﻿USE sofia;
DROP TABLE IF EXISTS sofia.uraNT_vpl;
CREATE TABLE uraNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uraNT_vpl WRITE;
INSERT INTO uraNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Caate Cana Coaunera Calaohi Jesocurisito foerateeurera Rabiri aina Abaraaun foeratenojoinuru foerateeurera curuaacurune. ");
INSERT INTO uraNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Isaca inaca neein nenaalu jetao Abaraaun. Jana Isaca calaohilu jetao Jacobo. Jana Jodaa aina rai nocoalacuru inaca neein nenaalu jetao Jacobo. ");
INSERT INTO uraNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Faresi aina Sara jetaote, Tamara que nebateein Jodaa bereecuru nelu. Jana Faresi calaohilu jetao Esroon. Jana Esroon calaohilu jetao Armi. ");
INSERT INTO uraNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Jana Armi calaohilu jetao Aminadaba. Jana Nasoon jetaote, Aminadaba calaohi nelu. Jana Salomoon jetaote, Nasoon calaohinelu. ");
INSERT INTO uraNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jana Raba que nebateein Salomoon calaohilu jetao Bosi. Jana Roto que nebateein Bosi calaohilu jetao Oberi. Jana Oberi calaohilu jetao Isaihasi. ");
INSERT INTO uraNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jana Isaihasi jetaote, reyneein nenaalu Rabiri inaca nelu. Jana Oriasi comasaineein nenaalu que nebateein, Rabiri calaohilu jetao Salomoon. ");
INSERT INTO uraNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jana Salomoon calaohilu jetao Roboam. Jana Roboam calaohilu jetao Abiasa. Jana Abiasa calaohilu jetao Asa. ");
INSERT INTO uraNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jana Asa calaohilu jetao Josafa. Jana Josafa calaohilu jetao Joraam. Jana Joraam calaohilu jetao Osiasi. ");
INSERT INTO uraNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jana Osiasi calaohilu jetao Jotaam. Jana Jotaam calaohilu jetao Acasi. Jana Acasi calaohilu jetao Esequiha. ");
INSERT INTO uraNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jana Esequiha calaohilu jetao Manasee. Jana Manasee calaohilu jetao Amoon. Jana Josiasi jetaote, Amoon calaohinelu. ");
INSERT INTO uraNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jana Jeconiasi aina rai nejeraauru inaca neein nenaalu jetao Josiasi. Nii bana jetaote, Isaraelitaauru mucuhin amanajaaurelu, acaauru atane caje roconajaain, Babilonia batane que ichaaoru coina. ");
INSERT INTO uraNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nitohaneein mucuhin amanajaauruhane baiha jetaote, rai calaohi Salatieli sirilu Jeconiasi. Salatieli calaohilu jetao Sorobaberi. ");
INSERT INTO uraNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jana Sorobaberi calaohilu jetao Abiod. Jana Abiod calaohilu jetao Eliaquiin. Jana Eliaquiin calaohilu jetao Asoro. ");
INSERT INTO uraNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jana Asoro calaohilu jetao Sadoco. Jana Sadoco calaohilu jetao Aquiin. Jana Aquiin calaohilu jetao Elioon. ");
INSERT INTO uraNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jana Elioon calaohilu jetao Eleasar. Jana Eleasar calaohilu jetao Mataan. Jana Mataan calaohilu jetao Jacobo. ");
INSERT INTO uraNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nii jana Jacobo jetaote, Curisito Mesihasi neba Mariha lana Jose inacanelu. ");
INSERT INTO uraNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nitohaneein jetaote, niha Abaraaunne caje coaauneein lechoonca jena saain nichoalateeurelu, Abaraaun nefoerateeuru, niha Rabirine que tiaaojoaain. Nii Rabiri caje coaauneein jetaote, lechoonca jena saain nefoerateeurelu, Babilonia batane Isaraelitaauru mucuhin amanajaauruhane que tiaaojoaain. Nii mucunajaain amanajaauruhane baiha jetaote, lechoonca jena saain nefoerateeurelu, nejanoaa Curisitone que tiaaojoaain. ");
INSERT INTO uraNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Naojoaainte nenaa nelu Jesocurisito. Nii bana jetaote Jose aina ita raauruhane rai niha Marihane jana jetaote, jaiti ita aina neeuruhane ajiniha Cana Coaunera Suujue ichanohineein inae ausirinelu Mariha. ");
INSERT INTO uraNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nii jana esinae rauhijiriin jeriha Cana Coaunerane rijijieein cacha caohachaain suujua coaaraniha Josene jaun jetaote, nii chuni cacha rai canaanai siriha Marihane belanaala jianeein caje amunaa jerelu. ");
INSERT INTO uraNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nitohaneein inae amuhane coina suujua cuhane coaauca Josene jana jetaote, sinihu rai ococohin jetao: “Jiaoriha Mariha raai ii comasainu quene coasiinera Rabiri nefoerateneein nenaa Jose. Nii canaanai niicha siriite Cana Coaunera Suujue ichanohineein nenaanera. ");
INSERT INTO uraNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Inae leinjiin calaohirichaain Marihara. Inae nejanoaa nii rai canaanaine jana Jesosoneein curuaateeura. Osa caje rai cachaneein neeninuuru ichoteraanu nihane jaunte, Jesosoneein curuaareeincha,” nae jetao rai Cana Coaunera letono anjera. ");
INSERT INTO uraNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nitohaneein jetaote, rai nere bera inoaensi profeta que: ");
INSERT INTO uraNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Chariji bana quicha aina ichoaelanaala nenaa ranunate, inae ausirineein leinjiin canaanai siricheein. Inae nejanoaane janate, Emanoel neein curuaateeurureein cachaaurura,” naain nere bera inoaensi que beratiha Cana Coaunerane nainaelu. “Emanoel,” naanete: “Cana Coaunerate cana aina ne,” nae. ");
INSERT INTO uraNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Inae niritiin sinihocane caje nocohin jetaote, nii rai aitoha Cana Coaunera letono anjerane tonoraain, comasainu que Mariha raelu Jose. ");
INSERT INTO uraNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nejetaote, nejanoaa nii Mariha calaohi- Jesoso neein Joseecha curuaatine reentiaain, nirijieein ita que turuelanaala ita aina ichaaorelu. ");
INSERT INTO uraNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nitohaneein jetaote, Jodea batane que nenaa Beleeun nejanoaelu Jesoso, jelai batane curuaanaaneein niha rey Erodesine bana. Nii jana jetaote, Jerosaleeun enoto mitu nichajai jeloon caje turuha uure itolere que nerelaain arasijieeuru caje cha coitucuureraauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Inae ecu turuhin jetaote: “Chu ne, nii Jorioocuru Curuaanaa rey nejanoanaa. Ocooca rai arasijiene coaracaanune jaunne turuhin coaraa uhacaanu, coroaecaanune coina,” naaure jetao turuhin, nii itolere coitucuurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nii nejanoaane coitucuhin jetaote, jataain nererojoecae rey Erodesi, satiin Jerosaleen cocoaichacuru aina jiniiquiin. ");
INSERT INTO uraNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nii jaun jetaote, satiin saseredotecuru curuaanaacuru, Moisesa aitonjoan rauhi que cacha relaaurera, naaonjoainuri cotiharate Erodesi: “Chu nejanoareein Mesihasi,” naain acaauru caje bajaane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nii jaun rene turuhin jetaote: “Jodea batane que nenaa Beleeunte nejanoareeincha. Nitohaneein ecu nejanoaane coinate: ");
INSERT INTO uraNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Jodaa atane que nenaa Beleen nese, coatiha ansijiin natiin ii amurijiriin tabaain nenacaauru neseeuru fautaain neriheeini, ii que netiin nejanoarihani leinjiin Curuaanaa canu cachaauru Isaraeli cocoaichacuru coroatajaneraneein nenaane jaaunra,’ naain laenaelu Cana Coaunera ere bera profeta inoaensicha,” naaure jetao Erodesi rai. ");
INSERT INTO uraNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nii jaun jetaote, nii chuni rai belanaala nii arasijie caje itolere coitucuurera cotiharatiha Erodesine jaun jetao, rai turuhin beeuruhane jaun acaauru caje esinae rauhijiriin, “Naaonjoain banate ococoelu,” naain nii ocooca arasijiene coitucue. ");
INSERT INTO uraNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Inae nitohaneein rai beeuruhane caje coitucuhin jetaote: “Chajaain Beleeun cuhin nii canaanai coaanihuche. Chucha ne. Cha cajecha nefoeratenaaneein ne. Chaen inae eruhichene carai biha uuchene canuhetonai coaraa uhene coroajera,” naain jetao nii itolere coitucuurera letoae Beleeun Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Niritiin acaauru letoaa reyne tonoraain Beleeun cuuruha nii itolere coitucuurerane jana jetaote, acaauru ajiniha cuujue nii arasijie- enoto mitu nichajai que ocoocane jana acaauruhacha coarai. Inae nii niha canaanaine jaaun turuhin jetaote, ecu nichoae inacue nii arasijie. ");
INSERT INTO uraNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Inae ecu inaauca nii arasijiene coaraain jetaote, jataain rachoojoeeure nii arasijie caje cha coitucuureraauru. ");
INSERT INTO uraNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nitohaneein rachoojoeeuruhane baiha loreri asae enohin coaracuruhane jana jetaote, neba Mariha aina niha nii canaanaine coaraain jetao, rohan nelauriaain nii canaanai coroaecuruhane baiha rai camela caje oro, enuha sacari jujui, chaen coretiin nenaa jujui, naaonjoainuri rocohin que nii canaanai belaihure. ");
INSERT INTO uraNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nii baiha jetaote, nii niha acaauru letoaera Erodesine jaan jeloon situhin cauha cuuruhane coataa acaauru sini anuu caje coitucuhin jetao, leeocha bero cuhane cuhin jelaiha nataneu cauha cuure. ");
INSERT INTO uraNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Inae jelai caje amuuruha nii itolere coitucuurera magocurune jana jetaote, Jose sinihu rai ococohin jetao: “Inae jetao nii canaanai ariha Erodesi sohin jaohane coina. Nii ajinihane ichei aitoon, nii canaanai aina rai neba amaain Egipto batane que cuhin sorohine coina. Chaen ichei bihanune reentiaain ecu neeura,” nae jetao rai Cana Coaunera letono anjera. ");
INSERT INTO uraNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","15","Nii jaun jetaote, sini caje nocohin nii canaanai aina rai neba amaain jetao, janotiin soroe Egipto nichae cunaa bero cuhane cuhin Jose, oha Erodesine reentiaain ecu nihane coina. Nitohaneein jetaote: “Egipto caje coaauneeinne canu Calaohi cotihareeunni,” naain beratihalu nere bera inoaensi profeta que Cana Coaunerane nainaane coina ailu. ");
INSERT INTO uraNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nitohaneein coritaain comarohin caauruha nii arasijie caje itolere coitucuurerane que nainaane jaun jetaote, jataain obajeein, ena nejanoanaa caje coaauneein, coroata jaanacai que tiaaojoaain, Beleeun sacuritaain nenacaauru canaanaihuru, nii Jesoso nejanoa beeuruha itolere coitucuurerane bana caje coaauneein nejanoanacaauru jitariin soaajerate Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Nitohaneein jetaote: “Rama nese quete aohanrareein jataain inaderaain chananaa tabaihuri. Raquerite calaohichuru coisiha aitoreein. Nete inae esinae rauhijiriin ooruha calaohichurune jaun, ajetera jerelanaala aite,” naain laenaalu profeta inoaensi Jeremihasine nainaelu. ");
INSERT INTO uraNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nejetaote, inae oha Erodesine baiha jetao, Egipto niha Josene jana sinihu rai ococohin jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Chajaain nii canaanai aina rai neba amaain jelaiha Isaraeli batane que caunihura. Inae ooruha nii canaanai sohin jaonaa jereraaurulura,” nae jetao rai Cana Coaunera letono anjera. ");
INSERT INTO uraNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nii jaun jetaote, nii canaanai aina rai neba amaain jelaiha Isaraeli batane que cauha cuelu Jose. ");
INSERT INTO uraNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nejetaote, nii rai inaca Erodesi coreeraniha niha Arquelaaone coitucueratiha sinihu que Cana Coaunerane caje coitucuhin jetao, Jodea cuhane coasiha Calileea batane que cue Jose. ");
INSERT INTO uraNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Inae nii Calileea batane que turuhin jetaote, rauhijiriin cuhin Nasarete neseu ichaoha cuelu. “Nasarete cocoaicha neeinte curuaareein Jesoso,” naain beeuruhalu profetacurune nainaane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nii bana jetaote, Jodea batane que nenaa cacha areroo ecocohin, ecu situnacaauru cachaauru cotijiaain acaauru rai Cana Coaunera Ere beebeje Joaan Baotisita. ");
INSERT INTO uraNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nitohaneein acaauru relaain jetaote: “Inae nichuuntaa Cana Coaunera cojoanonaa. Aihane jaun nacoaauneein Cana Coaunera ere tonoraain, caohachaain inara ichao coreein neeuche,” naain jetao cachaauru rai beebejeein relanajae Joaan Baotisita. ");
INSERT INTO uraNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nii Joaan que jetaote: “Nerichaain cacha areroo eheehejeein cacha cotiharanu. Nii ajiniha caohachaain inara suujua baaso jianeein, caohachaain inara suujua coaraain, caohachaain neeuche, turuha Cana Curuaanaane raotojeein raaichene coina,” naain laenaelu profeta inoaensi Isaihasi. ");
INSERT INTO uraNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Camecho ujui caje ichanohin cajione que cajionequiin jetaote, jacari caje ichanohin siitoroon que ichoraquiin, sisiincho, irichaje, naaonjoainuri que lenoneein nelu nii Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nii cacha areroo neein cachaauru relaa Joaanne coitucuhin jetaote, satiin Jodea batane caje, Jerosaleen caje, Jorodaan batane rohan caje, naaonjoainuri cajene maajeein turuhacoaain aonaa cuure arajii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nitohaneein rene turuhin esinae rauhijiriin suujuelanaala osaaocuruhane beeuruhane jetaote, cojunacatenaaca nucuhe Jorodaan cuhane teein acaauru baotisarejetelu Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nejetaote, jataain arajiin rene turuhacoaauruha acaauru baotisaane coina fariseeocuru aina sadoseeocurune coaraane jaun jetao: “Cha inara rai aite turu rai nenaa caseteco tabai caje nichoteeichene coinate taibinaecuru- acano rijijieein nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aihane jaun nii ajiniha caohachaain inara suujua coaraain caohachaain ichaaoche. Aihute esinae rauhijiriin nacoaauneein Cana Coaunera coitucuhin, inara ichao coreein caohachaain nenaa jerequichene coaracurumiin leeochaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jiaonrihachu chaen nejesinajeein: ‘Canacaanune Abaraaun nefoeratenichaanu,’ naain irihache. Cana Coaunerate naine caa ajeri caje niha natiin Abaraaun nefoerateeuru coaaunaa ne. ");
INSERT INTO uraNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chaen techu inaana inaeniha temulene, cojoaisi aina curuataain tero que sauhin usihanau mocohaca. Nii rijijieeinte inae esenetaaichuru letoaa cureein nii turuha uhenenu usi tabai jana. ");
INSERT INTO uraNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Canune esinae rauhijiriin nacoaauneein Cana Coaunera ere tonoraain neeichene coarateeichene coujunacane que, acauhanau teein inara coujunacateein inara baotisaaun. Jana canu baiha turuha uhenite laen, inara suujue cuhane Cana Coaunera Suujue teein, usi quene maajeein inara coujunacateein inara baotisareein. Acate jataain canu amurijiriin cocoainaain letononeein ne. Canune fautaain cocoainaain letononeein neeun. Nii rai safato amaeranu que niha natiin nelatejeehaaun. ");
INSERT INTO uraNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Charijieein teeinti aroso taojiaain, jelai teein rai fero taojiae mocohane coina taicha. Nii rijieeinte, jelai teein coitucuurera raain, jana nii nere tonorana jerelanaala nenacaauru jelai teein mocoha cureein, chabana jacanaa charanejeein nenaa usi que,” naain jetao cachaauru rai beebeje nii Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nii jana jetaote, baotisaa Joaanne coina Calileea caje cuhin, nii niha Joaanne jaaun nucuhe Jorodaaun turuha cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nii jana jetaote, jauriaanejeein baotisanaa jerelanaala jetao: “Chanuna ii canu baotisanaa naineei natiin, ii canu rene uhi,” naa Joaanne jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","“Jauriaa niriimiin ena. Jauriaanejeein satiin aitoha Cana Coaunerane jaan ichacaanete caohachae,” nae jetao Joaan rai Jesoso. Niritoha raine jaun jetaote, jerihane rijijieein baotisae Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nitohaneein coujunacatiha acauhanau teein baotisaa Joaanne jana, acau caje mituha Jesosone rijieeoritiin jetaote, nejoracaa dede bacuujuane jana, leinjiin serori rijijieein nichoae fauha uha Cana Coaunera Suujuene jana coarae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nii jana jetaote: “Caate jataain quiicha belaain canuhacha cocoainanohin canu Calaohi nera,” naain toniha erenaa dedeeune jana aonajeeunre. ");
INSERT INTO uraNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nii baotisaa Joaanne baiha jetaote, Cana Coaunera Suujue amanojoineein cacha areroo cue Jesoso, ecu coujuhin coaraa moconajaerane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nitohaneein cacha areroo niha jenachoonca jiichooneein, jenachoonca janotiineein lenone lanaalane baiha mijiitoha Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","coujuhin coaraane coina rene turuha cue moconajaera. Nitohaneein rene turuhin jetaote: “Chajaain aihane esinae rauhijiriin Cana Coaunera Calaohi neeine, caa ajeri jaberocooru rai aitoote lenoneneein nerotomiincha,” naa Jesoso rai moconajaerane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","“Nete Quiricha inoaensi cuhane: ‘Coatiha lenoneecha que ichaonaa nainihei cacha. Cana Coaunera ere tonoraain, jerihane rijijieein ichaohanete nainere, jerichanejeein ichaoha cachane,’ naain laenanohineein ne Cana Coaunera Quiricha inoaensi cuhanera,” nae jetao moconajaera rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Niritoha raine baiha jetaote, Cana Coauneraacha que banijiaain nenaa Jerosaleeun nese que nenaa Teenforo ecuunni choae Jesoso inaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Chajaain aihane esinae rauhijiriin Cana Coaunera Calaohi neeine caalai caje nomaroteeute coaracaa. Cana Coaunera Quiricha inoaensi cuhanete: ‘Rai letonocuru anjeraaurute letoareein Cana Coaunera, ii beraaihuruhane coina. Acaaurute rai biji que ii michuurureein, nabana ajeri que necunaitaaine coataa,’ naain laenaerate Cana Coaunera,” naa rai moconajaerane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","“Chaen techu Cana Coaunera Quiricha inoaensi cuhane: ‘Jiaonriha ii Curuaanaa ii Coaunera coujuhin coaraaine,’ naain laenanohineein ne,” nae jetao moconajaera rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satononejeein jetaote, jataain ecuuneein nenaa ichatane ucuuno que amaain jetao, jitariin caa chauratane que nenacaauru neseeuru coaarateein, que nelateein ichaonacaaurune maajeein coaarateein jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Jitariin caa ena iicha coaraine ichei tereeuni, neseeonriaain canu coroaequine,” naa Jesoso rai moconajaerane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","“Cana Coaunera Quiricha inoaensi cuhanete: ‘Leinjiin ii Curuaanaa ii Coaunera coroajeein raaicha nelateein rai nere tonoraau,’ naain laenanohineein nera. Chajaain ena canu caje amuhachaaura moconajaera,” naain jetao moconajaera sitae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Niritiin moconajaera sitaa Jesosone jaaun caje amuhane jana jetaote, rene turuhacoaain coroatajanecure anjeraauru. ");
INSERT INTO uraNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Caresero cuhane Joaan enoaauruhane coitucuuriin jetaote, Calileea nichae cuelu Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nejetaote, Nasarete ichoaelanaala, Saboloon aina Nefatalii nefoerateeuru atane que nenaa nemuri auhaniha Caferenaaon ichaoha cuelu. ");
INSERT INTO uraNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nitohaneein jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Cucuana auhaniha Jorodaan jerau Saboloon aina Nefatalii atane- Calileea ichaonacaauru Jorioniheichurute inae jianacoon rai nichao baaso caje mituurureein. ");
INSERT INTO uraNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jana nii ooruhane bana nitajeeneeurite, inae leeocha ichaonaa que ichaaore,” naain laenaalu profeta inoaensi Isaihasine nainaelu. ");
INSERT INTO uraNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nii caje coaauneein jetaote: “Inae nichuuntaa Cana Coaunera cojoanonaa. Aihane jaun nacoaauneein Cana Coaunera coitucuhin, caohachaain inara suujua coaraain, caohachaain neeuche,” naain jetao cachaauru rai beebejeein acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nii cachaauru relaane caje Calileea conemuri auhaniha cuujihane jaun jetaote, coroatajai ita nejeraauru Simoon Fedoro neein acaauruhacha curuaatei, chaen rai nejera Aanderesi, naaonjoainuri erue jetao Jesoso, acaauru amihaneeo niha ate mucuuruhane jaun, ate mucuuruhane coina acauhanau rai rede nalaecuruhane jana. ");
INSERT INTO uraNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nii jana acaauru coaariin jetaote: “Chajaauche canu ainate nii ate mucuhichene rijijieein, canu rai cachaauru mucuhin raeraneein neeiche,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nii rijieeoritiin jetaote, acaauru rai redeeuru ratiriin Jesoso aina cuure. ");
INSERT INTO uraNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nii caje basiinjiin cutiin jetaote, coroatajai ita nejeraauru Sebedeeo calaohichuru Saantiaao, Joaan, naaonjoainuri coaari Jesoso, leinjiin bote cuhane neein acaauru rai redeeuru rucuheca neeuruha rai inaca ainane jana. Nitohaneein coaarinajaain cotihanaaca Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nii rijieeoritiin bote cuhane acaauru inaca ratiriin caaijie cuure. ");
INSERT INTO uraNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nitohaneein cuhin jetaote, Calileea sacuritaain cuhecujueein, sinacocaauru naineein enohenojoeein cachaauru relaain, Cana Coaunera cojoanonaa erenaa raotono que ereerejeein, itolere cunai caaun cunaitenacaauru, jaberoco que cunainojoiriin nenacaauru, naaonjoainurine maajeein rautaacoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nii jana jetaote, satiin Siria batane sacuritaain inae Jesoso benaa coitucuhin jetao, araai laurii cunai caaun cunaitenacaauru, jaberoco que cunanacaauru, coitucuchuhi que suujueconacaauru, otonacaauru, bacosacuru, naaonjoainurine maajeein rene amaauruhane jana jetao, acaauru rautaacoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nitohaneein jetaote, Calileea nenacaauru neseeuru, Decapolis, Jerosaleen, Jodea, Jorodaan batene uurihuru, naaonjoainuri cajeeeurune maajeein cuhacoaain jetao, Jesoso sacuhin rene turuhacoaaure arajii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Arajiin rene turuuruha cachaaurune coaraane jaun jetaote, aina nerelanacaauru aina jiniiquiin ichatane ucuuno que iniin jetao, ecu nelauriariin lauheque Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nitohaneein ecu netiin acaauru relaain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nerausiaaecuruha latiha acaauru suujuane coitucuhin nenacaauru, Cana Coaunera Cojoanonaa que neeuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nerausiaaecuruha inaderaaeriin ichaonacaauru. Niichurute cairichaaojoaain coarae Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nerausiaaecuruha leeochaauru amurijiriin nenaa coacuelanaala raotojoeein ichaonacaauru. Niichuru raite, acaauru que banihateein niicha rucujuei atane tereein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nerausiaaecuruha corajeein esinae rauhijiriin jeriha Cana Coaunerane rijijieein leeochaneein namute cacha coaraelanaala, niheichu namute cacha cairichanaa coacuhin niha leeochane jerelanaala, naaonjoaain caohateraneein nenacaauru niicha coaana jerei coaracururichaaine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nerausiaaecuruha cairichaaojoaain leeochaauru coaraain, chaelai lateein neeuruhane, acaauru coroatajaneein naaonjoaain nenacaauru. Nii rijijieeinte cairichaaojoaain acaauru coaraain, jeelai amuritoheriin acaauru coroatajanereein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nerausiaaecuruha caohachaain suujua coaraain caohachaain ichaonacaauru. Niichurute esinae rauhijiriin Cana Coaunera aina jiniiquiin niha cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nerausiaaecuruha raotojoeein jiniiquiin ichaaoruha cachaaurune coina coroatajaneein ichaonacaauru. Niichurute rai calaohineein teein acaauru coaareein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nerausiaaecuruha Cana Coauneraacha jerei ichacuruhane coreniha mucunojoineein, casetecanojoineein, arinojoineein, naaonjoaain nenacaauru, Cana Coaunera cojoanonaa que neeuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nerausiajeeinte neeiche canu cachaneein neeichene coreniha inara nocoeje chanuhin, inara sohin, joaereein inara que ereein, naaonjoaan cachane. ");
INSERT INTO uraNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nitohaneein techu cairichaerinojoineein rautanohinelanaala ichaaorelu Cana Coaunera ere bera inoaensihuru profetacuru, inara ajiniha nenacaaurulu. Aihana jaun raotojoeein rachoojoeein, chaque tonajelanaala neeuche, dedeeu raoti ichaonaa que inara coreterihani Cana Coaunerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Charijieein teeinti setuhane coataa, tebe que iniho colaain rucuhecaa. Nii rijijieeinte nabana nitajeeuruha cachaaurune coataa, acaauru ichao baaso rucuheraneein neeiche. Inae lenone cotebetenaa naineniha tebene, inae lenone raotono tenaa nainerihei. Nechu joaaenreen atane ichoae jaonojoineein, shaonohineein nihane coinaachate nelate. Nii rijijieein inara netonai, cacha rai ichaonaa raotono coaaratelanaala cacha relaeneeichene, inara netonai nii chaque nelatelanaala neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ichatane ucuuno que niha leinjiin nesene, nihei chuni coaraelanaala nainejei. Nii rijijieein techu satiin cacha notaracaae inara aina cuaain niicha jerei coaaratiha Cana Coaunerane jaan- cono rijijieein neeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nii rijijieein nihei chuni cono mocohin darohe asae tera. Bujuaihu telanaalate ucuun tihaca, satiin conohanau turuuruha loreri asae turunacaaurune coina. ");
INSERT INTO uraNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nii rijijieein cacha cononeein satiin cachaauru que caohacha ichaquichene coaarateein, acaauru que coitucuerateein neeuche. Aihute esinae rauhijiriin caohacha ichaquichene coaraain Cana Coaunera coroaecuruhine cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Coatiha inara relaain nihalu Moisesane jaan rauhi jianeein neeichene coina, cau turuhin nihaaun. Nihieichu inara relaauruha profetacurune jaan jianequichene coina turuhaaun. Nenacaaen nejian, nii inara relaauruhane jaan coitucuhiche esinae rauhijiriin jeelai amuritoheriine coina, ‘Naaonjoain quete aite,’ naain inara rai biha uun. ");
INSERT INTO uraNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Esinae rauhijiriine inara rai aitoreeunni, jaiti niha dede, chauratane, naaonjoainurine que tiaaojoaain, coatiha aninoaerarinaai le erenaanejeein, satiin nii aitohane rijijieein situhane reentiaain, nii Cana Coaunera tenojoin Rauhi Inoaensi. ");
INSERT INTO uraNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nitohanihane jaun nii rauhi inoaensi caje leinjiin leeochaauru fautaain nelatihei rijijieein nenaa rauhi tonoraelanaala nenaa, niheichu que leeochaauru relaenihane, acate Cana Coaunera Cojoanonaa que jataain nelatenereein. Nete caohachaain tonoraain, nii aitoha Cana Coaunerane rijijieein ichaohin, esinae rauhijiriin leeochaauru relaerate, jataain nelatineein nereein Cana Coaunera Cojoanonaa que. ");
INSERT INTO uraNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Rauhijiriine inara rai aitoreeunni, Moisesa aitoonjoan rauhi que cacha relaaurera aina fariseeocuru amurijiriin, inara rai Cana Coaunera aitoonjoan tonoraain rijijieein niicha icharatei ichaeneeichene, coatiha Cana Coaunera Cojoanonaa que ichaonaa naineriheicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Inarate coitucuhiche: ‘Jiaoriha sonajaain jaohichene. Sonajaain joaerate caseteco coaareein,’ naauruha inara foerateeurera rai ne. ");
INSERT INTO uraNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nena laen canu inara rai aitoon. Chunocoha namute cacha aina obajei, nii obaecane jaan jera aina rucujueein que suujua acatelanaala nenaate, caseteconeein niha cureein. Jana rai nejera que ‘Cha coitucuheei,’ naain ereite, casetecaeratereein nitohanai rucuhecuruhane coina nenacaauru- Junta Supremacuru. Jana, ‘Chaque nelatiheei inacojoeeinte neei,’ naain namute cachaauru que ereite, usi tabai jana nijiaoreein. ");
INSERT INTO uraNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aihana jaun ii que suujua acatiha Cana Coaunerane coina chaelai amaai que belaaine coina Teenforo asae nenaa rori- altar ichoaene jana, ii cotaairiin niha chamute cachane que coaauquine, ");
INSERT INTO uraNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jauriaanejeein caohachaain neein ii cotaairicha ainane coina, nii rori acatiha nii iicha amai ratiriin, aina rucuhenihu. Inae aina caohachaain rucuhequine baihate laen nainereei jelaiha cuhin nii rori- altar ichoae nii Cana Coaunera belaaine jaan teeine. ");
INSERT INTO uraNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Chunocoha inara amute cacha, cocoainanacaaihuru rai inara coulurujeein nihane, raotojoeein aina ereein rucuhecuche, joesio rai inara colurujihane coataa. Aineeichenete folisiaa rai inara tiha joesione, caresero cuhane inara enoaaurureein. ");
INSERT INTO uraNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nitohaneein ichaeneeichenete nii caresero cuhane neriquicheein mituhelanaala, nii baaso ichaquichene coretequichene reentiaain. Esinae rauhijiriine aitoon inara rai. ");
INSERT INTO uraNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Inarate: ‘Jiaonriha inara sinijeranelanaala nenaa ene dadaaichene,’ naain inoaenlu inara relaauruhalune coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Esinae rauhijiriine laen canu inara rai aitoon. Chunocoha suujua cuhane ene jereein coaarate, suujua cuhane nejelau ene que naosate. ");
INSERT INTO uraNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Inara nota osa que inara sarunaa jerihane nii inara nota que coaraain, inaraacha jerei caje amuuche, nabana inara nota coreniha baaso ichaquichene, inara notaacha usi jana cuelanaala, satiin inara jaberoco usi jana nitajihane coataa. ");
INSERT INTO uraNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jana inara biji osa que inara sarunaa jerihane, coa nii inara biji turuaache nii inara sarueratenaa jerihane jaan que. Mucuhichene ajiniha caje amuuche. Nii inara bijiicha mocoelanaala, inara jaberocone maajeein usi tabai jana nitajihane coataa. ");
INSERT INTO uraNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Chaen techu inoaenlu: ‘Chunocoha comasai joaeranihane, nii comasai jaohane jaan cocoiricha teeuche raite aina comasai jaohine,’ naain inara relaaurelu. ");
INSERT INTO uraNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Esinae rauhijiriine laen canu inara rai aitoon. Leeocha cacha aina ichoaenihane jana comasai joaerate, inae osa que nesarue. Jana nii quicha jaonojoin ene raerate, jerichanejeein osa que nesarue. ");
INSERT INTO uraNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Chaen techu inara inoaensihuru rai: ‘Jiaonriha Cana Coaunera notaracae netiin, Cana Coaunera bajaain, rai chaelai benatequichene nihanatiin teneeichene,’ naauruhane coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Esinae rauhijiriine canu inara rai aitoon. Jiaonriha joaereein inacojoeein: ‘Cana Coaunera coreniha,’ naain ereeichene. Niheichu: ‘Dede coreniha,’ naain erenaa nainiheeiche, Cana Coaunera nelaurianaja niha dedene jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Niheichu atane coreniha nihanatiin nainiheeiche, nichaauraa Cana Coaunerane jaan nihane jaun. Niheichu Jerosaleen coreniha nihanatiin, Cana Coaunera nese nihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Niheichu inara couturi coreniha chaelai ichaquichene coina erenaa nainiheeiche, inara jerequichene que jichosiin, nesomaraain, naaonjoaain nenerihani inara coturijine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Chaelai que: ‘Icharihanuhin,’ naaichene ichacuche. Jana: ‘Icharihaauni,’ naaichene coa ichacache. Nelatihei cha ichaeraanu rijitiin nohaneein irihacane. Niite baaso ne. ");
INSERT INTO uraNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Inarate inoaenlu: ‘Chatohaneein inara soeraniha inara cunaitaaine, inara netonai cunaitaain nii inara soera sooche,’ naauruhane coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Esinae rauhijiriine canu inara rai aitoon. Jiaonriha chatohaneein baasoneein teraquichene neurinanaa coaauquichene. Aihane jaun inara meri faohitoroanihane, rai jera netonai icharatecuche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chunocoha cocoainanacai rai inara colurujueein inara obiri ruluhane, nii jelaronaa bana inaraacha jiai inara obirine maajeein teeuche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Inara que anajiin amaeratiha cocoainanacai, inara laurinelanaala nenaane, nii bajaane amuritoheriin amanaa nainequichene coaarateein amaauche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Inara caje niicha latei bajaain niha cachane, rai teeuche. Jana inara rai cainaane coina chaaelai bajaain niha cachane, chunaelanaa rai niicha latei teeuche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Chaen techu inoaenlu: ‘Inara belaichaauru belaain, inara cotaihurera cotaihuche,’ naauruha inara raine coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nena laen canu inara rai aitoon. Inara que nejeratenacaauru belaihuche. Inara rerohecaera rai Cana Coaunera bajaauche. ");
INSERT INTO uraNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nitohaneein neeichenete, dedeeu nenaa Cana Inaca Cana Coaunera calaohineein neriquicheein. Acate enoto coaaunae, cojoanoonetojoeein nechu aansaineein nenacaauru rai, caohachaain nenacaauru rai, naaonjoainuri conaeranu que nihane coina. Chaen techu suujua coaraelanaala nenacaauru rai, suujua coaraain nenacaauru rai, naaonjoainuri rai elo letoae acaauru rai caohachanu que. ");
INSERT INTO uraNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jana acaihaniji inara belaichaauruhacha belaaichene, chatohanai que jana inara belaiche Cana Coaunera, inae cuu tihane bana. Coaracuche nachuhinti Roma curuaanaa rai impoestonu que coriqui bajaaurera netonai jataain nechu aansaineein neeuruha natiin, nitohaneein ichaaoruhane. ");
INSERT INTO uraNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jana inara belaichaauruhacha rai raotojoeein ereein, leeochaauru aina raotojoeein erelanaala, naaonjoaain neeichene, chatohaneeinna jana esinae rauhijiriin inara ichao coreein neeichene coaracurure cachaauru, Cana Coaunera coitucuuruhi nihanatiinte, inara rijijieein neeure. ");
INSERT INTO uraNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aihana jaun caohachaain rauhijiriin neeuche, aiha Cana Coaunerane rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jiaonriha nechu raujiaain inara coaracuruha cachaaurune coinaacha cacha notaracaae Cana Coaunera jerenohin ichaquichene. Nitohaneein neeichene coatiha chaque inara rai cainarinaain Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aihana jaun cha lateein nenacaauru coroatajanequichene, jiaonriha itolereneein cachaauru rai beein acaauru coroatajanequichene. Cana Coaunera coitucutoha nocoetonacaaurute cacha notaracaae, nechu jataain acaauru aina caohachaain niha cachane coina, Sinacoca asaae, bero cuhane, naaonjoaain cacha belaihure. Jiaonriha acaauru rijijieein ichaquichene. Acaaurute nechu jataain aihure, acaauruhacha esenetaain, caohachaain acaauru coaraa cachane coina. Nete inae caohachaain acaauru coaracuruha cachaaurune que inae cainanohine acaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aihana jaun inara, cairichaihuru coroatajaniha cha teeichene, jiaonriha jataain inaraacha belaai rai niha natiin beeichene. ");
INSERT INTO uraNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nitohaneein esinae chuni que coaaratelanaala teeichene coaraanete, inara rai cainareein cana Inaca Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Cana Coaunera bajaaichene, coa bajaauruha Cana Coaunera coitucutoha nocoetonacaaurune rijijieein bajaache. Acaaurute sinacoca asaae, joaereein bero cuhane, naaonjoaainu neeichuru Cana Coaunera bajaaure, nechu jataain caohacha ichaa nocoetiin aihuruhane coaracuruha cachaaurune coina. Nete nii coaracuruha cachaaurune coina aihuruhaneecha que, inae cainanohine acaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nete laen ii Cana Coaunera bajanaa jereeine, caohacha jelai netiin coaraeniha chunine jana, bujuaihu ucuha cuhane netiin ii Inaca Cana Coaunera bajaaine caohachae. Nitohaneein chuni que necoharaeratelanaala netiin bajaaichene coaraanete, inara rai inaraacha bajai tereein ii Inaca Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Cana Coaunera bajaaichene, coa acaauru rai ecaantocuru bajaae bajaaecuruha araai saain Cana Coaunera coitucuhichurune rijijieein joaenreen ereerejeein bajaache. ");
INSERT INTO uraNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aihana jaun jiaonriha acaauru rijijieein neeiche inarane. Cana Coaunerate, caje bajaaichene ajiniha inara suujua cuhane inaraacha latei latequichene coitucue. ");
INSERT INTO uraNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Aihane jaun Cana Coaunera bajaaichene: ‘Satiin canacaanu Inacaneein dedeeu nenaa Ofa, Iineein neeine coitucuurumiin satiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Turuhine Ii Cojoanonaa. Caa chauratane que iicha jerei ichacurumiin, dedeeu ichacuruhane rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cojoanoonetojoeein canacaanu rai lenone ocoteeu. ");
INSERT INTO uraNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Baaso ichacaaunne, canacaanu que ii suujua acateeu, canacaanu rai baaso icharaauru que, canacaanu suujua acatichaanune rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jiaonriha osa que nesaruhin nihacaanune nainatejeein neeine. Canacaanu caje moconajaera sitaau. Inae,’ naain Cana Coaunera bajaauche. ");
INSERT INTO uraNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Inara rai baaso icharaauru que, inara suujua acateein, acaauru aina caohachaain neeichenete, Cana Coaunera netonai inara que suujua acatena nainereein. ");
INSERT INTO uraNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jana inara rai baaso ichaain neeuruha leeochaaurune jana, acaauru que inara suujua acateneeichene, Cana Coaunera netonai inara osa que suujua acatenereein. ");
INSERT INTO uraNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Inara suri couu netiin Cana Coaunera bajaaichene, jiaonriha aihuruha Cana Coaunera coitucutoha nocoetonacaaurune rijijieein, nechu inara suri couu neeichene coaracuruha cachaaurune coina coa cunaitenaa meri tocohaneein inara meri tihache. Inae nitohaneein ichacuruhane coaraain acaauru belaichuruha cachaaurunete, nii acaauru belaichuruhaneecha que inae cainanohi ne acaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jana inara, inara suri couu netiin Cana Coaunera bajaaichene, inara meri culejeein neruujueein raotojoeein bajaauche, ");
INSERT INTO uraNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","inara suri couu netiin Cana Coaunera bajaaichene que nainacuruha cachaaurune coataa. Nii banate laen leinjiin Cana Coauneraacha inara belaicheein, inara suri couu netiin bajaaichene coreniha. ");
INSERT INTO uraNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Coa caa chauratane que raotiin nenaa coacuhin, coriquihona neein itolere rucuhele sirina coaacuhin nihache, inara rai cojoanojoiin nitajeein, basijiaaurureein asijiautooru, naaonjoanrichaaine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Caa chauratane que caohachaain nenaa coacuhin mainajeein amihaneein coriqui taaojiaaichene jianeein, nii aaichene rijijieein mainajeein Cana Coaunera rai itolere caohachanu ichana que amihaneeuchete dedeeu inara rai cainanohinemii. Nii dedeeu laen asijiatooru nihanatiin turuhin inara basijiauna nainerinaain. Niheichu cojoano, ecu enohin aasaena nainerinaain. ");
INSERT INTO uraNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nitohanihane jaun jauriaanejeein caohatiin coaaucuche, inara ichao rai inaraacha ichanenu que. Inara ichao rai jataain nelateineein niha coriquine esenetaaichene acaacha ichacuche. Jana inara ichao rai nelateineein niha Cana Coauneraacha icharatenohine esenetaaichene acaacha ichacuche. ");
INSERT INTO uraNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Inara notate inara suujua que itolere inaraacha coarai coitucueratera ne. Aihana jaun inara nota que inaraacha coarai coitucuhin, ichaquichene caohatiha inara suujuane tonoraai ichaeneeichenete jianacoon neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jana inara nota que baasonihane coaraquichene saijieein, inara suujua nii baaso ichaquichene jerihane rijitojoeein baaso ichaquichenete, nocohenaanau nijiaonreein inara suujue. ");
INSERT INTO uraNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nihei chuni coroatajai curuaana letononeein nenaa nainei. Leinjiin belaain acaacha ere tonoraain, nii leeocha que jaolequiin nere tonoraenerihane jaun. Nii rijijieeinte Cana Coaunera sacunaa nainene cacha, coriquiicha que coacuhin nihane. ");
INSERT INTO uraNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nitohanihane jaunne inara rai aitoon. Coa lenoneein acau cohin ichaohichene jaanu, inara cajione, naaonjoain que nererojoecaaeriin nihache. Tana lenone amurijiriin nelatiha inara ichaone jana, cajione amurijiriin nelatiha inara jaberocone coitucuhin neeichene. ");
INSERT INTO uraNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Coaracuche nachuhinti temule jaain niicha quiineeuri taojiaain rucuhecuruhane jaanu coloheri siriin naaonjoaain neeururiha tajaaecuru. Nete laen cana Inaca Cana Coaunera, lenoneein ichaaoruhane coina acaauruhacha quiine teein ne. Inarate nii tajaaecuru amurijiriin jataain nelateein neeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Inaaonjoan saneein niha natiin itolereneein suujua cuhane coaauca cachane niha natiin, nichao cariaain ichaonaa nainihei. ");
INSERT INTO uraNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Chanuna inara cajione que nererojoecaaeriin neeiche. Coaracuche nachuhinti ajenacuru niicha jiaaenine que nichanaa ichaain, amihaneein, naaonjoaane que airijiin omarohin, jataain caohatonanaain ujuaneein naaonjoaain neeuruhane. ");
INSERT INTO uraNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jana rey Salomoon, coatiha nii aihuruha ajenacurune rijijieein niheilu, caohati cajione que necoreeteein nihalune saijieein. ");
INSERT INTO uraNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tana mocohin nitajerai niha ajaenane saijieein, caohachaain omarohin nihane jaanu teein niha Cana Coaunerane coitucuhichene. Chanuna jana chaen, nii amuritoheriin inara cajioneterichaain Cana Coaunerane esenetaeneeichete, cha esenetana jeriheichuru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nitohanihane jaun nainiheeiche: ‘Chaaque lenoneeinna acau cohin, necoreeteein, naaonjoaain nerichaache,’ naain que nererojoecaain nenaa nainiheeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Cana Coaunera coitucuhichurute, niicha que nererojoecaain niicha sacunaa jere. Nete laen Cana Coaunera inaraacha latei latequichene coitucue. ");
INSERT INTO uraNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aihana jaun Cana Coaunera Cojoanonaacha que coacuhin, jeriha Cana Coaunerane rijijieein ichaohin, niicha jereeicha ichaechajeein neeichenete, satiin caa inara rai aitocoaaunne jaan tereein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jiaonriha eresi inaraacha ichaneni que coacuhin nererojoecaaichene. Le janonaa bana naineein, canaacha ichaneni que coaaucaachenete caohachae. ");
INSERT INTO uraNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Coa leeochaauru ichao coaraain coulurujueein nihache. Nabana nii leeochaauru colurujueeichene rijijieein, inara coulurujiha Cana Coaunerane coataa. Nii leeochaauru coaraain neeichene rijijieeinte inara netonai coaareein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chanuna aansijiin laaojoiri ichaain baaso ichacuruha leeochaaurune coaraain, acaauru que ereein neeiche, inara, acaauru amurijiriin jataain baaso ichaain ichaohichene saijieein. ");
INSERT INTO uraNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Inasiina jataain amurijiriin leinjiin enuha jaberoco que funojoi niha ii notane saijieein, ‘Jereeune ii nota que nenaa utoone rocoe,’ naain erenaa nainereei inejera rai. ");
INSERT INTO uraNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Cha coitucuha nocoetohine saijieein cha coitucuhi. Jauriaanejeein nii ii nota fuera enuha jaberoco rocohin jaaote, caohatiin coaraain nii inejera nota que nenaa utoone coaraain rocohi. ");
INSERT INTO uraNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Coa remaaecuru rijijieein nenacaauru rai, inara que banijiaain Cana Coaunera tenojoin tihache. Nabana inara coineteein inara cunaitaauruhane coataa. Niheichu coosi rijijieein nenacaauru rai, inara rai nelateein nenaa nii Cana Coauneraacha tei tenaa nainiheeiche, que jaolequiin chaque nelatihei rijijieein coaracuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Cana Coaunera caje cha lateein bajaaichenete, inara rai inaraacha latei tereein. Cha lateein ariin bajaera raite, cha teein ne Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nii rijijieein techu lateein rene cuha cachane, rae Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Coaracuche nachuhinti inara caje lenone bajaa inara calaohine, rai ajeri telanaala lenone caohacha teeichene. ");
INSERT INTO uraNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ainihane inara caje ate bajaane, rai acano telanaala rai iniho caohacha teeichene. Nii amuritoheriinte, cha lateein caje bajaa cachane rai caohacha teein ne Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Coaracuche nachuhinti inara netonai baasoneein inara suujua coaraain ichaaohichene saijieein, cha bajaain niha inara calaohichurune, cha caohacha teein naaonjoaain neeichene. Nii amuritoheriinte cha caohacha teein nereein inara rai Cana Coaunera, caje cha lateein bajaaichene. ");
INSERT INTO uraNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nitohanihane jaun inara aina caohachaain neeuruha leeochaaurune jeriquichene rijijieein, leeochaauru aina caohachaain neeuche. Nitohaneein ichoai coinate aite nii rauhi aina profetacuru inoaensihuru laenanojoi. Aitoha nii rauhine rijijieein ichaoha cachane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Nii jaratoelanaala nenaa coero aina acuujua siricha jeloon enooche. Nii cacha ichao itajeranu que nenaa bacuujua aina rai coerote, jaraaotohane jaun cuhane cuhin arajiin nitajeeure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jana ichaonaa chabana nitajenaachara nejeein nenaa rene cacha turuaera bacuujua aina rai coerote, aansijin jaratohelanaala. Nii jaunte caaintatoha ecu turuha cachane jaun, coroatajajeeincha turuujue cacha. ");
INSERT INTO uraNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Caohachaain necohalajiin neeuche, nii Cana Coaunera coitucuha nocoetiinchuru erenacaauru casajeeuru que. Acaaurute turuurureein nii Cana Coaunera coitucuurera tocorijianeeichuru inara rene. Nete acaauru suujua cuhane, inara ichao itajeranu baaso uhaain inara rene turuurureein. ");
INSERT INTO uraNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Inarate nainequiche coitucunajaaiche acaauru ichao cajene. Coatiha inoeri que inaana nainihei ojoa, niheichu meseri que inaana nainihei acusa. Nii rijijieeinte cacha baaso caje ocoona nainene ichaonaa caohacha. ");
INSERT INTO uraNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nii rijijieein techu satiin temule caohacha, caohacha que inacae. Jana enuha baasote, jerichanejeein baaso que inacae. ");
INSERT INTO uraNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Satiin temule caohacha baaso que inaana nainihei. Jerichanejeeinchu caohacha que inaana nainihei enuha baaso. ");
INSERT INTO uraNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Satiin enuha baasooru- baaso que inaanacaaurute, inae sauhin moconojoiniha cureein. ");
INSERT INTO uraNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nii rijijieein techu acaauru ichao caje cacha caohachaneein, cacha baasoneein, naaonjoaain ichaaoruhane coitucuriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Coatiha satiin canu rai: ‘Canu Curuaanaa,’ naain erenacaauru, Cana Coaunera Cojoanonaa que turuhin ichaonaa nainecururinaain. Canu Inaca Cana Coaunera jerenohin icharate laen, nainereein rai Cojoanonaa que ichaoha ne. ");
INSERT INTO uraNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Inae nii cojoanonaa que turuhane banate, arajiin cachaauru nesoone caaun: ‘Curuaanaa, Curuaanaa, canacaanune ii coitucuuruha cachaaurune coina, ii que ereerejetocoaanu, ii curuaa corenihane moconajaera letonocuru sitaain, arajii cojoelanaacojoai ichacaanulu,’ ");
INSERT INTO uraNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","naauruha canu raine janane: ‘Coatiha inara coitucuhaaun, naain cacaje amuuche baaso ichajeein ichaonacaauru,’ naain acaauru sitareeunni. ");
INSERT INTO uraNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nitohanihane jaun canu ere aonaain caintoonjoan icharate, leinjiin cacha jataain nainaain niicha ichai coitucuhi nenaa, enuha suujui caohacha que banesijiateein, ucuacaain temuhin neloheritihane jana, ");
INSERT INTO uraNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","uha elone jaun tabaacoaa nucuhecuru aina uha cujuana tabaine jana, nii loreri inasine, enuha caohacha suujui que banesijiateein ucuacaain temuhin ichaa nii icharane jaun. Nii rijiicha canu ere aonaain caitoonjoa ichara cacha. ");
INSERT INTO uraNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jana canu ere aohanra nii caintoonjoa ichaelanaala baaso ichajeein ichaonaate, leinjiin cacha aaso erenaa tonoraai, enuha suujui baaso que banesijiateein, araracaaeriin temuhin neloheritihane jana, ");
INSERT INTO uraNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","uha elone jaun tabaacoaa nucuhecuru aina uha cujuana tabaine jaun comohin nerataneein nitaje nii loreri. Nii rijiicha canu ere aonaane saijieein caitoonjoan tonoraain ichaelanaala nenaa cacha,” naain jetao cachaauru rai ereereje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Niritiin acaauru rai beebejiha Jesosone jana jetaote, jataain cojoelatoore satiin cachaauru, ");
INSERT INTO uraNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Moisesa aitoonjoan rauhi que acaauru relaaurera amurijiriin, esinae rauhijiriin suujua caje coitucuhin aitohane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Inae nii cachaauru relaane nainaain, ichatane ucuunno caje fauha uha Jesosone jana jetaote, arajiin sacuure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nii jana jetaote, turuha uhe leinjiin cacha cosibi caaun cunaitenaa. Aca jetaote, Jesoso rene turuhin nacatiha neseeonriaain jetao: “Ii jereeine canu rautaau caa canu cosibi cajera Curuaanaa,” naane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","“Jerichaaun chujian. Ii caje amuhine caa ii cosibi,” naain biji que dadaa Jesosone rijieeoritiin, nii rai cosibi caje nerautaain somaraain ne nii cacha. Nitohanai cunai siricha cacha rohan nichuuntaain dadanaa naineniha chunine que airijiin, rohan nichuuntaain dadae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nitohaneein rautaain jetaote: “Aonaau. Jiaonriha chuni rai catohaneein ii rautaain nihanune beeinera. Raujiaaincha nii Moisesa aitoonjoan rijijieein, Cana Coaunera belaiha saseredote rai iicha teeni amaain cunihunte caje inae nerautaaine coaracurumiin cachaaurura. Chaen techu inae nii ii cunai caje nerautaain somaraain leeochaauru rohan turunaa naineeine coaracurureein satiin cachaauru,” nae rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Inae Caferenaaon turuha Jesosone jana jetaote, rene turuhin jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Curuaanaa, canu letononeein nenaate cunaiteein ne canu loreri asae, itolereneein jiurohin cunaacoaa rai jaberocone jaun,” naain Jesoso rai biha leinjiin Romanocuru rai soondarooru curuaanaane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Inae rautaa urichaaunni,” naa rai Jesosone jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Curuaanaa, coatiha chaque ichei nelatejeehaaun canu loreri asae turuha uhine coina. Raujiaaincha nii cunai sitaau canu letono caje, aihute nerautamiin. ");
INSERT INTO uraNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nitohaneeinne canu letoaain neeuruha canu curuaanaacurune acaauru ere tonoraain neeun. Nii rijijieein techu, neeure canuhacha letoaeni soondarooru. Leinjiin letoaanunete quere tonoraain cue. Jana leeocha cotihacaaunnete uhe. Chaelai ichaa canu letonone coina letoaanune techu ichae quere tonoraain,” naa Jesoso rai Romanocuru rai soondarooru curuaanaane jana, ");
INSERT INTO uraNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","cojoelatiin jetaote: “Esinae rauhijiriin coatiha nihei chuni Isaraeli cocoaicha, caa cacha rijijieein jataain quesenetaera coarahaaun chabana. ");
INSERT INTO uraNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Esinae rauhijiriinte enoto mitu nichajai, enoto so nichajai, naaonjoainuri cajeeuru arajiin uhin, Abaraaun, Isaca, Jacobo, naaonjoainuri aina raotojoeein turuhin lenonecurureein, inae Cana Coaunera cojoanonaa que turuhane bana. ");
INSERT INTO uraNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jana Isaraelitaauru tabaaurute, rai cachanu que ranajaain nihalu Cana Coaunerane saijieein, inae Cana Coaunera cojoanonaa que turuhane bana, nocohenaanau jaoleneein chanaa curureein nesoone caaun,” nae jetao aina cunacaauru cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Niritohane baiha jetaote: “Chajaain chenenajaun caunihute, nii esenetaain jereeine rijijieein nerautamiin ii letono,” nae Jesoso. Nii rijieeoritiin jetaote, inae nerautae nii soondarooru curuaanaa letono cunaitenaa. ");
INSERT INTO uraNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nii baiha jetaote, Fedoro loreri asae turuha cuha Jesosone jana jetao, ecu sininaja ichoae ajaa caaun cunaiteein niha Fedoro tanone jana eruuruha cue. ");
INSERT INTO uraNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Inae ecu turuhin nii cunaitenaa biji mucuha Jesosone rijieeoritiin jetao, inae caje amuha nii ajaane jaun, nerautaain nimichuhin acaauru rai lenone chalue. ");
INSERT INTO uraNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Inae nocohejihane jana, arajiin suujua cuhane coitucuchuhichuru siriin caaun cunaitenacaauru uhaain turuuruha cachaaurune jana jetao, nereecha que nii cacha suujua cuhane nenacaauru coitucuchuhichuru sitaain, satiin cunaitenacaaurune maajeein rautaacoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nitohaneeinte ichae Jesoso, “Acate turureein cana caje cana osa aina cana cunainunru itajihane coina,” naain besihalu Cana Coaunera ere bera inoaensi Isaihasine nainaane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nii jana arajiin curuhacaain neeuruha cachaaurune coaraane jaun jetaote, nemuri jerau amaauruha aina nerelanacaaurune coina acaauru rai aite Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nii jana jetaote, rohan nichuuntaain jetao: “Curuaanaa, ii ainane unaa jereeun, chunijiun cuhine jaaun niha natiin,” naa Jesoso rai Moisesa aitoonjoan que cacha relaerane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","“Arolarihurute sininajaanu siriin naaonjoaaunre. Jerichanejeein techu sininajaanu siriin naaonjoaaunre tajaaecuru. Nena laen canu Cana Coaunera Calaohi cacha caje nejanoanaa nichaaunne, nene canu rai chunijiun nesurucuaaunne jaanura,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nii jana jetaote, aina nerelanaa netonai jetao: “Curuaanaa, inae oha canu inacane janane conautichaaune baiha ii aina ureeuni,” naa raine jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Niriimiin. Canu sacuhachaaute ecu nejesinajeein Cana Coaunera coitucuhi nesinanejeein ichaaoruhine ooruhane reentiaain,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Niritiin jetaote, aina nerelanacaauru aina jiniiquiin bote cuhane fauhin jelai caje amue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nii jana inae bote cuhane cuujueeuruhane jana, uha cujuana tabai aina fichafichanaane jaun jetaote, enohe bote cuhane acau. Nii jana jetaote, tonajelanaala bote cuhane sinii siniicha Jesosone jana ");
INSERT INTO uraNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","nocoaain jetao: “Curuaanaa, inae nalunaa jerichaache. Chajaain caa acau caje cana ichoterateeu,” naauruha aina nerelanacaaurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“Chanuna jataain nesooneeiche. Jataainachura ansijieeinijin cha esenetaeneeichete,” naain nimichuhin cujuana aina fichafichanaa suruaa Jesosone jaun jetao, inae neniha fichafichanaane jaun raotojoeein cuujueeure. ");
INSERT INTO uraNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nii jana cojoelatiin jetaote: “Chatohanaineeinna ne caa cacha, cujuana aina cucuana cuhane niha natiin nere tonoraain nesuruhane coina,” naaure jetao ecu nejesinajeein aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Inae nemuri jerau aina nerelanacaauru aina jiniiquiin Cadara batane que turuha Jesosone jana jetaote, atanebana jelai caje cuhin jetao, coinetecure coroatajai cachaauru, suujua cuhane coitucuchuhi sirichaauru. Acaauru jetaote, enaacha cacha cunaitaane jaun, nene chuni nii neeurunaja bero cuhane amui. ");
INSERT INTO uraNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Acaauru jetaote: “Coa canacaanu rene turuhin canacaanu rerohecaa Cana Coaunera Calaohi Jesoso. Nechu jataain canacaanu rerohecaain, canacaanu cairichaaine coinate, jaiti cojoanonaa que turuenihane jana turuhicha,” naaure jetao ehequiin. ");
INSERT INTO uraNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nii jana ecu rohan arajiin lenoniha neeuruha coosichurune jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","“Caa cachaauru suujua caje canacaanu sitanaa jereeine, nii coosichuru suujua cuhane canacaanu letoaaura,” naauruha Jesoso rai, nii cachaauru suujua cuhane nenacaauru coitucuchuhichurune jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Taa coosichuru suujua cuhane cunichuchera,” naain jetao nii coitucuchuhichuru letoae Jesoso. Nii jaun jetaote, nii cachaauru suujua caje mituhin, coosichuru suujuaniha enooruha nii coitucuchuhichurune rijieeoritiin jetao, satiin ramarau nemarotihacoaain nereeonohin ohacoaaure nii coosichuru. ");
INSERT INTO uraNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nitohanihane coaraain jetaote, jelai caje sorohin jetao, neseu turuhin nii coosichuru suujua niha enooruha coitucuchuhichurune jana, ooruha coosichurune beeure nii coosichuru beraihurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nii jaun jetaote, satiin nii nese caje cuhin, nii niha Jesosone jaaun rene turuhin coaraain jetao, rai aitocure chajaain jelai caje amuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nii baiha jetaote, aina nerelanacaauru aina jiniiquiin bote cuhane fauhin cuhin nemuri jerau ichaohalune jaaun Caferenaaon turuha cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Inae ecu turuuruhane jana jetaote, nela cuhane leinjiin jiurona cacha turuaa cuuruha Jesoso rene cachaaurune jana, jataain rautaane esenetaain aihuruha nii cachaaurune coaraane jaun, nii cunaitenaa rai jetao: “Nelararajiaaura cacalabi. Inae ii osa caje ichoteratenohi neeicha,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nii aonaain jetaote: “Chanuna caritiin Cana Coaunera baijiaraanu rijitiin ere caa cacha,” naain jetao suujua cuhane coarajeeure Moisesa aitoonjoan que cacha relaaureraauru tabaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nejetaote niritiin baasoneein suujua cuhane coaaucuruhane coitucuhane jaun jetao: “Chanuna baasoneein itolere bana inara suujua coaraquiche. ");
INSERT INTO uraNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chaa quena caaintare: ‘Inae ii osa caje ichoteratenohineein,’ naenihacane: ‘Chajaain nimichuhin chela seriin amuun,’ naacane. ");
INSERT INTO uraNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Coarajeeuche nachuhintine, canu Cana Coaunera Calaohi- cacha caje nejanoanaa nichaaunne cocoainaain letohanojoinichaaun osa caje cacha ichoteratichaaunne coina, caa chauratane quene coaarate inara que,” naa acaauru raine baiha jetaote, nii jiurona cacha rai jetao: “Chajaain nimichuhin chela seriin chenenajaun cauninura,” nae nii jiurona rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nii rijieeoritiin nimichuhin jetao, rai nenajaun cauha cue nii jiurona cacha. ");
INSERT INTO uraNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nii coaraain jetaote, rai suujua rauhi inaaoritelanaala que casiin Cana Coaunera coroaaecure. Nitohanai ichana nainiha cachane jaanu teein niha Cana Coaunerane coaraain. ");
INSERT INTO uraNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nii jiurona cunaitenaa rautaane jaan jelai caje uhin canu- Mateeo nichaaunne, Roma curuaanaa rai impoestonu que cachaauru cobaraain coriqui bajaanune jaan rori ichoae lauhecohanune jana canu coaraainte: “Chajaau canu aina,” naain canu cotihaca Jesosone jaun, nii rijieeoritiin nimichuhin Jesoso aina cuun. ");
INSERT INTO uraNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nitohaneein cuhine canu loreri asae turuhin, satiin aina nerelanacaauru aina curuaaecaain Jesoso coroaateeun. Nii janate ecu canacaanu rene turuhin nelauriaain lenonecure jataain arajiin Roma curuaanaa rai impoestonu que coriqui bajaaureraauru canu leeochaauru, chaen leeochaauru cachaauru- nechu aansaineein ichaonacaauru, osaaonacaauru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nii coaraainte Jesoso aina nerelanacaauru rai: “Chanuna caa impoestonu que coriqui bajaaureraauru aina, caa osaaonacaauru aina lenone caa inara relaera,” naauruha fariseeocurune ");
INSERT INTO uraNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","aonaainte: “Coatiha coichaera latecuruhi raurohin nenacaauru. Leinjiin cunaitenacaauruhachate coichaera latecure. Nii rijijieein canu latecuruhi caohachaain ichaoha nocoetonacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Chajaain nii Quiricha Inoaensi cuhane: ‘Coatiha chaelai sohin mocohin que canu belaaichene jerinaaun. Raujiaaincha jiniiquiin cairichaaojoaain ita coaraain ita belaain neeichenena jereeun,’ naain laenanohi nihane jaan que nerelanihuche. Aihane jaun, coatiha nii caohachaain ichaoha nocoetonacaauru cotihaca uhaaun, osaaocuruhane coitucuhin nichao coreein caohachaain ichaonaa jereraaurune cotihaca uun,” nae fariseeocuru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nii janate Jesoso rohan nichuuntaain: “Chanuna fariseeocuru aina canacaanuhacha canacaanu suri couu netiin cosinacaain Cana Coaunera bajaacaanune jana, ii aina nerelanacaauru aihurene,” naauruha Joaan Baotisita aina amuhemuhenacaaurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","“Chasiina suri couu netiin cosinacaain inaderaaurure ene ranaa jerera beseta que cotihanohichuru, jaiti acaauru aina niha nii ene ranaa jerera cacha natiin. Nete inae nii jianacoon teein cacha ranaa jerera nichaaunne mucuhin amaauruhane banate laen, suri couu cosinacaain niha cuurureein- nii beseta que cotihanohichuru. ");
INSERT INTO uraNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Coaracuche nachuhinti, nihei chuni obiri enachasine soaain, cajione siri que counera. Nitohaneein nii obiri enachasine soaihanete, nii obiri enachasine asaaere nii cajione siri. Chaen caohachaain nedanaa nainerihei nii obiri enachasine, nii cajione siri que couneraane. ");
INSERT INTO uraNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nii rijijieeinchu nihei chuni inae conaca que tiha coaaeraine jana, cuhane ichonai tera. Nitohaneein cuhane teraa ichonainete naasaaere nii coaaerai. Nitohanihane jaunte, caohachae coaaerai nejesinaneein niha coaaeraine. Chaen ichonai, ichonai nejesinajeein nihane caohachae,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Niritiin acaauru rai ereereeca Jesosone janate, rene turuhin nacatiha neseeonriaain: “Jataain enate nijioaen canu cacunu. Nete canu jiniichaain uhin dadaaine nacoaauneein ichanareein,” naain Jesoso cotihaca leinjiin Jorioocuru curuaanaane jaun, ");
INSERT INTO uraNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","nii rijieeoritiin nimichuhin aina nerelanacaauru que corihaneraain caaijie cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nii janate lechoonca coroata jaanacaain, rai jaberoco caje ichana jaohajeein niha leinjiin enene jaun, Jesoso rohan nichuuntaain caaijie cutiin cajione auha mucuuri: ");
INSERT INTO uraNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Caa rai cajione auha mucuhanuneecha caaunne nerautareeunni,” naain esenetaane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nete rai cajione auha mucuhane jana nauriteriin nii ene coaariin: “Nelararajiaaura ene, jataain nerautaaine esenetaain aaine jaunte inae nerautaaicha,” naa rai Jesosone rijieeoritiin, inae nerautae nii ene ichana jaohane caje. ");
INSERT INTO uraNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nii ene rautaane caje cuhin, nii Jorioocuru curuaanaa loreri asaae turuha Jesosone janate, inae atane rucuhecuruhane rai neein cojioriinchuru coinaderaauruha cachaaurune jana turuhin: ");
INSERT INTO uraNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Satiin caalai caje mituuche. Coatiha ohane jaun aihei caa ranuna, sinihane jaunte aicha,” naa acaauru rai Jesosone jana coenacure ecu neein coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nete coenacuruhane saijieein, jitariin nii loreri caje mitanajaane baiha, nii ranuna rene enohin biji que mucuhin michuha Jesosone jana nimichue nii ene. ");
INSERT INTO uraNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nii coaraainte ita rai beeuruha cachaaurune jaun, satiin jelai batane sacuritaain coitucunojoi ne nii o caje ranuna ichatiha Jesosone. ");
INSERT INTO uraNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nii ranuna ichatihane baiha caje amuha Jesosone janate caaijie cuhin: “Jataain cairichaaojoaain canacaanu coaraaura Rabiri nefoerate,” naain eheehequiin sacuure coroatajai maosacuru. ");
INSERT INTO uraNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nii janate inae loreri asaae turuhin, ecu enoha Jesosone jana rohan nichuuntaauruha nii coroatajai maosacurune jaunte: “Caa maosa neeichene caje inara nota teein nihanune esenetaaichena,” naain acaauru caje bajaa Jesosone janate: “Aihacaanura Curuaanaa,” naauruhane jaun, ");
INSERT INTO uraNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","biji que acaauru nota dadaain: “Nii esenetaaichene rijijieein conohine inara notara,” naa acaauru rai Jesosone rijieeoritiin, ");
INSERT INTO uraNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","inae conoe acaauru nota. Nii jaunte: “Coa leeochaauru rai caa inara nota teein nihanune bihache,” naain acaauru suujuatiha Jesosone saijieein, ");
INSERT INTO uraNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","jelai caje amuuru rijieeoritiin beeuruhane jaun, inae satiin jelai batane sacutaain acaauru nota teein niha Jesosone coitucuure. ");
INSERT INTO uraNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Inae jelai caje amuuruha nii coroatajai maosacuru niicha rautaaurine janate, erenaachara cacha, coitucuchuhi que suujuequiin nenaa turuaa uure Jesoso rene. ");
INSERT INTO uraNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nii janate nii coitucuchuhi sitaa Jesosone rijieeoritiin, inae irihane nunuhete nii erenaachara cacha. Nii coaraainte: “Coatiha chabana catohanai coarahaacache Isaraeli lauri nichaachene janata,” naaure cojoelatiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nete: “Jeelai coitucuchuhichuru curuaanaate, caa catohaneein coitucuchuhichuru sitaain niha caa cachane jaanu teein nera,” naaure ecu neein coarajeein fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nitohaneeinte neseeuru cuhecujueein nenaanajaauru naineein amuhemujueein, netaojiaain Cana Coaunera rai rauhi que ereereecuruhane jaan coloheri sinacocacuru naineein cuhecujueein, Cana Coaunera Cojoanonaa erenaa raotono que cachaauru relaain, itolere cunai caaun cunaitenacaaurune maajeein rautae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nii jana cachaauru coaraa Jesosone janate, nii chaque nelatihei rijijieein beraicha colane nenaa carenero rijijieein amuhemuhecuruhane jaun cairichaaojoaain acaauru coarae. ");
INSERT INTO uraNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nii jaunte: “Jataainte esinae arajiin neeure cachaauru, Cana Coaunera coitucunaa jereraauru. Nete nene acaauru relaeranura. ");
INSERT INTO uraNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aihane jaun Cana Coaunera bajaauchete neeine acaauru raain acaauru relaeranu,” nae aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nii jaunte lechoonca coroatajai aina nerelanaa nichaanune cotijiaain janijiin, canacaanu cocoainaain canacaanu letoae Jesoso, cachaauru suujua cuhane nenacaauru coitucuchuhichuru sitaain, itolere cunai caaun cunaitenacaaurune maajeein rautaacaanune coina. ");
INSERT INTO uraNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nii lechoonca coroatajai afosotoorunu que niicha cocoainai nichaanunete, jauriaanejeein Simoon Fedoroneein acaauruhacha curuaatei, rai nejera Aanderesi, Saantiaao aina rai nejera Joaan Sebedeeo calaohineein nenacaauru, ");
INSERT INTO uraNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ferifi, Bartolomee, Tomasi, chaen canu Mateeo nichaaunne Roma curuaanaa rai impoestonu que cachaauru cobaraain coriqui bajaera nichaaunlune, Arafeeo calaohi Saantiaao, Tadeeo, ");
INSERT INTO uraNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","chaen jauriaanejeein Romanocuru que nejeratenacaauru aina nenaalu Simoon Seloteneein niicha curuaateeuri, chaen nii baiha Jesoso coulurujueranu Jodasi Isacariote, naaonjoainichaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nitohaneein nii lechoonca coroatajai aina nerelanaa nichaanune letoaainte canacaanu suujuate: “Coa nii Cana Coaunera coitucuelanaala ichaonacaauru atane que cuhache. Niheichu Samaria cocoaichacuru rene niha natiin coa turuhache. ");
INSERT INTO uraNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ucuaae cuelanaala, Cana Coaunera cachaneein nitajerai nenacaauru Isaraeli cocoaichacuru rene cunichuche. ");
INSERT INTO uraNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Chajaain ucuaae cuhin, inae nichuutaa Cana Coaunera Cojoanonaane benichuche acaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Chaen cunaitenacaauru rautaain, onacaauru nihanatiin ichateein, cosibi caaun cunaitenacaaurune maajeein rautaain, cacha suujua cuhane nenacaauru coitucuchuhichurune maajeein sitaauche. Inarate core colane nitohanai ichana nainequichene jaanu raain neeiche. Aihana jaun nitohanai ichaain neeichene, coa core bajaache. ");
INSERT INTO uraNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Coa inara coriqui, inara atora, inara cajione necoreeteeichene jaanu, inara safato, inara biji achune, naaonjoainuri amaain cuhache. Niha rauhi, amihanenacaauru coroaateeuruha cachaaurune coina. ");
INSERT INTO uraNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Leinjiin neseu, nenaanajaun, naaonjoainu turuhichene, chunocoha caohachaain inara raera cacha ariin, rai loreri asaae neeuche jelai caje amuhichene reentiaain. ");
INSERT INTO uraNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Inae nii loreri asaae turuhichene neein, loreri asaae nenacaauru rai ereein turuuche. ");
INSERT INTO uraNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nii jana raoti ichaonaa que ichaonaa jerecuruhanete, raotojoeein inara raaurureein nii loreri asaae nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jana caohachaain inara raelanaala inara aohana jerecurenihane, nii loreri caje, chaen nii nese caje, naaonjoaain caje inara amuneein inara tijia que nenaa utoone rihariaain ratiriin amuuche. ");
INSERT INTO uraNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Esinae rauhijiriin acaaurute cana janonaa besaute que inae tihane bana, Sodoma, Comora, naaonjoainuri batane que ichaonacaauru amurijiriin caseteco coaracurureein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aonacuche, canune inara letoaaun janolari mululune jana situha cuha irine rijijieein cuhichene coina. Aihana jaun cacha cunaitaane coina nainaa acanone rijijieein cunichuche. Chatohaneein teraane nihanatiin nerinanaa naineniha serorine rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aihane jaun caohachaain nainaain necohalajiin cunichuche. Cocoainanacaaihuru rai inara teeuruhane janate, sinacoca asaae inara amaain inara bisiin, ");
INSERT INTO uraNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","coberenadorocuru rene inara amaain, reychuru raine maajeein inara amaaurureein canu coreniha. Nii janate canuneein nihanune coitucuerateriquicheein acaauru que, chaen nii Cana Coaunera coitucuelanaala nenacaauru quene maajeein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Inae cocoainanacaihuri bijiu inara teeuruhane, coa acaauru tonoraain ereeichene jaanu que tonajianche. Inae ereeichene coina neeichene janate, Cana Coaunera Suujue, inara rai ereeichene jaanu tereein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aihane jaun coatiha inara ecu ereriheeicheein. Cana Inaca Cana Coaunera Suujuete inara coreniha ecu erereein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nitohanerichaaine jaunte, rai nejeraauruhacha, nejeraauru tereein ateinanohineeuruhane coina. Nii jana rai inacaauruhachate, rai calaohichuru tereein cocoainanacai rai. Nii jana acaauru calaohichuruhachate, inacaauru que nejerateein inacaauru teeurureein ateinanohineeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Satiin cachaauru caa chauratane sacuritaain canu coitucuelanaala nenacaaurute, canu coreniha inara que nererojoecaa cuurureein. Nete nii esenetaane jianelanaala, atiin satono que tiaain jerichanejeein sacuera nichotereein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Leinjiin neseu turuhichene jana, inara rerohecaain inara mucunaa jerecuruhane, leeocha neseu cuhin sorooche. Esinaene aitoon. Jaiti Isaraeli nefoerateeuru sacuritaain turuheneeichene janane, canu inara ichohaichaniha ecu turureeunni canu acaihaniji Cacha Calaohineein nejanoanaa nichaaunne. ");
INSERT INTO uraNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Niheichu rai relaera amurijiriin nenaa nainihei aina nerelanaa. Niheichu rai fatoroon amurijiriin nenaa nainihei rai cachaneein nenaa. ");
INSERT INTO uraNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Relanojoineein nenacaauru, acaauru relaera rijijieein neeuruhine. Jana letononeein nenacaauru acaauru curuaanaa rijijieein neeuruhine. Canu inara Curuaanaa neein inara relaera nihanune que moconajaera Beelseboo niha canu beeuruha natiin, tonacururiha jana inara que. ");
INSERT INTO uraNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Aihane jaun, coa cachaauru coasichache. Coitucueraelanaala, asinojoineein chaachaain niha chunine niha natiinte, coitucunojoiniha cureein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jana caa coitucueraelanaala nenaa nii chuni aonaenihane jana, caa caitoonjoan coitucuerateeuche satiin cachaauru urichoo netiin. ");
INSERT INTO uraNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Coa inara atinana naineraauru que casihache, inara atinaauruhane baiha chabana satonoelanaala neeni janonaa que neeni, inara suujue itajenaa nainecurenihane jaun. Nete laen nainequiche chabana satonoelanaala nenaa usi jana inara jaberoco aina inara suujue itajeranu neein nenaa- Cana Coaunera que casiin neeichene. ");
INSERT INTO uraNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tana nii chaque nelatejeecane que airijiin leinjiin moneda que coriha coroatajai tajaelinaane coitucuhichene. Nete jereniha cana Inaca Cana Coaunerane nii leinjiinijin nitajenaa nainecurene. ");
INSERT INTO uraNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nii amurijiriin inarate, inara couturijine maajeein leinjiana leinjianaain janiinojoineein ne. ");
INSERT INTO uraNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aihane jaun coa casiin ichaohache. Inarate jataain tajaelinaacuru amurijiriin nelateein neeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Chunocoha cachaauru que canuneein nihanune coitucueraneein, canu cachaneein nihane coitucueratera ne, acaentonai coitucueratereeunni dedeeu nenaa Ofa Cana Coaunera acatiha neein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nena laen canuneein nihanune coitucueraneein canu cachaneein nihane saijieein, canu coitucuerate lanaala nenaa que acaentonai coitucuenereeunni Ofa Cana Coaunera acatiha neein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Coatiha raoti ichaonaanaja turuaa uhaaunlu caa chauratane que, ita que nererojoecaain ichaoha cachane jaane turuaa uunlu. ");
INSERT INTO uraNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nitohanihane jaunte, rai inaca que nejeratiha rai calaohine jana rai neba que nejeratereein rai cacunu. Jana rai nebaene quete nejeratereein rai nacana. ");
INSERT INTO uraNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nitohaneeinte nechu naraaicha que nejeratenaaneein neeurureein cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Rai inaca, neba, calaohi, cacunu, naaonjoainuri belaihane amurijiriin cacoelainihane, nii chuni canu cachaneein nenaa nainihei. ");
INSERT INTO uraNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Itolere necairichanaa abaantaain coroso que nerichaaunnine rijijieein necairichanaa abaantaenihane, canu cachaneein nenaa nainihei. ");
INSERT INTO uraNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nete laen canu, rai nichao ichoteratena nainichaaunne coitucuhin canuhacha cohajeein nenaa, nichao ichoteratereein canu coreniha. Jana canu esenetaelanaala, canu colane nichao ichoteratena jererate rai nichao itajereein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Chunocoha inara raerate canu raa aicheein. Jana caohachaain canu raerate canu letoaera raa aicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Cana Coaunera letononiha leinjiin profetane coreniha caohachaain raain nenaate, profeta rai cainanohiniha rai namihaneeone rijijieein nii raane coreniha rai cainanohiniha cureein. Chunocoha leinjiin cacha caohachaain nenaa raain neite, jerichanejeein nii cacha caohachaain nenaa rai cainanohinihane rijijieein, nii raane coreniha rai cainanohiniha cureein. ");
INSERT INTO uraNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chunocoha caa ena canu sacunaa nunuhetejeeureraauru rai, nechu jataain canu sacueranihane coreniha le eraurujeein conacai teein nei raite, esinae rauhijiriin cainanohiniha cureein,” nae aina nerelanaanichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nii lechoonca coroatajai aina nerelanaa nichaanune relaane baihane, jelai batane que nenacaauru neseeuru naineein cuhacaanu, Cana Coaunera beratenojoin erenaa beebejeein cachaauru relaa amuhemuheca Jesosone coina. ");
INSERT INTO uraNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nii janate caresero cuhane netiin benaa caje itolere ichaa Curisitone coitucuhin aina amuhemuhenacaauru letoae Joaan: ");
INSERT INTO uraNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Iina esinae rauhijiriin, nii turuha uheneni Curisito niha. Aca neneeine beeune turuha leeochane cohacaanu,” naain rene turuhin bajaauruhane coina. Nii jaunte letoanajaane rijitojoeein aitocuruha rene turuhinne jaun: ");
INSERT INTO uraNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","“Chajaain caa inaraacha coarai, inaraacha aonai benichuche Joaan raicha. ");
INSERT INTO uraNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Inae maosa neeuruhane caje conoa maosacuru notara. Bacosacuru niha natiinte, inae nichaauraain amuurera. Cosibi caaun cunaitenacaauru niha natiinte, inae somaraain neeure cosibi cajera. Urichosaaecuru niha natiinte, inae enene erenaa aonacurera. Onacaauru niha natiinte, inae o caje ichanacurera. Jana cairichainejeein nenacaauru raite, Cana Coaunera beratenojoin erenaa beebejeein, nosa caje nichoteeururichaaine beebeje. ");
INSERT INTO uraNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nerausiaaejeeinte neeure rai suujua corelanaala acanihane esenetaain acaacha cohajeein nenacaauru,’ naain benichuche Joaan raicha,” naain Joaan letonocuru letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Inae jelaiha cauha cuuruha Joaan letonocurune janate: “Chatohanai coaraa cuhichelu cacha areroo cuhin. Leinjiin jiarana nujua cujuana ichanohineein nerurujuanaana coaraa cuhichelu. ");
INSERT INTO uraNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ainihane leinjiin cacha, cajione caohacha que necoreeteein neina coaraa cuhichelu. Inarate raotojoeein coitucuhiche, cajione caohacha que necoreeteein nenacaauru, reychuru loreri asaae neeuruhane. ");
INSERT INTO uraNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chatohanai coaraa cuhichelu. Leinjiin Cana Coaunera ere bera profetana coaraa cuhichelu. Aiha laesinaae, nii choae tacaain jataain leinjiin profeta amurijiriin nenaate esinae rauhijiriin coaraa cuhichelu. Acate Joaan ne. ");
INSERT INTO uraNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nii Joaan quete: ‘Canune ii ajiniha cachaauru rai ereerecane coina canu ere bera letoareeunni turuhine jaanu rucuheranu que,’ naain ne laenanohineein Cana Coaunera Quiricha cuhane. ");
INSERT INTO uraNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Esinae rauhijiriine aitoon, satiin cachaauru caje nihei chuni cacha Joaan amurijirii jataain nelateein nei, Moisesa que Cana Coauneraacha teratenojoi Cojoanonaa bana. Nete laen, ena turunaa Cana Coaunera Cojoanonaa, Joaan fautaain nelatihei rijijieein nenaa, jataain nii Joaan amurijiriin nelateineein ne. ");
INSERT INTO uraNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Turuhalu Joaanne caje coauneeinte, enanetojoeein ena turunaa Cana Coaunera Cojoanonaa turuaera nichaaunne que nejerateein itajenaa coaaucure Cana Coaunera coitucuhichuru curuaanaacuru. ");
INSERT INTO uraNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Satiin profetacuru aina Cana Coaunera aitoonjoaaunru rauhite, nii turuha uheni Cana Coaunera Cojoanonaa coitucuerateein neeurelu, turuha Joaanne que tiaaojoaain. ");
INSERT INTO uraNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Inarate esinae rauhijiriin nacoaauneein turuha urichaain Irihasine que aitocuruhalune coitucuhiche. Acate nii Joaan neein turuhelu. ");
INSERT INTO uraNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Caa aitocoaaunne aonacurumiin urichonacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Caa cachaauru, enene cojoanonaa que nenacaauru ichao bihanune jaannu coitucuhaaun. Aihuruha canaanaihuru nenaanaja cataaun nocoatijiaan, rai corihacuru rai eheehequiin: ‘Raansaichene coina auno totihacaanu. Nete canacaanu auno rautaelanaala raansanaa jereneeiche. Inara cotijiaain, berane jaain inaderaacaanune jana, canacaanu aina inaderaheeiche,’ naauruhane rijiichuruha. ");
INSERT INTO uraNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nii rijijieein techu, turuha Joaan joaenreen lenone que lenonelanaala, bino conaa inaelanaala, naaonjoaaine jana, moconajaera suujue siriha beeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nii baiha turuhanu canu, cacha calaohineein nejanoanaanichaaunne jana, bino cohin, joaenreein lenone que lenoneein, naaonjoaineeinne jana, ‘Achotoritiin, ajetoriaaneein, baasoneein ichaonacaauru osaaonacaauru belaichaneein, Roma curuaanaa rai impoestonu que cachaauru cobaraain coriqui bajaaurera belaicha niha’ canu beeiche. Nete jataain itolere que nainaain, chaachaain niha Cana Coaunerane caje coaraain, coitucunojoi ne niicha ichai,” nae Jesoso cachaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Cojoelanaacojoai ichaalu Jesosone saijieein nichao coreein nacoaauneein Cana Coaunera coitucuureniha nii nese que ichaonacaauru cachaaurune jaunte: ");
INSERT INTO uraNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Jataainte cairichaaojoaiche nohane, Corasiin cocoaichacuru. Cairichaaojoaiche nohane Betesaaida cocoaichacuru. Inara que cojoelanaacojoai ichaain coaaratihanulune tocohaneein, Tiro, Sidoon, naaonjoain cocoaichacuru rai cojoelanaacojoai ichaain coaaratihanulune jana nihanete, inae inoaenlu nejeein inae nichao coreein, nacoaauneein Cana Coaunera coitucueraneein neeuruhane coaarateeurure niicha jerenohin ichaain. ");
INSERT INTO uraNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nete inae coitucuhichuru coulurujueein casetecaeratihane jaan Cojoanonaa que turuhane bana, Tiro, Sidoon, naaojoainunri cocoaichacuru amurijiriin caseteco coaraa curiquicheein inara. ");
INSERT INTO uraNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jana inara, Caferenaaon cocoaicha neeichene, inacojoeein caohachaain niha nocoetiin raotiin nenaa coaauquiche. Nete ohichene bana nocohena tabai jana nitajiha curiquicheein. Nii inara que cojoelanaacojoai coaaratihanulune tocohaneein, Sodoma cocoaichacuru que coaaratihanune jana nihanete, enanetojoeein neeurure jelai cocoaichacuru. ");
INSERT INTO uraNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nete inae coitucuhichuru coulurujueein casetecaane coina turuha Cana Coaunera Cojoanonaa que turuhane bana, Sodoma batane cocoaichacuru amurijiriin caseteco coaraa curiquicheein inara,” nae cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Niritohane baihate: “Itolere chauratane, dede, naaonjoaain Coauneraneein neeine coroaaejihanu jataaincha, Ofa, itolere coitucutoha nocoetonacaauru que iicha asii coitucuerateei cairichainejeein nenacaauru quene jaaunra. ");
INSERT INTO uraNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aihara Ofa, nitohaneein jereeine jaunte ichaaicha,” naane baihate: ");
INSERT INTO uraNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Canu Inaca Ofate satiin raineein nenaa teein ne carai. Nihei chuni Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne coitucuera. Leinjiin Ofa Cana Coauneraachate cacoitucue. Niheichu chuni, Ofa Cana Coaunera coitucuera. Canu- Calaohineeichane coitucuun. Canu- Calaohi nichaaune coitucueratenaa jerichaaunne jaaunru que, coitucueratihanune banaachate, Canu Inaca Ofa Cana Coaunera coitucuurureein cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nii inara baasoneein ichaonacaauru, inara nererojoecaeriin ichaonacaauru, inara osaonacaauru, naaonjoaineeichene canu esenetaain canu sacuuchena raotojoeein ichaonaanaja te inara rai. ");
INSERT INTO uraNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Caa inara rai caitoonjoa esenetaain, Canu que nerelaain aihanune rijijieein ichaaoche. Coatiha chabana inara aina baasoneein nerinaaunni. Nii bana coatiha nitajerinaain inara suujue. ");
INSERT INTO uraNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Coatiha caaintaai, caa inara rai caitoonjoa tonoraa cachane,” nae. ");
INSERT INTO uraNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nii amuhemuhecaaunne jaun, nebetacanaa cojoanonaa bana tirico coocana jana situha cuhacaanu Jesoso aina jiniiquiin aina nerelanaa nichaanune. Nii janane mijiitohacaanune jaun, situnacanejeein nii tirico moloonejeein rai nucuhe quihacaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nii coaraainte: “Nii ii aina nerelanacaauru coaraau. Cocoaaeraa nebetacanaa cojoanonaa bana nitohanai ichara natiinte, inae tirico taihure,” naauruha Jesoso rai fariseeocurune jaunte: ");
INSERT INTO uraNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","“Tana lesajei que mijiitooruhane jaun, corihacuru aina jiniiquiin Cana Coaunera loreri Teenforo asaae enohin, Cana Coaunera que banijiaain nenaa faan, saseredotecuruhacha nii faan quinaa nainihane saijieein, corihacuru aina faan quiha curuaanaa Rabirine jaan reretaain coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tana Moisesa aitoonjoa cuhane nebetacanaa cojoanonaa bana carenero narejeen sohin Teenforo asaae mocooruha saseredotecurune niha natiin, osa que nesaruhin naaonjoaaurenihane jaan reretaain coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aihane jaun Teenforo amurijiriin jataain nelateein cau nihanune coitucuhin neeuche. ");
INSERT INTO uraNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Coatiha: ‘Naaonjoain quete aite caa Quiricha cuhane,’ naain coitucuheeiche. Nii Cana Coaunera Quiricha cuhane: ‘Nii inihocuru mocohichene jianeein inara amute cacha belaain, naaonjoaain neeichenena jereeun,’ naain ne, laenanohineein. Nitohanai coitucuhin neeichenenoote, chatohanai baaso ichaain neniha inara amute cachane jana colurujueein naaonjoaain neriquiche. ");
INSERT INTO uraNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nitohanihane jaunna, canu- cacha calaohineein nejanoanaa nichaaunne, nebetacanaa cojoanonaa amurijiriin cocoainaain letononeein neeun,” naain fariseeocuru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Inae jelai caje amuhinte, ecu nenaa sinacoca asaae enoha cuha Jesosone jana, ");
INSERT INTO uraNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ecu najiniha ne leinjiin jiurona bijii cacha. Nii jana Jesoso colurujueeuruhane jaanu lera ariiriichuruhane jaunte: “Nainihanacha cocoaeraane saijieein, cunaitenaa rautaaca nebetacanaa cojoanonaa banane,” naain Jesoso caje bajaauruha fariseeocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","“Tana chunocoha inara, leinjiin carenero siriquichene jana nebetacanaa cojoanonaa bana acau mitunajaan ucuha jachu cuhane naluha inara raine coaraa curiquiche jelai caje rocohichene coinane. ");
INSERT INTO uraNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tana leinjiin carenero amurijiriin nelatiha leinjiin cachane coitucuhichene. Aihane jaun, cha caaunna cunaitenaa rai caohacha ichaa rautaenerichaaca nebetacanaa janonaa bana,” naain fariseeocuru tonoraane baihate: ");
INSERT INTO uraNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","“Ii biji raujiaaura,” naa nii jiurona bijii leinjiin cacha rai Jesosone janate, biji sijitaane rijieeoritiin, inae nerautae nii biji jera rijijieein nii cacha biji. ");
INSERT INTO uraNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nete jelai caje mituhin nejesinajeein ita suujua tacaaure fariseeocuru Jesoso sohin jaaoruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nitohaneein inae sohin jaonaa jerecuruhane coitucuuriin jelai caje amuha Jesosone janate, sacuuruha arajiin cachaaurune jaun, jitaain cunaitenacaauru rautaain, ");
INSERT INTO uraNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","aonajeeuruha cachaaurune urichoo, nii rautanaacane que ereeuruhane caohate Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nitohaneeinte bihalu Cana Coaunera ere bera inoaensi Isaihasine nainaane coina: ");
INSERT INTO uraNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Caate, janijiin belaain cocoainaain Canu Suujue que suujuequiin canu letononeein nenaa ne, ‘Inae nerinaain baasoneein cachaauru cairichaaurera,’ naain, satiin chauratane que lauri lauri nenacaauru cachaauru rai beebejihane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Coatiha cachaauru que nejerateein, cachaauru cotaain, bero cuhane niha natiin tonijiaain ereein cachaauru relaain, naaonjoaane aohanrarinaain. ");
INSERT INTO uraNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Coatiha nelatelanaala nenacaauru, cairicheineein nenacaauru, naaonjoainuri cairichaeranu que airinaain. Niheichu aasaeriin esenetaeraauru que jaolecorinaain, lauri lauri nenacaauru cachaauru ichao rucuhecane jaan que turuhane reen tiaaojoaain. ");
INSERT INTO uraNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Satiin lauri lauri nenacaauru cachaaurute acaacha que jaaecoorureein,” naain belu Isaihasi. ");
INSERT INTO uraNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nii janate, suujua cuhane coitucuchuhi siricha leinjiin cacha erenaachara maosa amaauruha Jesoso rene jana, irihane jaanu teein, rai nota cono te. ");
INSERT INTO uraNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nii coaraain cojoelatiinte: “Tana caa cacha Rabiri ichoala nihane,” naain ecu nejesinajeein satiin ita caje bajaacoaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nii aonajeeinte: “Moconajaera curuaanaa Beelseboote, caa cacha rai catohanai ichana nainihane jaan teein ne,” naaure fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Niritiin coaaucuruhane coitucuha Jesoso raotojoeeine jaunte: “Satiin caa chauratane que ichaonacaauru cachaauru, ita que nejerateein neeuruhanete jiniiquiin nitajenaa nainecurure. Niheichu leinjiin nese que ichaonacaauru ita que nejerateein neeuruhane, jiniiquiin raotojeein ichaonaa nainecururihei. ");
INSERT INTO uraNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nii rijijieein techu, moconajaera netonai rai letonocuru que nejerateein nihane, nii rai letonohacha sitaain nihane, nii chaque nelateein nenaa nainerihei. ");
INSERT INTO uraNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nii aitocohichene tocohaneein moconajaera suujue aina cuaain moconajaera sitaanu nechujianra, jeelai moconajaeraacha itajiha aicheeunna. Nete nii aitocohichene tocohanene, nitohanihane, cha jana inara letonocuru letohare nitohanai ichana naineein neeuruhane jaanu siriin neeuruhane coina. Nitohanihane jaunte, nechu jataain inara raajenihane jataain baasoneein aitocohichene coaarateeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Caa cacha suujua cuhane nenacaauru moconajaeracuru sitaanu Cana Coaunera Suujue aina cuaainnete, inae inara aina niha Cana Coaunera Cojoanonaane coujunacaneein ichaaun. ");
INSERT INTO uraNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Leinjiin cacha jataain laraajiin nenaa loreri asae enohin nihei nii chuni caje niicha sirii ruluhera. Biji ichojoaainchate naine nitohaneein caje niicha sirii ruluhane. ");
INSERT INTO uraNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Chateeinti canuhacha ichai ichaene. Niite canu que nejeratenaaneein ne. Nii rijijieein techu canuhacha ichai itajeraneein ne canu esenetana jerihei. ");
INSERT INTO uraNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nitohanihane jaunne inara rai aitoon, satiin osaonacaauru cachaauru quete suujua acatereein Cana Coaunera. Nete laen tonaain baasoneein Cana Coaunera Suujue que erei que suujua acatenereein. ");
INSERT INTO uraNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Canu- Cacha Calaohineein nejanoanaa nichaaunne que nihanatiin tonaain baasoneein erei quete suujua acatereein. Nete laen rai Suujue que tonaain baasoneein erei nihane, caa ena nenaa janonaa, caa baiha neeninu janonaa, naaonjoain que nihanatiin neein suujua acatenereein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tana temule jaain neeichene, caohacha que inaacane caje temule caohacha coitucuhin neeichene. ");
INSERT INTO uraNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nitohaneein necha ansaineein neeichene jaunte, inara suujua caje mitunaa nainene caohacha. Inara suujua cuhane baasoneein inaraacha coacuite, inara ujuae caje mitue. ");
INSERT INTO uraNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jana caohachaain suujua coaara cachate, caohacha nejesina que ereein ne, suujua cuhane niha caohachane jaun. Jana baasoneein suujua coaara cachate baaso que ereein ne, suujua cuhane niha baasone jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Canune inara rai beeun, inae caseteco coaracururichaain satiin caa chauratane que nenacaauru cachaaurune bana, tonaain baasoneein ereeichene nihanatiinte coitucunojoinereein. ");
INSERT INTO uraNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nitohaneeinte, inara ujuaae caje baaso ichaain neeichene ujuaihoneein neneeichene, caohacha ichaain neeichene coitucunojoiniha cureein,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nii jaunte: “Cacha relaera, canacaanu rai cojoelanaacojoai ichaain coaarateeinene jerichaanura,” naauruha Moisesa aitonjoan que cacha relaaurera aina fariseeocuru tabaaurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“Caa necha ansaineein suujua coitucuelanaala ichaonacaauru cachaaurute, acaauru rai cojoelanaacojoai ichacaaunne jerecure. Nena inae acaauru que cojoelanaacojoai coaaratihalu profeta Jonasine jaun, inae nenacaaeneein acaauru que coaaratenaa jereneeun. ");
INSERT INTO uraNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nii nichata jiichoo nichata janotiineein, ate tabai suri cuhane nihalu Jonasine rijijieeine, canu- Cacha Calaohinichaaunne nichata jiichoo nichata janotiinejeeincha atane cuhane nereeunni. ");
INSERT INTO uraNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aihana jaun, coitucunojoiniha caohacha ichaeraauru aina baaso ichaeraauru ichao que tihane banate, nacoaauneein nimichucurureein Ninibe cocoaichacuru, acaauru coulurujueeuruhane coina, acaauru rai beratenojoin beebejiha Jonasine aonaain nacoaauneein Cana Coaunera que coacuhin neeuruhalune jaun. Jana ena cau inara aina neinichaaunnena Jonasi amurijiriin nenaa nichaaunne saijieeinte caitoonjoa esenetana jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jerichanejeein techu nacoaauneein nimichureein enoto mitu nichajai coarajeein cana raotono nichajai que nenaalu ene curuaanaaneein nenaa netonai inae caseteco coaracururichaain caa ena nenacaauru cachaaurune bana acaauru coulurujihane coina, niicha coitucuhi beebejiha cachaauru rai Salomoonne jana, coriaji atane caje uhin aonaa uhalune jaun. Cau caa ena inara aina neinichaaunnena Salomoon amurijiriin nenaa neeun. Nete nii saijieein canu esenetana jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Cacha suujua caje mituha leinjiin coitucuchuhinete, cajihaneein amuhemujeein nihane jaanu ariirijie. Nii jana eruhenihanete: ");
INSERT INTO uraNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Taolu mituhanulune jaaunne jelaiha cauha cureeun,’ naain coacue. Niritiin jelaiha turuhin nii cacha coaraane jana, aiha leinjiin loreri conera colane caohatiin lojoinojoineein nenaa rijijieein eruhanete, ");
INSERT INTO uraNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","nacoaauneein jelaiha cuhin, caainsineein amurijiriin baasoneein nenacaauru aina ita taojiaain, jiniiquiin nii cacha suujua cuhane jeelaiha enooruhane, jataain jeelai amuritoheriin baasoneein ichoae nii cacha. Nitohaneeinte, ichaoha cuurureein caa necha ansaineein ichaonacaauru cachaauru netonai,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Niritiin jaiti cachaauru aina ereereeca Jesosone janate, rene turuhin aina erenaa jerecure neba aina nejeraauru. Loreri asae enohelanaala airiniha neeuruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","“Taute airiniha turuhin neeure ii neba aina ii nejeraauru, ii ainate erenaa jerecure,” naain Jesoso rai beeure. ");
INSERT INTO uraNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","50","Nete, nii rai biha unaa rai: “Caaurute canu neba aina canu nejeraaurune. Chunocoha caletoaera Ofa ere tonoraain niicha jerenohin icharate, canu nejera, canu bai, canu neba, naaonjoainuri ne,” nae aina nerelanaa nichaanune cojeluhin Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nii bananeeinte, nii loreri nihacaanune jaan caje cuhin, nemuri auhaniha turuhin ecu nelauriaain lauheque Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nii jana, arajiin rene turuhacoaauruha cachaaurune jaunte, leinjiin bote cuhane fauhin lauheque, carene ichoae neeuruha cachaaurune tonohana. ");
INSERT INTO uraNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","4","Nii bote cuhane netiinte, araai laurii nereretanaa rijijiei parabola que cuaain cachaauru rai ereerejeein: “Leinjiin temule jaera temule jaa cunajaun ucuhe riiaacane janate tabaauru bero cuhane naluha nii niicha riajaiine jaun, turuhin coaraain quihure tajaaecuru. ");
INSERT INTO uraNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jana le turijieein niicha riajaite, neniha mululuhin atanene jaan jeloon ajeri ichoae nalunacaauru carajaelanaala omaroe. ");
INSERT INTO uraNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nete inae omarohane jana mituhin ajajaa enotone jaun ohe, mululuhin neniha atanene jaaun, ucuacaain neniha rai cojoaisine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Le turijieein niicha riajai ucuhete, ajena jana naluhane jaun, amurijiriin omaroha ajaenane jaun atinae. ");
INSERT INTO uraNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jana atane caohacha que le turijieein niicha riajaite, le ucuhecuru caje le temuracuru lefashaananaain inacae. Jana tabaaurute saotachoonca ucuheneein, nichatachoonca ucuheneein, naaonjoaain inaacure. ");
INSERT INTO uraNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Caa caitoonjoan aonacurumiin irichonacaauru,” naain cachaauru rai ereereje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nii jaunne, Jesoso rohan nichuuntaain nii araai laurii nereretanaa rijijiei parabola que cachaauru rai ereereecane jaan bajaacaanu caje aina nerelanaanichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nii jaunte: “Cana Coaunerate rai cachaneein neeichene jaun, coitucueraelanaala nenaa Cojoanonaa coitucuerate inara que. Nete laen rai cachanelanaala nenacaauru que coitucueratenaa jerene. ");
INSERT INTO uraNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nitohanihane jaunte, naitoonjoa tonoraain niicha jerei ichajeein nenacaauru rai, jataain jeelai amuritoheriin itolere coitucuhin neeuruhane jaanu tereein Cana Coaunera. Jana naitoonjoa tonoraelanaala niicha jerei ichaelanaala nenacaauru cajete, jitariin acaihaniji acaauruhacha coitucuujei rulureein. ");
INSERT INTO uraNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nitohanihane jaunne araai laurii nereretanaa rijijiei que cuaain acaauru rai ereeun. Coaracuruhane niha natiin coitucuurenihane jaun. Niheichu aonacuruhane niha natiin aonaain coitucuurenihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nitohaneeuruhane coinate: Aonacuruhane niha natiin: ‘Naaonjoain quete aite,’ naain coitucuururihaain. Niheichu nii coaana jerecuruhane niha natiin coaracururinaain. ");
INSERT INTO uraNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Inae jataain nauhacaa caa cachaauru suujuane jaunte, cha aonacuruhane nihanatiin, ‘Naaonjoai quete aite,’ naain coitucunaa nainecurene. ‘Niheichu cha coaracuruhane niha natiin coitucunaa nainecuruhi. Nabana canuhacha ichai coaraain, aonaain coitucuhin canu rene uuruhane, acaauru rautaanune coataa,’ naain bihalu Cana Coaunera ere bera inoaensi Isaihasine jaa nainaelu,” naain aina nerelanaa nichaanune rai bihane baihate: ");
INSERT INTO uraNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nete laen inara nerausiajeein niha curiquicheein, aonaain, coaraain, coitucuhin, naaonjoainchene jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Arajii profetacuru, chaen caohachaain suujua coaaraauru cachaauru, naaonjoainurine maajeeinte niqui, caa inaraacha coarai coaana jerecurelu. Nete coaana nainecurenelu. Inaraacha aonaine maajeein aohana jerecuruhane saijieein aonacuruhilu. ");
INSERT INTO uraNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Aonacuchene caa temule jaera que cuaain araai laurii parabola que irihanune be inara raite coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cana Coaunera Cojoanonaa que erenaa aonacuruhane saijieein coitucuhichurute, nii bero cuhane nalunaa temule ucuhe rijijieein neeure, acaauru suujua cuhane Cana Coaunera beratenojoi erenaa jereein aonacuruhane niha natiin, turuha acaauru suujua cuhane baasone jianeraauru ne. ");
INSERT INTO uraNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jana nii ajeri ichoae nalunacaauru temule ucuhecurute, Cana Coaunera ere aonaain esenetaain coroajeein jereein raauruhane jana, ");
INSERT INTO uraNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","inae cairichaaerinojoineein mucunojoinecuruhane coina arinojoineein neeuruhane, canu esenetaain neeuruhane jianeraauru rijijie. ");
INSERT INTO uraNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jana nii ajaena jana temunojoin temule ucuhecurute, Cana Coaunera ere aonacuruhane saijieein, nechu jataain caa atane que netiin necoriquijiaain, raotiin nenaa coacuhin, niicha que suujua cuaain necoritanacaauru rijijie. Niite, inae nii erenaa esenetaauruhane jianeein, leeochaauru relaauruhane jianeein neeure. ");
INSERT INTO uraNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nii atane caohacha que temunojoin temule ucuhecurute, Cana Coaunera ere aonaain leeochaauru relaain, naaonjoaain nenacaauru rijijie. Acaaurute, nii le ucuhecuru caje lefasha ucuheneein, saotachoonca ucuheneein, nichata choonca ucuheneein, naaonjoaain le tijiriichuru caje teeurera rijiichure,” naain aina nerelanacaauru rai beebeje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Niritiinte, nacoaauneein leeocha nereretanaa que cuaain acaauru rai ereerejeein: “Cana Coaunera Cojoanonaate, leinjiin cacha, rai nocoana jana cachaauru que tirico temueratihane jana, ");
INSERT INTO uraNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","temuhin satiin sinihuruhane tonohana, nii tirico niicha temuuri jana turuhin ajaena baaso temuha leinjiin cacha acaauru que nejeratenaane rijijie. ");
INSERT INTO uraNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nii jana inae omarohin, inae inaaca nii tiricone jana inanacae nii ajaena baaso netonai. ");
INSERT INTO uraNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nitohanihane jana coaraainte: ‘Curuaanaa, chasiinna temule caohacha ucuhe nejesina temuerateeilune saijieein, jana mituhe ajaena baaso,’ naauruha nii ocoana erora rene turuhin nii amihanenacaaurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Chunocoha canu que nejeratenaate, nii ajaena baaso temucaiha,’ naa acaauru rai nii ocoana erorane janate: ‘Ta, nii ajaena baaso rocohin jaohacaanune jereeine,’ naain bajaauruha nii amihanenacaaurune jana: ");
INSERT INTO uraNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Niriimiin, nii ajaena baaso rocohalaainte tiricone maajeein rocoriquiche. ");
INSERT INTO uraNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nirijieein ecu neein jiniiquiin omarocurumiin, tainaca que tihane reentiaain. Inae tainaca que tihane banane jelai teein nii ajaena baaso raain, jelai teein tirico raain rucuhecaaune jaa cuhane rucujueein, nii ajaena baaso jelai teein mocoheratereeunni,’ nae nii ocoana erora,” naain cachaauru rai beebeje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Niritiinte nacoaauneein: “Cana Coaunera Cojoanonaate leinjiin cacha, rai nocoana jana mosatasa ucuhe temuhera rijijie. ");
INSERT INTO uraNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Esinae rauhijiriinte, jataain leeochaauru temule ucuhecuru amurijiriin aansijian rai nucuhene saijieein, inae omarohane leeochaauru ocoana jana nenacaauru temulecuru amurijiriin fohecane, rai nunecuru que tajenajaanu ichacure tajaaecuru,” naain nereretanaa que cuaain beebeje cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Niritiinte: “Cana Coaunera Cojoanonaate nichata sajeein coujunaca que arina coujunacateriin rai jorerera que jasiiteein tabaain nii coliha jorereein caje arajiin faan jaa leinjiin enene rijijie. Nii neleeriha tabaain colihane coina nenaa jorerera rijijieeinte, cacha ichao sacuritaain nefaane coina nenaa ne Cana Coaunera Cojoanonaa,” naain beebeje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nitohaneeinte, nereretanaa rijijiei parabola nejesina que cachaauru relae Jesoso. Chabana nii parabola colane irihei cachaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nitohaneeinte: “Cana rai chauratane coaaunaa Cana Coaunerane caje coaauneeinte, satiin asinojoineein nenaa que erereein, nereretanaa rijijiei parabola cuaaincha,” naain beeuruhalu Cana Coaunera ere bera inoaensihuru profetacurune nainaane coina nitohaneein ichae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nitohaneein inae cachaauru rai irihane nainaainte, acaauru rai nocoeein jelai caje cuhin nii neeuruhane jaan loreri asaae enoha Jesosone jana, rohan nichuuntaain nii tirico coocana jana ajaena baaso temuhera que cachaauru rai iriha Jesosone bajaacaanu caje aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nii jaunte: “Nii temule ucuhe caohacha temuherate canu- Cacha Calaohineein nejanoanaanichaaunne rijijie. ");
INSERT INTO uraNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jana nii ocoana que caitoonjoate, cana rai chauratane ne. Jana nii temule ucuhe caohachate, Cana Coaunera esenetaain aina ijiin rai Cojoanonaa que neenihuru ne. Jana nii ajaena baasote, moconajaera letononeein nenacaauru ne. ");
INSERT INTO uraNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jana nii ajaena baaso temuherate, acaauru que nejeratenaa moconajaera ne. Jana nii taojiaera que aitocoaaunnete, inae ecu tihane bana sarichaain cana cojoanonaane que aite. Jana nii taain rucuheraaurute anjeraaurune. ");
INSERT INTO uraNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Charijieein teeinti, ajaena baaso taojiaain mocohaca, nii rijijieeinte inae saa cana janonaane bana moconojoiniha cuurureein osa que leeochaauru saruhin nenacaauru moconajaera aina. ");
INSERT INTO uraNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nii banane canu- Cacha Calaohineein nejanoanaanichaaunne canu rai anjeraauru letoareeunni, nii cana cojoanonaa que nenacaauru baaso ichaain, osa que leeochaauru saruhin, naaonjoaain nenacaauru raain ");
INSERT INTO uraNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","usi charijibana jacanaacharanejeein nenaa jana jaonajaauruhane, ecu neein auhaauhaquiin chanaaurureein. ");
INSERT INTO uraNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Inae nitohanihane banate, esinae rauhijiriin Cana Coaunera jerenohin ichaain tonoraain nenacaauru, aiha enotone tocohaneein jiquihaquiin conohin niha cuurureein, canu Inaca Cana Coaunera Cojoanonaa que neein. Caa aitocoaaunne aonacurumiin irichonacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Charijieein teeinti, leinjiin oro rijijieein nenaa coreti tesoro eruha leinjiin cachane, nii eruhane jaaun teein conauteein ratiriin, rachoojoeein jitariin niicha sirii rucuhele que necorete nii cacha, nii niicha eruhi conautihane jaan atane coretihane coina. Nii rijijieeinte, itolere cachaacha jerei amurijiriin jataain nelateine Cana Coaunera Cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Charijieein teeinti, leinjiin recatoon, perla coretiin nenaa ariirijieein amuhin, inae nii perla coretiin nenaa eruhane, jataain nii corei eruhane coitucuhin rachoojoeein cuhin, rai rucuhele que jitariin necoreteein, nii niicha eruhi perla corete nii recatoon. Nii rijijieeinte, itolere cachaacha jerei amurijiriin jataain nelateine Cana Coaunera Cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Charijieein teeinti, nemuri cuhane rede jaaoruha ate mucuurerane jana, itolere ate mucuha nii niicha jaori redene, inae memoha ate caaunne jana carene ichoae inaain ate caohachaauru janijiin omari cuhane teein, nii baasooru foranacaauru jaaore nii ate mucuurera, nii rijiicha Cana Coaunera Cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Nitohaneein techu, inae cana janonaa satono que turuhane bana, caohachaain ichaonacaauru janijiin raain, baasoneein ichaonacaauru jaaorureein usi chariji bana jacaelanaala nenaa jana anjeraauru. Nii banate chanaa cuurureein auhaauhaquiin,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Niritiinte: “Caa inara rai caitoonjoan aonaaina coitucuhiche,” naain canacaanu caje bajaa Jesosone janane: “Enjeen, aihacaanura Curuaanaa,” naacaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nii jaunte: “Coaracuche nachuhinti leinjiin Cana Coaunera rai rauhi que cacha relaera- cacha relaanete, ‘Naaonjoaan caa Ena Turunaa Cana Coaunera Cojoanonaa Caohacha’ naain beein, ‘Naaonjoaan nii rauhi inoaesi’ naain nii ena canuhacha bei Cana Coaunera Cojoanonaa aina rauhi inoaesi que aitiin caohatiin cachaauru rai beein cachaauru relae,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Inae nii nereretanaa rijijiei parabola biha cachaauru raine nainaainte, jelai caje canacaanu aina amuhin rai nataneu turuhin, ecu nenaa sinacoca asaae enohin, ecu nenacaauru cachaauru relaane nunuhete Jesoso. Nii janate cojoelatiin: “Chuna jataain cojoelanaacojoai ichaane coinane maajeein nerelaete toritiin itolere coitucuhin ere. ");
INSERT INTO uraNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tana enuha caje itolere ichana inaera cacha calaohi nihane, jana rai neba niha Marihane. Nii jana rai nejeraauru niha Saantiaao, Jose, Simoon, Jodasi, naaonjoainurine. ");
INSERT INTO uraNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jana rai baihuru netonai cau cana aina ichaaoruhane. Chaa cajena jataain nainaain itolere coitucuhin aite,” naaure ecu neein aonajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Niritocuruhane jaunte inae Jesoso esenetaain nere tonorana jerecurene cachaauru. Nii jaunte acaauru rai: “Chunijiun cuhane jaaunrute niqui leinjiin profeta que suujua acateein coitucuure laurinelanaala nenacaauru cachaauru. Nete laen esenetaaurene laurineein nenacaauru naraaichuru. Niheichu nii loreri ichaohane jaaun nenacaauru niha natiin,” nae cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nii jaunte ecu arajiin cojoelanaacojoai ichaenelu, esenetaaureniha ecu nenacaauru cachaaurune jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nii banate, Calileea batane curuaanaaneein niha Erodesine jaun, nii amuhemuheca Jesosone coitucuriin: ");
INSERT INTO uraNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Acate, Joaan Baotisitane. Inae o caje ichanacaihara. Acanihane jaunte, nii cojoelanaacojoai ichana nainera,” naain jetao ereereje Jesoso que rai letonocuru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Rai nocoala Ferifi comasai Erodiasi siriha comasaine que Erodesine jana jetaote: “Jiaonriha chocoala comasai sirii ii comasaine quera,” naa Joaanne coreniha jetao, caresero cuhane Joaan enoaeratelu cadena que ichoarateein Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nitohaneein caresero cuhane enoaain jetaote, Joaan sohin jaonaa jerihane niha natiin, ichana nainenelu Erodesi, satiin cachaauru Cana Coaunera letononiha Joaanne esenetaauruhane jaun, cachaauru coasiha. ");
INSERT INTO uraNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nejetaote, nejanoaane bajaanaa bitoaane coina beseta ichaa Erodesine jana jetao, nii beseta bitoaa turunacaauru acatiha raansae nii Erodiasi cacunu. Nii acaauru acatiha raansaa nii ranunane coaraain jetaote, jataain rautatiin coaraane jaun, ");
INSERT INTO uraNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","niicha jerei bajaa caje nii ranunane, Cana Coaunera notaracaae rai tihane coina aite Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nii jaun jetaote, rai neba suujuatenojoineein Erodesi rai: “Canu rai aihane, leinjiin ojoaichu cuhane Joaan Baotisita coturi uhaau caraicha,” naa nii ranunane jaun ");
INSERT INTO uraNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","inaderae rey Erodesi. Nejetaote, satiin niicha cotihacuri acatiha teein Cana Coaunera notaracaae, niicha jerei bajaa caje nii ranunane rai tihane coina aitohane jaun, ");
INSERT INTO uraNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","caresero cuhane niha Joaanne jana coturi moloherateein raerate. ");
INSERT INTO uraNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nii jaun jetaote, leinjiin ojoaichu cuhane Joaan coturi amaain teeuruha nii ranuna raine jaun, neba rai te nii ranuna. ");
INSERT INTO uraNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Inae nitohaneein teratiha Erodesine coitucuhinte, Joaan jaberoco raain conauteein ratiriin, biha uure Jesoso rai Joaan sacuureraauru. ");
INSERT INTO uraNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nii jaunte, rai beeuruhane caje coitucuhin, nii nihane jaan jelai caje canacaanu aina amuhin, canacaanuhacha aina leinjiin bote cuhane fauhin, neniha cachane jaan cue Jesoso. Nete nii bote cuhane fauhin amuhacaanu Jesoso ainane coitucuuriin, neseeuru cajeeuru uhacoaain sacuure atanechoae uhi cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Inae niicha coinetihu turuhin, bote caje fauhin, iniha cuha Jesosone janate, najiniha cunaitenacaauru uhaain arajiin neeuruha cachaaurune jaun, cairichaaojoaain acaauru coaraane jaun, niicha uhaauri cunaitenacaauru rautae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nii jana, inae nocohena jerihane jaunte, Jesoso rohan nichuuntaain: “Chajaain caa cachaauru rai necoeeute, nenajaun cauha cuuruhinete, ucuhae rai lenone coretecurumiin. Coatiha caa jana ichaohi cacha,” naacaanune jana: ");
INSERT INTO uraNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“Chajaain inara acaauru coroaateeuche. Coatiha caohacharihei ena caauruhane,” naa canacaanu rai Jesosone jaun: ");
INSERT INTO uraNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Nihei canacaanu rai lenone. Saoquijieein faan, itaque jerajejeein ate, naajeeinchate neeje,” naacaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Cajiha carai uhauuche,” naain ");
INSERT INTO uraNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","omane choae nelauriaauruha cachaaurune coina aitiin, biji cuhane nii ate aina faan mucuhin teberiaain: “Narihara Cana Coaunera,” naain Cana Coaunera bajaain cataun nii faan teruhin aina nerelanaa nichaanune rai te Jesoso, chaluhacaanune coina. ");
INSERT INTO uraNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nii jana satiin cachaauru naineein chaluhacaanune janate, que lenoneein obeecuruhane jana, jaiti cautihane jaun, rai caute que lechoonca coroata omarii, omari memoaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Canaanaihunru aina enecuru janijilanaala, quichaauruhacha janijiinte, saoqui oaraancai cachaauru nii lenonecure. ");
INSERT INTO uraNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nii baihate, ecu nedaain cachaauru rai necoihane tonohanau, bote cuhane fauhin ichoaichaniha nemuri jera jaaohacaanune coina aina nerelanaa nichaanune letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Inae cachaauru rai necoihane baihate, jelai caje amuhin, acaachanejeein ichatane ucuuno que cue, ecu Cana Coaunera bajaane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Inae nocohejihane janate, cuu acaachanejeein niha Jesoso nii ichatane ucuunone jana, inae coriaeneein cue nii bote, atane auha caje. Nii jana, mijiaaineein uha cujuana aina fichafichanaane jaunte, amusine nii bote. ");
INSERT INTO uraNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nii jana inae janonaa jerihane janate, nii ichatane ucuuno nihane caje uhin, canacaanu caaijie uhe Jesoso acau ichoae rurujueein. ");
INSERT INTO uraNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nii jana acau ichoae rurujueein uhane coaraainne, coasiha cojioriin: “Nechu aansai coitucuchuhite aicha,” naacaanu aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nii jaunte: “Coa nesoonetoache. Canune aihunra,” naain canacaanu rai iriha Jesosone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","“Ii aaine, jereeune ii rene tiaain uhe acau ichoaera Curuaanaa,” naa Jesoso rai Fedorone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Chajaaujian,” naa Jesosone jaun, bote caje fauhin acau ichoae cuhin ruruje Jesoso rene cuhin Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nete jataain mijiaaineein uha cujuana aina fichafichanaane coaraain, nesoonetohane jaun, asaaun naluha cue Fedoro. Inae naluhane jaunte, nesoone caaun auhaquiin: “Curuaanaa, canu comaleeu,” naa Fedorone jaunte, ");
INSERT INTO uraNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","biji que mucuhin: “Chanuna jataain cha esenetaeneei. Chanuna necoatohi,” nae Jesoso, Fedoro rai. ");
INSERT INTO uraNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Inae bote cuhane faauruhane rijieeoritiin, nesuruha nii fichafichanaa aina cujuanane janane, ");
INSERT INTO uraNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jesoso acatiha neseeonraain: “Iite esinae rauhijiriin Cana Coaunera Calaohineeincha,” naacaanu satiin nii bote cuhane cuinichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Inae nii nemuri jerau turuhinne, Jenesaree batane que turuhacaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nii Jenesaree bataneu turuhacaanune janate, Jesoso coitucuure ecu ichaonacaauru cachaauru. Nii jaunte, jelai batane sacuritiin ecu turuha Jesosone coitucuhin, rene cunaitenacaauru uhaacoaain ");
INSERT INTO uraNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","turuhin, caje acaauru rautana nainihane bajaaure, jeriha Jesosone rai cajione auha mucuuruhane coina. Nii rai cajione auha mucuurera cunaitenacaaurute satiin nerautaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nii janate, Jerosaleen caje turuha uure Jesoso coaraa, Moisesa aitoonjoan rauhi que cacha relaaureraauru aina fariseeocuru tabaauru. Acaaurute, Jesoso rohan nichuuntaain: ");
INSERT INTO uraNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Chanuna aihuruhalu canacaanu inoaesihurune rijijieein neeurene caa ii aina nerelanacaauru. Chanuna jeriha canacaanu ichaone rijijieein lenonecuruhane ajiniha, jauriaanejeein biji culeecurene,” naain Jesoso caje bajaauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","“Chanunajian inara netonai Cana Coaunera aitoonjoa tonoraelanaala, inara ichaohacha sacuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nitohaneeichene jaunte: ‘Ii inaca, ii neba, naaonjoainuri ere tonoraain caohachaain ichaaoche. Necha ansai, naain baasoneein rai inaca, rai neba, naaonjoaain que ereein neite ateinanohiniha cureein,’ naa Cana Coaunera Quiricha Inoaensi cuhane natiin tonoraelanaala ichaohiche. ");
INSERT INTO uraNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Cana Coaunera Quiricha Inoaensi cuhanete niqui ne rauhi, satiin cacha, rai fojiaraauru rai cha teein nihane coina. Nete inara: ‘Coatiha inara rai cha tenaa nainihaaun, satiin quiicha sirii inae Cana Coaunera que banijiaaineein nihane jaun,’ naain erei cacha, inaca, neba, naaonjoain rai chaelai tenaa nainenihane que aitocoiche. Nitohaneeinte, Cana Coaunera aitoonjoan que jaolecohin tonoraeneeiche, nechu jataain inara ichaohacha sacuhichene coina. ");
INSERT INTO uraNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Esinae rauhijiriinte, necha ansaineein neeichene que aitiin, inara que laenaelu Cana Coaunera Ere bera profeta inoaensi Isaihasi: ");
INSERT INTO uraNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Caa cachaaurute, rai nereecha que canu coroajeein neeure. Jana acaauru suujua cuhane aihuruhi. Cacajete coriaae ne acaauru suujua. ");
INSERT INTO uraNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nii jaun, nii chaque nelatejeehai, netaojiaain canu coroaaecuruhane nechu jataain acaauru relaauruha cachaaurune que nejesinajeein ita relajeein neeuruhane jaun,’ naelu inara que Cana Coaunera Ere bera inoaensi Isaihasi,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Niritohane baihate, nii ecu nenacaauru cachaauru cotijiaain: “Caohachaain caa inara rai aitocoaaunne aonacuchete coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Coatiha baasoneein cacha ichao aasaehai joaereen lenone canaacha quii. Baasoneein suujua cuhane niicha coacui, nujuae caje mitunaate laen, baasoneein cacha ichao aasaje,” naainte acaauru rai beebeje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nii janate rohan nichuuntaain: “Nii aitohine aonajeein jataain ii que nererojoecaauruha fariseeocurune aonaaina,” naain caje bajaacaanu aina nerelaa nichaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","“Niicha temunojoinelanaala nenaa ajaenate, cojoaisi aina curuataain rocohin jaoreein Cana Inaca Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aihane jaun, coa acaauru rerohecaachete nainaaurumiin. Maosa rijijieein neeuruhane rijijieein nenacaauru relaeraneein neeuruhane jaunte aitocure. Chaen techu leeocha maosa amanaa jeriha leeocha maosane, jiniiquiin atane jachu cuhane naluhin nitajeeururihane rijiichuruhane jaun aitocure,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nii janate Jesoso rai: “Canacaanu rai, nii aitohine jaan beeune coitucuhacaanu,” naa Fedorone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Inara niha natiin inachura coitucueneeichete. ");
INSERT INTO uraNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tana satiin cacha ujuae cuhane enonaa, cacha suri cuhane cuhin, nii baiha cacha jaberoco caje mituhane coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jana cacha ujuae caje mitunaate, cacha suujua caje mituhe. Niite laen baasoneein cacha ichao aasaerane. ");
INSERT INTO uraNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","20","Nitohanihane jaunte, cacha suujua caje mituha itolere baasone jaun, sonajaain jaohin, sinijeranelanaala nenaa ene aina ichaohin, asijiauhin, casejenetiin, ita cotaain, naaonjoaan cachanete laen, baasoneein cacha ichao asaaerane. Jana nitohaniha cana ichaone tonoraelanaala cana biji culejelanaala lenonichaane, coatiha baasoneein cana ichao aasaehai,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jelai caje amuhin Tiro, Sidoon, naaonjoainuri batane nichae cuha Jesosone jaun aina cuhin, ");
INSERT INTO uraNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","inae ecu turuhacaanune janate, eheehequiin: “Curuaanaa Rabiri nefoerate, cairichaaojoaain canu coaraau. Moconajaera siriha canu cacunune jaunne aitoonchera,” nae canacaanu caaijie uhin leinjiin Canaaun bene, natane caje uhin ecu ichaonaa. ");
INSERT INTO uraNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nii jana inauheneecha aonajian Jesosone jaunne: “Chajaain caa ene rai aitoote amuhine. Nete cana caaijie uujueein eheeheque,” naacaanu rohan nichuuntaain aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nii jaunte: “Cana Coaunerate rai cachaneein nenacaauru Isaraeli cocoaichacuru nitajeeuruhane rai nenacaauru reneecha caletoaelu,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nete, nacatiha neseeonraain: “Canu coroatajaneeuchera Curuaanaa,” naa rai nii enene janate: ");
INSERT INTO uraNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","“Coatiha caohacharihei Cana Coaunera cachaneein nenacaauru que banijiaain nenaa ruluhin remaae rijijieein neinequichene rai tihanuchenera,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Aihachechuhisi niquicha Curuaanaa. Nete remaae rijijieein canacaanu coaraaichene niha natiin, atiin canu coroatajaneeuchera Curuaanaa,” naain Jesoso tonorae nii ene. ");
INSERT INTO uraNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nii jaunte: “Quesenetaaine corenihate, inae ii jerenohi rijijieein nerautareein nii ii cacunuchera,” naa Jesosone rijieeoritiin, inae nerautae nii rai cacunu. ");
INSERT INTO uraNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jelai caje amuhinte, Calileea conemuri auhaniha turuhin, ichatane ucuunno que iniin, ecu nelauriaain lauheque Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nii janate, rene netaojiaaure arajii cachaauru, bacosacuru, maosacuru, biji que jiuronacaauru, erenaacharaauru, leeochaauru arajii cunaitenacaaurune maajeein uhaacoaain, Jesoso acatiha tenajaauruhane acaauru rautaane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nitohaneein rautanaacane janate, inae nerautaain, nichaauraain, amuure bacosacuru, maosaneeuruhane caje conoe maosacuru nota, inae nerautaaure biji que jiuronacaauru, erenaacharaauru niha natiin inae ereeure, naaonjoaauruhane coaraainte, jataain cojoelatiin, Cana Coaunera Isaraeli Coaunera coroaecure nii ecu neein coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nii janate, aina nerelanaa nichaanune cotijiaain canacaanu rai: “Inae jataain cairichaojoaain caa cachaauru coaracaaun. Inae nichata janoha cau canu aina neeuruhane. Nii jana nihei acaauru lenone. Naininaaun coroatenajaelanaala acaauru letoaanu acaauru nenajaunne. Mijiintena caaun aterocuruha bero cuhanene coataa,” naa canacaanu rai Jesosone jaunne: ");
INSERT INTO uraNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","“Chuna caa araaine cacha rai lenone erurichaache, neniha cachane jaaun nihacache natiin,” naacaanu aina nerelanaa nichaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Inatajajeein nihun faan siriquiche,” naa canacaanu rai Jesosone jaunne: “Caainsinejeein faan, coroatajajeein ate, naajeeichate neeje,” naacaanune janate, ");
INSERT INTO uraNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","atane ichoae nelauriaauruha cachaaurune coina aitiin ");
INSERT INTO uraNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","rai biji cuhane faan aina ate mucuhin, Cana Coaunera bajaane baiha, cataaun taturiin aina nerelanaa nichaanune rai te, cachaauru rai chaluhacaanune coina. ");
INSERT INTO uraNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nii jaunne, satiin cachaauru rai chaluhacaanune jana, inae nainaain lenonecuruhane saijieein cautihane jaun, rai caute que caainsine omari memoaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Canaanainuru, enecuru, uha elone jaun tabaacoaa nucuhecuru aina uha cujuana tabaine janijilanaala quichaauruhacha janijiinte jena oaraancaaure nii lenonenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nii lenonecuruha cachaaurune baihate, cachaauru rai necoeein, leinjiin bote cuhane fauhin, Maadala batane que cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nii janate, Jesoso coaraa uure fariseeocuru aina sadoseeocuru. Nitohaneeinte inae rene turuhin coulurujueeuruhane jaanu leranu ariha, acaauru rai cojoelanaacojoai ichaane coina aitocure. Chaen esinae rauhijiriin, Cana Coaunera letono nihane coitucuuruhane coinane maajeein. ");
INSERT INTO uraNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nete acaauru rai: “Charijieein teeinti, sonaina cafarane nocohaca dedene: ‘Caohatorichaain janonaa,’ naain ereeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jana, janone cafarane nocohaca dede nijichoriaaojoaaine: ‘Urichaain elo,’ naain ereeiche. Nitohaneein dede caje itolere coitucuhin naaonjoaainchene natiin, chanuna jana: ‘Naaonjoaane coinate caa aicha,’ naain caa enene cojoanonaa coitucunaa naineneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Caa cachaauru nechu aansaineein suujua coitucuelanaala nenacaaurute, cojoelanaacojoai ichacaaunne coina canu rai aitocure. Nene inae acaauru que coaaratesihalu Jonasine jaun inae nenacaeneein acaauru que cojoelanaacojoai coaaratenaa jereneeun,” naane baiha acaauru ratiriin, jelai caje amuhe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Inae Calileea conemuri jerau cuhacaanune jaun faan baiteein ratirihacaanu aina nerelanaa nichaanune jaunte: ");
INSERT INTO uraNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Aonacuche. Faan jorera rijiicha fariseeocuru aina, sadoseeocuru ichaone que necohalajihuche,” naa canacaanu rai Jesosone jaunne: ");
INSERT INTO uraNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","“Chanuna caa aite. Faan uhaenihacachene jaunna caa aitohate,” naacaanu ita raine aonajeeinte: ");
INSERT INTO uraNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","“Chanuna faan uhaeneeinchene que aitocoiche. Jataain asaaeriinchate quesenetaaiche. ");
INSERT INTO uraNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tachu jaiti nainaquiche taolu saoquijiei faan chaluheratihanu, saoqui oaraancai cacha raine jana, inata omariin rai caute taojiaaichelu. ");
INSERT INTO uraNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Niheichu taolu, caainsinejei faan chalueratihanulu jena oaraancai cacha raine coaauheeiche, inata omariin jana rai caute taojiaaichelu. ");
INSERT INTO uraNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Chanuna faan que inara rai aitenihanune que nainaeneeiche. Faan jorerera rijiicha fariseeocuru aina sadoseeocuru ichaone que necohalajihuche,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nii jaunne, faan jorerera que aitelanaala, cacha relaauruha fariseeocuru aina sadoseeocurune que aitoha canacaanu rai Jesosone que nainacaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Inae Filipo Sesareea batane que turuhinte, aina nerelanaa nichaanune rai: “Tonacuruha cachaauru, Cana Coaunera Calaohineein cacha caje nejanoanaa nichaaunne que,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Tabaaurute, Joaan Baotisita niha, ii beeure. Jana tabaaurute, Irihasi niha, ii beeure. Jana leeochaaurute, Jeremihasi niha ii beeure. Jana tabaaurute, chunocoha Cana Coaunera ere bera profetane caiha, naaure,” naain tonoraacaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Tonaquiche jana inara. Cha nichaaun jana Canu inara rai,” naain canacaanu caje bajaa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","“Iite esinae rauhijiriin ichaaohin nenaa Cana Coaunera Calaohi Mesihasineei,” nae rai Simoon Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nii jaunte: “Raotojoeeinte rausiaaenojineein neei, Jonasi calaohi Simoon. Chuni cacha ichei benihane janate, Canu Inaca Cana Coaunera ii que canu coitucuerate. ");
INSERT INTO uraNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jana iite Fedoro neei. Canune ichei aitoon. Iite canuhacha tei ajeri rijijieein, canu coitucuuruha canu cachaneein neenihurune coina icharaneein neriquiin. Nii ii que canuhacha icharatei amuritonaa nainerinaain chuni, onaaniha natiin itajenaa nainerinaain. ");
INSERT INTO uraNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ii raine, Cana Coaunera Cojoanonaa que nenaa naineeine coina, ichei chabi tereeunni. Caa chauratane que netiin, iicha ichaite, Cana Coaunera Cojoanonaa que nereein. Jana caa chauratane que netiin, jaolecohine jaante, Cana Coaunera Cojoanonaa que tihane bana jaolenereein,” naa Simoon Fedoro raine baihate: ");
INSERT INTO uraNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","“Jiaonriha chuni rai: ‘Acate Mesihasine,’ naain beeichene,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Inae mainajiriin cairichaaururichaain Jorioocuru bichauhenaauru, saseredotecuru curuaanaacuru, Moisesa rai Cana Coauneraacha tei rauhi que cacha relaaureraauru, naaonjoainurine catainaane jaunte, Jerosaleeun curichaainne beebeje aina nerelanaa nichaanune rai Jesoso. Sohin jaaoruhane nichata janone cuhane ichanarihanine que aitohane jaunte, ");
INSERT INTO uraNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","jelai Jesoso teteriin: “Jiaonriha nitohaneein chetecuruhane jeriha Cana Coaunerane Curuaanaa. Nitohaneein chetena nainecuruhi jerihane,” naain caohatiha Fedorone janate, nauriteriin Fedoro coaraain: ");
INSERT INTO uraNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","“Naain cacaje amuura moconajaera. Nechu canu cairichaeranu quete aitohicha. Cana Coaunera jerenohin aina, cha coitucunaa nainiheei ii. Cachaauruhacha jerenohinchate coitucuujueei,” naane baihate: ");
INSERT INTO uraNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","“Chunocoha canu esenetaain, canu aina nerelanaa jerihane, rainuhacha que niicha coacuhi jianeein, itolere necairichanaa abaataain canu sacuhine. ");
INSERT INTO uraNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jana canu colane rai nichao ichoteratena jererate, rai nichao itajereein. Jana, canu coreniha necairichanaate, rai nichao ichoteratereein. ");
INSERT INTO uraNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Coatiha chaque nelatihei, itolere niicha jerei, niicha coacui sirihane nihanatiin, nichao itajiha cachane. Inaaonjoaain coretihane niha natiin, nii nichao ichoteratena nainihei cacha. ");
INSERT INTO uraNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Inae Cojoanonaa que turuhane banane turuha ureeunni esinae rauhijiriin canu- Cana Coaunera Calaohineein cacha caje nejanoanaa nichaaunne, canu Inaca Cana Coaunera necaohacha que necaohachaain, rai letonocuru anjeraauru aina jiniiquiin. Nitohanihane banane, le cachaauruhacha ichai cainareeunni acaauruhacha ichai rijiinanaain. ");
INSERT INTO uraNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cau caa ena nenacaauru tabaaurute oorenereein, itolere curuaanaa neein nihanune coina turuhanu cacha caje nejanoanaa nichaaunne Cojoanonaa coaraane reentiaaojoaain,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nitohaneein atinaaururichaainne bihane baiha, saota janonejeeinte, Fedoro, Saantiaao, Saantiaao ocoala Joaan, naaonjoainuri amaain jelai acaauruhacha aina jataain ucuuneein nenaa ichatane ucuuno que cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Inae ecu turuhin jetaote, acaauru acatiha netiin, necoriha Jesoso jaberocone jana, rai nomeri netonai enoto tocohaneein jiquihacohane jana, rai cajione netonai cono tocohaneein jiquihaque. ");
INSERT INTO uraNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nitohaneein necoriha nomeri aina rai cajionene jana jetaote, Jesoso rene ecocohin aina ereeuruha Moisesa aina Irihasine jana coarajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nii jaun jetaote Jesoso rai: “Curuaanaa, caohatoha cau nihacachene. Ii jereeinene nichatajaain loanari jareeunni, leinjiin ii rai, leinjiin Moisesa rai, leinjiin Irihasi rai, naaonjoaain,” nae jetao rai Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Niritiin ereereeca Fedorone jana jetaote, luhecotariin jiquihaquiin acaauru conaacotaa dede sacarine jana jetao: “Caate jataain belaain janijiin quiicha cocoainai Canu Calaohi ne. Rai nere tonoraain neeuche,” naain jetao toni nii dede sacari jana erenaa. ");
INSERT INTO uraNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Niritiin toniha erenaane aonaain jetaote, atane ichoae comoore jataain coasina caaun, nii nichatajaain aina cunacaauru aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nii jana jetaote, acaauru rene nichuuntaain mucunajaain jetao: “Nimichucuche. Coa casihache,” naa Jesoso acaauru raine jana, ");
INSERT INTO uraNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","coaracuruhane jana jetao, inae neniha chuni ainane jana, jelai acaachanejeein ecu ne Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Inae nii ichatane ucuuno caje jeelaiha fauha cuuruna jaun jetaote: “Jiaonriha chuni rai caa inaraacha coarai beeichene, Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne ohanune caje ichanacaaunne reentiaain,” naa aina nerelanacaauru rai Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","“Chanuna jana chaen: ‘Irihasite jaurihanejeein turuha ureein,’ naaure Cana Coauneraacha tei rauhi que cacha relaaureraauru,” naain jetao Jesoso caje bajaaure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nii jaun jetaote: “Esinae rauhijiriin Irihasite ichoaichaniha turuha ureein. Acate itolere rucuhereein. ");
INSERT INTO uraNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nena canu inara rai aitoon. Nii Irihasite inae ichoaaichaniha turuhelu. Nete, acanihane coitucuelanaala que nocoatijiaain, mainajeriin cairichaaurelu. Nii rijijieeinne acaauru bijiu necairichaa cureeunni Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne,” naa acaauru rai Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Joaan Baotisita que, acaauru rai aitoha Jesosone que nainacure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Inae nii cachaauru aina nihacaanune jaan turuuruhane janate, Jesoso rohan nichuuntaain, nacatiha neseeonraain: ");
INSERT INTO uraNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Curuaanaa, cairichaaojoaain canu calaohi coaraau. Araain saainte mijiaaineein mucuha rai cunaine, usihanauniha natiin comohin, acauhanau niha natiin naluhe. ");
INSERT INTO uraNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ii aina nerelanacaauru raine niqui teeun, nete rautasihurene,” nae rai leinjiin cacha. ");
INSERT INTO uraNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nii janate: “Cha esenetaain, caohachaain suujua coaranacharaauru cachaauru. Cha carajaneeina inara aina neein inara relaain, inara abaantareeun. Cajiha canu rene nii canaanai uhaauche,” naain ");
INSERT INTO uraNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","nii canaanai caje coitucuchuhi sitaa Jesosone rijieeoritiinte inae nerautae. ");
INSERT INTO uraNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nii baihane, jelai Jesoso teteriin: “Chanuna jana canacaanu coitucuchuhi sitanaa nainesinihacaanu,” naain Jesoso caje bajaacaanu aina nerelanaa nichaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Jataain aasaaeriin esenetaaichene jaunte, rautana nainesineeiche. Esinae rauhijiriin mosatasa ucuhe tabaainejeeinijin esenetaaichene jana nihanete, caa ichatane ucuunno rai: ‘Caalai caje amuhin, tajiha cunihun,’ naaichene amure jelai caje. Nihei chanerihei inara rai cha, rauhijiriin esenetaaichene. ");
INSERT INTO uraNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nete laen, catohanei moconajaera letono, cana suri couu neein Cana Coaunera bajaae bajajeein sitanacai ne,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Inae nii canaanai caje coitucuchuhi sitaane baiha, jiniiquiin Calileea batane que amuhemuhecaaunne janate, aina nerelanaa nichaanune rai: “Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunnete necha aansaineein nenacaauru cachaauru bijihu canu tiha cuurureein, ");
INSERT INTO uraNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","casohin cajaaoruhane coina. Nena, nichata janone cuhane ichanareeunni,” naain aina nerelanaa nichaanune rai biha Jesosone jaunne, jataain inaderaacaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Niicha relainichaanune aina jiniquiin Caferenaaon turuha Jesosone janate, Fedoro coaraa uure, Teenforo asaae cacha caje coriqui bajaaureraauru. Inae Fedoro rene turuhinte: “Coriqui tihana Teenforo rai nii inara relaera,” naain caje bajaauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Ejeen, coriqui tiha,” naain acaauru tonorae Fedoro. Nii janate inae loreri asaae enoha cuhacaanune jana, Fedoro rai: “Tonaai iite Simoon. Charijihuru caje coriqui bajaaure caa chauratane que nenacaauru cachaauru curuaanaacuru. Rai lauri cajena. Ainihane, laurine lanaala nenacaauru cajena,” naain bajaa Fedoro caje Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Laurine lanaala nenacaauru cajete bajaaure,” naa Fedorone jaunte: “Nitohaneein, acaauru lauri coretena nainenihane chujian, cana netonai coretena nainerihaaca. ");
INSERT INTO uraNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nete nabana chunocoha acaauru caje nenaa baijiaera tocohanihacane coataa, caohachae coretichaane. Chajaain taa nemuri cuhane ate cojunihu. Chaen jauriaanejeein dadaera ate raain, rai nujuaaen cuhane coaraainete, cuhane nereein coata caje coriqui. Acaachate nainejereein que canu rai aina ii rai impoesto coretichaane. Chaen amaain coretenihun,” nae Fedoro rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nii rijieeoritiinne, Jesoso rohan nichuuntaacoaain: “Charijicha jataain nelateineein ne Cana Coaunera Cojoanonaa que,” naain caje bajaacaanu aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nii jaunte, leinjiin canaanai cotijiaain, canacaanu cataaun teein: ");
INSERT INTO uraNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Esinae rauhijiriine aitoon. Inara ichao coreein, aiha caa canaanaine rijijieein nenaa naineneeichene, coatiha Cana Coaunera Cojoanonaa que nenaa naineriheeicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cana Coaunera Cojoanonaa que nelateineein neite, leeochaauru amurijiriin nenaa coacuelanaala, aiha caa canaanaine rijijieein rai nichao coreein ne. ");
INSERT INTO uraNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chunocoha, canu coreniha leinjiin canaanai raerate canu raa aicheein,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Chunocoha, caa ena Canu esenetaeraauru canaanaihunru saruheraniha osa quene, nuluno que ajeri jaberoco tijichaain, cucuana ucuaano jelon joaeraanete caohachae. ");
INSERT INTO uraNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jataainte cairichaaojoaaure caa chauratane que nenacaauru cachaauru, enaaicha osa que sarunojoineein neeuruhane jaun. Itolere banate nitohaniha cureein. Nete acaauru amuritoheriin jataain cairichaaojoareein nii osa que acaauru saruhera cacha. ");
INSERT INTO uraNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nii jaunte caohachae, ii biji, ii tijia, naaonjoain osa que ii saruhin nihane, molohin jaohine. Nenacaeneein tejian caohachare, ii biji, ii tijia, naaonjoain mauhecaain ichaonaa esine que neeine. Nabana, ii biji, ii tijia, naaonjoain, ii saruhane coreniha, satiin ijiabereeo chabana jacanaacharanejeein nenaa usi jana nijiaohine coataa. ");
INSERT INTO uraNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jana, ii nota, osa que ii saruhane, rocohin jaao. Nenacaeneein tejian caohachare, leinjiin ii nota aina ichaonaa esine que neeine. Nabana jerane ii nota aina jiniiquiin chabana jacanaachara usi jana nijiaohine coataa. ");
INSERT INTO uraNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jiaonriha, chunocoha caa canaanaihunru que jaolecohichene. Dedeeu neein itolere bana acaauru beraihuruha Ofa Cana Coaunera rohan neein rai letonocuru anjeraaurune jaunne inara rai aitoon. ");
INSERT INTO uraNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Canu- Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunnena, nitajerai nenacaauru ichoterateraanu que turuhin neeun. ");
INSERT INTO uraNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Aonacuche. Tana leinjiin cacha, lefashaain niha rai carenerone jana, nitajiha leinjiinne, ichatane ucuunno que nii iscoon choonca iscoonni ratiriin, ");
INSERT INTO uraNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","nii nitajenaa ariin eruhane, nii iscoon choonca iscoonneein nitajelanaala nenacaauru coroaecane amurijiriin, esinae rauhijiriin niicha eruhi coroaerihane. ");
INSERT INTO uraNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nii rijijieeinte, nii leinjiinejein nitajeeuruha caa canaanaihunrune jerene dedeeu nenaa cana inaca Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Chunocoha leinjiin inara caje Jesocurisito coitucuera, baaso ichaain niha chunocoha raine, jelai teein cotijiaain baaso ichaain niha raine coitucuerateein rai raotojoeein ereeine, nii rai irihane jana rai nere tonoraain coitucuhin nihanete, inae jataain raotojoeein neriquicheein jiniiquiin. ");
INSERT INTO uraNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jana ii ere tonoraenihane, leinjiin coroatajaainniji cotijiaain, acaauru aina jiniiquiin rai ereeuche, ii coroatajanena nainecuruha nii leeochaauru netonaine coina. ");
INSERT INTO uraNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jana, acaauru ere nihanatiin tonoraenihane, netaojiaain Cana Coaunera coroaeraauru rai beein, acaauru rai teeute rai ereeuruhine. Nii netaojiaain Cana Coaunera coroaeraauru ere tonoraenihane, Cana Coaunera coitucuelanaala nenacaauruneein teein, Roma curuaanaa rai cacha cobaraain coriqui bajaaurera rijijieein coaracuche. ");
INSERT INTO uraNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Caa chauratane que netiin, inara ichanohite, jerichanejeein dedeeu icharareein. Jana, caa chauratane que netiin jaolecohichene jaante, dede caje jaonojoinereein. ");
INSERT INTO uraNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Caa quene inara rai aitoreeunni. Caa chauratane que netiin, ita que jerajejeein neein ita suujua rijijieein coacuhin Cana Coaunera bajaain, cha bajanaa jeriquichenete, inara rai inaraacha bajai tereein canu inaca Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chunijiun neeichene jaaunru, Canu coreniha, coroatajaain, nichatajaain, naaonjoaain netaojiaain neeichenena canu netonai, ecu inara aina nereeunni,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","“Curuaanaa, inata saain canejera que casuujua acatichaaunne caohachae, baaso ichaain niha caraine, caainsi saneeina,” naa Fedorone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“ ‘Coatiha, caainsi saneein,’ nahaaun. ‘Caainsichoonca saneein caainsinei quene aitoon, ii suujua acateeine coina,’ ” nae Fedoro rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nitohanihane jaunne, naaonjoaa Cana Coaunera Cojoanonaane que inara rai aitoreeunni. Aonacuche. Rebe rucuhena jeriha leinjiin curuaanaa reyne rijijiei nereretanaa quene inara relareeunni. ");
INSERT INTO uraNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Inae rebe rucuhena nunuhetihane janate, jataain arajiin que rebeeona rai cacha turuaa uure rene. ");
INSERT INTO uraNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nete, neniha cha coretihane jaanne jaun, jitariin bereecuru, rai sinijera, rai rucuheleeuru, naaonjoainuri aina curuaecaain, letononeein neeuruhane coina acaauru que necoretihane coina aite nii rey. Jitaain rai rebe coretihanereein tiaaojoaain satiin jiniiquiin amihaneeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nii jaunte, nii rey acatiha neseeonraain: ‘Curuaanaa, atiin caque ii suujua acateein, canu cohacorihune ii rai jitariin corete,’ naa rai nii cachane jana, ");
INSERT INTO uraNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","cairichaaojoaain coaraane jaun, nii rai rebe aninoaain que suujua acateein nirijieein jianerate. ");
INSERT INTO uraNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nete inae jianiha nii rebeeonajaane jana, caje cuhin rai corihanera que coroatajajeein rebeeona aina ita eruhin, nii rebeeoca quene coreniha mucuhin rai raro tororohin: ‘Caque rebeeoquine jaan coreteeu,’ naa raine janate, ");
INSERT INTO uraNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","nacatiha neseeonraain: ‘Canu que ii suujua acateein, canu cohacune ii rai jitariin corete,’ naa rai nii leeochane saijieein, ");
INSERT INTO uraNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","tonoraelanaala caresero cuhane enoaerate, cuu niha rebe jitaain coretihane reentiaaine coina. ");
INSERT INTO uraNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nitohaneein, caresero cuhane nii acaauru leeocha tihane coaraainte, jataain rautaaurenihane jaun, nii acaauru curuaanaa rey rai biha cuure leeochaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nii jaunte, que suujua acateein jianihane baiha nihane jaun, cotiharateein: ‘Nechu aansaineein ichaonaa cacha. Nii rebe coreniha rebeeoquine janane, ii que casuujua acateein, carichaaojoaine jaun ii jianeeunlu carai aitohine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Chanuna jana, nii cairichaaojoaain ii coaraain casuujua acatichaaunne rijijieein, nii ii leeocha que, ii suujua acateneei,’ naain, ");
INSERT INTO uraNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","inae jataain obaecane jaun, caresero cuhane enoaerate nii rey, jitaain rebe coretihane reentiaain,” naain nii nereretanaa que canacaanu relaane baihate: ");
INSERT INTO uraNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Nitohaneeinte inara casetecareein canu inaca Cana Coaunera, inara suujua aina cutaain inara amute cacha que inara suujua acateein belaineeichene,” naainte aina nerelanaa nichaanune rai beebeje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Niritiin acaauru rai irihane baihate, aina nerelanaa nichaanune aina Calileea caje amuhin, Jodea batane que turuhin, nucuhe Jorodaan jera que cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nii janate, arajiin sacuure cachaauru. Ecute arajiin cunaitenacaauru rautae. ");
INSERT INTO uraNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nii janate, nechu cairichaauruhane jaan lera ariha, Jesoso rohan nichuuntaain: “Tonaai. Caohachaana joaereen coreniha rai comasai jaoha cachane,” naauruha Jesoso rai fariseeocuru tabaaurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","“Tana Cana Coaunera Quiricha inoaensi cuhane laenanohineein nenaa ereretaain aonaquichene. Jaurihanejeein itolere coaunaane nunuheneeinte, quicha, ene, naaonjoaain coaunaelu Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nitohaneein acaauru coaaunaainte: ‘Rai fojiaraauru caje amuhinte comasai raain, leinjiin cachaneein nenaa rijijieein ichaaorureein,’ naalune coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nitohanihane jaunte, lesajeein necoansajiaa cachane, leinjiin ita jaberoco que jaberoconaa rijijieein neeure, rai comasai aina. Niheichu ita caje, Cana Coaunera tenojoihunru batunaa nainihei joaereen cacha,” naain acaauru tonoraa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Chanuna jana chaen, comasai jaonaa jerera nihane, rai ita jaaoruhane jaan cocoiricha teein, comasai joaera coina aitelu Moisesa tenojoi rauhi,” naauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","“Niritiinte aitelu Moisesa, nechu aansaineein nere tonorana jereneeichene jaun. Coatiha niqui jauriaanejeein nitohaneein niheilu. ");
INSERT INTO uraNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nena laen canu inara rai aitoon. Chunocoha, chuni quicha aina ichoaeniha rai comasaine jana, jaohin leeocha ene raanete, nii ene niicha rai coreniha inae osa que nesarue nii quicha,” naa Jesoso fariseeocuru raine janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","“Nitohanihane jaun chujian, caohacharihei necoasajiaa cachane,” naacaanu aina nerelanaa nichaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","“Coatiha nitohanai coitucunaa nainesihuruhi satiin cachaauru. Acaihanijin coitucuuruhane coina, coitucueratiha Cana Coaunerane jaan curuhachate, nii coitucuujueeurureein. ");
INSERT INTO uraNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Niha araai lauriin nitohaneein necoansaijianaa nainelanaala niha cachane jaanu. Tabaaurute, inae nejanoae nitohaneein necoasaijiaurenihane coina. Jana tabaaurute acaauru cule rocooruha acaauru amute cachaaurune jaun necoansaijianaa nainecurene. Jana leeochaaurute raotojoeein Cana Coauneraacha tei amihanenaa que amihaneeuruhane coina necoansaijianaa jerene. Nitohaneein ichaonaa jereraauru, nitohaneein ichaaoruhine,” naain ereereje canacaanu rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nii janate, canaanainunru uhaaure Jesoso rene cachaauru, acaauru rai Cana Coaunera bajaain, biji que acaauru mucuhin acaauru rausiaaecane coinane janane, acaauru que tacaain caohatihacaanu aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nii jaunte: “Coa Canu rene turuuruha canaanainunrune caohatihache. Cana Coaunera Cojoanonaate aihuruha caa canaanainunrune rijijieein nenacaauru raineein ne,” naainte, ");
INSERT INTO uraNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","bijique nii canaanainunru mucuhin rausiaae najaane baiha, jelai caje amuhe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nii janate, Jesoso rene turuhin: “Cacha relaera, chariji caohacha ichareeun, chariji bana nitajenaachara ichaonaa que ichaohanune coina,” naa leinjiin enamanaa Jesoso raine janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Chariji caohachana Canu caje bajaai. Caohachate ne leinjiincha. Nitajenaachara ichaonaa caohacha que ichaonaa jereeine, aitohalu Cana Coaunera rai Rauhine jaan tonoraain ichaao,” naa rai Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Chariji Rauhina,” naain baajaane janate: “ ‘Coa sonajaain jaoha. Jiaonrihachu, ii comasaine lanaala nenaa ene dadaain, asijiauhin, leeochaauru cairichaa casaje que ereein, naaonjoaain neeine. ");
INSERT INTO uraNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chaen ii fojiaraauru ere tonoraain, ijiabereeo belaaine rijijieein, chamute cacha belaain ichaao,’ ” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Jitariinne, nii chaitoonjoa tonoraaun. Chana nenacaaen carai lanare,” naa Jesoso rai nii enamanaane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“Esinae rauhijiriin, chaque lanaelanaala Cana Coaunera aitoonjoa tonorana jereeine, chajaain jitariin nii iicha sirii que necoreteein, cairichaaihuru rai tenihun. Nii banaachate, jelai amuritoeriin nereein iicha latei dedeeu. Nii baiha canu sacuu,” ");
INSERT INTO uraNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","naa rai Jesosone aonaainte, jataain inaderaain cauha cue nii enamanaa, jataain coriquihocane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nii jaunte, aina nerelanaa nichaanune rai: “Esinae rauhijiriinte caaintate, Cana Coaunera Cojoanonaa que enoha leinjiin coriquihonane. ");
INSERT INTO uraNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nacoauneeine aitoreeunni. Charijieein teeinti leinjiin toro seeonjoan amuritoojoaain nenaa camecho, oco jachu cuhane situnaa nainene. Nii amurijiriin enonaa nainihei leinjiin coriquihona Cana Coaunera Cojoanonaa que,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Niritoha Jesosone jaunne, jelai amuritoheriin canacaanu suujua elonaane jaun: “Nitohanihane, chariji jana enohin nichotenaa nainereein,” naacaanu ita raine janate, ");
INSERT INTO uraNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","canacaanu coaariin: “Nihei chuni raajenihane enohin nichotenaa nainihei. Nete laen Cana Coaunera jerihane joaenreein cacha enohin nichotenaa naine,” naa canacaanu rai Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","“Canacaanune, ii sacuhacaanune coina jitariin canacaanuhacha sirii ratirihacaanulu. Cha jana rarichaanuhin canacaanu nii coreniha,” naa Fedorone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","“Esinae rauhijiriinte, inae Cana Coaunera cojoanonaa que turuhane bana canu, Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne itolere cocoainanacaaihuri amurijijiriin cocoainanohi nichaaunne jaan rori- trono ichoae nelauriaanune banate, inara netonai lechoonca coroatajai cocoainanacai nequichene rori- trono ichoae nelauriariquicheein, nii lechoonca coroata lauriin nenacaauru Isaraeli cocoaichacuru ichanaa coaraain, ‘Acaauru acaaurute caohacha ichae. Jana acaauru acaaurute baaso ichae,’ naain beein coitucuhin rucuhequichene coina. ");
INSERT INTO uraNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Chaen techu, canuhacha icharatei ichacuruhane coina, rai bereecuru, naraaichuru, comasai, fojiaraauru, rai natane, naaonjoain ratirichate, lefasha saneein jelai amurijiriin eruurureein. Chaen techu, chabana nitajenaachara nejeein nenaa ichaonaa que ichaoreein. ");
INSERT INTO uraNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Chaen techu, caa ena leeochaauru amurijiriin nelaetoha nocoetonacaauru, caa ena chaque nelatihei rijijieein nenacaauru fautaain chaque nelatelanaala nedaaurureein. Jana ena caa leeochaauru fautaain nelatihei rijijieein nenacaaurute, jataain nelateineein neeurureein,” naain Fedoro tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","2","Niritoha canacaanu raine baihate nocoana que cacha amiharatiha leinjiin ocoana erorane rijiicha Cana Coaunera Cojoanonaane que canacaanu relae. Niritiinte: “Leinjiin cacha janohetiin nimichuhin, nocoana jana amihaneeuruha cachaaurune coina ariin, inae cachaauru eruhin, rai nocoana jana le jiichooneineein acaauru amihaneeo coretihane coina rucujueein, nii cachaauru letoae nii amihanenaa erora. ");
INSERT INTO uraNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Inae acaauru letoaane baiha, enoto chujutaaelalajeein nacoauneein mituhin cuhin leeochaauru cachaauru arihane janate, najiniha neeure nenaanaja cataaun nelanaaejeein cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nii jaunte, nii nelanaaejeeunruhane coaraane jaun: ‘chajaain inara netonai amihanenihuche canu ocoana jana. Inara amihaneeon rijijieeine inara coretereeunni,’ naa nii amihanenaa erorane jaun cuure nii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nii baihate coaiteen, enoto chujutaain mituhin cachaauru ariin, nii baiha sonaiha mituhin cachaauru ari nii amihanenaa erora. ");
INSERT INTO uraNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Inae nuna macohi ichoae teejiha enotone jana, mituhin nacoauneein cachaauru arihane jana, nenaanaja cataaun neeuruha rai namihaneeo colane nelanaaejeein cachaaurune jaun, erunajaain: ‘Chanuna sonafaajeein amihanelanaala neeiche,’ naain acaauru caje bajaa nii amihanenaa erorane jana: ");
INSERT INTO uraNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Neniha canacaanu rai amihanenaa terane jaunna, amihanenihacaanu,’ naauruhane jaunte: ‘Chajaain aihane inara netonai canu ocoana jana amihanenihuche,’ naain letoanajae nii amihanenaa erora. ");
INSERT INTO uraNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Inae nocohena jerihane janate, rai cachaauru beraicha rai: ‘Chajaain, nii cachaauru cotijiaain, acaauru satononiha turuhin amihanenacaauru que nunuheteein coretenaacu, nii jauriaanejeein nunuheteraauru que satonoteein,’ naa nii amihanenaa erorane janate, ");
INSERT INTO uraNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","inae ichoaichaniha cuuruha nii satononiha nuna macohi ichoae teejiha enotone jana nunuheteein amihanenacaaurune jana, le cachaauru corete jerichanejeein le jiichooneein, nii coretera. ");
INSERT INTO uraNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nii janate, inae nii ichoaichaniha turuhin amihanenacaauru coretihane jaan que turuhane jaun: ‘Nii satononiha turuhin amihanenacaauru amurijiriin jecha, rai namihaneeo core raaurureein,’ naaure. Nete, nii satononiha turunacaauru rijijieein, jerichanejeein le jiichoo coreneein raaure acaauru netonai. ");
INSERT INTO uraNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nii jaunte, rai namihaneeo core raauruhane ucuaaetoha nejesinajeein nii amihanenaa erora rai: ");
INSERT INTO uraNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Caa canacaanu satononiha turunacaaurute, basiinjiincha amihaneeuruhane saijieein, canacaanu coreteeine jeeoneein acaauru coreteei, mainajeein amihaneein, enoto ajaanone maajeein abaantacaanune saijieein,’ naaure. ");
INSERT INTO uraNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Niritocuruha nii amihanenaa erora raine jaunte, leinjiin rai: ‘Coatihana baasoneein ii coretihaaunte quiicha belaai. Tana canu aina, le janohineein ii coretichaaunne coina rucuhequine coitucuhine. ");
INSERT INTO uraNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Aihana jaun, nocoa ii amihaneeo core. Chajaain amuu. Canune, nii inara satononiha turuhin amihanenacaauru rai, jerichanejeein inara coretichaaunne jeeoneein coreteeun, ");
INSERT INTO uraNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","carai niha rauhi cacoriqui aina quiicha jerei ichacaaunne jaanune jaun. Raunajetocoaaunne jaunna baasoneein canu coaraaite,’ naain nii cacha tonorae nii amihanenaa erora. ");
INSERT INTO uraNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nii rijijieeinte, caa enene ichoaichaniha nenacaauru satononiha neeurureein. Jana satononiha nenacaaurute, nunuheneein neeurureein,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Inae bero cuhane Jerosaleen nichaae cuujihacaanune janate, nii lechoonca coroatajaain aina nerelanaa nichaanune cotijiaain, jelai canacaanu teteriin: ");
INSERT INTO uraNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","“Inae enate laen Jerosaleeun cuhacache. Ecute, Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne mucuhin, saseredote curuaanaacuru, chaen Moisesa rai Cana Coauneraacha tei rauhi que cacha relaaureraauru, naaonjoainuri rai canu tiha cuurureein. Chaen techu nejelau atane caje unacaauru cachaauru rai caetecurureein, caque nocoatijiaain, canu faojoaain coroso que canu teein canu ateinaauruhane coina. Nena nichata janojoin cuhane ichanareeunni,” naain aina nerelanaa nichaanune rai beebeje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nii janate, Jesoso rene turuha uhe Sebedeeo comasai, rai calaohichuru Joaan, Saantiaao, naaonjoainuri aina. Turuhinte, nii calaohichuru rai atiin chaelai ichaa Jesosone coina nacatiha neseeonriaane jana: ");
INSERT INTO uraNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Chate jerequicheta,” naain caje bajaa Jesosone janate: “Inae ii Cojoanonaa que turuhane bana, atiin ii raotono nichajai que nelauriaa leijiinne jana, ii jaabiji nichajai que nelauriamiinche caa leeochara,” naa Jesoso raine janate: ");
INSERT INTO uraNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Cha bajaaichene, coatiha coitucuhin bajaheeiche. Necairichanaa abaantarichaaunnine rijijieeinna necairichanaa abaantana nainequiche,” naain acaauru caje bajaa Jesosone janate: “Abaantana nainichaanu,” naain tonoraauruhane jaun: ");
INSERT INTO uraNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Nii necairichanaa abaantana nainequiche niqui. Nete laen, canu raotono nichajai que, canu jaabiji nichajai que, naaonjoaain nelauriana naineneeiche, nitohanai rai tihanune coina nenihanune jaun. Banihateein ichaalu Ofane jaancuruhacha raite, tenojoin niha cureein,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nii Jesoso caje bajaa Sebedeeo calaohichuru nebane aonaainne, nii coroatajai ita nejeraauru que nejeratihacaanu nii lechooncaain aina nerelanaa nichaanune. Nii jaunte, ");
INSERT INTO uraNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","canacaanu cotijiaain canacaanu rai: “Inarate rai cachaauru cairichaaeriin, acaauru amurijiriin niha nocohetiin neeuruha Cana Coaunera coitucuhichuru curuaanaacurune coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Nete laen, inara nitohaneein nenaa naineneeiche. Aihana jaun, chunocoha inara jana leeochaauru amurijiriin nenaa coaaucane, leeochaauru coroatajanemiin. Jana, chunocoha leeochaauru amurijiriin nenaa coaaucane, rai letononeein neeine. ");
INSERT INTO uraNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nitohaneein nihanune coinane cau turuhin neeun canu- Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne. Coatiha carai quiicha latei teein niha cachane coina cau turuhaaun. Canune, cachaauru rai nelatichaaunne coina letononeein neeun. Canune, osa caje nichotiha arajii cachaaurune coina ohin cacoichana que coretiha cureeunni,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Inae Jerico caje amuhacaanune janate, Jesoso caaijie uure arajii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nii janate, bero cuhane babaecooruha coroatajai maosacurune jaun, acaauru rohan situha cuha Jesosone aonaain: “Canacaanu Curuaanaa Rabiri nefoerateneein nenaa, tana cairichaaojoaain canacaanu coaraaine,” naauruha ehequiine janate, ");
INSERT INTO uraNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","aitocuruhane caohateeuruha cachaaurune jana, que rutaain tonijiaain ehehequiin: “Canacaanu Curuaanaa Rabiri nefoerateneein nenaa, cairichaaojoaain canacaanu coaraau,” naauru janate ecu inacuhin acaauru cotijiaain: ");
INSERT INTO uraNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","“Chatohanai inara rai ichacaaunne jeriquiche,” naain acaauru caje bajaa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Conoha canacaanu notanena jerichaanura Curuaanaa,” naauru jana, ");
INSERT INTO uraNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","cairichaaojoaain acaauru coaraane jaun, biji que acaauru nota dadaa Jesosone rijieeoritiin inae conoha acaauru notane jaun, Jesoso caaijie uure, nii coroatajai maosacuru. ");
INSERT INTO uraNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Inae Jerosaleen catainajeein leinjii nese Betafajee ichatane ucuunno- Oliboneein acaauruhacha curuaatei rohan turuhacaanune janate, aina nerelanaa nichaanune caje coroatajai letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Chajaain taa niita canaacha coarajei neseu cunichuche. Ecute, cositenojoineein leinjiin bene, leinjiin curuaanaa narejeen, naaonjoaain borocuru eruriquicheein. Chaen inae erunajaaichene, carai cajiha acaauru cosichuru rututaain uhanajaauche. ");
INSERT INTO uraNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Inae uhanajaaichene jana, chunocoa inara caje bajaane: ‘Latenaaca curuaanaane jaunna amanajaacaanu. Enate jelaiha acaauru cainaratereein,’ naain uhanajaauche,” naain letoanajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Nitohanihalu: “Sioon cocoaichacuru, joaenreen rijijieein nenaa inara Rey coaracuche. Acate, inara rene turuha uhe leinjiin boro laaojoiri ichoae. Cabario ichoae amuuruha leeochaauru curuaanaacurune saijieeinte, leinjiin boro anajiin tabai ruhacaera narejeen laojoiri ichoae uhe,” naain beein laenaalu profeta inoaensine nainaane coina ailu. ");
INSERT INTO uraNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Niritiin acaauru letoaa Jesosone jaun cuuruha nii coroatajai aina nerelanaa nichaanune caje cunacaaurune janate, nii beein letoanajaane rijijieein, ");
INSERT INTO uraNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","rai narejeen aina boro eruhin, nichoae cajione maritaain amanajaain, Jesoso rai tenajaaunruha aina nerelanacaaurune jana, nichoae lautoroaain cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nii janate, najiniha neeure arajiin cachaauru. Acaauru tabaaurute, bero cuhane acaauru cajione maririjiacoaaure. Jana tabaaurute, ajaena raain, najiniha meriaacoaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jana, ichoaichaniha cunacaaurute, acaauru caaijie cunacaauru aina coroajeein eheehequiin: “Rey Rabiri ichoala coroaaecuruhine. Raotojoeein turuhine acaneein nenaa rijijieein Cana Curuaanaa- Cana Coaunera letono. Dedeeune maajeein Cana Curuaanaa coroaaecuruhine,” naaure Jesoso que. ");
INSERT INTO uraNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nii Jerosaleen turuha Jesosone coaraainte, satiin nii nese sacutaain que suujua rerohecaain cajihaneei amuhemujueein: “Cha cajena unaa ne caa cacha,” naain ita caje bajaain: ");
INSERT INTO uraNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Caate, Cana Coaunera ere bera profeta Jesoso ne, taolu Calileea nenaa Nasarete cocoaicha,” naaure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nii jana inae Teenforo asaae enoha cuhane jana, najiniha neeuruha necoretenacaauru aina acaauru caje coreteraaurune jaunte, jelai caje sitanajae Jesoso. Coriqui coreeuruha cachaauru raina jaan rori lacohitiin, ecu serori que necoretiha nenacaauru rorine maajeein lacohitiin: ");
INSERT INTO uraNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“Cana Coaunera Quiricha cuhanete: ‘Canu lorerite, acaihaniji Canu bajaaebajaaecuruhane jaan coloherineein nereein,’ naain ne laenanohineein. Nete, inara leinjiin asijiaunanaja coloherineein teeiche,” naain acaauru cotai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nii Teenforo asae, rohan turuhacoaauruha maosacuru, bacosacuru, naaonjoainurine janate, acaauru rautae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nii cojoelanaacojoai ichaain acaauru notaaca Jesosone jana ecu neein coarajeeuruha saseredote curuaanaacuru aina Moisesa rai Cana Coauneraacha tei rauhi que cacha relaaureraauru, naaonjoainurine janate: “Coroaaenojoinemiin rey Rabiri ichoala,” naain cojiorichuruha canaanainunru Teenforo asaaene aonaain obajeeinte: ");
INSERT INTO uraNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Toon ii rai ereeuruhane aonaaina,” naain bajaaure. Nii jaunte: “Aihanu. Aonacaaun. Tana: ‘Canaanainunru, sisinacaaurune maajeein ii coroaecuruhane coinate, caohacha ichaai,’ naain laenanohineein nenaa reretaaichene,” naain acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Niritoha acaauru raine baihate, ecu acaauru ratiriin, nii nese caje amuhin, Betaniau cue Jesoso, ecu sinihane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Inae janone jelaiha neseeu cuhane jana mijiitohane jaunte, ");
INSERT INTO uraNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","bero auhaniha niha leinjiin iquerane jaun nichuuntaain coarae Jesoso, inaacane lihane coina niqui. Nete inacaenihane jaun: “Inae chabana coaiteen inaariheeini,” naa Jesosone rijieeoritiin ohe nii iquera. ");
INSERT INTO uraNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nii coaraainte: “Chasiinna luhecotariin ohe,” naauruha cojoelatiin aina nerelanaa nichaanune tabaaurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","“Esinae rauhijiriin esenetaain, icharichaain Cana Coaunerane esenetaain neeichene, caa ena iquera ichacaaunne amurijiriinte naineriquiche. Caa ichatane rai: ‘Caalai caje amuhin, cucuana cuhane cunihun,’ naaichene, nii aitocoichene rijieeoritiin cucuana cuhane cure nii ichatane. ");
INSERT INTO uraNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nii rijijieein techu, Cana Coaunera caje cha bajaaiche, terichaainne esenetaainne, inara rai inaraacha bajai tereein Cana Coaunera,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nii baiha Teenforo asae enohin cachaauru relaa niha Jesosone janate, rene turuhin: “Chatohanai Cocoainanacai neeinna neei ii, catohanai ichaaine coina. Chana cocoainanacai neein ii cocoainae,” naain Jesoso caje bajaauruha saseredote curuaanaacuru aina Joriocuru bichauhenaaurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","“Canuhetonaina inara caje bajanaa jereeun. Cha Joaan letoaelu cacha cojunacatihane coina. Cana Coaunerana letoaalu, ainihane cachaauru letononeeinna aihalu. Canu rai beeichenena, canuhetonai inara rai canu cocoainaera bereeunni,” naain acaauru tonoraa Jesosone janate: “ ‘Cana Coaunerate letoaelu,’ naacachenete: ‘Chanuna jana esenetaeneeichelu,’ nareein cana rai. ");
INSERT INTO uraNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Niheichu ‘Cachaaurute letoaelu,’ nanaa nainihaacache acaauru coasiha. Satiin cachaauru, Cana Coaunera, Joaan letoaalune esenetaauruhalune jaun,” naaure nejesinajeein ita rai. Niritiin ita rerohecaainte: ");
INSERT INTO uraNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","“Coitucuhaacaanu,” naauruha Jesoso raina jaunte acaaentonai: “Aihana jaun chujian canuhetonai, inara rai canu cocoainaera benaa nainihaaun,” naain acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nii baihate acaauru rai: “Tonaquiche jana inara caa erenaa que. Leinjiin cachate coroatajaain neeuruha rai calaohichurune jana, leinjiin rai: ‘Canu calaohi, enene canu ocoana jana amihanenihu,’ naa rai inacane jana: ");
INSERT INTO uraNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Coatiha curinaaunni’ naain cunaa jerenihane baiha cue nii leinjiin rai calaohi. ");
INSERT INTO uraNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nii baiha coaiteen, nii rai calaohi coroataja letoaane janate: ‘Saan ahi. Inae curichaaunnicha ofa,’ naane saijieein cuene. ");
INSERT INTO uraNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chariji inara rai, rai inaca ere tonoraain niicha icharatei ichae,” naain canacaanu caje bajaa Jesosone janate: “Nii ichoaichaniha rai inaca letoanojointe, inacaacha icharatei ichaain inaca ere tonorae,” naauru janate: “Nii rijijieein techu, inara aineeichene jana, Cana Coaunera Cojoanonaa que niha cuurureein Roma curuaanaa rai cachaauru cobaraain coriqui bajaaurera aina ene cojoaelorohecuru. ");
INSERT INTO uraNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Caohachaain rai nichao coreein neeuruha cachaaurune coina, relanajaa uhalu Joaanne jana, inara esenetaeneeichelune jana, Roma curuaanaa rai cachaauru cobaraain coriqui bajaaureraauru aina, nii ene cojoaelorohecuru esenetaauruhalune jaunte, Cana Coaunera Cojoanonaa que neeurureein. Jana inara, coaraquichene saijieein esenetaain inara ichao coreneeichene jaun, coatiha Cana Coaunera Cojoanonaa que neriheeicheein,” nae saseredotecuru aina Jorioocuru bichauhenaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Caa leeocha erenaa aonacuche. Leinjiin cachate oba coocana sirihane jaun, bino ichaane jaanu ichaain corihateein, nii baiha ucuuneein rori jae nichoae netiin amihanenacaauru beraihane coina. Inae satiin besautiaane baihate, rai leruhin teeuruhane coina que amihanenaa inaaureraauru cachaauru rai teein ratiriin amue. ");
INSERT INTO uraNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Inae tainacaane janate, leruhin rai niicha teeuruheni teeuruha raine coina letonocuru letoaa nii ocoana erorane jana, cuhin bajaauruha nii letonocurune jana, ");
INSERT INTO uraNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","tabaauru letonocuru faojoaain, tabaauru atinaain, ajeri que tabaauru bodoosiin, naaonjoainchuru sonajaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nii jaunte, nitohaneein rai letonocuru letoaane jana, sonajaauruhane jaun, coaiteen jelai amuritoheriin, enacoauneein letonocuru letoaane jana, jerichanejeein sonajaaunre nii amihanenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nii letonocuru letoaane naineein sonajatocuruhane jaunte, satononiha rai calaohi letoae: ‘Canu calaohi nihane jaunte laen que suujua acatecurureein,’ naain niqui letoae. ");
INSERT INTO uraNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","39","Nete inae cuha nii rai calaohine jana coaraain ecu ita rai: ‘Caate laen, nerora calaohi nihane jaun, jitariin cana caje caa rai inaca raineein nenaa raa cureein satiin aina nedaane coina. Coanete sohin jaohacache. Nii banate, satiin cana raineein nedareein nii raineein neenu,’ naain nii rijia caje mitaain sohin jaaore nii amihanenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aihana jaun, inae turuhane bana, cha ichareein acaauru aina, nii amihanenaa erora,” naain bajaa acaauru caje Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Nii nechu aansaineein ichaonacaauru cachaauru sohinte jaoreein, cairichaaojoaain acaauru coaraelanaala. Sohin jaonajaainte, leeochaauru rai nii amihanenaa tiha cureein, inae ecu tihane bana rai leruhin niicha taojiaauri teeuruhane coina,” naauru janate: ");
INSERT INTO uraNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","“Tana, Cana Coaunera Quiricha cuhane: ‘Nii ajeri, loreri ichacuruhane jaanu que nenaa jaolecooruhane jaan que temurateeinte loreri jaaure nii loreri icharaauru. Niine cojoelatohacaanu, nitohaneein ichaa Cana Coaunerane jaun,’ naain laenanohineein nihane reretaain aonaquichene. ");
INSERT INTO uraNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nitohanihane jaunna inara rai aitoon, rai Cojoanonaa que neeichene coina tihalune saijieein nii inara rai niicha teilu ruluhin, janijiin niicha ranojoinunru Cojoanonaanu que terichaain Cana Coaunerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jana canu nii ajeri nichaaunne ichoae comoite raajenihane chalutoroaain nedareein. Jana, canu nii ajerineein chunocoha ichoae comohanunete ajane neein nedareein,” naain raajenihane neque aite Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","46","Niritiin acaauru que aitoha Jesosone que nainacuruhane jaunte, Jesoso mucueratena jerecuruhane saijieein, ichana nainecurene, satiin cachaauru coasiha nii saseredote curuaanaacuru aina Joriocuru bichauhenaauru, satiin cachaauru Cana Coaunera letono profeta niha Jesosone esenetaauruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Nitohaneeinte coaiteen acaauru rai nereretanaa rijijie que cuaain ereerejeein: “Leinjiin rey, nisirihatiha rai calaohine coina beseta ichaane jaunte niqui, ");
INSERT INTO uraNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","rai letonocuru letoae, nii cotihanohichuru cotihacuruhane coina. Nete tonoraelanaala, nii beseta que turunaa jerecurene. ");
INSERT INTO uraNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nii turunaa jerecurenihane jaunte, enacoauneein rai letonocuru leeochaauru letoae: ‘Inae jatoroainjete ne lenone. Coerenetonanaain nenacaauru nirihurujete soerate. Chajaain beseta bitoaa uucheje,’ naain cotihanaacuruhane janate, ");
INSERT INTO uraNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","tonorana jerelanaala nocoana jana cue leinjiin. Jana leeochate, rai rucuhele que necoretiha cue. Jana leeochaaurute, nii rey letonocuru mucuhin atinanajaain sonajaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nii corenihate jataain obajeein, rai soondarooru letoae acaauru rey, nii rai letonocuru sohin jaaoreraauru sohin jaohin, acaauru nese mocooruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Inae nitohaneein turunaa jerecureniha niicha cotiharateeurine jaunte, ‘Satiinte niqui inae jatoroaain ne, caa nisirihatenaa beseta. Nete nelatecurenihane jaun turunaa nainecurene nii jauriaanejeein cotihanohichuru. ");
INSERT INTO uraNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aihana jaun, chajaain nese cataun situnacaauru berooru cuhane cuhecujeein, inaraacha erui cachaauru cotihacuchete, caa nisirihatenaa beseta bitoaa uuruhine,’ naain rai letonocuru letoae nii rey. ");
INSERT INTO uraNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nii jaunte, nese cataun situnacaauru berooru cuhane cuhin, aansaineein ichaonacaauru, cachaauru caohachaain suujua coaaraauru, naaonjoainurine majeein cotihacuruhane jaun, cacha que memoe loreri asajai. ");
INSERT INTO uraNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Inae satiin nii reycha tei cajione jiaain neeuruha cotihanoichurune jana enohin coaraa rey janate, ecu ne leinjiin cacha reycha tei nisirihateeuruhane jaan cocoajione jiaelanaala nenaa. ");
INSERT INTO uraNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nii cacha raite: ‘Chasiina nisiriatenaa cocoajione satiin rai canuhacha tei jiaeralanaala cau enohite quiicha belaai,’ naa rai nii rey jana, ecu inauheneeicha neein aonaje nii cacha. ");
INSERT INTO uraNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Niritiinte lenonecuruha cachaaurune jana coaaraneein nenacaauru rai: ‘Caa cacha biji aina, rai tijia ichojoaain airiniha nocohenaanau jaaochete, ecu neein chanaaine,’ nae nii rey. ");
INSERT INTO uraNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Arajiite niqui cotihanohi ne; nete coroatajaaecure janijiin ranojoinunri. Nii rijiicha Cana Coaunera Cojoanonaa,” naain que jaolequiin nenacaauru que cuaain ecu nenacaauru cachaauru rai ereereje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Niritiin acaauru que aitoha Jesosone que nainacuruhane jaunte, jelai caje amuhin Jesoso coulurujeeuruhane jaanu leranu arihure ita suujua tacaain fariseeocuru. Chaelai que aitocuruhane jana, baasoneein acaauru tonoraa Jesosone colurujeeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nitohaneein coacuhinte, acaauru ere tonoraeraauru, chaen Erodesi ere tonoraeraauru, naaonjoainuri letoaaure Jesoso rene, coulurujueeuruhane jaan lera ariha coritaauruhane coina. Nii jaunte rene turuhin: “Cacha relaera, iite iique tonaain iriha cachane tonoraelanaala, esinae rauhijiriin aitiin jeriha Cana Coaunerane rijijieein ichaoha cachane coina relaai, rai suujua caje rocohin cacha relaauruha leeochaaurune rijijielanaala. Chaen nechu inanacaa cacha ichaone caje coaraain coulurujueneeine coitucuhacaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nii jaunna, canacaanu rai beeine jerichaanu. Caohachaana Romanocuru curuaanaacuru curuaanaa- enferadoroacha bajaeratenojoi coriqui impoesto tihacachene,” naain bajaaure Jesoso caje. ");
INSERT INTO uraNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nete, nechu cairichanaa coacuhin letononeein aitocuruhane que nainaana jaun: “Casajenetiin cacha caohacha niha nocoetonacaauru, chanuna baasoneein cacairichaa canu coritana coaauquiche. ");
INSERT INTO uraNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Canu rai, nii enferadoro rai inaraacha tei coriqui uhaauchena coarae,” naa Jesosone jaun, rai coata caje nenaa coriqui denario teeuruhane jaun coaraainte: ");
INSERT INTO uraNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Chariji coujunaca cau caa ne, rai curuaa aina laenanohineein,” naain acaauru caje bajaa Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","22","“Caate enferadoro coujunacane,” naain tonoraauruhane jaunte: “Aihana jaun chujian, nii enferadoro raineein nenaa teeuche enferadoro rai. Jana, nii Cana Coaunera raineein nenaa teeuche Cana Coaunera rai,” naa acaauru rai Jesosone jaunte inauheneeicha cojoelatiin ecu Jesoso ratiriin amuure. ");
INSERT INTO uraNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nii bananeeinte, Jesoso coaraa uure sadoseeocuru tabaauru, oha cachane baiha nacoauneein ichanaane esenetaaurenihane jaun, bajaauruhane coina. Nitohaneein uhinte: ");
INSERT INTO uraNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Cacha relaera, Moisesate canacaanu rai aitelu, chunocoha leinjiiniji canaanai sirilanaala rai comasai ratiriin ohane, nii onaa ocoala nii rai ninana autana raa rai comasaineein ne, nii onaa bereeneein teein, nii autana bereetihane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nii janate, cau canacaanu aina neeurelu caainsineein ita nejera nejesinaneein cachaauru. Nii acaauru inanate, leinjiiniji rai comasai aina canaanai sirilanaala ohe. Nete leinjiiniji canaanai sirilanaala ohane jaun, rai nocoala rai, nii rai nautana teein ratiri. ");
INSERT INTO uraNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","27","Nete jerichanejeein canaanai sirilanaala oha acaaentonaine jaun, que jaurii nocoala rai nii nautana teein ratiri. Nirijieein cuaajeeinte satiin ooruha nii ita nejera nejesinaaurune jana, ohe nii ene netonai. ");
INSERT INTO uraNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aihana jaun, inae nacoauneein o caje ichanaa cachane bana, chariji comasaineein nereein nii ene, satiin ita nejeraauru comasaineein nihalune jaun,” naain Jesoso caje bajaauruhane jaunte: ");
INSERT INTO uraNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","“Cana Coaunera Quiricha inoaensi reretaain niicha ichana nainei coitucueneeichene jaunte, cha coitucueneeichene jaun aitocoiche. ");
INSERT INTO uraNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Inae ohane caje ichanaa cachane, ene, quicha, naaonjoainuri ita que nesinijerateein neeururinaain, inae Cana Coaunera letono anjera dedeeu nenacaauru rijijieein neeururichaaine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tana o caje ichanacuruha onacaaurune que, raaje nujuae caje: ");
INSERT INTO uraNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Canune, Abaraaun, Isaca, Jacobo, naaonjoainuri Coauneraneeun. Aihana jaun, coatiha onacaauru Coauneranihaaun. Canune ichaohin nenacaauru coauneraneeun.’ naain aitohalu Cana Coaunerane reretaain coitucuhichene,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Niritiin sadoseeocuru relaa Jesosone jaunte, cojoelatiin aonajeeure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nitohaneein acaauru relaa Jesosone jana, inauheneeicha aonajeeuruha sadoseeocurune coitucuhinte, ita taojiaaure fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Nitohaneeinte, leinjiin acaauru caje Cana Coaunera rai rauhi que cacha relaeraneein nenaa fariseeo, Jesoso rai: “Cacha relaera, chariji rauhi cana ichao rai leeochaauru amuritoeriin jataain nelateineein tenojoin ne,” naain nechu coulurijiane jaan leranu ariha, Jesoso caje bajaane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","“Ii Curuaanaa Cana Coaunera belaihu, ii coichana, ii suujua, ii suujue, iicha coacui, naaonjoain aina cuaritaain. ");
INSERT INTO uraNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Caritiinte jataain jauriaanejeein cana rai nelateineein nenaa rauhi beratelu cana rai Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nii que jauriineein tenojoite, jerichanetojoeein: ‘Chamute cacha belaain coaraau, ichaajenihane ijiabereeo belaaine rijitojoeein,’ nae. ");
INSERT INTO uraNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Caa coroatajai rauhite, jataain nelateein cana ichao rai tenojoi ne. Acatechu nii Moisesa aitoonjoa rauhichuru cana relaauruha profetacurune jaan rauhi temuraneein ne,” nae fariseeocuru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nitohaneein jaiti netaojiaain ita aina neeuruha fariseeocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tonaquiche inara Curisito Mesihasi que. Cha caje nefoeratenaa neeicha ne,” naain acaauru caje bajaa Jesosone janate: “Rabiri caje nefoeratenaaneeinte ne Curisito Mesihasi,” naain tonoraauruha fariseeocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Chasiina jana nitohanihane, que aitoroatiha Cana Coaunera Suujuene jaun: ‘Canu Curuaanaa,’ naelu Rabiri, Curisito Mesihasi que. Chaen techu: ");
INSERT INTO uraNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Canu Curuaanaa raite: “Cau carohan, caraotono nichajai que nelauriaau, ii que nejeratenacaauru amuritiin ii tijia asaae tenajaanune reentiaaincha,” nae Cana Coaunera,’ naain belu Rabiri. ");
INSERT INTO uraNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","46","Aihana jaun, chasiina Rabiri caje nefoeratenaa nere Curisito Mesihasi: ‘Canu Curuaanaa,’ naalu rai Rabiri natiin,” naa acaauru rai Jesosone janate, le erenaanejeeiniji tonoraaurenihane jaun, inae nii caje coaauneein, caje cha bajanaa jerecurene fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nii baihate, ecu nenacaauru cachaauru, chaen aina nerelanaa nichaanune, naaonjoainichaanune rai: ");
INSERT INTO uraNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Cana Coaunera rai rauhi que cacha relaaurera aina fariseeocurute, aitoha nii rauhine jaan belanaala joaenreen cuaain cachaauru relaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Atiin acaauru ere tonoraain acaauru aitoonjoa ichacuche. Nete laen caohachaene chaachacuruhane rijijieein cha ichaquichene, tonaain ereeuruhane nihanatiin, enaacha leeochaneein chaachacuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nitohaneeinte, nii chabana nitohanei ichaonaa que ichaonaa naineniha cachane saijieein, cachaauru rai caaintati ichaonaa teeure, nii acaauru nihanatiin nitohanei ichaonaa que ichaonaa naineralanaala. ");
INSERT INTO uraNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nechu caohacha ichaa nocoetocuruhane coaracuruha cachaaurune coinate, nitohaneein neeure. Nii jaunte, rai naurichuru, rai bijihuru cuhane, naaonjoaain Moisesa rai Cana Coauneraacha tenojoin rauhi laenanohineein nenaa amaauruhane rautatoore. Chaen techu jataain nelatiha nocoetocuruhane jaan coujunacanu que, cajione ererianohineein nenaa jiaainne maajeein aihure. ");
INSERT INTO uraNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nii rijijieein techu niha lenonena jaaunru rori caohachaauru janijiin ichoae nelauriaain lenoneein, sinacoca asaene maajeein enooruhane, rori caohachaauru janijiin nichoae nelauriaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nitohaneeuruhane jaunte, bero cuhane acaauru que tacaain, acaauru que suujua acateein iriha cachaaurune jereein: ‘Cacha relaera,’ naa acaauru rai cachane jereeinchuru aihure. ");
INSERT INTO uraNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nete laen inara: ‘Canu relaera,’ naain inara rai iriha cachane jereein nenaa naineneeiche, satiin inara ita nejeraneein neeichene jaun, leinjiincha niha inara Relaerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Niheichu nainiheeiche chuni rai: ‘Canu inaca,’ naain erenaa nainiheeiche, leinjiincha niha inara Inaca dedeeune jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Niheichu nainiheeiche: ‘Canu curuaanaa,’ naa inara rai cachane jereein neeichene, leinjiin Curisito nichaaunne inara Curuaanaa neein nihanune jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nitohanihane jaun, leeochaauru amuritoheriin nenaa coaauca chunocoha inara janane, cha lateein neeuruha leeochaaurune, acaauru coroatajanemiin. ");
INSERT INTO uraNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nitohaneein leeochaauru amurijiriin nenaa jerenacaaurute leeochaauru fautaain tenojoinereein. Jana leeochaauru fautaain neite, leeochaauru amuritoheriin tenojoinereein. ");
INSERT INTO uraNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Coaraain nainacuche Cana Coaunera rai rauhi que cacha relaaureraauru aina fariseeocuru. Inarate Cana Coaunera Cojoanonaa que nenaa jerecuruha leeochaaurune caohateraneein neeiche. Inara netonai que ichaonaa naineneeichene jaunte, que ichaaoruha leeochaaurune caohateraneein neeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Coaraain nainacuche Cana Coaunera rai rauhi que cacha relaaurera aina fariseeocuru, autanaauru loreri nihanatiin ruluhin neeichene jaun. Nitohaneein ichaohichene aninoaeraneeite, Cana Coaunera bajaaichene carajaain bajaaiche. Nitohaneein neeichene jaunte, jataain caseteco coaraa curiquicheein inara. ");
INSERT INTO uraNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Coaraain nainacuche Cana Coaunera rai rauhi que cacha relaaureraauru aina fariseeocuru. Inarate chauratane sacuritaain cucuana cuhaneeuru amuhemujeein cachaauru ariiriiquiche, nechu jataain Cana Coaunera esenetaera niha nocoetiin relanajaainchene, coroata saain inara amurijiriin moconajaera cachaneein neeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Coaraain nainacuche inara maosa rijijieein nenacaauru cachaauru relaeraneein nenacaauru. Inarate chunocoha, Teenforo coreniha cha ichaane coina aitohane sainejeein nii naitonjoa ichaeniha cachane, cha ujuaihoneein nenihane que aitocoiche. Nete laen Teenforo corujele oro coreniha chaachaain nihane coina aitohane jana, chatohanai ichaain nenihane cocoaeraane que aitocoiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aaso aina maosa rijijieein nenacaauru cachaauru. Cha jataain inara rai nelateein nenaane orona. Tana nii Teenforo coreniha que banijiaineein niha nii orone jaun, jataain nelateineein nihane coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Chaen techu: Chunocoha, Cana Coaunera que banijiai lenonecuru mocohichene jaan rori- altar coreniha cha ichaane coina aitohane sainejeein ichaenihane, cha ujuaihoneein nenihane que aitocoiche. Nete laen, nii rori- Cana Coaunera que banijiai iniho mocohichene jaan- altar ichoae nenaa coreniha cha ichaa cachane coina aitocoichene, esinae rauhijiriin nohanelanaala ichaane coina aitocoiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Maosa rijijieein nenacaauru cachaauru. Cha jataain inara rai nelateineein ne. Nii Cana Coaunera que banihateein tenojoin inihona, ainihane rorina. Tana nii rori coreniha Cana Coaunera que banijiaineein niha nii inihone coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aihane jaun nii rori coreniha chaachaain nihane coina aitoha chunine, nii roriicha coreniha coatiha icharinaain, nii nichoae nenaa corenihane maajeeinte ichareein. ");
INSERT INTO uraNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jana Teenforo coreniha chaachaain nihane coina aitohane, coatiha Teenforo corenihacha ichaane coina aitorinaain, Cana Coaunera quene maajeeinte aitoreein ecu nihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jana dede coreniha chaachaain nihane coina aitoha chuninete, Cana Coaunera nelaurianajaneein niha dedene jaun, Cana Coaunera quene maajeein aitoreein. ");
INSERT INTO uraNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Coaraain nainacuche fariseeocuru aina Cana Coaunera rai rauhi que cacha relaaureraauru, inaraacha ichai coitucuhin ichoaeneeichene jaun. Caohacha ichaa nocoetiinte niqui jataain ansijiin laaojoiri niha natiin Cana Coaunera rai teeiche. Nete jataain nelatei Cana Coaunera rai rauhi tonoraain neneeiche. ‘Caohacha nejesinaacha ichaain, baaso coacuelanaala neein, cairichaaojoaain leeochaauru coaraain, Cana Coaunera ere tonoraain aca jerihane rijijieein que asiin cha ichaelanaala neeuche,’ naa Cana Coaunera rai rauhine sainejeein tonoraeneeiche. Nii leeocha jianelanaala nii rauhi aitoonjoa ichaquichenete caohachae. ");
INSERT INTO uraNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Inarate, maosa rijijieein nenacaauru cachaauru relaeraneein neeiche. Jataain ansijin laaojoiriniha natiinte niqui tonoraain niha cachane jereein neeiche. Nete jataain banejelanaala baaso ichaain neeichene coaraain coitucunaa naineneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Coaraain nainacuche Cana Coaunera rai rauhi que cacha relaaureraauru aina fariseeocuru. Inara cacha coritaera nequichenete, acau cohichene jaan janoriicha culeequiche. Nete cuhanai culejeneeichene jaun jataain calanine cuhanai. Nii rijiicha inara suujua cuhanai, inara suujua cuhane coacuhin baasoneein cacha basijiaauhin, inara amute cacha caje cha chunaain, naaonjoaainchene jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Cha coitucuelanaala nitajenaa neein nenacaauru fariseeocuru. Jauriaanejeein nii acau cohichene jaan janori culeequichene rijijieein, nii inara suujua cuhanai itolere baaso ichaquichene jaan caaun calanineein niha inara suujua cuhanaine jaan jaaochete, somaraain neeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Coaraain nainacuche Cana Coaunera rai rauhi que cacha relaeracuru aina fariseeocuru, aiha atanebana airichai nichajaine rijijieein somaraain, jana asaaun itolere onaa bucuuru calani sirihane rijiicha inara suujua cuhanaine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nii aiha atanebanane rijijieeinte, cachaauru nota rai, inara jaberocohacha cacha caohacha tocohaneein inanacae. Nete, inara suujua cuhane casajenetiin, cacha coritaeraniha caohacha ichaa nocoetiin aaichene jaun, leinjiin calani rijijieein neeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Coaraain nainacuche Cana Coaunera rai rauhi que cacha relaeracuru aina fariseeocuru, inaraacha ichai coitucuhin ichaeneeichene jaun. Casajenetohichene jaunte, nechu cacha coritaeraniha, nii inara foerateracuru sonojoihunru profetacuru, cacha caohachaain suujua coaaraauru, naaonjoainuri cojunaca ichaquiche ajeri caje, caohatiin itolere que corujueleteein. ");
INSERT INTO uraNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nitohaneein ichaainte: ‘Cana foerateracuru jiniichaain ichaohacachelune jana nihane, coatiha acaauru coroatajane rihahacache, profetacuru sohin jaaoruhane jana,’ naain ereeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Niritiinte, inara raajenihane, nii inoaenlu profetacuru sohin jaaoreralu nefoeratenequichene coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Inae nitohaneein nunuheteeuruhalu inara foerateracurune jaan besautiaauche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Acanocuru, acano caje nefoeratenacaauru. Coatiha usi tabai jana caseteco neriquicheeinne caje nichoteriheicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nii coinate inara rene profetacuru, cha cojoeluinanaa inaaurera, cacha relaeracuru, naaonjoainuri letoaanune jana, tabaauru sohin jaohin, coroso que tabaauru teein, tabaauru faohariquicheein sinacoca asae teein. Chaen techu, neseeuru neseeuru naineein arinajariquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nii jaunte inara, satiin cacha caohachaauru atinanohichuru coreniha caseteco coaariquicheein. Caohachaain suujua coaara Abeli atinaauruhalune que nunuheteein, Cana Coaunera rai jelai teein nenaa teeuruhane jaan rori rohan nenaa santuario rohan teein inaraacha soilu- Berequihasi calaohi Sacariasi que tiaaojoaain, caseteco coaraa curiquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Esinae rauhijiriinte nitohanihane coreniha, caseteco coaracurureein caa enene nenacaauru cachaauru,” nae Cana Coaunera rai rauhi que cacha relaaurera aina fariseeocuru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Niritohane baihate: “Cairichaaojoaaiche Jerosaleen cocoaichacuru, inara rene Cana Coaunera letonocuru profetacuru sohin jaohin, Cana Coaunera ere beracuru bodoosiiche ajeri quene jaun. Araai saaine niqui, ii cocoaichacuru ranaa jereeun, nitaro asae calaohichuru taojiaa ataoharine rijijieein. Nete canu esenetaeneeichene jaun canu rene unaa jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aonacuche. Ena caje coauneein, inae inara aina nerihaaunni. Aihana jaun, inae nerinaain inara beraicha. ");
INSERT INTO uraNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Inae nacoauneein canu coaariheeicheein, turuhanune bana: ‘Caa ena turunaa Cana Curuaanaa coroaecuruhine satiin chauratane que nenacaauru cachaauru,’ nariquicheeine que tiaaojoaain,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Inae Teenforo caje mituhin jelai caje amuhane rai niha Jesosone janane, rohan nichuuntaacoain caohatiin ichanohiniha nii Teenforone coaracaanu aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nii jaunte: “Caohatiin ichanohiniha caa Teenforonena coarajeeiche. Esinae rauhijiriine inara rai aitoon, coatiha nii leinjiinniji ita ichoae nerinaain caa ena inaraacha coarajei ajeri, inae satiin nitajerichaaine jaun,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nii baihane, Oliboneein acaauruhacha curuaatei ichatane ucuunno cuhacaanu, ecu turuhin jelai lauhecoha Jesosone jana, rohan nichuuntaacaanu aina nerelanaa nichaanune. Nitohaneein rohan nichuuntaainne: “Canacaanu rai nii chaitoonjoan beeinene jerichaanu Curuaanaa. Chabana nacoauneein cau tururiquiin. Chatohanaicha inae turuhe lalajeeine jana, ii turu cojoinaca beraneein coaarichaanuhin, inae saaelalajiha cana janonaane bana,” naain caje bajaacaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","“Caohachaain necohalajiin neeuche, nabana inara coritaauruha chunocohacurune coataara. ");
INSERT INTO uraNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Arajii cachaaurute, canu niha nocoetiin inara coritana jerecurureein: ‘Canune Curisito Mesihasineeunra,’ naainte, arajii cachaauru coritaaurureeincha. ");
INSERT INTO uraNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Niha sonaana cau, tajiha, naaonjoaaine coitucuhichene, jiaonriha nesoonetohichenera, nitohanihate cureein nii ajinihara. Nete, nitohanihane nihanatiin, jaiti cana janonaa satono que turuenereeincha. ");
INSERT INTO uraNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nejelau lauri nenacaauru ainate, sonaana que neeurureein leeocha lauri nenacaaurura. Nejelau atane que nenacaauruniha natiinte, leeocha atane que nenacaauru aina sonaana que neeurureeincha. Chaen techu, itolere sacuritaain niha mijetenane jana, araai laurii atanecuru que niha cureein carorara. ");
INSERT INTO uraNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nitohaneeinte nunuheca cureein, inae cana cojoanonaa satono que turuhelalajihane jana, jataain inaderaauruha cachaaurune jaan cojoanonaara. ");
INSERT INTO uraNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nii jana inarate tenojoiniha curiquicheein cocoainanacaaihuri rai, inara faojoaain, inara atinaain, naaonjoaain inara teeuruhane coina. Chaen techu, satiin cachaauru, canu coreniha inara que nererojoecaaeriin neeurureeincha. ");
INSERT INTO uraNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nii banate, arajii canu esenetaera niquichene, inaraacha esenetai jianeein, ita que nererojoecaain, nejesinajeein ita colurujueein ita teriquicheein cocoainanacaaihuri rai. ");
INSERT INTO uraNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Arajiite profetaniha nocoetiin turuhin namute cachaauru coritaauruhane, acaauru esenetaaurureein arajii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nitohaneeinte, jataain baaso coacuhin inae ita belaihuruhane jianeein niha cuurureein cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nete laen, nii niicha esenetai esenetaane nunuhetihane caje coauneein, jerichanejeein satono que tiaain sacuera nichotereeincha. ");
INSERT INTO uraNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Caa ena nenaa ichaonaa erenaa raotono quiicha beebejei Cana Coaunera Cojoanonaate, satiin chauratane sacuritaain benojoinereein, satiin cachaauru inae coitucuuruhane jana, besaute que turuha cana cojoanonaane coinara. ");
INSERT INTO uraNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Profeta Danieriicha laenailu reretaain coaarate nii coitucuhin nichotenaa nainereein. Aihana jaun, inae nii Teenforo asaae jelai teein Cana Coaunera que banijiaain altar ichoae ecooca Cana Coaunera que nejeratenaa casicheine coaraquichene, ");
INSERT INTO uraNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jodeau nenacaauru sorooruhine ichatane ucuunno que cuhincha. ");
INSERT INTO uraNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jana, rai loreri janori ichoae nenaa, jiaonriha fauhin rai rucuhele raane. ");
INSERT INTO uraNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jana rai nocoana jana nenaa, jiaonriha rai nenajau cauhin rai cajione ranaa coaaucane. ");
INSERT INTO uraNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jataainte cairichaaojoaaurureein nii cojoanonaa que turuhane bana ausurineein nenacaauru enecuru, sisihajeein canaanai sirichaauru enecuru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Cana Coaunera bajaauche, nabana jelaronaa bana, niheichu nebetacanaa cojoanonaa, naaonjoain bana niha nii sorohichene jaan cojoanonaane coataa. ");
INSERT INTO uraNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nitohaneeinte niha cureein jataain necairichanaa tabai, cana necoaauna caje coaauneein nii chabana niha nitohanaine que airijiin niheichu nerinaain nii baiha. ");
INSERT INTO uraNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jana, nii cojoanonaa sarotiaeniha Cana Coaunerane, satiin cachaauru nichotenaa nainecururihei. Nete, atiin sarotiareein, janijiin niicha ranojoihunru belaitohane jaun acaauru coreniha. ");
INSERT INTO uraNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chunocoha inara rai: ‘Caute ne Curisito Mesihasicha. Chajaau tejian coaanicha,’ naa inara raine, jiaonriha esenetaaichene. ");
INSERT INTO uraNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Turuururichaain inara rene casajeeuru profetaniha nocoetonacaauru aina Curisito mesihasiniha nocoetonacaauru. Nitohaneein turuhinte, itolere cojoelanaacojoai ichacurureein, janijiin Cana Coauneraacha ranojoinunrune maajeein coritana nainecuruhane coritacuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nitohanihane ajinihane inara rai beeun, caje coitucuhin nainaain ichaohichene coina. ");
INSERT INTO uraNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Aihane jaun, inara rai: ‘Nota tajiha cacha areroote ne,’ naauruhane nihanatiin jiaonriha cuhichene. Niheichu: ‘Nocoa caute ne nasiincha,’ naa inara rai chunine, jiaonriha esenetaaichene. ");
INSERT INTO uraNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Charijieein teeinti, enoto mitu nichajai caje jilenetoha jiacane enoto soo nichaae cuhine, satiin coaanojoi ne. Nii rijijieeinte, satiin coaanojoiniha cureein, inae nacoauneein cau turuhanu acaihaniji Cacha Calaohineein nejanoanaa nichaaunne bana. ");
INSERT INTO uraNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Charijieein teeinti, niha caanii setune que fauha ichotarine caje coitucuerae. Nii rijijieeinte coitucunojoinereein turuhanu canu Curisitonichaaunne bana. ");
INSERT INTO uraNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Inae nitohaneein niha nii necairichanaa tabai cojoanonaane janate, nocohenaneein nerotoreein enoto cono. Atene netonaite, conohane jianereein nii cojoanonaa bana. Jana arasijieeurute, dede caje naluurureein. Dedeeu nenacaauru nihanatiinte nerurujuaaurureein. ");
INSERT INTO uraNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nitohanihane janate laen, inanacareein dede caje inae fauha uhanu canu acaihaniji Cacha Calaohineein nenaa nichaaunne bera. Nii jana, satiin chauratane sacuritaain nenacaauru cachaaurute, jataain coasinacaaun chanaain coaracuruhane janane, dede sacari jana uhin fauha ureeunni acaihaniji Cacha Calaohineein nenaa nichaaunne, jataain necaohachaain itolere ichana naineein nelateein. ");
INSERT INTO uraNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nitohaneein turuhinne canu letonocuru anjeraauru letoareeunni, tonijiaain jaaiha toteein, satiin chauratane sacuritaain, itolereneein satono tinonoritiin nenacaauru janijiin canu ranojoinunri cachaauru taojiaauruha canu raine coina. ");
INSERT INTO uraNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Aihana jaun, caa uhera que inara relaanune jaan que nerelaauche. Charijieein teeinti, inae rai nunecuru caohatonanaain alohacoaain ujuanihane caje, inae cataainjia ajaanaane coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nii rijijieein, caa inara rai caitoonjoa tocohanihane coaraquichene, inae turuhelalajihanu acaihaniji Cacha Calaohineein nejanoanaa nichaaunne que nainacuche. ");
INSERT INTO uraNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Esinae rauhijiriinte, jaiti ooreniha caa enene nenacaauru cachaaurune jana aicheein. ");
INSERT INTO uraNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dede aina chauratanete nitajeeurureein. Nete laen, nitajenereein, caa caitoonjoa nainaane reeitiaain, canu ere. ");
INSERT INTO uraNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Coatiha laen nihei chuni, rai cojoanonaa aina, ‘Naaonjoain rijiu tiaainte aicheeincha,’ naain nii coitucuera. Niheichu, Cana Coaunera letonocuru anjeraauru dedeeu nenacaauru nihanatiin coitucuuruhi; niheichu canu- Calaohinichaaune saijieein coitucuhaaun canuhetonai. Acaihaniji canu Inaca Cana Coauneraachate, nii coitucuhin ne. ");
INSERT INTO uraNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nihalu Nohene bana aihalune tocohaneeinte aicheein, inae nacoauneein turuha urichaaunni acaihaniji Cacha Calaohineein nenaa nichaaunne cojoanonaa que turuhane bana. ");
INSERT INTO uraNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Coaracuche nachuhinti, jaiti uheniha elo tabaine jana, rai bote cuhane fauhin enoha Nohene que tiaaojoaain, raotojoeein lenoneein, acau cohin, necohansajiaain, naaonjoauruhalu cachaaurune. ");
INSERT INTO uraNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nejetaote laen, urichaain elo tabaine coaaujeeurenihane jana, uha elo tabaine jaun jetao, jitariin acaauru joocalu ne. Nii rijijieein nechu, coohatejeeureniha cachaaurune jana, nacoauneein turureeunni acaihaniji Cacha Calaohineein nejanoanaa nichaaunne. ");
INSERT INTO uraNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nii turuhanune rijieeoritiinte, ocoana jana neeurureein coroatajai cachaauru. Leinjiinte, amanojoinihane jana, leeocha ratirinojoinereein. ");
INSERT INTO uraNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nii jana, coroatajai enecurute, tutune jaa neeuruhane jana, leinjiin amanojoinihane jana, leeocha ratirinojoinereein. ");
INSERT INTO uraNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nitohaneein: ‘Cuu tiaainte, turuha ureein canu Curuaanaa,’ naain coitucueneeichene jaun, tururichaaunnine que nainaain ichaaoche. ");
INSERT INTO uraNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Charijieein teeinti, leinjiin cacha: ‘Cuu tiha janotiine janate turuha ureein cau asijiauto,’ naain coitucuhane que nainaane jaun, nii chuni rai loreri asae enohane jerelanaala caohatiin rai loreri beraihane jaun, nenere basijiaera. Nii rijijieein inara netonai jatoroaain neeuche. ");
INSERT INTO uraNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aihane jaun, Cana Coaunera Calaohi cacha caje nejanonaa nichaaunne turu cojoanonaa coitucueneeichene jaun, inara netonai nainaain jatoraain canu cohacuche. ");
INSERT INTO uraNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Cha teeinti letoaain ratiriha rai fatoroonne tonoraain, inae cuu tihane jana rai loreri asaae nenacaauru cachaauru coroaate, ");
INSERT INTO uraNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","nii jataain raotojoeein neeine, nii letoaain ratirihane jaan ichajihane jana eruha nii rai fatoronne. ");
INSERT INTO uraNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nitohaneein rai fatoroon aitoonjoa tonoraain icharate, esinae rauhijiriin satiin rai niicha sirii beraichaneein tereein rai fatoroon. ");
INSERT INTO uraNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Nete laen: ‘Jaitijiecha carajareein rai fatoroon,’ naain nii leeochaauru letonocuru faojoaain sonajaain, ajetoriaacuru aina netaojiaain lenoneein ajeein, naaonjoaan, ");
INSERT INTO uraNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","cha cohatejelanaala nihane jana turuhane, nii nechu aansai letono casetecareein rai fatoroon, ");
INSERT INTO uraNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","caseteco coaracuruha nechu cacha coritaa Cana Coaunera coitucuha nocoetonacaaurune rijijieein. Ecute catu rioneein chanareein,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Cana Coaunera Cojoanonaate, aihuruha lechooncai ranunacuru nisirihatenaa beseta quene rijijie. Nii lechooncai ranunacurute, rai cono erene que mocohin nenaa amaain, nii nisirihateneni cohaca cuure turu jana raauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nii lechooncai ranunacuru caje, saoquii ranunacurute, niicha ichai que caohachaain coacuelanaala icharaauru ne. Jana, leeochaauru saoquii ranunacurute, jataain nainaain niicha ichai icharaauru ne. ");
INSERT INTO uraNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nii saoquii cha coacuelanaala nenacaauru ranunacurute, rai cono amaauruhane saijieein, nacoaauneein noitecuruhane jaanu erene amaaurene. ");
INSERT INTO uraNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nete laen, nii saoquii jataain nainaain nenacaauru, rai cono amaauruhane choae tacaain, le botichananaain rai noinu erene amaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nitohaneein cuuru jana, jaiti turueniha nii nisirihatenine jaunte, inae siniitoruhane jaun, satiin sinihure nii ranunacuru. ");
INSERT INTO uraNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nii janate, inae dede catai rijiu: ‘Inae uha nii cacha nisirihateneni. Chajaain que tacaain raauchera’ naain toniha eheeonane jaunte, ");
INSERT INTO uraNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","8","nimichucutaain rai cono noitecuruhane jana, nii saoquii cha coacuhelanaala nenacaauru ranunacuru, nii saoquii nainaain cono noinu que erene uhaurera rai: ‘Atiin canacaanu sihuche aansijiin, nii inara cono noi erene quera. Inae saa rai noi erenene jaun, jacaa canacaanu conone jaunne aitocoaanura,’ naauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Nainihaacanuta. Inara sihacaanune, canacaanu rai nihanatiin nerihane coaalanaalata. Chajaaincha que necoreteeuruhane jaun cuhin, coretenichuchera,’ naaure nii rai cono noinu amaain cunacaauru ranunacuru. ");
INSERT INTO uraNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nete nii rai cono noinu erene coretiha cuuruha nii saoquii cha coacuelanaala nenacaauru ranunacurune jana, inae turue nii nisirihateneni cacha. Nitohaneein turuha nii cacha nisirihatenenine janate, aina jiniiquiin loreri asae enooruha beseta que nii saoquii ranunacuru nainaai nenacaaurune jana inae nefue acuujua. ");
INSERT INTO uraNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nii janate, inae nii acuujuaniha turuhin: ‘Curuaanaa, atiin canacaanu rai acuujua joaracaaune canacaanu netonai enohacaanu,’ naauruha nii saoquii ranunacuru cha coacuelanaa nenacaauru, rai cono noinu coretecuruhane caje turuhinne janate: ");
INSERT INTO uraNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Esinae rauhijiriin inara coitucuhanune coaalanaala,’ nae acaauru rai nii curuaanaa. Nii rijiichate cureein Cana Coaunera Cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aihana jaun, itolere bana nii que nainaai jatoroaain ichaaoche, ‘Naaonjoai janonaa banate aicheein. Cuu tiariinte aicheein,’ naain coitucueneeichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Cana Coaunera Cojoanonaate, leinjiin cacha coriajai atane cuhane jaun, rai cachaauru cotijiaain, acaauru que coriqui beraichatera rijijie, ");
INSERT INTO uraNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","leinjiin rai saoqui oaraacai coreneein nenaa coata caje coriqui te. Jana leeocha raite, coroata oaraacaain te. Jana leeocha raite le oaracaain te, le cachaauru rai coretena nainecuruhane jeeonijihanaain teeinte amue. ");
INSERT INTO uraNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nii saoqui oaraancaain raera cachate, nii coriqui que rucuhele coreteein, que necoreteein saoqui oaraancaain nii coriqui jojoe. ");
INSERT INTO uraNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jerichanejeein techu, coroata oaraacaain niicha rai jojoe nii coroata oaraancaain raera cacha. ");
INSERT INTO uraNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nete laen, nii le oaraancaain raera, niicha bajei atane jachu cuhane nii rai fatoroon tenojoi coriqui asi. ");
INSERT INTO uraNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nii baiha carajaain catiaainte, inae turue nii acaauru curuaanaa coriqui teein ratiricha. Nitohaneein turuhinte, nii acaauru rai niicha tei coriqui coreniha acaauru rebe bajae. ");
INSERT INTO uraNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nii saoqui oaraancaain raerate ichoaichaniha turuhin: ‘Curuaanaa, nocoha taolu canu rai, saoqui oaraancaain iicha tei coriqui. Nocoa chaen leeocha saoqui oaraancaain joocaaune jaan,’ naain, nii coriqui niicha jojoi tiha nii rai cachane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Jataain caohachate ichaaicha, jelai amuritoriin nenaa beraichaneein ii tereeunnicha. Aihana jaun, chajaain caloheri asaae enoote jiniiquiin rachoojihacara,’ nae nii curuaanaa. ");
INSERT INTO uraNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nii baihate turue, nii cacha coroata oaraacaain coriqui raera. Nitohaneein turuhinte: ‘Curuaanaa, nocoa taolu canu rai coroata oaraancaain iicha tei coriqui. Nocoa chaen coroata oaraancaain joocaaunne jaan,’ naa nii coroata oaraacaain raera cachane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Jataain caohachate ichaaicha, coroatajajei aina caohachaain erenaa tonoraain ichaine jaunne, jelai amuritoherii beraichaneein ii tereeunni. Aihana jaun, chaajaain caloheri asaae enoote, jiniiquiin rachoojihaca,’ nae nii curuaanaa. ");
INSERT INTO uraNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nete laen, nii le oaraancaain raera cacha turuhin: ‘Curuaanaa, nechu aansai cachaneeine jaun, temueneeine jaaunru jelai caje temule raain, ii ocoananelanaala nenacaauru caje nihanatiin temule raain, ");
INSERT INTO uraNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","naaojoaaine jaunna ii coasiha, atane jachu cuhane ii coriqui asihun. Nete cau ne nii ii coriqui,’ naain nii coriqui cainaa nii cachane jaunte: ");
INSERT INTO uraNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Iite, canu cacha baasoneein bajeriti cacha neei. Inae raotojoeein canu temulenelanaala nenaa niha natiin raain, canu ocoananelanaala nenaa caje temule raain naaojoaanune coitucuhine saijieein, ");
INSERT INTO uraNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","chanuna chaen, canu coriqui amaain teneei banco cuhane. Bana nitohanihane jana nihane, canu turuneeine nii banco cuhane neein nejoocane jaanne maajeein rareeun,’ nae nii curuaanaa. ");
INSERT INTO uraNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Niritiinte, ecu nenacaauru rai: ‘Caje nii le oaraancai niicha sirii coriqui ruluhin, nii lechoonca oaraancaneein siricha rai teeuche. ");
INSERT INTO uraNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nitohaneeinte, siricha rai jataain jelai amuritoheriin tenojoinereein, jelai amuritoheriin sirihane coina. Jana, cha sirilanaala nenaate, acaihaniji niicha sirii, jitariin caje ruluerareein. ");
INSERT INTO uraNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aihana jaun, caa canu cacha baaso cha coitucuhi mucuhin, naain airiniha nocohenaanau jaaochete, ecu neein mainajeein chanaaine,’ nae ecu nenacaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Inae rai cono caohacha que conohin, rai anjeraauru cataaun uhin turuhin rai rori- trono ichoae nelauriaanu canu Cana Coaunera Calaohineein cacha caje nejanoanaa nichaaune banate, ");
INSERT INTO uraNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","satiin lauri lauri nenacaauru cachaauru turuurureein canu acatiha. Nitohaneein nacatiha turuuruhane janate, carenerocuru caje, jelai teein cabraauru leruha carenero beraichane rijijieein, ");
INSERT INTO uraNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","raotono nichajai que, nii janijiin niicha ranojoihunru- rai cachaauru teein, najaabiji nichajai que nii rai cachanelanaala nechu aansaineein nenacaauru tereein. ");
INSERT INTO uraNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nitohaneein jelai tihacoaain lerunajaainte, nii raotono nichajai que nenacaauru rai: ‘Chajaauche cajiha satiin, nii canu Inaca rausiaenojoineein neiniquichene. Chajaauchete, cana rai chauratane coaaunaane caje coauneein, inara que banihateein canu Inaca Cana Coauneraacha rucujuei Cojoanonaa que ichaohiche. ");
INSERT INTO uraNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Inarate, mijitichaaunne canu coroaateein, cocoirichaaunne acau que cacocaain, canu nesurunaja colane amuhemuhecaaunne, canu nesurunajaanu teein, ");
INSERT INTO uraNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","lanaa canu rai cajionene, carai cajione teein, cunaitichaaunne turuhin cacoharaain, caresero cuhane nihanune jana, turuhin canu coaraain, naaonjoaain canu rai nelateein nerejetocoiche,’ narichaaunni acaauru rai canu Cana Coaunera Calaohi cacha caje nejanoanaa nichaaune. Niritocoaaun acaauru raine janate: ");
INSERT INTO uraNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","‘Curuaanaa, esinaaena mijiteeine ii coroaateein, cocoireeine ii cocoaain, ");
INSERT INTO uraNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ii nesurunaja colane amuhemuhequine, ichei ii nesurunaja teein, ii cajione colane neeine, ichei cajione teein, ");
INSERT INTO uraNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","cunaiteein, caresero cuhane neein naaonjoaine turuhin ii coaraain, naaonjoa rejetocoaanulura,’ naauruha rai nii couluuonojoi suujuaquiin nenacaaurune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‘Satiin canu nejeraauru cairicheinejeein nenacaauruhacha latei terejetocoichenete, canu rai tiha nii terejetocoichelu,’ naain acaauru tonorareein nii acaauru Curuaanaa Rey,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Niritohane baihate, nii najaa biji nichajai que rai cachanelanaala nenacaauru rai: ‘Naain cacaje amuhin, moconajaera aina rai letonocuru que banihateein ichanohin chabana jacanaa charanejeein nenaa usi rene cunichuche, nii coina neiniquichene jaun,’ naain usi rene letoanajareein. ");
INSERT INTO uraNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Niritiin usi rene letoanajaainte: ‘Inarate, mijitichaaunne niha natiin, canu coroatelanaala, cocoirichaaunne niha natiin, acau que canu cocoaelanaala, naaonjoa rejetocoichelu. ");
INSERT INTO uraNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Niheichu canu nesurunaja colane amuhemuhecaaunne niha natiin, canu nesurunaja tiheeiche. Canu rai lanaa cajionene niha natiin, canu rai tiheeiche. Niheichu cunaiteein, caresero cuhane neein naaonjoaanune niha natiin turuhin cacoharaheeiche,’ naanu acaauru raine janate: ");
INSERT INTO uraNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‘Curuaanaa, esinaaena ii coroaatelanaala, cocoireeine ii cocoaelanaala, ii nenajanu lateeine ii rai telanaala, cajione lateeine ii rai telanaala, cunaiteein, caresero cuhane neein naaonjoaaine jana turuhin ii coaraelanaala, naaonjoan rejetocoaanulu,’ naain bajaauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Esinae rauhijiriinte, satiin cairicheinejeein nenacaauru cachaauruacha latei teneeichene canu raite nii teneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Satiin nitohaneein nenacaaurute, chabana sanaachara caseteco que neeurureein. Jana, coluunojoi suujuaquiin nenacaaurute, chabana sanaachara ichaonaa que neeurureein,’ naain tonoranaareein nii acaauru Curuaanaa Rey,” nae canacaanu rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Inae cachaauru rai niritohane nainaainte, niicha relai nichaanune rai: ");
INSERT INTO uraNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nii coitucuhichene rijijieeinte, coroata janoi cuhane nereein Fasocoa beseta. Inae laen Cana Coaunera Calaohi cacha caje nejanoanaa nichaaunne mucuhin teeururichaain coroso que catinaauruhane coina,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nii bananeeinte, saseredotecuru curuaanaa curuaanaa Caifasi loreri asae ita taojiaaure saseredotecuru aina Jorionichaanune bichauhenaauru, ");
INSERT INTO uraNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jesoso mucuhin, nechu nohaneein colurujueein sohin joaerateeuruhane que coaaucuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nejetaote: “Nainihaacache beseta cojoanonaa bana ichacaachene, nabana cachaauru suujua rerohecana coataa,” naaure jetao ita rai. ");
INSERT INTO uraNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betaniau, “Nabero caje nerautanaa,” naain niicha curuaateeuri- Simoon loreri asae niha Jesosone janate, ");
INSERT INTO uraNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ajeri coreti caje ichanohin boticha laaojoiri cuhane, le curuhin jujuhin- jataain coretiin nenaa amaain jetao, rori ichoae lauhecoha Jesosone jana, coturi ichoae nii jujuhi choohite nii leinjiin ene. ");
INSERT INTO uraNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nii coaraainte obajeein: “Chanuna jataain coretohane saijieein, catohaneein jujuhi lanaje caa ene. ");
INSERT INTO uraNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bana jataain coreein que necoreteein, nii rai core coriqui que, cairicheihuru coroatajanelanaala,” naacaanu aina nerelanaa nichaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","11","“Chanuna niritiin caa ene rerohecaaiche. Jataain canu rai caohachate ichae caa ene. Inae itolere bana inara aina nerihaaunni. Jana, cairicheihurute laen itolere bana neeurureein inara aina. ");
INSERT INTO uraNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Caa jujuhi choroha cajabereeo ichoae caa enenete, canu conautecuruhane coina cajabereeo rucuheca ichae. ");
INSERT INTO uraNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Esinae rauhijiriinte, cana rai chauratane sacutaain caa osa caje nichoterichaain cachane jaan que cachaauru relaauruhane jaaunru, caa cajabereeo ichoae jujuhi tiha caa ene quene maajeein cachaauru rai ereerecurureein. Nitohaneeinte, coaunojoinereein itolere bana caa ene,” nae Jesoso aina nerelanaa nichaanune rai. ");
INSERT INTO uraNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nii jana, nii aina nerelanaa nichaanune lechoonca coroataja neein nenaa Jodasite, saseredotecuru curuaanaa coaraa cue. ");
INSERT INTO uraNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nitohaneein cuhin jetaote: “Inaaojoaain carai coriqui tenaa nainequiche, inara rai Jesoso tihanune coinata,” naain acaauru caje bajaane jana nichata chooncaain coata caje nenaa coriqui teeuruhane coina rai aitocure. ");
INSERT INTO uraNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nii jaun jetaote, jelai neeorihane jana inae acaauru rai Jesoso tenaa nainihane jaan que coacuhin jetao, amuhemujue Jodasi. ");
INSERT INTO uraNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Inae nunuheca jorerera colane ichanohi faan quihuruhane jaan beseta Fasocoa cojoanonaane janate, Jesoso rohan nichuuntaacaanu: “Chu Fasocoa cojoanaa nunuhe cojoanotiin que, canaacha quiineni lenone ichacaaunne jereeita,” naain Jesoso caje bajaacaanu aina nerelanaa nichaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“Chajaain taa neseeu leinjiin cacha loreri asaae cuhin: ‘Cacha relaerate ichei, “Inae canu cojoanonaa que tihane jaunne ii loreri asaae ureeun, cuu canu aina nerelanacaauru aina Fasocoa beseta bitoaanune coinara,” naain aitoroate ii rai,’ nanichuchera,” naain canacaanu caje tabaauru letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Niritiin letoanajaa Jesosone jaun cuhin, nii naitoonjoa rijijieein Fasocoa cojoanotiin que canacaanuhacha quiineni lenone ichacure aina nerelanaa nichaanune tabaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nitohaneeinte, inae nocohecane jana, lechoonca coroatajaain aina nerelanaa nichaanune aina lenoniha ne Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nitohaneein lenoniha nihacaanune janate: “Esinae rauhijiriin, leinjiin inara cajete, cacoelaichaneei neeichene saijieein, caque nejeratenacaauru rai cacolurujueein, acaauru rai caetereeincha,” naa canacaanu rai Jesosone jaunne, ");
INSERT INTO uraNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","jataain inaderaain le cachanichaanune: “Curuaanaa, canu quenacha aitohi,” naacaanu satiin aina nerelanaa nichaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","“Caa ojoaichu cuhane faan setejiarichate nii cacolurujueein caetereein. ");
INSERT INTO uraNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nitohaneeine, canu que aitiin laenanohineein niha Cana Coaunera Quiricha inoaensi cuhanena rijijieein, Cana Coaunera Calaohi cacha caje nejanoanaa nichaaunne, nii nainaa cureeunni. Nete laen, jataain cairichaaojoareein nii canu colurujuera. Caohatorihalu niqui nitohanesihane ajiniha nejanoaenihalu nii cachane,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","“Cacha relaera, canu quenacha aitohi,” naa nii colurujueranu Jodasine janate: “Mmmjjjm, nii bajaaine rijijieeinte aicheein,” nae Jodasi rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nitohaneein lenonichaanune janate, faan mucuhin: “Narihara Cana Coaunera,” naain, cataaun nii faan tatuhin beeune beeuneein aina nerelanaa nichaanune rai teein: “Caa quihuche. Caate, cajabereeo nenaaneein ne,” naain canacaanu rai teeinte, jerichanejeein nii faan ichaane rijijieein ");
INSERT INTO uraNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","acau cooruhane jaan curu cuhane, conacai bino mucuhin: “Narihara Cana Coaunera,” naane baiha canacaanu rai nii conacai teeinte: “Satiin jiniiquiin leruune leruunein caa conacai cooche. ");
INSERT INTO uraNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Caate cacoichananeein arajii cachaauru caohachanu que canuhacha ichaneni cojunacaneein chorohi jaonojoinereein. Acate arajii osaonacaauru que suujua acaterichaaine coina orichaaunine cojunacane. ");
INSERT INTO uraNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nena laen, inae nacoauneein inara aina jiniinquiin, caa oba caje ichanohin conacai coenereeunni, Ofa Cana Coaunera Cojoanonaa que inara aina jiniiquiin neein nii bana ocoonaneein nenaa bino cohacachene reeintiaaojoaain,” nae aina nerelanaa nichaanune rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nii baihane, Quiricha Inoaensi cuhane laenanoineein nenaa salmo tabaauru que nenatichaanune nainaain, Oliboneein niicha curuateeuri ichatane ucuunno que cuhacaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","“Enene cojoanotiin cuhanete, satiin inara, Canu esenetaain canu que jaaequiin neeichene jianeein, ita caje riaaneriquicheein, Quiricha inoaensi cuhane: ‘Carenero beraicha sohin jaaoruhane janate, ita caje riaaneeurureein niicha beraihuri carenerocuru,’ naain canu que aitiin besihalune rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nena inae ohanune caje ichanacaaunne, inara ajiniha Calileea cureeunni, ecu nacoauneein jiniiquiin nenaa coinara,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","“Ii esenetaain ii que jaaecooruhane jianeein, neeuruha leeochaaurune nihanatiin, coatiha laen canu ii esenetaain ii que jaaecohanune jianerihaaunni Curuaanaa,” naa Jesoso rai Fedorone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“Esinae rauhijiriinte, enene cojoanotiin cuhane jaiti ereniha ataohari curuaanane ajiniha, nichata saain canu coitucuha nocoetoeneriquiin,” naa Fedoro rai Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","“Airihaauni bajiaata Curuaanaa. Ii aina curuaaecaain jereraa casohin cajaaoruhane coinane nihanatiin, nainihaaun ii que jaaecohanune jianeein ii coitucuha nocoetoenihanunera Curuaanaa,” naa Jesoso rai Fedorone janane, leeochaauru aina canacaanu netonai, nii aitoha Fedorone rijitojoeein aitocoaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nii baihate, aina nerelanaa nichaanune aina jelai caje amuhin, Jetesemaniineein niicha curuateeuriu cue Jesoso. Inae ecu turuhacaanune janate: “Cau nelauriaain canu cohacuchena, inara tonohanau tajiha cuhin Cana Coaunera bajani,” naain ");
INSERT INTO uraNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","jiniichaain Fedoro, coroatajai Sebedeeo calaohichuru, naaonjoaihunri amaain jataain nererojoecaaojoaain naonaain jetao, jataain inaderae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nitohaneein inaderaain jetaote: “Jataaine onaanajaanu rijitocojoaain casuujua cuhane inaderaaunra. Cau nedaain, canu jiniichaain ichaaojoeein cacohacuchera,” naain ratirinajaain jetao, ");
INSERT INTO uraNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","acaauru caje, nita cuhin neseeonraain atane que coturi temetaain jetao: “Ofa, icheine aitoon. Bana ii jereeine jana nihane, caa necairichanaa tabai caje canu rocohi. Nena canuacha jerei rijijieein ichaaine jereneeun. Ii jereeine rijijieein ichaainene jereeunra Ofa,” naain Cana Coaunera bajaane nainaain jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","jelaiha cuhin nii neeuruha aina nerelanacaaurune jaau turuha Jesosone jana jetao, najiniha sinihuruhane jana erunajaain jetao Fedoro rai: “Chanuna canu aina leratojoeein, sinilanaala ichaaojoeein nenaa naineneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sinilanaala ichaaojoeein neein Cana Coaunera bajaauche, nabana chatohanai que nesaruhin neeichene coataa. Inara suujuate niqui aitona naine, nete inara jaberoco jataain nii abaantasine,” naain jetao acaauru ratiriin jelaiha nii Cana Coaunera bajaane jaan cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nitohaneein inae coroata saain, jelaiha cuhin Cana Coaunera bajaane cuhane jetaote: “Ofa, caa necairichanaa tabai canu cojuhin canu coaaranu caje canu roconaa jereneeine, ii jereeine rijijieein ichaau,” naain jetao Cana Coaunera bajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Niritiin Cana Coaunera bajaane caje, nacoaauneein jelaiha cuhin, aina nerelanacaauru coaraa cuha Jesosone jana jetaote, jataain banetojoe niha acaauru rai sinirenane jaun nimirichaa acaauru notane jaun, sinihuru jana erunajaane jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ecu ratirinajaain jelaiha cuhin, Cana Coaunera bajaane nichatasatiha cue, nii jauriaanejeein aitohane rijitojoeein Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nitohaneein jetaote, jelaiha nacoauneein nii neeuruha aina nerelanacaaurune jaun, acaauru rene turuhin jetao: “Jaitinachura caohacha nainetojoeein siniichete. Inae laen, Cana Coaunera coitucuhichuru bijiu tenojoinichaaun, canu Cana Coaunera Calaohi cacha caje nejanoanaa nichaaunne cojoanonaa que turuha. ");
INSERT INTO uraNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Chajaain nimichucuchete amuhacachera, inae nichuuntajiha nii acaauru rai caeteraanura,” nae jetao Jesoso aina nerelanacaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Niritiin, jaiti aina nerelanaa nichaanune aina ereereeca Jesosone janate, turuha uhe, Jesoso aina nerelanaa nichaanune lechoonca coroatajaneein nenaa Jodasi, letoanajaauruha saseredotecuru curuaanaacuru curuaanaa, chaen Jorionichaachene bichauhenaauru, naaonjoainurine jaun, enuha, sabere, naaonjoain que biji achunequiin nenacaauru arajii cachaauru uhaain. ");
INSERT INTO uraNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jaiti Jesoso rene turuelanaalate, nii aina cunacaauru rai jetao: “Inae cuu turunaane: ‘Sohara cacha relaera,’ naain rai nomeri lohitoreeuni, caje coitucuhin, aca mucuhichene coinara,” naain acaauru rai be jetao. ");
INSERT INTO uraNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Niritiinte Jesoso rohan nichuuntaain: “Sohara cacha relaera,” naain Jesoso meri lohitoha Jodasine janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","“Cacoelaicha, ii jereeine rijijieein coaraain chatohaneein caetecurumiin,” nae Jodasi rai Jesoso. Nii janate Jesoso rohan nichuuntaain, Jesoso mucuure nii Jodasi amanojoinuri cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nii janate, rai sabere rocohitiin, que nii saseredotecuru curuaanaacuru curuaanaa letono uricho sauhitiin beuhitoha leinjiin cacha, Jesoso aina cunaane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","“Jelaiha rai curu cuhane, nii ii sabere teeu. Satiin sabere que sonajaain jaaoreraaurute, sabere que acaauru netonai sonojoiniha cuurureeincha. ");
INSERT INTO uraNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tana ena canu Inaca caje bajaanune, canu rai lechoonca coroata lauriin anjeraauru letoanaa nainiha, acaauru aina canu coreniha ita sooruhane coinane coitucuhine. ");
INSERT INTO uraNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nene naineneeun nitohanai ichacaaunne. Inae rai Quiricha inoaensi cuhane, catohaneein caetecururichaainne que aitiin laenaeratihalu Cana Coaunerane nainaane nihane jaun,” naainte nii mucuha unacaauru rai: ");
INSERT INTO uraNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","“Chanuna necha aansai cacha mucuha unaa tocohaneein, sabere, enuha, naaonjoainuri que biji achunequiin canu mucuha uhiche. Cojoanoonetojoeeine inara notaracaae, Teenforo asaae cachaauru relaa nenajacoon. Nii saijieeinte, canu mucunaja queneeiche, ");
INSERT INTO uraNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","inae nitohaneriquicheeine que aitiin, rai profetacuru que laenaeratihalu Cana Coaunerane nainaaichene coina,” naa acaauru rai Jesosone janate, ecu jelai ratiriin, satiin sorohacaanu aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nitohaneein Jesoso mucuhinte, saseredotecuru curuaanaacuru curuaanaa Caifasi loreri asaae amaaure nii mucuureraauru. Nii janate, nii Caifasi loreri asaae ita taojiaain neeure Moisesa aitoonjoa rauhi que cacha relaaurera aina fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nitohaneein, inae Jesoso amaauruhane janate, nita acaauru coarajeein cuujueein sacuhin, Caifasi loreri chaje rohan neeuruha Teenforo beraichacurune jaaun, ecu acaauru aina enohin lauhequiin, jelai caje coaauneein Jesoso coaraje Fedoro: “Chatohanerichaaincha,” naane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nii janate, nechu jataain nohaneein, colurujueein Jesoso atinaeratecuruhane jaanu que coaaucure saseredotecuru curuaanaacuru, chaen niha chatohanaine rucuheraneein nenacaauru Jorioocuru bichauhenaauru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nete, nitohaneein arajii cachaauru colurujeeuruha nohaneeine saijieein, nii chatohaneein teeuruhane jaanu lera erusichurene. Nii jaunte inae satononiha coroatajaain nimichuhin: ");
INSERT INTO uraNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Esinaete chuhisi: ‘Nainichaaun caa netaojiaain Cana Coaunera coroaecuruhane jaa coloheri Teenforo chamuhintiin, nichata janojoein cuhane jerichanejeein michuhanunera,’ naain erenajaquera,” naauruha nechu nohaneein colurijihane janate, inauheneeicha acaauru aonaje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nii jaunte laen nimichuhin: “Chanuna ereneei iitonai. Esinaena rauhijiriin aitoine jaunna caa ii colurujeeuruha,” naain caje bajae saseredotecuru curuaanaacuru curuaanaa, nete inauheneeicha aonaje Jesoso ");
INSERT INTO uraNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nii jaunte rai nacoauneein: “Esinae rauhijiriin, Cana Coaunera coreniha beeinena jereeun. Iina esinae Cana Coaunera Calaohi Mesihasineei,” naa rai saseredotecuru curuaanaacuru curuaanaane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“Esinae rauhijiriinte, acanichaaunne que aitohicha. Canu Cana Coaunera Calaohi cacha caje nejanoanaa nichaaunnena, coarajeeichene jana canu Inaca itolere ichana nainera Cana Coaunera raotono nichajai que lauhecoreeunnicha. Chaen techu, dede sacari jana uhin fauha uhanune coaariquicheeincha,” nae nii saseredotecuru curuaanaacuru curuaanaa rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nii jaunte obaaecane cojunacaniha rai cajione romaromaain: “Nechu jataain Cana Coaunera baijiaate, caritiin ere caa cacha. Cha nenacaaenneeina coaraain cana rai colurujuera laterihacache. Inae inara netonai, Cana Coaunera baijiaeraanu rijitiin irihane aonaquiche. ");
INSERT INTO uraNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tonaquiche jana inara, caa naitoonjoa que,” naa rai leeochaauru rai janate: “Esinaete chuhisi, aca colurujeeuruhane jaan ujuaihone. Aihane jaun ohanete caohachae,” naaure. ");
INSERT INTO uraNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Niritiinte, nomeri colunecuruha tabaaurune jana faohacure leeochaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Jana leeochaaurute: “Chajaain aihane, ii Mesihasineeine, caa ii soera cojoeluinaaura,” naain rai nomeri faojoaain soore. ");
INSERT INTO uraNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nii tonohanau, ecu airiniha lauhecoha Fedorone janate, rohan nichuuntaain: “Iitonaite, Calileea cocoaicha Jesoso aina nerejetohilu,” naa leinjiin ene coseenraneein nenaane janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","“Nii aitohine jaan cacha coitucuhaaun,” naain satiin aonajeeuruha ecu nenacaaurune urichoo suujue Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nii baihate jelai caje amuhin, rijia acuujua rohan cuha Fedorone janate, coaiteen coaraain: “Caa netonaite, Nasarete cocoaicha Jesoso aina nenaa ne,” naain leeochaauru rai biha leinjiine janate: ");
INSERT INTO uraNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","“Esinae rauhijiriin, Cana Coaunera notaracaae nii cacha coitucuaaunta,” naain nacoauneein suujue Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nii catiariinte Fedoro rohan nichuuntaacoaain: “Esinae rauhijiriinte, iitonai aina nenaaneein, ii ereecha cajete necoitucuerateeicha,” naaure nii ecu nenacaauru Fedoro rai. ");
INSERT INTO uraNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","“Esinae rauhijiriin, Cana Coaunerate coaraje nii cacha coitucuenihanunera,” naain nesuujiha Fedorone janate, nii rijieeoritiin inae ere ataohari curuaana. ");
INSERT INTO uraNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nii jaunte: “Jaiti ereniha ataoharine janate, nichata saain cacoitucuhine suujueriquiincha,” naalu rai Jesosone coacuhin, jelai caje mituhin amuhin, jataain inaderaain chanae Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Inae janohane jana jetaote, satiin saseredote curuaanaacuru aina Jorioocuru bichauhenaauru, ita suujua rijitojoeein ita suujuau tacaaure, Jesoso sohin jaaoruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nitohaneein jetaote, Jesoso ichojoaain amaain, Roma cocoaichaneein nenaa coberenadoro Filato rai teeure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Inae nitohaneein Jesoso cairichaain atinaaururichaainne que nainaain jetaote, jataain inaderaain netojoeete nii coulurujuera Jodasi. Nii jaun jetaote, nii saseredotecuru curuaanaacuru curuaanaa, chaen Jorioocuru bichauhenaauru, naaonjoainuri rai jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Osa quene nesaruun, inara rai atinaaichene coina cha ujuaihonelanaala nenaa cacha teeincha,” naain nii nichata chooncai coataneein nenaa coriqui coretecuruhane jaan cainaa Jodasine jana jetao, ranaa jerelanaala: “Nihei cha coitucunaa nainihaacaanu nii aina canacaanuta. Iichate nii coitucuujueeicha,” naaure jetao Jodasi rai. ");
INSERT INTO uraNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nii jaun jetaote Teenforo asae nii coriqui rialaaitiin ratiriin jelai caje amuhin raajenihane rai raro ruluhi ohe Jodasi. ");
INSERT INTO uraNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nii jana jetaote, nii coriqui raain jetao: “Caa coriquite, ichana corenihane jaun, leinjiin calaniheein ne. Aihana jaun, jelai teein Cana Coaunera rai canaacha tei coriqui curu cuhane, caa coriqui tenaa nainihaacache,” naaure jetao ita rai saseredotecuru curuaanaacuru curuaanaacuru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Niritiin coacuhin ita suujua tacaain jetaote: “Atane rocooruha, caje ojoaichucuru jaauruhane coinane jaan,” naain niicha curuaateeuri jelai coretecure nii coriqui coreniha, niha nejelau atane caje uhin onaane, cuu teein conautecuruhane jaanu que. ");
INSERT INTO uraNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nii jaun jetaote, Ichana Batane neein jelai curuaateeure enanetojoeein cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nitohaneeinte: “Rai core nichata chooncaain coataneein nenaa coriqui, Isaraelitacuruhacha cainai raainte, ");
INSERT INTO uraNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","coreniha: ‘Atane rocooruha, caje ojoaichu ichacuruhane coinane jaan,’ naain acaauruhacha curuaatei atane coretecure,” naain beratihalu profeta Jeremihasi que Cana Coaunerane rijijieein, nii naitoonjoa nainaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Inae coberenadoro Filato rene Jesoso amaain turuaauruhane jana jetaote: “Iina Jorioocuru curuaanaacuru curuaanaa- Rey ineein,” naain caje bajaa Filatone jana jetaote: “Esinaete, acanichaaunne que aitohicha,” naain Filato tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nii nainiha jetaote, cuu teein, Filato rai coulurujeeuruha saseredotecuru curuaanaacuru curuaanaacuru aina, Jorioocuru bichauhenaaurune jana jetao, cuu inauheneeicha aonajenajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nii jaun jetaote: “Toon ii que ereein ii coulurujueeuruhane aonaaina,” naa Jesoso rai Filatone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","cuu inauheneeicha tonoraelanaala aonajian Jesosone jaun jetao, inae rai tonaain irihane jaanu coitucuene Filato. ");
INSERT INTO uraNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Beseta bana naineein jetaote, janijiin: “Acate caohachae mituhanera,” naauruha satiin cachaurune jaan mitai nejesinane caseteco nihane caje Filato. ");
INSERT INTO uraNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nii bana jetaote, caresero cuhane niha itolere sacutaain cachaauruhacha coitucui Jesoso- Barabasineein acaauruhacha curuaatei caseteconeeinne jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","satiin netaojiaain codohacooruha, nii Jesoso colurujeeurera cachaaurune jana: “Chariji caa coroatajaaihuri caje, jianichaaunne jeriquiche. Caa Jesoso Barabasina jianerihanu. Ainihanena caa Jesoso Mesihasineein acaauruhacha curuaatei jianerihanu,” naain jetao acaauru caje bajae Filato, ");
INSERT INTO uraNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","nechu necoelai caaun, nii coulurujeeuruha raine que nainaane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Niritiin jetaote, nii cha rucuhecane jaan rori ichoae lauhaca Filatone jana: “Jiaonriha chatohaneein nii cha ujuaihonelanaala nenaa cacha tenaa coaauquine. Janotiine nii cacha coreniha, jataain baasoneein sinicoonni,” naain jetao berate rai comasai. ");
INSERT INTO uraNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nejetaote, satiin nii cuu nenacaauru cachaauru suujuau tacaaure, saseredotecuru curuaanaacuru curuaanaacuru aina Jorioocuru bichauhenaauru: “Nii Barabasi jianeein nii Jesoso atinaerateeu,” naauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nii jana jetaote: “Chariji jianichaaunne jeriquiche, caa coroatajaaihuri caje,” naain acaauru caje nacoauneein bajaa coberenadoro Filatone jana jetaote: “Nii Barabasi que tacaajeein jianeeinena jerichaanu,” naauruhane jana: ");
INSERT INTO uraNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Chajana laen ichareeun, caa Jesoso Mesihasineein acaauruhacha curuaatei aina,” naa Filatone jana jetaote: “Coroso que laen aca teeu,” naaure jetao satiin. ");
INSERT INTO uraNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Niritocuruhane jaun jetaote: “Chatohanai baasona ichae,” naa Filatone jana jetaote: “Chajaain coroso que teechaau,” naaure jetao tonijiaain ehequiin. ");
INSERT INTO uraNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nitohaneein Jesoso jianena jeriha Filatone saijieein, jianena jerelanaala rai suujua rerohecaauruha jelai ichoae jauhecotojoeriin cachaaurune jaun jetao, acau raerateein jetao: “Coatiha canu, orichaain caa cachane ujuaihoneein nerinaaunni. Inarate nii ujuaihoneein neriquicheein,” naain jetao, satiin coarajeeuruha nii cuu nenacaauru cachaaurune jana jetao, rai biji culeje Filato, nii ujuaihoneein nenihane coujunacaneein, nitohaniha acaauru ichaone jaun. ");
INSERT INTO uraNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Niritoha acaauru rai Filatone jana jetaote: “Satiin canacaanune, canacaanu bereecuru aina jiniiquiin, oha caa cachane ujuaihoneein nerichaanuhi,” naaure jetao Filato rai cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nii jaun jetaote, Barabasi jianeein, nii baiha Jesoso bisichateein acaauru bijiu teein, coroso que terate Filato. ");
INSERT INTO uraNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nii jana jetaote, niha chatohanaine rucuhecuruhane jaan coloherineein nenaa- loreri seeonjoa asae Jesoso amaain jetao, curuhacaain netaojiaain neeure satiin coberenadoro rai soodarooru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nitohaneein teein jetaote, rai cajione rocohin que cajione lanajai curuhacure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chaen couturi que ojoa caje ichanohin comai lauriaain jetao, rai biji raotono nichajai que otiha teeure. Nii baiha jetaote, nacatiha neseeonriaain: “Laraajiin ichaohine Jorioocuru curuaanaacuru Curuaanaa Reycha,” naain jetao, ");
INSERT INTO uraNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","couluneeinchuru nii rai niicha teeuri otiha que jetao, rai couturi faoha facoaain que ninichaajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nitohaneein mainajeein ninichaajeeuruhane baiha jetaote, nii cajione lanajai, que niicha curuhacuri rocohin, nacoauneein nii rai cajione esine curujuaai amaaure coroso que teeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Inae nii neeuruhane jaan jelai caje Jesoso amaauruhane jaun jetaote, Sirene cocoaicha Simoon eruhin, que nii Jesoso teeuruhane jaanu coroso baijiaeratecure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Inae nitohaneein cuhin: “Couturi Bejero,” naain acaauruhacha curuaateihu turuhin jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","elonai que jasisii bino que jetao Jesoso cocoaaure. Nejetaote, aansijiin cohin aonaain conaa jerene Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Inae coroso que Jesoso teein jetaote: “Chariji raineeicha nedareein,” naain jetao Jesoso cajione que nocoatijiaaure soodarooru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nii baiha jetaote, Jesoso asaae nelauriaacoaain beraihure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nitohaneein teein jetaote, rai couturiniha nii casetecaauruhane jaan leranu rai curuaa laenacure: Caate Jorioocuru curuaanaacuru Curuaanaa Rey ne. naain. ");
INSERT INTO uraNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Cuu jetao techu aina teein, coroatajai asijiautooru teeure coroso que, leinjiin najaa biji nichajai que, leeocha rai raotono nichajai que, naaonjoaain. ");
INSERT INTO uraNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jeloon situnacaauru cachaauru jetaote, couturi jisijisihanaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Teenforo chamuhitiin, nichata janojoeein nacoaauneein michuhin jerichanejeein tiha nocoetona jereei inatiin, chajaain ichaajenihane ijiabereeo ichoterateeu. Esinae rauhijiriin Cana Coaunera Calaohineeine, nii coroso caje faau,” naaure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","43","Jerichanetojoeein jetaotechu: “Leeochaauru ichoteratihane saijieein, tana laen raajenihane rai jaberoco ichoteratena nainihane. Aca Isaraelitacuru Curuaanaa Rey nihane, coroso caje fauhinete cana netonai esenetaacache. Cana Coauneraacha que jaaecohane jaun, chajaain ena ichoteratemiin Cana Coaunera, esinae rauhijiriin niicha belaai nihanete, cana netonai esenetaacache. Acate cana rai aitelu, Cana Coaunera Calaohi nihane que,” naain jetao que ninichaajeeure saseredotecuru curuaanaacuru curuaanaacuru, Moisesa rai rauhi que cacha ralaaureraauru, chaen Jorioocuru bichauhenaauru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nii coroatajai asijiautooru coroso que nenacaauru nihanatiin jetaotechu, nocoeje chanuure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nii jana jetaote, enoto chujutoroa caje coaauneein, nuna macohi amuritoheriha enotone reein tiaaojoaain nocojoe cana rai chauratane. ");
INSERT INTO uraNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nii rijieeoritiin jetaote, tonijiaain ehequiin: “Cana Coaunera, chanuna jelai canainatejeei,” naane neein jetao: “Eli Eli lema sabactani,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Niritohane jana, tabaauru ecu neein aonajeeurera jetaote: “Profeta Irihasi cotihacate aite,” naaure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nii jana, leinjiin acaauru caje jetaote, soroneein jeluhariin cuhin jetao, sie tocohaneein nenaa ariin ruhin, elohanti bino sisiaain jetao, jiarana nujua que nujuateein Jesoso ujuae que te, cohane coina. ");
INSERT INTO uraNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nii jana leeochaauru jetaote: “Coa rerohecaate, ichoteratiha uha niicha cotijiai Irihasine coarajihacachera,” naaure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nejetaote, nacoauneein tonijiaain auhaquiin inae ohe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nii rijieeoritiin jetaote, ecui caje coauneein ocoai cuhin nesoaiheite Teenforo cuhanai bujuaneein nenaa cajione. Nii jana jetaote, nerurujuaa cana rai chauratanene jana jetao, netatujuacoae ajerichuru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Atane banaaurune maajeein, netatujuacoaane jana jetaote, Cana Coaunera coitucueraneein onacaauru cachaauru nihanatiin jetao, o caje ichanajacoaain ichaaore. ");
INSERT INTO uraNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nitohaneein jetaote, inae o caje ichanaa Jesosone baiha jetao, Cana Coaunera nese Jerosaleeun cuuruha nii o caje ichananacaaurune jana jetao, coaranaacure arajii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nitohaneein uha carorane jana, nihacoaa cojoelanaacojoaine jana coaraain jetaote, jataain nesooneein jetao: “Esinaete chuhisi, Cana Coaunera Calaohine caa cacha,” naaure jetao, soondarooru curuaanaa aina ecu Jesoso beraiha nenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nii jana jetaote, caje icharaain netiin Jesoso coarajeeure arajii enecuru Calileea caje coauneein coroatajaneraneein sacuureraauru. ");
INSERT INTO uraNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Acaauru aina jetaote cuurelu Maadala bene Mariha, chaen Saantiaao aina Jose neba Mariha, chaen Sebedeeo calaohichuru neba, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Inae nocohecane jana jetaote, turuha uhe leinjiin Jesoso ere tonoraera coriquihonaneein nenaa Arimatea cocoaicha Jose. ");
INSERT INTO uraNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nii Jose jetaote, Filato coaraa cue, caje Jesoso jaberoco bajaane coina. Nii jana rai Jesoso jaberoco teratiha Filatone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jesoso jaberoco raain, lino caje ichanohi shojoera que conajaain, ");
INSERT INTO uraNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","que banijiaain niicha bajerateilu ajeri jachu cuhane Jesoso jaberoco rucujue Jose. Nii baiha jetaote, ajeri que caohatiin nii ajeri jachu bacuujua fuhin ratiriin jelai caje amue. ");
INSERT INTO uraNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nii jana, Maadala bene Mariha, chaen nii leeocha Mariha, naaonjoainuri jetaote, nii ajeri jachu Jesoso jaberoco teeuruhane jaan acatiha laurijiatiin nedaaure. ");
INSERT INTO uraNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nii cojoanoo, inae nebetacanaa cojoanonaa nihane jana jetaote, Filato coaraa cuure jiniiquiin saseredotecuru curuaanaacuru curuaanaacuru aina fariseeocuru. Nitohaneein cuhin, inae rene turuhin jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Curuaanaa, jaiti ichaohane banate: ‘Inae nichata janoha ohane baiha jete, o caje ichanareein,’ naain ererejetoha nii casajeneein ichaonaa cachane quene coaaucaaun. ");
INSERT INTO uraNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aihane jaun, nii rucuhecuruhane jaan ajeri jachu beraichateeu nichata janoi reeintiaain. Ainihanete, janotiin uhin rai jaberoco amaain: ‘O cajete ichanae,’ naain cachaauru coritaaurure aina nerelanacaauru. Niite laen, nii jauriaanejeein amurijiriin, jataain banejelanaala casaje nere,” naauruha Filato raine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Caa nitohanei beraichane que nenacaauru soondarooru aina cuhin, caohatiin jerequichene tocohaneein nii ajeri jachu funichuche,” nae acaauru rai Filato. ");
INSERT INTO uraNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nii jana cuhin jetaote, nii ajeri jachu niha Jesoso jaberocone jaan rai fuera sechaaure leinjiin secho que. Nitohaneein sechaain jetaote, ecu beraichanu que soondarooru ratiriin cauha cuure saseredotecuru curuaanaa curuaanaacuru aina fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Inae situha nebetacanaa cojoanonaane jana, inae ena janohajiha semana nunuhene jana jetaote, Jesoso jaberoco rucuhecuruhane jaan- ajeri jachu coaraa cuure Maadala bene Mariha aina leeocha Mariha. ");
INSERT INTO uraNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nii jana dede caje fauha anjerane jana jetaote, luhecotariin uhe jataain mijiaainetiin carora. Nitohaneein fauhin jetaote, nii Jesoso jaberoco rucuhecuruhane jaan ajeri jachu fuuruhane jaan ajeri jaberoco raain nichoae laujuae nii anjera. ");
INSERT INTO uraNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nii anjera jetaote, aiha jiacanene tocohaneein jiquihacoha rai jaberocone jana, jataain somajae rai cajione aiha dede sacarine tocohaneein. ");
INSERT INTO uraNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nii coaraain jetaote, coasina caaun rijijijianeein onaa rijiinanaain nedaaure nii beraihurera soondarooru. ");
INSERT INTO uraNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nii jana jetaote, nii coaraa cunacaauru enecuru rai jetao: “Jiaoriha casiichene. Inae, nii coroso que teein niicha ateinaauri Jesoso ariha aaichene coitucuhanura. ");
INSERT INTO uraNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Inae cau nihei. Inae nii aitoroaetohane tocohaneein o caje ichanaa. Chajaauchete, nii teeuruhalune jaan jelai coarae,” naain acaauru que nii Jesoso jaberoco teeuruhane jaan jelai coaarate nii anjera. ");
INSERT INTO uraNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Niritiin jetaote: “Chajaain erojoeein cuhin aina nerelanacaauru rai: ‘Inae jetao o caje ichanaa. Calileea cuhin jetaote, inara ajiniha turureein. Ecu jetaote coaariquicheein,’ nanichuche. Inara rai bihanune coinane cau turuun,” naain jetao, nii enecuru letoae anjera. ");
INSERT INTO uraNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nii jaun jetaote, jataain casihuruhane saijieein rachoojoeein nii Jesoso atane bana jelai caje erojoeein uhin biha uure nii enecuru, aina nerelanaa nichaanune rai. ");
INSERT INTO uraNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nii jana jetaote, uujueeuruha nii enecurune jana acaauru rohan neeoritiin acaauru rai iriha Jesosone jana rohan nichuuntaain, rai tijia que nebalurucaain cutujuaain jetao coroaaecure nii enecuru. ");
INSERT INTO uraNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nii jana jetaote: “Jiaonriha casiichenera. Chajaain canejeraneein nenacaauru rai benichuchete, Calileea cuuruhine. Ecune ita coaarichaanuhi,” nae jetao, nii enecuru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nitohaneein biha cuuruha enecurune nainiha jetaote, saseredotecuru curuaanaacuru curuaanaa rai jetao, neseeu cuhin jitariin niicha coaracuri biha cuure nii atane banau Jesoso jaberoco beraiha nenacaauru soondarooru tabaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nii jaun jetaote, ita suujuau tacaauruhane coina Jorioocuru bichauhenaauru coaraa cuure saseredotecuru curuaanaacuru curuaanaacuru. Nitohaneein inae ita suujuau tacaain jetaote, jataain arajiin soondarooru rai coriqui teein jetao: ");
INSERT INTO uraNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ ‘Janotiin sinihacaanune tonohanaute, turuhin Jesoso jaberoco amaaure aina nerelanacaauru,’ naauche. ");
INSERT INTO uraNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nii jana coitucuhin, chatohaneein inara tenaa coaauca coberenadoro Filatonena, ita suujua tacaain caohaterichaanuhi, nabana baasoneein inara tihane coataa,” naain jetao, nii soondarooru suujuateeure saseredotecuru curuaanaacuru curuaanaacuru aina Jorioocuru bichauhenaauru. ");
INSERT INTO uraNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nii jaun jetaote, nii coriqui raain jerichanetojoeein nii suujuatenajaauruhane rijitojoeein jetao, aitocure nii soondarooru. Nii jaun jetaote, niritiin acaauru coritaauruhane jaun, eneenetojoeein nii esenetaaure Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nitohaneein canacaanu rai beratiha Jesosone jaunne, Calileea nii naitoonjoa ichatane ucuunno cuhacaanu lechoonca leinjiin Jesoso aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ecu turuhacaanune janate, ecu canacaanu ajiniha niha Jesosone jaun, rohan turuhin jaiti acanihane esenetaaureniha tabaaurune saijieein coroaecaanu. ");
INSERT INTO uraNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nii janate canacaanu rohan nichuuntaain: “Canu Inaca Cana Coaunerate, chauratane, dede, naaonjoainuri rai cocoainacaineein nihanune coina caeteein ne. ");
INSERT INTO uraNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aihane jaun, chajaain satiin caa chauratane sacutaain lauri lauri nenacaauru cachaauru relanichuche inara relaanune rijijieeinte, canu ere tonoraera neeuruhine. Chaen, Canu Inaca, canu- rai calaohinichaaunne, Cana Coaunera Suujue, naaonjoain nichaanune rai canacaanu cachaneein nenaa jereraauru cojunacateein baotisanajaauche. ");
INSERT INTO uraNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chaen inara rai aitonajaaocaaunne rijijieein, nii caitoonjoa tonoraain ichaaoruhane coina relanajaauche. Jerichanejeeinne besautiha cana cojoanonaane reeintiaaojoaain itolere bana inara aina nereeunni,” naain necoe Jesoso.");
INSERT INTO uraNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Caate nunuhe caje coauneein Cana Coaunera Calaohi Jesocurisito que erenaa raotono ne. ");
INSERT INTO uraNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Niite inoaenlu nere bera inoaensi Isaihasi que berateein laenaratiha Cana Coaunerane jaun, nii aitohane rijitojoeein: “Nii Canuhacha letoai Canu ere berate, ii ajiniha cuhin turuhine jaan bero rucuhereein. Nitohanihane jaunte: ‘Cana Curuaanaa turunajaanu bero raujiaauche,’ naain cacha areroo rohan situnacaauru cotijiaain suujuatereein,” naain nere bera inoaensi Isaihasi que berateein laenaratiha Cana Coaunera ");
INSERT INTO uraNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nii rijijieein jetaote chuhisi, inae cacha areroo cachaauru baotisaain: “Inara osa jianeein, esinae rauhijiriin Cana Coaunera coitucuhin nacoauneein inara ichao coreein neeichene cojunacaneein acauhanau teein baotisanojoineein neeichene inara osa caje inara ichoteratemiin Cana Coaunera,” naain belu jetao acaauru rai Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nii jana jetaote, satiin Jodea batane que nenacaauru aina Jerosaleeun nenacaauru naaonjoainuri nii Joaan ere aonaa curejetecurelu. Nitohaneein cuhin ecu turuhin esinae rauhijiriin suujuelanaala osaaocuruhane beeuruhane jaun jetao, nucuhe Jorodaan cuhane teein acaauru cojunacatiha acaauru baotisarejete nii Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Camecho ujui caje ichanohin cajione que cajionequin jetaote, jacari caje ichanohi que ichoraquiin, sisiincho, irichaje, naaonjoainuri que jetao lenoneein nerejetelu nii Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nitohaneein jetaote, Cana Coaunera ere beebejeein jetao: “Canu baihate ureein leinjiin jataain canu amurijiriin nelateein nenaa. Niheichu rai safato ichora rutuhanune coina nihanatiin nelatejeerinaauni. ");
INSERT INTO uraNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Canune acau que inara camujuaain inara baotisaaun. Jana acate laen inara baotisaa ureein Cana Coaunera Suujue que,” nae jetao cachaauru rai Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nii cojoanonaa bana jetaote, Calileea batane que nenaa Nasarete caje amuhin, nucuhe Jorodaan auhaniha turuha Jesosone jana jetao, ecu Jorodaan cuhane teein acaentonai camujuaain baotisae Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nii baotisaa Joaane jana acau caje mituhane rijieeoritiin dede coaraa Jesosone jana jetaote, nejoracaa dede bacuujuane jana caje uhin serori rijijieein nichoae fauha uhe Cana Coaunera Suujue. ");
INSERT INTO uraNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nii jana dedeeu tonii jetaote: “Ii te jataain canuhacha jereein canuhacha cocoainanohin cacalabineein neeicha,” naain toniha erenaane jana jetao aonajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nii baiha jetaote, cacha nenaja nihei que Jesoso amae Cana Coaunera Suujue. ");
INSERT INTO uraNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nii jaun ucuae ataibinaecuru jana niha jena chonca janohin Cana Coaunera Calaohi Jesosone jana jetaote, baaso que saruhane coina cojuhin coaraa moconajaerane jana jetao, Jesoso coroatajanecure Cana Coaunera letonocuru anjeraauru. ");
INSERT INTO uraNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Inae caresero cuhane Joaan enoaauruhane baiha jetaote, Calileea batane que cue Jesoso, Cana Coaunera ere Erenaa Raotono que ereerejeein cachaauru rai bihane coina. Nitohaneein inae ecu turuhin jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Inae ichuunijiha Cana Coaunera Cojoanonaa. Aihane jaun Cana Coauneraacha beratenojoin Erenaa Raotono esenetaain tonoraauche,” naain beebeje cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nii jana jetaote, Calileea conemuri auhaniha cuujihane jaun jetao, coroatajai ate mucueracuru Simoon, chaen nejera Aanderesi, naaonjoainuri coarae Jesoso, acauhanau rai rede nalaaecuruhane jana. Nitohaneein acaauru coaraain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","“Chajaauche canu aina. Aihate nii ate mucuhichene rijijieein, canu rai cachaauru mucuhin raeraneein neeiche,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nii rijieeoritiin jetaote, rai rede ratiriin Jesoso aina cuure. ");
INSERT INTO uraNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nii caje basiinjiin cutiin jetaote, coroatajai ate mucuurera- Sebedeeo calaohichuru Saantiaao aina rai nejera Joaan eruha cue Jesoso, bote cuhane neein redeeuru rucuheca neeuruhane jana. ");
INSERT INTO uraNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nii coaranaacane rijijieeoritiin cotihanaacane jaun jetaote, bote cuhane acaauru coroatajaneraauru aina nii acaauru inaca Sebedeeo ratiriin Jesoso aina cuure. ");
INSERT INTO uraNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Inae Caferenaaon turuhin jetaote, nebetacanaa cojoanonaa bana ita taojiaain, Cana Coaunera rai rauhi que ereereecuruha Joriocurune jaan coloheri sinacoca asaae cuhin cachaauru relaane nunuhetiha cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nii jana jetaote, cojoaelatiin aonajeeure cachaauru, Moisesa aitonjoan rauhi que cacha relaaurera amurijiriin esinae rauhijiriin suujua caje coitucuhin aitohane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nii jana jetaote, nii netaojiaauruha cachaaurune jaan coloheri sinacoca asaae ne leinjiin cacha- suujua cuhane Moconajaera letono siricha. ");
INSERT INTO uraNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Aca jetaote ehequiin: “Chanute canacaanu rene turuha uhita Nasarete cocoaicha Jesoso. Jerihane nechu jataain canacaanu itajeranu quete turuha uhicha. Raotojoeeinne canu, ii Cana Coaunera Calaohi neeine coitucuunra,” nae Jesoso rai. ");
INSERT INTO uraNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nii jana jetaote: “Coa iriha. Caa cacha jianeein amuura,” nae jetao Jesoso, nii cacha suujua cuhane nenaa Moconajaera letono rai. ");
INSERT INTO uraNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nii jana jetaote, rijijijianeein nii cacha teein, tonijiaain ehequiin mitue nii Moconajaera letono, nii cacha suujua caje. ");
INSERT INTO uraNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nii jana satiin nesoonetiin jetaote: “Chatohanai cacha relaera cachana caa ai. Coatiha cacha relaauruha cacha relaaurerane rijijieein cacha relaai. Caate laen nohanelanaala esinae rauhijiriin cacha relae. Chaen techu moconajaera letonocuru nihanatiin nere tonoraain cacha suujua caje mituhin amuure,” naain jetao ita caje bajaaure nii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nii jana jetaote, coa carajaaeriin Jesoso benaa coitucuure satiin Calileea batane que nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Inae netaojiaain Cana Coaunera rai rauhi que ereereecuruha Jorioocurune jaan coloheri sinacoca caje mituhin jetaote, Saantiaao, Joaan, naaonjoanuri aina jiniiquiin, Aanderesi aina Simoon loreri asaae cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nii jana jetaote, inae nii loreri asaae turuuruhane jana, ajaa caaun cunaiteein ecu tocoeeque Simoon tano. Nii jaun jetaote, Jesoso rai beeuruhane jaun, ");
INSERT INTO uraNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","rohan nichuuntaain rai biji que michuhane jana jetao, inae caje amue ajaa. Nii rijieeoritiin inae caje amuha ajaane jaun jetaote, nimichuhin acaauru coroaate nii cunaitenaa Simoon tano. ");
INSERT INTO uraNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Inae sohane jaun nocohecane jana jetaote, Jesoso rene satiin cunaitenacaauru, chaen suujua cuhane Moconajaaera letono sirichaauru, naaonjoainuri cachaaurune maajeein amaaure, acaauru rautaa Jesosone coina. ");
INSERT INTO uraNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nii jaun jetaote, satiin nenaanajaauru caje cuhin, ecu acuujua niha netaojiaaure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nitohaneein jetaote, araai laurii cunai caaun cunaitenacaauru cachaauru rautaain, Moconajaera letono sirichaaurune maajeein rautae Jesoso. Nejetaote laen ereeuruha nii cacha suujua cuhane nenacaauru Moconajaera letonocurune caohate Jesoso, raotojoeein acanihane coitucuuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Inae janonaa jerihane jaun jetaote, nimichuhin nii nese caje cuhin, jelai Cana Coaunera bajaa cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nii jaun jetaote, leeochaauru aina jiniiquiin cuhin Jesoso ariha cue Simoon. ");
INSERT INTO uraNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eruhin jetaote: “Satiin cachaaurute ii ariirijia amuhemuhecure,” naauruha Jesoso raine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","“Chajaau chacuchete ichuun nenacaauru leeocha nenanajaauru cuhin Cana Coauneraacha beratenojoin erenaa benichaache. Nii coinane jelai caje mituhin cajiha uun,” naain acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nitohaneein jetaote, cajihaneein nenaanajaauru amuhemujueein, satiin Calileea batane sacuritaain Joriocuru rai netaojiaauruhane jaan coloherihuru asaae Cana Coaunera ere beebejeein, moconajaera letonocuru sirichaauru cachaaurune maajeein rautaain amuhemujue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nii jana jetaote, Jesoso rene turuhin jetao: “Jereeine jana nihane canu rautaai caa canu cosibi caje,” naa leinjiin cacha cosibi caaun cunaitenaa, nacatiha neseeonrihaainne jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","cairichaaojoaain coaraane jaun jetao, biji que mucuhin: “Jerichaaun chujian. Ii caje amuhine caa ii cosibi,” naa nii cacha rai Jesosone ");
INSERT INTO uraNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","rijieeoritiin caje amuha nii cosibine jaun jetaote, inae somaraain ne nii cacha. ");
INSERT INTO uraNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nii nerautaane rijieeoritiin rai necoeein jetaote: “Aonaaun. Coa caa ii rautaanune biha chuni rai. Raujiaain Cana Coaunera ere que cacha relaera neein nenaa saseredote coaanihun ii coaraane coina. Chaen inae nerautaai nii ii cosibi cajene coaracuruhane coina, aitoha Moisesa aitonjoan rauhine rijijieein, Cana Coaunera belaaine jaanu amaain cunihute inae ii cosibi caje nerautaaine coitucuurumiin satiin cachaauru,” naain jetao jataain suujuateein nii cacha letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nii jana jetaote, satiin cachaauru rai nii nitohaneein jaberoco rautaa Jesosone que nereretaa cue nii cacha. Nii jaun jetaote, inae neseeuru raotojoeein turunaa nainenihane jaun jetao, neniha cachane jaaun cuhin amuhemujue Jesoso. Nejetaote, lauri laurichuru caje cuhin coaraa cuure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Nii baiha janojanoheriin catiaain jetaote, coaiteen Caferenaaon cue Jesoso. Inae ecu turuhin, loreri asaae nihane coitucuhin jetaote, rene turuha cuuruha arajii cachaaurune jana jetao, acaauru rai Cana Coaunera ere beebeje Jesoso. Nitohaneein arajiin turuuruha cachaaurune jaun jetaote, jataain nemoha loreri asajine jaun, nii acuujua rohan nihanatiin nene turuha cachane jaannu. ");
INSERT INTO uraNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nii jana jetaote, Jesoso rene leinjiin cacha jiurona amaaure jenai cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nejetaote, jataain arajiin turuha cachane jaun, Jesoso rene nii jiurona cacha turuanaa nainecurenihana jaun jetao, loreri coarana joaracaain rai nela cuhane tijichaain, nii niha Jesosone jaan jeloon nii jiurona cacha faaure. ");
INSERT INTO uraNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nii cunaitenaa rautarichaainne esenetaain amaauruha nii amaaurerane coaraane jaun jetaote: “Inae ii osa caje ii ichoterateein, ii que casuujua acatichaaunra cacalabi,” nae jetao nii cunaitenaa rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Nii jana ecu neein aonajeein jetaote: “Chanuna caritiin ere caa cacha. Nechu jataain Cana Coaunera niha nocoetohane jaunte aite. Leinjiin Cana Coauneraachate nainere osa sitaa cacha cajene,” naain jetao suujua cuhane ereerejeein laurujualaurujuaain aonajeeure Moisesa aitoonjoan que cacha relaaureraauru tabaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Niritiin suujua cuhane coaaucuruhane que nainaain jetaote: “Chanuna niritiin inara suujua cuhane coaauquiche. ");
INSERT INTO uraNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Cha caaintanerihana nii jiurona rai: ‘Inae ii osa caje ichoteratenojoineein,’ naain irihaca ne. Ainihane: ‘Nimichuhin chela seriin amuu,’ naacane. ");
INSERT INTO uraNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Coarajeeuchenejian, Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne, itolere curuaanaa neein nihanu caa cana rai chauratane quene coaaratete, rai nosa caje cacha ichotena nainichaaunne coitucuhiche,” naain jetao, nii jiurona rai: ");
INSERT INTO uraNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ii raine aitoon. Nimichuhin chela seriin chenenajau caunihu,” naa Jesosone rijieeoritiin jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","satiin nii ecu neein coarajeeurera notaracae jetao, nimichuhin rai nela seriin jelai caje amue nii jiuro caaun cunaitenaa. Nii jaun jetaote, satiin cojoelatiin jetao: “Chabana catohani coarahaacacheta,” naain jetao Cana Coaunera coroaecure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nii baiha jetaote, coaiteen nemuri auhaniha cuha Jesosone jana, rene turuuruha arajiin cachaaurune jaun jetao, acaauru rai Cana Coaunera ere beebejeein acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nii caje cuujueein jetaote, Romanocuru rai impoestonu que cacha cobaraain coriqui raeraneein nihane jaun rai rori ichoae lauhecoha Arafeeo calaohi Lebine jana coaariin jetao: “Chajaau caniha,” naa Jesosone jaun jetao, nii rijieeoritiin nimichuhin Jesoso aina cue Lebi. ");
INSERT INTO uraNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nii baiha jetaote, nii Lebi loreri asae lenoniha niha aina nerelanacaauru aina Jesosone jana jetao, cuu nii Lebi aina lenoniha neeure arajiin leeochaauru Romanocuru rai impoestonu que cacha cobaraain coriqui raaurera, leeochaauru cachaauru- baasoneein ichaoha benojoihunri, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nitohaneein Jesoso aina lenoniha neeuruha nii nitohaneein ichaonacaauru cachaaurune coaracuruhane jaun jetaote, nii Jesoso aina nerelanacaauru rai jetao: “Chasiina taa Romanocuru rai impoestonu que cacha cobaraain coriqui raaurera, baasoneein ichaoha benojoihunuri, naaonjoaihunri aina lenone inara relaera,” naaure jetao fariseeocuru aina Moisesa aitoonjoan que cacha relaaurera, Jesoso aina nerelanacaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nii jana jetaote, acaauru aonajeein jetao: “Coatiha coichaera latecuruhi rauronacaauru. Leinjiin cunaitenacaauruhachate coichaera latecure. Coatiha osa colane nenacaauru cotihaca uhaaun. Osa aina nenacaaurune cotihaca uun,” naain jetao acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Joaan Baotisita sacuurera aina fariseeocuru sacuurera jetaote niqui, suri couu netiin Cana Coaunera bajaebajaecure. Nii jana jetaote, Jesoso rene turuhin jetao: “Chanuna jana chaen, Joaan, fariseeocuru, naaonjoaihunri relanojoinuru jataain Cana Coaunera bajaae bajaaecure suri couu netiin. Nete laen itolere bana ii aina nerelanacaauru, coaaerai cohin, lenoneein, naaonjoaunreta,” naauruha Jesoso raine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","“Aiha chuhisi niqui. Nete ene ranaa jeriha cachana jaa beseta que neeuruhane jaun, suri couu nenaa nainecurene caa cotihanohinchuru, jaiti acaauru aina niha nii ene raeranu cachane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nete laen inae nii ene ranaa jerera cacha amaauruhane, suri couu neein inaderaa cuurureeincha,” naain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Coaracuche nachuhinti, nihei chuni obiri enachasine soaain, cajione siri que counera. Nitohaneein nii obiri enachasine soaihanete, nii obiri enachasine asaaere nii cajione siri. Chaen caohachaain nedanaa nainerihei nii obiri enachasine, nii cajione siri que couneraane. ");
INSERT INTO uraNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nii rijijieeinchu, nihei chuni inae conaca que tiha coaaeraine jana, cuhane ichonai tera. Nitohaneein cuhane teraa ichonainete naasaaere nii coaaerati. Nitohanihane jaunte, caohachae coaaerai nejesinaneein niha coaaeraine. Chaen ichonai, ichonai nejesinajeein nihane caohachae,” naain jetao cachaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nebetacanaa cojoanonaa bana aina nerelanacaauru aina jiniiquiin temule jana situhin, amuhemuheca Jesosone jana jetaote, quihuruhane coina aroso rijijieein nenaa tirico inaa moloonejeeure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nii coarajeein jetaote: “Chanuna nebetacanaa cojoanonaa nihane jaun cocoaeraa nitohanai ichara natiin, nitohanai ichacure nii ii aina nerelanacauru,” naauruha Jesoso rai fariseeocurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tana nitohanihalu Rabirine coitucuhichene: ");
INSERT INTO uraNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","“Nii Rabiri jetaote, saseredotecuru curuaanaa neein niha Abiatane bana Teenforo asaae enohin Cana Coaunera que banijiaain nenaa faan qui, nii rai corihacuru aina jiniiquiin mijiitooruhane jaun, saseredotecuruhacha nii faan quinaa nainihane saijieein,” tana naain laenanohiniha Cana Coaunera Quiricha cuhanene ereretaain aonaquichene. ");
INSERT INTO uraNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","“Nebetacanaa cojoanonaate coaunaelu Cana Coaunera, bana nebetacanaa nainiha cachane coina. Coatiha cacha cairichaeranu que nebetacanaa cojoanonaa coaunaailu Cana Coaunera. Nii jaunne laen canu naineeun nebetacanaa cojoanonaa bana nihanatiin quiicha ichana jerei ichaain nihanune. Nitohaneeinte inara rijijieein cachaneein rai Calaohi nichaaunne cocoainaain letoae Ofa Cana Coaunera,” naain jetao fariseeocuru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nii baiha jetaote, coaiteen netaojiaain Cana Coaunera rai rauhi que ereereecuruha Joriocurune jaan coloheri sinacoca asae enoha cuha Jesosone jana jetao, cuu ne leinjiin cacha jiurona bijii. ");
INSERT INTO uraNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nii jaun jetaote, nebetacanaa cojoanonaa bana nihane jaun nii Jesoso coarajeeure fariseeocuru, nii jiurona bijii cacha rautaane niha nechu jataain colurujeeuruhane jaan leranune coina. ");
INSERT INTO uraNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nii jaun jetaote, nii jiurona bijii cacha rai jetao: “Nimichuhin nii cacha cataaun chujutoroaau,” naain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","“Chatohanai ichacaane caohachae nebetacanaa cojoanonaa bana, baaso ichaain cacha ichao itajihacanena. Ainihane cacha ichao rai caohacha ichacaanena,” naain fariseeocuru caje bajaa Jesosone jana jetaote, inauheneecha curuaaequiin aonajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nii jaun jetaote, nii nere aohana jerecurenihane jaun, nererojoecaaojoaain inaderaain, nii curuacaain nenacaauru coaraain jetao: “Ii biji raujiaau,” naa nii cacha rai Jesosone jana, biji sijitaain raujiaa nii cachane jana jetaote, inae nerautaain neraujiae rai biji. ");
INSERT INTO uraNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nii coaraain jetaote, airiniha mituhin ita suujuatiha cuure Erodesi ere tonoraeraauru aina fariseeocuru, Jesoso sohin jaaoruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nii baihate, rene turuuruha arajiin Calileea cocoaichacurune jana, nii Calileea conemuri auhaniha cue aina nerelanaauru aina Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jataain itolere ichaain, cunaitenacaauru cachaauru rautaain, naaonjoaane coitucuuruhane jaun jetaote, coaraa cuure Jodea batane, Jerosaleen, Idomea batane, nucuhe Jorodaan auhaniha neein enoto mitu nichajai cajeeurune maajeeinchuru cuhin jetao, Tiro, Sidoon, naaonjoainuri batane cajene maajeein turuha cuure arajiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nii jaun jetaote, chajaain letona jatoraain bote coaracuruha aina nerelanacaaurune coina, acaauru rai aite Jesoso, nabana sururucuruha nii arajiin turunacaauru cachaaurune coataa. ");
INSERT INTO uraNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jataain araai laurii cunai caaun cunaitenacaauru rautaane jaun jetaote, satiin cunaitenacaauru Jesoso jaberoco dadanaa jerecure nerataauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nii jana suujua cuhane moconajaenra letono sirichaauru jetaote, Jesoso coaracuruhane jetao, nacatiha neseeonriaain: “Iite Cana Coaunera Calaohi neeicha,” naain jetao cojiorichure. ");
INSERT INTO uraNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nejetaote aonajeeuruha cachaaurune jana, que ereeuruha nii moconajaera letonocurune caohate jataain Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Nii baiha jetaote, ichatane ucuuno que iniin caohachaain niicha coaracuri cotijiae Jesoso. Inae satiin netaojiaauruhane jana jetaote, janiinajaain acaauru caje lechoonca coroatajaain nenacaauru cocoainae, corihaneein jiniichaain amuhemujeein, chaen nere beraanu que naaonjoaaunruhane coina. Nii lechoonca coroatajai niicha cocoainaauri jetaote, afosotooruneein curuaatenajaain letoanajaen, ");
INSERT INTO uraNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","cacha suujua cuhane nenacaauru moconajaera letonocuru sitaain, cunaitenacaaurune maajeein rautaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nii lechoonca coroatajaain niicha janiichuri jetaote, nii jauriaanejeein Simoonneein niicha curuaatei Fedoro, chaen ");
INSERT INTO uraNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nejera Joaan aina Sebedeeo calaohichuru Saantiaao naaonjoainurine. Acaauru jetaote, Boanerges neein curuaatenajae: “Arara calaohichuru,” naaneneein. ");
INSERT INTO uraNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Chaen Aanderesi, Ferifi, Bartolomee, Mateeo, Tomasi, Arafeeo calaohi Saantiaao, Tadeeo, Celoteneein niicha curuaatei- Simoon, ");
INSERT INTO uraNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","chaen nii acaauru lechoonca coroataja, Jesoso colurujueranu Jodasi Isacariote naaonjoainurine. ");
INSERT INTO uraNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nii baiha jetaote, leinjiin loreri asaae enoha cuha Jesosone jana jetao, ecu rene arajiin netaojiaauruha cachaaurune jaun jetao, nii aina nerelanacaauru aina jiniiquiin lenonena nainecurene. ");
INSERT INTO uraNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Inae nitohaneein ecu niicha ichanenu coitucuelanaala niha Jesosone beeuruhane coitucuuruhane jaun jetaote, raa cuure naraaichuru. ");
INSERT INTO uraNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Chaen Jerosaleen caje turunacaauru Moisesa aitoonjoan que cacha relaaurera netonai jetaote, “Moconajaeracuru curuaanaa Beelseboote, caa cacha rai catohanei ichaane jaan teein ne, nii aina cacha suujua cuhane nenaa moconajaeracuru letono sitaane coina,” naaure jetao ita rai. ");
INSERT INTO uraNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Niritocuruhane aonaain jetaote, acaauru cotijiaain: “Chasiina nejesinanejeein, chatohaneein ita teein, ita sitanaa nainere moconajaera. ");
INSERT INTO uraNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Niheichu leinjiin atane que ichaonacaauru, nejesinajeein itaque nejerateein nihane raotiin ita aina ichaonaa nainecururihei. ");
INSERT INTO uraNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Niheichu leinjiin loreri asaei ita que nejesinajeein nejerateein nenaa nainecuruhi coroatajai cacha, lesajeein ita que nejerateein nihane raotiin ita aina ichaonaa nainecurenihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nii rijijieeinchu ita que nejesinajeein nejerateein nenaa nainecuruhi moconajaera aina rai letonocuru, enaacha jiniiquiin ita itajenaa nainecururihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nihei chunei jataain laraajiin nenaa cacha loreri asaae enohin niicha sirii rulunaa nainera. Jauriaanejeein biji ichohacane banaachate nainere caje niicha sirii ruluhane. ");
INSERT INTO uraNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Cana Coaunerate, itolere baaso ichaain neosateein, itolere baaso que ereein naaonjoaaunruha cachaaurune niha natiin acaauru que suujua acateein ne. ");
INSERT INTO uraNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nete laen rai Suujue que baasoneein iriha cachane, chabana que Suujua acatenereein Cana Coaunera. Nii cacha baasoneein que ereite chabana satonoelanaala caseteconiha cureein,” nae jetao Moisesa aitoonjoan que cacha relaaurera rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Moconajaaera letono siriha beeuruhane jaun jetaote, acaauru rai aite Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nii jana jetaote, turuha uure neba aina Jesoso nejeraauru. Nejetaote loreri asae enoelanaala, airiniha neein cotiharateeure. ");
INSERT INTO uraNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nii jana jetaote, nii Jesoso curuhacaain nenacaauru cachaauru jetao: “Taute airiniha turuhin ii ariiriichure ii neba aina ii nejeraauru aina ii baihuru,” naauruha raine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","“Charijina canu neba, canu nejeraauru, naaonjoainere,” naane baiha jetao, ");
INSERT INTO uraNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","nii curuhacaain nenacaauru cachaauru coaraain jetao: “Caaurute canu neba, canu nejeraauru, canu baihuru, naaonjoainuri ne. ");
INSERT INTO uraNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chunocoha jeriha Cana Coaunerane rijijieein ichaohin, Cana Coaunera jerenohin icharate, canu neba, canu nejera, canu bai, naaonjoainurine,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nii baiha nacoaauneein nemuri auha niha teein cachaauru relaa Jesosone jana jetaote, ecu arajiin netaojiaauruha cachaaurune jana, nii nemuri cuhane niha leinjiin botene jaun jetao, cuhane fauhin nelauriariin lauheque Jesoso, nemuri auhaniha neein coarajeeuruha cachaaurune jana. ");
INSERT INTO uraNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nitohaneein bote cuhane fauhin jetaote, ecu neein aonajeeuruhane jana araai laurii itolereeuru que cuaain acaauru relae. ");
INSERT INTO uraNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nitohaneein acaauru relaain jetaote: “Caohachaain caa quere aonacuche. ");
INSERT INTO uraNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Leinjiin cacha, ucuhe riaacane jana tabaauru bero cuhane nalunacaaurute turuhin quihure tajaaecuru. ");
INSERT INTO uraNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jana tabaauru jataain neniha atane jioonone jaun samaata choae nalunacaaurute erojoeein omaroe, ucuacaain neniha atane jioonone jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nete enoto ajaano caun, neniha cojoaisine jaun ohe nii omarona. ");
INSERT INTO uraNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jana tabaauru ucuhecuru, ojoa jana nalunacaaurute omarohane saijieein amurijiriin omarohin soha ojoane jaun, inacae lanaala ohacoae. ");
INSERT INTO uraNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jana tabaauru ucuhecuru atane caohacha choae nalunacaaurute omarohin caohachaain inaacane jaun, le ucuhecuru caje tabaauru nichata choonca ucujeein, saota choonca ucuheneein, le fasha ucuheneeichuru inacae,” naain acaauru relaain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Caohachaain aonacurumiin urichonacaauru,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Inae caje amuuruha nii cachaaurune jana, jelai nedaa Jesosone jana jetaote, nii cachaauru relaane jaan bajaaure caje, nii lechoonca coroatajaain aina nerelanacaauru aina ecu rohan nenacaauru leeochaauru cachaauru, coitucuuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nii jana jetaote, acaauru rai: “Inara quete asinojoineein nenaa rai Cojoanonaa coitucuerate Cana Coaunera. Nete laen rai cachane lanaala nenacaauru que, nereretanaa que cuaain acaauru rai be, ");
INSERT INTO uraNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","coaracuruha neniha natiin coitucuurenihane coina. Niheichu aonacuruhane niha natiin, coitucuuruhane coataa. Nabana aonaain aina cuaain esenetaauruhane, acaauru osa acaauru ichoterateein acaauru que suujua acatiha Cana Coaunerane coataa,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Niritiin jetaote, aina nerelanacaauru rai jetao: “Ta caa inara relaanune jaan aonaain coitucuhichene. Chatohaneeina jana leeochaauru que cuaain inara relaanune coitucuriquiche. ");
INSERT INTO uraNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nii ucuhe riaarate Cana Coaunera ere bera rijijieein ainaa ne. ");
INSERT INTO uraNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Niha nii coina tabaauru tabaauru nii bero cuhane naluhin nitajenaa ucuhe rijijieein nenacaauru cachaauru. Nii coinate Cana Coauneraacha beratenojoin aonacuruhane niha natiin, inae acaauru coritaa uha moconajaerane acaacha esenetaain, inae suujua cuhane Cana Coaunera coaaucuruhane jianecure. ");
INSERT INTO uraNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nii leeocha cachaaurute, nii samaata choae nalunaa ucuhe rijiichure. Nii jaunte Cana Coaunera beratenojoin jereein rautaain aonacuruhane baiha, ");
INSERT INTO uraNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","caohachaain acaauru suujua cuhane coaaucurenihane jaun, Cana Coaunera esenetaauruhane jianecure. Nii jaunte Cana Coauneraacha beratenojoin esenetaain neeuruhane jana, cairichanojoineein, cojunojoineein, naaonjoaauruhane, Cana Coaunera esenetaaruhane jianecure. ");
INSERT INTO uraNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jana leeocha cachaaurute, nii ojoa jana nalunaa ucue rijijieein neeure. Cana Coaunera beratenojoin aonacuruhane baiha niha natiin, ");
INSERT INTO uraNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","jataain acaauru ichaohacha que suujua teeuruhane jaunte, nechu jataain raaje necoritaain coriquihonaneein nenaa jereein, itolere sirina jerecuruhane jaun, caohachaain Cana Coaunera esenetaain tonoraaurenihane jaun nitajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jana leeochaaurute atane caohacha choaae nalunaa ucuhe rijijieein neeure. Acaaurute Cana Coaunera ere aonaain, caohachaain Cana Coaunera esenetaaure, nii chabana jianelanaala. Nii esenetaeraauru tabaaurute, le ucuhe caje nichata choonca ucuheneein le tijirii caje tera, saota choonca ucuheneein, le fasha ucuheneein tera, naaojoaain le tijirii caje teeurera rijijieein neeure,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Niritiin jetaote: “Nihei chuni cono mocohin bujuaihu tera. Nitohaneein bujuaihu telanaalate, jianacoon conohanau neeuruha turunacaaurune coina ecuun teeure. ");
INSERT INTO uraNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nii cono aina cuaainte jianacoon coitucunojoiniha cureein coitucuerae lanaala itolere asinojoineein inaraacha ichai. ");
INSERT INTO uraNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aonacurumiin urichonacaauru,” naain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Caohachaain nainaain inaraacha aonai aonacuche. Charijieein teeinti leeochaauru coaraquiche, nii rijijieeinte inara netonai coaareein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Caohachaain niicha jerei rijijieein ichaohin nere tonoraerate, jeelai amuritoheriin coroatajanereein Cana Coaunera. Nii rijijieein techu ena canuhacha tei raera jelai amuritoheriin rareein inae ecu tihane bana. Jana nii canuhacha tei latelanaala nenaate cha colane nedaareein inae ecu tihane bana,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Niritiin jetaote: “Temule jaera cacha rijiicha Cana Coaunera cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Charijieein teeinti temule jaain, janotiin berailanaala sinii, jerichanejeein jiichoo berailanaala nihane tonohanau coitucuenihane jana omaroe nii niicha temui, nii rijiicha Cana Coaunera Cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","29","Charijieein teeinti, raajenihane omarohin, nalojoaacoaain, inacaain, inae tainaca que teein cataa nii temulene taihure cachaauru, nii rijiicha Cana Coaunera cojoanonaa,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Niritiin jetaote: “Chaaquenejianra inara rai Cana Coaunera cojoanonaa que cuaain aitete coitucuhicheta. ");
INSERT INTO uraNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Leinjiin mosatasa ucuhe temunacai rijiicha. Acate itolere temulecuru ucuhe fautaain jataain aansijien. ");
INSERT INTO uraNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nete inae temunojoineein nihane, itolere temulecuru ocoana jana nenacaauru amurijiriin neleereein fojoeein nuna seeonjoan nihane jana, nichoae tajeein loroore tajaaecuru, nii rijiicha Cana Coaunera cojoanonaa,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nitohaneein jetaote, araai laurii que cuaain itolere acaauruhacha coitucui- acaauru ichao que cuaain cachaauru relaain Cana Coaunera ere beebejeein acaauru relae, aonaain coitucunaa nainecuruha nereentiaain Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nitohaneein jetaote, rai cacha nelanaala nenacaauru relaa Cana Coaunera Cojoanonaa quene, acaauruhacha coitucui- acaauru ichao que cuaain relanajae. Jana aina nerelanacaauru relaane jetaote, rauhijiriin, “Naaonjoainte ne Cana Coaunera Cojoanonaa,” naain Cana Coaunera Cojoanonaa beein que relanajae. ");
INSERT INTO uraNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nii cojoanotiin bananeein aina nerelanacaauru rai jetaote: “Jamaauchete nemuri jerau cunichaache,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nii jaun jetaote, ecu cachaauru ratiriin, nii fauhin lauhequiin cachaauru relaa Jesosone jaan bote cuhane fauhin amaauruha aina nerelanacaaurune jana jetao, acaauru jiniichaain cuure leeocha boteeuru. ");
INSERT INTO uraNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nitohaneein cuuruhane jana jetaote, jataain mijiaaineein uha cujuana tabai aina fichafichanaane jana jetao, acaauru bote cuhane acau enoaa fichafichanaane jaun, inae nalunaa jere nii cuurunaja bote. ");
INSERT INTO uraNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nii jana bote roe cuhane binaao choae tocoeequiin sinii siniicha Jesosone jana jetaote: “Cacha relaera chajaain nocoo. Inae nalurichaacheje. Tana inae nalunaa jerichaachene que tonajeeine,” naauruha nocoaain aina nerelanacaaurune jana jetaote, nimichuhin: ");
INSERT INTO uraNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","“Coaa inooniha. Chajaain nesuruu,” naa nii nemuri fichafichanaa rai Jesosone rijieeoritiin jetao, nesuruha cujuana aina nii fichafichanaane jaun raotojoeein cuujeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Inae nesuruha nii fichafichanaane baiha jetaote: “Chanuna jataain nesooneeiche. Chanuna cha esenetaeneeiche,” nae jetao nii aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nejetaote jataain nesoonetooruhane jaun jetao: “Chatohanaineeinna ne caa cachate, nere tonoraain nesurue cujuana tabai aina nemuri fichafichanaa,” naaure jetao ecu ita rai nii aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Nitohaneein cuhin inae nemuri jerau turuuruha Cadara batane que jana, iniha cuha Jesosone jana jetaote, que tacaain coinetiha cue leinjiin cacha- suujua cuhane moconajaera letono siricha. Nii cacha jetaote atane bana caje uhin ai, ");
INSERT INTO uraNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ecu ichaohane jaun. Nitohaneein rai suujua cuhane moconajaera letono sirihane jaun jetaote, cadena que niha natiin ichohana nainene chuni. ");
INSERT INTO uraNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Araai saain tijia aina biji ichohacuruha cadena quene niha natiin jetaote, molomolonijihanaane jaun, chatohaneein tenaa nainene nii chuni. ");
INSERT INTO uraNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nii jaun jetaote, janotiin, jiichoo netojoeeinchuru ichatane janaauru amuhemujueein, atane banaauru ichoae amuhemujueein, eheehejeein, ajeri jaberoco ichoae comohin, naaonjoain amuhemujue nii cacha. ");
INSERT INTO uraNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nii jaun jetaote, coriaae uujiha Jesosone coaariin, jeluhariin coineteein nacatiha neseeonriaain ehequiin jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Jiaonriha caniha nenoaain carerojoecaaine, acaihanijin nenaa Cana Coaunera Calaohi Jesoso. Jiaonriha atiin nohane Cana Coaunera coreniha chatohaneein caeteeine,” nae jetao ");
INSERT INTO uraNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","nii cacha suujua cuhane nenaa moconajaera letono. Nii cacha suujua jianeein amuhane coina: “Nii cacha suujua cuhane neein, cacha suujua aasaequine caje mituhin amuura moconajaera letono,” naa Jesosone jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Niritiin jetaote: “Tonaa ii curuaa,” naain caje bajaa Jesosone jana jetao, “Jataain araaichaanune jaunte Lejion ne canu curuaara,” nae jetao Jesoso rai. ");
INSERT INTO uraNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nejetaote, jelai batane caje jaoha Jesosone caohate jataain nii moconajaera letono nii cacha suujueniha nenaa. ");
INSERT INTO uraNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nii jana ichatane ucuuno rohan lenoniha neeuruha arajiin coosichurune jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","“Atiin taa coosichuru suujua cuhane canacaanu letoaau,” naaure jetao Jesoso rai, nii moconajaera letonocuru cacha suujua cuhane nenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nii jaun caje bajaauruhane rijitojoeein jeriha Jesosone jaun jetaote, nii coosichuru suujuaniha enooruhane jaun, ucui caje nomaroteein acauhanau naluhin, acau que nereeonohin oore nii coroata oaraancai coosichuru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nii jaun jetaote, nii coaraain jelai caje sorohin, neseeu cuhin, nenaanajaaunru, naaonjoainu cuhecujueein biha cuuruha nii coosichuru beraihurerane jaun jetao, turuhin coaraa cuure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nii jana jetaote, nii niha Jesosone jaun turuuruhane jana jetao, cojurihu cacha caohachaneein nenaa tocohaneein necoreeteein laujuae, nii suujua cuhane arajiin moconajaera letono coitucuchuhi siricha cacha. Nii jana coaraain nesoonetooruha nii coaraa cunacaauru cachaaurune jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","nii coosichuru suujua cuhane enooruha nii moconajaera letonocurune jana, ooruha nii coosichurune jana, nerautaa nii moconajaera letono siricha cachane beeure nii coaraa cunacaauru rai, nii ecu neein coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nii jaun jetaote, chajaain erojoeein jelai caje amuha Jesosone luhecaaure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nii jana, inae jelaiha bote cuhane fauha cuha Jesosone jana jetaote, aina cuhane coina rai aite nii moconajaera letono sirihane caje nerautanaa cacha. ");
INSERT INTO uraNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nejetaote, aina cuhane jerelanaala: “Chajaaincha chenenajaun cauhin, charaaichuru rene turuhin, cairichaaojoaain ii coaraain itolere ichaa iniha Cana Coaunerane benihun acaauru rai,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nii jaun jetaote, Decapolis batane que nenacaauru nenaanajaauru cuhecujueein, itolere ichaa coreniha Jesosone biha nii cachane jaun jetao, satiin cojoelatoore aonajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nii baiha jelaiha nemuri jerau cauha cuha Jesoso, bote cuhane jana jetaote, najiniha arajiin netaojiaain cohacuruha nemuri auhaniha cachaaurune jaun jetao, ecu turuhin ne nii cachaauru aina Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nii jana jetaote, turuha cue leinjiin sinacoca curuaanaa neein nenaa Jairo. ");
INSERT INTO uraNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Turuhin jetaote: “Onaa jeriha canu cacunune jaunne ii coaraa uun. Chajaaute atiin nohane turuhin nichoae ii biji meracaete nerautaain ichaohine,” nae jetao Jesoso acatiha neseeonriaain nii Jairo. ");
INSERT INTO uraNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nii jaun jetaote, aina cuha Jesosone jana, jiniichaain cuuruha arajiin cachaaurune jaun jetao, jataain arajii cachaauru cataaun cuujue. ");
INSERT INTO uraNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nii arajiin cunacaauru cachaauru jana jetaote cue, leinjiin ene lechoonca coroata jaanacaain jaberoco caje ichana jaohajeein nenaa. ");
INSERT INTO uraNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aca jetaote, nii rai chaque nelatejeecane que airijiin jitariin niicha sirii jaohin arajii cacha coicharaauru que nocoicharatihane niha natiin nerautasilanaala jataain taaeneein cuujue nii rai cunai. ");
INSERT INTO uraNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nii ene jetaote, Jesoso benaa inaaoriin cuhin coaraain, leeochaauru cachaauru jana cutiin, Jesoso janori nichae marotiin cajione auha mucuuri, ");
INSERT INTO uraNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Caa cajione auha mucuurihanune niha natiine nerautareeunni,” naain esenetaane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nii Jesoso cajione mucuhane rijieeoritiin nesuruha ichanane jana jetaote, inae nerautanaaneein naonae rai jaberoco. ");
INSERT INTO uraNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nii jana caje mituha niicha ichana nainei cacha rautaane jaaque nainaain jetaote, nii cachaauru coaraain: “Chana toon cacajione mucue,” naa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","“Tana jeranu ii sururucuruha cachaaurune coaraainete. ‘Chana toon cacajione mucue,’ naain bajaai,” naaure jetao Jesoso rai nii aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nejetaote, rai cajione mucuera coaraane coina, nii rohan nenacaauru cachaauru cajanaain coarae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nii jaun jetaote, nesoone caaun rijijijianeein nacatiha neseeonriaain, nii suujue lanaala esinae rauhijiriin, “Naaonjoaain ii cajione mucuhanune rijijieeoritiinne caa canu cunai caje nerautaaun” naain be nii ene. ");
INSERT INTO uraNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nii jaun jetaote: “Ii rautana nainichaaunne esenetaaine jaunte, inae nerautaai. Raotojoeein raurohin caunihun,” nae jetao nii ene rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Niritiin ereereeca nii ene rai Jesosone jana jetaote, nii ranuna inaca sinacoca curuaanaa Jairo loreri caje turuha uure cachaauru. Rene turuhin jetaote: “Inae oha ii cacunu. Coa inacojoeein nii cacha relaera rerohecaa,” naaure jetao nii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nejetaote, nii acaauru aohana jerelanaala nii sinacoca curuaanaa rai jetao: “Jiaonriha acaauru esenetaain nesooneeine. Raujiaaincha rautaanune esenetaau,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","38","Nitohaneein inae nii sinacoca curuaanaa loreri asae turuuruhane jana tonijiaain cojioriin chanaauruha cachaaurune jana jetaote, aina cuuruha leeochaaurune jerelanaala, Fedoro, Saantiaao, chaen nii Saantiaao nejera Joaan, naaonjoainuri aina jiniiquiin enohin jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","“Chanuna niritiin cojioriin chanaaiche. Coatiha ohane jaun aihei caa ranuna. Sinihane jaunte ai,” naa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jesoso coenacure cuu nenacaauru cachaauru. Nii jana jetaote, satiin nii cuu nenacaauru cachaauru mitaain, nii ranuna inaca aina neba, chaen corihaniha cunacaauru, naaonjoainuri aina jiniiquiin nii ranuna rene enohin jetao, ");
INSERT INTO uraNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","biji que mucuuriin: “Talita coom,” nae jetao nii ranuna rai Jesoso. “Icheine aitoon ranuna. Nimichuu,” naa jetaote aite Joriocuru ere cuhane. ");
INSERT INTO uraNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nii rijieeoritiin nimichuhin ruharuhaca nii lechoonca coroata jaanacai ranunane jana jetaote, cojoelatiin coarajeeure nii cuu neein coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nii jana jetaote, jataain chuni rai beeuruhane caohatihane baiha jetao, nii ranuna coroaateeuruhane coina aite Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nii baiha jetaote, aina nerelanacaauru aina jiniiquiin, jelai caje cuhin rai nataneu cauha cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Inae nataneu turuhin, nebetacanaa cojoanonaa bana sinacoca asae enohin cachaauru relaane nunuhetiha Jesosone jana jetaote, nii relanajaa Jesosone aonajeein jetao: “Chuna nerelaete toritiin itolere coitucuhin que cacha relae. Chaa cajena itolere coitucutiin, chabana coaaraai cojoelanaacojoai ichaane coinane maajeein nerelae. ");
INSERT INTO uraNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tana caa, Mariha calaohichuru Saantiaao, Jose, Jodasi, Simoon, naaonjoainuri nejera, tabara caje itolere rucuhele icharaneein nenaa carfinteroneein nerejetohane. Tana chaen rai baihuru cau cana aina ichaaoruhane,” naain jetao ita caje bajaaure cojoelatiin, nii ecu arajiin nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Niritiin rai nere tonorana jerecurenihane jaun jetaote: “Itolere banate niqui cuhane jaaunru, Cana Coaunera ere bera profeta que suujua acateein esenetaain neeure cachaauru. Nete laen rai nataneu nenacaauru naraaichuru que suujua acateein esenetana jerecurene. Niheichu nii nihane jaan loreri asaae nenacaauru niha natiin esenetaauruhi,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Niritiin jetaote, ecu cojoelanaacojoai ichaelanaala, coroatajajeein ecu nenacaauru cunaitenacaauruhacha mucuhin rautanajae. ");
INSERT INTO uraNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nitohaneein esenetana jerecureniha cachaaurune jaun jetaote, acaauru cojoelate Jesoso. Nii baiha jetaote, Nasarete rohan nenacaauru neseeuru cuhecujueein, cachaauru relaa cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nitohaneein jetaote, leeocha neseeuru cuhecujueein cacha suujua cuhane nenacaauru moconajaera letonocuru coitucuchuhichuru sitaain cachaauru rautaauruhane coina nii lechoonca coroatajaain aina nerelanacaauru cotijiaain cocoainanajaain letoanajae coroatajaanana coroatajaananaain Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nitohaneein letoanajaain jetaote, acaauru atora, acaauru achano, coriqui, naaonjoain amaelanaala, ");
INSERT INTO uraNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","acaauru safatocuruhacha curujuaain, nii necoreeteeuruhane coina acaauru cajione amaelanaala, acaauru biji achuneecha baaejeein bero cuhane cuuruhane coina acaauru rai aite. ");
INSERT INTO uraNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Niritiin letoanajaain jetaote: “Leinjiin loreri asae turuhichene, ecu sinihuche inaraacha ichai nainaain jelai caje amuhichene reentiaain. ");
INSERT INTO uraNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Chunijihun turuhichene jaaunru, caohachaain inara coaana jerelanaala inara aohana jerecurenihane, jelai caje amuuche, inara safato que nenaa utoone riariaain ratiriin, inae nitajeeuruhane rai neeuruhane que nainacuruhane coina,” naain jetao nii aina nerelanacaauru letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nitohaneein cuhin jetaote, nacoaauneein Cana Coaunera coitucuhin aca jerihane rijijieein neeuruha cachaaurune coina acaauru rai aitiin, ");
INSERT INTO uraNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","arajii moconajaera letono sirichaauru cachaaurune maajeein raautaain, arajii cunaitenacaauru rautaaure erene que rujuanajaain nii aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nitohaneein itolere ichaa Jesosone beeuruha itolere sacuritaaine jaun jetaote, Erodesi netonai coitucue. Chaen jetaotechu: “Joaan Baotisitate ichanacaihara. Nii jaunte, nii itolere cojoelanaacojoai ichana naineraneein necaihara,” naa Erodesine jana jetaote; ");
INSERT INTO uraNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","“Jerihanete Profeta Eliasinecaihara,” naaure leeochaauru. Nii jana leeochaauru jetaote: “Inoaenlu profetacuru rijijieein nenaa profetate aicaihara,” naaure. ");
INSERT INTO uraNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nejetaote, niritocuruhane aonajihane jaun: “Acate Joaan ne. Rai nuluno moloeratihanulu natiinte, inae nacoaauneein o caje ichanacaiha,” nae jetao Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erodiasi coreniha jetaote, Joaan mucuerateein cadena que ichojoaain caresero cuhane terate Erodesi. Nii Erodiasi jetaote, Erodesi nejera Ferifi comasaineein nelu. Nejetaote, comasaineein sirilu Erodesi nii rai nejera comasainihane saijieein. ");
INSERT INTO uraNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nii jaun jetaote: “Jiaonriha ii comasaineein taa inejera comasai siriinera,” nae jetao Erodesi rai Joaan. ");
INSERT INTO uraNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Niritoha Erodesi rai nii Joaane caje coaauneein jetaote, nii Joaan cotaairiin sohin jaohene rijitojoeein nerejete Erodiasi. ");
INSERT INTO uraNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nejetaote sohin jaonaa nainene, esinae rauhijiriin leinjiin cacha- saantoneein Cana Coaunera letononeein nihane coitucuhane jaun, coasiha cocoaerateraneein niha Erodesine jaun. Nitohanihane jaun jetaote, iriha Joaane rautatiin aonaane jaun nii aina chatohanai niicha ichanenu coitucuelanaala ne Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nejetaote, nejanoa bajaanaa bitoaane coina lenone jaain, que jauriineein nenacaauru curuaanaacuru, chaen rai soondarooru curuaanaacuru, chaen Calileea cocoaichacuru jataain nelatecuri cotijiaain beseta ichaa Erodesine jana jetao, Joaan sohin jaohene rijitojoenajaaocane jana, suujua rijijieein erue Erodiasi. ");
INSERT INTO uraNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nii jana jetaote, nii beseta ichaane jaa coloheri asaae enohin raansaa cuha nii Erodiasi cacunune jana jetao, nii raansaane jana rautatiin coaraje Erodesi, nii ecu aina lenoniha nenacaauru aina jiniiquiin. Nii jana jetaote: “Joaaereen iicha jerei bajaau cacajene ichei tera. ");
INSERT INTO uraNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cana Coaunera notaracaaene chaelai, iicha jerei bajaai cacajene tereeunicha. Nainichaaun cataaun leruhin caa quiicha beraai atane tihanunera,” nae jetao araai saain nii ranuna rai Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nii jaun jetaote, jelai caje mituhin: “Cha bajareeun cajete oma,” naa cuha neba raine jana jetaote: “Chajaain ena caje Joaan Baotisita couturi bajaau,” nae jetao nii ranuna neba. ");
INSERT INTO uraNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nii jaun jetaote, jelaiha soroneein enohin jetao, “Ena carai leinjiin plato cuhane Joaan Baotisita couturi teeinene jereeun,” naa jetao cue nii ranuna Erodesi rai. ");
INSERT INTO uraNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nii jaun jetaote, jataain inaderae Erodesi. Nejetaote, satiin niicha cotihacuri urichoo Cana Coaunera notaracae aitohane jaun, nii caje niicha bajai tenaa nainenihane que aitona nainene. ");
INSERT INTO uraNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nitohanihane jaun jetaote, nii rijieeoritiin leinjiin soondaro letoae Erodesi, Joaan couturi molohin raa cuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nii jaun jetaote, caresero cuhane cuhin Joaan couturi molohin leinjiin plato cuhane uhaain, nii ranuna rai tiha soondarone jaun jetao, neba rai te nii ranuna. ");
INSERT INTO uraNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nii jana jetaote, inae nitohaneein Joaan teeuruhane coitucuhin jetao, nii Joaan jaberoco raain conautiha cuure sacuureraauru. ");
INSERT INTO uraNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nitohaneein letoanajaa Jesosone caje turuhin jetaote, aina netaojiaain itolere ichaain Cana Coaunera ere que cachaauru relaain, naaonjoaaunruhane beeure Jesoso rai, nii lechoonca coroatajaain niicha cocoainaauri afosotoorune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","“Chajaauchete neniha cachane jaun cuhin, jelai raotojoeein nebetacanichaachera,” nae jetao acaauru rai Jesoso, cauhajeeuruhane niha natiin arajiin turuhajeeuruha cachaaurune jaun, lenonecuruhane teeureniha acaauru raine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nii jaun jetaote, leinjiin bote cuhane fauhin neniha cachane jaun, jelai Jesoso aina cuure nii niicha cocoainaauri afosotooru. ");
INSERT INTO uraNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nejetaote, arajii cacha cuuruhane coarajihane jaun, nii cuuruhane jaan jelai coitucuhin, satiin neseeuru caje arajiin cuhin jetao, acaauru ajiniha soroneein jeluhariin cuhin turuure. ");
INSERT INTO uraNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nitohaneein cuhin acaauru ajiniha turuuruhane jaun jetaote, ecu turuhin bote caje iniha cunajaun jetao, arajiin ecu cachaauru coaraa Jesosone jana, beraicha colane nenaa carenerocuru rijijieein aihuruhane jaun jetao, cairichaaojoaain acaauru coaraane jaun, ecu araai laurii niicha coitucui que relanajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nii jana inae sohane jaun jetaote, rohan nichuuntaain: “Inae soha. Coatiha nihei caa jana cacha. ");
INSERT INTO uraNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chajaain cachaauru rai nocoeeute ichuun nenacaauru nenaanajaauru, neseeuru, naaonjoainuri cuhin, chaelai lenone ariin coretiha cuuruhine,” naauruha aina nerelanacaaurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Niriimiin. Chajaain acaauru coroaateeuche inara,” naa Jesosone jana jetaote, “Aihana jaunna, coroata fashai denario coreneein faan coretiha cuhacaanune jereei, acaauru coroaatichaachene coina,” naaure Jesoso rai aina nerelanacaauru. Nii le denariote le jiichoo amihanenaa core ne. Niritocuruha aina nerelanacaaurune jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Inatajaain faan siriquiche. Chajaain coaanihuche,” naa Jesosone jaun, coaraain jetaote, “Saoquijieein faan, ita que jerajejeein ate, naajeeichate neeje,” naaure jetao aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nii jaun jetaote, joaenreen omane ichoae nelauriaauruha cachaaurune coina aitoha Jesosone jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","tabaauru le fashaain, tabaauru saoqui chooncaain, naaonjoaain neleruhin nelauriaaure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nitohaneein laurianaacane baiha jetaote, nii saoquii faan aina coroatajai ate raaoriin jabaaequiin dede coarajeein jetao, Cana Coaunera bajaain cataaun faan taturiin aina nerelanacaauru rai te jetao Jesoso, cachaauru rai chaluuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nitohaneein jetaote, jerecuruhane jaaun tiaojoaain nainaain lenonecuruhane baiha, ");
INSERT INTO uraNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","lechoonca coroata omariin, nii faan aina ate caute que omari memoaaure. ");
INSERT INTO uraNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Saoqui oaraancai cachaauru jetaote, nii saoquii faan que lenonecure, acaauru rai faa Jesosone jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nii baiha jetaote, aina nerelanacaauru letoae, bote cuhane fauhin nemuri jerau Betesaaidau ichoaichaniha turuuruhane coina. Nii tonohanau jetaote, ecu nedaain cachaauru rai necoe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Inae cachaauru rai nocoihane baiha jetaote, ichatane ucuuno que cuhin Cana Coaunera bajaa cue. ");
INSERT INTO uraNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nii jana jetaote, inae nocohejihane jana, nemuri cataaun cuujueeure nii aina nerelanacaauru bote cuhane. Nii jana jetaote, ecu jelai atane choae jaiti nihane jana, ");
INSERT INTO uraNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","acaauru que tacaain uha cujuanane jaun, necairichajeein taraacajeein cuujeeuruhane coaraje Jesoso. Nii jana inae janohe lalajihane jana jetaote, acaauru caaijie acau choae cuhin acaauru rohan situha cunaa rijijieein acaauru nichae cuujue. ");
INSERT INTO uraNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nitohaneein acau choae cuujihane jana, satiin coaracuruhane jaun jetaote, nesoonetiin anucainiha beein auhaaocure. Nii rijieeoritiin jetaote, acaauru rai: “Jiaonriha inacojoeein nesoonetiin casiichene. Canune aihunra,” naain, ");
INSERT INTO uraNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","acaauru aina bote cuhane fauha Jesosone jana jetaote, inae nesuruha cujuanane jaun, jataain cojoelatoore, ");
INSERT INTO uraNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","nii cojoelanaacojoaain faan faain acaauru notaacane sainejeein itolere ichana nainihane que nainaelanaala, “Naaonjoaanne jaunte catohanai ichae,” naain coitucunaa nainecurenihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nitohaneein cuhin nemuri jera jaaoruhane jaun jetaote, Genesareta bataneu turuhin, ecu acaauru bote jauriaain cositeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Inae bote cositeein caje inihuruhane rijieeoritiin jetaote, Jesoso nihane coitucuure nii cocoaichacuru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nii jaun jetaote, satiin nii jelai batane sacuritaain nii niha Jesosone jaan jelai coitucuhin jetao, rene cunaitenacaauru amaaure ela cuhane tijichanajaain. ");
INSERT INTO uraNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Chunijihun nenaanajaaunru, neseeuru, berooru cuhane, naaonjoainu cuha Jesosone jaaunru jetaote, najiniha situnajaaunru jeloon ela choae cunaitenacaauru teein, Jesoso rai aitocure, cajione auha mucuuruhane coina. Nitohaneein satiin Jesoso cajione mucuurera cunaitenacaauru jetaote, nerautaacoaaure. ");
INSERT INTO uraNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nitohaneein jetaote, Jesoso coaraa cuure Jerosaleeun caje turunacaauru Moisesa aitoonjoan que cacha relaaureraauru aina fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Acaauru jetaote, aihuruhalu acaauru inoaensihurune rijijieein acaauru rai rauhi tonoraelanaala lenonecuruhane ajiniha biji culejelanaala lenonecuruha Jesoso aina nerelanacaauru tabaaurune coaraain jetao, acaauru que ereeure. ");
INSERT INTO uraNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nitohaneein aihuruhalu acaauru inoaensihurune rijijieein ichaaoruha fariseeocuru aina satiin Jorioocurune jaun jetaote, lenonecuruhane ajiniha biji culejeein lenonecure itolere bana. ");
INSERT INTO uraNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jerichanejeein jetaote, lenone arihuruhane caje turuuruhane nii aitoha acaauru rai rauhine rijijieein biji culejeein lenonecure. Nitohaneein jetaote, araai lauriin ne acaauru ichao, lenonecuruhane ajiniha acau cooruhane jaan curu niha natiin culejeein, acau curu culejeein, coadarojoe culejeein, acaauru sininaja jelai niha natiin culejeein, naaonjoaaunruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nitohaneeuruhane jaun jetaote: “Chanuna nii aitoha rauhine rijijieein aihuruhalu cana inoaensihurune rijijieein, lenonecuruhane ajiniha biji culejeein lenonecurene ii aina nerelanacaauru,” naaure jetao Jesoso rai Moisesa aitoonjoan que cacha relaaurera aina fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nii jaun jetaote acaauru rai: “Esinae rauhijiriinte, inara que aitiin laenaelu Cana Coaunera ere bera inoaensi profeta Isaihasi, nechu jataain nohaniha Cana Coaunera coitucutoha nocoenacaauru. Nii que aitiin: ‘Caa cachaaurute, nechu jataain nujuaaecha que canu coroajeein neeure. Nete acaauru suujua, cacaje coriaae ne. ");
INSERT INTO uraNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nii jaun nii chaque nelatejeehai netaojiaain canu coroaecuruhane, nechu jataain caitoonjoanelanaala nenaa que nejesinajeein ita relajeein aihuruhane jaun,’ naa Cana Coaunera acaauru quene laenaelu profeta Isaihasi. ");
INSERT INTO uraNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chanuna nitohaneein Cana Coaunera aitoonjoan que jaolecohin inara inoaensihuru rijijieein ichaonaa jeriquiche inara,” naa acaauru raine baiha jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Itolere bana inara inoaensihuru ichao rijijieein ichaonaa jeriquichene jaunte, Cana Coaunera aitoonjoan que jaolecohin aohana jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","‘Inara inaca, inara neba, naaonjoainuri que inara suujua acateein neeuche. Chateeinti baasoneein neba, inaca, naaonjoain que ereein ne. Niite ateinanohiniha cureein,’ naelu jetao Moisesa. ");
INSERT INTO uraNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nete inara aitocoiche, leinjiin cacha, rai inaca, neba, naaonjoain rai. ‘Coatiha inara rai cha tenaa nainihaaun, satiin quiicha sirii corban neein nihane jaun,’ naane caohachae inara rai. (‘Corban,’ naane jetaote, acaauru ere cuhane, ‘Cana Coaunera que banijiaain nenaa,’ naa aite.) ");
INSERT INTO uraNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chaen techu, inara rai caohachae, inae niritiin erei cacha, rai inaca, neba, naaonjoain rai chaaelai tenaa nainenihane que aitocoichene. ");
INSERT INTO uraNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nitohaneein inara inoaensihuru ichao sacuhin neeichene jaunte, Cana Coaunera aitoonjoan tonorana jerelanaala itajeein neeiche, nejesinajeein jelaaicha que ita relaain neeichene jaun,” nae jetao Moisesa aitoonjoan que cacha relaaurera aina fariseeocuru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Niritiin jetaote, nacoaauneein nii ecu nenacaauru cachaauru cotijiaain jetao: “Satiin caa ena inara rai aitocoaaunne jaan aonaain coitucuuche. ");
INSERT INTO uraNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Coatiha joaereen lenone quiha cachane coreniha que jaolequiin nihei Cana Coaunera. Leeochaauru cairichanaa jerenacaaun, suujua cuhane baasoneein coacuhin baaso ichaeraauru quete laen jaolequiin ne Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Esinae rauhijiriin urichocoichene aonacuche,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Niritohane baiha ecu cachaauru ratiriin loreri asae enoha cuha Jesosone jana jetaote, nii cachaauru relaane jaan bajaaure caje aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nii jana jetaote: “Tana inara netonai aonaain coitucuhichene. Tana joaereen lenone quiha cachane coreniha que jaolequiin neniha Cana Coaunerane coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nii cachaacha quii lenonete, nii cacha suriicha cuhane enohin, nii baiha mitue, suujua cuhane enoelanaala,” nae jetao. Niritiinte, joaenreein lenone quiha cachane niha natiin, que jaoleconaa naineniha Cana Coaunerane coitucuerate cana que Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Cacha suujua caje mitunaa baaso niicha coacui, niicha ichai, naaonjoain corenihate laen, cacha que jaolequiin ne Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nitohaneein suujua cuhane baasoneein coacuin baaso ichaeraaurute, namute quicha aina niha natiin ichao jeracohin, asijiauharitiin, sonajaain jaohin, ");
INSERT INTO uraNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sinijeranelanaala nenaa ene aina ichaohin, laurijira rucuhele jereein, namute cacha cairichanaa jerenacaaun que ereein, namute cacha coritaain, itolere niicha jerei nejesina ichaain, necoelajauharitiin, namute cacha cairichaa casajenetiin, namute cacha que necohasitaain, suujua coaraain chaachaelanaala, naaonjoaaunre. ");
INSERT INTO uraNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Niichurute satiin cacha suujua caje mituhin cacha que jaolequii niha Cana Coaunerane jaan teraneein ne,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Inae cachaauru relaane nainaain jetaote, jelai caje coaauneein Tiro bataneu turuha cue Jesoso. Nejetaote, ecu turuhin leinjiin loreri asae enoe, coitucuuruha jelai cocoaichacurune jerelanaala. Nii sainejeein jetaote, ecu turuhin nihane coitucuurihure. ");
INSERT INTO uraNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nii jaun jetaote, inae ecu nihane coitucuhane jaun, rene turuhin Jesoso acatiha neseeonriaa cue leinjiin ene, suujua cuhane moconajaera letono coitucuchuhi siriha rai cacunune jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nii ene jetaote, Jorio niheichuru Sirofenicia batane cocoaichacuru bene ne. Aca jetaote, Jesoso rene turuhin conujue cacunu suujua cuhane nenaa moconajaera letono coitucuchuhi sitaane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nii jaun jetaote: “Coa canu rerohecaa. Naininaaun Cana Coaunera cachaneein nenacaauru que banijiaain nenaa ruluhin tihanu remaae raine,” naa rai Jesosone jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Aihachuhisi niquicha Curuaanaa. Atiin ii araaichuru Joriocuru rautaaine rijijieein canu cacunu rautaainene jereeunra. Remaae rijijieein canacaanu coaraaine niha natiincha,” naa Jesoso rai nii enene jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“Aihachuisi. Esinae rauhijiriinte aitohi. Inae ii cacunu caje mituhin amuha moconajaera letono coitucuchuhi. Inae naineein jelaiha chenenajaun cauha cuhinera,” naa Jesosone jaun, ");
INSERT INTO uraNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","nenajaun cauha cuhane jana jetaote, loreri asaae sininajaun niha nii cacunu ranunane jana eruha cue nii ene. Nejetaote, inae nii ranuna suujua caje mituhin amue moconajaera letono coitucuchuhi. ");
INSERT INTO uraNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nii baiha jetaote, nacoaauneein Tiro batane jelai caje amuhin, Sidoon batane, Decapolis batane, naaonjoainuri nenacaauru neseeuru ichoae rauhijiriin situhin nitihonohin cuhin jetao, Calileea conemuri turue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nitohaneein inae ecu turuhane jana jetaote, rene leinjiin urichoelanaala, raotiin eresilanaala, naaonjoaain nenaa turuaain jetao, biji que dadaain nii cacha rautaane coina rai aitocure. ");
INSERT INTO uraNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nii jaun jetaote, jelai cachaauru udaa nii cacha amaain jetao, nuricho jachuuru cuhane biji couturichuru enoaain, lune soriin lele ichoae teein, ");
INSERT INTO uraNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ecuun jabatoroaain dede coaraain neraain jetao: “Efata,” naane jetao: “Najachuu,” naa aite Joriocuru ere cuhane. ");
INSERT INTO uraNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Niritohane rijieeoritiin, inae najachuha nurichone jana jetaote, inae raotojoeein erenaa naine rai lele netonai. ");
INSERT INTO uraNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nitohaneein rautaain jetaote niqui, nii chuni rai beeuruhane caohate Jesoso. Nejetaote, jataain beeuruhane caohatiha sainejeein jataain que naurutaain beeure. ");
INSERT INTO uraNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nii caje coitucuhin jetaote: “Itolere banate caohacha ichae, uricho saaecuru niha natiin urichohin, raotiin eresilanaala niha natiin erenaa naineein, naaonjoaanne jaun,” naaure jetao cojoelatiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nii baiha nacoaauneein netaojiaauruha arajiin cachaaurune jaun jetaote, jataain neniha acaauru lenonena jaun aina nerelanacaauru cotijiaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Inae nichata janohinte canu aina neeure caa cachaauru. Jana nihei caohachanainejeein lenonecuruhane jaanu. Nii jaaunne jataain cairichaaojoaain acaauru coaraaun. ");
INSERT INTO uraNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Coroaatenajaelanaala acaauru nenajaun letoanajaanunete mijitenacaaun aterona nainecure, tabaauru coriae caje uuruhane jaun,” naa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","“Chaa caje eruhin najian caa jeeoni cacha coroaaterichaache, caa jana ichaoha chuni cacha, caje coretichaachene jaanune coaalanaala,” naauruha aina nerelanacaaurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Inatajaain najian faan siriquiche,” naain acaauru caje bajaa Jesosone jana jetaote: “Caaunsinejeeinchate neeje faan,” naaure jetao aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nii jaun jetaote, atane choae nelauriaauruha cachaaurune coina aitiin jetao, jerane biji que nii caaunsini faan mucuhin Cana Coaunera bajaain, cataaun nii faancuru tatuhin aina nerelanacaauru rai tiha Jesosone jaun jetaote, jitariin nii cachaauru rai chaluure. ");
INSERT INTO uraNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nii jana niha coroatajajeein ate netonaine jaun jetaote, acaentonai mucuhin Cana Coaunera bajaain nii ate nemaajeein chaluherate Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nitohaneein nainaain lenonecuruhane baiha jetaote, caute que caaunsineein omari memoaaunre. ");
INSERT INTO uraNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Itolereneein jena oaraancai cachaauru jetaote, lenonecure. Nii baiha jetaote, acaauru rai necoeein, ");
INSERT INTO uraNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","aina nerelanacaauru aina bote cuhane fauhin jetao, Dalmanotau bataneu cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nitohaneein jetaote, Jesoso rene turuhin aina ereeuruhane baiha jetao, nechu jataain coujuha, Cana Coaunera letononeein unaa nihane coaaratiha acaauru quene coina cojoelanaacojoai ichaane coina rai aitocure fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nii jaun jetaote, jataain mijiaaineein nerai raain jetao: “Chanuna acaauru rai cojoelanaacojoai ichacaaunne coina aitocure caa cachaauru. Coatiha nii acaauru que chatohanai cojoelanaacojoai coaaratenaa nainihaaun,” naane jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ecu acaauru ratiriin jeelaiha bote cuhane fauhin nemuri jerau cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nitohaneein jelai caje bote cuhane fauhin amuuruhane jaun jetaote, rai nachano baiteein leinjiin faancha amaain cuure. ");
INSERT INTO uraNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nii jana jetaote, acaauru nainalaaca jetao: “Aonacuche. Faan jorerera lebadora rijiicha fariseeocuru aina Erodesi ichaone que caohachaain nainacuche,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Niritoha acaauru rai Jesosone jana jetaote, neniha acaauru rai faanne que nejesinajeein ita rai ereeuruha aina nerelanacaaurune aonajeein jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","“Chanuna faan sirineeichene que ereereequiche. Jataain nachura nainanachara nejeein coitucueneeichete. Jataainte asoneeojoaain nainanachara nejeeiche. ");
INSERT INTO uraNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Niha niqui inacojoeein inara nota, inara uricho, naaonjoaain. Nete nii cha coaraain, cha aonaain coitucunaa naineneeiche. ");
INSERT INTO uraNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Saoqui oaraancai cachaauru rai saoquii faan chaluhanune bana, inata omariin caute raaichelu,” naa Jesosone jana jetaote: “Lechoonca coroata omariin,” naauruha aina nerelanacaaurune jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Chajana jena oaraancai cachaauru rai caaunsini faan chaluhanune bana, inata omariin caute raaichelu,” naa Jesosone jana jetaote: “Caaunsi omariineein,” naauruha aina nerelanacaaurune jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Nii saijieein nachura jaiti nainaeneeichete,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nitohaneein cuhin Betesaaida turuuruhane jana jetaote, Jesoso rene leinjiin maosa amaain rautaane coina conujeeunre cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nii jaun jetaote, biji que nii maosa mucuuriin jelai cachaauru udaa amaain jetao, lune que jerane nii maosa nota rujuarujuariin nichoae biji teein: “Inae chaelai coaana naineei,” naa Jesosone jana ");
INSERT INTO uraNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","nenotaain jetaote: “Nuna tocohaneeinte murimurihonanae carai cachaauru,” naa nii maosane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","nacoaauneein jerane nota ichoae biji tiha Jesosone jana, nacoauneein nota jirichaane jana jetao, inae conoha notane jaun, caohachaain cha coarae nii maosa. ");
INSERT INTO uraNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nitohaneein rautaain jetaote, rai nenajaun letoaain jetao: “Coa taa neseu cauha,” nae rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nii baiha jetaote, Filipo batane que nenaa Sesareea nenacaauru neseeuru cue jetao, aina nerelanacaauru aina jiniiquiin Jesoso. Nitohaneein bero cuhane aina nerelanacaauru aina cuujeeurunajau jetaote: “Tonacuruha canu que cachaauru. Cha nichaaunje,” naa Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Tabaauru cachaaurute Joaan Baotisita niha ii beeure. Jana leeochaaurute, inoaenlu nenaa Cana Coaunera ere bera profeta inoaensi Eliasi niha ii beeure. Leeochaaurute, inoaenlu nenacaauru profetacuru tabaauru niha ii beeure,” naauruha raine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Cha nichaaun jana inara rai,” naa acaauru rai Jesosone jaun jetaote: “Iite nii canacaanuhacha cohajei Mesihasineein,” nae jetao rai Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nejetaote, chuni rai acaneein nihane beeuruhane caohate jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nii caje nunuheteein jetaote: “Canu Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne cairichaaeriinte caque jaolecohin niha cuurureein Jorioocuru bichauhenaauru aina saseredotecuru curuaanaacuru, chaen Cana Coaunera aitoonjoan que cacha relaaureraauru, naaonjoainuri. Acaaurute catinaa cuurureein, nena nichata janone cuhane ichanareeunni,” naain jetao, ");
INSERT INTO uraNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","esinae rauhijiriin cachaauru rai bee Jesoso. Niritiin esinae rauhijiriin suujuelanaala aitohane jaun jetaote jelai amaain niritiin irihane caohate Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nejetaote niritoha Fedorone jaun, jaotoroaain nii aina nerelanacaauru coaraain jetao cotaicha rijitiin: “Coa carerojoecaa moconajaera. Cacaje amuun. Coatiha Cana Coauneraacha coacui coitucuheei- ii. Joaaereein cachaauruhacha coacuhite coaauqui,” ");
INSERT INTO uraNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","naane baiha jetaote, nii aina nerelanacaauru aina ecu nenacaauru cachaauru cotijiaain jetao: “Aonacuche. Chunocoha canu cachaneein nenaa jerihane suujua letono ichana jerihane jianeein, coroso que canu teein canu cairichaaururichaaine rijijieein necairichanaa abaantaain caitoonjoa tonoraain, jerichaaunne rijijieein neeine. ");
INSERT INTO uraNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chunocoha canuhacha icharatei ichaelanaala neein nichao ichoteratena jerera, coatiha nichoterinaain. Nete laen canu coreniha, canuhacha beratei bihane coreniha, naaojoain coreniha nichao itajera, ichoteratenojoiniha cureein. ");
INSERT INTO uraNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Chaaquena rai nelatere, itolere caa chauratane que nenaacha que coacuhin rai nichao itajiha cachane. ");
INSERT INTO uraNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nitohanihane jaun inaaonjoaain coretihane niha natiin nii nichao ichoteratena nainihei cacha. ");
INSERT INTO uraNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nitohanihane jaun, chunocoha canu nichaaunne beein quiicha beratenojoin biha caa necha aansaineein osaaonacaauru cachaauru raine que nocoejihanena, canu- cacha calaohi nichaaunne inae que tihane bana canu Inaca necaohacha que necohachaain rai letonocuru anjeraauru aina nacoaauneein turuha uhanune banane canuhetonai que necoejereeunni,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Niritiin jetaote: “Esinaae rauhijiriin coatiha oorurinaain cau ena canu aina nenacaauru tabaauru, niicha ichaneni ichaain turuha Cana Coaunera Cojoanonaane coaracuruhane que tiaain,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Saota janone baiha jetaote, ichatane ucuuno cue Jesoso, Fedoro, Saantiaao, Joaan, naaonjoainuriicha amaain. Inae ecu turuuruhane jana jetaote, acaauru notaracaae nejelauneein ocooca Jesoso jaberocone jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","jataain caohatiin bichoronohin cajione amurijiriin somajaain jiquihaquiin nedae rai cajione. ");
INSERT INTO uraNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nii jana jetaote, ecu Jesoso aina ecocohin ereeuruha inoaenlu nenacaauru Cana Coaunera ere bera inoaensihuru, Irihasi, Moisesa, naaonjoainurine jana coarajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nii jaun jetaote, “Cacha relaera, jataainte caohate cau nihacachene. Coanete nichatajaain loanari jaacache, leinjiin ii rai, leinjiin Moisesa rai, leinjiin Irihasi rai, naaonjoaain,” nae jetao Jesoso rai Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jataain nesoonetooruha nii Jesoso aina cunacaauru, aina nerelanacaaurune jaun jetaote, nii tonaain irihane jaa coitucuenihane jaaun aite Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Niritohane jana acaauru conaacotaa dede sacarine jaun jetaote, nii dede sacari jana tonii: “Caate jataain quiicha belaai canuhacha letoai canu Calaohinera, nere tonoraain neeuchera,” naa erenaane jana jetao aonajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nii rijieeoritiin roaichu coaracuruhane jana jetaote, inae acaauru rohan neniha chunine jana jetao, ecu jelai acaauru aina niha Jesosone jana coaracure. ");
INSERT INTO uraNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nitohaneein jetaote, nii ichatane ucuuno caje jelaiha faaujueein, nii niicha coaracuri beeruha chuni rai nii aina nerelanacaaurune caohate Cana Coaunera Calaohi Jesoso, inae o caje ichanaane baiha beeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nii jaun jetaote, suujuaacha cuhane nii niicha coaracuri ruhecure, oo caje ichanarihanine que aitohane coitucuurenihane jaun ita caje bajaaebajajeein. ");
INSERT INTO uraNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nii jaun jetaote: “Chanuna jauriaanejeein Irihasi tururichaaine que aitocure- Moisesa aitoonjoan que cacha relaaureraauru,” naain Jesoso caje bajaauruhane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","“Esinae rauhijiriinte niqui, itolere rucueraanu que jauriaanejeein tururichaain Irihasine que aitocurelu. Chanuna jana Cana Coaunera Quiricha inoaensi cuhane cacha Calaohineein nenaa cairichanojoineein, jaoleneein niha curichaaine que aite. ");
INSERT INTO uraNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aonacuche. Inae turuha uhalu Irihasine janate, que niicha jerei ichaain cairichaaurelu, nitohanihane coina Cana Coaunera Quiricha cuhane aitiin laenanohinihane rijijieein,” naain jetao tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Inae jelaiha nii neeuruha aina nerelanacaauru leeochaaurune jaaun turuuruhane jana jetaote, ecu acaauru aina neeure arajiin cachaauru. Chaen Moisesa aitoonjoan que cacha relaaurera tabaauru netonai ecu neein jetao acaauru aina ereereecure. ");
INSERT INTO uraNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nii jana uujiha Jesosone coaariin jetaote, que tacaain satiin jeluhariin cuhin jetao, jataain cojoelatiin rai iriha cuure. ");
INSERT INTO uraNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nii jana jetaote, acaauru rai: “Tonaai acaauru aina ereereequiche,” naain acaauru caje bajaa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","“Cacha relaera, coaraaine coinane, cau ii rene canu calaohi uhaaun, moconajaera letono coitucuchuhi siriha suujua cuhanena jaun, erenaachara neein nihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nitohanihane jaunte, chunijihun cuhane jaaunru baasoneein mucuhane naineein atane choaae tocojoaain tacaain, nujuae caje lajaaqui mitaain, catu rihoneein, sefetaain te nii suujua cuhane nenaa coitucuchuhi. Nii jaunne niqui ii aina nerelanacaauru rai aitoon nii suujua cuhane nenaa coitucuchuhi sitaauruhane coina. Nete sitanaa nainesihurene,” naa nii acaauru jana nenaa leinjiine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","“Jataain cha esenetaaichuru cachaauru. Cha carajaneeinna inara aina nereeun. Cha carajaneeina inara abaantareeun. Chajaain cajiha nii enamanaa uhaauche,” naa acaauru rai Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jesoso rene nii enamanaa amaaure. Nii jana Jesoso coaariin jetaote, atane choae nii enamanaa siheite nii suujua cuhane nenaa moconajaera letono coitucuchuhi. Nii jana jetaote, najaabu jabubuhin nujuae caje lajaaqui mitujuae nii enamanaa. ");
INSERT INTO uraNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nii jana jetaote, nii enamanaa inaca rai jetao: “Chabana caje coaauneein caa catohane,” naa Jesosone jana jetaote: “Causine caje coaauneeinte aicha. ");
INSERT INTO uraNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nii jaunte araai saain usihanaauru comaaichuru, acaauhanaauru comaain ateinana jere nii suujua cuhane nenaa coitucuchuhi. Nitohanihane jaun, atiin cairichaaojoaain canacaanu coaraain, canacaanu coroatajaneeun, rautana naineeine,” naa nii enamanaa inacane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Tana rautana nainichaaunne esenetaainete cacaje bajaai. Satiin quesenetaera raine niicha bajai ichaain neeun,” naa Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","“Jataainnachujian chesenetaaun. Cacorataaneeune jataain jelai amuritoheriin chesenetaera,” nae jetao ehequiin nii enamanaa inaca. ");
INSERT INTO uraNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nii jana arajiin netaojiaauruha cachaaurune coaraane jaun jetaote, nii enamanaa suujua cuhane nenaa moconajaera letono coitucuchuhi rai jetao: “Erenaachara neein urichoelanaala caa enamanaa tera coitucuchuhi, canune ichei aitoon caa enamanaa jianeein caje mituhin amuhine coina. Jiaonriha nacoaauneein caa enamanaa suujua cuhane enohine,” naain suruaa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","nacoaauneein baasoneein nii enamanaa jaberoco teein cojioriae nii suujua cuhane nenaa coitucuchuhi. Nitohaneein tihane baiha onaa rijijieein teein, caje mituhin amuhane jaun jetaote, “Inae baasoneein jaberoco tihane caaunte jerihane inae ohe,” naaure nii ecu arajiin neein coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nejetaote, biji que mucuhin michuha Jesosone jana jetao, nimichuhin nichaaurae nii enamanaa. ");
INSERT INTO uraNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nitohanihane baiha aina nerelanacaauru aina jiniiquiin leinjiin loreri asaae enoha Jesosone jaun jetaote, jelai ecu teteriin: “Chanuna canacaanu nii coitucuchuhi sitanaa nainesinihacaanu,” naain caje bajaauruhane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","“Catohanai moconajaera letonote nainichaa Cana Coaunera bajaacane ainaacha sitaacane,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nitohaneein nii canaanai rautaane jaan jelai caje amuhin jetaote, Calileea turuhin rauhijiriin situujueein cuujeeure. Nejetaote, nii acanihane coitucuha chunine jerene Jesoso, ");
INSERT INTO uraNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aina nerelanacaauru relanaa nainihane coina. Nii acaauru relaane jaaun jetaote: “Cacha Calaohineein nenaate cachaauru bijiu tenojoinihane jana ateinaa cuurureein. Nete nichata janohane baiha ichanareein,” naain aina nerelanacaauru relaane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","nii acaauru rai aitohane inaaureniha natiin jetao caje bajaaurene necoatocuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nitohaneein cuhin, inae Caferenaaon turuhin loreri asaae enooruhane jana jetaote, aina nerelanacaauru rai jetao: “Chaaque ita rai ereerejeein uhicheein bero cuhane,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nejetaote inauheneecha curuaaequiin aonajeeure, bero cuhane uujueein, “Charijina caa cana jana jataain nelateein nenaane,” naauruha ita raine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nitohaneein inauheneecha aonajeeuruhane jaun jetaote, nelauriariin nii aina nerelanacaauru lechoonca coroatajai cotijiaain jetao: “Leeochaauru amurijiriin nenaa jeriha chunine, acaauru rai nelateein itolereneein acaauruhacha jerei icharaneein neeine,” ");
INSERT INTO uraNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","naane baiha jetaote, biji que leinjiin canaanai mucuuriin acaauru cataaun teein jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Canu coreniha caa canaanai raerate, jerichanejeein canu raane rijijieein aicheein. Nii jaun canu raera coatiha canuhacha raa airinaain, caletoaera Ofa netonai raate aicheein,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nii jana jetaote: “Cacha relaera, ii curuaa aina cuaain moconajaera letono coitucuchuhi sitaain que suujuequiin nenacaauru rautaa leinjiinne janane eruhin caohatihacaanu, cana jana nenaaneein ainihane jaun,” naa Joaanne jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Jiaonriha caohateein neeichene. Chunocoha canu curuaaneein netiin cojoelanaacojoai ichaera, nii baiha baasoneein erenaa nainihei canu que. ");
INSERT INTO uraNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Canaacha ichai ichara, coatiha cana que nejeratenaa nainihei. ");
INSERT INTO uraNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chunocoha canu Curisito cachanequichene coreniha inara rai esinaeca niha natiin terate, esinae rauhijiriin rai cainanohiniha cureein,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Niritiin jetaote: “Chunocoha ena canu esenetajeeureraauru saruha osa quenete, nii ajiniha caohachare nuluno que leinjiin ajeri jaberoco tijichaain ichojoaain cucuana cuhane joaeraane. ");
INSERT INTO uraNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jana osa que ii saruha ichohiine moloo. Nii amuritoheriintejian caohachare le jerajei ichohii aina Cana Coaunera cojoanonaa que neeine. ");
INSERT INTO uraNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nabana le jerajei ichoii coreniha, nii chariji bana nii riano niha natiin ohin, nii usi tabai jacanaachara jana cuhine coataa. ");
INSERT INTO uraNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jerichanejeein osa que ii saruha ii tijiane moloo. Nii amuritoheriintejian caohachare le jerajei ii tijia aina Cana Coaunera cojoanonaa que neeine. ");
INSERT INTO uraNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nabana osa que ii saruha ii tijiane coreniha nii riano niha natiin ohin, nii usi tabai jacanaachara jana cuhine coataa. ");
INSERT INTO uraNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jerichanejeein osa que isharuha inotane, le jerajei inota rocoo. Nenacaaeneetejian nii amuritoheriin caohachare le jerajei inota aina Cana Coaunera Cojoanonaa que neeine. Nabana usi que isharuha inotane, ");
INSERT INTO uraNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nii riano niha natiin ohin, nii usi jacanaachara, naaonjoain jana cuhine coataa. ");
INSERT INTO uraNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Usi jana situnaa rijijieeinte nichoterichaacheein satiin. ");
INSERT INTO uraNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nelatiha niqui tebe. Nete inae lenone cotebetenaa nainenihane, inae nii chaque nelatene. Nii rijijieeinte chaque nelateneeiche inara que icharatenohi ichaain, raotojoeein ichaaoruha leeochaaurune jaan ichaeneeichene,” nae jetao acaauru rai Jesoso ");
INSERT INTO uraNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Inae Caferenaaon caje amuhin jetaote, aina nerelanacaauru aina jiniiquiin nucuhe Jorodaan auhaniha cuhin, enoto mitu nichajai jeloon nenaa Jodea batane que cue Jesoso. Ecu jetaote, rai netaojiaauruha cachaaurune jana jetao, nacoaauneein relanajae Jesoso, cachaauru relanaa rautatohane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nii jana jetaote, rohan nichuuntaain jetao, nechu jataain cairichaauruhane jaanu lera ariha jetao, comasai jianena nainiha cachane bajaaure jetao Jesoso caje fariseeocuru tabaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nii jaun jetaote: “Tonaa inara rai Moisesa, comasai jianiha cachane que,” naain acaauru caje bajaa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“ ‘Comasai jianiha cachane coina, jauriaanejeein comasai jianihane jaaque aitiin nenaa quiricha teeuchete, aina comasai jianemiin cacha,’ naainte aite Moisesa,” naauruha fariseeocurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Aiha niqui. Nete, nere tonorana jerelanaala neeichelune jaun, nitohaneein ichaquichene rautaenihane saijieein ichaquichene coina aitelu Moisesa. ");
INSERT INTO uraNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nete jauriaanejeein itolere coaaunaane nunuheneein, quicha, ene, naaonjoaain coaaunaelu Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nii jaaunte, inaca, neba, naaonjoain ratiriin amuhin necoaansaijiae cacha. ");
INSERT INTO uraNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chaen leinjiin cachaneein nenaa rijijieein coacuhin, jiniiquiin ita aina neeure. ");
INSERT INTO uraNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nitohaneein niha cachane coina ichaa Cana Coaunerane jaun, nii comasai jianena nainihei cacha,” nae jetao fariseeocuru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Inae loreri asaae enooruhane jana jetaote, nii cachaauru relaane jaan bajaaure nacoaauneein caje aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nii jaun jetaote, acaauru rai: “Comasai jianeein leeocha ene raerate, osa que nesaruha aicheein. ");
INSERT INTO uraNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jerichanejeein techu, osa que nesarureein lana jianeein leeocha cacha que nelanajaane ene,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nii jana jetaote, acaauru mucuhin rausiaaeca cojiotanaaca Jesosone coina jetao, rai canaanainuru amaaure acaauru fojiaraauru. Nejetaote, nii canaanainuru amaauruha nii amaaurerane caohateeure nii Jesoso aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nii rene amanajaauruhane caohateeuruhane coarajeein jetaote, obajeein jetao: “Coa carene turuuruha canaanainurune caohatihachete, canu rene turuuruhine. Aihuruha caa canaanainurune rijijieein nenacaauru raineeinte ne Cana Coaunera Cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Esinae rauhijiriin aiha leinjiin canaanaine rijijieein neniha cachane coatiha Cana Coaunera Cojoanonaa que nenaa nainerinaain,” ");
INSERT INTO uraNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","naane baiha jetao, jerane biji cuhane nii canaanaihuru raane baiha jetao acaauru mucuhin, acaauru rausiaaeca cojiotanajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nitohaneein inae jelai caje amunaa jeriha Jesosone jana jetaote, rene jeluhariin cuhin turuhin jetao, nacatiha neseeoriaain: “Caohachanejei cacha relaera. Cha ichareeun charijibana nitajenaachara ichaonaa raotono que nenaa nainichaaune coina,” naain Jesoso caje bajaa leinjiin cachane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Chanuna caohachanejei cacha neein canu curuaateei, leinjiin Cana Coauneraachate caohachanejeineein ne. ");
INSERT INTO uraNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Inae raotojoeein Cana Coaunera aitoonjoan coitucuhi: ‘Jiaonriha sonajaain jaohine. Coa ii sinijerane lanaala nenaa ene aina ichaohin niha. Coa asijiauha. Coa chamute cacha cairichanaa jerenacaaun chuni cacha coacuhin casaje que ereein niha. Chae efojiaraauru ere tonoraain caohachaain acaauru aina neeun,’ naane coitucuhi,” naa rai Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Aihanu chujian. Canu enamanaca caje coauneeinne jitariin nii naitoonjoan tonoraain ichaaon,” naa nii cachane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","jataain cairichaaojoaain coaraain jetao: “Esinae rauhijiriin, chaque lanaelanaala Cana Coaunera aitoonjoa tonorana jereeine, chajaain jitariin nii iicha sirii que necoreteein cairichaaihuru rai tenihun. Nii banaachate, jelai amuritoeriin nereein iicha latei dedeeu. Nii baiha laen canu aina uu,” naa rai Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","jataain nererojoecaain jelai caje amue inaderaain nii enamanaa, jataain coriquihocane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nii jaun jetaote, nii rohan curuacaain nenacaauru cachaauru coaraain, aina nerelanacaauru rai jetao: “Jataainte caaintate Cana Coaunera Cojoanonaa que nenaa jeriha coriquihonane,” naa acaauru rai Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","jataain cojoelatiin ecu aonajeeure aina nerelanacaauru. Nejetaote nacoaauneein acaauru rai jetao: “Cacoelaichaauru, jataainte caaintate Cana Coaunera Cojoanonaa que nenaa jerichaane. ");
INSERT INTO uraNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Leinjiin oco jachu cuhane situnaa naineniha leinjiin camechone amurijiriinte, jataain caaintate Cana Coaunera Cojoanonaa que nenaa jeriha coriquihonane,” naa aina nerelanacaauru rai Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","jataain jeelai amuritoheriin naurutaain cojoelatiin jetao, ecu nejesinajeein ita rai jetao: “Nitohanihane nichotenaa naineriaain chuni,” naauruha nii aitohane aonajeeinne jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ecu coaranaacane baiha jetao: “Caaintatiin cachaauruhacha coaraite, Cana Coaunera rai caaintajene,” naa Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","“Canacaanune jitariin canacaanuhacha sirii ratiriin ii sacuhacaanulu,” naa rai Fedorone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Chunocoha esinae rauhijiriin canu coreniha, chaen, cacha ichoteratera caitoonjoan- canu ere beebejeein, naaonjoaanne coina, rai loreri, rai nejeraauru, rai fojiaraauru, rai calaohichuru, rai natane, naaonjoain ratirichate, ");
INSERT INTO uraNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","caa chauratane que neein jataain jeelai amuritoheriin lefasha saneein rai loreri, rai nejeraauru, rai fojiaraauru, rai calaohichuru, rai natane, naaonjoainuri siricheein. Cairichaerinojoineein neeuruhane niha natiinte, turuha uheni Cana Coaunera Cojoanonaa charijibana nitajenaachara ichaonaa que niha cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ena jataain arajii itolere que nelaetoha nocoetonacaaurute, nii chaque nelatelanaala niha cuurureein. Jana ena chaque nelatelanaala arajiin nenacaaurute, nelateein niha cuurureein,” naain jetao Fedoro tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerosaleen nichaae cuuruhane jaun jetaote, aina nerelanacaauru ichoaaichaniha cuujiha Jesosone jana jetao, cojoelatiin cuujeeuruhane jana jetao, nii niritohane que casiin jetao, cuujeeure acaauru caaijie cunacaauru. Nii jaun jetaote, jelai nii aina nerelanacaauru lechoonca coroatajai cotijiaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Inae caa ena coitucuhichene rijijieeinte, Jerosaleen cuujihacache. Inae ecu turunaate, canu inaraacha cohajei cachaneein nejanoanaa nichaaune mucuhin saseredotecuru curuaanaacuru rai, Moisesa aitoonjoan que cacha relaaureraauru rai, naaonjoainuri rai caetecuruhane jana, catinanacanejeein nejelau cachaauru Jorionelanaala nenacaauru bijihu caetecurureein. ");
INSERT INTO uraNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nii janate, caque necoatijiaain canu couluneein, canu bisiin catinaa cuurureein. Nena nichata janohane baiha, nacoaauneein ichanareeunni,” nae jetao nitohaneein teeururichaainne que Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Niritohane jana jetaote, rohan nichuuntaain jetao: “Cacha relaera, caa ena ichei canacaanuhacha bajaaeni ichaainene jerichaanu,” naauruha Sebedeeo calaohichuru, Joaan, Saantiaao, naaonjoainurine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Chatohanai inara rai ichacaaunne jerequiche,” naa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Canacaanu rai, inae ii Cojoanonaa necaohacha que neeine bana, ii ajaabiji nichajai que, ii raotono nichajai que, naaonjoaain nihacaanune jaanu ichaainene jerichaanu,” naauruhane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","“Coatiha nohane inaraacha bajai coitucuhin aitoheeiche. Caa necairichanaa abaantarichaaunnine rijijieeinoote, necairichanaa abaantanaa nainequiche inara. Chaen noote, nitohanihanune coina cojunacatenohi nichaaunne rijijieein cojunacatenohineein neeiche,” naa acaauru rai Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Abaantanaa nainichaanu,” naauruhane jana jetao: “Inarate niqui, caa necairicharichaaunnine rijijieein necairichanaa abaantaain cojunacatenohineein niha curiquicheein, cojunacatenohineein nihanune rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nena laen, canu raotono nichajai que, canu ajaabiji nichajai que, naaonjoaain nelauriaaichene coina inaraacha bajai tenaa naineneeun, nii coina inae acaauru que banihateein rucuhenojoineein nenacaauru raineein nihane jaun,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Niritoha acaauru rai Jesosone aonajeein jetaote, Saantiaao, Joaan, naaonjoainuri aina obaaecure nii lechooncaihuri aina nerelanacaauru. Nejetaote, acaauru cotijiaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","“Inarate raotojoeein, Cana Coaunera coitucuhichuru, leeochaauru amurijiriin nenaa jereein acaauru cocoainanacai neeuruhane que suujua acateein neeuruha leeochaaurune jereein neeuruhane coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nete laen nejesinajeein nitohaneein nenaa naineneeiche inara. Nitohaneein nenaa coacuelanaala, nejesinajeein ita coroatajaneein neeuche. ");
INSERT INTO uraNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jana leeochaauru amurijiriin nenaa jerera, leeochaauru letononeein neeine. ");
INSERT INTO uraNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Coaracuche nachuhinti canu Cana Coaunera Calaohi cacha caje nejanoanaa nichaaunne canu coroatajaneeichene coina tururichaaun. Arajii cachaauru osa caje nichoteein jianacoon neeuruhane coinane, nii coreniha cajabereeo cairichaeratiha uunlu acaauru coroatajaniha,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Inae Jericoo turuhin jetaote, ecu basiinjiin neeoriin jelai caje amuha aina nerelanacaauru aina Jesosone jana jetao, acaauru aina cuure arajiin cachaauru. Nii jana bero auhaniha lauhequiin coriqui bajaa leinjiin Timeeo calaohi cairichei maosa Bartimeeone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nasarete cocoaicha Jesoso nihane aohanriin jetao: “Rabiriicha foeratei Jesoso, cairichaaojoaain atiin cacoharaau,” naain eheeoca nii maosane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","arajiin cachaauru, ehequiin aitohane caohateeure inauheneecha nihane coina. Nejetaote, que rutaain ehequiin: “Rabiriicha foeratei, atiin cairichaaojoaain cacoharaau,” naa nii maosane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ecu inacuhin jetao: “Chajaain cajiha cotihanihuche,” naa Jesosone jaun jetao: “Chajaauje nimichuhinte, toon ii cotihara coarae,” naauruha nii maosa raine jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","cajione buri rocohitiin siheeitiin ratiriin jetao, Jesoso rene jeluhariin turuha cue nii maosa. ");
INSERT INTO uraNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nii jana jetaote: “Chatohaneein chetichaaunne jereeita,” naa Jesosone jaun jetao: “Conoha canotanena jereeunra cacha relaera,” naa nii maosane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Inae jataain quesenetaaine jaun inae conoha inota. Inae naineein amuhinera,” naa rai Jesosone rijieeoritiin jetaote, inae conoha nii maosa notane jaun jetao Jesoso jiniichaain bero cuhane cue nii maosa. ");
INSERT INTO uraNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nitohaneein cuhin, inae Jerosaleen catainaauruhane jaun jetaote, Betafajee, Betania, naaonjoainuri rohan Olibo bichatane turuuruhane jaun jetao, caje coaauneein coroatajai aina nerelanacaauru letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Chajaain taa nita canaacha coarajei neseu cunichuche. Inae ecu turuhichenete, ecu cositenojoineein teecoha jaiti chuni cacha amunajanelanaala nenaa asno narejeene jana eruha curiquicheein. Cosi rutuhin uhaaichene jana: ");
INSERT INTO uraNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","‘Chanuna cosi rutuhin amaaiche,’ naa chunocoha inara raine: ‘Latiha Cana Curuaanaane jaaunne raa uhacaanu. Inae enate ichei jelaiha cainaratereein,’ naauche,” naain jetao letoanajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nii jaun jetaote cuhin, nii acaauru rai aitohane rijijieein bero auhaniha teecoha cositenojoineein acuujua rohan asno narejeene jana, eruhin jetao cosi rutuhin amaauruhane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","“Cha ichaquiche inooneein. Chanuna nii asno narejeen cosi rutuhin amaaiche,” naain jetao, acaauru caje bajaaure nii cuu nenacaauru cachaauru tabaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nii jaun jetaote, nii acaauru suujuateein letoanajaa Jesosone rijitojoeein nii cachaauru tonoraauruhane jaun jetao, inauheneecha nii asno narejeen amaauruhane coarajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nitohaneein jetaote, nii asno narejeen ichoae cajione teein jetao, Jesoso rai nii asno amaauruhane jana jetao, inae rene turuhaauruhane jana nichoae nelauriaain cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nitohaneein asno ichoae nelauriaain cuhane jana jetaote, najiniha bero cuhane rai cajione buri maririjiacoaauruhane jana jetao, leeochaauru elele alo rijijieein nenaa ajaena alo raain najiniha bero cuhane maririchure. ");
INSERT INTO uraNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nii jana najiniha cunacaauru, caaijie cunacaauru, naaonjoainuri jetaote: “Raotojoeein turuhine Cana Coaunera rijijieein nenaa cana Curuaanaa. ");
INSERT INTO uraNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Raotojoeein turuhine Cana Coaunera Cojoanonaa, cana inoaensihuru foerateraneein nenaa Rabiri nefoerate cojoanonaa. Aihute coreniha raotojoeein neeurumiin dedeeu nenacaaurune maajeein,” naaure jetao cojioriin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nitohaneein Jerosaleen turuhin jetaote, Teenforo asaae enohin, ecu basiijiin neeoriin jitariin nasajai coaraane baiha jetao Betaniau cue lechoonca coroatajai aina nerelanacaauru aina Jesoso, inae sohane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","13","Nii cojoanoo Betania caje amuuruhane jana jetaote, niita bero auhaniha niha uhera alone jana coaraain jetao, coaraa cue Jesoso mijiintohane jaun. Nejetaote, inaacane bana rijiu nenihane jaun, ninaa colane nalohacha baaejeein ne. ");
INSERT INTO uraNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nitohaneein inacaenihane jaun jetaote: “Inae nacoaauneein inacaeneriquiinne jaun, neriaain chuni ii inaa lerata,” naain uhera cojiotaa Jesosone jana jetao, ecu aina neein aonajeeure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Inae nacoaauneein Jerosaleen turuhin jetaote Teenforo asaae enohin, nii Teenforo asaae chaelai que necoreteein, chaelai coretiha, naaonjoaain nenacaauru sitaain, atanichoae coriqui coreeuruha cachaauru raine jaa rorihurune maajeein lacojoaain jetao, serori que necoretenacaauru rorihurune maajeein lacojoaain, ");
INSERT INTO uraNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","nii Teenforo asaae nenacaaen rucuhele enoaauruhane caohate Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nitohaneein jetaote: “Cana Coaunera Quiricha inoaensi cuhanete: ‘Cana Coaunera bajaauruha satiin chauratane sacuritaain que nenacaauru cachaaurune jaan coloherineeite ne canu loreri,’ naain laenanohineein ne. Nete asijiaauruhane jaan coloheri rijijieein teeiche inara,” naain jetao ecu acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Niritiin cachaauru relaane aonajeein jetaote, Jesoso sohin jaonaa coaaucuruhane jaun, sohin jaaoruhane jaanu lera arihure saseredotecuru curuaanaacuru, Moisesa aitoonjoanque cacha relaaureraauru, naaonjoainuri. Ne jetaote, sohin jaaoruhane coasichure, nii acaauru relaa Jesosone jaan rautatiin aonajeeuruha satiin cachaaurune jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Inae nocohecane jana jetaote, aina nerelanacaauru aina jiniiquiin nii nese caje amue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nii cojoanoo janone nii uhera rohan situha cuuruhane jana jetaote, inae cojoaisi aina curuaaequiin oha nii uherane jana coaracure. ");
INSERT INTO uraNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nii jaun jetaote, cojiotaa Jesosone coacuhin que nainaain jetao: “Cacha relaera, inae raca cojiotaaine jaunte, inae ohe taa uhera. Coaraau nachuhinti,” naa Fedorone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","“Jataain Cana Coaunera esenetaauche. ");
INSERT INTO uraNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chunocoha esinae rauhijiriin airichaainne esenetaain nii batoelanaala: ‘Niilai caje nefaruhin cucuana cuhane cunihun,’ naa caa ichatane ucuuno rainete, esinae nii aitohane rijijieein aihane ne. ");
INSERT INTO uraNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nitohanihane jaaunne inara rai aitoon, inaraacha latei eruhichene coina Cana Coaunera bajaaiche, inara rai terichaaine esenetaainete eruriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Inara rai chatohanai cotainacai ichaain neeuruha inara amute cachaaurune niha natiin, acaauru que inara suujua acateein Cana Coaunera bajaaichene bajaauche. ");
INSERT INTO uraNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aihute baaso ichaain osa que nesaruquichene niha natiin inara osa que suujua acatemiin cana Inaca dedeeu nenaa Cana Coaunera,” nae jetao Fedoro rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nii baiha jetaote, nacoaauneein Jerosaleen cauha cue aina nerelanacaauru aina Jesoso. Inae ecu turuhin Teenforo asaae enohin amuhemuheca Jesosone jana jetaote, rohan nichuuntaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Cha ii cocoainae catohanai ichaain neeine coina. Chatohanai cocoainanacai neeinna neei,” naaure jetao Jesoso rai saseredotecuru curuaanaacuru, Moisesa aitoonjoan que cacha relaaureraauru, Jorioocuru bichauhenaauru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Nii jaun jetaote, acaauru rai: “Canuhetonaine inara caje bajareeunni. Cha Joaan letoaelu, cachaauru cojunacatiha uhane coina. Cana Coaunera letoaenihanena cachaauruhacha letoanojoineein uhalu. Catoonraain carai beeichenena, canuhetonai canu cocoainaain canu letoaera bereeunni inara rai,” naain jetao acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nii jaun jetaote, ecu nejesinajeein ita rai jetao: “ ‘Cana Coaunera letoanojoineeinte uhelu,’ naacachenete: ‘Chanuna jana nere tonoraain esenetaeneeichelu,’ nareein. ");
INSERT INTO uraNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Coatihachu: ‘Cachaauru letoanojoineeinte uhelu,’ nanaa nainihaacache,” naaure jetao ita rai. Satiin cachaauru Cana Coaunera letoanojoineein uhalu Joaane esenetaauruhalune jaun, cachaauru coasiha. ");
INSERT INTO uraNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Niritiin jetaote: “Chachaainti Joaan letoaain nelu. Coatiha coitucuhaacaanu,” naauruha Jesoso raine jaun jetaote: “Aihane jaaunchujian canuhetonai, caa catohanai ichacaaunne coina canu cocoainaain canu letoaera berinaaunni inara rai,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Niritohane baiha jetaote, ocoana jaaurera que cuaain cachaauru relaain jetao: “Leinjiin cacha jetaote, ocoana jaain jitariin corihateein bino jaauruhane jaanu coloherinu que loreri jaain, leinjiin jataain ucuuneein teein rori jae ecu neein amihanenacaauru beraihane coina. Nitohaneein caohachaain rucuhecane baiha jetaote, nii ocoana que amihanenacaauru rai atane teein ratiriin amuhe nii atane erora. Inae tainaca que turuhane bana ita rai leruuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nitohaneein teein ratiriin jetaote, inae tainaca que tihane jaun, leinjiin rai cacha letoae, nii amihanenacaauru caje que banihateein niicha taihuri bajaa cuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nejetaote, nii cacha mucuhin faojoaain sooruhane baiha, nii cacha letoaaure cha colane nii temule erora rene. ");
INSERT INTO uraNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nii jaun jetaote, nacoaauneein leeocha cacha letoaa nii temule erorane jana, nocoejechanuhin, couturi cunaitaain cha colane acaentonai letoaaure jelaiha. ");
INSERT INTO uraNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nii jana nacoaauneein leeocha cacha letoaane jana jetaote, acaentonai sohin jaaore nii temule beraichacuru. Nii baiha nacoaauneein arajiin rai cachaauru letoajeein sacuha nii temule erorane jana jetaote, tabaauru sohin jaonajaain, tabaauru faojoaain cunaitanajaaure. ");
INSERT INTO uraNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Satononejeein jetaote leinjiin jataain niicha belaai rai calaohi neeorihane jana, aca letoae: ‘Jerihane canu calaohi quete laen suujua acatecurureein,’ naain coaaucane jaun, sohin jaaoruhane esenetaelanaala. ");
INSERT INTO uraNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nejetaote, ita rai jetao: ‘Inae uha caa atane erora calaohi. Coanete sohin jaohacachete, cana raineein nedaaine caa atane,’ naaure jetao nii ocoana que amihanenacaauru cachaauru, uha nii atane erora calaohine jana coarajeein. ");
INSERT INTO uraNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Niritocuruhane jaun jetaote, inae acaauru rene turuhane jana mucuhin ateinaain nii ocoana udaa amaain jaberoco jaaore,” naain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Tonaquiche jana inara, nii calaohi sohin jaaoruhane que, tohanrihacha jana nii ocoana erora. Raajenihane cuhinacha nii ocoana que amihanenacaauru sohin jaohin, leeochaauru cachaauru bijiu nii ocoana teriha beraihuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tana Cana Coaunera Quiricha inoaensi cuhane: ‘Ajeri jaolecooruha loreri icharaaurune jaante, jauriaanejeein loreri nunuheneein ne. ");
INSERT INTO uraNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Acate jataain cana rai cojoelanaacojoaain ichae Cana Coaunera,’ naain laenanohinihane jaan reretaain aonaquiche chariji banane,” naain jetao ocoana icharaauru que cuaain cachaauru rai ereerejeein acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Niritiin acaauru que cuaain relanajaa Jesosone que nainacuruhane jaun jetaote, Jesoso mucunaa jerecure Moisesa aitoonjoan que cacha relaaureraauru, saseredotecuru curuaanaacuru, naaonjoainuri. Nejetaote, Jesoso aina neeuruha arajiin cachaaurune jaun cachaauru coasiha ecu ratiriin jelai caje amuure. ");
INSERT INTO uraNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nitohaneein ecu ratiriin jelai caje amuuruhane baiha jetaote, Erodesi ere tonoraeraauru, fariseeocuru, naaonjoainuri letoaaure, rai ereeuruhane jana tonaain acaauru tonoraa Jesosone nechu jataain coulurujueeuruhane jaanu lera ariha cuuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Acaauru jetaote rene turuhin jetao: “Ii que tonaain iriha cachane niha natiin, tonoraelanaala esinae rauhijiriin ereein neeine coitucuhacaanu. Chaen techu nohanelanaala esinae rauhijiriin jeriha Cana Coaunerane rijijieein ichaoha cachane coina cacha relaai. Aihane jaun, caohachaana Romanocuru curuaanaa rai impoestonu que coriqui tihacaanune. Ainihane chatohaneriha. Coretena nainichaanuna. Ainihanena niriiriha,” naaure jetao Jesoso rai fariseeocuru aina Erodesi ere tonoraeraauru. ");
INSERT INTO uraNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nejetaote, nechu jataain cairichaa aitocuruhane que nainaane jaun jetao: “Chanuna cacairichanaa coacuhin niritiin carai ereeiche. Carai cajiha nii coriqui uhaauchene coarae,” naa acaauru rai Jesosone jaun, ");
INSERT INTO uraNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","rai coriqui teeuruhane jana jetaote: “Chaa curuaa caa laenanohineein ne rai cojunaca aina,” naa acaauru rai Jesosone jaun jetao: “Romanocuru curuaanaa enferadoro curuaa,” naaure jetao rai. ");
INSERT INTO uraNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nii jaun jetaote acaauru rai: “Aihana jaun chujian enferadoro que banijiaain nenaa teeuche enferadoro rai. Chaen Cana Coaunera que banijiaain nenaa teeuche Cana Coaunera rai,” naain acaauru tonoraa Jesosone jaun jetaote, ecu jataain cojoelatiin aonajeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nii jana jetaote, Jesoso coaraa uure sadoseeocuru, oo caje ichanaa cacha suujuene esenetaaurenihane jaun caje bajaauruhane coina. Acaauru jetaote rene turuhin jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Cacha relaera, Moisesate canacaanu rai laenaain ratirilu, oha leinjiin cacha nesirihateein nii comasai aina canaanai sirilanaalane, nii onaa comasai autana raa nii onaa nejerane, nii onaa aina siricha rijijieein canaanai sirihane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nitohanihane janate, ita nejera nejesinaneein neeuruha caaunsineein cachaaurune jana, jauriaanejeein acaauru nejera nesirihateein, nii nesirihatenajan aina calaojoilanaala ohe. ");
INSERT INTO uraNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nii jaunte, nii autana rae nii onaa nejera. Nete acaentonai ohe aina calaojoilanaala. Jerichanejeein techu ohe nii acaauru nichataja. ");
INSERT INTO uraNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nii jaaunte, nii chunocohacuru nii caaunsini ita nejeraauru calaojoilanaala oore. Nii janate tabiicha nii ene netonai ohe. ");
INSERT INTO uraNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aihane jaun ooruhane baiha nacoaauneein ichanaa acaauru suujuene bana, chariji comasaineein jana nereein nii ene, caaunsini ita nejeraauru aina nesirihateein nihalune jaun,” naain jetao Jesoso caje bajaaure sadoseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nii jaun jetaote: “Nechu jataain joaaenreeinte ereereequiche inara, Cana Coaunera Quiricha ereretaain aonaain niicha ichanenu coitucueneeichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ohane baiha jerichanejeein jaberoconeein nenaa rijijieein ichanaain niha quichaauru, enecuru, naaonjoainuri suujuene, inae nesirihatenaa nainecuruhi, dedeeu nenaa anjeraauru rijijieein inae neeuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tana ohane baiha jerichanejeein jaberoconeein nenaa rijijieein ichanaa cacha suujuene que aitoha nuna laaojoiri moconaau neein Moisesane jaa quiricha reretaain aonaquiche inarane. Ecu jetaote Moisesa rai: ‘Canune Abaraaun, Isaca, Jacobo, naaonjoainuri Coaunera neeun,’ nae jetao Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Coatiha ohin nitajenacaauru coaunera nihei Cana Coaunera- ohin nii baiha jerichanejeein jaberoconeein nenaa rijijieein nenacaauru cachaauru coaunera Cana Coaunera. Nitohanihane jaunte, jataain joaaereein nii cha coitucuelanaala ereereequiche inara,” naain jetao sadoseeocuru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Niritiin esinae rauhijiriin sadoseeocuru tonoraa Jesosone jana aonajihane jaun jetaote, Jesoso rohan nichuuntaain jetao: “Chariji jataain jauriaanejeein Cana Coaunera aitoonjoaneein cacha ichao rai nelateineein ne,” nae jetao, rai Moisesa aitoonjoan que cacha relaera. ");
INSERT INTO uraNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nii jaun jetaote: “Jauriaanejeein cana ichao rai nelateein nenaa Cana Coaunera aitoonjoante: ‘Aonacuche Isaraeli cocoaichacuru. Cana curuaanaa Cana Coaunerate, leinjiin acaacha itolere curuaanaa neein ne. ");
INSERT INTO uraNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Aihane jaun, ii suujua, ii suujue, ii coichana, naaonjoainuri aina curataain cana curuaanaa Cana Coaunera belaihu. ");
INSERT INTO uraNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chaen ichaajenihane ijiabereeo belaain coaraaine rijijieein chamute cacha belaain coaraau,’ nae. Nihei caa baiha jataain cacha ichao rai nelateein nei Cana Coaunera aitoonjoan,” nae jetao Moisesa aitoonjoan que cacha relaera rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nii jaun jetaote: “Esinae rauhijiriinte chuhisi aitohicha cacha relaera. Leinjiinte chuhisi ne Cana Coaunera. Nihei nii baiha acaneein nei. ");
INSERT INTO uraNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cana suujua, cana suujue, cana coichana, naaonjoain aina curitaain Cana Coaunera belaain, cana jaberoco belaichaane rijijieein cana amute cacha belaain, naaonjoaancanete chuhisi, itolere inihocuru, itolere jujuaihuru, naaonjoainuri mocohaca rori ichoae teeinne amurijiriin jataain nelateine,” nae jetao Jesoso rai Moisesa aitoonjoan que cacha relaera. ");
INSERT INTO uraNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Niritiin esinae rauhijiriin tonoraa nii Moisesa aitoonjoan que cacha relaerane coitucuhane jaun jetaote: “Coatiha icharaain niheei Cana Coaunera Cojoanonaa que neeine coina,” naa Jesosone jaun jetaote, inae nii tonaai caje chatohanai bajanaa coitucuene. ");
INSERT INTO uraNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nii baiha Teenforo asaae neein cachaauru relaane jaun jetaote: “Chanuna Rabiri caje nefoeratenaa niha Mesihasine que aitocure Moisesa aitoonjoan que cacha relaaureraauru. ");
INSERT INTO uraNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cana Coaunera Suujue aitoroatenojoineein: ‘ “Cau carautono nichajai que nelauriaau carohan, ichei nejeratenacaauru amuritoherateein, itiha asaae tenajaanune reen tiaajeein,” naa Cana Coaunera cana curuaanaa rai,’ naa Rabiri inatiin. ");
INSERT INTO uraNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Aihane jaun, inasiina Rabiri nefoerate caje nenaanere Mesihasi, Cana Curuaanaa neein curuaatiha Rabiri netonai inatiin,” naa cachaauru rai Jesoso jana jetaote, rautatiin Jesoso aonajeeure nii ecu arajiin nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nitohaneein cachaauru relaane aina cuaain jetaote: “Caohachaain nocohalajiin ichaaoche, Moisesa aitoonjoan que cacha relaaureraauru que. Cacha relaauruhane jaa cocajione jiaainte, bero cuhaneeuru acaauru que suujua acatecuruhane coaarateein neeuruha cachaaurune jereeinchuru amuure. ");
INSERT INTO uraNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chaente netaojiaain Cana Coaunera rai rauhi que ereereecuruhane jaan coloheri sinacoca asaae enooruhane jataain nelateein nenaa rijijieein rori caohacha ichoae nelauriana rautatiin, beseta ichaain lenonecuruhane jaaun niha natiin rori caohachaauru ichoae nelauriana rautatiin aihure. ");
INSERT INTO uraNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chaentechu, autanaauru caje acaauru loreri niha natiin ruluure. Nitohaneeinte necha aansaineein ichaaoruhane que nainacuruha cachaaurune coataa sonafaajianaaichuru Cana Coaunera bajaae bajajeein ichaaore. Acaaurute leeochaauru amuritoheriin caseteco coaraa cuurureein,” naain jetao cachaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nii jana jetaote, coriqui teeuruhane jaan curu cuhane coriqui teeuruha cachaaurune jana coarajiha lauhequiin Jesosone jana jetao, jataain araainanaain coriqui teeure coriquihonacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nii jana jetaote, turuhin jataain coroatajajeei coreein nenaa coriqui tiha cue, nii teeuruhane jaa curu cuhane ita que jerajejeein, leinjiin autana jataain cairichei. ");
INSERT INTO uraNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nii coarajeein jetaote, aina nerelanacaauru cotijiaain jetao: “Esinae rauhijiriin satiin caa curu cuhane coriqui teeurera amurijiriinte coriqui te caa leinjiin autana cairichei. ");
INSERT INTO uraNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Jana satiin caa coriquihonacaaurute, acaauru rai cautena coriqui caa teeure. Nete laen caa ene jataain cairicheinijian natiin, acaihanijin nichaonajaanu que niicha sirii te jitariin,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Inae nii Teenforo caje mituha cuha Jesosone jana jetaote rai jetao: “Cacha relaera, jataain caohatiin ajeri caje ichanohiniha caa Teenforone coaraaina,” naa rai aina nerelanacaauru caje leinjiine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“Jataainte niqui caohatiin tasiojoaain ichanohineein coaraai. Nete inae turuha cojoanonaane bana, nii leinjiinijin nenereein caa ajeri ita ichoae teein ichanohineein inaraacha coarajei, satiin itajenojoiniha curichaaine jaun,” naain jetao aina nerelanaa tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nii baiha jetaote, nii Teenforo coarajeein rohan nenaa Olibo bichataneu cue jetao aina nerelanacaauru aina Jesoso. Inae ecu turuuruhane jaun nelauriariin lauhecoha Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Chatohanai janonaa banana nunuhereein nitohanai. Chatohanaina jana, inae jataain cataainjian nitohanaine jana coaarareein,” naain caje bajaauruha jelai teteriin, Fedoro, Saantiaao, Joaan, Aanderesi, naaonjoainurine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","“Inara coritaain niha chunine coataa caohachaain nainaain neeuche. ");
INSERT INTO uraNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Arajiichurute canuniha nocoetiinchuru turuhin: ‘Canune Curisito neeunra,’ naa uuruhane, arajii cachaauru nii acaauru coritaauruhane esenetaa cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jiaonriha: ‘Ecuuru ecuurute ne sonaana,’ naain coitucuhichene nesooneein casiichene. Nitohaneeinte nunuheca cureein. Nete caa caitoonjoan cojoanonaa satono que turuhane jaun ainenereein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Laurihu laurihu nenacaauru cachaaurute, leeochaauru aina nejerateein, ita que nererojoecaain niha cuurureein. Jana leeocha atane que ichaonacaaurute, leeocha atane que ichaonacaauru aina sonaana que niha cuurureein. Chaentechu araai lauriin aihane jaaunru, jataain mijiaaineein niha cureein carora tabai. Nii janate, niha cureein mijitena. Niite aasaaeriin necairichanaa nunuheniha cureein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Aihane jaun caohachaain nainaain neeuche. Canu corenihate, cocoainanacaihuru, reychuru, naaonjoainuri bijiu inara teeuruhane janate, sinacocacuru asaaecuru teein inara bisiha cuurureein. Nitohaneein inara teeuruhane banate, esinae rauhijiriin canuneein nihanune biha curiquicheein acaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jaiti nitohaneein satono que turuenihane ajinihate, satiin cachaauru chauratane sacutaain lauri lauri nenacaauru rai caa caitonjoan nosa caje nichoteeururichaaine beebejiha curiquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aihane jaun, cocoainanacaihuru rene inara amaauruhane, jiaonriha acaauru rai ereeichene jaaque tonajeein cuichene. Inae ecu ereeichene coina turuhichene coatiha inara aitoriheeicheein. Cana Coaunera aitoroatenojoin Cana Coaunera Suujue letononeeinte aitoriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Rai nejeraauruhachate nejeraauru colurujiha cuurureein ateinanohineeuruhane coina. Jana rai calaohichuruhachate colurijiha cuurureein acaauru inacaauru. Nii janate rai inaca colurujueeuruha acaauru calaohichurune jana, acaauru ateinaa cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Canu cachaneein neeichene corenihate inara cotaairiin inara coaraa cuurureein satiin caa chauratane sacuritaain nenacaauru cachaauru. Nete nitohaniha sainejeein satono que tiaain caitoonjoan tonoraain neite ichoteratenojoiniha cureein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aihane jaun caa reretaain aonaain tonoraauche. Inae nii Teenforo asaae jelai teein Cana Coaunera que banijiaain altar ichoae ecooca Cana Coaunera que nejeratenaa casicheine coaraquichene, ichatane jana cuhin sorooruhine Jodea ichaonacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ecuun rai loreri satono coarana ichoae niha chunine jana niha nitohanaine, jiaonriha rucuhele niha natiin roconaa coaaucane. Rauhijiriincha fauhi amuhine. ");
INSERT INTO uraNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jana ocoana jana nihane jana aihane, jiaonriha jelaiha nejenohin cajione ranaa coaaucane. ");
INSERT INTO uraNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jataainte cairichaaojoaaurureein nii cojoanonaa que inae turuhane bana ausirineein nenacaauru enecuru, sisihajeein canaanai sirichaauru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nabana elohena bana niha nitohanaine coataa Cana Coaunera bajaauche inara. ");
INSERT INTO uraNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Cana rai chauratane coaaunaain nihalu Cana Coaunerane baiha, nitohanai necairichanaa coaaraa chariji banane que airijiinte, jataain niha cureein necairichanaa cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nii necairichanaa cojoanonaa sarotiaeniha Cana Coaunerane, nerihei chuni nichotei nii caje. Nete rai cachaneein janijiin niicha ranojoinunri jataain belaihane jaun, nabana nitajeeuruhane coataa nii cojoanonaa sarotiareein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aihane jaun chunocoha inara rai: ‘Caute ne Mesihasi. Ecute ne,’ naa inara rene turuhinne, jiaonriha esenetaaichene. ");
INSERT INTO uraNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mesihasi niha nocoetiinchurute profetane lanaala nenacaaurune maajeeichuru, inara coritaa cojoelanaacojoai ichaa cuurureein. Janijiin Cana Coaunera ranojoinuru niha natiinte coritaaurureein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aihane jaun, caohachaain necohalajiin itolereneein neeichene coinane caraajenihane inara rai aitoon, que nainaain neeichene coina,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Niritiin jetaote: “Nitohaneein inae niha necairichanaa cojoanonaane baihate, nocoena niha enotone jana, atene netonai conoenereein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nii janate, dede cajene maajeeichuru naluhacoaa arasijieeurune jana, nesoone caaun rijijijianiha cuurureein dedeeu nenacaauru netonai. ");
INSERT INTO uraNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nitohanihane janate, itolere ichana nainihane coaarateein nelate que nelateein dede sacari jana fauha uhanu canu Cana Coaunera Calaohi cacha caje nejanoanaa nichaaunne jana coaariquicheein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Acate rai anjeraauru letoareein, nii janijiin niicha raauri, rai cachaauru taojiaain raauruha satiin caa chauratane tinonoritiin nuurihuru cajeeurune maajeein, dede uurihuru cajeeurune maajeeichurune coina. ");
INSERT INTO uraNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Caohachaain nainacuche, caa uhera que cuaain inara relaanune que. Inae satiin naluha nune alone baiha nacoaauneein nalojoaa uherane coaraquichenete, caje inae nichuuntaa ajaanaane coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nii rijijieein nainacuche caa caitoonjoan rijijieein aihane coaraquichene, canu Cana Coaunera Calaohi cacha caje nejanonaa nichaaune inae nichuuntaa turuhanune que. ");
INSERT INTO uraNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Esinae rauhijiriine aitoon, jaiti ooreniha ena caa satiin canu aina nenacaaurune janate, ");
INSERT INTO uraNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","nitajereein caa chauratane aina dede. Nete lae caa aitocoaaunne jaa quere, caa aitocoaaunne rijijieein que tihane reeintiaain nereein. ");
INSERT INTO uraNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nete laen: ‘Naaonjoain cojoanonaa banate ecu tiaain aicheein,’ nene naain nii chuni coitucuera. Niheichu dedeeu nenacaauru anjeraauru niha natiin coitucuuruhi. Niheichu canu niha natiin coitucuhaaun, leinjiin Ofaachate coitucuujue. ");
INSERT INTO uraNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Niique tihaneree tiaain caohachaain nainaain Cana Coaunera bajajeein neeuche. Coatiha coitucueraai nii airichaaine jaa cojoanonaa. ");
INSERT INTO uraNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Acate coriaji ataneu cunaa jeriha leinjiin cachane, rai cachaauru que loreri beraichateein, le cacha cachaauru rai amihanenaa teein, nii loreri beraicha que beraichatenajaain ratirinajaain amuhane rijijie. ");
INSERT INTO uraNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Aihane jaun, caohachaain nainaain turuhane cohajeein neeuche inara. Coatiha coitucueraai turuha nii loreri erorane, sona naluque, dede cataaun, ataohari irihanau, janone, naaonjoaainijin, turuhane jana letona jatoroaain neneeichene coataa. ");
INSERT INTO uraNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Caa inara rai aitocoaaunne rijitojoeeine leeochaauru rai netonai aitoon, caohachaain nainaain cohaquichene coina,” nae jetao, Fedoro, Saantiaao, Joaan, Aanderesi, naaonjoainuri rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Coroata janohin lanajeeca jorerera colane ichanohin faan quihuruhane jaan beseta fasocoane jana jetaote, chunocoha que coritaerateein, Jesoso mucuhin ateinaauruhane jaan lera arihure saseredotecuru curuaanaacuru aina Moisesa aitoonjoan que cacha relaaureraauru. ");
INSERT INTO uraNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nii jana tabaauru jetaote: “Nainihei nitohanai ichacaache beseta nunuhe banane. Nabana cana que nejerateeuruha ecu aina nenacaauru cachaaurune coataa,” naaure jetao ecu ita rai. ");
INSERT INTO uraNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betaniau cosibi ruhecaeraneein niicha curuaateeuri Simoon loreri asaae turuhin, ecu nelauriana najaan rori choae lauhecoha Jesosone jana jetaote, alabastro caje ichanohi que curuhin- ujuane nejesina caje ichanohi jataain coretiin nenaa jujuai nardo amaain turuha cue leinjiin ene. Nitohaneein turuhin jetaote nii jujuai curu raiheitiin Jesoso couturi choae chorohe. ");
INSERT INTO uraNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nii jana ecu neein coarajeeurera tabaauru jetaote obajeein jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Chanuna que cairichaaihuru coroatajanena richaae, nichata fashai denario core jeeoni amurijiriin nii jataain coretiin nenaa jujuai nardo que necoretelanaala joaereen nii jujuaain ichanohi jaohiche,” naain jetao nii ene que ereein nocoeje chanuure. Nii le denario jetaote le jiichoo amihanenaa core ne. ");
INSERT INTO uraNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nii jana jetaote acaauru rai: “Coa nocoeje chanuhin, coa rerohecaache. Jataain caohachate ichae catohaneein canu teein. ");
INSERT INTO uraNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Itolere banate inara aina neeurureein cairicheihuru. Nii jaunte, acaauru coroatajanena jeriquichene jaan que, acaauru coroatajanena naineriquicheein. Jana canu, itolere cojoanonaa bana inara aina neriaauni. ");
INSERT INTO uraNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Caa enete niicha ichana nainei ichae, cajabereeo jujuaauruhane jaanu que niicha rucujui nihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Esinae rauhijiriine aitoon. Chunijihuunru chauratane sacuritaain nosa caje nichoteeuru richaaine coina caitoonjoan canu ere beebejeeuruhane jaaunrute, caa catohaneein canu jaberoco jujuaa caa enene jaan coaauca cuurureein. Nitohaneeinte coaaunojoi niha cureein,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nii Jesoso aina nerelanacaauru lechoonca coroataja Jodasi Isacariote jetaote, saseredotecuru curuaanaacuru coaraa cue, acaauru aina ereein, Jesoso rene amanajaane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nitohaneein acaauru rene turuhin amanajaane coina acaauru rai aitoha Jodasine jaun jetaote, jataain coroajeein rai coriqui tenaa jerecuruhane jaun, jelai nedaaoriha Jesosone que coacue, rene amanajaane coina Jodasi. ");
INSERT INTO uraNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jorerera colane ichanohin faan quiin, Cana Coaunera rai carenero narejeen sooruhane jaan fasocoa beseta cojoanonaa nunuhe bana jetaote: “Chu fasocoa cojoanotiin que lenonichaachene jaanu que lenone jaa cuhacaanune jereei,” naain jetao Jesoso caje bajaaure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Niritocuruha raine jaun jetaote, coroatajai aina nerelanacaauru letoaain jetao: “Chajaain taa neseu cunichuche. Inae ecu turuhichene jana, baichaje cuhane acau baaibaaichaain cuujuiha leinjiin cachane jana eruhichene sacuuche. ");
INSERT INTO uraNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chaen inae loreri asaae enohane, nii loreri erora rai: ‘Cacha relaerate ii caje bajaerate, Chariji ucuha cuhane canu aina nerelanacaauru aina lenonerichaanuhin fasocoa cojoanotiin que, naain bajaerate,’ naaiche rainete, ");
INSERT INTO uraNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","aca inara que ecuunetiin coaranai loreri asaae, caohatiin rucuhenojoineein nenaa ucuha seeojoan coaaratereein. Chaen inae inara que coaaratiha nii loreri erorane, ecu teein janotiin cana lenonenu enoalaauche,” naain jetao, nii aina nerelanacaauru suujuateein letoanajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nii jaun jetaote, nii neseu cuhin acaauru rai aitoha Jesosone rijijieein leinjiin cacha eruha cuure nii coroatajai aina nerelanacaauru. Nii jana jetao acaauru que leinjiin ucuha coaaratiha nii cachane jaun, ecu teein fasocoa cojoanotiin que lenonecuruhane coina lenone jaaure. ");
INSERT INTO uraNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Inae nocohejihane jana jetaote ecu leeochaauru aina nerelanacaauru aina turuha cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nitohaneein lenonecuruhane jaaun neein jetaote: “Esinae rauhijiriin ena cau caniha inara jiniichaain lenoniha nenaate, canu que nesuujueein cacoluruheca cureein,” naa acaauru rai Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","jataain inaderaain: “Canuna ii coulurujuerichaaunte,” naain caje bajaaure le cacha cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nii jaun jetaote: “Ena, cau canu aina lechoonca coroatajai nequichene caje nenaa, canu jiniichaain canu ojoaichu cuhane faan setejiaain quichate acane. ");
INSERT INTO uraNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cana Coaunera Quiricha inoaensi cuhane aitohane rijijieein itolereneein aihanete ne. Nete jataain cairichaaojoareein nii caque nesuujueein cacoluruhera. Jataainte caohacharelu, nejanoaenihalu nii cachane,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nitohaneein lenonecuruhane ucuaetoha jetaote, faan mucuuriin Cana Coaunera bajaain, cataaun tacaain taturiin acaauru rai teein jetao: “Nocoa caa quihuche. Caate cajabereeoneein nenaa ne,” naain jetao acaauru rai te Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nii baiha, acaauru coconeein nenaa bino curu mucuuriin, Cana Coaunera bajaain acaauru rai tihane jana jetaote, satiin ita rai leruune leruuneein cooruhane baiha jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Caa canaacha coite canu coichana ne. Acate arajii cachaauru osa coreniha nijiaonrichaainne coina Cana Coauneraacha icharatei ichacaaunne jerichaaunne jaan cojunacaneein nenaa ne. ");
INSERT INTO uraNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Esinaae rauhijiriin nacoaauneein caa baiha bino corihaaunni, Cana Coaunera Cojoanonaa necaohacha que neein ecu nenaa bino cohanune reentiaain,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nitohaneein jetaote, salmo que nenateein Cana Coaunera coroaecuruhane baiha jetao aina nerelanacaauru aina jiniiquiin Olibo bichataneu cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Inae ecu turuhin jetaote: “Enene cojoanotiin cuhanete, satiin canu esenetaaichene jianeein ita caje riaaneriquicheein. Nitohaneeichene coinate: ‘Carenerocuru beraicha sooruhane janate, cajihaneein riaaniha cuurureein carenerocuru,’ naain laenanohineein ne Cana Coaunera Quiricha inoaensi cuhane. ");
INSERT INTO uraNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nena inae ichanacaaunne, jaiti Calileea turusiquichene ajiniha, canu inara ichoaaichaniha ecu niha cureeunni,” naa acaauru rai Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","“Satiin ii esenetaauruhane jianecuruhane nihanatiin coatiha laen airinaaunni canu,” naa Fedorone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","“Esinae rauhijiriin enene cojoanotiin cuhanete, jaiti coroata saain ereniha ataoharine jana, canu coitucuha nocoetelanaala nichata saain nesuujia curiquiin,” naa Fedoro rai Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","“Ii aina jiniiquiin ateinanohi nihanune coina aitocuruhane nihanatiin, coatiha nii ichoitucuha nocoetelanaala nesuujuerihaaunni,” naa Jesoso rai Fedorone jana jetaote leeochaauru netonai jerichanetojoeein aitocure. ");
INSERT INTO uraNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nii baiha jetaote, Jetesemaniineein niicha curuaateeuri cuhin, inae ecu turuuruhane jana jetao: “Cau nelauriaain canu cohacuchene, inara tonohanau Cana Coaunera bajani,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Niritiin jetaote, Fedoro, Saantiaao, Joaan, naaonjoainuri amaain cuhin jetao, jataain inaderaain nererojoecae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nitohaneein nererojoecaain jetaote: “Jataain onaanajaanu rijitocojoaainte inaderae casuujua. Cau nedaauche inara. Jiaonriha siniichene. Nirijieein ichaaojoeein canu cohacuche,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Niritiin ratirinajaain acaauru caje nita cutiin jetaote, notoroaain atane que nauri temetaain jetao: “Ofa, coatiha ii rai caaintajerihei caa necairichanaa tabai caje canu ichoteratena jereeine. Nena canu jerichaaunne rijijieein ichaaine jereneeun, ii jereeine rijijieein ichaau,” naain jetao Cana Coaunera bajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Inae Cana Coaunera bajaane baiha, jelaiha acaauru coaraa cuhane jana jetaote, sinihuruhane jana erunajaa cue. Nii jaun jetaote: “Inaenachura siniite Simoon. Jataainachura aasaeriinijin sinirena abaantaain ichaaojoenaa naineneeite. ");
INSERT INTO uraNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nabana osa que nesaruquichene coataa sinirena abaantaain ichaaojoeein Cana Coaunera bajaauche. Jataainte niqui inara suujua cuhane ainaa jeriquiche. Nete jataain abaantasine inara jaberoco,” nae jetao Fedoro rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Niritiin jetaote, nacoaauneein jelaiha cuhin jerichanetojoeein Cana Coaunera bajaa cue. ");
INSERT INTO uraNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Inae Cana Coaunera bajaane baiha, acaauru coaraa cuhane jana jetaote jataain siniitooruhane jaun, sinihuruha aina nerelanacaaurune jana erunajaa cue Jesoso. Nii jaun jetaote, nii tonaain tonoraauruhane jaanu coitucuurene. ");
INSERT INTO uraNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Inae nichata saain jelaiha cuhane baiha nacoaauneein turuhin jetaote: “Jaitinachura neloraain siniichete. Inae laen necha aansaineein osaaonacaauru bijiu Cacha Calaohi nichaaune mucuhin teeuruhane rai nihane cojoinaca que tiha. ");
INSERT INTO uraNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Chajaain nimichucuchete amuhacache. Inae tajiha nichuutaa canu belaihane saijieein canu colurujuera,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Niritiin jaiti ereerejiha aina nerelanacaauru aina Jesosone jana jetaote, sabere, enuha, naaonjoainuri que biji achunequiin arajii cachaauru que corianeraain turuha cue nii Jesoso aina nerelanacaauru lechoonca coroatajaneein nenaa Jodasi. Acaauru letoaauruha saseredotecuru curuaanaacuru aina Moisesa aitoonjoan que cacha relaaureraauru, Joriocuru bichauhenaauru, naaonjoainurine jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nitohaneein que nesuujueein colurujueein jetaote: “Nii quiicha meri lioracaite acanereein. Chaen mucuhin caohatiin biji ichojoaain amaauche,” naain jetao amanajae Jodasi. ");
INSERT INTO uraNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Niritiin acaauru amaain jetaote, inae rene turuhin rohan nichuutaain jetao: “Cacha relaera,” naain jetao Jesoso meri lohite Jodasi. ");
INSERT INTO uraNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nitohaneein jetaote, Jesoso mucuhin amaaure. ");
INSERT INTO uraNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nii jana jetaote, sabere mucuhaneecha neeoriin leinjiin saseredotecuru curuaanaa cacha uricho beuhite, ecu acaauru aina nenaa cacha. ");
INSERT INTO uraNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nii jana jetaote, nii mucuha cunacaauru cachaauru rai jetao: “Chanuna necha aansai asijiauto mucuera tocohaneein enuha, sabere, naaonjoain uhaain canu mucuha uhiche. ");
INSERT INTO uraNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Itolere cojoanonaa banane inara jana Teenforo asaae neein cachaauru relanajacoon. Nii jana chabana canu mucunajaaoheeiche. Nete Quiricha inoaensi cuhane aitoha Cana Coaunerane nainaaichene coinate caa aaiche,” nae jetao nii mucuha cunacaauru cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nii jana jetaote, ecu jelai Jesoso ratiriin, satiin soroore aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nii jana leinjiin enamanaa jetaote, shojoera que shoheshohequiin caaijie cuujihane jana jetao, acaaentonai mucuuruhane jaun, ");
INSERT INTO uraNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nii shojoera ratiriin machohequiin cha colane soroe. ");
INSERT INTO uraNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nitohaneein saseredotecuru curuaanaacuru curuaana rene Jesoso amaauruhane jana jetaote, satiin ecu netaojiaaure saseredotecuru curuaanaacuru, Joriocuru bichauhenaauru, Moisesa aitoonjoan que cacha relaaureraauru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nii jana jetaote, nita coarajeein caaijie cuuje Fedoro, saseredotecuru curuaanaacuru curuaanaa loreri chajeniha tiaajeein. Inae ecu turuhin jetaote, Teenforo beraaihurera aina nelauriaain usi que nichaatiha nedae. ");
INSERT INTO uraNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nii jana jetaote, Jesoso sohin jaaoruhane jaanu lera airihure saseredotecuru curuaanaacuru, chaen satiin Joriocuru bichauhenaauru- Junta Supremacuru, naaonjoainuri. Nejetaote, nii chatohaneein teeuruhane jaanu lera eruurene, ");
INSERT INTO uraNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","nitohaneein nohaneein colurujueeuruha arajiin cachaaurune saijieein ita rijitojoeein aitocurenihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nii jana tabaauru jetaote, nimichuhin nechu jataain nohaneein: ");
INSERT INTO uraNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Canacaanu uricho quene aonacaaun: ‘Caa cachaauruhacha ichai Teenforo itajeeinne, nichata janojoeein cuhane leeocha ichana naineeun cachaauruhacha ichanohinelanaala,’ naane jana,” naain jetao colurujueeure. ");
INSERT INTO uraNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nejetaote, ita rijitojoeein cuaain colurujeeurenihane jaun esenetana nainecurene. ");
INSERT INTO uraNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nii jana jetaote, satiin nii ecu nenacaauru cataaun nichaauraain jetao: “Chatohanaina ichaaite, toon toritiin icholuruhecuruhane jana tonoranajaeneein,” naain jetao Jesoso caje bajae saseredotecuru curuaanaacuru curaanaa. ");
INSERT INTO uraNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nejetaote, tonoraelanaala inauheneecha aonaje Jesoso. Nii jaun jetaote, nacoaauneein rai jetao: “Iina itolere icharaanu que turuha uheni Cana Coaunera Calaohi Mesihasi neei,” naain caje bajaa saseredotecuru curuaanaacuru curuaanaane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Ejeen, acaneeunchujianrana. Inarate itolere ichana nainera neein nenaa Ofa raotono nichajai que lauhecohanune jana cacoarariquicheein. Chaen techu, inae ecu tihane bana dede caje, dede sacari jana uhin fauha uhanune jana canu coaariquicheein,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nii jaun jetaote, obaecane cojunacaneein cajione soaisoaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Cha nenacaaeneeina coaara lateriquiche. Inara uricho quete, inae Cana Coaunera Calaohiniha nocoetiin irihane aonaquiche. Tonaquiche jana nii que,” naa acaauru rai saseredotecuru curuaanaacuru curuaanaane jana jetaote, satiin ita suujua rijitojoeein nii coulurujeeuruhane ujuaaihoneein aca ohane coina aitocure. ");
INSERT INTO uraNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nii jana tabaauru jetaote, coluneeinchuru nota conajaain bisiin jetao: “Aihane caa ii bisicha coitucuhin beeu,” naauruhane jana jetao, Teenforo beraichacurune maajeein nomeri faohacure. ");
INSERT INTO uraNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Nii jana jetaote, loreri chajeniha usi que nichaatiha lauhecoha Fedorone coaariin: “Ii netonaite Nasarete cocoaicha Jesoso aina amuhemuhena neei,” nae jetao Fedoro rene turuhin saseredotecuru curuaanaacuru curuaanaa coseenra. ");
INSERT INTO uraNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nii jana jetaote: “Coatiha nii carai aitohine jaan cacha coitucuhaaun. Chaa que chaainti nii aitohi,” naain jetao neesuujue Fedoro. Niritiin jetaote, jelai caje amuhin acuujuaniha neeorihane jana, inae ere ataohari curuaanaa. ");
INSERT INTO uraNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nii jana jetaote, nacoaauneein Fedoro coaraain leeochaauru rai jetao: “Caa netonaite, nere tonoraeraneein nenaa ne,” nae jetao nii coseenra, leeochaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nejetaote nacoaauneein nesuujue. Nii baiha neeoriin jetaote, nacoaauneein Fedoro rai jetao: “Rauhijiriinte bajiaa acaauru caje nenaa neei. Nii choae tacaain Calileea cocoaicha neei inatiin,” naaure jetao nii cuu nenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nii jana jetaote: “Esinae rauhijiriin Cana Coaunerate coaraje, nii aitocoichene jaa cacha coitucuenihanune,” ");
INSERT INTO uraNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","naa Fedorone rijieeoritiin irihane coroata satiha ataoharine jana jetaote: “Jaiti coroata saain ereniha ataoharine ajinihate, cacoitucuha nocoetelanaala nichata saain nesuujueriquiin,” naalu rai Jesosone coacuhin jetao chanae Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nii jana jetaote, jataain janohetiin netaojiaaure saseredotecuru curuaanaacuru aina Jorioocuru bichauhenaauru, Moisesa aitoonjoan que cacha relaaureraauru, chaen niha chatohanaine rucuheraneein nenacaauru- Junta Supremacuru, naaonjoainuri. Nitohaneein jetaote, Jesoso biji ichojoaain amaain Roma curuaanaacha letoai Jorionelanaala nenaa- coberenadoro Filato rai tiha cuure. ");
INSERT INTO uraNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Inae nii Filato rene turuaauruhane jana jetaote: “Iina Jorioocuru Curuaanaa Rey niha,” naa rai Filatone jana jetaote: “Ejeen. Esinae rauhijiriin acanichaaunne quete aitohi,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nii jana saseredotecuru curuaanaacuru jetaote, jataain araai laurii itolere ichaain nihane que aitiin colurujeeure. ");
INSERT INTO uraNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nii jaun jetaote, nacoaauneein rai jetao: “Aonaaun, jataain araai laurii itolere ichaain neeine que aitiinte icholuruhecure. Chanuna jana tonaain acaauru tonoraeneei,” nae jetao rai Filato. ");
INSERT INTO uraNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nejetaote, tonoraeniha Jesosone jaun: “Chatohanihane jaunna caa catoonraene,” nae suujua cuhane Filato. ");
INSERT INTO uraNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nitohaneein beseta bana naineein niha chuni colurujuenojoine jetaote, jerecuruha nii cachaaurune rijijieein jianenajaque Filato. ");
INSERT INTO uraNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nii jana jetaote, caresero cuhane ne leinjiin cacha Barabasineein niicha curuaateeuri. Nii Barabasite leeochaauru aina acaauru curuaanaacuru que nejerateein sonajaain jaaorera ne. ");
INSERT INTO uraNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nii jana jetaote Filato rene turuhin, nii beseta bana naineein ichanajaaocane rijijieein ichaa Filatone coina caje bajaaure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nii jaun jetaote, acaauru rai jetao: “Aihane jaunna, inara Jorionequichene Curuaanaa Rey jianichaaunne jeriquiche,” nae jetao acaauru rai Filato, ");
INSERT INTO uraNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","saseredotecuru curuaanaa amurijiriin coitucuhin cachaauru relaa Jesosone jaun, arajii cachaauru esenetaain sacuuruhane jaun que necoelai caaun mucuhin rai teeuruhane que nainaane jaun. ");
INSERT INTO uraNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nejetaote, cachaauru suujuau tacaaure saseredotecuru curuaanaacuru, Barabasi jianeratecuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nii jana jetaote, acaauru rai jetao: “Chatohanai jana ichacaaunne jeriquiche caa Jorioocuru curuaanaa Reyneein inaraacha curuaatei aina,” naain acaauru caje bajaa Filatone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“Coroso que teeinene jerichaanura,” naauruha ehequiinne jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Chatohanai baasonajian ichae,” naa acaauru rai Filatone jana jetaote, nacoaauneein ehequiin jetao: “Coroso que teechaaura,” naaure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nii jaun jetaote cachaauru aina caohachaain nenaa jerihane jaun Barabasi jianeein, Jesoso bisichatihane baiha acaauru rai te Filato, coroso que teeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nii jana jetaote, nii cocoainanacai loreri chajeniha Jesoso amaain, sondaro nejesinanejeein ecu satiin netaojiaaure. ");
INSERT INTO uraNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nitohaneein netaojiaain jetaote, que cajione jichohajiojoaai lanajai curujuaain, ojoa caje ichanohin comai lauriaaure coturi que. ");
INSERT INTO uraNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nii baiha jetaote: “Acaneein neeine Jorioocuru Curuaanaa Rey,” naaure jetao ehequiin nechu jataain cairichaa que nocoatijiaa. ");
INSERT INTO uraNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Niritiin jetaote, enuha que rai couturi faojoaain coulunecuruhane baiha, nechu jataain que ninichaajia nacatiha neseeonriaaure soondarooru. ");
INSERT INTO uraNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nitohaneein jataain que ninichaajeeuruhane baiha jetaote, nii cajione lanajai jichohajiojoai que niicha curuhacuri rocohin jetao, rai cajione esine curujuaain, jelai caje amaain coroso que tiha cuure. ");
INSERT INTO uraNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nii jana jetaote, ocoana caje caaujiha Alejaandoro, Rufo, naaonjoainuri inaca leinjiin cacha Sirene cocoaicha Simoonne jana coaraain jetao cotihacure, nii Jesoso teeuruhane jaanu coroso amaane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nitohaneein jetaote, Golgotau Jesoso amaaure. Golgota naane jetaote, “Niha couturi bejerona jaan,” naane aite. ");
INSERT INTO uraNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Inae ecu turuhin sacari mirra jujuaain nenaa que jasiiteein bino que cocoanaa jerecuruhane jana jetaote conaa jerene Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nitohaneein cairichaain jetaote coroso que teein, “Chariji raineeincha nedareein,” naain que nocoatijiaain ecu nejesinajeein ita rai Jesoso cajione chaluure soondarooru. ");
INSERT INTO uraNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","26","Janone nichae nuna macohi ichoae teejia enotone jana coroso que teein jetaote: Jorioocuru curuanaa niha nocoetohane jaunte, “Jorioocuru curuaanaa Rey ne,” naain que aitiin, laenanohineein nenaa tabara teeure coturiniha. ");
INSERT INTO uraNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chaen jetaote ecu aina corotajai asijiautooru teeure coroso que, leinjiin raotono nichajaique, leeocha rai najaabiji nichajaique, naaonjoaain. ");
INSERT INTO uraNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nitohaneein jetaote: “Necha ansai asijiautooruneein nenaa rijijieeinte nereein,” naain laenanohineein niha Cana Coaunera Quiricha inoaensi cuhanene nainae. ");
INSERT INTO uraNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nii jana jetaote, coturi rurujuaain: “Ichalaraa. Chajaain aihane Teenforo itajeein nichata janojoin cuhane nacoaauneein michunaa jereeine rijijieein ");
INSERT INTO uraNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ichaajenihane ijiabereeo ichoterateein coroso caje faau,” naain jetao Jesoso nocoeje chanuure satiin ecu situnacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Saseredotecuru curuaanaacuru, Moisesa aitoonjoan que cacha relaaureraauru, naaonjoainuri netonai jetaote: “Leeochaauru ichoteratiha niqui, nete raajenihane jaberoco ichoteratena nainene. ");
INSERT INTO uraNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chajaain aihane caa coroso caje fauhine Mesihasi- Isaraelitaauru curuaanaa Reyte coaraain esenetaacache,” naain jetao que ninichaajeeure nii Moisesa aitoonjoan que cacha relaaureraauru. Nii ecu jiniichaain coroso que nenacaauru netonai jetaotechu Jesoso nocoejechanuure. ");
INSERT INTO uraNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nii jana jetaote, enoto chujutora caje coaauneein nunuheteein nocohena ne satiin caa chauratane nuna macohi ichoae teejiha sonanereentiaain. ");
INSERT INTO uraNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nii rijieeoritiin jetaote, jataain tonijiaain jetao: “Eloi, eloi, lema sabactani,” naane jetao: “Cana Coaunera cacorataaneeun, chanuna catohaneein canu nainatejeei,” naa jetao aite Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nii jana nii ecuneein aonajeeurera tabaauru jetaote: “Aonacuche profeta inoaensi Eliasi cotihacate aite,” naaure jetao ita rai. ");
INSERT INTO uraNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nii jaun jetaote, leinjiin acaauru caje nenaa cacha jetao, jeluhariin cuhin cajione que bino baaso elohanti sisiaain amaain jetao, Jesoso rai sijirichae jiarana nujuan macohi que teein cohane coina. “Coa rerohecaachete aihane coroso caje fauha uha Eliasine coaracaache,” naain. ");
INSERT INTO uraNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nii jana jetaote, jataain tonijiaain auhaquiin inae ohe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nii jaun jetaote, ecui nichajai caje nunuheteein ecoai nichaae cuhin nesoaiheite nii Teenforo bujuatecuruhane jaan cajione. ");
INSERT INTO uraNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nii jana, ecu neein coarajiha Roma rai soondarooru curuaanaane jana niritiin oha Jesosone jaun jetaote: “Esinae rauhijiriinte, Cana Coaunera Calaohinecaiha caa cachara,” naain jetao ecu coaraje. ");
INSERT INTO uraNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Chaen enecuru tabaauru jetaote, caje icharajeriin neein coarajeeuruhane jana, ecu acaauru aina ne Maadala bene Mariha, chaen Jose ocoala Saantiaao neba Mariha, chaen Salomee, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nii ecu neein coarajeeurera enecuru jetaote, aina cuhin Calileea niha Jesosone bana coroatajaneraneein nenacaauru ne. Chaen jetaotechu, ecu neeure arajiin leeochaauru cachaauru, Jerosaleeun cuha Jesosone jana aina cunacaauru. ");
INSERT INTO uraNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Inae nocoheca nebetacanaa cojoanonaa que janohane coinane jana, neruujeeuruha Jorioocurune jaa cojoanonaa jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Filato coaraa cue Arimatea cocoaicha Jose, Jesoso jaberoco bajaane coina. Nii Josete Jorioocuru rai nelateein nenacaauru Jorioocuru bichauhenaauru- Junta Supremacuru caje jataain nelateein nenaa ne. Acaaentonaite tururichaain Cana Coaunera Cojoanonaane cohajeein nelu. ");
INSERT INTO uraNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nii jaun jetaote, rene turuhin inae oha Jesosone que aitohane jaun cojoelatohane jaun jetao soondarooru curuaanaa cotiharate Filato, esinae rauhijiriin ohane biha raine coitcuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nii jana rene turuhin inae ohane bihane jaun jetaote Jose rai nii Jesoso jaberoco terate Filato. ");
INSERT INTO uraNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nii jaun jetaote, Jesoso jaberoco fauhin jataain cajione caohacha lino coreteein nii cajione que conajae Jose. Nitohaneein conaacane baiha jetaote, ajeri jachu cuhane teein, rai bacuujua fuhin ratiri ajeri jaberoco que. ");
INSERT INTO uraNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nii jana jetaote, ecu aina neein nii Jesoso jaberoco teeuruhane jaa jelai coarajeeure Maadala bene Mariha, chaen Jose neba Mariha, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Inae situha nebetacanaa cojoanonaane jana jetaote, semana nunuhe cojoanonaa tomiho bana jataain janohetiin enanejeein mituhajiha enotone jana jujuaihuru coreteein amaain, que Jesoso jaberoco jujuaa cuure Saantiaao neba Mariha, Maadala bene Mariha, Salomee, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nitohaneein cuhin jetaote ita rai: “Chana jana cana rai nii fueraneein nenaa ajeri elonare,” naain jetao niqui cuure. ");
INSERT INTO uraNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nejetaote coaracuruhane jana, elonanohineein ne nii ajeri seeonjoan fueraneein nenaa. ");
INSERT INTO uraNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nii jana nii ajeri jachu cuhane enooruhane jana jetaote, acaauru raotono nichajai que lauhaca leinjiin enamanaa somajaain tarararoti que cajionecohine jana coaraain nesoonetoore nii enecuru. ");
INSERT INTO uraNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nejetaote, acaauru rai: “Coa nesoonetohache. Coroso que niicha teeuri Nasarete cocoaicha Jesosona ariiche. Inae ichanaane jaun coatiha inae cau nihei. Nii teeuruhane jaan jelai coaracuche. ");
INSERT INTO uraNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Chajaain jelaiha cauhin, Fedoro, chaen aina nerelanacaauru, naaonjoainuri rai: ‘Inae inara ajinihate Calileea cue Jesoso. Ucuaaete coaariquicheein, inara rai aitoroaetohane rijijieeincha, nanichuche acaauru raicha,’ ” nae jetao nii enecuru rai anjera. ");
INSERT INTO uraNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nii jana jetaote, jataain nesoonetooruhane jaun chatatajaneein jelai caje sorohin, nii chuni rai belanaala inauheneecha neeure. ");
INSERT INTO uraNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Inae semana cojoanonaa nunuhe bana ichanaane baiha jetaote, nii suujua cuhane caaunsini moconajaera letono siricha- niicha rautailu Maadala bene Mariha rene ococoe jauriaanejeein Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aca jetaote, chanaain inaderaauruha nii Jesoso aina nerelanacaaurune jana jetao, acaauru rene turuhin biha cue. ");
INSERT INTO uraNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nitohaneein acaauru rene turuhin, jerichanejeein jaberoconeein ichaoha Jesosone coaraain biha cuha acaauru raine jana jetaote esenetaaurene. ");
INSERT INTO uraNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nii baiha jetaote, bero cuhane cuujeeuruha coroatajai aina nerelanacaaurune jana nejelauneein acaauru rai ococoe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nitohaneein acaauru rai ocoocane coaraain, leeochaauru rai biha cuuruhane jana jetaote, nii acaauru niha natiin esenetaaurene. ");
INSERT INTO uraNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nii baiha neeoriin jetaote, lenoniha neeuruha nii lechoonca leinjiin aina nerelanacaaurune jana jetao, ecu acaauru rai ococohin, nii o caje ichanaane coaraain beeurera esenetana jerelanaala baasoneein rai suujua coaracuruhane caohate. ");
INSERT INTO uraNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nii baiha jetaote: “Chajaain caa chauratane sacuritaain nenacaauru satiin cachaauru rai, nosa caje nichoteeururichaaine coina jitariin caa caitoonjoan beebejenichuche. ");
INSERT INTO uraNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Caa caitoonjoan beeichene jana esenetaain acauhanau teein nebaotisaerateite nichotiha cureein. Jana caa caitoonjoan beeichene jana esenetana jeriheichurute caseteco coaraa cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Canu esenetaain canu ere tonoraain neeichenete canu neein nenaa rijijieein moconajaera letonocuru sitaain, nejelauneeichuru nereeuru cuhane ereein, ");
INSERT INTO uraNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","acano niha natiin mucunaa naineein, naaonjoaain, corianiha natiin coichene nii chatohaneein baasoneein inara tenereein. Nii choae tacaain techu, cunaitenacaauru mucuhichene nerautaa cuurureein,” nae jetao niicha cocoainaauri rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Niritiin niicha cocoainaauri afosotooru rai irihane baiha jetaote, dedeeu iniin rai Inaca Cana Coaunera raotono nichajai que nelauriaa cuelu Cana Curuaanaa Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nii jaun jetaote, satiin chauratane sacuritaain amuhemujeein nosa caje nichoteeururichaaine beebejiha cuuruhane jana jetao, nii acaauruhacha beebejei esenetana nainecuruha cachaaurune coina acaauru aina cuaain cojoelanaacojoai ichae Cana Coaunera.");
INSERT INTO uraNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Arajii cachaaurute caa canacaanu jana Jesoso ichanohichuru laenacurelu. ");
INSERT INTO uraNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nii laenaeraaurute nunuhe caje coaauneein aina amuhemujueein niicha coarai que canacaanu relaeraneein neeuruhane coina tenojoineein neeurelu. ");
INSERT INTO uraNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nii jaunna, canuhetonai satiin coitucuurera caje bajaaun, rai nunuhe caje coaauneein colalajiin, caohachaain coitucuhanune coina. Nii jana, carai netonai jataain caohachaane jaunna carai nelatein neeine rai laenaaunra Teofilo, ");
INSERT INTO uraNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","esinae rauhijiriin erenaa niha nii ii relaauruhalune jaa esenetaain caohachaain coitucuhin neeine coina. ");
INSERT INTO uraNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jodea batane curuaanaa- rey neein niha leinjiin Jorioneein nenaa Erodesine bana jetaote, ichoaelu leinjiin Cana Coaunera aina caohachaain niha cachane coina rucuheraneein nenaa saseredote Sacariasi. Aca jetaote, acaauru inoaensi saseredotecuru Abiasa lauri caje nenaanelu. Nii jana rai sinijera Isabeli jetaote, jauriaanejeein saseredoteneein nenaa Aaroon nefoerateeuru caje nenaanelu. ");
INSERT INTO uraNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Acaauru jetaote, esinae rauhijiriin jiniiquiin Cana Coaunera esenetaain naitoonjoan tonoraain neeurelu. Nitohaneeunruhane jaun jetaote nii chuni- acaauru que chatohanai ujuaitena nainecurenelu. ");
INSERT INTO uraNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nejetaote, canaanai sirina inaeniha nii Isabeline jaun, leinjiinejei canaanai sirilanaala jiniiquiin biinaaneeurelu. ");
INSERT INTO uraNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Nitohaneein jetaote, inae Cana Coaunera notaracaae saseredote neeuruhane ichanohin jujui mocooruhane coina neeuruha Sacariasi laurichurune jaa cojoinacaque tihane jaun jetaote, nitohaniha saseredote neeuruhane ichaone jaun, Sacariasi que tacaajeein dadae, rori ichoaae teein jujui mocoha Teenforo asaaene coina. ");
INSERT INTO uraNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nitohaneein jujui mocoha enohane tonohanau jetaote, aerene neein Cana Coaunera bajae bajaecure leeochaauru saseredotecuru aina cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nii jana jetaote, Sacariasi rai ecocohin, nii jujui mocohane jaa rori raotono nichajai que jetao chujujuae Cana Coaunera letono anjera. ");
INSERT INTO uraNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nii jaun jetaote, nii anjera coaariin, nesoonetiin cojoaelatoha Sacariasine jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","“Coa nesoonetohara Sacariasi. Bajaebajaequiine aonajian Cana Coaunerara. Nii ii sinijera Isabelite leinjiin canaanai siricheeincha. Acate Joaan neein curuaateriquiincha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Chaentechu aina jataain raotojoein neriquiincha. Leeochaauru cachaauru netonaite nejanoa coroaecurureein, ");
INSERT INTO uraNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","jataain Cana Coaunera rai nelateinneein nerichaainne jaunra. Coatiha bino, abariinti, naaonjoainuri corinaainta. Acate esinae rauhijiriin Cana Coaunera suujue que suujuecoha cureein nejanoaane ajiniha caje coaauneeincha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Acate, Cana Coaunera Ere tonoraaiche Isaraeli cocoaichaneeichene coina ichareeincha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nii Joaante turuha uheneni Cana Curuaanaa ajiniha cureein, Cana Coaunera ere bera inoaensi Irihasi rai niicha tei suujueque suujuequiin- Cana Coauneraacha ichana nainei ichaain naaonjoaaincha. Acate aicheein calaohichuru aina jiniiquiin ita que suujua acateein neeuruha acaauru fojiaraaurune coinara. Chaen erenaa tonorana jeriheichuru netonai erenaa tonoraain naaonjoaaunruhane, raotojoeein Cana Curuaanaa ranaa nainecuruhane coinara,” naa rai nii anjerane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","“Inasiine bajiaa nitohaneein nerichaaunnine esenetareeun, inae casinejera aina jiniiquiin jataain biinaanihacaanu natiinta,” naa Sacariasine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Canune, Cana Coaunera letono Cabirieli neeun. Acate caletoae, ichei caa erenaa raotono bihanune coina. ");
INSERT INTO uraNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nete caa ichei aitocoaaunne esenetaeneeine jaun, ena caje coaauneei caa ichei caitoonjoan cojoinaca que tihanereein tiaain erenaachara neein neriquiincha,” nae jetao Sacariasi rai nii anjera. ");
INSERT INTO uraNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nii tonohanau jetaote, aerene neein Sacariasi cohacuruha cachaaurune jana, jataain carajaane jaun jetao, “Chana jataain ichae carajaain Teenforo asaae caje mituenihane coina,” naain jetao ita caje bajaaure nii aerene neein coharaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nii jana jetaote, tabiicha acaauru rene eresilanaala Teenforo caje mituha uhe nii Sacariasi, acaauru rai biji nejesinaacha que bihajeein. Nii jaun jetaote: “Jerihanete chaelai coaaratiha Cana Coaunerane jaa coaracaiha Teenforo asaaera,” naaunre jetao ita rai. Nii caje nunuheteein jetaote, erenaa nainelanaala nelu Sacariasi. ");
INSERT INTO uraNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Inae nitohaneein teenmforo asaae niicha ichanenu nainaain jetaote, jelaiha nenajaun cauha cue Sacariasi. ");
INSERT INTO uraNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nii baiha neeonriin, inae ausirineein jetaote, rai loreri caje amuelanaala ecuhacha ne saoqui ateein rai sinijera Isabeli: ");
INSERT INTO uraNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Cana Coaunerate, caa catohaneein caete, nabana caque nererojoecaain jaolecooruha cachaaurune coataa,” naain suujua ereein. ");
INSERT INTO uraNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Inae saota ateniha canaanai siriha Isabeline jana jetaote, Calileea batane que nenaa Nasareteu jetao, leinjiin letono anjera Cabirieli letoae Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Chariji bana quicha aina ichoaelanaala nenaa leinjiin ranuna Mariha rene turuha cuhane coina. Nii ranuna jetaote, cana inoaensihuru curuaanaa Rabiri nefoerateneein nenaa Jose que nelanajaane rai ne. ");
INSERT INTO uraNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nitohaneein cuhin jetaote, nii niha Marihane jaaun rene turuhin enohin jetao: “Ii renena bedaeniha uunra, Cana Coauneraacha rausiajei. Jataainte ii rausiaje Cana Coaunerara” naa rai nii anjerane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","coaariin nesoonetiin: “Chanuna caritiin ere canu rai,” naa suujua cuhane Marihane jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“Coa nesoonetohara Mariha. Cana Coaunerate ii janiji, ii rai caohacha ichaane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Inae leinjiin canaanai siririquiincha. Inae nejanoaane jana Jesoso neein curuaateeunicha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Acate itolere cacha amurijiriin itolere que nelateinneein, acaihaniji Cana Coaunera Calaohineein nenaaneein coitucuha cuurureein cachaaurura. Nii jana Cana Curuaanaa Cana Coaunerate, nii rai foeratera inoaensihuru curuaanaa neein nenaa Rabiri rijijieein reyneein tereein, inara Curuaanaaneein nihane, ");
INSERT INTO uraNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","rai nere tonoraaiche inara Isaraeli cocoaichaneeichene, chabana satonoelanaala inara Curuaanaaneein nihane coinara,” naa nii anjerane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","“Inasiine bajiaa nitohaneein leinjiin canaanai siricheeun nii chuni cacha aina ichaohanune coaalanaalata,” naa Marihane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","“Cana Coaunera Suujuete aiha suruaane rijijieein ichoae fauha ureein, leinjiin canaanai siriine coinara. Nii jaunte nii canaanai iicha sirii, Cana Coaunera Calaohinereeincha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ii araai Isabeli netonai techu, inae leinjiin canaanai siricheeincha. Inae biinaa nihane sainejeeinte inae canaanai siricha. ‘Canaanai sirina inaenihane jaun jete canaanai sirine,’ naauruhane jaate, inae saota atene rai canaanaicha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Coatiha Cana Coaunera rai caaintaai chata,” naa Mariha raine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Aihachuhisicha. Niicha belai nichaaunne rai aitohine rijijieein, niicha ichana jerei ichamiin Cana Coaunerara,” naa Marihane jana jetao, inae jelai caje amue nii anjera. ");
INSERT INTO uraNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nii bana jetaote, erojoeein cuhin Jodea bichatane que nenaa neseu cuhin Isabeli rene turuha cue jetao Mariha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","41","Nitohaneein cuhin jetaote, inae ecu turuhin Sacariasi loreri asae enohin, Isabeli rai iriha Marihane aonaain jetao, Isabeli suri cuhane neein nerurujuae nii rai canaanai. Nii jaun jetaote, Cana Coaunera Suujue que suujuequiin jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","jataain tonijiaain: “Cana Coaunerate, itolere enecuru rai caohacha ichaane amurijiriin ichei caohacha ichae. Nii rijijieeintechu nii ii calaohi rai netonai caohacha ichae. ");
INSERT INTO uraNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nii jaun chaneeinna jana nereeun canu, Cana Curuaanaa nebaneeine saijieein carene turuha uhine coina. ");
INSERT INTO uraNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nii carene turuhin ereeine aonaainte, rachoojoenaa caaun canu suri cuhane neein nerurujuae carai canaanai. ");
INSERT INTO uraNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nii jaunte raotojoeein neei, ii rausiaaeca nii ichei aitoha Cana Curuaanaane esenetaain tonoraaine jaun,” naa Mariha rai Isabeline jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","“Aihanuchujian. ");
INSERT INTO uraNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Canu suujuate, itolere niicha ichana naineei ichaain, canu ichoterateein niha Cana Curuaanaa Cana Coaunerane jaun coroaje, ");
INSERT INTO uraNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","rai chaneein nenihanune saijieein canu janijiin canu rausiaaeca Cana Coaunerane jaun. Nii jaunte ena caje coaauneein Cana Coauneraacha rausiajeineein cacurujuatiha cuurureein itolere janonaa bana cachaauru, ");
INSERT INTO uraNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nitohaneein jataain canu belaiha itolere que nelateein itolere ichana nainera Cana Coaunerane jaun. Leinjiin acaachate Acaneein ne. ");
INSERT INTO uraNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nii Cana Coaunerate, cairichaaojoaai itolere bana que suujua acateein ichaonacaauru coarae. ");
INSERT INTO uraNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nitohaneein itolere niicha ichana nainei ichaainte, nii chaque nelatelanaala neeuruha nii itolere que nelaaetoha nocoetonacaaurune coina icharaneein ne. ");
INSERT INTO uraNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Chaentechu, curuanaacuru reychuru nihanatiin, ");
INSERT INTO uraNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","inae cha nelanaala neeuruhane coina ichae. Chaentechu, nii leeochaauru rai chaque nelatelanaala cairicheinejeein nenacaauru rausiaeraneein ne, itolere que. Jana nii coriqui nebaneein nenacaaurute, nii cha colane bijiicha baaejeein niha cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Aihane jaunte rai cacha Isaraelitanichaachene cairichaaojoaain cana coaraane jaun, cana coroatajanereein, ");
INSERT INTO uraNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","inae nitohaneein ichaane coina, cana inoaensi Abaraaun, nii rai inamacooru, naaonjoainuri rai aitohalu Cana Coaunerane jaun,” naain jetao Cana Coaunera coroaje Mariha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nitohaneein turuha cunajau nichata ateein Isabeli aina nihane baiha jetaote, jelaiha nenajaun cauha cuelu Mariha. ");
INSERT INTO uraNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Inae nejanoaane que tiha nii Isabeli rai canaanaine jaun jetaote, quicha cojoaajineein janoae rai neba Isabeli. ");
INSERT INTO uraNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nii jana jetaote, rene turuhacoaain jetao coroaeca cuure rai naraaichuru aina rai laurijiracuru, rai caohacha ichaa Cana Coaunerane coitucuuruha raotojoeeine jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Inae fosa janoniha nii canaanai nejanoane jana jetaote, amaain rai jaberoco cari saerateein jetao, rai inaca Sacariasi curuaa que jetao curuaatenaa jerecure. ");
INSERT INTO uraNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ne jetaote jerelanaala: “Aihei, jiaohine. Joaan neein curuaacanete caohachae,” naa rai nebane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Chanuna. Inasiina niha niritocojoaain curuajaain charaaine coaalanaala niritocohare rai curuaa,” naain jetao jerecurene. ");
INSERT INTO uraNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Niritiin jetaote, nii canaanai inaca coujueluhin: “Tohanriani rai curuaata,” naain jetao bajaaure coitucuuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nii jaun jetaote, acaauru caje que teein laenaane jaanu bajae jetao biji nejesinaacha que. Nitohaneein bajaain jetaote, “Joaan neein curuaacanete ne,” naain jetao laenae rai inaca, jaiti mituheniha rai nerene jaun. Nii jaun jetaote, satiin cojoelatoore cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nii rijieeoritiin inae nacoauneein mituha nerene jaun jetaote, rachoojoeiin Cana Coaunera coroaje Sacariasi. ");
INSERT INTO uraNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nii jana jetaote, nitohanihane jaun cojoelatoore rai laurijiracuru coarajeuurera. Nii jaun jetaote, itolereneein Jodea bichatane batane sacuritaain coitucuhin ita rai beebejerejetocurelu. ");
INSERT INTO uraNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nii aonaain cojoelatiin jetaote: “Chatohanai neeinna nereein nii canaanai,” naaure jetao, esinae rauhijiriin niicha jerenohineein nenaa nihane coaaratiha acaauru que Cana Coaunerane coaracuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nii jana, nii canaanai inaca Sacariasi suujueniha neein que beratiha Cana Coaunera Suujuene jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Jataainte caohacha ichae Cana Curuaanaa Isaraeli Coaunerara, raotojoeein neeuruha rai cachaaurune coina, ichoteratiha uhana jaunra. ");
INSERT INTO uraNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nii jaunte, cana inoaensihuru curuaanaa Rabiri nefoerateneein, jataain itolere amurijiriin nelateein laraajiin nenaa letoae, jianacoon cana mitaeraanu quera. ");
INSERT INTO uraNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Inae catohaneein ichaane coinate, rai nere bera inoaensihuru que beratelura. ");
INSERT INTO uraNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Itolere cana que nererojoecaain, cana aina nejerateein nenacaaru, naaonjoaihunri caje cana mitaane coina aitohalune jaunte, ");
INSERT INTO uraNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","nii baitena nainene, cairichaaojoaain cana inoaensihuru coaraain aitohalune jaun, Cana Coaunerara. ");
INSERT INTO uraNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nitohaneein esinae rauhijiriin ichaane coina, cana foeratera inoaensi Abaraaun rai: ");
INSERT INTO uraNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Jianacoon, cana aina nejeratenacaauru caje jete cana mitaane, cha que casilanaala nere tonoraain leinjiin raaicha nelateein, ");
INSERT INTO uraNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","esinae rauhijiriin caohacha nejesina ichaain, baaso coacuelanaala inoaenlu netojoeein, itolere janonaa bana nerichaacheeinje,’ naain belu Cana Coaunera, cana foeratera inoaensi Abaraaun rai. ");
INSERT INTO uraNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jana ii, cacalabineeinete, acaihanijin Cana Coaunera neein nenaa ere beraneein, Cana Curuaanaa ajiinchatera neein niha curiquiin, jeriha Cana Coaunerane rijijieein, turunaa nainihane jaanu beebejeeine coina, ");
INSERT INTO uraNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","acaauru osa caje acaauru ichoteraterichaain Cana Coaunerane coitucuuruha cachaaurune coinara. ");
INSERT INTO uraNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jataain cairichaaojoaain cana coaraane jaunte, dede caje cana rai ena nenaa Cojoanonaa teein ne Cana Coaunera, ");
INSERT INTO uraNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nocohena tabai caje nichoteein, nii rai Cojoanonaa que neconaain cuhin, cana rai niicha tenojoin raotojoeein rachoojoeein ichaonaanaja que turuhacachene coinara,” naain jetao nii canaanai inaca Sacariasi suujueniha neein que beratiha Cana Coaunera Suujue. ");
INSERT INTO uraNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nii jana jetaote, esinae rauhijiriin Cana Coaunera Suujue que suujuequiin jetao, fohejeein cuujue nii canaanai. Nitohaneein fohejeein ichauhenaneein jetaote, cacha areroo amuhemujueein nelu, rai lauri Isaraelitacuru que necoitucueratihane reein tiaaojoaain. ");
INSERT INTO uraNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nii nejanoa rai niha Jesosone bana jetaote, itolereneein cana rai chauratane sacuritaain cachaauru letoaelu reychuru curuaanaacuru curuaanaa enferadoro Aogosto, satiin cachaauru janijiin acaauru curuaacuru cocoirichaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nii jauriaanejeein cachaauru curuaa cocoirichaauruhane bana jetaote, Siria batane coberenadoro neein nelu Sirenio. ");
INSERT INTO uraNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nii jaun jetaote, satiin acaauru foerateracuru atane cuhacoaain, quiricha cuhane curuaa teratiha cuhacoaaurelu lauri lauri caje uhin ecu turunacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nii jaun jetaote, Calileea batane que nenaa Nasarete caje cuhin jetao, Jodea batane que nenaa Beleeun cuelu jetao Jose, jelai caje nejanoanaaneein nihalu rai foeratera reyneein nenaalu Rabirine jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nii jaun jetaote, canaanai cousurihu niha Marihane jana, aina jiniiquiin quiricha cuhane curuaa laenaratiha Beleeun cue jetao Jose, ita raauruhane rai netiin. ");
INSERT INTO uraNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nii jana inae nejanoaane que tiha nii Mariha rai canaanaine jaun jetaote, nii Beleeun neeurunajau nejanoaelu rai canaanai. ");
INSERT INTO uraNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nitohaneein, inae nejanoaa nii jauriaanejeein nenaa rai calaohine jana jetaote, rai belaae que conaconariin jetao, baca lenone omane ichoae tocoeecae rai neba, neniha loreri turuurunajaanune jaun baca coloheri asaae neeuru jana nejanoaane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nii jana jetaote, Beleen rohan neeure fasoto jana janoaajihanaain, letononeein carenerocuru beraihurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nii jana jetaote, acaauru rai ecooca Cana Coaunera letono anjerane jana jetao, acaauru curuhacaain jilinetoha Cana Coaunera conone jaun, luaa nesoonetoore eluhatohane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nejetaote acaauru rai: “Coa nesoonetohachera. Raotojoeein satiin rachoojoeein neriquicheeine jaanune inara rai jataain erenaa caohachaneein biha uunra. ");
INSERT INTO uraNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Enenete inara inoaensihuru curuaanaa Rabiri neseu nejanoae inara Curuaanaa- inaraacha cohajei Mesihasi jianacoon inara ichoterateraanura. ");
INSERT INTO uraNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Caa inara rai aitocoaaunne jaate, coaraa cuhichene, baca coloheri asaae omane ichoaae rai belaae que conaanojoineein tocoeecoha jana eruha curiquicheeincha,” ");
INSERT INTO uraNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","naa acaauru rai nii anjerane rijieeoritiin jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Jataain rachoojoeein Cana Coaunera coroaecuruhine dedeeu. Raotojoeein rachoojoeein neeuruhine cau chauratane quene maajeein niicha rausiajeineein nenacaauru- rai cachaaurura,” naain jetao Cana Coaunera coroaecure dede caje arajiin ecoojoacoaain anjeraauru, nii leeocha anjera rohan ecocohin. ");
INSERT INTO uraNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Inae niritiin jelaiha dedeeu cuuruha nii anjeraaurune jana jetaote: “Chajamaaunchete aihane, caa cana rai Cana Coauneraacha beratenojohin coaanichaache Beleeun cuhincha. Chatohanaiquecha aiteta,” naaure jetao ita rai, nii letononeein carenerocuru beraaihurera- cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Niritiin erojoeein cuhin coaracuruhane jana jetaote, Mariha aina Jose eruuruhane jana jetao, baca lenone omane ichoae rai belaaeque conaanojoineein tocoeeque nii canaanai. ");
INSERT INTO uraNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nitohaneein eruhin, nii acaauru rai nii canaanai que aitoha anjerane beeuruha nii letononeein carenerocuru beraihurerane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","cojoelatoore jetao satiin ecu neein aonajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nii jana, rai neba Mariha jetaote, rai suujua cuhane nitohanihane coacuhin jetao, suujuaacha cuhane coaraje. ");
INSERT INTO uraNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nitohaneein esinae rauhijiriin nii acaauru rai biha anjerane rijijieein, jitariin coaracuruhane jaun jetaote: “Caohachate ichae cana rai Cana Coaunerara,” naain Cana Coaunera coroajeein jelaiha cauha cuure nii letononeein carenerocuru beraihureraauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Inae fosa janoniha nejanoane jana jetaote, nii canaanai jaberoco macohi cari saerateein, Jesoso neein curuaateeure, jaiti ausirineniha Marihane jana aitohalu anjerane rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Inae nii aitohalu Moisesane jaan cojoanonaa rijiu que tihane jaun jetaote, jiniiquiin nocoulucoherateeuruhane baiha jetao, Jerosaleeun nii canaanai amaain Cana Coaunera que coitucueratiha cuure. ");
INSERT INTO uraNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nitohanihane coina: “Satiin jauriaanejeein quicha cojoaajineein bereeconaa Cana Coauneraachaque nii rai beree banihatemiin. ");
INSERT INTO uraNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chaen coroatajai tajaae laaojoiri serori rijijieein nenaa torotola nenihane, coroatajai serori aao uhaaine,” naain aitohalu Cana Coaunerane rijijieein nii niicha bajai tajaae amaain cuure, rai naitoonjoan rijijieein nii tajaae niicha amaauri mocohin que Cana Coaunera belaain, que nii beree banihateeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nii bana jetaote, Jerosaleen ichoaelu leinjiin cacha Simeon. Aca jetaote, esinae rauhijiriin Cana Coauneraacha jerei ichajeein, tururichaain jianacoon Isaraeli cocoaichacuru mitaeranune cohajeein nelu. Aca jetaote, que coitucueratiha Cana Coaunera Suujuene jaun, ");
INSERT INTO uraNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","nii niicha letoaeni Mesihasi coaraelanaala ohenihane coitucuelu. ");
INSERT INTO uraNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nitohanihane jaun jetaote, nii cachaauru que suujua acatiha Cana Coaunerane jaa coloheri Teenforo asaae Jesoso causine amaauruha rai fojiaraaurune jana que coitucueratiha Cana Coaunera Suujuene jaun coitucuhin, Teenforo asaae cuha Simeonne jana jetaote, que jiniichaain nii Jesoso causine turuaaure rai fojiaraauru Teenforo asaae, Cana Coaunera aitoonjoan nainaaruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nii jana jetaote, nii canaanai coaariin, raain baiichaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Inae laen nii iicha ichanenu carai chaitoonjoan coaracaaunne jaun, inae laen nainichaaun ohanu iicha jerei icharanichaaunnera, ");
INSERT INTO uraNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","itolere notaracae ");
INSERT INTO uraNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","iicha tei jianacoon canacaanu mitaeranu coaracaaunne jaunra. ");
INSERT INTO uraNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Acate Cana Coaunera coitucuelanaala Isaraelitaniheichuru lauri lauri nenacaauru que acaauru aina Cana Coauneraacha ichanenu coitucueratereein. Chaentechu raotojoeein rachoojoeein neeurureein Isaraelitaauru, acaauru lauri caje nenaa neein niha caa iicha letoaine jaun,” naain jetao Cana Coaunera coroaje Simeon. ");
INSERT INTO uraNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Niritoha nii canaanai que Simeonne aonajeein jetaote, ecu cojoelatoore nii canaanai fojiaraauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nii jana jetaote: “Inara coroatajanemiin Cana Coaunera,” naa acaauru raine baiha jetao, Mariha coarajeein: “Aonaaun. Caa canaanaite, arajii Isaraeli cocoaichacuru itolere que nelaaetoha nocoetonacaauru nelatelanaala nedaauruhane jana, leeochaauru tabaauru itolere que nelateein nedaauruhane coina nenaane. Nitohaneein nihane corenihate, que jaolecoorureein arajii Isaraelitaauru, ");
INSERT INTO uraNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","satiin que acaauru ichao coitucueraterichaaine jaun. Nete jataain cunaain cacha jaberoco sauha saberene rijijieein, jataain cunaain ii suujuaque tacareein, que nejerateeriin neeururichaaine jaun,” nae jetao Mariha rai Simeon. ");
INSERT INTO uraNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nii jana jetaote, ecu nelu leinjiin ene netonoai- Cana Coaunera ere beraneein nenaa. Acate Asere laurineein nenaa- Fanoeri cacunu camotojoe Ana ne. Aca jetaote, jataain ranuna neein nelanajaain, caaunsi jaanacanejeein lana aina ichoaelu. ");
INSERT INTO uraNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nii baiha jetaote, fosachoonca jena jaanacaaneein nirijieein autananeein ichaohin jetao, suri couu netiinchuru janotiin inetojoeeinchuru, sonafaajihanaainchuru Cana Coaunera bajaae bajajeein nerejetelu nii Teenforo caje mituhelanaala. ");
INSERT INTO uraNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nii Ana jetaote, nii Jesoso causine turuaauruhane jana ereereeca Simeonne coaraain jetao, acaaentonoai nii Jesoso causine que ereereje, satiin nii nichoteeururichaain Jerosaleen cocoaichacurune cohajeraauru cachaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Inae nitohaneein jeriha Cana Coaunerane rijijieein rai naitoonjoa ichacuruhane baiha jetaote, jelaiha rai natane- Calileea batane que nenaa Nasarete jetao cauha cue Jose, Mariha aina. ");
INSERT INTO uraNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nii jana jetaote, fohejeein itolere que nainaain ichauhenanihajeein sacue nii canaanai, coroatajaniha Cana Coaunerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ajaanaa naineein jetaote, Jerosaleeun cuhin Fasocoa beseta bitoaa cunajaaoncure nii Jesoso fojiaraauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nitohaneeuruhane jaun jetaote, inae lechoonca coroata jaanacaa Jesosone jana jetao, nitohaniha acaauru ichaone jaun satiin cuhin nii beseta bitoaa cuure Jerosaleen. ");
INSERT INTO uraNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Inae beseta bitoaauruhane baiha, jelaiha nenajaun cauha cuuruha rai fojiaraaurune jana jetaote, Jerosaleeun nedae coitucuurenihane jana nii canaanai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nii jaun jetaote, “Inae jecha ichoaichaniha cunacaauru aina cauha cuha nii Jesoso,” naa fojiaraauru suuujuane jaun jetao, le janohin cuuru baiha, niicha coitucuuri, naraaichuru, naaonjoaihunri jana arihure niqui rai fojiaraauru, nejetaote eruurene. ");
INSERT INTO uraNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nitohaneein eruurenihane jaun jetaote, jelaiha nejenohin ariha cuure Jerosaleeun. ");
INSERT INTO uraNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nitohaneein cuhin jetaote, nichata janohane cuhane jetao Teenforo asae, Moisesa aitoonjoan que cacha relaaureraauru aina, ita rai ereeuruhane aonajeein, acaauru caje nii ereeuruhane jaan bajaa lauhequiinne jana eruha cuure. ");
INSERT INTO uraNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nii jana, jataain nainaain, nii ereeuruhane aonajeein, acaauru caje bajaain, acaauru tonoraane jaun jetaote, cojoelatoore satiin ecu neein aonajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nitohanihane jana eruhin jetaote: “Chanuna canacaanu rai belanaala nitohaneeinte canaanai. Ii inaca ainane ii ariirijiacaanu, neeine jaa coitucuenihacaanune jaun ii coinaderaain,” naa rai nebane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","50","“Chanuna canu ariirijieeiche. Tana canu inaca loreri asaae nihanu niicha jerenohineeine coitucuhicheneta,” naain acaauru tonoraa Jesosone jana jetaote: “Naaonjoaiquete aitera,” naain coitucusichurene rai fojiaraauru. ");
INSERT INTO uraNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nitohaneein fojiaraauru jiniichaain Nasarete cauhin jetaote, rai fojiaraauru ere tonoraain nerejetelu. Satiin niriinanai jetaote, rai suujuaacha cuhane coarajerejetelu rai neba. ");
INSERT INTO uraNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nitohaneein fohejeein ichauhenanihajeein, itolere que jataain nainaain jetaote, satiin cachaauru aina caohachaain ne nii Jesoso, coroatajaneein aina caohachaain niha Cana Coaunerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Inae lechoonca saoqui jaanacaain satiin cocoainanacaaihuri curuaanaa enferadoro neein niha Tiberione bana jetaote, Jodea batane rai coberenadoro neein nelu Ponsio Filato. Nii jana Erodesi jetaote, Calileea batane rai coberenadoro neein nelu. Nii jana rai nejera Ferifi jetaote, Taraconite, Itorea, naaonjoahuinri batane rai coberenadoro neein nihane jana, Abilinia batane rai coberenadoro neein nelu Lisania. ");
INSERT INTO uraNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nii jana Caifasi, Anasi, naaonjoaihunri jetaote, saseredotecuru curuaanaacuru- curuaanaaneein neeurelu. Nii bana jetaote, Sacariasi calaohi Joaan rai jetao erelu Cana Coaunera, cacha areroo rai ecocohin. ");
INSERT INTO uraNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nii jaun jetaote, Jorodaan auhaniha nenacaauru nenaanajaauru cuujecujueein jetao, “Jeriha Cana Coaunerane rijijieein inara suujua coreeuchete acauhanau teein cojunacatenohineein baotisanojoineein neeichete, inara osa caje inara ichoteratemiin Cana Coaunerara,” naain jetao, cachaauru rai beebeje Joaan. ");
INSERT INTO uraNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","5","Nitohaneein jetaote, icharejete Joaan. Niritiin laenaalu Cana Coaunera ere bera inoaensi Isaihasine rijijieein: “Nerichaain cacha areroo eheehejeein: ‘Cana Curuaanaa turunajaanu coeroteeuche, raujuiin cuaain. Satiin turiararoorute nemoanojoinereein. Atane ucuunooru nihanatiinte ranaasiin macaracanojoi nijihacoaa cureein. ");
INSERT INTO uraNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nii banate, satiin caa chauratane que nenacaauru cachaauru jianacoon cacha mitaeraanu letoaa Cana Coaunerane coaracurureein,’ ” naain nii Joaan que aitiin laenaalu profeta inoaensi Isaihasine rijijieein jetaote ichae Joaan. ");
INSERT INTO uraNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Inae nitohaneein cachaauru cojunacatiha acauhanau teein baotisaa Joaanne coitucuhin, rene cuuruha cachaauru, acaauru baotisaane coinane jana jetaote: “Chaa inara osa coreniha caseteco tabai turu rai nenaa caje nichoteein, jianacoo mituriquicheeine que inara rai aite, taibinaecuru. ");
INSERT INTO uraNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nitohanihane jaun, nii ajiniha caohachaain inara ichao coreein, Cana Curuaanaa Cana Coaunera coitucuhin esenetaain neeuchete, Cana Curuaanaa coitucueraneein inanacaaichene coaracurumiin cachaauru. Chaenchu jiaonriha: ‘Abaraaun nefoerate nichaanune jaun cha latihaacaanu canacaanu,’ naain inara raajenihane necoritanaa nainiheeiche. Cana Coauneraachate nainere, caa ajeri jaberoco caje Abaraaun nefoerate coaaunaane. ");
INSERT INTO uraNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chaentechu, inae ajianojoineein ne tero, inaana inaeniha temulene rai cojoaisi aina curuataain sauhin usihanau mocohacane rijijieein, inae jaoleneein neeuruha Cana Coaunera coitucutoha nocoetonacaaurune coina,” nae jetao acaauru rai Joaan. Niritoha acaauru rai Joaanne jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Chatohanai jana icharihacaanu canacaanuta,” naain caje bajaauruhane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Coroatajaain obiri siricha, nii obiri colane nenaa rai leinjiin teeine. Chaen lenone siricha, nii lenone colane nenaa rai teeinera,” nae jetao acaauru rai Joaan. ");
INSERT INTO uraNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nii jana jetaote, Roma curuaanaa rai impoesto nuque cachaauru cobaraain coriqui bajaaurera tabaauru netonai, acaauru baotisaa Joaan necoina turuhin jetao: “Chatohanai jana ichariacaanu canacaanuta cacha relaera,” naauruhane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Jiaonriha aitocuruha inara curuaanaacurune amuritoojoaain cachaauru cobaraain leruhin basijiauhichenera,” naa acaauru rai Joaanne jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","“Chatohanai jana icharihacaanu canacaanuta,” naain caje bajaauruha soondarooru tabaaurune jana jetaote: “Jiaonriha chatohanai ichaeniha chunine jana coulurujeein sonaa coacuhin cotaain niicha sirii rulunaa coauquichene. Inara amihaneeo corenihacha ichaaochera,” naa Joaanne jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","jataain turuha Mesihasine cohajeeuruhane jaun jetao: “Caa canaacha cohajei Mesihasi chara inae caa turuera,” naain jetao ita caje Joaan bajaaure nii ecu neein coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Niritiin ita caje bajaauruhane jaun jetaote, acaauru rai: “Canune esinae rauhijiriin, raujiaain acauhanau inara teein inara baotisaaun. Jana nii cacaaijie uhenite, Cana Coaunera Suujue, usi, naaonjoain que inara baotisaa ureein. Acate jataain camurijiriin nelateein cocoainaain letononeein ne. Nii rai safato ichora rutueranuque nihanatiin nelatejeehaaun. ");
INSERT INTO uraNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Chaentechu leinjiin inaro uhareein que aroso jiatuhin rai caohacha raain, rai bano mocoha charijibana jacanaacharanejeein nenaa usihanaau teeine coina. Nii rijijieeinte, nii jeriha Cana Coaunerane rijijieein nenaa jeriheichuru mocoha cureein, jerihane rijijieein nenacaauru janijiin raaincha,” nae jetao satiin ecu rene turunacaauru cachaauru rai Joaan. ");
INSERT INTO uraNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Niritiin acaauru suujuateein jetaote, acaauru rai Cana Coaunera beratenojoi Jesoso que Erenaa Raotono beebeje Joaan. ");
INSERT INTO uraNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chaen jetaotechu, coberenadoro Erodesi netonoai suujuate, rai nocoala Ferifi comasai Erodiasi siria comasaineeine jaun, chaen itolere baasooru ichaain nihane jianihane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nejetaote, nitohaneein nii baaso ichaane ichoae tacaain, caresero cuhane Joaan enoae, rai niritohane coreniha. ");
INSERT INTO uraNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nitohaneein jetaote, jaiti caresero cuhane enoaeniha Erodesine jana, acauhanau satiin cachaauru teein cojunacatenaaca acaauru baotisarejete Joaan. Nitohaneein cachaauru baotisaa Joaanne jana jetaote, Jesoso netonai nebaotisaerateein Cana Coaunera bajaane jana, nejoracaa dede bacuujuane jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","nichoae fauhin nelauriaa uhe inanacaain Cana Coaunera Suujue leinjiin serori rijijieein. Nii jana jetaote: “Iite acaihaniji quiicha jereei, quiicha janijiin cacalabineein neeicha,” naain toniha erenaa dedeeune jana jetao aonajeeure. ");
INSERT INTO uraNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Inae nii Cana Coauneraacha icharatenohin namihaneeon nunuhetihane bana jetaote, nichata choonca jaanaca nelu- nii Jose calaohi niha acaauruacha bei Jesoso. Nii jana nii Jose jetaote Eli calaohi nelu. ");
INSERT INTO uraNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jana Mataa calaohilu jetao Eli. Jana Lebi calaohilu jetao Mataa. Jana Meriqui calaohilu jetao Lebi. Jana Janaa calaohilu jetao Meriqui. Jana Jose calaohilu jetao Janaa. Jana Matatiasi calaohilu jetao Jose. ");
INSERT INTO uraNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jana Amoso calaohilu jetao Matatiasi. Jana Naaoso calaohilu jetao Amoso. Jana Esili calaohilu jetao Naaoso. Jana Nacaai calaohilu jetao Esili. ");
INSERT INTO uraNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Jana Maati calaohilu jetao Nacaai. Jana Matatiasi calaohilu jetao Maati. Jana Semei calaohilu jetao Matatiasi. Jana Jose calaohilu jetao Semei. Jana Jodaa calaohilu jetao Jose. ");
INSERT INTO uraNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jana Joanaan calaohilu jetao Jodaa. Jana Resaa calaohilu jetao Joanaan. Jana Sorobaberi calaohilu jetao Resaa. Jana Salatieli calaohilu jetao Sorobaberi. Jana Neeri calaohilu jetao Salatieli. ");
INSERT INTO uraNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Jana Meriqui calaohilu jetao Neeri. Jana Adiin calaohilu jetao Meriqui. Jana Cosamii calaohilu jetao Adiin. Jana Eremadaan calaohilu jetao Cosamii. Jana Eri calaohilu jetao Eremadaan. ");
INSERT INTO uraNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jana Jesoso calaohilu jetao Eri. Jana Eliseri calaohilu jetao Jesoso. Jana Jorimi calaohilu jetao Eliseri. Jana Mataa calaohilu jetao Jorimi. ");
INSERT INTO uraNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Jana Lebi calaohilu jetao Mataa. Jana Simeon calaohilu jetao Lebi. Jana Jodaa calaohilu jetao Simeon. Jana Jose calaohilu jetao Jodaa. Jana Jonaaun calaohilu jetao Jose. Jana Eliaquiin calaohilu jetao Jonaaun. ");
INSERT INTO uraNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Jana Meleea calaohilu jetao Eleaquiin. Jana Mena calaohilu jetao Meleea. Jana Matata calaohilu jetao Mena. Jana Nataan calaohilu jetao Matata. ");
INSERT INTO uraNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jana Rabiri calaohilu jetao Nataan. Jana Isaihasi calaohilu jetao Rabiri. Jana Oberi calaohilu jetao Isaihasi. Jana Bosi calaohilu jetao Oberi. Jana Sala calaohilu jetao Bosi. Jana Nasoon calaohilu jetao Sala. ");
INSERT INTO uraNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Jana Aminadaba calaohilu jetao Nasoon. Jana Admin calaohilu jetao Aminadaba. Jana Esroon calaohilu jetao Armi. Jana Faresi calaohilu jetao Esroon. Jana Jodaa calaohilu jetao Faresi. ");
INSERT INTO uraNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jana Jacobo calaohilu jetao Jodaa. Jana Isaca calaohilu jetao Jacobo. Jana Abaraaun calaohilu jetao Isaca. Jana Tare calaohilu jetao Abaraaun. Jana Nacoro calaohilu jetao Tare. ");
INSERT INTO uraNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Jana Seroo calaohilu jetao Nacoro. Jana Raco calaohilu jetao Seroo. Jana Fele calaohilu jetao Raco. Jana Eberi calaohilu jetao Fele. Jana Sala calaohilu jetao Eberi. ");
INSERT INTO uraNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jana Cainaa calaohilu jetao Sala. Jana Arafasa calaohilu jetao Cainaa. Jana Sem calaohilu jetao Arafasa. Jana Nohe calaohilu jetao Sem. Jana Lamee calaohilu jetao Nohe. ");
INSERT INTO uraNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Jana Matosalee calaohilu jetao Lamee. Jana Enoco calaohilu jetao Matosalee. Jana Jaredi calaohilu jetao Enoco. Jana Malareri calaohilu jetao Jaredi. Jana Cainaa calaohilu jetao Malareri. ");
INSERT INTO uraNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Jana Enoso calaohilu jetao Cainaa. Jana Seti calaohilu jetao Enoso. Jana Adaan calaohilu jetao Seti. Nii jana Adaan jetaote, jauriaanejeein Cana Coauneraacha coaunaineein nelu. ");
INSERT INTO uraNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nii baotisaa Joaanne baiha Cana Coaunera Suujue que suujuequiin nucuhe Jorodaaun caje cauha cuha Jesosone jana jetaote, cacha areroo amaa Cana Coaunera Suujuene jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ucuaae niha jena choonca janoneeinne jana, nechu cojuha sarue moconajaera. Nitohaneein jenachoonca janoneein lenone lanaala nihane jaun mijiintohane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","“Chajaain aihane esinae rauhijiriin Cana Coaunera Calaohi neeine, caa ajeri jaberoco rai aitoote lenoneneein nerotomiincha,” naa nechu saruha rai moconajaerane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","“ ‘Coatiha lenoneecha que ichaonaa nainihei cacha,’ aite Cana Coaunera, rai Quiricha cuhane,” naain tonoraa Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","luhecotariin ecuun amaain, satiin caa chauratane coaarateein jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Canune jitariin canuhacha ichana nainei aina satiin caa chauratane que nenacaauru curuaanaacuru curuaanaaneein neeine coina, ichei tenaa naineeun. Satiin acaauru canu raineein neeuruhane jaunne chunicoha jerera rai tenaa naineeun. ");
INSERT INTO uraNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aihane jaun neseeoriaain canu coroajeein, canu bajae bajaequinete satiin ichei niha cureein,” naa moconajaerane jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","“Nete, ‘Acaihanijin ii Coauneraacha coroajeein, rai nelateein niicha jerei ichaau,’ naain laenaerate Cana Coaunera, rai Quiricha cuhane,” naain jetao tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nii baiha jetaote, Jerosaleeun amaain ecuun Teenforo ichoae inaain jetao: “Chajaain aihane esinae rauhijiriin Cana Coaunera Calaohi neeine caalai caje nemaroteeute coaracaa. ");
INSERT INTO uraNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Cana Coaunera Quiricha inoaensi cuhane te: ‘Rai letonocuru anjeraauru letoarichaain Cana Coaunera ii beraaihuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Acaaurute rai biji que ii michuurureein, nabana ajeri que necunaitaaine coataa,’ naain laenaerate Cana Coaunera, rai Quiricha cuhane,” naa moconajaerane jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","“Chaentechu: ‘Coa ii Coaunera coujuhin coaraara,’ naain laenaerate Cana Coaunera, rai Quiricha cuhane,” naain tonoraa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ecu ratiriin carajaaojoaain caje amuhe nii Moconajaera, neniha tonaain Jesoso coujuhin coaraane jaane coitucuenihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nitohaneein, Cana Coaunera Suujue que suujuequiin niicha ichana nainei coitucuhin, Calileea cauha cuha Jesosone jana jetaote, satiin atane sacuritaain jetao que ereeure coitucuhacoaain cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nitohaneein cuhin jetaote, netaojiaain Cana Coaunera rai Rauhi que ereereecuruhane jaa coloheri sinacocaauru naineein cuhecujeein cachaauru relaane jaun jetao, satiin coroaecure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nitohaneein cuujue cuujueein jetaote, nii neein fohecalune jaan Nasareteu jetao cauha cue Jesoso. Nii jana jetaote, nitohaniha rai nichaone jaun jetao, nebetacaanaa cojoanonaa bana sinacoca asae enoha cue, Cana Coaunera Quiricha ereretaane coina. Nitohaneein ecu enohin chujuhecohane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","rai profeta inoaensi Isaihasicha laenai quiricha teeure, ereretaane coina. Nii Quiricha ereretaane coina jasasaane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Cana Coaunera Suujuete caniha ne, niicha jerenohineein, ‘Inae raotojoeein neriquicheein,’ naain cairichaihuru rai bihanune coina. Chaentechu, ‘Inae jianacoo neriquicheein,’ naain casetecocuru rai bihanune coina caletoae. Nii choae tacaain techu, maosacuru coichaain acaauru nota rautaain, cairichaihuru ichoteratichaaunne coina caletoae, ");
INSERT INTO uraNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nitohanerichaain inaraacha cohajei Cana Coaunera Cojoanonaa coitucueratihanu inara quene coina,” ");
INSERT INTO uraNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","naain ereretaane baiha jelaiha nii quiricha seriin, sinacoca curuaanaa rai teein nelauriariin lauhecoha Jesosone jana jetaote, chaque tonaelanaala coarajeeure satiin ecu nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nii jana jetaote: “Enenete esinae rauhijiriin caa Cana Coaunera Quiricha cuhane aitohane rijijieein, satiin inara acatiha turuhe caa naitoonjoa coarajeeichene notaracae,” naa acaauru rai Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ita rai ereerecure caohacha ichaa Jesosone que, satiin cojoelatiin coarajeein, acaauru rai raotojoeein ereerecane jaun. Nejetaote tabaauru: “Tajian caa Jose calaohinihaneta,” naain jetao ita caje bajaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nii jaun jetaote: “Jerihanete esinae rauhijiriin caque, ‘Aihane, cacha coichana inaeraneeine, ichaajenihane nocohichaain canacaanu notaacune coaracaanura,’ naain caque ereeiche. Chaentechu jerihane, ‘Aihane itolere ichaai Caferenaaonne rijijieein, cau chatane que jerichanejeein itolere ichaain canacaanu notaacune coaracaanura,’ naain ereeiche canu esenetaeneeinchene jaun,” naain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Esinae rauhijiriine inara rai aitoreeunni. Coatiha esinae rauhijiriin, caohachaain ranojoineein niheilu chuni Cana Coaunera ere beraneein nenacaauru profetacuru rai nataneque. ");
INSERT INTO uraNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Coaracuche nachuhinti jataain arajiin neeuruhalu Isaraelitanichaachene benecuru autanaaunru, nihalu Cana coaunera ere bera profeta Irihasine banane. Nii banate nichata jaanaca amurijiriin uheniha elone jaun, banejelanaala cana atane Isaraeli batane sacuritaain nelu mijitena omaroeniha temulene jaun. Nete nii cana benecuru autanaauru rene letono nenelu nii bana nenaa profeta Irihasi. ");
INSERT INTO uraNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nete laen coriaae atane que leinjiin Sidoon nese roha nenaa Sarepta neein curuajai neseu cana lauri Isaraelitanelanaala nenaa autana reneecha letononeein cuhelu nii Irihasi, nii autana rai lenone faane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jerichanejeein techu, arajii cana laurichuru Isaraelitacuru somane cauun cunaitecuruhane jana, acaauru rautaaenelu Cana Coaunera ere bera profeta inoaensi Iriseeo, cana lauri caje nenaa nihane saijieein. Nete laen, leinjiin Siria cocoaicha cana lauri Isaraelitanelanaala nenaa Naamaancha jetaote rautaelu,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Niritoha acaauru rai Jesosone jaun jetaote, satiin aina jataain obaaecure nii sinacoca asaae nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nitohaneein aina obajeein nimichucutaain jetaote, nii sinacoca caje sitaain, ichatane ecuunoo ichoae ichanohi niha nii nesene jaun jetao, ecu amaaunre jelai caje coaauneein nii Jesoso saruhitocuruhane coina niqui, ");
INSERT INTO uraNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","nejetaote, cha que tonajelanaala acaauru cataaun situhin amuhe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nitohaneein sitaauruhane jaun amuhin jetaote, Calileea batane que nenaa Caferenaaon cue Jesoso. Nitohaneein cuhin, ecu turuhin jetaote, ecu neein nebetacanaa cojoanonaa bana, ");
INSERT INTO uraNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ecu nenaa sinacoca asaae neein cachaauru relaane jana jetao, rautatiin aonajeeure cachaauru, leeochaauru cacha relaaurera rijijielanaala, esinae rauhijiriin rai suujua caje rocohin acaauru relaane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nii jana jetaote, nii sinacoca asaae ne leinjiin rai suujua cuhane coitucuchuhi siricha cacha. Aca jetaote, tonijiaain ehequiin: ");
INSERT INTO uraNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Coa canacaanu rerohecaara Nasarete cocoaicha Jesoso. Nechu canacaanu cairichaain canacaanu itajihate uhicha. Canune raotojoeein ichoitucuunra. Iite acaihaniji Cana Coaunera letononeein nenaaneeicha. Canacaanu jianeeura,” naane jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","“Coaa maitaa. Nii cacha suujua jianeein caje amuura,” naa Jesosone jana jetaote, satiin cachaauru acatiha chatohaneein cunaitaelanaala atane ichoae nii cacha siheitiin rai suujua caje amue nii coitucuchuhi. ");
INSERT INTO uraNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nii jana jetaote, satiin nesoonetiin coarajeein jetao: “Chatohanai cocoainanacaineein nenaana caa cacha, jataain chaque tonajelanaala nere nejesinaacha que caritohane jana caa cacha suujua caje mituha coitucuchuhi, rai nere tonoraainne coina,” naain jetao ita caje bajaaure ecu neein nii coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nitohanihane jaun jetaote, satiin nii atane sacuritaain jetao, Jesoso que ita rai ereereecure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Inae nii sinacoca caje mituhin, Simoon loreri asae turuha cuha Jesosone jana jetaote, najiniha ajaa caaun cunaiteein niha Simoon tanone jaun jetao, Jesoso rai aitocure rautaane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nii jaun jetaote, nichoae nenoracaain nii ajaa sitaa Jesosone jana jetao, inae caje amuhe nii ajaa. Nii jaun jetaote, inae nerautaane jaun nimichuin acaauru rai lenone chalue. ");
INSERT INTO uraNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nii jana jetaote, inae nuna macohi ichoae teejia enotone jana, araai laurii cunai caaun cunaitenacaauru turuaa cuure Jesoso rene, acaauru rautaane coina. Nii jana jetaote, cajanae cajanajeein acaauru ichoae biji meracaane jaun jetao nerautaacoaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chaen jetaotechu, suujua cuhane moconajaera letono sirichaauru netonoai rautaane nii nerautanacaauru cachaauru caje mituhin: “Iite Cana Coaunera Calaohi neeicha,” naauruha cojioriinne jetao, ereeuruha nii coitucuchuhichurune caohate Jesoso, Aca Mesihasineein nihane coitucuuruha nii coitucuchuhichurune jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nitohaneein jetaote, inae nemataracaa janonaane jana, nii nese caje amuhin neniha cachane jaa cue Jesoso. Nii jaun jetaote ariin, nii nihane jaa turuhin, jelai caje amuhane caohateeuruha cachaaurune jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","“Nena leeochaauru nenaanajaaunru cuhecujueein Cana Coaunera Cojoanonaa beebejia cureeun, nii coina letononeein nihanune jaun,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nitohaneein jetaote, Jodea batane sacuritaain nenacaauru Isaraelitacuru rai sinacocacuru naineein cuhecuje niicha beeni beebejeein. ");
INSERT INTO uraNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Calileea conemuri auhaniha turuhin, ecu Cana Coaunera naitoonjoan que cachaauru relaa Jesosone jaun, aonaa turuuruha arajiinne jaun jetaote, sururucure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nitohaneein sururucuruhane jana jetaote, caje fauhin redeeuru culeecuruha ate mucuurerane jana, carene que conera colane coroatajaain boteeuru coaari Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nii jana, Simoon rai niha nii ecu nenaa leinjiin botene jaun jetaote, cuhane fauhin, nemuri auha caje acau cataaunjeri nii bote amaa Simoonne coina aite Jesoso. Inae nemuri auha caje acau cataaunjeri amaauruhane jana jetaote, nii bote cuhane netiin, ecu nelauriariin caje coaauneein cachaauru rai ereerejeein acaauru relaje. ");
INSERT INTO uraNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Inae acaauru relaane nainaain jetaote: “Taa nemuri ucuaano que caa bote amaain, ecu caa inara rai redeeuru jaaochete ate mucuhichera,” naa Simoon raine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Nena inae janoaajeein rede jaohacaanu natiin, leinjiinnijin ate mucuelanaala janohacaanura cacha relaera. Nenachu ii aitohine jaun, nacoaauneein caa redeeuru jaohin coaraa curichaanura,” naain jetao tonorae Simoon. ");
INSERT INTO uraNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Niritoha acaauru rai Jesosone jaun redeeuru jaooruhane jana jetaote, jataain arajiin ate mucuuruhane jaun jetao, ate caaun nesoaiji nii acaauru rai redeeuru. ");
INSERT INTO uraNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nii jaun jetaote, leeocha bote cuhane nenacaauru acaauru leeochaauru cotihacure biji que, acaauru coroatajaniha cuuruhane coina. Nii jaun jetaote cuhin, nii coroatajai bote nemoaauruha ate quene jaun jetao, jataain naluhene rijijieein nelemue nii coroatajai bote. ");
INSERT INTO uraNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Nitohaneein jataain arajiin ate mucuuruhane jaun jetaote, jataain cojoelatiin satiin nesoonetooruhane jaun, Jesoso tijia asae neseeonriaain jetao: “Jataain osaaotohanune jaun ii rohan nenaa nainihaaunta Curuaanaa,” nae jetao Simoon Fedoro nesoone caaun. ");
INSERT INTO uraNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nii jana jetaote, nii Simoon aina neeurelu Sebedeeo calaohichuru, Joaan, Saantiaao, naaonjoaihunri, nii Simoon aina ate mucueraneein neeuruhane jaun. Niritoha Jesoso rai Simoonne jana jetaote: “Coa nesoonetohara, Simoon. Inae ate mucueraneein neriheeini. Ena caje coauneeinte, cachaauru mucuhin raeraneein neriquiincha,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Niritoha raine jaun jetaote, atane ichoae acaauru rai boteeuru inaain, jitariin niicha sirii ratiriin jetao Jesoso aina cuure Simoon Fedoro, Joaan, Saantiaao, naaonjoaihunri. ");
INSERT INTO uraNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nii baiha leinjiin neseu neeuruhane jana jetaote, Jesoso rene turuha cue leinjiin cacha cosibi ruhecaain caaun cunaiteein, nitohanai cunai siricha cacha leeochaauru rohan turunaa nainenihane saijieein. Aca jetaote, Jesoso coaariin atane que nauri turuanacanejeein notoroaain jetao: “Ii jereeine canu rautaau caa canu cosibi cajera Curuaanaa,” naane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","“Jerichaaun chujian. Ii caje amuhine caa ii cosibi,” naain biji que dadae Jesoso, nihei chuni cacha, nitohaneein cosibi ruhacaera dadanaa nainenihane saijieein. Nitohaneein dadaa Jesosone rijieeoritiin jetaote, inae caje amue nii rai cosibichuru. ");
INSERT INTO uraNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nitohaneein rautaain jetaote: “Inae nerautaaicha. Coa chaen chuni rai: ‘Acate canu rautaera,’ naain caque iriha. Raujiaaincha Cana Coaunera aina caohachaain niha cachane coina rucuheraneein nenaa saseredote rene turunihute, inae coulunohineein ii cosibi caje nerautaaine coaramiincha. Chaen nerautaaine coujunacane que nii aitohalu Moisesane rijijieein belaaine jaanu amaain teeu saseredote raicha. Aihute inae nerautaain somaraain neei nii ii cosibi cajene coaraain, inae acaauru rohan turunaa naineeine coitucuurumiin satiin cachaaurura,” naain jetao letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ne jetaote, niritiin bihane caohatiha Jesosone saijieein, acaauru rautaane coinane maajeein jataain jelai amuritoheriin turuhacoaain coaraain aonaa uure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ne jetaote, tabaauru que acaauru caje amuhin, nii neniha cachane jaau cuhin jetao Cana Coaunera bajarejetelu Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nii baiha, cachaauru relaa Jesosone jana jetaote, ecu nelauriaacoaain aonajeeure fariseeocuru tabaauru, Cana Coaunera naitoonjoa que cacha relaaurera, naaonjoainuri, Calileea batane, Jodea batane, Jerosaleen, naaonjoaihunri sacutaainchuru caje uhacoaain. Nii jana jetaote, aina cuaain niicha ichana nainei ichaa Cana Coaunerane jaun, cunaitenacaauru rautaacoaa Jesosone jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","leinjiin cacha jiurona turuaa uure cachaauru, rai nela cuhane tijichaain amaain. Inae turuaain jetaote, loreri asae enoanaa jerecure, nacatiha coaraa Jesosone coina niqui. ");
INSERT INTO uraNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ne jetaote, nene enooruhane jaanu, jataain araaicha cachana jaun. Nii jaun jetaote, loreri coarana joaracaain jetao rai nela cuhane tijichaain, satiin cachaauru cataaun jetao Jesoso acatiha nii jiurona cacha faaure. ");
INSERT INTO uraNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nii jana, esinaen rauhijiriin rautarichaainne esenetaain aihuruha nii cachaaurune coaraane jaun jetaote: “Inae ii que suujua acateein ii osa caje ichoteratenohineeicha cacalabi,” naa Jesosone jana jetao, inae nerautae nii cunaitenaa cacha. ");
INSERT INTO uraNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Niritiin nii jiurona rautaa Jesosone aonaain jetaote: “Chaneeinna ne caa cacha, caritiin ereein Cana Coaunera baijiaraanu rijitiin irihane coina. Leinjiin Cana Coauneraachate nainere nosa caje cacha ichoterateein cacha que suujua acateein nihanera,” naain jetao ereeure Cana Coaunera naitoonjoan que cacha relaaurera aina fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Niritiin que ereeuruhane que nainaain jetaote: “Chanuna niritiin ereeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chaquena caaintare: ‘Inae ii que suujua acateein ii osa caje ichoteratenohineeicha,’ naenihacane: ‘Nimichuhin amuun,’ naacane. ");
INSERT INTO uraNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Coarajeeuchenejian, Cana Coaunera Calaohi cachaneein nejanoanaa nichaaunne, itolere Curuaanaa neein nihanu caa cana rai chauratane quene coaaratete, rai nosa caje cacha ichotena nainichaaunne coitucuhiche,” naain jetao, nii jiurona cacha rai jetao: “Icheine aitoon. Nimichuhin chela seriin chenenajaun caunihu,” naane ");
INSERT INTO uraNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","rijieeoritiin jetao, satiin coarajeeuruhane notaracae nimichuhin, nii tocohacane jaa nela seriin jetao, Cana Coaunera coroajeein rai nenajaun cauha cue nii jiurohane caje nerautanaa cacha. ");
INSERT INTO uraNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nitohanihane coaraain jetaote, satiin cojoelatiin Cana Coaunera coroaaecuruhane saijieein jetao coasiin: “Charijibana coaaraa catohanaine que airijiinte, enene catohanai cojoelanaacojoai coaracaachera,” naaure jetao ita rai. ");
INSERT INTO uraNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nitohaneein nii jiurona cacha rautaane baiha, jelai caje mituha cuuruhane jaun jetaote, leinjiin cacha, Roma curuaanaa rai impoestonu que coriqui que cachaauru cobaraera Lebi coaari Jesoso, nii coriqui teeuruhana jaa rori ichoae lauheco jana. Nitohaneein coaariin jetaote: “Chajaau canihara,” naain cotihaca Jesosone ");
INSERT INTO uraNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","rijieeoritiin nimichuhin jetao, satiin niicha ichanenu ratiriin Jesoso jiniichaain aina cue Lebi, caaijie cunacaauru aina. ");
INSERT INTO uraNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nitohaneein Jesoso jiniichaain cuhin jetaote, nii baiha neenejeein coroaena caaun rai loreri asae beseta ichaa Lebine jana jetao, ecu neeure arajiin leeochaauru Roma curuaanaa rai impoestonu que coriqui que cachaauru cobaraaurera, chaen leeochaauru cachaauru, naaonjoaihunri. ");
INSERT INTO uraNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nii jaun jetaote, Jesoso aina nerelanacaauru rai: “Chanuna cocoaeraa Roma curuaanaa rai impoestonu que coriqui que cachaauru cobaraaurera aina leeochaauru osaaonacaauru aina lenoneein, acau cohin, naaonjoainchene saijieein, nii acaauru aina netaojiaain lenonequiche,” naaure jetao acaauru rai, nechu jataain acaauru que iriha Cana Coaunera naitoonjoa que cacha relaaureraauru fariseeocuru aina leeochaauru fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Niritocuruha nii aina nerelanacaauru raine aonaain jetaote: “Coatiha coichara latecuruhi raotojoeein raurohin nenacaauru. Leinjiin cunaitenacaauruhachate coichara latecure. ");
INSERT INTO uraNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Coatihachu baaso ichacuruhane nihanatiin coitucunaa jeriheichuru cotihaca uhahaun. Leinjiin osaaocuruhane coitucuureraaurune cotijiaaun, rai suujua coreein jeriha Cana Coaunerane rijijieein neeunruhane coinara,” naain jetao tonoranajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nii jana jetaote: “Chanuna jana chaen, Joaan, fariseeocuru, naaonjoaihunri relanojoinuru jataain Cana Coaunera bajaae bajaaecure suri couu netiin cosinacaain. Nete laen itolere bana ii aina nerelanacaauru, acau cohin, lenoneein, naaonjoaunreta,” naauruha Jesoso raine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","“Aiha chuhisi niqui. Nete ene ranaa jeriha cachana jaa beseta que neeuruhane jaun, suri couu neein cosinacanaa nainecurene caa cotihanohinchuru, jaiti acaauru aina niha nii ene raeranu cachane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nete laen, inae nii jianacoon teein cacha ranaa jerera nichaaunne amaauruhane suri couu neein cosinacaain inaderaa cuurureeincha,” naain jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","“Coaraanachuhinti, nihei chuni, obiri enachasine soaain que cajione siri counera. Nitohaneein nii obiri enachasine soaihanete nii obiri enachasine asaaere, nii cajione siri. Chaen caohachaain nedanaa nainihei nii obiri enachasine, nii cajione siri que couneraane. ");
INSERT INTO uraNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nii rijijieeinchu, nihei chuni inae conaca que tiha coaaeraine jana cuhane ichonai tera. ");
INSERT INTO uraNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nitohaneein cuhane teraa ichonainete naasaaere nii coaaerai. ");
INSERT INTO uraNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Niheichu coaaerati cohane baiha ichohanti coera, ichonai amuritoheriin raotoha coaaeratine jaun,” nae jetao, cacha relaauruha fariseeocurune rijijielanaala, leeochaneein cacha relaane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nebetacanaa janonaa bana tirico coocana jana situujueeuruha aina nerelanacaauru aina Jesosone jana jetaote, nii tirico moloonejeein biji cuhane situsitunijihanaain nucuhe quihure nii aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nii coaraain jetaote: “Chanuna nebetacanaa janonaa bana cocoaeraa nitohanai ichara natiin, nitohanai ichacure nii ii aina nerelanacaauru,” naain bajaauruha fariseeocuru tabaaurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","“Aiha niqui. Nete laenanohineein ne Cana Coaunera Quiricha cuhane. Tana lesajei que Cana Coaunera loreri taberenacolo asae enohin Cana Coaunera que banijiaineein niha nii faan natiin, mijitenacaaun rai corihacuru aina jiniiquiin nii faan quiha Rabirine ereretaain coaraquicheneta. Acaihaniji saseredotecuruhacha nii faan quihane rai nihanatiinte quihurelu,” naain jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Canu- cachaneein nejanoanaa nichaaunnena, nebetacanaa cojoanonaa amurijiriin cocoainanohineein neeun.” naain jetao acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nii baiha jetaote, coaiteen nebetacanaa cojoanonaa bana, sinacoca asae enohin cachaauru relaa Jesosone jana jetao, ecu acaauru jana niha leinjiin cacha, rai biji raotono nichajai que jiuronane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","“Necha caa nebetacanaa janonaa bana nihane saijieein, caa jiurona bijii cacha rautarichaainta,” naain jetao, Jesoso cojoelaaure colurujueeuruhane jaan lera ariha aihuruhane jaun, Cana Coaunera naitoonjoa que cacha relaurera aina fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ne jetaote, nii cojoelaauruhane que nainaain jetao, nii jiurona bijii cacha rai jetao: “Nimichuhin nii ena cataaun nichaauraaura,” naa nii Jesosone jana jetaote, nimichuhin nichaauraa nii cachane jaun jetao, nii fariseeocuru rai: ");
INSERT INTO uraNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","“Inara raine leinjiin erenaa bajanaa jereeun. Chatohanai ichacaane caohachae. Nebetacanaa janonaa bana, cacha ichao rai caohacha ichacaanena caohachaa. Ainihane cacha ichao itajihacanena caohachaa,” ");
INSERT INTO uraNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nii baiha jetaote, nii ecu satiin curuhacaain nenacaauru coaraain jetao, nii cacha rai aitoha jetao: “Ichoii raujiaaute coaracaara,” naa rai Jesosone jana jetao, rai biji raujiaa nii cachane jana jetao, jiurohane caje inae nerautae nii cacha biji. ");
INSERT INTO uraNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nitohaneein nii jiurona rautaane coaraain jetaote: “Chana icharihacache caa aansai aina,” naain jetao, jataain Jesoso aina obaaecure nii ecu neein coarajeeurera fariseeocuru aina Cana Coaunera aitoonjoan que cacha relaaureraauru. ");
INSERT INTO uraNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nii bana jetaote, ichatane ecuunno que cuhin, janoaajeein Cana Coaunera bajaebajajeein janoe jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Inae janohane jana jetaote, nii aina nerelaa amuhemuhenacaauru jitariin cotihanajaain acaauru caje janijiin lechoonca coroatajaihuri cocoainaain, afosotooru neein acaauru curuaate. “Afosoto” naanete, “Letononeein nenaa” naane aite. ");
INSERT INTO uraNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nii niicha janijiichuru jetaote, Simoon- nii Fedoro neein niicha curuhateeni, chaen nii Simoon nejera Aanderesi, chaen Saantiaao, Joaan, Ferifi, Bartolomee, ");
INSERT INTO uraNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateeo, Tomasi, chaen Arafeeo calaohi- Saantiaao, chaen Selote neein niicha curuaateeuri- Simoon, ");
INSERT INTO uraNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","chaen Saantiaao calaohi- Jodasi, chaen nii Jesoso coulurujueranu Jodasi Isacariote, naaonjoaihurine. ");
INSERT INTO uraNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Inae nitohaneeein ichatane ecuunno cuhin, nii rai afosotooru janijiin cocoainaane nainaain jetaote, acaauru aina jiniiquiin atane macararo que fauha cue Jesoso. Nii jana jetaote, ecu turuhin nii aina amuhemuhenacaauru aina netaojiaaure arajii cachaauru. Jodea batane, Jerosaleeun, cucuhana auhaniha nenacaauru neseeuru- Tiro aina Sidoon, naaonjoaihunri cajeeurune maajeein turuhacoaaure. Acaauru relaa Jesosone aonanacanejeein, acaauru rautaa acaauru cunain cajene coinane maajeeinchuru turuuure jataain arajiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nii coitucuchuhi ichanohineein cunaitenacaauru rautaane jana jetaote, nerautaacoaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nii coaraain jetaote, satiin cachaauru, Jesoso dadanaa jerecure biji que, aca jerihane rijijieein nerautaacoaauruha nii cunaitenacaaurune coaracuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nii jana jetaote, nii aina nerelanacaauru coaraain jetao: “Ena cairicheineein neeichene natiinte, nerausiajeein neeiche, Cana Coaunera cojoanonaa inara rai nihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ena mijitenaanaun neeichene natiinte, nerausiajeein neeiche, nii chaque lanaelanaala neriquicheeine jaun. Ena chanaaiche natiinte, nerausiajeein neeiche, rachoojoeein enoanaain neriquicheeine jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Canu cachaneein neeichene coreniha, inara cotaain, inara sitaain, inara nocoeje chanuhin, inara que jaolequiin naaonjoaauruha canu corenihane nihanatiinte nerausiajeein neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nitohaneein inara teeuruhane nihanatiin jataain raotojoeein rachoojoeein neeuche, canu coreniha dedeeu raotojoeein neriquicheeinne jaun. Coaracuchenachuhinti, inara cairichaauruha inara araaichurune rijijieein, Cana Coaunera ere beracuru profetacuru cairichaeriin nerejetucuruhalu acaauru inoaensihuru. ");
INSERT INTO uraNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Coaraain nainacuche coriquihonacaauru. Inae ena aaichene rijijieein rachoojoeein niha curieeicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Coaraain nainacuche ena raotojoeein lenoneein nenacaauru. Inae nerinaain inara rai lenone. Coaraain nainacuche ena enoanaain nenacaauru. Inae inaderanaa caaun chanaa curiquicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Coaraain nainacuche itolere neein atane sacuritaain coroaenohineein nenacaauru. Nitohaneeinte profetaniha nocoetonacaauru coroajeein nerejetocurelu inara inoensihuru. ");
INSERT INTO uraNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nena laen inara canu ere tonoraera nequichene rai aitoreeunni. Inara que nererojoecaain jaolequiin nenacaauru belaain caohachaain acaauru aina neeuche. ");
INSERT INTO uraNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nechu jataain inara cotaiha: ‘Coaraain nainacuche necha aansaihuru,’ naain inara que ereein nei belaain, rai Cana Coaunera bajaauche. ");
INSERT INTO uraNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chunucoha lejerajei chomeri faohitohane, rai jera netonai icharateeu. Jana chunucoha ii cajione buri ruluhane, rai ii obiri netonoai teeute amaaine. ");
INSERT INTO uraNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Jerichanejeeinchu, ii caje chaelai bajaeranihane teeu. Coa ii caje iicha sirii rulueranihane, coa tonaain iriha. ");
INSERT INTO uraNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Charijieeinchaainti, inara belaiha cachane jeriquiche, nii rijijieein acaauru belaihuche inara netonai. ");
INSERT INTO uraNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Inara belaichaauruhacha belaain neeichenete, aihuruha nii Cana Coaunera coitucuelanaala nenacaaurune rijijieein neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nii rijijieeintechu, inara coroatajaneraauruhacha belaain neeichene, aihuruha nii Cana Coaunera coitucuelanaala nenacaaurune rijijieein neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chaentechu, chaelai lateein niha cachane jana, inara rai cainaane coina teeichene, aihuruha nii Cana Coaunera coitucuelanaala nenacaaurune rijijieein neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jana laen, nii inara que jaolequiin, inara que nererojoecaaeriin, naaonjoaain nenacaaru aina caohachaain neein, chaelai latecuruhane acaauru rai teeiche, inara rai cainacuruhane latelanaalane, caohachae. Nii rijijieein neeichenete, esinaen rauhijiriin jerihane rjijieein ichaquichene jaun, inara rai nii cainareein Cana Coaunera, nitohaneein acaauru belaiha natiin coitucunaa jerelanaala nenacaauru, neechu aansaineein ichaonacaauru, naaonjoaihunri belaain ichaa Cana Coaunerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nii cairichaaojoaain cachaauru coaraa Cana Inaca Cana Coaunerane rijijieein, inara netonoai cairichaaojoaain inara amute cachaauru coaracuche. ");
INSERT INTO uraNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jiaonriha leeochaauru amurijiriin nenaa coacuhin, leeochaauru que baasoneein ereein neeichene, nabana, nii leeochaauru ichaquichene rijijieein inara tiha Cana Coaunerane coataa. Chatohanai ichaa inara leeochaaurune, acaauru que inara suujua acatecuchete, inara que netonoai suujua acatemiin Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chaelai lateein neeuruha inara amute cachaaurune jana rai teeichenete, inara rai inaraacha latei tereein Cana Coaunera. Jitariin inaraacha sirii teeichene nihanatiinte, jelai amuritoheriin inara rai cainareein Cana Coaunera. Chaentechu leeochaauru coaraquichene rijijieein, inara netonain coaareein Cana Coaunera,” naain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","“Coatiha nelaterihei, leinjiin maosa amaeraanu que niha leeocha namute maosane. Enaachate nitohanihane, leinjiin ecuha jachu cuhane naluhin jiniiquiin nitajenaa nainecurure. ");
INSERT INTO uraNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Niheichu nii chuni, rai relaera amurijiriin nenaa nainera. Nii inara relaera rijijieein nerelaaichene banaachate nainereeiche, raujiaain rijijieein neeichene. ");
INSERT INTO uraNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Chanuna inejeraacha baaso ichajeein ichaohane coaraai. Tana iitonai jataain amurijiriin baaso ichajeein ichaohine coaraaine. ");
INSERT INTO uraNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chasiina iitonai baaso ichajeein ichaohine coitucueneeine, baaso ichajeein ichaoha inejerane coitucureei. Jauriaanejeein ii baaso ichajeein ichaohine coitucuhin jianeein ichaao. Nii baihate laen nainereei inejera rai: ‘Baaso ichajeeinte ichaohi. Chajaain baaso ichajeein ichaohine jianeein caohachaain ichaao,’ naain erenaa nainereei. ");
INSERT INTO uraNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nihei chuni temule caohacha, baaso que inaana nainei. Niheichu temule baasoniha natiin caohacha que inaana nainei. ");
INSERT INTO uraNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nitohaneeinte, rai ninaa caje temule caohacha coitucuhaca. Nitohanihane jaunte, chabana tijiemule que inaana nainene ojoa. Jerichanejeeinchu chabana cajiauhi que, inaana nainihei ijiaaen soririji. ");
INSERT INTO uraNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nii rijijieein techu, caohachaain suujua coaara cacha, caohacha nejesina que ere, satiin caohacha- rai suujua cuhane nihane jaun. Jana cacha, baasoneein suujua coaarate baasoneein ere, satiin baaso- rai suujua cuhane nihane jaun. Nitohaneeinte cacha ujuae caje mitue satiin rai suujua cuhane nenaa. ");
INSERT INTO uraNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Chanuna itolere bana, ‘Canu Curuaanaa,’ naainchene sainejeein quere tonoraain quiicha jerei ichaeneeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aonacuchena inara rai canu ere tonoraain caitoonjoan icharaauru que erete coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Charijiein chaainti, loreri jaane coina jauriaanejeein ucuaatiin bajeein, enuha suuji caohachaauru temuhin ichaa leinjiin cachane jana, uha tabanaane jana que tacaa uujinaa mijiaaineein nihanatiin nii loreri comaene, caohatiin ichanohin nihane jaun. Nii rijiicha cacha, canu ere tonoraain caitoonjoan ichaa chabana jianelanaala ne. ");
INSERT INTO uraNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jana quere tonoraeniha cachanete, araracaaeriin atane bajeein, baasooru que banesijiateein loreri ichara cacha rijijieein ne. Nii jana uha tabanaane, que mijiaaineein tacaa uujuinaane jana, beraujuaain nitaje nii loreri, nii rijiicha nii canu aonaane sainejeein, quere tonoraelanaala nenacaauru cachaauru,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Inae nii cachaauru rai irihane nainaain jetaote, Caferenaaon cue aina nerelanacaauru aina Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nii jana jetaote, nii Caferenaaon ichoae leinjiin Romanocuru rai soondarooru curuaanaa cafitaan. Nii jana nii cafitaan letono- jataain belaain niicha sirii jetaote, cunaiteein ohane rai ne. ");
INSERT INTO uraNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nii jaun jetaote, nii Caferenaaon turuhin niha Jesosone inaaoriin jetao, Jorioocuru bichauhenaauru letoae nii cafitaan, conujueein Jesoso cotihaca cuuruhane, nii rai letono cunaitenaa rautaa uhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nii jaun jetaote, rene turuhin: “Iine cotihaca uhacaanu canacaanu letoaa cafitaane jaunra. ");
INSERT INTO uraNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Jataain canacaanu araaichuru belaichaneein, aca canacaanu rai sinacoca ichaerateein, naaonjoaain nihane jaunne, caa cafitaan coroatajaneein rai letono rautaaine jerichaanura,” naaure jetao Jesoso rai. ");
INSERT INTO uraNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nii jaun jetaote, acaauru aina cuhin, inae turuhe lalajeein cuujueeruha Jesoso ainane jana jetao, rai belaichaauru letoae nii cafitaan: “Curuaanaa, coatiha nii chaque ichei nelateein nihaaun canu loreri asae turuhine coina. ");
INSERT INTO uraNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nii jaunne caraajenihane ii cotihaca uheneeun. Acaihaniji aitoote nerautamiin canu letono. Ii aitohine rijijieein nerautarichaain canu letonone coitucuhanune jaunne ichei raujiaain berateeun. ");
INSERT INTO uraNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nii rijijieeinne canu letoaauruha canu curuaanaacurune tonoraain neeun. Nii rijijieeintechu, canu bijiu nenacaauru soondarooru caje chunucoha letoaanune, canu ere tonoraain cue. Jana chunucoha cotihacaaun uhane coinanete canu ere tonoraain uhe. Jana canu letono letoaanu chaelai ichaane coinanete canu ere tonoraain ichae, nanichuchera,” naain letoaa cafitaane jaun inae aitoha cuuruhane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","cojoelatiin, nii aina amuhemuhenacaauru cachaauru coarajeein jetao: “Coatiha Isaraelita nichaachene lauri jana, caa cacha tocohaneein jataain quesenetaera coarahaaunta,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nii jana inae jelaiha cauha cuuruha nii cafitaan loreri asae nii niicha letoaaurine jana jetaote, inae acaauru ajiniha nerautaain niha nii rai letono cunaitenaane jana turuure. ");
INSERT INTO uraNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nitohanihane baiha jetaote, aina nerelanacaauru, chaen arajiin sacuurera cachaauru, naaonjoaihunri aina leinjiin nese Naain ineein curuajai nichae cue jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nii jana jetaote, inae turuhelalajeein cuujueeruha nii nese quene jana jetao, leinjiin ene autana calaohi- leinjiin acaacha calaohineein nenaa onaa conautiha jetao cuure. Nii jana jetaote, nii nese caje cuhacoaain arajiin corihaniha cuure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nii jana nii autana coaraa Jesosone jana, cairichaaojoaain coaraane jaun jetaote: “Coa chanaara,” naain jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","nii rijieeoritiin, nii onaa roha nichuuntaain, nii amaaunruhane jaa rori dadaane jaun jetao, ecu inacuhin coarajeeuruha nii baijiaain amaaurerane jana jetao: “Enamanaa, nimichuhin nelauriaaura,” naa Jesosone jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","inae nimichuhin nelauriaain ere nii onaa. Nitohaneein nii neba rai nii onaa ichateein tiha Jesosone ");
INSERT INTO uraNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","coaraain jetaote, satiin acaneein nihane que suujua acateein cojoelatiin jetao: “Jataain itolere amurijiriin nelateein, itolere ichana nainera profetate cana rene turuera,” naain jetao: “Cana Coaunerate rai cacha nichaachene coroatajaniha uhera,” naaure jetao Cana Coaunera coroajeein, neebana nitohanai coaracuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nitohaneein coaraain jetaote, satiin Jodea batane sacuritaain jetao beeuruhane jaun, nii onaa ichatiha Jesosone coitucuure. ");
INSERT INTO uraNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nitohaneein onacaauru ichateein, naaonjoan Jesosone coaraain jetaote, Joaan rai biha cuure sacuureraauru. Nii caje coitucuhin jetaote, coroatajai sacuurera cotijiaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“ ‘Iina esinae rauhijiriin canacaanuhacha cohajei turuha uhenenineei. Aca neneeine canacaanu rai beeu, leeocha cohacaanune coina,’ naain bajanichuche rene turuhincha,” naain jetao letoanajae Joaan Baotisita. ");
INSERT INTO uraNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nii jaun cuhin, Jesoso rene turuhin: “Joaan Baotisitate canacaanu letoae, ii esinae rauhijiriin nii canacaanuhacha cohajei turuha uhenenineeine bajaacanune coina. Aca neneeine leeocha cohacaanune coina,” naauruha Jesoso rene turuhin Joaan letonocurune ");
INSERT INTO uraNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","rijieeoritiin jetaote, araai laurii cunai caaun cunaitenacaauru cachaauru rautaain, arajii maosacuru nota teein, coitucuchuhi caaun cunaitenacaaurune maajeein rautaacoaane baiha jetao, nii coroatajai Joaan letonocuru rai jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","“Chajaain Joaan rai caa ena inaraacha coarai aina inaraacha aonai benichuche. Chaen, inae maosa neeuruhane caje notaauruha maosacuru. Bacosacuru netonaite inae nichaauraain amuure. Cosibinacaauru netonoaite inae cosibi caje nerautaacoaaure. Iricho saaecuru netonaite, inae irichohin neeure. Nii jana onacaaurute jerichanejeein cacha neein jaberoconeein nichaauraain neeure. Jana cairicheinejeein nenacaauru raite, jataain acaauru rausiaaerichaain Cana Coaunerane beebeje. ");
INSERT INTO uraNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nitohanihane jaunte, nerausiajeein neeurureein canu que jaaecohane jianelanaala nenacaauru,” naain jetao, “Chajaain caritiin benichuche Joaan raicha,” naain jetao acaauru letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Niritoha acaauru raine jaun, jelaiha cauha cuuruha nii Joaan letonocurune jana jetaote, nii Joaan que cachaauru rai ereereje jetao Jesoso. “Chatohanai coaraa curejetocoichelu nii cacha areroo cuhin. Leinjiin jiarana nujuan cujuanaacha rurujuaina coaraquichelu. ");
INSERT INTO uraNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Chatohanai coaraquichelu. Leinjiin cacha cajione caohacha que necoreeteein neina coaraquichelu. Nete nii cajione caohacha que necoreeteein nenacaauru, cocoainanacaihuru loreri asae neeuruhane coitucuhiche raotojoeein. ");
INSERT INTO uraNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chatohanai jian coaraquichelu. Leinjiin profetana coaraquichelu. Aiha jerihane, jataain profetacuru amurijiriin nenaa leinjiin profetate coaraquichelu. ");
INSERT INTO uraNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nii Joaan que tejian, rai Calaohi nichaunne rai aitelu jetao: ‘Chajinihane quere beranu que leinjiin letoareeunni, turuhine jaanu rucuheraanu quera,’ naain belu Cana Coaunera, niicha laenaeratenojoi rai Quiricha inoaensi cuhane. ");
INSERT INTO uraNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Coatiha inoaenlu caje coaauneein, enanetojoeein nihei chuni nii Joaan amurijiriin nei cacha. Nete laen ena turunaa Cana Coaunera Cojoanonaa, canuhacha tei que nenaa cacha, leeochaauru fautaain nihane niha natiin jataain Joaan amurijiriin ne. ");
INSERT INTO uraNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nete cachaauru relaa Joaanne jana, satiin aonaraauru cachaauru, nii Joaan que acauhanau teein nebaotisaerateeurelu. Nii choae tacaaintechu, Roma curuaanaa rai impoestonu que cachaauru cobaraain coriqui bajaaurera netonai necha ansaineein neeuruhane saijieein nebaotisaerateeurelu, esinae rauhijiriin Cana Coauneraacha icharatenohi ichaa Joaanne esenetaauruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jana fariseeocuru aina Cana Coaunera naitoonjoa que cacha relaaureraauru, itolere amurijiriin Cana Coaunera coitucutoha nocoetocuruhane saijieein nebaotisaeratenaa jerecuruhilu, Cana Coaunera icharatenohi icharaneein aiha Joaanne esenetana jerelanaala que jaolecooruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nitohaneeinte itolere acaauru rai baaso ne. Nihei acaauru rai chabana caohacha. ");
INSERT INTO uraNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Acaaurute nenaanaja cataaun nocoatijiana jaun auno toteeuruha acaauru amute canaanaihurune jana, raasanaa jerelanaala neein, niheichu berane ichacuruhane jana chanaaurene acaauru amute canaanaihuru. Nii rijiichuruha caa enene nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nii rijiichuruhane jaunte, turuha Joaan Baotisita coaaerai conaa inaelanaala, faan niha natiin quinaa inaelanaala, naaonjoaaine jana, ‘Nechu aansainihane jaunte ai, nechu jataain coitucuchuhi siriha rai suujua cuhanene jaun,’ naain que ereeichelu. ");
INSERT INTO uraNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nii baiha canu- Cachaneein nejanohanaa nichaaunne turuhin, coaaerai cohin, lenoneein, naaonjoaanune jaunte, ‘Achotiritiinjiene tabaain lenoneein ajetoriaaneeun. Chaen jene nechu aansaineein ichaonacaauru cachaauru belaain, Roma curuaanaa rai impoestonu que cachaauru cobaraain coriqui bajaaurerane maajeein belaitoon,’ naain ereeiche caque. ");
INSERT INTO uraNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nete inae ecu tihane bana esinae rauhijiriin Cana Coauneraacha icharatenohi ichacaaunne coitucuha cuurureein satiin cachaauru,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Leinjiin fariseeo jetaote, Jesoso cotijiae rai loreri asae turuhin lenoniha cuhane coina. Nitohaneein cotihacane jaun cuhin, inae loreri asae turuhin, lenonecuruhane coina rori ichoae nelauriaa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","turuha cue leinjiin ene cojoaeloroheri nii neseu ichaonaa. Nii ene jetaote, nii fariseeo loreri asaae turuhin lenoniha cuha Jesosone inaaoriin jetao, lecuruhin jataain coretiin nenaa erene jujui amaain turuhin jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","chanaain Jesoso tijia rohan nelauriaain, rai nota baca que jetao rai tijia rujuae. Nitohaneein rujuaane baiha jetaote, rai couturiji que caruruhin jetao liosiin, erene jujui que rujuae. ");
INSERT INTO uraNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nitohaneein ichaane coaraain jetaote: “Esinae rauhijiriin leinjiin profetanihane jana nihanete, caaoneein tiha caa ene cojoaeloroerine jana, baaso nihane coitucure caa cachara,” naain jetao suujua ereein coaraje nii Jesoso cotihara fariseeo. ");
INSERT INTO uraNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nii jaun jetaote, nii fariseeo rai: “Simoon, icheina erenaa jereeun aonaaine coina,” naa Jesosone jana jetao: “Saan. Aitoo caraine aonaera, cacha relaera,” naa nii fariseeone jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Leinjiin cacha jetaote, coroatajai cacha rai coriqui te, jelai amuritoheriin rai cainacuruhane coina niqui. Nitohaneein jetaote, leinjiin rai te saoqui fashaain. Jana leeocha rai jetaote, te saoqui chooncaain. ");
INSERT INTO uraNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ne jetaote, coretena nainecurenihane jaun, nii coroatajai que rebeeonacaauru cachaauru cobaraelanaala acaauru que suujua acate nii coriqui erora. Tonaai jana nii que. Chariji jana nii coroatajaaihuri caje, jataain nii coriqui erora belaain coaare,” naa Jesosone jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Jerihane nii leeocha amurijiriin rebeeona cachate jataain nii coriqui erora belaain coaraera,” naa nii Simoonne jaun jetao: “Esinae rauhijiriinte aitohicha,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Niritiin jetaote, nii ene coarajeein, nii Simoon rai jetao: “Caa ene coaraaunachuhinti. Coatiha jauriaanejeein ii loreri asae turuhanune jana, catiha culeecaaunne coina carai acau tiheei. Nete laen caa ene, rai nota baca que catiha culejeein rai couturiji que caruruhin jacorae. ");
INSERT INTO uraNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Coatihachu turuhanune jana canu meri lioracaheei. Caa enete laen turuhin enohane caje coaauneein canu tijia lioracaane jianene. ");
INSERT INTO uraNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Niheichu nii jujui niha natiin cacouturi ichoae tiheei. Jana caa enete laen catiha ichoae erene jujui chorohin que catiha rujuae. ");
INSERT INTO uraNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nitohanihane jaunne ichei aitoon. Arajii rai nosate inae que suujua acate, jataain canu esenetaain canu belaihane coaaratiha caa ene ne jaun. Nete laen, nii leeochaauru amurijiriin caohachaain ichaoha nocoetonacaauru, rai nosa caje chabana nichoteeurenereein, chabana osaaocuruhane coitucuhin canu belaina jerecurenihane jaun,” naa nii fariseeo raine baiha jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","nii ene rai: “Inae itolere baaso ichajeein ichaohine caje ichoteratenojoineeichera,” naa Jesosone jana aonajeein jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","“Chaneeinna ne caa cacha, itolere baaso ichajeein niha caa enene jaan caje niha natiin ichoterateein nihane coina,” naauruha nii aina ecu cotihanohineei neein aonajeeurerane coitucuhin jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","“Quesenetaaine jaunte, ichoteratenojoineein neeiche, baaso ichajeein neeine jaan caje. Raotojoeein chenenajaun caunihuchera,” nae jetao Jesoso, nii ene rai. ");
INSERT INTO uraNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nitohaneein jetaote, itolereneein neseeuru naineein, nenanajaaunru naineein amuhemujueein Cana Coaunera cojoanonaa que ereerejeein amuhemuherejete Jesoso, lechoonca coroatajai rai afosotooru, ");
INSERT INTO uraNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","chaen coitucuchuhi caje, joaenreein cunai caje, naaonjoaihunri caje niicha rautaauri enecuru tabaauru que corihaneraain. Niichuru aina jetaote cuelu, nii caaunsineein suujua cuhane coitucuchuhi sirihane jana nii Jesosohacha rautai “Maadala bene” naain niicha curuaateeuri Mariha, ");
INSERT INTO uraNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","chaen Erodesi amihaneeo beraichaneein nenaa Cosa comasai Joana, chaen Sosana, naaonjoaihunri aina leeochaauru arajii enecuru jetao, acaauruhacha sirii que acaauru coroatajaneraneein cuure. ");
INSERT INTO uraNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nii jana jetaote, neseeuru caje cuhacoaain Jesoso coaraa cuuruha arajii cachaaurune jaun, arajiin netaojiaauruhane jaun jetao acaauru rai: “Aonacuchene ena inara rai temule jaera parabola que erete coitucuhiche. ");
INSERT INTO uraNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Leinjiin cacha, ucuhe riaaca cuhane jaun jetaote, bero cuhane naluha nii niicha riaajai nucuhene jaun shaaocure cachaauru. Chaen tabaauru quihure tajaaelinaacuru. ");
INSERT INTO uraNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nii jana tabaauru ajeri choae nalunacaauru jetaote, omarohane sainejeein ohijiacoae. ");
INSERT INTO uraNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tabaauru ojoa neeonjoai jana nalunacaauru jetaote, omarohane jana amurijiriin omaroha ajaenane jaun ohacoae. ");
INSERT INTO uraNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jana tabaauru atane caohacha choae nalunacaauru jetaote, caohachaain omarohane jaun, ele ucuhecuru caje ele fashai ucuheneeinchuru nefae,” naain jetaote, acaauru rai tonijiaain: “Caa caitoonjoan coitucunaa jeriquichene aonacuche,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Niritiin temule jaera que cachaauru relaa Jesosone jaun jetaote: “Chatohanai quena nii temule jaera que cuaain cachaauru rai aitohi,” naain Jesoso caje bajaauruha aina nerelanacaaurune jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Inaraacha quete rai Cojoanonaa coitucuerate Cana Coaunera. Nena laen, nii canu esenetana jeriheichuru cachaauru rai carijieein erenaa parabola que cuaain acaauru rai beeun, nabana coaracuruhane nihanatiin coitucuurenihane coina, niheichu aonacuruhane nihanatiin coitucuuruhane coataa. ");
INSERT INTO uraNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nii temule ucuhe riaara que aitocoaaunne jaan erenaa parabolate, Cana Coaunera beratenojoi rijijieein ne. ");
INSERT INTO uraNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jana nii bero cuhane nalunaa nucuhe que caitoonjoante, Cana Coaunera beratenojoin aonaain inae esenetaain neeuruhane jana, nabana nichoteeuruhane coataa acaauru coritaa uha moconajaerane jaun suujua elonaain nenacaauru cachaauru rijijie. ");
INSERT INTO uraNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jana nii ajeri choae nalunaa nucuhe que caitoonjoante, Cana Coaunera beratenojoin aonaain, coroajeein esenetaain neeuruhane nihanatiin, carajaelanaala basiinjiincha esenetaaoriin, inae necairichanaa coaracuruhane que nererojoecaain jianeraauru rijijie. ");
INSERT INTO uraNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jana nii ajaena jana nalunaa nucuhe que caitoonjoante, tonoraain aonacuruhane nihanatiin, jeraaen jianejeein cuaajeein, jataain niicha lateeicha que coacuhin, coriquiquiin raotojoeein neeururichaainne coacuhin, itolere bana niicha jereeicha ichajeein, jeriha Cana Coaunerane rijijieein cha chana jerelanaala nitajerai nenacaauru rijijie. ");
INSERT INTO uraNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jana nii atane caohacha choae nalunacaauru nucuhe que caitoonjoante, nii jataain jereein aonaain, nii beratiha Cana Coaunerane rijijieein naitoonjoan ichajeein, itolere bana tonoraain laraajiin jianelanaala nenacaauru cachaauru rijijie,” ");
INSERT INTO uraNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nihei chuni cono mocohin bujuaihu tera. Niheichu arana asae tenaa nainihei, nabana nocohenaanau turuuruha loreri asaae turunacaaurune coataa. Nitohaneein bujuaihu telanaalate ecuun te, conohanau loreri asaae enooruha turunacaaurune coina. ");
INSERT INTO uraNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nii rijijieeintechu, ena caa inara relaanune jaan coitucuelanaala nenacaauru, rijieeori bana coitucuurureein. ");
INSERT INTO uraNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aihane jaun, caohachaain aonacuche. Nii rijijieeintechu ena canuhacha tei raera jelai amuritoheriin rareein inae ecu tihane bana. Jana nii canuhacha tei latelanaala nenaate cha colane nedaareein inae ecu tihane bana,” naain acaauru rai be Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Niritiin cachaauru rai ereerejiha Jesosone jana jetaote, rene turuha uure neba aina rai nejeraauru. Ne jetaote, rohan turunaa nainecurene, jataain arajiin ecu turuuruha cachaaurune jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nii jana ecu nenacaauru tabaauru jetaote, “Taute aerene neeure ii nejeraauru, ii neba aina. Jataainte ii coaana jerecure,” naain Jesoso rai beeuruhane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","“Aiha niqui. Nete Cana Coaunera beratenojoi esenetaain, rijijieein ichaohin, naintonjoa rijijieein ichara cachate, canu fojiara aina canu nejeraaurunera,” naain jetao tonoranajaen Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nii baiha jetaote: “Amaauchete caa nemuri jerau cunichaachera,” naain jetao, aina nerelanacaauru aina leinjiin bote cuhane fauhin cuhin jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","nemuri jera jaohajeeuruhane jana jetao, uhe cujuana tabai aina fichafichanaa. Nii jana, sinitoha Jesosone jana jetao, inae nemoha acaune jaun, caaun nalunaa jere nii cuurunaja bote. ");
INSERT INTO uraNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nii jaun jetaote nesoone caun “Cacha relaera, cacha relaera, inae nalurichaacheje,” naain Jesoso nocoaauruhane jaun jetao, nimichuin cujuana aina fichafichanaa suruha Jesosone jaun jetao, tonajelanaala cuujeeure. ");
INSERT INTO uraNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nitohaneein cujuana aina fichafichanaa suruaain jetaote, nii aina nerelanacaauru rai jetao, “Chanuna cha esenetaeneeiche,” naa acaauru rai Jesosone jana jetao, nesoonetiin cojoelatiin jetao, “Chaneeina ne caa cacha, nere tonoraain nesuruha cujuana aina fichafichanaane coina,” naain jetao nejesinajeein ita caje bajaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nirijieein cuujeein jetaote, tabiicha nemuri jera jaohin, najauriaa cuure Calileea jeraniha nenaa Jerasau batane que. ");
INSERT INTO uraNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Inaen ecu turuhin najauriaain, atane choae iniha cuha Jesosone jana jetaote, nii nese caje cuhin que tacaa cue suujue cuhane coitucuchuhi siricha cacha. Nii cacha jetaote, nii chaabana cajione jiaain, niheichu loreri asae nihanatiin ichoaelanaala atane bana ichoaecha ichoae. ");
INSERT INTO uraNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aca jetaote, Jesoso coaariin nacatiha auhaquiin semojoaain tacaain jetao; “Coa caniha nenoaain carerojoecaara, acaihaniji nenaa Cana Coaunera Calaohi Jesoso,” nae jetao Jesoso rai, ");
INSERT INTO uraNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","caje mituha, nii suujua cuhane neein aasaera coitucuchuhi coina aitoha Jesosone jaun. Nitohanihane jaun jetaote, araai saain cadena que caohatiin biji aina tijia ichohacuruhane nihanatiin, rai molohin cacha nenajanihu amaauruha nii coitucuchuhicurune, ecu nii cacha areroo ne. ");
INSERT INTO uraNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nitohaneein rai irihane jana jetaote: “Tonaa ichurujuata,” naain caje curuaa bajaa Jesosone jana jetao, “Lejioon niha canu curuaara,” nae jetao nii cacha, jataain arajiin suujua cuhane neeuruha coitucuchuhicurune jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nii arajiin suujua cuhane nenacaauru jetaote, usi jana acaauru letoaa Jesosone coataa jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","33","ichatane ucuunno que arajiin lenoniha neeuruha coosichurune jaun jetao, nii coosichuru suujueniha enooruhane coina Jesoso caje bajaaure. Nii jaun jetaote, nii jereein caje bajaauruhane rijijieein jeriha Jesosone jaun jetao, nii cacha caje mituhacoaain nii coosichuru suujueniha enooruhane jaun jetao, nemuri cuhane nichorohin acauhanau naluhin ohacoaaure nii coosichuru. ");
INSERT INTO uraNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nii coaraain jetaote, satiin jelai caje sorohin, nenaanajaaunru, neseeuru, naaonjoaihunri naineein biha cuure nii coosi beraihurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nitohaneein beeuruhane jaun, cuhin coaraa cuuruha cachaaurune jana jetaote, Jesoso tijia asae lauhaca coujurihu cacha neein necoreeteein nii suujua caje coitucuchuhichuru mitunaja cachane jaun jetao, coaraain coasichure nii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nii jana, nii cacha caje mituuruha coitucuchuhichurune jana coaraauru jetaote, esinae rauhijiriin nii nerautaane rijijieein beeure leeochaauru cachaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nitohaneein coaraain jetaote, satiin nii Jerasa batane que nenacaauru cachaauru jetao, jelai caje amuha Jesosone jerecure, jataain coasichuruhane jaun. Nii jaun jetaote, bote cuhane fauhin, jelai caje amuha Jesosone jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","aina cunaa jere nii coitucuchuhichuru mitunaja cacha. Ne jetaote, aina cuhane jerelanaala: ");
INSERT INTO uraNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Jiaohine. Chajaaincha jelaiha chenenajaun cauhin, ii rautaain niha Cana Coaunerane beebejenihun,” nae jetao rai Jesoso. Nii jaun jetaote, ecu nedaain, satiin nenaanajaaunru naineein cuhecujueein jetao, rautaain niha Jesosone beebejeein amuhemujuen nii cacha. ");
INSERT INTO uraNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nitohanihane baiha, jelaiha nemuri jerau cauha cuuruhane jana jetaote, jataain coroajeein Jesoso raaure, turuhane cohajeeuruhane jaun, satiin cachaaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nii jana jetaote, turuha uhe leinjiin cacha- sinacoca curuaanaa neein nenaa Jaironeein niicha curuaateeuri. Nii cacha jetaote, Jesoso tijia asae neseeoriaain jetao conujueein cotijiae, rai loreri asae turuha cuhane coina, ");
INSERT INTO uraNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","jataain ohane rai niha leinjiin rai cacunu- lechoonca coroata jaanacajine jaun. Nii jaun cuha Jesosone jana jetaote, jataain arajiin sacuuruha cachaaurune jaun, sururucure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nii arajiin cunacaauru jana jetaote cue leinjiin ene- lechoonca coroata jaanacaain nirijieein ichana jaohajeein cunaiteein nenaa. Nii jetaote, jitariin niicha sirii coriqui jaohin nocoicharate niqui. Nejetaote, rautasihurene nii chuni coichaeraauru. ");
INSERT INTO uraNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nii ene jetaote, Jesoso caaijie cuhin, rohan nichuuntaain rai cajione auha dadae. Nii Jesoso cajione auha dadaane rijieeoritiin jetaote, inae nesurue rai ichana. ");
INSERT INTO uraNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nitohaneein dadaane jana jetaote: “Chatoon canu dadae,” naain bajaa Jesosone jana, satiin dadaauruhane suujueeuruhane jaun jetaote, “Cacha relaera jataain araaicha cachane jaunte, ii sururucure jerane,” naa rai Fedorone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","“Aihei bajiaa. Chunucohate jerihane canu dadae. Cacaje mituha cacha rautacaaunne jaan cajene coitucuunra,” naain jetao bajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Niritoha Jesosone jaun, nesuujuenaa nainenihane jaun jetaote, rijijijianeein Jesoso acatiha neseeorihaain: “Naaonjoaain cunaitichaaunne jaunne, nii caje nerautasinihanune jaun, ii dadaaunra. Nii ii dadaanune rijieeoritiine inae nerautaaun canu cunai cajera,” naain satiin aonajera urichoo jitariin biha nii enene jana jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","“Aihachuhisi. Jataain ii rautaanune esenetaaine jaunte, ii cunai caje nerautaaicha ene. Chajaain chaque tonajelanaala chenenajaun caunihunra,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nitohaneein jaiti ereerejiha Jesosone jana jetaote, turuhin jetao: “Coa nenacaaeneein nii cacha relaera reroecaa. Inae oha ii cacunura,” naain jetao biha uhe letoaauruhane jaun leinjiin cacha, nii sinacoca curuaanaa Jairo rai. ");
INSERT INTO uraNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Niritoha nii cachane aonajeein jetaote, “Coa tonajian. Raujiaaincha quesenetaaute nacoaauneein ichanamiin oo caje ii cacunura,” nae jetao Jairo rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Niritiin cuhin jetaote, nii Jairo loreri asaae turuhin, Fedoro, Saantiaao, Joaan, chaen, nii ene fojiaraauru, naaonjoaihunriicha enoae jiniichaain nii loreri asae. ");
INSERT INTO uraNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nitohaneein inae loreri asae enooruhane jana jetaote, jataain satiin coinaderaain nii ene coisichuruha nii loreri asaae nenacaaurune jaun: “Coa chanaache. Coatiha ohane jaun aihei caa ranuna. Sinihane jaunte aicha,” naa acaauru rai Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","satiin esenetaelanaala coenacure- nii ecu neein coarajeeurera cachaauru, esinaen rauhijiriin oha nii ranunane coaracuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nii jana jetaote, biji que nii ranuna onaa mucuhin tonijiaain jetao: “Ranuna, chajaain nimichuura,” naa Jesosone rijieeoritiin nimichuhin jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","nacoaauneein raurononeein oo caje ichanae nii ranuna. Nitohaneein ichateein jetaote, corohateeuruhane coina aite Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nii jaun jetaote, jataain cojoelatooruha rai fojiaraaurune jana jetao: “Jiaonriha caa catoaneein ichateein nihanune beeiche chuni rainera,” naain jetao suujuatenajaen Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jelai lechoonca coroatajai aina nerelanacaauru taojiaain, acaauru aina neein cocoainanajaain jetaote, letoanajae Jesoso, cacha suujua cuhane nenacaauru itolere coitucuchuhichuru sitaain, cunaitenacaaurune maajeein rautaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nitohaneein jetaote, Cana Coaunera Cojoanonaa beein, cunaitenacaaurune maajeein rautaauruhane coina acaauru letoae. ");
INSERT INTO uraNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nitohaneein letohanajaain jetaote: “Coa inara biji achune, inara atora, inara achano, inara coriqui, necoreeteeichene jaanu que inara cajione, naaonjoainuri amaain cuhache. ");
INSERT INTO uraNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chunijihun loreri asae turuhichene ecu neeuche jelai caje amuhichene reentiaain. ");
INSERT INTO uraNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jana chunijihun nese que turuhichene jana, inara ranaa jerelaanaala inara aohana jerecurenihane, jelai caje amuuche. Inara tijia batane faofaohin riariaain ratiriinte, ‘Coaraain cau neein nainacuche,’ naain ichaquichene coitucuurumiin caje,” naain jetao letoanajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nii jaun jetaote, nii letoanajaane rijijieein cuhin, neseeuru naineein cuhecujueein jetao, ichoteratenajaane jaa erenaa rauhi raotono beebejeein jetao, cunaitenacaaurune maajeein rautaacoaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nitohaneein itolere ichaechajeein niha Jesosone coitucuhin jetaote, que suujua auhacaain nererojoecae Jorioocuru curuaanaa Erodesi. Tabaauru, “Joaan jete oo caje ichanaain ai,” naauruhane jana, ");
INSERT INTO uraNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","leeochaauru, “Profeta Irihasi jiete, oo caje ichanae,” naaure. Jana tabaauru jetaote, “Cana Coaunera Ere bera inoaensi tabaauru jete, oo caje ichanaain ai,” naaure. ");
INSERT INTO uraNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ne jetaote, niritocuruhane coitucuhin jetao: “Caraajenihanena nii Joaan uluno moloheratihanune jana moloorelura. Chaaquena jana, nii itolere ichaa beein ereeure,” nae jetao Erodesi. Nii jaun jetaote, jataain Jesoso coaana jere Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Inae nii letoanajaa Jesosone caje turuhin, jitariin acaauruhacha ichai beeuruha nii cocoainaain niicha letoaauri afosotoorune jana jetaote, jelai cachaauru caje acaauru amaain, leinjiin nese Betesaaidau amanajae niqui Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nejetaote, inae cuhane coitucuuriin, sacuhin, rene turuha cuuruha cachaaurune jana jetao, raotojoeein acaauru raain, Cana Coaunera Cojoanonaa que acaauru rai ereerejeein, cunaitenacaaurune maajeein rautae. ");
INSERT INTO uraNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nii jana inae sohane jaun jetaote, Jesoso rohan nichuuntaain: “Chajaain caa cachaauru rai aitoote, taa ichuunucohacuru nenacaauru neseeuru cuhin, nesurunajaanu aina lenone ariha cuurumiincha. Coatiha nihei cau cacha caje lenone coreteein acaauru coroaatenaa jaanuta,” naauruha nii lechoonca coroatajai aina nerelanacaaurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","“Niriimiin. Atiin inara, acaauru coroaateeuche,” naa acaauru rai Jesosone jana jetaote: “Saoquijieeinchate neeje faan, chaen coroatajaain ate naajeeinchara. Coretiha cuhacaanune banaachate nenaa nainere lenone, satiin caa cachaauru raicha,” naaure jetao Jesoso rai, ");
INSERT INTO uraNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","itolereneein saoqui oharaancaain acaauru aina neeuruha cachaaurune jaun. Ne jetaote aina nerelanacaauru rai jetao: “Saoquichooncaa nanaain ita rohan teein acaauru lauriaauchera,” naa acaauru rai Jesosone jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","nii aitohane rijijieein, ita rohan teein acaauru lauriaacoaaure nii aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Inae satiin nelauriaacoaauruhane jana jetaote, nii saoquii faan aina coroatajai ate mucuhin, coreniha dede coarajeein Cana Coaunera coroaecane baiha jetao, nii faan aina ate beeunebeeuneein aina nerelanacaauru rai jetao te Jesoso, jitariin cachaauru rai chaluuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nitohaneein jetaote, inaeneeuruhane jaaun tiaaojoaain lenonecuruha satiin cachaaurune natiin jetao, lechoonca coroata omariin, omari nemoaaure caute que. ");
INSERT INTO uraNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nii baiha jetaote, jelai aina nerelanacaauru aina cuhin Cana Coaunera bajaane jaun jetao: “Tonacuruha canu que cachaauru. Chanichaaunchata,” naain acaauru caje bajaa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“Tabaaurute, ‘Joaan Baotisita jete, oo caje ichanaain ai,’ naaurera. Jana tabaaurute, ‘Cana Coaunera Ere bera inoaensi Irihasite ai,’ naaure. Jana tabaaurute, ‘Cana Coaunera Ere bera inoaensi caje leinjiin jete, oo caje ichanaain ai,’ naaure,” naain beeuruhane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Tonaquiche jana inara canu que. Cha nichaaun,” naain acaauru caje bajaane jana jetaote: “Iite, Cana Coauneraacha letoai Mesihasineeicha,” naain jetao tonorae Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ne jetaote, niritocuruha raine jana, nii acaneein nihane beeuruha chuni raine coataa, caohate Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Niritiin jetaote: “Nii inaraacha cohajei Cachaneein nejanohanune cairichaeriinte, caque jaolecoha cuurureein Jorioocuru bichauhenaauru aina saseredotecuru curuaanaacuru, chaen Cana Coaunera naitoonjoan que cacha relaaureraauru, naaonjoainuri. Acaaurute catinaa cuurureein niqui, nena nichata janohane cuhane ichanaa cureeunnicha,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nii baiha jetaote, nii satiin ecu aina nenacaauru rai jetao: “Chunucoha canuhacha relaineein canu ere tonoraeraneein nenaa jerihane, itolere suujua letono ichana jerihane jianeein, coroso que canu teein canu cairichaaururichaaine rijijieein necairichanaa abaataain caitoonjoan tonoraain, jerichaaunne rijijieein neeine. ");
INSERT INTO uraNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nitohanihane jaunte, cacoreniha nichao itajera, nichotiha cureein. Jana suujua letonohacha ichajeein, itolere bana rai caohachanuhacha coacuhin neite nitajereein. ");
INSERT INTO uraNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Chaaquena nelatere caa chauratane que neein, itolere rai nelateeicha que coacuhin rai nichao itajiha cachane. ");
INSERT INTO uraNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chunucoha, canu que coejeein caitoonjoa quene maajeein coejera quene necoejereeunni canuhetonai, canu- inaraacha cohajei Cachaneein nejanohanune, itolere ichana nainichaaunne coaarateein, Canu Inaca necaohacha que necaohachaain rai letonocuru anjeraauru aina turuha uhanune bana. ");
INSERT INTO uraNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Esinae rauhijiriin satiin cau nenacaauru tabaauru cachaauru oorurinaain, Cana Coaunera Cojoanonaa coaracuruhane reeintiaain,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nii cachaauru rai irihane baiha, fosa janoneein catiaain, ichatane ucuuno que cuhin Cana Coaunera bajaa cuha Jesosone jana jetaote, corihaniha cuure Fedoro, Saantiaao, Joaan, naaonjoaihuri. ");
INSERT INTO uraNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Inae ecu turuhin Cana Coaunera bajaane jana, ecu neein coarajeeuruhane jana jetaote, itolereneein nejelauneein nerotoha nomerine jana jetao, rai cajione netonai jataain somajaain jiquihaquiin nerotohane jana, ");
INSERT INTO uraNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ecu aina ococohin aina ereeure coroatajai cachaauru Moisesa, Irihasi, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nitohaneein jetaote, jataain cono caohacha que conaeraain neein jetao, Jerosaleeun cairichanojoineein oha curichaain Jesosone que jetao ereeure. ");
INSERT INTO uraNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nii jana jataain siniitooruhane sainejeein jetaote, nirijieein ichaojoeein jetao, cono caohacha cataaun neein coroatajai cacha aina iriha Jesosone jana, coaraje rai corihacuru aina Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Inae Jesoso rohan neeuru caje amuuruha nii coroatajai cachaaurune jana jetaote: “Cacha relaera, jataainte caohate cau nihacachene. Coanete nichatajaain lohanari jaacache, leinjiin ii rai, leinjiin Moisesa rai, leinjiin Irihasi rai, naaonjoaain,” nae jetao Fedoro. “Naaonjoaane coinate catohaneein coaarate Cana Coaunera,” naain coitucuenihane jaun nirite Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Niritiin ereerejihane jana, acaauru conaacotaa dede sacarine jana jetaote, jataain nesoonetooruhane jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","nii dede sacari jana toniin jetao: “Caate jataain jereein canuhacha cocoainaain quiicha letoai Canu Calaohinera. Nere tonoraain neeuchera,” naain jetao toni erenaa. ");
INSERT INTO uraNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Niritiin toniha erenaane aonajeeuruhane baiha, Jesoso coaracuruhane jana jetaote, inae jelai ecu ne. Ne jetaote, nii bana nii chuni rai nitohaniha Jesosone belanaala inauheneecha suujua cuhane coarajeein nii chuni rai beeurene. ");
INSERT INTO uraNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nii cojoanoo nii ichatane ucuuno neeuru caje jelaiha fauha cuuruhane jana jetaote, Jesoso que tacaa cuure arajiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nii arajiin que tacaa cunacaauru cachaauru jana toniin jetaote: “Cacha relaera, atiin nohane caa acaihanijin quiicha sirii canu calaohi coaraau. ");
INSERT INTO uraNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Suujua cuhane coitucuchuhi sirihane jaunte, baasoneein tihane, auhaquiin tocojoaain tacaane, nujuaae caje lajane mitae. Jataainte, baasoneein jaberoco teein jianena jerene. ");
INSERT INTO uraNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nii jaaunne niqui ii aina nerelanacaauru rai aitoon, caje nii coitucuchuhi sitaauruhane coina. Nete ichana nainesihurene,” naa tonijiaain ehequiin, nii leinjiin cachane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","“Jataainachura cha esenetaeneeichete nitaje rai nenacaauru cachaauru. Inaaonjoan saneeina inara aina neein inara abaantareeun. Chajaain cajiha nii ii calaohi uhaaura,” naa Jesosone jaun, ");
INSERT INTO uraNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","rohan nichuuntaa nii cunaitenaa canaanaine jana jetaote, atane ichoae tacaain siheite nii suujua cuhane nenaa coitucuchuhi. Nii jaun jetaote, nii suujua cuhane nenaa coitucuchuhi suruaain jetao, nii canaanai rautaain, rai inaca rai te Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Satiin nii coaraain jetaote, itolere que nelateein, itolere ichana nainiha Cana Coaunerane coaraain cojoelatoore. Nitohaneein cojoaelanaacojoai ichaain, acaauru notaaca Jesosone cojoaelatooruha satiin cachaaurune tonohanau jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Caohachaain caa inara rai aitocoaaunne aonacuche. Coa baitichache. Canu acaihaniji inaraacha cohajei Cachaneein nejanohanaa nichaaunne, cocoainanacaihuru bijihu tenojoiniha cureeunicha,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ne jetaote, acaauru que coitucuerateniha Cana Coaunerane jaun, nii acaauru rai aitohane coitucuurenihane sainejeein, acaauru rai biha Jesosone coina caje bajanaa nainecurene, bajaauruhane que nocoatocuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nii jana jetaote: “Charijina, caa cana jana, jataain leeochaauru amurijiriin nelatineein nere,” naauruha nejesinajeein ita rai aina nerelanacaaurune ");
INSERT INTO uraNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","aonajeein jetao, leinjiin canaanai mucuhin rohan teein jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Canu coreniha, caa canaanai raerate, canu raane rijijieein aicheein. Jerichanejeein canu raain neitechu, caletoaera Ofa raa aicheein. Nitohanihane jaun, cau inara jana nelatihei rijijieein inaraacha coaraite, jataain nelatineein ne,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nii jana jetaote: “Cacha relaera, ii letononeein nenaa rijijieein coitucuchuhi que suujuequiin nenacaauru rautaain niha leinjiinne janane eruhin nii caohatihacaanu, cana aina nenaaneein ainihane jaun,” naa Joaanne jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Jiaonriha nitohanai ichara caohateein neeichene. Canaacha ichai ichaain nenaate cana lauri rijijieein nenacaauru ne,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Inae jelaiha dedeu cuhane catainajeein jetaote, Jerosaleeun necairichanaa coaraane rai nihane saijieein, atiin nelararajiaain, nii Jerosaleeun turuhane coina ucuae cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nitohaneein cuhin jetaote, najiniha nere beraanuuru letoaelu, turuhane jaanu ariha cuuruha leinjiin nese Samariaune coina. ");
INSERT INTO uraNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ne jetaote, ecu ranaa jerecurenelu Samaria cocoaichacuru, rauhijiriin Jerosaleeun cuhane coitucuuruha raotojoeeinne jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nitohaneein, acaauru ranaa jerecurenihane jaun jetaote: “Curuaanaa, jereeune acaauru ichoae usi letoaacaanute, satiin mocohin nitajeeuruhine,” naaure jetao Joaan aina Saantiaao. ");
INSERT INTO uraNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ne jetaote, acaauru rene nauriteriin jetao: “Caohachaai nitohanai ichaain nihacachene,” naain jetao, acaauru cotaicha rijitiin caohate Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Niritohane baiha jetaote, leeocha neseu jetao cuure. ");
INSERT INTO uraNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Inae bero cuhane cuujeeuruhane jana jetaote: “Curuaanaa, cuhine jaaun niha natiine, itolere bana ii aina nenaa jereeunra,” naa Jesoso rai leinjiin cachane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","“Aonaaun, arolarihuru niha natiinte, sininajaanu siriin naaonjoaaurera. Jerichanejeeintechu, sininajaanu siriin ne tajaaecurura. Nii jana canu inaraacha cohajei- Cachaneein nejanohanune, coatiha nihei chunijihun neloraain nesurucuaaunne jaanuta,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Niritiin jetaote, leeocha rai: “Chajaau canihara,” naa Jesosone jana jetao: “Curuaanaa, jauriaanejeein canu cohacune, oha canu inacane reentihaain aina nenicha,” naane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","“Niriimiin, caa chabana nitajenaachara quiicha tei ichaonaa ranaa jeriheichuru, ecu nejesinajeein ita coaracurumiincha. Ii caniha uute, Cana Coaunera Cojoanonaa beebejeeicha,” naa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","leeocha netonai: “Curuaanaa, ii ainane unaa jereeun canuhetonai. Jauriaanejeein canu cohacune, canu nenajaun nenacaauru rai necoenicha,” naane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","“Nete, Cana Coaunera Cojoanonaa que nenaa jeriha cachane, itolere bana niicha ichana jerei jianihane caohachae,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nitohanihane baiha jetaote, caaunsi choonca coroatajaain jetao aina nerelacaauru janijiin jetao, coroatajaanana coroatajaananaain najiniha letoanajae Cana Curuaanaa Jesocurisito, nii turuha curichaainne jaaun neseeuru naineein cuuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nitohaneein letoanajaain jetaote: “Esinae rauhijiriin arajiinte neeure Cana Coaunera coitucunaa jereraauru cachaaurura. Nete jataain coroatajaaecure acaauru relaeranuurura. Aihane jaun Cana Coaunera bajaauchete neeine acaauru relaeranuurura. ");
INSERT INTO uraNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nii nitohanihane jaunne ena inara letoaaunra. Nete jataain alalacaraain nii curiquicheein, taebiaen mululune jana situha cuha irine rijijieein curiquicheeinne jaunra. ");
INSERT INTO uraNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jiaonriha inara coriqui, inara atora, inara safato, naaonjoaihunri amaain cuhichenera. Coa chunijiun inacuhin, chuni rai caeneenejeein ereein cuhache. ");
INSERT INTO uraNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Chaen chunijiun loreri asae turuhichene, ‘Raotojoeein neeuche saain caa loreri asae neinequichenera,’ naauche inara turuneeicha. ");
INSERT INTO uraNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nii jana nii loreri asae niha caohachaain nenaa jereraaurunete nerausiaejeein neeurureeincha. Jana caohachaain raotojoeein nenaa jerecurenihane, coatiha nerausiaecururiaainta. ");
INSERT INTO uraNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chaen chunijiun nese que turuhichene, leinjiin loreri asaecha neein, lenonecuruhane jaan que lenoneein, acau cohin, naaonjoaaunchera. Niha rauhi, coreteraauruha amihanenacaaurune jaanura. Jiaonriha lorerichuru naineein cajihaneein amuhemuhequichenera. ");
INSERT INTO uraNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chaen chunijiun nese que turuhichene jaaun, caohachaain inara raain inara coroateeuruhane jaan que lenonecuchera. ");
INSERT INTO uraNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chaen ecu neeuruha cunaitenacaaurune, acaauru rautaain, ‘Inaen ichuunnijiha, inara caje Cana Coaunera Cojoanonaara,’ naain acaauru rai beeuchera. ");
INSERT INTO uraNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Leinjiin neseu turuhichene jana, ecu inara coaana jerecurenihane: ");
INSERT INTO uraNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Cau inara neseu turuhacaanune jana canacaanu tijia que nitiririchana utoonena riariaain ratirihacaanu, “Coaraain cau neein nainaacuche,” naain ichacaaunne que nainaquichene coina. Nete laen, inae ichuunnejeeoriha inara caje Cana Coaunera Cojoanonaane saijieein que jaolecohichene coitucuhichene caohachaera,’ naain acaauru rai beein, jelai caje amuuchera. ");
INSERT INTO uraNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nii inara coiinteraauru cachaaurute, neecha aansaineein ichaonacaauru Sodoma cocoaichacuru amurijiriin jataain caseteco tabai coaraa cuurureeincha,” naain nii rai niicha letoanojoinunri rai be Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Niritiin jetaote: “Cairichaaojoaaiche, Corasiin, Betesaaida, naaonjoaain nese cocoaichacuru, jataain necairichanaa coaariquicheeinne jaun. Bana inara rai cojoelanaacojoai ichacaaunne rijijieein, Tiro, Sidoon, naaonjoaihun cana lauri Isaraelitanelanaala ichaonacaauru rai cojoelanaacojoai ichacaaunne jana niha nete, acaauru ichoaichaniha inae Cana Coaunera que suujua acatecuruhane coaarateein, baaso ichajeein ichaaoruhane jianeein neeuruhane coujunacane que inaderaain costaro siri caje nenaa cajione jiaain, ajane que nerujuaain neeurure. ");
INSERT INTO uraNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nitohaneeichene jaunte, inae nii cojoanonaa que turuhane bana, Tiro, Sidoon, naaonjoaihun cana lauri Isaraelitanelanaala ichaonacaauru amurijiriin, caseteco tabai coaraa curiquicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jana inara Caferenaaon cocoaichaneeinchene, inacojoeein dedeeu cuha nocoetona jereein coaauquiche. Inarate, usi tabai cataaun jaonojoineein nitajiha curiquicheein,” naain bihane baiha jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Nitohanihane jaun, caohachaain inara raerate, jerichanejeein caohachaain canu netonoai raa aicheein. Jana, inara que jaolequiin, inara ranaa jeriheichurute, jerichanejeein canu que jaolequiin canu ranaa jerenihane jaun aihurureein. Nii rijijieein techu, canu que jaolequiin, canu ranaa jeriheichuru, jerichanejeein caletoaera Cana Coaunera que jaolecoha aihurureein,” nae rai nii letonocuru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nitohaneein letoanajaane jaaun cuhin jetaote, caje jelaiha rachoojoeein turuhin jetao: “Curuaanaa, ii letononeein nihacaanune jaunte irihacaanune, coitucuchuhichuru nihanatiin canacaanu ere tonoraain neeure,” naauruha nii caaunsi choonca coroatajai letonocurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","“Aihachuhisi. Jiacane amuneein dede caje naluha uha Moconajaerane janane coarajeeun. ");
INSERT INTO uraNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Canune, nitohaneein itolere que nelateein laraajiin cuhin, acanocuru, canaaunru, naaonjoaihunri ichoae situhin, itolere coitucuchuhicuru amuritohiche, nii necairichanaa coaraelaanaalane coina inara letoaaun. ");
INSERT INTO uraNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nete, nii nitohaneein inara ere tonoraain neeuruha coitucuchuhichurune nihanatiin que rachoojoeein nenaa naineneeiche. Inae laenanohineein niha Cana Coaunera Quiricha cuhane dedeeu inara curuaacuruneecha quete laen nainequiche rachoojoeeichenera,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nitohaneein turuhin itolere ichacuruhane beeuruha nii rai letonocurune jaun jetaote, rachoojoeein Cana Coaunera Suujue que suujuequiin jetao: “Ii, dede, chauratane, naaonjoaain Coaunera neein, itolere Curuaanaa neein neeine coroaecaaunra Ofa. Iite, nii itolere coitucutoha nocoetonacaauru que coitucueratelanaala, nii cha que nelatihei rijijieein nenacaauru que nii coitucueraelanaala nenaa coitucuerateeicha. Aihara Ofa. Nitohaneein jereeine jaunte ichaaicha,” naa Cana Coaunera raine baiha jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ofate caque itolere coitucuerateein ne, coitucuhin nihanune coina. Nihei chuni canu coitucunaa nainera, cacoitucuerateniha Ofane. Nii rijijieeinchu canu, rai Calaohineein, que coitucueratenihanune, nihei chuni Ofa coitucuera. Canu, rai Calaohineein coitucueratenaa jerichaunne jaanruhachate Ofa coitucuurureein,” nae jetao rachoojoeein Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nii baiha jetaote, jelai teein aina nerelanacaauru rai jetao: “Nerausiajeeinte neeiche, caa ena inaraacha coarai coaraain neeichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Arajii profetacuru, chaen reycuru, naaonjoaihunru inoaesihurute niqui, caa ena inaraacha coarai coaana jereein, caa inaraacha aonai aohana jerecurelu. Nete, nii coaraain, aonaain, naaonjaaunrenelu,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Niritoha Jesosone jana jetaote, rene turuhin jetao, “Tohanrihanicha,” naain nechu jataain coujuha jetao: “Cacha relaera, cha ichareeun chariji bana nitajenaachara ichaonaa que ichaonaa nainichaaunne coina,” naa rai leinjiin Moisesa naitoonjoan rauhi que cacha relaerane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","“Tonaainjia laenanohineein ne Moisesa aitoonjoan rauhi cuhane ereretaain coaraaine jana,” naa rai Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","“ ‘Jataain ishuujua, ii suujue, ii coichana, naaonjoain aina cutaain, ii Curuaanaa ii Coaunera que ii suujua acateein, aca jerihane rijijieein coitucuhin naitoonjoan ichaain neeu. Chaen ijiabereeo belaain coaraain neeine rijijieein, chamute cacha belaain neeu,’ naainte ne nii rauhi cuhane,” naain jetao tonorae nii Moisesa naitoonjoan rauhi que cacha relaera. ");
INSERT INTO uraNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nii jaun jetaote: “Jataain caohatiinte aitohi. Nitohaneein neeinete, ichaonaa chariji bana nitajenaachara que niha curiquiincha,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nii jaun jetaote, jaiti jitaain nii niicha coitucunaa jerei beniha raine que nainaa Jesosone coina jetao: “Charijina camute cacha neein belaain ichaoreeun,” naa Jesoso raine jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","“Aonaaun. Coaraaunachuhinti, leinjiin cacha jetao, Jerosaleen caje Jericoo cuhane jana, bero cuhane eruhin, enuha que faofoaain sohin- rai cajione ruluhin- jitariin niicha siriine maajeein ruluhin- ateinanee lalajeein ratiriin amuuruha necha aansaineein ichaonacaauru cachaaurune. ");
INSERT INTO uraNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nii jana jetao, nii jeelai bero cuhane cuujiha leinjiin Isaraelitanichaachene lauri caje nenaa saseredotene jana, najiniha niha nii cachane coaariin, comarohin rauhijiriicha situhin amue. ");
INSERT INTO uraNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nii jana jetao coaiteen caaijie cuujiha, leeocha Isaraelitanichaachene lauri caje nenaa Lebitane jaun, acaaentonai coaariin, inauheneeicha coarajeein comarohin rauhijiriicha situhin amue. ");
INSERT INTO uraNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nii jana jetao, acaauru caaijie cuujiha leinjiin cana lauri Isaraelitanelanaala nenaa inara jaole Samaria cocoaichane jaun jetao, coaariin, cairichaaojoaain coaraane jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","rene nichuuntaain erene aina bino caje ichanohineein nenaa coi que culejeein jetao, nii nocoasaja coichaain, cajione que conajaain jetao rai cabario ichoae lauriaain, coreteein turunaanaja leinjiin loreri asaae amaain ecu teein jetao berai. ");
INSERT INTO uraNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nii cojoanoon jetaote, rai coriqui rocohin jetao nii nenaanaja erora corete jetao nii Samaria cocoaicha. Nitohaneein coreteein jetaote, ‘Atiin canu rai caa cacha beraain coichaau. Caa cacha coreniha ii coriqui jaohinene ii rai cainareeunni caaujiataain,’ nae jetao nii cacha, nii nenaanaja erora rai. ");
INSERT INTO uraNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nitohanihane jaun, chariji jana nii nichatajaihuri caje nii necha aansaineein ichaonacaauru cachaauru sonojoi cacha belaain coarae, rai jaberoco belaihane rijijieein,” naa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Nii cairichaaojoaain coaraain belaain coichaera,” naa nii Moisesa aitoonjoan que cacha relaerane jaun jetaote: “Inae laen coitucuhi. Nitohaneein iitonai ichaau,” nae jetao, rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nii baiha jetaote, jelai caje amuhin leinjiin neseu turuhane jana jetao, rai loreri asaae rae leinjiin ene Marata. ");
INSERT INTO uraNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nii Marata nejera Mariha jetaote, ecu turuhin ereerejiha Jesosone jaun jetao aonaane coina rai tijia asaae nelauriariin lauheque. ");
INSERT INTO uraNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nii jana jetaote jelai niicha ichanenu aina ratiriin aihane jaun jetao, Jesoso rohan nichuuntaain jetao: “Curuaanaa, tana itolereneein camijianeeon aina jelai caratiriin aiha caa canejerane coaraainete rai aiteneei canu coroatajaniha uhane coina.” naa Maratane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","“Marata, aonaaun. Jataain niha iicha ichanenune jaunna jataaain nererojoecaai. ");
INSERT INTO uraNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nete jataain leinjiincha ne cacha rai jataain nelatei. Caa Marihate nii jataain cacha rai nelateein nei janijiin rae. Nii jaun nerinaain chuni caje ruluera,” naain jetao tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jelai cuhin Cana Coaunera bajaa cuha Jesosone jana jetaote, inae nainaane jana jetao: “Curuaanaa, aina nerelanacaauru relaalu Joaanne rijijieein canacaanu relaau Cana Coaunera bajanaa quera,” naauruha aina nerelanacaaurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","“Saan ai. Cana Coaunera bajaaichene: ‘Cana Coaunera, ii acaihaniji Cana Coauneraneein neeine coitucuhin neeurumiin satiin cachaauru. Nihei chuni ii baiha ii rijijieein nei. Dedeeu iicha jerei ichacuruhane rijijieein, cau chauratane que netonai ichacurumiin satiin chauratane que nenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Canacaanu rai lenone teeute canacaanu rai lanaeneeine lenone. ");
INSERT INTO uraNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Baaso ichaechajeein nihacaanune nihanatiin canacaanu que ii suujua acateeu, canacaanu rai baaso ichaain nenacaauru que canacaanu suujua acateein nihacaanune rijijieein. Jiaonriha osa que nesaruhin nihacaanune nainatejeein neeine,’ naain Cana Coaunera bajaauche bajaaichenera,” naain jetao acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Niritiin jetaote: “Coaracuchenachuhinti inara tabaauru niha rai belaichane jana, janotiin dede cataaun rai loreri asae turuhin: ‘Quiicha belaai, taa niha ii lenone cautene. ");
INSERT INTO uraNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ena canu loreri asae turuha jataain quiicha belaaine jaunne, que coroaatihanune coina aitoon, neniha rai canuhacha teeninune jaun. Ii raine jeelai que corereeunni,’ naane janate nainere: ");
INSERT INTO uraNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Coa carerojoecaa. Inae canu bereecuru aina nesurucuaaunne jaun nimichuhin tenaa nainihaaun,’ naainte nesurunajaun neein tonorana nainere nii belaicha. ");
INSERT INTO uraNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Netechu nimichuhin tenaa jerenihane saijieein conujiha nii belaichane, atiin nimichuhin jitariin niicha latei tenaa nainere. ");
INSERT INTO uraNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nii rijijieeinte Cana Coaunera caje cha lateein bajaaichene, inara rai inaraacha latei tereein. Cha lateein ariin bajaera raite, cha teein ne Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Satiin cha lateein ariin bajaerate, niicha latei eruhin ne. Nitohaneeinte rohan nichuutaain cha bajaa cachane, rai cha teein naaonjoareein Cana Coaunera,” naain jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Coaracuchenachuhinti inara, inara caje ate bajaain niha inara calaohine jana, inara, inacaneein rai acano teriquiche. ");
INSERT INTO uraNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ainihane inara caje taje bajaane jana rai canau teriquiche. ");
INSERT INTO uraNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Coaracuchenachuhinti inara baasoneein ichaohichene natiin, caohacha nejesina teein neeiche inara bereecuru raine. Nii amurijiriin techu lateein caje bajaain neeichene, rai Suujue que suujuequiin neeichene coina, nii bajaera rai Suujue teein nereein dedeeu nenaa Cana Inaca Cana Coaunera,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nii baiha jetaote, suujua cuhane coitucuchuhi sirihane jaun, caaun eresilanaala niha leinjiin cachane jana jetao, caje sitaain rautae Jesoso. Inae caje mituhin amuha nii moconajaera letono coitucuchuhine jana, inae iriha nii eresilanaala nenaa cachane coaraain jetaote, jataain cojoaelatoore nii ecu neein coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ne jetaote tabaauru: “Coitucuchuhichuru curuaanaa Beelseboote caa cacha rai catohanai ichaane jaan tihane jaun, caa catohanai ichaera,” naaure jetao Jesoso coarajeein. ");
INSERT INTO uraNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jana tabaauru jetaote, esinae rauhijiriin aina niha Cana Coaunerane coaracuruhane coina nechu cojuha jetao, cojoelanaacojoai ichaane coina caje bajaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ne jetaote, nechu cojuha aitocuruhane coitucuha raotojoeeine jaun jetao: “Inarate caa coitucuchuhi ichanohineein cunaitenaa cacha rautaanune jaun, Moconajaera letononiha canu beeiche. Nete inara coitucuhichene rijijieein, satiin caa atane que nenacaauru ita que nejerateein neein ita sooruhanete, jiniiquiin ita ichao itajeeurureein. ");
INSERT INTO uraNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nii rijijieein techu, nii coaauquichene rijijieein, nejesinajeein ita que nejerateein neeuruha rai letonocuru ainane, ita ichao itajeeurureein Moconajaera aina rai letonocuru. Nitohanihane jiniiquiin nii cha que nelateein neeururihei. ‘Nii coitucuchuhichuru curuaanaa Beelseboo caletoaane aina, coitucuchuhi ichanohineein cunaitenaa caa cacha rautaa,’ canu beeichene jaunne caa inara rai aitoon. ");
INSERT INTO uraNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","20","Inara tabaauru, chunocoha cacha suujua caje coitucuchuhi sitanaa jerecuruhanete, ‘Cana Coauneraacha ichaneni ichaeraniha’ beriquiche. Jana laen canu, cacha suujua caje coitucuchuhi rocohanune jaunte, ‘Moconajaeraacha ichai ichaeraniha’ canu beeiche. ‘Nete laen, Moconajaera letono coitucuchuhi rocohanu cajene jaun, canu, Cana Coauneraacha ichai ichaeraneein, Moconajaeraacha ichai itajeraneein nihanune coaraquichene saijieein aitocoiche. ");
INSERT INTO uraNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nii rijijieein techu, jataain laraajiin nenaa cacha, rai biji achune aina rai loreri beraihane, satiin rai loreri asaae nenacaauru rai rucuhele rulunaa nainene caje chuni. ");
INSERT INTO uraNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nete laen, jataain amurijiriin jataain laraajiiin nenaa, turuhin caje nii rai rucuhele niicha berai ruluha uhane, enaacha caje nii biji achune ruluhin jitariin raine que nii rai rucuheleeuru rulureein,’ naain jetao Moconajaera amurijiriin laraajiin itolere ichana nainihane,” be Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Niritiin jetaote: “Nitohanihane jaun canuhacha ichai rautaelanaala coaarate, canu que nejeratenaa neein nihane jaun ai. Jana canu aina Cana Coaunera rai cachaauru ranaa jeriheite, moconajaera aina nitajeeuruha cachaaurune jerihane jaun ai,” nae jetao Jesoso ");
INSERT INTO uraNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Niritiin jetaote: “Nitohaneein leinjiin cacha caje mituhin amuha coitucuchuhinete, enohane jaanu ariirijie cajianeein joaereein amuhemujueein. Nii jana erusinihanete, ‘Jelaiha taolu mituhanune jaa rene cauha cuhanunete caohachae,’ nae. ");
INSERT INTO uraNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Niritiin nii mituhalune jaa cacha suujua cuhane turuhane, aiha leinjiin loreri coneraelanaala caohatiin lojoinojoineein rucuhenojoineeine rijijieein nii cacha suujua eruhane, ");
INSERT INTO uraNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","nacoaauneein jelaiha cauhin, caaunsineein amurijiriin jataain baasoneein nenacaauru coitucuchuhicuru cotijiaain amaain, nii cacha suujua cuhane enohin ichaaoruha nii coitucuchuhichurune, jauriaanejeein aihalune amuritoheriin jataain baasoneein ichoae nii cacha,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Niritiin jaiti acaauru rai ereerejiha Jesosone jana jetaote, nii cachaauru jana toniin jetao: “Nerausiaaeca ene ii janoaain efojiaralura,” naa rai leinjiin ene ehequiine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","“Aiha chuhisi niqui. Nete Cana Coaunera aitoonjoan aonaain tonoraain nenacaauru nii amuritoheriin nerausiaaecure,” naain jetao tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nitohaneein netaojiajeein, jataain arajiin turuuruha curuhacaain cachaaurune jaun jetaote, acaauru rai: “Caa Moconajaera cojoanonaa que nenacaauru cachaaurute, jataain necha aansaineein ichaooruhane jaun, acaauru rai cojoelanaacojoai ichacaaunne jerecure. Nete Isaraelita neeurenihane saijieein, dede caje cojoelanaacojoai coaracuruhane latelanaala, acaauru rai Cana Coauneraacha beratei biha Jonasine jana esenetaaurelu Ninibe cocoaichacuru. ");
INSERT INTO uraNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nii rijijieeinne canuhetonai inaraacha cohajei Cachaneein nejanohanaa nichaaunne, caa enene cojoanonaa que ichaonacaauru cachaauru rai Cana Coauneracha ichaneni beraneein neeun. ");
INSERT INTO uraNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nitohanihane jaunte, inae satiin cachaauru ichao coitucuhin rucuheca Cana Coaunerane Cojoanonaa que turuhane bana, nimichureein Egipto bujuau nenaa atane curuaanaa eneneein nenaa reina, caa enene neiniquichene coulurujiane coina. Acate coriaji atane caje uhin turuelu, niicha coitucui biha Salomoonne jana aonaane coina. Nitohanihalu natiinte, Salomoon amurijiriin neinichaaunne saijieein, canu ere aohana jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nii rijijieein techu, inae enene cojoanonaa que ichaonacaauru cachaauru ichao coitucuhin rucuheca Cana Coaunerane jaan Cojoanonaa que turuhane bana, inara colurujueeuruhane coina nimichua cuurureein Ninibe cocoaichacuru. Aiha nii Ninibe cocoaichacuru, inae caseteco coaracuruhane rai neeuru jana acaauru rai Jonasi que beratiha Cana Coaunerane jana, cojoaelanaacojoai coaracuruhane latelanaala esenetaain nichao coreeuruhalune jaun. Nete laen, Jonasi amurijiriin nei nichaaunne sainejeein canu esenetaeneeiche,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Niritoha acaauru raine baiha jetaote: “Charijieein teeinti, nene chuni cono mocohin bujuaihu tera. Niheichu rori asae nii cono telanaala ecuun nii cono mocohin te, satiin nii loreri asaae turunacaauru conohanau neeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nii rijijieein techu inara jaberoco cononeein ne inara nota. Aihane jaun, esinae rauhijiriin jataain caohachaain cha coaraain coitucuhin neeichenete, satiin jianacoon niha cureein inara suujua. Nete laen caohachaain cha coaraquichene nihanatiin que jaolequiin joaenreein chachaquichene, jataain nocohena tabai jana niha cureein inara suujua. ");
INSERT INTO uraNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aihane jaun, cha coaraain coitucuhin caohachaain nocohalajiin neeuche, nabana cha coaraquichene nihanatiin que jaolequiin neeichene, nocohenaneein nerotoha nii inara conaerane coataa. ");
INSERT INTO uraNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aihute itolere inaraacha coarai coitucuhin ichaquichene, nocohena coaraelanaala satiin jianaacoon neeine inara suujua, raafariin conohanau cha coaana rijijieein, esinae rauhijiriin satiin itolere coaraain neeichene,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Inae niritiin cachaauru rai ereerejihane nainaa Jesosone jana jetaote, rai loreri asae lenoniha cuhane coina jetao cotijiae leinjiin fariseeo. ");
INSERT INTO uraNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nii jaun cuhin, rai loreri asae turuhin nitohaniha acaauru ichaone saijieein biji culeje lanaanla rori ichoae nelauriaa Jesosone jaun jetaote, cojoaelate jetao nii cotihara fariseeo. ");
INSERT INTO uraNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nii jaun jetaote: “Inara fariseeo neeichenete jataain inara jaberoco culeena inaaiche niqui. Nete nii saijieein jataain banejelanaala calanaineein ne asijiauhin, naosateein, naaonjoaainchene coreniha inara suujua cuhanai. ");
INSERT INTO uraNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Asoneeojoaaichenaate. Tana nii jianacoon nenaa inara jaberoco coaunera inara jaberoco cuhane nenaa, inara suujua netonai coaaunaane coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aihana jaun inara suujua coaraain inaraacha ichaneni ichaain neeuchete nuculocohin neeine inara suujua aina inara jaberoco,” naain jetaote acaauru rai, ");
INSERT INTO uraNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Cairichaaojoaaiche fariseeocuru, cacha caohachaniha nocoetocoichene coaracuruha cachaaurune coina, biha inara rai rauhine rijijieein nii lechoonca turineein inaraacha taojiai inara temule caje le turii teeichene saijieein jeriha Cana Coaunerane rijijieein inara amute cachaauru belaain, nii chuni que jaolequelanaala satiin ita rijijieein cachaauru coaraain neneeichene jaun. Aihane jaun, nii cacha caohachaniha nocoetocoichene jianeein inara amute cacha belaain, nii choae tacaain aitoha inara rai rauhine rijijieein ichaaoche. ");
INSERT INTO uraNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Cairichaaojoaaiche fariseeocuru, esinae rauhijiriin jataain nelateein nenaa rijijieein sinacoca asaae rori caohacha janijiin nichoae nelauriaain, inara que suujua acateein, chunijiun inara eruuruhane inara rai ereein, naaonjoaaunruha cachaaurune jeriquichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Cairichaaojoaaiche. Charijieein teeinti atane bana shaquiin nichoae situhin amue cacha, asaaun niha calanaine coitucuelanaala. Nii rijijieeinte ne, inara suujue cuhane calani neosateeichene coreniha,” naa acaauru rai Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","“Cacha relaera, fariseeocuru que niritiin canacaanu quene maajeein ereeine jaunne, saneein rautaenihacaanu,” naa acaauru caje leinjiin Cana Coaunera aitoonjoan que cacha relaerane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","“Cairichaaojoaaiche inara netonai. Nitohaneein ichaohiche inarane que ainaan tocohaneein, ichaonaa anajiin teein, inara amute cachaauru cairichaaeriin neeichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Cairichaaojoaaiche, Cana Coaunera ere bera profetacuru sohin jaooruha inara foerateracurune coitucuhin, baaso ichacuruhane coitucuhichene saijieein inara netonai acaauru rijijieein neeichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nitohaneriquicheeine coitucuhinte: ‘Acaauru raine, profetacuru, afosotooru, naaonjoainuri letoareeunni. Nii janate, tabaauru sohin jaohin, tabaauru que nejerateein, acaauru que nererojoecaa curiquicheeincha,’ naain besilu Cana Coaunera, nitohaneeichene coitucuhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nii jaunte, cana rai chauratane coaaunaalu Cana Coaunerane caje coaauneein, nii inara foerateracuru aina nii inaraacha sohi inaraacha jaoorilu profetacuru coichana core coaaratiha cureein inara que Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nitohaneeinte nii Abeli sohin coichana jaohalune jaan caje coaauneein, Cana Coaunera rai lenonecuru mocooruha saseredotecuruhachane jaan rori aina santuario cataaun teein inara foerateracuruhacha atinailu Sacariasi que tiaaojoaain caa enene neiniquichene que nii core coaaratiha cureein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Cairichaaojoaaiche, Cana Coaunera ere bera Moisesa naitoonjoan que cacha relaaurera; Cana Coaunera naitoonjoan coitucuhin neeichene saijieein tonorana jerelanaala neein, coitucuhin tonoraauruha cachaaurune jerelanaalane maajeeine jaun,” nae caauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Niritoha acaauru raine jaun jetaote, aina obajeein, nechu jataain tonaane coulurujeeuruhane jaan lera ariha jetao, Jesoso rerohecaaure Cana Coaunera naitoonjoan que cacha relaaurera aina fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nitohaneein araai oharaancaain netaojiaauruha cachaaurune jaun jetaote, nejesinajeein ita sururucuruhane jana jetao, aina nerelanacaauru rai jetao: “Jiaonriha aihuruha fariseeocurune rijijieein asinojoineein baaso ichaain caohacha ichaa nocoetiin nihache. ");
INSERT INTO uraNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nii asinojoineein coitucueraelanaala baaso ichaain caohacha ichaa nocoetocoichene nihanatiinte inae ecu tihane bana coitucunojoinereein. ");
INSERT INTO uraNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nitohanihane jaunte, inae nii cojoanonaa que inae turuhane bana, nii coitucueraane coataa asiin ereeichene jaan coitucunojoinereein. Jana nii coaraa chunine coataa asiin inaraacha beite satiin aonajera urichoo coitucunojoinereein. ");
INSERT INTO uraNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nitohanihane jaunne, jataain canuhacha belaaineeichene rai aitoreeunni. Jiaonriha inara sohin inara jaonaa jerera que casiin neeichene, nii inara atinaaruhane baiha nii chatohaneein inara teein inara itajenaa nainecurenihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nena laen esinae rauhijiriin coasinacai que inara rai aitoreeunni. Nii ohin niha inara jaberocone baiha usi jana inara suujue itajeranu quete laen nainequiche casiin neeichene. Aiha laen, nitohaneein cana tenaa nainerate laen naine coasiin ichaohacane. ");
INSERT INTO uraNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tana nii coitucuhichene rijijieein jataain corelanaala nenaa coroatajajei moneda coriqui coreniha saoquii tajae laaoinaa que necoreteeichene. Nete nitohaneein cachaauru rai jataain cha que nelatenihane saijieein, nii leinjiinniji acaauru baitene Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nii rijijieein techu, leinjiana leinjianaain janiinojoineein ne inara couturijihuru. Aihana jaun, itolere tajaae laaoinaacuru amurijiriin nelateein neeiche Cana Coaunera raine jaun, jiaonriha casiin neeichene. ");
INSERT INTO uraNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chunocoha cacoitucuhin canu coreniha laraajiin cachaauru acatiha netiin ereein neine, inae Cana Coaunera Cojoanonaa que turuhane bana, Cana Coaunera aina letonocuru anjeraauru notaracaae netiin canu, acaihaniji inaraacha cohajei cachaneein nejanohanaa nichaaunne aca coreniha erereeunni. ");
INSERT INTO uraNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jana chunocoha, cachaauru que canu neein nihanune coitucueratelanaala nenaane, acaaentonoai coitucuha cuhenereeunni canuhetonai, Cana Coaunera aina rai anjeraauru acatiha netiin. ");
INSERT INTO uraNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Canu acaihaniji inaraacha cohajei Cachaneein nejanohanune que baasoneein ereein nei que nihanatiinte suujua acatena nainereein ofa Cana Coaunera. Nete laen baaso neein Cana Coaunera Suujue que ereein nei que suujua acatenereein. ");
INSERT INTO uraNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nitohanihane jaun inara colurujueein inara amaauruha sinacoca asae Joriocuru cocoainanacaihuri, joesiocuru, naaonjoainuri renene, jiaonriha chaque tonajeein cuhichene. Coa: ‘Tonaainnera erereeunta,’ naain nocoatiin ereeichene jaanu coacuhin cuhache. ");
INSERT INTO uraNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Inae ereeichene coina neeichene janate, caohachaain ereeichene coina inara relaa cureein Cana Coaunera Suujue. Coatiha inara suujua caje rocohin ecu ereriheicheein,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nitohaneein cachaauru relaa Jesosone jana jetaote, nii arajii cachaauru caje leinjiin cacha jetao Jesoso rai: “Cacha relaera, canu nejera rai aitoote, canu rai canacaanu inaca amureecha ratirii rucuhele canacaanu raineein nenaa leruhin teeine canu raicha,” naa Jesoso raine jaun jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","“Chana jana chaen, cocoainanacaineein canu teein, nitohanai rucuheraneein inara rene caletoae inara inaca amureecha sirii rucuhele leruhin tihanu inara raine coina,” naain jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","saain nii ecu neein aonajeeurera cachaauru rai jetao: “Jiaonriha itolere siriin necoriquijiaain nenaa coauquiche inara netonaine. Coatiha coriqui siriin nihacaneecha que nelateein nihei cana ichaota,” naain jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","“Coaracuchenachuhinti niqui niha leinjiin cacha, jataain itolere siriin coriquihonane. Nii jaun jetao, jelai teein atane siriin, arajiin ocoana sirihane jaun jataain arajiin rai temulecuru taojiae. ");
INSERT INTO uraNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nii jaun jetaote: ‘Cha laen ichareeun canu temulecuru canuhacha taojiai ainata. Inae nihei rucuhecaaunne jaanuta,’ naain jetao coacuhin; ");
INSERT INTO uraNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Saan. Inae canuhacha ichaneni coitucuhanu. Jitariin canu temulecuru coloherihuru comaain jaohinne, nacoauneein leeochaauru lorerichuru tabaihuri jareeun, jitariin catemuleeuru canuhacha taojiai rucujueein, jitariin carujueleeurune maajeein rucuhecaaun nasae teeinne coina. ");
INSERT INTO uraNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nii baihane laen caraajenihane: Inae niha araai jaanacaneein ichaohin, tonajelanaala acau cohin, lenoneein, rachoojoeein naaonjoaanune jaanu,’ naain suujua cuhane iriha nii coriqui coriquihonane jana jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","‘Asoneeojoaainaate, ena cojoanotiin cuhanete oriquiincha. Nii ii rucuhele inacojoeein arajiin rucujueein chunaain iicha sirii, chaa raineein chaainti niha cureeinta,’ nae jetao rai Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nitohanihane jaunte, nechu jataain raineein chaque namute cacha coroatajanelanaala rucuhele siriin nenaa cacha, Cana Coaunera rai cairichainejeein ne, nitajihane rai nihane jaun,” naain jetao nii coriquihona cacha que erenaa parabola que acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Niritohane baiha jetaote, aina nerelanacaauru rai jetao: “Caa quene inara rai erenaa jereeun. Jiaonriha lenoneein ichaohiche jaanu aina inara cajioneecha que nererojoecaaichene. ");
INSERT INTO uraNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Jataain nelateein niha lenonene amurijiriinte, jataain nelateein ne inara ichao. Jerichanejeein techu nelateein niha cajionene amurijiriin jataain nelateein ne inara jaberoco. ");
INSERT INTO uraNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Coaracuche nachuhinti temule jaain, niicha quiineeuri rucuhecuruhane jaanu coloheri siriin, naaonjoaain neeururiha rohirihuru. Nete laen Cana Coaunera, lenoneein ichaaoruhane coina acaauruhacha quiine teein ne. Inarate rohirihuru amurijiriin jataain nelateein neeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Inaonjoa saain nihanatiin itolereneein suujua cuhane coaauca cachane nihanatiin, nichao cariaain ichaonaa nainihei. ");
INSERT INTO uraNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chanuna aansijiin laaojoiri que coacuhin neeichene nihanatiin, ichana nainequichene coaalanaala itolere que nererojoecaaeriin neeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Coaracuche nachuhinti caohachaenanaain omarohin neeuruha caa ajaena ujuanecuru amihanejeein neeuruhane que airijiinne. Nete aihuruha caa ajaena ujuanecurune tocohaneein jataain caohachaain inanacaenelu rey Salomoon, cajione caohacha que necoreeteein nihalune saijieein. ");
INSERT INTO uraNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nitohaneein mocohenineein niha caa ajaena ujuanecuru natiinte, caohachaain omarohin neeuruhane jaanu teein ne Cana Coaunera. Tana nii amurijiriin inara- cachaneein neeichene cajione terichaain Cana Coaunerane esenetaaicheneta. ");
INSERT INTO uraNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nitohanihane jaun, coa lenoneein, acau cohin, naaonjoaaichene jaanuhacha que nererojoecaaeriin nihache. ");
INSERT INTO uraNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Satiin caa chauratane que Cana Coaunera coitucuelanaala nenacaauru cachaaurute, nechu jataain nitohaneein nererojoecaaeriin neeure. Nete laen, satiin inaraacha latei coitucuhin teraneein ne Cana Inaca Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nitohanihane jaun jeriha Cana Coaunerane rijijieein ichaaoruha cachaaurune jaan Cojoanonaa que coacuhin neeichenete lanaenereein inaraacha latei,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Niritiin jetaote: “Jiaonriha casiin neeichene, charijieein teeinti carenero beraain neeure irilaain sirichaauru, nii rijijieein inara beraain nerichaaunnine jaun. Inara Cana Coaunera coitucuheraneeichenete, jataain coroatajajeein neeiche niqui. Nete jataain inara belaihane jaun rai Cojoanonaa que inara rareein Ofa Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aihane jaun, jitariin nii inaraacha sirii rucuhele que necoreteein, cairichainejeein chaelai que latejiojoiriin nenacaauru coroatajanecuche. Nitohaneein neeichenete, dedeeu charijibana satonoelanaala nenaa Cana Coauneraacha teeninu rariquicheein. Nerinaain inara caje nii dedeeu inara raineein nenaa ruluera. Nii bana asijiautooru nihanatiin ecu turuhin inara basijiahuna nainihei. Niheichu cojoano nihanatiin ecu enohin asaaena nainihei. ");
INSERT INTO uraNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nitohanihane jaun jauriaanejeein caohatiin, nii chabana satonoelanaala nenaa, nii ena nitaje rai nenaa inara ichao, naaonjoai que coaaucuche. ");
INSERT INTO uraNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Letona jatoraain inara cajione jiaain neeuche, inara siricho mocohin conohanau. ");
INSERT INTO uraNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Charijieein teeinti, nesirihatenaa beseta caje cauhin, acuujua dadaa fatoroone jana, acuujua joaracaain raaure nii letonocuru. Nii rijijieein jatoraain neeuche. ");
INSERT INTO uraNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Raotojoeeinte neeurureein nii rai letonocuru, sinilanaala neeuruhane jana acaauru eruha nii acaauru fatoroone. Esinae rauhijiriinte raajenihane rori ichoae acaauru lauriaain lenone que acaauru coroaatiha cureein nii acaauru fatoroon. ");
INSERT INTO uraNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dede cataaun, janonaa nichae, naaonjoaain turuhane jana, sinilanaala cohacuruhanete, raotojoeein neeurureein. ");
INSERT INTO uraNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Caohachaain inara rai caitoonjoa aonacuchete coitucuhiche. Chunocoha loreri erora turuhin basijiauha uha asijiatone coitucuhane, coatiha nii acuujua joracarihei, nabana enohin basijiauha nii asijiautone coataa. ");
INSERT INTO uraNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nii rijijieein inara netonai nainaain jatoroaain neeuche, turuha urichaain nacoauneein nii jauriaa acaihaniji inaraacha cohajei Cachaneein nejanohanaa que,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Niritoha Jesosone jaun jetaote: “Leinjiin canacaanuhacha ii aina nerelanaanichaanune relanaa aitohi Curuaanaa, ainihane satiin raine maajeeinna aitohi,” naain caje bajaa Fedorone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","“Tana coitucuhichene. Chariji jian, nii jataain nelateein nere tonoraeraneein loreri beraichanu que ratiri rai fatoroon, turuhanereen tiaain nii rai cachaauru coroaateein acaauru sirihane coina. Tana satiin canuhacha cocoainai neeichene, canu cachaauru beraichaneein neeichene coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jataain raotojoeeinte nereein nii nere tonoraera, nii letoain ratirihane jaa ichaa jerihane rijijieeine jana, eruha nii fatoroone. ");
INSERT INTO uraNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nii banate, esinae rauhijiriin jerihane rijijieein ichaohin nere tonoraain nihane, aca cocoinaain itolere niicha sirii coaaranu que tereein rai fatoroon. ");
INSERT INTO uraNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jana, ‘Jaitijiecha carajaain lanae turuha rai fatoroone’ naain coacuhin baasoneein niicha beraihuri quichaauru, enecuru, naaonjoainuri que jaolequiin acau cohin, lenoneein, ajeein, naaonjoaane jana ");
INSERT INTO uraNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","eruhanete, rai cachaaurunelanaala rai nere tonoraaichuru cairichaa curichaain Cana Coaunerane rijijieein acaentonai cairichaa cureein nii rai fatoroon. ");
INSERT INTO uraNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jana inae nitohaneein coitucuhane saijieein, jatoroaain nelanaala nii letoaa rai fatoroonne tonoraelanaala, nenaate casetecareein jataain banejelanaala bisiin rai fatoroon. ");
INSERT INTO uraNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nete laen coitucuelanaala nenaa rai cacha, baaso ichaane nihanatiin coitucuuruhane saijieein baaso ichaeraauru fautaeriin cairichanojoiniha cureein. Nitohanihane jaun, quiicha coitucui coitucuheratihanune jaancuru cajene, jataain jelai amuritoheriin bajareeunni, canuhacha jerei ichacuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Canune caa chauratane que usi mocoha uun. Bajiaa nachuhinti chajaain mocohane jana turueneeunlu. ");
INSERT INTO uraNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Jataain necairichanaa tabai abaantanunete ne. Nii jaunne, nii que turuhanereen tiaain, que nererojocaeriin neeun. ");
INSERT INTO uraNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Inacojoeein chachu, ‘Caa cana rai chauratane que jecha raoti ichaonaanaja turuaa uun,’ naaiche niqui. Aihei bajiaa. Raujiaain ita caje neleruhin niha cachane coinane turuunlu. ");
INSERT INTO uraNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nitohanihane jaunte, saoquiin le lorerijieeincha ita aina ichaonacaauru, ena caje coauneein ita caje neleruhin, nii nichatajaihuri que nejeratiha cuurureein nii coroatajaihuri. Jana coroatajaihurite, nejeratiha cuurureein nichatajaihuri que. ");
INSERT INTO uraNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jana calaohi aina te nejeratereein rai inaca. Nii jana calaohite inaca que nejeratereein. Jana acaauru nebate, rai cacunu que nejeratihane jana, rai cacunu netonai que nejeratereein. Rai nacano que nejeratiha nebaenene janate, nebaene que nejeratereein rai nacano,” naain jetao Fedoro tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nii baiha jetaote, leeochaauru cachaauru rai jetao: “Enoto soo nichajai que nijichorianaa coaraaichenete, ‘Urichaain elo,’ naain ereeichene, nii aitocoichene rijijieein esinae rauhijiriin uhe elo. ");
INSERT INTO uraNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jerichanejeein techu, enoto mitu coarajeein cana raotono nichajai caje uaain jiatuha cujuanane, ‘Ajaarotorichaain,’ naaichene esinae rauhijiriin ajaarote. ");
INSERT INTO uraNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Cha coitucunaa jeriheichuru casajeeuru. Nitohaneein dede, cana rai chauratane, naaonjoain caje coaraain cha coitucuhiche natiinte, canu coaraaiche natiin, ‘Naaonjoaa ichaonaane coinate aicha,’ naain canu coitucunaa jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Chanuna baaso ichaain neeichene niha natiin, baaso ichaquichene coitucuhi nenaa jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nitohanihane jaunte, inae ena caje coauneein colurujuenojoi ineriquicheein. Aihane jaun, joesio rene inara amaa inara colurujueranu ajiniha aina rucuecuche. Ainihanete, inae coulurujuenojoi nequichene jaan cojoanonaa que turuhane bana, inara netonai colurujuiha nii nejerateeichene jaan jera joesio raine, inara tiha coaridiaauru bijihune, caresero cuhane inara enohaurureein. ");
INSERT INTO uraNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nii bana jelai caje mituriheeicheein nii baaso ichaquichene jaan core nainaaiche jitaain inara coriqui jaohinne reein tiaan,” nae jetao cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nii bana jetaote, turuha cuure cachaauru Jesoso rene. Nitohaneein rene turuhin jetaote, “Jerosaleen nenaa Teenforo asaae lenonecuru sohin mocohin, Cana Coaunera coroaeca neeuruha Calileea cocoaichacuru tabaaurune janate, acaauru sohin jaonajaain, nii lenone acaauruhacha sohi coichana que acaauru coichana jasiite Filatora,” naain jetao Jesoso rai beeure nii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Niritocuruhane jana jetaote: “ ‘Jataain naraaichuru amurijiriin osaaocuruhane jaun jecha aihure nii Calileea cocoaichacuru’ naaiche niqui. ");
INSERT INTO uraNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nete aine. Inara netonaite ohin nitajeriquicheein, inara ichao coreein jeriha Cana Coaunerane rijijieein neneeichene. ");
INSERT INTO uraNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jerichanejeein techu jerihane, ‘Nii leeochaauru Jerosaleeun ichaonacaaurulu amurijiriin jecha osaaotooruhane jaun, nii le choonca fosaneeuri ichoae comoe nii ucuuneein ininaanaja nenaa Silohe,’ naaiche niqui. ");
INSERT INTO uraNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nete aine. Nii aihuruhane rijijieein techu inara netonai ohin nitajeriquicheein, jeriha Cana Coaunerane rijijieein inara ichao coreein ichaonaa jereneeichene,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Niritiin jetaote: “Leinjiin cacha nocoana jana leinjiin temule sirihane jaun jetaote, inaacane coaraa cue. Nii jana leinjiinniji inacaenihane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","nii ocoana beraicha cacha rai jetao, ‘Aonaaun. Nichata jaanaca naineeinne niqui le jaanacaauru naineein turuhin caa temule coaraa unajacoon. Nena chabana inaacane jana coaraeneeun. Aihane jaun chajaain ena sauhin jaao. Cha inacojoeeinte atane lanaaeca nere,’ naane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Aihachuhisi niquicha curuaanaa. Jauriaa nirijieein coarajeeune, ena ajaanaa cuhane rai nasaji retuhin ajaena setuuru te temurau. ");
INSERT INTO uraNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nitohaneein tihanune saijieein inacaenihanete laen nainere sauhin jaohine,’ naain jetao tonorae nii ocoana beraicha,” naain jetao cachaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nii baiha jetaote, nebetacanaa cojoanonaa bana sinacoca asae enohin jetao, cachaauru relaa cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nii jana jetaote, ecu ne leinjiin ene- lechoonca fosa jaanacanihane caje coauneein baasoniha jaberocone jaun caaun cunaiteein. Nitohaneein jetaote, suujua cuhane neein jaberoco asaaeca coitucuchuhine jaun, nii chariji bana neraujiasilanaala janori rarohacaain ne. ");
INSERT INTO uraNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Nii ene coaraain jetaote, cotijiaain nichoae biji meracaain: “Inaen ii cunai caje nerautaaicha ene,” naa Jesosone rijieeoritiin, cunai caje nerautaain nichaauraain jetao, Cana Coaunera coroajeein rachoojoe nii cunaitenaa ene. ");
INSERT INTO uraNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nitohaneein nebetacanaa cojoanonaa bana cunaitenaa rautaa Jesosone coaraain jetaote, obaje nii sinacoca curuaanaa. Nitohaneein obajeein jetaote: “Niha saota janoneein amihanenaana jaan cojoanonaa. Nii amihanenaana jaan cojoanonaa bana nerautaeratiha uuchera. Coa nebetacanaa cojoanonaa bana nerautaeratiha uhachera,” naa cachaauru raine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","“Chanuna nebetacanaa janonaa bana cha ichaain neeiche inara netonaine saijieein, cha ichaain neeuruha leeochaaurune jereneeiche. Tana inara netonai nebetacanaa cojoanonaa bana, inara baca, inara boro, naaonjoinuri cosi batuhin amaaiche jesinaaeca cohane coinane. ");
INSERT INTO uraNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nii rijijieeiina caa ene Abaraaun nefoerateneein nenaa, lechoonca fosa jaanacaneein Moconajaera ichanohineein caaun cunaiteein nihane caje, nebetacanaa cojoanonaa bana rautaaun,” naa Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","jataain nocoejeeure jetao, nii aina nejeratenacaauru. Ne jetaote jataain itolere que nelateein, itolere ichaa Jesosone coaraain jetao coroaecure satiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Niritiin jetaote: “Coaracuchenachuhinti aansijihan mosatasa ucuhe natiin, nocoana jana temuha cachane jana omarohin fohecane, rai nunecuru que nucuhateeuruha tajaaecurune. Nii rijiicha cacha inae Cana Coaunera Cojoanonaa canuhacha tei que ichaoha cachane,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Niritiin jetaote: “Coaracuchenachuhinti faan ichacuruhane coina neleeriha tabaain nii colihane jaanu que jorerera teein, nichata sajeein coujunaca que arina coujunacate leinjiin ene, inae neleeriha tabaain nii colihane jana caje arajiin faan jaane coina. Nii rijijieeinte neleeriha tabaain colihane coina nenaa jorerera rijijieein, neruujiha cacha ichaone coina nenaa ne Cana Coaunera Cojoanonaa,” naain jetao acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nii baiha jetaote, Jerosaleeun cuuruna jaaun jetao, situuruna jaaunru nenacaauru nenaanajaaunru, neseeuru, naaonjoainuri naineein cachaauru relajeein cuujue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nii jana jetaote: “Curuaanaa, jataainna coroatajaaecuruha caa nosa caje nichotenacaauru,” naain caje bajaa leinjiinne jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Eenjeen. Nitohanihane jaun, nii acuujua jaratoelanaala nenaa cuhane enooche. Arajiite niqui enonaa jerereein nete nainecurenereein. ");
INSERT INTO uraNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Inae ecu tihane bana nimichuhin acuujua fuha nii loreri erora nete, inara airiniha nedainequichene, ‘Curuaanaa, acuujua joaracaaune enohacaanura,’ naaichene janate, ‘Inara coitucuhanune coaalanaala, cha nequiche chaainti,’ naa inara rai nii loreri eroranete, ");
INSERT INTO uraNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","‘Ii ainane lenoneein, acau cohin, naaonjoarejetocoaanulu. Iite canacaanu relarejetohi canacaanu berooru cuhanera,’ naaichene janate, ");
INSERT INTO uraNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","‘Inae inara rai aitocoaaun, cha nequiche chaainti. Inara coitucuhaaun. Naain cacaje amuuche, baaso ichaechajeein ichaonacaauru,’ nareein. ");
INSERT INTO uraNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nii banate, inara airiniha nedainiquichene inara catu rihoneein chanaa curiquicheein, Cana Coaunera Cojoanonaa que neeuruha satiin profetacuru, Abaraaun, Isaca, Jacobo, naaonjoainurine coarajeeincha. ");
INSERT INTO uraNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nitohaneeinte enoto mitu nichajai coarajeein cana jaabiji nichajai caje, enoto mitu nichajai coarajeein cana raotono nichajai caje, enoto mitu nichajai caje, enoto soo nichajai caje, naaonjoainuri nichajai cajeeurute turuha uurureein cachaauru, Cana Coaunera aina rai Cojoanonaa que neein nelauriaain lenonecuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nitohanerichaainne jaunte, nii ena jaolecooruhane jaaunru nelatelanaala nenacaauru tabaaurute, ichoaichaniha ranojoineein niha cuurureein. Jana leeochaauru amurijiriin nelaaetoha nocoetonacaauru tabaaurute, satononejeein ranojoiniha cuurureein,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Niritohane jana jetaote: “Chajaain ena caalai caje amuu. Ii sohinte ii jaonaa jere Erodesicha,” naauruha Jesoso rene turuhin fariseeocuru tabaaurune jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","“Aiha niqui. Chajaain nii ataibinae rai: ‘Enene, eresi, eresi cojoanoon, naaonjoaichurune coitucuchuhichuru sitaain, cunaitenacaauru rautaain, naaonjoareeunni,’ naain benichuche. ");
INSERT INTO uraNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nena laen enene, eresi, eresi cojoanoo, naaonjoaainchuru canuhacha ichaneni ichaaechajeein cuujuereeunni, nii Jerosaleeun edaa onaa naineniha leinjiin profetane jaun, ecu turuhanune reentiaaincha,” naain Erodesi rai beratihane baiha jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Cairichaaojoaaiche nohane satiin Jerosaleen cocoaichacuru, inara rene Cana Coaunera letonocuru, chaen profetacuru, naaonjoainuri bodoosiin ajeri que sohin jaonajaaonquichene jaun. Araai saaine niqui nitaro asae calaohichuru sararaain siniha ataoharine rijijieein, inara ranaa jereeun, nete cacoitucunaa jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aihane jaunte inaen jelai neriquicheein. Inae cacoharariheeicheein nacoaauneein inara rene turuhanune reeintiaaincha. Nii nacoauneein tururichaaunine cojoanonaa banate: ‘Raotojoeein turuhine Cana Coauneraneein nenaa cana Curuaanaara,’ nariquicheein canu raicha,” nae jetao cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nii baiha jetaote, nebetacanaa janonaa bana leinjiin curuaanaa fariseeo loreri asae lenoniha cuha Jesosone jana jetao colurujueeuruhane jaanu leratihane coaracuruhane coina, “Chatohanaicha ichareein,” naauruhane jaun jetao ecu coarajeeure leeochaauru fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nii jana, niritiin coaaucuruhane que nainaane jaun jetaote, ecu rohan niha leinjiin cacha laracaain cunaitenaane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","“Nainihana nebetacanaa janonaa bana rautaeraa leinjiin cunaitenaane. Tonaquiche inara,” naain jetao Cana Coaunera aitoonjoa que cacha relaaurera, chaen fariseeocuru, naaonjoainuri caje jetao bajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nii jana inauheneecha curuaaequiin aonajeeuruhane jaun jetaote, biji que nii cunaitenaa mucuhin rautaain jetao letoae amuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nitohaneein cunaitenaa rautaain jetaote: “Chariji inara caje nebetacanaa janonaa bana naluha rai toro acau netaojianaja atane jachu ucuacaain nenaa cuhanene jana, inauheneecha rocoelanaala coarajere. Ainihane rai calaohi naluha acau netaojiana jaan atane jachu cuhanene, nirijieein rocoelanaala coarajere,” naain fariseeocuru caje bajaa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tonoraelanaala inauheneecha aonajeeure. ");
INSERT INTO uraNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Niritoha Jesosone jana, nelaurianaanaja rori caohacha janijiin nichoae nelauriaauruha nii cotihanojoihurine coaraain jetaote, acaauru suujuatiha: ");
INSERT INTO uraNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Chunocoha inara cotihaca nesiriatenaa beseta quene, jiaonriha rori caohacha janijiin nichoae nelauriaaichene. Nabana turuha uha inara amuritoheriin nelateein nenaa cotihanohinete, ");
INSERT INTO uraNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","‘Nii ii rori jianeeute ecu nelauriamiin caa leeocha,’ naa uha nii inara cotiharane, coejetiin rori baaso ichoae nelauriaa cunaa nainequiche. ");
INSERT INTO uraNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aihane jaun nii ajiniha inara cotihara nihane, rori baasonejeein nenaa ichoae nelauriaauche. Nii banate turuhin, satiin nii ii rohan rori ichoae nelaurianacaauru notaracaae, ‘Caa rori caohacha ichoae nelauriaa uura quiicha belaai,’ naa nii inara cotiharane, ichei caohachanere. ");
INSERT INTO uraNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nitohaneein leeochaauru amurijiriin nelateein nenaa jerenacaaurute, necoeje chanunojoiniha cuurureein. Jana nii nelatecuruhane coaaratelanaala nenacaaurute, raotojoeein ranojoi niha cuurureein,” naain jetao suujuatenajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Niritiin jetaote acaauru cotihara cacha rai jetao: “Cachaauru cotijiaain coroatenaa jereeine, jiaonriha ii nejeraauru, charaaichuru, iicha belaihuri, ii laurijiracuru coriquihonacaauru, naaonjoainuri cotihaquine. Acaauru cotijiaain acaauru coroateeine jana, ii cotijiaain ii coroaateeuruhanete, inae ii rai nii cainaenereein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nitohanihane jaun beseta ichana jereeine, cairichaihuri, nelatelanaala nenacaauru, bacosacuru, maosacuru, naaonjoainuri cachaauru cotihacu. ");
INSERT INTO uraNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Acaaurute laen ichei cainana nainecurenihane nihanatiin, Cana Coaunera ichei cainaa cureein, inae rai cachaneein nenacaauru ichatiha oo caje Cana Coaunerane bana,” nae jetao nii cotihara fariseeo rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Niritoha Jesosone jana aonaain jetaote: “Bajiaanachuhinti Cana Coaunera Cojoanonaa que neein lenonenihacache,” naa Jesoso rai leinjiin acaauru aina rori ichoae nenaane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","“Coaracuchena chuhinti leinjiin cacha jetao, lenone jaain arajiin cachaauru cotiharate. ");
INSERT INTO uraNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nitohaneein jetaote, inaen jatoroaa nii lenonene jana jetao rai letono letoae cotihanajaane coina. Nii jaun jetaote, cuhin acaauru rene turuhin: ‘Chajaauchejete lenone, inae jatoroaa lenonera,’ naain cotihanajaane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","‘Saan, naininaaun. Ena atane coretichaaunne jaun coaraa cuhanunete ne. Canu que ii suujua acateeu,’ naain jetao berate leinjiin. ");
INSERT INTO uraNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nii jana leeocha jetaote: ‘Lechooncaain toro amihanenaa que nelatei coretichaaun enane jaunne, acaauru coujuhin coaraa cureeun, amihanenaa que nelatecuruhane coitucuhanune coina. Nii jaunne ichei aitoon caque ii suujua acateeine coina,’ naain beratihane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","leeocha netonai: ‘Ena nesirihatihanune jaun nainihaaun uhanune,’ naain jetao satiin ita rijitiin beratihacoaaure, acaauru que suujua acatiha acaauru cotiharane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nii jaun jetaote, jelaiha cauhin nii rai aitocuruhane rijitojoeein biha cue rai fatoroon rai nii letono. Nii jaun jetaote obajeein, ‘Chajaain soroneein nese sacutaain cuhin, cairichaihuri, cacha nelatelanaala nenacaauru, maosacuru, bacosacuru, naaonjoainuri cotijiaain cajia uhanajaau,’ nae jetao rai fatoroon nii letono rai. ");
INSERT INTO uraNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nii jaun jetaote, nii rai aitohane rijijieein satiin cachaauru chaque nelatelanaala nenacaauru cotijiaain jetao: ‘Curuaanaa, inae nii carai aitohine jaa ichacaaun. Nete jaiti caute nelaurihananajaauru,’ naa nii letonone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‘Chajaain nenaanajaauru naineein cuhin, unaa jereraauru leeochaauru cachaauru cotihanihute nemomiin canu lorericha. ");
INSERT INTO uraNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Coatiha inae canu loreri asaae lenonecururihaain nii jauriaanejeein cotihanojoinunrita,’ nae jetao nii letono rai fatoroon,” naain jetao nii cacha tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jelai caje amuha Jesosone jana, arajiin sacuuruha cachaaurune jaun jetaote, acaauru rai: ");
INSERT INTO uraNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Chunocoha canu esenetaain canu cachaneein nenaa jerihane, rai inaca, rai neba, rai comasai, rai bereecuru, rai nejeraauru, rai baihuru, rai jaberoco, naaonjoainuri belaihane amurijiriin cacoelaain quere tonoraain nihanete ne. ");
INSERT INTO uraNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Canuneein nihanune coitucuhin canu cachaneein nenaa jerera, coroso que airichaaunnine rijijieein itolere necairichanaa abaantaain letohaanune jaan ichaain neeine. Jana ainihane, coatiha canu cachaneein nenaa nainihei chuni. ");
INSERT INTO uraNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tana inara tabaauru, leinjiin loreri janaa jerihane jauriaanejeein nelauriaain: ‘Necha besautiana nainerichaaunni,’ naain coaaucane coitucuhichene. ");
INSERT INTO uraNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nitohaneein coacuelanaala ichaain, nunuheniha nenaa tihane baiha jianihanete, satiin ecu situhin coaaraauru nainere: ");
INSERT INTO uraNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Caa leinjiin cachate niqui caa loreri ichana jere. Nete jauriaanejeein besautiaane jaanu que coacuhin ichaenihane jaun nainaelanaala ecu jiane,’ naain erenaa nainecurure que cachaauru. Aihane jaun jauriaa nejeein besautiana nainihane coitucuhane coina coaauca nii loreri ichara cachane rijijieein coaumiin canu cachaneein nenaa jerera. ");
INSERT INTO uraNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nii rijijieein techu jauriaanejeein nelauriaain coaauna nainere leinjiin rey, leeocha rey aina sonaana que nenaa jerihane: ‘Necha lechoonca oharaancani soondarooru aina caa coroata choonca oharaancani soodaroo aina nenaa rey amuritonaa nainichaaun,’ naain coaaucane jana, ");
INSERT INTO uraNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","nainenihane coitucuhanete, jaiti coriaae niha nii nejeratihane jaa reyne jana, raotojoeein jiniiquiin ita aina rucujueein ichaaoruhane coina jitariin nii leeocha rey nejeratenajaacha bajai tihane coina aitiin nere beranu letoare. ");
INSERT INTO uraNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nii rijijieein coacuelanaala, niicha sirii jianena jerelanaala nenaa, coatiha canu cachaneein nenaa nainihei. ");
INSERT INTO uraNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Coaracuchena chuhinti jataain nelatiha niqui tebene. Nete nii cotebihane jianihane, inae chaque nelateein nenere. ");
INSERT INTO uraNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Niheichu temule jaacane coina, atane jasiitihacane jaanu que nihanatiin nelaterihei. Nechu jataain joaereeinte jaoleneein nere. Nii rijijieein nii chaque nelaterihei, relaanune rijijieein ichaohane baiha, jianeein niha canu cachane. Caa caitoonjoan aonacurumiin uricho nacaauru,” nae jetao nii arajiin sacuurera cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Satiin naraaichuru Jorioocuru cairichaeriin Roma curuaanaa rai impoestonu que coriqui que cachaauru cobaraaurera, chaen leeochaauru cachaauru baasoneein ichaonacaauru, naaonjoainuri jetaote, Jesoso rene turuure irihane aonacuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nii coaraain jetaote, “Caa cachate osaaonacaauru cachaauru raain nihanatiin acaauru aina lenonenajaque,” naain jetao Jesoso necoeje chanuure Moisesa aitoonjoan que cacha relaaurera aina fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Niritocuruhane jaun jetaote, acaauru rai: “Tana chunocoha inara caje lefashaain carenero siriquichene jana, nitajiha leinjiine nii iscoonchoonca iscooni ratiriin nii nitajenaa carenero ariha curiquiche eruhichenereein tiaaine. ");
INSERT INTO uraNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nitohaneein inae eruhichenete raotojoeein baijiaain turuaain, ");
INSERT INTO uraNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","loreri asaae inaraacha belaihuri, inara laurijiracuru, naaonjoainuri cotijiaain, ‘Canu coroaecuche. Inae carai nitajenaa carenero eruhanu,’ nanaa naineriquiche. ");
INSERT INTO uraNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nii rijijieein techu osaaocuruhane coitucunaa jerelanaala neeuruha nii iscoonchoonca iscooneeurine jana, leinjiin cacha osaaocane coitucuhin, Cana Coaunera lateein rene turuhane, nii iscoonchoonca iscoonni coroajelanaala, nii leinjiin turunaacha coroaaecure dedeeu nenacaauru,” naain jetao fariseeocuru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Niritiin jetaote: “Nii rijijieeintechu, leinjiin ene, lechooncaain moneda jataain rai nelateineein nenaa caje nitajiha leinjiinne, tana raafariin mocohin, eruhanereen tihaain loreri asaji lojoiin caohatiin aririhane. ");
INSERT INTO uraNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nitohaneeein ariin eruhane, tana niicha belaihuri, chaen rai laurijiracuru, naaonjoainuri cotijiaain, ‘Canu coroaecuche. Inaen canu rai nitajenaa jataain canu rai nelateineein nenaa moneda eruhanura,’ nariha nii ene ne. ");
INSERT INTO uraNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nii rijijieein techu, ita coroajeein neeure Cana Coaunera rai anjeraauru, nosa caje nichoteein niha leinjiin cachanera,” naain jetao acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Niritiin jetaote: “Niha jetao leinjiin cacha coroatajaain calaojoiin. ");
INSERT INTO uraNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nii jana, nii rai calaohi ocoala jetaote: ‘Ofa, canu rai, ohine bana caraineein neeninu iicha sirii irihuru, ii atane, ii rucuhele naaonjoaihunri leruu,’ naane jaun jetao, nii rai ninana aina acaauru naineein jetao lerue nii acaauru inaca. ");
INSERT INTO uraNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nii jana rai nocoala jetaote, nii baiha neeoriin jetao nii que banijiaai que jitariin necoreteein jetao nii coriqui aina coriajai atane cuhin, nechu jataain joaereein jitariin rai coriqui jaohin nichao que ichoae. ");
INSERT INTO uraNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Inaen jitariin rai coriqui jaohane jana, nii nihane jaan neniha quinacaine jaun jetaote, ecu mijitena que necairichae. ");
INSERT INTO uraNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nii jaun jetaote, nii nihane jaan nenaa leinjiin cacha caje amihanenaa ariha cuhane jaun, rai cosichuru beraihane coina jetao letoae nii cacha. ");
INSERT INTO uraNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nii jaun jetaote, nii cosichuru lenone raain que lenonenee rijitocojoae. Nejetaote nene rai cha tera. ");
INSERT INTO uraNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nii jaun jetaote: ‘Arajiin neeuruha ofa rai amihanenacaauru natiinte, itolere bana ne banejelanaala acaauru lenonenu, cau mijitenacaaun ohajihanu canune jana. ");
INSERT INTO uraNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jelaiha cauha cuhanunete ne ofa loreri asae. Chaenne inae ofa rene turuhanune: “Jataainine banejelanaala baaso ichaaun Cana Coaunera aina, ii aina, naaonjoaaincha. ");
INSERT INTO uraNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aihane jaun jiaonriha inae ii calaohineein caeteeinera. Raujiaain ichei amihanenacaauru rijijieein caeteeura ofa,” nareeunni ofa raicha,’ naain jetao suujua ere nii cacha calaohi ocoala. ");
INSERT INTO uraNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Niritiin suujua irihane baiha bero cuhane cuhin jelaiha cauha cuha rai inaca loreri asaene jana jetaote, jaiti nita nihane jana coaariin cairichaaojoaain coaraane jaun, soroneein coineteein jetao que baluunetiin, jataain belaain rae nii rai inaca. ");
INSERT INTO uraNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nii jana jetaote: ‘Jataain banejelanaalane baaso ichaaun Cana Coaunera aina, ii aina, naaonjoaaincha ofa. Aihane jaun jiaonriha ii calaohineein caeteeinera ofa,’ nae jetao nii calaohi, rai inaca rai. ");
INSERT INTO uraNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nejetaote niritohane jana: ‘Chajaain erojoeein cajione enachasine uhaain, caa rai cajione coreeuche. Chaen rai biji couturi que leinjiin anicho teein, rai tijia quene maajeein safato curuhacuche. ");
INSERT INTO uraNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Chaen leinjiin baca narejeen coereneti soochete, lenoneein beseta ichacaache, ");
INSERT INTO uraNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ohin nitajihane rai ne caje turuha uha caa canu calaohine jaun,’ naain jetao rai cachaauru letoae nii inaca. ");
INSERT INTO uraNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nii tonohanau jetaote, neeuruha irihurune jaaun nihane caje cauha uhe nii calaohi inana. Nii jana jetaote, inaen nenaanaja catainaane jana jetao, auno toteein raansaauruhane jana erunajae. ");
INSERT INTO uraNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nii jaun jetaote, nii leinjiin acaauru cacha cotijiaain jetao: ‘Chatohanai besetate ichaquicheta,’ naain caje bajaane jana jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Ii nejerate jerichanejeein raurohin turuhane jaun, baca narejeen coereneti soerateein beseta ichae ii inacara,’ naain rai biha nii acaauru cacha, nii calaohi inana raine jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","jataain obajeein loreri asaae turunaa jerene. Nii jana jetaote, raajenihane coineteein raa cue nii rai inaca, acaauru aina nihane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nii jana jetaote, jataain rautaelanaala jetao: ‘Iite raotojoeein araai jaanacaain ichei nelateein nihanune coitucuhi. Chaen nechu canu letoaaine chabana coiintelanaala ichaain neeun. Nii sainejeein chariji bana leinjiin niji carenero tiheei carai, canuhacha belaihuri aina sohin beseta ichacaaune coinata. ");
INSERT INTO uraNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nii saijieeinte turuha caa ii calaohi, ene cojoaeloroeerihuru aina nechu joaereein ii coriqui jaoinne janate, rai baca coereneti sohin teeicha,’ naa coaetaain rai inaca raine jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Aiha chuhisicha cacalabi. Iite chuhisi itolere bana canu aina neeicha. Nitohanihane jaunte satiin quiicha sirii icheineein nera. ");
INSERT INTO uraNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nete laen ena esinae rauhijiriin caohachae beseta ichaain rachoojoihacachene, ohin nitajihane rai ne caje nacoaauneein turuha ii ocoalane jaunra,’ nae jetao rai inaca,” naain jetao acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Niritiin jetaote, aina nerelanacaauru rai jetao: “Niha jetao leinjiin cacha jataain coriquihonaneein. Nii jetaote, rai loreri beraichaanu que leinjiin cacha ratiri jitariin rai rucuheleeuru, rai cachaauru, rai coriqui, naaonjoaihunri beraichanu que. Nii jana nii rai rucuheleeuru itajihacoaane jaun jetaote: ‘Inae ichujeleeuru itajeein, ii coriqui que niicha jerei ichaa taa ii cachara,’ naain jetao biha cuure nii fatoroon rai. ");
INSERT INTO uraNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nii jaun jetaote cotiharateein: ‘Chatohanai ichaaine jaunna, ii biha uure canu rai. Chajaain jitariin chamijianeeocuru cocoirichaain uhane coitucue. Inaen nenacaen nainiheei canu loreri aina canu rucuheleeuru beraichanu que neeineta,’ nae jetao nii rai fatoroon. ");
INSERT INTO uraNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nii jaun jetaote: ‘Chana nohane jana ichareeun, camijianeeon caje canu sitaa canu fatoroone jana. Coatiha atane que chatohanai amihanenaa ichana que nelatejeecaaunne coaalanaalata. Chaen nechu jataain nocoejeeun cacha caje chaaelai bajaanune quera,’ naain coaaucane baiha jetao ");
INSERT INTO uraNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‘Saan. Inae canuhacha ichaneni coitucuhanu, canu amihaneeon colane nedaanune bana canu raa chunocoha loreri asaaene coina,’ naain jetao suujua ere nii loreri beraichanu que niicha ratirii. ");
INSERT INTO uraNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Niritiin jetaote, leinjiana leinjianaain jetao, nii rai fatoroon que rebeeonacaauru cotijiaain: ‘Inaoonjoaain rebeeoqui canu fatoroon queta,’ naain bajaane jana jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Lefasha bareranei erene que ne rebecoonra,’ naain jetao tonorae nii jauriaanejeein niicha cotijiai. Nii jaun jetaote: ‘Saan, aihachuhisi. Nocoa nii rebeeoquine jaan, ninu nelauriaain saoquichoonca bareranejeeicha laenaaura,’ naane baiha jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Leeocha cacha rai jetao: ‘Inaaonjoaain jana rebeeoqui ii, canu fatoroon queta,’ naain bajaane jana jetaote: ‘Lefashai costaronei tirico quene rebecoonra,’ naain tonoraane jaun jetaote: ‘Saan, aihachuhisi. Nocoa nii ii rebe. Fosachoonca costaronejeeicha cau teein laenaaunra,’ nae jetao rai. ");
INSERT INTO uraNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nitohaneein jetaote, jataain nainaain rai caohachanuhacha que coacuhin ichaa nii rai loreri beraichane que nainae nii rai fatoroon. Nitohaneeinte Cana Coaunera Cojoanonaa que neenihuru amurijiriin, jataain nainaain rai caohachanuhacha que coacuhin neeure Cana Coaunera coitucuhichuru,” naane baiha jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Inara netonoaite nii rijijieein Cana Coaunera tenojoi beraichaneein neeiche. Aihane jaun nii itolere inara rai Cana Coauneraacha teei que, aca jerihane rijijieein niicha jerei ichaain neeuche, inae ohichene bana niha raotojoeein inara raeranune coina. ");
INSERT INTO uraNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nitohanihane jaun, aansijiin laojoiri raa cachane niha natiin caohachaain nii rai teraacha jerei icharate, arajiin cha raane jerichanejeein caohachaain ichareein. ");
INSERT INTO uraNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nitohanihane jaun, caa nitajerai nenaa chauratane que cha siriin neeichene nihanatiin caohachaain ichaeneeichene coatiha nerinaai inara rai esinaen rauhijiriin chabana nitajenaacharanejeein nenaa tera. ");
INSERT INTO uraNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aihane jaun, inara rai eroraqui tenojoi que caohachaain cha ichaain neneeichene, coatiha nerihaain inara raineein neeninu tera. ");
INSERT INTO uraNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nihei chuni coroatajai fatoroon rai niicha latei icharaneein nenaa nainei, nabana leeocha que jaolecohin, leeochaacha ere tonorana nainihane jaun. Nitohanihane jaun Cana Coauneraacha ere tonoraain nenaa jerichaane, nii canaacha jerei que coaauna nainihaaca,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Niritoha Jesosone jana aonajeein jetaote, Jesoso necoeje chanuure fariseeocuru, acaauru jataain coriquiicha que coacuhin neeuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nii jaun jetaote, “Inarate caohacha ichaa nocoetiin neeiche itolere bana cachaauru notaracaae. Nete inara suujua cuhane inaraacha coacui coitucue Cana Coaunera. Nitohaneein jataain nelateineein cachaauruhacha coarai que te jaoleque Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moisesa, chaen profetacuru, naaonjoainuri cojoanonaate turuha Joaan Baotisitane que tiaaojoaain nelu. Nii caje coauneeinte beebejenojoineein nelu Cana Coaunera cojoanonaa canuhacha turuai. Nii quete necounujueeure nii canuhacha teei Cojoanonaa sirichuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Canu Cojoanonaa que neeichene nihanatiin satiin Cana Coaunera rai rauhi inoaensi tonoraain neeichenete caohachae. ");
INSERT INTO uraNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Leinjiin cacha rai comasai jaohin leeocha ene raanete jataain osa que nesaruha aicheein. Jerichanejeein techu, lana joaera ene raain niha cachane osa que nesauruha aicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Niha jetao leinjiin cacha jataain coriquihonaneein. Nitohaneein coriquihocane jaun jetaote, itolere bana jataain cajione caohacha que necoreeteein, lenone caohacha nejesina que beseta ichanajaque. ");
INSERT INTO uraNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nii jana jetaote, ecu ne jaberoco nainecojoaain abero siriin leinjiin cairicheinejeein nenaa Lasaro. Aca jetaote, nii coriquihona loreri chajeniha lauheque nejesinane atanichoae. ");
INSERT INTO uraNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nitohaneein cairicheinejeein nihane jaun jetaote, nii coriquihona rori caje nalunaa rai lenone coni raain que lenonena jere nii cairichei. Nii jana remaaecuru jetaote, rohan turuhacoaain nii rai nabero lojoihure. ");
INSERT INTO uraNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nitohaneeinne baiha inaen oha nii cairicheinejeein nenaa- nii Lasarone jana jetaote, amaaure anjeraauru Abaraaun aina dedeeu nihane coina. Nii jana jetaote, nii coriquihona netonai inae ohane jaun conautecure. ");
INSERT INTO uraNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nitohaneein ohin necairichaauruha onacaaurune jaan netiin necairichajeein, nita icharajeriin neein Abaraaun coaaraa nii coriquihonane jana jetaote, Abaraaun rohan ne nii jaiti jiniiquiin ichaaoruhane bana niicha cairichaerii Lasaro. ");
INSERT INTO uraNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nii jaun jetaote: auhaquiin: ‘Cairichaaojoaain cacoharaaura ofa Abaraaun. Atiin nii Lasaro rai aitoote, esinaeca que biji coturi macohin setejiaain calele jelaroaa uhinera. Caune jataain necairichajeeun usi tabai janara,’ naane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘Aiha chuhisi niqui. Nete jiniiquiin inara jaberoconeein ichaohichene bana, jataain raotojoei ichaonaa que ichaorejetohilura cacalabi. Nii jana caa Lasarote, jataain ichaonaa baaso que ichaohin cairicheinejeein nerejetelu. Nii jaunte nii coacuhin, necairichaaequi iine jana, aca caohachaain ranojoineein nera. ");
INSERT INTO uraNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nii choae tacaain techu, cana cataaun ne jataain ucuacaain ucuha jachu satonoelanaalara. Nii jaun nii inara nichae situnaa nainecuruhi cajicheique nenacaauru. Niheichu inara niha natiin nii cajicheique turunaa nainiheeicheta,’ nae jetao Abaraaun, nii coriquihona onaa rai. ");
INSERT INTO uraNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Niritoha raine jaun jetaote: ‘Nii jaunne ichei aitoon, canu inaca loreri asaae ");
INSERT INTO uraNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nii neeuruha saoquii canu nejeraaurune jaaun Lasaro letohaine, acaauru rai iriha cuhane coina. Nabana caa necairichaecaaunne jaaun acaauru netonai uuruhane coataara, ofa Abaraaun,’ naa nii coriquihonane jana jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","‘Nete Moisesa aina profetacuruhacha laenanohin siriin neeure, nii tonoraain neeuruhinera,’ naa Abaraaunne jana jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Aiha chuhisicha ofa Abaraaun. Nete acaauru rene ichanaain turuhin biha leinjiin onaane, acaauru netonai nii esenetana nainecururera,’ naa nii coriquihonane jana jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Aiha chuhisi niqui. Nete Moisesa, chaen profetacuru, naaonjoainuri esenetaaurenihalune rijijieein, acaaauru rene ichanaain turuuruha onacaaurune nihanatiin, esenetana nainecurunerera,’ naain tonorae Abaraaun,” naain jetao fariseeocuru suujuate Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Niritiin jetaote: “Itolere banate nereein osa que inara sarueranu. Nete laen jataain necairichanaa coaareein nii osa que leeochaauru saruera cacha. ");
INSERT INTO uraNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nitohaneein caa ena Cana Coaunera coitucuhajeraauru sarueratiha osa quene ajinihate caohachare nulunoque ajeri tijichaain cucuana cuhane joaeratenojoi nihane. Aihane jaun nii que necohalajiin neeuche. ");
INSERT INTO uraNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chatohaneein baaso ichaain niha ii nejerane suujua teeu. Suujua teeine jana ii ere tonoraain caohachaain nichao coreein nihane que ii suujua acateeu. ");
INSERT INTO uraNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Lejiichoo cuhane caaunsi saneein ichei baaso ichaain nihane nihanatiin, caaunsi saneein turuhin, ‘Inae laen coaiterihaaunnita,’ naa uhane, que ii suujua acateeura,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nii jana jetaote: “Jataain itolere ichana nainiha Cana Coaunerane esenetaain nihacaanune jaanu teeu canacaanu raicha,” naauruha Jesoso rai niicha cocoainaauri afosotoorune jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","“Mosatasa ucuhe laojoiri jataain aansijieein nenaa rijijieein aasaeriin esinae rauhijiriin esenetaaichenete caa shabeento rai: ‘Niilai caje nerocohin caa cucuana cuhane omaronihunra,’ naaiche caa shabeento raine inara ere tonoraain aiche caa shabeentora,” naain jetao acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Niritiin jetaote: “Inara leinjiin cachaaoquichene jana, inara ocoana jana temule jaane jaanu que atane retuhin, baca beraain, naaonjoaanne caje cauhane janate rai: ‘Nelauriaaute lenoneei,’ nanaa coacuhelanaala: ");
INSERT INTO uraNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","‘Chajaain ena canu lenonenu jaain, ena uhaaune lenoneein acau coe. Nii baihate ii netonai lenoneein acau coriquiincha,’ nariquiche. ");
INSERT INTO uraNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nii choae tacaain techu, ‘Narihara,’ nanaa coitucueneeiche nii inara cacha rai, letoaain neeichene jaan ichaain nihane coreniha. ");
INSERT INTO uraNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nii rijijieein inara letoaain niha Cana Coaunerane jaan nainaain neeichene bana, nainiheeiche: ‘Jataain cacha caohacha neeine nihacaanura’ naain erenaa nainiheeiche. Raujiaain: ‘Canacaanu letoaain nihalune jaanchane inae nainacaanura,’ naauche,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerosaleeun cuhane jaun jetaote, Calileea, Samaria, naaonjoainuri batane cataaun situhin cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nii jana jetaote, leinjiin neseu turuhane jana jetao, nii nese caje que tacaa cuure lechooncaain cosibi caaun cunaitenacaauru cachaauru. Nitohaneein cuhin jetaote, cocoaaeraa cacha rohan turuha nitohanai cunai aonaera cachane jaun jetao, Jesoso caje coriaae netiin: ");
INSERT INTO uraNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Cairichaaojoaain nohane canacaanu coaraaura cacha relaera Jesoso,” naaunre jetao Jesoso rai ehequiin. ");
INSERT INTO uraNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Niritocuruha raine jana jetaote: “Chajaaincha saseredotecuru rene turunichuchete inara coaracurumiincha,” naa acaauru rai Jesosone jaun, cuujueeuruhane jana jetaote, inaen cosibi caje nerautaain somaraain neeure, acaauru dadaelanaala aitoha Jesosone saijieein. ");
INSERT INTO uraNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Inae nitohaneein nerautaauruha acaauru cosibi cajene coaraain jetaote, jelaiha nejenohin cuhin, tonijiaain ereein Cana Coaunera coroajeein jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesoso acatiha rai tijia asae atanichoae neseeoriaain jetao, rachoojoe leinjiin cacha Samaria cocoaicha Jorionelaanaa nenaa. ");
INSERT INTO uraNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nii jaun jetaote: “Tajian lechooncaauruhani caa cosibi caje nerautanacaaurune. Aancaauru chaen leeochaauru iscoon neeurita. ");
INSERT INTO uraNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Leinjiin caa Jorionelanaala nenaa cacha estaraajerohachate jelaiha nejenohin Cana Coaunera coroaeca uhe rautaanune corenihara,” naain ");
INSERT INTO uraNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","“Esinae rauhijiriin esenetaaine jaunte, ii cunai caje nerautaai, chajaain nimichuhin caunihura,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nii baiha jetaote, “Chabana turureein Cana Coaunera cojononaa,” naain jetao Jesoso caje bajaaure fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nii jaun jetaote: “Coatiha inanacaain tururinaain Cana Coaunera cojoanonaa. Niheichu, ‘Caute ne. Tajihate ne,’ naain coitucurieeicheein. Inaen inara jana niha quiicha tei Cana Coaunera Cojoanonaa,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Niritohane baiha jetaote, aina nerelanacaauru rai jetao: “Inae amuhanune baihate jaiti nacoauneein turuenihanune ajiniha le janojoeeinniji ena caa canuhacha tei janonaa coarana jereriquicheein niqui, nete coaraeneriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nii jana tabaaurute inara rai, ‘Caute ne. Tajihate ne,’ naaurureein. Nete nelatene, niritocuruhane jana acaauru esenetaain acaauru sacuhichene. ");
INSERT INTO uraNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nacoauneein turuha urichaaunni acaihaniji cachaneein nejanohanaane Cojoanonaa que turuhane banate, charijijieein teeinti jeraneeojoaain dede conaa jiacanone, saain coaanojoineein ne. Nii rijijieeinte saain coaanojoineein coitunojoiniha cureein inae nacoauneein turuhanune bana. ");
INSERT INTO uraNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nete amuhanune ajiniha jauriaanejeein jataain canu que nererojoecaain canu que jaolecoorureein, caa ena cojoanonaa que nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Charijieein teeinte nihalu Nohene bana ailu, nii rijijieeinte jerichanejeein aiha cureein nacoauneein turuha uhanu canu acaihaniji Cachaneein nejanohanune Cojoanonaa que tihane bana. ");
INSERT INTO uraNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Coaracuche nachuhinti nii chaque nererojoecaaeriin nelanaala, nisirihateein, lenoneein, acau cohin, naaonjoaaunruhalu cachaauru bote cuhane enohin nichotiha Nohene cojoanonaa que turuhanereein tiaaine. Nii jana uha elo tabaine jaunte satiin ohacoaaurelu. ");
INSERT INTO uraNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nii rijijieein techu cha coacuelanaala raotojoeein neein, acau cohin, lenoneein, netemulijiaain, namihaaneeo que necoreteein, niicha latei coreteein, neloheriteein, naaonjoaaurelu cachaauru nihalu Lotone bana. ");
INSERT INTO uraNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nii jana, Sodoma neseu ichaohane caje amuha Lotone janate, usi aina naluha asofere dede cajene jaun caaun satiin oorelu cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nii rijijieeinte jerichanejeein aiha cureein nacoaauneein turuha uhanu acaihaniji cachaneein nejanohanaa nichaaunne Cojoanonaa que turuhane bana,” naain jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Nii cojoanonaa bana inara loreri janori ichoae neeichene, jiaonriha jelaiha fauhin inara loreri caje inara rucuhele ranaa coaauquichene. Niheichu inara ocoana jana neeichene jana aihane, inara loreri asaae caunaa coacuelanaala rauhijiriincha sorooche. ");
INSERT INTO uraNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nitohanihane jaun, niicha ratirii coaaucane jaun aihalu Loto comasaine coacuhin nainaain ichaaoche. ");
INSERT INTO uraNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aihane jaun rai rucuheleeuru queecha coacuhin neite rai nichao itajereein. Jana nii rucuhele que coacuelanaala nichao rainuhachaque coacuhin neite nichotereein,” naain jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nii airichaainne cojoanotiin banate, leinjiin eruhari cuhane niha cuurureein coroatajai cachaauru. Nii jana leinjiin amanojoinihane janate, ecu nedaa cureein leeocha. ");
INSERT INTO uraNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jana coroatajai enecurute, ederi que chaelai tutuurureein. Nii jana leinjiin amanojoinihane janate ecu nedareein leeocha. ");
INSERT INTO uraNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nii jana coroatajai quichaaurute nocohana jana neeurureein. Leinjiinte amanojoinereein, leeochate ratirinojoinereein,” naane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","“Chatoanai bana, chucha nitohanereeinte Curuaanaa,” naain caje bajaauruhane jaun jetaote: “Inae ecu tihane banate coitucunojoinereein, canii setu que fauha uha ichotarine jana caje coaraain coitucunojoinihane rijijieein,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Coiinteerilanaala Cana Coaunera bajaauruhane, Cana Coaunera bajaauruhane coina parabola que cuaain acaauru relaa Jesosone. ");
INSERT INTO uraNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Niritiin jetaote: “Coaracuchenachuhinti leinjiin neseu nihalu jetao leinjiin joesio cachaauru que suujua acatelanaala, niheichu Cana Coaunera batohane que casilanaala nenaa ne. ");
INSERT INTO uraNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nii jana jetao, nii neseu ichoae leinjiin autana. Nii autana jetaote, nii joesio rai leinjiin cacha nejeratenaja colurujiha cue. ");
INSERT INTO uraNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nii jana jetaote, carajaain nirijieein nere tonorana jerelanaala ne nii joesio. Nejetaote nii baiha: ‘Cachaauru que nihanatiin casuujua acateein, niheichu Cana Coaunera batocoaaunne que casiin nihaaun niqui. ");
INSERT INTO uraNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nena raotojoeein nihanune rerohecaain, casuujua rerohecaain sacuha caa autanane coataa naitoonjoa tonoraain ichareeun caihanihane coina,’ nae nii joesio. ");
INSERT INTO uraNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Coaracuchenachuhinti, jataain necha aansaineein nihane saijieein suujua coaraa nii joesione. ");
INSERT INTO uraNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nii jaunte nii amurijiriin, nii janijiin nii raauri, janotiinetojoeein, jiichoonetojoeein, naaonjoaain bajaaebajaeraauru cocoaaeratenaa nainereein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nitohaneeinte carajaain cohacuruhane latelanaala enaacha acaauru cocoaaeratere. Nena laen inara caje bajaaun, canu inaraacha cohajei cachaneein nejanohanaa nichaaunne, nacoauneein turuhanune reeintiaainacha canuneein nihanune esenetaain caitoonjoa ichaaechajeein neeururichaain cachaauru,” naain jetao acaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nii baiha jetaote, nii acaauruhacha caohachaain niha nocoetiin leeochaauru que jaoleconacaauru rai jetao, acaauru ichaohacha que parabola que cuaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Coroatajai cacha jetaote, Teenforo asae cuhin Cana Coaunera bajaa cuure. Leinjiin jetaote, nechu jataain naraaichuru cairichaa Roma rai impoestonu que coriqui bajaerane. Jana leeocha jetaote fariseeone. ");
INSERT INTO uraNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nii fariseeo jetaote, ‘Narihara Cana Coaunera ichoreniha ainacaauru tocohaneein asijiautoneein, necha aansaineein ichaohin, joaereein ene canu sinijeranelanaala nenaa aina ichaohin, naaonjoaain nenihanu canune coreniha. Chaen nechu, naraaichuru cairichaa Roma rai impoestonu que coriqui bajaaurera rijijieein neneeun. ");
INSERT INTO uraNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Chaen nechu, jataain ii coitucuhanune esenetaaine coina, le semanacuru cuhane coroata saain casuri couu lenone lanaala neein ii bajaae bajajeein, lechooncaain chaaelai raanu camijianeeo corenihane, rai lechoocani teein neeun ii raicha,’ naain jetao Cana Coaunera bajae chujuhequiin. ");
INSERT INTO uraNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nii jana nii naraaichuru cairichaeriin coriqui bajaera jetaote, caje icharaain neein necoeje caaun najabaracaain dede coaraelanaala jetao: ‘Cairichaaojoaain cacoaraau osaaotohanune jaaunra Cana Coaunera,’ nae nalarijia faone faoneein. ");
INSERT INTO uraNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Niritiin bajaane jaunte, inae que suujua acatiha Cana Coaunerane jana jelaiha nenajaun cauha cue nii naraaichuru cairichaa coriqui bajaera. Nete laen nii fariseeo que suujua acatene Cana Coaunera. Nitohaneeinte nii leeochaauru amurijiriin Cana Coaunera coitucutiin, itolere que nelaaetoha nocoetiin nenacaaurute chaque nelatelanaala jaoleneein neeurureein. Jana rai nichao coitucuhin leeochaauru amurijiriin nenaa coacuelanaala nenacaaurute nelateein ranojoinecurureein,” nae. ");
INSERT INTO uraNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesoso rene canaanaihuru turuaa uuruha acaauru mucuhane coinane jana jetaote, Jesoso rene turuanajaauruhane caohateeure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nii jaun jetaote, nii aina nerelanacaauru cotijiaain jetao: “Coa rerohecanajaachete canu rene turuuruhine nii canaanainuru. Jiaonriha canu rene turuuruha canaanaihurune caohateeichenera. Cana Coaunera Cojoanonaate, aihuruha caa canaanaihurune rijijieein nenacaauru raineein nenaa nera. ");
INSERT INTO uraNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Esinaen rauhijiriine inara rai aitoreeunni. Aihuruha caa canaanaaihurune rijijieein canu raain neniha chunine, coatiha Cana Coaunera Cojoanonaa que nerihaain,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Leinjiin cocoainanacai jetaote, Jesoso aina iriha uhe. Nitohaneein rene turuhin jetaote: “Caohachanejei cacha relaera, cha ichareeun chariji bana nitajenaachara ichaonaa caohacha que ichaonaa nainichaaunne coina,” naain Jesoso caje bajaane jana jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Chanuna ‘caohachanejei cacha relaera,’ naain cacurujuateei. Leinjiin Cana Coauneraachate caohachanejeein ne,” naain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“Inae raotojoeein Moisesa aitoonjoan coitucuhi: ‘Jiaonriha nejelau ene ii sinijeranelanaala nenaa aina ichaohin neeine. Coa sonajaain jaoha. Coa asijiauha. Coa chamute cacha cairichanaa jerenacaaun chuni cacha coacuhin, casaje que ereein niha. Chaen efojiaraauru que ii suujua acateein acaauru coitucuhin neeun,’ naane coitucuhi,” naa rai Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Aihanu chujian. Canu enamanaca caje coauneeinne jitariin nii naitoonjoan tonoraain neeun,” naain tonoraa nii cocoainanacaine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","“Aihachuhisi niqui. Nete jaiti lanajejen leinjiin tonoraain ichaaine coina. Jitariin nii iicha sirii rucuhele que necoreteein, cairicheihuru rai jitariin nii coriqui chaluu. Nii banate dedeeu ichaonaa caohacha que ichaonaa naineriquiin. Nitohaneein ichaaine baiha canu aina uu,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nejetaote niritoha rai Jesosone jaun, jataain inaderae nii cacha jataain coriquihocane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nii jaun jetaote: “Jataainte caaintate Cana Coaunera Cojoanonaa que ichaoa leinjiin coriquihonane. ");
INSERT INTO uraNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nii Cana Coaunera Coajoanonaa que ichaaoruha coriquihonacaaurune coina caaintaane fautaain caaintarihei leinjiin camecho rai oco jachu cuhane situhane coina,” nae jetao inaderaa nii coriquihonane coaraain Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nii jaun jetaote: “Nitohanihane nichotenaa nainerinaain chuni,” naain caje bajaauruha ecu neein aonajeeunrerane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","“Nii caaintatiin cachaauruhacha coarai, coatiha Cana Coaunera rai caaintajiehita,” naa Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","“Canacaanune jitariin canacaanuhacha sirii ratiriin ii sacuhacaanulu,” naa Fedorone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Esinae rauhijiriin chunocoha, Cana Coaunera Cojoanonaa que ichaohane coina, rai loreri, rai sinijera, rai bereecuru, rai nejeraauru, rai fojiaraauru, naaonjoin ratirichate, ");
INSERT INTO uraNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jataain nii amuritoheriin caa chauratane que siriin, nii choae tacaain nii turuha uheni Cana Coaunera Cojoanonaa que chariji bana nitajenaachara ichaonaa siricheeincha,” naain jetao Fedoro tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nii baiha jetaote, jelai nii lechoonca coroatajaain niicha cocoainaauri cotijiaain jetao: “Enate laen Jerosaleeun cuhacache, cuu nii acaihaniji Cachaneein nejanohanaa nichaaunne que aitiin laenacuruhalu satiin profetacurune nainaanune coina. ");
INSERT INTO uraNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nitohaneeinte nejelau ataneu nenacaauru estaraanjerooru bijihu canu teeurureein nechu jataain cacotaiha baasoneein caeteein, canu nocoeje chanuhin, canu coluneein, naaonjoaaunruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nitohaneein canu teeinte, enuha que canu faohacuruhane baiha canu ateinaa cuurureein. Nena nichata janohane cuhane nacoauneein ichanaareeunni,” nae jetao niicha cocoainaauri rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nii niritoha acaauru raine jana jetaote, nii naitoonjoan aonacuruhane saijieein esenetana nainecurene. ");
INSERT INTO uraNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Niritohane baiha jelai caje amuhin Jericoo turue lalajeein cuujiha Jesosone jana jetaote, bero cuhane lauhequiin coriqui bajaa niha leinjiin maosane jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","arajiin situha cachane aonaain jetao: “Chaauruna toon situha cue,” naain bajaane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Nasarete cocoaicha Jesosote sacuureraaura cachaauru aina situha cuera,” naain beeuruhane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","“Atiin nohane cairichaaojoaain cacoharaaura Rabiri nefoerate Jesoso,” naa ehequiin nii maosane jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","niritohane caohateeure sitonaane coina nii ichohaichaniha cunacaauru. Nejetaote, acaauru ere tonoraelanaala jeelai amuritoheriin ehequiin jetao: “Atiin nohane cairichaaojoaain cacoharaaura Rabiri nefoerate Jesoso,” nae jetao nii maosa. ");
INSERT INTO uraNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nii jaun jetaote, ecu inacuhin raerateein jetao inaen rohan nichuutaane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Chate jereeita,” naain caje bajaa Jesosone jana jetao: “Canota rautaainene jereeunra Curuaanaa,” naain tonoraa nii maosane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Saan ai. Esinae rauhijiriin quesenetaaine jaunte inae maosaneeine caje nerautaaicha,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Niritoha rai Jesosone rijieeoritiin maosanihane caje inae conoha rai notane jaun jetaote, Cana Coaunera coroajeein Jesoso sacue nii maosa. Nitohaneein nii maosa rautaane jana, ecu neein coarajeeurera cachaaauru netonai jetaote, satiin Cana Coaunera coroajeein rachoojoeeure. ");
INSERT INTO uraNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericoo turuhin jetaote, nii Jerico nese cataaun situha cue jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nii jana jetaote, ecu ichoae leinjiin cacha, naraaichuru Jorioocuru cairichaeriin nenaa, Roma curuaanaa rai impoestonu que coriqui bajaaurera curuaanaaneein nenaa coriquihona Saqueeo. ");
INSERT INTO uraNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aca jetaote, jataain Jesoso coitucunaa jerihane jaun coaana jere niqui. Nejetaote, jataain araaicha cachane jaun coaana nainesine Saqueeo, leeochaauru fautaain ecoainijihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nii jaun jetaote, coaana nainihane coina soroneein najiniha cuhin jetao situha curichaain nii Jesosone jaaun nenaa leinjiin enuha que iniin jetao cohaca cue. ");
INSERT INTO uraNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nii jana jetaote, nii iniin cohacane jaan nenaa enuha asaae situha cuhane jaun, jabatoroaain coaraain jetao: “Saqueeo, chajaain soroneein niilai caje fauha uu. Enenene ii loreri asae nesurureeunni,” naa rai Jesosone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","soroneein nii enuha caje fauhin jetao, coroajeein rai loreri asae Jesoso amae jetao nii Saqueeo. ");
INSERT INTO uraNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nii coaraain jetaote: “Chanuna jataain osaaona niha taa cachane coitucuhane saijieein rai loreri asae aina nesuruha cue,” naain jetao Jesoso que ereeure ecu satiin neein coarajeeurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Niritiin Jesoso que ereeuruhane jana jetaote, nichaauraain jetao: “Aonaaun Curuaanaa. Jitariin quiicha sirii rucuhelene leruhin tereeunni cairichaaihuru rai. Chaen nechu chaaelai que chuni basijiauhin nihanune, jena saain jelai amuritoheriin cainareeunnicha,” nae jetao Jesoso rai nii Saqueeo. ");
INSERT INTO uraNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nii jaun jetaote: “Caa cacha netonai inara rijijieein, Abaraaun nefoerateneein nihane jaunte, enene caa rai loreri asae turue jianacoon osa caje mitaeranura. ");
INSERT INTO uraNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nii acaihaniji cachaneein nejanohanaa nichaaunnena, caa chauratane que turuun, nii jaolecohichene jaan cachaauru nitajenaa neein nenacaauru ariin, acaauru ichoterateein raanune coina,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Niritoha Jesosone jana, ecu neein aonajeeuruha cachaaurune jaun jetaote, acaauru relae parabola que. Inae Jerosaleen rohan nichuuntaauruhane jaun, “Inae jerihane turuhelalajiha Cana Coaunera Cojoanonaara,” naain coaaucuruhane jaun jetao acaauru rai: ");
INSERT INTO uraNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Coaracuche jetao nihalu leinjiin cacha rey araaineein nenaane. Nii cacha jetaote, rey ineein cocoainaauruhane coina jetao coriaji atane cue, inae rey ineein cocoainaauruhane jana jelaiha natane que cauha uhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Inae amuhane rai jetaote, lechooncaain rai letonocuru cotijiae, acaauru naineein jequiin coriqui chaluhane coina. Nitohaneein acaauru cotijiaain coriqui chaluhin jetaote: ‘Caa coriqui aina amihaneeuche turuhanune reeintiaaincha,’ naain ratirinajae. ");
INSERT INTO uraNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nejetaote, jataain que nererojoecaaure nii natane que nenacaauru cachaauru. Nii jaun jetaote, caaijie acaauru ere beranu que leinjiin letoaaure ‘Coatiha canacaanu curuaanaa rey ineein niha caa cachane jerihacaanuta,’ naa cuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nejetaote nitohaneein nere bera letoaauruha caaijiene sajieein, rey ineein cocoainaauruhane jaun, rey ineein jelaiha natane que turuha uhe. Inae nenajaun turuhin jetaote, nii letonocuru coriqui teein ratirihane jaaunru cotiharate, ‘Inaaonjoaaincha canu coriqui joocure le cacha cachaauruta,’ naain coitucuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nii jana nii niicha cotiharatei ichoaichaniha rene turunaa jetaote: ‘Curuaanaa lechoonca saneeinte nefae ii coriqui,’ naa turuhinne jaun jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Saan. Aihane jaun iite jataain caohati canu cachaneein neei. Inae acaihaniji que caohacha ichaai caa coroatajaji coriqui ainane jaunne, lechooncai nese coaaranu que coberenadoroneein chetereeunnicha,’ nae rai nii rey. ");
INSERT INTO uraNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nii jana leeocha jetaote: ‘Curuaanaa, saoqui saainte nefae ii coriqui,’ naa turuhinne jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","jerichanetojoeein: ‘Saan. Aihane jaun saoquii nese coaaranu que coberenadoroneeinte neriquiincha,’ nae jetao rai. ");
INSERT INTO uraNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Nii jana leeocha jetaote: ‘Curuaanaa, nocoa ii coriqui. Jataain necha aansai cacha neeine jaunne ii coasiha, cajione que conajaain cau rucujueeun. Chaen chaelai teneeine nihanatiin, enaacha temunojoi taain raain, naaonjoain neeine coitucuhanune jaun,’ naane jaun jetaote; ");
INSERT INTO uraNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Ichaajenihanete ii ereecha que necouluruhequi canu cacha baaso. Chanuna chaen, nii chaelai tihanune que airijiin, enaacha temunojoi taain, raain, naaonjoaanune coitucuhi raotojoeein inatiin, ");
INSERT INTO uraNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","baanco cuhane nii canu coriqui tiha cueneei, canu loreri asae turuhanune, jelai amuritoheriin carai cainaainerichaae,’ naain jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","nii ecu nenacaauru rai: ‘Caje nii coriqui ruluhin, nii lechoonca saneein faera rai teeuchera,’ naane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Curuaanaa, chanuna inae lechoonca saneein jelai amurijiriin siriha natiin nacoaauneein tenacare raita,’ naaunruha raine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Inae inara rai aitocoaaun, jataain siricha raite jeelai amuritoeeriin terareein. Jana sirihei cajete, coroatajajeein sirihane nihanatiin jitariin caje ruluherareein,’ naain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","‘Chajaain chaen nii rey ineein nihanune jerelanaala caque nejeratenacaauru uhaain cau canotaracaae teein sohin jaonajaauche,’ nae jetao nii rey,” naain jetao cachaauru relae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Niritohane baiha jetaote, Jerosaleen cunajaun, ");
INSERT INTO uraNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","nii Jerosaleen rohan ichuunejeein nenaa ichatane ucuuno Olibo neeonjoain neein niicha curuateeuri rohan nenaa Betafajee, Betania, naaonjoainu turuhin jetaote, coroatajaain aina nerelanacaauru rai: ");
INSERT INTO uraNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Chajaain taa cana ajiniha nenaa neseeu cunichuche. Ecute cositenojoineein teequi leinjiin boro chabana cacha amunajaniheine eruriquicheein. Chaen cajiha carai cosi rutuhin uhaauche. ");
INSERT INTO uraNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Inae uhaaichene jana, ‘Chanuna nii boro cosi rutuhin amaaiche,’ naa chunine, ‘Cana Curuaanaate latihane jaun raeratera,’ naauche,” naain jetao letoanajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Niritiin acaauru letoaa Jesosone jana, nii neseu cuuruhane jaun jetaote, nii acaauru rai aitohane rijijieein nii boro eruha cuure nii aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nitohaneein ecu turuhin, nii boro cosi rutuhajeeuruhane jana jetaote: “Chanute nii boro cosi rutuhicheta,” naa acaauru rai nerorane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Cana Curuaanaate latihane jaun raeratera,” naaure jetao rai. ");
INSERT INTO uraNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nitohaneein cosi rutuhin jetaote, nii boro ichoae rai cajione teein jetao, Jesoso rene amaaure nichoae nelauriaain cuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nitohaneein nii boro amaain Jesoso rene turuaauruhane jana jetaote, nichoae nelauriaain raotojoeein cuujiha Jesosone jana jetao, najiniha bero cuhane rai cajione maririjiacoaaure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Inae Olibo neeonjoain bichatane ucuuno fauque cuujiha Jesosone jana jetaote, itolere cojoaelanaacojoai ichanajaaoncane coaranajaaoncuruhane jaun jetao, cojioriin Cana Coaunera coroaecure satiin nii sacuurera cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Raotojoeein turuhine aca neein nenaa rijijieein cocoainaain Cana Coaunera letono Reycha. Dedeeu raotojoeein nihacachene coina icharaneein nihane coitucuhin Cana Coaunera coroaecuruhine cachaauru,” naauruha cachaaurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","“Cacha relaera, toon ii sacuurera cachaauru rai aitoote, toritocuruhane jianecurumiincha,” naauruha nii cachaauru jana cunacaauru fariseeocuru tabaaurune jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","“Esinae rauhijiriine aitoonra. Toritocuruhane caje inauheneecha neeuruhanete, cojiorichurureein caa ajerichurura,” naain jetao tonoranajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Inae Jerosaleen rohan nichuutane jaun, inae inanacaa nii Jerosaleenne coaraane jaun jetaote, ecu nenacaauru cachaauru coreniha chanaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Bajiaana chuhinti caa janonaa cuhane jianacoon inara mitaeraanu que cau turuhanune coitucuhin neneeiche. Nete quesenetaain canuneein nihanune coitucuhin coarana naineneeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nitohaneeichene jaunte, inaen nereein itolere neein inara curuhacaain inara corihateein, inara mucuhin niha nii nejerateein neeiche jaa cojoanonaara. ");
INSERT INTO uraNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Caa inara nese fejeeinte itajeein, inara cocoaichucuru soaajeein jaoha cuurureeincha. Coatiha nerinaain leinjiiniji ajeri ita choae teein ichanohita. Inara ichoterateein, jianacoon inara mitaeraanu que turuha uhanu inara Coauneraneeinne jana canu esenetaain cacoitucunaa jereneeichene corenihara,” nae jetao inaderaain Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Inae Jerosaleen turuhin jetaote, Teenforo asae enohin, ecu necoretiha nenacaauru sitaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Cana Coaunera Quiricha inoaensi cuhanete aite: ‘Canu lorerite nasae neein canu bajae bajaaecuruhane jaan coloherine,’ naain. Nete necha aansai asijiautooru ucuhaneein teeiche inarara,” nae jetao nii cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nitohaneein cojoanoonetojoeein Teenforo asae cuhin cachaauru relaa Jesosone jana jetaote, nechu jataain sohin jaaoruhane jaa lera ariha jetao, cuhin coaracure saseredote curuanaacuru, Cana Coaunera naitoonjoa que cacha relaaureraauru, nii nese curuaanaacuru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nejetaote, nii chatohaneein teeuruhane jaan lera erusichurene, satiin cachaauru jataain nii acaauru relaane jaa rautatiin aonajeeunruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Teenforo asaae nosa caje nichoteeururichaain cachaaurune beebejeein, acaauru relaa Jesosone jana jetaote, turuha cuure saseredotecuru curuaanaacuru, Cana Coaunera naitoonjoa que cacha relaaureraauru, Joriocuru rai nelateein nenacaauru ichauhenaauru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nitohaneein turuhin jetaote: “Chatohanai cocoainanacaineeina neei catohanai ichaaine coina. Chate catohanai ichaaine coina ii cocoainaain ii letoaain neta,” naauruhane jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","“Saan. Canuhetonaina inara caje leinjiin erenaa bajareeun catoonraaichene coina. ");
INSERT INTO uraNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Cha Joaan letoaain nelu cachaauru baotisaain cachaauru coujunacatiha uhane coina. Cana Coaunera letoaenihanena, cachaauruhachana letoaain nihalu,” naain acaauru caje bajaa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ecu inauheneeicha aonajeein jetao: “ ‘Cana Coaunera letononeeinte ailu,’ naacachenete: ‘Chanuna jana esenetaain tonoraain neneeichelu,’ nareein. ");
INSERT INTO uraNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Niheichu, ‘Cachaauru letononeeinte ailu,’ nanaa nainihaacache. Niritocoaachenete ajeri que cana bodoosiin cana sohin cana atinaaurureein cachaauru, satiin Cana Coaunera letononeein aihalu Joaanne esenetaauruhalune jaun,” naain jetao, ecu nejesinajeein ita rai ereerejeeuruhane baiha jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","“Coatiha coitucuhaacaanu. Chachaainti cacha baotisaain coujunacatiha Joaanne coina letoaain neluta,” naaure jetao. ");
INSERT INTO uraNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nii jaun jetaote: “Niheichu canuhetonai nihanatiin ‘Naaonjoainte canu cocoainaain nihane ainane, caa catohanai ichaaunra,’ naain benaa nainihaaun inara raita,” naain jetao acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Niritohane baiha jetaote, necha aansaineein ichaonacaauru ocoana beraihurera que parabola que cuaain jetao: “Leinjiin cacha jetaote, leinjiin ocoana sirihane jaun jetao, que amihanenacaauru rai teein ratiriin jetao, coriajai ataneu cue, latihane naineein raineein nenaa letoaauruha raine coina. ");
INSERT INTO uraNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nitohaneein teein ratiriin jetaote, inaen tainaca que tihane jana jetao, leinjiin letono letoae, nii amihanenacaauru caje raineein niha nii ocoanane coreniha que banihateein niicha taihuri bajaa cuhane coina. Ne jetaote, nii cha telanaala faojoaain sohin jelaiha letoaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nii jaun jetaote, nacoauneein leeocha letono letoaa nii ocoana erorane jana jetao, nocoeje chanuhin faojoaain sohin, cha colane acaentonai letoaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nii jana coaiteen leeocha letono letoaane jana jetaote, jataain cunaitaain jelai caje acaentonai sitaaure nii ocoana que amihanenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nii jaun jetaote: ‘Cha laen ichareeun. Satononejeein caa jataain jereein canuhacha belaai canu calaohi letoaanunete ne. Quete laen acaneein nihane coitucuhin raotojoeein raain nere tonoraaurureein,’ nae nii atane erora. ");
INSERT INTO uraNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nejetaote niritiin nii rai calaohi letoaane jana jetao, cuujihane jana coaariin: ‘Taate caa atane erora calaohi ne. Acate inae oha rai inacane bana, caa itolere que banijiaain nenaa rareeincha. Coanete mucuhin sohin jaohacachete cana raineein nedaaine caa iolere que banijiaain nenaara,’ naain ita caje bajaacoaain jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","nii ocoana caje amaain sohin jaaore nii ocoana que amihanenacaauru. Nitohanihane jaun, tonaquiche jana nii que inara. Chatohaneeicha acaauru tereein nii ocoana erora, nii rai calaohi mucuhin sohin jaaoruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Raajenihane uhin inacha nii ocoana que amihanenacaauru sohin jaohin, leeochaauru rai nii ocoana teriha nii ocoana erora,” naain jetao parabola que cuaain cachaauru rai ereerejeein relanajaen Jesoso. Nii jana jetaote: “Jiaonriha icharaa nitohaninera,” naaure jetao nii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nii jana jetaote, acaauru coarajeein jetao: “Chaquena jana chaen, Cana Coaunera Quiricha inoaensi cuhane: ‘Nii jaolecooruha loreri icharaaurune jaan ajerite jauriaanejeein loreri nunuheneein ichanohineein niha cureeincha,’ nae. ");
INSERT INTO uraNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aihana jaun chunocoha nii ajeri ichoae comoite, nichaluchaluriha cureein. Jana chunucoha ichoae comoha nii ajerinete jitohitoreein,” naain jetao be cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Niritiin acaauru que cuaain, cachaauru relaa Jesosone que nainacuruhane jaun jetaote, nii rijieeoritiin mucueratenaa jerecure saseredotecuru curuaanaacuru aina Cana Coaunera aitoonjoan que cacha relaaureraauru. Nejetaote chatohaneein tenaa nainecurene cachaauru coasichuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nitohaneein sohin jaonaa jerecuruhane jaun jetaote, acaauru letono letoaaure, belaicha cacha rijijieein turuhin Jesoso caje chaelai erenaa bajaauruhane jana, tonaain acaauru tonoraane nohaneein colurujueeuruha coberenadoro raine coina. ");
INSERT INTO uraNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nii jaun jetaote, rene turuhin: “Cacha relaera, nii aitiin cachaauru relaaine jaane esinae rauhijiriin chuni que suujuelanaala, satiin cachaauru rai jerichanetojoeein aitohine coitucuhacaanu. Iite esinae rauhijiriin jeriha Cana Coaunerane rijijieein ichaoha cachane coina aitiin cachaauru relaai. ");
INSERT INTO uraNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nitohanihane jaunne ii caje bajaa uhacaanu. Caohachaana Romanocuru curuaanaa enferadoro rai impoestonu que coriqui tihacaanune,” naain jetao Jesoso caje bajaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nii jaun jetaote, nechu jataain baasoneein coacuhin que iriha aitocuruhane que nainaane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Saan. Canu que leinjiin nii coretequichene jaan coriqui coaarateeuche,” naane jana, que nii coriqui coaarateeuruhane jana coaraain jetaote: “Cha cojunaca caa, ecu laenanohineein curuaa siriin,” naa Jesosone jaun jetaote: “Enferadoro rai,” naauruhane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Aihane jaun chujian- caa enferadoro raineein nenaa teeuche enferadoro raicha. Jana Cana Coaunera raineein nenaa teeuche Cana Coaunera raicha,” nae jetao nii cachaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Niritoha satiin cachaauru notaracaae Jesosone jaun jetaote, nii chatohaneein mucuhin teeuruhane jaa lera eruurenihane jaun jetao, ecuhacha cojoelatiin inauheneecha neeure nii saseredotecuru letonocuru, niritiin acaauru tonoraane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nii baiha jetaote, Jesoso coaraa cuure nii ohane baiha jerichanejeein jaberoco rijijieein niha cacha suujuene esenetaauruhi sadoseeocuru. Nitohaneein cuhin rene turuhin jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Cacha relaera, Moisesate canacaanu rai laenaain ratirilu, oha leinjiin cacha nesiriateein nii comasai aina canaanai sirilanaalane, nii autana raain aina canaanai siriha rai ocoalane coina. Nitohaneein nii autana aina canaanai siriha nii ocoalane, aca siricha rijijieein nii onaa calaohineein niha nii canaanaine coina. ");
INSERT INTO uraNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nii janate ita nejera nejesinaneein caaunsineein neeure cachaauru. Jauriaanejeein acaauru inanate, leinjiin ene aina nesirihateein, nii leinjiin niji canaanai sirilanaala ohe. ");
INSERT INTO uraNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Nii janate neeuruha coroatajaain rai nejeraaurune jaun, oha coaiteen nii nihanane jaun nii ene rae nii rai nejera. Nii rijijieein techu satiin nii ene raaure acaauru ocoalacuru itolere bana ooruha acaauru inanacurune jaun. Nete leinjiin niji canaanai sirilanaala oore nii caaunsineeuri ita nejeraauru. ");
INSERT INTO uraNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nii janate inae oohe nii ene netonai. ");
INSERT INTO uraNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aihane jaun chariji comasaineein jana nereein nii ene, inae Cana Coaunera Cojoanonaa que ichaaoruhane bana, caaunsineeuri ita nejeraauru aina nisiriatihalune jaun,” naain jetao Jesoso caje bajaaure nii sadoseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Niritiin caje bajaauruhane jaun jetaote: “Caa chauratane que nenacaauru quichaauru, enecuru, naaonjoainurite nisiriateein naaonjoaaunre. ");
INSERT INTO uraNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nete laen inae ooruhane baiha oo caje ichanaain Cana Coaunera rene turuhenihuru quichaauru, enecuru, naaonjoainuri inae oo caje ichanacuruhane nisirihateeurenereein, ");
INSERT INTO uraNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","onaa inaaureniha anjeraaurune rijijieein neeururichaainne jaun. Chaen techu Cana Coaunera Calaohineein neeurureein acaauru ichateein nerichaain Cana Coaunerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jerichanejeein techu ohane baiha ichanaain neeuruha onacaaurune que laenaain coitucuerateein nelu cana que Moisesa, nii nuna laaojoiri iihani netiin Cana Coaunera aina irihane bana, ‘Canune, Abaraaun, Isaca, Jacobo, naaonjoainuri Coaunera, inara Coaunera neein neeun,’ naalu Cana Coaunera Moisesa raine jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aihane jaun coatiha ichaonacaauruhacha Coaunera neein nihei Cana Coaunera, onacaauru nihanatiin rai ichaohin neeuruhane jaun,” naain jetao sadoseeocuru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Niritoha sadoseeocuru rai Jesosone jana jetaote: “Jataain caohatiinte acaauru rai aitohicha cacha relaera,” naaure jetao Cana Coaunera aitoonjoa que cacha relaaureraauru tabaauru, acaauru laen oo caje ichanaa cachane esenetaauruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Niritoha acaauru rai Jesosone jaun jetaote, inae nenacaaen caje chatohanai bajaanaa nainecurene. ");
INSERT INTO uraNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nii jana jetaote: “Chanuna Rabiri caje nefoeratenaaniha canaacha cohajei Mesihasine jaun, Rabiri amurijiriin nenaa naineniha beeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Inasiina raajenihane, quiricha Salmo cuhane: ‘Cana Coaunerate, Canu Curuaana Mesihasi rai: “Cau carohan canu raotono nichajai que nelauriaain coarajeeuna, ");
INSERT INTO uraNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nii iniha nejeratenacaauru amuritiin, ii bijihu tenajaanune reeintiaaicha,” naa Cana Coaunera, Canu Curuaanaa Mesihasi raicha,’ naain raajenihane Salmo cuhane bihalu Rabiri inatiin. Chanuna Rabiri amurijiriin nenaa nainenere Mesihasi. ");
INSERT INTO uraNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Inasiinna jana chaen amurijiriin nenaa naineniha Mesihasine saijieein nii Rabiri netonai, ‘Canu Curuaanaa,’ naain Mesihasi nichaaunne curuaatihalu natiin,” naain jetao bajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Niritohane jana satiin ecu neein aonajeeuruha cachaaurune jana jetaote, aina nerelanacaauru rai jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Caohachaain necohalajiin neeuche, caa Cana Coaunera aitoonjoa que cacha relaaureraauru que. Acaaurute acaauru que suujua acatena nainiha cachane jaan cocoajione jiaain, itolere coitucueraneein, caohachaain niha nocoetocuruhane jaun, chunijihu nenaanaja cataaun nihanatiin, acaauru que suujua acateein niha satiin cachaaurune jereein neeure. Chaen techu, sinacoca asae nelauriaauruha jataain nelatenacaaurune jaan rori caohacha janijiin, nichoae ichoaichaniha nelauriaaure. Chaen techu ichoaichaniha nelaurianana jaan janiijiin, lenone rohan nelaurihaain lenonecure. ");
INSERT INTO uraNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chaen techu cairichei autanaauru caje acaauru lorerichuru nihanatiin ruluhin naaonjoaaunre. Nii choae tacaain techu nitohaneeuruhane jaun, jataain nohaniha Cana Coaunera coitucueraniha nocoetocuruha itolere amurijiriine jaun, satiin notaracaae Cana Coaunera bajaauruhane carajaain bajaaure. Nitohaneeuruhane jaunte leeochaauru osaaonacaauru cachaauru amurijiriin, jataain caseteco tabai coaraa cuurureein,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Niritiin Teenforo asae coriqui coreniha Cana Coauneraacha icharatenohi amihanenaa ichacuruhane coina curu cuhane coriqui teeuruha cachaaurune jana, ecu coarajenajaa Jesosone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","leinjiin autana jataain cairicheinejeein nenaa netonai coroatajajeein jataain coretelanaala nenaa coriqui te, ");
INSERT INTO uraNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","jataain teeuruha leeochaaurune fautaaine jaun jetaote: “Esinae rauhijiriine aitoon inara rai. Caa cairichei autanate, leeochaauru amuritoheriin coriqui te. ");
INSERT INTO uraNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Satiin caa leeochaaurute nechu jataain inae acaauru rai cauteecha teeure. Jana caa autanate, jataain cairicheinejiha natiin jitariin acaihaniji ichaaojoihane jaanu te,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nii jana jetaote, caohatiin ajeri caje ichanohiniha Teenforone coaraain, jataain caohatiin inanacaane coina, nasaae itolere niicha teeuri coaraain jetao que ereerejeeure cachaauru. Nii jana jetaote acaauru rai: ");
INSERT INTO uraNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Caa ena ajeri caje caohatiin ichanohineein inaraacha coarajeite, inae ecu tihane bana fejeein itajenojoinereein,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Niritohane jaun jetaote: “Cacha relaera, chabanacha aicheein nii chaitoonjoan. Chatohanai cojoelanaacojoaicha inae que turuhelalajihane jana coararichaanuhin,” naain jetao caje bajaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nii jaun jetaote: “Caohachaain nainaain necohalajiin neeuche, inara coritaa chunine coataara. Inae nerichaain arajii canu niha nocoetiin inara coritaeraanuurura. Tabaaurute: ‘Canune acaneeunra,’ naaurureein. Jana tabaaurute: ‘Inae taolu caitoonjoa cojoanonaa que nihacachera,’ naauruha inara raine, jiaonriha esenetaain sacunajaaichenera. ");
INSERT INTO uraNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jiaonrihachu nejesinaneein ita sohin neeuruha satiin chauratane que nenacaauru cachaaurune coitucuhin neeichene nihanatiin nesoonetohichenera. Nitohaneeinte jaiti nii cojoanonaa que turuenihane ajiniha aicheeincha. Nete nitohanihane nihanatiin jaiti cana janonaa satono que turuhenereeincha,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Niritiin jetaote: “Leeocha atane que ichaonacaauru cachaaurute, lauriu ichaonacaauru cachaauru aina ita cotaiha cuurureein. Jana leinjiin atane que ichaonacaauru cachaaurute, leeocha atane que ichaonacaauru aina ita soorureein. ");
INSERT INTO uraNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nii janate itolere cana rai chauratane sacuritaain niha cureein jataain mijiaaineein carora, mijitena, cunai, naaojoainuri. Nii jana dede quete jataain coasinaacojoai coaraain, cojoelanaacojoai coaraa cuurureein cachaaurura. ");
INSERT INTO uraNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nete nii cojoanonaa que turuenihane ajiniha, inara rerohecaain inara mucuhin sinacoca asae inara amaain, curuaanaacuru, chaen coberenadorocuru, naaonjoainuri acatiha inara teein inara cairichaain caresero cuhane inara enohaa cuurureein canu ere tonoraera neeichene corenihara. ");
INSERT INTO uraNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nitohaneein inara teeuruhane banate, canu nichaaunne coitucuerateriquicheein cachaauru quera. ");
INSERT INTO uraNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jiaonriha, ‘Tonaainera erereeunta,’ naain inara jabereco coreniha ereeichene jaanu que coacuhin cuhiche inara amaauruhanene. ");
INSERT INTO uraNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Canune jataain nainaain ecu ereeichene jaanu tereeunni inara raicha. Nii bana nii tonaain inara tonoracuruhane jaanu coitucuhin neeururihaain nii inara aina nejeratenacaauruta. ");
INSERT INTO uraNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Nete laen inara cairichaeriin inara cotaairiin nenacaauru coroatajaniha cuurureein nechu jataain inara cairichaa, inara inacaauru, inara nejeraauru, inara araaichuru, inaraacha belaihuri, naaonjoainuricha. Nitohaneeinte inara tabaauru sohin jaaoha cuurureein. Satiin caa chauratane que nenacaauru cachaaurute Canu ere tonoraera neeichene coreniha inara que nererojoecaaeriin, inara cairichaeriin, inara cotaairiin, naaonjoaain neeurureeincha. ");
INSERT INTO uraNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nete nii leinjiiniji inara couturiji nihanatiin nitajenereein. ");
INSERT INTO uraNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nii jaun caohachaain laraajiin nii inara suujua corelanaala, raotojoeein neeuchete nii caje nichotenaa nainequiche. ");
INSERT INTO uraNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Inae Jerosaleen curuhacaain neeuruha soondaroorune coaraquichene, inae nitajerichaainne cojoanonaa que turuhane que nainacuche. ");
INSERT INTO uraNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Inae nitohaneeuruhane coaraquichene, Jodea nenacaauru naain ichatane ucuuno cuhin sorooruhine. Jana Jerosaleen nenacaauru, nii nese caje coriaae amuurumiiincha. Jana chunocoha rai nocoana jana nihane jana nitohanihane, jiaonriha jelaiha nii neseu turuha cunaa coaaucanera. ");
INSERT INTO uraNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Inaen nitohanihane coina, niritiin inoaenlu quiricha inoaensi cuhane satiin laenacuruhane jaa cojoanonaa nainaane coina jataain caseteco tabai niha curichaaine jaunra. ");
INSERT INTO uraNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jataainte cairichaaojoaa cuurureein nii cojoanonaa bana ausirineein nenacaauru enecurura, chaen sisiajeein canaanai siriin nenacaauru, naaonjoainuricha. Nitohaneeinte caseteco tabai coaraa cuurureein nii Jodea batane que nenaa aina Jerosaleen ichaonacaauru cachaaurura. ");
INSERT INTO uraNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tabaaurute sabere que sohin jaonojoiniha cuureeincha. Jana tabaaurute mucunojoineein corihaji ataneeuru amanojoiniha cuurureein. Nitohaneeinte Cana Coaunera coitucuhichuru, nii Jerosaleen nenacaauru itajiha cuurureein caohatenojoiniha nitohanei ichacuruhane jaan que turuhanereein tihaaincha,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Niritiin jetaote “Enoto, atene, arasijie, naaonjoainuri quete cojunacateein coaaratenojoinereeincha. Nii jana satiin caa chauratane que nenacaauru cachaaurute, nesooniha cuurureein, ‘Naaonjoaanne jaunte caa aicha’ naain coitucuurenihane jana jataain tonihaca coasinacaain fichafichanaa cucuanane coaraaincha. ");
INSERT INTO uraNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nitohanihane janate inae nitajerichaain cana rai chauratanene coaracuruhane jaun, coasinacaaun acunoha cuurureein cachaauru. Dedeeu nenacaauru netonaite jataain nerurujuaa cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nii janate jataain nelateein itolere ichana nainichaaunne coaarateein turuha uuhanu Canu Cachaneein nejanohanaaneein dede sacari jana uuhinne coaraa cuurureein cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Inae nitohanihane nunuhetihane jana, nii chaque tonajelanaala neeuche, inae inara que nejeratenacaauru caje nichoteriquicheeinine coitucuhichene jaun,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Acaauru rai niritiin jetaote, nechu jataain nainacuruhane jaanu que jetao: “Coaracuchena chuhinti iquera aina joaenreein enuhacuru, satiin neroeeca nalone baiha ");
INSERT INTO uraNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","nacoaauneein omaroha nalone, inae elohena que turunaa jerihane que nainaquichene. ");
INSERT INTO uraNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nii rijijieein techu inae caa caitoonjoan cojoanonaa que tihane bana, inae coaraquichene, nichuuntaa Cana Coaunera Cojoanonaane que nainariquicheeincha. ");
INSERT INTO uraNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Esinae rauhijiriinte jaiti ooreniha caa ena nenacaauru cachaaurune jana, satiin situha cureein caa caitoonjoan. ");
INSERT INTO uraNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dede, chauratane, naaonjoainurite nitajiha cuurureein. Nete laen caa caitoonjoan leinjiiniji nitajelanaala satiin aitocoaaunne rijijieein aihane rai ne. ");
INSERT INTO uraNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Aihane jaun caohachaain necohalajiin, nii cajihaneein inara suujua coacuelanaala, nii ajelanaala, nii inara ichaohacha que nererojoecaaeriin neeichene jianeein neeuche, inae nii cojoanonaa que tihane bana, ujua cuhane foroaa chaelaine rijijieein inara foratiaa nii cojoanonaane coataa. ");
INSERT INTO uraNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Itolere sacuritaain caa chauratane que nenacaauru cachaauru ichoaaete naluha cureein nitohanai. ");
INSERT INTO uraNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aihane jaun letona jatoroaain itolere cojoanonaa bana Cana Coaunera bajaaebajajeein neeuche. Aihate caa caitoonjoan tocoaneein situhane bana, caje nichoteein, nii acaihaniji Cachaneein nejanohanaa nichaaunne acatiha raotojoeein turunaa nainequiche inara,” nae jetao caje bajaauruhane jaun aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nitohaneein jetaote, jiichoonihane Teenforo asae cachaauru relaain, inae nocohecane jana Oliboneein niicha curuaateeuri ichatane ucuuno cuhin nihane nesururejetelu Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nitohaneein jetaote, janohetiin Teenforo asae cuhin, acaauru relaa Jesosone aonaa curejetucurelu satiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Inae jorerera colane faan quihuruhane jaa cojoanonaa Fasocoa beseta catainaane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jesoso sohin joaerateeuruhane coina jetao, “Chatohaneein ichanaareta,” naain coaaucure saseredotecuru curuaanaacuru aina Cana Coaunera aitoonjoa que cacha relaaureraauru. Nabana raajenihane mucuhin sohin jaaoruhane, chatohaneein acaauru teeuruha cachaaurune que necasacuruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nitohaneein inaen sohin jaaoruhane coina que nocousuujuaaruhane jana jetaote, nii aina nerelanacaauru lechoonca coroataja Jodasi Isacariote neein niicha curuaateeuri suujua saruha Moconajaerane jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","batirichuru curuaanaacuru, Teenforo curuaanaacuru, naaonjoainuri coaraa cue: “Canune naaonjoaain inara rai naineeun, nii Jesoso mucuhinchene coina ecu inara turuaanunera,” naa acaauru raine coina. ");
INSERT INTO uraNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Inae niritoha acaauru raine jaun jetaote, jataain coroajeein coretena jerecure. ");
INSERT INTO uraNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nii jaun jetaote, acaauru suujua rijitojoeein cachaauru colane niha Jesosone cojoae, ecu Jorioocuru bijihu Jesoso tihane coina Jodasi. ");
INSERT INTO uraNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nii jana inae jorerera colane ichanohin faan quiin carenero narejeen sooruhane jaan beseta cojoanonaa Fasocoa que turuhane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Fedoro aina Joaan rai jetao: “Chajaain Fasocoa beseta cosonaina que canaacha quiine ichanihuchete que lenonichaachera,” naain jetao acaauru letoae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nii jaun jetaote: “Chujian ichacaaunne jereeita,” naain jetao caje bajaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nii jaun jetaote: “Inaen cuhin nii neseu turuhichene janate, baichaje cuhane acau baaibaaichaain cuujiha leinjiin cachane jana eruriquicheein. Chaen loreri asae enohane reentiaain sacuuchera. ");
INSERT INTO uraNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chaen inae nii loreri asaae turuhichene, nii loreri erora rai: ‘Taa cana relaerate, Chariji loreri asae nenaa ecuha cuhane, Fasocoa beseta cosonaina que lenonereeunni canu aina nerelanacaauru ainata, naain ii caje bajaeratera,’ naauche. ");
INSERT INTO uraNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Niritocoichene janate, nii loreri coroata coarana ecuha seeonjoa siricha coaaratereein inara que. Chaen inae nitohaneein inara que coaaratihane baiha, ecu sonaina lenonichaachene jaanu jelai rucuhecuchera,” naain jetao letoanajaen Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nii jaun jetaote cuhin, nii acaauru rai aitoha Jesosone rijijieein eruuruhane jaun jetao, ecu teein Fasocoa beseta bitoaain, cosonaina que lenonecuruhane jaanu jelai rucuhecure. ");
INSERT INTO uraNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Inae nitohaneein enoalaauruhane jana jetaote turuhin, inae que lenonecuruhane jaan rijiu tihane jana, rai afosotooru aina rori ichoae nelauriae lenonecuruhane coina Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nitohaneein rori ichoae nelauriaain jetaote: “Jataaine inara aina carijieein caa Fasocoa beseta bitoaain, cosonaina que lenonena jerenajacoon osichaaunne ajiniha. ");
INSERT INTO uraNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Coatiha laen caa baiha, inaen caa Fasocoa beseta bitoaain inara aina lenonerihaaunni Cana Coaunera Cojoanonaa que turuhanune reentiaain,” naain jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","curu cuhane, oba caje ichanohin bino teberiaain Cana Coaunera bajaane baiha jetao, acaauru rai teein: “Nocoa, inara nejesinajeein caa leruune leruuneein cooche. ");
INSERT INTO uraNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Inae caa baiha nacoaauneein caa oba caje ichanohin bino corihaaunni Cana Coaunera Cojoanonaa que turuhanunereen tiaain,” ");
INSERT INTO uraNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","naane baiha jetaote, faan mucuhin Cana Coaunera bajaain, cataaun nii faan tatuhin beeune beeuneein acaauru rai teein jetao: “Caa inara rai canuhacha teite cajabereeoneein ne. Acate jianacoon neeichene coina, inara coreniha cairichanojoineein atinanohinereein. Aihane jaun, itolere bana canuneein nihanune coacuhin que lenonecuche,” nae jetao acaauru rai faan teruhin teein Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Niritoha acaauru rai Jesosone jana lenonecuruhane baiha jetaote, nii faan que aitohane rijitojoeein, acaauruhacha coheni teein jetao; “Caa oba caje ichanohin binote, inara caohachanu que cacoichana jaohin canuhacha ichaneni icharihanuhinne cojunaca nera. ");
INSERT INTO uraNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nitohaneein caque nejeratenacaauru rai caeteraanute ena cau cana aina lenoniha ne. ");
INSERT INTO uraNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nitohaneein acaihaniji Cachaneein nejanohanaa nichaaunne cairichaeriin neeuruhane coina, aitiin neeuruhalune rijijieein aihanete ne. Nete jataain cairichaaojoaa cureein, nii caque nerotohin cacairichaerateranu,” naain jetao bino teberiaain Cana Coaunera bajaane baiha afosotooru rai te Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nii jaun jetaote, “Charijinachara toon totohaneein que nerotohin aina nejeratenacaauru rai coulurujueein cairichaeratiha cureein,” naain jetao ita caje bajaacoaaure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Niritiin jetaote nejesinajeein: “Charijina caa cana caje jataain nelateineein coaanojoineein ne,” naain jetao ita caje bajaacoaaure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nii jaun jetaote acaauru rai: “Cana Coaunera coitucuelanaala nenacaauru curuaanaacurute, itolere amurijiriin nenaa jereein cachaauru cairichaeriin neeure. Niite acaauru cairichaauruhane coitucuuruhane nihanatin coroaaecure caohacha ichaa benajaain. ");
INSERT INTO uraNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nete laen inara naineneeiche nitohaneein neeichene. Nitohaneein nenaa coacuelanaala, leeochaauru amurijiriin nelateein nenaa jeriha chuni inara cajene, leeochaauru ere tonoraain, letoaauruhane jaan ichaain neeine. Jana chunocoha leeochaauru letoaeraneein nenaa jerihane satiin rai, chachaeraneein neeine. ");
INSERT INTO uraNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nitohanihane jaun chariji jataain nelateineein nere, nii lenonihane coina rori ichoae nelaurianaana. Ainihane nii lenone chaluherana nelateein neriha. Aihei jerihane. Nii rori ichoae lenonihane coina nelaurianaate nii lenone chaluera amurijiriin nelateein niha nocoete. Nena laen canu nitohanelanaala, inara letono rijijieein ena cau inara aina inaraacha latei icharaneein neeun. ");
INSERT INTO uraNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Inarate cajiniichaain necairichanaa coaraain nenajaaonquiche. ");
INSERT INTO uraNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nii jaunne itolere Curuaanaa neein nelateein nihanune coina canu cocoainaain caeteein niha Ofane rijijieein, inara netonai cocoainaaain nereeunni. ");
INSERT INTO uraNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nii banate inae nii cojoanonaa que turuhane bana, cajiniichaain rorihuru ichoae nelauriaain acau cohin, lenoneein, naaonjoanriquicheein. Chaen techu baaso ichacurenihane, caohacha ichacuruha lechoonca coroata laurii Isaraeli cocoaichacurune coaraain coitucuhichene coina cajiniinchaain nii coina banijiaain nenaa rori ichoae nelauriariquicheein, inae nii cojoanonaa que tihane bana,” nae jetao aina nerelanacaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Niritiin jetaote: “Simoon, inae Canu sacueraneein neeichene bajaa moconajaera inara raane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nena ii coreniha Cana Coaunera bajaaun, canu esetaaine jianeeine nihanatiin nacoauneein nelalararajiaain Canu esenetaain neeine coina. Aihana jaun, inae nacoaauneein canu esenetaaine bana, inejeraauru coroatajanecuhin caohachaain laraajiin, canu esenetaauruhane jianelanaala raotojoeein rachoojoeein neeuruhane coina,” nae jetao Simoon rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Niritoha raine jaun jetaote: “Curuaanaa, canune ijiniichaain caresero cuhane enohin nihanatiin ii coreniha onaa naineeun,” nae jetao rai Simoon. ");
INSERT INTO uraNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nii jaun jetaote: “Fedoro, enene janotiin cuhanete, iriha janonaa rai ataohari curuaanaane ajiniha, nichata saain canu coitucuha nocoetoeneriquiin,” nae jetao Fedoro rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Niritiin jetaote: “Inara letoaain nihanulu coriqui curu, inara safato, inara atora, naaonjoain colane janana lanaain nihalu inara rai cha,” naain acaauru caje bajaa Jesosone jaun jetaote, “Aihei. Coatiha nii lanaailu canacaanu rai chata,” naain jetao tonoraaure. ");
INSERT INTO uraNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Niritocuruhane jaun jetaote: “Nete laen ena chateeinti coriqui curu siriin, natora siri, nii amaain cuhane caohachae. Chateeinti sabere sirine nii jelaronaa bana niicha jiai cajione burique necoreteein leinjiin sabere coretemiin. ");
INSERT INTO uraNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Inara raine aitoon, inae caque aitiin Quiricha inoaesi cuhane: ‘Naaonjoaain cairichaaeriinte necha aansai caseteco coaraane rai nenaa ichara rijijieeinte teeurureeincha,’ naain itolereneein niritiin caque aitiin laenacuruhalune rijijieein situhane rai te ne,” naa acaauru raine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Curuaanaa, caute ne corotajaain sabere,” naauruhane jaun jetaote: “Inae nainejerichaain niriimiin,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Niritoha acaauru raine baiha jetaote, ecu nesurunajaaoncane jaun, Oliboneein niicha curuaateeuri ichatane ucuuno cuha Jesosone jana jetao, caaijie cuure aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nitohaneein cuhin, inae nii Olibo neeonjoaihu turuhin jetaote: “Cana Coaunera bajaauche nabana osa que nesaruquichene coataara,” nae jetao acaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Acaauru rai niritiin jetaote, nita acaauru aonajeein cuhin neseeonrariin jetao; ");
INSERT INTO uraNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ofa, ii jereeine caa jataain necairichanaa tabai caje canu mitaaura. Nena canu jerichaaunne rijijieein ichaaine jereneeunra. Ii jereeine rijijieein ichaaura,” naain jetao Cana Coaunera bajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Niritohane jana jetaote, dede caje ecocohin lararajiaa leinjiin anjerane jaun jetaote, aina suujua nunaaojoae. ");
INSERT INTO uraNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nii aina jataain nesoonenaa cataau neein jelai rutaain, Cana Coaunera bajaaebajaaeca Jesosone jana jetaote, atanichoae tabaanaain nalue rai doroana ichananeein. ");
INSERT INTO uraNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nitohaneein inae Cana Coaunera bajaane nainaain, aina nerelanacaauru coaraa cuhane jana jetaote, jataain cotaaena aina inaderanaa caaun sinihure. ");
INSERT INTO uraNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nii jaun jetaote acaauru rai: “Chanuna siniiche. Chajaain nimichuhin Cana Coaunera bajaauche nabana osa que nesaruquichene coataara,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Niritiin jaiti acaauru rai ereerejiha Jesosone jana jetaote, turuha cuure arajii cachaauru. Nii aina nerelanacaauru lechoonca coroataja neein nenaa Jodasi jetaote, acaauru ichoaichaniha acaauru amaeraneein cue. Aca jetaote, Jesoso rohan nichuuntaain nechu jataain belaicha rijijieein jetao rai nomeri lioracae. ");
INSERT INTO uraNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nii jaun jetaote: “Jodasi, belaicha rijijieeina nomeri lioracaain nii acaihaniji cacha Calaohineein nenaa teei aina nejerateeriin nenacaauru bijihute,” nae jetao Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Inae inooneeuruhane coaraain jetaote: “Curuaanaa, coanene ii cocoaeratihacaanu sabere quera,” naaure jetao nii Jesoso aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Niritiin jetaote, leinjiin saseredotecucu curuaanaa letono uricho beuhite, rai raotono nichajai que tacaain sabere que, leinjiin nii Jesoso aina nerelanaa. ");
INSERT INTO uraNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nii jaun jetaote: “Inae nirimiin, coa cunaitaa,” naain jetao jelaiha nii saseredotecuru curuaanaa letono uricho tirichaain jetao rautae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nitohaneein rautaane baiha jetaote, saseredotecuru curuaanaacuru, Teenforo beraihurera, chaen Joriocuru bichauhenaauru, Joriocuru rai nelateein nenacaauru, naaonjoainuri rai jetao: “Chanuna leinjiin necha ansai ausijiautoneein sonajaain joaeraneein nihanune que airijiin sabereeuru aina enuhacuru uhaain canu mucuha uhiche. ");
INSERT INTO uraNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Itolere cojoanonaa banara, inara aina Teenforo asae nenajacoonna. Nii jana nii chatohaneein coatiha canu dadanajaaoheeiche. Nete inae nitohaneein nocohena tabai osa que nesaruhin namuritocohichene cojoanonaa que tihane jaun aiiche inarara,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nitohaneein jetaote, Jesoso mucuhin saseredotecuru curuaanaa loreri asae amaauruhane jana jetao, nita caaijie coarajeein jetao cuujue Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Cuu turuhin jetaote, jelarotohane jaun, nenaanaja cataaun teein usi mocohin, curuhacaain nichaatiha neeuruhane jana jetao, Fedoro netonai cuu turuhin acaauru aina nichaatiha usi rohan lauheque. ");
INSERT INTO uraNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nii jana saseredotecuru curuaanaa coseenraneein nenaa leinjiin ene jetaote, cuu usi rohan lauhequiin nichaatiha Fedorone jana, cuu coarajihane baiha jetao coujueluhin: “Caa netonaite aina nenaane,” naane jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","“Ainaaunchenaate. Coatihana Jesoso coitucuhaaunche canute,” naain jetao suujue Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nii baiha neeoriin jetaote, leeocha netonai: “Caa netonaite acaauru aina nenaanera,” naane jaun jetaote; “Ainaaunnaate, coatihana aca nihaaunte,” naain jetao nii cacha tonorae Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nii baiha carajaaojoaain jetaote, coaiteen leeocha netonai; “Esinae rauhijiriin caa cacha netonaite, aina nenaane. Nii choae tacaain techu Calileea cocoaichanera,” naane jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","“Coatihana nii carai chaitoonjoan cacha coitucuhaaunte,” nae jetao nii cacha rai Fedoro. Niritiin jaiti ereerejiha Fedorone jana, nii rijieeoritiin iriha ataohari curuaanaane jana, ");
INSERT INTO uraNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","jaotoroaain Fedoro coaraa Jesosone aina jetaote: “Enene cojoanotiin cuhanete, nichata saain cacoitucuha nocoetelanaala nesuujueeine jana erereein ataoharicha,” naa Jesoso raine coacuhin nainaain jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","nii neeurunaja loreri caje mituhin jetao jataain obajeein chanae Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nitohaneein nii Jesoso mucuuruhane jana beraiha nenacaauru cachaauru jetaote, que ninichaajeein faohacure. ");
INSERT INTO uraNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nitohaneein faojoaain jetaote, nota conajaain: “Aihane esinae rauhijiriin profetaneeine caa ii soera coitucuura,” naainchuru jetao sohin, ");
INSERT INTO uraNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","jataain que ereeinchuru nocoeje chanuure. ");
INSERT INTO uraNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nitohaneein teein jetaote, inae janohane jana, ita taojiaaure Jorioocuru coaaraneein nenacaauru bichauhenaauru, chaen saseredotecuru curuaanaacuru, Cana Coaunera aitoonjoa que cacha relaaureraauru, naaonjoainuri, jataain Jorioocuru rai nelateein nenacaauru Junta Suprema acatiha amaauruhane coina. Nitohaneein amaain inae cuu turuhaain jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Esinae rauhijiriin Mesihasi neeine canacaanu rai beeune coitucuhacaanura,” naaunruhane jaun jetaote: “ ‘Aca nichaaunchujian,’ naanune nihanatiin, nii quesenetareeichene coaalanaalata. ");
INSERT INTO uraNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nii inara caje erenaa bajaanune nihanatiinchu catoonrariquichene coaalanaalata. ");
INSERT INTO uraNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nena laen inae, enene caje coaauneein, itolere Coauneraneein nelateein nenaa Cana Coaunera raotono nichajai que nelauriaa cureeinni, canu acaihaniji cachaneein nejanohanaa nichaaunnera,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Niritoha acaauru raine jaun jetaote, satiin: “Aihane jaunna, ii Cana Coaunera Calaohineei,” naauruhane jaun jetao: “Esinae rauhijiriinte acanichaaunne que aitocoichera,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Niritoha acaauru raine jaun jetaote: “Cha nenacaaeneein cana rai berana laterihacache, inae raajenihane nujuaae caje acanihane que aitohane aonacaache natiin,” naaure jetao. ");
INSERT INTO uraNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Niritiin jetaote, satiin nimichucutaain coineteein mucuhin jetao, Filato rene Jesoso amaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ecu turuaain jetaote, Filato acatiha teein Jesoso coulurujeeure: “Caa cachane eruhacaanu, caa cana atane que nenacaauru cachaauru suujua rerohecaain, cana curuaanaa Romanocuru curuaanaa enferadoro rai coriqui tihacachene caohateein, ‘Aca jete nii canaacha cohajei Rey Mesihasi ne,’ naain cachaauru suujua auhacaane jana,” naain jetao coulurujeeure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Niritiin coulurujeeuruhane jaun jetaote, “Iina chuhisi Jorioocuru Curuaanaa Rey ineei,” naain caje bajaa Filatone jaun jetaote: “Esinae rauhijiriin acanichaaunne quete aitohicha,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Niritohane jaun jetaote, saseredotecuru curuaanaacuru, chaen ecu neein aonajeeurera cachaauru, naaonjoainuri rai jetao: “Coatiha chatohaneein baaso ichaa caa cachane coarahaaun canuta,” naa acaauru rai Filatone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","“Nete cachaauru relaane aina cuaain satiin cachaauru suujua auhacae. Nitohaneeinte Calileea batane caje nunuheteein, caa Jodea batane netonai que jerichanejeein ichana jerera,” naain jetao jataain acaauru esenetaa Filatone jereein counujeeure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Niritocuruhane aonaain jetaote: “Calileea cajena nenaana caa cachate,” naain jetao acaauru caje bajae Filato. ");
INSERT INTO uraNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Niritiin acaauru caje bajaane jana, “Aca chujianrana,” naauruhane jaun jetaote, Calileea coberenadoroneein bana niha Erodesine jaun rene letoae Filato, nii bana nii Jerosaleeun turuhin niha nii Erodesine jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nitohaneein Jesoso letoaa Filatone jana coaraain jetaote, jataain rachoojoe Erodesi, cojoelanaacojoai ichaane coitucuhin, acaaentonai Jesoso coarana jeretohane jana rene letoaauruhane jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nii jaun jetaote, araai saain niqui, “Chatohaneein nenaa neein,” naain caje bajae Erodesi. Nejetaote, nere tonorana jerene Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nii nainiha jetaote, ecu neeure saseredotecuru curuaanaacuru, chaen Cana Coaunera aitoonjoa que cacha relaaureraauru, naaonjoainuri, jataain acaauru esenetaain, Jesoso cairichaa Erodisine coina counujeein coulurujiha neeure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nitohaneein nere tonorana jereniha Jesosone jaun jetaote, coaetaain rai soodarooru aina jiniinquiin nocoeje chanuhin jetao cairichaain, nocoreeteeuruha reychurune jaan tocohanai cajione que jetao Jesoso cajione corerate Erodesi. Nitohaneein teein jetaote, nacoaauneein Filato rene letoae Erodesi. ");
INSERT INTO uraNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nitohaneein Jesoso cairichaauruhane bana caje coaauneein jetaote, ita que nejerateeriin neeuruhane baiha jetao, ita belaichaneein neeure Filato aina Erodesihuru. ");
INSERT INTO uraNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nitohaneein Filato rene letoaa Erodesine jana jetaote, saseredotecuru curuaanaacuru, chaen cocoainacaihuru, satiin ecu nenacaauru cachaauru, naaonjoainuri taojiaain jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Inarate canu rene caa cacha turuaa uhiche, ‘Cachaauru suujua reroecaain jete, cachaauru suujua auhacae,’ naain coulurujeein. Nena caraajenihane inara acatiha teein caje bajaaunune janate, nii chatohaneein cotainacai ichaain, nii coulurujeeichene jaa lera coitucueneeun. ");
INSERT INTO uraNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Niheichu caa cana rene jelaiha letoaera Erodesi nihanatiin, nii chatoanai ichaane jaa lera coitucuhi. Aihane jaun inae coaraquiche inara, nihei nii chatoaneein cairichaain ateinaacachene jaan lera. ");
INSERT INTO uraNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Raujiaainchane casetecaain nii baiha jianereeunni, ");
INSERT INTO uraNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Fasocoa beseta naineein niha coulurujuenojoine, nirijieein jianenajaaoncaaunne rijijieein,” naa acaauru rai Filatone jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","satiin ita rijitiin jachaatorohaain jetao: “Jiaohine. Jiaonriha nii Jesoso jianeeinera. Nii Barabasi jianeeujian laenra,” naaure jetao Filato rai Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nii Barabasi jetaote, caresero cuhane enohaaure, nii neseu Romanocuru que nejerateein, acaauru aina sonaana que neein leinjiin cacha sohin jaohane coreniha. ");
INSERT INTO uraNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nitohaneein nii chatohaneein Jesoso cairichanaa jerenihane jaun jetaote, nirijieein jianihane coina jetao niqui, nacoaauneein acaauru rai ere Filato. ");
INSERT INTO uraNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nejetaote, jataain tonijiaain jeelai rutaain jachaatoroaain jetao: “Letonanocoriin coroso que teeute ecu neein ohinera,” naaure jetao ita rijitiin. ");
INSERT INTO uraNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Niritocuruhane jaun jetaote: “Chatohanai baasonajian ichae. Coatiha cairichaain atinaanune coina chatohaneein baaso ichaain nihane coarahaaun canuta. Raujiaainchane casetecaain, nii baiha nirijieein jianereeunnicha,” nae jetao acaauru rai Filato nichata saain. ");
INSERT INTO uraNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Niritoha acaauru raine jana jetaote, jachaatoraain ehequiin jetao, “Coroso que tihachaaura,” naauruha araai saaine cotabeniha jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","nii aitocuruhane rijijieein jetao ichae Filato. ");
INSERT INTO uraNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nitohaneein jetaote, nii Romanocuru que nejerateein sonaana que neein sonajaain joaera caresero cuhane nenaa, acaauruhacha jianeratei cacha mitaain jetao acaauruhacha jerei rijijieein jetao, acaauru bijihu Jesoso te Filato. ");
INSERT INTO uraNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nii jaun jetaote, coroso que Jesoso teeuruhane coina, amaauruhane jana, situujiha cuha leinjiin cacha Sirene caje unaa Simoonne jaun jetaote, cotijiaain que nii Jesoso teeuruhane jaanu coroso baijiaeratecure. Nii jaun jetaote Jesoso caaijie, nii coroso teeuruhane jaanu amae. ");
INSERT INTO uraNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nitohaneein amaauruhane jana jetaote, arajii enecuru, quichaauru, naaonjoainuri jetao, caaijie cuure. Nii caaijie cunacaauru jana cunacaauru enecuru jetaote, cojioriin chanaaure Jesoso coinaderaa. ");
INSERT INTO uraNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nii chanaauruhane jana acaauru coaraain jetaote: “Jiaonriha cacoreniha chanaaichenera Jerosaleen benecuru. Inara bereecuru, inara jaberoco, naaonjoain coreniha chanaauchera. ");
INSERT INTO uraNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Inae nerichaain inara cairichaauruhane jaan cojoanonaa. Nii banate: ‘Caohatoriha canaanai sirilanaala nihacachene niqui,’ nariquicheein. ");
INSERT INTO uraNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nii banate ichatane ecuunooru rai, ‘Canacaanu ichoae neranuu,’ naa cuurureein cachaauru. Jana atane rarororooru raite, ‘Canacaanu asihu,’ naaurureein. ");
INSERT INTO uraNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Coaracuche nachuhinti chatohanai baaso ichaain nenihanune sainejeein catohaneein caetecuruhane. Nii jaun chatohaneein teeinti inara teeurureein inae amuhanune baiha,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nii Jesoso jiniichaain jetaote, coroatajaain necha aansai baaso icharaauru cachaauru amaaure, sohin ateinanajaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Inae nii “Couturi Bejero” neein acaauruhacha curuaateihu turuhin jetaote, coroso que Jesoso aina jiniiquiin nii coroatajai necha aansai baaso icharaauru teeure. Leinjiin jetaote, Jesoso najaabiji nichajai que teeure. Jana leeocha jetaote, raotono nichajai que teeure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nitohaneein coroso que teeuruhane jana jetaote: “Caa catohaneein caetecuruhane coreniha, acaauru que ii suujua acateeura Ofa, cha coitucuurenihane jaunte aihurera,” nae jetao Jesoso. Nii jana jetaote, ecu nejesinajeein ita rai Jesoso cajione chaluure soodarooru. ");
INSERT INTO uraNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nitohaneein teeuruhane jana jetaote, ecu neein coarajeeure cachaauru. Nii nainiha jetaote, cocoainanacaaihuri netonai: “Chajaain aihane ena esinae rauhijiriin Cana Coaunera tenojoi Mesihasineein niicha janijiineein nihane, raajenihane rai jaberoco ichoteratemiin leeochaauru ichoteratihane rijijieeinte coaracaachera,” naaure jetao nechu jataain cairichaain que ninichaajia. ");
INSERT INTO uraNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nii jana soodarooru netonai jetaote, Jesoso que ninichaajeein nechu jataain cairichaa rohan nichuutaacoaain jetao, bino elorajiojoaain nenaa que jetao cocoaain: ");
INSERT INTO uraNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Aihane esinae rauhijiriin Jorioocuru rai Rey neeine, ichaajenihane ijiabereeo ichoterateeune coaracaanura,” naaure jetao rai. ");
INSERT INTO uraNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nitohaneein coroso que teein jetaote, rai bichoeniha teein jetao: “Caate Jorioocuru rai Reyneein ne,” naain laenacure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nii jana nii necha aansaineein coroso que nenaa cacha coroataja jetaote, nechu jataain cairichaa cotaiha jetao: “Aihane esinae rauhijiriin Mesihasineeine, ichaajenihane ijiabereeo ichoterateeute coaracurumiin, chaen canacaanune maajeein ichoterateeune coaracaanura,” naane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","“Coa niritoha. Tana ichasetecarichaain Cana Coaunerane coasiine. Itonai rijijieein caseteconeein neeinatiinachura aitohite. ");
INSERT INTO uraNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Canatejian esinae rauhijiriin itolereneein baaso ichacaane coreniha necairichaecaa cau. Jana caa cacha, nii chatohanai baaso ichaain nihane coreniha caa aihei,” ");
INSERT INTO uraNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","naane baiha jetao: “Canu coaaucuhin ii Cojoanonaa que neeine banara Jesoso,” naa nii baaso icharaauru coroso que nenaa leeochane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","“Enenete esinae rauhijiriin raotojoeein ichaonaana jaun caniha neriquiincha,” nae jetao rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nitohaneein inae ohane rai niha Jesosone jana jetaote, enoto chujutora caje coaauneein jetao, caohachanainejeein nocoenaneein nedae satiin chauratane, nuna macohi ichoae teejiha enotonereetiaain. ");
INSERT INTO uraNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nitohanihane jana jetaote, neleruhin nesoaihacoae nii Teenforo leruera cajione, ecu bujuaneein nenaa. ");
INSERT INTO uraNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nii jana jetaote, jataain tonijiaain auhaquiin jetao: “Ii bijihune canu suujue teeunra Ofa,” naain jetao inae ohe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nii jana ecu beraiha nenacaauru Roma rai sondarooru cafitaaun jetaote, Cana Coaunera coroajeein jetao: “Esinae rauhijiriinte, nii chatoanai baaso ichaain nenecaiha caa cachara,” nae jetao. ");
INSERT INTO uraNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nitohanihane jana ecu satiin neein coarajeeurera cachaauru jetaote, nesoone caaun rai nalarijia faojoaain jelai caje cauhacoaaure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nejetaote, satiin nii Jesoso coitucuureraauru, chaen Calileea caje coauneein sacuurera enecuru, naaonjoainuri jetao ecu neein coarajeeure jelai caje amuelanaala nita netiin. ");
INSERT INTO uraNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nii jana jetaote, ecu ne leinjiin cacha Jodea batane que nenaa Arimatea cocoaichaneein nenaa Jose. Aca jetaote, caohacha cachaneein, satiin Jorioocuru rai nelateein Jorioocuru coaaraneein nenacaauru- Junta Suprema tabaneein nihane sainejeein, turuha uha Cana Coaunerane Cojoanonaane cohajihane jaun jetao, nitohaneein nii Jesoso teeuruha nii rai leeochaauru Junta Supremacurune rautaain coaraene. ");
INSERT INTO uraNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nii Jose jetaote, Filato caje Jesoso jaberoco bajaa cue, rucuhecane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nitohaneein bajaain jetaote, coroso caje fauhin jetao, shojoera que conajaain jetao, jaiti chuni onaa teeurenihane jaan ichatane ramara que nenaa ajeri jachu cuhane jetao rucuheca cuure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nitohaneein jetaote, inae nunuheneelalajiha nebetacanaa cojoanonaane jaun, inae niicha ichanenu ichana nainecuruhane nainejeein jetao, luhecaain nii Jesoso rucuhecure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nitohaneein Jesoso jaberoco rucuheca cuuruhane jana jetaote, acaauru aina cuure Calileea caje coaauneein jiniichaain unacaauru enecuru. Nitohaneein cuhin jetaote, caohachaain rai jaberoco rucuhecuruha ajeri jachu cuhanene coaracure. ");
INSERT INTO uraNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nitohaneein ajeri jachu cuhane rai jaberoco rucuhecuruhane jana caohachaain coaracuruhane baiha jetaote, nenajaun cauhin jetao, meetoon rijijieein jujuaain nenaa ichacuruhane nainaain jetao, Quiricha inoaensi cuhane aitoha Cana Coaunerane rijijieein, nebetacanaa cojoanonaa bana nebetacaaure nii enecuru. ");
INSERT INTO uraNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nitohaneein nebetacaauruhane cojoanoo janohetiin jetaote, nii teeuruhane jaan ajeri jachu coaraa cuure nii acaauruhacha ichai jujui amaain nii enecuru. ");
INSERT INTO uraNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ecu turuhin coaracuruhane jana jetaote, elonanohi ne nii ajeri jachu fuuruhane jaa ajeri jaberoco. ");
INSERT INTO uraNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nii jana enohin coaracuruhane jana jetaote, inae ecu Cana Curuaanaa Jesoso jaberoco eruurene. ");
INSERT INTO uraNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nii jaun jetaote, niicha ichanenu coitucuelanaala nesoonetooruhane jana jetao, somaratohanai que cajionequiin, ecu luhecotariin acaauru aina ecocohin temeenete coroatajai cacha. ");
INSERT INTO uraNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nii coaraain jetaote, nesoone caaun, suujua acatecuruhane coaaratiha nenoracaauruhane jana jetao: “Chanuna onacaauru jana, ichaohin nenaa ariiche inara. ");
INSERT INTO uraNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Inae ichanaane jaun, coatiha cau nihei. Tana Calileea inara aina nihane bana inara rai: ");
INSERT INTO uraNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Acaihaniji cachaneein nejanohanaaneein nenaate, necha aansaineein ichaonacaauru rai tenojoineein niha cureein. Nii janate coroso que teein ateinaa cuurureein. Nete nichata janohane cuhane ichanareein,’ narejetoha inara raine que nainaquicheneta,” naaure jetao ecu ecoonacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Niritocuruha acaauru raine que nainaain jetaote, acaauru rai aitoroaetoha Jesosone coaaucure. ");
INSERT INTO uraNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nitohaneein inae nainaain, nii atane bana caje jelaiha cauhin jetaote, jitariin nii acaauruhacha coarai biha jetao cuure lechoonca leinjiin afosotooru rai, chaen satiin acaauru aina nenacaauru cachaauru, naaonjoainuri rai. ");
INSERT INTO uraNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nitohaneein coaraain afosotooru rai biha cunacaauru jetaote, Maadala bene Mariha, chaen Joana, chaen Saantiaao neba Mariha, chaen leeochaauru enecuru acaauru aina cunacaauru, naaonjoainurine. ");
INSERT INTO uraNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nitohaneein turuhin beeuruhane jana jetaote, acaauru esenetana jerecurene afosotooru. ");
INSERT INTO uraNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nejetaote, nii acaauru esenetaaurenihane sainejeein soroneein jeluhariin cuhin turuhin, nii atane bana cuhanai coaraa Fedorone jana jetao, nii conaacuruhane jaa shojoeraacha ecu codoheque. Nitohaneein shojoeraacha eruhane jaun jetaote, jataain cojoelatiin jelaiha nenaanajaun cauha cue Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nii bananeein jetaote, enoto chujutora rijiu fautaain amunaanaja itaanejeein nii Jerosaleen caje nenaa Emaoso neseu jetao, cuure coroatajai Jesoso aina nerelanacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nitohaneein Jesoso ateinaauruhane que ereerejeein bero cuhane cuujeeuruhane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","jaiti que ereerejeeuruhane jana, acaauru rohan nichuutaain jetao, acaauru aina bero cuhane cuujue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nejetaote, acanihane coitucuurene, acanihane coitucuuruhane jereniha Jesosone jaun. ");
INSERT INTO uraNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nitohaneein jetaote, acaauru rai: “Chaaquena bero cuhane ereerejeein cuujueeiche,” naa acaauru rai Jesosone jaun jetaote, ecu inaderatonanaain inacuhin jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","“Ii netonai Jerosaleeun neeinatiinna: ‘Naaonjoain ichacuruha caa janonaacha cuhanera,’ naain coitucueneeite,” naain tonoraa nii bero cuhane cuujuenaa coroataja Cureeofasine jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Chatohaneeuruhanaate aitohi,” naane jaun jetao: “Nasarete cocoaicha Jesoso, satiin cachaauru notaracae nere que irihane naitoonjoan ichaain, itolere que laraajiin Cana Coauneraacha letoai profetaneein nihanatiinte ");
INSERT INTO uraNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Romanocuru rai coulurujueeure saseredotecuru curuaanaacuru, chaen cana rai cocoinanacaihuri, naaonjoaihunri, coroso que teein ateinaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Canacaanune niqui, cairichaerinojoineein neeuruha Isaraeli cocoaicha nichaachene ichoteratihane cohajihacaanu. Nete inae nichata janoha nitohaneein ateinaauruhane saijieein, ");
INSERT INTO uraNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","canacaanu aina nenacaauru enecuru tabaauru, janonaa aonaain cuhin natane bana coaraa cuuruhane jana, ");
INSERT INTO uraNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ecu Jesoso jaberoco eruurenihane jaun, jelaiha nenaanajaun cauhin canacaanu rai beein canacaanu socoinaaure. Acaauru rai ecocohin jete: ‘ “Coatiha cau nihei Jesoso jaberoco, inae oo caje ichanaane jaunta,” naaunre anjeraauru,’ naain beeure. ");
INSERT INTO uraNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Niritocuruha turuhinne jaunte, canacaanu caje nenacaauru tabaauru netonai cuhin, nii atane bana coaraa cuure. Nii janate chuhisi, nii aitocuruha enecurune rijijieein, inae ecu nene Jesoso jaberoco. Niheichu nii Jesoso nihanatiin coaracuruhi,” nae jetao rai Cureeofasi. ");
INSERT INTO uraNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Niritohane jaun jetaote acaauru rai: “Chanuna cha esenetana jerelanaala, nii aitocuruhalu profetacurune coacuhin esenetana jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tana jauriaanejeein dedeeu cusihane ajiniha, catohaneein necairicharichaain Mesihasine coitucuhicheneta,” naane baiha jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Moisesa quiricha caje coaauneein nunuheteein jetao, que aitiin laenacuruhalu profetacurune beebejeein jetao, acaauru rai ereereje Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nitohaneein nii cuuruhane jaan, Emaoso neseu turuuru jana jetaote, rauhijiriin situujiha cunaa rijijieein cuujue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nejetaote: “Cauna canacaanu aina nesuruure. Inae jataain sohane jaun nocohejia natiin,” naain jetao chunaaure. Nitohaneein chunaauruhane jaun jetaote, ecu acaauru aina nesurue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nitohaneein acaauru aina nesuruhin jetaote, lenonecuruhane coina nelauriaauruhane jana jetao, faa teberiaain Cana Coaunera bajaane baiha jetao, acaauru rai beeunebeeuneein te. ");
INSERT INTO uraNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nitohaneein faan tihane que nainaain jetaote, Jesoso nihane coaraain acanihane coitucuuruhane jana jetao, inae acaauru caje jianatoroaain amue. ");
INSERT INTO uraNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nitohaneein jianatoraain amuha acaauru cajene jana jetaote: ecu jelai nedaain ita rai nejesinajeein, “Esinae rauhijiriin acanihane jaun jiara bero cuhane uujueein, ereerejiha Cana Coaunera Quiricha inoaensi quene jana, aca netoojoaain naonae cana suujua cuhanaina,” naaure jetao ita rai. ");
INSERT INTO uraNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Niritocuruhane baiha jetaote, caeneenejelanaala jelaiha bero cuhane soroneein cuhin Jerosaleen, ita taojiaain neeuruha lechoonca leinjiin nenacaauru afosotooru aina acaauru leeochaaurune jaan cauha cuure. Inae nii Jerosaleen nenacaauru rene turuuruhane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Esinae rauhijiriinte inae ichanae Cana Curuaanaara, Simoon raite inae ecocoera,” naain jetao acaauru rai beeure. ");
INSERT INTO uraNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niritocuruha acaauru raine jana jetaote, bero cuhane acaauru rai netonai ecocohin acaauru aina cuujihane beein, acaauru aina lenoneein faan teberiaain, Cana Coaunera bajaain acaauru rai tihane que nainacuruhane beeure jetao nii acaauru ajiniha netaojiaain nenacaauru rai, nii coroatajaihuri Emaoso coero cuhane cunacaauru. ");
INSERT INTO uraNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Niritiin acaauru rai bero cuhane ecoocane que jaiti ereereecuruhane jana jetaote, luhecotariin acaauru cataaun neeoritiin: “Raotojoeein neeuche,” naa acaauru rai Jesosone jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","“Rai corii jecha coaracure,” naauruhane jaun jetao jataain nesoonetoore. ");
INSERT INTO uraNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nitohaneein nesoonetooruhane jana jetaote: “Chanuna jataain nesoonetohiche. Chanuna nainanacharanejeein, baasoneein inara suujua cuhane coaauquiche. ");
INSERT INTO uraNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cacoiichuru, catihacuru, naaonjoaihunri coaracuchenachuhiti, jeelai cajabereeoneeinte neeure caa cajabereeocuru. Cajabereeo mucuhin cacoharaauche. Leinjiin onaa corii, caa cacoaraaichene tocoaneein bucuhin, jaberoconeein nichaauraain nenaa naineriheita,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Niritiin jetaote, coroso que teein, rai tijia, biji, naaonjoain curuabaauruhane jaacuru coaarate acaauru que. ");
INSERT INTO uraNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nejetaote, jataain esenetana jerecurene, jataain cojoelatiin rachoojoeeuruhane jaun. Nitohaneeuruhane jaun jetaote: “Tana cau enohalanohineein niha cau chaelai lenone nijine,” naain acaauru caje bajaane jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","niha ate basichone jaun, rai teeuruhane jaun jetao, ");
INSERT INTO uraNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ecu acaauru notaracae netiin que lenone. ");
INSERT INTO uraNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nitohaneein lenonihane baiha jetaote acaauru rai: “Caa catohaneein caetecuruhanene quene inara rai berejetoonlu, jaiti canu atinaaurenihane jana inara aina nihanune bana. Inae catoaneein caetecuruhane coina, rai quiricha cuhane itolereneein caque aitiin laenaalu Moisesane nainaain, chaen aitiin quiricha cuhane laenacuruha profetacuru, Salmo naaonjoain cuhanene rijijieeine inae nainaaun,” naa acaauru raine baiha, ");
INSERT INTO uraNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Cana Coaunera Quiricha inoaensi cuhane aitoane rijijieein acaauru que coitucuherateein jetaote: ");
INSERT INTO uraNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Laenanohineeinte ne, canu Mesihasi nichaaunne ohanune baiha, nichata janohane cuhane ichanacaaunne que. ");
INSERT INTO uraNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aihana jaun, canuhacha cocoainanohineein Jerosaleen caje nunuheteein, satiin atanecuru sacuritaain cachaauru rai, ‘Esinae rauhijiriinte, coreniha ichoteratenohineein nerichaacheein,’ naain beeuchete, nacoaauneein Cana Coaunera coacuhin suujua coreein neeuruhine acaauru osa caje acaauru ichoteratiha Cana Coaunerane coina. ");
INSERT INTO uraNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Inarate caa ohanune caje ichanacaaunne coaaraneein neeiche. ");
INSERT INTO uraNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Canune inara rai Ofa aitoonjoalu tereeunni. Aihane jaun, jiaonriha caa Jerosaleen caje amuhiche, laraajiin neeichene jaanu dede caje unaa raaichene reeitihaaineta” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Niritoha acaauru raine baiha jetaote, Jerosaleen caje amanajaain jetao, Betaniau turuanajaain, ecuun biji sijirichaain jetao acaauru cojiotae. ");
INSERT INTO uraNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nitohaneein acaauru cojiotaain coroaenaacane baiha jetao, inae dedeeu cauha cue, ecu acaauru ratiriin. ");
INSERT INTO uraNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nii jana jetaote, ecu Jesoso coroaecuruhane baiha, jataain rachoojoeein jelaiha Jerosaleeun cauha cuure. ");
INSERT INTO uraNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nitohaneein cauhin jetaote, itolere bana Teenforo asae Cana Coaunera coroaerejetecurelu.");
INSERT INTO uraNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Jaurianejeeinte nenaa ne caa Erenaa. Itolere, dede, cana rai chauratane, naaojoain coaunaa Cana Coaunerane ajiinihate nelu caa Cana Coaunera Ere, jelai Cana Coauneraneein. ");
INSERT INTO uraNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nii jelai Erenaa quete itolere coauneratelu Cana Coaunera. Nihei nii colane necoaunaain nei. ");
INSERT INTO uraNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nii Erenaate ichaonaa teraneein ne. Nii ichaonaa teerate, cacha cononeein ne. ");
INSERT INTO uraNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nii Erenaate, cononeein nocohena conaeraneein ne. Jacatiasihei nocohena tabai. Charijieein teinti cana rai chauratane conae caa enoto. Nii rijijieinte cacha suujua conae nii Erenaa. Amuritonaa nainesihei nocohena tabai. ");
INSERT INTO uraNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","9","Inae chauratane que turuelalajia nii cono esine, satiin cachaauru conoaeranune janate, Joaan letoae Cana Coaunera, nii cono que ereerejeein cachaauru relaane, aonaain esenetaain coitucuuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nii Erenaa quete, chauratane coaunerate Cana Coaunera niqui. Nete cajia chauratane que turuhane jana coitucuurene caa chauratane que nenacaauru, niicha coaunanohineein neeuruhane saijieein. ");
INSERT INTO uraNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Caa niicha coaunai chauratane que turuhane janate, que jaolequiin raaurene cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nii janate, atiin raain esenetaaure coroatajajei cachaauru. Nii corenihate, calaohi raane rijiijieein acaauru rae Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Joaereein cacha calaohi rijiijieein nihei inae Cana Coaunera ere esenetaane cacha. Rauhijiriinte Cana Coaunera calaohi rijijieein nereein nii Erenaa esenetaane. ");
INSERT INTO uraNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nii Erenaate, cachaneein nejanoain canacaanu aina ichoae. Nii jaunna aina amuemujueein coaracaanune jaun, leinjiin acaihanejeein Cana Coaunera Calaohineein nihane coaracaanu canacaanu nota que, jerichanejeein Cana Coaunera rijijieein chabana nohanelanaala rauhijiriin canacaanu belaihana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nii janate, turuha uhane jana: “Taa quenara aitonajacoonra, ‘Canu caaijiete turuha ureein canu ajiniha nenaara,’ naain aitonajacoon,” nae Joaan, nii Erenaa cojoeluhin. ");
INSERT INTO uraNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Inetono janonaa banate, satiin cacha belaain cana coroatajane nii Erenaa. ");
INSERT INTO uraNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisesa quete rai naitoonjoan berateein laenaeratelu niqui Cana Coaunera. Nete tonoraaurene cachaauru. Nii natiinte, atiin cachaauru belaiha ichaonaa rauhi que cachaauru relaane coina turue Cana Coaunera Calaohi Jesocurisito, nii cacha relaana jaan ichaonaa rauhi raauruha cachaaurune coina. ");
INSERT INTO uraNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Chabana Cana Coaunera coaracuruhi cachaauru niqui, nete inaca Cana Coaunera coitucuhane jaun, nii inaca que cana relae, acaihanejei Calaohineein nihana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Joaan renete batirichuru letoaaure nii Jerosaleen nenacaauru bichauhenaauru: “Chaneeita,” naain Joaan caje bajaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Inae Joaan rene turuhin bajauruhane janate: “Curisito nihaunta,” naain rauhijiriin tonoranaaca Joaanne jana: ");
INSERT INTO uraNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Chaneei najian. Cana Coaunera ere bera Eliasineeina,” naain coaiteen bajaauruhane jana: “Aca nihaunta,” naain coaiteein tonoranaaca Joaanne jana: “Aca neneeina jaun, chaneei najian. Nii turuha niicha jerecuri canacaanuhacha cohajei Cana Coaunera ere beranecaai,” naauruhane janate: “Ahan- aihei, aca nihaunta,” naain tonoranaaca coaiteenne jana: ");
INSERT INTO uraNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Chaneei najian. Beeinete ne, bihacaanu canacaanu letoaurera raine coina. Chatoanai icharaneei najian,” naain bajauruhane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","“Canu quetejian, nerichaain leinjiin cacha, cacha areeroo cuhin eeheehejeein cacha cotiaranura: ‘Turuha cana curaanaane jaan coero raujiauchera, naain beranura,’ naa Isaihasi najaan nichaaunra,” naain biha Joaanne jana: ");
INSERT INTO uraNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","“Chanuna jana chaen, acau que cachaauru coujunacateei, nii canaacha cohajei Mesihasi neein, niheichu Eliasi neein, niheichu leeocha Cana Coaunera ere bera- profeta neein, naaonjoainuri neein nenaalanaala,” naain bajaauruha nii fariseeocuru letonocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","“Acauhanau teeinne canu, cachaauru cojunacatiha baotisanajaaun. Inae turuha urichaain canu caaijie inaraacha coitucuhi cacha. ");
INSERT INTO uraNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Canu caaijiete turuha ureein, nii inoaelu nenaa cacha- jataen canu amuritoeriin cocoainanacai,” naain acaauru rai be Joaan. ");
INSERT INTO uraNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nitohaneeinte, Jorodaan jeraniha nenaa Betabarau niha Joaanne jana, Jerosaleen caje uhin Joaan rene turuhin bajauruhane janate: “Canuna laen cacha areeroo eeheehejeein cacha cotiaraneein neeunra,” naain acaauru rai be Joaan- cacha coujunacatera. ");
INSERT INTO uraNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nii cojoanoote, tajia uujiha Cana Coaunera Calaohi Jesosone jana coaariin: “Notara Cana Coaunera carenero narejeenta. Taate itolere caa chauratane que nenacaauru cachaauru caje osa itajeranu que oha cureeincha. ");
INSERT INTO uraNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Taa quenara aitonajacoonra, ‘Canu caijiete turuha ureein nii canu ajiiniha nenaa cacha,’ naain aitonajacoon. ");
INSERT INTO uraNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Inae niqui inoaelu caje coauneein nesianiha niqui, nete caa cacaijie turuha uhe. Canu netonaichu coitucuhaunlu jauriaa nejeein. Jianacoo cana mitaeraunu que Cana Coaunera letononeein nihane coitucuhaunlu. Nena laen inae ena coitucuun, carai biha caletoaerana jaun. Isaraeli cocoaichacuru que coitucueratihanune coinate, carai beein caletoae caletoaera. ");
INSERT INTO uraNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Osa caje cana mitaeranu que letononeein nihane coitucuhaunlu niqui. Nena, ‘Leinjiin cacha choaae fauha uha serori rijiijiein Cana Coaunera Suujuenete, Cana Coaunera Suujue que coujunacatihate aicheeincha,’ naain carai biha caletoaerana jaun, choaae fauha uha dede caje serori rijijieeine coaracaunna jaunna coitucuun. ");
INSERT INTO uraNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nii jaunna, ‘Acate Cana Coaunera Calaohi inecaihara,’ naaun, nitoanihane coaracaunna jaun,” naain be Joaan. ");
INSERT INTO uraNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nii cojoanoote jelaiha Betabarau coroatajai nere tonoraerauru Simoon Fedoro ocoala Aanderesi, chaen canu, naojoaain nihacaanu Joaan ainane jana, ");
INSERT INTO uraNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","situha uhe Cana Coaunera Calaohi Jesoso. Nii janate: “Taa Cana Coaunera carenero narejeen coaracuchera,” naain biha Joaan canacaanu raine jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cana Coaunera Calaohi Jesoso coaariin caijie cuhacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nitohaneein caaijie cuhacaanune janate, jaotoraain canacaanu coaariin: “Chate ichaquiche niriirijieeinta cachaauru,” naa Cana Coaunera Calaohi Jesoso canacaanu raine jana: “Chute neei aaita cacha relaera,” naacaanune jana: ");
INSERT INTO uraNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Chajauchetejian coaanicha,” naain canacaanu amaane jana, inae enuna macoijiu teejia enotone jaun, cuu aina sonafaacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Nii baihate, nihana Simoon Fedoro ariha cue nii Aanderesi. Ariin, ruhin: “Inae canaacha cohajei jianacoon cana mitaeranu que- Cana Coaunera letono Curisito eruhacaanura,” naain nihana Simoon Fedoro rai biha cue Aanderesi. ");
INSERT INTO uraNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nii baihate, Cana Coaunera Calaohi Jesoso rene, Simoon Fedoro turuaa uha Aanderesine jana, Simoon coariin: “Jonasi calaohi Simoonneei niqui, nete Fedoro nereein ichurujuara,” naain Fedoroneein curaate Cana Coaunera Calaohi Jesoso, aca laraajiin nere beraneein nerichaine coitucuhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","46","Nii cojoanoote Calileea batane que cuna jaaun, Ferifi aina itaque tacauruhana jaun: “Caniha neeorihura,” nae Cana Coaunera Calaohi Jesoso, Ferifi rai. Fedorooru nese Betesaaida caje unaa nii Ferifi netonai. Niritiin cotihacane jaunte, Natanaaeli ariha cue Ferifi. Ariin, eruin: “Inae turuha nii Cana Coaunera Quiricha Inoaesi cuhane turuha uha niicha jerecuri eruhacaanura. Nii cacha- canacaanuhacha eruhite, Jose calaohi- Nasarete cocoaichanera,” naain biha Ferifi, Natanaaeli raine jana jetaote: “Chaquete nelatere Nasarete cocoaichata,” naane jana jetao: “Chajaachaautejian coaanicha,” naa Ferifine jaun, Ferifi jiniichaain uhin turuha uhe. ");
INSERT INTO uraNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nii janate, inae rohan nichuuntaa Natanaaeline jana: “Nocoa inae uha Isaraeli cocoaicha esine- coritanacae lanaala nenaara,” naa Cana Coaunera Calaohi Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Inasiinte cacoitucuhita. Cacoitucuhi inachute,” naane janate: “Eejeen- aihanura. Ii cotihaca uha Ferifine ajinihana inae ii coitucuun. Nii uheraneein curajaain enuha asaae neeine janana, ichoharajeeunra,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Iite Cana Coaunera Calaohineein canacaanuacha cohajei Isaraeli curaanaa Rey neeicha cacha relaera,” naa Jesoso rai Natanaaeline jana: ");
INSERT INTO uraNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","“Nii uhera asaae neeine coaracaunne que aitocoaunne najaanchana canu esenetaai. Inae jataain nii amuritoeriin coaariquiincha. ");
INSERT INTO uraNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Rauhijiriina aitoonra. Inae nejoracaa dede bacuujuane janate inaraacha cohajei Cacha Calaohi nichaunne choae fauhin, jelaiha iniha cuuruha Cana Coaunera letonocuru aanjeraurune coaariquiincha,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nii baihate nichata janohi catiariin Calileea batane que nenaa- Canaau neein curajain nenaa neseu ne nisirihatiha cachana jaan beseta. Nii jaunte, cuu nii beseta bitoaa cue Cana Coaunera Calaohi Jesoso neba. ");
INSERT INTO uraNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nii janate Cana Coaunera Calaohi Jesoso netonai cotihacure nii beseta que, aina nerelanacaauru aina cuhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nitohaneein inae nii beseta que neeuru jana jetaote, inae saa binone jana: “Inae nihei binota,” naain Jesoso rai biha nebana jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Saan. Chanuna niriitohi caraite oma. Inasiina jaiti turuha canu amihaneeon nunuhetihanune jaan cojoinaca que ne coalanaala,” naa neba raine janate: ");
INSERT INTO uraNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","“Chajaaincha naitoojoaancha ichacuchera,” nae nii cuu bino chaluurera rai Jesoso neba. ");
INSERT INTO uraNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","7","Nii janate cuu ne Jorioocuru rai saotaneein baichaje tabaanaain- atane caje ichanohineein, Cana Coaunera notaracaae biji culejeein itolere acaauru lenonecuru culejeein ratirihuruhana jaanu que jesinaaeca teeuruhana jaan. Nii jaunte: “Caa cuhane acau raain teeuche nainecolijiaanaaincha,” nae Jesoso nii bino chaluurera rai. Nii le baichajete baichaje seeojoan cuhane coroata baichajihanaai curujuae. Inae nii baichaje nainecolijiaanaain acau raain, teein beeuruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Soriin amaain, taa beseta erora cocoanihura,” naa Jesosone jaun, soriin amaain nii beseta erora cocoae nii acau chaluurera. ");
INSERT INTO uraNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nii janate Cana Coaunera Calaohi Jesosohacha rotoi nihane coitucuelanaala coe nii beseta erora. Acaihanejein nii acau raureraachate coitucuure. Nii jaunte nii bino cohin aonaain: ");
INSERT INTO uraNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Raotoha caa bino,” naain, “Chajataauraa,” naain, nii ene ranaa jerera cotijiain: “Raaotoha caa ii bino. Aihuruha leeochaaurune rijijieein, bino caohacha que nunueteein cana cocoaerate lanaalate aaita. Taoniin nunueniha canaacha coi amuritoeriinte raaotera,” nae nii beseta erora, nii ene ranaa jerera rai. ");
INSERT INTO uraNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nitohaneeinte Calileea batane que nenaa nese Canaau, binoneein jesinaaeca rotoe Jesoso, esinae Cana Coaunera letononeein nihane coitucuuruha cachaaurune coina. Nii coaraaina, esentaacaanu aina nerelanaa nichaanune. Nitohaneein nunuheteeinte, itolere cunaitenacaauru rautaain, itolere ichae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nii baihane Caferenaaon cuha Jesosone jana, corianiha cuhacaanu, nejeraauru, neba, aina nerelanaa nichaanune naaonjoaain, cuu neeorihacaanu inata janojoeine coina. ");
INSERT INTO uraNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nii janate Jorioocuru beseta Fasocoa que turuelalajihana jaun, turuha cue Cana Coaunera Calaohi Jesoso. (Fasocoa besetate bitohaure Jorioocuru ajelanaala, nii Teenforo asaae. Cairichaaerinajaain niha Egipto curaanaane caje jianacoo mitanajaa Cana Coaunera najaan- cojoanonaaniha nii Fasocoa besetana jaunte, nitohaneein Fasocoa beseta cojoanonaa bana Teenforo asaae itataojiain Cana Coaunera coroajeein bajaaure Jorioocuru.) ");
INSERT INTO uraNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nii janate Jerosaleeun nenaa Cana Coaunera rai ita taojiauruhana jaan loreri inoaesi- Teenforo asaae necoretiha neeure Jorioocuru, itolere baca, carenero, serori naaonjoain que. Nii janate ecu jelai teein ne cachaauru rai coriqui coreeurera. Niite acaauru coriqui choae laurujua laurujuauruhane jana, ");
INSERT INTO uraNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","sicho coinori que rajirajinajaain, nii acaauru rai bacaauru, carenerocuru, naaonjoain aina curuaataain, acaauru sitaain, nii coriqui coreeurera rai coriqui riariae atane choae. Acaauru coriqui rori raatiin sieitiin, ");
INSERT INTO uraNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","chujuhecoha nii serori que necoretenaane jana: “Naain caa serorichuru amaauchera. Coa caa Ofa Cana Coaunera loreri asaae necoretihachera,” naain sitanajae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nii jaunte, “Jataain ii loreri beraihanunete ne,” naain aitosihalu Cana Coaunera Quiricha Inoaesi cuhane nii canacaanuhacha cohajeine jaun, “Aca caara,” naain canacaanu suujua cuhane Jesoso coarajiacaanu aina nerelanaa nichaanune. ");
INSERT INTO uraNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nii jaunte sitanajaa Jesosone jaun: “Chatohanai jana ichaain canacaanu notaareei jana, esinae Cana Coaunera letononeeine coitucuhacaanune coinata,” naain Jesoso caje bajaauruha Jorioocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","“Caa Cana Coaunera loreri chamuhitiin jaohichenena, nichata janojoeincha cuhane michureeunni nacoaauneeincha,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Inasiinte jenachoonca saota jaanacaain ichacuruhalu jetao natiin, iicha nichata janojoeeincha cuhane michureeita,” naaure Joriocuru Jesoso rai. ");
INSERT INTO uraNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Rai jaberocohacha quete aite, nii Cana Coaunera loreri que ujuaiteein. Nii jaunte nichata janojoeein ichanae Jesoso- oo caje. ");
INSERT INTO uraNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nii jaunte nichata janojoeein ichanaane coaracaanune jaun, inae jauriaa aitosihana jaun, canacaanu suujua neeoritohana jaun, nii aitoha Jesosone esenetacaanu, Cana Coaunera Quiricha Inoaesi cuhane aitohana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Fasocoa bana cuu Jerosaleeun neein, bacosacuru, maosacuru, urichosae, naaojoaunri rautaane coaraainte, Cana Coaunera Calaohi Jesoso esenetaacoaaure arajii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nete, “Naaojoaainte chuhisi, esinae rauhijiriin quesenetaurureeincha,” naene Jesoso, acaauru suujua coitucuhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","“Naaojoaaunruha caa cachaaurura,” naain biha chuneine que airijiinte, cacha suujua coitucuhana jaun, saneein esenetanajaene Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Leinjiin fariseeo Necodemo neein curajaain nenaate nii lelauriin Jorioocuru bichauhenaneein ne, acaauru rai jataain nelateineein. ");
INSERT INTO uraNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Niite janotiin Cana Coaunera Calaohi Jesoso rene turuha uhe. Turuhinte: “Eletoaa Cana Coaunerane coitucuhacaanura. Iite itolere bacosacuru aina cunaitenacaauru rautaeraneein neeicha. Nitohanai ichana nainihei jelai cacha Cana Coaunera colaneta, cacha relaera,” naa Necodemone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","“Esinaena rauhijiriin aitoreeunni. Enacoaauneein nejanoaeniha cachane, Cana Coaunera aina jiniiquiin nenaa nainihei” naa Jesosone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Inasiina enacoaauneein nejanoare ichauhena. Inasiinte coaiteen neba suuri cuhane neloroaain nejanoare ichauhena,” naa Necodemone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","“Esinaena rauhijiriin aitoon. Nihei acau nejei, Cana Coaunera Suujue naojoain que coujunacatenoineniha cachane, Cana Coaunera Ere tonoraeraneein nenaa nainihein cacha. ");
INSERT INTO uraNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jana, cacha caje nejanoanaate- jelai cachaneeinne. Jana, suujua culejeein caruruhin coriha Cana Coauneranete, Cana Coaunera cachaneein ne. Colane aihei. ");
INSERT INTO uraNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Cana Coaunera Calaohi coitucuhin esenetaain nere tonorana jereraaurute nejanoaain Cana Coaunera cachaneein nereein. Coaa caa ichei caritocoaaunne cojoaelatiincha caeneein aonajiha,” naa Jesoso, Necodemo rai. ");
INSERT INTO uraNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Niritiinte, “Charijieein teeinti tiririjiin uha cujuanane, ‘Naaojoain cajete uhera,’ naain coitucueneei. Niheichu ‘Cuute cuera,’ naain coitucuheneei. Nii rijijieein techu, ‘Naojoainte cacha rai ichaonaa te Cana Coaunera Suujue,’ naain coitucueneeicha,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Chatohanihana,” naa Necodemone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","“Jataain Isaraeli cocoaicha relaeraneei inatiin, ta carihanai coitucuhine. ");
INSERT INTO uraNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Esinaena rauhijiriin aitocoaanu, canacaanu nota que coaracaanune jaun. Nete, aitocoaanune esenetaeneeichera. ");
INSERT INTO uraNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Caa cana rai chauratane que aitocoaunne esentaeneeine, chatohaneein jana dedeeu ichaonaa bihanune esenetareei. ");
INSERT INTO uraNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nihei chunei dedeeu iniin coaara. Canuna laaen dedeeu nihanune caje uhin cau turuun cachaneein, itolere caa chauratane que nenaa cacha rijijieein nihanune coina. Canuna Cacha Calaohineein inaraacha cohajeineein neeun. ");
INSERT INTO uraNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Charijiieein teeinti, coaata caje acano ichaain, enuha que nujuateein chujuraa Moisesane coitucuhi chachu natiin. Nii rijijieein techu, enuha que nujuateein Cacha Calaohi nichaunne chujuraa cuurureein, ");
INSERT INTO uraNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nitajenaachara nejeein nenaa ichaonaa raa quesenetaerane coina,” naain, ");
INSERT INTO uraNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Jataain caa chauratane que nenacaauru cachaauru belaitoha Cana Coaunerana jaunte, acaihanejein calaohi nichaaunne letoae caa chauratane que Cana Coaunera, nitajenaachara nejeein niha quesenetaain cacoitucuurera cachaaurune coina. ");
INSERT INTO uraNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Coatiha cacha casetecaanune coina calaohi nichaaunne letoaai Cana Coaunera. Jianacoo osa caje cacha mitaanune coinate, cau calaohi nichaaunne letoae Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nii Cana Coaunera Calaohi nichaaunne esenetaa cachane, caseteco coaarinaain. Jana Cana Coaunera Calaohi nichaaunne esenetaaite, caseteconeein niha cureein, acaihanejein Cana Coaunera Calaohi nichaaunne esenetaenihana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cono rijijieeinne turuun caa chauratane que Cana Coaunera Calaohi nichaaunne, cacha conaeranu que niqui. Nete nii cono jerecurene nii Cana Coaunera Calaohi nichaaunne esenetaauruhi cachaauru. Acaihanejein nocohena janaachate nenaa jerecure, nocohenaanau neein suujua coaraelanaala baaso ichacuruhane coina. Nii corenihate caseteconeein neeurureein. ");
INSERT INTO uraNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Baaso ichacuruhane coaracuruhane coataate, cono rohan nichuuntanaa jerecurene saain nii baasoneein nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jana caohachaain ichaaoruhanete, cono rohan nichuuntaaure, Cana Coaunera jerenohin ichacuruhane coaracuruhane coina,” naainte Necodemo rai aite Cana Coaunera Calaohi Jesoso raaje neque. ");
INSERT INTO uraNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nii baihate Jodea batane que cue Cana Coaunera Calaohi Jesoso, aina nerelanaa nichaanune aina, cuu inata janojoeei nejeein neeoriin, acauhanau cachauru teein coujunacatenajaain baotisanajaane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nii janate, Salim rohan nenaa Enoon, cachaauru coujunacatiha ne Joaan, cuu niha tabaain acauna jaun. Nii janate cuu turuhajeeure cachaauru, acauhanau teein coujunacatenajaain baotisanajaa Joaanne coina. ");
INSERT INTO uraNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","26","Inae Joaan enoaene lalajeeuruha caresero cuhane janate, acauhanau teein cachaauru coujunacateein baotisaa Jesosone jaun, ita cotaicha rijiitocure Joaan ere tonoraaurera, leinjiin Jorioo aina. Nii baihate Joaan rene turuhin: “ ‘Cha,’ naau. Taolu ii aina Jorodaan jeraniha nenaalu leinjiin cacha canacaanu rai iicha beebejeilute, enene acauhanau teein cachaauru coujunacateein baotisanajaa ne. Saainte inae aca ere tonoraaure,” naauruha Joaan rai nere tonoraaurerane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","28","“Saan. Jeriha Cana Coaunerane jaunte aihure. Inae inara rai rauhijiriin aitonajaaocaaun, ‘Coatiha Curisito nihaun,’ nanajaaocaaun. Canute letoae Cana Coaunera nii beraanu que. ");
INSERT INTO uraNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Charijieein teeinti, inae comasai raa cachane coroaje rai belaicha. Nii rijijieein inachu canu netonai coroajeeun, Cana Coaunera Calaohi Jesoso ere tonoraauruha cachaaurune. ");
INSERT INTO uraNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aca ere tejian tonoraa cuurureein cachaauru, jelaichoae jauhecotojoeriin. Jana canu erete tonoraa cuurureein fautojoeriin. ");
INSERT INTO uraNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nii dede caje unaate, itolere cacha curuaanaa neein ne. Jana chauratane que nenaa cachate, niicha coaraaicha coitucuujue. Jana aihei dede caje unaa. Itolere dedeeu nenaa, itolere caa chauratane que nenacaauru, naojoainte coaraain coitucue. ");
INSERT INTO uraNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Acate itolere niicha coarai coaraain be niqui, nete esenetaaurene caa chauratane que nenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Jana esenetaa cachanete, esinae rauhijiriin aitoha Cana Coaunerane coitucuha cureein, jelai Cana Coaunera Suujue que suujuecoha Cana Coaunera Calaohi Jesosone jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cana Coaunerate, nii letono calaohi belaitohana jaun, itolere cacha curuaanaa nihane coina cocoainae. ");
INSERT INTO uraNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nii jaunte Cana Coaunera Calaohi esenetaera, nirijijieein nitajenaachara nejeein nenaa ichaonaa raa cureein. Jana, nii Cana Coaunera Calaohi esenetaite nitajiha cureein Cana Coaunera casetecanohi neein,” nae Joaan- Cacha Coujunacatera, nere tonoraaurera rai. Nitohanihalu inae Joaan enoaene lalajeeuruha caresero cuhane rai. ");
INSERT INTO uraNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Joaan cacha coujunacatera ere tonoraauruhane amuritoheriinte, Jesoso ere tonoraaure arajii cachaauru. Chaen “Aca jete, Joaan amuritoheriin acauhanau teein cachaauru coujunacateein baotisanajae.” naain coitucuure fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Coatiha aca, acauhanau teein cachaauru coujunacateein baotisanajaai. Acaihanejein canacaanu aina nerelanaa nichaanunechana acauhanauteein cachaauru coujunacateein baotisanajaacaanu.) ");
INSERT INTO uraNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nii jaunte nii coitucuhin, Jodea batane caje mituhin, Calileea cauha cue Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","5","Nii Calileea batane que turuhane coina, nii Samaria batane choae situhin, Sicaraneein curuajaain nenaa neseu turue Jesoso, calaohi Jose rai Jacoboacha tei atane rohan. ");
INSERT INTO uraNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nii jaunte cuu niha atane jachu ucuaatiin acau mitunajaan Jacobo curuaa siriina jaun, enoto chujutaae lalajeein rijiu ecu lauturoaain lauhecoha Jesosone tonohanaune, ");
INSERT INTO uraNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","nii nese Sicarau, lenone coretiha cuhacaanu saain. Nii jana jetaote canacaanu caaijie tocoriin tajiha acau raa uhe leinjiin Samaria bene. Nii jaun jetaote: “Caisichuche nii ii acau quera,” naain acau bajaa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“Chanuna Joriooneeinche natiin, cacaje acau bajaaiche, Samaria beneneein nihanuche natiin,” nae jetao nii Samaria bene Jesoso rai, Samaria cocoaichacuru aina ita belaihureniha Jorioocuruna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nii jaun jetaote: “Ichei Cana Coauneraacha tenaa jerei coitucuhin, canu nichaaunne coitucuhin cacaje laaen bajaaichene jana nihanena laaen, canu cocoirenachara nejeein niha cacha najaan acau ichaonaa tera tereeunche icheicha,” naa Cana Coaunera Calaohi Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Chaquena acau soriin rariquiche, raina jaannu sirijieequichene coalanaalata. Ucuhatohache caa atane jachu natiinta. Cha cajete ichaonaa tera acau tereeiche caraita. ");
INSERT INTO uraNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Canacaanu foeratera inoaesi Jacobohacha ratirineein nihache caa atane jachu natiinta. Caje raain niha nete acau corejetecurechelu Jacobo calaohichuru, rai nirihuru, naaojoaihunrichera. Iina amurijiriin nenaa jereeichete,” naa Samaria benene jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","“Satiin caa caje acau raain coorerate, jerichanejeein enacoaauneein cocoiriha cureeinchera. ");
INSERT INTO uraNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jana, canuhacha tei acau coha cachanete, coaiteen enacoauneein cocoirenereeinchera. Quiicha tei acaute, cacha suujua cuhane marohemarohereein, cacha rai nitajenaachara nejeein nenaa ichaonaa teranu quera,” naa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Saan. Carai aihane nii acau uhauche coaiteen cocoirichaaunchene coataara, enacoauneein coaiteen acau raanuchene coataara,” naane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Ii sinijiera cotihachanihuchera,” naa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Niheiche casinejerata,” naane jana jetao: “Esinaete chuhisi, rauhijiriin niicha que aitocoichera. ");
INSERT INTO uraNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Jauriaate niqui saoquiin sinijieraoquichelura. Chaeen nii ena ii aina nenaate rauhijiriin isinejera neein nenecheta,” naa Jesosone jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Cana Coaunera Ere beraneeina ichoaraaunchera. ");
INSERT INTO uraNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Caa atane ucuuno quete Cana Coaunera bajaebajaeraetoorechelu canacaanu foeratera inoaesihuruchera. Jana inara Joriooneeichenete, naain Jerosaleeun cuhin Cana Coaunera bajaebajaecaanune jerequichelura,” naa nii Samaria benene jana jetao: ");
INSERT INTO uraNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","“Quesenetaauchera. Inae ichuunnejeeonria caa atane ucuuno que uhichene laatelanaala, nii Jerosaleeun cuhichene laatelanaala, chunijiu niha natiin Cana Coaunera bajaebajaequichenera. ");
INSERT INTO uraNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria cocoaicha neeichene, coatiha nii inaraacha bajaebajajei coitucuujueein aitoheeiche. Jana canacaanu Jorioo nichaanunena nii canacaanuhacha bajaebajajei coitucuhin laaen aitocoaanuche, Jorioocuru caje ecoona nihache nii jianacoon cacha mitaerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Enene caje coauneein, caa atane ucuuno que unaa laatelanaala, nii Jerosaleeun cunaa laatelanaala, rauhijiriin suujua cuhane Cana Coaunera bajaauruhineche nere tonoraeraauru esineeuru. Nitohaneeinte jereche Cana Coaunera, ");
INSERT INTO uraNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","suujue nejeesiha nijihachena jaun,” naa Jesosone jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","“Raotojoeeina turuha urichain Cana Coaunera letono Curisitone coitucuunche. Acate laen cana relaa ureeinche itolere que,” naa nii enene jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“Saan. Canuna acaneein caa ichei aitoonchera,” nae jetao Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nii janana eruhacaanu aina nerelanaa nichaanune, nii ene aina ereeree jana. Nii natiine, “Chaquena ereereequiche,” naain bajanaa nainenihacaanu, jataain cana curuaanaa nihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nii jaunte cuu baichaje ratiriin, canacaanu que janoriin naain neseu biha cue nii Samaria bene. ");
INSERT INTO uraNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Inae neseu turuhin jetaote: “Chajaauchete, taa leinjiin cacha coaraera. Acate naaojoaain itolere ichacaunne que aite caraicha. Jerihane acate Cana Coaunera Letono Curisito necaihara,” naa nii neseu nenacaauru rai turuhinna jaun ");
INSERT INTO uraNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","tajiha jiniichaain uhin, nii ratiriha najaun turuhin coaraa uure. ");
INSERT INTO uraNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nii tonohanauna jaiti uujeeuru jana: “Chaelainejein quiorihura,” naain lenonihane coina counujichaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","“Niha caleeonne inaraacha coitucuhine lanaalara,” naa Jesosone jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","“Jerihane chunicohanejeinte coroaatecaihara,” naacaanu itaraine janate: ");
INSERT INTO uraNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","“Lenoneein inara suujua nunaaichene rijijieeina, casuujua nunaaun caletoaera amihaneeon ichaain jitaanune. Acate caleonne nera. ");
INSERT INTO uraNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","38","Inoaelu nere bera que catohaneein turuhanune beratiha Cana Coaunerana jaun, turuhanune cohajeein neeuruha cau nenacaauru cachaaurune jaunna inara letoareeunni, inae turuhanune beebejeeichene esenetauruhane, nitajenaachara nejeein nenaa ichaonaa raauruhane coina,” naa Cana Coaunera Calaohi Jesoso, aina nerelanaa nichaanune rai. ");
INSERT INTO uraNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nii neseu turuhin niriitiin cachaauru rai beein, “Naaojoain itolere ichacaaunne quete aitera,” naa nii enene jaun jetaote esenetaaure arajiin nii Samaria cocoaichacuru. ");
INSERT INTO uraNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nitohaneein Cana Coaunera Calaohi Jesoso rene turuhin: “Canacaanu aina neeorihura,” naauruhana jaun, acaauru aina coroata janojoeein neeorihacaanuna jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","jataain jelai amuritoheriin esenetaacoaaure, nujuaae caje raaje aitohane jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nitohaneeinte nii jauriaanejeein Jesoso aina erenaa Samaria bene rai: “Ii cajena aasaaeriin coitucuhin esenetacaanuchelu. Inae laaen enene esenetacaanuche jataain nujuae caje raaje aitohane aonacaanuchene jaun. Acate Curisitonechera. Acate caa chauratane que nenacaauru itolere cachaauru jianacoon mitaera nechera,” naaure nii ene rai. ");
INSERT INTO uraNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Coroata janohin Samaria batane que nihane baihate, caje amuhin naain Calileea batane que cue Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“Naaojoainte Cana Coaunera Letononeein nera,” naain caohachaain coitucuhin, belaain, raaurenerichaain naraaichurune coitucuha raotojoein inatiinte, atiin Calileea cauha cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Inae Calileea turuhacaanune janate, caohatiin Jesoso raaure jelai batane que ichaonacaauru. Jaurianejeein Jerosaleeun Fasocoa bitoauruhane jana cuu itolere ichaa Jesosone coaracuruhane jaunte caohatiin raaure. ");
INSERT INTO uraNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Nii jaunte Calileea nenaa nese- Canaau turuha cue Cana Coaunera Calaohi Jesoso, nii jauriaanejeein bino neein jeesinaaeca rotoha najaun. Nii janate coitucuuriin coaraa uhe Jorioocuru curuaanaacuru curuaanaa rey rai cocoainanacaineein nenaa, cunaitiha calaohina jaun que rautaeratihane coina. Tajiha turuhinte: “Atiin canenajau Caferenaaon turuha uute carai canaanai rautaaicha,” naa nii cocoainanacaine jana: ");
INSERT INTO uraNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","“Saan. Chatohanai coaraeneeiche inara nota quene, cha esenetaheeiche,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Chajaaojoaau atiin osiha carai canaanaine ajiinihara curuaanaa,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“Chajaaincha chaque tonajelanaala caunihu. Inae nerautaa ii rai canaanaicha,” naa Jesosone jaun, esenetaain cauha cue. ");
INSERT INTO uraNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nii jana jetaote, inae turuhelalajeein cuujihane jana jetao, tajiha que tacaain: “Inae nerautaa ii calaohicha,” naauruha que tacaain cachaaurune jaun jetao: ");
INSERT INTO uraNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","“Chu teejia enotone jana nejelajaain nerautaeta,” naain bajaane jana jetaote: “Raca enoto cafetaainte nejelajaain nerautaera,” naaurua najaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","“Nii rijiute chujian aite carai Jesosora,” naain jetao, nii caje coaauneein jetao Cana Coaunera Calaohi Jesoso esenetaaure saain, sinijiera, bereecuru, naaojoain aina jiniiquiin. ");
INSERT INTO uraNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nii quete coroata saain coitucuuruha cachaaurune coina niicha ichai ichae Cana Coaunera Calaohi Jesoso, Jodea caje Calileea nenaa neseu turuna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nii baihate Jerosaleeun cauha cue Jesoso, Jorioocuru beseta bitoaane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nii Jerosaleeunte, carenero bacuujuaneein curuajaain nenaa acuujua rohan ne Beteseta neein curuajaain acau netaojia najaan. ");
INSERT INTO uraNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ecute saoquiin niha lohanarine jana nasaae daraacoore arajiin cunaitenacaauru, maosacuru, bacosacuru, neluhinaauru, jiuronacaauru, niichuru daraaque nerurujuaa nii acau netaojiane cohaca. ");
INSERT INTO uraNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nii acau netaojia jetaote, tabaque nichoae fauha Cana Coaunera Letonone, nerurujuae nii acau. Nitohaneein nerurujuaane jana, ichoaaichaniha cuhane fai cunaitenaa jetaote nerautae. ");
INSERT INTO uraNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Cuute ne leinjiin cacha, nichatachoonca fosa jaanacain cunaaicha aina nei. ");
INSERT INTO uraNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Niite tocoeecohane jana coarae Cana Coaunera Calaohi Jesoso. Coaraane jana, inae nitohaneein carajaain cunai aina nihana jaunte, rai: “Nerautanaa jereeina,” naain caje bajaa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","“Eejeen, aihanu niquicha. Nete nene caa acau netaojianaja cuhane canu faeraanura. Faunaa jerichaaunne naineeinte, canu ichoaechaniha faaure leeochaaurura,” naa nii cunaitenaane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","“Saan. Chajaain nimichuhin chela seriin amuute coaracaara,” naa Jesosone janate, ");
INSERT INTO uraNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","nii rijieeoritiin caoachanainejeein nerautaain, nela seriin nichaauraain jelai caje amue nii cunaitenaa. Nii janate nebetacanaa janonaa bana nitohanai ichaane jaun, coaraain: ");
INSERT INTO uraNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","“Ta cocoaeraa chaelai baijiera enenene coitucuhinete, nebetacanaa cojoanonaa nihane saijieein anajiin baijiaai,” naauruha rai Jorioocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","“Aihanu niqui, nete caletoae canu cunai caje carautaera,” naane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Chate nii nitohanai ichaaine coina eletoaeta,” naain niqui bajaauruhane jana ");
INSERT INTO uraNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","coitucuene, arajii cacha jana nitajeoriha Jesosone jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nii baihate nii Jerosaleeun nenaa ita taojiaain Cana Coaunera bajauruha Joriocuru najaan Teenforo asaae eruhin: “Aonaau, inae laaen nerautaicha. Nijiaonria coaiteen naosatenaa coauquine. Coaiteeinete jelai amuritoeriin coaraa curiquiincha,” naa Jesoso raine jaunte, ");
INSERT INTO uraNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jorioocuru rai biha cue: “Acate carautaera,” naain. ");
INSERT INTO uraNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nii jaunte Jesoso aina nejerateein, jataain sohin jaonaa jerecure Jorioocuru, nitohaneein nebetacanaa janonaa bana cacha rautaana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nii jaunte: “Joaenreein bana amianiha Ofana jaunna, jerichanejeein ichaaunra,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Niritoha Jesosone jaunte, jataain jelaichoaae jauhecotojoeriin aina obajeein sohin jaonaa jerecure. Chaen nebetacanaa janonaa que aitocuruhane tonoraelanaala, “Cana Coaunera Calaohi nihane jaun jete, ichaa Cana Coaunerane rijijieein ichae,” naane corenihane maajeein jataain rautaaurene Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nii jaunte: “Esinaena rauhijiriin aitoreeunni inara rai, Coatiha casuujua caje coaauneein quiicha jerei ichana nainihaun, Cana Coaunera Calaohi nichaun natiin. Acaihanejein Ofaacha jerenohichana ichaaun. Itolere Ofaacha ichaichana ichaaun canu netonai. ");
INSERT INTO uraNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Cacoelaiha Ofa Cana Coaunerana jaunte, itolere niicha ichai que canotajae. Chaaen techu jeelai choae jauhecotojoeriin caque itolere ichaain inara notaaratihane, nii cojoaelatiin coaraa curiquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Onacaauru ichateein acaauru rai ichaonaa tiha Ofa Cana Coaunerana jaunna, canu netonai quiicha belaihuri ichateein acaauru rai ichaonaa teeun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chabana cacha coujuhin coaraai Ofa Cana Coaunera. Coatiha ichana nainenihane caun aihei. Nii jaunte canu cocoainaain caletoae cacha coujuhin coaraaunnuque, ");
INSERT INTO uraNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","chaen rijijieein jataain curuaanaa neein nihanune coitucuhin, rai nere tonoraauruhane rijijieein quere netonai tonoraauruhane coina. Cha teeinti quere tonoraene, niite caletoaera Ofa ere tonoraenereein. ");
INSERT INTO uraNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Caletoaera ere esenetaain, quere tonoraain naaojoain neeichenena inara coujuhin inara coaraelanaala rauhijiriin nitajenaachara nejeein nenaa ichaonaa tereeunni inara rai, jaoleneein neeichene coataa. Esinaena rauhijiriin aitoon. ");
INSERT INTO uraNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Enene caje coauneeinte Cana Coaunera Calaohineein nihanune ere aonacuruha Cana Coaunera coitucuhi cachaaurune jana, quere tonorauruhane, acaauru suujua coriha cureein Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Raajenihane ichaonaa nitajenaachara nejeein nenaa ichaonaa teraneein niha Ofa Cana Coaunerana jaunna, jerichanejeein rijijieen nenaa rai calaohi nichaunna jaun canu netonai nitajenaachara nejeein nenaa ichaonaa teeun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Inaraacha cohajei- cacha calaohi nichaaunne cocoainaainte caletoae, caohachaain ichaaoruhane coaraain baasoneein ichaonacaauru ichao rucueranu que. ");
INSERT INTO uraNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Coaa caa aitocoaunne cojoaelatohache. Inae cojoinaca que turuhane banate, rai nere aonacurureein. ");
INSERT INTO uraNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nii banate natane bana caje mituurureein satiin onacaauru, caoacha icharaauru nitajenaachara nejeein nenaa ichaonaa raauruhane jana, baaso icharaaurute caseteco coaraa cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Coatiha casuujua caje coauneein cacha coujuhin coarahaaun. Aitiin caletoaa Ofane rijijieeina rauhijiriin cacha coujuhin coaraaun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","‘Cana Coaunera Calaohi nichaunra,’ naain irihanu caraajenianene caohacharihei. ");
INSERT INTO uraNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","Inae Joaan caje bajaerateichene jana, rauhijiriin inara rai bihalu Joaan. Aihana jaun, esenetaaichenete caohachae, Cana Coaunera ere beraneein niha Joaanne coitucuichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Esinaete rauhijiriinte caque aite Joaan- acauhanau teein cachaauru coujunacateein baotisaera, caje bajaaichene jana niqui, nena cacha aitohane lateneeun. Jianacoon mituhin neeiche osa cajene jerena caaunna, caa niritiin aitoon. ");
INSERT INTO uraNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Aca aiha leinjiin conone rijijieein niha Joaanne jaunte niqui, coroajeein neeichelu basiijiin reeintiariin. ");
INSERT INTO uraNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Chaaen techu, ‘Acate canaacha cohajeinera,’ naain inara rai biha rauhijiriin Joaanne choae tacaain techu niqui, inara nota que itolere ichacaaunne coaraquiche. Nii quiicha ichaina ichaaun, esinae rauhijiriin caletoaa Ofa Cana Coaunerane coitucuhichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","40","Chariji bana Cana Inaca Cana Coaunera coaraain nere aonaheeiche niqui. Nete, nere bera inoaesihuru que catohaneein turuhanune berateein laenaeratihalu Cana Inaca najaan que nerelaaiche niqui, caje ichaonaa nitajenaachara nejeein nenaa raaichene coina. Nete nii aitohane rijiijieein caletoaa Cana Inacane esenetaeneeichene jaun raenereicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nii jaunna caque tacaain canu coroajeein caraaichene jereneeun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Chaaen nachu raotojoeein Cana Coaunera jereein, nere tonoraain neneeichene coitucuun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cana Inaca Cana Coaunerate niqui caletoae. Nete, caohachaain caranaa jereneeiche. Jana inara rene turuhin, ‘Canuna Cana Coaunera letono neeunra,’ naa inara rene turuhin Cana Coaunera letono niheinete laen caohachaain rariquiche. ");
INSERT INTO uraNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Cana Coaunera coacuelanaala itaacha coroajeein, ‘Iite caohati cachaneein neeicha,’ naain neeichene jaunte, quesenetana naineneeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Coatiha Ofa rai inara coulurujuenaa coauhaaun canu. Nii Moisesa inaraacha esenetaite laen Cana Coaunera rai inara colurujuereein. ");
INSERT INTO uraNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisesa aitoojoan esenetaaichene jana nihanete, quesenetareeiche, catohaneein turuhanune que aitiin laenaalu Moisesane jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nii aitiin niicha laenai esenetaeneichene, chatohaneein jana aitocoaunne esenetareeiche,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nii baihate Calileea conemuri jeraque cuha Jesosone jana, ");
INSERT INTO uraNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","sacuha cuure arajiin cachaauru, cunaitenacaauru rautaane coaracuruhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nii janate cuu atane ucuuno choae iniin nelauriariin lauheque Jesoso, aina nerelanaa nichaanune aina, ");
INSERT INTO uraNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jorioocuru beseta Fasocoa catainajeein. ");
INSERT INTO uraNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nii jaunte arajiin turuuruha cachaaurune jaun: “Chu lenone coreterihacache, caa arajii cachaauru rai,” naain bajae Ferifi rai Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Niicha ichaneni coitucuha natiinte bajae Jesoso Ferifi caje, “Toohanrichaaincha,” naain. ");
INSERT INTO uraNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Niritiin bajaane jana: “Coroata fashai janonei amihanenaa core jeeoneein faan coretichaachene niha natiin coatia caa arajii cacha naineriheta,” naa Ferifine baihate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","“Caute ne caa canaanai rai saoquijieein faan, nii baiha coroatajaain ate, naaonjoaain niqui, nete caa araainein cacha nainenere carijiei,” naa nii Simoon Fedoro ocoala Aanderesine jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“Saan. Acaauru rai aitocuchete nelauriaauruhine satiin,” naa Jesosone jaunte: “Nii omane choae nelauriaauchera,” naauruhane jana, nelauriaaure nii saoqui oaraancai quichaauru nejeesina, enecuru, canaanaihunru, naaojoain janijilanaala. ");
INSERT INTO uraNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nii janate nii faan teberiaain: “Nariha,” naain Cana Coaunera bajaane baiha, nii aina nerelanaa nichaanune rai nii faan te Cana Coaunera Calaohi Jesoso, chaluhacaanune coina. Chaluhacaanune janate, nii saoqui oharaancai cacha naine nii faan. Jerichanejeein techu nainecohanajae nii ate. ");
INSERT INTO uraNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nii janate, inaeneeuruhana jana cautihana jaun: “Caa caute curujuaain raauche nijiaohanne coataa,” naa Jesoso, aina nerelanaa nichaanune raine jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","curuhacaanune janate ne, elechoonca coroata omariin faan caute. Nitohaneeinte caute, nii saoquijiei faan nefaain. ");
INSERT INTO uraNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nii coaraainte: “Caate caa chauratane que turuha uha niicha jerecuri Cana Coaunera letono canaacha cohajeinecaihara,” naaure cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nii jaunte jataain acaauru curuaanaa rey neein Jesoso tenaa jereein, counujueein amanaa jerecuruhane coarajihana jaun, acaauru que janoriin amue rautaenihana jaun. Nitohaneeinte acaauru que janoriin amuhin, atane ucuuno que iniha cue Jesoso, cuu jelai basiijiin neeorihane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Nii janane, inae nocohecane jaun, jaiti turueniha Jesoso atane ucuuno cajena jaun, fauha cuhacaanu. Fauhina, leinjiin bote cuhane naain jera jaoha cuhacaanu, Caferenaaon turuhacaanune coina. Nii janate inae nalaaquiin cuhin nocojoe. ");
INSERT INTO uraNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","19","Nii janate, inae bote cuhane fauhin cuujihacaanune jana, canacaanu sacuha uhe Jesoso, acau choaae rurujueein uhin. Nitohaneeinte acau choae uhin canacaanu rohan nichuuntaain, nii acau jiheeitohane jana, fichafichanaa tabai nihane jana, nii bote nalaaene amuniha canacaanu rai janate coaracaanune jana, tajiha acau choaae uhin rurujue, nii bote nichaae uhin. Nii jaunne coasiha nesoonetohacaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","21","“Coaa nesoonetohachera. Canuna aihunra,” naane jaun, que tacaain coroajeein, nii bote cuhane fauhin amaacaanu. Nii janana cohaneeoriin turutoha cuhacaanu canacaanuhacha coinetihu. ");
INSERT INTO uraNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nii cojoanoote, acaihanejein satononiha jera jaoha cunaa bote cuhane fauhin jera jaoha cuhacaanune jana, canaacaanu aina uheniha Jesosone jaun, nii que ereereecure. ");
INSERT INTO uraNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nii jana jetaote, Tiberia nese caje uhin turuha uhe leinjiin bote. Turuhin jetaote, najauriaa uhe nii Cana Coaunera bajaain niicha tei faan quihuruha najaan rohan. ");
INSERT INTO uraNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nii jana cuu nenihacaanune jana, Jesoso netonai niha natiin nenihana jaun, nii bote cuhane nefaujuaain cuhin, nii nihacaanune jaaun Caferenaaon turuhin ariha uure. ");
INSERT INTO uraNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nii janate jera jaohin coaraa uuruhane jana, cuu nii Caferenaaon ne Jesoso. Nii jaunte rai: “Chabana cau turuhite cacha relaera” naauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","“Nii quiicha ichai coaraquiche natiin, ‘Naaojoain caara,’ naain inara suujuau erenaa coacuelanaala, nainaain obejeein lenonequichene jaunte cariirijieeiche,” naainte, ");
INSERT INTO uraNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","“Coa sanaa inaera lenone corenihacha amihanihache. Acaihanejein ichaonaa tera- chabana sanaachara nejeein lenone coreniha amihaneeuche. Nii nitajenachara nejeein niha cacha najaan lenone tihanune coinate caletoae Ofa Cana Coaunera. Canuna inaraacha cohajei Cacha Calaohi ineeunra,” naa Jesoso acaauru rai janate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","“Chatohaneein nerichaanu Cana Coaunera jerenohi ichacaaunne coina,” naain bajaauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","“Caa niicha letoai nichaunne esenetaichenete jere Cana Coaunera,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","“Chatohanaina ichaain canacaanu notaareei, coaraain esinaaen rauhijiriin Cana Coaunera letononeeine esenetaacaanune coina. ");
INSERT INTO uraNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Carene tabai que amuhemuhecuruha najaaun jetaote, neniha lenonene jaun jetao, dede caje faan rijijieei nenaa manaa neein curuajaain nenaa que jetao ichaohin amuhemuhecururejetelu canacaanu inoaesihuru. Nitohaneein jetaote, neniha lenonene jaun, ‘Dede caje nenaa faan rijijieein nenaa manaa te Cana Coaunera,’ naa Cana Coaunera Quiricha inoaesi cuhane” naauruhane jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","“Coatiha Moisesa nii dede caje nenaa faan manaa tihei. Acaihanejein Ofa Cana Coauneraachate nii dedeeu nenaa faan esine teraneein ne. ");
INSERT INTO uraNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nii Ofa Cana Coauneraacha tei faante turue caa chauratane que, cachaauru rai ichaonaa chabana nitajenaachara nejeein nenaa teranu que,” naa Jesosone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Atiin canacaanu rai inetono janonaa bana, nii faan que canacaanu sihura curuaanaa,” naauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","“Canuna cacha rai ichaonaa tera faan neein neeun. Cha teeinte carene uhe aca mijiteriaain. Cha teeinti quesenetae, aca cocoireriaain. ");
INSERT INTO uraNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nete inara rai aitocoaaunne esenetaeneeiche, inara nota que quiicha ichai coaraquiche natiin. ");
INSERT INTO uraNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Satiin Ofa Cana Coauneraacha letoaite carene uhe. Nii jaunna carene uhi nihane sitaenereeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Coatiha quiicha ichana jerei ichacaaunne coina, dede caje uhin turuha uhaaun caa chauratane que. Acaihanejein caletoaera Ofa Cana Coauneraacha jerei ichacaunne coinana cau turuun. ");
INSERT INTO uraNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nabana nitajeuruha cachaaurune coataate caletoae Ofa Cana Coaunera. Nii jaunna satiin nii carai niicha teeuri cachaauru ichateein michunajaa cureeunni inae saa cana janonaane bana. ");
INSERT INTO uraNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nii Cana Coaunera Calaohi coaracuruhane esenetaauruha satiin cachaaurunete jere caletoaera Ofa Cana Coaunera, chabana nitajenaachara nejeein nenaa ichaonaa raa esenetaeraaurune coina. Nii jaunna inae saa cana janonaane bana ichateein michuunajaa cureeunni,” naain acaauru tonorae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Niritiinte, “Canuna dede caje faunaa faan neeunra,” naa Jesosone jaun nocoeje chanuure Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nitohaneeinte ita rai: “Ta Jose calaohi Jesoso niha caane. Raotojoeein inaca, neba, naaojoain coitucuhacache natiin, dede caje faunaa nereta,” naauruha ita rai Jorioocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","“Inae canu necoeje chanuhichene jianecuchera. ");
INSERT INTO uraNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Chunei carene unaa nainihei, nii jereein neniha caletoaera Ofa Cana Coaunerane. Inae saa janonaane banana nii carene uhine ichatiha cureeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","‘Satiinte relareein Cana Coaunera,’ naa Cana Coaunera ere beracuru ioaensiuruhacha laenai quiricha cuhane jaunte, satiin Ofa ere aonaain tonoraain que nerelanacaaurute, carene ureeincha. ");
INSERT INTO uraNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Chabana Ofa coaraai chunei. Acaihanejein canuhachana coaraaun caje unaa nichaunna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Esinaena rauhijiriin aitoreeunni. Quesenetaerate ichaonaa chabana nitajenaachara nejeein nenaa raa cureein. ");
INSERT INTO uraNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Canuna ichaonaa chabana nitajenaachara nejeein nenaa tera lenoneneein neeunra. ");
INSERT INTO uraNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Neniha leinjiinejein cacha najaaun carene tabai choae amuhemuhecuruha inara inoaesihurune janate, que ichaaoruhane coina cojoanoo netojoeein manaa neein curuajaain nenaa quinacai nalae Ofa Cana Coaunera, que ichaaoruhane coina. Nete, satiin oore nii quihurera- inara inoaesihuru inae binaaneein. ");
INSERT INTO uraNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Canuna dede caje faunaa lenone neeun. Nii faan nichaaunne quicha, chabana orihain. ");
INSERT INTO uraNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Canuna nii lenone neein dede caje faunaa neein neeun. Nii lenone que ichaohin neite nirijijieein nitajenaachara nejeein niha cureein. Nii lenone quiicha tenaa jereite, cajabereonneein ne. Acane tiha cureeunni, que ichaohin neeuruha caa chauratane que nenacaaurune coina,” naa Jesosone janate, ");
INSERT INTO uraNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","“Chatohaneeina rai jaberoco que cana coroaatere,” naain nejesinajeein ita cotaicha rijitocure Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nii jaunte: “Esinaena rauhijiriin aitoreeunni inara rai. Canuna Cana Coaunera Calaohineein, jelai Cacha Calaohineein inaraacha cohajei ineein neeun. Cajabereeon quiin cacoichana coheneeichene, nihei ichaonaa esine ranaa nainiheeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Cajabereeon quiin cacoichana coerate, chabana nitajenaachara nejeein nenaa ichaonaa raa cureein. Acane, saa cana janonaane bana ichateein michuha cureeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ichaonaa tera lenone esine neein niha cajabereeonne janate, ichaonaa tera conacai ineein ne cacoichana. ");
INSERT INTO uraNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nitohaneein cajabereeon quiin, cacoichana coerate, caniha jiniiquiin nereein. ");
INSERT INTO uraNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nii caletoaera Ofa Cana Coaunerate ichaonaa siri. Nii jaunna que ichaohin neeun. Nii rijijieein techu, cacoreniha ichaoha cureein caque lenoneein nei. ");
INSERT INTO uraNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nii dede caje faunaa lenone quena aitoon. Coatiha nii inara inoaesihuruhacha quii manaa rijijieein nihei. Nii manaa quihuruha niqui inara inoaesihuru, nete satiin oore nii quihurera. Jana nii caitoojoan dede caje faunaa lenone quiha cachanete, chabana nitajenaachara nejeein niha cureein,” ");
INSERT INTO uraNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","naain relanajae Jesoso, Caferenaaon, acaauru rai sinacoca asaae netaojiauruha Jorioocurune jana. ");
INSERT INTO uraNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Caritiin relanajaa Jesosone jaunte: “Caaintatoha jataain caa naitoojoan. Chate nere tonorare,” naauruha nii caaijie arajiin cunacaauru cachaaurune janate, ");
INSERT INTO uraNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","aohanriin: “Ta aihane carautaaichene. ");
INSERT INTO uraNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Toohanreichecha, jauriaa nihanulune jaaun jelaiha iniha cuhanune coaraquichene. ");
INSERT INTO uraNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Caa quere aonaain esenetaeraaurute, chaelai janonaa bana nitajenereein. Jana, caa aitocoaunne esenetaelanaala erenaa tonoraauruhite, ichaoha jaberoco niha natiin, nitajiha cureein suujue. Cha que nelatihei cana jaberoco, cana suujue colane. ");
INSERT INTO uraNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nete jaiti caa aitocoaunne jaan esenetaaurene inara tabaauru,” nae acaauru rai Jesoso, inae inoaelu caje coauneein, “Acaauru acaaurute quesenetaenereein. Jana, acate naaonjoain cacoulrujueein naaonjoain caeteratiha cureein,” naain coitucuhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nii jaunte: “Nii jereniha Ofane, carene unaa nainihei chunei,” naa Jesosone caijiete, ");
INSERT INTO uraNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","jianijihacoaaure nii arajiin aina nerelananichaanune aina amuhemuhenacaauru niritoha Jesosone jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nii jaunte: “Inara netonaiha cajaohin caratiriin amuriquiche,” naain bajaa elechoonca coroatajai nichaanune cajene jana: ");
INSERT INTO uraNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","“Ahan aihei. Chuna nenacae curichaacaanu. Nii canacaanu relaina jaan tejian nenacaae ichaonaa chabana nitajenaachara nejeein nenaa teraneein ne. ");
INSERT INTO uraNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Canacaanuna laaen ii esenetaacaanu. Nii jaunna acaihanejein Cana Coaunera Calaohi Curisitoneein neeine coitucuhacaanura,” naa Fedorone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","“Canuna lechoonca coroatajai niquichene cotijiaain raain neeun niqui. Nete, nii inara lechoonca coroataja nechu aansain moconajaeraneein ne,” nae Jesoso canacaanu rai. ");
INSERT INTO uraNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nii Simoon calaohi Jodasi Isacariote quete aite Jesoso, aina nerelanaa nichaanune lechoonca coroataja niha natiin coulurujuerichaaine coitucuhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nii baihate, Calileea batane que nenacaauru neseeuru neseeuru cachaauru relaa amuhemujue Cana Coaunera Calaohi Jesoso. Jodea batane que cunaa jerihei, cuu sohin jaonaa jerecuruha cuu nenacaauru Jorioocuruna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nii janate, inae ichuunejeonriha lohanari beseta bitoaauruha Jorioocurune jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","“Coa cau niha. Jodea cunihunte cuu chaaelai ichaaine coaracurumii cuu nenacaauru ii coitucuurera. ");
INSERT INTO uraNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Coitucuha cachane jeriha chuneine, asiin cha ichana nainihei. Aihana jaun, letonoaneein satiin coarajeeurera notaracaae ichaaute coaracurumii,” nae nocoalacuru. ");
INSERT INTO uraNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nihei nocoalacuru nihanatiin esenetaaurenihana jaunte aitocure. ");
INSERT INTO uraNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nii jaunte: “Inasiina jaiti turuha cuhanune jaan cojoinacane coaalanaala cureeun. Inara raite laaen caoachae joaenreein bana cuhichene, ");
INSERT INTO uraNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","neniha chatohaneein inara aina nejerateein, inara cotaain, chatohaneein inara tenaa naineniha caa chauratane que nenacaaurune jaun. Canihate laaen nejerateeure, itolere baaso ichacuruhane que rauhijiriin aitocoaunne coreniha. ");
INSERT INTO uraNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Inara cunichuchete beseta bitoaaiche. Jaiti curihaunni canu, turueniha cuhanune jaan cojoinaca quene jaun,” naain ");
INSERT INTO uraNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","nii Calileea nedae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nii baihate inae cuuruha nocoalacurune jana, acaaentonai cue acaauru caaijie nasina rijijieein, acaauru aina beseta bitoaa. ");
INSERT INTO uraNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nii janate inae nunuheca besetane jana ariirijieeure Jorioocuru: “Aancacha nii cacha,” naain ");
INSERT INTO uraNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","cuu nejesinajeein coaucuhin ita rai ereerejeein: “Acate caohachanejein cachaneein ne,” naauruha tabaaurune janate, tabaauru: “Caohachanejein cacha nihei jana canacaanu rai, cacha coritaain naojoaanna jaun,” naaure tabaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nete, rauhijiriin “Aca,” naain chaque erenaa nainene chunei Jorioocuru coasiha. ");
INSERT INTO uraNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nii janate, netaojiauruhana jaan loreri Teenforo asaae enoha Jesosone jana, inae sanaa jere nii beseta. ");
INSERT INTO uraNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nii janate cuu relanajaa Jesosone jana cojoaelatoore Jorioocuru. Cojoaelatiinte: “Chatohaneeina nirijieein nerelaelanaala itolere coitucue,” naauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","“Coatiha casuujua caje quiicha rocohi nihei- caa inara relaanune jaan. Caa inara relaanune jaante, nii caletoaera caje unaa ne. ");
INSERT INTO uraNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nii jaunte inae jatoroaain Cana Coaunera jerenohi ichana jererate aitocoaunne aonaain coitucuha cureein. Nitohaneeinte esinaae rauhijiriin casuujua caje rocohin aitenihanune coitucuurureein. ");
INSERT INTO uraNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Charijieein teeinti: ‘Canuna caoacha cachaneein neeun,’ naain suujua caje rocohin raotono que ereereecane, ereereje cacha raotojoeein: ‘Caate jataain caohachanejeein cachaneein ne,’ naain caohachaain belaain coaracuruha cachaaurune coina. Nete rai letoaera curuaanaa coitucuhin coroaecuruhane coina, esinae rauhijiriin aite. Aihana jaun, Nihei nii que: ‘Casaje,’ naain ereereecuruhane jaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","‘Cana Coaunera ere bera Moisesa ere tonoraacaanu,’ naainte ereeiche niqui. Nete: ‘Coa sonajaain jaohache,’ naain aitoha Moisesa natiin tonoraeneeichene jaun, casohin cajaonaa jerequiche,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Chana ishohin ijiaonaa jerete aansai,” naauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","“Chanuna jana chaaen, nebetacanaa janonaa bana cunaitenaa rautaanune jana, cojoaelatiin obaaequichelu caniha. ");
INSERT INTO uraNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","‘Quichaneein nejanoaa inara bereene, inae fosa janoniha nejanoaane jana, rai nacatichei cari jiununuhin saauche,’ naa Moisesane jaunte niqui, nii tonoraain nebetacanaa janonaa bana niha natiin, canaanai nacatichei cari jiununuhin sauhin naaonjoaain neeichelu. ");
INSERT INTO uraNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chanuna chaaen nebetacanaa janonaa bana lesajeein cunaitenaa rautaanune coreniha, caniha obajeein caque nererojoecaaichelu. ");
INSERT INTO uraNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","‘Cana Coaunera aitoojoaan tonoraacaanu,’ naaiche inara suujua cuhane natiin, esinae rauhijiriin Cana Coaunera aitoonjoan coitucuhin tonoraain niheeiche. Esinae rauhijiriin Cana Coaunera aitoonjoa coitucuhin neeinchene jananihane, caniha obajeein caque nererojoecaain neriheeiche,” nae acaauru rai Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nii janate: “Tana caa cacha ariirijieuruha sohin jaaoruhane coinane,” naauruha nii Jerosaleen nenacaaurune jana, ");
INSERT INTO uraNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Nocoa chujianra jianacoo neein satiin coarajera notaracaae ereerejena. Chanuna colaraain inauhene coarajeeure. Jerihanete acaauru esenetaain, ‘Acate Cana Coaunera letono Curisitone,’ naaurucaiha cocoainanacaihuru. ");
INSERT INTO uraNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Canacaanuna laaen, nii uhana jaan coitucuhacaanu. Jana turuha Curisitone, ‘Naojoain cajete uhera,’ naain coitucuerariaain,” naauruhane janate, ");
INSERT INTO uraNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","cuu nii ita taojiaauruhana jaan loreri Teenforo asaae aonajenajaain, “Esinaena aihana jaun, canu unajaan coitucuhiche. Coatiha casuujua caje coauneein uhaaun. Inaraacha coitucuhi Cana Coaunerate caletoae. ");
INSERT INTO uraNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Dede caje, aca caletoana jaunna coitucuun caje uhanune jaun,” nae Cana Coaunera Calaohi Jesoso tonijiain. ");
INSERT INTO uraNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Niritohane corenihate mucuhin amaain caresero cuhane Jesoso enoanaa jerecure niqui, nete jaiti cuu tenihana jaun, chatoaneei que biji teeurene. ");
INSERT INTO uraNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nete, atiin esenetaain: “Turuha Curisitone, coatiha aiha caa cachane amuritoheriin araai saain niicha ichai ichaain cacha notaariaain,” naaure arajii cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jesoso queecha ereeuruha cachaaurune que urichocuruhana jaunte, rautaaurenihana jaun nere tonoraeraauru Teenforo beraihurera folisiacuru letoaaure nii fariseeocuru, nii cuu nenaa batirichuru curuaanaacuru, naojoaihuri, Jesoso mucuhin raacuuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nii jaunte: “Basijiin reeintiariina cau neeorihun. Nii baihana nii caletoaera rene cauha cureeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Canu aririquicheein niqui. Nete caurueneriquicheein, nii cuhanune jaun turunaa naineneriquicheei najaun,” naa Cana Coaunera Calaohi Jesosone jaunte, ");
INSERT INTO uraNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","nejeesinajeein itarai: “Chuna curute, ariirijiacachene niha natiin eruhenerihacache. Jerihanete Curiecocuru que najasiiteein nenacaauru Jorioocuru ataneu cunaa jere, Curiecocuru relaane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Chatohanerichaain naate aite: ‘Canu ariichene niha natiin, caururiheicheein cuhanune jaun turunaa naineneriquicheeine jaun,’ nae,” naainte itacaje bajaebajaecure Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nii beseta satono janonaa banate, beseta nunuhe bana, bajaauruhane amuritoheriin Cana Coaunera bajaaure jiniiquiin nii beseta bitoaa turunacaauru. Nii jaunte beseta satono que nimichuhin tonijiain, nii cuu nenacaauru rai: “Cocoirei carene uhinena cocoae. ");
INSERT INTO uraNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aitoha Cana Coaunera Quiricha Inoaesi cuhanene tocohaneein, quesenetaera cacha suujua cajete mitureein acau rijijieein sorohin, jelaiha suujua cuhane maroemaroereein, suujua rucujueein rai ichaonaa nitajenaachara nejeein nenaa teraaunu que, chaen leochaauru rai niha natiin tihane coina,” nae Cana Coaunera Calaohi Jesoso, nii beseta bitoaaurera rai. ");
INSERT INTO uraNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nitohaneein Cana Coaunera Suujue raaururichaain esenetaeraauru cachaaurune quete aite Cana Coaunera Calaohi Jesoso, coitucuuruane coina. Jaiti dede curuaanaaneein Jesoso enoaenihana jaunte, esenetaeraauru rai suujue letoaene Cana Coaunera. Nii quete aite Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nii jaunte niritoha Jesosone jaun tabaauru: “Acate nii turuha uha niicha jerecuri Cana Coaunera ere berane,” naauruhane jana, ");
INSERT INTO uraNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","“Acate Curisitonera,” naacoauruha leeochaaurune janate, tabaauru jana: “Inasiin jetao Calileea caje uriha Curisitone coaalanaala. ");
INSERT INTO uraNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","‘Jerichanejeeinte curuaanaa inoaesi Rabiri rijijieein Beleen cocoaichaneein nereein Curisito, curuaanaa inoaesi Rabiri ichoalaneein nenaa,’ naa Cana Coaunera Quiricha Inoaesi cuhane natiin, Curisito nere Calileea cocoaicha,” naaure. ");
INSERT INTO uraNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Niritiinte Jesoso coreniha cuu ita rerohecaain ita caje nelerucure. ");
INSERT INTO uraNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tabaaurute mucuhin amaain caresero cuhane tenaa jerecure niqui, nete ichana nainene chunei. ");
INSERT INTO uraNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nii jaunte, Jesoso colane turuha uuruha nii Teenforo beraihurera folisiaacurune jana: “Chanuna mucuhin uhaeneeiche,” naain bajaauruha cuu nenaa fariseeocuru, batirichuru curuaanaacuru, naaonjoaihurine jana: ");
INSERT INTO uraNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","“Cha corenihana mucuhin uharichaanu joaereein coreniha. Nihei chunei cacha irihane rijijieein erei,” naauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Inae nachu inara netonai coritaate. ");
INSERT INTO uraNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Esenetaauruha cana curuaanaacuru, fariseeocuru, naaonjoainurine coaalanaala esenetaaiche. ");
INSERT INTO uraNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Acaihanejein Cana Coaunera Ere coitucuuruhi, Cana Coaunera jaolecuru cachaaurute esenetae,” naauruhane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","“Nainihei joaereein nere aonaelanaala, joaereein: ‘Naojoainte ichae,’ naain, caohachaain coitucuhelanaa, cacha casetecaacachene, niritiin aitoha cana quiricha inoaesi cuhanene jaunne,” naa nii janotiin Jesoso rene turuha cunaa fariseeo Necodemone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","“Ii tonaina Calileea cocoaicha neei. Nihei chunei Calileea caje ecocohin Cana Coaunera ere bera. Cana Coaunera Quiricha cuhane arihute coitucuhi,” naauruha leeochaauru fariseeocuru Necodemo rai janate, ");
INSERT INTO uraNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","nenajau cauha cuure nii cuu nenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nii janate acaauru que janoriin, naain Oliboneein curuajaain nenaa atane ucuuno cue Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Inae janohane janate naain Jerosaleeun cauha cue, coaiteen enacoaauneein cuu nenaa Teenforo asaae enohane coina. Nii janate rene turuhajeeuruha arajii cachaaurune jaun, nelauriaain relanajae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nii janate nejelau quicha que nicharatihane jana ene cojoaeloroe eruhin, mucuhin, tajiha turuaa uure, Cana Coaunera aitoonjoa que cacha relaaurera fariseeocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nitohaneein turuaainte, nii cuu nenacaauru cataaun teein: “Naaojoaain nejelau quicha ainane janana, caa ene eruhin mucuhin uhaacaanura cacha relaera. ");
INSERT INTO uraNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Cana Quiricha Inoaesi cuhanete laenaain cana rai rauhin teein letoaelu Moisesa, nitohaniha ene cojoaelorohe ne, sohin jaohacache ajeri que botosiine coina. ‘Tonaai jana ii,’ ” ");
INSERT INTO uraNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","naain bajaaure, nii ene sohin joaeratenaa jerenihane coulurujueeuruhane coina. Nii janate acaauru tonoraelanaala notoroaain, biji couturi que atane laenaje. ");
INSERT INTO uraNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nii janate cuu tonoranajae lanaala atane laenajiha biji couturi quene jana, cuu jeelai coaineeinejeein bajaebajaecuruhana jaun, couturi michuriin: “Niha cau leinjiin inara jana osa que lanaala, chabana baaso ichae lanaala nenaa ne, nii ichoaechaniha focoine ajeri que,” ");
INSERT INTO uraNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","naain coaiteen notoroaain atane laenaje biji couturi que Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Niritoha Jesosone jaunte, aihuru bana acaauru netonai baaso ichacuruhana jaun, acaauru suujua que tacaana jaun, coejeein, biinaa que ichoaichaain leinjihana leinjihanaain mituhin cauha cuure. Inae satiin mituhin amuuruha nii ene coulurujueurerana jaun, nii eneecha que jerajejeein neeorihana jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","nimichuhin nichauraain: “Aancaauruche icholurueraauruta. Ta ishohin ijiaohache chuneine,” naain nii ene caje bajaa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Aiheicheta curuaanaa. Nihei casohin cajaohiche chuneita,” naa nii enene jana: “Niheichu, canu niha natiin chatohaneein cheteein, ishohin ijiaonaa nainihaaunche. Inae caunichuche. Jiaonriha caa baiha coaiteen nosateichenera,” naain nii ene jiane Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nii baihate coaiteen cachaauru rai beebeje Jesoso: “Canuna caa chauratane que nenacaauru cononeein neeunra. Quere esenetaerate ichaonaa tera cono siricheein. Chabana nocohenaanau amuhemuheriaain,” naa Cana Coaunera Calaohi Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","“Nohaneeicha. Ichaajenihane aitiinte aitohicha. Nii jaun chaque nelatihei nii aitohine jaanta,” naauruha fariseeocurune jana: ");
INSERT INTO uraNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","“Caraajenihane aitiin aitocoaaunne niha natiinte, nelate quere. Canuna nii uhanuluna jaan jelai coitucuun. Jana inara coitucuheeiche. Niheichu canu cunajaanu coitucuheeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nechu jataain Cana Coaunera coitucueneeichene jaunte, joaenreein inara suujua cuaaichene jaun, joaenreein ereereequiche. Aanca chunei coulurujuerichaaun canu. ");
INSERT INTO uraNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Canu, cacha coulurujianunete, esinae rauhijiriin coulurujuenojoineei ne, canuhacha jelai caitono nenihana jaun, caletoaera Cana Inaca aina aitocoaunna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Charijieein teeinti ‘Ita rijiitojoeein ereeuruha coroatajai coaraaurune, esenetaacache nete ne,’ naain aite inara quiricha inoaesi cuhane, nitohaneein ichaquichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nirijieeinna coaaraneein aitoon, nii caletoaera Ofate cajiniichaain coaaraneein ne. Nii jaun quesenetaaichenetene,” naa Jesosone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","“Aanca aihane nii chaca,” naain bajaauruhane jana: “Cacoitucueneeichene jaun, Ofa coitucuheeiche. Cacoitucuhichene jana nihanete, Ofa netonai coitucuriquiche,” ");
INSERT INTO uraNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","naain relanajae Jesoso, nii ita taojiaauruhana jaan loreri Teenforo asaae, nii coriqui teeuruha cachaaurune jaaun neein. Niritoha Jesosone jaunte mucuhin enoanaa jerecure. Nete enoaaurene, jaiti nitohaneein teeuruhane jaan cojohinaca que turuenihana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nii baihate coaiteen aitiin: “Inae amuhanune baihate cariirijieriquicheein inacojoeein. Nete inara osa caaun cauhacha neein oriquicheein, nii cuhanune jaun cunaa naineneeichene jaun,” naa Jesosone jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","“Jerihanete raajenihane nesohin nijiaonreein. Nii jaunte nii cunajaun cuenerihacacheeine que aite,” naain ita rai ereereecuruha Jorioocuruna jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","“Inarate, caa chauratane que neeiniquiche. Canuna jana, cana choae caje nenaa neeinneeun. ");
INSERT INTO uraNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nii jaunte oha curiquicheein osa caaun, canuneein nihanune esenetaeneeichene jaun,” naa Cana Coaunera Calaohi Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Chaneeina jian,” naain bajaauruha Jorioocurune jana: “Inae inara rai aitocoaacaaun turuhanune caje coauneein. ");
INSERT INTO uraNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Niha arajiin erenaa inara rai quiicha beenei. Nii caletoaerate rauhijiriin esinae aite. Cauricho que aonacaaunna jaunna jerichanetojoeein beebejeeun, caa chauratane que neniquichene rai,” naa Cana Coaunera Calaohi Jesosone ");
INSERT INTO uraNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","janate coitucusichurene, “Naaonjoain Cana Coaunera quete aitera,” naain coitucuurenihane jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nitohaneein coitucuurenihana jaunte: “Inara araaineein nihanu natiinte, enuha que ecuu canu nujuateein canu chujuuraa curiquicheein. Nii banate Curisitoneein nihanune coitucuhin, casuujua caje rocohin aitenihanune coitucuha curiquicheein. Acaihanejein carelaa Ofa Cana Coaunerana jaan que aitocoaaunne coitucuha curiquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chabana jelai caratirihei caletoaera Ofa, niicha jerenohin ichacaaunna jaun,” ");
INSERT INTO uraNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","naa Cana Coaunera Calaohi Jesosone jaunte esenetaaure arajiin cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nii baihate esenetaaurera Jeroocuru rai: “Rauhijiriin quere tonoraaichenete, canu ere tonoraera esineneein neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nii banate esinae rauhijiriin, Cana Coaunera jerenohi coitucuhin raotojoeein jianacoo ichaonaa naineriquicheein,” naa esenetaerauru rai Cana Coaunera Calaohi Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“Canacaanu foeratera Abaraaun caje coaauneein nihein chunei fatoroon canacaanu cailichaera. Inasiinte nii aitohine tocohaneei enene cuhaneeicha ichoreniha jianacoo mituhin nerichaanu. Nechu jataaina inoaelu caje coauneein raotojoeein rerohecaeraelanaala ichohacaanu,” naauruha nii esenetaaichuru Jorioocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","“Satiin quere tonoraauruhite jataain mululuhin osa tabai aiha ne. Nii chunijiu cuhin nichotenaa nainerihaain. ");
INSERT INTO uraNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cana Coaunera Calaohineein nihanune jaunte ne carai rauhi jianacoo nii osa caje inara mitaanune coina. ");
INSERT INTO uraNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Canu nii caje jianacoo inara mitaanunete esinaae rauhijiriin jianacoo mituhin neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abaraaunte chuhisi inara foeratera ne niqui, nete casohin cajaonaa jerequiche, quere esentaeneeichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Carelaa Ofa najaan quena inara rai aitoon. Charijieein teeinti, inara relaa inara inacana jaan ichaquiche, nii rijijieeina canu netonai caletoaa Ofane jaa ichaaun,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“Abaraaunte canacaanu inacane,” naauruha Jorioocurune janate: “Esinae rauhijiriin Abaraaun calaohi neeichene jana nihanetera, aichejetohalune rijijieein neriquiche inara netonai. ");
INSERT INTO uraNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nete esinaae caletoaa Cana Coaunerane que aitocoaaunne coreniha casohin cajaonaa jerequiche. Chabana nitohanai que nerurujuanaa jeriheilu Abaraaun. ");
INSERT INTO uraNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inarate aiha inara inacane rijijieein neeinche,” naa Cana Coaunera Calaohi Jesosone janate: “Coatiha unosineein nihaacaanu, Cana Coauneraachate canacaanu inacane,” naauruha Jorioocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","“Cana Coaunera inara inaca niha netera, canu belaicheeiche, Cana Coaunera caje uhin cau turuhin nihanune jaun. Coatiha casuujua caje coaauneein cau uhin turuhaaun. Cana Coaunera te caletoae. ");
INSERT INTO uraNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Quere esenetana jereneeichene jaunte, caa inara rai aitocoaunne aonasineeinche. ");
INSERT INTO uraNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Moconajaerate inara inaca ne. Nii jaunte, caje nenaa neeichene jaun niicha jereeicha ichaquiche. Nii Moconajaerate inoaelu caje coauneein soserejeein ne. Chabana rauhijiriin chaque irihei. Chaque irihanete nohane, nichaon nihana jaun, casaje nujuaneein nihana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Esinae rauhijiriin aitocoaunna jaunte quesenetaeneeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Chariji inara caje osaquiin nihanune coitucue. Chanuna esinae rauhijiriin aitocoaun natiin quesenetaeneeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Cana Coaunera cacha nequichenetera, Cana Coaunera ere rautaain aonaain tonorareeiche. Cana Coaunera cacha neneeichena jaunte, Cana Coaunera ere aohana jereneeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Esinaete rauhijiriin osaoquicha- Samaria cocoaicha,” naain Cana Coaunera Calaohi Jesoso cotaihuruha Jorioocurune jana: ");
INSERT INTO uraNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Nihei aansijieein nejein osaaohaun. Nechu acaihanejein Ofaacha jerenohin ichaain nihanune corenihate caansaine que ereeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Coatiha, ‘Canuna caohacha cachaneeun,’ naain irihaun. Curuaanaaneeinte caeteein ne Ofa. ");
INSERT INTO uraNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Esinaena rauhijiriin aitoon, quere tonoraerate chabana nitajenaachara nejeein nereein,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Esinaete osaaoquicha. Inasiinte Abaraaun, satiin Cana Coaunera ere bera inoaesihuru, naaojoaihunru inae oosichuruhalu inoaelu natiin, chere tonoraeraacha nitajenaachara nejeein neeurureta. ");
INSERT INTO uraNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abaraaun amurijiriinna nereei iite. Inae ohane jana ohacoaauruhalu Cana Coaunera ere bera inoaesihuru netonai natiin. Chaneeina jana ii nereei,” naauruha Jorioocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","“ ‘Canuna inara curuaanaa caohati neeun,’ naain irihanune caohacharihei. Nete caque: ‘Caate acaihanejein canu calaohine. Nere tonoraauche,’ nae Ofa Cana Coaunera. ‘Cacoaunera,’ naaiche niqui. Nete ");
INSERT INTO uraNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","coitucuujueneeiche. Canune laaen coitucuun. Inara rijijieein casaje nichaaunnena, ‘Coitucuhaun,’ nareeun. Esinaena rauhijiriin caraajenihane coaracaunna jaun, nere tonoraain caletoaana jaan ichaaun. ");
INSERT INTO uraNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Inara foeratera Abaraaunte, cau chauratane que catohaneein tururichaaunine coitucue. Nii jaunte inae ena cau turuhanune jaun coroajeein rachoojoe,” naa Cana Coaunera Calaohi Jesosone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","“Inasina saoquichoonca jaanacaaine coaalanaala, canacaanu foeratera Abaraaun coaareei,” naauruha Cana Coaunera Calaohi Jesoso rai Jorioocurune jana: ");
INSERT INTO uraNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Aihanu. Esinaena rauhijiriin aitoon. Inae inoaeluna Abaraaun ajiniha nesiha neeun canu,” naa Cana Coaunera Calaohi Jesosone jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ajeri mucuutaaure, que botosihuruhane coina. Ajeri mucuutaauruhane janate, jianatoroaain acaauru cataan cuhin, Teenforo caje mituhin amue. ");
INSERT INTO uraNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Amuhemujuena jaunte leinjiin cacha maosaneein nejanoanaa coarae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Coaraane janate: “Chanuna maosaneein nejanoae caa cacha. Rai fojiaraauru osa caaun nenihane, rai nosa caaunna,” naain Jesoso caje bajaacaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","“Aihei, coatiha nosa caun nihei. Niheichu fojiaraauru osa caaun nihei. Cana Coaunera ichanohi coaraa cachane coinate catohaneein nejanoae. ");
INSERT INTO uraNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Inae caletoaeraacha icharatei ichacaaunnete ne, nainichaaunne cojoataa. Inae caa baiha nainerihaaunni. ");
INSERT INTO uraNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cau chauratane que nihanune quena, chauratane cononeein neeun,” ");
INSERT INTO uraNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","naainte, atane choaae lune churutaain, biji couturi que laculacunejeein, itacariin nii maosa nota rujuaain: ");
INSERT INTO uraNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Inae laaenra, taa necaojoanaa najaan Silohe inota culeenihura,” naa Jesosone jaun, cuhin culeecane caje turuhane janate, inae conoe nii maosa nota. (Silohe nanaate, Letono nanaa ne.) ");
INSERT INTO uraNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Inae nerautaa jana coaraainte: “Caana lauhajelauhajeein coriqui bajanajaaoca,” naain ita caje bajaaure nii laurijiracuru- nii jauriaa nitohaneein coaaraauru. ");
INSERT INTO uraNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Niritiin ita caje bajaainte: “Aca chujianrana,” naauruha tabaaurune janate: “Aca nihane coaalanaala. Tocohaniha chuhisi niqui, nete aca nene,” naaure leeochaauru. Nii janate raajenihane: “Acaneeun chujianrana,” naa raajene jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Inasina jana enene conoe inota,” naain bajaauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Nii leinjiin cacha- Jesoso neein curuajaain nenaate, atane choae lune churutaain, biji couturi que laculacunejeein, tucuacaain canota rujuaain: ‘Inae laaenra, necaonjoanaana jaaun Silohe culeenihura,’ naain caletohana jaun: ‘Ai,’ naain culeecaunne janate, inae conoe caa canotara,” naain bihane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Aanca chaen nii cacha,” naain bajaauruhane janate: “Jm, jm, jm. Aancachaainti. Coitucuhaun,” nae nii maosa nerautanaa. ");
INSERT INTO uraNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nii janate nii maosa nerautanaa amaauruha fariseeocuru renene janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","15","“Inasiinte enene conoe inotata,” naain cotaain bajaaure fariseeocuru nii cacha caje, nebetacanaa janonaa bana atane choae lune churutaain biji couturi que laculacunejeein tucuacaain nii maosa nota rujuaain, rautaa Jesosone jaun. Bajauruhane janate: “Itanicha que canota rujuarujuariin culeeratihane jana, culeecaaunne janate inae conoe canotara,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","“Cana Coaunera caje nenaa nihei nitohanai cacha, amihaniha nebetacanaa janonaa banana jaun,” naauruha tabaaurune janate: “Inasiinte Cana Coaunera tocohaneein ichaa natiin, osaona nihane nitohanai ichanaa nainerihei bajiaa,” naauruha nii leeochaauruna jaunte, ");
INSERT INTO uraNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","coaiteen enacoauneein: “Tonaai jana ii, nii ichautaera cacha que,” naain bajaauruhane jana: “ ‘Jerihane acate Cana Coaunera Ere berane,’ naanu canu,” naa nii nerautanaa maosane janate, ");
INSERT INTO uraNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","esentaaurene. Esenetaaurenihana jaunte, fojiaraauru caje bajaaure: ");
INSERT INTO uraNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Caana inara calaohineein maosaneein nejanoaa. Inasiina jana enene conoe rai nota,” naain bajauruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","“Aca chujian, acate canacaanu calaohi maosaneein nejanoanaa ne. ");
INSERT INTO uraNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Inasiin chaaiti conoe enene rai nota. Niheichu nii rautaera coitucuhaacaanu. Cajejian bajaauche. Inae canaanai nihane coaalanaala. Acate naine raaje bihane,” ");
INSERT INTO uraNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","naaure nii fojiaraauru, Jorioocuru curuaanaa coasiha. “Acate Curisitone,” naain iriha chuneine, “Cau sinacoca asaae enohane jererihacacheein,” naauruha nii Jorioocuru curuaanaacurune raotojoeein coitucuuruhana jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","“Cajejian bajaauche. Inae canaanai nihane coaalanaala. Acate naine raaje bihane,” naaure nii fojiaraauru. ");
INSERT INTO uraNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nii janate coaiteen nii maosa niicha rautain cotijiain: “Esinaen rauhijiriin beeu, Cana Coaunera notaracaae. Osaaotoha nii cachane coitucuhacaanu,” naauruha Jorioocuru curuaanaane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“Osaaotoha nii cachane coitucuhaaun canu. Acaihanejein maosa nihanune caje, inae enene conoha canota neeinchana coitucuujueeun,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Chatohaneeinte chete nitohaneein conoha inotane coinata,” naain bajaauruha coaiteenne janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Inaera inara rai aitoonna. Chatonaaina nenacaaen bereeun. Chanuna coaiteen enacoaauneein inara rai bihanune jerequiche. Jerihane inara netonaite nere tonorana jerequiche,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","“Iite laaen nii cacha ere tonoraai. Canacaanuna jana, jelai teein Moisesa ere tonoraacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moisesa aina iriha Cana Coaunera neeichana coitucuhacaanu. Jana nii cacha coitucueraai caoachanainejeein. Chacaje chaainti ecoonane,” naain nii maosa nerautanaa cotaicha rijitucuruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","“Tara canota tihane caje coitucuhichene. Niheichu: ‘Naaojoain cajete uhe,’ naain coitucuheeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cana Coaunera bajaa osaaonaaurune tonoraeniha Cana Coaunerane coitucuhacaanu raotojoeein. Acaihanejein nere tonoraain niicha jerei ichaain nenaa cacha bajaanete coroatajane Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nihei chunei, inoaelu caje coauneein nitohaneein maosaneein nejanoaa leinjiin cachane jana nota cono tera. ");
INSERT INTO uraNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Cana Coaunera caje unaa nenihane noote catohanai ichare,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","“Osaaotiin nejanoaaina jaun noote canacaanu relanaa jereeita,” naain nii maosa sitaaure ita taojiaauruhana jaan loreri caje. ");
INSERT INTO uraNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Inae nii maosa sitaauruhane coitucuuriin, coaraa cuha Jesosone janate que tacaa uhe. Nii jaunte caje bajae: “Cana Coaunera Calaohi esenetaaina,” naain bajaane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“Eenje. Carai beeuna, rauhijiriin Cana Coaunera Calaohi nihane coitucuhin esenetaera Curuaanaa,” naane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Canuna acaneeun,” naa Cana Coaunera Calaohi Jesosone janate, ");
INSERT INTO uraNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","nacatiha neseeonraain: “Esenetaanura Curuaanaa,” naane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","“Canuna caa chauratane que turuun, maosacuru niha natiin, conoha rai notane coina. Jana, notaa nocoetonacaauru maosaneein nihane coina,” naa Jesosone janate, ");
INSERT INTO uraNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","cuu aonajeeuruhana jaun: “Canacaanu netonainoona maosaneein nihacaanu,” naa tabaauru fariseeocurune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","“Maosa neeichene, caseteco coaariheeicheein osa coreniha niqui. Nete, ‘Itolere canacaanuhacha ichai coaraain coitucuhin ichacaaunne jaun maosa nihaacaanu,’ naaichene jaun, caseteco coaraa curiquichein nii coreniha,” nae fariseeocuru rai Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Niritohane baihate: “Esinaena rauhijiriin aitoreeunni. Carenero ucuha acuujua edaa enoite asijiauto ne. ");
INSERT INTO uraNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jana, rauhijiriin nacuujua cuhane enoite beraicha esine ne. ");
INSERT INTO uraNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Acuujua beraichate, janone acuujua joracaain, enohin curuaacuru curuaacuru que curuaateein, nii carenerocuru cotihacane tajiha uure, acaauru beraicha nihane ere coitucuuruhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nitohaneein cotihanajaain, inae saain mituuru jana, acaauru ajiniha cuujihane jana, caaijie cuure nii carenerocuru, acaauru beraicha nihane coitucuruhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jana nejelau cotihanaacanete, que janoriin soroore, nejelau ere nihane coitucuuruhana jaun,” ");
INSERT INTO uraNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","naain niqui relanajae Cana Coaunera Calaohi Jesoso, coitucuuruhane coina niqui. Nete, “Naaonjoain quete aite,” naain aonaain coitucuurene. ");
INSERT INTO uraNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nii jaunte, rauhijiriin aonacuruhane coina: “Leinjiin canuhachana jianacoo cacha mitaeranu que nenaa neeun. Cacolane cana Inaca Cana Coaunera rene turunaa nainihei chunei. ");
INSERT INTO uraNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nii jauriaa cajiniha unacaaurute, nechu jataain cacha coritaeraaunu que unacaaurulu ne niqui. Nete, nere tonoraaurene cacoitucueranuuru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Leinjiin cacorenihachate naine, cana Inaca Cana Coaunera bijiu tacaain aina neeichene. ");
INSERT INTO uraNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Arajiite inara curuaanaaneein nenaa jere, nechu jataain nohaneein inara coritaain. Acaauru esenetaain, acaauru ere tonoraeraaurute caoachanainejeein nitajiha cuurureein. Canuna turuun, raotojoeein rachoojoeein cha latelanaala Cana Coaunera aina neeichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Canuna esinae rauhijiriin inara curuaanaanu que letononeein neeun. Nii jaunna oha cureeunni satiin canu cachaauru coreniha, nabana necairichaauruhane coataa, satiin quere tonoraain esenetaeraauru, necairichanaa coaraelanaala rauhijiriin Cana Coaunera aina nihane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nii curuaanaa neein nenaa jereraaurute, nechu jataain core coinaacha aihuruhana jaun, niha acaauru aina nejerateein acaauru coineterane, cachaauru jaohin ratiriin sorooruhane acaauruhacha mucuhin sooruhane, cajihaneein ita caje riaaneeure. ");
INSERT INTO uraNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nitohaneeinte rai cachaauru ratiriin soroore, nechu jataain curuaanaa neein nenaa jerecuruha core coinana jaun, coaraain cuu nainaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Canunajian nenacaaen caohacha nejeein curuaanaaneein neeun. Charijieein teeinti cacoitucuhiche nii rijijieeina Ofa coitucuun. Nii rijijieein inachu, canu cachaauru coitucuun. Jerichanejeein techu coitucunajaanune rijijieein cacoitucuure. Canuna canu cachaauru coreniha caraajenihane neteein oha cureeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nihachu naain nejelau canu cachaauru, cotihanaacaaun nete ne, ita aina inara tihanune coina. Cotianaacaun nete, quere tonoraain uurureein. Inae nitohanihanena leinjiin canuhacha inara curuaanaa neein niha cureeunni, nitohaneein ita aina inara tihanu ne. ");
INSERT INTO uraNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nere tonoraain caletoaana jaan ichacaaunna jaunte, jataain cacoelai cana Inaca Cana Coaunera. Nii corenihana caraajenihane netiha cureeunni, casohin cajaaoruhane coina, nena ichanaa cureeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Canu jerenihanune, nihei chunei casohin cajaonaa nainerihei. Nena caraajenihane netiha cureeunni, nitohanihanune coina caletoaa Ofa Cana Coaunerana jaun,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Niritoha Jesosone esenetaeraauru Jorioocurute, nii esenetaauruhichuru caje nejelau neleruhin neeure. ");
INSERT INTO uraNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Niichurute: “Chanuna caa osaaonaa nechu aansai jaeloroheneein nenaa cacha ere tonoraaure,” naaure tabaauru itarai. ");
INSERT INTO uraNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nii jana nii esenetaaurerate laaen: “Osaaocane noote caritiin erere. Chasiina jana osaaocane maosacuru nota cono tere,” naaure ita rai nejesinajeein. ");
INSERT INTO uraNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Inae elohena nihane janate, Jerosaleeun ita taojiaain nii loreri inoaesi Teenforo besaute beseta bitoaaure Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nii jana nii Teenforo coonri seeonjoan- Salomoon curuaa siriin nenaa asaae amuhemuheca Cana Coaunera Calaohi Jesosone jana ");
INSERT INTO uraNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","curuaacotaain, acaauru cataaun teteriin: “Cha carajana erereei ii coitucuhacaanune coina. Rauhijiriincha letonoaneein ereeu, esinaae Curisitoneeine,” naauruha Jorioocurune jana: ");
INSERT INTO uraNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","“Inae bihanulu. Nii jana quesenetaheeichelu. Inae caletoaa Ofana jaan ichacaaun inara notaracaae. ");
INSERT INTO uraNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nii coaraquiche niqui. Nete jauriaa aitocoaaunne tocohaneein canu cacha neneeichene jaunte, caje nainaain quesenetaeneeiche. ");
INSERT INTO uraNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Coitucunajaain nihanune rijijieein techu, cacoitucuhin quere tonoraain neeure canu cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Canuna acaauru rai nitajenaachara nejeein nenaa ichaonaa teeun. Chaaelai janonaa bananeriaain nitajeeuruhane. Niheichu chaaen cacaje rulunajaera. ");
INSERT INTO uraNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Satiin curuaanaacuru curuaanaa Ofa Cana Coaunera carai tenajaana jaun, nihei chunei cacaje rulunajaera. ");
INSERT INTO uraNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Canuna, Ofa aina leinjiin Cana Coauneraneein nihacaanu,” naa Jesosona jaunte, ");
INSERT INTO uraNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ajeri mucuutaaure Jorioocuru, que bodoosihuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nii jaunte: “Itolere caohachana ichaaun satiin coarajeeichene notaracaae, Ofa letononeein. Chatohanei corenihana nitoaneein ajeri que canu bodoosicheeiche,” naa Cana Coaunera Calaohi Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“Caohacha ichaaine coreniha ajeri que ii bodoosiriahacaanu. Cana Coaunera niha nocoetiin, Cana Coaunera rerohecaaina jaunna ichana jerichaanu. Cana Coaunera niheei. Raujiaain cachaneein natiinte Cana Coaunera niha nocoetohi,” naauruhane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","“Inarate casohin cajaonaa jerequiche, ‘Ofa cana Inaca calaohi nichaaun,’ naanune coreniha. Chaaen techu nii coreniha, ‘Ofa cana Inaca Cana Coaunera rerohecaa,’ cacoeeiche, Cana Coaunera chujian raajenihane, ‘Canu calaohichuru’ naa inoaelu ichauhenaauru rai, rai quiricha inoaesi cuhanena jana, esenetaaichelu satiinina jaun chujian, caa chauratane que caletoaa Ofa cana Inaca, niicha jerenohi ichacaaunne coina natiin. Inasiina Cana Coaunera rerohecareeun, ‘Ofa Cana Inaca calaohi nichaaun,’ naanune coreniha. ");
INSERT INTO uraNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ichaa Ofane tocohaneein cha ichaenihanune coa canu esenetaache. ");
INSERT INTO uraNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aihane jaun, canu esenetaeneeichene nihanatiin, nii canuhacha ichai coaraain esenetaaichenete caohachae. Nii ainate canu aina niha Ofa Cana Coaunerane jana, canu rai Calaohineein aina nihanune esenetaaichene caohachae,” naa Jesosone jana, ");
INSERT INTO uraNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","coaiteen mucuhin amanaa jerecuruhane jana, acaauru que janoriin amue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Acaauru que janoriin amuhinte Jorodaan jerau cauha cue. Nii jauriaa cachaauru coujunacatihalu Joaanna jaaun turuhin cuu ne. ");
INSERT INTO uraNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nii janate rene turuha uure arajiin cachaauru. Cuu turuhin coaraain: “Esinaete chuhisi rauhijiriin aite Joaan, caa cacha que. Niicha ichai ichaain cana notaaca Jesosone rijijieein cana notaacane que airijiinte, esinae rauhijiriin aitohane tocohane,” naainte ");
INSERT INTO uraNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jesoso esenetaaure cuu nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Naain Betaniau coroatajai baihuru aina nenaa Lasaroneein curuajai jetaote, banejelanaala cunaite. ");
INSERT INTO uraNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Marata, Mariha, naa nii baihuru curuaa. Nii Marihate, Cana Coaunera Calaohi Jesoso tijia choaae erene jujui jataain coreti chorohin, couturiji que jacoraera ne. ");
INSERT INTO uraNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nii jaunte cunaitiha nii acaauru cona Lasarona jaun, “Cunaitiha iicha belaaicha curuaanaa,” naain Jesoso rai berateeure. ");
INSERT INTO uraNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nii jaunte Jesoso rene turuhin beeuruhane jana: “Coatiha nii cuaaetoha nii cunai caaun orihaain. Cana Coaunera coitucuhin, ‘Caohatoha Cana Coaunera Calaohi,’ naain Cana Coaunera Calaohi coitucuuruha satiin cachaaurune coinate cunaite nii cacha,” naainte cuelanaala cuu coroata janohin ne Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nii baihuru aina curataain belainaaca natiinte ");
INSERT INTO uraNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","“Cunaitiha Lasaro,” naain berateeuruhane jana. ");
INSERT INTO uraNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","coroata janohi cuu nihane baiha: “Chajaauchete coaiteen Jodea cunichaache,” naa Jesoso, aina nerelanaa nichaanune raine janate: ");
INSERT INTO uraNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Jaitinootera carajaje, ishohin ijiaonaa jerecuruha Jorioocuru, ajeri que ii bodoosiine. Nii atiin inachura coaiteen ucuaae cunaa jereeite cacha relaera,” naacaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","“Tana, cojoanonaateein caletoaa Ofa Cana Coaunerana jaan ichacaaunne nihane coitucuhichene. Ichaenihanune, canuhachana baasoneein nedareeunni,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nii baihate: “Siniha cana belaicha Lasaro, nocoa inae nocoaa curichaaun,” naa Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","“Aihana jaunte chujian, sinihana jaun nerautareein,” naacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Esinae sininaa que jecha aite naacaanuna jaunte, ");
INSERT INTO uraNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","rauhijiriin: “Inae oha Lasaro. ");
INSERT INTO uraNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Caoacha quete cuu nenihanune jana ai. Inae laaen jataain quesenetaa curiquicheein,” naa Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","“Chajaauchete cana netonai aina cunichaache, aina jiniiquiin ohacachene coina,” nae nii Tomasi canacaanu rai. (Nii Tomasite curuaateeure Fafione neei, fafione nihana jaun.) ");
INSERT INTO uraNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nii janate Betaniau turuha Jesosone jana, inae jena janoha atane neruujuene beeure. ");
INSERT INTO uraNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Saaneein itaraeniha Jerosaleen caje nii Betaniane jaunte, ");
INSERT INTO uraNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","tajiha caje turuhacoaaure Jorioocuru, nii onaa cacha baihuru Marata, Mariha, naaonjoain suujua nunaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nii janate turuelalajeein tajiha uujiha Jesosone coitucuuriin que tacaa uhe Marata. Jana, Marihate, loreri asaae nedae. ");
INSERT INTO uraNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nitohaneein cuhin Jesoso que tacaain: “Cau neeichene jana nihane, oriheiche canejerata curaanaa. ");
INSERT INTO uraNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nete, chaelai bajaaichene ichei tiha cureeinche Cana Coaunera,” naa Maratane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","“Ichanaainte coaiteen nichaurareeinche,” naa Marata rai Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Eenjeen airichaainche chuhisi. Inae besautiha cana janonaane banate, coaiteen ichanaain ichaoha cuurureeinche oonacaauru niquicha,” naa Maratane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","“Canuna onaa ichateein, rai ichaonaa nitajenaa charanejeein nenaana jaan teraneeunche. Quesenetaerate, ohane niha natiin ichaoha cureeinche. ");
INSERT INTO uraNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Satiin jaiti ichaohin nenacaauru quesenetaanete, ohane niha natiin, chabana nitajenereeinche. Caa caitoonjoan esenetaaichena,” naa Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Eenjeen, iite Curisito neein- Cana Coaunera Calaohineeinchene esenetaanuchera. Iite caa chauratane que turuha uha niicha jerecuri canacaanuhacha cohajei ineinchera,” nae Marata. ");
INSERT INTO uraNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Niritohane baihate, nocoasai Mariha cotihaca cue Marata. Rene turuhinte: “Taute turue cacha relaera. Ichotijiaeratiha jaunna ii cotihaca uun,” naa Maratane jana, ");
INSERT INTO uraNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","luhecotariin nimihuritiin Jesoso coaraa uhe Mariha. ");
INSERT INTO uraNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nii janate nii ratiriha Maratana jaaun jelaiha ne Jesoso, jaiti nii neseu turuelanaala. ");
INSERT INTO uraNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Luhecotariin nimihuritiin uha Marihana jaunte caaijie uure nii loreri asaae aina neein suujua nunaa nenacaauru Jorioocuru, “Naain atanebana choaae jecha inaderaa cue,” naain niqui caaijie cuure nii Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nii janate Jesoso rene turuhin nacatiha neseonraain: “Cau neeichene jana nihane, oriheiche canejerata Curuaanaa,” naain ");
INSERT INTO uraNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","chanaa Marihane jana, aina chanaauruha Jorioocuruna jaun, jataain inaderaain: ");
INSERT INTO uraNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Chu atane rucuhecure,” naain bajaa Jesosone jana: “Nota taute atane rucuhecurera Curuaanaa. Chajaautejian coaanicha,” naauruhane jana ");
INSERT INTO uraNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","chanae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nii jaunte: “Jataainte coinaderae,” naaure Jorioocuru tabaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nii jana leochaaurute jana: “Tajian caa cacha, maosa nota cono tihalune. Tajian jana naineriha chaaelai ichaa oheniha Lasarone coinane,” naaure nii leochaauru Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nii jaunte atane bana rohan turuhin, coaiteen inaderae Jesoso. Ajeri jachu cuhane ita rucuhecuruha Jorioocuru, jelai ajeri que fuhina jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Joracaauche,” naa Jesosone janate: “Inae jerihane nirinihache cacha natiinta. Inae jena janohache aiha cachane natiinta Curaanaa,” naa nii nijiaonaa cacha bai Maratane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","“Inaera ichei, ‘Esenetaaichenete Cana Coaunera ichanohin caohati coaariquicheeincha,’ naain ichei aitoonchena,” naa Cana Coaunera Calaohi Jesosone jana ");
INSERT INTO uraNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","joracaauruhane jana, dede coarajeein: “Nariha Ofa, ii bajaanune satiin quiicha bajanojoin tenajaaoqui bajaanune naineeine coreniha. Nii jaunna ichei aitoon, aonacuruha nuricho que cau nenacaauru cachaaurune coina, aonaain esinae rauhijiriin ii caletohaine esenetaauruhane coinara Ofa,” naane ");
INSERT INTO uraNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","baihate: “Lasaro, mituu nii lai caje,” naa Cana Coaunera Calaohi Jesoso tonijiaine jana, ");
INSERT INTO uraNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tajiha conaara tijianeein mituha uhane jana: “Batuhichuchete jianacoon mituhine,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nii ainate Cana Coaunera Calaohi Jesoso esenetaaure le lauriin Jorioocuru, nii Mariha corianiha cunacaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nii jana, acaauru tabaauru jetaote turuhin biha cuure fariseeocuru rai. ");
INSERT INTO uraNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nii jaun jetaote itataojiaaure fariseeocuru, batirichuru curuaanaacuru, saain cocoainanacaihuri nii que ita rai ereereecuruhane coina. Nii jaun jetaote ita rai: “Inae itolere ichaa nii cacha. Inasirihacacheta. Maosacuru rautaain, onaa ichateein, lenone faain, itolere ichaa inae. ");
INSERT INTO uraNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Naajeein inauheneeicha coarajihacachenete, esenetaacoaauruha satiin cachaaurune, cana cairichaaurureein Romanocuru rai cocoainanacaihuri. Cana raite caa ita taojianaana jaan loreri Teenforo chamuhitiin cana cairichaaurure,” naaure jetao Jorioocuru curuaanaacuru. ");
INSERT INTO uraNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nii jana jetaote, cuune leinjiin Caifasineein curuajaain batirichuru curuaanaa. Nii jetaote: “Joaereeinte ereereequiche. ");
INSERT INTO uraNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nita coitucuhichene, cana caohachanu que tejian oha cureein nii leinjiin cacha, nabana necairichanaa coaracaache satiin Isaraeli cocoaicha nichaachene coataa,” nae jetao acaauru rai nii Caifasi. ");
INSERT INTO uraNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Coatiha suujua caje coaauneein rocohin aitohi nii Caifasi. Nii ajaana cuhane batirichuru curuaanaa neein nihana jaunte coroatajane Cana Coaunera, nabana necairichaa Jorioocurune coataa oha curichaain Cana Coaunera Calaohi Jesosone que aitohane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Coatiha Jorioocuruhacha coreniha oha curihaain niqui. Satiin chauratane sacutaain riaaneein nenacaauru Cana Coaunera calaohichuru jitariin taojiaane coinate aicheein.) ");
INSERT INTO uraNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nitohaneein oo caje Lasaro ichatihane caje coauneeinte, Cana Coaunera Calaohi Jesoso que necosuujuaaure Jorioocuru rai cocoainanacaihuri, sohin jaaoruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nii jaunte Jorioocuru rai cocoainanacaihuri rai ecocoelanaala nii Jodea batane caje mituhin naain Efaraaiun cue Jesoso. Cacha areroo rohan nenaa neseu Efaraaiun cuhin cuu ne, canacaanu aina. ");
INSERT INTO uraNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Fasocoa cataihajeein, neseeuru neseeuru caje naain Jerosaleeun cuhajeeure, acaauru necoaauna rijijieein naunatajaain, necaaonjoaain jatoroaain Fasocoa beseta bitohauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nii Jerosaleeun turuhinte cuu cajianeein Jesoso ariirijieeure. Cuu nenaa ita taojiahuruna jaan Teenforo asaae ita taojiaain: “Beseta bitohanacha urichaai,” naain itacaje bajaaure, ");
INSERT INTO uraNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","“Chunocoha, ‘Cuute ne,’ naain coitucuhane, beeinete mucuhin raeratihacaanu,” naauruha fariseeocuru, batirichuru curuanaacuru, naaonjoainurine jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Saota janonejeein lanajeeca Fasocoa janonaane janate, nii oo caje niicha ichatei Lasaro coaraa cue Jesoso naain Betaniau. ");
INSERT INTO uraNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nii janate cuu beseta bana rijijieein Jesoso coroaateeure, raaoti lenone que. Lasaro bai Maratate, acaauru rai lenone lauriae. ");
INSERT INTO uraNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nii jana litoro cataaun uujoaain erene jujui coreti uhaain, que Cana Coaunera Calaohi Jesoso tijia rujuaain, couturiji que jacoraa Marihane jana, juujijiain bijiihaque nii loreri asajai. ");
INSERT INTO uraNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Nii jaunte: “Chanuna nichata fashai janonei amihanenaa core tocohaneein necoretelanaala aihure, cairichaihuri coroatajanenarichaae,” nae nii canacaanu lechoonca coroataja Simoon calaohi Jodasi Isacariote, nii Jesoso coulurujueranu. ");
INSERT INTO uraNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Coatiha esinaae rauhijiriin cairichaihuri coroatajanena jerihane caaun aitohi. Asijiautonihana jaunte aite, nechu jataain aca nii coriqui raane jerena caaun. Aca canacaanu coriqui beraichaneein nihana jaun raotojoeein basijiauhane coinate aite. ");
INSERT INTO uraNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Niritoha Jodasine janate: “Coa rerohecaa. Cajabereeo rucuhecuruha najaannu que niicha rucujuei nihana jaunte ichae. ");
INSERT INTO uraNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Cairichaihuri coroatajanena jereeinete, nereein inoaenlu netojoeein arajiin cairichaihuri. Coatiha inoaelu netojoeein cau nerinaaunni inara aina,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nii baihate, Betaniau niha Jesosone coitucuuriin coaraa cuure Jorioocuru. Coatiha acaacha coaraa aihuruhi. Lasaro- nii oo caje niicha ichatei coaracuruhane coinane maajeeinte aihure. ");
INSERT INTO uraNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nii jaunte ita suujua rijitojoeein, ita suujuau tacaain, “Chatohaneeinte acaentonai sohin jaonaaneeineta,” naain ");
INSERT INTO uraNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nii Lasaro netonai que necosuujuaaure batirichuru curuaanaacuru. Ohane jana ichatiha Jesosone coaraain esenetaauruha le lauriin Jorioocuru, acaauru jianeeinna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nii janate Jerosaleeun cuhacoaaure arajiin cachaauru, Fasocoa beseta bitoaa. Nii cojoanoote turuha urichaain Jesosone coitucuure. ");
INSERT INTO uraNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nitohaneein coitucuhinte, elele alo saaujiin amaain que tacaa cuure. Que tacaain: “Caohacha quete uhicha- canacaanu coroatajaneraunu que Cana Coaunera letono. Cachuura,” naain, “Caa Cana Coaunera letono belaihuruhine itolere cachaauru. Caa Isaraeli Curuaanaa Rey belaihuruhinera,” naain, ehequiin coroajeein Jesoso raaure. ");
INSERT INTO uraNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nii janate cabario tocohaneein nenaa boro ichoaae iniin laulauquiin turuha uhe Jesoso, aitoha Cana Coaunera Quiricha Inoaesi cuhanene tocohaneein: ");
INSERT INTO uraNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Coa coasichachera Jerosaleen cocoaichacuru. Coaracuche, boro choaaete laulauquiin turuha ureein inara Curuaanaa Reycha,” naa Cana Coaunera Quiricha Inoaesi cuhanene tocohaneeinte turuha uhe Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nii janana caoachanae netojoeein aonajihacaanu aina nerelanaa nichaanune. Nii baiha inae dedeeu cuha Jesosone janate, canacaanu suujuau neeorite, niriitiin aitoha Cana Coaunera Quiricha Inoaesi cuhanene tocohaneein aihane coaracaanune jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Oo jana nii Lasaro ichatiha Jesosone coaraauru cachaaurute nii leochaauru rai beeuruhana jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","nitohaneein onaa ichatihane coitucuuruhana jaun, Jerosaleeun turuha Jesosone jana, que tacaa cuure. ");
INSERT INTO uraNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nii janana coarajenajaain: “Inae coaraquiche. Inae cha chana nainihaacacheta. Coaracuchera. Saainte aina cuurera,” naain ita rai ereerejeeure fariseeocuru nejesinajeein. ");
INSERT INTO uraNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Naain Jerosaleeun cuhin Fasocoa beseta bitoha cunacaauru aina cunacauru ");
INSERT INTO uraNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Curiecocuru tabaaurute Jesoso aina nerelanaa Ferifi rene turuhin: “Jesoso coaana jerichaanura curaanaa,” naaure. (Nii Ferifite Calileea batane que nenaa Betesaaida cocoaichane.) ");
INSERT INTO uraNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nii janate Aanderesi rai bihana jaun, jiniiquiin cuhin Jesoso rai biha cuure. Jesoso rai beeuruhane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","“Inae laen ecu tiha ohanune cojoinaca. Canuna inaraacha cohajei cachaneein neeun. Ohanune baihate satiin curuaanaacuru curuaanaa niha caenoaa cureein Ofa Cana Coaunera,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Niritiinte, “Esinaena rauhijiriin aitoon. Charijieein teeinti lecuhejeein temueraeniha arosone, omaroelanaala jerichanejeein ne. Jana atane choaae naluhane, omarohin arajiin inacaain nefae. ");
INSERT INTO uraNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nii rijijieein techu ne cacha netonai. Niicha jereeicha ichaa cachanete, temueraeniha ne, aiha arosone rijijieein jerichanejeein ne. Nirijieeinte, nechu jataain joaereein niha cureein. Jana cha que casilanaala Cana Coaunera jerenohi ichaa cachanete, Cana Coaunera bijiu tacaa cureein. Jana, ainihanete nitajiha cureeincha. ");
INSERT INTO uraNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Quere tonorana jerera, quere tonoraaine. Nii quere tonoraerate, nii cuhanune jaun niha cureein caniha. Chaen techu, quere tonoraera, Ofa rai coroaaenacai ichareein,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nii baihate: “Nererojoecaa jataain casuujua. Chatohanerihanu coaetaata. Nihei, ‘Cacorataaneeu Ofa, casohin canu ateinaauruhane coataa,’ naain erenaa nainihaun, nii coina cau turuhanune jaun,” naane baihate, ");
INSERT INTO uraNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Ofa, coaiteen iicha ichana jerei ichaain caa cachaauru notaacu, aihute coaraain, ‘Caohatoha Cana Coaunerara,’ naaurumiin satiin cachaauru coaraaincha,” naain Cana Inaca Cana Coaunera bajaa Jesosone janate dedeeu tonii: “Inae ichacaaun cacoitucuuruhane coina. Inae coaiteen icharichaaunni coaraain canu nichaaunne coitucuuruhane coina,” naain toni dedeeu. ");
INSERT INTO uraNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Naa dedeeu toniine jana: “Arara jecha,” naaure nii cuu neein aonajeeurera cachaauru. Nii jana tabaauru: “Cana Coaunera letonote aite,” naauruhane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","“Coatiha canu rai aitohi. Aonaquichene coinate inara rai aite. ");
INSERT INTO uraNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Inae chauratane curuaanaa Moconajaera aina jaoleneein neeururichaain inae Cana Coaunera coitucuuruhi. ");
INSERT INTO uraNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Inae ecuun coroso que nihanunena, satiin quesenetaaurera raa cureeunnicha,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Niritohane ainate, “Naaonjoaainte oha cureeincha,” naain coitucuure satiin cachaauru. Niritoha Jesosone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","“ ‘Onaachara nejeeinte nirijieein niha cureein Curisitora,’ naa canacaanu quiricha inoaesi cuhane natiin, chatohaneeina coroso que ecuun nere nii cachaneein nejanohanaa. Charijina nii cachaneein nejanohanaa ne,” naauruha Cana Coaunera Calaohi Jesoso rai jana: ");
INSERT INTO uraNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","“Canuna cacha cononeein neeun. Basijiin reintiariinne inara aina neeorihun. Quesenetaauche, inae inara ratirihanune, nocohenaanau nitajeeichene coataa. ");
INSERT INTO uraNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Cau jaiti nihanune cojoataa quesenetaauche, canu cachaneein neeichene coina,” naane baiha jianatoroaain acaauru caje naasi Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Itolere maosa rautaain, onaa ichateein, lenone faain, naojoaan acaauru notaracaae Jesoso natiinte, esenetaaurene Jorioocuru. ");
INSERT INTO uraNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Inae niritiin laenaain bihalu inoaelu Cana Coaunera Ere bera inoaesi Isaihasi najaunte, nii laconaa nainene: “Cha canacaanuhacha beebejei esenetaete curuaanaa,” naainte: “Chariji jana iicha ichai coaraain esenetaete curuaanaa” naain laenaelu Isaihasi. ");
INSERT INTO uraNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nii jaunte esenetana jerecurenihaluna jaun coaiteen laenaain: ");
INSERT INTO uraNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Jauriaa esenetana jerecurenihana jaun, inae acaauru suujua anioaan Cana Coaunerana jaunte, turuha Cana Coaunera Calaohine jana coitucuurene, nota que coaraain nesoone caaun enaraa coitucuuruhane coataa. Nitohaneeinte tenajae Cana Coaunera,” naainte ");
INSERT INTO uraNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","laenaelu Isaihasi inoaelu, cajiha cana rai chauratane que turuha uha Jesosone ajiniha. Ichoaichanihate nii coaraain caritiin laenaelu Isaihasi inoaelu. ");
INSERT INTO uraNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nii natiinte saain esenetaurenihane caniha, esenetaaure araijiriin. Cocoainanacaihuru tabaauru niha natiinte esenetaaure niqui. Nete chunei rai beeurene, nii ita taojiauruha najaan loreri sinacoca caje sitanajaa fariseeocurune coataa. ");
INSERT INTO uraNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Acaauru belaiha Cana Coaunerane rautaauruhane amuritoheriin acaauru belaiuruha acaauru araichurune jerecuruhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nii jaunte tonijiaain: “Quesenetaera, coatiha canuhacha esenetarinaain. Nii caletoaera Ofa niha natiinte esenetareein quesenetaera. ");
INSERT INTO uraNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Cacoharaerate nii caletoaera netonai coarae. ");
INSERT INTO uraNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Canuna caa chauratane cono neeun. Canuna caa chauratane que turuun, nabana nocohenaana niha quesenetaerane coataa. ");
INSERT INTO uraNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Quere tonoraeniha chuneine coatiha canu coulurujuerinaauni. Coatiha caa chauratane que nenacaauru coulurujueranu que uhaun. Jianacoon niha caa chauratane que nenacaauru cachaaurune coinana turuun. ");
INSERT INTO uraNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Chariji teeinti, ‘Caohachaaita,’ naain quere tonoraene. Niite coulurujiha cureein caa quicha beebejei Erenaa, inae saa cana janonaane bana, ");
INSERT INTO uraNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","casuujua caje rocohin aitenihanune jaun. Caletoaera Ofa aitoonjoaacha quena caa aitiin inara relaaun. ");
INSERT INTO uraNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ofate caletoae nitajenaachara nejeein niha canu ere esenetaain tonoraerane coina. Nii jaunna caletohane rijijieein, caa aitoon,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Le janojoeein lanajeeca Fasocoa besetane janate, inae Cana Inaca rene cauha cuhane catainaaecane coitucue Cana Coaunera Calaohi Jesoso. Itolere janonaa bana chauratane que nenacaauru cachaauru belaiha coichana aina cutaainna jaunte, esinae rauhijiriin belainaacane coitucuuruhane coina raajenihane netiha cureein. ");
INSERT INTO uraNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Nii jaunte aina nerelanaa nichaanune aina lenone Jesoso. Nii janate cuune canacaanu aina Simoon calaohi Jodasi Isacariote, suujua saruha Moconajaerana jaun Cana Coaunera Calaohi Jesoso coulurujueranu. Nii jana satiin curuaanaa neein tiha Cana Inaca Cana Coaunerane baiha, Cana Coaunera caje uhane coitucuhin, inae jelaiha cauha cuhane coitucue Cana Coaunera Calaohi Jesoso. Nii janane jaiti nitohaneein nerichaaine coitucuelanaala lenonejihacaanune jana, lenoneeo jiaaeriin, nobiri rocoriin, jaleri que faino balutaain, ");
INSERT INTO uraNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","baandeja cuhane acau chotaain, canacaanu tijia culejeein, nii rai faino que canacaanu tijia jacorae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nii baihate Simoon Fedoro tijia culeena jeriha Jesosone jana: “Iina catiha culeena jereeite curaanaa,” naa Fedorone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","“ ‘Naaonjoain coinate caa ichae,’ naain coitucuheei. Nii baihate coitucuriquiin,” naa Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Chaaelai janonaa bana nihei catiha culeequine jerichaaunne,” naa Fedorone jana: “Ii tijia culejenihanune, canu aina nenaa naineriheini,” naa Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Aihana jaun, coa catihacha culeeca, cacoii, cacoturi naaonjoaine maajeein culeecura Curuaanaa,” naa Simoon Fedorone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","“Enanejeein necaojoanaa, jitariin jaberocone maajeein culeera latiheei. Leinjiin rai tijia culeeraachate late, enanejeein necaojoane baiha niha natiin necalanoaaeca rai tijia najaun. Saainte niqui culeenohineein neeiche. Nete ne inara jana leinjiin jaiti ");
INSERT INTO uraNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","culeenojoinelanaala,” nae Jesoso, Jodasi Isacariote que, coulurujuerichaain Jodasi Isacariotene coitucuha najaun. ");
INSERT INTO uraNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Acaauru tijia culeecane baihate, nobiri curujuaain, coaiteen mesa choae nelauriaain: “ ‘Naaonjoaane jaunte caa cana tijia culeje,’ naain coitucuuche. ");
INSERT INTO uraNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Rauhijiriinte caque, ‘cacha relaera,’ naaiche. Chaen techu, ‘Curuaanaa,’ naaiche, rauhijiriin aca nichaaunna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Canu, inara relaeraneein, inara curuaanaa neein nihanu natiina, inara tijia culejeeun. Nirijieein inara suujua coaraain ita tijia culeequichenete caohachae. ");
INSERT INTO uraNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Charijieein teeinti aihun, nirijiein chabana necoasitaelanaala, raotojoeein ita belaain neeuche. ");
INSERT INTO uraNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Inara curuaanaa neein, inara relaera neein nihanu natiin, inara tijia culejeein nihanune jaun, jerichanejeein carijijieein satiin cachaauru belaain, inara suujua caje coauneein niha natiin, chaelai ichacuche, ‘Naaonjoaain nihanune jaun, naaonjoain ichana nainihaaun,’ nanaa coacuelanaala ichacuche. ");
INSERT INTO uraNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Inara suujua coaraain, ita coroataja neein, ita belaain, caa caitono aonaain tonoraaichenete, raotojoeein neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nete, caohachanainejeein satiin ena neeichene rijijieein nenereeicheein. Janijiina satiin inara raain neeunlu niqui. Nete, ‘Caniha nejeratereein leinjiin caniha lenonei,’ naalu Cana Quiricha Inoaesi cuhanene rijijieeinte, caniha nejeratereein leinjiin. ");
INSERT INTO uraNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jaiti aihei niqui, nena letonoha inara rai beeun, inae caque nejeratihane, Cana Coaunera Calaohi Curisito nichaaunne coitucuhichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Esinaena rauhijiriin aitoreeunni. Chunocoha quiicha letoai raanete, jerichanejeein canu raane rijijieein rareein. Nii canu raane rijijieein techu, caletoaera Ofa Cana Coaunera rareein,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nii janate: “Esinaena rauhijiriin aitoreeunni. Leinjiin inara caje cachate cacoluruheca cureein,” naain be Cana Coaunera Calaohi Jesoso. Niritiinte jataain inaderae Jesoso, coulurujuerichaain niicha belaaina jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nii janana, itaacha cajanacajanaain itaacha coaracaanu aina nerelanaa nichaanune, “Caa quete aite,” naain nii naitoonjoa coitucueniha caanune jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nii jana Jesoso roan neein lenonejianune jana, ");
INSERT INTO uraNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","canu cojoeluhin: “Chana icholuruherete, curuaanaa” naain caque bajaeratiha Simoon Fedorona jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jesoso roan naurutaain nuricho nainejeein metoroaain: “Charijina icholuruherete, curuaanaa,” naain bajaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","“Saan. Coarajeeujia. Obene que faan setejiariin tihanune jana raerate, aca nereein,” naain obene que faan setejiariin, Simoon calaohi Jodasi Isacariote rai te Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Obene que setejianohin faan raain quiha Jodasine rijieonritiinte, Jodasi suujua sarue Moconajaera, Cana Coaunera Calaohi Jesoso coulurujiane coina. Nii jaunte: “Letonoaneein, ena nii iicha ichana jerei ichaau,” nae Jesoso, Jodasi rai. ");
INSERT INTO uraNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nii janana, “Naaonjoain ichaane coinate aite,” naain coitucuenihacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nii jaunna, “Aca canacaanu coriqui beraicha nihana jaun jecha beseta rai chaelai inejei coretihane coina aite,” naacaanu. “Ainihane, cairichaihuru rai chaelai inejei coreteein tihane coina jecha aite,” naacaanu coitucuenihacaanune jaun. Nii janate aine. ");
INSERT INTO uraNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nii setejiariin Jesosohacha tei faan quihane baihate mituha cue, inae nocohecane jana Jodasi. ");
INSERT INTO uraNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Inae mituha cuha Jodasine janate: “Inae laaen caohatiin, rauhijiriin inaraacha cohajei Cacha Calaohi nichaaunne coitucuriquicheein, chaen techu canu aina cuaain, ‘Naaonjoaan Cana Coaunera’ naain Ofa coitucuriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Charijieein teeinti, aca neein niha Ofane coitucuerateeun inara que. Nii rijijieein techu, inara que canu neein nihanune coitucueratereein inae ena sorotiin Ofa Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Inae carajaain inara aina nerihaaunni canaanaihuru. Canu aririquicheein niqui. Nete, aitocoaaun Jorioocuru raine rijijieein, canu cunajaan cunaa naineneriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Inae ena nenaa caa erenaa bihanu inara rai, cacoichana aina cutaain inara belaihanune rijijieein jiniiquiin ita belaain neeichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Satiin chauratane que nenacaaurute, quiicha relaaurineeichene coitucuha cuurureein, jiniiquiin ita belaaichene coaracuruhane,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Niritoha Cana Coaunera Calaohi Jesosone jaun: “Chuna cureeite Curuaanaa,” naa Simoon Fedorone janate: “Cuhanune jaun jaiti casaauna nainihei. Nii baihate casaaureeini,” naa Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Chanuna ii sacunaa nainenereeunte curuaanaa. Nainichaaun ichoreniha ohanune,” naa Fedorone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","“Esinae chachu naineei cacoreniha ohine. Esinaena rauhijiriin ichei aitoreeunni. Iriha ataoharine ajinihate, nichata saain, ‘Jesoso cacha nihaunta,’ naa curiquiin,” nae Jesoso, Fedoro rai. ");
INSERT INTO uraNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Coa nererojoecaache. Cana Coaunera esenetaaichene rijijieein quesenetaauche. ");
INSERT INTO uraNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lanaai Ofa loreri asaae turunaa najaan cuu turuhin raotojoeein neeichene jaanu. Nenihane jananihane coatiha berihaun. Aihana jaunna, inara turunajaanu rucuheca cureeunni letonoa inara ajiniha. ");
INSERT INTO uraNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Inara nenajaanu rucuheca cuhanune baihana coaiteen ureeunni, inara raa tajiha caniha neeichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Inarate nii curichaunnine jaan coitucuhiche. Nii jaunte nii cuhanune jaun turuha cunaa nainiquiche tonajelanaala,” naa Cana Coaunera Calaohi Jesosone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","“Nii cuhina jaan coitucuhaacaanuta Curuaanaa. Inasiina coitucuhin urichaanuta,” naa Tomasine jana: ");
INSERT INTO uraNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","“Quere esenetaain tonoraaichenete, Cana Inaca rene turuhin aina ichaoriquicheein. Nete laaen cacolane turuenereein chunei, rauhijiriin ichaonaa rauhi tera nihanuna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Rauhijiriin cacoitucuhichenete, Ofa Cana Coaunera coitucuhiche. Inae laaen enene caje coauneein Ofa coitucuhiche, inae cacoharaichene jaun,” naa Cana Coaunera Calaohi Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","“Cana Inaca Cana Coaunera coarateeujian canacaanu quena, nii aina raotojoeein nihacaanune coinara Curuaanaa,” naa Ferifine janate: ");
INSERT INTO uraNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","“Inae carajaain inara aina nihanu. Ta jaiti cacoitucuhichenete, Ferifi. Cacoharaerate Cana Inaca coarae. Aihana jaun, chanuna Cana Inaca Cana Coaunera coaaratihanu inara quene jerequiche. Tajian, ‘Cacoharaerate Cana Inaca Cana Coaunera coarae,’ naanune aonaquichene. ");
INSERT INTO uraNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ta Ofa suujua que suujuaquiin nihanune coitucuhichene. Coatiha casuujua caje rocohin quiicha jerei que irihaaun. Acaihanejeein Ofaacha jerenohichana ichaaun, Ofa suujue que suujuequiin nihanune jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aihana jaaun Ofa suujue que suujuequiin nihanune esenetaeneeichene nihanatiin, itolere ichacaunne coaraquiche inara nota que najaun esenetaaichenete ne. ");
INSERT INTO uraNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Esinae rauhijiriine aitoreeunni. Quesenetaerate quiicha ichai ichareein camuritoheriin niha natiin, Ofa rene tacaain aina nerichaunina jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Cuu nihanune jana, cacurajateein chaelai inaraacha latei bajaaichenena, tiha cureeunni. Nitohaneeina Cana Inaca Cana Coaunera ichanohin coaaratiha cureeunni, Cana Inaca Cana Coaunera coitucuhin coroaequichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nii jaunna, chaelai bajaaichene tereeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Rauhijiriin esinae cacoelaichene, quere tonoraauche. ");
INSERT INTO uraNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nitohaneein neeichenena, Cana Inaca bajareeunni, inara Coroatajanera letoaane coina. Inoaelu netiin chabana satonoe lanaalate inara aina niha cureein inara Coroatajanera. ");
INSERT INTO uraNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Acate, esinae Cana Coaunera Suujue nereein. Nii Cana Coaunera Suujue coitucunaa nainecuruhi cacoitucuuruhi. Inarate laaen, raotojoeein coitucuhiche inara aina nihana jaun. Inoaelu netiinte, chabana satonoe lanaala inara aina niha cureein. ");
INSERT INTO uraNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Coatiha inara jaohin, inara ratiriha cainerinaain. Turuhana ureeunni, coaiteen inara aina nihanune coina. ");
INSERT INTO uraNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Inae cacoharaaururinaain quesenetaaichuru. Inaraachate laaen cacoharaa curiquicheein, inae coaiteen turuhanune. Ohanune caje ichanarihanuhina jaunte, jerichanejeein nitajenaachara nejeein niha curiquicheein, ichaohin nihanune rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Inae inara suujua cuhane enoha Cana Coaunera Suujuenete, Cana Inaca aina nihanune coitucuhin, canu aina neeichene coitucuhin, coitucuha curiquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Quere tonoraain neite, esinae rauhijiriin cacoelaicha nereein. Niite belaiha cureein Cana Inaca Cana Coaunera. Canu netonainiha natiinna inara belaain, inara que necoharaeratereeunni, raotojoeein rauhijiriin cacoitucuhichene coina,” naa Cana Coaunera Calaohi Jesoso canacaanu raina jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","“Chanuna canacaanuhacha rai ecocohin, leeochaauru que necoharaeratenereeite Curuaanaa,” naa nii leeocha Jodasine jana: ");
INSERT INTO uraNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","“Cacoelaichate quere tonorae. Niite belaiha cureein Ofa Cana Coaunera. Chaenna aina jiniiquiin Ofa aina niha cureeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Cacoelaiheite, caa quiicha beebejei esenetaene. Caa inara rai quiicha beebejei inaraacha aonajeite caletoaera- Ofa Cana Coaunera ere ne. ");
INSERT INTO uraNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Cau inara aina nihanune cojoataana, caritiin inara rai beebejeeun. ");
INSERT INTO uraNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Chaaen, Cana Inaca rene cuhanunete, cacoreniha Suujue letoareein Ofa Cana Inaca, inara suujua lararajiaain, inara suujuateein, inara coroatajanihane coina. Acate itolere que inara relareein, itolere caitoojoan que coauquichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Raotojoeeinna inara rai necoeeun. Canuhachana, Cana Coaunera tenojoin- raotojoeein neeichene jaannu teeun. Nerinaain cabaiha nii rijijieein raotojoein neeichene jaannu teraanu. Aihana jaun, chaque casilanaala, raotojoeein neeuche. ");
INSERT INTO uraNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Esinae rauhijiriin besichaaunlune rijijieeina, cau niha ureeunni coaiteen. Esinae cacoelaaichenete rachoojoeein neriquicheein. Nii caletoaera Ofa renene cureeunni, jelai choaae jauhecotojoeriin inara coroatajanihane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Amuhanune ajinihana aitoon, inae ichacaaunne, ‘Esinaete aitelu,’ naain esenetaaichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Inae nenacaaeneein inara rai ereerejerinaaunni, inae urichaain canu coitucuuruhi cachaauru letoaeranu Moconajaerane jaun. Canu jerenihanune, caniha cha chana nainerihei. ");
INSERT INTO uraNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nena, inauhene coarajereeunni, caletoaera Ofa belaain nere tonoraanune coaracuruha satiine coina. Chajaauchete amuhacache. Inae jitariin bihanu inara rai, coitucuhichene coina,” naainte canacaanu amaain amue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","2","Nii baihate aina nerelanaa nichaanune rai: “Canuna lenacai oba esine rijijieein neeun. Charijieein teeinti, lenacai oba une beraihaca, ajaanaa naineein. Caohatiin anasitiin inaana nuune cataaun uhajeein sauhin jaohaca, caohatiin nujua cutujuaain inaacane coina. Jana inacaeniha le unene, temura nainejeein tacaain sauhin jaohaca. Nii rijijieein techu, cacoitucue lanaala, suujua coaraelanaala, rai suujua letonohacha ichara, naaonjoain jaoha cureein moconajaera rene Ofa Cana Coaunera. Jana quere tonoraain canuhacha icharatei icharate, jeelai amuritoheriin suujua lararajiaain coroatajanereein Ofa Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Inara relaanune jaan Ofa Cana Coaunera aitoojoan esenetaain, tonoraain neeichene jaunte, inae inara suujua culeje Cana Coaunera, jianacoo neeichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","5","Coanete jiniiquiin Ofa Cana Coaunera jerenohin ichacaache. Ainihane, jelai chujutoroaain cacolane ichana naineriheeiche. Charijieein teeinti, nujua caje nebeuha lenacai oba unene, ojoiin inae inaana nainene. Nii rijijieein techu cacolane, jelai caohachaain Ofa Cana Coaunera jerenohi ichana naineneriquiche. Jana, jiniiquin canu aina ichaquichenete laaen esinae Ofa Cana Coaunera jerenohi ichariquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Chunocoha inara tabanejei, quere tonoraane jianihanete, nitajiha cureein cahoachanainejeein, Moconajaera rene jaorichaain Ofa Cana Coaunerana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Esinae rauhijiriin quere tonoraain neeichene, jiaonriha inara relaanune jaan baitiquichene. Chaelai inaraacha latei bajaaichenete, tereein Ofa Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nere tonoraain, naitoojoan beebejeeiche cachaauru rainete, inara coaraain, Ofa Cana Coaunera coroaeca cuurureein inara coaaraauru. Nii banate esinae rauhijiriin quere tonoraera neein neriquicheein. ");
INSERT INTO uraNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Cacoelaiha Ofa Cana Coaunerane rijijieeina inara belaihun. Caa inara belaihanune rijijieein, inara suujua coaraain cacha belaain neeuche. ");
INSERT INTO uraNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Caa caitoonjoan tonoraain ichaain neeichenena, itolere bana inara belaicheeunni. Charijieein teeinti caletoaa Ofa Cana Coaunerana jaan tonoraain ichaain nihanune jaun, canu belaain ne, nii rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Itolereneein raotojoeein rachoojoeein canu aina jiniiquiin neeichene coinana aitoon. ");
INSERT INTO uraNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Caa inara belaain nihanune rijijieein, ita belaain neeuche. Nitohaneein neeuche, caa inara rai aitocoaunne rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nainihei chatohanai, onaa niha natiin coasiin nihacane. Cana belaichaauru coreniha cana raaje netiha cuhacanetejian, nenacaaen caohachae, ichaohin neeuruha canaacha belaihurine jerena caaun. ");
INSERT INTO uraNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Inarate quiicha belaiineein neriquicheein, caa inara letoaanune jaan ichaain neeichene. ");
INSERT INTO uraNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","‘Canu cachaauru,’ narihaunni. Rauhijiriichana, ‘Canu belaichaauru,’ nareeunni. Chabana, ‘Naaonjoainte ichae,’ naain curuaanaacha ichai coitucuhin neniha cachana jaun. Nii jaunna, ‘Canu belaichaauru,’ naaun inara que. Carai aitiin caletoaa Ofa najaan coitucueratihanu inara quena jaun, nainihaun canu, ‘Canu cachaauru,’ naain irihanu inara quene. ");
INSERT INTO uraNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Coatiha inara, cariin carene uhin niheeichelu. Canuna inara ariin inara raain neeunlu. Nii jaunna Ofa Cana Coaunera rai arajiin cacha ariin raeraanu que inara letoaaun, inoaelu netiin neeneinu que. Nitohaneein neeichenete, chaelai latequichene, bajaaiche cacorenihane, tiha cureein Ofa Cana Coaunera,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nii baihate: “Aonacuchena caa que aite, raotojoeein jiniiquiin ita belaain neeuche. ");
INSERT INTO uraNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Inara coaana jerelanaala, inara belaihureniha caa chauratane que nenacaaurune, nii caje nainaauche, nenacaaen canu nichaun natiinte, cacoharanaa jerelanaala cacoelaihurene. Nii jaunte jelai amuritoheriin inara belaihurenereein. ");
INSERT INTO uraNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Chauratane que nenaa cacha neneeichena jaunte, inara belaain, inara coaana nainecurenereein caa chauratane que nenacaauru cachaauru. Canuna caa chauratane que nenacaauru caje inara raaunlu. Nii jaunte inara belaain inara coaana nainecurene caa chauratane que nenacaauru cachaauru, inae caa chauratane que nenaa cacha neneeichene jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aitocoaaunlune tocohaneein, nihei chunei rai curuaanaa amurijiriin nei. Nenacaen canu rerohecauruhaluna jaunte, jerichanejeein inara rerohecaa cuurureein. Quere esenetaain tonoraeraurute, jerichanejeein inara ere tonoraain esenetaaurureein. ");
INSERT INTO uraNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nitohanihate, cuurureein nii caletoaera coitucuuruhi nechu aansaineein nenacaauru cachaauru. Nitohanihate cuurureein, canu ere beebejeichene coreniha. ");
INSERT INTO uraNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Acaauru rene turuhin, acaauru relaenihanune jana nihane, chaelai ujuaihoneein neeururihei niqui. Nete inae enene acaauru osa coreniha chunijiun nichoteeurenereein. ");
INSERT INTO uraNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nii cacoharanaa jerelanaala quere tonoraichurute, jerichanejeein nii caletoaera Ofa Cana Coaunera ere tonoraaurene. ");
INSERT INTO uraNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Itolere, lenone faain, itolere cunaitenacaauru rautaain, itolere ichaain acaauru notajaain, naaonjoaain inatiinte, coaracuruha nota que natiin, canu batohin, Ofa Cana Coaunerane maajeein batohin neeuruhane corenihate caseteco coaraa cuurureein. Nii coaracuruha natiin esenetaaurenihane colane aihururihei. ");
INSERT INTO uraNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aitoha acaauru quiricha inoaesi cuhanene rijijieeinte, aihure. ‘Nechu jataain, joaereein corenihate aina nejerateein jerecurenereein,’ naain aitoha acaauru quiricha inoaesi cuhanene rijijieeinte aihure, inae nitohanihane coina laenanohineein nihana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Inae turuha urichaain inara coroatajaneraanu. Canuna Ofa caje letoareeunni. Nii inara coroatajaneraanu- Cana Coaunera Suujuete esinae rauhijiriin caitoojoan que inara relaa ureein. ");
INSERT INTO uraNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nii ainate chaque casilanaala laraajiin canu aitoonjoan Cana Coaunera ere beebejeriquicheein cachaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nii jaunna inara rai aitoon, inara rerohecaauruhane, nererojoecaain inara letoaanune jaan jianeeichene coataana, caa caritiin aitoon inara rai, laraajiin abaantaain neeichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Acaauru ita taojiaauruhana jaan loreri asaae enohichene janate, caje inara sitaa cuurureein. Chaaente, chunicoha inara tabanejei sohin jaooruhane, ‘Jeriha Cana Coaunerana jaunne, caa ichaaun,’ naa cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nii chabana Ofa coitucuelanaala, canu nihanatiin coitucuurenihana jaunte, nitohanain ichaa cuurureein. ");
INSERT INTO uraNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Inae cuutihane bana, ‘Esinaete aitelu,’ naaichene coinana caa aitoon. Jaiti jelai inara ratirihanune rai nenihanune jaunna, jauriaa caa que inara rai erenajaqueneeun. ");
INSERT INTO uraNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Inae laaen curichaaunni nii caletoaera aina nihanune coina. Nihei chunicohanejein nii cunaa jerichaaunna jaan bajaane que airijiin, ");
INSERT INTO uraNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","satiin inaderaachaquiche caa que aitocoaunna jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Inara rai tejian caohachare cuhanune. Jana cuenihanune, urihei inara corianeein inara suujua lararajiaain, inara coroatajaneraaunu. Acate inara suujua lararajiaain, inara corihaneein inara coroatajanereein. Inae cuhanunena, canu letoareeunni. ");
INSERT INTO uraNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aca inae turuhanete, cacha relaa cureein, osaaocuruhane coitucuuruha cachaaurune coina. Chaaen techu, caohati ichaonaa que cacha relaa aicheein. Jana ichaonaa caoacha sacunaa jeriheichurute, casetecaa cureein Cana Coaunera, ");
INSERT INTO uraNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","osaaocuruhane saijieein quesenetaaurenihane coreniha. ");
INSERT INTO uraNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nii banate, esinaae rauhijiriin ichaonaa esine teraneein nihanune coitucuha cuurureein, Ofa nenajaun tacaa curichaaunnine jaun. Inae canu coaariheicheein cuutihane reeintiaain. ");
INSERT INTO uraNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nii banate, Moconajaera aina jiniiquiin nosa coreniha caseteco coaraa cuururichaaine coitucuha cuurureein cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Niha arajiin inara rai quiicha beeni niqui, nete ‘Quete toon aite,’ naain coitucunaa naineneriquiche. ");
INSERT INTO uraNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Inae turuha Cana Coaunera Suujuenete, rauhijiriin inara relaa cureein. Coatiha suujua caje rocohin aitoriaain. Aitoha Cana Coaunera najaan quete aitoha cureein, nitohaneein situsihane ajiniha coitucuhin neeichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Acate coroajeein canu nichaaunne biha cureein, cacoitucuhin neeichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Charijieein teeinti, itolere coauneraneein ne Cana Inaca. Niirijijieein inachu canu netonai neeun, Cana Inaca calaohi nichaaunne. Aihana jaun, coaa cojoaelatohache canu coitucueratiha Ofa Suujuene. ");
INSERT INTO uraNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Satonoote, caa basiijiin cacoharaa curiquicheein. Nii baihajirite canu coaraa curiquicheein coaiteen,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nii jaunte ita caje: “Tonaa nena, ‘Satonoote cacoharaririquicheein, Cana Inaca rene curichaaunnine jaun. Nii baihajirite cacoharaa curiquicheein,’ nae. ");
INSERT INTO uraNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Chatonaa nena aite,” naacaanu ita rai. ");
INSERT INTO uraNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nii jaunte, caje bajanaa jerichaanune coarajihane jaun: “ ‘Satonoote basiijiin cacoharaririquicheein. Nii baihajirite cacoharareeicheein,’ naanune jaunna ita caje bajaaiche. ");
INSERT INTO uraNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Esinaena rauhijiriin aitoreeunni. Inaderanaa caaunte chanaa curiquicheein. Nii janate inara coroaaeca cuurureein caa chauratane que nenacaauru cachaauru. Nete rachoojoenaaneein necoriha cureein inara suujua. ");
INSERT INTO uraNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Charijieein teeinti, nejanoana jeriha rai canaanaine nererojoecaaure enecuru cunaa caaun. Jana inae lesajeein nejanoaane, inae nii cuna coacuelanaala raotojoeein rachoojoeein ne, nii canaanai coroaaeca. ");
INSERT INTO uraNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nii rijijieeinte nererojecaaiche niqui ena. Nete, turuhin inara coaraa uhanune, aitohi rijitojoeein rachoojoenaa neein niha cureein inara suujua cuhanai. Nihei chunei inara caje nii rulunaa nainera. ");
INSERT INTO uraNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nii bana inae cacaje, ‘Chatohanein icharihacaanu,’ naain cacaje cha bajariheicheein, inara netonai coitucuriquicheeina jaun. Chaaelai inaraacha latei bajaaiche cacorenihanete, tiha cureein Cana Inaca. ");
INSERT INTO uraNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nihei caniha neeichene caje coaauneein, cacoreniha chaaelai bajaheeiche. Bajaaiche cacorenihanete, tiha cureein Cana Inaca, raotojoeein rachoojoeein neeichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Inae cuutihane bana caritiin, ‘Charijieein teeinti naojoaen,’ naain cuaain, inara rai berihaaunni. Inae cuu tihane banane, nechu jataain rauhijiriincha cuaain Cana Inaca aitoojoan que inara relareeunni, rauhijiriin aonaain coitucuichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nii banate, inara raaje inaraacha latei bajaa curiquicheein. Nitohanihane bana, coatiha canu Cana Inaca rai aitorihaunni, ");
INSERT INTO uraNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","inae raujiaain caje uhanune esenetaaichene coreniha inara belaiha Cana Coaunerana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Canuna, Cana Inaca nenaja caje mituhin, caa chauratane que turuha uun. Inae caa chauratane ratiriin, Ofa Cana Inaca Cana Coaunera rene curichaaunni,” naa Cana Coaunera Calaohi Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","“Inae laaen aonacaaun rauhijiriin aitohina jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nii jaunna esinae itolere coitucuhin, esinae rauhijiriin Cana Coaunera caje uhine esenetacaanu. Aihana jaun, nihei nenacaaen canacaanuhacha bajaaenenu, inae coitucuhacaanuna jaun,” naacaanune jana: ");
INSERT INTO uraNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","“Nii jaunchana esenetaaiche. ");
INSERT INTO uraNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Inae cojoinaca que tiha. Enenete satiin ita caje riatoroaain, jelai cajaohin caratiriin amuriquicheein, nena jelai caa neneeun, caniha niha Ofa Cana Coaunerana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Coitucuhichene jerena caunna caa aitoon, quesenetaain raotojoeein rachoojoeein neeichene coina. Chaaen inara netonai, caa chauratane que necairichanaa coaraa curiquicheeina jaunna, raotojoeein rachoojoeein necairichanaa abaantaichene coinana aitoon. Caa chauratane curuaanaa Moconajaera amuritohanune jaun, inara netonai laraajiin caa chauratane curuaanaa Moconajaera amuritohichene coinana, coitucuhichene jerena caaun aitoon,” nae Cana Coaunera Calaohi Jesoso, aina nerelanaa nichaanune rai. ");
INSERT INTO uraNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Niritohane baihate, jabatoroaain dede coarajeein: “Inae caletoaina jaan ichacaaunne jaan cojoanonaa que turuha. Chajaain laaen cacorataaneeu, ii jerenohi ichacaaunne coina. ");
INSERT INTO uraNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Iite ii calaohineein nihanune cocoainaain, caa chauratane que caletoaai, satiin carai iicha teeuri cachaauru rai nitajenaachara nejeein nenaa ichaonaa teraaunu que. ");
INSERT INTO uraNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Leinjiin iichate nitajenaachara nejeein nenaa ichaonaa teraneei. Nii jana canuna, leinjiin ii letono Jesocurisitoneein neeun. Nii jaunte nitajenaachara nejeein neeurureein cana coitucuhin nenacaauru. Coatiha chabana nitajeeururinaain. ");
INSERT INTO uraNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inae caa chauratane que nenacaauru que ii coitucueratihanu. Chaaen nachu inae caletoaaina jaan nainaaun. ");
INSERT INTO uraNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Inoaenlu, jaiti necoaunaeniha caa chauratanene ajiniha, cocoainanacaineein nihanulune rijijieein, ii rene turuhanune, coaiteen cocoainanacaineein caeteeu, coaracuruha satiine coinara Ofa. ");
INSERT INTO uraNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Inae caa chauratane caje raain carai iicha tenojoinhuru cachaauru que ii neeine coitucueratihanu. Icheineeinte neeure, caa carai iicha teeuri cachaauru. Niichurute, chere aonaain tonoraain neeure. ");
INSERT INTO uraNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Inae laaen cacorataaneei jaan aina caletoai jaan ichacaaunne jaunte coaraain inae esenetaaure. ");
INSERT INTO uraNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Caletoaaina jaan que acaauru rai aitocoaaunna jaunte tonoraaure, carai iicha tenojoihuru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Coatiha caa chauratane que nenacaauru cachaauru, ii coitucuuruhi coroatajaneeine coina ii bajahaun. Caa carai iicha teeuri cachaauru icheineein nenacaauru coroatajaneeine coinana, canu Inaca neeine bajaaun. ");
INSERT INTO uraNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Satiin canu cachaneein nenacaaurute, jerichanejeein ii cachaneein neeure. Jerichanejeein techu, canu cachaneein neeure ii cachaauru. Nii jaunte jerichanejeein aihanune rijijieein ichaoore. ");
INSERT INTO uraNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Inae taenetojoeein caa chauratane que nerihaunni. Acaaurute jana jaiti caa chauratane que nedaa cuurureein. Canuna laaen inae ureeunni, ii aina nihanune coina. Ofa, carai caa iicha tenojoihuru cachaauru coroatajaneeu iicha jerei chana que. Charijieein teeinti canu coroatajaneein canu rai iicha tei ichana que, nii rijijieein acaauru coroatajaneeu. ");
INSERT INTO uraNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Enanetojoeein cacorataaneeine que, caa carai iicha tenojoihuru cachaauru nihei leinjiinejei nitajihei. Leinjiin caa, ii quiricha inoaesi cuhane beein laenaerateeilune rijijieein cacoluruheraachate, inae nitaje. ");
INSERT INTO uraNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Inae laaen enene, nii neeina jaaun urichaaunni iniha nihanune coina. Jaiti caa chauratane que nihanune cojoataana aitoon, raotojoeein rachoojoeein nihanune rijijieein, acaauru netonai canu rijijieein raotojoeein rachoojoeein neeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ii ere bihanu acaauru raine jana, esenetaain tonorauruhana jaunte, acaauru belaain, acaauru rautaain, acaauru coana nainecurene ii coitucuuruhi, aihanune rijijieei, inae caa chauratane que nenaa cachaneein neeurenihana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ofa Cana Coaunera, coatiha ena, caa chauratane caje ranajaain dedeeu amanajaaine coina caitono nihei. Acaauru que Moconajaera janoriteein, acaauru coroatajaneeine jerena caunna aitoon. ");
INSERT INTO uraNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Moconajaera cachaneein nenihanune rijijieein, carijijieein acaauru netonai inae Moconajaera cachaneein neeuruhi. ");
INSERT INTO uraNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ii raihuruneein neeuruhana jaunna aitoon, acaauru suujua rucujueein, acaauru coroatajaneeute, nejelau suujua cuaelanaala leinjiin ii jerenohicha ichacurumii. Ii erete esinaae rauhijiriin ichaonaa caohacha teraneein ne. Chaelai janonaa bana nihei nitajiha ii ere esenetaain tonoraain nenacaaurune. ");
INSERT INTO uraNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Charijieein teeinti, casuujua lararajiaain canu cocoainaain caletoaai, nii rijijieeina acaauru cocoainaain acaauru letoaaun, ii ere beebejiha cuuruha caa chauratane que nenacaauru raine coina. ");
INSERT INTO uraNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Acaauru corenihana nejelau casuujua cuaelanaala caletoaina jaancha ichaaun caraajenihane, acaauru netonai aihanune rijijieein nejelau suujua cuaelanaala relanajaanune rijijieein letoanajaanune jaancha ichacuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Coatiha acaauruhacha coroatajaneeine coina caitono nihei. Canu ere beebejeeuruhane, canu esenetaaichuru suujua rucujueein coroatajaneeute, ");
INSERT INTO uraNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","jiniiquiin aihacane rijijieein, ita aina jiniiquiin raotojoeein neein, nejelau suujua cuaelanaala ita coroatajaneein, neeuruhinete, esinaae ii caletoaine esenetaauruhine caa chauratane que nenacaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jeelai, nii canu cocoainaain neeina jaana teeun acaauru rai, ita neein nihacane rijijieein, acaauru netonai ita neein neeuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Chaaen nachu, casuujua cuhane neeine rijijieein, acaauru suujua cuhane neeun, jeelai ita neein neeuruhane coina, nii caje nainaain esinaae ii caletoaaine coitucuuruha caa chauratane que nenacaaurune coina. Aihute, cacoelaaine rijijieein, belainaaquine coitucuuruhine. ");
INSERT INTO uraNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Carai tenajaaina jaunna, caniha nii nerichaunnine jaun caniha neeuruhane jereeun, nii ii necaohacha aina canu necaohacha coarajeein neeuruhane coina. Chaaen necoaunaa caa chauratanene ajiniha caje coauneein cacoelaaine coaracuruhane coinara Ofa,” naain te, ");
INSERT INTO uraNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Rauhijiriin itolere coaunera Ofa neeine coitucuuruhi caa chauratane que nenacaauru niqui. Nena laaen canu ichoitucuun. Caa carai iicha teeurite laaen, esinaae ii caletoaaine coitucuure, ");
INSERT INTO uraNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","esinaae ii neeine coitucueratihanune jaun. Jelai choaae jauhecotojoeriine, ii coitucueratihajeein sacureeunni, esinaae cacoelaaine rijijieein acaauru belaaine coitucuuruhane coina, canu netonai nihanatiin acaauru aina nihanune coitucuuruhane coina,” naainte Cana Inaca Cana Coaunera bajaaebajaje Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cana Inaca aina irihane baihate, aina nerelanaa nichaanune amaain, Sedroon neein curuajaain nenaa nucuesoro jera que cue Cana Coaunera Calaohi Jesoso, cuu nii enuha inaa necojoai turuha canacaanu ainane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nii jaunte raotojoeein Jesoso cunajaa coitucuhana jaun, canacaanu caaijie turuha uhe Jodasi. Belaichaneein niha Jesoso natiin, Jesoso coulurujueein soondarooru uhaain turuha uhe. ");
INSERT INTO uraNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nii soondarooru, chaaen batirichuru curuaanaacuru, fariseoocuru, naaonjoainuri letono folisiaacuru uhaain turuha uhe nii Jodasi. Rejoon, sabere rijijieein nenaa- esefara, naaonjoain que biji achunequiin, raafariin, cohinee, naaonjoain que conoquiin turuha uure. ");
INSERT INTO uraNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nii jaunte inae raotojoeein nitohanai que siturichaainne coitucuhana jaun, acaauru que tacaain: “Chate ariicheta,” naain bajaa Cana Coaunera Calaohi Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","“Nasarete cocoaicha Jesosona arihacaanura,” naauruhane jana: “Saan. Canune aca neeunra,” naa acaauru rai Jesosone janate, nii niicha uhauri soondarooru aina jiniiquiin janori nichaae richootoroalaain tocojoaai tacae nii Jesoso coulurujuera Jodasi. ");
INSERT INTO uraNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nii jaunte: “Chate esinaae ariicheta,” naain coaiteen enacoauneein bajaa acaauru caje Jesosone jana: “Nasarete cocoaicha Jesosona arihacaanura,” naauruhane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Inae rauhijiriin bihanu inara rai. Canuna aca neeun. Cariha aaichene, caa caniha nenacaauru jianecuchete amuuruhine,” nae acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“Coatiha leinjiinejein nitajerinaain carai Ofa tenojoinunri cachaauru,” naain inae aitosiha Cana Coaunera Calaohi Jesosone jaunte nitohane. ");
INSERT INTO uraNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nii janate sabere sirihana jaun rocohitiin, que leinjiin uricho raotono nichajai beuhite Fedoro. Nii niicha uricho beuhitite batirichuru curuaanaa cachaneein nenaa- Malco ne. ");
INSERT INTO uraNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nii jaunte: “Jelaiha curu cuhane nii ishabere teeura. Ta caletoaa Ofana jaan icharichaunnine coitucuhin quesenetaaineta,” nae Fedoro rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nii jaunte Cana Coaunera Calaohi Jesoso mucuure caseteconeein soondadooru acaauru curuaanaa aina uhin, chaaen Jorioocuru rai folisiaacuru, naaonjoahunri. ");
INSERT INTO uraNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nitohaneein mucuhinte Cana Coaunera Calaohi Jesoso amaaure soondarooru, Anasi loreri asaae. (Nii Anasite, Caifasi tanaa ne.) Nii janate, nii ajaanaa cuhane batirichuru curuaanaaneein ne nii Caifasi. ");
INSERT INTO uraNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nii Caifasite, jauriaa Jorioocuru rai “Cana caohachanu quetejian, cana atane coreniha ohane ore leinjiin cachara,” naain Jorioocuru rai erenaane. ");
INSERT INTO uraNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Canacaanuna, Simoon Fedoro aina Jesoso sacuha cuhacaanu. Nii jana, canu coitucuha batirichuru curuaanaa jaunna, Jesoso jiniichaain enoon batirichuru curuaanaa loreri asaae. ");
INSERT INTO uraNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Jana Fedorote nedae airiniha acuujua rohan. Nii jaunna, acuujua beraicha ranuna rai ereeun, Fedoro enoaane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nii jaunte Fedoro enoaain: “Tana taa cacha aina nerelanaaneeine,” naain bajaa Fedoro caje nii acuujua beraichane jana: “Acanihahaunta,” naain benaa jerene Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nii jaunte, jelarotohana jaun usi mocohin que nichaateeuruha Anasi cachaauru, Jorioocuru rai folisiaacuru, naaonjoainurine jaun acaauru aina nichaatiha ne Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nii jana, cuu nii loreri asaae ucuha cuhane niha Cana Coaunera Calaohi Jesosone janate: “Chaauru caa iicha relaaurineein ne. Chaquete acaauru relaaita,” naain bajaa Jesoso caje batirichuru curuaanaane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","“Satiin aonajeeuruha cachaaurune acatiha teeinna canu, rauhijiriin aitonajacoon. Coatiha asinojoineein cachaauru relahaun. Sinacoca asaae, satiin itataojiauruha Jorioocuruna jaan Teenforo asaaene acaauru relanajacoon. ");
INSERT INTO uraNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chanuna nii bajaai cacaje. Nii relanajaanune jana aonaraauru caje bajaaute, raajenihane acaauru relaanune jaan beeuruhine,” nae Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Niritoha Jesosone janate, ecu niha Teenforo rai folisiaana jaun: “Niritiina erereei batirichuru curuaanaa rai te,” naain Cana Coaunera Calaohi Jesoso meri faohitohane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","“Baaso neeinoona aitoon. Chanuna caque ichohi teein aitohi,” nae Cana Coaunera Calaohi Jesoso nii Teenforo rai folisiaa rai. ");
INSERT INTO uraNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","25","Nii batirichuru curuaanaa Caifasi loreri asaae niha Jesosone tonohanaute, jelai cuu inae neeoriha Fedorone jana: “Ta ii taa cacha aina nerelanaa neeine,” naain bajauruhane jana: “Acanihahaunta,” naain benaa jereniha Fedorone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","“Tana, ii coaracaaunlu aina, enuha inaa neeonjoai jana neeine jananeta,” naain bajaa leinjiin batirichuru curuaanaa cacha- nii niicha uricho beuhiti cacha araineein nenaane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","“Acanihahaunta,” naain nesuujiha coaiteen Fedorone jana, inae ere ataohari. ");
INSERT INTO uraNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nii janate Caifasi loreri caje coberenadoro Filato loreri asaae Cana Coaunera Calaohi Jesoso amaauruhane jana, inae nemataracajiha janonaana jaun, enonaa nainecurene Jorioocuru, coberenadoro loreri asaae. Jorioo neniha nii coberenadorona jaunte, coberenadoro loreri asaae enonaa nainecurene Jorioocuru, enooruhane Fasocoa beseta bitoanaa nainecurenihane coataa. ");
INSERT INTO uraNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nii jaunte airiniha mituhin: “Chatohanai ichaane corenihana caa cacha colurujueeiche,” naain bajaa coberenadoro Filato, Jorioocuru cajene jana: ");
INSERT INTO uraNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“Nechu aansai taebinaen neein nenihanenoona, ichei colurujuerichaanu,” naauruha Jorioocurune jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","“Saan. Aihachuhisi niqui. Inara, amaain jeriquichene tocohaneein teeuche,” naa Filato, Jorioocuru raina jaunte: “Nihei canacaanu rai rauhi, chunei sohin jaohacaanune coinata,” naaure Jorioocuru Filato rai. ");
INSERT INTO uraNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Rauhijiriin coitucuhin, “Naaonjoaainte catinaa cuurureeincha,” naa Cana Coaunera Calaohi Jesosone rijijieeinte, rauhijiriin ichacure. ");
INSERT INTO uraNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nii jaunte coaiteen enacoauneein loreri asaae Jesoso cotijiain, caje bajae Filato: “Ii ina Jorioocuru curuaanaa rey neei,” naain bajaa caje Filatone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","“Ishuujua cuhane aitiina bajaai. Ainihane leochaauruna ichei Jorioocuru curuaanaa nihanune que aitoha,” naa Filato rai Jesosone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","“Chasiinna Jorionichaaunne coalanaala caraajenihane aitiin aitoreeun. Charaaichuru, batirichuru curuaanaacurute carai icholurujue. Chatohanai najian ichaaite icholuruhecure,” naa Filatone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","“Coatiha cajiha caa chauratane que nenacaauru curuaanaa nihaaunta. Caa chauratane que nenacaauru curuaanaa nihanunetera, sonaacurure quere tonoraeraauru, catohaneein caetecuruha Jorioocurune coataa,” naa Jesosone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Aihana jaun, iina curuaanaa rey neeite,” naa Filatone janate: “Ejeen, aca nichaaun. Nii aitohine rijijieeine acaneeun. Canuna caa chauratane que uhin nejanoaaunlu- cachaneein, esinae Cana Coauneraacha jerei rauhi coitucuuruha cachaaurune coina. Satiin Cana Coauneraacha jerei rauhi tonoraaurerate quere tonorae,” naa Jesosone jaunte: ");
INSERT INTO uraNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Chatohanai Cana Coauneraacha jerei rauhi esinena,” naain bajaa Filato, Jesoso cajene baihate, enacoaauneein coaiteen mituhin Jorioocuru aina iriha cue. “Coatiha chatohanai ichaai carai caa cachata. ");
INSERT INTO uraNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Inarate, Fasocoa beseta naineei, Fasocoa beseta catainajeein, naaonjoaain niha catohanai casetecone, nii beseta situ reeintiaain jianerate najaaoquiche. Tonaquiche, jerecuchene caa Jorioocuru curuaanaa rey jiane beseta situ reeintiaain,” naa Filato, Jorioocuru raine janate: ");
INSERT INTO uraNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","“Aihei. Coa nii jianiha. Nii Barabasi jianeeujian laaen,” naainte nujuaae soaisoaihure Jorioocuru, Filato rai, nii Barabasi asijiautoneein nenaa que. ");
INSERT INTO uraNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nii jaunte Cana Coaunera Calaohi Jesoso bisichate rai soondarooru que Filato. ");
INSERT INTO uraNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nitohaneein bisihuruhane baihate, ojoa caje janojoin comai curuhacure Jesoso couturi que. Nii baihate coaiteen que cajione lanaajiojoai curuhacure. ");
INSERT INTO uraNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nitohaneein teeuruhane baihate, Jesoso rohan turuhin: “Caa Jorioocuru curuaanaa rey coaracuchera,” naain Jesoso meri faohafacoaaure biji que Romanocuru rai soondarooru. ");
INSERT INTO uraNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nii janate jelai caje mituhin Jorioocuru rai: “Coaraquichene coinana caa cacha mitaa uun, neniha que chatoanai baaso ichaenihane coaracaunna jaun,” nae Filato. ");
INSERT INTO uraNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nii jaunte, inae ojoa que jerichanejeein comaiquiin, lanaajiojoai que cajionequiin mituha uhe Jesoso. Mituha uha Jesosone janate: “Caa cacha coaracuchera,” nae Filato. ");
INSERT INTO uraNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Niritoha Filatone jaunte, Jesoso coaraain: “Coroso que teeuche. Coroso que teeuchera,” naain nujuae soaisoaiuruha batirichuru curaanaacuru, folisiacuru naaonjoainurina jaun: “Inara amaain coroso que teeuche. Neniha carai que chana jaunna, nitohaneein tenaa naineneeun canu,” naa Filatone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","“Canacaanu quiricha inoaesi cuhanete aite, nitohaneein nei nihane sohin jaohacaanune coina. Cana Coaunera Calaohi niha nocoetohane corenihate caohachae, sohin jaohacane,” naauruha Jorioocurune ");
INSERT INTO uraNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","aonajihane jaunte, jataain casi Filato. ");
INSERT INTO uraNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nii jaunte nacoauneein loreri asaae enohin: “Chaa cajena unaaneei,” naain bajaa Filatone jana, inauhene chujuhequiin aonaje Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nitohaneein tonoraeniha Jesosone jaunte: “Chanuna catoonraeneei. Tana cocoainanacaineein nihanune coitucuhine. Canune nainereeun coroso que ii teratihanune. Chaaen nachu naineeun caa ii colurujueeuruhane jaan caje jianacoo chetichaaunne,” naa Filatone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","“Cocoainanacaine lanaala cheteein nii jereniha Cana Coaunerane, canasia nainihei. Nii jaunte, chamurijiriin osaque caa catohaneein ichei caetera,” naa Cana Coaunera Calaohi Jesosone jaunte, ");
INSERT INTO uraNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jesoso jianena jere Filato niqui. Nete: “Jiaohine jianeeine. Aca, curuaanaa rey neein nenaa jerihane jaun, caohacharihei jianeeine. Jianeeinete, satiin inara curuaanaacuru curuaanaa enferadoro aina nejeratenaa neriquiin,” naauruha nujuae soaisoain Jorioocurune jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jesoso raerate, nii Cabata naauruha Ebereeo ere cuhanene jaan- ajeri caje ichanohineein nenaa aranichoae uhauruhane coina. Nitohaneein raerateeuruhane jaun, raain turaauruhane jana, nii casetecocuru neruujuena jaaun nelauriariin lauheque nelaurianaana jaan rori choaae, ");
INSERT INTO uraNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","enoto chujutaain Fasocoa catainajeein. Nii jaunte nitohaneein raerateein: “Nocoa inara curuaanaa rey,” naa Filato Jorioocuru raine jana: ");
INSERT INTO uraNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","“Coroso que teeuchete coaraain cuu ohine,” naain nujuae soaisoaiuruhane jana: “Chasiinna inara curuaanaa rey tereeun coroso que,” naa Filatone jana: “Romanocuru curuaanaa enferadorohachate canacaanu curuaanaa rey neein nera. Nihei nii baiha curuaanaa reyta,” naauruha batirichuru curuaanaacuru Filato raine jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","acaauru que Jesoso amaerate Filato. ");
INSERT INTO uraNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nii jaunte nii Jesoso amaain, que corosonu baijieratecuruhane jana, Couturi Bejeroneein curuajaain nenaa atane ucuuno que baibaichaain amaain, nii coroso tiha cue Jesoso. (Nii Ebereeo ere cuhane Colocota naauru najaan- Couturi Bejeroo.) ");
INSERT INTO uraNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nii janate cuu coroatajai coroso que, cuu neeuruha coroatajaain soserenacaaurune jaun, acaaru cataaun Jesoso teeure coroso que, leinjiin jera que, leocha jera que, naaonjoaain. ");
INSERT INTO uraNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nii janate, cuu Jesoso curuaa laenaerate Filato. “Nasarete cocoaicha Jesoso, Jorioocuru curuaanaa rey” nasiin laenerate coroso que, tabara que teein Filato. ");
INSERT INTO uraNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nii jana arajiin Jorioocurute nii Jesoso curuaa Filatohacha laenaeratei ereretaaure, nii Jesoso teeuruha coroso quene jaan caje icharaeniha Jerosaleenne jaun. Ebereeo ere, Curieco ere, Romano ere, naaonjoain que nichata lauriin erenaa cuhane teeinte laenaaure, nii que erenaa inaurera ereretaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nii jaunte: “Coa, Jorioocuru Curuaanaa reyneein teein laenaratihara,” naaure Joriocuruneein batirichuru curaanaacuru Filato rai. “Nii Jorioocuru curuaanaa rey niha nocoeti, nasiin laenaerateeura,” nauruhane jana: ");
INSERT INTO uraNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","“Nii rijieeincha nedaainera,” nae acaauru rai Filato. ");
INSERT INTO uraNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nitohaneein coroso que Cana Coaunera Calaohi Jesoso curaboaain teeuruhane baihate, Cana Coaunera Calaohi Jesoso cajione raaure jenai soondarooru. Rai nobirine maajeein raaure. Rai nobiri, coaracuruhane jana nirijieein ijiabereeonu farueraelanaala tocoonojoi inelanaala niha nii rai nobirine jaun: ");
INSERT INTO uraNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Coa soaihachete naajeein amaacache, nenacaaentejian caohachare naajeen amaacachene. Aihute que necoatijianaa neeine, chariji rai neeincha nedareein,” naaure soondarooru. “Ita raite cacaijione leruhin raaurureein que necoatijiain,” naa Cana Coaunera Quiricha Inoaesi cuhanene jaunte, nii Cana Coaunera Quiricha cuhane aitohane nainaane coina nitohaneein teeure soondarooru. ");
INSERT INTO uraNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nii jaunte, inae Jesoso mucuuruhane coitucuuriin, coroso asaae cuhin coaraje rai neba, nichatajai enecuru aina. Nocoasai, Cureeofasi comasaineein nenaa- Mariha, Mariha- Maadala bene, naaonjoaain. ");
INSERT INTO uraNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nii janana cuu nihacaanu, jataain niicha belaaii nichaanune temeecohacaanu neba ainane jana, neba coaariin: “Nii ii calaoita oma,” naa neba raine baiha: ");
INSERT INTO uraNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","“Nii chobata,” naa caraina jaunna jerichanejeein cafojiara raanune rijijieein raain amaaun caloheri asaae. ");
INSERT INTO uraNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Inae nitohaneein nihane coina letoaa Cana Inaca Cana Coaunerane nainaane coitucuha raotojoeinne jaunte, inae Cana Coaunera Quiricha Inoaesi cuhane aitosiha inaena jaun: “Cocoiintohanura,” nae Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nii janate baichaje laaojoiri nainecojoain ecu niha bino baasone jaun, enuha que sie rijijieein nenaa nujuateein, nii bino sisiaain Jesoso ujuaae que suesuecaauruhane jana, ");
INSERT INTO uraNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","nii bino baaso cohane baiha: “Inae laaenra,” naain ocoai couturi tijitiaain ohe Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Le janojoeein lanaa Fasocoa besetane janate, Filato rai aitoha cuure Jorioocuru, coroso que nenacaauru anaae bacoerateein, naain nii coroso caje rocoeratenajaain, naain rucuhenaaratiha Filatone coina, nabana nebetacanaa janonaa bana cuu neeuruhane, coaranaaca cachaaurune coataa, acaauru rai jataain beseta tabaineein niha Fasocoa besetana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nii jaun soondarooru letoaa Filatone jaun, cuhin nii Jesoso ajiniha coroso que nenacaauru anaae bucu bateeichure soondarooru. ");
INSERT INTO uraNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nii baiha Jesoso rohan turuhin coaracuruhane jana, inae oha Jesosone jaun, rai nanaae bacoorene. ");
INSERT INTO uraNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nete laaen rai nanaae bacoorenihane caniha laaen, rai jaleri rucuaaite leinjiin soondaro rejoon que. Nii janate rai jaleri rucuaitohane jana chujuhare ichana, acau que jasisiin. ");
INSERT INTO uraNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Canuna coaaraneein aitoon inara rai, inara netonai rauhijiriin aonaain esenetaaichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“Nihei chatohaneei bacoorurihaainta,” naa Cana Coaunera Quiricha Inoaesi cuhanena jaunte, Jesoso bucu bacoorene. ");
INSERT INTO uraNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Cana Coaunera Quiricha Inoaensi leeocha cuhanete “Focooruhane janate, inauhene coarajiha cuurureeincha,” naain aitohane rijijieein coarajeeure. ");
INSERT INTO uraNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nii janate Cana Coaunera Calaohi Jesoso jaberoco bajae Filato caje Arimatea cocoaicha Jose, rucuhecuruhane coina. (Nii Josete asinojoineein Cana Coaunera Calaohi Jesoso ere tonoraera ne, leeochaauru Jorioocuru coasiha.) Nii jaunte, Jesoso jaberoco jianiha Filatone jaun, Jesoso jaberoco raain amae. ");
INSERT INTO uraNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nii janate turuha uhe nii jauriaanejeein janotiin Jesoso rene turuhin erenaa Necodemo netonai, nichatachoonca quironeein meentoon tocohaneein nenaa ujujuai uhain. ");
INSERT INTO uraNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nitohaneein Jesoso jaberoco amaain, nii juujijiai que rujuaain, cajione que baluluhin conajaain, Jesoso jaberoco rucuheca cuhe Jose, Necodemo aina. Nitohaneeinte onaa rucuhecure Jorioocuru, nitohaniha acaauru ichaona jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nii Cana Coaunera Calaohi Jesoso teeuruha Jorioocuruna jaaunte ne enuha inaa neeonjoai. Nii enuha inaa neeojoain janate ne atanebana. Ecute ne achasineneein ajeri jachu- jaiti lesajeeinejein onaa teeurenihana jaan. ");
INSERT INTO uraNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Cuhanete Jesoso jaberoco teeure, ichuunejeein niha cajene jaun, chaaen inae beseta bitoauruhane coina neruujihajeeuruha Jorioocurune jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Semana nunuhe tomiho cojoanonaa bana nocohejiriin cuhin, jaiti nocohetoojoaane jana turuhin coaraa Mariha Maadala benene jana, inae fueraene nii ajeri jachu. ");
INSERT INTO uraNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nii jaunte soroneein jelaiha uhin, Fedoro, canu, naaonjoainihacaanune rai biha uhe. “Aanca chaainti cana curuaanaa. Chu chaainti amaaureta,” ");
INSERT INTO uraNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","naain biha canacaanu raina jaun coaraa cuhacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nii jaun, ita jiniichaain soroneein cuhin coaraa cuhacaanune jana, Fedoro reroriin cuhin, turuhin ");
INSERT INTO uraNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","metoraain coaracaunne janate, cuu ne cona. Nena laaen enohin coaraeneeun. ");
INSERT INTO uraNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nii janate canu caaijie turuhin, enohin, coaraa Fedorone jana, cuu ne jaberoco conaauru. ");
INSERT INTO uraNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nii janate nejelau ne nii Cana Coaunera Calaohi Jesocurisito couturi cona, nejelau maromarorinohineein seeque. ");
INSERT INTO uraNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nii janane canu netonai enohin coaracaunna jaun, ichanaa Cana Coaunera Calaohi Jesocurisitone esenetaaun. ");
INSERT INTO uraNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Cana Coaunera Quiricha Inoaesi cuhane besihane jana niqui, “Naaonjoarichaaine quete aite,” naain coitucusinaaunlu. Nena canacaanu nota que coaracaanune jaun, caohachaain coitucuhin esenetaacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nitohaneein coaracaanune bihane nenaanajaun cauha cuhacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nii janate cuu nii ajeri jachu rohan nedaain chanaechanaje Mariha- Maadala bene. Chanaaechanajeein metoroaain nii ajeri jachu coaraane jana, ");
INSERT INTO uraNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","cuu laurujua laurujuaaure Cana Coaunera letonocuru anjeraauru somanerei que cajionequiin Cana Coaunera Calaohi Jesocurisito jaberoco teeuruhana jaaun, leinjiin couturi nichajai que, leeocha tijia nichajai que naaojoain. ");
INSERT INTO uraNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Niichurute: “Chate coisiita,” naauruhane jana: “Carai curuaanaa jaberoco amaauruhana jaunna coisiunra. Chu chaainti amaain teeureta,” naane baiha, ");
INSERT INTO uraNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","jaotoroain janori nichajai coaraa Marihane jana, rai chujuhaca Cana Coaunera Calaohi Jesocurisitone jana, acanihane coitucuene. ");
INSERT INTO uraNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nii jana: “Chana coisiite ene. Chana arii,” naa Jesocurisitone jana: “Nii enuha inaa beraicha niha,” beein: “Ii amaaine, carai nii amaain teeine jaa jelai beeune coaanicha,” naa Marihane janate: ");
INSERT INTO uraNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Mariha,” naa Jesocurisitone jana, nejaorocoaain rautaain Jesoso coaraain: “Raboni,” nae Mariha. “Cacha relaera,” naanete aite Ebereeo ere cuhane. ");
INSERT INTO uraNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Niritiin coineteein mucunaa jeriha Marihane jana: “Caiha neeu. Jauriaa coaa cadadaara, jaiti iniin Ofa coaraenihanune jaunra. Chajaaincha cacoelaichaauru rai canu benihura. Jaitina iniin, Ofa Cana Inaca Cana Coaunera rene iniha cureeunnicha,” naa Cana Coaunera Calaohi Jesocurisitone jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","nii Cana Coaunera Calaohi aina nerelanaa nichaanune rai biha uhe Mariha Maadala bene. ");
INSERT INTO uraNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tomiho cojoanonaa bana nihana jaunna, nii cojoanotiin cuhane ita taojiaacaanu nii Cana Coaunera Calaohi Jesocurisito aina nerelanaa nichaanune, caohatiin acuujua fuhin Jorioocuru coasiha. Nii janate enohin, canacaanu cataaun neeoritiin: “Raotojoeein rachoojoeein neeuchera,” nae canacaanu rai Jesocurisito. ");
INSERT INTO uraNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Niritohane baihate, biji que curabo cure, jaleri que rejoon cure, naaonjoain coaarate canacaanu que. Nii jaunna rachoojihacaanu aina nerelanaa nichaanune, coaiteen canacaanu aina nihana jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nii baihate enacoauneein: “Raotojoeein rachoojoeein neeuchera. Charijieein teeinti, caletoae Ofa, nirijieeinna caa inara letoaunra,” nae canacaanu rai Cana Coaunera Calaohi Jesocurisito. ");
INSERT INTO uraNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Niritiinte canacaanu couturi jiririin: “Cana Coaunera suujue raauchera. ");
INSERT INTO uraNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Chunei osaaona que inara suujua acatequichenena, canu netonai nii osaaona que casuujua acatereeunnicha. Jana aineeinchene, canu netonai airihaaunnita,” nae canacaanu rai Jesocurisito. ");
INSERT INTO uraNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nii janate, inae amuha Cana Coaunera Calaohi Jesocurisitone jana, turuha uhe Tomasi, nii fafione neein, niicha curuaateeuri. Nii Tomasite Jesocurisito aina nerelanaa nichaanune lechoonca coroataja ne. ");
INSERT INTO uraNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Turuha Tomasine janate: “Cana Curuaanaa coaracaanura,” naain bihacaanu Tomasi raine janate: “Biji larijia que curabo cure coaracaaunne banaachane, esenetareeunni. Chaaen cuhane canu biji couturi enoaain, chaaen jaleri que rejoon cure cuhane canu biji couturi enoaain, naaonjoain coaracaaunne banaachane nainereeunni esenetaanunera,” nae Tomasi, rai bihacaanune jana. ");
INSERT INTO uraNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nii baihate foosa janonei cuhane, coaiteen jelaiha enacoauneein ita taojiacaanune janate laaen, canacaanu aina ne Tomasi. Nii jana caohatiin fueraa acuujuane saijieein enohin canacaanu cataaun neeoritiin: “Raotojoeein, rachoojoeein neeuchera,” nae canacaanu rai Jesocurisito. ");
INSERT INTO uraNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nii baihate: “Tomasi, caa canu biji larijia cuhane, ii biji couturi enoain coaraau. Chaaenchu caa canu jaleri que rejoon cure cuhane, ii biji couturi enoain coaraain esenetaachaau, baaso coacuelanaala,” naa Jesocurisitone jana: ");
INSERT INTO uraNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","“Canu Curuaanaa Cana Coaunera” naa Tomasine jana: ");
INSERT INTO uraNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","“Inae laaen Canu esenetaai ichaajenihane coaraina jaun. Raotojoeeinte niha cuurureein, catohaneein nihanune coaraelanaala quesenetaeraauru,” nae rai Jesocurisito. ");
INSERT INTO uraNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Itolere ichaainte coaarate Cana Coaunera Calaohi Jesocurisito. Nete satiin laenanohineein nene caa quiricha cuhane. ");
INSERT INTO uraNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Cana Coaunera Calaohineein niha Jesosone esenetaaichene coinate, laenanohineein ne, esenetaaichene, ichaonaa caohacha, chabana nitajeniha cachane jaan raaichene coina. ");
INSERT INTO uraNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nii baihate Calileea conemuri auhaniha, aina nerelanaa nichaanune rai ecocoe coaiteen Cana Coaunera Calaohi Jesoso, rede jaoha nihacaanune jana. ");
INSERT INTO uraNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nii janana laaen Fedoro aina nihacaanu, Tomasi nii fafione naauru najaan, chaaen nii baiha Natanaaeli, Calileea caje unaa Canaau cocoaicha, chaaen Sebedeeo calaohi nichaaunne, chaaen eleeocha coroatajaain, naaonjoaain nihacaanu Fedoro aina. ");
INSERT INTO uraNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nitohanihane coinanu quete: “Redena jaoha cureeun,” naa Fedorona jaun: “Tana iniha uhacaanu,” naacaanune jana: “Chajaauchetejian aihane cunichaache,” naa Fedorona jaun, cuhin bote cuhane fauhin, cuhin janoaajeein rede jaohacaanu niqui. Nii janane leinjiinejein ate mucuujenihacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nii jana, inae mataaquiin uha janonaane jana, nemuri auhaniha ecocoe Cana Coaunera Calaohi Jesoso. Nii janana, aca nihane coitucuenihacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nii janate: “Enamanaacuru, ta ate mucuhichene,” naane jana: “Aihahacaanuta,” naacaanune janate: ");
INSERT INTO uraNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Cana raotono nichajai bote jera que, rede jaohichenete ate mucuriquicheein,” naane jana, nii bote jera que jaohacaanune jana, esinae ate mucuhacaanu. Nii jaunna ate anaai caaun nii rede tijichasinihacaanu. ");
INSERT INTO uraNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nii janate: “Cana Curuaanaate aitera,” naanu Simoon Fedoro raine jana, aohanrihane rijieeoritiin torosaacha baaejeein nihana jaun, luhecotariin cajione curujuain acauhanau fautiin Jesoso rene turuha cue Simoon- Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nii janane bote cuhane caaijie cuujueein turuha cuhacaanu rede tararajeein, ate caaun lemuequiin, lefasha metoroneein lanaa nemuri auha cajena jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Najauriaain inihacaanune jana, cuu ne canacaanu ajiniha usi lanarotiin. Nii jana nii usihanau niha leinjiin atene jana, cuu ne faan. ");
INSERT INTO uraNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nii janate: “Nii ena inaraacha mucuhi ate uhauche,” naa Jesocurisitone jaun, ");
INSERT INTO uraNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","bote cuhane fautiin nii rede tararae Simoon Fedoro, carene choaae. Lefasha saoquichoonca nichatajaa ate tabai inatiinte, nii rede soaine. ");
INSERT INTO uraNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nii janate: “Chajaauchete inara suuri noite,” naane jana, “Chaneeina” naain bajanaa nainenihacaanu, raotojoein Cana Curuaanaa Jesoso nihane coitucuhacaanune jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nii janate, tajiha uhin nii faan raaoriin, canacaanu nainetiin chalue. Jerichanejeein techu, nii ate basicho chalue canacaanu nainetiin. ");
INSERT INTO uraNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nitohaniha Cana Coaunera Calaohi Jesoso, oo caje ichanaain, canacaanu rai ecoocane nichata sai cuhane. ");
INSERT INTO uraNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Inae nainaain canacaanu suri noitichaanune janate: “Jonasi calaohi Simoon, cau nenacaauru leeochaauru amuritoheriina ii coichana aina cutaain cacoelai” naain bajaa Cana Coaunera Calaohi Jesoso, Simoon Fedoro cajene jana: “Ejeen. Iite ichoelaihanune coitucuhicha curuaanaa,” naane jana: “Aihane quere esenetaurera beraihura,” naane baihate coaiteen: ");
INSERT INTO uraNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","“Jonasi calaohi Simoon ii coichana aina cutaain cacoelaaina,” naain bajaa Jesocurisitone jana: “Iite ichoelaihanune coitucuhicha curuaanaa,” naane jana: “Aihane quere esenetaain tonoraeraauru beraihu,” naane jana coaiteen: ");
INSERT INTO uraNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","“Jonasi calaohi Simoon, ii coichana aina cutaain cacoelaaina,” naain nichata saain bajaane jaunte, inaderaain: “Ejeen. Iite itolere coitucuhin, esinae ichoelaihanune coitucuhicha curuaanaa,” naane jana: “Aihane quere esenetaain tonoraeraauru beraihu. ");
INSERT INTO uraNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Esinaena aitoonra. Enamanaaneeinne banate, necoreeteein, chunijiu cunaa jereinajaaun curejetohi. Jana, inae biinaa neeinete, ichoii caaecaaecaaine jana, ichajione curujuaain, cunaa jereeneina jaaun niha natiin chamaaurureeincha,” nae Simoon Fedoro rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Niritoha Jesoso, “Naaonjoainna Cana Coaunera ere tonoraanune coreniha oha cureeunni,” naain coitucuha Fedorone coina. Nii baihate: “Quere tonoraeraneein neeu, inoaelu netiin,” naane jana, ");
INSERT INTO uraNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","jaotoroaalaain canu coaari Fedoro, acaauru caaijie cuhanune jaun. ");
INSERT INTO uraNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nii jaunte: “Chataaenriha jana caa,” naa Fedorone janate: ");
INSERT INTO uraNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","“Chaquena aasare ichei. Canu jerichaaunete nacoauneein turuhanune que tiaaojoaain ichaonaa naine, Ii laaen quereecha tonoraau,” nae. ");
INSERT INTO uraNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Niritohana jaunte, orihaunnijiecha naaure ita rai nii canu aina Cana Coaunera Calaohi coitucuurera. Coatiha oenerihanuhinne que aitohi. Netechu jataain, “Chaquena aasare ichei. Canu jerichaaunnete, coaiteen turuhanune que tiaaojoaain ichaore,” nae Fedoro rai caque Cana Coaunera Calaohi Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Caraajenihane coaraain, laenaanune jaunte, esinae rauhijiriin erenaa ne. ");
INSERT INTO uraNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Itolerete niqui ichae Cana Coaunera Calaohi Jesoso nete saain laenanohineein neene. Satiin laenanohineein nihane, nerihei caa chauratane que tenaana jaan.");
INSERT INTO uraNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Nii nunuhe caje coauneein, niicha ichanohin ichaain, cachaauru relaalu Cana Coaunera Calaohi Jesoso dedeeu cauha cuhane que tiaaojoaaine quene, caa ichei beein, jauriaanejeein laenaunlu, jataain ii belaichaaunna jaunra Teofilo. Chaen techu dedeeu cauha cuhane ajiniha, rai afosotooru- niicha cocoainaenenuuru cotijiaain raain suujua tenajaerate Cana Coaunera Suujue que acaauruhacha ichanenenu coitucuhin ichacuruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ohane baiha jetaote, jenachoonca janoneein cachaneein ecocohin, acaauru rai Cana Coaunera Cojoanonaa que ereereje esinae rauhijiriin oo caje ichanaain enacoauneein ichaohane esenetaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jaiti Jerosaleeun niicha cocoainaauri afosotooru aina nihane bana jetaote: “Jiaaonriha caa Jerosaleen caje chunijiun cuhichenera. Aitocoaaunne rijijieein inara rai Ofaacha tenaa jerei cohacuche jauriaara,” naain chunijiun cuuru caohateein jetao, ");
INSERT INTO uraNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","“Esinaete rauhijiriin acau que cacha baotisaain cojounacateraaete Joaan. Nete inara chaabana nejein Cana Coaunera Suujue que, baotisaain cojounacatenohineein niha curiquicheeincha,” naain jauriaanejeein acaauru rai beelu jetao Cana Coaunera Calaohi Jesocurisito nitohanihane coina. ");
INSERT INTO uraNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesoso aina ita taojiaain neeuru najaaun jetaote: “Enenena coaiteen jianacoo Isaraeli cocoaicha nichaachene mitareeita Curuaanaa, raotojoeein cana ichao que ichaohacachene coina,” naain bajaauruha niicha cocoainanenuurune jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","“Nainiheeiche inara nii coitucuhichenera. Chatohanai bana chaainti, nii ichaa cureein Ofata. Leinjiin acaachate nii coitucue niquicha. ");
INSERT INTO uraNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nete inara ichoae fauha Ofa Cana Coaunera Suujuene, nii aina itolere ichana naineriquicheein inara netonaicha. Chaente chatohanai que casilanaala, laraajiin itolere Jerosaleen sacutaain, itolere Jodea batane, Samaria batane, naaonjoainuri sacutaainchuru amuhemujueein canu ere beebejiha curiquicheein, itolereneein chauratane sacutaain canu coitucuuruhane coinara,” nae jetao acaauru rai Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Niritoha acaauru raine jaun jetaote, coarajeeuruhane jana jetao, dede sacari jana nitajeeoriin dedeeu cauha cue Jesoso. ");
INSERT INTO uraNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nii jaun jetaote, coaarihurenihane jaun, cuu caaijie cojoaelaauruhane jana jetao, somaratohanai que cajionequiin acaauru rene ecoocure coroatajai anjeraauru ");
INSERT INTO uraNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nitohaneein ecocohin jetaote: “Chanuna dede cojoaelaaichete Calileea cocoaichacuru. Nii coarajeeichene jana dedeeu cauha cuhane rijijieeinte, coaiteen turuha ureein Jesosora,” naaure jetao acaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nii jaun jetaote, nii Oliboneein curuajaain nenaa ichatane ucuunno neeuru caje cauha cuure Jerosaleeun, Jesosohacha cocoainaauri afosotooru, ichuunnejeein le oaraanca metoro fautaeriin nebetacanaa janonaa bana amuuruha cachaaurune jerecuruha Jorioocurune itaanejeein. ");
INSERT INTO uraNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Inae nii neseeu turuhin jetaote, ecuunetiin coroatajaain coaranai loreri asaae sinii aihuruhane jaun jetao, iniha cuure ita caaijie, Fedoro, Saantiaao, Joaan, Aanderesi, Ferifi, Tomasi, Bartolomee, Mateeo, Arafeeo calaohi Saantiaao, chaen, Selote naaurunaja- Simoon, chaen, Saantiaao calaohi- Jodasi, naaonjoaainunri. ");
INSERT INTO uraNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Satiin nii afosotooru jetaote, inetono janonaa bana ita taojiaain, Cana Coaunera bajae bajaecururejetelu, Jesoso nejeraauru, chaen neba Mariha, chaen leeochaauru enecuru, naaonjoaainunri aina. ");
INSERT INTO uraNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nii cojoanonaa bananeein jetaote, ita taojiaaure lefasha coroata chooncaain nenacaauru- Cana Coaunera Calaohi Jesoso esenetaeraauru. Nii jana jetaote, acaauru cataaun nichaauraain jetao, acaauru rai: ");
INSERT INTO uraNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Jesocurisito coreniha canejeraauru, inae Quiricha Inoaensi cuhane laenaerateein Rabiri que beratihalu Cana Coaunera Suujuene rijijieein situhanetene. Nii jaunte Jesoso mucuha cunacaauru aina cue Jodasi, acaauru rai beranu que. ");
INSERT INTO uraNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Canacaanu aina nere beranu quete niqui ranojoineein nelu. Nete nitohaneein ichae. ");
INSERT INTO uraNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nii Jodasi jetaote, coretecuruhane jaan coriqui coreniha atane coretihane jaun jetao, nii baiha nemarote. Nemarotihane jaun jetao, couturi que chujujuaain tacaane jaun jetao, nefohitoha rai surine jaun, jianacoon chatolene cacha suri. ");
INSERT INTO uraNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nii coitucuhinte, nii atane curuaateeure Jerosaleen cocoaichacuru Areseramaneein. Acaauru ere cuhane, ‘Areserama’ naanete, ‘Ichana core- coriqui coreniha ranojoin atane.’ naane aite. ");
INSERT INTO uraNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Cana Coaunera Quiricha Inoaensi- Salmo cuhanete: ‘Rai loreri quete jaole que. Nihei nasaae ichoai.’ naain laenanohineein ne. Chaen techu: ‘Niicha ichaneni neein nenaa icharaaunu quete enoe coreenranu que leeocha cacha.’ naain, Cana Coaunera Quiricha Inoaensi cuhane laenanohineein ne. ");
INSERT INTO uraNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Nete, cau canacaanu aina neeure- Cana Curuanaa Jesoso baotisaa Joaanne caje coaauneein- dedeeu cauha cuhanereein tiaaojoaain- canacaanu corihaniha amuhemuhenacaauru cachaauru. Aihana jaun, canacaanu lechoonca coroatajanu que, chunocoha acaauru caje enohanete caohachare, canacaanu aina, esinae rauhijiriin ichanaa Jesosone coaracuruhane jaun, canacaanu aina beraanu que,” nae jetao Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nii jaun jetaote, “Barasaba Josto” naain acaauruhacha curuaatei Jose, Matiasi, naaonjoainuri, jelai ita rohan tenajaain jetao, niicha jerei biha acaauru rai Cana Coaunerane coina jetao: ");
INSERT INTO uraNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","“Cana Coaunera, iite saatiin cacha suujua coitucuera neein neeicha. Iite, canacaanu que nii coitucueratenaa naineeicha. Chariji, caa coroatajaihuri caje nainere, niicha jereeineein nosa coreniha cunaa jerena jaaun cunaa coreenraniha, iicha teei amihanenaa ichana nainereta,” naain jetao, Cana Coaunera bajaaure acaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Niritiin Cana Coaunera bajaauruhane baiha jetaote, niha ajeri catu, cojunaca siriina jaun, “Cojunaca siricha mucuerate aca nereeincha,” naauru jana jetaote, rauhijiriin nii cojunaca aina nenaa mucue Matiasi. Nii rijieeoritiin jetaote, lechoonca coroatajaaure Jesocurisito letonocuru, lechoonca leinjiin neeuruhane baiha. ");
INSERT INTO uraNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jorioocuru beseta Feentecosetesi janonaa bana nihane jaun jetaote, satiin le laurijieein ita taojiaain neeure, Cana Coaunera bajaauruhane coina Jesocurisito esenetaeraauru. ");
INSERT INTO uraNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nii jana jetaote, cuu le lorerijieein satiin codohacooruhana jana, luhecotariin tonijiaain cujuana rijitiin fauha uhe Cana Coaunera Suujue dede caje. ");
INSERT INTO uraNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nitohaneein tonijiaain fauhin jetaote, nii satiin- ecu nenacaauru suujueniha neeoritiin, acaauru bichohe naainetiin, usi lanaro tocohaneein lanalanaaonanae. ");
INSERT INTO uraNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nii aina jetaote, nejelau nejelaauru, lauri laurichuru caje uhin cuu turunacaauru cachaauru rai, acaauru ere cuhane ereeure satiin Jesocurisito esenetaeraauru, erelanaaca Cana Coaunera Suujuene rijijieein. ");
INSERT INTO uraNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nii bana jetaote, cuu nii Jerosaleeun turuhin neeure lauri lauri atane sacutaainchuru caje unacaauru- Cana Coaunera aitoonjoa rijijieein ichaonacaauru Jorioocuru, ecu Feentecosetesi beseta bitoaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nitohaneein inae acaauru ichoaae fauha Cana Coaunera Suujuene jana jetaote, tonijiaain ereeuruha Jesoso esenetaeraaurune jana jetaote, satiin codoonetoore nii lauri lauri caje unacaauru cachaauru, acaauru ereeuru cuhane aitocuruhane aonaain. Nitohaneein jetaote, suujuanu inaaoritelanaala ");
INSERT INTO uraNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","cojoaelatonajaain: “Calileea cocoaichacuru nihanatiin, ");
INSERT INTO uraNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","inasiina cana ere cuhane aitocure aonacaachene coina. ");
INSERT INTO uraNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Caute nihacache itolere sacutaain caje uhinichaachene, Partia batane caje unacaauru, Media batane caje unacaauru, Elam batane caje unacaauru, Jodea batane caje unacaauru, Capadosia batane caje unacaauru, Poonto batane caje unacaauru, chaen Asia batane caje- unacaauru, ");
INSERT INTO uraNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firijia batane caje unacaauru, Paanfilia batane caje unacaauru, chaen Egipto batane caje unacaauru, tajiha Sirene bujua nenaa Libia batane caje unacaauru. Chaen techu, cau neeure cana aina Romanocuru netonai. ");
INSERT INTO uraNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Acaauru tabaaurute Jorionecure. Jana leeochaaurute, Jorionecurenihane saijieein Joriooneein nerotocure. Chaen techu cau neeure cana aina Cureta batane caje unacaauru, chaen Arabia batane caje unacaauru, naaonjoaainunri. Nitohaneein araai laurii caje uhacachene saijieeinte, satiin lauri lauri caje uhin nichaachene ereeuru cuhane Cana Coaunera coroaecuruhane jana aonajihancache,” naain jetao satiin cojoelatoore. ");
INSERT INTO uraNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nitohaneein cojoelatiin jetaote: “Chatohanihana,” naain ita caje bajaae bajaaecure satiin. ");
INSERT INTO uraNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jana acaauru tabaauru jetaote: “Chaquena ereeure caa ajenacaauru,” naain acaauru batocure. ");
INSERT INTO uraNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nii jaun jetaote, lechoonca leinjiin aina ecu nenacaauru afosotooru aina nichaauraain jetao tonijiaain: “Aonacuche satiin Jorioocuru. Satiin cau Jerosaleeun neiniquichene raina aitoreeunni coitucuhichene coina. ");
INSERT INTO uraNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Coatiha aitocohichene jana, aansijiinijin ajeeuruhi caa cachaauruta. Inasiina jaiti janoneniha natiin ajeeurureta. Ena nuna macojiu teejiha enoto natiin, cha caaunna ajeeurure. ");
INSERT INTO uraNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nete catohanihane coina, inoaenlu inae aitiin besihalu Cana Coaunera Ere bera inoaensi Joherine rijijieein: ");
INSERT INTO uraNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Inara rai quiicha tei janonaa besautelalaje raina, satiin chauratane que nenacaauru choae canu suujue letoareeunnicha. Nii banate, quiicha chana jerei coaraain beebejiha cuurureein canu coreniha, inara nefoerateeurura. Enamanaacuru niha natiinte, acaauru que quiicha coaaratei coaracurureeincha. Binaacuru nihanatiinte, quiicha coaaratei coaraa cuurureein acaauru sinihura. ");
INSERT INTO uraNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nitohaneein inae cutihane banane, saain canu cachaauru, enecuru, quichaauru, naaonjoainuri choae canu suujue letoareeunni canu ere beebejeeuruhane coinara. ");
INSERT INTO uraNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Chaenna, naain dedeeu jataain cojoaelanaacojoai coaratiha cureeunnicha. Jerichanejeeinachu, chauratane que coaratiha cureeunnicha. Nii banate ecooca cureein ichana, usi tabai, suruaa neeonjoaain, naaonjoainuri chauratane sacutaaincha. ");
INSERT INTO uraNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nii banate conoenereein enotora. Jana atenete, ichana tocohanai jana niha cureeincha. Nitohanihate cureein inae ichuun nejeeonriha turu rai niha inara Curuaanaane janara. Nii cojoanonaa banate, coasinacaain elunareeincha. Nerinaain nii caje nichotei cachata. ");
INSERT INTO uraNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nete, cairichaaojoaain coaraa Cana Curuaanaane coina bajae bajajeein ichaonacaauru, satiin nii caje nichotiha cuurureeincha.’ naain nere bera inoaensi Joheri que beratihalu Cana Coaunerane rijijieeinte, inae caa aihane jana coaraquichera. ");
INSERT INTO uraNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Aihana jaun, caohachaain rautaain aitocoaaunne aonacuchena, caa que erete aonaquichera Isaraeli cocoaichacuru. Satiin coarajeeichene notaracaete, itolere ichaain inara notaarate Nasarete cocoaicha- Jesoso que Cana Coaunera rai letononeein nihane coitucuhichene coina niquicha. ");
INSERT INTO uraNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nete, inae inoaenlu nitohaneein teeichene coina, niicha jerei rijijieein ichaa Cana Coaunerane jaun, inara rai tiha nii terane jana, amaain teeiche nechu aansai cachaauru raine jaun, coroso que teein sohin jaaorelu. ");
INSERT INTO uraNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nete onaa caje ichatelu Cana Coaunera, onaa caje colucohin, amuritonaa nainesiniha onaane jaun. ");
INSERT INTO uraNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Inoaenlu jaiti caa chauratane que turueniha Jesocurisitone janate, aitorichaain Jesosone rijitojoeein: ‘Itolere janonaa banate, cacorataanereein Cana Curuaanaara. Aihana jaun, nerinaain chatohaneein canu terata. ");
INSERT INTO uraNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nii jaaunte, raotojoeein rachoojoeein ne canu suujuara. Chaen nechu, chaque casilanaala raotojoeein ichaaon, ");
INSERT INTO uraNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","curu cuhane nitajiha canu jaberecone nainatejelanaala, niheichu setuha canu jaberecone nainatejenereeinine jaunra. ");
INSERT INTO uraNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Iite canu que, onaa caje ichananaja coaarateeicha. Nii jaunna, raotojoeein rachoojoeein nereeunni,’ narichaain Jesoso, Cana Coaunera raine rijitojoeeinte belu curuaanaa inoaensi Rabiri que beratiha Cana Coaunerana jaun. ");
INSERT INTO uraNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Jesocurisito coreniha canejeraauru, jerecuchene esinae rauhijiriin inara rai aitete aonaquiche. Nii coitucuhichene rijijieeinte, ohalu cana foeratera Rabirine jana, conautecuruhane jaun cau ne rai natanebana. ");
INSERT INTO uraNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nete, esinae rauhijiriin rai nere bera inoaensi niha Rabirina jaun, rai nichoala- cana curuaanaa- Rey neein tihane coina, rai besihalu Cana Coaunerane jaun, coaara rijijieein coitucuelu- curuaanaa inoaensi Rabiri: ‘Ii ichoala ichoalacuru calaohite, Jorioocuru curuaanaa Rey niha cureeincha.’ naain que coitucueratiha Cana Coaunerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nii jaunte, inoaenlu jaiti turueniha Cana Coaunera letono- Mesihasine jana, nota que coaara rijitojoeein: ‘Naaonjoaainte, turuha ureeincha. Nihei nitajerinaain rai jaberecota. Niheichu ecu seturinaainta. Oo cajete ichanareein Mesihasicha,’ naain caohacha nainejeein jitariin coitucuhana jaun, Jesoso coaara rijitojoeein belu curuaanaa inoaensi Rabiri. ");
INSERT INTO uraNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nii jaunna esinae rauhijiriin bihalune rijijieein, canaacaanu netonai, canaacaanu nota que ichanaa Jesosone coaracaanu, ichatiha Cana Coaunerana jaun. ");
INSERT INTO uraNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nitohaneein ichateeinte, enacoauneein dedeeu rae Cana Coaunera, rai raotono nichajai que, aina jiniiquiin nihane coina. Chaaen techu, nitohaneein dedeeu raain, nii rai niicha tenaa jerei rai Suujue te. Niite, caa inara notaracae canaacaanu nainetiin chaluhane jaun, satiin coaraain aonaquiche. Aihana jaun, inae laen coitucuhiche raaotojoeein. ");
INSERT INTO uraNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Coatiha Cana Coaunera ere bera- curuaanaa inoaensi Rabiri, dedeeu iniha cuhilu. Cana Coaunera Calaohi Jesosote iniha cuelu. Nii jaunte, ‘ “Iite satiin Curuaanaa neeicha. Cau caraaotono nichajai que carohan nelaurihaau, ii que nejeratenacaauru amuritohine coina ichacaaunne reentiaaincha,” naa Cana Curuaanaa rai Cana Coaunerara,’ naain Jesoso belu Rabiri, beratiha que Cana Coaunerane jaun. ");
INSERT INTO uraNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Aihana jaun, satiin Jorioneeichene raina caa beeun raotojoeein coitucuhichene coina. Nii coroso que teein inaraacha focoi- inaraacha atinai Jesosote, satiin Curuaanaa Mesihasineein te Cana Coaunera,” naa Fedorona jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","que suujua rerohecaain, jataaen inaderaain: “Jesocurisito coreniha canejeraauru, cha charihacaanuta,” naain bajaauruhane jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","“Cana Coaunera notaracae baaso ichaain, osa que nesaruhin naosateein, naaonjoaain neeichene jiaaneein, Cana Curuaanaa Jesocurisito coreniha nebaotisaerateeuche satiinte, inara osa caje inara mitaain, inara rai- rai Suujue teeine Cana Coaunerara. ");
INSERT INTO uraNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Catohaneein tihane coinate, inoaenlu beratelu Cana Coaunera. Niite nenacaae inara caohachanu neein ne, satiin inara calaohichuru aina, satiin coriaae nenacaauru raine maajeein. Satiin niicha cotihacuri raite, rai Suujue tiha cureein Cana Curuaanaa- Cana Coaunerara,” ");
INSERT INTO uraNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","naain acaauru suujuatiha, nii cachaauru- baasoneein ichaonacaauru caje mituuruhane coina, Fedorone jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","nii niicha beebejei esenetaain tonoraeraauru jetaote, baotisaain cojounacatenojoineein, Jesoso esenetaeraneein neeure, nii bananeein nichata oaraancai cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nii jaun jetaote, satiin rauhijiriin ichaaore, relanajaauruha nii afosotoorune rijijieein, ita suujua rijitojoeein jiniiquiin ita coroatajaneein, ita taojiaain ita aina Cana Coaunera bajaain, ita aina jiniiquiin lenoneein naaonjoaaunre. ");
INSERT INTO uraNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nii jaun jetaote, satiin cojoaelatoore, itolere ichaain- cachaauru notaaratiha afosotooru que Cana Coaunerana jaun. ");
INSERT INTO uraNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Satiin nii esenetaeraauru jetaote, ita suujua rijitojoeein neein, ita rai chaaelai sirichuruhane ita sihure ita acatiha tacaain. ");
INSERT INTO uraNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Chaelai acaauruhacha sirii que necoreteeuruhane nenainetiinete, ita aina nii core- coriqui teein ita rai leruhin raaure, raotojoeein latecuruhane rijiinanaain. ");
INSERT INTO uraNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cojoanoonetojoeein jetaote ita taojiaaure, ita taojiaauruhana jaan coloheri- Teenforo asae. Rai lorerichuru asaae nihanatiin jetaote, ita taojiaain, ita rai lenone chaluhin lenonecure jiniiquiin, raotojoeein rachoojoeein ");
INSERT INTO uraNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Cana Coaunera coroajeein. Chaen jetao techu, caohachaain neeuruhane coaracure satiin ecu nenacaauru cachaauru. Cojoanoonetojoeeinte, niicha ichoteratecuri tiha acaauru aina, Cana Coaunerane jaun nejeeotejeein sacuure. ");
INSERT INTO uraNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nuna macohi choae teejiha enotone jana jetaote, nii ita taojiaauruha Jorioocuruna jaan loreri Teenforo asae cuure Fedoro, Joaan, naaonjoainuri cuu Cana Coaunera bajaauruhane coina. Jelai rijiu enoto tiaajianaain jetaote, ita taojiaaure satiin Cana Coaunera bajaauruhane coina. ");
INSERT INTO uraNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nii jana jetaote, nii Teenforo acuujuaniha ne leinjiin bacosaneein nejanoa caje coaauneein nenaa cacha. Cojoanoonetojoeein jetaote, nii Teenforo acuujua- Caohachajeineein- acaauruhacha curuhateihu amaain teeure, coriqui bajaa ecu enonacaauru cajene coina. ");
INSERT INTO uraNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","4","Nii jana jetaote, enooru coina iniijina cuuruha Fedoro aina Joaanne jana jetaote, acaauru caje coriqui bajae nii bacosa. Nitohaneein coriqui bajaa acaauru caje, nii bacosane jaun jetaote, coarajeein jetao: ");
INSERT INTO uraNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","6","“Aonaaunra,” naa nii bacosa rai Fedorone jana, “Chaelai teeuruhane coina jecha aite,” naain acaauru coarajihane jana jetaote, “Nihei nohane canacaanu rai coriqui. Nena quiicha sirii tereeuni icheicha. Nasarete cocoaicha Jesocurisito coreniha, nimichuhin nichaauraain amuunte coaracaara,” ");
INSERT INTO uraNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","naain nii bacosa biji- raotono nichajai que mucuhin michuha Fedorone jana jetaote, nii rijieeoritiin caohachanainejeein nerautae nii bacosa tijia aina- rai tajichocuru. ");
INSERT INTO uraNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nii jaun jetaote, nimichuhin nichaauraain, nii ita taojiaauruha Jorioocuruna jaan loreri Teenforo asae enoha cue jeluhate jeluhatiin Cana Coaunera coroaejeein. ");
INSERT INTO uraNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Nitohaneein nimichuhin nichaauraain amuhin, Cana Coaunera coroaecane coaraain jetaote, satiin cojoaelatiin coasichure situuruhane naineein Teenforo bacuujua- Caohachajeineein- acaauruhacha curuaateihu lauhequiin coriqui bajaera nihane coitucuhin. ");
INSERT INTO uraNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nitohaneein jetaote, Fedoro aina Joaan caje coriaae nalunaa jerene nii bacosa nihane caje nerautaanaa cacha. Nii jana jetaote, Teenforo chajeneein nenaa loreri Salomoonneein curuajaain nenaa asaae neeuruhane jaun, soroneein ruhanihajaaintiin cuhin cojoaelatiin coarajeeure satiin nii cuu nenacaauru cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nii jaun jetaote, acaauru rai: “Chanuna canacaanu cojoaelatohichete Isaraeli cocoaichacuru. Coatiha canacaanuhacha nejeein nihane nerautarihei caa cachata. Niheichu jataain leeochaauru amurijiriin, Cana Coaunera ere tonoraeraneein nihacaanune jaun niheinta,” nae Fedoro. ");
INSERT INTO uraNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Niritiin jetaote: “Nii cana inoaensihuru- Abaraaun, Isaca, Jacobo, naaonjoainuri coaunera- Cana Coaunerate, jataain nelateein nihane coina, cocoainaain rai letono Jesoso letoaelu. Acate, nii cocoainanacaihuri rai teeichene jana, jiaanena jeriha coberanadoro Filatone saijieein, caohateein jianena jereneeichelu. ");
INSERT INTO uraNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nitohaneein caohachanejesina ichara nihanatiinte, jianena jeriha Filatone jana, caohateein neeichelu. Coinanaa, nechu aansai sonajaaineein nenaa jianeratequichelu. ");
INSERT INTO uraNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nitohaneeinte, nii ichaonaa tera sohin joaerateeichene jana, ichatelu Cana Coaunera. Canacaanuna, nii ichatiha Cana Coaunerane coaaraneein nihacaanu. ");
INSERT INTO uraNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nii Jesoso corenihate nerautae caa cacha- inaraacha coitucuicha. Jesosohacha corenihate, caoachanainejeein nerautae caa cacha inara notaracaaera,” naain jetao: ");
INSERT INTO uraNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Acanihane coitucueneeichene jaun, sohin joaerateeichelu inara curuanaacuru aina jiniiquine coitucuhanu raotojoeeincha canejeraauru. ");
INSERT INTO uraNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nitohaneein situhin nihanetene. Inae nere bera inoaensihuru que, ‘Naaonjoaaite cairichaaeriin inae nirijieein cuaajeein sohin jaoha cuurureeincha,’ naain nere bera inoaensihuru que beratihalu inoaenlu Cana Coaunerane jaunte, Cana Coaunera ere nainaane coina, nitohaneein nii inoaenlu- inara coroatajaneraaunu que- niicha letoanaa jereilu Mesihasi teeichelura. ");
INSERT INTO uraNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Aihane jaun, chatohaneein baaso ichaain neeichene, suujuelanaala jitariin beein, jiaaneein Cana Coaunera ere tonoraain neeuchete caseteco coaraquichene rai neeichene caje inara ichotemiin- Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Chaen techu nitohaneein neeichene, nii inoaenlu- inara coroatajaneraaunu que- niicha letoanaa jereilu- Mesihasi- Jesoso letoareein nacoauneeincha. ");
INSERT INTO uraNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nete jaiti itolere rucuheca Cana Coaunerane reentiaan, dedeeu niha cureein nere bera inoaensihuru que, inoaenlu beratiha Cana Coaunerane tocohaneeincha. ");
INSERT INTO uraNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nii quete, cana inoaensihuru rai: ‘Caa nere beraneein caletohane rijijieeinte, inara caje nacoauneein rai nere bera letoareein Cana Coaunerara. Itolere que tonaane, nere tonoraain neeuchera. ");
INSERT INTO uraNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nere tonorana jeriheichurute, caohachanainejeein nitajiha cuurureeincha.’ naain belu cana inoaensihuru rai Moisesa. ");
INSERT INTO uraNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Caritiinte aitoroaeetoorelu Cana Coaunera ere bera inoaensi- Samoeri caje coaauneein satiin nere bera inoaensihuru, catohaneein turuhane quera. ");
INSERT INTO uraNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nii jaun inarate, nii nere bera inoaensihuru que beratihalu Cana Coaunerane rijijieein, nii naitoonjoa sirichaneein neeichera. Chaen techu, inoaenlu cana foeratera inoaensi- Abaraaun rai: ‘Satiin caa chauratane que nenacaaurune, caohachaain teratiha cureeunni ii nefoerateeuru coreniha.’ naelu Cana Coaunera, cana foeratera inoaensi- Abaraaun rai. ");
INSERT INTO uraNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Niritohane jaunte, oo caje nii Calaohi ichateein, jauriaanejeein inara rene letoaelu Cana Coaunera, nii coaraain neeichene, baaso ichaaechajeein neeichene jianeein neeichene, inara coroatajaneein nihane coinara,” nae jetao Fedoro, nii cuu nenacaauru cachaauru rai. ");
INSERT INTO uraNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Niritiin jaiti cachaauru rai ereereeca Fedoro aina Joaanne jana jetaote, tajiha turuha uure saseredotecuru, Teenforo beraihurera- folisihacuru- curuaanaa, sadoseeocuru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Turuuruhane jana: “Coaraanachuinti oo caje ichana nainiha cachana jaun, oo caje ichanaalu Jesosone. Nii jaunne esinae rauhijiriin oo caje ichana nainiha cachane coitucuhacaanu,” naain cacha relaauruha Fedoro aina Joaanne aonajeeuruhana jaun jetaote, obaaecure sadoseeocuru: “Nihei chunei onaa ichatera. Nihei Cana Coaunera niha natiin onaa ichatena nainiheita,” naain cachaauru relaauruhana jaun. ");
INSERT INTO uraNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nitohaneein obajeein jetaote, Joaan aina curuataain Fedoro mucuhin amaain, inae sonaina nihana jaun, caresero cuhane tenajaain cuu janoaeratenajaaure. ");
INSERT INTO uraNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nii inatiin jetaote, atiin esenetaaure nii cuu aonajeeurera- arajii cachaauru. Nii jaun jetaote, ita que jooraain quichaauru nejesina janijiin, saoqui oharaancaelalajeein Jesocurisito esenetaeraneein neeure, enecuru, canaanaihuru, naaonjoainuri janijilanaala. ");
INSERT INTO uraNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nii cojoanoo jetaote, nii que ita rai ereeuru coina, Jerosaleeun ita taojiaaure Jorioocuru curuaanaacuru, satiin acaauru bichauhenaauru, chaen Cana Coaunera Quiricha Inoaensi que cacha relaaurera, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chaen jetao techu, cuu neeure saseredotecuru curuaanaacuru Anasi, chaen Caifasi, Joaan, Alejaandoro, satiin nii saseredotecuru curuaanaacuru araaichuru, naaonjoainuri. ");
INSERT INTO uraNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Acaauru jetaote, caresero caje rocoeratenajaain, Fedoro aina Joaan raerateein, acaauru cataaun tenajaain acaauru rai: “Cha cocoainanacaineein inara tihane aina caa aaicheta. Cha corenihata,” naain Fedoro aina Joaan caje bajaauruhane jana jetaote, ");
INSERT INTO uraNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","coroatajaniha Cana Coaunera Suujuene jaun, cha que casilanaala jetao: “Aonacuche satiin caraaichuru curuaanaacuru, satiin Isaraeli cocoaichacuru bichauhenaauru. ");
INSERT INTO uraNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nii cunaitenaa rai caohacha ichara coitucunaa jereein bajaaichene jaaunna, inara rai berichaanuhincha, coitucuhin neeiche satiine coinara. ‘Nitohaneeinna nerautaa caa cachate.’ naain coitucuhichene jerena caaunra. ");
INSERT INTO uraNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Satiin aonajeeichene urichoone berichaanuhin, satiin Isaraeli cocoaicha neeichene coitucuhin neeichene coinara. Nii coroso que terateein- inaraacha sohin- inaraacha joaerateilu Nasarete cocoaicha Jesocurisito- oo caje Cana Coauneracha ichatei corenihate, caohachanainejeein cunai caje nerautaain, caa canaacaanu aina inara acatiha ne caa cunai caje nerautanaa cachara. Inae satiin, inara nota que, caohachanainejeein nerautaane coaraquichera. ");
INSERT INTO uraNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Caa cacha rautaera- Jesosote, letoae Cana Coaunera, satiin cacha coroatajaneraaunu que niqui. Nete, nere aonana jerelanaala, que jaolequiin neeichera. ");
INSERT INTO uraNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Acate letoae Cana Coaunera, nabana nitajeein nihacachene coataara. Nihei chunei, leeocha cacha tihei Cana Coaunera, caa chauratane queta. Leinjiin acaachate, chabana nitajenaa charanejeein nihacache jaanu teraanu que- letononeein nenaa ne, itolere baaso caje- jianacoo cana mitaeraanu quera,” naa acaauru rai Fedorona jaun jetaote: ");
INSERT INTO uraNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","“Caaurute, Jesoso aina amuhemujeein nerelanacaauru nera. Coatiha jataain cana tocohaneein, caohatiin- quiricha inaaurera niheita. Nete jataain coitucuera rijitojoeein, erenaa inaaure caa cachaaurura,” naaure cojoaelatiin nii cocoainanacaihuru, cha que casilanaala ereeuruha Fedoro aina Joaanne jaun. ");
INSERT INTO uraNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Chaen, cuu acaauru aina, chujuhecoha nii cunai caje nerautanaa cachana jaun jetaote, nii chaque tonaain erenaa nainecurene. ");
INSERT INTO uraNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nii jaun jetaote, nii ita taojiaauruhana jaan caje, mitaeratenajaaure. Nitohaneein, mitaeratenajaain jetaote, cuu nejesinajeein, ita cotaicha rijitiin: ");
INSERT INTO uraNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Cha charihahacache, caa cachaauru ainata. Itolere caa Jerosaleeun nenacaauru cachaaurute, cojoelanaacojoai ichaain, caa leinjiin cacha rautaauruhane coitucuurera. Nii que, nainihei, ‘Casaje.’ naain, irihacacheneta. ");
INSERT INTO uraNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Coanete, taeneein cuajeein, Jesoso que- cacha relaauruhane coataa, nii caohatichaachete jianecurumiin, nabana chunei cacha rai, Jesoso que ereein neeuruhane coataara,” naain jetaote, ");
INSERT INTO uraNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Fedoro aina Joaan cotijiaain: “Jiaonriha Jesoso coacuhin que ereerejeein chunei cacha relaain neeichenera. Nii jianeechacuchera,” naauruha acaauru raine jana jetaote: ");
INSERT INTO uraNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","“Inara suujua coaracuche jauriaanejeeincha. Inasiina Cana Coaunera ere tonoraacaanune jianeein inara ere tonorarihacaanu, Cana Coaunera ere tonoraacaanune colaihaje tacaainta. ");
INSERT INTO uraNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nainihaacaanu nii que ereerejihacaanune jianichaanuneta. Inasiina, canacaanu uricho que- canacaanuhacha aonai, canacaanuhacha coarai, canacaanuhacha coitucui, naojoaihunri que cachaauru relanaa jianerihacaanuta,” naain tonoranaacuruha Fedoroorune jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","cacha relaauruhane caohateein: “Nenacaen nitohanai ichaain, sacuhichenena, jelai choae jauhecotojoeriin inara casetecarichaanuhincha,” naaure jetao, acaauru rai cocoainanacaihuru. Nitohaneein jetaote, casetecanajaelanaala, nirijieein jianenaacure. Jianenaana jerecuruhi jetao niqui. Ne jetaote, nii cacha rautaauruha Fedoroorune coaraain, Cana Coaunera coroaecuruha satiin ecu nenacaauru cachaaurune jaun jetao acaauru jianecure. ");
INSERT INTO uraNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nii cojoelanaacojoaain nerautanaa cacha jetaote, jenachoonca jaanaca amurijiri. ");
INSERT INTO uraNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nitohaneein jianenaacuruhana jaun jetaote, nii neeuruha acaauru leeochaaurune jaun, turuha cuure Fedoro aina Joaan. Cuu acaauru rene turuhin jetaote, “Naaonjoaainte, canacaanu teeure canacaanu casataain, cana araaichuru bichauhenaauru, saseredotecuru curuaanaacuru ainara,” naain jitariin, nii acaauru leeochaauru rai beeuruhane jaun jetaote, ");
INSERT INTO uraNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","cuu jiniiquiin, aonajeeuruhane baiha: “Cana Coaunera, iite cana janonaa coauneraneein neeicha. Iite cana rai dede, chauratane, cucuana, naaonjoaain coauneraneein neeicha. Iite itolere cautenurijihuru coauneraneein neeicha Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Iite, ii Suujue que berateein, ii ere bera inoaesi Rabiri que berateein: ‘Chanuna joaereein rai suujua auhacaain nererojoecaaure laurilauri nenacaauru cachaauru. Chanuna nitohaneein baasoneein suujua coaracure inacojoeein cachaauru. ");
INSERT INTO uraNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Chaen techu Cana Coaunera amurijiriin nenaa coacuhin, nii niicha letoai Mesihasi que nejerateeure cana rai chauratane coaaraneein que nenacaauru aina reycuru.’ naain aitiin berateeilune jaun, niritiin bihalu ii ere bera inoaesi Rabirine rijijieeinte, ");
INSERT INTO uraNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Romanocuru curuaanaacha tei Jorioocuru curuaanaa Foonsio Filato, Jorioocuru rey Erodesi, chaen nejelau atane nenacaauru, chaen Isaraelitaauru, naaonjoainuri, caa neseeu netaojiaain nejerateeure, nii ii jerenohin icharaanu que- ii letono Jesoso- iicha janijii iicha rai Mesihasi ainara. ");
INSERT INTO uraNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nitohanihane coina, inae inoaelu coacuhin ichaailune rijijieeinte, aihurera. Nitohaneeinte, aitohine nainaaurera Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Aihana jaun, enene caje coauneein, canacaanu casataauruhane coaraaine, jelai amuritoheriin canacaanu coroatajaneeuna, cha que casilanaala, cachaauru rai, ii ere beebejihacaanura, Cana Coaunera. ");
INSERT INTO uraNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chaen, laraajiin itolere ichana nainichaanune jaannu teeu, canacaanu rai, cunaitenacaauru rautaain, cojoelanaacojoai ichaain naaonjoacaanune coina, esinaae rauhijiriin nii ii letono Jesoso letononeein nihacaanune coaracuruha satiin cachaaurune coinara,” naain jetao jiniiquiin Cana Coaunera bajaaure. ");
INSERT INTO uraNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Inae Cana Coaunera bajaauruhane nainaauruhane rijieeoritiin jetaote, nerurujuaa nii netaojiaauruhana jaan jelaiine jana, acaauru suujuau neeoritiin, acaauru suujua lararajiae Cana Coaunera Suujue. Nii aina jetaote, chaque casilanaala, chaque tonajelanaala, satiin cachaauru notaracaae laraajiin, Cana Coaunera Ere beebejeeure. ");
INSERT INTO uraNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Satiin Jesoso esenetaeraauru jetaote, jataain arajiin ita aina neeuruhane saijieein, ita suujua rijitojoeein coacuhin jetao, “Coatiha leeinjiin cana rainuhachanu que, nihei caa canaacha sirii rucuheleta. Satiin cana raineeinte nera.” naaure jetao, satiin, ita rai. Nitohaneein jetaote, satiin raineein ne nii itolere acaauruhacha sirii. ");
INSERT INTO uraNT_v