﻿USE sofia;
DROP TABLE IF EXISTS sofia.upv_vpl;
CREATE TABLE upv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES upv_vpl WRITE;
INSERT INTO upv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ngel evi naul ne metka se Iesu Kristo metka se Devet, ko metka se Epram. ");
INSERT INTO upv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ko nise jinibb nir re metka nen: Epram womu jer. Ko Epram evesi Aesak, ko Aesak evesi Jekop, ko Jekop evesi Juta ko niaken sen nir. ");
INSERT INTO upv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ko Juta evesi Peres ko Sera, nuru ko tasu se nuru ko Tamar; ko Peres evesi Esron, ko Esron evesi Ram. ");
INSERT INTO upv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ko Ram evesi Aminatap, ko Aminatap evesi Nason, ko Nason evesi Salmon. ");
INSERT INTO upv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ko Salmon evesi Boas nga tasu sen Reap, ko Boas evesi Opet nga tasu sen Rut, ko Opet evesi Jese. ");
INSERT INTO upv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ko Jese evesi Numal Devet, ko Numal Devet elesi luwe kele nesevin se Uria, ko evesi Solomon. ");
INSERT INTO upv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ko Solomon evesi Reopoam, ko Reopoam evesi Apia, ko Apia evesi Asa. ");
INSERT INTO upv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ko Asa evesi Jeosapat, ko Jeosapat evesi Joram, ko Joram evesi Usia. ");
INSERT INTO upv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ko Usia evesi Jotam, ko Jotam evesi Eas, ko Eas evesi Esekia. ");
INSERT INTO upv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ko Esekia evesi Manasa, ko Manasa evesi Amon, ko Amon evesi Josia. ");
INSERT INTO upv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ko Josia evesi Jekonia ko niaken sen nir. Renge daron nen ko aron tertere nir arteka twenir van re Bapilon e suri nuval. ");
INSERT INTO upv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Arteka twenir jile osuw, ko Jekonia evesi Sealtiel, ko Sealtiel evesi Serupapel. ");
INSERT INTO upv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ko Serupapel evesi Apiut, ko Apiut evesi Eliakim, ko Eliakim evesi Asor. ");
INSERT INTO upv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ko Asor evesi Satok, ko Satok evesi Akim, ko Akim evesi Eliut. ");
INSERT INTO upv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ko Eliut evesi Eliesar, ko Eliesar evesi Matan, ko Matan evesi Jekop. ");
INSERT INTO upv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ko Jekop evesi Josep diwen se Merri, nga mivi tasu se Iesu nga marveruse Mesaea. ");
INSERT INTO upv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","M̃itipatun re metka renge Epram, musuwsuw re Numal Devet, evi metka esngavöl drromon ivij (14). Ko m̃itipatun kele renge Devet, musuwsuw re daron nga marteka twenir van re Bapilon, evi metka esngavöl drromon ivij kele. Ko m̃itipatun kele renge daron nga marteka twenir van Bapilon mijpari daron nga Kristo m̃iak e, evi metka esngavöl drromon ivij kele. ");
INSERT INTO upv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Kristo errmali iel ngatan erpel. Arlingi ore Merri, Iesu tasu sen. Ko setewor evan ji diwen sen Josep, ko Merri etaole nga m̃ilesi nga ni m̃itetaur. Suri Nem̃in On ko esilvi ni. ");
INSERT INTO upv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ko Josep, Merri diwen sen, evi jinibb nga mumomsawos m̃irres, ko orrorrmi p̃ilinglingi silveni nesen sen bbong; omusus puwrai tevi jinibb nir, tuloli Merri non tiwis. ");
INSERT INTO upv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ko daron nga murrorrmi nanu ngel e nir, ko anglo san se Atua eplari jin renge bori san ko owrai owra “Josep, nik kuvi metka se Devet, sete kupmetutu kuptekai ko wor Merri pivi nesevin som. Suri bipi nga musloi ngok, Nem̃in On ko elai tevi. ");
INSERT INTO upv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mian ko vinok Merri pia-wosi natun norman san, ko kupa-lingi nisen piwajie Iesu. Suri ni pia-tekai tweni jinibb sen nir renge nololien ser.” ");
INSERT INTO upv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nanu ngok eplari jile osorsan tevi nale san se Atua nga propet sen san owra wowomue tuwi pa: ");
INSERT INTO upv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nesen m̃elakel osloi bipi mian ko pia-wosi natun norman san, ko para-lingi nisen piwajie Emanuel.” Ko nais nen arieni erpel: “Atua eptevi kerr.” ");
INSERT INTO upv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mian ko Josep emra re meturen sen; ko ololi suri erpe nga anglo se Numal muwrai tevi ni, ko etkai nesevin sen.");
INSERT INTO upv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ko sete evan jin ejpari daron nga muwosi natun norman m̃iak. Ko daron nga m̃iak jile musuw, ko elngi nisen ewajie Iesu. ");
INSERT INTO upv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu eak renge Betliem ne Jutia, ko renge daron nen, Erot evi batu numal. Ko sete epriv, ko jinibb sopor nga norongwosien ser milep arivel re vanu m̃inij san nga muto ngasu renge Is, ko arini Jerusalem e. ");
INSERT INTO upv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ko arsusi arwera “Nibeni bipi wel nga m̃iak nga pivi numal se m̃eri Isrel nir? Namlesi moju sen eplari, ko namini tweni nablotoe ni.” ");
INSERT INTO upv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Daron nga numal Erot murnge nanu ngel e ko eririr elep, ko erpok kele re m̃eri Jerusalem kele nir aririr elep kele. ");
INSERT INTO upv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ko Erot everus kortoni jinibb nga marlelep ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir, ko osusi tevir owra “Nibeni lat nga Mesaea p̃iak ren?” ");
INSERT INTO upv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ko nir arij weli ni, arwera “Mesaea p̃iak renge Betliem re Jutia. Suri nale san se Atua nga propet san muli wowomue tuwi ngel, owra ");
INSERT INTO upv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ko nik, Betliem re Jutia, setete kuwelili renge jinibb nga marlelep nir renge Jutia. Natum san nga pia-pelari jim pivi numal nga pia-metmete jinibb suk nir m̃eri Isrel.’” ");
INSERT INTO upv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mian ko vitunen vajin numal Erot everus silveni bbonge jinibb nen nir ne Is vini ji ni, ko osusi tevir owra “Moju nen eplari re daron sev?” ");
INSERT INTO upv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Arwera suri jile tevi, ko Erot ekrekrasir owrai tevir, “Erres, kapan kappej bipi wel nen p̃irres, ko poro kaplesi ni, ko kaploli inu borongwose; ko inu kele ban bolotoe ni.” Ko Erot okoni twenir arivel van Betliem e. ");
INSERT INTO upv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ko daron nga marivel kele vajin, ko arlesi kele moju nga; ko artaole, ko arir temijpal. Ko moju nga owowomu kele nir, ko nir arvijuri. Arvijuri moju nga mian ko oto jer mare momsawose naim nga Iesu m̃iak ren. ");
INSERT INTO upv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ko daron nga maran loloim e, arlesi bipi wel nen nuru tasu sen Merri. Ko arjipa van ngatan ko arlotoe ni. Arlotoe jile ko arsaro van renge nolo narr ser, ko arlai merrenien ser tevi ni, arla gol ko prangkinsens ko mir. ");
INSERT INTO upv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mian ko vitunen vajin arlesi bori san nga Atua ewer orer sete parkali lweni ji Erot e. Ko arkali lweni re sel m̃inij e van renge vanu ser e. ");
INSERT INTO upv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ko daron nga lartul nga norongwosien ser milep marivel e vajin, ko anglo san se Atua eplari ji Josep renge bori san ko owrai tevi owra “Kuptur imare kupwosi bipi wolok ko tasu sen, kapwolu van Ijip mun e. Ko kaplik iok pijpari daron nga bea-wera lweni nale tevim. Suri Erot owra pirevji pini, ko otomori pa pipej.” ");
INSERT INTO upv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Daron nga anglomuwrai jile tevi Josep nat nga mupong nen, ko Josep otur imare, owosi bipi wel nen, ko nir tasu sen arwolu van Ijip mun e. ");
INSERT INTO upv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ko arlik iok ejpari nga Erot mimij. Ngok eplari osorsan tevi nale se Atua nga propet sen san muwrai wowomu pae tuwi, “Inu beveruse natuk piplari Ijip ko vini.” ");
INSERT INTO upv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mian ko vitunen vajin Erot orongwose jinibb ne Is nen arkerkerasi, ko ololar lengleng. Ko okoni jinibb ne nuval sen parevji pini bipi norman nir re Betliem ko rrale p̃etp̃eti Betliem, nga sia ser ejpari eru ko sia ser mulwi vitan. Ngel osorsan tevi daron nga jinibb ne Is marwerai tevi. ");
INSERT INTO upv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ngok eplari erpe nale se Atua nga Jeremaea muwrai wowomue tuwi: ");
INSERT INTO upv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Arunge dingen san renge ngaim ne Rama, arting nga arting lengleng. Rejel ko etengsi natun, ko omusus parjinge, suri natun armij pa osuw.” ");
INSERT INTO upv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mian ko Erot emij vajin, ko anglo se Atua eplari kele ji Josep renge bori san renge Ijip ko owrai tevi, owra ");
INSERT INTO upv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Kuptur imare, kupwosi bipi wolok, ko kami tasu sen, kapluwi van re vanu Isrel kele e. Suri m̃er nga muwra pirevji pini bipi wolok emij pa osuw.” ");
INSERT INTO upv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ko Josep otur imare ko owosi bipi wel nen, ko arluwi van re vanu Isrel e. ");
INSERT INTO upv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mian ko Josep ornge kele nga Arkelaos ela wani milnge tata sen Erot, evi numal ne Jutia. Murnge ko emtutu pian iok e. Mimtutu pian iok e, ko elesi bori san kele nga Atua ewer ore sete pian, ko arwolu van re vanu ne Galili e. ");
INSERT INTO upv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ko arini arlik renge ngaim san nga nisen Nasret. Ngok eplari wor osorsan tevi nale se Atua nga propet sen san muwrai wowomu pae suri Kristo, “Ni parveruse m̃eri Nasret ko.” ");
INSERT INTO upv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mian mian ko vitunen Jon Baptaes evini ewerwer re lolo merwer ne Jutia, owra ");
INSERT INTO upv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nolo kami pulululwi, suri otomori le pa batun vanu ne melrin p̃irrmali.” ");
INSERT INTO upv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Suri Jon evi m̃er nga Atua m̃ijilwer suri renge nale ngel nga propet Aesea muli tuwi pa, muwra “Jinibb le san ekail renge lolo merwer, owra ‘Kaploli lilane sel se Numal puto metmet terai. Kaploli mesekle sel sen nir parmetet p̃irres.’ ");
INSERT INTO upv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon sunsun sen erpe propet Elaeja tuwi. Ori nevlu kamel, ko netatuw sen arloli nevlu buluk e. Ko re devjen nga re nanen sen e, elai nato nga mok-rowrow re mösmös ko narrlu sukabak nga m̃ierri orivi nanen sen. ");
INSERT INTO upv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ko nir jijle ne Jerusalem ko ne Jutia ko rrale nuwi seser ne Jortan arivel ko arini jin. ");
INSERT INTO upv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Arini jin, ko daron nga marwera tweni nololien ser, ko Jon epaptaes nir renge nuwi seser ne Jortan. ");
INSERT INTO upv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ko daron nga m̃ilesi Parasi ko Satusi, nga marivi jinibb nga marlelep re m̃eri Isrel nir, ko Jon owrai tevir: “Kamivi jinibb nga kamsij O! Kamirpe metka ne num̃et. Ko weta, kami kamrongwos kapwolu asi ko renge lolaren se Atua nga pia-vini? ");
INSERT INTO upv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Poro nolo kami pulululwi, rrek erres kapviseni wenen nen. ");
INSERT INTO upv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sete kapwerwerai tevi kami: ‘Epram evi metka se kerr, ko ngok rramivi pa jinibb se Atua ko.’ Nu nuwrai tevi kami: Atua orongwos p̃ilai nevöt nawon ngel nir ko p̃irienir parivi metka se Epram. ");
INSERT INTO upv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lelingen ngel artori batu deli oto metmet nga parta ototvi lap̃e nai nir; ko nai jijle nga marsij, sete wener marres mun, parta twenir parwirr nir van renge nabb nga m̃in. ");
INSERT INTO upv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nu nupaptaes nuwi e kami, kami nga nolo kami mulululwi. Ko san nga pivivitu suri inu, ni ean wor mare renge inu. Inu sete nurres rragrrag nuvter re b̃esai but sen nga m̃irae. Ni pia-paptaese kami re Nem̃in On ko nabb. ");
INSERT INTO upv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ni otori nai juljule san renge nevren nga pujlujle wene wit e nir, ko dokolvir parwirr lingi jelangir; ko p̃iser kortoni jelangir p̃ilngir renge b̃ep̃eim sen, ko pusli dokolvir renge nabb nga sete san orongwose pivsi pini.” ");
INSERT INTO upv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Vitunen Iesu evel re Galili vini re nuwi seser ne Jortan, pian ji Jon p̃ipaptaese ni. ");
INSERT INTO upv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ko Jon owra p̃iwer ore ni, owra “Erpese nik kuvini jik nga inu b̃epaptaese nik? Erres ma poro nik kuppaptaese inu.” ");
INSERT INTO upv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ko Iesu erij weli, owra tevi ni: “Puto pirpok ko wor, nga rroporloli nanu jijle nga Atua mimrreni parpelari.” Ko ni epaptaese ni vajin. ");
INSERT INTO upv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ko Iesu daron nga m̃ipaptaes jile, evel lingi nuwi evesane, ko elesi melrin etp̃ir; ko elesi Nem̃in se Atua ojubbul erpe wum̃er, ko evini esilvi ni. ");
INSERT INTO upv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ko drrelan san eplari re melrin, owra “Morok evi natuk nga memrreni, nurnge erres elep suri ni.” ");
INSERT INTO upv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Daron nga Jon m̃ipaptaes jile Iesu musuw vajin, Nem̃in On etkai Iesu van re lolo merwer nga Demij purrowrrowe ni. ");
INSERT INTO upv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ko Iesu elngi tweni nanen, owra pulot van ji Atua. Ko mulot mian mian mijpari vajin nabong ngavöl ivij (40), vitunen ko ornge numer eaji lenglenge. ");
INSERT INTO upv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ko Demij, nga mok-rrowrrowe jinibb, evini jin, owra puloli Iesu pivitan. Ko owrai tevi ni: “E, nik kuvi pa Atua natun, ko numer ajim. Kupwerai tevi nevöt nawon ngel nir, parivi niv.” ");
INSERT INTO upv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ko ni erij weli ni, owrai tevi ni, “Ejki, sete bololi, suri aruli erpel renge Nale On se Atua, ‘Jinibb sete orongwose pimaur kis e niv kobbong; pimaur e nale jile ngok nga miplari renge jingo Atua.’” ");
INSERT INTO upv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Vitunen Demij etkai Iesu van renge ngaim nga muon renge Jerusalem, ko elngi renge drromdrromo Naim On mare jer, ");
INSERT INTO upv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ko owrai tevi, “E, nik kuvi pa Atua natun. Kuprow jubbul vitan. Suri aruli erpel renge Nale On se Atua: ‘Atua pia-koni anglo sen nir, parwosinik renge nevrer mare, suri nik tukjilaklak wos b̃elam renge nevöt.’” ");
INSERT INTO upv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ko Iesu owrai tevi: “Ejki, sete bololi, suri aruli kele erpel renge Nale On se Atua: ‘Nik sete kuprrowrrowe Numal Atua som te, pijki.’” ");
INSERT INTO upv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Vesan kele Demij etkai Iesu van re botwen san nga muwu mare jer, ko evisenie ni batun vanu jile ne iel ngatan nir, ko nosrövien nen nir. ");
INSERT INTO upv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ko owrai tevi, “Poro nik kupjipa van ngatan kuplotoe inu, ko bea-lai nanu jile ngel nir tevim.” ");
INSERT INTO upv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ko Iesu owrai tevi ni, “Kupruj ngasu, Demij, suri aruli erpel renge Nale On se Atua: ‘Nik kuplotoe Numal Atua som, ko ni kobbong nik kupmajing sen.’” ");
INSERT INTO upv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Muwrai jile tevi, ko Demij elinglingi ni. Ko anglo sopor arini ji ni ko armetmete ni. ");
INSERT INTO upv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Vitunen Iesu ornge nale nen nga marlingi Jon renge naim ne nekaien, ko ni olwi van Galili e. ");
INSERT INTO upv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mivini Galili, ko setemun evan Nasret, elinglingi Nasret ojpon ko etajer van Kapaneam e, ko elik ie. Kapaneam evi ngaim san nga muto devje nuwito nga milep nga mubbun rrerrale nisen Galili, renge vanu ne metka se Sepulon ko Naptali. ");
INSERT INTO upv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngok eplari osorsan tevi nale san se Atua nga propet Aesea muli tuwi pa, owra ");
INSERT INTO upv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Vanu se Sepulon ko vanu se Naptali re devje nuwi seser ne Jortan van re devjen nga ngalu e renge dis; jinibb nen nir arivi jinibb ne vare. ");
INSERT INTO upv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Arivi jinibb nga marlik renge nemalik, mian ko arlesi vajin moron nga milep. Ko jinibb nir nga marlik renge vanu ne namol ne mijen, moron ngok eplari jir.” ");
INSERT INTO upv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Renge daron nen, Iesu etipatun nga m̃iwerwer, owra “Nolo kami pululwi, suri otomori le pa batun vanu ne melrin p̃irrmali.” ");
INSERT INTO upv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Renge nabong kele san, Iesu evel sere renge jeli nuwito ne Galili. Ko elesi niaken eru, Saemon nga marveruse Pita, ko Antru. Ortuwe niva renge nuwi, suri orivi jinibb nga morok-revrevei nai. ");
INSERT INTO upv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ko Iesu owrai tevi nuru, “Kopor-vijuri inu, ko inu bea-loli kamru kopor-ivi jinibb nga morok-revrevei jinibb.” ");
INSERT INTO upv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ko ngavilvil nuru orlinglingi niva se nuru ko orvijuri ni. ");
INSERT INTO upv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ko Iesu evel rujruj kele sopon ko elesi niaken kele eru, Jemes ko Jon, nuru tata se nuru Sepeti renge drrav ser, arilile niva ser. Ko everuse nuru. ");
INSERT INTO upv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ko ngavilvil nuru orlinglingi drrav ko tata se nuru, ko orvijuri ni. ");
INSERT INTO upv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ko Iesu evel jile re Galili, ko ok-visviseni renge naim gortien ser, ko ok-werwer suri nale nga m̃irres suri batun vanu ne melrin. Ko ok-loli nir nga marmesi mesien lele arres luwi. ");
INSERT INTO upv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mian ko nosp̃en sen arsup̃e renge Siria jile. Ko jinibb nir arwosi jinibb jijle nga marmesi vini jin. Armesi mesien lele: sopor niber arerer, ko sopor demij esisilvir, ko sopor nem̃i nai ololir armijmij, ko sopor nga niber sopor mimij. Ko ololi nir arres luwi. ");
INSERT INTO upv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ko delung elep arvijuri ni, jinibb ne Galili nir, ko Dekapolis nir, ko Jerusalem nir, ko Jutia nir, ko nir nga marlik van devje Jortan e. ");
INSERT INTO upv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Daron nga Iesu m̃ilesi delung nir, ko otongsa van mare renge botwen san ko elik ngatan. Ko jinibb sen nir arini jin, arlik rrale. ");
INSERT INTO upv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ko ni esa jingon etipatun evisvisenir owra ");
INSERT INTO upv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Neiren renge nir nga norrorrmien ser mian ngatan, suri batun vanu ne melrin evi pa se nir ko. ");
INSERT INTO upv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Neiren renge nir nga marok-taure dauren ne nololien, mian ko Atua pia-jinge nir ko. ");
INSERT INTO upv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Neiren renge nir nga nolor maran ngatan jer, suri mian ko dan pia-ivi se nir ko, ko nanu jile nga marto rengen. ");
INSERT INTO upv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Neiren renge nir nga marmerrmerreni nga murrun nga m̃irres puto p̃irres, erpe jinibb armerrmerreni nanen ser ko nuwi num̃er, mian ko Atua pia-la nanu nga marmerrmerreni tevir ko. ");
INSERT INTO upv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Neiren renge nir nga marok-telasi jinibb, mian ko Atua pia-telasi tweni nir ko. ");
INSERT INTO upv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Neiren renge nir nga nolor marwokwok, mian ko nir para-lesi Atua ko. ");
INSERT INTO upv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Neiren renge nir nga marok-loli demat, suri mian ko jinibb nir para-veruse nir Atua natun ko. ");
INSERT INTO upv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Neiren renge nir nga jinibb marloli m̃isij tevir suri arloli nanu nga marres, suri batun vanu ne melrin evi pa se nir ko. ");
INSERT INTO upv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ko neiren renge kami poro jinibb nir parwor suri kami, ko poro nir parloli p̃isij tevi kami, ko poro nir parkerkeris p̃isij tevi kami, parwera nanu lele nga marsij suri kamivi inu jinibb suk nir. ");
INSERT INTO upv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kami kap̃ir pilep, suri nowli kami elep re melrin, osorsan tevi nowli propet san. Suri propet nir nga marwowomue kami tuwi, jinibb arloli esij ko pa tevir erpok. ");
INSERT INTO upv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Murru kami nga m̃irres arirpe sol se jinibb jijle nir nga marok-lingi re nanen ser. Ko poro nga sol dilten nga m̃irres pivel lingi jijle, ko p̃irres luwi pirpese ko? Erres re parlai ko parsor tweni, ko jinibb parivivel ren parbbötbböt ren vajin. ");
INSERT INTO upv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ko murru kami nga m̃irres erpe moron se jinibb jijle nir. Moron sete orongwos puto teptepi; osorsan tevi ngaim nga milep san nga muto limjer mare re botwen. ");
INSERT INTO upv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ko poro jinibb san pusli nasul, ko sete orongwos putori ngatan; putori mare sopon, ko puloli jinibb jile parlesi moron. ");
INSERT INTO upv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kami kamivi nasul nen. Moron se kami pimor wor van ji jinibb jile, puloli jinibb jijle parlesi majingen se kami nga m̃irres, ko parsurövi Tata se kami nga m̃ilik renge melrin. ");
INSERT INTO upv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Sete kaprrorrmi inu nuvini tweni bolokloksi nale ne nesesreien nir ko nale se propet nir nga marto re Naul On. Inu sete nuvini tweni bolokloksir, ejki, nuvini tweni bololir parpelari le. ");
INSERT INTO upv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nuwretun nuwrai tevi kami, pia-jipari daron nga melrin ko iel ngatan pora-asi, sete bebje nale nesesreien san p̃iasi nawon, pia-jipari nga nanu ngel jijle nir para-pelari. ");
INSERT INTO upv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Poro jinibb p̃isan putor otvi nale nga welwelili jer nen san renge nale nesesreien, ko pivisvisenie jinibb nga parloli pirpok kele, m̃ernen parveruse pivi jinibb nga welili jer renge batun vanu ne melrin. ");
INSERT INTO upv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Inu nuwrai tevi kami, kaploli nanu nga parres, parasie jinibb nevisvisenien ne nale nesesreien nir ko Parasi nir. Poro pijki, setete kami kamrongwos kapan renge batun vanu ne melrin. ");
INSERT INTO upv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kami kamrunge pa nga marwerai pa tevi b̃irtera ne tuwi nir renge Naul On, ‘Sete kuprevji pini jinibb pisan. Ko poro jinibb san pirevji pini jinibb pisan, m̃ernen pia-sij ren re daron nga Atua puwra suri lat nga puto suri tevi jinibb nir.’ ");
INSERT INTO upv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ko inu ma nuwrai tevi kami vajin, Poro jinibb p̃isan pulolarsi tuwan kobbong, m̃ernen pia-sij ren re daron nga Atua puwra suri lat nga puto suri tevi jinibb nir. Ko poro jinibb p̃isan puwrai tevi tuwan, ‘Kulengleng,’ m̃ernen pia-sij ren re nosp̃en se numal nir. Ko poro jinibb p̃isan puwrai tevi tuwan, ‘Kuvi jinibb nga kumloli sagraut nanu,’ m̃ernen pia-sij ren renge nabb ne norongen nga m̃isij. ");
INSERT INTO upv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ko erpok, daron nga kumla merrenien som vini re nawot nga marok-sulsul ren tevi Atua, ko iokporo kuprrorrmi jipari nga nik kumloli tuwam ololar, ");
INSERT INTO upv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kuplingi merrenien nen puto mun, ko kupan kuploli p̃irres tevi tuwam, pusuw, ko kupluwi vini kele kupa-la merrenien som vajin. ");
INSERT INTO upv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ko poro nga jinibb san nga kumloli mulolar p̃itkai nik nga koporan re nosp̃en se numal nir, kupsaro pingavil, kuploli p̃irres tevi ni. Poro mijki, ko ni tia-lingi nik tevi numal nga mok-wera suri lat nga puto suri re jinibb nir, ko ni tia-lingi nik tevi jinibb ne naim ne nekaien, ko m̃ernen tia-lingi nik renge naim ne nekaien. ");
INSERT INTO upv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nuwretun nuwrai tevi nik, sete kurongwos kupivare re naim ne nekaien pijpari daron nga nik kupkele lweni nevöt nen jijle. ");
INSERT INTO upv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ko kami kamrunge nga marwerai kele renge Naul On arwera ‘Sete kupvenae nesevin m̃inij.’ ");
INSERT INTO upv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ko inu ma nuwrai tevi kami vajin, Poro nga jinibb p̃isan pimteni rres nesevin kobbong ko nolon pivnae, ngok nolon ololi pa esij jile ko tevi vinnen. ");
INSERT INTO upv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ko poro nga metem rres puloli nik kupvitan pirpok, ko kupla tweni re nik, kupwirre. Erres p̃elak kobbong re metem devjen pijkie, evi nanu nga welili kobbong, renge poro nga parwirre nibem totoklai pian renge lat ne nejijkien. ");
INSERT INTO upv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ko poro nga nevrem rres puloli nik kupvitan pirpok, ko kupta tweni re nik ko kupwirre. Erres p̃elak kobbong re nik nevrem devjen pijkie, evi nanu nga welili kobbong, renge poro nga nibem totoklai pian renge lat ne nejijkien. ");
INSERT INTO upv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ko arwerai kele renge Naul On arwera ‘Isi nga p̃ilngi kurtweni nesevin sen puli naul san suri, ko p̃ilai tevi vinnen.’ ");
INSERT INTO upv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ko inu ma nuwrai tevi kami vajin, Poro nga jinibb san nesevin sen sete puloli womue batun, ko m̃ernen bbong p̃ilngi kurtweni nawone, ko m̃ernen ololi esij nga nesen sen pian pivitan re norman m̃inij. Ko poro nga san p̃ilesi vin nga m̃er nga m̃ilngi kurtweni ngok, m̃ernen evitan re nesevin ngok. ");
INSERT INTO upv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ko kamrunge kele nga marwerai tuwi renge Naul On, ‘Sete kurongwos kupwera nise Atua nga puloli rijrijen som p̃iterter, ko mian ko vitunen ko kuptor otvi nale nen. Poro kupwera nise Atua, ko kuploli ko wor pusorsan tevi kumwerai.’ ");
INSERT INTO upv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ko inu ma nuwrai tevi kami vajin, Sete kupwera rragrrag nise nanu san nga puloli rijrijen som p̃iterter. Sete kupwera nise melrin, suri evi lat seksakel se Atua; ");
INSERT INTO upv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","sete kupwera nise dan, suri evi lat nga m̃ilngi b̃elan ren daron nga m̃isakel re nai seksakel se ni; sete kupwera nise Jerusalem, suri evi ngaim nga milep se Numal nga milep. ");
INSERT INTO upv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ko sete kupwera nise batum kele daron nga kumloli rijrijen e, suri nik sete kurongwos kuploli rao batum san puwuwer rrek pimotmot. ");
INSERT INTO upv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ko daron nga ma kumrijrij nga kuploli nanu san, ko kuploli ko wor nanu nen; ko daron nga kumrijrij nga sete kuploli nanu san, ko sete kuploli nanu nen. Murrun nga parwera nawon nise nanu daron nga parijrij, arivel ji Demij kobbong vini. ");
INSERT INTO upv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kamrunge nga marwerai kele renge Naul On, ‘Poro san pulokloksi metem tuwen, ko nik kupkele lweni kuplokloksi meten tuwen. Ko poro san puti rrawe liwem san, ko nik kupkele lweni, kuputi rrawe liwen san.’ ");
INSERT INTO upv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ko inu ma nuwrai tevi kami vajin, Sete kupwer ore jinibb nga m̃isij. Poro pungasim, ko puwje vasum rres, ko kuprieni nom, ko puwje kele vasum devjen kele. ");
INSERT INTO upv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ko poro jinibb san puwra p̃ilngim renge nosp̃en se numal nir ko p̃ilai sunsun som tuwen, ko kuplinglingi kele p̃ila sunsun ne melas som. ");
INSERT INTO upv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ko poro jinibb san puon terter nik kupsa narr sen van ngasu, ko nik kupsai van ngasu jer wor. ");
INSERT INTO upv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ko poro jinibb san pungoni nanu san ji nik, kuplai tevi ni; ko poro jinibb san owra p̃ilai mun jorom, sete kupwer ore ni. ");
INSERT INTO upv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kamrunge nga marwerai kele renge Naul On, ‘Kupmerreni selem ko kupungasi jinibb nga mok-loli m̃isij tevim.’ ");
INSERT INTO upv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ko inu ma nuwrai tevi kami vajin, Kapmerreni wor jinibb nga marok-loli m̃isij tevi kami, ko kapverus suri nir nga marungasi kami. ");
INSERT INTO upv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pirpok ko kapivi natu Tata se kami mawos nga m̃ilik renge melrin. Suri ni ololi nial sen esin ji jinibb nga marres ko nga marsij, ko okoni naus ous ji jinibb nga marres ko nga marsij. ");
INSERT INTO upv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Poro kapmerreni lartul nga bbong marmerreni kami, ko ngok sev ko pivi nowli kami ren? Iok jinibb nga marok-lai takis kele, nga jinibb jijle nir marungasir, nir kele arok-loli kobbong erpok. ");
INSERT INTO upv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ko poro nga kapwera ‘erres’ tevi tuwa kami nir kobbong, kamloli nanu nga jinibb jijle kobbong nir marok-loli. Jinibb nga marlik re devjen nga vare nir arok-loli kele erpok. ");
INSERT INTO upv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Ngok pirpel ma, kami kapivi wor jinibb mawos nga kapmomsawos p̃irres jijle ko, pirpe Tata se kami nga m̃ilik re melrin ni omomsawos erres jile.” ");
INSERT INTO upv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ko Iesu owra “Kapmetmet, sete kaploli nanu nga m̃irres nga jinibb nir parlesi nawone. Poro pirpok, ko nowli kami nga Tata se kami nga m̃ilik re melrin pia-lai tevi kami tijkie, suri jinibb arsurövi pa kami osuw. ");
INSERT INTO upv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Erpok, daron nga nik kumlai nevöt tevi b̃eres, sete kupsup̃sup̃e kele tevi jinibb nir, pirpe lartul nga marivel re sel eru marok-loli re naim gortien nir ko renge sel nir, nga marwera jinibb parsurövir. Nuwretun nuwrai tevi kami, nir arlai pa nowlir ko osuw. ");
INSERT INTO upv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ko nik ma, daron nga nik kuplai nevöt tevi b̃eres, kuplai silveni kem̃kam̃e, sete jinibb san purongwose. ");
INSERT INTO upv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ko Tata som vajin nga m̃ilesi nanu nga muto silveni pia-lai nowlim tevim. ");
INSERT INTO upv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ko daron nga kamlot e, sete kaploli pirpe lartul nga marivel re sel eru. Nir armerreni partur renge naim gortien nir ko partur ore mesakelkel ne sel nir, nga jinibb nir parlesi nir parlot. Nuwretun nuwrai tevi kami, nir arlai pa nowlir ko osuw. ");
INSERT INTO upv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ko nik ma, daron nga nik kuplot, kupan renge naim som ko kupkikiorore metali, ko kuplot van ji Tata som nga m̃ilik silveni. Ko Tata som nga m̃ilesi nanu nga muto silveni pia-lai nowlim tevim. ");
INSERT INTO upv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ko kami, daron nga kaplot, sete kapwer lululweni nanu nga kami sete kamrongwose, pirpe jinibb nga marlik vare marok-loli. Suri nir arrorrmi poro nga nir parwer lululweni pirpok, ko atua ser nir parunge loten ser. ");
INSERT INTO upv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sete kami kaploli pirpok pirpe nir, suri Tata se kami orongwose womu pae sev nga nevre kami marmumrrol ren, vitunen ko kama-ungoni ni. ");
INSERT INTO upv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ko ngok kami sel nga kaplot ren pirpel le: Kapwera ‘Tata se kem, nik nga kumlik renge melrin, Nik nisem on. Nammerreni jinibb jijle nir partori nisem. ");
INSERT INTO upv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nammerreni nik batun vanu som pivini iel ngatan. Nammerreni nik marongen som piplari iel ngatan, pirpe nga muto pa re melrin. ");
INSERT INTO upv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kupla nanen pivter tevi kem lelingen, nabaani. ");
INSERT INTO upv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ko kuptelasi tweni nololien se kem, pirpe nga kem namok-telasi pa nanu nga marsij nga jinibb nir marok-loli tevi kem. ");
INSERT INTO upv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ko sete kuploli nanu parini parrowrrow p̃elake kem. Ko kuptor ore Demij, sete pivini pulokloksi kem. Suri batun vanu evi som, ko derteren evi som, ko nosrövien evi som, ko parto pijpari tuwi ngok vini. Amen.’ ");
INSERT INTO upv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Suri poro kami kaptelasi tweni nololien se jinibb nir nga marok-loli tevi kami, ko Tata se kami nga m̃ilik re melrin kele p̃itlasi tweni nololien se kami kele vajin. ");
INSERT INTO upv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ko poro sete kaptelasi tweni nololien se jinibb nir, ko Tata se kami kele sete mia-telasi tweni nololien se kami kele vajin. ");
INSERT INTO upv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ko daron nga kamlingi kurtweni nanen nga kaplot van ji Atua, sete kaploli pirpe lartul nga marivel re sel eru. Arloli nor ous nawon nga jinibb nir parongwose nga marlinglingi tweni nanen ser. Nuwretun nuwrai tevi kami, nir arlai pa nowlir osuw, suri jinibb arsurövir pa. ");
INSERT INTO upv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ko nik, daron nga nik kuplingi kurtweni nanen nga kuplot, kupwirap vaseni nom ko kuploli lilane nom p̃irres pirpe bbong nabong jijle komok-loli. ");
INSERT INTO upv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Pirpok, ko jinibb nir sete parongwose nga nik kumlingi tweni nanen. Ko Tata som ma nga m̃ilik silveni, ni kobbong purongwose; ko Tata som nga m̃ilesi nanu nga muto silveni pia-lai nowlim tevim. ");
INSERT INTO upv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Sete nolo kami parkul, ko sete kapok-ser kortoni kis joro kami nga marres iel ngatan. Suri momom tuti ko doto nir tarurro lokloksir, ko jinibb venao tubbri lut nabbu ko tian tivevna loloim. ");
INSERT INTO upv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nolo kami parres, ko re sel ngok, kapok-ser kortoni joro kami nga parres parto renge melrin mare. Suri momom sete orongwos puti, ko doto sete arongwos parurro lokloksir, ko jinibb venao sete orongwose pubbri lut nabbu ko pian pivevna loloim. ");
INSERT INTO upv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngok poro nga jorom puto renge lat nga m̃irres, ko nolom kele p̃irres, suri jorom oto pa lat nga m̃irres osuw. ");
INSERT INTO upv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mete jinibb erpe moron ne niben. Poro nga metem p̃im̃erer, ko moron puwun saut re nibem totoklai. Ngok owra puwra, poro nga nolom p̃irres, ko mauren som totoklai kele p̃irres. ");
INSERT INTO upv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ko poro nga metem p̃isij, ko nemalik puwun saute nibem totoklai, suri metem erpe moron ne nibem. Ngok owra puwra, poro nga nolom pukul, ko mauren som totoklai kele p̃isij jile. ");
INSERT INTO upv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Sete jinibb san orongwos p̃imajing se numal p̃ieru pivesane. Poro pirpok, ko tungasi nuru tuwen, ko timrreni nuru tuwen nen. Erpok ko, sete Atua orongwos pukonim re majingen sen poro nevöt mukonim pa renge majingen sen. Suri sete kurongwos kupmajing se nuru korti pivesane. ");
INSERT INTO upv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Suri nanu ngel, nuwrai tevi kami, sete kaprrorrmi p̃elake mauren se kami. Sete kapok-wera ‘O, rrapurroi sev le?’, rreknga ‘O, rrapmini sev le?’, rreknga ‘O, rrapuri sunsun sev le?’. Mauren se jinibb nir evi nanu nga milep nga Atua m̃ilai pa tevi jinibb nir. Nanen evi nanu nga welili jer kobbong—Atua orongwos p̃ilai kele kobbong. Ko nibe jinibb nir kele evi nanu nga milep nga Atua m̃ilai pa tevir. Sunsun evi nanu nga welili jer kobbong—Atua orongwos p̃ilai kele kobbong. ");
INSERT INTO upv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kaprrorrmi ta numön nga marok-il suri mesa ngok nir. Nir sete aruw ko sete arili tweni, ko sete arlingi nanen ser renge b̃ep̃eim; ko Tata se kami nga mok-lik ko re melrin ok-wunganir. Ko kami kamrres womu nen ko wor re numön ngok nir re no Atua, ngok ni puwngani kami kele ko wor. ");
INSERT INTO upv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kaprrorrmi ta m̃er nga murrorrmi p̃elake mauren nga mumrrol. Orongwos puloli kele mauren sen pipriv kele renge sel ngok? Ejki rres nawon! ");
INSERT INTO upv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ko suri sev kamrrorrmi p̃elake sunsun se kami? Kapmeteni wose renge nevngun nga marmaur suri orsel ngok nir. Armaur erpese? Sete armajing erpe jinibb te, ko sete arilile wose. ");
INSERT INTO upv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ko nuwrai kele tevi kami, numal Solomon, daron nga m̃ilngi sunsun sen nga m̃irres p̃elak, ko sunsun sen emau erres, sete erpe nga m̃itra. Ko sunsun se nevngun, nulsen arres easi. ");
INSERT INTO upv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ko mösmös ne orsel nir armaur erres, ko Atua ololi orsel emau erres e lelingen ngel; ko mevinen mun parsulir ko pa. Ko kami sete kamrrorrmi nga Atua p̃ilai sunsun se kami nga parres? O, lartul, nosurien se kami ewelili jer. ");
INSERT INTO upv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Setete kaprrorrmi p̃elake pirpel: ‘Rrapurro isev? Rrapmini isev?’ rreknga ‘Sunsun sev rrapuri?’ ");
INSERT INTO upv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Jinibb nir nga marlik vare arok-pej nanu nga ngok nir. Ko Tata se kami nga m̃ilik re melrin orongwos pae nanu jijle nga nevre kami mumrrol ren. ");
INSERT INTO upv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ko nanu nga milep nen nga kami kaploli, kapp̃elak nga kapsil van renge batun vanu se Atua, ko nga kaploli suri murrun nga m̃irres sen. Ko vitunen ni pia-lai kele nanu ngok jile nir tevi kami. ");
INSERT INTO upv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sete erres kaprrorrmi p̃elake nanu ne mevi nir. Suri mevi evi nabong nga kaprrorr mi suri nanu nga parpelari kis ren. Nanu nga m̃isij nga piplari renge nabong san evtere kaprrorrmi suri re nabong nen kis kobbong. ");
INSERT INTO upv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Sete kapwer lokloksi jinibb p̃isan, puloli Atua sete mia-wer lokloksi kami. ");
INSERT INTO upv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pusorsan tevi nga kami kamwer lokloksi jinibb nir, Atua kele pia-wer lokloksi kami. Ko tevi norrngov sev nga kami kamrrongvie jinibb, Atua pia-rrongvie lweni kami e re nabong nga vitunen. ");
INSERT INTO upv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Ko erpese kumlesi nate nato nga tuwam m̃ikrae re nolo b̃elan, ko sete kulesi suri nate buluk nga milep nga nik kumkerae re nik nolo b̃elam? Ko poro pirpok, ko nik kupwerai pirpese tevi tuwam, ‘Tuwak, kuplinglingi b̃esre tweni nate nato nga kumkerae re nolo b̃elam,’ daron nga nik sete kumleslesi nate buluk nga milep nga nik kumkerae re nik nolo b̃elam? O, nik nga kumiel renge sel eru, tukbböt re aseni ni b̃elan, tuloli ni b̃elan turro tiasi! Womunen kupsere tweni nate buluk nga milep nga nik kumkerae re nolo b̃elam jile pusuw, ko kuplesi nolo b̃elam owokwok erres, ko kurongwos kupa-sere tweni vajin nate nato nga tuwam m̃ikrae mibbölji b̃elan. ");
INSERT INTO upv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ngok orrongrrongvi nololien nga wowarreng se kalesia nir. Ko re devjen nga re nir ne vare nga marivi jinibb ngamarsij p̃etp̃eti, kapmetmet re nir. Daron nga poro kapan ji nir nga kapwera tweni nale suk, ko nir arongwose parpalpal p̃iterter tevi kami pirpe guli, ko parungasi nale suk pirpe b̃erp̃er marbbötbböt re nanu nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kapungoni, ko Atua pia-lai tevi kami. Kappej, ko Atua puloli kapa-lesi. Kapututi, ko Atua pia-tasi metali nen tevi kami. ");
INSERT INTO upv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Suri nir jijle nga marok-ungoni para-lai, ko nir jijle nga marok-pej para-lesi, ko nir jijle nga marok-ututi, para-tasi tevir. ");
INSERT INTO upv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Jinibb si re kami poro nga natun pungoni niv tevi ni, ko ni p̃ikrekrasi pia-la nevöt tevi natun? ");
INSERT INTO upv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ko poro nga natun pungoni mesal, ko rreknga ni pia-la num̃et tevi? Ejki rres nawon, sete orongwos puloli pirpok. ");
INSERT INTO upv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ko ngok, kami nga kamivi jinibb nga kamsij kamrongwos sel nga kapla nanu nga marres tevi natu kami nir. Ko Tata se kami nga m̃ilik re melrin pia-lai ko wor pumomsawos nanu nga marres tevi nir nga marungoni ni. ");
INSERT INTO upv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nanu jijle nga kami kamwera jinibb parloli tevi kami, kami kele kaploli ko wor tevi nir pirpok kele. Ngok kobbong evi murrun ne nosp̃en jile se Moses ko propet nir nga maruli re Naul On. ");
INSERT INTO upv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kapasi renge metali nga m̃ikel, nga pian re lut ne mauren. Suri metali ko sel nga poran renge lut ne nejijkien, metali nen nolon elep, ko sel nen kele elep, ko nir elep nga marvijuri. ");
INSERT INTO upv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ko metali ko sel nga poran renge lut ne mauren, metali nen nolon ewelili jer, ko sel nen kele nolon ewelili jer; ko nir pievis kobbong para-vijuri. ");
INSERT INTO upv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kapmetmet renge propet ne gerisen nir. Arirpe guli rrum nga numer m̃iajir, ko aruri nevlu sipsip arkerkeris arirpe sipsip nga sete marongwose parlokloksi nanu san. ");
INSERT INTO upv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kaplesi wose nir renge wenen nga marpelari renge mauren ser. Sete jinibb arongwose partawe wene drra renge moku, ko wene nitapol renge jibermij, ejki. ");
INSERT INTO upv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Erpok, nai jijle nga marres parwen kele wenen nga marres, ko nai jijle nga marsij parwen wenen nga marsij. ");
INSERT INTO upv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nai jijle nga marres sete arongwos parla wenen nga marsij, ko nai jijle nga marsij sete arongwose parla wenen nga marres. ");
INSERT INTO upv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ko nai jijle nga sete parwen wenen nga m̃irres, parta twenir, ko parwirrer van re nabb. ");
INSERT INTO upv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Erpok, kaplesi wose nir renge wenen nga miplari re mauren ser. ");
INSERT INTO upv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Sete nir jijle nga marok-veruse inu ‘Numal, numal’ tetajer paran renge batun vanu ne melrin. Rrek nir pievis kobbong, nir nga bbong marok-loli marongen se Tata suk nga m̃ilik re melrin mare ko. ");
INSERT INTO upv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Erpok, renge nabong nga vitunen, nir elep parwera tevi inu, ‘Numal, numal, sete kurrorrmi wos nga kem namsup̃e nosp̃en som re nisem, ko nga kem namoji tweni demij nir renge nisem, ko nga kem namloli majingen nga marterter marlelep marres nir renge nisem?’ ");
INSERT INTO upv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ko vitunen bea-werai limjer tevi nir, ‘Setete nurongwose kami. Kapruj ngasu inu, kami nga kamok-majing nanu nga m̃isij.’ ");
INSERT INTO upv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ngel, jinibb jijle nga marunge nale suk ngel nir ko marlolir, osorsan erpe jinibb san nga norongwosien sen otoe, nga m̃ili naim sen renge dan nga m̃iterter m̃irres. ");
INSERT INTO upv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","M̃ili jile vajin, mian ko naus ous elep, ko nuwi owlu vini, ko ling eser elep ko owi naim eterter. Ko setete evitan, suri arili pa eterter renge dan nga m̃iterter m̃irres. ");
INSERT INTO upv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ko jinibb jijle nga m̃ilengleng, norongwosien sen m̃ijkie, nga m̃ili naim sen renge dep̃inan. ");
INSERT INTO upv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","M̃ili jile vajin, mian ko naus ous elep, ko nuwi owlu vini, ko ling eser elep ko owi petpate naim. Ko emav ko omobburbbur jijle.” ");
INSERT INTO upv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu evinvini ore nale sen osuw iok. Ko bbösa nga milep elai delung e nir. ");
INSERT INTO upv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Suri ni nevisvisenien sen orrow erres, sete erpe nevisvisenien se jinibb nevisvisenien ne nale nesesreien nir. ");
INSERT INTO upv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Daron nga Iesu mujubbul vajin e renge botwen, ko delung nga milep nir arvijuri ni. ");
INSERT INTO upv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ko jinibb san nga mimsi mesien nga niber m̃im̃emaul evini ejiol vitan jin, ko owra “Wurru, numal, oto ji nik, poro nga nik kupmarong, ko kurongwos kuploli nibek puwokwok luwi.” ");
INSERT INTO upv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ko Iesu esareni nevren ejpari m̃ernen niben, ko owra “Inu numarong, nibem puwokwok luwi.” Ko ngavilvilsen mesien nga niber m̃im̃emaul evel lingi ni, ko niben owokwok luwi erres. ");
INSERT INTO upv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ko Iesu ewer ore, owrai tevi: “Kuplesi sete kupwerwerai tevi jinibb p̃isan, ko kupan kupviseni nibem tevi jinibb ne sulsulen san, ko kuplai merrenien p̃isan pusorsan tevi Moses muli tuwi suri nir nga marres luwi re mesien ngok, miviseni nir nga nibem muwokwok pa musuw.” ");
INSERT INTO upv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ko daron nga Iesu mian renge Kapaneam e, ko numal san se jinibb ne nuval ne Rom nir evini ji ni ");
INSERT INTO upv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ko ongoni ni, owra “Wurru, numal, nanwarreng weli ne majingen suk emsi, ematur renge naim. Emsi mesien nga niber mokmijmij e, ko ornge esij p̃elak.” ");
INSERT INTO upv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ko Iesu owra lweni tevi: “Inu bevinuk le pa, rroporan bololi ni p̃irres.” ");
INSERT INTO upv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ko m̃ernen ewer ore, owra lweni tevi Iesu: “Numal, sete nurres nga nik kupini re loloim suk. Ko kuptur iok kobbong, kupwera bbong nale, ko nanwarreng suk wel nen p̃irres luwi re mesien sen. ");
INSERT INTO upv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ko inu kele derteren suk otoe, ko numal suk sopor kele derteren ser arasie inu wor. Ko poro nga bowrai tevi jinibb ne nuval suk san, ‘Kupan,’ ko ni pian ko wor; ko poro nga bowrai tevi san kele, ‘Kupini,’ ko ni pivini ko wor; ko poro nga bowrai tevi jinibb ne majingen suk, ‘Kuploli pirpel,’ ko ni puloli ko wor pirpok.” ");
INSERT INTO upv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ko daron nga Iesu murnge nale sen ngel, ko etaole, ko owrai tevi nir nga marvijuri ni: “Nuwretun, nuwrai tevi kami, setete nulesi jinibb san ne Isrel nga nosurien sen milep mirpe m̃erel. ");
INSERT INTO upv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nuwrai tevi kami, nir pilep nga para-ivel re Is ko re Wes ko ngatan jijle vini, para-lik ngatan tevi Epram ko Aesak ko Jekop renge batun vanu ne melrin, ko para-aani nanen. ");
INSERT INTO upv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ko m̃eri Isrel nir nga marrorrmi nawon nga paran renge batun vanu ne melrin, para-sor twenir, paran renge lat nga mimalik jerjer. Iok ngok jinibb para-ting ko para-runge p̃isij pilep.” ");
INSERT INTO upv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ko Iesu owrai lweni kele tevi jinibb nuval nen, “Kupiel; nanu nga kumosuri piplari ko jim.” Ko renge mete nial mawos nen, nanwarreng wel nen erres luwi re mesien sen. ");
INSERT INTO upv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ko vitunen, Iesu evan loloim se Pita, ko elesi Pita p̃ilen lekter ematur emsi mesien dowalul. ");
INSERT INTO upv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ko Iesu ejpari nevre nesevin, ko mesien dowalul osuw re ni. Ko emra, ko etabbuni nanen se Iesu. ");
INSERT INTO upv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ko rivriv jer, re daron nga nial muwaj pini, ko nabong on ser musuw, ko artektekai jinibb elep vini ji Iesu nga demij marsisilvir; ko ni oji tweni nem̃in nga marsij rer tevi nale sen, ko ololi nir nga marmesi arres luwi re mesien ser. ");
INSERT INTO upv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ngok eplari osorsan tevi nale san se propet Aesea nga muli tuwi mirpel: “Ni ela tweni mesien se kerr ko norongen nga m̃isij se kerr.” ");
INSERT INTO upv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ko vitunen Iesu elesi delung elep nga martur rrale ni, ko owrai tevi jinibb sen nir, “Rrapan re devje nuwi Galili e.” ");
INSERT INTO upv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ko jinibb nevisvisenien ne nale nesesreien san evini ji ni, ko owra “Jinibb nevisvisenien, ngabe nga kupa-van e, ko inu bea-vijuri nik.” ");
INSERT INTO upv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ko Iesu owra lweni tevi ni, “Guli rrum nga wowarreng nir b̃elaur otoe, ko numön nir menuner otoe; ko inu Jinibb Mawos, milngek ejkie. Ngok, kuprrorrmi mun p̃irres poro nga kumrreni kupvijuri inu.” ");
INSERT INTO upv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ko san re jinibb sen owra tevi ni, “Numal, kuplinglingi inu puwomu ban b̃etevni luwe tata suk.” ");
INSERT INTO upv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ko Iesu owrai tevi, “Ejki, kupvijuri inu, ko kuplinglingi nir nga sete marla mauren ko pa partevni lartul nga marmij.” ");
INSERT INTO upv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Erij jile erpok musuw, ko ean esa renge drrav se nir, ko jinibb sen arsa tevi ni. Ko ni evan, ematur lolo drrav. Ko drrav owlu. ");
INSERT INTO upv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ko mian ko ling serser nga milep etewut vini re nuwito, ko owi nuwi daptap nen elelep nga marjerjeravi drrav ser, ko drrav ser otomori purron. Ko Iesu ematur malum, sete emra wor. ");
INSERT INTO upv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ko jinibb sen aran arwuni ni, ko arwerai tevi ni: “Numal, kupla se kerr, otomori rrapmij!” ");
INSERT INTO upv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ko ni owra tevi nir: “Erpese kami kammetutu? Nosurien se kami ewelili jer.” Ko otur mera, ko ewer ore ling ko daptap ne nuwi, ko ormol kem̃kam̃e. ");
INSERT INTO upv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ko nir artaole, ko arwerwerair e, “Jinibb nga mirpese le mirpel ngel, nga m̃irij tevi ling ko nuwi kele, ko morosuri ni?” ");
INSERT INTO upv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ko vitunen arjipari devje nuwi renge ngaim se m̃eri Gatara. Ko jinibb eru nga demij m̃isisilvi nuru orpelari re lat ne dubb vini, orivel ore selen. Nuru orivi jinibb rrum, ko orloli jinibb sete arongwose parasi renge sel ngok. ");
INSERT INTO upv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ko orkail ko orwera “Nik Atua natun, kuvini iel tweni kuploli sev le tevi komru? Kuvini tweni kuploli komru nobor-runge p̃isij puwomu, vitunen ko daron nen vajin?” ");
INSERT INTO upv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ko mori bbong nir, nior b̃erp̃er artur arok-susung malum. ");
INSERT INTO upv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ko demij nen nir arungoni tevi Iesu, arwera “Wurru, poro kupoji tweni kem, ko kuplinglingi kem naban nabsilvi b̃erp̃er ngok nir.” ");
INSERT INTO upv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ko ni owra tevi nir: “Kapan.” Ko daron nga marivare, aran arsilvi b̃erp̃er nir; ko nir jijle arwolu renge botwen nga mivjivjar san ko arowrow jubbul van renge nuwi nga milep nen, ko arron ko armij. ");
INSERT INTO upv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ko jinibb nga marok-metmete b̃erp̃er nir, daron nga marlesi, arwolu suri sel van ngaim e, ko arsup̃e nanu jile nga marpelari. Ko nanu nga milep nga marsup̃e suri, sev nga miplari ji laru nen nuru. ");
INSERT INTO upv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ko nir nga marlik renge ngaim nen jijle nir arivel ore parsesewute Iesu. Ko daron nga marini ji ni ko arungonie eterter, arwera pivel lingi lut nga nir. ");
INSERT INTO upv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ko mian ko Iesu esa luwi kele renge drrav nen, olwi kele vini renge ngaim sen e. ");
INSERT INTO upv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ko jinibb sopor arwosi jinibb san re maling sen nga mimsie mesien nga niber mok-mij e vini jin. Ko Iesu elesi nosurien ser elep, ko owrai tevi m̃er nga mimsi, “Natuk, nolom p̃irres, b̃etlasi tweni nololien som le pa.” ");
INSERT INTO upv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ko jinibb nevisvisenien ne nale nesesreien sopor arwerwera lululwenir e, “Aro, m̃erel erij melmelas ko osopsop̃e pa Atua!” ");
INSERT INTO upv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ko Iesu orongwose norrorrmien ser, ko owra “Suri sev norrorrmien nga m̃isij muto re nolo kami ngok? ");
INSERT INTO upv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Evi nanu nga m̃isisarow bbong nga bowrai tevi m̃erel, ‘Nololien som nutlasi tweni pa,’ suri si p̃ilesi poro nuwretun rrek nukrekris kobbong? Ko evi nanu nga m̃iterter kele wor asi ngok nga poro bowra ‘Kuptur imare kupla milngom ko kupiel van renge naim som e,’ suri jinibb jijle parlesi lelingen poro piplari pirpe nga mowrai ngok. Ko bololi vajin nanu nga m̃iterter nen, puloli kaprongwose kele nga inu Jinibb Mawos derteren suk otoe renge iel ngatan nga b̃etlasi tweni nololien.” Ko ni owrai tevi m̃er nga devje niben mimij, owra “Nuwrai tevi nik, Kuptur imare kuplai maling som kupwosi, ko kupiel van renge naim som e.” ");
INSERT INTO upv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ko ni erres luwi, ko otur imare ko evan renge naim sen e. ");
INSERT INTO upv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ko delung nir arlesi nanu nga muloli, ko armetutue, ko arsurövi Atua renge nga m̃ilai derteren nga mirpok tevi jinibb. ");
INSERT INTO upv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ko Iesu evel lingi lat ngok, orujruj sopon. Ko elesi jinibb san nisen Matiu esakel renge lat nga mok-lai nevöt netakis e. Ko owrai tevi, “Kupvijuri inu.” Ko ni otur imare, evijuri ni. ");
INSERT INTO upv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ko vitunen Iesu ean loloim se Matiu ko esakel re tep nga p̃iaan. Ko nir elep nga marok-lai nevöt ne takis arini kele, ko nir nga jinibb marok-ungasir arini arsakel tevi Iesu ko jinibb sen nir. ");
INSERT INTO upv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ko Parasi nir marlesi ko arwerai tevi jinibb sen nir, “Erpese numal se kami m̃iaan tevi lartul ngok nga marok-loli nanu nga m̃isij?” ");
INSERT INTO upv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ko Iesu ornge nale ser ko owrai tevir: “Nir nga marres sete armerreni dokta; nir nga bbong marmesi ko. ");
INSERT INTO upv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kapan kapmeteni suri re mining ne nale se Atua ngel: ‘Nanu nga memrreni milep evi murrun nga partelasi jinibb. Murrun nga parsulsul tevi Atua evi nanu nga welili jer kobbong.’ Sete nuvini tweni nga beveruse jinibb nga marvilvil ore marsij marwera marres, ko nuvini tweni nga beveruse nir nga sete markerkeris, ko marwer limjere nga marsij.” ");
INSERT INTO upv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ko vitunen vajin jinibb se Jon Baptaes nir arini ji Iesu, ko arsusi tevi ni: “Erpese kem ko Parasi nir namlingi tweni nanen nga nablot van ji Atua, ko jinibb som nir sete arloli erpok?” ");
INSERT INTO upv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ko Iesu owra lweni tevir, “Daron nga nesevin muwra p̃ilik ji diwen sen, ko elik malum tevi selen nir renge nanen, sete arongwos partengsi wor. Ko daron nen pia-vini ko nga pia-ivel lingir vajin, ko arongwos parunge p̃isij vajin ko parlingi tweni nanen ser suri. ");
INSERT INTO upv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ko sete jinibb san orongwose p̃ilai bebje kalik nga mimerr puwol ore lat nga mimarrerr renge sunsun nga m̃itra e. Poro pirpok, ko kalik nga m̃imerr nen tia-sakuk ko tia-teri kele sunsun nga m̃itra, ko tia-loli lat nga m̃imarrerr tia-lep temijpal. ");
INSERT INTO upv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ko erpok kele, sete jinibb san orongwos pujongjongi norro nga mimerr van renge botel nga m̃itra nga marloli nevlu nanikot e. Poro pirpok ko norro nga mimerr tut, tuloli nevlu nanikot nga m̃itra tirrerren ko tiap rrerrsi, suri etra p̃elak. Ko norro timejivjiv tisij, ko nevlu nanikot kele tisij. Pirpel ko, norro nga mimerr parlingi ko wor renge nevlu nanikot nga mimerr mimalum m̃irres.” ");
INSERT INTO upv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ko daron nga m̃irij mirpok tevi nir, ko numal san se m̃eri Isrel evini ji Iesu. Ko ejiol ko owra “Natuk nesenwarreng eamij bbong lelingen wolok. Ko poro nga nik kupini, kupa-jipari kobbong ni tevi nevrem, ko ni pia-maur luwi kele.” ");
INSERT INTO upv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ko Iesu otur imare ko evijuri ni, ko jinibb se Iesu nir kele arvijuri. ");
INSERT INTO upv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ko nesevin san nga mok-mesi mesien se nesevin nir tetajer, sete orongwos pumosi ejpari sia esngavöl drromon eru (12), evini evitu suri Iesu re duren, ko ejpari bongsi sunsun sen. ");
INSERT INTO upv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nesevin norrorrmien sen erpel: “Poro bbong bejpari bongsi sunsun sen, ko inu bea-rres ko.” ");
INSERT INTO upv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ko Iesu erieni lweni ko elesi vinnen ko owrai tevi: “Natuk, nolom p̃irres, nosurien som ololim kumrres.” Ko vinnen erres jer ko pa evesane. ");
INSERT INTO upv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ko daron nga Iesu mivini vajin re naim se numal nen, ko elesi nir nga marok-uwi davö ne mijen, ko nir nga marting vijajeng. ");
INSERT INTO upv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ko ni owrai tevir, “Kapiel, suri nesenwarreng ngel setete emij, ko ematur kobbong.” Ko daron nga marunge nale sen, ko armen kerajie. ");
INSERT INTO upv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ko daron nga delung nir maran vajin vare e, ko ni evan re loloim nga nesenwarreng mimatur ren, ko erveinevre nesenwarreng nen imare, ko nesenwarreng emra. ");
INSERT INTO upv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ko nosp̃en nen arsup̃e re lat nen jile nir. ");
INSERT INTO upv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Daron nga Iesu mivel rujruj lingi ie, ko metrrorr eru orvijuri ni. Ko orkail, orwera “Wurru, kuprrorrmi komru, nik metka se Devet!” ");
INSERT INTO upv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ko daron nga Iesu mian loloim e, ko metrrorr nuru oran jin. Ko ni owra tevi nuru, “Komor-osuri nga inu nurongwos bololi nanu ngel?” Ko nuru orwera lweni, “O-o, numal.” ");
INSERT INTO upv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ko ejpari mete nuru, ko owra “Piplari pusorsan tevi nosurien se kamru.” ");
INSERT INTO upv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ko mete nuru orres. Ko Iesu ewer ore eterter owrai tevi nuru, “Kopor-lesi sete jinibb san purongwose.” ");
INSERT INTO upv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ko nuru daron nga morivel, ortur imare ko ortewijreni nosp̃en ne Iesu renge vanu nen jile nir. ");
INSERT INTO upv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ko daron nga nuru morivare re naim e, ko jinibb sopor arpitevi nabbut san nga demij m̃isisilvi vini ji Iesu. ");
INSERT INTO upv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ko Iesu oji tweni demij, ko nabbut erij luwi vajin. Ko delung nir artaole, ko arwera “Sete pa nabong san rramlesi nanu nga mirpok eplari renge Isrel.” ");
INSERT INTO upv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ko Parasi nir arwera “Wi, ok-ojoji tweni demij suri ni elai derteren sen ji numal se demij nir.” ");
INSERT INTO upv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ko Iesu evel rrerrale ngaim nga marlelep nir ko nga wowarreng nir, ko ok-visviseni renge naim gortien ser. Ko ok-werwer suri nale nga m̃irres suri batun vanu ne melrin, ko ok-loli nir nga marmesi mesien lele, mesien ser osuw, arres vajin. ");
INSERT INTO upv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ko daron nga m̃ilesi delung nir, ko orrorrmi elep suri nir. Suri arirpe sipsip nga sete san mok-metmeter, armaob nawon, setemun arongwose parwolu. ");
INSERT INTO upv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ko owrai tevi jinibb sen nir, “Numös elep p̃elak, ko nir evis bbong nga partawer ko parilir. ");
INSERT INTO upv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngok, kapungoni tevi Atua, nga mivi numal ne numös, nga pukoni kele jinibb nga marok-tawe ko marok-ili sopon van re orsel sen.” ");
INSERT INTO upv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ko Iesu everus jinibb sen esngavöl drromon eru (12), nga marveruse nir aposol, parini mori. Ko elai derteren tevir nga paroji nem̃in nga marsij nir, ko nga parloli nir nga marmesi mesien lele parres luwi. ");
INSERT INTO upv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ngel evi nise aposol esngavöl drromon eru: nga womuj nen Saemon, nga marveruse kele e Pita, ko Antru Pita tasin, ko Jemes natu Sepeti ko Jon Jemes tasin, ");
INSERT INTO upv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ko Pilip, ko Batolomiu, ko Tomas, ko Matiu nga mok-lai nevöt ne takis bonevis, ko Jemes natu Alpeas, ko Tateas, ");
INSERT INTO upv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ko Saemon nga bonevis m̃ilik ji nir nga marmerreni paroji tweni m̃eri Rom nir, ko Jutas Iskariot, nga vitunen pia-teka kerasi Iesu. ");
INSERT INTO upv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jinibb esngavöl drromon eru ngel Iesu okonir van. Ko daron nga mukonir e, ko ewer sesesre erpel tevir: “Sete kapan ji jinibb ne vare nir, ko sete kapan renge ngaim san se m̃eri Sameria nir, pijki. ");
INSERT INTO upv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Rrek kapan wor ji m̃eri Isrel nir. Nir arirpe sipsip nga marivel sarrsarr. ");
INSERT INTO upv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ko daron nga kapan, ko kapok-werwer pirpel, kapwera ‘Otomori le pa batun vanu ne melrin p̃irrmali.’ ");
INSERT INTO upv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kaploli nir nga marmesi parres, ko kaploli nir nga marmij parmaur luwi, ko kaploli nir nga marmesie mesien nga niber m̃im̃emaul parwokwok, ko kapoji tweni demij nga marsisilvi jinibb nir. Ngok evi derteren nga marlai nawone tevi kami. Sete kamwuli. Ko kami kele kaplai nawon tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sete kapsongni nevöt renge baos se kami; poro pivi nevöt nga milep, rreknga nevöt nga welili, ko sete kapsongni, pijki. ");
INSERT INTO upv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ko sete kapsa narr se kami daron nga kapiel e, ko sete kaptori sunsun p̃ieru, rreknga but se kami, rreknga nai nga mok-tor etete kami. Sete kaptori nanu ngok nir, suri oto ji lartul nga kammajing ser para-la nanu ngok nir tevi kami. ");
INSERT INTO upv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ko daron nga kapan renge ngaim nga milep san, rrek nga welili san, kappej siko nga m̃irres ren, ko kaplik tevi, pijpari daron nga kapa-ivel. ");
INSERT INTO upv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ko daron nga kapan renge naim sen, ko kapwera erres tevi nir nga marlik ren. ");
INSERT INTO upv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ko poro nga nir parivi jinibb nga marres, ko kaplinglingi rijen se kami nga m̃irres ngok puto jer jir. Ko poro nga nir sete parivi jinibb nga marres, ko kaploli rijen se kami nga m̃irres ngok pulwi vinuk ji kami. ");
INSERT INTO upv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ko poro sopor sete parmarong kami kapan ji nir, ko sete parunge nale se kami, daron nga kapiel lingi lut nen, erres kapwirrwirrleni tweni maw nga muto re but se kami, nga piviseni tevir nga marloli m̃isij. ");
INSERT INTO upv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nuwretun nuwrai tevi kami, renge nabong nga Atua pia-wera suri lat nga puto suri tevi jinibb nir, pia-sij wor pia-asie renge nir ngok renge nir ne Sotom ko nir ne Gomora, nga marsup̃e tuwi pa suri nololien ser nga marsij. ");
INSERT INTO upv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kapmurrong. Bokoni tweni kami kapirpe sipsip nga paran renge livö ne guli rrum nir. Kapkulu metmet p̃irres pirpe num̃et, ko kapirpe kele wum̃er nga sete orongwos puloli p̃isij. ");
INSERT INTO upv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kapmetmet re jinibb nir. Para-tekai kami van re nosp̃en se numal ser nir, ko renge naim gortien ser, para-revji kami tevi nai ");
INSERT INTO upv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ko para-tekai kele kami van re no numal nga marlelep sopor kele, suri kamivi jinibb suk. Ko kapa-wera tweni nale suk tevi nir ko tevi jinibb ne vare nir. ");
INSERT INTO upv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Ko daron nga para-tekai kami, sete kaprrorrmi p̃elake sev nga kapwerai ko pirpese nga kapwerai. Suri Nem̃in On pia-lai nale tevi kami nga kapa-werai renge mete nial mawos nen. ");
INSERT INTO upv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Suri sete kami kis kaprij, ko Nem̃in On se Tata se kami nga pia-rij renge jingo kami. ");
INSERT INTO upv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ko tuwan pia-tekai tasin pia-lingi re mijen, ko tata kele pia-loli pirpok tevi natun; ko natur kele nir para-tur imare, para-teka tata ser ko tasu ser para-lingi van re mijen. ");
INSERT INTO upv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ko jinibb jile para-ungasi kami suri kamivi jinibb suk. Ko si nga pia-tur p̃iterter pijpari bongsin, Atua pia-la mauren tevi. ");
INSERT INTO upv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Ko poro nga parloli esij tevi kami renge ngaim san, ko kapwolu van re ngaim nga surie. Nuwretun nuwrai tevi kami, setete kapiel p̃etp̃eti re ngaim ne Isrel nir, pijpari inu Jinibb Mawos bea-luwi vini. ");
INSERT INTO upv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sete jinibb san elep asi ni nga mok-visviseni, ko sete jinibb ne majingen san elep asi numal sen. ");
INSERT INTO upv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jinibb san purnge p̃irres kobbong nga pirpe numal sen. Ko poro san piveruse numal san puwra ‘Bielsepal’ (ngok evi nise numal se demij nir), ko pia-rij pia-sij kele wor tevi jinibb sen nir, suri jinibb sen nir arivi jinibb nga welili kobbong. ");
INSERT INTO upv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ngok, sete kapmetutue nir. Suri nanu jijle nga m̃itiwtawi ore, para-raji puto limjer; ko nanu jijle nga muto teptepi, para-rongwose kele e. ");
INSERT INTO upv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sev nga mowrai silveni tevi kami, ko kapa-werai limjer; ko sev nga mowra renge boro kami, kapkail van mare, kapwerai tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ko sete kapmetutue nir nga marok-revji nibe jinibb, ko sete arongwose parevji nem̃ir. Kapmetutu wore Atua kobbong, suri ni orongwose pirevji kortoni niben ko nem̃in renge lat ne norongen nga m̃isij. ");
INSERT INTO upv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Arok-wulwule numön nga wowarreng nir nowlir ean ngatan temijpal. Ko sete nir san pivitan aseni ngatan poro nga Tata se kami sete pimarong. ");
INSERT INTO upv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ko kami, kamlelep lingi nir wor ji Tata se kami. Erpe kami kamrrorrmi rao batu kami evi nanu nga welili kobbong; ko suri kamlelep p̃elak ji Tata se kami, ni orongwose jijle rao batu kami nir. ");
INSERT INTO upv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ngok, sete kapmetutu. Kamlelep temijpal wor asi numön nga wowarreng ngok nir, ko Tata se kami pimetmete kami kele wor. ");
INSERT INTO upv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Si nga puwrowrai inu renge no jinibb nir, inu kele bea-werwerai ni renge no Tata suk nga m̃ilik re melrin. ");
INSERT INTO upv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ko si nga pivilvil ore inu renge no jinibb nir, inu kele bea-vilvil ore ni renge no Tata suk nga m̃ilik re melrin. ");
INSERT INTO upv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sete kaprrorrmi nga nuvini tweni bokoni demat vini iel ngatan. Sete nuvini tweni bokoni demat, ko nuvini tweni b̃eti wukari jinibb nir, pivi meling p̃ieru e. ");
INSERT INTO upv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ko nuvini tweni bololi jinibb p̃itre tata sen, ko nesenwarreng p̃itre tasu sen, ko nesevinli p̃itre p̃ilen lekter. ");
INSERT INTO upv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ko devje nuval se jinibb nir parpelari re nir lulweni kobbong niaken. ");
INSERT INTO upv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ko poro jinibb san pimrreni tata sen rreknga tasu sen womu re inu, ko sete erres re pivi jinibb suk. Ko ni nga mimrreni natun norman rreknga nesevin womu re inu, ko sete erres kele re pivi jinibb suk. ");
INSERT INTO upv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ko si nga sete muwosi nai pelaot sen pivijuri inu, ko sete erres re pivi jinibb suk. ");
INSERT INTO upv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Si nga putor totoni mauren sen p̃iterter iel ngatan, mian ko pia-tor jabble; ko si nga pimaronge mauren sen suri m̃imajing suk, ko mian ko pia-tor sweri mauren nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ko si nga pimarong kami kapan ji ni, ko erpe emarong kele inu ban ji ni. Ko ni nga pimarong ban ji ni, erpe emarong kele nga Tata suk nga mukoni inu pian ji ni. ");
INSERT INTO upv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ko si nga pimarong nga propet san pian ji ni suri evi propet, ni kele pia-lai nowli propet ji Atua. Ko si nga pimarong nga jinibb nga m̃irres san pian ji ni suri evi jinibb nga m̃irres, ni kele pia-lai nowli jinibb nga m̃irres san ji Atua. ");
INSERT INTO upv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ko si nga p̃ilai biles nuwi kobbong nga mimemrrali san tevi jinibb suk nga welili ngel san nga pimni, suri evi jinibb suk, erpe ololi nanu nga welili kobbong. Ko nuwretun nuwrai tevi kami, m̃ernen pia-lai nowlin nen ko wor ji Atua.” ");
INSERT INTO upv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu evinvini ore nga muwer sesesre jinibb sen esngavöl drromon eru iok. Ko evel rujruj sopon kele vini re ngaim sopor nga marto rrale ie, nga pivisviseni ko p̃iwerwer rer. ");
INSERT INTO upv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Renge daron nen, Jon Baptaes elik renge naim ne nekaien, ko ornge majingen se Kristo nga mulolir. Ko okoni jinibb sen sopor van ji Iesu. ");
INSERT INTO upv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ko arsusi tevi, “Erpese? Nik kuvi ni nga kem m̃eri Isrel nir namok-teravi, rreknga ejki, nabtiriv m̃inij malum?” ");
INSERT INTO upv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ko Iesu erij weli tevi nir, owra “Kapan ji Jon, ko kapa-werai tevi ni nanu nga m̃irres nga kamlesi ko kamrunge, pirpel: ");
INSERT INTO upv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Metrrorr arkulkulu erres luwi, ko naroj nir arivel erres, ko jinibb nga marmesie mesien nga niber m̃im̃emaul arwokwok luwi, ko borwon nir arongrong luwi, ko mijen nir armaur luwi, ko arwerwer nale nga m̃irres tevi b̃eres nir. ");
INSERT INTO upv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ko neiren re ni nga sete m̃ilesi nanu san renge inu nga puloli ni purnge p̃isij rengen.’” ");
INSERT INTO upv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ko daron nga nir marivel e vajin, ko Iesu etipatun nga puwrai tevi delung nir suri Jon, owra “Sev ko kamiel tweni van kaplesi re lolo merwer bonevis? Kamiel tweni kaplesi jinibb san nga mirpe mavir nga ling mok-uwi sarrsarre? Ejki. ");
INSERT INTO upv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ko suri sev kamiel? Kaman tweni kamlesi jinibb san nga muri sunsun nga mimau m̃irres? Ejki, nir nga maruri sunsun nga mirpok arlik re naim se numal nga marlelep nir. ");
INSERT INTO upv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ko suri sev kamiel? Kaman tweni kamlesi propet san? Nuwrai tevi kami, ewretun, ni evi propet, ko elep kele wor asi propet nir. ");
INSERT INTO upv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ni ngel ko tuwi aruli suri renge Naul On, erpel: ‘Kapmurrong, bokoni jinibb suk san nga puwowomu re Mesaea, ko puloli sel se ni pimetet.’ ");
INSERT INTO upv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nuwretun nuwrai tevi kami, renge nir p̃etp̃eti nga mariak iel ngatan, sete san erpe Jon Baptaes. Ni elep wor asi nir. Ko renge nir nga paran re batun vanu ne melrin, nir p̃etp̃eti arlelep asi wor Jon. ");
INSERT INTO upv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“M̃itipatun renge daron nga Jon Baptaes mok-werwer e evini mijpari lelingen, ko jinibb ne balpalen nir arpalpal tere batun vanu ne melrin, ko arwera parpalpal ore jinibb nir sete paran rengen. ");
INSERT INTO upv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nale se propet nir, ko nale nesesreien nga maruli tuwi pa, arsup̃e wowomue ko pa osuw, mijparimian ko Jon mia-pelari. ");
INSERT INTO upv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ko nanu nga bowrai rreknga p̃iterter nga parosuri le, ko Jon le evi Elaeja nga nir marsup̃e wowomue nga pia-luwi vini. ");
INSERT INTO upv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Isi nga boron otoe, purnge re nolo boron! ");
INSERT INTO upv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ko bowrai rrongrrongvi dul nga lelingen ngel aripese? Arirpe bipiwarreng nga marlik renge mesa nga m̃irres sopon, ko markikail marververuse seler nir parini jir partetnij. ");
INSERT INTO upv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ko arwera ‘Namuwi nabbu, ko kammusus kapsew e; namla nubo nga martaur e, ko kammusus kapting. Kammusus kaptetnij detnijen ne neiren, ko detnijen ne dauren.’ ");
INSERT INTO upv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ko erpok kele, dul nga lelingen ngel arungasi murru Jon ko murru inu Jinibb Mawos kele. Suri Jon mivini, ko sete eaan elep, ko sete emni norro ejki, suri ok-lot tetajer. Ko dul ngel arlesi esij, ko arwera ‘Demij san esisilvi.’ ");
INSERT INTO upv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ko inu Jinibb Mawos nuvini nomok-aan ko nomok-mini norro. Ko dul ngel arlesi esij kele, ko arwera ‘Kaplesi, leorr lep, ko lemni kis norro! Ni evi sele jinibb nga marok-lai nevöt ne takis, ko jinibb nga marsij nir.’” Ko Iesu owrai tevir, “Ko norongwosien sete eplari re sel sansan, eplari wor re sel elep ko. Ko komru Jon, komru kes nomor-vijuri.” ");
INSERT INTO upv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ko vitunen Iesu etipatun ko erij terter tevi nir nga marlik renge ngaim sopor suri nelesien jijle nga muloli re nir marlesi, ko sete nolor arlululwi ren. ");
INSERT INTO upv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ko owra “Wi, kami m̃eri Korasin! Wi, kami m̃eri Betsaeta! Kami nga kamok-ungasi jinibb ne vare nir, erpe m̃eri Taea ko m̃eri Saeton nir. Ko poro nga san puloli majingen nga marinijnij nawone ngel nir nga mololi ji kami renge Taea ko Saeton, ko nolor pulululwi pa tuwi nen renge nololien ser, ko paruri sunsun tera nga marmerrmerris nir, ko parlik renge niavi nabb parp̃elpalose, parviseni nga arrorrmi nanu nga marsij nga marloli sarrsarre nir. ");
INSERT INTO upv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ko nuwrai tevi kami, pia-sij wor renge kami pia-asi nir m̃eri Taea ko Saeton renge nabong nga Atua pia-wera suri lat nga puto suri tevi jinibb nir, suri nolo kami sete olululwi. ");
INSERT INTO upv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ko kami, m̃eri Kapaneam, kamok-rrorrmi nga kapa-van mare re melrin, a? Ejki, ko kapa-van ngatan jer re lat ne mijen. Poro nga san puloli majingen nga marlelep ngel nir nga mololi ji kami renge Sotom tuwi, ko nolor pulululwi, ko Atua sete pusli ngaim ser, puto p̃irres pijpari lelingenok. ");
INSERT INTO upv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ko nuwrai tevi kami, pia-sij wor renge kami pia-asi nir m̃eri Sotom renge nabong nga Atua pia-wera suri lat nga puto suri tevi jinibb nir, suri nolo kami sete olululwi.”");
INSERT INTO upv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ko renge daron ngok, ko Iesu owra “Nuwra erres wor tevi nik, Tata. Kuvi Numal ne melrin ko ne ngatan. Ko kusilveni nanu ngel nir suri batun vanu ne melrin renge nir nga marwera ‘Norongwosien se kem otoe, ko namrongrongwos,’ ko kuviseni tevi nir nga nolor maran ngatan mirpe bipiwarreng. ");
INSERT INTO upv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Erpok, emawos re nik, Tata, nelesien som. ");
INSERT INTO upv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nanu jijle Tata suk elair pa tevi inu. Ko sete jinibb san orongwose inu Natu Atua, Tata suk kobbong. Ko sete san orongwose Tata suk kele, inu kobbong Natun nusan, ko si nga memrreni kele beviseni Tata suk tevi ni. ");
INSERT INTO upv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kapini ji inu, kami nga kamp̃elak milep ko kamtetaur milep, ko inu bea-lai mosien tevi kami. ");
INSERT INTO upv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ko kapwosi nai soloslo suk re birpari kami, ko kapivi jinibb ne majingen suk, ko kapmeteni re inu. Suri inu numalum, ko nolok ean ngatan temijpal, ko kapa-lesi mosien re nem̃i kami. ");
INSERT INTO upv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Suri nai soloslo suk sete majingen nen orrow, ko detauren suk nga bea-lai tevi kami kapsoloi esisarow kobbong.” ");
INSERT INTO upv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Renge daron nen, renge nabong ne Sapat san, ko Iesu ko jinibb sen nir arivel rrurrngi orsel ne wit san. Ko jinibb sen nir, numer ajir, ko artipatun arsesri sursele wene wit nir, ko arurroi. ");
INSERT INTO upv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ko daron nga Parasi marlesi, ko arlesi esij, suri evi nabong ne Sapat. Ko arwerai tevi Iesu: “E, kuplesi, jinibb som nir artor otvi nesesreien ne nabong ne Sapat!” ");
INSERT INTO upv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ko ni owrai tevi Parasi nir, “Nurrorrmi sete kammeteni suri nanu nga Numal Devet muloli nabong san tuwi, daron nga numer m̃iaji ni ko jinibb sen nir. ");
INSERT INTO upv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ko ean loloim se Atua ko elai niv nga jinibb ne sulsulen marlai pa tevi Atua musuw, ko ni ko jinibb sen nir nga marpitevi ni arurroi. Ngok nale nesesreien ewer orer nga sete parurroi, jinibb ne sulsulen kis kobbong parurroi. Ko nosp̃en nen ejkie ji Atua. ");
INSERT INTO upv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ko rreknga sete kammeteni kele renge nale nesesreien nga renge nabong ne Sapat nir, ko jinibb ne sulsulen nir ne Naim On se Atua arok-tor ototvi nesesreien ne nabong ne Sapat daron nga marmajing majingen ser, ko nosp̃en nen ejkie ji Atua. Kammeteni ko pa, ko kamrrelenge. ");
INSERT INTO upv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ko nuwrai tevi kami, inu ngel, nulep asi Naim On. ");
INSERT INTO upv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ko poro nga kaprongwose mining ne nale ngel nga muto kele re Naul On, ‘Atua owra sete kaprrorrmi sulsulen ko nanu nga marirpok nir, ko kaprrorrmi suri jinibb,’ ko sete kapsup̃e suri nir ngok nga nosp̃en ser mijkie. ");
INSERT INTO upv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ko inu Jinibb Mawos nuvi numal ne Sapat.” ");
INSERT INTO upv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ko Iesu evel rujruj kele sopon, ko ean re naim gortien ser san. ");
INSERT INTO upv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ko jinibb san nga nevren mimij elik iok. Ko Parasi nir armerreni parloli Iesu puloli nanu san nga nosp̃en nen putoe. Ko arsusi tevi, arwera “Erpese? Evi nanu nga m̃irres nga parloli jinibb p̃irres luwi re nabong ne Sapat, rreknga ejki?” ");
INSERT INTO upv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ko ni owrai lweni tevir, “Poro nga kami san sipsip sen san otoe, ko sipsip nen pivitan re bbulwil san re nabong ne Sapat, ko ni sete mia-van mia-rrul ren ko pirvei tweni, ko p̃ilngi kurtweni kobbong, puto iok? Ejki, pian ko wor, pirvei tweni. ");
INSERT INTO upv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ko jinibb elep asi wor ean mare re sipsip. Ngok, erres ko pa nga parloli p̃irres re nabong ne Sapat.” ");
INSERT INTO upv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Vitunen, ko ni owrai tevi jinibb nga nevren mimij, “Kup̃ete nevrem.” Ko ni ete nevren emetet, ko nevren erres luwi erpe nevren devjen. ");
INSERT INTO upv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ko Parasi nir arlolarsi, ko arivare ko armurri suri sel nga parevji pini Iesu ren. ");
INSERT INTO upv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu orongwose norrorrmien ser, ko evel lingi ie. Ko delung arvijuri ni, ko ni ololi nir jijle nga marmesi arres luwi. ");
INSERT INTO upv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","“Ko ni ewer ore nir nga nir sete parsup̃sup̃e ni. ");
INSERT INTO upv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngok eplari osorsan tevi nale san se Atua nga propet Aesea muwrai tuwi: ");
INSERT INTO upv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“M̃erel evi jinibb ne majingen suk nga motobbtobbue ko nga memrreni, ko nurnge erres elep suri ni. Bea-loli Nem̃ik pia-silvi ni, ko ni pia-van pia-wer tweni nesesreien suk nga mimawos tevi m̃eri vare nir. ");
INSERT INTO upv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Sete orongwos p̃ilat, ko sete orongwos p̃ikail vijajeng p̃elak; ko sete san orongwos purnge drrelan re sel nga marlelep nir nga nir elep marivel asasi ren. ");
INSERT INTO upv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni pivi jinibb malum tevi nir nga marmeljakov ko tevinir nga derteren ser mijkie. Ko ni pok-loli pirpok pijpari daron nga ni pia-loli jile pa nesesreien nga mimawos nga pia-asi ko pia-to p̃iterter jer. ");
INSERT INTO upv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ko jinibb ne vare nir parlingi nolor p̃iterter re ni.” ");
INSERT INTO upv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ko vitunen arpitevi jinibb san nga demij m̃isisilvi ko mivi metrrorr ko nabbut vini ji Iesu. Ko ni ololi erres luwi, ko erij vajin ko okluklu. ");
INSERT INTO upv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ko delung nir bbösa elair e, ko arwera “A, rreknga ni evi metka mawos se Numal Devet nga rramok-teravi!” ");
INSERT INTO upv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ko Parasi nir daron nga marunge, arwera “M̃erel elai derteren nga pok-ojoji demij e ji Bielsepal kobbong, numal se demij nir.” ");
INSERT INTO upv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ko Iesu orongwose norrorrmien ser, ko owra tevir: “Poro vanu p̃isan jinibb nen nir parteri wukari meling nen p̃ieru e, ko vanu nen pivitan p̃isij. Ko poro nga ngaim p̃isan rreknga niaken p̃isan jinibb nen nir parteri wukari devjen p̃ieru e, ko ngaim nen rreknga niaken nen setete orongwos porlik p̃irres, porvitan ko. ");
INSERT INTO upv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ko poro nga Demij pok-ojoji demij sen nir, ko ololi meling eru e, ko ortertere lweni nuru, ko batun vanu sen p̃irres pirpese? Pivitan ko. Ngok kamsarr nga kamwerai inu nulai derteren suk ji Bielsepal, numal se demij nir. ");
INSERT INTO upv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ko poro nga pivi weretunen nga inu nomok-lai derteren suk nga boji tweni demij e nir ji Bielsepal, ko pirpese kele re jinibb se kami nir? Suri nir kele arok-ojoji demij nir. Ko arok-lai derteren ser ngabe ko? Erres nir parlesi suri nale se kami nga kamwerair ngok. ");
INSERT INTO upv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ko poro nga b̃elai derteren suk nga boji tweni demij e nir ji Nem̃in On se Atua, ngok batun vanu se Atua eplari le pa ji kami. Kaprrorrmi p̃irres suri nanu ngok. ");
INSERT INTO upv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ko erpok kele, sete jinibb san orongwos pian nawon lolo naim se jinibb nga m̃iterter san ko p̃ila nijor sen nir. Ejki, pian puwomu ko p̃isre totoni m̃ernen, ko vitunen vajin pia-lai p̃etp̃eti nijor sen jile nir. Ko m̃ernen erpe Demij, nga Nem̃in On esre totoni pa osuw. ");
INSERT INTO upv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ko poro san sete p̃imajing tevi inu, erpe etre inu ko; ko poro san sete p̃iser kortoni tevi inu, ngok erpe ewirrwirr sisamis nir. ");
INSERT INTO upv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Niko nuwrai tevi kami, nololien jile nir ko nale nga m̃isij jile nir, Atua orongwose p̃itlasi tweni renge jinibb nir. Ko nale nga marsopsop̃e ma Nem̃in On e, Atua sete orongwose p̃itlasi tweni rragrrage renge jinibb. ");
INSERT INTO upv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ko poro san p̃irij p̃isij ko pusopsop̃e inu Jinibb Mawos, ko Atua orongwose p̃itlasi tweni rengen. Ko poro san p̃irij p̃isij ko pusopsop̃e Nem̃in On, ko Atua sete orongwose p̃itlasi tweni rengen lelingen ngel, ko tuwi ngok vini. Ngok kapmetmet nga sete kapwerai nga inu nula derteren suk ji Demij. ");
INSERT INTO upv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Poro nai san p̃irres, ko wenen kele p̃irres. Ko poro nai san p̃isij, ko wenen kele p̃isij. Suri nai jijle arlesi wose renge wenen. ");
INSERT INTO upv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kamivi jinibb nga kamsij, kamivi metka ne num̃et. Kapwera nanu nga parres sopon pirpese? Suri, sev nga muwun saut re nolor, niko jingor marwera tweni. ");
INSERT INTO upv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jinibb nga m̃irres okwera tweni nanu nga m̃irres kobbong nga muto renge nolon; ko jinibb nga m̃isij okwera tweni nanu nga m̃isij kobbong nga muto renge nolon. ");
INSERT INTO upv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nuwrai tevi kami, bebje nale jijle nga jinibb sete murrorrmi muwomue, ko muwra tweni, Atua pia-lesi suri nir jijle renge nabong nga puwra suri lat nga puto suri tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Renge rijen som ko nir, Atua pia-werai ko nik kurres, rreknga kusij.” ");
INSERT INTO upv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Vitunen ko jinibb nevisvisenien ne nale nesesreien sopor ko Parasi sopor arkerkerasi Iesu, ko arsusi tevi, arwera “Jinibb nevisvisenien, nammerreni kupviseni nelesien san tevi kem, nablesi. Ko ngok nabrongwose nga weretunen nik kuvel ji Atua vini.” ");
INSERT INTO upv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ko ni owra lweni tevir, “Kamivi dul nga m̃isij, kamok-loli esij tevi Atua erpe nesevin san nga mok-loli m̃isij tevi diwen sen. Erpese kammerreni beviseni nelesien san tevi kami kaplesi? Kapa-lesi kobbong nelesien p̃isan, nga pusorsan tevi nelesien se propet Jona nga miplari tuwi. ");
INSERT INTO upv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Erpe Jona elik nutrin itul ko nutpong itul renge depai nai nga milep nen, pirpok ko inu Jinibb Mawos bea-lik nutrin p̃itul ko nutpong p̃itul renge lolo dan. ");
INSERT INTO upv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ko renge nabong nga Atua pia-wera suri lat nga puto suri tevi jinibb nir, jinibb nir ne Nineve para-tur imare ko para-sup̃e suri kami. Suri nir nolor arlululwi daron nga Jona m̃iwerwer tuwi. Ko kaplesi inu ngel, nulep asasi Jona, ko kami sete nolo kami olululwi daron nga inu m̃ewerwer tevi kami. ");
INSERT INTO upv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ko renge nabong nga Atua pia-wera suri lat nga puto suri tevi jinibb nir, nesevin nga tuwi nga mivi kwin se nir ne Saot pia-tur imare ko pia-sup̃e suri kami. Suri ni evel ngasu p̃elak renge bongsi vanu vini, owra purongwose norongwosien se Numal Solomon. Ko kaplesi inu ngel, nulep asasi Solomon. Ko suri sev kami sete kamini ji inu? ");
INSERT INTO upv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Moro nga nem̃in nga m̃isij san nga m̃isilvi jinibb san mivel lingi ni, ko evel rrurrngi lat nga nuwi mijki e, epejpej lat nga p̃ilik p̃irres ren; ko sete otor sweri san. ");
INSERT INTO upv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mian ko owra ‘O, bolwi kele van re naim suk, lat nga mevel lingi vini.’ Ko daron nga mijpari, elesi naim sen obbubbil, ko elesi aruruk vaseni pae osuw, ko arjuroi erres. ");
INSERT INTO upv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Elesi jile naim sen musuw, ko olwi van ko elesi nem̃in ebut kele nga marsij asie ni, ko nir jijle aran loloim ko arlik iok. Ko morok vajin nga nem̃in nga marsij marsilvi elik esij easi re nga m̃ilik womu. Ko pirpok kele ko tevi kami nga kamivi dul nga kamsij.” ");
INSERT INTO upv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Daron nga m̃irij malum mirpok tevi delung nir, ko tasu sen ko tasin nir arini. Ko artur vare ko arngoni tevi jinibb sen nir nga parij tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ko san owrai tevi Iesu, “Tasu som ko tasim nir nir le vare, ko arngoni nik nga parij tevi nik.” ");
INSERT INTO upv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ko Iesu owra lweni tevi ni nga muwrai tevi ni, “Isi evi tasu suk, ko isi arivi tasik?” ");
INSERT INTO upv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ko ni esareni nevren mawos jinibb sen nir ko owra “Nir ngel le arivi tasu suk ko tasik nir. ");
INSERT INTO upv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Suri si nga puloli marongen se Tata suk nga m̃ilik re melrin mare, ni ko evi pa tasik ko jojik ko tasu suk osuw.” ");
INSERT INTO upv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Re nabong mawos nen, Iesu eivare lingi naim nen, ean elik re devje nuwito ne Galili. ");
INSERT INTO upv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Elik, ko delung nga milep sopor arini arkorti rrale ni. Ko suri nir elep p̃elak, ni otur imare ko esa van renge drrav san ko esakel rengen. Ko delung jile artur jer ngaut. ");
INSERT INTO upv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ko ni osp̃e suri nale rrongrrongvi elep tevi nir. Owra “Kapmurrong. Jinibb san nga mok-jijreni jelangin ean tweni p̃ijijreni jelangin orsel. ");
INSERT INTO upv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ko daron nga mok-jijreni e, ko ejijreni aseni sopon, ko jelangin sopor arvitan re devje sel e. Ko numön nir arini artasi twenir. ");
INSERT INTO upv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ko sopor arvitan van re dan ne nevöt, lat nga sete dan mimtul e. Ko moro maretiv, arpelari ngavilvilsen imare, suri sete arto ngatan p̃elak re nolo dan. ");
INSERT INTO upv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ko daron nga nial m̃isner, ko armeli. Ko suri lap̃er sete evter, ko armij. ");
INSERT INTO upv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ko sopor arvitan van re lolo moku, ko moku emra tevtev nir, ko emelngi orer. ");
INSERT INTO upv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ko sopor ma sete arwij lingi dan nga m̃irres nen, armatur jer renge dan nga m̃irres nen, ko armaur erres, ko arwen. Ko sopor wener ongut (100), ko sopor wener ngavöl ouwon (60), ko sopor wener ngavöl itul (30). ");
INSERT INTO upv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Isi nga boron otoe, purnge re nolo boron!” ");
INSERT INTO upv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ko Iesu jinibb sen arini ji ni ko arsusi tevi: “Suri sev komok-sup̃e suri nale rrongrrongvi tevi nir?” ");
INSERT INTO upv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ko ni owra lweni tevir, owra “Atua elai tevi kami nga kaprongwose nanu nga marto teptepi renge batun vanu ne melrin, ko sete elai tevi nir nga ngok nga parongwose. ");
INSERT INTO upv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Si nga norongwosien sen mutoe, Atua pia-lai pilep kele tevi ni. Ko si nga norongwosien sen muwelili jer, Atua pia-la tweni jin. ");
INSERT INTO upv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nomok-sup̃e suri nale rrongrrongvi tevi nir, suri arok-lesi ko sete arok-lesi wose, ko arok-runge ko sete arok-rongwos kele e. ");
INSERT INTO upv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Renge nir ngel eplari erpe nale san se Atua nga propet Aesea osp̃e wowomue, owra ‘Kapa-runge pilep, ko setete kama-rongwose; ko kapa-lesi pilep, ko setete kama-lesi wose. ");
INSERT INTO upv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Suri jinibb ngel nir batur eterter ko boror arwonwon ko meter arp̃il, ko arwera “Rratlesi tevi meterr, ko rratrunge tevi bororr, ko rratrongwose re nolorr, ko nolorr tulululwi, ko Atua tia-loli kerr rratrres luwi!” ’ ");
INSERT INTO upv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ko kami ma, kamlik erres, suri mete kami arok-lesi, ko boro kami arok-runge. ");
INSERT INTO upv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nuwretun nuwrai tevi kami, propet elep ko jinibb nga marres elep ne tuwi armerreni elep parlesi nanu nga kamlesir ngel nir, ko sete arlesir; ko arwera elep parunge nanu nga kami kamrunger ngel nir, ko sete arunger. ");
INSERT INTO upv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kaprunge kele ta jilweren rrongrrongvi suk suri jinibb nga mok-jijreni jelangin, bowra tweni vajin. ");
INSERT INTO upv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Poro jinibb san purnge nga marsup̃e suri batun vanu ne melrin ko sete purongwose nale nen, Demij pivini ko p̃iteseni tweni nale nga mietiv renge nolon. Ngok erpe pa jelangin nga marvitan re devje sel. ");
INSERT INTO upv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ko jelangin nga marvitan renge dan ne nevöt, erpe pa jinibb san nga murnge nale, ko m̃ilai ngavilvil, ko eir elep. ");
INSERT INTO upv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ko lap̃en ejki malume, ko orongwos puto bbong beblen; ko daron nga nanu nga m̃iterter mivini, rreknga poro nga jinibb sopor partur imare parloli p̃isij tevi ni suri nale nga muosuri, ko ni elngi kurtweni evesane. ");
INSERT INTO upv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ko jelangin nga marvitan renge lolo moku, erpe pa jinibb san nga murnge nale; ko suri orrorrmi p̃elake nanu ne iel ngatan nir, ko suri emrreni joron pilep, nanu ngok nir armelngi nale nga mimaur ren, ko arloli wenen ejkie. ");
INSERT INTO upv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ko jelangin nga marvitan re dan nga m̃irres, erpe pa jinibb sopor nga marunge nale, ko marongwose, ko marlai wener. Ko wenen nir sopon ejpari ongut (100), ko nir sopon ngavöl ouwon (60), ko nir sopon ngavöl itul (30).” ");
INSERT INTO upv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ko Iesu ela nale rrongrrongvi m̃inij kele san tevi nir, owra “Renge batun vanu ne melrin, Atua puloli pusorsan tevi murru jinibb ngel: Jinibb san ean ejijreni jelangin nga m̃irres ne wit re orsel sen. ");
INSERT INTO upv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ejijreni jijle osuw, ko daron nga jinibb marmatur e, ko ni devje nuval sen evini ko ejijreni jelangin nga m̃isij oto tevi wit nen, ko evel. ");
INSERT INTO upv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ko mian ko jelangin nen nir aretiv vajin, ko armaur, ko arwen. Ko arlesi wose vajin mösmös nga m̃isij nen mutur tevir, suri wenen enije. ");
INSERT INTO upv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ko jinibb ne majingen se m̃er nga orsel sen nir arini jin ko arwerai tevi ni: ‘Numal, erpese? Kujijreni jelangin nga marres renge orsel som, ko mösmös nga m̃isij ngel evan erpese?’ ");
INSERT INTO upv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ko ni orongwose ko owrai tevi nir, ‘Devje nuval ko ololi nanu ngel.’ Ko jinibb sen arwerai kele tevi ni, ‘Ko kumarong kem naban nabrrangi twenir?’ ");
INSERT INTO upv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ko ni owra ‘Ejki, pijki, daron nga poro kaprrangi mösmös nga m̃isij e, takrrangi tweni wit nga m̃irres tuto tevir. ");
INSERT INTO upv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kaplinglingir parmaur korti pijpari daron ne numös. Ko renge daron ne numös ngok, bea-werai tevi nir nga partawer, “Kapser kortoni mösmös nga marsij puwomu, ko kapserer parivi bböbbti nga para-sulir. Ko kapsere wit nen pian renge b̃ep̃eim suk.” ");
INSERT INTO upv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ko ni ela nale rrongrrongvi m̃inij kele san tevi nir, owra “Batun vanu ne melrin osorsan tevi jelangi nubek nga mivitan re nai san. ");
INSERT INTO upv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jelangin nen ewelili jer lingi jelangin m̃inij nir, ko daron nga mimaur, elep lingi nai nir. Ko numön ne mesa nir arini arok-loli menu ner renge rengsin nir.” ");
INSERT INTO upv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ko ni ela nale rrongrrongvi m̃inij kele san tevi nir, owra “Batun vanu nemelrin osorsan tevi is nga nesevin m̃ilai m̃ilngi renge besin nga milep san nga muwune plaoa, ko m̃ikiskisi. Ko setemun arlesi is nen, ko ololi niv jile epau.” ");
INSERT INTO upv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nanu ngel jile nir, Iesu osp̃e tevi delung nir renge nale rrongrrongvien. Poro nale rrongrrongvi pijki, ko sete mia-sup̃e nanu san tevi delung nir. ");
INSERT INTO upv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngok eplari osorsan tevi nale san se Atua nga propet san muwrai tuwi: “Bea-sa jingok, ko bea-lai nale rrongrrongvi, bea-werwerai tweni nanu nga marteptepi re iel ngatan m̃itipatun mivini mijpari lelingenok.” ");
INSERT INTO upv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Vitunen ko Iesu evel lingi delung nir, ko evan loloim re naim. Ko jinibb sen nir arini ji ni ko arwera “Kupwera suri ta tevi kem nale rrongrrongvi ne mösmös nga m̃isij renge orsel ngok.” ");
INSERT INTO upv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ko ni owra lweni tevir, owra “Jinibb nga m̃ijijreni jelangin nga m̃irres ngok erpe pa inu ko, Jinibb Mawos. ");
INSERT INTO upv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Orsel ngok erpe pa iel ngatan ko. Ko jelangin nga marres ngok arirpe pa jinibb nir ne batun vanu ne melrin ko, ko jelangin nga marsij ngok arirpe pa jinibb se Demij ko nir. ");
INSERT INTO upv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ko devje nuval nga m̃ijijrenir erpe pa Demij ko. Ko numös ngok erpe pa iel ngatan ko bongsin nga pia-suw e ko pa, ko nir nga martawe ngok arirpe pa anglo ko nir. ");
INSERT INTO upv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pusorsan tevi nga marser kortoni mösmös nga marsij nir ko marsuli, pia-sorsan kele tevi iel ngatan bongsin nga pia-suw e. ");
INSERT INTO upv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Inu Jinibb Mawos bea-koni anglo suk nir, ko nir para-sere kortoni nir nga marok-loli jinibb parong tweni nale suk ko nir nga marok-loli nololien nga marsij renge batun vanu suk. ");
INSERT INTO upv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Para-sere kortonir jile, ko para-wirrer van re nabb. Iok ngok jinibb para-ting ko para-runge p̃isij pilep. ");
INSERT INTO upv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ko renge daron nen jinibb nga marres nir pia-irpe nial, para-mor renge batun vanu se Tata ser. Kaprunge renge nolo boro kami! ");
INSERT INTO upv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Batun vanu ne melrin osorsan tevi nijor nga m̃irres san nga muto teptepi renge orsel, nga poro jinibb san putor sweri, ko p̃ir pilep ren, ko p̃isilveni kele. Ko suri eir elep ren, ko pian puwulwule joron jijle nir, ko puwli tweni orsel ngok, nga nijor nen pivi sen ko vajin. ");
INSERT INTO upv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ko erpel kele, batun vanu ne melrin osorsan tevi nevöt san nga marok-lai lolo botrrum. Ko jinibb san nga mokwuli nevöt ngok nir, ");
INSERT INTO upv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","daron nga mutor sweri nevöt nga nowlin milep temijpal ngok san, ko olwi van owulwule joron jijle nir ko ela nevöt nen, ko owli tweni vajin nevöt ngok evi sen. ");
INSERT INTO upv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ko erpel kele, batun vanu ne melrin osorsan tevi niva san nga marwirre renge dis, ko nai jijle maron ren. ");
INSERT INTO upv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ko daron nga niva nen puwun, parevei van ngaut e. Ko parlik ngatan, ko parla mesal nga marres parsongni van re narr; ko nga marsij nen, parwirr twenir. ");
INSERT INTO upv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pia-irpok kele ko renge daron ne iel ngatan bongsin. Anglo nir para-vini para-la tweni jinibb nga marsij re nir nga marres, ");
INSERT INTO upv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ko parwirrer van re nabb. Iok ngok jinibb para-ting ko para-runge p̃isij pilep.” ");
INSERT INTO upv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu osusi tevir, “Kamrongwose nanu ngel nir?” Ko nir arwera lweni tevi: “O-o.” ");
INSERT INTO upv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ko ni owrai kele tevir: “Ko jinibb nevisvisenien ne nale nesesreien san nga marok-visvisenie pa renge murru batun vanu ne melrin erpe jinibb san nga murongwos p̃ila tweni nanu nga mimerr ko nanu nga m̃itra renge narr sen. Suri jinibb nevisvisenien nen ne nale nesesreien orongwos pae suri nale se Atua ne tuwi ko ne lelingenok kele.” ");
INSERT INTO upv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Daron nga Iesu musuw re nale rrongrrongvi ngel nir vajin, ko evel lingi ie, ");
INSERT INTO upv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ko olwi vajin vini re ngaim sen e. Ko evisviseni jinibb nir re naim gortien ser; ko jinibb nen nir bbösa elair e, ko arwera “E, m̃erel ela norongwosien ko derteren ngel ngabe? ");
INSERT INTO upv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ni ngel evi metusu lebbong san natun, ko tasu sen marveruse Merri, ko tasin nir Jemes, ko Josep, ko Saemon, ko Jutas. ");
INSERT INTO upv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ko jojin le ngel nir marlik tevi kerr. Ko m̃erel ela nanu ngel nir ngabe ko?” ");
INSERT INTO upv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ko arong karkare ni. Ko Iesu owrai tevir, “Propet san parosuri ko wor, sete mia-jiki; ko renge nir nga re ngaim sen ko nir nga niaken sen, san pijki.” ");
INSERT INTO upv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ko setemun ololi majingen elep iok, suri arong tweni nale sen. ");
INSERT INTO upv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Renge daron nen, Erot natun san nga marveruse Erot Antipas, ornge nosp̃en nga marsup̃e Iesu e. ");
INSERT INTO upv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ko owrai tevi jinibb sen nir, “M̃erel evi Jon Baptaes le. Ni emra renge mijen, niko derteren sen mutoe nga muloli majingen nga marinijnij nawone nir.” ");
INSERT INTO upv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Owrai erpok suri nanu san nga miplari seveling nga, erpel: Erot etka luwe Erotias, nesen se tuwan Pilip. Ko Jon owra tevi Erot, “Sete evi nesesreien nga mimawos nga nik kupteka luwe nesen se tuwam.” Daron nga muwrai mirpok, ko Erot orrul totkoni ni ko esre totkoni, ko elngi ni van re naim ne nekaien, suri Erotias sete emrreni Jon p̃irij pirpok. ");
INSERT INTO upv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ko Erot owra pirevji pini Jon, ko emtutue delung nir, suri nir arwera ni evi propet san. ");
INSERT INTO upv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mian ko vitunen vajin, nir arloli nabong san suri sia se Erot ejpijp̃et. Ko Erotias natun nesevin m̃elakel esew re no nir, ko Erot elesi erres. ");
INSERT INTO upv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ko ololi rijrijen tevi, owra “Sev nga kupungoni, ko inu bea-lai ko tevim.” ");
INSERT INTO upv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ko nesen m̃elakel nen erij nale se tasu sen, owra “Kuplai tevik iel batu Jon Baptaes renge narov san.” ");
INSERT INTO upv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ko Erot ornge esij e; ko suri m̃irijrij pa ko nir nga marini maraan tevi marunge pa, ko ololi owra nale tevi jinibb sen nir nga parlai tevi nesen m̃elakel nen. ");
INSERT INTO upv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ko okoni jinibb sen san pian renge naim ne nekaien ko p̃ita otvi batu Jon Baptaes. ");
INSERT INTO upv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","M̃ernen evan, ololi erpok, ko elngi batu Jon Baptaes re narov san. Ko esale tevi nesenwarreng, ko nesenwarreng esale elai tevi tasu sen. ");
INSERT INTO upv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ko vitunen, Jon jinibb sen nir arini, arwosi Jon niben, ko arivel tevi van, artevni. Artevni jile Jon, ko vitunen aran arwerai tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ko daron nga Iesu murnge nanu ngel nir, esa re drrav ko evel lingi ie; owra pian re lolo merwer, ko p̃isan p̃ilik sopon. Ko delung nir, daron nga marunge, ko arivel lingi ngaim ser nir, ko arvijuri, arivel re jeli nuwi. ");
INSERT INTO upv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ko Iesu, daron nga mujubbul re drrav, elesi delung elep. Ko orrorrmi nir elep, ko ololi nir nga marmesi arres luwi. ");
INSERT INTO upv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mian ko nat erivriv vini, ko jinibb sen arini jin, arwerai tevi ni, “Iel evi lolo merwer le, ko nat tupong mun. Kupkoni tweni lartul ngok nir parivel paran re ngaim nir parwuli nanen ser.” ");
INSERT INTO upv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ko Iesu owra lweni tevir, “Nir sete mara-ivel. Kami ko kapla nanen tevir paraani.” ");
INSERT INTO upv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ko nir arwera lweni tevi “Ai, kem namtori bbong niv elim le ko nai eru.” ");
INSERT INTO upv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ko ni owra “Kaplair ta vini jik.” ");
INSERT INTO upv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ko owrai tevi delung nir parlik ngatan re mösmös. Ko ni ela niv nga elim nga ko nai nga eru nga, ko oklu imare van re melrin owra erres tevi Atua rengen, musuw ko otpoi ko elai tevi jinibb sen nir; ko nir arlai tevi delung nir. ");
INSERT INTO upv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ko nir jijle arurroi, mian ko arup vajin. Ko jinibb sen nir arsere kortoni bebjen nga marjijpon nen nir van renge narr esngavöl drromon eru arwun saute. ");
INSERT INTO upv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ko nir nga marurroi ngok arever erpe nuvasngavöl nuvalim (5000) norman kis, ko nesevin ko bipiwarreng kele sete arever. ");
INSERT INTO upv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ko ngavilvil ololi jinibb sen nir arsa kele re drrav, parwowomu van re devje nuwi, parteravi ni nga ni pukoni tututweni delung nir parivel. ");
INSERT INTO upv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Daron nga mukoni tututweni delung nir marivel musuw, ni esan otongsa van re botwen nga pulot. Olot mian, ko nat opong vajin, ko ni esan malum iok. ");
INSERT INTO upv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ko jinibb sen nir nga marla drrav aran vajin re liven mesa re nuwito. Ko daptap ne nuwito arus renge drrav, suri arwolu tere ling. ");
INSERT INTO upv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Marwolu tere ling mirpok mian, ko nat otomori p̃isal p̃irin vajin, ko Iesu evel mare re nuwi vini pivini ji nir. ");
INSERT INTO upv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ko jinibb sen nir arlesi ni mivel mare re nuwi ko armetutu, arwera “O, nem̃in ko san!” Ko arkail mare suri armetutu. ");
INSERT INTO upv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ko Iesu erij tevir evesane, owra “Nolo kami p̃irres, inu lebbong, sete kapmetutu.” ");
INSERT INTO upv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Daron nga ni muwrai mirpok ko Pita erij weli lweni ni, owra “Numal, poro weretunen evi nik, kupwerai tevi inu nga inu bevel mare re nuwi vinuk jim.” ");
INSERT INTO upv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ko ni owra “Kupini.” Ko Pita orow jubbul re drrav, ko evel mare re nuwi pian ji Iesu. ");
INSERT INTO upv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mivel mian, ko elesi ling eser eterter, ko emtutu vajin, ko etipatun purron. Ko ekail owra “Numal, kupla se inu!” ");
INSERT INTO upv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ko Iesu esareni nevren ngavilvil ko orrul ren, ko owra tevi, “Nik nosurien som ewelili, ko erpese norrorrmien som eru e?” ");
INSERT INTO upv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ko daron nga morini morsa re drrav, ko ling omol vajin. ");
INSERT INTO upv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ko jinibb se Iesu nir nga renge drrav arlotoe ni ko arwera “Weretunen, nik kuvi Atua natun.” ");
INSERT INTO upv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ko arwolu re drrav, arwolu toku renge devje nuwito renge ngaim san, nisen Genesaret. ");
INSERT INTO upv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ko daron nga jinibb ne lat nen nir marlesi wose Iesu, arla nale van ji nir nga marlik rrale ie. Ko jinibb nen nir artekai jinibb nga marmesi vini ji ni, ");
INSERT INTO upv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ko arungoni tevi Iesu nga parjipari kobbong bongsi sunsun sen. Ko ni emarong, ko nir jijle nga marjipari arres luwi. ");
INSERT INTO upv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Renge daron nen ko Parasi sopor ko jinibb nevisvisenien ne nale nesesreien sopor arivel Jerusalem vini ji Iesu, ko arwerai tevi ");
INSERT INTO upv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Erpese jinibb som nir martor otvi nale se b̃irterawarreng nir? Suri sete arjejavöl daron nga maraan e.” ");
INSERT INTO upv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ko ni erij weli lweni nir owra “Erpese kami kele kamtor otvi nale nesesreien se Atua nga kamok-vijuri nale se b̃irterawarreng se kami nir? ");
INSERT INTO upv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Suri Atua nale nesesreien sen owra ‘Kuprrorrmi lilane tata som ko tasu som,’ ko nale san kele erpel: ‘M̃er nga m̃irij m̃isij tevi tata sen rreknga tasu sen sete orongwos pimaur, kaprevji pini ko wor.’ ");
INSERT INTO upv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ko kami ma kamwera ‘Isi nga pia-werai tevi tata sen rreknga tevi tasu sen: “Nulai pa merrenien tevi Atua, setemun inu mea-lai kele tevi nik,” ");
INSERT INTO upv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","erij erres, ko sete mia-osuri mun tata sen ko tasu sen renge nanu ngok.’ Erpok nale se kami owra nale m̃inij re nale se Atua, nga setemun parvijuri. ");
INSERT INTO upv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kamiel re sel eru! Aesea orrongvi kem̃kam̃e kami erres, daron nga muwra wowomue suri kami: ");
INSERT INTO upv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Lartul ngel nir arosuri inu tevi nevlu jingor kobbong, ko nolor oto ngasue inu. ");
INSERT INTO upv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Arloto nawone inu, arvisviseni nevisvisien nga mivi se jinibb bbong.’” ");
INSERT INTO upv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ko Iesu everuse delung nir ko owrai tevir, “Kaprunge nanu ngel ko kaprongwose. ");
INSERT INTO upv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sete nanu nga mian re nolo jinibb ololi ni orro (ngok evi norrorrmien se nir nga marok-jejavöl tajer kobbong); ko ngel ko ma, nanu nga miplari re nolo jinibb ololi jinibb orro.” ");
INSERT INTO upv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ko vitunen jinibb sen nir arini jin, arwerai tevi ni: “Nik kurongwose nga Parasi nir marunge m̃isij e nanu nga kumwerai ngok?” ");
INSERT INTO upv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ko ni erij weli lwenir, owra “Nanu jijle nga Tata suk nga m̃ilik re melrin sete murwir, pia-rrangi tweni ko. ");
INSERT INTO upv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kaplinglingi nir parirpok. Arivi metrrorr pa osuw, ko arwera parviseni sel. Ko poro nga metrrorr puwowomue metrrorr renge sel, ko nuru kes pora-vitan van renge bbulwil.” ");
INSERT INTO upv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ko Pita owrai tevi ni: “Kupwera suri nale rrongrrongvi ngok ta tevi kem.” ");
INSERT INTO upv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ko ni owra “Kami kele norongwosien se kami ejki malume? ");
INSERT INTO upv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sete kamrongwose nga nanu jijle nga mian re nolon evan renge depain e, ko parta lev tweni p̃iasi kobbong? ");
INSERT INTO upv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ko nanu nga mivare re jingon eplari re nolon, ko ngok kobbong ololi jinibb orro. ");
INSERT INTO upv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Suri eplari re nolo jinibb ko, norrorrmien nga marsij, nga parevji pini jinibb suri, nga norman pian ji nesevin nga sete evi nesen sen, nga nesevin pian ji norman nga sete evi diwen sen, nga parvenae joro jinibb, nga parkerkeris re kot, nga parsopsop̃e p̃isij Atua rreknga parij p̃isij tere jinibb. ");
INSERT INTO upv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nanu ngel le nir arloli jinibb orro; ko nga paraan sete parjejavöl, sete ololi jinibb orro.” ");
INSERT INTO upv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ko vitunen Iesu evel lingi ie, evel rujruj sopon evan morie Taea ko Saeton. ");
INSERT INTO upv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ko daron nga mivel mori ie mirpok, ko nesevin ne Kenan san nga m̃ilik ie sopon errmali ko ekail van jin, owra “Kuprrorrmi inu, numal, nik metka se Devet! Natuk nesenwarreng, demij arsisilvi ni esij elep.” ");
INSERT INTO upv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ko Iesu sete erij nale weli san tevi nesevin. Mian ko jinibb sen nir arini jin ko arungoni tevi ni: “Kupkoni tweni vinok, suri ekail vijajeng suri kerr.” ");
INSERT INTO upv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ko ni erij weli lweni tevir, owra “Atua okoni inu nga ban ji m̃eri Isrel kis kobbong, nga marirpe sipsip nga marjijki, sete ban ji jinibb m̃inij nir. Ko vinok evi nesevin ne vare san.” ");
INSERT INTO upv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ko vinnen evini ejiol vitan ji Iesu ko owra “Wurru, numal, kupla se inu.” ");
INSERT INTO upv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ko ni erij weli lweni tevi ni, owra “Sete erres nga parla nanen se bipiwarreng nir ko parwirre tevi guli nir.” Ni erij erpok suri m̃eri Isrel nir arok-veruse jinibb ne vare nir arwera “guli” e nir. ");
INSERT INTO upv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ko vin nga owra “Ewretun, numal, ko guli nir arok-urroi ko wor bebje nanen nga marvitvitan re numal ser tep sen.” ");
INSERT INTO upv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Daron nga murnge nale se nesevin ngok, ko Iesu owra lweni tevi: “O, nesevin, nosurien som elep temijpal. Puto pirpe nga nik kumarong.” Ko re mete nial mawos nen vinnen natun erres luwi. ");
INSERT INTO upv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu evel lingi iok ko evini re nuwito ne Galili ko otutur sopon iok; mian ko otongsa van mare re botwen, ko elik ngatan iok. ");
INSERT INTO upv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ko delung elep arini ji ni, arpitevi jinibb nga marmesi sopor, sopor b̃elar rreknga nevrer arsij, sopor meter arrorr, sopor arivi naroj, sopor arivi nabbut, ko nga marmesi mesien lele kele nir; ko arlingir ngatan re b̃ela Iesu. Ko Iesu ololi nir arres luwi. ");
INSERT INTO upv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ko daron nga jinibb nir marlesi nabbut marij, ko nir nga b̃elar ko nevrer marsij arres luwi, naroj marivel, ko metrrorr markulu, bbösa elair e, ko arsurövi Atua se m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Vitunen ko Iesu everus jinibb sen nir vini ji ni, ko owrai tevi nir, “Nurrorrmi lengleng delung ngel nir, suri arpitevik nabong itul le pa, ko nanu nga parurroi ejki. Ko numusus bokoni tweni nawon nir, suri numer ajir pa, ko tarmaob re sel.” ");
INSERT INTO upv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ko jinibb sen nir arwerai tevi: “Rrapla nanen ngabe ko, suri iel evi lolo merwer, ko delung elep p̃elak?” ");
INSERT INTO upv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ko Iesu owrai tevir, “Kamtori niv evis?” Ko nir arwera “Ebut, ko nai wowarreng sopor.” ");
INSERT INTO upv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ko ni owrai tevi delung nir parlik ngatan re dan. ");
INSERT INTO upv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ko ni ela niv nga ebut nga ko nai nga nir, ko olot owra erres tevi Atua suri, ko otpoir ko elair tevi jinibb sen nir; ko jinibb sen nir artututwenir tevi delung nir. ");
INSERT INTO upv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ko nir jijle arurroir, mian ko arup jile. Ko arsere lweni bebje nanen nir nga marjijpon nir van re narr ebut arwun saut. ");
INSERT INTO upv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nir nga marurro niv ko nai nir evi nuvasngavöl vavij (4000) norman kis, ko sete areve nesevin ko nanwarreng nir. ");
INSERT INTO upv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ko Iesu okoni tweni delung nir arivel; ko ni esa re drrav, ko evan morie ngaim san nisen Makatan. ");
INSERT INTO upv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ko Parasi sopor ko Satusi sopor arini. Arwera parrowrrowe Iesu, armerreni ni puloli nelesien san renge derteren ne melrin tevi nir parlesi. ");
INSERT INTO upv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ko ni erij weli lweni tevi nir owra “Daron nga nat mirivriv, ko kami kamok-wera ‘Nat p̃irres ko, suri rramlesi nabor arsongsong.’ ");
INSERT INTO upv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ko daron nga nial pimraej, ko kami kapok-wera ‘Lelingen naus puto tevi ling, suri rramlesi nabor arsongsong ko armotmote.’ Erpese kamlesi wose nabor nir ko kamrongwose nat nga pirpese nga piplari suri, ko kami sete kamrongwose nabong se inu nga meplari ren? ");
INSERT INTO upv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kamivi dul nga m̃isij, kamok-loli esij tevi Atua erpe nesevin san nga mok-loli m̃isij tevi diwen sen! Erpese kammerreni beviseni nelesien san tevi kami kaplesi? Kapa-lesi kobbong nelesien p̃isan, nga pusorsan tevi nelesien se propet Jona nga miplari tuwi.” Ko daron nga Iesu m̃irij jijle mirpok tevir, ko evel lingir. ");
INSERT INTO upv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ko Iesu evini ji jinibb sen nen nir, ko arsa re drrav, arwolu van re devje nuwito e. Ko jinibb sen nir arlesi vajin nga sete arla niv sopor partori suri. ");
INSERT INTO upv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ko Iesu owrai tevir, “Kapmetmet p̃irres renge is se Parasi nir ko Satusi nir.” ");
INSERT INTO upv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ko nir arwerwerai lweni tevir, arwera “O, suri sete rramtori niv, niko m̃irij mirpok.” ");
INSERT INTO upv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ko Iesu orongwose norrorrmien ser ko owrai tevir: “O, kami nga nosurien ewelili, suri sev kami kamwerweraie kami mirpok suri sete kamtori niv? ");
INSERT INTO upv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Setewor kamrongwose? Rreknga setemun kamrrorrmi suri niv nga elim, nga nir evi nuvasngavöl valim (5000) marurroir ko marup e, ko narr evis kele nga kamsere marwun? ");
INSERT INTO upv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Rreknga niv nga ebut nga nir evi nuvasngavöl vavij (4000) marurroir ko marup e, ko narr evis kele nga kamsere marwun? ");
INSERT INTO upv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Erpese sete kamrongwose nga inu sete nusp̃e suri niv? Kapmetmet renge is se Parasi nir ko Satusi nir.” ");
INSERT INTO upv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ko nir arongwos vajine nga ni sete owrai nga nir parmetmet renge is ne niv, ko renge nevisvisenien nga m̃isij se Parasi nir ko Satusi nir. ");
INSERT INTO upv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ko nir artutur kele sopon. Ko daron nga marini mori re Sisaria Pilipae, ko ni osusi tevi jinibb sen nir, owra “Jinibb nir arwera inu Jinibb Mawos nuvi isi?” ");
INSERT INTO upv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ko nir arwera “Sopor arwera nik kuvi Jon Baptaes, sopor arwera nik kuvi Elaeja, ko nir sopon kele arwera Jeremaea, rreknga propet san ne tuwi.” ");
INSERT INTO upv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ko ni owra tevir, “Ko kami, kamwera inu nuvi isi?” ");
INSERT INTO upv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ko Saemon Pita erij weli lweni owra “Nik kuvi Mesaea, Atua nga mimaur natun.” ");
INSERT INTO upv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ko Iesu erij weli lweni owrai tevi ni: “Nik kulik erres ko pa, Saemon natu Jon, suri sete jinibb san ololi kurongwose nanu ngel, ko Tata suk ko nga m̃ilik re melrin ololi kurongwose. ");
INSERT INTO upv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ko inu nuwrai tevim, nik kuvi Pita (nais ngok Pita renge nale se m̃eri Gris nir owra b̃ereng). Nik kupivi batu jinibb suk nir totoklai, pirpe nga marili naim san renge b̃ereng. Ko mijen sete derteren sen evter nga p̃iasie nir. ");
INSERT INTO upv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","B̃ela ki ne batun vanu ne melrin tevi nik. Ko poro nga nik kupwer ore nanu san renge iel ngatan, Atua kele p̃iwer ore; ko poro nga nik kupmaronge parloli nanu san iel ngatan, Atua kele pimaronge parloli.” ");
INSERT INTO upv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","M̃irij jile mirpok, ko ewer ore jinibb sen nir nga sete parwerwerai tweni tevi jinibb san nga ni evi Mesaea. ");
INSERT INTO upv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Etipatun re daron ngok ko Iesu ok-wera suri tevi jinibb sen nir nga ni pian renge Jerusalem ko wor, ko b̃irterawarreng nir ko jinibb nga marlelep re sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir para-loli p̃isij tevi re nanu pilep, niben pia-runge p̃isij e, ko para-revji pini; ko nabong p̃itul ko Atua pia-loli ni pia-tur imare kele. ");
INSERT INTO upv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","M̃irij jile mirpok, ko Pita ervei tweni ni nuru orsan, ko etipatun erij terter tevi, owra “Numal, Atua pia-rrorrmi nik. Setete pia-pelari pirpok ji nik.” ");
INSERT INTO upv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ko Iesu erieni ni ko owrai tevi Pita, “Demij, kupruj ngasue inu! Kuwer ore inu nga sete bololi majingen se Atua. Norrorrmien som sete erpe norrorrmien se Atua, erpe norrorrmien se jinibb kobbong nir.” ");
INSERT INTO upv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Muwrai jile tevi Pita mirpok, ko owrai vajin tevi jinibb sen nir: “Poro san pimarong pivijuri inu, ni putor ore nanu nga ni bbong mimrreni, puwosi nai pelaot sen, ko pivijuri inu. ");
INSERT INTO upv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ko poro san puwra putor totoni mauren sen, mian ko pia-tor jabble; ko poro nga san pimaronge mauren sen suri mivijuri inu, ko mian ko pia-lai vajin mauren nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pia-rres pirpese re jinibb san poro p̃ilai p̃etp̃eti nijor ne iel ngatan nir, ko mauren sen pijijki? Pia-la sev ko pia-wuli lweni mauren sen e? ");
INSERT INTO upv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Inu Jinibb Mawos bea-luwi vini re nosrövien se Tata suk tevi anglo suk nir, ko renge daron nen bea-wuli jinibb jijle nir pusorsan tevi majingen ser sisamis. ");
INSERT INTO upv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nuwretun nuwrai tevi kami, kami sopor nga kamtur iel setete kama-mij wor pijpari nga kapa-lesi inu Jinibb Mawos tevi batun vanu suk vini.” ");
INSERT INTO upv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nabong ouwon easi osuw, ko Iesu etka Pita ko Jemes ko Jemes tasin wor Jon, ko nir arsan aran artongsa van re botwen nga mian mare san. ");
INSERT INTO upv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ko Atua erieni nibe Iesu re no nir; ko Iesu non erinrin erpe nial, ko sunsun sen ow erpe moro nial. ");
INSERT INTO upv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ko artaol arvesane ko arlesi Moses ko Elaeja kele orpelari jin, orjiljilwer tevi. ");
INSERT INTO upv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ko Pita erij van ji Iesu, “O, numal, erres kem namlik pa iel. Poro kumarong, inu b̃eli gorkoraim p̃itul iel, san pivi se nik, san pivi se Moses, ko san pivi se Elaeja.” ");
INSERT INTO upv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Daron nga mok-rij malum mirpok, ko nabor nga m̃irinrin san esalsal orer, ko arunge drrelan san eplari re nabor, owra “Morok evi natuk nga memrreni, ko nurnge erres elep suri ni. Kaprunge ni p̃irres.” ");
INSERT INTO upv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ko daron nga jinibb sen nir marunge, ko armetutu temijpal, ko arsusweni nor van ngatan. ");
INSERT INTO upv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ko Iesu evini jir ko ejparir ko owra “Kapmera, sete kapmetutu.” ");
INSERT INTO upv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ko daron nga markulu imare, sete arlesi jinibb san, Iesu esan bbong. ");
INSERT INTO upv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ko daron nga marok-jubbul re botwen malum, ko Iesu ewer orer, owra “Sete kapwerwera nanu nga Atua miviseni kamlesi re mete kami tevi jinibb p̃isan, pijpari nga inu Jinibb Mawos bea-tur imare luwi re mijen.” ");
INSERT INTO upv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ko jinibb sen nir arsusi rongornge tevi ni arwera “Erpese jinibb nevisvisenien ne nale nesesreien nir marwera Elaeja pia-vini womu ko wor?” ");
INSERT INTO upv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ko Iesu erij welir, owra “Arweretun nga marwerai Elaeja pia-vini ko wor ko pia-loli nanu jijle pia-sorsan. ");
INSERT INTO upv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ko inu nuwrai tevi kami, Elaeja evini pa osuw; ko nir sete arosuri, ko arloli wor sev nga m̃isij nga marmerreni tevi ni. Pirpok kele kobbong nir para-loli p̃isij tevi inu Jinibb Mawos, nibek purnge p̃isij.” ");
INSERT INTO upv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Daron nga m̃irij mirpok ko jinibb sen nir arongwose vajin nga ni sete osp̃e suri Elaeja weretun, ko osp̃e suri Jon Baptaes tevi nir. ");
INSERT INTO upv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ko musuw vajin, arini ji delung nir; ko jinibb san evini ji ni ko ejipa ngatan jin, ");
INSERT INTO upv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ko owra “Wurru, numal, kuprrorrmi natuk norman; nai ok-loli, ko ornge niben esij e elep. Ko nabong elep ok-wajeni re nabb nga m̃in ko re nuwi. ");
INSERT INTO upv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ko nutkai van ji jinibb som nir, ko nir sete arongwose parloli p̃irres luwi.” ");
INSERT INTO upv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ko Iesu owra “Kamivi dul nga nosurien se kami ejkie ko norrorrmien se kami m̃ilengleng. B̃elik tevi kami pijpari seveling? Bornge p̃isij suri kami pijpari seveling? Kaptekai ta bipiwarreng nen vini jik iel.” ");
INSERT INTO upv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ko Iesu otortori demij nga m̃isisilvi ni, ko eivare evel lingi ni. Ko bipiwarreng nen erres luwi re mete nial mawos nen. ");
INSERT INTO upv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ko vitunen, jinibb se Iesu nir arsan arini jin, ko arwera “Erpese kem sete namrongwose naboji tweni demij ngok?” ");
INSERT INTO upv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ko Iesu owrai tevir, “Suri nosurien se kami ewelili jer. Nuwretun nuwrai tevi kami, poro nosurien se kami putoe pirpe jelangi nubek nga welili bbong, ko pivtere nga kapwerai tevi botwen nga milep ngel, ‘Kupruj ngasu iok,’ ko puruj ko. Sete nanu p̃isan kele nga kami sete kamrongwos kaploli. ");
INSERT INTO upv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ko nga paroji tweni demij nga pirpok, parlot ko wor, ko parlinglingi nanen ser, ko niko paroji tweni.” ");
INSERT INTO upv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ko mian ko daron nga marini marlik korti re vanu ne Galili vajin, ko Iesu owrai tevir: “Inu Jinibb Mawos para-teka kerasi inu van re nevre jinibb. ");
INSERT INTO upv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ko jinibb nen nir para-revji pini inu; ko renge nabong itolin, Atua pia-loli inu bea-maur luwi kele.” Ko jinibb sen nir, daron nga marunge nale ngok, ko arunge esij lenglengen e. ");
INSERT INTO upv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ko daron nga marini vajin re Kapaneam, ko lartul nga marok-lai nevöt ne takis nga mivi se Naim On ne Jerusalem arini ji Pita. Ko arsusi tevi arwera “Jinibb nevisvisenien se kami ok-wuli takis ngel, rrek ejki?” ");
INSERT INTO upv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ko ni owra “O-o. Ni ok-wuli ko.” Ko daron nga Pita mian vajin loloim ji Iesu, ko Iesu erij womu tevi, owra “Kurrorrmi sev, Saemon? Numal nga marlelep nir ne iel ngatan arok-lai nevöt ne takis ser ji isi? Ji jinibb ser nir, rreknga ji jinibb neturvitan nir?” ");
INSERT INTO upv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ko Pita owra tevi, “Ji jinibb neturvitan nir.” Ko Iesu owrai tevi ni: “Niko muloli jinibb ser nir sete arongwos parwuli. Ko erpok kele, jinibb se Atua nir, Atua sete orongwose pok-la nevöt jir. ");
INSERT INTO upv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ko rromormusus rroporloli nir nga marok-lai takis ne Naim On parlolar. Kupjubbul van ngatan re nuwi kuptutumun, ko nai nga kupa-revei womue, kupwaki nisen; ko kupa-lesi bebje nevöt san oto ren nga pivtere kerru korti rropora-wuli takis se kerru e. Ko kupan kupwulie tevir.” ");
INSERT INTO upv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Re daron mawos nen malum ko jinibb se Iesu nir arini jin ko arsusi tevi arwera “Isi elep womunen renge batun vanu ne melrin?” ");
INSERT INTO upv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ko Iesu everuse bipi san vini jin ko ololi otur liven re nir, ");
INSERT INTO upv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ko owra “Nuwretun nuwrai tevi kami, Poro norrorrmien se kami sete pulwi pivini pirpe bipiwarreng nir, ko kami setete kamrongwos kapan re batun vanu ne melrin. ");
INSERT INTO upv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Isi nga puloli lweni ni pivi jinibb malum pirpe bipi ngel, ni pilep womunen renge batun vanu ne melrin. ");
INSERT INTO upv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ko isi nga muosuri inu ko mimaronge bipi nga mirpel san pian ji ni, erpe emaronge nga inu kele ban jin. ");
INSERT INTO upv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Poro isi nga puloli nir san nga welili ngel nga muosuri inu pivitan van renge nololien, erres p̃elak renge m̃ernen poro nga parrul totoni womue, ko parruloni nevöt nga milep san renge nowen, ko parjubbli maure re liven mesa re dis, purron van ngatan e. ");
INSERT INTO upv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Esij wor elep niko re jinibb ne iel ngatan ngel nir suri nanu jijle nga marok-loli jinibb nir parvitan. Nanu ngok nir parini ko wor, ko esij elep niko re jinibb nga m̃ilai nanu ngok san vini. ");
INSERT INTO upv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ko pirpel ko, poro nga nevrem rreknga b̃elam porloli kupvitan renge nosurien som, erres ma kupta tweni nuru kupsor tweni nuru van ngasue nik. Evi nanu nga m̃irres renge nik poro kupan renge mauren tevi nevrem p̃isansan rreknga b̃elam p̃isansan, easi re poro nevrem korti nuru ko b̃elam korti nuru, ko parwirre nik van re nabb nga p̃in tuwi ngok vini. ");
INSERT INTO upv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ko poro nga metem puloli kupvitan, kupla tweni ko kupwirre van ngasue nik. Evi nanu nga m̃irres renge nik poro kupan renge mauren tevi metem p̃isan, easi re poro metem korti nuru ko parwirre nik van re nabb ne norongen nga m̃isij. ");
INSERT INTO upv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kapmetmet renge kamkulu wutane re san nga welili ngel. Nuwrai tevi kami, renge melrin anglo ser nir nga marok-metmete nir arlesi tetajer no Tata suk nga m̃ilik re melrin. ");
INSERT INTO upv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Ko inu Jinibb Mawos nuvini tweni b̃ela se nir nga marjijki. ");
INSERT INTO upv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kami kamrrorrmi erpese? Poro nga jinibb san sipsip sen ongut (100), ko san rer evel sarrsarr ko esarr, ni sete orongwos p̃ilinglingi ngavöl esiw drromon esiw (99) ngok renge botwen parurroi mösmös ko pian pipej nga m̃isarr? Ni pian ko wor. ");
INSERT INTO upv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nuwretun nuwrai tevi kami, poro putor sweri, ko p̃ir pilep wor ren suri sipsip ngok, piasie nga ngavöl esiw drromon esiw nga sete marivel sarrsarr. ");
INSERT INTO upv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Erpok kele, sete evi marongen se Tata se kami nga m̃ilik re melrin nga san nga welili ngel pijijki. ");
INSERT INTO upv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Poro nga kalesia nga mivi tuwam e puloli p̃isij tevim, ko kupan ji ni, kamru koporsan bbong, ko kuptortorie suri. Ko poro purnge nik, ko ololi ni evi luwi tuwam. ");
INSERT INTO upv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ko poro sete purnge nik, ko kupla kele jinibb p̃isan rreknga p̃ieru, nga pirpe nale san nga Naul On muwrai: ‘Nale jijle nir, nir p̃ieru ko wor rreknga p̃itul parwilwil ren.’ ");
INSERT INTO upv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ko poro pumusus malum purnge nir, kupwerai tevi nir nga marivi kalesia. Ko poro pumusus malum purnge nir, ko kaploli ni vajin pirpe jinibb ne vare san, rreknga jinibb nga mok-lai takis san. ");
INSERT INTO upv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nuwretun nuwrai tevi kami, nanu jijle nga kapwer orer renge iel ngatan, Atua kele p̃iwer orer renge melrin; ko nanu jijle nga kapmaronge parlolir iel ngatan, Atua kele pimaronge parlolir renge melrin. ");
INSERT INTO upv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nuwretun kele nuwrai tevi kami, poro kami p̃ieru kobbong pormarong korti renge iel ngatan suri nanu p̃isan nga porungoni, ko Tata suk nga m̃ilik re melrin pia-loli wor nanu nen tevi nuru. ");
INSERT INTO upv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Poro jinibb p̃ieru rreknga p̃itul parkorti nga parlotoe inu, ko inu kele b̃elik livö nir.” ");
INSERT INTO upv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Vitunen ko Pita evini jin ko osusi tevi owra “Numal, pivavis nga tuwak puloli p̃isij tevik ko b̃etlasi ni? Pijpari pivabut?” ");
INSERT INTO upv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ko Iesu owra lweni tevi “Inu nuwrai tevi nik, sete pivabut te, ejki, ko pijpari ma pingavöl piebut pivabut (77) kis. ");
INSERT INTO upv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Suri renge batun vanu ne melrin, Atua pia-loli pirpe jinibb ngel le: Numal nga milep san owra pieve nivnon se jinibb sen nir. ");
INSERT INTO upv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ko daron nga m̃itipatun pieve, ko artekai san nga muloli nivnon mijpari nevöt elep nga elep. ");
INSERT INTO upv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ko suri sete orongwos puwli, ko numal sen ololi nale nga parwuli ni pivi demij maur, tevi nesen sen ko natun nir, ko parwuli kele joron jile nir, nga puloli parwuli tweni nivnon sen e sopon nga muloli. ");
INSERT INTO upv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ko jinibb ne majingen nen ejiol vitan ongoni eterter tevi, owra “Wurru, numal, kuplinglingi inu beblen, pian ko bea-wuli tweni jile kobbong nivnon suk nir.” ");
INSERT INTO upv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ko numal sen orrorrmi ni, ko owra lweni tevi ni, “Nivnon som osuw ko pa.” Ko elinglingi ni evel. ");
INSERT INTO upv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ko jinibb ne majingen nen evel. Ko daron nga mivini vare e, elesi selen nga mok-majing tevi ni san nga muloli pa nivnon jin, mijpari nevöt nga welili bbong. Ko ololarsi ko orrul totoni ni, ekinji b̃irislan ko owrai tevi: “Kupwuli nivnon som!” ");
INSERT INTO upv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ko selen nen ejiol vitan ko ongoni tevi ni, owra “Wurru, kuplinglingi inu beblen, pian ko bea-wuli twenir kobbong tevim.” ");
INSERT INTO upv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ko ni omusus p̃ilinglingi ni; otur imare, etkai ni ean elngi re naim ne nekaien, pijpari nga pia-wuli jile wor nivnon sen. ");
INSERT INTO upv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ko daron nga selen nir marlesi nanu nga muloli tevi, ko arunge esij elep e; ko aran arwerai nanu nga muloli tevi numal ser nga womu m̃iwer tweni m̃ernen nivnon sen jile. ");
INSERT INTO upv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ko daron nga numal ser murnge jile, ko ololar lenglengen; ko vitunen everus m̃ernen, ko owrai tevi: ‘Kuvi jinibb nga m̃isij p̃erp̃er! Nuwer tweni pa nivnon som ngok p̃etp̃eti nga sete kupwuli, suri nik kumngoni tevi inu. ");
INSERT INTO upv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ko suri sev nik sete kurongwos kuploli pirpok, kuprrorrmi selem pusorsan tevi nga inu morrorrmi nik?’ ");
INSERT INTO upv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Ko numal sen ololarsi lenglengen e, ko etkai ni van ji jinibb nga marok-telmaji nir re naim ne nekaien, p̃ilik iok pijpari nga pia-wuli jile nivnon sen.” ");
INSERT INTO upv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ko Iesu owrai kele, “Ko erpok Tata suk nga m̃ilik re melrin etlasi tweni pa nololien se kami nga marlelep nir. Ko poro nga kami nolo kami weretunen sete p̃itlasi tweni nanu nga tuwa kami muloli m̃isij tevi kami, nga mirpe nanu nga welili kobbong, ko Tata suk pia-loli tevi kami pusorsan tevi numal ngok muloli tevi jinibb sen ngok.” ");
INSERT INTO upv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Daron nga Iesu musuw re m̃irij vajin, ko evel lingi Galili, evini re Jutia re devje nuwi seser ne Jortan. ");
INSERT INTO upv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ko delung elep arvijuri ni, ko ni ololi nir nga marmesi arres luwi ie. ");
INSERT INTO upv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ko Parasi kele nir arini jin, arwera parrowrrowe ni. Ko arsusi, “Erpese? Evi nanu nga m̃irres nga jinibb p̃ilngi kurtweni nesevin sen suri nanu jijle?” ");
INSERT INTO upv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ko ni erij luwi, owrai tevir: “Rreknga kami sete kameve nga ni nga muloli nanu jijle womu, ololi norman ko nesevin, ");
INSERT INTO upv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ko owra ‘Ko ngok niko suri mirpel ngel ko, norman pivel lingi tata sen ko tasu sen, pian vajin piptevi nesevin sen. Nuru nga eru ngok porivi vajin niben sansan ko metka sansan.’ ");
INSERT INTO upv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ko ngok niko nuru setemun orivi eru, ko orivi vajin niben sansan ko metka sansan. Sev nga Atua m̃ijipteni kortoni nuru, sete erres jinibb san p̃ila tweni kele.” ");
INSERT INTO upv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ko nir arwera lweni tevi: “Poro pirpok ngok ko, suri sev Moses owra ‘Poro jinibb san p̃ilngi kurtweni nesevin sen, ko puli naul p̃ilai tevi, ko p̃ilngi tweni vajin’?” ");
INSERT INTO upv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ko ni owra lweni tevir, “Suri batu kami nga m̃iterter, niko Moses mimarong nga kaplingi kurtweni nesevin se kami nir. Ko renge womunen sete erpok. ");
INSERT INTO upv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ko nuwrai tevi kami, Poro nga jinibb san nesevin sen sete puloli womue batun, ko m̃ernen bbong p̃ilngi kurtweni nawone, ko p̃itka kele nesevin p̃isan kele, ni evitan re nesevin ngok ko vajin.” ");
INSERT INTO upv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ko jinibb sen nir arwerai tevi ni, “Poro pirpok tevi jinibb san ko nesevin sen, rrek erres sete portektekai nuru.” ");
INSERT INTO upv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ko ni owra lweni tevir, “Sete jinibb jijle orongwose puloli pirpe nga kamwerai ngok, nir nga bbong Atua m̃ilngi re nolor arongwose parloli pirpok. ");
INSERT INTO upv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jinibb sopor sete arongwose partekai nesevin suri arivi demaw, rreknga ariak erpok ko wor, rreknga jinibb ololi arirpok. Ko inu nomok-sup̃e suri nir nga marivi jinibb rres ko wor, ko sete arteka nesevin suri armajing suri batun vanu ne melrin. Si nga murongwos puloli pirpok, puloli pirpok ko wor.” ");
INSERT INTO upv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ko vitunen jinibb sopor artekai bipiwarreng ser vini ji ni nga ni p̃ilngi nevren rer ko pulot. Ko Iesu jinibb sen nir artortori lartul nen nir. ");
INSERT INTO upv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ko Iesu owrai tevir: “Sete kapwer orer. Kaplinglingi bipiwarreng nir parini jik, suri batun vanu ne melrin evi se nir nga marirpe bipiwarreng ngok nir.” ");
INSERT INTO upv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ko elngi nevren rer jile osuw, ko evel lingi ie. ");
INSERT INTO upv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mian ko vitunen vajin, ko jinibb san evini jin ko osusi tevi ni: “E, jinibb nevisvisenien, bololi majingen sev nga p̃irres pivtere nga bea-lai mauren nga tuwi ngok vini?” ");
INSERT INTO upv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ko Iesu owra lweni tevi: “Erpese kumsusi tevik suri nanu nga m̃irres? Jinibb san bbong erres, Atua. Ko poro kupwera kupla mauren ngok, kuptori nale nesesreien se Atua.” ");
INSERT INTO upv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ko m̃ernen osusi kele tevi Iesu: “Sev nale nesesreien ko kumwerai ngok?” Ko Iesu owra lweni tevi ni: “Nale nesesreien nen le ngel: ‘Sete kuprevji pini jinibb, sete kupvenae nesevin, sete kupevna, sete kupkerkeris re nosp̃en se numal nir, ");
INSERT INTO upv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kuposuri tata som ko tasu som, ko kupmerreni selem pirpe nik luwi.’” ");
INSERT INTO upv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ko m̃elakel nen owra lweni tevi Iesu: “Nomok-loli jile pa erpe nale nga kumwerair ngok nir. Sev ojpon kele wor nga bololi?” ");
INSERT INTO upv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ko Iesu owra lweni tevi ni, “Poro kupmerreni kupivi jinibb mawos jile p̃irres, kupan kupwulwule jorom jijle nir, ko kupla nevöt nen tevi b̃eres nir; ko jorom nga marres putoe mare re melrin. Ko kupini kupvijuri inu.” ");
INSERT INTO upv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Daron nga m̃elakel murnge nale se Iesu ngok e, ko ornge esij e elep, suri ni joron nir elep. Ko evel. ");
INSERT INTO upv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ko Iesu owrai tevi jinibb sen nir, “Nuwretun nuwrai tevi kami, Eterter elep renge jinibb nga joron milep pian re batun vanu ne melrin. ");
INSERT INTO upv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ko bowrai kele tevi kami: Eterter temijpal renge nato liwen pietiv. Ko nga jinibb san nga joron milep poro pian re batunvanu se Atua, eterter wor elep asi wore ngok.” ");
INSERT INTO upv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ko daron nga jinibb sen nir marunge nale ngel, ko bbösa elair e elep, ko arwera “Poro pirpok, ko si ma orongwos p̃ila mauren?” ");
INSERT INTO upv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ko Iesu emtenir ko owrai tevir: “Eterter re devjen nga jinibb puloli. Ko re devjen nga Atua, ni orongwos puloli nanu jijle.” ");
INSERT INTO upv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ko Pita erij weli, owra lweni tevi: “Kuplesi kem, namlinglingi joro kem jile arjipon, ko namini namvijuri nik. Naba-la sev p̃irres ren?” ");
INSERT INTO upv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ko Iesu owrai lweni tevi nir: “Nuwretun nuwrai tevi kami, renge daron nga Atua pia-loli nanu jijle parmerr p̃irres, ko inu Jinibb Mawos bea-sakel renge nai seksakel suk tevi nosrövien suk; ko kami nga kamok-vijuri inu, kami kele kapa-sakel re nai seksakel pisngavöl drromon p̃ieru, ko kapa-wera suri lat nga puto suri tevi metka ne Isrel nir esngavöl drromon eru. ");
INSERT INTO upv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Ko nir jile kele nga marivel lingi naim ser nir rreknga tuwar nir rreknga jojir nir rreknga tata ser rreknga tasu ser rreknga natur nir rreknga dan ser suri marongen suk, lartul nen nir para-la weli vajin renge iok pijpari pungut pivesan, ko para-lai kele mauren ne tuwi ngok vini. ");
INSERT INTO upv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ko nir elep nga marwowomu mian ko para-vivitu, ko nir elep nga marvivitu, mian ko para-wowomu.” ");
INSERT INTO upv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ko Iesu owrai kele tevir, “Renge batun vanu ne melrin, Atua pia-loli pusorsan tevi jinibb ngel le: Jinibb san naut nga milep sen san otoe. Ko nabong san emremra rorpong susu, owra p̃ilai jinibb ne majingen sopor nga parmajing renge orsel sen. ");
INSERT INTO upv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mian ko eskai jinibb sopor, osp̃e suri nowli nabong tevir, mian ko nir armarong renge nowli nabong nen; ko ni okoni nir vajin van re orsel sen. ");
INSERT INTO upv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ko re mete nial esiw sopon, ko ni otutur sopon kele; ko daron nga mututur e, ko elesi jinibb sopor kele artur nawon re maket. ");
INSERT INTO upv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ko owra tevir, ‘Kami kele kapan re orsel suk, ko nowlin sev nga pumomsawos bea-wuli kami ren.’ ");
INSERT INTO upv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ko nir aran. Ko re mete nial esngavöl drromon eru sopon, mian ko re kele mete nial itul sopon re nat mirivriv, otutur kele, ko ololi erpok kele. ");
INSERT INTO upv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ko mijpari re mete nial elim sopon rivriv, ko otutur kele; ko elesi jinibb sopor kele artur nawon, ko owrai tevir: ‘Erpese kamtur nawon iel mirpel nabong totoklai san?’ ");
INSERT INTO upv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ko nir arwera lweni tevi: ‘Suri sete jinibb san elngi majingen re kem.’ Ko ni owrai tevir: ‘Kami kele kapan re orsel suk.’ ");
INSERT INTO upv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ko rivriv jer ko vajin, numal nga naut sen nen owrai tevi m̃er nga mok-metmete joron nir, ‘E, kupverus kortoni jinibb ne majingen nir, ko kupwulir. Ko kuptipatun kupwuli re nir nga marvivitu, pian pusuwsuw re nir nga marwowomu.’ ");
INSERT INTO upv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ko nir nga martipatun majingen re mete nial elim sopon rivriv arini ko arlai nevöt ser, osorsan tevi nowli nabong san totoklai. ");
INSERT INTO upv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mian ko nir vajin nga marini wowomu re majingen arini, arrorrmi rreknga nir nowlir parasi wor van mare wor. Ko ejki, nir erpok kele bbong, arlai nevöt nga musorsan tevi nowli nabong san. ");
INSERT INTO upv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ko daron nga marlair e, ko nir arwor suri jinibb nga naut sen. ");
INSERT INTO upv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mian ko arwerai tevi: ‘E, erpese nir ngel arvivitu armajing bbong mete nial sansan, ko nik kuwlir osorsan tevi kem nga nammajing renge nabong totoklai, namrunge m̃isij renge nial nga milep?’ ");
INSERT INTO upv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ko ni owra lweni tevi nir san, owra ‘Selek, sete nuloli esij tevim, suri nik kumarong pa tevi inu renge nevöt ngok. ");
INSERT INTO upv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kupla nevöt som ko kupiel. Inu numrreni bowli nga mivitu ngel pusorsan tevi nik. ");
INSERT INTO upv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Rrek kulesi nga sete evi nanu nga m̃irres nga inu bololi sev nga memrreni re jorok? Ejki ma, erres ko wor. Rreknga nolom eleplep kobbong suri inu nolok erres.’” ");
INSERT INTO upv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ko Iesu owrai kele: “Pirpok ko, nir nga marvivitu mian ko para-wowomu, ko nir nga marwowomu, mian ko para-vivitu.” ");
INSERT INTO upv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ko vitunen Iesu owra pulwi kele van Jerusalem e. Ko jinibb sen nir esngavöl drromon eru arpitevi ni re sel. Marivel mian, ko Iesu etkai talev nir van re devje sel e, ko owrai tevir: ");
INSERT INTO upv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kaplesi, rraman Jerusalem le ngel. Ko daron nga rrapa-jipari, ko para-teka kerasi inu Jinibb Mawos van ji jinibb sulsulen nga marlelep nir, ko ji jinibb nevisvisenien ne nale nesesreien nir. Ko para-wera inu ban re mijen, ");
INSERT INTO upv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ko para-tekai inu van ji jinibb ne vare nir nga para-tetnije inu ko para-telmaji inu, ko para-rruloni inu para-wuse maure inu re nai pelaot. Ko mian ko re nabong itolin, Atua pia-loli inu bea-maur luwi kele re mijen.” ");
INSERT INTO upv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mian ko vitunen Sepeti nesen sen eptevi natun nuru Jemes ko Jon, nga morivi pa jinibb se Iesu, arini ji Iesu ko arjipa jin. Ko vinnen owra pungoni nanu san ji Iesu. ");
INSERT INTO upv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ko Iesu owra tevi: “Kumrreni sev?” Ko vinnen owra lweni tevi ni: “Numrreni kupwera nale san nga natuk norman ngel nuru porivi jinibb nga morlelep jer renge batun vanu som, tuwen p̃isakel re nevrem rres, ko tuwen re nevrem mair.” ");
INSERT INTO upv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ko Iesu owra lweni: “O, sete komor-rongwose nanu nga komor-ngoni ngok. Kamru komor-vitere kopor-minmin re biles ne norongen nga m̃isij nga inu beminmin ren?” Ko nuru orwerai lweni tevi ni: “O-o, komru nomor-vitere.” ");
INSERT INTO upv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ko ni owra tevi nuru, “Kopora-minmin ko re biles nga inu beminmin ren. Ko re kopora-sakel re nevrek rres rreknga re nevrek mair, sete evi nanu nga inu bea-lai. Evi nanu nga Tata suk ko pia-lai tevi nuru nga mutobbtobbu tweni nuru pae musuw nga pia-lai tevi nuru.” ");
INSERT INTO upv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ko daron nga nir esngavöl marunge, arlolarsi niaken nen e nuru, suri nuru orwera poran mare porasi nir. ");
INSERT INTO upv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ko Iesu orongwose norrorrmien ser, ko everus kortoni nir jijle vini jin ko owrai tevir: “Kami kamrongwose numal nir se jinibb ne vare nir aron tertere jinibb ser, ko jinibb nga marlelep ser nir arok-rrowrrowe derteren ser elep. ");
INSERT INTO upv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sete pirpok re livö ne kami. Isi nga mimrreni pivi jinibb nga milep re livö ne kami, ni puloli lweni ko wor ni pivi jinibb nga welili, nga pivi jinibb ne majingen se kami. ");
INSERT INTO upv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ko isi nga mimrreni puwowomu re kami, ni pivi demij maur se kami. ");
INSERT INTO upv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Osorsan tevi inu Jinibb Mawos, sete nuvini tweni nga jinibb parmajing se inu, ko nuvini tweni b̃emajing se nir, ko nga b̃elai mauren suk puto wani milnge delung nir re mijen, ko bowli lwenir.” ");
INSERT INTO upv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ko nir artutur mian, ko daron nga marivel lingi Jeriko, ko delung elep arvijuri ni. ");
INSERT INTO upv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ko renge devje sel, metrrorr eru orlilik ren. Ko daron nga morunge Iesu m̃iasi re sel, orkail orwera “Warru, Numal, metka se Devet, kuprrorrmi komru!” ");
INSERT INTO upv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ko delung nir artortori nuru, arwera “Kopor-p̃erp̃er!” Ko nuru orkail van mare lengleng kele, orwera kele: “Warru, Numal, metka se Devet, kuprrorrmi komru!” ");
INSERT INTO upv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ko Iesu otur murrong ko everus nuru ko owrai tevi nuru: “Komor-marong bololi sev tevi kamru?” ");
INSERT INTO upv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ko nuru orwera lweni tevi: “O, numal, nomor-marong mete komru porkulu luwi.” ");
INSERT INTO upv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ko Iesu orrorrmi lengleng nuru, ko ejpari mete nuru. Ko ngavilvil orkulkulu luwi erres vajin, ko orvijuri ni. ");
INSERT INTO upv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ko mian ko vitunen arini morie Jerusalem, ko arini re ngaim san nisen Betpas nga muto morie botwen san nga marveruse Botwen ne lolnai ne olip. Ko Iesu owrai tevi jinibb sen eru: ");
INSERT INTO upv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Koporan re ngaim nga muto ngokwan ngok. Ko pingavil kopora-lesi arile totkoni dongki san tevi natun. Kopor-rupaji dali nuru ko kopor-ile nuru vini jik. ");
INSERT INTO upv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ko poro san p̃irij tevi kamru suri, ko kopora-werai tevi, ‘Numal emrreni nuru.’ Ko pingavil ko p̃ilinglingi kamru kopor-ile nuru vini.” ");
INSERT INTO upv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ngok eplari osorsan tevi nale san se Atua nga propet sen san muli wowomue tuwi mirpel: ");
INSERT INTO upv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kapwerai tevi jinibb nir nga marlik re Saeon, ‘Kaplesi Numal se kami evini ji kami, evi jinibb malum, ko esakel re dongki nga welili kobbong, nga mivi natu dongki ne majingen.” ’ ");
INSERT INTO upv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ko nuru oran ko orloli osorsan erpe Iesu muwrai tevi nuru, ");
INSERT INTO upv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ko orile dongki nen tevi natun vini ji Iesu; ko arp̃elseni sunsun ser re nuru, ko Iesu esakel mare ren. ");
INSERT INTO upv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ko delung elep arla sunsun ser arp̃elsenir renge sel, ko nir sopor kele artitai rengsi nai tevi raor, arp̃elp̃elsenir renge sel. Ngok eviseni nga artori Iesu evi jinibb nga milep. ");
INSERT INTO upv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ko delung elep sopon, sopor nga marwowomu ko sopor nga marvivitu arkikail, arsurövi ni ko arwera “Osana van ji metka ngel se Devet! Numal Atua, nik kurij pa erres tevi ni nga mivini re nik nisem. Osana re melrin mare!” ");
INSERT INTO upv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ko daron nga mivini Jerusalem e, ko jinibb ne ie nir arore, arwera “Isi ko ngok?” ");
INSERT INTO upv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ko delung nir arwera lweni: “Ngel evi propet Iesu ne Nasret renge Galili.” ");
INSERT INTO upv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mian ko vitunen vajin ko Iesu evan re loloim ne Naim On. Ko oji tweni nir nga marok-wulwule nanu nir iok tetajer, ko nir nga marok-wulwuli nanu nen nir, ko evatpuse tep se nir nga marok-kelkele nevöt nir, ko evatpuse kele nai seksakel se nir nga marok-wulwule wum̃er nir. ");
INSERT INTO upv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ko owrai tevir: “Aruli pa tuwi nale se Atua san ngel, owra ‘Naim suk, parveruse naim ne verusen.’ Ko kami kamtur imare vajin ko kamloli evi ‘naim ne venao res.’” ");
INSERT INTO upv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mian ko jinibb nga meter marrorr nir ko naroj nir arini jin renge Naim On, ko ni ololi arres luwi. ");
INSERT INTO upv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko daron nga jinibb nga marlelep re sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir marlesi muloli majingen nga marinijnij nawone, ko nanwarreng nir markikail renge Naim On, nga marwera “Osana van ji metka se Devet!”, ko lartul nen arlolarsi lenglengen e Iesu suri. ");
INSERT INTO upv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ko arwerai tevi: “E, erpese? Nik kurnge nanu nga nanwarreng ngel nir marwerair ngok?” Ko Iesu owrai lweni tevir: “O-o. Ko kami sete kameve nabong san nale ngel se Atua nga muwra tuwi: ‘Eplari re jingo bipi nir ko bipiwarreng nga marsus malum nir, Atua ololi nir arsurövi ni erres p̃elak.’ Kami kameve ko pa osuw.” ");
INSERT INTO upv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ko elinglingir ko evel van re ngaim ne Betani ko omosi ie. ");
INSERT INTO upv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mian ko mevinen vajin renge rorpong susu, olwi van ngaim e re Jerusalem. Ko daron nga mututur mian, ko numer eaji. ");
INSERT INTO upv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ko elesi nai san nisen nai pik otur re devje sel, ko emawose evan ren, owra purro wenen. Ko elesi raon kiskis bbong, sete wenen otoe. Ko owrai tevi nai pik nen, “Setemun wenem puto kele e nabong san pijpari tuwi ngok vini.” Ko daron momsawos e nen ko pa, nai pik nen emli. ");
INSERT INTO upv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ko jinibb sen nir, daron nga marlesi e, ko artaole ko arwera “Erpese nai pik ngel mimli mivesane?” ");
INSERT INTO upv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ko Iesu erij welir, owrai tevir: “Nuwretun nuwrai tevi kami, poro nosurien se kami putoe, ko sete kaprrorrmi karkare le, ko ngok kami kele kaprongwose kaploli kobbong pirpe nga mololi ngel tevi nai pik ngel. Ko mare re iok, kapwerai kele tevi botwen ngel nga Atua p̃ila tweni ko puwirre van re dis, ko piplari pusorsan tevi. ");
INSERT INTO upv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ko nanu jijle, sev nga kapa-ngoni renge verusen, poro kapa-osuri, ko kapa-lair ko.” ");
INSERT INTO upv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ko Iesu olwi kele van re Naim On e, ko ok-visviseni jinibb nir. Ko jinibb nga marlelep nir ne sulsulen ko b̃irterawarreng nga marivi pa jinibb nga marlelep arini jin ko arsusi: “E, kula derteren ngok nir ngabe ko nga komok-loli nanu ngok e nir? Siko elai tevim?” ");
INSERT INTO upv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ko Iesu erij welir owrai tevir: “Inu kele bosusi kami e nanu p̃isan, ko poro kami kapwerai tevik, ko inu kele pirpok bowrai tevi kami nulai derteren ngel nir ngabe le nga mololi nanu ngel le nir. ");
INSERT INTO upv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kami kapwerai ta tevik: Jon ela derteren sen nga mok-paptaes e ngabe? Ji Atua, rreknga ji jinibb kobbong?” Ko nir arwerwerai tevir: “Poro rrapwerai, ‘Evel ji Atua vini,’ ko ni tia-werai lweni tevi kerr, ‘Erpese kami sete kamosuri ni?’ ");
INSERT INTO upv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ko poro rrapa-wera, ‘Evel ji jinibb kobbong vini,’ ko rrammetutue delung nir, suri nir jile artori pa Jon osuw evi propet.” ");
INSERT INTO upv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ko nir arwera lweni tevi Iesu, arwera “Sete namrongwose.” Ko Iesu owra lweni tevir, “Ia, ko inu kele sete nurongwose bowrai tweni tevi kami renge derteren sev nga mololi nanu ngel e nir.” ");
INSERT INTO upv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ko Iesu owrai kele, “Kaprrorrmi ta nanu ngel: Jinibb san natun otoe, natun eru. Ko evini ji m̃erwomu nen ko owrai tevi, ‘Natuk, lelingen kupan kupmajing re orsel suk.’ ");
INSERT INTO upv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ko natun owrai lweni tevi, ‘Numusus.’ Ko mian ko vitunen ko vajin, ko norrorrmien sen olwi, ko evan. ");
INSERT INTO upv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ko tata se nuru evini kele ji m̃ervitu nen, ko owrai kele erpe nga muwrai tevi m̃erwomu. Ko m̃ervitu nen owra lweni tevi: ‘Bean ko tata.’ Mian ko setemun evan.” ");
INSERT INTO upv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ko Iesu osusi suri re nuru nga eru ngok tevir, owra “Nuru si nen ko ololi marongen se tata sen?” Ko nir arwera lweni tevi: “Nga womu nen.” Ko Iesu owra lweni tevir: “Nuwretun nuwrai tevi kami, kami kamsorsan temijpal tevi m̃ervitu nen. Ko lartul nga marok-la nevöt ne takis nir ko nesevin ne sel nir nga kamungasir ngok arsorsan tevi m̃erwomu nen, ko nir parlai wani milnge kami van re batun vanu se Atua. ");
INSERT INTO upv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Suri Jon evini ji kami, evisviseni sel nga mumomsawos m̃irres, ko kami sete kamosuri ni. Ko nir ma, lartul nga marok-la nevöt ne takis nir ko nesevin ne sel nir, arosuri ni. Ko kami, daron nga kamlesi nir nga marosuri mirpok ngok, ko norrorrmien se kami sete olwi kele nga kami kele kaposuri ni. ");
INSERT INTO upv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Kaprunge ta nale rrongrrongvi m̃inij kele, ngel: Jinibb san orsel sen otoe. Ko orwi grep. Ololi nalut owlu rrale live laut. Ko eli bbulwil ko elngi besin san ren, ko san oto mare e nga parjingteni wene grep ren ko jinibb parok-bböt ren, suwen p̃iseser van re besin nga muto ngatan e. Muloli jile mirpok, ko eli naim san nga muwu mare nga jinibb nga marok-kulkulu parsa paran partur mare ren, ko parok-kulkulu pej nanu nga marok-vevna nir. Erpok, ololi jile osorsan tevi nga marok-loli daron nga maruwi nanu nen. Koelinglingi tevi jinibb sopor parmetmete, ko ni evel van re vanu m̃inij e. ");
INSERT INTO upv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Ko mian ko daron nga wenen mutomori pimirr, ni okoni jinibb sen sopor van ji nir nga marok-metmete orsel sen, nga nir parla wenen nen sopor, pusorsan tevi nga marijrij e. ");
INSERT INTO upv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ko jinibb nen nga marok-metmete orsel arrul totonir; ko nir san artelmaji, nir san arevji pini, ko nir san artuwe. ");
INSERT INTO upv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mian ko ni okoni kele jinibb sen sopor nir elep asi vajin nga womu, ko lartul nga arloli kele tevir osorsan tevi nga marloli tevi nir nga womu. ");
INSERT INTO upv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Mian ko vitunen jer vajin, okoni natun norman; orrorrmi nga nir parloli p̃irres le tevi ni natun. ");
INSERT INTO upv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ko jinibb nen nir, daron nga marlesi ni natun, arwerwerai tevir, ‘O, ngel evi natun nga pia-la joro tata sen. Rraprevji pini, ko puloli orsel pia-ivi vajin se kerr!’ ");
INSERT INTO upv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ko arrul totoni, ko arevei van vare re orsel, ko arevji pini.” ");
INSERT INTO upv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ko Iesu osusi tevi nir, owra “Ko daron nga jinibb nga orsel sen pivini, ko puloli sev tevi jinibb ngok nir?” ");
INSERT INTO upv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ko nir arwera lweni tevi ni, “Suri nir arivi jinibb nga marsij, ni kele puloli p̃isij pusorsan luwi tevir, pirevji pinir. Ko pia-linglingi orsel sen tevi jinibb sopor kele nga parok-metmete ko para-la wenen nen tevi re daron mawos nen.” ");
INSERT INTO upv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ko Iesu owrai tevir: “Sete kameve nabong san nale ngel ne Naul On? ‘Nabur nga lartul nga marok-ili naim marungasi marwirre, ni ko vajin evi nabur nga murrul totoni naim m̃iterter. Ngel evi majingen se Numal nga muloli, ko rramtaole rramlesi m̃irres p̃elak.’ Kameve ko pa osuw. ");
INSERT INTO upv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ngok, nuwrai tevi kami: Atua pia-la tweni batun vanu sen ji kami, ko pia-lai tevi jinibb sopor kele nga para-la wenen nga musorsan tevi. ");
INSERT INTO upv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Si nga pusnge nabur ngel, niben pimabbur. Ko si nga nabur ngel piravij ren, niben pumoloplop p̃etp̃eti.” ");
INSERT INTO upv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ko jinibb nga marlelep nir re sulsulen ko Parasi nir daron nga marunge nale rrongrrongvi sen ngok, arongwose nga ni owra suri nir. ");
INSERT INTO upv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ko arwera parrul totoni Iesu, ko armetutu delung nir. Suri delung nir artori ni evi propet san. ");
INSERT INTO upv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ko Iesu ela nale rrongrrongvi kele tevi nir, owra ");
INSERT INTO upv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Renge batun vanu ne melrin, Atua pia-loli pusorsan tevi numal ngel le: Numal san ololi dabbuen ne totkoien se natun norman. ");
INSERT INTO upv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ko okoni jinibb sen nir nga parveruse nir nga m̃ila pa nale tevir nga parini. Ko nir armusus parini. ");
INSERT INTO upv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ko okoni kele jinibb sen sopor kele, owra ‘Kapwerai tevi nir nga m̃ela nale tevir nga parini, “Kaplesi, nuloli lilane jile nanen, nutor pini pa buluk suk nir ko natu buluk suk nga marlelep marres nir, ko nanu jijle oto omomsawos pa nga parurroi. Kapini renge dabbuen ne totkoien.” ’ ");
INSERT INTO upv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ko nir arong melmelase bbong, ko arivel; san evan orsel sen, ko san evan emajing re sto sen. ");
INSERT INTO upv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ko nir sopon nga marlik jer nen arrul totoni jinibb nga mukonir nen, ko arloli esij tevir, ko arevji pinir. ");
INSERT INTO upv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ko numal nen, daron nga murnge nanu nga marloli ngok, ko ololar lenglengen. Ko okoni jinibb nuval sen nir aran ko arpir pinpini jinibb nen nir nga marok-revrevji pini jinibb, ko arsuli ngaim ser. ");
INSERT INTO upv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Muloli jile mirpok tevir musuw, ko owrai vajin tevi jinibb sen nir, ‘Nanen ne totkoien arloli jile osuw, artiriv ko vajin. Ko nir nga marwerai tevi nir nga parini, sete arres re parini. ");
INSERT INTO upv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kapiel ta vajin suri sel nir, ko jinibb si nir nga poro kapa-sewute re sel, kapa-werai tevir nga nir parini re nanen ne totkoien.’ ");
INSERT INTO upv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ko jinibb sen nir arloli erpok, arivel suri sel nir; ko daron nga marsewute jinibb tama san, poro pivi jinibb nga m̃isij rreknga jinibb nga m̃irres, ko arwerai tevi, ‘Kupan re nanen ne totkoien.’ Marok-loli mirpok mian, konaim ne nanen ne totkoien owun saute nir nga marini vajin. ");
INSERT INTO upv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ko daron nga numal nen ne nanen mivini loloim nen, owra p̃ilesi nir nga marini, ko otor sweri jinibb san loloim nga sete muri sunsun mawos ne totkoien. ");
INSERT INTO upv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ko numal nen owrai tevi m̃ernen, ‘Selek, erpese kumini loloim ko sete kumuri sunsun mawos ne totkoien?’ Ko ni omurrong jer. ");
INSERT INTO upv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ko numal nen elesi esij ko owrai tevi jinibb sen nir, ‘Kaprrul kokortoni nevren nuru ko b̃elan nuru, ko kapsere totkoni. Ko kapwos tweni van vare e, ko kapwosi van kapwirre van re lat nga mimalik jerjer. Iok ngok jinibb para-ting ko para-runge p̃isij pilep.’ ");
INSERT INTO upv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Nir elep nga Atua m̃iveruser nga parini jin, ko nir ewelili bbong m̃ilai twenir parivi sen.” ");
INSERT INTO upv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ni m̃irij jile mirpok musuw, ko Parasi nir arivel van lut san e ko arkorti, ko arsup̃sup̃e suri parloli pirpese nga Iesu puon luwi re nale sen. ");
INSERT INTO upv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Arsup̃e jile osuw, ko arkoni jinibb ser sopon tevi jinibb se Erot sopor aran arkerkerasi Iesu, arwera “Jinibb nevisvisenien, namrongwose nik kuwretun, kuvisviseni sel se Atua renge weretunen. Sete kuwor suri jinibb san, suri sete kumtutue jinibb san. ");
INSERT INTO upv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ngok, kupwerai ta tevi kem norrorrmien som. Evi nanu nga m̃irres rraplai nevöt ne takis tevi Sisa, batu numal se m̃eri Rom nir, rreknga ejki?” ");
INSERT INTO upv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ko Iesu orongwose nga arwera parkerkerasi ni, ko owra tevir: “Suri sev kamrrowrrowe inu, kami nga kamiel re sel eru? ");
INSERT INTO upv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kapviseni ta inu nevöt nen.” Ko nir arlai nevöt nen san tevi. ");
INSERT INTO upv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ko ni elai, emteni, ko osusi tevir, “Isi le nisen ko non maruli rengen ngel?” ");
INSERT INTO upv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ko nir arwera lweni tevi, “Rrekma Sisa ko.” Ko ni owrai tevir, “Kaplai tevi numal se m̃eri Rom sev nga marivi se ni, ko kaplai tevi Atua sev nga marivi se Atua.” ");
INSERT INTO upv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ko daron nga marunge nale ngel e nir, bbösa elair e, suri arrorrmi Iesu sete orongwose p̃iasie nir renge nanu ngok. Ko arlinglingi ni ko arivel sisamis. ");
INSERT INTO upv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ko vitunen, re nabong mawos nen malum, ko Satusi nir sopor arini jin kele. Nir arok-wera jinibb sete orongwos pimaur luwi kele renge mijen. Ko arsusi kerkerasi tevi, arwera ");
INSERT INTO upv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Jinibb nevisvisenien, Moses owrai tuwi, ‘Poro jinibb p̃isan pimij ko natun pijkie, ko tasin p̃itkai nesevin sen ko pivesi wani metka se tuwan nga mimij ngok.’ ");
INSERT INTO upv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ko renge kem bonevis jinibb ebut arivi niaken erpok. Ko m̃erwomu nen etka nesevin sen; mian ko orongwose otomori pimij, ko owrai tevi tasin, ‘Natuk ejkie, kuptekai nesevin suk.’ Ko m̃erwomu emij. ");
INSERT INTO upv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ko m̃ervitu kele ololi erpok kele, etka kele nesevin nga, mian ko emij. Mian ko ejpari ebutun nga vitu jer nen, nir jijle artekai nesevin nga, mian ko nir jijle armij lingi vin nga. ");
INSERT INTO upv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mian ko vitu jer nen vajin, ko nesevin emij vajin. ");
INSERT INTO upv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ko namwera nabsusi tevim: Renge daron nga jinibb nir parmaur luwi kele re mijen, siko re nir niaken nga ebut ngok pia-ivi nesen sen e vinnen? Kupwerai ta we!” ");
INSERT INTO upv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ko Iesu erij welir owrai tevir: “Kamsarr, suri sete kamrongwose Nale On se Atua, ko sete kamrongwose derteren se Atua. ");
INSERT INTO upv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Suri renge meraien ne mijen, sete arongwose para-totko kele mun, ko para-irpe vajin anglo ko re melrin. ");
INSERT INTO upv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ko nga kami kapjipari meraien ne mijen evi weretunen, ko b̃elai nale san se Atua nga kamrongwose pae nga muwrai tevi kami ngel, muwra ");
INSERT INTO upv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Inu nuvi Atua se Epram, ko Atua se Aesak, ko Atua se Jekop.’ Atua sete evi Atua se jinibb nga marmij nir, ko evi pa se jinibb nga marmaur nir. Suri derteren sen elep nga elep lingi mijen.” ");
INSERT INTO upv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ko daron nga delung nir marunge nale ngel, ko bbösa nga milep elair renge nevisvisenien nga m̃irres sen. ");
INSERT INTO upv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ko Parasi nir, daron nga marunge Iesu muloli Satusi nir marmurrong jer mirpok, ko nir arververus kortonir arkorti lat san. ");
INSERT INTO upv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mian ko san re nir nga norongwosien sen mutoe re nale nesesreien se Atua osusi rongornge tevi ni, owra purrowrrowe ni, owra ");
INSERT INTO upv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Jinibb nevisvisenien, renge nale nesesreien, kulesi nale ngabes nen ko elep womunen?” ");
INSERT INTO upv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu owra lweni tevi: “‘Kupmerreni Numal Atua som tevi nolom totoklai, tevi mauren som totoklai, ko tevi norrorrmien som totoklai.’ ");
INSERT INTO upv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ngok evi nale nesesreien nga milep womu jer nen. ");
INSERT INTO upv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ko nga suri nen e, mutomori pirpe ngok, ni le ngel: ‘Kupmerreni selem pirpe nik luwi.’ ");
INSERT INTO upv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ngok ko nuru orivi batu nale nesesreien nir, ko nale se propet nir kele.” ");
INSERT INTO upv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parasi nen nir arlik korti malum, ko Iesu osusi tevir, ");
INSERT INTO upv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","owra “Kamrrorrmi Mesaea erpese? Isi ko metka sen?” Nir arwera lweni tevi, arwera “Se Numal Devet.” ");
INSERT INTO upv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ko ni owra lweni tevir, “Poro pirpok, ko Mesaea piveruse Devet puwra ‘Numal,’ suri Devet owowomu. Ko ejki, Nem̃in On ololi Devet miveruse Mesaea muwra Numal, nga muwra ");
INSERT INTO upv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Numal Atua owra tevi Numal suk, “Kuplik renge nevrek rres pijpari nga bea-lingi devje nuval som nir parirpe lat nga kupbböt ren renge nolon b̃elam ngatan.’” ");
INSERT INTO upv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Poro nga pirpok Numal Devet miveruse Mesaea mivi Numal sen, ko evi metka sen erpese?” ");
INSERT INTO upv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ko daron nga m̃irij jile mirpok, ko sete jinibb kele san orongwos p̃irij weli nale san tevi ni. Ko m̃itipatun re daron nen jinibb jijle armetutu, setemun san orongwos pususi rongornge nanu san tevi ni. ");
INSERT INTO upv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mian ko Iesu erij tevi delung nir ko jinibb sen nir, owra ");
INSERT INTO upv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Jinibb nevisvisenien ne nale nesesreien nir ko Parasi nir arla wani milnge Moses, arivi pa jinibb nga parvisviseni jinibb nir re nale nesesreien nga Moses muli tuwi. ");
INSERT INTO upv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Suri iok ko, nanu jijle nga marwerai tevi kami, kaploli tevir pirpe nga marwerai kobbong. Ko re devjen nga nanu nga marlolir, sete kaploli surir e pirpok. Suri nir arok-werai, ko sete arok-majing suri. ");
INSERT INTO upv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Arsere bböbbti nga marrow milep ko eterter nga jinibb nir parsoloir, ko arjingtenir re birpari jinibb nir; ko nir mawos ma armusus parsa tweni bbös nevrer e san. ");
INSERT INTO upv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ko renge majingen ser arlolir armerreni jinibb parlesir. Kamrongwose narr nga wewarreng nir nga marsongni naul nga maruli tweni nale se Atua rer, nga jinibb nir parruloni re borngir ko nevrer. Ko nir arloli se nir arlelep nga jinibb parlesir ko parsurövir renger. Ko suri norrorrmien ngok kobbong, muloli marloli kele sunsun ser marpepriv. ");
INSERT INTO upv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ko renge nanen kele, arok-merreni parsakel re lat nga jinibb nga marlelep nir marok-sakel rer; ko arloli erpok kele re naim ne gortien nir. ");
INSERT INTO upv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ko armerreni jinibb partorir re maket, ko jinibb nir parveruse nir, ‘Jinibb nevisvisenien.’ ");
INSERT INTO upv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ko kami, sete kaplolir parveruse kami san ‘Jinibb nevisvisenien,’ suri jinibb sansan bbong evi jinibb nevisvisenien se kami, ko kami jijle kamivi niaken. ");
INSERT INTO upv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ko sete kapveruse jinibb san pivi tata se kami renge iel ngatan, suri jinibb sansan bbong evi tata se kami, ni nga m̃ilik re melrin. ");
INSERT INTO upv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ko sete kaplolir parveruse kami ‘Numal,’ suri Numal se kami sansan bbong, Mesaea. ");
INSERT INTO upv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ko ni nga mivi jinibb nga milep temijpal re livö renge kami, pivi wor jinibb ne majingen se kami kele. ");
INSERT INTO upv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ko si nga musustur lweni ni mian mare, Atua pia-loli ni pian ngatan. Ko si nga puloli lweni ni pian ngatan, Atua pia-sustur ni pian mare. ");
INSERT INTO upv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Wi, kami jinibb nevisvisenien ne nale nesesreien, ko kami Parasi, kami nga kamiel re sel eru! Suri kamkikiorore batun vanu ne melrin tevi jinibb nir. Ko kami kele sete kaman, ko sete kamlinglingi kele nir nga marmerreni paran. ");
INSERT INTO upv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Wi, kami jinibb nevisvisenien ne nale nesesreien, ko kami Parasi, kami nga kamiel re sel eru! Kami nga nolo kami mok-venae pa naim se nesevin nir nga diwen ser marmij lingir, ko kamkerkeris re kamloli nawon verusen nga marpepriv. Suri nanu ngok, puloli Atua putor vitrangi kami pilep. ");
INSERT INTO upv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Wi, kami jinibb nevisvisenien ne nale nesesreien, ko kami Parasi, kami nga kamiel re sel eru! Kamp̃elak kamwolu otvi dis ko kamiel suri vanu nga kaplai jinibb p̃isansan pivini piptevi kami. Ko daron nga miptevi kami mirpok, kamloli ni evi pa jinibb nga pian re lat ne norongen nga m̃isij, evi jinibb nga m̃isij varu re kami. ");
INSERT INTO upv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Wi, kami metrrorr nga kamok-wowomue jinibb re sel. Kamok-wera ‘Isi nga p̃irijrij renge Naim On, ololi nanu nawon. Ko isi nga p̃irijrij renge gol ne Naim On, ngok ni puloli nanu nen ko wor.’ ");
INSERT INTO upv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kamlengleng, kamivi metrrorr. Ngabes nen evi nanu nga milep nen, gol nen, rreknga Naim On? Suri Naim On kobbong ololi gol nga muto ren on. ");
INSERT INTO upv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ko kamok-wera kele, ‘Isi nga p̃irijrij renge nawot nga marok-sulsul ren re Naim On, ololi nanu nawon. Ko isi nga p̃irijrij renge merrenien nga muto ren, ngok ni puloli nanu nen ko wor.’ ");
INSERT INTO upv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kamivi metrrorr! Ngabes nen evi nanu nga milep nen, merrenien nen, rreknga nawot? Suri nawot kobbong ololi merrenien on. ");
INSERT INTO upv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Suri isi nga p̃irijrij re nawot, erpe erijrij ren ko nanu jijle nga pa marto ko ren kele. ");
INSERT INTO upv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ko isi nga p̃irijrij re Naim On, erpe erijrij ren, ko erijrij kele renge Atua nga pa m̃ilik ko ren kele. ");
INSERT INTO upv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ko isi nga p̃irijrij re melrin, erpe erijrij renge nai seksakel se Atua, ko erijrij kele renge Atua nga m̃isakel ren kele. ");
INSERT INTO upv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Wi, kami jinibb nevisvisenien ne nale nesesreien ko kami Parasi, kami nga kamiel re sel eru! Ko kamok-eveve roi wowarreng nir nga marok-lingi re nanen, min ko til ko kamin, nga kaploli pusorsan p̃etp̃eti tevi nale nesesreien se Atua, ko kaplai songovlön pian ji Atua. Ko kamlinglingi nanu nga marlelep re nale nesesreien, erpe nesesreien mawos, murrun nga marrorrmi jinibb, ko murrun nga marosuri weretunene. Ngok, nanu nga marlelep e nir, kaplolir ko wor, ko sete kaplinglingi nanu nga wowarreng, pirpe murrun nga parlai songovlön pian ji Atua, parjipon. ");
INSERT INTO upv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kamivi metrrorr nga kamok-wowomue jinibb re sel. Daron nga kamwera kapmini nuwi, ko kamlesi nunu m̃isal ren, ko kamjuljule tweni, musuw ko kammini nuwi nen vajin. Ko poro kaplesi buluk san m̃isal re nuwi se kami, ko sete kamjule tweni, kammini kobbong, ko kamrrolmi nuwi tevi buluk nen! ");
INSERT INTO upv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Wi, kami jinibb nevisvisenien ne nale nesesreien, ko kami Parasi, kami nga kamiel re sel eru! Kamok-rrawe vare ne biles nir ko plet nir arwokwok, ko renge nolor arrokitkit temijpal. Erpe kami, nolo kami arwun saute venao. Ko kamwera malum kapevna, nolo kami sete orongwos pusuw ren. ");
INSERT INTO upv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kami Parasi, kamivi metrrorr! Womuj nen, kaprrawe vaseni nolo biles ko plet puwomu, ko vare nen kele puwokwok p̃irres vajin. ");
INSERT INTO upv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Wi, kami jinibb nevisvisenien ne nale nesesreien ko kami Parasi, kami nga kamiel re sel eru! Kamirpe dubb nga marbbölji laen er, vare ner marow m̃irres, ko lolor marwun saute ji jinibb nga marmij nir, ko nanu jijle nga marrokitkit nir. ");
INSERT INTO upv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Erpok kele re kami, jinibb arlesi re vare ne nibe kami armomsawos erres; ko renge nolo kami arwun saute gerisen nir ko nololien nga marsij nir. ");
INSERT INTO upv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Wi, kami jinibb nevisvisenien ne nale nesesreien ko kami Parasi, kami nga kamiel re sel eru! Kamok-tuwe nevöt re dubb se propet nir ne tuwi pa ko kamok-juroi dubb se jinibb nga marres nir ne tuwi ");
INSERT INTO upv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ko kamok-wera ‘Poro nga nablik re nabong nga tuwi nir se b̃irterawarreng se kem nir, sete nama-pitevi nir nga marevji propet nir drra mibböljir.’ ");
INSERT INTO upv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ko ngok, kamwer lokloksi kami lweni kobbong, suri kamwera kamivi metka mawos se nir nga marevji propet nir. ");
INSERT INTO upv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Iow, erres kobbong, majingen nga marsij se b̃irterwarreng se kami nga marmajing linglingir, kami vajin kapmajing jijler. ");
INSERT INTO upv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","O, kamivi num̃et! Kamivi metka se num̃et nir nga marsij ko marok-wolu. Kapwolu asi re lat ne norongen nga m̃isij pirpese? ");
INSERT INTO upv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Erpok ko, kaplesi, bokoni propet sopor ko jinibb sopor nga norongwosien ser mutoe, ko jinibb nevisvisenien ne nale nesesreien sopor vinuk ji kami. Ko nir sopor kapa-revji pinir, ko nir sopor kapa-rrulonir kapa-wuse maur nir re nai pelaot, para-rrul pijpari para-mij. Ko nir sopor kapa-telmajir re naim gortien se kami, ko kapa-ojir re ngaim ko ngaim. ");
INSERT INTO upv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngok puloli drra jinibb jijle nga marres nga marevjir iel ngatan parbbölji kami, etipatun re drra jinibb nga m̃irres nen Epel, ejpari drra Sekaria natu Barakaea nga b̃irterawarreng se kami marevji pini re Naim On mawos, liven ne lat nga muon ko nawot. ");
INSERT INTO upv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nuwretun nuwrai tevi kami, drra jijle ngel nir para-bbölji kami nga lelingen ngel nir. ");
INSERT INTO upv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem, nik nga komok-revji pini propet nir, ko komok-tuwe pini jinibb nir nga Atua mukonir vini jim. Vavis nga mowra b̃eser kortoni natum nir parkorti pirpe nato dosevin nga m̃isrew ore natun nir; ko ejki, kammusus. ");
INSERT INTO upv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaplesi, Atua evel lingi pa kami ko Naim On se kami. ");
INSERT INTO upv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ko nuwrai tevi kami, setete kama-lesik kele sopon pijpari nga kapa-wera: ‘Atua erij pa erres suri ni nga mivini re ni nisen.’” ");
INSERT INTO upv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ko Iesu eivare, owra pivel lingi Naim On. Ko jinibb sen nir arini jin, arwera parviseni tevi ni majingen nga marres milep ne Naim On. ");
INSERT INTO upv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ko Iesu erij welir, owra “Kamlesi nanu ngok nir? Nuwretun nuwrai tevi kami, pian ko sete nevöt ngok nir san pia-jek jer re p̃isan, para-wirr sisamis p̃etp̃eti.” ");
INSERT INTO upv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mian ko vitunen vajin, Iesu ok-lik ngatan re Botwen ne lolnai ne olip, ko jinibb sen nir arini malum bbong jin, ko arsusi tevi: “Kupwerai ta tevi kem, nanu ngok nir para-rremali seveling? Ko sev piviseni daron nga kupa-luwi e vini ko ngatan ngel bongsin nga pia-suwsuw e?” ");
INSERT INTO upv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ko Iesu owra lweni tevir, “Kapmetmete jinibb san tia-kerkerasi kami. ");
INSERT INTO upv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Suri nir pilep ko para-vini renge inu nisek, ko para-wera ‘Inu le Mesaea,’ ko para-kerkerasi jinibb pilep para-vijurir. ");
INSERT INTO upv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ko kapa-runge naror ne nuval nir ko nosp̃en ne nuval nir. Kapmetmet, takmetutue. Nanu ngok jile nir para-pelari ko wor, ko ngatan ngel bongsin ejki wor. ");
INSERT INTO upv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ko jinibb nir para-tur imare para-val tevi jinibb nir, ko batun vanu nir para-tur imare para-val tevi batun vanu nir, ko numer pia-to, ko nam̃i pia-m̃i re lat lele. ");
INSERT INTO upv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nanu ngel nir arivi nanu womunen re martipatun, erpe nesevin san nga murnge rrongvi depain.");
INSERT INTO upv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Renge daron nen, ko para-tekai kami van ji jinibb nga para-loli p̃isij tevi kami, ko para-revji pini kami. Ko jinibb jijle para-ungasi kami suri kamivi jinibb suk. ");
INSERT INTO upv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ko renge daron nen nir pilep nolor pia-vitan, ko para-tektekai kerasi lululwenir, ko para-ungungasi lululwenir. ");
INSERT INTO upv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ko propet ne gerisen nir pia-lep para-tur imare ko para-kerkerasi jinibb pilep, para-vijurir. ");
INSERT INTO upv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ko suri nololien se jinibb nir pia-wun saut, pia-loli merrenien se kalesia nir pilep pia-melmelas. ");
INSERT INTO upv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ko si nga pia-tur p̃iterter pijpari bongsin, m̃ernen pia-la mauren nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ko nosp̃en nga m̃irres suri batun vanu ne melrin para-sup̃e tevi jinibb jijle nir puwomu renge iel ngatan, nga jinibb ne vare nir para-runge; pia-suw vajin, ko bongsin pia-vini ko vajin. ");
INSERT INTO upv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ko nabong san kapa-lesi atua se jinibb ne vare nir nga m̃isij nga m̃isij, nga propet Daniel musp̃e tuwi pa, para-sireni putur renge lat nga muon, ko pia-loli nir para-wolu lingi lat on nen.” (Si nga mok-eve purongwose.) ");
INSERT INTO upv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Korenge daron nen, kami nga kamlik Jutia kapwolu van re botwen e nir. ");
INSERT INTO upv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ko kami nga kamlik vare renge naim se kami, sete kapluwi kele van loloim se kami kapla joro kami p̃isan, ejki, kapa-wolu lingir pingavil. ");
INSERT INTO upv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ko kami nga kammajing re orsel se kami, sete kapa-luwi kele van re ngaim se kami kapa-la sunsun se kami, ejki. ");
INSERT INTO upv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wi renge nesevin nir nga marsolo malum bipi, ko renge nesevin nir nga marloli bipi ser marsus renge nabong nga marsij nen nir. ");
INSERT INTO upv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kapungoni ko wor tevi Atua nga woluen se kami sete pia-vini re daron ne naus, rreknga re nabong ne Sapat. ");
INSERT INTO upv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Suri daron nen pia-ivi daron nga m̃iterter m̃isij temijpal san. M̃itipatun re daron nga Atua muloli iel ngatan e, mivini mijpari lelingen ngel, nanu san setewor eplari erpok, ejki wor; ko vitunen, sete pia-irpok kele pia-vesan. ");
INSERT INTO upv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Numal Atua orrorrmi pa nga pia-ta tweni nabong nga marsij ngel nir; poro pijki, ko sete jinibb san mia-maur. Ko suri orrorrmi nir nga ni mutobbtobbu pae nir, ko niko muloli nabong nen nir sete pilep p̃elak. ");
INSERT INTO upv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ko renge daron nen, poro jinibb san pia-werai tevi kami, ‘Kaplesi, Mesaea ngokwan,’ rreknga ‘Ngelan,’ sete kapa-osuri. ");
INSERT INTO upv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pian, ko pia-irpok ko wor renge iel ngatan; mesaea ne gerisen nir pilep para-tur imare, ko propet ne gerisen nir pilep para-tur imare, ko para-viseni nevisenien ko nelesien nga marlelep nir, nga para-kerkerasi jinibb nir, ko jinibb se Atua kele nir. Ko sete arvitere para-kerkerasi jinibb se Atua nga mutobbtobbu nir. ");
INSERT INTO upv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kaplesi, nuwrai wowomu pae kami le ngel. ");
INSERT INTO upv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Erpok, poro para-werai tevi kami, ‘Kaplesi, Mesaea nika lolo merwer!’ kami sete kapan. Ko poro para-werai tevi kami, ‘Kaplesi nika, elik teptepi loloim sopon re naim ngok san,’ ko sete kapa-osuri. ");
INSERT INTO upv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Erpe navil nga mivil, daron nga mivil renge devje melrin ko mimor vaseni melrin p̃etp̃eti mivesane mijpari devjen, nga jinibb jijle nir marlesi, ko ngok pia-irpok renge inu Jinibb Mawos renge daron nga bea-luwi vini. ");
INSERT INTO upv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pirpe daron nga nanu san emij, ko numön nir nga marok-tasi parmot rrale; orongwos kaplesi wose kobbong ngasu. ");
INSERT INTO upv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ko vitunen vajin re daron nga m̃isij nen, ngavilvil nial pia-mot, ko navöl sete mia-ser, ko moju ne melrin nir para-vitvitan, ko nanu nga marterter ne melrin nir para-terrterring. ");
INSERT INTO upv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mian ko vitunen nelesien se inu Jinibb Mawos pia-pelari re melrin. Ngok pia-loli metka se jinibb ne iel ngatan nir para-ting nga para-lesi inu Jinibb Mawos bea-vini re nabor ne melrin nir tevi derteren ko nosrövien nga milep. ");
INSERT INTO upv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ko vitunen, daron nga para-uwi davö nga milep san, ko inu bea-koni anglo suk nir para-van re iel ngatan bongsin ivij jijle, tevi lat p̃etp̃eti nir nga melrin m̃isalsal orer, ko para-ser kortoni jinibb suk nir nga motobbtobbue. ");
INSERT INTO upv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kaprrorrmi renge nale rrongrrongvi ne nai pik, ngel: Daron nga rengsin mimalum vajin, ko etengriv luwi kele nga puloli raon nir parpelari. Ngok, kamrongwos pae daron ne dorvusavus oruj mori. ");
INSERT INTO upv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kami pirpok ko, daron nga kapa-lesi nanu ngok nir, kapa-rongwose nga inu nuruj mori p̃elak, erpe nutur ko vajin roro metali. ");
INSERT INTO upv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nuwretun nuwrai tevi kami, dul nga lelingen ngel sete pia-asi wor pijpari nga nanu ngel nir para-pelari. ");
INSERT INTO upv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Melrin ko ngatan, mian ko pora-asi; ko nale suk nir setete mara-asi, ejki, para-pelari ko wor. ");
INSERT INTO upv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ko nabong nen, ko mete nial nen, sete jinibb san rragrrag orongwose, ejki; sete anglo ne melrin san kele orongwose, ejki; ko inu kele Atua Natun, inu sete nurongwose; ko Tata suk kobbong, ni esan orongwose. ");
INSERT INTO upv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Inu Jinibb Mawos bea-vini pia-sorsan pia-irpe Noa nabong sen tuwi nga naus nga milep mus ko iel ngatan murron ko nanu jijle nir marmij. Suri re daron nen, jinibb nir arlelea nawon. Pia-sorsan kele ko pia-irpok tevi inu daron suk nga bea-luwi e. ");
INSERT INTO upv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Suri nabong nga wowomu nen nir, mian ko vitunen naus pia-us, jinibb nir aran ko arminmin ko arloli totkoiennir, ejpari nabong nga Noa mian re lolo drrav nga milep e. ");
INSERT INTO upv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ko sete arongwose naus nga pilep nga pivini, ejpari nga mian ko mivini m̃isale twenir. Pia-sorsan kele ko pia-irpok tevi inu daron suk nga bea-luwi e. ");
INSERT INTO upv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Renge daron nen, jinibb p̃ieru portur re orsel; ko parla luwe nuru tuwen, ko tuwen putur jer. ");
INSERT INTO upv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ko nesevin p̃ieru porlik korti portabbu nurrer; ko parla luwe nuru tuwen, ko tuwen p̃ilik jer. ");
INSERT INTO upv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Erpok ko, kapkulkulu. Suri kami sete kamrongwose nabong sev nga inu Numal se kami bea-luwi ren. ");
INSERT INTO upv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kaprongwose nanu ngel: Poro jinibb san purongwose daron sev re nutpong nga jinibb venao pivini p̃irrarre naim sen, ko ni puklu pimetmet ko putur ore nga jinibb nen sete p̃irrarre naim sen. ");
INSERT INTO upv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pirpok ko kami kele kapmetmet nga kaptiriv ko wor, suri inu Jinibb Mawos dea-pelari re mete nial nga sete taka-rongwose. ");
INSERT INTO upv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Jinibb si nga erpe jinibb ne majingen nga muosuri m̃irres, ko batun otoe? Numal sen ololi ni emetmete jinibb ne majingen sen nir, ko puwngani nir renge daron momsawos. ");
INSERT INTO upv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jinibb ne majingen nga m̃irres nen pia-runge p̃irres daron nga numal sen pia-vini ko pia-lesi ni m̃imajing m̃irres mirpok. ");
INSERT INTO upv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nuwretun nuwrai tevi kami, numal nen pia-loli m̃ernen pia-metmete joron totoklai nir. ");
INSERT INTO upv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko poro nga m̃ernen pivi jinibb nga m̃isij, ko puwrai re nolon, ‘O, numal suk ololola nga pulwi vini. Poro nga bololi nanu san, ni sete orongwos purongwose,’ ");
INSERT INTO upv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ko etipatun vajin pivrrali selen nir nga marmajing tevi nga numal sen m̃ilngi ni mivi jinibb nga milep rer, ko eaan ko eminmin tevi jinibb nga marok-minmin nir. ");
INSERT INTO upv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ko numal se m̃ernen pia-luwi vini re nabong nga m̃ernen sete murrorrmi, ko renge mete nial san nga sete murongwose. ");
INSERT INTO upv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ko numal nen pia-oji tweni m̃ernen pia-suw, ko pia-tor vitrangi ni pusorsan tevi lartul nga marivel re sel eru, re lat nga jinibb para-ting ko para-runge p̃isij pilep.” ");
INSERT INTO upv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ko Iesu ela nale rrongrrongvi m̃inij kele, owra “Re daron nen, batun vanu ne melrin pia-pelari pusorsan tevi nanu ngel nga miplari ji nesenwarreng m̃elakel esngavöl ngel: Nesevin m̃elakel esngavöl arsa laet ser, ko aran arwera parivel ore jinibb san nga muwra putotko re nabong nen. ");
INSERT INTO upv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nir elim norrorrmien ser ejkie, ko nir elim norrorrmien ser otoe. ");
INSERT INTO upv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Suri nir nga norrorrmien ser mijkie arsa laet ser, ko sete artori karsin; ");
INSERT INTO upv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ko nir nga norrorrmien ser mutoe, artori botel karsin ser oto tevi laet ser. ");
INSERT INTO upv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ko jinibb nen nga muwra putotko nen ololola malum. Mian, ko nesenwarreng nen nir meter arrurruwel, ko armatur. ");
INSERT INTO upv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ko muruj mori nat nga m̃irrang sopon, ko san ekail owra ‘Kaplesi, jinibb nga putotko evini. Kapiel ore!’ ");
INSERT INTO upv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ko nesenwarreng nen nir armera, ko arrowrrowe laet ser. ");
INSERT INTO upv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ko nir nga norrorrmien ser mijkie arwera tevi nir nga norrorrmien ser mutoe, ‘E, kapla karsin se kami sopon tevi kem, suri laet se kem artep.’ ");
INSERT INTO upv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ko nir nga norrorrmien ser mutoe arwera lweni tevir, ‘O, ejki rres, sete tivtere kem ko kami. Erres p̃elak kapluwi van re sto ko kapwuli wor nga pivi se kami.’ ");
INSERT INTO upv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ko daron nga marluwi van parwuli e, ko jinibb nga putotko evini. Ko nir nga martirive aran arpitevi ni aran re totkoien, ko mian ko arkikiore metali nen. ");
INSERT INTO upv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mian ko vitunen vajin, nir nga norrorrmien ser mijkie nen arini arwera ‘Numal, numal, kuptasi metali tevi kem!’ ");
INSERT INTO upv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ko ni owra lweni tevir, ‘Nuwretun nuwrai tevi kami, Sete nurongwose kami.’” ");
INSERT INTO upv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ko Iesu owra kele: “Erpok, kapkulkulu, suri sete kamrongwose nabong nen rreknga mete nial nen nga inu bea-luwi vini ren. ");
INSERT INTO upv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Suri renge batun vanu ne melrin, Atua pia-loli pusorsan tevi numal ngelle: Jinibb san owra pivel van re vanu nga ngasu san. Ko everus jinibb ne majingen sen nir, ko elngir parmetmete joron nir. ");
INSERT INTO upv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ko ela tevi nir san bebje silva nevöt nuvasngavöl valim (5000), ko tevi nir san kele ela nuvasngavöl varu (2000), ko tevi nir san kele, nuvasngavöl vesan (1000). Ngok, elai tevir osorsan tevi norongwosien ser sisamis. Elai jile tevir, ko evel. ");
INSERT INTO upv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ko ni nga m̃ila nuvasngavöl valim nen esaro van ngavilvil ko emajing ren, ko ololi kele ejpari nuvasngavöl valim kele. ");
INSERT INTO upv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ko ni nga m̃ila nuvasngavöl varu nen ololi osorsan erpok kele, ko ni ololi kele ejpari nuvasngavöl varu kele. ");
INSERT INTO upv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ko ni nga m̃ila nuvasngavöl vesan evan ko eli dan ko etevni silveni ren nevöt se numal sen nen. ");
INSERT INTO upv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mian ko vitu jer nen vajin, numal se jinibb ne majingen nen nir olwi vini, owra p̃ilesi suri ta nevöt sen nen ji nir, ko everuse nir. ");
INSERT INTO upv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ko ni nga m̃ila nuvasngavöl valim evini; ko otori nuvasngavöl valim kele oto tevi, ko owrai tevi numal sen owra ‘Numal, nik kula nuvasngavöl valim ko tevik; ko kuplesi, nuloli kele nuvasngavöl valim kele ngel oto tevi.’ ");
INSERT INTO upv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ko numal sen owra tevi ni, ‘Erres p̃elak! Nik kuvi jinibb ne majingen nga m̃irres, ko komok-osuri erres. Suri kuosuri erres re nanu nga welili ngel, ko inu bea-loli nik kupa-metmete nanu pilep kele wor. Kupini re neiren se inu numal som.’ ");
INSERT INTO upv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ko ni nga m̃ila nuvasngavöl varu evini, ko owra ‘Numal, nik kula nuvasngavöl varu ko tevik; ko kuplesi, nuloli kele nuvasngavöl varu kele ngel oto tevi.’ ");
INSERT INTO upv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ko numal sen owra tevi ni, ‘Erres p̃elak! Nik kuvi jinibb ne majingen nga m̃irres, ko komok-osuri erres. Suri kuosuri erres re nanu nga welili ngel, ko inu bea-loli nik kupa-metmete nanu pilep kele wor. Kupini re neiren se inu numal som.’ ");
INSERT INTO upv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ko ni nga m̃ila nuvasngavöl vesan evini, ko owrai tevi: ‘Numal, nurongwose, nik kuvi jinibb nga m̃iterter. Komok-tawe wenen nga nik sete kumruwi, ko komok-ser kortoni wenen nga nik sete komok-juljule tweni dokolvin ren, arivi som. ");
INSERT INTO upv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ko inu numtutu, ko nuan nusilveni nevöt som lolo dan. Kuplesi ngel, nanu nga mivi som.’ ");
INSERT INTO upv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ko numal sen owra lweni tevi: ‘Nik kuvi jinibb ne majingen nga m̃isij! Nibem emijmij temijpal. Kurongwose pae nga inu nomok-tawe wenen nga inu sete nurwi, ko nomok-ser kortoni wenen nga inu sete nomok-juljule tweni dokolvin ren, arivi suk. ");
INSERT INTO upv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ko erpese sete kulngi nevöt suk re bang, ko re daron nga bea-luwi vini, ko bea-lai nevöt suk tevi majbböl nen nga bang mok-wuli lwenie?’ ");
INSERT INTO upv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ko owra tevi jinibb sen sopor, ‘Kapla tweni nevöt suk jin, kaplai tevi ni nga mutori nuvasngavöl valim ngok. ");
INSERT INTO upv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Suri nir jijle nga martori pa, para-lai pilep kele ko wor tevir. Ko ni nga sete mutori milep para-la luwe ko wor jin. ");
INSERT INTO upv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ko kapwirre jinibb ne majingen ngoknga sete muloli nanu san m̃irres van re lat nga mimalik jerjer. Iok ngok jinibb para-ting ko para-runge p̃isij pilep.’ ");
INSERT INTO upv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Re daron nga inu Jinibb Mawos bea-luwi vini tevi nosrövien suk, ko anglo nir para-pitevik. Ko bea-sakel re nai seksakel ne nosrövien suk. ");
INSERT INTO upv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ko anglo nir para-ser kortoni jinibb nir ne vanu jijle renge nok. Ko inu bea-tututweni nir sisamis rer, bea-loli pivi meling p̃ieru e, pirpe jinibb nga mok-metmete sipsip mok-tututweni tweni sipsip sen nir renge nanikot nir. ");
INSERT INTO upv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ko bea-lingi nir nga marirpe sipsip nir re nevrek rres, ko nir nga marirpe nanikot nir re nevrek mair. ");
INSERT INTO upv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ko bea-ivi numal, ko bea-werai tevi nir nga re nevrek rres, ‘Kapini, kami nga Tata suk m̃irij m̃irres suri kami, kapla vajin batun vanu nga Tata suk muloli terai kami re daron nga womu jer nen nga iel ngatan m̃itipatun. ");
INSERT INTO upv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Suri inu numer ajik, ko kamla nanen tevik. Nolok emesmes, ko kamloli numinmin. Nuturvitan, ko kamtekai inu van loloim e. ");
INSERT INTO upv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Numalmal, ko kami kamlai sunsun nuri. Numsi, ko kami kamini kamkulkule inu. Nulik re naim ne nekaien, ko kami kamini jik.’ ");
INSERT INTO upv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ko nir nga marres nen para-taole, para-werai tevi inu, ‘E, numal, seveling namlesi nik, numer ajim, ko namwunganim, rreknga nolom emesmes, ko namloli kuminmin? ");
INSERT INTO upv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Rreknga seveling namlesi nik kuturvitan, ko namtekai nik van loloim se kem, rreknga kumalmal ko namloli kuri sunsun? ");
INSERT INTO upv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Rreknga seveling namlesi nik kumsi, rreknga kulik re naim ne nekaien, ko naminuk jim?’ ");
INSERT INTO upv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ko inu numal bea-werai lweni tevi nir, ‘Nuwretun nuwrai tevi kami, Erpe nga kamloli erres tevi tasik nga welili jer ngel san, ko erpe kele kamloli ko tevi inu.’ ");
INSERT INTO upv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ko mian ko bea-werai kele tevi nir nga renge nevrek mair vajin, ‘Kapruj ngasu inu, kami nga Atua m̃irij pa m̃isij suri kami, ko kapan re nabb nga m̃in tuwi ngok vini, nga Atua muloli terai Demij ko anglo sen nir. ");
INSERT INTO upv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Suri numer ajik, ko sete kamla nanen tevik. Nolok emesmes, ko sete kamloli numinmin. ");
INSERT INTO upv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nuturvitan, ko sete kamtekai inu van loloim e. Numalmal, ko sete kamloli nuri sunsun; numsi, ko nulik re naim ne nekaien, ko sete kami kamkulkule inu.’ ");
INSERT INTO upv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ko nir para-taole ko para-werai lweni tevi inu, ‘E, numal, seveling namlesi nik, numer ajim rreknga nolom emesmes rreknga kuturvitan rreknga kumalmal rreknga kumsi, rreknga kulik re naim ne nekaien, ko sete namloli nanu san tevi nik?’ ");
INSERT INTO upv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ko inu bea-wera lweni tevir, ‘Nuwretun, nuwrai tevi kami, Erpe nga kami sete kamloli tevi san nga welili jer ngel, erpe sete kamloli ko tevi inu.’ ");
INSERT INTO upv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ko nir paran re lat ne norongen nga m̃isij ne tuwi ngok vini. Ko nir nga marres nen paran re mauren ne tuwi ngok vini.” ");
INSERT INTO upv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ko daron nga Iesu mivinvini ore rijen sen ngok vajin, ko owrai tevi jinibb sen nir, ");
INSERT INTO upv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kamrongwose, teru le pa evi nabong ne nanen ne Asien se m̃eri Isrel nir, daron nga marrorrmi lweni nga marivel lingi Ijip tuwi. Ko inu Jinibb Mawos para-tekai kerasik nga para-rruloni inu para-wuse maure inu re nai pelaot, pijpari nga bemij pin.” ");
INSERT INTO upv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Re wosenen mawos bbong ko jinibb nir nga marlelep re sulsulen ko b̃irtera nir nga marivi pa jinibb nga marlelep nir re m̃eri Isrel nir, arini arlik korti re batu jinibb ne sulsulen nir naim sen. Ko batu jinibb ne sulsulen nir nisen ko Kaeapas. ");
INSERT INTO upv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ko armurri suri nga pirpese parrul re venae Iesu nga parevji pini. ");
INSERT INTO upv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ko nir arwerwerai lweni tevir, “Re nabong ne nanen pijki, jinibb nir tara-revji kerr.” ");
INSERT INTO upv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ko vitunen vajin, Iesu evan Betani re naim se jinibb san nisen Saemon nga tuwi mimsi e mesien nga niber m̃im̃emaul. ");
INSERT INTO upv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Re lat nen, nesevin san evini jin, otori botel san nga marmajing e nevöt nga m̃irres san, nisen alapasta. Ko renge botel nen, nuwi nga muto ren, mapun erres elep, ko nowlin ean mare jer. Ko ejvi re batu Iesu daron nga m̃isakel pia-aan e. ");
INSERT INTO upv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ko daron nga jinibb sen nir marlesi, nolor esij e ko arlolar e, ko arwerwera lweni tevir, “Erpese vinel mulokloksi nanu ngok mirpok? ");
INSERT INTO upv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Suri poro parwulwule nuwi ngok, nowlin pilep temijpal, ko parlai tevi b̃eres nir.” ");
INSERT INTO upv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ko Iesu orongwose norrorrmien ser, ko owrai tevir, “Erpese kamlokloksi vinel? Suri ololi majingen nga m̃irres san tevik. ");
INSERT INTO upv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","B̃eres ngok nir arlik tetajer ko pa tevi kami, ko inu sete inu mea-lik tetajer tevi kami. ");
INSERT INTO upv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Renge nga nesevin ngel mijvi nuwi ngel re inu nibek, ololi lilane nga pa partevni inu. ");
INSERT INTO upv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nuwretun nuwrai tevi kami, re iel ngatan totoklai ngabe nga parwerwere nosp̃en nga m̃irres ngel ren, ko parsup̃e kele nanu nga nesevin ngel muloli kele pivi now se ni.” ");
INSERT INTO upv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mian ko san re nir esngavöl drromon eru, nga marveruse Jutas Iskariot, evan ji nir nga marlelep re sulsulen nir ");
INSERT INTO upv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ko owrai tevir: “Kapa-la sev tevik poro nga inu bea-teka kerasi Iesu tevi kami?” Ko arla bebje nevöt silva evi ngavöl itul (30) tevi ni. ");
INSERT INTO upv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ko etipatun re daron nen, epejpej nabong san nga m̃irres nga p̃itka kerasi Iesu ren. ");
INSERT INTO upv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mian ejpari nabong womunen ne nanen ne niv nga is mijki ren. Ko Iesu jinibb sen nir arini jin, arwerai tevi: “Kumarong kem nabloli lilane ngabe nga nik kupaani nanen ne Asien ren?” ");
INSERT INTO upv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ko ni owra “Kapan re ngaim ne Jerusalem ji jinibb san ngok, ko kapwerai tevi ni, ‘Jinibb nevisvisenien owra “Daron suk oto mori pa. Bea-tori nanen ne Asien tevi jinibb suk nir re naim som.” ’ ");
INSERT INTO upv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ko nir arloli erpe nga Iesu muwrai tevir, ko arloli lilane nanen ne Asien etriv. ");
INSERT INTO upv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mian ko rivriv jer ko vajin, nial muwaj pini, ko Iesu esakel tevi jinibb sen nir esngavöl drromon eru, para-aan. ");
INSERT INTO upv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ko daron nga maraan e, ko owrai tevi nir: “Nuwretun nuwrai tevi kami nga san re kami pia-tekai kerasi inu.” ");
INSERT INTO upv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ko nolor arrum elep, ko artipatun arwerwerai tevi ni, “Numal, evi inu?” ");
INSERT INTO upv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ko ni owra lweni tevir, “San re kami nga rramok-saro rramok-la nanen re plet ngel, pia-teka kerasi inu. ");
INSERT INTO upv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Inu Jinibb Mawos bea-van pirpe nga maruli suri inu renge Naul On pa. Ko wi, isi ko pia-ivi m̃ernen nga pia-teka kerasi inu Jinibb Mawos. Erres p̃elak bbong re m̃ernen poro sete p̃iak.” ");
INSERT INTO upv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ko Jutas nga p̃itka kerasi ni owrai tevi ni, “Jinibb nevisvisenien, evi inu?” Ko Iesu owrai tevi, “Erpe nik kumwerai.” ");
INSERT INTO upv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ko re daron nga marok-aan malum e, Iesu ela niv ko owra erres tevi Atua suri, ko otpoi ko owngani tevi jinibb sen nir ko owra “Kaplai kapurroi, ngel evi nibek.” ");
INSERT INTO upv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ko elai kele biles ko owra erres tevi Atua suri, ko elai tevir, ko owra “Kami jijle kapmini. ");
INSERT INTO upv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ngel evi drrak nga puloli marongen se Atua putur imare. Inu mejvi ngel suri netlasien ne nololien se delung nir. ");
INSERT INTO upv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nuwrai tevi kami, Sete nurongwose bemni kele norro ngel pijpari nabong nga bea-mini nga mimerr tevi kami renge batun vanu se Tata suk.” ");
INSERT INTO upv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mian ko arla nubo nga marok-lai daron nga maraan jile re nanen ne Asien osuw, ko arivel vajin van re Botwen ne lolnai ne olip. ");
INSERT INTO upv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ko Iesu owrai tevir, “Kami jijle nolo kami pia-vitan suri inu renge natmupong ngel, suri aruli re Naul On, ‘Bea-revji jinibb nga mok-metmete sipsip, ko sipsip para-wolu sarrsarr.’ ");
INSERT INTO upv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ko bea-tur imare kele, ko vitunen vajin ko bea-womu bea-ivel ore womu kami re Galili.” ");
INSERT INTO upv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ko Pita owra lweni tevi: “Poro nolo jinibb ngel jijle nir pia-vitan suri nik, ko inu ma nolok setete mia-vitan.” ");
INSERT INTO upv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ko Iesu owrai tevi, “Nuwretun nuwrai tevi nik, renge nat nga mupong ngel puwomu, vitunen ko nato pia-kokrout, ko nik kupa-vilvil ore inu pivatul.” ");
INSERT INTO upv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ko Pita owra lweni tevi: “Setete bea-vilvil ore nik ko, poro bea-mij wor tevi nik!” Ko jinibb sen jijle nir arwerai kele erpok. ");
INSERT INTO upv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Vitunen Iesu eptevi jinibb sen nir aran re lat san nisen Getsemane. Ko owrai tevir, “Kaplik iel, daron nga inu ban beverus sopon iok.” ");
INSERT INTO upv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ko etkai Pita ko natu Sepeti nuru, arivel rujruj sopon. Ko ni nolon orrum elep vajin ko ornge esij. ");
INSERT INTO upv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ko owrai tevir, “Inu nolok orrum temijpal, otomori puloli bemij e. Kaplik iel ko kapkulkulu p̃irres tevi inu.” ");
INSERT INTO upv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ko ni evel rujruj kele sopon van ngasu ko ejiol non van ngatan ko olot ko owra “Tata suk, poro pivi nanu nga p̃isisarow, kupla tweni biles ne norongen nga m̃isij ngel, inu sete bea-minmin ren. Ko piplari pusorsan tevi nik marongen som, sete inu marongen suk.” ");
INSERT INTO upv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ko olwi kele vini ji jinibb sen nir nga itul nga ko elesi armaturrwel; ko owra tevi Pita, “Erpese kami sete kamviter kapkulkulu tevi inu mete nial p̃isansan? ");
INSERT INTO upv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kapkulkulu p̃irres, ko kapverus nga sete nanu parini parrowrrow p̃elake kami. Nem̃i kami emarong lengleng, ko nibe kami emijmij.” ");
INSERT INTO upv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ko evel lingir kele varwen ko olot kele, owra “Tata suk, poro pivi nanu nga p̃isisarow, kuploli biles ngel pia-asi re inu, nga inu sete beminmin ren. Ko pirpok ko wor, piplari ko wor pusorsan tevi marongen som.” ");
INSERT INTO upv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ko olwi kele vini; ko elesi armatur kele, suri meter orrwel. ");
INSERT INTO upv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ko elinglingir ko evel lingir kele ko olot vatolin, owra kele nale mawos nga muwrair womu. ");
INSERT INTO upv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Vitunen, olwi kele vini ji jinibb sen nir nga itul nga, ko owrai tevi nir, “Erres, kapmatur vajin, kapmosi p̃irres. Kaplesi. Daron suk evini nga parteka kerasi inu Jinibb Mawos van re nevre lartul nga marsij nir. ");
INSERT INTO upv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kapmera, kerr pivel. Kaplesi m̃er nga p̃itka kerasi inu otomori le pa pivini.” ");
INSERT INTO upv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ko daron nga ni m̃irij malum e, ko Jutas, san re esngavöl drromon eru evini, eptevi delung nga milep san ngamartori nesip ne nuval ser nir ko b̃etiluk ser nir. Arivel ji jinibb nga marlelep re sulsulen nir ko b̃irtera nir nga marivi pa jinibb nga marlelep re m̃eri Isrel nir vini. ");
INSERT INTO upv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ko ni nga p̃itka kerasi ni owrai pa tevir lat nga pia-loli surie, owra “Kaplesi si nga bea-rromji, ni evi ni nen ko. Kapa-rrul ren.” ");
INSERT INTO upv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Marini vajin, ko ngavilvil ni evan ji Iesu ko owra “O, erres, jinibb nevisvisenien.” Ko orromji ni. ");
INSERT INTO upv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ko Iesu owrai tevi ni, “Selek, kuploli vajin nanu nga kumini suri.” Ko nir arini, ko arrul totoni Iesu. ");
INSERT INTO upv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ko san re nir nga marpitevi Iesu esaro ko ervei tweni nesip ne nuval sen ko eta jinibb san, ko eta tweni boron. Ko m̃ernen evi jinibb ne majingen se batu jinibb ne sulsulen nir. ");
INSERT INTO upv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ko Iesu owrai tevi, “E, kuplingi lweni nesip ne nuval som ngok re milngen. Suri nir jijle nga marla nesip ne nuval, para-mij ko renge nesip ne nuval. ");
INSERT INTO upv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nik kurrorrmi sete nurongwose beveruse Tata suk, ko ni lelingen wolok pukoni meling nga marlelep ne anglo ne nuval pisngavöl drromon p̃ieru (12) parpitevi inu? ");
INSERT INTO upv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ko poro pirpok, ko pirpese nga nale se Atua nga maruli renge Naul On nga pia-pelari ko wor suri inu pia-rremali mawos?” ");
INSERT INTO upv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ko re daron mawos nen, Iesu owrai tevi delung nir, “Erpese? Kamloli erpe nuvi jinibb nga mok-revji jinibb san. Kamini tweni kaprrul totkonik, ko kamtori nesip ne nuval nir ko b̃etiluk nir. Ko tetajer nomok-lik renge Naim On, nomok-visviseni, ko sete kamrrul totkonik. ");
INSERT INTO upv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ko nanu ngel jijle nir arpelari osorsan tevi nale se Atua nga propet sen nir aruli wowomue tuwi pa.” Erij jile erpok, ko jinibb sen nir arivel arwolu lingi. ");
INSERT INTO upv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ko delung nga marrul totkoni Iesu arevei tweni van ji Kaeapas, nga mivi batu jinibb ne sulsulen nir, lat nga jinibb nevisvisenien ne nale nesesreien nir ko b̃irtera nir nga marivi pa jinibb nga marlelep re m̃eri Isrel nir markorti pa ren. ");
INSERT INTO upv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ko Pita evivitue nir vitu jer van re lolo naworr ne naim se batu jinibb ne sulsulen nir nga mutur ren. Ko elik ngatan tevi jinibb nga marok-metmete lat nen, owra p̃ilesi bongsi nanu nga parloli tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ko jinibb nga marlelep ne sulsulen nir tevi nir jijle nga marok-tori gortien nga milep arpejpej nale gerisen san nga p̃itre Iesu, puloli parlingi ni re mijen suri. ");
INSERT INTO upv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko sete artor sweri san, ewretun nir elep arini ko arkerkeris bbong. Mian ko vitu jer nen ko vajin, jinibb eru orini ");
INSERT INTO upv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","orwera “M̃erel owra ‘Inu nuvter bolokloksi Naim On se Atua ngel, ko nabong p̃itul kobbong, bea-ili lweni.’” ");
INSERT INTO upv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ko batu jinibb ne sulsulen nir otur imare ko owrai tevi ni: “Sete kupwera nanu san? Erpese re nale se nuru nga morij terem e ngok?” ");
INSERT INTO upv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ko Iesu omurrong. Ko batu jinibb ne sulsulen nir owra kele tevi, “Nungoni nik re nise Atua nga mimaur, kupwera weretunen tevi kem poro nik kuvi Mesaea Atua natun, rreknga ejki!” ");
INSERT INTO upv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ko Iesu owrai, “Erpe nik kumwerai. Ko nanu san kele bowrai tevi kami: Vitunen kapa-lesi inu Jinibb Mawos bea-sakel renge Atua nga derteren sen mutoe nevren rres. Ko bea-luwi re nabor ne melrin vini.” ");
INSERT INTO upv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Daron nga batu jinibb ne sulsulen nir murnge nale se Iesu ngok, ko errerrsi sunsun sen, ko owra “A, ni erij melmelas ko osopsop̃e pa Atua! Erpese kerr rrampej malum jinibb kele san nga puwra nale kele sopon? Kaplesi, lelingenok kamrunge ni erij esij. ");
INSERT INTO upv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kamrrorrmi erpese?” Ko nir arwera lweni tevi, “O, ni erres re pimij ko wor!” ");
INSERT INTO upv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ko arlutövi non ko aruti, ko nir sopon arwuje ");
INSERT INTO upv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ko artetnije ni, ko arwerai tevi, “Kupwerai tevi kem, nik Mesaea, isi ko muwjem ngok?” ");
INSERT INTO upv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ko Pita elik malum vare re naim renge lolo naworr nen. Ko nesenwarreng ne majingen san evini jini, ko owrai tevi ni: “E, nik kele komok-pitevi Iesu ne Galili.” ");
INSERT INTO upv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ko ni evilvil ore renge no delung nir, owra “Sete nurongwose nanu nga kumwerai ngok!” ");
INSERT INTO upv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ko ni orujruj van morie metali ne naworr nen. Ko nesenwarreng m̃inij kele san elesi ni, ko owrai tevi nir nga marlik ie, “M̃erel okpitevi Iesu ne Nasret.” ");
INSERT INTO upv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ko ni evilvil ore kele ojuji mare, owra “O ejki, sete nurongwose morok!” ");
INSERT INTO upv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mian ko beblen kele, ko nir nga martur iok arini ji ni ko arwerai tevi Pita, “Ewretun nik kuvi nir san, suri rijen som erpe m̃eri Galili nir.” ");
INSERT INTO upv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ko Pita ololi nale nga m̃iterter temijpal san, ko ojuji mare ren ko owra “Mowra sete nurongwose morok!” Ko mian ko ngavilvil nato okokrout. ");
INSERT INTO upv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ko Pita orrorrmi vajin nale se Iesu nga muwrai tevi ni, “Puwomu, vitunen ko nato pia-kokrout, ko nik kupa-vilvil ore inu pivatul, nga kupwera sete kurongwose inu.” Ko ni eivare ko eting temijpal. ");
INSERT INTO upv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Daron nga rorpong susu mivini e, ko jinibb nga marlelep ne sulsulen nir ko b̃irtera nir nga marivi pa jinibb nga marlelep nir artori gortien san, armurri suri parlingi Iesu re mijen. ");
INSERT INTO upv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Armurri jile osuw, ko arsere nevren ko arpitei tweni ko artekai van ji numal Paelet, nga batu numal se m̃eri Rom nir m̃ilngi ni nga pok-metmete m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ko daron nga Jutas, nga m̃itka kerasi Iesu, m̃ilesi nga marwera Iesu pimij, ko norrorrmien sen olwi. Ko ela lweni bebje nevöt silva ngavöl itul nen elai van ji jinibb nga marlelep nir re sulsulen ko b̃irtera nir nga marivi pa jinibb nga marlelep nir, ");
INSERT INTO upv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ko owrai tevir, “O, nuloli nololien re nga mirpel ngel nga m̃etka kerasi jinibb nga m̃irres pian re mijen!” Ko nir arwera “Ko erpese kumini kumngoni tevi kem? Sete evi nga kem, evi nga nik ko wor. Kuprunge surim tevi!” ");
INSERT INTO upv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ko Jutas ewirr tweni nevöt nen van loloim re Naim On, ko evel, ko evan orruloni lweni ni tevi dil, ko emij. ");
INSERT INTO upv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ko jinibb nga marlelep re sulsulen nir arla nevöt nen, ko arwera “Sete erres rraplai rraplingi re nevöt ne Naim On bokis nen, suri evi nowli drra ne mijen.” ");
INSERT INTO upv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ko armurri suri, mian ko arla nevöt nen, arwuli tweni dan sopon se m̃er nga mok-majing sospen dan, ko arloli pivi lat san nga partevni jinibb neturvitan nir ren. ");
INSERT INTO upv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ngok dan ngok arveruse “dan ne drra ne mijen” ejpari lelingenok. ");
INSERT INTO upv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ko ngok kele eplari erpe nale se Atua nga propet sen Jeremaea muwrai wowomue tuwi pa ngel: “Ko nir arlai bebje silva nevöt ne ngavöl itul, nowli ni nga m̃eri Isrel sopon arlingi nowlin. ");
INSERT INTO upv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ko arlair arwuli tweni dan se m̃er nga mok-majing sospen dan, erpe nga Numal Atua muwrai tevi inu bololi.” ");
INSERT INTO upv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Musuw, ko Iesu vajin otur womu re no numal Paelet. Ko numal Paelet osusi tevi, owra “Nik kuvi numal se m̃eri Isrel nir?” Ko Iesu owrai tevi, “Erpe nga nik kumwerai.” ");
INSERT INTO upv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ko daron nga jinibb nga marlelep re sulsulen nir ko b̃irtera nir nga marivi pa jinibb nga marlelep nir marwera tweni nale ser nga marij tere Iesu ren, ko ni sete owra lweni nanu san. ");
INSERT INTO upv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ko daron nga nir marij jile musuw, ko numal Paelet owrai tevi ni, “Erpese? Sete kurnge nale ser nga muwun saut ngok nga marij terem ngok?” ");
INSERT INTO upv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ko ni sete owra suri lweni nanu san tevi, ololi numal Paelet etaol lenglenge. ");
INSERT INTO upv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ko sia jijle, re daron ne nanen ne Asien mirpok, ko numal Paelet ok-marong pok-la tweni jinibb nga m̃ilik re naim ne nekaien san nga delung nir poro parwera nisen. ");
INSERT INTO upv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ko jinibb san elik re naim ne nekaien re daron nen, arveruse nisen Iesu Barapas. Jinibb jijle arok-runge nanu nga marsij nga mok-lolir. ");
INSERT INTO upv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mian ko delung arkorti vajin, ko numal Paelet osusi lesi owrai tevir, “Kammarong isi bea-la tweni tevi kami, Iesu Barapas, rreknga Iesu nga marveruse Mesaea?” ");
INSERT INTO upv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Suri numal Paelet orongwose nolor eval tevi Iesu ko niko martekai vini jin. ");
INSERT INTO upv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ko daron nga m̃isakel ngatan re lat nga mok-sakel ren mok-wera suri lat nga puto suri tevi jinibb nir e, ko nesen sen oli naul ko elai tevi jinibbsan elai van jin, ko owra “Sete kuploli nanu san tevi jinibb nga m̃irres ngok, suri numatur lesi bori natmupong suri ni, ko nurnge esij elep e.” ");
INSERT INTO upv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ko jinibb nga marlelep re sulsulen nir ko b̃irtera nir nga marivi pa jinibb nga marlelep nir arververus delung nir nga parungoni p̃ila tweni Barapas ko pirevji pini Iesu. ");
INSERT INTO upv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ko re daron nga numal Paelet mususi kele e tevir, “Kammarong isi ko re nuru nga eru ngel bea-la tweni tevi kami?”, ko nir arwerai lweni, “Barapas!” ");
INSERT INTO upv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ko numal Paelet owra lweni tevir, “Poro pirpok, ko bololi sev tevi Iesu nga marveruse Mesaea?” Ko nir jijle arwera lweni tevi, “Pimij re nai pelaot!” ");
INSERT INTO upv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ko numal Paelet owra “Suri sev? Ololi sev esij?” Ko nir arkail van mare kele, “Pimij re nai pelaot!” ");
INSERT INTO upv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ko numal Paelet elesi vajin sete orongwose puloli mun nanu san, suri delung artoni lweni ni eterter, ko otomori vajin parloli laten nga milep san. Ko elai nuwi sopon ko ejejavöl e renge no delung nir ko owra “Inu drra jinibb ngel sete pubböljik. Kaprunge suri kami tevi!” ");
INSERT INTO upv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ko nir jijle arwera lweni tevi, “Rrek erres, drran pubbölji kem ko metka se kem nir.” ");
INSERT INTO upv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Marwera jile mirpok, ko numal Paelet ela tweni Barapas tevir. Ko etelmaji Iesu ko etkai vini ji jinibb ne nuval sen nir, nga pimij re nai pelaot. ");
INSERT INTO upv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ko nir vajin artekai Iesu van re naim nga milep se numal Paelet, ko arser kortoni delung ne jinibb nuval nir. ");
INSERT INTO upv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ko nir aruri tweni sunsun sen ko aruri lweni sunsun nga nulsen musongsong van ren; ngok arrongrrongvi nulse sunsun se numal ser nir. ");
INSERT INTO upv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ko artali dil moku arrongrrongvi erpe nuvan se numal san, ko arlingi re batun ori; ko arla mavir otori orrongrrongvi nai se numal nga mok-tori. Musuw ko arjipa vajin baur ngatan jin arkerkerasi, arwera “O, erres, numal se m̃eri Isrel nir!” ");
INSERT INTO upv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ko arlutövi ni, ko arla mavir nen ko arvirrvirrale batun e. ");
INSERT INTO upv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ko arkerkerasi ni mirpok jile musuw, ko aruri tweni sunsun ren ko aruri lweni sunsun sen van ren, ko arpitei tweni ni van re lat nga pimij re nai pelaot e. ");
INSERT INTO upv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ko daron nga marivel mirpok vini, ko arlesi jinibb san ne Saerin nga nisen Saemon. Ko aron tertere ni nga puwosi nai pelaot se Iesu. ");
INSERT INTO upv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ko mian ko arini vajin re lat san nisen Golkota. Nais ngok renge nale se m̃eri Isrel nir owra “Lat ne bongur.” ");
INSERT INTO upv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ko arla norro, ko arlingi nanu san nga mirpe melu van ren nga puloli poro pimni ko niben puprus e. Ko arlai tevi. Ko ni, daron nga mimni lesi bbong, ko omusus pimni. ");
INSERT INTO upv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ko arruloni arwuse vajin re nai pelaot, musuw ko artutweni sunsun sen, ko artuwe daes arwera parlesi isi nga poro pia-asi, niko sunsun se Iesu pivi sen. ");
INSERT INTO upv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Musuw, ko arlik ngatan vajin, ko armetmet suri Iesu ie. ");
INSERT INTO upv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ko aruli tweni nale san ngel suri nga marevji pini ni, “M̃erel evi Iesu, numal se m̃eri Isrel nir,” ko arwuse mare re batun. ");
INSERT INTO upv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ko arruloni kele jinibb eru nga morok-vevna ko morok-revrevji jinibb tevi Iesu, nuru tuwen arwuse re nai pelaot san re nevren rres ko tuwen re nevren mair. ");
INSERT INTO upv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ko lartul nga marasasi ie arij esij tevi, arwirrwirrleni batur tevi, ko armen keraji. ");
INSERT INTO upv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ko arwerai tevi, “A, nik nga kumwera kuplokloksi Naim On ko nabong p̃itul ko kup̃ili lweni, kupla lweni nik poro kumivi Atua Natun, ko kuprow jubbul re nai pelaot vitan!” ");
INSERT INTO upv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Erpok kele re jinibb nga marlelep re sulsulen nir, arkerkerasi Iesu tevi jinibb nevisvisenien ne nale nesesreien nir ko b̃irtera nir nga marivi pa jinibb nga marlelep re m̃eri Isrel nir, ko arwera ");
INSERT INTO upv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Poro weretunen m̃ila se jinibb m̃inij nir, ko erpese ni sete orongwose p̃ila lweni se ni? Evi numal ne Isrel, ko purow jubbul re nai pelaot vitan, ko rrapa-osuri ni vajin! ");
INSERT INTO upv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ni ebibto Atua, Atua p̃itka tweni vajin lelingenok poro pimrreni ni. Suri owrai pa, ‘Inu nuvi Atua Natun.’” ");
INSERT INTO upv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Erpok kele, nuru nga morok-revrevji jinibb nga marruloni nuru tevi Iesu oraji liwe nuru tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ko mian ko levial ko vajin, nial muwosput, ko nat emalik p̃etp̃eti re vanu ejpari mete nial itul. ");
INSERT INTO upv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ko momsawos mete nial itul sopon, ko Iesu ekail drrelan elep, owra “Eli, Eli, lama sapaktani?” Ngok renge nale se m̃eri Isrel nir owra “Atua suk, Atua suk, erpese kumiel lingi inu?” ");
INSERT INTO upv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ko nir sopor nga martur ie arunge jabble, ko arwera “M̃erel everuse Elaeja ko.” ");
INSERT INTO upv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ko ngavilvil nir san owlu van ko ela nanu san erpe nalum, ko ololi ervei norro nga mimelmel van ren, ko elngi re mavir ko esareni tevi Iesu pimni. ");
INSERT INTO upv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ko nir m̃inij nen nir arwera “Pirpok pa! Rraplesi ta poro Elaeja pivini pia-la sen.” ");
INSERT INTO upv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ko Iesu ekail kele drrelan elep ko osrow pini. ");
INSERT INTO upv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ko kalik nga murrul ore lat nga muon emarrerr devjen eru e, m̃itipatun re bongsin nga mare osuw re bongsin nga ngatan. Ko nam̃i em̃i ko b̃ereng nir armoworwor. ");
INSERT INTO upv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ko dubb nir artep̃ir, ko nibe jinibb on elep nga marmij armera. ");
INSERT INTO upv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ko vitunen daron nga Iesu mimra jile re mijen sen ko nir arivel lingi dobbir, ko aran re Ngaim On Jerusalem; ko arpelari ji jinibb elep arlesir. ");
INSERT INTO upv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ko daron nga numal se jinibb nuval nen nir ko jinibb nga marpitevi ni marmetmet suri Iesu marunge nam̃i m̃im̃i ko nanu jijle nga marpelari ngok, ko armetutu temijpal, arwera “Ewretun, m̃erel evi Atua Natun!” ");
INSERT INTO upv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ko nesevin elep nga marok-majing sen ko nga marvijuri re Galili vini, artur ngasu bbong ko armeteni. ");
INSERT INTO upv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Livö re nir, Merri ne Maktala ko Merri tasu se Jemes ko Josep, ko Sepeti nesen sen. ");
INSERT INTO upv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mian ko rivriv jer vajin, jinibb ne Aramatia san nga joron milep, nisen Josep, evini. Ni kele evi jinibb se Iesu san. ");
INSERT INTO upv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ko evan ji numal Paelet, ongoni nibe Iesu. Ko numal Paelet owra nale san nga parlai. ");
INSERT INTO upv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ko Josep ela niben, ko onb̃e ore kalik nga muwokwok e m̃irres. ");
INSERT INTO upv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ko elngi renge dubb sen nga mimerr nga m̃itai renge b̃ereng. Ko eitini nevöt b̃ereng nga milep san oto ore metali ne dubb, ko evel lingi. ");
INSERT INTO upv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Merri ne Maktala ko Merri m̃inij nen kele san orlik mori bbong ie, no nuru orlik ormawos e dubb. ");
INSERT INTO upv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ngok evi nabong nga parloli lilane nanu parto pumomsawos parteravi nabong ne Sapat. Mevinen jinibb nga marlelep re sulsulen nir ko Parasi nir arini arkorti ji numal Paelet, ");
INSERT INTO upv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ko arwera “Numal, namrrorrmi iok. Jinibb ne gerisen ngok daron nga mimaur malum e, ko owra ‘Vitunen, nabong p̃itul, ko bea-maur luwi kele re mijen.’ ");
INSERT INTO upv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ngok, kupwerai ta nale san nga parmetmet ore dubb p̃irres pijpari nabong p̃itul. Jinibb sen nir tarini ko tarvenae tweni ni ko tarwerai tevi jinibb nir, ‘Ni emaur luwi re mijen.’ Ngok poro pirpok gerisen nga vitu jer nen tia-sij tia-asie nga womuj nen.” ");
INSERT INTO upv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ko numal Paelet owrai tevir, “Kamrongwose kapla jinibb nuval sopor. Kapiel vajin kaploli parmetmet ore nanu jijle puto p̃irres pirpe nga kami kamrongwose.” ");
INSERT INTO upv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ko arivel aran ko arlingi nanu san renge nevöt nga muto ore metali nga puloli parongwose poro jinibb san p̃iasi van loloim. Ko arlingi jile osuw, ko arlingi vajin jinibb ne nuval nen nir parmetmet ore. ");
INSERT INTO upv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mian ko vitunen ko vajin, nabong ne Sapat osuw ko nial etipatun nga pimraej re nabong womu re wik, ko Merri ne Maktala ko Merri m̃inij nen kele oran orwera porlesi dubb. ");
INSERT INTO upv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ko nam̃i nga milep san em̃i, suri anglo san se Numal Atua ojubbul re melrin vini; evini eitini tweni nevöt ne metali, ko esakel ren. ");
INSERT INTO upv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Non erinrin erpe moro navil ko sunsun sen eraprap temijpal erpe numow. ");
INSERT INTO upv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ko nir nga marmetmete dubb armetutue ko aririr lengleng, arirpe jinibb nga marmij nir. ");
INSERT INTO upv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ko anglo erij, owrai tevi nesevin nen nuru, “E, sete kopormetutu, suri nurongwose komorpej Iesu nga mimij re nai pelaot. ");
INSERT INTO upv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ni ejki iel. Suri emaur luwi kele, erpe nga muwrai wowomue. Koporini ta koporlesi lat nga mimatur ren.” ");
INSERT INTO upv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nuru orlesi jile osuw, ko anglo owrai kele: “Koporan pingavil, koporwerai tevi jinibb sen nir nga ni emaur luwi kele pa renge mijen. Ko ni puwowomue kami van re Galili e, ko kapa-lesi ie. Pirpe nga inu mowrai ngel tevi kamru.” ");
INSERT INTO upv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ko orivel lingi dubb ngavilvil tevi metutuen ko neiren nga milep, ko orwolu van porla nale tevi Iesu jinibb sen nir. ");
INSERT INTO upv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ko ortaole orsorrvij lengleng Iesu miplari ji nuru, ko owra “O, erres.” Ko oran orjipa ngatan jin ko orrul totoni b̃elan, ko orsurövi ni. ");
INSERT INTO upv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ko Iesu owrai tevi nuru, “Sete kopormetutu. Koporan koporwerai tevi tasik nir nga para-wowomu iak Galili, ko para-lesik ie.” ");
INSERT INTO upv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ko daron nga nuru moran e, ko jinibb sopor nga marmetmet dubb nen arluwi van Jerusalem e, ko arwerai tevi jinibb nga marlelep re sulsulen nir nanu jijle nga marpelari. ");
INSERT INTO upv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ko nir arkorti tevi b̃irtera nga marivi pa jinibb nga marlelep nir ko armurri suri parloli pirpese partawi ore nanu nga miplari. Mian ko vitunen ko vajin arla nevöt elep tevi jinibb nuval nen nir, ");
INSERT INTO upv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ko arwerai tevi nir, “Kami kapwerai tevi jinibb nir, ‘O, jinibb sen nir arini natmupong ko arvenae tweni niben daron nga nammatur e.’ ");
INSERT INTO upv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ko poro numal Paelet purnge nale ngel, ko kem naba-van naba-loli p̃irres tevi ni, ko kami sete kapa-la norongen nga m̃isij ren.” ");
INSERT INTO upv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ko jinibb nuval nen nir arla nevöt nen evi se nir, ko arloli erpe nir marwerai suri tevir. Ko nosp̃en ne gerisen ngel m̃eri Isrel nir arsup̃e ejpari lelingen ngel malum. ");
INSERT INTO upv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ko Iesu jinibb sen nir esngavöl drromon san (11) arivel van re Galili van re botwen nga Iesu muwrai pa tevir. ");
INSERT INTO upv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ko daron nga marlesi ni, ko arsurövi ni; ko nir sopon sete arosuri erres. ");
INSERT INTO upv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ko Iesu evini mori jir, ko owrai tevir, “Atua elai pa derteren jile tevi inu re nanu jijle ne melrin ko iel ngatan. ");
INSERT INTO upv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngok, kapan re vanu jijle, kapvisviseni jinibb nir, para-ivi jinibb suk. Ko kappaptaes nir re nise Tata suk ko re nise inu Atua Natun, ko re nise Nem̃in On. ");
INSERT INTO upv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ko kapvisvisenir nga parloli suri nanu jijle nga mowrai tevi kami. Ko kaplesi, inu beptevi kami tetajer, pian pijpari ngatan ngel bongsin.” ");
INSERT INTO upv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Batu nosp̃en nga m̃irres se Iesu Kristo Atua Natun. Ko etipatun erpel: ");
INSERT INTO upv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Erpe Atua owrai renge naul nga Aesea propet sen muli tuwi pa, owra “Kapmurrong, bokoni jinibb suk san nga puwowomu re Mesaea, ko puloli sel se ni puto metmet. ");
INSERT INTO upv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Drrela m̃ernen ekail renge lolo merwer owra ‘Kaploli lilane sel se Numal puto metmet terai! Kaploli mesekle sel sen nir parmetet p̃irres.’” ");
INSERT INTO upv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Erpok ko Jon evini, ko ewerwer owra “Kaprieni lweni nolo kami renge nololien se kami nir, ko kappaptaes, ko Atua p̃itlasi tweni nololien se kami.” Ko Jon ok-paptaes renge lolo merwer. ");
INSERT INTO upv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ko renge ie jinibb jijle ne vanu ne Jutia nir ko nir jijle nga renge Jerusalem nir arivel tweni. Arwerwera tututweni nololien ser nir, ko Jon epaptaese nir renge nuwi seser ne Jortan. ");
INSERT INTO upv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ori bbong silvi kamel nga marvati mivi sunsun, ko etatuwe nevlu buluk renge netutwen, erpe Elaeja tuwi. Ko orro bbong nato nga mok-rowrow renge mösmös ko narrlu sukabak nga m̃ierri. ");
INSERT INTO upv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ko ewerwer owra “San nga pivivitu suri inu vini niko, ni evan wor mare renge inu. Inu sete nurres rragrrag nuvter nga b̃ejiol vitan nga b̃etlasi tweni dil renge but sen. ");
INSERT INTO upv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inu nomok-paptaese kami bbong e nuwi le, ko ni ma pia-paptaese kami e Nem̃in On.” ");
INSERT INTO upv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sete epriv ko Iesu evel lingi sisen Nasret, ngaim nga welili ne Galili san, ko evini ji Jon. Ko Jon epaptaese ni renge nuwi seser ne Jortan. ");
INSERT INTO upv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ko daron nga mitawij renge nuwi imare, ko elesi evesane melrin eteri wukari eru e etp̃ir; ko elesi Nem̃in On erpe wum̃er orow jubbul rengen vini ko esakel renge ni. ");
INSERT INTO upv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ko drrela Atua evel renge melrin vini owra “Nik kuvi natuk nga numrrenim elep, nurnge erres surim.” ");
INSERT INTO upv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Daron mawos nen ko pa, Nem̃in On owowomue Iesu orujruj kele wor van renge lolo merwer liven sopon. ");
INSERT INTO upv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ko ni elik renge ie ejpari nabong ngavöl ivij (40) nga Demij mok-rrowrrowe, ni elik renge lat nga nanu rrum ne lolo merwer nir marok-tur rengen. Ko anglo arok-kuluklu metmet re ni erres kemkam̃e. ");
INSERT INTO upv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Arlingi womue Jon renge naim ne nekaien, mian ko vitunen vajin ko Iesu ea-vini renge Galili, evisviseni nosp̃en nga m̃irres se Atua. ");
INSERT INTO upv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ko ni owrai owra “Nabong suk mawos le pa, ko batun vanu se Atua oruj mori pa pivini. Nolo kami pulululwi ko kaposuri nosp̃en nga m̃irres.” ");
INSERT INTO upv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Vitunen vajin ko Iesu evel sere suri jeli nuwito nga milep ne Galili. Ko elesi Saemon nuru tasin wor Antru orok-juröni niva se nuru van renge nuwi ngatan, suri nuru orivi jinibb nga morok-revrevei nai. ");
INSERT INTO upv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ko Iesu owrai tevi nuru owra “Laru, koporini koporvitu surik, ko inu bololi kamru koporivi jinibb nga morok-revrevei jinibb.” ");
INSERT INTO upv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ko orsaro ngavilvil orlingi kurtweni niva se nuru ojpon jer, ko orvijuri suri ni. ");
INSERT INTO upv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ko daron nga mivel rujruj kele beblen e ko elesi Sepeti natun nuru, Jemes ko tasin wor Jon, orsakel renge drrav ser orok-ilile lweni niva ser lat nga marmarrerr nir. ");
INSERT INTO upv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ko Iesu everus nuru kele, ko nuru orlingling tata se nuru Sepeti renge drrav ser tevi jinibb ne majingen sen nir, ko orvijuri Iesu. ");
INSERT INTO upv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ko Iesu eptevir aran renge ngaim ne Kapaneam e. Ko renge Sapat aran renge naim ne loten ser, ko Iesu evisviseni jinibb nir. ");
INSERT INTO upv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ko daron nga jinibb nir marmurrarrong suri ni nevisvisenien sen e ko bbösa elair e. Suri ni nevisvisenien sen orrow erres, sete erpe nevisvisenien se jinibb nevisvisenien ne nale nesesreien nir. ");
INSERT INTO upv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ko re daron nen renge naim ne loten, jinibb nga nem̃in nga m̃isij m̃isisilvi san elik rengen, ko ekail van mare, owrai tevi Iesu ");
INSERT INTO upv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","owra “Sev som oto ni le iel, nik Iesu ne donasret? Kuvini nga kuplokloksi kem? Inu nurongwos nik, isi nik. Nik kuvi jinibb on se Atua.” ");
INSERT INTO upv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ko Iesu ewer ore nem̃in nga m̃isij ko owrai tevi owra “Sete kuprij, kupivare lingi ni.” ");
INSERT INTO upv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ko nem̃in nga m̃isij ololi ni elilawij ko eririr lengleng. Ko ekail van mare ko esil ivare, ko owlu lingi. ");
INSERT INTO upv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bbösa nga milep elair e, ko arsur vijvij, arwerwera lululweni tevir, “Sev le ngel? Nevisvisenien nga mimerr san! Nale sen orrow otutun erres, owrai bbong tevi nem̃in nga marsij nir ko arosuri ni.” ");
INSERT INTO upv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ngavilvilsen nosp̃en nen arsupsup̃e rrerrale p̃etp̃eti vanu ne Galili jile nir. ");
INSERT INTO upv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mian ko nir arivare lingi naim ne loten vini vare e, ko artajer van renge naim se Saemon e ko Antru; ko Jemes ko Jon orpitevir. ");
INSERT INTO upv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ko iok Saemon p̃ilen lekter emsi mesien dowalul ematur, ko arwerai tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ko ni evan ko orrul re Saemon p̃ilen nevren ko esa raji imare. Ko mesien dowalul evel lingi vin nga, ko ean etabbu nurrer. ");
INSERT INTO upv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ko renge nat nga mirivriv daron nga nial miwaj pini e ko nabong on ser musuw, ko jinibb nir arwowosi vajin jinibb nga marmesi nir, ko artekai jinibb nga nem̃in nga marsij marsisilvir kele arini ji Iesu. ");
INSERT INTO upv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ko jinibb jijle nga renge ngaim nen arini arlik korti armot rrale metali vare e. ");
INSERT INTO upv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ko ni ololi nir elep nga marmesi mesien lele arres luwi, ko oji tweni nem̃in nga marsij elep. Ko ewer orer nga sete parij, suri arongwose ni. ");
INSERT INTO upv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Renge rorpong susu nat nga p̃isal p̃irin, ko Iesu emremra esan evel van renge lat nga nat mubbubbil e san, ko olot ie. ");
INSERT INTO upv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mian ko sete epriv ko Saemon ko nir nga marlik tevi ni, arpej ni ko arvivitu suri ni. ");
INSERT INTO upv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mian ko artor sweri ko aran jin. Daron nga maran jin e, ko arwerai tevi ni arwera “Ai, jinibb jijle arok-pej nik.” ");
INSERT INTO upv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ko ni owrai tevir owra “Kerr pian kele wor re ngaim m̃inij e nir, nga inu b̃ewerwer kele renger. Suri nuvini tweni iok le ngel.” ");
INSERT INTO upv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ko ni evan renge loloim ne naim loten ser p̃etp̃eti nir renge Galili ko ok-werwer renge nir, ko okoji tweni nem̃in nga marsij nir. ");
INSERT INTO upv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ko nabong san jinibb nga mimsi mesien nga niber m̃im̃emaul san evini ejipa jin ngatan, ko ongoni tevi ni owra “Wurru, poro nga nik kupmarong ko kurongwos kuploli inu bowokwok.” ");
INSERT INTO upv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ko Iesu orrorrmi lenglenge ni, ko sete ering e mesien sen, ko esaro elngi nevren rengen; ko owrai tevi owra “Inu numarong. Kupwokwok ko.” ");
INSERT INTO upv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ko ngavilvilsen mesien nga niber m̃im̃emaul evel lingi ni, ko ni owokwok ko ornge erres luwi. ");
INSERT INTO upv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ko renge daron mawos nen ko pa Iesu ewer ore ni, owrai tevi, “Kuplesi sete kupwerai nanu pisan tevi jinibb pisan, ko kupvijuri sel van re Naim On, ko kupasi ji jinibb ne sulsulen san p̃ilesim. Ko kuplai nanu ne sulsulen nga Moses muwrai renge nale nesesreien sen tevi ni. Suri kumwokwok pa.” Ko ni elinglingi evel. ");
INSERT INTO upv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Evel van ko etipatun osupsup̃e limjer, etewijreni nanu nga elep. Ko ololi Iesu setemun orongwos pivel limjer renge ngaim mun nir, ni elik jer ko pa renge lolo merwer. Ko ngok ololi bbong jinibb ne lat p̃etp̃eti arivivel tweni malume. ");
INSERT INTO upv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nabong evis arasi osuw, mian ko Iesu olwi kele van renge Kapaneam e, ko elik re naim se Pita. Ko jinibb arunge nosp̃en nen nga ni elik renge loloim nen. ");
INSERT INTO upv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ko delung elep aran jin renge loloim; ko loloim setemun evter nir, ko vini vare e kele renge roro metali setemun evter kele. Ko ni ewerwer renge nale nga m̃irres tevir. ");
INSERT INTO upv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ko nir sopor ara-vini vivitu tevi jinibb san nga devje niben mimij; nir ivij arwosi renge maling sen. ");
INSERT INTO upv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ko sete arongwos parini mori ji Iesu, suri jinibb elep p̃elak. Ko arsa van mare renge drru naim, ko arrarre drru naim mare momsawos lat nga Iesu m̃ilik e etp̃ir. Arrarre jile osuw, ko arla dil sopor, ko arile renge maling nga marsale m̃ernen ren, ko arjuröni van ngatan e. ");
INSERT INTO upv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ko Iesu elesi nosurien ser, ko owrai tevi m̃er nga devje niben mimij nen, owra “Natuk, nololien som nir nutlasi twenir pa osuw.” ");
INSERT INTO upv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ko jinibb nevisvisenien ne nale nesesreien sopor arlik ie renge daron nen ko arrorrmi sarrsarre renge nolor, arwera ");
INSERT INTO upv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Erpese m̃erel m̃irij mirpok? Ni erij melmelas ko osopsop̃e pa Atua! Isi orongwos p̃itlasi tweni nololien nir, Atua kobbong esan bbölbböl!” ");
INSERT INTO upv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngavilvilsen Iesu ornge niben nen, orongwose nga nir arrorrmi erpok renge nolor. Ko owrai tevir, owra “Suri sev kami kamrrorrmi nanu ngel nir renge nolo kami nir mirpok? ");
INSERT INTO upv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Evi nanu nga m̃isisarow bbong nga bowrai tevi m̃erel, ‘Nololien som nutlasi tweni pa,’ suri si p̃ilesi poro nuwretun rrek nukrekris kobbong? Ko evi nanu nga m̃iterter kele wor asi ngok nga poro bowra, ‘Kuptur imare kupla milngom ko kupiel van renge naim som e,’ suri jinibb jijle parlesi lelingen poro piplari pirpe nga mowrai ngok. ");
INSERT INTO upv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ko bololi vajin nanu nga m̃iterter nen, puloli kaprongwose kele nga inu Jinibb Mawos derteren suk otoe renge iel ngatan nga b̃etlasi tweni nololien.” Ko ni owrai tevi m̃er nga devje niben mimij, owra ");
INSERT INTO upv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nuwrai tevi nik, Kuptur imare kuplai maling som kupwosi, ko kupiel van renge naim som e.” ");
INSERT INTO upv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ko ni otur mera kasi ngavilvil, ko owosi maling sen ko evel limjer renge nor evan vare e. Ko nir jijle bbösa elair e, ko arsurövi Atua arwera “Sete pa rramlesi nanu san erpe nga ngel tuwi, ejki rres nawon wor.” ");
INSERT INTO upv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ko Iesu evel olwi kele van renge nuwito ne Galili e. Ko jinibb elep aran ji ni, ko ni evisviseni nir. ");
INSERT INTO upv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ko renge daron nga mivel asi, ko elesi Livae natu Alpus elik renge naim ne takis nga mok-majing rengen. Ko owrai tevi ni owra “M̃erel, kupini kupvijurik.” Ko ni otur imare kasi ko evijuri ni. ");
INSERT INTO upv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Musuw vajin ko vitunen daron nga m̃ilik renge nanen m̃iaan, ko jinibb elep nga marok-la nevöt ne takis, ko jinibb nga marok-loli nololien nga marsij nir nga marwirr twenir arlik tevi, ko jinibb sen kele wor nir, ko nir elep kele wor nga marvijuri. ");
INSERT INTO upv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ko jinibb ne nevisvisenien ne nale nesesreien nga marivi Parasi sopor arlesi esij ko arlolar e. Ko aran arlesi jinibb se Iesu nir, ko arwor suri Iesu tevir, arwera “Erpese ni aan ko eminmin tevi jinibb nga marok-la nevöt ne takis ko jinibb nga marok-loli nololien nga marsij nir!” ");
INSERT INTO upv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Daron nga Iesu murnge nale ser ngok e ko owrai tevir owra “Nir nga marres sete armerreni dokta, ko nir nga bbong marmesi ko armerreni dokta. Erpok ko, inu sete nuvini tweni beveruse nir nga marok-wera tetajer nga nir lweni marres, ejki, ko nuvini tweni bbong beverus nir nga sete markerkeris, ko marwer limjere nga marsij.” ");
INSERT INTO upv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon jinibb sen nir ko jinibb se Parasi nir arvil. Ko jinibb sopor arlesi, ko arini ji Iesu ko arwerai tevi, arwera “Suri sev Jon jinibb sen nir ko Parasi nir jinibb ser nir marvil, ko nik jinibb som sete marvil?” ");
INSERT INTO upv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ko Iesu owrai tevir, owra “Orongwos jinibb nga mutotko selen parvil daron nga m̃ilik malum tevir e? Daron nga m̃ilik malum tevir e, ngok sete arongwos parvil. ");
INSERT INTO upv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mian ko nabong nen nir para-vini vajin, ko para-tekai tweni jir; ko ngok ko, nir para-runge p̃isij ko para-vil ko renge nabong nen nir. ");
INSERT INTO upv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ko erpok kele sete jinibb san orongwos p̃ila kalek nga mimerr ko puwol ore lat nga m̃imarrerr e renge sunsun tera, ko p̃ilile ore rengen. Poro pirpok, ko nga mimerr tia-sakuk ko tia-teri kele kalek nga m̃itra, ko tia-loli lat nga m̃imarrerr tia-lep temijpal. ");
INSERT INTO upv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ko erpok kele, sete jinibb san orongwos pujongjongi norro nga mimerr van renge botel nga m̃itra nga marloli nevlu nanikot e. Poro pirpok, ko norro nga mimerr tut, tuloli nevlu nanikot nga m̃itra tirrerren ko tiap rrerrsi, suri etra p̃elak. Ko norro timejivjiv tisij, ko nevlu nanikot kele tisij. Pirpel ko, norro nga mimerr parlingi ko wor renge nevlu nani nga mimerr mimalum m̃irres.” ");
INSERT INTO upv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mian ko Iesu evel otvi naut ne wit san renge nabong ne Sapat. Eptevi jinibb sen nir, ko jinibb sen nir artipatun arsesri wene wit nir ko arlair arurrurro surseler. ");
INSERT INTO upv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ko Parasi sopor arlesi, ko arwerai tevi ni, arwera “Kuplesi ta! Nir arloli nanu nga sete mumomsawos renge nabong ne Sapat ko!” ");
INSERT INTO upv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ko ni owra lweni tevir, owra “Aro, ejki ma, ko rreknga ma kami sete kameve renge Naul On, nanu nga Numal Devet muloli daron nga nanen ser mijkie, numer m̃iaji ni ko nir nga marlik tevi ni? ");
INSERT INTO upv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ni ean renge Naim On se Atua daron nga Apiata mivi batu jinibb ne sulsulen, ko ela niv nga sete erres renge jinibb nawon parurroi, evi kis bbong se jinibb ne sulsulen ko; ko orroi, ko ni elai kele tevi nir nga marlik tevi ni arurroi kele.” ");
INSERT INTO upv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ko Iesu ewer oti nale sen vajin tevir, owra “Atua elngi Sapat nga p̃ila se jinibb, sete elngi jinibb nga p̃ila se Sapat, ejki! ");
INSERT INTO upv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ko niko erpok ko inu Jinibb Mawos nuvi Numal ne Sapat.” ");
INSERT INTO upv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu olwi kele evan renge naim ne loten. Ko renge loloim ne loten nen, jinibb san nga nevren m̃ikati elik rengen. ");
INSERT INTO upv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ko Parasi sopor armeteni suri ni, poro nga ni puloli m̃er nga nevren m̃ikati nen p̃irres renge nabong ne Sapat; ko ngok nir partor sweri sel san nga parevei ni pian re kot suri. ");
INSERT INTO upv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ko ni owrai tevi m̃er nga nevren devjen m̃ikati nga, owra “Kupini ta iel, kuptur womu iel.” ");
INSERT INTO upv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ko ni owrai tevi nir, owra “Renge devjen ne nale nesesreien, erres nga parloli nanu nga m̃irres renge nabong ne Sapat? Rrek poro pijki, parloli p̃isij? Erres nga parloli jinibb san p̃irres luwi re nabong ne Sapat? Rrek poro pijki, ko parlokloksi jinibb rrek!” Ko nir armurrong. ");
INSERT INTO upv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ko Iesu vajin oklu rrale nir jijle nga martur rrale ni, ko ololarsir ko ornge esij, suri nolor eterter elep erpe nevöt. Ko owrai tevi m̃er nga nevren m̃ikati, owra “Kup̃ete ta nevrem pimetet.” Ko ni ete nevren emetet erres luwi. ");
INSERT INTO upv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ko Parasi nen nir arivare vini vare e, ko arsaro ngavilvilsen aran arkorti tevi jinibb se Erot nir. Ewretun Parasi nir ko jinibb se Erot nir tetajer orok-lololarsi lweni nuru, ko arlik lat sansan vajin, ko arsupsup̃e suri parevji pini Iesu pirpese. ");
INSERT INTO upv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Iesu eptevi jinibb sen nir, arjubbul luwi kele van renge nuwito ne Galili e ngalu. Ko delung nga delung nga milep nga marunge nanu nga marlelep nga ni mok-lolir arinini jin ko arvijuri, nir ne Galili ko nir ne Jutia ko nir ne Jerusalem ko nir ne Itumia, ko nir ne devjen nga muto roroni van Jortan e, ko rrale Taea ko Saeton. ");
INSERT INTO upv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ko Iesu owrai tevi jinibb sen nir nga parwer totoni ngarr drrav san puto terai ni, suri delung elep p̃elak, ko tarlilji ni. ");
INSERT INTO upv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ko ni ololi nir elep pa arres luwi, ko niko nir elep nga marmesi artontonir parini mori arlilji Iesu, arwera parjipari. ");
INSERT INTO upv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ko nem̃in nga marsij nir, daron nga marlesi ni e ko arwajenir van ngatan renge non, ko arkail van mare arwera “Nik kuvi Atua Natun!” ");
INSERT INTO upv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ko ni otortorir, ko ewer orer eterter nga sete parwowra tweni ni tevi jinibb nir parongwose, pijki. ");
INSERT INTO upv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mian ko Iesu otongsa tevi jinibb sen p̃etp̃eti nir van renge botwen nga muwu mare milep san. Ko renge marongen se ni, ni everus nir esngavöl drromon eru (12) arini mori jin, ko otobbtobbue nir. ");
INSERT INTO upv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ko ni everuse nir arwaji aposol, nga parok-pitevi ni, ko ngok pok-konir parok-an parok-werwer. ");
INSERT INTO upv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ela derteren tevir nga parok-oji tweni nem̃in nga marsij nir nga marok-sisilvi jinibb nir parivare. ");
INSERT INTO upv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jinibb nen nir niser le ngel: Saemon nga ni m̃ilngi kele nisen san miwajie Pita, ");
INSERT INTO upv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ko Jemes nga Sepeti natun, ko tasin wor Jon, nga ni m̃ilngi kele nise nuru morwajie Boanejes, nga muwra puwra natu belver (suri orivi jinibb nga morok-verver). ");
INSERT INTO upv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ko Antru ko Pilip ko Bartolemu ko Matiu ko Tomas ko Jemes nga natu Alpus ko Tateas ko Saemon ne Selote (ngok evi pati se lartul nga marmerreni parwirre m̃eri Rom nir), ");
INSERT INTO upv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ko Jutas ne Iskariot nga vitunen pia-tekai kerasi Iesu van renge mijen. ");
INSERT INTO upv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu olwi kele vini renge naim se Pita e. Ko delung elep kele arini korti kele jin, ko ngok ololi setete daron ser otoe, erpok kele re daron ne nanen kele. ");
INSERT INTO upv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ko metka sen arunge, ko arivel tweni parlesi lweni ni; suri jinibb sopor arwera ni elengleng. ");
INSERT INTO upv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ko jinibb ne nevisvisenien ne nale nesesreien sopor arivel renge Jerusalem e vini, ko arwera “Belsipa ko, numal se demij nir, ok-pitpitevi ni nga mok-oji tweni nem̃in nga marsij marok-ivare ngok.” ");
INSERT INTO upv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ko ni everus nir arini jin mori, ko ni owra nale rrongrrongvi sopor tevir, owra “Demij puoji lweni ni pirpese? ");
INSERT INTO upv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ko poro batun vanu san p̃iteri wukari p̃ieru e, ko pulolarsi lweni, ko p̃itre lweni, batun vanu nen setete mia-tur! ");
INSERT INTO upv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ko poro metka san p̃iteri wukari p̃ieru e ko pulolarsi lweni, ko p̃itre lweni, metka nen sete orongwos p̃ilik p̃irres. ");
INSERT INTO upv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ko erpok kele, sete Demij orongwos putur imare p̃itre lweni ni lweni ko p̃iteri wukari p̃ieru e pirpe nga kami kamwerai ngok, suri poro puloli pirpok, ko sete orongwos putur te, suri evan pa renge bongsin ko osuw. ");
INSERT INTO upv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ko erpel ma le: sete jinibb san orongwose pian renge naim se jinibb nga derteren sen mutoe san, ko pulokloksi joron, ejki. Womujnen ni p̃ila dil ko p̃isre totoni m̃er nga derteren sen mutoe ngok ko wor, ko ngok orongwos pia-lokloksi joro m̃ernen ko vajin. Niko inu nuloli tevi Demij renge derteren se Nem̃in On ko. ");
INSERT INTO upv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ko kaprunge nanu kele san: Nuwretun nga nuwretun nuwrai tevi kami, jinibb nir Atua p̃itlasi tweni nololien ser nir ko nale nga marsij ser kele nir nga marok-rij melmelas renger. ");
INSERT INTO upv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ko poro san p̃irij melmelas ko pusopsop̃e Nem̃in On, ngok netlasien nen ejki rres nawone. Ni on renge nololien nga puto tuwi ngok vini.” ");
INSERT INTO upv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Owrai erpok suri nga nir arwera nem̃in nga m̃isij eptevi ni. ");
INSERT INTO upv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mian ko Iesu tasin nir ko tasu sen arivel ko arini ie; ko artur vare, ko arkoni jinibb san evan piveruse loloim. ");
INSERT INTO upv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ko delung elep arlik rrale ni. Ko arwerai tevi ni, arwera “Kuplesi tasu som ko tasim nir artur ngel vare, arpej nik, arwera parlesim.” ");
INSERT INTO upv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ko ni owra lweni tevi nir, owra “Isi evi tasu suk ko isi arivi tasik nir?” ");
INSERT INTO upv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ko ni oklu emteni nir nga marlik rrale ni, ko owrai tevir, owra “Kaplesi tasu suk ko tasik nir, nir le ngel! ");
INSERT INTO upv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Isi nga puloli marongen se Atua, m̃ernen ko evi tasik ko jojik ko tasu suk.” ");
INSERT INTO upv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ko Iesu evisviseni kele jinibb nir renge jeli nuwito ngalu, ko delung elep nga elep arini korti jin. Ko ni esa asi van renge drrav san e ko esakel rengen. Ko jinibb sen nir arsoni tweni drrav, esal van ngalngalu sopon, ko delung jile nir arlik jer ngaut renge jeli nuwito. ");
INSERT INTO upv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ko ni evisvisenir e nanu elep renge nale rrongrrongvi. Ko owrai tevir renge nale rrongrrongvi sen, owra ");
INSERT INTO upv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kaprunge ta. Jinibb san nga mok-jijreni jelangin evel van nga p̃ijijreni jelangin. ");
INSERT INTO upv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ko daron nga mok-jijreni jelangin e mirpok, ko sopor arwij asi van renge dan ne sel e, ko numön arow vini ko artasi twenir. ");
INSERT INTO upv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ko sopor kele arwij asi van renge dan ne jerev e, lat nga dan sete mimtul rengen. Ko aretiv pelari ngavilvilsen, suri dan sete emtul. ");
INSERT INTO upv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mian ko daron nga nial mivini muwosput mare e, ko armeli, suri lap̃er ejkie, ko armaob. ");
INSERT INTO upv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ko sopor kele arwij asi van renge lolo moku e; ko moku armaur imare ko arejal tevtevnir, ko sete arongwos parwen. ");
INSERT INTO upv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ko sopor ma sete arwij lingi dan nga m̃irres nen, armatur jer rengen, ko aretiv, armaur, ko arwen. Sopor wener ejpari ngavöl itul (30), ko sopor wener ejpari ngavöl ouwon (60), ko sopor wener ejpari ongut vesan (100).” ");
INSERT INTO upv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ko ni owrai tevir, owra “Isi nga boron otoe, purnge re nolo boron!” ");
INSERT INTO upv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ko renge daron nga Iesu m̃isan vajin e, ko lartul nga marlik tevi ni ko jinibb sen wor nir esngavöl drromon eru arsusi nale rrongrrongvi nen nir tevi ni. ");
INSERT INTO upv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ko ni owrai tevir, owra “Kami ko ma, Atua elai momsawos nanu nga marto silveni renge batun vanu sen tevi kami. Ko nir nga marlik renge vare nir, nanu jile arlai tevir renge nale rrongrrongvi. ");
INSERT INTO upv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Niko Naul On owrai owra ‘parlesi ko parlesi lululweni, ko sete parlesi wose. Parunge ko parunge lululweni, ko sete parongwose. Suri nolor eterter ko armusus nolor pulululwi, ko arwera ‘Rratrongwose ko rratmetutu, ko rratrieni lweni nolorr tululwi, ko Atua titlasi tweni nololien se kerr suri!’” ");
INSERT INTO upv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ko ni owrai tevir, owra “Kami kamrrerrlenge nale rrongrrongvi nga mowrai ngok ko? Ko poro pirpok ko poro nga bowra nale rrongrrongvi m̃inij kele sopor, ko kami kaprongwose pirpese? ");
INSERT INTO upv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","M̃er nga mok-jijreni jelangin ngok, erpe m̃er nga mok-werwer renge nale se Atua ko. ");
INSERT INTO upv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dan ne sel osorsan tevi nir nga ngel le, nga marunge nale se Atua ko marloli nolor m̃iterter nga marmusus parunge ko parlingi renge nolor. Niko muloli ngavilvilsen Demij mivini m̃iteseni luwe nale se Atua renge nolor. ");
INSERT INTO upv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ko dan ne jerev erpe nir nga ngel le, nga marunge nale se Atua nga mivitan, ko arir lengleng e ko arlai ngavilvilsen. ");
INSERT INTO upv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ko lap̃er sete artoe renge nolor; arlik beblen bbong, mian ko daron nga nat m̃ikarkar renger e suri nale ne batun vanu se Atua, ko marojir suri, marloli m̃isij tevir suri, ko nolor arvitan arvesane. ");
INSERT INTO upv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ko nir m̃inij nen nir arirpe jelangin nga miwij van renge lolo moku. Nir ngel ko arivi lartul nga marmurronge nale, ");
INSERT INTO upv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ko arrorrmi p̃elak nanu ne iel ngatan nir, rrek nijor ervei norrorrmien ser, rrek nolor arvenae nanu elep kele. Ko nanu ngok ko nir arejal tevtevni vajin nale ne batun vanu se Atua nga morrongrrongvi re jelangin nga mivitan re nolor, ololi sete wener otoe rragrrag. ");
INSERT INTO upv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ko jelangin sopor nga marvitan van renge dan nga m̃irres nen e arsorsan tevi nir nga marunge nale ko martori renge nolor, ko arwen. Sopor wener ngavöl itul (30), ko sopor wener ngavöl ouwon (60) ko sopor wener ongut vesan (100).” ");
INSERT INTO upv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ko Iesu owrai kele tevi nir, owra “Daron nga kumla laet vini e, sete orongwos kupla twenie nga kuptawi ore besin e, ko sete orongwos kuplingi renge melve maling, ejki. Ko kuplingi ko wor renge milngen mawos. ");
INSERT INTO upv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ko erpok ko, sete nanu san orongwos piteptepi; pian ko pia-to limjer kobbong. Rreknga nanu tama san nga parsilveni puto teptepi, ejki rres nawon! Nanu jile parpelari p̃etp̃eti ko wor renge moron. ");
INSERT INTO upv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Isi nga boron otoe, purnge re nolo boron!” ");
INSERT INTO upv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ko ni owrai kele tevi nir, owra “Nale ngok nga kamok-murrong nir ngok, kaprrorrmir ko wor, ko kamrongwos kaplair pusorsan tevi nga kamok-p̃elak m̃iterter suri. Ko Atua p̃ila norongwosien mare nen kele tevi kami. ");
INSERT INTO upv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","M̃er nga murnge ko murrul totoni, m̃ernen para-lai kele ko wor tevi ni. Ko m̃er nga murnge ko sete murrul totoni, m̃ernen para-lai tweni jin norongwosien sen beblen nga ni murongwos wowomue pa.” ");
INSERT INTO upv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ko Iesu owrai tevir, owra “Batun vanu se Atua erpel le. Jinibb san ok-jijreni jelangin renge orsel san. ");
INSERT INTO upv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Musuw ko ean vajin elelea nawon, setemun orrorrmi suri renge nutrin ko nutpong, ejki mun. Jelangin etiv pelari esan. Ko emra elep vajin, ko m̃ernen sete orongwose rragrrage suri erpese. ");
INSERT INTO upv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dan esan kobbong ololi ewen. Womujnen elngi nowsen mian ko nevngun, mian ko elngi wenen jile vajin. ");
INSERT INTO upv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ko daron nga wenen m̃itra m̃irres mimirr vajin, ko m̃er nga ela nesip ko ean eta tutweni vajin, suri evi daron ne numös vajin.” ");
INSERT INTO upv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ko Iesu owrai tevi jinibb nir, owra “Kerr purrongrrongvi batun vanu se Atua pirpese? Rreknga renge nale rrongrrongvi sev rraploli piplari limjer p̃irres rengen? ");
INSERT INTO upv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Rraprrongrrongvi pirpel le: Jinibb san ela jelangi nubek san ko orwi. Jelangin nen ewelili nga ewelili jer lingi jelangi nai jijle nir. ");
INSERT INTO upv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ko daron nga murwi jile ko mietiv pelari vajin, ko emra elep van mare e, ko easi p̃etp̃eti nai nga ngok nen nir. Ko emeseksek, rengsin nir arlelep arsalsal van ngasu jer. Ko numön esaut arinini ren, arok-loli menur renge rengsin nir, ko arok-molmol re melven.” ");
INSERT INTO upv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu ela nale rrongrrongvi lele elep kele nga marirpok nir tevi jinibb nir, osorsan tevi nir marongwos parongwose. ");
INSERT INTO upv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ni ok-visviseni nir renge bbong nale rrongrrongvi ko. Ko daron nga Iesu nir jinibb sen kis vajin marsan, ko owra suri nale rrongrrongvi nga nir lat nga marto suri vajin. ");
INSERT INTO upv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Renge nabong nen malum, renge daron nga nat mirivriv vini, ko Iesu owrai tevi jinibb sen nir owra “Kerr puwlu van renge devje nuwi e.” ");
INSERT INTO upv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ko arivel arlinglingi delung nir artur jer, ko arengeni ni renge drrav eptevir, drrav nga pa ni m̃isakel ko rengen. Ko drrav m̃inij kele sopor arpitevi drrav nen. ");
INSERT INTO upv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ko mian ko sete epriv ko ling serser nga milep san etwut vini. Ko daptap arwowosi elep, arututi drrav ko arjivjivi van renge nolon. Ko natung owun elep renge drrav, ko otomori purron. ");
INSERT INTO upv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ko Iesu ematur pareng pa renge batu drrav vitunen, ematur oulele pilo san. Ko jinibb sen arini ko arwuni tweni, arwerai tevi arwera “E, jinibb nevisvisenien, sete kurrorrmi nga kerr rrapmij?” ");
INSERT INTO upv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ko ni emra otur ko ewer ore ling. Ko owrai tevi nuwi owra “Kupmol kupjire p̃irres!” Ko ling omol omosi evesane, evilvil. ");
INSERT INTO upv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ko ni owrai tevi nir owra “Suri sev nolo kami eririr? Nibeni nosurien se kami?” ");
INSERT INTO upv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ko nir armetutu lengleng, arij vijvij por arwerwerai tevir arwera “Aro, isi le ngel, nga ling ko nuwi kele morosuri ni?” ");
INSERT INTO upv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nir arwolu toku renge devje nuwito momsawos renge sise m̃eri Gerasa nir. ");
INSERT INTO upv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ko daron nga moka-jubbul renge drrav e, ko jinibb san nga nem̃in nga m̃isij m̃isisilvi evel pelari renge dubb e nir vini, evel tersele, esewute. ");
INSERT INTO upv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","M̃ernen ok-lik pa renge lat nga marok-tivtavin e ko, renge dubb nir. Ko setemun jinibb san orongwose p̃isre totoni tevi dil nga marterter e nir, ko dil delrrurr kele nir sete arvitere, ejki mun. ");
INSERT INTO upv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Suri arok-sere totoni tetajer pa nevren ko nuru ko b̃elan nuru tevi dil nga marterter e nir ko tevi dil delrrurr nir, ko ok-rrerrerrsir armotot. Ko niko setemun san derteren sen evtere nga purrul totoni puloli pumu luwi. ");
INSERT INTO upv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ko tetajer, renge nutrin ko nutpong kele nir, ni ok-ivel karkar renge dubb nir ko botwen nir ko ok-kikail ko ok-tevteve nevöt e ni luwi niben nir. ");
INSERT INTO upv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ko daron nga m̃ilesi Iesu mivel malum ngasu wore vini, ko owlu van jin ejipa ngatan jin. ");
INSERT INTO upv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ko ekail van mare temijpal owra “Sev som oto ni le iel, Iesu Atua ne Drromsen Mare Natun? Inu nungonie nik eterter renge Atua, warru sete kuplokloksik!” ");
INSERT INTO upv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Suri Iesu muwra pa “Nik nem̃in nga m̃isij, kupivare lingi morok!” ");
INSERT INTO upv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ko Iesu osusi tevi, owra “Nik nisem si?” Ko ni owrai tevi ni, owra “Inu nisek ko Delung, suri kem elep.” ");
INSERT INTO upv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ko ni ongoni tevi Iesu eterter, nga ni sete puoji tweni nem̃in nga marsij nen nir parivel lingi vanu nen. ");
INSERT INTO upv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ko renge ie, nior b̃erp̃er nga milep san arok-susung bbong mori jeli botwen nen. ");
INSERT INTO upv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ko nem̃in nga marsij nir arngoni tevi Iesu arwera “Kupkoni kem van renge b̃erp̃er ngok nir, nga kem nabsilvir.” ");
INSERT INTO upv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ni elinglingir, ko nem̃in nga marsij arsil ivivare lingi m̃er nga, ko arwolu van arsilvi b̃erp̃er nir; ko arloli batur arlengleng. Ko b̃erp̃er nen nir elep, evi nuvasngavöl varu (2000); ko nir p̃etp̃eti arwolu jubbjubbul mawos nuwito ngatan, ko arow jubbjubbul van renge nuwi, ko arron. ");
INSERT INTO upv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ko lartul nga marok-uwngani b̃erp̃er nen nir arwolu van renge ngaim nga milep ko ngaim nga wewarrang nen mir, arwerai tevi jinibb nen nir. Ko jinibb nen nir arivel tweni parlesi sev nga miplari ngok pa. ");
INSERT INTO upv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ko nir arini ji Iesu. Ko arlesi m̃er nga nem̃in nga marsij milep marsisilvi nga, norrorrmien sen erres luwi, ko ori sunsun, ko elik malum vajin. Ko armetutu vajin. ");
INSERT INTO upv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ko nir nga marlesi mawose nanu ngel miplari arsup̃e suri erres tevir lat nga muto suri, erpese renge ni nga nem̃in nga marsij marsisilvi, ko suri kele b̃erp̃er nir. ");
INSERT INTO upv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ko nir aron tertere Iesu arwerai tevi nga ni pivel lingi vanu ser. ");
INSERT INTO upv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ko daron nga ni m̃isa luwi renge drrav, ko m̃er nga nem̃in nga marsij marsisilvi bonevis nga ongoni tevi Iesu nga ni piptevi ni. ");
INSERT INTO upv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ko Iesu ewer ore owra pijki, ko owrai tevi ni, “Kupluwi van renge naim som e ji metka som nir, ko kupsup̃e tevir erpese nga Numal mimrreni nik, ko nanu nga milep nga muloli tevim.” ");
INSERT INTO upv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ko m̃ernen osri sel sen olwi, ko ospusp̃e vajin limjer renge lat nga marwera Ngaim Esngavöl e, nanu nga milep nen nga Iesu muloli tevi ni. Ngok jinibb jijle daron nga marunge, ko artaole. ");
INSERT INTO upv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu esa kele renge drrav ko arwolu pelaot van renge devje nuwito kele e. Ko daron nga marwolu toku e vajin, ko delung nga milep arini korti jin ngalu. ");
INSERT INTO upv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ko renge iok jinibb san nisen Jaeras nga mok-metmete naim ne loten elesi ni ko evini jin, ejipa ngatan renge b̃elan. ");
INSERT INTO upv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ko on tertere owra “Natuk nesenwarreng otomori pimij. Wurru nungonim kupini kuplingi nevrem rengen, ko vin wel nen p̃irres luwi!” ");
INSERT INTO upv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ko Iesu eptevi ni nuru oran. Ko delung elep arvijuri suri ni ko arlilji ni. ");
INSERT INTO upv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ko nesevin san nga mesien se nesevin nir muloli tetajer e renge sia esngavöl drromon eru, ");
INSERT INTO upv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ko ornge lengleng e esij elep, ewretun elesi dokta elep. Ko olokloksi p̃etp̃eti nevöt sen, ko setete nanu san erres renge ni, ea-runge lengleng ma esij ko. ");
INSERT INTO upv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ko daron nga murnge vajin nanu nga Iesu mulolir, ko esilvi delung nir vitu ko evini morie, ko ejpari sunsun sen. ");
INSERT INTO upv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Suri orrorrmi renge nolon, owra “Poro bbong bejpari bongsi sunsun sen ko ngok inu b̃erres luwi ko pa.” ");
INSERT INTO upv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ko daron mawos nga pa mijpari e ko mete drra emes, ko ornge renge niben nga ni erres pa osuw renge mesien sen. ");
INSERT INTO upv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Renge daron mawos nen Iesu ornge renge niben nga derteren owlu lingi ni, ko erieni ni ko osusi owra “Isi ko mijpari sunsun suk?” ");
INSERT INTO upv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ko jinibb sen nir arwerai tevi, arwera “Po! ko kulesi delung elep arlililjim, ko erpese nik kuwra isi ejparim?” ");
INSERT INTO upv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ko ni okluklu wor emteni rrale nir, owra p̃ilesi isi ko ololi nanu ngel. ");
INSERT INTO upv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ko nesevin nen emtutu ko eririr, orongwose sev nga ni muloli. Ko evini ejipa vitan renge b̃ela Iesu ko owra weretunen nir tevi. ");
INSERT INTO upv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ko ni owrai tevi vinnen, owra “Natuk, nosurien som ololim kumrres. Kupluwi renge demat, kurres ko pa renge mesien som.” ");
INSERT INTO upv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Daron nga m̃irij malum e ko jinibb sopor arivel renge naim se Jaeras vini, ko arwerai tevi Jaeras arwera “Natum nesenwarreng emij pa osuw. Kuplinglingi Numal, setemun kupvijajeng rengen.” ");
INSERT INTO upv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ko Iesu sete ewer suri nale nga marwerai nir, owrai tevi owra “Sete kupmetutu. Sansan kobbong, kuposuri.” ");
INSERT INTO upv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ko ni ewer ore jinibb nir sete san pivijuri, sansan kobbong Pita ko Jemes ko Jon, Jemes wor tasin. ");
INSERT INTO upv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ko nir aran vajin renge naim se Jaeras. Ko Iesu elesi nga nir muwun saut, ko arting vijajeng lengleng, arul temijpal van mare. ");
INSERT INTO upv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ko ni evan loloim, ko owrai tevi nir, owra “Erpese kami kamting vijajeng? Nesenwarreng sete emij, ko ematurrwel kobbong.” ");
INSERT INTO upv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ko nir arunge erij se lenglengen, ko armen keraji e. Ko ejelir aran vare e, ko elai kis bbong tata ko tasu se nesenwarreng ko nir nga marpitevi ni. Ko ni evan renge lat nga nesenwarreng mimatur ren. ");
INSERT INTO upv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ko orrul totkoni nevre nesenwarreng ko owrai tevi owra “Talita kum,” nga muwra mirpel: “Nesenwarreng, nuwrai tevi nik kupmera.” ");
INSERT INTO upv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ko renge daron mawos nen ko pa nesenwarreng emra, ko evivel. Suri sian esngavöl ko pa drromon eru. Ko bbösa nga milep elair e. ");
INSERT INTO upv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ko Iesu ewer ore nga sete parwowrai nanu ngel tevi jinibb pisan purongwose, pijki. Ko owrai tevir nga parlai nanen sopon tevi vin wel nen purroi. ");
INSERT INTO upv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ko Iesu evel lingi lat nen ko olwi van renge ngaim sen e, ko jinibb sen nir arvijuri suri ni. ");
INSERT INTO upv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ko moro nabong ne Sapat mivini, ko ni evan renge naim ne loten ko evisviseni jinibb nir rengen. Ko nir elep armurrarronge ni, ko bbösa elair e ko arwera “M̃erel ela norongwosien ngabe le? Ko ok-loli nanu nga marinijnij nawone nir arirpese le? ");
INSERT INTO upv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kerr rramrongwose kobbong, evi metusu, Merri natun, ko tasin Jemes ko Joses, ko Juta, ko Saemon. Ko sete jojin le nir ngel marpitevi kerr?” Ko arong karkare. ");
INSERT INTO upv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ko ni owrai tevi nir, owra “Weretunen, propet san arongwos parosuri lat jijle nga mian e. Ko jinibb nga ma renge sisen woswos, ko metka sen nir ko niaken sen nir sete mara-osuri p̃elake. Nanu ngok sete erres.” ");
INSERT INTO upv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ko ni sete orongwos puloli nanu san ie. Elngi bbong nevren renge nir nga marmesi evis ko, ololi arres luwi. ");
INSERT INTO upv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ko ni etaole nga sete marosuri. Ko evel evisviseni jinibb nir rrale vanu nen ngaim nen nir. ");
INSERT INTO upv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ko Iesu everus jinibb sen esngavöl drromon eru arini jin, ko elai derteren tevir nga paroji tweni nem̃in nga marsij nir. Ko ni okoni tweni nir ererwi arivel. ");
INSERT INTO upv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ko ni ewer orer, owra “Sete kaptori nanu pisan renge nivelen se kami renge sel, pijki, niv pijki, narr pijki, ko nevöt pijki renge baos kele. Sansan kobbong, kaptori nejipjip pisansan. ");
INSERT INTO upv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ko kaprae but se kami, ko sete kapuri sunsun p̃ieru.” ");
INSERT INTO upv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ko ni owrai kele tevir owra “Naim ngabe nga kami kapan rengen womu ko parevei kami, kaplik ko pa rengen pijpari daron nga kapa-ivel lingi naim nen. ");
INSERT INTO upv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ko poro renge ngaim san jinibb nen nolor p̃iterter, sete parunge kami nga parevei kami van jir, ko ngok, daron nga kapa-ivel lingi ie, erres kapwirrwirrleni tweni maw nga muto re but se kami renge meter nga parlesi, piviseni tevir nga marloli m̃isij.” ");
INSERT INTO upv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ko nir arivel lingi, aran arwerwer tevi jinibb nir nga nolor pulululwi. ");
INSERT INTO upv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ko aroji tweni nem̃in nga marsij elep arivare renge jinibb nir, ko arjivi oel van renge nir elep nga marmesi, ko arlolir arres luwi. ");
INSERT INTO upv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ko Numal Erot Antipas ornge marsup̃e Iesu, suri nisen jinibb jile arunge. Ko nir sopor arwera “Jon Baptaes ko otur imare luwi renge mijen, ko ngok niko majingen nga marlelep ngok arimare renge ni, ko ololi nanu nga marinijnij nawon ngok e nir.” ");
INSERT INTO upv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ko jinibb sopor kele arwera “Ni evi Elaeja,” ko nir sopor kele arwera “Ni evi propet ko, erpe propet ne tuwi san.” ");
INSERT INTO upv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ko Erot daron nga murnge ko owra “Rrek Jon ko nga inu m̃eta otvi batun, otur imare luwi kele renge mijen kele!” ");
INSERT INTO upv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ko Erot Antipas bonevis pa okoni jinibb san evan orrul totoni Jon ko esre totoni elngi renge naim ne nekaien, suri marongen se Erotias nesevin se tuwan Pilip. Suri ni etkai luwe vinnen, ");
INSERT INTO upv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ko Jon owrai tevi Erot, owra “Sete erres nga nik kuptekai luwe nesen se tuwam.” ");
INSERT INTO upv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Niko Erotias esij lengleng tevi Jon, emrreni parevji pini. Ko Erot ewer ore, ");
INSERT INTO upv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","suri emtutue Jon; orongwose nga ni evi jinibb san nga m̃irres, evi jinibb on. Ko emetmete ni erres renge naim ne nekaien. Ko daron nga murnge nale sen, ko eir kobbong renge purnge, ko ornge esij lengleng kele, suri ololi nanu elep. ");
INSERT INTO upv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ko mian ko nabong mawos se Erot evini nga ni puloli dabbuen renge nga ni m̃iak e. Puloli tevi numal sen nir, ko batu jinibb nuval nir, ko batu jinibb ne Galili nir. Ko renge daron nen, Erotias elesi evi daron san nga m̃irres se ni. ");
INSERT INTO upv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ko okoni natun nesen m̃elakel evini loloim ko esew. Ko Erot ko lartul nga marlik tevi renge nanen marlesi, ko arlesi erres p̃elak. Ko numal Erot owrai limjer tevi vinnen owra “Kupngoni tevik isev nga nik kumrreni ko inu b̃elai tevim!” ");
INSERT INTO upv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ko ni ojuji lengleng mare ko owrai tevi vinnen owra “Isev tama san nga poro kupngoni tevik, b̃elai tevim; poro pivi devje vanu suk, ko b̃elai ko wor tevim.” ");
INSERT INTO upv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ko ni ean vare ko osusi tevi tasu sen, owra “Bongoni sev le?” Ko tasu sen owra lweni tevi owra “Kupngoni batu Jon Baptaes.” ");
INSERT INTO upv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Vinnen ewit olwi evel mawose numal ko ongoni tevi owra “Numrreni nik kupla Jon Baptaes batun tevik renge narov.” ");
INSERT INTO upv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ko numal orrorrmi elep suri sev nga ni mimarong pa rengen. Ko suri muloli pa rijrijen sen rengen, ko suri kele nir nga marlik tevi renge nanen nga maraan, nir jile arunge, ngok setemun orongwos pumusus. ");
INSERT INTO upv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ko ni owrai tevi jinibb sen san pian renge naim ne nekaien ko p̃ita otvi batu Jon, ko p̃ila lweni vini. Ko m̃ernen evan, eta otvi jile, ");
INSERT INTO upv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ko esale lweni renge narov vini. Ko elai tevi nesenwarreng, ko nesenwarreng esale elai tevi tasu sen. ");
INSERT INTO upv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ko daron nga Jon jinibb sen nir marunge, ko aran arwosi niben, aran artevni renge dubb. ");
INSERT INTO upv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jinibb se Iesu nir arlulwi vini arlik korti ji Iesu, ko arsup̃e suri nanu jijle tevi ni sev nga marlolir, ko sev nga marvisviseni tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ko ni owrai tevir, owra “Kami kis kobbong kapini, kappitevik kerr pian renge lolo merwer e, ko kapmosi sopon.” Suri iok jinibb arinini jir ko arlululwi, ko ololi setete daron ser otoe, erpok kele re daron ne nanen kele. ");
INSERT INTO upv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ko nir aran renge drrav e arsa rengen, ko arwolu silveni tweni bbong lat san nga mivi lolo merwer. ");
INSERT INTO upv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ko jinibb ne ngaim nen nir arlesir daron nga marwolu e. Ko nir elep arlesi woser, ko arwolu orer kali ngaut e, ko arwowomu renge nir renge lat nen. ");
INSERT INTO upv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ko Iesu nir jinibb sen arwolu toku; ko ni ojubbul, ko elesi delung nga milep nga milep marlik pa. Ko orrorrmi lenglenge nir, suri arirpe sipsip nga jinibb nga muwowomue nir mijkie. Ko ni etipatun evisvisenir e nanu elep. ");
INSERT INTO upv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ko mian ko nat nga mirivriv evini vajin. Ko jinibb sen nir arini jin ko arwerai tevi ni, arwera “Iel evi lolo merwer le, ko nial otomori pa piwaj pini. ");
INSERT INTO upv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kupkoni tweni nir parivel paran renge ngaim nga marlelep nir ko nga wewarreng nir nga ngok nir, ko nir lweni wor parwuli niv, suri nanen nga parurroi ejki.” ");
INSERT INTO upv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ko ni owrai lweni tevir, owra “Kami ko kapla nanen tevir parurroi.” Ko nir arwera lweni tevi, arwera “Ai, merre nevöt ko! Poro pirpok kem naban nabwuli niv e nevöt selva pungut pivaru (200) ko nablai tevir parurroi?” ");
INSERT INTO upv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ko ni owrai tevir, owra “Ko kami kamtori niv evis? Kapan ta kaplesi.” Ko nir aran arlesi, ko arluwi ko arwera “Namtori elim, ko nai eru.” ");
INSERT INTO upv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ko ni owrai tevir nga parloli jinibb nir parlik ngatan renge mösmös nga miejejen, pivi meling pievis e. ");
INSERT INTO upv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ko nir arloli arlik vivöngsur renge meling nir. Meling sopor ongut vesan (100) rengen ko sopor ngavöl elelmi (50) renger. ");
INSERT INTO upv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ko ni ela niv nga elim nga ko ela nai nga eru nga ko esarrerr imare emteni melrin, ko olot erij erres surir. Ko obbri otvi niv nir, ko elai tevi jinibb sen nir, ko nir arlai tevi jinibb nir. Ko ololi kele erpok renge nai. ");
INSERT INTO upv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ko nir jijle arurroi ko nir jijle arup. ");
INSERT INTO upv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ko jinibb sen nir arsere lweni bebje niv nga marurro linglingir ko nai nga marurro linglingir van renge narr esngavöl drromon eru arwun saut er. ");
INSERT INTO upv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ko jinibb nga marurroi niv nen nir, nir evi nuvasngavöl nuvalim (5000) totoklai. ");
INSERT INTO upv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ko Iesu ololi jinibb sen nir arsa van renge drrav parwowomu van renge devje nuwi e renge ngaim ne Betsaeta, daron nga ni pukoni tweni jinibb nir parivel e. ");
INSERT INTO upv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Vitunen renge mukoni tweni jile nir marivel e, ko ni esan vajin evel otongsa van renge botwen nga pulot. ");
INSERT INTO upv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mian ko nat nga mirivriv e vini vajin, ko drrav esal ko pa renge liven mesa renge nuwito. Ko ni esan elik jer ngaut. ");
INSERT INTO upv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ko elesi nga nir marsu marunge m̃isij, suri arsu tere ling. Ko mian ko nat otomori p̃isal p̃irin, ko evan jir, evel renge nuwi. Mian ko evini mori jir, ko ololi erpe owra p̃iasie nir. ");
INSERT INTO upv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ko daron nga nir marlesi nga mivel renge drru nuwi mare, ko arrorrmi rreknga evi nem̃in san, ko arkail lengleng van mare. ");
INSERT INTO upv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nir jijle arlesi ko nolor opotpote elep. Ko ni esaro ngavilvilsen erij tevir, owra “Inu lebbong, nolo kami p̃irres! Sete kapmetutu.” ");
INSERT INTO upv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ko ni esa van mare renge drrav jir, ko ling omol evesane. Ngok ololi bbösa ela nir e elep. ");
INSERT INTO upv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Suri sete arongwose suri nanu nga m̃inijnij nawone nga Iesu muloli re devjen ne niv, norrorrmien ser sete otoe. ");
INSERT INTO upv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ko nir arwolu pelaot kele arini renge vanu ne Genesaret e renge devje nuwito e, ko arile totoni drrav renge lat nen. ");
INSERT INTO upv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ko daron nga maroka-jubbjubbul renge drrav, ko jinibb nga ie nir ngavilvil arlesi wose Iesu, ko arini jin. Ko ni ololi nir elep arres luwi. ");
INSERT INTO upv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ko jinibb nir arwolu p̃etp̃eti renge vanu nen, ko arwosi nir nga marmesi renge maling ser vini jin renge ngabe nga ni m̃ilik e. ");
INSERT INTO upv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ko ngabe nga ni mian rengen, renge ngaim nga welili rreknga ngaim nga milep, arwosi nir nga marmesi van renge maket nir, ko arngoni tevi nga poro bbong parjipari bongsi sunsun sen. Ko nir jijle nga marjipari arres luwi. ");
INSERT INTO upv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parasi nir ko jinibb nevisvisenien ne nale nesesreien arivel renge Jerusalem e vini, arini arlik korti ji Iesu. ");
INSERT INTO upv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ko nir arlesi nga jinibb sen nir nevrer arrokitkit nga marurro niv, sete arjejavöl. ");
INSERT INTO upv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parasi ko m̃eri Isrel nir artori murrun ne jejavölen se b̃irterwarreng ser nir eterter. Poro sete parjejavöl, ko ngok sete paraan. ");
INSERT INTO upv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ko poro parlulwi renge maket vini, ko poro sete parjejavöl ko ngok sete arongwos paraan. Ko nanu elep kele nga martori mirpok, renge marrawe biles minminen ko sospen ko besin ko maling. ");
INSERT INTO upv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ko Parasi nen nir ko jinibb ne nevisvisenien ne nale nesesreien nen nir arsusi tevi ni, arwera “Erpese nga nik jinibb som nir sete marvijuri murru b̃irterawarreng se kerr nir nga tuwi, ko marurroi niv tevi nevrer nga marrokitkit?” ");
INSERT INTO upv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ko ni owrai tevir, owra “Aesea owrai erres kemkam̃e suri kami sel se kami eru, nga muwrai mirpel, muwra ‘Lartul ngel nir arosuri inu tevi nevlu jingor kobbong, ko nolor oto ngasue inu. ");
INSERT INTO upv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Arloto nawone inu. Arvisviseni nevisvisenien nga mivi se jinibb bbong.’ ");
INSERT INTO upv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Erpok ko, kami kamlinglingi kurtweni nesesreien se Atua, ko kamtori murrun ne rijen se jinibb kobbong nir eterter.” ");
INSERT INTO upv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ko ni owrai kele tevir, “Kami kamlinglingi kurtweni jerjere nale nesesreien se Atua, ko kamwera kaptori murrun ne rijen se kami. ");
INSERT INTO upv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Suri Moses owra ‘Kuprrorrmi lilane tata som ko tasu som. M̃er nga m̃irij m̃isij tevi tata sen rreknga tasu sen sete orongwos pimaur, kaprevji pini ko wor.’ ");
INSERT INTO upv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ko kami vajin kamwera ‘Poro nanu san nga moro jinibb san p̃ilai tevi tata sen rreknga tasu sen, ko puwra “Ejki, nanu ngel on, ko evi se Atua,” ");
INSERT INTO upv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ko kami kamwera “Ejki, erres kobbong, setemun mia-lai nanu nen tevi tata sen rreknga tasu sen.” ");
INSERT INTO upv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kamlinglingi kurtweni nale se Atua evi nanu nawon, suri kamtori murrun ne rijen se kami. Ko nanu elep kele nga marirpok nir kamok-p̃elak kamok-lolir.” ");
INSERT INTO upv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ko ni everus kele delung nir arini jin, ko owrai tevir owra “Kapmurrarronge inu p̃irres ko kaprunge nanu nga bowrai ngel: ");
INSERT INTO upv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sete nanu san nga mivel vare e van renge nolo jinibb ololi orro, ejki. Ko nanu nga marpelari ko ma renge nolo jinibb arivi nanu nga marloli jinibb murro. ");
INSERT INTO upv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Poro kami san boron otoe ko purnge re nolo boron!” ");
INSERT INTO upv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ko ni evel lingi delung nir ko evini renge loloim e; ko jinibb sen nir arini jin ko arsusi rongornge nale nen tevi ni. ");
INSERT INTO upv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ko ni owrai tevi nir owra “Kami kele kamlengleng kamirpe nir? Sete kamrongwose nga nanu nga mivel vare van renge nolo jinibb e sete orongwos puloli purro. ");
INSERT INTO upv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Suri sete evan renge nolon, ko evan renge depain kobbong, ko easi tweni.” Owrai erpok nga nanen jijle arres kobbong, sete arongwos parwer ore nanen san puon nga jinibb sete purroi. ");
INSERT INTO upv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ko ni owra kele, “Nanu nga ma mivare ko renge nolo jinibb vini, ngok ko ma ololi jinibb orro rengen. ");
INSERT INTO upv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Suri renge nolo jinibb ko nanu ngel nir marpelpelari, ko norrorrmien nga marsij marivare: Arvevna, arevji pini jinibb, arkerkeris, arwer lokloksi jinibb, arij melmelas ko arsopsop̃e Atua, nolor emrremrreni nanu nir, nolor eleplep, arloli murru lenglengen ser, arloli nolor nga mian mare p̃elak. Ko nesevin arloli murrur nga martori joror nir nga sete marmomsawos re mete jinibb nir, ko norman ean ji nesevin nga sete evi nesen sen, ko nesevin ean ji norman nga sete evi diwen sen. Ko arloli murrun karkar lele nir nga marsij nir. ");
INSERT INTO upv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nanu nga marsij ngel nir arpelpelari renge nolo jinibb vini vare e, ko nir ko arloli jinibb orro.” ");
INSERT INTO upv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mian ko Iesu evel lingi ie, ko evan renge ngaim nga muto mori Taea san. Ko evan renge loloim nen san, ko sete emrreni san purongwose; owra p̃isan p̃ilik. Ko ejki rres nawon, sete orongwos piteptepi. ");
INSERT INTO upv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ko nesenwarreng san, nesevin san natun, nem̃in nga m̃isij san esisilvi. Ko nesevin nga natun nen ornge nga Iesu m̃ilik ie; ko esaro ngavilil van jin, ko evan ejipa van ngatan renge b̃elan. ");
INSERT INTO upv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Vinnen evi nesevin ne vare san, ko eak renge Ponisia, ngaim nga welili ne Siria san. Ko ongoni tevi Iesu nga puoji tweni nem̃in nga m̃isij nen nga m̃isisilvi natun nen, pivare lingi. ");
INSERT INTO upv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ko ni owrai tevi vinnen owra “Nanwarreng paraan parup puwomu, suri sete erres nga parla nanen se bipiwarreng ko parsor tweni tevi guli.” Ni ewirr nale ngok mirpok ngok suri tetajer m̃eri Isrel nir arok-wera “guli” e jinibb ne vare nir. ");
INSERT INTO upv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ko vin nga otuw lweni nale tevi, owra “Erpok ko Numal, ko guli ngok nir nga marmatur renge melve tep ngok nir arok-urrurroi bebje nanen se bipiwarreng sopon!” ");
INSERT INTO upv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ko ni owrai tevi vinnen owra “Suri kumwerai mirpok, ko kupluwi suri sel som, kupiel. Nem̃in nga m̃isij nen eivare pa lingi natum.” ");
INSERT INTO upv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ko daron nga vin nga mulwi vini renge naim sen e, ko elesi nga nem̃in nga m̃isij eivare lingi pa natun osuw, ko natun erres vajin ematur renge maling. ");
INSERT INTO upv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu evel lingi kele Taea ko olwi, ekalie otvi renge Saeton e, evel rrurrngi renge livö ne Ngaim Esngavöl, olwi vini renge nuwito ne Galili. ");
INSERT INTO upv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ko jinibb sopor arpitevi jinibb san nga mivi borwon ko nemen m̃ikel vini jin. Ko nir arngoni tevi ni nga ni p̃ilngi nevren renge m̃ernen ko puloli ni p̃irres luwi. ");
INSERT INTO upv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ko Iesu eptevi tweni m̃ernen lingi delung nir, ko nuru kis orsan ortur talev. Ko ni ojongroni bbös nevren renge nolo boro m̃ernen, musuw ko evrae kele ni luwi wor nevren ko ejpari m̃ernen nemen e. ");
INSERT INTO upv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Musuw, ko eleng raji meten oklu emteni melrin, ko engavsi ko owra “Epata”, nga muwra mirpel, “Borom p̃iap, ko nemem pimtarup!” ");
INSERT INTO upv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ko m̃ernen boron eap ko orngurnge nanu vajin, ko nanu nga m̃isre totoni nemen emtarup lingi; ko ni erij vajin erres. ");
INSERT INTO upv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ko Iesu ewer orer nga nir sete parwerwerai nanu ngel tevi jinibb pisan pijki, ewer ore lenglengen e nir wor rengen. Ko nir armerreni lenglenge wor parwowrai, ko arwowrai tweni; arsupsup̃e vajin elep lengleng. ");
INSERT INTO upv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bbösa nga milep elair ko arwera “Aro, ni ololi nanu elep arres, ololi kele borwon ngel kele nga nemen m̃ikel ngel erres luwi.” ");
INSERT INTO upv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Renge nabong nen nir, delung elep nga elep armot rrale Iesu; ko nanu san ejki nga parurroi. Ko Iesu everus jinibb sen nir arini jin ko owrai tevir owra ");
INSERT INTO upv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nurrorrmi lenglengen e delung ngel nir elep, suri arlik tevik nabong itul le pa, ko sete artori jere mun nanu san nga parurroi. ");
INSERT INTO upv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ko poro bokoni twenir re nga numer m̃iajir mirpok, ko tara-maob renge sel, suri nir sopon arivel wor ngasu ko vini.” ");
INSERT INTO upv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ko jinibb sen nir arwerai lweni tevi ni arwera “Po! Nabla niv ngabe le nga pivtere lartul ngel nir parurroi parup e? Suri iel evi lolo merwer le!” ");
INSERT INTO upv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ko ni osusi tevi nir owra “Ko kami kamtori niv evis?” Ko nir arwera lweni tevi ni arwera “Mmmm...ebut bbölbböl lebbong!” ");
INSERT INTO upv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ko ni owrai tevi delung nir owra parlik ngatan renge dan, ko ni ela niv nga ebut nga nir, ko olot owra erres tevi Atua surir. Ko otpoir ko elair tevi jinibb sen nir, ko jinibb sen nir arselsaler van ji jinibb nir. ");
INSERT INTO upv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ko nir artori nai nga wowarreng sopor, ko ni erij erres kele suri nai nga nir, ko owrai tevi nir parselsaler kele van ji jinibb nir. ");
INSERT INTO upv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ko nir jile arurroi, ko arup. Ko arsersere lululweni bebjen nga marjipon van renge narr ebut arwun saut. ");
INSERT INTO upv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nir totoklai nga marurroi ejpari nuvasngavöl vavij (4000) sopon. Ko ni okoni twenir arivel. ");
INSERT INTO upv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ko esaro ngavilvil esa renge drrav tevi jinibb sen nir, aran devjen e renge Dalmanuta e. ");
INSERT INTO upv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ko Parasi sopor arini ji ni, arwera parrowrrowe ni; arsusi kerkerasi tevi ni, armerreni parlesi nelesien ne melrin san nga ni puloli. ");
INSERT INTO upv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ko Iesu engavsi lenglengen e ko owra “Erpese dul ngel nir arpej nelesien? Nuwretun nga nuwretun lengleng nuwrai tevi kami, sete mara-lai nelesien san tevi dul ngel nir.” ");
INSERT INTO upv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ko ni evel lingir ean kele esa renge drrav aran renge devje nuwito e. ");
INSERT INTO upv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nir armalie parla nanen sopon nga partor mas e, artotori suri bbong niv sansan bbölbböl renge drrav. ");
INSERT INTO upv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ko Iesu osur terter tevir owra “Kapkulkulu metmet p̃irres renge is ne Parasi ko is ne Erot, tulokloksi kami.” ");
INSERT INTO upv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ko nir arwerwera lululweni tevir arwera “Suri kerr sete rramtori niv te, niko muwrai mirpok ngok.” ");
INSERT INTO upv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu orongwose norrorrmien ser ko owrai tevir, “Kamok-werwera lululweni kami e sev ko? Suri sev norrorrmien se kami oto re niv bbong, ko sete kamlesi wose, ko sete kamrongwose? Norrorrmien se kami sete otoe? ");
INSERT INTO upv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mete kami otoe pa, ko sete kamlesi? Boro kami otoe pa, ko sete kamrunge e? ");
INSERT INTO upv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Renge wosenen nga inu motpoi otvi niv elim tevi nir nuvasngavöl nuvalim, ko kami kamsersere lululweni bebjen nga marjijpon van renge narr evis nga marwun saute?” Ko nir arwera “Esngavöl drromon eru.” ");
INSERT INTO upv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ko renge niv nga ebut nga m̃elai tevi nir nuvasngavöl vavij, kami kamsersere lululweni bebjen van renge narr evis arwun saute?” Ko nir arwera “Ebut.” ");
INSERT INTO upv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ko ni owra lweni tevir owra “Ko ngok kami setewor kamrongwose derteren suk?” ");
INSERT INTO upv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu ko jinibb sen nir arini renge Betsaeta, ko jinibb sopor arpitevi jinibb san nga meten murrorr vini ji Iesu, ko arngoni ni nga ni p̃ilngi nevren renge m̃ernen. ");
INSERT INTO upv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ko ni orrul totkoni metrrorr nen nevren ko eptevi tweni renge ngaim van vare e, ko evrae meten e nolton ko elngi nevren nuru rengen. Ko osusi tevi ni owra “Kuleslesi nanu san?” ");
INSERT INTO upv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ko ni okluklu emteni rrale ni, ko owra “Nulesi jinibb nir, nulesir arirpe duru nai arivel.” ");
INSERT INTO upv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ko Iesu elngi kele nevren nuru renge mete metrrorr nen nuru, ko metrrorr emet teretre oklu luwi erres vajin, emteni nanu jijle arres. ");
INSERT INTO upv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ko Iesu owrai tevi ni owra “Kupluwi ko pa van renge naim som e, setemun kupiel limjer re ngaim,” ko okoni tweni. ");
INSERT INTO upv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu nir jinibb sen nir arivel aran renge ngaim jile ne Sisaria Pilipae nir. Ko renge sel ni osusi tevi jinibb sen nir, owrai tevir, “Jinibb nir arwera inu nuvi isi?” ");
INSERT INTO upv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ko nir arwerai tevi ni, “Sopor arwera Jon Baptaes, ko sopor arwera Elaeja, ko sopor arwera propet san.” ");
INSERT INTO upv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ko ni osusi tevi nir kele, “Ko kami, kamwera inu nuvi isi?” Pita owra lweni tevi ni, “Nik kuvi Mesaea nen ko, nga namok-tirive.” ");
INSERT INTO upv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ko Iesu ewer orer owra “Sete kapwerwerai tevi jinibb pisan, pijki.” ");
INSERT INTO upv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iesu etipatun evisviseni jinibb sen nir, owrai tevir nga ni Jinibb Mawos purnge wor p̃isij ko renge nanu pilep lengleng. Ko b̃irterawarreng ko batu jinibb ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir parungasi ni, ko parevji pini. Ko nabong p̃itul ko pimaur luwi. ");
INSERT INTO upv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ni owrai tweni nale ngel limjer, ko niko Pita eptevi taleve ni ko erij terter tevi ko ewer ore ni. ");
INSERT INTO upv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ko ni erieni emteni jinibb sen nir, ko otortori Pita ewer ore owra “Kupini renge durek e, nik Demij! Suri nik sete kurrorrmi nanu nga marivi se Atua, kurrorrmi nanu nga marivi se jinibb bbong.” ");
INSERT INTO upv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ko Iesu everus jinibb sen nir ko delung nir vini jin, ko owrai tevir owra “Poro jinibb san puwra pivijurik, ni putor ore nanu nga ni bbong mimrreni, ko puwosi nai pelaot sen ko pivijurik. ");
INSERT INTO upv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Poro san puwra putor totoni mauren sen, mian ko pia-tor jabble; ko poro nga san pimaronge mauren sen suri mivijuri inu ko suri nosp̃en nga m̃irres, ko mian ko pia-lai vajin mauren nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Poro jinibb pisan p̃ilai p̃etp̃eti nanu ne iel ngatan ngel nir, ko putor jabble mauren sen pijijki, ko p̃ilesi sev ko p̃irres rengen? ");
INSERT INTO upv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jinibb p̃ila isev p̃ikle lweni mauren sen e? ");
INSERT INTO upv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ko isi san poro pimanune inu ko nale suk renge dul nga muloli karkar nanu nga m̃isij ngel, inu kele Jinibb Mawos bemanune ni renge daron nga bea-vini e renge nosrövien se Tata suk tevi anglo on nir.” ");
INSERT INTO upv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ko ni owrai tevi nir owra “Nuwretun nuwrai tevi kami, kami sopon renge kami nga kamtur ngel setewor kapmij, ko kaplesi batun vanu se Atua pivini tevi derteren nen.” ");
INSERT INTO upv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nabong ouwon asi osuw, vitunen ko Iesu etka Pita ko Jemes ko Jon arpitevi ni, nir kis arsan artongsa van renge botwen nga muwu van mare jer san. Maran mare vajin, ko ni niben erieni enij kele e renge nir nor. ");
INSERT INTO upv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ko sunsun sen erinrin ow raprap titis lengleng; sete san renge iel ngatan orongwos puloli kalek pisan puow raprap jipari. ");
INSERT INTO upv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ko renge ie Elaeja ko Moses orpelari limjer jir ko orjiljilwer tevi ni. ");
INSERT INTO upv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ko Pita owrai tevi Iesu owra “Numal, erres kem namlik pa iel! Kem nabloli gorkoraim p̃itul, san pivi se nik, ko san pivi se Moses, ko san pivi se Elaeja.” ");
INSERT INTO upv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ni errerrlenge nanu nga puwrai, suri metutuen nga milep elair, armetutu elep. ");
INSERT INTO upv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ko mian ko nabor san esal vini ko esalsal ore iok; ko renge nabor nen drrelan san eplari rengen, owra “Ngel evi natuk nga memrreni, ko ngok kami kaprunge ni.” ");
INSERT INTO upv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ngavilvilsen arienir arkulkulu pej; ko setemun arlesi san, ejki mun, Iesu kis vajin esan eptevi nir. ");
INSERT INTO upv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ko mian ko renge daron nga marok-jubbul vajin renge botwen vini ngatan e, ko ni ewer orer nga sete parwowra nanu ngel nir nga marlesir ngel tevi jinibb pisan, pian pijpari daron nga Jinibb Mawos pimaur luwi kele renge mijen. ");
INSERT INTO upv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nir artori totoni nale nga muwrai tevi nir kis ngok, ko nir arsususi lululweni tevi nir, “Owra puwra sev ko nga muwra ‘pimaur luwi kele renge mijen’?” ");
INSERT INTO upv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ko nir arsusi tevi Iesu arwera “Jinibb nevisvisenien ne nale nesesreien arsup̃e suri arwera Elaeja pivini ko wor puwomu.” ");
INSERT INTO upv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ko Iesu owra “Ewretun Elaeja pivini ko wor puwomu ko puloli nanu jijle parto p̃irres puwomu. Ko erpese le maruli suri Jinibb Mawos nga nolor pijebreni ni ko ni purnge p̃isij renge nanu pilep? ");
INSERT INTO upv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko inu nuwretun nuwrai tevi kami, Elaeja evini pa osuw, ko nir arloli nanu nga marmerreni tevi ni osorsan tevi nga maruli suri ni e.” ");
INSERT INTO upv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ko daron nga marluwi vajin vini ji jinibb se Iesu e sopor nen nir, ko arlesi nga delung nga milep martur rraler, ko jinibb nevisvisenien ne nale nesesreien marok-susi rongornge nanu sopon tevir. ");
INSERT INTO upv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ko ngavilvilsen daron nga delung markulu sweri ni ko bbösa nga milep elair e, ko arwolu ore aran jin. ");
INSERT INTO upv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ko ni osusi tevi nir owra “Ko kami kamok-susi rongornge sev ko tevi nir iok?” ");
INSERT INTO upv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ko nir san nga renge delung ngok owrai tevi ni, “Numal, nuptevi natuk le ngel pivinuk jim. Nem̃in nga m̃isij esisilvi ko evi nabbut, sete erij. ");
INSERT INTO upv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ko ngabe nga poro piptevi van e ko evivivrrule ko osurrngoni temijpale, ko melabbsen eplari renge jingon, ko orrliw ko erivtet ko aji nisen. Ko nuwrai tevi jinibb som nir nga nir paroji tweni, ko sete arongwos parloli.” ");
INSERT INTO upv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ko Iesu owrai tevir owra “Kami dul ngel sete kamosuri ko! Beptevi kami pijpari seveling? Bornge p̃isij suri kami pijpari seveling? Kaptekai ni pivini jik!” ");
INSERT INTO upv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ko nir arpitevi ni vini jin. Ko moka-lesi Iesu ko nem̃in nga m̃isij evivrrule m̃er wel nen, ko ewajeni ngatan renge dan elilawij, melabbsen eplari renge jingon. ");
INSERT INTO upv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ko Iesu osusi tevi tata se m̃er wel nen owra “Seveling le pa nanu ngel mivini rengen?” Ko ni owra “Renge daron nga mivi malum bipi e ko. ");
INSERT INTO upv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ko momori ok-wajeni van renge nabb ko renge nuwi, owra pok-tor pini. Ko poro nga nik kuprrorrmi kem, ko kurongwos kuploli nanu pisan, kupla se kem!” ");
INSERT INTO upv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu owrai tevi m̃ernen, “E, kuwrai kuwra ‘Poro nik kurongwos kuploli,’ ko sete oto iok ko. Oto wor re nik nosurien som ko. Suri poro kuposuri, ko nanu jijle armalum kobbong renge m̃er nga muosuri.” ");
INSERT INTO upv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ko tata se bipiwarreng esaro ngavilvilsen ekail owra “Nuosuri, kupla se inu nga sete mosuri!” ");
INSERT INTO upv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ko daron nga Iesu m̃ilesi delung marwolwolu vini korti, ko ewer ore nem̃in nga m̃isij, osur terter tevi ni owra “Nik nem̃in ne nabbut ko borwon, kupivare lingi ni, ko sete kupsilvi ni kele!” ");
INSERT INTO upv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ko nem̃in nga m̃isij ekail lengleng, ko evirvireni m̃er wel nen elep, ko esil ivare rengen. Ko m̃er wel nen erpe mimij pa, ololi jinibb elep arwera “O, emij pa!” ");
INSERT INTO upv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ko Iesu ervei nevren, ko esa raji imare, ko m̃er wel nen otur imare. ");
INSERT INTO upv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mian ko daron nga mivini vajin renge naim e, ko jinibb sen nir arsusi silveni tevi ni arwera “Erpese nga kem sete namrongwose naboji tweni?” ");
INSERT INTO upv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ko ni owra lweni tevir owra “Nem̃in nga mirpel ngel, eterter lenglengen nga pivivare. Sansan kobbong, renge verusen.” ");
INSERT INTO upv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ko nir arivel lingi lat nen, ko arivel otvi renge vanu ne Galili. Ko Iesu sete emrreni nga san purongwose. ");
INSERT INTO upv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ko ni evisviseni jinibb sen nir, owrai tevir owra “Jinibb Mawos partekai van renge nevre jinibb nir ko parevji pimij. Ko vitunen renge daron nga marevji mimij e ko nabong p̃itolin vajin, ko ni pia-maur luwi kele.” ");
INSERT INTO upv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ko nir arrelenge nale nga muwrai ngok, ko armetutue nga parsusi lweni tevi ni. ");
INSERT INTO upv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ko nir arini renge Kapaneam, ko aran arlik renge naim se Pita. Ko ni osusi tevi nir owra “Kami kamok-rij latlat lululweni kami renge sel ngok. Suri sev ko?” ");
INSERT INTO upv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ko nir armurrarrong, suri nir arok-rij latlat lululweni tevi nir renge sel suri isi pivi jinibb nga milep jer renge nir. ");
INSERT INTO upv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ko ni esakel ngatan ko everus jinibb sen nen nir esngavöl drromon eru arini jin. Ko owrai tevir, “Poro jinibb pisan puwra pivi jinibb nga milep jer nen, ko ngok ni pia-ivi jinibb nga welili jer nen, pia-ivi jinibb ne majingen ser.” ");
INSERT INTO upv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ko ni etkai bipiwarreng nga welili san ko elngi elik renge liven renge nir, ko owosi esale renge nevren nuru ko owrai tevir owra ");
INSERT INTO upv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Isi nga p̃itkai bipiwarreng nga welili san nga mirpel ngel vini jin renge inu nisek, ko ngok erpe ni etkai inu ko pa. Ko isi nga m̃itkai inu, erpe sete etkai inu ko, ko etkai ni nga mukoni inu ko.” ");
INSERT INTO upv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ko Jon owrai tevi owra “Numal, namlesi jinibb san oji tweni demij renge nik nisem, ko namwer ore, suri nga ni sete evijuri kerr.” ");
INSERT INTO upv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ko Iesu owrai tevi nir owra “Sete kapwer ore ni. Suri sete jinibb san orongwos puloli majingen nga milep renge inu nisek ko putur imare vajin ko p̃irij p̃isij tevi inu. ");
INSERT INTO upv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","M̃er nga sete m̃itre kerr, ni evi kerrkerr ko san. ");
INSERT INTO upv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nuwretun nuwrai tevi kami, Isi nga p̃ilai bbong biles nuwi wel san tevi kami kapmini suri kami kamivi se inu Mesaea, m̃ernen setete mia-tor jabble nowlin. ");
INSERT INTO upv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ko isi san poro puloli bipiwarreng nga ngel nga muosurik ngel san pijilaklak, erres p̃elak poro m̃ernen parruloni nevöt nga milep temijpal san renge nowen ko parjuröni renge dis mot. ");
INSERT INTO upv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ko poro nevrem pulolim kupjilaklak, kuptai otvi; puloli p̃irres p̃elak nga kupasi van re mauren, p̃iasie nga nevrem korti nuru nga pulolim kupan renge lat ne nejijkien, renge nabb nga sete san orongwos pivsi pini. ");
INSERT INTO upv_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naulwij ne lat nen sete arongwos parmij ko nabb nen sete arongwos parvisi pini. ");
INSERT INTO upv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ko poro b̃elam pulolim kupjilaklak, kuptai otvi; puloli p̃irres p̃elak nga kupasi van re mauren, p̃iasie nga b̃elam korti nuru nga pulolim kupan renge lat ne nejijkien, renge nabb nga sete san orongwos pivsi pini. ");
INSERT INTO upv_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naulwij ne lat nen sete arongwos parmij ko nabb nen sete arongwos parvisi pini. ");
INSERT INTO upv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ko poro metem pulolim kupjilaklak, kupwirr tweni; puloli p̃irres rengem nga kupsilvi batun vanu se Atua tevi metem pisansan, p̃iasie nga metem korti nuru nga pulolim kupan renge lat ne nejijkien renge nabb nga sete san orongwos pivsi pini. ");
INSERT INTO upv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Naulwij ne lat nen sete arongwos parmij ko nabb nen sete arongwos parvisi pini. ");
INSERT INTO upv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jinibb jijle Atua purrowrrow nir renge nabb, pusorsan tevi marsuli lesi nevöt mot. Poro nga m̃isij, ko nabb p̃iani pivi niavin. Ko poro nga m̃irres, sete nabb orongwos p̃iani lokloksi. Erpok kele marlingi sol renge nanen nga parunge lesi dilten, dilten erres, rreknga esij. ");
INSERT INTO upv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol erres, ko poro nga sol dilten nga mimelmel pusuw rengen, ko parloli pimelmel luwi pirpese? Kaptori sol renge nolo kami, ko kaploli demat tevi kami sisamis luwi.” ");
INSERT INTO upv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ko Iesu otur imare evel lingi lat nen, ko evini renge vanu ne Jutia renge devjen nga muto roroni van renge Jortan e. Ko delung elep kele arini korti jin, ko ni evisvisenir kele erpe nga momori mok-loli pa. ");
INSERT INTO upv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ko renge ie Parasi sopor arini jin arwera parrowrrowe ni. Ko arsusi tevi ni arwera “Erpese, renge nale nesesreien evi nanu nga m̃irres nga jinibb p̃ilinglingi kurtweni nesevin sen?” ");
INSERT INTO upv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ko ni owrai lweni tevir owra “Ko Moses owra sev ko tevi kami?” ");
INSERT INTO upv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ko nir arwera lweni tevi ni arwera “Moses owra jinibb puli naul nga pukur tweni nesevin sen ko p̃ilai tevi, ko p̃ilngi kurtweni vajin.” ");
INSERT INTO upv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ko Iesu owrai lweni tevir, “Suri nolo kami nga m̃iterter ko, niko muloli Moses muli nale nesesreien ngel nga puwomue kami. ");
INSERT INTO upv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko renge womu jer m̃itipatun, Atua ololi iel ngatan ko nanu jile, ko ‘ololi jinibb eru, norman san ko nesevin san. ");
INSERT INTO upv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ko ngok niko suri mirpel ngel ko, norman pivel lingi tata sen ko tasu sen, pian vajin piptevi nesevin sen. ");
INSERT INTO upv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nuru nga eru ngok porivi vajin niben sansan ko metka sansan.’ Ko ngok niko nuru setemun orivi eru, ko orivi vajin niben sansan ko metka sansan. ");
INSERT INTO upv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sev nga Atua mijipteni kortoni nuru, sete erres jinibb san p̃ila tweni kele.” ");
INSERT INTO upv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Daron nga marlik vajin loloim ko jinibb sen nir arsusi lweni kele nanu nga tevi ni. ");
INSERT INTO upv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ko ni owrai tevir, “Poro isi san p̃ilngi kurtweni nesen sen ko p̃ilesi kele nesevin m̃inij kele san, ngok olokloksi lenglengen e nesevin sen nga womu, ololi butterter sen tevi. ");
INSERT INTO upv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ko poro nesevin p̃ilngi kurtweni diwen sen p̃ilik kele ji jinibb m̃inij san, ni kele ololi kobbong erpok, olokloksi diwen sen.” ");
INSERT INTO upv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ko jinibb sopor arpitevi bipiwarreng sopor vini ji Iesu nga ni p̃ilngi nevren renger. Ko jinibb sen nir artortori nir nga marpitevi nir vini. ");
INSERT INTO upv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ko daron nga Iesu m̃ilesi e ko ololar lengleng, ko owrai tevir, “Kaplinglingi bipiwarreng parini jik, sete kapwer orer te. Suri batun vanu se Atua evi se nir nga nolor marirpe bipiwarreng ngok nir. ");
INSERT INTO upv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nuwretun nuwrai tevi kami, m̃er nga sete puloli nolon pivini pirpe bipiwarreng, ni sete orongwos pia-van renge batun vanu se Atua.” ");
INSERT INTO upv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ko ni erake totoni bipiwarreng nen nir, ko elngi nevren renger, ko erij erres surir. ");
INSERT INTO upv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ko daron nga mivel suri sel, ko jinibb san owlu van jin, ko ejipa jin ngatan, ko osusi tevi ni owra “Numal nga m̃irres, inu bololi sev, ko b̃elai mauren nga muto tuwi ngok vini?” ");
INSERT INTO upv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ko Iesu owrai tevi m̃ernen owra “Erpese nga nik kumwera inu nurres? Sete san erres, Atua kobbong esan. ");
INSERT INTO upv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nik kurongwos pae nale nesesreien se Atua, ‘Sete kuprevji pini jinibb, sete kupvevna, ko sete kupkerasi san kupvenae, ko sete kupvenae nesevin, sete kupkerkeris, kuposuri tata som ko tasu som nuru p̃irres.’” ");
INSERT INTO upv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ko m̃ernen owra lweni tevi Iesu, “O numal, nanu ngel nir nulolir pa renge daron nga mevi nanwarreng malum e ko, mivini mijpari lelingen ngel.” ");
INSERT INTO upv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ko Iesu oklu emteni, ko emrreni elep ko owrai tevi ni, “Nanu sansan kobbong setewor kuloli. Kupan kupwulwule jorom nir ko kuplai nowlir tevi b̃eres nir. Ko nik nowlim puto renge melrin. Ko nik kupini vajin kupvijurik.” ");
INSERT INTO upv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ko ni non eta dan e Iesu muwrai mirpok, ko evel, ornge lengleng esij. Suri ni evi jinibb nga joron milep. ");
INSERT INTO upv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu erieni oklu emteni jinibb sen nir, ko owrai tevir, “Evi nanu nga m̃iterter milep san renge nir nga joror milep paran renge batun vanu se Atua.” ");
INSERT INTO upv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ko nale sen ngok nir bbösa ela jinibb sen e nir, ko arp̃erp̃er nawon. Ko Iesu owrai suri lweni kele tevir owra “Nanwarreng nir, evi nanu nga m̃iterter milep nga san pian renge batun vanu se Atua. ");
INSERT INTO upv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Erpe nato, eterter temijpal renge liwen pietiv. Ko nga jinibb nga joron milep p̃isil asi van renge batun vanu se Atua eterter temijpal wor asie ngok.” ");
INSERT INTO upv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jinibb sen nir arong wonwon nawone nale ngok, bbösa nga milep elair e. Ko arwerwera lululweni tevi nir lweni, “Po! Ko ngok isi le ma orongwos pian renge mauren?” ");
INSERT INTO upv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu emtenir ko owrai tevir, “Renge jinibb evi nanu nga m̃iterter. Ko renge Atua ejki, suri nanu jijle armalum kobbong renge Atua.” ");
INSERT INTO upv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ko Pita etipatun owrai tevi ni, “E, kuplesi kem namlinglingi nanu ngok jile pa nir ko namvijurim vajin.” ");
INSERT INTO upv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu erij weli lweni owra “Nuwretun nuwrai tevi kami, sete jinibb san nga mivel lingi naim sen rreknga tuwan nir ko tasin nir, rreknga jojin nir rreknga tata sen rreknga tasu sen, rreknga natun nir rreknga vanu sen suri inu marongen suk ko nosp̃en nga m̃irres, puwra sete orongwos p̃ila weli nanu nga mivel lingir ngok nir, ejki, ");
INSERT INTO upv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","m̃ernen p̃ila weli pungut ko wor renge daron nga lelingen ngel pivses nir sisamis luwi, metka sen nir ko tuwan tevi tasin nir, ko jojin nir ko tasu sen nir ko natun nir ko vanu sen nir. Ko jinibb parloli p̃isij tevi suri nga muosuri Atua. Ko vitunen vajin pia-lai mauren nga muto tuwi ngok vini. ");
INSERT INTO upv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ko jinibb elep nga lelingenok marwowomu, mian ko parvivitu vajin. Ko elep nga lelingenok marvivitu mian ko parwowomu vajin.” ");
INSERT INTO upv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nir arusri sel artongsa van renge Jerusalem e. Ko Iesu ewit ko owowomue nir ie, ko jinibb sen nir bbösa elair e nga mimawose Jerusalem mirpok, ko jinibb nga marvijurir armetutu. Ko ni eptevi tweni jinibb sen esngavöl drromon eru, ko osp̃e suri nanu nga para-pelari renge ni tevi nir. ");
INSERT INTO upv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Owra “Kaplesi, rraptongsa le pa van renge Jerusalem. Ko partekai inu Jinibb Mawos van ji batun numal ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir. Ko nir parwera erres renge bemij, ko partekai inu van ji jinibb ne vare nir. ");
INSERT INTO upv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ko nir parsopsop̃e inu, ko parverae noltor e inu, ko parvirrvirrali inu, ko parevji pini inu. Ko vitunen renge nabong p̃itolin ko inu bemaur luwi kele.” ");
INSERT INTO upv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jemes ko Jon, Sepeti natun nuru, orini ji Iesu ko orwerai tevi ni, “Numal, komru nomor-marong nga nik kuploli tevi komru sev nga nobor-ngoni tevi nik.” ");
INSERT INTO upv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ko ni owra lweni tevi nuru, “Kamru komor-marong nga inu bololi sev le tevi kamru?” ");
INSERT INTO upv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ko nuru orwera lweni tevi ni, “Komru nomor-marong nga nik kuploli komru tuwen p̃isakel renge nevrem rres, ko komru tuwen p̃isakel renge nevrem mair, renge daron ne nosrövien som.” ");
INSERT INTO upv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ko Iesu owrai tevi nuru, “Kamru sete komor-rongwose sev nga komor-ngoni. Kamru komor-viter kopor-minmin renge biles ne norongen nga m̃isij nga inu beminmin rengen? Rreknga komor-rongwos kopor-paptaes renge baptaesen ne norongen nga m̃isij nga inu bepaptaes rengen?” ");
INSERT INTO upv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ko nuru orwerai lweni tevi ni, “O-o, nomor-viter.” Ko Iesu owrai tevi nuru, “Biles nga inu beminmin rengen, kamru kele kopor-minmin rengen. Ko baptaesen nga inu bepaptaes rengen, kamru kele kopor-paptaes rengen. ");
INSERT INTO upv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ko nga kopor-sakel renge inu nevrek rres ko renge nevrek mair sete evi nga inu b̃elai, evi se nir bbong nga Atua muloli terai nir e ko.” ");
INSERT INTO upv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ko daron nga jinibb sen esngavöl marunge, ko arlolarsi lenglengen e Jemes ko Jon. ");
INSERT INTO upv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu everus nir vini jin, ko owrai tevir, “Kami kamrongwos pae murru jinibb nga marwera marivi numal nga marwowomu renge jinibb ne vare. Nir arwer orer eterter ko arrowrrowe derteren ser renger. ");
INSERT INTO upv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ko kami sete kapirpok. M̃er nga mimarong pivi jinibb nga milep renge kami, ni pivi jinibb ne majingen se kami ko wor. ");
INSERT INTO upv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","M̃er nga pimarong pivi jinibb nga puwomu renge kami, ni pivi demij maur se kami jile ko wor. ");
INSERT INTO upv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngok nuwretun, inu Jinibb Mawos kele sete nuvini nga jinibb parmajing suk, ejki. Ko nuvini ma nga b̃emajing se jinibb nir, ko b̃elai mauren suk pivi nowli jinibb pilep, ko bojri lwenir e.” ");
INSERT INTO upv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ko nir aran Jeriko. Ko daron nga nir jinibb se Iesu marivel lingi Jeriko e, ko delung nga milep arvijurir. Ko Batimeas nga meten murrorr nga mok-ngun-ngun res, natu Timeas, elik renge roro sel. ");
INSERT INTO upv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ko daron nga ni murnge Iesu ne doNasret m̃iasi, ko ekail van owra “Iesu nik metka se Devet, kuprrorrmi inu!” ");
INSERT INTO upv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ko jinibb elep arkail ore ni, arwera ni pip̃erp̃er; ko ni ekail temijpal kele ko owra ‘Nik metka se Devet, kuprrorrmi inu!” ");
INSERT INTO upv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ko Iesu otur murrong, ko owra “Kapverus ni vini.” Ko nir arveruse metrrorr arwerai tevi “Nolom pian ngatan, kupmera! Everus nik.” ");
INSERT INTO upv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ko ni ewirr tweni sunsun ne melas sen, ko otur imare kasi ko evan ji Iesu. ");
INSERT INTO upv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ko Iesu osusi lweni tevi metrrorr owra “Nik kumarong inu bololi sev tevi nik?” Ko metrrorr owrai tevi ni, “Numal, numarong boklu.” ");
INSERT INTO upv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ko Iesu owrai tevi ni, “Kupiel suri sel som ko wor. Nosurien som ololim kumrres.” Ko ngavilvil meten oklu luwi evesane, ko evijuri suri ni renge sel. ");
INSERT INTO upv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Daron nga nir marini mori renge Jerusalem e renge Betpas ko Betani renge botwen ne lolnai ne olip, ko ni okoni tweni jinibb sen eru. ");
INSERT INTO upv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Owrai tevi nuru, “Kopor-mawos renge ngaim nga muto roroni no kamru ngok, ko kopor-lesi natu dongki san niko eati nga jinibb san setewor esakel rrongvi rengen. Kopor-telasi ko kopor-ile vini. ");
INSERT INTO upv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ko poro jinibb pisan puwrai tevi kamru, ‘Erpese komor-loli mirpel?’ Ko kopor-wera, ‘Numal emrreni wor, ko sete mia-periv ko pia-lingi lweni.’” ");
INSERT INTO upv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ko nuru orivel lingi, oran ko orlesi natu dongki nga m̃iati mori renge roro metali vare renge sel, ko ortelasi. ");
INSERT INTO upv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ko jinibb sopor nga martur ie arwerai tevi nuru, “Komor-telasi dali natu dongki ngok suri sev?” ");
INSERT INTO upv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ko nuru orwerai lweni tevir erpe nga Iesu muwrai, ko nir arlinglingi nuru orivel. ");
INSERT INTO upv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ko nuru orile natu dongki van ji Iesu; ko orp̃elseni sunsun se nuru rengen, ko ni esakel rengen. ");
INSERT INTO upv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ko nir elep arp̃elseni sunsun ser renge sel, ko nir sopor arta nablasi nini ko rengsi nai tei raor ko arp̃elsenir renge sel. ");
INSERT INTO upv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ko jinibb nga marwowomu ko jinibb nga marvivitu suri arkail arwera “Osana! Numal Atua, nik kurij pa erres tevi ni nga mivini renge nik nisem. ");
INSERT INTO upv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Neiren renge Batun Vanu nga mivini, batun vanu se tata se kerr Devet. Osana van ji Atua ne drromsen mare!” ");
INSERT INTO upv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Musuw ko Iesu evan renge Jerusalem ko evan renge Naim On se Atua, ko onunri nanu jijle nga marto rrale. Ko nat erivriv vajin, ko ni eptevi jinibb sen esngavöl drromon eru ko arluwi van renge Betani e. ");
INSERT INTO upv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ko renge mevinen vajin daron nga marivel lingi Betani e, ko numer aji Iesu. ");
INSERT INTO upv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ko ni elesi nai pik san otur iokwan, etavös luwi pa, raon otoe. Ko evan mori rengen, owra poro p̃ilesi wenen putoe. Ko moro mivini rengen ko sete elesi nanu san rengen, raon kiskis bbong, suri setewor evi daron nga piwen e. ");
INSERT INTO upv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ko Iesu erij, owrai tevi, “Setemun jinibb san purro kele wenem, renge lelingen ngel ko pa ko tuwi ngok vini.” ");
INSERT INTO upv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nir arini renge Jerusalem. Ko Iesu evan loloim renge Naim On se Atua ko oji tweni lartul nga marwulwule nijor renge Naim On ko lartul nga marwulwulir, ko evatpuse tep se nir nga markelkele nevöt ko nai seksakel se nir nga marwulwule wum̃er nir. ");
INSERT INTO upv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ko ewer ore jinibb nir, sete san puwosi nanu pisan p̃ikali otvi renge live laut ne Naim On e. ");
INSERT INTO upv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ko ni evisviseni nir owrai tevir, “San oli owra ‘Naim suk pivi naim ne verusen se jinibb ne vanu nga musuw ngok.’ Ko kami kamtur imare vajin ko kamloli evi ‘naim ne venao res’!” ");
INSERT INTO upv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Daron nga batu jinibb ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir marunge e, ko arkulkulu pej sel san nga parevji pini ni rengen. Ko armetutu parrul re ni, suri renge nevisvisenien sen delung jile bbösa elair e. ");
INSERT INTO upv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ko renge nat nga mirivriv mivini e ko ni evel lingi ngaim nga milep nen. ");
INSERT INTO upv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ko moro mevinen renge rorpong marvijuri sel marasi renge lat nen, ko arlesi nai pik nga mukur renge drromon ko mijpari renge lap̃en ngatan. ");
INSERT INTO upv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ko Pita orrorrmi jipari nga Iesu m̃irij tevi nai nen, ko owrai tevi ni, “Jinibb nevisvisenien, kuplesi nai pik nga nik kumsur terter tevi nga, okur jile.” ");
INSERT INTO upv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ko Iesu erij owra lweni tevi nir, “Kaplingi nosurien se kami renge Atua. ");
INSERT INTO upv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nuwretun nuwrai tevi kami, Isi san poro puwrai tevi botwen ngel, ‘Kupruj ngasu iok, kupwirr van ngalu e renge dis e,’ ko sete norrorrmien sen p̃ieru e, ko puosuri sev nga muwrai ngok, ko niko nanu nen piplari ko pusorsan tevi nga muwrai. ");
INSERT INTO upv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Niko nuwrai tevi kami, Nanu jile nga kami kamngoni renge kamlot, kaposuri ko wor nga kami kaplair, ko kaplair ko vajin. ");
INSERT INTO upv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ko poro nolo kami p̃isij tevi jinibb pisan, ko renge daron nga kami kamtur e nga kaplot, kaptelasi tweni ni. Ko ngok Tata se kami nga m̃ilik renge melrin p̃itlasi tweni nololien se kami. ");
INSERT INTO upv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ko poro nga kami sete kamtelasi nololien se kami, ko Tata se kami nga m̃ilik re melrin ni kele sete p̃itlasi nololien se kami.” ");
INSERT INTO upv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ko nir arluwi kele vini renge Jerusalem e. Ko daron nga Iesu mok-tutur suri loloim ne Naim On e, ko batu jinibb ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir ko b̃irterawarreng nir arini jin. ");
INSERT INTO upv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ko arwerai tevi ni, “Renge derteren sev nga nik kumloli nanu ngel nir, rreknga isi elai derteren ngel tevim nga kuploli nanu ngel e nir rengen?” ");
INSERT INTO upv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ko Iesu owrai tevi nir, “Inu bosusi kami mun e nale san nile, ko poro kapwera lweni tevik, ko inu bea-wera lweni tevi kami nga renge derteren sev nga inu mololi nanu ngel nir rengen. ");
INSERT INTO upv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Baptaesen se Jon evel renge melrin vini, rreknga evel renge jinibb vini? Kapwerai ta tevik.” ");
INSERT INTO upv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nir arwerwera lululweni tevir arwera “Poro rrapwera ‘Evel renge melrin vini,’ ko ni puwra ‘Ko erpese sete kami kamosuri ni?’ ");
INSERT INTO upv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ko poro rrapwera ‘Renge jinibb,’ ko iok p̃isij re kerr.” Suri armetutue delung nir, suri nir jile artori Jon evi propet weretunen. ");
INSERT INTO upv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mian ko arwera lweni tevi Iesu, “Ia, sete namrongwose.” Ko Iesu owrai tevi nir, “Ko inu kele sete numa-werai tevi kami renge derteren sev le nga inu mololi nanu ngel nir rengen.” ");
INSERT INTO upv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu owra nale rrongrrongvi san tevi jinibb nir, owra “Jinibb san orwi naut ne grep san, ko osi rrale nalut rengen. Ko eli bbulwil san renge lat nen nga jinibb parivel renge grep nir ko suwer p̃iseser van rengen. Ko eli naim san nga muwu mare nga parsa ren ko parkulkulu metmet p̃irres. Ko elai naut nen tevi jinibb sopor nga parmajing rengen, ko ni evel van renge ngaim m̃inij e san. ");
INSERT INTO upv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mianan ko mijpari renge daron mawos nen vajin nga partawe wenen e, ko ni okoni jinibb ne majingen sen san van ji jinibb nga marmetmete naut nga, p̃ilai wenen sopon jir. ");
INSERT INTO upv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ko nir arrul re totoni ni, ko arvirrvirrali, ko arkoni tweni evel kiskis olwi. ");
INSERT INTO upv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ko ni okoni kele jinibb sen m̃inij nen san evan jir; ko nir arla nevöt ko artuwe rrurrngi batun e, ko arloli esij elep tevi, ko arkoni tweni olwi. ");
INSERT INTO upv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ko ni okoni kele jinibb sen m̃inij nen san, ko m̃ernen arevji pini emij. Ko nir elep kele wor nga mukonir van jir, nir sopon arvirrvirralir, ko nir sopor arevji pinir armij. ");
INSERT INTO upv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ko sansan bbölbböl vajin ojpon jer, natun nga mimrreni temijpal nen e. Ni okoni vivitu jere evan jir, owra ‘Nir rreknga parosuri natuk le.’ ");
INSERT INTO upv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ko jinibb nga marmetmete naut nen daron nga marlesi, ko arwerwera lululweni tevi nir, ‘Ngok, natun mawos nga pia-la joro tata sen ko ngok. Kerr pirevji pini, ko naut sen pivi vajin se kerr e.’ ");
INSERT INTO upv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ko arrul totoni ni, ko arevji pini emij, ko arsor tweni van vare e renge naut ne grep nen e. ");
INSERT INTO upv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ngok mirpok ngok, numal ne naut ne grep nen pulwi vini ko puloli sev ko tevir? Ni pivini ko pirevji pinir, ko p̃ilai tevi jinibb m̃inij kele sopor.” ");
INSERT INTO upv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ko Iesu osusi tevir owra “Ia, ko nale nga maruli renge Naul On ngel owra sev le, nga muwra ‘Nabur nga jinibb nga marok-majinge naim marungasi marwirre, niko vajin evi nabur nga murrul totoni naim m̃iterter. ");
INSERT INTO upv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nanu ngel evi nanu nga mivel ji Numal e vini. Ko evi nanu nga mete kerr m̃ilesi taole m̃irres p̃elak.’” ");
INSERT INTO upv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ko nir nga marwowomu re m̃eri Isrel nir arongwose nga ni owra nale rrongrrongvi nga m̃itre nir rengen, ko arwera parrul totoni; ko armetutue delung nir. Ko arlinglingi arivel lingi. ");
INSERT INTO upv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jinibb nga marlelep sopor arkoni Parasi sopor ko jinibb se Erot sopor arini ji Iesu nga parjiljilwer kerkerasi, nga puloli nir partor wos ni renge nale sen. ");
INSERT INTO upv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nir arini jin ko arwerai tevi ni, “Jinibb nevisvisenien, kem namrongwose nga nik komok-weretun; ko sete kuwer suri jinibb san, ko sete kumanun rragrrag renge no san, ko komok-visviseni sel se Atua weretunen. Ngok kupwerai ta tevi kem, evi nanu nga m̃irres renge nale nesesreien se kerr nga rrapwuli takis tevi Sisa, rreknga ejki? Nablai tevi rreknga sete nablai tevi?” ");
INSERT INTO upv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Iesu orongwose nga nir marivel re sel eru, ko owrai tevir, “Suri sev nga kami kamrrowrrowe inu mirpok? Kaplai ta nevöt nen pisan vini jik, nga inu b̃elesi ta.” ");
INSERT INTO upv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ko nir arla nevöt nen san tevi ni, elesi jile musuw, ko owrai tevi nir, “Ko isi le non ngel, ko nisen ngel?” Ko nir arwera lweni tevi arwera “Rrekma Sisa ko.” ");
INSERT INTO upv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ko Iesu owrai lweni tevir, “Nanu nga marivi se Sisa, kaplai lweni tevi Sisa. Ko nanu nga marivi se Atua ko kaplai lwenir tevi Atua.” Ko bbösa elair e. ");
INSERT INTO upv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satusi nir, nga marwera jinibb sete orongwos pimaur luwi kele renge mijen, arini ji Iesu, ko arsusi kerkerasi tevi ni arwera ");
INSERT INTO upv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Jinibb nevisvisenien, Moses oli pa renge naul ne nale nesesreien se kerr erpel: ‘Poro jinibb san tuwan pimij lingi nesen sen, ko natu nuru pijkie, ko ngok m̃ernen tasin p̃itkai kele tuwan nesen sen ko pivesi wani metka se tuwan nga mimij ngok.’ ");
INSERT INTO upv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ngok niko jinibb niaken ebut; ko m̃erwomu nen elesi nesevin san, mian ko emij lingi nesevin nen, ko natu nuru ejkie. ");
INSERT INTO upv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Erwen kele etkai vinnen, ko emij lingi kele, sete natu nuru otoe te ejki. Ko nir itolin kele, ko erpe kele bbong nga womunen nuru. ");
INSERT INTO upv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nir jile nga ebut ngok natur arjikie. Ngok vitunen vajin ko nesevin nen emij kele. ");
INSERT INTO upv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ko ngok mirpok ngok, renge daron nga para-maur luwi kele re mijen, vinnen pivi nir si nen ko nesevin sen? Suri nir niaken nga ebut ngok jile nir artekai. Kupwera suri ta we!” ");
INSERT INTO upv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu owrai tevi nir, “Suri nanu nga eru ngel le, kami kamsarr nga kamsarr lengleng, suri nga sete kamrongwose Naul On rreknga derteren se Atua. ");
INSERT INTO upv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Suri daron nga jinibb nga marmij parmaur luwi renge mijen, setemun norman ko nesevin mora-totko kele, rreknga porleslesi nuru kele, ejki mun. Porlik vajin porirpe anglo ne melrin nir. ");
INSERT INTO upv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ko re devjen ne nga nir nga marmij, nga para-maur luwi kele, ngok kami sete kameve renge naul se Moses renge lat nga marsup̃e suri nai wel san nga muroror, ko nabb sete eani? Renge nai ngok, Atua erij tevi Moses, owra ‘Inu nuvi Atua se Epram, ko Atua se Aesak, ko Atua se Jekop.’ ");
INSERT INTO upv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ni sete evi Atua se jinibb nga marmij te ejki, evi Atua se nir nga marmaur. Suri derteren sen elep nga elep lingi mijen. Iok kami kamsarr nga kamsarr lenglengen ko nga kamok-wera jinibb sete orongwos pimaur luwi kele re mijen.” ");
INSERT INTO upv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ko san renge jinibb nevisvisenien ne nale nesesreien evini, ko omurrarronge nir jile marok-bburbburir e nale, ko ornge nga Iesu okrij welir erres p̃elak. Ko osusi tevi ni owra “Nale nesesreien se Atua ngabes nen evi drromon jer renge nale nesesreien m̃inij nga ngok nen nir nga m̃irres asi nen nga rrapvijuri?” ");
INSERT INTO upv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ko Iesu owra lweni tevi ni owra “Renge nale nesesreien se Atua nga mivi drromsen jer renger erpel, ‘O Isrel, kaprunge Iova Atua se kerr. Ni kobbong esan evi Iova. ");
INSERT INTO upv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ko nik kupmerreni Iova Atua som tevi nolom jile, ko tevi mauren som jile, ko tevi norrorrmien som jile, ko tevi derteren som jile.’ Ngel ko evi nale nesesreien se Atua nga mivi drromon jer, nga m̃iasi nga ngok nen jile nir. ");
INSERT INTO upv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nga surie kele erpel, ‘Nik kupmerreni jinibb nga marlik morie nik pirpe kumrreni lweni nik.’ Setemun nale nesesreien kele san osorsan tevi nga ngel nuru, ejki.” ");
INSERT INTO upv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","M̃ernen owra lweni tevi, “Omomsawos ko, Jinibb nevisvisenien, nik kuwra weretunen. Atua sansan kobbong, setemun san kele, ni kobbong esan rres. ");
INSERT INTO upv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ko nga rrapmerreni ni renge nolo kerr jile ko norrorrmien se kerr jile, ko derteren se kerr jile, ko nga rrapmerreni jinibb nga marlik morie kerr pirpe kerr, ngok erres womu re marsuli nanu tevi Atua.” ");
INSERT INTO upv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ko daron nga Iesu m̃ilesi muwra lweni tevi ni mumomsawos, ko owrai tevi ni, “Nik sete kuruj ngasu rragrrag renge batun vanu se Atua.” Vitunen renge ngel ko setemun jinibb san osusi kele nanu san tevi ni, suri armetutu. ");
INSERT INTO upv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Daron nga Iesu mok-visviseni jinibb nir renge loloim ne Naim On e, ko owrai tevir, “Erpese jinibb nevisvisenien ne nale nesesreien marwera ‘Mesaea evi Devet natun’? ");
INSERT INTO upv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Suri Devet Nem̃in On esilvi ko owra erpel: ‘Numal Atua owrai tevi Numal suk, “Kuplik renge nevrek rres, kuptiriv pijpari nga bololi devje nuval som nir parirpe lat nga kupbböt ren renge nolon b̃elam ngatan.” ’ ");
INSERT INTO upv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devet lweni wor owra ni evi Numal sen, ko ngok ni evi natun erpese ko?” Jinibb elep nga marini arunge ni muwrai mirpok ko arir lengleng ren. ");
INSERT INTO upv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu evisviseni jinibb nir ko owrai tevir, “Kapmetmet renge jinibb nevisvisenien ne nale nesesreien nir, suri nir armerreni paruri sunsun nga marres nga marpepriv partutur tevir, ko delung jile partorir ko parsareni nevrer tevir renge sel. ");
INSERT INTO upv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Armerreni parsakel renge nai seksakel nga muto limjer womu m̃irres renge Naim On, ko erpok kele armerreni parsakel renge nai seksakel nga muto limjer womu m̃irres renge lat ne nanen. ");
INSERT INTO upv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Arivi demij venao, arvenae p̃etp̃eti nijor se nesevin nga diwen ser marmij lingir, ko renge daron ngok ko pa arkerkerasi jinibb nir, arloli verusen nga marpepriv tevi Atua. Ngok Atua putor vitrangi nir pilep suri.” ");
INSERT INTO upv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu esakel renge loloim on se Atua, morie lat nga bokis ne nevöt mutoe. Ko ok-meteni suri erpese nga jinibb marok-tuwe nevöt van renge bokis nen. Jinibb elep nga joror milep artuwe nevöt nga marlelep nir. ");
INSERT INTO upv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ko renge ie, nesevin san nga mivi b̃eres, diwen sen mimij lingi, evini ko otuwe nevöt nga wowarreng eru. Nevöt nga wowarreng nen nuru korti ko evi wan selen ko. ");
INSERT INTO upv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ko Iesu everuse jinibb sen nir arini jin, ko owrai tevir, “Nuwretun nuwrai tevi kami, nesevin nga ngel nga diwen sen mimij lingi ngel, ni otuw nevöt asie nir jijle nga martuwe nevöt van renge bokis nen. ");
INSERT INTO upv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Suri lartul nga ngok nir joror elep, ko arlai bbong beblen ko artuwe, ko artori jere eleplep; ko vinel ma emarong putuw p̃etp̃eti sev nga ni m̃ilngi, nga mivi liken sen p̃etp̃eti.” ");
INSERT INTO upv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Daron nga Iesu mivare renge Naim On se Atua e, ko jinibb sen san owrai tevi owra “Jinibb nevisvisenien, kupmeteni ta nevöt lepel nir, ko naim lepel nir, arinijnij nawone.” ");
INSERT INTO upv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ko Iesu owrai tevi, “Kulesi naim nga marlelep marinijnij nawone ngel e? Mian ko jinibb partingtinge p̃etp̃etir. Setemun nevöt pisan p̃ijnget jer kele renge pisan, nga sete orongwos piwirr pimatur ngatan.” ");
INSERT INTO upv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu oksakel renge Botwen ne lolnai ne olip, ko oklu mawose Naim On se Atua. Ko Pita ko Jemes ko Jon ko Antru arsusi silveni bbong tevi ni, ");
INSERT INTO upv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kupwowrai ta tevi kem, nanu ngel nir para-vini seveling ko? Ko sev ko parivi nelesien nga piviseni nga nanu ngel nir otomori parini?” ");
INSERT INTO upv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ko Iesu owra lweni tevir, etipatun owra “Kapmetmet ko wor, jinibb tarkerkerasi kami. ");
INSERT INTO upv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Suri renge inu nisek nir pilep parini rengen, ko parwera ‘Inu nuvi Kristo le,’ ko parkerkerasi kele nir pilep pirpok. ");
INSERT INTO upv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Daron nga kami kaprunge marval, ko jinibb nir maror e nuval, kami sete kapmetutu. Nanu ngok nir parini ko wor parasi womu, ko bongsi iel ngatan ejki ko wor. ");
INSERT INTO upv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ngaim san putur imare ko pival tevi ngaim san, ko batun vanu san putur imare ko pival tevi batun vanu san. Ko nam̃i p̃im̃i renge vanu lele, ko numer puto renge vanu lele ne iel ngatan, jinibb parmer pilep. Nanu ngel nir arivi bbong batun nga jinibb nolor parrume. ");
INSERT INTO upv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kami kapmetmet wor kami ko p̃irres. Suri partekai kami ko van renge kot ser nir, parwer lokloksi kami. Ko parvirrvirrali kami renge naim ne loten ser, ko kaptur renge no numal nga marwewarreng nir, ko numal nga marlelep nir. Suri kami kapsup̃e inu renge no nir. ");
INSERT INTO upv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Womunen parwerwer mun renge nosp̃en nga m̃irres tevi jinibb jijle nir renge vanu ne ngatan ngel jijle nir. ");
INSERT INTO upv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ko daron nga parevei kami ko partekai kami van renge kot ser, ko sete kapmetutu womu suri sev nga kami kapa-werai. Suri sev nga Nem̃in On pia-lai tevi kami renge mete nial nen, ngok ko kami kapwerai. Suri sete kami kaprij, ko Nem̃in On nga m̃ilik renge kami p̃irij re norrorrmien se kami, ko kami kapwera tweni. ");
INSERT INTO upv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ko niaken p̃itkai niaken sen ko p̃ilngi renge mijen, ko tata p̃itkai natun norman p̃ilngi renge mijen, ko bipiwarreng partur imare ko partere tata ko tasu ser, ko parevji pinir parmij. ");
INSERT INTO upv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ko jinibb jijle nir parungasi kami suri inu nisek; ko m̃er nga putur p̃iterter pijpari bongsin, m̃ernen ko pia-la mauren. ");
INSERT INTO upv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mian ko daron nga kami kaplesi atua se jinibb ne vare nir nga m̃isij nga m̃isij p̃erp̃er parini parsireni putur renge lat nga muon (rrek kami nga kameve kaprongwose kobbong), ko ngok kami nga kamlik renge Jutia kapwolu van renge botwen e nir. ");
INSERT INTO upv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ko nik nga kumlilik vare renge naim som, sete kupluwi kele van renge loloim som nga kupla nanu pisan, pijki, kupwolu ko pa. ");
INSERT INTO upv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ko poro jinibb san pian renge orsel, ko setemun pulwi kele vini renge naim sen nga p̃ila kele sunsun sen; puwlu ko pa. ");
INSERT INTO upv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wurru pia-sij wor niko renge nesevin nga m̃itetaur, ko nesevin nga muloli natun musus renge nabong nen nir. ");
INSERT INTO upv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ko kami kapverus ko wor van ji Atua nga puloli woluen se kami sete puto renge daron ne naus. ");
INSERT INTO upv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nanu nga marsij pilep parini. Nanu nga jinibb nir setewor marlesi meter e nabong san, m̃itipatun renge daron nga Atua muloli iel ngatan e, mivini mijpari lelingen ngel. Ko setemun nanu nga m̃isij pirpel pivini kele renge nabong san, ejki mun. ");
INSERT INTO upv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Numal Atua orrorrmi pa nga pia-ta tweni nabong nga marsij ngel nir; poro pijki, ko sete jinibb san mia-maur. Ko suri orrorrmi nir nga ni mutobbtobbu pae nir, ko niko muloli nabong nen nir sete pilep p̃elak. ");
INSERT INTO upv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Renge nabong nen, poro jinibb pisan pia-werai tevi kami, ‘Kaplesi Mesaea ngel!’, rreknga ‘Kaplesi ngokwan!’, ko sete kaposuri. ");
INSERT INTO upv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pian ko pia-irpok ko wor renge iel ngatan, Mesaea ne gerisen pilep para-tur imare, ko propet ne gerisen nir pilep para-tur imare ko para-viseni nevisenien ko nelesien nga marlelep nir, nga para-kerkerasi jinibb nir ko jinibb se Atua kele nir. Ko sete arvitere para-kerkerasi jinibb se Atua nga mutobbtobbu nir. ");
INSERT INTO upv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaplesi, nuwra wowomue nanu jile le pa ngel nir tevi kami. Ko kami kapkulkulu metmet ko wor p̃irres. ");
INSERT INTO upv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Renge nabong nen nir, nanu nga marsij ngok nir parini parasi p̃etp̃eti pusuw, ko daron nen vajin ‘Ko nial pimot ko navöl sete p̃iser. ");
INSERT INTO upv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ko moju ne melrin nir parvitvitan ngatan, ko nanu nga marterter ne melrin nir paririr.’ ");
INSERT INTO upv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mian ko parlesi ‘Jinibb Mawos pujubbul renge nabor vini’ tevi derteren sen nga milep temijpal ko tevi nosrövien sen. ");
INSERT INTO upv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mian ko ni pia-koni tweni anglo sen nir paran re iel ngatan bongsin ne ivij jijle, tevi lat p̃etp̃eti nir nga melrin m̃isalsal orer. Ko parser kortoni lartul nga ni mutobbtobbue nir vini lat pisansan. ");
INSERT INTO upv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kami kamrongwos pae ko renge daron ne nai nir marok-jur. Daron nga rengsir martengriv luwi nga raor marpelari, ngok kami kamrongwose pae ko nga numös evini mori vajin. ");
INSERT INTO upv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ko pirpok ko, daron nga kami kaplesi nanu ngel nir parini parpelpelari parasi, ko kami kaprongwose nga inu Jinibb Mawos otomori beplari, erpe renge pa roro metali. ");
INSERT INTO upv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nuwretun nuwrai tevi kami, Dul nga ngel nir setewor parmij p̃etp̃eti ko, nir sopor parmaur malum kobbong pijpari nga parlesi nanu ngel nir parpelpelari. ");
INSERT INTO upv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Melrin ko iel ngatan porjijki, ko nale suk ma nir sete mara-jijki. ");
INSERT INTO upv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nabong nen sete jinibb san orongwose, ejki, ko anglo ne melrin nir kele arrelenge. Ko inu kele Jinibb Mawos sete nurongwose te. Tata suk kobbong esan orongwose. ");
INSERT INTO upv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Kami kapkulkulu metmet ko wor p̃irres, suri sete kamrongwose nabong nen. ");
INSERT INTO upv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Suri inu Jinibb Mawos nurpe jinibb san nga mivel lingi naim sen ngok ko, nga mian renge vanu m̃inij san m̃ilik rengen. Ko m̃ilai derteren tevi jinibb sen nir ko m̃ila majingen sisamis tevi nir sisamis. Ko owrai tevi m̃er nga mutur metmet renge metali ni pukulkulu ko wor p̃irres. ");
INSERT INTO upv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pirpok ko, kami kapkulkulu, suri kami kamrrerrlenge daron mawos nga numal ne naim pulwi rengen vini. Pivini renge rivriv rreknga renge nat p̃irrang, rreknga nato pukokrout, rreknga renge rorpong. ");
INSERT INTO upv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","“Kapmetutu tia-luwi tingavil vini, ko tia-lesi kami taka-matur. ");
INSERT INTO upv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ko sev nga mowrai tevi kami, nuwrai kele tevi jinibb jijle, nga parkulkulu ko wor p̃irres.” ");
INSERT INTO upv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nabong eru ma ojpon nga partori nanen ne asien ko nanen ne niv nga is mijki rengen. Ko batu jinibb ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir arpejpej sel san nga parrul venae Iesu rengen ko parevji pini. ");
INSERT INTO upv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ko arwera “Sete rrama-loli renge daron ne nanen, suri jinibb tarkomrönir vini ko tarevji kerr.” ");
INSERT INTO upv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu evan renge Betani ko elik renge naim se Saemon nga bonevis mimsi e mesien nga niber m̃im̃emaul. Ko ni esakel mare ko eaan. Ko nesevin san evini jin, otori botel san nga marloli nevöt e san, nisen arwera alapasta. Renge botel nen senta nga marloli renge nart oto rengen, mapun erres elep ko nowlin elep kele. Ko vinnen obbri botel nen ko ejvi senta nen renge batu Iesu. ");
INSERT INTO upv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ko jinibb sopor arlik ie, ko arlolarsi vinnen suri, ko arwerwerai lulweni tevir, “Owra erpese le, mulokloksi nawone senta ngel. ");
INSERT INTO upv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Poro parwulwule senta ngel ko rrek nowlin pivi nevöt pungut pivatul (300) ko, ko parlai tevi b̃eres nir.” Nir artortori erpok. ");
INSERT INTO upv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ko Iesu owrai tevir, “Kaplinglingi vinok! Erpese kami kamloli ni murnge m̃isij? Ni ololi nanu san nga m̃irres p̃elak renge inu. ");
INSERT INTO upv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kami kamlik tevi b̃eres ngok nir tetajer ko pa, ko poro kapmerreni kaploli nanu san tevir, tetajer kobbong orongwos kaploli p̃irres tevir. Ko inu ma sete mea-lik tetajer tevi kami. ");
INSERT INTO upv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ko vinel evini iel, ololi pa nanu nga ni murongwos puloli ko, ni ejvi senta re nibek owomu etravi daron ne netivtavien suk. ");
INSERT INTO upv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nuwretun nuwrai tevi kami, renge iel ngatan ngabes nen nga paran parwerwer renge nosp̃en nga m̃irres rengen, ie kele nanu nga nesevin ngel muloli tevik parsup̃e suri ren, pivi ni now sen.” ");
INSERT INTO upv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ko Jutas ne Iskariot evan ji batu jinibb ne sulsulen nir nga p̃itkai kerasi Iesu tevir. ");
INSERT INTO upv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Daron nga marunge nale sen nga muwrair tevir, ko arir elep. Ko arloli rijrijen san tevi nga parlai nevöt sopon tevi. Ko ni epejpej daron ngabe ko p̃irres renge ni p̃itkai kerasi tevir. ");
INSERT INTO upv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Renge nabong womu ne niv nga is mijki rengen, nabong nga marevji nanu rrum nga parsulir renge nanen ne asien, ko jinibb sen arsusi tevi ni arwera “Numal, kumarong nga kem naban ngabe le nabloli lilane terai nga nik kuprroi nanen ne asien rengen?” ");
INSERT INTO upv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ko ni owrai tevi jinibb sen eru, “Kamru koporan renge Jerusalem, ko koporsewute jinibb san ie nga muwosi botel nuwi san nga muwun; ko koporvijuri ni. ");
INSERT INTO upv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ko renge naim nga ni pian loloim rengen, kamru koporwerai tevi jinibb ne naim nen koporwera ‘Jinibb nevivisenien owra “Nibeni le loloim ne naim som nga borroi nanen ne asien ren tevi jinibb suk nir?” ’ ");
INSERT INTO upv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ko m̃ernen piviseni tevi kamru naim nen loloim nen nga milep san nga muto mare, nga nanu jile marto pa, marloli lilaner marres ren.” Ko ni okoni tweni nuru orivel oran. ");
INSERT INTO upv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jinibb sen nuru orivel oran renge Jerusalem, ko orlesi erpe nga ni muwrai tevi nuru pa. Ko nuru orloli lilane nanen ne asien oto terai. ");
INSERT INTO upv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Renge nata mirivriv nen ko Iesu evini tevi jinibb sen esngavöl drromon eru. ");
INSERT INTO upv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ko daron nga marsakel marok-aan vajin e, ko Iesu owrai tevir owra “Nuwretun nuwrai tevi kami, kami san ko p̃itkai kerasi inu van renge nevre devje nuval suk nir. Kami san nga kamaan tevik ngel.” ");
INSERT INTO upv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jinibb sen nir arunge lenglenge esij e, ko nir sisamis arsususi sisamise tevi ni, “Isi le? Inu ma ejki!” ");
INSERT INTO upv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ko ni owrai lweni tevir, “Kami ko san renge jinibb suk esngavöl drromon eru nga rramok-rrirri korti renge bol ngel. ");
INSERT INTO upv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Inu Jinibb Mawos bean ko wor renge mijen erpe nga Naul On muwrai suri inu, bemij ko wor rengen. Ko wi p̃isij ko renge m̃er nga p̃itkai kerasi Jinibb Mawos. Erres p̃elak re m̃ernen poro bbong sete p̃iak te pijki.” ");
INSERT INTO upv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ko daron nga nir marok-urrurro ngavilvil nanen sopon, ko Iesu ela niv ko otori. Ko olot owra erres tevi Atua suri, obbri otvi ko esareni tevir, ko owra “Kaplai kapurroi, ngel evi nibek.” ");
INSERT INTO upv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ko ni ela kele biles san, ko daron nga muwra erres jile tevi Atua suri musuw ko esareni tevir, ko nir jijle armini. ");
INSERT INTO upv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ko ni owrai tevir, “Nanu ngel evi inu drrak. P̃iseser suri jinibb pilep, ko puloli rijrijen se Atua putur. ");
INSERT INTO upv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nuwretun nuwrai tevi kami, inu setemun numa-mini kele grep suwen ejki mun, pian pijpari nabong nga ngok nga inu bea-mini vajin nga mimerr renge batun vanu se Atua.” ");
INSERT INTO upv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ko daron nga marla jile nubo san ko arivare arivel van renge botwen ne lolnai ne olip e. ");
INSERT INTO upv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu owrai tevir, “Kami jile nolo kami pivitan suri inu. Suri Naul On owrai owra ‘Mian ko inu berevji pini m̃er nga mok-metmete sipsip, ko sipsip nir parivel sarrsarr.’ ");
INSERT INTO upv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ko vitunen renge inu bemaur luwi kele renge mijen, ko bowowomu renge Galili terai kami.” ");
INSERT INTO upv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita owrai tevi ni, “Rreknga lartul ngok ma nir nolor pivitan, ko inu ma sete nolok mia-vitan te, ejki.” ");
INSERT INTO upv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ko Iesu owra tevi ni, “Nuwretun nuwrai tevi nik, lelingen renge nata mupong ngel puwomu mian ko nato pia-kokrout pivaru, nik kupvilvil orek pivatul, kupwera sete kurongwose inu.” ");
INSERT INTO upv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita osur terter luwi tevi kele owra “Poro bemij tevi nik, ko sete numa-vilvil ore nik!” Ko nir jijle arwera erpok. ");
INSERT INTO upv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ko nir aran renge lat san nga nisen Getsemani. Ko Iesu owrai tevi jinibb sen nir, “Kami kaplik iel daron nga inu bean bolot.” ");
INSERT INTO upv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ko ni ela Pita ko Jemes ko Jon arpitevi ni. Ko ni nolon etipatun ngarr orrum, ornge lengleng esij elep. ");
INSERT INTO upv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ko owrai tevir, “Nolok ornge lengleng esij elep, erpe b̃eap nawone bemij. Kami kaplik iel, ko kapkulkulu metmet.” ");
INSERT INTO upv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ko ni evel rujruj lingir sopon ko esrapo van ngatan, ematur renge dan. Ko olot nga poro Atua orongwos puloli nanu nga renge mete nial nen nir parasi renge ni. ");
INSERT INTO upv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ko ni owra “Apa” (erpe owra “Tata”), “nik kuloli wose nanu nga musuw ngok. Wurru kupla tweni biles ne norongen nga m̃isij ngel renge inu. Ko ejki, sete kuma-loli inu marongen suk, ko kuploli ko wor pirpe nik marongen som.” ");
INSERT INTO upv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ko mian ko ni olwi kele vini jir, ko elesi nir armaturrwel. Ko owrai tevi Pita, “E Saemon, nik kumaturrwel kele? Sete kurongwos kupkulkulu renge mete nial pisansan? ");
INSERT INTO upv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kami kapkulkulu ko wor ko kaplot, nga puloli sete nanu parini parrowrrow p̃elake kami. Nolor armerreni, ko niber armijmij.” ");
INSERT INTO upv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ko ni evel lingir, olwi kele van olot owra malum nale nga muwrair womu. ");
INSERT INTO upv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ko mian ko daron nga mulwi kele vini ko elesir armaturrwel kele, suri meter arruwel. Ko nale nga parwerai tevi ni ejki mun. ");
INSERT INTO upv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mian ko ni evel kele evan olot jile musuw, ko olwi kele vini jir evi vatolin le vajin, ko owrai tevir vajin owra “Erres, kapmaturrwel vajin, kapmosi p̃irres! Evter ko pa! Mete nial nen evini. Kaplesi inu Jinibb Mawos partekai kerasik van renge nevre jinibb nga marsij nir. ");
INSERT INTO upv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kaptur imare, rrapiel van rraplesi m̃er nga p̃itkai kerasi inu evini pa ngel mori.” ");
INSERT INTO upv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Momsawos daron nga m̃irij malum e ko pa ko Jutas, san renge esngavöl drromon eru, evel ngavilvil vini, eptevi meling jinibb nga milep. Artori nesip nuval ko b̃etiluk nir. Arivel ji batu jinibb ne sulsulen nir, ko jinibb nevisvisenien ne nale nesesreien nir ko b̃irterawarreng ne Isrel nir vini. ");
INSERT INTO upv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jutas, m̃er nga m̃itka kerasi ni, elngi pa nale jir osuw, owra “M̃er nga ban jin borromji, ni evi m̃ernen ko. Kaprrul totoni p̃iterter, kapiel tevi.” ");
INSERT INTO upv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mian ko renge daron nga mivini e, ko evel momsawos pa Iesu ko evesane, ko owra “Jinibb nevisvisenien,” ko orromji. ");
INSERT INTO upv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ko nir arrul renge Iesu, arwusi totoni etingtingin. ");
INSERT INTO upv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ko nir nga mutur morie bbong san ela nesip nuval sen ko etai jinibb ne majingen se batu jinibb ne sulsulen san, ko eta vasi boron devjen. ");
INSERT INTO upv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ko Iesu owrai lweni tevir, “Kami kamini tevi nesip nuval ko b̃etiluk nir, ko kamrrul totonik erpe nibb nga mivevna ko mokrevrevji pinpini jinibb nir. ");
INSERT INTO upv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tetajer nomok-lik tevi kami renge Naim On nomok-visviseni, ko kami sete kamrrul totonik te ejki. Ko ngel kamloli mirpel tevi inu nga puloli Naul On piplari.” ");
INSERT INTO upv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ko jinibb sen nir arwolu lingi ni arivel, ko ni otur jer. ");
INSERT INTO upv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ko jinibb m̃elakel san evijuri Iesu, sete ori sunsun te ejki, ela bbong kalek san ko elavlave. Ko sopor arrul ren. Ko arrul rursi, ");
INSERT INTO upv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ko arrul rrawe lavlav sen. Ko ni owlu malmal, owlu lingir. ");
INSERT INTO upv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ko nir arpitevi Iesu van ji jinibb nga mivi drromo batu jinibb ne sulsulen nir. Ko renge ie batu jinibb ne sulsulen nir ko b̃irterawarreng nir ko jinibb nevisvisenien ne nale nesesreien nir arlik korti jin. ");
INSERT INTO upv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ko Pita evivitu suri ngasu jer, ko evan renge lolo naworr nga muwlu ore naim se batu jinibb ne sulsulen nir, ko ni ean elik tevi lartul nga marmajing se drromo batu jinibb ne sulsulen nir. Ko etetli renge nabb nga m̃in. ");
INSERT INTO upv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ko batu jinibb ne sulsulen nir ko nir nga renge gortien ser nga marlik loloim arpejpej jinibb sopor nga parongwos parkerkeris e nga parwera Iesu ololi nanu nga m̃isij san nga parlingi ni renge mijen suri. Ko sete arongwos parlesi san, ");
INSERT INTO upv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","suri ewretun nir elep arsup̃e nale gerisen nir nga martere ni renger, ko nale ser sete arsorsan rragrrag te. ");
INSERT INTO upv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ko mian ko jinibb sopor artur imare ko arwera nale gerisen san van rengen, arkerkeris artere ni rengen, arwera ");
INSERT INTO upv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kem namrunge nga ni owra ‘Inu bea-lokloksi Naim On se Atua nga ngel nga naver muloli, ko nabong p̃itul ko b̃eli lweni m̃inij kele san nga naver san sete pijpari sopon.’” ");
INSERT INTO upv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ko gerisen ser ngok nir kele nga marwerair sete arsorsan, arsisamis p̃etp̃eti. ");
INSERT INTO upv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ko drromo batu jinibb ne sulsulen nir mutur imare livö rer, ko osusi tevi Iesu owra “Erpese nga nik sete kumwera nanu san? Sev le ngel nir lartul ngel nir martere nik surir ngel?” ");
INSERT INTO upv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ko ni ep̃erp̃er nawon, sete owra lweni nanu san. Mian ko drromo batu jinibb ne sulsulen erij kele tevi owra “Erpese? Nik kuvi Mesaea, Atua nga rramok-surövi Natun mawos?” ");
INSERT INTO upv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ko Iesu owra “Inu le. Ko kaplesi inu Jinibb Mawos bea-sakel renge Atua nga derteren sen mutoe nevren rres. Ko bea-luwi re nabor ne melrin vini.” ");
INSERT INTO upv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ko drromo batu jinibb ne sulsulen nir ololar lengleng ko errerrsi sunsun sen, ko owra “Erpese rrappej kele wor sopor nga parwera nale sopor? ");
INSERT INTO upv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kami kamrunge pa nga ni m̃irij melmelas ko musopsop̃e pa Atua! Ko kamrrorrmi erpese?” Ko nir jijle arwera “Ni erres renge pimij ko wor!” ");
INSERT INTO upv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ko nir sopor arverae noltor e ni. Ko nir sopor arsere ore meten ko arlumati ko arwera “Nik kuvi propet! Kupwowrai ta m̃er nga mulmati nik ngok. Isi ko?” Ko batu jinibb ne sulsulen kele jinibb sen nir arvirrvirrali lenglenge ni kele. ");
INSERT INTO upv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Renge naworr nga muwlu ore laut on nen, Pita oklik renge live laut nen. Ko nesevin san nga mok-majing se batu jinibb ne sulsulen nir evini ie. ");
INSERT INTO upv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ko elesi Pita mok-tetli renge nabb ko owrai tevi, “E, sete nik kele kuptevi Iesu ne doNasret ngel?” ");
INSERT INTO upv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ko ni evilvil ore owra “Inu nurrerrlenge, sete nurongwose nanu nga kumwerai ngok!” Ko ni esil ivare renge devji evini vare ko ewit van otur renge metali. Ko nato okokrout vesan. ");
INSERT INTO upv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mian ko nesevin ne majingen nga emteni kele Pita, ko owrai tevi nir nga martur morie ni “M̃erel evi nir le san!” ");
INSERT INTO upv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ko Pita evilvil ore kele eterter. Mian ko vitunen beblen weli ma ko lartul nga martur tevi arwerai tevi Pita, “Ewretun nik kuvi nir san. Nik kuvi m̃eri Galili!” ");
INSERT INTO upv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ko Pita erij otot ojuji lenglengen mare ko owra “Nurrerrlenge m̃erel nga kami kamsup̃e ngel!” ");
INSERT INTO upv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Renge daron mawos ngok ko pa, ko nato okokrout varwen kele. Ko Pita orrorrmi wos nale se Iesu nga muwrai tevi ni, “Daron nga nato setewor pukokrout pivaru e ko, ko nik kupvilvil ore inu pivaru.” Ko ngok daron nga murrorrmi wose, ko ornge esij, ko eting. ");
INSERT INTO upv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Renge rorpong susu, nat murrorrorr malum, ko batu jinibb ne sulsulen nir arevei gortien san. Arkorti tevi b̃irterawarreng nir ko jinibb nevisvisenien ne nale nesesreien nir, ko nir nga renge gortien ser jijle nir. Ko arloli nale san, arwera jinibb sopor paran parsere totoni Iesu, ko parevei van ji Paelet. ");
INSERT INTO upv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ko lartul nen nir aran arevei Iesu vini ji Paelat. Ko Paelat osusi tevi ni owra “Nik kuvi Numal se m̃eri Isrel nir?” Ko ni owrai lweni tevi, “Erpe nga kumwerai.” ");
INSERT INTO upv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ko batu jinibb ne sulsulen nir arwera gerisen elep van renge ni. ");
INSERT INTO upv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ko Paelat osusi kele tevi ni owra “Erpese nik sete kumwerai nanu san tevir? Kuplesi nir arwera nanu elep artere nik renger.” ");
INSERT INTO upv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ko Iesu setemun owra kele nanu san, ejki mun, ko ngok ololi Paelat etaole. ");
INSERT INTO upv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Renge sia jile renge nanen ne asien ngok, Paelat okmaronge jinibb san nga m̃ilik renge naim ne nekaien pivel sisarow, ngok poro parngoni isi tama san tevi ni. ");
INSERT INTO upv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ko jinibb sopor arlik renge naim ne nekaien, suri arevji pini jinibb sopor renge daron nga martur imare ko marval tevi Gavman. Ko san renge nir nisen Barapas. ");
INSERT INTO upv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ko delung nga milep arini ji Paelat ko arngoni tevi ni nga ni puloli tevir pirpe nga tetajer mok-loli. ");
INSERT INTO upv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ko Paelat owrai lweni tevir, “Kami kammarong nga inu borpaji tweni numal se m̃eri Isrel nir tevi kami nga ni pivel sisarow?” ");
INSERT INTO upv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Suri ni ornge renge niben nen, ko orongwose nga batu jinibb ne sulsulen nir arlingi Iesu van renge nevren suri nalol leplep ne lolaren ser kobbong. ");
INSERT INTO upv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ko batu jinibb ne sulsulen nir aron tertere delung nir nga nir parngoni ma Barapas tevi ni nga ni pimaronge tevir. ");
INSERT INTO upv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ko Paelat erij welir kele, owrai tevir, “Ko kami kamwera inu bololi sev tevi m̃er nga kami kamveruse numal se m̃eri Isrel nir?” ");
INSERT INTO upv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ko nir arkail, arwerai eterter kele van mare arwera “Kuprruloni ni renge nai pelaot!” ");
INSERT INTO upv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ko Paelat owra lweni tevir, “Erpese? Ni ololi nanu nga m̃isij sev?” Ko nir arkail kele wor eterter van mare wor, arwera “Kuprruloni renge nai pelaot!” ");
INSERT INTO upv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paelat emrreni puloli nolo jinibb nir parres. Ko orpaji Barapas evel sisarow, ko owrai tevi jinibb nuval sen nir parvirrali Iesu. Ko ni etkai elngi renge nevrer nga parruloni renge nai pelaot. ");
INSERT INTO upv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ko jinibb ne nuval arpitevi tweni Iesu van renge naworr nga muwlu rrale naim se Paelat e nga nisen Praetoriam. Ko arverus kortoni jinibb nuval jile nir arini jir. ");
INSERT INTO upv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ko nir arloli ori sunsun san nga nulsen musongsong mirpe sunsun se numal, ko arjali nuvan moku san erpe nuvan se numal ko arlingi renge batun ori. ");
INSERT INTO upv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ko arij kerkerasi ni arwera “Erres wor, Numal se m̃eri Isrel nir!” ");
INSERT INTO upv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ko arla mavir ko arvirrali batun e, ko arverae noltor e, ko arjipa ngatan jin arlotoe, arsopsop̃e. ");
INSERT INTO upv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ko daron nga marsopsop jile ni musuw, ko arla tweni sunsun sen nga muri nga musongsong ko arla lweni sunsun sen nga mok-uri wor ko arloli ori lweni. Ko arpitevi tweni van parruloni re nai pelaot. ");
INSERT INTO upv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ko renge sel arlesi m̃eri Saerin san nga mivi tata se Aleksanta ko Rupas, ni nisen Saemon. Evini owra pisip asi nir pian ngaim e, ko nir aron tertere ni arwera puwosi nai pelaot se Iesu. ");
INSERT INTO upv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ko nir arpitevi Iesu van renge lat san nga nisen Golkota, nga muwra puwra mirpel, Lat ne bongur. ");
INSERT INTO upv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ko nir arla norro san nga markisi tevi mir nga puloli niben parpurus ko sete purnger parerer. Ko ni sete emni te, ejki. ");
INSERT INTO upv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ko nir arruloni Iesu renge nai pelaot. Ko artutweni sunsun sen evses nir, ko artuw daes suri, arwera parlesi renge nir sisamis ta nir si nen pia-lai. ");
INSERT INTO upv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Evi mete nial esiw renge rorpong nga marruloni Iesu renge nai pelaot. ");
INSERT INTO upv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ko renge niriv nga muto pelaot mare aruli tweni nale san ngel suri nga marevji pini ni: NUMAL SE M̃ERI ISREL NIR. ");
INSERT INTO upv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ko nir arruloni kele jinibb eru nga morok-vevna ko morok-revrevji jinibb orpitevi ni, arruloni tuwen renge nevren rres ko arruloni tuwen nen renge nevren mair e. ");
INSERT INTO upv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ko ngok Naul On evini eplari nga muwrai mirpel, “Ko ni arloli tevi ni erpe jinibb nga m̃isij san.” ");
INSERT INTO upv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ko jinibb nga marasasi renge sel arijrij meten ko arbbölbböleni batur, arwera “Ai! Nik nga le kumwera kuplokloksi Naim On ko nabong p̃itolin ko kup̃ili lweni kele! ");
INSERT INTO upv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kuploli lweni ta nik ta we kupmaur, ko kupjubbul renge nai pelaot ta we, kupini ngatan e!” ");
INSERT INTO upv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Batu jinibb ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir, nir kele arsopsop̃e ni arwerwera lululweni tevir, “Ni okloli jinibb m̃inij nir armaur, ko ni sete bbong ololi lweni ni emaur niko! ");
INSERT INTO upv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Rraplesi ta Kristo Numal se m̃eri Isrel nir pujubbul renge nai pelaot vini ngatan e, ko kerr p̃ilesi ko puosuri ni vajin.” Ko laru nga marruloni nuru tevi ni renge nai pelaot, nuru kele orij esij tevi ni. ");
INSERT INTO upv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Renge levial mawos daron nga nial muwosput e, ko nat emalik renge vanu jijle nir ejpari mete nial itul sopon. ");
INSERT INTO upv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ko renge mete nial itolin nat mirivriv vajin ko Iesu ekail drrelan elep van mare owra “Eloi! Eloi! Lama sapaktani?” nga muwra puwra mirpel “Atua suk Atua suk, erpese kumiel lingik?” ");
INSERT INTO upv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ko jinibb sopor nga martur renge lat nen arunge nale ngok nga ni muwrai ko arwera “Kaprunge, ni everuse Elaeja ko.” ");
INSERT INTO upv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ko jinibb san owlu van ela nalum, ko elngi re venika nga pujm̃i puwun ren ko elai elngi re mavir, ko esareni van mare renge jingo Iesu. Ko owra “Kaplinglingi, rraplesi ta poro Elaeja pivini ko pujri tweni vini ngatan e.” ");
INSERT INTO upv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ko Iesu ekail drrelan elep lengleng ko osrow pini, emij. ");
INSERT INTO upv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ko kalek nga murrul ore lat nga muon renge Naim On eteri renge ngatan ejpari mare devjen erue. ");
INSERT INTO upv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Batun ne jinibb nuval nir otur mawose Iesu non, ko daron nga m̃ilesi ni mimij mirpok, ko owra “Ewretun m̃erel evi Atua Natun.” ");
INSERT INTO upv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nesevin sopor nir Merri korti nuru, Merri ne Maktala ko Merri nga Jemes nga welili, ko Joses tasu se nuru, ko Salome, arok-tur ie ngasu wor sopon. Ko arok-kulu van arok-meteni. ");
INSERT INTO upv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nir arok-vijuri Iesu renge Galili, arok-pitevi ni renge nanu nir. Ko nesevin m̃inij kele wor elep nga marvijuri suri ni vini renge Jerusalem e. ");
INSERT INTO upv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nat erivriv pa vini, nial evan ngatan. Ko suri nabong nen evi nabong nga marok-eseser ren, ko poro nial piwaj pini vajin ko osuw, nabong on ko, setemun san orongwos puloli mun nanu san, niko ");
INSERT INTO upv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep ne Aramatia evan loloim ji Paelat. Sete emtutu te, ongoni tevi nga p̃ilai nibe Iesu. Josep nen evi jinibb san nga nir martori renge gortien ser m̃irres, ko ni kele oktirive nga p̃ilesi batun vanu se Atua pivini. ");
INSERT INTO upv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paelat etaole nga murnge nga Iesu emij pa osuw, ko everuse batun ne jinibb nuval nir vini jin, ko osusi tevi ni owra “Emij pa pareng ko sopon, rreknga?” ");
INSERT INTO upv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ko batu jinibb ne nuval owra “O-o, emij pa parpareng ko sopon.” Daron nga Paelat murnge lilane jile e m̃irres jin musuw ko emarong vajine nibe Iesu tevi Josep pian puwosi. ");
INSERT INTO upv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ko Josep evan owli kalek nga miraprap nga mimalum m̃irres san, ko olwi vini ojri tweni nibe Iesu vini ngatan, ko onb̃e ore kalek nen e. Ko owosi van elngi renge nevöt san nga martai jile pa nolon mutoe, ko eitini nevöt nga milep san oto ore metali nen. ");
INSERT INTO upv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ko Merri ne Maktala ko Merri nga tasu se Joses orlesi lat nga marlingi nibe Iesu rengen e. ");
INSERT INTO upv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mian ko mijpari renge mevinen vajin nat mirivriv, nial ean ewaj pini, ngok Sapat osuw ko vajin, ko Merri ne Maktala ko Merri nga tasu se Jemes ko Salome aran vajin arwuli rao nai sopor nga mapu suwer m̃irres, ngok nga paran parsesei renge ni niben. ");
INSERT INTO upv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mevinen vajin renge rorpong susu malum daron nga nial mia-meraej e renge nabong womu nen ne wik, ko nir armermera tweni paran renge dubb. ");
INSERT INTO upv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Marivel renge sel ko arok-werwera lululweni tevir, “Wurru, si le p̃itini tweni nevöt tevi kerr warreng?” ");
INSERT INTO upv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ko moro markulu tawij imare ko arkulu pej nevöt nga, setemun arlesi, san eitini tweni pa nevöt nga milep temijpal nga. ");
INSERT INTO upv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ko arsil van renge lolo dubb e, ko arlesi m̃elakel san nga muri sunsun nga muow raprap m̃isakel renge devjen nga van re nevrer rres e. Ko armetutu lenglengen e. ");
INSERT INTO upv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ko owrai tevir, “Sete kapmetutu te! Nurongwose kami kampej Iesu ne doNasret nga marruloni renge nai pelaot. Ni ejki iel. Ni emaur luwi pa renge mijen. Kapmeteni ta lat nga marlingi mimatur rengen. ");
INSERT INTO upv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kami kapiel ma kapan, kapwerai tevi jinibb sen nir ko Pita, nga ni puwowomu terai kami renge Galili, ko renge ie kami kapa-lesi ni rengen.” ");
INSERT INTO upv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ko arsil ivare renge dubb ko arwolu lengleng, arwolu lingi, suri aririr ko bbösa evan renger. Ko sete arwera nale san tevi jinibb san. ");
INSERT INTO upv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ko renge rorpong susu renge nabong womu ne wik, daron nga Iesu mimaur luwi renge mijen e, ni eplari womu ji Merri ne Maktala, vin nga nem̃in nga marsij ebut marsisilvi ni ko Iesu muoji twenir ren. ");
INSERT INTO upv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ko vinnen evan ko owrai tevi nir sopon nga marok-pitevi Iesu nga martaur ko marok-tengsi ni marrorrmi. ");
INSERT INTO upv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ko daron nga marunge nga ni mimaur luwi ko Merri m̃ilesi, ko sete arosuri te, ejki. ");
INSERT INTO upv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Vitunen renge ngok, ko Iesu eplari kele ji jinibb eru orlesi ni renge daron nga morivel lingi ngaim. ");
INSERT INTO upv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ko nuru orivel van orwerai tevi nir jijle, ko nir sete arosuri kele nale se nuru. ");
INSERT INTO upv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ko vitunen Iesu eplari kele ji jinibb sen esngavöl drromon san, renge daron nga marsakel maraan e. Ko ni otortorir suri norrorrmien ser sete otoe ko sete marosuri lartul nga marwerai nga marlesi ni mimaur luwi renge mijen. ");
INSERT INTO upv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ko ni owrai tevi jinibb sen nir owra “Kami kapiel kapan renge vanu nga musuw ngok, kapwerwer renge nosp̃en nga m̃irres suk tevi jinibb jijle nga musuw ngok nir. ");
INSERT INTO upv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","M̃er nga muosuri ko mipaptaes, Atua pia-la mauren tevi; ko m̃er nga sete muosuri, Atua pia-tor vitrangi. ");
INSERT INTO upv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nelesien ngel nir parvijuri suri lartul nga marosuri. Renge inu nisek nir paroji tweni demij rengen, ko parongwos parij nale nga marmerr nir. ");
INSERT INTO upv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nir parwosi num̃et ko parmini nuwi nga m̃isij, ko sete purongwos pulolir parmij e. Ko parongwos parlingi nevrer re jinibb nga marmesi, ko jinibb nga marmesi nen nir parres luwi.” ");
INSERT INTO upv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ko daron nga Numal Iesu m̃irij jijle tevir musuw, ko vitunen vajin ko Atua elai Iesu van renge melrin e, ko ni esakel renge Atua nevren rres. ");
INSERT INTO upv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ko jinibb sen nir arivel aran arwerwer renge vanu nga musuw ngok. Ko Numal emajing tevir, ololi nelesien elep nga marviseni nga nale ser evi weretunen. ");
INSERT INTO upv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Selek Teopilas, jinibb elep pa arp̃elak arwera paruli tweni jilweren ne nanu ngel nir nga marpelari ji kerr ngel nir. ");
INSERT INTO upv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Erpe renge womu jer nen, nir arlesi renge meter ko aruli tututweni nale nen nir renge naul, ko arwerair tevi kerr. ");
INSERT INTO upv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ko inu nulesi evi nanu nga m̃irres nga inu kele boli tututweni nale nen nir renge naul tevi nik. Suri inu nomok-meteni suri nanu ngel nir bonevis le wor, ko nurongwos boli surir tevi nik pimawos; ");
INSERT INTO upv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ko puloli nga nik kuprongwose nanu nga marvisvisenir tevi nik arivi weretunen temijpal. ");
INSERT INTO upv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nanu ngel nir arpelari renge daron se Erot, renge daron nga mivi numal renge Jutia e. Ko renge daron nen jinibb ne sulsulen san elik rengen, nisen Sekaraea. Ni evi san renge meling jinibb ne sulsulen se Apaeja. Ko nesen sen Elisapet, ni kele evi metka se Eron san. ");
INSERT INTO upv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nuru korti orivi jinibb nga mormawos m̃irres renge no Atua. Orivel lilane renge nale nesesreien se Atua nir ko nale nesesreien nir. ");
INSERT INTO upv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ko nuru korti ortera pa osuw, sia se nuru elep pa. Ko Elisapet kele evi nesevin nga m̃im̃er, sete evasus, ko ololi natu nuru ejkie. ");
INSERT INTO upv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mian ko ejpari daron se Sekaraea gortien sen nir nga parloli majingen nga jinibb ne sulsulen nir marok-loli renge nabong jile renge Naim On se Atua. Ko ni kele evan. ");
INSERT INTO upv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ko nir arwirr daes erpe murrun se jinibb ne sulsulen nir, nga parlesi nir si nen ko nga pian pusli nanu nga mapun m̃irres renge naworr; ko daes orrum mawos re Sekaraea. Ko ni evan renge loloim on se Atua nga pusulsul. ");
INSERT INTO upv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Delung artur jer vare, parlot renge daron nga nanu nga mapun m̃irres p̃in e. ");
INSERT INTO upv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ko Sekaraea etaole anglo se Iova san errmali jin, ko otur renge nawot van renge devjen rres e. ");
INSERT INTO upv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ko daron nga Sekaraea m̃ilesi, ko nolon opotpot lenglengen e ko emtutu elep. ");
INSERT INTO upv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ko anglo owrai tevi, “Sete kupmetutu, Sekaraea; Atua ornge loten som, ko nesen som pivesi nik natum norman san. Ko nik kuplingi nisen piwaji Jon. ");
INSERT INTO upv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nik kuprunge p̃irres ko kup̃ir pilep daron nga ni p̃iak. ");
INSERT INTO upv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ko ni poro pilep vajin ko pivi jinibb nga milep renge no Numal. Ko sete pimni norro rreknga nuwi nga m̃iterter, pijki. Ni puwun saute Nem̃in On tetajer, p̃itipatun renge daron nga tasu sen pivesi e. ");
INSERT INTO upv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ni puloli m̃eri Isrel nir pilep parieni lweni van ji Iova Atua ser. ");
INSERT INTO upv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ko ni puwowomue Mesaea non renge nem̃in ko derteren se Elaeja, ko p̃irieni lweni tata ser nolor p̃irieni lweni van ji natur, ko parresrres luwi tevir. Ko nir nga sete marosuri parivel vajin renge norongwosien se nir nga marmomsawos, ko puloli lilane jinibb nga martiriv tera Numal nolor p̃irres.” ");
INSERT INTO upv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ko Sekaraea owrai tevi anglo owra “Inu borongwos nanu ngel nir pirpese? Suri inu nuvi b̃irtera pa, ko nesen suk kele sian elep pa osuw.” ");
INSERT INTO upv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ko anglo erij luwi tevi owra “Inu nuvi Gapriel nga motur renge no Atua, ko ni okoni inu nga bowrai tevim nosp̃en nga m̃irres ngel. ");
INSERT INTO upv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ko kuplesi, nik kupivi nabbut, sete kuprongwos kuprij kupwera nale pisan, p̃itipatun lelingen ngel ko pijpari daron nga nanu ngel nir para-pelari e. Suri nga nik sete kuosuri nale suk nir, nga para-pelari renge nabong nen mawos.” ");
INSERT INTO upv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ko renge daron nen artirive Sekaraea, ko arwera “E, erpese nga ni m̃ilik mipriv mirpok renge Naim On se Atua?”, ko ngok ololi bbösa elair e. ");
INSERT INTO upv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Marok-tiriv mian ko ni eivare renge Naim On vini vare e. Ko evi nabbut, sete orongwos p̃irij. Ko ewirrleni nevren tevir; ko nir arongwose nga ni elesi nem̃in san renge Naim On. ");
INSERT INTO upv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mian ko nabong ne majingen sen nir osuw, ko ni olwi van renge naim sen e. ");
INSERT INTO upv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mian ko nabong sete elep mun ko nesen sen Elisapet ejien. Ko ok-lik tepi malume ejpari navöl elim, ko owra ");
INSERT INTO upv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nurongwose vajin nga Numal ko orrorrmi inu, ko niko ela tweni vajin nanu nga jinibb nir marok-meteni inu suri.” ");
INSERT INTO upv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ko Elisapet navöl sen ouwon easi osuw, ko Atua okoni kele anglo Gapriel evan renge ngaim nga milep san renge Galili, nisen Nasret. ");
INSERT INTO upv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ni otori nale nga pian puwrai tevi nesen m̃elakel san nga nisen Merri. Merri nen setewor norman san evan jin, ko arwera p̃ilik ji m̃er san nga nisen Josep, nga mivi metka se Devet san. ");
INSERT INTO upv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ko anglo evan ji Merri renge loloim sen ko owrai tevi ni, “Erres, nik kup̃ir. Numal ololi erres tevim ko eptevi nik.” ");
INSERT INTO upv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ko Merri nolon opotpot e ko orrorrmi karkare renge nale nga anglo muwrai ngok, owra “O, sev le ngel?” ");
INSERT INTO upv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ko anglo owrai tevi ni, “Merri, sete kupmetutu, suri Atua erres tevim. ");
INSERT INTO upv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ko kuplesi, nik kuptetaur, ko kupa-wosi natum norman san. Ko kuplingi nisen piwaji Iesu. ");
INSERT INTO upv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ni pivi Jinibb nga milep ko parveruse Atua ne Drromsen Mare Natun. Ko Iova Atua puloli ni pivi Numal pirpe apu sen Devet tuwi. ");
INSERT INTO upv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ni pivi Numal renge metka se Jekop nir tuwi ngok vini. Ko batun vanu sen sete purongwos pusuw.” ");
INSERT INTO upv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ko Merri owrai tevi anglo owra “O, ko inu sete nuvijuri wor norman san, ejki. Ko nanu ngel putoe pirpese le?” ");
INSERT INTO upv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ko anglo owrai lweni tevi Merri owra “Nem̃in On ko pivini jim, ko derteren se Atua ne Drromsen Mare pivini pisalsal orem. Ko suri nanu ngel, jinibb parwerai bipi nga m̃iak On, ko evi Atua Natun. ");
INSERT INTO upv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ko kuplesi niaken som Elisapet. Ni evi nesevin nga m̃im̃er, ko etra pa evi lekter osuw; ko etetaur vajin lelingenok, navöl sen ouwon le ngel vajin. ");
INSERT INTO upv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Suri sete nanu san rragrrag nga Atua sete orongwos puloli.” ");
INSERT INTO upv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ko Merri owrai tevi “Inu nuvi nesevin ne majingen se Numal lebbong, ko erres kobbong, puto pirpe nga nik kumwerai ngok.” Ko anglo evel lingi ni. ");
INSERT INTO upv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ko renge vitunen vajin, Merri ewit ngavilvil van renge botwen nga ngaim nga milep san ne Jutia muto rengen. ");
INSERT INTO upv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ko esil van renge loloim se Sekaraea e, ko owra “Erres” tevi Elisapet. ");
INSERT INTO upv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ko daron nga Elisapet moka-runge nale se Merri, ko bipi nga mimatur renge depain eir ko ewrrir renge depain, ko Elisapet owun saute Nem̃in On. ");
INSERT INTO upv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ko ekail drrelan elep van mare, ko owra “Atua erij erres surim renge nesevin m̃inij nen jile nir, ko erij erres suri bipi nga kumsoloi renge depaim! ");
INSERT INTO upv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ko erpese tasu se Numal suk mivini m̃ilesik? ");
INSERT INTO upv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ko kuplesi, daron nga inu mornge nale som, ko bipi nga mosloi renge depaik eir e ko ewrrir e. ");
INSERT INTO upv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Neiren renge nik, suri nga kumosuri nale nga Numal mukoni anglo sen muwrai tevi nik piplari.” ");
INSERT INTO upv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Merri owra ");
INSERT INTO upv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","“Renge mauren suk totoklai nusrövi Atua ne Drromsen Mare. Ko nem̃ik eir suri Atua nga moklai mauren tevik, ko nga murrorrmi inu milep. ");
INSERT INTO upv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Suri ni orrorrmi terai inu nga mevi nesevin ne majingen sen ko nga mevi nesevin nga welili jer. Ko renge lelingen ngel ko tuwi ngok vini jinibb parveruse inu nesevin nga Atua m̃ilai neiren tevi, ");
INSERT INTO upv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","suri nanu nga milep nga Atua nga derteren sen milep muloli tevi inu. Ni nisen On. ");
INSERT INTO upv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Eviseni merrenien sen tevi nir nga marmetutue ni renge dul nga tuwi pa ko nga lelingen ngel ko nga para-vini kele. ");
INSERT INTO upv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eviseni derteren sen tevi delung arlesi. Ololi nir nga nolor mian mare arsarr suri norrorrmien ser. ");
INSERT INTO upv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ni ela tweni nir nga marivi numal nga marlelep renge nai seksakel ser nga marsakel rer aran ngatan, ko ok-susi lartul nga maran ngatan van mare. ");
INSERT INTO upv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jinibb nga numer m̃iajir, ni ololir arup erres. Ko jinibb nga joror milep, ni okoni twenir artotori nevrer kiskis arivel. ");
INSERT INTO upv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Otori rijrijen sen nga muloli tevi apu se kerr nir nga tuwi pa, ko orrorrmi kerr m̃eri Isrel, ni jinibb sen nir, ");
INSERT INTO upv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","erpe nga muwrai pa tevi apu se kerr nir, ko Epram, ko metka sen nir nga para-vini vitunen suri ni, pian pijpari tuwi ngok vini.” ");
INSERT INTO upv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ko Merri elik tevi Elisapet erpe navöl itul sopon, ko evel olwi kele van renge ngaim sen e. ");
INSERT INTO upv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mian ko ejpari nabong nga Elisapet puwosi natun e, ko ni evasus; ko natun evi norman. ");
INSERT INTO upv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ko selen nir ko niaken sen nir arunge nga Numal muloli m̃irres tevi ni ko nga murrorrmi ni, ko nir arir elep tevi. ");
INSERT INTO upv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mian ko ejpari bongin owil, ko nir arini nga parloli ni pian renge movil parevji parloli ni p̃ilalos. Ko arwera parlingi ni nisen piwaji kele tata sen Sekaraea. ");
INSERT INTO upv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ko tasu sen owra “Ejki! Ni nisen piwaji Jon.” ");
INSERT INTO upv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ko nir arwerai tevi ni, “Ko nik. Sete metka som san ewaji nais ngel.” ");
INSERT INTO upv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ko nir arij e nevrer tevi tata sen nga ni puwra nisen piwaji isi. ");
INSERT INTO upv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ko Sekaraea owra parla nanu nga marok-ulul ren san tevi ni. Arlai tevi, ko ni oli nisen owra “Ni nisen piwaji Jon.” Ko nir jile artaole. ");
INSERT INTO upv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ko renge daron mawos nen ko pa erij luwi, ko osrövi Atua. ");
INSERT INTO upv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ko nir nga marlik mori ni armetutu, ko bbösa elair e. Ko nosp̃en nen arsup̃e rrale ngaim nga marto rrale botwen ne Jutia e nir. ");
INSERT INTO upv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ko jinibb jile nga marunge nosp̃en ne bipi ngel arrorrmi renge nolor ko arwera “Bipi ngel pia-ivi bipi nga pia-irpese le?” Suri oto limjer ngel nga Atua ne Drromsen Mare derteren sen eptevi. ");
INSERT INTO upv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ko tata sen Sekaraea Nem̃in On evini esilvi, ko owun saute. Ko erij erpe propet owra ");
INSERT INTO upv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kerr rrapsurövi Atua se kerr m̃eri Isrel nir. Suri ni evini oklue kerr jinibb sen nir, ko orpaji tweni kerr rramiel sisarow vajin. ");
INSERT INTO upv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Elai jinibb nga derteren sen milep san tevi kerr nga p̃ila mauren tevi kerr; ni evi metka se Devet san. ");
INSERT INTO upv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Erpe Atua owrai pa tuwi renge jingo propet on sen nir, ");
INSERT INTO upv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ni erijrij pa nga p̃ijnge devje nuval se kerr nir renge kerr, ko pirvei tweni kerr renge nevre nir nga marungasi kerr nir. ");
INSERT INTO upv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ko ni eviseni merrenien sen mawos apu se kerr nir nga tuwi, ko orrorrmi suri rijrijen on sen. ");
INSERT INTO upv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ololi rijrijen nga m̃iterter renge ni nisen tevi apu se kerr nga tuwi Epram. ");
INSERT INTO upv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ewer telasi tevi ni nga ni pirvei tweni kerr renge nevre devje nuval se kerr nir, ko kerr rraploli majingen sen nga sete rrapmetutu rragrrag vajin pijpari nga rrapa-mij. ");
INSERT INTO upv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Rrapivi jinibb on sen ko rrapivi jinibb nga mumomsawos m̃irres renge ni non renge nabong jile renge mauren se kerr. ");
INSERT INTO upv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ko nik bipi suk, parveruse nik nisem kupwaji Atua ne Drromsen Mare propet sen; suri nik kupwowomu renge no Numal nga kuploli lilane sel sen. ");
INSERT INTO upv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kupwer telasi sel sen limjer tevi jinibb sen nir, nga Atua p̃itlasi tweni nololien ser ko parmaur, ");
INSERT INTO upv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","suri merrenien nga milep se Atua se kerr. Ni pukoni moron ne melrin pivini puklue kerr, ");
INSERT INTO upv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ko pimor vaseni nir nga marlik tongmalik renge namol ne mijen; ko puloli b̃ela kerr parivel renge sel ne demat.” ");
INSERT INTO upv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ko mian ko nanwarreng nga elep rujruj ma renge niben ko norrorrmien sen, renge nga p̃imajing se Atua. Ko tetajer ok-an ok-lik renge lolo merwer ok-tirive nabong nga ni pia-vini limjer renge no m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Renge daron nen batu numal se m̃eri Rom nir nga nisen miwaji Sisa Okastas elngi nale nesesreien san, emrreni pareve jinibb jijle nga ni mimetmete nir, purongwose nir evis totoklai. ");
INSERT INTO upv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ngel evi sensas nga womu nen, renge daron nga Kwaerinias mivi numal nga milep renge Siria. ");
INSERT INTO upv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ko niko renge wosenen jinibb jijle arlulwi wor van renge vanu ser e, nga norman nir paruli niser renge naul renge ngaim ser mawos. ");
INSERT INTO upv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ko ngok niko Josep evel lingi ngaim ne Galili san nga nisen Nasret, lat nga m̃ilik e, ko evan renge ngaim ne Jutia san nga nisen Betliem. Ie evi lat nga numal Devet m̃iak e rengen tuwi. Ko niko Josep mulwi wor van ie, suri ni evi metka nga miplari renge metka se Devet san. ");
INSERT INTO upv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep eptevi nesen sen Merri, nuru oran nga parlai nise nuru. Orlik korti ma, ko Josep setewor ean jin. Ko Merri otomori pa pivesi natun. ");
INSERT INTO upv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ko renge daron nga morlik renge Betliem e ko evi daron mawos nga Merri puwosi bipi sen e. ");
INSERT INTO upv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ko ni evesi womue natun norman eak rrongvi. Ko ni ela kalek nga mimalum m̃irres ko onb̃e ore e, ko evetri ematur ngatan renge narov san nga marok-wungani nanu rrum nir rengen. Suri naim nga jinibb marlik renger loloim nen nga markel ototvi sete evter nir, ko lat nga nuru porlik rengen ejki. ");
INSERT INTO upv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ko renge lat nen jinibb ne ngaim nen sopor arlik orsel arok-metmete sipsip ser renge nat nga mupong nen. ");
INSERT INTO upv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ko anglo se Iova san evini eplari jir, ko nosrövien se Iova omor rrerraler; ko nir armetutu elep. ");
INSERT INTO upv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ko anglo owrai tevir, “Sete kapmetutu te pijki! Kaplesi, inu nuvini tevi nosp̃en nga m̃irres nga bowrai tevi kami, nga p̃ilai neiren nga milep temijpal tevi jinibb jijle nir. ");
INSERT INTO upv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Renge lelingen ngel, renge nata mupong nga ngel, renge ngaim ngel se Devet, bipi san eak rengen nga p̃ilai mauren tevi kami. Ni evi m̃er nga Atua m̃irijrij nga pukoni, ni evi Mesaea ko Numal. ");
INSERT INTO upv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nanu ngel le pivi nelesien nga piviseni tevi kami: kami kapan ko kaplesi bipi san nga marnub̃e ore kalek nga mimalum m̃irres e, ko marlingi mimatur ngatan renge narov nga marok-wungani nanu rrum nir rengen.” ");
INSERT INTO upv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Daron mawos nen ko pa anglo ne melrin nir arini arpitevi anglo nen, ko arla nubo, arsurövi Atua ne Drromsen Mare, arwera ");
INSERT INTO upv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nosrövien pian ji Atua ne Drromsem Mare! Ko renge iel ngatan ngel demat puto renge jinibb se Atua nga ni mimrrenir.” ");
INSERT INTO upv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mian ko daron nga anglo marivel lingir e marluwi vajin van renge melrin e, ko jinibb nga marok-metmete sipsip arwerwerai tevir, “Kerr pian ta Betliem rraplesi ta nanu nga miplari ngel nga Atua muwrai tevi kerr.” ");
INSERT INTO upv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ko nir arwit lengleng van; ko arlesi Merri ko Josep ko bipi nen nga mimatur renge narov nga nanu rrum nir marok-wunganir rengen. ");
INSERT INTO upv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ko daron nga marlesi jile bipi e, ko arsup̃sup̃e tevi jinibb nir sev nga anglo nir marwerai tevir suri bipi. ");
INSERT INTO upv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nir jijle nga marunge nale ngel nir nga jinibb nga marok-metmete sipsip marsup̃e suri tevir artaol lenglenge. ");
INSERT INTO upv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ko Merri otori totkoni jile rijen nen nir ko elngir renge nolon, orrorrmi surir eterter. ");
INSERT INTO upv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ko jinibb nga marok-metmete sipsip arlulwi, ko arsurövi Atua, arwera erres tevi ni renge nanu jile nga marunge ko marlesir mirpe nga anglo muwrai tevir. ");
INSERT INTO upv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mian ko bipi nen bongin owil, omomsawos bongin nga parloli pian renge bae e, ko arloli evan renge bae. Ko arlingi nisen ewaji Iesu, nisen nga anglo m̃ilngi womue mian ko vitunen vajin ko Merri mia-soloi. ");
INSERT INTO upv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mian ko ejpari daron momsawos nen nga Josep ko Merri porloli murrun nga nale nesesreien se Moses muwrai nga puloli nuru porwokwok re no Atua ko jinibb, ko orwosi Iesu van renge Jerusalem nga porla lweni tevi Iova. ");
INSERT INTO upv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Erpe aruli renge nale nesesreien se Iova, “Bipi norman jile nga m̃iak rrongvi womu nen e aron, arivi se Iova.” ");
INSERT INTO upv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ko porloli sulsulen pirpe nga nale nesesreien se Iova muwrai parlai: “Wum̃er p̃ieru, rreknga daro p̃ieru.” ");
INSERT INTO upv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ko b̃irtera san elik renge Jerusalem renge daron nen, nisen Simeon. Ni evi b̃irtera nga mumomsawos m̃irres, ko evi jinibb se Atua nga mimtutu ko etriv terai p̃ilesi m̃er nga p̃ilai mauren tevi m̃eri Isrel nir. Ko Nem̃in On se Atua eptevi ni, ");
INSERT INTO upv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","eviseni tevi ni nga ni sete pimij mun, p̃ilesi mun Mesaea se Iova nga m̃irijrije puwomu. ");
INSERT INTO upv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ngok Nem̃in On eptevi ni van renge Naim On se Atua. Ko re wosenen mawos ko pa tasu se bipi ko tata sen orsale Iesu vini renge Naim On nga porloli sulsulen tevi ni pirpe nga nale nesesreien se Atua muwrai. ");
INSERT INTO upv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ko Simeon elesi bipi, ko owosi esale renge nevren ko osrövi Atua owra ");
INSERT INTO upv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lelingenok kuplinglingi jinibb ne majingen som vajin pivel renge demat, pirpe nale som muwrai. ");
INSERT INTO upv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lelingen ngel metek elesi jinibb som nga pia-la mauren tevi jinibb nir ");
INSERT INTO upv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","erpe nga nik kumloli lilane renge no jinibb jijle ne iel ngatan nir. ");
INSERT INTO upv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Moron nga pimor vaseni jinibb jijle ne vare nir, ko pivi nosrövien se kem m̃eri Isrel nir nga namivi jinibb som.” ");
INSERT INTO upv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ngok tata sen ko tasu sen ortaole nale nga muwrair ngok nir suri ni. ");
INSERT INTO upv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ko Simeon erij erres suri nir; ko owrai tevi tasu sen Merri owra “Kupmeteni! Atua otobbtobbue bipi ngel nga pulokloksi m̃eri Isrel pilep parvitan, ko p̃isa raji lweni nir pilep. Ko pivi nelesien nga m̃eri Isrel pilep parij tere. ");
INSERT INTO upv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ko ngok niko pimor vaseni norrorrmien se jinibb pilep nga marok-silvenir marto teptepi parto limjer vajin. Ko nik nolom purnge p̃isij pirpe nesip nuval nga muso renge devjen korti m̃isari rrurrngi nolom.” ");
INSERT INTO upv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ko renge daron nen lekter san evi propet, nisen Ana. Ni evi natu Panuel ko evi metka se Aser san. Bonevis, daron nga mivi nesen m̃elakel kobbong, ko elik ji diwen sen; ko orlik sia ebut, ko diwen sen emij lingi. Ko otur nawon sia elep lengleng. ");
INSERT INTO upv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Sian evi ngavöl owil drromon ivij (84) vajin. Ko sete elinglingi Naim On nabong san. Renge rorpong jile ko rivriv jile okorti tevi nir nga marok-lot ko marok-linglingi nanen suri. ");
INSERT INTO upv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ko Ana evini renge loloim ne Naim On renge daron mawos nga Simeon m̃irij m̃irres suri bipi e. Ko omurrarrong suri nale nga muwrair suri bipi ngel, ko owra erres elep tevi Atua suri. Ko osp̃e suri tevi jinibb jijle nga martiriv tera Atua p̃itlasi tweni m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Merri ko Josep orloli nanu nga nale nesesreien se Atua muwrai jile, ko orwosi bipi arluwi van renge Galili e renge ngaim ser Nasret. ");
INSERT INTO upv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ko bipiwarreng nen elep rujruj ma, ko jin eterter, ko owun saute norongwosien. Ko Atua erij erres suri ni. ");
INSERT INTO upv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Renge sia jijle tata se Iesu ko tasu sen orok-pitevi nir nga marok-an renge Jerusalem nga marok-tori nanen ne asien. ");
INSERT INTO upv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Daron nga Iesu sian mijpari esngavöl drromon eru malum e ko tata sen ko tasu sen orpitevi ni nir kes aran renge nanen ne asien, erpe tetajer marok-loli. ");
INSERT INTO upv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mian ko ejpari nabong nga marlingi nanen ne asien puto renger arsuw, ko jinibb artipatun arlulwi van renge ngaim ser e. Ko Iesu elik jer renge Jerusalem; tata sen ko tasu sen sete orongwose nga ni m̃ilik jer. ");
INSERT INTO upv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Orrorrmi rreknga ni eptevi pa meling ne jinibb nga ngok nen sopor nga marlulwi van renge ngaim ser e. Mian ko otomori pivi vajin nabong totoklai san, ko ortipatun orkulkulu pej renge metka ser nir ko seler nir, ");
INSERT INTO upv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ko sete orlesi te ejki. Mian ko orluwi kele van renge Jerusalem e, orpej kele. ");
INSERT INTO upv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mian ko renge nabong itolin vajin ko orsekai renge Naim On se Atua, m̃ilik tevi jinibb ne nevisvisenien se m̃eri Isrel nir, ko ok-murrarrong nir ko ok-susi lweni nale tevir. ");
INSERT INTO upv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ko nir jile nga marunge nale sen bbösa elair e, suri marunge renge rijen sen nga mok-rij weli lweni nale se jinibb nevisvisenien se m̃eri Isrel nir, nga norongwosien sen elep. ");
INSERT INTO upv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Daron nga tata sen nuru tasu sen morsekai ni e ko ormabbös bbösa elai nuru e, ko tasu sen owrai tevi, “Wurru natuk erpese kumloli mirpok tevi komru? Kuplesi tata som ko inu nomor-runge esij, nolo komru opotpot elep nga nomor-pej nik.” ");
INSERT INTO upv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ko Iesu owrai lweni tevi nuru, “Komor-pej inu suri sev? Sete komor-rongwose nga inu b̃elik renge naim se Tata suk ko wor?” ");
INSERT INTO upv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ko nuru sete orongwose isev ko nga muwrai tevi nuru. ");
INSERT INTO upv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ko Iesu evini ji nuru ko arluwi van renge Nasret e, ko ni tetajer ok-runge drrela nuru. Ko tasu sen orrorrmi suri nanu ngel nir tetajer, sete emalie nir. ");
INSERT INTO upv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ko Iesu elep oruj renge niben ko norongwosien sen, ko Atua eir rengen, ko jinibb kele arir rengen. ");
INSERT INTO upv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Renge sia esngavöl drromon elim (15) nga Taepirias Sisa mivi batu numal renge Rom, ko Ponjes Paelet evi numal ne Jutia, ko Erot Antipas evi numal ne Galili, ko tuwan Pilip evi numal ne Ituria ko Trakonaetas, ko Lisanias evi numal ne Apilin, ");
INSERT INTO upv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ko Anas ko Kaeapas orivi batu jinibb ne sulsulen nir; ko renge daron nen ko nale se Atua evini ji Jon Sekaraea natun renge daron nga m̃ilik renge lolo merwer e. ");
INSERT INTO upv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ko Jon evel p̃etp̃eti renge vanu nga marto mori Jortan nir, ewerwer renger, owra “Kaprieni lweni nolo kami renge nololien se kami nir, ko kappaptaes; ko Atua p̃itlasi tweni nololien se kami.” ");
INSERT INTO upv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Erpe nga propet Aesea muli renge naul sen muwra “Jinibb san ekail renge lolo merwer, owra ‘Kaploli lilane sel se Numal puto metmet terai, ko kaploli mesekle sel sen nir parmetet p̃irres. ");
INSERT INTO upv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bbulwil nga marp̃errparrorr van ngatan nir kaptevnir parsorsan, ko botwowout jile nir kapjuröni nir paran ngatan parsorsan, ");
INSERT INTO upv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","nga jinibb jijle parlesi sel nga Atua p̃ila mauren tevi jinibb nir.’” ");
INSERT INTO upv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Delung elep arivel sele Jon, nga ni pipaptaese nir. Ko ni owrai tevir, “Kamivi jinibb nga kamsij O! Kamirpe metka ne num̃et! Isi osusur metu tevi kami nga kapwolu lingi lolaren se Atua nga pia-vini? ");
INSERT INTO upv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Poro nolo kami pulululwi, rrek erres kapviseni wenen nen. Sete kapwerwerai tevi kami lululweni, ‘O, kem namivi metka se Epram, ko p̃irres bbong re kem.’ Inu nuwrai tevi kami, Atua orongwos p̃ila nevöt nawon nga ngel nir ko p̃irienir parivi metka se Epram. ");
INSERT INTO upv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lelingen ngel artori batu deli oto metmet nga parta ototvi lap̃e nai nir; ko nai jile nga marsij, sete wener marres mun, parta twenir parwirr nir van renge nabb nga m̃in.” ");
INSERT INTO upv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ko delung, daron nga marunge nale sen, ko arsusi lweni tevi ni, “Ko kem nabloli sev ma?” ");
INSERT INTO upv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ko ni owra lweni tevir owra “M̃er nga sunsun sen m̃ieru p̃ila tuwen tevi m̃er nga sunsun sen mijkie; ko m̃er nga nanen sen mutoe, ni kele puloli pirpok puwngani sopon tevi m̃er nga nanen sen mijkie.” ");
INSERT INTO upv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ko jinibb nga marok-la nevöt ne takis nir arini jin nga ni pipaptaese nir, ko arsusu tevi ni arwera “Ko kem nabloli pirpese?” ");
INSERT INTO upv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ko ni owra lweni tevir, “Kami sete kaplai nevöt p̃iasi renge lat nga marlingi tevi kami nga kaplai rengen.” ");
INSERT INTO upv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ko jinibb nuval nir arsusi tevi ni arwera “Ko kem nabloli pirpese?” Ko ni owra lweni tevir, “Kami sete kapon tertere jinibb nga kapla nevöt jin, ko sete kapsusur metu tevir kapwera kaploli nanu san tevir nga puloli kami kapla nevöt jir. Ko kap̃ir kobbong suri nowli kami.” ");
INSERT INTO upv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jinibb norrorrmien ser artipatun arunge erres suri Jon, ko arrorrmi rrekma ni evi Mesaea. ");
INSERT INTO upv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ko Jon orongwose norrorrmien ser ko owra lweni tevir, “Inu nupaptaese kami e nuwi rres kobbong. Ko san ko ma niko pia-vitu suri inu vini, ni ean wor mare renge inu, ko inu sete nurres rragrrag nuvter re b̃etlasi tweni dil ne but sen. Ni ko ma pia-paptaese kami e Nem̃in On ko nabb. ");
INSERT INTO upv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ni otori nai juljule san renge nevren nga pujlujle wene wit e nir, ko dokolvir parwirr lingi jelangir; ko p̃iser kortoni jelangir p̃ilngir renge b̃ep̃eim sen, ko pusli dokolvir renge nabb nga sete san orongwos pivsi pini.” ");
INSERT INTO upv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ko ela nale lele kele wor elep tevir renge nga m̃iwerwer tevir renge nosp̃en nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ko Jon otortori Numal Erot suri m̃itkai luwe nesen se tuwan Pilip, Erotias, ko suri kele wor nanu elep nga mulolir marsarr. ");
INSERT INTO upv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ko nanu nga m̃isij p̃erp̃er nen nga muloli evi vajin nga m̃ilngi Jon renge naim ne nekaien. ");
INSERT INTO upv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ko daron nga setewor Erot m̃ilngi Jon re naim ne nekaien, ko Jon epaptaes jile jinibb nir osuw, ko vitunen vajin ko epaptaese Iesu. Ko renge daron mawos nga pa mipaptaese ngok ko, ko Iesu olot ko melrin eteri wukari etp̃ir. ");
INSERT INTO upv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ko Nem̃in On ojubbul vini; ko ololi niben otoe erpe wum̃er, ko orow vini esakel renge Iesu. Ko Atua drrelan evel renge melrin vini erij tevi, owra “Nik kuvi Natuk nga numrrenim elep. Nurnge erres elep surim.” ");
INSERT INTO upv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu etipatun majingen sen renge daron nga sian pirpe pingavöl p̃itul (30) sopon. Ko jinibb arwera ni evi natu Josep, ko tata sen ko Josep. Ko Josep evi natu Eli ");
INSERT INTO upv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ko Eli evi natu Matat, ko Matat evi natu Livae ko Livae evi natu Melki ko Melki evi natu Janai ko Janai evi natu Josep. ");
INSERT INTO upv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ko Josep evi natu Matataias ko Matataias evi natu Amos ko Amos evi natu Naum ko Naum evi natu Esli ko Esli evi natu Nakai. ");
INSERT INTO upv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ko Nakai evi natu Maat ko Maat evi natu Matataias ko Matataias evi natu Semin ko Semin evi natu Josek ko Josek evi natu Jota. ");
INSERT INTO upv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ko Jota evi natu Jonan ko Jonan evi natu Resa ko Resa evi natu Serupapel ko Serupapel evi natu Salatail ko Salatail evi natu Neri. ");
INSERT INTO upv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ko Neri evi natu Melki ko Melki evi natu Ati ko Ati evi natu Kosam ko Kosam evi natu Elatam ko Elatam evi natu Er. ");
INSERT INTO upv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ko Er evi natu Josua ko Josua evi natu Eliesa ko Eliesa evi natu Jorim ko Jorim evi natu Matat ko Matat evi natu Lipae. ");
INSERT INTO upv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ko Lipae evi natu Simeon ko Simeon evi natu Jutas ko Jutas evi natu Josep ko Josep evi natu Jonam ko Jonam evi natu Eliakim. ");
INSERT INTO upv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ko Eliakim evi natu Melea ko Melea evi natu Mena ko Mena evi natu Matata ko Matata evi natu Natan ko Natan evi natu Devet. ");
INSERT INTO upv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ko Devet evi natu Jese ko Jese evi natu Opet ko Opet evi natu Boas ko Boas evi natu Salmon ko Salmon evi natu Nason. ");
INSERT INTO upv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ko Nason evi natu Aminatap ko Aminatap evi natu Atmin ko Atmin evi natu Ani ko Ani evi natu Esron ko Esron evi natu Perej ko Perej evi natu Juta. ");
INSERT INTO upv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ko Juta evi natu Jekop ko Jekop evi natu Aesak ko Aesak evi natu Epram ko Epram evi natu Tera ko Tera evi natu Nakor. ");
INSERT INTO upv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ko Nakor evi natu Seruk ko Seruk evi natu Reu ko Reu evi natu Pelek ko Pelek evi natu Eper ko Eper evi natu Sela. ");
INSERT INTO upv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ko Sela evi natu Kenan ko Kenan evi natu Apaksat ko Apaksat evi natu Sem ko Sem evi natu Noa ko Noa evi natu Lamek. ");
INSERT INTO upv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ko Lamek evi natu Metusela ko Metusela evi natu Inok ko Inok evi natu Jaret ko Jaret evi natu Malalel ko Malalel evi natu Kenan. ");
INSERT INTO upv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ko Kenan evi natu Inos ko Inos evi natu Set ko Set evi natu Atam, ko Atam evi natu Atua. ");
INSERT INTO upv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ko Iesu owun saute Nem̃in On, ko evel lingi Jortan, olwi. Ko Nem̃in On owomue ni evan renge lolo merwer e. ");
INSERT INTO upv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ko ni elik iok nabong ngavöl ivij (40) nga Demij purrowrrowe ni. Ko renge nabong ngok nir, ni sete orro nanen san renger ejpari marsuw. Ko renge vitunen vajin ko ornge numer aji lenglengen. ");
INSERT INTO upv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ko Demij owrai tevi ni owra “E, nik kuvi pa Atua Natun! Kupwerai tevi nevöt nawon ngel p̃irieni pivi niv.” ");
INSERT INTO upv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ko Iesu owra lweni tevi owra “Ejki, Naul On owra ‘Jinibb sete orongwos pimaur e niv kis pisan.’” ");
INSERT INTO upv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ko Demij eptevi ni ortongsa van mare sopon. Ko eviseni batun vanu ne iel ngatan totoklai tevi ni evesane erpe navil nga mivil. ");
INSERT INTO upv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ko owrai tevi, “B̃ela derteren ne nanu ngel jile nir tevim ko nosrövien ner jile, suri arlair pa tevi inu, ko inu vajin b̃elai tevi isi nga inu memrreni. ");
INSERT INTO upv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ko niko poro nga nik kupjipa ngatan ko kuplotoe inu, ko ngok nanu ngel jile parivi som.” ");
INSERT INTO upv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ko Iesu owrai lweni tevi owra “Ejki, Naul On owra ‘Nik kuplotoe Iova Atua kobbong, ko nik kuploli majingen se ni kobbong.’” ");
INSERT INTO upv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ko Demij eptevi ni kele van renge Jerusalem e ko elngi ni renge drromo Naim On mare jer, ko owrai tevi, “E, nik kuvi pa Atua Natun! Kuprow jubbul iel van ngatan e. ");
INSERT INTO upv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Suri Naul On owra ‘Atua pukoni anglo sen parmetmete nik.’ ");
INSERT INTO upv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ko Naul On owrai kele, ‘Nir parwosim renge nevrer mare suri nik tukjilaklak wos b̃elam renge nevöt.’” ");
INSERT INTO upv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ko Iesu owra lweni tevi, “Ejki, Naul On owra, ‘Sete kuprrowrrowe Iova Atua som te, pijki.’” ");
INSERT INTO upv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Daron nga Demij murrowrrow jile Iesu renge sel nga muwra purrowrrowe ni rengen ko evel lingi mun, pian pijpari nabong sopon kele ko pia-luwi kele. ");
INSERT INTO upv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ko derteren se Nem̃in On esilvi Iesu, ko ni olwi van renge Galili e. Ko nosp̃en nen evel jile renge ie nir. ");
INSERT INTO upv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ko evisviseni jinibb nir renge naim ne loten ser nir, ko jinibb jile nir arsurövi ni. ");
INSERT INTO upv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ko Iesu olwi van renge Nasret e renge lat nga ni milep e bonevis. Ko renge nabong ne Sapat ni evan renge Naim On erpe tetajer mok-loli. Ko otur imare nga pieve Naul On. ");
INSERT INTO upv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ko nir arla naul se Propet Aesea arsareni tevi ni. Ko ni elai eveve; ko elesi lat san, ko eve tevir. Lat nen owra erpel: ");
INSERT INTO upv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Nem̃in se Iova elik renge inu, suri ni otobbtobbue inu nga b̃ewerwer renge Nosp̃en nga M̃irres tevi b̃eres nir. Ni okoni inu nga bowra tweni tevi nir nga marlik renge naim ne nekaien parivel sisarow, ko bololi nir nga meter marrorr parkulu luwi, ko bololi nir nga marlik re nekaien parivel sisarow. ");
INSERT INTO upv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ko bowra tweni sia nga Iova pia-la mauren tevi jinibb sen nir.’ ");
INSERT INTO upv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ko daron nga mieve jile, ko ni olulngi lweni naul ko esareni lweni tevir ko esakel re lat ne werweren. Ko nir jijle nga marlik renge naim ne loten arwang suri etingtingin. ");
INSERT INTO upv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ko ni etipatun owra suri tevir, “Nale nga naul ngel musp̃e surir ngel nir nga kammurrarrong nir ngel, lelingen ngel Atua ololir arpelari.” ");
INSERT INTO upv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jinibb jile arunge nale sen nir arres p̃elak, ko bbösa elair e. Ko arwera “Ni evi natu Josep, rreknga?” ");
INSERT INTO upv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ko ni owra lweni tevir, owra “Nurnge erpe kami kapwera nale san nga marok-werai ngel tevi inu, ‘Dokta, kuploli nik lweni kuprres puwomu. Nanu nga kumloli renge Kapaneam nir, kuplolir iel kele renge sisom’. ");
INSERT INTO upv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ko nuwretun nuwrai tevi kami, propet san, orongwos parosuri lat jijle nga mian e. Ko jinibb nga ma renge sisen woswos sete mara-osuri p̃elake. Nanu ngok sete erres. ");
INSERT INTO upv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ko renge weretunen nuwrai tevi kami, nesevin elep renge Isrel nga diwen ser marmij lingir renge daron se Elaeja, renge daron nga naus sete mus renge sia itul totoklai ko renge devje sia kele san, ko numer nga milep renge vanu ngel p̃etp̃eti. ");
INSERT INTO upv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ko Atua sete okoni Elaeja van ji nir san, ejki. Ko okoni ni ma van renge Saripat renge vanu ne Saeton san, evan ji nesevin san nga diwen sen mimij lingi ie. ");
INSERT INTO upv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ko jinibb elep nga marmesi e mesien nga niber m̃im̃emaul renge daron nga Elaesa mivi propet e renge Isrel, ko nir san sete Elaesa ololi erres luwi, ejki, ko sansan kobbong Neman, nga mivi m̃eri Siria.” ");
INSERT INTO upv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ko nir nga marlik renge naim ne loten loloim marunge nanu ngel e ko arlolar lenglenge. ");
INSERT INTO upv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ko artur imare ko arrul totoni Iesu, ko arevei van vare e. Ko arpitevi van renge drromo botwen e nga marloli ngaim ser renge jeljelin, arwera parsir jubble batun puwomu van ngatan e. ");
INSERT INTO upv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ko ni evel rrurrngi bbong livö renge delung nir ko evel asi, evel, setemun arrul totoni. ");
INSERT INTO upv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ko Iesu evan renge Kapaneam e, ngaim ne Galili san. Ko renge nabong ne Sapat evan renge naim ne loten, ko evisviseni jinibb nir. ");
INSERT INTO upv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ko jinibb artaole nevisvisenien sen, suri nale sen nir arrow erres. ");
INSERT INTO upv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ko jinibb san nga nem̃in nga marsij marsisilvi elik ie renge loloim ne naim ne loten. Ko ekail drrelan evan mare lengleng, ");
INSERT INTO upv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","owra “E! Sev som oto nile iel, nik Iesu ne do Nasret? Nik kuvini nga kuplokloksi kem? Inu nurongwose nik, nik kuvi jinibb on se Atua.” ");
INSERT INTO upv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ko Iesu otortori owra “Kupmurrarrong, kupsil ivare renge ni!” Ko nem̃in nga m̃isij evireni m̃ernen ewajeni torrlai ngatan renge livö ne nir, ko evel lingi. Ko sete ololi niben sopon esij. ");
INSERT INTO upv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ko bbösa nga milep elair e, ko arsup̃sup̃e lulweni nir e arwera “Aro, nale sev le ngel? Ni nale sen otutun, muwrai tevi nem̃in nga marsij ko arivare arvesane.” ");
INSERT INTO upv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ko nosp̃en ne nanu nga Iesu mulolir, jinibb arsup̃sup̃er owlu jijle renge vanu ne ie nir. ");
INSERT INTO upv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ko Iesu eivare renge naim ne loten ko evan renge naim se Saemon e. Ko Saemon p̃ilen lekter emsi e mesien dowalul nga m̃iterter milep, ko arwerai tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ko ni evan otur mori ji Saemon p̃ilen lekter ko ewer ore mesien dowalul, ko mesien dowalul elinglingi. Ko lekter emra kasi ko ela nanen tevir. ");
INSERT INTO upv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mian ko nial ewaj pini vajin, ko nabong on ser osuw. Ko jinibb nga seler marmesi artektekair vini ji Iesu. Ko elngi nevren nuru renger ko ololi nir jile arres luwi. ");
INSERT INTO upv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ko nem̃in nga marsij arivare lingi nir elep, ko arkail van mare arwera “Nik kuvi Atua Natun!” Ko Iesu otortorir ewer orer owra sete parij, suri arongwose ni evi Mesaea. ");
INSERT INTO upv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ko renge nat nga murorpong ko Iesu evel lingi ie ko evan renge lolo merwer e, lat nga nat mubbubbil e. Ko delung arvivitu suri, arpej. Ko daron nga marlesi ko arloli lesi parwer ore ni sete pivel lingir. ");
INSERT INTO upv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ko ni owrai tevir, “Inu b̃ewerwer ko wor renge nosp̃en nga m̃irres ne batun vanu se Atua renge ngaim m̃inij kele nir, suri nga nanu ngok ko Atua mukoni inu tweni nga bololi.” ");
INSERT INTO upv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ko ni evel suri ngaim ne Jutia nir, ko evan renge naim ne loten nir ko ewerwer renger. ");
INSERT INTO upv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Renge nabong san ko Iesu ok-tur renge jeli nuwito ne Genesaret (nga nisen tuwen marveruse nuwito ne Galili) ko ok-werwer. Ko delung elep arini mori jin arunge nale se Atua, ko arlilji ni. ");
INSERT INTO upv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ko Iesu elesi drrav eru orrerrsi renge jeli dep̃inan; ko jinibb nga marok-tutumun renge nuru arivel lingi nuru aran arrawe niva ser. ");
INSERT INTO upv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ko Iesu esa van renge drrav nen tuwen, nga mivi se Saemon Pita nen, ko owrai tevi ni nga pusoni tweni p̃isal van ngalu beblen, p̃isal lingi dep̃inan. Ko ni esakel renge drrav ko evisviseni delung nir nga martur suri jeli nuwito. ");
INSERT INTO upv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ko daron nga Iesu m̃irij jile, ko owrai tevi Saemon “Kupsu rujoni drrav beblen van renge lat nga nuwi murron e, ko kapjuröni niva se kami van ngatan. Ko kaplesi ko, kaprevei nai vajin.” ");
INSERT INTO upv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ko Saemon owra lweni tevi, “Numal, namp̃elak elep nata mupong, namp̃elak rrarren ko sete namla nai sansan rragrrag. Ko suri nik kumwerai, ko inu bololi ta pirpe nga kumwerai.” ");
INSERT INTO upv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ko nir arjuröni niva ser van ngatan renge nuwi; ko arevei lengleng nai, ololi niva ser otomori pimarrerr. ");
INSERT INTO upv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ko aroluve seler nir renge drrav tuwen nen e nga parini parpitevir. Ko nir arini ko arlila tututweni nai re niva van renge nolo drrav e nuru, ko orwun saute vajin, otomori parron e. ");
INSERT INTO upv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ko Saemon Pita etaol lenglengen e ko ejipa ngatan renge b̃ela Iesu ko owra “Numal wurru kupruj ngasue inu, suri nuvi jinibb nga m̃esij.” ");
INSERT INTO upv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Suri ni ko nuru nga morpitevi ni bbösa nga milep elair e renge nga marlesi marevei lenglenge nai mirpel. ");
INSERT INTO upv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ko Jemes ko tasin Jon, Sepeti natun nuru nga morpitevi Saemon, nir jile bbösa elair e. Ko Iesu owrai tevi Saemon, “Sete kupmetutu te. Etipatun le pa ngel, lelingen ngel ko p̃itajer tevi, nga nik kuprevei vajin jinibb pirpe nga lelingenok komok-revei nai.” ");
INSERT INTO upv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ko nir arsu e drrav ser van ngaut e, arrerrseni renge dep̃inan. Ko arivel lingi, tevi joror jile nir nga marto rengen. Ko arvijuri Iesu, arivi jinibb sen vajin. ");
INSERT INTO upv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mian ko renge nabong m̃inij kele san Iesu elik renge ngaim san, ko jinibb san nga mimsi mesien nga niber m̃im̃emaul evini. Mesien ngok ololi p̃etp̃eti niben jile nir osuwsuw. Ko m̃ernen elesi Iesu ko evini ejipa ngatan jin, ko owra “Wurru poro nga nik kupmarong, ko kuploli inu bowokwok.” ");
INSERT INTO upv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ko Iesu owra “Ejki, numarong le pa. Kupwokwok!” Ko sete eringe mesien sen, esaro elngi nevren rengen. Ko ngavilvilsen mesien nga niber m̃im̃emaul evel lingi ni. ");
INSERT INTO upv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ko Iesu ewer ore ni, owra “Kuplesi sete kupwera nanu pisan tevi jinibb pisan, ko kupvijuri sel som, kupasi ji batu jinibb ne sulsulen p̃ilesim. Ko kupla nanu nga Moses muwrai renge nale nesesreien sen tevi ni. Ngok piviseni tevi jinibb nir nga kumwokwok pa.” ");
INSERT INTO upv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ko nosp̃en ne sev nga Iesu muloli ok-ruj ma elep renge vanu. Ko delung elep arok-ivel tweni nga parunge ni nale sen, ko pulolir parres luwi renge mesien lele ser nga marmesi e. ");
INSERT INTO upv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ko evi murrun sen nga renge nabong jile ok-ivel lingir, ko ok-san ok-an renge lolo merwer e, ok-lot mun ie. ");
INSERT INTO upv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mian ko renge nabong m̃inij kele san Iesu ok-visviseni jinibb nir. Ko Parasi nir ko jinibb nevisvisenien ne nale nesesreien nir nga marivel renge ngaim jijle nir ne Galili e vini, ko renge Jutia ko renge Jerusalem kele, arsakel ie. Ko derteren se Iova elep renge Iesu nga puloli lartul nga marmesi parres luwi. ");
INSERT INTO upv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ko jinibb sopor arwosi jinibb san nga devje niben mimij renge maling sen vini, ko arpejpej lat nga parasi van loloim e tevi, parlingi ji Iesu. ");
INSERT INTO upv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ko sete lat san oto nga parasi rengen, ejki, suri jinibb elep p̃elak. Ko arwosi arsa tevi van mare e renge drru naim. Ko arrarre drru naim mare, ko arjuröni ni van loloim e renge livö ne jinibb nir ko renge Iesu non. ");
INSERT INTO upv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ko Iesu etaole nga m̃ilesi nosurien ser ko owrai tevi, “E, m̃erel, nololien som nutlasi tweni pa osuw.” ");
INSERT INTO upv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ko jinibb nevisvisenien ne nale nesesreien ko Parasi nir arrorrmi sarrsarre renge nolor, arwera “Erpese m̃erel m̃irij mirpok? Erij melmelas ko osopsop̃e Atua! Isi orongwos p̃itlasi tweni nololien nir? Atua kobbong esan bbölbböl!” ");
INSERT INTO upv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ko Iesu orongwose norrorrmien ser, ko owrai tevir, “Suri sev kami kamrrorrmi nanu ngel nir renge nolo kami nir mirpok? ");
INSERT INTO upv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Evi nanu nga m̃isisarow bbong nga bowrai tevi m̃erel, ‘Nololien som nutlasi tweni pa,’ suri si p̃ilesi poro nuwretun rrek nukrekris kobbong? Ko evi nanu nga m̃iterter kele wor asi ngok nga poro bowra ‘Kuptur imare kupla milngom ko kupiel van renge naim som e,’ suri jinibb jijle parlesi lelingen poro piplari pirpe nga mowrai ngok. ");
INSERT INTO upv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ko bololi vajin nanu nga m̃iterter nen, puloli kaprongwose kele nga inu Jinibb Mawos derteren suk otoe renge iel ngatan nga b̃etlasi tweni nololien.” Ko ni owrai tevi m̃er nga niben devjen mimij owra “Nuwrai tevi nik, Kuptur imare kuplai maling som kupwosi, ko kupiel van renge naim som e.” ");
INSERT INTO upv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ko ni otur imare kasi ngavilvil, ko osrövi Atua, ko owosi maling sen ko evel limjer renge nor, evan vare e. ");
INSERT INTO upv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ko jinibb jijle bbösa nga milep elair e ko armetutu elep, ko arsurövi Atua arwera “Aro, lelingen rramlesi nanu nga m̃inijnije san.” ");
INSERT INTO upv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Vitunen renge nanu ngel nir, ko Iesu evel kele, ko elesi jinibb san nga mok-la nevöt ne takis nga nisen miwajie Livae, ok-lik renge naim nga mok-majing rengen. Ko Iesu owrai tevi “M̃erel, kup-vijuri inu ko kupivi jinibb suk.” ");
INSERT INTO upv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ko ni otur imare, evel lingi joron jile nir arjipon ko evijuri Iesu. ");
INSERT INTO upv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ko mian ko Livae ololi nanen nga milep san renge naim sen nga m̃iaan ore ni e tevi Iesu. Ko nir elep nga marok-la nevöt ne takis arini renge nanen, ko jinibb elep kele wor nga marsakel tevi Iesu araan korti tevi ni renge tep. ");
INSERT INTO upv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ko Parasi sopor ko jinibb nevisvisenien ne nale nesesreien sopor nga marok-pitevir arwor suri Iesu tevi jinibb sen nir, arwera “Erpese kami kamaan ko kamminmin tevi jinibb nga marok-la nevöt ne takis nir ko jinibb nga marsij nir?” ");
INSERT INTO upv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ko Iesu owrai lweni tevi nir, “Nir nga marres sete armerreni dokta, ko nir nga bbong marmesi ko. ");
INSERT INTO upv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ko erpok ko, inu nuvini sete nga beveruse nir nga tetajer marwera marres, ejki, ko nuvini tweni bbong beveruse nir nga sete markerkeris, ko marwer limjere nga marsij, nga nolor pulululwi.” ");
INSERT INTO upv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ko mian ko jinibb sopor arwerai tevi Iesu “Jon jinibb sen nir arok-vil tetajer ko arok-lot, ko jinibb se Parasi kele nir arok-loli erpok; ko nik jinibb som, erpese maraan ko marminmin ko setemun marvil?” ");
INSERT INTO upv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ko Iesu owrai tevir owra “Daron nga jinibb nga mutotko elik vane renge nanen tevi selen nir, ko kami kamrrorrmi nga nir parlinglingi nanen nga parvil? Ejki rres nawon! ");
INSERT INTO upv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mian ko nabong nen pia-vini vajin, ko para-tekai tweni m̃er nga mutotko jir. Ko ngok ko nir para-vil ko renge nabong nen nir.” ");
INSERT INTO upv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ko ni owra nale rrongrrongvi m̃inij nen kele san tevir, owra “Sete jinibb san orongwos p̃irrerrsi tweni bebje sunsun nga mimerr sopon ko puwol ore lat nga mimarrerr e renge sunsun nga m̃itra e, ejki. Poro pirpok ko ni olokloksi pa sunsun nga mimerr nen; ko sunsun nga m̃itra nen kele p̃isij, suri bebje sunsun nga mimerr nen sete pusorsan p̃irres tevi. ");
INSERT INTO upv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ko erpel kele, sete jinibb san orongwos pujongjongi norro nga mimerr van renge botel nga m̃itra nga marloli nevlu nanikot e. Poro pirpok ko norro nga mimerr tut, tuloli nevlu nanikot nga m̃itra tirrerren ko tiap rrerrsi, suri etra p̃elak. Ko norro timejivjiv teplingi tisij, ko nevlu nanikot kele tisij. ");
INSERT INTO upv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Niko norro nga mimerr parlingi ko wor renge nevlu nani nga mimerr mimalum m̃irres. ");
INSERT INTO upv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ko sete jinibb san nga mok-mini norro nga m̃itra emrreni norro nga mimerr, suri owra ‘Norro nga m̃itra erres’.” ");
INSERT INTO upv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mian ko Iesu evel otvi naut ne wit san renge nabong ne Sapat. Eptevi jinibb sen nir; ko jinibb sen nir numer ajir, ko artipatun arsesri sursele wene wit nir ko arseseir nga dokolvir parjikie lingir, ko arlair arurrurroir. ");
INSERT INTO upv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ko Parasi sopor arlesi, ko arwerai tevi ni, “Kuplesi ta, nir arloli nanu nga sete mumomsawos renge nabong ne Sapat!” ");
INSERT INTO upv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ko ni owrai lweni tevir, “Aro, ejki ma, ko rreknga ma kami sete kameve renge Naul On, nanu nga Numal Devet muloli daron nga nanen ser mijkie, numer m̃iaji ni ko nir nga marlik tevi ni? ");
INSERT INTO upv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ni ean renge Naim On se Atua, daron nga Apiata mivi batu jinibb ne sulsulen e, ko ni orro tama niv nga setete erres renge jinibb nga marivi jinibb nawon parurroi, evi kis bbong se batu jinibb ne sulsulen ko. Ko ni elai kele tevi nir nga marlik tevi arurroi.” ");
INSERT INTO upv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ko Iesu owrai kele tevir, “Inu Jinibb Mawos nuvi Numal ne Sapat.” ");
INSERT INTO upv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mian ko renge nabong ne Sapat m̃inij kele san ko Iesu evan kele renge naim ne loten pivisviseni jinibb nir. Ko jinibb san nga nevren rres m̃ikati elik ie renge loloim. ");
INSERT INTO upv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ko renge ie jinibb nevisvisenien ne nale nesesreien sopor ko Parasi sopor armeteni suri Iesu eterter nga poro nga ni puloli m̃er nga nevren m̃ikati nen p̃irres renge nabong ne Sapat, ko ngok nir partor sweri nanu san nga parevei Iesu pian re kot suri. ");
INSERT INTO upv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ko Iesu orongwose norrorrmien ser, ko owrai tevi m̃er nga nevren m̃ikati, “Kupmera ta, kupini iel kuptur iel liven womu.” Ko ni otur imare evan otur liven womu. ");
INSERT INTO upv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ko Iesu owrai tevi nir, “Inu numrreni bosusi tevi kami: Renge devjen ne nale nesesreien, erres nga parloli nanu nga m̃irres re nabong ne Sapat? Poro pijki rreknga parloli p̃isij? Erres nga parloli jinibb san p̃irres luwi renge nabong ne Sapat? Poro pijki ko parlokloksi jinibb rrek!” ");
INSERT INTO upv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ko Iesu oklu emteni rrale nir jijle nga martur rrale ni, ko owrai tevi m̃er nga nevren m̃ikati, “Kup̃ete ta nevrem pimetet.” Ko ni ete nevren emetet, ko nevren erres luwi. ");
INSERT INTO upv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ko nir arlolar lengleng ko arsupsup̃e lululweni tevi nir nga parloli sev tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Renge daron nen Iesu otongsa van mare renge botwen nga pulot, ko ni elik rrarren renge ie nutpong san nga mulot van ji Atua. ");
INSERT INTO upv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko daron nga nat m̃irin vajin, ko ni everus jinibb sen nir vini jin; ko ni otobbtobbu tweni nir esngavöl drromon eru nga ni m̃ilngi niser marwajie aposol. ");
INSERT INTO upv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nir le niser ngel: Saemon (nga ni m̃ilngi kele nisen miwajie Pita), ko Antru ni wor tasin, ko Jemes, Jon, Pilip, Batolomiu, ");
INSERT INTO upv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ko Matiu, Tomas, Jemes nga natu Alpeas, Saemon nga mivi pati nga marwera paroji tweni m̃eri Rom nir, ko Jutas nga natu Jemes, ");
INSERT INTO upv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ko Jutas ne Iskariot nga vitunen ko pia-tekai kerasi Iesu. ");
INSERT INTO upv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ko Iesu ojubbul tevi jinibb sen nir vini ngatan e renge numiv san ko otur rengen. Ko jinibb sen elep, ko delung elep ne Jutia ko Jerusalem, ko nga renge jeljeli dis ngalu renge Taea ko Saeton. ");
INSERT INTO upv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nir ngel arini mori jin nga parunge nale sen, ko ni pulolir parres luwi renge mesien ser. Ko lartul nga nem̃in nga marsij marsisilvir, Iesu oji twenir renger ko ololir arres luwi. ");
INSERT INTO upv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Renge meling jinibb nga milep ngel, nir jijle arok-wera parjipari Iesu nga puloli derteren sen pian renger, ko pirpok ko puloli nir jijle parres luwi. ");
INSERT INTO upv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu emteni jinibb sen nir ko owra “Neiren renge kami nga kamivi b̃eres; batun vanu se Atua evi se kami. ");
INSERT INTO upv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Neiren renge kami nga numer m̃iaji kami lelingen ngel; mian ko kami kapa-up. Neiren renge kami nga kamting lelingen ngel; mian ko kapa-ir ko, kapa-men. ");
INSERT INTO upv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Neiren renge kami renge daron nga poro jinibb nir arlesi nga kamivi jinibb se inu Jinibb Mawos, ko arungasi kami vajin, ko arla nale otot tevi kami, ko arsoni tweni kami renge gortien ser, suri bbong inu. ");
INSERT INTO upv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kap̃ir renge nabong nen daron nga nanu ngok nir parpelari, ko kaprowrow e neiren, suri nowli kami elep renge melrin. Suri renge sel mawos ngok ko pa b̃irterawarreng ser arloli tevi propet nga tuwi nir. ");
INSERT INTO upv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ko esij wor elep niko renge kami nga joro kami milep lelingen ngel, suri kamlik pa renge mauren nga mimalum, ko sete kamrongwos kaplik kele mun pirpok re melrin. ");
INSERT INTO upv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ko esij wor elep niko renge kami nga kamup m̃irres lelingen ngel; suri mian ko numer p̃iaji kami. Esij wor elep niko renge kami nga kammen lelingen ngel; suri mian ko kapting ko kaptaur. ");
INSERT INTO upv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Esij wor elep niko renge kami nga jinibb nir marsupsup̃e kami kamrres lelingen ngel, suri apu ser kele tuwi arok-loli sel mawos ngok ko pa tevi propet ne gerisen nir, arsup̃er arwera nawon arres. ");
INSERT INTO upv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ko inu nuwrai tevi kami nga kammurrarronge inu: Kapmerreni devje nuval se kami, kaploli p̃irres tevi nir nga marungasi kami. ");
INSERT INTO upv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kaprij p̃irres tevi nir nga marij m̃isij tevi kami, ko kapverus van ji Atua suri nir nga marungasi kami. ");
INSERT INTO upv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Poro jinibb pisan puwje vasum devjen, ko nik sete kupwuje lweni kele, ko kuplinglingi kele ma vasum devjen tevi puwje kele. Ko poro jinibb pisan p̃ilai tweni kot som, ko kuplinglingi ni p̃ila kele sunsun som. ");
INSERT INTO upv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Kuplai tevi m̃er nga mungonim, ko m̃er nga m̃ilai jorom, sete kupwera p̃ila lweni kele tevim. ");
INSERT INTO upv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Erpe nga kami kammarong nga jinibb parloli nanu tevi kami, ko kami vajin kaploli pirpok tevir. ");
INSERT INTO upv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Poro kami kapmerreni jinibb nga bbong marok-merreni kis kami, ko erpese? Iok sete evi nanu san, suri jinibb nga marsij kele arok-merreni nir nga marok-merrenir. ");
INSERT INTO upv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Poro kapok-loli p̃irres tevi kis bbong nir nga marok-loli m̃irres tevi kami, ko erpese? Iok sete evi nanu san, suri nir nga marsij kele arok-loli kobbong erpok. ");
INSERT INTO upv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ko poro kaplai tevi nir kis bbong nga parkele lweni ko, ko erpese? Iok sete evi nanu san, suri nir nga marsij kele arok-loli bbong erpok tevi nir lululwi nga parok-kele lweni pusorsan. ");
INSERT INTO upv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ko kami ma kapmerreni ko wor devje nuval se kami ko kaploli p̃irres tevir, ko kaplai tevi nir nga sete kaprrorrmi parlai lweni kele. Ko niko kami nowli kami pilep, ko kami kapivi Atua ne Drromsen Mare natun; suri ni erres tevi nir nga sete marok-wera erres tevi, ko nir nga marsij. ");
INSERT INTO upv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kaprrorrmi jinibb nir, pirpe Tata se kami orrorrmir. ");
INSERT INTO upv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Sete kapwer lokloksi jinibb pisan kapwera esij, pijki, ko Atua vajin sete pia-wera kami kamsij. Kami kaptelasi tweni nololien se jinibb m̃inij nir, ko Atua vajin p̃itlasi tweni nololien se kami. ");
INSERT INTO upv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kaplai joro kami tevi jinibb m̃inij nir, ko Atua pia-kele lweni tevi kami; pijvi puwun saut p̃irres, puni van ngatan, pusurrsurrngoni p̃ij p̃irres, pijvi kele puwun saut, ko pimejivjiv nawon vajin.” ");
INSERT INTO upv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ko Iesu owra nale rrongrrongvi m̃inij kele san tevir owra “Metrrorr sete orongwos puwowomue metrrorr piptevi renge sel, ejki. Poro pirpok ko nuru korti pora-vitan van ngatan renge nolo bbulwil! ");
INSERT INTO upv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ko erpok kele, m̃er nga marvisviseni ni sete orongwos p̃iasie jinibb nevisvisenien sen van mare e; pian pijpari wor pusuw ko renge marvisviseni, ko ngok ko ea-sorsan ko vajin tevi jinibb nevisvisenien sen. ");
INSERT INTO upv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ko erpese kumlesi nate nato nga tuwam m̃ikrae re nolo b̃elan, ko sete kulesi suri nate buluk nga milep nga nik kumkerae re nik nolo b̃elam? ");
INSERT INTO upv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ko poro pirpok, ko nik kupwerai pirpese tevi tuwam, ‘Tuwak, kuplinglingi b̃esre tweni nate nato nga kumkerae re nolo b̃elam,’ daron nga nik sete kumleslesi nate buluk nga milep nga nik kumkerae re nik nolo b̃elam? O, nik nga kumiel renge sel eru, tukbböt re aseni ni b̃elan tuloli ni b̃elan turro tiasi! Womujnen kupsere tweni nate buluk nga milep nga nik kumkerae re nolo b̃elam jile pusuw, ko kuplesi nolo b̃elam owokwok erres, ko kurongwos kupa-sere tweni vajin nate nato nga tuwam m̃ikrae mibbölji b̃elan. ");
INSERT INTO upv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nai nga m̃irres san sete orongwos piwen wenen nga m̃isij, ko nga m̃isij sete orongwos piwen wenen nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nai jijle arongwose renge wener. Jinibb sete orongwos pian p̃itawe wene nitapol renge ga moku, ko sete orongwos p̃itawe wene drra renge duru molulu. ");
INSERT INTO upv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ko erpok ko, jinibb nga m̃irres ok-wera tweni nanu nga marres nga mok-rrorrmir marto renge nolon; ko jinibb nga m̃isij ok-wera tweni nanu nga marsij nga mok-rrorrmir renge nolon. Suri sev nga muwun saut renge nolo jinibb, niko marpelpelari renge jingo jinibb mok-wera tutwenir. ");
INSERT INTO upv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Erpese kami kamveruse inu m̃irres, ‘Numal, Numal,’ ko setete kamok-loli suri nanu nga mowrai tevi kami? ");
INSERT INTO upv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nir jijle nga marini jik, ko marunge nale suk nir ko marlolir surie, inu beviseni tevi kami nir arirpe isi. ");
INSERT INTO upv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nir arirpe jinibb san nga m̃ili naim sen renge dan nga m̃iterter m̃irres. M̃ili jile musuw vajin, ko mian ko daron nga naus mus ko nuwi muwlu ko miveji naim nen, ko sete ototo, suri eli pa eterter jile erres. ");
INSERT INTO upv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ko m̃er nga ma murnge nale suk ko sete mulolir, ni erpe m̃er nga m̃ili naim sen renge dan malum; ko sete eli nabur nen nir aran ngatan, arun jipoj nawon. Ko daron nga nuwi muwlu muti naim nen, ko evitan van ngatan, ko omosoksok p̃etp̃eti.” ");
INSERT INTO upv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Daron nga Iesu musuw renge nale sen, ko evel van renge Kapaneam e. ");
INSERT INTO upv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ko renge ie, batu jinibb ne nuval san se m̃eri Rom nir, jinibb ne majingen sen san nga mimrreni milep emsi lengleng, otomori pimij. ");
INSERT INTO upv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ko ni ornge nga Iesu m̃ilik ie, ko ni okoni b̃irterawarreng ne Isrel sopor paran parwerai tevi ni nga ni pivini puloli jinibb sen p̃irres luwi. ");
INSERT INTO upv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ko nir aran ji Iesu ko arngoni tertere nga ni pian, ko arwerai tevi, “Ni evi m̃er nga m̃irres p̃elak. Kupini ko wor kuploli nanu nga muwrai ngel. ");
INSERT INTO upv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ni emrreni jinibb ne vanu se kerr nir, ko ni eli naim ne loten se kerr.” ");
INSERT INTO upv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ko Iesu eptevir aran. Ko daron nga martomori parjipari naim nen, ko batun ne jinibb nuval okoni selen sopor arivel tersele aran jin, nga parwerai tevi, “Numal, sete kuplokloksim. Inu sete nurres nga kupini renge loloim suk. ");
INSERT INTO upv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ko inu kele nurrorrmi sete erres nga inu bevinuk jim. Ko kupwerai bbong nale, ko jinibb ne majingen suk p̃irres luwi. ");
INSERT INTO upv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Suri jinibb nga marlelep renge inu arlingik renge derteren, ko arlingi kele jinibb nuval arlik tevik. Ko poro bowrai tevi nga ngel ‘Kupan,’ ko ni pian ko wor, ko poro bowra tevi nir san kele, ‘Kupini,’ ko ni pivini ko wor; ko poro bowrai tevi jinibb ne majingen suk san, ‘Kuploli nanu ngel’, ko ni puloli ko wor.” ");
INSERT INTO upv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ko Iesu etaol lenglenge nale ngel nir daron nga murnger e. Ko erieni oklu emteni delung nga marvijuri, ko owra “Nuwrai tevi kami, sete nulesi nosurien nga milep mirpel wor san, ejki. Renge Isrel kele ejki rres nawon.” ");
INSERT INTO upv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ko jinibb nga batu jinibb ne nuval nen mukonir arluwi van renge ngaim; ko arlesi nga jinibb ne majingen nen erres pa osuw. ");
INSERT INTO upv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Musuw vajin ko sete epriv ko Iesu evan kele renge ngaim nga welili san nga nisen Naen. Ko jinibb sen nir arpitevi ni, ko delung elep kele wor arpitevi ni. ");
INSERT INTO upv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ko daron nga maran mori renge ngaim nen metali ne naworr nen, ko arlesi jinibb sopor marwosi tweni bipiwarreng san nga mimij, paran partevni. Bipiwarreng wel nen, tasu sen diwen sen emij lingi pa osuw, ko vinnen natun sansan wel nen ko pa. Ko delung elep nga renge ngaim nen arpitevi vinnen. ");
INSERT INTO upv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ko daron nga Numal m̃ilesi vinnen, ko orrorrmi lenglenge, ko owrai tevi owra “Sete kupting te pijki.” ");
INSERT INTO upv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ko oruj van mori ko ejpari drrav nga mimatur rengen, ko jinibb nga marwosi artur murrong tevi. Ko owra “Nanwarreng, nuwrai tevim, kupmera!” ");
INSERT INTO upv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ko m̃er wela nga mimij emra ko elik, ko erij luwi. Ko Iesu ela lweni m̃er wela tevi tasu sen. ");
INSERT INTO upv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ko jinibb jijle nolor arwun saute metutuen. Ko arsurövi Atua arwera “Propet nga milep san otur imare renge livö renge kerr!”, ko arwera kele “Atua evini nga p̃ila mauren tevi jinibb sen nir.” ");
INSERT INTO upv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ko nosp̃en ne sev nga Iesu muloli ngok, jinibb nir arsupsup̃e owlu p̃etp̃eti renge Jutia ko renge vanu jijle nga marto rrerrale ie. ");
INSERT INTO upv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon jinibb sen nir arsup̃e suri nanu ngel nir tevi, ko ni everuse jinibb sen eru orini jin. ");
INSERT INTO upv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ni owrai tevi nuru poran ji Numal porwerai tevi, “Jon owra ‘Nik kuvi pa m̃er nga pivini le, rreknga kem nabtiriv malume san kele wor?’” Ko ni okoni tweni nuru. ");
INSERT INTO upv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Daron nga morini ji Iesu ko orwerai tevi, “Jon Baptaes okoni komru owra nobor-susi tevim, ‘Nik kuvi pa m̃er nga pivini le, rreknga kem nabtiriv malume san kele wor?’” ");
INSERT INTO upv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ko renge daron nen ni ololi nir elep nga marmesi mesien lele nir arres luwi, ko ololi nem̃in nga marsij arivare arwolu lingi jinibb nga marsisilvir, ko ololi nir elep nga meter marrorr arkulkulu luwi erres. ");
INSERT INTO upv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ko ni owra lweni tevi laru nga Jon mukoni nuru, owra “Kopor-vijuri lweni sel se kamru, kopor-luwi ko kopor-werai tevi Jon isev nga komor-lesir ko komor-runger: Metrrorr nir arkulkulu luwi erres, naroj nir arivel luwi erres, niber m̃im̃emaul nir arwokwok luwi, borwon nir arongrong luwi erres, jinibb nga marmij armaur luwi kele, ko b̃eres nir arwerwer renge nosp̃en nga m̃irres tevir. ");
INSERT INTO upv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ko inu nuwrai erpel, neiren renge m̃er nga sete m̃ilesi nanu san renge inu nga puloli ni purnge p̃isij rengen.” ");
INSERT INTO upv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Daron nga jinibb nga Jon mukoni nuru morivel lingir, ko Iesu etipatun osp̃e suri Jon tevi delung nir, owra “Bonevis daron nga kamiel tweni Jon renge lolo merwer e, kamwera kaplesi sev ko? Mavir san nga ling muwi petpate m̃ia? ");
INSERT INTO upv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ia, kaman kamwera kaplesi sev ko? Jinibb san nga muri sunsun nga m̃imau m̃irres? Ejki rres nawon. Lartul nga maruri sunsun nga mirpok araan erres ko arlik renge laut se numal nir. ");
INSERT INTO upv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ia, ko kami kamwera kaplesi sev? Propet san? O-o, ko inu nuwrai tevi kami, ni elep asi wore propet. ");
INSERT INTO upv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","M̃erel ko Naul On muli suri nga Atua muwra ‘Kapmurrong, bokoni jinibb suk san nga puwowomu re Mesaea ko puloli sel se ni pimetet.’ ");
INSERT INTO upv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ko inu nuwrai tevi kami, Jinibb jijle nga mariak renge iel ngatan, sete san elep asie Jon. Ko m̃er nga ma muwelili renge batun vanu se Atua ko, ni elep asi wore Jon.” ");
INSERT INTO upv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ko delung nir ko jinibb nga marok-la nevöt ne takis nir, daron nga marunge ko arir ko arsurövi Atua. Suri nir arpaptaes pa renge baptaesen se Jon. ");
INSERT INTO upv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ko Parasi nir ko jinibb nevisvisenien ne nale nesesreien nir armusus parvijuri sel se Atua nga muloli pa tevir, suri armusus parpaptaes bonevis renge baptaesen se Jon. ");
INSERT INTO upv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Sev ko niko bowra viringsi dul nga lelingen ngel e nir? Ko nir arirpese le? ");
INSERT INTO upv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nir arirpe bipiwarreng sopor nga marlik renge mesa nga m̃irres sopon, ko markikail marververuse seler nir parini jir partetnij; arwera ‘Namuwi nabbu tevi kami, ko kammusus kapsew; ko namla nubo ne mijen, ko kammusus kapting. Kammusus kaptetnij detnijen ne neiren, ko detnijen ne dauren.’ ");
INSERT INTO upv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ko erpok, kami dul nga lelingenok kami kele kammususe murru komru kes, Jon Baptaes ko inu. Jon Baptaes evini ko eaan wowarreng bbong, ko sete ok-mini norro; ko kami kamwera ‘Nem̃in nga m̃isij elik rengen.’ ");
INSERT INTO upv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ko inu Jinibb Mawos nuvini ko nomok-aan ko nomok-minmini norro, ko kami kamwera ‘Kaplesi leorr lep ko lemni kis norro. Ni evi sele jinibb nga marok-la nevöt ne takis nir ko jinibb nga marsij nir.’” ");
INSERT INTO upv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ko Iesu owrai tevir, “Ko norongwosien sete eplari re sel sansan, eplari wor re sel elep ko. Ko komru Jon, komru kes nomor-vijuri.” ");
INSERT INTO upv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ko mian ko Parasi san everuse Iesu nga pian p̃iaan tevi. Ko Iesu evan renge loloim se Parasi nen, ko esakel ngatan ko eaan tevi. ");
INSERT INTO upv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ko nesevin san nga renge ngaim nen nga mauren sen m̃isij ornge nga Iesu m̃ilik renge naim se Parasi nen m̃iaan tevi. Ko vinnen ela botel senta san nga nowlin elep. Ko botel nen arloli nevöt e san nga nisen alapasta. ");
INSERT INTO upv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ko vinnen evini otur renge b̃ela Iesu renge duren ko eting, ko suwen meten arjumjum van renge b̃ela Iesu. Ko ela rao batun ko etwasi b̃ela Iesu e, ko orromji b̃ela Iesu, ko ejvi senta renge b̃elan. ");
INSERT INTO upv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parasi nga miveruse Iesu nga pivini p̃iaan tevi m̃ilesi, ko orrorrmi renge nolon owra “M̃erel poro weretunen pivi propet, ko purongwose ko nesevin nga mirpese le ngel nga mijpari. Nesevin ngel evi vin nga m̃isij!” ");
INSERT INTO upv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ko Iesu owra lweni tevi, “Saemon, inu nuwra bowra nanu le san ngel tevim.” Ko Saemon owra “Numal, kupwerai ko wor.” ");
INSERT INTO upv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ko Iesu owra “Numal san, jinibb eru orloli nivnon jin. Ngok nuru tuwen ela nevöt evi ongut valim (500) jin nga muloli nivnon e. Ko nuru tuwen nen ela nevöt ngavöl elim (50) jin nga muloli nivnon e. ");
INSERT INTO upv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mian ko nuru korti sete orviter nga porkele lweni tevi. Ko ni erres tevi nuru, elinglingi nivnon nen nuru korti orjipon, setemun porkele. Ko renge nuru ngok, nuru ngabes nen ko pimrreni wore ni p̃iasi jer renge nuru?” ");
INSERT INTO upv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saemon owra lweni tevi, “Inu nurrorrmi nganga muloli nivnon mileplep nen ko jin, ni ko pimrreni p̃iasie wor.” Ko Iesu owra lweni tevi, “Kuwra momsawose erres.” ");
INSERT INTO upv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ko ni erieni emteni nesevin ko owrai tevi Saemon, “Kulesi vinel? Inu nuvini renge naim som, ko nik sete kutkaik erres, sete kurrawe b̃elak. Ko vinel ma errawe b̃elak e suwen meten, ko etwasi jomro batun e b̃elak nuru ormes. ");
INSERT INTO upv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nik sete kurromji inu, ko vinel ma daron nga mevini loloim e ko orromji b̃elak, sete omosie. ");
INSERT INTO upv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nik sete kujvi oel renge inu batuk, ko vinel ma ejvi senta nga m̃irresrres asi oel renge inu b̃elak. ");
INSERT INTO upv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ko suri mirpel ngel ko niko nuwrai tevi nik, nololien se vinel nga muwun saut nutlasi twenir pa, niko mimrreni inu milep suri. Ko isi ko nga murrorrmi nololien sen muwelili bbong, poro m̃etlasi tweni ni, pimrreni inu bbong puwelili rrek.” ");
INSERT INTO upv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ko Iesu owrai tevi nesevin nen, “Nololien som nir nutlasi twenir pa osuw.” ");
INSERT INTO upv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ko nir nga marsakel tevi nga maraan tevi arrorrmi lweni e lolor arwera “M̃erel evi jinibb sev le nga orongwos p̃itlasi tweni nololien nir?” ");
INSERT INTO upv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ko Iesu owrai tevi nesevin “Nosurien som ololi nik kumrres luwi. Kupiel, kupluwi renge demat.” ");
INSERT INTO upv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nanu ngel nir arasi osuw, ko renge vitunen sopon vajin ko Iesu otutur sopon evan renge ngaim nga marlelep nir ko renge ngaim nga wewarreng nir. Ko ni ewerwer renge nosp̃en nga m̃irres tevi jinibb nir, ko jinibb sen nir esngavöl drromon eru arpitevi ni. ");
INSERT INTO upv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ko nesevin sopor nga nem̃in nga marsij marivare lingir, ko sopor nga marres luwi pa renge mesien ser nir, ngok Merri ne Maktala, nga nem̃in nga marsij ebut marwolu lingi pa musuw, ");
INSERT INTO upv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ko Joana nesen se Kusa nga mivi jinibb san ne majingen se Numal Erot, ko Susana, ko nesevin elep kele wor nga marok-la joror tevi Iesu ko jinibb sen nir. ");
INSERT INTO upv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mian ko delung elep ne ngaim lele nir arini arkorti ji Iesu. Ko ni owra nale rrongrrongvi san tevi nir, owra ");
INSERT INTO upv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Jinibb nga mok-jijreni jelangin evan nga p̃ijijreni. Ko daron nga m̃ijijreni e, ko jelangin sopor arwij asi van renge dan ne sel e, ko jinibb arivel rer ko arverasi lokloksir, ko numön arow vini ko artasi twenir. ");
INSERT INTO upv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ko sopor kele arwij asi van renge dan ne jerev e; ko daron nga maretiv imare ko armeli ngavilvil, suri lap̃er sete ejpari nuwi te ejki. ");
INSERT INTO upv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ko sopor kele arwij van renge liven ne lolo moku, ko daron nga moku m̃iejal mimaur orer, ko emelngir, sete armaur. ");
INSERT INTO upv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ko sopor ma arwij van renge dan malum nga m̃irres, ko aretiv armaur erres ko arwen, wener ongut (100).” Ko Iesu ekail owra “M̃er nga boron mutoe purnge re nolo boron!” ");
INSERT INTO upv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ko jinibb se Iesu nir arsusi tevi ni, arwera “Nale rrongrrongvi ngel owra puwra isev ko?” ");
INSERT INTO upv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ko ni owrai tevir owra “Kami ma arlai tevi kami nga kaprongwose nanu nga marto teptepi renge batun vanu se Atua. Ko nale rrongrrongvi ma arlai tevi nir jijle ngok nga parlesi, ko sete parlesi wose, ko parunge ko sete parongwose; suri batur eterter ko armusus nolor pulululwi.” ");
INSERT INTO upv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nale rrongrrongvi nen, nile erpel ngel. Jelangin nen evi nale se Atua. ");
INSERT INTO upv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ngok, jelangin nga marwij van renge dan ne sel arirpe jinibb nga marunge nale, ko demij mivini m̃ila tweni renge nolor, nga puloli nir sete parosuri ko sete parmaur. ");
INSERT INTO upv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ko jelangin nga marwij van renge dan ne jerev arirpe jinibb nga marunge nale, ko arir nga parlai. Ko norrorrmien nen nga pirpe lap̃e nai nga purrul totkoni renge nolor ejkie. Arosuri beblen, mian ko sete epriv daron nga nanu nga purrowrrowe mivini, ko arvitan. ");
INSERT INTO upv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ko jelangin nga marwij van renge lolo moku arirpe jinibb nga marunge nale, ko marvijuri suri wor sel ser; ko norrorrmien ser, ko joror nir, ko nanu lele nga marmerrenir renge mauren ser nir armelngir, ko sete arwen e wenen nga marres sopor. ");
INSERT INTO upv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ko jelangin nga marwij van renge dan malum nga m̃irres, arirpe jinibb nga nolon muwretun ko m̃irres, ornge nale ko otori eterter ejpari nga m̃ilai wenen. ");
INSERT INTO upv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Sete jinibb san orrungsi laet ko p̃ila biles piteplis ore e, rreknga p̃ilai p̃ilngi renge melve maling, ejki rres nawon. P̃ilngi ko wor mare renge lat nga mok-jinget rengen. Ko ngok jinibb nga parini renge loloim parlesi moron. ");
INSERT INTO upv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nanu san sete orongwos piteptepi rragrrag nga sete pia-pelari limjer, rreknga nanu tama san nga muto silsilveni nga sete orongwos piplari renge moron, ejki rres nawon. Nanu jile nga marirpok parpelari ko wor renge moron. ");
INSERT INTO upv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kapmetmet renge nale suk nga kami kamok-runger. Poro nga jinibb pisan putor totonir, ko ngok m̃ernen Atua p̃ilai kele ko wor tevi. Ko poro jinibb san setete putori totonir, ko ngok m̃ernen Atua p̃ilai tweni ko ji ni sev nga murrorrmi mutori totoni.” ");
INSERT INTO upv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesu tasu sen ko tasin nir arini nga parlesi ni; ko sete arongwose paran jin mori te ejki, suri nga delung elep p̃elak. ");
INSERT INTO upv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ko arwerai tevi Iesu, “Tasu som le ko tasim, nir le ngel vare armerreni parlesi nik.” ");
INSERT INTO upv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ko Iesu owra lweni tevi nir, “Tasu suk ko tasik nir arivi nir nga marunge nale se Atua ko marosuri.” ");
INSERT INTO upv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mian ko renge nabong san, Iesu owrai tevi jinibb sen nir, “Kerr puwlu asi van renge devje nuwito e.” Ko nir arsa re drrav ko arwolu van. ");
INSERT INTO upv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ko daron nga marwolu e, ko Iesu ematurrwel. Ko ling serser nga milep san etewut eterter vini re nuwito, ko ejpari drrav ser. Ko nuwi ejvijvi van renge nolo drrav, ko dungun elep nga elep; otomori parron, ko nolor opotpot e elep. ");
INSERT INTO upv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ko aran ji Iesu ko arwuni arwera “Numal! Numal! Rrapmij le pa!” Ko ni emra ko ewer ore ling ko daptap ne nuwi nga marbburbbur milep marjivjivi vini re drrav, ko nuru korti ormosi orsuw. Ie omol nawon vajin. ");
INSERT INTO upv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ko Iesu owrai tevir, “Nibeni le nosurien se kami?” Ko nir armetutu ko artaol lengleng, ko arwerwerai tevi nir lululweni arwera “Isi le ngel, ni ewer ore ling ko nuwi ko nuru orunge ni?” ");
INSERT INTO upv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ko nir arwolu toku renge bongsin san renge vanu se m̃eri Gerasa nir renge nuwito. Ko Galili oto luwi van devjen e renge bongsin nen. ");
INSERT INTO upv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ko daron nga Iesu mujubbul mian ngaut e, ko jinibb ne ngaim nen san evel vini ko esewute. M̃ernen demij arsisilvi, ko epriv pa nga sete mun ok-uri sunsun; ko setemun elik renge ngaim, ko ok-lik pa renge dubb ko, lat nga martivtavin e. ");
INSERT INTO upv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ko daron nga m̃ilesi Iesu ko ekail van mare ko ejipa van ngatan renge non, ko erij drrelan ean mare jer owra “Sev som oto ni le iel, nik Natu Atua ne Drromsen Mare? Nungoni tevi nik sete kuplokloksik!” ");
INSERT INTO upv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Owrai erpok suri Iesu owrai pa tevi nem̃in nga m̃isij pivare lingi m̃ernen. Nabong elep bonevis mivini mijpari lelingenok nga nem̃in nga m̃isij mok-wowomue. Ko ewretun jinibb nir arsere nevren nuru ko b̃elan nuru tevi dil delrrurr nir, ko ni ok-rrerrersir armotot. Ko nem̃in nga m̃isij okjeli van lolo merwer e. ");
INSERT INTO upv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ko Iesu osusi tevi, “Nik nisem si?” Ko owra “Delung,” suri demij elep arsisilvi ni. ");
INSERT INTO upv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ko demij nir arngoni tevi Iesu arwera “Warru sete kupkoni kem naban renge bbulwil nga nabbön mijkie, pijki!” ");
INSERT INTO upv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ko renge ie meling b̃erp̃er nga milep san arok-susung bbong renge jeljeli botwen. Ko nem̃in nga marsij arngoni tevi Iesu nga ni p̃ilinglingi nir parsilvi b̃erp̃er nir. Ko ni elinglingir. ");
INSERT INTO upv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ko nem̃in nga marsij arivare lingi m̃er nga ko aran arsilvi b̃erp̃er nir. Ko b̃erp̃er nir arwolu jubbjubbul van renge jeljeli nuwito ko arowrow jubbjubbul van ngatan e renge nuwito, ko arron. ");
INSERT INTO upv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ko daron nga lartul nga maruwngani b̃erp̃er maroka-lesi sev nga miplari, ko arwolu van arwerai renge ngaim nga milep ko ngaim nga wewarreng nen nir. ");
INSERT INTO upv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ko jinibb ne ngaim nen nir arivel tweni van, parlesi isev nga miplari nen. Ko arini ji Iesu ko arlesi m̃er nga nem̃in nga marsij marivare rengen elik ngatan renge b̃ela Iesu. Norrorrmien sen erres vajin, ko ori vajin sunsun. Ko daron nga marlesi, ko nir jijle armetutu lengleng. ");
INSERT INTO upv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ko nir nga marlesi nanu ngel nga Iesu muloli arsup̃e suri tevir erpese nga Iesu muloli pa m̃er nga nem̃in nga marsij marsisilvi m̃irres luwi. ");
INSERT INTO upv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ko nir jijle nga marlik renge Gerasa ko nga marlik rrerrale ie arsurtoni tertere Iesu pivel lingi vanu ser, suri armetutu elep. Ko Iesu evan esa van renge drrav, ko drrav etipatun nga puwlu. ");
INSERT INTO upv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ko m̃er nga nem̃in nga marsij marivare lingi ongoni tevi Iesu nga poro nga ni piptevi ni. Ko Iesu okoni lweni owra ");
INSERT INTO upv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kupluwi van renge ngaim som e, ko kupwera sev nga Atua muloli pa tevim.” Ko m̃ernen evan renge ngaim jile nir ko osp̃e suri sev nga Iesu muloli tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Daron nga Iesu mian mijpari renge devje nuwi e, ko delung nir artur terai ko pa parwera erres tevi ni renge nga mivini, suri nir artiriv ko pa terai. ");
INSERT INTO upv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ko jinibb san nisen Jaeras, evi jinibb nga mok-metmete naim ne loten, ni evini ji Iesu ko ejipa van ngatan renge b̃ela Iesu ko ongoni tertere nga Iesu pivini renge naim sen. ");
INSERT INTO upv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ni natun sansan bbong, ko evi nesevin, sian esngavöl drromon eru. Ko vin wel nen ematur renge maling, otomori pimij pa. Ko daron nga Iesu mian e ko delung elep arvijuri suri ni ko arlilji ni. ");
INSERT INTO upv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ko nesevin san nga mesien se nesevin nir ololi tetajer renge sia esngavöl drromon eru. Vinnen olokloksi p̃etp̃eti joron nir nga m̃ilngir tevi dokta nir, ko sete san orongwos puloli ni p̃irres. ");
INSERT INTO upv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ko vinnen esilvi delung nir renge Iesu duren vitu nen e, ko evini morie, ko ejpari bongsi sunsun sen. Ko ngavilvil mesien nga muloli vinnen drra nen emes evesane. ");
INSERT INTO upv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ko Iesu owra “Isi mijparik?” Ko nir jijle arwera ejki, arvilvil ore. Ko Pita owra, “Numal, delung elep arututir mori nik ko arliljim.” ");
INSERT INTO upv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ko Iesu owra “Ejki, san wor ejparik, suri nurnge renge nibek nga derteren evel lingik.” ");
INSERT INTO upv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ko vinnen elesi nga nanu nga muloli oto pa limjer, ko eririr lengleng ko evan ko ejipa ngatan renge no Iesu, ko ewer telasi renge no delung nir sev ko ololi nga ni mijpari Iesu bongsi sunsun sen, ko erpese nga ni m̃irres ngavilvilsen. ");
INSERT INTO upv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ko Iesu owra tevi, “Natuk, nosurien som ololim kumrres jile. Kupiel renge demat.” ");
INSERT INTO upv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ko daron nga mok-rij malum e, ko jinibb san evel ko ewit lengleng renge naim se Jaeras vini, ko owrai tevi Jaeras, “Natum nesenwarreng emij pa osuw. Kuplinglingi Numal, sete kupkarkar rengen.” ");
INSERT INTO upv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ko Iesu ornge, ko owrai tevi m̃ernen “Sete kupmetutu, sansan kobbong kuposuri, ko nesenwarreng pimaur luwi ko.” ");
INSERT INTO upv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ko daron nga marini renge naim e ko Iesu ewer ore jinibb nir san sete pivijuri van loloim, sansan kobbong Pita ko Jon ko Jemes ko tata se nesenwarreng ko tasu sen wor. ");
INSERT INTO upv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ko jinibb nir artengsi vin wel nen, drrelar elep. Ko Iesu owra “Sete kapting, nesenwarreng sete emij te ejki, ematur kobbong.” ");
INSERT INTO upv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ko lartul nen nir armen keraji e, suri arongwose nga nesenwarreng wel nen emij pa osuw. ");
INSERT INTO upv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ko ni esaro ko orrul re nevre nesenwarreng ko everuse owra “Nesenwarreng, kuptur imare!” ");
INSERT INTO upv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ngavilvilsen mauren sen olwi van rengen ko otur imare. Ko Iesu owrai tevir nga parla nanen sopon tevi purroi. ");
INSERT INTO upv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ko tata sen ko tasu sen bbösa nga milep elai nuru e. Ko Iesu ewer ore nuru nga sete porwerai nanu ngel tevi jinibb pisan, pijki. ");
INSERT INTO upv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ko Iesu everus kortoni jinibb sen esngavöl drromon eru arini korti jin, ko ela derteren tevir nga paroji tweni nem̃in nga marsij nir, ko parloli jinibb nga marmesi nir parres luwi renge mesien ser nir. ");
INSERT INTO upv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","5","Ko ni ewer orer owra “Sete kaptori nanu pisan renge nivelen se kami renge sel, pijki; nejipjip pijki, narr pijki, nanen pijki, nevöt pijki; ko sete kaptori sunsun pieru. Ngabe nga kami kapan rengen, kapan renge naim, ko kaplik renge naim nen ko pa pijpari daron nga kapiel e. Ko poro renge ngaim san jinibb nen nolor p̃iterter, sete parlai kami pijki, ko ngok daron nga kami kapiel lingi ie, erres kapwirrwirrleni tweni maw nga muto re but se kami, nga piviseni tevi nir nga marloli m̃isij.” Ko ni okonir van parwerwer tevi jinibb nir suri batun vanu se Atua, ko parloli jinibb nir nga marmesi parres luwi renge mesien ser nir. ");
INSERT INTO upv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ko nir arivel lingi, aran renge ngaim nir ko arwerwer renge nosp̃en nga m̃irres tevi jinibb nir, ko renge iok jile arloli jinibb arres luwi. ");
INSERT INTO upv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ko Erot Antipas evi numal ne Galili, ko ornge nanu nga marpelari ngok nir nga Iesu mulolir. Ko nolon ekarkare elep, suri ornge jinibb sopor arwera “Ngok Jon Baptaes ko otur imare luwi renge mijen.” ");
INSERT INTO upv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ko nir sopor arwera “Elaeja ko miplari ngok,” ko nir sopor kele arwera “Propet ko san nga tuwi emaur luwi kele.” ");
INSERT INTO upv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ko Erot owra “Jon Baptaes, inu nuta otvi pa batun, ko si kele le ngel, nga inu mornge kele nanu ngel kele nir suri mirpel?” Ko ni emrreni lenglenge p̃ilesi Iesu, p̃ijiljilwer sopon tevi. ");
INSERT INTO upv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ko aposol nir, daron nga marlulwi vini ji Iesu, ko arsup̃e suri sev nga marlolir tevi ni. Ko ni eptevir arsan aran renge ngaim e san nga nisen Betsaeta. ");
INSERT INTO upv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ko delung arongwose, ko arvijuri suri ni; ko ni owra erres tevi nir, ko osp̃e suri batun vanu se Atua tevir, ko ni ololi nir sopor nga marmerreni parres luwi arres. ");
INSERT INTO upv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ko nat erivriv pa otomori nial piwaj pini, ko jinibb sen nir esngavöl drromon eru arini jin ko arwerai tevi ni, “Kupkoni tweni jinibb nir parivel, ko paran renge ngaim nga wewarreng nir ko ngaim nga marlelep nga marto karkar ngok nir, ko parmatur ko parla nanen ser. Suri iel lat nga rramlik e ngel evi lolo merwer le.” ");
INSERT INTO upv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ko ni owrai tevir, “Kami ko kapla nanen tevir parurroi.” Ko nir arwerai tevi, “Kem namtori bbong niv elim ko nai eru. Ko poro pirpok ko kem naban nabwuli nanen ser kele wor, suri delung.” ");
INSERT INTO upv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Suri jinibb elep, evi nuvasngavöl valim (5000) totoklai nga marlik ie marunge nale se Iesu. Ko Iesu owrai tevi jinibb sen nir, “Kaploli jinibb parlik ngatan pivi meling. Ko kaplingi nir pingavöl pilelmi (50) parlik renge meling sisamis.” ");
INSERT INTO upv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ko nir arloli surie erpe nga muwrai ngok, arloli arlik ngatan. ");
INSERT INTO upv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ko Iesu ela niv nga elim nga nir ko nai nga eru nga ko esarrerr imare emteni melrin, ko olot erij erres surir; ko obbri otvi niv nga nir ko nai nga nuru, ko elai tevi jinibb sen nir. Ko nir arlilai tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ko nir jile arurroi, ko nir jile arup. Ko jinibb se Iesu nir arsere lweni bebje niv nga marurroi linglingir ko nai nga marurroi linglingir van renge narr esngavöl drromon eru arwun saut er. ");
INSERT INTO upv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mian ko nabong san Iesu kis bbong oklot, ko jinibb sen nir arini jin. Ko ni osusi tevir owra “Jinibb nir arwera inu nuvi isi?” ");
INSERT INTO upv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ko nir arwera lweni tevi ni, “Sopor arwera Jon Baptaes, ko sopor arwera Elaeja, ko sopor arwera propet nga tuwi san emaur luwi kele.” ");
INSERT INTO upv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Ko kami kamwera inu nuvi isi?” Ko Pita owra lweni tevi ni, “Nik kuvi Mesaea se Atua.” ");
INSERT INTO upv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ko Iesu osur terter tevi nir nga sete parwowrai nale nen tevi jinibb pisan. ");
INSERT INTO upv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ko owra “Jinibb Mawos purnge wor p̃isij ko renge nanu pilep, ko b̃irterawarreng nir, ko batu jinibb ne sulsulen nir, ko jinibb ne nevisvisenien ne nale nesesreien nir parungasi ni, parevji pini. Ko nabong p̃itul ko pimaur luwi kele.” ");
INSERT INTO upv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ko Iesu owrai tevi jinibb sen nir, “Poro jinibb san puwra pivijurik, ni putor ore nanu nga ni bbong mimrreni, ko nabong jile puwosi nai pelaot sen ko pivijurik. ");
INSERT INTO upv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ko poro san puwra putor totoni mauren sen, mian ko pia-tor jabble; ko poro nga san pimaronge mauren sen suri mivijuri inu, ko mian ko pia-lai vajin mauren nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Poro jinibb pisan pia-lai p̃etp̃eti nanu ne iel ngatan ngel nir, ko putor jabble mauren sen pijijki, ko p̃ilesi sev ko p̃irres rengen? ");
INSERT INTO upv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ko isi san poro pimanune inu ko nale suk nir, ni kele Jinibb Mawos pia-manune ni renge daron nga ni pia-vini e renge nosrövien se Tata sen tevi anglo on nir. ");
INSERT INTO upv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nuwretun nuwrai tevi kami, sopor renge kami nga kamtur ngel setewor kaplesi mijen ko kaplesi batun vanu se Atua pivini.” ");
INSERT INTO upv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nabong owil asi osuw, vitunen ko Iesu ela Pita ko Jon ko Jemes arpitevi ni. Ko nir kis arsan artongsa van renge botwen nga ni pulot. ");
INSERT INTO upv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ko renge daron nga mulot e ko non erieni enij kele e, ko sunsun sen owraprap titis. ");
INSERT INTO upv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ko jinibb eru orpelari ie, Moses ko Elaeja, nuru orok-jiljilwer tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nuru orremali renge nosrövien ne melrin, ko orsup̃e suri mijen sen nga otomori piplari Jerusalem. ");
INSERT INTO upv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ko Pita ko laru nga morpitevi armatur pa, suri meter arruwel temijpal. Mian ko artaol ko arkulu vajin van ji Iesu e, ko arlesi nosrövien sen ko laru nga mortur pa tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mian ko laru nga ortipatun porivel lingi Iesu, ko Pita owrai tevi Iesu, “O, Numal, erres ma kem namlik pa iel; kem nabloli gorkoraim p̃itul, san pivi se nik, ko san pivi se Moses, ko san pivi se Elaeja.” Ni owrai ma, ko errerrlenge nale nga muwrai. ");
INSERT INTO upv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ko daron nga mok-rij malum e mok-werai nanu ngel nir, ko nabor san esal vini esalsal orer, ko nir artur vajin renge namol nen. Ko armetutu elep. ");
INSERT INTO upv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ko renge nabor nen drrelan san eplari rengen owra “Ni evi natuk nga memrreni, ko ni ko motobbtobbue. Kami kaprunge ni.” ");
INSERT INTO upv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ko renge daron nga drrelan musuw, ko arlesi Iesu esan vajin. Ko sete arwowra nanu ngel tevi jinibb san renge nabong nen nir, armurrarrong ore ko pa. ");
INSERT INTO upv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ko renge mevinen vajin nir arjubbul renge botwen, arluwi vini ngatan e. Ko delung elep arivel ore arini jin arlesi. ");
INSERT INTO upv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ko jinibb ne delung nen san everus owra “Jinibb nevsivsenien, natuk sansan welel le pa, ko nungoni nik, warru kupini kuplesi ni ta. ");
INSERT INTO upv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ko kuplesi, nabong sopon nem̃in san esilvi ni, ko enger nga enger lengleng, ko eririr nga eririr ko melabbsen eia. Ko nem̃in nen eterter elep renge nga pivare lingi ni, ko ololi niben arerer elep. ");
INSERT INTO upv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ko nungoni jinibb som nir paroji tweni, ko sete arongwos parloli.” ");
INSERT INTO upv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ko Iesu owra lweni tevir, owra “O, aro, kami dul ngel nosurien se kami ejkie! B̃elik tevi kami pijpari wor seveling, ko bololi nanu tevi kami?” Ko owrai tevi m̃ernen, “Kuptekai natum vini iel ta.” ");
INSERT INTO upv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ko m̃er wel nga daron nga mivel malum e vini, ko nem̃in nga evivivrrule elep ko ololi ewajeni lenglenge ngatan, ko ololi niben aririr elep. Ko Iesu otortori nem̃in nga m̃isij nen ko ololi m̃er wel nga erres luwi, ko ela lweni tevi tata sen. ");
INSERT INTO upv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ko nir jile bbösa nga milep elair e suri nanu nga mulolir renge derteren nga milep se Atua. Ko daron nga bbösa milair malum e suri nanu nga mulolir ngel nir, ko Iesu owrai tevi jinibb sen nir, owra ");
INSERT INTO upv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nale nga bowrai ngel nir, kaplingi pian renge nolo boro kami nir ko kaprrorrmir. Inu Jinibb Mawos partekai inu van renge nevre jinibb nir.” ");
INSERT INTO upv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ko jinibb sen nir arrelenge nale nga Iesu muwrai ngel lat nga muto suri. Atua esilveni renger nga sete parongwose, ko nir armetutue parsusi lweni tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ko jinibb se Iesu nir arok-rij latlat lulweni tevir suri isi pivi jinibb nga milep jer renge nir. ");
INSERT INTO upv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ko Iesu orongwose sev nga muto renge nolor, ko etkai bipiwarreng nga welili san ko elngi otur renge nelin devjen. ");
INSERT INTO upv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ko ni owrai tevir, “Isi nga p̃itkai bipiwarreng nga welili san nga mirpel ngel renge inu nisek, ko erpe etkai inu ko pa. Ko isi nga m̃itkai inu, erpe sete etkai inu ko, ko etkai ni nga mukoni inu ko. M̃er nga mivi jinibb nga welili jer nen renge kami, ko ngok ni ko evi jinibb nga milep jer nen.” ");
INSERT INTO upv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ko Jon owrai tevi owra “Numal, namlesi jinibb san oji tweni demij san renge jinibb san renge nik nisem. Ko namwer ore, suri nga ni sete evijuri kerr.” ");
INSERT INTO upv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ko Iesu owrai tevi ni, owra “Sete kapwer ore ni. M̃er nga sete m̃itre kami, ko ngok ni evi kamikami ko.” ");
INSERT INTO upv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mian ko otomori nabong nga Atua p̃itka lweni Iesu van mare e renge melrin, ko ni elngi non eterter evijuri sel van renge Jerusalem e. ");
INSERT INTO upv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ko Iesu okoni wowomu ngarre jinibb sopor nga marivi ni non, ko nir arivel aran renge ngaim san se m̃eri Sameria nir nga parloli lilane ngarre tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ko nir armusus nga ni pivini renge vanu ser, suri ni elngi non emawos van Jerusalem e. ");
INSERT INTO upv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ko daron nga jinibb sen ngel nuru Jemes ko Jon morunge, ko orwerai tevi, “Numal, kumarong komru nobor-werai nabb pivel renge melrin vini p̃ianir?” ");
INSERT INTO upv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ko ni erieni ko otortori nuru. ");
INSERT INTO upv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ko nir setemun aran re ngaim nen, arivel asie van renge ngaim m̃inij kele e san. ");
INSERT INTO upv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ko daron nga marivel suri sel malum, ko jinibb san evini ko owrai tevi Iesu, “Ngabe tama nga poro kupa-van e, ko inu bevijuri nik ko wor.” ");
INSERT INTO upv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ko Iesu owrai tevi, “Guli rrum nga wowarreng nir b̃elaur otoe, ko numön nir menuner otoe; ko inu Jinibb Mawos milngek ejkie. Ngok, kuprrorrmi mun p̃irres poro nga kumrreni kupvijuri inu.” ");
INSERT INTO upv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ko mian ko Iesu owrai tevi jinibb m̃inij nen san, “Kupvijuri inu!” Ko m̃ernen owrai lweni tevi owra “Numal, kuplinglingik mun bean betevni tata suk puwomu.” ");
INSERT INTO upv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ko Iesu owrai tevi m̃ernen owra “Kuplinglingi lartul nga sete marla mauren ko pa partevni nir nga marmij ser, ko nik kupan kupwerai batun vanu se Atua tevi jinibb jile nir.” ");
INSERT INTO upv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ko nir m̃inij nen san owrai tevi, “Bea-vijuri nik ko, Numal; ko kuplinglingik mun puwomu bean beremse nir nga marlik renge naim suk.” ");
INSERT INTO upv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ko Iesu owrai tevi, “Jinibb nga m̃iale drrav puklu van womue tetajer, sete puklu vitu kele. M̃er nga mirpok sete erres renge batun vanu se Atua.” ");
INSERT INTO upv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Vitunen renge nanu ngel nir marsuw vajin, ko Numal otobbtobbue nir m̃inij kele sopor arivi jinibb sen. Nir ngavöl ebut drromon eru, ko ni okoni tweni nir ererwi arivel arwowomu renge ni van renge ngaim ko vanu jile nga ni pia-vivitu van renger. ");
INSERT INTO upv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ko owrai tevir, “Lelingen ngel evi daron ne numös nga milep, ko jinibb nga marmajing rengen nir ewelili jer. Ko ngok kami kaplot, kapngoni p̃iterter tevi Numal ne numös nga ni pukoni kele jinibb ne majingen sen sopor nga parmajing renge orsel ne numös sen. ");
INSERT INTO upv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kapiel, ko kaprongwose nga inu nukoni tweni kami kamsan kis kamirpe natu sipsip nir renge sel, paran renge livö ne guli rrum nir. ");
INSERT INTO upv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sete kaptori baos rreknga narr rreknga but se kami, pijki; ko sete kaprij tevi jinibb pisan renge sel, pijki. ");
INSERT INTO upv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ko renge naim ngabe nga kami kapan renge loloim nen, nanu womujnen nga kapwerai kapwera ‘Demat puto renge naim ngel.’ ");
INSERT INTO upv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ko poro jinibb ne demat san p̃ilik renge naim nen, ko ngok demat se kami pijpon jer jin. Ko poro pijki, ko ngok pulwi kele vini ji kami e. ");
INSERT INTO upv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ko renge naim mawos nen ko pa kami kaplik malum pa rengen ko. Sete kapan kele renge naim lele e nir, pijki. Ko kaprro nanen sev ko kapmini nuwi sev nga marlair tevi kami. Suri erres nga jinibb ne majingen p̃ila nowlin. Sete kapan renge naim ko naim. ");
INSERT INTO upv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ko renge ngaim ngabes nen nga kami kapa-pelari rengen, ko poro jinibb nen nir parir nga partekai kami kapan jir, ngok kami kapurroi sev nanen ko nga nir parlair parlingi renge no kami. ");
INSERT INTO upv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ko kami kaploli jinibb nga marmesi renge ngaim nen parres luwi renge mesien ser. Ko kapwerai tevi nir jile, ‘Lelingen ngel batun vanu se Atua evini mori pa vajin ji kami.’ ");
INSERT INTO upv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ko renge ngaim ngabes nen nga kami kappelari rengen, ko poro jinibb nen nir sete parmarong nga partekai kami van jir nga kaplik tevir, ko ngok kapivare kapini renge sel ne ie ko kapwera ");
INSERT INTO upv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Erpe maw kele ne ngaim se kami nga mibbölji b̃ela kem, namtewasi twenir etre kami. Ko kaprongwose mae nanu ngel: Batun vanu se Atua evini mori pa ji kami.’ ");
INSERT INTO upv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nuwrai tevi kami, renge daron nga Atua pia-wera suri lat nga puto suri re jinibb jijle, ko pia-sij wor pilep renge nir ne ngaim ngok pia-asie Sotom. ");
INSERT INTO upv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Wi kami m̃eri Korasin! Wi kami m̃eri Betsaeta! Kami nga kamok-ungasi jinibb ne vare nir, erpe m̃eri Taea ko m̃eri Saeton nir. Ko poro nga nelesien ngel nir nga mololir ngel nir nga kami kamlesir, poro parlolir pa renge Taea ko Saeton, ko jinibb ne iok nuru, nolor pululwi pa tuwi nen renge nololien ser, ko paruri sunsun tera nga marmerrmerris nir, ko parlik renge niavi nabb parp̃elpalos e, parviseni nga arrorrmi nanu nga marsij nga marloli sarrsarre nir. ");
INSERT INTO upv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Niko renge daron nga jinibb jile nir ne iel ngatan, Atua pia-wera suri lat nga puto suri rer, ko pia-tor vitrangi kami p̃iasie nga putor vitrangi m̃eri Taea ko Saeton. ");
INSERT INTO upv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ko kami m̃eri Kapaneam nir, kami kamok-wera kami ma kamrres kapan renge melrin, ko ejki rres nawon. Kami parwirr tweni kami van renge bbulwil nga nabbön mijkie.” ");
INSERT INTO upv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ko ngok Iesu owrai tevi jinibb sen nir owra “M̃er nga murnge kami ko ngok erpe ornge inu ko, ko m̃er nga mungasi kami ko ngok erpe ongasi inu ko. Ko m̃er nga mungasi inu ko ongasi m̃er nga mukoni inu ko.” ");
INSERT INTO upv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ngok nir ngavöl ebut drromon eru (72) arlulwi vini tevi neiren nga milep, ko arwerai tevi Iesu, “Numal, demij kele nir arunge drrela kem ko arloli nanu nga namwerair renge nik nisem.” ");
INSERT INTO upv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu owrai tevir “Ok-irpok, ko inu numteni renge metek daron nga demij muwlu lingi melrin erpe navil evil.” ");
INSERT INTO upv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ko Iesu owrai kele tevir, “Kaplesi, inu nulai pa derteren tevi kami osuw. Asi p̃etp̃eti derteren se demij nir. Ko ngok niko, kami kamrongwose kapverasi num̃et ko netu num̃et, ko nanu san ejki rres nawon nga orongwos pulokloksi kami. ");
INSERT INTO upv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ko niko sete kap̃ir suri nga nem̃in nga marsij marloli nanu nga kamwerair, ko kap̃ir ma suri nise kami Atua olir renge naul ne melrin.” ");
INSERT INTO upv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Renge wosenen, Nem̃in On ololi Iesu nolon owun saute neiren, ko owra “Tata, nuwra erres tevi nik, O Tata Numal ne melrin ko iel ngatan, nga nik kumloli nanu ngel nir marto teptepi renge jinibb nga norongwosien ser milep ko nir nga marongrongwos milep, ko kuviseni tevi nir nga marivi bipi kobbong. Niko Tata, erpe erres ko wor renge nom.” ");
INSERT INTO upv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ko owra “Tata suk ela nanu p̃etp̃eti nir tevik, ko sete san orongwose rragrrage norrorrmien se inu, natun mawos. Tata suk kobbong esan bbölbböl orongwose. Ko sete san orongwose Tata suk, inu kobbong nga mevi natun mawos, ko nir nga inu motobbtobbue nir, nir kele arongwose.” ");
INSERT INTO upv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ko Iesu erieni mawose jinibb sen nir ko owra malum bbonge tevi nir kis bbong arunge, owra “Neiren renge nir nga marlesi meter e nanu nga kami kamlesir ngel nir. ");
INSERT INTO upv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nuwretun nuwrai tevi kami, propet elep, ko numal nga marlelep owun saut armerreni parlesi nanu ngel nir nga kami kamlesir ngel, ko setete arlesir te, ko arwera parunge nanu nga kami kamrunger ngel, ko setete arunger te.” ");
INSERT INTO upv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ko jinibb ne nevsivsenien ne nale nesesreien san otur mera ko owra purrowrrowe Iesu, owra “Numal, inu bololi isev ko, ko b̃ela mauren nga muto tuwi ngok vini?” ");
INSERT INTO upv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ko Iesu owra lweni tevi, “Naul On owra sev re iok? Kueve kulesi owra erpese?” ");
INSERT INTO upv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ko m̃ernen owra lweni tevi Iesu, “Ko Naul On owra ‘Nik kupmerreni Numal Atua som tevi nolom totoklai, ko mauren som totoklai, ko derteren som totoklai, ko tevi norrorrmien som totoklai; ko kupmerreni selem pirpe nik mawos.’” ");
INSERT INTO upv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ko Iesu owra lweni tevi m̃ernen, “Nik kuwrai erres p̃elak ko; ko nik kuploli pirpok ko, ko kuplai mauren nga muto tuwi ngok vini.” ");
INSERT INTO upv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ko jinibb nevisvisenien ne nale nesesreien emrreni wor piviseni nga ni mumomsawos, ko osusi kele tevi Iesu owra “Ko isi ko evi selek nen?” ");
INSERT INTO upv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ko Iesu owra lweni tevi renge nale rrongrrongvi ngel: “Jinibb san ojubbul Jerusalem van ngatan e Jeriko. Ko daron nga mivijuri sel mivini ko etaole jinibb venao nir marpelari jin. Ko arrul totoni ko arla joron nir, ko arevji emijmij, ko arivel lingi ematur jer renge jeli sel otomori pimij. ");
INSERT INTO upv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mian ko sete epriv ko jinibb ne sulsulen san ojubbul kele renge sel nen vini. Mivini ko elesi m̃ernen; ko etalev van renge devje sel e, ko easie evel lingi. ");
INSERT INTO upv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ko erpok kele renge Livaet san. Ni kele evini, evini kele renge lat nen ko elesi m̃ernen kele. Ko etalev kele van renge devje sel e, ko asie evel lingi. ");
INSERT INTO upv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vitunen vajin ko m̃eri Sameria san evel vini evijuri sel nen kele. Mivini renge lat nen, ko elesi m̃ernen mimatur mutomori pimij, ko orrorrmi lenglenge. ");
INSERT INTO upv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ko evan jin, ko ela oel ko norro, etwasi vaseni niben nga marmetmetvir e nir ko ekai orer. Ko owosi elngi esakel mare renge dongki sen, ko elai van renge naim san nga marok-mosi rengen, elngi elik rengen ko emetmete. ");
INSERT INTO upv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ko renge mevinen renge rorpong susu nen vajin, ko oroni tweni nevöt sopor ko elair tevi m̃er nga naim sen nen, ko owrai tevi, ‘Kupmetmete m̃erel ko pa iel. Ko poro nga kupa-lokloksi kele nevöt som sopor rengen, ko ngok daron nga bea-luwi vini ko bea-kele lweni tevim.’” ");
INSERT INTO upv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ko Iesu owrai tevi m̃er nga mususi tevi nga, owra “Nik renge norrorrmien som, kurrorrmi erpese renge nir nga itul ngok? Kurrorrmi nir si nen ko erpe pivi selen e m̃er nga jinibb venao marevji ngok?” ");
INSERT INTO upv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ko m̃ernen owra “Rrek m̃er nga murrorrmi ni nen ko.” Ko Iesu owrai tevi m̃ernen, “Kupiel, ko kupan kuploli pirpok.” ");
INSERT INTO upv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ko nir artutur suri sel ko arini renge ngaim san. Ko nesevin ne ie san, nisen ewajie Marta, vinnen etkair aran renge naim sen. ");
INSERT INTO upv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ko vinnen tasin san nisen ewaji Merri. Ko Merri nen evini ko elik ngatan ji Iesu morie b̃elan, ko omurrarrong nale se Iesu nir. ");
INSERT INTO upv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ko Marta ornge esij e nga majingen milep, ko ni bbong m̃isan m̃iplaker. Ko evini ji Iesu ko owrai tevi, “Numal, sete kurrorrmi nga tasik mivel lingi inu, ko inu bbong m̃esan m̃eplak? Kupwerai tevi ni pivini piptevi inu.” ");
INSERT INTO upv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ko Numal owra lweni tevi, “Marta, Marta, nik kurnge esij suri nanu elep p̃elak ko pa ngok. ");
INSERT INTO upv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ko nanu sansan kobbong erres temijpal. Ko ngok niko Merri otobbtobbue ngel, nga sete san orongwos p̃ilai tweni kele jin.” ");
INSERT INTO upv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nabong san Iesu esan evan olot renge lat san. Ko daron nga musuw vajin ko olwi vini ji jinibb sen e nir. Ko jinibb sen san owrai tevi, “Numal, kupvisviseni kem e loten, pirpe Jon mivisviseni jinibb sen e nir marok-lot.” ");
INSERT INTO upv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ko Iesu owrai tevir, “Daron nga kami kaplot e ko kapwerai pirpel: ‘Tata se kem, nisem on. Nammerreni jinibb jijle nir partorim p̃irres. Nammerreni nik batun vanu som pivini iel ngatan. ");
INSERT INTO upv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ko kuplai nanen pivtere kem lelingen, nabaani. ");
INSERT INTO upv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ko kuptelasi tweni nololien se kem nir, pirpe kem namtelasi tweni nololien se nir nga marloli m̃isij tevi kem. Ko sete kuploli nanu parini parrowrrow p̃elake kem.’” ");
INSERT INTO upv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ko Iesu owra tevir, “Kami si poro selen otoe ko pia-van ji selen nen nat nga m̃irrang vajin, ko puwrai tevi, ‘Ai sile, kupla pa niv p̃itul tevik. ");
INSERT INTO upv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Suri selek san otutur vini jik eatur vitan ni le, ko nanen nga namrro lingi sete sopon ojpon jer nga b̃elai tevi purroi.’ ");
INSERT INTO upv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ko selen nga m̃ilik loloim nen puwrai lweni tevi, ‘Sete kupvijajeng rengek, nuplaji ore pa metali osuw, ko kem natuk nir nammatur pa renge milnge kem osuw. Setemun nurongwos bemra b̃ela nanu san tevim.’ ");
INSERT INTO upv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nuwrai tevi kami, ewretun evi selen nga m̃irres, ko pumusus ko nga pimra p̃ilai tevi. Ko suri bbong mungoni malume m̃iterter, mian ko ni pimra ko p̃ilai tevi pusorsan tevi nga m̃ernen mimrreni. ");
INSERT INTO upv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ngok niko inu nuwrai tevi kami, Kapngoni, ko Atua pia-lai ko tevi kami. Kappej, ko Atua pia-loli kaplesi ko. Kapututi, ko Atua pia-tasi metali nen tevi kami. ");
INSERT INTO upv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Suri nir jijle nga marok-ngoni para-lai, ko nir jijle nga marok-pej para-lesi, ko nir jijle nga marok-ututi metali, para-tasi metali nen p̃itp̃ir tevir. ");
INSERT INTO upv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kami si nga mivi tata, poro natun pungoni niv tevi, ko ni p̃ila nevöt tevi purroi? Rreknga poro pungoni mesal tevi, ko ni setemun p̃ila mesal nen tevi, ko p̃ila num̃et tevi purroi? ");
INSERT INTO upv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Rreknga poro pungoni narrlu nato tevi, ko ni p̃ila netu num̃et tevi? Ejki rres nawon! ");
INSERT INTO upv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ia ko kami kamivi jinibb nga marsij nir, ko kami kamrongwose kobbong nanu nga marres nir nga kapa-lair tevi natu kami nir. Ko ngok Tata se kami nga m̃ilik renge melrin, ni asi wore tata se kami nir. Ko ni pia-lai Nem̃in On tevi nir nga marngoni tevi ni.” ");
INSERT INTO upv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nem̃in nga m̃isij san evi nabbut, ko esilvi jinibb san ko ololi m̃ernen sete ok-rongwos pok-rij. Ko daron nga Iesu muoji tweni nem̃in nga m̃isij nen renge m̃ernen, ko m̃ernen erij luwi vajin. Ko delung artaol lenglenge. ");
INSERT INTO upv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ko jinibb sopor arwera “Bielsepul ko, numal se demij nir, ela derteren ngok tevi, niko mok-oji tweni demij nir ngok e.” ");
INSERT INTO upv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ko nir sopor arrowrrowe ni arpej nelesien ne melrin renge ni nga puloli parlesi. ");
INSERT INTO upv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ko Iesu orongwose norrorrmien ser ko owrai tevir, “Poro batun vanu san p̃iteri wukari p̃ieru e, ko pipalpal luwi tevi ni, ko sete orongwos putur te. Ko poro metka san p̃iteri wukari p̃ieru e ko p̃itre lweni ni, sete liken sen orongwos p̃irres te renge nabong pisan. ");
INSERT INTO upv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ko ngok poro Demij p̃iteri wukari pieru e ko p̃itre lweni ni, ko batun vanu sen putur pirpese? Suri kami kamwera inu nuoji tweni demij nir renge derteren se Belsipa. ");
INSERT INTO upv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ko poro nga weretunen inu nomok-oji tweni demij nir renge derteren se Belsipa, ko kami natu kami nir arok-oji tweni demij nir renge derteren se isi? ");
INSERT INTO upv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ko weretunen inu nomok-oji tweni demij nir renge Atua nevren ne derteren, ko ngok niko batun vanu se Atua evini pa ji kami ko osuw. ");
INSERT INTO upv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Daron nga jinibb nga m̃iterter mutori joro nuval sen nir mutur metmete naim sen, ko ngok joron nir arto erres malum renge naim sen. ");
INSERT INTO upv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ko daron nga jinibb nga m̃iterter asie m̃ernen mivini ko epalpal tevi m̃ernen mianan ko oji tweni, ko ngok ela joro nuval sen nir nga ni m̃ilngi nolon renger, ko ela joro m̃ernen, ko owluwlu tevi selen nir. ");
INSERT INTO upv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“M̃er nga sete miptevi inu, m̃ernen etre inu ko, ko m̃er nga sete miptevik nomorser kortoni jinibb nir, oji tututwenir ko. ");
INSERT INTO upv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nem̃in nga m̃isij san daron nga mivare lingi jinibb san ko evel p̃etp̃eti renge lat nga nuwi mijkie nir, epejpej lat san nga pumosi rengen. Ko poro sete elesi lat san, ko owra ‘Bolwi kele wor van renge naim suk nga meivare ren nga mevel lingi.’ ");
INSERT INTO upv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ko renge daron nga pulwi vini e, ko p̃ilesi nga aruraki vaseni pa loloim nen erres, ko arlingi nanu jile nir arto jile pa erres rengen. ");
INSERT INTO upv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ko nem̃in nga m̃isij nen pian vajin ko p̃ilesi kele nem̃in nga marsij ebut nga marsij asi wore ni, ko piptevir parluwi van parsilvi lweni m̃ernen. Ko m̃ernen mauren sen nga vitunen p̃isij p̃erp̃er vajin p̃iasi nga womunen.” ");
INSERT INTO upv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Daron nga Iesu muwra jile nanu ngel e nir musuw, ko nesevin san nga nir delung marlik erij drrelan elep van mare owra “Neiren renge nesevin nga mivesi nik, ko m̃ila nasus tevim kumsus rengen.” ");
INSERT INTO upv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ko Iesu owra “Rrek erpok ko, ko mare renge iok, neiren renge nir nga marunge nale se Atua ko martor totonir kele renge nolor.” ");
INSERT INTO upv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Delung elep nga elep arini korti ji Iesu, ko Iesu owra “Dul ngel arivi dul nga marsij, ko armerreni parlesi nelesien. Ko ejki rres nawon, sete mea-la mun san tevir. Sansan kobbong, nelesien nga miplari ji propet Jona tuwi. ");
INSERT INTO upv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Erpe Jona evi nelesien se m̃eri Nineve nir tuwi, ko ngok pirpok ko Jinibb Mawos pivi nelesien se dul nga lelingen ngel nir. ");
INSERT INTO upv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ko nesevin nen nga mivi numal nga milep renge Saot pia-tur imare tevi jinibb ne dul ngel nir renge nabong nga Atua pia-wera suri lat nga puto suri tevi jinibb nir, ko pia-wer lokloksi bbong nir, puwra ‘O, kaplesi, inu nuvel renge bongsi vanu vini nga bornge norongwosien se Solomon, ko erpese kami sete kamrunge nale se san nga milep asi wor Solomon, ko m̃ilik tevi kami bbong?’ ");
INSERT INTO upv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ko renge nabong nga Atua pia-wera suri lat nga puto suri tevi jinibb nir, m̃eri Nineve nir para-tur imare ko tevi dul ngel nir ko parongwos parwer lokloksi bbong sel se kami nir, parwera ‘O, kaplesi, daron nga namrunge Jona m̃iwerwer e tuwi, ko nolo kem olululwi renge nololien se kem nir. Ko erpese kami nolo kami sete olululwi daron nga kamrunge san nga milep asi wor Jona m̃iwerwer tevi kami?’ ");
INSERT INTO upv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Sete jinibb san osli jile nasul osuw mian ko otori ngatan, ejki; putori mare sopon, ko puloli jinibb jile parlesi moron. ");
INSERT INTO upv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","35","Mete jinibb erpe moron ne niben. Poro nga metem p̃im̃erer, ko moron puwun saut re nibem totoklai. Ngok owra puwra, poro nga nolom p̃irres, ko mauren som totoklai kele p̃irres. Ko poro nga metem p̃isij, ko nemalik puwun saute nibem totoklai, suri metem erpe moron ne nibem. Ngok owra puwra, poro nga nolom pukul, ko mauren som totoklai kele p̃isij jile. ");
INSERT INTO upv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ko poro mauren totoklai se kami parwun saute moron, ngok pimor vaseni p̃etp̃eti mauren se kami ko, sete lat sopon mara-jipon jer.” ");
INSERT INTO upv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Daron nga Iesu m̃irij jile musuw vajin, ko Parasi san ongoni ni, owra ni pian p̃iaan tevi ni. Ko Iesu evan loloim esakel eaan. ");
INSERT INTO upv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ko daron nga Parasi nen m̃ilesi mirpok, ko bbösa nga milep elai ni e suri. Suri nga Iesu sete ejejavöl owomu mian ko vitunen ko ni pia-aan. ");
INSERT INTO upv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ko Numal owrai tevi m̃ernen, “Kami Parasi kamok-rrawe vare ne biles nir ko plet nir, ko renge nolo kami nir arwun saute nanu nga marsij nir. ");
INSERT INTO upv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","O kami nga kamlengleng temijpal, sete kamrrorrmi nga Atua nga muloli vare nen e, ni kele kobbong ololi nolon e? ");
INSERT INTO upv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kami kapla nanu nga marto renge nolo biles se kami ko nolo plet se kami tevi b̃eres nir, ko nanu jile nir parwokwok vajin ji kami. ");
INSERT INTO upv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Wi kami Parasi nir, pia-sij wor pilep niko renge kami, suri kami kamok-p̃elak milep suri nanu nga marp̃er jer, ko nanu nga marlelep nir nga moro kaplolir, kamlingi kurtwenir. Suri kamok-p̃elak suri nanu nga marp̃er jer, erpe roi warreng nir erpe min ko ru, nga kapeveve p̃etp̃etir, ko kamla tweni songovlör nga kaplair tevi Atua. Ko erpok erres kobbong kaploli; ko nanu nga m̃isij nen evi nga kamlingi kurtweni nanu nga marlelep nir, erpe murrun mawos ko merrenien nga kapmerreni lenglengen Atua. ");
INSERT INTO upv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Wi kami Parasi nir, pia-sij wor pilep niko renge kami. Kami kammerreni kapok-sakel renge nai seksekal nga mare nir renge loloim ne naim ne loten nir, ko kammerreni jinibb partori kami daron nga marsekai kami re lat ne nanen. ");
INSERT INTO upv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wi pia-sij wor pilep niko renge kami. Kamirpe dubb nga sete marusi ore nivev rer, marto kiskis nawon, ko jinibb sete marongrongwos rragrrag nir; ko marivel rer marbbötbböt rer, ko ololi arrokitkit p̃etp̃etie.” ");
INSERT INTO upv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ko san renge jinibb ne nevisvisenien ne nale nesesreien owra lweni tevi Iesu owra “Jinibb nevisvisenien, daron nga kumwera nale ngok e nir, ko ngok kulokloksi kem kele.” ");
INSERT INTO upv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ko Iesu owra “Wi pia-sij wor pilep niko renge kami kele jinibb ne nevisvisenien ne nale nesesreien nir, suri kami kamok-jingteni nanu nga marrow milep renge birpari jinibb nir nga sete marongwos parwosi luwer, ko kami ma kammusus lengleng kapjipari majingen ser sopon. ");
INSERT INTO upv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wi pia-sij wor pilep niko renge kami, suri kamok-juroi dobbi propet nga tuwi nir, nga tata se kami nir marevji pinir marmij. ");
INSERT INTO upv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iok kamviseni emawos nga kami kele kamkorti renge majingen nga marsij se tata se kami nir. Suri nir arevji pinir, ko kami vajin kamok-juroi dobbir. ");
INSERT INTO upv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ko erpok Atua osp̃e suri pa renge norongwosien sen owra ‘Bea-koni propet nir ko aposol nir vini jir, ko nir sopor parevji pinir, ko nir sopor parloli p̃isij tevir parojir.’ ");
INSERT INTO upv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ko niko drra propet jile nir nga apu se kami nir marevji pinir tuwi, kami ko dul ngel kapa-la norongen nga m̃isij nen. ");
INSERT INTO upv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nuwretun nuwrai tevi kami, m̃itipatun renge drra Apel, mivini mijpari drra Sekaraea nga marevji renge Naim On se Atua renge livö ne nawot ko lat nga muon. Nuwretun nuwrai tevi kami, kami ko dul nga lelingen ngel, kapa-la norongen nga m̃isij ne nanu ngok jile nir vajin. ");
INSERT INTO upv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Esij wor elep niko renge kami jinibb ne nevisvisenien ne nale nesesreien nir, suri kami kamkikiore metali ne norongwosien ko kamsilveni ki nen. Ko kami kele sete kaman renge loloim nen, ko kamok-wer ore jinibb nir nga marwera paran renge loloim nen.” ");
INSERT INTO upv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mian ko Iesu evel lingi naim nen, ko jinibb nevisvisenien ne nale nesesreien nir ko Parasi nir arij esij tevi ko arsusi nanu elep. ");
INSERT INTO upv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nir arok-teravi Iesu nga poro puwra jabble nale pisan nga nir parlai ni rengen. ");
INSERT INTO upv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Renge daron nen meling jinibb nga milep arini arser korti ji Iesu renge lat san. Nir evi nuvasngavöl vavis kis wor, ko artur lililjir p̃elak nir, ko arbbötbböt renge drrun b̃elar. Ko Iesu owra womue tevi jinibb sen nir owra “Kami kapmetmet ko wor renge is se Parasi ngel nir, renge murrun nga sel ser eru ngok e. ");
INSERT INTO upv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ko nanu jile nga jinibb martawi ore nir, mian ko Atua piraji vasenir parto limjer. Ko nanu jile nga jinibb marsilvenir, mian ko Atua pulolir parto limjer, jinibb parongwoser. ");
INSERT INTO upv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ko nanu jile nga kami kamok-sup̃er renge nat nga mupong, mian ko Atua puloli nga jinibb parsup̃er renge nat nga m̃irin. Ko nanu jile nga kami kamok-sur vijvije renge boro jinibb nir renge loloim, mian ko parkaile parwerai van mare jer.” ");
INSERT INTO upv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Iesu owra “Selek nir, inu nuwrai tevi kami, sete kapmetutue jinibb nir nga marongwose parevji pini bbong nibe kami nir, mian ko vitunen setemun arongwose parloli kele nanu pisan. ");
INSERT INTO upv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Inu bosusur metu le ngel tevi kami, bowrai tevi kami isi nga parmetutue. Parmetutue Atua kobbong. Ni kobbong orongwose pirevji pini jinibb, mian ko vitunen ni orongwos piwirre van renge lat ne nejijkien. Suri derteren sen otoe. Ngok ni ko ma kami kapmetutue. ");
INSERT INTO upv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kami kamrongwos pae nga jinibb nir arok-wulwule numön nga wowarreng elim nowlir evi nevöt eru kobbong. Ko renge no Atua, sete ok-kulu jabble san emalie, ejki. ");
INSERT INTO upv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ko kaplesi jomro batu kami ngok nir; Atua orongwos p̃etp̃eti nir, sete san ejki. Atua tetajer emetmete kami erres p̃elak. Ko ngok niko kami sete kapmetutu, ni emrreni kami elep nga elep, asi jer wore numön ngok nir. ");
INSERT INTO upv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Inu nuwrai tevi kami, M̃er nga sete mimtutu nga puwowrai inu nisek renge no jinibb nir, inu kele Jinibb Mawos bea-wowrai ni nisen renge no anglo se Atua nir. ");
INSERT INTO upv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ko m̃er nga mimtutu ko mivilvil ore inu nisek renge no jinibb nir, ngok inu kele bea-vilvil ore ni nisen renge no anglo se Atua nir. ");
INSERT INTO upv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ko m̃er nga m̃irij melmelas ko osopsop̃e inu Jinibb Mawos, mian ko Atua orongwos p̃itlasi tweni ni. Ko m̃er nga m̃irij melmelas ko osopsop̃e Nem̃in On, m̃ernen Atua sete orongwos p̃itlasi tweni rragrrage ni. ");
INSERT INTO upv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ko inu nuwrai tevi kami: Mian ko jinibb para-revei kami van renge naim gortien ji numal nga marlelep nir nga nir parwera suri nanu nga kamloli, lat nga puto suri re kami. Ko kami sete kapmetutu kaprrorrmi p̃elake sev nale ko nga kami kapwera lweni. ");
INSERT INTO upv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Suri renge daron nen mawos malum ko pa, Nem̃in On pia-wera nale mawos nen tevi kami nga kami kapa-werai.” ");
INSERT INTO upv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ko nir san renge meling jinibb ngel nir owrai tevi Iesu owra “Jinibb nevisvisenien, kupwerai tevi tuwak nga ni puwngani joro tata se komru nir nga ni mimetmete nir, pivsese komru korti. Suri ni omusus puwnganir.” ");
INSERT INTO upv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ko Iesu owrai tevi m̃ernen owra “E m̃erel, inu sete nuvini tweni nga bosp̃e suri nanu nga marirpok.” ");
INSERT INTO upv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ko mian ko ni owrai tevi jinibb nir owra “Kami kapmetmet wor kami ko p̃irres, ko kaptor ore nolo kami nga kamok-merrmerreni nijor e nir. Suri jinibb mauren sen weretunen sete arloli nanu ngok e ko nir, nga marivi joron ngok.” ");
INSERT INTO upv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ko Iesu owra nale rrongrrongvi san tevir, owra “Jinibb san nga joron milep, orsel sen nanen elep nga elep ren. ");
INSERT INTO upv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ko ni orrorrmi ko owra ‘Inu bololi pirpe le vajin, suri b̃ep̃e ne nanen suk ewelili pa. Bololi pirpese le vajin?’ ");
INSERT INTO upv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ko ni orrorrmi renge nolon owra ‘A, nurongwose lat nga bololi surie; bololi pirpel le, b̃errarre tweni b̃ep̃e suk ko b̃eli pilep lengleng vajin, ko b̃elngi nanen suk nir ko jorok nga marres nir rengen. ");
INSERT INTO upv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ko bowrai vajin tevi nem̃ik, ‘Jorom nga marres elep nga elep lengleng, evter nga nik kuplik vajin sia pilep nga pilep lengleng. Kup̃aan ko kupminmin p̃irres, ko kup̃ir vajin.’ ");
INSERT INTO upv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ko Atua owrai tevi m̃ernen owra ‘O, nik nga kumlengleng temijpal! Suri nata mupong nga lelingen b̃elai tweni nem̃im. Ko nanu nga kumajing nir ngok, ko nanu nga kumlingir ngok nir parivi se si ko vajin?’” ");
INSERT INTO upv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ko Iesu owra “Pia-irpok ko renge jinibb nga marser kortoni joror milep nga mivi se nir kis bbong, ko iok renge no Atua sete joror oto rragrrage, ejki rres nawone.” ");
INSERT INTO upv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ko Iesu owrai tevi jinibb sen nir, “Suri nanu ngel ko inu nuwrai tevi kami, Sete erres nga kami kaprrorrmi p̃elake mauren se kami, ko kapwera ‘Mian ko rraprro sev le lelingen?’ Ko sete erres kele nga kami kaprrorrmi p̃elake nibe kami, kapwera ‘Mian ko rrapla sunsun nga rrapuri ngabe le?’ ");
INSERT INTO upv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mauren evi nanu nga milep wor, nanen evi bbong nanu nga welili. Erpok kele, nibe kerr evi nanu nga milep wor, sunsun evi bbong nanu nga welili. Ko Atua elai pa nanu nga morlelep nen nuru; ko suri sev kami kamrrorrmi sete orongwos p̃ila kele nanu nga wowarreng ngok nir tevi kami? ");
INSERT INTO upv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Kaplesi numön nir; sete nevrer artoe, sete aruw te, ko sete arok-tawe wenen nurrer te, ejki, ko b̃ep̃e ser ejkie. Ko Atua ok-la wor nanen tevir. Ko ngok renge no Atua kami kamrres asi wore numön ngok nir. ");
INSERT INTO upv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Kami kamrrorrmi jinibb nga mok-p̃elak mok-rrorrmi mauren sen nga mumrrol jer bbong, orongwos puloli mauren sen pipriv asi kele wor? Ejki! ");
INSERT INTO upv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ko suri nga kami sete kamrongwos kaploli nanu nga marwowarreng ngel nir pirpe nga ngok nen nir, ko suri sev kami kamok-rrorrmi p̃elake nanu m̃inij nga ngak nen nir suri mauren se kami? ");
INSERT INTO upv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kami kaprrorrmi ta nevngu sekavöl. Sekavöl sete emajing erpe jinibb, ko sete evitvit te. Ko inu nuwrai tevi kami, numal Solomon kele tuwi ori sunsun nga marres p̃elak nir, ko sete arres arirpe nevngu sekavöl ngok san. ");
INSERT INTO upv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Atua emetmete mösmös ne orsel nga parmaur lelingen ko mevinen mun parsulir ko pa; ko ngok ni pimetmete wor kami pilep p̃iasi wor womu renge mösmös, O kami nga nosurien se kami ewelili. ");
INSERT INTO upv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ko sete kaprrorrmi p̃elake nanen nga kami kaprroi, ko nuwi nga kami kapminir, rreknga kaprrorrmi nanu pilep p̃elak. ");
INSERT INTO upv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nanu ngel nir jinibb jile nga marlik iel ngatan nir nga sete marosuri Atua arok-rrorrmi ko arok-pej. Ko Tata se kami ma orongwos pae sev nga nevre kami marmumrrol ren. ");
INSERT INTO upv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ko nanu nga milep nen nga kami kaploli, kapp̃elak nga kapsil van renge batun vanu se Atua. Ko ni pia-lai kobbong nanu ngok nir tevi kami. ");
INSERT INTO upv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sete kapmetutu te, kami meling welili. Suri Tata se kami orongwose erres nga ni pia-la batun vanu sen tevi kami. ");
INSERT INTO upv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Kapwulwule joro kami, ko kaplai nevöt nen tevi b̃eres nir. Ko re sel ngok ko, erpe kami kamvati narr se kami nga sete marongwos parmutmut, ko kamlingi joro kami parto renge melrin. Iok sete arongwos parsij, ko jinibb ne venao sete orongwos pian, ko momom sete orongwos pulokloksir. ");
INSERT INTO upv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Suri nga ngabe nga narr se kami puto rengen, ko ngok lat nen ko nolo kami puto rengen tetajer.” ");
INSERT INTO upv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ko Iesu owrai kele tevi jinibb sen nir “Kami kapmetmet ko wor tetajer terai inu bolwi vini. Ko kapserteni netatuw se kami p̃iterter, ko kapsuli laet se kami pimor metmet. ");
INSERT INTO upv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kami kapirpe jinibb ne majingen nga m̃ilik terai numal sen daron nga ni pulwi renge nanen ne totkoien sen e vini. Ko daron nga pulwi vini ko pututi metali, ko nir partasi metali pivesane tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Neiren renge jinibb ne majingen nen nir, suri nir sete armatur te renge daron nga numal ser mivini, ko m̃ilesi nir markulu metmet terai ni mulwi vini. Nuwretun nuwrai tevi kami, ni puloli p̃irres p̃elak tevir; p̃ila netatuw sen p̃itatuwe, ko puloli nir parlik ngatan, ko p̃ila nanen tevir paraani. ");
INSERT INTO upv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ko poro pulolola sopon, pia-vini renge nat p̃irrang sopon rreknga nat p̃isal p̃irin, ko p̃ilesi lartul nen nir parok-teravi malume pirpok, ko ngok neiren renge lartul nen nir. ");
INSERT INTO upv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ko kami kaprongwose nanu ngel: Poro nga jinibb san purongwose daron mawos nga jinibb venao pivini e, ko ni sete orongwos pivel lingi naim sen; pimetmet ko wor, puloli m̃ernen sete orongwos p̃iasi van. ");
INSERT INTO upv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ko pirpok kele ko, kami kele kapmetmet ko wor, suri Inu Jinibb Mawos dea-vini renge daron san nga kami sete kaprrorrmi rragrrage nga inu bolwi vini rengen.” ");
INSERT INTO upv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ko Pita owrai tevi Iesu owra “Numal, kuwra nale rrongrrongvi tevi kem kis lebbong, rreknga tevi jinibb jijle nir?” ");
INSERT INTO upv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ko Numal owra lweni tevi “Ia, ko kuprunge ta nale ngel: Jinibb si nga m̃ilngi nolon re majingen nga numal sen m̃ila tevi, ko evi jinibb ne majingen nga norongwosien sen mutoe. Ni evi jinibb san nga numal sen p̃ilngi pimetmete naim sen jile, ko p̃ila nanen tevi jinibb sen nir renge daron mawos nen. ");
INSERT INTO upv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Neiren renge m̃ernen daron nga Numal sen pulwi vini e ko p̃ilesi nga ni puloli pirpok. ");
INSERT INTO upv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nuwretun nuwrai tevi kami, m̃ernen ko numal sen p̃ilngi ni pivi batu jinibb nga pimetmete joron nir. ");
INSERT INTO upv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ko poro jinibb ne majingen nen purrorrmi renge nolon puwra ‘Numal suk ololola lengleng renge nga pulwi vini,’ ko p̃itipatun pivirrvirrali jinibb ne majingen nir, ko pian ko piminmin ko pivi jinibb ne botminminen. ");
INSERT INTO upv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mian ko numal se jinibb ne majingen nen pulwi vini renge nabong san nga m̃ernen sete murongwos rragrrage. Ko numal nen piwirr tweni m̃ernen, ko puloli ni pian p̃ilik p̃isij p̃erp̃er tevi jinibb nga marsij ko nga nosurien ser mijkie. ");
INSERT INTO upv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Jinibb ne majingen nga murongwose pa sev nga numal sen mimrreni nga ni puloli tevi ni, ko sete muloli te nanu nen, m̃ernen numal sen pia-virrvirrali temijpale. ");
INSERT INTO upv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ko m̃er nga ma sete murongwose nanu nga numal sen mimrreni, ko muloli nanu nga musorsan tevi pa nga parvirrvirrali rengen pilep suri, ko ejki, parvirrvirrali puwelili kobbong suri. Erpok ko, jinibb si nga marla nanu milep tevi, m̃ernen parngoni nanu pilep jin; ko jinibb si nga Atua m̃ilngi pa nanu milep renge nevren, m̃ernen Atua emrreni p̃imajing majingen nga marlelep. ");
INSERT INTO upv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Inu nuvini nga bosor tweni nabb renge iel ngatan. Ko nabb nen ein pa, ko poro puror ko inu bololi sev? Inu b̃eir lengleng. ");
INSERT INTO upv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ko nanu erwen le ngel, baptaesen san nga muto malum, nga inu bepaptaes rengen; ko inu nomok-runge esij e, pian pian pijpari nanu ngel pivini p̃iasi; ko osuw vajin. ");
INSERT INTO upv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kami kamrrorrmi nga inu nuvini tweni nga b̃ela demat tevi iel ngatan? Ejki rres nawon! Inu nuwrai tevi kami, sete b̃ela demat, ko bowjuwje ma jinibb ko parwijwij ngasu nir. ");
INSERT INTO upv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ko etipatun le pa ngel ko p̃itajer tevi le pa, metka san nir pielim parlik korti renge naim pisansan. Ko nir p̃itul partere nuru p̃ieru, ko nuru p̃ieru portere nir p̃itul. ");
INSERT INTO upv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tata ko p̃itre natun norman, ko natun norman p̃itre tata sen. Ko tasu p̃itre natun nesenwarreng, ko natun nesenwarreng p̃itre tasu sen, ko lekter p̃itre nesevinli sen, ko nesevinli sen p̃itre p̃ilen lekter.” ");
INSERT INTO upv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ko Iesu owrai kele tevi delung nir owra “Daron nga kami kamlesi nabor marimare marmot korti milep lat san, ko kamrongwos pae ko evesane, ko kamwera ‘Naus pus ko’, ko mian ko erpe nga kami kamwerai. ");
INSERT INTO upv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ko daron nga kami kamlesi ling murrwurrweli tolu, ko kamwera ‘Nat pututun ko pilep’, ko mian ko erpe nga kamwerai. ");
INSERT INTO upv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kami nga kamiel renge sel eru! Kamrongwos kapwera suri nelesien nga kamlesir renge iel ngatan ko renge melrin. Nanu nawon ngok nir kami kamlesi woser. Ko erpese renge daron se inu nga lelingen ngel? Erpese kami sete kamrongwose kaplesi wose nelesien nen te mijki? ");
INSERT INTO upv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ko erpese nga kami lweni sete kamrongwose kapwera suri nanu nga marres nir marsorsan nga moro kaplolir? ");
INSERT INTO upv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Poro nik ko m̃er nga kamru komorlat koporivel korti koporan ji numal nga pusp̃e lilane, ko daron nga komorivel renge sel e, ko kupwerai lilane tevi ni. Poro pijki, ko ni tilngim van renge nevre numal, ko numal tilngi nik van renge nevre polis, ko polis tilngi nik van renge naim ne nekaien. ");
INSERT INTO upv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nuwrai tevi nik, sete kurongwos kupivare renge ie pijpari wor kupla jile ko nevöt nga marlingi ko marwera kuplai.” ");
INSERT INTO upv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ko jinibb sopor arlik ie renge daron nen ko arini ji Iesu. Ko arsup̃e suri m̃eri Galili sopor nga marloli sulsulen van ji Atua, ko Paelet otur imare ko erevji pinir re daron mawos nga marloli sulsulen. ");
INSERT INTO upv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ko Iesu owra lweni tevir “Ko ngok suri mirpok ngok, kami kamrrorrmi m̃eri Galili ngel nir arsij womu ne wor m̃eri Galili jijle nir, suri nga marpal mirpok? ");
INSERT INTO upv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Inu nuwrai tevi kami, Ejki. Poro kami sete nolo kami pulululwi renge nololien se kami nir nga kamok-lolir, kami kele kapmij kapjijki pirpe nir. ");
INSERT INTO upv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ko nir esngavöl drromon owil (18) nga naim nga muwu mare renge Saeloam mimav ko mirevji pinir; kami kamrrorrmi nir arsij wor easie nir m̃inij nen nir nga marlik renge Jerusalem? ");
INSERT INTO upv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ejki rres nawon! Inu nuwrai tevi kami, poro kami nolo kami sete pulululwi renge nololien se kami nga kamok-lolir, kami kele kapmij pirpe nir marjijki ngok.” ");
INSERT INTO upv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ko Iesu owra nale rrongrrongvi ngel tevir, owra “Jinibb san orwi nai pik san renge orsel sen. Mian ko evini epej wenen rengen, ko sete elesi san rragrrag. ");
INSERT INTO upv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ko owrai tevi m̃er nga mimetmete dan sen, owra ‘Kuplesi, sia itul le pa mevini mepej nai pik ngel wenen rengen, ko sete nulesi te san. Kupta bburi piravij ngatan, erpese mimni nawone suwe dan?’ ");
INSERT INTO upv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ko m̃er nga mok-metmete dan sen owra lweni tevi owra ‘Numal, kuplinglingi pa putur kele mun renge sia ngel, ko inu b̃eli rrale bbulwil renge batun, ko bololi lilane dan p̃irres rengen. ");
INSERT INTO upv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ko poro nga pia-wen vajin renge sia nga vitu, ko ngok erres ko. Ko poro nga pia-jiki, ko kupa-ta bburi ko pivitan ngatan.” ");
INSERT INTO upv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ko Iesu ok-visviseni renge loloim ne naim ne loten san renge nabong ne Sapat. ");
INSERT INTO upv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ko nesevin san nga nem̃in nga m̃isij m̃isisilvi muloli mimsi sia esngavöl drromon owil (18), nga duren murru jer, sete murongwos putur rramos renge nabong san, elik ie. ");
INSERT INTO upv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ko daron nga Iesu m̃ilesi vinnen ko owra “Vinel! Kuprres ko pa renge mesien som nga muloli durem murru ngok.” ");
INSERT INTO upv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ko Iesu elngi nevren renge vin nga, ko erres evesane renge duren nga murru nga, ko osrövi Atua. ");
INSERT INTO upv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ko numal ne naim ne loten ololarsi lenglenge Iesu suri nga muloli vinnen m̃irres renge nabong ne Sapat, ko ni erij otortori delung nir, owra “Nabong ouwon kis nga jinibb puloli majingen rengen, ko kapini renge nabong nen nir ko kami kaprres renge mesien se kami nir, ko sete nabong ne Sapat, pijki!” ");
INSERT INTO upv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ko Numal owra lweni tevi owra “Kami nga kamiel renge sel eru! Sete kami sisamis kamok-telasi buluk se kami rreknga dongki se kami renge nabong ne Sapat, ko kamok-iler van renge nuwi parminmin? ");
INSERT INTO upv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ko vinel evi metka se Epram san nga Demij m̃isre totoni ni renge sia esngavöl drromon owil, ko erpese sete erres renge ni pivel sisarow renge nabong ne Sapat?” ");
INSERT INTO upv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nale sen nga muwrair ngel nir arloli devje nuval sen nir nor eta dan. Ko delung arir elep suri nanu nga marres nga ni mulolir. ");
INSERT INTO upv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu owra “Batun vanu se Atua erpe sev, ko sev osorsan tevi nga inu bowra rrongrrongvi rengen? ");
INSERT INTO upv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Erpe jelangi nubek san nga muwelili jer, nga jinibb m̃ilai ko murwi renge dan sen. Ko etiv pelari, ko emaur, evi nai nga milep san; ko numön ne mesa nir arow vini, arsakel renge rengsin, ko arjali menuner rengen.” ");
INSERT INTO upv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ko Iesu owra kele “Batun vanu se Atua erpe sev? Ko sev osorsan tevi nga inu bowra rrongrrongvi ren? ");
INSERT INTO upv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Osorsan tevi is nga nesevin m̃ilai ko m̃ilngi renge besin ne plaoa itul kis, mian ko mipau jijle vajin.” ");
INSERT INTO upv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mian ko Iesu evel suri sel sen evel rrurrngi ngaim nga marlelep nir ko ngaim nga marwowarreng nir; ko ok-visviseni jinibb nir, ko ok-tajer tevi van renge Jerusalem e. ");
INSERT INTO upv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ko jinibb san osusi tevi ni owra “Numal, nir puwelili kobbong para-maur?” Ko ni owra lweni tevi owra ");
INSERT INTO upv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kami kapp̃elak temijpal ko wor tweni nga kapan kapsil renge metali nga welili ko. Inu nuwrai tevi kami, nir pilep para-merreni nga paran parsil rengen, ko sete parongwos paran te, ejki. ");
INSERT INTO upv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ko Numal ne naim tutur imare ko tian tikikiorore metali, ko kami tamoka-tur jer vini vare e. Ko kaptipatun kapututi metali, ko kapverus ‘Numal, kuptasi metali tevi kem!’ Ko ni tia-wera lweni tevi kami, ‘Inu nurrerrleng sisini kami. Kami kamivi m̃eri ngabe ko?’ ");
INSERT INTO upv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ko kami kaptipatun kapwera lweni tevi inu, kapwera ‘Ejki ma, namok-aan tevim ko namok-minmin tevim, ko nik komok-visviseni kem lat nga kem!’ ");
INSERT INTO upv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ko ni puwra lweni kele tevi kami, ‘Inu nurrerrleng sisini kami. Kami kamivi m̃eri ngabe ko, kami nga kamok-loli nanu nga marsij nir.’ ");
INSERT INTO upv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ko kami kapting ko kaporrliw daron nga kaplesi Epram ko Aesak ko Jekop ko propet nir renge batun vanu se Atua, ko kami lweni parwirr tweni kami kapjikie. ");
INSERT INTO upv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ko delung parivel renge vanu p̃etp̃eti ngok vini, ko parsakel tevi Atua renge batun vanu sen, paraan tevi. ");
INSERT INTO upv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ko kaplesi renge ie nir nga marivi jinibb nga marwelili, mian ko para-ivi jinibb nga marlelep; ko nir nga marivi jinibb nga marlelep, mian ko para-ivi jinibb nga marwelili.” ");
INSERT INTO upv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ko renge daron nen mawos ko pa Parasi sopor arini ji Iesu ko arwerai tevi “Kupiel lingi iel, kupan iok e sopon. Suri Erot emrreni pirevjim kupmij.” ");
INSERT INTO upv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ko Iesu owra lweni tevir owra “O, morok evi jinibb ne gerisen. Kapan kapwera tevi, ni p̃ilesi inu nuoji tweni nem̃in nga marsij nir, ko bololi nir nga marmesi parres luwi lelingen ko mevi. Ko renge nabong itolin vajin ko bololi jile majingen suk. ");
INSERT INTO upv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko ngok niko inu bevijuri suri wor sel suk ko renge lelingen ko mevi ko teru, ko bejpari Jerusalem. Suri ewretun lenglengen, Jerusalem evi lat nga moro partori p̃irres propet nir rengen; ko ejki mun, arok-revji pinir ma ren. ");
INSERT INTO upv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem, nik nga kumrevji pini propet nir ko kumtuwe pini nir nga Atua mukonir vini jim! Momori inu numrreni bololi jinibb som nir parlik korti pirpe nato nga misrew ore natun nir, ko nik kumusus. ");
INSERT INTO upv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ko kuplesi, Atua evel lingi pa ngaim som oto kiskis. Ko kami sete kama-lesi inu te ejki, pian pijpari daron nga kami kapa-wera ‘Atua, kuprij p̃irres suri m̃er nga mivini renge nise Iova.’” ");
INSERT INTO upv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Renge nabong ne Sapat san ko Iesu evan nga p̃iaan tevi m̃erwomu ne Parasi nir san. Ko delung arujruj van mori jin, ko armeteni suri ni eterter. ");
INSERT INTO upv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ko jinibb san nga drru nevren nuru ko drru b̃elan nuru morsosol pa nga pimij elik renge ie. ");
INSERT INTO upv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ko Iesu elesi, ko osusi tevi jinibb ne nevisvisenien ne nale nesesreien nir ko Parasi nir, owra “Renge nale ne nesesreien se kerr emarong nga rraploli jinibb p̃irres luwi renge nabong ne Sapat, rreknga ejki?” ");
INSERT INTO upv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ko nir armurrarrong nawon, sete arwera nanu san. Ko Iesu eptevi tweni m̃ernen ko ololi erres luwi, ko elngilngi ni evel. ");
INSERT INTO upv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ko Iesu owrai tevi jinibb nir, owra “Isi renge kami poro nga natun rreknga buluk sen otoe, ko osobbul van ngatan renge bbulwil ne nuwi renge nabong ne Sapat, ko m̃ernen sete orongwos pian mawos pirvei tweni renge wosenen?” ");
INSERT INTO upv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ko nir armurrarrong nawon kele, sete arongwos parwera lweni kele nale san tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu owra nale rrongrrongvi san tevi nir nga marsakel maraan, suri elesi nir arpejpej lat seksakel nga marto womu. Ko owrai tevir owra ");
INSERT INTO upv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Poro jinibb pisan pungoni nik nga kupan renge nanen ne totkoien sen, ko kupan, ko sete kupsakel womu renge lat seksakel nga m̃irres. Suri m̃er nga mungoni nik tungoni jinibb nga milep asie wor nik san tia-vivitu vini. ");
INSERT INTO upv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ko poro pirpok ko m̃er nga mungoni nik nen tia-vini jim ko tia-werai tevim, ‘Kuptur iok, m̃erel pivinuk p̃isakel iok re milngom,’ ko ngok nik kupan kuplik ngatan, ko kupmanun pilep. ");
INSERT INTO upv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ko poro daron nga parngonim e, ko nik kupan ko kuplik bbong ngatan. Ko ngok poro m̃er nga mungonim pivini ko p̃ilesim, ko puwrai tevim ‘Selek, kupini kupsakel mare.’ Ko ngok ni puloli nolom p̃ir renge no jinibb nir nga kupan kupsakel mare tevi nir nga kap̃aan. ");
INSERT INTO upv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Suri m̃er nga m̃ilngi lweni ni van mare, mian ko Atua puloli ni pivi jinibb nga pian ngatan jer. Ko m̃er nga muloli ni mian ngatan, mian ko Atua puloli ni pian mare.” ");
INSERT INTO upv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ko Iesu owrai tevi m̃er nga miveruse ni nga p̃iaan tevi, owra “Poro nga nik kuploli nanen ne levial rreknga rivriv, sete erres kupveruse selem nir, rreknga tuwam nir rreknga metka som nir rreknga selem nga joron milep nga m̃ilik tevim bbong. Poro pirpok, ko nir parverus kele bbong nik, ko parkele lweni nanu nga kumloli tevir. ");
INSERT INTO upv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ko poro daron nga nik kuploli nanen pisan, ko kupveruse b̃eres nir ko jinibb nga marus karkar nir ko nir nga b̃elar marsij nir ko metrrorr nir. ");
INSERT INTO upv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ko nik kuprunge p̃irres, suri lartul nen nir sete arongwos parkele lweni tevi nik. Ko Atua vajin pia-kele lweni tevi nik renge daron nga puloli jinibb nga marres nir parmaur luwi kele re mijen.” ");
INSERT INTO upv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ko san renge nir nga marsakel tevi nga maraan murnge nanu ngel nir e, ko owrai tevi Iesu owra “M̃er nga pian pia-aan renge batun vanu se Atua, ni purnge p̃irres pilep.” ");
INSERT INTO upv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ko ni owrai tevi m̃ernen owra “Jinibb san ololi nanen nga milep san, ko everuse jinibb elep parini renge nanen. ");
INSERT INTO upv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ko renge daron ne nanen vajin, ko ni okoni jinibb ne majingen sen pian puwrai tevi lartul nga ni muwrai pa tevir nga para-vini, ‘Kapini vajin, arloli nanu jile arsuw pa, arto metmet.’ ");
INSERT INTO upv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ko nir jile norrorrmien ser evi sansan e, ko artipatun arwera orore nanu sopor. Nir san nga womunen owra ‘Inu nua-wuli bbong orsel san, ko inu numrreni bean mun b̃elesi ta; sete numa-vinuk ko, ejki.’ ");
INSERT INTO upv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ko nir erwen nen kele owrai tevi, ‘Inu nua-wuli bbong buluk nga marok-revei kat esngavöl, ko inu numrreni bean borrowrrowe ta nir parmajing lesi ta. Sete numa-vinuk ko, ejki.’ ");
INSERT INTO upv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ko nir itolin kele owra ‘Inu nua-lesi bbong nesevin suk, ko niko inu sete numa-vinuk ko, ejki.’ ");
INSERT INTO upv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ko jinibb ne majingen nen olwi van, ko owrai suri nale nga lartul nga marwerai tevi ni, tevi numal sen. Ko numal nen ololar lengleng, ko owrai tevi jinibb ne majingen nen, owra ‘Kupsaro pingavil, kupan renge sel nga marwolu ototvi live laut ne ngaim ko sel lele kele nir. Ko kuptekai b̃eres nir, ko nir nga niber marsij, ko metrrorr nir, ko naroj nir; ko nir vajin parini renge nanen.’ ");
INSERT INTO upv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ko ni evan, ololi jile, mian ko olwi ko owra ‘Numal, inu nuloli pa erpe nga kumwerai osuw, ko loloim elep malum wor oto.’ ");
INSERT INTO upv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ko numal owrai tevi jinibb ne majingen sen owra ‘Kupiel, kupan kele kupvijuri sel jile nga iok e nir, ko kupvijuri sel nga maran orsel e nir. Ko kupan kupsup̃e p̃irres tevi jinibb nir parini ko parsongni naim suk puwun saut. ");
INSERT INTO upv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Inu nuwrai tevi kami, jinibb nga mongoni womu nir ngok, nir san sete mia-vini mia-rroi nanen suk sopon.’ ");
INSERT INTO upv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Delung jinibb nga milep arvijuri suri Iesu. Ko Iesu erieni lweni emtenir, ko owrai tevi nir owra ");
INSERT INTO upv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Poro jinibb san emrreni pivini ji inu, ko m̃ernen pimrreni inu p̃iasi jer wore mimrreni tata sen, ko tasu sen, ko ni wor nesen sen, ko natun nir, ko tuwan nir, ko jojin nir, ko ni kele wor mauren sen. Ko ngok m̃ernen orongwos pivi jinibb suk san vajin. ");
INSERT INTO upv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ko isi nga sete muwosi nai pelaot sen ko mivijurik, ni sete orongwos pivi jinibb suk san. ");
INSERT INTO upv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ko poro kami san pimrreni p̃ili naim nga muwu mare temijpal san, ko setemun p̃ilik ngatan te purrorrmi suri lat nga nowlin puto surie pirpese, ni evtere puwli jile rreknga ejki? ");
INSERT INTO upv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Poro pirpe nga ngok, ko ni titipatun bbong, ko tia-runge turrow renge ni, tuloli bbong ngatan nen ko. Ko ngok sete tivter mun tia-loli jijle; ko jinibb nir tarlesi ko tarmen keraji ni rengen, ");
INSERT INTO upv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tarwera ‘M̃erel emajinge naim ngel, ko setemun evtere nga p̃imajing jijle mun, omrrol ren.’ ");
INSERT INTO upv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ko poro nga numal san piptevi jinibb nuval pivi nuvasngavöl vasngavöl vesan (10,000), paran parval tevi numal m̃inij san nga miptevi jinibb nuval mivi nuvasngavöl vasngavöl varu (20,000) mivini tevir nga parval tevi nir. Numal nen p̃ilik ko wor ngatan purrorrmi suri lat nga puto surie puwomu, poro nga ni eterter evtere nga pival tevi numal m̃inij nen, rreknga ejki. ");
INSERT INTO upv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ko poro pijki, ko ni pukoni jinibb sopon parivel ore numal nen tuwen nen, parsewute renge sel renge daron nga ni mivel malum ngasue, ko parngoni demat tevi.” ");
INSERT INTO upv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iesu ewer otvi nale sen, owra erpel le: “Ko erpok ko, poro kami san sete pivel lingi jile nanu nga marivi sen nir, m̃ernen sete orongwos pivi jinibb suk te, ejki. ");
INSERT INTO upv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol erres; ko poro dilten nga mimelmel pusuw jer rengen, ko parloli lweni pimelmel luwi pirpese ko? ");
INSERT INTO upv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sete erres rragrrag mun renge parloli nanu kele e san, nanu nga m̃irres rreknga nanu nga m̃isij. Parwirre kobbong p̃irresrres. M̃er nga boron mutoe, purnge re nolo boron.” ");
INSERT INTO upv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Renge nabong san, ko jinibb nga marok-la nevöt ne takis nir ko jinibb nga marsij nga marwirr tweni nir arini armurrarronge Iesu. ");
INSERT INTO upv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ko Parasi nir ko jinibb ne nevisvisenien ne nale nesesreien nir arlesi, ko artipatun arok-sur vijvij malum bbong arok-wor suri Iesu, arwera “M̃erel okorti tevi jinibb nga marsij nir ko eaan tevir.” ");
INSERT INTO upv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ko Iesu ornge marwerai, ko owra nale rrongrrongvi san tevir, owra ");
INSERT INTO upv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Poro nga san renge kami sipsip sen ongut vesan (100), ko san pijijki lingir, ko erpese, ni sete orongwos p̃ilngilngi ngavöl esiw drromon esiw (99) ngok renge lolo merwer parurro mösmös, ko ni pipej nga mijijki nen, pian pijpari nga p̃iska lweni? ");
INSERT INTO upv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pian ko wor, ko daron nga m̃iska lweni, ko owosi elngi ejingteni renge birparin, ko eir nga eir lengleng. ");
INSERT INTO upv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ko daron nga muwosi lweni vini ngaim e, ko everus kortoni selen nir nga marlik ngasue ni ko nga marlik mori bbong ni, ko owrai tevir, ‘Kerr rrap̃ir, suri nuska lweni pa sipsip suk nga mijijki nga.’ ");
INSERT INTO upv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ko inu nuwrai tevi kami, pirpok ko renge melrin. Nir parir lengleng suri jinibb sansan nga m̃isij nga nolon mulululwi, p̃iasi ngavöl esiw drromon esiw nga marok-wera lweni kis pae nga marivi jinibb nga marres, ko armusus nolor pulululwi. ");
INSERT INTO upv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ko nesevin si renge kami poro p̃ilngi silva pisngavöl ko pisansan pijijki, ko erpe? Ni pusli laet ko puraki vaseni loloim, pipej pian pijpari nga piska lweni. ");
INSERT INTO upv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ko daron nga vinnen m̃iskai lweni, ko everus kortoni selen nir nga marlik ngasue ni ko nir nga marlik mori bbong ni ko owrai tevir, owra ‘Kerr rrap̃ir, suri nuskai lweni pa silva suk nga mijijki nga.’ ");
INSERT INTO upv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ko inu nuwrai tevi kami, pirpok ko renge no anglo se Atua. Nir parir lengleng suri jinibb sansan bbong nga m̃isij nga mijijki nen, nga nolon mululwi mirpel.” ");
INSERT INTO upv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ko Iesu owra “Jinibb san nga natun eru morivi norman. ");
INSERT INTO upv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ko ngok m̃ervitu nen evan ji tata sen ko ongoni tevi, owra ‘Tata, kuptutweni jorom nga parivi se komru nen nir, pivsivsese komru korti.’ Ko ni otutweni joron tevi nuru korti. ");
INSERT INTO upv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mian ko nabong sete elep mun, ko m̃ervitu nen eser kortoni joron jijle nir ko evel evan renge ngaim nga milep san nga muto ngasu. Ko elik ie, ko etipatun olokloksi p̃etp̃eti joron renge norrorrmien sen nga sete murrorrmi m̃irres e. ");
INSERT INTO upv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Ko daron nga mulokloksi p̃etp̃eti joron e nir, ko numer nga milep eimare renge ngaim nen; ko ejki mun, ni joron arsuwsuw p̃etp̃eti pa. ");
INSERT INTO upv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ko ni lweni evan emajing se jinibb ne ngaim nen san. Ko m̃ernen okoni ni evan renge orsel nga marok-wungani b̃erp̃er sen nir rengen, nga pok-wungani b̃erp̃er sen nir. Ko renge marwungani b̃erp̃er, m̃eri Isrel nir arlesi evi majingen san nga m̃isij p̃erp̃er. ");
INSERT INTO upv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ko ni numer aji lenglengen e, ko sete san ela nanen rragrrag san tevi nga purroi; ko ngok ololi emrreni lenglengen e purro nanen se b̃erp̃er nir sopon, nga puloli pup e. ");
INSERT INTO upv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mian ko nolon olwi, orrorrmi lweni tata sen vajin, ko owra ‘Aro, jinibb ne majingen se tata nir elep wor, ko nanen evtere nir p̃etp̃eti, ko majbböl nen ojpon; ko suri sev inu bemij e numer iel! ");
INSERT INTO upv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Erres ma inu bemra iel, ko bolwi van ji tata. Ko bowrai tevi ni, “Tata, inu nuloli esij renge no Atua ko renge no nik kele. ");
INSERT INTO upv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ko ngok inu setemun nurres renge nga jinibb parwera inu nuvi natum san, ejki mun. Ko kuploli inu ma bevi jinibb ne majingen som san.’” ");
INSERT INTO upv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ko ni otur imare ko evel, pivini ji tata sen e. “Ko daron nga mivel ngasu malum mivini, ko tata sen elesi. Ko orrorrmi temijpale. Ko owlu tersele ko pa, evan ko erake totoni, ko orromji. ");
INSERT INTO upv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ko natun owrai tevi ni ‘Tata, inu nuloli esij renge no Atua ko renge no nik kele. Inu setemun nurres renge nga jinibb parwera inu nuvi natum san.’ ");
INSERT INTO upv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ko tata sen everuse jinibb ne majingen sen nir, owra ‘Kapsaro pingavil, kapla sunsun nga m̃irresrres asi nen, kaploli ni puri. Ko kapla ring suk ko kaploli p̃irae re bbösö nevren, ko kaploli p̃irae but. ");
INSERT INTO upv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ko kapan kaprevji natu buluk san nga milep m̃irres; ko rrapurroi, ko kerr rrap̃ir vajin. ");
INSERT INTO upv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Suri natuk ngel erpe emij le pa osuw, ko emaur luwi kele. Ni erpe ejijki le pa, ko nulesi lweni kele.’ Ko nir artipatun arir vajin. ");
INSERT INTO upv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ko ni natun norman nga wowomu nen ejkie nir, evel womu evan pa orsel e. Mian ko olwi vini ngaim e. Ko daron nga mivini morie naim, ko ornge drrelar marla nubo ko marsew. ");
INSERT INTO upv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ko ni everuse jinibb ne majingen se tata sen san vini jin, ko osusi tevi owra ‘Sev ko ngok?’ ");
INSERT INTO upv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ko m̃ernen owra lweni tevi ni, owra ‘O, tasim olwi vini ngaim, ko niko tata som erevji natu buluk nga milep m̃irres san rengen, suri ni m̃ilesi natun mulwi vini mimaur malum bbong.’ ");
INSERT INTO upv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ko ni ololar e, omusus pian loloim. Ko tata sen eivare vini vare e ko evini jin, ko eiari ni nga pian loloim. ");
INSERT INTO upv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ko ni owra lweni tevi tata sen, owra ‘Kuplesi, inu numajing som sia sia, nurpe jinibb ne majingen som san. Ko sete nutor otvi nale nesesreien som san, ejki rres nawon. Ko nik sete kula nanu san rragrrag tevik. Sete kula nanani san tevik nga inu bololi nanen e san tevi selek nir ko nab̃ir. ");
INSERT INTO upv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ko daron nga ma natum ngel nga mulokloksi p̃etp̃eti jorom nir tevi nesevin ne sel nir mivini e, ko nik kutur imare, kurevji natu buluk nga milep m̃irres renge ni!’ ");
INSERT INTO upv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ko tata sen owra lweni tevi ni owra ‘Natuk, nik kulik tevik tetajer ko pa, ko ngok nanu jile nga marivi suk arivi som ko pa. ");
INSERT INTO upv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Niko erres kerr rrap̃aan vajin ko rrap̃ir, suri tasim ngel erpe emij ko pa ko emaur luwi; ko ejijki ko pa, ko rramlesi lweni kele.’” ");
INSERT INTO upv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ko Iesu owrai tevi jinibb sen nir, owra “Numal san joron elep. Ko ni elngi jinibb ne majingen sen san nga pimetmete nijor sen nir. Ko mian ko jinibb sopor arini ji numal nen, ko arwera ‘O, jinibb som ngok olokloksi jorom nir.’ ");
INSERT INTO upv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ko numal nen everuse m̃er nga mivi burtur renge joron nen vini jin, ko owrai tevi ‘Sev le ngel nga inu mornge renge nik? Kupsuw ko pa, setemun kuma-ivi burtur renge inu jorok nir. Kupan kupuli tweni lat nga komok-majing muto suri, ko san kele p̃ila wanim.’ ");
INSERT INTO upv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ko burtur nen orrorrmi renge nolon, owra ‘Inu bololi sev le, suri numal suk p̃ila tweni inu renge majingen suk? Ko inu derteren suk sete evter renge nga b̃eli dan orsel, ko numanun kele renge nga bongun-ngun.’ ");
INSERT INTO upv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mian ko owra ‘E! Inu nurongwos pae lat nga bololi surie renge daron nga numal suk p̃ila tweni majingen suk jik, puloli jinibb nir parmarong kobbong nga inu bean loloim se nir.’ ");
INSERT INTO upv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ko ni everuse jinibb nga marloli nivnon ji numal sen arini jin. Ko osusi womue tevi nir san, owra ‘Nik kuloli nivnon e sev ji numal suk?’ ");
INSERT INTO upv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ko m̃er nga mususi womu nen e tevi owra lweni tevi, owra ‘Inu nuloli nivnon e dram oel ongut (100).’ Ko burtur nen owra lweni tevi, ‘Naul nen le ngel, kuplai ko kupuli pingavöl pielim (50) kobbong rengen.’ ");
INSERT INTO upv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ko osusi kele tevi nir san, owra ‘Ko nik kuloli nivnon e sev?’ Ko m̃ernen owrai tevi, owra ‘Inu nuloli nivnon e bak wit evi nuvasngavöl vesan (1000).’ Ko burtur nen owra lweni tevi ‘Naul nen le ngel, kuplai ko kupuli ongut valim (500) kobbong rengen.’ ");
INSERT INTO upv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ko numal se m̃er nga mivi burtur nga sete muloli mumomsawos nga owra ‘O, morok norrorrmien sen engavilvil nawon, orongwos kemkam̃e lat nga puloli surie!’ Suri jinibb ne iel ngatan nir arongwose asie nir nga marlik renge moron. ");
INSERT INTO upv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Kami kele kaploli pirpe morok, kapla nijor ne iel ngatan nir, ko kaplair tevi jinibb nir. Ngok puloli nir parir suri kami, ko partekai kami van renge naim nga renge melrin nir rrek! ");
INSERT INTO upv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ejki! M̃er nga m̃irres renge puloli nanu nga welili bbong, ngok ni p̃irres renge puloli kele nanu nga milep. Ko m̃er nga sete erres renge puloli nanu nga welili bbong, ngok ni sete mia-rres renge puloli nanu nga milep kele. ");
INSERT INTO upv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Erpok ko, poro sete kamloli erres renge nijor ne iel ngatan nir, ko si p̃ila nijor nga marres weretunen ne melrin tevi kami kapmetmeter? ");
INSERT INTO upv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ko poro sete kamrres renge kapmetmete nijor se jinibb m̃inij, si p̃ilai tevi kami nijor nga parivi se kami? ");
INSERT INTO upv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Sete jinibb san orongwose p̃imajing se numal pieru pivesane. Poro pirpok, ko tungasi nuru tuwen, ko timrreni nuru tuwen nen. Erpok ko, sete Atua orongwos pukonim re majingen sen poro nevöt mukonim pa renge majingen sen. Suri sete kurongwos kupmajing se nuru korti evesane.” ");
INSERT INTO upv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ko Parasi nir arok-merreni temijpale nevöt, ko daron nga marunge nanu nga Iesu muwrair ngok e nir, ko armen kerajie. ");
INSERT INTO upv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ko Iesu owrai tevi nir owra “Kami ngok ko kamivi lartul nga tetajer kamwera kamrres renge mete jinibb. Ko Atua orongwose nolo kami. Ko sev nga marloli mian mare renge jinibb bbong, ngok sete evi nanu san rragrrag renge no Atua. ");
INSERT INTO upv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Nale nesesreien oto ko pa, ko nale se propet nir arto ko pa, mian ko mivini mijpari daron se Jon Baptaes vajin. Ko renge daron nen mawos ko vajin, marwerwer renge nosp̃en nga m̃irres; ko jinibb arp̃elak temijpal arwera paran renge batun vanu se Atua. ");
INSERT INTO upv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ko evi nanu nga m̃iterter renge melrin ko iel ngatan porjijki; ko evi nanu nga m̃iterter kele wor m̃iasi san renge bebje nale ne nale nesesreien ngel san pijijki. ");
INSERT INTO upv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Erpok ko, jinibb si nga p̃ilngi kurtweni nesen sen ko p̃itkai kele nesevin m̃inij san, erpe evitan re nesevin ngok ko vajin. Ko m̃er nga m̃itkai kele nesevin nga diwen sen m̃ilngi kurtweni, ni kele evitan re nesevin ngok.” ");
INSERT INTO upv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ko Iesu ela jilweren kele san erpel: “Jinibb san nga joron milep elik lat san. Ko ni tetajer ok-uri sunsun nga nulser marres p̃elak marsongsong, ko marow raprap titis, ko marmalum marres. Ko nabong jijle eaan erres ko eir, elelea. ");
INSERT INTO upv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ko jinibb san nga mivi b̃eres nga mok-ngun-ngun res nga miwajie Lasros elik ie renge metali se m̃er nga joron milep nen. Ko m̃ernen niben nir arkar p̃etp̃eti. ");
INSERT INTO upv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ko ni emrreni lengleng pok-rroi bebje nanen nga marvitvitan renge tep se m̃er nga joron milep nen. Ko ejki; ko guli arok-ini arok-lomlomi niben nga markar nir. ");
INSERT INTO upv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mian ko vitunen vajin ko b̃eres nga mok-ngun-ngun res nga emij. Ko anglo nir arwosi ni van renge melrin ji Epram, ko elik lilji nelin. Mian ko vitunen vajin, ko m̃er nga joron milep nga ea-mij vajin, ko artevni. ");
INSERT INTO upv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ko ni elik renge lat ne mijen, ko ornge esij elep lengleng. Ko daron nga moro muklu, ko elesi Epram iokwan ngasu jer, ko Lasros emajil renge morkon. ");
INSERT INTO upv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ko ni ekail everus owra ‘Tata Epram, warru kuprrorrmi inu! Kupkoni Lasros pian purrurrngoni bbös nevren pisansan renge nuwi, ko puloli pujum renge nemek, ko pimemrrali. Suri inu nurnge esij nga esij lengleng renge lomi nabb ngel.’ ");
INSERT INTO upv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ko Epram owra lweni tevi, owra ‘Natuk, kuprrorrmi renge daron nga nik kummaur e. Nik kulesi nanu jile arres vinuk jim; ko Lasros ornge esij elep, elesi nanu jile arsij vini jin. Ko renge lelingen ngel vajin ni ela lol molmol, ornge erres; ko nik kulik renge lat ne norongen nga m̃isij, kurnge esij. ");
INSERT INTO upv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ko nanu san muto ngok liven ne kem ko kami, evi mesa nga milep. Ko ngok nir nga parwera parasi vinuk ji kami sete arloli wos parasi vinuk ji kami, ko kami sete kamrongwose kapasi vini ji kem iel.’ ");
INSERT INTO upv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ko mian ko m̃er nga joron milep nga owra lweni tevi owra ‘Tata, nungoni tevi nik, warru kupkoni Lasros pulwi kele van renge naim se tata suk. ");
INSERT INTO upv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Suri inu tasik elim, ko erres ma renge ni pian ko pususur metu tevi nir, ko puloli nga nir sete parini kele iel renge lat nga inu mornge m̃isij ngel e.’ ");
INSERT INTO upv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ko Epram owra lweni tevi m̃er nga joron milep nga owra ‘O, ejki, tasim nir, naul se Moses ko naul se propet nir arto pa jir. Naul ser nen ko pa nir parsusur metu tevir.’ ");
INSERT INTO upv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","M̃er nga joron milep owra lweni tevi owra ‘O, ejki, tata Epram, poro ma san pimaur luwi ko wor renge mijen ko pian jir, ko ngok ko ma nir nolor pululwi ko renge nololien ser nir!’ ");
INSERT INTO upv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ko Epram owra lweni tevi, ‘Poro nir sete parunge nale ne naul se Moses ko nale ne naul se propet nir, ko ngok nir parirpok kele kobbong renge nga poro san pimaur luwi renge mijen; sete mara-osuri te, ejki.’” ");
INSERT INTO upv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu owrai tevi jinibb sen nir owra “Nanu nga parloli jinibb parjilaklak parvitan van renge nololien parini ko wor, sete orongwos pijki. Iok ewretun, ko wi pia-sij wor niko renge m̃er nga pia-la nanu ngok nir parpelari! ");
INSERT INTO upv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Erres p̃elak poro nga parsaro puwomu pingavil parla nevöt nga milep ko san, ko parile dil renge m̃ernen nowen ko parjuröni ngalu renge dis mot, p̃iasie nga poro puloli nir nga welili ngel san p̃ijilaklak pivitan van renge nololien. ");
INSERT INTO upv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Kami kapmetmet lululweni kami lweni ko wor. Poro tuwam rreknga tasim puloli p̃isij tevim, ko nik kupwera lilane ko wor tevi ni. Ko poro nolon pulululwi, ko kuptelasi tweni nololien sen. ");
INSERT INTO upv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ko poro puloli p̃isij tevi nik pivavis kis renge nabong sansan bbong, ko ngok poro pulwi vini jim puwra nolon olululwi, ko ngok, nik kuptelasi tweni ko wor.” ");
INSERT INTO upv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ko aposol nir arwerai tevi Iesu arwera “Numal, kuploli nosurien se kem puruj kele wor van mare.” ");
INSERT INTO upv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ko Numal owra lweni tevir owra “Po, ko poro nosurien se kami puwelili bbong pirpe jelangi nubek, ko kamrongwos kapwerai tevi nai sikmon nga milep ngel, ‘Nik lweni kuprrangi twenim ko kupan kuptur renge dis,’ ko ni puloli kobbong pirpe nga kami kamwerai ngok ko tevi. ");
INSERT INTO upv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ko isi niko renge kami poro jinibb ne majingen sen p̃imajing renge orsel p̃ilawlaw rreknga pimetmete sipsip, ko poro pulwi vini ngaim e, ko nik kupwerai tevi, ‘Erres, kupsaro pingavil, kuptajer ko pa kup̃aan.’ ");
INSERT INTO upv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ejki rres nawon, nik kupwerai ma tevi ‘Nik kuploli nanen suk puto teraik, ko nik kupla netatuw som ko kuptatuwe ko kupselsale nanen suk daron nga inu b̃eaan e, ko beminmin jile mun pusuw. Ko vitunen vajin ko nik ko kupa-aan ko kupa-minmin.’ ");
INSERT INTO upv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ko kami kamrrorrmi numal nen owra erres tevi jinibb ne majingen sen suri nga muloli nanu ngel nir nga ni muwrai? Ejki! Evi wor nanu nga puloli ko. ");
INSERT INTO upv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ko kami kele kapirpok, kaploli nanu jile nga inu nuwrai tevi kami nga kaplolir, ko ngok ololi kami kapwera vajin ‘Niko erres ko wor, kem ngel namivi bbong jinibb ne majingen som le, osorsan ko wor renge nabloli pirpok.’” ");
INSERT INTO upv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ko daron nga marivel suri sel nga paran Jerusalem e, ko Iesu eptevir arivel rrurrngi renge liven ne Sameria ko Galili. ");
INSERT INTO upv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ko aran laut renge ngaim nen san. Ko jinibb nga marmesi e mesien nga niber m̃im̃emaul esngavöl arini ji Iesu. Ko sete arini morie, artur bbong ngasu. ");
INSERT INTO upv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ko arverus van jin, arwera “Iesu, Numal, warru kuprrorrmi kem!” ");
INSERT INTO upv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ko Iesu oklu van emtenir, ko owrai tevir “Kami kapan ji batun jinibb ne sulsulen ko kaploli ni pununri kami.” Ko daron nga marok-ivel suri bbong sel malum e vini, ko nir jile arwokwok pa osuw. ");
INSERT INTO upv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ko san renge nir nga esngavöl ngok m̃ilesi muwokwok ko olwi vini ko osrövi Atua drrelan ean mare jer. ");
INSERT INTO upv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ko daron nga mivini ji Iesu, ko ejipa van ngatan renge dan re b̃ela Iesu, ko owra erres tevi ni. Ko m̃ernen evi m̃eri Sameria ko. ");
INSERT INTO upv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ko Iesu osusi lweni owra “Nuwrate nga nuloli nir esngavöl ko arres arwokwok luwi, ko nibeni nir esiw? ");
INSERT INTO upv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Sete nir san orongwos pulwi vini pusrövi Atua, m̃erel bbong esan nga mivi jinibb neturvitan!” ");
INSERT INTO upv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ko ni owrai tevi m̃ernen, “Kuptur imare ko kupvijuri sel som, ko kupluwi. Nosurien som ololim kumwokwok ko kumrres.” ");
INSERT INTO upv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ko Parasi sopor arsusi tevi Iesu arwera “Batun vanu se Atua pivini seveling?” Ko Iesu owra lweni tevir owra “Batun vanu se Atua sete orongwos pivini renge sel nga parlesi rengen. ");
INSERT INTO upv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sete jinibb san puwrai tevi nik, ‘Kuplesi ngel’, rreknga ‘Kuplesi ngokwan,’ ejki. Batun vanu se Atua oto pa renge nolo jinibb.” ");
INSERT INTO upv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ko Iesu owrai tevi jinibb sen nir owra “Mian ko daron nen pia-vini nga kami kapmerreni kaplesi nabong se Jinibb Mawos, ko kami sete kamrongwos kaplesi. ");
INSERT INTO upv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ko jinibb nir arongwos parwerai tevi kami, parwera ‘Kaplesi ngokwan!’, rreknga ‘Kaplesi ngel!’; ko ngok kami sete kapan kapkulkulu pej te, pijki. ");
INSERT INTO upv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Erpe navil nga mivil, daron nga mivil renge devje melrin ko mimor vaseni melrin p̃etp̃eti mivesane mijpari devjen, nga jinibb jijle nir marlesi. Ko ngok pia-irpok renge inu Jinibb Mawos renge daron nga bea-luwi vini. ");
INSERT INTO upv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ko womunen inu bornge p̃isij renge nanu pilep renge dul nga marmaur lelingen ngel parloli tevik. ");
INSERT INTO upv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Erpe renge daron se Noa tuwi jinibb nir arlelea nawon, ko ngok pirpok ko renge nabong se inu Jinibb Mawos. ");
INSERT INTO upv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Renge daron nen ko jinibb araan ko arminmin ko arlesi nesevin, ko armusus parunge nale se Noa, mianan mijpari daron nga Noa mian renge lolo drrav nga muwse; ko nuwi owlu ko ervei jinibb nir, ko armij p̃etp̃eti. ");
INSERT INTO upv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pirpe kele nabong se Lot. Jinibb araan ko arminmin ko arwulwul ko aruw ko arilili naim nir. ");
INSERT INTO upv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ko mian ko mijpari daron nga Lot mivel lingi Sotom e, ko nabb ko nevöt nga marin arvitvitan renge melrin erpe naus nga mus, ko osli nir, arin p̃etp̃eti arivi niavin. ");
INSERT INTO upv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ngok nabong se inu Jinibb Mawos nga bevini rengen pusorsan tevi ko pirpok. ");
INSERT INTO upv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ko renge nabong nen, m̃er nga m̃ililik vare renge naim sen ko joron marto renge loloim, ni sete pian kele mun p̃ila twenir. Ko m̃er nga mutur renge orsel, ni sete puwlu luwi kele mun van renge naim sen nga p̃ila joron. ");
INSERT INTO upv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kaprrorrmi sev nga miplari ji nesen se Lot. ");
INSERT INTO upv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Si nga mimrreni p̃ila se mauren sen, m̃ernen putor jabble mauren sen. Ko si nga ma mutor jabble mauren sen, ni pia-la lweni mauren sen. ");
INSERT INTO upv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ko inu nuwrai tevi kami, renge nat nga mupong nen, jinibb p̃ieru pormatur renge maling pisansan; ko parteka tweni tuwen, ko nuru tuwen nen p̃ilik jer. ");
INSERT INTO upv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ko nesevin p̃ieru porlik lat pisansan parvarrvarr; ko nuru tuwen parteka tweni, ko nuru tuwen p̃ilik jer. ");
INSERT INTO upv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jinibb p̃ieru pormajing renge orsel; tuwen parteka tweni, ko nuru tuwen p̃ilik jer.” ");
INSERT INTO upv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ko jinibb sen nir arwera lweni tevi “Ngabe ko, Numal?” Ko Iesu owra lweni tevir owra “Lat nen kapa-lesi wos bbonge ko. Pirpe daron nga nanu san emij, ko numön nir nga marok-tasi parmot rrale; orongwos kaplesi wose kobbong ngasu.” ");
INSERT INTO upv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ko Iesu owra nale rrongrrongvi san tevi jinibb sen nir nga pivisvisenir e nga parlot tetajer, sete partibbtibbot e. ");
INSERT INTO upv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Owra “Numal san elik renge ngaim san. Ko ni sete emtutu rragrrag Atua, ko sete ornge jinibb san. ");
INSERT INTO upv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ko renge ngaim nen nesevin san nga diwen sen mimij lingi elik rengen. Ko vinnen evini tetajer ko pa jin, ok-luni suri numal nen nga puloli lilane nanu nga muto jin ko ji devje nuval sen. ");
INSERT INTO upv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ko numal nen omusus puloli. Epriv wor mian, ko vitunen vajin ni lweni orrorrmi lweni ko owra ‘Inu sete numtutu Atua ko sete nurnge jinibb san. ");
INSERT INTO upv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ko suri vinel mutor momorie pa mivini ko mivijajeng jik, ko bololi ma nanu nga muwrai. Poro pijki, ko ngok puloli inu sete numa-lik m̃irres rragrrag, pivijajeng inu ko tetajer.’ ");
INSERT INTO upv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Ko kami kamrunge sev nga numal nga m̃isij nen muwrai. ");
INSERT INTO upv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ko erpese renge Atua ko jinibb sen nir nga mutobbtobbue nir, nga marngir suri ni renge nata m̃irin ko nata mupong? Kami kamrrorrmi ni orongwos pulolola renge puloli nanu nga marngir suri ngok e? ");
INSERT INTO upv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Inu nuwrai tevi kami, Atua pisaro pingavil, puloli lilane nanu nen tevir. Ko inu Jinibb Mawos renge daron nga bea-luwi vini e, ko bea-lesi nosurien puto malum renge jinibb ne iel ngatan nir, rreknga ejki mun?” ");
INSERT INTO upv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ko Iesu owra nale rrongrrongvi san tevi jinibb nir nga marok-linglingi lweni nir lweni marok-wera marres, ko marok-kulu wutan re jinibb m̃inij nen nir. ");
INSERT INTO upv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Jinibb eru oran loloim renge naim ne loten nga porlot. Nuru tuwen evi Parasi, ko nuru tuwen nen evi jinibb nga mok-la nevöt ne takis. ");
INSERT INTO upv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ko Parasi esan otur ko olot owra ‘Atua, nuwra erres wor tevi nik, suri nga inu sete nurpe jinibb nga ngok nir nga marok-vevna ko marok-loli nanu nga sete marres, ko marok-loli m̃isij tevi nesevin nir. Ko inu sete nurpe kele m̃er nga mok-la nevöt ne takis ngel. ");
INSERT INTO upv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Renge wik jile inu nomok-linglingi nanen renge nabong nen eru, ko jorok nir, nomok-la songovlön tevi nik tetajer.’ ");
INSERT INTO upv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ko m̃er nga mok-la nevöt ne takis nen otur tuwi ngasu, ko sete oklu imare emteni melrin, ejki. Ko owjuwje morkon nga miviseni nga murnge m̃isij, ko owra ‘Atua, kuprrorrmi inu! Nuvi jinibb nga m̃isij.’” ");
INSERT INTO upv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ko Iesu owrai tevi nir, owra “Nuwrai tevi kami, m̃erel ko, daron nga morivare, ko ni ko evi m̃er nga mumomsawos renge no Atua nen, ko sete nuru tuwen nen. Suri m̃er nga m̃ilngi ni van mare, ko Atua puloli ni pian ngatan; ko m̃er nga m̃ilngi ni van ngatan, ko Atua p̃ilngi ni van mare.” ");
INSERT INTO upv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ko jinibb sopor arpitevi bipiwarreng ser nir arini ji Iesu nga ni p̃ilngi nevren rer ko p̃irij p̃irres surir. Ko daron nga jinibb sen nir marlesi, ko arwer orer sete paran jin, pijki. ");
INSERT INTO upv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ko Iesu everus nir paran jin. Ko owra “Kaplinglingi bipiwarreng nir parini jik, sete kapwer orer te, pijki. Suri batun vanu se Atua evi se nir ko nga nolor marirpe bipiwarreng ngok nir. ");
INSERT INTO upv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nuwretun nuwrai tevi kami, M̃er nga sete puloli nolon pivini pirpe bipiwarreng, ni sete orongwos pian renge batun vanu se Atua.” ");
INSERT INTO upv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ko m̃erwomu san re m̃eri Isrel nir osusi tevi Iesu, owra “Wurru, jinibb nevisvisenien nga m̃irres, bololi pirpese ko b̃ela mauren nga muto tuwi ngok vini?” ");
INSERT INTO upv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ko Iesu owra lweni tevi m̃ernen, owra “Erpese nik kumverus inu m̃erres? Sete san erres, Atua kobbong esan erres. ");
INSERT INTO upv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ko nik kurongwose pae nale nesesreien se Atua nga muwra ‘Nik sete kupvenae nesevin, ko sete kuprevji pini jinibb, ko sete kupvevna, ko sete kupkerkeris, ko kuptori tata som ko tasu som.’” ");
INSERT INTO upv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ko ni owra “Nanu ngok nir, inu nulolir jile pa renge daron nga bbong mevi nanwarreng e ko mijpari lelingen ngel.” ");
INSERT INTO upv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ko daron nga Iesu murnge muwrai mirpok, ko owra lweni tevi owra “Nanu sansan kobbong ojpon evi nga kummerreni malume. Jorom nir kupwulwul p̃etp̃eti nir, ko kuptutweni nevöt ner tevi b̃eres nir. Ko nik jorom pia-to renge melrin. Ko kupini kupvijurik.” ");
INSERT INTO upv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ko daron nga m̃ernen murnge nale ngel e, ornge lengleng esij e. Suri ni evi jinibb nga joron milep san. ");
INSERT INTO upv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ko Iesu elesi nga m̃ernen ornge lengleng esij e. Ko owra “Evi nanu nga m̃iterter milep nga jinibb nga joron milep pian renge batun vanu se Atua. ");
INSERT INTO upv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Erpe nato, eterter temijpal renge liwen pietiv. Ko nga jinibb nga joron milep pian renge batun vanu se Atua, eterter temijpal wor asie ngok.” ");
INSERT INTO upv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lartul nga marunge muwrai mirpok arwera lweni tevi, “Aro, poro pirpok ko isi ko ma p̃iasi pimaur?” ");
INSERT INTO upv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ko Iesu owra lweni tevir “Sev nga m̃iterter re jinibb puloli, sete eterter rragrrag renge nga Atua puloli.” ");
INSERT INTO upv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ko ngok ololi Pita owra lweni tevi, “Ko kuplesi, kem namiel lingi nanu jijle nga marivi se kem nir arjipon, ko namvijuri nik.” ");
INSERT INTO upv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ko Iesu owra lweni tevir “Inu nuwretun nuwrai tevi kami, m̃er nga mivel lingi naim sen, rreknga nesen sen, rreknga tuwan tevi tasin nir, rreknga tata sen tevi tasu sen, rreknga natun nir, suri batun vanu se Atua, ");
INSERT INTO upv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","m̃ernen pia-lai pilep kele wor renge daron nga lelingen ngel; ko renge daron nga para-vini, ko ni pia-la mauren nga muto tuwi ngok vini.” ");
INSERT INTO upv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ko Iesu eptevi jinibb sen nir arsan kis, ko owrai tevir owra “Kaplesi, rramtongsa le van mare e renge Jerusalem. Ko nanu jile nga propet nir maruli tuwi suri inu Jinibb Mawos parpelari ko wor. ");
INSERT INTO upv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Partekai inu van ji jinibb ne vare, ko partetnije inu ko parlutövi inu. ");
INSERT INTO upv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ko nir parvirralik ko parevji pinik. Ko nabong p̃itul, ko inu bemaur luwi kele.” ");
INSERT INTO upv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ko jinibb sen nir arrleng sisini nale nga muwrair ngel, ko sete arongwose rragrrage sopon. ");
INSERT INTO upv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ko Iesu otutur suri sel evan morie Jeriko. Ko jinibb san nga mok-ngun-ngun nga meten murrorr, elik renge jeli sel. ");
INSERT INTO upv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ko daron nga m̃er nga meten murrorr nen murnge delung jinibb nga milep marivel asi renge sel, ko osusi owra “A, sev ko ngok?” ");
INSERT INTO upv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ko nir arwera lweni tevi arwera “Iesu ne doNasret ko m̃iasi ngok.” ");
INSERT INTO upv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ko daron nga murnge, ko ekail everus van mare owra “Iesu, nik Devet metka sen, kuprrorrmi inu!” ");
INSERT INTO upv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ko jinibb nga martur van womue renge lat nga non mimawos e arwera ore ni, arwera “Kupmurrarrong!” Ko ni ea-verus temijpal kele ko ma van mare lengleng, owra “Nik Devet metka sen, warru kuprrorrmi inu!” ");
INSERT INTO upv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ko Iesu otur murrong, ko owra partekai ni van jin. Ko daron nga mivel vini mori ji Iesu, ko osusi tevi, ");
INSERT INTO upv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","owra “Nik kumarong nga inu bololi sev tevi nik?” Ko metrrorr nen owra lweni tevi owra “Numal, numrreni kuploli metek puklu!” ");
INSERT INTO upv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ko Iesu owra lweni tevi owra “Kupkulu! Nosurien som ololi nik kumrres.” ");
INSERT INTO upv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ko meten oklu evesane. Ko evijuri Iesu, ko osrövi Atua. Ko daron nga delung nir marlesi e, ko arsurövi Atua. ");
INSERT INTO upv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ko Iesu evijuri sel van renge Jeriko e, nga p̃iasi lingi ie vajin; ");
INSERT INTO upv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ko jinibb san nga nisen Sakias elik renge iok. Ko ngok renge nir nga marok-la nevöt ne takis, ni evi jinibb nga milep rer, ko evi jinibb nga joron milep kele. ");
INSERT INTO upv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ni okluklu pej Iesu, owra p̃ilesi wose evi jinibb nga mirpese ko. Ko sete orongwos p̃ileslesi, suri ni evi jinibb nga mumrrol jer, ko delung elep p̃elak. ");
INSERT INTO upv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ko owlu wowomu asie delung nir, ko ean esa renge drru nai san nga mirpe nai sikmon, emrreni p̃ilesi wose Iesu renge daron nga pia-asi renge sel nen. ");
INSERT INTO upv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ko daron nga Iesu mivel vini mumomsawose lat nen, ko esarrerr imare emteni, ko owrai tevi owra “Sakias, kupsaro pingavil, kupjubbul vini ngatan e. Suri nga lelingen inu b̃elik renge loloim som.” ");
INSERT INTO upv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ko Sakias esaro ngavil, ojubbul vini ngatan e, ko eptevi Iesu. Ko eir lengleng. ");
INSERT INTO upv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ko daron nga delung marlesi e ko arwor surie, arwera “Ni evan renge naim se jinibb nga m̃isij!” ");
INSERT INTO upv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ko daron nga marsakel vajin re naim se Sakias, ko Sakias otur mare ko owrai tevi Numal owra “B̃ela wukari jorok nir; devjen bea-lai tevi b̃eres nir, ko devjen pivi suk. Ko poro nuvnae pa joro jinibb san, ko bea-la lweni nanu pivij bea-kele e.” ");
INSERT INTO upv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ko Iesu owra lweni tevi owra “Lelingen mauren easi vini renge naim ngel, suri nik kele kuvi Epram metka sen san. ");
INSERT INTO upv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Suri inu Jinibb Mawos nuvini nga nomok-pej nir nga marsarr marjijki nga b̃ela ser.” ");
INSERT INTO upv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ko daron nga marmurrarrong suri nanu ngel nir e, ko Iesu erij malum ko pa etajer tevi, owra nale rrongrrongvi san. Suri ni evini mori pa renge Jerusalem e, ko suri nga nir arok-rrorrmi nga batun vanu se Atua pivini p̃irrmali pingavilvil. ");
INSERT INTO upv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ko ni owra “Jinibb nga mivi jinibb nga milep san owra pian ngasu renge vanu nga milep san, nga parloli ni pivi batu numal ne vanu sen, ko pia-luwi vini. ");
INSERT INTO upv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ko ni everuse jinibb ne majingen sen esngavöl arini ji ni, ko ela nevöt san nga marwera mina esngavöl tevi nir sisamis. Ko owrai tevir, owra ‘Kapla nevöt ngel nir ko kapmajing rer, ko kaprevei kele nevöt sopor parto tevir, pian pijpari renge daron nga inu bolwi vini e.’ ");
INSERT INTO upv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ko ni evel lingi vanu sen. Ko jinibb sen nir nga renge vanu sen arungasi ni, ko arkoni jinibb sopor arvijuri ni nga parwera ‘Kem sete nammerreni m̃erel pivi numal se kem, ejki.’ ");
INSERT INTO upv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ko daron nga mulwi vini e, nga m̃ila jile derteren sen erpe batu numal, ko everus jinibb ne majingen sen nen nir nga ni m̃ila nevöt tevir parini ji ni, nga ni purnge jir nga nir armajing re nevöt nen nir, ko evis nga marlai kele muto tevi. ");
INSERT INTO upv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ko m̃erwomu nen evini ko otur womu renge non, ko owra ‘Numal kuplesi, nevöt som le ngel. Ko inu numajing ren, ko nula kele esngavöl oto tevi nga kumlai tevik.’ ");
INSERT INTO upv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ko ni owrai tevi owra ‘Nik kuloli erres, kuvi jinibb ne majingen nga m̃irres. Nik kuloli erres renge nanu nga welili jer bbong. Inu b̃elngi nik kupmetmete ngaim nga marlelep pisngavöl.’ ");
INSERT INTO upv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ko nir erwen evini kele, ko otur womu renge non, ko owra ‘Numal, kuplesi nevöt som le ngel, ko inu numajing ren, ko nula kele elim oto tevi nga kumlai tevik.’ ");
INSERT INTO upv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ko ni owrai kele tevi m̃ernen, owra ‘Nik kele kupivi numal renge ngaim nga marlelep pielim.’ ");
INSERT INTO upv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ko nir itolin kele evini, ko owra ‘Numal, kuplesi nevöt som le ngel. Inu nulai ko nunbunb̃e ore e kalek e, ko nulngi oto. ");
INSERT INTO upv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Suri numtutue nik; kuvi m̃er nga murrum m̃iterter. Komok-la kele nanu nga nik sete kumlingi, ko komok-la kele nanu nga sete kumruwir.’ ");
INSERT INTO upv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ko ni owra lweni tevi m̃ernen owra ‘Nik kuvi jinibb ne majingen nga m̃isij, inu b̃ewer lokloksim suri nale som ngok ko nir. Suri nik kurongwose nga inu nuvi jinibb nga murruk m̃iterter, nomok-la nanu nga sete m̃elngir, ko nomok-la nanu nga sete morwir. ");
INSERT INTO upv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ko erpese sete kumla nevöt suk ko kumlingi renge naim ne nevöt lat nga marok-to rengen e? Ko daron nga inu bea-luwi vini e, ko bea-la lweni nevöt suk tevi majbböl nen.’ ");
INSERT INTO upv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ko ni owrai tevi lartul nga martur ie, owra ‘Kapla tweni nevöt nga mutorir jin, ko kaplai tevi m̃er nga mutori misngavöl.’ ");
INSERT INTO upv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ko nir arwera lweni tevi arwera ‘Numal, ko ni otori pa esngavöl osuw!’ ");
INSERT INTO upv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ko ni owra lweni tevir, owra ‘Inu nuwrai tevi kami, nir jile nga martori, parlai kele wor tevir. Ko nir jile nga sete martori, ko beblen nga martori, para-la tweni jir. ");
INSERT INTO upv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ko jinibb suk ngel nir nga marungasi inu ngel, nga sete marmerreni inu bevi numal ser ngok, kapreveir vini jik, ko kaprevji pinir renge inu nok.’” ");
INSERT INTO upv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ko daron nga Iesu muwra jile nale ngel e, ko otongsa wowomu van renge Jerusalem e. ");
INSERT INTO upv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ko daron nga marini mori Betpaj e ko Betani renge botwen nga marveruse Botwen ne lolnai ne olip, ko ni okoni jinibb sen eru, ");
INSERT INTO upv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","owra “Koporivel, koporwowomu van renge ngaim nga muto mawos kamru ngok. Ko koporlesi natu dongki san ni ko arile totoni otur nga jinibb san setewor esakel rrongvi rengen. Ko koportelasi tweni dalin ko koporile vini. ");
INSERT INTO upv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ko poro jinibb san pususi tevi kamru, ‘Erpese komortelasi?’, ko kamru koporwera lweni tevi koporwera ‘Numal emrreni’.” ");
INSERT INTO upv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ko laru nga Numal mukoni nuru nen orivel suri sel van, ko orlesi erpe nga Numal muwrai tevi nuru. ");
INSERT INTO upv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ko daron nga mortelasi tweni dil ne natu dongki e, ko lartul nga ser arlesi ko arwera tevi nuru, arwera “Erpese kamru komortelasi tweni dil ne natu dongki?” ");
INSERT INTO upv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ko nuru orwera lweni tevir orwera “Numal le emrreni.” ");
INSERT INTO upv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ko nuru orile vini ji Iesu. Ko nir arp̃elseni sunsun ser renge drrun, ko arloli Iesu esa esakel rengen. ");
INSERT INTO upv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ko daron nga mivel suri sel e ko nir sopor kele arla sunsun ser ko arp̃elsenir renge sel. ");
INSERT INTO upv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ko daron nga ni mivini mori Jerusalem e renge lat nga sel mujubbul van ngatan e renge Botwen ne lolnai ne olip e, ko delung jile nga marivi jinibb sen nir artipatun arir ko arsurövi Atua, drrelar elep van mare, suri nanu nga marinijnij nawone nir nga marlesir. ");
INSERT INTO upv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ko arwera “Numal Atua, nik kurij pa erres tevi ni nga mivini renge nik nisem. Demat puto renge melrin ko nosrövien pian ji ni, Atua ne Drromsen Mare.” ");
INSERT INTO upv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ko Parasi sopor renge meling jinibb nga milep ngel arij van ji Iesu, arwera “Jinibb nevisvisenien, kupwer ore jinibb som nir!” ");
INSERT INTO upv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ko Iesu owra lweni tevir owra “Nuwrai tevi kami, poro nir parmurrarrong, ko nevöt nawon ngel nir vajin parkail van mare.” ");
INSERT INTO upv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ko daron nga Iesu mivini morie Jerusalem ko emteni, ko etengsi, ");
INSERT INTO upv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","owra “Poro bbong kuprongwose nabong nga lelingen, ko nik kuprongwose nanu nga mivi demat ko! Ko ejki mun, lelingen ngel metem sete orongwos p̃ilesi mun. ");
INSERT INTO upv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mian ko nabong nen nir para-vini, ko nir nga marivi devje nuval som partuwe nawot nga puwlu rralem, ko parlik rralem ko parmetmet ore nik renge iok jijle. ");
INSERT INTO upv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ko nir parjijkarre p̃etp̃eti nik ko jinibb nga marlik tevim renge live laut ne nawot som, ko sete parlinglingi nevöt ne nawot nen san p̃ijnget jer renge pisan. Suri nik sete kurongwose daron nga lelingenok nga Atua muwra p̃ila som.” ");
INSERT INTO upv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ko Iesu evan renge loloim ne Naim On. Ko ejeli tweni nir nga marwulwul, paran vare e. ");
INSERT INTO upv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ko owrai tevir owra “Aruli erpel renge Naul On: Atua owra ‘Naim suk parveruse naim ne verusen’. Ko kami kamtur imare vajin ko kamloli evi ‘naim ne venao res.’” ");
INSERT INTO upv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ko renge nabong jijle Iesu ok-an ok-visviseni renge Naim On. Ko batu jinibb ne sulsulen ko jinibb ne nevisvisenien ne nale nesesreien nir armerreni parevji pini. ");
INSERT INTO upv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ko arrelenge suri lat nga parloli suri e, sete artor sweri sel san nga parloli rengen. Suri delung jile arkomrönir suri, armurrarrong kemkam̃e nale sen nir. ");
INSERT INTO upv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mian ko errmali erpel: renge nabong san, daron nga Iesu mok-visviseni jinibb nir e renge Naim On ko mok-werwer renge nosp̃en nga m̃irres, ko batu jinibb ne sulsulen sopor ko jinibb nevisvisenien ne nale nesesreien sopor ko b̃irterawarreng sopor arkorti ko arini. ");
INSERT INTO upv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ko arsusi tevi, arwera “Kupwerai ta tevi kem, isi ko ela derteren ngel tevi nik, nga kumrres renge kuploli nanu ngel nir?” ");
INSERT INTO upv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ko Iesu owra lweni tevir owra “Ko inu kele bosusi ta nale san ni le tevi kami, ko kami kapwerai tevik. ");
INSERT INTO upv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Baptaesen se Jon evel ji Atua vini, rreknga evel ji jinibb kobbong vini?” ");
INSERT INTO upv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ko nir arsupsup̃e suri lululweni tevi nir kis bbong ko arwera “Rrapwera pirpese? Poro rrapwera ‘Evel ji Atua vini,’ ko ni puwra ‘Ko suri sev kami sete kamosuri Jon?’ ");
INSERT INTO upv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ko poro rrapwera ‘Evel ji jinibb vini,’ ko delung ngel nir parla nevöt nir ko partuwe pini kerr e. Suri nir artori Jon evi propet.” ");
INSERT INTO upv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ko nir arwera lweni tevi arwera “Iawo, kem namrrelenge lat nga mivel e vini.” ");
INSERT INTO upv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ko Iesu owra lweni tevir owra “Ko inu kele sete numa-werai tevi kami inu nula derteren ngel ngabe le nga mololi nanu ngel e nir.” ");
INSERT INTO upv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ko Iesu etipatun owra nale rrongrrongvi ngel tevi delung nir, owra “Jinibb san orwi naut ne grep san. Ko elngi tevi jinibb sopor parmajing rengen, ko ni evel van renge ngaim m̃inij san, ko elik ie epriv val wor. ");
INSERT INTO upv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ko renge daron mawos nga grep wenen marok-mirr e, ko numal nen okoni jinibb ne majingen sen san van ji lartul nga marmajing rengen, nga parla merrenien ne wenen nen sopon tevi. Ko lartul nen nir arvirrvirrali m̃ernen ko arkoni tweni ototori nevren, olwi kiskis tevi. ");
INSERT INTO upv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ko numal nen okoni kele jinibb ne majingen sen m̃inij nen kele san evan. Ko m̃ernen kele lartul nga arvirrvirrali, ko arloli esij tevi jile osuw, ko arkoni tweni ototori nevren, olwi kiskis kele tevi. ");
INSERT INTO upv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mian ko numal nga okoni kele nir itolin van; ko m̃ernen kele lartul nga arevji lenglenge ko arwirre van vare e. ");
INSERT INTO upv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ko numal ne naut ne grep nga owra ‘Aro! Bololi pirpese? Inu bokoni vajin natuk nga memrreni, ko ni ko ma nir partori p̃irres ko.’ ");
INSERT INTO upv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ko daron nga lartul nen nir marlesi ni, ko arwerwera lululweni tevir, arwera ‘Ngok natu numal nen ko ngok! Kerr pirevji pini, ko orsel sen pivi vajin se kerr!’ ");
INSERT INTO upv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ko arrul totoni, ko arevei tweni re orsel van vare e, ko arevji pini emij.” Ko Iesu owra “Ko numal ngel pia-loli pirpese tevir? ");
INSERT INTO upv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ni pia-revji pini lartul ngel nir parmij, ko p̃ilngi orsel ngel tevi jinibb m̃inij nir.” Ko daron nga marunge nale ngel nir e, ko delung arwera “Ejki rres nawon!” ");
INSERT INTO upv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ko Iesu oklu mawos nir, ko osusi tevir owra “Ia, ko nale nga maruli renge Naul On ngel owra sev le, nga muwra ‘Nabur nga jinibb nga marok-majinge naim marungasi marwirre, ni ko vajin evi nabur nga murrul totoni naim m̃iterter.’ ");
INSERT INTO upv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Si nga pusnge nabur ngel, niben pimabbur; ko si nga nabur ngel piravij ren, niben pumoloplop p̃etp̃eti.” ");
INSERT INTO upv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ko renge daron momsawos nen ko pa ko jinibb nevisvisenien ne nale nesesreien nir ko batu jinibb ne sulsulen nir arloli lesi parevei Iesu. Suri arongwose nga ni owra nale rrongrrongvi ngok ewer lokloksi nir rengen. Ko armetutue jinibb nir, ololi setemun arrul totoni. ");
INSERT INTO upv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ko nir arpejpej sel san nga poro p̃irres renge nir nga puloli partor wos Iesu rengen, ko niko puloli nir parongwose vajin parlingi ni van renge nevre numal, ko numal vajin pia-tor pini. Ko niko arwuli jinibb sopor nga paran parloli sel kerkeris tevi ni, nga puloli nir parla Iesu renge nale sen nir. ");
INSERT INTO upv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ko lartul ngel nir arsusi kerkerasi tevi Iesu, arwera “Jinibb nevisvisenien, kem namrongwos iok, sev nga kumwerai ko kumvisviseni jinibb e nir arweretun temijpal. Ko sete komok-rrorrmi san, poro evi jinibb nga milep rreknga muwelili, ko kurij telair ko wor, komok-visviseni marongen se Atua weretunen tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ko nammerreni nabrongwose ta, Ia, erres kobbong renge nale nesesreien se kerr nga poro rrapwuli takis tevi Sisa, batu numal se m̃eri Rom nir, rreknga sete erres?” ");
INSERT INTO upv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ko Iesu elesi wose nale gerisen ser nga marwerai nga markerkerasi e, ko owrai tevir owra ");
INSERT INTO upv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kapsareni ta nevöt nen tevik b̃elesi.” Ko nir arlai san tevi. Ko ni owra “Isi le non ngel, ko nisen maruli rengen ngel?” Ko nir arwera “Rrekma Sisa ko.” ");
INSERT INTO upv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ko Iesu owra lweni tevir, owra “Ko niko nanu nga mivi se Sisa kapla lweni tevi Sisa. Ko nanu nga mivi se Atua, kapla lweni tevi Atua.” ");
INSERT INTO upv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ko lartul ngel nir sete arongwos parlai ni renge nale sen ngel nir renge no jinibb nir. Artaole muwrai mirpok, ko armurrarrong jer. ");
INSERT INTO upv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ko Satusi sopor, nga marok-wera jinibb sete orongwos pimaur luwi kele renge mijen, arini ji Iesu ko arsusi kerkerasi tevi ");
INSERT INTO upv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","arwera “Ia, ko jinibb nevisvisenien, Moses oli pa renge nale nesesreien se kerr nga muwra ‘Poro jinibb san pimij, ko poro m̃ernen elesi nesevin san, ko natu nuru ejkie, ko ngok tasin p̃ilesi kele nesevin nga tuwan mimij lingi nga, ko pivesi wani metka se tuwan nga mimij ngok.’ ");
INSERT INTO upv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ko ngok, jinibb niaken ebut; m̃erwomu nen elesi nesevin, ko mian ko emij, ko natu nuru ejkie. ");
INSERT INTO upv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ko m̃ervitu nen kele elesi. ");
INSERT INTO upv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mian ko nir itolin kele elesi vinnen. Mian mian ejpari nir jile nga ebut nen arlesi vinnen. Ko nir jijle natur ejkie, ko armij lingi vinnen. ");
INSERT INTO upv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Vitunen vajin ko vinnen vajin emij. ");
INSERT INTO upv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ko mirpok ngok, renge nabong nga Atua puloli jinibb nir parmaur luwi kele re mijen, nir si nen ko pia-ivi nesen sen e? Suri nir ebut jile ngok martekai vinnen. Kupwerai ta we!” ");
INSERT INTO upv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ko Iesu owra lweni tevir, owra “Renge iel ngatan ngel, norman nir ko nesevin nir arongwos partotko. ");
INSERT INTO upv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ko nir nga Atua m̃ilesir arres re parmaur luwi re mijen renge liken ne tuwi ngok vini, nir ko ma sete arongwos parok-totko. ");
INSERT INTO upv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nir arsorsan tevi anglo nir, parmaur tuwi ngok vini, sete arongwos parmij kele mun. Nir arivi pa Atua natun, suri ni ololi nir armaur luwi kele renge mijen. ");
INSERT INTO upv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ko renge devjen ne nir nga marmij, nga mivi weretunen nga marongwose parmaur luwi renge mijen, Moses kele nga kami kamtori, ni ko eviseni tweni nga evi weretunen. Suri renge jilweren ne nai welili nen nga nabb muroror ren ko sete ani, Moses oli nale se Atua nga muwra ‘Inu nuvi Iova Atua se Epram, ko Atua se Aesak, ko Atua se Jekop.’ ");
INSERT INTO upv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ngok niko, ni sete evi Atua se nir nga marmij te ejki. Ni evi Atua se nir nga marmaur. Suri Atua derteren sen elep nga elep lingi mijen, ko jinibb jijle armaur kobbong renge ni.” ");
INSERT INTO upv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ko jinibb nevisvisenien ne nale nesesreien sopor arwera “Ejki, aro, jinibb nevisvisenien, nik kuwra lweni omomsawos erres p̃elak.” ");
INSERT INTO upv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ko ngok ololi nir armetutue pae ko, armusus parsusi nanu kele mun san tevi. ");
INSERT INTO upv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ko Iesu owra lweni tevir, owra “Erpese nir marwera Mesaea evi metka se Devet san? ");
INSERT INTO upv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Suri Devet lweni owrai renge naul ne Sam, owra ‘Numal Atua owrai tevi Numal suk “Kupsakel iel renge nevrek rres ko kuptiriv ");
INSERT INTO upv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pijpari nga inu b̃elngi devje nuval som parirpe lat nga kupbböt ren renge nolon b̃elam ngatan.” ’ ");
INSERT INTO upv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Niko Devet owra m̃ernen evi Numal sen. Ko poro pirpok ngok, ko Mesaea evi metka sen erpese ko?” ");
INSERT INTO upv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Daron nga jinibb nir marmurrarrong e, ko Iesu owrai tevi jinibb sen nir ");
INSERT INTO upv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","owra “Kapmetmet renge jinibb nevisvisenien ne nale nesesreien nir. Suri nir armerreni paruri sunsun nga marres marpepriv partur tevir, ko delung jile partorir p̃irres ko parsareni nevrer tevir renge sel. Armerreni parsakel renge nai seksakel nga muto limjer womu m̃irres renge Naim On, ko armerreni parsakel renge nai seksakel nga muto limjer womu m̃irres renge lat ne nanen. ");
INSERT INTO upv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nir arivi demij venao, arvenae p̃etp̃eti nijor se nesevin nga diwen ser marmij lingir; ko renge daron ngok ko pa arkerkerasi jinibb nir, arloli verusen nga marpepriv nga partori nir p̃irres rengen. Ngok Atua putor vitrangir p̃iterter asi wor suri.” ");
INSERT INTO upv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu ok-meteni jinibb nga joror milep marok-tuwe nevöt ser renge bokis nen renge Naim On se Atua. ");
INSERT INTO upv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ko ni elesi nesevin san nga diwen sen mimij lingi, ko evi b̃eres. Vinnen evini ko otuw nevöt nga wowarreng eru. ");
INSERT INTO upv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ko Iesu owra “Nuwrai tevi kami, vin nga diwen sen mimij lingi ngel, ni otuw nevöt asi wore nir jijle nga martuw nevöt ser ngok e. ");
INSERT INTO upv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Suri lartul nga ngok nir joror elep temijpal ko arlai bbong beblen ko artuwe, ko artori jere wor eleplep. Ko vinel ma emarong putuw p̃etp̃eti sev nga ni m̃ilngi nga mivi liken sen p̃etp̃eti.” ");
INSERT INTO upv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ko jinibb se Iesu sopor arok-supsup̃e suri nevöt nga marlelep lengleng nga renge Naim On se Atua, ko nevöt nga marres kele nir nga marjuroi e, ko merrenien nir nga jinibb marlair. ");
INSERT INTO upv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ko Iesu owra “Kami kamok-meteni nanu ngok nir? Mian ko daron nen pia-vini nga jinibb nir partingtinge nevöt ngok nir p̃etp̃eti nga marlelep ngok nir nga renge naim ngok. Setemun san p̃ijnget jer renge san, partingtinge p̃etp̃etir.” ");
INSERT INTO upv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ko nir arsusi tevi ni arwera “Jinibb nevisvisenien, nanu ngok nir para-pelari seveling ko? Ko sev nelesien ko piviseni nga nanu ngok nir otomori pa nga parremali?” ");
INSERT INTO upv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ko Iesu owrai kele owra “Kami kapmetmet ko wor nga sete san p̃ikerkerasi kami. Suri jinibb pilep parini renge inu nisek ko parwera ‘Inu nuvi Mesaea le’, ko ‘Daron nen evini!’ Ko kami sete kapvijuri nir te, pijki. ");
INSERT INTO upv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ko daron nga kami kaprunge marval, ko jinibb nir parlatlat nir, ko sete kapmetutu te; suri nanu ngok nir parini ko wor, parasi puwomu, ko nabong nga vitunen ejki malum ko wor.” ");
INSERT INTO upv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ko ni owrai tevir owra “Ngaim san putur imare ko pival tevi ngaim san; ko batun vanu san putur imare ko pival tevi batun vanu san. ");
INSERT INTO upv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ko nam̃i nga marlelep nir parm̃i renge vanu lele ne iel ngatan nir. Ko numer nga marlelep nir parpelari renge vanu lele ne iel ngatan nir, jinibb parmer pilep. Ko mesien lele nir parini parlokloksi jinibb nir. Ko renge melrin nanu lele nir parpelari, parloli jinibb nir parmetutu, ko nelesien lele nga marlelep nir. ");
INSERT INTO upv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nanu ngok nir setewor parpelari ko, ko jinibb parrul totoni womu pae kami ko. Ko parloli p̃isij pilep tevi kami, ko partekai kami van ji jinibb nga marmetmete naim ne loten nir. Ko parlingi kami van renge naim ne nekaien, ko parloli kami kaptur renge no numal nga marlelep nir ko no numal nga wowarreng nir, suri inu nisek muto renge kami. ");
INSERT INTO upv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngel pia-ivi daron se kami nga m̃irres nga kapa-wera tweni nosp̃en nga m̃irres. ");
INSERT INTO upv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ngok niko suri nanu ngok nir, kami kaptor ore womu re norrorrmien se kami ko p̃iterter, nga puloli sete kaprrorrmi nga kapa-wera ‘O, rrapwera lweni nale sev le tevir?’ ");
INSERT INTO upv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Suri inu ko bea-la nale ko norongwosien nen tevi kami nga kapwerai. Ngok puloli sete nir san renge devje nuval se kami purongwos p̃irij tere nale se kami rreknga puwra kamkerkeris. ");
INSERT INTO upv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ko tata se kami nir ko tasu se kami nir ko tuwa kami nir ko niaken se kami nir ko sele kami nir parlingi kami van renge nevre devje nuval se kami nir. Ko lartul nen nir parongwose parevji pini kami sopor. ");
INSERT INTO upv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mian ko jinibb jijle nir parungasi kami suri kami kamtori inu nisek. ");
INSERT INTO upv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ko jomro batu kami nir, sete pisansan pia-jijki. ");
INSERT INTO upv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kami kaptur ko wor p̃iterter, ko kapla se nem̃i kami. ");
INSERT INTO upv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mian ko daron nga kami kapa-lesi jinibb nuval pilep parini parlik rrale iel Jerusalem, ko ngok kami kaprongwose nga sete pipriv ko parlokloksi p̃etp̃eti. ");
INSERT INTO upv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ko daron nga kami kaplesi nanu ngel, ko kami nga kamlik renge Jutia, kapwolu ko wor kapan kapteptepi renge botwen. Ko kami nga kamlik Jerusalem, kami kele, kapwolu lingi wor ko. Ko kami nga kamlik renge vanu nga marto rrale ngaim, setemun kamrongwos kapluwi kele van rengen. ");
INSERT INTO upv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nabong ngel nir arivi nabong nga Atua pia-tor vitrangi jinibb nir nga puloli nanu jile nga Naul On muwrai parini parpelari. ");
INSERT INTO upv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wurru pia-sij wor niko re nesevin nga m̃itetaur ko nesevin nga muloli natun musus renge nabong nen nir. Atua lolaren sen pia-vini renge jinibb nga iel nir. Ko nanu nga parsij nga parsij p̃erp̃er pilep parini parpelari renge vanu ngel. ");
INSERT INTO upv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jinibb sopor parmij e nesip, ko sopor parlair van parlik renge naim ne nekaien nga marto renge vanu sarrsarr ngok nir. Mian ko jinibb ne vare nir parlokloksi p̃etp̃eti Jerusalem parjijkarre p̃irres pelak, sete sopon pijpon jer. Pian pian pijpari jinibb ne vare nir parini renge bongsi daron ser e nga marwomu. ");
INSERT INTO upv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Mian ko nelesien nir parto renge nial, ko navöl, ko moju nir. Ko renge iel ngatan jinibb ne vanu pilep parunge p̃isij pilep ko parmetutu dis bburbbur ko daptap nen nir. ");
INSERT INTO upv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jinibb parunge p̃isij pilep nga partiriv terai sev nga piplari renge iel ngatan totoklai. Suri derteren ne nanu nga marto renge melrin mare, Atua pulolir paririr. ");
INSERT INTO upv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mian ko jinibb nir parongwose parlesi inu Jinibb Mawos bevini beplari renge nabor tevi derteren nga milep ne nosrövien suk jijle. ");
INSERT INTO upv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ko daron nga nanu ngel nir partipatun, ko kami kaptur rramos ko apkulu kapmeteni mare. Suri inu sel ne netlasien se kami otomori bevini.” ");
INSERT INTO upv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ko Iesu owra nale rrongrrongvi san tevir owra “Erres renge kami kaprrorrmi nai pik ko nai m̃inij nen kele nga ngok nen nir. ");
INSERT INTO upv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Renge daron nga kami kamlesir martipatun martengriv luwi, ko kami kamrongwose nga daron ne numös evini mori pa. ");
INSERT INTO upv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ko pia-irpe sel ngel ko, daron nga kami kamlesi nanu ngok nir marpelari, ko kapa-rongwose nga batun vanu se Atua otomori pa pivini. ");
INSERT INTO upv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nuwretun nga nuwretun nuwrai tevi kami, dul ngel nir nga marmaur ngel nir setewor parmij ko, ko parlesi nanu ngel nir parpelpelari. ");
INSERT INTO upv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Melrin ko iel ngatan pian ko porjijki, ko nale suk ma sete orongwos pijijki nabong san. ");
INSERT INTO upv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kami kapkulkulu metmet ko wor p̃irres, suri norrorrmien se kami tilelea; kami tamok-oji nanen ko tamok-minmin tamok-lengleng, ko tamok-rrorrmi p̃elake mauren ne iel ngatan; ko ngok nabong suk tia-irpe nover, tia-tawi ore kami tivesane. ");
INSERT INTO upv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Suri nga nabong nen pivini ji jinibb jijle nga marlik renge iel ngatan totoklai. ");
INSERT INTO upv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ko niko renge nabong jijle kami kapok-metmet ko wor p̃irres. Ko kami kapok-lot ko wor, nga puloli kami derteren se kami putoe nga puloli kami kapwolu lingi nanu nga marsij p̃erp̃er ngok nir, nga puloli kami kaptur p̃irres renge no inu Jinibb Mawos.” ");
INSERT INTO upv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Renge nabong ngel nir Iesu ok-visviseni jinibb nir renge Naim On se Atua. Ko renge nat nga mupong jile ni ok-ivel lingi ie ok-tongsa van renge Botwen ne lolnai ne olip e. Ko ok-matur rrarren pa ie ko. ");
INSERT INTO upv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ko renge rorpong susu jijle jinibb arok-mermera vini jin renge Naim On nga parmurrarrong suri nale sen nir. ");
INSERT INTO upv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Daron ne nanen nga marok-rro niv nga is mijki rengen, nga marveruse nanen ne asien, oruj mori. ");
INSERT INTO upv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ko batun ne jinibb ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir arpejpej sel san nga parevei silveni Iesu rengen, nga parevji pini pimij. Armusus parloli limjer, suri armetutu temijpale jinibb nir. ");
INSERT INTO upv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ko Demij evini esilvi Jutas nga miwajie Iskariot, nga mivi san renge nir esngavöl drromon eru. ");
INSERT INTO upv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ko Jutas evel lingir ko evan owrai tevi batu jinibb ne sulsulen nir ko m̃erwomu ne jinibb nuval nir ne Naim On se Atua, nga puloli sel nga ni purongwos p̃ilngi Iesu renge nevrer. ");
INSERT INTO upv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ko lartul nen nir arunge erres e, arir lengleng, ko arloli rijrijen nga parla nevöt sopon tevi ni rengen. ");
INSERT INTO upv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ko Jutas emarong. Ko orrorrmi pejpeje sel san nga poro p̃irres renge ni nga p̃ila Iesu p̃ilngi renge nevrer, ko sel nen jinibb jijle parrerrelenge. ");
INSERT INTO upv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mian ko ejpari nabong ne nanen nen nga marok-rroi niv nga is mijki rengen. Ko renge nabong nen jinibb arok-revji natu sipsip nir nga parloli nanen ne Asien. ");
INSERT INTO upv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ko Iesu owrai tevi Pita ko Jon “Koporan koporloli lilane nanen ne Asien puto metmet ngarr terai kerr ko rrapa-uroi.” ");
INSERT INTO upv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ko nuru orsusi lweni tevi orwera “Ko kumarong nga komru noboran noborloli lilane ngarre puto terai kerr ngabe le?” ");
INSERT INTO upv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ko ni owrai lweni tevi nuru owra “Kopormurrarrong ta. Daron nga kamru koporan renge laut ne ngaim nen, ko koporsewute jinibb san ie nga muwosi botel nuwi san nga muwun, mian tevi re naim sen e. Ko koporvijuri suri ni, ko koporan renge naim nga ni pian renge loloim nen. ");
INSERT INTO upv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ko koporwerai lweni tevi m̃er nga naim sen nen, koporwera ‘Numal, jinibb nevisvisenien le okoni komru, owra noborsusi tevim nibeni le loloim nga ni putori nanen ne Asien rengen?’. ");
INSERT INTO upv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ko ngok m̃ernen piptevi kamru van renge loloim ne naim nen san nga milep temijpal nga muto mare, nga nanu jile marto pa rengen. Renge ie ko koporloli nanu jile parto metmet ngarr p̃irres.” Ko okoni nuru orivel. ");
INSERT INTO upv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ko nuru orivel oran, ko orlesi nanu jijle osorsan erpe nga Iesu muwrai tevi nuru. Ko nuru orloli lilane nanu jijle ne nanen ne Asien arto erres ngarr. ");
INSERT INTO upv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mian ko evini ejpari renge mete nial nga marok-aani nanen ne Asien ren, ko Iesu evan esakel renge milngen renge tep, ko aposol nir arsakel arpitevi ni. ");
INSERT INTO upv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ko ni owrai tevir owra “Numrreni lenglengen e borro nanen ne Asien ngel tevi kami puwomu ko vitunen vajin ko bea-runge pia-sij renge nibek. ");
INSERT INTO upv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Inu nuwrai tevi kami, setemun numa-rroi kele nanen ne Asien ngel pian pijpari pia-pelari pumomsawos p̃etp̃eti renge batun vanu se Atua.” ");
INSERT INTO upv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ko Iesu ela biles norro ko olot owra erres tevi Atua, ko owra “Biles ngel ko kaplilai tevi kami. ");
INSERT INTO upv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Suri inu nuwrai tevi kami, setemun numa-mini kele mun norro ngel renge lelingen ngel le pa ko pian pijpari batun vanu se Atua pivini.” ");
INSERT INTO upv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ko mian ko ni ela niv ko olot owra erres tevi Atua, ko obbur ototvi, ko elai tevi jinibb sen nir. Ko owrai tevir, “Ngel evi inu nibek nga m̃elai m̃isre kami. Kami kapok-loli nanu ngel pirpok ko, ko kapok-rrorrmi inu.” ");
INSERT INTO upv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ko daron nga nanen musuw ko ni ololi erpok kele renge biles; ela biles ko owra “Ngel evi inu drrak nga p̃iseser suri kami ko puloli rijrijen nga mimerr se Atua pia-pelari. ");
INSERT INTO upv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ko kaplesi jinibb san nga pia-tekai kerasi inu van renge nevre devje nuval suk nir, ni esakel tevik ni le renge tep. ");
INSERT INTO upv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Inu nuvi jinibb mawos, ko mian ko inu bemij ko wor pirpe nga Atua muwrai pa. Ko wi pia-sij wor pilep niko renge m̃er nga m̃ilngi inu van renge nevre nir.” ");
INSERT INTO upv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mian ko nir arsusi lululweni tevi nir lweni, arwera “Isi nen ko renge kerr nga ni puloli pirpok?” ");
INSERT INTO upv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ko mian ko jinibb sen nir arijrij latlat lululweni tevi nir lululweni bbong suri nir si nen ko pia-ivi jinibb nga milep asasi nen renge nir. ");
INSERT INTO upv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ko Iesu erij tevir owra “Numal nir ko jinibb nga marwowomu nir renge jinibb ne iel ngatan nir, derteren ser otoe. Ko armerreni nga jinibb nir parveruse nir parwera ‘M̃er nga mok-la se jinibb.’ Ko tetajer arok-tor vitrangi jinibb ser nir. ");
INSERT INTO upv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ko kami ma norrorrmien ngok pijki renge kami, sete kaploli pirpok. Ko m̃er nga mivi jinibb nga milep renge kami, m̃ernen puloli lweni wor ni pirpe m̃er nga vitunen jerjer renge kami. Ko m̃er nga mivi m̃erwomu renge kami, ni puloli lweni wor ni pirpe jinibb ne majingen se kami vajin. ");
INSERT INTO upv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kaprunge ta renge jinibb nga eru ngel nuru, nuru ngabes nen le eleplep renge nuru: M̃er nga m̃isakel renge tep m̃iaan, rreknga m̃er nga mok-selsale nanen vini jin? Kami kamwera m̃er nga m̃isakel ko mare renge tep m̃iaan. Ko inu nutur livö renge kami nurpe m̃er nga mok-selsale nanen nen ko ma.” ");
INSERT INTO upv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Iesu ololi rijrijen tevi jinibb sen nir, owra “Kami kamlik tevik renge daron nga nanu nir marini marpelari ji inu, nga marrowrrowe inu. ");
INSERT INTO upv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ko erpe inu Tata suk m̃ilngi pa inu mevi Numal, ko ngok inu vajin nulngi kami ");
INSERT INTO upv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nga kami kapsakel tevik renge batun vanu suk, kapaan ko kapminmin tevik renge inu tep suk, ko kaplik renge nai seksakel suk. Ko kapsup̃e lilane suri metil naim se m̃eri Isrel nir nga esngavöl drromon eru. ");
INSERT INTO upv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saemon, Saemon! kupmurrarrong ta, demij ongoni pa kami nga purrowrrowe kami pirpe jinibb nga mok-majing mok-jule tutweni dokolvin renge wit. ");
INSERT INTO upv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ko inu nomok-lot suri nik Saemon nga nik nosurien som sete pivitan te. Ko daron nga kupa-rieni lweni nolom, ko kupvijuri lwenik kele vajin, ko kupwer jilijle tasim nir nga puloli norrorrmien ser p̃iterter kele.” ");
INSERT INTO upv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ko Pita owra lweni tevi ni owra “Ejki ma, Numal, inu nomok-tiriv le vajin nga bean renge naim ne nekaien tevi nik ko bemij tevi nik!” ");
INSERT INTO upv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ko Iesu owra lweni tevi owra “Nuwrai tevim Pita, lelingen nato sete pukokorout rragrrag ko wor, ko nik kupvilvil ore womu pae inu ko pivatul nga kupwera sete kurongwose inu.” ");
INSERT INTO upv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ko Iesu owrai tevir owra “Bonevis nga daron nga mokoni kami van nga kapwerwer, ko nuwrai tevi kami nga kami sete kaptori baos ko narr ko but se kami. Ko erpese, kami nevre kami armumrrole nanu san?” Ko nir arwera “Ejki.” ");
INSERT INTO upv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ko Iesu owrai tevir owra “Ko lelingenok vajin m̃er nga m̃ilngi baos ko narr, p̃ilai putori nuru. Ko m̃er nga sete m̃ilngi nesip nuval, ko p̃ila sunsun sen puwulwule, ko puwli san e. ");
INSERT INTO upv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Inu nuwrai tevi kami nale ne Naul On ngel nga muwra ‘Nir arlesi ni oto tevi m̃er nga mutor otvi nale ne nale nesesreien,’ ngok mian ko piplari ko renge inu. Suri nale nga maruli renge Naul On nga marsup̃e suri inu, parini ko wor parpelari.” ");
INSERT INTO upv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ko jinibb sen nir arwerai tevi, arwera “Numal, nesip nuval eru le pa ngel!” Ko ni owra “Ngok evter ko pa!” ");
INSERT INTO upv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ko Iesu evel lingi ngaim ko otongsa van renge Botwen ne lolnai ne Olip e, erpe tetajer mok-loli. Ko jinibb sen nir ara-tongsa vitu suri. ");
INSERT INTO upv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ko daron nga mivini renge lat nen, ko owrai tevi jinibb sen nir, owra “Kami kaplot ko wor nga puloli kami sete kapvitan daron nga marrowrrowe kami.” ");
INSERT INTO upv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ko ni evel rujruj sopon ko ejipa van ngatan ko olot. ");
INSERT INTO upv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Owra “Tata, poro pivi marongen som, ko kuplai tweni biles ne norongen nga m̃isij ngel renge inu. Ko sete pivijuri inu marongen suk te ejki, ko pivijuri wor nik marongen som.” ");
INSERT INTO upv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ko anglo ne melrin san evini jin ko osusi lweni jile ni eterter. ");
INSERT INTO upv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ko nolon ornge esij elep lengleng; ko eplak malum olot eterter, ko erat, ko raten sen ojumjum van ngatan renge dan erpe drra. ");
INSERT INTO upv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ko daron nga mulot jile ko emra otur, ko olwi van ji jinibb sen e nir. Ko elesi nga nir marmatur pa, suri arunge esij lengleng, ko norrorrmien ser arrow arto murrarrong. ");
INSERT INTO upv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ko ni owrai tevir, “Suri sev kammatur? Kapmera ko kaplot, nga puloli kami sete kapvitan daron nga marrowrrowe kami.” ");
INSERT INTO upv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Daron nga Iesu mok-rij malum e, ko meling delung jinibb nga milep arini arpelari. Ko m̃er nga miwajie Jutas, nga mivi nir san renge nir esngavöl drromon eru, owowomue nir evini. Ko evel vini mori ji Iesu nga purromji. ");
INSERT INTO upv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ko Iesu owrai tevi Jutas owra “Nik kuptekai kerasi inu Jinibb Mawos renge nga kuprromjik?” ");
INSERT INTO upv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ko daron nga ni jinibb sen nga martur tevi marlesi wose nga sev piplari, ko arwerai tevi arwera “Pirpe? Nabla nesip nuval se kem nabpalpal e?” ");
INSERT INTO upv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ko nir san ela nesip nuval sen, ko eta jinibb ne majingen se batu jinibb ne sulsulen, ko esipri otvi boron rres. ");
INSERT INTO upv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ko Iesu owra “E, pijki, evter ko pa!” Ko ela nevren ko eptongi renge m̃er nga boron ko ololi emaw erres luwi. ");
INSERT INTO upv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ko Iesu owrai tevi batun ne jinibb ne sulsulen nir, ko batun ne jinibb nuval nga marmetmete Naim On nir ko b̃irterawarreng nga marini ie jin nga parevei ni, owra “Kami kamini tevi nesip nuval ko b̃etiluk. Kami kamrrorrmi inu nurpe jinibb venao rreknga jinibb nga mok-revrevji pinpini jinibb? ");
INSERT INTO upv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ko renge nabong jile daron nga inu m̃elik tevi kami, ko inu nomok-visviseni jinibb nir renge Naim On se Atua, ko kami sete kamloli lesi nga kapreveik te ejki. Ko lelingen ngel evi daron se kami, ko evi daron nga derteren ne nemalik piplari rengen.” ");
INSERT INTO upv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ko nir arrul totoni Iesu ko arpitevi van renge loloim se batu jinibb ne sulsulen nir. Ko Pita ok-vivitu surir ngasu wor sopon nga mok-vijurir. ");
INSERT INTO upv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ko mian ko nir arsure nabb san renge liven renge naworr nga muwlu ore naim nen, ko arlik rrale; ko Pita evan ko elik renge liven jir. ");
INSERT INTO upv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ko nesenwarreng ne majingen san elesi nga nabb muror vaseni ni m̃ilik. Ko ok-meteni suri eterter mian ko owrai owra “M̃erel kele eptevi ni le!” ");
INSERT INTO upv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ko Pita evilvil ore owra “Ejki! Vinel, inu sete nurongwose ni te.” ");
INSERT INTO upv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mian ko sete epriv kele mun ko jinibb kele san emteni ni ko owrai tevi “Nik kele kuvi nir ko san”. Ko Pita owra “Ejki ma m̃erel!” ");
INSERT INTO upv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ko vitunen vajin, erpe mete nial san asi pa osuw, ko jinibb m̃inij nen kele san osur terter tevi, owra “Ewretun le m̃erel eptevi le, suri evi m̃eri Galili le san.” ");
INSERT INTO upv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ko Pita owra “E, m̃erel, inu sete nurongwose rragrrag nanu nga kumwerai ngok!” Daron nga mok-rij malum mirpel ko nato kele okokrout evesane tevi momsawos daron nga mok-rij malum ngok e. ");
INSERT INTO upv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ko Numal erieni ko oklu emteni Pita. Ko Pita orrorrmi sweri nale se Numal nga muwrai womu pae tevi, nga muwrai mirpel, “Lelingen kobbong, renge nata mupong nga lelingen, nato setewor pukokrout ko, ko nik kupvilvil ore inu pivatul ko pa pusuw.” ");
INSERT INTO upv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ko Pita evel van vare, ko eting nga eting lengleng, emesmasorr e. ");
INSERT INTO upv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ko renge daron nen jinibb nga marmetmet ore Iesu artetnije ni, ko arwuje. ");
INSERT INTO upv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ko nir arka ore mete Iesu, ko arwerai tevi, “Kuvi propet san, ko kupwerai ta, Isi ko mivrralim ngok?” ");
INSERT INTO upv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ko nale elep kele wor nga marsij nir, marwerair tevi. ");
INSERT INTO upv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ko renge nata m̃irin nen vajin, ko b̃irterawarreng ne Isrel nir, ko batu jinibb ne sulsulen nir, ko jinibb nevisvisenien ne nale nesesreien nir arini korti lat sansan, ko artori gortien ser. Ko arwera Iesu pivini putur re nor. ");
INSERT INTO upv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ko arsusi tevi arwera “Ia, kupwerai ta tevi kem. Nik kuvi Mesaea ko?” Ko Iesu owra lweni tevi nir owra “Poro bowrai tevi kami, ko kami sete kama-osuri inu, ejki. ");
INSERT INTO upv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ko poro nga inu bosusi nanu san tevi kami, ko ngok kami sete kamrongwos kapwera lweni. ");
INSERT INTO upv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ko etipatun le pa ngel, mian ko inu Jinibb Mawos bean b̃esakel ngatan renge Atua nevren rres, nga derteren sen mutoe.” ");
INSERT INTO upv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ko nir jijle arsusi tevi arwera “Ia ko erpese! Nik kuvi Atua natun?” Ko ni owra lweni owra “Kami kamwerai pa ngok. Inu ko.” ");
INSERT INTO upv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ko nir arwera “Ngok! Niko vajin. Ko suri sev ko nga muloli kerr rramok-pejpej malume nale sopor nga parwilwil tere ni ren?” ");
INSERT INTO upv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ko nir nga marlik renge gortien nen nir jijle artur imare ko artekai Iesu van renge no Paelet nga ni puwra suri lat nga puto suri renge Iesu. ");
INSERT INTO upv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ko arini ji Paelet vajin ko artipatun arwera nanu ngel nir: “Kem namlesi m̃erel ololi jinibb se kem nir arlengleng. Ololi artere numal se kem, ko okwer ore kem, owra sete nabwuli takis tevi Sisa, batu numal se kami m̃eri Rom. Ko ok-wera ni evi Mesaea Numal.” ");
INSERT INTO upv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ko Paelet osusi tevi Iesu owra “Nik kuvi numal se m̃eri Isrel nir?” Ko ni owra lweni tevi, owra “Nik ko kumwerai ngok.” ");
INSERT INTO upv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ko Paelet owra lweni tevi batu jinibb ne sulsulen nir ko jinibb jijle nir, “Nulesi m̃erel sete otor otvi nale ne nesesreien san, ejki.” ");
INSERT INTO upv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ko nir arij eterter arwera “Ejki, ni ololi jinibb arlik esij, evel p̃etp̃eti renge Jutia. Ko etipatun renge Galili ko evini ejpari iel nga mok-visviseni jinibb nir.” ");
INSERT INTO upv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ko daron nga Paelet murnge nale ngel, ko osusi owra “Ia, ko m̃erel evi m̃eri Galili le?” ");
INSERT INTO upv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ko daron nga Paelet murnge marwera lilane nga Iesu mivel renge Galili e vini, ko okoni tweni van ji Erot e. Suri Galili evi vanu nga Erot mok-metmete, ko re daron nen Erot elik pa renge Jerusalem. ");
INSERT INTO upv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ko daron nga Erot m̃ilesi Iesu ko eir nga eir lenglenge. Suri nga ni ok-tiriv pa bonevis ko, emrreni p̃ilesi. Suri nga ni ok-runge nosp̃en nen, ko orrorrmi nga renge nabong san ko p̃ilesi Iesu puloli nanu nga m̃inijnij nawone san. ");
INSERT INTO upv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ko Erot osusi rongornge nale elep tevi Iesu. Ko Iesu sete owra lweni rragrrag nale san tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ko batu jinibb ne sulsulen nir ko jinibb nevisvisenien ne nale nesesreien nir artur ko arwer memsi Iesu. ");
INSERT INTO upv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ko mian ko Erot ko jinibb nuval sen nir arongrong melas bbonge ni ko arsij tevi. Ko Erot owra parloli puri sunsun san nga nulsen m̃irres ko parpitevi lweni van ji Paelet. ");
INSERT INTO upv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ko Erot bonevis evi devje nuval sen e Paelet, ko Paelet bonevis evi devje nuval sen e Erot. Ko lelingen ngel vajin orloli sel. ");
INSERT INTO upv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ko Paelet everus kortoni batun ne jinibb ne sulsulen nir ko numal se m̃eri Isrel nir, ko jinibb jile nir arini arkorti lat sansan. ");
INSERT INTO upv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ko owrai tevir owra “M̃er nga kami kamtekai vini jik ngel nga kami kamwera ni ololi jinibb nir arlengleng temijpal. Ko inu nurnge lilane pa nanu nen nir jin renge no kami, ko sete nulesi nanu nga kami kamwerai ngok san, nga m̃erel esij ren. ");
INSERT INTO upv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ko Erot kele sete elesi nanu san esij rengen, suri mukoni lweni vini ji inu. Ko ngok oto vajin limjer nga m̃erel sete ololi nanu san nga ni pimij suri. ");
INSERT INTO upv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ko inu bololi jinibb suk parvirrvirrali, ko bea-linglingi ni ko vajin pivel sisarow.” ");
INSERT INTO upv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Suri renge daron ne nanen ne Asien renge murrun ser Paelet p̃ilinglingi wor jinibb ser ko san nga m̃ilik renge naim ne nekaien pivel sisarow. ");
INSERT INTO upv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ko nir jile arkail arvesane van mare jer arwera “Kuppitevi tweni m̃erel van, kuprevji pini pimij! Ko kuplinglingi ma Barapas pivel sisarow pirpe kem nammerreni.” ");
INSERT INTO upv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","M̃erel Barapas, m̃eri Rom nir arlingi renge naim ne nekaien suri nga muloli lartul nga marlik ie marpalpal tevi numal nga m̃ilik renge ngaim nen. Ko ni erevji pini kele wor jinibb emij. ");
INSERT INTO upv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ko Paelet emrreni p̃ilinglingi Iesu pivel sisarow, ko erij tevi nir kele. ");
INSERT INTO upv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ko nir arkikail lengleng van mare arwera “Kuprruloni renge nai pelaot!” ");
INSERT INTO upv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ko ni erij luwi kele vatolin tevir, owra “M̃erel ololi sev esij? Inu sete nulesi ololi nanu san esij renge ni pimij suri. Ko inu bololi para-virrvirrali ni, ko b̃elinglingi ni pivel sisarow.” ");
INSERT INTO upv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ko nir sete armosi re markail. Arkail kele eterter lengleng, drrelar evan mare jer arvesane, arwera “Kuprruloni! Kuprruloni renge nai pelaot!” Ko Paelet ornge drrelar, ololi surie erpe drrelar muwrai. ");
INSERT INTO upv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ko emarong Iesu tevir nga nir parloli surie nga nir marmerreni tevi ni pirpe nga nir marwerai. ");
INSERT INTO upv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ko ni elinglingi Barapas, m̃er nga m̃eri Rom nir marlingi renge naim ne nekaien suri nga muloli nir marpalpal tevi numal nga m̃ilik renge vanu nen, ko erevji pini kele wor jinibb. Ko elinglingi ni evel sisarow erpe nga m̃erwomu se m̃eri Isrel nir marmerreni. ");
INSERT INTO upv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ko jinibb nuval sopor arpitevi Iesu evel van nga parruloni re nai pelaot. Ko arlesi jinibb ne Saerin san renge sel, nga nisen Saemon, otutur vini nga pian renge ngaim nga milep. Ko arrul totoni ni ko arjingteni nai pelaot se Iesu renge birparin, ko aron tertere nga ni puwosi pivitu. ");
INSERT INTO upv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ko delung nga milep arvijuri suri Iesu. Ko nesevin sopor arpitevir, ko arting elep armesmasor e nga martengsi erpe ni mimij pa. ");
INSERT INTO upv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ko Iesu erieni lweni ko owrai tevir owra “Kami nesevin ne Jerusalem nir, sete kaptengsi inu te, pijki. Ko kaptengsi lweni ma kami, ko natu kami nir. ");
INSERT INTO upv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nabong nen nir para-vini nga jinibb nir para-wera ‘Neiren renge kami nesevin nga kamm̃er ko kami nesevin nga setewor kamvasus ko kami nesevin nga setewor kamloli bipi musus wor nabong san. Kami ngok ko kaprunge p̃irres.’ ");
INSERT INTO upv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ko renge nabong nen nir para-rongwos parwerai tevi botwen nga marlelep nir, ‘Kapmatop ko kapvitan renge kem!’, ko arongwos parwerai tevi botwen nga marwowarreng nir, ‘Kapini kaptevni ore kem!’ ");
INSERT INTO upv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kaplesi! Ara-tipatun lebbong ngel, ko arloli erpok. Pian ko para-loli p̃isij p̃erp̃er wor p̃iasi ngel.” ");
INSERT INTO upv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ko nir arpitevi kele nuru eru. Laru nen nuru korti orivi jinibb nga morsij, ko niko marlingi nuru pormij tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ko nir arini renge lat san nga marwera Golkota e, nga muwra mirpel, Lat ne bongur. Ko renge ie nir arwuse Iesu nevren nuru ko b̃elan nuru renge nai pelaot. Ko arwuse kele jinibb nga morsij nga nevre nuru ko b̃ela nuru renge nai pelaot eru, nuru tuwen renge Iesu nevren rres, ko nuru tuwen renge nevren mair. ");
INSERT INTO upv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ko Iesu owra “Tata, kuptelasi tweni nololien ser, suri sete arongwose rragrrage nanu nga marloli.” Ko nir artututweni sunsun sen tevir nga partuwe daes suri. ");
INSERT INTO upv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ko jinibb nir artur mori bbong. Ko arok-kulu arok-meteni daron nga m̃erwomu se m̃eri Isrel nir marok-men kerkerasi Iesu, arwera “Ni ela pa se jinibb elep osuw; ko rraplesi vajin ni p̃ila se ni luwi vajin ta we, poro pivi Mesaea nga Atua mutobbtobbue.” ");
INSERT INTO upv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ko jinibb nuval kele nir armen kerkerasi. Ko arini mori jin ko arla lesi norro nga mimilali pa tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ko arwera “Poro nik kupivi numal se m̃eri Isrel nir, ko kupla se nik luwi!” ");
INSERT INTO upv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nale ngel le nir nga marulir mare renge nai pelaot: M̃EREL EVI NUMAL SE M̃ERI ISREL NIR. ");
INSERT INTO upv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ko laru nga mormij tevi Iesu, nuru tuwen erij esij tevi, owra “E, poro nik kupivi Mesaea, ko kupla se nik ko komru!” ");
INSERT INTO upv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ko nuru tuwen erij tevi suri, owra “Nik sete kumtutue Atua rrek! Kuplesi nik ko inu, kerru rromorsere lweni wor nanu nga rromorloli ko, ");
INSERT INTO upv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ko niko renge kerru, erres ko wor. Suri kerru ma, rromorla mawos wore ko nanu nga moro rroporlai renge sev nga rromorlolir. Ko m̃erel ma sete ololi nanu san esij rragrrag te.” ");
INSERT INTO upv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mian ko ni owrai tevi Iesu owra “Iesu, poro nabong nga kupa-ivi Numal, ko warru kuprrorrmi inu.” ");
INSERT INTO upv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ko Iesu owra lweni tevi owra “Nuwretun nuwrai tevi nik, lelingen kobbong kuplik tevik renge lat nga m̃irres asi jer, nga mivi drromdrromon jer.” ");
INSERT INTO upv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ko omomsawos renge mete nial esngavöl drromon eru ko nial setemun esin. Lat emalik p̃etp̃eti renge lat jijle evini ejpari mete nial itul nat mirivriv vajin. ");
INSERT INTO upv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ko kalek nga murrul ore lat nga muon nga muon temijpal renge Naim On se Atua loloim eteri wukari devjen eru e. ");
INSERT INTO upv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ko Iesu everus temijpal van mare owra “Tata, nulngi nem̃ik renge nevrem!” Daron nga muwrai jile nale ngel e ko osrow pini. ");
INSERT INTO upv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ko daron nga batu jinibb nuval se m̃eri Rom nir m̃ilesi nanu nga miplari, ko osrövi Atua suri. Ko owra “Ewretun le m̃erel evi jinibb nga mimawos m̃irres!” ");
INSERT INTO upv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ko jinibb jijle nga marini ie nga parmeteni, daron nga marlesi nanu ngel nir ko arieni lwenir van renge ngaim ser e, arunge esij lengleng, arwujwuje morkor suri. ");
INSERT INTO upv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ko Iesu selen wor nir ko nesevin nga marvijuri Iesu renge Galili vini, nir ngok artur wor van ngasngasu sopon, ko armeteni nanu nga marpelari nir. ");
INSERT INTO upv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ko m̃eri Armetia san elik ie, nisen Josep. Armetia evi ngaim ne Isrel san. Ko m̃erel Josep evi nir san renge gortien se nir nga marwowomu re Isrel nir. Ni evi jinibb nga mimawos m̃irres, ko evi jinibb nga mok-teravi batun vanu se Atua pivini. Ko sete emarong renge nanu nga gortien ser ngok muloli tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ko m̃erel ko emawose no Paelet evan jin, sete emtutu te, ko ongoni nibe Iesu tevi. Ko Paelet emarong. ");
INSERT INTO upv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ko Josep evan ojri tweni nibe Iesu renge nai pelaot, ko ela kalek nga mimalum m̃irres san, ko onb̃e ore e. Ko owosi van elngi renge nevöt san nga marsavi nolon mutoe nga setewor arlingi jinibb san rengen nabong san. ");
INSERT INTO upv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ko evi Praete, nabong nga marok-eseser e marok-la kortoni ngarre nanu nir. Ko otomori pa nial piwaj pini ko Sapat pivini. ");
INSERT INTO upv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ko nesevin nga marvijuri Iesu renge Galili vini, nir arpitevi Josep, aran ko arlesi dubb nen, ko armeteni suri lat nga marlingi nibe Iesu muto suri. ");
INSERT INTO upv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mian ko nesevin ngel nir arluwi van renge naim e, ko arla roi nga mapur m̃irres ko pomat, arloli kortoni ngarre nir, mian ko para-lair van parsesei renge nibe Iesu. Ko nir armosi erpe nesesreien ne Sapat muwrai. ");
INSERT INTO upv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Renge Sante rorpong susu malum, ko nesevin nen nir artori ro nai nga mapur m̃irres, ko armermera tevi van renge dubb nga parsesei renge nibe Iesu. ");
INSERT INTO upv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ko daron nga marini renge dubb, ko arlesi nevöt nga muto ore dubb martini tweni pa rengen mijkie. ");
INSERT INTO upv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ko arjiol van ngatan ko arsil van renge lolo dubb, ko sete arlesi nibe Numal Iesu. ");
INSERT INTO upv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ko nir artur lengleng vajin, arrelenge lat nga nanu ngel muto suri. Ko ngavilvilsen jinibb eru orpelari jir ortur tevir. Sunsun se nuru orow raprap titis. ");
INSERT INTO upv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ko nir armetutu temijpal, ko arjiol vitan nor emawose dan. Ko laru nen nuru orwerai tevir orwera “Erpese kami kampej m̃er nga mimaur renge nir nga marmij pa? ");
INSERT INTO upv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ni ejki iel, ni emaur luwi pa. Kami kamrongwose renge daron nga m̃ilik renge Galili wosenen ni owra sev nale tevi kami? ");
INSERT INTO upv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ko ni owra ‘Partekai inu Jinibb Mawos van renge nevre jinibb nga marsij nir, ko nir parwuse inu renge nai pelaot ko parrulonik; ko nabong p̃itolin ko bemaur luwi kele.’” ");
INSERT INTO upv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ko nesevin nen nir arrorrmi sweri lweni nale nga muwrair nen nir. ");
INSERT INTO upv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ko nir arivel lingi dubb ko arluwi van ji jinibb se Iesu nir esngavöl drromon san e (11); ko arsup̃e nanu p̃etp̃eti tevir. ");
INSERT INTO upv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nesevin nen le ngel nir: Merri ne Maktla ko Joana ko Merri nga tasu se Jemes, ko nesevin m̃inij nen kele wor sopor nga marpitevir. ");
INSERT INTO upv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ko aposol nir arunge nale ser erpe nale gerisen bbong, ko sete arosuri. ");
INSERT INTO upv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ko Pita emra ko owlu van renge dubb e. Ko ejiol van ngatan, ko emteni ko elesi sunsun nga bbong marnub̃e e m̃isan muto, ko setemun elesi kele nanu san. Ko evel olwi van renge naim sen e. Bbösa nga milep elaie suri nanu nga miplari ngok. ");
INSERT INTO upv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Renge nabong nen mawos ko pa, jinibb se Iesu eru orivel suri sel nga poran renge ngaim e san nga nisen Emeas. Ko oto wor ngasngasue Jerusalem sopon erpe evi kilomita esngavöl drromon san wor. ");
INSERT INTO upv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ko daron nga morok-ivel suri sele morok-supsup̃e suri nanu nga marpelari nir tevi nuru lululweni wore, ");
INSERT INTO upv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ko Iesu evel vini mori ji nuru. Ko nuru orok-sup̃e malume, ko Iesu evini pa ji nuru, arivel kokorti vajin. ");
INSERT INTO upv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ko daron nga nuru morlesi ni ko orrelenge ni, sete orongwose, suri Atua opongi ore mete nuru. ");
INSERT INTO upv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ko Iesu osusi tevi nuru owra “Sev ko komorok-supsup̃e renge sel nga komorivel ngok?” Ko nuru ortur murrarrong, no nuru evirrvirrting. ");
INSERT INTO upv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ko nuru tuwen nen nga nisen Kleopas osusi tevi, “Rreknga nik kusan kuvi jinibb nga kumlik renge Jerusalem ko sete kurongwose nanu nga miplari renge nabong evis lebbong nga marasi!” ");
INSERT INTO upv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ko Iesu osusi tevi nuru owra “Isev ko nir?” Ko nuru orwera lweni tevi orwera “Nanu nga marpelari renge Iesu ne Donasret. Ni evi propet san, ko renge no Atua ko renge no jinibb nir, ni evi jinibb nga milep san renge majingen sen ko renge nale sen nir. ");
INSERT INTO upv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ko batun ne jinibb ne sulsulen nir ko m̃erwomu se kerr nir arpitevi ni van ji m̃eri Rom nir, nga nir parwera ni pimij ko wor. Ko nir arruloni ni renge nai pelaot. ");
INSERT INTO upv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ko kem namlingi nolo kem renge ni eterter nga ni orongwos puloli kerr m̃eri Isrel nir rrapiel sisarow vajin. Ko mare nen renge nanu ngel nir, lelingen evi nabong itolin le pa osuw nga nanu ngel nir marpelari. ");
INSERT INTO upv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ko nesevin sopor renge gortien se kem arloli bbösa nga milep elai kem, renge daron nga marmermera rorpong susu van renge dubb nga jinibb marlingi ni niben rengen. ");
INSERT INTO upv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ko sete marlesi nibe Iesu, ko arlulwi vini arwerai nga nir arlesi anglo eru orwerai tevi nir nga ni emaur luwi pa. ");
INSERT INTO upv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ko sopor renge gortien se kem aran renge dubb ko arlesi nanu jile arirpe nga nesevin nir marwerai. Ko sete arlesi ni.” ");
INSERT INTO upv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ko Iesu owrai tevi nuru owra “O, kami nga kamlengleng, ko kamlolola lengleng renge kaposuri nale se propet nir nga marwerai! ");
INSERT INTO upv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sete evi nanu nga Atua m̃ilngi pa nga piplari ko wor nga Mesaea purnge p̃isij renge nanu ngel nir, musuw ni pian renge nosrövien sen?” ");
INSERT INTO upv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ko Iesu owra lweni tevi nuru sev nga marwerai suri ni renge Naul On, etipatun renge naul se Moses ko etajer tevi vini ejpari nga propet nir marulir. ");
INSERT INTO upv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mian ko nir aran mori renge ngaim nga nuru morwera poran rengen, ko Iesu ololi erpe ni p̃itajer kele wor. ");
INSERT INTO upv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ko nuru orevei totoni ni ko orwera “Kuplik tevi komru. Suri nat erivriv pa, otomori nial piwaj pini.” Ko ni emarong, ko ean loloim nga p̃ilik tevi nuru. ");
INSERT INTO upv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ko ni esakel renge tep tevi nuru nga paraan. Ko ni ela niv ko olot owra erres tevi Atua suri, ko obbri otvi niv, ko elai tevi nuru. ");
INSERT INTO upv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ko mete nuru em̃erer vajin, ko orlesi wose ni. Ko ni ejijki renge mete nuru, orrerrlenge lat nga mian e, setemun orlesi. ");
INSERT INTO upv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ko nuru kis vajin orwerwera lululweni tevi nuru, orwera “Po! Nile ma wor daron nga rramiel renge sel e ko muwra visviseni Naul On nir tevi kerru, ko nolo kerru eir.” ");
INSERT INTO upv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ko renge daron nen mawos ko pa, ortur imare ko orluwi van renge Jerusalem e, orlesi aposol nir esngavöl drromon san ko nir m̃inij nen kele wor sopor. ");
INSERT INTO upv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ko aposol nen nir ko nir nga marpitevir ngok arij womu tevi nuru, arwera “Numal emaur luwi weretunen! Ni eplari ji Saemon.” ");
INSERT INTO upv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ko nuru vajin orsup̃e suri nanu nga marpelari renge sel tevi nir, ko erpese renge daron nga ni mubbri otvi niv, ko nuru morlesi wose. ");
INSERT INTO upv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ko daron nga morok-sup̃e suri nanu ngel e tevir, ko artaol lenglenge Iesu otur pelari renge liven jir, ko owra “Demat piptevi kami.” ");
INSERT INTO upv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ko nir armetutu lengleng, arrorrmi rreknga ma arlesi nem̃in san. ");
INSERT INTO upv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ko Iesu owrai tevir owra “Kami kammetutu sev ko? Suri sev norrorrmien nga marirpel ngel nir marini renge nolo kami? ");
INSERT INTO upv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kapmeteni nevrek nuru ko b̃elak, ko kapsareni nevre kami, ko kaprunge evi inu mawos le wor. Ko kaplesi, nem̃in sete niben otoe te ejki, ko jin sete otoe te ejki, erpe nga kami kamlesi inu ngel!” ");
INSERT INTO upv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ni owra nanu ngel, ko eviseni nevren nuru ko b̃elan nuru tevi nir armeteni. ");
INSERT INTO upv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ko bbösa elair e ko arir lengleng; ko setewor arosuri erres te, ejki malum wor. Ko ni owrai tevir, “Kamtori nanen sopon ni ko?” ");
INSERT INTO upv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ko nir arla viso nai nga mimasos jile pa san ko arsareni tevi ni. ");
INSERT INTO upv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ko ni esaro ko elai jir ko orroi renge nir jile nor. ");
INSERT INTO upv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ko Iesu owrai tevir owra “Nanu ngel nir arivi nanu mawos nga mowrai pa tevi kami renge daron nga m̃elik malum tevi kami e. Renge bonevis nen nomok-werai pa nga nanu jile nga maruli renge naul se Moses ko renge nale se propet nir ko renge Sam nir nga marsup̃e suri inu parini ko wor parpelari.” ");
INSERT INTO upv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ko ni owni norrorrmien ser arkulu nga parongwose nale ne Naul On nir p̃irres. ");
INSERT INTO upv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ko owrai tevi nir owra “Ngel evi sev nga maruli, nga Mesaea purnge ko wor p̃isij, mian ko pia-maur luwi kele renge nabong itolin. ");
INSERT INTO upv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ko parwerwer renge vanu jijle nir nga jinibb nir nolor parlululwi ko wor, ko Atua p̃itlasi tweni nololien ser vajin renge nise Mesaea. Ko womujnen p̃itipatun womu renge Jerusalem. ");
INSERT INTO upv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kami ko kamivi jinibb nga kapwera tweni nanu ngel nir. ");
INSERT INTO upv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ko inu bokoni m̃er nga Tata suk m̃irijrij pae tevi kami nga pia-lai tevi kami. Ko kami kaptiriv wore ko renge ngaim pian pijpari daron nga derteren se Atua pivel renge melrin vini iel ngatan nga puloli kami kapterter.” ");
INSERT INTO upv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ko Iesu eptei twenir arivel lingi ngaim nen. Ko arivel van arjipari Betani. Ko renge ie ni esareni nevren nuru van mare mawos nir, ko erij erres suri nir. ");
INSERT INTO upv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ko daron nga mok-rij m̃irres surir ko Atua etkai tweni ni van mare e renge melrin. ");
INSERT INTO upv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ko nir arlotoe ni, ko mian ko arlulwi van renge Jerusalem e tevi neiren nga milep renge nir nolor. ");
INSERT INTO upv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ko nir aran renge Naim On ko arlotoe Atua, arwera erres tevi. ");
INSERT INTO upv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tuwi nga tuwi jer Nale elik ko pa osuw. Nale ngok eptevi Atua. Nale ngok kele evi Atua. ");
INSERT INTO upv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Womu jer mian ko ngatan ngel pia-tipatun, ni elik ko pa osuw tevi Atua. ");
INSERT INTO upv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nanu jijle nga Atua mulolir Nale eptevi ni ren, nuru korti orlolir, sete Nale ejkie nanu san nga Atua muloli. ");
INSERT INTO upv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mauren oto renge ni, ko mauren ngok elai moron tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Moron ngok omor re nemalik, ko nemalik sete evter rragrrage nga pimalik tevtevni. ");
INSERT INTO upv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Atua okoni jinibb san vini, m̃ernen nisen Jon. ");
INSERT INTO upv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ni evini nga p̃irij se Moron ngok ko, owra lilane tevi jinibb nir, nga puloli jinibb nir parosuri. ");
INSERT INTO upv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ni sete evi Moron nen te, ni evini nga bbong p̃irij se Moron nen ko. ");
INSERT INTO upv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nale ngok evi Moron weretunen, evini iel ngatan, omor vaseni jinibb jijle nir. ");
INSERT INTO upv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ni elik iel ngatan, ko ni ololi ngatan ngel, ko jinibb ne ngatan ngel nir sete arlesi wose ni te. ");
INSERT INTO upv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ni evini ji metka sen mawos nir, ko metka sen mawos nir sete artekai ni. ");
INSERT INTO upv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ko nir elep ma nga marosuri ni, ko martekai ni vini jir. Nir ngel ko ma, ni elai derteren tevir arini arivi Atua natun. ");
INSERT INTO upv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nir arivi Atua natun, sete erpe nga jinibb m̃iak renge drra, rreknga marongen se niben, rreknga marongen se jinibb, ejki. Nir arivi Atua natun suri Atua ko wor marongen sen. ");
INSERT INTO upv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nale ololi lweni ni evi jinibb, eplari limjer ko elik tevi kerr. Ko kem namlesi wose renge nosrövien sen nga ni esan evi Atua natun mawos, owun saute nalol nga m̃irres nga sete orongwos p̃irieni. ");
INSERT INTO upv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon erij sen, ekail owrai tevi jinibb nir, “M̃erel le nomok-sup̃e suri nga nomok-wera, Inu nuwowomu nga bololi lilane sel sen, nga ni pia-vitu surik. Ko ni elep wor asi inu, suri ni elik wowomu ko pa mian ko inu mea-iak, ko niko ni elep asi wore inu.” ");
INSERT INTO upv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Niko suri nolon owun saute nga mimrreni kerr, ko ololi ni mok-la nanu nir tevi kerr. Ko erpok malum, ok-lila malum wore nanu ko nir tevi kerr. ");
INSERT INTO upv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nale nesesreien eplari re Moses, ko nalol nga ma m̃irres nga sete orongwos p̃irieni eplari renge Iesu Kristo. ");
INSERT INTO upv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sete jinibb san elesi Atua renge daron san, ejki. Natun mawos kobbong, nga nuru Atua morsorsan mawos, nga morkorti m̃irres morirpe m̃elew, ni kobbong evel renge melrin vini, ko owra visviseni Tata sen tevi kerr. ");
INSERT INTO upv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nir nga marwowomue m̃eri Isrel nir nga marlik Jerusalem arkoni jinibb ne sulsulen sopor ko Livaet sopor vini ji Jon nga parsusi tevi, “Nik kuvi isi le?” ");
INSERT INTO upv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ko Jon sete evilvil orore ni, ejki, ewer limjere ni tevir, owra “Inu sete nuvi Mesaea te.” ");
INSERT INTO upv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ko ngok arsusi kele tevi ni, “Ia, ko nik kuvi isi, Elaeja?” Ko Jon owra “Ejki, inu ejki.” Ko arwera “Ia, ko nik kuvi ma Propet nen?” Ko Jon owra “Ejki.” ");
INSERT INTO upv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ko nir arsusi lweni tevi, “Po! Ko nik ngok kuvi isi le? Kupwerai lweni nik tevi kem, puloli kem naban nabwera lweni tevi nir nga markoni kem vini. Nik kupwowrai lweni nik!” ");
INSERT INTO upv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ko Jon owra “Inu nuvi bbong jinibb san nga propet Aesea musp̃e suri, muwra ‘Drrela jinibb san ekail renge lolo merwer, “Kaploli lilane sel se Numal pimetet.” ’” ");
INSERT INTO upv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lartul ngok nir, Parasi ko nir arkonir van ji Jon. ");
INSERT INTO upv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ko nir arsusi tevi Jon “Poro nga nik ngok sete kuvi Mesaea rreknga Elaeja rreknga propet nen, ko suri sev komok-loli baptaes?” ");
INSERT INTO upv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon owra lweni tevir, “Inu nomok-loli baptaes tevi nuwi lebbong, ko san ma ni ko pa otur livö renge kami, kami sete kamrongwose. ");
INSERT INTO upv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngok ni ko ma evi m̃ernen mawos nga propet nga tuwi nir arwera pivitu suri inu. Ko ni elep asi jer wore inu, ko inu sete numomsawos nurres rragrrag kele re bbong b̃ejiol vitan b̃etlasi tweni dil renge but sen.” ");
INSERT INTO upv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nanu ngel nir arpelari renge Betani, ie oto roroni Jortan, lat nga Jon mok-loli baptaes ren. ");
INSERT INTO upv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Renge nabong m̃inij nen san kele, Jon emteni Iesu mivel mawose vini. Ko owra “Kaplesi, natu sipsip se Atua nga p̃ila tweni nololien ne iel ngatan! ");
INSERT INTO upv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ngok! Niko m̃er nga nomok-sup̃e suri nga ko, mowra ‘Inu nuwowomu le, nuloli lilane sel sen nga pivivitu surik.’ Ko ni elep wor asi inu, suri ni elik ko pa, mian ko inu ngel mea-iak. ");
INSERT INTO upv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Inu kele sete nurongwose m̃erel bonevis, ko erpok nuvini tweni nupaptaes tevi nuwi nga inu beviseni ni tevi m̃eri Isrel nir.” ");
INSERT INTO upv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ko Jon erij se ni owra “Nulesi Nem̃in ojubbul renge melrin vini erpe wum̃er ko esakel jer re ni. ");
INSERT INTO upv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Inu kele sete nurongwose m̃erel, ko ni nga mukoni inu mepaptaes tevi nuwi owrai tevik, ‘M̃er nga kuplesi Nem̃in pujubbul pian pisilvi p̃ilik jer ren, m̃ernen ko evi ni nga pipaptaes jinibb nir tevi Nem̃in On.’ ");
INSERT INTO upv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngok niko inu m̃elesi ko nurij sen nga ni ngel ko evi Atua natun mawos.” ");
INSERT INTO upv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Renge nabong m̃inij nen san, Jon otur tevi jinibb sen eru. ");
INSERT INTO upv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ko Jon emteni Iesu mivel, ko owrai tevi jinibb sen nuru, “Koporlesi, Natu sipsip se Atua ngel.” ");
INSERT INTO upv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Daron nga jinibb sen nuru morunge nga muwrai mirpok tevi nuru, ko orlingi tweni Jon otur jer ko orvijuri suri Iesu. ");
INSERT INTO upv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu erieni emteni nga morvijuri, ko owrai tevi nuru, “Komorpej isev?” Ko nuru orwerai tevi ni “Rabae (nais ngok renge nale se m̃eri Isrel nir owra jinibb nevisvisenien ko), nibeni lat nga kumlik e?” ");
INSERT INTO upv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesu owrai lweni tevi nuru, “Koporini koporlesi.” Ko nuru orvijuri, oran orlesi lat nga m̃ilik e. Ko orlik tevi ni ie, suri nat erivriv pa, erpe pirpe mete nial ivij. ");
INSERT INTO upv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Renge nuru nga eru ngok nga morunge Jon muwra visviseni Iesu tevi nuru ko morvijuri ngok, nuru tuwen nisen ko Antru, Saemon Pita tasin. ");
INSERT INTO upv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Antru evel evan ko eska wowomue Saemon, ni tuwan, ko owrai tevi ni owra “Komru ma nomorlesi Mesaea” (nais ngok renge nale se m̃eri Gris nir, arwera Kristo, ko owra puwra ‘Jinibb nga Atua m̃irijrij pa nga pukoni nga p̃ila mauren tevi jinibb nir’). ");
INSERT INTO upv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ko ngok Antru eptevi Saemon van ji Iesu. Ko daron nga Iesu m̃ilesi, ko owrai tevi, “Nik Saemon, kuvi natu Jon. Nik parverus kele nisem Kepas.” Nais ngok renge nale se m̃eri Isrel nir owra b̃ereng ko. Ko nais ngok Pita renge nale se m̃eri Gris nir, owra b̃ereng kele kobbong. ");
INSERT INTO upv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Renge nabong m̃inij kele san, Iesu owra pian kele Galili e. Ko elesi Pilip ko owrai tevi, “Kupini kupvijurik, kupivi jinibb suk.” ");
INSERT INTO upv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Antru ko Pita, ngaim se nuru ko Betsaeta, ko Pilip kele evi m̃eri iok. ");
INSERT INTO upv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip evel ko elesi Nataniel, ko owrai tevi, “Kem ma namlesi m̃er nga Moses muli suri renge Naul ne nale nesesreien tuwi, ko propet nir kele maruli suri. Nisen ko Iesu ne donasret, Josep natun.” ");
INSERT INTO upv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel owrai tevi “O, aro, ejki ma, nik kurrorrmi renge iok Nasret nanu nga m̃irres san orongwos piplari ren e?” Pilip owra lweni tevi, ‘Iow, ko kupini kuplesi ta we.” ");
INSERT INTO upv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Daron nga Iesu m̃ilesi Nataniel mivel mawose vini, ko owra “Kaplesi morok, evi m̃eri Isrel tera san nga sete orongwos p̃ikrekris.” ");
INSERT INTO upv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel owra lweni tevi, “Nik kurongwose inu erpese le?” Iesu owra lweni tevi, “Nurongwos wowomu nik ko pa osuw daron nga komok-tur re melve nai pik e, vitunen ko vajin Pilip mia-verus nik.” ");
INSERT INTO upv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ngok Nataniel owrai lweni tevi, “O, jinibb nevisvisenien, nik kuvi Atua natun mawos, kuvi Numal se m̃eri Isrel nir!” ");
INSERT INTO upv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu owra lweni tevi, “Niko suri nga inu mowrai tevim nga nulesim renge melve nai pik, nik kuosuri suri iok wolok kobbong? Ko kurongwos kupa-lesi nanu nga parlelep kele wor parasie ngok.” ");
INSERT INTO upv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ko Iesu owrai kele tevi ni, “Nuwretun nga nuwretun nuwrai tevi kami, vitunen suri ngel kapa-lesi melrin p̃itp̃ir ko anglo se Atua nir partongsa van mare renge melrin ko parjujubbul vini ngatan ji Jinibb Mawos.” ");
INSERT INTO upv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Renge nabong itolin vajin, totkoien san oto renge Galili, renge ngaim nen san nga nisen Kena. Ko renge iok Iesu tasu sen owomu pa, elik tevir iok. ");
INSERT INTO upv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Arla nale kele van ji Iesu ko jinibb sen nir parini kele renge totkoien nen. ");
INSERT INTO upv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mian ko daron nga norro ser musuwsuw renge nanen, ko Iesu tasu sen owrai tevi ni, “Norro ser osuwsuw.” ");
INSERT INTO upv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ko Iesu owra tevi vinnen, “Kuwra bololi sev? Mete nial suk mawos nga inu b̃emajing ren setewor evini.” ");
INSERT INTO upv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mian ko tasu sen owrai tevi jinibb ne majingen ne nanen ne totkoien nir, owra “Kaploli sev tama nga puwrai tevi kami.” ");
INSERT INTO upv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ko botel nga marlelep ouwon nga marlolir e nevöt arto ie nga jinibb parjejavöl e, nga mivijuri murrun tera se m̃eri Isrel nir. Botel nen nir sisamis murrrmurr nga marlelep nga martori nuwi rer ejpari eru rreknga itul. ");
INSERT INTO upv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu owrai tevi jinibb ne majingen ne nanen ne totkoien, “Kaptevtevangi nuwi van renge botel ngok nir parwun.” Ko nir artevtevangi nuwi van renge botel nen nir arwun saut van mare renge jingor. ");
INSERT INTO upv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ko owra lweni kele tevir, “Kaptevangi tweni sopon, kaplai tevi m̃er nga mimetmete nanen ne totkoien.” Ko nir arloli erpok. ");
INSERT INTO upv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Daron nga m̃er nga mimetmete nanen ne totkoien mimni rrongvi nuwi nga m̃irieni pa mivi norro ngok, ko etaole. Ko errerrlenge lat nga mivel e vini (ko jinibb ne majingen ne totkoien ma, nir nga martevangi tweni nuwi, arongwose). Ko everus jinibb nga mutotko, ");
INSERT INTO upv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ko owrai tevi, “Aro, jinibb jijle arok-la wowomue norro nga m̃irres tevi jinibb nir, arok-mini wowomue, mian ko moro marmini jile musuw, ko arrleng suri dilten vajin lat nga muto suri, ko aroka-la nga sete m̃irres armini vivitue. Ko nik ma lelingen kumtipatun kula nga m̃irres, mijpari lelingen ngel ko kua-la nga m̃irres jerjer nen oto ore.” ");
INSERT INTO upv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ngel evi nelesien womujnen nga Iesu muloli renge Kena renge ngaim ne Galili san, nga miviseni nosrövien sen. Ko jinibb sen marosuri ni rengen. ");
INSERT INTO upv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Vitunen renge ngel, ko ni evan ngatan e renge Kapaneam, eptevi tasu sen ko tasin nir ko jinibb sen nir, ko arlik nabong evis ie. ");
INSERT INTO upv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nanen ne asien, daron nga m̃eri Isrel nir marok-rrorrmi lweni daron nga marivel lingi norongen nga m̃isij nga marok-runge Ijip, oruj mori. Ko Iesu otongsa luwi van mare e Jerusalem. ");
INSERT INTO upv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ko elesi nir nga marwulwule buluk ko sipsip ko wum̃er, ko nir nga markelkele nevöt, marsakel renge Naim On loloim. ");
INSERT INTO upv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ko ni ela dil wowarreng sopor, ko evirvirenir arto korti lat sansan, ko oji twenir e renge Naim On, tevi sipsip ser ko buluk ser. Ko evatpus tep ser osutapoe van ngatan, ko nevöt ser nir arwera jrar! arwirr sarrsarr. ");
INSERT INTO upv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ko owrai tevi nir nga marwulwule wum̃er, owra “Kapla tweni nanu ngok nir! Kapiel tevir, sete kaploli naim se Tata suk pivi lat ne wulwulen se kami!” ");
INSERT INTO upv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ngok jinibb sen nir arrorrmi wos nga aruli pa renge Naul On, nga muwrai mirpel, muwra ‘Inu numrreni Naim On som puwokwok tetajer. Norrorrmien suk eterter tetajer iok, erpe nabb nga m̃in re nolok.’ ");
INSERT INTO upv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ko m̃eri Isrel nir nga marlelep renge nir arlesi esij ko arwerai tevi ni, “Nelesien sev nga nik kupviseni tevi kem nga nik kurres renge kuploli pirpel?” ");
INSERT INTO upv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu owra lweni tevir, owra “Kaplokloksi Naim On ngel, ko nabong p̃itul kobbong, ko bosusi raji lweni kele.” ");
INSERT INTO upv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","M̃eri Isrel nen nir arwera lweni tevi ni, “O, laro, Naim On ngel ela sia ngavöl ivij drromon ouwon (46) nga kem nammajinge rer. Ko nik ma kurongwos kupsusi raji lweni nabong p̃itul bbölbböl?” ");
INSERT INTO upv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ko Naim On nga Iesu musp̃e suri ngok evi ni kobbong niben, nga Atua pia-loli pimaur luwi kele re mijen. ");
INSERT INTO upv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Vitunen vajin, daron nga ni mimaur luwi renge mijen, jinibb sen nir arrorrmi sweri nga ni owrai pa nanu ngel tevir bonevis, ko arosuri Naul On ko nale nga Iesu muwrai tevir. ");
INSERT INTO upv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Daron nga Iesu m̃ilik renge Jerusalem renge daron ne nanen ne asien, jinibb elep arosuri ni, suri marlesi nelesien nir nga ni mulolir. ");
INSERT INTO upv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ko Iesu sete osurir, suri orongwose jinibb jijle nir nolor. ");
INSERT INTO upv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ko sete emrreni jinibb san puwra tweni suri jinibb kele san, suri ni orongwos pae sev nga marto renge nolo jinibb jijle nir. ");
INSERT INTO upv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parasi san elik iok, nisen Nikotemas. Evi jinibb san nga milep nga muwowomue m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","M̃ernen mawos evini silveni ji Iesu renge natamupong san. Ko owrai tevi, “Jinibb nevisvisenien, kem namrongwose nik kuvi jinibb nevisvisenien nga kumiel ji Atua vini, suri sete san orongwose puloli nelesien ngel nir nga nik kumlolir ngel, poro nga Atua sete piptevi ni.” ");
INSERT INTO upv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu owra lweni tevi, “Nuwretun nga nuwretun nuwrai tevi nik, poro nga san sete p̃iak luwi kele, ko sete orongwos rragrrage pian renge batun vanu se Atua nga pia-vini.” ");
INSERT INTO upv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikotemas owra lweni tevi Iesu, “Ai, jinibb p̃iak luwi kele pirpese, nga m̃itra pa? Sete orongwos pulwi kele van renge depai tasu sen, ko p̃iak luwi kele!” ");
INSERT INTO upv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu owra lweni tevi, “Nuwretun nga nuwretun nuwrai tevi nik, poro nga jinibb sete p̃iak luwi renge nuwi ko Nem̃in On, ko ni sete orongwose pian rragrrag renge batun vanu se Atua. ");
INSERT INTO upv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Niko, nanu nga m̃iak renge niben evi niben kobbong, ko nanu nga m̃iak renge Nem̃in On evi nem̃in. ");
INSERT INTO upv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sete kuptaole nga inu mowrai tevim mirpok ngok nga nik kup̃iak kele. ");
INSERT INTO upv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nik kurongwos kuprunge ling puwuw renge iok jijle nir vini, ko sete kurongwos lat nga m̃itipatun ren vini ko lat nga pian pusuw ren. Erpok kele renge nir nga mariak renge Nem̃in On.” ");
INSERT INTO upv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikotemas owra lweni tevi Iesu, owra “Ai, nanu ngel putoe pirpok pirpese ko?” ");
INSERT INTO upv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ko Iesu owra lweni kele tevi Nikotemas, “Nik kuvi jinibb ne nevisvisenien se m̃eri Isrel nir, ko suri sev sete kumrongwose nanu ngel? ");
INSERT INTO upv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nuwretun nga nuwretun nuwrai tevi nik, inu nomok-sup̃e suri nanu nga morongwose, ko nomok-rij suri nanu nga nulesi metek e. Ko kami sete kamosuri sev nga nuwrai. ");
INSERT INTO upv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nuwra tweni nanu ne iel ngatan nir tevi kami, ko kami sete kamosuri te. Ko poro bowra vajin nanu ne melrin nir tevi kami, ko kami kaposurir pirpese? ");
INSERT INTO upv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sete jinibb san otongsa van renge melrin nabong san. Inu kobbong sansan, Jinibb Mawos nga mojubbul renge melrin vini. ");
INSERT INTO upv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Erpe Moses tuwi murrloni num̃et nga marmajing rrongrrongvi e bras re nai san ko musi mutur imare renge lolo merwer, ngok pirpok ko renge inu Jinibb Mawos, jinibb nir para-rrulonik. ");
INSERT INTO upv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Renge iok, poro isi tama san pia-osuri inu, m̃ernen pia-lai mauren nga muto tuwi ngok ko wor vini. ");
INSERT INTO upv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Atua emrreni temijpale jinibb ne iel ngatan nir. Ko niko muloli ni mukoni inu, nga m̃esansan mevi ni natun mawos, vini iel ngatan. Ngok poro isi san pia-osuri inu, m̃ernen sete mia-mij, ko pia-la mauren nga muto tuwi ngok vini. ");
INSERT INTO upv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Atua okoni inu Natun mawos vini iel ngatan, sete suri b̃ewer lokloksi jinibb ne iel ngatan nir, ejki, ko b̃ela ma mauren tevir. ");
INSERT INTO upv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ni nga muosuri inu, setemun Atua mia-wer lokloksi. Ko si nga sete muosuri inu, Atua ewer lokloksi ko pa osuw ngok, suri sete muosuri nise inu nga mevi Atua natun mawos. ");
INSERT INTO upv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Atua ololi erpok suri nanu ngel le: moron evini pa iel ngatan osuw, ko jinibb sete armerreni te. Armerreni wor nemalik asie moron, suri nanu nga marok-lolir arsij. ");
INSERT INTO upv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jinibb jijle nga marok-loli nanu nga marsij nir arok-ungasi moron, ko ololi sete armerreni parini renge moron. Armetutue moron, arunge moron tumor vaseni nanu nga marsij nga marok-lolir tarto limjer. ");
INSERT INTO upv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ko si nga ma muloli sev nga mivi weretunen, okini ko wor renge moron, suri nga emrreni puloli parlesi wos nanu nga mok-lolir nga marres, nga muosuri Atua rer.” ");
INSERT INTO upv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Vitunen vajin renge nanu ngel nir, Iesu eptevi jinibb sen nir aran renge Jutia. Ko arlik nabong evis wor iok, ko Iesu ok-paptaese jinibb nir ie. ");
INSERT INTO upv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon kele renge daron nen ok-paptaese jinibb nir renge Aenon mori Salim, suri nuwi elep renge iok. Ko jinibb nir aranan ji Jon ie, ko ok-paptaes nir iok. ");
INSERT INTO upv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Suri renge daron nen setewor arlingi Jon renge naim ne nekaien. ");
INSERT INTO upv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Renge iok Jon jinibb sen sopor ko m̃eri Isrel san arsupsup̃e suri murrun ne lalosen, erpese nga jinibb san orongwos puwokwok renge no Atua. ");
INSERT INTO upv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mian ko arini ji Jon arwerai tevi, “Jinibb nevisvisenien, kuplesi m̃er nga bonevis nga miptevim nga iokwan renge devje nuwi seser van luwi Jortan nga e, nga nik kumrij sen. Ni le ngel mok-paptaes jinibb nir renge nuwi seser. Jinibb p̃etp̃eti arinini jin.” ");
INSERT INTO upv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon owra “Erres kobbong. Sete jinibb san orongwos puloli majingen san poro Atua sete mukoni twenie. ");
INSERT INTO upv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kami bonevis nga, kamrongwose nga inu mowra inu sete nuvi Mesaea. Atua okoni wowomu inu ko ma renge ni, vitunen ko ni pia-vini.” ");
INSERT INTO upv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ko Jon otuw kele nale ngel, owra “Jinibb san nga puwra p̃ilesi nesevin san, ko poro puwra pian mun lat san, ko p̃ilngi selen san nga pimetmete nesen sen sopon pijpari nga pia-luwi. Ko vinnen evi pa sen ko. Ko selen ngok, daron nga murnge drrela m̃ernen mivini, ko eir elep, sete orongwos purnge p̃isij e. Ko erpok ko, inu neiren suk elep temijpal vajin. ");
INSERT INTO upv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ni pian mare jerjer, ko inu bean ngatan jerjer renge ni.” ");
INSERT INTO upv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ni nga mujubbul mare renge melrin vini, ean mare jerjer renge jinibb nir. Ko m̃er nga miplari bbong renge iel ngatan evi pa jinibb ne iel ngatan, ko ok-sup̃e suri bbong nanu ne iel ngatan nir. Ni nga ma mujubbul mare renge melrin vini, ni an mare jerjer ko wor renge jinibb nir. ");
INSERT INTO upv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ni ok-sup̃e sev nga ni murnge ko m̃ilesir re meten. Ko sete ma jinibb san ea-osuri rragrrage nanu nga muwrai ngok nir! ");
INSERT INTO upv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ni nga ma muosuri sev nga inu mowrai eviseni vajin nga Atua nale sen arivi weretunen. ");
INSERT INTO upv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","M̃er nga Atua mukoni, ni ok-sup̃e suri nale se Atua, suri Atua elai Nem̃in On sen tevi ni owun saut rrese. ");
INSERT INTO upv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata emrreni Natun, ko ela nanu jijle tevi, elngir renge nevren. ");
INSERT INTO upv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","M̃er nga muosuri Natun elai pa mauren nga muto tuwi ngok vini. Ko m̃er nga sete muosuri Natun sete mia-la mauren nga muto tuwi ngok vini. M̃ernen lolaren se Atua oto malum ren.");
INSERT INTO upv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Ko mian ko Parasi nir arunge nga Iesu jinibb sen nir milep m̃iasie Jon vajin, ko nga Iesu mipaptaese jinibb milep m̃iasie Jon. (Ko ewretun, Iesu sete epaptaese jinibb nir, ejki, ko jinibb sen kobbong nir arok-paptaese jinibb nir.) ");
INSERT INTO upv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ko daron nga Iesu murongwose nga Parasi nir arunge pa nga ni jinibb sen milep miasie Jon, ko niko muloli ni mivel lingi Jutia, ko mulwi kele van re Galili e. ");
INSERT INTO upv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ko renge nivelen sen, evel otvi sise m̃eri Sameria nir. ");
INSERT INTO upv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ngok, evini renge Sameria ngaim nga welwelili nen san nga nisen Saeka, morie orsel nga Jekop m̃ilai tuwi tevi natun Josep. ");
INSERT INTO upv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Renge ie evi lat nga Jekop m̃ili nuwi sen ren. Ko Iesu ornge lengleng esij renge nivelen sen, ko evini esakel mori jeli nuwi nen. Erpe evi levial mawos, mete nial esngavöl drromon eru. ");
INSERT INTO upv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mian ko nesen Sameria san evini nga pitvangi nuwi ie. Ko Iesu owrai tevi vinnen, “Kupla nuwi ngok sopon tevik bemni.” ");
INSERT INTO upv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Renge daron nen jinibb sen nir arivel pa aran ngaim e parwuli nanen ser sopon.) ");
INSERT INTO upv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nesen Sameria nen etaol ko owrai lweni tevi, “Erpese nga nik kumivi m̃eri Isrel, ko kumngoni nuwi nga kupmini tevi inu, nga mevi nesen Sameria?” (M̃eri Isrel sete arok-korti tevi m̃eri Sameria nir.) ");
INSERT INTO upv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu owra lweni tevi vinnen, “Poro nga nik kuprongwose nelaien se Atua nga m̃ilai, ko isi le nga muwrai tevim nga kupla nuwi tevi pimni, ngok nik kurongwos kupngoni ni p̃ilai nuwi nga nik vajin kupmini. Ko kupmaur tuwi ngok vini rengen.” ");
INSERT INTO upv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Vinnen owra lweni tevi Iesu, “O, ko nanu san ejki iel nga nik kuptevangi nuwi e, ko nuwi ngel evan ngatan lengleng. Ko renge nuwi ne mauren nga tuwi ngok vini nga nik kumwera kuplai ngok, kuplai ngabe ko? ");
INSERT INTO upv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","B̃irtera se kerr Jekop, ni le eli nuwi ngel; ni ko natun nir ko buluk sen nir armini nuwi ngel. Ko ni ko elai tevi kem. Ko erpese, nik kulep asi wore ni?” ");
INSERT INTO upv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu owra lweni tevi, “Isi nga pimni nuwi ngel, pian ko purnge kele kobbong nolon pimesmes. ");
INSERT INTO upv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ko isi nga ma pimni nuwi nga inu bea-lai tevi, ni sete nolon mia-mesmes kele mun. Nuwi nen nga b̃elai tevi nen pia-irpe mete nuwi nga muwowosi renge ni, ko pia-lai mauren nga muto tuwi ngok vini.” ");
INSERT INTO upv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Vinnen owrai tevi ni, “Numal, kuplai nuwi nen tevik bemni, ko puloli nolok sete pimesmes kele, ko sete bevini kele mun betvangi nuwi iel.” ");
INSERT INTO upv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu owra lweni tevi vinnen, “Kupan kupveruse diwen som pivini, ko nik kele kupluwi vini.” ");
INSERT INTO upv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Vinnen owra lweni tevi Iesu, “Ejki ma, diwen suk ejkie.” Ko Iesu owra lweni tevi, “Kuwretun renge kumwerai mirpok, diwen som ejkie. ");
INSERT INTO upv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Suri nik diwen som nga renge sel elim kis, ko m̃er nga nik kumlik jin lelingenok sete evi diwen som. Kuwretun ko wor renge kumwerai mirpok.” ");
INSERT INTO upv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Vinnen owra lweni tevi, “Numal, nurnge nibek nen nga nik kuvi propet san. ");
INSERT INTO upv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","B̃irtera se kem nga tuwi nir arok-lotoe Atua renge botwen nga ngel, ko kami m̃eri Isrel nir kamok-wera renge Jerusalem ko wor evi lat nga jinibb parlotoe Atua rengen.” ");
INSERT INTO upv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu owrai tevi vinnen, “Vinel, kuposuri inu, mete nial nen evini nga kami setemun kaplotoe Tata renge botwen nga ngel, rreknga renge Jerusalem. ");
INSERT INTO upv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kami m̃eri Sameria nir sete kamrongwose Atua nga kamlotoe, ko kem m̃eri Isrel namlotoe Atua nga namrongwose. Suri sel nga jinibb p̃ila mauren eplari ji m̃eri Isrel nir kobbong. ");
INSERT INTO upv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mete nial nen evini ko eplari lelingen ngel, nga jinibb nga marweretun marlot, parlotoe Tata tevi nem̃in ko weretunen. Tata epej loten nga mirpok ko, nga parlotoe ni rengen. ");
INSERT INTO upv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Atua evi Nem̃in, ko jinibb nga marlotoe ni parlotoe ni ko wor tevi Nem̃in ko weretunen.” ");
INSERT INTO upv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nesevin owra tevi ni, “Nurongwose nga Mesaea, nga pia-la mauren tevi jinibb nir, pia-vini ko wor ko pia-wera visviseni nanu jijle tevi kerr.” ");
INSERT INTO upv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iesu owra lweni tevi vinnen, “Inu nen le pa ngel nga m̃erij tevim ngel, inu nuvi m̃ernen.” ");
INSERT INTO upv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Renge daron nen mawos Iesu jinibb sen arlulwi vini. Ko artaole nga marlesi Iesu mok-rij tevi nesevin san. Ko sete nir san osusi tevi vinnen, “Kupej sev le?”, rreknga puwrai tevi Iesu, “Erpese kumrij tevi nesevin ngok?” ");
INSERT INTO upv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ko nesevin nga elngi tweni botel sen esiri jer, ko owlu suri sel olwi van ngaim nga milep ser e, ko owrai tevi delung ne ie nir, ");
INSERT INTO upv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Lartul, kapini kaplesi ta jinibb san ni le, m̃ernen owra jijle nanu nga nomok-lolir nir. Rreknga m̃ernen evi Kristo le?” ");
INSERT INTO upv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ngok jinibb nga renge ngaim nen nir arivel tweni aran jin arlesi. ");
INSERT INTO upv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Renge daron nen jinibb sen nir arveruse ni, arwera “Numal, kupini mun kup̃aan sopon.” ");
INSERT INTO upv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ko ni owrai tevir, “Nanen suk nga borroi oto wore nga kami sete kamrongwose.” ");
INSERT INTO upv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Suri muwrai mirpok ngok, ko jinibb sen nir arwerwera lululweni nir e, “Rrekma jinibb san ela nanen tevi ni nga purroi?” ");
INSERT INTO upv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ko Iesu owra lweni tevir, “Kami sete kamrongwose nanen suk. Nanen suk evi nga b̃emajing jile marongen se Atua nga mukoni inu vini, bololi jijler. ");
INSERT INTO upv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kami kamok-wera, ‘Navöl ivij ojpon malum mian ko daron ne numös pia-vini.’ Ko kaplesi, inu nuwrai tevi kami, kapkulu ta imare kapmeteni naut ne orsel nir. Arkur arow jile, arviter partawer. ");
INSERT INTO upv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","M̃er nga mok-tawe wenen ne numös ok-la nowlin. Ko ok-ser kortoni wenen nir, ngok erpe jinibb nir nga paran renge mauren ne tuwi ngok vini. Puloli nuru korti, m̃er nga mok-jijreni ko m̃er nga mok-tawe, porir kokorti. ");
INSERT INTO upv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Naul On owra, ‘San purwi naut ne orsel, ko jinibb m̃inij pia-tawe wenen ren vajin.’ ");
INSERT INTO upv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Inu nukoni kami kaman renge naut ne orsel nga kami sete kamruwir, ko kamok-tawe wenen rer vajin. Jinibb m̃inij nir arp̃elak nga maruwi naut nen nir, ko kami vajin kama-van kamtawe nawone wenen rer.” ");
INSERT INTO upv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jinibb ne ngaim nen elep arosuri Iesu vajin, suri renge nale se nesevin nga muwrai tevir ngel, ‘Owra nanu jijle nga nomok-lolir’. ");
INSERT INTO upv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Daron nen nga m̃eri Sameria marini jin nen, arngoni tertere ni nga ni p̃ilik mun tevir. Ko ni elik mun tevir ie nabong eru kele. ");
INSERT INTO upv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ko renge m̃ilik tevir ie, nir elep kele wor arosuri ni renge marunge nale sen nir. ");
INSERT INTO upv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ko lartul nen nir arwerai tevi nesevin nen, arwera “Lelingen ngel kem namosuri, sete suri nga nik kumwerai tevi kem, ko suri kem wor namrunge nale sen nir nga muwrair. Ko namrongwose ni evi m̃er weretunen nga pia-lai mauren tevi jinibb ne iel ngatan nir.” ");
INSERT INTO upv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iesu elik ie Sameria ejpari nabong eru asi osuw, ko evel kele van sisen e Galili. ");
INSERT INTO upv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ko ni owra tweni wowomue pa renge nale sen, “M̃er nga mivi propet, ko jinibb ne sisen nir sete arok-osuri ni.” ");
INSERT INTO upv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ko daron nga mivini mijpari lweni Galili e, jinibb ne ie nir artur terai, suri marlesi nanu nga mulolir renge Jerusalem renge daron ne nanen ne asien; suri nir kele arini renge nanen nen. ");
INSERT INTO upv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mian ko Iesu olwi kele vini Kena e, nga mivi ngaim nga welili ne Galili san, lat nga bonevis m̃irieni nuwi rres mivi norro e. Ko jinibb nga milep san elik iok. M̃ernen natun emsi, ko ematur jer wor Kapaneam. ");
INSERT INTO upv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","M̃ernen daron nga murnge Iesu mivel lingi pa Jutia mivini renge Galili e, ko ean jin ko ongoni ni, owra piptevi poran ngatan Kapaneam, puloli natun p̃irres luwi. Suri otomori pa pimij. ");
INSERT INTO upv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu owrai tevi m̃ernen, “Aro! Poro nga sete kaplesi nelesien nir, sete kama-osuri rragrrage te.” ");
INSERT INTO upv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jinibb nga milep nen owra “Numal, wurru, kupini wor pingavil puwomu, vitunen ko poro natuk pia-mij vajin!” ");
INSERT INTO upv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ko Iesu owra lweni tevi, owra “Kupiel. Natum emaur pa.” Ko m̃ernen osuri nale nga Iesu muwrai, ko evel osri lweni sel olwi. ");
INSERT INTO upv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ko daron nga musri lweni sel mulwi van ngatan e Kapaneam, ko jinibb ne majingen sen sopor arivel tersele ko arsewute renge sel, ko arwerai tevi, “Ai, natum erres luwi pa!” ");
INSERT INTO upv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ko ni osusi tevir, owra “Momsawos mete nial sev nga ni m̃itipatun m̃irres luwi ren?” Ko nir arwera lweni tevi, “Momsawos mete nial sansan renge miniv levial, mesien dowalul elinglingi ni.” ");
INSERT INTO upv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tata sen orongwose evi mete nial mawos nga Iesu muwrai ko tevi ni rengen, ‘Natum emaur pa.’ Ko ni osuri, ko nir jijle nga marlik renge naim sen nir kele arosuri. ");
INSERT INTO upv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ngel evi nelesien erwen nga Iesu muloli daron nga mivel lingi Jutia ko mivini Galili e. ");
INSERT INTO upv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Vitunen renge nabong ngel, ko nanen san se m̃eri Isrel nir vajin, ko Iesu otongsa evan Jerusalem e. ");
INSERT INTO upv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ko renge iok Jerusalem, nuwito san oto ren nga mubbun rrerrale. Renge nale se m̃eri Isrel nir, nisen ko Betsaeta. Evi lat ne lalosen, ko oto mori metali san renge naworr nga m̃irrale Jerusalem nga marveruse metali ne sipsip. Lat nen, naim salsal elim artur ren. ");
INSERT INTO upv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ko renge iok renge naim salsal ngok nir, jinibb elep nga elep temijpal armatur rer, nir ngok armesi e mesien lele nir. Nir sopor meter arrorr, nir sopor arivi naroj, nir sopor devje niber armij. Ko arok-tiriv tera nuwi nen p̃iterringrring. ");
INSERT INTO upv_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Suri nabong sopon anglo ok-jubbul vini ngatan ok-siksikeni nuwi nen, ko isi nga puwowomu van renge nuwi ngatan, m̃ernen ko erres renge mesien sev nga ni mimsi ren. ");
INSERT INTO upv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Renge ie jinibb san nga mimsi sia ngavöl itul drromon owil (38). ");
INSERT INTO upv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Daron nga Iesu m̃ilesi mimatur, ko orongwose nga mesien ngok ololi wor tuwi ko. Ko owrai tevi, “Nik kumarong kuprres?” ");
INSERT INTO upv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","M̃er nga owra lweni tevi, “Numal, inu sete jinibb nga p̃uwosik van renge nuwi otoe. Moro daron nga nuwi m̃iterringrringe, ko mowun tweni nga ban, ko jinibb m̃inij san ojubbul womu van ngatan renge nuwi.” ");
INSERT INTO upv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ko Iesu owrai tevi, “Kupmera kupuni milngom ko kupiel!” ");
INSERT INTO upv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Daron nen mawos ko pa, m̃ernen erres luwi. Ko oni milngen ko evel. Renge nabong nen evi nabong on mawos. ");
INSERT INTO upv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","M̃eri Isrel nga marlelep nir arwerai tevi m̃er nga m̃irres luwi nga, “E, lelingen evi nabong on, sete omomsawos renge devjen ne nale nesesreien nga nik kupuni milngom ko kupiel!” ");
INSERT INTO upv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ko ni owra lweni tevi nir, owra “M̃er nga wor muloli inu ko m̃erres luwi owrai tevik, ‘Kupuni milngom ko kupiel.’” ");
INSERT INTO upv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ko nir arsusi lweni kele tevi, arwera “Ia, ko isi ko nenen nga muwrai tevim nen, ‘Kupuni milngom ko kupiel’?” ");
INSERT INTO upv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ko m̃er nga m̃irres luwi sete orongwose isi ko m̃ernen, suri delung elep p̃elak ie. Ko Iesu kele evel tilper ko evel pa van lat m̃inij e. ");
INSERT INTO upv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mian ko vitunen vajin sopon, Iesu otor sweri m̃ernen renge Naim On se Atua. Ko owrai tevi, “Kuplesi, kurres pa ngok. Ko sete kuploli kele mun nololien, suri nanu nga tia-sij temijpal san tia-asi mesien som ngok tia-loli kele nik.” ");
INSERT INTO upv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ko m̃er nga eivare ko evan ji m̃eri Isrel nen nir, ko owrai tevir, “Iesu le nga muloli inu m̃erres luwi nga.” ");
INSERT INTO upv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ngel ko ololi nga m̃eri Isrel nen nir marmerreni para-rrurr otot tevi Iesu, suri ololi nanu ngok re nabong on. ");
INSERT INTO upv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ko Iesu owra lweni tevir, “Tata suk emajing tetajer erpok sete omosi, ko niko inu m̃emajing, sete bomosi.” ");
INSERT INTO upv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Renge muwrai mirpok ngok ko, ololi m̃eri Isrel nen nir arpej kele wor renge ni sel nga parevji pini ni rengen, sete suri kis nga mutor oti nabong on, ko suri kele nga muwra Atua evi ni Tata sen mawos, erpe ololi ni osorsan tevi Atua. ");
INSERT INTO upv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iesu owrai kele tevir, “Nuwretun nga nuwretun nuwrai tevi kami, sev nga m̃elesir Tata suk mok-lolir, ko niko inu nomok-lolir. Inu sete nurongwos bololi nawone nanu pisan, ejki. Sev nga Tata mok-lolir kobbong, ko inu kele nomok-lolir. ");
INSERT INTO upv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Suri Tata emrreni inu, ni natun, ko eviseni nanu jijle nga ni mok-lolir tevi inu. Ko pia-viseni kele wor renge inu majingen nga wor parlelep parasie nga ngel, nga parloli kami kapa-taoler. ");
INSERT INTO upv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Erpe Tata suk muloli jinibb nga marmij nir armaur luwi kele renge mijen, inu kele berpok, ko b̃ela lweni mauren tevi si nga memrreni. ");
INSERT INTO upv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tata suk sete owra suri lat nga puto suri tevi jinibb san, ko elngi majingen ngok oto renge inu nevrek. ");
INSERT INTO upv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Niko puloli jinibb nir parosuri inu, nga mevi ni natun mawos, pirpe nga nir marosuri inu Tata suk. M̃er nga sete muosuri inu te mijki, ni sete osuri Tata suk nga mukoni inu, ejki. ");
INSERT INTO upv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nuwretun nga nuwretun nuwrai tevi kami, m̃er nga murnge nale suk, ko muosuri Tata suk nga mukoni inu, elai pa mauren nga muto tuwi ngok ko vini. Atua setemun orongwos putor vitrangi, ko asi ko pa renge mijen ean renge mauren. ");
INSERT INTO upv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nuwretun nga nuwretun nuwrai tevi kami, lelingen ngel mete nial nen evini nga jinibb nga marmij nir parunge drrela inu nga mevi Atua natun mawos; ko jinibb nga marmurronge inu, nir kele parla mauren. ");
INSERT INTO upv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Erpe Tata suk esansan bbölbböl kobbong evi batu mauren, ko erpok elai tevi inu nga inu kele b̃esansan bbölbböl bevi batu mauren. ");
INSERT INTO upv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tata suk ela derteren tevik nga inu bowra lilane lat nga puto suri renge jinibb nir, suri inu nuvi Jinibb Mawos. ");
INSERT INTO upv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kami sete kaptaole nanu nga mowrai ngel, suri mete nial nen evini nga jinibb nga marmij nir para-runge drrelak ");
INSERT INTO upv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ko para-ivare renge dobbir. Ko nir nga marok-loli nanu nga marres nir bonevis parmaur luwi ko paran renge lat ne mauren. Ko nir nga ma marok-loli nanu nga marsij nir bonevis paran renge lat ne norongen nga m̃isij. ");
INSERT INTO upv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Inu sete nurongwos bowra nawone lat nga puto suri tevi jinibb san renge inu derteren suk, ejki rres nawon. Nanu jijle nga nomok-werai, nurnger ko wor ji Tata suk. Ko nanu nga mowrair arivi weretunen, suri sete nomok-loli marongen suk, ko nomok-loli ma marongen se ni nga mukonik. ");
INSERT INTO upv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Poro inu b̃erij se inu lweni bbong, nale suk ngok sete evi weretunen. ");
INSERT INTO upv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Inu ngel, jinibb m̃inij san erij se inu. Ko inu nurongwose nale sen nga m̃irij se inu ren evi weretunen. ");
INSERT INTO upv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bonevis nga kami kaman ji Jon Baptaes, kami kamsusi rongornge tevi ni, ko ni owra tweni weretunen tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Inu nomok-rij erpok ngok, sete suri nubibto re nale se jinibb san, ejki. Inu nomok-wera nanu ngel nir arirpel nga puloli kami kapasi van re mauren. ");
INSERT INTO upv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon evi nasul san nga mimor, moron m̃irinrin wowomu bonevis; ko kami kam̃ir, kammarong kaplesi nasul sen. Ko ngok oto bbong omrrol. ");
INSERT INTO upv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ko inu nanu kele san nga m̃irij suk otoe. Nenen elep asie wor nga Jon ngok, nenen evi majingen nga Tata suk m̃ilair tevik nga inu b̃emajing rer, bololi jijler. Majingen jijle nga mololir ngok nir arij se inu nga Tata suk okoni inu. ");
INSERT INTO upv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ko Tata suk nga mukoni inu, ni kele erij se inu. Ko sete kami kamrunge drrelan renge nabong san, rreknga kamlesi niben renge nabong san. ");
INSERT INTO upv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nale se ni sete kami kamlair kamtorir renge nolo kami nir, suri sete kamosuri inu, nga ni mukonik. ");
INSERT INTO upv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kami kamok-pejpej sel renge Naul On, ko kamok-wera kami kamok-la mauren nga muto tuwi ngok vini ren. Ko Naul On nen kele erij se inu kobbong, ");
INSERT INTO upv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ko kammusus kapini jik ko puloli kapla mauren. ");
INSERT INTO upv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Sete numrreni jinibb nir parsurövi inu, ejki. ");
INSERT INTO upv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ko inu nurongwose renge kami ngok, sete kamok-la merrenien se Atua kamok-tori renge nolo kami nir. ");
INSERT INTO upv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inu nuvini renge nise Tata suk, ko kami sete kamtekai inu. Ko poro ma jinibb m̃inij san pivini renge ni kobbong nisen, ni ko ma kaptekai. ");
INSERT INTO upv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ngok kami kaposuri pirpese, suri kami kamok-lila lululweni nosrosrövien renge kami kobbong, ko sete kamok-pej nosrövien nga mivel ji Atua nga m̃isan kis mivini. ");
INSERT INTO upv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sete kami kaprrorrmi nga kapwera inu bowowra tweni kami tevi Tata suk, pijki. Moses nga mivi m̃er nga kami kamosuri, ko ni ko pia-wowrai tweni kami. ");
INSERT INTO upv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Poro pivi weretunen nga kami kamosuri Moses, ko ngok kami kaposuri inu ko, suri ni oli suri inu kobbong. ");
INSERT INTO upv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ko suri kami sete kamosuri nale se Moses, ngok kaposuri nale suk nir pirpese?” ");
INSERT INTO upv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Vitunen renge ngel, Iesu evel rujruj kele evan renge devjen ne nuwito ne Galili, nga nisen m̃inij nen marwera nuwito ne Taepirias e. ");
INSERT INTO upv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ko meling jinibb nga milep arvijuri arini jin, suri marlesi nelesien sen nir nga mulolir renge nir nga marmesi. ");
INSERT INTO upv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ko Iesu otongsa van mare renge botwen san, ko elik tevi jinibb sen nir ie. ");
INSERT INTO upv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Renge daron nen, nanen ne asien se m̃eri Isrel nir dabbuen nen oruj mori. ");
INSERT INTO upv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Daron nga Iesu muklu tawij, ko m̃ilesi meling jinibb nga milep marinini jin renge ie. Ko owrai tevi Pilip, “Kerr rrapwuli niv ngabe nga delung jinibb nga marinini ngel parurroir?” ");
INSERT INTO upv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Owrai erpel, owra bbong purrowrrowe Pilip ko ren. Suri ni orongwos pae sev nga ni pia-loli. ");
INSERT INTO upv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip owrai lweni tevi, “Nevöt pivi pungut pivaru (200) kis ngok puwelili kele kobbong, sete pivter malum pivi nowli niv nga parurroi e; nir sisamis parurrurro bbong beblen ko.” ");
INSERT INTO upv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ko san kele renge jinibb sen, nga nisen Antru, Saemon Pita tasin, owrai tevi ni owra ");
INSERT INTO upv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nanwarreng san ni le ielan otori niv wowarreng nga marloli bale e elim, ko nai wowarreng eru. Ko erpese, jinibb ngok nir elep ko wor.” ");
INSERT INTO upv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ko Iesu owra “Kaploli jinibb nir parlik ngatan.” Ko renge ie mösmös elep ren; ko jinibb nen nir arlik ngatan. Ko norman nga marlelep kis kobbong nir totoklai ejpari nuvasngavöl valim (5000). ");
INSERT INTO upv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iesu ela niv nen nir, ko owra erres tevi Atua surir. Ko owjuwje tevi jinibb nir nga marlik iok; ko ololi erpok kele renge nai nga wowarreng nga nuru. Ko nir jijle arla nanen evter nir erpe marmerreni. ");
INSERT INTO upv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ko daron nga maraan jile vajin musuw, ko Iesu owrai tevi jinibb sen nir owra “Kapsere lweni bebje nanen nir nga marurro linglingir marjipon, sete sopon parsij nawon.” ");
INSERT INTO upv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ko nir aran arsere kortoni bebjen nga marurro linglingir renge niv nga elim wowarreng nga, ko arsongnir renge narr esngavöl drromon eru arwun saute. ");
INSERT INTO upv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ko daron nga delung nen nir marlesi nelesien nga muloli, ko arwera “M̃erel evi propet nen weretunen le pa nga marwera pia-vini iel ngatan!” ");
INSERT INTO upv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu ornge renge niben nen, orongwose nga parini paron tertere ni nga pivi numal ser. Ko ni evel esan evan renge botwen e. ");
INSERT INTO upv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Renge daron nga nat mirivriv e vini, ko jinibb sen nir arjubbul van ngatan e renge nuwito. ");
INSERT INTO upv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ko aran arsa renge drrav, ko arwolu otvi nuwito, arluwi kele van Kapaneam e. Ko natopong pa vini, ko Iesu setewor evini jir. ");
INSERT INTO upv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ko ling serser nga milep san etewut vini, ko ololi nuwito obburbbur. ");
INSERT INTO upv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ko jinibb sen arsu erpe ningaw evi nuvasngavöl valim (5000) rreknga vawon (6000) pa osuw, ko arlesi Iesu mivel renge mare ne nuwito vini, evini mori renge drrav. Ko nir aririr lengleng. ");
INSERT INTO upv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ko Iesu owrai tevir, “Inu lebbong, sete kapmetutu!” ");
INSERT INTO upv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ko nir armarong vajin p̃isa parengeni renge drrav. Ko drrav evesan rrese ejpari ngaut lat nga marwera paran ren. ");
INSERT INTO upv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mevinen jinibb delung nga martur jer renge devje nuwito arlesi nga drrav sansan bbong nga mutur renge devje nuwito, ko arongwose nga Iesu sete m̃isa tevi jinibb sen nir mijkie, ko arsan kis bbong arsa ko arwolu. Ko arrorrmi Iesu ni ko malum iok sopon. ");
INSERT INTO upv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Drrav m̃inij sopor ne Taepirias arwolu veut morie lat nga meling jinibb nga milep marurroi niv e nga Numal muwra erres rer womu tevi Atua, ko vitunen ko mara-urroir. ");
INSERT INTO upv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ko mian ko meling jinibb ngok nir marlesi nga Iesu mijki iok, ko jinibb sen kele nir, ko ngok arla kele drrav sopor arwolu kele arini Kapaneam e, arpej Iesu. ");
INSERT INTO upv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Daron nga delung martor sweri ni renge devje nuwito e, ko arwerai tevi, “Jinibb nevisvisenien, kuvini iel e seveling le?” ");
INSERT INTO upv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ko Iesu owra lweni tevir “Nuwretun nga nuwretun nuwrai tevi kami, kampej inu sete suri kamrongwose suri nelesien suk nir, ko suri kamrro niv, ko kamup e mirpe nga kammerreni. ");
INSERT INTO upv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sete kapmajing tweni nanen nga mian ko p̃isij, ko kapmajing tweni nanen nga pia-la mauren nga puto tuwi ngok vini tevi kami, nga inu Jinibb Mawos bea-lai tevi kami. Atua elngi nabil ne derteren nen pa renge inu.” ");
INSERT INTO upv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ko nir arsusi tevi ni, “Kem nabloli sev ko, evi nga nammajing majingen se Atua?” ");
INSERT INTO upv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu owra lweni tevir, “Ngel le evi majingen se Atua, nga kami kaposuri inu, nga ni mukonik.” ");
INSERT INTO upv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ko nir arwerai tevi ni, “Nelesien sev nga nik kupviseni nga kem nablesi, ko nabosuri nik? Kuploli majingen sev? ");
INSERT INTO upv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tata se kerr nir arurroi mana renge lolo merwer, erpe nga maruli renge Naul On, ‘ni ela niv ne melrin tevir arurroi.’” ");
INSERT INTO upv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu owrai tevir, “Nuwretun nga nuwretun nuwrai tevi kami, Moses sete ela niv ne melrin weretunen tevi kami. Tata suk ko ma ok-la niv ne melrin weretunen tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ni nga mivel renge melrin vini iel ngatan evi niv se Atua, ko ok-lai mauren tevi iel ngatan.” ");
INSERT INTO upv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ko nir arwerai tevi ni, “Numal, kopok-la niv nen ko pa tetajer tevi kem.” ");
INSERT INTO upv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ko Iesu owrai tevir, “Inu nuvi niv ne mauren. M̃er nga pivini jik, numer sete orongwos p̃iaji kele; ko m̃er nga muosuri inu, ni sete purnge nolon pimesmes kele mun. ");
INSERT INTO upv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ko nuwrai tevi kami, kami kamlesi mete kami e inu, ko sete kamosuri inu te. ");
INSERT INTO upv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jinibb nga Tata m̃ilair tevik parini jik ko wor; ko m̃er nga mivini jik, setemun numa-oji tweni, ejki. ");
INSERT INTO upv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Suri inu nuvel renge melrin vini iel ngatan, ko sete nuvini tweni nga bololi marongen suk, ko nuvini tweni nga bololi marongen se ni nga mukoni inu. ");
INSERT INTO upv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ngel ko evi marongen se Tata nga mukoni inu, nga jinibb jijle nga m̃ilair tevik, sete botor jabble san pijijki, bea-loli parmaur luwi kele renge nabong nga vitunen. ");
INSERT INTO upv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ko ngel le evi marongen se Tata suk, nga jinibb jijle nga marlesi Natun ko marosuri ni, parla mauren nga muto tuwi ngok vini. Ko inu bea-loli parmaur luwi kele renge nabong nga vitunen.” ");
INSERT INTO upv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ko m̃eri Isrel nga marlelep nir arlolare renge Iesu muwrai mirpok, nga ni evi niv nga mivel renge melrin vini, ko arok-rij latlat malum bbonge suri. ");
INSERT INTO upv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ko arwera “Po, m̃erel evi bbong Iesu le ngel, nga tata sen ko tasu sen rramrongwose nuru. Ni mivi bbong natu Josep! Ko erpese le ni muwra mivel renge melrin vini?” ");
INSERT INTO upv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu owra lweni tevir owra “Sete kaplolar kapok-supsup̃e lululweni malume pirpok renge kami lweni. ");
INSERT INTO upv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sete jinibb san orongwose pivini jik, poro bbong Tata suk nga mukonik ko pirvei ni vini jik. Ko inu bea-loli pimaur luwi kele renge nabong nga vitunen. ");
INSERT INTO upv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Propet nir aruli renge Naul On erpel, ‘Atua pia-visvisenir’, ko jinibb jijle nga murnge Tata ko murongwose nanu vajin, pivini jik ko. ");
INSERT INTO upv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Sete jinibb san elesi Tata renge nabong san. Ni nga bbong mivel ji Atua ko, ni kobbong elesi Tata. ");
INSERT INTO upv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nuwretun nga nuwretun nuwrai tevi kami, m̃er nga muosuri inu ela mauren ne tuwi ngok ko pa vini. ");
INSERT INTO upv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inu nuvi niv ne mauren. ");
INSERT INTO upv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tata se kerr nga tuwi nir arurroi mana renge lolo merwer, mian ko armij. ");
INSERT INTO upv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ko ngel evi niv nga mivel renge melrin vini iel ngatan, nga poro jinibb san purroi, ko sete pimij. ");
INSERT INTO upv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Inu ngel nuvi niv ne mauren nga mevel renge melrin vini. Poro jinibb san purro niv ngel, ni pimaur tuwi ngok vini. Niv nga inu b̃elai pivi mauren ne iel ngatan, evi inu nibek.” ");
INSERT INTO upv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","M̃eri Isrel nen nir arlolar vajin, ko arsususi lululweni tevir, arwera “M̃erel p̃ila niben tevi kerr pirpese nga kerr rraprroi?” ");
INSERT INTO upv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu owrai lweni tevir, “Nuwretun nga nuwretun nuwrai tevi kami, poro nga kami sete kaprroi nibe Jinibb Mawos, ko kami sete kapmini drran, ko ngok mauren sete oto renge kami. ");
INSERT INTO upv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko isi nga murro nibek, ko mimni drrak, ela pa mauren nga muto tuwi ngok ko vini. Ko niko inu bea-loli pimaur luwi kele renge nabong nga vitunen. ");
INSERT INTO upv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Suri nibek evi nanen weretunen, ko drrak evi minminen weretunen. ");
INSERT INTO upv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","M̃er nga murro nibek ko mimni drrak, ni elik renge inu, ko inu nulik renge ni. ");
INSERT INTO upv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Erpe Tata nga mimaur tuwi ngok vini mukoni inu, ko inu numaur renge Tata, erpok kele m̃er nga murroi inu nibek, ni pirpok ko, pimaur renge inu. ");
INSERT INTO upv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ngel evi niv nga mivel renge melrin vini iel ngatan. Sete erpe mana nen nga tata se kerr marurroi tuwi, ko mian ko marmij bbong. M̃er nga murroi niv ngel pimaur tuwi ngok vini.” ");
INSERT INTO upv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Owra nanu ngel nir renge naim kortien ser daron nga mivisviseni renge Kapaneam e. ");
INSERT INTO upv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nir elep renge jinibb sen nir daron nga marunge nale sen ngel e, ko arwera “Nevisvisenien sen ngel eterter temijpal, isi ko orongwos pumurrarronge?” ");
INSERT INTO upv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu ni lweni orongwose nga jinibb sen nir arunge esij renge nanu nga muwrai ngok, arwerwera malum bbonge renge nir lululwi bbong. Ko owrai tevir, “Nale welel lebbong olokloksi kami? ");
INSERT INTO upv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ko pirpese ko vajin poro kami kaplesi Jinibb Mawos p̃isa tongsa luwi van mare renge lat nga m̃ilik e tuwi? ");
INSERT INTO upv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nem̃in ko evi nga m̃ilai mauren, niben sete orongwos puloli nanu pisan. Nale nga mowrair tevi kami arivi nem̃in ko armaur. ");
INSERT INTO upv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Niko renge iok, kami sopor sete arosuri.” Suri Iesu orongwos wowomue pa siko nir nga sete marosuri, ko siko nga pia-tekai kerasi ni. ");
INSERT INTO upv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ko Iesu owrai kele: “Renge murrun ngok ko muloli nga inu mowrai tevi kami, Sete jinibb san orongwose pivini jik, poro nga bbong Tata suk ko pimarong.” ");
INSERT INTO upv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ngok suri iok ngok ko, ololi jinibb sen elep arlulwi, setemun arpitevi ni. ");
INSERT INTO upv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ko Iesu owrai tevi jinibb sen nir esngavöl drromon eru, “Erpese, kami kele kapluwi kapiel?” ");
INSERT INTO upv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ko Saemon Pita owra lweni tevi, “Numal, naban ji si kele e ko mun? Nik ko pa kutori nale ne mauren nga muto tuwi ngok vini! ");
INSERT INTO upv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kem namosuri ko namrongwose nga nik kuvi Jinibb On se Atua.” ");
INSERT INTO upv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesu owrai lweni tevir, “Sete inu nutobbtobbue kami nga esngavöl drromon eru ngok? Ko san renge kami evi demij!” ");
INSERT INTO upv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Owra suri Jutas, natu Saemon Iskariot, san renge nir esngavöl drromon eru nga pia-tekai kerasi ni. ");
INSERT INTO upv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Vitunen renge nanu ngel, Iesu otutur suri renge Galili. Sete emrreni pian pututur renge Jutia, suri m̃eri Isrel nga marlelep nir armerreni parevji pini. ");
INSERT INTO upv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ko nabong ne nanen ne devji se m̃eri Isrel nir oruj mori. ");
INSERT INTO upv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ko Iesu tasin nir arwerai tevi ni, arwera “Kupiel lingi iel, kupan Jutia e, puloli nga jinibb som nir kele parlesi majingen som nga komok-lolir. ");
INSERT INTO upv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Poro jinibb san pimrreni putur limjer, sete orongwos p̃imajing silsilveni te. Poro kuploli nanu ngel nir, kupviseni wor nik lweni ko tevi jinibb jijle nir!” ");
INSERT INTO upv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Arij erpok suri nir, nga marivi tasin mawos wor nir, nir kele sete arosuri ni. ");
INSERT INTO upv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ko Iesu owrai tevir, “Daron suk setewor evini. Kami ma daron jijle evi pa se kami ko nir. ");
INSERT INTO upv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jinibb nir sete arongwos parungasi kami. Ko inu ma arungasik, suri mowra tweni majingen ser nga marsij. ");
INSERT INTO upv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kami ma kapan renge nanen. Inu sete numa-van rengen, suri daron suk mawos setewor evini.” ");
INSERT INTO upv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Owra nale ngok tevir jile, ko nir arivel. Ko ni elik jer renge Galili. ");
INSERT INTO upv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tasin nir aran renge nanen ne devji. Vitunen vajin ko Iesu evivitu surir. Sete evel limjer te, ko evel silsilveni. ");
INSERT INTO upv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","M̃eri Isrel nga marlelep nir arpej ni renge nanen, ko arsusi “Nibeni ni?” ");
INSERT INTO upv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ko renge livö renge nir arsur vijvije arsupsup̃e suri ni elep. Sopor arwera ni evi jinibb nga m̃irres, ko sopor arwera “Ejki, ok-kerkerasi bbong jinibb ko nir.” ");
INSERT INTO upv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ko sete san ejilwer suri ni re limjer, suri armetutue m̃eri Isrel nga marwowomu re nir. ");
INSERT INTO upv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ko mian vajin mijpari liven sopon ne nabong nir ne nanen nen, ko Iesu evini limjer vajin, ko evan renge Naim On se Atua ko evisviseni jinibb nir rengen. ");
INSERT INTO upv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","M̃eri Isrel nga marlelep nen nir artaole, ko arwera “M̃erel sete bbong arvisviseni sopon, ko orongwose nanu ngel nir erpese?” ");
INSERT INTO upv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu owra lweni tevir, “Nevisvisenien suk sete evi nga inu, ko evi se ni nga mukoni inu. ");
INSERT INTO upv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Poro jinibb san pimarong puloli marongen se Atua, m̃ernen pia-rongwose nevisvisenien ngel nga inu nomok-visviseni evel ji Atua vini, rreknga evi inu bbong nevisvisenien suk. ");
INSERT INTO upv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","M̃er nga musp̃e suri lweni bbong ni lweni, epej sel nga bbong pusrusrövi lweni bbong ni ko ren. Ko ni nga ma muwra pusrövi kis ni nga mukoni, m̃ernen ko ewretun, ko sete nanu nga m̃isij san oto ren. ");
INSERT INTO upv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses elai pa nale nesesreien tevi kami. Ko kami san sete otori rragrrage. Ko suri sev kamwera kaprevji pinik?” ");
INSERT INTO upv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Delung arwera lweni tevi, “Demij oto rem! Isi owra pirevji pinim?” ");
INSERT INTO upv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ko Iesu owrai tevir “Nuloli majingen nga milep san, ko kami kamtaole. ");
INSERT INTO upv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ela bae tevi kami (erpe sete Moses, ko apu se kami nir, metka ser nga wowomu nen nir.) Ko kami kamok-loli bipiwarreng se kami nir arok-an renge bae, ko kamrongwos kaprevjir kele renge nabong on. ");
INSERT INTO upv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kamok-loli arok-an renge bae renge nabong on erpok, nga nale nesesreien se Moses sete pimaot otvi. Ko erpese kami kamlolarsi inu nga mololi jinibb niben totoklai m̃irres renge nabong on? ");
INSERT INTO upv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sete kaptor ngavilvil nga kapwer lokloksi nanu, ko kaprrorrmi lilane mun, musuw ko kapa-wera suri vajin lat nga pia-to surie.” ");
INSERT INTO upv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nir sopon renge delung ne m̃eri Jerusalem nir arwera “Kules, m̃er nga, nga marwera parevji pini nga le ngel! ");
INSERT INTO upv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kules, ni le ngel: mutur limjer m̃irij ngel, ko sete san erij tere! Rreknga jinibb nga marlelep se kerr nir arongwose nga ni ewretun evi Mesaea. ");
INSERT INTO upv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ko nanu ma san: m̃erel kerr rramrongwose lat nga mivel e vini. Ko daron nga Mesaea pia-vini e, sete san purongwose lat nga pia-pelari e.” ");
INSERT INTO upv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ko suri nga marok-werai mirpok, daron nga Iesu mivisviseni e renge Naim On se Atua, ko ekail van mare, owra “Ia, ko kami kamrongwose inu, ko kamrongwose ngabe nga mevel e vini? Ko inu sete nuvini suri bbong inu norrorrmien suk. Ni okoni inu, ni evi weretunen. Ko kami sete kamrongwose ni. ");
INSERT INTO upv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Inu ma nurongwose ni, suri nuvel ji ni le mevini. Ni ko okoni inu.” ");
INSERT INTO upv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ngok ololi arwera parevei ni. Ko sete nir san orrul ren, suri mete nial sen setewor evini. ");
INSERT INTO upv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ko delung elep arosuri ni. Ko arwera “Poro nga Mesaea ni ko malum setewor evini, ko ni pia-loli kele wor majingen nga para-lelep wor nir, piasie nga m̃erel mulolir ngel nir? Ejki, ni le pa!” ");
INSERT INTO upv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parasi nir arunge delung nir marok-sur vijvij malum marok-sup̃e suri nanu nga Iesu mulolir ngok nir. Ko ngok nir ko batu jinibb ne sulsulen nir arkoni jinibb ne no nuval sopor paran parevei Iesu. ");
INSERT INTO upv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ko Iesu owrai tevir, “Beptevi kami ma beblen sete pipriv, ko bevel lingi kami, bean ji ni nga mukoni inu. ");
INSERT INTO upv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kami kappej inu ko sete kapa-lesik, suri lat nga bean e, kami sete kamrongwose kapini ren.” ");
INSERT INTO upv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ko m̃eri Isrel nen nir arwerwera lulwenir e, arwera “Owra pian ngabe nen e le, nga kerr sete rraplesi ngel? Pian lat san nga m̃eri Isrel nga marivel lingi kerr marlik e, ko pivisviseni m̃eri Gris nir? ");
INSERT INTO upv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Owra erpese le muwrai mirpel ngel, ‘Kappej inu, ko sete kama-lesik, ko lat nga b̃elik ren, sete kamrongwos kapini ren?’ Owra sev ko?” ");
INSERT INTO upv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Renge nabong nga muto ore jere renge nanen ne devji se m̃eri Isrel nir, ngok evi nabong nga milep ko nga m̃irres nen jer, Iesu otur imare ko ekail, owra “Poro jinibb san nolon emesmes, pivini jik pimni nuwi! ");
INSERT INTO upv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","M̃er nga muosuri inu, m̃ernen ‘mete nuwi seser ne mauren nga tuwi ngok vini puwowosi peleplarie renge nolon’, erpe Naul On muwrai.” ");
INSERT INTO upv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ngok Iesu osp̃e suri Nem̃in nga nir nga para-osuri para-lai. Ko Nem̃in On nen setewor evini, suri Iesu setewor emra renge mijen, ko setewor evan renge nosrövien. ");
INSERT INTO upv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Delung elep daron nga marunge nale sen ngel e, ko arwera “Weretunen, m̃erel evi propet nen.” ");
INSERT INTO upv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ko nir sopon arwera “M̃erel evi Mesaea.” Ko nir sopor arwera “Mesaea piplari ko Galili? Ejki rres! ");
INSERT INTO upv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Renge Naul On owra Mesaea piplari renge metka se Numal Devet, ko pia-ak renge Betliem, lat nga Numal Devet.” ");
INSERT INTO upv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ngok suri marij latlat mirpok ngok ko, ololi meling jinibb ngok nir nolor eru e. ");
INSERT INTO upv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nir sopor armerreni parevei ni, ko sete san orrul totoni ni, ejki. ");
INSERT INTO upv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jinibb ne no nuval nen nir arlulwi vini ji batu jinibb ne sulsulen nir ko Parasi nir. Ko nir arsusi tevir, arwera “Suri sev sete kamrevei ni vini?” ");
INSERT INTO upv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jinibb ne no nuval nen nir arwera lweni tevir, “Sete nabong san jinibb san erij erpe m̃erel m̃irij.” ");
INSERT INTO upv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parasi arwera lweni tevir, “Kami kele, ololi kami kamlengleng kele? ");
INSERT INTO upv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ko erpese renge jinibb womu ne jinibb nir ko kem Parasi nir, sete san osuri ni! ");
INSERT INTO upv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ko delung ngok nir nga marosuri ngok, sete arongwose nale nesesreien se Moses, ko lolaren se Atua oto rer.” ");
INSERT INTO upv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ko Nikotemas, nir san nga mivini ji Iesu bonevis, owrai tevir, owra ");
INSERT INTO upv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Renge devjen ne nale nesesreien se kerr, sete orongwose rrapsup̃e suri lat nga puto suri renge jinibb san puwowomu, vitunen vajin ko rrapa-runge nale sen ko rrapa-meteni suri nanu nga mulolir.” ");
INSERT INTO upv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ko nir arwera lweni tevi, arwera “Ko rrek nik kele kuvi m̃eri Galili rrek? Poro kuppej renge Naul On ko kuplesi ko, sete propet san orongwose p̃iak renge Galili!”");
INSERT INTO upv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ko nir p̃etp̃eti arlulwi vini renge naim ser e, ko Iesu otongsa van renge Botwen ne lolnai ne olip e. ");
INSERT INTO upv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ko mevinen renge rorpong susu, ko olwi kele van renge Naim On e. Ko delung elep arini kele jin, ko ni esakel ko evisvisenir. ");
INSERT INTO upv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ko jinibb nevisvisenien ne nale nesesreien nir ko Parasi nir arpitevi nesevin san vini, nga muloli batun. Ko arlingi otur renge livö renge nir. ");
INSERT INTO upv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ko arwerai tevi, “Jinibb nevisvisenien, nesevin le san ngel ololi nanu nga m̃isij kele tevi norman m̃inij san nga sete mivi ni diwen sen. Lelingenok ko namrevei ko ren. ");
INSERT INTO upv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ko renge nale nesesreien nga Moses m̃ilai tevi kerr, evi nga vinel pimij le, partuwe pini. Ko nik kuwra erpese?” ");
INSERT INTO upv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Arwerai erpel ngel nga bbong parrowrrowe ni ko rengen, puloli nga nir parla norrorrmien rengen, ko parwer lokloksi ni ren. Ko Iesu ejiol vitan ko olul e bbös nevren renge dan, ololi erpe sete murnge nanu nga marwerai. ");
INSERT INTO upv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ko nir arp̃elak arsusi rongornge malume tevi; mian ko ni otur rramos ko owrai tevir, “Isi renge kami ngok poro nga sete ololi nanu nga m̃isij nabong san, ni ko p̃ila womue nevöt ko putwe wowomue nesevin ngok.” ");
INSERT INTO upv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ko ejiol luwi kele van ngatan, ko olul kele renge dan. ");
INSERT INTO upv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Daron nga marunge, ko nir sisamis arrorrorrmi lululweni rer. Mian ko arm̃etaw sisamis arivel, m̃itipatun renge b̃irtera ko evini ejpari nga vitu jer nen. Ko Iesu esan esapo jer vajin, ko nesevin otur malum renge liven nga mutur ren. ");
INSERT INTO upv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ko ni otur rramos kele, ko setemun elesi san, nesevin bbong esan. Ko owrai tevi, “Vinel, nibeni lartul nga marpitevim nga nir? Sete jinibb san p̃iwer lokloksi nik?” ");
INSERT INTO upv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ko vinnen owra “Numal, san ejki.” Ko Iesu owrai tevi, “Inu kele sete numa-wer lokloksi nik. Kupiel, ko sete kuploli lweni kele mun nololien.” ");
INSERT INTO upv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu owrai kele tevir, “Inu nuvi moron ne iel ngatan. M̃er nga pivijuri inu, ni p̃ila moron ne mauren. Sete orongwos pivel renge nemalik.” ");
INSERT INTO upv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ko Parasi nir arwerai tevi, “Nik komok-rij se nik lweni kobbong, ko niko nale som sete evi weretunen.” ");
INSERT INTO upv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu owra lweni tevir, “Erpok, poro nurij se inu lweni kobbong, ko nale suk evi weretunen, suri nurongwose lat nga mevel e vini ko lat nga bean e. Kami ma sete kamrongwose lat nga mevel e vini ko lat nga bean e. ");
INSERT INTO upv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kami kamok-supsup̃e nanu erpe nga jinibb nir marok-supsup̃e. Ko inu ma sete nusp̃e suri lat nga puto suri re jinibb san. ");
INSERT INTO upv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ko poro inu bosp̃e suri lat nga puto suri re jinibb san, ko nosp̃en suk evi weretunen, suri sete inu kis nusan, ko inu komru wor Tata suk ko nga mukoni inu, komru korti. ");
INSERT INTO upv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aruli kele renge nale nesesreien se kerr nga nale se jinibb eru evi weretunen. ");
INSERT INTO upv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Inu nuvi san nga m̃erij se inu lweni, ko Tata suk kele nga mukoni inu, ni ko erij se inu kele.” ");
INSERT INTO upv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ko nir arsusi lweni tevi ni, “Nibeni Tata som?” Ko ni owra lweni tevir, “Kami sete kamrongwose komru korti te; sete kamrongwose inu, ko sete kamrongwose Tata suk.” ");
INSERT INTO upv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nale ngel nir Iesu owrair renge daron nga mivisviseni jinibb nir renge Naim On, renge lat nga marok-tuwe nevöt rengen. Ko sete san ervei, suri mete nial sen setewor evini. ");
INSERT INTO upv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu owra lweni kele tevir, “Inu bea-ivel, ko kami kapa-pej inu, ko sete kaprongwos kaplesik; ko kapa-mij renge nololien se kami. Ko lat nga bean e, kami sete kamrongwose kapini rengen.” ");
INSERT INTO upv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","M̃eri Isrel nen nga marlelep nir arwera “Owra sev ko, muwra ‘Sete kamrongwose kapini renge lat nga bean ngok e’? Rrek owra putor pini lweni ko, rrek!” ");
INSERT INTO upv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu owra lweni tevir, “Kami kamivi ne iel ngatan, ko inu nuvi ne mare. Kami kamivi ne iel ngatan, ko inu sete nuvi ne iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nuwrai tevi kami, kami kapmij renge nololien se kami nir, poro nga kami sete kaposuri nga inu nuvi m̃ernen.” ");
INSERT INTO upv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ko nir arwera tevi ni, arwera “Aro, nik kuvi isi?” Iesu owra lweni tevir, “Ko erpe nga nomok-werai tetajer tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nanu elep nga kamsarr rer nga inu nurongwose bowrair ko bosp̃e surir re kami, ko ejki wor. Ko San nga mukoni inu, ni evi weretunen, ko inu nomok-wera suri bbong nanu nga mornge jin nir iel ngatan.” ");
INSERT INTO upv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ko nir sete arongwose nga ni osp̃e suri Tata sen tevir. ");
INSERT INTO upv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mian ko Iesu owrai tevir, “Daron nga kami kapa-susi Jinibb Mawos pia-an mare, ko ngok kaprongwose nga inu nuvi m̃ernen. Ko niko inu sete nusan nomok-loli nanu san, ejki. Inu nomok-sup̃e bbong nanu nga Tata suk ko mivisvisenie inu. ");
INSERT INTO upv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ko M̃er nga mukoni inu eptevi inu, sete elinglingi inu nusan, suri tetajer nomok-loli kobbong nanu nga mimrrenir.” ");
INSERT INTO upv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jinibb elep nga marunge Iesu muwrai mirpel ko arosuri ni rengen. ");
INSERT INTO upv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iesu owrai tevi m̃eri Isrel nir nga marosuri ni, owra “Poro kaplik tetajer malum ko pa renge nale suk, ko ngok kamivi jinibb suk weretunen ko. ");
INSERT INTO upv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kaprongwose weretunen, ko weretunen pia-loli kami kapiel sisarow.” ");
INSERT INTO upv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ko nir arwera lweni tevi ni, “Aro, kem ma namivi metka se Epram kobbong, ko setewor namivi demij maur se jinibb san nabong san. Ko suri sev nik kumwerai ngok, Kem nabiel sisarow?” ");
INSERT INTO upv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ko Iesu owrai tevir “Nuwretun nga nuwretun nuwrai tevi kami, isi nga mok-loli nololien evi pa demij maur ne majingen se nololien ko. ");
INSERT INTO upv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Demij maur sete orongwose p̃ilik tuwi ngok vini renge naim, ko natu m̃er nga naim sen ko ma p̃ilik tuwi ngok vini. ");
INSERT INTO upv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ko poro inu Atua Natun bololi kami kapiel sisarow, ngok kapa-ivel sisarow p̃etp̃eti ko vajin. ");
INSERT INTO upv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nurongwose kami kamivi metka se Epram. Ko kamwera kaprevji pinik, suri nale suk milngen ejki renge nolo kami. ");
INSERT INTO upv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inu nomok-sup̃e suri nanu nga m̃elesir ji Tata suk, ko kami ma kamok-loli sev nga kamlesir ji tata se kami.” ");
INSERT INTO upv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ko nir arwerai tevi ni, “Po! Ko niko, Epram evi tata se kem!” Ko ni owrai tevir, “Poro kapweretun nga kamivi metka se Epram, ko ngok kaploli majingen nga marres nga Epram mok-lolir ko. ");
INSERT INTO upv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Inu nga mowra weretunen tevi kami nga mornge ji Atua, ko lelingen ngel kamwera kaprevji pinik suri. Ko Epram sete ololi erpok. ");
INSERT INTO upv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kamok-loli nanu mawos nga tata se kami mok-lolir.” Ko nir arwerai tevi, “Aro, kem ma sete namivi bipi ne sel te ejki! Atua ko evi tata se kem, kem namivi natun weretunen!” ");
INSERT INTO upv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ko Iesu owrai tevir, “Poro nga Atua pivi Tata se kami weretunen, ko kapmerreni inu ko, suri nuplari ji Atua ko nga mevini ngel. Inu sete nuvini suri inu bbong norrorrmien suk, ko ni ko wor okoni inu. ");
INSERT INTO upv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Suri sev sete kamrongwose nanu nga mowrair? Erpok ko wor, suri sete kami kamrongwos rragrrage nale suk. ");
INSERT INTO upv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kami kamivi se tata se kami, Demij! Ko murrun nir nga marivi se tata se kami ko kamok-lolir. Ni erevji pini wowomu jinibb, ko eplak etajer tevi malume. Ko sete elik renge weretunen, suri weretunen ejki renge ni. Daron nga m̃ikrekris, ngok evijuri wor murrun nga ni ko, suri ni evi botgerisen, ko evi tata se botgerisen nir. ");
INSERT INTO upv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Suri nuwra weretunen tevi kami, ko niko kami sete kamosuri inu. ");
INSERT INTO upv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Isi renge kami orongwos ma puwra tweni nga inu nuloli nololien san? Ejki! Inu ma nomok-wera weretunen tetajer, suri sev sete kamosuri inu? ");
INSERT INTO upv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","M̃er nga mivi se Atua ornge nale se Atua. Ko niko kami sete kamrunge nale se Atua, evi suri kami sete kamivi se Atua.” ");
INSERT INTO upv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","M̃eri Isrel nir arwera lweni tevi, arwera “Namweretun, namwera nik kuvi m̃eri Sameria, ko demij esisilvi nik!” ");
INSERT INTO upv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ko Iesu owra lweni tevir, “Inu sete demij esisilvik te. Inu nuosuri Tata suk, ko kami sete kamosuri inu. ");
INSERT INTO upv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Inu sete nupej nosrövien se inu lweni, ejki. Ko San ko ma niko ni ko p̃ia-lai nosrövien tevi inu, ko pia-wer suri lat nga puto suri renge kami. ");
INSERT INTO upv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nuwretun nga nuwretun nuwrai tevi kami, poro jinibb pisan putori totoni nale suk, sete mia-lesi mijen nabong san.” ");
INSERT INTO upv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","M̃eri Isrel nen nir arwera lweni tevi ni, “A! Re iok vajin, nama-rongwose erres nga nik demij esisilvim. Epram emij pa, ko propet nir armij pa, ko nik kuwra poro san putori totoni nale som, ko m̃ernen sete mia-lesi mijen! ");
INSERT INTO upv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Erpee? Nik kulep lingi wor tata se kem Epram nga mimij pa, ko propet nga marmij pa nir? Ko kuwra kupwera nik kuvi isi kele?” ");
INSERT INTO upv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ko Iesu owra lweni tevir, “Poro inu bosrosrövi lweni inu, ko evi nanu nawon. Ko ejki, Tata suk ko osrosrövi inu. Ni ko kamok-wera evi Atua se kami. ");
INSERT INTO upv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ko kami sete kamrongwose ni, inu ma nurongwose. Poro nga bowra sete nurongwose ni, ko bevi jinibb ne gerisen pirpe kami. Ko ejki, nurongwose ni, ko nutori totoni nale sen. ");
INSERT INTO upv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tata se kami Epram eir renge nga m̃ilesi nabong suk, ko renge daron nga m̃ilesi e, eir lengleng.” ");
INSERT INTO upv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","M̃eri Isrel nen nir arwera lweni tevi ni, “Nik ngok setewor siam evi ngavöl elim (50) wor, ko kulesi Epram erpese?” ");
INSERT INTO upv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu owra lweni tevir, “Nuwretun nga nuwretun nuwrai tevi kami, inu ngel nulik womu ko pa osuw, mian ko Epram mia-iak.” ");
INSERT INTO upv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ko nir arevei nevöt arwera partuwe e. Ko Iesu otur tevi jinibb nir, ko evel rrurrngi liven rer, ko esil ivare renge Naim On, evini vare e evel. ");
INSERT INTO upv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu otutur sopon ko elesi jinibb san nga m̃iak ko meten murrorr ko pa. ");
INSERT INTO upv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ko jinibb sen nir arsusi tevi ni, arwera “Jinibb nevisvisenien, isi ko ololi nololien, ololi m̃iak ko meten murrorr? ni, rreknga tata sen rreknga tasu sen?” ");
INSERT INTO upv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu owra lweni tevir, “Ngok sete evi nololien se ni, rreknga tata sen ko tasu sen, ejki. Ngok evi nga puloli majingen se Atua piplari ko rengen. ");
INSERT INTO upv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nata m̃irin evi daron nga rraploli ko wor majingen se ni nga mukonik rengen. Daron nga nata pupong pivini, setemun san orongwos mun puloli majingen san rengen. ");
INSERT INTO upv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Erpe lelingen ngel, inu nulik iel ngatan, ko nuvi moron ne iel ngatan.” ");
INSERT INTO upv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Daron nga muwrai mirpok, ko oltuv van renge dan, ko ekiskisi nolton tevi dan, ko elai nolton nga mikiskisi tevi dan ngok ko ebbölji renge mete metrrorr. ");
INSERT INTO upv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ko owrai tevi, “Kupan kupwirap renge nuwito ne Saeloam (nga marieni mirpel, Okoni). Ko m̃ernen osri sel evan ewirap vaseni meten, ko oklu luwi erres; ko olwi van sisen e. ");
INSERT INTO upv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ko selen nir ko jinibb nga marok-lesi pa ni nga meten murrorr arwera “Sete m̃er nga mok-lik ngun-ngun nga le ngel?” ");
INSERT INTO upv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nir sopor arwera “Ewretun, m̃er nga le ngel”. Ko nir sopor nen arwera, “Ejki, ko morok erpe pini pa ni ko.” Ko ni owrai tevir, “P̃e, inu nen le pa ngel!” ");
INSERT INTO upv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ko nir arsusi tevi ni, “Ia, ko metem oklu luwi erpese ko?” ");
INSERT INTO upv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ko ni owrai tevir, “Jinibb san nga marveruse nisen Iesu ekiskisi dan, ko elai dan ngok, ebbölji renge metek nuru ko owrai tevik, ‘Kupan renge nuwito ne Silam ko kupwirap.’ Ko mean mewirap ko nuklu luwi.” ");
INSERT INTO upv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ko nir arsusi tevi ni, “Ko nibeni m̃ernen?” Ko ni owra lweni tevir, “Iawo, sete nurongwose.” ");
INSERT INTO upv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Arpitevi m̃er nga bonevis meten murrorr nen van ji Parasi nir. ");
INSERT INTO upv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Renge nabong nga Iesu mikiskisi dan ngok ko muloli metrrorr meten m̃irres luwi ngok e, evi nabong on. ");
INSERT INTO upv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ko Parasi nir arsusi tevi ni, arwera “Ko kuklu luwi erpese?” Ko ni owrai tevir, “Ela dan, ebbölji renge metek nuru, ko nuwirap, ko nuklu luwi erres.” ");
INSERT INTO upv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ko nir sopor renge Parasi arwera “M̃ernen sete evi jinibb se Atua ko, suri sete otori nabong on.” Ko nir sopor nen kele arwera “Ko jinibb ne nololien san sete orongwos puloli nelesien nga mirpel san!” Ngok ololi nir nolor eru e. ");
INSERT INTO upv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ko Parasi nir arsusi kele tevi metrrorr, arwera “Erpe nik, kumwerai ololi metem nuru orres. Ko nik kurrorrmi m̃ernen evi isi ko?” Ko metrrorr owrai tevir, “Evi propet ko san.” ");
INSERT INTO upv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Parasi nen nir sete arosuri nga m̃erel evi metrrorr, ko oklu luwi kele. Artiriv wore parverus tata sen ko tasu sen porini. ");
INSERT INTO upv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ko arsusi tevi nuru, “M̃erel evi natu kamru nga m̃iak ko meten murrorr? Ko oklu luwi erpese le?” ");
INSERT INTO upv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","M̃ernen tata sen nuru tasu sen orwera “Ewretun nga ni evi natu komru, ko ewretun nga m̃iak ko meten orrorr ko pa. ");
INSERT INTO upv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ko erpese nga muklu luwi, komru sete nomor-rongwose te ejki. Ko sete nomor-rongwos kele m̃er nga muloli meten morkulu luwi. Kapsusi tevi ni, puwrai ko tevi kami. Etra ko pa, evter puwra suri nanu nga miplari jin.” ");
INSERT INTO upv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tata sen nuru tasu sen orwerai erpok suri ormetutue m̃eri Isrel nga marlelep nen nir. Suri arwerai jile pa nga poro jinibb pisan puwra nga Iesu evi Mesaea, ko ngok puloli nir parla tweni m̃ernen renge naim gortien ser, pijkie rengen. ");
INSERT INTO upv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Niko muloli nga tata sen ko tasu sen morwera “ni etra ko pa, sian evter kapsusi ni e.” ");
INSERT INTO upv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ko arverus lweni kele m̃er nga meten murrorr nga vini jir, ko arwerai tevi, “Nik kupsurövi Atua ko wor suri. Kem ma namrongwose m̃erel evi jinibb ne nololien.” ");
INSERT INTO upv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ko ni owra lweni tevir, “Sete nurongwose te, m̃ernen pivi jinibb ne nololien, rreknga ejki. Nanu sansan kobbong nurongwose, nga metek murrorr ko lelingen ngel nuklu luwi.” ");
INSERT INTO upv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nir arsusi tevi ni, “Ololi erpese nik, ololi erpee ko ko metem morkulu?” ");
INSERT INTO upv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ko ni owrai tevir, “E, nuwrai jile pa tevi kami, ko kami sete kammurrarronge. Erpee? Kami kammerreni kaprunge kele? Kami kele kammerreni kapivi jinibb sen, rrek?” ");
INSERT INTO upv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ko nir arsowri ni, ko arwerai tevi ni, “Nik kuvi jinibb sen, kem namivi jinibb se Moses! ");
INSERT INTO upv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kem namrongwose Atua erij tevi Moses. Ko morok, sete namrongwose evel ngabe ko vini!” ");
INSERT INTO upv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ko m̃er nga owrai lweni tevir, “O, nanu nga rramtaole le, kami sete kamrongwose lat nga mivel e vini! Ko ni ololi metek orkulu luwi! ");
INSERT INTO upv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kerr rramrongwose, Atua sete orongwose pumurraronge m̃er nga muloli nololien, orongwos bbong m̃er nga mutori ni ko, ko m̃er nga muloli nanu nga ni mimrrenir, ni ko ma pumurrarronge. ");
INSERT INTO upv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","M̃itipatun renge daron nga Atua muloli iel ngatan e mijpari lelingen ngel, setewor arunge jinibb san ololi m̃er nga m̃iak ko meten murrorr oklu luwi, ejki rres nawon. ");
INSERT INTO upv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Poro m̃erel sete pivi se Atua, ko sete orongwose rragrrage puloli nanu pisan!” ");
INSERT INTO upv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nir arwera lweni tevi, “Aro, nik kuak renge nololien, ko kuloli nololien tetajer malum, ko kuwra kupvisviseni kem?” Ko arwirr tweni ni renge naim gortien ser. ");
INSERT INTO upv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu ornge nga marwirr tweni m̃ernen renge naim gortien ser pa. Mian ko eskai ko owrai tevi, “Nik kuosuri Jinibb Mawos?” ");
INSERT INTO upv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ko ni owrai lweni tevi, “Numal, isi ko, nga poro inu bosuri renge ni?” ");
INSERT INTO upv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ko Iesu owra lweni tevi, owra “Nik kulesi jile pa m̃ernen, m̃ernen evi m̃er nga m̃irij tevim lelingen ngel.” ");
INSERT INTO upv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ko m̃er nga owra “Numal, nuosuri!” Ko ejipa vitan ko olotoe. ");
INSERT INTO upv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu owra “Inu nuvini iel ngatan tweni nga bowra suri lat nga puto suri renge jinibb nga meten sete mukluklu, puklu luwi vajin, ko jinibb nga markulkulu parivi vajin metrrorr nir.” ");
INSERT INTO upv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ko Parasi sopor artur tevi ie arunge nga ni muwra nale ngok nir mirpok, ko arwera tevi, “Aro, kem kele namirpok, mete kem orrorr?” ");
INSERT INTO upv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu owrai tevir, “Poro piwretun mete kami purrorr, ko nololien se kami sete putoe. Ko suri kami kamwera kamkulkulu, ngok nololien se kami otoe ko.” ");
INSERT INTO upv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu owra “Nuwretun nga nuwretun nuwrai tevi kami, m̃er nga sete m̃ikali renge metali ne sipsip e ko m̃isa tela naworr, m̃ernen evi jinibb venao ko. ");
INSERT INTO upv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ko m̃er nga m̃ikali renge metali e, ni evi m̃er nga mok-metmete sipsip nir. ");
INSERT INTO upv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ko m̃er nga mok-metmete metali ne sipsip etasi tevi, ko sipsip arongwose ni drrelan; ko ni orongwose piverus sisamis niser, ko owomue nir parivare. ");
INSERT INTO upv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Daron nga miptevi twenir ivare, owowomue nir; ko sipsip arvijuri ni, suri arongwose drrelan. ");
INSERT INTO upv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sete arongwose parvijuri jinibb m̃inij; parwolue ko, suri sete arongwose drrelan.” ");
INSERT INTO upv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu owra nale rrongrrongvien ngel tevi nir, ko sete arongwose isev ko muwrai tevir. ");
INSERT INTO upv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iesu owrai kele tevir owra “Nuwretun nga nuwretun nuwrai tevi kami, inu ngel nuvi metali ne sipsip. ");
INSERT INTO upv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Jinibb nga marwowomue inu arivi jinibb venao kobbong nir. Ko sipsip sete arunge drrelar. ");
INSERT INTO upv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Inu nuvi metali. M̃er nga m̃ikali ji inu e, ni pia-asi van re mauren; ko pia-lik p̃irres, pirpe sipsip san nga sete nanu rrum san pulokloksi, ko nanen sen owun saut temijpal. ");
INSERT INTO upv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jinibb venao evini bbong nga pivevna ko, ko pirevji pini, ko pulokloksi p̃etp̃eti. Inu ma nuvini nga b̃elai mauren tevir nga parla p̃etp̃eti vajin. ");
INSERT INTO upv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Inu nuvi jinibb metmeten nga m̃irres. Jinibb metmeten nga m̃irres ela mauren sen tevi jinibb nir, emij surir. ");
INSERT INTO upv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","M̃er nga marlingi bbong pimetmete sipsip nga parwuli rengen, daron nga m̃ilesi guli rrum mivini, ko elngi kurtweni sipsip nir ko owlu lingir. Ko guli rrum ean aji terteri sopor, ko ojir arwolu sarrsarr. ");
INSERT INTO upv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","M̃er nga mok-metmete sipsip nga marwuli bbong ren, ko muwlu lingir ngok; suri ni mivi bbong m̃er nga marwuli bbong ren, ko niko sete muwor surir. ");
INSERT INTO upv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Inu nuvi jinibb metmeten nga m̃irres renge sipsip nir. Ko nurongwose sipsip suk nir, ko nir arongwose inu. ");
INSERT INTO upv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Erpe Tata orongwose inu, ko inu kele nurongwose Tata. Ko numarong nga bemij suri sipsip suk nir. ");
INSERT INTO upv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Sipsip m̃inij kele wor sopor nga marivi suk, nga sete marivi ne laut ngel, b̃elair vini rengen kele. Nir parunge drrelak; parivi meling pisansan, ko jinibb metmeten ser pisansan. ");
INSERT INTO upv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tata suk emrrenik suri numarong b̃elngilngi mauren suk, bemij sere jinibb nir. Ko mian ko bea-la lweni kele, bemaur luwi. ");
INSERT INTO upv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sete jinibb san orongwos p̃ila tweni mauren suk jik, putor pinik. Inu kobbong numarong bemij. Derteren suk otoe nga b̃elngilngi mauren suk bemij, ko derteren suk otoe nga b̃ela lweni kele mauren suk, bemaur luwi. Niko Tata suk owrai tevik nga bololi pirpok.” ");
INSERT INTO upv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Renge muwrai mirpok ngok, m̃eri Isrel nga marlelep nir norrorrmien ser eru e kele rengen. ");
INSERT INTO upv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nir elep arwera “Demij esisilvi ko epapa nawone! Erpese kami kammurrarronge?” ");
INSERT INTO upv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ko nir m̃inij nen nir arwera “Sete m̃er nga demij m̃isisilvi ok-rij erpok, ejki. Demij orongwose puloli metrrorr san puklu luwi kele?” ");
INSERT INTO upv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Evi daron ne nanen san se m̃eri Isrel nir, nga marok-rrorrmi lweni Naim On se Atua nga marloli muon luwi bonevis. Nanen ngel artori renge Jerusalem. Ko renge daron nen evi daron ne melas. ");
INSERT INTO upv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iesu otutur sopon renge naim san nga mutur re jeli Naim On, nga marveruse Naim Salsal se Solomon. ");
INSERT INTO upv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ko m̃eri Isrel nga marlelep nir arini jin, artur rrale ko arwerai tevi, “Pijpari seveling nga nik kopok-loli kem nabok-tiriv pirpel? Namtirivtiriv ko ejki rres nawon. Poro nga nik kuvi Mesaea, kupwerai momsawose tevi kem vajin!” ");
INSERT INTO upv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ko Iesu owra lweni tevir, “Nuwrai pa tevi kami, ko sete kamosuri te. Ko majingen nga mololir renge nise Tata suk arij se inu. ");
INSERT INTO upv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ko kami sete kamosuri, suri nga sete kamivi sipsip suk, erpe nga mowrai pa tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip suk nir arunge drrelak; ko inu nurongwose nir, ko nir arvijurik. ");
INSERT INTO upv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Inu nula mauren nga muto tuwi ngok vini tevir, nga nir setemun parmij kele nabong pisan. Ko sete san orongwose p̃iteseni twenir renge inu nevrek. ");
INSERT INTO upv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tata suk nga m̃ilair tevik, ni eterter asie jinibb p̃etp̃eti nir, ko sete san orongwos p̃iteseni twenir renge ni nevren. ");
INSERT INTO upv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ko Tata suk ko inu nomorivi sansan kobbong.” ");
INSERT INTO upv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","M̃eri Isrel nen nir arla kele nevöt arwera partuwe pini ni kele. ");
INSERT INTO upv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ko Iesu owrai tevir, “Nuloli majingen elep nga marres tevi kami nga Tata suk m̃ilair tevik nga bololir. Ko renge majingen ngabe nen ko nga kami kamwera kaptuwek rengen?” ");
INSERT INTO upv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ko m̃eri Isrel nir arwera lweni tevi, “Renge majingen nga m̃irres sete namrongwos nabtuwem suri, ko suri kuwer lokloksi Atua ko. Suri nik kuvi bbong jinibb, ko kumtur imare ko kumloli lweni nik lweni kumsorsan tevi Atua!” ");
INSERT INTO upv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ko Iesu owra lweni tevir, “Sete aruli renge Naul On owra ‘Kami kamirpe Atua’? ");
INSERT INTO upv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kerr rramrongwos nanu nga Naul On muli surir, ewretun tetajer ko pa tuwi ngok vini. Ngok niko nir ngel nga Atua m̃ila nale sen van jir, Atua everuse nir ‘Atua’. ");
INSERT INTO upv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ko inu ma nulep asi nir ngok ko. Ko Tata osusture inu, ko okonik vini iel ngatan. Ko erpese kami kamwera inu nuwer lokloksi Atua suri nga mowra inu nuvi Atua Natun? ");
INSERT INTO upv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Poro sete nomok-loli majingen se Tata suk nir, ko erres kobbong, sete kaposuri inu. ");
INSERT INTO upv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ko poro bololir wor, ko pesveni poro sete kaposuri inu suri nale suk, ko kaposuri ma inu suri majingen suk nir, nga puloli kami kaprongwose. Ko kaplesi wose nga Tata suk elik renge inu, ko inu nulik renge Tata suk.” ");
INSERT INTO upv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vesan kele arloli lesi kele nga parrul totoni; ko evel easi renge nevrer, evel lingir. ");
INSERT INTO upv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Evel luwi kele van renge devje nuwi seser ne Jortan e, renge lat nga Jon Baptaes mipaptaes womue ni rengen, ko elik ie. ");
INSERT INTO upv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jinibb elep arini jin, ko arwera “Ewretun, Jon Baptaes sete ololi nelesien te ejki, ko nanu jile nga ma Jon Baptaes musp̃e surir renge m̃erel arweretun.” ");
INSERT INTO upv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ko jinibb elep lengleng arosuri ni renge ie. ");
INSERT INTO upv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","M̃eri Betani san, nisen Lasros, emsi. Betani evi ngaim se Merri ko tuwan Marta. ");
INSERT INTO upv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Merri ngel evi vin nga vitunen ko mia-jivi senta nga mapun m̃irres renge b̃ela Iesu ko mia-tewasi jomro batun e. Vinel ko tuwan Lasros mimsi nen. ");
INSERT INTO upv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ngok nesen niaken ngel ko nuru orla nale ngel van ji Iesu, “Numal, selem nga kumrreni milep emsi.” ");
INSERT INTO upv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Daron nga Iesu murnge e ko owra “Mesien se Lasros ngok sete evi ne mijen, ko evi ma nosrövien se Atua, nga puloli parsurövi inu Atua natun mawos rengen.” ");
INSERT INTO upv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu emrreni lenglenge Marta ko tasin Merri ko Lasros. ");
INSERT INTO upv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ko daron nga murnge nga Lasros mimsi, ko elik malum lat nen nga m̃ilik nen e nabong eru kele wor orasi. ");
INSERT INTO upv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Vitunen renge ngel ko owrai tevi jinibb sen nir “Kerr pulwi kele van renge Jutia e.” ");
INSERT INTO upv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ko jinibb sen arwerai tevi, “Ai, jinibb nevisvisenien, seveling nga kobbong m̃eri Isrel nir nga marlik Jutia arwera partuwem, ko erpese kuwra kupan kele ie ko?” ");
INSERT INTO upv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu owra “Erpese, sete mete nial esngavöl drromon eru renge nabong san? Ko poro jinibb pisan pivel renge nata m̃irin, sete orongwos p̃ijilaklak, suri elesi moron ne iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ko poro pivel renge nemalik, ko ngok p̃ijilaklak ko, suri moron ejki ji ni.” ");
INSERT INTO upv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu owra nanu ngel nir, mian ko vitunen owra “Sele kerr Lasros ematur, ko inu bean bowni tweni pimra renge meturen sen.” ");
INSERT INTO upv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ngok jinibb sen nir arwerai tevi, “Numal, poro pimatur ko p̃irres luwi kobbong.” ");
INSERT INTO upv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nga m̃irij mirpok, ko Iesu osp̃e mijen se Lasros; ko nir arrorrmi rreknga owra emitmatur rres kobbong, omosi. ");
INSERT INTO upv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ko Iesu owra momsawos vajine limjer tevir, “Lasros emij pa. ");
INSERT INTO upv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ko inu nuir nga sete m̃elik tevi ni ie, suri kaplesi vajin nanu nga p̃irres san renge kami, nga puloli kami kaposuri. Kerr pian lat nga marlingi e.” ");
INSERT INTO upv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ko Tomas nga marveruse m̃elew owrai tevi jinibb se Iesu nga ngok nen e nir, “Pesveni, kerr kele rrapvijuri ma, rrapan rrapmij rrapvesane ko pa tevi.” ");
INSERT INTO upv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Daron nga Iesu mian vajin, ko elesi nga artevni Lasros nabong ivij pa arasi osuw. ");
INSERT INTO upv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani oto mori bbong Jerusalem sopon, erpe pirpe kilometa itul bbong sopon, ");
INSERT INTO upv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ko niko m̃eri Isrel elep arini ji Marta ko Merri nga parla nale molmol tevi nuru suri renge mijen se tuwa nuru. ");
INSERT INTO upv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Daron nga Marta murnge nga marwera nga Iesu mivini, ko evel ore renge sel. Ko Merri elik jer renge naim. ");
INSERT INTO upv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta owrai tevi Iesu, “Numal, poro ma kuplik bbong iel, ko tuwa komru sete mia-mij welili, pijki ko. ");
INSERT INTO upv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ko nurongwos mae lelingen ngel, poro kupngoni isev tama san tevi Atua, ko Atua p̃ilai ko wor tevi nik.” ");
INSERT INTO upv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ko Iesu owrai tevi, “Tuwam pimaur luwi kele kobbong.” ");
INSERT INTO upv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ko Marta owrai tevi, “Nurongwose nga pia-maur luwi kele renge nabong nga vitunen nga Atua puloli jinibb nir parmaur luwi.” ");
INSERT INTO upv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ko Iesu owrai tevi nesevin, “Inu nuvi batun ne mauren. M̃er nga muosuri inu, poro pimij, ko pia-maur luwi kele ko wor. ");
INSERT INTO upv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ko isi nga mimaur ko muosuri inu, sete orongwos pimij rragrrag pijpari tuwi ngok vini. Kuosuri renge iok?” ");
INSERT INTO upv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nesevin owra lweni tevi, “O-o, Numal, nuosuri nga nik kuvi Mesaea, Atua natun mawos, ni nga propet nga tuwi nir arok-wera pia-vini renge iel ngatan.” ");
INSERT INTO upv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Daron nga vinnen muwrai jile mirpel ngel, ko evel evan everus silveni bbong tasin Merri, ko owrai tevi, “Jinibb nevisvisenien le ngel osusi nik.” ");
INSERT INTO upv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Daron nga Merri murnge, ko emra ngavilvil evan ji Iesu. ");
INSERT INTO upv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu setewor evini renge ngaim, ejki wor. Elik malum renge lat nga Marta mian jin ren. ");
INSERT INTO upv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","M̃eri Isrel nir nga marla nale molmol tevi Merri renge naim marlesi nga Merri mimra kasi mivel, ko arvijuri suri. Arrorrmi rreknga nesevin pian renge dubb, p̃iting ie. ");
INSERT INTO upv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Merri evini renge lat nen nga Iesu m̃ilik e. Ko elesi ko ejipa van ngatan osusweni non renge b̃ela Iesu, ko owrai tevi, “Wurru, Numal, poro kuplik iel, ko tuwak sete mia-mij ko te ejki.” ");
INSERT INTO upv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Daron nga Iesu m̃ilesi nesevin m̃iting, ko m̃eri Isrel nir nga marpitevi nesevin marting, ko engavsi, ornge lenglenge esij renge nolon, erpe p̃iap nawone. ");
INSERT INTO upv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ko osusi tevir, “Nibeni lat nga kamtevni e?” Ko arwerai tevi, “Kupini ta numal, kuplesi.” ");
INSERT INTO upv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu eting. ");
INSERT INTO upv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","M̃eri Isrel arwera “Ai, emrreni lenglenge ma morok.” ");
INSERT INTO upv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ko nir sopor nen arwera “Ai, m̃erel ololi metrrorr meter markulu bonevis. Erpese sete orongwos puloli morok kele sete pimij?” ");
INSERT INTO upv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Vesan kele Iesu engavsi, ornge lengleng esij. Ko evan renge dubb. Evi b̃ereng, ko aritini nevöt nga milep oto ore metali nen. ");
INSERT INTO upv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu owra “Kap̃itini tweni nevöt.” Ko Marta, joji m̃er nga mimij nen, owra lweni tevi “O, ejki, Numal, lelingen ngel opo le pa, suri bongin ivij le pa osuw!” ");
INSERT INTO upv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ko Iesu owrai tevi nesevin, “Sete nuwrai tevim nga poro kuposuri ko kupa-lesi nosrövien se Atua?” ");
INSERT INTO upv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ko nir aritini tweni nevöt nen. Ko Iesu eleng raji meten oklu imare, ko owra “Tata, nuwra erres tevi nik nga komok-runge inu. ");
INSERT INTO upv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nurongwose nga nik kurnge inu tetajer, ko nuwra nanu ngel suri lartul nga martur ngel nir, nga puloli parosuri inu nga nik kumkoni inu.” ");
INSERT INTO upv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Muwrai jile mirpel, ko everus temijpal van mare, owra “Lasros, kupivare!” ");
INSERT INTO upv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ko m̃ernen nga mimij pa eivare vini. Ko nevren nuru ko b̃elan nuru, kalek ne mijen nga marnub̃e e arto malum rer; ko sunsun nga markai renge non arto malum rengen. Ko Iesu owra “Kaptelasi twenir ren.” ");
INSERT INTO upv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","M̃eri Isrel elep nga marini marlesi Merri arlesi sev nga Iesu muloli, ko arosuri ni. ");
INSERT INTO upv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ko nir sopon nen nir arluwi ko aran ji Parasi nir ko arsup̃e suri nanu nga Iesu mulolir tevir. ");
INSERT INTO upv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ko Parasi nir ko batu jinibb ne sulsulen nir arkorti tevi gortien nga milep se m̃eri Isrel nir ko arwera “Kerr puloli pirpese? M̃erel ololi nelesien nga marlelep nir. ");
INSERT INTO upv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Poro rraplinglingi puloli sel ngok, ko jinibb jijle nir tarosuri ni; ko m̃eri Rom nir nga marrul totoni kerr tarlesi tisij ko tartingtinge Naim On se kerr, ko tarlokloksi jinibb se kerr jijle nir.” ");
INSERT INTO upv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","San renge nir nisen Kaeapas; ni evi batu jinibb ne sulsulen nir renge sia nen. Owra “Kami sete kamrongwos rragrrage nanu san. ");
INSERT INTO upv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sete kamrongwose nga evi nanu nga m̃irres nga jinibb pisansan pimij suri delung, pia-la wani jinibb jijle nir nga moro parmij?” ");
INSERT INTO upv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Errlenge sev nga muwrai ngok, ko erij wor nale se Atua, suri evi batu jinibb ne sulsulen ko renge sia nen: ni owra tweni nga Iesu pimij suri m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ko sete nir kis kobbong, ko pia-la lweni kele wor jinibb jijle se Atua nga marivel sarrsarr nir. ");
INSERT INTO upv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Renge nabong nen m̃eri Isrel nga martori derteren renge nir arloli nale nga parevji pini Iesu rengen. ");
INSERT INTO upv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ololi Iesu setemun evel limjer renge Jutia, evel lingi ie ko evan renge ngaim nga welili e san nga nisen Eprem, morie lolo merwer. Ko elik tevi jinibb sen nir ie. ");
INSERT INTO upv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nanen ne asien se m̃eri Isrel nir oto mori. Ko jinibb elep arivel aran renge Jerusalem, arwera partaur parwokwok jile tera daron ne nanen ne asien. ");
INSERT INTO upv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ko daron nga marini renge Jerusalem, ko arkulkulu pej Iesu ko arwerwera lululwenir e, “Kamrrorrmi erpese? Pivini ko renge nanen ne asien, rreknga sete orongwos pivini?” ");
INSERT INTO upv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Batu jinibb ne sulsulen nir ko Parasi nir arwerai pa tevi jinibb nir arwera poro san p̃ilesi Iesu lat nga m̃ilik e, ko puwrai tevir parongwose, ko paran parevei. ");
INSERT INTO upv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nanen ne asien nabong ouwon ojpon malum, ko Iesu olwi kele vini renge Betani e renge lat nga Lasros, nga ni muloli mimaur luwi kele renge mijen, lat nga m̃ilik e. ");
INSERT INTO upv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Renge ie artabbu nurre Iesu. Marta etabbu, ko Lasros evi san renge nir nga maraan tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mian ko Merri ela botel nga milep san ne senta nga mapun m̃irres p̃elak nga nowlin milep temijpal nga marloli e nart, ko ejvi p̃etp̃eti renge b̃ela Iesu nuru, ko etwasi e jomro batun. Ko loloim owun saute mapu senta nen. ");
INSERT INTO upv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jutas ne Iskariot, nga mian ko vitunen pia-tekai kerasi Iesu, owra ");
INSERT INTO upv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Erpese kumlokloksi senta nga mapun m̃irres ngok? Poro kupwulwule ko nevöt nen pivi pungut pivatul (300) kis ko, ko orongwos rraplai tevi b̃eres nir.” ");
INSERT INTO upv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Owrai erpel sete suri orrorrmi b̃eres ko nir, ko suri evi jinibb ne venao. Ko ni oksolo narr ser, ko ok-sesaroe nevöt nga muto renge nolon. ");
INSERT INTO upv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ko Iesu owrai tevi “Kuplinglingi nesevin pisan, kuplinglingi puloli metmete tera nga partevnik. ");
INSERT INTO upv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","B̃eres ngok nir parlik tetajer ko pa tevi kami, ko inu ma sete numa-lik tetajer tevi kami.” ");
INSERT INTO upv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Delung jinibb nga milep ne m̃eri Isrel nir arunge nga Iesu elik renge Betani, ko artutur van, sete suri kis Iesu, ko suri kele wor Lasros nga Iesu muloli mimaur luwi renge mijen. ");
INSERT INTO upv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ko niko batu jinibb ne sulsulen nir arloli nale ne Lasros nga parevji pini kele. ");
INSERT INTO upv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Suri nga m̃eri Isrel elep arlesi nga Iesu muloli Lasros mimaur luwi, ko arlingi kurtweni m̃erwomu ser nir, ko arosuri Iesu vajin. ");
INSERT INTO upv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Renge nabong m̃inij nen vajin meling jinibb nga milep nga marini renge nanen ne asien arunge nga Iesu mivel vini pivini renge Jerusalem. ");
INSERT INTO upv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ko arvasi rengsi nini nir ko arivel aran artur ore, ko arkail arwera “Rrapsurövi Atua! Atua p̃irij p̃irres suri ni nga mivini renge nise Iova, Numal se m̃eri Isrel nir!” ");
INSERT INTO upv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ko Iesu elesi natu dongki san ko esakel ren, erpe nga maruli renge Naul On: ");
INSERT INTO upv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‘Kami jinibb ne Saeon nir, sete kapmetutu. Kaplesi Numal se kami evini, esakel renge natu dongki.’ ");
INSERT INTO upv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jinibb sen nir sete arongwos wowomue nanu ngel nir; mian ko vitunen vajin daron nga Iesu mutur imare luwi renge mijen mian renge melrin m̃ila nosrövien sen, ko ngok ara-rrorrmi sweri vajine nga aruli nanu ngel nir suri ni renge Naul On, nga jinibb nir parloli nanu ngel nir tevi ni. ");
INSERT INTO upv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lartul nga marpitevi ni renge daron nga miverus ko muloli Lasros mutur imare luwi renge mijen renge dubb arij suri nanu nga Iesu muloli miplari nen. ");
INSERT INTO upv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nanu ngok ko muloli delung elep kele wor aran jin rengen, suri nga marunge nelesien nen nga muloli. ");
INSERT INTO upv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ko Parasi nir arwerwerai lululweni tevir, “Kaplesi, setemun rramrongwos rraploli mun nanu pisan, suri jinibb jijle arvijuri pa ni.” ");
INSERT INTO upv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jinibb nga maran renge nanen ne asien renge Jerusalem, renge livö rer, m̃eri Gris sopor aran kele nga parlot. ");
INSERT INTO upv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Lartul nen arini ji Pilip, m̃eri Betsaeta ne Galili, ko arwerai tevi “E m̃erel, nammerreni nablesi Iesu.” ");
INSERT INTO upv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip ean owrai tevi Antru, ko Antru nuru vajin Pilip oran orwerai tevi Iesu. ");
INSERT INTO upv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ko Iesu owra lweni tevir, “Lelingen ngel mete nial nen mawos evini nga parsurövi inu Jinibb Mawos. ");
INSERT INTO upv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nuwretun nga nuwretun nuwrai tevi kami, Poro wene nai sete pukur pivitan ngatan renge dan, ko ngok esansan bbölbböl malum. Ko poro pukur ko wor, pivitan ngatan renge dan, pietiv ko pimaur kele, ko ngok ko pia-la wenen pilep ko vajin. ");
INSERT INTO upv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","M̃er nga mimrreni mauren sen iel ngatan putor jabble; ko m̃er nga ma sete mimrreni mauren sen iel ngatan, pia-tori tajere van renge mauren nga muto tuwi ngok vini. ");
INSERT INTO upv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Poro jinibb san pimrreni p̃imajing suk, ko pivijuri surik ko wor. Ngabe nga b̃elik e, jinibb suk kele p̃ilik tevik ie. Ko poro nga jinibb san p̃imajing suk, Tata suk pia-susi van mare.” ");
INSERT INTO upv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Iesu owra “Lelingen ngel nolok ornge esij temijpal, ko bowra pirpese? Bowra, ‘Tata, kupla twenik renge mijen ngel?’ Ejki, sete nurongwos bowra pirpok, suri nanu mawos ngel ko mevini tweni renge iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ko bowra ma ‘Tata, kuploli isev tama san nga pususi nik nisem van mare.’” Ko drrelan san evel renge melrin vini owra “Nususi pa evan mare osuw, ko bosusi kele wor pian mare pivesan.” ");
INSERT INTO upv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Delung nga martur ie marunge ko arwera “Belver ko san”, ko nir sopor nen arwera “Ejki, anglo ko san erij tevi.” ");
INSERT INTO upv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ko Iesu owra lweni tevi delung nga martur ie, “Drrelan ngel sete evini suri inu, ko evini suri kami kaprunge. ");
INSERT INTO upv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lelingen ngel evi daron nga Atua puwra suri lat nga puto suri tevi jinibb nir, ko pusor tweni demij, numal ne iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ko inu daron nga parsusik imare ko bervei jinibb jijle parini jik.” ");
INSERT INTO upv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Owra nale ngel, eviseni sev mijen nga ni pimij rengen. ");
INSERT INTO upv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Delung arwera lweni tevi, “Kem namrunge renge nale nesesreien, owra Mesaea p̃ilik tuwi ngok vini. Ko nik kuwra erpese ko nga kumwerai mirpok ngok, ‘Parsusi wor jinibb mawos ko mare’? Ko isi ko jinibb mawos ngok?” ");
INSERT INTO upv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ko Iesu owrai tevir, “Moron ngel piptevi kami beblen kele ma, ko sete mia-periv te. Daron nga moron ngel mimor e, ko kapiel ko wor rengen, nemalik tia-malik tevtevni kami. Suri ni nga mivel renge nemalik errleng lat nga pian e. ");
INSERT INTO upv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Daron nga moron miptevi kami, ko ngok kaposuri moron, nga puloli kami kapivi jinibb ne moron.” Iesu owra jile nanu ngel nir ko evel teptepe nir, sete parlesi. ");
INSERT INTO upv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ewretun ni ololi nelesien elep temijpal renge nor arlesi, ko sete arosuri ni te, ejki. ");
INSERT INTO upv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Osorsan tevi nale nga propet Aesea muwrai tuwi, owra ‘Numal, isi osuri nanu nga namwerair, isi elesi wose derteren som nga kumviseni?’ ");
INSERT INTO upv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Erpe nga ngok ko, sete arongwos parosuri. Suri Aesea owrai kele vesan, owra ");
INSERT INTO upv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Lartul ngok nir batur eterter erpe nevöt. Ko niko Atua ololi meter arrorr, ko ololi nolor arterter. Suri arwera “Ai, rratlesi renge mete kerr! Rratrongwose renge norrorrmien se kerr! Rratrieni lweni kerr vini jin vajin ko ni tuloli kerr rrata-maur luwi!” ’ ");
INSERT INTO upv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aesea owrai nanu ngel nir, suri elesi nosrövien se Iesu, ko niko musp̃e suri ni. ");
INSERT INTO upv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ko ewretun, m̃eri Isrel elep arosuri Iesu, ko nir elep nga marlelep rer arosuri kele. Ko suri armetutu Parasi nir, ko sete arwerai tweni ni te ejki. Suri armetutu tarwirr twenir renge naim gortien ser. ");
INSERT INTO upv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Suri armerreni nga jinibb parsurövir easi renge nga Atua pusrövir. ");
INSERT INTO upv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesu ekail ko owra tweni “M̃er nga muosuri inu, sete osuri inu kis ko, ko osuri m̃er nga mukonik kele. ");
INSERT INTO upv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jinibb si nga m̃ilesi inu, ngok elesi pa m̃er nga mukoni inu ko osuw. ");
INSERT INTO upv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inu nuvi moron ne iel ngatan. M̃er nga muosuri inu sete orongwos p̃ilik renge nemalik. ");
INSERT INTO upv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Poro jinibb pisan purnge nale suk, ko sete puosuri te, inu sete numa-wera suri lat nga puto suri re m̃ernen. Suri sete nuvini tweni bololi pirpok iel ngatan, nuvini tweni nga b̃ela mauren tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Isi nga mungasi inu, ko sete muosuri nale suk nga mowrai, san nga pia-wera suri lat nga puto suri re m̃ernen otoe. “Nale suk nga mowrai niko pia-wera suri lat nga puto suri re m̃ernen renge nabong nga vitunen. ");
INSERT INTO upv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Inu sete nuwra nawon nanu san. Tata suk nga mukonik ko wor owrai tevik nale nesesreien sev nga inu bea-werair ko bosp̃e surir. ");
INSERT INTO upv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ko nurongwose nale nesesreien sen evi mauren nga muto tuwi ngok vini. Ko niko nale suk nga mowrair, nuwrai osorsan tevi nga Tata suk muwrai tevi inu.” ");
INSERT INTO upv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Evi nabong nga muwomu nen, mian ko mevinen vajin pivi nabong ne nanen ne asien. Ko Iesu orongwose nga mete nial sen evini nga pivel lingi iel ngatan, pulwi van ji Tata sen e. Ni tetajer emrreni jinibb nga marivi sen renge iel ngatan, ko emrrenir ejpari bongsin jer. ");
INSERT INTO upv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iesu eptevi jinibb sen nir renge nanen. Ko Demij elngi womu pae renge nolo Jutas, Saemon ne Iskariot natun, nga ni p̃itkai kerasi Iesu. ");
INSERT INTO upv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu orongwose nga Tata ela nanu p̃etp̃eti nir elngir renge nevren, ko ni orongwose nga ni evel ji Atua vini, ko pulwi kele ko wor van ji Atua e. ");
INSERT INTO upv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ko ni emra renge nanen, ko ori tweni sunsun sen ejingteni oto, ko ela tawol, etatuwe renge b̃in. ");
INSERT INTO upv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ko ela nuwi ejvi van renge narov, ko etipatun errawe b̃ela jinibb sen nir, ko ela tawol nga mitatuwe ko etwasir e. ");
INSERT INTO upv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mian ko evini vajin ji Saemon Pita. Ko Pita owrai tevi “Numal, sete omomsawos nga nik kuprrawe inu b̃elak!” ");
INSERT INTO upv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu owra lweni tevi, “Sev nga mololi sete kuma-rongwose lelingen ngel, vitunen ko wor ko kupa-rongwose.” ");
INSERT INTO upv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita owra lweni tevi “Ejki rres nawon! Sete kuma-rrawe b̃elak nabong san.” Iesu owrai tevi “Poro sete b̃errawe b̃elam, ko nik sete kuma-ivi jinibb suk.” ");
INSERT INTO upv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ko Saemon Pita otur imare owrai tevi, “O, Numal, poro pirpok ko sete b̃elak kis nuru, ko nevrek nuru ko batuk kele!” ");
INSERT INTO upv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu owrai tevi “Ejki, m̃er nga m̃ilalos jile lelingen ngel sete orongwos pulwi p̃ilalos luwi kele, b̃elan kis kobbong nuru; ko ni owokwok p̃etp̃eti ko pa. Kami kamwokwok; ko sete kami jile kamwokwok.” ");
INSERT INTO upv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Suri orongwos womue pa nga isi pia-tekai kerasi ni, ko niko muloli nga mutuw nale ngok, “sete kami jijle kamwokwok”. ");
INSERT INTO upv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Vitunen renge m̃irrawe jile b̃elar, ko ela lweni sunsun sen ko ori lweni, musuw ko esakel luwi renge milngen. Ko owrai tevir, “Kamrongwose sev nga mololi tevi kami? ");
INSERT INTO upv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kami kamveruse inu Jinibb Nevisvisenien ko Numal. Kami kamwerai momsawose inu ko, ");
INSERT INTO upv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","inu nuvi Numal ko jinibb nevisvisenien se kami. Ko ngok, kami kele kaploli nolo kami pian ngatan, ko kaploli pirpok, kaprrarrawe b̃ela kami lululweni nir. ");
INSERT INTO upv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inu nuloli rrongrrongvi tevi kami ko lat nga kaploli suri e. Niko, kami kaploli pirpe nga mololi tevi kami ngok ko. ");
INSERT INTO upv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nuwretun nga nuwretun nuwrai tevi kami, jinibb ne majingen sete ean mare lingi numal sen, ko erpok kele jinibb nga markoni sete ean mare lingi ni nga mukoni. ");
INSERT INTO upv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Poro kaprongwose nanu ngel, ko neiren renge kami poro kaploli. ");
INSERT INTO upv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Sete nuwra kami jijle ngok ko. Nurongwose nir nga motobbtobbuer. Ko Naul On pivini piplari weretunen ko wor, nga muwra ‘M̃er nga murro nanen nurruk p̃irieni ko p̃itre kele inu.’ ");
INSERT INTO upv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nuwra wowomue le ngel tevi kami, vitunen ko pia-pelari; ko poro pia-pelari, ko kami kapa-osuri vajin nga inu nuvi m̃ernen. ");
INSERT INTO upv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nuwretun nga nuwretun nuwrai tevi kami, isi nga m̃itkai nir san renge nir nga mokoni ngel van re naim sen, ngok etka kele pa inu ko. Ko isi nga m̃itkai inu, ngok etkai kele pa ni nga mukoni inu ko.” ");
INSERT INTO upv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Daron nga Iesu muwra nanu ngel e ko ornge lenglenge esij ko owrai tevir, “Nuwretun nga nuwretun nuwrai tevi kami, san renge kami pia-tekai kerasi inu.” ");
INSERT INTO upv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jinibb sen nir armetmetenir e, arrelenge owra nir si nen ko. ");
INSERT INTO upv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","San renge jinibb sen, ni nga Iesu mimrreni, elik mori bbong Iesu, elik lilji. ");
INSERT INTO upv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ko Saemon Pita olongwis bbong tevi, owra “Kupsusi ta tevi ni, isi ko muwrai ngok.” ");
INSERT INTO upv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ngok m̃ernen oruj mori van jin ko osusi tevi, owra “Numal, isi ko m̃ernen?” ");
INSERT INTO upv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ko Iesu owrai tevi, “M̃er nga bea-rrurrngoni niv ko bea-lai tevi. Ni ko evi m̃ernen.” Ko ela bebje niv ko orrurrngoni renge sup ko elai vajin tevi Jutas, Saemon ne Iskariot natun. ");
INSERT INTO upv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Daron nga Jutas moka-la niv e, ko Demij kele esilvi vajin. Ko Iesu owrai tevi “Sev nga kumwera kuploli ngok, kuploli pingavil.” ");
INSERT INTO upv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nir nga marlik renge nanen, nir san sete orongwose rragrrag suri sev nga Iesu muwrai mirpel tevi. ");
INSERT INTO upv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Arrorrmi rreknga suri nga Jutas moksa narr ne nevöt, ko niko Iesu muwrai tevi pian puwli sev nga marmerreni renge nanen, rreknga pian p̃ila nevöt tevi b̃eres nir. ");
INSERT INTO upv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ko Jutas ela jile niv ko esil ivare evel. Natopong ko pa osuw. ");
INSERT INTO upv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jutas ean pa vare ko osuw, ko Iesu owra “Lelingen ngel evi daron nga parsurövi inu Jinibb Mawos, ko renge inu bosrövi Atua. ");
INSERT INTO upv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Poro nosrövien se Atua piplari renge inu, ko Atua kele puloli nosrövien se inu kele piplari luwi kele ji inu, ko puloli pirpok pivesane. ");
INSERT INTO upv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nanwarreng suk nir, sete numa-lik tevi kami mia-periv mun. Sete pipriv mun mian ko kapa-pej inu; ko erpe mowrai pa tevi m̃erwomu se kerr m̃eri Isrel nir, ko lelingen ngel nuwrai le vajin tevi kami: Lat nga bean e kami sete kamrongwos kapini rengen. ");
INSERT INTO upv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lelingen ngel b̃ela nale nesesreien nga mimerr tevi kami, ngel: Kami kapmerrmerreni kami. Pirpe nga inu memrreni kami, kami kele kaploli pirpok, kapmerrmerreni kami. ");
INSERT INTO upv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Poro kami kapmerrmerreni kami, ko ngok jinibb jijle parongwose ko nga kami kamivi jinibb suk nir.” ");
INSERT INTO upv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saemon Pita osusi tevi ni, “Kupan ngabe ko Numal?” Iesu owra lweni tevi ni, “Lat nga bean e, lelingen ngel setete kurongwose kupvijurik rengen; ko kupa-vijurik vitunen vajin.” ");
INSERT INTO upv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita owrai tevi, “Numal, suri sev setete nurongwos bevijurim lelingen ngel? Numarong lweni inu nga bemij surim.” ");
INSERT INTO upv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesu owra lweni tevi, owra “Ia, nik kuwretun ko wor, nik kumarong nga kupmij surik? Inu bowra weretunen vajin tevim. Nato setewor pukokrout ko wor ko nik kupvilvil orek pivatul, kupwera sete kurongwose inu.” ");
INSERT INTO upv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ko Iesu owrai tevir, “Sete kaploli nolo kami parkarkar; kaposuri Atua ko inu kele. ");
INSERT INTO upv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Renge naim se Tata, loloim nen nga markel ototi rengen owun saut. Poro sete pirpok, sete numa-werai le ngel tevi kami: Bean bololi lilane lat nga kami. ");
INSERT INTO upv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bean bololi lilane jile pusuw, ko bolwi kele vini b̃etkai kami, kaplik tevik renge lat nga m̃elik e. ");
INSERT INTO upv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ko kami kamrongwose sel nen nga bean e.” ");
INSERT INTO upv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas owrai tevi “Numal, sete namrongwose te lat nga kupan e, kem nabrongwose sel nen pirpese?” ");
INSERT INTO upv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ko Iesu owrai lweni tevi, “Inu nuvi batu sel, ko nuvi batu weretunen, ko nuvi batu mauren. Sete san orongwos p̃iasi nawon van ji Tata ejki, p̃ikali wor ji inu e ko. ");
INSERT INTO upv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Poro kaprongwose inu, ko kaprongwose kele Tata suk. Kamlesi pa ni osuw, ko lelingenok kamrongwose ni.” ");
INSERT INTO upv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip owrai tevi owra “Numal, kupviseni ta Tata som tevi kem, nga puloli kem nabrongwos alje vajin.” ");
INSERT INTO upv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu owrai tevi, “E, nuptevi kami bonevis le wor, ko ejki malum wor, kurrleng malume inu Pilip? M̃er nga m̃ilesi inu, ngok elesi pa Tata suk ko, ko suri sev nga kumwera “Kupviseni ta Tata som tevi kem”? ");
INSERT INTO upv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Sete kuosuri nga inu renge Tata suk ko Tata suk renge inu? Nale nga mowrair tevi kami, sete nuwrair renge derteren suk. Tata suk ko wor nga m̃ilik renge inu ololi majingen sen nir. ");
INSERT INTO upv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kaposuri inu nga inu renge Tata suk ko Tata suk renge inu. Ko poro kaplesi p̃iterter nga kaposuri iok, ko kaprrorrmi majingen nga mololir, ko kapa-osuri ko vajin. ");
INSERT INTO upv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nuwretun nga nuwretun nuwrai tevi kami, m̃er nga muosuri inu pia-loli majingen nga mololir, ko pia-loli nga wor marlelep nen jerjer, suri inu bolwi van ji Tata suk e. ");
INSERT INTO upv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Poro kapngoni isev san renge inu nisek, ko bea-loli ko, nga puloli nosrövien se Tata suk pia-viseni rrurrngi renge Natun. ");
INSERT INTO upv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nanu jijle ngok nir, poro kapngoni renge inu nisek, ko ngok bea-lolir ko.” ");
INSERT INTO upv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Poro kapmerreni inu, ko kaptori lilane nale nesesreien suk nir. ");
INSERT INTO upv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ko inu bea-ngoni tevi Tata nga ni pia-koni Nem̃in On vajin vini nga pok-wilwil se kami, ko pia-tekai kami tuwi ngok vini. ");
INSERT INTO upv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ni evi Nem̃in ne weretunen, ko sete jinibb ne iel ngatan arongwos parlai ni, suri sete arlesi ko sete arlesi wos kele e. Ko kami ma kamrongwose ni, suri elik livö renge kami, ko p̃ilik renge kami tetajer. ");
INSERT INTO upv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Setete b̃elinglingi kami kapsan te ejki, bolwi kele vini ji kami. ");
INSERT INTO upv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sete ngasu te, ko jinibb ne iel ngatan ngel nir setemun parlesik. Ko kami ma kaplesik; ko suri numaur, ko kami kele kapa-maur. ");
INSERT INTO upv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Renge nabong nen, kami kaprongwose nga inu renge Tata, ko kami renge inu, ko inu kele renge kami. ");
INSERT INTO upv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“M̃er nga mutori lilane nale nesesreien suk nir ko muosurir, ni evi m̃er nga mimrreni inu. Ko m̃er nga mimrreni inu, Tata suk pimrreni ni; ko inu kele bemrreni ni, ko inu bea-viseni inu tevi ni.” ");
INSERT INTO upv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jutas (sete Jutas ne Iskariot) owrai tevi ni, “Numal, kuploli pirpese nga kupviseni nik lweni tevi kem, ko sete tevi jinibb ne iel ngatan jijle nir?” ");
INSERT INTO upv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu owra lweni tevi, “Poro nga jinibb san pimrreni inu, ko ngok ni pia-tori lilane nale suk. Ko Tata suk pia-merreni ni, ko noborini jin, ko noborloli liken se komru tevi ni. ");
INSERT INTO upv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","M̃er nga sete mimrreni inu sete otori totoni nale nesesreien suk nir. Nale nga kamrunge ngok nir sete arivi suk, arivi se Tata suk nga mukoni inu. ");
INSERT INTO upv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Daron ngel nga m̃elik tevi kami malum e, ko nuwra nanu ngel nir tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nem̃in nga pok-wilwil se kami, Nem̃in On nga Tata pia-koni renge inu nisek, pia-visviseni kami e nanu jijle, puloli kami kaprrorrmi sweri lweni nanu nga mowrair pa tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Demat nga milep le m̃elai tevi kami, evi inu demat suk. Sete demat suk osorsan tevi demat ne iel ngatan. Sete kaprong karkare te, puloli nolo kami p̃isij, pijki, ko sete kapmetutu te. ");
INSERT INTO upv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kamrunge nuwrai tevi kami le ngel, ‘Inu bolwi le pa, ko bevini kele bbong ji kami ko.’ Poro kapmerrenik ko kap̃ir kobbong, suri nga bean ji Tata. Suri ni elep asi wore inu. ");
INSERT INTO upv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Inu nuwrai wowomue nanu ngel le nir tevi kami, mian ko vitunen para-pelari. Ko daron nga para-pelari e, ko kami kapa-osuri vajin. ");
INSERT INTO upv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Sete numa-rij periv tevi kami. Suri Demij, numal ne iel ngatan, otomori pivini. Derteren sen ejki rres nawone renge inu. ");
INSERT INTO upv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ko inu nuloli surie erpe wor Tata ko muwrai tevik, puloli nga jinibb ne iel ngatan parongwose nga inu numrreni Tata. Kapmera, kerr pivel vajin.” ");
INSERT INTO upv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Inu nuvi batu grep weretunen, ko Tata suk evi m̃er nga mimetmete. ");
INSERT INTO upv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ko seken jijle nir nga renge inu nga sete marwen nen nir, oktevei tutwenir arjikie. Ko okvasi vaseni seken nga marwen nen nir, ko ngok puloli sete parmelmelngir, ko parejal sisamis ma p̃irres, ko parwen lengleng. ");
INSERT INTO upv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ko ololi vaseni kami kamwokwok ko pa osuw renge nale nga mowrair tevi kami ngel nir. ");
INSERT INTO upv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ko kami kaplik renge inu, ko inu b̃elik renge kami. Erpe seken sete orongwose pisan piwen, orongwos bbonge piwen ko renge nga poro p̃ijipjipti malum renge durun. Ko ngok erpok ko renge kami, sete kamrongwos kapwen poro sete kaplik renge inu. ");
INSERT INTO upv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Inu nuvi batun, ko kami kamivi seken nir. Si nga m̃ilik renge inu, ko inu renge ni, pia-wen temijpal kele wor. Suri sete kamrongwos kaploli rragrrage nanu pisan poro nga inu bejkie kami. ");
INSERT INTO upv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Poro nga jinibb pisan sete p̃ilik renge inu, parwirr tweni ko wor erpe seken, ko pukurkur. Ko arser kortoni seken ngok nir ko arwirr tweni nir van renge nabb, ko arin. ");
INSERT INTO upv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ko poro nga kaplik renge inu, ko nale suk puto renge kami, ko ngok ko poro nga kapngoni sev nga kammerrenir, ko kaplair ko. ");
INSERT INTO upv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ko jinibb pilep parsurövi Atua Tata suk, suri kapla temijpale wenen. Ko renge sel ngel ko, kami kapivi jinibb suk nir. ");
INSERT INTO upv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Erpe Tata suk emrreni temijpale inu, ko inu numrreni kami; niko kami kaplik renge inu merrenien suk malum. ");
INSERT INTO upv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Poro nga kami kaptor lilane nale nesesreien suk nir, ko niko kaplik renge merrenien suk, pirpe nga inu motori lilane nale nesesreien se Tata suk nir, ko m̃elik renge merrenien sen. ");
INSERT INTO upv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Inu nuwrai nanu ngel nir tevi kami nga puloli neiren suk puto renge kami. Ko ngok puloli kami neiren se kami puwun saut. ");
INSERT INTO upv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ngel evi nale nesesreien suk: Kami kapmerrmerreni lululweni kami, pirpe nga inu memrreni kami. ");
INSERT INTO upv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Merrenien nga milep temijpal nga jinibb puloli tevi selen nir, evi nga p̃ilngilngi mauren sen, pimij p̃isrer. ");
INSERT INTO upv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kami kamivi selek, poro nga kaploli sev nir nga mowrair tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Inu setemun beveruse kami ‘jinibb ne majingen’. Suri jinibb ne majingen sete orongwose sev ko nga numal sen muloli. Inu beverus vajine kami ‘selek nir’. Suri nuwra nanu jijle nir nga mornger ji Tata tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kami sete kamtobbtobbue inu, inu ko ma nutobbtobbue kami. Ko nulngi kami nga kapan kapla wenen pilep, wenen nen nga puto tuwi ngok vini. Ko ngok niko, isev nga poro kapngoni renge inu nisek van ji Tata suk, ni pia-lai ko tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ngel le evi nanu nga bowrai tevi kami: Kami kapmerrmerreni lululweni kami. ");
INSERT INTO upv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Poro nga jinibb ne iel ngatan nir parungasi kami, ko kami kaprongwose nga arungasi womue inu ko pa, vitunen ko mara-ungasi kami vajin. ");
INSERT INTO upv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Poro kami kapivi se iel ngatan, ko jinibb ne iel ngatan parmerreni kami ko, suri kamivi sen. Ko ejki, inu nutobbtobbue kami renge iel ngatan. Kami sete kamivi sen. Suri iok ko niko mungasi kami suri. ");
INSERT INTO upv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kaprrorrmi nale nga inu mowrai pa tevi kami: Sete jinibb ne majingen elep asie numal sen. Poro parloli p̃isij tevi inu, ko parloli p̃isij kele kobbong tevi kami; ko poro partori nale suk nga mowrair, ko partori kele bbong nale se kami ko nir. ");
INSERT INTO upv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ko parloli nanu ngel ko nir tevi kami suri kami kamivi jinibb suk nir, suri nir sete arongwose m̃er nga mukoni inu vini. ");
INSERT INTO upv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Poro nga inu sete bevini ko bowra nanu tevir, ko niko sete arongwose paron ko renge nololien ser. Ko lelingen ngel sete arongwose parkerkerise parwera nawone nanu san suri nololien ser, suri m̃ejiljilwer pa tevir, ko arongwos pae osuw. ");
INSERT INTO upv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","M̃er nga mungasi inu, ngok ongasi Tata suk kele ko. ");
INSERT INTO upv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ko poro nga sete bololi majingen nga jinibb san setewor muloli ko renge livö renge nir, ko ngok ko sete arongwose paron ko renge nololien ser suri. Ko ejki, arlesi pa nanu nga mololir, ko arungasi wor komru korti, inu ko Tata suk. ");
INSERT INTO upv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ngel evi nga puloli nale nga maruli renge nesesreien ser piplari, nga muwra ‘Arungasi nawon bbonge inu, inu sete nuloli rragrrag nanu nga m̃isij san.’ ");
INSERT INTO upv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nem̃in nga mokla ser pivini, Nem̃in ne weretunen, nga pia-ivel ji Tata vini. Inu bea-koni ji Tata pia-vini ji kami, ko ni pia-rij se inu. ");
INSERT INTO upv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ko kami kele kapa-rij se inu, suri nga kami kamlik tevik renge nga m̃etipatune m̃emajing wowomu jer, mijpari lelingen ngel. ");
INSERT INTO upv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nuwra nanu ngel nir nga puloli kami sete kapvitan te, pijki. ");
INSERT INTO upv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jinibb nir parwirr tweni kami renge naim gortien ser. Ko daron nen pia-vini nga jinibb parevji pini kami, ko jinibb nga marevji pini kami nir, parrorrmi arloli majingen se Atua ko. ");
INSERT INTO upv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Parloli nanu ngel nir tevi kami suri nga sete arongwose komru korti, Tata ko inu. ");
INSERT INTO upv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nuwra wowomu pae nanu ngel le nir tevi kami ngel. Poro nga daron nen pia-vini vajin nga para-loli nanu nga ngel nir tevi kami, ko ngok, kami kaprrorrmi sweri nga nuwrai pa tevi kami osuw.” “Sete nuwra wowomue nanu ngel nir tevi kami renge bonevis pa, suri inu m̃elik tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ko lelingen ngel, bevel le pa, bolwi van ji ni nga mukoni inu e. Ko kami san sete osusi tevik “Kupan ngabe ko?” ");
INSERT INTO upv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ko mowrai tevi kami nga bevel lingi kami, ko nolo kami arrum suri. ");
INSERT INTO upv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ko nuwra weretunen ko tevi kami, ngok pia-ivi nanu nga m̃irres renge kami; suri poro sete bevel, ko Nem̃in nga mok-la ser sete orongwos pivini ko. Ko poro bolwi ko van, ko bokoni Nem̃in On ko vini ji kami. ");
INSERT INTO upv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ko daron nga pivini e, ko pia-wowrai jinibb ne iel ngatan nir nga marsarr renge nololien, ko pia-wowrai suri sev nga mumomsawos, ko sev nga sete mumomsawos nga Atua pia-wer lokloksi jinibb suri. ");
INSERT INTO upv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nir arsarr renge nololien, suri nga sete marosuri inu. ");
INSERT INTO upv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ko arsarr renge inu m̃er nga mololi mumomsawos m̃irres, suri inu bean ji Tata e, ko kami sete kaplesi kele mun inu. ");
INSERT INTO upv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ko arsarr renge erpese nga Atua pia-wer lokloksi jinibb suri, suri sete arongwose nga Atua ewer lokloksi jile pa Demij nga mivi m̃erwomu ne iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nanu elep malum wor nga moro bowrai tevi kami, ko ejki mun, lelingen ngel setemun kamviter kaprongwos nir. ");
INSERT INTO upv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ko daron nga Nem̃in ne weretunen vajin pia-vini, ko pia-wowomue kami van renge weretunen jile nir. Ni sete pia-wera nawone nale pisan, ejki rres. Ni puwra bbong nanu nga murnger kis ko, ko puwowra nanu nga para-vini nir tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ni pusrövi inu, suri pia-la nanu nga marivi suk nir, ko ni pia-werwerai twenir tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nanu jile nga marivi se Tata arivi suk; ngok ko ololi nga inu mowrai Nem̃in pia-la nanu nga marivi suk nir, ko pia-werwerair tevi kami vajin.” ");
INSERT INTO upv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ko Iesu owrai kele tevir, owra “Beblen welili kele ma, ko sete kaplesi mun inu; mian ko beblen welili kele ma vitunen renge ngok, ko kapa-lesi kele inu.” ");
INSERT INTO upv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jinibb sen sopor arwerai tevi nir sopor nen, “Owra sev le san nga muwrai mirpok ngok tevi kerr, ‘Beblen welili kele ma, ko setemun kaplesi inu, mian ko beblen welili kele ma vitunen renge ngok, ko kapa-lesi kele inu’, ko, ‘Suri nga inu bean ji Tata’?” ");
INSERT INTO upv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ko jinibb sen nir arsususi lululweni tevi nir: “Owra sev le san nga muwra ‘Beblen welili’? Sete rramrongwose owra sev ko.” ");
INSERT INTO upv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu orongwose nga armerreni parsusi tevi ni, ko owrai tevir, “Inu mowra ‘Beblen welili kele ma ko setemun kaplesi inu, mian ko beblen welili kele ma vitunen renge iok, ko kapa-lesi kele inu’. Ngok ko, kamok-susi lululweni kami ngok e. ");
INSERT INTO upv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nuwretun nga nuwretun nuwrai tevi kami, kapkail kapting, suwen mete kami pujumjum; ko jinibb ne iel ngatan nir parir, ko kami nolo kami parrum. Ko mian ko nolo kami nga marrum ngok parienir van renge neiren. ");
INSERT INTO upv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Daron nga nesevin mutomori puwosi bipi sen, ko nolon orrum, suri daron sen evini nga puwosi bipi. Ko daron nga nesevin muwosi jile bipi, ko emalie norongen nga m̃isij sen vajin, suri bipi eak pa iel ngatan osuw. ");
INSERT INTO upv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kami kamirpok ko lelingen ngel, nolo kami arrum. Ko bea-lesi kele kami, ko nolo kami puwun saute neiren. Neiren nen, setemun jinibb san orongwos p̃ilai tweni mun ji kami. ");
INSERT INTO upv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Renge nabong nen, setemun kama-susi rongornge nanu san tevik. Nuwretun nga nuwretun nuwrai tevi kami, poro nga kapngoni nanu san tevi Tata suk renge inu nisek, kapngoni, ko ni pia-lai ko tevi kami. ");
INSERT INTO upv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mijpari lelingen ngel, kami setewor kamngoni nanu san renge inu nisek; kapngoni vajin ko kaplai, nga puloli neiren se kami puwun saut.” ");
INSERT INTO upv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nuwra nanu ngel nir tevi kami renge nale rrongrrongvi nir. Ko daron nen pia-vini nga inu setemun b̃ela nale rrongrrongvi, pijki, ko bowra momsawos Tata vajin tevi kami renge nale momsawos nir. ");
INSERT INTO upv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nabong nen pia-vini ko kami kapngoni ni renge inu nisek. Sete nuwra inu bean se kami bongoni nanu san jin se kami, ejki. Kami ko wor kapan mawos ji Tata, ");
INSERT INTO upv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","suri Tata ni lweni emrreni kami. Ni emrreni kami suri kami kammerreni inu, ko kamosuri nga inu nuvel ji Atua vini. ");
INSERT INTO upv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Inu nuvel ji Tata vini iel ngatan. Ko lelingen ngel, bevel lingi iel ngatan ko bolwi van ji Tata e.” ");
INSERT INTO upv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jinibb sen nir arwerai tevi ni, “Ngok kulesi, kuwra momsawose vajin, setemun kuwrai renge nale rrongrrongvi. ");
INSERT INTO upv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kem namrongwose vajin nga nik kurongwose nanu jijle. Kurongwos kupsupsup̃e nanu p̃etp̃eti nir, tevi nanu nir nga setewor san mususi tevim. Ngel ololi nga kem namosuri nga nik kuel ji Atua vini.” ");
INSERT INTO upv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ko Iesu owrai lweni tevir, “Kamosuri vajin lelingen ngel? ");
INSERT INTO upv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mete nial nen evini, ejpari pa ngel, nga kami jijle kapwolu sisamis van renge ngaim se kami e. Ko inu b̃esansan bbölbböl botur jer. Ko weretunen sete nusan, suri Tata eptevik. ");
INSERT INTO upv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Inu nuwra pa nanu ngel tevi kami, nga puloli kami kapkorti renge inu, ko kapla demat. Iel ngatan puloli kami kaprunge p̃isij; ko sete kapmetutu, inu nuasie pa nanu ne iel ngatan ngok nir jijle.” ");
INSERT INTO upv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Daron nga Iesu muwra jile nale ngel e nir, ko oklu imare emteni melrin, ko olot owra “Tata, mete nial nen evini. Kupsurövi natum, ko inu bosrövi nik. ");
INSERT INTO upv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kula derteren tevik nga inu nuterter evter nga bololi sev nga memrreni tevi jinibb p̃etp̃eti nir. Ko ngok nurongwos b̃elai mauren nga muto tuwi ngok vini tevi jinibb jijle nga kumlair tevik. ");
INSERT INTO upv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nanu ngel le evi mauren nga muto tuwi ngok vini, nga jinibb parongwose nik kumsansan kumivi Atua weretunen, ko parongwose Iesu Kristo nga nik kumkoni vini iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inu nusrövi nik renge iel ngatan, nuloli jijle majingen nga kumlair tevik nga bololir. ");
INSERT INTO upv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Lelingen ngel vajin Tata, kupsurövi inu renge nik nom renge nosrövien nga tuwi mivi suk, renge daron nga m̃elik tevi nik e womu mian ko vitunen vajin kuma-loli iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Inu nuwra visviseni nik nisem tevi jinibb ne iel ngatan nir nga nik kumla twenir marivi som, ko kumlair tevik vajin, ko nir arosuri nale som. ");
INSERT INTO upv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lelingen ngel nir arongwose vajin nga nanu jile nga kumlair tevik arivel jim vini. ");
INSERT INTO upv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Suri nale som nir nga kumlair tevik, inu nulair tevir. Ko nir arlair, ko nir arongwose vajin nga weretunen nga inu nuvel jim vini. Ko arosuri nga nik kukoni inu. ");
INSERT INTO upv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Inu nomok-lot suri nir; inu sete nomok-lot suri jinibb ne iel ngatan nir te ejki; nomok-lot suri bbong nir nga kumlair ko tevik, suri arivi som. ");
INSERT INTO upv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nir jile nga marivi suk arivi som kele, ko nir nga marivi som arivi suk. Nosrövien suk nir ko arviseni eplari. ");
INSERT INTO upv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lelingen ngel inu bevinuk pa jim e le, setemun numa-lik iel ngatan; ko nir ma parlik jer iel ngatan. Tata nga muon, kupmetmet nir nga kumlair tevik renge derteren ne nik nisem, nga nir parivi pisansan, pirpe nga kerru sansan. ");
INSERT INTO upv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Daron nga m̃elik tevi nir nga kumlair tevik, numetmet nir renge derteren ne nik nisem. Numetmet lilane nir erres, sete nir san ejijki te; sansan kobbong, nga ni pirpok ko wor, ni kobbong ejijki, nga puloli nale nga muto renge Naul On piplari. ");
INSERT INTO upv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lelingen ngel inu bolwi le pa bevinuk jim e, ko nuwra nanu ngel nir tevir renge daron nga inu m̃elik ngatan malum le. Ngok puloli nir parla neiren suk renge nolor parwun saute. ");
INSERT INTO upv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Inu nula nale som tevir; ko jinibb ne iel ngatan nir arungasir, suri nir sete arivi ne iel ngatan, arsorsan tevi inu sete mevi ne iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Inu sete nungoni nik nga kupla twenir renge iel ngatan, pijki. Nungoni nik ma nga kuptor orer, parasi renge Demij nga m̃isij. ");
INSERT INTO upv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nir sete arivi ne iel ngatan, arirpe inu sete mevi ne iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kuplingi taleve nir, kuplolir paron renge weretunen som. Nale som evi weretunen. ");
INSERT INTO upv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Erpe nga nik kumkoni inu vini iel ngatan, ko inu kele nukoni nir van renge iel ngatan. ");
INSERT INTO upv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Inu nulngi taleve inu lweni nuon, nga puloli nir kele parlik talev, ko paron renge weretunen. ");
INSERT INTO upv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Inu sete nulot suri nir kis kobbong, ko nulot suri kele wor nir nga para-osuri kele inu vitunen suri nale se jinibb suk ngel nir. ");
INSERT INTO upv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Inu nulot suri nir, nga parivi pisansan e, pirpe nik Tata renge inu, ko inu renge nik. Ngok pirpok ko, nir kele renge kerru, puloli nga jinibb ne iel ngatan nir parlesi wose inu nga nik kumkoni inu. ");
INSERT INTO upv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nosrövien nga kumlai tevik, nulai pa tevir nga nir parivi pisansan pirpe kerru rromorivi sansan. ");
INSERT INTO upv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inu renge nir, ko nik renge inu, ngok puloli nir parivi pisansan mawos, nga puloli jinibb ne iel ngatan nir parongwose nga nik kukoni inu, ko kumrreni nir osorsan tevi kumrreni inu. ");
INSERT INTO upv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, numrreni nga nir nga kumlair tevik parlik tevik kele renge lat nga b̃elik e, nga parlesi inu nosrövien suk nga kumlai tevik. Suri nik kumrreni womu inu, vitunen ko iel ngatan ngel mia-toe. ");
INSERT INTO upv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O, Tata nga mumomsawos, jinibb ne iel ngatan nir sete arongwose nik, ko inu ma nurongwose nik; ko nir ngel kele arongwose nga nik kumkoni inu. ");
INSERT INTO upv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nomok-wera visviseni pa nik tevi nir, ko nir arongwos vajine. Ko bololi malume pirpok, nga puloli merrenien nga kummerreni inu e puto renge nir, ko inu kele renge nir.” ");
INSERT INTO upv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Vitunen renge Iesu mulot jile muwra nale ngel nir, ko eptevi jinibb sen nir arivare renge Jerusalem, arivel otvi b̃elai nuwi ne Kitron. Ko aran renge lut san nga mivi lolnai olip. ");
INSERT INTO upv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jutas nga p̃itkai kerasi ni orongwose lat nen, suri Iesu tetajer ok-korti tevi jinibb sen nir ie. ");
INSERT INTO upv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ko Jutas eptevi jinibb ne nuval sopor ne Rom ko jinibb ne nuval kele sopor nga marmetmete Naim On, nga Parasi nir ko batu jinibb ne sulsulen nir markonir. Artur korti evi meling jinibb nga milep ne nuval san. Artori laet ko nasul ko nijor ne nuval nir, ko arivel mawos ie. ");
INSERT INTO upv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ko Iesu orongwose sev nga piplari renge ni; ko evel mawose nir van womue ko osusi tevir, owra “Kampej isi ko?” ");
INSERT INTO upv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nir arwera lweni tevi ni, “Iesu ne donasret.” Ko Iesu owra lweni tevir, “Ko inu le ngel.” Ko renge ie Jutas nga m̃itkai kerasi ni otur tevir, ko ornge nale nga marwerai. ");
INSERT INTO upv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Renge daron nga Iesu moka-werai tevir mirpok e, “Inu le ngel”, ko nir arivel durer ko arwajenir van ngatan renge dan. ");
INSERT INTO upv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ko Iesu osusi lweni kele tevir, “Kampej isi le?” Ko nir arwera “Nampej Iesu ne donasret.” ");
INSERT INTO upv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu owrai tevir, “Nuwra jile pa tevi kami osuw, ‘Inu le ngel’. Poro nga kampej inu ko, ko kaplinglingi jinibb ngel nir parivel.” ");
INSERT INTO upv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Owrai erpel nga puloli nale sen nga muwrai piplari, ‘Tata, sete nutor jabble nir san nga kumlair tevik ejijki.’ ");
INSERT INTO upv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ko Saemon Pita etatuwe nesip nuval san, ko ervei tweni ko owun owra p̃ita pini demij maur se batu jinibb ne sulsulen. Ko eta jabble, ko esipri otvi boron rres evesane. Demij maur nen nisen ko Malkas. ");
INSERT INTO upv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ko Iesu owrai tevi Pita, owra “Pijki! Kuplingi lweni nesip nuval som renge milngen. Tata suk ko owra p̃ila norongen nga m̃isij ngel tevik. Kurrorrmi sete erres nga botor totoni nolok p̃iterter ren nga ban ren?” ");
INSERT INTO upv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Meling jinibb nga milep ne nuval nen nir arrul totoni Iesu ko arsere totoni nevren ko arile. ");
INSERT INTO upv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Womujnen arpitevi womue van ji Annas, suri ni evi p̃ile Kaeapas, nga mivi batu jinibb ne sulsulen renge sia nen. ");
INSERT INTO upv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaeapas nen ko muwrai tevi m̃eri Isrel nir nga ‘Evi nanu nga m̃irres nga jinibb pisansan pimij suri delung nir.’ ");
INSERT INTO upv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saemon Pita ko jinibb m̃inij se Iesu kele san orvijuri suri Iesu tevi meling jinibb nga marile. Ko nuru tuwen nen eptevi Iesu oran renge lolo naworr ne naim se batu jinibb ne sulsulen e, suri m̃ernen batu jinibb ne sulsulen orongwose erres p̃elak. ");
INSERT INTO upv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ko Pita otur jer renge metali vare e. Ko jinibb se Iesu tuwen nen olwi van ko ongoni tevi nesenwarreng nga mok-tur metmete metali nga ni p̃iasi van vare e, piptevi Pita p̃iasi vini live laut ne naworr e. ");
INSERT INTO upv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ko daron nga nesenwarreng nen moka-lesi Pita, ko owrai tevi, “Rrek nik kele kuvi jinibb se m̃er nga ngelan san.” Ko Pita owra “Inu? Ejki, sete nuvi san.” ");
INSERT INTO upv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nata mupong nen melas elep, ko jinibb ne majingen nir ko jinibb ne nuval nir arser kortoni bevla nir. Ko arsurer ko artur rrale ko artetli rengen. Ko Pita evan lat nen jir, ko otur tevir etetli. ");
INSERT INTO upv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ko renge loloim batu jinibb ne sulsulen osusi rongornge tevi Iesu, owra purongwose suri jinibb sen nir ko nevisvisenien sen. ");
INSERT INTO upv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ko Iesu owra lweni tevi, “Tetajer inu nomok-wera nanu nir tevi jinibb jijle nir renge limjer. Nevisvisenien suk nomok-lolir renge naim gortien nir ko renge Naim On, lat nga m̃eri Isrel jijle marok-ini korti rengen. Inu sete nomok-wera silveni rragrrage nanu san, ejki. ");
INSERT INTO upv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Sete osorsan renge nale nesesreien se kerr nga nik kupsusi rongornge tevi inu. Kupsusi tevi ta delung nir nga marok-runge inu. Nir arongwose nanu nga mowrair.” ");
INSERT INTO upv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Daron nga Iesu muwra nanu ngel e, ko san renge jinibb nuval nir owje, ko owrai tevi, “Erpe kumrij mirpel tevi batu jinibb ne sulsulen nga mian mare! Sete arok-rij erpok.” ");
INSERT INTO upv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ko Iesu owra lweni tevi m̃ernen, “Poro inu nuwra nawone nanu san sete emawos, ko kupwera tweni lut nga mowrai sarrsarre. Ko poro nga nanu nga mowrai omomsawos, ko suri sev kumwujek?” ");
INSERT INTO upv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mian ko Annas okoni tweni Iesu van ji Kaeapas, batu jinibb ne sulsulen. Ko dil nga marsere Iesu nevren e oto malum ren. ");
INSERT INTO upv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saemon Pita otur malum renge lat nga ko etetli. Ko nir sopor nga martur martetli tevi arwerai tevi, “Nik kuvi jinibb se morok san.” Ko Pita evilvil ore kele, owra “Ejki ma, inu sete nuvi jinibb sen san!” ");
INSERT INTO upv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","San renge jinibb ne majingen se batu jinibb ne sulsulen, nga mivi metka se m̃er nga Pita misipri otvi boron, owra “Sete nik ko, m̃elesim kumpitevi ni renge lolnai ne olip?” ");
INSERT INTO upv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ko Pita evilvil ore kele, owra “Ejki ma!” Ko renge daron mawos ngok ko pa, nato okokrout. ");
INSERT INTO upv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nir arpitevi tweni Iesu renge naim se Kaeapas van renge naim nga milep se Paelat, nga mivi m̃eri Rom nen nga mivi batu gavman iok. Evi rorpong susu malum. M̃eri Isrel nir sete aran renge naim se Paelat te ejki, suri ni evi m̃eri Rom, ko poro paran ko ngok parrokitkit ko, ko sete parongwos parurroi nanen ne asien. ");
INSERT INTO upv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ko niko Paelat eivare evini jir, ko osusi tevir owra “Sev ko kamlesi esij re m̃erel nga muloli kamrevei vini iel e jik?” ");
INSERT INTO upv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ko nir arwera lweni tevi ni, arwera “Po, ko poro m̃erel sete puloli majingen nga parsij, ko setete nama-pitevi ni vini!” ");
INSERT INTO upv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paelat owra lweni tevir, “Kappitevi tweni, ko kami ko kapwera suri lat nga puto suri rengen renge nale nesesreien se kami.” M̃eri Isrel nga marwowomu nir arwera lweni, “Ko kami ko m̃eri Rom nir kamwer ore nga sete namrongwos nabtor pini jinibb san!” ");
INSERT INTO upv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nanu ngel eplari nga puloli nale se Iesu nga muwrai piplari, nga muwra suri mijen sev nga ni pia-mij rengen. ");
INSERT INTO upv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ko Paelat olwi van loloim e, ko everuse Iesu pivini jin. Ko Iesu evini jin, ko Paelat osusi tevi ni, “Ia, ewretun nik kuvi numal se m̃eri Isrel nir?” ");
INSERT INTO upv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ko Iesu owra lweni tevi, “Kususi rongornge erpok suri nik kobbong norrorrmien som, rreknga sopor arsup̃e suri inu tevi nik?” ");
INSERT INTO upv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paelat owra lweni tevi ni, “Po, kurrorrmi inu nuvi m̃eri Isrel rrek? Nik luwi ko wor jinibb som nir ko batu jinibb ne sulsulen nir artekai nik vini jik. Nik kuloli sev?” ");
INSERT INTO upv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu owra lweni tevi, “Inu batun vanu suk sete evi ne iel ngatan. Poro nga bevi numal ne batun vanu san ne iel ngatan, ko jinibb suk nir parpalpal ore inu ko, nga sete mara-tekaik vini renge nevre m̃erwomu se m̃eri Isrel nir. Ko niko inu batun vanu suk sete evi ne iel ngatan.” ");
INSERT INTO upv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ko Paelat osusi kele tevi ni, “Ia, ko ewretun ko wor nik kuvi Numal san?” Ko Iesu owra lweni tevi, “Kuwretun re kumwerai, ko rrek sete kurongwos suri nuvi numal nga mirpese san. Inu mevini iel ngatan m̃eak suri bbong majingen sansan, nga bosp̃e suri weretunen. Isi nga mivi jinibb ne weretunen pumurronge inu drrelak.” ");
INSERT INTO upv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ko Paelat osusi tevi, “Isev ko weretunen?” Ko Paelat muwrai mirpok jile tevi Iesu, ko eivare olwi van ji m̃eri Isrel e nir. Ko owrai tevir, “Inu sete nulesi nanu nga m̃isij rragrrag san renge ni. ");
INSERT INTO upv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ko nanu san. Evi pa murrun se kami nga re sia jijle re daron ne nanen ne asien, inu bemaronge jinibb nga m̃ilik renge naim ne nekaien san nga kammerreni pivel sisarow. Ko ngok kami kammarong nga inu bemaronge Numal se m̃eri Isrel nir pivel sisarow?” ");
INSERT INTO upv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ko nir arkail lengleng arwera “Ejki rres nawon, kem sete nammerreni m̃erel! Kem nammerreni Barapas.” Ko Barapas nen evi m̃er nga mivi jinibb venao, ko mok-revrevji pinpini jinibb. ");
INSERT INTO upv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ko Paelat ela Iesu tevi jinibb nuval nir, ko arvirrvirrali. ");
INSERT INTO upv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ko jinibb nuval nir arla dil moku ko arjali erpe nuvan se Numal san, ko arlingi renge batun ori. Ko arla sunsun nga musongsong mupongpong m̃irres ko arloli ori. ");
INSERT INTO upv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ko armomori jin ko arkerkerasi, arwerai tevi “Nik kuplik pipriv, Numal se m̃eri Isrel nir!” Ko arwuje non. ");
INSERT INTO upv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ko Paelat eivare kele vini ji delung nir ko owrai tevir, “Kaplesi, beptei tweni le pa vini vare e ji kami, ko kaprongwos mae nga inu sete nutor sweri nanu nga m̃isij san renge ni nga puloli inu bosp̃e suri ni rengen, ejki.” ");
INSERT INTO upv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ko Iesu eivare vini vare e, ori nuvan nen nga marjali renge dil moku mirpe nuvan se numal san, ko ori sunsun nga musongsong. Ko Paelat owrai tevir, “Niko m̃ernen le ngel.” ");
INSERT INTO upv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ko daron nga batu jinibb ne sulsulen nir ko jinibb nuval nir marlesi ko arkail mare, arwera “Kuprruloni ni renge nai pelaot! Kuprruloni ni renge nai pelaot!” Ko Paelet owrai tevir, “Kaptekai ni kapiel tevi, ko kami vajin kaprruloni renge nai pelaot. Inu sete nulesi on renge nanu san nga bosp̃e suri ni rengen.” ");
INSERT INTO upv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","M̃eri Isrel nir arwera lweni tevi Paelet, arwera “Kem nesesreien se kem otoe, ko nesesreien nen owrai ni orongwos pimij ko wor! Suri ni lweni elngi ni evi Atua natun.” ");
INSERT INTO upv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Daron nga Paelat murnge mirpel, ko ni ea-metutu lengleng kele e ko. ");
INSERT INTO upv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ko olwi van renge loloim sen kele e, ko osusi tevi Iesu, “Nik kuvi m̃eri ngabe le?” Ko Iesu sete owra lweni nanu san tevi ni. ");
INSERT INTO upv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ko Paelat owrai kele tevi ni, “Sete kuma-wera nanu san tevik? Sete kurongwose nga inu derteren suk otoe nga bololi nik kupiel sisarow, ko borruloni nik renge nai pelaot?” ");
INSERT INTO upv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ko Iesu owrai tevi, “Nik derteren som easi inu suri Atua kobbong elai tevi nik. Ko m̃er nga m̃ilai inu vini jim, ni ko ma on renge nololien nga m̃isij p̃erp̃er milep.” ");
INSERT INTO upv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ko daron nga Paelat murnge nale ngel, ko epejpej sel kele san nga puloli Iesu pivel sisarow rengen. Ko m̃eri Isrel nir arkail van jin: “Poro kuploli ni pivel sisarow, ngok eviseni nga nik sete kuvi sele Sisa. Si nga m̃ilngi ni lweni mivi numal, ni evi devje nuval se Sisa ko vajin!” ");
INSERT INTO upv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ko daron nga Paelat murnge nale ngel e nir, ko olwi van loloim e, ko etkai tweni Iesu eivare, ko ean re lat san nga martuwe mivi nawot (nga nale se m̃eri Isrel nir marwera nisen Gapata e), ko esakel renge nai seksakel nga mok-sakel ren daron nga mok-wera suri lat nga puto suri tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Evi levial vajin renge nabong nga pareseser tera nanen ne asien e, mete nial esngavöl drromon eru; ko Paelat owrai tevi m̃eri Isrel nir owra “Ni le, Numal se kami!” ");
INSERT INTO upv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ko nir arkail van mare arwera “Kuppitei tweni, kuppitei tweni, kuprevji pini renge nai pelaot!” Paelat owrai tevi nir, “Erpe, kami kammerreni inu berevji pini numal se kami renge nai pelaot?” Ko batu jinibb ne sulsulen nir arwera “Numal se kem ejki ko ngok, Sisa ko ma!” ");
INSERT INTO upv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ko Paelat elinglingi Iesu tevi nir vajin, parevji ko parruloni renge nai pelaot. ");
INSERT INTO upv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ko arpitei tweni Iesu evel, owosi nai pelaot sen van renge botwen san nga marveruse nisen miwaji bongur (renge nale se m̃eri Isrel nir arveruse Kolkota). ");
INSERT INTO upv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nir arruloni ni iok renge nai pelaot; ko nuru eru kele orpitevi, san renge devjen rres ko san renge devjen mair, ko Iesu renge liven. ");
INSERT INTO upv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paelat oli nale sopor, ko elngi renge nai pelaot se Iesu. Areve erpel, ‘Iesu ne donasret Numal se m̃eri Isrel nir.’ ");
INSERT INTO upv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ko m̃eri Isrel elep areve nale nen, suri lat nga marruloni Iesu ren oto mori Jerusalem bbong. Aruli nale ngok renge nale se m̃eri Isrel nir, ko nale se m̃eri Rom nir, ko nale se m̃eri Gris nir. ");
INSERT INTO upv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ko batu jinibb ne sulsulen se m̃eri Isrel nir arwerai tevi Paelat, “Sete kupuli ‘Numal se m̃eri Isrel nir’ pijki, ko kupuli pirpel: ‘M̃erel owra Inu Numal se m̃eri Isrel nir’.” ");
INSERT INTO upv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ko Paelat owra lweni tevir, “Sev nga moli pa puto ko pa pirpe nga moli.” ");
INSERT INTO upv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Vitunen renge jinibb nuval marruloni jile Iesu renge nai pelaot, ko arla joron nir ko artutweni sisamise nir. Arlingi meling ivij e, evsese jinibb nuval nen nir ivij. Ko arla kele sunsun nga mok-uri ore womu niben e, ko arlesi nga marloli mivi pa sansane ko. ");
INSERT INTO upv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ko jinibb nuval arwerwera lululweni tevi nir, “Sete rraprrerrsi te, pijki. Kerr putuw daes suri.” Ngel puloli nale nga Naul On muwrai piplari, ‘Ko nir arlai tweni jorok ko artututwenir e, ko artuw daes nga parlesi si p̃ilai sunsun suk’. Ngok jinibb nuval nir arloli surie erpok. ");
INSERT INTO upv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ko mori bbonge nai pelaot sopon, Iesu tasu sen ko tasu sen tuwan, ko Merri nga nesen se Klopas, ko Merri nesen Maktala, artur. ");
INSERT INTO upv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ko Iesu emteni tasu sen ko jinibb sen nga ni mimrreni temijpale mortur, ko owrai tevi tasu sen, “Ngok evi natum.” ");
INSERT INTO upv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mian ko owrai kele tevi jinibb sen nga ni mimrreni temijpale, “Ngok evi tasu som.” Ko etipatun re daron nen, ko m̃ernen emetmete erres renge naim sen. ");
INSERT INTO upv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesu orongwose nga lelingen ngel nanu jijle arsuw jerjer pa, ko owra (nga puloli Naul On piplari) “Nolok emesmes.” ");
INSERT INTO upv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Besin san oto iok, owun saute norro nga mimilali. Ko ngok arla nalum san ko arrurrngoni rengen, ko arlingi renge mavir san, ko arsareni van renge nevlu jingon nuru. ");
INSERT INTO upv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ko Iesu orromji lesi norro nen beblen, ko owra “Osuw jerjer vajin.” Ko etmarru vitan ko emij. ");
INSERT INTO upv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","M̃erwomu se m̃eri Isrel nir arngoni tevi Paelat nga pimarong parbburi b̃ela jinibb nen nir, puloli parmij e, ko parjuri twenir renge nai pelaot nir. Arwera parloli pirpel suri evi Praete, ko sete armerreni niber parrul jipari nabong ne Sapat. Sapat nen evi Sapat nga muon milep, suri evi Sapat ne nanen ne asien. ");
INSERT INTO upv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Niko jinibb nuval nen nir arini ko arbburi luwe m̃er nga murrul tevi Iesu tuwen b̃elan, musuw ko aran kele arbburi kele nuru tuwen kele b̃elan. ");
INSERT INTO upv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ko daron nga marini ji Iesu vajin, ko arlesi nga emij pa osuw, ko nir setemun arbburi ni b̃elan. ");
INSERT INTO upv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ngok nir san renge jinibb nuval ela sir sen ko ouni renge neli Iesu. Ko drra ko nuwi orseser pelari orvesane. ");
INSERT INTO upv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","San le ngel elesi nga mirpok, ko owrai erpok ko. Orongwose nga ni ok-wera weretunen, ko owra ‘Sev nga nomok-werair ewretun. Kami kele kaposuri.’ ");
INSERT INTO upv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nanu ngel nir arpelari nga nale san nga muto renge Naul On pivini piplari, nga muwra ‘Sete jin san pia-mabbur.’ ");
INSERT INTO upv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ko nale kele san renge Naul On owra ‘Parmeteni ni nga jinibb maruni sir rengen.’ ");
INSERT INTO upv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Vitunen renge nanu ngel, Josep, nga mivi m̃eri Armetia, ongoni tevi Paelat nga poro orongwos puwosi tweni nibe Iesu. (Josep evi jinibb se Iesu ko pa san, ko okvilvil ore, suri emtutue m̃erwomu se m̃eri Isrel nir nga martori derteren renge nir.) Ko Paelat elinglingi tevi ni. Ko evan owosi tweni nibe Iesu. ");
INSERT INTO upv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ko Nikotemas, nga bonevis mivini ji Iesu nat nga mupong, eptevi Josep, nuru oran. Ni ela senta nga nowlin mivi nevöt ongut vesan nga markisie mir ko alos, otori tevi ni. ");
INSERT INTO upv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nuru orwosi nibe Iesu ko ornub̃e sunsun nga mimalum e m̃irres tevi mir ko alos nga. M̃eri Isrel nir lat nga marok-loli surie ko erpok. ");
INSERT INTO upv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mori iok lat nga marruloni Iesu rengen, orsel ne lolnai ne olip san oto mori bbonge. Ko renge lolnai ne olip ngok nevöt b̃ereng san nga Josep m̃itai nolon mutoe oto rengen, nga sete arlingi rrongvi wor jinibb nga mimij san rengen. ");
INSERT INTO upv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ko suri evi pa nabong se m̃eri Isrel nir nga marok-eseser rengen ko mevinen pivi nabong nga milep ser, ko lolo b̃ereng nen mori bbong ie, ko orwosi Iesu orlingi rengen. ");
INSERT INTO upv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Daron nga Sapat ser m̃iasi vajin, renge Sante rorpong susu nat murrorrorr malum, Merri ne Maktala emremra van renge dubb. Ko elesi nevöt nga muto ore nolo b̃ereng mijkie, arla tweni pa. ");
INSERT INTO upv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ko nesevin owlu luwi van ji Saemon Pita e nuru jinibb se Iesu m̃inij nen nga Iesu mimrreni nen. Ko owrai tevi nuru, “O laru, arwosi tweni Numal renge dubb, ko sete rramrongwose lat nga marlingi e!” ");
INSERT INTO upv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ko ngok Pita ko jinibb se Iesu m̃inij nen otur imare kasi nga poran porlesi dubb. ");
INSERT INTO upv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nuru korti orwolu van; ko jinibb se Iesu m̃inij nen owlu eterter easie Pita, ko ejpari womue dubb. ");
INSERT INTO upv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ko ejiol vitan ko okluklu; ko elesi sunsun nga marmalum marres marto, ko sete ma evan lolo b̃ereng. ");
INSERT INTO upv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Vitunen vajin Saemon Pita muwlu vitu vini. Ko ni ma etajer evan lolo b̃ereng, ko ni kele elesi sunsun nga marmalum marres marmatur marto. ");
INSERT INTO upv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ko elesi kalek nga marm̃elji batun e m̃isan muto, sete oto tevi sunsun nga marmalum marres te, ejki. Arlulngi esan oto. ");
INSERT INTO upv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mian ko jinibb se Iesu m̃inij nen nga muwowomu renge dubb nen, ni kele evan lolo b̃ereng, ko elesi ko osuri vajin. ");
INSERT INTO upv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nuru setewor orongwose Naul On nga muwra ni pimaur luwi renge mijen. ");
INSERT INTO upv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mian ko jinibb se Iesu nen nuru orluwi van renge ngaim e. ");
INSERT INTO upv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ko Merri ne Maktala ok-tur malum vare renge dubb, eting. Ok-ting mianan, ko ejiol vitan oklu van renge lolo dubb e. ");
INSERT INTO upv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ko elesi anglo eru oruri sunsun nga morow raprap, orlik renge lat nga Iesu marlingi niben muto rengen, nuru tuwen renge batun ko nuru tuwen renge b̃elan. ");
INSERT INTO upv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ko orsusi tevi vinnen, orwera “Nesevin, kuting suri sev ko?” “Suri nga marla tweni Numal suk, ko sete nurongwose arlingi nibeni.” ");
INSERT INTO upv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Daron nga vinnen muwra mirpel e, ko moro m̃irieni vajin, ko elesi Iesu mutur. Ko sete orongwose nga evi Iesu. ");
INSERT INTO upv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu osusi tevi owra “Erpese nga nik kumting? Kupej isi ko?” Vinnen orrorrmi rreknga evi jinibb nga mok-metmete nai olip nen nir, ko owrai tevi, “M̃erel, poro nga nik kuwosi tweni, ko kupwowrai tevik, ko inu bean bowosi lweni.” ");
INSERT INTO upv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ko Iesu owra Merri nisen renge nale se m̃eri Isrel nir; ko Merri etaole ko erieni mawose, ko owra “Raboni!” (nga renge nale se m̃eri Isrel nir owra ‘jinibb nevisvisenien’). ");
INSERT INTO upv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ko Iesu owrai tevi “Sete kuprrul totonik, suri setewor nuan ji Tata. Kupluwi ma van ji tasik nir, ko kupsup̃e suri inu tevir, nga inu botongsa van ji mun Tata suk, ko kami Tata se kami kele, van ji mun Atua suk ko Atua se kami kele.” ");
INSERT INTO upv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ko Merri olwi van ko owrai tevi jinibb se Iesu nir, “O, lartul! Nulesi Numal!”, ko osp̃e suri tevir nga ni owra nanu ngel nir tevi. ");
INSERT INTO upv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Renge nata mirivriv ko Iesu jinibb sen nir arkorti kele. Ko metali arkikior, suri armetutue jinibb nga marlelep renge m̃eri Isrel nir. Ko artaole Iesu otur pelari livö jir, ko owrai tevir, “Demat piptevi kami.” ");
INSERT INTO upv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Vitunen renge muwrai jile mirpel, ko eviseni milnge nel nuru renge nevren nuru ko milnge sir renge nelin. Ko jinibb sen nir arir renge marlesi Numal. ");
INSERT INTO upv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ko Iesu owra lweni kele tevir, “Demat piptevi kami. Erpe inu Tata okonik, ko inu kele bokoni kami vajin.” ");
INSERT INTO upv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ko daron nga muwra nale ngel e, ko owi sowin van renge nir, ko owrai tevir owra “Ngok, Nem̃in On esilvi pa kami. ");
INSERT INTO upv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Poro kami kaptelasi tweni nololien se jinibb pisan, ngok Atua etlasi tweni ko pa. Ko poro sete kaptelasi tweni, ko ngok Atua sete p̃itlasi tweni ko.” ");
INSERT INTO upv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas, san nga renge jinibb se Iesu esngavöl drromon eru, nga marveruse miwajie m̃elew, sete eptevir renge daron nga Iesu mivini jir. ");
INSERT INTO upv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ko jinibb se Iesu m̃inij nen nir arwerai tevi ni, “Kem ma namlesi Numal!” Ko Tomas owrai tevi nir, “Ejki ma! Poro inu sete b̃elesi nel milngen renge nevren nuru, ko sete b̃elngi bbösö nevrek renge milnge nel nolon ko b̃elngi nevrek renge milnge sir renge nelin, ngok sete numa-osuri.” ");
INSERT INTO upv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mian ko renge nabong owil arasi osuw, ko jinibb sen nir arlik korti kele renge naim; ko Tomas eptevir vajin. Ko metali arkikior. Ko Iesu otur pelari kele livö jir, ko owra “Demat piptevi kami.” ");
INSERT INTO upv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ko owrai tevi Tomas “Kuplingi bbös nevrem iel ko kupmeteni nevrek nuru, ko kupsareni nevrem kuplingi renge milnge sir renge nelik. Sete nosurien som pijkie, ko kuposuri ma.” ");
INSERT INTO upv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ko Tomas owra lweni tevi Iesu, “Numal suk ko Atua suk!” ");
INSERT INTO upv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ko Iesu owrai tevi Tomas, “Nik kuosuri inu suri kumlesik? Neiren renge nir nga sete marlesik ko marosuri wor!” ");
INSERT INTO upv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ko Iesu ololi nelesien m̃inij nir elep kele wor renge no jinibb sen nir, nga sete marulir renge naul ngel. ");
INSERT INTO upv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ko ngel le ma nir nga molir, nulir nga kami kaposuri nga Iesu evi Mesaea, Atua natun mawos; ko renge nosurien ngok renge nisen, kami kapla mauren rengen. ");
INSERT INTO upv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Vitunen renge ngel, Iesu lweni eviseni ni kele vesan tevi jinibb sen nir renge jeli nuwito ne Taepirias (Galili). Renge sel ngel ko ni miviseni ni lweni rengen, erpel: ");
INSERT INTO upv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saemon Pita, Tomas (nga miwajie m̃elew), Nataniel (ne Kena renge Galili) ko natu Sepet nuru, ko nuru m̃inij nen kele eru arlik korti lat sansan. ");
INSERT INTO upv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ko Saemon Pita owrai tevir, owra “Inu bean le pa botutumun.” Ko nir arwerai tevi “Nabinuk, kerr.” Ko nir arivel van, ko arsa renge drrav. Ko mian ko renge nata mupong nen sete arla nanu san rragrrag. ");
INSERT INTO upv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mian ko mijpari rorpong, nat m̃irinrin rranu malum, ko arlesi Iesu mutur renge jeli nuwito renge dep̃inan. Arlesi ma, ko setewor arongwose nga mivi Iesu. ");
INSERT INTO upv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ko Iesu vajin erij van jir, owra “Nanwarreng nir, kamla mesal?” Ko nir arwerai tevi, “Ejki rres!” ");
INSERT INTO upv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ko ni owrai tevir “Kapjuröni niva van renge drrav devjen rres e, ko kaprevei sopor ko.” Ko nir arloli erpok, arjuröni niva van ngatan renge nuwi; ko sete epriv ko nai aron temijpal ren, ololi setemun arongwos parevei lweni, orrow p̃elak. ");
INSERT INTO upv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mian ko jinibb se Iesu nga mimrreni nen owrai tevi Pita, “O, Numal ko ngok!” Daron nga Saemon Pita moka-runge sweri nga muwra ni mivi Numal, ko esaro ngavilvil, ela lweni sunsun sen ko etatuwe, suri ori tweni re marevei niva; ko orow jubbul van renge nuwi. ");
INSERT INTO upv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ko jinibb se Iesu m̃inij nen nir arsaro ngavilvil arevrevei niva renge drrav vini ngaut e, suri nai owun saut rengen. Sete aruj ngasue vanu, erpe ningaw ongut vesan bbong sopon. ");
INSERT INTO upv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Daron nga maran ngaut e, ko arlesi nabb m̃in; ko nai marmasos renge bevla nen, ko niv sopor arto. ");
INSERT INTO upv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ko Iesu owrai tevir, “Kapla nai ngok nga kama-lai ngok bbong sopor vini.” ");
INSERT INTO upv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ko Saemon Pita evan ervei rrerrseni niva vini lat nga mimes e vajin, owun saute nai nga marlelep nir. Nir jijle evi ongut vesan bbulin ngavöl elim drromon itul (153). Ko ngok niva owun saute nai nir, ko sete emarrerr te ejki. ");
INSERT INTO upv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ko Iesu owrai tevir, “Kapini kap̃aan.” Ko jinibb sen nir armetutu nga parsusi tevi, ‘Isi le nik?’ Suri arongwose evi Numal. ");
INSERT INTO upv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ko Iesu evini ela niv ko obbur ototvir, elai tevir, ko ololi erpok kele renge nai. ");
INSERT INTO upv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ngel evi vatolin le nga Iesu miviseni ni lweni tevi jinibb sen nir vitunen renge mimaur luwi kele re mijen. ");
INSERT INTO upv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Daron nga maraan jile, ko Iesu osusi tevi Saemon Pita, “Saemon Jonas natun, kumrreni inu asie nanu ngel nir?” “O-o Numal, nik kurongwose nga inu numrreni nik.” Iesu owrai tevi “Kupwungani sipsip suk.” ");
INSERT INTO upv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mian ko sete epriv ko Iesu osusi varwen tevi ni, “Saemon Jonas natun, kumrreni inu?” Pita owrai lweni tevi “O-o Numal, nik kurongwose nga inu numrreni nik.” Ko Iesu owrai kele tevi, “Kupwungani sipsip suk.” ");
INSERT INTO upv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ko Iesu osusi vatolin tevi ni, “Saemon Jonas natun, kumrreni inu?” Pita ornge lengleng esij e suri Iesu owrai vatul kis tevi ni, ‘Nik kumrreni inu?’ Ko owra lweni tevi, “Numal, nik kurongwose nanu nga musuw ngok nir, kurongwose nga inu memrreni nik!” Ko Iesu owrai lweni kele tevi, “Kupwungani sipsip suk. ");
INSERT INTO upv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ko nuwretun nga nuwretun nuwrai tevi nik, Daron nga kumivi m̃elakel e, ko kusre totoni netatuw som, ko kuan lat jile nga musuw ngok nga kummerreni kupan e. Ko daron nga kupa-ivi b̃irtera, ko kupa-sale nevrem nuru, ko jinibb san pia-sere totkoni nuru, ko pia-pitevim van lat nga sete kummerreni kupan e.” ");
INSERT INTO upv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ngel Iesu owrai suri mijen sev nga Pita pimij rengen, pia-la nosrövien tevi Atua. Muwrai jile nale ngel, ko owrai tevi Pita, “Kupvijuri inu.” ");
INSERT INTO upv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mian ko Pita erieni ko elesi jinibb se Iesu nga Iesu mimrreni milep womunen, m̃er nga m̃ilik lilji Iesu renge daron ne nanen nga maraan, ko mususi tevi, “Numal, isi ko p̃itkai kerasi nik?” ");
INSERT INTO upv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Daron nga Pita m̃ilesi, ko owrai tevi Iesu “Numal, ko pirpese re m̃erel?” ");
INSERT INTO upv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ko Iesu owrai tevi Pita owra “Poro inu bemarong ni sete mia-mij ko p̃ilik pijpari nga inu bolwi vini, ko ngok erpese renge nik? Nik kupvijurik ko wor.” ");
INSERT INTO upv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ko nale ngel owlu elep vajin renge kalesia, nga jinibb se Iesu ngel sete pimij te. Ko Iesu sete owrai tevi Pita nga ni sete pimij, ejki, ko owrai bbong ‘Poro inu bemarong ni sete mia-mij ko p̃ilik pijpari inu bolwi vini, ko ngok erpese renge nik?’ ");
INSERT INTO upv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Inu nuvi m̃ernen le, jinibb se Iesu nga mowra nanu ngel nir, ko moli tututweni nanu ngel nir. Ko kami kamrongwose nale suk evi werweretunen. ");
INSERT INTO upv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nanu elep nga elep kele wor nga Iesu mulolir. Poro paruli nir p̃etp̃eti, inu nurrorrmi rreknga naul nen nir parsongni iel ngatan parto p̃etp̃eti rengen puwun saute, ko sete pivter kele e, sopor parjijpon. ");
INSERT INTO upv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Selek Teopilas, renge naul suk nga womujnen, nulul tevim nga b̃ejiljilwer suri nanu jijle nga Iesu mulolir ko nga mivisviseni kele jinibb nir renger tuwi, ");
INSERT INTO upv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mian mian mijpari nabong nga Atua m̃itkai van re melrin e. Ko vitunen ko mia-van mare e, ko owrai nanu sopor renge derteren se Nem̃in On tevi aposol nir nga mutobbtobbuer. ");
INSERT INTO upv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ko renge nabong ngavöl ivij (40) ko ni eviseni ni tevir, nga puloli parongwose p̃irres nga ni emaur luwi renge mijen. Nir arlesi, ko ni ejilwer tevir suri batun vanu se Atua. ");
INSERT INTO upv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ko daron nga nir jijle marini lat sansan, ko owrai tevir owra “Setewor kapiel lingi Jerusalem wor, ko kaptiriv mun Tata nga p̃ilai Nem̃in On tevi kami erpe merrenien nga milep san tevi kami. Niko mowra pa tevi kami nga ni ololi pa rijrijen nga puloli ko. ");
INSERT INTO upv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ololi baptaes renge nuwi, ko re nabong pievis kele kobbong ko kami kappaptaes renge Nem̃in On.” ");
INSERT INTO upv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Daron nga aposol nir marini markorti lat sansan tevi Iesu, ko arsusi tevi arwera “Ia, Numal, evi pa daron le vajin nga nik kupivi batu numal ne Isrel?” ");
INSERT INTO upv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ko Iesu erij welir owra “Sete evi nga kami kaprongwose daron nga nanu ngok nir parremali ren; Tata kobbong esan elngir renge ni derteren sen. ");
INSERT INTO upv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ko Nem̃in On ma p̃ilai derteren pivini puwun saut re kami, ko kami kapsup̃e suri vajin inu tevi jinibb nir renge Jerusalem, renge Jutia totoklai, Sameria, ko re lat jijle ne iel ngatan.” ");
INSERT INTO upv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Daron nga m̃irij jile mirpok, ko nir arlesi meter e nga Atua ela lweni van re melrin e. Ko nabor san etevni ore, ko setemun arlesi kele. ");
INSERT INTO upv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ko daron nga mian mare e ko meter oto eterter malum re melrin, ko artaole marlesi jinibb eru ortur renge jelir tevi sunsun nga marow titis. ");
INSERT INTO upv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Orwera “Suri sev kami m̃eri Galili ngel kamok-tur iel, kamok-kulu van mare e renge melrin? Iesu ean pa re melrin e mare. Ko ni pia-rremali luwi kele osorsan erpe nga kamlesi mian mare e.” ");
INSERT INTO upv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ko aposol nir arlinglingi botwen ngok nga marveruse ‘Botwen ne lolnai ne olip’, arluwi van Jerusalem e. Botwen ngok oto mori bbong ngaim erpe kilomita bbong san. ");
INSERT INTO upv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mian ko arluwi van Jerusalem e re naim nga marok-lik ren mare. Nir ngok ko niser ngel: Pita, ko Jon, ko Jemes, ko Antru ko Pilip, ko Tomas, ko Batolomiu, ko Matiu ko Jemes nga mivi natu Alpeas, ko Saemon nga bonevis mukorti tevi lartul nga marmerreni puwirr tweni m̃eri Rom, ko Jutas nga tata sen Jemes. ");
INSERT INTO upv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nir ngok arok-korti tetajer renge loten tevi nesevin nir, ko Merri, tasu se Iesu kele, tevi kele tasi Iesu nir. ");
INSERT INTO upv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nabong sopor arasi ko jinibb se Numal nir ejpari ongut vesan bbulin ngavöl eru (120) arser korti renge liken ser san. Mian ko Pita otur imera ko owrai tevir, ");
INSERT INTO upv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","owra “Tasik ko jojik nir, tuwi jer Nem̃in On erij renge jingo Devet, owrai tweni Jutas ngok nga m̃itkai jinibb nir marini marrul totkoni Iesu. ");
INSERT INTO upv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Bonevis ni okorti tevi kem, suri Iesu otobbtobbue ni kele nga p̃imajing tevi kem. ");
INSERT INTO upv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Mian ko Jutas owli dan sopon renge nevöt nga marlai tevi renge sel nga m̃isij nga muloli ngok tevi Iesu. Mian ko ewajeni pa iok ko, ko depain eap ko jinen arivare. ");
INSERT INTO upv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ko daron nga m̃eri Jerusalem jijle nir arongwose nanu ngok, ko niko arlingi vajin ie ewaji nais ngok Akeltama, nga renge nale ser owra puwra ‘Lat ne Drra.’” ");
INSERT INTO upv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ko Pita etajer owra “Re Naul ne Sam nir, Devet owra nale san nga muwra ‘Naim sen puto kiskis, ko sete jinibb san p̃ilik ren.’ Ko nale m̃inij kele san oto nga muwra ‘Erres jinibb m̃inij san p̃ilai wani milngen re majingen sen.’ ");
INSERT INTO upv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Re iok, erres jinibb san pivini pukorti kele tevi kem nga puwrai tweni Iesu, Numal se kerr nga mimaur luwi kele renge mijen. Ko ni pivi wor san re nir nga miptevi kem tetajer, etipatun re daron nga Jon musp̃e suri murrun ne baptaes, mivini mijpari daron nga Atua m̃ila lweni Iesu van renge melrin e.” ");
INSERT INTO upv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ko nir arlingi jinibb eru. Tuwen evi Josep nga marverus kele e Basapas (ko ni nisen tuwen nen evi Jastas), ko nuru tuwen nen nisen Matias. ");
INSERT INTO upv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mian ko nir arlot arwera “Numal Atua, nik kurongwose norrorrmien se jinibb jijle nir. Kupviseni tevi kem nuru si nen re nuru ngel nik kutobbtobbue ");
INSERT INTO upv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nga putori majingen ngel ne aposol nga Jutas m̃ilngi kurtweni pa ko mian re lat nga mumomsawos wor re ni pian ren.” ");
INSERT INTO upv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ko arloli nanu san erpe arwirre daes nga parlesi purrum ji nuru si nen, mian ko nise Matias errmali. Mian ko arsusture, okorti tevi aposol esngavöl drromon san (11). ");
INSERT INTO upv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Re nabong ne Pentekos (ngok nabong ne nanen nga milep se m̃eri Isrel nir), jinibb se Iesu nir arser korti kele lat sansan. ");
INSERT INTO upv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ko vesan rres, drrela nanu nga milep san errmali renge melrin vini, erpe ling nga m̃iterter; ko drrelan nen osongni p̃etp̃eti naim nga marlik ren loloim. ");
INSERT INTO upv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ko arlesi nanu san arirpe lomi nabb nga maror pelpelari. Lomi nabb nen nir aror jipari nir jijle nga marlik re naim nen. ");
INSERT INTO upv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ko Nem̃in On owun saute nir jijle, ko artipatun vajin nga marij renge nale lele nga Nem̃in mimarong nga parij ren. ");
INSERT INTO upv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ko m̃eri Isrel elep nga marok-lot arivel renge vanu jijle nir ne iel ngatan, arini arlik renge Jerusalem re daron ngok. ");
INSERT INTO upv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ko daron nga marunge drrelan nen, ko delung nga milep arser korti ie. Ko nir artaol ko aririr temijpal, suri arunge vajin jinibb se Iesu nir marjiljilwer renge nale ser mawos. ");
INSERT INTO upv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mian ko artaol lengleng ko arwera “E weta, lartul nga marok-rij mirpok ngok arivi m̃eri Galili kobbong! ");
INSERT INTO upv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Suri sev rramrunge marok-rij renge nale se kerr nir mirpok? ");
INSERT INTO upv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kerr rramiel lat lele le vini. Sopor Patia, Mitia, ko Elam. Sopor arivi nga Mesopotemia, Jutia, Kapatosia, Pontas, Esia, ");
INSERT INTO upv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prijia, Pampilia, Ijip, ko re lat sopon ne Lipia mori Saerin, ko Rom, ");
INSERT INTO upv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Krit, ko Arepia. Kerr sopor arivi m̃eri Isrel mawos, ko sopor arivi jinibb ne vare nga marlot tevi m̃eri Isrel nir. Ko rramrunge nir marok-rij renge nale ngok nir se kerr, ko marok-werai tweni majingen ngok nir nga marlelep nga Atua mulolir!” ");
INSERT INTO upv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mian ko nir artaol lenglengen e ko norrorrmien ser esis nawone, ko setemun arongwose lat nga muto suri; ko arsususi lululweni tevir arwera, “E, lartul! Sev ko san?” ");
INSERT INTO upv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ko nir sopor armen keraji jinibb se Iesu nir ko arwera “O, lartul ngok arminmin ko!” ");
INSERT INTO upv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mian ko Pita otur tevi aposol nir esngavöl drromon san ko erij renge drrelan nga mian mare tevi delung nir, owra “Selek nir, kami nga kamivi m̃eri Isrel ko kami nga kamlik iel Jerusalem, kapmurrong inu p̃irres renge sev nga bowrai visviseni tevi kami ngel. ");
INSERT INTO upv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kami kamrongsarr ko nga kamwera namminmin. Suri ea-ivi bbong mete nial esiw ko nga rorpong. ");
INSERT INTO upv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ko sev nga kamlesi ngel evi ma nanu nga propet Joel musp̃e wowomu pae tuwi muwra ");
INSERT INTO upv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Atua owra Re daron ne nabong nga vitu ne iel ngatan pia-tomori, ko inu bejivreni Nem̃in suk tevi jinibb jijle, nga nir para-tor sweri derteren jijle rengen. Natu kami norman ko nesevin para-ivi propet, para-werai tweni sev nga inu b̃elai tevir. M̃elakel se kami nir parlesi bori nga inu bea-viseni tevir, ko b̃irterawarreng se kami nir parmatur lesi bori nir. ");
INSERT INTO upv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ko renge nabong ngok nir, inu bea-jivreni Nem̃in suk renge jinibb suk nir totoklai, norman ko nesevin, ko nir para-werai tweni nale suk nga inu bowrai tevir. ");
INSERT INTO upv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Inu bololi nanu nga marinijnij nawone nir renge melrin mare ko re kele iel ngatan. Ngok, drra ko nabb ko nousnin nga milep kele puto. ");
INSERT INTO upv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Womujnen nial p̃irieni pumot nawon, ko navöl p̃irieni pusongsong pirpe drra. Ko vitunen nabong suk nga mevi Numal Atua nga mean mare pia-rremali vajin. ");
INSERT INTO upv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ko renge daron ngok ko vajin, Numal pia-lai mauren tevi nir nga marverus van jin.’ ");
INSERT INTO upv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ko erres kapmurrong vajin suri sev nga bowrai suri renge Iesu ngok ne Nasret. Atua eviseni nga m̃ilai pa derteren sen tevi Iesu suri nanu nga marinijnij nawone nir ko nelesien nir nga Iesu muloli renge derteren se Atua. Kami kamrongwose erres nanu ngok nir, suri arpelari iel bbong re liven ne kami. ");
INSERT INTO upv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ko oto pa re norrorrmien se Atua osuw nga ni mimrreni p̃ilngi Iesu renge nevre kami. Ko kami vajin kamtor pini, suri kamloli jinibb nga marsij nir arwuse re nai pelaot. ");
INSERT INTO upv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ko Atua ololi emaur luwi kele renge mijen, ko ololi evel sisarow renge derteren nen. Ko mijen sete derteren nen evter rrag rrag nga purrul totkoni Iesu, ");
INSERT INTO upv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","suri Devet owrai nale san suri, owra ‘Tetajer nulesi Numal elik mori tevik, ko oklik re nelik nga sete mea-metutu rragrrag. ");
INSERT INTO upv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ko renge iok, nolok p̃ir temijpal; ko nale suk kele, neiren oto renger, ko nolok sete pivitan. ");
INSERT INTO upv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Suri Numal sete mia-marong nga nem̃ik pimij pin. Nuvi wor se ni nga muon le, ko sete mia-marong nga nibek pumutmut renge dubb, suri nuvi jinibb nga mon re majingen sen. ");
INSERT INTO upv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kuviseni pa sel ne mauren nir osuw tevik, ko kuloli nuir nga komok-lik mori inu.’ ");
INSERT INTO upv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Selek nir, evi norrorrmien nga musorsan nga bosp̃e suri apu se kerr ngok Devet tevi kami. Emij ko pa ko artevni, ko dobbin oto malum iel. ");
INSERT INTO upv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ko evi propet san, ko orongwose nga Atua ololi pa rijrijen san tevi nga sete mia-tor otvi. Owrai pa tevi nga nir san re metka sen mawos ngok nabong sopon pia-ivi batu numal pirpe ni. ");
INSERT INTO upv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devet elesi nanu nga Atua pia-loli, ko niko osp̃e suri Mesaea nga pia-maur luwi re mijen. Nale sen erpel: ‘Atua sete elinglingi renge dubb nga niben pumutmut.’ ");
INSERT INTO upv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Kerr jijle rramlesi nga Atua ololi Iesu nen emaur luwi kele. ");
INSERT INTO upv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Iesu ean pa mare e nga m̃ilik vajin tevi Atua Tata sen renge nevren rres, ko Atua elai Nem̃in On tevi, erpe nga ni m̃irijrij pae musuw. Ko Iesu kele ejivreni Nem̃in renge kem, ko ngok vajin lelingenok kamlesi ko kamrunge. ");
INSERT INTO upv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devet sete ean renge melrin. Ko ni bbong owra nale ngok nga muwra ‘Atua owrai tevi Numal suk owra Kupsakel re devjek rres, kuptiriv ");
INSERT INTO upv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nga inu b̃elngi devje nuval som nir parirpe nanu san nga kupbböt ren.’ ");
INSERT INTO upv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Re iok, erres nga kerr m̃eri Isrel totoklai nir rraprongwose p̃irres nga ewretun nga Atua m̃ilai Iesu ngok nga womu kamwuse re nai pelaot, ko ni ololi evi Numal ko Mesaea se kerr vajin.” ");
INSERT INTO upv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Daron nga jinibb nir marunge jile nale ngok, ko arunge erpe ojuji lenglengen nolor. Ko arsusi tevi Pita ko aposol m̃inij kele nir arwera, “E, selek nir, kem nabloli pirpese nga nablesi mauren?” ");
INSERT INTO upv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita owra lweni tevir owra “Kami kaprieni ko wor norrorrmien se kami suri nololien se kami, ko kami jijle kappaptaes renge nise Iesu Kristo, nga puloli Atua p̃itlasi tweni nololien se kami. Ko Atua pia-lai vajin Nem̃in On ngok tevi kami. ");
INSERT INTO upv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Suri rijrijen ngok evi se kami, ko tevi natu kami kele nir. Ko evi se kele jinibb jijle nir nga Atua piveruse nir, poro arlik ngabe ngabe.” ");
INSERT INTO upv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ko Pita owra visviseni nanu elep nga pirvei norrorrmien ser. Mian ko owra “Nuwrai eterter tevi kami nga kapwolu lingi lolaren nga pivini renge dul nga marsij ngel nir.” ");
INSERT INTO upv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ko re daron ngok ejpari nuvasngavöl nuvatul (3000) nga marosuri nale ko marpaptaes. ");
INSERT INTO upv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ko nir arlai daron ser elep vajin nga martor sweri norrorrmien nga marmerr ji aposol nir; ko arirpe vajin niaken sorsan nir. Tetajer araan korti ko arlot korti. ");
INSERT INTO upv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ko Atua emajing vajin rrurrngi aposol sen nir re nanu elep nga marinijnij nawone nir ko nelesien nir, ko jinibb nir aririr temijpal suri. ");
INSERT INTO upv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jinibb jijle nga marosuri arok-korti kemkam̃e, ko arok-vijngeni lululwenir kele re nanu jijle nga marto jir. ");
INSERT INTO upv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nir arwulwule joror nir ko arlai nevöt nen, artutweni tevi nir si nga mumrrole nanu san. ");
INSERT INTO upv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nabong jijle arok-korti lat sansan, loloim re Naim On. Arok-aan kokorti renge naim sisamis, renge nolor nga marir ko maran ngatan. ");
INSERT INTO upv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nir arok-surövi Atua, ko jinibb kele nir artorir. Ko nabong jijle Numal ololi jinibb kele sopor arlai mauren ko arini arkorti kele re gortien ser vajin. ");
INSERT INTO upv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nabong san renge daron ne loten, evi mete nial itul rivriv, ko Pita ko Jon oran renge Naim On. ");
INSERT INTO upv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ko jinibb san sete orongwos pivel, suri daron nga m̃iak e evi naroj. Nabong jijle selen nir arwosi vini ko arlingi re roro metali san ne Naim On nga nisen Metali nga m̃irinrin m̃irres. Ko okngoni nevöt ji nir nga marok-asi van loloim ngok. ");
INSERT INTO upv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","M̃ernen elesi Pita ko Jon orini nga poran loloim, ko ongoni nga porlai nevöt sopon tevi. ");
INSERT INTO upv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ko nuru orkulu mawos ni ormeteni, ko Pita owra “Kupmeteni komru!” ");
INSERT INTO upv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mian ko oklu van ji nuru, orrorrmi nga p̃ilai nanu san ji nuru. ");
INSERT INTO upv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ko Pita owrai tevi owra “Nevöt san ejki rragrrag jik, ko nanu ma san oto jik nile b̃elai tevim. Renge nise Iesu Kristo m̃eri Nasret ngok, nuwrai tevim, kuptur imera ko kupiel!” ");
INSERT INTO upv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mian ko orrul totkoni nevren rres ko ervei nga putur. Ko vesan rres nau re b̃elan ko bbujin b̃elan arres luwi, ");
INSERT INTO upv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ko otur imera kasi ko evivel. Ko evivitu suri nuru aran loloim re Naim On. Evel ko orowrow b̃elan, osrövi vajin Atua. ");
INSERT INTO upv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ko jinibb arlesi vajin nga ni mok-rowrow b̃elan nuru ko mok-surövi Atua. ");
INSERT INTO upv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ko daron nga marlesi wose nga mivi naroj nga tetajer mok-ngoni nevöt vare renge metali nga m̃irinrin m̃irres, ko nir artaol lenglengen suri nanu ngok nga m̃irrmali jin. ");
INSERT INTO upv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","M̃ernen orrul totoni Pita ko Jon renge naim san nga mutur re jeli Naim On nga marveruse Naim Salsal se Solomon. Ko jinibb nir artaol lenglengen ko arwolwolu vini jir. ");
INSERT INTO upv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ko daron nga Pita m̃ilesi delung milep marini marser rrale, ko owra “Selek nir, suri sev kamtaole nanu ngel? Suri sev kamok-meteni lenglenge kem? Kamrrorrmi komru nomor-majing re derteren se komru? Kamrrorrmi nomor-rongwos nobor-loli m̃erel pivel suri bbong nomor-ivi jinibb nga nomor-rres? ");
INSERT INTO upv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ejki! Atua nga Epram, Aesak, Jekop ko b̃irterawarreng se kerr nir elngi ni nosrövien sen tevi jinibb ne majingen sen ngok Iesu. Ni ko kami kamtekai kerasi van renge nevre m̃eri Rom nir, ko kamtere ni daron nga mutur re no Paelet nir. Paelet kele owra puloli ni pivel sisarow, ko kami kammusus. ");
INSERT INTO upv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kamungasi Iesu, nga muon ko m̃irres. Kamngoni tevi Paelet suri jinibb nga mirevji pini jinibb nga pivel sisarow, ");
INSERT INTO upv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ko kamrevji pini ni nga m̃itkai jinibb nir van re mauren. Ko Atua osustur lweni re mijen, kem namlesi! ");
INSERT INTO upv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ko kaplesi naroj ngel. Derteren ne nise Iesu ko ololi derteren sen muto luwi. Nanu ngel nga kami kamlesi ko kamrongwose, nomor-loli suri nomor-osuri Iesu nisen. Niko nosurien ngok ko renge Iesu ko ololi m̃erel m̃irres jile luwi, erpe nga kami jijle kamok-lesi vajin. ");
INSERT INTO upv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ko selek nir, nurongwose nga sev nga kami tevi m̃erwomu se kami nir marloli tevi Iesu, kamloli suri sete kamrongwose sev nga kamloli. ");
INSERT INTO upv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ko ngok evi sel se Atua nga puloli nale nga muwrai tweni tuwi pa parremali. Renge nale se propet sen nir, owrai tweni pa osuw nga Mesaea pia-runge p̃isij, ko lelingenok otori totkoni rijrijen sen ngok. ");
INSERT INTO upv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ko erres vajin nga kaprieni lululweni norrorrmien se kami suri nololien se kami, ko kapan ji Atua nga ni p̃itlasi tweni nololien se kami. Poro kaploli pirpok, ko ");
INSERT INTO upv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","daron nen pivini vajin nga Numal pia-lai derteren nga mimerr ko m̃irres tevi kami. Ko ni pukoni Iesu vinuk nga mivi Mesaea se kami nga ni mutobbtobbue musuw. ");
INSERT INTO upv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ko Iesu p̃ilik mun re melrin puwomu pianan pijpari nanu jijle parmerr luwi kele, pirpe nga Atua muwrai tweni pa musuw re nale se propet sen nga maron ne tuwi. ");
INSERT INTO upv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Suri Moses owra ‘Numal nga mivi Atua se kami pukoni san vini ji kami nga pia-ivi propet, osorsan erpe nga mukoni pa inu. Ni pivi san re kami kobbong. Kapvijuri ko wor p̃irres nanu jijle nga pia-werai tevi kami. ");
INSERT INTO upv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jinibb nga sete mivijuri nale se propet ngok, ko Atua pia-lai tweni renge gortien sen ko puloli pijijki.’ ");
INSERT INTO upv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ko Samuel kele tevi propet m̃inij nen nir nga marvivitu suri arok-supsup̃e kele suri sev nga m̃irrmali pa lelingenok. ");
INSERT INTO upv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Rijrijen nga Atua m̃ilai tevi b̃irtera se kerr nir tuwi arivi se kami, ko kami kamkorti pa renge rijrijen nen nir. Nale nga Atua muwrai tevi Epram owra ‘Rrurrngi renge nik metka som nir nga para-vini, inu b̃erij p̃irres suri jinibb totoklai ne iel ngatan.’ ");
INSERT INTO upv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Niko Atua otobbtobbue jinibb ne majingen sen ko okoni womue vini ji kami. Suri Atua emrreni p̃irij p̃irres suri kami ko puloli kami jijle kaprieni lululweni kami renge sel nga marsij se kami.” ");
INSERT INTO upv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita nuru Jon orok-rij malum tevi delung nir, ko jinibb ne sulsulen nir tevi m̃erwomu se jinibb nir nga marok-metmete Naim On tevi Satusi nir arini ji nuru. ");
INSERT INTO upv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Arlolarsi nuru suri mor-visviseni delung nir, arwera Iesu emaur luwi kele re mijen, ko ngok niko ololi nga jinibb nir nga marmij arongwose parmaur luwi re mijen. ");
INSERT INTO upv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ko arrul totoni nuru ko arlingi nuru re naim ne nekaien pijpari mevinen, suri rivriv jer pa. ");
INSERT INTO upv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ko nir elep nga marunge nale se nuru ko arosuri. Ko norman nga marlelep nir nga marosuri oruj mori nuvasngavöl nuvalim (5000) sopon. ");
INSERT INTO upv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mevinen vajin ko jinibb nga marlelep nir se m̃eri Isrel nir ko b̃irterwarreng ser nir ko jinibb nevisvisenien ne nale nesesreien nir arkorti Jerusalem. ");
INSERT INTO upv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Arkorti tevi batu jinibb ne sulsulen, nga nisen Annas, ko Kaeapas, ko Jon, ko Aleksanta, ko nir m̃inij nen kele nir nga marivi metka se batu jinibb ne sulsulen. ");
INSERT INTO upv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ko arlingi nuru ortur re liven ne nir, ko arsusi tevi nuru, arwera “Re derteren se siko rreknga re nise siko komor-loli nanu ngok ren?” ");
INSERT INTO upv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ko Pita owun saut e Nem̃in On, ko owrai tevir owra “Kami jinibb nga marlelep nir se kerr m̃eri Isrel nir ko b̃irterwarreng nir, ");
INSERT INTO upv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kamok-susie komru erpese re majingen nga m̃irres ngok nga nomor-loli renge naroj ngel, erpese b̃elan erres luwi. ");
INSERT INTO upv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Erres kami ko m̃eri Isrel jijle nir kaprongwose nanu ngel: nomor-loli re nise Iesu Kristo doNasret, nga kami kamtor pini re nai pelaot, ko Atua ololi emaur luwi re mijen. Niko re ni nisen ko, m̃erel m̃irres luwi pa mutur re no kami ngel. ");
INSERT INTO upv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu ngel evi m̃er nga Naul On musp̃e suri, ngel: ‘Nabur nga kami jinibb nga marmajinge naim kamlesi esij ko kamwirre, evi vajin nabur nga murrul totoni naim m̃iterter.’ ");
INSERT INTO upv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ko sete san kele orongwos p̃ila mauren tevi kerr, ejki. Suri nais p̃etp̃eti ne iel ngatan nir san ejki kele mun nga kerr rrapmaur ren.” ");
INSERT INTO upv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ko daron nga marlesi Pita nuru Jon sete ormetutu mirpok ko artaole, suri nuru orivi jinibb nawon, ko sete arsesre p̃elak nuru bonevis. Ko arlesi wose vajin nga morok-pitevi Iesu. ");
INSERT INTO upv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ko sete arongwos parwera mun nanu san tevi nuru ren, suri marlesi bbong m̃er nga m̃irres luwi jile pa mutur tevi nuru. ");
INSERT INTO upv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ko arkoni twenir ivare lingi gortien ser, ko nir kis arsan vajin armurri suri. ");
INSERT INTO upv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ko arwerwerai tevir, “Rraploli sev tevi jinibb ngel nuru? Suri nir jijle nga marlik iel Jerusalem arongwos pae nanu nga milep nga morloli. Sete rramrongwos rrapvilvil ore mun. ");
INSERT INTO upv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ko nga rraptor ore, setemun p̃iasasi kele van ji m̃eri Isrel p̃etp̃eti nir, rrapsusur metu tevi nuru nga setemun porsup̃e kele nais ngok tevi jinibb san.” ");
INSERT INTO upv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ko arverus nuru vajin vini. Ko arwera eterter tevi nuru nga setemun porsup̃e ko setemun porvisviseni kele nise Iesu, pijki. ");
INSERT INTO upv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ko Pita nuru Jon orwera lweni tevir: “Erpese? Erres re no Atua nga nobor-vijuri nale se kami, rreknga nobor-vijuri nale se Atua? Erres kami kaprunge suri kami tevi. ");
INSERT INTO upv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ko komru ma, sete nomor-rongwos nobor-lingi kurtweni sev nga nomor-lesir ko sev nga nomor-runger. Ejki, nobor-wera twenir ko wor.” ");
INSERT INTO upv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ko mian ko artortori nuru eterter kele sopon, ko arlinglingi tweni nuru vajin, orivel. Sete arongwos partor sweri sel san nga partor alje nuru ren, suri delung nir arlesi sev nga morloli erres p̃elak, ko arsurövi Atua rengen. ");
INSERT INTO upv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Suri m̃er nga nanu nga milep ngok miplari ren nga morloli m̃irres nen evi jinibb tera pa sopon, sian asi ngavöl ivij (40). ");
INSERT INTO upv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Orivel sisarow vajin, ko ormawos kele kalesia nir sopon, ko orwera tweni nanu nga batu jinibb ne sulsulen nir ko b̃irterwarreng nir marwerai tevi nuru. ");
INSERT INTO upv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ko kalesia nir, daron nga marunge nale se nuru ngok, ko arlot korti van ji Atua, arwera “Numal nga mian mare, nik nga kummajing melrin ko iel ngatan ko dis ko nanu jijle nga marto rer. ");
INSERT INTO upv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Renge derteren se Nem̃in On kurij rrurrngi renge Devet apu se kem, nga mivi jinibb ne majingen som, re nale ngel: ‘Suri sev jinibb ne vare nir arlolar p̃elak erpok? Suri sev armurri nanu nga marsij, nga sete marongwos parivi nanu san? ");
INSERT INTO upv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Numal ne iel ngatan nir artur korti tera nuval, ko jinibb nga marlelep nir kele arini lat sansan tera nuval, artere Numal Atua ko Mesaea sen nga mutobbtobbue.’ ");
INSERT INTO upv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ewretun, eplari pa erpok bonevis renge ngaim ngel mawos, nga Erot nuru Ponjes Paelat nuru tevi jinibb ne vare nir ko m̃eri Isrel nir kele arini lat sansan, arkorti artere Iesu nga mivi Mesaea som, nga kumtobbtobbue. ");
INSERT INTO upv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ko arloli bbong sev nga derteren som ko marongen som morlingi wowomu pae nga piplari. ");
INSERT INTO upv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ko lelingenok, Numal Atua, kupmeteni suri nale ne balpalen ser, ko kuploli kem jinibb ne majingen som, no kem p̃iterter ko nabwera tweni nale som. ");
INSERT INTO upv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ko kupsareni nevrem ko kupjipari jinibb nga puloli jinibb parres luwi, ko nga majingen nga marlelep marres nir parpelari renge nise jinibb ne majingen som nga muon, Iesu.” ");
INSERT INTO upv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Daron nga marlot jile musuw, ko nam̃i eterure naim nga marlik ren. Ko nir jijle arwun saut e Nem̃in On, ko ololi nor eterter vajin nga parwera tweni nale se Atua. ");
INSERT INTO upv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ko kalesia nir, nolor ko nem̃ir arivi sansane. Ko setemun nir san orrorrmi joron arivi se ni esan, ko arwera joror evi se nir jijle. ");
INSERT INTO upv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ko aposol nir arwera tweni nga Numal Iesu emaur luwi re mijen tevi derteren nga milep, ko Atua erij erres p̃elak suri nir jijle. ");
INSERT INTO upv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ko sete nir san nevren omrrol rragrrage nanu san. Suri nir jile nga joror milep, erpe dan ko naim, ko arwulwuler, ko arlai nowli nanu nga marwulwul ngok e nir, ");
INSERT INTO upv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ko arlai tevi aposol nir. Ko nir artututweni tevi jinibb si nga nevren mumrrol. ");
INSERT INTO upv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ko jinibb san nga nisen Josep, metka se Livae san, nga m̃iak renge Saepras. Ko aposol nir arlingi nisen m̃inij kele san, arveruse Banapas, nga muwra puwra ‘jinibb nga moksusi nolo jinibb nir mian mare.’ ");
INSERT INTO upv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ko re murrun ngok, ni owulwule bebje dan sen, ko ela nowlin vini ko elai tevi aposol nir. ");
INSERT INTO upv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ko jinibb san nisen Ananaeas nga nesen sen nisen Sapaera owulwule bebje dan se nuru san. ");
INSERT INTO upv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ko elngi jer nowlin sopor ojpon, ko elai sopor bbong vini tevi aposol nir. Ko nesen sen kele orongwose sev nga muloli ngok. ");
INSERT INTO upv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ko Pita owrai tevi, “Ananaeas, erpese Demij musongni nolom nga kumkerkerasi Nem̃in On, ko kumlingi jere nowli dan som sopon? ");
INSERT INTO upv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Daron nga setewor kumwulwul wore dan, ko evi som ko. Ko daron nga kumwulwul pae, ko nowlin oto re nik nevrem malum nga kuploli sev nga kummerreni e, erres kobbong. Ko suri sev norrorrmien ne gerisen mivini muto re nolom? Sete kukrekrasi jinibb nir, ko kukrekrasi Atua kele.” ");
INSERT INTO upv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ko Ananaeas, daron nga murnge nale sen ngok, ko eil jubbul vitan, ko emij pin. Ko nir nga marunge nanu ngel, metuen nga milep evini rer suri. ");
INSERT INTO upv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ko m̃elakel nir arnub̃e ore, ko arwosi tweni van ko artevni. ");
INSERT INTO upv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Vitunen vajin, erpe mete nial itul arasi, ko nesen sen evini loloim. Mivini ko sete orongwose sev nga miplari ji diwen sen. ");
INSERT INTO upv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ko Pita owrai tevi, “Kupwerai ta tevik. Ngel evi nowli dan totoklai le pa nga komor-wulwule?” Ko ni owra “O-o, ngok ko.” ");
INSERT INTO upv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ko Pita owrai tevi, “Erpese kamru korti komor-marong komor-wera kopor-rrowrrow silveni Nem̃in se Numal? Kuprunge dan b̃ela nir nga martevni diwen som arini pa roro metali, ko parwosi tweni nik kele.” ");
INSERT INTO upv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ko vinnen eil jubbul evesane ngatan renge Pita b̃elan, ko emij pin. Ko m̃elakel ngok nir arini loloim, ko arlesi nga ni mimij pa; ko arwosi tweni ivare, ko aran artevni tevi diwen sen. ");
INSERT INTO upv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ko metuen nga milep evini renge kalesia jijle nir suri, ko renge nir jijle nga marunge. ");
INSERT INTO upv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ko aposol nir arok-loli majingen nga marinijnij nawone nir elep tevi jinibb nir. Ko nir jijle arkorti renge naim salsal se Solomon nga muto ore Naim On. ");
INSERT INTO upv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jinibb jijle nir arsurövir, ko nir jijle nga sete marivi kalesia armetutu nga paran parkorti tevir. ");
INSERT INTO upv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ko gortien ne kalesia nir nga marok-osuri Numal, ngok norman ko nesevin nir, okruj van mare tetajer. ");
INSERT INTO upv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Suri nanu ngok nir, ko jinibb nir arwoswosi jinibb nga marmesi nir vini re sel nir, ko arlingi nir sopor re maling, ko nir sopor renge boriti nga marp̃elsenir. Armerreni nga poro Pita p̃iasi, ko poro bbong nem̃in p̃isal van pijpari nir sopor. ");
INSERT INTO upv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ko delung elep ne nir nga marlik renge ngaim wowarreng nga marto rrale Jerusalem kele arwoswosi jinibb nga marmesi vini, tevi nir nga nem̃in nga marsij marsisilvir; ko nir jijle arres luwi. ");
INSERT INTO upv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ko batu jinibb ne sulsulen, ko nir nga markorti re gortien sen, nir ngok ko Satusi nir, nolor eleplep temijpal. Ko artur imare, ");
INSERT INTO upv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ko arrul totoni aposol nir, ko arwirrer van re naim ne nekaien. ");
INSERT INTO upv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ko anglo se Numal san evini nat mupong, ko etasi metali ne naim ne nekaien ko eptevi twenir ivare. Ko owrai tevir: ");
INSERT INTO upv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kapan kaptur renge Naim On ko kapwera tweni p̃etp̃eti nale ngel ne mauren tevi jinibb nir.” ");
INSERT INTO upv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ko daron nga marunge nale ngok musuw, mian ko nat ea-rinrin rranu vajin, ko arini re Naim On, ko artipatun arvisviseni jinibb nir. Mian ko batu jinibb ne sulsulen tevi gortien sen nir arververus kortoni gortien nga milep se b̃irterwarreng nir nga marwowomue m̃eri Isrel nir arini lat sansan. Ko arkoni jinibb ser sopor paran re naim ne nekaien ko parpitevi aposol nir parini. ");
INSERT INTO upv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ko daron nga jinibb nen nir maran, ko sete arlesir re naim ne nekaien. Ko arluwi vini jir kele, ko arwerai arwera ");
INSERT INTO upv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Daron nga namjipari naim ne nekaien, ko namlesi metali nen arkikiore erres p̃elak, ko lartul nga martur metmete artur metmete erres renge roro metali. Ko daron nga namtasi metali vajin, ko sete namlesi jinibb san loloim.” ");
INSERT INTO upv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ko daron nga batu jinibb nga mok-metmete Naim On tevi batu jinibb nga marsulsul nir marunge nale ngok, ko norrorrmien ser ekarkar, ko arrelenge sev ko eplari jir. ");
INSERT INTO upv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mian ko jinibb san evini ko owrai tevir, “E lartul! Jinibb ngok nir nga kamlingir re naim ne nekaien artur lelingenok re Naim On ko arok-visviseni jinibb nir.” ");
INSERT INTO upv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ko batu jinibb nga mok-metmete Naim On eptevi jinibb sen sopor aran ko arpitevi twenir. Ko sete aron tertere nir, suri armetutue delung nir tartuwtuwer e nevöt. ");
INSERT INTO upv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Arpitevir van ko arloli artur re no gortien ser. Ko batu jinibb ne sulsulen erij tevir, owra ");
INSERT INTO upv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Namwerai pa eterter tevi kami nga sete kami kapvisvisenir renge nais ngok. Ko erpese? Kamloli iel Jerusalem owun saute nevisvisenien ngok! Ko rrek kammerreni kaploli drra Iesu pibbölji kem!” ");
INSERT INTO upv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ko Pita tevi aposol nir arwera lweni tevir: “Nabosuri wor Atua ko womu ne jinibb. ");
INSERT INTO upv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Numal se tata se kerr nir ololi Iesu emaur luwi re mijen, nga kami kamrevji re nai pelaot. ");
INSERT INTO upv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Atua elngi ni esakel mare re nevren rres, nga ni puwomu re kerr ko p̃ila mauren tevi kerr, nga kerr m̃eri Isrel nir nolo kerr purongwos pulululwi, ko nga p̃itlasi tweni nololien se kerr. ");
INSERT INTO upv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ko kem namok-rij sen renge nanu ngel nir, tevi Nem̃in On nga Atua m̃ila tevi nir nga marosuri ni.” ");
INSERT INTO upv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ko daron nga nir nga markorti ngok nir marunge nale ngok, ko arlolar lengleng ko arwera parevji pinir. ");
INSERT INTO upv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ko Parasi san nga mok-korti tevir renge gortien ngok, nisen ko Gameliel, evi jinibb ne nevisvisenien ne nale ne nesesreien san nga jinibb jijle nir arsurövi ni. Ko ni otur imare ko owra partekai tweni mun aposol nir van vare e beblen. ");
INSERT INTO upv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Musuw, ko owrai vajin tevi selen nir, owra “M̃eri Isrel nir, rraprrorrmi p̃irres p̃elak ko wor re sev nga rramwera rraploli tevi lartul ngok nir. ");
INSERT INTO upv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Suri rramrongwose bonevis sopon, san otur imare, nisen ko Tutas. Ni elngi lweni ni evi jinibb san. Ko jinibb elep sopon, ejpari ongut vavij (400) sopon arpitevi. Ko mian ko m̃ernen arevji pini, ko jinibb sen nir arwolu sarrsarr; ko ngok evi vajin bongsi majingen sen. ");
INSERT INTO upv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ko vitunen Jutas, m̃eri Galili ko san, otur imare re daron nga marok-eve jinibb e nir. Ko ni ervei tweni jinibb sopor arvijuri ni. Ko mian ko ni kele arevji, ko nir jijle nga marvijuri ni arivel sarrsarr. ");
INSERT INTO upv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ko ngok, re nanu nga miplari ngel vajin, nuwra bowrai tevi kami: sete rraploli nanu san tevi jinibb ngok nir. Rraplinglingir parivel. Suri poro nga norrorrmien ser ko majingen ser eplari re jinibb kobbong, ko pivitan kobbong. ");
INSERT INTO upv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ko poro ma eplari re Atua, ko sete rramrongwos rraplokloksir. Poro pirpok ko kerr rratpalpal kobbong tevi Atua.” Ko nir armurronge erres. ");
INSERT INTO upv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ko arveruse aposol nir arini kele jir, ko artelmajir ko arwerai eterter tevir nga setemun parsup̃e nise Iesu; ko arlinglingir arivel. ");
INSERT INTO upv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ko nir arivare lingi gortien ser nen ko arir kobbong nga Atua elesi nir arviter nga jinibb artelmajir suri nise Iesu. Ko sete armanun rragrrage. ");
INSERT INTO upv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ko re nabong ko nabong, sete armosi nga parvisviseni ko parwera tweni nosp̃en nga m̃irres suri Iesu nga mivi Kristo nga Atua mutobbtobbue, renge Naim On, ko renge naim nir. ");
INSERT INTO upv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jinibb se Iesu elep malum arini. Ko mian ko laten san eplari jir. Renge devjen evi m̃eri Isrel nga marok-rij nale se m̃eri Gris nir, ko renge devjen evi m̃eri Isrel nga marok-rij nale ser wor. Ko nir re devjen nga marok-rij nale se m̃eri Gris nir artere nir re devjen, arwera sete armeteni suri nesevin ser nir erres re daron nga martututweni nevöt ko nanen nabong jijle tevi nesevin nir nga diwen ser marmij lingir. ");
INSERT INTO upv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ko aposol esngavöl drromon eru arverus kortoni kalesia jijle nir, ko arwerai tevir: “Sete erres re nga kem nablinglingi kurtweni majingen ne nale se Atua ko nabp̃elak nga nabmetmete nevöt. ");
INSERT INTO upv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ko niko, niaken se kem nir, kaplingi jinibb piebut re kami nga jinibb nir martorir, ko nga marwun saute Nem̃in On ko norongwosien, ko kem nablingi nir parla majingen ngel. ");
INSERT INTO upv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ko kem ma, nabmajing tetajer renge majingen ne verusen ko ne nale se Atua.” ");
INSERT INTO upv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ko kalesia jijle nir arlesi nale ser ngok erres, ko arlingi Steven, jinibb san nga muwun saute nosurien ko Nem̃in On, ko Pilip, ko Prokoras, ko Nikeno, ko Timon, ko Pamenas, ko Nikolas nga mivi m̃eri Antiok san, nga womu evi jinibb ne vare san ko vitunen ea-korti vajin tevi m̃eri Isrel nir ko oklot tevir. ");
INSERT INTO upv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ko kalesia nir arpitevi nir ngok, arlingir artur re no aposol nir, ko nir arlot ko arlingi nevrer rer. ");
INSERT INTO upv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ko nale se Atua ok-asasi, ko jinibb se Iesu nir nga renge Jerusalem elep temijpal malum arini, ko delung elep ne jinibb ne sulsulen nir arosuri kele. ");
INSERT INTO upv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Steven ngok evi jinibb san nga Atua m̃irij m̃irres suri, ko elai derteren nga milep tevi. Ko ololi majingen nga marinijnij nawone nir re no jinibb nir. ");
INSERT INTO upv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ko sete epriv, jinibb sopor artur imare ko artere. Nir arivi jinibb ne naim gortien san se m̃eri Isrel nir nga bonevis marivi pa demij maur, ko lelingenok arivel sisarow vajin. Ko niko arverus naim gortien ser, arwera ‘Naim gortien se nir nga marivel sisarow’. Nir ko arivi m̃eri Isrel nga marivel Saerin ko Aleksantria vini. Ko m̃eri Isrel sopor kele nga marivel Silisia ko Esia arkorti kele tevir, ko arlat tevi Steven. ");
INSERT INTO upv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ko Nem̃in On ololi Steven norongwosien sen elep, ko daron nga m̃irij e, nir sete arongwos parasi ni re rijen sen. ");
INSERT INTO upv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mian ko arkonkoni silveni jinibb sopor nga paran parwerai, “Namrunge pa ni erij esij tere Moses ko tere Atua.” ");
INSERT INTO upv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Arok-rij erpok mian, ko arserranu re nolo jinibb nir ko b̃irterwarreng nir ko jinibb nevisvisenien ne nale nesesreien nir; ko nir vajin artur imare ko aran arrul totoni Steven, ko arevei van re naim gortien se numal ser nir. ");
INSERT INTO upv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ko arlingi jinibb sopor partur ko parij re nale gerisen ser. Ko lartul nen arwera “M̃erel okrij tetajer tere Naim On ko tere nale nesesreien se Atua. ");
INSERT INTO upv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ko namrunge ni owrai Iesu ne Nasret ngok pulokloksi Naim On ngel ko p̃irieni liken nga Moses m̃ila tevi kerr pa.” ");
INSERT INTO upv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ko nir nga marlik re naim gortien ngok armet teretre Steven; ko arlesi ni non erpe no anglo san. ");
INSERT INTO upv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ko batu jinibb ne sulsulen osusi tevi Steven owra “Evi weretunen ko wor?” ");
INSERT INTO upv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ko Steven erij weli lweni owra “Tuwak ko tata nir, kapmurrong inu! Womunen ko apu se kerr ngok Epram mia-van nga p̃ilik Aran, daron nga m̃ilik malum re vanu ngok Koltia nga muto re vanu nga milep ngok Mesopotamia, ");
INSERT INTO upv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ko Atua ne nosrövien eplari jin; ko owrai tevi owra “Kupiel lingi vanu som ko metka som nir ko kupan re vanu san nga bea-viseni tevim.” ");
INSERT INTO upv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mian ko Epram evel lingi vanu sen ko ean etipatun liken sen Aran. Ko vitunen ko tata se Epram ea-mij, ko Atua ololi Epram evel oruj vini re vanu ngel nga rramlik ren lelingenok. ");
INSERT INTO upv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ko renge daron ngok Atua sete elai rragrrag bebje dan sopon tevi Epram, ejki, ko ololi ma rijrijen tevi nga pia-lai dan nir tevi. Ko owra dan nir parivi se ni tevi metka nga para-rremali renge ni. Ko daron nga muwrai ngok e, ko Epram natun ejki wore ko! ");
INSERT INTO upv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ko ngel evi nale se Atua nga muwrai tevi, owra ‘Metka som nir para-ivel lingi iok ko paran parlik renge vanu m̃inij nga parivi demij maur ie, ko parlik renge nekaien nga m̃iterter pijpari sia pungut pivavij (400).’ ");
INSERT INTO upv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Iok osp̃e suri Ijip. Ko Atua owra ‘Inu bea-virrvirrali nir nga marmajing ser, ko metka som nir para-ivel lingi vanu ngok ko parluwi parsurövik iel.’ ");
INSERT INTO upv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ko Atua elai murrun ne bae tevi Epram, nga miviseni nga Epram evijuri vajin sel se Atua. Natun Aesak ean re bae daron nga bongin muowil e. Ko Aesak kele ololi tevi Jekop nga m̃ilai van re bae, ko Jekop kele ololi erpok nga m̃ilai natun esngavöl drromon eru maran re bae, nir ngok nga marivi b̃irtera se kerr ne tuwi. ");
INSERT INTO upv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jekop natun nir nolor eleplep tevi tasir Josep, ko arwulwule nga pian pivi demij maur renge vanu ngok Ijip. Ko Atua emetmete Josep, ");
INSERT INTO upv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ko etkai lilane erres; ko ololi easi renge daron nga marterter nir nga marok-pelari jin. Daron nga Josep mivini vajin mutur re no batu numal se m̃eri Ijip nir, ko Atua ololi norongwosien sen ean mare tevi murrun nga m̃irres p̃elak sen. Ko numal nen ololi Josep evi jinibb nga mian mare temijpal, nga pimetmete Ijip totoklai ko pimetmete majingen ne naim sen kele. ");
INSERT INTO upv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Sete epriv daron nga m̃iterter san ejpari Ijip ko Kenan, nga nanen ejki. Ko b̃irtera ngok se kerr nir arunge esij lengleng suri nanen ejki. ");
INSERT INTO upv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ko daron nga Jekop murnge nga nanen muto Ijip, ko okoni natun nir, b̃irtera ngok se kerr nir, aran. Ngok evi womujnen nga mara-van rrongi ie. ");
INSERT INTO upv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ko renge daron m̃inij kele nga maran, ko Josep eviseni ni limjer vajin tevi tuwan nir, ko numal se m̃eri Ijip nir ornge jilweren suri metka se Josep nir. ");
INSERT INTO upv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mian ko Josep elai nale van ji tata sen Jekop nga piptevi metka sen nir parini parlik Ijip. Renge gortien ngok nir ejpari ngavöl ebut drromon elim (75) renge nir totoklai. ");
INSERT INTO upv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ko Jekop tevi b̃irtera ngok se kerr nir ne tuwi arivel lingi lat nga marlik e ko aran arlik Ijip; ko arlik ie ejpari daron nga mara-mij e. ");
INSERT INTO upv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ko arwosi lweni niber van Sekem e, ko artevnir lat nga marok-tivtavin e san nga Epram muwli tweni pa tevi metka se Amoro nga renge vanu ngok Sekem. ");
INSERT INTO upv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ko daron evini mori vajin nga Atua puloli rijrijen sen ngok nga m̃ilai pa tevi Epram p̃irrmali. Renge daron ngok, metka se b̃irtera se kerr ngok nir arvasus ko emaur elep kele. ");
INSERT INTO upv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","“Ko eanan ejpari nga jinibb m̃inij kele mivi batu numal kele ne Ijip, nga sete murrorrmi tutune Josep. ");
INSERT INTO upv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Osur terter ko ekrekrasi b̃irtera ngok se kerr nir, ko osulngatir nga parwosi tweni bipi ser nir renge naim ser ko parling twenir vare nga parmij. ");
INSERT INTO upv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ngok evi daron mawos nga bipi nga m̃irres p̃elak ngok Moses m̃iak ren. Tata sen ko tasu sen ormetmete erres renge naim ser ean ejpari navöl itul, ");
INSERT INTO upv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","mian ko orlingi tweni vare erpe nga nesesreien se batu numal muwrai. Mian ko natu numal nesevin eskai, ko otori tweni ko emetmete, ko elai erpe natun mawos vajin. ");
INSERT INTO upv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Arvisviseni renge norongwosien se m̃eri Ijip nir, ko evini evi jinibb nga milep renge rijen ko re majingen kele. ");
INSERT INTO upv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Daron nga Moses sian mijpari ngavöl ivij (40) ko orrorrmi wor nga pian p̃ilesi otvi lat nga m̃eri Isrel nir liken ser muto suri. ");
INSERT INTO upv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mian ko elesi m̃eri Ijip san nga mirevji jinibb nga nir san; ko ean erevji pini m̃eri Ijip nen. ");
INSERT INTO upv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ni orrorrmi metka sen nir parongwose nga Atua p̃imajing rrurrngi ni nga puloli nir parivel sisarow. Ko nir sete arongwose. ");
INSERT INTO upv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ko mevinen kele, elesi m̃eri Isrel eru orpalpal, ko evan nga p̃ijnge nuru. Ko owra “E, erpese komor-ivi niaken bbong, ko komor-palpal lululweni kamru mirpok?” ");
INSERT INTO upv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ko wela nga mokloli m̃isij tevi nuru tuwen osoni tweni Moses ko owrai tevi owra “Erpese, si elngi nik nga nik kuptur womue kem, ko nga kupwera suri lat nga puto suri tevi kem? ");
INSERT INTO upv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Rrek kumrreni kuprevjik pirpe kumrevji pini m̃eri Ijip ngok miniv?” ");
INSERT INTO upv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Daron nga Moses murnge nale ngok, ko owlu lingi Ijip. Ko ean elik erpe jinibb neturvitan renge vanu ne Mitian. Ko natun nuru ora-iak ko ie. ");
INSERT INTO upv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Sia ngavöl ivij (40) easi, ko anglo san errmali ji Moses renge duru nai nga welili san nga m̃in, mori botwen nga Sinae. ");
INSERT INTO upv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses etaol lenglengen re sev nga m̃ilesi, ko oruj van mori nga p̃ilesi lilane. Ko etaol nga Atua erij tevi, ");
INSERT INTO upv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","owra “Inu nuvi Atua se b̃irtera som nir. Inu nuvi Atua se Epram, Aesak ko Jekop.” Mian ko Moses eririr temijpal ko emtutu nga pimteni. ");
INSERT INTO upv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ko Atua owrai tevi Moses owra “Kuplai tweni but nga kumrae renge nolo b̃elam, suri lat nga kumtur ngok e evi lat nga muon ko. ");
INSERT INTO upv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nulesi ko pa nga jinibb suk nga marlik Ijip nir arunge lengleng esij, ko nurongwose norongen nga muto jir, ko nuvini nga b̃elai twenir. Ko kupini, bokonim van Ijip. ");
INSERT INTO upv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ngok Moses nen kele kobbong nga m̃eri Isrel marungasi ko marwirr nale nga muwra “Erpese, si elngi nik nga kuptur womue kem ko kupwera suri lat nga puto suri tevi kem?”, Atua kobbong osusture ni. Okoni anglo nga miplari ji Moses renge nai ngok nga nabb muroror rengen mare nga pususture ni pivini pivi jinibb nga milep ser, ko nga piwilwil se nir. ");
INSERT INTO upv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ngok ololi nanu nga marinijnij nawone nir Ijip, ko etkai tweni m̃eri Isrel nir Ijip van re dis nga musongsong e. Ko etkair kele sia ngavöl ivij (40) van renge lolo merwer, ko ololi nanu nga marinijnij nawone nir kele wor. ");
INSERT INTO upv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ko Moses ngok kobbong nga muwrai tevi m̃eri Isrel nir nga muwra ‘Atua pususture propet san re kami pirpe nga mususture inu. Ko ni pivi kele san re kami san.’ ");
INSERT INTO upv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses ngok ko etkai jinibb nir ko eser kortonir renge lolo merwer, mian ko anglo erij tevi renge botwen ngok nga Sinae. Iok ko, Atua elai nale ne mauren tevi nga pivini pivijngeni tevi kerr. ");
INSERT INTO upv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ko b̃irterawarreng se kerr nir armusus parosuri Moses. Arong tweni nale sen ko arrorrmi lenglengen nga parluwi kele van Ijip e. ");
INSERT INTO upv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ko arwerai tevi Eron arwera “Wurru, kupmajing ta atua sopor nga parwowomu ko kerr rrapok-vijuri. Suri Moses ngok nga m̃itkai tweni kerr Ijip nga rrapini iel, ko rramrreleng vajine, erpese rengen.” ");
INSERT INTO upv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Renge daron ngok ko armajing nanu san nga marrongrrongi re natu buluk nga parsurövi erpe atua ser, ko arevji nanu rrum ko arloli nanen nga milep san. Arsurövi sev nga nevrer bbong m̃imajinge. ");
INSERT INTO upv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ko Atua esir duren tevir ko elinglingir arsurövi moju nir. Ngok erpe nga Naul On muwrai re naul se propet nir muwra ‘M̃eri Isrel nir, tetajer renge sia ngavöl ivij (40) renge lolo merwer kamok-revji nanu rrum nir nga kaploli sulsulen rengen, ko sete kamsurövi inu, ejki. ");
INSERT INTO upv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tetajer kamok-wosi devji ngok ne atua m̃inij ngok Molok tevi pija ne moju se atua ngok se kami Repan. Molok ko Repan ngok kamok-surövi nuru. Renge murrun ngok, inu boji tweni kami kapan ngasue re devjen van ngasu ngasue Bapilon. ");
INSERT INTO upv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Devji nga b̃irterawarreng se kerr nir nga marok-surövi Atua rengen otur tevir kele renge lolo merwer. Devji ngok kobbong Atua owrai tevi Moses nga p̃imajinge, ko armajinge suri norrngov nga Moses m̃ilesi. ");
INSERT INTO upv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Vitunen, daron nga b̃irterawarreng se kerr nir marvivitu suri Josua, arini nga parlai dan ngel. Ko nir arlai devji se Atua ngok tevir. Renge daron ngok, Atua oji tweni jinibb nir, ko arwolu lingi b̃irtera se kerr nir. Ko devji se Atua ngok oto osorsan ean ejpari daron nga Devet mivi batu numal. ");
INSERT INTO upv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Atua eir suri Devet, ko Devet ongoni nga poro orongwose p̃imajing naim rres san nga m̃eri Isrel nir parok-surövi Atua rengen vajin. ");
INSERT INTO upv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ko mian ko Devet sete emajinge, ko Solomon ma emajing naim nen tevi Atua. ");
INSERT INTO upv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ko ewretun, Atua ngok nga mian mare temijpal sete orongwose p̃ilik renge naim nga jinibb m̃imajinge, erpe nga propet muwrai daron nga m̃irij renge nise Numal muwra ");
INSERT INTO upv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Melrin evi nai seksakel suk, ko iel ngatan evi lat nga b̃ejingteni b̃elak ren. Naim nga mirpese ko san kuwra kupmajinge tevik? Ngabe mawos ko inu bea-mosi ren? ");
INSERT INTO upv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Inu numajing nanu totoklai nir.’ ");
INSERT INTO upv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“O, batu kami eterter p̃elak, norrorrmien se kami erpe bbong jinibb ne vare nir! Sete kamrongwose kaprunge nale, ko kamsorsan tevi b̃irtera se kerr nga tetajer kamok-palpal tere Nem̃in On. ");
INSERT INTO upv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","B̃irterawarreng se kerr nir arloli sel nga m̃isij milep tevi propet p̃etp̃eti ne tuwi nir. Arevji pini propet nga muwra visviseni m̃er nga muosuri Atua nga pia-vini vitu, ko lelingenok kamtere ni ko kamrevji pini. ");
INSERT INTO upv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Anglo nir arlai nale nesesreien se Atua vini tevi kami, ko setewor kamosuri.” ");
INSERT INTO upv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ko daron nga jinibb ne gortien ngok marunge nale se Steven, nolor eirarsi ko arorrliw tevi. ");
INSERT INTO upv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ko Steven owun saut e Nem̃in On, ko oklu van mare renge melrin; ko elesi nosrövien se Atua, ko Iesu kele nga mutur renge devjen rres ji Atua. ");
INSERT INTO upv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mian ko owra “Inu nulesi metali ne melrin etp̃ir, ko Jinibb Mawos otur renge devjen rres ji Atua.” ");
INSERT INTO upv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mian ko jinibb ne gortien ngok arkikail van mare ko artop ore boror, ko arwolu mawose Steven. ");
INSERT INTO upv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ko arrul totkoni musuw, ko arevei tweni renge ngaim ngok, ko arok-tuwtuwe nevöt e vajin. Ko nir nga marij tere Steven aruri tweni sunsun ser sopor ko arlai tevi m̃elakel san, nisen Sol, nga ni pimetmete; mian ko artuwe vajin Steven. ");
INSERT INTO upv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ko daron nga jinibb nir marok-tuwtuwe suri kele, ko Steven everus owra “Wurru Numal Iesu, kuprunge drrelak ko kuplai inu nem̃ik pivinuk piptevim.” ");
INSERT INTO upv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mian ko ejipa van ngatan ko ekail van mare owra “Numal, sete kupvirrvirrali nir renge sev nga marloli ngok.” Daron nga muwrai jijle mirpok musuw, ko osrow pini. ");
INSERT INTO upv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ko Sol elesi erres kobbong nga martuwe pini Steven. Ko renge nabong mawos ngok, Sol tevi m̃eri Isrel nir artipatun nga parloli p̃isij pilep tevi kalesia nir nga marlik Jerusalem. Ko kalesia nir arwolu lingi ngaim ngok ko arwolu van renge vanu karkar nga Jutia ko Sameria, ko nir esngavöl drromon eru nga marivi aposol kobbong arlik jer Jerusalem. ");
INSERT INTO upv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ko m̃eri Isrel sopor nga marvijuri lilane Atua arunge esij suri Steven, ko arlai niben ko artengsi ko aran artevni. ");
INSERT INTO upv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ko Sol olokloksi torrlai kalesia nir, ko etkai jinibb sen nir arivel karkar Jerusalem renge naim nir ko arrul totoni kalesia nir, norman ko nesevin kele, ko arlingir van renge naim ne nekaien. ");
INSERT INTO upv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ko daron nga Steven mimij, jinibb se Atua nir arwolu lingi Jerusalem, aran lat karkar ko arvisviseni suri nise Iesu. ");
INSERT INTO upv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ko jinibb san, nisen Pilip, ean kele renge ngaim nga milep ne Sameria ko ewerwer suri nise Iesu, nga mivi Mesaea. ");
INSERT INTO upv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ko jinibb p̃etp̃eti renge ngaim nen armerreni parunge lilane nale se Pilip, suri arunge nale sen nga m̃irres ko arlesi nelesien nir nga ni mulolir nga marviseni derteren se Atua tevir iok. ");
INSERT INTO upv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nir elep nem̃in nga marsij marsisilvir, ko nem̃in nga marsij nen arkail van mare ko arivare lingir arivel. Mian ko Pilip ololi nir elep nga devje niber marmij arres luwi, ko nir nga sete marongwose parivel arivel luwi kele. ");
INSERT INTO upv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ko nir nga marlik iok daron nga marlesi ko arir lenglengen. ");
INSERT INTO upv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ko renge ngaim ngok kele, jinibb san nisen Saemon elik iok nga muloli botut sen, jinibb marok-taole bonevis pa. Ko okwera kele erpok “Inu nuvi jinibb m̃inij san tevi derteren lele nir.” ");
INSERT INTO upv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ko nir jijle renge ngaim ngok nga marivi jinibb ko nga marivi jinibb nawon kele, arosuri sev nga muwrai, mian ko arwera “O, ewretun morok derteren se Atua eptevi.” ");
INSERT INTO upv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ko arok-murronge ni daron elep pa nga ni mokloli marok-taole nanu nga mokloli nir. ");
INSERT INTO upv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ko vitunen, daron nga Pilip mian m̃iwerwer tevir suri batun vanu se Atua nga pia-pelari ko suri Iesu Kristo, arunge nale sen. Ko ni epaptaese nir, ngok nesevin ko norman. ");
INSERT INTO upv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ko Saemon kele osuri nale se Pilip, ko arpaptaese ni. Ko ngabe nga Pilip mian e, ko Saemon kele eptevi; ko daron nga m̃ilesi nanu nga marinijnij nawone nir nga miviseni derteren se Atua nga Pilip muloli, ko etaol ko eririr. ");
INSERT INTO upv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ko aposol nir esngavöl drromon eru nga marlik iok Jerusalem arunge nale suri m̃eri Sameria nga marosuri pa nale se Atua osuw, mian ko arkoni Pita ko Jon nga poran jir. ");
INSERT INTO upv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mian ko oran jir, ko daron nga morpelari jir, ko orlot nga Atua p̃ilai Nem̃in On tevir. ");
INSERT INTO upv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Suri Pilip epaptaese nir renge nise Iesu Kristo kobbong, ko Nem̃in On setewor ean renger. ");
INSERT INTO upv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ko Pita ko Jon orlingi nevre nuru renge batu nir, mian ko Nem̃in On ean esilvir vajin. ");
INSERT INTO upv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ko Saemon daron nga m̃ilesi aposol ngel nuru morlingi nevre nuru renge batu nir ko Nem̃in On m̃isilvir, otur mera ko elai nevöt nga milep vini ko esareni tevi Pita ko Jon ko owra tevi nuru owra ");
INSERT INTO upv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ei, kopor-lai kele derteren ngok tevik bevel tevi, ko jinibb si nga b̃elngi nevrek rengen, ko ni kele Nem̃in On p̃isilvi.” ");
INSERT INTO upv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mian ko Pita owrai lweni tevi owra “E, nik kurongwose kupwuli sev nga Atua m̃ilai nawone tevi jinibb? Nik tevi nevöt som koporan korti renge nejijkien! ");
INSERT INTO upv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Sete kuma-pitevi kem rragrrag renge majingen ngel, suri nolom sete osorsan renge no Atua. ");
INSERT INTO upv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kuprieni nolom renge sev nga komok-loli ngok, ko kuplot van ji Atua nga ni p̃itlasi nik renge murrun nga komok-loli mirpok. ");
INSERT INTO upv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Suri inu nurongwose nga lol leplep nga marsij elep arto nga demij muloli markikair renge nolom.” ");
INSERT INTO upv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mian ko Saemon owrai tevi Pita ko Jon owra “Wurru laru, koporlot suri inu nga Atua p̃ilai se inu, nga nanu nga m̃isij nga komor-werai ngok sete p̃irrmali ji inu.” ");
INSERT INTO upv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mian ko aposol nga nuru orsup̃e nale se Atua tevi jinibb nir ko sev nga morlesi Numal muloli, ko vitunen morsuw, orivel lingi ie ko orluwi van Jerusalem e. Ko daron nga morivel suri sel, orok-werwer suri nosp̃en nga m̃irres se Iesu Kristo renge ngaim elep nga Sameria. ");
INSERT INTO upv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ko anglo se Atua san eplari ji Pilip ko owra “Pilip, kupan iak ko kupiel van renge sel nga m̃itipatun Jerusalem ko mian Gasa e.” Sel ngok easi renge lolo merwer. ");
INSERT INTO upv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mian ko otur mera ko evel van. Daron nga miplari, ko elesi m̃eri Etiopia san esakel renge lem̃etiti sen, ko okwolu suri sel vini. M̃ernen artevei evi demaw, ko evi jinibb nga milep san nga mokmetmete nevöt se kwin nga Etiopia nga marveruse nisen kele san Kantes. M̃ernen ean Jerusalem nga pulot tevi Atua. ");
INSERT INTO upv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ko daron nga musuw ko esakel renge lem̃etiti nga pulwi, ko okeve naul se propet Aesea. ");
INSERT INTO upv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mian ko Nem̃in On erij tevi Pilip owra “Pilip, kupan mori lem̃etiti ngok ko kupiel jelin.” ");
INSERT INTO upv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ko Pilip ean ko okivel mori lem̃etiti nen. Ko ornge m̃ernen mokeve nale se propet Aesea. Mian ko Pilip owra tevi m̃er nga owra “E, nik kurongwose, nale nga komok-eve ngok owra puwra sev?” ");
INSERT INTO upv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ko m̃er nga owra “Borongwose pirpese? Poro jinibb san pivisviseni tevik, ko borongwose ko. Kupsa vini mare, ko kupvisviseni murru nale ngel tevik”. ");
INSERT INTO upv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ko nale se propet Aesea nen le ngel: ‘Erpe sipsip san nga marlai nga parevji pini, erpe natu sipsip nga martevei tweni silvin ko sete murongwose p̃iting, ko m̃ernen sete orongwose puwrai nanu san, ko omurrong kobbong. ");
INSERT INTO upv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ko nir arwer rrerrarre renge sel nga m̃isij. M̃ernen sete orongwos natun putoe, suri artor otvi mauren sen.’ ");
INSERT INTO upv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mian ko m̃eri Itiopa nen osusi tevi Pilip owra “Kupwerai ta tevik, isi ko ngok nga propet ngok moksup̃e suri ngok? Oksup̃e ni kobbong, rreknga oksup̃e jinibb m̃inij kele san?” ");
INSERT INTO upv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ko Pilip esa jingon ko osp̃e suri nale se Aesea ngok ko suri nosp̃en p̃etp̃eti nga m̃irres suri Iesu Kristo. ");
INSERT INTO upv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Orjilwer ortajer orini, ko orremali renge nuwi seser nga welili san. Ko m̃er nga osusi tevi Pilip owra “E, kulesi, rromor-pelari renge nuwi le ngel. Ko nik kurrorrmi erpese? Sev ejki nga poro parpaptaese inu?” ");
INSERT INTO upv_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mian ko Pilip owrai tevi “Poro weretunen wor nga nosurien oto renge nolom, ko erres nga inu bepaptaese nik.” Ko m̃er nga owra “O-o, o-o, inu nuosuri nga weretunen jerjer, Iesu Kristo evi Atua natun.” ");
INSERT INTO upv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Daron nga muwrai jijle musuw ko owrai tevi m̃er nga moklai lem̃etiti nga pumosie mun, mian ko nuru Pilip orjubbul ko oran ngatan re nuwi. Ko Pilip epaptaese ni. ");
INSERT INTO upv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ko daron nga morivel lingi nuwi vini lat nga mimes e, ko Nem̃in On eteseni tweni Pilip evel, ko m̃er nga setemun elesi. Mian ko ean esakel luwi renge lem̃etiti sen, ko nolon eir nga eir vajin daron nga lem̃etiti mokwolu tevi m̃itajer. ");
INSERT INTO upv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mian ko Pilip etaole nga mijpari ngaim nga Asot. Ko etajer kele nga mokwerwer e nosp̃en nga m̃irres se Atua renge ngaim m̃inij nga marto surusrir iok, ko etajer malum van ko ejpari vajin ngaim nga Sisaria. ");
INSERT INTO upv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ko renge daron ngok, Sol oksur terter nga pirevji pini nir nga marok-osuri Numal. Ean elesi batbatu jinibb ne sulsulen, ");
INSERT INTO upv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ko osusi tevi, mian ko batbatu jinibb ne sulsulen oli naul sopor se nir nga marok-metmete naim gortien nir renge ngaim nga Damaskas, ko elair tevi Sol. Ko nale nen erpel: ‘Nukoni m̃erel Sol nga pivinuk p̃ilesi norman rreknga nesevin si nga mivijuri sel nga mimerr ngok, ko p̃isre totkonir ko piptei lwenir vini Jerusalem e.’ ");
INSERT INTO upv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ko Sol elinglingi Jerusalem nga pian Damaskas e. Ko daron nga mivini morie ngaim ngok, ko etaole moron nga milep san miplari renge melrin vini, ko mumor vaseni lat nga mivel e. ");
INSERT INTO upv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ko ewajeni ngatan, ko ornge drrelan san owrai tevi owra “Sol o, Sol! Suri sev komok-loli m̃isij tevik mirpok?” ");
INSERT INTO upv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ko Sol osusi lweni, owra “Wurru, Numal, nik si ko?” Ko drrelan nga owra lweni, “Inu le Iesu nga komok-loli m̃isij tevik. ");
INSERT INTO upv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ko kupmera, ko kupan ngaim Damaskas, ko iok jinibb san ni ko puwrai tevim sev nga kupa-loli.” ");
INSERT INTO upv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ko nir nga marok-ivel tevi Sol artur murrong, sete arwerai nale san. Nir kele arunge drrelan ngok, ko sete arlesi jinibb san. ");
INSERT INTO upv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ko Sol otur mera eleng raji meten, ko meten omot. Ko selen nir arevei ko arpitevi van renge ngaim nga Damaskas e. ");
INSERT INTO upv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ko Sol meten orrorr erpok ejpari nabong itul, sete orongwos p̃ileslesi nanu san. Ko daron ngok kele, sete eaan ko sete eminmin. ");
INSERT INTO upv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ko renge ngaim ngok Damaskas, jinibb san nga mok-osuri Iesu, nisen Ananaeas. Ni elesi bori san nga Numal muwra tevi “Ananaeas!” Ko Ananaeas orrum, owra “Inu le ngel, Numal.” ");
INSERT INTO upv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ko Atua owrai tevi “Kupmera ko kupvijuri sel nga mivel otvi liven ne ngaim ngel nga nisen Sel nga mimetet, ko kupan re naim se Jutas. Ko kupsusi m̃eri ngaim ne Tasas san, nisen Sol. M̃ernen oklik ko oklot. ");
INSERT INTO upv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ko ni kele elesi bori san, ko elesi nga nik Ananaeas kuan kujpari meten, ko meten erres luwi kele.” ");
INSERT INTO upv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ko Ananaeas owrai lweni, “Wurru, Numal, nir elep pa marok-sup̃e suri morok, nga ni oklokloksi jinibb se Atua nir nga marlik Jerusalem. ");
INSERT INTO upv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ko renge iel Damaskas kele elai derteren sen ngok ji batbatu jinibb ne sulsulen nir nga pivini purrul totkoni jinibb si nga muosuri nik.” ");
INSERT INTO upv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ko Numal owrai tevi owra “Kupiel, suri inu nulngi ni nga p̃imajing se inu, ko puloli nisek pian mare ji jinibb ne vare nir ko numal nir ko ji m̃eri Isrel kele. ");
INSERT INTO upv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ko daron nga puloli majingen suk, inu bowrai visviseni sel nga m̃isij sev nga pia-sekai iok.” ");
INSERT INTO upv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ko Ananaeas ornge nale ngok nir, ko otur imare ko ean ji Sol renge naim se Jutas. Ean loloim ko elngi nevren re batu Sol, ko owrai tevi, “Niaken Sol, Numal nga mivi Iesu, nga miplari jim renge sel le, okoni inu nga bevini bololi kupkulu luwi kele, ko nga Nem̃in On kele puwun saut renge nolom.” ");
INSERT INTO upv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ko vesan rres nanu san erpe berte nai orvitan renge mete Sol, ko meten orkulu luwi vajin. Otur mera, ko sete epriv Ananaeas epaptaese. ");
INSERT INTO upv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ko eaan luwi ko jin eterter luwi vajin, ko elik nabong sopon kele tevi kalesia nir Damaskas. ");
INSERT INTO upv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ko sete epriv nga Sol etajer kele van renge naim gortien nir se m̃eri Isrel, ko etipatun nga p̃iwerwer suri Iesu nga ni evi natu Atua. ");
INSERT INTO upv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ko nir jijle nga marunge ni artaole ko arwera “E, m̃er nga moktorrtorrlai kalesia nir Jerusalem ngok, ko evini tweni nga purrul totkonir ko p̃itkair van ji batu jinibb ne sulsulen nir!” ");
INSERT INTO upv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ko Sol derteren ne nale sen emaur elep, ko eviseni nir e erres nga Iesu evi Mesaea. Ko m̃eri Isrel nir nga ie arwera parij otvi nale sen, ko arunge nale se Sol eterter p̃elak ko norrorrmien ser omrrol, ko arbbut kobbong. ");
INSERT INTO upv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ko nabong elep arasi, ko m̃eri Isrel sopor nga marlik iok arlolarsi Sol elep, ko armurri suri nga parevji pini. ");
INSERT INTO upv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ko nutrin ko nutpong kele, nir artirive Sol renge metali ne nawot nga milep nga m̃irrale ngaim ser, nga parevji pini. Ko jinibb san ean owrowra tweni womue norrorrmien ser tevi Sol. ");
INSERT INTO upv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ko natpong san jinibb se Sol nir arpitevi ko arsongni renge narr nga milep san, ko arjuröni rrurrngi renge lat nga m̃itp̃ir e san renge nawot van ngatan e. Erpok ko Sol eivare ko owlu. ");
INSERT INTO upv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ko Sol evel lingi Damaskas ko olwi van Jerusalem e. Ko owra pukorti tevi jinibb se Iesu nir; ko nir sete arosuri nga ni evi kalesia, ko arwij ngasue. ");
INSERT INTO upv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ko Banapas ewilwil sen, ko eptei van liven ji aposol nir. Ni owra visviseni tevir erpese nga Sol m̃ilesi Numal renge sel, ko nga Numal kele m̃irij tevi. Ni owrai kele tevir erpese nga Sol sete mimtutu nga pusp̃e suri nise Iesu iak Damaskas. ");
INSERT INTO upv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ko Sol elik tevir ko arongwose vajin, ko arkorti tevi vajin. Ko evel lat p̃etp̃eti Jerusalem, ko sete emtutu nga poksup̃e suri nise Numal. ");
INSERT INTO upv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol ewerwere nale kele sopor tevi m̃eri Isrel nir nga marlik ngasue vanu ser nga marongwose nale se m̃eri Gris nir, ko vitunen marini marlik Jerusalem. Ko nir sete armerreni nale se Sol ko arlatlat tevi suri. Ko sete epriv nir arlolar ko arwera parevji pini. ");
INSERT INTO upv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ko daron nga kalesia marunge nale nga m̃eri ie marwera parevji pini Sol, ko artekai van ko arlingi elik talev Sisaria. Ko vitunen arkoni tweni van sisen e Tasas. ");
INSERT INTO upv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ko renge daron nen, kalesia nir nga marlik sarrsarr renge vanu ne Jutia, Galili ko Sameria arlik renge demat. Ko Nem̃in On elai derteren tevir, ko nir arlik eterter nga marosuri Numal. Ko nir elep temijpal malum arini nga marosuri Numal vajin. ");
INSERT INTO upv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ko Pita otutur errale lat sopon, ko daron san evan ji jinibb se Atua nir ne ngaim ngok Lita. ");
INSERT INTO upv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Re ngaim ngok, eskai jinibb san nga niben mimij mijpari sia owil ko pa osuw nga sete orongwose pivel, ko okmatur kobbong re maling sen. M̃ernen nisen Aeneas. ");
INSERT INTO upv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Mian ko Pita owrai tevi owra “Aeneas, lelingen wolok ko pa Iesu Kristo puloli kuprres luwi. Kuptur mera kuplulngi maling som!” Ko vesan rres Aeneas otur imare. ");
INSERT INTO upv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ko nir jijle nga marlik re ngaim ne Lita ko re kele vanu ne Saron, daron nga marlesi, ko arieni norrorrmien ser ko arvijuri Numal se kerr. ");
INSERT INTO upv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ko nesevin san elik re ngaim ngok Jopa, nisen Tapita (nais ngok owra puwra die, nanu rrum san. Re nale se m̃eri Gris nir, arveruse Dokas). Vinnen osuri Atua ko tetajer okloli majingen nga marres nir ko okwilwil se kele nir nga joror marjikie. ");
INSERT INTO upv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Re daron ngok mesien san ololi, mian ko emij. Ko arrawe lilane niben, ko arlingi renge loloim san kele mare renge naim sen tera nga partevni. ");
INSERT INTO upv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ko Jopa oto mori bbong Lita ko sopon; ko daron nga jinibb se Iesu nga Jopa marunge nale nga Pita m̃ilik Lita, ko arkoni nuru eru oran jin tevi nale ngel nga muwra “Wurru kupsaro ta pingavilvil sopon, kupini kuplesi kem iel.” ");
INSERT INTO upv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mian ko Pita otur imare ko eptevi nuru aran. Daron nga marjipari ie, ko arpitevi van re loloim ne naim nen mare. Iok, nesevin nga diwen ser marmij lingir arser rrale, ko arok-ting ko arok-sareni sunsun ko nijor nga Dokas m̃imajinge daron nga mimaur malum e. ");
INSERT INTO upv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mian ko Pita okoni twenir, ko ejiol vitan ko olot. Olot jile ko erieni non mawos vin nga mimij nga ko everuse, owra “Tapita, kupmera!” Tapita eleng raji meten, ko daron nga m̃ilesi Pita, ko emra elik. ");
INSERT INTO upv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ko Pita otori nevren, esa raji nga putur. Mian ko everuse jinibb se Iesu nir tevi nesevin nga diwen ser marmij lingir, ko elngi lweni vin nga mimaur luwi nga tevir. ");
INSERT INTO upv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nosp̃en ne nanu ngok owlu p̃etp̃eti re ngaim ngok Jopa, ko jinibb elep kele arini arosuri Numal. ");
INSERT INTO upv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ko mian ko Pita elik eprepriv kele sopon Jopa tevi m̃er san nga mokmajinge nanu nir renge nevlu buluk, nga nisen Saemon. ");
INSERT INTO upv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ko renge ngaim ngok Sisaria, m̃eri Rom san elik nga nisen Konilias, nga mimetmete jinibb nuval nir ongut (100) se m̃eri Rom nir, nga marivi ne gortien nga marveruse gortien ne Itali. ");
INSERT INTO upv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ni evi jinibb san nga mukorti pa tevi m̃eri Isrel nir mok-surövi Atua, tevi jinibb nir ne naim sen kele; ko oklai kele merrenien elep tevi m̃eri Isrel nga joror ewelili. Ko tetajer oklot van ji Atua. ");
INSERT INTO upv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ko nabong san, otomori pivi mete nial itul nga rivriv, omomsawose daron ne verusen, ko elesi nanu san erpe bori. Renge bori nen elesi oto limjer nga anglo se Atua san evini loloim sen ko everuse, owra “Konilias”. ");
INSERT INTO upv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias emet teretre anglo ko emtutu lenglengen, ko owra “Wurru, Numal, kupej sev ko san?” Ko anglo erij weli owra “Atua eir temijpal renge loten som ko majingen ne merrenien som, ko etriv nga piwilwil som. ");
INSERT INTO upv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","“Ko kupkoni jinibb sopor paran Jopa ko parveruse jinibb san nga pivini mun iel. M̃ernen nisen arveruse Saemon Pita. ");
INSERT INTO upv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Elik tevi jinibb san nga mokmajinge nanu nir renge nevlu buluk, nga nisen kele Saemon. Naim sen oto ngatan mori jeli dis.” ");
INSERT INTO upv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mian ko anglo evel lingi. Ko Konilias everuse jinibb ne majingen sen eru vini, ko jinibb nuval nga mokmajing sen ko nga moklot kele, nga nir p̃itul parini jin. ");
INSERT INTO upv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ewer visvisenir suri sev nga m̃irrmali, ko okoni tweni nir itul ngok van Jopa e. ");
INSERT INTO upv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ko renge nabong m̃inij nen, arvijuri sel vini re ngaim ngok Jopa. Ko re daron mawos nen, Pita esa van mare renge drru naim nat milival nga pulot. ");
INSERT INTO upv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mian ko numer eaji elep, ko emrreni lengleng purroi nanu san. Ko daron nga marok-loli nanen ser e, ko ni elesi bori san nga Atua miviseni tevi. ");
INSERT INTO upv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Elesi melrin etp̃ir, ko boriti nga milep san, artori renge bongsin nga ivij, ko arjuröni renge melrin vini iel ngatan e. ");
INSERT INTO upv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Renge boriti nen, netun vanu jijle nir ko numön jijle nir arto ren. ");
INSERT INTO upv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ko drrelan san errmali ko owrai tevi owra “Pita, kuptur imare, kuprevji nanu ngok nir ko kupurroir.” ");
INSERT INTO upv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ko Pita erij weli owra “Numal, sete mea-loli mirpok, suri setewor nurroi lesi nanu san nga murrokitkit, ko sete musorsan mirpok nga borroi.” ");
INSERT INTO upv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mian ko drrelan nen eplari kele jin owra “Sev nga inu Atua mowrai pa tevim nga owokwok, nik sete kurongwose kupwera orrokitkit kele.” ");
INSERT INTO upv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Drrelan nen owra lweni nale nen vatul musuw, ko boriti nen emtaw lingi ko olwi van re melrin e. ");
INSERT INTO upv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita nolon orrum malum suri bori ngok, owra purongwose sev nga Atua miviseni tevi ngok. Ko jinibb itul nga arsusi rongornge pa naim se Saemon lut nga mutur e, arongwose, ko re daron nen mawos nga Pita murrorrmi bori sen, artur rremali renge metali. ");
INSERT INTO upv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ko arsusi arwera “Moi, Saemon Pita elik niko iok rreknga ejki?” ");
INSERT INTO upv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mian ko Nem̃in On owrai tevi Pita owra “Jinibb itul arini pa nile, arpej nik. ");
INSERT INTO upv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kupsaro pingavilvil, kupjubbul van ngatan e. Sete kuprrorrmi nanu san, suri inu ko nukonir.” ");
INSERT INTO upv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita ojubbul, ean ngatan e, ko owrai tevir owra “Inu nen le nga kamok-peje inu. Suri sev kampej inu?” ");
INSERT INTO upv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ko nir arwerai lweni arwera “Numal Konilias ko okoni kem. Evi jinibb nga m̃irres nga moksurövi Atua. M̃eri Isrel kele armerreni ni. Anglo se Atua nga muon ko san owra Konilias pukoni kem vinuk jim nga puloli purnge sev nga kupwerai.” ");
INSERT INTO upv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ko Pita etkair arlik tevi ko armatur tevi. Ko rorpong nen, Pita tevi m̃eri Sisaria nen itul arlinglingi ngaim ne Jopa, arivel kele, ko nir sopor nga marosuri Iesu renge vanu ngok arpitevir kele. ");
INSERT INTO upv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Renge nabong m̃inij nen arjipari Sisaria; ko Konilias etriv terair ko pa. Erijrij kele metka sen ko selen nga marres nir nga parkorti partiriv Pita. ");
INSERT INTO upv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Daron nga Pita m̃irrmali vajin, ko Konilias otur imera ko evini ejiol vitan jin. ");
INSERT INTO upv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ko Pita owrai tevi owra “O, sete kuploli pirpok tevik, kupmera, inu nuvi kele bbong jinibb le!” Ko Pita ervei nevre Konilias otur rramos. ");
INSERT INTO upv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ko Pita okjiljilwer tevi Konilias, ko orivel korti oran loloim e. Ko Pita elesi erpe jinibb elep aran pa loloim e. ");
INSERT INTO upv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ko owrai tevir owra “Kamrongwose erres nga m̃eri Isrel renge gortien ser sete arongwose parkorti rreknga parpelari ji jinibb ne vare nir. Ko Atua eviseni tevik nga sete nurongwose b̃elesi jinibb sopor erpe arrokitkit rreknga arsij. ");
INSERT INTO upv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Niko ololi daron nga kamverus nga bevinuk, ko sete nuloli kele nale san, ko nutur imera ko pa ko nuvini. Ko nuwra bosusi tevi kami, kamverus inu suri sev ko?” ");
INSERT INTO upv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ko Konilias erij weli owra “Nabong itul le pa easi, erpe pivi mete nial itul natmirivriv san, ko nomok-lot iel renge naim suk. Ko vesan rres jinibb san sunsun sen arinrin nawon evini otur renge nok. Ko owrai tevi inu owra ");
INSERT INTO upv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Konilias, Atua ornge pa verusen som ko okrrorrmi elep suri merrenien som nga komok-lai tevi jinibb nir nga joror mijkie. ");
INSERT INTO upv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kupkoni jinibb sopor paran Jopa, parlesi jinibb san nisen Saemon Pita. Elik renge naim se jinibb san nga nisen kele Saemon, nga mivi jinibb nga mokmajinge nanu nir renge nevlu buluk. Naim sen oto mori jeli dis ngalu.” ");
INSERT INTO upv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ko nusaro ngavilvil ko nukoni jinibb suk arinuk jim, ko erres wor nga kumrunge sev nga marwerai ko kuvini. Kem jijle namlik korti vajin renge no Numal Atua ko nabrunge vajin sev nga kupwerai.” ");
INSERT INTO upv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ko Pita esa jingon owra “Lelingenok inu nua-lesi wose vajin nga weretunen Atua ololi osorsan kobbong tevi jinibb jijle. ");
INSERT INTO upv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Atua eir temijpal tevi si nga musrövi ni ko muloli sev nga musorsan m̃irres, poro evel renge vanu ngabe tama san. ");
INSERT INTO upv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nale ngok kele kobbong Atua elai tevi jinibb sen nir m̃eri Isrel, daron nga mukoni Iesu Kristo Numal se jinibb jijle nir nga p̃ilai demat tevi nir. ");
INSERT INTO upv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ko rrek kamrongwose sev nga miplari ji Iesu Kristo lat jijle re vanu ne Jutia. Nanu ngok jijle artipatun Galili, daron nga Jon muwra jinibb jijle nir parpaptaes. ");
INSERT INTO upv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Atua elai Nem̃in On ko derteren tevi Iesu doNasret, ko Iesu daron nga mokivel rrale mokloli majingen nga marres nir, ko ololi nir nga marlik renge derteren se Demij nir arres luwi kele. ");
INSERT INTO upv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kem jijle namlesi sev nga Iesu muloli Isrel ko re ngaim nga Jerusalem kele. Ko jinibb nga marlelep se nir arwuse re nai pelaot nga pimij. ");
INSERT INTO upv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ko nabong itul easi, ko Atua ololi emaur luwi kele re mijen. Ko eviseni ni tevi kem nga m̃ilngi kem nga nabsupsup̃e ni tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Atua sete eviseni ni tevi jinibb jijle nir, ko tevi kem kis kobbong daron nga mimaur luwi renge mijen, ko kem namaan korti ko namminmin korti tevi ni. ");
INSERT INTO upv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ko Atua owrai nga nabwerai tweni ko wor nosp̃en nga m̃irres tevi jinibb nir. Ko kem nabwerai tweni ko wor nga Atua elngi pa ni nga pia-wera suri lat nga puto suri tevi jinibb jijle nir, ngok nir nga marmaur malum lelingenok, ko nir nga marmij pa musuw. ");
INSERT INTO upv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ko propet jijle arok-rrorrmi ni kobbong, ko arwera suri nga nise Iesu kobbong, derteren nen otoe; ko jinibb nga marosuri ni, Atua pia-telasi tweni nololien ser.” ");
INSERT INTO upv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Daron nga Pita mokrij malum e, ko Nem̃in On ojubbul vitan ko esilvi nir nga marok-murronge nale sen. ");
INSERT INTO upv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ko m̃eri Isrel nga marosuri Iesu nga marlinglingi Jopa tevi Pita artaol ko aririr lengleng renge sev nga miplari, suri Atua elai Nem̃in On tevi jinibb ne vare nir erpe merrenien nga milep san tevi nir. ");
INSERT INTO upv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Artaol temijpal suri arok-runge nir ngok arok-rij renge nale lele, nga marok-surövi nise Atua. Mian ko Pita owra ");
INSERT INTO upv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nir ngok arlai Nem̃in On pa erpe kerr rramlai pa musuw. Ko siko orongwose p̃iwer orer nga sete parpaptaese nir?” ");
INSERT INTO upv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ko Pita owrai tevir nga parpaptaese nir renge nise Iesu Kristo. Mian ko nir arngoni nga poro Pita orongwose p̃ilik mun beblen kele tevir. ");
INSERT INTO upv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ko aposol tevi tuwa kerr ko joji kerr nir re lat jijle re vanu nga Jutia arunge nosp̃en nga jinibb ne vare kele arlai pa nale se Atua kele osuw. ");
INSERT INTO upv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ko daron nga Pita mian Jerusalem e, ko m̃eri Isrel sopor artortori, arwera jinibb ne vare nir nga marivi kalesia paran ko wor re bae. ");
INSERT INTO upv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Arwera “E, suri sev komok-pitevi nir nga setewor maran re bae ko komok-aan kele tevir?” ");
INSERT INTO upv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mian ko Pita owrai tweni vajin tevir nanu mawos nen nga m̃irrmali, ");
INSERT INTO upv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","owra “Daron nga nomok-lot renge ngaim ngok Jopa, mian ko numatur, ko nulesi bori san. Nulesi nanu san nga mirpe boriti nga milep san, artori renge bongsin nga ivij ko arjuröni renge melrin vini iel ngatan e, ko evini mori inu. ");
INSERT INTO upv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Numteni lilane nolo boriti ngok, ko nulesi netun vanu jijle nir ko numön jijle nir. ");
INSERT INTO upv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mian ko sete epriv nurnge drrelan san owrai tevik owra “Pita, kuptur imera, kuprevji ko kuprroi.” ");
INSERT INTO upv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ko inu nuwra “Ejki Numal, ejki rres. Nanu ngok sopor sete arsorsan ko sete arwokwok nga borroi, ko setewor nurroir nabong san.” ");
INSERT INTO upv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ko sete epriv, nurnge drrelan nen eplari kele vini owra “Nanu nga inu Atua mowrai pa musuw nga owokwok, nik sete kurongwose kupwera orrokitkit kele.” ");
INSERT INTO upv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Drrelan ngok errmali erpok vatul osuw, ko boriti nen tevi nanu jijle arevei lweni kele van re melrin e. ");
INSERT INTO upv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ko renge daron mawos nen, jinibb itul arini re naim nga nulik ren. M̃eri Sisaria san okonir nga parini partekaik nga bolwi tevi nir. ");
INSERT INTO upv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ko Nem̃in On owrai tevik sete bongasi nir ko bemarong ma bolwi tevir. Ko tuwa kerr nga ouwon ngok kele arpitevi inu. Ko daron nga nampelari Sisaria, ko kem jijle naman loloim re naim se m̃erak Konilias. ");
INSERT INTO upv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mian ko ni owrai tevi kem nga ni elesi anglo san evan otur renge loloim sen, ko anglo owrai tevi owra “Kuplai nale van re ngaim ngok Jopa nga parveruse jinibb san nga nisen Saemon ko nisen kele Pita. ");
INSERT INTO upv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ni pia-wera nale tevi nik nga p̃ila mauren tevi nik ko tevi nir nga renge naim som kele”. ");
INSERT INTO upv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ko mian ko daron nga m̃etipatun vajin nga m̃erij tevir, ko Nem̃in On evini esilvir osorsan erpe nga mivini re kerr bonevis. ");
INSERT INTO upv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mian ko nurrorrmi jipari nale nga Numal muwrai tuwi nga muwra, ‘Jon ololi baptaes tevi nuwi; ko sete mia-periv, Atua pia-paptaese kami renge Nem̃in On.’ ");
INSERT INTO upv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ko oto limjer nga Atua elai merrenien ngok kobbong tevi jinibb ne vare nir, erpe nga m̃ilai tevi kerr daron nga rramosuri Iesu Kristo e. Ko erpese, inu nurongwose bololi lesi nga bewer ore Atua, rrek?” ");
INSERT INTO upv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Daron nga Pita m̃irij jile musuw, ko nir arlingi kurtweni norrorrmien karkar ser, ko nolor emra e ko arsurövi Atua arwera “Rrek Atua elai kele tevi jinibb ne vare nir norrorrmien ne parieni lululwenir ko parmaur vajin.” ");
INSERT INTO upv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Daron nga Steven mimij, ko jinibb nir aroji kele nir nga marosuri, ko nir arwolu sarrsarr. Sopor aran arjipari Ponisia ko Saepras ko Antiok ko arok-werai tweni nosp̃en nga m̃irres, sete tevi m̃eri m̃inij, ko tevi m̃eri Isrel kobbong. ");
INSERT INTO upv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ko nir sopor kele nga marivi m̃eri Saepras ko Saerin aran Antiok ko arwera tweni nosp̃en nga m̃irres se Iesu Kristo, Numal se kerr, tevi jinibb ne vare kele nir. ");
INSERT INTO upv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Derteren se Numal eptevir, ko jinibb elep arieni nolor arosuri Atua vajin. ");
INSERT INTO upv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ko nosp̃en ne nanu ngok owlu kele evan ejpari kalesia nga Jerusalem, mian ko nir arkoni Banapas van Antiok e. ");
INSERT INTO upv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Daron nga ni mian jir ko m̃ilesi erpese nga Atua m̃irij m̃irres suri jinibb ne ie nir, ko ni eir temijpal, ko owrai tevir nga partur p̃iterter renge nosurien ser ko weretunen renge Numal tevi nolor totoklai. ");
INSERT INTO upv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banapas evi jinibb nga m̃irres, nga muwun saute Nem̃in On ko nosurien, ko ervei jinibb elep arini ji Numal se kerr. ");
INSERT INTO upv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mian ko Banapas ean kele Tasas e nga pipej Sol. ");
INSERT INTO upv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ko daron nga m̃iskai, ko etkai oran Antiok e. Ko renge sia totoklai san, nuru orok-jiljilwer tevi kalesia ne ie ko orvisviseni nir elep kele renge gortien ngok. Ko renge ngaim ngok ko Antiok, arlingi womue nais ngok ‘Kristin’ re kalesia nir. ");
INSERT INTO upv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ko renge daron ngok, propet sopor kele arivel lingi Jerusalem aran Antiok. ");
INSERT INTO upv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nir nen san nisen Akapas, otur imera renge derteren se Nem̃in On ko ewer rrurrngi tevir nga daron ne numer nga m̃iterter san sete ngasu p̃irrmali renge ngatan ngel totoklai. Ko numer nen errmali erpe nga muwrai renge daron nga Klotias mutori batu numal ne Rom. ");
INSERT INTO upv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mian ko jinibb se Iesu nir armurri poro erres jinibb sisamis p̃ilai wor merrenien pilep van nga piwilwil se seler nir nga marlik Jutia. ");
INSERT INTO upv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mian ko arloli erpok, ko arlai nevöt sopon. Ko arlai tevi Banapas ko Sol nga poran porlai tevi jinibb nga marlelep se kalesia nir nga Jerusalem. ");
INSERT INTO upv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ko renge daron ngok kele, Numal Erot Akripa etipatun nga puloli p̃iterter kele tevi kalesia sopor. ");
INSERT INTO upv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Okoni jinibb sen nir nga paran parrul totkoni Jemes tasi Jon ko partai otvi batun. ");
INSERT INTO upv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ko suri nanu ngok ololi m̃eri Isrel nir arir, ko etajer kele ololi nale tevi jinibb sen nir nga parrul totkoni Pita. Nanu ngok errmali mawos re daron ne nanen ne niv nga is mijki ren. ");
INSERT INTO upv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Elngi Pita re naim ne nekaien, ko elngi gortien ivij ne jinibb ne nuval sen nir nga parlik metmete. Norrorrmien sen evi nga poro daron ne nanen gortien p̃iasi, ko ni pia-wera suri lat nga puto suri tevi ni re no delung nir. ");
INSERT INTO upv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mirpok ko Pita m̃ilik re naim ne nekaien. Ko kalesia nir arlot eterter van ji Atua suri ni. ");
INSERT INTO upv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Re natpong nen, ko vitunen nga Erot pia-wera suri lat nga puto suri tevi Pita renge no delung nir, Pita ematur liven re jinibb ne nuval nga mormetmete ni re naim ne nekaien tevi kele dil delrrurr eru nga markai nevren e, ko jinibb ne nuval eru kele ortur metmete metali. Ko Pita ematurrwel. ");
INSERT INTO upv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ko vesan rres anglo se Atua san otur pelari ie, ko moron omor vaseni jijle naim ne nekaien ngok. Ko esesaro ejpari neli Pita ko owni, ko owra “Kupsaro pingavilvil, kupmera.” Ko vesan rres, dil delrrurr ngok nuru orjiki re nevre Pita ko orvitan. ");
INSERT INTO upv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ko anglo owrai kele tevi owra “Kuptatuwe netatuw som ko kuprae but som, ko kupini rroporivel.” Pita ololi sev nga anglo muwrai, mian ko anglo owrai kele owra “Erres, ko kupuri kot som ko kupvivitu surik.” ");
INSERT INTO upv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ko Pita evivitu suri. Etla van vare e renge naim ne nekaien. Ko orrorrmi nga nanu ngok nir arirpe bbong ematur lesi bori ko. ");
INSERT INTO upv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mian ko orini orasi gortien eru ne jinibb ne nuval, ko orini vajin renge metali delrrurr nga muto ore jer ngaim nga jinibb pian vare e vajin. Ko metali nen esan etp̃ir, ko oran vare e. Orok-vijuri sel vini, ko vesan rres anglo emtaw lingi Pita, evel. ");
INSERT INTO upv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ko Pita elesi wose vajin sev nga m̃irrmali, ko owra “O, nulesi wose ko vajin nga Numal suk okoni anglo sen vini nga p̃itkai tweni inu re derteren se Erot ko re nanu jijle nga jinibb nga marlelep se m̃eri Isrel nir marrorrmi nga parloli tevik.” ");
INSERT INTO upv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ko ean re naim se Merri, nga mivi tasu se Jon nga nisen tuwen nen marveruse Mak. Ko nir elep nga marok-vijuri Numal arser korti ie nga parlot. ");
INSERT INTO upv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita evini otuti metali vare. Ko nesenwarreng nga mokmetmete naim, nga nisen Rota, evini owra p̃itasi. ");
INSERT INTO upv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ko ni etaole drrela Pita, ko orongwose evesane, ko eir temijpal suri. Ko setemun etasi metali, ko owlu luwi kele van ji nir sopon e nga marlot. Ko owrai tevir owra “E, lartul, Pita le ngel moktur vare renge metali!” ");
INSERT INTO upv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ko nir arwerai lweni tevi arwera “Ai, kulengleng!” Ko ni otur eterter owra “Ejki, nuwretun ko wor!”. Mian ko nir arwera “Ejki ma, rrekma nem̃in ko.” ");
INSERT INTO upv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ko Pita nga eplak malum, otuti metali, mianan ko artasi ko vajin. Ko daron nga marlesi ko artaol lenglengen. ");
INSERT INTO upv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ko Pita obbölbböleni nevren tevir nga parmurrong, ko owra visviseni tevir erpese nga Numal se kerr m̃ilai tweni ni re naim ne nekaien. Ko okonir vajin owra “Kapwerai kele tevi Jemes ko kerr sopor kele sev nga m̃irrmali”. Mian ko evel lingi ie van elik talev re lat m̃inij kele san. ");
INSERT INTO upv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mevinen vajin, ko jinibb ne nuval nir ara-taole arlesi Pita mijki; ko arrorrmi sarrsarre, arok-sususir e vajin arwera “E, Pita nga ean ngabe e?” ");
INSERT INTO upv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ko Erot okoni kele jinibb ne nuval sen nir nga paran parpej tevi, ko sete arlesi rragrrage te. Ko osusi kele norrorrmien elep tevi nir nga marmetmete, mijki mun, mian ko ololi arevji pinir. Mian ko sete epriv ko Erot evel lingi Jutia nga pian p̃ilik sopon Sisaria. ");
INSERT INTO upv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mian ko Erot ololarsi m̃eri Taea ko Saeton nir. Suri iok, nir ne ngaim nga eru ngok arkorti lat sansan nga paran parlesi. Ko womunen, arevei womue jinibb san nga mokmetmete majingen ne naim se Erot nga piptevir van, nisen Blastas. Ko nir arini ji Erot ko arngoni nga poro ni orongwose puloli demat, suri nir ne vanu ngok arok-wuli bbong nanen ser ko ji jinibb ne vanu se Numal Erot. ");
INSERT INTO upv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mian ko Erot elngi nabong san nga pia-lesi nir ren. Ko re daron nen vajin, Erot ojokjok erres temijpal re nijor se numal ko ean esakel re nai seksakel se numal, ko elai vajin nale tevir. ");
INSERT INTO upv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ko nir arkikail van mare arwera “O, sete jinibb ko m̃irij ngok, ko atua ko wor san.” ");
INSERT INTO upv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ko vesan rres, anglo se Atua san ololi Erot eil jubbul ngatan. Suri emrreni jinibb partori ko parsurövi ni pirpe kele atua san. Mian ko doto nir arpelari ko arurroi jinen, ko emij. ");
INSERT INTO upv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ko nale se Atua easasi elep kele, ko jinibb elep arini arosuri kele. ");
INSERT INTO upv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ko Banapas ko Sol oran orvinvini ore jijle majingen nga marlingi nuru tweni. Mian ko orivel lingi Jerusalem vajin orluwi. Orpitevi lweni Jon Mak tevi nuru. ");
INSERT INTO upv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ko kalesia sopor ne Antiok arivi propet ko jinibb nevisvisenien. Banapas, ko Simeon nga marveruse nibmotmot, ko Lusias kele nga mivi m̃eri Saerin, ko Manaen nga bonevis marmetmet kortoni ni ko Erot Antipas renge naim sansan, ko Sol kele. ");
INSERT INTO upv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ko daron san arlingi kurtweni nanen ko arsurövi Atua. Mian ko Nem̃in On erij tevir owra “Kapsusture Banapas ko Sol nga porloli majingen nga inu motobbtobbue nuru tweni.” ");
INSERT INTO upv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mian ko nir artajer nga arlingi kurtweni nanen, ko arlot. Ko sete epriv nir jijle arlingi nevrer renge nuru, ko arkoni tweni nuru nga poran porloli majingen. ");
INSERT INTO upv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ko niko Nem̃in On okoni nuru, ko orjubbul van ngatan e Selusia. Ko orsa re drrav san, ko drrav owlu tweni paran re sale san nisen Salamis nga muto re norour nga Saepras. ");
INSERT INTO upv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ko daron nga nuru morjipari vajin Salamis, ko orok-werai tweni nale se Atua re naim loten se m̃eri Isrel. Ko Jon Mak eptevi nuru nga m̃imajing se nuru. ");
INSERT INTO upv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ko nir nga itul ngok arivel otvi norour ngok van devjen e Papos. Ko renge ie, arlesi jinibb ne botut san, nisen Bajisas. Ni evi m̃eri Isrel san, ko evi propet ne gerisen san. Ko nisen kele san re nale Gris arwera Elimas. ");
INSERT INTO upv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ko ni evi kele jinibb se Sejas Polas nga mimetmete norour ngok Saepras, nga batun muwlu milep. Ko Sejas Polas ngok everuse Banapas ko Sol nga poran jin, suri emrreni purnge nale se Atua. ");
INSERT INTO upv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ko daron nga marini ko marij, ko m̃er ne botut ngok Bajisas, nga nisen tuwen nen Elimas, erij tere nuru ko ololi lesi nga p̃irieni norrorrmien se numal Sejas Polas, nga sete puosuri Atua. ");
INSERT INTO upv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ko Sol nga nisen tuwen nen Pol, owun saute Nem̃in On, ko emet teretre jinibb ne botut ngok, ");
INSERT INTO upv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ko owra “A, nik natu demij, kuvi botgerisen ko sel som arkipkap̃il, ko kuvi devje nuval se nanu jijle nga m̃irres! Seveling vajin kupa-suw re komok-rij tere sel weretunen se Numal? ");
INSERT INTO upv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lelingenok ko pa Atua putor aljem nga metem pumot, ko setemun kuma-lesi moron pipriv sopon.” Ko vesan rres nanu san nga mirpe nousnin nga mumotmot san evini ousni ore non, ololi meten omot; ko evel esesaro karkar epej jinibb san nga pok-tekai ni. ");
INSERT INTO upv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ko daron nga Sejas Polas m̃ilesi sev nga m̃irrmali ngok, ko etaol; ko eir temijpal re nale se Numal se kerr nga nuru morvisviseni tevi, ko osuri vajin Atua. ");
INSERT INTO upv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ko Pol tevi selen nir arlai drrav san Papos ko aran Pampilia, arwolu toku re ngaim ngok Peka. Ko renge ie, Jon Mak evel lingir ko olwi van Jerusalem e. ");
INSERT INTO upv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Arivel lingi vajin Peka, ko arjipari Antiok nga mori vanu ngok Pisitia. Ko renge nabong on, orsil van re naim loten se m̃eri Isrel nir ko orsakel ngatan. ");
INSERT INTO upv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ko daron nga mareve jijle Naul On musuw, ko nabur ser arkoni nir san van ji Pol ko Banapas ko osusi tevi nuru owra “E selek, poro norrorrmien nga m̃irres san oto niko nga komor-merreni kopor-werai nga piwilwil se jinibb nir, ko erres kopor-werai”. ");
INSERT INTO upv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ko Pol esareni nevren tevir nga parmurrong, mian ko owra “M̃eri Isrel nir ko kami jile nga kamok-surövi Atua, kapmurrong. ");
INSERT INTO upv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Atua se m̃eri Isrel nir otobbtobbue apu se kerr ne tuwi nir, ko osusi nir van mare daron nga marlik mirpe jinibb neturvitan re vanu ne Ijip. Ko tevi derteren nga milep jerjer sen, etkai twenir arivel lingi ie. ");
INSERT INTO upv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ko erpe sia ngavöl ivij (40) sopon erpok, ko arlik re lolo merwer, ko arok-loli batur sopon. Ko Atua sete emet twenir, ");
INSERT INTO upv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ko ololi metil ngaim ebut re vanu ngok Kenan armij ko elai dan ser tevi jinibb sen nir; ko arlik ren, ");
INSERT INTO upv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","evini ejpari sia ongut vavij bbulin ngavöl elim (450). Ko vitunen Atua osusture numal nir sopor nga parmetmete nir, eanan ejpari daron se propet Samuel. ");
INSERT INTO upv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ko marngoni kele batu numal san, mian ko Atua elai Sol nga mivi natu Kis re metka ngok Benjamin nga pivi batu numal ko putori vanu ser. Ko ni otori ejpari sia ngavöl ivij (40). ");
INSERT INTO upv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ko daron nga Atua m̃ilai tweni kele, ko osusture vajin Devet nga pivi batu numal. Ko Atua owrai norrorrmien sopon suri Devet owra “Nulesi Devet natu Jesi evi jinibb nga nolon oto suri inu nolok. Evi jinibb nga puloli nanu jijle nga inu memrreni puloli.” ");
INSERT INTO upv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ko osorsan erpe nga Atua m̃irijrij pae musuw, ni osusture metka se Devet san nga nisen Iesu nga ni pia-la mauren tevi m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ko daron nga Iesu sete miplari wor, ko Jon okwerwer pae ko tevi m̃eri Isrel nir owra ‘Kami kaprieni wor kami ko renge nololien se kami nir, ko kami jijle kappaptaes ko wor’. ");
INSERT INTO upv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Daron nga Jon mivini mori vajin renge bongsi majingen sen, ko oksusi okwera ‘Kami kamok-rrorrmi inu nuvi isi le? Inu sete nuvi m̃er nga kamok-tirive. Ko kapmurrong ta. Jinibb san pivini ni ko nga inu sete nuvter rragrrage nga b̃etlasi tweni dil renge but sen.’ ");
INSERT INTO upv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Tasik ko jojik nir, kami nga kampelari renge metka se Epram ko kami jinibb ne vare nir nga kamok-surövi Atua se kerr, kerr ngok ko, Atua elai pa nale nga p̃itasi sel nga p̃ila mauren tevi kerr jijle. ");
INSERT INTO upv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Daron nga Iesu mivini, ko m̃eri Jerusalem nir ko nabur ser nir arrelenge. Ko sete arongwose nale se propet kele nir nga marok-eve renge nabong on jijle nir. Iok ko ololi nir arlingi Iesu pian re mijen, mian ko arwera ni pimij ko wor, erpe nga propet nir marwerai wowomu pae musuw. ");
INSERT INTO upv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ko sete artor sweri sel san nga norrorrmien nen purrow puloli nga Iesu pian re mijen, ko artur imera ma ko arngoni tevi Numal Paelet nga pirevji pini. ");
INSERT INTO upv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ko daron nga marevji pini jijle re nai pelaot erpe nga Naul On muwrai, ko arjuröni vini ngatan e vajin, ko aran artevni renge dubb. ");
INSERT INTO upv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mian ko sete epriv nga Atua ololi emaur luwi kele renge mijen. ");
INSERT INTO upv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ko re daron elep, Iesu errmali ji jinibb sen nir nga moktutur tevir Galili van Jerusalem e, ko lelingenok vajin nir arok-wera tweni Iesu tevi m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Atua ololi pa rijrijen nen tevi apu se kerr nir osuw, ko kem namvijuri le vajin nga nabwerai tweni nosp̃en nga m̃irres nen tevi kami. ");
INSERT INTO upv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ko ololi pa tevi kerr nga rramivi metka nen daron nga muloli Iesu emaur luwi kele renge mijen. Erpe Naul On muwrai pa renge naul erwen ne Sam, muwra ‘Etipatun lelingen nik kuvi natuk woswos, ko lelingen inu bevi tata som woswos.’ ");
INSERT INTO upv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ko iok ko Atua muwrai pa re Naul On sen suri Iesu pimaur luwi kele re mijen nga ni sete mia-mij kele nabong san nga niben pian pupo, ejki. Ko erpe nga muwrai kele muwra ‘Bololi tevim rijrijen nga muon ko mimerr osorsan erpe nga mololi tevi Devet.’ ");
INSERT INTO upv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ko renge naul ne Sam kele san, Nale On owra ‘Atua sete mia-marong rragrrag nibe jinibb on sen pupo nawon.’ ");
INSERT INTO upv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daron nga Devet mimaur e, ko osuri Atua. Ko daron nga mimij e, ko artevni erpe b̃irtera sen nir, ko niben ean opo. ");
INSERT INTO upv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ko Iesu ma nga Atua muloli mimaur luwi kele renge mijen, niben sete opo, ejki. ");
INSERT INTO upv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Tasik ko jojik nir, kaprongwos lilane ko wor nale ngok nga nomok-werai nir tevi kami. Suri re Iesu Kristo kobbong sansan, Atua orongwose p̃itlasi tweni nololien nir se kami. ");
INSERT INTO upv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kami kaprongwos wore ko nga Iesu Kristo kobbong orongwose puloli nir nga marosuri ni parivel sisarow renge nololien ser. Ko sete evi nale nesesreien se Moses nga murongwose puloli kapiel sisarow renge nololien se kami, ejki. ");
INSERT INTO upv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ko suri iok, kami kapmetmet ko wor p̃irres. Poro pijki ko nale se propet nir tirrmali ji kami ");
INSERT INTO upv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","nga muwra ‘Kami nga kamok-sopsop̃e Atua, lelingenok ko kaptaole ko kapa-van re mijen suri. Suri sev nga bololi lelingen evi nanu nga kami sete kama-osuri. Rrek poro san puwra lilane tevi kami, ko iok kele sete kama-osuri rrek.’” ");
INSERT INTO upv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ko daron nga Pol nuru Banapas morivel lingi naim ne loten vajin, ko jinibb ne ie arngoni kele tevi nuru arwera “Wurru, poro orongwose kopora-luwi kele vini, kopor-wer visviseni kem e nale ngok renge nabong on nga vitu.” ");
INSERT INTO upv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ko daron nga jinibb martela vare re naim ne loten vajin, ko nir elep arvijuri kele Pol ko Banapas. Nir sopor arivi m̃eri Isrel, ko nir sopor womujnen arivi jinibb ne vare nir, mian ko vitunen mara-tori vajin nosurien se m̃eri Isrel nir. Ko Pol ko Banapas orwerai eterter tevir, orwera “Kaprrul totkoni ko wor murrun ngok se Atua p̃iterter nga mokwilwil se kami renge nolon nga m̃irres p̃elak.” ");
INSERT INTO upv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ko re nabong on nga suri nen kele, otomori nir jijle re ngaim ngok arini kele lat sansan nga parunge nale ngok se Numal se kerr. ");
INSERT INTO upv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ko daron nga m̃eri Isrel nir markulu marmeteni delung ngok nir, ko nolor eleplep temijpal. Mian ko arok-rij esij ko arok-rij tere vajin nale se Pol. ");
INSERT INTO upv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ko Pol nuru Banapas orloli norrorrmien se nuru eterter kele ko orwera “Nobor-wera womue ko wor nale se Atua tevi kami m̃eri Isrel nir. Ko kami kamrong tweni nale nen. Ngok eviseni nga sete kammerreni kaptor sweri mauren nga sete mia-suw nabong sopon. Ko lelingenok rrek nablingi kurtweni kami, ko naban vajin ji jinibb ne vare nir. ");
INSERT INTO upv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ko ngel evi nale nga Numal m̃ilai tevi kem, nga Naul On muwra ‘Inu nususture nik nga nik kupirpe moron san nga pumor jipari jinibb ne vare nir, tweni nga jinibb ne lat jijle ne iel ngatan parasi van re mauren.’” ");
INSERT INTO upv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nale ngok ololi jinibb ne vare nir arir temijpal ren, ko arsurövi lengleng Numal re sev nga marunge. Ko nir nga Atua mutobbtobbu pa nir musuw nga parlai mauren nga sete mia-suw nabong sopon, arosuri ni vajin. ");
INSERT INTO upv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ko murrun ngok ololi vajin nale se Numal easasi van lat jijle renge ngaim ngok. ");
INSERT INTO upv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ko m̃eri Isrel sopor arivel rrerrale ji nesevin ne loten nir ko nabur se nesevin ko jinibb nga marlelep ne ie, ko areveir nga paran partere Pol nuru Banapas. Mian ko aroji tweni vajin nuru re siser. ");
INSERT INTO upv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ko Pol nuru Banapas orwajwajeni tweni maw re b̃ela nuru nga piviseni tevi jinibb ne ie nga nuru orsir dure nuru tevi nir. Mian ko orivel lingi ie, ko oran Ikoniam e. ");
INSERT INTO upv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ko jinibb se Numal nir ne Antiok arir temijpal, ko arwun saute Nem̃in On. ");
INSERT INTO upv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol ko Banapas orwerwer renge nosp̃en nga m̃irres tevi jinibb nir ne Ikoniam, osorsan erpe nga morloli Antiok; ko m̃eri Isrel ko m̃eri Gris elep arlingi nosurien ser renge Numal. ");
INSERT INTO upv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ko m̃eri Isrel nga nosurien ser mijkie artere nir, ko arloli jinibb nir ne ngaim nen arlolar ko artere jinibb se Atua. ");
INSERT INTO upv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ko aposol nuru orlik daron sopon kele ie. Ko nosurien se nuru oto eterter re Numal, ko nolo nuru eterter nga morwerai tweni nale sen. Atua elai derteren tevi nuru nga pormajing nanu nga marinijnij nawone nir. Ko eviseni nga nosp̃en nga m̃irres nga musp̃e suri Atua nolon nga m̃irres evi weretunen. ");
INSERT INTO upv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mian ko m̃eri Ikoniam arteri wukari nir evi meling eru e; devjen arvijuri m̃eri Isrel, ko devjen arvijuri aposol nuru. ");
INSERT INTO upv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mian ko jinibb ne vare sopor tevi m̃eri Isrel sopor ko nabur ser nir arloli norrorrmien nga parevji ko partuwe pini Banapas ko Pol. ");
INSERT INTO upv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Daron nga morunge norrorrmien ngok, ko orwolu oran renge ngaim nga morlelep ngok nuru Listra ko Depe re vanu ngok Likaonia. ");
INSERT INTO upv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ko renge ngaim ngok ko nuru ko lat sopor nga marto rrale, orok-werwer tweni nosp̃en nga m̃irres se Iesu Kristo. ");
INSERT INTO upv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ko jinibb san elik Listra, ko daron nga m̃iak e ko pa ko sete orongwose pivel, b̃elan orkati. ");
INSERT INTO upv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ko ni oklik ie ko okmurronge nale se Pol. Pol elesi nga nosurien sen eterter wor nga emrreni p̃irres luwi, mian ko oklu van jin ");
INSERT INTO upv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ko ekail van mare, owra “Kuptur rramos!” mian ko m̃er nga otur imera kasi ko etipatun nga pivivel vajin. ");
INSERT INTO upv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ko daron nga delung marlesi sev nga Pol muloli, ko artipatun arkail re nale ne ie Likaonia, arwera “O, atua nir arirpe jinibb kele, ko arjubbul vitan vini ji kerr kele!” ");
INSERT INTO upv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ko arlingi nise Banapas ewaji Sus (nga mivi batbatu numal atua ser nir), ko arlingi Pol ewaji Emis (nga mivi atua ser san nga mokwosi nale se atua ser nir). ");
INSERT INTO upv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ko naim ne loten se Sus oto mori bbong ngaim ser ko, vare sopon. Ko jinibb nga moksulsul tevi Sus tevi delung ngok nir armerreni parloli sulsulen tevi Banapas ko Pol; mian ko aran arevei buluk nga marjoroi tevi nevngun vini re jeli metali. ");
INSERT INTO upv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ko daron nga Pol ko Banapas mora-rongwose vajin sev nga nir marwera parloli, ko orrerrerrsi sunsun se nuru nga piviseni nga orunge esij p̃elak. Ko orwolu van liven re jinibb nir ko orkikail van mare jer, ");
INSERT INTO upv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","orwera “E, lartul, suri sev kamok-loli sel ngok? Komru nomor-ivi jinibb erpe kami kobbong. Namini iel nga nabwera tweni nosp̃en nga m̃irres nga p̃irieni kami renge sel nga m̃isij, ko kapluwi van ji Atua nga mimaur nga muloli melrin, iel ngatan, dis ko nanu jijle nga marto rengen. ");
INSERT INTO upv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tuwi elinglingi jinibb jijle arvijuri lweni norrorrmien ser sisamis, ");
INSERT INTO upv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ko eviseni ma nga okpitevi kami re nanu jijle nga marres nga muloli. Atua elai naus renge melrin vini nga muloli wini marres. Elai nanen tevi kami ko ololi nolo kami eir.” ");
INSERT INTO upv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pol ko Banapas orwerai tweni nale nen erpok ko pa, orp̃elak epriv sopon, mian ko ora-ete vajin norrorrmien se delung nir nga setemun parloli sulsulen van ji nuru. ");
INSERT INTO upv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ko mian ko nabur ne Isrel sopor nga marivel Antiok ko Ikoniam arevei norrorrmien se delung nir arasi vini devjen ser e. Artekai Pol ko artuwe ko arevei tweni van vare e re ngaim ngok ko arkurtweni, arrorrmi nga ni emij ko pa. ");
INSERT INTO upv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ko daron nga jinibb se Iesu nir marini martur rrale Pol, ko Pol emra, ko olwi kele van renge ngaim ngok. Ko mevinen ko nuru Banapas orivel kele van Depe e. ");
INSERT INTO upv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol ko Banapas orwerwer e nosp̃en nga m̃irres re ngaim ngok Depe, ko orevei jinibb elep arini arivi jinibb se Iesu. Mian ko orluwi van Listra e ko Ikoniam, mian ko ortajer van Antiok renge Pisitia e. ");
INSERT INTO upv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Orsa raji nolo kalesia nir, ko orwerai eterter tevir nga parrul totoni nosurien ser puto p̃iterter; mian ko orwerai tevir orwera “Kerr rraprunge ko wor p̃isij pilep puwomu, ko orongwose rrapa-sil van re batun vanu ne melrin.” ");
INSERT INTO upv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ko re Naim On sisamis orok-susture elta nga morok-lingi kurtweni nanen ko morlot milep van ji Atua surir nga Numal se kerr pimetmete nir p̃irres. ");
INSERT INTO upv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mian ko Pol ko Banapas orivel otvi kele Pisitia e van Pampilia e. ");
INSERT INTO upv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ko renge ie, orwerwer kele renge ngaim wel san nga Peka, mian ko orjubbul van ngatan e Atalia. ");
INSERT INTO upv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Daron nga morsuw vajin iok, ko orsa luwi van re drrav e ko orwolu luwi van Antiok renge Siria e. Iok ko evi lat nga Atua mususture nuru bonevis ko muwrai nga pimetmete nuru p̃irres renge nalol nga m̃irres sen mijpari nga morvinvini ore jijle vajin majingen sen. ");
INSERT INTO upv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Daron nga morjipari Antiok, ko orveruse kalesia jijle arini arkorti lat sansan. Orwera tevi jinibb nir sev nga Atua miwilwil se nuru nga morloli, ko erpese ni murongwose puloli nga jinibb ne vare nir kele parosuri. ");
INSERT INTO upv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mian ko orlik eprepriv kele ie tevi jinibb se Iesu nir. ");
INSERT INTO upv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ko jinibb sopor arivel lingi Jutia ko arini Antiok e. Ko arok-wer sesesre tasi kerr, arwera “Poro sete kapan re bae pirpe nale nesesreien se Moses muwrai, ko Atua sete mia-la mauren tevi kami.” ");
INSERT INTO upv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ko Pol ko Banapas orij latlat elep tevir suri nesesreien ngok. Ko mian ko kalesia nir nga Antiok arkoni tweni Pol ko Banapas tevi nir sopon kele van Jerusalem e nga parsusi rongornge iok tevi aposol ko elta nir. ");
INSERT INTO upv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ko daron nga markonir jile ko arivel otvi Ponisia ko Sameria. Arsup̃e suri erpese nga Atua mirvei jinibb ne vare nir nga parini parivi jinibb se Atua. Nosp̃en ngok ololi jinibb se Numal nir arir temijpal. ");
INSERT INTO upv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ko daron nga marremali Jerusalem e, ko kalesia nir tevi aposol ko elta nir arwera erres tevir. Ko arwerai tweni nanu jijle nga Atua miwilwil se nir nga marlolir. ");
INSERT INTO upv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ko nir sopor nga marivi Parasi ko marosuri Iesu, artur imera ko arwera “O, nir ngok nga sete marivi m̃eri Isrel paran wor re bae ko. Ko kapvisvisenir ko wor nga parvijuri nale nesesreien se Moses.” ");
INSERT INTO upv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mian ko aposol tevi elta nir arlik korti nga parjiljilwer suri norrorrmien ngok suri jinibb ne vare nir, lat nga parloli puto suri. ");
INSERT INTO upv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Arjiljilwer suri epriv sopon, mian ko Pita otur imera ko owra “Selek nir, kamrongwose nga tuwi jer pa, Atua orrorrmi nga p̃ilngi inu erpe san re gortien ngok se kerr nga piwerwer renge nosp̃en nga m̃irres tevi jinibb ne vare nir. Atua ololi erpok nga nir parunge ko parosuri ni. ");
INSERT INTO upv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ko Atua nga murongwose nolo jinibb jijle nir eviseni norrorrmien sen tevi jinibb ne vare nir daron nga m̃ilai Nem̃in On sen tevir, osorsan erpe nga m̃ilai tevi kerr. ");
INSERT INTO upv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Norrorrmien nga Atua muloli tevi nir osorsan kobbong erpe norrorrmien nga muloli tevi kerr. Arlingi nosurien ser renge ni, ko ni ololi nolor owokwok jijle erres. ");
INSERT INTO upv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ngok, ko suri sev kamwera kaploli Atua pulolar? Suri kamwera kaplingi kele soloslo nga murrow renge nir ngok nga marosuri. Soloslo ngok orrow p̃elak renge kerr m̃eri Isrel nir, ko re kele apu se kerr nir. ");
INSERT INTO upv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ko Numal se kerr Iesu okrres p̃elak tevi kerr, ko rramasi renge nosurien renge ni kobbong, osorsan erpe jinibb ne vare nir.” ");
INSERT INTO upv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nir jijle arlik murrarrong ko armurrong, mian ko Banapas ko Pol vajin orsup̃e suri erpese nga Atua m̃ilai derteren tevi nuru nga pormajinge nelesien nir ko nanu nga marinijnij nawone nir tevi jinibb ne vare nir. ");
INSERT INTO upv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Daron nga morwerai jijle nale se nuru musuw, ko Jemes otur imera ko evinvini ore nale, owra “Tasik ko jojik nir, kapmurronge nale suk p̃irres. ");
INSERT INTO upv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saemon Pita ea-wer visviseni lebbong erpese nga womu Atua murrorrmi jinibb ne vare nir, ko nga m̃ilai tweni nir sopor marini jin e. ");
INSERT INTO upv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Iok osorsan tevi sev nga propet maruli: ");
INSERT INTO upv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Inu Numal, bea-luwi kele ko b̃emajing lweni naim se Devet nga mumutmut jile pa m̃isij. Inu bosusture lweni kele. ");
INSERT INTO upv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ko jinibb lele ne iel ngatan nga inu meveruse nir pa nga partori totkoni nisek, parlesi wose nga inu nuvi Atua. ");
INSERT INTO upv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nale ngel evi se inu Atua nga mololi jinibb marongwose tuwi pa vini.’” ");
INSERT INTO upv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ko Jemes etajer nga muwra “Evi nale suk nga bowrai suri: sete erres nga rraplingi soloslo nga murrow kele re jinibb ne vare nir nga marieni lwenir pa vini ji Atua e. ");
INSERT INTO upv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ko erres rrapuli naul san van jir, ko rrapwerair e nga nir parvijuri ko wor nale sopor nga marto renge nale nesesreien se Moses, nir le ngel: Setemun parurroi nanen nga marloli sulsulen e van ji atua m̃inij nir, ko sete parloli p̃isij tevi nesevin, ko sete parurro nanu san nga marwusi ore b̃irislan nga pimij ko drran sete m̃iseser asi te. ");
INSERT INTO upv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Suri tuwi jer pa vini, renge naim ne loten se m̃eri Isrel nir re nabong on, jinibb sopor arok-tur imare ko arok-eve nesesreien se Moses, ko jinibb arok-werai tweni nale sen re ngaim jijle.” ");
INSERT INTO upv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Aposol tevi elta ko kalesia nir armurri suri nga parkoni kele jinibb sopor van Antiok e nga parpitevi Pol ko Banapas. Arlingi Saelas ko Jutas Barsapas nga morivi nabur eru re gortien se Numal. ");
INSERT INTO upv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Aruli naul san nga muwra mirpel: ‘Kem aposol ko elta nir, namwerai erres p̃elak tevi kami jijle jinibb ne vare nir nga kamivi jinibb se Numal nir re Antiok, Siria, ko Silisia. ");
INSERT INTO upv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","‘Namrunge nga jinibb sopor re gortien se kem arinuk ji kami ko arlokloksi kami re nale nga sete kem namkonir e. ");
INSERT INTO upv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ngok ololi kem namlik korti le, ko namini tevi norrorrmien nga nablingi jinibb ne majingen eru ko nabkoni nuru vinuk ji kami. Nuru porpitevi Banapas ko Pol nga nammerreni nuru milep. ");
INSERT INTO upv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nir nga namlingir ngok arlai pa nolor ko mauren ser ko tweni majingen ngok. ");
INSERT INTO upv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ko niko namkoni Jutas ko Saelas, nga pora-werai kele nanu ngok kobbong nga kem namuli. ");
INSERT INTO upv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","‘Nem̃in On eviseni tevi kem nga sete nabjingteni soloslo nga murrow renge kami. ");
INSERT INTO upv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ko iok kobbong, evi nga sete kapurroi sev nga marloli sulsulen ren van ji atua m̃inij nir. Ko sete kaploli p̃isij tevi nesevin. Sete kapurroi nanu san nga marwusi ore b̃irislan nga pimij ko drran sete m̃iseser asi te. Poro kapvijuri norrorrmien ngok nir, ko kaploli p̃irres ko. Erres wor ko remse kami ko pa.’ ");
INSERT INTO upv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Niko nir ivij ngok arivel lingi Jerusalem ko aran Antiok e. Mian ko arkortoni kalesia totoklai nir, ko arlai vajin naul ser tevir. ");
INSERT INTO upv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nale ne naul nen osongni nolor e neiren, ko osustur kele norrorrmien ser. ");
INSERT INTO upv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ko Jutas ko Saelas kele orivi propet, ko orjiljilwer epriv tevir, ko orsustur e norrorrmien ser ko orwilwil ser. ");
INSERT INTO upv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","M̃eri Jerusalem ngok orlik kele beblen Antiok, ko daron nga morivel lingi nga porluwi van ji nir nga markonir e, ko kalesia nir ne ie arwera “Demat piptevi kamru re sel se kamru nga kopor-luwi e.” ");
INSERT INTO upv_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ko Saelas elik jer ie. ");
INSERT INTO upv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ko Pol ko Banapas orlik kele Antiok, ko nuru tevi kalesia elep kele wor arvisviseni ko arwerwer suri Numal renge ie. ");
INSERT INTO upv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ko sete epriv, Pol owrai tevi Banapas owra “Rrek rrapluwi kele van rraplesi jinibb se Numal nir renge ngaim jijle nga rramwerwer renge nale sen rer. Ngok puloli rraprongwose lat nga marlik ren muto suri.” ");
INSERT INTO upv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ko Banapas emarong, ko emrreni p̃itkai kele Jon nga nisen tuwen nen Mak. ");
INSERT INTO upv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ko Pol sete emrreni pirpok, suri Mak evel lingir seveling nga Pampilia ko omusmus p̃imajing tevir. ");
INSERT INTO upv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Sete epriv ko Pol ko Banapas orlat, mian ko orsisamis. Banapas etkai Mak ko orwolu renge drrav van Saepras e. ");
INSERT INTO upv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ko Pol etkai Saelas; ko jinibb se Numal nir arngoni nga Numal se kerr purongwose pimetmete nuru renge nalol nga m̃irres sen. Mian ko orivel. ");
INSERT INTO upv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Orivel van, orremali Siria ko Silisia, orok-wilwil se kalesia nir nga parterter. ");
INSERT INTO upv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol etajer kele van Depe ko Listra e, lat nga jinibb san nga mivi kalesia nga nisen Timoti m̃ilik e. Tasu sen kele evi kalesia nga mivi nesen Isrel, ko tata sen ma evi m̃eri Gris. ");
INSERT INTO upv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tasi kerr ko joji kerr nir nga Listra ko Ikoniam arwera evi jinibb nga m̃irres p̃elak san. ");
INSERT INTO upv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol emrreni p̃itkai piptevi, mian ko ololi ean re bae. Ololi erpok suri m̃eri Isrel p̃etp̃eti nga marlik ie arongwose nga tata se Timoti evi m̃eri Gris. ");
INSERT INTO upv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ko daron nga Pol tevi selen ngok nir marok-tutur m̃itajer re ngaim ko ngaim nir, arwerai tweni tevi kalesia nir sev nga aposol tevi elta nga Jerusalem marwerai. Ko arwerai eterter nga nir parrul totkoni ko wor norrorrmien ngok nir. ");
INSERT INTO upv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ko kalesia nir arini eterter kele renge nosurien. Ko nabong jijle, jinibb evinvini, ololi nir esa van mare tetajer. ");
INSERT INTO upv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol tevi selen nir arivel otvi Prijia ko Galesia. Ko Nem̃in On sete emarong nga nir parwerwer re vanu ne Esia. ");
INSERT INTO upv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Vitunen ko arremali kele renge vanu ngok Misia; ko arloli lesi nga paran mare kele Bitinia e, ko Nem̃in se Iesu sete emarong. ");
INSERT INTO upv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mian ko arivel otvi ma Misia, mian ko arjipari Troas. ");
INSERT INTO upv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ko re natmupong nen bbong, ko Pol elesi bori san suri m̃eri Masetonia san nga mutur ko mungoni tertere muwra “Kupini wor iel Masetonia ko kupwilwil se kem.” ");
INSERT INTO upv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Daron nga Pol m̃ilesi jijle bori ngok, ko kem nampejpej sel nga naban Masetonia e. Suri namrongwose nga Atua everuse kem nga naban nabwerwer renge nosp̃en nga m̃irres sen iok. ");
INSERT INTO upv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Namwolu lingi kele Troas renge drrav, ko naman mawos Samotres e. Ko mevinen, namjipari Neapolis. ");
INSERT INTO upv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ko renge iok namtajer kele van Pilipae e, lat nga m̃eri Rom milep marloli liken ser rengen, ko mivi kele ngaim nga muto womu re vanu ngok Masetonia. Namlik nabong sopor ie. ");
INSERT INTO upv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ko re nabong on, namivare re ngaim ngok van re jeli nuwi seser san, nga namrrorrmi evi lat nga m̃eri Isrel nir marok-ser korti e tweni loten. Namlik ngatan ko namtipatun namjiljilwer tevi nesevin nir nga markorti ie. ");
INSERT INTO upv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nesevin nen san nga mokmurrong nen nisen Litia, nga mokwulwule nijor nga nowlin milep ko musongsong mupongpong m̃irres re ngaim ngok Taeatira. Ko ni evi vin nga moksurövi Atua. Numal etasi nolon nga m̃ilngi norrorrmien sen vajin eterter re nale se Pol. ");
INSERT INTO upv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ko daron nga vinnen tevi naim sen nir marpaptaes jijle, ko everuse kem owra “E, kapini kaplik renge naim suk, poro nga kaprrorrmi nga inu nuvi weretunen jinibb se Numal”. Mian ko kem nammarong re sev nga muwrai, ko naman. ");
INSERT INTO upv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nabong san renge sel se kem van re lat ne loten e, namsekai nesenwarreng demij maur san. Ni nem̃in san oto rengen nga m̃ilai derteren tevi nga puwrai tweni sev nga pia-rremali vitu. Ervei nevöt elep daron nga mokloli majingen ngok e tevi nir nga marmetmete ni. ");
INSERT INTO upv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Vinok evijuri Pol tevi kem sopor kele, ko ok-kail van mare owra “Lartul ngel arivi jinibb se Atua nga mian mare temijpal nga marvisviseni kami renge sel ne mauren!” ");
INSERT INTO upv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Vinok olöni lweni norrorrmien ngok nabong sopon kele, mian ko Pol ornge esij e. Ko otur imera ko erij tere nem̃in nga, owra “Renge nise Iesu Kristo, kuplinglingi vajin vinel!” Ko vesan rres nem̃in nga m̃isij nen elinglingi vin nga. ");
INSERT INTO upv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ko daron nga nir nga marok-metmete vinel marongwose vajin nga martor jabble sel ser nga marok-loli nevöt milep ren, artur imare ko arrul totkoni Pol ko Saelas. Ko artekai nuru van ortur renge ngaim ngok re maket, lat nga marok-wer sesesre lat nga puto suri tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ko artekai nuru van ortur renge no m̃eri Rom eru nga morivi gavman, mian ko arwera “Laru ngel orivi m̃eri Isrel, ko orok-loli sel nga marsij renge sise kerr. ");
INSERT INTO upv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Orvisviseni murrun nga sete musorsan. Ko murrun nga morwerai kele sete evijuri nale nesesreien se kerr, ko kerr rrammajing renge nise numal gavman ne Rom ko sete orongwose rrapvijuri nuru.” ");
INSERT INTO upv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ko delung aran kele re norrorrmien ngok, ko artere Pol ko Saelas. Ko jinibb ne nuval nir arrerrerrsi joro nuru ko arlai nale nga parevji nuru re nai. ");
INSERT INTO upv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Daron nga marevji lenglengen nuru musuw, ko arlingi nuru van re naim ne nekaien. Ko arlingi nale tevi m̃er nga mimetmete naim ne nekaien nga pimteni suri nuru p̃irres nga sete porwolu. ");
INSERT INTO upv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Daron nga morok murnge nale ngok, ko otur mera ko etkai nuru van lat san loloim jer kele, ko eplaji totkoni b̃ela nuru e nai nga milep san. ");
INSERT INTO upv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ko mian ko daron nga nat m̃irrang, ko Pol ko Saelas orlot ko orlai nubo van ji Atua, daron nga nir kele sopor re naim ne nekaien marok-murronge. ");
INSERT INTO upv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sete epriv ko nam̃i nga milep san eterure naim ne nekaien elep. Metali nir artetp̃ir, ko dil delrrurr nga markai renge nevrer arvitvitan renge nevre nir jijle nga marlik re naim ne nekaien. ");
INSERT INTO upv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Daron nga m̃er nga mokmetmete nir m̃itaol ko m̃ilesi metali martetp̃ir, ko orrorrmi nir nga marlik loloim arwolu van vare e; otur mera ko elai nesip ne nuval sen nga p̃isari lweni e. ");
INSERT INTO upv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mian ko Pol ekail owra “E, sete kupsari lwenim! Sete san owlu ivare, ejki.” ");
INSERT INTO upv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mian ko m̃ernen ongoni laet san, ko owlu van loloim re naim ne nekaien. Eririr temijpal, ko evini ejiol vitan re no Pol ko Saelas. ");
INSERT INTO upv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ko etkai tweni nuru re naim ne nekaien, ko osusi tevi nuru owra “Wurru, bololi pirpese ko b̃ela mauren?” ");
INSERT INTO upv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Orij weli nale sen, orwera “Kuplingi nosurien som renge Numal Iesu, ko ngok kurongwose kupla mauren, nik ko nir nga marlik renge naim som.” ");
INSERT INTO upv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mian ko Pol ko Saelas orjilwer vajin tevi ni ko nir jijle nga marlik renge naim sen suri Numal Iesu. ");
INSERT INTO upv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Re daron ngok kobbong natmupong nen, ko m̃er nga mokmetmete nir re naim ne nekaien ngok etkai nuru van, errawe vaseni lat nga marevji nuru renge nibe nuru, mian ko ni tevi jinibb jijle nir nga marlik renge naim sen arpaptaes. ");
INSERT INTO upv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mian ko etkai lweni Pol ko Saelas vini re naim sen e, ko ela nanen sopon tevi nuru. Ni ko jinibb ne naim sen nir, neiren nga milep oto renge nolor suri arini nga marosuri vajin Atua. ");
INSERT INTO upv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Daron nga nat m̃irin vajin, ko numal nesesreien okoni polis sopor van ji ni nga mokmetmete naim ne nekaien tevi nale san nga muwra “Kuplinglingi laru ngok nuru porivel sisarow.” ");
INSERT INTO upv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","M̃er nga owrai tevi Pol owra “Jinibb nesesreien elai nale ngel nga nik ko Saelas kopor-ivel. Komor-rongwose kopor-ivel ko vajin renge demat.” ");
INSERT INTO upv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ko Pol owrai tevi polis nen owra “E, erpese ko, komru nomorivi m̃eri Rom, ko laru ngok setemun orloli nomorkot, ko arevji komru re no jinibb nir, mian ko arwirr komru van re naim ne nekaien. Ko lelingenok ormerreni porlai tweni silveni komru. Sete mia-irpok, sete erres porlai nale re sel, ko porini ko wor porlai tweni komru iel.” ");
INSERT INTO upv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Daron nga polis muwrai tweni tevi numal nen nuru nga Pol ko Saelas orivi m̃eri Rom, ko numal nen nuru ormetutu lenglengen. ");
INSERT INTO upv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mian ko orini ko orwerai warru tevi nuru, ko ortekai tweni nuru re naim ne nekaien, mian ko orngoni nga porivel lingi ngaim ngok. ");
INSERT INTO upv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ko daron nga morivel lingi ie ko oran mawos re naim se Litia, ko iok ko orlesi kele jinibb se Numal nir ren, ko orsusture kele nosurien ser. Mian ko orivel lingi vanu ngok. ");
INSERT INTO upv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ko Pol ko Saelas orivel van, ko orremali re ngaim ngok Ampipolis ko Apolonia; mian ko ortajer van orjipari Tesalonaeka. Ko naim ne loten se m̃eri Isrel nir san oto ie. ");
INSERT INTO upv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ko erpe nga mokloli pa tetajer, ko Pol ean loloim nen nga pusrövi Atua. Ko okloli erpok ean ejpari nabong on itul ko pa nga ni mokwerwer tevi jinibb nir ie. Ko oklai nale ");
INSERT INTO upv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ne Naul On nga miviseni tevir nga Mesaea purnge p̃isij ko wor pijpari pimij, ko Atua pia-loli pia-maur luwi kele renge mijen. Pol owrai kele tevir nga Iesu evi Mesaea nga ni mokwerwer suri. ");
INSERT INTO upv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nir sopor arosuri sev nga Pol muwrai, ko arini kele arvivitu suri Pol ko Saelas. Ko jinibb ne vare kele nir elep nga marok-surövi Atua, ko nesevin nga marwowomu re nesevin nir arini kele arpitevir. ");
INSERT INTO upv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ko mian ko jinibb nga marlelep se m̃eri Isrel nir nolor eleplep, ko aran arpej butterter nga marok-ivel suri nawon sel, ko arwerai tevir nga parloli balpalen karkar. Arwera parevei Pol ko Saelas van jir; ko aran renge naim se jinibb san nisen Jeson, ko arbburbburi metali sen nga marok-pej Pol ko Saelas. ");
INSERT INTO upv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ko daron nga setemun marlesi nuru, ko arrul totoni Jeson tevi tasi kerr sopon, areveir vini artur renge kot re no jinibb nga marlelep ie. Mian ko arkail van mare temijpal arwera “Laru ngok nuru Pol ko Saelas orloli nanu nga marsij elep renge lat elep. Ko lelingenok orini iel kele! ");
INSERT INTO upv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Mian ko Jeson ngel etkai nuru oran loloim sen e. Nir jijle artor otvi nale nesesreien se Sisa, batu numal se m̃eri Rom nir. Nuru orwerai nga batu numal m̃inij kele san oto, nga nisen Iesu.” ");
INSERT INTO upv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ko daron nga m̃eri Isrel tevi jinibb nga marlelep ne ie marunge nale ngok, ko arunge lengleng esij suri. ");
INSERT INTO upv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mian ko arloli Jeson ko tasi kerr nen nir parlai nevöt sopor tevir puloli parivel sisarow e. Ko nir arloli erpok, ko arivel sisarow vajin. ");
INSERT INTO upv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Renge natpong nen kobbong ko tasi kerr nir arkoni tweni Pol ko Saelas oran re ngaim ngok e Berea. Ko daron nga morremali ie, ko ortajer ko pa van re naim loten se m̃eri Isrel nir. ");
INSERT INTO upv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jinibb ne ngaim ngok Berea arresrres asi nir ne Tesalonaeka, ko nir arir nga parunge nale. Ko nabong jijle armeteni pejpej renge Naul On poro nga nale nga Pol muwrair arsorsan tevi nga marto re Naul On, rreknga ejki. ");
INSERT INTO upv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ko mian ko nir elep arlingi nosurien ser renge Numal. Ko nesevin elep nga marwowomu re nesevin nir ne Gris ko norman nen kele elep arosuri. ");
INSERT INTO upv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ko daron nga m̃eri Isrel nir nga marlik Tesalonaeka marunge nga Pol mokwera tweni nale se Atua tevi m̃eri Berea nir, iok ololi nir aran ie ko arevei kortoni delung sopor arser korti; ko arwera suri tevir, ko ololi nolor ololarsi Pol. ");
INSERT INTO upv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ko ngavilvil, tasi kerr nir arkoni tweni Pol tevi selen kele sopor arjubbul van ngatan e renge jeli dis (ko Saelas ko Timoti orlik jer Berea). ");
INSERT INTO upv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ko arpitevi Pol aran arjipari Atens. Ko daron nga marivel lingi Pol nga parluwi van Berea e, ko Pol elai nale tevir nga paran parwerai tevi Saelas ko Timoti nga nuru porsaro pingavilvil vini porpitevi kele. ");
INSERT INTO upv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Daron nga Pol mokteravi nuru renge Atens, ko ornge esij nga m̃ilesi atua ser nga marsavir renge nai ko nevöt muwun saut. ");
INSERT INTO upv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ko ean renge naim gortien se m̃eri Isrel nir nga p̃ijiljilwer tevi nir ko tevi jinibb ne vare kele nga marsurövi Atua. Ko nabong jijle, okjiljilwer kele tevi jinibb jijle nga m̃ilesir renge maket. ");
INSERT INTO upv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ko m̃eri Gris nir sopor arvijuri nesesreien se nir san nga nisen Epikurus, ko sopor arvijuri nesesreien se nir san nga nisen Seno. Ko nir nen sopor arjilwer tevi Pol. Ko nir sopor arwera “O, morok erij se lenglengen! Ni oksup̃e sev ko?” Ko nir m̃inij arwera “Namrunge erpe moksup̃e atua ne vanu m̃inij ko.” Arok-rij erpok suri Pol oksup̃e suri Iesu ko owrai tweni nga Atua ololi emaur luwi renge mijen. ");
INSERT INTO upv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mian ko arverus Pol nga pivini putur renge no gortien ser san nga marveruse Ereopakas, ko arwera “Nammerreni nabrongwose nevisvisenien nga mimerr som erpese ko? ");
INSERT INTO upv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Namrunge kuwrai nanu sopor nga namtaol lenglenge, ko nammerreni nabrongwose kusp̃e sev ko?” ");
INSERT INTO upv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ko suri evi norrorrmien tera se m̃eri Atens nir ko se neturvitan kele nir ne ie nga tetajer marmerreni parlilik ko parmurronge nale nga mimerr ko parjiljilwer renge norrorrmien nga marirpok. ");
INSERT INTO upv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mian ko Pol otur imera re no delung nir ko owra “M̃eri Atens, inu nulesi pa erpe kamok-surövi atua se kami nir erres p̃elak. ");
INSERT INTO upv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Daron nga nomok-ivel suri sise kami, ko nomok-meteni nanu nir nga kamok-surövi, ko nulesi pa nale san nga kamuli renge nawot san nga muwra ‘Ngel oto tweni nga parsurövi Atua san nga setewor rramrongwose’. Kami sete kamrongwose ko kamsurövi ma, ni le vajin mowra tweni ngel tevi kami. ");
INSERT INTO upv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Atua ngok emajinge iel ngatan ko nanu jijle nga marto rengen. Evi numal ne melrin ko iel ngatan kele. Sete elik renge naim loten nga jinibb m̃imajinge. ");
INSERT INTO upv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Sete ongoni jinibb san p̃ila sen nga p̃irij. Elai mauren, sowin ko nanu jijle tevi jinibb nir. ");
INSERT INTO upv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Etipatun re jinibb sansan kobbong, ni ololi jinibb totoklai nir nga marmaur iel ngatan. Ko owjuwje vajin lat ne liken ser sisamis, ko owra suri kele daron nga para-maur jipari. ");
INSERT INTO upv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Atua ngok ololi erpok nga puloli kerr jijle rraploli lesi nga rrappej ni; ko rrek daron nga rramok-totong karkar, ko orongwose rrapsekai ni. Ko ewretun temijpal nga ni sete oruj ngasu rragrrag ji kerr. ");
INSERT INTO upv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ko erpe jinibb san muwrai pa tuwi muwra ‘Suri rramkorti renge Atua kobbong ololi rramla mauren, ko rramok-tutur ko rramloli nanu jijle’. Ko erpe kele kami san nga mok-koji nubo muwrai pa muwra ‘Kerr kele rramivi natun.’ ");
INSERT INTO upv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ko suri rramivi natu Atua, ko sete orongwose rrapwera ni erpe nanu nga marmajinge re gol rrek silva rrek nevöt. Sete evi nanu san nga jinibb murongwose p̃imajinge re nevren rreknga norongwosien sen, ejki. ");
INSERT INTO upv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ko re daron ne tuwi nga jinibb sete murongrongwos, ko Atua etlasi tweni bbong sev nga marloli, suri norongwosien ser ejkie. Ko lelingenok vajin okwerai tevi kerr jijle re lat jijle, owra ‘Kami jijle kaprieni norrorrmien se kami suri nololien se kami.’ ");
INSERT INTO upv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Suri elngi pa nabong nga pia-wera suri lat nga puto suri tevi jinibb jijle ne iel ngatan renge sel nga musorsan kobbong. Atua otobbtobbu pae isi nga ni puloli pia-wera suri lat nga puto suri tevi jinibb nir. Ko eviseni nga evi weretunen nga puloli pirpok re nga muloli pa m̃ernen emaur luwi kele renge mijen.” ");
INSERT INTO upv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ko daron nga Pol muwra jinibb san mimaur luwi kele re mijen, ko nir sopor armen keraji. Ko nir sopor ma arwera “Nammerreni naba-runge kele nale som suri norrorrmien ngok.” ");
INSERT INTO upv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mian ko Pol evel lingir; ");
INSERT INTO upv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ko nir sopor arini arkorti tevi ko arosuri Iesu. Renge nir ngok, jinibb san nisen Denis nga mivi san re gortien ngok Ereopakas, ko nesevin kele san nga nisen Damaris, ko norman m̃inij kele sopor.");
INSERT INTO upv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pol evel lingi Atens ko ean kele re ngaim ngok Korin. ");
INSERT INTO upv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ko iok, eskai m̃eri Isrel san nga mivel Pontas, nga nisen Akwila. Ko bonevis ean