﻿USE sofia;
DROP TABLE IF EXISTS sofia.unx_vpl;
CREATE TABLE unx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES unx_vpl WRITE;
INSERT INTO unx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ନେଆଁଁ ହବାଅଃତାନା ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ପୁର୍‌ଖା ଆପୁକଆଃ ନୁତୁମ୍‌କ ଅଲାକାନ୍‌ ପୁଥି, ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌, ଦାଉଦ୍‌ଆଃ କିଲିରେନ୍‌ ଆଡଃ ଦାଉଦ୍‌, ଆବ୍ରାହାମ୍‌ଆଃ କିଲିରେନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଆବ୍ରାହାମ୍‌ଆଃ ହନ୍‌ ଇସାକ୍‌, ଇସାକ୍‌ଆଃ ହନ୍‌ ଯାକୁବ୍‌, ଯାକୁବ୍‌ଆଃ ହନ୍‌ ଯିହୁଦା ଆଡଃ ଆୟାଃ ହାଗାକ ତାଇକେନା, ");
INSERT INTO unx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ଯିହୁଦାରାଃ ହନ୍‌ ପେରସ୍‌ ଆଡଃ ସେରହ, ଇନ୍‌କିନାଃ ଏଙ୍ଗାତେ ତାମର୍‌ ତାଇକେନାଏ, ପେରସ୍‌‌ରାଃ ହନ୍‌ ହେସ୍ରୋନ୍‌, ହେସ୍ରୋନ୍‌ରାଃ ହନ୍‌ ଅରାମ୍‌, ");
INSERT INTO unx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ଅରାମ୍‌ରାଃ ହନ୍‌ ଅମ୍ମୀନାଦବ୍‌, ଅମ୍ମୀନାଦବ୍‌ରାଃ ହନ୍‌ ନହଶୋନ୍‌, ନହଶୋନ୍‌ରାଃ ହନ୍‌ ସାଲ୍‌ମନ୍‌, ");
INSERT INTO unx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସାଲ୍‌ମନ୍‌ରାଃ ହନ୍‌ ବୋୟାଜ୍‌, ବୋୟାଜ୍‌ରାଃ ଏଙ୍ଗାତେୟାଃ ନୁତୁମ୍‌ ରାହାବ୍‌, ବୋୟାଜ୍‌ରାଃ ହନ୍‌ ଓବେଦ୍‌, ଓବେଦ୍‌ରାଃ ଏଙ୍ଗାତେ ରୁତ୍‌, ଓବେଦ୍‌ରାଃ ହନ୍‌ ଯିଶି, ");
INSERT INTO unx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଯିଶିରାଃ ହନ୍‌ ରାଜା ଦାଉଦ୍‌, ରାଜା ଦାଉଦାଃ ହନ୍‌ ସୁଲିମାନ୍‌, ସୁଲିମାନ୍‌ରାଃ ଏଙ୍ଗାତେ ସିଦାହେତେ ଉରିୟରାଃ କୁଡ଼ି ତାଇନ୍‌କେନା, ");
INSERT INTO unx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ସୁଲିମାନ୍‌ରାଃ ହନ୍‌ ରିହବିୟାମ୍‌, ରିହବିୟାମ୍‌ରାଃ ହନ୍‌ ଅବିୟ, ଅବିୟରାଃ ହନ୍‌ ଆସା, ");
INSERT INTO unx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଆସାରାଃ ହନ୍‌ ଯିହୋଶାଫତ୍‌, ଯିହୋଶାଫତ୍‌ରାଃ ହନ୍‌ ଯୋରାମ୍‌, ଯୋରାମ୍‌ରାଃ ହନ୍‌ ଉଜ୍ଜିୟ, ");
INSERT INTO unx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜ୍ଜିୟରାଃ ହନ୍‌ ଯୋଥାମ୍‌, ଯୋଥାମ୍‌ରାଃ ହନ୍‌ ଆହାସ୍‌, ଆହାସ୍‌ରାଃ ହନ୍‌ ହିଜକିୟ, ");
INSERT INTO unx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ହିଜକିୟରାଃ ହନ୍‌ ମନଶି, ମନଶିରାଃ ହନ୍‌ ଆମୋନ୍‌, ଆମୋନ୍‌ରାଃ ହନ୍‌ ଯୋଶିୟ, ");
INSERT INTO unx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ଯୋଶିୟରାଃ ହନ୍‌ ଯିକନିୟ ଆଡଃ ଆୟାଃ ହାଗାକ ତାଇକେନା, ନେଆଁଁ ଇସ୍ରାଏଲ୍‌ ହଡ଼କକେ କିରିଙ୍ଗ୍‌ ଦାସିକେଦ୍‌ତେ ବାବିଲୋନ୍‌ତେ ଇଦିକୁତାଇକେନ୍‌ ଦିପିଲିରାଃ କାଜିତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ବାବିଲୋନ୍‌ତେ ତଲ୍‌ଇଦି ତାୟମ୍‌ତେ ଯିକନିୟ ଶଲ୍‌ଟିୟେଲ୍‌କେ ଜାନାମ୍‌କିୟା, ଶଲ୍‌ଟିୟେଲ୍‌ରାଃ ହନ୍‌ ଜିରୁବାବେଲ୍‌, ");
INSERT INTO unx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବାବେଲ୍‌ରାଃ ହନ୍‌ ଅବିହୁଦ୍‌, ଅବିହୁଦ୍‌ରାଃ ହନ୍‌ ଏଲିୟାକିମ୍‌, ଏଲିୟାକିମ୍‌ରାଃ ହନ୍‌ ଆଜୋର୍‌, ");
INSERT INTO unx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଆଜୋର୍‌ରାଃ ହନ୍‌ ସାଦୋକ୍‌, ସାଦୋକ୍‌ରାଃ ହନ୍‌ ଆଖିମ୍‌, ଆଖିମ୍‌ରାଃ ହନ୍‌ ଏଲିହୁଦ୍‌, ");
INSERT INTO unx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ଏଲିହୁଦ୍‌ରାଃ ହନ୍‌ ଏଲିୟାଜାର୍‌, ଏଲିୟାଜାର୍‌ରାଃ ହନ୍‌ ମାତ୍ତାନ୍‌, ମାତ୍ତାନ୍‌ରାଃ ହନ୍‌ ଯାକୁବ୍‌, ");
INSERT INTO unx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ଯାକୁବ୍‌ରାଃ ହନ୍‌ ଯୋଷେଫ୍‌, ଇନିଃ ମାରିୟାମ୍‌ରାଃ କଡ଼ାତେ ତାଇକେନା, ଏନ୍‌ ମାରିୟାମ୍‌ ୟୀଶୁକେ ଜାନାମ୍‌କିୟା, ଇନିଃକେ ମାସି ମେନ୍ତେ କାଜିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ନେ ଲେକାତେ ଆବ୍ରାହାମ୍‌ଏତେ ଦାଉଦ୍‌ ଜାକେଦ୍‌ ଗେଲ୍‌ଉପୁନ୍‌ ପିଢ଼ି, ଆଡଃ ଦାଉଦ୍‌ଏତେ ବାବିଲୋନ୍‌ତେ ତଲ୍‌ଇଦିକାଦ୍‌କ ଜାକେଦ୍‌ ଗେଲ୍‌ଉପୁନ୍‌ ପିଢ଼ି, ଆଡଃ ବାବିଲୋନ୍‌ତେ ଇଦିକାଦ୍‌କ ଦିପିଲିଏତେ ମାସି ଜାକେଦ୍‌ ଗେଲ୍‌ଉପୁନ୍‌ ପିଢ଼ିକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ ନେ ଲେକାଏ ଜାନାମ୍‌ଲେନା । ଇନିୟାଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌କେ ଯୋଷେଫ୍‌ ନାଙ୍ଗ୍‌ ଆସିଆକାନ୍‌ ତାଇକେନା । ମେନ୍‌ଦ ଇନିଃଲଃ ଆଣ୍‌ଦିୟାନ୍‌ ସିଦାରେ ଇନିଃ ପାବିତାର୍‌ ଆତ୍ମାତେ ଆବ୍‌ରାଅୟାନା ଆଡଃ ହାମ୍ବାଲ୍‌ରୋୱା କାନାଏ ମେନ୍ତେ ଆଟ୍‌କାର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ଇନିୟାଃ କଡ଼ା ଯୋଷେଫ୍‌ ମିଆଁଦ୍‌ ଧାର୍‌ମାନ୍‌ ହଡ଼ ତାଇକେନାଏ, ଏନାତେ ମାରିୟାମ୍‌ ବାଦ୍‌ନାମଃକାଏ ମେନ୍ତେ ଇନିଃ କାଏ ସାନାଙ୍ଗ୍‌କେଦା, ଏନାମେନ୍ତେ ଇନିଃକେ କା ଆଣ୍‌ଦିୟଃ ନାଙ୍ଗ୍‌ ଉଡ଼ୁଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ମେନ୍‌ଦ ଇନିଃ ନେଆଁଁ ଉଡ଼ୁଃତାନ୍‌ ତାଇକେନ୍‌ରେ ପ୍ରାଭୁଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ କୁମୁରେ ଉଦୁବେନ୍‌ୟାନା ଆଡଃ କାଜିକିୟାଏ, “ହେ ଦାଉଦ୍‌ଆଃ ହନ୍‌ ଯୋଷେଫ୍‌, ଆମାଃ କୁଡ଼ି ଲେକା ମାରିୟାମ୍‌କେ ଅଡ଼ାଃତେ ଇଦିନାଙ୍ଗ୍‌ ଆଲମ୍‌ ବରଏୟା, ଚିୟାଃଚି ଇନିୟାଃ ହାମ୍ବାଲ୍‌ରୋୱା ପାବିତାର୍‌ ଆତ୍ମାତେ ହବାକାନା । ");
INSERT INTO unx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ଇନିଃ ମିଆଁଦ୍‌ କଡ଼ାହନ୍‌ ଜାନାମିଁୟାଏ, ଆଡଃ ଆମ୍‌ ଇନିଃକେ ୟୀଶୁ ମେନ୍ତେମ୍‌ ନୁତୁମିଁୟା, ଚିୟାଃଚି ଇନିଃଦ ଆୟାଃ ହଡ଼କକେ ଆକଆଃ ପାପ୍‌ହେତେ ବାଞ୍ଚାଅକଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ନାବୀକଆଃ ହରାତେ ପ୍ରାଭୁ କାଜିକାଦ୍‌ ନେ କାଜି ପୁରାଅଃ ନାଗେନ୍ତେ ନେ ସବେନାଃ ହବାକାନା, ");
INSERT INTO unx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ମିଆଁଦ୍‌ ଡିଣ୍ଡାକୁଡ଼ି ହାମ୍ବାଲ୍‌ରୋୱା ହବାଅଃଆଏ ଆଡଃ କଡ଼ାହନ୍‌ ଜାନାମିଁୟାଏ, ଆଡଃ ହଡ଼କ ଇନିଃକେ ଇମ୍ମାନୁୟେଲ୍‌” ମେନ୍ତେକ ନୁତୁମିଁୟା, ଏନାରେୟାଃ ମୁଣ୍ଡିଦ, “ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବୁଲଃରିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଏନ୍ତେ ଯୋଷେଫ୍‌ ଦୁଡ଼ୁମ୍‌ଏତେ ବିରିଦ୍‌କେଦ୍‌ତେ, ପ୍ରାଭୁଆଃ ଦୁଁତ୍‌ ଆଚୁକାଇ ଲେକା ଆୟାଃ କୁଡ଼ି ମାରିୟାମ୍‌କେ ଅଡ଼ାଃତେ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ମେନ୍‌ଦ ଇନିଃ ମୁତ୍‍କୁଲ୍‌ କଡ଼ାହନ୍‌ ଆଉରି ଜାନାମିଁ ଜାକେଦ୍‌ ଯୋଷେଫ୍‌ ଇନିଃକେ କାଏ ଜୁଟିଦ୍‍କିୟା । ଆଡଃ ଯୋଷେଫ୍‌ ଏନ୍‌ ହନ୍‌କେ ୟୀଶୁ ମେନ୍ତେ ନୁତୁମ୍‌କିଆ । ");
INSERT INTO unx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ହେରୋଦ୍‌ ରାଜାରାଃ ଦିପିଲିରେ ଯିହୁଦା ଦିଶୁମ୍‌ରେୟାଃ ବେଥ୍‌ଲେହେମ୍‌ ସାହାର୍‌ରେ ୟୀଶୁ ଜାନାମ୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ, ସିଙ୍ଗିତୁରଃସାଃରେନ୍‌ ଚିମିନ୍‌ ପାଣ୍ଡିତ୍‌କ ଯୀରୁଶାଲେମ୍‌ତେକ ହିଜୁଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ଆଡଃ କୁଲିକେଦାଃକ, “ଯିହୁଦୀକଆଃ ରାଜା ହବାଅଃନିଃ ଜାନାମାକାନ୍‌ ହନ୍‌ ଅକ୍‌ତାଃରିୟା ? ଆଲେଦ ସିଙ୍ଗିତୁରଃସାଃରେ ଇନିୟାଃ ଇପିଲ୍‌କେ ନେଲ୍‌କେଦ୍‌ତେ ଇନିଃକେ ଜହାରି ନାଗେନ୍ତେଲେ ହିଜୁଃକାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ହେରୋଦ୍‌ ରାଜା ଆଡଃ ଇନିଃଲଃ ଗଟା ଯୀରୁଶାଲେମ୍‌ରେନ୍‌କ ଆକ୍‌ବାକାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ଆଡଃ ଇନିଃ ହଡ଼କଆଃ ସବେନ୍‌ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକକେ ହାକାଅ ହୁଣ୍ଡିକେଦ୍‌ତେ “ମାସି ଚାଏ ଖ୍ରୀଷ୍ଟ୍‌, ଅକ୍‌ତାଃରେ ଜାନାମଃଆ ?” ମେନ୍ତେ କୁଲିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ଇନ୍‌କୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଯିହୁଦା ଦିଶୁମ୍‌ରେୟାଃ ବେଥ୍‌ଲେହେମ୍‌ ସାହାର୍‌ରେ,” ଚିୟାଃଚି ନେଆଁଁକେଦ ନାବୀ ନେ'ଲେକାଏ ଅଲାକାଦା, ");
INSERT INTO unx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘ରେ ଯିହୁଦା ଦିଶୁମ୍‌ରେୟାଃ ବେଥ୍‌ଲେହେମ୍‌, ଆମ୍‌ ଯିହୁଦାରେୟାଃ ମାରାଙ୍ଗ୍‌ ନାଗାର୍‌କଏତେ ଜେତାଲେକାତେ କାମ୍‌ ହୁଡିଙ୍ଗ୍‌ୟାଁ, ଚିୟାଃଚି ଆମେତେଦ ମିଆଁଦ୍‌ ଆଗୁଆଇ ଅଡଙ୍ଗ୍‌ଅଃଆଏ, ଇନିଃ ଆଇଁୟାଃ ଇସ୍ରାଏଲ୍‌ ହଡ଼କକେ ହରକଆ ।’” ");
INSERT INTO unx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ଏନ୍ତେ ହେରୋଦ୍‌, ଏନ୍‌ ସିଙ୍ଗିତୁରଃସାଃରେନ୍‌ ପାଣ୍ଡିତ୍‌କକେ ଦାନାଙ୍ଗ୍‌ତେ ହାକାଅକେଦ୍‌କଆ, ଆଡଃ ଏନ୍‌ ଇପିଲ୍‌ ଚିମ୍‌ତାଏ ନେଲଃୟାନା, ଏନା ଇନ୍‌କୁତାଃଏତେ ବୁଗିଲେକାଏ ସାରିନାମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ ବେଥ୍‌ଲେହେମ୍‌ତେ କୁଲ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆ, “ସେନଃପେ ଆଡଃ ବୁଗିଲେକାତେ ଏନ୍‌ ବାଲେଃହନ୍‌କେ ଦାଣାଁଁଇପେ ଆଡଃ ଇନିଃକେ ନାମ୍‌କିଃରେ ଉଦୁବାଇଙ୍ଗ୍‌ପେ, ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ହଁ ସେନ୍‌କେଦ୍‌ତେ ଇନିଃକେ ଜହାରିୟାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ଇନ୍‌କୁ ରାଜାରାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଆକଆଃ ହରାରେ ସେନଃୟାନାକ ଆଡଃ ନେଲେପେ, ଇନ୍‌କୁ ସିଙ୍ଗିତୁରଃସାଃରେ ନେଲାକାଇ ଏନ୍‌ ଇପିଲ୍‌କେଗି ନେଲ୍‌କିଃତେ ପୁରାଃ ରାସ୍‌କାୟାନାକ । ଏନ୍‌ ଇପିଲ୍‌, ଏନ୍‌ ହନ୍‌ ତାଇକେନ୍‌ ଠାୟାଦ୍‌ତେ ଆଉରି ସେଟେର୍‌ ଜାକେଦ୍‌ ଇନ୍‌କୁକେ ଆୟାର୍‌ ଇଦିକତାନ୍‌ ତାଇକେନା, ଏନ୍ତେ ଏନ୍‌ ଠାୟାଦ୍‌ତେ ସେଟେର୍‌ୟାନ୍‌ଚି, ଏନ୍‌ ଇପିଲ୍‌ ଏନ୍ତାଃରେ ଆଟ୍‌କାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ଇନ୍‌କୁ ଏନ୍‌ ଇପିଲ୍‌କେ ନେଲ୍‌କିଃତେ ପୁରାଃଗିକ ରାସ୍‌କାୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ଆଡଃ ଇନ୍‌କୁ ଅଡ଼ାଃତେ ବଲୟାନ୍‌ଚି ହନ୍‌କେ ଆୟାଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌ଲଃ ନେଲ୍‌କିୟାକ ଆଡଃ ଇନ୍‌କୁ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ଇନିଃକେକ ଜହାର୍‌କିୟା ଏନ୍ତେ ଆକଆଃ ପଟମ୍‌କେ ରାଡ଼ାକେଦ୍‌ତେ ସୋନା, କୁନ୍ଦୁରୁ ଆଡଃ ବୁଗିନ୍‌ ସହାନ୍‌ସୁନୁମ୍‌ ଦାନ୍‌କ ଏମ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ଏନ୍ତେ ହେରୋଦ୍‌ତାଃତେ ଆଲ୍‌ପେ ସେନ୍‌ରୁହାଡ଼ାଃ ମେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆନାଚୁ କୁମୁରେ ନାମ୍‌ୟାନ୍‌ଚି, ଇନ୍‌କୁ ଏଟାଃ ହରାତେ ଆକଆଃ ଦିଶୁମ୍‌ତେକ ସେନଃରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ଇନ୍‌କୁ ସେନଃୟାନ୍‌ ତାୟମ୍‌ତେ, ପ୍ରାଭୁଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ଯୋଷେଫ୍‌ତାଃତେ କୁମୁରେ ହିଜୁଃୟାନା ଆଡଃ କାଜିକିୟାଏ, “ହେରୋଦ୍‌, ହନ୍‌ତାମାଃକେ ଗଏଃନାଙ୍ଗ୍‌ ଦାଣାଁଁତାନାଏ, ଏନାତେ ମାର୍‌ ବିରିଦ୍‌ମେ, ହନ୍‌ ଆଡଃ ଆୟାଃ ଏଙ୍ଗାତେକେ ମିସାର୍‌ ଦିଶୁମ୍‌ତେ ଇଦିକିନ୍‌ମେ ଆଡଃ ଆଉରିଙ୍ଗ୍‌ ଉଦୁବାମେ ଜାକେଦ୍‌ ଏନ୍ତାଃରେ ତାଇନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ଯୋଷେଫ୍‌ ବିରିଦ୍‌କେଦ୍‌ତେ ଏନ୍‌ ନିଦାରେଗି ହନ୍‌ ଆଡଃ ଇନିୟାଃ ଏଙ୍ଗାତେକେ ମିସାର୍‌ ଦିଶୁମ୍‌ତେ ଇଦିକେଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ହେରୋଦ୍‌ ଆଉରି ଗଜଃ ଜାକେଦ୍‌ ଏନ୍ତାଃରେଗି ତାଇନ୍‍ୟାନା । “ଆଇଙ୍ଗ୍‌ ମିସାର୍‌ ଦିଶୁମ୍‌ହେତେ ହନିଙ୍ଗ୍‌କଡ଼ାକେଇଙ୍ଗ୍‌ କେଡ଼ାଆଉକିୟା” ମେନ୍ତେ ନାବୀତେ କାଜିକାଦ୍ ପ୍ରାଭୁଆଃ କାଜି ନେ ଲେକାତେ ପୁରାୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ହେରୋଦ୍‌ ରାଜା, ସିଙ୍ଗିତୁରଃସାଃରେନ୍‌ ପାଣ୍ଡିତ୍‌ ହଡ଼କ ବେଦାକେଦିୟାଁ ମେନ୍ତେ ଆଟ୍‌କାର୍‌କେଦ୍‍ଚି, ପୁରାଃଗି ଖିସ୍‌ୟାନା ଆଡଃ ପାଣ୍ଡିତ୍‌କକେ କୁଲିକେଦ୍‌ତେ ଅକ୍‌ନାଃ ସାରିକାଦ୍‌ ତାଇକେନାଏ, ଏନ୍‌ ଲେକାଗି ବେଥ୍‌ଲେହେମ୍‌ରେନ୍‌ ଆଡଃ ଏନାରେୟାଃ ହପର୍‌ଜାପାଃରେନ୍‌ ହନ୍‌କ, ଅକନ୍‌କଚି ବାବାର୍‌ ସିର୍ମାରେନ୍‌ ଆଡଃ ଏନାଏତେ ହୁପ୍‌ଡିଙ୍ଗ୍‌ ସବେନ୍‌ କଡ଼ାହନ୍‌କକେ ଗଏଃନାଙ୍ଗ୍‌ ଆଚୁକେଦ୍‍କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ନେ ଲେକାତେ ଯିରିମିୟ ନାବୀ କାଜିଲେଦ୍ କାଜି ପୁରାୟାନା, ");
INSERT INTO unx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ରମା ସାହାର୍‌ରେ ହାୟ ହାୟରେୟାଃ ରାଆଃ ଆଡଃ ପୁରାଃ କୁସୁଦ୍‌ କୁସୁଦ୍‌ ରାଆଃ ଆୟୁମ୍‌ୟାନା, ରାହେଲ୍‌ ଆୟାଃ ହନ୍‌କ ନାଗେନ୍ତେ କୁସୁଦ୍‌ କୁସୁଦ୍‌ ରାଆଃ କେଦାଏ; ଇନିଃ ଜୀଉରାଡ଼େଜେନ୍‌ କାଏ ସାନାଙ୍ଗ୍‌ତାନ୍‌ ତାଇକେନା, ଚିୟାଃଚି ଆୟାଃ ସବେନ୍‌ ହନ୍‌କ ଗଏଃୟାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ହେରୋଦ୍‌ ଗଏଃୟାନ୍‌ ତାୟମ୍‌ତେ, ପ୍ରାଭୁଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ମିସାର୍‌ ଦିଶୁମ୍‌ରେ ଯୋଷେଫ୍‌ତାଃରେ କୁମୁରେ ଉଦୁବେନ୍‌ୟାନ୍‌ଲଃ କାଜିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ବିରିଦ୍‌ମେ, ହନ୍‌ ଆଡଃ ଇନିୟାଃ ଏଙ୍ଗାତେକେ ଇସ୍ରାଏଲ୍‌ ଦିଶୁମ୍‌ତେ ସୁତୁଃଇଦିକିନ୍‍ମେ, ଚିୟାଃଚି ହନ୍‌ରାଃ ଜୀଉ ଇଦି ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ ତାଇକେନ୍‌ ହଡ଼କଦ ଗଏଃୟାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ଏନ୍ତେ ଯୋଷେଫ୍‌ ବିରିଦ୍‌କେଦ୍‌ତେ ହନ୍‌ ଆଡଃ ଇନିୟାଃ ଏଙ୍ଗାତେକେ ଇସ୍ରାଏଲ୍‌ ଦିଶୁମ୍‌ତେ ସୁତୁଃରୁହାଡ଼୍‌କେଦ୍‍କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ମେନ୍‌ଦ ଆର୍ଖିଲିୟସ୍‌ ଆୟାଃ ଆପୁତେ ହେରୋଦ୍‌ଆଃ ଠାୟାଦ୍‌ରେ ଯିହୁଦା ଦିଶୁମ୍‌ରେ ରାଜାକାନା ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ତେ, ଇନିଃ ଗାଲିଲ୍‌ତେ ସେନ୍‌ନାଙ୍ଗ୍‌ ବରକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ଆଡଃ କୁମୁରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଚୁକାଦ୍‌ ଲେକା ଗାଲିଲ୍‌ ଦିଶୁମ୍‌ରାଃ ନାଜ୍‌ରେତ୍‌ ସାହାର୍‌ତେ ସେନଃୟାନା । ଆଡଃ “ଇନିଃ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ମେନ୍ତେ ନୁତୁମଃଆ ।” ମେନ୍ତେ କାଜିକାନ୍‌ ନାବୀକଆଃ କାଜି ନେ ଲେକାତେ ପୁରାୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ଏନ୍‌ ଦିପିଲିରେ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ହିଜୁଃୟାନାଏ, ଆଡଃ ଯିହୁଦାରେୟାଃ ବିର୍‌ରେ ଇନିତୁ କାଜି ଏଟେଦ୍‌କେଦା, ");
INSERT INTO unx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“ଆପେୟାଃ ପାପ୍‌ହେତେ ମନ୍‌ରୁହାଡ଼େପେ ଚିୟାଃଚି ସିର୍ମା ରାଇଜ୍‌ଦ ନାଡ଼େଃରେଗିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ଅକନ୍‌ ହଡ଼ଆଃ ବିଷାଏରେ ଯିଶାୟ ନାବୀ କାଜିକାଦ୍‌ନିଃ ଯୋହାନ୍‌ଗି ତାନିଃ : ଇନିଃ କାଜିକେଦାଏ, “ଜେତାଏ ବିର୍‌ରେ କାଉରିତାନ୍‌ନିୟାଃଁ ସାଡ଼ି ଆୟୁମଃତାନା, ‘ପ୍ରାଭୁଆଃ ହରା ବାଇୟେପେ; ଇନିୟାଃ ନାଙ୍ଗ୍‌ ହରା ସିଧାଏପେ ।’” ");
INSERT INTO unx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଯୋହାନ୍‌ ଉଁଟ୍‌ରାଃ ଉବ୍‌ତେ ବାଇୟାକାନ୍ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଅଃଁତାନ୍‌ ତାଇକେନାଏ, ଆୟାଃ ମାୟାଙ୍ଗ୍‌ରେ ଉହୁର୍‌ରାଃ କାସ୍‌ନା ତଲଃ ତାଇକେନାଏ ଆଡଃ ଇନିଃ ସନ୍‌ସରେଦ୍‌ ଆଡଃ ହୁରୁମ୍‌ସୁୁକୁ ଜମ୍‌କତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ଯୀରୁଶାଲେମ୍‌ରେନ୍‌କ, ଗଟା ଯିହୁଦାରେନ୍‌କ ଆଡଃ ଯାର୍ଦାନ୍‌ ନାହିଁରାଃ ସବେନ୍‌ ହପର୍‌ଜାପାଃରେନ୍‌ ହଡ଼କ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ଆଡଃ ଇନ୍‌କୁ ଆକଆଃ ପାପ୍‌କ ପାତିୟାର୍‌କେଦା, ଏନ୍ତେ ଇନିଃ ଯାର୍ଦାନ୍‌ ନାହିଁରେ ଇନ୍‌କୁକେ ବାପ୍ତିସ୍ମାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ମେନ୍‌ଦ ଯୋହାନ୍‌ ପୁରାଃ ଫାରୁଶୀକ ଆଡଃ ସାଦୁକିକ ଆୟାଃତାଃତେ ବାପ୍ତିସ୍ମା ନାମେ ନାଗେନ୍ତେ ହିଜୁଃତାନାଏ ନେଲ୍‌କେଦ୍‍କଚି ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଏ ବିଙ୍ଗ୍‌କଆଃ ହନ୍‌କ !” ହିଜୁଃତାନ୍‌ ମାରାଙ୍ଗ୍‌ ଏନେସେଦ୍‌ଏତେ ନିର୍‌ ନାଗେନ୍ତେ ଅକଏ ଆପେକେ ଚେତାୱାଦ୍‌ପେୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ଆପେ ସାର୍‌ତିଗି ପାପ୍‌ଏତେ ହେୟାତିଙ୍ଗ୍‌କାଦ୍‌ରେଦ ଆପେୟାଃ ବୁଗିନ୍‌ କାମିତେ ଉଦୁବେନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ଆଡଃ ଆବ୍ରାହାମ୍‌ ଆଲେୟାଃ ଆପୁ ତାନିଃ ମେନ୍ତେ ଆପେ ଡିଡିକେଦ୍‌ତେ କାଜିତାନ୍‌ଲଃ ନେ ସାଜାଇଏତେ ବାଞ୍ଚାୱାଃଲେ ମେନ୍ତେ ଆଲ୍‌ପେ ଉଡ଼ୁଃୟା । ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ପାର୍‌ମେଶ୍ୱାର୍‌ଦ ନେ ଦିରିକଏତେ ଆବ୍ରାହାମ୍‌ ନାଗେନ୍ତେ ହନ୍‌କଏ ବାଇଦାଡ଼ିୟା ! ");
INSERT INTO unx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ଆଡଃ ନାହାଁଃ ଦାରୁରେୟାଃ ବୁଟାରେ ହାକେ ମାଣ୍ଡାୱା କାନା; ଅକନ୍‌ ଦାରୁ ବୁଗିନ୍‌ ଜ କା ଜଅଃ'ଆ ଏନାକେ ମାଗଃଆ ଆଡଃ ସେଙ୍ଗେଲ୍‌ରେ ହୁରାଙ୍ଗ୍‌ଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“ଆଇଙ୍ଗ୍‌ଦ ଆପେୟାଃ ହେୟାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଦାଆଃତେ ବାପ୍ତିସ୍ମାପେ ତାନାଇଙ୍ଗ୍‌ ମେନ୍‌ଦ ଆଇଁୟାଃ ତାୟମ୍‌ତେ ଆଇଙ୍ଗ୍‌ଏତେ ପେଡ଼େୟାନ୍‌ନିଃ ହିଜୁଃତାନାଏ; ଇନିୟାଃ ଖାର୍‌ପା ଗଅଃଇଦି ଲେକାନିଃହ ଆଇଙ୍ଗ୍‌ ନାହାଁଲିଙ୍ଗ୍‌ । ଇନିଃ ଆପେକେ ପାବିତାର୍‌ ଆତ୍ମା ଆଡଃ ସେଙ୍ଗେଲ୍‌ତେ ବାପ୍ତିସ୍ମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ଆୟାଃ ତିଃଇରେ ହାଟାଆଃ ମେନାଃ, ଏନାତେ କଲମ୍‌ରେୟାଃ ଗହମ୍‌ ଆଡଃ ବାବା ଗୁମ୍ ସାଫାକେଦ୍‌ତେ ଆୟାଃ ଭାଣ୍ଡାର୍‌ ଅଡ଼ାଃରେ ମାଣ୍ଡାଅୟା ଆଡଃ ପେଟେଃକେ କା ଇଣିଁଜଃ ସେଙ୍ଗେଲ୍‌ରେ ଅଣ୍ଡର୍‌ଏଣ୍ଡାଗେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ଏନ୍‌ ଦିପିଲିରେ ୟୀଶୁ ଯୋହାନ୍‌ତେ ବାପ୍ତିସ୍ମା ଇଦି ନାଗେନ୍ତେ ଗାଲିଲ୍‌ଏତେ ଯାର୍ଦାନ୍‌ ନାହିଁତେ ହିଜୁଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ମେନ୍‌ଦ ଯୋହାନ୍‌ ଇନିଃକେ ମାନାତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌କେ ଆମାଃଏତେ ବାପ୍ତିସ୍ମା ଇଦି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଏନ୍‌ରେହଗି ଆମ୍‌ ଆଇଙ୍ଗ୍‌ତାଃତେମ୍ ହିଜୁଆକାନା !” ");
INSERT INTO unx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ମେନ୍‌ଦ ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ନାହାଁଃ ନେଆଁଁରେ ମାନାତିଙ୍ଗ୍‌ୟଁଃମେ, ଚିୟାଃଚି ନେ ଲେକାତେ ଆବୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସବେନ୍‌ ଧାର୍‌ମାନ୍‌ କାଜି ପୁରାନାଙ୍ଗ୍‌ ଆବୁକେ ରିକା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ଏନ୍ତେ ଯୋହାନ୍‌ ଇନିୟାଃ କାଜିକେ ମାନାତିଙ୍ଗ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ୟୀଶୁ ବାପ୍ତିସ୍ମାୟାନ୍‌ ତର୍‌ସା ଦାଆଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନା । ଏନ୍ତେ ଇନିଃ ନାଗେନ୍ତେ ସିର୍ମା ନିଜ୍‌ୟାନା ଆଡଃ ଇନିଃରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆତ୍ମା ଦୁଦୁମୁଲ୍‌ ଲେକା ଆଡ଼୍‌ଗୁଃତାନ୍‌ତେୟାଃ ଯୋହାନ୍‌ ନେଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ଆଡଃ ସିର୍ମାଏତେ ନେ'ଲେକା କାଜି ଆୟୁମ୍‌ୟାନା, “ନିଃଗି ଆଇଁୟାଃ ଦୁଲାଡ଼୍‌ ହନ୍‌ ତାନିଃ, ନିଃତାଃରେ ଆଇଁୟାଃ ପୁରାଃଗି ସୁକୁ ।” ");
INSERT INTO unx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ଏନ୍ତେ ପାବିତାର୍‌ ଆତ୍ମା ୟୀଶୁକେ ବିର୍‌ତେ ଇଦିକିୟା, ଏନ୍ତାଃରେ ସାଏତାନ୍‌ ଇନିଃକେ ବିଡ଼ାଅକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ବାର୍‌ହିସି ନିଦାସିଙ୍ଗି ରେଙ୍ଗେଃ କାଟାବ୍‌କେଦ୍‍ ତାୟମ୍‌ତେ ୟୀଶୁକେ ରେଙ୍ଗେଜ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ଏନ୍ତେ ସାଏତାନ୍‌ ଇନିଃତାଃତେ ହିଜୁଃୟାନା ଆଡଃ କାଜିକିୟାଏ, “ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେରେଦ, ନେ ଦିରିକକେ ହଲଙ୍ଗ୍‌ ବାଇୟଃକା ମେନ୍ତେ ଆଚୁତାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ମେନ୍‌ଦ ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟା, “ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ହଡ଼ ହଲଙ୍ଗ୍‌ତେ ଏସ୍‌କାର୍‌ କା ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମଚାଏତେ ଅଡଙ୍ଗ୍‌ଅଃତାନ୍‌ ସବେନ୍‌ କାଜିତେ ଜୀହିଦଃଆ ।’” ");
INSERT INTO unx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ଏନ୍ତେ ସାଏତାନ୍‌ ୟୀଶୁକେ ଯୀରୁଶାଲେମ୍‌ ଏନ୍‌ ପାବିତାର୍‌ ନାଗାର୍‌ତେ ଇଦିକିଃତେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେୟାଃ ଚୁଟିରେ ତିଙ୍ଗୁକିୟା, ");
INSERT INTO unx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ଆଡଃ କାଜିକିୟାଏ, “ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେରେଦ ନେତାଃଏତେ ଲାତାର୍‌ତେ ଡେଗାଅତାମେ, ଚିୟାଃଚି ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, “‘ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ଦୁଁତ୍‌କକେ ଆଚୁକଆ; ଆଡଃ ଆମାଃ କାଟା ଦିରିରେ ଆଲକା ଠଗଃକା ମେନ୍ତେ ଇନ୍‌କୁ ଆକଆଃ ତିଃଇତେକ ତେଲାମେୟାଁ ।’” ");
INSERT INTO unx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଧାରାମ୍‌ପୁଥିରେ ନେଆଁଁହଗି ଅଲାକାନା, ‘ପ୍ରାଭୁ ଆମାଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଆଲମ୍‌ ବିଡ଼ାଅଇୟା ।’” ");
INSERT INTO unx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ଏନ୍ତେ ସାଏତାନ୍‌ ୟୀଶୁକେ ମିଆଁଦ୍‌ ସାଲାଙ୍ଗି ବୁରୁତେ ଇଦିକିଃତେ ଅତେଦିଶୁମ୍‌ରେୟାଃ ସବେନ୍‌ ରାଇଜ୍‌ ଆଡଃ ଏନାରେୟାଃ ସୁଗାଡ଼ାନ୍‌ତେୟାଃକ ଉଦୁବ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ଆଡଃ ସାଏତାନ୍‌ ୟୀଶୁକେ କାଜିକିୟାଏ, “ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ଜହାରିଙ୍ଗ୍‌ରେଦମ୍ ନେ ସବେନାଃଇଙ୍ଗ୍‌ ଏମାମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ଏନ୍ତେ ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆତମେନ୍‌ମେ ସାଏତାନ୍‌, ଚିୟାଃଚି ନେଆଁଁ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ପ୍ରାଭୁ ଆମାଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଜହାରିମେ ଆଡଃ ଇନିଃକେ ଏସ୍‌କାର୍‌ ସୁସାରିମେ ।’” ");
INSERT INTO unx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ଏନ୍ତେ ସାଏତାନ୍‌ ୟୀଶୁକେ ବାଗିକେଦ୍‌ତେ ନିର୍‌ୟାନା ଆଡଃ ଦୁଁତ୍‌କ ହିଜୁଃକେଦ୍‌ତେ ଇନିଃକେ ସୁସାର୍‌ ଏଟେଦ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ଯୋହାନ୍‌ ଜେହେଲ୍‌ୟାନାଏ ମେନ୍ତେ ୟୀଶୁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଗାଲିଲ୍‌ ସାହାର୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ନାଜ୍‌ରେତ୍‌ ବାଗିକେଦ୍‌ତେ ସବ୍‌ଲୁନ୍‌ ଆଡଃ ନପ୍ତାଲି ସିମ୍‌ନାରାଃ ଗାଲିଲ୍‌ ଦରେୟା ହେପାଦ୍‌ରାଃ କପର୍‌ନାହୁମ୍‌ ସାହାର୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ତାଇନ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ନେଆଁଁତେ ଯିଶାୟ ନାବୀ କାଜିକାଦ୍ କାଜି ପୁରାୟାନା, ");
INSERT INTO unx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ସବ୍‌ଲୁନ୍‌ ଦିଶୁମ୍‌ ଆଡଃ ନପ୍ତାଲି ଦିଶୁମ୍‌, ଦରେୟା ହେପାଦ୍‌ରାଃ ଯାର୍ଦାନ୍‌ ଗାଡ଼ା ହାନ୍‌ ପାରମ୍‌ରେ ସାଅଁସାର୍‌କଆଃ ଗାଲିଲ୍‌ ଦିଶୁମ୍‌, ");
INSERT INTO unx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ନୁବାଃରେ ତାଇନ୍‌କାନ୍‌ ହଡ଼କ ମାରାଙ୍ଗ୍‌ ମାର୍ସାଲ୍‌କ ନେଲେୟା ଆଡଃ ଗନଏଃରେୟାଃ ଉମ୍ବୁଲ୍‌ରେ ତାଇନ୍‌କାନ୍‌ ହଡ଼କ ନାଙ୍ଗ୍‌ ମାର୍ସାଲ୍‌ ତୁରଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ଏନ୍‌ ଦିପିଲିଏତେ ୟୀଶୁ ଇତୁ ଏଟେଦ୍‌କେଦ୍‌ତେ କାଜିକେଦା, “ଆପେୟାଃ ପାପ୍‌ହେତେ ମନ୍‌ରୁହାଡ଼େପେ ଚିୟାଃଚି ସିର୍ମା ରାଇଜ୍‌ଦ ନାଡ଼େଃରେଗିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ୟୀଶୁ ଗାଲିଲ୍‌ ଦରେୟା ଗେନାଗେନାତେ ସେନଃତାନ୍‌ ଇମ୍‌ତା, ପାତ୍‌ରାସ୍‌ ନୁତୁମଃତାନ୍‌ ଶିମୋନ୍‌ ଆଡଃ ଆୟାଃ ହାଗାତେ ଆନ୍ଦ୍ରିୟ, ଏନ୍‌ ବାରାନ୍‌ ହାଗିୟାକିନ୍‌କେ ଦରେୟାରେ ଜାଲୋମ୍‌ ହୁଦ୍‌ମାକେଦ୍‌ତେ ହାକୁ ସାବ୍‌ତାନ୍‌ ନେଲ୍‌କେଦ୍‌କିନାଏ, ଚିୟାଃଚି ଇନ୍‌କିନ୍‌ଦ କେଉଁଟ୍‌କିନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ କାଜିୟାଦ୍‌କିନା, “ଦେଲା ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ବେନ୍‌, ଆଇଙ୍ଗ୍‌ ଆବେନ୍‌କେ ହଡ଼କକେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃତେ ଆଉତେୟାଃ ଇତୁବେନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଜାଲୋମ୍‌ ବାଗିକେଦ୍‌ତେ ୟୀଶୁକେ ଅତଙ୍ଗ୍‌କିୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ୟୀଶୁ ଏନ୍ତାଃଏତେ କାଟିଃସାଙ୍ଗିନ୍‌ ଆୟୁର୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ଏଟାଃ ବାର୍‌ହଡ଼୍‌ ହାଗିୟାକିନ୍‌, ଜେବଦୀୟାଃ ହନ୍‌ ଯାକୁବ୍‌ ଆଡଃ ଆୟାଃ ହାଗାତେ ଯୋହାନ୍‌କେ ଆକିନାଃ ଆପୁତେ ଜେବଦୀଲଃ ଲାଉକାରେ ଜାଲୋମ୍‌ ଚାପିତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ଇନ୍‌କିନ୍‌କେ କେଡ଼ାକେଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଲାଉକା ଆଡଃ ଆକିନାଃ ଆପୁତେକେ ବାଗିକେଦ୍‌ତେ ୟୀଶୁକେ ଅତଙ୍ଗ୍‌କିୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ୟୀଶୁ ଗଟା ଗାଲିଲ୍‌ ସେନ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଇତୁତାନ୍‌ଲଃ ରାଇଜ୍‌ରେୟାଃ ସୁକୁକାଜି ଉଦୁବ୍‍କେଦାଏ ଆଡଃ ହଡ଼କଆଃ ସବେନ୍‌ ଦୁକୁ ଆଡଃ ସବେନ୍‌ ହାସୁକଏତେ ବୁଗିକତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ଆଡଃ ଇନିୟାଃ ନୁତୁମ୍‌ ଗଟା ସିରିୟା ଦିଶୁମ୍‌ ଜାକେଦ୍‌ ସେଟେର୍‌ୟାନା ଆଡଃ ହଡ଼କ ସବେନ୍‌ ଲେକାନ୍‌ ଦୁକୁତାନ୍‌, ହାସୁତାନ୍‌କକେ ଆଡଃ ବଙ୍ଗା ଏସେର୍‌କାନ୍‌କକେ, ମିର୍କି ବେମାର୍‌କକେ, ଆଡଃ ବାତ୍‌ତାକାନ୍‌କକେ ଇନିଃତାଃତେକ ଆଉକେଦ୍‌କଆ ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ବୁଗିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ଆଡଃ ଗାଲିଲ୍‌, ଦେକାପଲ୍ଲୀ, ଯୀରୁଶାଲେମ୍‌, ଯିହୁଦା ଆଡଃ ଯାର୍ଦାନ୍‌ ହାନ୍‌ ପାରମ୍‌ଏତେ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେକ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ୟୀଶୁ ଗାଦେଲ୍‌ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌ତେ ବୁରୁତେ ରାକାବ୍‌ୟାନା ଆଡଃ ଇନିଃ ଦୁବାକାନ୍‌ତାଃ ଆୟାଃ ଚେଲାକ ହୁଣ୍ଡିବିୟୁର୍‌କିୟାକ, ");
INSERT INTO unx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ଆଡଃ ଇନିଃ ହଡ଼କକେ ଇତୁ ଏଟେଦ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆ, ");
INSERT INTO unx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ଆତ୍ମାରେ ରେଙ୍ଗେଃତାନ୍‌କ ସୁକୁତାନ୍‌ଗିୟାଃ; ଚିୟାଃଚି ସିର୍ମା ରାଇଜ୍‌ ଇନ୍‌କୁଆଃଗି ତାନାଃ ! ");
INSERT INTO unx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ଏୟମେଁତାନ୍‌କ ସୁକୁତାନ୍‌ଗିୟାଃ; ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଦ ଇନ୍‌କୁକେ ଜୀଉରାଡ଼େଃକଆ ! ");
INSERT INTO unx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ଲେବେଃଜୀଉକ ସୁକୁତାନ୍‌ଗିୟାଃ; ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ ବାନାର୍‌ସା ଏମାକାଦ୍‌ତେୟାଃକ ଅତେରେକ ଆକ୍‌ତେୟାର୍‌ରେୟା । ");
INSERT INTO unx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ଆପେ ଧାର୍‌ମାନ୍‌ ନାଗେନ୍ତେ ରେଙ୍ଗେଃତାନ୍‌କ, ସୁକୁତାନ୍‌ ଗିୟାଃପେ; ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେକେ ବିୟଃଗି ଏମାପେୟା ! ");
INSERT INTO unx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ଦାୟାତାନ୍‌କ ସୁକୁତାନ୍‌ଗିୟାଃ; ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କୁକେ ଦାୟାକଆ ! ");
INSERT INTO unx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ମନ୍‌ରେ ଫାର୍‌ଚିଆକାନ୍‌କ ସୁକୁତାନ୍‌ଗିୟାଃ; ଚିୟାଃଚି ଇନ୍‌କୁଦ ପାର୍‌ମେଶ୍ୱାର୍‌କେକ ନେଲିୟା ! ");
INSERT INTO unx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ବାପାଇଚିକ ସୁକୁତାନ୍‌ଗିୟାଃ; ଚିୟାଃଚି ଇନ୍‌କୁଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌କ ନୁତୁମଃଆ ! ");
INSERT INTO unx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ଧାର୍‌ମାନ୍‌ ନାଗେନ୍ତେ ସାସାତି ନାମ୍‌ତାନ୍‌କ ସୁକୁତାନ୍‌ଗିୟାଃ; ଚିୟାଃଚି ସିର୍ମା ରାଇଜ୍‌ଦ ଇନ୍‌କୁଆଃଗି ତାନାଃ ! ");
INSERT INTO unx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ଆଇଙ୍ଗ୍‌ ନାଗେନ୍ତେ ହଡ଼କ ଆପେକେ ନିନ୍ଦାପେୟାକ, ସିଗିଦ୍‍ପେୟାକ, ଆଡଃ ହସଡ଼ କାଜିତେ ଆପେୟାଃ ବିରୁଧ୍‌ରେ ଏତ୍‌କାନ୍‌ କାଜିକ କାଜିୟାପେରେଦ, ଆପେ ସୁକୁତାନ୍‌ଗିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ଆପେ ପୁରାଃଗି ରାସ୍‌କାଅଃପେ, ଚିୟାଃଚି ସିର୍ମା ଦିଶୁମ୍‌ରେଦ ଆପେୟାଃ ନାଲା ପୁରାଃଗିୟା, ଏନ୍‌ ଲେକାଗିଦ ଇନ୍‌କୁ ଆପେୟାଃ ସିଦାରେନ୍‌ ନାବୀକକେ ସିଗିଦ୍‌କେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ଆପେ ସବେନ୍‌କ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ବୁଲୁଙ୍ଗ୍‌ ଲେକାଗି ତାନ୍‌ପେ, ମେନ୍‌ଦ ବୁଲୁଙ୍ଗ୍‌ ସାବାଗଃରେଦ ଏନା ଚିଲ୍‌କାତେ ଆଡଃମିସା ସିବିଲ୍‌ରୁହାଡ଼ଃଆ ? ଏନା ଆଡଃ ଜେତାନ୍‌ କାମିରେ କା ଲାଗାତିଙ୍ଗ୍‌ ଦାଡ଼ିୟଃଆ ଆଡଃ ବାହାରିରେ ହୁରାଙ୍ଗ୍‌ ଏଣ୍ଡାଗଃଆ । ହଡ଼କ ଏନାକେ ତିକାକେଦ୍‌ତେ ସେନଃଆକ । ");
INSERT INTO unx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“ଆପେ ଅତେଦିଶୁମ୍‌ରେୟାଃ ମାର୍ସାଲ୍‌ ଲେକାଗି ତାନ୍‌ପେ । ବୁରୁରେ ବାଇକାନ୍‌ ନାଗାର୍‌ କା ଉକୁଦାଡ଼ିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ଆଡଃ ହଡ଼କ ଦିମି ଜୁଲ୍‌କେଦ୍‌ତେ ତାୱାଲାତାର୍‌ରେ କାକ ହାରୁବେୟା ମେନ୍‌ଦ ଦିର୍କାରେକ ଦହୟା, ଆଡଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌କକେ ଏନା ମାର୍ସାଲ୍‌ ଏମାକଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ଏନ୍‌ ଲେକାଗି ଆପେୟାଃ ମାର୍ସାଲ୍‌ ହଡ଼କଆଃ ଆୟାର୍‌ରେ ମାସ୍କାଲଃକା, ଏନାତେ ଇନ୍‌କୁ ଆପେୟାଃ ବୁଗିନ୍‌ କାମି ନେଲ୍‌କେଦ୍‌ତେ ସିର୍ମା ଦିଶୁମ୍‌ରେନ୍‌ ଆପୁକେକ ମାରାଙ୍ଗ୍‌ଇକା । ");
INSERT INTO unx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ଆଇଙ୍ଗ୍‌ ମୁଶା ନାବୀ ଏମାକାଦ୍‌ ଆନ୍‌ଚୁ ଆଡଃ ନାବୀକଆଃ ଇନିତୁ ଇଣିଁଃ ନାଗେନ୍ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ ଆଲ୍‌ପେ ଆଟ୍‌କାରେୟା, ମେନ୍‌ଦ ଏନା ପୁରାଅଃ ନାଗେନ୍ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିତାନାଇଙ୍ଗ୍‌, ସିର୍ମା ଦିଶୁମ୍‌ ଆଡଃ ଅତେ ଆଉରି ଜିୟନଃ ଜାକେଦ୍‌ ଆଡଃ ସବେନାଃ ଆଉରି ଚାବାଃଅ ଜାକେଦ୍‌, ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁରେୟାଃ ହୁଡିଙ୍ଗ୍‌ ଅନଲ୍‌ ଚାଏ ହୁଡିଙ୍ଗ୍‌ ବିନ୍ଧୁହ ଜେତାଲେକାତେ କା ଜିୟନଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ଏନା ନାଗେନ୍ତେ ଜେତାଏ ନେ ହୁପ୍‌ଡିଙ୍ଗ୍‌ ଆନ୍‍ଚୁଏତେ ଜେତା ମିଆଁଦ୍‌ ଆନ୍‌ଚୁ କାଏ ମାନାତିୟାଁଃ ଆଡଃ ଏନ୍‌ ଲେକାଗି ହଡ଼କକେ ଇତୁକଆ, ଇନିଃ ସିର୍ମା ରାଇଜ୍‌ରେ ସବେନ୍‌କଏତେ ହୁଡିଙ୍ଗ୍‌ ମେନ୍ତେ ଲେକାଅଃଆଏ ମେନ୍‌ଦ ଜେତାଏ ଏନ୍‌ ସବେନାଃକେ ମାନାତିୟାଁଃ ଆଡଃ ଇତୁଆଃଏ, ଇନିଃ ସିର୍ମା ରାଇଜ୍‌ରେ ମାରାଙ୍ଗ୍‌ ମେନ୍ତେ ଲେକାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ଆପେୟାଃ କାମି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମନେ ଲେକା, ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକଆଃଏତେ ଆଦ୍‌କା ପାତିୟାର୍‌ କା ହବାଅଃ ଜାକେଦ୍‌ ଆପେ ଜେତାଲେକାତେ ସିର୍ମା ରାଇଜ୍‌ରେ କାପେ ବଲ ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ସିଦା ଦିପିଲିରେନ୍‌ ହଡ଼କକେ କାଜିୟାକାନ୍‌ ତାଇକେନା, ‘ଆଲମ୍‌ ଗଗଏଃ ଆଡଃ ଜେତାଏ ଗଗଏଃରେଦ, ଇନିଃ ବିଚାର୍‌ରେ ସାଜାଇ ନାମେୟାଏ’ ମେନ୍ତେ ଆପେ ଆୟୁମ୍‌କାଦାପେ । ");
INSERT INTO unx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଜେତାଏ ଆୟାଃ ହାଗାକେ ଖିସ୍‌ଅଃଆଏ, ଇନିଃ ବିଚାର୍‌ରେ ସାଜାଇ ନାମେୟାଏ । ଆଡଃ ଜେତାଏ ଆୟାଃ ହାଗାତେକେ ଡଣ୍ଡ ମେନ୍ତେ କାଜିନିଃ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ରେ ସାଜାଇ ନାମେୟାଏ, ଆଡଃ ଜେତାଏ କକଲେ ମେନ୍ତେ କାଜିନିଃ ସେଙ୍ଗେଲ୍‌ ନାରାକ୍‌ରେ ସାଜାଇ ନାମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ଏନାମେନ୍ତେ ଆମ୍‌ ଆମାଃ ଦାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନାଗେନ୍ତେ ବେଦିତେମ୍‌ ଆଉୱେ ଇମ୍‌ତା ଆମାଃ ବିରୁଧ୍‌ରେ ଆମାଃ ହାଗାମାଃ ଜେତା କାଜି ମେନାଃ ମେନ୍ତେମ୍‌ ପାହାମ୍‌ତାରେ, ");
INSERT INTO unx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ଏନ୍‌ ବେଦିତାଃରେ ଆମାଃ ଦାନ୍‌କେ ବାଗିକେଦ୍‌ତେ ସେନଃମେ ଆଡଃ ସିଦାତେ ଆମାଃ ହାଗାମ୍‌ଲଃ ବାପାଇୟେନ୍‌ମେ, ଏନ୍ତେ ହିଜୁଃକେଦ୍‌ତେ ଆମାଃ ଦାନ୍‌କେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ରାକାବେମେ । ");
INSERT INTO unx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ଆମାଃ ବାଇରିଲଃ ହରାରେ ସେନ୍‌ତାନ୍‌ ଇମ୍‌ତା ବାପାଇଦାବେନ୍‌ମେ, କା'ରେଦ ବାଇରି ଆମ୍‌କେ ବିଚାର୍‌ନିୟାଃ ତିଃଇରେ ଏମ୍‌ମେୟା, ଆଡଃ ବିଚାର୍‌ନିଃ ସିପାଇକଆଃ ତିଃଇରେ ଜିମାମେଁୟା, ଏନ୍ତେ ଆମ୍‌ ଜେହେଲଃଆମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ସାର୍‌ତିଗି କାଜିତାନା, ଆମ୍‌ କାଉଡ଼ି କାଉଡ଼ି ଆଉରି ହାଲ୍‌ଚାବାଏ ଜାକେଦ୍‌ ଏନ୍ତାଃଏତେ କାମ୍‌ ଅଡଙ୍ଗ୍‌ ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ଆଲ୍‌ପେ ଆପାଙ୍ଗିରାଃ, ମେନ୍ତେ ‘କାଜିୟାକାନ୍‌ କାଜିପେ ଆୟୁମାକାଦାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେଇଙ୍ଗ୍‌ କାଜିପେତାନା, ଜେତାଏ ଜେତା କୁଡ଼ିକେ ଏତ୍‍କାନ୍‌ ସାନାଙ୍ଗ୍‌ତେ ନେଲିରେଦ ଇନିଃ ଆୟାଃ ମନ୍‌ରେ ଇନିଃଲଃ ଆପାଙ୍ଗିର୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ଆଡଃ ଆମାଃ ଜମ୍‌ତିସାଃରାଃ ମେଦ୍‌ ପାପ୍‌ଇଚିମେରେଦ, ଏନାକେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ହୁଦ୍‌ମାଏଣ୍ଡାଃଏମେ, ଚିୟାଃଚି ଆମାଃ ଗଟା ହଡ଼୍‌ମ ନାରାକ୍‌ରେ ହୁଦ୍‌ମାଅଃଏତେ ମିଆଁଦ୍‌ ହାଟିଙ୍ଗ୍‌ ଜିୟନଃରେ ଆମାଃ ନାଗେନ୍ତେ ବୁଗିଅଃତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଆଡଃ ଆମାଃ ଜମ୍‌ତିସାଃରାଃ ତିଃଇ ପାପ୍‌ଇଚିମେରେଦ, ଏନାକେ ଛପାଏଣ୍ଡାଃଏମେ, ଚିୟାଃଚି ଆମାଃ ଗଟା ହଡ଼୍‌ମ ନାରାକ୍‌ରେ ହୁଦ୍‌ମାଅଃଏତେ, ମିଦ୍‌ ହାଟିଙ୍ଗ୍‌ ଜିୟନଃରେ ଆମାଃ ନାଗେନ୍ତେ ବୁଗିଅଃତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ନେଆଁଁହଗି କାଜିକାନା, ‘ଜେତାଏ ଆୟାଃ କୁଡ଼ିକେ ବାଗିରେଦ, ଇନିଃ ଏନ୍‌ କୁଡ଼ିକେ ବାଗିରେଆଃ ଅନଲ୍‌ଚିଠା ଏମ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ଜେତାଏ ଆୟାଃ କୁଡ଼ିତେକେ ଆପାଙ୍ଗିର୍‌ କାମି ବାଗିକେଦ୍‌ତେ ଏଟାଃ କାମି ନାଗେନ୍ତେ ବାଗିରେଦ, ଇନିଃ ଆୟାଃ କୁଡ଼ିତେକେ ଆପାଙ୍ଗିର୍‌ ରିକାଇରେୟାଃ ଗୁହ୍ନାଁରେ ଚିଟାଃୱା ଆଡଃ ଜେତାଏ ବାଗିୟାକାନ୍‌ କୁଡ଼ିକେ ଆଣ୍‌ଦିନ୍‌ରେଦ, ଇନିଃ ଆପାଙ୍ଗିର୍‌ କାମି ରିକାଃଏ । ");
INSERT INTO unx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ଆପେ ଆଡଃଗିପେ ଆୟୁମ୍‌କାଦା, ନେଆଁଁ ସିଦା ଦିପିଲିରେନ୍‌ ହଡ଼କକେ କାଜିୟାକାନା, ‘ଆପେ ହସଡ଼ କିରିୟା ଆଲ୍‌ପେୟାଃ, ମେନ୍‌ଦ ଆପେୟାଃ କିରିୟାକ ପ୍ରାଭୁଆଃ ଆୟାର୍‌ରେ ପୁରାଏପେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, କିରିୟାଏ ଇମ୍‌ତା ଜେତାନ୍‌ ବିଷାଏରେ କିରିୟା ଆଲପେ ରିକାଏ, ସିର୍ମା ଦିଶୁମ୍‌ରେୟାଃ ଆଲ୍‌ପେୟାଃ, ଚିୟାଃଚି ଏନାଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଜ୍‌ଗାଦି ତାନାଃ, ");
INSERT INTO unx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ଚାଏ ଅତେରେୟାଃ ଆଲ୍‌ପେୟାଃ, ଚିୟାଃଚି ଏନାଦ ଇନିୟାଃ କାଟାରେୟାଃ ଗାଣ୍ଡୁ ତାନାଃ, ଆଡଃ ଯୀରୁଶାଲେମ୍‌ରେଆଃ ଆଲ୍‌ପେୟାଃ, ଚିୟାଃଚି ଏନାଦ ମାରାଙ୍ଗ୍‌ ରାଜାକଆଃ ନାଗାର୍‌ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ଆଡଃ ଆପେୟାଃ ବହଃରେୟାଃ କିରିୟା ଆଲ୍‌ପେୟାଃ, ଚିୟାଃଚି ଏନାରାଃ ମିଆଁଦ୍‌ ଉବ୍‌କେ ପୁଣ୍ଡି ଚାଏ ହେନ୍‌ଦେ ରିକାନାଙ୍ଗ୍‌ ଆପେ କାପେ ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ଏନାତେ ଆପେୟାଃ କାଜି ‘ହଁ ରେଦ ହଁ’ ଚାଏ ‘କା ରେଦ କା’ ମେନ୍ତେ କାଜିପେ, ନେଆଁଁଏତେ ଆଦ୍‌କା କାଜିତେୟାଃ ଏତ୍‌କାନ୍‌ଏତେ ହିଜୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“‘ଆପେ ମେଦ୍‌ରେଆଃ ବାଦ୍‌ଲା ମେଦ୍‌, ଆଡଃ ଡାଟାରେୟାଃ ବାଦ୍‌ଲା ଡାଟା ମେନ୍ତେପେ ଆୟୁମାକାଦାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଜେତାଏ ଆପେୟାଃ ଏତ୍‌କାନ୍‌ ରିକାଏରେଦ, ଇନିୟାଃ ବାଦ୍‌ଲା ଆଲ୍‌ପେ ଇଦିୟା, ମେନ୍‌ଦ ଜେତାଏ ଆପେୟାଃ ଜମ୍‌ସାଃରାଃ ଜୱାରେ ଚାଟ୍‌କାନ୍‌ପେରେଦ, ଇନିଃକେ ଏଟାଃ ଜୱାହଗି ବିୟୁରାଇପେ । ");
INSERT INTO unx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଆଡଃ ଜେତାଏ ଆପେଲଃ ବିଚାର୍‌ ଠାୟାଦ୍‌ରେ ଏପ୍‌ରାଙ୍ଗ୍‌କେଦ୍‌ତେ ଆପେୟାଃ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃ ଇଦିନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ, ଇନିଃକେ ଚାଦାର୍‌ ଲିଜାଃ ହଗି ଏମାଇପେ । ");
INSERT INTO unx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ଜେତାଏ ପାଲ୍‌ଟାନ୍‌ ଆୟାଃ ବୋଝା ଗଅଃକେଦ୍‌ତେ ଆପେକେ ମିଦ୍‌ କିଲୋମିଟର୍‌ ହରା ସେନ୍‌ ରିକାପେରେଦ, ଇନିଃଲଃ ବାର୍‌ କିଲୋମିଟର୍‌ ସେନଃପେ । ");
INSERT INTO unx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ଜେତାଏ ଆପେକେ ଆସିପେରେଦ ଇନିଃକେ ଏମାଇପେ, ଆଡଃ ଜେତାଏ ଆପେତାଃଏତେ ରିଣୀ ଇଦି ସାନାଙ୍ଗ୍‌ରେଦ ଇନିଃକେ ଏମାଇପେ । ");
INSERT INTO unx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“‘ଆପେୟାଃ ଗାତିକକେ ଦୁଲାଡ଼୍‌କପେ ଆଡଃ ବାଇରିକକେ ହିଲାଙ୍ଗ୍‌କପେ ମେନ୍ତେ ଆପେ ଆୟୁମାକାଦାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେ ଆପେୟାଃ ବାଇରିକକେ ଦୁଲାଡ଼୍‌କପେ ଆଡଃ ଆପେକେ ସିଗିଦ୍‍ପେତାନ୍‌କଆଃ ନାଗେନ୍ତେ ବିନ୍ତିପେ । ");
INSERT INTO unx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଏନାତେ ଆପେ ଆପେୟାଃ ସିର୍ମା ଦିଶୁମ୍‌ରେନ୍‌ ଆପୁଆଃ ହନ୍‌କପେ ବାଇୟଃଆ, ଇନିଃ ଏତ୍‌କାନ୍‌ ଆଡଃ ବୁଗିନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ସିଙ୍ଗି ତୁରାଃଏ, ଧାର୍‌ମାନ୍‌ ହଡ଼ ଆଡଃ ଏତ୍‌କାନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ଦାଆଃ ଗାମାଃଏ । ");
INSERT INTO unx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ଆପେକେ ଅକନ୍‌କ ଦୁଲାଡ଼୍‌ପେତାନାକ ଇନ୍‌କୁକେ ଏସ୍‌କାର୍‌ ଦୁଲାଡ଼୍‌ରେକରେଦ ଆପେୟାଃ ଚିକାନ୍‌ ନାଲା ନାମଃଆ ? ଚିୟାଃ ମାଲ୍‌ହାରମ୍‌କହଁ ନେ'ଲେକା କାକ ରିକାଃଚି ? ");
INSERT INTO unx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ଆଡଃ ଆପେ ଆପେୟାଃ ହାଗାକକେ ଏସ୍‌କାର୍‌ପେ ଜହାର୍‌କ ରେଦ, ଆଦ୍‌କା ଚିନାଃପେ ଚିକାକାଦା ? ଚିୟାଃ ସାଅଁସାର୍‌କହଁ ଏନ୍‌ଲେକା କାକ କାମିୟାଃ ? ");
INSERT INTO unx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ଏନାମେନ୍ତେ ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ ଲେକା ଆପେୟ ପାବିତାର୍‌ ତାୟୁଃପେ । ");
INSERT INTO unx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ହଡ଼କ ନେଲେକା ମେନ୍ତେ ଆପେୟାଃ ଧାର୍‌ମାନ୍‌ କାମି ଇନ୍‌କୁଆଃ ଆୟାର୍‌ରେ ଆଲ୍‌ପେ ରିକାୟା, ଏନାମେନ୍ତେ ଆପେ ଚିର୍ଗାଲାକାନ୍‌ ତାଇନ୍‌ପେ, କା'ରେଦ ଆପେୟାଃ ସିର୍ମା ଦିଶୁମ୍‌ରେନ୍‌ ଆପୁତାଃଏତେ ଆପେ ଜେତାନ୍‌ ନାଲା କାପେ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ଏନା ନାଗେନ୍ତେ ଆପେ ରେଙ୍ଗେଃକକେ ଜେତ୍‌ନାଃ ଏମ୍‌ ଇମ୍‌ତା ବେଦାହଡ଼କଆଃ ଲେକା ବିଙ୍ଗୁଲ୍‌ ବାଜା ଆଲ୍‌ପେ ସାଡ଼ିଆ, ଇନ୍‌କୁ ହଡ଼କତାଃଏତେ ଜହାର୍‌ ନାମେ ନାଗେନ୍ତେ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଆଡଃ ହରାକରେ ଏନ୍‌ଲେକା ରିକାଃକ । ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିପେତାନାଇଙ୍ଗ୍‌, ଇନ୍‌କୁ ଆକଆଃ ନାଲା ନାମ୍‌ ଚାବାକାଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ମେନ୍‌ଦ ଆପେ ଦାନ୍‌ ଏମ୍‌ ଇମ୍‌ତା ଆପେୟାଃ ଜମ୍‌ତିଃଇ କାମିତାନ୍‌ତେୟାଃ ଲେଙ୍ଗାତିଃଇ ଆଲକାଏ ସାରିକା, ");
INSERT INTO unx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ନେ ଲେକାଗି ଆପେୟାଃ ଏମଃତେୟାଃ ଦାନାଙ୍ଗି ତାଇନାଃ, ଆଡଃ ଆପେୟାଃ ଆପୁ ଦାନାଙ୍ଗ୍‌ରେ କାମିତେୟାଃ ନେଲାଃଏ, ଇନିଃ ଆପେକେ ନାଲାଏ ଏମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ଆପେ ବିନ୍ତି ଇମ୍‌ତା ବେଦାହଡ଼କ ଲେକା ଆଲ୍‌ପେ ରିକାନାଃ, ଚିୟାଃଚି ଇନ୍‌କୁ ହଡ଼କଆଃ ନେପେଲ୍‌ରେ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଆଡଃ ହରା କଚାକରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ବିନ୍ତି ନାଗେନ୍ତେ ସୁକୁଆଃକ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିପେତାନାଇଙ୍ଗ୍‌, ଇନ୍‌କୁ ଆକଆଃ ନାଲା ନାମ୍‌ ଚାବାକାଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ମେନ୍‌ଦ ଆପେ ବିନ୍ତି ଇମ୍‌ତା ଆପେୟାଃ ଭିତାର୍‌ ବାଖ୍‌ରାରେ ବଲପେ ଆଡଃ ଦୁଆର୍‌ ହାଣ୍ଡେଦ୍‌କେଦ୍‌ତେ ଆପେୟାଃ କାଏ ନେଲଃତାନ୍‌ ସିର୍ମାରେନ୍‌ ଆପୁତାଃରେ ବିନ୍ତିପେ ଏନ୍ତେ ଦାନାଙ୍ଗ୍‌ରେ ନେଲ୍‌ତାନ୍‌ ଆପୁ ନାଲାଏ ଏମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ବିନ୍ତି ଇମ୍‌ତା ସାଅଁସାର୍‌କ ଲେକା ଏନାଏନାକେଗି ଆଲ୍‌ପେ କାଜିୟା, ଚିୟାଃଚି ଇନ୍‌କୁ ପୁରାଃ କାଜି କାଜିଲେରେ ଆକଆଃ ବିନ୍ତି ଆୟୁମଃଆ ମେନ୍ତେକ ଉଡ଼ୁଃୟା । ");
INSERT INTO unx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ଏନା ନାଗେନ୍ତେ ଆପେ ଇନ୍‌କୁ ଲେକା ଆଲ୍‌ପେୟାଃ, ଚିୟାଃଚି ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁଦ ଆପେ ଆସି ସିଦାରେ ଆପେୟାଃ ଲାଗାତିଙ୍ଗ୍‌ତେୟାଃ ସାରିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ଏନାତେ ଆପେ ନେ ଲେକା ବିନ୍ତିପେ, “‘ହେ ଆଲେୟାଃ ସିର୍ମାରେନ୍‌ ଆବା; ଆମାଃ ନୁତୁମ୍‌ ପାବିତାରଃକା; ");
INSERT INTO unx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ଆମାଃ ରାଇଜ୍‌ ହିଜୁଃକା; ଆମାଃ ମନେ ସିର୍ମାରେ ଲେକା ଅତେଦିଶୁମ୍‌ରେୟ ପୁରାଅଃକା । ");
INSERT INTO unx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ଆଲେୟାଃ ତିସିଙ୍ଗ୍‌ରେୟାଃ ଜମେୟାଃଁ ଏମାଲେମେ । ");
INSERT INTO unx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ଆଲେ ଆଲେୟାଃ ଏତ୍‌କାନ୍‌କକେ ଛାମାକେଦ୍‍କ ଲେକା, ଆଲେୟାଃ ପାପ୍‌କ ଛାମାଏମେଁ । ");
INSERT INTO unx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ଆଡଃ ବିଡ଼ାଅରେ ଆଲମ୍‌ ଆଉଲେୟା, ମେନ୍‌ଦ ଏତ୍‌କାନ୍‌ନିଃଏତେ ବାଞ୍ଚାଅଲେମ୍‌ । ଚିୟାଃଚି ରାଇଜ୍‌, ପେଡ଼େଃ ଆଡଃ ମାନାରାଙ୍ଗ୍‌ ଜାଉ ଜରଙ୍ଗ୍‌ ଆମାଃଗି ହବାଅଃକା, ଆମେନ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ଆପେ ହଡ଼କଆଃ ଗୁହ୍ନାଁଁକପେ ଛାମାଏରେଦ, ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ ଆପେକେୟଗି ଛାମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ମେନ୍‌ଦ ଆପେ ହଡ଼କଆଃ ଗୁହ୍ନାଁଁକେ କାପେ ଛାମାଏରେଦ, ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁହଁ ଆପେକେ କାଏ ଛାମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ଆପେ କାଟାବ୍‌ ଇମ୍‌ତା ବେଦାହଡ଼କ ଲେକା ଆଲ୍‌ପେ ଗସ ମେଦ୍‌ମୁହାଁଡ଼େନା, ଚିୟାଃଚି ଇନ୍‌କୁଦ କାଟାବ୍‌ତାନାଲେ ମେନ୍ତେ ହଡ଼କଆଃ ଆୟାର୍‌ରେ ନେଲଃକାଲେ ମେନ୍ତେ ଆକ ଗସ ମେଦ୍‌ମୁହାଁଡ଼୍‌ଗିକ ତାଇନାଃ । ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିପେତାନା, ଇନ୍‌କୁ ଆକଆଃ ନାଲା ନାମ୍‌ ଚାବାକାଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ମେନ୍‌ଦ ଆପେ କାଟାବ୍‌ ଇମ୍‌ତା ଆପେୟାଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ ଆବୁଙ୍ଗ୍‌ୟେଁନ୍‌ପେ ଆଡଃ ବହଃରେ ସୁନୁମ୍‌ ଗସଗେନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ନେ ଲେକାତେ ଆପେ ହଡ଼କଆଃ ଆୟାର୍‌ରେ କାଟାବ୍‌ତାନାକ ମେନ୍ତେଦ କା ମେନ୍‌ଦ କା ନେଲଃତାନ୍‌ ଆପୁତାଃରେ କାଟାବ୍‌ତାନାକ ମେନ୍ତେପେ ଉଦୁବଃଆ, ଆଡଃ ଦାନାଙ୍ଗ୍‌ରେ ନେଲ୍‌ତାନ୍‌ ଆପେୟାଃ ଆପୁ ନାଲାଏ ଏମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ନେ ଅତେରେ ଆପେୟାଃ ନାଗେନ୍ତେ ଖୁର୍ଜି ଆଲ୍‌ପେ ହୁଣ୍ଡିଆଃ, ନେତାଃରେ ନିଦିର୍‌କ ଆଡଃ ମୁର୍ଚାଜମ୍‌କେଦ୍‌ତେ ଜିୟନଃଆ ଆଡଃ କୁମ୍ବୁଡ଼ୁକ ସିନ୍ଧି ତଡ଼ାଅକେଦ୍‌ତେ କୁମ୍ବୁଡ଼ୁଆଃକ । ");
INSERT INTO unx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ମେନ୍‌ଦ ଆପେ ନାଗେନ୍ତେ ସିର୍ମାରେ ଖୁର୍ଜି ହୁଣ୍ଡିପେ, ଏନ୍ତାଃରେ ତିଜୁ ଆଡଃ ନିଦିର୍‌ କାକ ଜିୟନେଆ ଆଡଃ କୁମ୍ବୁଡ଼ୁକ ସିନ୍ଧି ତଡ଼ାଅକେଦ୍‌ତେ କାକ କୁମ୍ବୁଡ଼ୁଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ଚିୟାଃଚି ଆପେୟାଃ ଖୁର୍ଜି ତାଇନଃତାଃରେଗି ଆପେୟାଃ ମନ୍‌ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ମେଦ୍‌ଦ ହଡ଼୍‌ମରେୟାଃ ଦିମି ତାନାଃ, ଆପେୟାଃ ମେଦ୍‌ ନିରାଲ୍‌ ମେନାଃରେଦ ଗଟା ହଡ଼୍‌ମତାପେୟାଃ ମାର୍ସାଲଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ମେନ୍‌ଦ ଆପେୟାଃ ମେଦ୍‌ ଏତ୍‌କାନ୍‌ ମେନାଃରେଦ, ଆପେୟାଃ ଗଟା ହଡ଼୍‌ମ ନୁବାଗଃଆ । ଏନା ନାଗେନ୍ତେ ଆପେରେ ତାଇନଃତାନ୍‌ ମାର୍ସାଲ୍‌ ନୁବାଗଃରେଦ, ଚିମିନ୍‌ ମାରାଙ୍ଗ୍‌ ବରୱାନ୍‌ ନୁବାଃ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ଜେତାଏ ବାରିଆ ଗମ୍‌କେକିନାଃ ଦାସି କାଏ ହବାଦାଡ଼ିୟଃଆ । ଚିୟାଃଚି ଇନିଃ ମିହୁଡ଼୍‌କେ ହିଲାଙ୍ଗ୍‌ଇୟାଏ ଆଡଃ ଏଟାଃ ମିହୁଡ଼୍‌କେ ଦୁଲାଡ଼ିୟାଏ, ଚାଏ ମିଆଁଦ୍‌ନିଃଲଃ ମେସାନାଏ ଆଡଃ ଏଟାଃନିଃଲଃ କାଏ ମେସାନା । ଆପେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଡଃ ଖୁର୍ଜି ବାରାନାଃରେ କାପେ ଦାସିଦାଡ଼ିନା ।” ");
INSERT INTO unx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ଜୀନିଦ୍‌ ତାଇନଃ ନାଗେନ୍ତେ ଚିକ୍‌ନାଃବୁ ଜମାଃ ଆଡଃ ଚିକ୍‌ନାଃବୁ ନୁଁଏୟା, ଚାଏ ହଡ଼୍‌ମରେ ଚିକ୍‌ନାଃବୁ ତୁସିଙ୍ଗ୍‌ୟେଁନା ମେନ୍ତେ ଆପେୟାଃ ଜୀଉରେ ଆଲ୍‌ପେ ଉଡ଼ୁଃୟା । ଜମେୟାଁଃଏତେ ଜୀଉ ଆଡଃ ଲିଜାଃଏତେ ହଡ଼୍‌ମ କା'ଚି ମାରାଙ୍ଗ୍‌ଆଁ ? ");
INSERT INTO unx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ଚେଣେଁକକେ ନେଲ୍‌କପେ, ଇନ୍‌କୁ କାକ ହେରେୟା ଚାଏ କାକ ଇରେୟା, ଆଡଃ ଇନ୍‌କୁଆଃ ଭାଣ୍ଡାର୍‌ ଅଡ଼ାଃରେ କାକ ହୁଣ୍ଡିଆଃ, ହଲେହଁ ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ ଇନ୍‌କୁକେ ଆସୁଲ୍‌କତାନାଏ । ଆପେ ଚିନାଃ ଇନ୍‌କୁତାଃଏତେ କାପେ ମାରାଙ୍ଗ୍‌ଆଃ ? ");
INSERT INTO unx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ଆପେକଏତେ ଅକଏ ଉଡୁଃକେଦ୍‌ତେ ଆୟାଃ ଜୀଉକେ ମିଦ୍‌ ଘାଡ଼ି ପସାଦାଡ଼ିୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“‘ଆଡଃ ଆପେ ଲିଜାଃ ନାଗେନ୍ତେ ଚିନାଃ ମେନ୍ତେପେ ଉଡ଼ୁଃତାନା ? ଅତେରେୟାଃ ବାହାକକେ ନେଲେପେ, ଏନାକ ଚିଲ୍‌କା ହାରାତାନା, ଏନାକ କାକ କାମିତାନା, ଚାଏ କାକ ତୁକୁଇତାନା, ");
INSERT INTO unx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ହଲେହଁ ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ସୁଲିମାନ୍‌ହଁ ଆୟାଃ ସବେନ୍‌ ସୁଗାଡ଼ାନ୍‌ତେୟାଃଏତେ ଏନ୍‌ ବାହାକ ଲେକା କାଏ ସିଙ୍ଗାରାକାନ୍ ତାଇକେନା ।’ ");
INSERT INTO unx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ତିସିଙ୍ଗ୍‌ ମେନାଃ ଆଡଃ ଗାପା ଚୁଲ୍ଲାରେ ହାଁଣବଃତାନ୍‌ ଅତେରାଃ ତାସାଦ୍‌କେ ପାର୍‌ମେଶ୍ୱାର୍‌ ନେ ଲେକାଏ ସିଙ୍ଗାର୍‌ରେ ରେଦ, ଏ ହୁଡିଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ତାନ୍‌କ, ଚିୟାଃ ଇନିଃ ନେଆଁଁଏତେ ଆଦ୍‌କା ଆପେକେ କାଏ ତୁସିଙ୍ଗ୍‌ପେୟା ? ");
INSERT INTO unx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“ଏନା ନାଗେନ୍ତେ ‘ଚିକ୍‌ନାଃବୁ ଜମେୟାଁ ? ଚାଏ ଚିକ୍‌ନାଃବୁ ନୁଁଏୟା ? ଚାଏ ଚିକ୍‌ନାଃବୁ ତୁସିଙ୍ଗ୍‌ୟେଁନା ?’ ମେନ୍ତେ ଆଲ୍‌ପେ ଉଡ଼ୁଗେୟା । ");
INSERT INTO unx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ଚିୟାଃଚି ସାଅଁସାର୍‌ ହଡ଼କ ନେ ସବେନାଃ ଦାଣାଁଁବାଡ଼ାଃକ, ଆଡଃ ନେ ସବେନାଃ ଆପେୟାଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଏନା ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ ସାରିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ମେନ୍‌ଦ ଆପେ ସିଦାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆଡଃ ଇନିୟାଃ ଧାର୍‌ମାନ୍‌ କାଜି ଦାଣାଁଁଏପେ, ଆଡଃ ନେ ସବେନାଃହ ଆପେକେ ଏମଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ଏନା ନାଗେନ୍ତେ ଗାପାନାଙ୍ଗ୍‌ ଆଲ୍‌ପେ ଉଡ଼ୁଃୟା, ଚିୟାଃଚି ଗାପାଦ ଆୟାଃ ନାଙ୍ଗ୍‌ ଆଇଃକ୍‌ଗି ଉଡ଼ୁଃୟା । ମୁସିଙ୍ଗ୍‌ରେୟାଃ ଦୁକୁ ମୁସିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଥିମ୍ୱାଗିଆ । ");
INSERT INTO unx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ଏଟାଃକକେ ଆଲ୍‌ପେ ବିଚାର୍‌କଆ, ଏନାରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେକେ କାଏ ବିଚାର୍‌ପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ଚିୟାଃଚି ଆପେ ଏଟାଃକକେ ବିଚାର୍‌କ ଲେକାଗି ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେକେ ବିଚାର୍‌ପେୟାଏ, ଆଡଃ ଆପେ ସଙ୍ଗେ ତାମ୍ବିରେଗି ଆପେ ନାଗେନ୍ତେ ସୋଙ୍ଗଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ଆମ୍‌ ଆମାଃ ମେଦ୍‌ରେଆଃ ଚୁବାଃ କା ନେଲ୍‌କେଦ୍‌ତେ ହାଗାମାଃ ମେଦ୍‌ରେଆଃ ହୁଡିଙ୍ଗ୍‌ ଚୁବାଃ ଚିକା ନାଗେନ୍ତେମ୍‌ ନେଲେତାନା ? ");
INSERT INTO unx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ଆମାଃ ମେଦ୍‍ରେ ଚୁବାଃ ତାଇନ୍‌କେଦ୍‌ତେ, ‘ହାଗାମାଃ ମେଦ୍‌ରେଆଃ ଚୁବାଃକେ ଅଡଙ୍ଗ୍‌ତାମାଇଙ୍ଗ୍‌’ ମେନ୍ତେ ଚିଲ୍‌କାତେ କାଜି ଦାଡ଼ିୟାମ୍‌ ? ");
INSERT INTO unx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ଏ ବେଦାହଡ଼, ସିଦାତେ ଆମାଃ ମେଦ୍‌ରେଆଃ ଚୁବାଃ ଅଡଙ୍ଗ୍‌ୟେଁମେ, ଏନ୍ତେ ହାଗାମାଃ ମେଦ୍‌ରାଃ ଚୁବାଃ ଅଡଙ୍ଗ୍‌ ନାଗେନ୍ତେ ବୁଗିଲେକାମ୍‌ ନେଲ୍‌ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ପାବିତାର୍‌ତେୟାଃ ସେତାକକେ ଆଲ୍‌ପେ ଏମାକଆ ଚାଏ ଆପେୟାଃ ମୋତି ସୁକୁରିକଆଃ ଆୟାର୍‌ରେ ଆଲ୍‌ପେ ଏଣ୍ଡାଃଏୟା, କା'ରେଦ ଇନ୍‌କୁ ଏନାକକେ ଆକଆଃ କାଟାତେକ ତିକାଏୟା ଆଡଃ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ଆପେକେ ଅଡ଼େଃପେୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ଆସିପେ ଏନାରେଦ ଆପେକେ ଏମଃଆ, ଦାଣାଁଁଏପେ ଏନ୍‌ରେଦପେ ନାମେୟା, ଦୁଆର୍‌ ଠକ୍‌ ଠକାଏପେ ଏନ୍‌ରେଦ ଆପେ ନାଗେନ୍ତେ ନିଜଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ଚିୟାଃଚି ଜେତାଏ ଆସିତାନ୍‌ନିଃଦ ତେଲାଜମାଃ, ଆଡଃ ଦାଣାଁଁଏନିଃଦ ନାମେୟାଏ, ଆଡଃ ଠକ୍‌ ଠକାଏନିଃ ନାଗେନ୍ତେ ନିଜଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ଆପେକଏତେ ଅକନ୍‌ ହଡ଼ ନେ'ଲେକା ମେନାଇୟା, ଆୟାଃ ହନ୍‌ ହଲଙ୍ଗ୍‌ ଆସିରେଦ, ଚିନାଃ ଇନିଃକେ ଦିରି ଏମାଇୟାଏ, ");
INSERT INTO unx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ଚାଏ ହାକୁ ଆସିରେଦ ଚିୟାଃ ଇନିଃକେ ବିଙ୍ଗ୍‌ ଏମାଇୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ଏନ୍ତେ ଆପେ ଏତ୍‌କାନ୍‌କ ତାଇନ୍‌ରେୟ, ଆପେୟାଃ ହନ୍‌କକେ ବୁଗିନାଃ ଏମଃପେ ସାରିୟା, ତାବ୍‌ଦ ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ, ଅକନ୍‌କଚି ଆଇଃକ୍‌କେ ଆସି ତାନାକ, ଇନ୍‌କୁକେ ଏନାଏତେ ଆଦ୍‌କା ବୁଗିନ୍‌ତେୟାଃ କାଏଚି ଏମାକଆ ! ");
INSERT INTO unx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“ଏନାମେନ୍ତେ ହଡ଼କ ଆଲେନାଙ୍ଗ୍‌ ରିକାଏକାକ ମେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନ୍‌ ଲେକା ଆପେୟଗି ଇନ୍‌କୁ ନାଗେନ୍ତେ ଏନ୍‌ଲେକା ରିକାଏପେ, ଚିୟାଃଚି ନେଆଁଁଗି ମୁଶାରାଃ ଆନ୍‌ଚୁ ଆଡଃ ନାବୀକଆଃ ଇନିତୁରାଃ ମୁଣ୍ଡିତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ରେସେଦ୍‌ ଦୁଆର୍‌ତେ ବଲପେ, ଚିୟାଃଚି ଜିୟନଃତେ ଇଦି ନାରାକ୍‌ ଦୁଆର୍‌ଦ ଚାକାର୍‌ଗିୟା ଆଡଃ ଏନ୍‌ ହରାତେ ସେନ୍‌ ନାଙ୍ଗ୍‌ ପୁରାଃଗି ସାହାଜ୍‌ଗିଆ, ଏନାରେ ବଲନାଙ୍ଗ୍‌ ପୁରାଃ ହଡ଼କ ମେନାକଆ । ");
INSERT INTO unx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ମେନ୍‌ଦ କା ଟୁଣ୍ଡୁ ଜୀଦାନ୍‌ତେ ସେଟେର୍‌ ଦୁଆର୍‌ ରେସେଦ୍‍ଗିଆ ଆଡଃ ଏନ୍‌ ହରାତେ ସେନ୍‌ ନାଙ୍ଗ୍‌ ପୁରାଃଗି କେଟେଦ୍‌ଗିୟା, ଏନାକେ ନାମେ ହଡ଼କ ହୁଡିଙ୍ଗ୍‌ଗି ମେନାକଆ । ");
INSERT INTO unx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ହସଡ଼ ନାବୀକତାଃଏତେ ଚିର୍ଗାଲାକାନ୍‌ପେ, ଇନ୍‌କୁ ବାହାରି ନେପେଲ୍‌ରେ ମିଣ୍ଡିକ ଲେକା ଆପେୟାଃ ହେପାଦ୍‌ତେକ ହିଜୁଃଆ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଭିତାର୍‌ ନେପେଲ୍‌ରେ ହୁଣ୍ଡାର୍‌କ ଲେକାନ୍‌କ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ଆପେ ଇନ୍‌କୁଆଃ କାମିତେ ଇନ୍‌କୁକେପେ ନେଲ୍‌ଉରୁମ୍‌କଆ । ଚିୟାଃ ହଡ଼କ ଜାନୁମ୍‌ ଦାରୁଏତେ ଦାଖ୍‌ ଜ ଚାଏ ଦଧାଡ଼ି ଦାରୁଏତେ ଲଆ ଜ ଗଦେୟାକ ? ");
INSERT INTO unx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ଏନ୍‌ ଲେକାତେ ସବେନ୍‌ ବୁଗିନ୍‌ ଦାରୁ ବୁଗିନ୍‌ ଜ ଜଅଃ'ତାନା ମେନ୍‌ଦ ଏତ୍‌କାନ୍‌ ଦାରୁ ଏତ୍‌କାନ୍‌ ଜ ଜଅଃ'ଆ । ");
INSERT INTO unx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ବୁଗିନ୍‌ ଦାରୁଏତେ ଏତ୍‌କାନ୍‌ ଜ କା ଜ ଦାଡ଼ିୟଃଆ, ଚାଏ ଏତ୍‌କାନ୍‌ ଦାରୁଏତେ ବୁଗିନ୍‌ ଜ କା ଜଅଃ'ଆ । ");
INSERT INTO unx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ଜେତା ଦାରୁଏତେ ବୁଗିନ୍‌ ଜ କା ଜ'ରେଦ, ଏନା ମାଗଃଆ ଆଡଃ ସେଙ୍ଗେଲ୍‌ରେ ଏଣ୍ଡାଗଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ଏନାମେନ୍ତେ ଆପେ ହସଡ଼ ନାବୀକଆଃ କାମିତେ ଇନ୍‌କୁକେପେ ନେଲ୍‌ଉରୁମ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ଆଇଙ୍ଗ୍‌କେ ‘ହେ ପ୍ରାଭୁ, ହେ ପ୍ରାଭୁ’ ମେତାଇଙ୍ଗ୍‌ତାନ୍‌ ଏନ୍‌ ହଡ଼କଏତେ ସବେନ୍‌ ହଡ଼କ ସିର୍ମା ରାଇଜ୍‌ରେ କାକ ବଲଆ, ମେନ୍‌ଦ ଜେତାଏ ଆଇଁୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁଆଃ ମନେଲେକା ସେସେନ୍‌ନିଃ ବଲଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାଜାଇ ହୁଲାଙ୍ଗ୍‌ ହିଜୁଃରେ, ପୁରାଃ ହଡ଼କ ଆଇଙ୍ଗ୍‌କେ ‘ହେ ପ୍ରାଭୁ, ହେ ପ୍ରାଭୁ, ଚିୟାଃ ଆଲେ ଆମାଃ ନୁତୁମ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାନାଜି କାଲେଚି କାଜି ? ଆମାଃ ନୁତୁମ୍‌ତେ ବଙ୍ଗାକକେ କାଲେଚି ହାର୍‌ଅଡଙ୍ଗ୍‌ ? ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମି କାଲେଚି କାମି ?’ ");
INSERT INTO unx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ମେତାକଆଇଙ୍ଗ୍‌, ‘ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ, ଏ ଏତ୍‌କାନ୍‌କ, ଆଇଙ୍ଗ୍‌ତାଃଏତେ ଆତମେନ୍‌ପେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ଏନା ନାଗେନ୍ତେ ଜେତାଏ ଆଇଁୟାଃ ନେ ସବେନ୍‌ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ମାନାତିଙ୍ଗ୍‌ନିଃ, ଚାଟେନ୍‌ ଦିରିରେ ଆୟାଃ ଅଡ଼ାଃ ବାଇକେଦ୍‌ ସେଣାଁଁନ୍‌ ହଡ଼ ଲେକାଃଏ । ");
INSERT INTO unx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ଦାଆଃ ଗାମାକେଦାଏ, ଟୁଡାୟାନା, ଆନ୍ଧିହୟ ହୟକେଦାଏ ଆଡଃ ଅଡ଼ାଃରେ ଟଅଃୟାନା, ମେନ୍‌ଦ ଏନା କା ହାଦୁଡ଼୍‌ୟାନା, ଚିୟାଃଚି ଏନାଦ ଚାଟେନ୍‌ ଦିରି ଚେତାନ୍‌ରେ ବାଇୟାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ମେନ୍‌ଦ ଜେତାଏ ଆଇଁୟାଃ ନେ ସବେନ୍‌ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ କା ମାନାତିଙ୍ଗ୍‌ନିଃ, ଗିତିଲ୍‌ରେ ଆୟାଃ ଅଡ଼ାଃ ବାଇକେଦ୍‌ ଡଣ୍ଡ ହଡ଼ ଲେକାଃଏ । ");
INSERT INTO unx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ଦାଆଃ ଗାମାକେଦାଏ, ଟୁଡାୟାନା, ଆନ୍ଧିହୟ ହୟକେଦାଏ ଆଡଃ ଅଡ଼ାଃରେ ଟଅଃୟାନା, ଏନ୍ତେ ଏନା ହାଦୁଡ଼୍‌ୟାନା, ଆଡଃ ଏନାରାଃ ଜିୟନଃ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ୟୀଶୁ ନେ କାଜିକ କାଜିଟୁଣ୍ଡୁକେଦ୍‍ଚି, ଗାଦେଲ୍‌ ହଡ଼କ ଇନିୟାଃ ଇନିତୁରେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ, ");
INSERT INTO unx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ଚିୟାଃଚି ଇନିଃଦ ଇନ୍‌କୁଆଃ ଆଇନ୍‌ ଇତୁକ ଲେକାଦ କାହା, ମେନ୍‌ଦ ମିଆଁଦ୍‌ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ନିଃଲେକା ଇତୁକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ୟୀଶୁ ବୁରୁଏତେ ଆଡ଼୍‌ଗୁୟାନ୍‌ଚି, ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେକ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ଏନ୍ତେ ମିଆଁଦ୍‌ ନାଗେଘାଅନିଃ ଇନିଃତାଃ ହିଜୁଃକେଦ୍‌ତେ, ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ବିନ୍ତିତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଆଇଙ୍ଗ୍‌କେ ବୁଗିନିୟାର୍‌ ଦାଡ଼ିୟାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ତିଃଇ ଜିଲିଙ୍ଗ୍‌କେଦ୍‌ତେ ଜୁଟିଦ୍‌କିୟାଏ ଆଡଃ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନିଙ୍ଗ୍‌ ଆମ୍‌ ବୁଗିନିୟାରଃମେ ।” ଆଡଃ କାଜିତାନ୍ ତର୍‌ସାଗି ଇନିୟାଃ ନାଗେଘାଅ ଫାର୍‌ଚିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଏନ୍ତେ ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ନେଲେମେ, ଜେତାଏକେ ନେ କାଜି ଆଲମ୍‌ ଉଦୁବ୍‌କଆଃ, ମେନ୍‌ଦ, ଜୁ, ଯାଜାକ୍‌ତାଃରେ ଉଦୁବେନ୍‌ମେ ଆଡଃ ଆମ୍‌ ବୁଗିୟାକାନାମ୍‌ ମେନ୍ତେ ଇନ୍‌କୁଆଃ ଗାୱା ନାଗେନ୍ତେ ମୁଶା ନାବୀ ଆଚୁକାଦ୍‌ ଦାଣେଁରାଃ ଦାନ୍‌ ରାକାବେମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ୟୀଶୁ କପର୍‌ନାହୁମ୍‌ ସାହାର୍‌ତେ ବଲୟାନ୍‌ ଇମ୍‌ତା ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ମିଆଁଦ୍‌ ରୋମି ଗମ୍‌କେ ଇନିଃତାଃତେ ହିଜୁଃୟାନା ଆଡଃ ଦେଙ୍ଗାନାଙ୍ଗ୍‌ ବିନ୍ତିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ହେ ଗମ୍‌କେ, ଦାସିତାଇଙ୍ଗ୍‌ ବାତ୍‌କାନ୍‌ତେ ଅଡ଼ାଃରେ ବିରିଦ୍‍ବାଡ଼ା କାଏ ଦାଡ଼ିତାନ୍‌ ଆଡଃ ବରୱାନ୍‌ଗି ଦୁକୁତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟା, “ଆଇଙ୍ଗ୍‌ ସେନ୍‌କେଦ୍‌ତେ ଇନିଃକେ ବୁଗିଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ମେନ୍‌ଦ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଗମ୍‌କେ କାଜିରୁହାଡ଼୍‌କିୟା, “ହେ ଗମ୍‌କେ, ଆମ୍‌ ଆଇଁୟାଃ ଅଡ଼ାଃରେମ୍‌ ବଲଆ ଏନ୍‌ ଲେକାନ୍‌ନିଃଦ ନାହାଁଲିଙ୍ଗ୍‌, ମେନ୍‌ଦ ମିସାଗି କାଜିତାମ୍‌ ଏନ୍‌ରେଦ ଦାସି ତାଇୟାଁଃ ବୁଗିକଆଃଏ । ");
INSERT INTO unx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ହଁ ଏଟାଃକଆଃ ଆକ୍‌ତେୟାର୍‌ରେ ମେନାଇୟାଁଃ, ସିପାଇକ ଆଇଁୟାଃ ଆକ୍‌ତେୟାର୍‌ରେ ମେନାକଆଃ । ଆଇଙ୍ଗ୍‌ ମିହୁଡ଼୍‌କେ ସେନଃମେ ମେତାଇରେଦ ଇନିଃ ସେନଃଆଏ ଆଡଃ ଏଟାଃନିଃକେ ହିଜୁଃମେ ମେତାଇରେ ଇନିଃ ହିଜୁଃଆଏ । ଆଇଁୟାଃ ଦାସିକେ ନେୟାଁ କାମିମେ ମେତାଇରେ ଇନିଃ କାମିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ୟୀଶୁ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନା ଆଡଃ ଆଇଃକ୍‌କେ ଅତଙ୍ଗ୍‌ଇଁତାନ୍‌ ହଡ଼କକେ ମେତାଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିପେତାନାଇଙ୍ଗ୍‌, ଇସ୍ରାଏଲ୍‌ରେହ ନେ ଲେକାନ୍‌ ମାରାଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ କାଇଙ୍ଗ୍‌ ନାମ୍‌କାଦା । ");
INSERT INTO unx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ପୁରାଃ ହଡ଼କ ପୁରାବ୍‌ ଆଡଃ ପାଶ୍ଚିମ୍‌ଏତେକ ହିଜୁଃଆ, ଏନ୍ତେ ଆବ୍ରାହାମ୍‌, ଇସାକ୍‌, ଆଡଃ ଯାକୁବ୍‌ତେକଲଃ ସିର୍ମା ରାଇଜ୍‌ରେ ଜଜମ୍‌ ନାଙ୍ଗ୍‌କ ଦୁବାଃ, ");
INSERT INTO unx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ମେନ୍‌ଦ ଏନ୍‌ ରାଇଜ୍‌ରେନ୍‌ ହନ୍‌କ ନୁବାଃଉତାର୍‌ରେକ ହୁରାଙ୍ଗ୍‌ ଏଣ୍ଡାଗଆଃ । ଏନ୍ତାଃରେ ଆକଆଃ ରାନାଆଃ ଆଡଃ ଡାଟା ହାବ୍‌ ରିଡିଦଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଏନ୍ତେ ୟୀଶୁ ମିଦ୍‌ ସାଅ ସିପାଇକଆଃ ଗମ୍‌କେ କେ କାଜିକିୟା, “ଜୁ ଅଡ଼ାଃତେ ସେନଃମେ, ଆଡଃ ଆମ୍‌ ବିଶ୍ୱାସ୍‌କାଦ୍‌ ଲେକା ଆମାଃ ନାଗେନ୍ତେ ହବାଅଃକା ।” ଆଡଃ ମିଦ୍‌ ସାଅ ସିପାଇକଆଃ ଗମ୍‌କେୟାଃ ଦାସି ଏନ୍‌ ଦିପିଲିରେଗି ବୁଗିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ୟୀଶୁ ପାତ୍‌ରାସ୍‌ଆଃ ଅଡ଼ାଃତେ ହିଜୁଃୟାନ୍‌ଚି, ଇନିଃ ପାତ୍‌ରାସ୍‌ଆଃ ହାନାର୍‌ତେକେ ଉରିୟୁତେ ପାର୍‌କମ୍‌ରେ ବାଟିୟାକାନ୍‌ ନେଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ଏନ୍ତେ ୟୀଶୁ ଇନିୟାଃ ତିଃଇ ଜୁଟିଦ୍‌କେଦାଏ ଆଡଃ ଇନିଃ ଉରିୟୁଏତେ ବୁଗିୟାନା, ଏନ୍ତେ ଇନିଃ ବିରିଦ୍‌କେଦ୍‌ତେ ଇନିୟାଃ ସୁସାର୍‌ ଏଟେଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ସିଙ୍ଗିହାସୁରଃ ତାନ୍‌ରେ ହଡ଼କ ପୁରାଃ ବଙ୍ଗା ଏସେର୍‌କାନ୍‌ ହଡ଼କକେ ୟୀଶୁତାଃତେକ ଆଉକେଦ୍‌କଆ । ଇନିଃ ବଙ୍ଗାକକେ କାଜିତେଗି ହାର୍‌ ଅଡଙ୍ଗ୍‌କେଦ୍‌କଆ ଆଡଃ ସବେନ୍‌ ଦୁକୁହାସୁତାନ୍‌କକେ ବୁଗିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ଯିଶାୟ ନାବୀ କାଜିକାଦ୍‌ତେୟାଃ ପୁରାଅଃକା ମେନ୍ତେ ଇନିଃ ନେ ଲେକାଏ କାମିକେଦା, “ଇନିଃ ଆଇଃକ୍‌ଗି ଆବୁଆଃ ଦୁକୁହାସୁକଏ ଗଅଃଇଦିକେଦା ।” ");
INSERT INTO unx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ୟୀଶୁ ଆୟାଃ ଉପୁନ୍‌ସାଃରେ ପୁରାଃ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌ତେ ଦରେୟା ହାନ୍‌ ପାରମ୍‌ତେବୁ ସେନା ମେନ୍ତେ ଚେଲାକକେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ଏନ୍ତେ ମିଆଁଦ୍‌ ଆଇନ୍‌ ଇତୁନିଃ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟା, “ହେ ଗୁରୁ, ଆମ୍‌ କତେମ୍‌ ସେନା ଏନ୍ତେଇଙ୍ଗ୍‌ ଅତଙ୍ଗ୍‌ମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟା, “ତୁୟୁକଆଃଦ ଲାତା ମେନାଃ ଆଡଃ ସିର୍ମା ଲାତାର୍‌ରେନ୍‌ ଚେଣେଁକଆଃ ଥକା ମେନାଃ ମେନ୍‌ଦ ମାନୱାହନ୍‌ଆଃ ବହଃ ଦହନାଙ୍ଗ୍‌ ଠାୟାଦ୍‌ ବାନଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଆୟାଃ ଚେଲାକଏତେ ଏଟାଃନିଃ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ସିଦାତେ ଆପୁଇଙ୍ଗ୍‌କେ ତପାଇ ନାଗେନ୍ତେ ସେନ୍‌ଇଚିଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ମେନ୍‌ଦ ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ, ଆଡଃ ଗଏଃକାନ୍‌କ ଆକଆଃ ଗଏଃକାନ୍‌କକେ ତପାକକାକ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ୟୀଶୁ ଲାଉକାରେ ଦେଏଃୟାନା ଆଡଃ ଇନିୟାଃ ଚେଲାକ ଇନିଃକେକ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ଏନ୍ତେ ନେଲେପେ, ଦରେୟାରେ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଦୁଦୁଗାର୍‌ହୟ ବିରିଦ୍‌ୟାନା ଆଡଃ ଲାଉକାରେ ଆଲ୍‌ପୁଙ୍ଗ୍‌କ ରାକାବ୍‌ୟାନା, ଆଡଃ ଲାଉକା ଡୁବିଃଗ୍‌ୟାନ୍‌ ଲେକା ହବାୟାନା । ମେନ୍‌ଦ ୟୀଶୁ ଦୁଡ଼ୁମ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ଚେଲାକ ଇନିଃତାଃତେ ସେନ୍‌କେଦ୍‌ତେ ବିରିଦିତାନ୍‌ଲଃ କାଜିକିୟାକ, “ହେ ପ୍ରାଭୁ, ବାଞ୍ଚାଅଲେମେ, ଆଲେ ଡୁବିଃଗ୍‌ ଗଜଃତାନାଲେ !” ");
INSERT INTO unx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆ, “ଏ ହୁଡିଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ତାନ୍‌କ, ଚିନାଃ ମେନ୍ତେପେ ବରତାନା ।” ଏନ୍ତେ ଇନିଃ ବିରିଦ୍‌କେଦ୍‌ତେ ହୟ ଆଡଃ ଦରେୟାରାଃ ଆଲ୍‌ପୁଙ୍ଗ୍‌କେ ମାରାଙ୍ଗ୍‌ମଚାକେଦା, ଏନ୍ତେ ସବେନାଃ ପୁରା ସିଃସଏଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ, ଆଡଃ ମେନ୍‌କେଦାକ, “ନିଃ ଚିଲ୍‌କାନ୍‌ ହଡ଼ ତାନିଃ ? ହୟ ଆଡଃ ଦରେୟାରାଃ ଆଲ୍‌ପୁଙ୍ଗ୍‌କ ନିଃକେ ମାନାତିଙ୍ଗ୍‌ତାନାକ !” ");
INSERT INTO unx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ୟୀଶୁ ଦରେୟା ହାନ୍‌ ପାରମ୍‌ ଗେରାସିମିକଆଃ ପାର୍‌ଗାନ୍‌ତେ ସେଟେର୍‌ୟାନ୍‌ଚି, ବାର୍‌ହଡ଼୍‌ ବଙ୍ଗା ଏସେର୍‌କାନ୍‌କିନ୍‌ ତପାଠାୟାଦ୍‌ଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ୟୀଶୁକେ ସେନ୍‌ଦାରମ୍‌କିୟାକିନ୍‌ । ଇନ୍‌କିନାଃ ପୁରାଃ ପେଡ଼େଃ ଆଡଃ ବରୱାନ୍‌ଗି ତାଇକେନାକିନ୍‌, ଏନାତେ ଏନ୍‌ ହରାରେ ଜେତାଏ କାକ ସେନ୍‌ପାରମ୍‌ ଦାଡ଼ିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ଆଡଃ ଇମ୍‌ତାଗି ଇନ୍‌କିନ୍‌ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାକିନ୍‌, “ହେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌, ଆଲିଙ୍ଗ୍‌ଲଃ ଆମାଃ ଚିକାନ୍‌ କାମି ? ଚିୟାଃ ଆମ୍‌ ନେଡା ଆଉରି ସେଟେର୍‌ ସିଦାରେ ଆଲିଙ୍ଗ୍‌କେ ସାଜାଇ ଏମ୍‌ ନାଗେନ୍ତେ ନେତାଃତେମ୍‌ ହିଜୁଆକାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ଆଡଃ ଇନ୍‌କୁଏତେ କାଟିଃ ସାଙ୍ଗିନ୍‌ରେ ସୁକୁରିକଆଃ ମାରାଙ୍ଗ୍‌ ଗୋଟ୍‌ ଆତିଙ୍ଗ୍‌ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ଏନ୍ତେ ଏନ୍‌ ହଡ଼ଆଃ ଭିତାର୍‌ଏତେ ବଙ୍ଗାକ ୟୀଶୁକେ ବିନ୍ତିକେଦ୍‌ତେ କାଜିକିୟାକ, “ଆମ୍‌ ଆଲେକେ ଅଡଙ୍ଗ୍‌ଲେରେଦମ୍‌ ଏନ୍‌ ସୁକୁରିକଆଃ ଗୋଟ୍‌ରେ କୁଲ୍‌ତାଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ସେନଃପେ ।” ଏନ୍ତେ ଇନ୍‌କୁ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ସୁକୁରିକରେକ ବଲୟାନା, ଆଡଃ ସୁକୁରିକଆଃ ଗୋଟ୍‌, ଦରେୟାରେ ନିର୍‌ ଢୁଷ୍‌ମାଅୟାନାକ ଆଡଃ ଦାଆଃରେ ଡୁବିଃଗ୍‌ ଗଏଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ସୁକୁରି ଗୁପିତାନ୍‌କ ନିର୍‌ୟାନା ଆଡଃ ସାହାର୍‌ତେ ତେବାଃୟାନ୍‌ଚି, ହବାକାନ୍‌ ସବେନାଃ ଆଡଃ ଏନ୍‌ ବଙ୍ଗା ଏସେର୍‌କାନ୍‌କିନ୍‌କେ ହବାକାନ୍‌ତେୟାଃ ସବେନାଃ ଉଦୁବାଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ଏନ୍ତେ ସାହାର୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ୟୀଶୁକେ ନେଲ୍‌ ନାଗେନ୍ତେକ ଅଡଙ୍ଗ୍‌ୟାନା ଆଡଃ ଇନିଃକେ ନେଲ୍‌କିଃତେ, ଆଲେୟାଃ ସାହାର୍‌ରାଃ ସିମ୍‌ନାଏତେ ଅଡଙ୍ଗ୍‌ଅଃମେ ମେନ୍ତେକ ବିନ୍ତିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ୟୀଶୁ ଲାଉକାରେ ଦେଏଃୟାନ୍ତେ ଦରେୟା ପାରମ୍‌କେଦ୍‌ତେ ଆୟାଃ ସାହାର୍‌ତେ ହିଜୁଃରୁହାଡ଼୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ନେଲେପେ, ମିଆଁଦ୍‌ ବାତ୍‌କାନ୍‌ ହଡ଼କେ ପାର୍‌କମ୍‌ରେ ବାଟିୟାକାନ୍‌ଗି ୟୀଶୁତାଃ ଗଅଃ ଆଉକିୟାକ । ୟୀଶୁ ଇନ୍‌କୁଆଃ ବିଶ୍ୱାସ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ଏନ୍‌ ବାତ୍‌କାନ୍‌ନିଃକେ କାଜିକିୟା, “ଏ ହନ୍‌ ଆଲମ୍‌ ବରଏୟା ! ଆମାଃ ପାପ୍‌କ ଛାମାୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ଏନ୍ତେ ଆଇନ୍‌ ଇତୁକଏତେ ଚିମିନ୍‌କ ଆକ ଆକରେକ କାଜିକେଦା, “ନେ ହଡ଼ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ନିନ୍ଦାଇତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ୟୀଶୁ ଇନ୍‌କୁଆଃ ମନ୍‌ରେୟାଃ ଉଡ଼ୁଃ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆ, “ଆପେ ଚିକାନାଙ୍ଗ୍‌ ଆପେୟାଃ ମନ୍‌ରେ ଏତ୍‌କାନାଃପେ ଉଡ଼ୁଃତାନା ? ");
INSERT INTO unx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ଅକ୍‌ନାଃ ରାୱାଲାଃ ? ‘ପାପ୍‌ ତାମାଃକ ଛାମାୟାନା’ ମେନ୍ତେ କାଜିତେୟାଃ ରାୱାଲାଃ ଚି ‘ବିରିଦ୍‌ମେ ଆଡଃ ସେନେମେ’ ମେନ୍ତେ କାଜିତେୟାଃ ? ");
INSERT INTO unx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ମେନ୍‌ଦ ନେ ଅତେରେ ପାପ୍‌ ଛାମାରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ମାନୱାହନ୍‌ଆଃ ମେନାଃ,” ଏନା ଆପେ ସାରିଦାଡ଼ିପେ ମେନ୍ତେ ଇନିଃ ଏନ୍‌ ବାତ୍‌କାନ୍‌ନିଃକେ କାଜିକିୟା, “ମାର୍‌ ବିରିଦ୍‌ମେ ଆଡଃ ପାର୍‌କମ୍‌ତାମାଃ ଗଅଃକେଦ୍‌ତେ ଆମାଃ ଅଡ଼ାଃତେ ସେନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ଇନିଃ ବିରିଦ୍‌ୟାନ୍ତେ ଅଡ଼ାଃତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ପୁରାଃ ହଡ଼କ ବରକେଦାକ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ହଡ଼କକେ ନେ ଲେକାନ୍‌ ଆକ୍‌ତେୟାର୍‌ ଏମାକାଦ୍‌କ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାରାଙ୍ଗ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ୟୀଶୁ ଏନ୍ତାଃ ବାଗିକେଦ୍‌ତେ ସେନଃତାନ୍‌ ଇମ୍‌ତା ମାଥିଉ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ମାଲ୍‌ହାରମ୍‌ ଠାୟାଦ୍‌ରେ ଦୁବାକାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ଇନିଃକେ କାଜିକିୟା, “ଦେଲା ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ଏନ୍ତେ ମାଥିଉ ବିରିଦ୍‌କେଦ୍‌ତେ ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ୟୀଶୁ, ମାଥିଉଆଃ ଅଡ଼ାଃରେ ଜମ୍‌ ଦୁବାକାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ପୁରାଃ ମାଲ୍‌ହାରମ୍‌କ ଆଡଃ ପାପିକ ହିଜୁଃକେଦ୍‌ତେ, ୟୀଶୁଲଃ ଆଡଃ ଆୟାଃ ଚେଲାକଲଃକ ଦୁବ୍‍ ମେସାୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ଫାରୁଶୀକ ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ଇନିୟାଃ ଚେଲାକକେ କୁଲିକେଦ୍‌କଆକ, “ଆପେୟାଃ ଗୁରୁ ଚିକାନାଙ୍ଗ୍‌ ମାଲ୍‌ହାରମ୍‌କଲଃ ଆଡଃ ପାପିକଲଃ ଜମ୍‌ତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ୟୀଶୁ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆ, “ବୁଗିନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ମେନ୍ତେଦ କାହା ମେନ୍‌ଦ ହାସୁତାନ୍‌କ ନାଗେନ୍ତେ ବାଇଦ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ମେନ୍‌ଦ ଆପେ ସେନଃପେ ଆଡଃ ‘ଆଇଙ୍ଗ୍‌ ଦାଣେଁରାକାବ୍‌ କାହାଗି ମେନ୍‌ଦ ଲିବୁଇଙ୍ଗ୍‌ ସୁକୁତାନା’ ନେ କାଜିରେୟାଃ ମୁଣ୍ଡି ଇତୁନ୍‌ପେ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଧାର୍‌ମାନ୍‌ ହଡ଼କକେ କେଡ଼ା ନାଗେନ୍ତେଦ କା ମେନ୍‌ଦ ପାପିକକେ କେଡ଼ା ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ହିଜୁଆକାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ଏନ୍ତେ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ଆଃ ଚେଲାକ ୟୀଶୁତାଃତେ ହିଜୁଃକେଦ୍‌ତେ କୁଲିକିୟାକ, “ଆଲେ ଆଡଃ ଫାରୁଶୀକ କାଟାବ୍‌ ରିକାଃଲେ, ମେନ୍‌ଦ ଆମାଃ ଚେଲାକ ଚିନାଃମେନ୍ତେ କାକ କାଟାବାଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଆଣ୍‌ଦିଅଡ଼ାଃରେ ବାଲାକଲଃ ଦୁହ୍ଲାକଡ଼ା ତାଇନଃ ଜାକେଦ୍‌ ଚିୟାଃ ଇନ୍‌କୁ ରେଙ୍ଗେଃ କାଟାବ୍‌ଗି ତାଇନାଃକ ? କାହାଗି, ଏନ୍‌କାଦ କା ହବାଅଆଃ । ମେନ୍‌ଦ ନେଡା ତେବାଗାଃ, ଦୁହ୍ଲାକଡ଼ାକେ ଇନ୍‌କୁତାଃଏତେ ଇଦିୟଃଆ, ଏନ୍‌ ଦିପିଲିରେ ଇନ୍‌କୁ କାଟାବେୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ଜେତାଏ ନାୱା ଲିଜାଃରାଃ କେଚାଃ ମାରି ଲିଜାଃରେ ଜଡ଼ାଇକେଦ୍‌ତେ କାକ ତୁନାୟା, ଚିୟାଃଚି ନାୱା ଲିଜାଃରାଃ କେଚାଃ ମାରି ଲିଜାଃଏତେ ଆଡଃଗି ଚେଚାଃ ଇଦିୟାଏ, ଆଡଃ ଏନ୍‌ ଚେଚାଃ ସିଦାଏତେ ଆଡଃଗି ମାରାଙ୍ଗ୍‌ ଇଦିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ଆଡଃ ହଡ଼କ ନାୱା ଦାଖ୍‌ରାସିକେ ମାରି ଉହୁର୍‌ତୁମ୍ବାରେ ଜେତାଏ କାକ ଦୁଲ୍‌ପେରେଜେୟା, ଚିୟାଃଚି ଦାଖ୍‌ରାସି ଉହୁର୍‌ତୁମ୍ବାକେ ଅଡ଼େଃତାଃଏ ଆଡଃ ଦାଖ୍‌ରାସି ଲିଙ୍ଗି ଏଣ୍ଡାଗଃଆ, ଏନାମେନ୍ତେ ହଡ଼କ ନାୱା ଦାଖ୍‌ରାସିକେଦ ନାୱା ଉହୁର୍‌ତୁମ୍ବାରେ ପେରେଜାଃକ, ଆଡଃ ବାରାନାଃ ଦହ ଜାତାନଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ୟୀଶୁ ଇନ୍‌କୁକେ ନେଆଁଁ କାଜିୟାକ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଯିହୁଦୀକଆଃ ମିଆଁଦ୍‌ ଆଗୁଆଇ ଇନିଃତାଃ ହିଜୁଃକେଦ୍‌ତେ ଆୟାଃ ଆୟାର୍‌ରେ ଇକ୍‌ଡ଼ୁମ୍‌ୟାନା ଆଡଃ କାଜିକିୟାଏ, “ହନିଙ୍ଗ୍‌କୁଡ଼ି ନାହାଁଃଗି ଟୁଣ୍ଡୁକେଦା । ଇନିଃ ଚିଲ୍‌କା ବାଞ୍ଚାଅଃଆଏ, ଏନାମେନ୍ତେ ହିଜୁଃମେ, ଆଡଃ ଇନିୟାଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହେମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ଏନ୍ତେ ୟୀଶୁ ବିରିଦ୍‌କେଦ୍‌ତେ ଆୟାଃ ଚେଲାକଲଃ ଏନ୍‌ ହାକିମ୍‌କେ ଅତଙ୍ଗ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ଆଡଃ ବାରା ବାରାଷ୍‌ଏତେ ମାୟୋମ୍‌ଲିଙ୍ଗି ଦୁକୁରେ ଦୁକୁତାନ୍‌ ମିଆଁଦ୍‌ କୁଡ଼ି ଦୟାହରା ହିଜୁଃକେଦ୍‌ତେ ୟୀଶୁଆଃ ଲିଜାଃରାଃ ଆଚ୍‌ରା ଜୁଟିଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ଚିୟାଃଚି ଇନିଃ ଆୟାଃ ମନ୍‌ରେ “ଇନିୟାଃ ଲିଜାଃ ଏସ୍‌କାର୍‌ ଜୁଟିଦ୍‌ତାରେଦ ଆଇଙ୍ଗ୍‌ ବୁଗିକଆଇଙ୍ଗ୍‌” ମେନ୍ତେ ଉଡ଼ୁଃତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ମେନ୍‌ଦ ୟୀଶୁ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ଇନିଃକେ ନେଲ୍‌କିଃତେ କାଜିକିୟା, “ଏ ମାଈ, ଆଲମ୍‌ ବରଏୟା, ବିଶ୍ୱାସ୍‌ ତାମାଃ ବୁଗିୟାକାଦ୍‌ମେଁୟାଏ ।” ଏନ୍‌ ନେଡାରେଗି ଏନ୍‌ କୁଡ଼ି ବୁଗିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ଏନ୍ତେ ୟୀଶୁ ଏନ୍‌ ଆଗୁଆଇରାଃ ଅଡ଼ାଃତେ ହିଜୁଃକେଦ୍‌ତେ ଗନଏଃରାଃ ମୁର୍‌ଲିସାଡ଼ି ହଡ଼କକେ ଆଡଃ ହାଲାଗୁଲାତାନ୍‌ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌ତେ, ");
INSERT INTO unx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ଇନିଃ ମେତାଦ୍‌କଆଏ, “ବାହାରି ଅଡଙ୍ଗ୍‌ଅଃପେ କୁଡ଼ିହନ୍‌ଦ କାଏ ଗଏଃକାନା, ମେନ୍‌ଦ ଦୁଡ଼ୁମ୍‌ତାନାଏ ।” ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଲାନ୍ଦାକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ମେନ୍‌ଦ ପୁରାଃ ହଡ଼କକେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ, ଇନିଃ ଭିତାର୍‌ତେ ବଲୟାନା ଏନ୍ତେ କୁଡ଼ି ହନ୍‌ରାଃ ତିଃଇ ସାବ୍‌କେଦାଏ, ଆଡଃ କୁଡ଼ି ହନ୍‌ ବିରିଦ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଆଡଃ ନେ କାଜି ଏନ୍‌ ଗଟା ଦିଶୁମ୍‌ ଆୟୁମ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ୟୀଶୁ ଏନ୍ତାଃଏତେ ସେନଃତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ବାର୍‌ହଡ଼୍‌ କା ନେଲ୍‌ଦାଡ଼ିକିନ୍‌ ଇନିୟାଃ ଦୟାଦୟାତେ ଅତଙ୍ଗ୍‌କିଃତେ କାଉରିକେଦାକିନ୍‌, “ହେ ଦାଉଦ୍‌ଆଃ ହନ୍‌, ଆଲିଙ୍ଗ୍‌କେ ଦାୟାଲିଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ୟୀଶୁ ଅଡ଼ାଃତେ ବଲୟାନ୍‌ଚି, ଏନ୍‌ କା ନେଲ୍‌ଦାଡ଼ିକିନ୍‌ ଇନିଃତାଃତେ ହିଜୁଃୟାନାକିନ୍‌ ଆଡଃ ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ କୁଲିକେଦ୍‌କିନା, “ଆଇଙ୍ଗ୍‌ ଆବେନ୍‌କେ ବୁଗି ଦାଡ଼ିୟାଇଙ୍ଗ୍‌ ମେନ୍ତେ ଚିନାଃ ଆବେନ୍‌ ବିଶ୍ୱାସ୍‌ତାନାବେନ୍‌ ?” ଇନ୍‌କିନ୍‌ କାଜିରୁହାଡ଼୍‌କିୟା, “ହେଗି, ପ୍ରାଭୁ ।” ");
INSERT INTO unx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କିନାଃ ମେଦ୍‌କେ ଜୁଟିଦ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କିନା, “ଆବେନାଃ ବିଶ୍ୱାସ୍‌ ଲେକା ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ଆଡଃ ଇନ୍‌କିନ୍‌ ନେଲ୍‌ ଦାଡ଼ିକେଦାକିନ୍‌ । ଏନ୍ତେ ୟୀଶୁ ଚେତାୱାନ୍‌ଗି ଇନ୍‌କିନ୍‌କେ ମେତାଦ୍‌କିନା, “ନେଲେବେନ୍‌, ନେଆଁଁ ଜେତାଏକକେ ଆଲ୍‌ବେନ୍‌ କାଜିକ ।” ");
INSERT INTO unx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ମେନ୍‌ଦ ଇନ୍‌କିନ୍‌ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ, ୟୀଶୁଆଃ ବିଷାଏରେ ଏନ୍‌ ଦିଶୁମ୍‌ରାଃ ସବେନ୍‌ତାଃକିନ୍‌ ଉଦୁବ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ହଡ଼କ ଅଡଙ୍ଗ୍‌ଅଃତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଚିମିନ୍‌ ହଡ଼କ ମିଆଁଦ୍‌ କା ବାଖାଁଣ୍‌ ଦାଡ଼ିତାନ୍‌ ହଡ଼କେ ୟୀଶୁତାଃତେକ ଆଉକିୟା । ଇନିଃ ବଙ୍ଗା ଏସେର୍‌କାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଆଡଃ ବଙ୍ଗା ଅଡଙ୍ଗ୍‌ୟାନ୍‌ ଇମ୍‌ତାଗି ଇନିଃ ଜାଗାର୍‌ ଏଟେଦ୍‌କେଦାଏ । ସବେନ୍‌ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ ଆଡଃ କାଜିକେଦାଃକ, “ଆଲେ ନେ ଲେକାନ୍‌ କାମି ଚିଉଲାହ ଇସ୍ରାଏଲ୍‌ରେ କାଲେ ନେଲାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ମେନ୍‌ଦ ଫାରୁଶୀକ ମେନ୍‌କେଦା, “ବଙ୍ଗାକଆଃ ଗମ୍‌କେରାଃ ଦେଙ୍ଗାତେ ୟୀଶୁ ବଙ୍ଗାକକେ ହାର୍‌ ଅଡଙ୍ଗ୍‌କତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ୟୀଶୁ ସବେନ୍‌ ସାହାର୍‌ ଆଡଃ ହାତୁ ହାତୁ ହନର୍‌ତାନ୍‌ ତାଇକେନାଏ । ଇନିଃ ଇନ୍‌କୁଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଇତୁକତାନ୍‌ଲଃ ରାଇଜ୍‌ରେୟାଃ ସୁକୁକାଜି ଉଦୁବ୍‍କେଦାଏ ଆଡଃ ହଡ଼କଆଃ ସବେନ୍‌ ଦୁକୁ ଆଡଃ ସବେନ୍‌ ହାସୁକଏତେ ବୁଗିକତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌ତେ ଆୟାଃ ମନ୍‌ରେ ବିଲ୍‌କାଅୟାନାଏ, ଚିୟାଃଚି ଇନ୍‌କୁଦ ଗୁପିନିଃ ବାଙ୍ଗାଇ ମିଣ୍ଡିକ ଲେକା ଜୀଉ ଦୁକୁଆକାନ୍‌ ଆଡଃ ଛିତିବିତିକାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଚେଲାକକେ କାଜିକେଦ୍‌କଆ, “ଇରୋଃ ପୁରାଃଗିୟାଃ ମେନ୍‌ଦ କାମିନାଲାକ ହୁଡିଙ୍ଗ୍‌ଆଁକ । ");
INSERT INTO unx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ଆମ୍‌ ଆମାଃ ଇରୋଃତେ କାମି ନାଲାକ କୁଲ୍‌କମ୍ ମେନ୍ତେ ଇରୋଃ ଗମ୍‌କେତାଃରେ ବିନ୍ତିମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ୟୀଶୁ ଆୟାଃ ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ ଆୟାଃତାଃତେ ହାକାଅକେଦ୍‌ତେ ସତ୍‌ରା ଆତ୍ମାକକେ ହାର୍‌ଅଡଙ୍ଗ୍‌ରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ଆଡଃ ସବେନ୍‌ ଲେକାନ୍‌ କିଲିମିଲି ଦୁକୁ ହାସୁଏତେ ବୁଗିକ ନାଗେନ୍ତେ ଆକ୍‌ତେୟାର୍‌ ଏମାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ଏନ୍‌ ବାରା ପ୍ରେରିତ୍‌କଆଃ ନୁତୁମ୍‌ ନେ ଲେକା ମେନାଃ, ପାହିଲାନିୟାଃ ନୁତୁମ୍‌ ଶିମୋନ୍‌, ଇନିଃଦ ପାତ୍‌ରାସ୍‌ ମେନ୍ତେ କାଜିୟଃତାନା ଆଡଃ ଆୟାଃ ହାଗାତେ ଆନ୍ଦ୍ରିୟାସ୍‌, ଜେବଦୀୟାଃ ବାରିଆ ହନ୍‌କଡ଼ାକିନ୍‌ ଯାକୁବ୍‌ ଆଡଃ ଯୋହାନ୍‌, ");
INSERT INTO unx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ଫିଲିପ୍‌ ଆଡଃ ବାର୍ଥୋଲମି, ଥୋମା ଆଡଃ ମାଲ୍‌ହାରମ୍‌ନିଃ ମାଥିଉ, ଆଲ୍‌ଫିୟନାଃ ହନ୍‌ ଯାକୁବ୍‌, ଆଡଃ ଥଦ୍ଦିୟ, ");
INSERT INTO unx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ଶିମୋନ୍‌ ଅକଏଚି ଇସ୍ରାଏଲ୍‌ ହଡ଼କଆଃ ତନଲ୍‌ହେତେ ରାଡ଼ା ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌ ତାଇକେନାଏ, ଆଡଃ ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା ଅକଏଚି ତାୟମ୍‌ତେ ୟୀଶୁକେ ବାଇରିକଆଃ ତିଃଇରେ ଏମ୍‌ ଏଣ୍ଡାଃକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ୟୀଶୁ ନେ ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ କୁଲ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁକେ ଆଚୁକତାନ୍‌ଲଃ ମେତାଦ୍‌କଆଏ, “ସାଅଁସାର୍‌ ହଡ଼କତାଃତେ ଆଲ୍‌ପେ ସେନା ଚାଏ ଶମିରୋନିକଆଃ ଜେତା ସାହାର୍‌ତେ ଆଲ୍‌ପେ ବଲଆ । ");
INSERT INTO unx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ମେନ୍‌ଦ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କ, ମିଣ୍ଡିକଲେକା ଆଦାକାନ୍‌ ହଡ଼କତାଃତେ ସେନଃପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ଆଡଃ ସେନ୍‌ତାନ୍‌ ସେନ୍‌ତାନ୍‌ଲଃ ‘ସିର୍ମା ରାଇଜ୍‌ ନାଡ଼େଃକାନା’ ମେନ୍ତେ ଉଦୁବେପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ହାସୁତାନ୍‌କକେ ବୁଗିକପେ, ଗଏଃକାନ୍‌କକେ ଜୀଉବିରିଦ୍‌କପେ, ନାଗେଘାଅକାନ୍‌କକେ ଫାର୍‌ଚିକପେ ଆଡଃ ବଙ୍ଗାକକେ ହାର୍‌ ଅଡଙ୍ଗ୍‌କପେ । ଆପେ ବେଗାର୍‌ ଗନଙ୍ଗ୍‌ତେ ନାମ୍‌କାଦ୍‌ତେୟାଃ ବେଗାର୍‌ ଗନଙ୍ଗ୍‌ତେ ଏମାକପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ଆପେୟାଃ ଥାଇଲାରେ ସୋନା, ରୁପା ଚାଏ ତାମ୍ବାରେୟାଃ ଟାକା ଆଲ୍‌ପେ ଇଦିୟା । ");
INSERT INTO unx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ଆଡଃ ହରା ସେନ୍‌ ନାଗେନ୍ତେ ଥାଇଲା ଚାଏ ବାରିଆ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃ ଚାଏ ଖାର୍‌ପା ଚାଏ ସଟା ଆଲ୍‌ପେ ଇଦିୟା, ଚିୟାଃଚି କାମିନିଃଦ ଆୟାଃ ନାଲା ନାମେ ଲେକାଃଏ । ");
INSERT INTO unx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ଆଡଃ ଆପେ ଜେତା ସାହାର୍‌ରେ ଚାଏ ହାତୁରେପେ ବଲରେଦ, ଏନ୍ତାଃରେ ଆପେକେ ସୁକୁଆପେତାନ୍‌ଲଃ ଦାରମ୍‌ପେନିଃକେ ଦାଣାଁଁଇପେ, ଆଡଃ ଏନ୍ତାଃଏତେ ଆଉରି ସେନଃ ଜାକେଦ୍‌ ଏନ୍ତାଃରେଗି ତାଇନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ଆଡଃ ଆପେ ଏନ୍‌ ଅଡ଼ାଃରେ ବଲ ଇମ୍‌ତା, ‘ଆପେରେ ଜୀଉସୁକୁ ହବାଅଃକା’ ମେତାକପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ଆପେକେ ଏନ୍‌ ଅଡ଼ାଃରେନ୍‌ ହଡ଼କ ଦାରମ୍‌ପେରେଦ, ଆପେୟାଃ ଜୀଉସୁକୁ ଇନ୍‌କୁରେ ତାଇନ୍‌କା, ମେନ୍‌ଦ ଇନ୍‌କୁ କାକ ଦାରମ୍‌ପେରେଦ ଆପେୟାଃ ସୁକୁ ଆପେତାଃତେ ରୁହାଡ଼୍‌କା । ");
INSERT INTO unx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଆଡଃ ଜେତାଏ କାକ ଦାରମ୍‌ପେରେଦ ଚାଏ ଆପେୟାଃ କାଜି କାକ ଆୟୁମ୍‌ରେଦ, ଏନ୍‌ ଅଡ଼ାଃଏତେ ଚାଏ ଏନ୍‌ ସାହାର୍‌ଏତେ ଅଡଙ୍ଗ୍‌ ଇମ୍‌ତା ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌କଆପେ ମେନ୍ତେ ମିଆଁଦ୍‌ ଚିହ୍ନାଁ ଲେକା ଆପେୟାଃ କାଟା ତାଲ୍‌କାରେୟାଃ ଧୁଡ଼ି କଟା ବାଗିତାପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିପେତାନାଇଙ୍ଗ୍‌, ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଏନ୍‌ ସାହାର୍‌ରେନ୍‌ ହଡ଼କତାଃଏତେ ସୋଦମ୍‌ ଆଡଃ ଗମ୍‌ରା ଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କଆଃ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ପୁରାଃ ଲିବୁଇୟାକଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ନେଲେପେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ମିଣ୍ଡିକ ଲେକା ହୁଣ୍ଡାର୍‌କ ଥାଲାରେଇଙ୍ଗ୍‌ କୁଲ୍‌ପେତାନା, ଏନା ନାଗେନ୍ତେ ବିଙ୍ଗ୍‌କ ଲେକା ସେଣାଁଁନଃପେ ଆଡଃ ଦୁଦୁମୁଲ୍‌କ ଲେକା ଲେବେୟଃପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ମେନ୍‌ଦ ହଡ଼କତାଃଏତେ ଚିର୍ଗାଲାକାନ୍‌ ତାଇନ୍‌ପେ, ଚିୟାଃଚି ଇନ୍‌କୁ ଆପେକେ ପାଞ୍ଚେଟ୍‌କରେକ ଜିମାପେୟା ଆଡଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେକ ହାଁଣ୍‌ସାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ଆଡଃ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଆପେକେ ଇନ୍‌କୁତାଃ ଆଡଃ ସାଅଁସାର୍‌କତାଃ ଗାୱା ଏମ୍‌ ନାଗେନ୍ତେ ହାକିମ୍‌ ଆଡଃ ରାଜାକଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ତେକ ଆଉପେୟା । ହାକିମ୍‌ ଆଡଃ ରାଜାକଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ତେକ ଆଉପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ମେନ୍‌ଦ ଚିମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କୁ ଆପେକେ ଜିମାପେୟାକ ଇମ୍‌ତା ଚିନାଃବୁ କାଜିୟା ଚିଲ୍‌କାବୁ କାଜିୟା ମେନ୍ତେ ସିଦାରେ ଆଲ୍‌ପେ ଉଡ଼ୁଃୟା, ଚିୟାଃଚି ଏନ୍‌ ଦିପିଲି ହିଜୁଃଆ ଇମ୍‌ତା ଆପେକେ ଅକଆଃ କାଜି ନାଗେନ୍ତେ ଏମଃଆ ଏନାପେ କାଜିୟା । ");
INSERT INTO unx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ଚିୟାଃଚି ଆପେ ଅକ କାଜିପେ କାଜିୟା ଏନାଦ ଆପେତେଗି କା, ମେନ୍‌ଦ ଆପେୟାଃ ଆପୁଆଃ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ହରାତେପେ କାଜିୟା । ");
INSERT INTO unx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ହାଗା ଆୟାଃ ହାଗାତେକେ ଆଡଃ ଆପୁ ଆୟାଃ ହନ୍‌କେ ଗଜି ନାଗେନ୍ତେ ଜିମାଇୟାଏ, ଆଡଃ ହନ୍‌କ ଆକଆଃ ଏଙ୍ଗା ଆପୁକଆଃ ବିରୁଧ୍‌ରେକ ବିରିଦାଃ ଆଡଃ ଇନ୍‌କୁକେ ଗଏଃ ଇଚିକଆକ । ");
INSERT INTO unx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ଆଇଁୟାଃ ନାଗେନ୍ତେ ସବେନ୍‌ ହଡ଼କ ଆପେକେ ହିଲାଙ୍ଗ୍‌ପେୟାକ, ମେନ୍‌ଦ ଜେତାଏ ଟୁଣ୍ଡୁ ଜାକେଦ୍‌ ତିଙ୍ଗୁ କେଟେୟାକାନ୍ ତାଇନ୍‌ନିଃ ବାଞ୍ଚାଅଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ଚିମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କୁ ଆପେକେ ମିଆଁଦ୍‌ ସାହାର୍‌ରେକ ସାସାତିପେରେ, ଇମ୍‌ତାଙ୍ଗ୍‌ ଏଟାଃ ସାହାର୍‌ତେ ନିର୍‌ପେ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିପେତାନା, ଆପେ ଇସ୍ରାଏଲ୍‌ରାଃ ସବେନ୍‌ ସାହାର୍‌ରେ କାମି ଆଉରି ଚାବାଏ ସିଦାରେ ମାନୱାହନ୍‌ ହିଜୁଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ଗୁରୁଏତେ ଚେଲା କାଏ ମାରାଙ୍ଗ୍‌ଆଃ ଚାଏ ଆୟାଃ ଗମ୍‌କେଏତେ ଦାସି କାଏ ମାରାଙ୍ଗ୍‌ଆଁ । ");
INSERT INTO unx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ଚେଲା ଆୟାଃ ଗୁରୁ ଲେକା ଆଡଃ ଦାସି ଆୟାଃ ଗମ୍‌କେ ଲେକା ହବାଅଃରେଦ, ଇନ୍‌କୁକେ ଇମ୍‌ନାଙ୍ଗ୍‌ରେଗି ସୁକୁ ହବାଅଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ଇନ୍‌କୁ ଅଡ଼ାଃରେନ୍‌ ଗମ୍‌କେ କେ ବାଲ୍‌ଜେବୁଲ୍‌ ମେନ୍ତେକ ମେତାଇତାନ୍‌ରେଦ, ଇନିୟାଃ ଅଡ଼ାଃରେନ୍‌କକେ ଏନାଏତେ ଆଦ୍‌କା ଏତ୍‌କାନ୍‌କ ନୁତୁମ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ଏନା ନାଗେନ୍ତେ ହଡ଼କକେ ଆଲ୍‌ପେ ବରଆକଆ, ଚିୟାଃଚି ଅକ୍‌ନାଃ ଉକୁଆକାନ୍‌ତେୟାଃ ଉଦୁବଃଆ ଆଡଃ ଅକ୍‌ନାଃ ଦାନାଙ୍ଗ୍‌ଆଁକାନ୍‌ତେୟାଃ ସାରିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ଆଇଙ୍ଗ୍‌ ଆପେକେ ଅକ୍‌ନାଃ ନୁବାଃରେଇଙ୍ଗ୍‌ କାଜିକାଦ୍‌ତେୟାଃ ମାର୍ସାଲ୍‌ରେ ଉଦୁବେପେ ଆଡଃ ଅକ୍‌ନାଃ ଉକୁକେଦ୍‌ତେ ଆୟୁମେତେୟାଃ ସାଡ଼୍‌ମି ଚେତାନ୍ଏତେ ଉଦୁବେପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଆପେୟାଃ ହଡ଼୍‌ମ ଗଗଏଃକକେ, ମେନ୍‌ଦ ଆତ୍ମାକେ କା ଗଏଃ ଦାଡ଼ିକକେ ଆଲ୍‌ପେ ବରଆକଆ, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେୟାଃ ହଡ଼୍‌ମ ଆଡଃ ଆତ୍ମା ବାରାନାଃକେ ନାରାକ୍‌ରେ ଜିୟନ୍‌ ଦାଡ଼ିୟାଏ, ଇନିଃକେ ବରଆଇପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ଚିୟାଃ ବାରିଆ ଗେରଁୱାକିନ୍‌ ମିଦ୍‌ ସିକାତେ କାକିନ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ୟଃଆ ? ହଲେହଁ ଆପେୟାଃ ଆପୁଆଃ ବେଗାର୍‌ ଆଚୁତେ ଇନ୍‌କିନ୍‌ଏତେ ମିଆଁଦ୍‌ହଁ ଅତେ ଲାତାର୍‌ରେ କାଏ ଉୟୁଗଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ମେନ୍‌ଦ ଆପେୟାଃ ବହଃରାଃ ସବେନ୍‌ ଉବ୍‌ହ ଲେକାକାନା । ");
INSERT INTO unx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ଏନା ନାଗେନ୍ତେ ଆଲ୍‌ପେ ବରଏୟା, ଆପେ ପୁରାଃ ଗେରଁୱାକଏତେ ପୁରାଃଗି ଗନଙ୍ଗ୍‌ଆଃଁପେ । ");
INSERT INTO unx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ଜେତାଏ ନେପେଲ୍‌ରେ ଆପାନ୍‌କେ ଆଇଁୟାଃ ମେନ୍ତେ ଆଡଃ ଆଇଙ୍ଗ୍‌କେ ସାରିୟାଃକ ମେନ୍ତେ ହଡ଼କଆଃ ଆୟାର୍‌ରେ ଆଇଙ୍ଗ୍‌କେ ସାରିୟାଃଇଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିରେଦ, ଆଇଙ୍ଗ୍‌ହଁ ଆଇଁୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁଆଃ ଆୟାର୍‌ରେ ଇନିଃକେ ସାରିୟାଃଇଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ମେନ୍‌ଦ ଜେତାଏ ହଡ଼କଆଃ ଆୟାର୍‌ରେ ଆଇଙ୍ଗ୍‌କେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ମେନ୍ତେ କାଜିନିଃକେ, ଆଇଙ୍ଗ୍‌ହଁ ଆଇଁୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁଆଃ ଆୟାର୍‌ରେ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ମେନ୍ତେ କାଜିୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ରେ ଜୀଉସୁକୁ ଏମ୍‌ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ ଆଲ୍‌ପେ ଆଟ୍‌କାରେୟା । ବାନଃଗି, ଜୀଉସୁକୁ ଏମ୍‌ ନାଗେନ୍ତେଦ କା ମେନ୍‌ଦ ତାରାଉଡ଼ି ଏମ୍‌ ନାଗେନ୍ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ହନ୍‌କଡ଼ା ବିରୁଧ୍‌ରେ ଆପୁ, ଆଡଃ ହନ୍‌କୁଡ଼ି ବିରୁଧ୍‌ରେ ଏଙ୍ଗା, କିମିନ୍‌ ବିରୁଧ୍‌ରେ ହାନାର୍‌ତେକେ ବିନ୍‌ଗାଅ ନାଙ୍ଗ୍‌ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ଆଡଃ ଅଡ଼ାଃରେନ୍‌କଗି ଅଡ଼ାଃରେନ୍‌କଆଃ ବାଇରିକ ବାୟଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ଜେତାଏ ଆୟାଃ ଏଙ୍ଗା ଚାଏ ଆପୁତେକେ ଆଇଙ୍ଗ୍‌ଏତେ ଆଦ୍‌କା ଦୁଲାଡ଼୍‌ରେଦ, ଇନିଃ ଆଇଁୟାଃ ଚେଲା ବାଇୟଃ ଲେକାନ୍‌ନିଃ ନାହାଁଲିଃ, ଆଡଃ ଜେତାଏ ଲେକା ଆୟାଃ ହନ୍ତେକଡ଼ା ଚାଏ ହନ୍ତେକୁଡ଼ିକେ ଆଇଙ୍ଗ୍‌ଏତେ ଆଦ୍‌କା ଦୁଲାଡ଼୍‌ରେଦ, ଇନିଃ ଆଇଁୟାଃ ଚେଲା ବାଇୟଃ ଲେକାନ୍‌ନିଃ ନାହାଁଲିଃ । ");
INSERT INTO unx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଜେତାଏ ଆୟାଃ କ୍ରୁଶ୍‌ ଗଅଃକେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌କେ କାଏ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ରେଦ, ଇନିଃ ଆଇଁୟାଃ ଚେଲା ବାଇୟଃ ଲେକାନ୍‌ନିଃ ନାହାଁଲିଃ । ");
INSERT INTO unx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଜେତାଏ ଆୟାଃ ଜୀଉ ନାମେନିଃ, ଏନାଏ ଆଦେୟା ଆଡଃ ଜେତାଏ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଆୟାଃ ଜୀଉ ଆଦେନିଃ, ଏନାଏ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ଜେତାଏ ଆପେକେ ସୁକୁଆପେନିଃ, ଆଇଙ୍ଗ୍‌କେ ସୁକୁଆୟାଁଏ, ଆଡଃ ଆଇଙ୍ଗ୍‌କେ ସୁକୁଆଇଙ୍ଗ୍‌ନିଃ, ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‌ନିଃକେ ସୁକୁଆଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଜେତାଏ, ନାବୀ ତାନିଃ ମେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କୁନୁଲ୍‌ନିଃ ଲେକା ଦାରମିନିଃ ନାବୀଆଃ ନାଲାଏ ନାମେୟା ଆଡଃ ଜେତାଏ, ଇନିଃ ଧାର୍‌ମାନ୍‌ ହଡ଼ ତାନିଃ ମେନ୍ତେ ଧାର୍‌ମାନ୍‌ ହଡ଼ ଲେକାଏ ସୁକୁଆଇନିଃ ଧାର୍‌ମାନ୍‌ ହଡ଼ଆଃ ନାଲାଏ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ଆଡଃ ଜେତାଏ, ନେ ହୁପ୍‌ଡିଙ୍ଗ୍‌କଏତେ ମିହୁଡ଼୍‌କେ ଇନିଃ ଆଇଁୟାଃ ଚେଲା ତାନିଃ ମେନ୍ତେ ମିଦ୍‌ ଗିଲାସ୍‌ ରେହାଡ଼୍‌ ଦାଆଃ ନୁଁଏ ନାଗେନ୍ତେ ଏମାଇରେଦ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିପେତାନାଇଙ୍ଗ୍‌, ଇନିଃ ଆଇଁୟାଃ ଚେଲାତାନିଃ ମେନ୍ତେ ଆୟାଃ ନାଲା ନାମେଗିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ୟୀଶୁ ଆୟାଃ ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ ଆଚୁ ଚାବାକେଦ୍‌କଚି, ଇନିଃ ଏନ୍ତାଃ ବାଗିକେଦ୍‌ତେ ହେପାଦ୍‌ରାଃ ସାହାର୍‌ତେ ହଡ଼କକେ ଇତୁକ ନାଙ୍ଗ୍‌ ଆଡଃ ପ୍ରାଚାର୍‌ ନାଗେନ୍ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ଏନ୍ତେ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ଜେହେଲ୍‌ରେ ତାଇକେନ୍‌ ଇମ୍‌ତା ଖ୍ରୀଷ୍ଟ୍‌ଆଃ କାମିକ ଆୟୁମ୍‌କେଦ୍‌ତେ, ଆୟାଃ ବାର୍‌ହଡ଼୍‌ ଚେଲାକିନ୍‌କେ ଇନିଃତାଃ କୁଲି ନାଗେନ୍ତେ କୁଲ୍‌କେଦ୍‌କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ଇନ୍‌କିନ୍‌ ୟୀଶୁକେ କୁଲିକିୟାକିନ୍, “ଅକନ୍‌ ହଡ଼ ହିଜୁଃଆଏ ମେନ୍ତେ ଯୋହାନ୍‌ କାଜିକାଦ୍‌ ତାଇକେନାଏ, ଇନିଃ ଆମ୍‌ଗି ତାନ୍‌ମେ ଚି ଏଟାଃନିଃଲେ ନେଲ୍‌ହରାଇୟା ?” ");
INSERT INTO unx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ ମେତାଦ୍‌କିନା, “ଆବେନ୍‌ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ଅକ୍‌ନାଃବେନ୍‌ ନେଲାକାଦା ଆଡଃ ଆୟୁମାକାଦା ଏନାକ ଯୋହାନ୍‌କେ ଉଦୁବାଇବେନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କା ନେଲ୍‌ଦାଡ଼ିତାନ୍‌କ ନେଲେତାନା, କାଟା ଲେଙ୍ଗ୍‌ଡ଼ାକାନ୍‌କ ସେସେନ୍‌ତାନା, ନାଗେଘାଅକାନ୍‌କ ବୁଗି ନିଆଁରଃତାନା, ଭାଏଁରାକାନ୍‌କ ଆୟୁମେତାନା, ଗଜାକାନ୍‌କ ଜୀଉବିରିଦ୍‌ ରୁହାଡ଼ଃତାନା, ଆଡଃ ରେଙ୍ଗେଃ ହଡ଼କତାଃରେ ସୁକୁକାଜି ଉଦୁବଃତାନା । ");
INSERT INTO unx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ଆଡଃ ଆଇଁୟାଃ ବିଷାଏରେ ଅକନ୍‌କଆଃ ଜେତାନ୍‌ ଆଡ଼ାଃଉଡ଼ୁଃ ବାନଃଆ, ଇନ୍‌କୁ ସୁକୁତାନ୍‌ଗିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଯୋହାନ୍‌ଆଃ ଚେଲାକ ସେନଃ ତାଇକେନ୍‌ ଇମ୍‌ତା ୟୀଶୁ ଯୋହାନ୍‌ଆଃ ବିଷାଏରେ ପୁରାଃ ହଡ଼କକେ କାଜି ଏଟେଦ୍‌କେଦ୍‌ଆଏ, “ଆପେ ଯୋହାନ୍‌କେ ନେଲ୍‌ ନାଗେନ୍ତେ ସେନ୍‌କେନାପେ ଇମ୍‌ତା, ଚିକ୍‌ନାଃ ନେଲ୍‌ ନାଗେନ୍ତେ ସେନ୍‌କେନାପେ ? ଚିନାଃ ହୟତେ ଏକ୍‌ଲାଅଃତାନ୍‌ ବିର୍‌ନି ତାସାଦ୍‌କେ ? ‌ ");
INSERT INTO unx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ଏନା କାହାରେଦ ଚିକ୍‌ନାଃ ନେନେଲ୍‌ତେପେ ଅଡଙ୍ଗ୍‌କାନ୍‌ ତାଇକେନା । ଚିନାଃ ଗନଙ୍ଗ୍‌ଆଁନ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍‌ ହଡ଼କେ ? ଗନଙ୍ଗ୍‌ଆଁନ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍‌ ହଡ଼କ ରାଜାକଆଃ ଅଡ଼ାଃକରେକ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","କାଜିଙ୍ଗ୍‌ପେ, ଏନା କାହାରେଦ, ଚିକ୍‌ନାଃ ନେନେଲ୍‌ତେପେ ଅଡଙ୍ଗ୍‌ଲେନା ? ଚିନାଃ ମିଆଁଦ୍‌ ନାବୀକେ ? ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି ମେତାପେ ତାନାଇଙ୍ଗ୍‌, ନାବୀଏତେ ମାରାଙ୍ଗ୍‌ନିଃକେପେ ନେଲିୟା । ");
INSERT INTO unx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ଚିୟାଃଚି ଯୋହାନ୍‌ଆଃ ନାଗେନ୍ତେ ଧାରାମ୍‌ପୁଥିରେ ନେଆଁଁ ଅଲାକାନା, ‘ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିକେଦାଏ, ଆଲେ ଆମାଃଏତେ ସିଦାରେ ଆଲେୟାଃ ଦୁଁତ୍‌କେଲେ କୁଲିତାନା ଇନିଃ ଆମାଃ ନାଗେନ୍ତେ ପାହିଲାରେ ହରା ବାଇୟାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, କୁଡ଼ିକଏତେ ଜାନାମାକାନ୍‌ ସବେନ୍‌କଆଃ ଭିତାର୍‌ରେ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ ଜେତାଏ ବାଙ୍ଗାଇୟା, ହଲେହଁ ସିର୍ମା ରାଇଜ୍‌ରେନ୍‌ ହୁଡିଙ୍ଗ୍‌ନିଃ ଯୋହାନ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ଆଡଃ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ଆୟାଃ କାଜି ପ୍ରାଚାର୍‌କେଦ୍‌ ଦିପିଲିଏତେ ତିସିଙ୍ଗ୍‌ ଜାକେଦ୍‌ ସିର୍ମା ରାଇଜ୍‌ରେ ପୁରାଃଗି ପେଡ଼େୟାନ୍‌ତେ ଏତ୍‌କାନ୍‌ ହଡ଼କ ଏନାକେ ଆକ୍‌ତେୟାର୍‌ରେ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌ ତାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଯୋହାନ୍‌ଆଃ ଦିପିଲି ଜାକେଦ୍‌ ସବେନ୍‌ ନାବୀକ ଆଡଃ ମୁଶାରାଃ ଆନ୍‌ଚୁ ସିର୍ମା ରାଇଜ୍‌ ବିଷାଏରେ ଆୟାର୍‌କାଜିକ କାଜିକାଦା । ");
INSERT INTO unx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଆଡଃ ଆପେ ଆପେୟାଃ ମନେଲେକା ଇନ୍‌କୁଆଃ କାଜିପେ ବିଶ୍ୱାସେରେଦ, ଏନ୍‌ ହିଜୁଃତାଇକେନ୍‌ ଏଲିୟ ନିଃଗି ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଲୁତୁର୍‌ ମେନାଃନିଃ ଆୟୁମେକାଏ । ");
INSERT INTO unx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ଆଇଙ୍ଗ୍‌ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କକେ ଅକଏଲଃ ଜକାକଆଇଙ୍ଗ୍‌ ? ଇନ୍‌କୁଦ ପିଟ୍‌ରେ ଦୁବାକାନ୍‌ ଆଡଃ ଆକ ଆକରେ କେଡ଼ାଅଃତାନ୍‌ ହନ୍‌କ ଲେକାଃକ, ");
INSERT INTO unx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ଆଲେ ଆପେ ନାଗେନ୍ତେ ମୁର୍‌ଲିଲେ ସାଡ଼ିକେଦା, ମେନ୍‌ଦ ଆପେ କାପେ ସୁସୁନ୍‌କେଦାଃ, ଆଲେ ଦୁକୁତାନ୍‌ ଦୁରାଙ୍ଗ୍‌ଲେ ଦୁରାଙ୍ଗ୍‌କେଦାଃ ମେନ୍‌ଦ ଆପେ କାପେ ରାଆଃ କେଦାଃ ।’ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କ ଏନ୍‌ ଲେକାନ୍‌କ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ କାଟାବ୍‌କେଦାଏ ଆଡଃ ଦାଖ୍‌ରାସି କାଏ ନୁଁ କେଦାଃ, ଆଡଃ ହଡ଼କ ‘ଇନିଃକେ ବଙ୍ଗା ଏସେର୍‌କିୟାଏ’ ମେନ୍ତେକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ଚିମ୍‌ତା ମାନୱାହନ୍‌ ହିଜୁଃକେଦ୍‌ତେ ଜମ୍‌ ନୁଁ କେଦାଏ, ଇମ୍‌ତା ହଡ଼କ ଇନିଃକେ ‘ପେଟୁ ଆଡଃ ଦାଖ୍‌ରାସି ନୁଁ ହଡ଼, ମାଲ୍‌ହାରମ୍‌କଆଃ ଆଡଃ ପାପିକଆଃ ଗାତି ତାନିଃ’ କାଜିକିୟାକ । ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସେଣାଁଁ ଆୟାଃ କାମିତେ ଏନା ସାର୍‌ତି ମେନ୍ତେ ଉଦୁବାକାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ୟୀଶୁ ଅକନ୍‌ ସାହାର୍‌ରେନ୍‌ ହଡ଼କତାଃରେ ଆୟାଃ ପୁରାଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ରିକାକାଦ୍‌ ତାଇକେନାଏ, ଏନ୍‌ ସାହାର୍‌ରେନ୍‌ ହଡ଼କକେ ଇନିଃ ହିଲାଙ୍ଗ୍‌କେଦ୍‌କଆଏ, ଚିୟାଃଚି ଇନ୍‌କୁ କାକ ହେୟାତିଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ଏ କରାଜିନ୍, ଆମାଃ ଚିମିନ୍‌ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଃଆ, ଏ ବେଥ୍‌ସାଇଦା, ଚିମିନ୍‌ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଃଆ, ଆବେନ୍‌ରେ ହବାୟାନ୍ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ସୋର୍‌ ଆଡଃ ସିଦୋନ୍‌ରେ ହବାକାନ୍‌ରେଦ, ଇଦୁ ଇନ୍‌କୁ ଚିଉଲାରେ ବସ୍ତା ତୁସିଙ୍ଗ୍‌କେଦ୍‌ତେ ଆଡଃ ତରେକ୍‌ ଚେତାନ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ମନ୍‌ରୁହାଡ଼୍‌ କେଦ୍‌ତେୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେତାଃଏତେ ସୋର୍‌ ଆଡଃ ସିଦୋନ୍‌ରେନ୍‌ ହଡ଼କକେ ପୁରାଃ ଲିବୁଇୟାକଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ଆଡଃ ଏ କପର୍‌ନାହୁମ୍‌, ଚିୟାଃ ଆମ୍‌ ସିର୍ମା ଜାକେଦେମ୍ ରାକାବଆଃ ? ବାନଃଗି ଆମ୍‌ ପାତାଲ୍‌ ଜାକେଦେମ୍ ଏଣ୍ଡାଗଆଃ । ଚିୟାଃଚି ଆମ୍‌ରେ ଅକନ୍‌ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ରିକାୟାନା, ଏନା ସଦୋମ୍‌ରେ କାମିୟାକାନ୍‌ତେୟାଃ ହଲେ ସୋଦମ୍‌ ତିସିଙ୍ଗ୍‌ ଜାକେଦ୍‌ ତାଇନ୍‌କାନ୍‌ତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିପେତାନା, ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେତାଃଏତେ ସୋଦମ୍‌ ଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କକେ ପୁରାଃ ଲିବୁଇୟାକଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ଏନ୍‌ ଦିପିଲିରେ ୟୀଶୁ ବିନ୍ତିକେଦ୍‌ତେ କାଜିକେଦାଏ, “ହେ ଆବା, ସିର୍ମା ଆଡଃ ଅତେରେନ୍‌ ପ୍ରାଭୁ, ଆମ୍‌ ନେ କାଜିକ ସେଣାଁଁନ୍‌କ ଆଡଃ ଇତୁଆନ୍‌କତାଃଏତେମ୍‌ ଦାନାଙ୍ଗ୍‌ଆଁଁ କାଦାଃ, ଆଡଃ କା ଇତୁଆକାନ୍‌କତାଃରେମ୍ ଉଦୁବାକାଦାଃ ମେନ୍ତେଇଙ୍ଗ୍‌ ଧାନ୍ୟାବାଦ୍‌ ଏମାମ୍‌ତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ହେଗି, ହେ ଆବା, ନେୟାଁଗିଦ ଆମାଃ ବୁଗିନ୍‌ ସାନାଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ଆପୁଇଙ୍ଗ୍‌ ସବେନାଃ ଏମାକାଦିୟାଁଏ, ଆପୁକେ ବାଗିକେଦ୍‌ତେ ହନ୍‌ ଅକଏ ତାନିଃ ନେୟାଁ ଜେତାଏ କାକ ସାରିୟାଃ, ଆଡଃ ହନ୍‌କେ ବାଗିକେଦ୍‌ତେ ଆପୁ ଅକଏ ତାନିଃ ନେୟାଁ ଜେତାଏ କାକ ସାରିୟାଃ । ମେନ୍‌ଦ ଅକନ୍‌କକେ ଏନା ସାରି ନାଗେନ୍ତେ ହନ୍‌ ଆଇଃକ୍‌ଗି ସାଲାକୁଆଏ, ଇନ୍‌କୁ ଏସ୍‌କାର୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବିଷାଏରେ ସାରିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ଏ ଲାଗାକାନ୍‌ ଆଡଃ ବାହାରମ୍‌ତେ ତେନାକାନ୍‌ ହଡ଼କ ଆଇଙ୍ଗ୍‌ତାଃତେ ହିଜୁଃପେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ରୁଡ଼ୁନାଇଙ୍ଗ୍‌ ଏମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ଆଇଁୟାଃ ଆଡ଼୍‌ନା ଗଅଃଏପେ ଆଡଃ ଆଇଙ୍ଗ୍‌ଏତେ ଇତୁନ୍‌ପେ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ମନ୍‌ରେ ଲେବେଃ ଆଡଃ ନାରାମ୍‌ଗିୟାଇଙ୍ଗ୍‌, ଆଡଃ ଆପେ ରୁଡ଼ୁନ୍‌ପେ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ଆଇଁୟାଃ ଆଡ଼୍‌ନାଦ କେଟେଦ୍‌ ବାନଆଃ ଆଡଃ ବାହାରମ୍‌ ତାଇୟାଁଃ କା ହାମ୍ବାଲାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ଏନ୍‌ ଦିପିଲିରେ ୟୀଶୁ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ହେରାକାନ୍‌ ପିଡ଼ି ଥାଲାଥାଲାତେ ସେନଃତାନ୍‌ ତାଇକେନାଏ, ଆଡଃ ଆୟାଃ ଚେଲାକ ରେଙ୍ଗେଃତେ ଗେଲେ ଜ'କେ ହଦ୍‌କେଦ୍‌ତେ ଜମ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ମେନ୍‌ଦ ଫାରୁଶୀକ ଏନା ନେଲ୍‌କେଦ୍‌ତେ, ୟୀଶୁକେ କାଜିକିୟାକ, “ନେଲେମେ, ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ କା ଲାଗାତିଙ୍ଗ୍‌ କାମି ଆମାଃ ଚେଲାକ କାମିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଦାଉଦ୍‌ ଆଡଃ ଆୟାଃ ଗାତିକ ରେଙ୍ଗେଃୟାନ୍‌ ଇମ୍‌ତା ଚିନାଃଏ କାମିକେଦାଃ ଏନା କାପେଚି ପାଢ଼ାୱା କାଦାଃ ? ");
INSERT INTO unx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଅଡ଼ାଃତେ ବଲୟାନା, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନୁତୁମ୍‌ରେ ଏମାକାନ୍‌ ହଲଙ୍ଗ୍‌, ଅକ୍‌ନାଃକେଚି ଆଇନ୍‌ ଲେକାତେ ଯାଜାକ୍‌ ଏସ୍‌କାର୍‌ ଜମ୍‌ ଦାଡ଼ିୟାଏ ମେନଃତାନା, ଏନାକେ ଆଉକେଦ୍‌ତେ ଜମ୍‌କେଦାଏ ଆଡଃ ଆୟାଃଲଃ ତାଇକାନ୍‌କକେୟ ଜମ୍‌ନାଙ୍ଗ୍‌ ଏମାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ଚାଏ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଯାଜାକ୍‌କ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌କେ ସତ୍‌ରାଏ ରେୟ କାକ ଚିଟାଅଃଆ, ନେଆଁ ଚିନାଃ ମୁଶାରାଃ ଆନ୍‌ଚୁରେ ଆପେ କାପେ ପାଢ଼ାଅକାଦା ? ");
INSERT INTO unx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ଆଇଙ୍ଗ୍‌ ଆପେକେ ମେତାପେ ତାନାଇଙ୍ଗ୍‌, ମାନ୍ଦିର୍‌ ଅଡ଼ାଃଏତେ ମାରାଙ୍ଗ୍‌ ନେତାଃରେ ମେନାଇୟା । ");
INSERT INTO unx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ଆଇଙ୍ଗ୍‌ ଦାଣେଁରାକାବ୍‌ କାହାଗି ମେନ୍‌ଦ ଲିବୁଇଙ୍ଗ୍‌ ସୁକୁତାନା,’ ନେଆଁଁରାଃ ମୁଣ୍ଡିପେ ଆଟ୍‌କାର୍‌ଉରୁମ୍‌କାରେଦ, ନେ ବେଗାର୍‌ ଗୁହ୍ନାଁନ୍‌କକେ କାପେ ଚିଟାକାକତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ଚିୟାଃଚି ମାନୱାହନ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେନ୍ ଗମ୍‌କେ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ୟୀଶୁ ଏନ୍‌ ଠାୟାଦ୍‌ ବାଗିକେଦ୍‌ତେ ସାମାଜ୍‌ ଅଡ଼ାଃତେ ବଲୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ଆଡଃ ଏନ୍ତାଃରେ ତିଃଇ ରହଡ଼ାକାନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ । ଏନ୍ତେ ଚିମିନ୍‌ ହଡ଼କ ୟୀଶୁକେ ଚିଟାଇ ନାଗେନ୍ତେ କୁଲିକିୟାକ, “ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ବୁଗିତେୟାଃ ଆଇନ୍‌ ଲେକାତେ ଠାଉକାନ୍‌ଗିୟାଚି ?” ");
INSERT INTO unx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆ, “ଆପେକଏତେ ଜେତାଏୟାଃ ମିଣ୍ଡି, ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଗାଡାରେ ଉୟୁଃକେନଃରେ, ଚିୟାଃ ଆପେ ଇନିଃକେ ସାବ୍‌କିତେ କାପେ ଅଡଙ୍ଗ୍‌ଇଁୟା ? ");
INSERT INTO unx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ଆଡଃ ମିଣ୍ଡିଏତେ ହଡ଼ ପୁରାଃଗି ଗନଙ୍ଗ୍‌ଆଁଏ । ଏନା ନାଗେନ୍ତେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ବୁଗିନାଃ କାମିତେୟାଃ ଆଇନ୍‌ଲେକାତେ ଏଟାଃନିଃକେ ଦେଙ୍ଗାତେୟାଃ ଠାଉକାନ୍‌ଗିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ଏନ୍ତେ ଇନିଃ ଏନ୍‌ ହଡ଼କେ କାଜିକିୟାଏ, “ତିଃଇତାମାଃ ଜିଲିଙ୍ଗ୍‌ୟେଁମେ ।” ଏନ୍ତେ ଇନିଃ ତିଃଇତାୟାଃ ଜିଲିଙ୍ଗ୍‌କେଦାଏ, ଆଡଃ ଏଟାଃ ତିଃଇ ଲେକା ବୁଗିରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ମେନ୍‌ଦ ଫାରୁଶୀକ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ୟୀଶୁକେ ଚିଲ୍‌କାତେବୁ ଗଜିୟା ମେନ୍ତେକ ରଜୋଟକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ଚିମ୍‌ତା ୟୀଶୁ ଆୟାଃ ବିରୁଧ୍‌ରେ ରଜୋଟତାନାକ ମେନ୍ତେ ଆୟୁମ୍‌କେଦା ଇମ୍‌ତା ଇନିଃ ଏନ୍ତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନା ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟାକ ଏନ୍ତେ ସବେନ୍‌ ଦୁକୁତାନ୍‌କକେ ବୁଗିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ଆଡଃ ଆଇଁୟାଃ ବିଷାଏରେ ଏଟାଃକକେ ଆଲ୍‌ପେ କାଜିକଆ ମେନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ ମାରାଙ୍ଗ୍‌ମଚା କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ପାର୍‌ମେଶ୍ୱାର୍‌ ଯିଶାୟ ନାବୀଆଃ ହରାତେ କାଜିକାଦ୍‌ତେୟାଃ ପୁରାଅଃ, ନାଗେନ୍ତେ ଇନିଃ ନେଆଁଁ କାମିକେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ଆଇଁୟାଃ ଦାସି ନେତାଃରିୟା, ଅକଏକେଚି ଆଇଙ୍ଗ୍‌ ସାଲାକାଜାଇଙ୍ଗ୍‌, ଇନିଃକେ ଆଇଙ୍ଗ୍‌ ପୁରାଃଗିଇଙ୍ଗ୍‌ ଦୁଲାଡ଼୍‌ ତାନା, ଇନିଃତାଃରେ ଆଇଁୟାଃ ପୁରାଃଗି ସୁକୁ, ଆଇଙ୍ଗ୍‌ ଇନିଃରେ ଆଇଁୟାଃ ଆତ୍ମାକେ କୁଲିୟାଇଙ୍ଗ୍‌, ଆଡଃ ଇନିଃ ସବେନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କତାଃରେ ଆଇଁୟାଃ ବିଚାର୍‌ ଉଦୁବେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ଇନିଃ କାଏ ଏପେରାଙ୍ଗ୍‌ଆଃ ଚାଏ କାଏ କିର୍‌ଲାଅୟା, ଚାଏ ଥାଲା ହରାରେ କାଏ ତିଙ୍ଗୁନା ଆଡଃ ପୁରାଃତେ କାଏ କିର୍‌ଲାଅୟା । ");
INSERT INTO unx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ଇନିଃ କା ପେଡ଼େୟାନ୍‌କକେ ଲେବେଃ ମନ୍‌ତେ ନେଲ୍‌କଆ, ଆଡଃ ନାରାଦୁରାକକେ ଲିବୁଇୟାକଆ । ଇନ୍‌କୁ ବିଚାର୍‌ ଆଉରି ନାମେ ଜାକେଦ୍‌ ଏନ୍‌ କାମି ନାଗେନ୍ତେ କାଏ ଅହରାଅଆଃ, ");
INSERT INTO unx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ଆଡଃ ଇନିୟାଃ ନୁତୁମ୍‌ରେ ଦିଶୁମ୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ଆସ୍ରାଏୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ଏନ୍ତେ ଚିମିନ୍‌ ହଡ଼କ ବଙ୍ଗା ଏସେର୍‌କାନ୍‌ ମିଆଁଦ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିତାନ୍‌ ଆଡଃ କା ବାଖାଁଣ୍‌ ଦାଡ଼ିତାନ୍‌ ହଡ଼କେ ୟୀଶୁତାଃତେକ ଆଉକିୟା, ଆଡଃ ଇନିଃ ଏନ୍‌ ହଡ଼କେ ବୁଗିକିୟାଏ, ଏନ୍ତେ ଇନିଃ ବାଖାଁଣ୍‌ ଆଡଃ ନେଲ୍‌ ଦାଡ଼ିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ଗାଦେଲ୍‌ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ ଆଡଃ ମେନ୍‌କେଦା, “ଚିୟାଃ ନିଃ ଦାଉଦ୍‌ଆଃ ହନ୍‌ କା'ଚି ତାନିଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ମେନ୍‌ଦ ଫାରୁଶୀକ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ କାଜିକେଦାକ, “ବଙ୍ଗାକଆଃ ଗମ୍‌କେ ବାଲ୍‌ଜେବୁଲ୍‌ଗି ନିଃକେ ବଙ୍ଗାକକେ ହାର୍‌ଅଡଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ପେଡ଼େଃ ଏମାଇତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ୟୀଶୁ ଇନ୍‌କୁଆଃ ମନ୍‌ରେୟାଃ ଉଡ଼ୁଃ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଜେତା ରାଇଜ୍‌ ଆଇଃକ୍‌ତେଗି ବିନ୍‌ଗାଅକେଦ୍‌ତେ ଆକ ଆକଥାଲାରେ ଲାପ୍‌ଡ଼ାଇରେଦ ଏନ୍‌ ରାଇଜ୍‌ କା ତିଙ୍ଗୁନାଃ । ଜେତା ସାହାର୍‌ ଚାଏ ଅଡ଼ାଃରେ ବିନ୍‌ଗାଅ ହବାକେଦ୍‌ତେ ଆକ ଆକରେ ଲାପ୍‌ଡ଼ାଇରେଦ, ଇନ୍‌କୁ କାକ ତାଇନ୍‌ ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ଏନ୍‌ଲେକାଗି ସାଏତାନ୍‌, ସାଏତାନ୍‌ଆଃ ରାଇଜ୍‌ ହିଗାଡ଼୍‌କେଦ୍‌ତେ ବିନ୍‌ଗାଅରେଦ ଏନା କା ତିଙ୍ଗୁନାଃ, ମେନ୍‌ଦ ଛିତିବିତିକେଦ୍‌ତେ ଟୁଣ୍ଡୁଉତାରଃଆ । ଏନ୍‌ରେଦ ଚିଲ୍‌କାତେ ଆୟାଃ ରାଇଜ୍‌ ତାଇନ୍‌ ଦାଡ଼ିୟଃଆ ? ");
INSERT INTO unx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ଆଡଃ ଆଇଙ୍ଗ୍‌ ବାଲ୍‌ଜେବୁଲ୍‌ଆଃ ପେଡ଼େଃତେ ବଙ୍ଗାକଇଙ୍ଗ୍‌ ହାର୍‌ଅଡଙ୍ଗ୍‌କ ତାନ୍‌ରେଦ, ଆପେୟାଃ ହଡ଼କ ଅକଏୟାଃ ହରାତେକ ହାର୍‌ ଅଡଙ୍ଗ୍‌କତାନା ? ଏନା ନାଗେନ୍ତେ ଇନ୍‌କୁଗି ଆପେୟାଃ ବିଚାର୍‌ନିଃକ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆତ୍ମାତେ ବଙ୍ଗାକଇଙ୍ଗ୍‌ ହାର୍‌ଅଡଙ୍ଗ୍‌କ ତାନ୍‌ରେଦ ଏନାତେ ଆଟ୍‌କାରଃତାନା ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆପେତାଃତେ ତେବାଃକାନା । ");
INSERT INTO unx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ପେଡ଼େୟାନ୍‌ନିଃକେ ଆଉରି ତଲ୍‌ ଜାକେଦ୍‌ ଜେତାଏ ଇନିୟାଃ ଅଡ଼ାଃରେ ବଲକେଦ୍‌ତେ ଆୟାଃ ମେନାଃତେୟାଃ କାଏ ରେଃକ୍‌ଦାଡ଼ିୟା, ମେନ୍‌ଦ ସିଦାତେ ଇନିଃକେ ତଲ୍‌କେଦ୍‌ତେ ଆୟାଃ ମେନାଃତେୟାଃ ରେଃକ୍‌ଦାଡ଼ିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ଜେତାଏ ଆଇଁୟାଃଲଃ ବାଙ୍ଗାଇନିଃ, ଆଇଁୟାଃ ବିରୁଧ୍‌ରେ ମେନାଇୟା ଆଡଃ ଜେତାଏ ଆଇଁୟାଃଲଃ କାଏ ହୁଣ୍ଡିନିଃ ଛିତିବିତିୟଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ଏନା ନାଗେନ୍ତେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ହଡ଼କଆଃ ସବେନ୍‌ ପାପ୍‌ ଆଡଃ ଏତ୍‌କାନ୍‌ କାଜିକ ଛାମାୱାଃ, ମେନ୍‌ଦ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ବିରୁଧ୍‌ରେ ନିନ୍ଦା କାଜିକ କା ଛାମାୱାଃ । ");
INSERT INTO unx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଜେତାଏ ମାନୱାହନ୍‌ଆଃ ବିରୁଧ୍‌ରେ କାଜିନିଃ ଛାମାୱାଃ, ମେନ୍‌ଦ ଜେତାଏ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ବିରୁଧ୍‌ରେ କାଜିନିଃକେ ନେ ପାରିୟା ଚାଏ ହିଜୁଃତାନ୍‌ ପାରିୟାରେୟ କା ଛାମାୱାଃ । ");
INSERT INTO unx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ଆପେ ଦାରୁ ବୁଗିନାଃପେ ମେନେରେଦ ଜ ବୁଗିନାଃପେ ମେନେୟା ଚାଏ ଦାରୁ ଏତ୍‌କାନାଃପେ ମେନେରେଦ ଜ ଏତ୍‍କାନାଃପେ ମେନେୟା, ଚିୟାଃଚି ଦାରୁଦ ଆୟାଃ ଜ'ତେ ଆଟ୍‌କାର୍‍ଉରୁମଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ବିଙ୍ଗ୍‌କ ଲେକା ଏତ୍‍କାନ୍‌ ହଡ଼କ ତାନ୍‌ପେରେଦ ଚିଲ୍‌କାତେ ବୁଗିନ୍‌ତେୟାଃପେ କାଜିଦାଡ଼ିୟାଃ ? ଚିୟାଃଚି ମନ୍‌ରେ ଅକ୍‌ନାଃ ପେରେଜାକାନ୍‌ତେୟାଃ ମଚାଏ କାଜିୟା । ");
INSERT INTO unx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ବୁଗିନ୍‌ ହଡ଼ ଆୟାଃ ବୁଗିନ୍‌ ଭାଣ୍ଡାର୍‌ଅଡ଼ାଃଏତେ ବୁଗିନ୍‌ତେୟାଃ ଅଡଙ୍ଗ୍‌ୟେଁଆଏ, ଏତ୍‌କାନ୍‌ ହଡ଼ ଆୟାଃ ଏତ୍‌କାନ୍‌ ଭାଣ୍ଡାର୍‌ଅଡ଼ାଃଏତେ ଏତ୍‌କାନ୍‌ତେୟାଃ ଅଡଙ୍ଗ୍‌ୟେଁଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ହଡ଼କ ଆକଆଃ ମିମିଆଦ୍‌ ସାମାକାଜିରେୟାଃ ହିସାବ୍‌ ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ରେକ ଏମେୟା । ");
INSERT INTO unx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ଆପେ ଆପେୟାଃ ଜାଗାର୍‌ତେଗି ବିଚାର୍‌ୟାନ୍‌ଲଃ ଗୁହ୍ନାଁଁକାଦାପେ ଚି କାପେ ଗୁହ୍ନାଁଁକାଦା, ଏନା ଉଦୁବଃଆପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ଏନ୍ତେ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକଏତେ ଚିମିନ୍‌ ହଡ଼କ କାଜିକିୟାକ, “ହେ ଗୁରୁ, ଆଲେ ଆମାଃତାଃଏତେ ମିଆଁଦ୍‌ ଚିହ୍ନାଁ ନେନେଲ୍‌ ସାନାଙ୍ଗ୍‌ତାନାଲେ ।” ");
INSERT INTO unx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ଆପେ ନେ ପାରିୟାରେନ୍‌ ହଡ଼କ, ଚିମିନ୍‌ ଏତ୍‌କାନ୍‌ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ କା ବିଶ୍ୱାସ୍‌ତାନ୍‌କ ତାନ୍‌ପେ । ଆପେ ଆଇଙ୍ଗ୍‌କେ ମିଆଁଦ୍‌ ଚିହ୍ନାଁପେ ଆସିତାନା, ମେନ୍‌ଦ ଯୁନୁସ୍‌ ନାବୀଆଃ ଚିହ୍ନାଁ ବାଗିକେଦ୍‌ତେ ଆଡଃ ଏଟାଃ ଚିହ୍ନାଁ ଆପେକେ କା ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ଯୁନୁସ୍‌ ନାବୀ ଆପି ମାହାଁ ନିଦାସିଙ୍ଗି ମାରାଙ୍ଗ୍‌ ହାକୁଆଃ ଲାହିଦ୍‌ରେ ତାଇକେନାଏ, ଏନ୍‌ଲେକାଗି ମାନୱାହନ୍‌ ଆପି ମାହାଁ ନିଦାସିଙ୍ଗି ଅତେ ଭିତାର୍‌ରେ ତାଇନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ନିନିବିରେ ଯୁନୁସ୍‌ ନାବୀ ପ୍ରାଚାର୍‌କେଦ୍‌ ଇମ୍‌ତା ପାତିୟାର୍‌କେଦ୍‌ ହଡ଼କ ତିଙ୍ଗୁକେଦ୍‌ତେ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କଲଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଇନ୍‌କୁକେକ ଚିଟାକଆ, ଚିୟାଃଚି ଇନ୍‌କୁ ଯୁନୁସ୍‌ ପାର୍‌ଚାର୍‌କେଦ୍‌ ଇମ୍‌ତା ମନ୍‌ରୁହାଡ଼୍‌କେଦାକ, ଆଡଃ ନାହାଁଃ ଆଇଙ୍ଗ୍‌ କାଜିପେତାନାଇଙ୍ଗ୍‌, ଯୁନୁସ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ନିଃ ନେତାଃରେ ମେନାଇୟା । ");
INSERT INTO unx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଦାକ୍ଷିଣ୍‌ ଦିଶୁମ୍‌ରେନ୍‌ ରାନୀ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କଲଃ ତିଙ୍ଗୁନାଃ ଆଡଃ ଇନ୍‌କୁକେ ଚିଟାକଆ, ଚିୟାଃଚି ଇନିଃ ସୁଲିମାନ୍‌ଆଃ ସେଣାଁଁନ୍‌ କାଜି ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଆୟାଃ ଅତେଦିଶୁମ୍‌ରେୟାଃ ଟୁଣ୍ଡୁଏତେ ହିଜୁଃକାନ୍‌ ତାଇକେନା, ଆଡଃ ନେଲେପେ, ସୁଲିମାନ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ନିଃ ନେତାଃରେ ମେନାଇୟା । ");
INSERT INTO unx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ସତ୍‌ରା ଆତ୍ମା ମିହୁଡ଼୍‌ତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ରେ, ରହଡ଼୍‌ ଠାୟାଦ୍‌କରେ ହନର୍‌ବାଡ଼ାକେଦ୍‌ତେ ରୁଡ଼ୁନ୍‌ ନାଗେନ୍ତେ ଦାଣାଁଁୟାଏ ଆଡଃ କାଏ ନାମ୍‌ତାରେ, ");
INSERT INTO unx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ଇନିଃ କାଜିୟାଏ, ‘ଆଇଙ୍ଗ୍‌ ଅକନ୍‌ ଅଡ଼ାଃଏତେ ଅଡଙ୍ଗ୍‌କାନ୍‌ ତାଇକେନାଇଙ୍ଗ୍‌, ଏନ୍‌ ଅଡ଼ାଃତେଗି ସେନ୍‌ରୁହାଡ଼ାଇଙ୍ଗ୍‌,’ ଆଡଃ ଇନିଃ ଏନ୍‌ ଅଡ଼ାଃକେ ସାମାଅଡ଼ାଃ, ସାଫାକାନ୍‌ ଆଡଃ ସୁଗାଡ଼ାନ୍‌ଗି ନେଲେୟା । ");
INSERT INTO unx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ଏନ୍ତେ ଇନିଃ ସେନ୍‌କେଦ୍‌ତେ ଆୟାଃତାଃଏତେ ଆଦ୍‌କା ଏତ୍‌କାନ୍‌ ସାତ୍‌ଠୁ ଆତ୍ମାକକେ ମିଦ୍‌ତେ ଆଉକଆ, ଆଡଃ ଇନ୍‌କୁ ଏନାରେକ ବଲଆ ଆଡଃକ ତାଇନଃଆ । ଆଡଃ ଏନ୍‌ ହଡ଼ରାଃ ଦାସା ପାହିଲାଏତେ ଟୁଣ୍ଡୁ ଦାସା ପୁରାଃଗି ଏତ୍‌କାନ୍‌ ହବାଅଆଃ । ନେ ଦିପିଲିରେନ୍‌ ଏତ୍‌କାନ୍‌ ହଡ଼କଆଃଲଃ ନେ ଲେକା ହବାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ୟୀଶୁ ଗାଦେଲ୍‌ ହଡ଼କକେ କାଜିକତାନ୍‌ ତାଇକେନ୍‌ରେ, ଇନିୟାଃ ଏଙ୍ଗା ଆଡଃ ହାଗାକ ଏନ୍ତାଃ ସେଟେର୍‌କେଦ୍‌ତେ ବାହାରିରେ ତିଙ୍ଗୁୟାନାକ ଆଡଃ ଆୟାଃଲଃ ଜାଗାର୍‌ ନାଗେନ୍ତେ ମିହୁଡ଼୍‌ତାଃରେ କାଜିକୁଲ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ଏନ୍ତେ ମିହୁଡ଼୍‌ ଇନିଃକେ କାଜିକିୟାଏ, “ଆମାଃ ଏଙ୍ଗାମ୍‌, ଆଡଃ ହାଗାମ୍‌ତେକ ବାହାରିରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ଆମାଃଲଃ ଜାଗାର୍‌ ନାଗେନ୍ତେକ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ଅକଏ ଆଇଁୟାଃ ଏଙ୍ଗାଇଙ୍ଗ୍‌ ? ଆଡଃ ଅକନ୍‌କ ଆଇଁୟାଃ ହାଗାଇଙ୍ଗ୍‌କ ତାନ୍‌କ ?” ");
INSERT INTO unx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଚେଲାକକେ ଚୁଣ୍ଡୁଲ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆ, “ନେଲ୍‌କପେ, ନିକୁଦ, ଆଇଁୟାଃ ଏଙ୍ଗା ଆଡଃ ହାଗାକତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ଆଇଁୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁଆଃ ମନେଲେକା କାମିନିଃଗି ଆଇଁୟାଃ ହାଗା, ମିଶି ଆଡଃ ଏଙ୍ଗା ତାନ୍‌କ ।” ");
INSERT INTO unx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ଗି ୟୀଶୁ ଅଡ଼ାଃଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଦରେୟା ଗେନାରେ ଦୁବ୍‌ୟାନାଏ, ଆଡଃ ଇତୁ ଏଟେଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିୟାଃ ହେପାଦ୍‌ରେକ ଜୁରୁହୁଣ୍ଡିୟାନ୍ତେ ଇନିଃ ମିଆଁଦ୍‌ ଲାଉକାରେ ଦୁବ୍‌ୟାନାଏ ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ଦରେୟା ଗେନାରେ ତିଙ୍ଗୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ଇନିଃ ଇନ୍‌କୁକେ ଜନ୍‌କା କାଜିତେ ପୁରାଃ କାଜି ଉଦୁବ୍‌କେଦ୍‌କଆ । “ମୁସିଙ୍ଗ୍‌ହୁଲାଙ୍ଗ୍‌ ମିଆଁଦ୍‌ ହିତାହେର୍‌ନିଃ ହିତା ହେର୍‌ ନାଗେନ୍ତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ଇନିଃ ହିତା ହେର୍‌ତାନ୍‌ ଇମ୍‌ତା, ଚିମିନ୍‌ ହିତା ହରା ଗେନାରେ ଉୟୁଃୟାନା ଆଡଃ ଚେଣେଁକ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ ଏନାକ ହାଲାଙ୍ଗ୍‌ ଜମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ଚିମିନ୍‌ ହିତାଦ ହାସା ପୁରାଃ ବାନଃ ଦିରି ଅତେରେ ଉୟୁଃୟାନା, ହାସା ଏତାଙ୍ଗ୍‌ଗି ତାଇକାନ୍‌ ହରାତେ ଅମନ୍‌ ଧାବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ମେନ୍‌ଦ ସିଙ୍ଗିରାଃ ରାଁପ୍‌ତେ ଏନ୍‌ ଅମନ୍‌ତେୟାଃକ ସବେନ୍‌ ରହଡ଼୍‌ଗସୟାନା, ଚିୟାଃଚି ଏନାଏତେ ଭିତାର୍‌ତେ ପୁରାଃ କା ରେହେଦାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଚିମିନ୍‌ ହିତା ଜାନୁମ୍‌ ଚୁପାଦ୍‌କ ଥାଲାରେ ଉୟୁଃୟାନା, ଏନାକକେ ଜାନୁମ୍‌ ହାରାତପାକେଦାଏ, ଆଡଃ ଏନାକ କା ଜ ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ମେନ୍‌ଦ ଚିମିନ୍‌ ହିତା ବୁଗିନ୍‌ ଅତେରେ ଉୟୁଃୟାନା, ଆଡଃ ଏନା ଅମନ୍‌ ହାରାୟାନ୍ତେ ଆଦ୍‌କା ଜ'ୟାନା, ଚିମିନ୍‌ ମିଦ୍‌ଶାଅଗୁନା, ଚିମିନ୍‌ ଷାଠେ, ଆଡଃ ଚିମିନ୍‌ ତିରିଶ୍‌ଗୁନା, ଜ'ୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ଆଡଃ ୟୀଶୁ ମେନ୍‌କେଦାଏ, “ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଲୁତୁର୍ ମେନାଃନିଃ ଆୟୁମେକାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ଏନ୍ତେ ଚେଲାକ ୟୀଶୁତାଃ ହିଜୁଃକେଦ୍‌ତେ କୁଲିକିୟାକ, “ଚିକାନାଙ୍ଗ୍‌ ହଡ଼କକେ ଜନ୍‌କା କାଜିତେମ୍‌ ଇତୁକତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆ, “ଆପେଦ ସିର୍ମା ରାଇଜ୍‌ରେୟାଃ ଉକୁଆକାନ୍‌ କାଜିରାଃ ମୁଣ୍ଡି ସାରି ନାଗେନ୍ତେ ସେଣାଁଁ ଏମାକାନା, ମେନ୍‌ଦ ବାହାରିରେନ୍‌ ଏଟାଃକକେ କାଜିରାଃ ମୁଣ୍ଡି ସାରି ନାଗେନ୍ତେ ସେଣାଁଁ କା ଏମାକାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ଜେତାଏତାଃରେ ମେନାଃନିଃକେ ଏମଃଆ, ଆଡଃ ଇନିୟାଃ ପୁରାଃଗି ହବାଅଆଃ, ମେନ୍‌ଦ ଜେତାଏତାଃରେ ବାନଃଆ, ଇନିଃତାଃଏତେ ଅକ୍‌ନାଃ ମେନାଃ ଏନାହଗି ଇଦିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ଇନ୍‌କୁକେ ଆଇଙ୍ଗ୍‌ ଜନ୍‌କା କାଜିତେ ଇତୁକ ତାନାଇଙ୍ଗ୍‌, ଚିୟାଃଚି ଇନ୍‌କୁ ନେଲ୍‌ଦକ ନେଲେୟା ମେନ୍‌ଦ କାକ ନେଲେୟା, ଆୟୁମ୍‌ଦକ ଆୟୁମେୟା ମେନ୍‌ଦ କାକ ଆଟ୍‌କାର୍‌ଉରୁମେୟାଁ । ");
INSERT INTO unx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ଇନ୍‌କୁରେ ଯିଶାୟ ନାବୀଆଃ ଆୟାର୍‌କାଜି ପୁରାଅଃତାନା, “‘ନେ ହଡ଼କ ଆୟୁମ୍‌ଦକ ଆୟୁମେୟା ମେନ୍‌ଦ କାକ ଆଟ୍‌କାର୍‌ଉରୁମେୟାଁ; ଆଡଃ ନେଲ୍‌ଦକ ନେଲେୟା ମେନ୍‌ଦ କାକ ନେଲ୍‌ଉରୁମେୟାଁ, ");
INSERT INTO unx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ଚିୟାଃଚି ନେ ହଡ଼କଆଃ ମନ୍‌ କେଟେଦ୍‌ଉତାର୍‌ୟାନା, ଇନ୍‌କୁଆଃ ଲୁତୁର୍‌ ମେନାଃରେୟ କାକ ଆୟୁମେୟା ଆଡଃ ଇନ୍‌କୁଆଃ ମେଦ୍‌ ମେନାଃରେୟ କାକ ନେଲେୟା । କା'ରେଦ, ଇନ୍‌କୁ ଆକଆଃ ମେଦ୍‌ତେକ ନେଲେତେୟାଃ, ଆଡଃ ଆକଆଃ ଲୁତୁର୍‌ତେକ ଆୟୁମେତେୟାଃ, ଆଡଃ ଆକଆଃ ମନ୍‌ତେକ ଆଟ୍‌କାର୍‌ଉରୁମେତେୟାଃ, ଆଡଃ ଇନ୍‌କୁ ଆଇଁୟାଃତାଃତେ ରୁହାଡ଼୍‌ତେୟାଃକ, ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେଇଙ୍ଗ୍‌ ବୁଗିକତେୟାଃ ।’” ");
INSERT INTO unx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ମେନ୍‌ଦ ଆପେ ଚିମିନ୍‌ ସୁକୁତାନ୍‌ଗିୟାଃପେ, ଚିୟାଃଚି ଆପେ ନେଲ୍‌ ଦାଡ଼ିତାନାପେ, ଆଡଃ ଆୟୁମ୍‌ ଦାଡ଼ିତାନାପେ । ");
INSERT INTO unx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ଆଇଙ୍ଗ୍‌ଦ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେ ନେଲ୍‌ତାନ୍‌ତେୟାଃ ପୁରାଃ ନାବୀକ ଆଡଃ ଧାର୍‌ମାନ୍‌ ହଡ଼କ ନେନେଲ୍‌ ସାନାଙ୍ଗ୍‌କେଦ୍‌କଆ ମେନ୍‌ଦ କାକ ନେଲ୍‌କେଦା ଆଡଃ ଆପେ ଆୟୁମ୍‌କେଦ୍‌ତେୟାଃ ଇନ୍‌କୁକେ ଆୟୁମ୍‌ ସାନାଙ୍ଗ୍‌କେଦ୍‌କଆ ମେନ୍‌ଦ କାକ ଆୟୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ଆପେ ନାହାଁଃ ହିତାହେର୍‌ନିଆଃ ଜନ୍‌କା କାଜିରେୟାଃ ମୁଣ୍ଡି ଆୟୁମେପେ । ");
INSERT INTO unx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ଜେତାଏ ହଡ଼ ସିର୍ମା ରାଇଜ୍‌ରେୟାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଏନା କାଏ ଆଟ୍‌କାର୍‍ଉରୁମେରେ, ଏନ୍‌ ଏତ୍‌କାନ୍‌ନିଃ ହିଜୁଃଆଏ ଆଡଃ ଇନିୟାଃ ମନ୍‌ସୁରୁଦ୍‌ରେ ହେରାକାନ୍‌ତେୟାଃ ରେଃକ୍‌ ଇଦିୟାଏ, ଇନିଃ ହରା ଗେନାରେ ହେରାକାନ୍‌ ହିତା ଲେକାନ୍‌ନିଃ ତାନିଃ । ହରା ଗେନାରେ ଉୟୁଗାକାନ୍‌ ହିତାରାଃ ମୁଣ୍ଡି ନେଆଁଁ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ଜେତାଏ କାଜି ଆୟୁମାଃଏ ଆଡଃ ରାସ୍‌କାତେ ତେଲାଦାବେଆ, ଇନିଃ ଦିରି ଅତେରେ ଉୟୁଗାକାନ୍‌ ହିତା ଲେକାନ୍‌ନିଃ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ମେନ୍‌ଦ ଇନିୟାଃ ମନ୍‌ରେ କାଏ ରେହେଦ୍‌ୟାନ୍‌ତେ ହୁଡିଙ୍ଗ୍‌ ଦିପିଲିଗି ତାଇନାଏ ଆଡଃ କାଜି ନାଗେନ୍ତେ ସାସାତି ଚାଏ ସିଗିଦ୍‌ ହିଜୁଃୟାନ୍‌ରେ ଇନିଃ ତହଦ୍‍ଦାବଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ଜେତାଏ କାଜି ଆୟୁମାଃଏ ମେନ୍‌ଦ ସାଂସାର୍‌ରେୟାଃ ଉଡ଼ୁଃ ଆଡଃ ପୁରାଃ ମେନାଃତେୟାଃରାଃ ହାୟା, କାନାଜିକେ ହାରାତପାଏୟା ଆଡଃ ଇନିଃ କାଏ ଜଅଃ'ଆ, ଇନିଃ ଜାନୁମ୍‌ ଥାଲାରେ ଉୟୁଗାକାନ୍‌ ହିତା ଲେକାନ୍‌ନିଃ ତାନିଃ, ଇନିଃ ଜେତାନ୍‌ ଜ କାଏ ଜଅଃ'ଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ଆଡଃ ଜେତାଏ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଆଟ୍‌କାର୍‍ଉରୁମ୍‌ନିଃ ବୁଗିନ୍‌ ଅତେରେ ଉୟୁଗାକାନ୍‌ ହିତା ଲେକାନ୍‌ନିଃ ତାନିଃ, ଇନିଃ ବୁଗିନ୍‌ ସାର୍‌ତିଗି ଜଅଃ'ଆ ଆଡଃ ମିଦ୍‌ଶାଅ ଗୁଣ୍‌ ଆଦ୍‌କା, ଷାଠେ ଗୁଣ୍‌ ଆଡଃ ତିରିଶ୍‌ ଗୁଣ୍‌ ଜଅଃ'ଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଆଡଃ ଇନିଃ ଏଟାଃ ଜନ୍‌କା କାଜି କାଜିୟାଦ୍‍କଆଏ, “ସିର୍ମା ରାଇଜ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ଲେକା ତାନାଃ, ଇନିଃ ଆୟାଃ ଅତେରେ ବୁଗିନ୍‌ ହିତାଏ ହେର୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ମେନ୍‌ଦ ହଡ଼କ ଦୁଡ଼ୁମାକାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଇନିୟାଃ ବାଇରି ହିଜୁଃକେଦ୍‌ତେ ଗହମ୍‌ ହେରାକାନ୍‌ ଅତେରେ ଟୁଲିତାସାଦ୍‌ ଜାଙ୍ଗ୍‌ ହେର୍‌କେଦ୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ଗହମ୍‌ ଅମନ୍‌ୟାନା ଆଡଃ ଗେଲେୟାନ୍‌ରେ ଟୁଲିତାସାଦ୍‌ ନେଲ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ଅଡ଼ାଃରେନ୍‌ ଗୁସିୟାଁ ଦାସିକ ହିଜୁଃଲେନ୍ତେ କାଜିକିୟାକ, ‘ହେ ଗମ୍‌କେ, ଚିୟାଃ ଆମ୍‌ ଆମାଃ ଅତେରେ ବୁଗିନ୍‌ ହିତା କାମ୍‌ ହେର୍‌ଲେଦା, ଏନ୍‌ ଟୁଲିତାସାଦ୍‌ ଅକ୍‌ତାଃଏତେ ହିଜୁଆକାନା ?’ ");
INSERT INTO unx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ଇନିଃ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, ‘ମିଆଁଦ୍‌ ବାଇରି ନେଆଁଁ ରିକାକାଦାଏ ।’ ଏନ୍ତେ ଦାସିକ କୁଲିକିୟାକ, ‘ଆଲେ ସେନ୍‌କେଦ୍‌ତେ ଏନାକେଲେ ହେଡ଼େଦ୍ ହୁରାଙ୍ଗ୍‌ୟେଁଆ ମେନ୍ତେମ୍‌ ସାନାଙ୍ଗ୍‌ତାନାଚି ?’ ");
INSERT INTO unx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ଇନିଃ ‘ବାନଃଗି’ ମେତାଦ୍‌କଆଏ, ‘ଚିୟାଃଚି ଟୁଲିତାସାଦ୍‌ ହେଡ଼େଦ୍‍ତାନ୍‌ ଇମ୍‌ତା ଗହମ୍‌ହଁ ଏନାଲଃ ହେଡ଼େଦ୍‌ମେସାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ଇରୋଃ ଦିପିଲି ଜାକେଦ୍‌ ଗହମ୍‌ ଆଡଃ ଟୁଲିତାସାଦ୍‌ ବାର୍‌ନାଃକେ ମିଦ୍‌ତେ ହାରାଇଚିପେ ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇରୋଃ ଦିପିଲିରେ ଇରୋଃକକେ କାଜିକଆଇଙ୍ଗ୍‌, ସିଦାତେ ଟୁଲିତାସାଦ୍‌ ହୁଣ୍ଡିପେ ଆଡଃ ଉରୁବେ ନାଗେନ୍ତେ ବିଡ଼ା ତଲେପେ ଏନ୍ତେ ଗହମ୍‌କେ ଆଇଁୟାଃ ଭାଣ୍ଡାର୍‌ ଅଡ଼ାଃରେ ଦହଏପେ ।’” ");
INSERT INTO unx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ୟୀଶୁ ଆଡଃମିଆଁଦ୍‌ ଜନ୍‌କା କାଜି ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆ, “ସିର୍ମା ରାଇଜ୍‌ ମିଆଁଦ୍‌ ମାନିଜାଙ୍ଗ୍‌ ଲେକା ଏନା ଜେତା ହଡ଼ ଇଦିକେଦ୍‌ତେ ଆୟାଃ ଅତେରେ ହେର୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ଏନାଦ ସବେନ୍‌ ହିତାଏତେ ହୁଡିଙ୍ଗ୍‌ଆଁ ମେନ୍‌ଦ ଏନା ହାରାୟାନ୍‍ଚି ସବେନ୍‌ ଆଡ଼ାଃଏତେ ମାରାଙ୍ଗ୍‌ଅଃଆ ଏନ୍ତେ ଦାରୁ ହବାଅଆଃ, ଆଡଃ ଏନାରେୟାଃ କତରେ ସିର୍ମାରେନ୍‌ ଚେଣେଁକ ଥକାୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ୟୀଶୁ ଆଡଃମିଆଁଦ୍‌ ଜନ୍‌କା କାଜି ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆ, “ସିର୍ମା ରାଇଜ୍‌ ମିଆଁଦ୍‌ ରାନୁ ଲେକାଃ, ଏନାକେ ଜେତାଏ କୁଡ଼ି ଆଉକେଦ୍‌ତେ ଆପି କେଜି ମାଇଦାରେ ଏନା ଆଉରି ରାନୁଚାବାଅଃ ଜାକେଦ୍‌ ସିପୁଦ୍‌କେଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ନେ ସବେନାଃ, ୟୀଶୁ ଜନ୍‌କା କାଜିତେ ଗାଦେଲ୍‌ ହଡ଼କକେ କାଜିୟାଦ୍‍କଆ ଆଡଃ ବେଗାର୍‌ ଜନ୍‌କା କାଜିତେ ଇନିଃ ଇନ୍‌କୁକେ ଜେତ୍‌ନାଃ କାଏ କାଜିୟାଦ୍‍କଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ନାବୀଆଃ ନେ କାଜି ନେ ଲେକାତେ ପୁରାୟାନା, “ଇନ୍‌କୁଲଃ ଜାଗାର୍‌ ଇମ୍‌ତା ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ଜନ୍‌କା କାଜିତେ କାଜିକଆଇଙ୍ଗ୍‌; ଅତେଦିଶୁମ୍‌ରେୟାଃ ମୁନୁରାଃ ସିଦାଏତେ ଉକୁଆକାନ୍‌ କାଜିକଇଙ୍ଗ୍‌ ଉଦୁବେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ଏନ୍ତେ ୟୀଶୁ ଗାଦେଲ୍‌ ହଡ଼କକେ ବାଗିକେଦ୍‌ତେ ଅଡ଼ାଃତେ ସେନଃୟାନା ଆଡଃ ଇନିୟାଃ ଚେଲାକ ଇନିଃତାଃତେ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟାକ, “ଆମ୍‌ ଅତେରେୟାଃ ଟୁଲିତାସାଦ୍‌ରେୟାଃ ଜନ୍‌କା କାଜିରେୟାଃ ମୁଣ୍ଡି ଉଦୁବାଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ବୁଗିନ୍‌ ହିତା ହେର୍‌ନିଃ ମାନୱାହନ୍‌ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ନେ ପିଡ଼ି, ଅତେଦିଶୁମ୍‌ ତାନାଃ ଆଡଃ ବୁଗିନ୍‌ ହିତା, ସିର୍ମା ରାଇଜ୍‌ରେନ୍‌ ହଡ଼କ ତାନ୍‌କ ଆଡଃ ଟୁଲିତାସାଦ୍‌ ଜାଙ୍ଗ୍‌, ଏତ୍‌କାନ୍‌ ଆତ୍ମାରାଃ ହଡ଼କ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ଆଡଃ ଏନା ହେର୍‌କେଦ୍‍ ବାଇରି, ସାଏତାନ୍‌ ତାନିଃ, ଆଡଃ ଇରୋଃ ଦିପିଲି ଅତେଦିଶୁମ୍‌ରେୟାଃ ଟୁଣ୍ଡୁତାନାଃ ଆଡଃ ଇରୋଃକ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ଅତେଦିଶୁମ୍‌ରେୟାଃ ଟୁଣ୍ଡୁରେ ଏନ୍‌ ଟୁଲିତାସାଦ୍‌କ ହୁଣ୍ଡିକେଦ୍‌ତେ ସେଙ୍ଗେଲ୍‌ରେ ଉରୁବଃ ଲେକାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ମାନୱାହନ୍‌ ଆୟାଃ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କକେ କୁଲ୍‌କଆଏ ଆଡଃ ଇନ୍‌କୁ ଇନିୟାଃ ରାଇଜ୍‌ରେ ସବେନ୍‌ ତହଦଃ ଲେକାନାଃ ତାଇନ୍‌ତେୟାଃ ଆଡଃ ଏତ୍‌କାନାଃ କାମିତାନ୍‌କକେ ହୁଣ୍ଡିକଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ଇନ୍‌କୁ ସେଙ୍ଗେଲ୍‌ ହୁୱାଙ୍ଗ୍‌ରେକ ହାଁଣବଆଃ, ଏନ୍ତାଃରେ ରାନାଆଃ ଆଡଃ ଡାଟା ହାବ୍‌ ରିଡିଦଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ଏନ୍ତେ ଧାର୍‌ମାନ୍‌ ହଡ଼କ ଆକଆଃ ସିର୍ମାରେନ୍‌ ଆପୁଆଃ ରାଇଜ୍‌ରେ ସିଙ୍ଗିଲେକାକ ନେଲଆଃ । ଲୁତୁର୍‌ ମେନାଃନିଃ ବୁଗିଲେକା ଆୟୁମେକାଏ । ");
INSERT INTO unx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ସିର୍ମା ରାଇଜ୍‌ ଅତେରେ ତପାକାନ୍‌ ଖୁର୍ଜି ଲେକାନାଃ ତାନାଃ, ମିଆଁଦ୍‌ ହଡ଼ ନାମ୍‌କେଦ୍‌ତେ ଆଡଃମିସା ଅତେରେ ଉକୁକେଦାଏ ଏନ୍ତେ ସୁକୁଜୀଉତେ ସେନଃୟାନା ଆଡଃ ଆୟାଃ ସବେନାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ଏନ୍‌ ଅତେକେ କିରିଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ଆଡଃଗି ସିର୍ମା ରାଇଜ୍‌ ବୁଗିନ୍‌ ବୁଗିନ୍‌ ମୋତି ଦାଣାଁଁତାନ୍‌ ମିଆଁଦ୍‌ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ତାନ୍‌ ହଡ଼ଲେକାଃ । ");
INSERT INTO unx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ଆଡଃ ଇନିଃ ମିଆଁଦ୍‌ ପୁରାଃ ଗନଙ୍ଗ୍‌ଆଁନ୍‌ ମୋତି ନାମ୍‌କେଦ୍‌ତେ ସେନଃୟାନାଏ ଆଡଃ ଆୟାଃ ସବେନାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ଏନାକେ କିରିଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ଆଡଃଗି ସିର୍ମା ରାଇଜ୍‌ ମିଆଁଦ୍‌ ଜାଲୋମ୍‌ ଲେକାଃ, ଚିମିନ୍‌ ହାକୁସାବ୍‌କ ଆକଆଃ ଜାଲୋମ୍‌କେ ଦରେୟାରେ ହୁରାଙ୍ଗ୍‌କେଦାକ ଆଡଃ ଏନାରେ ସବେନ୍‌ ଲେକାନ୍‌ ହାକୁକ ଜାଲୋମ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ଏନା ପେରେଃୟାନ୍‌ଚି ହଡ଼କ ଗେନାତେକ ଥାଇଜ୍‌ ଅଡଙ୍ଗ୍‌କେଦା ଆଡଃ ଦୁବ୍‌ୟାନ୍ତେ ବୁଗିନ୍‌ ହାକୁକକେ ଟୁଙ୍କିରେକ ସାଲାକେଦ୍‌କଆ ମେନ୍‌ଦ ଏତ୍‍କାନ୍‌କକେ ଏଣ୍ଡାଃକେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଅତେଦିଶୁମ୍‌ରେୟାଃ ଟୁଣ୍ଡୁରେୟଗି ନେକାଅଃଆ । ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କ ଅଡଙ୍ଗ୍‌ଅଃଆ ଆଡଃ ଧାର୍‌ମାନ୍‌କଆଃ ଥାଲାଏତେ ଏତ୍‍କାନ୍‌କକେ ଆତମ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ଆଡଃ ଇନ୍‌କୁକେ ସେଙ୍ଗେଲ୍‌ ହୁୱାଙ୍ଗ୍‌ରେକ ହାଁଣବ୍‌କଆ, ଏନ୍ତାଃରେ ରାନାଆଃ ଆଡଃ ଡାଟା ରିଡିଦଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“ୟୀଶୁ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆ, ଚିୟାଃ ଆପେ ନେ ସବେନାଃପେ ଆଟ୍‌କାର୍‌ଉରୁମ୍‌କେଦା ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ହେଗି, ଆଟ୍‌କାର୍‍ଉରୁମ୍‌କେଦାଲେ ।” ");
INSERT INTO unx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଏନା ନାଗେନ୍ତେ ସିର୍ମା ରାଇଜ୍‌ରେୟାଃ ଚେଲାକାନ୍‌ ମିଆଁଦ୍‌ ଆଇନ୍‌ ଇତୁନିଃ, ମିଆଁଦ୍‌ ଅଡ଼ାଃ ଗମ୍‌କେ ଲେକାନ୍‌ନିଃ ତାନିଃ । ଇନିଃ ଆୟାଃ ଭାଣ୍ଡାର୍‌ଅଡ଼ାଃଏତେ ନାୱା ଆଡଃ ମାରିତେୟାଃ ଅଡଙ୍ଗ୍‌ୟେଁଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ୟୀଶୁ ନେ ଜନ୍‌କା କାଜି ଚାବାକେଦ୍‍ଚି ଏନ୍ତାଃଏତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ଆଡଃ ଆୟାଃ ଆପୁତେୟାଃ ସାହାର୍‌ତେ ତେବାଃୟାନ୍‌ଚି ଇନ୍‌କୁଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ଇନ୍‌କୁକେ ଇତୁକେଦ୍‍କଆ ଆଡଃ ଇନ୍‌କୁ ଆକ୍‌ଦାନ୍ଦାଅୟାନ୍ତେ, “ଇନିଃ ଅକ୍‌ତାଃଏତେ ନେ ସେଣାଁଁ ଆଡଃ ପେଡ଼େୟାନ୍‌ କାମିକରେୟାଃ ପେଡ଼େଃ ନାମାକାଦାଏ ?” ମେନ୍ତେକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“ଚିୟାଃ ନିଃ ଏନ୍‌ ବାଢ଼ାଇଆଃ ହନ୍‌ କା'ଚି ତାନିଃ ? ଚିୟାଃ ଇନିୟାଃ ଏଙ୍ଗାରାଃ ନୁତୁମ୍‌ ମାରିୟାମ୍‌ କା'ଚି ତାନାଃ ? ଯାକୁବ୍‌, ଯୋଷେଫ୍‌, ଶିମୋନ୍‌ ଆଡଃ ଯିହୁଦା ନେ ସବେନ୍‌କ ଆୟାଃ ହାଗାକ କା'ଚି ତାନ୍‌କ ? ");
INSERT INTO unx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ଆଡଃ ଇନିୟାଃ ମିଶିକ ଆବୁଲଃଚି ବାଙ୍ଗ୍‌କଆ ? ନିଃ ଏନ୍‌ ସେଣାଁଁ ଆଡଃ ପେଡ଼େଃ ଅକ୍‌ତାଃଏତେ ନାମାକାଦା ?” ମେନ୍ତେକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ଏନାତେ ଇନ୍‌କୁ ଇନିଃକେ ହିଲାଙ୍ଗ୍‌କିୟାକ । ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ନାବୀ ଆୟାଃ ଦିଶୁମ୍‌ ଆଡଃ ଆୟାଃ ଅଡ଼ାଃ ବାଗିକେଦ୍‌ତେ ଏଟାଃ ସବେନ୍‌ତାଃରେ ମାଇନାଏ ନାମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ଚିୟାଃଚି ଇନ୍‌କୁ ଇନିଃକେ କାକ ବିଶ୍ୱାସ୍‌କିଃ ନାଗେନ୍ତେ ଇନିଃ ଏନ୍ତାଃରେ ପୁରାଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ କାଏ କାମିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ଏନ୍‌ ଦିପିଲିରେ ହେରୋଦ୍‌ ଗାଲିଲ୍‌ରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ତାଇକେନାଏ ଆଡଃ ୟୀଶୁଆଃ ବିଷାଏରେ ଆୟୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ଆଡଃ ଇନିଃ ଆୟାଃ କାମିତାନ୍‌କକେ ମେତାଦ୍‌କଆ, “ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ଗଜାକାନ୍‌ଏତେ ଜୀଉବିରିଦାକାନାଏ, ଏନା ମେନ୍ତେଗି ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ଇନିୟାଃ ହରାତେ ହବାଅଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ହେରୋଦ୍‌ ଆୟାଃ ହାଗାତେ ଫିଲିପ୍‌ଆଃ କୁଡ଼ି ହେରୋଦିୟା ନାଗେନ୍ତେ ଯୋହାନ୍‌କେ ସାବ୍‌କିତେ ତଲ୍‌କିୟାଏ ଆଡଃ ଜେହେଲ୍‌କାଇ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ଚିୟାଃଚି ଯୋହାନ୍‌ ହେରୋଦ୍‌କେ କାଜିକାଇ ତାଇକେନା, “ଆମ୍‌ ହେରୋଦିୟାକେ କୁଡ଼ି ଲେକା ଦହକାଇ ତାଇକେନାମ୍‌ ଏନା ଆଇନ୍‌ ଲେକାତେ କା ଠାଉକାନ୍‌ତେୟାଃ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ଏନାତେ ଇନିଃ ଯୋହାନ୍‌କେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ ତାଇକେନାଏ, ମେନ୍‌ଦ ଇନିଃ ଯିହୁଦୀ ହଡ଼କକେ ବରକେଦ୍‌କଆ, ଚିୟାଃଚି ଇନ୍‌କୁଦ ଯୋହାନ୍‌କେ ମିଆଁଦ୍‌ ନାବୀ ତାନିଃ ମେନ୍ତେକ ଆଟ୍‌କାରି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ହେରୋଦ୍‌ଆଃ ଜାନାମ୍‌ ହୁଲାଙ୍ଗ୍‌ ସେଟେର୍‌ୟାନ୍‌ରେ, ହେରୋଦିୟାଃ ହନ୍ତେକୁଡ଼ି କେଡ଼ାକାନ୍‌ ହଡ଼କଆଃ ଥାଲାରେ ସୁସୁନ୍‌କେଦାଏ ଆଡଃ ହେରୋଦ୍‌ ପୁରାଃଗି ସୁକୁୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ଆଡଃ ହେରୋଦ୍‌ ଇନିଃକେ କିରିୟାତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ଆମ୍‌ ଆସିଙ୍ଗ୍‌ତେୟାଃ ସବେନାଃଇଙ୍ଗ୍‌ ଏମାମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ଆଡଃ ଇନିଃ, ଆୟାଃ ଏଙ୍ଗାତେ ଆଚୁକାଇ ଲେକା ଆସିକିୟା, “ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ଆଃ ବହଃ ନେ ଥାଡ଼ିରେ ଏମାଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ଏନ୍ତେ ରାଜା ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନାଏ ମେନ୍‌ଦ ଇନିଃ ନେଅଁତାକାନ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ କିରିୟାକାଦ୍‌ ହରାତେ ଏମାଇପେ ମେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ଆଡଃ ଇନିଃ ଜେହେଲାକାନ୍‌ ଯୋହାନ୍‌ଆଃ ବହଃ ମାଆଃ ଆଉ ନାଙ୍ଗ୍‌ ହଡ଼କକେ କୁଲ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ଆଡଃ ଇନିୟାଃ ବହଃ ମିଆଁଦ୍‌ ଥାଡ଼ିରେକ ଆଉକେଦା ଆଡଃ ହନ୍ତେକୁଡ଼ିକେକ ଏମ୍‌କିୟା ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଏଙ୍ଗାତେତାଃତେ ଇଦିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ଯୋହାନ୍‌ଆଃ ଚେଲାକ ହିଜୁଃକେଦ୍‌ତେ ଆୟାଃ ହଡ଼୍‌ମକେ ଇଦିକେଦ୍‌ତେ ତପାକେଦାକ ଆଡଃ ସେନଃୟାନ୍ତେ ୟୀଶୁକେକ ଉଦୁବ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ୟୀଶୁ ଯୋହାନ୍‌ଆଃ ବିଷାଏ ଆୟୁମ୍‌କେଦ୍‌ତେ ଏନ୍ତାଃ ବାଗିକେଦ୍‌ତେ ଲାଉକାରେ ସିଃସଏଃ ଠାୟାଦ୍‌ତେ ଏସ୍‌କାର୍‌ଗି ସେନଃୟାନା । ଗାଦେଲ୍‌ ହଡ଼କ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆକଆଃ ସାହାର୍‌କଏତେ ସେସେନ୍‌ତେଗି ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ଇନିଃ ଲାଉକାଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ଲଃ ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌କଆ ଆଡଃ ଆୟାଃ ମନ୍‌ସୁରୁଦ୍‌ ଲିବୁଇତେ ବିଲ୍‌କାଅୟାନା । ଇନିଃ ପୁରାଃ ହାସୁତାନ୍‌କକେ ବୁଗିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ଆଡଃ ସିଙ୍ଗି ହାସୁରଃତାନ୍‌ରେ, ୟୀଶୁଆଃ ଚେଲାକ ଆୟାଃତାଃ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟାକ, “ନେ ଠାୟାଦ୍‍ଦ ସିଃସଏଃଗିୟା ଆଡଃ ସିଙ୍ଗି ହାସୁରଃତାନା, ଏନାତେ ମାର୍‌ ଗାଦେଲ୍‌ ହଡ଼କକେ କୁଲ୍‌ତାକମେ, ଆଡଃ ଇନ୍‌କୁ ହାତୁ ସେନ୍‌କେଦ୍‌ତେ ଆକଆଃ ନାଙ୍ଗ୍‌ ଜମେୟାଃଁକ କିରିଙ୍ଗ୍‌ୟେଁକା ।” ");
INSERT INTO unx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଇନ୍‌କୁ ଚିନାଃମେନ୍ତେକ ସେନଆଃ ? ଆପେଗି ଇନ୍‌କୁକେ ଜମେୟାଃଁ ଏମାକପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ଇନ୍‌କୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ମଣେୟାଁ ହଲଙ୍ଗ୍‌ ଆଡଃ ବାରିଆ ହାକୁ ଏସ୍‌କାର୍‌ ଆଲେତାଃରେ ମେନାକଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଏନ୍‌ ସବେନାଃକେ ଆଇଙ୍ଗ୍‌ତାଃତେ ଆଉୱେପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ତାସାଦ୍‌ ଚେତାନ୍‌ରେ ଦୁବ୍‌କପେ ମେନ୍ତେ ଆଚୁକେଦ୍‌କଆ, ଆଡଃ ଏନ୍‌ ମଣେୟାଁ ହଲଙ୍ଗ୍‌ ଆଡଃ ବାରିଆ ହାକୁ ସାବ୍‌କେଦ୍‌ତେ ସିର୍ମାସାଃ ସାଙ୍ଗିଲ୍‌ରାକାବ୍‌ତାନ୍‌ଲଃ ଆଶିଷ୍‌କେଦାଏ ଆଡଃ ହଲଙ୍ଗ୍‌ କେଚାଃକେଦ୍‍ତେ ଚେଲାକକେ ଏମାଦ୍‍କଆଏ, ଆଡଃ ଚେଲାକ ଗାଦେଲ୍‌ ହଡ଼କକେ ହାଟିଙ୍ଗ୍‌ଆଁଁଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ସବେନ୍‌କ ଜମ୍‌କେଦ୍‌ତେ ବି'ୟାନାକ ଆଡଃ ଚେଲାକ ସାରେୟାକାନ୍‌ତେୟାଃ ବାରା ଟୁଙ୍କିକ ହୁଣ୍ଡିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ଜମ୍‌କେଦ୍‌ ହଡ଼କ, କୁଡ଼ିକ ଆଡଃ ହନ୍‌କକେ ବାଗିକେଦ୍‌ତେ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ କଡ଼ାକ ଏସ୍‌କାର୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ଇମ୍‌ତାଗି ୟୀଶୁ ଚେଲାକକେ ଆଚୁକେଦ୍‌କଆ, ଲାଉକାରେ ଦେଏଃପେ ଆଡଃ ହାନ୍‌ ପାରମ୍‌ତେ ସେନ୍‌ ଆୟାରଃପେ, ଇମ୍‌ତାଲଃ ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ବିଦାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ଏନ୍ତେ ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ବିଦାକେଦ୍‌ତେ, ଆଇଃକ୍‌ଗି ବିନ୍ତି ନାଗେନ୍ତେ ବୁରୁତେ ରାକାବ୍‍ୟାନା ଆଡଃ ସିଙ୍ଗିହାସୁର୍‌ତାନ୍‌ରେ ଇନିଃ ଏସ୍‌କାର୍‌ଗି ଏନ୍ତାଃରେ ତାଇନ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ଆଡଃ ଏନ୍‌ ଦିପିଲିରେ ଲାଉକା ଦରେୟା ଖାଇଁଣ୍‌ଏତେ ପୁରାଃ ସାଙ୍ଗିନ୍‌ରେ ଆଲ୍‌ପୁଙ୍ଗ୍‌ତେ ଏକ୍‌ଲାଅଃତାନ୍‌ ତାଇକେନା, ଚିୟାଃଚି ଲାଉକା ସେନଃତାନ୍‌ସାଃଏତେ ହୟ ହିଜୁଃତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ସେତାଃ ନିଦାରେୟାଃ ଉପୁନ୍‌ ଘାଡ଼ି ଇମ୍‌ତାକରେ ୟୀଶୁ ଦରେୟାରେ ସେସେନ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁତାଃତେ ହିଜୁଃତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ଚେଲାକ ଇନିଃକେ ଦରେୟାରେ ସେସେନ୍‌ତାନ୍‌ ନେଲ୍‌କିଃତେକ ବରକେଦା ଆଡଃ “ବଙ୍ଗା ତାନିଃ” ମେନ୍ତେ ବରତେକ କାଉରିକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ମେନ୍‌ଦ ୟୀଶୁ ଇମ୍‌ତାଗି ଇନ୍‌କୁକେ ଜାଗାର୍‌ତାନ୍‌ଲଃ ମେତାଦ୍‌କଆ, “ଜୀଉରେ କେଟେଜେପେ, ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ ଆଲ୍‌ପେ ବରଏୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ଗି ତାନ୍‌ମେରେଦ ଦାଆଃରେ ଆଇଁୟାଃତାଃତେ ହିଜୁଃମେ ମେନ୍ତେ ଆଚୁଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହିଜୁଃମେ ।” ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଲାଉକାଏତେ ଆଡ଼୍‌ଗୁୟାନ୍‌ଚି ଦାଆଃରେ ସେସେନ୍‌କେଦ୍‌ତେ ୟୀଶୁତାଃତେ ସେନଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ମେନ୍‌ଦ ଇନିଃ ହୟ ନେଲ୍‌କେଦ୍‌ତେ ବରକେଦାଏ ଆଡଃ ଇନିଃ ଦାଆଃରେ ଡୁବିଃଗ୍‌ ଏଟେଦଃତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ କାଉରିକେଦାଏ, “ହେ ପ୍ରାଭୁ, ବାଞ୍ଚାଅଇଙ୍ଗ୍‌ମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ୟୀଶୁ ଇମ୍‌ତାଗି ତିଃଇତାୟାଃ ଜିଲିଙ୍ଗ୍‌କେଦ୍‍ତେ ଇନିଃକେ ସାବ୍‍କିୟାଏ ଆଡଃ କାଜିକିୟାଏ, “ଏ ହୁଡିଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ତାନ୍‌ନିଃ ଚିନାଃମେନ୍ତେମ୍‌ ଆଡ଼ାଃଉଡ଼ୁଃକେଦା ?” ");
INSERT INTO unx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ଆଡଃ ଇନ୍‌କିନ୍‌ ଲାଉକାରେ ଦେଏଃୟାନ୍‌ଚି ହୟ ସାଲ୍‌ସାନ୍ତ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ଏନ୍ତେ ଲାଉକାରେ ତାଇକେନ୍‌ ଚେଲାକ ୟୀଶୁକେ ଜହାର୍‌କିଃତେ କାଜିକିୟାକ, “ଆମ୍‌ ସାର୍‌ତିଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ଦରେୟା ପାରମ୍‌କେଦ୍‌ଚି ଗିନେସରେତ୍‌ ନୁତୁମ୍‌ ପାର୍‌ଗାନ୍‌ତେକ ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଏନ୍ତାଃରେନ୍‌ ହଡ଼କ ୟୀଶୁକେ ନେଲ୍ଉରୁମ୍‌କିୟାକ । ଆଡଃ ଇନିଃ ନେତାଃରିୟା ମେନ୍ତେ ସବେନ୍‌ସାଃତେ କାଜିକୁଲ୍‌କେଦାକ ଆଡଃ ହଡ଼କ ସବେନ୍‌ ଦୁକୁହାସୁତାନ୍‌କକେ ଇନିଃତାଃତେ ଆଉକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ଆଡଃ ଇନ୍‌କୁ ବିନ୍ତିକିୟାକ, ଦୁକୁହାସୁତାନ୍‌କ ଆମାଃ ଲିଜାଃରେୟାଃ ଆଚ୍‌ରାକେ ଏସ୍‌କାର୍‌ ଜୁଟିଦ୍‌ ଇଚି ନାଗେନ୍ତେ ଆଚୁକମ୍‌ ଆଡଃ ଜୁଟିଦ୍‌କେଦ୍‍ ସବେନ୍‌କ ବୁଗିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ଏନ୍ତେ ଚିମିନ୍‌ ଫାରୁଶୀକ ଆଡଃ ଯୀରୁଶାଲେମ୍‌ହେତେ ସେଟେରାକାନ୍‍ ଚିମିନ୍‌ ଆଇନ୍‌ ଇତୁକ ୟୀଶୁତାଃତେକ ହିଜୁଃୟାନା ଆଡଃ କୁଲିକିୟାକ, ");
INSERT INTO unx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ଚିନାଃମେନ୍ତେ ଆମାଃ ଚେଲାକ ଆବୁଆଃ ପ୍ରାଚିନ୍‌କଆଃ ରିତିରିୱାଜ୍‌କ କାକ ମାନାତିଙ୍ଗ୍‌ତାନା ? ଇନ୍‌କୁ ଆବୁଆଃ ରିତିରିୱାଜ୍‌ ଲେକାତେ ବୁଗିଲେକା ତିଃଇ କା ଆବୁଙ୍ଗ୍‌ ସିଦାରେକ ଜଜମାଃ !” ");
INSERT INTO unx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆପେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଏମାକାଦ୍‌ ଆନ୍‌ଚୁକେ କା ମାନାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ଚିକାନାଙ୍ଗ୍‌ ଆପେୟାଃ ରିତିରିୱାଜ୍‌କେ ମାନାତିଙ୍ଗ୍‌ ତାନାପେ ? ");
INSERT INTO unx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିୟାକାଦାଏ, ‘ଏଙ୍ଗାମ୍ ଆପୁମ୍‌କିନ୍‌କେ ମାନାତିଙ୍ଗ୍‌କିନ୍‌ମେ,’ ଆଡଃ ‘ଜେତାଏ ଏଙ୍ଗାତେକେ ଚାଏ ଆପୁତେକେ ସାର୍‌ପାଅକିନ୍‌ରେଦ ଇନିଃ ଗଜଃକାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ମେନ୍‌ଦ ଆପେ ସବେନ୍‌କ କାଜିତାନାପେ, ଜେତା ହଡ଼ ଆୟାଃ ଏଙ୍ଗା ଆପୁକିନ୍‌କେ, ଆଇଙ୍ଗ୍‌ତାଃଏତେ ଅକ୍‌ନାଃ ଦେଙ୍ଗାବେନ୍‌ ନାମାକାତେତେୟାଃ, ଏନା ‘ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଦାନ୍‌ ଏମାକାନା’ ମେନ୍ତେ କାଜିତାନ୍‌ଲଃ, ");
INSERT INTO unx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ଇନିଃ ଆୟାଃ ଏଙ୍ଗା ଆପୁକିନ୍‌କେ କାଏ ମାନାତିଙ୍ଗ୍‌ରେୟ ହବାଅଃଆ, ମେନ୍ତେପେ କାଜିତାନା । ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆନ୍‌ଚୁକେ କା ମାନାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ଆପେ ଆପ୍‌ନାଃ ରିତିରିୱାଜ୍‌ରାଃ ଇନିତୁ ଲେକାପେ ସେସେନ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ଆପେ ବେଦାହଡ଼କ ତାନ୍‌ପେ, ଯିଶାୟ ଆପେୟାଃ ବିଷାଏରେ ସାର୍‌ତିଗି ଆୟାର୍‌କାଜି କାଜିକାଦା, ");
INSERT INTO unx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘ନେ ହଡ଼କ ମଚାତେକ ମାଇନିଙ୍ଗ୍‌ତାନା, ମେନ୍‌ଦ ଆକଆଃ ମନ୍‌ ଆଇଙ୍ଗ୍‌ତାଃଏତେ ସାଙ୍ଗିନ୍‌ରେଆ । ");
INSERT INTO unx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ଇନ୍‌କୁ ସାମାଗିକ ସେୱାଇଙ୍ଗ୍‌ତାନା, ଚିୟାଃଚି ହଡ଼କଆଃ ରିତିରିୱାଜ୍‌ରାଃ ଇନିତୁକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଇନିତୁ ତାନାଃ ମେନ୍ତେକ ଇତୁକତାନା !’” ");
INSERT INTO unx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ୟୀଶୁ ଗାଦେଲ୍‌ ହଡ଼କକେ କେଡ଼ାକେଦ୍‌କଆଏ ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଆୟୁମେପେ ଆଡଃ ଆଟ୍‌କାର୍‌ ଉରୁମେପେ । ");
INSERT INTO unx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ଅକ୍‌ନାଃ ହଡ଼ ହନ୍‌ରାଃ ମଚା ଭିତାର୍‌ତେ ବଲଃଆ ଏନା ଇନିଃକେ କାଏ ସତ୍‌ରା ଦାଡ଼ିୟାଇଆ, ମେନ୍‌ଦ ଆୟାଃ ମଚାଏତେ ଅକ୍‌ନାଃ ଅଡଙ୍ଗ୍‌ଅଃଆ ଏନା ଆଇଃକ୍‌କେ ସତ୍‌ରାଇଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ଏନ୍ତେ ୟୀଶୁଆଃ ଚେଲାକ ଇନିଃତାଃ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟାକ, “ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଫାରୁଶୀକ ଖିସ୍‌ୟାନାକ, ଚିୟାଃ ନେଆଁଁମ୍‌ ସାରିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ମେନ୍‌ଦ ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଁୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ କାଏ ରୟାକାଦ୍‌ ଦାରୁ ତୁଦ୍ ଏଣ୍ଡାଗଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ଇନ୍‌କୁକେ ବାଗିତାକୁପେ, ଇନ୍‌କୁଦ ମେଦ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିତାନ୍‌ନିୟାଃ ମେଦ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିତାନ୍‌ ଆଗୁଆଇକ ତାନ୍‌କ, ମେଦ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିନିଃ, ମେଦ୍‌ କା ନେଲ୍‌ଦାଡ଼ିନିଃକେ ଆୟାର୍‌ଇଦିରେଦ ବାରାନ୍‌କିନ୍‌ ଗାଡାରେକିନ୍ ଉୟୁଗଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ନେ ଜନ୍‌କା କାଜିରାଃ ମୁଣ୍ଡି ଚିନାଃ ତାନାଃ ଉଦୁବାଲେମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆପେୟଚି ନାହାଁଃ ଜାକେଦ୍‌ ଡଣ୍ଡଗିୟାପେ । ");
INSERT INTO unx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ଅକ୍‌ନାଃ ମଚା ହରାତେ ଲାହିଦ୍‌ତେ ବଲଃଆ ଆଡଃ ହଡ଼୍‌ମଏତେ ଅଡଙ୍ଗ୍‌ଅଃଆ ନେୟାଁ ଚିୟାଃ କାପେ ଆଟ୍‌କାରେତାନା ? ");
INSERT INTO unx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ଜେତାଏ ହଡ଼ଆଃ ମଚାହରା ଅକ୍‌ନାଃ ଅଡଙ୍ଗ୍‌ଅଃଆ ଏନା ଆୟାଃ ମନ୍‌ରାଃ ବିଚାର୍‌ଏତେ ଅଡଙ୍ଗ୍‌ଅଃଆ, ଏନା ଇନିଃକେ ସତ୍‌ରାଇଆ । ");
INSERT INTO unx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ମନ୍‌ ଭିତାର୍‌ଏତେଗି ଏତ୍‌କାନ୍‌ ଉଡ଼ୁଃ, ହଡ଼ଗଏଃ, ଆପାଙ୍ଗିର୍‌ କାମି, ଆଣ୍‌ଦି ଆପାଙ୍ଗିର୍‌, କୁମ୍ବୁଡ଼ୁ, ହସଡ଼ ଗାୱା, ପାର୍‌ମେଶ୍ୱାର୍‌କେ ନିନ୍ଦାଇଆକ । ");
INSERT INTO unx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ନେ ସବେନାଃତେଗି ହଡ଼କେ ସତ୍‌ରାଇଆଏ, ମେନ୍‌ଦ ରିତିରିୱାଜ୍‌ ଲେକାତେ ତିଃଇ ବେଗାର୍‌ ଆବୁଙ୍ଗ୍‌କେଦ୍‌ତେ ଜମେତେୟାଃତେ ହଡ଼କେ କାଏ ସତ୍‌ରାଇଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ୟୀଶୁ ଏନ୍‌ ଠାୟାଦ୍‌ ବାଗିକେଦ୍‌ତେ ସୋର୍‌ ଆଡଃ ସିଦୋନ୍‌ ପାର୍‌ଗାନ୍‌ରେୟାଃ ସାହାର୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଆଡଃ ନେଲେପେ କିନାନ୍‌ରେନ୍ ମିଆଁଦ୍‌ ସାଅଁସାର୍‌ କୁଡ଼ି ଏନ୍‌ ଦିଶୁମ୍ଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ହାକାଅକିୟାଏ, “ହେ ଗମ୍‌କେ, ଦାଉଦ୍‌ଆଃ ହନ୍‌ ଲିବୁଆଇଙ୍ଗ୍‌ମେ, ହନିଙ୍ଗ୍‌କୁଡ଼ି, ବଙ୍ଗା ଏସେର୍‌କାନ୍‌ ହରାତେ ପୁରାଃଗି ହାସୁତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ମେନ୍‌ଦ ଇନିଃ ଜେତ୍‌ନାଃ କାଏ କାଜିରୁହାଡ଼୍‌କିୟା ଆଡଃ ଇନିୟାଃ ଚେଲାକ ବିନ୍ତିକିଃତେ କାଜିକିୟାକ, “ଇନିଃକେ କୁଲ୍‌ତାଇମେ, ଚିୟାଃଚି ଇନିଃଦ ପୁରାଃ ରାଆଃତାନ୍‌ଲଃ ଆବୁକେ ଅତଙ୍ଗ୍‌ବୁତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ମେନ୍‌ଦ ଇନିଃ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ଆଦାକାନ୍‌ ମିଣ୍ଡିକତାଃତେ ଏସ୍‌କାର୍‌ କୁଲାକାନାଇଙ୍ଗ୍‌, ଏଟାଃକତାଃତେଦ କାହାଗି ।” ");
INSERT INTO unx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ମେନ୍‌ଦ ଏନ୍‌କୁଡ଼ି ନାଡ଼େଃୟାନ୍‌ଚି ଇନିୟାଃ ଆୟାର୍‌ରେ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ କାଜିକିୟାଏ, “ହେ ଗମ୍‌କେ, ଦେଙ୍ଗାଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ଏନ୍ତେ ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହନ୍‌କଆଃ ଜମେୟାଃଁ ରେଃକ୍‌କେଦ୍‌ତେ ସେତାକଆଃ ଆୟାର୍‌ରେ ହୁଦ୍‌ମାତେୟାଃ କା ବୁଗିନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ସାଅଁସାର୍‌ କୁଡ଼ି କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେଗି ପ୍ରାଭୁ, ନେଆଁଁ ସାର୍‌ତି କାଜିତାନାଃ, ମେନ୍‌ଦ ସେତାକହଗି ଆକଆଃ ଗମ୍‌କେଆଃ ମେଜ୍‌ଏତେ ଉୟୁଗାକାନ୍ ହଲଙ୍ଗ୍‌କେଚାଃକ ଜଜମାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ଏନ୍ତେ ୟୀଶୁ କାଜିକିୟାଏ, “ଏ କୁଡ଼ି, ଆମାଃ ବିଶ୍ୱାସ୍‌ ପୁରାଃ ମାରାଙ୍ଗିଆଃ ! ଆମାଃ ମନେଲେକା ହବାଅଃକା ।” ଆଡଃ ଇନିୟାଃ ହନ୍ତେକୁଡ଼ି ଏନ୍‌ ଦିପିଲିରେଗି ବୁଗିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ୟୀଶୁ ଏନ୍ତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ଗାଲିଲ୍‌ ଦରେୟାସାଃତେ ସେଟେର୍‌ୟାନା, ଆଡଃ ବୁରୁତେ ରାକାବ୍‌କେଦ୍‌ତେ ଏନ୍ତାଃରେ ଦୁବ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ଛୁଟା, କାଣାଁ, କେପା, କା ବାଖାଁଣ୍‌ ଦାଡ଼ିତାନ୍‌, ଆଡଃ ଏଟାଃ ହଡ଼କକେ ଆକଆଃଲଃ ଆଉକେଦ୍‌ତେ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା ଆଡଃ ଇନ୍‌କୁକେ ଆୟାଃ କାଟା ସୁବାରେ ଦହକେଦ୍‌କଆକ ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ବୁଗିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଏନ୍‌ଲେକାଗି କା ବାଖାଁଣ୍‌ ଦାଡ଼ିତାନ୍‌କ ବାଖାଁଣ୍‌ ଦାଡ଼ିୟାନା, କାଣାଁକାନ୍‌କ ନେଲ୍‌ ଦାଡ଼ିୟାନା, କେପାକାନ୍‌କ ବୁଗିୟାନା, ଛୁଟାକାନ୍‌କ ସେସେନ୍‌କେଦା, ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ଗାଦେଲ୍‌ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନା ଆଡଃ ଇନ୍‌କୁ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌କେକ ମାରାଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଏନ୍ତେ ୟୀଶୁ ଚେଲାକକେ ଆୟାଃତାଃତେ ହାକାଅକେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, “ନେ ଗାଦେଲ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ଆଇଁୟାଃ ଜୀଉ ବିଲ୍‌କାଅଃତାନା, ଚିୟାଃଚି ଆପି ମାହାଁଏତେ ଆଇଁୟାଃଲଃ ମେନାକଆ, ଆଡଃ ନାହାଁଃ ଇନ୍‌କୁତାଃରେ ଜମେୟାଃଁ ଜେତ୍‌ନାଃ ବାନଃଆ, ଇନ୍‌କୁ ହରାକରେ ଭୁକ୍‌ସୁଲ୍‌କଆଃକ, ଏନାତେ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ବେଗାର୍‌ ଜମ୍‌କେଦ୍‌ତେ କୁଲ୍‌ କାଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ଇନିୟାଃ ଚେଲାକ କାଜିରୁହାଡ଼୍‌କିୟା, “କତାଃଏତେ ନେ ସିଃସଏଃ ଠାୟାଦ୍‌ରେ ନିମିନାଙ୍ଗ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ବିୟଃଗି ଜମେୟାଃଁଲେ ନାମେୟା ?” ");
INSERT INTO unx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ୟୀଶୁ କୁଲିକେଦ୍‌କଆଏ, “ଆପେତାଃରେ ଚିମିନାଙ୍ଗ୍‌ ହଲଙ୍ଗ୍‌ ମେନା ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟା, “ସାତ୍‌ଠୁ ହଲଙ୍ଗ୍‌ ଆଡଃ ଚିମିନ୍‌ ହୁପ୍‌ଡିଙ୍ଗ୍‌ ହାକୁ ।” ");
INSERT INTO unx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ୟୀଶୁ, ଗାଦେଲ୍‌ ହଡ଼କକେ ଅତେରେ ଦୁବ୍‌ପେ ମେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ଏନ୍ତେ ଇନିଃ ଏନ୍‌ ସାତ୍‌ଠୁ ହଲଙ୍ଗ୍‌ ଆଡଃ ହାକୁ ଇଦିକେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌କିୟାଏ ଆଡଃ ଏନା କେଚାଃକେଦ୍‌ତେ ଆୟାଃ ଚେଲାକକେ ଏମାଦ୍‌କଆଏ ଆଡଃ ଚେଲାକ ହଡ଼କକେ ହାଟିଙ୍ଗ୍‌ଆଁଁଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ଏନା ଜମ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ ବି'ୟାନାକ ଆଡଃ ହଲଙ୍ଗ୍‌ କେଚାଃ ସାତ୍‌ ଟୁଙ୍କି ସାରେଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","କୁଡ଼ିକ ଆଡଃ ହନ୍‌କ ବାଗିକେଦ୍‌ତେ ଉପୁନ୍‌ ହାଜାର୍‌ କଡ଼ାକ ଜମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ଏନ୍ତେ ୟୀଶୁ ଗାଦେଲ୍‌ ହଡ଼କକେ କୁଲ୍‌କେଦ୍‌କଚି ଲାଉକାରେ ଦେଏଃୟାନାଏ ଆଡଃ ମାଗ୍‌ଦଲା ପାର୍‌ଗାନ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ଫାରୁଶୀକ ଆଡଃ ସାଦୁକିକ ୟୀଶୁତାଃ ହିଜୁଃକେଦ୍‌ତେ, ଇନିଃକେ ଚିଟାଇ ନାଗେନ୍ତେ ବିଡ଼ାଅତାନ୍‌ଲଃ ସିର୍ମାଏତେ ମିଆଁଦ୍‌ ଚିହ୍ନାଁ ଉଦୁବାଲେମେ ମେନ୍ତେକ କାଜିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆପେ ଆୟୁବ୍‌ତାନ୍‌ରେ ସିର୍ମା ଆରାଃଗିପେ ନେଲେରେଦ, କାଜିୟାଃପେ ତିସିଙ୍ଗ୍‌ ଫାର୍‌ଚିଗିୟା । ");
INSERT INTO unx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ଆଡଃ ସେତାଃ ଇଦାନ୍‌ରେ ସିର୍ମା ଆରାଃଗି ଆଡଃ ରିମିଲାକାଦ୍‌ଗିପେ ନେଲେରେଦ, କାଜିୟାଃପେ, ତିସିଙ୍ଗ୍‌ ଦୁଦୁଗାର୍‌ ହୟ ହିଜୁଃଆ । ଆପେଦ ସିର୍ମାରେୟାଃ ଚିହ୍ନାଁପେ ନେଲ୍ଉରୁମେତାନା ମେନ୍‌ଦ ଦିପିଲିରାଃ ଚିହ୍ନାଁକ କାପେ ନେଲ୍ଉରୁମ୍‌ ଦାଡ଼ିତାନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ଏତ୍‌କାନ୍‌ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ କା ବିଶ୍ୱାସ୍‌ତାନ୍‌ ହଡ଼କ ଚିହ୍ନାଁକ ଦାଣାଁଁ, ମେନ୍‌ଦ ଯୁନୁସ୍‌ ନାବୀଆଃ ଚିହ୍ନାଁ ବାଗିକେଦ୍‌ତେ ଇନ୍‌କୁନାଙ୍ଗ୍‌ ଏଟାଃ ଚିହ୍ନାଁ କା ଏମଃଆ ।” ଆଡଃ ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌ତେ ଇନିଃ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ଚେଲାକ ଦରେୟା ହାନ୍‌ ପାରମ୍‌ତେ ସେଟେର୍‌ୟାନ୍‌ଚି ହଲଙ୍ଗ୍‌ ଇଦି ନାଙ୍ଗ୍‌କ ରିଡ଼ିଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଫାରୁଶୀକଆଃ ଆଡଃ ସାଦୁକିକଆଃ ରାନୁଏତେ ଚିର୍ଗାଲାକାନ୍‌ ତାଇନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ଇନ୍‌କୁ ଆକ ଆକରେକ ମେନ୍‌କେଦା, “ଆବୁ ହଲଙ୍ଗ୍‌ କାବୁ ଆଉକାଦା ଏନାମେନ୍ତେ ଇନିଃ ଆବୁକେ କାଜିୟାବୁତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ୟୀଶୁ, ଇନ୍‌କୁ କାଜିତାନ୍‌ତେୟାଃ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ କାଜିକେଦ୍‌କଆଏ, “ଏ ହୁଡିଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ତାନ୍‌କ, ଆପେତାଃରେ ହଲଙ୍ଗ୍‌ ବାନଃ ମେନ୍ତେ ଚିକାନାଙ୍ଗ୍‌ ଆପେଗି ଉଡ଼ୁଃତାନା ? ନାହାଁଃ ଜାକେଦ୍‌ କାପେଚି ସାରିକାଦା ଆଡଃ ଆଟ୍‌କାର୍‌ଉରୁମାକାଦା ? ");
INSERT INTO unx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ଏନ୍‌ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ହଡ଼କ, ମଣେୟାଁ ହଲଙ୍ଗ୍‌ ଜମ୍‌କେଦ୍‌ତେ, ଚିମିନ୍‌ ଟୁଙ୍କି ସାରେଃୟାନା ଏନା କାପେଚି ପାହାମେତାନା ? ");
INSERT INTO unx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ଆଡଃ ଏନ୍‌ ଉପୁନ୍‌ ହାଜାର୍‌ ହଡ଼କ, ସାତ୍‌ଠୁ ହଲଙ୍ଗ୍‌ ଜମ୍‌କେଦ୍‌ତେୟାଃ କାପେଚି ପାହାମେତାନା ? ଚିମିନ୍‌ ଟୁଙ୍କି ସାରେଃୟାନା ? ");
INSERT INTO unx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ହଲଙ୍ଗ୍‌ ନାଗେନ୍ତେ କାଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଚିଲ୍‌କାତେ ନେଆଁଁ କାପେ ଆଟ୍‌କାର୍‌ଉରୁମେତାନା ? ମେନ୍‌ଦ ଫାରୁଶୀକଆଃ ଆଡଃ ସାଦୁକିକଆଃ ରାନୁଏତେ ଚିର୍ଗାଲାକାନ୍‌ ତାଇନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ଏନ୍ତେ ଇନ୍‌କୁ ହଲଙ୍ଗ୍‌ରାଃ ରାନୁଏତେଦ କା ମେନ୍‌ଦ ଫାରୁଶୀକଆଃ ଆଡଃ ସାଦୁକିକଆଃ ଇନିତୁଏତେ ଚିର୍ଗାଲାକାନ୍‌ପେ ମେନ୍ତେ ଇନିଃ କାଜିୟାଦ୍‌ବୁଆଏ ମେନ୍ତେକ ଆଟ୍‌କାର୍‌ଉରୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","କାଇସରିୟା ଫିଲିପି ପାର୍‌ଗାନ୍‌ରାଃ ସାହାର୍‌ତେ ସେଟେର୍‌ୟାନ୍‌ଚି ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କୁଲିକେଦ୍‌କଆ, “ମାନୱାହନ୍‌ ଅକଏ ତାନିଃ ମେନ୍ତେ ହଡ଼କ କାଜିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଚିମିନ୍‌କ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌, ଚିମିନ୍‌କ ଏଲିୟ, ଚିମିନ୍‌କ ଯିରିମିୟ ଚାଏ ନାବୀକଏତେ ମିଆଁଦ୍‌ନିଃ ତାନିଃ ମେନ୍ତେକ କାଜିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ୟୀଶୁ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆ, “ମେନ୍‌ଦ ଆପେ ଚିନାଃ ମେନେତାନାପେ ? ଆଇଙ୍ଗ୍‌ ଅକଏ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେପେ କାଜିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆମ୍‌ଗି ଖ୍ରୀଷ୍ଟ୍‌, ଜୀନିଦ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେ ଯୁନୁସ୍‌ରାଃ ହନ୍‌ ଶିମୋନ୍‌, ଆମ୍‌ ସୁକୁତାନ୍‌ଗିୟାମ୍‌, ନେଆଁଦ ହଡ଼ହନ୍‌ ଆମାଃତାଃ କାଏ ଉଦୁବ୍‌, ମେନ୍‌ଦ ସିର୍ମାରେନ୍‌ ଆପୁ ଉଦୁବାଦ୍‌ମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ଆଡଃ ଆଇଙ୍ଗ୍‌ହଁ ଆମ୍‌କେ କାଜିୟାମେ ତାନାଇଙ୍ଗ୍‌, ଆମ୍‌ ପାତ୍‌ରାସ୍‌ ତାନ୍‌ମେ ଏନାରାଃ ମୁଣ୍ଡି ଚାଟେନ୍‌ ତାନାଃ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ନେ ଚାଟେନ୍‌ରେ ଆଇଁୟାଃ କାଲିସିୟା ବାଇୟାଇଙ୍ଗ୍‌ ଆଡଃ ନାରାକ୍‌ରାଃ ପେଡ଼େଃ ଏନାକେ କାଏ ହାଦୁଡ଼୍‌ ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ଆଇଙ୍ଗ୍‌ ସିର୍ମା ରାଇଜ୍‌ରେୟାଃ ଚାଭି ଏମାମେୟାଁ, ଆମ୍‌ ଅତେରେ ଅକ୍‌ନାଃମ୍‌ ତଲେତେୟାଃ, ସିର୍ମାରେ ଏନା ତଲଃଆ, ଆଡଃ ଆମ୍‌ ଅତେରେ ଅକ୍‌ନାଃମ୍‌ ରାଡ଼ାଏତେୟାଃ, ସିର୍ମାରେ ଏନା ରାଡ଼ାଅଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ମାସି ତାନିଙ୍ଗ୍‌, ନେଆଁଁ ଜେତାଏତାଃ ଆଲ୍‌ପେ ଉଦୁବିୟାଁ ମେନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ଏନ୍‌ ଦିପିଲିଏତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ଫାର୍‌ଚିତେ କାଜିକେଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌କେ ଯୀରୁଶାଲେମ୍‌ତେ ସେନ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଏନ୍ତାଃରେ ପ୍ରାଚିନ୍‌କ, ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକଆଃ ତିଃଇରେ ସାବ୍‌ଇଚିକେଦ୍‌ତେ ପୁରାଃ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ ଆଡଃ ଗଜଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଏନ୍ତେ ଆପି ମାହାଁ ତାୟମ୍‌ତେ ଜୀଉବିନିରିଦ୍‌ ହବାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ପାତ୍‌ରାସ୍‌ ୟୀଶୁକେ ଗେନାତେ ଇଦିକିଃତେ ଏଗେର୍‌ଏଟେଦ୍‌କିୟାଏ । “ହେ ପ୍ରାଭୁ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଆମ୍‌କେ ଲିବୁଇମେକାଏ, ନେଆଁଁ ଆମାଃରେ ଚିଉଲାଅ ଆଲକା ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ୟୀଶୁ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ପାତ୍‌ରାସ୍‌କେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଏ ସାଏତାନ୍‌ ଆଇଁୟାଃତାଃଏତେ ଆତମେନ୍‌ମେ, ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ତହଦ୍‌ଇଚିଙ୍ଗ୍‌ତାନାମ୍‌, ଚିୟାଃଚି ଆମ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କା ମେନ୍‌ଦ ହଡ଼କଆଃ ଲେକାମ୍‌ ଉଡ଼ୁଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, “ଜେତାଏ ହଡ଼ ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଇନିଃ ଆୟାଃ ମନେ ବାଗିତାକାଏ ଆଡଃ ଆୟାଃ କ୍ରୁଶ୍‌ ଗଅଃକେଦ୍‌ତେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌କାଏ । ");
INSERT INTO unx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ଚିୟାଃଚି ଜେତାଏ ଆୟାଃ ଜୀଉକେ ବାଞ୍ଚାଅ ସାନାଙ୍ଗ୍‌ନିଃଦ ଏନାଏ ଆଦେୟା ମେନ୍‌ଦ ଜେତାଏ ଆୟାଃ ଜୀଉକେ ଆଇଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଆଦେନିଃ ଏନାଏ ବାଞ୍ଚାଅୟା । ");
INSERT INTO unx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ଜେତାଏ ହଡ଼ ଗଟା ଅତେଦିଶୁମ୍‌ ନାମ୍‌କେଦ୍‌ରେୟ ଆୟାଃ ଜୀଉକେ ଆଦେରେଦ ଇନିୟାଃ ଚିକାନ୍‌ ଫାଏଦା ହବାଅଆଃ ? ଚାଏ ଜେତାଏ ହଡ଼ ଆୟାଃ ଜୀଉ ନାମ୍‌ରୁହାଡ଼େ ନାଗେନ୍ତେ ଚିନାଃଏ ଏମ୍‌ ଦାଡ଼ିୟା ? ");
INSERT INTO unx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ମାନୱାହନ୍‌ଦ ଆୟାଃ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କଲଃ ଆୟାଃ ଆପୁଆଃ ମାନାରାଙ୍ଗ୍‌ରେ ହିଜୁଃ ଇମ୍‌ତା ଇନିଃ ମିଆଁଦ୍‌ ହଡ଼କେ ଆୟାଃ କାମିଲେକାଏ ଏମାଇୟା । ");
INSERT INTO unx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ନେତାଃରେ ମେନାକଏତେ ଚିମିନ୍‌ ହଡ଼କ ମାନୱାହନ୍‌ ଆୟାଃ ରାଇଜ୍‌ରେ ହିଜୁଃତାନ୍‌ ଆଉରିକ ନେଲେ ଜାକେଦ୍‌ କାକ ଗଜଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ତୁରିୟା ମାହାଁ ତାୟମ୍‌ତେ ୟୀଶୁ, ପାତ୍‌ରାସ୍‌, ଯାକୁବ୍‌ ଆଡଃ ହାଗାତେ ଯୋହାନ୍‌ତେକୁକେ ଆୟାଃଲଃ ମିଆଁଦ୍‌ ସାଲାଙ୍ଗି ବୁରୁତେ ଇଦିକେଦ୍‌କଆଏ । ଏନ୍ତାଃରେ ଇନ୍‌କୁ ଏସ୍‌କାର୍‌ଗିକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ଇନିୟାଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ ଇନ୍‌କୁଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ବାଦ୍‌ଲାୟାନା ଆଡଃ ଇନିୟାଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ ସିଙ୍ଗିଲେକା ଜୁଲ୍‌ୟାନା ଆଡଃ ଇନିୟାଃ ଲିଜାଃ ଝାକ୍‌ ମାକ୍‌ ପୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ଏନ୍ତେ ମୁଶା ଆଡଃ ଏଲିୟ ୟୀଶୁଲଃ ଜାଗାର୍‍ତାନ୍‌କ ନେଲ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ପାତ୍‌ରାସ୍‌ ୟୀଶୁକେ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆବୁଆଃ ନେତାଃରେ ତାଇନଃ ପୁରାଃ ବୁଗିନାଃ, ଆଡଃ ଆମ୍‌ ସୁକୁରେଦ, ଆଇଙ୍ଗ୍‌ ନେତାଃରେ ଆପିୟା କୁମ୍ବାଇଙ୍ଗ୍‌ ବାଇୟା, ଆମାଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌, ମୁଶା ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ଆଡଃ ଏଲିୟ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ୟୀଶୁ ଜାଗାର୍‌ତାନ୍‌ ଇମ୍‌ତାଗି ମିଆଁଦ୍‌ ମାର୍ସାଲ୍‌ ରିମିଲ୍‌ ଇନ୍‌କୁକେ ଉମ୍ବୁଲ୍‌କେଦ୍‍କଆ ଆଡଃ ନେଲେପେ, ଏନ୍‌ ରିମିଲ୍‌ଏତେ ଲାବ୍‌ଜା ଆୟୁମ୍‌ୟାନା, “ନିଃଗି ଆଇଁୟାଃ ଦୁଲାଡ଼୍‌ ହନ୍‌ ତାନିଃ, ନିଃତାଃରେ ଆଇଁୟାଃ ପୁରାଃଗି ସୁକୁ, ନିୟାଃ କାଜି ଆୟୁମେପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ଚେଲାକ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ଚି, ବରତେ ତାବେର୍‌କେଦ୍‍ତେ ଅତେରେକ ଉୟୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ୟୀଶୁ ଇନ୍‌କୁତାଃ ନାଡ଼େଃୟାନ୍‌ଚି ଜୁଟିଦ୍‌କେଦ୍‌ତେ କାଜିକେଦ୍‍କଆଏ, “ବିରିଦ୍‌ପେ, ଆଲ୍‌ପେ ବରଏୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ଇନ୍‌କୁ ଆରିଦ୍‌ରାକାବ୍‌କେଦ୍‌ତେ ୟୀଶୁକେ ବାଗିକେଦ୍‌ତେ ଏନ୍ତାଃରେ ଜେତାଏକେ କାକ ନେଲ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ଇନ୍‌କୁ ବୁରୁଏତେ ଆଡ଼୍‌ଗୁତାନ୍ ଇମ୍‌ତା ୟୀଶୁ ଇନ୍‌କୁକେ ଆଚୁକେଦ୍‌କଆ, “ମାନୱାହନ୍‌ ଗଜାକାନ୍‌କଏତେ ଆଉରି ଜୀଉବିରିଦ୍‌ ଜାକେଦ୍‌ ଆପେ ନେଲାକାଦ୍‌ତେୟାଃ ଜେତାଏକକେ ଆଲ୍‌ପେ ଉଦୁବାକଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ଚେଲାତାୟାଃକ ଇନିଃକେ କୁଲିକିୟାକ, “ଆଇନ୍‌ ଇତୁକଆଃ ଆଇନ୍‌ ଚିନାଃ ମେନ୍ତେ ଏଲିୟକେ ପାହିଲା ହିଜୁଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ମେନେତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଏଲିୟ ହିଜୁଃକେଦ୍‌ତେ ସବେନାଃ ଆଡଃମିସା ବାଇରୁହାଡ଼େୟାଏ, ଏନା ସାର୍‌ତିଗି ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଏଲିୟ ହିଜୁଃୟାନାଏ ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ କାକ ନେଲ୍‌ଉରୁମ୍‌କିୟା ଆଡଃ ଆକଆଃ ମନେଲେକା ଇନିଃକେ ସିଗିଦ୍‌‌କିୟାକ । ଏନ୍‌ ଲେକାଗି ମାନୱାହନ୍‌କେକ ସିଗିଦିଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ଏନ୍ତେ ଚେଲାକ, ଇନିଃ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ଆଃ ବିଷାଏ କାଜିକତାନାଏ ମେନ୍ତେ ଆଟ୍‌କାର୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ଗାଦେଲ୍‌ ହଡ଼କତାଃତେ ରୁହାଡ଼୍‌ୟାନ୍‌ଚି ମିଆଁଦ୍‌ ହଡ଼ ୟୀଶୁତାଃତେ ହିଜୁଃୟାନା ଆଡଃ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ, ");
INSERT INTO unx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ହନିଙ୍ଗ୍‌କଡ଼ାକେ ଲିବୁଆଇମେ, ଇନିଃଦ ମିର୍କି ବେମାର୍‌ତେ ପୁରାଃଗି ଦୁକୁତାନାଏ ଆଡଃ ଇନିଃ ମଣେଁସା ସେଙ୍ଗେଲ୍‌ରେ ଆଡଃ ଦାଆଃରେ ଉୟୁଗଃତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ଆଇଙ୍ଗ୍‌ ଆମାଃ ଚେଲାକତାଃ ଇଦିକିୟାଇଙ୍ଗ୍‌ ମେନ୍‌ଦ ଇନ୍‌କୁ କାକ ବୁଗିଦାଡ଼ିକିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଏ କା ବିଶ୍ୱାସ୍‌ତାନ୍‌ ଆଡଃ କେଟେଦ୍‌ ମନ୍‌ ହଡ଼କ, ଚିମିନ୍‌ ମାହାଁ ଜାକେଦ୍‌ ଆପେଲଃ ତାଇନାଇଙ୍ଗ୍‌ ? ଚିମିନ୍‌ ଜାକେଦ୍‌ ଆପେକେ ସାହାତିଙ୍ଗ୍‌ପେଆଇଙ୍ଗ୍‌, ଇନିଃକେ ଆଇଙ୍ଗ୍‌ତାଃତେ ଆଉୱିପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ୟୀଶୁ କଡ଼ାହନ୍‌ରେ ତାଇକାନ୍‌ ବଙ୍ଗାକେ ମାରାଙ୍ଗ୍‌ମଚାକିୟା ଆଡଃ ଇନିଃତାଃଏତେ ବଙ୍ଗା ଅଡଙ୍ଗ୍‌ୟାନା ଆଡଃ ଏନ୍‌ କଡ଼ାହନ୍‌ ଏନ୍‌ ଦିପିଲିଏତେ ବୁଗିୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ଏନ୍ତେ ଚେଲାକ ୟୀଶୁତାଃତେ ଏସ୍‌କାର୍‌ରେ ହିଜୁଃକେଦ୍‌ତେ କୁଲିକିୟାକ, “ଆଲେଦ ଚିନାଃମେନ୍ତେ ଏନ୍‌ ବଙ୍ଗାକେ କାଲେ ଅଡଙ୍ଗ୍‌ ଦାଡ଼ିକେନା ?” ");
INSERT INTO unx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଆପେୟାଃ ହୁଡିଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ ମେନ୍ତେ କାପେ ଦାଡ଼ିକେନା । ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେୟାଃ ବିଶ୍ୱାସ୍‌ ମିଆଁଦ୍‌ ମାନିଜାଙ୍ଗ୍‌ଲେକା ମେନାଃରେଦ, ମିଆଁଦ୍‌ ବୁରୁକେ ନେତାଃଏତେ ହାନ୍ତାଃତେ ସେନଃମେ ମେନ୍ତେ କାଜିରେଦ ଏନା ସେନଃଆ ଆଡଃ ବିଶ୍ୱାସ୍‌ରାଃ ପେଡ଼େଃତେ କା ଦାଡ଼ିୟଃଲେକା ଜେତ୍‌ନାଃ ବାନଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ନେ ଲେକାନ୍‌ ବଙ୍ଗାକ ବିନ୍ତି ଆଡଃ କାଟାବ୍‌କେଦ୍‌ତେ ଏସ୍‌କାର୍‌କ ଅଡଙ୍ଗ୍‌ଅଃଆ ଆଡଃ ଏଟାଃ ଲେକାତେଦ କାହାଗି ।” ");
INSERT INTO unx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ସବେନ୍‌ ଚେଲାକ ଗାଲିଲ୍‌ରେ ହୁଣ୍ଡିୟାନ୍‌ଚି ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଡଃ ହଡ଼କଆଃ ତିଃଇରେ ଏମ୍‌ଏଣ୍ଡାଗଃଆଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ଇନ୍‌କୁ ଇନିଃକେକ ଗଜିୟା ଆଡଃ ଆପି ମାହାଁରେ ଜୀଉବିରିଦ୍‌ ରୁହାଡ଼ାଏ ।” ଆଡଃ ଚେଲାକ ପୁରାଃଗିକ ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ କପର୍‌ନାହୁମ୍‌ତେକ ସେଟେର୍‌ୟାନ୍‌ଚି, ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେନ୍‌ ମାଲ୍‌ହାରମ୍‌କ ପାତ୍‌ରାସ୍‌ତାଃତେ ହିଜୁଃୟାନାକ ଆଡଃ କୁଲିକିୟାକ, “ଚିୟାଃ ଆପେୟାଃ ଗୁରୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଃ କାର୍‍ ପାଏସା କାଏ ଏମାଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ପାତ୍‌ରାସ୍‌ କାଜିକେଦ୍‌କଆଏ, “ହେଗି, ଏମାଃଏ ।” ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଅଡ଼ାଃତେ ବଲୟାନ୍‌ଚି, ୟୀଶୁ ପାତ୍‌ରାସ୍‌କେ ପାହିଲା କାଜିକିୟାଏ, “ଶିମୋନ୍‌ ଚିନାଃମ୍‌ ମେନେତାନା ? ନେ ଅତେରେନ୍‌ ରାଜାକ ଅକଏତାଃଏତେ କାର୍‌ ହାରମାଃକ ? ଇନ୍‌କୁ ଆକଆଃ ପାର୍‌ଜାକତାଃଏତେ ଚି ପାର୍‌ଦେଶିକତାଃଏତେ ?” ");
INSERT INTO unx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ପାତ୍‌ରାସ୍‌, “ପାର୍‌ଦେଶିକତାଃଏତେ” ମେନ୍‍ରୁହାଡ଼୍‌କେଦ୍‌ଚି, ୟୀଶୁ କାଜିକିୟାଏ, “ଏନ୍‌ରେଦ ପାର୍‌ଜାକ ପାଏସା କାକ ଏମ୍‌ରାଃକାଜି । ");
INSERT INTO unx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ମେନ୍‌ଦ ନାହାଁଃ ଆବୁ ଇନ୍‌କୁକେ ତହଦ୍‌ରିକା ନାଙ୍ଗ୍‌ କାବୁ ସାନାଙ୍ଗ୍‌ ତାନା, ଏନା ମେନ୍ତେ ଆମ୍‌ ଦରେୟାତେ ସେନ୍‌କେଦ୍‌ତେ ବାନ୍‍ଶି ହୁରାଙ୍ଗ୍‌ୟେଁମେ ଆଡଃ ସିଦା ବାନ୍‌ଶିଅଃ ହାକୁକେ ସାବିମେ ଏନ୍ତେ ଇନିୟାଃ ମଚାଏତେ ମିଆଁଦ୍‌ ରୁପାରାଃ ସିକାମ୍‌ ନାମେୟା, ଏନାକେ ଇଦିକେଦ୍‌ତେ ଆଇଁୟାଃ ଆଡଃ ଆମାଃ ନାଗେନ୍ତେ ଏମାକମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ଏନ୍‌ ଦିପିଲିରେ ଚେଲାକ ୟୀଶୁତାଃତେ ହିଜୁଃକେଦ୍‌ତେ କୁଲିକିୟାକ, “ସିର୍ମା ରାଇଜ୍‌ରେ ଅକଏ ମାରାଙ୍ଗ୍‌ଆଁଏ ?” ");
INSERT INTO unx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ୟୀଶୁ ମିଆଁଦ୍‌ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କେ ଆୟାଃତାଃତେ ଆଉକେଦ୍‌ତେ ଇନ୍‌କୁଆଃ ଥାଲାରେ ତିଙ୍ଗୁକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ‘ଆପେ ହେୟାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ହୁଡିଙ୍ଗ୍‌ହନ୍‌ ଲେକା କାପେ ବାଇୟେନ୍‌ରେ, ଜେତାଏ ସିର୍ମା ରାଇଜ୍‌ରେ କାପେ ବଲଆ । ");
INSERT INTO unx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ଏନାମେନ୍ତେ ଜେତାଏ ଆପାନ୍‌କେ ଲେବେୟେନ୍‌ନିଃ ଆଡଃ ନେ ହନ୍‌ ଲେକା ବାଇୟେନ୍‌ନିଃଗି ସିର୍ମା ରାଇଜ୍‌ରେ ମାରାଙ୍ଗ୍‌ଆଁଏ । ");
INSERT INTO unx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ଆଡଃ ଜେତାଏ ନେ ଲେକାନ୍‌ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କେ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ସୁକୁଆଇନିଃ ଆଇଙ୍ଗ୍‌କେ ସୁକୁଆଃଏ ।’ ");
INSERT INTO unx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ଜେତାଏ ଆଇଁୟାଃରେ ବିଶ୍ୱାସ୍‌ତାନ୍‌ ନେ ହୁପ୍‌ଡିଙ୍ଗ୍‌କଏତେ ମିଆଁଦ୍‌ନିଃକେ ଆୟାଃ ବିଶ୍ୱାସ୍‌ରେ ତହଦ୍‍ରିକାଇରେଦ ଇନିୟାଃ ହଟଃରେ ଜାନ୍ତାଦିରି ହାକାକେଦ୍‌ତେ ଇନିଃକେ ଇକିର୍‌ ଦରେୟାରେ ହୁଦ୍‌ମାତେୟାଃ ଇନିଃ ନାଗେନ୍ତେ ବୁଗିଅଃତେଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ହାୟ, ଚିମିନ୍‌ ବରୱାନ୍‌ଗି ନେ ଅତେଦିଶୁମ୍‌ ଚିୟାଃଚି ହଡ଼କଆଃ ବିଶ୍ୱାସ୍‌ରେ ତହଦ୍‌ରିକା ନାଗେନ୍ତେ ପୁରାଃତେୟାଃ ମେନାଃ । ନେ ଲେକାନ୍‌ ତହଦଃତେୟାଃଦ ହିଜୁଃଗି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ମେନ୍‌ଦ ଜେତାଏ ତହଦ୍‌ରିକାନିଆଃ ହାୟ, ଇନିୟାଃ ଦାସା ଚିମିନ୍‌ ବରୱାନ୍‌ଗି ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ଆମାଃ ତିଃଇ ଚାଏ ଆମାଃ କାଟା ଆମାଃ ବିଶ୍ୱାସ୍‌ରେ ତହଦ୍‍ ରିକାମ୍‌ତାନ୍‌ରେଦ ଏନାକେ ଛପା ଏଣ୍ଡାଗେମେ । ବାରିଆ ତିଃଇ ଆଡଃ ବାରିଆ କାଟା ତାଇକେଦ୍‌ତେ ନାରାକ୍‌ରେ ଜାନାଅ କା ଇଣିଁଜଃ ସେଙ୍ଗେଲ୍‌ତେ ସେନଃଏତେଦ ଟୁଣ୍ଟାୟାନ୍ତେ ଜୀଦାନ୍‌ରେ ବଲଃ ଆମାଃ ନାଗେନ୍ତେ ବୁଗିନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ଆମାଃ ମିଆଁଦ୍‌ ମେଦ୍‌ ପାପ୍‌ଇଚିମେରେଦ, ଏନାକେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ହୁଦ୍‌ମାଏଣ୍ଡାଃଏମେ । ବାରିଆ ମେଦ୍‌ ତାଇନ୍‌କେଦ୍‌ତେ ନାରାକ୍‌ ସେଙ୍ଗେଲ୍‌ରେ ହୁଦ୍‌ମାଅଃହେତେ ମିଆଁଦ୍‌ ମେଦ୍‌ତେ ଜୀଦାନ୍‌ରେ ବଲତେୟାଃ ବୁଗିନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ନେ ହୁପ୍‌ଡିଙ୍ଗ୍‌ ହନ୍‌କଏତେ ମିଆଁଦ୍‌ନିଃକେହଁ ଆଲ୍‌ପେ ହିଲାଙ୍ଗ୍‌ଇଆ ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ଇନ୍‌କୁକେ ଜାତ୍‌ନାଅକତାନ୍‌ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କ ଜାନାଅଗି ଆଇଁୟାଃ ଆପୁ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ମେନାକଆ । ");
INSERT INTO unx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ଚିୟାଃଚି ମାନୱାହନ୍‌ଦ ଆଦାକାନ୍‍କକେ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ହିଜୁଆକାନା । ");
INSERT INTO unx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ଚିକ୍‌ନାଃପେ ଉଡ଼ୁଃ ତାନା ? ଜେତାଏ ହଡ଼ଆଃ ମଣେଁହିସି ମିଣ୍ଡିକ ମେନାକଆ, ଆଡଃ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ଆଦ୍‌କରେ ଚିୟାଃ ଏନ୍‌ ଉପୁନ୍‌ହିସି ଗେଲ୍‌ଅରେୟା ମିଣ୍ଡିକକେ ବୁରୁରେ ଗୋଟ୍‌କେଦ୍‌ତେ ବାଗିତାକଆଏ ଆଡଃ ଆଦାକାନ୍‌ ମିଣ୍ଡିକେ କାଏ ଚି ଦାଣାଁଁଇୟାଁ ? ");
INSERT INTO unx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ଆଡଃ ଇନିଃକେ ନାମ୍‌ତାଇରେ, ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଇନିଃ ଏନ୍‌ ଉପୁନ୍‌ହିସି ଗେଲ୍‌ଅରେୟା କା ଆଦାକାନ୍‌ ମିଣ୍ଡିକଏତେ ମିଆଁଦ୍‌ ନାମାକାଇ ମିଣ୍ଡି ନାଗେନ୍ତେ ପୁରାଃଗି ରାସ୍‌କାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ଏନ୍‌ଲେକାଗି ନେ ହୁପ୍‌ଡିଙ୍ଗ୍‌କଏତେ ମିଆଁଦ୍‌ନିଃକେହଁ ଜିୟନଃକାଏ ମେନ୍ତେ ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ କାଏ ସାନାଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ହାଗାମ୍‌ତାମାଃ ଆମାଃ ବିରୁଧ୍‌ରେ ପାପ୍‌ ରିକାଏରେଦ, ଆୟାଃତାଃ ସେନ୍‌ମେ ଆଡଃ ଆବେନ୍‌ ବାରାନ୍‌କିନାଃ ଥାଲାରେ ଆୟାଃ ଚିଟାତେୟାଃ ଉଦୁବାଇମେ । ଇନିଃ ଆୟୁମ୍‌ରେଦ ହାଗାମ୍‌ତାମାଃକେ ନାମ୍‌ରୁହାଡ଼୍‌କିୟାମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ମେନ୍‌ଦ ଇନିଃ କାଏ ଆୟୁମ୍‌ରେଦ ମିହୁଡ଼୍‌ ଚାଏ ବାର୍‌ହଡ଼୍‌ ଏଟାଃକକେ ଆମାଃଲଃ ଇଦିକୁମେ । ଧାରାମ୍‌ପୁଥିରେୟାଃ କାଜିଲେକା, ‘ବାର୍‌ହଡ଼୍‌ ଚାଏ ଆପିହଡ଼୍‌ଆଃ ଗାୱାତେ ସବେନ୍‌ କାଜି ମାନାତିଙ୍ଗ୍‌ ହବାଅଃଆ ।’ ");
INSERT INTO unx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ଆଡଃ ଇନିଃ ଇନ୍‌କୁଆଃ କାଜିକ କାଏ ଆୟୁମ୍‌ରେଦ କାଲିସିୟାକେ ଉଦ୍‍ବିମେ, ଆଡଃ ଇନିଃ କାଲିସିୟାରାଃ କାଜିୟ କାଏ ଆୟୁମ୍‌ରେଦ, ଇନିଃକେ ସାଅଁସାର୍‌ ହଡ଼ ଆଡଃ ମାଲ୍‌ହାରମ୍‌ନିଃ ଲେକା ରିକାଇମେ, ଆଡଃ ଇନିଃଲଃ ଆଲମ୍‌ ମେସାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆମ୍‌ ଅତେରେ ଅକ୍‌ନାଃମ୍‌ ତଲେତେୟାଃ, ସିର୍ମାରେ ଏନା ତଲଃଆ, ଆଡଃ ଆମ୍‌ ଅତେରେ ଅକ୍‌ନାଃମ୍‌ ରାଡ଼ାଏତେୟାଃ, ସିର୍ମାରେ ଏନା ରାଡ଼ାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“ଆଡଃ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିପେତାନା, ଆପେକଏତେ ବାର୍‌ହଡ଼୍‌ ନେ ଅତେରେ ଜେତ୍‌ନାଃ ମିଦ୍‌ ମନ୍‍ତେକିନ୍‌ ଆସିରେଦ, ଏନା ସିର୍ମାରେନ୍‌ ଆପୁଇଙ୍ଗ୍‌ ସାଃଏତେକିନ୍‌ ନାମେଗିୟା । ");
INSERT INTO unx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ଚିୟାଃଚି ବାର୍‌ହଡ଼୍‌ ଚାଏ ଆପିହଡ଼୍‌ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ହୁଣ୍ଡିୟଃତାଃରେ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁଆଃ ଥାଲାରିୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ୟୀଶୁତାଃତେ ହିଜୁଃଲେନ୍ତେ କୁଲିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ହାଗାଇଙ୍ଗ୍‌ ତାଇୟାଁଃ ଆଇଁୟାଃ ବିରୁଧ୍‌ରେ ସବେନ୍‌ ଇମ୍‌ତା ପାପ୍‌ଏରେଦ ଚିମିନ୍‌ସା ଜାକେଦ୍‌ ଛାମାଇୟାଇଙ୍ଗ୍‌ ? ଚିୟାଃ ସାତ୍‌ ଧାଅଁ ଜାକେଦ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ସାତ୍‌ ଧାଅଁ ଜାକେଦ୍‌ ମେନ୍ତେ କାହାଗି, ମେନ୍‌ଦ ସତସ୍ତୋର୍‌ ଧାଅଁ ଜାକେଦ୍‌ ? ");
INSERT INTO unx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ଚିୟାଃଚି ସିର୍ମା ରାଇଜ୍‌ଦ ମିଆଁଦ୍‌ ରାଜାଲେକା, ଇନିଃ ଆୟାଃ ଦାସିକଆଃ ହିସାବ୍‌ ଆସି ନାଙ୍ଗ୍‌ ଉହାଟ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ଆଡଃ ରାଜା ହିସାବ୍‌ ଏଟେଦ୍‌ତାଇକେନ୍‌ ଇମ୍‌ତା ମିଆଁଦ୍‌ ଦାସିକେ ଇନିଃତାଃକ ଆଉକିୟା, ଇନିଃଦ ଗେଲ୍‌ ହାଜାର୍‌ ଦିନାରି ରିଣୀ ଇଦିକାଦ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ଇନିଃତାଃରେ ହାଲ୍‍ରୁହାଡ଼୍‌ ନାଗେନ୍ତେ ଜେତ୍‌ନାଃ କା ତାଇକେନା । ଏନାମେନ୍ତେ ରାଜା ଇନିଃକେ ଆଡଃ ଆୟାଃ କୁଡ଼ି, ହନ୍‌ଗାଁଣା, ଆଡଃ ଆୟାଃ ମେନାଃତେୟାଃ ସବେନାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ରିଣୀ ପେରେଃ ନାଗେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ଏନ୍ତେ ଏନ୍‌ ଦାସି ରାଜାରାଃ ଆୟାର୍‌ରେ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ଉୟୁଃୟାନାଏ, ଆଡଃ କାଜିକିୟାଏ, ‘ହେ ଗମ୍‌କେ, ଆଡଃ ଚିମିନ୍‌ ମାହାଁଲେକା ତାଙ୍ଗିତାମେ, ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ସବେନାଃଇଙ୍ଗ୍‌ ହାଲ୍‌ରୁହାଡ଼ାମେଆ ।’ ");
INSERT INTO unx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ଏନ୍ତେ ଏନ୍‌ ଦାସିରାଃ ରାଜା ଇନିଃରେ ବିଲ୍‌କାଅକେଦ୍‌ତେ, ଇନିଃକେ ଆଡ଼ାଃକିୟା, ଆଡଃ ଆୟାଃ ରିଣୀକ ବାଗିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ମେନ୍‌ଦ ଏନ୍‍ ଦାସି ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ, ଆୟାଃତାଃଏତେ ମିଦ୍‌ ସାଅ ମୁସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକା ରିଣୀ ଇଦିକାଦ୍‌ ମିଆଁଦ୍‌ ଗାତିଦାସିକେ ନାମ୍‍କିୟାଏ, ଏନ୍ତେ ଇନିଃକେ ସାବ୍‌କିତେ ହଟଃରେ ଲିମ୍ବୁଦ୍‍ ଏଟେଦ୍‌କିୟା ଆଡଃ କାଜିକିୟାଏ, ‘ଆଇଁୟାଃତାଃଏତେ ରିଣୀକାଦ୍‌ତେୟାଃ ସବେନାଃ ପେରେଜାଇଙ୍ଗ୍‌ମେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ଏନ୍‌ ଗାତିଦାସି ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ବିନ୍ତିକିୟାଏ, ଆଡଃ କାଜିକିୟାଏ, ‘ଆଡଃ ଚିମିନ୍‌ ମାହାଁଲେକା ତାଙ୍ଗିତାମେ, ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ସବେନାଃଇଙ୍ଗ୍‌ ହାଲ୍‌ରୁହାଡ଼ାମେଆ ।’ ");
INSERT INTO unx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ମେନ୍‌ଦ ଇନିୟାଃ ବିନ୍ତି କାଏ ଆୟୁମ୍‌କେଦା, ଆଡଃ ଇନିଃ ରିଣୀ ଆଉରି ହାଲ୍‌ରୁହାଡ଼େ ଜାକେଦ୍‌ ଜେହେଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ଇନିୟାଃ ଗାତିଦାସିକ ନେଆଁଁ ନେଲ୍‍କେଦ୍‍ତେ ପୁରାଃଗିକ ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନା ଆଡଃ ସେନଃୟାନ୍ତେ ସବେନାଃ ଆକଆଃ ରାଜାକେକ ଉଦୁବ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ଏନ୍ତେ ଇନିୟାଃ ରାଜା ଇନିଃକେ ହାକାଅକିୟାଏ, ଆଡଃ କାଜିକିୟାଏ, ‘ଏ ଏତ୍‌କାନ୍‌ ଦାସି, ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ବିନ୍ତିକେଦିଇଙ୍ଗ୍‌ରେ ଆମାଃ ସବେନ୍‌ ରିଣୀ ବାଗିତାଦ୍‌ମେୟାଁଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ବିଲ୍‍କାଅକେଦ୍‌ମେଲେକା, ଆମ୍‌ହ ଆମାଃ ଗାତିଦାସିକେ ବିଲ୍‌କାଅ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା ।’ ");
INSERT INTO unx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ରାଜା ପୁରାଃଗି ଏସେଦ୍‌ୟାନାଏ ଆଡଃ ଇନିଃ ଏନ୍‌ ଦାସିକେ ସବେନ୍‌ ରିଣୀ ଆଉରି ହାଲ୍‌ରୁହାଡ଼େ ଜାକେଦ୍‌ ସାଜାଇ ନାମେ ନାଗେନ୍ତେ ଜେହେଲ୍‌ତେ କୁଲ୍‌କିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ୟୀଶୁ ଜନ୍‌କା କାଜି କାଜିଚାବାକେଦ୍‌ଚି କାଜିକେଦାଏ, “ଆପେକଏତେ ମିଆଁଦ୍‌ ହଡ଼ ଆପେୟାଃ ହାଗାକଆଃ ଗୁହ୍ନାଁ ଆପେୟାଃ ମନ୍‌ସୁରୁଦ୍‌ତେ କାପେ ଛାମାକରେଦ, ଆଇଁୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁହଁ ଏନ୍‌ଲେକାଗି କାଏ ଛାମାପେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ୟୀଶୁ ନେଆଁଁ କାଜି ଚାବାକେଦ୍‍ଚି ଗାଲିଲ୍‌ ବାଗିକେଦ୍‌ତେ ଯାର୍ଦାନ୍‌ନାହିଁ ହାନ୍‍ପାରମ୍‌ ଯିହୁଦା ପାର୍‌ଗାନ୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେକ ଅତଙ୍ଗ୍‌କିୟା ଆଡଃ ଇନିଃ ଏନ୍ତାଃରେ ଦୁକୁହାସୁତାନ୍‌କକେ ବୁଗିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ଚିମିନ୍‌ ଫାରୁଶୀକ ଆୟାଃତାଃତେ ବିଡ଼ାଅ ନାଗେନ୍ତେକ ହିଜୁଃୟାନା ଆଡଃ କୁଲିକିୟାକ, “ମୁଶାରାଃ ଆଇନ୍‌ ଲେକାତେ, ଚିୟାଃ କଡ଼ା ଆୟାଃ କୁଡ଼ିକେ ଜେତାନ୍‌ କାଜି ନାଗେନ୍ତେ ବାଗିଦାଡ଼ିୟାଏ ଚି କାହା ?” ");
INSERT INTO unx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ଇନିଃ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଧାରାମ୍‌ପୁଥିରେ କାପେଚି ପାଢ଼ାଅକାଦା, ବାବାଇନିଃ ମୁନୁରେ ଏନ୍‌ ବାରାନ୍‍କିନ୍‍କେ, କଡ଼ା ଆଡଃ କୁଡ଼ି ବାଇକେଦ୍‍କିନାଏ ? ");
INSERT INTO unx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିକେଦାଏ, ‘ଏନା ନାଗେନ୍ତେ ହଡ଼ ଆୟାଃ ଏଙ୍ଗା ଆପୁକିନ୍‌କେ ବାଗିକେଦ୍‌ତେ ଆୟାଃ କୁଡ଼ିଲଃ ମିଦଃଆଏ, ଆଡଃ ଇନ୍‌କିନ୍‌ ବାରାନ୍‌କିନ୍‌ ମିଦଃଆକିନ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ଏନାମେନ୍ତେ ଇନ୍‌କିନ୍‌ ବାରିଆ ହଡ଼୍‌ମ ନାହାଁଲାଃକିନ୍‌, ମେନ୍‌ଦ ମିଆଁଦ୍‌ ହଡ଼୍‌ମତାନ୍‌କିନ୍‌, ଏନା ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ମିଦ୍‌ରେ ତଲାକାଦ୍‌ତେୟାଃ ହଡ଼ ଆଲକାଏ ବିନ୍‌ଗାଏକା ।” ");
INSERT INTO unx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ଫାରୁଶୀକ ୟୀଶୁକେ କୁଲିକିୟାକ, “ତାବ୍‌ଦ ମୁଶା ଚିନାଃମେନ୍ତେ କୁଡ଼ିକେ ବାଗିରେଆଃ ଅନଲ୍‌ଚିଠା ଏମ୍‌କେଦ୍‌ତେ ବାଗିକପେ ମେନ୍ତେ ଆଇନ୍‌ରେ ଆଚୁକାଦା ?” ");
INSERT INTO unx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ମୁଶାଦ ଆପେୟାଃ କେଟେଦ୍‌ମନ୍‍ ନାଗେନ୍ତେ ଆପେୟାଃ କୁଡ଼ିକକେ ବାଗି ଚିକାଦ୍‍ପେୟାଏ, ମେନ୍‌ଦ ଅତେଦିଶୁମ୍‌ରେୟାଃ ମୁନୁରାଃ ସିଦାରେ ଏନ୍‍ଲେକା କା ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଜେତାଏ ହଡ଼ ଆପାଙ୍ଗିର୍‌ କାମି ବେଗାର୍‌ ଏଟାଃ କାଜି ନାଗେନ୍ତେ ଆୟାଃ କୁଡ଼ିକେ ବାଗିକେଦ୍‌ତେ ଏଟାଃ କୁଡ଼ିକେ ଆଣ୍‌ଦିୟଃରେ ଆପାଙ୍ଗିର୍‌ କାମି କାମିୟାଏ ଆଡଃ ଇନିଃ ଆଇଃକ୍‌ଗି ଆପାଙ୍ଗିର୍‌ନିଃ ହବାଅଃଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ଚେଲାକ ୟୀଶୁକେ କାଜିକିୟାକ, “କଡ଼ା ଆଡଃ ଆୟାଃ କୁଡ଼ିଆଃ ଥାଲାରେ ନେ ଲେକା ହବାଅଃତାନ୍‌ରେଦ ଆଣ୍‌ଦି କା ବୁଗିନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ସବେନ୍‌ ହଡ଼କ ନେ ଇନିତୁ କାକ ମାନାତିଙ୍ଗ୍‌ ଦାଡ଼ିୟା, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଏନା ଅକନ୍‌କକେ ଏମାକାଦ୍‌କଆଏ, ଇନ୍‌କୁ ଏସ୍‌କାର୍‌ଗି ଦାଡ଼ିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ଚିୟାଃଚି ଚିମିନ୍‌ ଚାକୁରାକ ମେନାକଆ, ଇନ୍‌କୁ ଏନ୍‌ଲେକାଗିକ ଜାନାମାକାନା, ଆଡଃ ଏଟାଃ ଚିମିନ୍‌କ ହଡ଼କଆଃତେ ଚାକୁରାକ ବାଇୟାକାନା, ଆଡଃ ଏଟାଃକ ସିର୍ମା ରାଇଜ୍‌ରାଃ କାମି ନାଗେନ୍ତେ କାକ ଆଣ୍‌ଦିନ୍‌ତାନା । ନେୟାଁ ମାନାତିଙ୍ଗ୍‌ ଦାଡ଼ିନିଃ ମାନାତିଙ୍ଗ୍‌ୟେଁକାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ଏନ୍ତେ ୟୀଶୁ ହନ୍‌କଆଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହକେଦ୍‌ତେ ବିନ୍ତିକାଏ ମେନ୍ତେ ହଡ଼କ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କକେ ୟୀଶୁତାଃତେକ ଆଉକେଦ୍‌କଆ ମେନ୍‌ଦ ଚେଲାକ ଇନ୍‌କୁକେକ ମାରାଙ୍ଗ୍‌ମଚାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କକେ ଆଇଙ୍ଗ୍‌ତାଃତେ ହିଜୁଃଇଚିକପେ ଆଡଃ ଇନ୍‌କୁକେ ଆଲ୍‌ପେ ମାନାକଆ, ଚିୟାଃଚି ସିର୍ମା ରାଇଜ୍‌ଦ ନେ ହନ୍‌କ ଲେକାନ୍‌କଆଃ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ଏନ୍ତେ ଇନ୍‌କୁ ଚେତାନ୍‌ରେ ତିଃଇ ଦହକେଦ୍‌ତେ ଆଶିଷ୍‌କେଦ୍‌କଆଏ ଆଡଃ ଇନିଃ ଏନ୍ତାଃଏତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ମିଆଁଦ୍‌ ଧାଙ୍ଗ୍‌ଡ଼ା ୟୀଶୁତାଃତେ ହିଜୁଃୟାନା ଆଡଃ କୁଲିକିୟାଏ, “ହେ ଗୁରୁ, ଜାନାଅ ଜୀଦାନ୍‌ ନାମେ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ ଚିକାନ୍‌ ବୁଗିନ୍‌ କାମି ରିକା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଚିକାନାଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌କେ ଅକ୍‌ନାଃ ବୁଗିନ୍‌ ବିଷାଏ ତାନାଃ ମେନ୍ତେମ୍‌ କୁଲିଙ୍ଗ୍‌ତାନା ? ପାର୍‌ମେଶ୍ୱାର୍‌ ଏସ୍‌କାର୍‌ ବୁଗିନ୍‌ନିଃ ତାନିଃ । ମେନ୍‌ଦ ଆମ୍‌ ଜୀଦାନ୍‌ରେ ବଲ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌ତାନ୍‌ରେଦ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆନ୍‌ଚୁକ ମାନାତିଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ଇନିଃ ୟୀଶୁକେ କୁଲିକିୟାଏ, “ଅକନ୍‌ ଆନ୍‌ଚୁକ ?” ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହଡ଼ ଆଲମ୍‌ ଗଜିୟା, ଆଲମ୍‌ ଆପାଙ୍ଗିରାଃ, ଆଲମ୍‌ କୁମ୍ବୁଡ଼ୁଆଃ, ହସଡ଼ଗାୱା ଆଲମାଃ, ");
INSERT INTO unx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ଏଙ୍ଗା ଆପୁକିନ୍‌କେ ମାନାତିଙ୍ଗ୍‌କିନ୍‌ମେ, ଆଡଃ ଆମାଃ ହପର୍‌ଜାପାଃରେନ୍‌କକେ ଆମ୍‌ଲେକା ଦୁଲାଡ଼୍‌କମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ଏନ୍‌ ଧାଙ୍ଗ୍‌ଡ଼ା କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଏନ୍‌ ସବେନ୍‌ ଆନ୍‌ଚୁକଇଙ୍ଗ୍‌ ମାନାତିଙ୍ଗ୍‌କାଦା ଆଡଃ ଚିକ୍‌ନାଃ ଆଇଙ୍ଗ୍‌କେ ରିକା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ପକ୍‌ତାମ୍‌ ସାନାଙ୍ଗ୍‌ତାନ୍‌ରେଦ, ମିଆଁଦ୍‌ କାଜି ଆମ୍‌କେ ରିକା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଜୁ, ଆମାଃ ସବେନାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ରେଙ୍ଗେଃକକେ ହାଟିଙ୍ଗ୍‌ଆଁକମ୍‌, ଆଡଃ ଆମ୍‌ ସିର୍ମାରେ ଖୁର୍ଜିମ୍‌ ନାମେୟା । ଏନ୍ତେ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ଏନ୍‌ ଧାଙ୍ଗ୍‌ଡ଼ା ନେ'କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନ୍ତେ ସେନଃୟାନା ଚିୟାଃଚି ଇନିଃ ପୁରାଃଗି କିସାଁଣ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‍କଆଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, କିସାଁଣ୍‌ ହଡ଼କନାଙ୍ଗ୍‌ ସିର୍ମା ରାଇଜ୍‌ରେ ବଲଃ ପୁରାଃଗି ହାମ୍ବାଲାଃ । ");
INSERT INTO unx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ଆଡଃଗିଇଙ୍ଗ୍‌ କାଜିପେତାନା, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ କିସାଁଣ୍‌ ହଡ଼ ବଲ ଦାଡ଼ିଏତେ, ସୁଇ ଉଣ୍ଡୁଃରେ ଉଁଟ୍‌ ପାରମଃତେୟାଃ ରାୱାଲାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ଚେଲାକ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ପୁରାଃଗିକ ଆକ୍‌ଦାନ୍ଦାଅୟାନା, ଆଡଃ ଆକ ଆକରେକ କୁପ୍‌ଲିୟାନା, “ତାବ୍‌ଦ ଅକଏ ଜୀଉ ବାଞ୍ଚାଅ ନାମ୍‌ ଦାଡ଼ିୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ୟୀଶୁ ଇନ୍‌କୁକେ ଆରିଦ୍‌କେଦ୍‌ତେ କାଜିକେଦ୍‌କଆଏ, “ହଡ଼କ ନାଗେନ୍ତେ ନେଆଁଁ କା ଦାଡ଼ିୟଃ କାମିତାନା ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ତେ ହବାଦାଡ଼ିୟଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ନେଲେମେ, ଆଲେଦ ସବେନାଃ ବାଗିକେଦ୍‌ତେ ଆମ୍‌କେଲେ ଅତଙ୍ଗ୍‌କେଦ୍‌ମେୟାଁ । ଆଲେ ଚିକ୍‌ନାଃଲେ ନାମେୟା ?” ");
INSERT INTO unx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ସବେନାଃରାଃ ନାୱାଗି ବାଇରୁହାଡ଼୍‌କେଦ୍‌ତେ, ମାନୱାହନ୍‌ ଆୟାଃ ମାନାରାଙ୍ଗ୍‌ରେୟାଃ ରାଜ୍‌ଗାଦିରେ ଦୁବାଃଏ ଇମ୍‌ତା ଆପେ ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌କାଦିଙ୍ଗ୍‌କଗି ଗେଲ୍‌ବାର୍‌ ରାଜ୍‌ଗାଦିରେ ଦୁବ୍‌କେଦ୍‌ତେ ଇସ୍ରାଏଲ୍‌ରେନ୍ ଗେଲ୍‌ବାର୍ କିଲିକଆଃ ଚେତାନ୍‌ରେ ରାଇଜେୟାପେ । ");
INSERT INTO unx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ଆଡଃ ଜେତାଏ ହଡ଼ ଆଇଙ୍ଗ୍‌ ମେନ୍ତେ ଅଡ଼ାଃ ଚାଏ ହାଗା ଚାଏ ମିଶି ଚାଏ ଆପୁ ଚାଏ ଏଙ୍ଗା ଚାଏ ହନ୍‌ଗାଁଣା ଚାଏ ଅତେହାସା ବାଗିତାରେଦ, ଇନିଃ ଏନା ସାଅଗୁନା ଆଦ୍‌କାଏ ନାମେୟା ଆଡଃ ଜାନାଅ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌ ନାମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ମେନ୍‌ଦ ପୁରାଃ ଆୟାର୍‌ରେନ୍‌କ ତାୟମଃଆ ଆଡଃ ତାୟମ୍‌ରେନ୍‌କ ଆୟୁରଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ସିର୍ମା ରାଇଜ୍‌ଦ ମିଆଁଦ୍‌ ଚାଷି ହଡ଼ଲେକାଃ, ଇନିଃ ଇଦାନ୍‌ତେ ଆୟାଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ିରେ କାମିନାଙ୍ଗ୍‌ ହଡ଼କକେ ଦାଣାଁଁ ନାଗେନ୍ତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ଇନିଃ ସିଙ୍ଗିସାଟୁବ୍‌ରେ ମୁସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକାପେ ନାମେୟା ମେନ୍ତେ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆ, ଆଡଃ ଆୟାଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ିତେ କାମିନାଙ୍ଗ୍‌ କୁଲ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ଇନିଃ ସେତାଃ ନାଅ ଘାଡ଼ିକ ହବାଅଃତାଇକେନ୍‌ରେ ପିଟ୍‌ ପିଡ଼ିରେ ଏଟାଃ ହଡ଼କ ସାମାଗି ତିଙ୍ଗୁଆକାନ୍‌ ନେଲ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, ‘ଆପେୟ ଦାଖ୍‌ବାକ୍‌ଡ଼ିତେ ସେନଃପେ ଆଡଃ କାମିପେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ଠାଉକାନ୍‌ ଲେକାଗି ନାଲାଇଙ୍ଗ୍‌ ଏମାପେୟା ।’ ");
INSERT INTO unx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ଆଡଃ ଇନ୍‌କୁ କାମିତେକ ସେନଃୟାନା, ଏନ୍ତେ ଇନିଃ ଆଡଃଗି ତିକିନ୍‌ରାଃ ବାରାବାଜେ ଆଡଃ ତାର୍‌ସିଙ୍ଗ୍‌ ତିନ୍‌ବାଜେ ଅଡଙ୍ଗ୍‌ୟାନା ଆଡଃ ଚିମିନ୍‌ ନାଲାକାମି ହଡ଼କକେ ଆଉକେଦ୍‌ତେ କାମି ଏମାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ସିଙ୍ଗି ହାସୁରଃତାନ୍‌ରାଃ ପାଞ୍ଚ୍‌ବାଜେକ ଇନିଃ ଆଡଃମିସା ଅଡଙ୍ଗ୍‌ୟାନା, ଏନ୍ତେ ପିଟ୍‌ ପିଡ଼ିରେ ଚିମିନ୍‌ ନାଲାକାମିକ ସାମାଗି ତିଙ୍ଗୁଆକାନ୍‌ ନେଲ୍‌କେଦ୍‌କଆଏ, ଆଡଃ ମେତାଦ୍‌କଆଏ, ‘ଚିନାଃ ମେନ୍ତେ ଆପେ ନେତାଃରେ ସିଙ୍ଗିସାଟୁବ୍‌ ଜାକେଦ୍‌ ସାମାଗିପେ ତିଙ୍ଗୁଆକାନା ?’ ");
INSERT INTO unx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, ‘ଜେତାଏ ଆଲେକେ କାମିନାଙ୍ଗ୍‌ କାକ ଆଚୁକାଦ୍‌ଲେୟା ।’ ଇନିଃ ମେତାଦ୍‌କଆଏ, ‘ଠିକ୍‌ମେନାଃ, ଜୁ, ଆପେୟ ଦାଖ୍‌ବାକ୍‌ଡ଼ିତେ ସେନଃପେ ଆଡଃ କାମିପେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ଆୟୁବ୍‌ୟାନ୍‍ଚି ଦାଖ୍‌ବାକ୍‌ଡ଼ିରେନ୍‌ ଗମ୍‌କେ, ଆୟାଃ ଭାଣ୍ଡାରିକେ କାଜିକିୟାଏ, ‘ସବେନ୍‌ ନାଲାତାଇକେନ୍‌କକେ ହାକାଅକେଦ୍‌ତେ ଆକଆଃ ନାଲା ଏମାକମେ ।’ ତାୟମ୍‌ତେ କାମି ହିଜୁଆକାନ୍‌କକେ ପାହିଲା ଆଡଃ ମୁଲ୍‌ଏତେ କାମିକେନ୍‌କକେ ଟୁଣ୍ଡୁରେ ନାଲା ଏମାକମେ । ");
INSERT INTO unx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ସିଙ୍ଗିହାସୁର୍‌ତାନ୍‌ରାଃ ପାଞ୍ଚ୍‌ବାଜେ କାମିକେଦ୍‌ ସବେନ୍‌ ହଡ଼କ ମିପିହୁଡ଼୍‌ରେ ମୁସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକାକ ନାମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ମୁଲ୍‌ଏତେ କାମିକେନ୍‌କ ଆଦ୍‌କା ନାଲାଲେ ନାମେୟା ମେନ୍ତେକ ଉଡ଼ୁଃକେଦା, ମେନ୍‌ଦ ଇନ୍‌କୁହଗି ମିପିହୁଡ଼୍‌ରେ ମୁସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକାକ ନାମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ଇନ୍‌କୁ ନାଲା ତେଲାକେଦ୍‌ଚି, ଅଡ଼ାଃ ଗମ୍‌କେୟାଃ ବିରୁଧ୍‌ରେ କୁରୁମ୍‌ଡୁରୁମ୍‌ୟାନ୍‌ଲଃ କାଜିକେଦାକ, ");
INSERT INTO unx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘ତାୟମ୍‌ତେ ହିଜୁଆକାନ୍‌ ହଡ଼କ ମିଦ୍‌ ଘାଡ଼ିଗି କାମିକେଦାକ ଆଡଃ ଆଲେ ସିଙ୍ଗିସାଟୁବ୍‌ ନିମିନ୍‌ରାଃ ସିତୁଙ୍ଗ୍‌ ସାହାତିଙ୍ଗ୍‌କେଦ୍‌ତେ କାମିକେଦ୍‌ରେୟ ଆମ୍‌ ଆଲେକେ ଇନ୍‌କୁଲଃ ମିଦ୍‌ଗିମ୍‌ ଜକାକେଦ୍‌ଲେୟା ।’ ");
INSERT INTO unx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ମେନ୍‌ଦ ଇନିଃ ଇନ୍‌କୁଏତେ ମିହୁଡ଼୍‌କେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, ‘ଏ ଗାତି, ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ କାଇଙ୍ଗ୍‌ ବେଦାମେତାନା, ଆମ୍‌ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଚିନାଃ ମୁସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକା ଏମଃଆ ମେନ୍ତେ କାଲାଙ୍ଗ୍‌ ବାଖାଁଣ୍‌ କାଦ୍‌ତାଇକେନା ? ");
INSERT INTO unx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ନେ ଆମାଃ ନାଲା ଇଦିମେ ଆଡଃ ସେନଃମେ । ଆଇଙ୍ଗ୍‌ ତାୟମ୍‌ତେ ହିଜୁଃକାନ୍‌ କାମିନିଃକେ ଆମ୍‌କେ ଏମାକାଦ୍‌ମେ ଲେକା ଏମ୍‌ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ଚିୟାଃ ଆଇଁୟାଃ ମେନାଃତେୟାଃକେ ଆଇଁୟାଃ ମନେଲେକା ଏମ୍‌ କାଇଙ୍ଗ୍‌ ଦାଡ଼ିୟା ? ଚି ଆଇଙ୍ଗ୍‌ ବୁଗିନ୍‌ ଏମଃନିଃ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେମ୍‌ ହିସ୍‌ଙ୍ଗାଇଙ୍ଗ୍‌ତାନା ?’” ");
INSERT INTO unx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ଆଡଃ ୟୀଶୁ ନେ ଲେକାତେ କାଜିଚାବାକେଦା, “ତାୟମ୍‌ରେନ୍‌କ ସିଦାଅଃଆ, ଆଡଃ ଆୟାର୍‌ରେନ୍‌କ ତାୟମଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ ସେନଃ ଇମ୍‌ତା ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ ଗେନାତେ ଇଦିକେଦ୍‌ତେ କାଜିକେଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ନେଲେପେ, ଆବୁ ଯୀରୁଶାଲେମ୍‌ତେବୁ ସେନଃତାନା ଆଡଃ ମାନୱାହନ୍‌କେ ମୁଲ୍‌ ଯାଜାକ୍‌କଆଃ ଆଡଃ ଆଇନ୍‌ ଇତୁକଆଃ ତିଃଇରେକ ଜିମାଇୟା ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ଗନଏଃ ସାଜାଇ ନାଗେନ୍ତେକ ବିଚାରେୟା । ");
INSERT INTO unx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେକ ଲାନ୍ଦାଇୟା, ହାଁଣ୍‌ସାଇୟା ଆଡଃ କ୍ରୁଶ୍‌ରେ କିଲା ନାଗେନ୍ତେ ସାଅଁସାର୍‌କଆଃ ତିଃଇରେକ ଏମିୟା, ମେନ୍‌ଦ ଆପି ମାହାଁ ତାୟମ୍‌ତେ ଇନିଃ ଜୀଉବିରିଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ଏନ୍ତେ ଜେବଦୀୟାଃ କୁଡ଼ିତେ ଆୟାଃ ବାରିଆ ହନ୍‌କିନ୍‌ଲଃ ୟୀଶୁତାଃତେ ହିଜୁଃୟାନା ଆଡଃ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ଦେଙ୍ଗା ଆସିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ଏନ୍ତେ ୟୀଶୁ କୁଲିକିୟାଏ, “ଆମ୍‌ ଚିନାଃ ସାନାଙ୍ଗ୍‌ ତାନାମ୍‌ ?” ଇନିଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଁୟାଃ ନେ ହନ୍‌କିନ୍‌ ଆମାଃ ରାଇଜ୍‌ରେ ମିଆଁଦ୍‌ନିଃକେ ଜମ୍‌ତିସାଃରେ ଆଡଃମିଆଁଦ୍‌ନିଃକେ ଲେଙ୍ଗାତିସାଃରେ ଦୁବ୍‌କାକିନ୍‌ ମେନ୍ତେ ଆଚୁକିନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ୟୀଶୁ ଜେବଦୀଆଃ ବାରିଆ ହନ୍‌କିନ୍‌କେ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କିନାଏ, “ଚିନାଃବେନ୍‌ ଆସିତାନା ଏନା କାବେନ୍‌ ସାରିତାନା । ଚିନାଃ ଆଇଁୟାଃ ଦୁକୁରେୟାଃ ନୁଁଏ କାଟୋରାରେ ନୁଁବେନ୍‌ ଦାଡ଼ିୟା ?” ଇନ୍‌କିନ୍‌ କାଜିରୁହାଡ଼୍‌କେଦା, “ଦାଡ଼ିୟାଲିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ୟୀଶୁ ମେତାଦ୍‌କିନାଏ, “ଆଇଁୟାଃ କାଟୋରାତେ ନୁଁଦବେନ୍‌ ନୁଁଇୟା ମେନ୍‌ଦ ଆଇଁୟାଃ ଜମ୍‌ତିସାଃରେ ଆଡଃ ଲେଙ୍ଗାତିସାଃରେ ଦୁବ୍‌ରିକାତେୟାଃ ଆଇଁୟାଃ ତିଃଇରେ ବାନଆଃ ମେନ୍‌ଦ ନେ ଠାୟାଦ୍‌ ଆପୁଇଙ୍ଗ୍‌ ଅକନ୍‌କ ନାଗେନ୍ତେ ବାଇୟାକାଦାଏ ଇନ୍‌କୁ ନାଙ୍ଗ୍‌ ଏସ୍‌କାର୍‌ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ଏଟାଃ ଗେଲ୍‌ ଚେଲାକ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଏନ୍‌ ବାରାନ୍‌ ହାଗିୟାକିନ୍‌କେ ଖିସ୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ କେଡ଼ାକେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, “ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କଆଃ ହାକିମ୍‌କ ଇନ୍‌କୁରେକ ରାଇଜ୍‌ତାନା ଆଡଃ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌କ ଇନ୍‌କୁଆଃ ଚେତାନ୍‌ରେ ପୁରାଃଗି ଆକ୍‌ତେୟାର୍‌ରେ ତାନାକ, ଏନା ଆପେ ସାରିୟାକାଦାଃପେ । ");
INSERT INTO unx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ଆପେୟାଃ ଥାଲାରେ ଆଲକା ଏନ୍‌କାଅଃକା, ମେନ୍‌ଦ ଆପେ ଥାଲାରେ ଜେତାଏ ମାରାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଇନିଃ ଏଟାଃକଆଃ ସୁସାର୍‌ନିଃ ହବାଅଃକାଏ, ");
INSERT INTO unx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ଆଡଃ ଆପେୟାଃ ଥାଲାରେ ଜେତାଏ ସିଦାଉତାରଃ ସାନାଙ୍ଗ୍‌ତାନ୍‌ନିଃ, ଏଟାଃକଆଃ ଦାସିଲେକା ଏଟାଃକକେ ସୁସାର୍‌କକାଏ । ");
INSERT INTO unx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ନେ ଲେକାତେ ମାନୱାହନ୍‌ ସୁସାର୍‌ ନାମେ ନାଗେନ୍ତେଦ କା ମେନ୍‌ଦ ସୁସାର୍‌ ନାଗେନ୍ତେ ଆଡଃ ଆୟାଃ ଜୀଉ ପୁରାଃ ହଡ଼କନାଙ୍ଗ୍‌ ଦାଣେଁ ଗନଙ୍ଗ୍‌ ଏମ୍‌ ନାଗେନ୍ତେ ହିଜୁଆକାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ଯିରିହୋ ସାହାର୍‌ଏତେ ଅଡଙ୍ଗ୍‌ ତାଇକେନ୍‌ରେ ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେକ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ଆଡଃ ବାର୍‌ହଡ଼୍‌ କାଣାଁକିନ୍‌ ହରାଗେନାରେ ଦୁବାକାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ୟୀଶୁ ପାରମଃତାନାଏ ମେନ୍ତେକିନ୍‌ ଆୟୁମ୍‌କେଦ୍‌ଚି କାଉରିକେଦାକିନ୍‌, “ହେ ଗମ୍‌କେ, ହେ ଦାଉଦ୍‌ଆଃ ହନ୍‌, ଦାୟାଲିଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ଗାଦେଲ୍‌ ହଡ଼କ ହାପାଃଅବେନ୍‌ ମେନ୍ତେକ ମାରାଙ୍ଗ୍‌ମଚାକେଦ୍‍କିନା ମେନ୍‌ଦ ଇନ୍‌କିନ୍‌ ଆଡଃ ପୁରାଃତେ କାଉରିକେଦାକିନ୍‌, “ହେ ପ୍ରାଭୁ, ଦାଉଦ୍‌ଆଃ ହନ୍‌ ଦାୟାଲିଙ୍ଗ୍‌ମେ !” ");
INSERT INTO unx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ୟୀଶୁ ତିଙ୍ଗୁୟାନ୍ତେ ହାକାଅକେଦ୍‌କିନାଏ ଆଡଃ ମେତାଦ୍‌କିନାଏ, “ଆଇଙ୍ଗ୍‌ ଆବେନାଃ ନାଗେନ୍ତେ ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ମେନ୍ତେବେନ୍‌ ସାନାଙ୍ଗ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ଇନ୍‌କିନ୍‌ ୟୀଶୁକେ କାଜିରୁହାଡ଼୍‌କିୟାକିନ୍‌, “ହେ ପ୍ରାଭୁ, ମେଦ୍‌ଲିଙ୍ଗ୍‌ ନେଲ୍‌ ଦାଡ଼ିକା ମେନ୍ତେଲିଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ ଲିବୁଇୟାଦ୍‌କିନାଏ ଆଡଃ ଇନ୍‌କିନାଃ ମେଦ୍‌ ଜୁଟିଦ୍‌କେଦାଏ, ଏନ୍ତେ ଇମ୍‌ତାଗି ନେଲ୍‌ ଦାଡ଼ିକେଦାକିନ୍‌ ଆଡଃ ଇନ୍‌କିନ୍‌ ୟୀଶୁକେ ଅତଙ୍ଗ୍‌କିୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ଯୀରୁଶାଲେମ୍‌ ନାଡ଼େଃରାଃ ଜାଇତୁନ୍‌ ବୁରୁ ଜାପାଃ ବେତ୍‌ଫାଗି ହାତୁତେ ସେଟେର୍‌ୟାନାକ, ଇମ୍‌ତା ୟୀଶୁ ବାରିଆ ଚେଲାକିନ୍‌କେ କୁଲ୍‍କେଦ୍‍ତେ, ମେତାଦ୍‌କିନାଏ ");
INSERT INTO unx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ଆବେନ୍‌ ଆବେନାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେଆଃ ହାତୁତେ ସେନଃବେନ୍‌ ଆଡଃ ଏନ୍ତାଃତେ ତେବାଃ ଇମ୍‌ତାଗି ମିଆଁଦ୍‌ ଗାଧା ଆଡଃ ଗାଧାହନ୍‌କେ ତଲାକାନ୍‌ବେନ୍‌ ନାମିୟା, ଇନ୍‌କିନ୍‌କେ ରାଡ଼ାକେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌ତାଃତେ ଆଉକିନ୍‌ବେନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ଆଡଃ ଜେତାଏ ଜେତ୍‌ନାଃ କାଜିବେନ୍‌ରେଦ, ‘ନିକିନ୍‌ତାଃରେ ପ୍ରାଭୁଆଃ କାମିମେନାଃ’ ମେତାଇବେନ୍ ଆଡଃ ଇନିଃ ଇମ୍‌ତାଗି କୁଲ୍‍ବାଗିକିନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ନେଆଁଁ ନାବୀକଆଃ କାଜି ପୁରାଅଃ ନାଗେନ୍ତେ ନେ ଲେକା ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ସିୟୋନ୍‌ରେନ୍‌ ହନ୍‌କୁଡ଼ିକେ କାଜିପେ, ‘ନେଲେମେ, ଆମାଃ ରାଜା ଆମାଃତାଃତେ ହିଜୁଃତାନା ! ଲେବେୟାନ୍‌ଗି ଇନିଃ, ଗାଧା ଆଡଃ ଗାଧାହନ୍‌ ଚେତାନ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ଆମାଃତାଃତେ ହିଜୁଃତାନା ।’” ");
INSERT INTO unx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ଏନ୍‌ ଚେଲାକିନ୍ ସେନଃୟାନ୍ତେ ୟୀଶୁ ଆଚୁକାଦ୍‌କିନ୍ ଲେକା କାମିକେଦାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଚେଲାକିନ୍‌ ଗାଧା ଆଡଃ ଗାଧାହନ୍‌କେ ଆଉକେଦ୍‌ତେ, ଗାଧାକିନାଃ ଚେତାନ୍‍ରେ ଲିଜାଃ ଆଟେଦ୍‌ କେଦାକିନ୍‌ ଆଡଃ ୟୀଶୁ ଏନ୍‌ ଚେତାନ୍‌ରେ ଦୁବ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ଗାଦେଲ୍‌ହଡ଼କଏତେ ଚିମିନ୍‌କ ଆକଆଃ ଲିଜାଃ ହରାରେକ ଆଟେଦ୍‌କେଦା, ଆଡଃ ଏଟାଃକ ଦାରୁଏତେ କତକ ମାଆଃକେଦ୍‌ତେ ହରାରେକ ଆଟେଦ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଆଡଃ ଆୟୁର୍‌ ତାୟମ୍‌ତେ ସେନ୍‌ତାନ୍‌ ଗାଦେଲ୍‍ହଡ଼କ କାଉରିକେଦା, “ଦାଉଦ୍‌ଆଃ ହନ୍‌ ହୋଶାନ୍ନା, ପ୍ରାଭୁଆଃ ନୁତୁମ୍‌ତେ ହିଜୁଃତାନ୍‌ନିୟାଃ ଧାଇନ୍‌ ହବାଅଃକା, ସାଲାଙ୍ଗିଉତାର୍‌ ଠାୟାଦ୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ତେ ବଲୟାନ୍‌ ଇମ୍‌ତା ଗଟା ନାଗାର୍‌ରେନ୍‌ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନା ଆଡଃ “ନିଃ ଅକଏ ତାନିଃ ?” ମେନ୍ତେକ କୁଲିବାଡ଼ାକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ଗାଦେଲ୍‌ ହଡ଼କ କାଜିରୁହାଡ଼୍‌କେଦା, “ନିଃ ଗାଲିଲ୍‌ରେୟାଃ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ନାବୀ ୟୀଶୁ ତାନିଃ” ମେନ୍ତେକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ବଲୟାନାଏ ଆଡଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ସବେନ୍‌ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ ତାନ୍‌କକେ ହାର୍‌ ଅଡଙ୍ଗ୍‌କେଦ୍‌କଆ ଆଡଃ ପାଏସା ଭାଞ୍ଜାଅତାନ୍‌କଆଃ ଟେବୁଲ୍‌କ, ଦୁଦୁମୁଲ୍‌କ ଆଖ୍‌ରିଙ୍ଗ୍‌ତାନ୍‍କଆଃ ଦୁବ୍‌ତେୟାଃ ଉଦୁର୍‌ବାଟିକେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଧାରାମ୍‌ପୁଥିରେ ନେଆଁଁ ଅଲାକାନା, ‘ଆଇଁୟାଃ ଅଡ଼ାଃ ବିନ୍ତିଅଡ଼ାଃ ମେନ୍ତେ ନୁତୁମଃଆ’ ମେନ୍‌ଦ ଆପେ ନେଆଁଁକେ କୁମ୍ବୁଡ଼ୁକଆଃ ତାଇନଃ ଠାୟାଦ୍‌ପେ ବାଇୟାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ମେଦ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିତାନ୍‌କ ଆଡଃ କାଟା ଟୁଣ୍ଟାକାନ୍‍କ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ବୁଗିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ମେନ୍‌ଦ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଇନିୟାଃ ଆକ୍‌ଦାନ୍ଦାଅକାମିକ ଆଡଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ “ଦାଉଦ୍‌ଆଃ ହନ୍‌ ହୋଶାନ୍ନା” ମେନ୍ତେ ହନ୍‌କ କାଉରିତାନ୍‌ତେୟାଃ ନେଲ୍‌କେଦ୍‌ତେ ଖିସ୍‌ୟାନାକ, ");
INSERT INTO unx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ଆଡଃ କୁଲିକିୟାକ, “ଚିୟାଃ ଆମ୍‌ ଇନ୍‌କୁ କାଜିତାନ୍‌ତେୟାଃ ଆୟୁମେତାନାମ୍‌ଚି ?” ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆ, “ହେଗି ଆୟୁମ୍‌ତାନାଇଙ୍ଗ୍‌ । ଆପେ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ତେୟାଃ ଚିଉଲାହ କାପେ ପାଢ଼ାଅଚି ? ‘ଆପେ ହନ୍‌କକେ ଆଡଃ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କକେ ବୁଗିନ୍‌ ଜହାର୍‌ ନାଗେନ୍ତେ ଇତୁକାଦ୍‌କଆପେ ।’” ");
INSERT INTO unx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ୟୀଶୁ ଇନ୍‌କୁକେ ଯୀରୁଶାଲେମ୍‌ ବାଗିକେଦ୍‌ତେ ବେଥ୍‌ନିଆ ନାଗାର୍‌ତେ ସେନଃୟାନା ଆଡଃ ଏନ୍ତାଃରେ ମିଦ୍‌ନୁବାଃ ତାଇନ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ସେତାଃ ଇଦାନ୍‌ରେ ଯୀରୁଶାଲେମ୍‌ ନାଗାର୍‌ତେ ସେନଃରୁହାଡ଼୍‌ତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ୟୀଶୁକେ ରେଙ୍ଗେଃକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ହରାଗେନାରେ ମିଆଁଦ୍‌ ଲଆଦାରୁକେ ନେଲ୍‌କେଦ୍‌ତେ ଏନ୍ତାଃତେ ସେନ୍‌ ନାଡ଼େଃୟାନା, ମେନ୍‌ଦ ସାକାମ୍‌ ବାଗିକେଦ୍‌ତେ ଏନାରେ ଜେତ୍‌ନାଃ କାଏ ନାମ୍‌କେଦା ଆଡଃ କାଜିକେଦାଏ, “ଆମାଃତାଃରେ ଚିଉଲାଅ ଆଲକା ଜଅଃ'କା” ଆଡଃ ଲଆଦାରୁ ଇମ୍‌ତାଗି ରହଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ଚେଲାକ ନେଆଁଁ ନେଲ୍‍କେଦ୍‍ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ ଆଡଃ କୁଲିକିୟାକ, “ଲଆଦାରୁ ଚିଲ୍‍କାତେ କାଜି ତର୍‍ସାଗି ରହଡ଼୍‌ୟାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆପେ ମନ୍‌ରେ କା ଆଡ଼ାଃଉଡ଼ୁଃକେଦ୍‌ତେ ପୁରାଃ ବିଶ୍ୱାସ୍‌ତାନ୍‌ଲଃ ନେ ଲଆଦାରୁକେ ଆଇଙ୍ଗ୍‌ ରିକାକାଦ୍‌ଲେକା, ଆପେୟ ଏନ୍‌ଲେକା ରିକାଦାଡ଼ିୟାପେ । ଆଡଃ ନେଆଁଁକେ ଏସ୍‌କାର୍‍ କା ମେନ୍‌ଦ ବୁରୁକେହଁ ‘ମାର୍‌ ବିରିଦ୍‌ମେ ଆଡଃ ଦରେୟାରେ ଉୟୁଗଃମେ’ ମେନ୍ତେପେ କାଜିରେ ଏନା ଏନ୍‌ଲେକା ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ଆଡଃ ଆପେ ବିଶ୍ୱାସେରେଦ, ବିନ୍ତିତେ ଆସିତେୟାଃ ସବେନାଃପେ ନାମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ବଲକେଦ୍‌ତେ ଇତୁତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‍ତାଗି ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ହଡ଼କଆଃ ପ୍ରାଚିନ୍‌କ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା ଆଡଃ କୁଲିକିୟାକ, “ଆମ୍‌ ଅକ ଆକ୍‌ତେୟାର୍‌ତେ ନେଆଁଁକମ୍‌ କାମିତାନା ? ଆଡଃ ଅକଏ ନେ ଆକ୍‌ତେୟାର୍‌ ଏମାକାଦ୍‌ମେୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ହଁ ମିଆଁଦ୍‌ କାଜିଇଙ୍ଗ୍‌ କୁଲିପେୟା, ଏନାପେ ଉଦୁବାଇଙ୍ଗ୍‌ରେଦ ଆଇଙ୍ଗ୍‌ ଅକ ଆକ୍‌ତେୟାର୍‌ କାମିତାନାଇଙ୍ଗ୍‌ ଏନାଇଙ୍ଗ୍‌ ଉଦୁବାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ଯୋହାନ୍‌, ବାପ୍ତିସ୍ମା ଏମ୍‌ ନାଗେନ୍ତେ ଅକ୍‌ତାଃଏତେ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ ତାଇକେନା ? ସିର୍ମାରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ଚି ହଡ଼କତାଃଏତେ ?” ଆଡଃ ଇନ୍‌କୁ ଆକ ଆକରେକ ଉଡ଼ୁଃକେଦା, “ଆବୁ, ‘ସିର୍ମାରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ’ ମେନେରେଦ ଇନିଃ ‘ଚିକାନାଙ୍ଗ୍‌ ଯୋହାନ୍‌ରେ କାପେ ବିଶ୍ୱାସ୍‌କେଦା’ ମେତାବୁଆଏ ? ");
INSERT INTO unx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ମେନ୍‌ଦ ଆବୁ, ‘ହଡ଼କତାଃଏତେ’ ମେନେରେଦ, ଗାଦେଲ୍‌ ହଡ଼କତାଃଏତେ ବରମେନାଃ, ଚିୟାଃଚି ଯୋହାନ୍‌କେ ସବେନ୍‌ ହଡ଼କ ନାବୀ ତାନିଃ ମେନ୍ତେକ ବିଶ୍ୱାସୀ ତାଇକେନା ।” ");
INSERT INTO unx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ଏନାତେ ଇନ୍‌କୁ “ଆଲେ କାଲେ ସାରିୟା” ମେନ୍ତେ ୟୀଶୁକେକ କାଜିରୁହାଡ଼୍‌କିୟା । ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ହଁ ଅକ ପେଡ଼େଃତେ ଏନାକଇଙ୍ଗ୍‌ ରିକାତାନା, କାଇଙ୍ଗ୍‌ ଉଦୁବାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ନେ ବିଷାଏରେ ଆପେ ଚିନାଃପେ ଉଡ଼ୁଃତାନା ? ଜେତାଏ ହଡ଼ରାଃ ବାରିଆ ହନ୍‌କିନ୍‌ ତାଇକେନା, ଆଡଃ ମାରାଙ୍ଗ୍‌ନିଃତାଃତେ ସେନ୍‌କେଦ୍‌ତେ କାଜିକିୟାଏ, ‘ଏ ହନ୍‌, ଜୁ ତିସିଙ୍ଗ୍‌ ଆଇଁୟାଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ିରେ କାମିମେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ଇନିଃ କାଜିକିୟାଏ, ‘ଆଇଙ୍ଗ୍‌କେ କାମି କା ସାନାଙ୍ଗ୍‌ ତାନାଃ,’ ମେନ୍‌ଦ ତାୟମ୍‌ତେ ହେୟାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ଏନ୍ତେ ଆପୁତେ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କଡ଼ାତାଃତେ ସେନ୍‌କେଦ୍‌ତେ ଏନ୍‌ଲେକାଗି କାଜିକିୟାଏ, ଆଡଃ ଇନିଃ ‘ହେଗି, ଆଇଙ୍ଗ୍‌ ସେନାଇଙ୍ଗ୍‌’ ମେନ୍ତେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, ମେନ୍‌ଦ ଇନିଃ କାଏ ସେନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ଏନ୍‌ ବାରାନ୍‌କିନ୍‌ଏତେ ଅକଏ ଆପୁତେୟାଃ ମନେଲେକା କାମିକେଦାଏ ?” ଇନ୍‌କୁ “ମାରାଙ୍ଗ୍‌ନିଃ,” ମେନ୍ତେକ କାଜିରୁହାଡ଼୍‌କିୟା । ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ମାଲ୍‌ହାରମ୍‌କ ଆଡଃ ବେଶ୍ୟାକ ଆପେଏତେ ସିଦାରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେକ ବଲତାନା । ");
INSERT INTO unx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ଦ ଆପେତାଃ ଧାର୍‌ମାନ୍‌ ହରା ଉଦୁବ୍‌ ନାଗେନ୍ତେ ହିଜୁଃୟାନା ଆଡଃ ଆପେ ଇନିଃରେ କାପେ ବିଶ୍ୱାସ୍‌କେଦା, ମେନ୍‌ଦ ମାଲ୍‌ହାରମ୍‌କ ଆଡଃ ଆଣ୍‌ଦିଆପାଙ୍ଗିର୍‌କ ଇନିଃରେକ ବିଶ୍ୱାସ୍‌କେଦା । ଆଡଃ ଆପେ ନେଆଁଁ ନେଲ୍‍କେଦ୍‌ରେହଁ, କାପେ ହେୟାତିଙ୍ଗ୍‌କେଦା ଆଡଃ ଇନିଃରେ କାପେ ବିଶ୍ୱାସ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“ୟୀଶୁ କାଜିକେଦାଏ, ଏଟାଃ ଆଡଃମିଆଁଦ୍‌ ଜନ୍‌କା କାଜି ଆୟୁମେପେ । ମିଆଁଦ୍‌ ଲୟଙ୍ଗ୍‌ ଗମ୍‌କେ ଦାଖ୍‌ବାକ୍‌ଡ଼ି ବାଇକେଦାଏ ଆଡଃ ଏନା କେସେଦ୍‌ବିୟୁର୍‍କେଦାଏ, ଘାନା ନାଗେନ୍ତେ ଗାଡା ଉର୍‌କେଦାଏ, ଆଡଃ ହରମେନ୍ତେ ମାଚେନ୍‌ ଅଡ଼ାଃ ବାଇକେଦାଏ, ଏନ୍ତେ ଇନିଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ି କାର୍‌ କାମିତାନ୍‌କକେ ଏମ୍‌କେଦ୍‌ତେ ସାଙ୍ଗିନ୍‌ ଦିଶୁମ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ଜ ଗଦଃ ସାହା ତେବାଃୟାନ୍‌ଚି, ଦାଖ୍‌ବାକ୍‌ଡ଼ିରେୟାଃ ଜ ନାମେ ନାଗେନ୍ତେ ଇନିଃ ଦାସିକକେ ଏନ୍‌ କାର୍‌ କାମିକତାଃତେ କୁଲ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","କାର୍‌କାମି ହଡ଼କଦ ଏନ୍‌ ଦାସିକକେ ସାବ୍‌କେଦ୍‌ତେ ମିହୁଡ଼୍‌କେ ଦାଲ୍‌କିୟାକ, ଆଡଃମିହୁଡ଼୍‌କେ ଗଏଃକିୟାକ, ଆଡଃ ଏଟାଃ ମିହୁଡ଼୍‌କେ ଦିରି ଚିଦ୍‌ଗିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ଏନ୍ତେ ଇନିଃ ସିଦାଏତେ ଆଡଃଗି ଆଦ୍‌କା ଦାସିକକେ କୁଲ୍‌କେଦ୍‌କଆଏ, ଆଡଃ କାର୍‌କାମି ହଡ଼କ ଇନ୍‍କୁକେହ ଏନ୍‍ଲେକାଗି ରିକାକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ଟୁଣ୍ଡୁରେ, ଇନିଃ, ଆୟାଃ ହନ୍ତେକଡ଼ାକେ କାର୍‌ କାମିହଡ଼କତାଃତେ କୁଲ୍‌କିୟାଏ, ଆଡଃ କାଜିକେଦାଏ, ‘ଇନ୍‌କୁ ହନିଙ୍ଗ୍‌କଡ଼ାକେ ମାଇନିୟାକ ।’ ");
INSERT INTO unx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ମେନ୍‌ଦ କାର୍‌କାମି ହଡ଼କ ଏନ୍‌ ହନ୍‌କେ ନେଲ୍‍କେଦ୍‍ତେ, ମେପେନ୍‌ୟାନାକ, ‘ନିଃଗି ଏନ୍‌ ଗମ୍‌କେୟାଃ ହନ୍‌ ତାନିଃ, ଦଲାବୁ ଗଜିୟା ଆଡଃ ଇନିୟାଃ ହାନାଟିଙ୍ଗ୍‌ବୁ ଇଦିୟା ।’ ");
INSERT INTO unx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଦାଖ୍‌ବାକ୍‌ଡ଼ିଏତେ ସାବ୍ଅଡଙ୍ଗ୍‌କିଃତେ ଗଏଃକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“ନାହାଁଃଦ ଦାଖ୍‌ବାକ୍‌ଡ଼ିରେନ୍‌ ଗମ୍‌କେ ହିଜୁଃରେ ଏନ୍‌ କାର୍‌କାମି ହଡ଼କକେ ଚିନାଃଏ ଚିକାକଆ ?” ମେନ୍ତେ ୟୀଶୁ କୁଲିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟା, “ଇନିଃ ଏନ୍‌ ଏତ୍‌କାନ୍‍କକେ ପୁରାଃ ସାସାତିତେ ଗଏଃକଆ ଆଡଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ି ଏଟାଃ କାର୍‌କାମି ହଡ଼କକେ ଏମାକଆ, ଅକନ୍‌କଚି ଠିକ୍‌ ନେଡାରେ ଇନିଃକେ ଆୟାଃ ହିସାକ ଏମାଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ନେଆଁଁ ଧାରାମ୍‌ପୁଥିରେ କା'ପେଚି ପାଢ଼ାଅକାଦା ? “‘ଅଡ଼ାଃ ବାଇତାନ୍‌କ ଆତମ୍‌ ଏଣ୍ଡାଗାକାନ୍ ଦିରିକେ କଚାରାଃ ଦିରିକ ବାଇକେଦା । ପ୍ରାଭୁ ଆଇଃକ୍‌ଗି ନେଆଁଁକେ ବାଇୟାକାଦା ଆଡଃ ଆବୁଆଃ ନେପେଲ୍‌ରେ ଆକ୍‌ଦାନ୍ଦାଅଗିୟା !’” ");
INSERT INTO unx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ଏନା ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆପେଏତେ ରେଜଃଆ ଆଡଃ ଅକନ୍‌ ହଡ଼କ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମନେ ଲେକା କାମିୟାଃକ ଇନ୍‌କୁକେ ଏମଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“ଏନ୍‌ ଦିରିରେ ଉୟୁଗଃନିଃ ଗୁଣ୍ଡାଅଃଆଏ ଆଡଃ ଏନା ଜେତାଏରେ ଉୟୁଗଃରେଦ ଇନିଃକେ ରିଦିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଫାରୁଶୀକ ୟୀଶୁଆଃ ଜନ୍‌କା କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ, ଇନିଃ ଆବୁକେ କାଜିୟାବୁତାନାଏ ମେନ୍ତେକ ଆଟ୍‌କାର୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ଏନାତେ ଇନ୍‌କୁ ଇନିଃକେ ସାସାବ୍‍ ସାନାଙ୍ଗ୍‌କେଦାକ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଗାଦେଲ୍‍ ହଡ଼କକେ ବରକେଦ୍‌କଆକ, ଚିୟାଃଚି ହଡ଼କ ଇନିଃକେ ନାବୀ ମେନ୍ତେକ ଆଟ୍‌କାରି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ୟୀଶୁ ଆଡଃଗି ଜନ୍‌କା କାଜିତେ ହଡ଼କକେ କାଜିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ସିର୍ମା ରାଇଜ୍‌ ମିଆଁଦ୍‌ ନେ ଲେକାନାଃ ତାନାଃ । ମିଆଁଦ୍‌ ରାଜା ହନ୍ତେକଡ଼ାରାଃ ଆଣ୍‌ଦିରେ ମାରାଙ୍ଗ୍‌ଜମେୟାଁଃ ବାଇକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ଇନିଃ କେଡ଼ାକାନ୍‍କକେ ଆଣ୍‌ଦି ଭୋଜି ଜଜମ୍‌ ନାଗେନ୍ତେ ହାକାଅ ନାଙ୍ଗ୍‌ ଆୟାଃ ଦାସିକକେ କୁଲ୍‌କେଦ୍‌କଆଏ ମେନ୍‌ଦ ଇନ୍‌କୁ ହିଜୁଃ କାକ ସାନାଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ଇନିଃ ଏଟାଃ ଦାସିକକେ ନେଆଁଁ କାଜିକେଦ୍‌ତେ ଆଡଃମିସା କୁଲ୍‌କେଦ୍‌କଆଏ, ‘ଆଇଙ୍ଗ୍‌ ମାରାଙ୍ଗ୍‌ଜମେୟାଁଃ ବାଇୟାକାଦାଇଙ୍ଗ୍‌, ଆଇଁୟାଃ ମାପ୍‌ରାଙ୍ଗ୍‌ କିରିକାନ୍‌ ଜାଁତୁକ ମାଆଃକେଦ୍‌ତେ ସବେନାଃ ବାଇସେକାଡ଼ାକାନା, ଆଣ୍‌ଦି ଭୋଜି ଜଜମ୍‌ତେ ହିଜୁଃପେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ମେନ୍‌ଦ କେଡ଼ାକାନ୍‌କ ଜେତାଏ କାକ ଉଡ଼ୁଃକେଦ୍‌ତେ ଆକଆଃ କାଜିକାମିରେ ତାଇନ୍‌ୟାନାକ, ଚିମିନ୍‌କ ଆକଆଃ ଲୟଙ୍ଗ୍‌ତେ, ଆଡଃ ଚିମିନ୍‍କ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ଏଟାଃକ ରାଜାରାଃ ଦାସିକକେ ସାବ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁକେ ସାସାତିକେଦ୍‌କଆକ ଆଡଃ ଗଏଃକେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ରାଜା ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଖିସ୍‍ୟାନାଏ ଆଡଃ ଆୟାଃ ସିପାଇକକେ କୁଲ୍‍କେଦ୍‍ତେ ଏନ୍‍ ଗଗଏଃକକେ ଜିୟନ୍‌କେଦ୍‌କଆଏ ଆଡଃ ଇନ୍‌କୁଆଃ ନାଗାର୍‌କେ ଅଣ୍ଡର୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ଏନ୍ତେ ଏନ୍‌ ଆଣ୍‌ଦି ଗମ୍‌କେ ଦାସିକକେ କାଜିୟାଦ୍‌କଆଏ, ‘ଆଣ୍‌ଦି ଜମେୟାଃଁ ବାଇୟାକାନା ମେନ୍‌ଦ କେଡ଼ାକାନ୍‌କ ଏନା ନାମେଲେକା କାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ଏନା ନାଗେନ୍ତେ ବାରିଆ ହରା ମେସାଅଃତାନ୍‌ତାଃ ସେନଃପେ ଆଡଃ ଆପେ ନାମ୍‍ତାନ୍‍ ସବେନ୍‌କକେ ଆଣ୍‌ଦି ଜମେୟାଃଁ ନାଗେନ୍ତେ ହାକାଅକପେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ଏନ୍‍ ଦାସିକ ହରାକରେ ସେନ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ନାମ୍‍କେଦ୍‍ ସବେନ୍‌ ଏତ୍‌କାନ୍‍ ଆଡଃ ବୁଗିନ୍‌ ହଡ଼କକେ ହୁଣ୍ଡିକେଦ୍‍କଆକ ଆଡଃ ଆଣ୍‌ଦି ଅଡ଼ାଃ ହଡ଼ତେ ପେରେଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ରାଜା ଜଜମ୍‌କକେ ନେନେଲ୍‍ତେ ବଲୟାନ୍‌ ଇମ୍‌ତା, ଆଣ୍‌ଦି ଲିଜାଃ କା ତୁସିଙ୍ଗ୍‌କାନ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ନେଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ଆଡଃ ଇନିଃ କୁଲିକିୟାଏ, ‘ଏ ଗାତି, ଆମ୍‌ ଆଣ୍‌ଦି ଲିଜାଃ କା ତୁସିଙ୍ଗ୍‌କେଦ୍‌ତେ ଚିଲ୍‌କାତେମ୍ ବଲଆକାନା ?’ ମେନ୍‌ଦ ଏନ୍‌ ହଡ଼ ହାପାୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ଏନ୍ତେ ରାଜା ଦାସିକକେ କାଜିକେଦ୍‌କଆଏ, ‘ଆୟାଃ ତିଃଇ କାଟା ତଲ୍‌କେଦ୍‌ତେ ନୁବାଃରେ ହୁରାଙ୍ଗ୍‌ତାଇପେ, ଏନ୍ତାଃରେ ଇନିଃ ରାଆଃୟାଏ ଆଡଃ ଡାଟା ରିଦେୟାଏ ।’” ");
INSERT INTO unx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ଆଡଃ ୟୀଶୁ କାଜିଟୁଣ୍ଡୁକେଦାଏ, “ପୁରାଃକଦ ହାକାଅକାନା ମେନ୍‌ଦ ହୁଡିଙ୍ଗ୍‌ଲେକାକ ସାଲାକାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ଏନ୍ତେ ଫାରୁଶୀକ ସେନଃକେଦ୍‌ତେ, ଆବୁ ଚିଲ୍‍କାତେ ୟୀଶୁକେ ଆୟାଃ କାଜିତେବୁ ସାବିଆ, ମେନ୍ତେକ ରଜୋଟକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ଇନ୍‌କୁ ହେରୋଦ୍‌ଆଃ ହଡ଼କଲଃ, ଆକଆଃ ଚେଲାକକେ ୟୀଶୁତାଃତେକ କୁଲ୍‌କେଦ୍‍କଆ ଆଡଃ ଇନ୍‌କୁ ୟୀଶୁକେ କାଜିକିୟାକ, “ହେ ଗୁରୁ, ଆଲେ ସାରିତାନାଲେ, ଆମ୍‌ ସାର୍‌ତିଙ୍ଗ୍‌ ହଡ଼ ତାନ୍‌ମେ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାର୍‌ତି ହରା ଇତୁଆଃମେ ଆଡଃ ଜେତାଏକେ କାମ୍‌ ବରୱା, ଚିୟାଃଚି ଆମ୍‌ ହଡ଼କଆଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ କାମ୍‌ ନେଲାଃ । ");
INSERT INTO unx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ଆମ୍‌ ଆଲେକେ କାଜିୟାଲେମ୍‌, ଆମ୍‌ ଚିକ୍‌ନାଃମ୍‌ ଉଡ଼ୁଃତାନା ? କାଇସାର୍‌କେ ଆଇନ୍‌ ଲେକାତେ କାର୍‌ ପାଏସା ଏମଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଚି କାହା ?” ");
INSERT INTO unx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁଆଃ ଏତ୍‌କାନାଃ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ କାଜିୟାଦ୍‍କଆଏ, “ହେ ବେଦାହଡ଼କ ଚିନାଃ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ ଚିଟାଇଙ୍ଗ୍‌ ନାଗେନ୍ତେ ବିଡ଼ାଅତାନାପେ ? ");
INSERT INTO unx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","କାର୍‌ ପାଏସା ଏମ୍‌ରେୟାଃ ସିକା ମିଆଁଦ୍‌ ଏମାଇଙ୍ଗ୍‌ପେ ।” ଏନ୍ତେ ଇନ୍‌କୁ ମୁସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକା ଇନିଃତାଃତେକ ଆଉକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆଏ, “ନେ ସିକାରେ ଅକଏୟାଃ ମୁରୁତ୍‌ ଆଡଃ ନୁତୁମ୍‌ ମେନାଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ଇନ୍‌କୁ କାଜିକିୟାକ, “କାଇସାର୍‌ଆଃ,” ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଅକ୍‌ନାଃ କାଇସାର୍‌ଆଃ ଏନା କାଇସାର୍‌କେ ଏମାଇପେ, ଅକ୍‌ନାଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଏନା ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଏମାଇପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ଆଡଃ ଇନ୍‌କୁ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ହାଏକାଟ୍‍ୟାନାକ ଆଡଃ ଇନିଃକେ ବାଗିକେଦ୍‌ତେ ସେନଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ଗି ଚିମିନ୍‌ ସାଦୁକିକ ୟୀଶୁତାଃତେକ ହିଜୁଃୟାନା ଆଡଃ ଇନ୍‌କୁ ଜୀଉବିନିରିଦ୍‌ ବାନଆଃ ମେନ୍ତେକ କାଜିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ଇନ୍‌କୁ କାଜିକିୟାକ, “ହେ ଗୁରୁ, ଜେତାଏ ହଡ଼ ବେଗାର୍‌ ହନ୍‌ଗାଁଣାତେ ଗଜଃରେଦ, ହାଗାତେ ଇନିୟାଃ କୁଡ଼ିକେ ଆଣ୍‌ଦିୟଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଆଡଃ ଗଜାକାନ୍‌ ହାଗାତେୟାଃ ନାଙ୍ଗ୍‌ ହନ୍‌ଗାଁଣା ହାରାକକାଏ ମେନ୍ତେ ମୁଶା ନାବୀ କାଜିକାଦା । ");
INSERT INTO unx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ନେଲେମେ, ଆଲେତାଃରେ ସାତ୍‌ ହାଗିୟା ତାଇକେନାକ ମାରାଙ୍ଗ୍‌ନିଃ ଆଣ୍‍ଦିକେଦ୍‍ତେ ବେଗାର୍‌ ହନ୍‌ଗାଁଣାତେ ଗଏଃୟାନାଏ, ଆଡଃ ଏନ୍‌ ରାଣ୍ଡିକୁଡ଼ିକେ ହାଗାତେ ଆଣ୍‌ଦିୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ଏନ୍‌ଲେକାଗି ଏଟାଃ ହାଗାତେଲଃ ଆଡଃ ଆପିୟାନିଃଲଃ ହବାୟାନା, ଟୁଣ୍ଡୁରେ ସାତ୍‌ ହାଗିୟାକ ଇନିଃକେ ଆଣ୍‍ଦିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ଆଡଃ ସବେନ୍‌କଆଃ ତାୟମ୍‌ତେ ଏନ୍‌ ରାଣ୍ଡି କୁଡ଼ିୟଗି ଗଏଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ଏନ୍ତେ ଜୀଉବିନିରିଦ୍‌ ଇମ୍‌ତା ଏନ୍‌ କୁଡ଼ି ଅକଏୟାଃ କୁଡ଼ିତେ ହବାଅଃଆଏ ? ସବେନ୍‍କଦ ଇନିଃକେ ଆଣ୍‍ଦିୟାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଆପେ ଧାରାମ୍‌ପୁଥି ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପେଡ଼େଃ କାପେ ସାରିୟା ଏନା ନାଗେନ୍ତେପେ ଆଦାକାନା । ");
INSERT INTO unx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ଜୀଉବିନିରିଦ୍‌କେଦ୍‌ତେ ଜେତାଏ କାକ ଆଣ୍‍ଦିନାଃ, ଚାଏ ଆଣ୍‌ଦି କାକ ଏମଃଆ, ମେନ୍‌ଦ ଇନ୍‌କୁ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌ଲେକାକ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ଆଡଃ ଗଜାକାନ୍‌କଆଃ ଜୀଉବିନିରିଦ୍‌ ବିଷାଏରେ ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିୟାକାଦ୍‍ କାଜିକେ କାପେଚି ପାଢ଼ାଅକାଦା ? ");
INSERT INTO unx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ଆଇଙ୍ଗ୍‌ ଆବ୍ରାହାମ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଇସାକ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଡଃ ଯାକୁବ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଙ୍ଗ୍‌ ।’ ଇନିଃ ଗଏଃକାନ୍‍କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ନାହାଁଲିଃ ମେନ୍‌ଦ ଜୀନିଦ୍‌କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନିୟାଃ ଇନିତୁତେ ହାଏକାଟ୍‍ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ୟୀଶୁ ସାଦୁକିକକେ ହାପାକେଦ୍‍କଆଏ ମେନ୍ତେ ଫାରୁଶୀକ ଆୟୁମ୍‌କେଦ୍‌ଚି ହୁଣ୍ଡିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ଆଡଃ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ ଆଇନ୍‌ ଇତୁନିଃ ୟୀଶୁକେ ଚିଟାଇ ନାଗେନ୍ତେ ବିଡ଼ାଅକିୟାଏ ଆଡଃ କୁଲିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ହେ ଗୁରୁ, ମୁଶାରାଃ ଆଇନ୍‌ରେୟାଃ ମାରାଙ୍ଗ୍‌ ଆନ୍‌ଚୁ ଅକ୍‌ନାଃ ତାନାଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “‘ଆମାଃ ସବେନ୍‌ ମନ୍‌ତେ, ଆମାଃ ସବେନ୍‌ ଜୀଉତେ ଆଡଃ ଆମାଃ ସବେନ୍‌ ମନ୍‌ତେ ପ୍ରାଭୁ ଆମାଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଦୁଲାଡ଼ିମେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ନେଆଁଁଗି ମାରାଙ୍ଗ୍‌ ଆଡଃ ପାହିଲା ଆନ୍‌ଚୁ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ଆଡଃମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ଆନ୍‌ଚୁ ଏନ୍‍ଲେକାଗିୟା, ‘ଆମାଃ ହପର୍‌ଜାପାଃରେନିଃକେ ଆମାଃ ଲେକା ଦୁଲାଡ଼ିମେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ନେ ବାରିୟା ଆନ୍‌ଚୁରେ ମୁଶାରାଃ ଆଇନ୍‌ ଆଡଃ ନାବୀକଆଃ ଇନିତୁରେ ଆସ୍ରାଏତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ଫାରୁଶୀକ ହୁଣ୍ଡିୟାନ୍‌ ଇମ୍‌ତା ୟୀଶୁ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆଏ ? ");
INSERT INTO unx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ଆପେ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ବିଷାଏରେ ଚିନାଃପେ ଉଡ଼ୁଃତାନା ? ଇନିଃ ଅକଏୟାଃ ହନ୍‌ ତାନିଃ ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଦାଉଦ୍‌ଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, “ଦାଉଦ୍‌, ମାସିକେ ‘ଆଇଁୟାଃ ପ୍ରାଭୁ’ ମେନ୍ତେ ଚିନାଃମେନ୍ତେ ତାମ୍‌ କାଜିକିୟାଏ ? ଚିୟାଃଚି ପାବିତାର୍‌ ଆତ୍ମାତେ ଇନିଃ ଅଲାକାଦାଏ, ");
INSERT INTO unx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘ପ୍ରାଭୁ ଆଇଁୟାଃ ପ୍ରାଭୁକେ କାଜିକିୟା, ଆଇଙ୍ଗ୍‌ ଆମାଃ ବାଇରିକକେ ଆମାଃ କାଟା ଲାତାର୍‌ରେ ଆଉରି ଦହକ ଜାକେଦ୍‌ ଆମ୍‌ ଆଇଁୟାଃ ଜମ୍‌ତିସାଃରେ ଦୁବାକାନ୍‌ମେ ।’” ");
INSERT INTO unx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“ଦାଉଦ୍‌ ଖ୍ରୀଷ୍ଟ୍‌କେ ‘ଆଇଁୟାଃ ପ୍ରାଭୁ’ ମେତାଇତାନ୍‌ରେଦ, ଇନିଃ ଚିଲ୍‍କାତେ ଇନିୟାଃ ହନ୍‌ ତାନିଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ଆଡଃ ଜେତାଏ ମିଆଁଦ୍‌ କାଜିୟ ୟୀଶୁକେ କାକ କାଜିରୁହାଡ଼୍‌ ଦାଡ଼ିକେଦା, ଏନ୍‍ ହୁଲାଙ୍ଗ୍‌ତାଃଏତେ ଜେତାଏ ଇନିଃକେ ଜେତ୍‌ନାଃ କୁଲିନାଙ୍ଗ୍‌ କାକ ସାହାଁସ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ଏନ୍ତେ ୟୀଶୁ ଏନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କକେ ଆଡଃ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‍କଆଏ, ");
INSERT INTO unx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ମୁଶାରାଃ ଆଇନ୍‌ ଇତୁରାଃ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ ଇନିତୁକ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ଏନା ନାଗେନ୍ତେ, ଆପେ ନେଆଁଁ ମାନାତିଙ୍ଗ୍‌ପେ ମେନ୍ତେକ କାଜିରେଦ ଏନ୍‌ ସବେନାଃ ମାନାତିଙ୍ଗ୍‌ପେ, ମେନ୍‌ଦ ଇନ୍‌କୁଆଃ କାମିଲେକା ଆଲ୍‌ପେ କାମିୟା, ଇନ୍‌କୁ କାଜିଦକ କାଜିୟା ମେନ୍‌ଦ କାକ କାମିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ଇନ୍‌କୁ ଆକଆଃ ଇନିତୁକେ ହଡ଼କଆଃ ତାରାନ୍‌ ଚେତାନ୍‌ରେ ହାମ୍ବାଲ୍‍ତେୟାଃକ ଲାଦିତାନା, ମେନ୍‌ଦ ଇନ୍‌କୁ ଏନାକେ ଆକଆଃ ମିଆଁଦ୍‌ ସାର୍‌ସାର୍‌ତେହ ଉଠାଅକେଦ୍‌ତେ ଗଅଃଇଦି ନାଙ୍ଗ୍‌ କାକ ଦେଙ୍ଗାଃ । ");
INSERT INTO unx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ହଡ଼କ ଆଲେକେ ନେଲ୍‌ଲେକାକ ମେନ୍ତେ ଇନ୍‌କୁ ଆକଆଃ ସବେନ୍‌ କାମିକ କାମିୟାଃ । ନେଲ୍‌କପେ, ଇନ୍‍କୁଦ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ତେୟାଃ ଆକଆଃ ମଲଙ୍ଗ୍‌କରେକ ତଲେୟା ଆଡଃ ଆକଆଃ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃରେୟାଃ ଝାଲେର୍‌କେକ ଜିଲିଙ୍ଗ୍‌ଆଃଁ । ");
INSERT INTO unx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ଆଡଃ ଇନ୍‌କୁ ମାରାଙ୍ଗ୍‌ଜମେୟାଁଃତାଃରେ ଚେତାନ୍‌ ଠାୟାଦ୍‌ରେ ଆଡଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଆୟାର୍‌ରେ ଦୁବ୍‌ନାଙ୍ଗ୍‌ ସୁକୁକଆ । ");
INSERT INTO unx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ଆଡଃ ଇନ୍‌କୁ ହଡ଼କତାଃଏତେ ପିଟ୍‌ ପିଡ଼ିକରେ ଜହାର୍‌ତେଲା ଆଡଃ ‘ହେ ଗୁରୁ’ ମେନ୍ତେ କାଜିୟାଲେକାକ ନେଆଁଁ ସୁକୁଆଃକ । ");
INSERT INTO unx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ମେନ୍‌ଦ ଆପେ ‘ହେ ଗୁରୁ’ ମେନ୍ତେ ଆଲ୍‌ପେ ନୁତୁମଃଆ, ଚିୟାଃଚି ଆପେୟାଃ ଇତୁନିଃଦ ମିଆଁଦ୍‌ଗିଆଏ, ଆଡଃ ଆପେ ସବେନ୍‌କ ହାଗା ତାନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ଆଡଃ ଅତେରେ ଜେତାଏକେ ‘ଆବା’ ମେନ୍ତେ ଆଲ୍‌ପେ କାଜିୟା, ଆପେୟାଃ ଆପୁଦ ମିଆଁଦ୍‌ଗିଆଏ ଆଡଃ ଇନିଃ ସିର୍ମାରେ ମେନାଇୟା । ");
INSERT INTO unx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ଆଡଃ ଆପେ ହଡ଼କଆଃ ‘ଗମ୍‌କେ’ ମେନ୍ତେ ଆଲ୍‌ପେ ନୁତୁମଃଆ, ଚିୟାଃଚି ଆପେୟାଃ ଗମ୍‌କେଦ ମିଆଁଦ୍‌ଗିଆଏ, ଇନିଃ ମାସି ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ଆଡଃ ଆପେୟାଃ ଥାଲାରେ ସବେନ୍‌କଏତେ ମାରାଙ୍ଗ୍‌ନିଃ ଆପେୟାଃ ସୁସାର୍‌ନିଃ ହବାଅଃକାଏ । ");
INSERT INTO unx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଆଡଃ ଜେତାଏ ଆପାନ୍‌କେ ମାରାଙ୍ଗ୍‌ୟେଁନ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଇନିଃ ହୁଡିଙ୍ଗ୍‌ୟେଁନ୍‌କାଏ, ଆଡଃ ଜେତାଏ ଆପାନ୍‌କେ ହୁଡିଙ୍ଗ୍‌ୟେଁନ୍‌ନିଃ, ମାରାଙ୍ଗ୍‌ୟେଁନ୍‌କାଏ । ");
INSERT INTO unx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ଏ ହସଡ଼ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଆପେଦ ହଡ଼କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ସିର୍ମା ରାଇଜ୍‌ରେୟାଃ ଦୁଆର୍‍ପେ ହାଣ୍ଡେଦ୍‌ ତାନାଃ, ଆପେଦ ଆପେଗି ଏନାରେ କାପେ ବଲତାନା ଆଡଃ ବଲ ସାନାଙ୍ଗ୍‌ତାନ୍‍କକେ କାପେ ବଲ ଇଚିକୁତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ଏ ହସଡ଼ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଚିୟାଃଚି ଆପେ ବେଦାତେ ଜିଲିଙ୍ଗ୍‌ ଜିଲିଙ୍ଗ୍‌ଗି ବିନ୍ତିୟାପେ ଆଡଃ ରାଣ୍ଡିକୁଡ଼ିକଆଃ ଅଡ଼ାଃକ ଉଦେତାନାପେ, ଏନାମେନ୍ତେ ଆପେ ଆଦ୍‌କା ସାଜାଇପେ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ଏ ହସଡ଼ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଆପେଦ ମିଆଁଦ୍‌ ହଡ଼କେ ଯିହୁଦୀ ଧାରାମ୍‌ରେ ମେସାଇ ନାଗେନ୍ତେ ଦରେୟା ଆଡଃ ଗଟା ଅତେଦିଶୁମ୍‌ପେ ହନର୍‌ତାନା, ଆଡଃ ଚିମ୍‌ତାଙ୍ଗ୍‌ ଇନିଃ ଯିହୁଦୀ ଧାରାମ୍‌ରେ ମେସାୟାନ୍‌ରେ, ଆପେଏତେ ବାର୍‌ଗୁନା ଇମ୍‍ନାଙ୍ଗ୍‌ ନାରାକ୍‌ରେ ସାଜାଇ ନାମେ ନାଗେନ୍ତେପେ ଦେଙ୍ଗାଇତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ଆନ୍ଧା ହରା ଆୟାର୍‌ଇଦିକ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ‘ଜେତାଏ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେୟାଃ କିରିୟାଏରେଦ ଇନିଃ ମାନାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେ କାଏ ତଲଃଆ ମେନ୍‌ଦ ଜେତାଏ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେୟାଃ ସୋନାରାଃ କିରିୟା ଜମେରେଦ ଇନିଃକେ ଏନା ମାନାତିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ଏ କା ନେଲ୍‌ ଦାଡ଼ିତାନ୍‌ ଡଣ୍ଡକ, ସୋନା ମାରାଙ୍ଗ୍‌ ଚି ସୋନାକେ ପାବିତାର୍‌କାଦ୍‌ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃ ମାରାଙ୍ଗ୍‌ ତାନାଃ ? ");
INSERT INTO unx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ଆଡଃଗି ଇତୁଆଃପେ, ‘ଜେତାଏ ବେଦିରାଃ କିରିୟାଏରେଦ ଇନିଃକେ ଏନା ମାନାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେ କା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ମେନ୍‌ଦ ଜେତାଏ ଏନାରେ ରାକାବାକାନ୍‍ ଦାନ୍‌ରାଃ କିରିୟାଏରେଦ ଇନିଃକେ ଏନା ମାନାତିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ଏ ମେଦ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିତାନ୍‌ ହଡ଼କ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଏନ୍‌ ଦାନ୍‌ ମାରାଙ୍ଗ୍‌ଆଁଚି ଦାନ୍‌କେ ପାବିତାର୍‌ ରିକାଏତାନ୍‌ ଏନ୍‍ ବେଦି ମାରାଙ୍ଗ୍‌ଆଁ, ନେ ବାରାନାଃରେ ଅକ୍‌ନାଃ ମାରାଙ୍ଗ୍‌ଆଁ ? ");
INSERT INTO unx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ନେଆଁଁମେନ୍ତେ ଜେତାଏ ବେଦିରେୟାଃ କିରିୟାଏରେଦ, ଇନିଃ ଏନାରେୟାଃ ଆଡଃ ଏନାରେ ରାକାବାକାନ୍‌ତେୟାଃ ସବେନାଃରାଃ କିରିୟାଏତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ଜେତାଏ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଃ କିରିୟାଏରେଦ ଇନିଃ ଏନାରେୟାଃ ଆଡଃ ଏନାରେ ତାଇନଃତାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କିରିୟାଏତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ଆଡଃ ଜେତାଏ ସିର୍ମାରେୟାଃ କିରିୟାଏରେଦ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଜ୍‌ଗାଦିରେୟାଃ ଆଡଃ ଏନାରେ ଦୁବାକାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନୁତୁମ୍‌ରେ କିରିୟାଏତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ଏ ହସଡ଼ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଆପେଦ ପୁଦ୍‌ନା, ପାନ୍‌ମୁହୁରି ଆଡଃ ଜୀରାରାଃ ଗେଲ୍‌ ହାନାଟିଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌କେପେ ଏମାଇତାନା, ମେନ୍‌ଦ ମୁଶାରାଃ ଆନ୍‌ଚୁରେୟାଃ ମାରାଙ୍ଗ୍‌କାଜି, ନ୍ୟାୟ ବିଚାର୍‌, ଲିବୁଇ ଆଡଃ ପାତିୟାର୍‌ରଃ ଲେକାନ୍‌ କାଜିକେ ବାଗିୟାକାଦାପେ, ମେନ୍‌ଦ ଏଟାଃତେୟାଃକକେ କା ବାଗିକେଦ୍‌ତେ ନେ ସବେନାଃକେ ମାନାତିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ଏ କାଣାଁ ହରା ଆୟାର୍‌ଇଦିକ, ଆପେଦ ସିକିଣିଁକପେ ଛାନାଅତାନା ଆଡଃ ଉଁଟ୍‌କପେ ଉଦ୍‌କତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ଏ ହସଡ଼ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଚିୟାଃଚି ଆପେଦ ଡୁବ୍‌ନି ଆଡଃ ଥାଡ଼ିରାଃ ବାହାରିକପେ ଗାସାର୍‍ ଆବୁଙ୍ଗ୍‌ ତାନା । ମେନ୍‌ଦ ଏନାରେୟାଃ ଭିତାର୍‌ ହିସ୍‌ଙ୍ଗା ଆଡଃ ଏତ୍‍କାନାଃ ପେରେଜାକାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ହେ କାଣାଁ ଫାରୁଶୀକ ସିଦାତେ ଡୁବ୍‌ନି ଆଡଃ ଥାଡ଼ିରାଃ ଭିତାର୍‌ ଆବୁଙ୍ଗ୍‌ଗାସାରେପେ ଏନ୍ତେ ଏନାରେୟାଃ ବାହାରିହଁ ଆବୁଙ୍ଗ୍‌ଗାସାରଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ହେ ହସଡ଼ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ, ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଆପେ ଚୁନାତେ ଜଲମାକାନ୍‍ କାବାର୍‌ ଲେକାନ୍‌କ ତାନ୍‌ପେ, ଏନା ବାହାରି ନେପେଲ୍‍ରେଦ ପୁରାଃ ବୁଗିନ୍‍ଗି ନେଲଃତାନା ମେନ୍‌ଦ ଏନାରେୟାଃ ଭିତାର୍‌ରେ ଗଜାକାନ୍‍କଆଃ ଜାଙ୍ଗ୍‌କ ଆଡଃ ସବେନାଃ କା ଫାର୍‌ଚିତେ ପେରେଜାକାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ନେ ଲେକାତେ ଆପେ ବାହାରି ନେପେଲ୍‌ରେ ହଡ଼କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଧାର୍‌ମାନ୍‌ଗିପେ ନେଲଆଃ ମେନ୍‌ଦ ମନ୍‌ ଭିତାର୍‌ରେ ବେଦାତେ ଆଡଃ ଏତ୍‌କାନ୍‌ତେ ପେରେଜାକାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ଏ ହସଡ଼ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଆପେଦ ନାବୀକଆଃ ନାଗେନ୍ତେ ବୁଗିନ୍‌ କାବାର୍‌ ବାଇକେଦ୍‌ତେ ଧାର୍‌ମାନ୍‌କଆଃ ତପାଗାଡ଼ାରେ ନୁତୁମ୍‌ ଅଲାକାନ୍‌ ଖୁଣ୍ଟୁକେପେ ସିଙ୍ଗ୍‌ରାଅ ତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ଆଡଃ କାଜିତାନାପେ, ‘ଆବୁ ଆବୁଆଃ ହାଡ଼ାମ୍‌କଆଃ ଦିପିଲିରେବୁ ତାଇନ୍‌କାନ୍‌ରେ, ଆବୁ ଇନ୍‌କୁ ଲେକା କାବୁ କାମିକାଦ୍‌ତେୟାଃ ଆଡଃ ନାବୀକଆଃ ଗନଏଃ ମାୟୋମ୍‌ ଲିଙ୍ଗିରେ ଇନ୍‌କୁଲଃ କାବୁ ମେସାକାନ୍‌ତେୟାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ନେଆଁଁତେ ଆପେଗି ନାବୀକକେ ଗଏଃକେନ୍‌କଆଃ କିଲିକ ତାନ୍‌ପେ ମେନ୍ତେ ଆପେୟାଃ ନାଗେନ୍ତେ ଗାୱାପେ ଏମ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ଆପେଗି ହାଡ଼ାମ୍‌କଆଃ ପାପ୍‌ରାଃ ସସଙ୍ଗ୍‌ତେୟାଃ ପେରେଜେପେ । ");
INSERT INTO unx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ଏ ବିଙ୍ଗ୍‌କ, ଆପେ ବିଙ୍ଗ୍‌କଆଃ ହନ୍‌କ ! ଆପେ ନାରାକ୍‌ରେୟାଃ ସାଜାଇଏତେ ଚିଲ୍‍କାପେ ବାଞ୍ଚାଅଃଆ ? ");
INSERT INTO unx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆପେତାଃତେ ନାବୀକ, ସେଣାଁଁନ୍‌କ, ଆଡଃ ଇତୁକକେ କୁଲ୍‌କତାନାଇଙ୍ଗ୍‌, ଆଡଃ ଆପେ ଇନ୍‌କୁଏତେ ଚିମିନ୍‍କକେ ଗଏଃକଆପେ ଆଡଃ କ୍ରୁଶ୍‍ରେପେ କିଲାକଆ ଆଡଃ ଏଟାଃକକେ ଆପେୟାଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେପେ ହାଁଣ୍‌ସାକଆ ଆଡଃ ସାହାର୍‌ ସାହାର୍‌ଏତେ ହାର୍‍କତାନ୍‌ଲଃ ସିଗିଦ୍‌‍କଆପେ । ");
INSERT INTO unx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ଆଡଃ ନେ ଲେକାତେ ଧାର୍‌ମାନ୍‌ ହାବିଲ୍‌କେ ଗଏଃକିଃତାଃଏତେ ମାନ୍ଦିର୍‌ରେୟାଃ ପାବିତାର୍‌ ଠାୟାଦ୍‌ ଆଡଃ ଦାଣେଁରାକାବ୍‌ ବେଦିରାଃ ଥାଲାମାଲାରେ ଆପେ ଗଏଃକିଃ ବେର୍‌ଖିୟଆଃ ହନ୍ତେକଡ଼ା ଜିଖ୍‌ରିୟା ଜାକେଦ୍‌ ଆଡଃ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ଧାର୍‌ମାନ୍‌ ହଡ଼କକେ ଗଏଃକେଦ୍‌କ ନାଗେନ୍ତେ ଆପେ ସାଜାଇପେ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ନେ ସବେନ୍‌ ହଡ଼ଗଏଃକଆଃ ସାଜାଇ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କକେ ନାମଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ହେ ଯୀରୁଶାଲେମ୍‌, ହେ ଯୀରୁଶାଲେମ୍‌, ଆମ୍‌ ନାବୀକକେମ୍‌ ଗଏଃକେଦ୍‌କଆ ଆଡଃ ଆମ୍‌ତାଃତେ କୁଲାକାନ୍‌କକେ ଚିଦ୍‌ଗିଗଏଃ କେଦ୍‌କଆମ୍‌, ଏଙ୍ଗାସିମ୍‌ ଆୟାଃ ହନ୍‌କକେ ଆପ୍‌ରବ୍‌ ଲାତାର୍‌ରେ ଆବ୍‌ରୁମ୍‌ ତପାକତାନ୍‌ଲେକା ଚିମିନ୍‌ସା ଆଇଙ୍ଗ୍‌ ଆମାଃ ହନ୍‌କକେ ହୁଣ୍ଡିସାନାଙ୍ଗ୍‌କେଦାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଆପେ କାପେ ସାନାଙ୍ଗ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ନେଲେପେ, ଆପେୟାଃ ମାନ୍ଦିର୍‌ ଆପେତାଃରେ ହାଦୁଡ଼୍‌ନାଙ୍ଗ୍‌ ବାଗିୟଃତାନା । ");
INSERT INTO unx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ‘ପ୍ରାଭୁଆଃ ନୁତୁମ୍‌ତେ ହିଜୁଃତାନ୍‌ନିଃକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଶିଷ୍‌ ଏମାଇକାଏ’ ମେନ୍ତେ ଆପେ ଆଉରି କାଜି ଜାକେଦ୍‌ ନାହାଁଃଏତେ ଆଡଃ ଆଇଙ୍ଗ୍‌କେ କାପେ ନେଲିୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନଃତାନ୍‌ ଦିପିଲିରେ ଆୟାଃ ଚେଲାକ, ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ବାଇୟାକାନ୍‌ତେୟାଃ, ଆଡଃ ମାପ୍‌ରାଙ୍ଗ୍‌ ଅଡ଼ାଃକ ଉଦୁବାଇ ନାଗେନ୍ତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଆପେ ଚିନାଃ ଏନ୍‍ ସବେନାଃ କାପେ ନେଲେତାନା ? ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଏନାରେ ଦିରି ଚେତାନ୍‍ ଦିରି ତିରିୟାଁକାନ୍‍ କା ତାଇନା, ସବେନାଃ ହାଦୁଡ଼ଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ୟୀଶୁ ଜାଇତୁନ୍‌ ବୁରୁରେ ଦୁବାକାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଚେଲାକ ଏସ୍‍କାର୍‍ରେ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା ଆଡଃ କୁଲିକିୟାକ, “ଆଲେକେ ଉଦୁବାଲେମେ ନେ ସବେନାଃ ଚିଉଲା ହବାଅଃଆ ଆଡଃ ଆମାଃ ହିଜୁଃରେୟାଃ ଚିହ୍ନାଁ ଚିନାଃ ତାନାଃ ଆଡଃ ଅତେଦିଶୁମ୍‌ରେୟାଃ ଟୁଣ୍ଡୁ ଦିପିଲି ଚିଉଲା ହବାଅଆଃ ?” ");
INSERT INTO unx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ଚିର୍ଗାଲାକାନ୍‍ପେ, ଜେତାଏ ଆଲକାକ ବେଦାପେକା । ");
INSERT INTO unx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ଚିୟାଃଚି ପୁରାଃ ହଡ଼କଦ ଆଇଁୟାଃ ନୁତୁମ୍‍ତେକ ହିଜୁଃଆ ଆଡଃ ‘ଆଇଙ୍ଗ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ତାନିଙ୍ଗ୍‌’ ମେନ୍ତେକ କାଜିୟା ଆଡଃ ପୁରାଃକକେ ବେଦାକଆକ । ");
INSERT INTO unx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ଆପେ ମାପାଃତୁପୁଇଙ୍ଗ୍‌ ଆଡଃ ମାପାଃତୁପୁଇଙ୍ଗ୍‌ରାଃ କାଜିପେ ଆୟୁମେରେଦ, ଚିର୍ଗାଲାକାନ୍‌ପେ, ବରତେ ଆଲ୍‌ପେ ଆକ୍‌ବାକାଅଆଃ । ନେଆଁଁ ସବେନାଃଦ ହବାଅଃଗି ଲାଗାତିୟାଃଁ, ମେନ୍‌ଦ ଏନ୍‌ ଦିପିଲିହ ଟୁଣ୍ଡୁ ନାହାଁଲାଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଚିୟାଃଚି ଦିଶୁମ୍‌ ବିରୁଧ୍‌ରେ ଦିଶୁମ୍‌ ଆଡଃ ରାଇଜ୍‌ ବିରୁଧ୍‌ରେ ରାଇଜ୍‌ ଲାଡ଼ାଇ ହବାଅଆଃ, ସବେନ୍‌ ଠାୟାଦ୍‌ରେ ଅତେ ଏକ୍‌ଲାଅଃଆ ଆଡଃ ରିଙ୍ଗାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ମେନ୍‌ଦ ନେ ସବେନାଃ ହନ୍‌ ଜାନାମଃ ଇମ୍‌ତାରାଃ ଦୁକୁରେୟାଃ ଏନେଟେଦ୍‌ ଲେକାନାଃ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ଏନ୍ତେ ଇନ୍‌କୁ ଆପେକେ ସାସାତିପେ ନାଗେନ୍ତେକ ଜିମାପେୟା ଆଡଃକ ଗଏଃପେୟା, ଆଡଃ ଆପେ ଆଇଙ୍ଗ୍‌ତାଃରେ ପାତିୟାର୍‌କାଦ୍‌ ନାଗେନ୍ତେ ସବେନ୍‌ ହଡ଼କ ଆପେକେକ ହିଲାଙ୍ଗ୍‌ପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ଏନ୍‍ ଦିପିଲିରେ ପୁରାଃ ହଡ଼କ ଆକଆଃ ବିଶ୍ୱାସ୍‌କ ଆଦେୟା, ଆଡଃ ଆକ ଆକଗି ମିହୁଡ଼୍‌ ଆଡଃମିହୁଡ଼୍‌କେ ଏମ୍‌ଏଣ୍ଡାଗିୟାକ ଆଡଃ ହିଲାଙ୍ଗ୍‌ଇଆକ । ");
INSERT INTO unx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ଆଡଃ ପୁରାଃ ହସଡ଼ ନାବୀକ ହିଜୁଃଆ ଆଡଃ ଇନ୍‌କୁ ପୁରାଃ ହଡ଼କକେ ବେଦାକଆକ । ");
INSERT INTO unx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ଚିୟାଃଚି ଏତ୍‌କାନ୍‌ ନିତିର୍‌ୟାନ୍‍ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନାଙ୍ଗ୍‌ ପୁରାଃ ହଡ଼କଆଃ ଦୁଲାଡ଼୍‌ ହୁଡିଙ୍ଗ୍‌ଇଦିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ମେନ୍‌ଦ ଜେତାଏ ଟୁଣ୍ଡୁ ଜାକେଦ୍‌ ସାହାତିଙ୍ଗ୍‌ତାନ୍‌ଲଃ ତିଙ୍ଗୁ କେଟେୟାକାନ୍ ତାଇନ୍‌ରେଦ ବାଞ୍ଚାଅଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ବିଷାଏରେ ନେ ସୁକୁକାଜି ଏଟାଃ ଏଟାଃ ଜାଗାର୍‌ତାନ୍‌ ସବେନ୍‌ ହଡ଼କଆଃ ଗାୱା ନାଗେନ୍ତେ, ଗଟା ଅତେଦିଶୁମ୍‌ରେ ଉଦୁବଃଆ ଆଡଃ ଏନ୍ତେ ଟୁଣ୍ଡୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ଆପେ ଚିମ୍‌ତା ଏନ୍‌ ‘ଅଡ଼େଜଃ ସତ୍‌ରାକାନ୍‌ନିଃ’ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଃ ପାବିତାର୍‌ ଠାୟାଦ୍‌ରେ ତିଙ୍ଗୁଆକାନ୍‍ପେ ନେଲିୟା,” ନେ କାଜି ଅକ୍‌ନାଃଚି ଦାନିୟେଲ୍‌ ନାବୀ କାଜିକାଦାଏ, ପାଢ଼ାଅନିଃ ନେଆଁଁରାଃ ମୁଣ୍ଡି ଆଟ୍‌କାର୍‍ଉରୁମେକାଏ । ");
INSERT INTO unx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“ଇମ୍‌ତା ଯିହୁଦା ପାର୍‌ଗାନ୍‌ରେ ତାଇନଃତାନ୍‌କ ବୁରୁତେକ ନିର୍‌ତେବାଃକା । ");
INSERT INTO unx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ଅକ ହଡ଼ ଆୟାଃ ଅଡ଼ାଃ ସାଡ଼୍‌ମିରେ ମେନାଇୟାଃ ଇନିଃ ଆୟାଃ ଜେତ୍‌ନାଃ ଇଦିମେନ୍ତେ ଅଡ଼ାଃଏତେ ଆଲକାଏ ଆଡ଼୍‌ଗୁଃକା । ");
INSERT INTO unx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଆଡଃ ପିଡ଼ି ଲୟଙ୍ଗ୍‌ରେ ମେନାଇନିଃ ଆୟାଃ ଲିଜାଃ ଇଦି ନାଗେନ୍ତେ ଆଲକାଏ ରୁହାଡ଼୍‌କା । ");
INSERT INTO unx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ମେନ୍‌ଦ ଏନ୍‍ ଦିପିଲିରେନ୍‌ ବାର୍ଜିଆକାନ୍‍ କୁଡ଼ିକଆଃ ଆଡଃ ତଆ ନୁନୁଆକତାନ୍‍ ଏଙ୍ଗାକଆଃ ନାଗେନ୍ତେ ଚିମିନ୍‌ ବରୱାନ୍‌ଗି ଦୁକୁ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ଆପେ ନିର୍‌ସେନଃ ନାଗେନ୍ତେ ରାବାଙ୍ଗ୍‌ସାହା ଚାଏ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆଲକା ହବାଅଃକା ମେନ୍ତେ ଆପେୟାଃ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ବିନ୍ତିପେ । ");
INSERT INTO unx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ଚିୟାଃଚି ଏନ୍‍ ଦିପିଲିରେଦ ମାରାଙ୍ଗ୍‌ ଦୁକୁ ହବାଅଆଃ ଏନା ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ ନେ'ଲେକାନାଃ ଅତେଦିଶୁମ୍‌ରେୟାଃ ଏନେଟେଦ୍‌ଏତେ ନାହାଁଃ ଜାକେଦ୍‌ ଚିଉଲାଅ କା ହବାକାନା ଆଡଃ ଚିଉଲାଅ କା ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌କକେ କାଏ କାମ୍‌ତିକାରେଦ ଜେତାଏ କାକ ବାଞ୍ଚାଅଃତେୟାଃ, ମେନ୍‌ଦ ଆୟାଃ ସାଲାକାନ୍‍ ହଡ଼କଆଃ ନାଗେନ୍ତେ ଏନ୍‍ ହୁଲାଙ୍ଗ୍‌କକେ କାମ୍‌ତିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ଏନ୍‌ ଦିପିଲିରେ ଜେତାଏ ଆପେକେ, ‘ନେଲିପେ, ଖ୍ରୀଷ୍ଟ୍‌ ନେତାଃରିୟା’ ଚାଏ ‘ହାନ୍ତାଃରିୟା,’ ମେତାପେରେଦ ଇନିଃକେ ଆଲ୍‌ପେ ବିଶ୍ୱାସୀଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ହସଡ଼ ଖ୍ରୀଷ୍ଟ୍‌ ଆଡଃ ହସଡ଼ ନାବୀକ ବିରିଦାଃ ଆଡଃ ମାପ୍‌ରାଙ୍ଗ୍‌ ଚିହ୍ନାଁ ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ରିକାଉଦୁବେଆ, ଆଡଃ ହବାଦାଡ଼ିୟଃରେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାଲାକାନ୍‍କକେହଁ ବେଦାକଆକ । ");
INSERT INTO unx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ଏନାମେନ୍ତେ ଆୟୁମେପେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ନେଡା ହିଜୁଃ ସିଦାରେଇଙ୍ଗ୍‌ ଉଦୁବାଦ୍‌ପେୟା । ");
INSERT INTO unx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ଏନା ନାଗେନ୍ତେ, ଜେତାଏ ଆପେକେ, ‘ନେଲିପେ, ଇନିଃ ବିର୍‌ରେ ମେନାଇୟା’ ମେତାପେରେ, ‘ଏନ୍ତାଃତେ ଆଲ୍‌ପେ ସେନା’ ଚାଏ ନେଲିପେ, ‘ନେତାଃରାଃ ଭିତାର୍‌ ବାଖ୍‌ରାରେ ଉକୁକାନାଏ’ ମେତାପେରେ ଆଲ୍‌ପେ ବିଶ୍ୱାସୀଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ଜେ'ଲେକାଚି ହିଚିର୍‍ଦ ସିଙ୍ଗିତୁର୍‌ ସାଃଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ସିଙ୍ଗି ହାସୁର୍‌ସାଃ ଜାକେଦ୍‌ ସିର୍ମାକେ ମାସ୍କାଲେୟାଏ, ଏନ୍‌ ଲେକାଗି ମାନୱାହନ୍‌ଆଃ ହିନିଜୁଃ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ଅକ୍‌ତାଃରେ ମାଁଡ଼ା ମେନାଃ, ଏନ୍ତାଃରେ ଗିଦିକ ହୁଣ୍ଡିୟଃଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ଏନ୍‍ ଦିପିଲିରେୟାଃ ଦୁକୁ ତାୟମ୍‌ତେ ଇମ୍‍ତାଗି ସିଙ୍ଗି ନୁବାଗଃଆ ଆଡଃ ଚାଣ୍ଡୁଃ ମାର୍ସାଲ୍‌ କାଏ ଏମେୟା ଆଡଃ ଇପିଲ୍‍କ ସିର୍ମାଏତେକ ଉୟୁଗଃଆ ଆଡଃ ସିର୍ମାରେୟାଃ ପେଡ଼େଃୟାନ୍‌ତେୟାଃକ ଏକ୍‌ଲାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ଏନ୍‌ ଦିପିଲିରେ ମାନୱାହନ୍‌ଆଃ ଚିହ୍ନାଁ ସିର୍ମାରେ ନେଲଆଃ ଆଡଃ ଅତେରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ଏୟମେଁୟା । ଇନ୍‌କୁ ମାନୱାହନ୍‌କେ ପୁରାଃ ପେଡ଼େଃତେ ଆଡଃ ମାନାରାଙ୍ଗ୍‌ଲଃ ସିର୍ମାରାଃ ରିମିଲ୍‌ରେ ହିଜୁଃତାନ୍‍କ ନେଲିୟା । ");
INSERT INTO unx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ଆଡଃ ବିଙ୍ଗୁଲ୍‌ ବାଜା ସାଡ଼ିଆ, ଆଡଃ ଇନିଃ ଆୟାଃ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କକେ ଅତେଦିଶୁମ୍‌ରାଃ ନେ ଟୁଣ୍ଡୁଏତେ ହାନ୍‌ ଟୁଣ୍ଡୁ ଜାକେଦ୍‌ ଆୟାଃ ସାଲାକାନ୍‍କକେ ହୁଣ୍ଡି ନାଗେନ୍ତେ କୁଲ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ଲଆଦାରୁରେୟାଃ ଜନ୍‌କା କାଜିତେ ଇତୁଃପେ, ଏନାରେୟାଃ କତ ସାଗେନ୍‍ତାନ୍‍ ଆଡଃ ସାକାମ୍‌ ସୁଡ଼ାଅଃତାନ୍ ଇମ୍‌ତା ଜେଟ୍‌ସିଙ୍ଗି ନାଡ଼େଃଗିଆ ମେନ୍ତେପେ ସାରିୟା । ");
INSERT INTO unx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ଏନ୍‌ଲେକାଗି, ନେଆଁଁ ସବେନାଃ ହବାଅଃତାନ୍‌ପେ ନେଲେ ଇମ୍‌ତା, ଆଇଁୟାଃ ହିଜୁଃ ନେଡା ନାଡ଼େଃରେଗିଆଃ ମେନ୍ତେ ସାରିପେ । ");
INSERT INTO unx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା ନେ ସବେନାଃ ଆଉରି ହବାଅଃ ଜାକେଦ୍‌ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କ କାକ ଟୁଣ୍ଡୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ସିର୍ମା ଆଡଃ ଅତେ ଟୁଣ୍ଡୁଉତାରଃଆ, ମେନ୍‌ଦ ଆଇଁୟାଃ କାଜିକ କା ଟୁଣ୍ଡୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଚାଏ ଏନ୍‌ ଦିପିଲି ଜେତାଏ କାକ ସାରିଆଃ, ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କହ କା, ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଲାଡ଼୍‌ ହନ୍‌ହ କା, ମେନ୍‌ଦ ଆଇଁୟାଃ ଆପୁ ଏସ୍‌କାର୍‌ଗି ସାରିଆଃଏ । ");
INSERT INTO unx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ଆଡଃ ନୁହୁଁରାଃ ପାରିୟାରେ ଜେ'ଲେକା ହବାୟାନା, ମାନୱାହନ୍‌ଆଃ ହୁଲାଙ୍ଗ୍‌ରେହଗି ଏନ୍‌ଲେକା ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ଟୁଡା ଦାଆଃ ହିଜୁଃ ସିଦାଏତେ ନୁହୁଁ ଲାଉକାରେ ଆଉରି ବଲ ଜାକେଦ୍‌ ହଡ଼କଦ ଜଜମ୍‌ ନୁଁ ଆଡଃ ଆଣ୍‌ଦିତାନ୍‍ ଆଡଃ ଆଣ୍‌ଦି ଏମ୍‍ତାନ୍‍ରେ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ଆଡଃ ଟୁଡା ଦାଆଃ ହିଜୁଃକେଦ୍‌ତେ ସବେନ୍‌କକେ ଆଉରି ଆତୁଇଦି ଜାକେଦ୍‌ ଇନ୍‌କୁ ଜେତ୍‌ନାଃ କାକ ଆଟ୍‌କାରେ ତାଇକେନା, ଏନ୍‌ ଲେକାଗି ମାନୱାହନ୍‌ଆଃ ହିଜୁଃ ହୁଲାଙ୍ଗ୍‌ରେ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ଇମ୍‌ତାଙ୍ଗ୍‌ ବାର୍‌ହଡ଼୍‌ ଲୟଙ୍ଗ୍‌ରେକିନ୍ କାମିକାତେରେ, ମିହୁଡ଼୍‌କେ ଇଦିୟଃଆ ଆଡଃ ମିହୁଡ଼୍‌କେ ବାଗିଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ଜାନ୍ତାଦିରିରେ ଗୁଣ୍ଡା ରିଦେତାନ୍‌ ବାରିଆ କୁଡ଼ିକିନ୍‌ଏତେ ମିଆଁଦ୍‌ନିଃକେ ଇଦିୟଃଆ, ଆଡଃ ଏଟାଃନିଃକେ ବାଗିଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“ଏନାମେନ୍ତେ ଏୟନାକାନ୍‍ତାଇନ୍‌ପେ, ଚିୟାଃଚି ଆପେଦ ଆପେୟାଃ ପ୍ରାଭୁଆଃ ହିଜୁଃ ଦିପିଲି କାପେ ସାରିୟା । ");
INSERT INTO unx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ମେନ୍‌ଦ ନେଆଁଁ ଆଟ୍‌କାରେପେ, ଅଡ଼ାଃ ଗମ୍‌କେ କୁମ୍ବୁଡ଼ୁ ହିଜୁଃ ଦିପିଲିକେ ସାରିକାରେଦ ଏୟନାକାନ୍ ତାଇନ୍‌ତେୟାଃଏ ଆଡଃ ଆୟାଃ ଅଡ଼ାଃକେ ସିନ୍ଧି ତଡ଼ାଅକେଦ୍‌ତେ କାଏ ବଲରିକାକତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ଏନା ନାଗେନ୍ତେ ଆପେୟ ସାପ୍‌ଡ଼ାଅକାନ୍‍ ତାଇନ୍‌ପେ, ଚିୟାଃଚି ଆପେ କାପେ ଉଡ଼ୁଃତାନ୍‌ ଦିପିଲିରେଗି ମାନୱାହନ୍‌ ହିଜୁଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ଏନ୍ତେ ଗୁସିୟାଁ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌କକେ ବୁଗିନ୍‌ ନେଡାରେ ଜମେୟାଃଁ ଏମାକ ନାଗେନ୍ତେ ଅକଏକେ ଇନିଃ ସାଲାକିଆଏ, ଏନ୍‌ଲେକାନ୍‌ ପାତିୟାର୍‌ରଃ ଆଡଃ ସେଣାଁଁନ୍‌ ଦାସି ଅକଏ ତାନିଃ ? ");
INSERT INTO unx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ଆୟାଃ ଗୁସିୟାଁ ନେ'ଲେକା କାମିତାନ୍ ଦାସିକେ ହିଜୁଃ ନାମିରେ ଇନିଃ ସୁକୁତାନ୍‌ଗିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଇନିଃ ଏନ୍‍ ଦାସିକେ ଆୟାଃ ସବେନ୍‌ ମେନାଃତେୟାଃରେନ୍‍ ଗୁସିୟାଁ ବାଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ମେନ୍‌ଦ ଏନ୍‌ ଦାସି ଏତ୍‌କାନ୍‌ ତାନିଃରେଦ, ଇନିଃ, ଆଇଁୟାଃ ଗୁସିୟାଁରାଃ ହିଜୁଃତେୟାଃ ବିଲାମଃତାନାଃ ମେନ୍ତେ ଆଇଃକ୍‌ଗି ଆୟାଃ ମନ୍‌ରେ କାଜିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ଆଡଃ ଆୟାଃ ଗାତିଦାସିକକେ ଦାଲ୍‌ ଏଟେଦ୍‌କଆଏ ଆଡଃ ବୁଲ୍‌ ହଡ଼କଲଃ ଜମ୍‌ ନୁଁରେ ତାଇନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ଏନ୍ତେ ଏନ୍‌ ଦାସି କାଏ ଉଡ଼ୁଃକା ହୁଲାଙ୍ଗ୍‌ରେ ଆଡଃ କାଏ ସାରି ଦିପିଲିରେ ଇନିୟାଃ ଗୁସିୟାଁ ହିଜୁଃଆଏ, ");
INSERT INTO unx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ଆଡଃ ଗୁସିୟାଁ ଇନିଃକେ ପୁରାଃ ଦୁକୁ ଏମାଇତାନ୍‌ଲଃ ଟୁକ୍‌ଡ଼ା ଟୁକ୍‌ଡ଼ା ମାଆଃଇୟାଏ ଆଡଃ ହସଡ଼ ହଡ଼କଲଃ ହାନାଟିଙ୍ଗ୍‌ ଏମାଇୟାଏ ଆଡଃ ଏନ୍ତାଃରେ ରାଆଃ ଆଡଃ ଡାଟା ରିଦ୍‌ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ଏନ୍‌ ଦିପିଲିରେ ସିର୍ମା ରାଇଜ୍‌ରାଃ ହିନିଜୁଃ ନେ ଗେଲେୟା ଡିଣ୍ଡାକୁଡ଼ିକ ଲେକା ହବାଅଃଆ, ଇନ୍‌କୁ ଆକଆଃ ଦିମି ସାବ୍‌କେଦ୍‌ତେ ଦୁହ୍ଲାକଡ଼ାଲଃ ନେପେଲ୍‌ ନାଗେନ୍ତେକ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ଇନ୍‌କୁଏତେ ମଣେୟାଁ ସେଣାଁଁନ୍‌କ ଆଡଃ ମଣେୟାଁ ଡଣ୍ଡକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ଏନ୍‍ ଡଣ୍ଡ କୁଡ଼ିକ ଆକଆଃ ଦିମି ଇଦିକେଦ୍‌ ଇମ୍‌ତା ଆଦ୍‌କା ସୁନୁମ୍‌ କାକ ଇଦି । ");
INSERT INTO unx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ମେନ୍‌ଦ ଏନ୍‌ ସେଣାଁଁନ୍‌କ ଆକଆଃ ଦିମି ଇଦିତାନ୍‍ଲଃ ଶିଶିରେ ଆଦ୍‌କା ସୁନୁମ୍‌କ ଇଦିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ଦୁହ୍ଲାକଡ଼ା ହିଜୁଃରେ ବିଲାମ୍‌କେଦାଏ, ଏନାତେ ଏନ୍‍ ସବେନ୍‌କକେ ଝୁପାଅ ଏଟେଦ୍‌କେଦ୍‌କଆ ଆଡଃ ଦୁଡ଼ୁମ୍‌ ବାଟିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ଏନ୍ତେ ଥାଲା ନିଦାରେ କାଉରି ଆୟୁମ୍‌ୟାନା, ‘ନେଲିପେ, ଦୁହ୍ଲାକଡ଼ା ହିଜୁଃତାନାଏ, ଇନିଃକେ ଦାରମ୍‌ତେ ଅଡଙ୍ଗ୍‌ଅଃପେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ଏନ୍ତେ ଏନ୍‌ ଗେଲେୟା ଡିଣ୍ଡାକୁଡ଼ିକ ବିରିଦ୍‌କେଦ୍‌ତେ ଆକଆଃ ଆକଆଃ ଦିମିକ ସାଜାଡ଼ାଅକେଦ୍‌ତେ ଜୁଲ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ଆଡଃ ଏନ୍‍ ଡଣ୍ଡ କୁଡ଼ିକ ସେଣାଁଁନ୍‌ କୁଡ଼ିକକେ ମେତାଦ୍‌କଆକ, ‘ଆପେୟାଃ ସୁନୁମ୍‌ କାଟିଃଲେକା ଏମାଲେପେ ଆଲେୟାଃ ଦିମିଦ ଇଣିଁଜଃତାନା ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ମେନ୍‌ଦ ସେଣାଁଁନ୍‌ କୁଡ଼ିକ କାଜିରୁହାଡ଼ାଦ୍‍କଆ, ‘କାହାଗି ଆଲେୟାଃ ଆଡଃ ଆପେୟାଃ ନାଗେନ୍ତେ ନିମିନାଙ୍ଗ୍‌ ସୁନୁମ୍‌ କା ପୁରାଅଃଆ, ଏନାମେନ୍ତେ ଜୁ ଆଖ୍‌ରିଙ୍ଗ୍‌କତାଃ ସେନଃପେ ଆଡଃ ଆପେୟାଃ ନାଗେନ୍ତେ କିରିଙ୍ଗ୍‌ୟେଁପେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ଆଡଃ ଇନ୍‌କୁ କିରିଙ୍ଗ୍‌ ନାଗେନ୍ତେକ ସେନଃତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‍ତାଙ୍ଗ୍‌ଗି ଦୁହ୍ଲାକଡ଼ା ସେଟେର୍‍ୟାନାଏ ଆଡଃ ସାପ୍‌ଡ଼ାଅକାନ୍‍କ ଇନିଃଲଃ ଆଣ୍‌ଦି ଅଡ଼ାଃତେକ ବଲୟାନା, ଆଡଃ ଦୁଆର୍‌ ହାଣ୍ଡେଦ୍‍ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ତାୟମ୍‌ତେ ଏନ୍‌ ଡଣ୍ଡ କୁଡ଼ିକ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟାକ, ‘ହେ ପ୍ରାଭୁ, ହେ ପ୍ରାଭୁ, ଆଲେୟାଃ ନାଗେନ୍ତେ ଦୁଆର୍‌ ନିଜାଲେମ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ଏନ୍ତେ ଦୁହ୍ଲାକଡ଼ା କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, ‘ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ।’” ");
INSERT INTO unx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ଆଡଃ ୟୀଶୁ କାଜିଟୁଣ୍ଡୁକେଦ୍‌ତେ କାଜିକେଦାଏ, “ଏୟନାକାନ୍‍ପେ, ଆପେଦ ମାନୱାହନ୍‌ଆଃ ହିଜୁଃ ହୁଲାଙ୍ଗ୍‌ ଆଡଃ ହିଜୁଃ ଘାଡ଼ି କାପେ ସାରିୟା । ");
INSERT INTO unx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ଏନ୍‌ ଦିପିଲିରେ ସିର୍ମା ରାଇଜ୍‌ଦ ନେ ଲେକାଗିଆ, ମିଆଁଦ୍‌ ହଡ଼ ଆୟାଃ ଦାସିକକେ ହାକାଅକେଦ୍‌ତେ ଆୟାଃ ସବେନ୍‌ ଖୁର୍ଜି ଏମାଦ୍‍କଆଏ ଆଡଃ ସାଙ୍ଗିନ୍‌ ଦିଶୁମ୍‌ତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ଇନିଃ ମିହୁଡ଼୍‌କେ ମଣେୟାଁ ହାଜାର୍‌ ରୁପା ସିକା, ଆଡଃମିହୁଡ଼୍‌କେ ବାରିୟା ହାଜାର୍‌ ରୁପା ସିକା, ଆଡଃମିହୁଡ଼୍‌କେ ମିଦ୍‌ ହାଜାର୍‌ ରୁପା ସିକା, ନେ ଲେକା ସବେନ୍‌କକେ ଆକଆଃ ଆପ୍‌ନାଃ ପେଡ଼େଃ ଲେକାତେ ଏମାଦ୍‍କଆ ଆଡଃ ସାଙ୍ଗିନ୍‌ ଦିଶୁମ୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ମଣେୟାଁ ହାଜାର୍‌ ରୁପା ସିକା ନାମ୍‌କେଦ୍‌ନିଃ ଇମ୍‍ତାଗି ସେନଃୟାନ୍‌ଲଃ ଏନାକେ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ରେ ଏମ୍‌କେଦ୍‌ତେ ଆଡଃ ମଣେୟାଁ ହାଜାର୍‌ ରୁପା ସିକା ପସାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ଏନ୍‌ଲେକାଗି ବାରିୟା ହାଜାର୍‌ ରୁପା ସିକା ନାମ୍‌କେଦ୍‌ନିଃହଁ ଆଡଃ ବାରିୟା ହାଜାର୍‌ ରୁପା ସିକା ପସାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ମେନ୍‌ଦ ମିଦ୍‌ ହାଜାର୍‌ ରୁପା ସିକା ନାମ୍‌କେଦ୍‌ନିଃ ସେନ୍‌କେଦ୍‌ତେ ଅତେରେ ଗାଡା ଉର୍‍କେଦାଏ ଆଡଃ ଆୟାଃ ଗୁସିୟାଁରାଃ ଟାକାକେ ତପାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ଚିମିନ୍‍ ମାହାଁ ତାୟମ୍‌ତେ ଏନ୍‍ ଦାସିକଆଃ ଗୁସିୟାଁ ହିଜୁଃରୁହାଡ଼୍‌ୟାନାଏ ଆଡଃ ଇନ୍‍କୁଲଃ ହିସାବ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ମଣେୟାଁ ହାଜାର୍‌ ରୁପା ସିକା ନାମାକାଦ୍‌ନିଃ ହିଜୁଃୟାନାଏ ଆଡଃ ମଣେୟାଁ ହାଜାର୍‌ ରୁପା ସିକା ଆଦ୍‌କା ଆଉକେଦ୍‌ତେ କାଜିକିୟାଏ, ‘ହେ ଗମ୍‌କେ, ଆମ୍‌ ମଣେୟାଁ ହାଜାର୍‌ ରୁପା ସିକା ଏମାକାଇଙ୍ଗ୍‌ ତାଇକେନାମ୍‌, ନେଲେମେ ଆଇଙ୍ଗ୍‌ ମଣେୟାଁ ହାଜାର୍‌ ରୁପା ସିକା ପସାକାଦାଇଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ଇନିୟାଃ ଗୁସିୟାଁ କାଜିକିୟାଏ, ‘ସାବାସ୍‌, ଆଇଁୟାଃ ବୁଗିନ୍‌ ଦାସି ! ଆମ୍‌ ବୁଗିନ୍‌ ଆଡଃ ପାତିୟାର୍‌ରଃ ଲେକାନ୍‌ ଦାସି ତାନ୍‌ମେ, ଆମ୍‌ ହୁଡିଙ୍ଗ୍‌ତେୟାଃରେ ପାତିୟାର୍‍ରଃ ଲେକାମ୍‌ କାମିକାଦ୍‌ ହରାତେ, ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ପୁରାଃତେୟାଃରାଃ ଗୁସିୟାଁ ବାଇମେୟାଇଙ୍ଗ୍‌ । ଏଲା ହିଜୁଃମେ, ଆଇଁୟାଃଲଃ ରାସ୍‌କାନ୍‌ମେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ବାରିୟା ହାଜାର୍‌ ରୁପା ସିକା ନାମାକାଦ୍‌ନିଃହଁ ହିଜୁଃୟାନାଏ ଆଡଃ କାଜିକିୟାଏ, ହେ ଗମ୍‌କେ, ଆମ୍‌ ବାରିୟା ହାଜାର୍‌ ରୁପା ସିକା ଏମାକାଇଙ୍ଗ୍‌ ତାଇକେନାମ୍‌, ନେଲେମେ ଆଇଙ୍ଗ୍‌ ବାରିୟା ହାଜାର୍‌ ରୁପା ସିକା ଆଦ୍‌କା ପସାକାଦାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ଇନିୟାଃ ଗୁସିୟାଁ ଇନିଃକେ କାଜିକିୟାଏ, ‘ବୁଗିନ୍‌ କାମିକାଦାମ୍‌, ଆମ୍‌ ବୁଗିନ୍‌ ଆଡଃ ପାତିୟାର୍‌ରେନ୍‌ ଦାସି ତାନ୍‌ମେ, ଆମ୍‌ ହୁଡିଙ୍ଗ୍‌ତେୟାଃରେ ପାତିୟାର୍‍କାନାମ୍ ଏନାତେ ଆଇଙ୍ଗ୍‌ ପୁରାଃତେୟାଃରାଃ ଗୁସିୟାଁ ବାଇମେୟାଇଙ୍ଗ୍‌, ଏଲା ହିଜୁଃମେ, ଆଇଁୟାଃଲଃ ରାସ୍‌କାନ୍‌ମେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ଏନ୍ତେ ଏନ୍‌ ମିଦ୍‌ ହାଜାର୍‌ ରୁପା ସିକା ନାମାକାଦ୍‌ନିଃ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟାଏ, ‘ହେ ଗମ୍‌କେ, ଆମ୍‌ କେଟେଦ୍‌ ମନ୍‍ରେନ୍‌ ହଡ଼ ତାନ୍‌ମେ ଏନା ଆଇଙ୍ଗ୍‌ ସାରିତାଇକେନାଇଙ୍ଗ୍‌ । ଆମ୍‌ କା ହେରାକାନ୍‌ତାଃଏତେ ଇରାଃମେ ଆଡଃ କା ତାସିକାନ୍‌ତାଃଏତେ ହୁଣ୍ଡିୟାଃମେ । ");
INSERT INTO unx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ଏନାତେ ଆଇଙ୍ଗ୍‌ ବରକେଦାଇଙ୍ଗ୍‌ ଆଡଃ ସେନଃକେଦ୍‌ତେ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଦିଙ୍ଗ୍‌ ଟାକାକେ ଅତେରେ ଗାଡା ଉର୍‌କେଦ୍‌ତେ ଉକୁକେଦାଇଙ୍ଗ୍‌, ନେଲେମେ, ନେ ନେତାଃରେୟା ଟାକା, ଅକ୍‌ନାଃଚି ଆମାଃତାନାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“ଇନିୟାଃ ଗୁସିୟାଁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, ‘ଏ ଏତ୍‌କାନ୍‌ ଆଡଃ ଆଲ୍‌ସି ଦାସି, ଆଇଙ୍ଗ୍‌ କା ହେରାକାନ୍‌ତାଃଏତେ ଇରାଃଇଙ୍ଗ୍‌ ଆଡଃ କା ତାସିକାନ୍‌ତାଃଏତେ ହୁଣ୍ଡିୟାଃଇଙ୍ଗ୍‌ ମେନ୍ତେ ସାରିତାଇକେନ୍‌ରେଦ, ");
INSERT INTO unx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ଆମ୍‌ ଆଇଁୟାଃ ଟାକାକେ ବ୍ୟାଙ୍କ୍‌ରେ ଏମଃ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା ଆଡଃ ଆଇଙ୍ଗ୍‌ ହିଜୁଃରୁହାଡ଼୍‌କେଦ୍‌ତେ ସବେନ୍‌ ମୁଲ୍‌'କାନ୍‌ତାର୍‌ଲଃ ଟାକା ନାମ୍‍ରୁହାଡ଼୍‌ କେଦ୍‌ତେୟାଃଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଏନାତେ ନାହାଁଃ, ଏନ୍‌ ମିଦ୍‌ ହାଜାର୍‌ ରୁପା ସିକା ଇଦିକେଦ୍‌ତେ, ଅକଏତାଃରେ ଗେଲ୍‌ ହାଜାର୍‌ ରୁପା ସିକା ମେନାଃନିଃକେ ଏମାଇପେ । ");
INSERT INTO unx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ଚିୟାଃଚି ଅକଏତାଃରେ ମେନାଃ, ଇନିଃକେ ଏମଃଆ ଆଡଃ ଇନିୟାଃ ପୁରାଃଗି ହବାଅଃଆ, ମେନ୍‌ଦ ଜେତାଏତାଃରେ ବାନଃଆ, ଇନିଃତାଃଏତେ ଅକ୍‌ନାଃ ମେନାଃ ଏନାହଗି ଇଦିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଆଡଃ ନେ ଏତ୍‌କାନ୍‌ ଦାସିକେ ବାହାରି ନୁବାଃରେ ହୁଦ୍‌ମାଇପେ, ଏନ୍ତାଃରେ ରାନାଃ ଆଡଃ ଡାଟା ରିନିଦ୍‌ ହବାଅଆଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ମାନୱାହନ୍‌ ଆୟାଃ ସିର୍ମାରେନ୍‌ ସବେନ୍‌ ଦୁଁତ୍‌କଲଃ ଆୟାଃ ମାନାରାଙ୍ଗ୍‌ରେ ରାଜା ଲେକା ହିଜୁଃ ଦିପିଲିରେ ଇନିଃ ଆୟାଃ ମାନାରାଙ୍ଗ୍‌ ସିର୍ମାରେୟାଃ ରାଜ୍‌ଗାଦିରେ ଦୁବାଃଏ । ");
INSERT INTO unx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ଆଡଃ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ସବେନ୍‌ ଜାତିରେନ୍‍ ହଡ଼କ ଇନିୟାଃ ଆୟାର୍‍ରେକ ହୁଣ୍ଡିୟଃଆ ଆଡଃ ଗୁପିନିଃ ମିଣ୍ଡିକକେ ମେରମ୍‌କଏତେ ହିଗାଡ଼୍‌କ ଲେକା ଇନିଃ ଇନ୍‌କୁକେ ମିହୁଡ଼୍‌ଏତେ ଆଡଃମିହୁଡ଼୍‌କେ ହିଗାଡ଼୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ଇନିଃ ମିଣ୍ଡିକକେ ଆୟାଃ ଜମ୍‌ତିସାଃରେ ଆଡଃ ମେରମ୍‌କକେ ଲେଙ୍ଗାତିସାଃରେ ଦହକଆଏ । ");
INSERT INTO unx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ଏନ୍ତେ ରାଜା ଆୟାଃ ଜମ୍‍ତିସାଃରେନ୍‌କକେ କାଜିକଆଏ, ‘ଆଇଁୟାଃ ଆପୁଇଙ୍ଗ୍‌ତାଃଏତେ ଆଶିଷ୍‌କାନ୍‍କ ହିଜୁଃପେ ଆଡଃ ଆପେୟାଃ ନାଗେନ୍ତେ ଅତେଦିଶୁମ୍‌ରେୟାଃ ଏନେଟେଦ୍‌ ସିଦାରେ ବାଇୟାକାନ୍‌ ରାଇଜ୍‌ରେ ବଲପେ । ");
INSERT INTO unx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ରେଙ୍ଗେଜାକାନ୍‍ ତାଇକେନ୍‌ରେ ଜମେୟାଃଁପେ ଏମାଦିୟାଁ, ଆଡଃ ତେତାଙ୍ଗିଙ୍ଗ୍‌ ତାଇକେନ୍‌ରେ ନୁଁଏ ନାଗେନ୍ତେ ଦାଆଃପେ ଏମାଦିୟାଁ, ଆଇଙ୍ଗ୍‌ ଏଟାଃ ଦିଶୁମ୍‌ରେ ତାଇକେନ୍‌ରେ ଆପେୟାଃ ଅଡ଼ାଃରେ ତାଇନ୍‌ ନାଙ୍ଗ୍‌ ଠାୟାଦ୍‌ପେ ଏମାଦିୟାଁ, ");
INSERT INTO unx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ଆଇଙ୍ଗ୍‌ ସାମାହଡ଼୍‌ମ ତାଇକେନ୍‌ରେ ଲିଜାଃପେ ତୁସିଙ୍ଗ୍‌କେଦିୟାଁ, ଆଇଙ୍ଗ୍‌ ହାସୁତାନ୍ ତାଇକେନ୍‌ରେ ଯାତ୍‌ନାଅ ସାକ୍‌ଲାଅ କେଦିୟାଁପେ, ଆଇଙ୍ଗ୍‌ ଜେହେଲ୍‌ରେ ତାଇକେନ୍‌ ଇମ୍‌ତା ନେନେଲ୍‌ତେପେ ହିଜୁଃୟାନା ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ଏନ୍ତେ ଧାର୍‌ମାନ୍‌ ହଡ଼କ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାକ, ‘ହେ ଗମ୍‌କେ, ଚିଉଲା ଆଲେ ଆମ୍‌କେ ରେଙ୍ଗେତାନ୍‍ଲେ ନେଲ୍‌ଲେଦ୍‌ମେୟାଁ ଆଡଃ ଆମ୍‌କେ ଜଜମାଃଲେ ଏମାଦ୍‍ମେୟାଁ, ଚାଏ ଚିଉଲା ତେତାଙ୍ଗ୍‌ତାନ୍‌ଲେ ନେଲ୍‌ଲେଦ୍‌ମେୟାଁ ଆଡଃ ନୁଁ ନାଙ୍ଗ୍‌ ଦାଆଃଲେ ଏମାଦ୍‌ମେୟାଁ ? ");
INSERT INTO unx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ଚିଉଲା ଆଲେ ଆମ୍‌କେ ନେଲ୍‌କେଦ୍‌ତେ ଏଟାଃ ଦିଶୁମ୍‌ରେନ୍‌ ତାନିଃ ମେନ୍ତେ ଆଲେୟାଃ ଅଡ଼ାଃରେ ତାଇନ୍‌ ନାଙ୍ଗ୍‌ ଠାୟାଦ୍‌ଲେ ଏମାଦ୍‌ମେୟାଁ ଆଡଃ ଚିଉଲା ସାମାହଡ଼୍‌ମ ତାଇକେନ୍‌ରେ ତୁସିଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଲିଜାଃଲେ ଏମାଦ୍‌ମେୟାଁ ? ");
INSERT INTO unx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ଆଡଃ ଆମ୍‌ ହାସୁତାନ୍‌ରେ ଚାଏ ଜେହେଲ୍‍କାନ୍‌ରେ ଚିଉଲା ଆଲେ ଆମ୍‌କେ ନେନେଲ୍‌ତେଲେ ସେନ୍‌କେନା ?’ ");
INSERT INTO unx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ଆଡଃ ରାଜା ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼୍‌କଆଏ, ‘ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେ ଆଇଁୟାଃ ନେ ହାଗାକଏତେ ମିହୁଡ଼୍‌ ନାଗେନ୍ତେ ଅକ୍‌ନାଃପେ ରିକାକାଦା, ଏନା ଆଇଁୟାଃ ନାଗେନ୍ତେୟ ରିକାକାଦାପେ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ଏନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ଲେଙ୍ଗାତିସାଃରେନ୍‍କକେ କାଜିୟାଦ୍‌କଆଏ, ‘ହେ ସାର୍‍ପାଅକାନ୍‍ ହଡ଼କ ! ଆଇଁୟାଃତାଃଏତେ ନିର୍‌ପେ ଏନ୍ତେ ସାଏତାନ୍‌ ଆଡଃ ଆୟାଃ ଦୁଁତ୍‌କ ନାଗେନ୍ତେ ବାଇୟାକାନ୍‌ ଜାନାଅ କା ଇଣିଁଜଃ ସେଙ୍ଗେଲ୍‌ତେ ସେନଃପେ । ");
INSERT INTO unx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ରେଙ୍ଗେଃ ତାଇକେନ୍‌ରେ ଜମେୟାଃଁ କାପେ ଏମାଦିୟାଁ, ଆଇଙ୍ଗ୍‌ ତେତାଙ୍ଗ୍‌ ତାଇକେନ୍‌ରେ ନୁଁ ନାଗେନ୍ତେ ଦାଆଃ କାପେ ଏମାଦିୟାଁ । ");
INSERT INTO unx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ଆଇଙ୍ଗ୍‌ ଏଟାଃ ଦିଶୁମ୍‌ରେ ତାଇକେନ୍‌ ଇମ୍‌ତା ଆପେ ଆପେୟାଃ ଅଡ଼ାଃରେ ତାଇନ୍‌ ନାଙ୍ଗ୍‌ ଠାୟାଦ୍‌ କାପେ ଏମାଦିୟାଁ, ଆଇଙ୍ଗ୍‌ ସାମାହଡ଼୍‌ମ ତାଇକେନ୍‌ରେ ତୁସିଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଲିଜାଃ କାପେ ଏମାଦିୟାଁ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଦୁକୁରେ ଆଡଃ ଜେହେଲ୍‌ରେ ତାଇକେନ୍‌ ଇମ୍‌ତା ଆଇଙ୍ଗ୍‌କେ କାପେ ଯାତ୍‌ନାଅ ସାକ୍‌ଲାଅ କେଦିୟାଁ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“ଏନ୍ତେ ଇନ୍‍କୁହଗି ଇନିଃକେ କାଜିରୁହାଡ଼ିୟାକ, ‘ହେ ପ୍ରାଭୁ, ଚିଉଲା ଆଲେ ଆମ୍‌କେ ରେଙ୍ଗେଃତାନ୍ ଚାଏ ତେତାଙ୍ଗ୍‌ତାନ୍ ଚାଏ ଏଟାଃ ଦିଶୁମ୍‌ରେନ୍‌, ଚାଏ ସାମାହଡ଼୍‌ମ, ଚାଏ ହାସୁତାନ୍, ଚାଏ ଜେହେଲ୍‌ରେ ନେଲ୍‌କେଦ୍‌ତେ କାଲେ ଦେଙ୍ଗାକେଦ୍‌ମେୟାଁ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ଏନ୍ତେ ରାଜା କାଜିରୁହାଡ଼୍‌କଆଏ, ‘ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେ ନେ ହୁପ୍‌ଡିଙ୍ଗ୍‌କଏତେ ମିହୁଡ଼୍‌କେହଁ କାପେ ଦେଙ୍ଗାକେଦ୍‌କ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌କେହଁ କାପେ ଦେଙ୍ଗାକେଦିୟାଁ ।’ ");
INSERT INTO unx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ଏନ୍ତେ ଇନ୍‌କୁ ଜାନାଅ ଜାନାଅରେୟାଃ ଦୁକୁ, ମେନ୍‌ଦ ଧାର୍‌ମାନ୍‌କ ଜାନାଅ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌କ ନାମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ୟୀଶୁ ନେ ସବେନ୍‌ କାଜିକ କାଜି ଚାବାକେଦ୍‍ଚି, ଇନିଃ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‍କଆଏ, ");
INSERT INTO unx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ବାର୍‍ସିଙ୍ଗ୍‌ ତାୟମ୍‌ତେ ପାସ୍‌କା ପାରାବ୍‌ ହବାଅଆଃ ଏନା ଆପେ ସାରିତାନାପେ । ଇମ୍‌ତା ମାନୱାହନ୍‌ କ୍ରୁଶ୍‌ରେ କିଲାଅଃ ନାଗେନ୍ତେ ଜିମାଃୱାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ଏନ୍ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କ, ଆଡଃ ପ୍ରାଚିନ୍‌କ, କାୟଫା ନୁତୁମ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ରାଃ ଅଡ଼ାଃରାଚାରେ ହୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ଆଡଃ ଇନ୍‌କୁ ୟୀଶୁକେ ବେଦାତେ ସାବ୍‌କେଦ୍‌ତେ ଗଜି ନାଗେନ୍ତେ ରଜୋଟକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ମେନ୍‌ଦ ଇନ୍‌କୁ କାଜିକେଦାକ, “ପାରାବ୍‍ରେଦ କାହାଗି, କା'ରେଦ ହଡ଼କ ହାଲାଗୁଲାୟାକ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ୟୀଶୁ ବେଥ୍‌ନିଆରେ ନାଗେଘାଅଏତେ ବୁଗିଆକାନ୍‌ ଶିମୋନ୍‌ଆଃ ଅଡ଼ାଃରେ ତାଇକେନ୍‌ ଇମ୍‌ତା, ");
INSERT INTO unx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ମିଆଁଦ୍‌ କୁଡ଼ି ପୁରାଃ ଗନଙ୍ଗ୍‌ଆଁନ୍‌ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ତେ ପେରେଜାକାନ୍‍ ମିଆଁଦ୍‌ ପୁଣ୍ଡିଦିରିରାଃ ଚୁକାଃ ସାବ୍‌କେଦ୍‌ତେ ୟୀଶୁତାଃତେ ହିଜୁଃୟାନା, ଆଡଃ ୟୀଶୁ ଜଜମ୍ ନାଗେନ୍ତେ ଦୁବାକାନ୍‌ ଇମ୍‌ତା ଇନିୟାଃ ବହଃରେ ଦୁଲ୍‍କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ଇନିୟାଃ ଚେଲାକ ନେଆଁଁ ନେଲ୍‍କେଦ୍‍ତେ ଖିସ୍‍ୟାନାକ ଆଡଃ କୁଲିକିୟାକ, “ଚିୟାଃ ନାଗେନ୍ତେ ନେ ସବେନ୍‌ ସାମାଗି ଏଣ୍ଡାଗଃତାନା ? ");
INSERT INTO unx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ନେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ ପୁରାଃ ଗନଙ୍ଗ୍‌ତେ ଆଖ୍‌ରିଙ୍ଗ୍‌ ଦାଡ଼ିକାନ୍‌ତେୟାଃ ଆଡଃ ରେଙ୍ଗେଃକକେ ଏମାକାନ୍‌ତେୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ଚେଲାକ କାଜିତାନ୍‌ତେୟାଃ ୟୀଶୁ ସାରିକେଦ୍‌ତେ କାଜିକେଦ୍‍କଆଏ, “ଆପେ ଚିନାଃମେନ୍ତେ ଏନ୍‍ କୁଡ଼ିକେ ବିତ୍‍ଲାଇତାନାପେ ? ନିଃଦ ଆଇଁୟାଃ ନାଗେନ୍ତେ ବୁଗିନ୍‌ କାମି କାମିକାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ରେଙ୍ଗେଃକଦ ଆପେଲଃ ସବେନ୍‌ ଇମ୍‌ତା ତାଇନାଃକ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେଲଃ ସବେନ୍‌ ଇମ୍‌ତା କାଇଙ୍ଗ୍‌ ତାଇନା । ");
INSERT INTO unx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ଆଇଁୟାଃ ତପାଅଃରାଃ ସେକାଡ଼େନ୍‌ ନାଗେନ୍ତେ ଇନିଃ ନେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌କେ ଆଇଁୟାଃ ହଡ଼୍‌ମରେ ଦୁଲାକାଦା । ");
INSERT INTO unx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଅତେଦିଶୁମ୍‌ରେୟାଃ ଜାହାତାଃରେଗି ସୁକୁକାଜି ଉଦୁବଃତାନ୍‌ ଇମ୍‌ତା ଏନ୍‌ କୁଡ଼ି କାମିକାଦ୍‍ତେୟାଃ ପାହାମେ ନାଗେନ୍ତେ ଉଦୁବଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ଏନ୍ତେ ଏନ୍‍ ଗେଲ୍‌ବାର୍‌ ଚେଲାକଏତେ ମିଆଁଦ୍‌ନିଃ, ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା ମୁଲ୍‌ ଯାଜାକ୍‌କତାଃ ସେନଃୟାନାଏ, ");
INSERT INTO unx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ଆଡଃ କୁଲିକେଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ଆପେୟାଃ ତିଃଇରେ ଜିମାଇରେଦ ଆପେ ଆଇଙ୍ଗ୍‌କେ ଚିନାଃପେ ଏମାଇୟାଁ ?” ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ତିରିଶ୍‌ଠୁ ରୁପା ସିକା ଲେକାକେଦ୍‌ତେ ଏମ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ଏନ୍‍ ହୁଲାଙ୍ଗ୍‌ତାଃଏତେ ଇନିଃ ୟୀଶୁକେ ସାବ୍‍ରିକାଇ ନାଗେନ୍ତେ ସୁଯୋଗ୍‌ ଦାଣାଁଁତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ସାବାଃ ହଲଙ୍ଗ୍‌ ପାରାବ୍‌ରେୟାଃ ସିଦା ହୁଲାଙ୍ଗ୍‌ରେ ଚେଲାକ ୟୀଶୁତାଃତେ ହିଜୁଃକେଦ୍‌ତେ କୁଲିକିୟାକ, “ଆଲେ ଅକ୍‌ତାଃରେ ଆମାଃ ନାଗେନ୍ତେ ପାସ୍‌କା ପାରାବ୍‌ରେୟାଃ ଜମେୟାଃଁଲେ ବାଇୟା ମେନ୍ତେମ୍‌ ସାନାଙ୍ଗ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ୟୀଶୁ ଚେଲାକକେ ମେତାଦ୍‌କଆ, “ଏନ୍‍ ନାଗାର୍‌ରେନ୍‌ ଜେତାଏ ହଡ଼ତାଃତେ ସେନ୍‍ପେ ଆଡଃ ମେତାଇପେ, ‘ଗୁରୁ କାଜିତାନାଏ, ଆଇଁୟାଃ ନେଡା ସେଟେରାକାନା, ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଚେଲାକଲଃ ଆମାଃ ଅଡ଼ାଃରେ ପାସ୍‌କା ପାରାବ୍‌ ମାନାଅୟାଇଙ୍ଗ୍‌ ।’” ");
INSERT INTO unx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ଏନ୍ତେ ଚେଲାକ ୟୀଶୁ ଆଚୁକାଦ୍‍ଲେକା ରିକାକେଦାକ ଆଡଃ ପାସ୍‌କା ପାରାବ୍‌ରେୟାଃ ଜମେୟାଁଃକ ବାଇକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ଆୟୁବ୍‍ୟାନ୍‍ଚି ୟୀଶୁ ଗେଲ୍‌ବାର୍‌ ଚେଲାକଲଃ ଜଜମ୍‌ ନାଗେନ୍ତେ ଦୁବ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ଇନ୍‌କୁ ଜମ୍‌ତାଇକେନ୍‌ ଇମ୍‌ତା ଇନିଃ ମେତାଦ୍‌କଆଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେକଏତେ ମିଆଁଦ୍‌ନିଃ ଆଇଙ୍ଗ୍‌କେ ବାଇରିକଆଃ ତିଃଇରେ ସାବ୍‍ରିକାଇଙ୍ଗ୍‌ୟାଁଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ଇନ୍‌କୁ ପୁରାଃଗି ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନାକ ଆଡଃ ଇନିଃକେ “ହେ ପ୍ରାଭୁ, ଇନିଃ ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ଚି ?” ମେନ୍ତେ ମିହୁଡ଼୍‌ ମିହୁଡ଼୍‌ତେ କୁଲି ଏଟେଦ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଆଡଃ ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଆଇଁୟାଃଲଃ କାଟୋରାରେ ଆୟାଃ ତିଃଇ ସୁଉଃକାଦ୍‌ନିଃଗି ସାବ୍‍ରିକାଇଙ୍ଗ୍‌ୟାଁଏ । ");
INSERT INTO unx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ପାବିତାର୍‌ ଅନଲ୍‌କରେ ଅଲାକାନ୍‌ ଲେକା, ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌କେ ଗଜଃଲାଗାତିୟାଃଁ । ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌କେ ବାଇରିକଆଃ ତିଃଇରେ ସାବ୍‌ରିକାନିଃ ହାୟ୍ ହାୟ୍ ଚିମିନ୍‌ ଦୁକୁନାମେୟାଏ । ଏନ୍‌ ହଡ଼ କାଏ ଜାନାମ୍‌କାନ୍‌ରେଦ ଇନିଃ ନାଗେନ୍ତେ ବୁଗିକାନ୍‌ତେଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ଏନ୍ତେ ୟୀଶୁକେ ସାବ୍‌ରିକାଇନିଃ ଯିହୁଦା କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେ ଗୁରୁ, ଇନିଃ ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ଚି ?” ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ହେଗି, ଆମ୍‌ଗି ତାନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ଚେଲାକ ଜମ୍‌ତାଇକେନ୍‌ ଇମ୍‌ତା ୟୀଶୁ ମିଆଁଦ୍‌ ହଲଙ୍ଗ୍‌ ଇଦିକେଦ୍‌ତେ ଆଶିଷ୍‌କେଦାଏ ଆଡଃ ଏନାକେ କେଚାଃକେଦ୍‌ତେ ଆୟାଃ ଚେଲାକକେ ଏମ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ନେ ତେଲାଏପେ ଆଡଃ ଜମେପେ, ନେଆଁଁ ଆଇଁୟାଃ ହଡ଼୍‌ମ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ଏନ୍ତେ ଇନିଃ କାଟୋରା ଇଦିକେଦ୍‌ତେ ଆଶିଷ୍‌କେଦାଏ ଆଡଃ ଏନା ଇନ୍‌କୁକେ ଏମ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ଆପେ ସବେନ୍‌ ନେଆଁଁଏତେ ନୁଁଏପେ । ");
INSERT INTO unx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ନେଆଁଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଜିନାମାକେ ମୋହର୍‌କାଦ୍‌ ଆଇଁୟାଃ ମାୟୋମ୍‌ ତାନାଃ । ଅକ୍‌ନାଃଚି ପୁରାଃ ହଡ଼କଆଃ ପାପ୍‌ ଛାମା ନାଗେନ୍ତେ ନେ ମାୟୋମ୍‌ ଲିଙ୍ଗିଆକାନା । ");
INSERT INTO unx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆପୁଇଁୟାଃ ରାଇଜ୍‌ରେ ଆପେଲଃ ନାୱା ଦାଖ୍‌ରାସି ଆଉରିଙ୍ଗ୍‌ ନୁଁଇ ଜାକେଦ୍‌, ନାହାଁଃଏତେ ନେ ଦାଖ୍‌ରାସି ଆଡଃ ଚିଉଲାଅ କାଇଙ୍ଗ୍‌ ନୁଁଇଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ଏନ୍ତେ ଇନ୍‌କୁ ମାଇନାନ୍‌ ଦୁରାଙ୍ଗ୍‌ ଦୁରାଙ୍ଗ୍‌କେଦ୍‌ତେ ଜାଇତୁନ୍‌ ବୁରୁତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ଏନ୍ତେ ୟୀଶୁ ଚେଲାକକେ କାଜିୟାଦ୍‍କଆଏ, “ଆପେ ସବେନ୍‌କ ନେ ନିଦାରେ ଆଇଙ୍ଗ୍‌କେ ବାଗିକେଦ୍‌ତେ ନିର୍‌କଆଃପେ, ନେଆଁଦ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ପାର୍‌ମେଶ୍ୱାର୍‌ ଗୁପିନିଃକେ ଦାଲିୟାଏ ଆଡଃ ଗୋଟ୍‌ରେନ୍‍ ମିଣ୍ଡିକ ଛିତିବିତିୟଃଆ ।’ ");
INSERT INTO unx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଜୀଉବିରିଦ୍‌କେଦ୍‌ତେ ଗାଲିଲ୍‌ ପାର୍‌ଗାନ୍‌ତେ ଆପେଏତେ ଆୟାର୍‌ରେଇଙ୍ଗ୍‌ ସେନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ଆଡଃ ପାତ୍‌ରାସ୍‌ ୟୀଶୁକେ କାଜିକିୟାଏ, “ଏଟାଃକ ବାଗିତାମ୍‌ରେହଁ, ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ କାଇଙ୍ଗ୍‌ ବାଗିମେଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ୟୀଶୁ ପାତ୍‌ରାସ୍‌କେ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାମ୍‌ତାନା, ନେ ନିଦାରେ ସାଣ୍ଡିସିମ୍‌କ ରାଃଏ ସିଦାରେ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ କାଇଙ୍ଗ୍‌ ସାରିୟା ମେନ୍ତେ ଆପିସାମ୍‌ କାଜିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପାତ୍‌ରାସ୍‌ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଙ୍ଗ୍‌କେ ଆମାଃଲଃ ଗଜଃ ଲାଗାତିଙ୍ଗ୍‌ରେୟ ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ କାଇଙ୍ଗ୍‌ ସାରିୟା ମେନ୍ତେ କାଇଙ୍ଗ୍‌ଗି କାଜିୟା,” ଆଡଃ ସବେନ୍‌ ଏଟାଃ ଚେଲାକହ ଏନ୍‍ଲେକାଗି କାଜିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ଗେଥ୍‌ସିମାନି ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ବାଖ୍‌ଡ଼ିତେକ ସେନଃୟାନା, ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଏନ୍ତାଃରେ ବିନ୍ତି ଜାକେଦ୍‌ ଆପେ ନେତାଃରେ ଦୁବ୍‍ପେ ଆଡଃ ବିନ୍ତିପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ଇନିଃ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଜେବଦୀୟାଃ ବାରାନ୍‌ ହନ୍‌କିନ୍‌କେ ଆୟାଃଲଃ ଇଦିକେଦ୍‌କଆଏ, ଆଡଃ ଇନିଃ ପୁରାଃଗି ଦୁକୁତେ ଆକୁଲ୍‌ବାକୁଲ୍‌ୟାନା, ");
INSERT INTO unx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, “ଜୀଉତାଇୟାଁଃ ଗଜଃଲେକା ଦୁକୁଃତାନା, ନେତାଃରେଗି ତାଇନ୍‌କାନ୍‌ପେ ଆଡଃ ଆଇଁୟାଃଲଃ ଏୟନାକାନ୍‌ ତାଇନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଆଡଃ ୟୀଶୁ କାଟିଃ ସାଙ୍ଗିନ୍‌ ସେନ୍‌କେଦ୍‌ତେ ଅତେରେ ଇକ୍‌ଡ଼ୁମ୍‌ୟାନ୍‌ଲଃ ଅମ୍ବାଃୟାନାଏ ଆଡଃ ବିନ୍ତିକେଦାଏ, “ହେ ଆବା, ହବାଦାଡ଼ିୟଃରେଦ ନେ ଦୁକୁରାଃ କାଟୋରା ଆଇଙ୍ଗ୍‌ତାଃଏତେ ଇଦିୟଃକା, ଏନ୍‌ରେୟ ଆଇଁୟାଃ ମନେଲେକାଦ କା ମେନ୍‌ଦ ଆମାଃ ମନେଲେକାଗି ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ଏନ୍ତେ ୟୀଶୁ ଚେଲାକତାଃ ରୁହାଡ଼୍‌ୟାନ୍‌ଚି ଇନ୍‌କୁକେ ଦୁଡ଼ୁମାକାନ୍‌ ନାମ୍‍କେଦ୍‍କଆଏ, ଆଡଃ ପାତ୍‌ରାସ୍‌କେ କାଜିକିୟାଏ, “ଆପେ ଆଇଁୟାଃଲଃ ମିଦ୍‌ଘାଣ୍ଟାହଁ ଏୟନ୍‌କେଦ୍‌ତେ କାପେ ତାଇନ୍‌ ଦାଡ଼ିକେନା ? ");
INSERT INTO unx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ବିଡ଼ାଅରେ ଆଲ୍‌ପେ ଉୟୁଗଃକା ମେନ୍ତେ ଏୟନାକାନ୍‌ ତାଇନ୍‌ପେ ଆଡଃ ବିନ୍ତିପେ । ଆତ୍ମାଦ ସାନାଙ୍ଗ୍‌ତାନାଏ, ମେନ୍‌ଦ ହଡ଼୍‌ମ ନାରାଦୁରାଗିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଇନିଃ ଆଡଃମିସା ସେନଃୟାନାଏ ଆଡଃ ବିନ୍ତିକେଦାଏ, “ହେ ଆଇଁୟାଃ ଆବା, ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ନୁଁ ଜାକେଦ୍‌ ନେ ଦୁକୁରାଃ କାଟୋରା ଆଇଙ୍ଗ୍‌ତାଃଏତେ କା ଇଦି ଦାଡ଼ିୟଃରେଦ, ଆମାଃ ମନେ ଲେକାଗି ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ଇନିଃ ଇନ୍‌କୁତାଃ ହିଜୁଃରୁହାଡ଼୍‌ୟାନ୍‌ଚି ଆଡଃମିସା ଦୁଡ଼ୁମାକାନ୍‌ ନାମ୍‍କେଦ୍‍କଆଏ, ଚିୟାଃଚି ଇନ୍‍କୁଦ ଦୁଡ଼ୁମ୍‍ତେ ମେଦ୍‌ତାକଆଃ ଆରିଦ୍‌ କାକ ଦାଡ଼ିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ୟୀଶୁ ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌ତେ ଆଡଃଗି ସେନଃୟାନା ଆଡଃ ଏନ୍‍ ଲେକାଗି ଆପିସାଏ ବିନ୍ତିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଚେଲାକତାଃ ହିଜୁଃକେଦ୍‌ତେ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ନାହାଁଃ ଜାକେଦ୍‌ଚିପେ ଦୁଡ଼ୁମ୍‍ତାନା ଆଡଃ ରୁଡ଼ୁନ୍‌ତାନା ? ନେଲେପେ, ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ପାପିକଆଃ ତିଃଇରେ ସାବ୍‌ରିକାଅଃତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ବିରିଦ୍‌ପେ, ଦଲାବୁ ସେନଆଃ ! ନେଲିପେ, ଆଇଙ୍ଗ୍‌କେ ସାବ୍‍ରିକାଇଙ୍ଗ୍‌ନିଃ ସେଟେରାକାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ୟୀଶୁ ନେଆଁଁ କାଜିତାନ୍ ଇମ୍‍ତାଗି ଗେଲ୍‌ବାର୍‌ ଚେଲାକଏତେ ମିଆଁଦ୍‌ନିଃ ଯିହୁଦା ନୁତୁମ୍‌ ଚେଲା ହିଜୁଃୟାନାଏ, ଇନିଃଲଃ ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ତାରାଉଡ଼ି ଆଡଃ ଭଙ୍ଗାଟ୍‌କ ସାବ୍‌କେଦ୍‌ତେ ହିଜୁଃୟାନାକ । ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ପ୍ରାଚିନ୍‌କ ଇନ୍‌କୁକେ କୁଲାକାଦ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","“ଆଇଙ୍ଗ୍‌ ଅକ୍‌ନିଃକେ ଚଅଃ'ଇଙ୍ଗ୍‌ ଇନିଃକେଗି ସାବ୍‌କିତେ ତଲିପେ” ମେନ୍ତେ ୟୀଶୁକେ ସାବ୍‍ରିକାନିଃ ଯିହୁଦା ଏନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କକେ ଚିହ୍ନାଁ ଏମାକାଦ୍‌କ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଯିହୁଦା, ୟୀଶୁଆଃ ନାଡ଼େଃ ସେନ୍‌କେଦ୍‌ତେ, “ହେ ଗୁରୁ, ଜହାର୍‌” ମେତାଇୟାଏ ଆଡଃ ଇନିଃକେ ଚଅଃ'କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଏ ଗାତି ଆମ୍‌ ଅକନ୍‌ କାମିନାଙ୍ଗ୍‌ ହିଜୁଆକାନାମ୍‌ ଏନା ରିକାଧାବେମେ ।” ଏନ୍ତେ ଇନ୍‌କୁ ନାଡ଼େଃ ହିଜୁଃକେଦ୍‌ତେ ୟୀଶୁକେ ସାବ୍‌କେଦ୍‌ତେ ତଲ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ୟୀଶୁଲଃ ତାଇକେନ୍‌ ହଡ଼କଏତେ ମିହୁଡ଼୍‌ ଆୟାଃ ତାରାଉଡ଼ି ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ରାଃ ଦାସିଆଃ ଲୁତୁର୍‌କେ ମାଆଃ ଖାଣ୍ଡାଅକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆମାଃ ତାରାଉଡ଼ିକେ ଖାପ୍‍ରେ ଦହଏମେ, ଚିୟାଃଚି ତାରାଉଡ଼ି ସାବ୍‌କେଦ୍‌ତେ କାମିତାନ୍ ସବେନ୍‍କଦ ତାରାଉଡ଼ିତେକ ଗଜଃଆ । ");
INSERT INTO unx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ଆପେ ଚିନାଃ କାପେ ସାରିତାନା, ଆଇଁୟାଃ ଆପୁଇଙ୍ଗ୍‌କେ ବିନ୍ତିଲେରେ, ଇନିଃ ଚିନାଃ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଇମ୍‌ତାଗି ଗେଲ୍‌ବାର୍‌ ଫାଉଦ୍‌ତାଃଏତେ ଆଦ୍‌କା ଦୁଁତ୍‌କକେ କାଏ କୁଲ୍‌ଦାଡ଼ିୟା ? ");
INSERT INTO unx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ମେନ୍‌ଦ ନେ ଲେକାତେ ହବାଅଃଗି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ମେନ୍ତେ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ତେୟାଃ ଚିଲ୍‌କାତେ ପୁରାଅଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ଏନ୍‌ ଦିପିଲିରେ ୟୀଶୁ ଗାଦେଲ୍‌ ହଡ଼କକେ ମେତାଦ୍‌କଆ, “ଚିୟାଃ କୁମ୍ବୁଡ଼ୁ ଲେକା ସାବିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ତାରାଉଡ଼ିକ ଆଡଃ ଭଙ୍ଗାଟ୍‌କ ସାବ୍‌କେଦ୍‌ତେ ହିଜୁଃକାନାପେ ? ଆଇଙ୍ଗ୍‌ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଦୁବ୍‌କେଦ୍‌ତେ ଇତୁକ ତାଇକେନାଇଙ୍ଗ୍‌ ଆଡଃ ଆପେ ଆଇଙ୍ଗ୍‌କେ କାପେ ସାବ୍‌କେଦିୟାଁ । ");
INSERT INTO unx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ମେନ୍‌ଦ ଧାରାମ୍‌ପୁଥିରେ ନାବୀକ ଅଲାକାଦ୍‌ତେୟାଃ ପୁରାଅଃ ନାଗେନ୍ତେ ନେ ସବେନାଃ ହବାୟାନା ।” ଏନ୍ତେ ସବେନ୍‌ ଚେଲାକ ଇନିଃକେ ବାଗିକିୟାକ ଆଡଃ ନିର୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ୟୀଶୁକେ ସାବାକାଇ ହଡ଼କ ଇନିଃକେ କାୟଫା ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଅଡ଼ାଃତେକ ଇଦିକିୟା, ଏନ୍ତାଃରେ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ପ୍ରାଚିନ୍‌କ ହୁଣ୍ଡିୟାକାନ୍‍କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ ସାଙ୍ଗିନ୍‍ଏତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଅଡ଼ାଃରାଚା ଜାକେଦ୍‌ ଅତଙ୍ଗ୍‌କେଦ୍‌କଆଏ ଆଡଃ ଟୁଣ୍ଡୁରେ ଚିନାଃ ହବାଅଆଃ ଏନା ନେନେଲ୍‌ ନାଗେନ୍ତେ ଇନିଃ ଭିତାର୍‌ ବଲକେଦ୍‌ତେ ଏନ୍ତାଃରେ ଦାରୱାନ୍‌କଲଃ ଦୁବ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଯିହୁଦୀ ପାଞ୍ଚେଟ୍‌ରେନ୍ ସବେନ୍‌କ ୟୀଶୁକେ ଗଗଏଃ ନାଗେନ୍ତେ ହସଡ଼ ଗାୱାକ ଦାଣାଁଁବାଡ଼ା ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ମେନ୍‌ଦ ପୁରାଃ ହଡ଼କ ହସଡ଼ ଗାୱାକ ଏମ୍‌କେଦ୍‌ରେୟ ଜେତ୍‌ନାଃ କାକ ନାମ୍‌କେଦା, ଏନ୍ତେ ଟୁଣ୍ଡୁରେ ବାର୍‌ହଡ଼୍‌ ଆୟାର୍‌ତେ ହିଜୁଃକେଦ୍‌ତେ କାଜିକେଦାକିନ୍‌, ");
INSERT INTO unx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ନେ ହଡ଼ କାଜିକାଦ୍‌ ତାଇକେନାଏ, ‘ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃକେ ହାଦୁଡ଼୍‌କେଦ୍‌ତେ ଆପିମାରେ ଏନାକେ ବାଇରୁହାଡ଼୍‌ ଦାଡ଼ିୟାଇଙ୍ଗ୍‌ ।’” ");
INSERT INTO unx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ୟୀଶୁକେ କାଜିକିୟା, “ନେ ହଡ଼କ ଆମାଃ ବିରୁଧ୍‌ରେ ଗାୱାକ ଏମ୍‌ତାନା, ଆମ୍‌ ଚିକାନାଙ୍ଗ୍‌ ଇନ୍‌କୁକେ କାମ୍‌ କାଜିରୁହାଡ଼୍‌କତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ମେନ୍‌ଦ ୟୀଶୁ ହାପାକାନ୍‍ ତାଇକେନାଏ, ଇମ୍‌ତା ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଆଡଃଗି କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ଜୀନିଦ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନୁତୁମ୍‌ତେ କିରିୟାନ୍‌ତାନ୍‌ଲଃ କୁଲିମେ ତାନାଇଙ୍ଗ୍‌, ସାର୍‌ତିଗି କାଜିୟାଲେମ୍‌, ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ତାନ୍‍ମେଚି ?” ");
INSERT INTO unx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆମ୍‌ ଠାଉକାଗି କାଜିକେଦାମ୍‌, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେ ସବେନ୍‌କକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ନାହାଁଃଏତେ ଆପେ ମାନୱାହନ୍‌କେ ସବେନ୍‌ ପେଡ଼େୟାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଜମ୍‌ତିସାଃରେ ଦୁବାକାନ୍‌ ଆଡଃ ସିର୍ମାରାଃ ରିମିଲ୍‌ରେ ହିଜୁଃତାନ୍‍ପେ ନେଲିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଆୟାଃ ଲିଜାଃ ଚେଚାଃକେଦ୍‍ତେ କାଜିକେଦାଏ, “ନିଃଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହିଲାଙ୍ଗ୍‌କାଜି କାଜିକେଦା, ଆଡଃ ଆବୁକେ ଚିକାନ୍‌ ଗାୱା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ? ନେଲେପେ, ଆପେଦ ନାହାଁଃଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନିନ୍ଦାକାଜିପେ ଆୟୁମ୍‌କେଦା, ");
INSERT INTO unx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ଆପେ ଚିନାଃପେ ଉଡ଼ୁଃତାନା ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କେଦାକ, “ଇନିଃ ଚିଟାକାନ୍‌ନିଃ ତାନିଃ, ଇନିଃକେ ଗଜଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିୟାଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ରେ ବେଏକ୍‌କିତେ ଦାଲ୍‌କିୟାକ ଆଡଃ ଏଟାଃକ ଥାପ୍‌ଡ଼ିତାନ୍‍ଲଃ ");
INSERT INTO unx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","କାଜିକିୟାକ, “ଏ ଖ୍ରୀଷ୍ଟ୍‌ ! ଆମ୍‌ ପରେ ନାବୀ ତାନ୍‌ମେ, ମାର୍‌ କାଜିଲେମେ, ଆମ୍‌କେ ଅକଏ ଦାଲ୍‌ମେତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ପାତ୍‌ରାସ୍‌ ବାହାରି ଅଡ଼ାଃରାଚାରେ ଦୁବାକାନ୍‌ ତାଇକେନାଏ, ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ରାଃ ମିଆଁଦ୍‌ କାମ୍‌ଡ଼ି ଇନିୟାଃ ନାଡ଼େଃତେ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟାଏ, “ଆମ୍‌ହ ଗାଲିଲ୍‌ରେନ୍‍ ୟୀଶୁଲଃ ତାଇକେନାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ ସବେନ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଦଦାଦ୍‌ତାନ୍‌ଲଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆମ୍‌ ଚିନାଃମ୍‌ କାଜିତାନା ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ସାରିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ଆଡଃ ଇନିଃ ବାହାରି ଅଡ଼ାଃରାଚାରେୟାଃ ବଲଦୁଆର୍‌ତାଃତେ ସେନଃୟାନା । ଆଡଃମିଆଁଦ୍‌ କାମ୍‌ଡ଼ି ଇନିଃକେ ନେଲ୍‍କେଦ୍‍ତେ ଏନ୍ତାଃରେ ତାଇକାନ୍‌ ହଡ଼କକେ ମେତାଦ୍‌କଆ, “ନିଃଦ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁଲଃ ତାଇକେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ଇନିଃ ଆଡଃମିସା କିରିୟାତାନ୍‌ଲଃ ଦଦାଦ୍‌ୟାନାଏ ଆଡଃ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ଏନ୍‍ ହଡ଼କେ କାଇଙ୍ଗ୍‌ ସାରିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ଘାଡ଼ିକାଦ୍‍ ତାୟମ୍‌ତେ ନାଡ଼େଃରେ ତିଙ୍ଗୁଆକାନ୍‍କ ପାତ୍‌ରାସ୍‌ତାଃତେ ସେନ୍‌କେଦ୍‌ତେ କାଜିକିୟାକ, “ଆମ୍‌ହ ସାର୍‌ତିଗି ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ତାନ୍‌ମେ, ଚିୟାଃଚି ଆମାଃ ଜାଗାର୍‌ ଉଦୁବେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ କିରିୟାକେଦ୍‌ତେ ସାର୍‌ତିଗି କାଜିତାନାଇଙ୍ଗ୍‌, କାହାରେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌କେ ସାଜାଇ ଏମାଇଙ୍ଗ୍‌କାଏ, ଆଇଙ୍ଗ୍‌ ଏନ୍‌ ହଡ଼କେ କାଇଙ୍ଗ୍‌ ସାରିୟା,” ଇମ୍‌ତାଙ୍ଗି ସାଣ୍ଡିସିମ୍‌ ରାଆଃକେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ଆଡଃ “ସାଣ୍ଡିସିମ୍‌ ଆଉରି ରାଆଃ ସିଦାରେ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଆପିସା କାଇଙ୍ଗ୍‌ ସାରିୟା ମେନ୍ତେ କାଜିୟାମ୍‌” ମେନ୍ତେ ୟୀଶୁ କାଜିକାଇ କାଜିକେ ପାତ୍‌ରାସ୍‌ ପାହାମ୍‍କେଦାଏ ଆଡଃ ଇନିଃ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ କୁସୁଦ୍‌ କୁସୁଦ୍‌ତାନ୍‌ ରାଆଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ସେତାଃ ଇଦାନ୍‌ରେ ସବେନ୍‌ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ହଡ଼କଆଃ ପ୍ରାଚିନ୍‌କ ୟୀଶୁକେ ଗଜି ନାଗେନ୍ତେକ ରଜୋଟକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ଇନ୍‌କୁ ୟୀଶୁକେ ସିକ୍‌ଡ଼ିତେ ତଲ୍‌କେଦ୍‌ତେ ରୋମିରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ପିଲାତୁସ୍‌ତାଃରେକ ଜିମାକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ବାଇରିକଆଃ ତିଃଇରେ ସାବ୍‌ରିକାକାଇ ଯିହୁଦା, ୟୀଶୁଆଃ ଗନଏଃ ସାଜାଇରେୟାଃ ବିଚାର୍‌ ଆୟୁମ୍‌କେଦ୍‌ତେ ହେୟାତିଙ୍ଗ୍‌କେଦା ଆଡଃ ଏନ୍‍ ତିରିଶ୍‌ଠୁ ରୁପା ସିକା ରୁହାଡ଼୍‌ ନାଗେନ୍ତେ ମୁଲ୍‌ ଯାଜାକ୍‌ ଆଡଃ ପ୍ରାଚିନ୍‌କତାଃ ଆଉକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ଆଡଃ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ମିହୁଡ଼୍‌ କା ଚିଟାଃଅ ହଡ଼କେ ଗଏଃ ନାଗେନ୍ତେ ବାଇରିକଆଃ ତିଃଇରେ ଜିମାକେଦ୍‌ତେ ପାପ୍‌କାଦାଇଙ୍ଗ୍‌,” ମେନ୍‌ଦ ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଏନାରେ ଆଲେ ଚିନାଃ ଚିକାୟାଲେ ? ଏନା ଆମ୍‌ଗି ସାରିମେ !” ");
INSERT INTO unx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ଯିହୁଦା ଏନ୍‍ ସିକାକେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ହୁଦ୍‌ମାକେଦ୍‌ତେ ସେନଃୟାନା ଆଡଃ ଆଇଃକ୍‌ଗି ହାକା ଗଏଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ମୁଲ୍‌ ଯାଜାକ୍‌କ ଏନ୍‍ ସିକା ଆଉକେଦ୍‌ତେ କାଜିକେଦାକ, “ନେଆଁଦ ମାୟୋମ୍‌ରେୟାଃ ଟାକା ତାନାଃ, ଆଇନ୍‌ ଲେକାତେ ନେଆଁଁକେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେୟାଃ ଖୁର୍ଜିଅଡ଼ାଃରେ ଦହ ନାଙ୍ଗ୍‌ କା ବୁଗିନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ଏନ୍ତେ ଇନ୍‌କୁ ନେ ବିଷାଏରେ ସାଲ୍‌ହାକେଦ୍‌ତେ, ଏଟାଃ ଦିଶୁମ୍‍ରେନ୍‌କକେ ତପାକ ନାଗେନ୍ତେ ଏନ୍‍ ଟାକାତେ କୁମ୍ଭାର୍‌ଆଃ ଅତେକେ କିରିଙ୍ଗ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ଏନାମେନ୍ତେ ଏନ୍‍ ଅତେକେ ତିସିଙ୍ଗ୍‌ ଜାକେଦ୍‌ “ମାୟୋମ୍‌ରେୟାଃ ଅତେ” ମେନ୍ତେକ କାଜିତାନା । ");
INSERT INTO unx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ଏନ୍ତେ ନେ ବିଷାଏରେ ଯିରିମିୟ ନାବୀ କାଜିକାଦ୍‌ କାଜି ପୁରାୟାନା, “ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କ ଇନିୟାଃ ନାଙ୍ଗ୍‌ ଠାହାରାଅକାଦ୍‌ ଗନଙ୍ଗ୍‌କେ ଚାଏ ଏନ୍‌ ତିରିଶ୍‌ଠୁ ରୁପା ସିକା ଇଦିକେଦ୍‌ତେ, ");
INSERT INTO unx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ଆଇଁୟାଃ ପ୍ରାଭୁଆଃ ଆଚୁ ଲେକା ଇନ୍‌କୁ କୁମ୍ଭାର୍‌ଆଃ ଅତେକ କିରିଙ୍ଗ୍‌କେଦା ।” ");
INSERT INTO unx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ୟୀଶୁକେ ରୋମିରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ପିଲାତୁସ୍‌ଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ତିଙ୍ଗୁକିୟାକ, ଆଡଃ ଲାଟ୍‌ସାହେବ୍‌ ଇନିଃକେ କୁଲିକିୟାଏ, “ଆମ୍‌ ଯିହୁଦୀକଆଃ ରାଜା ତାନ୍‍ମେଚି ?” ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେଗି, ଆମ୍‌ଗି କାଜିତାନାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ପ୍ରାଚିନ୍‌କ ଇନିଃକେ ଚିଟାଇତାନ୍‍ ଇମ୍‌ତା ଇନିଃ ଜେତ୍‌ନାଃ କାଏ କାଜିରୁହାଡ଼୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ଏନ୍ତେ ପିଲାତୁସ୍‌ ଇନିଃକେ କାଜିକିୟାଏ, “ଇନ୍‌କୁ ଆମାଃ ବିରୁଧ୍‌ରେ ଚିଟାନାଙ୍ଗ୍‌ ପୁରାଃ ଗାୱାକ ଏମ୍‌ତାନା ଏନା ଚିନାଃ କାମ୍‌ ଆୟୁମେତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ମେନ୍‌ଦ ୟୀଶୁ ମିଆଁଦ୍‌ କାଜିୟ କାଏ କାଜିକେଦା, ଏନାମେନ୍ତେ ଲାଟ୍‌ସାହେବ୍‌ ପୁରାଃଗି ଆକ୍‌ଦାନ୍ଦାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ରୋମିରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ଆଃ ରିତିଲେକାତେ ପାସ୍‌କା ପାରାବ୍‌ ଦିପିଲିରେ ଗାଦେଲ୍‌ ହଡ଼କଆଃ ମନେଲେକା ମିଆଁଦ୍‌ ଜେହେଲାକାନ୍‌ନିଃକେ ଇନ୍‌କୁଆଃ ନାଗେନ୍ତେ ଆଡ଼ାଗାକତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ଏନ୍‍ ଦିପିଲିରେ ବାରବ୍‌ବା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ନାମିକୁମ୍ବୁଡ଼ୁ ଜେହେଲ୍‌ରେ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ଏନ୍ତେ ଇନ୍‌କୁ ହୁଣ୍ଡିକାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‍କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆପେୟାଃ ନାଗେନ୍ତେ ଅକଏକେଇଙ୍ଗ୍‌ ଆଡ଼ାଃଇୟା ମେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନା ? ବାରବ୍‌ବାକେ ଚି ଖ୍ରୀଷ୍ଟ୍‌ ନୁତୁମଃତାନ୍‌ ୟୀଶୁକେ ?” ");
INSERT INTO unx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ଚିୟାଃଚି ଯିହୁଦୀକଆଃ ପ୍ରାଚିନ୍‌କ ହିସ୍‌ଙ୍ଗାତେ ଇନିଃକେକ ଜିମାକିୟା, ଏନା ପିଲାତୁସ୍‌ ସାରିତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ପିଲାତୁସ୍‌ ବିଚାର୍‌ ଠାୟାଦ୍‌ରେ ଦୁବାକାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଆୟାଃ କୁଡ଼ି, “ଏନ୍‌ ଧାର୍‌ମାନ୍‌ ହଡ଼କେ ଜେତ୍‌ନାଃ ଆଲମ୍‌ ରିକାଇୟା, ଚିୟାଃଚି ଇନିୟାଃ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ କୁମୁରେ ତିସିଙ୍ଗ୍‌ ନିଦାରେ ପୁରାଃଗି ଦୁକୁଇଙ୍ଗ୍‌ ନାମାକାଦା” ମେନ୍ତେ କାଜି କୁଲ୍‍କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ମେନ୍‌ଦ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ପ୍ରାଚିନ୍‌କ ବାରବ୍‌ବାକେ ଆସି ନାଙ୍ଗ୍‌ ଆଡଃ ୟୀଶୁକେ ଗଜି ନାଗେନ୍ତେ ଗାଦେଲ୍‌ ହଡ଼କକେ ଉସ୍‍କୁର୍‍କେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ମେନ୍‌ଦ ରୋମିରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ଗାଦେଲ୍‌ ହଡ଼କକେ କୁଲିକେଦ୍‌କଆଏ, “ନେ ବାରାନ୍‌କିନ୍‌ଏତେ ଆପେୟାଃ ନାଗେନ୍ତେ ଅକଏକେଇଙ୍ଗ୍‌ ଆଡ଼ାଃଇୟା ମେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନା ?” ଇନ୍‌କୁ “ବାରବ୍‌ବାକେ” ମେନ୍ତେକ କାଜିରୁହାଡ଼୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‍କଆଏ, “ଖ୍ରୀଷ୍ଟ୍‌ ନୁତୁମ୍‌ ୟୀଶୁକେ ଆଇଙ୍ଗ୍‌ ଚିନାଃ ଚିକାଇୟାଇଙ୍ଗ୍‌ ?” ଇନ୍‌କୁ ସବେନ୍‌କ କାଉରିକେଦ୍‌ତେ କାଜିରୁହାଡ଼୍‌କିୟା, “ଇନିଃକେ କ୍ରୁଶ୍‌ରେ କିଲାଇମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ମେନ୍‌ଦ ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‍କଆଏ, “ଚିକାନାଙ୍ଗ୍‌ ଇନିଃ କିଲାୱାଏଃ ଚିକାନ୍‌ ଗୁହ୍ନାଁ ରିକାକାଦାଏ ?” ମେନ୍‌ଦ ଇନ୍‌କୁ ପୁରାଃତେକ କାଉରିକେଦା, “କ୍ରୁଶ୍‌ରେ କିଲାଅଃକାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ଏନ୍ତେ ପିଲାତୁସ୍‌ ଜେତ୍‌ନାଃ ରିକା କାଏ ଦାଡ଼ିକେନା, ମେନ୍‌ଦ ଆଦ୍‌କା ପୁରାଃ ହାଲାଗୁଲାଅଃତାନା, ନେଆଁଁ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ଦାଆଃ ଆଉକେଦାଏ ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଆୟାଃ ତିଃଇ ଆବୁଙ୍ଗ୍‌କେଦ୍‌ତେ କାଜିକେଦାଏ, “ନେ ହଡ଼ଆଃ ଗନଏଃ ମାୟୋମ୍‌ରେ ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ଚିଟାନାଃ, ଏନା ଆପେୟାଃ କାମିତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ସବେନ୍‌ ହଡ଼କ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ୟୀଶୁଆଃ ଗନଏଃରାଃ ଗୁହ୍ନାଁ ଆଲେୟାଃରେ ଆଡଃ ଆଲେୟାଃ ହନ୍‍କଆଃରେ ଠଗଃକା ।” ");
INSERT INTO unx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ଏନ୍ତେ ପିଲାତୁସ୍‌ ବାରବ୍‌ବାକେ ଇନ୍‌କୁ ନାଗେନ୍ତେ ଆଡ଼ାଃକିୟା, ମେନ୍‌ଦ ୟୀଶୁକେ ହାଁଣ୍‌ସା ରିକାକେଦ୍‌ତେ କ୍ରୁଶ୍‌ରେ କିଲାଅଃକାଏ ମେନ୍ତେ ସିପାଇକଆଃ ତିଃଇରେ ଜିମାକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ଏନ୍ତେ ପିଲାତୁସ୍‌ଆଃ ସିପାଇକ ୟୀଶୁକେ ରୋମିରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ଆଃ ଅଡ଼ାଃ ଭିତାର୍‌ତେ ଇଦିକେଦ୍‌ତେ ଗଟା ପାଲ୍‌ଟାନ୍‍କରେନ୍‌କକେ ହୁଣ୍ଡିକେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ଇନ୍‌କୁ ଇନିୟାଃ ଲିଜାଃ ହଲେଃକ୍‌କେଦ୍‌ତେ ଇନିଃକେ ମିଆଁଦ୍‌ ବାଇଗିନିଆ ଲିଜାଃକ ତୁସିଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ଏନ୍ତେ ଜାନୁମ୍‌ କତ ଗାଲାଙ୍ଗ୍‌କେଦ୍‍ତେ ମୁକୁଟ୍‌କ ବାଇକେଦା ଏନ୍ତେ ଇନିୟାଃ ବହଃରେକ ଟୁପୁରିକିଆ ଆଡଃ ଇନିୟାଃ ଜମ୍‌ ତିଃଇରେ ମିଆଁଦ୍‌ ସଟାକ ଏମ୍‌କିୟା ଆଡଃ ଇନିୟାଃ ଆୟାର୍‌ରେ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ, “ଏ ଯିହୁଦୀକଆଃ ରାଜା ଜାନାଅ ଜାକେଦ୍‌ ତାଇନ୍‌ମେ” ମେନ୍ତେ କାଜିକେଦ୍‌ତେ ଇନିଃକେକ ଲାନ୍ଦାକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ବେଏକ୍‌କିୟାକ ଆଡଃ ଏନ୍‍ ପାଇପ୍‌ ଇଦିକେଦ୍‌ତେ ଇନିୟାଃ ବହଃରେକ ଦାଲ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ଇନ୍‌କୁ ଇନିଃକେ ଲାନ୍ଦା ଚାବାକିତେ, ଏନ୍‍ ଲିଜାଃକ ହଲେଃକ୍‌କେଦା ଆଡଃ ଆୟାଃ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌କିତେ କ୍ରୁଶ୍‌ରେ କିଲାଇ ନାଗେନ୍ତେକ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ଇନ୍‌କୁ ସାହାର୍‌ଏତେ ସେନଃତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‍ତାଗି ଶିମୋନ୍‌ ନୁତୁମ୍‌ କୁରିନି ସାହାର୍‌ରେନ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ନେଲ୍‌କେଦ୍‌ତେ ୟୀଶୁଆଃ କ୍ରୁଶ୍‌ ଗଅଃ ନାଗେନ୍ତେ ଇନିଃକେ ଜାବାର୍‌ଜାସ୍ତିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ଇନ୍‌କୁ ଗାଲ୍‌ଗାଥା, ନେଆଁଁରାଃ ମୁଣ୍ଡିଦ “ବହଃଜାଙ୍ଗ୍‌” ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଠାୟାଦ୍‌ତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ଏନ୍ତାଃରେ ଇନ୍‌କୁ ଇନିଃକେ ମେହେର୍‍ତେଆଃ ମେସାକାନ୍‍ ଦାଖ୍‌ରାସି ନୁଁଇ ନାଗେନ୍ତେକ ଏମ୍‌କିୟା, ମେନ୍‌ଦ ଇନିଃ ଏନାକେ ଚାଖାଅକେଦ୍‍ତେ ନୁଁ କାଏ ଦାଡ଼ିକେନା । ");
INSERT INTO unx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ଇନ୍‌କୁ ୟୀଶୁକେ କ୍ରୁଶ୍‌ରେ କିଲାକିୟାକ, ଏନ୍ତେ ଇନିୟାଃ ଲିଜାଃକକେ ଇଦି ନାଗେନ୍ତେ ଚିଠା ଉୟୁଃକେଦାକ ଆଡଃ ଲିଜାଃତାୟାଃ ହାଟିଙ୍ଗ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ଏନ୍‌ ତାୟମ୍‌ତେ ଇନ୍‌କୁ ଏନ୍ତାଃରେ ଦୁବ୍‌କେଦ୍‌ତେ ଇନିଃକେକ ହରକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ଆଡଃ ଇନିୟାଃ ବହଃ ଚେତାନ୍‍ରେ ଇନ୍‌କୁ “ନିଃ ଯିହୁଦୀକଆଃ ରାଜା ୟୀଶୁ ତାନିଃ,” ମେନ୍ତେ ଆୟାଃ ବିରୁଧ୍‌ରେ ମିଆଁଦ୍‌ ଚିଠାଅନଲ୍‌ରେ ଅଲ୍‌କେଦ୍‌ତେ ହାକାକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ଏନ୍ତେ ଇନିଃଲଃ ବାର୍‌ହଡ଼୍‌ ରେରେଃକ୍‌କିନ୍‌କେ କ୍ରୁଶ୍‍ରେକ କିଲାକେଦ୍‍କିନା ମିଆଁଦ୍‌ନିଃକେ ଜମ୍‌ସାଃରାଃ କ୍ରୁଶ୍‌ରେ ଆଡଃମିଆଁଦ୍‌ନିଃକେ ଲେଙ୍ଗାତିସାଃରାଃ କ୍ରୁଶ୍‌ରେ । ");
INSERT INTO unx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ଆଡଃ ଏନ୍‌ ହରାରେ ସେନ୍‌ପାରମଃତାନ୍‌ ହଡ଼କ ଆକଆଃ ବହଃ ହିଲାଅକେଦ୍‌ତେ ୟୀଶୁକେ ନିନ୍ଦାତାନ୍‌ଲଃ ଲାନ୍ଦାକିୟାକ, ");
INSERT INTO unx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ଆଡଃ କାଜି ଏଟେଦ୍‌କେଦାକ, “ବାଃରେ, ମାନ୍ଦିର୍‌ ହାଦୁଡ଼୍‌ନିଃ ଆଡଃ ଆପିମାରେ ବାଇରୁହାଡ଼୍‌ନିଃ, ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ତାନ୍‌ମେରେଦ ମାର୍‌ କ୍ରୁଶ୍‌ଏତେ ଆଡ଼୍‌ଗୁନ୍‌ମେ ଆଡଃ ବାଞ୍ଚାଅଏନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ଏନ୍‌ ଲେକାଗି ମୁଲ୍‌ ଯାଜାକ୍‌କ, ଆଇନ୍‌ ଇତୁକ ଆଡଃ ପ୍ରାଚିନ୍‌କ ସବେନ୍‌ ଲାନ୍ଦାକିୟାକ, ");
INSERT INTO unx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ଆଡଃ କାଜିକିୟାକ, “ଇନିଃଦ ଏଟାଃକକେ ବାଞ୍ଚାଅକେଦ୍‍କଆଏ, ମେନ୍‌ଦ ଇନିଃ ଆଇଃକ୍‌ଗି ବାଞ୍ଚାୱେନ୍‌ କାଏ ଦାଡ଼ିତାନ୍‌ । ଇନିଃ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ରାଜା ତାନିଃରେଦ ନାହାଁଃଗି କ୍ରୁଶ୍‌ଏତେ ଆଡ଼୍‌ଗୁନ୍‌କାଏ, ଆଡଃ ଆବୁ ସବେନ୍‌କ ଏନା ନେଲ୍‌କେଦ୍‌ତେ ଇନିଃରେବୁ ବିଶ୍ୱାସେତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ଇନିଃଦ ଆଇଃକ୍‌ଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ତାନିଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିୟାଃଏ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ଭାର୍‌ସାକାଦାଏ । ଠାଉକାଗିୟା, ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ବାଞ୍ଚାଅ ସାନାଙ୍ଗ୍‌ତାନାଏ ଚି କାହା ଏନା ମାର୍‌ବୁ ନେଲେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ଆଡଃ ଇନିଃଲଃ କ୍ରୁଶ୍‌ରେ କିଲାକାନ୍ ଏତ୍‌କାନ୍‌ କାମିକିନ୍‌ହଗି ନେ ଲେକାଗି ଇନିଃକେକିନ୍‌ ଲାନ୍ଦାକିୟା । ");
INSERT INTO unx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ତିକିନ୍‍ସିଙ୍ଗିଏତେ ତାର୍‌ସିଙ୍ଗ୍‌ ତିନ୍‌ଘାଣ୍ଟା ଜାକେଦ୍‌ ଗଟା ଦିଶୁମ୍‌ ନୁବାଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ତାର୍‌ସିଙ୍ଗ୍‌ ତିନ୍‌ବାଜେ ଇମ୍‌ତାକ ୟୀଶୁ ପୁରାଃତେ କାଉରିକେଦ୍‌ତେ କାଜିକେଦାଏ, “ଏଲୋଇ, ଏଲୋଇ, ଲାମା ସାବାକ୍‍ଥାନି ?” ଏନାରାଃ ମୁଣ୍ଡିଦ, “ଏ ଆଇଁୟାଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଏ ଆଇଁୟାଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଚିନାଃମେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ ବାଗିକିଦିୟାଁମ୍ ?” ");
INSERT INTO unx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ଏନ୍ତାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ଚିମିନ୍‌ ହଡ଼କ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ, “ଇନିଃ ଏଲିୟକେ ହାକାଅତାନା” ମେନ୍ତେକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ନିର୍‌ଧାବ୍‍କେଦ୍‍ତେ ସ୍ପଞ୍ଜ୍‌କେ ସାବ୍‌କେଦାଏ ଆଡଃ ମେହେର୍‌ ରାସିରେ ତୁପୁକେଦ୍‍ତେ ମିଆଁଦ୍‌ ଜିଲିଙ୍ଗ୍‌ ସଟାରେୟାଃ ଚୁଟିରେ ଗୁତୁକେଦାଏ, ଏନ୍ତେ ଇନିଃକେ ନୁଁ ନାଗେନ୍ତେ ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ମେନ୍‌ଦ ଏଟାଃକ କାଜିକେଦା, “ରାହା, ନାହାଁଃ ଏଲିୟ ଇନିଃକେ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ହିଜୁଃଆଏ ଚି କାହା ଏନାବୁ ନେଲେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ୟୀଶୁ ଆଡଃମିସା ପୁରାଃଗି କାଉରିକେଦାଏ ଆଡଃ ଜୀଉତାୟାଃ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ଏନ୍ତେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ହାକାକାନ୍‌ ହାନାଟିଙ୍ଗ୍‌ ଦାନାଙ୍ଗ୍‌ଲିଜାଃ ଚେତାନ୍‍ଏତେ ଲାତାର୍‍ ଜାକେଦ୍‌ ଥାଲାରେ ବାର୍‌ ହିସା ଚାଗାଡ଼୍‌ୟାନା ଆଡଃ ଅତେ ଏକ୍‌ଲାଅକେଦ୍‌ତେ ଚାଟେନ୍‌କ ଫାଡ଼ାଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ଆଡଃ ଚିମିନ୍‌ ତପାଗାଡ଼ାକ ଅଟାଃୟାନା ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଚିମିନ୍‌ ଗଜାକାନ୍‌ ପାବିତାର୍‌ ହଡ଼କଆଃ ହଡ଼୍‌ମ ଜୀଉବିରିଦ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ଆଡଃ ଇନ୍‌କୁ ତପାଗାଡ଼ା ବାଗିକେଦ୍‌ତେ ୟୀଶୁଆଃ ଜୀଉବିନିରିଦ୍‌ ତାୟମ୍‌ତେ ପାବିତାର୍‌ ନାଗାର୍‌ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃୟାନାକ । ଏନା ପୁରାଃ ହଡ଼କ ଇନ୍‌କୁକେ ନେଲ୍‌କେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଗମ୍‌କେ ଆଡଃ ଆୟାଃଲଃ ୟୀଶୁକେ ହରଇତାନ୍‌କ ଅତେ ଏକ୍‌ଲାଅଃତେୟାଃ ଆଡଃ ସବେନ୍‌ ହବାୟାନ୍‍ତେୟାଃକ ନେଲ୍‍କେଦ୍‍ତେ ପୁରାଃଗିକ ବରକେଦା ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅଃତାନ୍‌ଲଃ କାଜିକେଦାକ, “ସାର୍‌ତିଗି ନେ ହଡ଼ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‍ଗି ତାଇକେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଏନ୍ତାଃରେ ୟୀଶୁକେ ଦେଙ୍ଗାକାଇ ପୁରାଃ କୁଡ଼ିକ ସାଙ୍ଗିନ୍‍ଏତେ ନେଲି ତାଇକେନାକ । ଇନ୍‌କୁ ଗାଲିଲ୍‌ଏତେ ଅତଙ୍ଗ୍‌ଆଉକାଇ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ଇନ୍‌କୁଏତେ, ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌, ଯାକୁବ୍‌ ଆଡଃ ଯୋଷେଫ୍‌ଆଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌ ଆଡଃ ଜେବଦୀୟାଃ ହନ୍‌କଆଃ ଏଙ୍ଗାତେ, ନେ ସବେନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ଆୟୁବ୍‍ୟାନ୍‍ଚି ହାରାମାଥିୟା ସାହାର୍‌ରେନ୍‌ ଯୋଷେଫ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ କିସାଁଣ୍‌ ହଡ଼ ହିଜୁଃୟାନାଏ, ଇନିଃହଗି ୟୀଶୁଆଃ ମିଆଁଦ୍‌ ଚେଲା ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ଇନିଃ ପିଲାତୁସ୍‍ତାଃତେ ସେନ୍‌କେଦ୍‌ତେ ୟୀଶୁଆଃ ଗଏଃହଡ଼୍‌ମ ଆସିକିୟାଏ, ଏନ୍ତେ ପିଲାତୁସ୍‌ ଇନିୟାଃ ଗଏଃହଡ଼୍‌ମ ଏମାଇ ନାଗେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ଆଡଃ ଯୋଷେଫ୍‌ ୟୀଶୁଆଃ ଗନଏଃ ହଡ଼୍‌ମ ଆଉକେଦ୍‌ତେ ଫାର୍‌ଚି ନିରାଲ୍‌ ଲିଜାଃତେ ପଟମ୍‍କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ଆଡଃ ଇନିଃ ଆୟାଃ ନାଗେନ୍ତେ ଚାଟେନ୍‌ରେ ଉରାକାନ୍‌ ନାୱା ତପାଗାଡ଼ାରେ ଇନିଃକେ ଦହକିୟାଏ ଆଡଃ ତପାଗାଡ଼ା ଦୁଆର୍‌ରେ ମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ଦିରିତେ ବାଟିକେସେଦ୍‍କେଦ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ଆଡଃ ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌ ଆଡଃ ଏଟାଃ ମାରିୟାମ୍‌ ତପାଗାଡ଼ା ହେପାଦ୍‌ରେ ଦୁବ୍‌ୟାନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌, ଅକ୍‌ନାଃଚି ରୁଡ଼ୁନ୍‌ହୁଲାଙ୍ଗ୍‌ରେ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଫାରୁଶୀକ ପିଲାତୁସ୍‌ତାଃତେ ସେନଃୟାନାକ ");
INSERT INTO unx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ଆଡଃ କାଜିକିୟାକ, “ହେ ଗମ୍‌କେ, ଆଲେ ନାହାଁଃ ଜାକେଦ୍‌ ପାହାମ୍‌କାଦାଲେ ଏନ୍‍ ବେଦାନିଃ ଜୀନିଦ୍‌ ତାଇକେନ୍‌ରେ ‘ଆଇଙ୍ଗ୍‌ ଆପିମା ତାୟମ୍‌ତେ ଜୀଉବିରିଦାଇଙ୍ଗ୍‌’ ମେନ୍ତେ କାଜିକାଦ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ଏନା ନାଗେନ୍ତେ ତପାଗାଡ଼ାକେ ଆପିମା ଜାକେଦ୍‌ ହର ନାଗେନ୍ତେ ଆଚୁକମ୍‌, କା'ରେଦ ଇନିୟାଃ ଚେଲାକ ନିଦାରେ ହିଜୁଃଆକ ଆଡଃ ଗଏଃହଡ଼୍‌ମକେ କୁମ୍ବୁଡ଼ୁ ଇଦିକେୟାକ ଏନ୍ତେ ଇନିଃ ଗଜାକାନ୍‍କଏତେ ଜୀଉବିରିଦାକାନାଏ ମେନ୍ତେ ହଡ଼କକେ କାଜିୟାକଆକ । ନେ ଟୁଣ୍ଡୁବେଦା ପାହିଲା ବେଦାଏତେ ପୁରାଃ ଏତ୍‌କାନ୍‌ ହବାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଜୁ ଦାରୱାନ୍‌କକେ ଇଦିକପେ ଆଡଃ ଏନ୍‌ ତପାଗାଡ଼ାକେ ବୁଗିଲେକା ହରୟେପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ଏନ୍ତେ ଇନ୍‌କୁ ଦାରୱାନ୍‌କଲଃ ସେନ୍‌କେଦ୍‌ତେ ତପାଗାଡ଼ା ବଲତାଃରେ ହାଣ୍ଡେଦାକାନ୍‌ ଦିରିକେ ମୋହର୍‌ ଏମ୍‌କେଦ୍‌ତେ ତପାଗାଡ଼ାକେ ହର ନାଗେନ୍ତେ ଦାରୱାନ୍‌କକେ କାଜିକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତାୟମ୍‌ତେ, ଏତଆର୍‌ ହୁଲାଙ୍ଗ୍‌ ସେତାଃ ଇଦାନ୍‌ରେ ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌ ଆଡଃ ଏଟାଃ ମାରିୟାମ୍‌ ତପାଗାଡ଼ା ଠାୟାଦ୍‌ତେ ନେନେଲ୍‌ତେକିନ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ଆଡଃ ଏନ୍ତାଃରେ ପୁରାଃଗି ଅତେ ଏକ୍‌ଲାଅୟାନା ଚିୟାଃଚି ପ୍ରାଭୁଆଃ ଦୁଁତ୍‌ ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁୟାନା ଏନ୍ତେ ତପାଗାଡ଼ା ସେନ୍‌କେଦ୍‌ତେ ଦୁଆର୍‍ତାଃରାଃ ପୁରାଃ ମାରାଙ୍ଗ୍‌ ଦିରିକେ ବାଟି ଆତମ୍‌କେଦ୍‌ତେ ଏନାରେ ଦୁବ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ଇନିଃଦ ହିଚିର୍‍ ଲେକା ନେଲଃ ତାଇକେନାଏ ଆଡଃ ଇନିୟାଃ ଲିଜାଃ ବାରାଫ୍‌ ଲେକା ପୁଣ୍ଡିଗି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ଦାରୱାନ୍‌କ ଇନିଃକେ ନେଲ୍‌କେଦ୍‌ତେ ବରତେ ଥାର୍‌ଥାରାଅୟାନାକ ଆଡଃ ଗଜାକାନ୍‍କ ଲେକା ହବାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ମେନ୍‌ଦ ଦୁଁତ୍‌ ଏନ୍‌ କୁଡ଼ିକକେ ମେତାଦ୍‌କଆଏ, “ଆଲ୍‌ପେ ବରଏୟା । ଆଇଙ୍ଗ୍‌ ସାରିତାନାଇଙ୍ଗ୍‌ ଆପେ କ୍ରୁଶ୍‌ରେ କିଲାୟାନ୍ ୟୀଶୁକେ ଦାଣାଁଁତାନାପେ । ");
INSERT INTO unx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ଇନିଃ ନେତାଃରେ ବାଙ୍ଗାଇୟା ଇନିଃଦ ଆୟାଃ କାଜିଲେକାତେ ଜୀଉବିରିଦାକାନାଏ । ନେତାଃ ହିଜୁଃକେଦ୍‌ତେ ନେଲେପେ, ନେତାଃରେ ଇନିୟାଃ ଗଏଃ ହଡ଼୍‌ମକେ ଦହକାଦ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ଆଡଃ ଆପେ ଜାଲ୍‍ଦି ସେନ୍‌କେଦ୍‌ତେ ଚେଲା ତାୟାଃକକେ କାଜିୟାକପେ, ‘ଇନିଃ ଗଜାକାନ୍‍କଏତେ ଜୀଉବିରିଦାକାନାଏ, ଆଡଃ ଆପେଏତେ ଆୟାର୍‌ରେ ଇନିଃ ଗାଲିଲ୍‌ତେ ସେନଃତାନା । ଏନ୍ତାଃରେ ଆପେ ଇନିଃକେପେ ନେଲିୟା ।’ ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିକାଦ୍‌ପେତେୟାଃ ପାହାମେପେ ।” ");
INSERT INTO unx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ବରତାନ୍‍ରେୟ ପୁରାଃ ରାସ୍‌କାତାନ୍‌ଲଃ ଇମ୍‌ତାଗି ତପାଗାଡ଼ା ବାଗିକେଦ୍‌ତେ ଆୟାଃ ଚେଲାକକେ ଉଦ୍‌ବାକ ନାଗେନ୍ତେ ନିର୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ୟୀଶୁ ଇନ୍‌କୁକେ ହିଜୁଃନାମ୍‌କେଦ୍‌ତେ କାଜିୟାଦ୍‍କଆଏ, “ଆପେୟାଃ ଜୀଉସୁକୁ ହବାଅଃକା” ଆଡଃ ଇନ୍‌କୁ ସେନ୍‌ ହେପାଦ୍‍କେଦ୍‍ତେ ଇନିୟାଃ କାଟା ସାବ୍‌କେଦ୍‌ତେ ଜହାର୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, “ଆଲ୍‌ପେ ବରଏୟା, ଆପେ ସେନ୍‌କେଦ୍‌ତେ ଆଇଁୟାଃ ହାଗାଇଙ୍ଗ୍‌କକେ କାଜିୟାକପେ, ଗାଲିଲ୍‌ତେ ସେନଃପେ ଆଡଃ ଏନ୍ତାଃରେ ଇନିଃକେପେ ନେଲିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ଏନ୍‌ କୁଡ଼ିକ ସେନଃତାଇକେନ୍ ଇମ୍‌ତା, ତପାଗାଡ଼ା ହରତାଇକେନ୍‌ ଦାରୱାନ୍‌ ସିପାଇକଏତେ ଚିମିନ୍‍କ ନାଗାର୍‌ତେ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କକେ ହବାଲେନ୍‌ତେୟାଃ ସବେନାଃ ଉଦୁବାଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ଆଡଃ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ପ୍ରାଚିନ୍‌କ ହୁଣ୍ଡିକେଦ୍‌ତେ ବାଖାଁଣ୍‌ ବାଇକେଦାକ ଏନ୍ତେ ଦାରୱାନ୍‌ ସିପାଇକକେ ପୁରାଃ ଟାକା ଏମ୍‌କେଦ୍‌ତେ, ");
INSERT INTO unx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","କାଜିକେଦ୍‌କଆକ, “ଆଲେ ଦୁଡ଼ୁମାକାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଇନିୟାଃ ଚେଲାକ ନିଦାରେ ହିଜୁଃକେଦ୍‌ତେ ଇନିଃକେ କୁମ୍ବୁଡ଼ୁ ଇଦିକିୟାକ ମେନ୍ତେ କାଜିୟାକପେ । ");
INSERT INTO unx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଆଡଃ ନେ କାଜି ରୋମିରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ଆୟୁମେରେଦ ଆଲେ ଇନିଃକେ ବୁଗିଲେକା କାଜିତାଇୟାଲେ ଯେ, ଆପେୟାଃ ଜେତାନ୍‌ ଗୁହ୍ନାଁ ବାନଆଃ । ନେ ବିଷାଏରେ ଆପେ ଜେତ୍‌ନାଃ ଆଲ୍‌ପେ ଉଡ଼ୁଃୟା ।” ");
INSERT INTO unx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ଦାରୱାନ୍‌ ସିପାଇକ ଟାକା ନାମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ଇତୁକାଦ୍‌କ ତାଇକେନ୍‌ ଲେକାକ କାଜିକେଦା ଆଡଃ ଏନ୍‍ କାଜି ଯିହୁଦୀକଆଃ ଥାଲାରେ ନିତିର୍‌ୟାନା ଆଡଃ ତିସିଙ୍ଗ୍‌ ଜାକେଦ୍‌ ମେନାଃ । ");
INSERT INTO unx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ଏଗାରାଝାନ୍‌ ଚେଲାକ ଗାଲିଲ୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ୟୀଶୁ କାଜିକାଦ୍‌କ ତାଇକେନ୍‌ ବୁରୁତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ଏନ୍ତାଃରେ ଇନ୍‌କୁ ୟୀଶୁକେ ନେଲ୍‍କେଦ୍‍ତେ ଜହାର୍‌କିୟାକ ମେନ୍‌ଦ ଚିମିନ୍‍କ ଆଡ଼ାଃଉଡ଼ୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‍କୁତାଃତେ ହିଜୁଃକେଦ୍‌ତେ କାଜିକେଦ୍‌କଆଏ, “ସିର୍ମା ଆଡଃ ଅତେରେୟାଃ ସବେନ୍‌ ଆକ୍‌ତେୟାର୍‌ ଆଇଁୟାଃ ତିଃଇରେ ଏମାକାନା, ");
INSERT INTO unx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ଏନାମେନ୍ତେ ସେନଃପେ ଆଡଃ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କକେ ଆଇଁୟାଃ ଚେଲା ବାଇକପେ ଆଡଃ ଇନ୍‌କୁକେ ଆପୁ, ହନ୍‌ ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ନୁତୁମ୍‌ତେ ବାପ୍ତିସ୍ମାକପେ । ");
INSERT INTO unx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆଚୁକାଦ୍‌ ସବେନାଃ ମାନାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଇତୁକପେ ଆଡଃ ସାରିଜମେପେ, ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ରେୟାଃ ଟୁଣ୍ଡୁ ଦିପିଲି ଜାକେଦ୍‌ ଆପେଲଃ ସବେନ୍‌ଇମ୍‌ତା ତାଇନାଇଙ୍ଗ୍‌ ।”");
INSERT INTO unx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ନେଆଁଁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ସୁକୁକାଜିରାଃ ଏନେଟେଦ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ଯିଶାୟ ନାବୀ ଅଲାକାଦ୍‌ ପୁଥି ଲେକାତେ, “ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିକେଦାଏ, ‘ଆଲେ ଆମାଃଏତେ ସିଦାରେ ଆଲେୟାଃ ଦୁଁତ୍‌କେଲେ କୁଲିତାନା ଇନିଃ ଆମାଃ ନାଗେନ୍ତେ ପାହିଲାରେ ହରା ବାଇୟାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ଜେତାଏ ମିହୁଡ଼୍‌ ବିର୍‌ରେ କାଉରିକେଦାଏ, ‘ପ୍ରାଭୁଆଃ ହରା ବାଇୟେପେ, ଆୟାଃ ଏଙ୍କବେଙ୍କ ହରା ସିଧାଏପେ ।’” ");
INSERT INTO unx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ଏନ୍ତେ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ବିର୍‌ରେ ସେଟେର୍‌ତାନ୍‌ଲଃ, ଇନିଃ ହଡ଼କକେ କାଜିୟାଦ୍‌କଆ, “ପାପ୍‌ଏତେ ମନ୍‌ରୁହାଡ଼େପେ ଆଡଃ ବାପ୍ତିସ୍ମାଅଃପେ, ଏନାରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେୟାଃ ପାପ୍‌କ ଛାମାପେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ଏନ୍ତେ ଯିହୁଦା ରାଇଜ୍‌, ଯୀରୁଶାଲେମ୍‌ ନାଗାର୍‌ଏତେ ଆଡଃ ଯାର୍ଦାନ୍‌ ନାହିଁରାଃ ସବେନ୍‌ ହପର୍‌ଜାପାଃରେନ୍‌ ହଡ଼କ ଯୋହାନ୍‌ତାଃ ଆୟୁମ୍‌ ନାଗେନ୍ତେ ହିଜୁଃୟାନାକ । ଏନ୍ତେ ହଡ଼କ ଆକଆଃ ପାପ୍‌କ ପାତିୟାର୍‌କେଦା ଏନ୍ତେ ଇନିଃ ଯାର୍ଦାନ୍‌ ନାହିଁରେ ଇନ୍‌କୁକେ ବାପ୍ତିସ୍ମାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ଯୋହାନ୍‌ ଉଁଟ୍‌ରାଃ ଉବ୍‌ତେ ବାଇୟାକାନ୍ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଅଃଁତାନ୍‌ ତାଇକେନାଏ, ଆୟାଃ ମାୟାଙ୍ଗ୍‌ରେ ଉହୁର୍‌ରାଃ କାସ୍‌ନା ତଲଃ ତାଇକେନାଏ ଆଡଃ ଇନିଃ ସନ୍‌ସରେଦ୍‌ ଆଡଃ ହୁରୁମ୍‌ସୁୁକୁ ଜମ୍‌କତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ଇନିଃ ପାର୍‌ଚାରେତାନ୍‌ଲଃ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ଏତେ ପୁରାଃଗି ପେଡ଼େୟାନ୍‌ନିଃ ଆଇଁୟାଃ ତାୟମ୍‌ତେ ହିଜୁଃତାନା, ଉଙ୍ଗୁଦ୍‌କେଦ୍‌ତେ ଇନିୟାଃ ଖାର୍‌ପାରେୟାଃ ତନଲ୍‌ ରାଡ଼ାଏ ଲେକାନ୍‌ନିଃ ନାହାଁଲିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ଆଇଙ୍ଗ୍‌ଦ ଆପେକେ ଦାଆଃତେ ବାପ୍ତିସ୍ମାପେ ତାନାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଇନିଃ ଆପେକେ ପାବିତାର୍‌ ଆତ୍ମାତେ ବାପ୍ତିସ୍ମା ଏମାପେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ଏନ୍‌ ଦିପିଲିରେ ୟୀଶୁ ଗାଲିଲ୍‌ ପାର୍‌ଗାନ୍‌ରେୟାଃ ନାଜ୍‌ରେତ୍‌ ନାଗାର୍‌ଏତେ ଯାର୍ଦାନ୍‌ ନାହିଁତେ ହିଜୁଃୟାନା, ଆଡଃ ଯୋହାନ୍‌ ୟୀଶୁକେ ବାପ୍ତିସ୍ମା ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ଆଡଃ ୟୀଶୁ ଦାଆଃ ଭିତାର୍‌ଏତେ ବାହାରି ଅଡଙ୍ଗ୍‌ୟାନ୍‌ ଇମ୍‌ତା ଇନିଃ ସିର୍ମା ନିଜାକାନ୍‌ ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମା ଦୁଦୁମୁଲ୍‌ ଲେକା ଆୟାଃ ଚେତାନ୍‌ରେ ଆଡ଼୍‌ଗୁତାନାଏ ନେଲ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ଆଡଃ ସିର୍ମାଏତେ ନେ'ଲେକା କାଜି ଆୟୁମ୍‌ୟାନା, “ଆମ୍‌ଗି ଆଇଁୟାଃ ଦୁଲାଡ଼୍‌ ହନ୍‌, ଅକଏକେଚି ଆଇଙ୍ଗ୍‌ ଦୁଲାଡ଼ାଃ; ଆମାଃତାଃରେ ଆଇଁୟାଃ ପୁରାଃଗି ସୁକୁ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ଇମ୍‌ତାଗି ପାବିତାର୍‌ ଆତ୍ମା ୟୀଶୁକେ ବିର୍‌ତେ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ୟୀଶୁ ଏନ୍ତାଃରେ ବାର୍‌ହିସି ନିଦାସିଙ୍ଗି ତାଇକେନାଏ, ଆଡଃ ସାଏତାନ୍‌ ଇନିଃକେ ବିଡ଼ାଅକିୟା । ଇନିଃ ବିର୍‌ ଜାଁତୁକଲଃ ତାଇକେନାଏ ଆଡଃ ଦୁଁତ୍‌କ ହିଜୁଃକେଦ୍‌ତେ ଇନିଃକେ ସୁସାର୍‌ ଏଟେଦ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ଯୋହାନ୍‌ ଜେହେଲ୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ, ୟୀଶୁ ଗାଲିଲ୍‌ ସାହାର୍‌ତେ ହିଜୁଃୟାନାଏ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ସୁକୁକାଜି ଉଦୁବ୍‌ବାଡ଼ାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“ନେଡା ପୁରାୟାନା, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆପେତାଃ ନାଡ଼େୟାକାନା ! ଆପେୟାଃ ପାପ୍‌ହେତେ ମନ୍‌ରୁହାଡ଼େପେ ଆଡଃ ସୁକୁକାଜିରେ ବିଶ୍ୱାସେପେ” ମେନ୍ତେ ଇନିଃ କାଜିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ୟୀଶୁ ଗାଲିଲ୍‌ ଦରେୟା ଗେନାଗେନାତେ ସେନଃତାନ୍‌ ଇମ୍‌ତା ଶିମୋନ୍‌ ଆଡଃ ଆୟାଃ ହାଗାତେ ଆନ୍ଦ୍ରିୟକେ ଦରେୟାରେ ଜାଲୋମ୍‌ ହୁଦ୍‌ମାକେଦ୍‌ତେ ହାକୁ ସାବ୍‌ତାନ୍‌ ନେଲ୍‌କେଦ୍‌କିନାଏ, ଚିୟାଃଚି ଇନ୍‌କିନ୍‌ଦ କେଉଁଟ୍‌କିନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ୟୀଶୁ କାଜିକେଦ୍‌କିନାଏ, “ଦେଲା ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ବେନ୍‌, ଆଇଙ୍ଗ୍‌ ଆବେନ୍‌କେ ହଡ଼କକେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃତେ ଆଉତେୟାଃ ଇତୁବେନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ଇନ୍‌କିନ୍‌ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଜାଲୋମ୍‌ ବାଗିକେଦ୍‌ତେ ୟୀଶୁକେ ଅତଙ୍ଗ୍‌କିୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ଆଡଃ ୟୀଶୁ ଏନ୍ତାଃଏତେ କାଟିଃସାଙ୍ଗିନ୍‌ ଆୟୁର୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ଜେବଦୀୟାଃ ହନ୍‌ ଯାକୁବ୍‌ ଆଡଃ ଆୟାଃ ହାଗାତେ ଯୋହାନ୍‌କେ ଲାଉକାରେ ଜାଲୋମ୍‌ ଚାପିତାନ୍‌ ନେଲ୍‌କେଦ୍‌କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ଆଡଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ କେଡ଼ାକେଦ୍‌କିନାଏ, ଆଡଃ ଇନ୍‌କିନ୍‌ ଆକିନାଃ ଆପୁ ଜେବଦୀକେ ନାଲାନାମ୍‌ ହଡ଼କଲଃ ଲାଉକାରେ ବାଗିକେଦ୍‌ତେ ୟୀଶୁକେ ଅତଙ୍ଗ୍‌କିୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ କପର୍‌ନାହୁମ୍‌ ସାହାର୍‌ତେ ସେନଃୟାନାଏ, ଆଡଃ ଇନିଃ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ବଲକେଦ୍‌ତେ ଧାରାମ୍‌ କାଜି ଉଦୁବ୍‌ ଏଟେଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ଆୟାଃ ଧାରାମ୍‌ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ, ଚିୟାଃଚି ଇନିଃ ଆଇନ୍‌ ଇତୁକ ଲେକାଦ କାହା, ମେନ୍‌ଦ ମିଆଁଦ୍‌ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ନିଃଲେକା ଇନ୍‌କୁକେ ଧାରାମ୍‌ କାଜି ଉଦୁବ୍‌କ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ଇମ୍‌ତାଗି ଇନ୍‌କୁଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ମିଆଁଦ୍‌ ସତ୍‌ରା ଆତ୍ମାତେ ଏସେରାକାନ୍ ହଡ଼ କାଉରିକେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ହେ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ, ଆଲେଲଃ ଆମାଃ ଚିକାନ୍‌ କାମି ? ଆମ୍‌ ଚିନାଃ ଆଲେକେ ଜିୟନ୍‌ ନାଗେନ୍ତେମ୍ ହିଜୁଆକାନା ? ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପାବିତାର୍‌ନିଃ ତାନ୍‌ମେ, ଏନା ଆଇଙ୍ଗ୍‌ ସାରିତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ୟୀଶୁ ଇନିଃକେ ମାରାଙ୍ଗ୍‌ମଚାକେଦ୍‌ତେ କାଜିକିୟାଏ, “ହାପାଅଃମେଁ, ଆଡଃ ଇନିଃତାଃଏତେ ଅଡଙ୍ଗ୍‌ଅଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ଏନ୍ତେ ଏନ୍‌ ସତ୍‌ରା ଆତ୍ମା ଇନିଃକେ ମୁର୍‌କୁଟାଅକିୟାଏ ଆଡଃ କାଉରିତାନ୍‌ଲଃ ଇନିଃତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ନେୟାଁ ନେଲ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ ନେ'ଲେକା ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ ଯେ, ଇନ୍‌କୁ ଆକ ଆକଗି କୁଲିୟଃତାନ୍‌କ ତାଇନ୍‌କେନା “ନେୟାଁ ଚିକ୍‌ନାଃ ? ନେଆଁଦ ନାୱା ଇତୁ ! ନିଃଦ ଆକ୍‌ତେୟାର୍‌ତେ ସତ୍‌ରା ଆତ୍ମାକକେ ଅଡଙ୍ଗ୍‌ଅଃ ନାଙ୍ଗ୍‌ ଆଚୁକତାନାଏ ଆଡଃ ଇନ୍‌କୁ ଇନିୟାଃ କାଜିକ ମାନାତିଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ଆଡଃ ୟୀଶୁଆଃ କାଜି ଇମ୍‌ତାଗି ଗାଲିଲ୍‌ ଦିଶୁମ୍‌ରାଃ କଚାକୁନି ସବେନ୍‌ସାଃରେ ନିତିର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ସାମାଜ୍‌ ଅଡ଼ାଃ ବାଗିକେଦ୍‌ତେ, ଯାକୁବ୍‌ ଆଡଃ ଯୋହାନ୍‌ଲଃ, ଆନ୍ଦ୍ରିୟ ଆଡଃ ଶିମୋନ୍‌ଆଃ ଅଡ଼ାଃତେ ସେନଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ଶିମୋନ୍‌ଆଃ ହାନାର୍‌ତେ ଉରିୟୁତେ ପାର୍‌କମ୍‌ରେ ବାଟିୟାକାନ୍‌ ତାଇକେନାଏ, ଆଡଃ ଇମ୍‌ତାଗି ଇନିୟାଃ କାଜି ୟୀଶୁକେ ଉଦୁବ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ଏନ୍ତେ ୟୀଶୁ ଇନିୟାଃ ଜାପାଃତେ ସେନ୍‌ୟାନ୍‌ଚିଃ ଇନିୟାଃ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ ବିରିଦ୍‌କିୟାଏ ଆଡଃ ଇନିଃ ଉରିୟୁଏତେ ବୁଗିୟାନା, ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ସୁସାର୍‌ ଏଟେଦ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ସିଙ୍ଗିହାସୁରଃ ତାନ୍‌ରେ ହଡ଼କ ପୁରାଃ ବଙ୍ଗା ଏସେର୍‌କାନ୍‌ ଆଡଃ ଦୁକୁହାସୁତାନ୍‌ ସବେନ୍‌ ହଡ଼କକେ ୟୀଶୁତାଃତେକ ଆଉକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ଆଡଃ ଏନ୍‌ ସାହାର୍‌ରେନ୍‌ ହଡ଼କ ଏନ୍‌ ଅଡ଼ାଃ ଦୁଆର୍‌ରେକ ହୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ଏନ୍‌ରେଦ ୟୀଶୁ ଚିମିନ୍‌ ରାକାମ୍‌ରେନ୍‌ ହାସୁ ଦୁକୁତାନ୍‌ ଚିମିନ୍‌ ଚିମିନ୍‌ ହଡ଼କକେ ବୁଗିକେଦ୍‌କଆଏ, ଆଡଃ ଚିମିନ୍‌ ଚିମିନ୍‌ ବଙ୍ଗାକକେ ହାର୍‌ଅଡଙ୍ଗ୍‌ କେଦ୍‌କଆଏ, ଆଡଃ ଇନିଃ ବଙ୍ଗାକକେ କାଏ କାଜି ଇଚିକେଦ୍‌କଆ, ଚିୟାଃଚି ଇନ୍‌କୁ ୟୀଶୁକେ ସାରିତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଆଙ୍ଗ୍‌ମାର୍ସାଲ୍‌ ଝୁଲ୍‌ପୁଲ୍‌ନୁବାଃ ତାଇନ୍‌ଲଃଗି ୟୀଶୁ ବିରିଦ୍‌କେଦ୍‌ତେ ସିଃସଏଃ ଠାୟାଦ୍‌ତେ ସେନଃୟାନାଏ ଆଡଃ ଏନ୍ତାଃରେ ବିନ୍ତିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ମେନ୍‌ଦ, ଶିମୋନ୍‌ ଆଡଃ ଗାତି ତାୟାଃକ ୟୀଶୁକେ ଦାଣାଁଁ ନାମ୍‌କେଦ୍‌ତେ, ");
INSERT INTO unx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ଆୟାଃତାଃକ ହିଜୁଃୟାନା ଆଡଃ କାଜିକିୟାଃକ, “ସବେନ୍‌କ ଆମ୍‌କେ ଦାଣାଁଁବାଡ଼ାତାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ମେନ୍‌ଦ ଇନିଃ କାଜିୟାଦ୍‌କଆଏ, “ଦଲା, ଜାପାଃକରାଃ ହାତୁତେବୁ ସେନଆଃ, ଜେ'ଲେକାଚି ଏନ୍ତାଃକରେହଁ ଆଇଙ୍ଗ୍‌ କାଜିକ ଉଦୁବେୟାଇଙ୍ଗ୍‌, ଚିୟାଃଚି ଏନା ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଇତୁକେଦ୍‌କଆ ଆଡଃ ବଙ୍ଗାକକେ ହାର୍‌ତାନ୍‌ଲଃ ଗଟା ଗାଲିଲ୍‌ ହନର୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ମୁସିଙ୍ଗ୍‌ ହୁଲାଙ୍ଗ୍‌ ମିଆଁଦ୍‌ ନାଗେଘାଅନିଃ ୟୀଶୁତାଃ ଦେଙ୍ଗାଆସି ମେନ୍ତେ ହିଜୁଃୟାନାଏ, ଆଡଃ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ବିନ୍ତିତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ଆମ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଆଇଙ୍ଗ୍‌କେ ବୁଗିନିୟାର୍‌ ଦାଡ଼ିୟାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ଏନ୍ତେ ୟୀଶୁ ଦାୟାତେ ପେରେଃୟାନାଏ ଆଡଃ ଆୟାଃ ତିଃଇ ଜିଲିଙ୍ଗ୍‌କେଦ୍‌ତେ ଜୁଟିଦ୍‌କିୟାଏ ଆଡଃ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନିଙ୍ଗ୍‌ ଆମ୍‌ ବୁଗିନିୟାରଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","କାଜିତର୍‌ସାଗି ଇନିୟାଃ ନାଗେଘାଅ ନିର୍‌ୟାନା ଆଡଃ ଇନିଃ ବୁଗିୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ଏନ୍ତେ ୟୀଶୁ ଇମ୍‌ତାଗି ଏନ୍ତାଃଏତେ କୁଲ୍‌କିୟାଏ, ଆଡଃ ମାରାଙ୍ଗ୍‌ମଚାତେ କାଜିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ଆୟୁମେମେ, ଜେତାଏକେ ନେ କାଜି ଆଲମ୍‌ ଉଦୁବ୍‌କଆଃ, ମେନ୍‌ଦ, ଜୁ, ଯାଜାକ୍‌ତାଃରେ ଉଦୁବେନ୍‌ମେ ଆଡଃ ଇନିଃ ନେଲ୍‌ମେକାଏ, ଏନ୍ତେ ଆମ୍‌ ବୁଗିଫାର୍‌ଚିୟଃତେୟାଃ ସବେନ୍‌ ହଡ଼କଆଃ ସାରିନାଗେନ୍ତେ, ମୁଶା ହୁକୁମାକାଦ୍‌ଲେକା ଦାଣେଁରାକାବେମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ମେନ୍‌ଦ ଏନ୍‌ ହଡ଼ ସେନଃୟାନ୍‌ଚି ନେ କାଜି ସବେନ୍‌ତାଃରେ ଉଦୁବ୍‌ ଏଟେଦ୍‌କେଦାଏ, ଇନିୟାଃ ନେ କାଜି ମେନ୍ତେ ୟୀଶୁ ଜେତାନ୍‌ ସାହାର୍‌ରେ ହଡ଼କଆଃ ଆୟୁର୍‌ରେ କାଏ ବଲ ଦାଡ଼ିକେନା, ଆଡଃ ସିଃସଏଃ ଠାୟାଦ୍‌ରେ ତାଇନ୍‌ବାଡ଼ାୟାନାଏ, ହଲେହଁ ହଡ଼କ ସବେନ୍‌ସାଃଏତେ ଇନିଃତାଃତେ ହିଜୁଃତାନ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ଚିମିନ୍‌ ମାହାଁ ତାୟମ୍‌ତେ, ୟୀଶୁ କପର୍‌ନାହୁମ୍‌ତେ ଆଇଃକ୍‌ ତାଇନଃ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ୟାନ୍‌ଚି, ଅଡ଼ାଃରିୟା ମେନ୍ତେ ଇନ୍‌କୁ ଆୟୁମ୍‌କେଦା, ");
INSERT INTO unx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ଏନ୍ତେଦ ହଡ଼କ ପୁରାଃଗି ହୁଣ୍ଡିୟାନ୍ତେ ଏନ୍ତାଃରେ ଦୁଆର୍‌ପିଣ୍ଡିଗିରେହ ଠାୟାଦ୍‌ କା ତାଇକେନା, ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁକେ ବାଚାନ୍‌ ଉଦୁବାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ଏନ୍‌ ଦିପିଲିରେ, ମିଆଁଦ୍‌ ବାତ୍‌କାନ୍‌ ହଡ଼କେ ଚାର୍‌ଝାନ୍‌ ହଡ଼କ ଇନିଃତାଃତେକ ଗଅଃ ଆଉକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ମେନ୍‌ଦ ଗାଦେଲ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ଇନ୍‌କୁ ୟୀଶୁଆଃ ନାଡ଼େଃତେ କାକ ସେନ୍‌ଦାଡ଼ିୟାନା । ଏନାମେନ୍ତେ ୟୀଶୁ ତିଙ୍ଗୁକାନ୍‌ତାଃରାଃ ଅଡ଼ାଃ ସାଡ଼୍‌ମି ଗେନାକେଦ୍‌ତେ, ଏନ୍‌ ବାତ୍‌କାନ୍‌ନିଃକେ, ବାଟିୟାକାନ୍‌ ପାର୍‌କମ୍‌ଲଃଗି ଆଡ଼୍‌ଗୁକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁଆଃ ବିଶ୍ୱାସ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ବାତ୍‌କାନ୍‌ନିଃକେ ମେତାଇୟାଏ, “ଏ ହନ୍‌ ଆମାଃ ପାପ୍‌କ ଛାମାୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ଏନ୍ତାଃରେ ଦୁବାକାନ୍‌ ଚିମିନ୍‌ ଆଇନ୍‌ ଇତୁକ ଏନା ନେଲ୍‌କେଦ୍‌ତେ ଆକ ଆକଆଃ ମନ୍‌ରେ ପାହାମ୍‌କେଦାଃକ, ");
INSERT INTO unx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ନିଃ ଚିଲ୍‌କାକେଦ୍‌ତେ ନେ ଲେକାଏ କାଜି ଦାଡ଼ିତାନ୍‌ ? ନିଃଦ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ନିନ୍ଦାଇତାନା, ମିହୁଡ଼୍‌କେ ବାଗିକେଦ୍‌ତେ, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ବେଗାର୍‌ ଅକଏ ପାପ୍‌ ଛାମା ଏମ୍‌ ଦାଡ଼ିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ଇନ୍‌କୁ ଏନ୍‌ଲେକା ଆକଆଃ ମନ୍‌ରେ ପାହାମ୍‌ତାନା ମେନ୍ତେ ୟୀଶୁ ଇମ୍‌ତାଗି ଆୟାଃ ଆତ୍ମାରେ ଆଟ୍‌କାର୍‌କେଦା, ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଆପେ ଆପେୟାଃ ମନ୍‌ରେ ଚିନାଃପେ ଉଡ଼ୁଃତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ଅକ୍‌ନାଃ ରାୱାଲାଃ, ନେ ବାତ୍‌କାନ୍‌ନିଃକେ “ପାପ୍‌ ତାମାଃକ ଛାମାୟାନା” କାଜିତେୟାଃ ରାୱାଲାଃ ଚି “ବିରିଦ୍‌ମେ, ପାର୍‌କମ୍‌ ତାମାଃ ଗଅଃକେଦ୍‌ତେ ସେନଃମେ” ମେନ୍ତେ କାଜିତେୟାଃ ରାୱାଲା ? ");
INSERT INTO unx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ମେନ୍‌ଦ ଆପେ ସାରିଦାଡ଼ି ନାଗେନ୍ତେ ଉଦୁବାପେତାନାଇଙ୍ଗ୍‌ ନେ ଅତେଦିଶୁମ୍‌ରେ ପାପ୍‌ ଛାମାରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ମାନୱାହନ୍‌ଆଃ ମେନାଃ, ଏନ୍‌ ବାତ୍‌କାନ୍‌ନିଃକେ କାଜିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ଆଇଙ୍ଗ୍‌ କାଜିମେତାନାଇଙ୍ଗ୍‌, “ମାର୍‌ ବିରିଦ୍‌ମେ ଆଡଃ ପାର୍‌କମ୍‌ତାମାଃ ଗଅଃକେଦ୍‌ତେ ଆମାଃ ଅଡ଼ାଃତେ ସେନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ଇମ୍‌ତାଗି ଇନିଃ ବିରିଦ୍‌ୟାନାଏ, ଆଡଃ ଆୟାଃ ପାର୍‌କମ୍‌ ଗଅଃକେଦ୍‌ତେ ସବେନ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ସେନଃୟାନାଏ, ଏନାତେ ସବେନ୍‌କ ଆକ୍‌ଦାନ୍ଦାଅଃତାନ୍‌ଲଃ ମେନ୍‌କେଦାଃକ “ନେ ଲେକା ଚିଉଲାହ କାବୁ ନେଲାକାଦ୍‌ ତାଇକେନା, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାରାଙ୍ଗ୍‌କିୟାକ ।” ");
INSERT INTO unx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ଆଡଃଗି ୟୀଶୁ ଗାଲିଲ୍‌ ଦରେୟା ଗେନାତେ ସେନଃୟାନାଏ, ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃତାଃକ ହିଜୁଃୟାନା ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ଇତୁ ଏଟେଦ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଆୟାର୍‌ତେ ସେନଃତାନ୍‌ ଦିପିଲିରେ ଆଲ୍‌ଫିୟାନ୍‌ରାଃ ହନ୍ତେକଡ଼ା ଲେବୀ ଆୟାଃ ମାଲ୍‌ହାରମ୍‌ ଠାୟାଦ୍‌ରେ ଦୁବାକାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ୟୀଶୁ କାଜିକିୟାଏ, “ଦେଲା ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ଏନ୍ତେ ଇନିଃ ବିରିଦ୍‌କେଦ୍‌ତେ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ତାୟମ୍‌ ଦିପିଲିରେ ୟୀଶୁ ଲେବୀଆଃ ଅଡ଼ାଃରେ ଜମ୍‌ନାଙ୍ଗ୍‌ ଦୁବାକାନ୍‌ ତାଇକେନାଏ, ଇମ୍‌ତାଙ୍ଗ୍‌ ୟୀଶୁକେ ଅତଙ୍ଗ୍‌ଇଁତାନ୍‌ ପୁରାଃ ମାଲ୍‌ହାରମ୍‌କ, ପାପିକ ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକଲଃ ଜଜମ୍‌କ ଦୁବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ଫାରୁଶୀକଏତେ ଚିମିନ୍‌ ଆଇନ୍‌ ଇତୁକ, ୟୀଶୁକେ ମାଲ୍‌ହାରମ୍‌ ଆଡଃ ପାପିକଲଃ ଜମ୍‌ତାନ୍ ନେଲ୍‌କେଦ୍‌ତେ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆକ “ଚିନାଃମେନ୍ତେ ଇନିଃ ନେ ଲେକାନ୍‌ ହଡ଼କଲଃ ଜମ୍‌ତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ୟୀଶୁ ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, “ବୁଗିନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ମେନ୍ତେଦ କା, ମେନ୍‌ଦ ହାସୁତାନ୍‌କ ନାଗେନ୍ତେ ବାଇଦ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଧାର୍‌ମାନ୍‌ ହଡ଼କକେ କେଡ଼ା ନାଗେନ୍ତେଦ କା ମେନ୍‌ଦ ପାପିକକେ କେଡ଼ା ମେନ୍ତେଇଙ୍ଗ୍‌ ହିଜୁଃକାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ଯୋହାନ୍‌ ଡୁବାକ୍‌ରାଃ ଚେଲାକ ଆଡଃ ଫାରୁଶୀକ କାଟାବ୍‌ ତାଇକେନ୍‌ ଦିପିଲିରେ ଚିମିନ୍‌ ହଡ଼ ୟୀଶୁତାଃ ହିଜୁଃକେଦ୍‌ତେ କୁଲିକିୟାକ, “ଚିନାଃମେନ୍ତେ ଯୋହାନ୍‌ ଡୁବାକ୍‌ରାଃ ଚେଲାକ ଆଡଃ ଫାରୁଶୀକଆଃ ଚେଲାକ କାଟାବାଃ ? ମେନ୍‌ଦ ଆମାଃ ଚେଲାକଦ କାକ କାଟାବାଃ ?” ");
INSERT INTO unx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଆଣ୍‌ଦିଅଡ଼ାଃରେ ଦୁହ୍ଲାକଡ଼ା ବାଲାକଲଃ ତାଇନଃରେ, ବାଲାକ ଚିଲ୍‌କାତେ ରେଙ୍ଗେଃ କାଟାବ୍‌ଗି ତାଇନାଃକ ? କାହାଗି, ଏନ୍‌କାଦ କା ହବାଅଆଃ ଆକଲଃ ଦୁହ୍ଲାକଡ଼ା ତାଇନଃ ଜାକେଦ୍‌ କାକ କାଟାବ୍‌ ଦାଡ଼ିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ମେନ୍‌ଦ ନେଡା ତେବାଗାଃ, ଆଡଃ ଦୁହ୍ଲାକଡ଼ାକେ ଇନ୍‌କୁଆଃ ଥାଲାଏତେ ଇଦିୟଃଆ, ଏନ୍‌ ଦିପିଲିରେ ଇନ୍‌କୁ ରେଙ୍ଗେଃ କାଟାବ୍‌ ରିକାଏୟାକ । ");
INSERT INTO unx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ଜେତାଏ ନାୱା ଲିଜାଃରାଃ କେଚାଃ ମାରି ଲିଜାଃରେ ଜଡ଼ାଇକେଦ୍‌ତେ କାଏ ତୁନାଏୟା, ଏନ୍‌କାଲେରେ ନାୱା ଲିଜାଃରାଃ କେଚାଃ ମାରି ଲିଜାଃଏତେ ଆଡଃଗି ଚେଚାଃ ଇଦିୟାଏ, ଆଡଃ ଏନ୍‌ ଚେଚାଃ ସିଦାଏତେ ଆଡଃଗି ମାରାଙ୍ଗ୍‌ ଇଦିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ଆଡଃ ନାୱା ଦାଖ୍‌ରାସିକେ ମାରି ଉହୁର୍‌ତୁମ୍ବାରେ ଜେତାଏ କାକ ଦୁଲ୍‌ପେରେଜେୟା, ଏନ୍‌କାଲେରେ ଦାଖ୍‌ରାସି ଉହୁର୍‌ତୁମ୍ବାକେ ଅଡ଼େଃତାଃଏ ଆଡଃ ଦାଖ୍‌ରାସି ଲିଙ୍ଗି ଏଣ୍ଡାଗଃଆ, ଏନାମେନ୍ତେ ନାୱା ଦାଖ୍‌ରାସିକେଦ ନାୱା ଉହୁର୍‌ତୁମ୍ବାରେ ପେରେଜାଃକ ।” ");
INSERT INTO unx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ମୁସିଙ୍ଗ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ୟୀଶୁ ହେରାକାନ୍‌ ପିଡ଼ି ଥାଲାଥାଲାତେ ଚେଲାକଲଃ ସେନଃତାନ୍‌ ତାଇକେନାଏ, ଆଡଃ ଇନିୟାଃ ଚେଲାକ ସେନ୍‌ତାନ୍‌ଲଃ ଗେଲେକ ହଦ୍‌ ଏଟେଦ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ଆଡଃ ଫାରୁଶୀକ ୟୀଶୁକେ କାଜିକିୟାଃକ, “ନେଲେମେ, ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଆମାଃ ଚେଲାକ ଆଇନ୍‌ ଲେକାତେ ଅକ୍‌ନାଃ କା ଠାଉକାନ୍‌ କାମି ତାନାଃ, ଏନା ଚିନାଃମେନ୍ତେକ ରିକାତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଦାଉଦ୍‌ଆଃ ଜମେୟାଃଁ କା ତାଇକେନା ଇମ୍‌ତା ଇନିଃ ଆଡଃ ଆୟାଃ ଗାତିକ ରେଙ୍ଗେଃୟାନ୍‌ ଇମ୍‌ତା, ଇନିଃ ଚିନାଃଏ ଚିକାକାଦ୍‌ ତାଇକେନା, ଏନା ଚିଉଲାହ ଚି କାପେ ପାଢ଼ାଅକାଦା ? ");
INSERT INTO unx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ଚିଲ୍‌କା ଇନିଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଅବିୟାଥର୍‌ରାଃ ସାମାଏରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଅଡ଼ାଃତେ ବଲୟାନା ଆଡଃ ଅକ୍‌ନାଃକେଚି ଆଇନ୍‌ ଲେକାତେ ଯାଜାକ୍‌କକେ ଏସ୍‌କାର୍‌ ଜମେବାଇୟଃ ହଲଙ୍ଗ୍‌କେ ଜମ୍‌କେଦାଏ ଆଡଃ ଆୟାଃ ଗାତିକକେୟ ଜମ୍‌ନାଙ୍ଗ୍‌ ଏମାଦ୍‌କଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ଆଡଃ ଟୁଣ୍ଡୁରେ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌କେ ମାନୱାରାଃ ବୁଗିନାଃ ନାଗେନ୍ତେ ବାଇୟାକାନା, ମେନ୍‌ଦ ମାନୱାକେ ହାମ୍ବାଲ୍‌ତେ ତେନ୍‌ ନାଗେନ୍ତେ କାହାଗି । ");
INSERT INTO unx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ନେ ଲେକାଗି ମାନୱାହନ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେନ୍‌ ହଁ ଗମ୍‌କେ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ଏନ୍ତେ ୟୀଶୁ ସାମାଜ୍‌ ଅଡ଼ାଃତେ ବଲୟାନା, ଏନ୍ତାଃରେ ତିଃଇ ରହଡ଼ାକାନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ଆଡଃ ୟୀଶୁ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଏନ୍‌ ହଡ଼କେ ବୁଗିୟାଏ ଚି କା ମେନ୍ତେ ଚିଟାଇ ନାଗେନ୍ତେ ଚିମିନାଙ୍ଗ୍‌ ହଡ଼କ ହରାକ ଦାଣାଁଁତାନ୍‌ ଆଡଃ ଲଡଇତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ୟୀଶୁ ତିଃଇ ରହଡ଼ାକାନ୍ ହଡ଼କେ କାଜିକିୟାଏ, “ଏଲା, ସବେନ୍‌କଆଃ ଥାଲାରେ ତିଙ୍ଗୁନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆବୁଆଃ ଆଇନ୍‌ଲେକାତେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଅକନ୍‌ କାମି ରିକା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ? ମିହୁଡ଼୍‌ଆଃ ବୁଗିନ୍‌ ରିକାତେୟାଃ ଚି ଏତ୍‌କାନ୍‌ ରିକାତେୟାଃ ? ମିହୁଡ଼୍‌ଆଃ ଜୀଉ ବାଞ୍ଚାଅତେୟାଃ ଚି ଜୀଉ ଗଗଏଃତେୟାଃ ?” ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନିଃକେ ଜେତ୍‌ନାଃ କାକ କାଜିରୁହାଡ଼୍‌ ଦାଡ଼ିକେନା । ");
INSERT INTO unx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ଏନ୍ତେ ଇନ୍‌କୁଆଃ କେଟେଦ୍‌ ମନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ୟୀଶୁଆଃ ମନ୍‌ ଦୁକୁୟାନା, ଆଡଃ ଖିସ୍‌ତେ ଇନ୍‌କୁକେ ନେଲ୍‌ବିୟୁର୍ କେଦ୍‌କଚି ଏନ୍‌ ହଡ଼କେ ମେତାଇୟାଏ, “ତିଃଇତାମାଃ ଜିଲିଙ୍ଗ୍‌ୟେଁମେ,” ଇନିଃ ତିଃଇ ଜିଲିଙ୍ଗ୍‌କେଦାଏ, ଆଡଃ ତିଃଇତାୟାଃ ପୁରାଗି ବୁଗିରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ଆଡଃ ଫାରୁଶୀକ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ୟୀଶୁକେ ଚିଲ୍‌କାତେବୁ ଗଜିୟା ମେନ୍ତେ ଇମ୍‌ତାଗି ହେରୋଦ୍‌ ରାଜାରାଃ ହଡ଼କଲଃ ରଜୋଟ କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ଗେନାକେଦ୍‌ତେ ଗାଲିଲ୍‌ ଦରେୟାସାଃତେ ସେନଃୟାନାଏ, ଆଡଃ ଗାଲିଲ୍‌ ଆଡଃ ଯିହୁଦାଏତେ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେକ ଅତଙ୍ଗ୍‌କିୟା, ");
INSERT INTO unx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଯୀରୁଶାଲେମ୍‌, ଇଦୁମ୍‌, ଯାର୍ଦାନ୍‌ ଗାଡ଼ା ହାନ୍‌ପାରମ୍‌, ସୋର୍‌ ଆଡଃ ସିଦୋନ୍‌ରାଃ ହପର୍‌ଜାପାଃ ନାଗାର୍‌କଏତେ ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିୟାଃ ସବେନ୍‌ ମାପ୍‌ରାଙ୍ଗ୍‌ କାମି ରିକାରେୟାଃକାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ଏନ୍ତାଃରେ ହଡ଼କ ହୁଣ୍ଡିୟାନ୍‌ଚି ଇନ୍‌କୁଆଃ ଉପୁଦୁର୍‌ଠେପ୍‌ସାଅ ଏତେ ବାଞ୍ଚାଅ ନାମେ ନାଗେନ୍ତେ ୟୀଶୁ ଆୟାଃ ନାଙ୍ଗ୍‌ ମିଆଁଦ୍‌ ଲାଉକା ଜଗାଡ଼୍‌ନାଙ୍ଗ୍‌ ଚେଲାକକେ କାଜିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ଚିୟାଃଚି, ୟୀଶୁ ପୁରାଃ ହଡ଼କକେ ବୁଗିକାଦ୍‌କ ତାଇକେନା, ଏନାମେନ୍ତେ ଦୁକୁହାସୁତାନ୍‌ ସବେନ୍‌କ, ଇନିଃକେ ଜୁଟିଦି ନାଗେନ୍ତେ ଇନିଃତାଃ ଜୁରୁହୁଣ୍ଡିନ୍‌ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ଆଡଃ ସତ୍‌ରା ଆତ୍ମାତେ ଏସେରାକାନ୍‌ ହଡ଼କ ଇନିଃକେ ନେଲ୍‌ତାଇଲଃଗି ଇନିୟାଃ କାଟାସୁବାରେ ଉୟୁଗେନ୍‌ତାନ୍‌କ ତାଇକେନା, ଆଡଃ “ଆମ୍‌ଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେ” ମେନ୍ତେକ କାଉରିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ଏନ୍ତେଦ ଆଇଁୟାଃ ବିଷାଏରେ ଏଟାଃକକେ ଆଲ୍‌ପେ କାଜିକଆ ମେନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ ମାରାଙ୍ଗ୍‌ମଚା କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ଏନ୍ତେ ୟୀଶୁ ବୁରୁତେ ରାକାବ୍‌ୟାନାଏ, ଆଡଃ ଆୟାଃ ସାନାଙ୍ଗ୍‌ଆଁକାଦ୍‌କକେ ଆୟାଃତାଃତେ କେଡ଼ାକେଦ୍‌କଆଏ, ଆଡଃ ଇନ୍‌କୁ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ଆଡଃ ଇନିଃ ଗେଲ୍‌ବାର୍‌ ପ୍ରେରିତ୍‌କକେ ସାଲାକେଦ୍‌ତେ, ଇନ୍‌କୁକେ ପ୍ରେରିତ୍‌ ମେନ୍ତେ ନୁତୁମ୍‌କେଦ୍‌କଆଏ । ଇନିଃ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ଲଃ ତାଇନଃ ନାଗେନ୍ତେ ଆପେକେ ସାଲାକାଦ୍‌ପେଆଇଙ୍ଗ୍‌, ଆଡଃ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେଇଙ୍ଗ୍‌ କୁଲ୍‌ପେୟା । ");
INSERT INTO unx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ଆଡଃ ବଙ୍ଗାକ ହାର୍‌ଅଡଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଆପେକେ ପେଡ଼େଃ ଏମାପେୟାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ୟୀଶୁ ନେ ଗେଲ୍‌ବାର୍‌ କୁଲାକାନ୍‌କକେ ସାଲାକେଦ୍‌କଆଏ, ଶିମୋନ୍‌, ଅକଏକେଚି ଇନିଃ ପାତ୍‌ରାସ୍‌ ନୁତୁମ୍‌କିଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବଦୀଆଃ ବାରିୟା ହନ୍‌କଡ଼ାକିନ୍‌ ଯାକୁବ୍‌ ଆଡଃ ଯୋହାନ୍‌, ନେ ବାରାନ୍‌ ହାଗିୟାକିନ୍‌କେ ୟୀଶୁ, ବାନାର୍‌ଗେସ୍‌ ମେନ୍‌ଲେରେ “ରିମିଲ୍‌ସାଡ଼ିରେନ୍‌ ହନ୍‌କିନ୍‌” ମେନ୍ତେ ନୁତୁମ୍‌କେଦ୍‌କିନା; ");
INSERT INTO unx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍ରିୟ, ଫିଲିପ୍‌, ବାର୍ଥୋଲମି, ମାଥିଉ, ଥୋମା, ଆଲ୍‌ଫିୟନାଃ ବାରିଆ ହନ୍‌କଡ଼ାକିନ୍‌ ଯାକୁବ୍‌ ଆଡଃ ଥଦ୍ଦିୟ, କିନାନ୍‌ରେନ୍‌ ଶିମୋନ୍‌, ଅକଏଚି ଇସ୍ରାଏଲ୍‌କକେ ମୁକ୍ତି ଏମ୍‌ ସାନାଙ୍ଗ୍‌ତାନ୍‌ ଯିହୁଦୀକ ଏତେ ମିହୁଡ଼୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ଆଡଃ ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା ଅକଏଚି, ତାୟମ୍‌ତେ ୟୀଶୁକେ ବାଇରିକଆଃ ତିଃଇରେ ଆଖ୍‌ରିଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ଏନ୍ତେ ୟୀଶୁ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ୟାନାଏ, ଆଡଃ ଏନ୍ତାଃରେ ପୁରାଃ ହଡ଼କ ହୁଣ୍ଡିୟାନା, ଏନାତେ ଇନିଃ ଆଡଃ ଆୟାଃ ଚେଲାକ ଜମ୍‌ହ କାକ ଦାଡ଼ିକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌ ହଡ଼କ ଆଇଃକ୍‌କେ ସାବ୍‌ଇଦି ନାଗେନ୍ତେ ଅଡଙ୍ଗ୍‌ୟାନାକ, ଚିୟାଃଚି ହଡ଼କ କାଜିତାଇନାକ, “ନିଃ ବାଲୁଅଃତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଆଡଃ, ଯୀରୁଶାଲେମ୍‌ଏତେ ହିଜୁଆକାନ୍‌ ଆଇନ୍‌ ଇତୁକ ମେନ୍‌କେଦାଃକ “ବଙ୍ଗାକଆଃ ଗମ୍‌କେ ବାଲ୍‌ଜେବୁଲ୍‌ ଇନିଃକେ ଏସେର୍‌କିୟାଏ । ଇନିଃଗି ଇନିଃକେ ବଙ୍ଗା ହାର୍‌ଅଡଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ପେଡ଼େଃ ଏମାଇତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ଏନାମେନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ ହାକାଅକେଦ୍‌କଆଏ, ଆଡଃ ଜନ୍‌କା କାଜିତେ ମେତାଦ୍‌କଆଏ, “ସାଏତାନ୍‌ଗିଃ ସାଏତାନ୍‌କେ ଚିଲ୍‌କା ହାର୍‌ଅଡଙ୍ଗ୍‌ ଦାଡ଼ିୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ମିଆଁଦ୍‌ ରାଇଜ୍‌ ଆୟାଃରେଗି ବିନ୍‌ଗାଅକେଦ୍‌ତେ ଆକ ଆକଥାଲାରେ ଲାପ୍‌ଡ଼ାଇରେଦ ଏନ୍‌ ରାଇଜ୍‌ ଛିତିବିତିକଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ଆଡଃ, ମିଆଁଦ୍‌ ଅଡ଼ାଃରେନ୍‌କ ଆକ ଆକଗି ଲାପ୍‌ଡ଼ାଇରେଦ ଏନ୍‌ ଅଡ଼ାଃ କା ତିଙ୍ଗୁନାଃ । ");
INSERT INTO unx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ଏନ୍‌ଲେକାଗି ସାଏତାନ୍‌, ସାଏତାନ୍‌ଆଃ ରାଇଜ୍‌ ହିଗାଡ଼୍‌କେଦ୍‌ତେ ବିନ୍‌ଗାଅରେଦ ଏନା କା ତିଙ୍ଗୁନାଃ, ମେନ୍‌ଦ ଛିତିବିତିକେଦ୍‌ତେ ଟୁଣ୍ଡୁଉତାରଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ପେଡ଼େୟାନ୍‌ନିଃକେ ଆଉରି ତଲ୍‌ ଜାକେଦ୍‌ ଜେତାଏ ଇନିୟାଃ ଅଡ଼ାଃରେ ବଲକେଦ୍‌ତେ ଆୟାଃ ମେନାଃତେୟାଃ କାଏ ରେଃକ୍‌ଦାଡ଼ିୟା, ମେନ୍‌ଦ ସିଦାତେ ଇନିଃକେ ତଲ୍‌କେଦ୍‌ତେ ଆୟାଃ ମେନାଃତେୟାଃ ରେଃକ୍‌ଦାଡ଼ିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ସାର୍‌ତିଗି କାଜିପେତାନାଇଙ୍ଗ୍‌, ମାନୱାହନ୍‌କଆଃ ସବେନ୍‌ ପାପ୍‌ ଆଡଃ ଇନ୍‌କୁଆଃ ନିନ୍ଦା କାଜିକ ଛାମାୱାଃ; ");
INSERT INTO unx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ମେନ୍‌ଦ ପାବିତାର୍‌ ଆତ୍ମାକେ ହିଲାଙ୍ଗ୍‌ଇ ହଡ଼କେ ଚିଉଲାହ କା ଛାମାୱାଃ, ଚିୟାଃଚି ଇନିଃ ଜାନାଅ ଜାନାଅରାଃ ପାପ୍‌ କେଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“ସତ୍‌ରା ଆତ୍ମା ଇନିଃକେ ଏସେରାକାଇୟାଏ” ମେନ୍ତେ ଆଇନ୍‌ ଇତୁକ କାଜିକେଦ୍‌ଚି ନେ ସବେନାଃ ୟୀଶୁ କାଜିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ଏନ୍ତେ ୟୀଶୁଆଃ ଏଙ୍ଗାତେ ଆଡଃ ହାଗାକ ହିଜୁଃୟାନା ଆଡଃ ରାଚାରେ ତିଙ୍ଗୁକେଦ୍‌ତେ, ଇନିଃକେ କେଡ଼ାଆଉୱି ନାଗେନ୍ତେ ମିହୁଡ଼୍‌କେକ କୁଲ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃତାଃରେ ଦୁବ୍‌ ଜୁରୁଆକାନ୍‌କ ତାଇକେନା, ଆଡଃ ଇନ୍‌କୁ କାଜିକିୟାଃକ, “ନେଲେମେ, ଆମାଃ ଏଙ୍ଗାମ୍‌ ଆଡଃ ହାଗା ମିଶିକ ରାଚାରେକଆ, ଇନ୍‌କୁ କେଡ଼ାମେତାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, “ଅକଏ ଆଇଁୟାଃ ଏଙ୍ଗାଇଙ୍ଗ୍‌ ? ଆଡଃ ଅକନ୍‌କ ଆଇଁୟାଃ ହାଗାଇଙ୍ଗ୍‌କ ତାନ୍‌କ ?” ");
INSERT INTO unx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ଆଡଃ ଦୁବାକାନ୍‌କକେ, ଆରିଦ୍‌ବିୟୁର୍‌କେଦ୍‌ତେ କାଜିକେଦାଏ, “ନେଲ୍‌କପେ ନିକୁଦ ଆଇଁୟାଃ ଏଙ୍ଗା ଆଡଃ ହାଗାକତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଅକଏ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାନାଙ୍ଗ୍‌ ପୁରାଃଏ, ଇନିଃ ଆଇଁୟାଃ ଏଙ୍ଗାଇଙ୍ଗ୍‌, ହାଗାଇଙ୍ଗ୍‌ ଆଡଃ ମିଶିଙ୍ଗ୍‌ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ୟୀଶୁ ଆଡଃଗି ଗାଲିଲ୍‌ ଦରେୟା ଗେନାରେ ଇନିତୁ ଏଟେଦ୍‌କେଦାଏ, ଆଡଃ ଏନ୍ତାଃରେ ଗାଦେଲ୍‌ ହଡ଼କ ହୁଣ୍ଡିୟାନ୍‌ଚି ଦରେୟାରେ ତାଇକାନ୍‌ ମିଆଁଦ୍‌ ଲାଉକାରେ ଦୁବ୍‌ୟାନାଏ ଆଡଃ ସବେନ୍‌ ହଡ଼କ ଦରେୟା ଗେନାରେ ଅତେରେକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ୟୀଶୁ ଇନ୍‌କୁକେ ଜନ୍‌କା କାଜିତେ ପୁରାଃ କାଜିକ ଇତୁକେଦ୍‌କଆଏ, ଆଡଃ ଇତୁକତାନ୍‌ଲଃ କାଜିକେଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ଆୟୁମେପେ, ମିଆଁଦ୍‌ ହିତାହେର୍‌ନିଃ ହିତା ହେର୍‌ନାଗେନ୍ତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ଆଡଃ ଇନିଃ ହିତା ହେର୍‌ତାନ୍‌ଲଃ ଚିମିନ୍‌ ହିତା ହରା ଗେନାରେ ଉୟୁଃୟାନା ଆଡଃ ଚେଣେଁକ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ ଏନାକ ହାଲାଙ୍ଗ୍‌ ଜମ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ଚିମିନ୍‌ ହିତାଦ ହାସା ପୁରାଃ ବାନଃ ଦିରି ଅତେରେ ଉୟୁଃୟାନା, ହାସା ଏତାଙ୍ଗ୍‌ଗି ତାଇକାନ୍‌ ହରାତେ ଅମନ୍‌ ଧାବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ମେନ୍‌ଦ ସିଙ୍ଗି ରାକାବ୍‌ୟାନ୍‌ଚି ଏନ୍‌ ଅମନ୍‌ତେୟାଃକ ସବେନ୍‌ ଗସୟାନା, ଆଡଃ କା ରେହେଦାକାନ୍‌ ହରାତେ ରହଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ଚିମିନ୍‌ ହିତା ଜାନୁମ୍‌ ଚୁପାଦ୍‌କ ଥାଲାରେ ଉୟୁଃୟାନା, ଏନାକକେ ଜାନୁମ୍‌ ହାରାତପାକେଦାଏ, ଆଡଃ ଏନାକ କା ଜ ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ମେନ୍‌ଦ ଚିମିନ୍‌ ହିତା ବୁଗିନ୍‌ ଅତେରେ ଉୟୁଃୟାନା, ଆଡଃ ଏନା ଅମନ୍‌ ହାରାୟାନ୍ତେ ଜ ୟାନା, ଅକଆଃକ ତିରିଶ୍‌, ଅକଆଃ ଷାଠେ, ଅକଆଃ ମିଦ୍‌ଶାଅଗୁନା, ଜ ୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଆଡଃ ୟୀଶୁ ମେନ୍‌କେଦାଏ, “ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଲୁତୁର୍ ମେନାଃନିଃ ଆୟୁମେକାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ୟୀଶୁ ଏସ୍‌କାର୍‌ଗି ତାଇକାନ୍‌ ଦିପିଲିରେ, ଆୟାଃଲଃ ତାଇକେନ୍‌ ହଡ଼କ, ଗେଲ୍‌ବାର୍‌ ଚେଲାକଲଃ, ନେ ଜନ୍‌କା କାଜିରେୟାଃ ମୁଣ୍ଡି ଚିକ୍‌ନାଃ ତାନାଃ ମେନ୍ତେକ କୁଲିକିୟାଃ ? ");
INSERT INTO unx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ଇନିଃ କାଜିୟାଦ୍‌କଆଏ, “ଆପେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେୟାଃ ଉକୁଆକାନ୍‌ କାଜିରାଃ ମୁଣ୍ଡିପେ ନାମ୍‌କାଦାଃ । ମେନ୍‌ଦ ବାହାରିରେନ୍‌ ଏଟାଃକକେ କାଜିରାଃ ଜନ୍‌କା କାଜିତେ ସବେନାଃ ଉଦୁବଃତାନା । ");
INSERT INTO unx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ଏନ୍‌ଲେକାତେ, “‘ଇନ୍‌କୁ ନେଲ୍‌ଦକ ନେଲେଆ, ମେନ୍‌ଦ କାକ ନେଲ୍‌ଉରୁମେୟାଁ, ଇନ୍‌କୁ ଆୟୁମ୍‌ଦକ ଆୟୁମେୟା, ମେନ୍‌ଦ କାକ ଆଟ୍‌କାରେୟା, କା'ରେଦ ଇନ୍‌କୁ ମନ୍‌କ ରୁହାଡ଼େତେୟାଃ, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କୁକେ ଛାମା ଏମାଦ୍‌କତେୟାଏ ।’” ");
INSERT INTO unx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଏନ୍ତେ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ନେ କାଜିରାଃ ଜନ୍‌କା କା'ଚିପେ ମୁଣ୍ଡିକେଦା ? ତାବ୍‌ଦ, ଆଡଃ ଜନ୍‌କାକ ଚିଲ୍‌କାପେ ମୁଣ୍ଡିଆ ? ");
INSERT INTO unx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ହିତାହେର୍‌ନିଃଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି ହେର୍‌ନିଃ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ଚିମିନ୍‌ ହଡ଼କ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ କାଜି ଆୟୁମ୍‌ ତାନ୍‌ଲଃଗି ସାଏତାନ୍‌ ହିଜୁଃକେଦ୍‌ତେ ଇନ୍‌କୁତାଃଏତେ ଆୟୁମ୍‌ କାଜିକେ ରେଃକ୍‌ଇଦିତାଃଏ, ଇନ୍‌କୁଦ ହରା ଗେନାରେ ହେରାକାନ୍‌ ହିତା ଲେକାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ଏନ୍‌ଲେକା, ଚିମିନ୍‌ ହଡ଼କଦ ହିତା ହେରାକାନ୍‌ ଦିରିଅତେ ଲେକାନ୍‌କ ତାନ୍‌କ, ଇନ୍‌କୁଦ କାଜି ଆୟୁମ୍‌ଲଃଗି ରାସ୍‌କାତେ ତେଲାଏତାନ୍‌ ହଡ଼କ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ମେନ୍‌ଦ ଇନ୍‌କୁତାଃରେ ‘ରେହେଦ୍‌’ କା ତାଇନ୍ ହରାତେ ଇନ୍‌କୁ କାଟିଃ ଘାଡ଼ିଗିକ ତାଇନାଃ, ତାୟମ୍‌ତେ କାଜିରାଃ ହରାତେ ଦୁକୁହାସୁ ଚାହେ ସାସାତି ହିଜୁଃରେ ଇମ୍‌ତାଗିକ ରୁହାଡ଼୍‌କଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ଜେତାଏ କାଜି ଆୟୁମାଃଏ ମେନ୍‌ଦ ସାଂସାର୍‌ରେୟାଃ ଉଡ଼ୁଃ ଆଡଃ ପୁରାଃ ମେନାଃତେୟାଃରାଃ ହାୟା, କାନାଜିକେ ହାରାତପାଏୟା ଆଡଃ ଇନିଃ କାଏ ଜଅଃ'ଆ, ଇନିଃ ଜାନୁମ୍‌ ଥାଲାରେ ଉୟୁଗାକାନ୍‌ ହିତା ଲେକାନ୍‌ନିଃ ତାନିଃ, ଇନିଃ ଜେତାନ୍‌ ଜ କାଏ ଜଅଃ'ଆ । ");
INSERT INTO unx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ନେ ଲେକାନ୍‌ ହଡ଼କଦ ଜାନୁମ୍‌ ଥାଲାରେ ହେରାକାନ୍‌ ହିତାଲେକାନ୍‌କତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ଆଡଃ ବୁଗିନ୍‌ ଅତେରେ ହେରାକାନ୍‌ ହିତାଲେକା ଚିମିନ୍‌ ହଡ଼କ ସୁକୁକାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ମାନାତିଙ୍ଗ୍‌ୟାଁଃକ, ଆଡଃ ମିଆଁଦ୍‌ନିଃ ତିରିଶ୍‌, ଏଟାଃନିଃ ଷାଠେ, ଆଡଃ ମିଆଁଦ୍‌ନିଃ ମିଦ୍‌ଶାଅ ଗୁନାକ, ଜ ଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଆଡଃଗି ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, “ଚିୟାଃ ଜେତାଏ ହଡ଼ ଦିମି ଜୁଲ୍‌କେଦ୍‌ତେ ‘ତାୱାତେ’ ଚାଏ ପାର୍‌କମ୍‌ ଲାତାର୍‌ରେ ଦହୟାଏ ? ଏନାକେଦ ପାଖା ଚାଏ ଦିର୍କା ଚେତାନ୍‌ରେ ଦହୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ଅକ ସବେନ୍‌ ଉକୁଆକାନ୍‌ତେୟାଃ ଏନା ମାସ୍କାଲ୍‌ତେ ଆଉଃଆ, ଆଡଃ ଅକ ସବେନାଃ ଦାନାଙ୍ଗ୍‌ଆଁକାନା ଏନା ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଲୁତୁର୍‌ ତାପେଆଃ ଆୟୁମ୍‌ ନାଗେନ୍ତେ ମେନାଃରେଦ, ଆୟୁମେପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଆଡଃଗି ଇନିଃ କାଜିୟାଦ୍‌କଆଏ, “ଆପେ ଆୟୁମେତେୟାଃ ବୁଗିଲେକା ଆୟୁମ୍ଉରୁମେପେ, ଆପେ ସଙ୍ଗେ ତାମ୍ବିରେଗି ଆପେ ନାଗେନ୍ତେ ସୋଙ୍ଗଃଆ, ଆଡଃ ଏନାଏତେ ଆଦ୍‌କାପେ ନାମେଆଁ । ");
INSERT INTO unx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ଚିୟାଃଚି, ଅକଏତାଃ ମେନାଃ ଇନିଃଦ ଆଡଃଗି ନାମେଆଁ, ଆଡଃ ଜେତାଏତାଃରେ ବାନଃଆ, ଇନିଃତାଃଏତେ ଅକ୍‌ନାଃ ମେନାଃ ଏନାହଗି ଇଦିୟଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଆଡଃଗି ୟୀଶୁ କୁଲିକେଦ୍‌କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ନେ'ଲେକାଗିଆଃ, ମିଆଁଦ୍‌ ହଡ଼ ଆୟାଃ ଅତେରେ ହିତା ହେର୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ଆଡଃ ଇନିଃ ନିଦାରେ ଦୁଡ଼ୁମାଏ, ସିଙ୍ଗିରେ ବିରିଦାଏ, ଆଡଃ ଇନିୟାଃ କା ସାରିତେ ହିତା ଅମନଆଃ ଆଡଃ ହାରାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ଅତେଦ ଆୟାଃତେଗି ଜ'ଏମାଃଏ, ସିଦା ଅମନେୟାଏ, ଏନ୍ତେ ଗେଲେୟାଏ, ଏନ୍ତେ ଗେଲେରେ ଜାଙ୍ଗ୍‌ଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ଜ ଜାଙ୍ଗ୍‌ୟାନ୍‌ଚି ଏନ୍‌ ହଡ଼, ଇରୋଃ ଦିପିଲି ସେଟେର୍‌ୟାନା ମେନ୍ତେ, ଦାତ୍‌ରମ୍‌ ସାବେଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“ଆଡଃଗି ୟୀଶୁ କୁଲିକେଦ୍‌କଆଏ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଚିନାଃଲଃବୁ ଜକାଏୟା ଚାଏ ଅକ ଜନ୍‌କା କାଜିତେ ଏନାବୁ ଉଦୁବେୟା । ");
INSERT INTO unx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ଏନାଦ ମିଆଁଦ୍‌ ମାନିଜାଙ୍ଗ୍‌ ଲେକା, ଅତେରେ ହେର୍‌ତାନ୍‌ ସାମାଏରେ ଅତେରାଃ ସବେନ୍‌ ହିତାଜାଙ୍ଗ୍‌ ଏତେ ହୁଡିଙ୍ଗ୍‌ଆଁ, ");
INSERT INTO unx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ମେନ୍‌ଦ ଅତେରେ ହେର୍‌ୟାନ୍‌ଚି ଏନାରେୟାଃ କତକ ଏଟାଃ ଆଡ଼ାଃଦାରୁକଏତେ ପୁରାଃ ମାରାଙ୍ଗ୍‌ ହାରାସାଲାଙ୍ଗିଅଃଆ, ଆଡଃ ସିର୍ମାରେନ୍‌ ଚେଣେଁକ ଏନାରେୟାଃ ଉମ୍ବୁଲ୍‌ରେକ ଥକାୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ୟୀଶୁ ଇନ୍‌କୁକେ ଆଟ୍‌କାର୍‌ଉରୁମ୍‌ ଦାଡ଼ିଲେକା ପୁରାଃ ନେ'ଲେକାନ୍‌ ଜନ୍‌କା କାଜିକ କାଜିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ବେଗାର୍ ଜନ୍‌କା କାଜିତେ ଇନିଃ ଇନ୍‌କୁକେ ଜେତ୍‌ନାଃ କାଏ କାଜିୟାଦ୍‌କଆ, ମେନ୍‌ଦ ଏସ୍‌କାର୍‌ରେ ଇନିଃ ଆୟାଃ ଚେଲାକକେ ସବେନାଃରାଃ ମୁଣ୍ଡି ଉଦୁବାକ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌, ଆୟୁବ୍‌ୟାନ୍‌ଚି ୟୀଶୁ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, “ଦଲାବୁ, ଦରେୟା ହାନ୍‌ ପାରମ୍‌ତେବୁଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ଆଡଃ ଚେଲାକ ଗାଦେଲ୍‌ ହଡ଼କକେ ବାଗିକେଦ୍‌ତେ ଲାଉକାରେ ଦୁବ୍‌ୟାନାକ, ମେନ୍‌ଦ ୟୀଶୁ ସିଦାରେ ଦୁବାକାନ୍‌ ତାଇକେନାଏ, ଏନ୍ତେ ଇନ୍‌କୁ ଲାଉକାକେ ଚାଲାଅକେଦାଃକ, ଏନ୍ତାଃରେ ଏଟାଃ ଲାଉକାକହ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଦୁଦୁଗାର୍‌ହୟ ବିରିଦ୍‌ୟାନା ଆଡଃ ଲାଉକାରେ ଆଲ୍‌ପୁଙ୍ଗ୍‌କ ରାକାବ୍‌ୟାନା, ଏନାତେ ଲାଉକାରେ ଦାଆଃ ପେରେଜଃତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ଇମ୍‌ତା ୟୀଶୁ ଲାଉକାରେୟାଃ ତାୟମ୍‌ସାଃରେ ଉଠୁଙ୍ଗିକେଦ୍‌ତେ ଦୁଡ଼ୁମାକାନାଏ ତାଇକେନା । ଚେଲାକ ଇନିଃକେ ବିରିଦିତାନ୍‌ଲଃ କାଜିକିୟାଃକ, “ହେ ଗୁରୁ, ଡୁବିଃଗ୍‌ ଗଜଃତାନାଲେ, କାମ୍‌ଚି ପାହାମ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ୟୀଶୁ ବିରିଦ୍‌ତିଙ୍ଗୁୟାନ୍‌ଚି ହୟକେ ମାରାଙ୍ଗ୍‌ମଚାକିୟା ଆଡଃ ଆଲ୍‌ପୁଙ୍ଗ୍‌କେ କାଜିକେଦା, “ହାପାଅଃମେଁ,” ଆଡଃ ଏନା ରୁଡ଼ୁୟାନା, ଆଡଃ ପୁରା ସିଃସଏଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ଏନ୍ତେ ୟୀଶୁ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, “ଚିନାଃ ମେନ୍ତେପେ ବରତାନା ? ନାହାଁଃ, ଜାକେଦ୍‌ ଆପେୟାଃ ବିଶ୍ୱାସ୍‌ ବାନଃଆଚି ?” ");
INSERT INTO unx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ଏନାତେ ଇନ୍‌କୁ ପୁରାଃଗି ବରକେଦାଃକ, ଆଡଃ ମେପେନ୍‌ୟାନାକ, “ନିଃଦ ଅକଏ ତାନିଃ ? ହୟ, ଆଡଃ ଦରେୟା ହଁ ନିୟାଃ କାଜିକ ମାନାତିଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ଗାଲିଲ୍‌ ଦରେୟା ସେନ୍‌ପାରମ୍‌କେଦ୍‌ତେ ଗେରାସିମିକଆଃ ପାର୍‌ଗାନ୍‌ତେ ତେବାଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଇନିଃ ଲାଉକାଏତେ ଆଡ଼୍‌ଗୁୟାନ୍‌ଚି, ସତ୍‌ରା ଆତ୍ମାତେ ଏସେରାକାନ୍‌ ମିହୁଡ଼୍‌ ହଡ଼ ତପାଠାୟାଦ୍‌ଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନ୍‌ଦାରମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ଇନିଃ ତପା ଠାୟାଦ୍‌ରେ ତାଇନଃତାନାଏ ତାଇକେନା, ଇନିଃକେ ଜେତାଏ କାକ ତଲ୍‌ ଦାଡ଼ିତାଇକେନା, ସିକ୍‌ଡ଼ିତେହଁ କାହାଗି । ");
INSERT INTO unx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ପୁରାଃସା ଇନିୟାଃ କାଟା ତିଃଇକ ସିକ୍‌ଡ଼ିତେ ତଲାକାନ୍‌ ତାଇକେନାଏ, ମେନ୍‌ଦ ସବେନ୍‌ ଇମ୍‌ତା ଇନିଃ ସିକ୍‌ଡ଼ି ଆଡଃ ବେଡ଼ିକକେ ଟଟାଃକେଦାଏ । ଇନିଃତାଃରେ ପୁରାଃ ପେଡ଼େଃ ତାଇକେନା ଆଡଃ ଜେତାଏ ହଁ ଇନିଃକେ କାକ କାବୁ ଦାଡ଼ିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ନିଦା ଆଡଃ ସିଙ୍ଗି ତପା ଠାୟାଦ୍‌କରେ, ବୁରୁରେ କାଉରିତାନ୍‌ ଆଡଃ ଦିରିତେ କଟେୟଃତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ସାଙ୍ଗିନ୍‌ଏତେ ୟୀଶୁକେ ନେଲ୍‌ତାଇଲଃ ନିର୍‌ଦାରମ୍‌କେଦ୍‌ତେ ଆୟାଃ ଆୟାର୍‌ରେ ଅମ୍ବାଃ ଇକ୍‌ଡ଼ୁମ୍‌ ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ଆଡଃ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ଏ, ସାଲାଙ୍ଗିଉତାର୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ୟୀଶୁ, ଆଇଁୟାଃଲଃ ଆମାଃ ଚିକାନ୍‌ କାମି ମେନାଃ ? ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ନୁତୁମ୍‌ତେ କଏଁମେ ତାନାଇଙ୍ଗ୍‌, ଆଲମ୍‌ ସାସାତିଆଁ ।” ");
INSERT INTO unx_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ଚିୟାଃଚି “ଏ, ସତ୍‌ରା ଆତ୍ମା, ନେ ହଡ଼ଏତେ ଅଡଙ୍ଗ୍‌ଅଃମେ” ମେନ୍ତେ ୟୀଶୁ କାଜିକାଇ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଏନ୍ତେ ୟୀଶୁ ଇନିଃକେ କୁଲିକିୟା, “ଆମାଃ ନୁତୁମ୍‌ ଚିକ୍‌ନାଃ ? ଆଇଁୟାଃ ନୁତୁମ୍‌ ଫାଉଦ୍, ଆଲେ ପୁରାଃଗି ମେନାଲେୟା” ମେନ୍ତେ କାଜିରୁହାଡ଼୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ଆଡଃ ଇନିଃ ୟୀଶୁକେ, ନେ ଦିଶୁମ୍‌ଏତେ ଆଲମ୍‌ଗି ହାର୍‌ ଅଡଙ୍ଗ୍‌ଲେୟା, ମେନ୍ତେ ପୁରାଃଗି ବିନ୍ତିତାନ୍‌ଲଃ କାଜିଗହାର୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ବୁରୁଗେନା ଜାପାଃରେ ସୁକୁରିକଆଃ ମାରାଙ୍ଗ୍‌ ଗୋଟ୍‌ ଆତିଙ୍ଗ୍‌ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ଆଡଃ, ବଙ୍ଗାକ ବିନ୍ତିକେଦ୍‌ତେ କାଜିକିୟାଃକ, “ଆଲେକେ ଏନ୍‌ ସୁକୁରିକରେ ବଲଃ ନାଗେନ୍ତେ କୁଲ୍‌ତାଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ୟୀଶୁ ଇନ୍‌କୁକେ ସେନ୍‌ଇଚିକେଦ୍‌କଆ, ଆଡଃ ଏନ୍‌ ସତ୍‌ରା ଆତ୍ମାକ ଏନ୍‌ ହଡ଼ଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ସୁକୁରିକରେକ ବଲୟାନା, ଆଡଃ ଏନ୍ତାଃରେ ଦୁଇ ହାଜାର୍‌ ଲେକା ସୁକୁରିକ ଆତିଙ୍ଗ୍‌ ତାଇକେନା, ଇନ୍‌କୁ ଦରେୟାରେକ ନିର୍‌ ଢୁଷ୍‌ମାଅୟାନା ଆଡଃ ଡୁବିଃଗ୍‌ ଗଏଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ସୁକୁରି ଗୁପିତାନ୍‌କ ନିର୍‌ୟାନାକ ଆଡଃ ସାହାର୍‌ ଆଡଃ ଟଲାକରେ ନେ କାଜିକ ଉଦୁବ୍‌କେଦାଃ, ଏନ୍ତେ ଚିକ୍‌ନାଃ ଚିକାୟାନା ମେନ୍ତେ ହଡ଼କ ନେଲ୍‌ ନାଗେନ୍ତେ ଅଡଙ୍ଗ୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ଆଡଃ ଇନ୍‌କୁ ୟୀଶୁତାଃ ତେବାଃୟାନ୍‌ଚି ବଙ୍ଗା ଏସେର୍‌କାନ୍‌ ହଡ଼କେ ଇନିୟାଃ କାଟାସୁବାରେ ବୁଗିନ୍‌ମନ୍‌ତେ ଦୁବାକାନ୍‌, ଆଡଃ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍‌ ନେଲ୍‌କିଃତେ ବରକେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ନେ ସବେନ୍‌ ନେଲାକାଦ୍‌ ହଡ଼କ, ବଙ୍ଗା ଏସେର୍‌କାନ୍‌ ଏନ୍‌ ହଡ଼ ଚିଲ୍‌କା ବୁଗିୟାନାଏ ଆଡଃ ସୁକୁରିକ ଚିଲ୍‌କାୟାନା ଏନା ସବେନ୍‌ ହଡ଼କକେ ଉଦୁବାଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ଏନ୍ତେ ଇନ୍‌କୁ ୟୀଶୁକେ, ଆଲେୟାଃ ସିମ୍‌ନାଏତେ, ଅଡଙ୍ଗ୍‌ଅଃମେ ମେନ୍ତେକ ବିନ୍ତିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ଏନ୍ତେ ୟୀଶୁ ଲାଉକାରେ ରାକାବ୍‌ତାନ୍‌ ଇମ୍‌ତା, ବଙ୍ଗା ଏସେର୍‌ଏତେ ବୁଗିକାନ୍‌ ହଡ଼, ୟୀଶୁକେ “ଆମାଃଲଃ ତାଇନ୍‌ ଚିକାଆଇଙ୍ଗ୍‌ମେଁ” ମେନ୍ତେ ବିନ୍ତିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ମେନ୍‌ଦ ୟୀଶୁ “କାହାଗି, ଆମାଃ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ମେଁ ଆଡଃ ଗମ୍‌କେ ଆମାଃ ନାଗେନ୍ତେ ଚିନାଃ ରିକାକେଦାଃଏ, ଆଡଃ ଚିଲ୍‌କା ଆମ୍‌କେ ଦାୟାକାଦ୍‌ମେୟା ଏନ୍‌ ସବେନାଃ ଆମାଃ ଅଡ଼ାଃରେନ୍‌କକେ ଉଦୁବାକମେ” ମେନ୍ତେ କାଜିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ଏନ୍ତେ ଏନ୍‌ ହଡ଼ ରୁହାଡ଼୍‌ୟାନାଏ ଆଡଃ ଆୟାଃ ନାଗେନ୍ତେ ୟୀଶୁ ଚିନାଃ ରିକାକେଦାଃଏ ଏନା ସବେନ୍‌ ଦେକାପଲ୍ଲୀରେ ଉଦୁବ୍‌ ଏଟେଦ୍‌କେଦାଏ, ଆଡଃ ଏନା ଆୟୁମ୍‌ତାନ୍‌କ ଆକ୍‌ଦାନ୍ଦାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ୟୀଶୁ ଲାଉକାରେ ଦରେୟାରାଃ ହାନ୍‌ ପାରମ୍‌ଏତେ ନେ ପାରମ୍‌ତେ ରୁହାଡ଼୍‌ୟାନ୍‌ଚି, ଏନ୍ତାଃରେ ଗାଦେଲ୍‌ ହଡ଼କ ହୁଣ୍ଡିୟାନା, ଆଡଃ ୟୀଶୁ ଦରେୟା ଗେନାରେ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ଏନ୍ତେ ଯାଇରସ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସାମାଜ୍‌ଅଡ଼ାଃରେନ୍‌ ଆଗୁଆଇ ହଡ଼ ହିଜୁଃୟାନାଏ, ଆଡଃ ୟୀଶୁକେ ନେଲ୍‌କେଦ୍‌ତେ ଆୟାଃ କାଟାସୁବାରେ ଉୟୁଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ପୁରାଃଗି ବିନ୍ତିତାନ୍‌ଲଃ କାଜିକେଦା, “ହନିଙ୍ଗ୍‌କୁଡ଼ି ଦୁକୁତେ ଗଜଃ ଲେକାକାନାଏ, ଇନିଃ ଚିଲ୍‌କା ବାଞ୍ଚାଅଃଆଏ, ଏନାମେନ୍ତେ ହିଜୁଃମେ, ଆଡଃ ଇନିୟାଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହେମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ଏନ୍ତେ ୟୀଶୁ ଇନିଃଲଃ ସେନଃୟାନାଏ ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ଉପୁଦୁର୍‌ଠେପ୍‌ସାକେଦ୍‌ତେ ଜୁରୁବିହୁର୍‌ ତାନ୍‌ଲଃ ଦୟା ଦୟାକ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ଆଡଃ ଏନ୍ତାଃରେ ବାରା ବାରାଷ୍‌ଏତେ “ମାୟୋମ୍‌ଲିଙ୍ଗି” ଦୁକୁରେ ଦୁକୁତାନ୍‌ ମିଆଁଦ୍‌ କୁଡ଼ି ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ଇନିଃ ପୁରାଃ ବାଇଦ୍‌କତାଃରେ ରାନୁଆକାନ୍‌ ତାଇକେନାଏ, ଆଡଃ ଆୟାଃ ସବେନ୍‌ ତାଇକେନ୍‌ତେୟାଃ ଇନ୍‌କୁଆଃରେ ଚାବାକେଦାଏ, ଏନ୍‌ରେୟ କାଏ ବୁଗିୟାନା, ମେନ୍‌ଦ, ଦୁକୁତାୟାଃ ଆଡଃଗି ସାର୍‌ସାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ଇନିଃ ୟୀଶୁଆଃ ବିଷାଏ ଆୟୁମ୍‌କେଦ୍‌ଚି ଗାଦେଲ୍‌ ହଡ଼କଆଃ ଥାଲାରେ ଇନିୟାଃ ଦୟାହରା ଏତେ ଲିଜାଃରାଃ ଆଚ୍‌ରା ଜୁଟିଦ୍‌ ନାଙ୍ଗ୍‌ ହିଜୁଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ଚିୟାଃଚି ଇନିଃ ଆୟାଃ ମନ୍‌ରେ “ଇନିୟାଃ ଲିଜାଃ ଏସ୍‌କାର୍‌ ଜୁଟିଦ୍‌ତାରେଦ ଆଇଙ୍ଗ୍‌ ବୁଗିକଆଇଙ୍ଗ୍‌” ମେନ୍ତେ ଉଡ଼ୁଃତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ଏନ୍ତେ ଇନିଃ ୟୀଶୁଆଃ ଲିଜାଃ ଆଚ୍‌ରାକେ ଜୁଟିଦ୍‌କେଦାଏ ଆଡଃ, ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଇନିଃ ମାୟୋମ୍‌ ଲିଙ୍ଗି ଦୁକୁଏତେ ବୁଗିୟାନାଏ । ଆଡଃ ଦୁକୁଏତେ ବୁଗିୟାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ ଆୟାଃ ହଡ଼୍‌ମରେ ଆଟ୍‌କାର୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ୟୀଶୁ, “ଆଇଙ୍ଗ୍‌ଏତେ ପେଡ଼େଃ ଅଡଙ୍ଗ୍‌ୟାନା” ମେନ୍ତେ ଜୀଉରେ ସାରିଆଟ୍‌କାର୍‌କେଦାଏ, ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ, “ଅକଏ, ଆଇଁୟାଃ ଲିଜାଃ ଜୁଟିଦ୍‌କେଦାଏ ?” ମେନ୍ତେ କୁଲିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ଆଡଃ ଚେଲା ତାୟାଃକ ୟୀଶୁକେ କାଜିକିୟାଃକ, “ଗାଦେଲ୍‌ ହଡ଼କ ଆମାଃ ଚେତାନ୍‌ରେ ଉୟୁଗଃତାନାକ, ଏନାଦ ନେଲ୍‌କତାନାମ୍‌, ଆଡଃ ‘ଅକଏ ଜୁଟିଦ୍‌କିଦିୟାଁଏ,’ ମେନ୍ତେ ଚିନାଃମ୍‌ କୁଲିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ମେନ୍‌ଦ ଜୁଟିଦ୍‌କେଦ୍‌ନିଃକେ ୟୀଶୁ ନେଲ୍‌ନାମି ନାଗେନ୍ତେ ହେତାବାଡ଼ାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ଏନ୍‌ କୁଡ଼ି ଆଇଁୟାଃ ଚିକ୍‌ନାଃ ଚିକାୟାନା ନେଆଁଁ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ, ବରତେ ଏକ୍‌ଲାଅଃତାନ୍‌ଲଃ ହିଜୁଃୟାନାଏ ଆଡଃ ଇକ୍‌ଡ଼ୁମ୍‌ ତାନ୍‌ଲଃ ସବେନାଃ ସାର୍‌ତିଗି ୟୀଶୁକେ ଉଦୁବ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ୟୀଶୁ କାଜିକିୟାଏ, “ଏ ମାଈ, ବିଶ୍ୱାସ୍‌ ତାମାଃ ବୁଗିୟାକାଦ୍‌ମେଁୟାଏ, ଜୁ ସୁକୁ ଜୀଉତେ ସେନଃମେ, ଆଡଃ ଆମାଃ ଦୁକୁଏତେ ବୁଗିୟାକାନ୍‌ ତାଇନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ୟୀଶୁ ଏନା କାଜିତାନ୍‌ ଇମ୍‌ତାଗି, ସାମାଜ୍‌ ଅଡ଼ାଃ ଚାଲାଅନିୟାଃ ଅଡ଼ାଃଏତେ କାଜି ଆଉୱାକାଦ୍‌ ହଡ଼ ଯାଇରସକେ କାଜିକିୟାଏ, “ହନ୍‌ମେକୁଡ଼ି ଗଏଃୟାନାଏ, ଗୁରୁକେ ଆଡଃ ଆଲ୍‌ମେ ଦୁକୁଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ୟୀଶୁ ଏନ୍‌କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ କା ଆୟୁମ୍‌ତାନ୍‌ ଲେକା ସାମାଜ୍‌ଅଡ଼ାଃରେନ୍‌ ଆଗୁଆଇକେ କାଜିକିୟା, “ଆଲମ୍‌ ବରଏୟା, ବିଶ୍ୱାସ୍‌ରେଗି ତାଇନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ଆଡଃ ୟୀଶୁ, ପାତ୍‌ରାସ୍‌, ଯାକୁବ୍‌, ଆଡଃ ଯୋହାନ୍‌, ଯାକୁବ୍‌ଆଃ ହାଗାତେକେ ବାଗିକେଦ୍‌ତେ ଆଡଃ ଜେତାଏକକେ କାଏ ସେନ୍‌ ଇଚିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ଯାଇରସଆଃ ଅଡ଼ାଃତେ ସେଟେର୍‌ୟାନ୍‌ଚି, ୟୀଶୁ ଗାଦେଲ୍‌ ହଡ଼କ ହାଲାଗୁଲାତାନ୍‌ଲଃ, ରାଆଃତାନ୍‌ ଆଡଃ ଏୟମ୍‌ତାନ୍‌ ନେଲ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ଇନିଃ ଅଡ଼ାଃରେ ବଲୟାନାଏ, ଆଡଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆ, “ଚିନାଃ ମେନ୍ତେପେ ହାଲାଗୁଲାଏତାନା ଆଡଃପେ ରାଆଃଏତାନା ? ଏନ୍‌ ହନ୍‌ଦ କାଏ ଗଜାକାନା ମେନ୍‌ଦ ଦୁଡ଼ୁମ୍‌ତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଲାନ୍ଦାକିୟାଃକ । ମେନ୍‌ଦ ୟୀଶୁ ସବେନ୍‌ ହଡ଼କକେ ଏନ୍ତାଃଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌କଚି, କୁଡ଼ିହନ୍‌ରାଃ ଏଙ୍ଗାଆପୁକିନ୍‌ ଆଡଃ ଆୟାଃଲଃ ତାଇକାନ୍‌ ଚେଲାକଲଃ, କୁଡ଼ିହନ୍‌ ଗିତିଜାକାନ୍‌ତାଃ ସେନ୍‌ ବଲୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ଆଡଃ ଇନିୟାଃ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ “ଟାଲିଥାକୁମ୍‌” ମେନ୍‌କିୟାଏ, ନେ କାଜିରେୟାଃ ମୁଣ୍ଡି ନେଆଁଁ ତାନାଃ, “ଏ ମାଈ ବିରିଦ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ଇମ୍‌ତାଗି ଏନ୍‌ କୁଡ଼ିହନ୍‌ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ସେସେନ୍‌ ବାଡ଼ାକେଦାଏ, ଚିୟାଃଚି ଇନିଃଦ ବାରା ବାରାଷ୍‌ରେନ୍‌ ତାଇକେନାଏ । ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ ପୁରାଃଗି ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ମେନ୍‌ଦ ୟୀଶୁ “ନେ କାଜି ଜେତାଏତାଃରେ ଆଲ୍‌ପେ ଉଦୁବେୟା,” ମେନ୍ତେ କାଜିୟାଦ୍‌କଆଏ, ଆଡଃ “କୁଡ଼ିହନ୍‌କେ ଜେତ୍‌ନାଃ ଜଜମ୍‌ ନାଙ୍ଗ୍‌ ଏମାଇପେ” ମେତାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ୟୀଶୁ ଏନ୍ତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନା । ଆଡଃ ଚେଲାକଲଃ ଆୟାଃ ସାହାର୍‌ତେ ହିଜୁଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ଇନିଃ ଇତୁ ଏଟେଦ୍‌କେଦାଏ । ଏନ୍ତାଃରେନ୍‌ ପୁରାଃ ହଡ଼କ ଇନିୟାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ, ଆଡଃକ ମେନ୍‌କେଦାଃ, “ଇନିଃ ନେ ସବେନ୍‌କାଜି ଅକ୍‌ତାଃଏତେ ନାମାକାଦା ? ଇନିଃ ଅକ୍‌ତାଃଏତେ ନେ ସେଣାଁଁ ଆଡଃ ପେଡ଼େୟାନ୍‌ କାମିକରେୟାଃ ପେଡ଼େଃ ନାମାକାଦାଏ ? ନିଃ ଚିଲ୍‌କା ନେ ଲେକା ପେଡ଼େୟାନ୍‌ କାମିକ କାମିତାନାଏ ? ");
INSERT INTO unx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ଚିୟାଃ ନିଃ ଏନ୍‌ ବାଢ଼ାଇ ନାହାଁଲିଃ ? ଚିୟାଃ ନିଃ ମାରିୟାମ୍‌ଆଃ ହନ୍ତେକଡ଼ା ନାହାଁଲିଃ ? ଆଡଃ ଯାକୁବ୍‌, ଯୋସି, ଶିମୋନ୍‌ ଆଡଃ ଯିହୁଦା ନେ ସବେନ୍‌କ ଆୟାଃ ହାଗାକ କା'ଚି ତାନ୍‌କ ? ଆଡଃ ଇନିୟାଃ ମିଶିକ ଆବୁଲଃଚି ବାଙ୍ଗ୍‌କଆ ?” ଆଡଃ, ଇନ୍‌କୁ ୟୀଶୁକେ କାକ ବିଶ୍ୱାସ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ନାବୀ ଆୟାଃ ଦିଶୁମ୍‌ ଆଡଃ ଆୟାଃ କୁଟୁମ୍‌, ଆଡଃ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌କକେ ବାଗିକେଦ୍‌ତେ ସବେନ୍‌ତାଃରେ ମାଇନଃଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ୟୀଶୁ ଚିମିନ୍‌ ଦୁକୁତାନ୍‌କକେ ତିଃଇତେ ଜୁଟିଦ୍‌କେଦ୍‌ତେ ବୁଗିକେଦ୍‌କଆଏ, ଏନା ବାଗିକେଦ୍‌ତେ ଆଡଃ ଏନ୍ତାଃରେ ଇନିଃ ଜେତାନ୍‌ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ କାଏ ରିକା ଦାଡ଼ିକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁଆଃ କା ବିଶ୍ୱାସ୍‌ତେୟାଃ ନେଲ୍‌କେଦ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନା । ଏନ୍ତେ ୟୀଶୁ ହପର୍‌ଜାପାଃ ହାତୁ ହାତୁ ସେନ୍‌କେଦ୍‌ତେ ଇତୁତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ଏନ୍ତେ ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ କେଡ଼ାକେଦ୍‌ତେ, ବାବାର୍‌ହଡ଼୍‌ଲେକା କୁଲ୍‌କେଦ୍‌କଆଏ । ଆଡଃ ସତ୍‌ରା ଆତ୍ମା ହାର୍‌ଅଡଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଇନ୍‌କୁକେ ଆକ୍‌ତେୟାର୍‌ ଏମାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ଆଡଃ ୟୀଶୁ ଚିର୍ଗାଲ୍‌କେଦ୍‌କଆଏ, “ହରାସେନ୍‌ ନାଗେନ୍ତେ ସଟା ବାଗିକେଦ୍‌ତେ ଆଡଃ ଜେତ୍‌ନାଃ ଆଲ୍‌ପେ ଇଦିୟା, ହଲଙ୍ଗ୍‌ ଚି ଥାଇଲା, ମାୟାଙ୍ଗ୍‌ରେ ଟାକା ପାଏସା ହଁ କାହାଗି । ");
INSERT INTO unx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","କାଟାରେ ଖାର୍‌ପା ତୁସିଙ୍ଗ୍‌ୟେଁନ୍‌ପେ ମେନ୍‌ଦ ବାରିଆ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃ ଆଲ୍‌ପେ ସାବେୟା । ");
INSERT INTO unx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ଆଡଃ ଇନିଃ ମେତାଦ୍‌କଆଏ, ଜେତା ଅଡ଼ାଃରେ ଦାରମ୍‌ପେରେ, ଏନ୍‌ ସାହାର୍‌ଏତେ ଆଉରିପେ ଅଡଙ୍ଗ୍‌ଅଃ ଜାକେଦ୍‌ ଏନ୍‌ ଅଡ଼ାଃରେଗି ତାଇନ୍‌କାନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ଜାହାନ୍‌ ଠାୟାଦ୍‌ରେନ୍‌କ କାକ ସୁକୁଆପେରେ, ଆଡଃ ଆପେୟାଃ କାଜି କାକ ଆୟୁମ୍‌ରେଦ, ଏନ୍ତାଃଏତେ ସେନଃତାନ୍‌ଲଃ, ଆପେୟାଃ କାଟା ତାଲ୍‌କାରେୟାଃ ଧୁଡ଼ି ଇନ୍‌କୁଆଃ ବିରୁଧ୍‌ରେଆଃ ଗାୱା ନାଗେନ୍ତେ କଟା ବାଗିତାପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ଇନ୍‌କୁ ସେନଃୟାନାକ ଆଡଃ ହଡ଼କକେ ହେୟାତିଙ୍ଗ୍‌ ଲାଗାତିୟାଃଁ ମେନ୍ତେ ଉଦୁବ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ଇନ୍‌କୁ ପୁରାଃ ବଙ୍ଗାକକେ ହଡ଼କତାଃଏତେ ହାର୍‌ଅଡଙ୍ଗ୍‌ କେଦ୍‌କଆକ ଆଡଃ ପୁରାଃ ଦୁକୁହାସୁତାନ୍‌ ହଡ଼କକେ ସୁନୁମ୍‌ ଗସଃକେଦ୍‌ତେ ବୁଗିକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ୟୀଶୁଆଃ ନୁତୁମ୍‌ ସବେନ୍‌ସାଃରେ ନିତିର୍‌ୟାନ୍ତେ, ହେରୋଦ୍‌ ରାଜା ଇନିୟାଃ ବିଷାଏ ଆୟୁମ୍‌କେଦା । ଚିମିନ୍‌ ହଡ଼କ କାଜିତାଇକେନାକ, “ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ଗଜାକାନ୍‌ଏତେ ଜୀଉବିରିଦାକାନାଏ, ଏନା ମେନ୍ତେଗି ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ଇନିୟାଃ ହରାତେ ହବାଅଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ମେନ୍‌ଦ ଏଟାଃକ କାଜିକେଦାଃକ, “ଇନିଃ ଏଲିୟ ତାନିଃ, ଆଡଃ ଚିମିନ୍‌ ହଡ଼କ କାଜିକେଦାଃକ, ଇନିଃ ସିଦାରେନ୍ ନାବୀକଏତେ ମିଆଁଦ୍‌ ନାବୀ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ମେନ୍‌ଦ ହେରୋଦ୍‌ ନେଆଁଁକ ଆୟୁମ୍‌କେଦ୍‌ତେ ମେନ୍‌କେଦାଏ, “ଆଇଙ୍ଗ୍‌ ବହଃ ଖାଣ୍ଡାଅକାନ୍‌ ଯୋହାନ୍‌ ଗଜାକାନ୍‌ କଏତେ ଜୀଉବିରିଦ୍‌ୟାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ନେ ହେରୋଦ୍‌ଗି ଯୋହାନ୍‌କେ ସାସାବ୍‌ରାଃ ହୁକୁମ୍‌ ଏମାକାଦ୍‌ ତାଇକେନାଏ, ଆଡଃ ଇନିଃକେ ତଲ୍‌କିଃତେ ଜେହେଲ୍‌କିୟାଏ, ହେରୋଦ୍‌ ନେଆଁଁ ରିକାକେଦାଏ, ଚିୟାଃଚି ହେରୋଦ୍‌ ଆୟାଃ ହାଗାତେ ଫିଲିପ୍‌ରାଃ କୁଡ଼ିତେ ହେରୋଦିୟାଃକେ ମାଣ୍ଡାଅକାଇ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ଚିୟାଃଚି “ହାଗାମାଃ କୁଡ଼ିକେ ଦହତେୟାଃ ଆଇନ୍‌ ଲେକାତେ ଆମାଃ ନାଙ୍ଗ୍‌ କା ଠାଉକାଃ” ମେନ୍ତେ ଯୋହାନ୍‌ ହେରୋଦ୍‌କେ କାଜିକାଇ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ଏନାତେ, ହେରୋଦିୟାଃ ଇନିଃକେ ଖିସ୍‌ତେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ ତାଇକେନାଏ, ମେନ୍‌ଦ ହେରୋଦିଆ କାଏ ଦାଡ଼ିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ଚିୟାଃଚି, ହେରୋଦ୍‌ ଯୋହାନ୍‌କେ ମିଆଁଦ୍‌ ଧାର୍‌ମାନ୍‌ ଆଡଃ ପାବିତାର୍‌ ହଡ଼ ତାନିଃ ମେନ୍ତେ ସାରିକେଦ୍‌ତେ ବରଆଇତାନ୍‌ ତାଇକେନାଏ ଆଡଃ ଇନିଃକେ ଜେହେଲ୍‌ରେ ଜୀହିଦ୍‌ଗି ମାଣ୍ଡାଅକାଇ ତାଇକେନାଏ । ଆଡଃ ଇନିୟାଃ କାଜିକ ଆୟୁମ୍‌କେଦ୍‌ତେ ପୁରାଃଗି ଦାନ୍ଦରାଅଃ ତାଇକେନ୍‌ରେୟ ଇନିୟାଃ କାଜିକ ରାସ୍‌କାତେ ଆୟୁମ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ଟୁଣ୍ଡୁରେ ହେରୋଦିଆ ନାଗେନ୍ତେ ନେଡା ସେଟେର୍‌ୟାନା, ହେରୋଦ୍‌ ଆୟାଃ ଜାନାମ୍‌ ହୁଲାଙ୍ଗ୍‌କେ ମାନାଅ ନାଗେନ୍ତେ, ଆୟାଃ ମାପ୍‌ରାଙ୍ଗ୍‌ ଦାର୍‌ବାର୍‌ ହଡ଼କ, ପାଲ୍‌ଟାନ୍‌କଆଃ ସାର୍‌ଦାର୍‌କ, ଆଡଃ ଗାଲିଲ୍‌ରେନ୍ ମାପ୍‌ରାଙ୍ଗ୍‌ ହଡ଼କଆଃ ନାଗେନ୍ତେ ନୁବାଃରେୟାଃ ମାରାଙ୍ଗ୍‌ ଜଜମାଃ ବାଇକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ହେରୋଦିୟାଃରାଃ ହନ୍ତେକୁଡ଼ି ଜମେଅଡ଼ାଃରେ ବଲକେଦ୍‌ତେ ସୁସୁନ୍‌କେଦାଏ, ଆଡଃ ହେରୋଦ୍‌ତାଃ ହିଜୁଆକାନ୍‌ ସବେନ୍‌ ନେଅଁତା ହଡ଼କକେ ରାସ୍‌କା କେଦ୍‌କଆଏ । ଏନ୍ତେ ରାଜା ହେରୋଦ୍‌ ହନ୍ତେକୁଡ଼ିକେ କାଜିକିୟାଏ “ଆମ୍‌ ସୁକୁଃତେଆଃ ଜେତ୍‌ନାଃମ୍‌ ଆସିଙ୍ଗ୍‌ରେହଁ, ଏନାଇଙ୍ଗ୍‌ ଏମାମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“ଜାହାନାଃଗି ଆସିଙ୍ଗ୍‌ମେ, ରାଇଜ୍‌ରାଃ ତାରାହାଟିଙ୍ଗ୍‌ ମେନେରେୟଗି ଆଇଙ୍ଗ୍‌ ଏମାମେୟାଁ” ମେନ୍ତେ ରାଜା ଇନିଃତାଃରେ କିରିୟାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ଆଡଃ ଏନ୍‌ କୁଡ଼ିହନ୍‌ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ, ଚିକାନାଃଇଙ୍ଗ୍‌ ଆସିୟା ମେନ୍ତେ ଏଙ୍ଗାତେକେ କୁଲିକିୟାଏ ? ଆୟାଃ ଏଙ୍ଗାତେ କାଜିରୁହାଡ଼୍‌କିୟା “ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ଆଃ ବହଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ଏନ୍‌ କୁଡ଼ିହନ୍‌ ଜାଲ୍‌ଦିଗି ହିଜୁଃ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ରାଜାକେ କାଜିକିୟାଏ, “ନାହାଁଃଗି ନେତାଃରେ, ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ରାଃ ବହଃ ମିଆଁଦ୍‌ ଥାଡ଼ିରେ ଏମାଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ଏନ୍‌ କାଜି ହରାତେ ରାଜା ପୁରାଃଗି ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନା, ମେନ୍‌ଦ ନେଅଁତାକାନ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ କିରିୟାକାଦ୍‌ ହରାତେ ଇନିଃ ଆୟାଃ ଆନାସିକେ ବାନଃ ମେନ୍ତେ ମାନା କାଏ ଦାଡ଼ିକେନା । ");
INSERT INTO unx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ଏନା ମେନ୍ତେ ରାଜା ଇମ୍‌ତାଗି ମିଆଁଦ୍‌ ସିପାଇକେ, ଯୋହାନ୍‌ଆଃ ବହଃ ଥାଡ଼ିରେ ଆଉ ନାଗେନ୍ତେ କୁଲ୍‌କିୟାଏ, ଇନିଃଦ ସେନଃୟାନ୍ତେ, ଜେହେଲ୍‌ରେ ଯୋହାନ୍‌ରାଃ ବହଃକେ ମାଆଃକେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଏନ୍ତେ ଇନିୟାଃ ବହଃ ମିଆଁଦ୍‌ ଥାଡ଼ିରେକ ଆଉକେଦା ଆଡଃ ହନ୍ତେକୁଡ଼ିକେକ ଏମ୍‌କିୟା, ଏନ୍ତେ କୁଡ଼ିହନ୍‌ ଏଙ୍ଗାତେକେ ଏନା ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଯୋହାନ୍‌ଆଃ ଚେଲାକ ଏନା ଆୟୁମ୍‌କେଦ୍‌ତେକ ହିଜୁଃୟାନା ଆଡଃ ଆୟାଃ ହଡ଼୍‌ମକେ ଇଦିକେଦ୍‌ତେ ତପାଗାଡ଼ାରେକ ତପାକେଦା । ");
INSERT INTO unx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ପ୍ରେରିତ୍‌କ ୟୀଶୁତାଃରେକ ହୁଣ୍ଡିୟାନା, ଆଡଃ ଆକ କାମିକାଦ୍ ସବେନାଃ, ହଡ଼କକେ ଇତୁତେଆଃକ ଇନିଃକେ ଉଦୁବ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ଏନ୍ତେ ପୁରାଃ ହଡ଼କ ହିଜୁଃ ସେନଃତାନ୍‌କ ତାଇକେନା, ଆଡଃ କୁଲାକାନ୍‌ ଚେଲାକ ଜଜମ୍‌ ନାଗେନ୍ତେ ସାମାଏ କାକ ନାମ୍‌କେଦାଃ, ଏନାମେନ୍ତେ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଦଲା ଜାହାନ୍‌ ସିଃସଏଃ ଠାୟାଦ୍‌ତେବୁଆଃ, ଅକ୍‌ତାଃରେ ଆବୁ ହୁଡିଙ୍ଗ୍‌ଲେକା ରୁଡ଼ୁନ୍‌ବୁ ଦାଡ଼ିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ଏନ୍ତେ ଇନ୍‌କୁ ଲାଉକାରେ ଦେଏଃୟାନ୍ତେ ମିଆଁଦ୍‌ ସିଃସଏଃ ଠାୟାଦ୍‌ତେ ସେନଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ମେନ୍‌ଦ, ହଡ଼କ ଇନ୍‌କୁକେ ସେନଃତାନ୍‌କ ନେଲ୍‌କେଦ୍‌କଆ ଆଡଃ ଇନ୍‌କୁକେ ନେଲ୍‌ଉରୁମ୍‌ କେଦ୍‌କଆକ, ଆଡଃ ସବେନ୍‌ ସାହାର୍‌କଏତେ ହଡ଼କ ସେସେନ୍‌ତେଗି ଏନ୍‌ ଠାୟାଦ୍‌ତେ ସିଦାରେଗି ତେବାଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ୟୀଶୁ ଲାଉକାଏତେ ଆଡ଼୍‌ଗୁୟାନ୍‌ଚି ଗାଦେଲ୍‌ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌ତେ ଜୀଉରେ ବିଲ୍‌କାଅୟାନାଏ, ଚିୟାଃଚି ଇନ୍‌କୁଦ ଗୁପିନିଃ ବାଙ୍ଗାଇ ମିଣ୍ଡିକ ଲେକାକ ତାଇକେନା, ଏନ୍ତାଃରେ ଇନିଃ ଇନ୍‌କୁକେ ଇତୁ ଏଟେଦ୍‌କେଦ୍‌ଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ଆଡଃ ସିଙ୍ଗି ହାସୁରଃତାନ୍‌ରେ, ଚେଲାକ ୟୀଶୁତାଃ ସେନ୍‌କେଦ୍‌ତେକ କାଜିକିୟା, “ନେ ଠାୟାଦ୍‌ ସିଃସଏଃଗିୟା, ଆଡଃ ସିଙ୍ଗିଅଃ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ଏନାମେନ୍ତେ ଜାପାଃ ହାତୁ ଆଡଃ ଟଲାକତେ ସେନ୍‌କେଦ୍‌ତେ ଜଜ୍‌ମାଃକ କିରିଙ୍ଗ୍‌ ଜମେକା ମେନ୍ତେ ଏନ୍‌ ହଡ଼କକେ ବିଦାତାକମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆପେଗି ଇନ୍‌କୁକେ ଜାହାନାଃ ଜମେୟାଃଁ ଏମାକପେ,” ଇନ୍‌କୁଦ ଇନିଃକେ କାଜିକିୟାକ, “ଆଲେଗି ଚି ୨୦୦ ରୁପାରାଃ ସିକାତେ ହଲଙ୍ଗ୍‌ କିରିଙ୍ଗ୍‌କେଦ୍‌ତେ ଜମେୟାଃଁଲେ ଏମାକଆ ?” ");
INSERT INTO unx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆଏ, “ଆପେତାଃରେ ଚିମିନ୍‌ ହଲଙ୍ଗ୍‌ ମେନାଃ ? ଜୁ, ନେଲାଉଲେପେ,” ଇନ୍‌କୁଦ ନାମ୍‌କେଦ୍‌ଚି ଇନିଃକେକ ଉଦୁବ୍‌କିୟା, “ମଣେୟାଁ ହଲଙ୍ଗ୍‌ ଆଡଃ ବାରିଆ ହାକୁ ।” ");
INSERT INTO unx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ଏନ୍ତେ ୟୀଶୁ ଚେଲାକକେ “ହାରିୟାର୍‌ ତାସାଦ୍‌ରେ ସବେନ୍‌ ହଡ଼କକେ ପାନ୍ତିପାନ୍ତି ଦୁବ୍‌କୁପେ” ମେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ଆଡଃ ହଡ଼କ ମିଆଁଦ୍‌ ପାନ୍ତିରେ ଶାଅ ଶାଅ ଆଡଃ ମିଆଁଦ୍‌ ପାନ୍ତିରେ ପାଚାଶ୍‌ ପାଚାଶ୍‌ ଲେକାକ ଦୁବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ଆଡଃ, ୟୀଶୁ ଏନ୍‌ ମଣେୟାଁ ହଲଙ୍ଗ୍‌ ଆଡଃ ବାରିଆ ହାକୁ ସାବ୍‌କେଦ୍‌ତେ ସିର୍ମାସାଃ ସାଙ୍ଗିଲ୍‌ରାକାବ୍‌ତାନ୍‌ଲଃ ଆଶିଷ୍‌କେଦାଏ ଆଡଃ ହଲଙ୍ଗ୍‌ କେଚାଃକେଦ୍‍ତେ ଚେଲାକକେ ଏମାଦ୍‍କଆଏ ଆଡଃ ହାକୁକେହଁ ଇନ୍‌କୁ ହାଟିଙ୍ଗ୍‌କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ସବେନ୍‌କ ଜମ୍‌କେଦ୍‌ତେ ବି'ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ଏନ୍ତେ ଚେଲାକ ଜମ୍‌ ସାରେଜାକାନ୍ ହଲଙ୍ଗ୍‌ ଆଡଃ ହାକୁ ବାରା ଟୁଙ୍କିକ ହାଲାଙ୍ଗ୍‌ ପେରେଃକେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ଜମ୍‌କେନ୍‌କଦ, ପାଞ୍ଚ୍‌ ହାଜାର୍‌ କଡ଼ାକ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ଇମ୍‌ତାଗି ୟୀଶୁ ଚେଲାକକେ ଲାଉକାରେ ଦୁବ୍‌କେଦ୍‌ତେ ଦରେୟା ହାନ୍‌ ପାରମ୍‌ ବେଥ୍‌ସାଇଦାତେ କୁଲ୍‌ ଆୟାର୍‌କେଦ୍‌କଆ । ଇମ୍‌ତାଲଃ ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ବିଦାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ବିଦାକେଦ୍‌ତେ, ବିନ୍ତି ନାଗେନ୍ତେ ବୁରୁତେ ରାକାବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ଆଡଃ ସିଙ୍ଗିହାସୁର୍‌ତାନ୍‌ରେ ଲାଉକା ଥାଲା ଦରେୟାରେ ତାଇକେନା, ଇମ୍‌ତାଦ ୟୀଶୁ ଏସ୍‌କାର୍‌ଗି ଅତେରେ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ସାମ୍‌ନାଙ୍ଗ୍‌ରାଃ ମାରାଙ୍ଗ୍‌ହୟତେ ଚେଲାକ ଦୁକୁତେ ଲାଉକାକେ ଇଦିତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ, ଇନିଃ ସେତାଃ ନିଦାରେୟାଃ ଉପୁନ୍‌ ଘାଡ଼ି ଇମ୍‌ତାକରେ ୟୀଶୁ ଦରେୟାରେ ସେସେନ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁତାଃତେ ହିଜୁଃକେଦ୍‌ତେ ସେନ୍‌ପାରମ୍‌କତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ମେନ୍‌ଦ ଇନ୍‌କୁ ଦରେୟା ଚେତାନ୍‌ରେ ଇନିଃକେ ସେସେନ୍‌ତାନ୍‌କ ନେଲ୍‌କିଃତେ ବରକେଦାକ ଆଡଃ “ବଙ୍ଗା ତାନିଃ” ମେନ୍ତେକ କାଉରିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ସବେନ୍‌କ ଇନିଃକେ ନେଲ୍‌କିଃତେ ବରତେକ ଥାର୍‌ଥାରାଅୟାନା । ଇମ୍‌ତାଗି ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଜୀଉରେ କେଟେଜେପେ, ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ ଆଲ୍‌ପେ ବରଏୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଏନ୍ତେ ଇନ୍‌କୁଲଃ ଲାଉକାରେ ଦେଏଃୟାନ୍‌ଚି ହୟ ସାଲ୍‌ସାନ୍ତ୍‌ୟାନା, ଚେଲାକଦ ପୁରାଃଗି ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ, ");
INSERT INTO unx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ଇନ୍‌କୁ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ହଡ଼କକେ ଜମେୟାଃଁ ହାଟିଙ୍ଗ୍‌ କାଜିରାଃ ହରାତେ କାକ ସେଣାଁଁୟାନା, ଚିୟାଃଚି ଆକଆଃ ମନ୍‌ କେଟେଦ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ଦରେୟା ପାରମ୍‌କେଦ୍‌ଚି ଗିନେସରେତ୍‌ ନୁତୁମ୍‌ ପାର୍‌ଗାନ୍‌ତେକ ସେଟେର୍‌ୟାନା, ଆଡଃ ଲାଉକାକେ ତଲ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ଇନ୍‌କୁ ଲାଉକାଏତେ ଆଡ଼୍‌ଗୁୟାନ୍‌ ତର୍‌ସା, ଏନ୍ତାଃରେନ୍‌ ହଡ଼କ ୟୀଶୁକେ ନେଲ୍ଉରୁମ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ହଡ଼କ ନେତେହେନ୍ତେକ ନିର୍‌ବାଡ଼ାକେଦା ଆଡଃ ଇନିଃ ଏନ୍ତାଃରିୟା ମେନ୍ତେ ଇନ୍‌କୁ ସାରିକେଦ୍‌ଚି ଦୁକୁହାସୁତାନ୍‌କକେ ପାର୍‌କମ୍‌କରେ ଇନିଃତାଃତେକ ଗଅଃ ଆଉକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଆଡଃ ୟୀଶୁ ସବେନ୍‌ ହାତୁ, ଟଲା, ସାହାର୍‌ତେ ବଲଃତାଇକେନ୍‌ଲଃଗି, ହଡ଼କ ଦୁକୁହାସୁତାନ୍‌କକେ ପିଟ୍‌ ଠାୟାଦ୍‌ତେକ ଆଉକେଦ୍‌କଆ, ଆଡଃ ଲିଜାଃରେୟାଃ ଆଚ୍‌ରାକେ ଜୁଟିଦ୍‌ତାକାକ ମେନ୍ତେ ଇନିଃକେକ ବିନ୍ତି ତାଇକେନା, ଆଡଃ ଜୁଟିଦ୍‌କେଦ୍‍ ସବେନ୍‌କ ବୁଗିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ଚିମିନ୍‌ ଫାରୁଶୀକ ଆଡଃ ଯୀରୁଶାଲେମ୍‌ଏତେ ହିଜୁଃଲେନ୍‌ ଚିମିନ୍‌ ଆଇନ୍‌ ଇତୁକ ୟୀଶୁତାଃରେକ ହୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ଆଡଃ ଇନ୍‌କୁ ୟୀଶୁଆଃ ଚିମିନ୍‌ ଚେଲାକକେ ଯିହୁଦୀକଆଃ ରିତିରିୱାଜ୍‌ ଲେକାତେ ସତ୍‌ରାକେଦ୍‌ତେ କା ଆବୁଙ୍ଗ୍‌ ତିଃଇତେ ଜମ୍‌ତାନ୍‌କ ନେଲ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ଚିୟାଃଚି ଫାରୁଶୀକ ଆଡଃ ସବେନ୍‌ ଯିହୁଦୀକ ପ୍ରାଚିନ୍‌ ହଡ଼କଆଃ ରିତିରିୱାଜ୍‌ ଲେକା ତିଃଇ ବୁଗିଲେକାତେ କା ଆବୁଙ୍ଗ୍‌ ଜାକେଦ୍‌ କାକ ଜଜମାଃ । ");
INSERT INTO unx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ଆଡଃ ପିଟ୍‌ଏତେ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ଦାଆଃ'ତେ ଆଉରି ଆବୁଙ୍ଗ୍‌ ଜାକେଦ୍‌ କାକ ଜଜମାଃ । ଆଡଃ ନେ'ଲେକାନ୍ ରିତିରିୱାଜ୍‌ ମାନାତିଙ୍ଗ୍‌ ତାଇକେନାକ, ତାୱାକ, ଚାଟୁକ, ପାର୍‌କମ୍‌କ, ଆଡଃ ତାମ୍ବାତେ ବାଇୟାକାନ୍ ବାର୍ତାନ୍‌କକେ ଦାଆଃତେ ଆବୁଙ୍ଗ୍‌ ଗାସାର୍ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ଏନାମେନ୍ତେ ଫାରୁଶୀକ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ୟୀଶୁକେ କୁଲିକିୟାକ, “ଚିନାଃମେନ୍ତେ ଆମାଃ ଚେଲାକ ତିଃଇ ବେଗାର୍‌ ଆବୁଙ୍ଗ୍‌କେଦ୍‌ତେ ସତ୍‌ରାଗି ଜଜମ୍‌କ ଦୁବାଃ ଆଡଃ ଆବୁଆଃ ପ୍ରାଚିନ୍‌କଆଃ ରିତିରିୱାଜ୍‌କ କାକ ମାନାତିଙ୍ଗ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ଆପେ ବେଦାହଡ଼କ ତାନ୍‌ପେ, ଯିଶାୟ ଆପେୟାଃ ବିଷାଏରେ ସାର୍‌ତିଗି ଆୟାର୍‌କାଜି କାଜିକାଦା, ନେଆଁଦ ଅଲାକାନା, “ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିକେଦାଏ, ‘ନେ ହଡ଼କ ମଚାତେକ ମାଇନିଙ୍ଗ୍‌ତାନା, ମେନ୍‌ଦ ଆକଆଃ ମନ୍‌ ଆଇଙ୍ଗ୍‌ତାଃଏତେ ସାଙ୍ଗିନ୍‌ରେଆ । ");
INSERT INTO unx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ଆଇଙ୍ଗ୍‌କେ ସାମାଗିକ ସେୱାଇଙ୍ଗ୍‌ୟାଁ; ଆଡଃ ଇନ୍‌କୁଦ ନେୟାଁ ଧାରାମ୍‌ରେୟାଃ କାଜି ତାନାଃ ମେନ୍ତେ ହଡ଼କଆଃ ଆନାଚୁକ ଇତୁକତାନା ।’ ");
INSERT INTO unx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ଆପେ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ଆନ୍‌ଚୁକ ଦୟା କୁଣ୍ଡାମ୍‌କେଦ୍‌ତେ ହଡ଼କଆଃ ରିତିରିୱାଜ୍‌ ମାନାତିଙ୍ଗ୍‌ ତାନାପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ୟୀଶୁ ଆଡଃଗି କାଜିୟାଦ୍‌କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ଆନ୍‌ଚୁକେ କା ମାନାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ଆପେୟାଃ ରିତିରିୱାଜ୍‌କେ ମାନାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଆପେ ଆପେୟାଃ ହରାପେ ନାମାକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ମୁଶା ଆନ୍‌ଚୁରେ କାଜିୟାକାଦାଏ, ‘ଏଙ୍ଗା ଆପୁ କିନ୍‌କେ ମାନାତିଙ୍ଗ୍‌କିନ୍‌ମେ’ ଆଡଃ ‘ଜେତାଏ ଏଙ୍ଗାତେକେ ଚାଏ ଆପୁତେକେ ସାର୍‌ପାଅ ରେଦ ଇନିଃ ଗଜଃକାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ମେନ୍‌ଦ ଆପେ କାଜିତାନାପେ, ଜେତାଏ ଆୟାଃ ଆପୁ ଚାଏ ଏଙ୍ଗାକେ କାଜିୟାକିନାଏ, ଆୟାଃତାଃଏତେ ଅକ୍‌ନାଃ ନାଗେନ୍ତେ ଆମାଃ ବୁଗିନାଃ ନାମେତେୟାଃ ‘କୁର୍ବାନା’ କାନା, ନେଆଁଁରାଃ ମୁଣ୍ଡିଦ ନେୟାଁ ପାର୍‌ମେଶ୍ୱାର୍‌ ନାଗେନ୍ତେ ଦାନ୍‌ ଏମାକାନା, ");
INSERT INTO unx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ଏନ୍ତେଦ ଆପେ ତାୟମ୍‌ତେ ଇନିଃକେ ଆୟାଃ ଏଙ୍ଗା ଚାହେ ଆୟାଃ ଆପୁଆଃ ନାଙ୍ଗ୍‌ ବୁଗିନାଃ ରିକା ନାଗେନ୍ତେ ଆଡଃ ଜେତ୍‌ନାଃ କାପେ ରିକାଚିକାଇତାନା । ");
INSERT INTO unx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଆଡଃ ନେ ଲେକାତେ ଆପେୟାଃ ରିତିରିୱାଜ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ କାଜିପେ ଫାଦାଆତମେତାନା । ଆଡଃ ନେ ଲେକାନ୍ କାମିକ ପୁରାଃପେ କାମିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ଏନ୍ତେ ୟୀଶୁ ଗାଦେଲ୍‌ ହଡ଼କକେ କେଡ଼ାକେଦ୍‌କଆଏ ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଆୟୁମେପେ ଆଡଃ ଆଟ୍‌କାର୍‌ ଉରୁମେପେ । ");
INSERT INTO unx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ହଡ଼ରେ ବାହାରିଏତେ ବଲଃତେୟାଃ ଜେତ୍‌ନାଃ ଇନିଃକେ କାଏ ସତ୍‌ରା ଦାଡ଼ିୟାଇଆ, ମେନ୍‌ଦ ଇନିଃତେ ଅକ୍‌ନାଃ ଅଡଙ୍ଗ୍‌ଅଃଆ ଏନା ଆଇଃକ୍‌କେ ସତ୍‌ରାଇଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଲୁତୁର୍‌ ମେନାଃନିଃ ଆୟୁମ୍‌ଜମେକାଏ । ");
INSERT INTO unx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ଆଡଃ ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କସାଃଏତେ ଫାର୍‌କାକେଦ୍‌ତେ ଅଡ଼ାଃରେ ବଲୟାନ୍‌ଚି, ଚେଲାତାୟାଃକ ଏନ୍‌ ଜନ୍‌କା କାଜିରାଃ ମୁଣ୍ଡିକ କୁଲିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ଇନିଃ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଚିୟାଃ ଆପେୟଗି ଡଣ୍ଡଗିୟାପେ ? ବାହାରିଏତେ ହଡ଼ରେ ବଲଃତେୟାଃ ଇନିଃକେ କାଏ ସତ୍‌ରା ଦାଡ଼ିୟାଇଆ । ");
INSERT INTO unx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ଚିୟାଃଚି ଏନା ମନ୍‌ରେ କାହାଗି, ମେନ୍‌ଦ ଲାହିଦ୍‌ରେ ବଲଃଆ, ଆଡଃ ହଡ଼୍‌ମଏତେ ଅଡଙ୍ଗ୍‌ ଏଣ୍ଡାଗଆଃ, ନେୟାଁ ଚିୟାଃ କାପେ ଆଟ୍‌କାରେତାନା ।” ନେ କାଜିରେ, ସବେନ୍‌ ଜଜମାଃ ଫାର୍‌ଚିଗିୟା ମେନ୍ତେ ୟୀଶୁ ଉଦୁବ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଆଡଃଗି ଇନିଃ ମେତାଦ୍‌କଆଏ, “ଅକ୍‌ନାଃ ହଡ଼ରାଃ ବିଚାର୍‌ଏତେ ଅଡଙ୍ଗ୍‌ଅଃଆ, ଏନା ହଡ଼କେ ସତ୍‌ରାଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ଚିୟାଃଚି ଭିତାର୍‌ଏତେଗି, ହଡ଼କଆଃ ମନ୍‌ଏତେ ଏତ୍‌କାନ୍‌ ଉଡ଼ୁଃ ଅଡଙ୍ଗ୍‌ଅଃତାନା, ଆପାଙ୍ଗିର୍‌ କାମି, କୁମ୍ବୁଡ଼ୁ, ହଡ଼ଗଏଃ, ");
INSERT INTO unx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ଆପାଙ୍ଗିର୍‌, ଲାଲାଚ୍‌, ଏତ୍‌କାନାଃ, ବେଦା, ନିଲାଜ୍‌, ହିସ୍‌ଙ୍ଗା, ନିନ୍ଦା, ଫୁଟାନି ଆଡଃ ବାଲୁସେଣାଁଁ । ");
INSERT INTO unx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ନେ ସବେନ୍‌ ଏତ୍‌କାନ୍‌ କାଜି ମନ୍‌ଏତେ ଅଡଙ୍ଗ୍‌ଅଃତାନା ଆଡଃ ହଡ଼କେ ସତ୍‌ରାଇଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ଏନ୍ତେ ୟୀଶୁ ଏନ୍ତାଃକେ ବାଗିକେଦ୍‌ତେ ସୋର୍‌ ଦିଶୁମ୍‌ରାଃ ଜାପାଃ ହାତୁତେ ସେନଃୟାନାଏ । ଇନିଃ ମିଆଁଦ୍‌ ଅଡ଼ାଃରେ ବଲୟାନାଏ ଆଡଃ ଜେତାଏ ଏନ୍‌ ଅଡ଼ାଃରେ ମେନାଇୟା ଏନା ଆଲକାକ ସାରିକା ମେନ୍ତେ ଇନିଃ ସାନାଙ୍ଗ୍‌କେଦାଏ, ମେନ୍‌ଦ ଇନିଃ କାଏ ଉକୁ ଦାଡ଼ିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ମେନ୍‌ଦ ଇମ୍‌ତାଗି ମିଆଁଦ୍‌ କୁଡ଼ି, ୟୀଶୁ ହିଜୁଃକାନାଏ ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ତେ ହିଜୁଃୟାନାଏ ଆଡଃ ୟୀଶୁଆଃ କାଟାସୁବାରେ ଉୟୁଃୟାନାଏ, ଚିୟାଃଚି ସତ୍‌ରା ଆତ୍ମାଦ ଇନିୟାଃ ହନ୍ତେକୁଡ଼ିକେ ଏସେରାକାଇ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ଇନିଃ ସିରିୟା ଦିଶୁମ୍‌ରାଃ ଫୋନେସିୟାରେନ୍‌ ମିଆଁଦ୍‌ ସାଅଁସାର୍‌ କୁଡ଼ି ତାଇକେନାଏ, ଇନିଃ ହନ୍ତେକୁଡ଼ିଏତେ ବଙ୍ଗାକେ ହାର୍‌ଅଡଙ୍ଗ୍‌ତାଇମେ ମେନ୍ତେ ୟୀଶୁକେ ବିନ୍ତିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ମେନ୍‌ଦ ୟୀଶୁ ମେତାଇୟାଏ, “ସିଦାତେ ହନ୍‌କକେ ଜମ୍‌ ରିକାକମେ, ଚିୟାଃଚି ହନ୍‌କଆଃ ଜମେୟାଃଁ ରେଃକ୍‌କେଦ୍‌ତେ ସେତାକଆଃ ଆୟାର୍‌ରେ ହୁଦ୍‌ମାତେୟାଃ କା ବୁଗିନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ଏନ୍ତେ ଏନ୍‌ କୁଡ଼ି କାଜିକିୟାଏ, “ହେଗି ପ୍ରାଭୁ, ମେନ୍‌ଦ ମେଜ୍‌ ଲାତାର୍‌ରେ ସେତାକହଗି ହନ୍‌କଆଃ ହଲଙ୍ଗ୍‌କେଚାଃକ ଜଜମାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ଏନ୍ତେ ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ନେ କାଜିରେୟାଃ ନାଗେନ୍ତେ ଜୁ, ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ମେଁ, ହନ୍‌ମେଁ କୁଡ଼ିତାଃଏତେ ବଙ୍ଗା ଅଡଙ୍ଗ୍‌ୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ଏନ୍‌ କୁଡ଼ି ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ୟାନ୍ତେ ହନ୍ତେକୁଡ଼ିତାୟାଃକେ ପାର୍‌କମ୍‌ରେ ଗିତିଜାକାନ୍‌ ନେଲ୍‌କିୟାଏ, ଆଡଃ ବଙ୍ଗା ଇନିଃତାଃଏତେ ଅଡଙ୍ଗ୍‌ଆଁକାନ୍‌ ନାମ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ଆଡଃଗି ୟୀଶୁ ସୋର୍‌ ଦିଶୁମ୍‌ଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ଚି, ସିଦୋନ୍‌ ଦିଶୁମ୍‌ରାଃ ଥାଲା ହରା, ଗାଲିଲ୍‌ ଦରେୟା, ଆଡଃ ଦେକାପଲ୍ଲୀ ସିମ୍‌ନାସାଃତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ଚିମିନ୍‌ ହଡ଼କ ମିଆଁଦ୍‌ କା ଆୟୁମ୍‌ ଦାଡ଼ିତାନ୍‌ ହଡ଼ ଆଡଃ କା ବାଖାଁଣ୍‌ ଦାଡ଼ିତାନ୍‌ ହଡ଼କେ ୟୀଶୁତାଃତେ ଆଉକିୟାଃକ, ଆଡଃ ଆମାଃ ତିଃଇ ଇନିଃରେ ଦହେମେ ମେନ୍ତେକ ବିନ୍ତିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଆଡଃ ୟୀଶୁ ଇନିଃକେ ଗାଦେଲ୍‌ ହଡ଼କ ଥାଲାଏତେ ଗେନାତେ ଏସ୍‌କାର୍‌ଗି ଇଦିକିୟାଏ, ଆଡଃ ଆୟାଃ ସାର୍‌ସାର୍‌ ଇନିୟାଃ ଲୁତୁର୍‌ରେ ଦହକେଦାଏ, ଆଡଃ ବେଏକ୍‌କେଦ୍‌ତେ ଇନିୟାଃ ଆଲାଙ୍ଗ୍‌କେ ଜୁଟିଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ଆଡଃ ସିର୍ମାସାଃତେ ସାଙ୍ଗିଲ୍‌କେଦ୍‌ତେ, ମାରାଙ୍ଗ୍‌ସାହେଁଦ୍‌ଲଃ ମେନ୍‌କେଦାଏ “ଏଫ୍‌ଫାଥାଃ” ନେଆଁଁରାଃ ମୁଣ୍ଡିଦ “ନିଜଃମେଁ” । ");
INSERT INTO unx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ଇମ୍‌ତାଗି ଇନିୟାଃ ଲୁତୁର୍‌ଦ ନିଜ୍‌ୟାନା ଆଡଃ ଆଲାଙ୍ଗ୍‌ରେୟାଃ ତନଲ୍‌ ରାଡ଼ାୟାନା, ଆଡଃ ଇନିଃ ବୁଗିଲେକାତେ ବାଖାଁଣ୍‌ ଦାଡ଼ିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଏନ୍ତେ ୟୀଶୁ ଜେତାଏକକେ ନେ କାଜି କା ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, ମେନ୍‌ଦ ଇନିଃ ହଡ଼କକେ ପୁରାଃଗି କାଜିକେଦ୍‌କରେହ ଇନ୍‌କୁ ଆଡଃଗି ପୁରାଃତେକ ଉଦୁବ୍‌ବାଡ଼ାକେଦା । ");
INSERT INTO unx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ଆଡଃ ଏନା ଆୟୁମ୍‌କେଦ୍‌ ହଡ଼କ ପୁରାଃଗିକ ଆକ୍‌ଦାନ୍ଦାଅୟାନା, ଆଡଃ କାଜିକେଦାଃକ, “ଇନିଃଦ ସବେନାଃ ବୁଗିଲେକାତେ କାମିୟାକାଦାଏ, କା ଆୟୁମ୍‌ଦାଡ଼ିତାନ୍‌କକେ ଇନିଃ ଆୟୁମ୍‌ ରିକାକେଦ୍‌କଆଏ, ଆଡଃ କା ବାଖାଁଣ୍‌ଦାଡ଼ିତାନ୍‌କକେ ବାଖାଁଣ୍‌ ନାଗେନ୍ତେ ପେଡ଼େଃ ଏମାକୁତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ଏନ୍‌ ଦିପିଲିରେ ଆଡଃଗି ଗାଦେଲ୍‌ ହଡ଼କ ହୁଣ୍ଡିୟାନା, ଆଡଃ ଜଜମାଃକ ବାନଃ ହରାତେ, ୟୀଶୁ ଚେଲାକକେ ଆୟାଃତାଃତେ ହାକାଅକେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ନେ ଗାଦେଲ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ଆଇଁୟାଃ ଜୀଉ ବିଲ୍‌କାଅଃତାନା, ଚିୟାଃଚି ଆପି ମାହାଁଏତେ ଆଇଁୟାଃଲଃ ମେନାକଆ, ଆଡଃ ନାହାଁଃ ଇନ୍‌କୁତାଃରେ ଜମେୟାଃଁ ଜେତ୍‌ନାଃ ବାନଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ଇନ୍‌କୁକେ ସାମାଲାହିଦ୍ ଅଡ଼ାଃତେଇଙ୍ଗ୍‌ କୁଲ୍‌ତାକୁରେ ହରାକରେ ଲାଗାଉତାରଃଆକ, ଚିୟାଃଚି ଇନ୍‌କୁଏତେ ଚିମିନ୍‌କ ସାଙ୍ଗିନ୍‌କଏତେ ହିଜୁଆକାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ଇନିୟାଃ ଚେଲାକ କାଜିରୁହାଡ଼୍‌କିୟା, “ଅକଏ ନେ ସିଃସଏଃ ଠାୟାଦ୍‌ରେ ନିମିନାଙ୍ଗ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ବିୟଃଗି ଜମେୟାଃଁ ଏମ୍‌ଦାଡ଼ିୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ୟୀଶୁ କୁଲିକେଦ୍‌କଆଏ, “ଆପେତାଃରେ ଚିମିନାଙ୍ଗ୍‌ ହଲଙ୍ଗ୍‌ ମେନା ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟା, “ସାତ୍‌ଠୁ ହଲଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ଇନିଃ ସବେନ୍‌ ହଡ଼କକେ ଅତେରେ ଦୁବ୍‌ପେ ମେତାଦ୍‌କଆଏ । ଏନ୍ତେ ଏନ୍‌ ସାତ୍‌ଠୁ ହଲଙ୍ଗ୍‌ ଇଦିକେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌କିୟାଏ, ଆଡଃ ଏନା କେଚାଃକେଦ୍‌ତେ ହଡ଼କକେ ହାଟିଙ୍ଗ୍‌ଆଁକ ନାଗେନ୍ତେ ଚେଲାତାୟାଃକକେ ଏମାଦ୍‌କଆଏ, ଆଡଃ ଇନ୍‌କୁକେ ହାଟିଙ୍ଗ୍‌ଆଁଁଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ଇନ୍‌କୁତାଃରେ ହୁଡିଙ୍ଗ୍‌ଲେକା ହୁପ୍‌ଡିଙ୍ଗ୍‌ ହାକୁ ତାଇକେନାକ, ଏନ୍‌ ହାକୁ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌କିୟାଏ, ଆଡଃ ଏନାକେ ହାଟିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଚେଲାକକେ କାଜିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ଏନା ଜମ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ ବି'ୟାନାକ, ଆଡଃ ସାରେଜାକାନ୍ କେଚାଃତେୟାଃକ ସାତ୍‌ ଟୁଙ୍କି ହାଲାଙ୍ଗ୍‌କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ଏନ୍ତାଃରେ ଉପୁନ୍‌ ହାଜାର୍‌ ଲେକା ହଡ଼କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ବିଦାକେଦ୍‌କଚି, ଇମ୍‌ତାଗି ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ଲାଉକାରେ ଦେଏଃୟାନାଏ, ଆଡଃ ଦାଲ୍‌ମାନୁଥା ସିମ୍‌ନାତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ଆଡଃ ଫାରୁଶୀକ ହିଜୁଃକେଦ୍‌ତେ ୟୀଶୁଲଃ ଏପ୍‌ରାଙ୍ଗ୍‌ଜାଗାର୍‌ ତାନ୍‌ଲଃ, ଇନିଃକେ ବିଡ଼ାଅ ନାଗେନ୍ତେ ଇନିଃ ସିର୍ମାଏତେ ହିଜୁଆକାନାଏ, ନେଆଁଁ ଉଦୁବ୍‌ ନାଗେନ୍ତେ ସିର୍ମାଏତେ ମିଆଁଦ୍‌ ଚିହ୍ନାଁକ ଆସିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ୟୀଶୁ ଜୀଉରେ ମାରାଙ୍ଗ୍‌ ସାହେଁଦ୍‌କେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, “ଚିନାଃମେନ୍ତେ ନେ ପାରିୟାରେନ୍‌ ହଡ଼କ ପେଡ଼େଃରାଃ କାମିକ ରିକା ନାଗେନ୍ତେ କୁଲିତାନା ? ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ନେ ପାରିୟାରେନ୍‌ ହଡ଼କଆଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ଚିହ୍ନାଁହ କା ଏମଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ଇନିଃ ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌ତେ, ଲାଉକାରେ ଦେଏଃରୁହାଡ଼୍‌ୟାନାଏ ଆଡଃ ଦରେୟା ହାନ୍‌ସାଃ ପାରମ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ୟୀଶୁଆଃ ଚେଲାକ ହଲଙ୍ଗ୍‌ ଇଦି ନାଙ୍ଗ୍‌କ ରିଡ଼ିଙ୍ଗ୍‌କେଦା ଆଡଃ ଲାଉକାରେ ମିଆଁଦ୍‌ଗି ହଲଙ୍ଗ୍‌ ଆକତାଃରେ ତାଇକେନା, ");
INSERT INTO unx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ୟୀଶୁ କେଟେୟାନ୍‌ଗି କାଜିୟାଦ୍‌କଆଏ, “ନେଲେପେ, ଫାରୁଶୀକଆଃ ଆଡଃ ହେରୋଦ୍‌ଆଃ ହସଡ଼ ଇନିତୁ, ଅକଆଃଚି ରାନୁ ଲେକାଃ ଏନାଏତେ ଚିର୍ଗାଲାକାନ୍‌ ତାଇନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ଇନ୍‌କୁଦ ଆକ ଆକରେକ ମେନ୍‌କେଦା, “ଆବୁତାଃରେ ହଲଙ୍ଗ୍‌କ ବାନଆଃ ଏନାମେନ୍ତେ ଇନିଃ ଆବୁକେ କାଜିୟାବୁତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ୟୀଶୁ ଇନ୍‌କୁଆଃ ଜୀଉରାଃ କାଜି ସାରିକେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ଆପେତାଃରେ ହଲଙ୍ଗ୍‌ ବାନଃ ମେନ୍ତେ ଚିକାନାଙ୍ଗ୍‌ ଆପେଗି ଉଡ଼ୁଃତାନା ? ନାହାଁଃ ଜାକେଦ୍‌ କାପେଚି ସାରିକାଦା ଆଡଃ ଆଟ୍‌କାର୍‌ଉରୁମାକାଦା ? ଆପେୟାଃ ମନ୍‌ ନାହାଁଃ ଜାକେଦ୍‌ଚି କେଟେଦ୍‌ଗିୟା ? ");
INSERT INTO unx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ମେଦ୍‌ ମେନାଃତେହ କା ଚିପେ ନେଲେତାନା ? ଆଡଃ ଲୁତୁର୍‌ ମେନାଃତେହ କା ଚିପେ ଆୟୁମେତାନା ? ଆଡଃ କା ଚିପେ ପାହାମେତାନା ? ");
INSERT INTO unx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ମଣେୟାଁ ହଲଙ୍ଗ୍‌କେ କେଚାଃକେଦ୍‌ତେ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ହଡ଼କକେ ହାଟିଙ୍ଗ୍‌ଆଁଁଦ୍‌କଆ, ଜମ୍‌ ସାରେଜ୍‌କେଚାଃ ଚିମିନ୍‌ ଟୁଙ୍କିପେ ହାଲାଙ୍ଗ୍‌କେଦାଃ ?” ଚେଲାକ କାଜିକିୟାଃ, “ବାରା ଟୁଙ୍କି ।” ");
INSERT INTO unx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ଆଡଃ ଆଇଙ୍ଗ୍‌ “ଉପୁନ୍‌ ହାଜାର୍‌ ହଡ଼କ ନାଗେନ୍ତେ ସାତ୍‌ଠୁ ହଲଙ୍ଗ୍‌ କେଚାଃକେଦ୍‌ ଇମ୍‌ତାଙ୍ଗ୍‌, ସାରେଜାକାନ୍ କେଚାଃତେୟାଃ ଚିମିନ୍‌ ଟୁଙ୍କିପେ ହାଲାଙ୍ଗ୍‌କେଦାଃ ?” ଇନ୍‌କୁଦ କାଜିକିୟାଃ “ସାତ୍‌ ଟୁଙ୍କିଲେ ହାଲାଙ୍ଗ୍‌କେଦା ।” ");
INSERT INTO unx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ନାହାଁଃ ଜାକେଦ୍‌ ଚି କାପେ ଆଟ୍‌କାର୍‌ ଉରୁମେତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ଏନ୍ତେ ଇନ୍‌କୁ ବେଥ୍‌ସାଇଦା ତେବାଃୟାନାକ, ଆଡଃ ହଡ଼କ ମିଆଁଦ୍‌ କାଏ ନେଲ୍‌ ଦାଡ଼ିତାନ୍‌ ହଡ଼କେ ୟୀଶୁତାଃତେକ ଆଉକିୟା ଆଡଃ ଇନିଃକେ ଜୁଟିଦ୍‌କେଦ୍‌ତେ ବୁଗିମେ ମେନ୍ତେକ ବିନ୍ତିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ୟୀଶୁ, ଏନ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିତାନ୍‌ ହଡ଼ରାଃ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ ହାତୁଏତେ ଅଡଙ୍ଗ୍‌କିୟା । ଇନିୟାଃ ମେଦ୍‌ରେ ବେଏକ୍‌କିୟାଏ ଆଡଃ ଆୟାଃ ତିଃଇ ଇନିଃରେ ଦହକେଦ୍‌ତେ କୁଲିକିୟାଏ, “ଚିୟାଃ ଆମ୍‌ ଜେତ୍‌ନାଃମ୍‌ ନେଲେତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ଏନ୍‌ ହଡ଼ଦ ଆରିଦ୍‌କେଦାଏ ଆଡଃ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ହଡ଼କକେ ସେନ୍‌ବାଡ଼ାତାନ୍‌ ଦାରୁଲେକାଇଙ୍ଗ୍‌ ନେଲ୍‌କତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ୟୀଶୁ ଆଡଃମିସା ଇନିୟାଃ ମେଦ୍‌କେ ଜୁଟିଦ୍‌କେଦାଏ, ଏନ୍ତେ ଇନିଃ ନେଲ୍‌ ଦାଡ଼ିକେନାଏ, ଇନିଃ ବୁଗିୟାନାଏ ଆଡଃ ସବେନାଃ ଫାର୍‌ଚିଗି ନେଲ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ୟୀଶୁ ଇନିଃକେ ଅଡ଼ାଃତେ କୁଲ୍‌ ରୁହାଡ଼ିତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ନେ ହାତୁତେ ଆଲମ୍‌ ସେନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ କାଇସରିୟା ଫିଲିପି ଦିଶୁମ୍‌ରାଃ ହାତୁକ ସେନଃତାନ୍‌ ଇମ୍‌ତା ଚେଲାକକେ କୁଲିକେଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ଅକଏ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେ ହଡ଼କ କାଜିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଚିମିନ୍‌କ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌, ଚିମିନ୍‌କ ଏଲିୟ ମେନ୍‌ଦ ଚିମିନ୍‌କ ନାବୀକଏତେ ମିହୁଡ଼୍‌ ତାନିଃ ମେନ୍ତେକ କାଜିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ୟୀଶୁ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ଅକଏ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେପେ କାଜିତାନା ?” ପାତ୍‌ରାସ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆମ୍‌ଗି ଖ୍ରୀଷ୍ଟ୍‌, ତାନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ ହୁକୁମ୍‌କେଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ଅକଏ ତାନିଙ୍ଗ୍‌ ନେ କାଜି ଜେତାଏତାଃରେ ଆଲ୍‌ପେ ଉଦୁବେୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ଇତୁ ଏଟେଦ୍‌କେଦ୍‌ଆଏ, “ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌କେ ପୁରାଃ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ ଲାଗାତିୟାଃଁ, ଆଡଃ ପ୍ରାଚିନ୍‌କ, ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଆଇଙ୍ଗ୍‌କେ ହିଲାଙ୍ଗ୍‌ଇଁୟା ଆଡଃ ଗଜିୟାଁ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପି ମାହାଁ ତାୟମ୍‌ତେ ଜୀଉ ବିରିଦାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ଆଡଃ ଇନିଃ ନେ ବିଷାଏ ଫାର୍‌ଚିଆନ୍‌ଗି ଇନ୍‌କୁକେ ଉଦୁବାଦ୍‌କଆ । ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ୟୀଶୁକେ ଗେନାତେ ଇଦିକିଃତେ ଏଗେର୍‌ଏଟେଦ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ମେନ୍‌ଦ ୟୀଶୁ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ଆୟାଃ ଚେଲାକସାଃ ଆରିଦ୍‌କେଦ୍‌ତେ, ପାତ୍‌ରାସ୍‌କେ ଏଗେର୍‌କିୟା, “ଏ ସାଏତାନ୍‌ ଆଇଁୟାଃତାଃଏତେ ଆତମେନ୍‌ମେ ଆମ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଲେକା କାହା ମେନ୍‌ଦ ହଡ଼କଆଃ ଲେକାମ୍ ଉଡ଼ୁଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ଏନ୍ତେ, ଗାଦେଲ୍‌ ହଡ଼କକେ ଆଡଃ ଚେଲାକକେ, ୟୀଶୁ କେଡ଼ାକେଦ୍‌କଆଏ ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଜେତାଏ ହଡ଼ ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଇନିଃ ଆଇଃକ୍‌ ଆପାନ୍‌କେ ହିଲାଙ୍ଗ୍‌ଇକାଏ, ଆଡଃ ଆୟାଃ କ୍ରୁଶ୍‌ ଗଅଃକେଦ୍‌ତେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌କାଏ । ");
INSERT INTO unx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ଚିୟାଃଚି ଆୟାଃ ଜୀଉ ବାଞ୍ଚାଅ ସାନାଙ୍ଗ୍‌ତାନ୍‌ନିଃ ଏନାଏ ଆଦେୟା, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ମେନ୍ତେ ଆଡଃ ସୁକୁକାଜି ମେନ୍ତେ ଆୟାଃ ଜୀଉ ଆଦେନିଃ, ଏନାଏ ବାଞ୍ଚାଏୟା । ");
INSERT INTO unx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ଜେତାଏ ହଡ଼ ଗଟା ଅତେଦିଶୁମ୍‌ ନାମ୍‌କେଦ୍‌ରେୟ ଆୟାଃ ଜୀଉକେ ଆଦେରେଦ ଇନିୟାଃ ଚିକାନ୍‌ ଫାଏଦା ହବାଅଆଃ ? ");
INSERT INTO unx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ଚାଏ ଜେତାଏ ହଡ଼ ଆୟାଃ ଜୀଉ ନାମ୍‌ରୁହାଡ଼େ ନାଗେନ୍ତେ ଚିନାଃଏ ଏମ୍‌ ଦାଡ଼ିୟା ? ");
INSERT INTO unx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ନେ ପାରିୟାରେନ୍‌ ଆପାଙ୍ଗିର୍‌ ଆଡଃ ପାପିହଡ଼କଆଃ ଥାଲାରେ ଆଇଙ୍ଗ୍‌ ଆଡଃ ଆଇଁୟାଃ କାଜି ବିଷାଏରେ ଅକଏ ଗିହୁଗଃଆଏ, ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ପାବିତାର୍‌ ଦୁଁତ୍‌କଲଃ ଆପୁଇଁୟାଃ ମାନାରାଙ୍ଗ୍‌ରେ ହିଜୁଃରୁହାଡ଼୍‌ ଦିପିଲିରେ ଆଇଙ୍ଗ୍‌ହଗି ଏନ୍‌ ବିଷାଏରେ ଗିହୁଗଃଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ଆଡଃ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ପେଡ଼େଃଲଃ ହିଜୁଃତାନ୍‌ ଆଉରି ନେଲେ ଜାକେଦ୍, ନେତାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ କଏତେ ଚିମିନ୍‌କ ଗନଏଃ କାକ ଚାଖାଅୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ତୁରୁଇ ମାଃ ତାୟମ୍‌ତେ ୟୀଶୁ ପାତ୍‌ରାସ୍‌, ଯାକୁବ୍‌ ଆଡଃ ଯୋହାନ୍‌କେ ମିଆଁଦ୍‌ ସାଲାଙ୍ଗି ବୁରୁ ଚେତାନ୍ ଇଦିକେଦ୍‌କଆଏ ଆଡଃ ଇନ୍‌କୁ ଏନ୍ତାଃରେ ଏସ୍‌କାର୍‌ଗି ତାଇକେନାକ, ଆଡଃ ଇନ୍‌କୁଆଃ ନେପେଲ୍‌ରେ ୟୀଶୁଆଃ ରୁପ୍‌ ବାଦ୍‌ଲାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ଜେତାଏ ଧୋବି କାଏ ପୁଣ୍ଡି ଦାଡ଼ିଲେକା, ଲିଜାଃକ ତାୟାଃଦ ଝାକ୍‌ ମାକ୍‌ ପୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ଏନ୍ତେ ମୁଶା ଆଡଃ ଏଲିୟକେ, ୟୀଶୁଲଃ ଜାଗାର୍‌ତାନ୍‌ ନେଲ୍‌କେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ପାତ୍‌ରାସ୍‌ଦ ୟୀଶୁକେ ମେତାଇୟାଏ, “ହେ ଗୁରୁ, ଆବୁ ନାଙ୍ଗ୍‌ ନେତାଃରେଗି ତାଇନଃ ପୁରାଃ ବୁଗିନାଃ, ଆପିୟା କୁମ୍ବାବୁ ବାଇୟାଃ, ମିଆଁଦ୍‌ ଆମାଃ ନାଗେନ୍ତେ, ମିଆଁଦ୍‌ ମୁଶା ନାଗେନ୍ତେ ଆଡଃ ମିଆଁଦ୍‌ ଏଲିୟ ନାଗେନ୍ତେ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ପାତ୍‌ରାସ୍‌ ଚିକ୍‌ନାଃଏ କାଜିରୁହାଡ଼େୟା ଏନା କାଏ ଉଡ଼ୁଃ ଦାଡ଼ିକେଦା, ଚିୟାଃଚି ଇନ୍‌କୁଦ ପୁରାଃଗି ବରକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଏନ୍ତେ ମିଆଁଦ୍‌ ରିମିଲ୍‌ ହିଜୁଃକେଦ୍‌ତେ ଇନ୍‌କୁକେ ଉମ୍ବୁଲ୍‌ କେଦ୍‌କଆଏ, ଆଡଃ ଏନ୍‌ ରିମିଲ୍ଏତେ ମିଆଁଦ୍‌ କାଜି ଆୟୁମ୍‌ୟାନା “ନିଃଗି ଆଇଁୟାଃ ଦୁଲାଡ଼୍‌ ହନ୍‌ତାନିଃ, ଅକଏକେଚି ଆଇଙ୍ଗ୍‌ ଦୁଲାଡ଼ାଃଇଙ୍ଗ୍‌, ନିୟାଃ କାଜି ଆୟୁମେପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ଇନ୍‌କୁ ଇମ୍‌ତାଗି ଆରିଦ୍‌ ବିୟୁର୍‌କେଦାକ, ଆଡଃ ଆକଲଃ ୟୀଶୁକେ ବାଗିକେଦ୍‌ତେ ଜେତାଏକେ କାକ ନେଲ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ବୁରୁଏତେକ ଆଡ଼୍‌ଗୁନ୍‌ତାନ୍‌ରେ ୟୀଶୁ ଇନ୍‌କୁକେ ଚେତାଅକେଦ୍‌କଆ, “ଆପେ ନେଲାକାଦ୍‌ତେଆଃ, ମାନୱାହନ୍‌ ଗଜାକାନ୍‌କଏତେ ଆଉରି ଜୀଉବିରିଦେନ୍ ଜାକେଦ୍‌, ଜେତାଏକେ ଆଲ୍‌ପେ ଉଦୁବାକଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ଇନ୍‌କୁଦ ଇନିୟାଃ କାଜିକ ଆୟୁମ୍‌କେଦ୍‌ତେ “ଗଏଃକାନ୍‌ କଏତେ ଜୀଉବିରିଦେନ୍ କାଜିରାଃ ମୁଣ୍ତି ଚିକ୍‌ନାଃ ତାନାଃ ?” ମେନ୍ତେ ଆକ ଆକରେକ କୁଲିୟଃତାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ଆଡଃ ଇନ୍‌କୁ ୟୀଶୁକେ କୁଲିକିୟାଃକ, “ଚିନାଃ ମେନ୍ତେ ଆଇନ୍‌ ଇତୁକ ଏଲିୟକେ ସିଦାତେ ହିଜୁଃଲାଗାତିୟାଃଁ ମେନ୍ତେକ କାଜିୟାଃ ?” ");
INSERT INTO unx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ଇନିଃ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ନେଆଁଁ ସାର୍‌ତିଗି ତାନାଃ, ଏଲିୟ ଆୟୁର୍‌ତେ ହିଜୁଃଗିୟାଏ, ଆଡଃ ସବେନାଃ ଆଡଃମିସା ବାଇରୁହାଡ଼େୟାଏ । ମାନୱାହନ୍‌କେ ପୁରାଃ ଦୁକୁସାହାତିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଆଡଃ ହିଲାଙ୍ଗ୍‌ଇଆକ, ନେୟାଁ ଚିନାଃ ମେନ୍ତେତାମ୍‌ ଆୟାଃ ବିଷାଏରେ ଅଲାକାନା ? ");
INSERT INTO unx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ଆଇଙ୍ଗ୍‌ଦଇଙ୍ଗ୍‌ କାଜିପେତାନା, ଏଲିୟ ହିଜୁଃୟାନାଏ, ଆଡଃ ପାବିତାର୍‌ ଅନଲ୍‌କ ଇନିୟାଃ ବିଷାଏରେ ଅଲାକାଦ୍‌ ଲେକା, ହଡ଼କ ଆକଆଃ ସାନାଙ୍ଗ୍‌ ଲେକା ଇନିଃକେ ରିକାକିୟାଃକ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ଆଡଃ ଇନ୍‌କୁ ଏଟାଃ ଚେଲାକତାଃକ ରୁହାଡ଼୍‌ୟାନ୍‌ଚି, ଗାଦେଲ୍‌ ହଡ଼କ ଇନ୍‌କୁଆଃ ବିୟୁର୍‌ତେ ହୁଣ୍ଡିଆକାନ୍‌ ଆଡଃ ଆଇନ୍‌ ଇତୁକଲଃ କାପାଜିତାନ୍‌କ ନେଲ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ୟୀଶୁକେ ନେଲ୍‌ତାଇଲଃଗି ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନା ଆଡଃ ନିର୍‌ ଦାରମ୍‌କେଦ୍‌ତେକ ଜହାର୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ୟୀଶୁ, ଆୟାଃ ଚେଲାକକେ କୁଲିକେଦ୍‌କଆଏ, “ଆଇନ୍‌ ଇତୁକଲଃ ଚିନାଃପେ କାପାଜିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ଗାଦେଲ୍‌ ହଡ଼କଏତେ ମିଆଁଦ୍‌ନିଃ ମେତାଇୟାଏ, “ଏ ଇତୁନିଃ, ହନିଙ୍ଗ୍‌କଡ଼ାକେ ଆମାଃତାଃ ଆଉକିୟାଇଙ୍ଗ୍‌, ଚିୟାଃଚି ଇନିଃରେ ମିଆଁଦ୍‌ ବଙ୍ଗା ବଲକାନାଏ ମେନ୍ତେ ଇନିଃ କାଏ ବାଖାଁଣ୍‌ ଦାଡ଼ିତାନା । ");
INSERT INTO unx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ଜେତାଏ ଠାୟାଦ୍‌ରେ ସାବ୍‌କିଦ୍‌ତେ ଇନିଃକେ ଥାୱାଃବାଟିୟାଏ, ଆଡଃ ଇନିୟାଃ ମଚା ପୁତୁରିଦଃଆ, ଇନିଃ ଡାଟାଏ ତାଗଏଃରିଦେୟା ଆଡଃ ଗଜାକାନ୍‌ ଲେକାଏ ରିକାଅଃଆ । ଆଇଙ୍ଗ୍‌ ଆମାଃ ଚେଲାକକେ ଅଡଙ୍ଗ୍‌ହାର୍‌ତାଇପେ ମେନ୍‌କେଦ୍‌କଆଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଇନ୍‌କୁ କାକ ଦାଡ଼ିକେନା ।” ");
INSERT INTO unx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଏ କା ବିଶ୍ୱାସ୍‌ତାନ୍‌ ହଡ଼କ, ଚିମିନ୍‌ ଜାକେଦ୍‌ ଆପେଲଃ ତାଇନାଇଙ୍ଗ୍‌ ? ଚିମିନ୍‌ ଜାକେଦ୍‌ ଆଇଙ୍ଗ୍‌ ସାହାତିଙ୍ଗ୍‌ପେଆ ? ମାର୍‌ ଏନ୍‌ ସିଟିଆକେ ଆଇଙ୍ଗ୍‌ତାଃତେ ଆଉୱିପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ଏନ୍ତେ ଇନ୍‌କୁ ସିଟିଆକେ ଆୟାଃତାଃକ ଆଉକିୟା । ଏତ୍‌କାନ୍‌ ଆତ୍ମାଦ ୟୀଶୁକେ ନେଲ୍‌ତାଇଚି ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଏନ୍‌ ହନ୍‌କେ ଆଇଁଠାଅକିୟାଏ ଆଡଃ ହନ୍‌ ଅତେରେ ଉୟୁଃକେଦ୍‌ତେ ବାଟିବାଡ଼ାୟାନାଏ ଆଡଃ ଇନିୟାଃ ମଚା ପୁତିରିଦଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ୟୀଶୁ ଏନ୍‌ ହନ୍‌ରାଃ ଆପୁତେକେ କୁଲିକିୟାଏ, “ଚିମିନ୍‌ ମାହାଁଏତେ ନେକାଅଃତାନାଏ ?” ଆପୁତେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ମିଦ୍‌ ସିଟିଆଏତେଗି ।” ");
INSERT INTO unx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ଗଜି ନାଗେନ୍ତେ ଏତ୍‌କାନ୍‌ ଆତ୍ମା ଇନିଃକେ ପୁରାଃସା ଦାଆଃରେ ଆଡଃ ସେଙ୍ଗେଲ୍‌ରେ ଇଲିଙ୍ଗ୍‌ଉୟୁଃକାଇ ତାଇକେନା । ଏନାମେନ୍ତେ ଜେତ୍‌ନାଃମ୍‌ ରିକାଦାଡ଼ିରେଦ ଦାୟାକେଦ୍‌ତେ ଆମ୍‌ ଦେଙ୍ଗାଲେମ୍ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ୟୀଶୁଦ “ହେ” ମେନ୍‌ତାନ୍‌ଲଃ, କାଜିକେଦାଏ, “ଚିନାଃମେନ୍ତେ ରିକାଦାଡ଼ିରେଦ ମେନେତାନାମ୍‌, ବିଶ୍ୱାସ୍‌ତାନ୍‌ନିଃ ନାଗେନ୍ତେ ସବେନାଃ ରିକାଦାଡ଼ିୟଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ଏନ୍‌ ତର୍‌ସାଗି ଏନ୍‌ ହନ୍‌ରାଃ ଆପୁତେ ରାଆଃତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ ତାନାଇଙ୍ଗ୍‌, ଆଇଁୟାଃ କା ବିଶ୍ୱାସ୍‌ରେ ଦେଙ୍ଗାଇଙ୍ଗ୍‌ମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ହଡ଼କକେ ଜୁରୁ ହୁଣ୍ଡିନ୍‌ତାନ୍ ୟୀଶୁ ନେଲ୍‌କେଦ୍‌କଚି, ସତ୍‌ରା ଆତ୍ମାକେ ମାରାଙ୍ଗ୍‌ମଚାକିୟାଏ ଆଡଃ ମେତାଇୟାଏ, “ଏ ଭାଏଁରା ଆଡଃ କା ବାଖାଁଣ୍‌ ଦାଡ଼ିତାନ୍‌ ଆତ୍ମା, ଆଇଙ୍ଗ୍‌ ହୁକୁମ୍ ଏମାମ୍‌ତାନାଇଙ୍ଗ୍‌, ନିଃଏତେ ଅଡଙ୍ଗ୍‌ଅଃମେ, ଆଡଃ ନିଃଇରେ ଚିଉଲାଅ ଆଲମ୍‌ ବଲ ରୁହାଡ଼ାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ଏତ୍‌କାନ୍‌ ଆତ୍ମା କାଉରିକେଦ୍‌ତେ ଏନ୍‌ ହନ୍‌କେ ସିଦୁବ୍‌କିୟା ଆଡଃ ଅଡଙ୍ଗ୍‌ ବାଗିତାଇୟାଏ । ସିଟିଆ କଡ଼ାଦ ଗଜାକାନ୍‌ନିଃ ଲେକାଏ ରିକାୟାନା; ହଡ଼କ ମେନ୍‌କେଦାଃ, “ଗଏଃୟାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ମେନ୍‌ଦ ୟୀଶୁ ତିଃଇ ସାବ୍‌କିତେ ବିରିଦ୍‌କିୟାଏ, ଆଡଃ ଇନିଃ ତିଙ୍ଗୁକେଟେଦ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଏନ୍ତେ ୟୀଶୁ ଅଡ଼ାଃତେ ସେନଃୟାନାଏ, ଆଡଃ ଏସ୍‌କାର୍‌ରେ ଚେଲାକତାୟାଃ ଇନିଃକେ କୁଲିକିୟାଃକ, “ଆଲେଦ ଚିନାଃମେନ୍ତେ ଏନ୍‌ ବଙ୍ଗାକେ କାଲେ ଅଡଙ୍ଗ୍‌ ଦାଡ଼ିକେନା ?” ");
INSERT INTO unx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ୟୀଶୁ ମେତାଦ୍‌କଆଏ “ନେ ଲେକାନ୍ ଏତ୍‌କାନ୍‌ ଆତ୍ମାକ ବିନ୍ତିତେ ଏସ୍‌କାର୍‌କ ଅଡଙ୍ଗ୍‌ ଦାଡ଼ିୟଃଆ, ଆଡଃ ଜେତାଲେକାତେଦ କାହାଗି ।” ");
INSERT INTO unx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ୟୀଶୁ ଆଡଃ ଚେଲାକତାୟାଃ ଏନ୍ତାଃଏତେ ସେନଃୟାନ୍‌ଚି ଗାଲିଲ୍‌ ଦିଶୁମ୍‌ ଥାଲା ଥାଲାତେକ ସେନଃୟାନା । ଜେତାଏ ଏନା ଆଲକାକ ସାରିନାମେକା ମେନ୍ତେ ଇନିଃ ସାନାଙ୍ଗ୍‌ତାଇକେନାଏ, ");
INSERT INTO unx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ଚିୟାଃଚି ଇନିଃଦ ଆୟାଃ ଚେଲାକକେ ଇତୁକ ତାଇକେନାଏ । ଇନିଃ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ହଡ଼କଆଃ ତିଃଇରେ ଏମ୍‌ଏଣ୍ଡାଗଃଆଇଙ୍ଗ୍‌, ଆଡଃ ହଡ଼କ ଆଇଙ୍ଗ୍‌କେ ଗଜିୟାଁକ, ଗନଏଃରାଃ ଆପିମା ତାୟମ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଜୀଉ ବିରିଦାଃଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ମେନ୍‌ଦ ଇନ୍‌କୁ ନେ କାଜି କାକ ଆଟ୍‌କାର୍‌ ଉରୁମ୍‌ ଦାଡ଼ିକେଦା, ଆଡଃ ଇନ୍‌କୁଦ ଇନିଃକେ କୁଲି ନାଗେନ୍ତେ ବରକେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ କପର୍‌ନାହୁମ୍‌ ତେବାଃକେଦ୍‌ଚି ଅଡ଼ାଃରେକ ବଲୟାନା, ଆଡଃ ଇନିଃ ଚେଲାକକେ କୁଲିକେଦ୍‌କଆଏ, “ହରାରେ ଚିନାଃପେ ଜାଗାର୍‌ତାନ୍‌ ତାଇକେନା ?” ");
INSERT INTO unx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ମେନ୍‌ଦ ଇନ୍‌କୁ ହାପାୟାନାକ, ଚିୟାଃଚି ଇନ୍‌କୁ ଅକଏ ମାରାଙ୍ଗ୍‌ଆଁ ମେନ୍ତେ ହରାରେକ କାପାଜିତାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ୟୀଶୁ ଦୁବ୍‌ୟାନ୍‌ଚି ବାରାଝାନ୍‌କକେ ହାକାଅକେଦ୍‌କଆଏ ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଅକନ୍‌ ହଡ଼ ସବେନ୍‌କଏତେ ମାରାଙ୍ଗ୍‌ୟେଁନ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ, ସବେନ୍‌କଏତେ ଲାତାରେନ୍‌କାଏ ଆଡଃ ସବେନ୍‌କଆଃ ଦାସିନ୍ କାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ଏନ୍ତେ ମିଆଁଦ୍‌ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କେ ହାକାଅକିଃତେ ଇନ୍‌କୁଆଃ ଥାଲାରେ ତିଙ୍ଗୁକିୟାଏ ଆଡଃ କୟଙ୍ଗ୍‌କିଃତେ ମେତାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ନେ ଲେକାନ୍ ମିଆଁଦ୍‌ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କେ ଅକନ୍‌ ହଡ଼ “ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ସୁକୁଆଇୟାଏ ଇନିଃଦ ଆଇଙ୍ଗ୍‌କେ ସୁକୁଆୟାଁଏ, ଆଡଃ ଅକନ୍‌ ହଡ଼ ଆଇଙ୍ଗ୍‌କେ ସୁକୁଆୟାଁଏ, ଇନିଃ ଆଇଙ୍ଗ୍‌କେ ଏସ୍‌କାର୍‌ କା ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‌ନିଃ ଆଇଁୟାଃ ଆବାକେୟଗି ସୁକୁଆଇୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଯୋହାନ୍‌ ୟୀଶୁକେ କାଜିକିୟାଏ, “ହେ ଗମ୍‌କେ, ମିଆଁଦ୍‌ ହଡ଼ ଆମାଃ ନୁତୁମ୍‌ତେ ବଙ୍ଗାକକେ ଅଡଙ୍ଗ୍‌କତାନ୍‌ଲେ ନେଲ୍‌କିୟା ଆଡଃ ଇନିଃ ଆବୁଆଃ ଜାମାରେନ୍ କାଏ ତାଇକେନା, ଏନାମେନ୍ତେ ଇନିଃକେ ମାନାକିୟାଲେ ।” ");
INSERT INTO unx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“ୟୀଶୁ ମେତାଦ୍‌କଆଏ, ଆଲ୍‌ପେ ମାନାଇୟା, ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅ କାମି କାମିତାନ୍‌ ଜେତାଏନିଃ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ଏତ୍‌କାନ୍‌ କାଜି କାମି କାଏ ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ଚିୟାଃଚି ଅକଏ ଆବୁକେ ଦାରମ୍‌ବୁତାନାଏ, ଇନିଃଦ ଆବୁଲଃରିୟା । ");
INSERT INTO unx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗିଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ତାନ୍‌ପେ ମେନ୍ତେ ଅକ ହଡ଼ ଆପେକେ ମିଦ୍‌ ଗିଲାସ୍‌ ରେହାଡ଼୍‌ ଦାଆଃ ନୁଁଏ ନାଗେନ୍ତେ ଏମାପେରେଦ, ଏନ୍‌ ହଡ଼ ଆୟାଃ ନାଲା ନାମେଗିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ଆଡଃଗି ୟୀଶୁ କାଜିକେଦାଃଏ, ଜେତାଏ ଆଇଁୟାଃରେ ବିଶ୍ୱାସ୍‌ତାନ୍‌ ନେ ହୁପ୍‌ଡିଙ୍ଗ୍‌କଏତେ ମିଆଁଦ୍‌ନିଃକେ ଆୟାଃ ବିଶ୍ୱାସ୍‌ରେ ତହଦ୍‍ରିକାଇରେଦ ଇନିୟାଃ ହଟଃରେ ଜାନ୍ତାଦିରି ହାକାକେଦ୍‌ତେ ଇନିଃକେ ଇକିର୍‌ ଦରେୟାରେ ହୁଦ୍‌ମାତେୟାଃ ଇନିଃ ନାଗେନ୍ତେ ବୁଗିଅଃତେଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ଆଡଃ ଆମାଃ ତିଃଇ ବିଶ୍ୱାସ୍‌ରେ ତହଦ୍‍ ରିକାମ୍‌ତାନ୍‌ରେଦ, ଏନାକେ ଛପାଏଣ୍ଡାଃଏମେ । ବାରିଆଃ ତିଃଇ ତାଇକେଦ୍‌ତେ ନାରାକ୍‌ତେ, ଚିଉଲାଅ କା ଇଣିଁଜଃ ସେଙ୍ଗେଲ୍‌ତେ ସେନଃଏତେଦ ଟୁଣ୍ଟାୟାନ୍ତେ ଜୀଦାନ୍‌ରେ ବଲଃ ଆମାଃ ନାଗେନ୍ତେ ବୁଗିନାଃ । ");
INSERT INTO unx_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ନାରାକ୍‌ରେ ଇନ୍‌କୁକେ ଜମ୍‌ତାନ୍ ତିଜୁ କାକ ଗଜଃଆ ଆଡଃ ସେଙ୍ଗେଲ୍ କା ଇଣିଁଜଃଆ ");
INSERT INTO unx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଆଡଃ ଆମାଃ କାଟା ତହଦ୍‍ ରିକାମ୍‌ତାନ୍‌ ରେଦ, ଏନାକେ ଛପା ଏଣ୍ଡାଃତାମ୍ । ବାରିଆ କାଟାତେ, ସେଙ୍ଗେଲ୍ ନାରାକ୍‌ରେମ୍‌ ହୁରାଙ୍ଗ୍‌ ହାଁଣବଃଏତେଦ, ଲାଙ୍ଗ୍‌ଡ଼ାକାନ୍ ଜୀଦାନ୍‌ରେ ବଲଃତେୟାଃ ଆମ୍‌ ନାଗେନ୍ତେ ବୁଗିନାଃ । ");
INSERT INTO unx_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ନାରାକ୍‌ରେ ଇନ୍‌କୁଆଃ ତିଜୁ କାଏ ଗଜଃଆ ଆଡଃ ସେଙ୍ଗେଲ୍ କା ଇଣିଁଜଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ଆଡଃ ଆମାଃ ମିଆଁଦ୍‌ ମେଦ୍‌ ପାପ୍‌ଇଚିମେରେଦ, ଏନାକେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ହୁଦ୍‌ମାଏଣ୍ଡାଃଏମେ । ଆମାଃ ବାରିଆ ମେଦ୍‌ ତାଇକେଦ୍‌ତେ ସେଙ୍ଗେଲ୍ ନାରାକ୍‌ରେ ହୁଦ୍‌ମାଅଃଏତେ ମିଆଁଦ୍‌ ମେଦ୍‌ ତାଇକେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ବଲଃ ଆମାଃ ନାଗେନ୍ତେ ବୁଗିନାଃ । ");
INSERT INTO unx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ଏନ୍ତାଃରେଦ ଇନ୍‌କୁକେ ଜମ୍‌ତାନ୍ ତିଜୁକ କାକ ଗଜଃଆ ଆଡଃ ଏନ୍ତାଃରାଃ ସେଙ୍ଗେଲ୍ ଚିଉଲାଅ କା ଇଣିଁଜଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ଦାଣେଁ ବୁଲୁଙ୍ଗ୍‌ତେ ଫାର୍‌ଚିଅଃ ଲେକା ସବେନ୍‌ ହଡ଼କହ ସେଙ୍ଗେଲ୍‌ତେକ ଫାର୍‌ଚିଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ବୁଲୁଙ୍ଗ୍‌ ବୁଗିନାଃ, ମେନ୍‌ଦ ଏନା ସାବାଗଃରେଦ, ଏନା ଚିଲ୍‌କାତେ ଆଡଃମିସା ସିବିଲ୍‌ରୁହାଡ଼ଃଆ ? ଆପେରେ ଦୁପୁଲାଡ଼୍‌ରାଃ ବୁଲୁଙ୍ଗ୍‌ ତାଇନଃକା, ଆଡଃ ଆପେ ମିହୁଡ଼୍‌ ଆଡଃମିହୁଡ଼୍‌ଲଃ ସୁକୁରେ ତାଇନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ଏନ୍ତେ ୟୀଶୁ କପର୍‌ନାହୁମ୍‌ଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ଯାର୍ଦାନ୍‌ନାହିଁ ପାରମ୍‌କେଦ୍‌ତେ ଯିହୁଦା ପାର୍‌ଗାନ୍‌ତେ ସେଟେର୍‌ୟାନାଏ । ଏନ୍ତେ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃତାଃ ଆଡଃଗିକ ହୁଣ୍ଡିୟାନା ଆଡଃ ଇନିଃ ସିଦାଲେକା ଇନ୍‌କୁକେ ଇତୁକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ଚିମିନ୍‌ ଫାରୁଶୀକ ଇନିଃତାଃ ହିଜୁଃକେଦ୍‌ତେ ବିଡ଼ାଅ ନାଗେନ୍ତେକ କୁଲିକିୟା, “ମିଆଁଦ୍‌ କଡ଼ା ଆୟାଃ କୁଡ଼ିତେକେ ବାଗିତେଆଃ ଆଇନ୍‌ଲେକାତେ ଠାଉକାଗିୟାଃ ଚି ?” ");
INSERT INTO unx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ୟୀଶୁ କୁଲିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ମୁଶା ଆଇନ୍‌ରେ ଚିକ୍‌ନାଃଏ ଆଚୁକାଦ୍‌ପେୟା ?” ");
INSERT INTO unx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ଇନ୍‌କୁ କାଜିକିୟାଃ, “ବାଗିରେଆଃ ଅନଲ୍‌ଚିଠା ଏମ୍‌କେଦ୍‌ତେ ଜେତାଏ କୁଡ଼ି ତାୟାଃକେ ବାଗି ନାଗେନ୍ତେ ମୁଶା କାଜିୟାକାଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆପେୟାଃ କେଟେଦ୍‌ମନ୍‍ ନାଗେନ୍ତେ ମୁଶା ନେ ଆନ୍‌ଚୁ ଅଲାଦ୍‌ପେଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ମେନ୍‌ଦ ପୁଥିରେ ଅଲାକାନ୍‌ ଲେକା, ‘ଅତେଦିଶୁମ୍‌ରାଃ ବାଇୟଃ ମୁନୁରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ମାନୱା କିନ୍‌କେ କଡ଼ା ଆଡଃ କୁଡ଼ି ବାଇକାଦ୍‌କିନାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘ଏନାମେନ୍ତେ କଡ଼ା ଆୟାଃ ଏଙ୍ଗା ଆଡଃ ଆପୁକିନ୍‌କେ ବାଗିକିନାଏ, ଆଡଃ ଆୟାଃ କୁଡ଼ିତାୟାଃଲଃ ମିଦଃଆଏ, ");
INSERT INTO unx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ଆଡଃ ଇନ୍‌କିନ୍‌ ମିଆଁଦଃଆକିନ୍‌ ।’ ଏନାମେନ୍ତେ ଇନ୍‌କିନ୍‌ ବାରିଆ ହଡ଼୍‌ମ ନାହାଁଲାଃକିନ୍‌, ମେନ୍‌ଦ ମିଆଁଦ୍‌ ହଡ଼୍‌ମତାନ୍‌କିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ଏନା ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ମିଦ୍‌ରେ ତଲାକାଦ୍‌ତେୟାଃ ହଡ଼ ଆଲକାଏ ବିନ୍‌ଗାଏକା ।” ");
INSERT INTO unx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ଅଡ଼ାଃତେ ସେନଃୟାନ୍ତେ, ଏନ୍ତାଃରେ ଆୟାଃ ଚେଲାକ ୟୀଶୁକେ ଏନ୍‌କାଜି ଆଡଃଗିକ କୁଲିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ୟୀଶୁଦ ମେତାଦ୍‌କଆଏ, “ଜେତାଏ ଆୟାଃ କୁଡ଼ିତେକେ ବାଗିକେଦ୍‌ତେ ଏଟାଃ କୁଡ଼ି ଆଣ୍‌ଦିୟଃନିଃଦ ଆୟାଃ କୁଡ଼ିତେୟାଃ ବିରୁଧ୍‌ରେ ଆପାଙ୍ଗିର୍‌ କାମି କାମିୟା । ");
INSERT INTO unx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ଏନ୍‌ ଲେକାତେ କୁଡ଼ି ଆୟାଃ କଡ଼ାତେକେ ବାଗିକେଦ୍‌ତେ ଏଟାଃ କଡ଼ାକେ ଆଣ୍‌ଦିନ୍‌ରେଦ ଇନିଃ ଆୟାଃ କଡ଼ାତେୟାଃ ବିରୁଧ୍‌ରେ ଆପାଙ୍ଗିର୍‌ କାମି କାମିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ହୁପ୍‌ଡିଙ୍ଗ୍‌ ହନ୍‌କକେ, ତିଃଇ ଦହକେଦ୍‌ତେ ଆଶିଷ୍‌କକାଏ ମେନ୍ତେ, ହଡ଼କ ୟୀଶୁତାଃତେକ ଆଉକେଦ୍‌କଆ, ମେନ୍‌ଦ ଚେଲାକ ଆଉକତାନ୍‌କକେ ମାରାଙ୍ଗ୍‌ମଚା କେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଏନା ନେଲ୍‌କେଦ୍‌ତେ ୟୀଶୁ ଖିସ୍‌ୟାନାଏ ଆଡଃ ଚେଲାକକେ ମେତାଦ୍‌କଆଏ, “ହୁପ୍‌ଡିଙ୍ଗ୍‌ ହନ୍‌କକେ ଆଇଙ୍ଗ୍‌ତାଃତେ ହିଜୁଃରିକାକପେ, ଆଡଃ ଆଲ୍‌ପେ ମାନାକଆ, ନିକୁଲେକାନ୍‌ କଆଃଗିଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା ଜେତାଏ ହଡ଼ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌, ମିଆଁଦ୍‌ ହୁଡିଙ୍ଗ୍‌ହନ୍‌ ଲେକା କାଏ ତେଲାଏରେଦ, ଏନାରେ ଚିଉଲାହଗି କାଏ ବଲଦାଡ଼ିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ଏନ୍ତେ ଇନିଃ ହନ୍‌କକେ ହାମ୍ବୁଦ୍‌କେଦ୍‌କଆଏ, ଆଡଃ ଇନ୍‌କୁଆଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହକେଦ୍‌ତେ ଆଶିଷ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଆଡଃଗି ୟୀଶୁ ସେନଃନାଙ୍ଗ୍‌ ଅଡଙ୍ଗ୍‌ତାନ୍‌ ଇମ୍‌ତା ମିଆଁଦ୍‌ ହଡ଼ ଇନିୟାଃ ଆୟାର୍‌ରେ ନିର୍‌ହିଜୁଃୟାନ୍‌ଚି ଇକୁଡ଼ୁମ୍‌ୟାନାଏ ଆଡଃ କୁଲିକିୟାଏ, “ଏ ବୁଗିନ୍‌ ଇତୁନିଃ, ଜାନାଅ ଜୀଦାନ୍‌ ନାମେ ନାଗେନ୍ତେ ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ?” ");
INSERT INTO unx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ୟୀଶୁ ମେତାଇୟାଏ, “ଆମ୍‌ ଚିନାଃମେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ ବୁଗିନ୍‌ ମେନ୍ତେମ୍‌ କାଜିଇଙ୍ଗ୍‌ତାନା ? ମିଆଁଦ୍‌ନିଃ ଏସ୍‌କାର୍‌ ବୁଗିନାଏଃ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଃ ଆଡଃ ଜେତାଏକାହା । ");
INSERT INTO unx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ଆମ୍‌ ଆନ୍‌ଚୁମ୍‌ ସାରିତାନା, ଆଲମ୍‌ ଗଗଏୟାଃ, ଆଲମ୍‌ ଆପାଙ୍ଗିର୍‌ରାଃ, ଆଲମ୍‌ କୁମ୍ବୁଡ଼ୁଇୟା, ହସଡ଼ଗାୱା ଆଲମାଃ, ଆଲମ୍‌ ବେଦାଃ, ଏଙ୍ଗା ଆପୁ କିନ୍‌କେ ମାନାତିଙ୍ଗ୍‌କିନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ଇନିଃଦ ମେନ୍‌ରୁହାଡ଼ାଇୟାଏ, “ହେ ଗୁରୁ, ନେ ସବେନ୍‌ ଆନ୍‌ଚୁ ମିଦ୍‌ସିଟିଆଏତେଇଙ୍ଗ୍‌ ମାନାତିଙ୍ଗ୍‌ ଆଉକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ୟୀଶୁ ଇନିଃକେ ନେଲ୍‌ବାଇକିଃତେ ଦୁଲାଡ଼୍‌କିୟାଏ ଆଡଃ ମେତାଇୟାଏ, “ଆଡଃ ମିଆଁଦ୍‌ କାଜି ଆମ୍‌କେ ରିକାଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଜୁ, ଆମାଃ ସବେନାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌ତାମେ, ଆଡଃ ଏନ୍‌ ଟାକା ରେଙ୍ଗେଃକକେ ହାଟିଙ୍ଗ୍‌ଆଁକମ୍, ସିର୍ମା ଦିଶୁମ୍‌ରେ ଖୁର୍ଜିମ୍ ନାମେଆଁ, ଆଡଃ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ଏନା ଆୟୁମ୍‌କେଦ୍‌ତେ ଏନ୍‌ ହଡ଼ ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନାଏ, ଆଡଃ ଗସ ମେଦ୍‌ମୁହାଁଡ଼ାଏ ସେନଃୟାନା । ଚିୟାଃଚି ଇନିଃଦ ପୁରାଃଗି କିସାଁଣ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ୟୀଶୁ ଚେଲାକକେ ହେତାବିୟୁର୍‌କେଦ୍‌କଆଏ ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଅକନ୍‌ ହଡ଼କଆଃ ଟାକା ପାଏସା ମେନାଃ, ଏନ୍‌ କିସାଁଣ୍‌ ହଡ଼କନାଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ବଲଃ ପୁରାଃଗି ହାମ୍ୱାଲାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଏନ୍‌ କାଜିକ ଆୟୁମ୍‌କେଦ୍‌ତେ ଚେଲାକ ଆକ୍‌ଦାନ୍ଦାଅୟାନା, ମେନ୍‌ଦ ୟୀଶୁ ଆଡଃଗି କାଜିୟାଦ୍‌କଆଏ, “ଏ ହନ୍‌କ, ପାର୍‌ମେଶ୍ୱାରାଃ ରାଇଜ୍‌ରେ ବଲଃ ପୁରାଃଗି ହାମ୍ୱାଲାଃ । ");
INSERT INTO unx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ କିସାଁଣ୍‌ ହଡ଼ ବଲ ଦାଡ଼ିଏତେ, ସୁଇଉଣ୍ଡୁଃରେ ଉଁଟ୍‌ ପାରମଃତେଆଃ ରାୱାଲାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଚେଲାକ ଆଡଃଗି ଆକ୍‌ଦାନ୍ଦାଅୟାନା ଆଡଃ ଆକ ଆକରେ କୁଲିବାଡ଼ାକେଦାଃକ, “ତାବ୍‌ଦ ଅକଏ ଜୀଉବାଞ୍ଚାଅ ନାମ୍‌ ଦାଡ଼ିୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ୟୀଶୁ ଇନ୍‌କୁସାଃତେ ଆରିଦ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ହଡ଼କ ନାଗେନ୍ତେ ଏନା କା ଦାଡ଼ିୟଃ କାମି ତାନାଃ, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ନାଗେନ୍ତେ ଦାଡ଼ିଅଃଆ । ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ତେ ହବାଦାଡ଼ିୟଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ କାଜିକେଦା, “ନେଲେମେ, ଆଲେଦ ସବେନାଃ ବାଗିକେଦ୍‌ତେ ଆମ୍‌କେଲେ ଅତଙ୍ଗ୍‌କେଦ୍‌ମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଜେତାଏ ହଡ଼ ଆଇଙ୍ଗ୍‌ ମେନ୍ତେ ଚାଏ ସୁକୁକାଜିମେନ୍ତେ, ଅଡ଼ାଃଦୁଆର୍, ଚାଏ ହାଗା ଚାଏ ମିଶି, ଚାଏ ଏଙ୍ଗା ଚାଏ ଆପୁ, ଚାଏ ହନ୍‌ଗାଁଣା, ଚାଏ ପିଡ଼ିହାସା ବାଗିତାରେଦ, ");
INSERT INTO unx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ଇନିଃ ନେ ପାରିୟାରେ, ସାଅଗୁଣା ଆଦ୍‌କା ଅଡ଼ାଃଦୁଆର୍‌କ, ହାଗା ମିଶିକ, ଏଙ୍ଗାକ, ହନ୍‌କ ଆଡଃ ଅତେହାସାକ ନାମେୟାଏ, ଆଡଃ ଏନାଲଃ ଦୁକୁସାସ୍‌ତି ହଁ, ଆଡଃ ତାୟମ୍‌ ଦିପିଲିରେ ଜାନାଅ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌ ନାମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ମେନ୍‌ଦ ପୁରାଃ ହଡ଼କ ସିଦାକାନ୍‌କ ତାୟମଃଆ, ଆଡଃ ତାୟମାକାନ୍‌କ ସିଦାଅଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ନାହାଁଃଦ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃତାନ୍‌ ହରାକ ସାବ୍‌କେଦା । ୟୀଶୁ ଆୟାଃ ଚେଲାକଆଃ ଆୟୁର୍‌ ଆୟୁର୍‌ରେ ସେନଃ ତାଇକେନା, ଚେଲାକ ଆକ୍‌ଚାକାଅକାନ୍‌ ତାଇକେନାକ ଆଡଃ ତାୟମ୍‌ରେ ସେନ୍‌ତାନ୍‌ ଏଟାଃ ହଡ଼କହଗି ବର ତାଇକେନାକ । ୟୀଶୁ ଆଡଃଗି ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ ହରାଏତେ ହାକାଅ ଆତମ୍‌କେଦ୍‌କଆ, ଆଡଃ ଆଇଃକ୍‌ରେ ଟଗଃ କାଜିକ ଇନ୍‌କୁକେ ଉଦୁବ୍‌ ଏଟେଦ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଆବୁ ଯୀରୁଶାଲେମ୍‌ତେବୁ ସେନଃତାନା, ଆଡଃ ଏନ୍ତାଃରେ ଆଇଙ୍ଗ୍‌କେ ମାନୱାହନ୍‌କେ ମୁଲ୍‌ ଯାଜାକ୍‌କଆଃ ଆଡଃ ଆଇନ୍‌ ଇତୁକଆଃ ତିଃଇରେ ଏମ୍‌ଏଣ୍ଡାଗିଆଁକ । ଇନ୍‌କୁ ଆଇଙ୍ଗ୍‌କେ ଗନଏଃ ସାଜାଇ ଏମ୍‌କେଦ୍‌ତେ ସାଅଁସାର୍‌ ହଡ଼କଆଃ ତିଃଇରେକ ଜିମାଇଁୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ଇନ୍‌କୁ ଆଇଙ୍ଗ୍‌କେ ଲାନ୍ଦାୟାଃଁକ, ବେଜିୟାଃଁକ, ଚାବୁକ୍‌ରେକ ହାଁଣ୍‌ସାୟାଁଃ, ଆଡଃକ ଗଜିୟାଁ ମେନ୍‌ଦ ଆପିମାରେ ଆଇଙ୍ଗ୍‌ ଜୀଉ ବିରିଦାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ଜେବଦୀୟାଃ ହନ୍‌କିନ୍‌ ଯାକୁବ୍‌ ଆଡଃ ଯୋହାନ୍‌, ୟୀଶୁତାଃକିନ୍ ହିଜୁଃୟାନା, ଆଡଃକିନ୍ କାଜିକିୟା, “ହେ ଗୁରୁ ଜେତାନ୍‌କାଜି ଆଲିଙ୍ଗ୍‌ ଆସିମେତେୟାଃ ଆଲିଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ରିକାଏମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ କୁଲିକେଦ୍‌କିନାଏ, “ଚିକାନାଃବେନ୍ ଆସିତାନା, ଚିନାଃଇଙ୍ଗ୍‌ ରିକାୟା ?” ");
INSERT INTO unx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ଇନ୍‌କିନ୍‌ କାଜିକିୟା, “ଆମାଃ ରାଇଜ୍‌ ମାନାରାଙ୍ଗ୍‌ରାଃ ରାଜ୍‌ଗାଦିରେ ଆଲିଙ୍ଗ୍‌ଏତେ ମିହୁଡ଼୍‌ ଆମାଃ ଜମ୍‌ତିସାଃରେ, ଆଡଃ ଏଟାଃନିଃ ଆମାଃ ଲେଙ୍ଗାତିସାଃରେ ଦୁବ୍‌କାଏ ମେନ୍ତେ କାଜିତାମ୍, ନେୟାଁଲିଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ୟୀଶୁଦ ମେତାଦ୍‌କିନାଏ, “ଚିନାଃବେନ୍ ଆସିତାନା ଏନା କାବେନ୍‌ ଆଟ୍‌କାର୍‌ ଉରୁମେତାନା । ଚିୟାଃ ଆଇଙ୍ଗ୍‌ ଅକନ୍‌ ଦୁକୁସାହାତିଙ୍ଗ୍‌ରାଃ କାଟୋରାରେ ନୁଁଇଙ୍ଗ୍‌, ଏନା ନୁଁବେନ୍‌ ଦାଡ଼ିୟା ? ଚାଏ ଆଇଙ୍ଗ୍‌ ଅକନ୍‌ ଗନଏଃରାଃ ବାପ୍ତିସ୍ମାତେଇଙ୍ଗ୍‌ ବାପ୍ତିସ୍ମାଅଃଆ, ଏନାରେ ଚିନାଃ ଆବେନଃବେନ୍ ବାପ୍ତିସ୍ମା ଦାଡ଼ିୟଃଆ ?” ");
INSERT INTO unx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“ଦାଡ଼ିୟାଃଲିଙ୍ଗ୍‌,” ମେତାଇଜାକିନ୍‌, ୟୀଶୁ ମେତାଦ୍‌କିନାଏ, “ଆଇଙ୍ଗ୍‌ ନୁଁଏ କାଟୋରାରେଦବେନ୍ ନୁଁଇୟାଃ ଆଡଃ ଆଇଙ୍ଗ୍‌ ବାପ୍ତିସ୍ମାଅଃ ବାପ୍ତିସ୍ମାତେବେନ୍ ବାପ୍ତିସ୍ମାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ମେନ୍‌ଦ ଆଇଁୟାଃ ଜମ୍‌ତିସାଃରେ ଚାଏ ଲେଙ୍ଗାତିସାଃରେ ଅକଏ ଦୁବାଃଏ ନେଆଁଁ କାଜିତେୟାଃଦ ଆଇଁୟାଃ ତିଃଇରେ ବାନଆଃ । ଅକଏୟାଃ ନାଗେନ୍ତେ ଏନା ପାର୍‌ମେଶ୍ୱାର୍‌ ବାଇୟାକାଦାଃଏ ଇନ୍‌କୁକେ ଇନିଃ ଏନା ଏମାକଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ଏନା ଆୟୁମ୍‌କେଦ୍‌ତେ, ଏଟାଃ ଗେଲ୍‌ ଚେଲାକ ଯାକୁବ୍‌ ଆଡଃ ଯୋହାନ୍‌କେ ଖିସ୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ୟୀଶୁ ଇନ୍‌କୁକେ ଆୟାଃତାଃତେ ହାକାଅ କେଦ୍‌କଆଏ ଆଡଃ ମେତାଦ୍‌କଆଏ, “ସାଅଁସାର୍‌କଆଃ ଗୁସିୟାଁକ ନୁତୁମଃତାନ୍‌କ ଇନ୍‌କୁରେକ ରାଇଜ୍‌ତାନା ଆଡଃ ଇନ୍‌କୁ ଥାଲାରେ ମାପ୍‌ରାଙ୍ଗ୍‌କାନ୍‌କ ଆକଆଃ ଆକ୍‌ତେୟାର୍‌କ ଇନ୍‌କୁକେ ଆଟ୍‌କାର୍‌ ରିକାଚିକାକତାନା, ନେଆଁଁପେ ସାରିଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ଆପେରେଦ ଆଲକା ଏନ୍‌କାଅଃକା । ଆପେ ଥାଲାରେ ଜେତାଏ ମାରାଙ୍ଗ୍‌ୟେଁନ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଇନିଃ ଆପେୟାଃ ସୁସାର୍‌ନିଃ ବାଇୟେନ୍‌କାଏ । ");
INSERT INTO unx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ଆଡଃ ଆପେୟାଃ ଥାଲାରେ ଜେତାଏ ସିଦାଉତାରଃ ସାନାଙ୍ଗ୍‌ତାନ୍‌ନିଃ ସବେନ୍‌କଆଃ ଦାସି ବାଇୟେନ୍‌କା । ");
INSERT INTO unx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌, ସୁସାର୍‌ନାମେ ନାଗେନ୍ତେଦ କା, ମେନ୍‌ଦ ସୁସାର୍‌ ନାଗେନ୍ତେ ଆଡଃ ଆଇଁୟାଃ ଜୀଉ ପୁରାଃ ହଡ଼କଆଃ ଦାଣେଁ ଗନଙ୍ଗ୍‌ ଏମ୍‌ପୁରା ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ହିଜୁଃକାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ଯିରିହୋତେକ ସେଟେର୍‌ୟାନା, ଆଡଃ ଇନ୍‌କୁ ଗାଦେଲ୍‌ ହଡ଼କଲଃ ଏନ୍‌ ସାହାର୍‌ଏତେ ଅଡଙ୍ଗ୍‌ଅଃତାନ୍‌ ଇମ୍‌ତା ତିମାୟୁଆଃ ହନ୍‌ କା ନେଲ୍‌ଦାଡ଼ିତାନ୍‌ ବାର୍ଟିମାୟ ହରାଗେନାରେ ଦୁବ୍‌କେଦ୍‌ତେ କଏଁ ଆସିତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ଇନିଃ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ ତାନିଃ ମେନ୍ତେ ଆୟୁମ୍‌ତାଦ୍‌ଚି, “ହେ ଦାଉଦ୍‌ଆଃ ହନ୍‌ ୟୀଶୁ ଦାୟାଇଙ୍ଗ୍‌ମେ” ମେନ୍ତେ କାଉରିତାନ୍‌ଲଃ ହାକାଅ ଏଟେଦ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେ ହାପାଅଃକାଏ ମେନ୍ତେକ ମାରାଙ୍ଗ୍‌ମଚାକିୟାଃ । ମେନ୍‌ଦ ଇନିଃ ଆଡଃଗି ପୁରାଃ “ହେ ଦାଉଦ୍‌ଆଃ ହନ୍‌ ଦାୟାଇଙ୍ଗ୍‌ମେ” ମେନ୍ତେ କାଉରିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ୟୀଶୁ ତିଙ୍ଗୁୟାନାଏ ଆଡଃ, “କେଡ଼ାଆଉଇପେ” ମେନ୍‌କେଦାଏ । ଇନ୍‌କୁ ଏନ୍‌ କା ନେଲ୍‌ଦାଡ଼ିତାନ୍‌ ହଡ଼କେ କେଡ଼ାକିୟାଃକ ଆଡଃ କାଜିକିୟାକ, “ଆଲମ୍‌ ବରଏୟା, ମାର୍‌ ବିରିଦ୍‌ମେ ! ଇନିଃ କେଡ଼ାମେତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ଇନିଃଦ ଆୟାଃ ଲିଜାଃ ହୁଦ୍‌ମା ଏଣ୍ଡାଃକେଦ୍‌ତେ ବିରିଦ୍‌ ଧାବ୍‌ୟାନାଏ ଆଡଃ ୟୀଶୁତାଃତେ ହିଜୁଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ୟୀଶୁ ଇନିଃକେ କୁଲିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ଆମାଃ ନାଙ୍ଗ୍‌ ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ମେନ୍ତେମ୍ ସାନାଙ୍ଗ୍‌ତାନା” ଏନ୍‌ କା ନେଲ୍‌ଦାଡ଼ିତାନ୍‌ ହଡ଼ ମେତାଇୟାଏ, “ହେ ଗୁରୁ ନେନେଲାଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ୟୀଶୁ ଇନିଃକେ ମେତାଇୟାଏ, “ଜୁ ସେନଃମେ, ଆମାଃ ବିଶ୍ୱାସ୍‌ ଆମ୍‌କେ ବୁଗିକେଦ୍‌ମେୟାଏ ।” ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଇନିଃ ନେଲ୍‌ ଦାଡ଼ିକେଦାଏ ଆଡଃ ୟୀଶୁକେ ହରାହରାତେ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ୟୀଶୁ ଆଡଃ ଚେଲାକ ଯୀରୁଶାଲେମ୍‌ ନାଡ଼େଃୟାନ୍‌ତେ, ଜାଇତୁନ୍‌ ବୁରୁଜାପାଃ ବେତ୍‌ଫାଗି ଆଡଃ ବେଥ୍‌ନିଆ ନାଡ଼େଃତେକ ସେଟର୍‌ୟାନା, ଇମ୍‌ତା ୟୀଶୁ ଆୟାଃ ଚେଲାକଏତେ ବାର୍‌ହଡ଼୍‌କିନ୍‌କେ ଆୟାର୍‌ତେ କୁଲ୍‌କେଦ୍‌କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ଆଡଃ ମେତାଦ୍‌କିନାଏ, “ସାମ୍‌ନାଙ୍ଗ୍‌ରେଆଃ ହାତୁତେ ସେନଃବେନ୍, ଏନ୍‌ ହାତୁ ତେବାଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ନାହାଁଃ ଜାକେଦ୍‌ ଜେତାଏ ଇନିଃରେ କା ଦେଜାକାନ୍ ମିଆଁଦ୍‌ ଗାଧାହନ୍‌ ତଲାକାନ୍‌ବେନ୍ ନାମିଆଁ, ଇନିଃକେ ରାଡ଼ାଇବେନ୍ ଆଡଃ ନେତାଃ ଆଉୱିବେନ୍ । ");
INSERT INTO unx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ଜେତାଏ ହଡ଼ ଇନିଃକେ ଚିନାଃ ମେନ୍ତେବେନ୍ ରାଡ଼ାଇତାନା ମେନ୍ତେ କୁଲିବେନ୍‌ରେଦ, କାଜିୟାଇବେନ୍‌, ନିଃ'ତାଃରେ ପ୍ରାଭୁଆଃ କାମିମେନାଃ, ଆଡଃ ହୁଡିଙ୍ଗ୍‌ତାୟମ୍‌ତେ କୁଲ୍‌ରୁହାଡ଼୍‌ତାଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ଇନ୍‌କିନ୍‌ ସେନଃୟାନାକିନ୍‌ ଆଡଃ ରାଚା ଦୁଆର୍‌ତାଃ ବାହାରିରେ ମିଆଁଦ୍‌ ଗାଧାହନ୍‌ ତଲାକାନ୍‌କିନ୍ ନାମ୍‌କିୟାଃ । ଇନିଃକେକିନ୍‌ ରାଡ଼ାଇ ଇମ୍‌ତା, ");
INSERT INTO unx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ଏନ୍ତାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ହଡ଼କ କୁଲିକେଦ୍‌କିନା, “ଗାଧାହନ୍‌କେ ଚିନାଃ ମେନ୍ତେବେନ୍ ରାଡ଼ାଇତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ଇନ୍‌କିନ୍‌ଦ ୟୀଶୁ କାଜିୟାଦ୍‌କିନ୍ ଲେକାକିନ୍‌ କାଜିରୁହାଡ଼ାଦ୍‌କଆ, ଏନ୍ତେ ଇନ୍‌କୁ ଇନ୍‌କିନ୍‌କେ ରାଡ଼ା ରିକାଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ଗାଧାହନ୍‌କେ ଇନ୍‌କିନ୍‌ ୟୀଶୁତାଃକିନ୍ ଆଉକିୟା, ଆଡଃ ଗାଧା ଚେତାନ୍‌ରେ ଆକିନାଃ ଲିଜାଃକିନ୍ ଆଟେଦ୍‌କେଦା, ଆଡଃ ୟୀଶୁ ଇନିଃରେ ଦୁବ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ପୁରାଃ ହଡ଼କ ୟୀଶୁକେ ମାଇନି ନାଗେନ୍ତେ ଆକଆଃ ଲିଜାଃ ହରାହରାକ ବିଲ୍‌ଇଦି ତାଇକେନା; ଏଟାଃକଦ, ପିଡ଼ିକଏତେ ହୁଡିଙ୍ଗ୍‌ ଢାଉଡ଼ା ମାଆଃ ଆଉକେଦ୍‌ତେ, ହରାହରାକ ଆଟେଦ୍ଇଦି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ୟୀଶୁଆଃ ଆୟୁର୍‌ ତାୟମ୍‌ରେ ସେନଃତାନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ କାଉରିକେଦାଃ, “‘ହୋଶାନ୍ନା’ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ହବାଅଃକା, ପ୍ରାଭୁଆଃ ନୁତୁମ୍‌ତେ ହିଜୁଃନିଃ ଧାଇନ୍‌ ହବାଅଃକାଏ । ");
INSERT INTO unx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ଆବୁଆଃ ପୁର୍‌ଖାଆପୁ ଦାଉଦ୍‌ଆଃ ହିଜୁଃତାନ୍‌ ରାଇଜ୍‌ ଧାଇନ୍‌ ହବାଅଃକା, ସାଲାଙ୍ଗିଉତାର୍‌ ଠାୟାଦ୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ହୋଶାନ୍ନା ହବାଅଃକା” ମେନ୍ତେକ କାଉରିକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ତେ ତେବାଃୟାନ୍‌ଚି ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ବଲୟାନାଏ ଆଡଃ ଇନିଃ ସବେନାଃ ନେଲ୍‌ ବାଡ଼ାକେଦ୍‌ଚି ସିଙ୍ଗିହାସୁରଃତାନ୍ ଇମ୍‌ତା ବାରାଝାନ୍‌ ଚେଲାକଲଃ ବେଥ୍‌ନିଆତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ବେଥ୍‌ନିଆଏତେ ରୁହାଡ଼୍‌ ଇମ୍‌ତା, ୟୀଶୁକେ ରେଙ୍ଗେଃକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ସାଙ୍ଗିନ୍‌ରେ ଇନିଃ ସାକାମାକାନ୍‌ ମିଆଁଦ୍‌ ଲଆଦାରୁକେ ନେଲ୍‌କେଦ୍‌ତେ, ଏନ୍‌ରେ ଜ'କଇଙ୍ଗ୍‌ ନାମେଜାଃ ମେନ୍ତେ ଏନ୍ତାଃତେ ସେନଃୟାନା । ମେନ୍‌ଦ ତେବାଃୟାନ୍‌ଚି ଏନାରେ ସାକାମ୍‌ ବିଡ଼ାଙ୍ଗ୍‌ ନାମ୍‌କେଦାଏ ଆଡ଼ାଃ ଜ କାଏ ନାମ୍‌କେଦାଃ, ଚିୟାଃଚି ଇମ୍‌ତା ଲଆ ଜ'ସାହା କା ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ଏନ୍ତେ, “ଆମାଃ ଜ ଆଡଃ ଜେତାଏ ହଡ଼ ଚିଉଲାଅ ଆଲକାଏ ଜମେକା” ମେନ୍ତେ ଲଆ ଦାରୁକେ କାଜିକେଦା । ଆଡଃ ଚେଲାକତାୟାଃ ଏନ୍‌ କାଜିକ ଆୟୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ଯୀରୁଶାଲେମ୍‌ତେ ତେବାଃୟାନ୍‌ଚି, ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃତେ ବଲୟାନାଏ, ଆଡଃ ଏନ୍ତାଃରେ ଦାଣେଁନାଙ୍ଗ୍‌ ଜାଁତୁକକେ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ ତାନ୍‌କକେ ହାର୍‌ଅଡଙ୍ଗ୍‌ ଏଟେଦ୍‌କେଦ୍‌ଆଏ । ପାଏସା ଭାଞ୍ଜାଅତାନ୍‌କଆଃ ମେଜ୍‌କ ଆଡଃ ଦୁଦୁମୁଲ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ ତାନ୍‌କଆଃ ଦୁବ୍‌ତେୟାଃକ ଉଦୁର୍‌ବାଟିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ଆଡଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଃ ବାହାରି ରାଚା ଥାଲା ଥାଲାତେ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ତେଆଃକ ସାବ୍‌କେଦ୍‌ତେ ଜେତାଏକେୟ କାଏ ସେନ୍ ପାରମ୍‌ ଇଚିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ଏନ୍ତେ ଇନ୍‌କୁକେ ଇତୁତାନ୍‌ଲଃ ମେତାଦ୍‌କଆଏ, ନେଆଁଁ ଅଲାକାନା, “ଆଇଁୟାଃ ଅଡ଼ାଃ ଦିଶୁମ୍‌ରାଃ ସବେନ୍‌ ଜାତିକ ନାଗେନ୍ତେ ବିନ୍ତିଅଡ଼ାଃ ନୁତୁମଃଆ ମେନ୍‌ଦ ଆପେ ନେଆଁଁକେ କୁମ୍ବୁଡ଼ୁକଆଃ ତାଇନଃ ଠାୟାଦ୍‌ପେ ବାଇୟାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ, ଏନା ସବେନ୍‌ ଆୟୁମ୍‌କେଦ୍‌ତେ, ୟୀଶୁକେ ଚିଲ୍‌କାକ ଗଜିୟା ମେନ୍ତେ ହରାକ ଦାଣାଁଁବାଡ଼ାକେଦାଃ । ସବେନ୍‌ ହଡ଼କଦ ୟୀଶୁଆଃ ଇନିତୁରେ ଆକ୍‌ଦାନ୍ଦାଅୟାନା ମେନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ବରଆଇତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ସିଙ୍ଗିହାସୁର୍‌ୟାନ୍‌ଚି ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ସାହାର୍‌ଏତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ସେତାଃ ଇଦାନ୍‌ତେ ହରାରେ ସେନଃ ଇମ୍‌ତା ଇନ୍‌କୁ ଲଆଦାରୁକେକ ନେଲ୍‌କେଦା । ଏନା ବୁଟାଏତେ ଚୁଟି ଜାକେଦ୍‌ ରହଡ଼୍‌ ଗଜାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ପାତ୍‌ରାସ୍‌ ସିଦାହୁଲାଙ୍ଗ୍‌ରାଃ କାଜି ପାହାମ୍‌କେଦ୍‌ତେ ମେତାଇୟାଏ “ନେଲେମେ, ହେ ଗୁରୁ, ଆମ୍‌ ସାର୍‌ପାଅଲେଦ୍ ଲଆଦାରୁ ରହଡ଼୍‌କାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ୟୀଶୁ ଚେଲାକକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ରେ ବିଶ୍ୱାସ୍‌ ଦହେପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, “ଜେତାଏ ହଡ଼ ନେ ବୁରୁକେ, ମାର୍‌ ବିରିଦ୍‌ମେ ଆଡଃ ଦରେୟାରେ ଉୟୁଗଃମେ ମେନ୍ତେ କାଜିରେ, ଆଡଃ ମନ୍‌ରେ କାଏ ଆଡ଼ାଃଉଡ଼ୁଃରେ ଆଡଃ ଇନିଃ ଆସିତେୟାଃ ସାର୍‌ତିଗି ହବାଅଆଃ ମେନ୍ତେ ବିଶ୍ୱାସେରେଦ, ଇନିଃ ସାନାଙ୍ଗ୍‌ତାନ୍‌ଲେକା ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ଏନାମେନ୍ତେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ବିନ୍ତି ଇମ୍‌ତା ଜେତ୍‌ନାଃପେ ଆସିଆ, ଏନ୍‌ ସବେନାଃ ନାମାକାଦାଃଲେ ମେନ୍ତେପେ ବିଶ୍ୱାସେରେଦ, ଆସିତେୟାଃ ସବେନାଃପେ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ଆଡଃ ବିନ୍ତି ନାଗେନ୍ତେପେ ତିଙ୍ଗୁନ୍‌ରେ ଜେତା ହଡ଼ଆଃ ବିରୁଧ୍‌ରେ ଜେତ୍‌ନାଃ ଆପେୟାଃ ଗୁହ୍ନାଁଁ ମେନାଃରେଦ, ଇନିଃକେ ଏନା ଛାମାଇପେ, ଏନାରେ ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ ଆପେକେୟଗି ଛାମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ମେନ୍‌ଦ ଆପେ କାପେ ଛାମାଇରେଦ, ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁହଁ ଆପେୟାଃ ପାପ୍‌ କାଏ ଛାମାଏଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ୟୀଶୁ ଆଡଃ ଚେଲାକ ଆଡଃଗି ଯୀରୁଶାଲେମ୍‌ତେ ହିଜୁଃୟାନାକ । ମାନ୍ଦିର୍‌ଅଡ଼ାଃରେ ୟୀଶୁ ସେନ୍‌ବାଡ଼ାତାନ୍ ଦିପିଲିରେ, ମୁଲ୍‌ ଯାଜାକ୍‌କ, ଆଇନ୍‌ ଇତୁକ ଆଡଃ ପ୍ରାଚିନ୍‌କ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ଆଡଃ, ଇନ୍‌କୁ କୁଲିକିୟାଃକ, “ଆମ୍‌ ଅକ ଆକ୍‌ତେୟାର୍‌ତେ ନେଆଁଁକମ୍‌ ରିକାତାନା ? ନେ କାମିକ ରିକାନାଗେନ୍ତେ ଅକଏ ନେ ଆକ୍‌ତେୟାର୍‌ ଏମାକାଦ୍‌ମେଆ ?” ");
INSERT INTO unx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ହଁ ମିଆଁଦ୍‌ କାଜିଙ୍ଗ୍‌ କୁଲିପେୟା, ଏନା ଉଦୁବାଇଙ୍ଗ୍‌ପେ, ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ହଁ ଅକ ପେଡ଼େଃତେ ନେଆଁଁକଇଙ୍ଗ୍‌ ରିକାତାନା, ଏନାଇଙ୍ଗ୍‌ ଉଦୁବାପେୟା । ");
INSERT INTO unx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଯୋହାନ୍‌ଆଃ ବାପ୍ତିସ୍ମା ସିର୍ମାରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ଚି ମାନୱାତାଃଏତେ ତାଇକେନା ? ନେଆଁଁ, ମାର୍‌ କାଜିୟାଇଙ୍ଗ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ଇନ୍‌କୁ ଆକ ଆକରେକ କାପ୍‌ଜିୟାନା, “ଆବୁ ନେ କାଜିରେ ଚିନାଃବୁ କାଜିରୁହାଡ଼ିୟା ? ‘ସିର୍ମାରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ’ ମେନେରେଦ, ଇନିଃ ‘ଚିକାନାଙ୍ଗ୍‌ ଯୋହାନ୍‌ରେ କାପେ ବିଶ୍ୱାସ୍‌କେଦା’ ମେତାବୁଆଏ ?” ");
INSERT INTO unx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ମେନ୍‌ଦ ମାନୱାକତାଃଏତେ ମେନ୍ତେ କାଜିନାଙ୍ଗ୍‌ ବରକେଦାଃକ ଚିୟାଃଚି, ଇନ୍‌କୁ ହଡ଼କକେ ବର ତାଇକେନାକ, ଚିୟାଃଚି ସବେନ୍‌ ହଡ଼କ ଯୋହାନ୍‌ ଆୟାର୍‌କାଜିନିଃ ତାନିଃ ମେନ୍ତେ ମାନାତିଙ୍ଗ୍‌ଇ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ଏନାମେନ୍ତେ ଇନ୍‌କୁ ୟୀଶୁକେ କାଜିରୁହାଡ଼୍‌କିୟାଃକ, “ଆଲେ କାଲେ ସାରିଆଃ ।” ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ହଁ ଅକ ପେଡ଼େଃତେ ଏନାକଇଙ୍ଗ୍‌ ରିକାତାନା, କାଇଙ୍ଗ୍‌ ଉଦୁବାପେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ଏନ୍ତେ ୟୀଶୁ ଜନ୍‌କା କାଜିତେ ଇନ୍‌କୁକେ ଜାଗାର୍‌ ଏଟେଦ୍‌କେଦ୍‌ଆଏ, “ମିଆଁଦ୍‌ ହଡ଼ ମିଆଁଦ୍‌ ଦାଖ୍‌ବାକ୍‌ଡ଼ି ବାଇକେଦାଏ, ଆଡଃ କେସେଦ୍‌ବିୟୁର୍‌କେଦାଏ, ଘାନା ନାଗେନ୍ତେ ଗାଡା ଉର୍‌କେଦାଏ, ଆଡଃ ହରମେନ୍ତେ ହରଠାୟାଦ୍‌ ବାଇକେଦାଏ, ଏନ୍ତେ ଇନିଃ ଏନ୍‌ ଦାଖ୍‌ବାକ୍‌ଡ଼ି କାର୍‌ କାମିତାନ୍ ହଡ଼କକେ ଏମ୍‌କେଦ୍‌ତେ ସାଙ୍ଗିନ୍‌ ଦିଶୁମ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ଜ ଗଦଃ ସାହା ତେବାଃୟାନ୍‌ଚି, ଦାଖ୍‌ବାକ୍‌ଡ଼ିରେୟାଃ ଜ ନାମେ ନାଗେନ୍ତେ ଇନିଃ ମିଆଁଦ୍‌ ଦାସିକେ ଏନ୍‌ କାର୍‌ କାମିତାନ୍ ହଡ଼କତାଃତେ କୁଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","କାର୍‌ କାମି ହଡ଼କଦ ଏନ୍‌ ଦାସିକେ ସାବ୍‌କିତେକ ଦାଲ୍‌କିୟାଃ, ଆଡଃ ସାମାତିଃଇକ କୁଲ୍‌ରୁହାଡ଼୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ଏନ୍ତେ ଇନିଃ ଏଟାଃ ଦାସିକେ ଇନ୍‌କୁତାଃ କୁଲ୍‌କିୟାଏ, ଇନିଃକେଦ କାର୍‌କାମି ହଡ଼କ ବହଃରେ ଦାଲିତାନ୍‌ଲଃ ହିଲାଙ୍ଗ୍‌କେଦ୍‌ତେ କୁଲ୍‌ରୁହାଡ଼୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ଏନ୍ତେ ଇନିଃ ଆଡଃମିଆଁଦ୍‌ ଦାସିକେ କୁଲ୍‌କିୟାଏ, ଆଡଃ ଇନିଃକେହଁ ଗଏଃକିୟାକ । ଇନିଃ ପୁରାଃ ଏଟାଃ ଦାସିକକେ କୁଲ୍‌କେଦ୍‌କଆଏ, ଚିମିନ୍‌କକେ ଦାଲ୍‌କେଦ୍‌କଆକ, ଆଡଃ ଚିମିନ୍‌କକେ ଗଏଃକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ନାହାଁଃ ମିଆଁଦ୍‌ଗି କୁଲଃନିଃ ସାରେଜାକାନାଏ, ଇନିଃଦ ଆୟାଃ ଦୁଲାଡ଼୍‌ ହନ୍‌କଡ଼ା ତାନିଃ । ନାହାଁଃ ଇନ୍‌କୁ ହନିଙ୍ଗ୍‌କଡ଼ାକେ ମାଇନିୟାକ, ମେନ୍‌କେଦ୍‌ତେ ଟୁଣ୍ଡୁରେ ଇନିଃ ଆୟାଃ ଏନ୍‌ ହନ୍‌କେ ଇନ୍‌କୁତାଃତେ କୁଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","କାର୍‌କାମି ହଡ଼କ ମେପେନ୍‌ୟାନା, ‘ନିଃଗି ଏନ୍‌ ଗମ୍‌କେୟାଃ ହନ୍‌ତାନିଃ, ମାର୍‌ବୁ ଗଜିୟା ଆଡଃ ଇନିୟାଃ ହାନାଟିଙ୍ଗ୍‌ ଆବୁଆଃ ହବାଅଆଃ ।’ ");
INSERT INTO unx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ଏନାମେନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ସାବ୍‌କିତେ ଗଏଃକିୟାକ, ଆଡଃ ଇନିୟାଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ିଏତେ ହୁରାଙ୍ଗ୍‌ ଅଡଙ୍ଗ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ଦାଖ୍‌ବାକ୍‌ଡ଼ି ଗମ୍‌କେ ତାବ୍‌ଦ ଚିନାଃଆଏ ଚିକାୟା ?” ମେନ୍ତେ ୟୀଶୁ କୁଲିକେଦ୍‌କଆଏ । “ଇନିଃଦ ହିଜୁଃକେଦ୍‌ତେ ଏନ୍‌ କାର୍‌ କାମିହଡ଼କକେ ଗଏଃକଆଏ, ଆଡଃ ବାଖ୍‌ଡ଼ିତାୟାଃକେ ଏଟାଃ କାର୍‌ କାମିହଡ଼କକେ ଏମାକଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ଚିୟାଃ ଆପେ ଧାରାମ୍‌ପୁଥିରେ ନେ କାଜି କାପେ ପାଢ଼ାଅକାଦାଃ ? “‘ବାବାଇକ ଅକନ୍‌ ଦିରିକେ ଆତମ୍‌ ଏଣ୍ଡାଃଲେଦାକ ଏନାଦ କଚାରାଃ ମୁଲ୍‌ଦିରି ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ନେ କାମିଦ ପ୍ରାଭୁଗି ରିକାକେଦାଏ ଆଡଃ ଏନାଦ ଆବୁଆଃ ନେନେଲ୍‌ରେ ଆକ୍‌ଦାନ୍ଦାଅଗିୟା ।’” ");
INSERT INTO unx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ଯିହୁଦୀ ନେତାକଆଃ ବିରୁଧ୍‌ରେ ନେ ଜନ୍‌କା କାଜି କାଜିକେଦାଏ ଏନା ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ଇନିଃକେ ସାସାବ୍ ସାନାଙ୍ଗ୍‌ତାନ୍‌କ ତାଇକେନା, ମେନ୍‌ଦ ଇନ୍‌କୁ ଗାଦେଲ୍‌ ହଡ଼କକେ ବରକେଦ୍‌ତେ ଇନିଃକେ ବାଗିକେଦ୍‌ତେକ ନିର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ଆଡଃ ୟୀଶୁଆଃ କାଜି ହରାତେ ସାବି ନାଗେନ୍ତେ ଇନ୍‌କୁ ଫାରୁଶୀକଏତେ ଆଡଃ ହେରୋଦ୍‌ରାଃ ଚିମିନ୍‌ ହଡ଼କକେ ଇନିଃତାଃତେକ କୁଲ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ଇନ୍‌କୁ ଆୟାଃତାଃ ହିଜୁଃୟାନ୍‌ଚିକ କାଜିକିୟା, “ହେ ଗୁରୁ, ଆମ୍‌ଦ ସାର୍‌ତିନିଃ ତାନ୍‌ମେ ଆଡଃ ଜେତାଏକେ କାମ୍‌ ବରଆଃ ମେନ୍ତେ ଆଲେ ସାରିତାନାଲେ, ଆମ୍‌ଦ ହଡ଼ରାଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ କାମ୍‌ ନେଲାଃ, ମେନ୍‌ଦ ସାର୍‌ତିଗି ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ହରା ଇତୁଆଃମେ, ମାର୍‌ କାଜିୟାଲେମେ, ଆଇନ୍‌ ଲେକାତେ ଆଲେକେ କାଇସାର୍‌କେ କାର୍‌ ଏମଃ ଲାଗାତିୟାଃଁ ଚି କାହା ?” ");
INSERT INTO unx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁଆଃ ବେଦା ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆ, “ଚିନାଃ ମେନ୍ତେପେ ବିଡ଼ାଅଇଙ୍ଗ୍‌ ତାନା ? ମୁସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକା ଆଉୱାଇଙ୍ଗ୍‌ପେ, ଏନା ନେଲେଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ଇନ୍‌କୁ ମିଆଁଦ୍‌ ସିକା ଆୟାଃତାଃକ ଆଉକେଦା, ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆ, “ନେ ମୁରୁତ୍‌ ଆଡଃ ନୁତୁମ୍‌ ଅକଏୟାଃ ତାନାଃ ?” ଇନ୍‌କୁ “କାଇସାର୍‌ରାଃକ” କାଜିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଏନ୍‌ରେଦ ଅକ୍‌ନାଃ କାଇସାର୍‌ରାଃ ତାନାଃ ଏନା କାଇସାର୍‌କେଗି ଏମାଇପେ, ଆଡଃ ଅକ୍‌ନାଃ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ତାନାଃ ଏନା ପାର୍‌ମେଶ୍ୱାର୍‌କେଗି ଏମାଇପେ ।” ଆଡଃ ୟୀଶୁଆଃ ନେ କାଜିରେ ଇନ୍‌କୁ ହାଏକାଟ୍‍ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ଜୀଉବିନିରିଦ୍‌ରେ କା ବିଶ୍ୱାସେତାନ୍‌ ସାଦୁକିକଏତେ ଚିମିନ୍‌ ହଡ଼କ ୟୀଶୁତାଃତେ ହିଜୁଃକେଦ୍‌ତେ ଇନିଃକେ କୁଲିକିୟାଃକ : ");
INSERT INTO unx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ହେ ଗୁରୁ, ମୁଶା ଆଲେ ନାଗେନ୍ତେ ଅଲାକାଦାଏ, ଜେତାଏ ହଡ଼ଆଃ ଦାଦାତେ ବେଗାର୍‌ ହନ୍‌ଗାଁଣାକ ହବାଅଃ ସିଦାରେ ଗଏଃକେନଃ ରେଦ, ଆୟାଃ ହାଗାତେ ଇନିୟାଃ କୁଡ଼ିକେ ଆଣ୍‌ଦିୟଃକାଏ, ଆଡଃ ଦାଦାତେ ନାଙ୍ଗ୍‌ ହନ୍‌ଗାଁଣା ଜାନାମ୍‌କକାଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ମିଦ୍‌ ଦିପିଲିରେ ସାତ୍‌ ହାଗିୟା ତାଇନ୍‌କେନାକ ମାରାଙ୍ଗ୍‌ନିଃ ଆଣ୍‍ଦିକେଦ୍‍ତେ ବେଗାର୍‌ ହନ୍‌ଗାଁଣାତେ ଗଏଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ଏଟାଃନିଃ ଏନ୍‌ ରାଣ୍ଡିକେ ଆଣ୍‌ଦିୟାନାଏ ଆଡଃ ଇନିଃହ ହନ୍‌ଗାଁଣା ହବାଅଃ ସିଦାରେ ଗଏଃୟାନା, ଆପିୟାନିଃହଗି ଏନ୍‌କାୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ଏନ୍‌କାତେ ସାତ୍‌ ହାଗିୟାକ ବେଗାର୍ ହନ୍‌ଗାଁଣାତେକ ଗଏଃୟାନା, ସବେନ୍‌କ ତାୟମ୍‌ତେ ଏନ୍‌ କୁଡ଼ିୟଗି ଗଏଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ତାବ୍‌ଦ ଜୀଉବିନିରିଦ୍‌ରେ, ସବେନ୍‌କ ଜୀଉବିରିଦଃ ଦିପିଲିରେ, ଏନ୍‌ କୁଡ଼ି ଇନ୍‌କୁଏତେ ଅକଏୟାଃ କୁଡ଼ି ହବାଅଆଃଏ ? ଚିୟାଃଚି ସାତ୍‌ ହାଗିୟା ସବେନ୍‌କଦ ଇନିଃକେ ଆଣ୍‌ଦିକାନ୍‌ ତାଇକେନାକ ।” ");
INSERT INTO unx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଆପେ ଧାରାମ୍‌ପୁଥି ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପେଡ଼େଃକ କାପେସାରି ହରାତେ ଆଦାକାନାପେ । ");
INSERT INTO unx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ଗଏଃକେଦ୍‌ତେ ଜୀଉ ବିନିରିଦ୍‌ ତାୟମ୍‌ତେ ହଡ଼କ କାକ ଆଣ୍‌ଦିନାଃ ଆଡଃ କାକ ଆଣ୍‌ଦି ଏମଃଆ, ଇନ୍‌କୁ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କ ଲେକାକ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ଆଡଃ ଗଏଃକାନ୍‌କଆଃ ଜୀଉବିରିଦ୍‌ରାଃ କାଜିପେ କୁଲିଙ୍ଗ୍‌ତାନା, ମୁଶା ଅଲାକାନ୍‌ ପୁଥିରେ ଅଲାକାନା, ଜୁଲଃତାନ୍ ଚୁପାଦ୍‌ରାଃ କାଜି କାପେଚି ପାଢ଼ାଅକାନା ? ନେ ସବେନ୍‌କ ଗଜାକାନ୍‌ରେୟଗି, ଚିଲ୍‌କା ପାର୍‌ମେଶ୍ୱାର୍‌ ମୁଶାକେ କାଜିକିୟାଏ, ଆଇଙ୍ଗ୍‌ ଆବ୍ରାହାମ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଇସାକ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଆଡଃ ଯାକୁବ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ପାର୍‌ମେଶ୍ୱାର୍‌ଦ ଗଜାକାନ୍‌କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ନାହାଁଲିଃ ମେନ୍‌ଦ ଜୀନିଦ୍‌ ହଡ଼କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଃ । ଆପେ ପୁରାଃଗିପେ ଆଦାକାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ମିଆଁଦ୍‌ ଆଇନ୍‌ ଇତୁନିଃ ଇନ୍‌କୁକେ କାପାଜିତାନ୍ ଆୟୁମ୍‌କେଦ୍‌କଆଏ । ୟୀଶୁ ଏନ୍‌ ସାଦୁକିକକେ ଚିଲ୍‌କା ବୁଗିଲେକାତେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ ଏନା ଆଟ୍‌କାର୍‌ ଉରୁମ୍‌କେଦ୍‌ଚି, ଇନିଃ କୁଲିକିୟାଏ, “ସବେନ୍‌ ଆନ୍‌ଚୁକଏତେ, ମାରାଙ୍ଗ୍‌ ଆନ୍‌ଚୁ ଅକଆଃ ତାନାଃ ?” ");
INSERT INTO unx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ସବେନାଃଏତେ ମାରାଙ୍ଗ୍‌ ଆନ୍‌ଚୁଦ ନେଆଁଁତାନାଃ, ହେ ଇସ୍ରାଏଲ୍‌, ଆୟୁମେମେ, ପ୍ରାଭୁ ଆବୁଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଏସ୍‌କାର୍‌ଗି ପ୍ରାଭୁତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ପ୍ରାଭୁ ଆମାଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଆମାଃ ସବେନ୍‌ ମନ୍‌ତେ, ଆଡଃ ଆମାଃ ସବେନ୍‌ ଜୀଉତେ, ଆଡଃ ଆମାଃ ସବେନ୍‌ ସେଣାଁଁତେ, ଆଡଃ ଆମାଃ ସବେନ୍‌ ପେଡ଼େଃତେ ଦୁଲାଡ଼ିମେ । ");
INSERT INTO unx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ଏଟାଃ ଆନ୍‌ଚୁଦ ନେଆଁଁତାନାଃ, ଆମାଃ ହପର୍‌ଜାପାଃରେନିଃକେ ଆମ୍‌ଲେକା ଦୁଲାଡ଼ିମେ । ନେ ବାରିଆଃ ଆନ୍‌ଚୁଏତେ, ମାରାଙ୍ଗ୍‌ ଆଡଃ ଜେତାଏ ଆନ୍‌ଚୁ ବାନଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ଆଇନ୍‌ ଇତୁକ ୟୀଶୁକେ କାଜିକିୟାଃ, “ଠାଉକାଗିମ୍ କାଜିତାନା, ଏ ଇତୁନିଃ, ଆମାଃ କାଜି ସାର୍‌ତିଗିଆଃ, ଆମାଃ କାଜି ଲେକାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ମିଆଁଦ୍‌ଗିଆଏଃ, ଆଡଃ ଇନିଃକେ ବାଗିକେଦ୍‌ତେ ଏଟାଃ ଜେତାଏ ପାର୍‌ମେଶ୍ୱାର୍‌ ବାଙ୍ଗାଇଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ଆଡଃ ହଡ଼କେ, ଆୟାଃ ସବେନ୍‌ ମନ୍‌ତେ, ଆଡଃ ଆୟାଃ ସବେନ୍‌ ସେଣାଁଁତେ, ଆଡଃ ଆୟାଃ ସବେନ୍‌ ପେଡ଼େଃତେ ଇନିଃକେ ଦୁଲାଡ଼୍‌ ଲାଗାତିୟାଃଁ ଆଡଃ ଆୟାଃ ହପର୍‌ଜାପାଃନିଃକେହ ଆୟାଃ ଲେକା ଦୁଲାଡ଼୍‌ ଲାଗାତିୟାଃଁ । ନେ ବାରିଆ ଆନ୍‌ଚୁ ମାନାତିଙ୍ଗ୍‌ତେଆଃଦ ଉରୁବଃ ଦାଣେଁ ଚାଏ ସବେନ୍‌ ଏଟାଃ ଦାଣେଁରାକାବ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ କାମିତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ଇନିଃ ସେଣାଁଁନ୍‌ ଲେକାତେ କାଜିକେଦାଏ, ଏନା ନେଲ୍‌କେଦ୍‌ତେ ୟୀଶୁ ଇନିଃକେ ମେତାଇୟାଏ, “ଆମ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ଏତେ ସାଙ୍ଗିନ୍‌ରେ ବାଙ୍ଗ୍‌ମେଆଁଃ ।” ଆଡଃ ଏନ୍‌ତାୟମ୍‌ତେ ଜେତାଏ ଇନିଃକେ ଜେତ୍‌ନାଃ କୁଲିନାଙ୍ଗ୍‌ କାକ ସାହାଁସ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଇତୁତାନ୍‌ ଇମ୍‌ତା ୟୀଶୁ କୁଲିକେଦ୍‌କଆଏ, “ଖ୍ରୀଷ୍ଟ୍‌ ଦାଉଦ୍‌ଆଃ ହନ୍‌ ତାନିଃ ମେନ୍ତେ ଆଇନ୍‌ ଇତୁକ ଚିଲ୍‌କାତେକ କାଜିୟାଃ ? ");
INSERT INTO unx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ଦାଉଦ୍‌ ଆଇଃକ୍‌ଗି ପାବିତାର୍‌ ଆତ୍ମାରାଃ ଉସ୍‌କୁର୍‌ତେ କାଜିକେଦାଏ, “‘ପ୍ରାଭୁ ଆଇଁୟାଃ ପ୍ରାଭୁକେ ମେତାଇୟାଏ; ଆମାଃ ବାଇରିକକେ ଆମାଃ କାଟାସୁବାରେ କା ଆଉ ଜାକେଦ୍‌ ଆଇଁୟାଃ ଜମ୍‌ତିସାଃରେ ଦୁବାକାନ୍‌ମେ ।’” ");
INSERT INTO unx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ଦାଉଦ୍‌ ଆଇଃକ୍‌ଗି ଖ୍ରୀଷ୍ଟ୍‌କେ ପ୍ରାଭୁ ମେତାଇତାନ୍‌ରେଦ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାଲାକାନ୍‌ ବଞ୍ଚାଅନିଃ ଖ୍ରୀଷ୍ଟ୍‌ ଚିଲ୍‌କାତେ ଦାଉଦ୍‌ଆଃ ହନ୍ତେକଡ଼ା ତାନିଃ ? ଗାଦେଲ୍‌ ହଡ଼କ ୟୀଶୁଆଃ କାଜି ସୁକୁତେକ ଆୟୁମ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ୟୀଶୁ ଇନ୍‌କୁକେ ଇତୁତାନ୍‌ଲଃ ମେତାଦ୍‌କଆଏ, “ଆଇନ୍‌ ଇତୁକତାଃଏତେ ଚିର୍ଗାଲାକାନ୍‌ପେ । ଇନ୍‌କୁ ଜିଲିଙ୍ଗ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନ୍‌ବାଡ଼ା, ଆଡଃ ପିଟ୍‌ ପିଡ଼ିକରେ ଜହାର୍‌ତେଲା, ");
INSERT INTO unx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ଆଡଃ ଇନ୍‌କୁକେ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଆୟାର୍‌ରେ ଦୁବ୍‌ନାଙ୍ଗ୍‌, ଆଡଃ ମାରାଙ୍ଗ୍‌ ଜମ୍‌ନୁଁକରେ ସିଦା ଠାୟାଦ୍‌ରେ ଦୁବ୍‌ନାଙ୍ଗ୍‌ ସୁକୁକଆ । ");
INSERT INTO unx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ଇନ୍‌କୁ ରାଣ୍ଡିକୁଡ଼ିକଆଃ ଅଡ଼ାଃକ ଉଦେତାନା ଆଡଃ ବେଦାତେ ଜିଲିଙ୍ଗ୍‌ ଜିଲିଙ୍ଗ୍‌ଗିକ ବିନ୍ତିୟା । ଏନ୍‌ଲେକାନ୍‌ ହଡ଼କଦ ଆଦ୍‌କା ସାଜାଇକ ନାମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ୟୀଶୁ ମାନ୍ଦିର୍‌ ଖାଜ୍‌ନା ବାକାସ୍‌ ନାଡ଼େଃରେ ଦୁବାକାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ହଡ଼କକେ ଏନାରେ ପାଏସା ସାଜୁତାନ୍‌ ନେଲ୍‌କେଦ୍‌କଆଏ । ପୁରାଃ କିସାଁଣ୍‌ ହଡ଼କ ପୁରାଃଗି ପାଏସା ଉୟୁଃକେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ଏନ୍ତେ ମିଆଁଦ୍‌ ରେଙ୍ଗେଃ ରାବାଙ୍ଗ୍‌ ରାଣ୍ଡିକୁଡ଼ି ହିଜୁଃକେଦ୍‌ତେ ମିଦ୍‌ଦୋକ୍‌ଡ଼ା ଗନଙ୍ଗ୍‌ରାଃ ବାରିଆଃ ହୁପ୍‌ଡିଙ୍ଗ୍‌ ତାମ୍ବା ସିକା ଉୟୁଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ହାକାଅକେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଖାଜ୍‌ନା ବାକାସ୍‌ରେ ଏମ୍‌କେଦ୍ ସବେନ୍‌ ହଡ଼କ ଏତେ, ନେ ଗାରିବ୍‌ ରାଣ୍ଡିକୁଡ଼ି ଥିମ୍ୱା ଏମାକାଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ଏଟାଃ ହଡ଼କ ଆକଆଃ ଆଦ୍‌କା ମେନାଃତେୟାଃଏତେ କାଟିଃଲେକାକ ଏମ୍‌କେଦାଃ; ମେନ୍‌ଦ ନିଃ ରେଙ୍ଗେଃ ରାବାଙ୍ଗ୍‌ ତାଇନ୍‌ରେୟ ଆୟାଃ ଜୀଉ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ଆୟାଃତାଃରେ ତାଇକେନ୍‌ତେୟାଃ ସବେନାଃଏ ଏମ୍‌କେଦା ।” ");
INSERT INTO unx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଆଡଃ ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃଏତେ ସେନଃତାନ୍‌ ଦିପିଲିରେ ଆୟାଃ ଚେଲାକଏତେ ମିହୁଡ଼୍‌ କାଜିକିୟାଏ, “ଏ ଇତୁନିଃ, ନେ ମାପ୍‌ରାଙ୍ଗ୍‌ ଅଡ଼ାଃକରେ ନେଲେମେ, ଚିଲ୍‌କାନ୍‌ ମାପ୍‌ରାଙ୍ଗ୍‌ ଦିରିକ ଆଡଃ ଚିଲ୍‌କାନ୍‌ ସୁଗାଡ଼ାନ୍‌ ଦିରିକ ମେନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟା, “ନେ ମାପ୍‌ରାଙ୍ଗ୍‌ ଅଡ଼ାଃକ ଚିମ୍‌ ନେଲେତାନା ? ଦିରି ଚେତାନ୍‍ ଦିରି ତିରିୟାଁକାନ୍‍ କା ତାଇନା, ସବେନାଃ ହାଦୁଡ଼ଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ମାନ୍ଦିର୍‌ ସାମ୍‌ନାଙ୍ଗ୍‌ରେଆଃ ଜାଇତୁନ୍‌ ବୁରୁ ଚେତାନ୍‌ରେ ୟୀଶୁ ଦୁବାକାନାଏ ତାଇକେନ୍‌ ଦିପିଲିରେ, ପାତ୍‌ରାସ୍‌, ଯାକୁବ୍‌, ଯୋହାନ୍‌ ଆଡଃ ଆନ୍ଦ୍ରିୟ ଇନିଃତାଃ ଏସ୍‌କାର୍‌ରେ ହିଜୁଃକେଦ୍‌ତେକ କୁଲିକିୟା, ");
INSERT INTO unx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ନେଆଁଁକ ଚିଉଲା ହବାଅଆଃ ? ଆଡଃ ନେ କାଜି ପୁରାଅଃଲେକାରେ ଅକନ୍‌ ଚିହ୍ନାଁ ଉଦୁବଃଆ ଏନା ଉଦୁବାଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","“ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, ଚିର୍ଗାଲାକାନ୍‍ପେ, ଜେତାଏ ଆଲକାକ ବେଦାପେକା । ");
INSERT INTO unx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ପୁରାଃ ହଡ଼କଦ ଆଇଁୟାଃ ନୁତୁମ୍‍ତେକ ହିଜୁଃଆ ଆଡଃ ‘ଆଇଙ୍ଗ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ତାନିଙ୍ଗ୍‌’ ମେନ୍ତେକ କାଜିୟା ଆଡଃ ପୁରାଃ ହଡ଼କକେ ବେଦାକଆକ । ");
INSERT INTO unx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ଆପେ ମାପାଃତୁପୁଇଙ୍ଗ୍‌ ଆଡଃ ମାପାଃତୁପୁଇଙ୍ଗ୍‌ରାଃ କାଜିପେ ଆୟୁମେରେଦ ବରତେ ଆଲ୍‌ପେ ଆକ୍‌ବାକାଅଆଃ, ନେଆଁଁ ସବେନାଃଦ ହବାଅଃଗି ଲାଗାତିୟାଃଁ, ମେନ୍‌ଦ ଏନ୍‌ ଦିପିଲିହ ଟୁଣ୍ଡୁ ନାହାଁଲାଃ । ");
INSERT INTO unx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ଚିୟାଃଚି ଦିଶୁମ୍‌ ବିରୁଧ୍‌ରେ ଦିଶୁମ୍‌ ଆଡଃ ରାଇଜ୍‌ ବିରୁଧ୍‌ରେ ରାଇଜ୍‌ ଲାଡ଼ାଇ ହବାଅଆଃ, ସବେନ୍‌ ଠାୟାଦ୍‌ରେ ଅତେ ଏକ୍‌ଲାଅଃଆ ଆଡଃ ରିଙ୍ଗାଅଃଆ । ମେନ୍‌ଦ ନେ ସବେନାଃ ହନ୍‌ ଜାନାମଃ ଇମ୍‌ତାରାଃ ଦୁକୁରେୟାଃ ଏନେଟେଦ୍‌ ଲେକାନାଃ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“ଆପେକେ ଚିର୍ଗାଲାକାନ୍‌ ତାଇନଃ ଲାଗାତିୟାଃଁ, ଇନ୍‌କୁଦ ପାଞ୍ଚେଟ୍‌କରେକ ଏମ୍‌ଏଣ୍ଡାଃପେୟା ଆଡଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଦାଲ୍‌ପେୟାକ । ଆପେ ଆଇଁୟାଃ ଚେଲାକ ତାନ୍‌ପେ ମେନ୍ତେ, ସୁକୁକାଜି ଉଦୁବେ ନାଗେନ୍ତେ ଆପେକେ ହାକିମ୍ ଆଡଃ ରାଜାକତାଃ ତିଙ୍ଗୁ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ଆଡଃ ଟୁଣ୍ଡୁ ଦିପିଲି ସେଟେର୍‌ ସିଦାରେ ସୁକୁକାଜି ସବେନ୍‌ ଜାତିରାଃ ହଡ଼କତାଃରେ ଉଦୁବ୍‌ଗି ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ଚିମ୍‌ତାଙ୍ଗ୍‌ ଆପେକେ ସାବ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ କାଚାଇରିତେ ଇଦିପେୟାକ, ଇମ୍‌ତା ଚିନାଃବୁ କାଜିୟା ମେନ୍ତେ ସିଦାରେ ଆଲ୍‌ପେ ଉଡ଼ୁଃଇୟା ଏନ୍‌ ଦିପିଲି ହିଜୁଃଆ ଇମ୍‌ତା ଆପେକେ ଅକଆଃ କାଜି ନାଗେନ୍ତେ ଏମଃଆ ଏନାପେ କାଜିୟା । ଚିୟାଃଚି ଏନ୍ତାଃରେ ଅକ କାଜିପେ କାଜିୟା ଏନାଦ ଆପେତେଗି କା, ମେନ୍‌ଦ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ପେଡ଼େଃ ହରାତେପେ କାଜିୟା । ");
INSERT INTO unx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ହାଗା ଆୟାଃ ହାଗାତେକେ ଆଡଃ ଆପୁ ଆୟାଃ ହନ୍‌କେ ଗଜି ନାଗେନ୍ତେ ଏମ୍‌ଏଣ୍ଡାଇଆଃଏ, ଆଡଃ ହନ୍‌କ ଆକଆଃ ଏଙ୍ଗାଆପୁକଆଃ ବିରୁଧ୍‌ରେକ ବିରିଦାଃ ଆଡଃ ଇନ୍‌କୁକେ ଗଏଃ ଇଚିକଆକ । ");
INSERT INTO unx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ଚିୟାଃଚି ଆପେ ଆଇଁୟାଃ ଚେଲାକ ତାନ୍‌ପେ ସବେନ୍‌ ହଡ଼କ ଆପେକେ ହିଲାଙ୍ଗ୍‌ପେୟାକ, ମେନ୍‌ଦ ଜେତାଏ ଟୁଣ୍ଡୁ ଜାକେଦ୍‌ ସାହାତିଙ୍ଗ୍‌ତାନ୍‌ଲଃ ତିଙ୍ଗୁ କେଟେୟାକାନ୍ ତାଇନ୍‌ରେଦ ବାଞ୍ଚାଅଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ଆପେ ଚିମ୍‌ତା, ‘ଏନ୍‌ ଅଡ଼େଜଃ ସତ୍‌ରାକାନ୍‌ନିଃ’ ଅକ୍‌ତାଃରେଚି ଇନିୟାଃ କା ତାଇନଃ ଲାଗାତିଙ୍ଗ୍‌ ଠାୟାଦ୍‌ରେ ତିଙ୍ଗୁଆକାନ୍‍ପେ ନେଲିୟା ।” ପାଢ଼ାଅନିଃ ନେଆଁଁରାଃ ମୁଣ୍ଡି ଆଟ୍‌କାର୍‍ଉରୁମେକାଏ, ଇମ୍‌ତା ଯିହୁଦା ପାର୍‌ଗାନ୍‌ରେ ତାଇନଃତାନ୍‌କ ବୁରୁତେକ ନିର୍‌ତେବାଃକା । ");
INSERT INTO unx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ଅକ ହଡ଼ ଆୟାଃ ଅଡ଼ାଃ ସାଡ଼୍‌ମିରେ ମେନାଇୟାଃ ଇନିଃ ଆୟାଃ ଜେତ୍‌ନାଃ ଇଦିମେନ୍ତେ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ ଅଡ଼ାଃତେ ଆଲକାଏ ବଲଃକା । ");
INSERT INTO unx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ପିଡ଼ି ଲୟଙ୍ଗ୍‌ରେ ତାଇନ୍‌ନିଃ, ଇନିଃ ଆୟାଃ ଲିଜାଃ ଇଦିମେନ୍ତେ ଅଡ଼ାଃତେ ଆଲକାଏ ରୁହାଡ଼୍‌କା । ");
INSERT INTO unx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ମେନ୍‌ଦ ଏନ୍‍ ଦିପିଲିରେନ୍‌ ବାର୍ଜିଆକାନ୍‍ କୁଡ଼ିକଆଃ ଆଡଃ ତଆ ନୁନୁଆକତାନ୍‍ ଏଙ୍ଗାକଆଃ ନାଗେନ୍ତେ ଚିମିନ୍‌ ବରୱାନ୍‌ଗି ଦୁକୁ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ରାବାଙ୍ଗ୍‌ସାହା ନେଆଁଁ ଆଲକା ହବାଅଃକା ମେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ବିନ୍ତିପେ, ");
INSERT INTO unx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ଚିୟାଃଚି ଏନ୍‌ ମାହାଁକରାଃ ଦୁକୁଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ବାଇୟାକାଦ୍‌ରେଆଃ ଏନେଟେଦ୍‌ଏତେ ନାହାଁଃ ଜାକେଦ୍‌ ଚିଉଲାଅ କା ହବାକାନା ଆଡଃ ଚିଉଲାଅ କା ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ମେନ୍‌ଦ ପ୍ରାଭୁ ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌କକେ କାଏ କାମ୍‌ତିକାରେଦ ଜେତାଏ କାକ ବାଞ୍ଚାଅଃତେୟାଃ, ମେନ୍‌ଦ ଆୟାଃ ସାଲାକାନ୍‍ ହଡ଼କଆଃ ନାଗେନ୍ତେ ଏନ୍‍ ହୁଲାଙ୍ଗ୍‌କକେ କାମ୍‌ତିୟାକାଦା । ");
INSERT INTO unx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ଏନ୍‌ ଦିପିଲିରେ ଜେତାଏ ଆପେକେ, ‘ନେଲିପେ, ଖ୍ରୀଷ୍ଟ୍‌ ନେତାଃରିୟା’ ଚାଏ ‘ହାନ୍ତାଃରିୟା,’ ମେତାପେରେଦ ଇନିଃକେ ଆଲ୍‌ପେ ବିଶ୍ୱାସୀଆ । ");
INSERT INTO unx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ଚିୟାଃଚି ହସଡ଼ ଖ୍ରୀଷ୍ଟ୍‌ ଆଡଃ ହସଡ଼ ନାବୀକ ବିରିଦାଃ ଆଡଃ ଇନ୍‌କୁ ମାପ୍‌ରାଙ୍ଗ୍‌ ଚିହ୍ନାଁ ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ରିକାଉଦୁବେଆ, ଆଡଃ ହବାଦାଡ଼ିୟଃରେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାଲାକାନ୍‍କକେହଁ ବେଦାକଆକ । ");
INSERT INTO unx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ଏନାମେନ୍ତେ ଚିର୍ଗାଲାକାନ୍‌ପେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ନେଡା ହିଜୁଃ ସିଦାରେଇଙ୍ଗ୍‌ ଉଦୁବାଦ୍‌ପେୟା । ");
INSERT INTO unx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ଏନ୍‌ ଦିପିଲିରେୟାଃ ଦୁକୁ ତାୟମ୍‌ତେ, ସିଙ୍ଗି ନୁବାଗଃଆ, ଆଡଃ ଚାଣ୍ଡୁଃ ଆୟାଃ ମାର୍ସାଲ୍ କାଏ ଏମେୟା, ");
INSERT INTO unx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ଇପିଲ୍‌କ ସିର୍ମାଏତେକ ଉୟୁଗଃଆ, ଆଡଃ ସିର୍ମାରେୟାଃ ପେଡ଼େଃୟାନ୍‌ତେୟାଃକ ଏକ୍‌ଲାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌ ହଡ଼କ ପୁରାଃ ପେଡ଼େଃତେ ଆଡଃ ମାନାରାଙ୍ଗ୍‌ଲଃ ରିମିଲ୍‌ରେ ହିଜୁଃତାନ୍‌କ ନେଲିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାଲାକାନ୍ ହଡ଼କକେ ଅତେଦିଶୁମ୍‌ରାଃ ନେ ଟୁଣ୍ଡୁଏତେ ସିର୍ମାରେୟାଃ ହାନ୍‌ ଟୁଣ୍ଡୁ ଜାକେଦ୍‌ ହୁଣ୍ଡିକ ନାଗେନ୍ତେ ଇନିଃ ଆୟାଃ ଦୁଁତ୍‌କକେ ଅତେଦିଶୁମ୍‌ରାଃ ଚାରିୟସାଃତେ କୁଲ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ନାହାଁଃ ଲଆଦାରୁରେଆଃ ଜନ୍‌କା କାଜିତେ ଇତୁନ୍‌ପେ, ଏନାରେୟାଃ କତ ସାଗେନଃତାନ୍‌ ଆଡଃ ସାକାମ୍‌ ସୁଡ଼ାଅଃତାନ୍‌ ଇମ୍‌ତା ଜେଟ୍‌ସିଙ୍ଗି ନାଡ଼େଃଗିଆ ମେନ୍ତେପେ ସାରିୟା । ");
INSERT INTO unx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ଏନ୍‌ଲେକାଗି, ନେଆଁଁ ସବେନାଃ ହବାଅଃତାନ୍‌ପେ ନେଲେ ଇମ୍‌ତା, ଆଇଁୟାଃ ହିଜୁଃନେଡା ନାଡ଼େଃରେଗିଆଃ, ହେଗି ଏନା ଦୁଆର୍‌ତାଃରେୟାଃ ମେନ୍ତେ ସାରିପେ । ");
INSERT INTO unx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା ନେ ସବେନାଃ ଆଉରି ହବାଅଃ ଜାକେଦ୍‌ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କ କାକ ଟୁଣ୍ଡୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ସିର୍ମା ଆଡଃ ଅତେ ଟୁଣ୍ଡୁଉତାରଃଆ, ମେନ୍‌ଦ ଆଇଁୟାଃ କାଜିକ କା ଟୁଣ୍ଡୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଚାଏ ଏନ୍‌ ଦିପିଲି ଜେତାଏ କାକ ସାରିଆଃ, ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କହ କା, ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଲାଡ଼୍‌ ହନ୍‌ହ କା, ମେନ୍‌ଦ ଆଇଁୟାଃ ଆପୁ ଏସ୍‌କାର୍‌ଗି ସାରିଆଃଏ । ");
INSERT INTO unx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ଚିର୍ଗାଲାକାନ୍‌ତାଇନ୍‌ପେ, ଏୟନାକାନ୍ ନେଲ୍‌ହରାଏପେ, ଚିୟାଃଚି ଏନ୍‌ ନେଡା ଚିମ୍‌ତା ତେବାଗାଃ ଏନା ଆପେଦ କାପେ ସାରିୟା । ");
INSERT INTO unx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ଏନା ସାଙ୍ଗିନ୍‌ ଦିଶୁମ୍‌ତେ ସେନଃତାନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ଲେକା । ଇନିଃ ଆୟାଃ ଅଡ଼ାଃ ବାଗିକେଦ୍‌ତେ ଆୟାଃ ଦାସିକକେ ଆକ୍‌ତେୟାର୍‌ ଏମାଦ୍‌କଆଏ, ଆଡଃ ମିଆଁଦ୍‌ନିଃକେ ଆୟାଃ କାମି ଏମାଦ୍‌କଆଏ, ଆଡଃ ହରନିଃକେ ଏୟନାକାନ୍‌ମେ ମେନ୍ତେ ଆଚୁକାଦା । ");
INSERT INTO unx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ଏନାମେନ୍ତେ ଏୟନାକାନ୍‍ତାଇନ୍‌ପେ, ଚିୟାଃଚି ଆପେଦ ଆପେୟାଃ ଅଡ଼ାଃ ଗମ୍‌କେଆଃ ହିଜୁଃ ଦିପିଲି କାପେ ସାରିୟା, ଆୟୁବ୍‌ତାନ୍‌ରେ, ଚାହେ ଥାଲାନିଦାରେ, ଚାହେ ସିମ୍‌କରାଃରେ, ଚାଏ ସେତାଃ ଇଦାନ୍‌ତେ । ");
INSERT INTO unx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ଆଚ୍‌କାଗି ଇନିଃ ତେବାଃକଃରେ ଦୁଡ଼ୁମାକାନ୍‌ ଆଲକାଏ ନାମ୍‌ପେକା । ");
INSERT INTO unx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେତାନ୍ କାଜି ସବେନ୍‌କକେଇଙ୍ଗ୍‌ କାଜିୟାକତାନା, ଏୟନାକାନ୍ ତାଇନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ପାସ୍‌କା ପାରାବ୍‌ ଆଡଃ ସାବାଃ ହଲଙ୍ଗ୍‌ରାଃ ପାରାବ୍‌ ଏତେ ବାର୍‌ସିଙ୍ଗ୍‌ ସିଦା, ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଅକ ସେଣାଁଁତେ ୟୀଶୁକେକ ସାବିଆ ଆଡଃକ ଗଜିୟା ମେନ୍ତେ ହରାକ ଦାଣାଁଁତାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“ପାରାବ୍‌ ହୁଲାଙ୍ଗ୍‌ଦ କାବୁଆଃ, କା'ରେଦ ହଡ଼କ ହାଲାଗୁଲାୟାକ” ମେନ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ୟୀଶୁ ବେଥ୍‌ନିଆ ହାତୁରେ, ଶିମୋନ୍‌ ନାଗେଘାଅନିଆଃ ଅଡ଼ାଃରେ ତାଇକେନାଏ । ଜଜମ୍ ନାଙ୍ଗ୍‌ ଦୁବାକାନ୍‌ ଦିପିଲିରେ, ମିଆଁଦ୍‌ କୁଡ଼ି ପୁରାଃ ଫାର୍‌ଚି ଗନଙ୍ଗ୍‌ଆଁନ୍‌ ଜଟାମାଂସି ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ତେ ପେରେଜାକାନ୍‌ ପୁଣ୍ଡିଦିରିରାଃ ଚୁକାଃ ସାବ୍‌କେଦ୍‌ତେ ବଲୟାନାଏ । ଇନିଃ ଏନ୍‌ ଚୁକାଃରାଃ ଠିପି ଅଡ଼େଃକ୍‌କେଦ୍‌ତେ ଏନ୍‌ ସୁନୁମ୍ ୟୀଶୁଆଃ ବହଃରେ ଦୁଲ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ମେନ୍‌ଦ ଏନ୍ତାଃରେ ତାଇକେନ୍‌ ଚିମିନ୍‌ ହଡ଼କ ଏସେଦ୍‌ୟାନ୍ତେ ମେପେନ୍‌ୟାନାକ, “ଚିନାଃମେନ୍ତେ ନେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ ସାମାରେ ଦୁଲ୍‌ଏଣ୍ଡାଗଃତାନା ? ");
INSERT INTO unx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ନେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌କେଦ ମିଆଁଦ୍‌ ହଡ଼ରାଃ ମିଦ୍‌ବାରାଷ୍‌ କାମିକାଦ୍‌ ନାଲା ସିକାଏତେ ଆଦ୍‌କା ଗନଙ୍ଗ୍‌ରେ ଆଖ୍‌ରିଙ୍ଗ୍‌ ଦାଡ଼ିକାନ୍‌ତେୟାଃ ଆଡଃ ରେଙ୍ଗେଃ ରାବାଙ୍ଗ୍‌କକେ ଏମାକାନ୍‌ତେୟାଃ ।” ଆଡଃ ଇନ୍‌କୁ ଏନ୍‌ କୁଡ଼ିକେକ କୁରୁମ୍ ଡୁରୁମ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଇନିଃକେ ତାଇନ୍ ଚିକାଇପେ । ଚିନାଃ, ମେନ୍ତେପେ ଦୁକୁଇଚିତାନା ? ଆଇଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଇନିଃ ବୁଗିନ୍‌ କାମି ରିକାକାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ରେଙ୍ଗେଃ ରାବାଙ୍ଗ୍‌କଦ ଜାନାଅ ଆପେଲଃକ ତାଇନା, ଆଡଃ ଆପେୟାଃ ସାନାଙ୍ଗ୍‌ ଲେକା ଜା'ଇମ୍‌ତାଗି ଇନ୍‌କୁକେ ଦେଙ୍ଗାପେ ଦାଡ଼ିୟାକଆ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେଲଃ ସବେନ୍‌ ଇମ୍‌ତା କାଇଙ୍ଗ୍‌ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ନିଃ ଚିମିନାଙ୍ଗ୍‌ ଦାଡ଼ିୟାନାଏ ଇମିନାଙ୍ଗ୍‌ ରିକାକେଦାଏ, ଆଇଙ୍ଗ୍‌ ହାସାଗାଡ଼ାଅଃ ମେନ୍ତେ ସିଦାରେ ଆଇଁୟାଃ ହଡ଼୍‌ମରେ ନେ ସୁନୁମ୍‌କେ ଦୁଲ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଅତେଦିଶୁମ୍‌ରେୟାଃ ଜାହାତାଃରେଗି ସୁକୁକାଜି ଉଦୁବଃତାନ୍‌ ଇମ୍‌ତା ଏନ୍‌ କୁଡ଼ି କାମିକାଦ୍‍ତେୟାଃ ପାହାମେ ନାଗେନ୍ତେ ଉଦୁବଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ଏନ୍ତେ ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା, ଗେଲ୍‌ବାର୍‌ ଚେଲାକଏତେ ମିଆଁଦ୍‌ନିଃ, ୟୀଶୁକେ ସାବ୍‌ରିକାଇ ମେନ୍ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କକେ ସେନ୍‌ନାମ୍ କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ଇନ୍‌କୁଦ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେକ ରାସ୍‌କାୟାନା, ଆଡଃ ଟାକାଲେ ଏମାମେୟା ମେନ୍ତେ ଇନିଃକେକ ବାନାର୍‌ସା ଏମ୍‌କିୟାକ । ଏନାମେନ୍ତେ ଯିହୁଦା ଇନ୍‌କୁଆଃ ତିଃଇରେ ୟୀଶୁକେ ସାବ୍‍ରିକାଇ ନାଗେନ୍ତେ ସୁଯୋଗ୍‌ ଦାଣାଁଁତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ସାବାଃ ହଲଙ୍ଗ୍‌ ପାରାବ୍‌ରେୟାଃ ସିଦା ହୁଲାଙ୍ଗ୍‌ରେ, ପାସ୍‌କା ପାରାବ୍‌ରେ ମିଣ୍ଡିହନ୍‌ ଦାଣେଁଅଃ ତାଇକେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଚେଲାକ ୟୀଶୁକେକ କାଜିକିୟା, “ଆଲେ ଅକ୍‌ତାଃଲେ ସେନା ଆଡଃ ଆମାଃ ନାଗେନ୍ତେ ପାସ୍‌କା ପାରାବ୍‌ରେ ଜମେଆଃଲେ ବାଇୟା ମେନ୍ତେ ସାନାଙ୍ଗ୍‌ତାନାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ଏନ୍ତେ ୟୀଶୁ ବାର୍‌ହଡ଼୍‌ ଚେଲାକିନ୍‌କେ କୁଲ୍‌ତାନ୍‌ଲଃ ମେତାଦ୍‌କିନାଏ, “ନାଗାର୍‌ତେ ସେନଃବେନ୍ ଆଡଃ, ମିଆଁଦ୍‌ ହଡ଼ ଦାଆଃଚାଟୁ ତେଙ୍ଗଃକେଦ୍‌ତେ ଦାରମ୍‌ବେନାଏ, ଇନିଃକେ ଅତଙ୍ଗ୍‌ଇଁବେନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ଆଡଃ ଇନିଃ ବଲଃ ଅଡ଼ାଃରେନ୍‌ ଗମ୍‌କେ କେ ମେତାଇବେନ୍, ଇତୁନିଃ କୁଲିତାନାଏ, ଆଇଁୟାଃ ଚେଲାକଲଃ ପାସ୍‌କା ପାରାବ୍‌ରେ ଜମେ ନାଗେନ୍ତେ ବାଖ୍‌ରା ଅକ୍‌ତାଃରେୟା ? ");
INSERT INTO unx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ଏନ୍ତେ ଇନିଃ ଚେତାନ୍ ଅଡ଼ାଃରେ ମିଆଁଦ୍‌ ବାଇସେକାଡ଼ାକାନ୍‌ ମାରାଙ୍ଗ୍‌ ବାଖ୍‌ରା ଉଦୁବାବେନାଏ, ଏନାରେଗି ଆବୁ ନାଗେନ୍ତେ ଜମେନାଙ୍ଗ୍‌ ବାଇୟେବେନ୍ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ଚେଲାକିନ୍ ନାଗାର୍‌ତେକିନ୍ ସେନଃୟାନା, ଆଡଃ ୟୀଶୁ କାଜିୟାଦ୍‌କିନ୍‌ ଲେକାଗି ସବେନାଃକିନ୍ ନାମ୍‌କେଦାଃ ଆଡଃ ପାସ୍‌କା ପାରାବ୍‌ରେୟାଃ ଜମେୟାଃଁକିନ୍ ବାଇକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ଆୟୁବ୍‍ୟାନ୍‍ଚି ୟୀଶୁ ଗେଲ୍‌ବାର୍‌ ଚେଲାକଲଃ ତେବାଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ଇନ୍‌କୁ ଜମ୍‌ ଦୁବାକାନ୍‌ ଦିପିଲିରେ, ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେକଏତେ ମିଆଁଦ୍‌ନିଃ ଆଇଙ୍ଗ୍‌ଲଃ ଜମ୍‌ତାନ୍‌ନିଃଗି ବାଇରିକଆଃ ତିଃଇରେ ସାବ୍‍ରିକାଇଙ୍ଗ୍‌ୟାଁଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ଚେଲାକଦ ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନାକ, ଆଡଃ ମିହୁଡ଼୍‌ ମିହୁଡ଼୍‌ତେ କାଜିକିୟାକ, “ଇନିଃ ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ଚି ?” ");
INSERT INTO unx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ବାରାଝାନ୍‌ କଏତେ ମିଆଁଦ୍‌ନିଃ, ଆଇଁୟାଃଲଃ ମିଆଁଦ୍‌ କାଟୋରାରେ ଆୟାଃ ତିଃଇ ସୁଉଃକାଦ୍‌ନିଃଗି ସାବ୍‌ରିକାଙ୍ଗ୍‌ଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ପାବିତାର୍‌ ଅନଲ୍‌କରେ ଅଲାକାନ୍‌ ଲେକା, ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌କେ ଗଜଃଲାଗାତିୟାଃଁ । ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌କେ ବାଇରିକଆଃ ତିଃଇରେ ସାବ୍‌ରିକାନିଃ ହାୟ୍ ହାୟ୍ ଚିମିନ୍‌ ଦୁକୁନାମେୟାଏ । ଏନ୍‌ ହଡ଼ କାଏ ଜାନାମ୍‌କାନ୍‌ରେଦ ଇନିଃ ନାଗେନ୍ତେ ବୁଗିନ୍‌ ହବାକାନ୍‌ତେୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ଇନ୍‌କୁ ଜମ୍‌ତାନ୍ ଦିପିଲିରେ, ୟୀଶୁ ମିଆଁଦ୍‌ ହଲଙ୍ଗ୍‌କେ ସାବ୍‌କେଦ୍‌ତେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌କେଦାଏ ଆଡଃ କେଚାଃକେଦ୍‌ତେ ଚେଲାକକେ ଏମ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ନେ ମାର୍‌ ତେଲାଏପେ, ନେଆଁଁ ଆଇଁୟାଃ ହଡ଼୍‌ମ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ଏନ୍ତେ ଇନିଃ କାଟୋରା ଇଦିକେଦ୍‌ତେ ବିନ୍ତିକେଦାଏ ଆଡଃ ଏମାଦ୍‌କଆଏ, ଆଡଃ ଇନ୍‌କୁ ଏନାଏତେକ ନୁଁକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଆଡଃ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ନେଆଁଁ ଆଇଁୟାଃ ମାୟୋମ୍‌ ତାନାଃ, ମାନୱାରାଃ ପାପ୍‌ ଛାମା ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଅକ ମାୟୋମ୍‌କେ ଲିଙ୍ଗି ନାଗେନ୍ତେ ସେନ୍‌ତାନାଇଙ୍ଗ୍‌, ଏନା ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଜିନାମାକେ ମୋହର୍‌କାଦା ।” ");
INSERT INTO unx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ନାୱା ଦାଖ୍‌ରାସି ଆଉରିଙ୍ଗ୍‌ ନୁଁଇ ଜାକେଦ୍‌, ଦାଖ୍‌ଜ'ରାଃ ରାସି ଆଡଃ ଚିଉଲାଅ କାଇଙ୍ଗ୍‌ ନୁଁଇଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ଏନ୍ତେ ଇନ୍‌କୁ ମାଇନାନ୍‌ ଦୁରାଙ୍ଗ୍‌ ଦୁରାଙ୍ଗ୍‌କେଦ୍‌ତେ ଜାଇତୁନ୍‌ ବୁରୁତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆପେ ସବେନ୍‌କ ନେ ନିଦାରେ ଆଇଙ୍ଗ୍‌କେ ବାଗିକେଦ୍‌ତେ ନିର୍‌କଆଃପେ, ନେଆଁଦ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ପାର୍‌ମେଶ୍ୱାର୍‌ ଗୁପିନିଃକେ ଦାଲିୟାଏ ଆଡଃ ଗୋଟ୍‌ରେନ୍‍ ମିଣ୍ଡିକ ଛିତିବିତିୟଃଆ ।’ ");
INSERT INTO unx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଜୀଉବିରିଦ୍‌କେଦ୍‌ତେ ଗାଲିଲ୍‌ତେ ଆପେଏତେ ଆୟାର୍‌ରେଇଙ୍ଗ୍‌ ସେନା ।” ");
INSERT INTO unx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ପାତ୍‌ରାସ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ “ଏଟାଃକ ବାଗିତାମ୍‌ରେହଁ, ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ବାଗିମେଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ୟୀଶୁଦ ପାତ୍‌ରାସ୍‌କେ ମେତାଇୟାଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାମ୍‌ତାନା, ତିସିଙ୍ଗ୍‌, ନେ ନିଦାରେ ସାଣ୍ଡିସିମ୍‌ ବାର୍‌ସା ରାଆଃଏ ସିଦାରେ ଆଇଙ୍ଗ୍‌କେ କାଇଙ୍ଗ୍‌ ସାରିୟା ମେନ୍ତେ ଆପିସାମ୍ କାଜିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ପାତ୍‌ରାସ୍‌ ଆଡଃଗି ପୁରାଃତେ କାଜିକିୟାଏ, “ଆମ୍‌ଲଃ ଗଜଃ ଲାଗାତିଙ୍ଗ୍‌ରେଅ ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ କାଇଙ୍ଗ୍‌ ସାରିଆଃ ମେନ୍ତେ କାଇଙ୍ଗ୍‌ଗି କାଜିୟା ।” ଆଡଃ ଏନ୍‌ଲେକା ସବେନ୍‌ ଏଟାଃ ଚେଲାକହଗି କାଜିକେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ଗେଥ୍‌ସିମାନି ନୁତୁମ୍‌ ଠାୟାଦ୍‌ତେକ ତେବାଃକେଦ୍‌ଚି, ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ବିନ୍ତି ଜାକେଦ୍‌ ନେତାଃରେ ଦୁବାକାନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ଇନିଃ ପାତ୍‌ରାସ୍‌, ଯାକୁବ୍‌, ଆଡଃ ଯୋହାନ୍‌କେ ଆୟାଃଲଃ ଇଦିକେଦ୍‌କଆଏ । ଆଡଃ ଇନିଃ ପୁରାଃଗି ଦୁକୁତେ ଆକୁଲ୍‌ବାକୁଲ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, “ଜୀଉତାଇୟାଁଃ ଗଜଃଲେକା ଦୁକୁଃତାନା, ନେତାଃରେଗି ତାଇନ୍‌କାନ୍‌ପେ ଆଡଃ ଆଇଁୟାଃଲଃ ଏୟନାକାନ୍‌ ତାଇନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ୟୀଶୁ କାଟିଃ ସାଙ୍ଗିନ୍‌ ସେନ୍‌କେଦ୍‌ତେ ଅତେରେ ଇକ୍‌ଡ଼ୁମ୍‌ୟାନ୍‌ଲଃ ଅମ୍ବାଃୟାନାଏ ଆଡଃ ବିନ୍ତିକେଦାଏ, “ହବାଦାଡ଼ିୟଃରେଦ ନେ ଦୁକୁ ଦିପିଲି ଆଇଙ୍ଗ୍‌ତାଃଏତେ ପାରମଃକା ।” ");
INSERT INTO unx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ଇନିଃ ବିନ୍ତିରେ ମେନ୍‌କେଦା, “ହେ ଆବା, ହେ ଆପୁ, ଆମାଃତେ ସବେନାଃ ହବାଦାଡ଼ିଅଃଆ । ନେ ଦୁକୁ କାଟୋରାକେ ଆଇଙ୍ଗ୍‌ଏତେ ଆତମ୍‌ତାମ୍; ଇମିନ୍‌ରେଅ ଆଇଁୟାଃ ସାନାଙ୍ଗ୍‌ଲେକାଦ କାହାଗି, ମେନ୍‌ଦ ଆମାଃ ସାନାଙ୍ଗ୍‌ ଲେକାଗି ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଚେଲାକତାଃ ରୁହାଡ଼୍‌ୟାନ୍‌ଚି ଇନ୍‌କୁକେ ଦୁଡ଼ୁମାକାନ୍‌ ନାମ୍‍କେଦ୍‍କଆଏ । ଇନିଃ ପାତ୍‌ରାସ୍‌କେ କାଜିକିୟାଏ, “ଏ ଶିମୋନ୍‌, ଦୁଡ଼ୁମ୍ ତାନାମ୍ ଚି ? ମିଦ୍‌ ଘାଣ୍ଟାଅଚି ଏୟନାକାନ୍ କାମ୍‌ତାଇନ୍‌ ଦାଡ଼ିୟାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ଆଡଃ ଇନିଃ କାଜିକେଦ୍‌କଆଏ, “ବିଡ଼ାଅରେ ଆଲ୍‌ପେ ଉୟୁଗଃକା ମେନ୍ତେ ଏୟନାକାନ୍ ତାଇନ୍‌ପେ ଆଡଃ ବିନ୍ତିପେ । ଆତ୍ମାଦ ସାନାଙ୍ଗ୍‌ତାନାଏ, ମେନ୍‌ଦ ହଡ଼୍‌ମ ନାରାଦୁରାଗିଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ଇନିଃ ଆଡଃଗି ସେନଃୟାନାଏ, ଆଡଃ ସିଦାଲେକାଗି ବିନ୍ତିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ଏନ୍ତେ ଇନିଃ ହିଜୁଃରୁହାଡ଼୍‌ଲେନାଏ ଆଡଃ ଚେଲାକକେ ଆଡଃମିସା ଦୁଡ଼ୁମାକାନାଏ ନାମ୍‍କେଦ୍‍କଆ, ଚିୟାଃଚି ଇନ୍‌କୁ ଦୁଡ଼ୁମ୍‌ତେ ମେଦ୍‌ତାକଆଃ ଆରିଦ୍‌ କାକ ଦାଡ଼ିତାନ୍‌ତାଇକେନା । ଇନିଃକେ ଚିନାଃବୁ କାଜିରୁହାଡ଼୍‌କିୟା ମେନ୍ତେ ଇନ୍‌କୁ କାକ ସାରିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ଆଡଃ ଇନିଃ ଆପିସା ରୁହାଡ଼୍‌ୟାନ୍‌ଚି, ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ନାହାଁଃ ଜାକେଦ୍‌ଚିପେ ଦୁଡ଼ୁମ୍‌ତାନା ଆଡଃ ରୁଡୁନ୍‌ତାନା ? ଇମ୍‌ନାଙ୍ଗ୍‌ଗି ! ନେଡା ତେବାଃୟାନା, ନେଲେପେ, ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ପାପିକଆଃ ତିଃଇରେ ସାବ୍‌ରିକାଅଃତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ବିରିଦ୍‌ପେ, ଦଲାବୁ ସେନଆଃ ! ନେଲିପେ, ଆଇଙ୍ଗ୍‌କେ ସାବ୍‍ରିକାଇଙ୍ଗ୍‌ନିଃ ସେଟେରାକାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ୟୀଶୁ ଜାଗାର୍‌ତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତାଗି ଯିହୁଦା, ବାରାଝାନ୍‌କଏତେ ମିଆଁଦ୍‌ନିଃ ତେବାଃୟାନାଏ । ଇନିଃଲଃ ମୁଲ୍‌ ଯାଜାକ୍‌କ, ଆଇନ୍‌ ଇତୁକ ଆଡଃ ପ୍ରାଚିନ୍‌କ ସାଃଏତେ କୁଲାକାନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ତାରାଉଡ଼ିକ ଆଡଃ ଭଙ୍ଗାଟ୍‌କ ସାବ୍‌କେଦ୍‌ତେ ହିଜୁଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ୟୀଶୁକେ ସାବ୍‌ରିକାନିଃ ଏନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କକେ ମିଆଁଦ୍‌ ଚିହ୍ନାଁ ଏମାକାଦ୍‌କ ତାଇକେନାଏ, “ଆଇଙ୍ଗ୍‌ ଅକ୍‌ନିଃକେ ଚଅଃ'ଇଙ୍ଗ୍‌, ଇନିଃଗି ୟୀଶୁ ତାନିଃ । ଇନିଃକେ ସାବିପେ ଆଡଃ ଚିର୍ଗାଲ୍‌ତେ ଇଦିପେ” ମେନ୍ତେ ସିଦାରେ କାଜିକାଦ୍‌କ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ଯିହୁଦା ତେବାଃୟାନ୍‌ଚି, “ହେ ଗୁରୁ” ମେତାଇତାନ୍‌ଲଃ ଇନିଃକେ ଚଅଃ'କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ଆଡଃ ଇନ୍‌କୁ ୟୀଶୁକେ ସାବ୍‌କେଦ୍‌ତେ ତଲ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ଜାପାଃରେ ତିଙ୍ଗୁଆକାନ୍ଏତେ ମିଆଁଦ୍‌ନିଃ ତାରାଉଡ଼ି ଅଡଙ୍ଗ୍‌କେଦାଏ ଆଡଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ରାଃ ଦାସିକେ ମାଆଃକିୟାଏ ଆଡଃ ଇନିୟାଃ ମିଆଁଦ୍‌ ଲୁତୁର୍‍ ହାଦ୍‍ତାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଏନ୍ତେ ୟୀଶୁ ପୁରାଃ ହଡ଼କକେ କାଜିୟାଦ୍‍କଆଏ, “ଚିୟାଃ, ମିଆଁଦ୍‌ କୁମ୍ୱୁଡ଼ୁଲେକା ସାବିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ତାରାଉଡ଼ିକ ଆଡଃ ଭଙ୍ଗାଟ୍‌କ ସାବ୍‌କେଦ୍‌ତେ ହିଜୁଃକାନାପେ ? ");
INSERT INTO unx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଇତୁତାନ୍‌ଲଃ ଆପେଲଃ ତାଇକେନାଇଙ୍ଗ୍‌ ଆଡଃ ଆପେ କାପେ ସାବ୍‌କେଦିୟାଁଃ । ମେନ୍‌ଦ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ତେୟାଃ ପୁରାଅଃକା ମେନ୍ତେ ନେ ସବେନାଃ ହବାଅଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ଏନ୍ତେଦ ଆୟାଃ ସବେନ୍‌ ଚେଲାକ ଇନିଃକେ ନିର୍‍ବାଗିକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ମିଆଁଦ୍‌ ଧାଙ୍ଗ୍‌ଡ଼ା ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟା, ଇନିଃ ସାମା ହଡ଼୍‌ମରେ ନିରାଲ୍‌ ଲିଜାଃଉୟୁକାନ୍ ତାଇକେନାଏ, ଚିମ୍‌ତା ସିପାଇକ ଧାଙ୍ଗ୍‌ଡ଼ାକେ ସାବ୍ ନାଗେନ୍ତେକ ହିଜୁଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ଇନିଃ ଆୟାଃ ନିରାଲ୍‌ ଲିଜାଃ ବାଗିକେଦ୍‌ତେ, ଇନିଃ ସାମାହଡ଼୍‌ମ ନିର୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ଏନ୍ତେ ଇନ୍‌କୁ ୟୀଶୁକେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କତାଃ ଇଦିକିୟାଃକ । ଏନ୍ତାଃରେ ମୁଲ୍‌ ଯାଜାକ୍‌କ, ପ୍ରାଚିନ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ହୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପାତ୍‌ରାସ୍‌ ସାଙ୍ଗିନ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଅଡ଼ାଃରାଚା ଜାକେଦ୍‌ ଅତଙ୍ଗ୍‌ ଇଦିକିୟାଏ । ଏନ୍ତାଃରେ ଇନିଃ ହରହଡ଼କଲଃ ଦୁବ୍‌କେଦ୍‌ତେ ସେଙ୍ଗେଲ୍‌ ଜୁରୁବ୍‌ତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ପାଞ୍ଚେଟ୍‌ରେନ୍ ସବେନ୍‌କ ୟୀଶୁକେ ଗଜି ନାଗେନ୍ତେ ଗାୱାକ ଦାଣାଁଁବାଡ଼ା ତାଇକେନା, ମେନ୍‌ଦ ଏନା କାକ ନାମ୍‌ ଦାଡ଼ିକେଦା । ");
INSERT INTO unx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ପୁରାଃ ହଡ଼କ ଇନିୟାଃ ବିରୁଧ୍‌ରେ ହସଡ଼ ଗାୱାକ ଏମ୍‌କେଦାଃ, ମେନ୍‌ଦ ଇନ୍‌କୁଆଃ ଗାୱାକ ମିଦ୍‌ଲେକା କା ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ଏନ୍ତେ ଚିମିନ୍‌ ହଡ଼କ ତିଙ୍ଗୁୟାନାକ, ଆଡଃ ୟୀଶୁଆଃ ବିରୁଧ୍‌ରେ ନେ ହସଡ଼ ଗାୱାକ ଏମ୍‌କେଦାଃ : ");
INSERT INTO unx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ହଡ଼କଆଃ ତିଃଇତେ ବାଇୟାକାନ୍, ନେ ମାନ୍ଦିର୍‌କେ ହାଦୁଡ଼େଆଇଙ୍ଗ୍‌, ଆଡଃ ଆପିମାରେ, ହଡ଼କଆଃ ତିଃଇତେ କା ବାଇୟାକାନ୍‌ ମାନ୍ଦିର୍‌କେ ତିଙ୍ଗୁୟାଇଙ୍ଗ୍‌ ମେନ୍ତେ ନିଃକେ କାଜିତାନ୍‌ଲେ ଆୟୁମ୍‌କିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ମେନ୍‌ଦ ଇନ୍‌କୁଆଃ ନେ କାଜିକରାଃ ଗାୱାକ କା ମିଦ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌, ସବେନ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ୟୀଶୁକେ କୁଲିକିୟାଏ, “ନେ ହଡ଼କ ଆମାଃ ବିରୁଧ୍‌ରେ ଗାୱାକ ଏମ୍‌କେଦାଃ, ଚିୟାଃ ଆମ୍‌ ଜେତ୍‌ନାଃ କାମ୍‌କାଜି ରୁହାଡ଼େତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ମେନ୍‌ଦ ୟୀଶୁ ହାପାକାନ୍ ତାଇକେନାଏ ଆଡଃ ଜେତ୍‌ନାଃ କାଏ କାଜିରୁହାଡ଼୍‌କେଦା । ଆଡଃଗି ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଇନିଃକେ କୁଲିକିୟାଏ, “ଆମ୍‌ଗି ଚି ଖ୍ରୀଷ୍ଟ୍‌, ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ହନ୍‌ ତାନ୍‌ମେ, ଅକଏୟାଃଚି ସବେନ୍‌ ମାଇନାନ୍‌ ତାନାଃ ?” ");
INSERT INTO unx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ୟୀଶୁ ମେତାଇୟାଏ, “ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌ । ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ସବେନ୍‌ ପେଡ଼େୟାନ୍‌ନିୟାଃ ଜମ୍‌ତିସାଃରେ ଦୁବାକାନ୍‌ ଆଡଃ ସିର୍ମାରାଃ ରିମିଲ୍‌ରେ ଆଡ଼୍‌ଗୁନ୍‌ତାନ୍‌ପେ ନେଲିଙ୍ଗ୍‌ୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌, ଆୟାଃ ଲିଜାଃ ଚାଗାଡ଼୍‌କେଦାଏ । “ଆବୁକେ ଆଡଃ ଚିକାନ୍‌ ଗାୱା ଲାଗାତିୟାଃଁ ?” ମେନ୍ତେ ଇନିଃ କୁଲିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“ଆପେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନିନ୍ଦାକାଜିପେ ଆୟୁମ୍‌କେଦା । ଚିନାଃପେ ବିଚାରେତାନା ?” ସବେନ୍‌କ ଇନିୟାଃ ବିରୁଧ୍‌ରେ କାଜିକେଦାଃକ ଚି ଇନିଃକେ ଗନଏଃ ସାଜାଇ ଏମଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ଏନ୍ତେ ଚିମିୟାଙ୍ଗ୍‌କ ୟୀଶୁକେ ବେଏକ୍‌କିୟାଃକ, ଆଡଃ ଇନିୟାଃ ମେଦ୍‌ ହାରୁବ୍‌କେଦ୍‌ତେ ଦାଲିତାନ୍‌ଲଃ କାଜିକିୟାଃକ, “ଆମ୍‌ ପରେ ନାବୀ ତାନ୍‌ମେ, ମାର୍‌ କାଜିଲେମେ, ଅକଏ ଦାଲ୍‌ମେତାନାଏ ।” ଆଡଃ ହରହଡ଼କ ଇନିଃକେ ସାବ୍‌କେଦ୍‌ତେ ଥାପ୍‌ଡ଼ିକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ଚିମ୍‌ତା ପାତ୍‌ରାସ୍‌ ଲାତାର୍‌ ଅଡ଼ାଃରାଚାରେ ତାଇକେନ୍‌ରେ, ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ରାଃ ମିଆଁଦ୍‌ କାମ୍‌ଡ଼ିକୁଡ଼ି ହିଜୁଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ଆଡଃ ପାତ୍‌ରାସ୍‌କେ ଜୁରୁବ୍‌ତାନ୍‌ ନେଲ୍‌କିୟାଏ, ଇନିଃକେ ଆରିଦ୍‍ବାଇକେଦ୍‍ତେ ମେତାଇୟାଏ, “ଆମ୍‌ଅଗି ନାଜ୍‌ରେତ୍‌ରେନ୍‌, ୟୀଶୁଲଃ ତାଇକେନାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ମେନ୍‌ଦ ଇନିଃ କାହାଗି ମେନ୍‍କେଦ୍‌ତେ, କାଜିରୁହାଡ଼୍‌କେଦାଏ, “ଆଇଙ୍ଗ୍‌ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିୟା । ଆମ୍‌ ଚିନାଃମ୍‌ କାଜିତାନା ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ମୁଣ୍ଡିଅଃତାନାଃ ।” ଏନ୍ତେ ଇନିଃ ବଲଃଦୁଆର୍‍ତେ ସେନଃୟାନାଏ, ଇମ୍‌ତାଗି ସାଣ୍ଡିସିମ୍‌ ରାଆଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଆଡଃମିସା କାମ୍‌ଡ଼ିକୁଡ଼ି ଇନିଃକେ ନେଲ୍‌କିଃତେ, ଜାପାଃକରେ ତିଙ୍ଗୁଆକାନ୍‌ ହଡ଼କକେ ମେତାଦ୍‌କଆଏ, “ନିଃଇହ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ ଆଡଃଗି “କାହାଗି” ମେନ୍‍କେଦାଏ । ଘାଡ଼ିକାଦ୍‌ ତାୟମ୍‌ତେ ଏନ୍ତାଃରେ ତିଙ୍ଗୁଆକାନ୍‍କ ପାତ୍‌ରାସ୍‌କେକ କାଜିକିୟା, “ସାର୍‌ତିଗି, ଆମ୍‌ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ତାନ୍‌ମେ, ଚିୟାଃଚି ଆମ୍‌ଅଗି ଗାଲିଲ୍‌ରେନ୍ ତାନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ କିରିୟା ଜମ୍‍କେଦ୍‍ତେ କାଜିକେଦାଏ, “ଆପେ କାଜିତାନ୍ ନେ ହଡ଼କେ ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ସାରିଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ଏନ୍ତେ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ସାଣ୍ଡିସିମ୍‌ ବାର୍‍ସାଏ ରାଆଃକେଦାଃ, ଆଡଃ “ସାଣ୍ଡିସିମ୍‌ ବାର୍‌ସା ଆଉରି ରାଆଃ ସିଦାରେ ଆପିସା ଆଇଙ୍ଗ୍‌କେ କାଇଙ୍ଗ୍‌ ସାରିଆ ମେନ୍ତେ କାଜିୟାମ୍‌,” ଏନା ୟୀଶୁ କାଜିଲେଦ୍‌କାଜି ପାତ୍‌ରାସ୍‌ ପାହାମ୍‍କେଦାଏ । ଆଡଃ ଇନିଃ କୁସୁଦ୍‌ କୁସୁଦ୍‍ତାନ୍ ରାଆଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ଆଙ୍ଗ୍‌ୟାନ୍‍ଲଃଗି ମୁଲ୍‌ ଯାଜାକ୍‌କ, ପ୍ରାଚିନ୍‌କଲଃ, ଆଇନ୍‌ ଇତୁକଲଃ ଆଡଃ ପାଞ୍ଚେଟ୍‌ରେନ୍ ସବେନ୍‌କଲଃକ ରଜୋଟକେଦା । ଇନ୍‌କୁ ୟୀଶୁକେ ତଲ୍‍କେଦ୍‌ତେକ ଇଦିକିୟା, ଆଡଃ ପିଲାତୁସ୍‌ରାଃ ତିଃଇରେ ଏମ୍‍କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତୁସ୍‌ ଇନିଃକେ, “ଆମ୍‌ଗିଚି ଯିହୁଦୀକଆଃ ରାଜା ତାନ୍‌ମେ ?” ମେନ୍ତେ କୁଲିକିୟାଏ । ୟୀଶୁ ମେନ୍‍ରୁହାଡ଼ାଇୟାଏ, “ହାଁ, ଆମ୍‌ଗିମ୍ କାଜିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ମୁଲ୍‌ ଯାଜାକ୍‌କ ୟୀଶୁକେ ପୁରାଃ କାଜିତେକ ଚିଟାକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ଏନାମେନ୍ତେ ପିଲାତୁସ୍‌ ଆଡଃଗି ଇନିଃକେ କୁଲିକିୟାଏ, “ଚିୟାଃ ଆମ୍‌ ଜେତ୍‌ନାଃ କାମ୍‌ କାଜିରୁହାଡ଼ାକଆ ? ନେଲ୍‌କୁମ୍, ଇନ୍‌କୁ ଆମ୍‌କେ ଚିମିନ୍‌ ପୁରାଃ କାଜିତେକ ଚିଟାମେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ମେନ୍‌ଦ ୟୀଶୁ ଜେତ୍‌ନାଃହ କାଏ କାଜିରୁହାଡ଼୍‌କିୟା, ଏନାମେନ୍ତେ ପିଲାତୁସ୍‌ ଆକ୍‌ଦାନ୍ଦାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ପିଲାତୁସ୍‌ରାଃ ରିତିଲେକାତେ, ସବେନ୍‌ ପାସ୍‌କା ପାରାବ୍ ଦିପିଲିରେ ହଡ଼କ ମିଆଁଦ୍‌ ଜେହେଲାକାନ୍‍ନିଃକେ ଆସି ତାଇକେନାକ, ଇନିଃକେ ପିଲାତୁସ୍‌ ଇନ୍‌କୁନାଙ୍ଗ୍‌ ଆଡ଼ାଗାକତାନ୍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ଦିଶୁମ୍‌ରେ ହାଲାଗୁଲା ହବାୟାନ୍ ଦିପିଲିରେ, ହଡ଼ଗଏଃ ହରାତେ ଜେହେଲାକାନ୍‍କଏତେ, ବାରବ୍‌ବା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ହଁ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ଗାଦେଲ୍‌ ହଡ଼କ ପିଲାତୁସ୍‌ତାଃ ହିଜୁଃୟାନ୍ତେ, ଆମ୍‌ ଜାନାଅ ରିକାତାନ୍‌ ଲେକା ଆଲେୟାଃ ନାଙ୍ଗ୍‌ ରିକାଗାଲେମ୍, ମେନ୍ତେକ ଆସିଏଟେଦ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଚିନାଃ ଆଇଙ୍ଗ୍‌ ଆପେୟାଃ ନାଗେନ୍ତେ ଯିହୁଦୀକଆଃ ରାଜାକେଇଙ୍ଗ୍‌ ଆଡ଼ାଃତାଇୟା ମେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ଚିୟାଃଚି ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ ହିସ୍‌ଙ୍ଗାତେ ୟୀଶୁକେ ଆଇଃକ୍‌ତାଃରେ ଜିମାକାଇ ତାଇକେନାକ, ଏନା ଇନିଃ ଆଟ୍‌କାର୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ମୁଲ୍‌ ଯାଜାକ୍‌କ, ୟୀଶୁକେ ବାନଃ ମେନ୍‌ଦ ବାରବ୍‌ବାକେ ରାଡ଼ା ନାଗେନ୍ତେ ପିଲାତୁସ୍‌କେ ଆସିପେ ମେନ୍ତେ ଗାଦେଲ୍‌ ହଡ଼କକେ ଉସ୍‍କୁର୍‍କେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ପିଲାତୁସ୍‌ ଆଡଃଗି ହୁଣ୍ଡିଆକାନ୍‍କକେ କୁଲିକେଦ୍‍କଆଏ, “ଆପେ ଯିହୁଦୀକଆଃ ରାଜା ମେତାଇନିଃକେ ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାଇୟା ମେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ଇନ୍‍କୁଦ ଆଡଃଗିକ କାଉରିକେଦାଃ, “ଇନିଃକେ କ୍ରୁଶ୍‌ରେ କିଲାଇମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ମେନ୍‌ଦ, “ଇନିଃ ଚିନାଃ ଗୁହ୍ନାଁକାଦାଏ ?” ମେନ୍ତେ ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‍କଆଏ । ଇନ୍‍କୁଦ ଆଡଃଗି କାଉରିକେଦ୍‌ତେ କାଜିକିୟା, “କ୍ରୁଶ୍‌ରେ କିଲାଇମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ପିଲାତୁସ୍‌ ହଡ଼କକେ ସୁକୁ ସାନାଙ୍ଗ୍‌ତାନ୍‍ତେ ବାରବ୍‌ବାକେ ଇନ୍‌କୁଆଃ ନାଗେନ୍ତେ ରାଡ଼ାକିୟାଏ । ଏନ୍ତେ ଇନିଃ ୟୀଶୁକେ ହାଁଣ୍‌ସା ରିକାକିଃତେ କ୍ରୁଶ୍‌ରେ ରାକାବଃକାଏ ମେନ୍ତେ ଇନିଃକେ ଜିମାକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ସିପାଇକ ପିଲାତୁସ୍‌ରାଃ ଅଡ଼ାଃରାଚା ଭିତାର୍‌ତେ ୟୀଶୁକେକ ଇଦିକିୟା, ଆଡଃ ଗଟା ପାଲ୍‌ଟାନ୍‍କକେ ହୁଣ୍ଡିକେଦ୍‍କଆକ ");
INSERT INTO unx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ଇନ୍‌କୁ ଇନିଃକେ ମିଆଁଦ୍‌ ବାଇଗିନିଆ ଲିଜାଃକ ତୁସିଙ୍ଗ୍‌କିୟାଃ ଆଡଃ ଜାନୁମ୍‌ ମୁକୁଟ୍‌ ଗାଲାଙ୍ଗ୍‌କେଦ୍‍ତେ ଇନିୟାଃ ବହଃରେକ ଟୁପୁରିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ କାଜି ଏଟେଦ୍‌କିୟାଃକ, “ହେ, ଯିହୁଦୀକଆଃ ରାଜା, ଜାନାଅ ଜାନାଅ ନାଙ୍ଗ୍‌ ତାଇନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ଇନ୍‌କୁ ଇନିଃକେ ସଟାତେ ବହଃରେକ ଦାଲ୍‍କିୟା, ବେଏକ୍‌କିୟା ଆଡଃ ଇକ୍‌ଡୁମ୍‍କେଦ୍‌ତେକ ଜହାର୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ଇନ୍‌କୁ ଇନିଃକେ ଲାନ୍ଦାକିତେ ଏନ୍‌ ବାଇଗିନିଆ ଲିଜାଃକେକ ହଲେଃକ୍‌କେଦା ଆଡଃ ଆୟାଃ ଲିଜାଃକେକ ତୁସିଙ୍ଗ୍‌କିୟା । ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ କ୍ରୁଶ୍‌ରେ କିଲାଇ ନାଗେନ୍ତେ ବାହାରିତେକ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","କୁରିନିରେନ୍ ଶିମୋନ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼, ଆଲେକ୍‌ଜାଣ୍ଡାର୍‌ ଆଡଃ ରୁପୁସ୍‍ରାଃ ଆପୁତେ, ହାତୁଏତେ ହିଜୁଃତାନ୍‌ଲଃ ଏନ୍‌ ହରାରେ ପାରମଃତାନ୍‌ ତାଇକେନାଏ, ଆଡଃ ପାଲ୍‌ଟାନ୍‍କ ଇନିଃକେକ ୟୀଶୁଆଃ କ୍ରୁଶ୍‍କେ ଜାବାର୍‌ଜାସ୍ତି ଗଅଃ ରିକାକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ଇନ୍‌କୁ ୟୀଶୁକେ ଗାଲ୍‌ଗାଥା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଠାୟାଦ୍‌ତେକ ଇଦିକିୟା, ଗାଲ୍‍ଗାଥାରାଃ ମୁଣ୍ଡିଦ, “ବହଃଜାଙ୍ଗ୍‌ବୁରୁ” । ");
INSERT INTO unx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ଏନ୍ତାଃରେ ଇନ୍‌କୁ ଇନିଃକେ ମେହେର୍‍ତେଆଃ ମେସାକାନ୍ ଦାଖ୍‌ରାସି ନୁଁଇ ନାଗେନ୍ତେକ ଏମାଇୟା, ମେନ୍‌ଦ ୟୀଶୁ ଏନା କାଏ ନୁଁକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ କ୍ରୁଶ୍‍ରେକ ରାକାବ୍‍କିଆ, ଆଡଃ ଇନିୟାଃ ଲିଜାଃକ, ଅକଏ ଅକ୍‌ନାଃବୁ ନାମେଆଁ ଏନା ଚିଠା ଉୟୁଃକେଦ୍‌ତେ ନେଲ୍‌କେଦାଃକ, ଏନ୍ତେ ଆକ ଆକରେଗି ହାଟିଙ୍ଗ୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ସେତାଃରାଃ ନାଅବାଜେ ଇନ୍‌କୁ ଇନିଃକେ କ୍ରୁଶ୍‍ରେକ କିଲାକିୟାଃ ");
INSERT INTO unx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଇନିୟାଃ ବିରୁଧ୍‌ରେ ଅଲାକାନ୍‌ ଚିଠାରେ, “ଯିହୁଦୀକଆଃ ରାଜା” ମେନ୍ତେ ଅଲାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ଇନ୍‌କୁ ବାରିଆ କୁମ୍ବୁଡ଼ୁକିନ୍‌କେ ଇନିଃଲଃ କ୍ରୁଶ୍‍ରେକ କିଲାକେଦ୍‍କିନା, ମିଆଁଦ୍‌ନିଃକେ ଜମ୍‌ତିସାଃରେ, ଏଟାଃନିଃକେ ଲେଙ୍ଗାତିସାଃରେ । ");
INSERT INTO unx_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ଏନ୍‌ଲେକାତେ, ପାବିତାର୍‌ ଅନଲ୍‌କରେ, “ଏତ୍‍କାନ୍‍କଲଃ ଲେକାୟାନାଏ, ମେନ୍ତେ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ କାଜି ପୁରାୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ଏନ୍‌ ହରାରେ ସେନ୍‌ପାରମଃତାନ୍ ହଡ଼କ, ଆକଆଃ ବହଃ ହିଲାଅକେଦ୍‌ତେ ଇନିଃକେ ନିନ୍ଦାତାନ୍‌ଲଃ କାଜିକିୟାଃକ, “ବାଃରେ ମାନ୍ଦିର୍‌ ହାଦୁଡ଼୍‌ନିଃ ଆଡଃ ଆପିମାରେ ବାଇରୁହାଡ଼୍‌ନିଃ, ");
INSERT INTO unx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ମାର୍‌ କ୍ରୁଶ୍‌ଏତେ ଆଡ଼୍‌ଗୁନ୍‍ମେ ଆଡଃ ବାଞ୍ଚାଅଏନ୍‍ମେ ।” ");
INSERT INTO unx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ଏନ୍‍ଲେକାଗି ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ, ୟୀଶୁକେ ଆକ ଆକରେକ ହିଲାଙ୍ଗ୍‌କିଆ ଆଡଃ ମେପେନ୍‍ୟାନା “ଏଟାଃକକେଦ ଇନିଃ ବାଞ୍ଚାଅକେଦ୍‍କଆଏ, ମେନ୍‌ଦ ଇନିଃ ଆଇଃକ୍‌ଗି ବାଞ୍ଚାୱେନ୍‍ କାଏ ଦାଡ଼ିତାନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ଆମ୍‌ ସାର୍‌ତିଗି ଖ୍ରୀଷ୍ଟ୍‌, ଇସ୍ରାଏଲ୍‌ରାଃ ରାଜାତାନ୍‌ମେ ରେଦ, କ୍ରୁଶ୍‌ଏତେ ନାହାଁଃ ଆଡ଼୍‌ଗୁନ୍‍କାଏ, ଆଡଃ ଏନା ନେଲ୍‍କେଦ୍‌ତେବୁ ବିଶ୍ୱାସୀତେଆଃ ।” ଆଡଃ ଇନିଃଲଃ କ୍ରୁଶ୍‌ରେ କିଲାକାନ୍‌କିନ୍‌ ଇନିଃକେକିନ୍‌ ହିଲାଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ତିକିନ୍‌ସିଙ୍ଗିକରେ ତିନ୍‌ଘାଣ୍ଟା ଜାକେଦ୍‌ ଗଟା ଦିଶୁମ୍‌ ନୁବାଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ଆଡଃ ତିନ୍‌ବାଜେ ୟୀଶୁ ପୁରାଃଗି କାଉରିକେଦ୍‌ତେ କାଜିକେଦାଏ, “ଏଲୋଇ ଏଲୋଇ ଲାମା ସାବାକ୍‍ଥାନି ?” ଏନାରାଃ ମୁଣ୍ଡିଦ, “ଏ ଆଇଁୟାଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଏ ଆଇଁୟାଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଚିନାଃମେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ ବାଗିକିଦିୟାମ୍ ?” ");
INSERT INTO unx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ଏନ୍‌ ଜାପାଃରେ ତିଙ୍ଗୁଆକାନ୍‍କଏତେ ଚିମିନ୍‌ ହଡ଼କ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ କାଜିକେଦା, “ଆୟୁମେପେ, ଇନିଃ ଏଲିୟକେ ହାକାଅତାନା ।” ");
INSERT INTO unx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ନିର୍‍କେଦ୍‍ତେ ସ୍ପଞ୍ଜ୍‌କେ ମେହେର୍‌ ରାସିରେ ତୁପୁକେଦାଏ ଆଡଃ ଏନାକେ ମିଆଁଦ୍‌ ସଟାରେ ଗୁତୁକେଦ୍‌ତେ ୟୀଶୁକେ ନୁଁଇ ନାଗେନ୍ତେ ଏମ୍‌କିୟାଏ, ଆଡଃ ମେନ୍‍କେଦାଏ, “ରାହା କ୍ରୁଶ୍‌ଏତେ ଇନିଃକେ ଆଡ଼୍‌ଗୁ ନାଗେନ୍ତେ ଏଲିୟ ହିଜୁଃତାନାଏ ଚି କାହା ନେଆଁଁବୁ ନେଲେଆ ।” ");
INSERT INTO unx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ୟୀଶୁ ପୁରାଃଗି କାଉରିକେଦାଏ ଆଡଃ ଜୀଉତାୟାଃ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ହାକାକାନ୍‌ ହାନାଟିଙ୍ଗ୍‌ ଦାନାଙ୍ଗ୍‌ଲିଜାଃ ଚେତାନ୍‍ଏତେ ଲାତାର୍‍ ଜାକେଦ୍‌ ଥାଲାରେ ବାର୍‌ ହିସା ଚାଗାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","କ୍ରୁଶ୍‍ରାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ତିଙ୍ଗୁଆକାନ୍‌ ସିପାଇକଆଃ ଗମ୍‌କେ ୟୀଶୁ ଚିଲ୍‌କାଏ ଗଏଃୟାନା, ଏନା ନେଲ୍‌କେଦ୍‌ତେ ମେନ୍‍କେଦାଏ, “ସାର୍‌ତିଗି ନେ ହଡ଼ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‍ଗି ତାଇକେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ଆଡଃ ଏନ୍ତାଃରେ ଚିମିନ୍‌ କୁଡ଼ିକ ସାଙ୍ଗିନ୍‌ଏତେ ନେଲ୍‍ତାନ୍‍କ ତାଇକେନା । ଇନ୍‌କୁଆଃ ଥାଲାରେ ମାରିୟାମ୍‌ ମାଗ୍‌ଦାଲିନି, ହୁଡିଙ୍ଗ୍‌ ଯାକୁବ୍‌ ଆଡଃ ଯୋସିରାଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌, ଆଡଃ ସାଲୋମିତେକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଇନ୍‌କୁ, ୟୀଶୁ ଗାଲିଲ୍‌ରେ ତାଇକେନ୍‌ ଇମ୍‌ତା ଅତଙ୍ଗ୍‌ଇଁତାନ୍‌ ଆଡଃ ସୁସାରିତାନ୍‍କ ତାଇକେନା । ଇନିଃଲଃ ଯୀରୁଶାଲେମ୍‌ତେ ହିଜୁଃକାନ୍ ପୁରାଃ ଏଟାଃ କୁଡ଼ିକହ ଏନ୍ତାଃରେ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ଏନ୍‌ହୁଲାଙ୍ଗ୍‌ଦ ସାପ୍‌ଡ଼ାଅନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତାଇକେନା, ଏନା ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରାଃ ସିଦାହୁଲାଙ୍ଗ୍‌ ତାଇକେନା, ଆଡଃ ଆୟୁବ୍‌ୟାନ୍‌ଚି, ");
INSERT INTO unx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ହାରାମାଥିୟା ସାହାର୍‌ରେନ୍ ଯୋଷେଫ୍‌, ଇନିଃଦ ଯିହୁଦୀକଆଃ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ରେନ୍ ମିଆଁଦ୍‌ ମାଇନାନ୍ ହଡ଼ ତାଇକେନାଏ, ଇନିଃହ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ନେଲ୍‌ ହରାତାନ୍ ତାଇକେନାଏ, ଏନାମେନ୍ତେ ଇନିଃ ଜେତାଏକେ କାଏ ବରକେଦ୍‌ତେ ପିଲାତୁସ୍‌ତାଃତେ ବଲୟାନାଏ ଆଡଃ ୟୀଶୁଆଃ ଗଏଃ ହଡ଼୍‌ମ ଆସିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ୟୀଶୁଆଃ ଜୀଉଟୁଣ୍ଡୁୟାନା ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ତେ ପିଲାତୁସ୍‌ ଆକ୍‌ଦାନ୍ଦାଅୟାନା । ଇନିଃ ସିପାଇକଆଃ ଗମ୍‌କେ କେ କେଡ଼ାକେଦ୍‍ତେ, ଚିୟାଃ ଇନିଃ ଗଏଃୟାନାଏ ମେନ୍ତେ ଇନିଃକେ କୁଲିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ପିଲାତୁସ୍‌ ସିପାଇକଆଃ ଗମ୍‌କେୟାଃ କାଜିତେ ଏନା ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ, ଇନିଃ ୟୀଶୁଆଃ ଗଏଃହଡ଼୍‌ମ ଯୋଷେଫ୍‌କେ ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ଯୋଷେଫ୍‌ ନିରାଲ୍‌ ଲିଜାଃ କିରିଙ୍ଗ୍‌କେଦ୍‌ତେ ୟୀଶୁକେ କ୍ରୁଶ୍‌ଏତେ ଆଡ଼୍‌ଗୁକିଆଏ ଆଡଃ ଏନ୍‌ ଫାର୍‌ଚି ନିରାଲ୍‌ ଲିଜାଃରେ ପଟମ୍‍କିୟାଏ, ଆଡଃ ସେରେଙ୍ଗ୍‌ରେ ଉରାକାନ୍ ତପାଗାଡ଼ାରେ ଗିତିଃକିୟାଏ । ଏନ୍ତେ ଏନ୍‌ ଦୁଆର୍‌କେ ମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ଦିରିତେ ବାଟିକେସେଦ୍‍ତାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌ ଆଡଃ ଯୋସିଆଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌ ଇନିଃକେ ଅକ୍‌ତାଃରେ ତପାକିୟାକ ଏନାକିନ୍ ନେଲ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ସେନଃୟାନ୍‍ଚି ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌, ଯାକୁବ୍‌ରାଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌, ଆଡଃ ସାଲୋମି ସେନ୍‌କେଦ୍‌ତେ ୟୀଶୁଆଃ ଗଏଃ ହଡ଼୍‌ମରେ ଗସଗେ ନାଗେନ୍ତେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ତେୟାଃ କିରିଙ୍ଗ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ଏତଆର୍‌ ହୁଲାଙ୍ଗ୍‌ ସେତାଃ ଇଦାନ୍‍ରେ ସିଙ୍ଗି ତୁରଃଲଃଗି ଇନ୍‌କୁ ତପାଗାଡ଼ା ଠାୟାଦ୍‌ତେ ସେନଃତାନ୍‌ ତାଇକେନାକ, ");
INSERT INTO unx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ଆଡଃ ଇନ୍‌କୁ ଆକ ଆକରେ ମେପେନ୍‌ୟାନାକ, “ତପାଗାଡ଼ା ଦୁଆର୍‌ରେୟାଃ ପୁରାଃ ମାରାଙ୍ଗ୍‌ ଦିରିକେ ଅକଏ ବାଟିଆତମାବୁଆଏ ?” ");
INSERT INTO unx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ମେନ୍‌ଦ ଇନ୍‌କୁ ଏନ୍‌ ଦିରିକେ ଆତମ୍‍ବାଟିକାନ୍ ନେଲ୍‍କେଦାକ, ଏନାଦ ପୁରାଃ ମାରାଙ୍ଗ୍‌ ଦିରି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ତପାଗାଡ଼ାରେକ ବଲୟାନ୍‍ଚି, ପୁଣ୍ଡି ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍‌ ମିଆଁଦ୍‌ ସେପେଡ଼େଦ୍‍କେ ଜମ୍‍ସାଃରେ ଦୁବାକାନ୍‍କ ନେଲ୍‌କିୟାଃ, ଆଡଃକ ଆକ୍‌ବାକାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ଇନିଃଦ ମେତାଦ୍‌କଆଏ, “ଆଲ୍‌ପେ ବରଏୟା, କ୍ରୁଶ୍‌ରେ କିଲାଗଏଃୟାନ୍‌ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁକେପେ ଦାଣାଁଁତାନା, ଇନିଃ ଜୀଉବିରିଦ୍‌ୟାନାଏ, ଇନିଃ ନେତାଃରେ ବାଙ୍ଗାଇୟା । ନେଲେପେ, ନେ ଠାୟାଦ୍‍ରେଗି ଇନିଃକେକ ବାଟିଆକାଇ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ମେନ୍‌ଦ ଜୁ ରୁହାଡ଼୍‌ପେ, ଆୟାଃ ଚେଲାକକେ ଆଡଃ ପାତ୍‌ରାସ୍‌କେ ଉଦୁବାକପେ, ଆପେଏତେ ଆୟାର୍‌ରେ ଇନିଃ ଗାଲିଲ୍‌ତେ ସେନଃତାନା, ଇନିଃ କାଜିୟାଦ୍‍ପେ ଲେକା ଏନ୍ତାଃରେ ଇନିଃକେପେ ନେଲିୟା ।” ");
INSERT INTO unx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ଆଡଃ ଇନ୍‌କୁ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ଚି ବରତାନ୍‌ ଆଡଃ ଏକ୍‌ଲାଅଃତାନ୍‌ଲଃ ତପାଗାଡ଼ାତାଃଏତେକ ନିର୍‌ୟାନା । ଇନ୍‍କୁକେଦ ବରଭେଦାଅ ହରାତେ ଜେତାଏକେ ଜେତ୍‌ନାଃ କାକ କାଜିୟାଦ୍‍କଆ । ");
INSERT INTO unx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ୟୀଶୁ ହାପ୍ତାରାଃ ପାହିଲାହୁଲାଙ୍ଗ୍‌ ସେତାଃଇଦାନ୍‍ରେ ଜୀଉବିରିଦ୍‍କେଦ୍‌ତେ, ଇନିଃ ସିଦାତେ ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌ତାଃରେ ଉଦୁବେନ୍‍ୟାନା, ଇନିଃତାଃଏତେ ସାତ୍‌ଠୁ ବଙ୍ଗାକକେ ଅଡଙ୍ଗ୍‌କାକ ତାଇନା । ");
INSERT INTO unx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ଇନିଃ ସେନ୍‍ୟାନ୍ତେ ୟୀଶୁଲଃ ତାଇକେନ୍‍କକେ ଉଦୁବାଦ୍‌କଆଏ । ଇନ୍‍କୁଦ ରାଆଃତାନ୍ ଆଡଃ ଏୟମ୍‍ତାନ୍‍କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ଇନିଃ ଇନ୍‌କୁକେ ୟୀଶୁ ଜୀଉବିରିଦାକାନାଏ ଆଡଃ ଆୟାଃତାଃ ଉଦୁବେନ୍‍ୟାନାଏ ନେଆଁଁ କାଜିକେଦ୍‍କଆଏ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନିଃକେ କାକ ବିଶ୍ୱାସ୍‍କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ଏନ୍‌ ତାୟମ୍‌ତେ, ଇନ୍‌କୁଏତେ ବାର୍‌ହଡ଼୍‌, ହାତୁତେକିନ୍ ରୁହାଡ଼୍‌ତାନ୍ ଦିପିଲିରେ, ୟୀଶୁ, ଏଟାଃ ମେଦ୍‍ମୁହାଁଡ଼୍‌ୟାନ୍ତେ ଇନ୍‌କିନ୍‌ତାଃ ହରାରେ ଉଦୁବେନ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ଇନ୍‌କିନ୍‌ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ଏଟାଃ ଚେଲାକକେ ଏନା ଉଦୁବାଦ୍‍କଆକିନ୍, ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନ୍‌କିନାଃ କାଜିୟଃ କାକ ବିଶ୍ୱାସ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ତାୟମ୍‌ତେ ୟୀଶୁ ଏଗାରାଝାନ୍‌ ଚେଲାକତାଃରେ ଜମ୍‌କ ଦୁବାକାନ୍‌ ଦିପିଲିରେ ଉଦୁବେନ୍‍ୟାନାଏ ଆଡଃ ଅକନ୍‌କ ଇନିଃକେ ଜୀଉବିରିଦାକାନ୍ ନେଲ୍‍କାଇ ତାଇକେନାକ, ଇନ୍‌କୁଆଃ କାଜିକକେ କାକ ବିଶ୍ୱାସ୍‌କେଦା ଆଡଃ ଇନ୍‌କୁଆଃ କେଟେଦ୍‌ମନ୍‍ ନାଗେନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ ମାରାଙ୍ଗ୍‌ମଚାକେଦ୍‍କଆଏ । ");
INSERT INTO unx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ଇନିଃ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଜୁ ଗଟା ଅତେଦିଶୁମ୍‌ତେପେ ଆଡଃ ସବେନ୍‌ ହଡ଼କକେ ନେ ସୁକୁକାଜି ଉଦୁବାକପେ । ");
INSERT INTO unx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ବିଶ୍ୱାସେନିଃ ଆଡଃ ବାପ୍ତିସ୍ମାଅଃନିଃ ବାଞ୍ଚାଅଃଆଏ, ମେନ୍‌ଦ କା ବିଶ୍ୱାସେନିଃ ବିଚାର୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ସାଜାଇ ନାମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ବିଶ୍ୱାସ୍‌ତାନ୍‌କକେଦ ପେଡ଼େଃକରାଃ କାମି ନାଗେନ୍ତେ ପେଡ଼େଃ ଏମଃଆ; ଇନ୍‌କୁ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ବଙ୍ଗାକ ହାର୍‌ଅଡଙ୍ଗ୍‌କଆ, ଇନ୍‌କୁ ନାୱା ଜାଗାର୍‌କ ବାଖାଁଣେଆ । ");
INSERT INTO unx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ଇନ୍‌କୁ ବିଙ୍ଗ୍‌କକେ ହାଲାଙ୍ଗ୍‌କରେ ଚାଏ ମାହୁଁରାକ ନୁଁଏରେଅଃ ଜେତାକାକ ରିକାଅଆଃ, ଇନ୍‌କୁ ଦୁକୁହାସୁତାନ୍‌କଆଃ ଚେତାନ୍‌ରେ ଆକଆଃ ତିଃଇକ ଦହଲେରେ, ଇନ୍‌କୁ ବୁଗିଅଃଆକ ।” ");
INSERT INTO unx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ୟୀଶୁ ପ୍ରାଭୁ ନେଆଁଁ କାଜିକେଦ୍‌କଚି, ସିର୍ମା ଦିଶୁମ୍‌ତେ ଇଦିୟାନା ଆଡଃ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଜମ୍‌ତିସାଃରେ ଦୁବ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ଏନ୍ତେ ଚେଲାକ ସେନଃୟାନ୍ତେ ସବେନ୍‌ତାଃରେ ପାର୍‌ଚାର୍‌କେଦାଃକ, ଆଡଃ ପ୍ରାଭୁ ଇନ୍‌କୁଲଃ କାମିକେଦାଏ ଆଡଃ ଆୟାଃ ଉଦୁବଃତାନ୍‌ କାଜିକେ ଚିହ୍ନାଁତେ ସାର୍‌ତି ତାନାଃ ମେନ୍ତେ ପକ୍‌ତାକେଦାଏ ଆଡଃ ଗାୱା ଏମ୍‌କେଦାଏ ।");
INSERT INTO unx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ହେ ଦୁଲାଡ଼୍‌ ଥିଅଫିଲ, ପୁରାଃ ହଡ଼କ ଆଲେ ଥାଲାରେ ହବାକାନ୍ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ଜାନାମ୍‌, ଗନଏଃ ଆଡଃ ଜୀଉବିନିରିଦ୍‌ରେୟାଃ ପକ୍‌ତାନ୍‌କାଜିକ ଅଲ୍‌ ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌କାଦାକ । ");
INSERT INTO unx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ଅକନ୍‌କଚି ନେ ହବାକାନ୍‌ ବିଷାଏକେ ଏନେଟେଦ୍‌ଏତେ ନେଲାକାଦାଃକ ଆଡଃ ହଡ଼କତାଃରେ ନେୟାଁ ଉଦୁବ୍‌କେଦାଃକ, ଏନ୍‌ ହଡ଼କତାଃଏତେ ଅକନ୍‌ ବିଷାଏଲେ ଇତୁଆକାନା ଏନ୍‌କାଜି ଇନ୍‌କୁ ଅଲାକାଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ଏ ମାଇନାନ୍ ଥିୟଫିଲସ୍‌, ଏନାନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ନେ ସବେନ୍‌ କାଜି ମୁଲ୍‌ଏତେ ବୁଗିଲେକା କୁଲିନାମ୍‌ ବାଡ଼ାକେଦ୍‌ତେ ସାରିକାଦାଇଙ୍ଗ୍‌, ଏନାମେନ୍ତେ ଆମାଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ପୁଥି ଲେକା ତାରାଗେନାଏତେ ସବେନ୍‌ କାଜି ଅନଲ୍‌ ସାନାଙ୍ଗ୍‌କେଦାଆଇଙ୍ଗ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ଜେ'ଲେକା ଆମ୍‌ ଅକନ୍‌ ସବେନ୍‌ କାଜିକମ୍ ଇତୁଆକାନା ଏନ୍‌ ସବେନ୍‌ କାଜିକରେୟାଃ ପକ୍‌ତାମ୍ ନାମ୍‌ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଯିହୁଦା ଦିଶୁମ୍‌ରେନ୍ ରାଜା ହେରୋଦ୍‌ଆଃ ଦିପିଲିରେ ଅବିୟଆଃ ଯାଜାକ୍‌ ଝୁଣ୍ଡ୍‌ରେନ୍ ଜାଖ୍‌ରିୟା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଯାଜାକ୍‌ ତାଇକେନାଏ । ଇନିୟାଃ ଘାର୍‌ନି ଏଲିଶାବେଥ୍‌, ଇନିଃ ହାରୁନ୍‌ଆଃ କିଲିରେନ୍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ଏନ୍‌ ବାରାନ୍‌କିନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଧାର୍‌ମାନ୍‌ ଆଡଃ ପ୍ରାଭୁଆଃ ସବେନ୍‌ ଆନ୍‌ଚୁ ଆଡଃ ରିତିରିୱାଜ୍‌ ବେଗାର୍‌ ଚିଟାତେ ବୁଗିଲେକା ମାନାତିଙ୍ଗ୍‌ ତାଇକେନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ମେନ୍‌ଦ ଇନ୍‌କିନାଃ ହନ୍‌ଗାଁଣା କାକ ତାଇକେନା, ଚିୟାଃଚି ଏଲିଶାବେଥ୍‌ଦ ଟଣିଟ୍‌ ତାଇକେନାଏ, ଆଡଃ ବାରାନ୍‌କିନ୍‌ ହାଡ଼ାମ୍ ବୁଢୀଆକାନ୍‌କିନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ଜାଖ୍‌ରିୟା, ଆୟାଃ ଝୁଣ୍ଡ୍‌ରେୟାଃ ପାଳି ଲେକାତେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଯାଜାକ୍‌ କାମି କାମିତାନ୍‍ ଇମ୍‌ତା, ");
INSERT INTO unx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ଯାଜାକ୍‌କଆଃ କାମିରେୟାଃ ରିତିଲେକାତେ ପାଞ୍ଜିଖାଡ଼ିଲଃ ଇନିଃକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ବଲକେଦ୍‌ତେ ବୁଗିନ୍‌ସୱାନ୍‌ତେୟାଃ ଧୁଆନ୍‌ ଉରୁବ୍ ଲାଗାତିଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ଆଡଃ ବୁଗିନ୍‌ସୱାନ୍‌ତେୟାଃ ଧୁଆନ୍‌ ଉରୁବ୍ ଦିପିଲିରେ ସବେନ୍‌ ହଡ଼କ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଚାରେ ବିନ୍ତିତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ଇମ୍‌ତାଙ୍ଗ୍‌ ଜାଖ୍‌ରିୟାରାଃ ଆୟାର୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଁତ୍‌ ଉଦୁବେନ୍‌ୟାନାଏ ଆଡଃ ଧୁଆନ୍‌ ଉରୁବ୍ ବେଦିରେୟାଃ ଜମ୍‌ସାଃରେ ତିଙ୍ଗୁୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜାଖ୍‌ରିୟା ଇନିଃକେ ନେଲ୍‌କେଦ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନା ଆଡଃ ବରକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ମେନ୍‌ଦ ଦୁଁତ୍‌ କାଜିକିୟାଏ, “ଏ ଜାଖ୍‌ରିୟା ! ଆଲ୍‌ମେ ବରୟାଃ, ଆମାଃ ବିନ୍ତିଦ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃ ଆୟୁମ୍‌ୟାନା । ଆମାଃ ଘାର୍‌ନି ଏଲିଶାବେଥ୍‌ ଆମାଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ କଡ଼ାହନ୍ଆଏ ଜାନାମିଁୟା, ଆଡଃ ଇନିଃକେ ଯୋହାନ୍‌ ମେନ୍ତେପେ ନୁତୁମିଁୟା । ");
INSERT INTO unx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ଆମ୍‌ ପୁରାଃଗି ସୁକୁ ରାସ୍‌କାୱାମ୍ ଆଡଃ ଆୟାଃ ଜାନାମ୍‌ରେ ପୁରାଃ ହଡ଼କ ରାସ୍‌କାୱାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ଇନିଃଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନେପେଲ୍‌ରେ ମାରାଙ୍ଗ୍‌ଅଃଆଏ, ଇନିଃ ଦାଖ୍‌ରାସି ଚାଏ ବୁଲଃତେୟାଃ ଚିଉଲାହ କାଏ ନୁଁଏୟା ଆଡଃ ଇନିଃ ଏଙ୍ଗାତେୟାଃ ଲାହିଦ୍‌ତେଗି ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଜଃଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ଆଡଃ ଇନିଃ ଇସ୍ରାଏଲ୍‌ ହଡ଼କଆଃଏତେ ପୁରାଃ ହଡ଼କକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆକଆଃ ପ୍ରାଭୁସାଃତେ ରୁହାଡ଼୍‌ ହିଜୁଃନାଙ୍ଗ୍‌ ଦେଙ୍ଗାକୱାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ଆଡଃ ଆପୁକଆଃ ମନ୍‌ ହନ୍‌କସାଃ ଆଡଃ କା ମାନାତିଙ୍ଗ୍‌ ତାନ୍‌କକେ ଧାର୍‌ମାନ୍‌କଆଃ ସେଣାଁଁସାଃ ରୁହାଡ଼୍‌କଆଏ ଆଡଃ ପ୍ରାଭୁନାଙ୍ଗ୍‌ ମିଆଁଦ୍‌ ବାଇସେକାଡ଼ାକାନ୍‌ ହଡ଼କେ ବାଇନାଗେନ୍ତେ ଇନିଃ ଏଲିୟଆଃ ଆତ୍ମା ଆଡଃ ପେଡ଼େଃତେ ଇନିୟାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ସେନେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ନେ କାଜି ଆୟୁମ୍‌ କେଦ୍‌ତେ, ଜାଖ୍‌ରିୟା ଦୁଁତ୍‌କେ କାଜିକିୟାଏ, “ଆମ୍‌ ଅକ୍‌ନାଃ କାଜିତାନାମ୍, ଏନା ସାର୍‌ତି କାଜି ମେନ୍ତେ ଚିଲ୍‌କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ? ଆଇଙ୍ଗ୍‌ଦ ହାଡ଼ାମ୍ ୟାନାଇଙ୍ଗ୍‌ ଆଡଃ ଆଇଁୟାଃ ଘାର୍‌ନିୟଗି ବୁଡି ୟାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ସିର୍ମାରେନ୍‌ ଦାସି କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଙ୍ଗ୍‌ ଗାବ୍ରିଏଲ୍‌ ଦୁଁତ୍‌ ତାନିଙ୍ଗ୍‌, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ତିଙ୍ଗୁନ୍‌ନିଃ ତାନିଙ୍ଗ୍‌ ଆଡଃ ଆମ୍‌କେ ନେ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ୟାଁଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ନାହାଁଃ ଆୟୁମେମ୍, ନେ ସବେନ୍‌ ସାର୍‌ତି କାଜି କା ପୁରାଅଃ ଜାକେଦ୍‌ ଆମ୍‌ ବାଖାଁଣ୍‌ କାମ୍‌ ଦାଡ଼ିୟାଃ ଚିୟାଃଚି ଆଇଁୟାଃ କାଜିରେ ଆମ୍‌ କାମ୍‌ ପାତିୟାର୍ କେଦାଃ, ଏନାଦ ଠିକ୍‌ ନେଡାରେ ପୁରାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ଇମ୍‌ତାଙ୍ଗ୍‌ ହଡ଼କ ଜାଖ୍‌ରିୟାକେ ନେଲ୍‌ହରାଇତାନ୍‌କ ତାଇକେନା ଆଡଃ ଇନିଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃଏତେ ଜାଲ୍‌ଦି କାଏ ଅଡଙ୍ଗ୍‌ଅଃତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ଆକ୍‌ଦାନ୍ଦାଅଃ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ଚିମ୍‌ତାଙ୍ଗ୍‌ ଜାଖ୍‌ରିୟା ଅଡଙ୍ଗ୍‌ୟାନା, ଇନିଃ ଇନ୍‌କୁକେ ଜେତ୍‌ନାଃ କାଜି କାଏ ଦାଡ଼ିକେନା । ଏନାତେ ଇନ୍‌କୁ ଆଟ୍‌କାର୍‌ କେଦାଃକ ଯେ ଇନିଃ ମାନ୍ଦିର୍‌ ଭିତାର୍‌ରେ ଜେତାଏୟାଃ ଦାର୍‌ଶାନ୍‌ନାଏ ନେଲ୍‌କାଦା, ଚିୟାଃଚି ଇନିଃ ଇନ୍‌କୁକେ ତିଃଇତେ ଉଦୁବ୍‌କତାନ୍ ତାଇକେନାଏ ଆଡଃ କାଏ ବାଖାଁଣ୍‌ ଦାଡ଼ିକେଦା । ");
INSERT INTO unx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ଜାଖ୍‌ରିୟାରାଃ ସେୱା ପାଳିରେୟାଃ ସାମାଏ ପୁରାୟାନ୍‌ଚି ଇନିଃ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ନେଆଁଁ ତାୟମ୍‌ତେ ଜାଖ୍‌ରିୟାରାଃ ଘାର୍‌ନି ଏଲିଶାବେଥ୍‌ ହାମ୍ବାଲ୍‌ ରୋୱାୟାନାଏ । ଆଡଃ ଇନିଃ ପାଞ୍ଚ୍‌ ମାହିଁନା ଜାକେଦ୍‌ ଜେତାଏକେ ଜେତ୍‌ନାଃ କାଏ କାଜିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ଏନ୍ତେ ଏଲିଶାବେଥ୍ କାଜିକେଦାଏ, “ନେଲେପେ, ଟୁଣ୍ଡୁରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ନେଆଁଁ ରିକାକାଦାଏ । ହଡ଼କଆଃ ଥାଲାରେ ଆଇଁୟାଃ ଗିହୁଃ ଆତମେ ନାଗେନ୍ତେ ପ୍ରାଭୁ ଆଇଙ୍ଗ୍‌କେ ଦେଙ୍ଗାକେଦିୟାଁ !” ");
INSERT INTO unx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଏଲିଶାବେଥ୍‌ଆଃ ହାମ୍ବାଲ୍‌ରୋୱାରାଃ ଛ ମାହିଁନା ତାୟମ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଗାବ୍ରିଏଲ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କେ ଗାଲିଲ୍‌ରେୟାଃ ନାଜ୍‌ରେତ୍‌ ନାଗାର୍‌ତେ ମିଆଁଦ୍‌ ଡିଣ୍ଡାକୁଡ଼ିତାଃତେ କୁଲ୍‌କିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ଏନ୍‌ ଡିଣ୍ଡାକୁଡ଼ିଦ ଦାଉଦ୍‌ଆଃ କିଲିରେନ୍ ଯୋଷେଫ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ନାଙ୍ଗ୍‌ ଆସିଆକାନାଏ ତାଇକେନା, ଇନିୟାଃ ନୁତୁମ୍‌ ମାରିୟାମ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌ ଇନିୟାଃ ଅଡ଼ାଃତେ ବଲକେଦ୍‌ତେ କାଜିକିୟାଏ, “ଏ ଲିବୁଇୟାକାନ୍‌ନିଃ, ଆମ୍‌କେ ଜହାର୍ ! ପ୍ରାଭୁ ଆମ୍‌କେ ପୁରାଃଗି ଲିବୁଇୟା କାଦ୍‌ମେଁୟାଏ ଆଡଃ ଇନିଃ ଆମାଃଲଃ ମେନାଇୟାଃ !” ");
INSERT INTO unx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ମେନ୍‌ଦ ମାରିୟାମ୍‌ ଇନିୟାଃ କାଜିତେ ପୁରାଃଗି ଆକ୍‌ଦାନ୍ଦାଅୟାନା, ଆଡଃ ନେୟାଁ ଚିଲ୍‌କାନ୍ ଜହାର୍ ତାନାଃ ମେନ୍ତେ ଆୟାଃ ମନ୍‌ରେ ଉଡ଼ୁଃତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ଏନାତେ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌ ଇନିଃକେ କାଜିକିୟାଏ, “ଏ ମାରିୟାମ୍‌, ଆଲମ୍‌ ବରଏୟା, ଚିୟାଃଚି ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆୟାର୍‌ରେ ସାୟାଦ୍‌ ନାମାକାଦାମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ଆଡଃ ନେଲେମେ, ଆମ୍‌ ହାମ୍ବାଲ୍ ରୋୱାଅଃଆମ୍‌ ଆଡଃ ମିଆଁଦ୍‌ କଡ଼ାହନ୍‌ନାମ୍ ଜାନାମିଁୟା ଆଡଃ ଇନିଃକେ ୟୀଶୁ ନୁତୁମିଁୟାମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ଇନିଃ ମାରାଙ୍ଗ୍‌ଅଃଆଏ ଆଡଃ ହଡ଼କ ଇନିଃକେ ମାରାଙ୍ଗ୍‌ ଉତାର୍‌ନିୟାଃ ହନ୍‌ ମେନ୍ତେକ କାଜିୟାଃ ଆଡଃ ପ୍ରାଭୁ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଇନିୟାଃ ଆପୁତେ ଦାଉଦ୍‌ ରାଜାରାଃ ରାଜ୍‌ଗାଦି ଏମାଇୟା । ");
INSERT INTO unx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ଆଡଃ ଇନିଃ ଜାନାଅଜାକେଦ୍ ଯାକୁବ୍‌ଆଃ କିଲିରେନ୍‌କଆଃ ରାଜା ତାଇନାଏ, ଇନିୟାଃ ରାଇଜ୍‌ ଚିଉଲାଅ କା ଟୁଣ୍ଡୁଃଆ !” ");
INSERT INTO unx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ମାରିୟାମ୍‌ ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌କେ କୁଲିକିୟାଏ, “ନେଆଁଁ ଚିଲ୍‌କାତେ ହବାଅଆଃ ? ଆଇଙ୍ଗ୍‌ଦ ଜେତାନ୍‌ କଡ଼ାକେ କାଇଙ୍ଗ୍‌ ସାରିୟାକାଇଜାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ସିର୍ମାରେନ୍‌ ଦୁଁତ୍‌ ମାରିୟାମ୍‌କେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ପାବିତାର୍‌ ଆତ୍ମା ଆମ୍‌ରେ ଆଡ଼୍‌ଗୁନାଏ ଆଡଃ ମାରାଙ୍ଗ୍‌ ଉତାର୍‌ନିୟାଃ ପେଡ଼େଃ ଆମ୍‌କେ ଉମ୍ବୁଲ୍ ମେଁୟାଏ । ଏନାନାଗେନ୍ତେ ଜାନାମଃତାନ୍ ହନ୍‌ ପାବିତାର୍‌ ହବାଅଃଆଏ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ମେନ୍ତେ ନୁତୁମଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ଆଡଃ ନେଲେମେ, ଆମାଃ ମିଶିମ୍ ଏଲିଶାବେଥ୍‌ ବୁଡିୟଃତାନ୍ ନେଡାରେ ମିଆଁଦ୍‌ କଡ଼ାହନ୍‌ ଜାନାମିଁୟାଏ, ଆଡଃ ଇନିଃଦ ଟଣିଟ୍‌ ମେନ୍ତେ କାଜିୟଃତାନ୍ ତାଇକେନାଏ, ନାହାଁଃ ଇନିୟାଃ ହଡ଼୍‌ମଃତେୟାଃ ଛ ମାହିଁନା ହବାଅଃତାନା । ");
INSERT INTO unx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆୟାର୍‌ରେଦ ଜାହାନ୍ କାଜି କା ହାମ୍ବାଲଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ଏନ୍ତେ ମାରିୟାମ୍‌ କାଜିକିୟାଏ, “ନେଲେମେ, ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦାସି ତାନିଙ୍ଗ୍‌ ଆମାଃ କାଜିଲେକାଗି ଆଇଙ୍ଗ୍‌ରେ ହବାଅଃକା,” ଏନ୍ତେଦ ଦୁଁତ୍‌ ଇନିଃତାଃଏତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ଏନ୍ତେ ମାରିୟାମ୍‌ ଏନ୍‌ ନେଡାରେ ବିରିଦ୍‌ୟାନ୍‌ଲଃ ବୁରୁଦିଶୁମ୍ ଯିହୁଦା ରାଇଜ୍‌ରେୟାଃ ମିଆଁଦ୍‌ ସାହାର୍‌ତେ ଜାଲ୍‌ଦିଗି ସେନଃ ଦାବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ଇନିଃ ଜାଖ୍‌ରିୟାରାଃ ଅଡ଼ାଃତେ ବଲୟାନ୍‌ଚି ଏଲିଶାବେଥ୍‌କେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ଆଡଃ ଏଲିଶାବେଥ୍ ମାରିୟାମ୍‌ଆଃ ଜହାର୍ ଆୟୁମ୍‌କେଦ୍‌ଚି ଏଲିଶାବେଥ୍‌ଆଃ ଲାହିଦ୍‌ରେନ୍ ହନ୍‌ ଏନେଃକ୍‌କେଦାଏ ଆଡଃ ଏଲିଶାବେଥ୍ ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ଇନିଃ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ଆମ୍‌ କୁଡ଼ିକଆଃ ଥାଲାରେମ୍ ଧାଇନ୍‌ଗିୟାଃ ଆଡଃ ଆମ୍‌ ଜାନାମିଁ ହନ୍‌ ଧାଇନ୍‌ଗିୟାଏ ! ");
INSERT INTO unx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ମେନ୍‌ଦ ଆଇଁୟାଃ ପ୍ରାଭୁଆଃ ଏଙ୍ଗାତେ ଆଇଙ୍ଗ୍‌ତାଃତେ ହିଜୁଆକାନାଏ, ଏନା ଆଇଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଚିଲ୍‌କାତେ ହବାକାନା ? ");
INSERT INTO unx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ଚିୟାଃଚି, ନେଲେମେ, ଆମାଃ ଜହାର୍ ଆୟୁମ୍‌କେଦ୍‌ଚି ଆଇଁୟାଃ ଲାହିଦ୍‌ରେନ୍‌ ହନ୍‌ଦ ରାସ୍‌କାତେ ଏନେଃକ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ଅକଏ ବିଶ୍ୱାସ୍‌କେଦାଏ ଇନିଃ ଧାଇନ୍‌ଗିୟାଃଏ, ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ଇନିଃକେ କାଜିୟାକାନ୍ କାଜିଦ ହବାଅଃଗିଆ !” ");
INSERT INTO unx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ଆଡଃ ମାରିୟାମ୍‌ କାଜିକେଦାଏ, “ଆଇଁୟାଃ ମନ୍‌ସୁରୁଦ୍‌ ପ୍ରାଭୁକେ ମାରାଙ୍ଗ୍‌ଇତାନା; ");
INSERT INTO unx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ଆଡଃ ଆଇଁୟାଃ ଜୀଉ ବାଞ୍ଚାଅନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ରାସ୍‌କାଅଃତାନାଏ, ");
INSERT INTO unx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ଚିୟାଃଚି ଇନିଃ ଆୟାଃ ଦାସିଆଃ ନାରାଦୁରାକେ ନେଲାକାଦାଏ ! ଆଡଃ ନେଲେମେ, ନାହାଁଃଏତେ ସବେନ୍‌ ପାରିୟାରେନ୍‌ ହଡ଼କ ଆଇଙ୍ଗ୍‌କେ ସୁକୁତାନ୍‌ଗିୟାମେ ମେନ୍ତେକ ମେତାଇୟାଁ, ");
INSERT INTO unx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ଚିୟାଃଚି ପେଡ଼େୟାନ୍ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଁୟାଃନାଙ୍ଗ୍‌ ମାପ୍‌ରାଙ୍ଗ୍‌ କାମିକ କାମିୟାକାଦାଏ । ଇନିୟାଃ ନୁତୁମ୍‌ ପାବିତାର୍‌ଗିୟାଃ; ");
INSERT INTO unx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ଆଡଃ ଇନିଃକେ ବରତାନ୍‌କଆଃନାଙ୍ଗ୍‌ ଇନିୟାଃ ଦାୟା ଇନ୍‌କୁଆଃ ପିଢ଼ି ପିଢ଼ି ଜାକେଦ୍‌ ଜାନାଅଗି ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ଇନିଃ ଆୟାଃ ସୁପୁତାଃରେୟାଃ ପେଡ଼େଃ ଉଦୁବାକାଦାଏ । ଇନିଃ ମାରାଙ୍ଗ୍‌ୟେଁନ୍‌ ତାନ୍‌କକେ ଆକଆଃ ମନ୍‌ରେୟାଃ ଉଡ଼ୁଃଏତେ ଛିତିବିତିୟା କାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ଇନିଃ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ ପେଡ଼େୟାନ୍‌ ରାଜାକକେ ରାଜ୍‌ଗାଦିଏତେ ଆଡ଼୍‌ଗୁଆ କାଦ୍‌କଆଏ, ଆଡଃ ନାରାଦୁରାକକେ ଚେତାନ୍‌ତେ ରାକାବା କାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ଇନିଃ ରେଙ୍ଗେଜାକାନ୍‌କକେ ବୁଗିନ୍‌ ବିଷାଏତେ ବିୟାକାଦ୍‌କଆଏ, ମେନ୍‌ଦ କିସାଁଣ୍‌ ହଡ଼କକେ ସାମା ତିଃଇଗି କୁଲ୍‌ରୁହାଡ଼୍‌ କାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ଆବୁଆଃ ପୁର୍‌ଖାହାଡ଼ାମ୍‌କକେ କାଜିୟାକାଦ୍‌କ ତାଇକେନ୍‌ ଲେକା, ଇନିଃ ଆୟାଃ ଦାସି ଆବ୍ରାହାମ୍‌ ଆଡଃ ଇସ୍ରାଏଲ୍‌ ହଡ଼କକେ ଦାୟା କାଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ଇନିଃ ଜାନାଅ ଜାନାଅ ନାଗେନ୍ତେ ଆବ୍ରାହାମ୍‌ ଆଡଃ ଆୟାଃ ସବେନ୍‌ କିଲିକକେ ଲିନିବୁଇ ଉଦୁବ୍‌ ନାଗେନ୍ତେ କାଏ ରିଡ଼ିଙ୍ଗ୍‌କାଦା ।” ");
INSERT INTO unx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ମାରିୟାମ୍‌ ଆପି ମାହିଁନା ଜାକେଦ୍‌ ଏଲିଶାବେଥ୍‌ଆଃ ଅଡ଼ାଃରେ ତାଇନ୍‌ୟାନାଏ, ତାୟମ୍‌ତେ ଆୟାଃ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ଏଲିଶାବେଥ୍‌ଆଃ ହନ୍‌ଜାନାମ୍‌ ଦିପିଲି ସେଟେର୍‌ୟାନା, ଆଡଃ ଇନିଃ ମିଆଁଦ୍‌ କଡ଼ାହନ୍‌ ଜାନାମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଯେ ଏଲିଶାବେଥ୍‌କେ ପୁରାଃଗି ଲିବୁଇୟାକାଇୟାଏ ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆୟାଃ ହପର୍‌ଜାପାଃରେନ୍ ହଡ଼କ ଆଡଃ ପାରିବାର୍‌ରେନ୍‌କ ଆୟାଃଲଃକ ରାସ୍‌କାୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ହନ୍‌ ଜାନାମ୍‌ରେୟାଃ ଇରାଲିୟା ମାହାଁରେ ଇନ୍‌କୁ ବାଲେଃହନ୍‌କେ ଖାତ୍‌ନାଅ ନାଗେନ୍ତେକ ହିଜୁଃୟାନା, ଆଡଃ ଆୟାଃ ଆପୁତେୟାଃ ନୁତୁମ୍‌ଲେକା ଆଇଃକ୍‌କେ ଜାଖ୍‌ରିୟା ମେନ୍ତେ ନୁତୁମିଁ ତାନ୍‌କ ସାନାଙ୍ଗ୍‌ ତାଇକେନା, ");
INSERT INTO unx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ମେନ୍‌ଦ ଇନିୟାଃ ଏଙ୍ଗାତେ କାଜିକେଦାଏ, “ବାନଃଗି ଇନିଃକେ ଯୋହାନ୍‌ ନୁତୁମଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ଇନ୍‌କୁ ଏଲିଶାବେଥ୍‌କେ କାଜିକିୟାଃକ, “ଆପେୟାଃ କିଲିରେନ୍ ହାଗା ହନ୍‌କରେ ଜେତାଏୟାଃ ନୁତୁମ୍‌ ନେ ଲେକା ବାନଃଆ !” ");
INSERT INTO unx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ଏନ୍ତେ ଏନ୍‌ ସିଟିଆକେ ଚିକାନ୍‌ ନୁତୁମ୍‌ ନୁତୁମଃଆ ମେନ୍ତେ ଆୟାଃ ଆପୁତେ ସାନାଙ୍ଗ୍‌ତାନାଏ, ଏନା ସାରିନାଙ୍ଗ୍‌ ଆପୁତେକେ ତିଃଇତେକ କୁଲିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆପୁତେ ମିଆଁଦ୍‌ ତାକ୍‌ତା ଆସିକେଦ୍‌ଚି, “ବାଲେଃହନ୍‌ଆଃ ନୁତୁମ୍‌ ଯୋହାନ୍‌ ତାନାଃ” ମେନ୍ତେ ଅଲ୍‌କେଦାଏ, ଏନାତେ ସବେନ୍‌କ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ଆଡଃ ଇମ୍‌ତାଗି ଇନିୟାଃ ମଚା ଆଡଃ ଆଲାଙ୍ଗ୍‌ ରାଡ଼ାୟାନା ଆଡଃ ଇନିଃ ଆଡଃମିସା ବାଖାଁଣ୍‌ ଏଟେଦ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ଏନାତେ ଇନ୍‌କୁଆଃ ସବେନ୍‌ ହପର୍‌ଜାପାଃରେନ୍‌କ ବରକେଦାଃକ, ଆଡଃ ସବେନ୍‌ କାଜି ଯିହୁଦା ଦିଶୁମ୍‌ରେୟାଃ ଗଟା ବୁରୁ ଦିଶୁମ୍‌ରେ ଉମିନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ନେ କାଜି ଆୟୁମାକାଦ୍ ସବେନ୍‌ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନ୍‌ଲଃ ଆକଆଃ ଆପ୍‌ନାଃ ମନ୍‌ରେ କୁଲିକେଦାଃକ, “ନିଃ ଚିଲ୍‌କାନ୍‌ ହନ୍‌ନାଏ ହବାଅଆଃ ?” ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ତିଃଇ ଇନିଃଲଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ଆଡଃ ଯୋହାନ୍‌ଆଃ ଆପୁତେ ଜାଖ୍‌ରିୟା ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଃୟାନ୍ତେ, ନେ ଆୟାର୍‌କାଜିୟାଏ ଉଦୁବ୍‌କେଦାଃ : ");
INSERT INTO unx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ଇସ୍ରାଏଲ୍‌ଆଃ ପ୍ରାଭୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାହାରାଅ ହବାଅଃକା ! ଚିୟାଃଚି ଇନିଃଦ ଆୟାଃ ହଡ଼କକେ ଦେଙ୍ଗାନାଙ୍ଗ୍‌ ମେନ୍ତେ ହିଜୁଆକାନାଏ ଆଡଃ ଇନ୍‌କୁକେ ରାଡ଼ା କାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ଇନିଃ ଆବୁଆଃନାଙ୍ଗ୍‌ ମେନ୍ତେ ଆୟାଃ ଦାସି ଦାଉଦ୍‌ଆଃ କିଲିଏତେ ମିଆଁଦ୍‌ ପେଡ଼େୟାନ୍‌ ଜୀଉବାଞ୍ଚାଅନିଃକେ ଏମାକାଦ୍‌ବୁଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ନାଙ୍କ ପାରିୟାଏତେ ତାଇନଃତାନ୍ ତାଇକେନ୍‌ ଆୟାଃ ପାବିତାର୍‌ ନାବୀକଆଃ ମଚାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ନେୟାଁଏ ଉଦୁବ୍‌ଲେଦା । ");
INSERT INTO unx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ଏନ୍‌ଲେକାଗି ଆବୁଆଃ ବାଇରିକଏତେ ଆଡଃ ସବେନ୍‌ ଖିସ୍‌ଆବୁତାନ୍‌କଆଃ ତିଃଇଏତେ ଜୀଉବାଞ୍ଚାଅ ଏମାକାଦ୍‌ବୁଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ଆବୁଆଃ ପୁର୍‌ଖାହାଡ଼ାମ୍‌କକେ ଦାୟାକଆ ଆଡଃ ଆୟାଃ ପାବିତାର୍‌ ରାଜିନାମାରାଃ କାଜିକେ ପାହାମେ ନାଗେନ୍ତେ, ");
INSERT INTO unx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ଇନିଃ ଆବୁଆଃ ଆପୁ ଆବ୍ରାହାମ୍‌ଲଃ କିରିୟାକାଦ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ଆବୁକେ ଆବୁଆଃ ବାଇରିକଆଃ ତିଃଇଏତେ ବାଞ୍ଚାଅବୁଆଏ, ଆଡଃ କା ବରତାନ୍‌ଲଃ ଇନିୟାଃ ସେୱାନାଙ୍ଗ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ପାବିତାର୍‌ ଆଡଃ ଧାର୍‌ମାନ୍‌ ଲେକାତେ ଇନିୟାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଆବୁ ଜାଉଜରଙ୍ଗ୍‌ବୁ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ଆଡଃ ଏ ହନ୍‌, ଆମ୍‌ ମାରାଙ୍ଗ୍‌ ଉତାର୍‌ନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନାବୀ ନୁତୁମଃଆମ୍‌ ଆମ୍‌ଦ ପ୍ରାଭୁଆଃ ଆୟାର୍‌ରେ ଇନିୟାଃ ହରା ବାବାଇତେମ୍ ସେନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ଇନିୟାଃ ହଡ଼କକେ ଆମ୍‌ ଆକଆଃ ପାପ୍‌ ଛାମାରେୟାଃ ହରାତେ ଜୀଉବାଞ୍ଚାଅରାଃ ସେଣାଁଁମ୍‌ ଉଦୁବାକଆ । ");
INSERT INTO unx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାରାଙ୍ଗ୍‌ ଲିବୁଇତେ ତୁରୋଃତାନ୍ ସିଙ୍ଗି ସିର୍ମାଏତେ ଆବୁତାଃରେ ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ଏନା ନୁବାଃରେୟାଃ ଆଡଃ ଗନଏଃରେୟାଃ ଉମ୍ବୁଲ୍‌ରେ ଦୁବାକାନ୍‌କକେ ମାର୍ସାଲ୍‌କଆଏ, ଆଡଃ ଜୀଉ ସୁକୁରେୟାଃ ହରାରେ ସେନ୍‌ନାଙ୍ଗ୍‌ ଆୟାର୍‌ ଇଦିକଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ନେ ଲେକାଗି ଏନ୍‌ ସିଟିଆ ହନ୍‌ ମାଡ଼ି ମାଡ଼ିତେ ହାରା ଇଦିୟାନ୍‌ଲଃ ଆତ୍ମାରେ ପେଡ଼େଃ ଇଦିୟାନାଏ, ଆଡଃ ଇସ୍ରାଏଲ୍‌ତାଃ ଆଉରି ଉଦୁବଃ ଜାକେଦ୍‌ ବିର୍‌ରେ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌କରେ ଗଟା ରୋମ୍‌ ଦିଶୁମ୍‌ରେନ୍‌କଆଃ ନୁତୁମ୍‌ ଅଲ୍‌ଲଃକା ମେନ୍ତେ ଲାଟ୍‌ସାହେବ୍‌ କାଇସାର୍‌ ଆଗସ୍ତସ୍‌ ହୁକୁମ୍‌ ଜାରିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","କୁରିଣିୟ ନୁତୁମ୍‌ ସିରିୟାରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ତାଇକେନ୍‌ ଦିପିଲିରେ ନେଆଁଁ ପାହିଲା ନୁତୁମ୍‌ ଅନଲ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ଏନା ନାଗେନ୍ତେ ସବେନ୍‌କ ଆକଆଃ ନୁତୁମ୍‌ ଅଲ୍‌ରିକାନାଙ୍ଗ୍‌ ଆକଆଃ ଆକଆଃ ନାଗାର୍‌ତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ଆଡଃ ଯୋଷେଫ୍‌ହଗି ନୁତୁମ୍‌ ଅଲ୍‌ରିକା ନାଗେନ୍ତେ ମାରିୟାମ୍‌ଲଃ ଗାଲିଲ୍‌ରେୟାଃ ନାଜ୍‌ରେତ୍‌ ନାଗାର୍‌ଏତେ ଯିହୁଦା ଦିଶୁମ୍‌ରେୟାଃ ବେଥ୍‌ଲେହେମ୍‌ ନୁତୁମ୍‌ ଦାଉଦ୍‌ଆଃ ନାଗାର୍‌ତେକିନ୍ ସେନ୍‌କେନା, ଚିୟାଃଚି ଯୋଷେଫ୍‌ ଦାଉଦ୍‌ଆଃ କିଲି ଆଡଃ ଅଡ଼ାଃରେନ୍‌ନିଃ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ଯୋଷେଫ୍‌ ନାଙ୍ଗ୍‌ ଆସିଆକାନ୍‌ କୁଡ଼ିଲଃ ନୁତୁମ୍‌ ଅଲ୍‌ରିକାତେ ହିଜୁଃୟାନା, ଇମ୍‌ତା ଇନିଃ ହାମ୍ବାଲ୍‌ରୋୱା କାନାଏ ତାଇକେନା । ଏନ୍‌ କୁଡ଼ିରାଃ ନୁତୁମ୍‌ ମାରିୟାମ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ଇନ୍‌କିନ୍‌ ବାଏତୁଲାମ୍‌ ରେନ୍‌କିନ୍ ତାଇକେନା ଇମ୍‌ତାଙ୍ଗ୍‌ ମାରିୟାମ୍‌ଆଃ ରାୱାଲଃରେୟାଃ ନେଡା ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ଆଡଃ ଇନିଃ ଆୟାଃ ମୁତ୍‌କୁଲହନ୍‌ ଜାନାମ୍‌କିୟାଏ, ଆଡଃ ଇନିଃକେ ଲିଜାଃତେ ପୋଟମ୍‌କିଃତେ ଡାଡାକାରେୟାଏ ବାଟିକିୟାଃ, ଚିୟାଃଚି ଇନ୍‌କିନାଃ ନାଗେନ୍ତେଦ ଡେରା ଅଡ଼ାଃରେ ଠାୟାଦ୍‌ହ କା ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ଆଡଃ ଏନ୍‌ ହାତୁ ଜାପାଃରେୟାଃ ପିଡ଼ିରେ ମିଣ୍ଡିଗୁପିମାହାରାକ ତାଇକେନା, ଇନ୍‌କୁ ନିଦାରେ ଆକଆଃ ମିଣ୍ଡିକକେ ହରତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ଆଡଃ ପ୍ରାଭୁଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ଇନ୍‌କୁତାଃରେ ତିଙ୍ଗୁୟାନାଏ ଆଡଃ ପ୍ରାଭୁଆଃ ମାନାରାଙ୍ଗ୍‌ରାଃ ମାର୍ସାଲ୍‌ ଇନ୍‌କୁତାଃରେ ଜୁଲ୍‌ବିୟୁର୍‌ୟାନା ଆଡଃ ଇନ୍‌କୁ ପୁରାଃଗିକ ବରକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ମେନ୍‌ଦ ଦୁଁତ୍‌ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଆଲ୍‌ପେ ବରୟାଃ ! ନେଲେପେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ପୁରାଃ ରାସ୍‌କାରେୟାଃ ସୁକୁକାଜିଙ୍ଗ୍‌ ଉଦୁବାପେତାନା, ଏନା ସବେନ୍‌ ହଡ଼କଆଃ ନାଗେନ୍ତେ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ଚିୟାଃଚି ତିସିଙ୍ଗ୍‌ଦ ଦାଉଦ୍‌ଆଃ ନାଗାର୍‌ରେ ଆପେୟାଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ବାଞ୍ଚାଅନିଃ ଜାନାମା କାନାଏ, ଇନିଃ ଖ୍ରୀଷ୍ଟ୍‌ ପ୍ରାଭୁ ତାନିଃ ! ");
INSERT INTO unx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ଆଡଃ ଆପେୟାଃ ନାଗେନ୍ତେ ନେଆଁଁ ଚିହ୍ନାଁ ତାନାଃ, ଆପେ ମିଆଁଦ୍‌ ବାଲେଃ ହନ୍‌କେ ଲିଜାଃତେ ପୋଟମାକାନ୍ ଆଡଃ ଡାଡାକାରେ ବାଟିୟାକାନ୍‌ପେ ନାମିୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ଇମ୍‌ତାଗି ଏନ୍‌ ଦୁଁତ୍‌ଲଃ ସିର୍ମାରେନ୍‌ ଫାଉଦ୍‌କ ହୁଣ୍ଡିୟାନାକ ଆଡଃ ଇନ୍‌କୁ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାରାଙ୍ଗ୍‌ଇତାନ୍‌ଲଃ କାଜିକେଦାଃକ : ");
INSERT INTO unx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ସାଲାଙ୍ଗିଉତାର୍‌ ସିର୍ମାରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌, ଆଡଃ ଅତେରେ ଆୟାଃ ସୁକୁଆକତାନ୍ ହଡ଼କରେ ସୁକୁ ହବାଅଃକା !” ");
INSERT INTO unx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ଦୁଁତ୍‌କ ଇନ୍‌କୁତାଃଏତେ ସିର୍ମାତେକ ସେନଃୟାନ୍‌ଚି, ମିଣ୍ଡିଗୁପିମାହାରାକ ଆକ ଆକରେ ମେନ୍‌କେଦାଃକ, “ଦଲାବୁ ବେଥ୍‌ଲେହେମ୍‌ତେବୁଆ ଆଡଃ ପ୍ରାଭୁ ଉଦୁବାକାଦ୍‌ବୁଆଏ ଏନ୍‌ ହବାକାନ୍‌ କାଜିବୁ ନେଲେୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ଆଡଃ ଇନ୍‌କୁ ଜାଲ୍‌ଦିଗି ସେନ୍‌ତେବାଃୟାନ୍ତେ ମାରିୟାମ୍‌, ଯୋଷେଫ୍‌ ଆଡଃ ଡାଡାକାରେ ବାଟିୟାକାନ୍ ବାଲେଃ ହନ୍‌କେକ ନେଲ୍‌ନାମ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ଇନ୍‌କୁ ଇନିଃକେ ନେଲ୍‌କିଃତେ ହନ୍‌ଆଃ ବିଷାଏରେ ଦୁଁତ୍‌ କାଜିଲେଦ୍ କାଜିକ ଉଦୁବ୍‌ବାଡ଼ାକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ମିଣ୍ଡିଗୁପିମାହାରାକ ଉଦୁବ୍‌କେଦ୍ କାଜିତେ ସବେନ୍‌ ଆୟୁମ୍‌କେଦ୍‌ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ମେନ୍‌ଦ ମାରିୟାମ୍‌ ନେ ସବେନ୍‌ କାଜି ଆୟାଃ ମନ୍‌ରେ ଦହକେଦାଏ ଆଡଃ ପୁରାଃ ଉଡ଼ୁଃତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ଆଡଃ ମିଣ୍ଡିଗୁପିମାହାରାକକେ ଉଦୁବ୍‌ଲେନ୍‌ଲେକା, ଏନ୍‌ ସବେନାଃ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆଡଃ ନେଲ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ଦୁରାଙ୍ଗ୍‌ତାନ୍‌ଲଃ ଇନ୍‌କୁ ରୁହାଡ଼୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଏନ୍‌ ସିଟିଆକେ ଇରାଲିୟା ମାହାଁ ହବାୟାନ୍‌ଲଃ ଖାତ୍‌ନାଅକିୟାକ, ଆଡଃ ଇନିଃକେ ୟୀଶୁ ମେନ୍ତେକ ନୁତୁମ୍‌କିୟାଃ, ନେ ନୁତୁମ୍‌ ଇନିୟାଃ ହାମ୍ବାଲ୍‌ରୋୱା ହବାଅଃ ସିଦାରେ ଦୁଁତ୍‌ଆଃ ହରାତେ ନୁତୁମାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ମୁଶାରାଃ ଆନ୍‌ଚୁଲେକା ଇନ୍‌କୁଆଃ ଫାର୍‌ଚିରେୟାଃ ନେଡା ତେବାଃୟାନ୍‌ରେ, ପ୍ରାଭୁଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ରାକାବି ନାଗେନ୍ତେ ଯୋଷେଫ୍‌ ଆଡଃ ମାରିୟାମ୍‌ ଇନିଃକେ ଯୀରୁଶାଲେମ୍‌ ମାନ୍ଦିର୍‌ତେକିନ୍ ଇଦିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ପ୍ରାଭୁଆଃ ଆନ୍‌ଚୁରେ ଅଲାକାନା, “ସବେନ୍‌ ମୁତ୍‌କୁଲ୍‌ କଡ଼ାହନ୍‌କ ପ୍ରାଭୁଆଃ ନାଗେନ୍ତେକ ପାବିତାରଃକା,” ");
INSERT INTO unx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ଆଡଃ ଇନ୍‌କିନ୍‌ ପ୍ରାଭୁଆଃ ଆନ୍‌ଚୁରେୟାଃ କାଜିଲେକା, ବାରିୟା ପୁତାମ୍ ଚାଏ ବାରିୟା ଦୁଦୁମୁଲ୍‌ ହନ୍‌କିନ୍‌କେ ଦାଣେଁ ରାକାବ୍‌ତେକିନ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ନେଲେପେ, ଯୀରୁଶାଲେମ୍‌ରେ ଶିମିୟନ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ, ଇନିଃ ଧାର୍‌ମାନ୍ ଆଡଃ ମାନାତିଙ୍ଗ୍‌ନିଃ ତାଇକେନାଏ । ଇନିଃ ଇସ୍ରାଏଲ୍‌ ହଡ଼କଆଃ ଜୀଉରାଡ଼େଃ ଏମଃନିଃକେ ନେଲ୍‌ହରା ତାଇକେନାଏ, ଆଡଃ ଇନିଃରେ ପାବିତାର୍‌ ଆତ୍ମା ତାଇନଃତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ଆଡଃ ଆମ୍‌ ପ୍ରାଭୁଆଃ ଖ୍ରୀଷ୍ଟ୍‌କେ ଆଉରି ନେଲିଯାକେଦ୍ ଆମାଃ ଗନଏଃ କା ହବାଅଆଃ ମେନ୍ତେ ପାବିତାର୍‌ ଆତ୍ମା ଇନିଃକେ ଉଦୁବାକାଇ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ଆଡଃ ଶିମିୟନ୍ ପାବିତାର୍‌ ଆତ୍ମାତେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃତେ ହିଜୁଃୟାନାଏ । ଆଡଃ ଆନ୍‌ଚୁରେୟାଃ କାଜିଲେକାତେ କାମିନାଙ୍ଗ୍‌ ୟୀଶୁଆଃ ଏଙ୍ଗା ଆପୁକିନ୍‌ ଇନିଃକେ ସାବ୍‌କେଦ୍‌ତେ ମାନ୍ଦିର୍‌ତେକିନ୍ ବଲୟାନା, ");
INSERT INTO unx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ଇମ୍‌ତାଙ୍ଗ୍‌ ଶିମିୟନ୍‌, ହନ୍‌କେ ଖାକିୟାଅକିୟାଏ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌ତାନ୍‌ଲଃ କାଜିକେଦାଏ : ");
INSERT INTO unx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ହେ ଗମ୍‌କେ, ନାହାଁଃଦ ଆମ୍‌ ଆମାଃ କାଜିଲେକା, ଦାସିତାମାଃକେ ସୁକୁତେମ୍ ବିଦାଇତାନା । ");
INSERT INTO unx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ଆଇଁୟାଃ ମେଦ୍‌ତେ ଆମାଃ ପାରିତ୍ରାଣ୍‌କେ ନେଲାକାଦାଇଙ୍ଗ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ଅକଆଃଚି ସବେନ୍‌ ହଡ଼କଆଃ ଆୟାର୍‌ରେ ସେକାଡ଼ାକାଦାମ୍‌ : ");
INSERT INTO unx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ଆଡଃ ଏଟାଃ ଜାତିରେନ୍‌କଆଃ ନାଙ୍ଗ୍‌ ମାସ୍କାଲ୍‌ରାଃ ଦିମି ଆଡଃ ଆମାଃ ଇସ୍ରାଏଲ୍‌ ହଡ଼କଆଃ ନାଗେନ୍ତେ ମାଇନାନ୍‌ ଆଉୱେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ସିଟିଆ ହନ୍‌ଆଃ ଏଙ୍ଗାଆପୁକିନ୍‌ ଆୟାଃ ବିଷାଏରେ କାଜିୟଃତେୟାଃ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ଶିମିୟନ୍‌ ଇନ୍‌କୁକେ ଆଶିଷ୍‌ କେଦ୍‌କଆଏ, ଆଡଃ ଇନିୟାଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌କେ କାଜିକିୟାଏ, “ନେଲେମେ, ନେ ହନ୍‌ ପୁରାଃ ଇସ୍ରାଏଲ୍‌କଆଃ ଉୟୁଗଃ ଆଡଃ ବିରିଦଃ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମିଆଁଦ୍‌ ସାଲାକାନ୍‌ ଚିହ୍ନାଁ ହବାଅଃଆଏ, ମେନ୍‌ଦ ପୁରାଃ ହଡ଼କ ଇନିୟାଃ ବିରୁଧ୍‌ରେ ବାଖାଁଣେୟାକ । ");
INSERT INTO unx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ଆଡଃ ଏନାତେ ପୁରାଃ ମନ୍‌ରେୟାଃ ଉଡ଼ୁଃ ଉଦୁବଃଆ । ଆଡଃ ଏନ୍‌ ବିଷାଏନାଙ୍ଗ୍‌ ଆପେୟାଃ ମନ୍‌ସୁରୁଦ୍‌ରେ ତାରାଉଡ଼ି ଗୁତୁ ପାରମଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ଆସେର୍‌ କିଲିରେନ୍ ପିନୁଏଲ୍‌ଆଃ ହନ୍ତେକୁଡ଼ି ହାନ୍ନା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ କୁଡ଼ିନାବୀ ତାଇକେନାଏ । ଇନିଃ ଡିଣ୍ଡାଏତେ ସାତ୍ ବାରାଷ୍ ଆୟାଃ କଡ଼ାତେଲଃ ତାଇକେନ୍‌ତେ ବୁଡି ଲୁକୁଦ୍‌ ଲୁକୁଦା କାନାଏ ତାଇକେନା । ଆଡଃ ଇନିଃ ଚାର୍‌ହିସି ଚାର୍‌ବାରାଷ୍‌ ରେନ୍‌ ରାଣ୍ଡିକୁଡ଼ି ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ଆଡଃ ଇନିଃ ଚିଉଲାହ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃଏତେ କାଏ ଅଡଙ୍ଗ୍‌ଅଃତାନ୍‌ ତାଇକେନା, ମେନ୍‌ଦ କାଟାବ୍‌ତାନ୍‌ଲଃ ଆଡଃ ବିନ୍ତିତାନ୍‌ଲଃ ନିଦାସିଙ୍ଗି ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାଇନାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ଇନିଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ସିଟିଆ ହନ୍‌ ଆଡଃ ଆୟାଃ ଏଙ୍ଗାଆପୁକିନ୍‌ତାଃ ନାଡ଼େଃୟାନ୍‌ଲଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍‌କିୟାଏ ଆଡଃ ଅକନ୍‌କ ଯୀରୁଶାଲେମ୍‌ରାଃ ମୁକ୍ତି ନେଲ୍‌ହରାତାନ୍ ସବେନ୍‌କକେ ଇନିଃ ୟୀଶୁଆଃ ବିଷାଏରେ କାଜିୟାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ଯୋଷେଫ୍‌ ଆଡଃ ମାରିୟାମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆନ୍‌ଚୁଲେକା ସବେନାଃ ଚାବାକେଦ୍‌ଚି ଗାଲିଲ୍‌ ଦିଶୁମ୍‌ରେୟାଃ ଆକିନାଃ ନାଗାର୍‌ ନାଜ୍‌ରେତ୍‌ତେକିନ୍ ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ଆଡଃ ସିଟିଆ ହନ୍‌ ମାଡ଼ି ମାଡ଼ିତେ ହାରା ଇଦିୟାନ୍‌ଲଃ ପେଡ଼େଃ ଆଡଃ ସେଣାଁଁତେ ପେରେଃଇଦିୟାନାଏ, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାୟାଦ୍ ଇନିଃଲଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ୟୀଶୁଆଃ ଏଙ୍ଗାଆପୁକିନ୍ ସବେନ୍‌ ବାରାଷ୍ ପାସ୍‌କା ପାରାବ୍‌ରେ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃ ତାନ୍‌କିନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ୟୀଶୁକେ ବାରା ବାରାଷ୍ ହବାଅଃତାନ୍ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଇନ୍‌କୁ ରିତିଲେକା ପାରାବ୍‌ ମାନାତିଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌କ ସେନ୍‌କେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ଆଡଃ ପାରାବ୍‌ ମାନାତିଙ୍ଗ୍‌ ଚାବାକେଦ୍‌ଚି, ଅଡ଼ାଃତେ ସେନ୍ ରୁହାଡ଼୍‌ତାନ୍ ଇମ୍‌ତା ହନ୍‌ ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ରେ ତାଇନ୍‌ୟାନାଏ, ଏନା ଆୟାଃ ଏଙ୍ଗାଆପୁକିନ୍ କାକିନ୍ ସାରିତାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ମେନ୍‌ଦ ଇନିଃ ଗାତିକଲଃ ମେନାଇୟାଃ ମେନ୍ତେକିନ୍ ପାହାମ୍‌କେଦ୍‌ତେ, ସିଙ୍ଗିସାଟୁବ୍‌ରେୟାଃ ହରା ସେନଃୟାନାକିନ୍‌, ଏନ୍ତେ ଆକିନାଃ କୁପୁଲ୍‌କ ଆଡଃ ଗାତିକଆଃ ଥାଲାରେକିନ୍ ଦାଣାଁଁଏଟେଦ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ଇନିଃକେ କାକିନ୍ ନାମ୍‌କିଃତେ ଦାଣାଁଁତାନ୍‌ଲଃ ଯୀରୁଶାଲେମ୍‌ତେକିନ୍ ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ଆପି ମାଃ ତାୟମ୍‌ତେ ଇନ୍‌କିନ୍‌ ୟୀଶୁକେ ମାନ୍ଦିର୍‌ଅଡ଼ାଃରେକିନ୍ ନାମ୍‌କିୟାଃ, ଧାରାମ୍‌ଗୁରୁକ ଥାଲାରେ ଦୁବ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଆଃ କାଜି ଆୟୁମ୍‌ତାଇକେନାଏ ଆଡଃ ଇନ୍‌କୁକେ କୁଲିକତାନ୍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ଇନିୟାଃ ବାଖାଁଣ୍‌ ଆୟୁମ୍‌ତାନ୍ ସବେନ୍‌ ହଡ଼କ ଇନିୟାଃ ସେଣାଁଁ ଆଡଃ କାଜିରୁହାଡ଼୍‌ରେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ଇନିୟାଃ ଏଙ୍ଗାଆପୁ ଇନିଃକେ ନେଲ୍‌କିଃତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକିନ୍‌, ଆଡଃ ଏଙ୍ଗାତେ ଇନିଃକେ କୁଲିକିୟାଏ, “ଏ ହନ୍‌, ଆମ୍‌ ଚିକାନାଙ୍ଗ୍‌ତେ ନେକାକେଦ୍‌ଲିୟାଁମ୍‌ ? ନେଲେମେ, ଆପୁମ୍ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଦୁକୁତାନ୍‌ଲଃ ଦାଣାଁଁବାଡ଼ାମେଁ ତାନାଲିଙ୍ଗ୍‌ ତାଇକେନା ।” ");
INSERT INTO unx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ କାଜିକେଦ୍‌କିନାଏ, “ଚିନାଃମେନ୍ତେବେନ୍ ଦାଣାଁଁବାଡ଼ାଇଙ୍ଗ୍‌ ତାଇକେନା ? ଚିୟାଃ ଆଇଙ୍ଗ୍‌କେ ଆପୁଇଁୟାଃ ଅଡ଼ାଃରେ ତାଇନଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଏନାଚି କାବେନ୍ ସାରିତାନ୍ ତାଇକେନା ?” ");
INSERT INTO unx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ମେନ୍‌ଦ ଇନିଃ ଇନ୍‌କିନ୍‌କେ କାଜିୟାଦ୍‌କିନ୍ କାଜିକେ ଇନ୍‌କିନ୍‌ କାକିନ୍ ଆଟ୍‌କାର୍‌ଉରୁମ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କିନ୍‌ଲଃ ନାଜ୍‌ରେତ୍‌ତେ ସେନଃୟାନାଏ, ଆଡଃ ଇନ୍‌କିନାଃ କାଜିକ ମାନାତିଙ୍ଗ୍‌ତାନ୍‌ଲଃ ତାଇୟାନାଏ । ମେନ୍‌ଦ ଇନିୟାଃ ଏଙ୍ଗାତେ ଏନ୍‌ ସବେନ୍‌ କାଜି ଆୟାଃ ମନ୍‌ରେୟାଏ ଦହକେଦା । ");
INSERT INTO unx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ଆଡଃ ୟୀଶୁ ସେଣାଁଁତେ, ହଡ଼୍‌ମତେ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଡଃ ହଡ଼କଆଃ ସାୟାଦ୍‌ରେ ହାରା ଇଦିୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ତିବିରିୟା କାଇସାର୍‌ଆଃ ରାଇଜ୍‌ତାନ୍‌ ପାନ୍ଦ୍‌ରା ବାରାଷ୍ ତାଇକେନ୍‌ ଇମ୍‌ତା ପନ୍ତିୟସ୍‌ ପିଲାତୁସ୍‌ ଯିହୁଦାରେନ୍ ଲାଟ୍‌ସାହେବ୍ ତାଇକେନାଏ, ଆଡଃ ହେରୋଦ୍‌ ଗାଲିଲ୍‌ରେନ୍‌ ମିଦ୍‌ହାନାଟିଙ୍ଗ୍‌ ରାଜା, ହାଗାତେ ଫିଲିପ୍‌ ଈତୁରିୟା ଆଡଃ ତ୍ରାଖୋନିତିଆରେନ୍‌ ମିଦ୍‌ହାନାଟିଙ୍ଗ୍‌ ରାଜା, ଆଡଃ ଲୁସାନିଆଁ ଅବିଲିନିରେନ୍‌ ମିଦ୍‌ହାନାଟିଙ୍ଗ୍‌ ରାଜା ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ହାନାନ୍‌ ଆଡଃ କାୟଫା ନୁତୁମ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ତାଇକେନ୍‌ପାରିୟାରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି ଜାଖ୍‌ରିୟାରାଃ ହନ୍‌ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ତାଃତେ ବିର୍‌ରେ ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ଏନାତେ ଇନିଃ ଯାର୍ଦାନ୍‌ ଗାଡ଼ା ଯାପାଃରେୟାଃ ସବେନ୍‌ସାଃତେ ସେନ୍‌କେଦ୍‌ତେ “ପାପ୍‌ ଛାମା ନାମେନାଗେନ୍ତେ ମନ୍‌ରୁହାଡ଼୍‌ରେୟାଃ ବାପ୍ତିସ୍ମା” ଉଦୁବ୍‌ବାଡ଼ା ତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ଜେ'ଲେକା ନେଆଁଦ ଯିଶାୟ ନାବୀୟାଃ କାଜିରେୟାଃ ପୁଥିରେ ଅଲାକାନା, “ଜେତାଏ ବିର୍‌ରେ କାଉରିତାନ୍‌ନିୟାଃଁ ସାଡ଼ି ଆୟୁମଃତାନା, ପ୍ରାଭୁଆଃ ହରା ବାଇୟେପେ, ଇନିୟାଃ ହରା ସିଧାଏପେ ");
INSERT INTO unx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ସବେନ୍‌ ଗାଡ଼ା ପେରେଜଃଆଃ, ସବେନ୍‌ ବୁରୁ ଆଡଃ ଗୁଟୁ ଲାତାରଆଃ । ବେଙ୍କଆକାନ୍ ହରାକ ସିଧାଅଃଆ ଆଡଃ ଗାଡା ଡିପା ହରାକ ସବେନ୍‌ ସାମ୍‌ବାଇୟଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ଆଡଃ ସବେନ୍‌ ହଡ଼କ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପାରିତ୍ରାଣ୍‌କ ନେଲେୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ଯୋହାନ୍‌ତାଃତେ ବାପ୍ତିସ୍ମା ଇଦିନାଗେନ୍ତେ ହିଜୁଆକାନ୍‌ ପୁରାଃ ଫାରୁଶୀ ଆଡଃ ସାଦୁକି ହଡ଼କକେ କାଜିୟାଦ୍‌କଆଏ, “ଏ ବିଙ୍ଗ୍‌କଆଃ ହନ୍‌କ !” ହିଜୁଃତାନ୍‌ ମାରାଙ୍ଗ୍‌ ଏନେସେଦ୍‌ଏତେ ନିର୍‌ ନାଗେନ୍ତେ “ଅକଏ ଆପେକେ ଚେତାୱାଦ୍‌ପେୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ଆପେ ସାର୍‌ତିଗି ପାପ୍‌ଏତେ ହେୟାତିଙ୍ଗ୍‌କାଦ୍‌ରେଦ ଆପେୟାଃ ବୁଗିନ୍‌ କାମିତେ ଉଦୁବେନ୍‌ପେ । ଆଡଃ ଆବ୍ରାହାମ୍‌ ଆଲେୟାଃ ଆପୁ ତାନିଃ ମେନ୍ତେ ଆପେ ଡିଡିକେଦ୍‌ତେ କାଜିତାନ୍‌ଲଃ ନେ ସାଜାଇଏତେ ବାଞ୍ଚାୱାଃଲେ ମେନ୍ତେ ଆଲ୍‌ପେ ଉଡ଼ୁଃୟା । ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଦ ନେ ଦିରିକଏତେ ଆବ୍ରାହାମ୍‌ ନାଗେନ୍ତେ ହନ୍‌କଏ ବାଇଦାଡ଼ିୟା ! ");
INSERT INTO unx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ଆଡଃ ନାହାଁଃ ଦାରୁରେୟାଃ ବୁଟାରେ ହାକେ ମାଣ୍ଡାୱା କାନା; ଅକନ୍‌ ଦାରୁ ବୁଗିନ୍‌ ଜ କା ଜଅଃ'ଆ ଏନାକେ ମାଗଃଆ ଆଡଃ ସେଙ୍ଗେଲ୍‌ରେ ହୁରାଙ୍ଗ୍‌ଅଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ଏନ୍ତେ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେ କୁଲିକିୟାଃକ, “ତାବ୍‌ଦ ଆଲେ ଚିନାଃଲେ ଚିକାୟା ?” ");
INSERT INTO unx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ଯୋହାନ୍‌ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଅକଏତାଃରେ ବାରିଆ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃ ମେନାଃ, ଇନିଃ ଅକଏତାଃରେ ବାନଆଃ ଇନିଃକେ ମିଦ୍‌ ହାଟିଙ୍ଗ୍‌ ଏମାଇକାଏ, ଆଡଃ ଅକଏତାଃରେ ଜମେୟାଁ ମେନାଃ, ଇନିଃହ ଏନ୍‌କାଗି ହାଟିଙ୍ଗ୍‌ୟେଁକାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ଆଡଃ ମାଲ୍‌ହାରମ୍‌କହ ବାପ୍ତିସ୍ମା ଇଦିନାଙ୍ଗ୍‌କ ହିଜୁଃୟାନା ଆଡଃ ଯୋହାନ୍‌କେକ କୁଲିକିୟାଃ, “ହେ ଗୁରୁ ଆଲେ ଚିନାଃଲେ ଚିକାଏୟା ?” ");
INSERT INTO unx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଆପେକେ ଚିମିୟାଙ୍ଗ୍‌ ଇଦିନାଙ୍ଗ୍‌ କାଜିୟାକାନା, ଏନାଏତେ ଆଦ୍‌କା ଆଲ୍‌ପେ ହାରୋମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ଆଡଃ ପାଲ୍‌ଟାନ୍‌କ ଯୋହାନ୍‌କେକ କୁଲିକିୟାଃ, “ଆଲେ ଚିନାଃଲେ ଚିକାୟା ?” ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ପେଡ଼େଃତେ ଚାଏ ବେଦାତେ ଆଡଃ ହାଉକାଅକେଦ୍‌ତେ ଜେତାଏୟାଃ ଖୁର୍ଜି ଆଲ୍‌ପେ ଇଦିୟା ଆଡଃ ଆପେୟାଃ ନାଲାରେ ସୁକୁଆକାନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ସବେନ୍‌ ହଡ଼କ ବାଞ୍ଚାଅନିଃକେ ନେଲ୍‌ହରାତାନ୍‌କ ତାଇକେନ୍‌ ହରାତେ, ଯୋହାନ୍‌କେ ଖ୍ରୀଷ୍ଟ୍‌ ତାନିଃ ମେନ୍ତେ ଆକଆଃ ମନ୍‌ରେ ପାହାମ୍ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ଏନାମେନ୍ତେ ଯୋହାନ୍‌ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ଦ ଦାଆଃତେ ବାପ୍ତିସ୍ମାପେ ତାନାଇଙ୍ଗ୍‌ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ଏତେ ପେଡ଼େୟାନ୍‌ନିଃ ହିଜୁଃତାନାଏ, ଇନିୟାଃ ଖାର୍‌ପାରେୟାଃ ତନଲ୍‌ ରାଡ଼ାଏ ଲେକାନିଃହ ଆଇଙ୍ଗ୍‌ ନାହାଁଲିଙ୍ଗ୍‌ । ଇନିଃ ଆପେକେ ପାବିତାର୍‌ ଆତ୍ମା ଆଡଃ ସେଙ୍ଗେଲ୍‌ତେ ବାପ୍ତିସ୍ମାପେୟା । ");
INSERT INTO unx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ଆୟାଃ ତିଃଇରେ ହାଟାଆଃ ମେନାଃ, ଏନାତେ କଲମ୍‌ରେୟାଃ ଗହମ୍‌ ଆଡଃ ବାବା ଗୁମ୍ ସାଫାକେଦ୍‌ତେ ଆୟାଃ ଭାଣ୍ଡାର୍‌ ଅଡ଼ାଃରେ ମାଣ୍ଡାଅୟା ଆଡଃ ପେଟେଃକେ କା ଇଣିଁଜଃ ସେଙ୍ଗେଲ୍‌ରେ ଅଣ୍ଡର୍‌ଏଣ୍ଡାଗେୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ନେ ଲେକା ଆଡଃଗି ପୁରାଃ ଏଟାଃ ଇନିତୁ କାଜିକତେ ଯୋହାନ୍‌ ହଡ଼କକେ ସୁକୁକାଜି ଉଦୁବାକତାନ୍ ତାଇକେନା । ଆଡଃ ମନ୍‌ରୁହାଡ଼୍‌ ନାଗେନ୍ତେ ଇନ୍‌କୁକେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ମେନ୍‌ଦ ମିଦ୍‌ ହାନାଟିଙ୍ଗ୍‌ରେନ୍ ରାଜା ହେରୋଦ୍‌ ଆୟାଃ ହାଗାତେୟାଃ କୁଡ଼ି ହେରୋଦିୟାଲଃ ଆଣ୍‌ଦିୟାନ୍‌ ନାଗେନ୍ତେ ଆଡଃ ହେରୋଦ୍‌ କାମିକେଦ୍‌ ସବେନ୍‌ ଏତ୍‌କାନାଃ ନାଗେନ୍ତେ ଯୋହାନ୍‌ ହେରୋଦ୍‌କେ ମାରାଙ୍ଗ୍‌ ମଚାକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ଏନା ନାଗେନ୍ତେ ହେରୋଦ୍‌ ଯୋହାନ୍‌କେ ଜେହେଲ୍‌କିୟାଏ ଆଡଃ ନେ ଲେକାତେ ଇନିଃ ଆୟାଃ ଏତ୍‌କାନାଃକେ ଆଦ୍‌କାକେଦା । ");
INSERT INTO unx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ସବେନ୍‌ ହଡ଼କ ବାପ୍ତିସ୍ମାୟାନ୍ତେ ୟୀଶୁ ହଗି ବାପ୍ତିସ୍ମାୟାନାଏ । ଆଡଃ ଇନିଃ ବିନ୍ତିତାନ୍ ଇମ୍‌ତାଙ୍ଗ୍‌ ସିର୍ମା ନିଜ୍‌ୟାନା, ");
INSERT INTO unx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମା ଦୁଦୁମୁଲ୍‌ଲେକା ନେଲଃ ହଡ଼୍‌ମ, ୟୀଶୁଆଃ ଚେତାନ୍‌ରେ ଆଡ଼୍‌ଗୁୟାନା ଆଡଃ “ଆମ୍‌ ଆଇଁୟାଃ ଦୁଲାଡ଼୍‌ ହନ୍‌, ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ପୁରାଃ ସୁକୁଆମ୍‌ତାନାଇଙ୍ଗ୍‌” ମେନ୍ତେ ସିର୍ମାଏତେ ଆୟୁମ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ୟୀଶୁ ଆୟାଃ ସେୱାଏଟେଦ୍‌କେଦ୍ ଇମ୍‌ତାଙ୍ଗ୍‌ ତିରିଶ୍ ବାରାଷ୍‌ରେନ୍ ଲେକାଏ ତାଇକେନା ଆଡଃ ଇନିଃ ହଡ଼କଆଃ ସାରିଲେକାତେ ଯୋଷେଫ୍‌ଆଃ ହନ୍‌, ଆଡଃ ଯୋଷେଫ୍‌ ଏଲିଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲି ମାତ୍‌ଥାତ୍‌ତାଃ ହନ୍‌, ମାତ୍‌ଥାତ୍‌ ଲେବୀଆଃ ହନ୍‌, ଲେବୀ ମଲ୍‌ଖିଆଃ ହନ୍‌, ମଲ୍‌ଖି ଯାନ୍ନୟଆଃ ହନ୍‌, ଯନ୍ନୟ ଯୋଷେଫ୍‌ଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଯୋଷେଫ୍‌ ମାତ୍ତିଥ୍ୟାରାଃ ହନ୍‌, ମାତ୍ତିଥ୍ୟା ଆମୋସ୍‌ଆଃ ହନ୍‌, ଆମୋସ୍‌ ନାହୁମ୍‌ଆଃ ହନ୍‌, ନାହୁମ୍ ଏସ୍‌ଲିଆଃ ହନ୍‌, ଏସ୍‌ଲି ନଗୟଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଗୟ ମହଥଆଃ ହନ୍‌, ମହଥ ମତ୍ତିଥ୍ୟାରାଃ ହନ୍‌, ମତ୍ତିଥ୍ୟା ଶିମୟୀଆଃ ହନ୍‌, ଶିମୟୀ ଯୋସେଖାୟାଃ ହନ୍‌, ଯୋସେଖା ଯୋଦାୟାଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଯୋଦା ଯୋହାନ୍‌ଆଃ ହନ୍‌, ଯୋହାନ୍‌ ରେଷାଆଃ ହନ୍‌, ରେଷା ଜିରୁବାବେଲ୍‌ଆଃ ହନ୍‌, ଜିରୁବାବେଲ୍ ଶଲ୍‌ଟିୟେଲ୍‌ଆଃ ହନ୍‌, ଶଲ୍‌ଥୀୟେଲ୍ ନେରୀଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରୀ ମଲ୍‌ଖିଆଃ ହନ୍‌, ମଲ୍‌ଖି ଅଦ୍ଦୀଆଃ ହନ୍‌, ଅଦ୍ଦୀ କୋସାମ୍‌ଆଃ ହନ୍‌, କୋସାମ୍ ଏଲ୍‌ମାଦାନ୍‌ଆଃ ହନ୍‌, ଏଲ୍‌ମାଦାନ୍ ଏର୍‌ଆଃ ହନ୍‌, ଏର୍‌ ଯିହୋଶିୟରାଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଯିହୋଶିୟ ଏଲିୟାଜାର୍‌ଆଃ ହନ୍‌, ଏଲିୟାଜାର୍ ଯୋରିମ୍‌ଆଃ ହନ୍‌, ଯୋରିମ୍ ମାତ୍‌ଥାତ୍‌ତାଃ ହନ୍‌, ମାତ୍‌ଥାତ୍‌ ଲେବୀୟାଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେବୀ ଶିମୋନ୍‌ଆଃ ହନ୍‌, ଶିମୋନ୍‌ ଯିହୁଦାଃ ହନ୍‌, ଯିହୁଦା ଯୋଷେଫ୍‌ଆଃ ହନ୍‌, ଯୋଷେଫ୍‌ ଯୋନାମ୍‌ଆଃ ହନ୍‌, ଯୋନାମ୍ ଏଲିୟାକିମ୍‌ଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲିୟାକିମ୍ ମଲାହଆଃ ହନ୍‌, ମଲାହ ମନ୍ନାୟାଃ ହନ୍‌, ମନ୍ନା ମତ୍ତଥାୟାଃ ହନ୍‌, ମତ୍ତଥା ନାଥାନ୍‌ଆଃ ହନ୍‌, ନାଥାନ୍ ଦାଉଦ୍‌ଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଉଦ୍‌ ଯିଶିଆଃ ହନ୍‌, ଯିଶି ଓବେଦ୍‌ଆଃ ହନ୍‌, ଓବେଦ୍ ବୋୟାଜ୍‌ଆଃ ହନ୍‌, ବୋୟାଜ୍‌ ଶାଲ୍‌ମନ୍‌ଆଃ ହନ୍‌, ଶାଲ୍‌ମନ୍‌ ନହଶୋନ୍‌ଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନହଶୋନ୍‌ ଅମ୍ମୀନାଦବ୍ଆଃ ହନ୍‌, ଅମ୍ମୀନାଦବ୍‌ ଅଦ୍ମିନ୍‌ଆଃ ହନ୍‌, ଅଦ୍ମିନ୍‌ ଅର୍ଣ୍ଣୀଆଃ ହନ୍‌, ଅର୍ଣ୍ଣୀ ହେସ୍ରୋନ୍‌ଆଃ ହନ୍‌, ହେସ୍ରୋନ୍‌ ପେରସ୍‌ଆଃ ହନ୍‌, ପେରସ୍‌ ଯିହୁଦାଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଯିହୁଦା ଯାକୁବ୍‌ଆଃ ହନ୍‌, ଯାକୁବ୍‌ ଇସାକ୍‌ଆଃ ହନ୍‌, ଇସାକ୍‌ ଆବ୍ରାହାମ୍‌ଆଃ ହନ୍‌, ଆବ୍ରାହାମ୍‌ ଥେରହଆଃ ହନ୍‌, ଥେରହ ନାହୋର୍‌ଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାହୋର୍ ସରୁଗଆଃ ହନ୍‌, ସରୁଗ ରଗୁଆଃ ହନ୍‌, ରଗୁ ଫେଲଗ୍‌ଆଃ ହନ୍‌, ଫେଲଗ୍‌ ଏବର୍‌ଆଃ ହନ୍‌, ଏବର୍ ଶେଲହଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ଶେଲହ କେନାନ୍‌ଆଃ ହନ୍‌, କେନାନ୍ ଅର୍ଫକ୍ଷାଦ୍‌ଆଃ ହନ୍‌, ଅର୍ଫକ୍ଷାଦ୍‌ ଶେମ୍‌ଆଃ ହନ୍‌, ଶେମ୍‌ ନୁହୁଁଆଃ ହନ୍‌, ନୁହୁଁ ଲାମାକ୍‌ଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲାମାକ୍‌ ମଥୁଶେଲହଆଃ ହନ୍‌, ମଥୁଶେଲହ ହନୋକ୍‌ଆଃ ହନ୍‌, ହନୋକ୍‌ ଯେରଦ୍‌ଆଃ ହନ୍‌, ଯେରଦ୍ ମହଲ୍‌ଲେଲ୍‌ଆଃ ହନ୍‌, ମହଲ୍‌ଲେଲ୍‌ କେନନ୍‌ଆଃ ହନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କେନନ୍ ଏନୋଶ୍‌ଆଃ ହନ୍‌, ଏନୋଶ୍ ଶେଥ୍‌ଆଃ ହନ୍‌, ଶେଥ୍ ଆଦାମ୍‌ଆଃ ହନ୍‌, ଆଦାମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ୟୀଶୁ ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଃୟାନ୍‌ଲଃ ଯାର୍ଦାନ୍‌ ଗାଡ଼ାଏତେ ରୁହାଡ଼୍‌ୟାନାଏ ଆଡଃ ଆତ୍ମା ଇନିଃକେ ବିର୍‌ତେ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ଏନ୍ତାଃରେ ବାର୍‌ହିସି ନିଦାସିଙ୍ଗି ଜାକେଦ୍‌ ସାଏତାନ୍‌ ଇନିଃକେ ବିଡ଼ାଅକିୟା । ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌କରେ ଇନିଃ ଜେତ୍‌ନାଃ କାଏ ଜମ୍‌କେନା, ଆଡଃ ଏନ୍‌ ନେଡା ଟୁଣ୍ଡୁୟାନ୍‌ରେ ରେଙ୍ଗେଜ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ସାଏତାନ୍‌ ୟୀଶୁକେ କାଜିକିୟାଏ, “ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେରେଦ ନେ ଦିରିକକେ ହଲଙ୍ଗ୍‌ ବାଇୟଃକା ମେନ୍ତେ ଆଚୁତାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ନେଆଁଁ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ହଡ଼ ହଲଙ୍ଗ୍‌ତେ ଏସ୍‌କାର୍‌ କାଏ ଜୀହିଦଃଆ ।’” ");
INSERT INTO unx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ସାଏତାନ୍‌ ଇନିଃକେ ମିଆଁଦ୍‌ ସାଲାଙ୍ଗି ଠାୟାଦ୍‌ତେ ଇଦିକିୟାଏ ଆଡଃ ଘାଡ଼ିକାଦ୍‌ରେଗି ଅତେଦିଶୁମ୍‌ରେୟାଃ ସବେନ୍‌ ରାଇଜ୍‌ ଉଦୁବ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ଆଡଃ ସାଏତାନ୍‌ ୟୀଶୁକେ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ନେ ସବେନାଃରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ଆଡଃ ସୁଗାଡ଼ାନ୍‌ତେୟାଃ ଆମ୍‌କେ ଏମାମେୟାଁଇଙ୍ଗ୍‌ ଚିୟାଃଚି ନେୟାଁ ସବେନ୍‌ ଆଇଁୟାଃ ତିଃଇରେ ଏମାକାନା, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ସାନାଙ୍ଗ୍‌ ଲେକା ନେ ସବେନାଃଇଙ୍ଗ୍‌ ଏମ୍ ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ଜହାରିଙ୍ଗ୍‌ରେଦମ୍ ନେୟାଁ ସବେନ୍‌ ଆମାଃଗି ହବାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆତମେନ୍‌ମେ ସାଏତାନ୍‌, ଚିୟାଃଚି ନେଆଁଁ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ପ୍ରାଭୁ ଆମାଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଜହାରିମେ ଆଡଃ ଇନିଃକେ ଏସ୍‌କାର୍‌ ସୁସାରିମେ ।’” ");
INSERT INTO unx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ଏନ୍ତେ ସାଏତାନ୍ ଯୀରୁଶାଲେମ୍‌ତେ ଇଦିକିଃତେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେୟାଃ ଚୁଟିରେ ତିଙ୍ଗୁକିୟା, ଆଡଃ କାଜିକିୟାଏ, “ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେରେଦ ନେତାଃଏତେ ଲାତାର୍‌ତେ ଡେଗାଅତାମେ । ");
INSERT INTO unx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ଚିୟାଃଚି ଧାରାମ୍‌ପୁଥିରେ ନେୟାଁ ଅଲାକାନା, ‘ଆମ୍‌କେ ତେଲାମେ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ଦୁଁତ୍‌କକେ ଆଚୁକଆ ।’ ");
INSERT INTO unx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ଆଡଃଗି ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ଆମାଃ କାଟା ଦିରିରେ ଆଲକା ଠଗଃକା ମେନ୍ତେ ଇନ୍‌କୁ ଆକଆଃ ତିଃଇତେକ ତେଲାମେୟାଁ ।’” ");
INSERT INTO unx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ମେନ୍‌ଦ ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଧାରାମ୍‌ପୁଥିରେ ନେଆଁଁହଗି ଅଲାକାନା, ‘ପ୍ରାଭୁ ଆମାଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଆଲମ୍‌ ବିଡ଼ାଅଇୟା ।’” ");
INSERT INTO unx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ସାଏତାନ୍‌ ସବେନ୍‌ ବିନିଡ଼ାଅ ଚାବାକେଦାଏ ଆଡଃ ଘାତାଅ କା ନାମ୍‌ ଜାକେଦ୍‌ ୟୀଶୁକେ ବାଗିକେଦ୍‌ତେ ନିର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ଏନ୍ତେ ୟୀଶୁ ପାବିତାର୍‌ ଆତ୍ମାତେ ପେଡ଼େଃ ନାମ୍‌ତାନ୍‌ଲଃ ଗାଲିଲ୍‌ ସାହାର୍‌ତେ ରୁହାଡ଼୍‌ୟାନାଏ, ଆଡଃ ଇନିୟାଃ ନୁତୁମ୍‌ ଗାଲିଲ୍‌ରେୟାଃ ହପର୍‌ଜାପାଃ ସବେନ୍‌ସାଃ ନିତିର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ଇନିଃ ଇନ୍‌କୁଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଇତୁକେଦ୍‌କଆଏ ଆଡଃ ସବେନ୍‌କ ଇନିଃକେ ମାରାଙ୍ଗ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ଏନ୍‌ ତାୟମ୍‌ତେ ଇନିଃ ନାଜ୍‌ରେତ୍‌ତେୟାଏ ହିଜୁଃୟାନା, ଏନ୍ତାଃରେ ଇନିଃ ଆସୁଲ୍ ହାରାକାନ୍‌ ତାଇନାଏ, ଆଡଃ ଆୟାଃ ରିତି ଲେକାତେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ବଲୟାନ୍ତେ, ଧାରାମ୍‌ପୁଥି ପାଢ଼ାଅ ନାଗେନ୍ତେ ବିରିଦ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ଆଡଃ ଇନ୍‌କୁ ଯିଶାୟ ନାବୀୟାଃ ପୁଥି ଇନିଃକେକ ଏମ୍‌କିୟାଃ, ଇନିଃ ଏନା ରାଡ଼ାକେଦ୍‌ତେ ନେଆଁଁ ଅଲାକାନ୍‌ତେୟାଃ ନାମ୍‌କେଦାଏ : ");
INSERT INTO unx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆତ୍ମା ଆଇଙ୍ଗ୍‌ରେ ମେନାଇୟାଃ, ଚିୟାଃଚି ନାରାଦୁରା ହଡ଼କତାଃରେ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଇନିଃ ଆଇଙ୍ଗ୍‌କେ ଆଭିଷେକ୍‌କାଦିୟାଁ । ତଲାକାନ୍‌କ ରାଡ଼ାଅଃରେୟାଃ କାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ, କାଣାଁକାନ୍‌କ ନେନେଲ୍‌ ଦାଡ଼ିରେୟାଃ କାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ, ଦୁକୁତେ ତେନାକାନ୍‌କଆଃ ଦୁକୁ ସାଙ୍ଗିନେ ନାଗେନ୍ତେ, ");
INSERT INTO unx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଲିବୁୟାନ୍ ବାରାଷ୍‌ରେୟାଃ କାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ଏନ୍ତେ ୟୀଶୁ ପୁଥିକୁଡ଼ାକେଦ୍‌ତେ ଦାସ୍‌କେ ଏମ୍‌ରୁହାଡ଼୍‌କିୟାଏ ଆଡଃ ଦୁବ୍‌ୟାନାଏ । ସାମାଜ୍‌ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌କ ଇନିଃକେ ଆରିଦାକାଇକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ପାଢ଼ାଅକେଦ୍ ଧାରାମ୍‌ପୁଥିରେୟାଃ ନେ କାଜି ତିସିଙ୍ଗ୍‌ ଆପେୟାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ପୁରାୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ଆଡଃ ସବେନ୍‌କ ୟୀଶୁଆଃ ବିଷାଏରେ ଗାୱା ଏମ୍‌ ଏଟେଦ୍‌କେଦାକ, ଆଡଃ ଇନିୟାଃ ମଚାଏତେ ଅଡଙ୍ଗ୍‌ଅଃତାନ୍‌ ସାୟାଦ୍‌ରାଃ କାଜିତେକ ଆକ୍‌ଦାନ୍ଦାଅୟାନା । ଆଡଃ ଇନ୍‌କୁ କାଜିକେଦାଃକ, “ଚିୟାଃ ନିଃ ଯୋଷେଫ୍‌ଆଃ ହନ୍‌ ନାହାଁଲିଃ ?” ");
INSERT INTO unx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ଇନିଃ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଆପେ ଆଇଙ୍ଗ୍‌କେ ସାର୍‌ତିଗି ଏନ୍‌ ମାରି ଜନ୍‌କାପେ କାଜିୟାଇଙ୍ଗ୍‌ୟାଁ, ‘ଏ ବାଇଦ୍ ଆମ୍‌ ଆମ୍‌ଗି ବୁଗିନଃମେଁ’ ଆଡଃଗିପେ କାଜିୟା, ‘ଆମ୍‌ କପର୍‌ନାହୁମ୍‌ ସାହାର୍‌ରେମ୍‌ କାମିକେଦ୍‌ ସବେନାଃଲେ ଆୟୁମାକାଦାଃ, ଏନା ନେ ଆମାଃ ଦିଶୁମ୍‌ରେୟ କାମିମେଁ ।’” ");
INSERT INTO unx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ‘ଜେତାଏ ନାବୀ ଆୟାଃ ନାଗାର୍‌ରେ କାଏ ମାନାତିଙ୍ଗ୍‌ଅଃଆ ।’ ");
INSERT INTO unx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ନାବୀ ଏଲିୟଆଃ ଦିପିଲିରେ ଆପି ବାରାଷ୍ ତୁରିୟା ମାହିଁନା ଜାକେଦ୍‌ ସିର୍ମାଏତେ ଦାଆଃ କାଏ ଗାମାକେଦାଃ, ଏନାତେ ଗଟା ଦିଶୁମ୍‌ରେ ରିଙ୍ଗାକାନ୍ ତାଇକେନ୍‌ରେ ଇସ୍ରାଏଲ୍‌ ଦିଶୁମ୍‌ରେ ପୁରାଃଗି ରାଣ୍ଡିକୁଡ଼ିକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ମେନ୍‌ଦ ସିଦୋନ୍‌ ଦିଶୁମ୍‌ରେୟାଃ ସାରିଫାତ୍‌ ହାତୁରେନ୍‌ ମିଆଁଦ୍‌ ରାଣ୍ଡିକୁଡ଼ିତାଃ ଏଲିୟ କୁଲ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ଆଡଃଗି ଏଲିଶାୟ ନାବୀୟାଃ ଦିପିଲିରେ ଇସ୍ରାଏଲ୍‌ରେ ପୁରାଃ ନାଗେଘାଅୱାକାନ୍‌କ ତାଇକେନା ମେନ୍‌ଦ ଇନ୍‌କୁଏତେ ସୁରିୟା ଦିଶୁମ୍‌ରେନ୍‌ ନାମାନ୍ ଏସ୍‌କାର୍‌ ଫାର୍‌ଚିୟାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ସାମାଜ୍‌ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌କ ଖିସ୍‌ତେକ ପେରେଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ଆଡଃ ଇନ୍‌କୁ ବିରିଦ୍‌ୟାନ୍ତେ ଇନିଃକେ ସାହାର୍‌ଏତେକ ଅଡଙ୍ଗ୍‌କିୟା ଆକଆଃ ସାହାର୍‌ ବୁରୁ ଚେତାନ୍‌ରେ ତାଇକେନା । ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ଇଲିଙ୍ଗ୍‌ ଉୟୁଗି ନାଗେନ୍ତେ ବୁରୁ ଚେତାନ୍‌ରେୟାଃ ଖାଇଣ୍‌ତେକ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ମେନ୍‌ଦ ଇନିଃ ଇନ୍‌କୁଆଃ ଥାଲା ଥାଲାଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ଲଃ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ୟୀଶୁ ଗାଲିଲ୍‌ରେୟାଃ କପର୍‌ନାହୁମ୍‌ ସାହାର୍‌ତେ ହିଜୁଃକେଦ୍‌ତେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଇନିଃ ହଡ଼କକେ ଇତୁ ଏଟେଦ୍‌କେଦ୍‌ଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ଇନିୟାଃ ଇନିତୁରେ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ, ଚିୟାଃଚି ଇନିଃ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ନିଃଲେକା ଇତୁକତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ସାମାଜ୍‌ ଅଡ଼ାଃରେ ମିଆଁଦ୍‌ ସତ୍‌ରା ଆତ୍ମାତେ ଏସେରାକାନ୍ ହଡ଼ ତାଇକେନାଏ । ଇନିଃ ପୁରାଃ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ହାଏରେ, ହେ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ ଆଲେଲଃ ଆମାଃ ଚିକାନ୍‌ କାମି ? ଆମ୍‌ ଚିନାଃ ଆଲେକେ ଜିୟନ୍‌ ନାଗେନ୍ତେମ୍ ହିଜୁଆକାନା ? ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପାବିତାର୍‌ନିଃ ତାନ୍‌ମେ, ଏନା ଆଇଙ୍ଗ୍‌ ସାରିତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ୟୀଶୁ ଇନିଃକେ ମାରାଙ୍ଗ୍‌ମଚାକେଦ୍‌ତେ କାଜିକିୟାଏ, “ହାପାଅଃମେଁ, ଆଡଃ ଇନିଃତାଃଏତେ ଅଡଙ୍ଗ୍‌ଅଃମେ ।” ଏନ୍ତେ ଏନ୍‌ ସତ୍‌ରା ଆତ୍ମା ଇନିଃକେ ସବେନ୍‌କଆଃ ଥାଲାରେ ଥାୱାକିଦ୍‌ଚି ଇନିୟାଃ ନକ୍‌ସାନ୍‌ କା ରିକାତାନ୍‌ଲଃ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନ୍‌ଲଃକ କୁପୁଲିୟାନା, “ନେଆଁଁ ଚିଲ୍‌କାନ୍ ଇନିତୁ ? ଇନିଃଦ ଆକ୍‌ତେୟାର୍‌ତେ ଆଡଃ ପେଡ଼େଃଲଃ ସତ୍‌ରା ଆତ୍ମାକକେ ଅଡଙ୍ଗ୍‌ଅଃ ନାଙ୍ଗ୍‌ ଆଚୁକତାନାଏ ଆଡଃ ଇନ୍‌କୁ ଇନିୟାଃ କାଜିକ ମାନାତିଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ଏନ୍ତେଦ ୟୀଶୁଆଃ କାଜି କଚାକୁନି ସବେନ୍‌ସାଃରେ ନିତିର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ୟୀଶୁ ସାମାଜ୍‌ ଅଡ଼ାଃଏତେ ଶିମୋନ୍‌ଆଃ ଅଡ଼ାଃତେ ସେନଃୟାନାଏ । ପାତ୍‌ରାସ୍‌ଆଃ ହାନାର୍‌ତେ ବରୱାନ୍‌ଗି ଉରିୟୁ ତାଇକେନା, ଆଡଃ ଇନିୟାଃ ବୁଗିୟଃ ନାଗେନ୍ତେ ୟୀଶୁକେ ବିନ୍ତିକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ଏନ୍ତେ ୟୀଶୁ ଇନିୟାଃ ହେପାଦ୍‌ରେ ତିଙ୍ଗୁୟାନ୍‌ଲଃ ଉରିୟୁକେ ମାରାଙ୍ଗ୍‌ମଚାକେଦାଏ ଆଡଃ ଇନିଃ ଉରିୟୁଏତେ ବୁଗିୟାନା । ଆଡଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଇନିଃ ବିରିଦ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁକେ ସୁସାର୍‌ ଏଟେଦ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ସିଙ୍ଗିହାସୁରଃ ତାନ୍‌ରେ ହଡ଼କତାଃରେ ତାଇକେନ୍‌ ଦୁକୁହାସୁତାନ୍‌ ସବେନ୍‌ ହଡ଼କକେ ୟୀଶୁତାଃତେକ ଆଉକେଦ୍‌କଆ, ଇନିଃ ମିପିଆଦ୍‌ ହଡ଼କଆଃରେ ତିଃଇ ଦହକେଦ୍‌ତେ ବୁଗିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ଆଡଃଗି, ପୁରାଃ ହଡ଼କତାଃଏତେ ବଙ୍ଗାକ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ଲଃକ କାଉରିକେଦାଃ, “ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେ ।” ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ ହାପାଅଃ ନାଗେନ୍ତେ ମାରାଙ୍ଗ୍‌ମଚା କେଦ୍‌କଆ, ଆଡଃ ଇନିଃ ବଙ୍ଗାକକେ କାଏ କାଜି ଇଚିକେଦ୍‌କଆ, ଚିୟାଃଚି ଏନ୍‌ ବଙ୍ଗାକ ଇନିଃ ଖ୍ରୀଷ୍ଟ୍‌ ତାନିଃ ମେନ୍ତେକ ସାରିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ଆଙ୍ଗ୍‌ୟାନ୍‌ଚି, ୟୀଶୁ ସାହାର୍‌ଏତେ ଅଡଙ୍ଗ୍‌ୟାନା ଆଡଃ ମିଆଁଦ୍‌ ସିଃସଏଃ ଠାୟାଦ୍‌ତେ ସେନଃୟାନାଏ । ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେ ଦାଣାଁଁ ନାମ୍‌କେଦ୍‌ତେ ଆୟାଃତାଃକ ହିଜୁଃୟାନା, ଆଡଃ ଇନିଃ ଆକତାଃଏତେ ଆଲକାଏ ସେନଃକା ମେନ୍ତେ କେସେଦିତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ମେନ୍‌ଦ ଇନିଃ କାଜିୟାଦ୍‌କଆଏ, “ଏଟାଃ ନାଗାର୍‌ରେୟ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେୟାଃ ସୁକୁକାଜି ଆଇଙ୍ଗ୍‌କେ ଉଦୁବ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଚିୟାଃଚି ଏନା ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ଆଡଃ ଇନିଃ ଯିହୁଦା ଦିଶୁମ୍‌ରେୟାଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଇତୁକତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ମୁସିଙ୍ଗ୍‌ ୟୀଶୁ ଗିନେସରେତ୍‌ ଦରେୟା ନାଡ଼େଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ତାଇକେନାଏ, ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଇନିଃକେ ଜୁରୁବିୟୁରାକାଇକ ତାଇକେନା, ");
INSERT INTO unx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ଇନିଃ ବାରିଆ ଲାଉକା ଦରେୟା ଗେନାରେ ଦହଆକାନାଏ ନେଲ୍‌କେଦାଃ, ହାକୁସାବ୍‌ ହଡ଼କ ଏନ୍‌ ଲାଉକାଏତେ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ ଜାଲୋମ୍‌କ ଚାପିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ୟୀଶୁ ଏନାଏତେ ମିଆଁଦ୍‌ ଲାଉକାରେ ରାକାବ୍‌ୟାନାଏ, ଏନାଦ ଶିମୋନ୍‌ଆଃ ତାଇକେନା ଆଡଃ ୟୀଶୁ ଇନିଃକେ ଦରେୟା ଗେନାଏତେ ହୁଡିଙ୍ଗ୍‌ ସାଙ୍ଗିନ୍‌ତେ ଇଦିମେ ମେନ୍ତେ ବିନ୍ତିକିୟାଏ । ଏନ୍ତେ ଇନିଃ ଲାଉକାରେ ଦୁବ୍‌ୟାନ୍‌ଚି ଗାଦେଲ୍‌ ହଡ଼କକେ ଇତୁକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ଇନିଃ କାଜିଚାବାକେଦ୍‌ଚି ଶିମୋନ୍‌କେ କାଜିକିୟାଏ, “ଲାଉକା ତାମାଃକେ ଇକିର୍‌ତେ ଇଦିମେ ଆଡଃ ହାକୁସାବ୍‌ ନାଗେନ୍ତେ ଜାଲୋମ୍‌ ତାମାଃ ହୁଦ୍‌ମାଏମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ମେନ୍‌ଦ ଶିମୋନ୍‌ କାଜିକିୟାଏ, “ହେ ଗୁରୁ, ଆଲେ ମିଦ୍‌ନିଦାଲେ କାମିକେଦା ଆଡଃ ମିଆଁଦ୍‌ହ ହାକୁ କାଲେ ସାବ୍‌କେଦ୍‌କଆ । ମେନ୍‌ଦ ଆମାଃ କାଜିତେ ଜାଲୋମ୍‌ ହୁଦ୍‌ମାୟାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ଇନ୍‌କୁ ଜାଲୋମ୍ ହୁଦ୍‌ମାକେଦ୍‌ଚି ପୁରାଃ ହାକୁକ ଜାଲୋମ୍‌କେଦ୍‌କଆ, ଆଡଃ ଇନ୍‌କୁଆଃ ଜାଲୋମ୍‌କ ଚାଗାଡ଼ଃତାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ଇମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କୁ ଦେଙ୍ଗାନାଙ୍ଗ୍‌ ମେନ୍ତେ ଆକଆଃ ଗାତିକକେ ହାକାଅ କେଦ୍‌କଆକ । ଆଡଃ ଗାତିକ ହିଜୁଃକେଦ୍‌ତେ ବାରିଆ ଲାଉକାରେ ନିମିନ୍‌ ହାକୁ ପେରେଃକେଦ୍‌କଆକ ଯେ ଲାଉକା ତାକଆଃ ଡୁବିଜଃତାନ୍‌ଲେକା ହବାଅଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ଏନା ନେଲ୍‌କେଦ୍‌ତେ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ୟୀଶୁଆଃ କାଟା ସୁବାରେ ଉୟୁଃୟାନାଏ ଆଡଃ କାଜିକେଦାଏ, “ହେ ପ୍ରାଭୁ ଆଇଁୟାଃତାଃଏତେ ସାଙ୍ଗିନଃମେଁ, ଆଇଙ୍ଗ୍‌ଦ ପାପି ହଡ଼ ତାନିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଆୟାଃ ଗାତିକ ମିସାତରା ନିମିନ୍‌ ହାକୁ ନେଲ୍‌କେଦ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ଆଡଃ ଜେବଦୀୟାଃ ହନ୍‌ ଯାକୁବ୍‌ ଆଡଃ ଯୋହାନ୍‌ ଶିମୋନ୍‌ଲଃ ମିସାତେ କାମି ତାଇକେନାକିନ୍‌ ଆଡଃ ଏନ୍‌ ବାରାନ୍‌କିନ୍‌ହ ଆକ୍‌ଦାନ୍ଦାଅ ୟାନାକିନ୍ । ଆଡଃ ୟୀଶୁ ଶିମୋନ୍‌କେ କାଜିକିୟାଏ, “ଆଲମ୍‌ ବରଏୟା, ନାହାଁଃଏତେ ଆମ୍‌ ହଡ଼କକେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃତେ ଆଉକଆମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ଏନ୍ତେ ଇନ୍‌କୁ ଲାଉକାକକେ ଦରେୟା ଗେନାତେ ତେବାଃକେଦ୍‌ଚି ସବେନାଃ ବାଗିକେଦ୍‌ତେ ୟୀଶୁକେକ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ୟୀଶୁ ମିଆଁଦ୍‌ ସାହାର୍‌ରେ ତାଇକେନ୍‌ ଇମ୍‌ତା ଏନ୍ତାଃରେ ନାଗେଘାଅତେ ପେରେଜାକାନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ । ଇନିଃ ୟୀଶୁକେ ନେଲ୍‌ଲଃଗି ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ବିନ୍ତିତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଆଇଙ୍ଗ୍‌କେ ବୁଗିନିୟାର୍‌ ଦାଡ଼ିୟାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ତିଃଇ ଜିଲିଙ୍ଗ୍‌କେଦ୍‌ତେ ଜୁଟିଦ୍‌କିୟାଏ ଆଡଃ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନିଙ୍ଗ୍‌ ଆମ୍‌ ବୁଗିନିୟାରଃମେ ।” ଆଡଃ କାଜିତାନ୍ ତର୍‌ସାଗି ଇନିୟାଃ ନାଗେଘାଅ ଫାର୍‌ଚିୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ଏନ୍ତେ ୟୀଶୁ ହୁକୁମ୍‌କିୟାଏ, “ଜେତାଏକେ ନେ କାଜି ଆଲମ୍‌ ଉଦୁବ୍‌କଆଃ, ମେନ୍‌ଦ, ଜୁ, ଯାଜାକ୍‌ତାଃରେ ଉଦୁବେନ୍‌ମେ ଆଡଃ ଇନ୍‌କୁଆଃ ଗାୱାନାଙ୍ଗ୍‌ ମୁଶାନାବୀ ଆଚୁକାଦ୍‌ ଲେକାତେ ଆମାଃ ଫାର୍‌ଚିରେୟାଃ ଦାଣେଁ ରାକାବେମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ଆଡଃ ୟୀଶୁଆଃ ବିଷାଏରେୟାଃ କାଜି ପୁରାଃଗି ନିତିର୍‌ୟାନା, ଏନ୍ତେ ଇନିୟାଃ ଇତୁଆନ୍‌ କାଜିକ ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଆଡଃ ଆକଆଃ ଦୁକୁଏତେ ବୁଗିୟଃ ନାଗେନ୍ତେ ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃତାଃରେକ ହୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ମେନ୍‌ଦ ୟୀଶୁ ସିଃସଏଃ ଠାୟାଦ୍‌ତେ ସେନଃୟାନ୍ତେ ବିନ୍ତିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ମୁସିଙ୍ଗ୍‌ହୁଲାଙ୍ଗ୍‌ ୟୀଶୁ ଇତୁତାନାଏ ତାଇକେନା, ଏନ୍ତାଃରେ ଫାରୁଶୀ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଦୁବାକାନ୍‌କ ତାଇକେନା, ଇନ୍‌କୁ ଗାଲିଲ୍‌ରେୟାଃ ସବେନ୍‌ ହାତୁ ଆଡଃ ଯିହୁଦା ଦିଶୁମ୍‌ରେୟାଃ ସବେନ୍‌ ହାତୁ ଆଡଃ ଯୀରୁଶାଲେମ୍‌ଏତେ ହିଜୁଃକାନ୍‌କ ତାଇକେନା । ଆଡଃ ଦୁକୁତାନ୍‌କକେ ବୁଗିନ୍‌ ନାଗେନ୍ତେ ପ୍ରାଭୁଆଃ ପେଡ଼େଃ ୟୀଶୁଲଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ହଡ଼କ ମିଆଁଦ୍‌ ବାତ୍‌କାନ୍‌ନିଃକେ ପାର୍‌କମ୍‌ରେ ବାଟିୟାକାନ୍‌ଗି ଗଅଃ ଆଉକିୟାକ ଆଡଃ ଇନିଃକେ ଭିତାର୍‌ତେ ଇଦିକେଦ୍‌ତେ ୟୀଶୁଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଦହନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ଗାଦେଲ୍‌ ହଡ଼କ ତାଇକେନ୍‌ ହରାତେ ଇନ୍‌କୁ ଇନିଃକେ ଭିତାର୍‌ତେ ଆଉ ନାଙ୍ଗ୍‌ ହରା କାକ ନାମ୍‌କେଦା । ଏନାତେ ଇନ୍‌କୁ ସାଡ଼୍‌ମି ଚେତାନ୍‌ତେ ପାର୍‌କମ୍‌ଲଃଗି ଇନିଃକେ ତେଙ୍ଗଃ ରାକାବ୍‌କିୟାଃକ ଆଡଃ ସାଡ଼୍‌ମି ଖାପ୍‌ରା ଆତମ୍‌କେଦ୍‌ତେ ୟୀଶୁଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଡୁଙ୍ଗା ଆଡ଼୍‌ଗୁକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ୟୀଶୁ ଏନ୍‌ ହଡ଼କଆଃ ବିଶ୍ୱାସ୍‌ ନେଲ୍‌କେଦ୍‌ତେ କାଜିକିୟାଏ, “ଏ ଗାତି, ଆମାଃ ପାପ୍‌କ ଛାମାୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ଆକ ଆକରେ ଉଡ଼ୁଃକେଦାଃକ, “ପାର୍‌ମେଶ୍ୱାର୍‌କେ ନିନ୍ଦାଇତାନ୍‌ ନେ ହଡ଼ ଅକଏ ତାନିଃ ? ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବାଗିକେଦ୍‌ତେ ଆଡଃ ଅକଏ ପାପ୍‌ଛାମା ଦାଡ଼ିୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁଆଃ ଉଡ଼ୁଃ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ଆପେ ଆପେୟାଃ ମନ୍‌ରେ ଚିନାଃପେ ଉଡ଼ୁଃତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ଅକ୍‌ନାଃ ରାୱାଲାଃ ? ‘ପାପ୍‌ ତାମାଃକ ଛାମାୟାନା’ ମେନ୍ତେ କାଜିତେୟାଃ ରାୱାଲାଃ ଚି ‘ବିରିଦ୍‌ମେ ଆଡଃ ସେନେମେ’ ମେନ୍ତେ କାଜିତେୟାଃ ? ");
INSERT INTO unx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ମେନ୍‌ଦ ମାନୱାହନ୍‌ଆଃ ନେ ଅତେଦିଶୁମ୍‌ରେ ପାପ୍‌ ଛାମାରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ମେନାଃ” ଏନା ଆପେ ସାରିକାମେନ୍ତେ, ଇନିଃ ଏନ୍‌ ବାତ୍‌କାନ୍‌ନିଃକେ କାଜିକିୟାଏ, “ମାର୍‌ ବିରିଦ୍‌ମେ ଆଡଃ ପାର୍‌କମ୍‌ତାମାଃ ଗଅଃକେଦ୍‌ତେ ଆମାଃ ଅଡ଼ାଃତେ ସେନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଇନିଃ ଇନ୍‌କୁଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ବିରିଦ୍‌ୟାନାଏ, ଆଡଃ ଆୟାଃ ଗିତିଜାକାନ୍‌ ପାର୍‌କମ୍‌କେ ତେଙ୍ଗଃକେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ଦୁରାଙ୍ଗ୍‌ତାନ୍‌ଲଃ ଅଡ଼ାଃତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ଏନ୍ତାଃରେ ତାଇକାନ୍‌ ସବେନ୍‌କ ଆକ୍‌ଦାନ୍ଦାଅୟାନକ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାରାଙ୍ଗ୍‌କିୟାକ, “ଆବୁ ତିସିଙ୍ଗ୍‌ ହାଏକାଟ୍‌ କାମିବୁ ନେଲ୍‌କେଦା” ମେନ୍ତେ ବରତାନ୍‌ଲଃକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ଏନ୍‌ ତାୟମ୍‌ତେ ୟୀଶୁ ଅଡଙ୍ଗ୍‌ୟାନା, ଆଡଃ ଲେବୀ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ମାଲ୍‌ହାରମ୍‌ନିଃକେ ମାଲ୍‌ହାରମ୍‌ ଠାୟାଦ୍‌ରେ ଦୁବାକାନାଏ ନେଲ୍‌କିୟା । ୟୀଶୁ ଇନିଃକେ ମେତାଇଜାଏ, “ଦେଲା ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ଆଡଃ ଲେବୀ ସବେନାଃ ବାଗିକେଦ୍‌ତେ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ଏନ୍ତେ ଲେବୀ ଆୟାଃ ଅଡ଼ାଃରେ ୟୀଶୁ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ଜମେୟାଃଁ ବାଇକେଦାଏ, ଆଡଃ ପୁରାଃ ମାଲ୍‌ହାରମ୍‌କ ଆଡଃ ଏଟାଃ ହଡ଼କ ଇନ୍‌କୁଲଃକ ଜମ୍‌ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ମେନ୍‌ଦ ଫାରୁଶୀ ଆଡଃ ଆଇନ୍‌ ଇତୁକ କୁର୍‌ବୁରାଅଃତାନ୍‌ଲଃ ଆୟାଃ ଚେଲାକକେ ମେତାଦ୍‌କଆକ, “ଆପେ ମାଲ୍‌ହାରମ୍‌କଲଃ ଆଡଃ ପାପିକଲଃ ଚିକା ନାଗେନ୍ତେ ଜମ୍, ନୁଁ ତାନାପେ ?” ");
INSERT INTO unx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “କା ହାସୁତାନ୍‌କଆଃ ନାଗେନ୍ତେ ବାଇଦ୍ କା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ମେନ୍‌ଦ ହାସୁତାନ୍‌କଆଃ ନାଗେନ୍ତେ ବାଇଦ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ଆଇଙ୍ଗ୍‌ ଧାର୍‌ମାନ୍ ହଡ଼କକେ କେଡ଼ା ନାଗେନ୍ତେ କାଇଙ୍ଗ୍‌ ହିଜୁଆକାନା, ମେନ୍‌ଦ ପାପି ହଡ଼କଆଃ ମନ୍‌ରୁହାଡ଼ଃ ନାଗେନ୍ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ଚିମିନ୍‌ ହଡ଼କ ୟୀଶୁକେ କାଜିକିୟାଃକ, “ଯୋହାନ୍‌ଆଃ ଚେଲାକ ମଣେଁସା କାଟାବ୍‌ ଆଡଃ ବିନ୍ତିୟାଃକ, ଏନ୍‌ଲେକା ଫାରୁଶୀକଆଃ ଚେଲାକହ ରିକାଃକ, ମେନ୍‌ଦ ଆମାଃ ଚେଲାକ ସବେନ୍‌ ଇମ୍‌ତାଙ୍ଗ୍‌ ଜମ୍ ନୁଁ ତାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଚିୟାଃ ଆଣ୍‌ଦିଅଡ଼ାଃରେ ଦୁହ୍ଲାକଡ଼ା ବାଲାକଲଃ ତାଇନଃ ଜାକେଦ୍‌ ଆପେ ଚିୟାଃ ଇନ୍‌କୁକେ କାଟାବ୍‌ରିକା ଦାଡ଼ିୟାକଆପେ ? କାହାଗି ! ");
INSERT INTO unx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ମେନ୍‌ଦ ନେଡା ହିଜୁଃଆ ଚିମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କୁତାଃଏତେ ଦୁହ୍ଲାକଡ଼ା ବିନ୍‌ଗାଅଃଆଏ, ଇମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କୁ କାଟାବ୍‌ ରିକାଏୟାକ ।” ");
INSERT INTO unx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ଇନିଃ ଇନ୍‌କୁକେ ନେ ଜନ୍‌କା କାଜି କାଜିୟାଦ୍‌କଆଏ, “ଜେତାଏ ନାୱା ଲିଜାଃରେୟାଃ କେଚାଃ ମାରି ଲିଜାଃରେ ଜଡ଼ାଇକେଦ୍‌ତେ କାକ ତୁନାୟା । ଆଡଃ ଏନ୍‌କାଲେରେଦ ନାୱା ଲିଜାଃଏ ଚାଗାଡ଼େୟା ଆଡଃ ନାୱା ଲିଜାଃରେୟାଃ କେଚାଃ ମାରିଲିଜାଃରେ କା ମେସାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ଆଡଃ ଜେତାଏ ନାୱା ଦାଖ୍‌ରାସିକେ ମାରି ଉହୁର୍‌ତୁମ୍ବାରେ ଜେତାଏ କାକ ଦୁଲ୍‌ପେରେଜେୟା । ଚିୟାଃଚି ନାୱା ଦାଖ୍‌ରାସି ମାରି ଉହୁର୍‌ତୁମ୍ବାରେୟାଃ ଥାଇଲାକେ ଚାଗାଡ଼୍‌ତାଃଏ ଆଡଃ ଦାଖ୍‌ରାସି ଲିଙ୍ଗି ଏଣ୍ଡାଗଃଆ ଆଡଃ ଉହୁର୍‌ରେୟାଃ ଥାଇଲା ଜିୟନଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ମେନ୍‌ଦ ନାୱା ଦାଖ୍‌ରାସିକେ ନାୱା ଉହୁର୍‌ତୁମ୍ବାରେୟାଃ ଥାଇଲାରେ ପେରେଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ଆଡଃ ଜେତାଏ ହଡ଼ ମାରି ଦାଖ୍‌ରାସି ନୁଁକେଦ୍ ତାୟମ୍‌ତେ ନାୱା କାଏ ସାନାଙ୍ଗ୍‌ଆଃ, ଚିୟାଃଚି ଇନିଃଦ ‘ମାରିତେୟାଃକେ ବୁଗିନ୍‌ତେୟାଃ ତାନାଃ’ ମେନେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ୟୀଶୁ ହେରାକାନ୍‌ ପିଡ଼ି ଥାଲାଥାଲାତେ ସେନଃତାନ୍‌ ତାଇକେନାଏ, ଆଡଃ ଆୟାଃ ଚେଲାକ ଗେଲେ ଜ'କେ ହଦ୍‌କେଦ୍‌ତେ ତିଃଇଲଃ ଇତ୍‌କିଦ୍‌କେଦ୍‌ତେ ଜମ୍‌ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ମେନ୍‌ଦ ଚିମିନ୍‌ ଫାରୁଶୀକ କୁଲିକିୟାଃକ, “ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ କା ଲାଗାତିଙ୍ଗ୍‌ କାମି ଚିନାଃମେନ୍ତେକ ରିକାତାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଦାଉଦ୍‌ ଆଡଃ ଆୟାଃ ଗାତିକ ରେଙ୍ଗେଃୟାନ୍‌ ଇମ୍‌ତା ଚିନାଃଏ କାମିକେଦାଃ ଏନା କାପେଚି ପାଢ଼ାୱାକାଦାଃ ? ");
INSERT INTO unx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଅଡ଼ାଃତେ ବଲୟାନା, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନୁତୁମ୍‌ରେ ଏମାକାନ୍‌ ହଲଙ୍ଗ୍‌, ଅକ୍‌ନାଃକେଚି ଆଇନ୍‌ ଲେକାତେ ଯାଜାକ୍‌ ଏସ୍‌କାର୍‌ ଜମ୍ ଦାଡ଼ିୟାଏ ମେନଃତାନା, ଏନାକେ ଆଉକେଦ୍‌ତେ ଜମ୍‌କେଦାଏ ଆଡଃ ଆୟାଃଲଃ ତାଇକାନ୍‌କକେୟ ଏମାଦ୍‌କଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ଏନ୍ତେ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ମାନୱାହନ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେନ୍ ଗମ୍‌କେ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଆଡଃ ଏଟାଃ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଇନିଃ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ବଲୟାନ୍ତେ ଇତୁକେଦ୍‌କଆଏ, ଆଡଃ ଏନ୍ତାଃରେ ତିଃଇ ରହଡ଼ାକାନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ଆଡଃ ୟୀଶୁ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଇନିଃକେ ବୁଗିୟାଏ ଚି କା ଏନା ନେଲ୍‌ ନାଗେନ୍ତେ ଫାରୁଶୀକ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଇନିଃକେ ଘାତାଇତାନ୍‌କ ତାଇକେନା ଚିୟାଃଚି ଇନ୍‌କୁ ୟୀଶୁକେ ଚିଟାଇ ନାଗେନ୍ତେ ହରାକ ଦାଣାଁଁ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁଆଃ ଉଡ଼ୁଃ ସାରିକେଦ୍‌ତେ, ଏନ୍‌ ତିଃଇ ରହଡ଼ାକାନ୍ ହଡ଼କେ କାଜିକିୟାଏ, “ମାର୍‌ ବିରିଦ୍‌ମେ ଆଡଃ ସବେନ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ତିଙ୍ଗୁନ୍‌ମେ, ଆଡଃ ଇନିଃ ବିରିଦ୍‌ୟାନ୍‌ଚି ଏନ୍ତାଃରେ ତିଙ୍ଗୁୟାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆପେକେ କୁଲିପେତାନାଇଙ୍ଗ୍‌, ଆବୁଆଃ ଆଇନ୍‌ଲେକାତେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଅକନ୍‌ କାମି ରିକା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ? ମିହୁଡ଼୍‌ଆଃ ନାଗେନ୍ତେ ବୁଗିନ୍‌ କାମିତେୟାଃ ବୁଗିନାଃ ଚି ଏତ୍‌କାନ୍‌ କାମିତେୟାଃ ବୁଗିନାଃ ? ଜୀଉ ବାଞ୍ଚାଅତେୟାଃ ଚି ଜୀଉ ଜିୟନେତେୟାଃ ?” ");
INSERT INTO unx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ଇନିଃ ସବେନ୍‌କକେ ନେଲ୍‌ବିୟୁର୍ କେଦ୍‌କଚି ଏନ୍‌ ହଡ଼କେ କାଜିକିୟାଏ, “ତିଃଇତାମାଃ ଜିଲିଙ୍ଗ୍‌ୟେଁମେ ।” ଏନ୍ତେ ଇନିଃ ତିଃଇତାୟାଃ ଜିଲିଙ୍ଗ୍‌କେଦାଏ ଆଡଃ ତିଃଇତାୟାଃ ପୁରାଗି ବୁଗିରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ମେନ୍‌ଦ ଇନ୍‌କୁ ଏନେସେଦ୍‌ତେ ବାଲୁୟାନାକ, ଆଡଃ ୟୀଶୁକେ ଚିନାଃବୁ ଚିକାଇୟା ମେନ୍ତେ ଆକଥାଲାରେ କାପାଜିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌କରେ ୟୀଶୁ ବିନ୍ତି ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ବୁରୁତେ ଅଡଙ୍ଗ୍‌ୟାନା, ଆଡଃ ମିଦ୍‌ନିଦା ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ବିନ୍ତିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ଆଙ୍ଗ୍‌ୟାନ୍‌ଚି ଇନିଃ ଆୟାଃ ଚେଲାକକେ ଆୟାଃତାଃତେ କେଡ଼ାକେଦ୍‌କଆଏ ଆଡଃ ଇନ୍‌କୁଏତେ ଗେଲ୍‌ବାର୍‌ ହଡ଼କକେ ସାଲାକେଦ୍‌କଆଏ, ଆଡଃ ଇନ୍‌କୁକେ ପ୍ରେରିତ୍‌ ମେନ୍ତେ ନୁତୁମ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ଇନ୍‌କୁଆଃ ନୁତୁମ୍‌ ଶିମୋନ୍‌, ଇନିଃକେ ପାତ୍‌ରାସ୍‌ ମେନ୍ତେ ନୁତୁମ୍‌କିୟାଏ, ଶିମୋନ୍‌ଆଃ ହାଗାତେ ଆନ୍ଦ୍ରିୟାସ୍‌, ଯାକୁବ୍‌, ଯୋହାନ୍‌, ଫିଲିପ୍‌, ବାର୍ଥୋଲମି, ");
INSERT INTO unx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାଥିଉ, ଥୋମା, ଆଲ୍‌ଫିୟନାଃ ହନ୍ତେକଡ଼ା ଯାକୁବ୍‌, ଶିମୋନ୍‌, ଅକଏଚି ଇସ୍ରାଏଲ୍‌ ହଡ଼କଆଃ ତନଲ୍‌ହେତେ ରାଡ଼ା ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌ ତାଇକେନାଏ, ");
INSERT INTO unx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଯାକୁବ୍‌ଆଃ ହନ୍ତେକଡ଼ା ଯିହୁଦା, ଆଡଃ ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା, ତାୟମ୍‌ତେ ନେ ଯିହୁଦା ୟୀଶୁକେ ବାଇରିକତାଃରେ ଜିମାକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ବୁରୁଏତେ ଲାତାର୍‌ତେ ଆଡ଼୍‌ଗୁୟାନାକ । ଆଡଃ ଇନିଃ ତିଙ୍ଗୁକାନ୍‌ ସାମ୍‌ ଠାୟାଦ୍‌ତାଃରେ ଆୟାଃ ପୁରାଃ ଗାଦେଲ୍‌ ଚେଲାକ ତାଇକେନା ଆଡଃ ଏନ୍ତାଃରେ ଗଟା ଯିହୁଦା ଦିଶୁମ୍‌ରେନ୍, ଯୀରୁଶାଲେମ୍‌ରେନ୍, ଦରେୟାଗେନା ସୋର୍‌ରେନ୍ ଆଡଃ ସିଦୋନ୍‌ରେନ୍‌ ପୁରାଃ ହଡ଼କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ଇନ୍‌କୁ ୟୀଶୁଆଃ ଇନିତୁ ଆୟୁମ୍‌ ଆଡଃ ଆକଆଃ ଦୁକୁଏତେ ବୁଗିୟଃ ନାଗେନ୍ତେ ହିଜୁଃକାନ୍‌କ ତାଇକେନା । ଆଡଃ ସତ୍‌ରା ଆତ୍ମାକଏତେ ଦୁକୁଆକାନ୍‌କ ବୁଗିୟାନା ");
INSERT INTO unx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ଆଡଃ ସବେନ୍‌କ ଇନିଃକେ ଜୁଟିଦିନାଙ୍ଗ୍‌କ ସାନାଙ୍ଗ୍‌ ତାଇକେନା, ଚିୟାଃଚି ଇନିଃତାଃଏତେ ପେଡ଼େଃ ଅଡଙ୍ଗ୍‌ଅଃତାନ୍‌ ତାଇକେନା ଆଡଃ ଇନ୍‌କୁ ବୁଗିଅଃତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ୟୀଶୁ ଆୟାଃ ଚେଲାକସାଃ ନେଲ୍‌କେଦ୍‌ତେ କାଜିକେଦ୍‌କଆଏ, “ରେଙ୍ଗେଃତାନ୍‌କ ସୁକୁତାନ୍‌ଗିୟାଃ; ଚିୟାଃଚି ସିର୍ମା ରାଇଜ୍‌ ଇନ୍‌କୁଆଃଗି ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ନାହାଁଃ ଆପେ ରେଙ୍ଗେଃତାନ୍‌କ, ସୁକୁତାନ୍‌ ଗିୟାଃପେ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେକେ ବିୟଃଗି ଏମାପେୟା ! ନାଆଃ ଆପେ ରାଆଃଏ ତାନ୍‌କ, ସୁକୁତାନ୍‌ ଗିୟାଃପେ, ଚିୟାଃଚି ଆପେଦ ଲାନ୍ଦାଏୟାପେ । ");
INSERT INTO unx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“ମାନୱାହନ୍‌ଆଃ ନାଗେନ୍ତେ ହଡ଼କ ଆପେକେ ହିଲାଙ୍ଗ୍‌ପେରେ, ଆପେକେ ଆତମ୍‌ପେରେ, ଆପେକେ ନିନ୍ଦାପେରେ ଆଡଃ ଆପେୟାଃ ନୁତୁମ୍‌ ଏତ୍‌କାନ୍‌ ନୁତୁମ୍‌ଲେକାକ ଇଦିଲେରେ ଆପେ ସୁକୁତାନ୍‌ ଗିୟାଃପେ । ");
INSERT INTO unx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ରାସ୍‌କାଅଃପେ ଆଡଃ ରାସ୍‌କାତେ ସୁସୁନ୍‌ନେପେ, ଚିୟାଃଚି ନେଲେପେ, ଆପେୟାଃ ନାଙ୍ଗ୍‌ ପୁରାଗି ଜ ସିର୍ମାରେୟା । ଇନ୍‌କୁଆଃ ପୁର୍‌ଖାହାଡ଼ାମ୍‌କ ନାବୀକକେ ସିଗିଦ୍‌କେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ମେନ୍‌ଦ ଆପେ କିସାଁଣ୍‌ ହଡ଼କଆଃ ହାୟ ହାୟ ଆପେ ଦୁକୁପେ ନାମେୟା, ଚିୟାଃଚି ଆପେଦ ଆପେୟାଃ ଜୀଦାନ୍‌ରେ ଜୀଉରାଡ଼େଃପେ ନାମ୍‌ଚାବାକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ଆପେ ନାହାଁଃ ବିୟାକାନ୍‌କଆଃ ହାୟ ହାୟ, ଆପେଦପେ ରେଙ୍ଗେଜଆଃ । ଆପେ ନାହାଁଃ ଲାନ୍ଦାତାନ୍‌କଆଃ ହାୟ ହାୟ, ଚିୟାଃଚି ଆପେଦପେ ଏୟମେଁୟା ଆଡଃପେ ରାଆଃୟା । ");
INSERT INTO unx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“ସବେନ୍‌ ହଡ଼କ ଆପେକେ ବୁଗିନ୍‌କ ମେତାପେରେ, ଆପେୟାଃ ହାୟ ହାୟ, ଇନ୍‌କୁଆଃ ପୁର୍‌ଖାହାଡ଼ାମ୍‌କ ହସଡ଼ ନାବୀକକେ ଏନ୍‌କାକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେ ଆୟୁମ୍‌ତାନ୍‌କକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆପେୟାଃ ବାଇରିକକେ ଦୁଲାଡ଼୍‌କପେ, ଅକନ୍‌କ ଆପେକେ ଖିସ୍‌ସାଅପେୟାକ ଇନ୍‌କୁଆଃ ବୁଗିନ୍‌ ରିକାଏପେ । ");
INSERT INTO unx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଜେତାଏ ଆପେକେ ସାର୍‌ପାଅପେକ, ଆଶିଷ୍‌କପେ, ଆପେକେ ହିଲାଙ୍ଗ୍‌ପେକ, ବିନ୍ତିପେ । ");
INSERT INTO unx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଜେତାଏ ଆପେକେ ମିଆଁଦ୍‌ ଜଆରେ ଥାପ୍‌ଡ଼ିପେରେଦ, ଏଟାଃ ଜୱାହଗି ବିୟୁରାଇପେ । ଜେତାଏ ଆପେୟାଃ ଚାଦାର୍‌ ଲିଜାଃ ଇଦିରେଦ, ଇନିଃକେ ଆପେୟାଃ ହଡ଼୍‌ମରେ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃ ହଗି ଇଦିନାଙ୍ଗ୍‌ ଆଲପେ ମାନାଇୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଜେତାଏ ଆପେକେ ଆସିପେରେଦ ଇନିଃକେ ଏମାଇପେ, ଆଡଃ ଆପେୟାଃ ମେନାଃତେୟାଃ ରେଃକ୍‌ଇଦିପେରେଦ, ଇନିଃକେ ଆଲପେ ଆସିରୁହାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ହଡ଼କ ଆଲେନାଙ୍ଗ୍‌ ରିକାଏକାକ ମେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନ୍‌ ଲେକା, ଆପେୟଗି ଇନ୍‌କୁ ନାଗେନ୍ତେ ଏନ୍‌ଲେକା ରିକାଏପେ । ");
INSERT INTO unx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ଆପେକେ ଅକନ୍‌କ ଦୁଲାଡ଼୍‌ପେତାନାକ ଇନ୍‌କୁକେ ଏସ୍‌କାର୍‌ ଦୁଲାଡ଼୍‌ରେକରେ, ଆପେ ଚିକା ନାଙ୍ଗ୍‌ ଆଶିଷ୍‌ପେ ନାମେୟା ? ପାପି ହଡ଼କହ ଆକକେ ଦୁଲାଡ଼୍‌ତାନ୍‌ ହଡ଼କକେ ଦୁଲାଡ଼୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ଆଡଃ ଅକନ୍‌କ ଆପେୟାଃ ବୁଗିନାଃ କାମିତାନାକ, ଇନ୍‌କୁଆଃ ଏସ୍‌କାର୍‌ ଆପେ ବୁଗିନ୍‌ କାମିପେ ରିକାଏ ରେଦ, ଆପେ ଚିକାନ୍‌ ଆଶିଷ୍‌ପେ ନାମେୟା ? ପାପି ହଡ଼କହଗି ଏନ୍‌ଲେକା କାମିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ଆଡଃ ଅକନ୍‌ କତାଃଏତେ ଆପେୟାଃ ନାମଃ ରୁହାଡ଼୍‌ରେୟାଃ ଆସ୍ରା ତାଇନାଃ, ଇନ୍‌କୁକେ ଏସ୍‌କାର୍‌ ରିଣୀ ଏମ୍‌ଲେକରେ ଆପେ ଚିକାନ୍‌ ଆଶିଷ୍‌ପେ ନାମେୟା ? ଏମାକାଦ୍‌ତେୟାଃ ଇମିୟାଙ୍ଗ୍‌ଗିବୁ ନାମ୍‌ରୁହାଡ଼େୟାଃ ମେନ୍ତେ ପାପି ହଡ଼କହଗି ପାପିକକେ ରିଣୀକ ଏମାକଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ମେନ୍‌ଦ ଆପେୟାଃ ବାଇରିକକେ ଦୁଲାଡ଼୍‌କପେ, ବୁଗିନ୍‌ କାମି ରିକାଏପେ ଆଡଃ ନାମ୍‌ରୁହାଡ଼୍‌ରେୟାଃ ଆସ୍ରାବାଗିକେଦ୍‌ତେ ରିଣୀ ଏମାକପେ ଏନ୍ତେ ଆପେ ପୁରାଃ ଜ'ପେ ନାମେୟା, ଆପେ ମାରାଙ୍ଗ୍‌ ଉତାର୍‌ନିୟାଃ ହନ୍‌କପେ ବାୟୁଃଆ, ଚିୟାଃଚି ଇନିଃଦ କା ଜହାର୍‌କ ଆଡଃ ଏତ୍‌କାନ୍‌କକେ ଲିବୁଇୟାକତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ ଲିବୁଇତାନ୍‌ ଲେକା, ଆପେୟ ଲିବୁଆକପେ । ");
INSERT INTO unx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ଏଟାଃକକେ ଆଲ୍‌ପେ ବିଚାର୍‌କଆ, ଏନାରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେକେ କାଏ ବିଚାର୍‌ପେୟା, ଆଲ୍‌ପେ ଚିଟାକଆ, ଏନ୍ତେ ଆପେ କାପେ ଚିଟାଃୱା । ଛାମାକପେ, ଏନ୍ତେ ଆପେକେ ଛାମାୱାଃ । ");
INSERT INTO unx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ଏମେପେ, ଏନ୍ତେ ଆପେକେ ଏମଃଆ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେକେ, ତାମ୍ବିରେ ଅତାପେରେଃକେଦ୍‌ତେ, ଆଡଃ ଉଛ୍‌ଲାଅଃଗି ପୁରାଃ ସଙ୍ଗ୍‌କେଦ୍‌ତେ ଆପେୟାଃ କୟଙ୍ଗ୍‌ରେକ ଦୁଲାପେୟା ଚିୟାଃଚି ଆପେ ସଙ୍ଗେ ତାମ୍ବିରେଗି ଆପେ ନାଗେନ୍ତେ ସୋଙ୍ଗଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁକେ ନେ ଜନ୍‌କା କାଜି କାଜିୟାଦ୍‌କଆଏ, “ଚିୟାଃ ମେଦ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିନିଃ, ଆଡଃ ମିଆଁଦ୍‌ ମେଦ୍‌ କା ନେଲ୍‌ ଦାଡ଼ିନିଃକେ ହରା ଉଦୁବ୍‌ ଦାଡ଼ିୟାଃଏ ? ଇନିଃ ଏନ୍‌କା ରିକାଏରେଦ, ଚିୟାଃ ବାରାନ୍‌କିନ୍‌ ଗାଡାରେକିନ୍ ଉୟୁଗଃଆ ? ");
INSERT INTO unx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଗୁରୁଏତେ ଚେଲା କାଏ ମାରାଙ୍ଗ୍‌ଆଃ, ମେନ୍‌ଦ ଜେତାଏ ପୁରା ଇତୁକେଦ୍‌ରେ ଆୟାଃ ଗୁରୁ ଲେକାଅଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ଆମ୍‌ ଆମାଃ ମେଦ୍‌ରେଆଃ ଚୁବାଃ କା ନେଲ୍‌କେଦ୍‌ତେ ହାଗାମାଃ ମେଦ୍‌ରେଆଃ ହୁଡିଙ୍ଗ୍‌ ଚୁବାଃ ଚିକା ନାଗେନ୍ତେମ୍‌ ନେଲେତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ଆମାଃ ମେଦ୍‍ରେ ଚୁବାଃ ତାଇନ୍‌କେଦ୍‌ତେ, ‘ହାଗାମାଃ ମେଦ୍‌ରେଆଃ ଚୁବାଃକେ ଅଡଙ୍ଗ୍‌ତାମାଇଙ୍ଗ୍‌’ ମେନ୍ତେ ଚିଲ୍‌କାତେ କାଜି ଦାଡ଼ିୟାମ୍‌ ? ଏ ବେଦାହଡ଼, ସିଦାତେ ଆମାଃ ମେଦ୍‌ରେଆଃ ଚୁବାଃ ଅଡଙ୍ଗ୍‌ୟେଁମେ, ଏନ୍ତେ ହାଗାମାଃ ମେଦ୍‌ରାଃ ଚୁବାଃ ଅଡଙ୍ଗ୍‌ ନାଗେନ୍ତେ ବୁଗିଲେକାମ୍‌ ନେଲ୍‌ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ବୁଗିନ୍‌ ଦାରୁରେଦ ଏତ୍‌କାନ୍‌ ଜ କା ଜଅଃ'ଆଃ, ଆଡଃ ଏତ୍‌କାନ୍‌ ଦାରୁରେଦ ବୁଗିନ୍‌ ଜ କା ଜଅଃ'ଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ମିମିଆଦ୍ ଦାରୁଦ ଆୟାଃ ଜ'ତେଗି ନେଲ୍‌ଉରୁମଃଆ । ଜାନୁମ୍‌ ଦାରୁଏତେଦ ହଡ଼କ ଲଆ ଜ କାକ ଗଦେୟା ଆଡଃ ଜାନୁମ୍‌ ଚୁପାଦ୍‌ଏତେଦ ଦାଖ୍‌ ଜ କାକ ଗଦେୟା । ");
INSERT INTO unx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ବୁଗିନ୍‌ ହଡ଼ ଆୟାଃ ମନ୍‌ସୁରୁଦ୍‌ ଲେକାନ୍‌ ବୁଗିନ୍‌ ଭାଣ୍ଡାର୍‌ଅଡ଼ାଃଏତେ ବୁଗିନାଃ ତେୟାଃ ଅଡଙ୍ଗ୍‌ୟେଁଆଏ ଆଡଃ ଏତ୍‌କାନ୍‌ ହଡ଼ ଆୟାଃ ଏତ୍‌କାନ୍‌ ଭାଣ୍ଡାର୍‌ଅଡ଼ାଃଏତେ ଏତ୍‌କାନ୍‌ତେୟାଃ ଅଡଙ୍ଗ୍‌ୟେଁଆଏ । ଚିଆଃଚି ଆୟାଃ ମନ୍‌ସୁରୁଦ୍‌ରେ ପେରେଜାକାନ୍‌ତେୟାଃ ମଚାଏ କାଜିୟା । ");
INSERT INTO unx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ଆପେ ଚିନାଃମେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ, ‘ହେ ପ୍ରାଭୁ, ହେ ପ୍ରାଭୁପେ,’ ମେତାଇଙ୍ଗ୍‌ତାନା ଆଡଃ ଆଇଁୟାଃ କାଜି ଆପେ କାପେ ମାନାତିଙ୍ଗ୍‌ତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଜେତାଏ ଆଇଁୟାଃତାଃ ହିଜୁଃନିଃ ଆଡଃ ଆଇଁୟାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ମାନାତିଙ୍ଗ୍‌ନିଃ, ଇନିଃ ଅକଏ ଲେକାଃଏ ଏନା ଆପେକେଇଙ୍ଗ୍‌ ଉଦୁବାପେୟା । ");
INSERT INTO unx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ଇନିଃ ନେ'ଲେକାନ୍‌ ଅଡ଼ାଃ ବାଇତାନ୍ ହଡ଼ ଲେକାଃଏ, ଇନିଃ ଉର୍‌କେଦ୍‌ତେ ନିହିଁଗାଡ଼ା କେଦାଏ ଆଡଃ ଦିରି ଚେତାନ୍‌ରେ ବାଇକେଦାଏ, ଆଡଃ ଟୁଡା ହିଜୁଃଲେନ୍‌ରେ ଏନ୍‌ ଅଡ଼ାଃରେ ଦାଆଃ ଟଗଃତାନ୍ ତାଇକେନା ମେନ୍‌ଦ ଏନାକେ କାଏ ହାଦୁଡ଼୍‌ ଦାଡ଼ିକେଦା, ଚିୟାଃଚି ଏନାଦ ଚାଟେନ୍‌ ଦିରି ଚେତାନ୍‌ରେ ବାଇୟାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ମେନ୍‌ଦ ଆଇଁୟାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ କା ମାନାତିଙ୍ଗ୍‌ନିଃ ଅତେରେ ବେଗାର୍‌ ନିହିଁଗାଡ଼ାତେ ବାଇୟାକାନ୍ ଅଡ଼ାଃ ଲେକାନ୍‌ନିଃ ତାନିଃ, ଏନ୍‌ ଅଡ଼ାଃରେ ଟୁଡା ଦାଆଃ ପୁରାଃଗି ଧାକ୍‌କାକେଦ୍‌ ଇମ୍‌ତା ଏନା ହାଦୁଡ଼୍‌ୟାନା ଆଡଃ ଏନାରାଃ ଜିୟନଃ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ୟୀଶୁ ହଡ଼କକେ ଆୟାଃ ସବେନ୍‌ କାଜି କାଜିଚାବାକେଦ୍‌ଚି କପର୍‌ନାହୁମ୍‌ ସାହାର୍‌ତେ ବଲୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ଏନ୍ତାଃରେ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ମିଆଁଦ୍‌ ରୋମି ଗମ୍‌କେୟାଃ ଦାସି ବେମାର୍‌ତେ ଗଜଃଲେକାଏ ତାଇକେନା, ଇନିଃକେ ଇନିୟାଃ ଗମ୍‌କେ ପୁରାଃଗି ଦୁଲାଡ଼ିତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଗମ୍‌କେ ୟୀଶୁଆଃ ବିଷାଏରେ ଆୟୁମ୍‌କେଦ୍‌ଚି, ଆମ୍‌ ହିଜୁଃକେଦ୍‌ତେ ଆଇଁୟାଃ ଦାସିକେ ବୁଗିମେ ମେନ୍ତେ ଯିହୁଦୀକଆଃ ପ୍ରାଚିନ୍‌କକେ ୟୀଶୁତାଃ ଗୋହାର୍‌ ନାଗେନ୍ତେ କୁଲ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ଇନ୍‌କୁ ୟୀଶୁତାଃ ସେଟେର୍‌ୟାନ୍‌ଚି ଇନିଃକେ ପୁରାଃଗି ବିନ୍ତିତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ଇନିଃ ଆମାଃ ଦେଙ୍ଗା ନାମେ ଲେକାଗିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ଚିୟାଃଚି ଇନିଃଦ ଆବୁ ଜାତିରେନ୍‌କକେ ଦୁଲାଡ଼୍‌କତାନାଏ ଆଡଃ ଆଇଃକ୍‌ଗି ଆବୁନାଙ୍ଗ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃ ବାଇୟାକାଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ଏନାତେ ୟୀଶୁ ଇନ୍‌କୁଲଃ ସେନଃୟାନାଏ । ଆଡଃ ୟୀଶୁ ଇନିୟାଃ ଅଡ଼ାଃ ନାଡ଼େଃତେ ହିଜୁଃ ସେଟେର୍‌ତାନ୍ ଇମ୍‌ତା ଇନିଃ ଆୟାଃ ଗାତିକକେ ୟୀଶୁତାଃତେ କାଜି କୁଲ୍‌କେଦ୍‌କଆଏ, “ହେ ଗମ୍‌କେ ଆଲମ୍‌ ଦୁକୁନାଃ, ଚିୟାଃଚି ଆମ୍‌ ଆଇଁୟାଃ ଅଡ଼ାଃରେମ୍‌ ବଲଆ ଏନ୍‌ ଲେକାନ୍‌ନିଃଦ ନାହାଁଲିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ଏନା ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆମାଃତାଃତେ ସେନଃନାଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌କେଦାଃ । ମେନ୍‌ଦ ଆମ୍‌ ମିସାଗି କାଜିତାମ୍, ଆଇଁୟାଃ ଦାସି ବୁଗିକଆଃଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ହଁ ଏଟାଃକଆଃ ଆକ୍‌ତେୟାର୍‌ରେ ମେନାଇୟାଁଃ, ସିପାଇକ ଆଇଁୟାଃ ଆକ୍‌ତେୟାର୍‌ରେ ମେନାକଆଃ । ଆଇଙ୍ଗ୍‌ ମିହୁଡ଼୍‌କେ ସେନଃମେ ମେତାଇରେଦ ଇନିଃ ସେନଃଆଏ ଆଡଃ ଏଟାଃନିଃକେ ହିଜୁଃମେ ମେତାଇରେ ଇନିଃ ହିଜୁଃଆଏ । ଆଇଁୟାଃ ଦାସିକେ ନେୟାଁ କାମିମେ ମେତାଇରେ ଇନିଃ କାମିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ୟୀଶୁ ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନା, ଆଡଃ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ଆୟାଃ ତାୟମ୍‌ରେ ଅତଙ୍ଗ୍‌ଇଁ ତାନ୍‌କକେ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଇସ୍ରାଏଲ୍‌ରେୟ ନେ ଲେକାନ୍ ମାରାଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ କାଇଙ୍ଗ୍‌ ନାମାକାଦାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ଏନ୍ତେ ୟୀଶୁଆଃ ଜାପାଃତେ କୁଲ୍‌ଲେନ୍‌କ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ୟାନ୍ତେ ଏନ୍‌ ଦାସିକେ ବୁଗିୟାକାନ୍‌କ ନାମ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ରେ ୟୀଶୁ ନାଇନ୍ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସାହାର୍‌ତେ ସେନଃୟାନାଏ, ଆଡଃ ଇନିଃଲଃ ଆୟାଃ ଚେଲାକ ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିୟାଃଲଃ ସେନ୍‌ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ଆଡଃ ସାହାର୍‌ ଦୁଆର୍‌ତେ ତେବାଃୟାନ୍‌ଚି, ହଡ଼କ ମିଆଁଦ୍‌ ମାଁଡ଼ା ଗଅଃ ଅଡଙ୍ଗ୍‌ଏତାନ୍‌କ ତାଇକେନା । ଇନିଃ ଆୟାଃ ରାଣ୍ଡିକୁଡ଼ି ଏଙ୍ଗାତେୟାଃ ମିଆଁଦ୍‌ଗି ହନ୍‌କଡ଼ା ତାଇକେନାଏ । ଆଡଃ ସାହାର୍‌ରେନ୍ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃଲଃ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ଏନ୍‌ ରାଣ୍ଡିକୁଡ଼ିକେ ନେଲ୍‌କେଦ୍‌ତେ ପ୍ରାଭୁ ଇନିଃକେ ଦାୟାଇତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ଆଲ୍‌ମେ ରାଆଃୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ଏନ୍ତେ ୟୀଶୁ ସେନ୍ ନାଡ଼େଃକେଦ୍‌ତେ ପାର୍‌କମାଏ ଜୁଟିଦ୍‌କେଦା ଆଡଃ ଗଅଃକାଦ୍‌ ହଡ଼କ ତିଙ୍ଗୁୟାନାକ । ୟୀଶୁ ଗଜାକାନ୍‍ ହଡ଼କେ କାଜିକିୟାଏ, “ଏ ସେପ୍‌ଡ଼େଦ୍, ମାର୍‌ ବିରିଦ୍‌ମେ ମେତାମ୍‌ତାନାଇଙ୍ଗ୍‌ !” ");
INSERT INTO unx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ଏନ୍‌ ଗଜାକାନ୍‌ନିଃ ବିରିଦ୍‌ୟାନ୍‌ଲଃ ଦୁବ୍‌ୟାନାଏ, ଆଡଃ ବାଖାଁଣ୍‌ ଏଟେଦ୍‌କେଦାଏ, ୟୀଶୁ ଇନିଃକେ ଇନିୟାଃ ଏଙ୍ଗାତେତାଃରେ ଜିମାକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ନେୟାଁ ନେଲ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ ବରକେଦାଃକ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାନାରାଙ୍ଗ୍‌ ତାନ୍‌ଲଃ କାଜିକେଦାଃକ, “ଆବୁ ଥାଲାରେ ମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ନାବୀ ହିଜୁଆକାନାଏ । ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ହଡ଼କକେ ବାଞ୍ଚାଅ ନାଙ୍ଗ୍‌ ହିଜୁଆକାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ଆଡଃ ୟୀଶୁଆଃ ନେ ବାନାର୍‌ ଗଟା ଯିହୁଦାରେ ଆଡଃ ଗଟା ହପର୍‌ଜାପାଃ ଦିଶୁମ୍‌ରେ ନିତିର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ଯୋହାନ୍‌ଆଃ ଚେଲାକ ନେ ସବେନ୍‌ କାଜିକ ଯୋହାନ୍‌କେ ଉଦୁବ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ଯୋହାନ୍‌ ଆୟାଃ ଚେଲାକଏତେ ବାର୍‌ହଡ଼୍‌କିନ୍‌କେ କେଡ଼ାକେଦ୍‌କିନାଏ, ଆଡଃ ପ୍ରାଭୁତାଃତେ ନେଆଁଁ କୁଲିନାଙ୍ଗ୍‌ କୁଲ୍‌କେଦ୍‌କିନାଏ “ଏନ୍‌ ହିଜୁଃନିଃ ଆମ୍‌ଗି ତାନ୍‌ମେ ଚି ଏଟାଃନିଃଲେ ନେଲ୍‌ହରାଇୟା ?” ");
INSERT INTO unx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ଆଡଃ ଇନ୍‌କିନ୍‌ ୟୀଶୁତାଃ ହିଜୁଃୟାନ୍ତେ କାଜିକେଦାଃକିନ୍ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ଆଲିଙ୍ଗ୍‌କେ ଆମାଃତାଃତେ ନେୟାଁ କୁଲି ନାଗେନ୍ତେ କୁଲାକାଦ୍‌ଲିଙ୍ଗ୍‌ଆଏ, “ଏନ୍‌ ହିଜୁଃନିଃ ଆମ୍‌ଗି ତାନ୍‌ମେ ଚି ଏଟାଃନିଃଲେ ନେଲ୍‌ହରାଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ଏନ୍‌ ଦିପିଲିରେଗି ୟୀଶୁ ପୁରାଃ ହାସୁତାନ୍ ଦୁକୁତାନ୍‌ ଆଡଃ ଏତ୍‌କାନ୍‌ ଆତ୍ମା ଏସେରାକାଦ୍ ହଡ଼କକେ ବୁଗିକେଦ୍‌କଆଏ, ଆଡଃ ପୁରାଃ କା ନେଲ୍‌ଦାଡ଼ିତାନ୍‌କକେ ନେଲ୍‌ରିକାକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ୟୀଶୁ ଯୋହାନ୍‌ଆଃ ଚେଲାକିନ୍‌କେ କାଜିକେଦ୍‌କିନାଏ, “ଆବେନ୍ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ଅକ୍‌ନାଃବେନ୍‌ ନେଲାକାଦା ଆଡଃ ଆୟୁମାକାଦା ଏନାକ ଯୋହାନ୍‌କେ ଉଦୁବାଇବେନ୍, କାଣାଁକାନ୍‌କ ନେଲେତାନା, କାଟା ଲେଙ୍ଗ୍‌ଡ଼ାକାନ୍‌କ ସେସେନ୍‌ତାନା, ନାଗେଘାଅକାନ୍‌କ ଫାର୍‌ଚିଅଃତାନା, ଭାଏଁରାକାନ୍‌କ ଆୟୁମେତାନା, ଗଜାକାନ୍‌କ ଜୀଉବିରିଦ୍‌ ରୁହାଡ଼ଃତାନା, ଆଡଃ ରେଙ୍ଗେଃ ହଡ଼କତାଃରେ ସୁକୁକାଜି ଉଦୁବଃତାନା । ");
INSERT INTO unx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ଆଇଁୟାଃ ବିଷାଏରେ ଅକନ୍‌କଆଃ ଜେତାନ୍‌ ଆଡ଼ାଃଉଡ଼ୁଃ ବାନଃଆ, ଇନ୍‌କୁ ସୁକୁତାନ୍‌ଗିୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ଯୋହାନ୍‌ଆଃ ଚେଲାକିନ୍ ସେନଃୟାନ୍‌ଚି ୟୀଶୁ ଯୋହାନ୍‌ଆଃ ବିଷାଏରେ ହଡ଼କକେ କାଜି ଏଟେଦ୍‌କେଦ୍‌ଆଏ, “ଆପେ ଚିକ୍‌ନାଃ ନେନେଲ୍‌ତେ ବିର୍‌ତେପେ ସେନ୍‌କେନା ? ଚିନାଃ ହୟତେ ଏକ୍‌ଲାଅଃତାନ୍‌ ବିର୍‌ନି ତାସାଦ୍‌କେ ? ");
INSERT INTO unx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ଏନା କା'ରେଦ ଚିକ୍‌ନାଃ ନେନେଲ୍‌ତେପେ ଅଡଙ୍ଗ୍‌ୟାନା । ଚିନାଃ ଗନଙ୍ଗ୍‌ଆଁନ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍ ହଡ଼କେ ? ନେଲେପେ, ଗନଙ୍ଗ୍‌ଆଁନ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍‌ ଆଡଃ ସୁକୁତେ ତାଇନଃତାନ୍‌ ହଡ଼କ ରାଜାକଆଃ ଅଡ଼ାଃକରେକ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","କାଜିଙ୍ଗ୍‌ପେ, ଏନା କାହାରେଦ, ଚିକ୍‌ନାଃ ନେନେଲ୍‌ତେପେ ଅଡଙ୍ଗ୍‌ଲେନା ? ଚିନାଃ ମିଆଁଦ୍‌ ନାବୀକେ ? ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି ମେତାପେ ତାନାଇଙ୍ଗ୍‌, ନାବୀଏତେ ମାରାଙ୍ଗ୍‌ନିଃକେପେ ନେଲିୟା । ");
INSERT INTO unx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଯୋହାନ୍‌ଆଃ ନାଗେନ୍ତେ ଧାରାମ୍‌ପୁଥିରେ ନେଆଁଁ ଅଲାକାନା, ‘ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିକେଦାଏ, ନେଲେମେ, ଆଲେ ଆମାଃଏତେ ସିଦାରେ ଆଲେୟାଃ ଦୁଁତ୍‌କେଲେ କୁଲିତାନା ଇନିଃ ଆମାଃ ନାଗେନ୍ତେ ପାହିଲାରେ ହରା ବାଇୟାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ‘କୁଡ଼ିକଏତେ ଜାନାମାକାନ୍‌ ସବେନ୍‌କଆଃ ଭିତାର୍‌ରେ ଯୋହାନ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ ଜେତାଏ ବାଙ୍ଗାଇୟା, ହଲେହଁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେନ୍‌ ହୁଡିଙ୍ଗ୍‌ନିଃ ଯୋହାନ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ଆଏ ।’” ");
INSERT INTO unx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ୟୀଶୁଆଃ ଇନିତୁ ଆୟୁମ୍‌ତାନ୍ ସବେନ୍‌ ହଡ଼କ, ନେ'ଲେକାଚି ମାଲ୍‌ହାରମ୍‌କହ, ସାରିକେଦାଃକ ଯେ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହରା ସାର୍‌ତିଗିଆଃ, ଚିୟାଃଚି ଇନ୍‌କୁକେ ସିଦାରେ ଯୋହାନ୍‌ ବାପ୍ତିସ୍ମା ଏମାକାଦ୍‌କ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ମେନ୍‌ଦ ଫାରୁଶୀକ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାନାଙ୍ଗ୍‌ ଆକ ନାଗେନ୍ତେକ ହିଲାଙ୍ଗ୍‌କେଦାଃ ଆଡଃ ଯୋହାନ୍‌ତାଃଏତେ କାକ ବାପ୍ତିସ୍ମାୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ୟୀଶୁ ଆଡଃଗି କାଜିକେଦାଏ, “ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କକେ ଅକଏଲଃ ଆଇଙ୍ଗ୍‌ ଜକାକଆ ? ଆଡଃ ଇନ୍‌କୁ ଅକଏ ଲେକାଃକ ? ");
INSERT INTO unx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ଇନ୍‌କୁଦ ପିଟ୍‌ରେ ଦୁବାକାନ୍‌ ଆଡଃ ଆକ ଆକରେ ହାକାଅଃତାନ୍‌ ହନ୍‌କ ଲେକାଃକ, ଆଲେ ଆପେ ନାଗେନ୍ତେ ମୁର୍‌ଲିଲେ ସାଡ଼ିକେଦା, ମେନ୍‌ଦ ଆପେ କାପେ ସୁସୁନ୍‌କେଦାଃ, ଆଲେ ଦୁକୁତାନ୍‌ ଦୁରାଙ୍ଗ୍‌ଲେ ଦୁରାଙ୍ଗ୍‌କେଦାଃ ମେନ୍‌ଦ ଆପେ କାପେ ରାଆଃକେଦାଃ । ଇନ୍‌କୁ ଏନ୍‌ଲେକାନ୍‌କ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ହଲଙ୍ଗ୍‌ କାଏ ଜମ୍‌କେଦାଃ ଆଡଃ ଦାଖ୍‌ରାସି କାଏ ନୁଁ କେଦାଃ, ଆଡଃ ଆପେ ‘ଇନିଃକେ ବଙ୍ଗା ଏସେର୍‌କିୟାଏ’ ମେନ୍ତେପେ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ମାନୱାହନ୍‌ ହିଜୁଃକେଦ୍‌ତେ ଜମ୍‌ ନୁଁ କେଦାଏ, ଆଡଃ ଆପେ ‘ଇନିଃକେ ଦାର୍‌ଧା ଆଡଃ ଦାଖ୍‌ରାସି ନୁଁ ହଡ଼ ତାନିଃ, ମାଲ୍‌ହାରମ୍‌କଆଃ ଆଡଃ ପାପିକଆଃ ଗାତି ତାନିଃ ମେତାଇତାନାପେ ।’ ");
INSERT INTO unx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସେଣାଁଁ, ଆୟାଃ ସବେନ୍‌ ହନ୍‌କଆଃ ହରାତେ ସାର୍‌ତି ତାନାଃ ମେନ୍ତେ ଉଦୁବ୍‌ୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ଫାରୁଶୀକଏତେ ମିଆଁଦ୍‌ ହଡ଼ ଆଇଁୟାଃଲଃ ଜମେମେ ମେନ୍ତେ ୟୀଶୁକେ ବିନ୍ତିକିୟାଏ, ଏନାତେ ୟୀଶୁ ଫାରୁଶୀଆଃ ଅଡ଼ାଃତେ ବଲୟାନ୍ତେ ଜଜମାଏ ଦୁବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ଆଡଃ ନେଲେପେ, ଏନ୍‌ ନାଗାର୍‌ରେନ୍‌ ମିଆଁଦ୍‌ ପାପିକୁଡ଼ି, ୟୀଶୁ ଫାରୁଶୀଆଃ ଅଡ଼ାଃରେ ଜମେ ନାଗେନ୍ତେ ଦୁବାକାନାଏ ମେନ୍ତେ ସାରିକେଦ୍‌ତେ ଇନିଃ ମିଆଁଦ୍‌ ପୁଣ୍ଡିଦିରିରାଃ ଚୁକାଃ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ ଆଉକେଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ଆଡଃ ୟୀଶୁଆଃ କାଟା ସୁବାରେ ଦୁବ୍‌କେଦ୍‌ତେ ରାଆଃ ତାନ୍‌ଲଃ ଆୟାଃ ମେଦ୍‌ଦାଃତେ ଇନିୟାଃ କାଟାକେ ଲୁମ୍‌କେଦାଏ ଆଡଃ ଆୟାଃ ବହଃରେୟାଃ ଉବ୍‌ତେ ଜଦ୍‌କେଦ୍‌ଲଃ ଇନିୟାଃ କାଟା ଚଅଃ କେଦ୍‌ତେ କାଟାରେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ତେ ଗସଃକିୟା । ");
INSERT INTO unx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ନେୟାଁ ନେଲ୍‌କେଦ୍‌ତେ ୟୀଶୁକେ କେଡ଼ାକାଇ ଫାରୁଶୀ ଆୟାଃ ମନ୍‌ରେ କାଜିକେଦାଏ, “ନିଃ ନାବୀ ତାନିଃରେଦ, ନେ ଜୁଟିଦିତାନ୍‌ କୁଡ଼ି ଅକଏ ଆଡଃ ଚିଲ୍‌କାନ୍‌ନିଃ ତାନିଃ ଏନା ସାରିଦାଡ଼ିତେୟାଃଏ, ଚିୟାଃଚି ଇନିଃଦ ପାପିନିଃତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ୟୀଶୁ ଶିମୋନ୍‌କେ କାଜିକିୟାଏ, “ଏ ଶିମୋନ୍‌ ଆମ୍‌କେ ହୁଡିଙ୍ଗ୍‌ଲେକା କାଜିସାନାଙ୍ଗ୍‌ ତାନାଇଙ୍ଗ୍‌ ।” ଇନିଃ କାଜିକିୟାଏ, “ହେ ଗୁରୁ ମାର୍‌ କାଜିଙ୍ଗ୍‌ମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“ଜେତାଏ ସାହୁକାର୍ ହଡ଼ଆଃ ବାର୍‌ହଡ଼୍‌ ରିଣୀ ସାବ୍‌ତାନ୍‌କିନ୍ ତାଇକେନା । ମିହୁଡ଼୍‌ ମଣେୟାଁ ହୁଲାଙ୍ଗ୍‌ରାଃ ନାଲା ସିକା ଆଡଃ ଏଟାଃନିଃ ବାର୍‌ହିସି ଗେଲେୟା ହୁଲାଙ୍ଗ୍‌ରାଃ ନାଲା ସିକା । ");
INSERT INTO unx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ହାଲ୍ ରୁହାଡ଼୍‌ଲାଇ ଇନ୍‌କିନ୍‌ତାଃ ଜେତ୍‌ନାଃ କା ତାଇକେନ୍‌ରେ ଇନିଃ ବାରାନ୍‌କିନାଃ ରିଣୀ ବାଗିତାଦାଏ । ଇନ୍‌କିନ୍‌ଏତେ ଅକଏ ଇନିଃକେ ପୁରାଃ ଦୁଲାଡ଼ିୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ଶିମୋନ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଁୟାଃ ବିଚାର୍‌ତେ ପୁରାଃରିଣୀ ବାଗିକିଃ ନିଃ ।” ୟୀଶୁ ଶିମୋନ୍‌କେ କାଜିକିୟାଏ, “ଆମ୍‌ ବୁଗିନାଃମ୍ କାଜିକାଦାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ଆଡଃ ୟୀଶୁ ଏନ୍‌ କୁଡ଼ିସାଃ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ଶିମୋନ୍‌କେ କାଜିକିୟାଏ, “ଚିନାଃ ଆମ୍‌ ନେ କୁଡ଼ିକେମ୍ ନେଲିତାନା ? ଆଇଙ୍ଗ୍‌ ଆମାଃ ଅଡ଼ାଃତେଇଙ୍ଗ୍‌ ହିଜୁଃୟାନା, ଆମ୍‌ କାଟା ଆବୁଙ୍ଗ୍‌ନାଙ୍ଗ୍‌ ଦାଆଃ କାଟିଃହ କାମ୍‌ ଏମାଦିୟାଁ, ମେନ୍‌ଦ ନେ କୁଡ଼ି ମେଦ୍‌ଦାଃତେ ଆଇଁୟାଃ କାଟା ଲୁମ୍‌କେଦାଏ ଆଡଃ ଆୟାଃ ବହଃରେୟାଃ ଉବ୍‌ତେ ଜଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ମିସାହ କାମ୍‌ ଚଅଃ'କିୟାଃଁ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ବଲୟାନ୍‌ ଇମ୍‌ତାଏତେ ନିଃ କାଟାତାଇୟାଁଃକେ ଚଅଃ'କାତେ ତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ଆମ୍‌ ଆଇଁୟାଃ ବହଃରେ ସୁନୁମ୍ କାମ୍‌ ଗସଃକେଦାଃ ମେନ୍‌ଦ ନିଃ କାଟାତାଇୟାଁଃରେ ସହାନ୍‌ ସୁନୁମ୍‌ ଗସଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ଏନାନାଗେନ୍ତେ କାଜିୟାମେ ତାନାଇଙ୍ଗ୍‌, ନିଃ ପୁରାଃ ଦୁଲାଡ଼୍‌କେନାଏ ମେନ୍ତେ ଇନିୟାଃ ପୁରାଃ ପାପ୍‌ ଛାମାକାନା । ମେନ୍‌ଦ ହୁଡିଙ୍ଗ୍‌ଲେକା ଛାମାଅଃନିଃ ହୁଡିଙ୍ଗ୍‌ଲେକା ଦୁଲାଡ଼ାଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ଏନ୍ତେ ୟୀଶୁ ଏନ୍‌ କୁଡ଼ିକେ କାଜିକିୟାଏ, “ଆମାଃ ପାପ୍‌ ସବେନ୍‌ ଛାମାୟାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ଆଡଃ ଇନିଃଲଃ ଜମ୍‌ତେ ଦୁବାକାନ୍‌ ହଡ଼କ ଆକ ଆକରେଗି କାଜି ଏଟେଦ୍‌କେଦାକ, “ଇଦୁ ନିଃ ଅକଏ ତାନିଃ ଯେ ପାପ୍‌କହଗି ଛାମାଏତାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ୟୀଶୁ ଏନ୍‌ କୁଡ଼ିକେ କାଜିକିୟାଏ “ଆମାଃ ବିଶ୍ୱାସ୍‌ ଆମ୍‌କେ ବାଞ୍ଚାଅ କାଦ୍‌ମେୟାଁଏ ଜୀଉ ସୁକୁତେ ସେନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ଏନ୍‌ ତାୟମ୍‌ତେ, ୟୀଶୁ ସାହାର୍‌ ସାହାର୍‌ ଆଡଃ ହାତୁ ହାତୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେୟାଃ ସୁକୁକାଜି ଉଦୁବ୍‌ତାନ୍‌ଲଃ ହନର୍‌ବାଡ଼ା ତାଇକେନାଏ ଆଡଃ ଗେଲ୍‌ବାର୍‌ ଚେଲାକ ଆୟାଃଲଃ ତାଇକେନାକ, ");
INSERT INTO unx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ଆଡଃ ଏତ୍‌କାନ୍‌ ଆତ୍ମାକଏତେ ଆଡଃ ହାସୁଇତେ ବୁଗିଆକାନ୍‌ ଚିମିନ୍‌ କୁଡ଼ିକ ୟୀଶୁଲଃ ତାଇକେନାକ, ଇନ୍‌କୁଇତେ ମାରିୟାମ୍‌, ଅକଏକେଚି ମାଗ୍‌ଦାଲିନି ମେତାଇ ତାଇକେନାକ, ଇନିଃଏତେଦ ସାତ୍‌ଠୁ ବଙ୍ଗାକକେ ହାର୍‌ଅଡଙ୍ଗ୍‌କାଦ୍‌ ତାଇକେନା; ");
INSERT INTO unx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ହେରୋଦ୍‌ଆଃ ଭାଣ୍ଡାରି ଖୁଜାରାଃ କୁଡ଼ିତେ ଯୋହାନ୍ନା, ଶୁସାନା ଆଡଃ ପୁରାଃ ଏଟାଃ କୁଡ଼ିକ ଆକଆଃ ମେନାଃତେୟାଃତେ ୟୀଶୁକେ ଆଡଃ ଆୟାଃ ଚେଲାକକେ ସୁସାରିତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ଗାଦେଲ୍‌ ହଡ଼କ ହୁଣ୍ଡିୟାକାନ୍ ଆଡଃ ସାହାର୍‌ ସାହାର୍‌ଏତେ ହଡ଼କ ୟୀଶୁତାଃକ ହିଜୁଃତାନ୍‌ ତାଇକେନ୍‌ରେ, ୟୀଶୁ ନେ ଜନ୍‌କା କାଜି କାଜିୟାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ମିଆଁଦ୍‌ ହିତାହେରଃନିଃ ହିତାହେରଃନାଙ୍ଗ୍‌ ଅଡଙ୍ଗ୍‌ୟାନା । ଇନିଃ ହେର୍‌ହେର୍‌ତାନ୍‌ଲଃ ଚିମିନ୍‌ ହିତା ହରା ଗେନାରେ ଉୟୁଃୟାନା ଆଡଃ ତିକାୟାନା, ଆଡଃ ସିର୍ମାରେନ୍‌ ଚେଣେଁକ ଏନାକେ ହାଲାଙ୍ଗ୍‌ ଜମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ଆଡଃ ଚିମିନ୍‌ ହିତା ଦିରି ଅତେରେ ଉୟୁଃୟାନା, ଏନା ଗାଜା ଅମନ୍‌ୟାନା, ମେନ୍‌ଦ ହାଲି କା ତାଇକେନ୍‌ତେ ରହଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ଚିମିନ୍‌ ହିତା ଜାନୁମ୍‌ ଥାଲାରେ ଉୟୁଃୟାନା ଆଡଃ ଏନାକେ ଜାନୁମ୍‌ ହାରାତପାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ଆଡଃ ଚିମିନ୍‌ ହିତା ବୁଗିନ୍‌ ଅତେରେ ଉୟୁଃୟାନା, ଏନା ଅମନ୍‌ ହାରାୟାନ୍ତେ ହେରାକାନ୍‌ଏତେ ସାଅଗୁନା ଆଦ୍‌କା ଜ'ୟାନା । ନେ କାଜି କାଜିକେଦ୍‌ଚି ଇନିଃ କାଉରିକେଦାଏ, “ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଲୁତୁର୍ ମେନାଃନିଃ ଆୟୁମେକାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ଏନ୍ତେ ଇନିୟାଃ ଚେଲାକ ନେ ଜନ୍‌କା କାଜିରେୟାଃ ମୁଣ୍ଡି ଚିନାଃତାନାଃ ମେନ୍ତେକ କୁଲିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ଇନିଃ କାଜିୟାଦ୍‌କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେୟାଃ ମୁଣ୍ଡି ସାରିରେୟାଃ ପେଡ଼େଃ ଆପେଦପେ ନାମାକାଦାଃ ମେନ୍‌ଦ ଏଟାଃକକେ ଜନ୍‌କା କାଜିତେ ସବେନାଃ ଉଦୁବଃତାନା । ଇନ୍‌କୁ ନେଲ୍‌ଦକ ନେଲେୟାଃ, ମେନ୍‌ଦ କାକ ନେଲ୍‌ ଉରୁମେୟାଃ, ଇନ୍‌କୁ ଆୟୁମ୍‌ଦକ ଆୟୁମେୟାଃ, ମେନ୍‌ଦ କାକ ଆଟ୍‌କାର୍ ଉରୁମେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“ନେ ଜନ୍‌କା କାଜିରେୟାଃ ମୁଣ୍ଡି ନେଆଁଁତାନାଃ, ହିତା ହବାଅଃତାନା ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି । ");
INSERT INTO unx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ଆଡଃ ହରା ଗେନାରେ ଉୟୁଗାକାନ୍‌ ହିତା ଇନ୍‌କୁତାନ୍‌କ, ଅକନ୍‌କଚି ଆୟୁମାଃକ, ଏନ୍ତେ ସାଏତାନ୍‌ ହିଜୁଃଆଏ ଆଡଃ ଇନ୍‌କୁ ବିଶ୍ୱାସ୍‌କେଦ୍‌ତେ ଆଲକାକ ବାଞ୍ଚାଅଃକା ମେନ୍ତେ ଇନ୍‌କୁଆଃ ମନ୍‌ଏତେ କାଜି ରେଃକ୍‌ ଇଦିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ଦିରି ଅତେରେ ଉୟୁଗାକାନ୍‌ ହିତା ଇନ୍‌କୁତାନ୍‌କ, ଅକନ୍‌କଚି କାଜି ଆୟୁମ୍‌ତର୍‌ସା ରାସ୍‌କାତେ ତେଲାୟାକ, ମେନ୍‌ଦ ରେହେଦ୍‌ କା ତାଇନ୍‌ ହରାତେ ଇନ୍‌କୁ ହୁଡିଙ୍ଗ୍‌ ସାମାଏ ଜାକେଦ୍‌କ ବିଶ୍ୱାସେୟାଃ, ମେନ୍‌ଦ ବିଡ଼ାଅ ନେଡାରେକ ବାଗିୟା । ");
INSERT INTO unx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ଆଡଃ ଜାନୁମ୍‌ ଥାଲାରେ ଉୟୁଗାକାନ୍‌ ହିତା ଇନ୍‌କୁତାନ୍‌କ, ଅକନ୍‌କଚି ଇନ୍‌କୁ କାଜି ଆୟୁମାଃକ, ମେନ୍‌ଦ ଜୀଉରେୟାଃ ଉଡ଼ୁଃତେ, ପୁରାଃ ମେନାଃତେୟାଃତେ, ଆଡଃ ଜୀନିଦ୍‌ରେୟାଃ ସୁକୁ ରାସ୍‌କାତେକ ତପା ଇଦିୟଃଆ ଆଡଃ ଜାଙ୍ଗ୍‌ୟାଁନ୍‌ ଜ କାକ ଜ'ଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ମେନ୍‌ଦ ବୁଗିନ୍‌ ଅତେରେ ଉୟୁଗାକାନ୍‌ ହିତା ଇନ୍‌କୁତାନ୍‌କ, ଅକନ୍‌କଚି ବୁଗିନ୍‌ ଆଡଃ ଫାର୍‌ଚି ମନ୍‌ରେ ବାଚାନ୍‌କେ ଆୟୁମ୍‌କେଦ୍‌ତେକ ତେଲାଦହୟା ଆଡଃ ସାହାତିଙ୍ଗ୍‌ତାନ୍‌ଲଃକ ଜ'ଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ଜେତାଏ ହଡ଼ ଦିମି ଜୁଲ୍‌କେଦ୍‌ତେ ତାୱାତେ କାଏ ହାରୁବେୟା, ଚାଏ ପାର୍‌କମ୍‌ ଲାତାର୍‌ରେ କାଏ ଦହୟାଃ, ମେନ୍‌ଦ ବଲତାନ୍‌ ହଡ଼କ ମାର୍ସାଲ୍‌କ ନେଲେକା ମେନ୍ତେ ଦିର୍କାରେ ଦହୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“ଚିୟାଃଚି ସବେନ୍‌ ଉକୁଆକାନ୍‌ତେୟାଃ ଉଦୁବଃଆ ଆଡଃ ସବେନ୍‌ ଦାନାଙ୍ଗ୍‌ଆଁକାନ୍‌ତେୟାଃ ସାରିଅଃଆ ଚାଏ ମାସ୍କାଲ୍‌ତେ ଆଉଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“ଏନାମେନ୍ତେ, ଚିଲ୍‌କାପେ ଆୟୁମେୟାଃ ଏନା ଚିର୍ଗାଲାକାନ୍‌ପେ, ଚିୟାଃଚି ଅକଏତାଃ ମେନାଃ ଇନିଃକେ ଦ ଆଡଃଗି ଏମଃଆ, ଆଡଃ ଜେତାଏତାଃରେ ବାନଃଆ, ଇନିଃତାଃଏତେ ଅକ୍‌ନାଃ ମେନାଃ ଏନାହଗି ଇଦିୟଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ୟୀଶୁଆଃ ଏଙ୍ଗାତେ ଆଡଃ ହାଗାତେ ତେକ ଇନିଃତାଃ ହିଜୁଃୟାନାକ ମେନ୍‌ଦ ଗାଦେଲ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ଇନିଃତାଃ କାକ ସେଟେର୍‌ ଦାଡ଼ିୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ଜେତାଏ ମିହୁଡ଼୍‌ ୟୀଶୁକେ ଉଦୁବ୍‌କିୟାଏ, “ଆମାଃ ଏଙ୍ଗାମ୍‌ ଆଡଃ ହାଗାମ୍‌ତେକ ବାହାରିରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ଆମ୍‌ଲଃ ନେପେଲ୍‌ ନାଙ୍ଗ୍‌କ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ଇନିଃ ମେନ୍‌ରୁହାଡ଼ାଦ୍‌କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି ଆୟୁମ୍‌ ଆଡଃ ମାନାତିଙ୍ଗ୍‌ ତାନ୍‌କଗି ଆଇଁୟାଃ ଏଙ୍ଗା ଆଡଃ ହାଗାକ ତାନ୍‌କ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ମୁସିଙ୍ଗ୍‌ ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ଲାଉକାରେକ ଦେଏଃୟାନା ଆଡଃ “ଦଲାବୁ ଦରେୟା ହାନ୍‌ ପାରମ୍‌ତେବୁଆ” ମେତାଦ୍‌କଆଏ । ଆଡଃ ଇନ୍‌କୁ ଲାଉକା ରାଡ଼ାକେଦାଃକ ");
INSERT INTO unx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ଇନ୍‌କୁ ସେନଃତାନ୍‌ ଇମ୍‌ତା ୟୀଶୁଦ ଦୁଡ଼ୁମ୍‌ୟାନାଏ । ଇମ୍‌ତାଙ୍ଗ୍‌ ଦରେୟାରେ ଦୁଦୁଗାର୍‌ହୟ ବିରିଦ୍‌ୟାନା, ଏନ୍ତେ ଲାଉକାରେ ଦାଆଃ ପେରେଜଃତାନ୍‌ ତାଇକେନା, ଆଡଃ ଇନ୍‌କୁଦ ଡୁବିଜଃଲେକାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ଚେଲାକ ଇନିଃତାଃତେ ହିଜୁଃୟାନ୍‌ତେକ ବିରିଦ୍‌କିୟା, “ହେ ଗୁରୁ, ହେ ଗୁରୁ, ଆଲେ ଡୁବିଃଗ୍‌ ଗଜଃତାନାଲେ” ମେନ୍ତେକ କାଜିକିୟାଃ । ଏନ୍ତେ ଇନିଃ ବିରିଦ୍‌ୟାନ୍ତେ ହୟ ଆଡଃ ଆଲ୍‌ପୁଙ୍ଗ୍‌କେ ମାରାଙ୍ଗ୍‌ମଚାକେଦାଃ, ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ସବେନାଃ ହାପାଉତାର୍‌ୟାନା ଆଡଃ ସିଃସଏଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ଏନ୍ତେ ୟୀଶୁ ଚେଲାକକେ ମେତାଦ୍‌କଆଏ, “ଅକ୍‌ତାଃରେୟା ଆପେୟାଃ ବିଶ୍ୱାସ୍‌ ?” ମେନ୍‌ଦ ଇନ୍‌କୁ ବରତାନ୍‌ଲଃ ମେପେନ୍‌ୟାନାକ, “ନିଃ ଅକଏ ତାନିଃ, ହୟ ଆଡଃ ଦରେୟାରେୟାଃ ଦାଆଃକହ ନିୟାଃ କାଜି ମାନାତିଙ୍ଗ୍‌ ତାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ୟୀଶୁ ଆଡଃ ଚେଲାତାୟାଃକ ଗେରାସିମିକଆଃ ପାର୍‌ଗାନ୍‌ତେ ସେଟେର୍‌ୟାନାକ, ଏନା ଗାଲିଲ୍‌ ଦରେୟାରାଃ ହାନ୍‌ ପାରମ୍‌ରେୟା । ");
INSERT INTO unx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ୟୀଶୁ ଡଙ୍ଗାଏତେ ଦରେୟା ଗେନାରେ ଆଡ଼୍‌ଗୁତର୍‌ସା, ଏନ୍‌ ନାଗାର୍‌ରେନ୍ ମିହୁଡ଼୍‌ ଏତ୍‌କାନ୍‌ ଆତ୍ମାଏତେ ପେରେଜାକାନ୍‌ ହଡ଼ ୟୀଶୁଲଃ ନାପାମ୍‌ୟାନାକିନ୍, ଇନିଃ ପୁରାଃ ମାହାଁଏତେ ଲିଜାଃ କାଏ ତୁସିଙ୍ଗ୍‌ଅଁତାନ୍‌ ତାଇକେନା ଚାଏ ଅଡ଼ାଃରେ କା ତାଇନ୍‌କେଦ୍‌ତେ ହଡ଼ ତପା ଠାୟାଦ୍‌ରେ ତାୟୁଃତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ଇନିଃ ୟୀଶୁକେ ନେଲ୍‌ତାନ୍‌ଚି ଆୟାଃ କାଟାସୁବାରେ ଉୟୁଃକେଦ୍‌ତେ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ହେ ୟୀଶୁ ସାଲାଙ୍ଗିଉତାର୍ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌, ଆଇଙ୍ଗ୍‌ଲଃ ଆମାଃ ଚିକାନ୍‌ କାମି ମେନାଃ ? ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ଜହାର୍ ମେଁ ତାନାଇଙ୍ଗ୍‌ ଆଲମ୍‌ ଦୁକୁଇୟାଁଃ !” ");
INSERT INTO unx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ଇନିଃ ଏନା କାଜିକେଦାଏ ଚିୟାଃଚି ୟୀଶୁ ଏନ୍‌ ସତ୍‌ରା ଆତ୍ମାକେ ନେ ହଡ଼ଏତେ ଅଡଙ୍ଗ୍‌ଅଃମେ ମେନ୍ତେ ଆଚୁକାଇତାଇନାଏ । ଏତ୍‌କାନ୍‌ ଆତ୍ମା ହଡ଼କେ ପୁରାଃ ମାହାଁଏତେ ସାବାକାଇତାଇନାଏ । ଆଡଃ ହଡ଼କ ଇନିଃକେ ସିକ୍‌ଡ଼ିଲଃ ଆଡଃ ବେଢ଼ିରେ ତଲ୍‌କିଃତେ ହରଇତାନ୍‌କ ତାଇକେନା, ମେନ୍‌ଦ ଇନିଃ ତନଲ୍‌କେ ଟଟାଃଏତାନ୍‌ ଆଡଃ ଏତ୍‌କାନ୍‌ ଆତ୍ମା ଇନିଃକେ ବିର୍‌ତେ ହାର୍‌ଇଦିତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ୟୀଶୁ ଇନିଃକେ କୁଲିକିୟାଏ “ଆମାଃ ନୁତୁମ୍‌ ଚିକ୍‌ନାଃ ?” ଇନିଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଁୟାଃ ନୁତୁମ୍‌ ଫାଉଦ୍,” ଚିୟାଃଚି ଇନିଃରେ ପୁରାଃଗି ବଙ୍ଗାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ଆଡଃ ଇନ୍‌କୁ ୟୀଶୁକେ “ଆଲେକେ ହୁଆଙ୍ଗ୍‌ଗାଡ଼ାତେ ଆଲମ୍‌ କୁଲ୍‌ଲେ” ମେନ୍ତେ ପୁରାଃଗିକ ବିନ୍ତିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ବୁରୁଗେନା ଜାପାଃରେ ସୁକୁରିକଆଃ ମାରାଙ୍ଗ୍‌ ଗୋଟ୍‌ ଆତିଙ୍ଗ୍‌ତାଇକେନାକ । ଏତ୍‌କାନ୍‌ ଆତ୍ମାକ ୟୀଶୁକେ, ଆଲେକେ ଏନ୍‌ ସୁକୁରିକରେ ବଲଃ ନାଗେନ୍ତେ କୁଲ୍‌ତାଲେମେ ମେନ୍ତେକ ବିନ୍ତିକିୟାଃ, ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ବଲରିକାକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ଏତ୍‌କାନ୍‌ ଆତ୍ମାକ ଏନ୍‌ ହଡ଼ଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ସୁକୁରିକରେକ ବଲୟାନା ଆଡଃ ସୁକୁରିକଆଃ ଗୋଟ୍‌ ଦରେୟାରେକ ନିର୍‌ବଲୟାନା ଆଡଃ ଡୁବିଃଗ୍‌ ଗଏଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ସୁକୁରି ଗୁପିତାନ୍‌କ ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ନିର୍‌ୟାନାକ ଆଡଃ ସାହାର୍ ଜାପାଃରାଃ ଟଲାକରେ ନେ କାଜିକ ଉଦୁବ୍‌ ବାଡ଼ାକେଦାଃ, ");
INSERT INTO unx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ଆଡଃ ହଡ଼କ ହବାଲେନ୍‌ତେୟାଃ ନେଲ୍‌ନାଗେନ୍ତେ ଅଡଙ୍ଗ୍‌ୟାନାକ ଆଡଃ ୟୀଶୁତାଃକ ହିଜୁଃୟାନ୍ତେ ଏତ୍‌କାନ୍‌ ଆତ୍ମାକଆଃ ଫାଉଦ୍‌ତେ ଏସେରାକାନ୍‌ ହଡ଼କେ ୟୀଶୁଆଃ କାଟାସୁବାରେ ଦୁବାକାନ୍‌, ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍‌ ନେଲ୍‌କିଃତେ ବରକେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ନେ ସବେନାଃ ନେଲାକାଦ୍ ହଡ଼କ ବଙ୍ଗା ଏସେର୍‌କାନ୍‌ ଏନ୍‌ ହଡ଼ ଚିଲ୍‌କା ବୁଗିୟାନାଏ, ଏନା ସବେନ୍‌ ହଡ଼କକେ ଉଦୁବାଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ଏନ୍ତେ ଗେରାସିମି ହପର୍‌ଜାପାଃରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ଆଲେୟାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ଏତେ ସେନଃମେ ମେନ୍ତେ ୟୀଶୁକେକ ବିନ୍ତିକିୟା, ଚିୟାଃଚି ଇନ୍‌କୁ ବରତାଇକେନାକ । ଆଡଃ ୟୀଶୁ ଲାଉକାରେ ଦେଏଃୟାନ୍ତେ ରୁହାଡ଼୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ଏତ୍‌କାନ୍‌ ଆତ୍ମାଏତେ ବୁଗିୟାକାନ୍ ହଡ଼ ୟୀଶୁକେ କାଜିକିୟାଏ, “ଆମାଃଲଃ ତାଇନ୍‌ ଚିକାଆଇଙ୍ଗ୍‌ମେଁ” ମେନ୍ତେ ବିନ୍ତିକିୟାଏ, ମେନ୍‌ଦ ୟୀଶୁ ଆଇଃକ୍‌କେ ବିଦା ଏମ୍‌ତାନ୍‌ଲଃ କାଜିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ଆମ୍‌ ଆମାଃ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ମେଁ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆମାଃ ନାଗେନ୍ତେ ଚିକ୍‌ନାଃ ରିକାକାଦାୟ, ଚିଲ୍‌କା ଆମ୍‌କେ ଦାୟାକାଦ୍‌ମେୟା ଏନା ସବେନ୍‌କକେ ଉଦୁବାକମେ ।” ଏନ୍ତେଦ ଏନ୍‌ ହଡ଼ ରୁହାଡ଼୍‌ୟାନାଏ, ଆଡଃ ୟୀଶୁ ଆୟାଃ ନାଗେନ୍ତେ ନେ'ଲେକାନ୍‌ ମାରାଙ୍ଗ୍‌ କାମି କାମିୟାଁଦିୟାଁଏ ମେନ୍ତେ ସବେନ୍‌ ନାଗାର୍‌ରେ ଉଦୁବ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ୟୀଶୁ ଦରେୟା ହାନ୍‌ପାରମ୍‌ତେ ରୁହାଡ଼୍‌ୟାନ୍‌ ଇମ୍‌ତା ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେ ଦାରମ୍‌କିୟାଃକ, ଚିୟାଃଚି ସବେନ୍‌କଦ ଇନିଃକେ ନେଲ୍‌ହରାଇତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ଆଡଃ ନେଲେପେ, ଯାଇରସ ନୁତୁମ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃରେନ୍‌ ଆଗୁଆଇ ହିଜୁଃୟାନାଏ, ଆଡଃ ୟୀଶୁଆଃ କାଟା ସୁବାରେ ଉୟୁଃକେଦ୍‌ତେ ଆଇଁୟାଃ ଅଡ଼ାଃତେ ହିଜୁଃମେ ମେନ୍ତେ ବିନ୍ତିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ଚିୟାଃଚି ଆୟାଃ ବାରା ବାରାଷ୍‌ରେନ୍‌ ମିଆଁଦ୍‌ଗି ହନ୍‌କୁଡ଼ି ତାଇକେନାଏ, ଇନିଃ ଦୁକୁତେ ଗଜଃଲେକା କାନାଏ ତାଇକେନା । ମେନ୍‌ଦ ୟୀଶୁ ସେସେନ୍‌ତାନ୍ ଦିପିଲିରେ ଗାଦେଲ୍‌ ହଡ଼କ ଇପ୍‌ଲିଙ୍ଗ୍‌ଅଃ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ଇମ୍‌ତା ବାରା ବାରାଷ୍‌ଏତେ ମାୟୋମ୍‌ଲିଙ୍ଗି ଦୁକୁରେ ଦୁକୁତାନ୍‌ ମିଆଁଦ୍‌ କୁଡ଼ି ତାଇକେନାଏ, ମେନ୍‌ଦ ଇନିଃ ଆୟାଃ ସବେନ୍‌ ତାଇକେନ୍‌ତେୟାଃ ବାଇଦ୍‌କତାଃରେ ଚାବାକେଦ୍‌ରେୟ ଇନିଃକେ ଜେତାଏ ହ କାକ ବୁଗି ଦାଡ଼ି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ଇନିଃ ଦୟାହରା ୟୀଶୁତାଃ ସେନ୍‌କେଦ୍‌ତେ ଲିଜାଃରାଃ ଆଚ୍‌ରା ଜୁଟିଦ୍‌କେଦାଏ, ଆଡଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ମାୟୋମ୍‌ ଲିଙ୍ଗି ଦୁକୁଏତେ ବୁଗିୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ଏନ୍ତେ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଅକଏ ଆଇଙ୍ଗ୍‌କେ ଜୁଟିଦ୍‌କିଦିୟାଏଁ ?” ସବେନ୍‌କ କା ମାନାତିଙ୍ଗ୍‌ ତାନ୍‌ତେ, ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ “ହେ ଗମ୍‌କେ, ଗାଦେଲ୍‌ ହଡ଼କ ଇପ୍‌ଲିଙ୍ଗ୍‌କେଦ୍‌ତେ ଆମାଃ ଚେତାନ୍‌ରେ ଉୟୁଗଃତାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ୟୀଶୁ କାଜିକେଦ୍‌କଆଏ, “ଅକଏ ମିହୁଡ଼୍‌ ଆଇଙ୍ଗ୍‌କେ ଜୁଟିଦ୍ କେଦିଙ୍ଗ୍‌ଆଏ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ତାଃଏତେ ପେଡ଼େଃ ଅଡଙ୍ଗ୍‌ୟାନା ମେନ୍ତେ ସାରିଉରୁମ୍‌ କେଦାଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ଆଡଃ ଏନ୍‌କୁଡ଼ି କାଏ ଉକୁଦାଡ଼ିୟାନା ମେନ୍ତେ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ଇନିଃ ବରତେ ଏକ୍‌ଲାଅଃତାନ୍‌ଲଃ ହିଜୁଃୟାନାଏ ଆଡଃ ୟୀଶୁଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ସବେନ୍‌କଆଃ ଆୟାର୍‌ରେ, ଚିନାଃମେନ୍ତେଇଙ୍ଗ୍‌ ଜୁଟିଦ୍‌କେଦ୍‌ମେୟାଁ ଆଡଃ ଇମ୍‌ତାଗି ଚିଲ୍‌କାଇଙ୍ଗ୍‌ ବୁଗିୟାନା ମେନ୍ତେ ଉଦୁବ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ଏନ୍ତେ ୟୀଶୁ କାଜିକିୟାଏ, “ଏ ମାଈ, ବିଶ୍ୱାସ୍‌ ତାମାଃ ବୁଗିୟାକାଦ୍‌ମେଁୟାଏ, ଜୁ ସୁକୁ ଜୀଉତେ ସେନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ୟୀଶୁ ଏନା କାଜିତାନ୍‌ ଇମ୍‌ତାଗି, ସାମାଜ୍‌ ଅଡ଼ାଃ ଚାଲାଅନିୟାଃ ଅଡ଼ାଃଏତେ କାଜି ଆଉୱାକାଦ୍‌ ହଡ଼ ଯାଇରସକେ କାଜିକିୟାଏ, “ହନ୍‌ମେକୁଡ଼ି ଗଏଃୟାନାଏ, ଗୁରୁକେ ଆଡଃ ଆଲ୍‌ମେ ଦୁକୁଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ୟୀଶୁ ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଯାଇରସକେ କାଜିକିୟାଏ, “ଆଲମ୍‌ ବରଏୟା, ବିଶ୍ୱାସ୍‌ରେଗି ତାଇନଃମେ, ଆଡଃ ଇନିଃ ବାଞ୍ଚାଅଃଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ଏନ୍ତେ ୟୀଶୁ ଯାଇରସରାଃ ଅଡ଼ାଃତେ ହିଜୁଃୟାନ୍‌ଚି, ପାତ୍‌ରାସ୍‌, ଯାକୁବ୍‌, ଆଡଃ ଆୟାଃ ହାଗାତେ ଯୋହାନ୍‌ ଆଡଃ କୁଡ଼ିହନ୍‌ଆଃ ଏଙ୍ଗା ଆପୁକିନ୍‌କେ ବାଗିକେଦ୍‌ତେ ଜେତାଏକକେ କାଏ ବଲରିକାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ମେନ୍‌ଦ ଏନ୍‌ କୁଡ଼ିହନ୍ ନାଗେନ୍ତେ ସବେନ୍‌କ ରାଆଃତାନ୍ ଆଡଃ କୁଡ଼ାମ୍‌କରେ ତିଃଇ ଥାପ୍‌ଡ଼ିଅଃତାଇକେନାକ । ଏନ୍ତେ ୟୀଶୁ କାଜିକେଦ୍‌କଆଏ, ଆଲ୍‌ପେ ରାଆଃଏୟା ଇନିଃ କାଏ ଗଜାକାନା ମେନ୍‌ଦ ଦୁଡ଼ୁମ୍‌ତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ଇନ୍‌କୁ ୟୀଶୁକେ ଲାନ୍ଦାକିୟାଃକ ଚିୟାଃଚି ଏନ୍‌ କୁଡ଼ିହନ୍ ଗଜାକାନାଏ ମେନ୍ତେ ଇନ୍‌କୁ ସାରିତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ୟୀଶୁ ଏନ୍‌ କୁଡ଼ିହନ୍‌ଆଃ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ କାଜିକିୟାଏ, “ଏ ମାଈ ବିରିଦ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ଏନ୍‌ କୁଡ଼ିହନ୍‌ଆଃ ଜୀଉ ଇମ୍‌ତାଗି ରୁହାଡ଼୍‌ୟାନା, ଇନିଃ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ଇନିଃକେ ଜାହାନାଃ ଜମେୟାଃଁ ଏମାଇପେ ମେନ୍ତେ ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","କୁଡ଼ିହନ୍‌ଆଃ ଏଙ୍ଗା ଆପୁ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକିନ୍ ମେନ୍‌ଦ ନେ କାଜି ଜେତାଏତାଃରେ ଆଲ୍‌ପେ ଉଦୁବେୟା ମେନ୍ତେ ୟୀଶୁ କାଜିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ଏନ୍ତେ ୟୀଶୁ ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ କେଡ଼ାହୁଣ୍ଡିକେଦ୍‌କଆଏ, ସବେନ୍‌ ବଙ୍ଗାକକେ ହାର୍‌ଅଡଙ୍ଗ୍‌ନାଙ୍ଗ୍‌, ଆଡଃ ଦୁକୁ ଗେରାଙ୍ଗ୍‌ ଏତେ ବୁଗିକନାଙ୍ଗ୍‌ ମେନ୍ତେ ପେଡ଼େଃ ଆଡଃ ଆକ୍‌ତେୟାର୍‌ ଏମାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେୟାଃ କାଜି ଉଦୁବଃ ନାଗେନ୍ତେ, ଦୁକୁହାସୁତାନ୍‌କକେ ବୁଗିକ ନାଗେନ୍ତେ କୁଲ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେୟାଃ ହରାସେନ୍‌ ନାଗେନ୍ତେ ସଟା ଚାଏ ଥାଇଲା, ହଲଙ୍ଗ୍‌ ଚାଏ ଟାକାପାଏସା, ଚାଏ ବାରିଆ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃ ହଁ ଆଲ୍‌ପେ ଇଦିୟା । ");
INSERT INTO unx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ଜେତା ଅଡ଼ାଃରେ ଦାରମ୍‌ପେରେ, ଏନ୍‌ ଜାପାଃଏତେ ଆଉରି ଅଡଙ୍ଗ୍‌ଅଃ ଜାକେଦ୍‌ ଏନ୍‌ ଅଡ଼ାଃରେଗି ତାଇନଃପେ । ");
INSERT INTO unx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ଜେତାଏ ଆପେକେ କାକ ଦାରମ୍‌ପେରେଦ ଏନ୍‌ ହାତୁଏତେ ଅଡଙ୍ଗ୍‌ ଇମ୍‌ତାଙ୍ଗ୍‌ ଆପେୟାଃ କାଟା ତାଲ୍‌କାରେୟାଃ ଧୁଡ଼ି ଗାୱା ନାଗେନ୍ତେ କଟା ବାଗିତାପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ଏନାରେ ଇନ୍‌କୁ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ସବେନ୍‌ସାଃ ସୁକୁକାଜି ଉଦୁବ୍‌ତାନ୍‌ଲଃ ଆଡଃ ହଡ଼କକେ ବୁଗିକ ତାନ୍‌ଲଃ ହାତୁ ହାତୁକ ହନର୍‌ବାଡ଼ାକେଦା । ");
INSERT INTO unx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଆଡଃ ଗାଲିଲ୍‌ରେନ୍‌ ରାଜା ହେରୋଦ୍ ୟୀଶୁଆଃ କାମିକାଦ୍ ସବେନାଃ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆକ୍‌ଚାକାଅୟାନାଏ, ଚିୟାଃଚି ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ଗଜାକାନ୍‌ଏତେ ଜୀଉବିରିଦାକାନାଏ ମେନ୍ତେ ଚିମିନ୍‌ ହଡ଼କ ମେନ୍‌କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ଆଡଃ ଚିମିନ୍‌ ହଡ଼କ ଏଲିୟ ଉଦୁବାକାନାଏ, ଆଡଃ ଏଟାଃକ ସିଦାରେନ୍ ନାବୀକଏତେ ମିଆଁଦ୍‌ନିଃ ଜୀଉବିରିଦାକାନାଏ ମେନ୍‌କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ମେନ୍‌ଦ ହେରୋଦ୍‌ କାଜିକେଦାଏ, ବାନଃଗି ଯୋହାନ୍‌ଆଃ ବହଃ ଆଇଙ୍ଗ୍‌ ମାଆଃ ରିକାକାଦା ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଇନିୟାଃ ନାଗେନ୍ତେ ନେ ଲେକା କାଜିଇଙ୍ଗ୍‌ ଆୟୁମ୍‌ତାନା ନେ ହଡ଼ ଅକଏ ତାନିଃ ମେନ୍‌କେଦାଏ, ଆଡଃ ଇନିଃ ନେଲ୍‌ସାନାଙ୍ଗ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ଏନ୍ତେ ପ୍ରେରିତ୍‌କ ହିଜୁଃରୁହାଡ଼୍‌ୟାନା, ଆଡଃ ଆକ କାମିକାଦ୍ ସବେନାଃ ୟୀଶୁକେକ ଉଦୁବ୍‌କିୟା । ଆଡଃ ଇନ୍‌କୁକେ ଏସ୍‌କାର୍‌ରେ ଇଦିକେଦ୍‌କତେ ବେଥ୍‌ସାଇଦା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସାହାର୍‌ତେୟାଏ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ମେନ୍‌ଦ ଗାଦେଲ୍‌ ହଡ଼କ ନେଆଁଁ ସାରିକେଦ୍‌ତେ ଅତଙ୍ଗ୍‌କିୟାକ, ଇନିଃ ଇନ୍‌କୁକେ ଦାରମ୍‌କେଦ୍‌କଆଏ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେୟାଃ କାଜି ଉଦୁବାଦ୍‌କଆଏ ଆଡଃ ବୁଗିୟଃଲାଗାତିଙ୍ଗ୍‌ତାନ୍‌ ତାଇକେନ୍‌କକେ ବୁଗିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ଆଡଃ ସିଙ୍ଗି ହାସୁରଃତାନ୍‌ରେ ଗେଲ୍‌ବାର୍‌ ଚେଲାକ ହିଜୁଃୟାନ୍ତେ କାଜିକିୟାକ, “ଏନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କକେ କୁଲ୍‌ରୁହାଡ଼୍‌କମ୍, ଜେ'ଲେକାଚି ଇନ୍‌କୁ ଚାରିୟସାଃରେୟାଃ ହାତୁ ଟଲା ସେନ୍‌କେଦ୍‌ତେ ଜମେୟାଃଁ ଆଡଃ ତାଇନଃ ଠାୟାଦ୍‌କ ନାମ୍‌ ଦାଡ଼ିୟା । ଚିୟାଃଚି ଆବୁଦ ସିଃସଏଃ ଠାୟାଦ୍‌ରେବୁଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆପେଗି ଇନ୍‌କୁକେ ଜମେୟାଃଁ ଏମାକପେ ।” ଆଡଃ ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଆଲେ ସେନ୍‌କେଦ୍‌ତେ ନେ ସବେନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ଜମେୟାଃଁ କାଲେ କିରିଙ୍ଗ୍‌ୟେଁରେଦ, ଆଲେତାଃରେ ମଣେୟାଁ ହଲଙ୍ଗ୍‌ ଆଡଃ ବାରିଆ ହାକୁ ଏସ୍‌କାର୍‌ ମେନାକଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ଇନ୍‌କୁ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ଲେକା କଡ଼ାକ ତାଇକେନା । ମେନ୍‌ଦ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ମେତାଦ୍‌କଆଏ, “ପାଚାଶ୍ ପାଚାଶ୍ ଝାନ୍‌ଲେକା ପାନ୍ତି ପାନ୍ତି ଦୁବ୍‌କପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ଏନ୍ତେ ଇନ୍‌କୁ ଏନ୍‌ଲେକାଗି ସବେନ୍‌କକେ ଦୁବ୍‌କେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ଇନିଃ ଏନ୍‌ ମଣେୟାଁ ହଲଙ୍ଗ୍‌ ଆଡଃ ବାରିଆ ହାକୁ ସାବ୍‌କେଦ୍‌ତେ ସିର୍ମାସାଃ ସାଙ୍ଗିଲ୍‌ରାକାବ୍‌ତାନ୍‌ଲଃ ଆଶିଷ୍‌କେଦ୍‌ତେ କେଚାଃକେଦାଏ, ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କତାଃରେ ହାଟିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଚେଲାକକେ ଏମାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ସବେନ୍‌କ ଜମ୍‌କେଦ୍‌ତେ ବି'ୟାନାକ ଆଡଃ ସାରେୟାକାନ୍ କେଚାଃ ବାରା ଟୁଙ୍କିକ ହାଲାଙ୍ଗ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ମିସା ୟୀଶୁ ଏସ୍‌କାର୍‌ରେ ବିନ୍ତିତାନ୍ ତାଇକେନ୍‌ ଇମ୍‌ତା ଚେଲାକ ଇନିଃଲଃକ ତାଇକେନା ଆଡଃ ଇନିଃ ଚେଲାକକେ କୁଲିକେଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ଅକଏ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେ ହଡ଼କ କାଜିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ଏନ୍ତେଦ ଇନ୍‌କୁ କାଜିକିୟାଃକ, “ଚିମିନ୍‌କ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌, ଚିମିନ୍‌କ ଏଲିୟ, ଚିମିନ୍‌କ ସିଦାରେନ୍ ନାବୀକଏତେ ମିହୁଡ଼୍‌ ଜୀଉ ବିରିଦାକାନାଏ ମେନ୍ତେକ କାଜିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ୟୀଶୁ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ଅକଏ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେପେ କାଜିତାନା ?” ପାତ୍‌ରାସ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଖ୍ରୀଷ୍ଟ୍‌ ତାନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ଏନ୍ତେ ୟୀଶୁ ନେ କାଜି ଜେତାଏକେ ଆଲ୍‌ପେ ଉଦୁବାକଆ ମେନ୍ତେ ହୁକୁମ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌କେ ପୁରାଃ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ ଲାଗାତିୟାଃଁ, ଆଡଃ ପ୍ରାଚିନ୍‌କ, ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଆଇଙ୍ଗ୍‌କେ ହିଲାଙ୍ଗ୍‌ଇଁୟା ଆଡଃ ଗଜିୟାଁ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପି ମାହାଁ ତାୟମ୍‌ତେ ଜୀଉ ବିରିଦାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ୟୀଶୁ ସବେନ୍‌କକେ କାଜିକେଦ୍‌କଆଏ, ଜେତାଏ ହଡ଼ ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଇନିଃ ଆୟାଃ ମନେ ବାଗିତାକାଏ ଆଡଃ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆୟାଃ କ୍ରୁଶ୍ ଗଅଃକେଦ୍‌ତେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌କାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ଜେତାଏ ଆୟାଃ ଜୀଉ ବାଞ୍ଚାଅ ସାନାଙ୍ଗ୍‌ରେଦ, ଏନାଏ ଆଦେୟା, ମେନ୍‌ଦ ଆୟାଃ ଜୀଉ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଆଦେନିଃ ଏନାଏ ବାଞ୍ଚାଅୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ଜେତାଏ ହଡ଼ ଗଟା ଅତେଦିଶୁମ୍‌ ନାମ୍‌କେଦ୍‌ରେୟ ଆୟାଃ ଜୀଉକେ ଜିୟନେରେଦ ଇନିୟାଃ ଚିକାନ୍‌ ଫାଏଦା ହବାଅଆଃ ? ");
INSERT INTO unx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ଆଡଃ ଆଇଁୟାଃ କାଜିକେ ଗିହୁଃରେଦ ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ପାବିତାର୍‌ ଦୁଁତ୍‌କଲଃ ଆପୁଇଁୟାଃ ମାନାରାଙ୍ଗ୍‌ରେ ହିଜୁଃରୁହାଡ଼୍‌ ଦିପିଲିରେ ଆଇଙ୍ଗ୍‌ହଗି ଏନ୍‌ ବିଷାଏରେ ଗିହୁଗଃଆଇଙ୍ଗ୍‌ । ସିର୍ମାରେନ୍‌ ଦାସିକଆଃ ମାନାରାଙ୍ଗ୍‌ରେ ହିଜୁଃ ଇମ୍‌ତା ଇନିଃହଗି ଇନିୟାଃ ବିଷାଏରେ ଗିହୁଗଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, “ନେତାଃରେ ତିଙ୍ଗୁଆକାନ୍‌କଏତେ ଚିମିନ୍‌କ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆଉରିକ ନେଲେଜାକେଦ୍ ଗନଏଃ କାକ ଚାଖାଏୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ଆଡଃ ନେ କାଜିରେୟାଃ ଇରାଲିୟା ମାହାଁ ତାୟମ୍‌ତେ ୟୀଶୁ ପାତ୍‌ରାସ୍‌, ଯୋହାନ୍‌ ଆଡଃ ଯାକୁବ୍‌ ତେକକେ ଆୟାଃଲଃ ଇଦିକେଦ୍‌ତେ ବିନ୍ତିନାଙ୍ଗ୍‌ ବୁରୁତେ ରାକାବ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଇନିଃ ବିନ୍ତିତାନ୍ ଇମ୍‌ତା ଇନିୟାଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ ବାଦାଲାଅୟାନା ଆଡଃ ଇନିୟାଃ ଲିଜାଃ ପୁରାଃଗି ମାସ୍କାଲ୍‌ଲେକା ପୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ଆଡଃ ଇମ୍‌ତାଗି ବାର୍‌ହଡ଼୍‌କିନ୍ ତାଇକେନା, ଇନ୍‌କିନ୍‌ ହବାଅଃତାନାକିନ୍‌ ମୁଶା ଆଡଃ ଏଲିୟ, ");
INSERT INTO unx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ଇନ୍‌କିନ୍‌ ସିର୍ମାରେନ୍‌ ମାନାରାଙ୍ଗ୍‌ରେକିନ୍ ଉଦୁବେନ୍‌ୟାନା, ଆଡଃ ୟୀଶୁଲଃ ଯୀରୁଶାଲେମ୍‌ରେ ଆୟାଃ ଗନଏଃରେୟାଃ କାଜି ବାଖାଁଣେତାନ୍‌କିନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ପାତ୍‌ରାସ୍‌ ଆଡଃ ଇନିୟାଃ ଗାତିକିନ୍‌ ଦୁଡ଼ୁମ୍‌ତେ ପୁରାଃ ପେରେଜାକାନ୍‌ ତାଇକେନାକିନ୍‌, ମେନ୍‌ଦ ଇନ୍‌କିନ୍‌ ପୁରା ଆଦାୟାନ୍ତେ, ଇନିୟାଃ ମାନାରାଙ୍ଗ୍‌ ଆଡଃ ଇନିଃଲଃ ତିଙ୍ଗୁଆକାନ୍‌ ବାର୍‌ହଡ଼୍‌କିନ୍‌କେ ନେଲ୍‌କେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ଇନ୍‌କିନ୍‌ ୟୀଶୁତାଃଏତେ ସେନଃତାନ୍‌ରେ ପାତ୍‌ରାସ୍‌, “ହେ ପ୍ରାଭୁ ଆବୁଆଃ ନେତାଃ ତାଇନଃତେୟାଃ ବୁଗିନାଃ, ଆଲେ ଆପିୟା କୁମ୍ବାଲେ ବାଇୟାଃ, ଆମାଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌, ମୁଶା ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ଆଡଃ ଏଲିୟ ନାଗେନ୍ତେ ମିଆଁଦ୍‌” ମେନ୍ତେ ୟୀଶୁକେକ କାଜିକିୟାଃ । ଇନିଃ ଦ ଆୟାଃ କାଜିତାନ୍‌ତେୟାଃ କାଏ ସାରିତାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ଇନିଃ ନେୟାଁ କାଜିତାନ୍‌ ଇମ୍‌ତାଗି ରିମିଲ୍‌ ହିଜୁଃକେଦ୍‌ତେ ଇନ୍‌କୁକେ ଉମ୍ୱୁଲ୍‌କେଦ୍‌କଆ, ଆଡଃ ଏନ୍‌ ରିମିଲ୍‌ରେ ବଲତାନ୍ ଇମ୍‌ତା ଇନ୍‌କୁ ବରକେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","“ନିଃ ଆଇଁୟାଃ ସାଲାକାନ୍‌ ଦୁଲାଡ଼୍‌ ହନ୍‌ ତାନିଃ, ଇନିୟାଃ କାଜି ଆୟୁମେପେ” ମେନ୍ତେ ମିଆଁଦ୍‌ କାଜି ରିମିଲ୍‌ଏତେ ଆୟୁମ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ନେ କାଜି କାଜିୟାନ୍‌ରେ, ଇନ୍‌କୁ ୟୀଶୁକେ ଏସ୍‌କାର୍‌ଗି ନାମ୍‌କିୟାଃକ । ଆଡଃ ଚେଲାକ ହାପାୟାନାକ, ନେଲ୍‌କାଦ୍ କାଜି ଏନ୍‌ ଦିପିଲିରେ ଜେତାଏକେ କାକ ଉଦୁବ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ୟୀଶୁ ଆଡଃ ଆୟାଃ ଆପିୟା ଚେଲାକ ବୁରୁଏତେ ଆଡ଼୍‌ଗୁୟାନ୍‌ ଇମ୍‌ତା ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ୟୀଶୁକେ ସେନ୍‌ଦାରମ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ଆଡଃ ନେଲେପେ, ଗାଦେଲ୍‌ ହଡ଼କଏତେ ମିହୁଡ଼୍‌ କାଉରିକେଦାଏ, “ହେ ଗୁରୁ ଆଇଙ୍ଗ୍‌ ବିନ୍ତିମେତାନାଇଙ୍ଗ୍‌, ହନିଙ୍ଗ୍‌କଡ଼ାକେ ହେତାଇମେ, ଇନିଃଦ ଆଇଁୟାଃ ମିଆଁଦ୍‌ଗି ହନ୍‌କଡ଼ା ତାନିଃ” ମେନ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ଆଡଃ ନେଲିମେ, ମିଆଁଦ୍‌ ବଙ୍ଗା ଇନିଃକେ ସାବ୍‌କିଃରେ ଇନିଃ ଆଚ୍‌କାଗି କାଉରିୟାଏ; ଆଡଃ ମଚାଏତେ ପୁତ୍‌ରିଦ୍‌କ ଅଡଙ୍ଗ୍‌ଅଃଆ, ବଙ୍ଗା ଇନିଃତାଃଏତେ ଚିମିନ୍‌ ତାର୍‌ସାର୍‌ତେ ଅଡଙ୍ଗ୍‌ଅଃଆଏ । ଆଡଃ ଇନିଃଦ ଇନିଃକେ ଜିୟନିତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ଆଇଙ୍ଗ୍‌ ଚେଲାକକେ ବିନ୍ତିକେଦ୍‌କଆଇଙ୍ଗ୍‌, “ମାର୍‌ ବଙ୍ଗାକେ ଅଡଙ୍ଗ୍‌ଇଁପେ, ମେନ୍‌ଦ ଇନ୍‌କୁ କାକ ଦାଡ଼ିକେଦାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଆଡଃ ୟୀଶୁ ମେନ୍‌କେଦାଏ, “ଏ କା ବିଶ୍ୱାସ୍‌ ଆଡଃ କେଟେଦ୍‌ ମନ୍‌ରେନ୍‌ ହଡ଼କ, ଚିମିନ୍‌ ମାହାଁ ଜାକେଦ୍‌ ଆପେଲଃ ତାଇନାଇଙ୍ଗ୍‌ ଆଡଃ ସାହାତିଙ୍ଗ୍‌ପେୟା ?” ଆଡଃ ଏନ୍‌ ହଡ଼କେ କାଜିକିୟାଏ, “ମାର୍‌ ଆମାଃ ହନ୍‌କେ ଆଇଙ୍ଗ୍‌ତାଃତେ ଆଉୱିମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ଆଡଃ କଡ଼ାହନ୍‌ ହିଜୁଃତାନ୍‌ ଇମ୍‌ତା ବଙ୍ଗା ଇନିଃକେ ଥାୱାକିୟାଏ, ମେନ୍‌ଦ ୟୀଶୁ ଏନ୍‌ ସତ୍‌ରା ଆତ୍ମାକେ ମାରାଙ୍ଗ୍‌ମଚାକେଦ୍‌ତେ ଇନିଃକେ ବୁଗିକିୟାଏ ଆଡଃ ଆପୁତେକେ ଏମ୍‌ରୁହାଡ଼ାଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ଏନ୍ତେଦ ସବେନ୍‌କ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ । ଆଡଃ ୟୀଶୁ କାମିକେଦ୍ ସବେନ୍‌ କାମିତେୟ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅଃତାନ୍ ତାଇକେନ୍‌ରେ, ଇନିଃ ଆୟାଃ ଚେଲାକକେ ମେତାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ନେ ସବେନ୍‌ କାଜି ଆପେୟାଃ ଲୁତୁର୍‌ରେ ଦହଏପେ, ଆଇଙ୍ଗ୍‌ ମାନୱାହନ୍‌ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ହଡ଼କଆଃ ତିଃଇରେ ଏମ୍‌ଏଣ୍ଡାଗଃଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ମେନ୍‌ଦ ଚେଲାକ ନେ କାଜି କାକ ଆଟ୍‌କାର୍‌ ଉରୁମ୍‌ ଦାଡ଼ିକେଦା ଆଡଃ ଇନ୍‌କୁ ଏନା ଆଲକାକ ଆଟ୍‌କାରେକା ମେନ୍ତେ ଚେଲାକନାଙ୍ଗ୍‌ ଉକୁଆକାନ୍ ତାଇକେନା ଆଡଃ ଇନ୍‌କୁ ନେ କାଜି ଇନିଃକେ କୁଲି ନାଗେନ୍ତେ ବରତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ଆଡଃ ଆବୁକଏତେ ଅକଏ ମାରାଙ୍ଗ୍‌ ମେନ୍ତେ ଚେଲାକ ଆକ ଆକରେକ ଉଡ଼ୁଃତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁଆଃ ମନ୍‌ରେୟାଃ ଉଡ଼ୁଃ ସାରିକେଦ୍‌ତେ, ମିଆଁଦ୍‌ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କେ ଆଉକିୟାଏ ଆଡଃ ଆୟାଃ ହେପାଦ୍‌ରେ ତିଙ୍ଗୁକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ଏନ୍ତେ ଇନିଃ ମେତାଦ୍‌କଆଏ, “ଜେତାଏ ନେ ହୁଡିଙ୍ଗ୍‌ ହନ୍‌କେ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ଦାରମିରେଦ ଆଇଙ୍ଗ୍‌କେ ଦାରମିଆଁ; ଆଡଃ ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ଦାରମିଁରେଦ ଆଇଙ୍ଗ୍‌କେ କୁନୁଲ୍‌ନିଃକେହଁ ଦାରମିଆଏ । ଚିୟାଃଚି ଆପେ ସବେନ୍‌କଏତେ ଅକଏ ହୁଡିଙ୍ଗ୍‌ଉତାରଃଆଏ ଇନିଃଗି ମାରାଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ଆଡଃ ଯୋହାନ୍‌ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ମିଆଁଦ୍‌ ହଡ଼ ଆମାଃ ନୁତୁମ୍‌ତେ ବଙ୍ଗାକକେ ଅଡଙ୍ଗ୍‌କତାନ୍‌ଲେ ନେଲ୍‌କିୟା ଆଡଃ ଆଲେ ଇନିଃକେ ମାନାକିୟାଃଲେ, ଚିୟାଃଚି ଇନିଃ ଆବୁଏତେ ମିହୁଡ଼୍‌ କାଏ ତାଇକେନା ।” ");
INSERT INTO unx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ମେନ୍‌ଦ ୟୀଶୁ କାଜିକିୟାଏ, “ଆଲ୍‌ପେ ମାନାଇୟା, ଆବୁଆଃ ବିରୁଧ୍‌ରେ ବାଙ୍ଗାଇନିଃଦ ଆବୁସାଃରିୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ୟୀଶୁଆଃ ସିର୍ମା ରାକାବ୍‌ରେୟାଃ ଦିପିଲି ନାଡ଼େଃୟଃତାନ୍‌ରେ ଇନିଃ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃ ନାଗେନ୍ତେ ଏସ୍‌କାର୍‌ଗି ମନ୍‌ତାୟାଃ କେଟେଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ଆଡଃ ଇନିଃ ହଡ଼କକେ କୁଲ୍‌ ଆୟାର୍‌କେଦ୍‌କଆଏ, ଇନ୍‌କୁ ସେନଃୟାନ୍ତେ ଇନିଃନାଙ୍ଗ୍‌ ବାଇସାତି ନାଗେନ୍ତେ ଶମିରୋନିରେନ୍‌କଆଃ ମିଆଁଦ୍‌ ହାତୁରେକ ବଲୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ମେନ୍‌ଦ ଏନ୍ତାଃରେନ୍‌ ହଡ଼କ ଇନିଃକେ କାକ ଦାରମ୍‌କିୟା ଚିୟାଃଚି ଇନିଃ ଯୀରୁଶାଲେମ୍‌ସାଃତେ ସେନଃତାନା ମେନ୍ତେ ସାରିୟଃ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ଇନିୟାଃ ଚେଲା ଯାକୁବ୍‌ ଆଡଃ ଯୋହାନ୍‌ ବାରାନ୍‌କିନ୍‌ କାଜିକିୟାଃ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଏଲିୟକେ ଆଚୁକେଦ୍‌ଲେକା ସିର୍ମାଏତେ ସେଙ୍ଗେଲ୍‌ ଉୟୁଗଃକା ଆଡଃ ଇନ୍‌କୁ ଜିୟନଃକାକ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ଏଗେର୍‌କେଦ୍‌କିନାଏ, ଆବେନ୍ ଚିଲ୍‌କାନ୍ ଆତ୍ମାରେନ୍‌ ତାନ୍‌ବେନ୍, ନେଆଁଁ କାବେନ୍‌ ସାରିତାନା । ହଡ଼କଆଃ ଜୀଉ ଜିୟନ୍‌ ନାଗେନ୍ତେଦ କାହା ମେନ୍‌ଦ ଜୀଉ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ମାନୱାହନ୍‌ ହିଜୁଃକାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ଆଡଃ ଇନ୍‌କୁ ଏଟାଃ ହାତୁତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ଇନ୍‌କୁ ହରାରେ ସେନ୍‌ତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ମିଆଁଦ୍‌ ହଡ଼, ୟୀଶୁକେ କାଜିକିୟାଏ, “ଆମ୍‌ କତେମ୍‌ ସେନା ଏନ୍ତେଇଙ୍ଗ୍‌ ଅତଙ୍ଗ୍‌ମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ତୁୟୁକଆଃଦ ଲାତା ମେନାଃ, ଆଡଃ ସିର୍ମା ଲାତାର୍‌ରେନ୍‌ ଚେଣେଁକଆଃ ଥକା ମେନାଃ ମେନ୍‌ଦ ମାନୱାହନ୍‌ଆଃ ବହଃ ଦହନାଙ୍ଗ୍‌ ଠାୟାଦ୍ ବାନଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ଆଡଃ ଇନିଃ ଏଟାଃନିଃକେ କାଜିକିୟାଏ, “ମାର୍‌ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ମେନ୍‌ଦ ଇନିଃ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ସିଦାତେ ଆପୁଇଙ୍ଗ୍‌କେ ତପାଇ ନାଗେନ୍ତେ ସେନ୍‌ଇଚିଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ମେନ୍‌ଦ ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଗଏଃକାନ୍‌କ ଆକଆଃ ଗଏଃକାନ୍‌କକେ ତପାକକାକ, ମେନ୍‌ଦ ଆମ୍‌ ସେନ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେୟାଃ କାଜି ଉଦୁବେମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ଆଡଃ ମିହୁଡ଼୍‌ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆଇଙ୍ଗ୍‌ ଅତଙ୍ଗ୍‌ମେୟାଁଇଙ୍ଗ୍‌ ମେନ୍‌ଦ ସିଦାତେ ଆଇଁୟାଃ ଅଡ଼ାଃରେନ୍‌କତାଃ ସେନ୍‌କେଦ୍‌ତେ ବିଦା ଇଦିନାଙ୍ଗ୍‌ କାଜି ଇଚିଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ୟୀଶୁ କାଜିକିୟାଏ, “ଆୟାଃ ତିଃଇକେ ନାଏଁହାଲ୍‌ରେ ଦହକେଦ୍‌ତେ ତାୟମ୍‌ସାଃ ହେତାଏନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ କାମିଲେକାନିଃ କାଏ ହବାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ନେଆଁଁତାୟମ୍‌ତେ ପ୍ରାଭୁ ୭୨ଏଟାଃ ଚେଲାକକେ ସାଲାକେଦ୍‌ତେ, ଆଇଃକ୍‌ ସେନଃ ସାନାଙ୍ଗ୍‌ତାନ୍ ସବେନ୍‌ ହାତୁ, ଟଲାତେ ବାବାର୍‌ହଡ଼୍‌ କୁଲ୍‌ ଆୟାର୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଇରୋଃ ପୁରାଃଗିୟାଃ ମେନ୍‌ଦ କାମିନାଲାକ ହୁଡିଙ୍ଗ୍‌ଆଁକ, ଏନା ନାଗେନ୍ତେ ଆପେ, ଆମ୍‌ ଆମାଃ ଇରୋଃତେ କାମି ନାଲାକ କୁଲ୍‌କମ୍ ମେନ୍ତେ ଇରୋଃ ଗମ୍‌କେତାଃରେ ବିନ୍ତିପେ । ");
INSERT INTO unx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ମାର୍‌ ସେନଃପେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ମିଣ୍ଡିହନ୍‌କ ଲେକା ହୁଣ୍ଡାର୍‌କ ଥାଲାରେଇଙ୍ଗ୍‌ କୁଲ୍‌ପେତାନା । ");
INSERT INTO unx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ଆପେ ପାଏସାମୁନା, ଥାଇଲାଃ, ଖାର୍‌ପା ଆଲ୍‌ପେ ଇଦିୟା ଆଡଃ ହରାରେ ଜେତାଏକେୟ ଆଲ୍‌ପେ ଜହାର୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଆଡଃ ଜେତା ଅଡ଼ାଃରେ ଦାରମ୍‌ପେରେ ‘ନେ ଅଡ଼ାଃରେନ୍‌କଆଃରେ ସୁକୁ ହବାଅଃକା’ ମେନେପେ । ");
INSERT INTO unx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ସୁକୁ ନାମେଲେକାନ୍ ହଡ଼ ଏନ୍ତାଃରେ ତାଇନ୍‌ରେଦ ଆପେୟାଃ ସୁକୁ ଇନିଃରେ ତାଇନାଃ, କା'ରେଦ ଏନା ଆପେତାଃତେ ରୁହାଡ଼ାଃ । ");
INSERT INTO unx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ଏନ୍‌ ଅଡ଼ାଃରେ ତାଇନଃପେ, ଇନ୍‌କୁ ଏମାପେତେୟାଃ ଜମ୍ ନୁଁଏପେ, କାମିନିଃଦ ଆୟାଃ ନାଲା ନାମେଗିୟାଏ । ଆଡଃ ଅଡ଼ାଃ ଅଡ଼ାଃ ଆଲ୍‌ପେ ହନରାଃ । ");
INSERT INTO unx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଜେତାଏ ହାତୁରେପେ ବଲରେଦ ଆଡଃ ହଡ଼କ ଦାରମ୍‌ପେରେଦ, ଇନ୍‌କୁଆଃ ଏମେତେୟାଃ ଜମେପେ । ");
INSERT INTO unx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ଏନ୍ତାଃରେନ୍ ହାସୁତାନ୍‌କକେ ବୁଗିକପେ, ଆଡଃ ‘ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆପେତାଃ ନାଡ଼େୟାକାନା’ ମେତାକପେ । ");
INSERT INTO unx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ମେନ୍‌ଦ ଆପେ ଜେତାଏ ହାତୁରେପେ ବଲରେଦ ଆଡଃ ହଡ଼କ କାକ ଦାରମ୍‌ପେରେଦ, ଏନାରେୟାଃ ହରାଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ କାଜିପେ, ");
INSERT INTO unx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ଆଲେୟାଃ କାଟା ତାଲ୍‌କାରେୟାଃ ଧୁଡ଼ି ଆପେୟାଃ ହାତୁରାଃ ଆୟାର୍‌ରେଲେ କଟା ଏଣ୍ଡାଏଃତାନା, ଏନ୍‌ରେୟ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆପେତାଃ ନାଡ଼େୟାକାନା ଏନା ସାରିପେ ।’ ");
INSERT INTO unx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଏନ୍‌ ହାତୁରେୟାଃ ଦୁକୁଏତେ ସୋଦମ୍‌ରାଃ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ୟେଁ ଲେକାୱାଃ । ");
INSERT INTO unx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ଏ କରାଜିନ୍, ଆମାଃ ହାୟ ହାୟ, ଏ ବେଥ୍‌ସାଇଦା, ଆମାଃ ହାୟ ହାୟ, ଆବେନ୍‌ରେ ହବାୟାନ୍ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ସୋର୍‌ ଆଡଃ ସିଦୋନ୍‌ରେ ହବାକାନ୍‌ରେଦ, ଇଦୁ ଇନ୍‌କୁ ଚିଉଲାରେ ବସ୍ତା ତୁସିଙ୍ଗ୍‌କେଦ୍‌ତେ ଆଡଃ ତରେକ୍‌ ଚେତାନ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ମନ୍‌ରୁହାଡ଼୍‌ କାତେତେୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ମେନ୍‌ଦ ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଆବେନାଃଏତେ ସୋର୍‌ ଆଡଃ ସିଦୋନ୍‌ରେୟାଃ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ୟେଁ ଲେକାୱାଃ । ");
INSERT INTO unx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ଆଡଃ ଆମ୍‌, ଏ କପର୍‌ନାହୁମ୍‌, ଚିୟାଃ ଆମ୍‌ ସିର୍ମା ଜାକେଦେମ୍ ରାକାବଆଃ ? ବାନଃଗି ଆମ୍‌ ପାତାଲ୍‌ ଜାକେଦେମ୍ ଏଣ୍ଡାଗଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ମେତାଦ୍‌କଆଏ, “ଆପେୟାଃ କାଜି ଆୟୁମ୍‌ନିଃ ଆଇଁୟାଃ ଆୟୁମେୟାଏ, ଆଡଃ ଆପେକେ କା ସୁକୁନିଃ ଆଇଙ୍ଗ୍‌କେହଁ କାଏ ସୁକୁୱାଇଙ୍ଗ୍‌ଆଃ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ କାଏ ସୁକୁନିଃ ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‌ନିଃକେ ହଁ କାଏ ସୁକୁୱାଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ଏନ୍‌ ୭୨ଝାନ୍‌ ଚେଲାକ ରାସ୍‌କାତାନ୍‌ଲଃକ ରୁହାଡ଼୍‌ୟାନା ଆଡଃ “ହେ ପ୍ରାଭୁ, ଆମାଃ ନୁତୁମ୍‌ତେ ବଙ୍ଗାକହଁ ଆଲେକେ ମାନାତିଙ୍ଗ୍‌ଲେତାନାକ” ମେନ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ଇନିଃ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ସାଏତାନ୍‌କେ ହିଚିର୍‌ ଲେକା ସିର୍ମାଏତେ ଉୟୁଗଃତାନ୍‌ତେୟାଃ ନେଲ୍‌କିୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ନେଲେପେ, ଆଇଙ୍ଗ୍‌ ବିଙ୍ଗ୍‌କଆଃ ଆଡଃ ମାର୍‌ମାର୍‌କଆଃ ଚେତାନ୍‌ରେ ସେସେନ୍‌ରେୟାଃ ଆଡଃ ବାଇରିୟାଃ ଗଟା ପେଡ଼େଃରେ ଆକ୍‌ତେୟାରାଇଙ୍ଗ୍‌ ଏମାଦ୍‌ପେୟା । ଆପେୟାଃ ଜେତ୍‌ନାଃ କା ହାନିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ଏନ୍‌ରେୟ ଏତ୍‌କାନ୍‌ ଆତ୍ମାକ ଆଲେକେ ମାନାତିଙ୍ଗ୍‌ତାନାକ ମେନ୍ତେ ଆଲ୍‌ପେ ରାସ୍‌କାୱାଃ, ମେନ୍‌ଦ ଆପେୟାଃ ନୁତୁମ୍‌ ସିର୍ମାରେ ଅଲାକାନା ନେୟାଁତେ ରାସ୍‌କାଅଃପେ” ମେନ୍ତେ କାଜିୟାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ଏନ୍‌ ଦିପିଲିରେ ୟୀଶୁ ପାବିତାର୍‌ ଆତ୍ମାରେ ପୁରାଃ ରାସ୍‌କାୟାନ୍‌ଲଃ କାଜିକେଦାଏ, “ହେ ଆବା, ସିର୍ମା ଆଡଃ ଅତେରେନ୍‌ ପ୍ରାଭୁ, ଆମ୍‌ ନେ କାଜିକ ସେଣାଁଁନ୍‌କ ଆଡଃ ଇତୁଆନ୍‌କତାଃଏତେମ୍‌ ଦାନାଙ୍ଗ୍‌ଆଁଁକାଦାଃ, ଆଡଃ ବାଲେଃ ହନ୍‌କତାଃରେମ୍ ଉଦୁବାକାଦାଃ ମେନ୍ତେଇଙ୍ଗ୍‌ ଧାନ୍ୟାବାଦ୍‌ମେତାନା । ହେଗି ହେ ଆବା, ନେୟାଁଗିଦ ଆମାଃ ବୁଗିନ୍‌ ସାନାଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ଆପୁଇଙ୍ଗ୍‌ ସବେନାଃ ଏମାକାଦିୟାଁଏ, ଆପୁକେ ବାଗିକେଦ୍‌ତେ ହନ୍‌ ଅକଏ ତାନିଃ ନେୟାଁ ଜେତାଏ କାକ ସାରିୟାଃ, ଆଡଃ ହନ୍‌କେ ବାଗିକେଦ୍‌ତେ ଆପୁ ଅକଏ ତାନିଃ ନେୟାଁ ଜେତାଏ କାକ ସାରିୟାଃ । ମେନ୍‌ଦ ଅକନ୍‌କକେ ଏନା ସାରି ନାଗେନ୍ତେ ହନ୍‌ ଆଇଃକ୍‌ଗି ସାଲାକୁଆଏ, ଇନ୍‌କୁ ଏସ୍‌କାର୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବିଷାଏରେ ସାରିୟାଃକ ।” ");
INSERT INTO unx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଚେଲାକକେ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ଏସ୍‌କାର୍‌ରେୟାଏ କାଜିୟାଦ୍‌କଆ, “ଆପେ ସବେନ୍‌ ନେ ସବେନାଃ ନେଲ୍‌ତାନ୍‌ତେୟାଃ ଚିମିନ୍‌ ସୁକୁତାନ୍‌ଗିୟାଃପେ । ");
INSERT INTO unx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ଆଇଙ୍ଗ୍‌ଦ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେ ନେଲ୍‌ତାନ୍‌ତେୟାଃ ପୁରାଃ ନାବୀକ ଆଡଃ ରାଜାକ ନେନେଲ୍‌ ସାନାଙ୍ଗ୍‌କେଦ୍‌କଆ ମେନ୍‌ଦ କାକ ନେଲ୍‌କେଦା ଆଡଃ ଆପେ ଆୟୁମ୍‌କେଦ୍‌ତେୟାଃ ଇନ୍‌କୁକେ ଆୟୁମ୍‌ ସାନାଙ୍ଗ୍‌କେଦ୍‌କଆ ମେନ୍‌ଦ କାକ ଆୟୁମ୍‌କେଦା ।” ");
INSERT INTO unx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ଆଡଃ ନେଲେପେ ମିଆଁଦ୍‌ ଆଇନ୍‌ ଇତୁନିଃ ବିରିଦ୍‌ୟାନ୍ତେ ୟୀଶୁକେ ବିଡ଼ାଅ ନାଗେନ୍ତେ କୁଲିକିୟାଏ, “ଏ ବୁଗିନ୍‌ ଇତୁନିଃ, ଜାନାଅ ଜୀଦାନ୍‌ ନାମେ ନାଗେନ୍ତେ ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ?” ");
INSERT INTO unx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ୟୀଶୁ କାଜିକିୟାଏ, “ଆନ୍‌ଚୁରେ ଚିକ୍‌ନାଃ ଅଲାକାନା ? ଆମ୍‌ ଚିଲ୍‌କାମ୍ ପାଢ଼ାଅ ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ଆଡଃ ଇନିଃ ମେନ୍‌ରୁହାଡ଼ାଇୟାଏ, “ପ୍ରାଭୁ ଆମାଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଆମାଃ ସବେନ୍‌ ମନ୍‌ସୁରୁଦ୍‌ତେ ଆଡଃ ଆମାଃ ସବେନ୍‌ ଜୀଉତେ ଆଡଃ ଆମାଃ ସବେନ୍‌ ପେଡ଼େଃତେ ଆଡଃ ଆମାଃ ସବେନ୍‌ ସେଣାଁଁତେ ଦୁଲାଡ଼ିମେ, ଆଡଃ ଆମାଃ ହପର୍‌ ଜାପାଃରେନ୍‌ନିଃକେ ଆମାଃ ଲେକାଗି ଦୁଲାଡ଼ିମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ଏନ୍ତେ ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ବୁଗିନାମ୍‌ କାଜିକାଦା, ଆମ୍‌ ନେକାଏରେଦମ୍ ଜୀହିଦଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ମେନ୍‌ଦ ଆଇନ୍‌ଇତୁନିଃ ଆଇଃକ୍‌ଗି ଧାର୍‌ମାନ୍‌ ଉଦୁବେନ୍ ସାନାଙ୍ଗ୍‌କିଃତେ ୟୀଶୁକେ କୁଲିକିୟାଏ “ଆଇଁୟାଃ ହପର୍‌ଜାପାଃରେନ୍‌ନିଃ ଅକଏ ତାନିଃ ?” ");
INSERT INTO unx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ମିଆଁଦ୍‌ ହଡ଼ ଯୀରୁଶାଲେମ୍‌ଏତେ ଯିରିହୋତେ ସେନଃତାନାଏ ତାଇକେନା ଆଡଃ କୁମ୍ବୁଡ଼ୁକଆଃ ତିଃଇରେ ଉୟୁଃୟାନାଏ, ଇନ୍‌କୁ ଇନିୟାଃ ଲିଜାଃ ରେକ୍‌କିୟାଃକ ଆଡଃ ଦାଲ୍‌କିଃତେ ଗଏଃଲେକାକ ବାଗିତୁକାଇଜାଃ । ");
INSERT INTO unx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ତାୟମ୍‌ତେ ମିଆଁଦ୍‌ ଯାଜାକ୍‌ ଏନ୍‌ ହରାତେଗି ସେନ୍‌ତାନାଏ ତାଇକେନା ଆଡଃ ଇନିଃକେ ନେଲ୍‌କିଃତେ ଏଟାଃ ହରାରେ ପାରମ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ନେ ଲେକାଗି ମିଆଁଦ୍‌ ଲେବୀହ, ଏନ୍‌ ଠାୟାଦ୍‌ରେ ସେଟେର୍‌ୟାନ୍‌ଚି ଇନିଃକେ ନେଲ୍‌କିଃତେ ପାରମ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ମେନ୍‌ଦ ମିଆଁଦ୍‌ ଶମିରୋନିରେନ୍ ହଡ଼ ସେନ୍‌ତାନ୍‌ଲଃ ଇନିଃ ତାଇକେନ୍‌ ଠାୟାଦ୍‌ରେ ସେଟେର୍‌ୟାନାଏ ଆଡଃ ଇନିଃକେ ନେଲ୍‌କିଃତେ ବିଲ୍‌କାଅୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ସେନ୍ ନାଡ଼େଃକେଦ୍‌ତେ ଇନିୟାଃ ଘାଅକରେ ସୁନୁମ୍‌ ଆଡଃ ଦାଖ୍‌ରାସି ଦୁଲ୍‌କେଦାଏ, ଏନାକେ ତଲ୍‌କେଦାଏ ଆଡଃ ଇନିଃକେ ଆୟାଃ ଗାଧାଚେତାନ୍‌ରେ ଲାଦିକିଃତେ ଡେରା ଅଡ଼ାଃତେ ଇଦିକିୟାଏ ଆଡଃ ଇନିଃକେ ଯାତାନ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଇନିଃ ବାର୍‌ସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକା ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଡେରା ଗମ୍‌କେ କେ ଏମ୍‌କିୟାଏ ଆଡଃ ନିଃକେ ଯାତାନିଃମେଁ ଆଡଃ ନିମ୍‌ନାଙ୍ଗ୍‌ଏତେ ଆଦ୍‌କାମ୍ ଖାର୍ଚାଏରେଦ ଆଇଙ୍ଗ୍‌ ରୁହାଡ଼୍‌ ଇମ୍‌ତା ପେରେଜାମେଁୟାଇଙ୍ଗ୍‌” ମେନ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“ନେ ଆପିୟା ହଡ଼କଏତେ ଅକଏ କୁମ୍ବୁଡ଼ୁକଆଃ ତିଃଇରେ ଉୟୁଗାକାନ୍‌ ହଡ଼ରାଃ ହପର୍‌ଜାପାଃରେନ୍‌ନିଃ ତାନିଃ ମେନ୍ତେପେ ଉଡ଼ୁଃତାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ଏନ୍‌ ଆଇନ୍‌ ଇତୁନିଃ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ “ଅକଏ ଲିବୁଇକେନ୍‌ନିଃ ।” ଏନ୍ତେ ୟୀଶୁ ଆଇନ୍‌ ଇତୁନିଃକେ କାଜିକିୟାଏ, “ଜୁ ଆମ୍‌ହ ନେ ଲେକାଗି ରିକାଏମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ସେନଃତାନ୍‌ ଇମ୍‌ତା ମିଆଁଦ୍‌ ହାତୁତେ ବଲୟାନାଏ, ଆଡଃ ମାର୍ଥା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ କୁଡ଼ି ଆୟାଃ ଅଡ଼ାଃରେ ଇନିଃକେ କୁପୁଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ଆଡଃ ମାରିୟାମ୍‌ ନୁତୁମ୍‌ ଇନିୟାଃ ମିଆଁଦ୍‌ ମିଶି ତାଇକେନାଏ, ଇନିଃ ପ୍ରାଭୁ ୟୀଶୁଆଃ କାଟା ସୁବାରେ ଦୁବ୍‌ୟାନ୍ତେ ଇନିୟାଃ କାଜି ଆୟୁମ୍‌ତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ମେନ୍‌ଦ ମାର୍ଥା ପୁରାଃ ସୁସାର୍‌ରେ ବିତ୍‌ଲାଅକାନାଏ ତାଇକେନା ଆଡଃ ଇନିଃ ହେପାଦ୍‌ତେ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟା, “ହେ ପ୍ରାଭୁ, ମିଶିଙ୍ଗ୍‌ତାଇୟାଁଃ ଆଇଙ୍ଗ୍‌କେ ଏସ୍‌କାର୍‌ ସୁସାର୍ ଇଚିଙ୍ଗ୍‌ତାନାଏ, ଚିୟାଃ ଏନା ଆମ୍‌କାମ୍ ଉଡ଼ୁଃତାନା ? ମାର୍‌ ମିଶିମ୍‌କେ ଦେଙ୍ଗାଇମେଁ” ମେନ୍ତେ ଇନିଃକେ ଆଚୁଇମେଁ । ");
INSERT INTO unx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ମେନ୍‌ଦ ପ୍ରାଭୁ ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, ଏ ମାର୍ଥା, ଏ ମାର୍ଥା, ଆମ୍‌ ପୁରାଃ କାଜି ନାଗେନ୍ତେମ୍ ଉଡ଼ୁଃତାନା ଆଡଃ ବିତ୍‌ଲାଅକାନା ମେନ୍‌ଦ ମିଆଁଦ୍‌ କାଜି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ମାରିୟାମ୍‌ଦ ଏନ୍‌ ବୁଗିନ୍‌ ହାନାଟିଙ୍ଗ୍‌କେ ସାଲାକାଦାଏ, ଏନା ଇନିଃତାଃଏତେ କା ରେଜଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ୟୀଶୁ ମିଆଁଦ୍‌ ଠାୟାଦ୍‌ରେ ବିନ୍ତିତାନାଏ ତାଇକେନା, ଆଡଃ ଟୁଣ୍ଡୁକେଦ୍ ଇମ୍‌ତା ଇନିୟାଃ ଚେଲାକଏତେ ମିହୁଡ଼୍‌ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ଆୟାଃ ଚେଲାକକେ ବିନ୍ତି ଇତୁକେଦ୍‌କଲେକା ଆମ୍‌ହ ଆଲେକେ ବିନ୍ତି ଇତୁଲେମ୍ ।” ");
INSERT INTO unx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, “ଆପେ ବିନ୍ତି ଇମ୍‌ତା ନେ ଲେକା ବିନ୍ତିପେ,” “‘ହେ ଆଲେୟାଃ ସିର୍ମାରେନ୍‌ ଆବା, ଆମାଃ ନୁତୁମ୍‌ ପାବିତାରଃକା, ଆମାଃ ରାଇଜ୍‌ ହିଜୁଃକା, ଆମାଃ ମନେ ଚିଲ୍‌କା ସିର୍ମାରେ, ଏନ୍‌ଲେକା ଅତେଦିଶୁମ୍‌ରେୟ ହବାଅଃକା । ");
INSERT INTO unx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ଆଲେୟାଃ ତିସିଙ୍ଗ୍‌ରେୟାଃ ଜମେୟାଃଁ ଏମାଲେମେ । ");
INSERT INTO unx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ଆଲେୟାଃ ପାପ୍‌କ ଛାମାଏମେଁ, ଚିୟାଃଚି ଜେ'ଲେକା ଆଲେୟ ଆଲେୟାଃ ସବେନ୍‌ ପାପ୍‌କେନ୍‌କଲେ ଛାମାକଆ ଆଡଃ ବିଡ଼ାଅରେ ଆଲମ୍‌ ଆଉଲେୟା, ମେନ୍‌ଦ ଏତ୍‌କାନ୍‌ନିଃଏତେ ବାଞ୍ଚାଅଲେମ୍‌ ।’” ");
INSERT INTO unx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆ, “ଇଦୁ ଆପେକଏତେ ଜେତାଏୟାଃ ମିଆଁଦ୍‌ ଗାତି ମେନାଇୟା, ଆଡଃ ଇନିଃ ଇନିଃତାଃତେ ଥାଲାନିଦା ସେନ୍‌କେଦ୍‌ତେ ମେତାଇୟାଏ, ‘ଏ ଗାତି ଆପିୟା ହଲଙ୍ଗ୍‌ ଉଧାର୍‌ ଏମାଇଙ୍ଗ୍‌ମେ, ");
INSERT INTO unx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ଆଇଁୟାଃ ମିଆଁଦ୍‌ ଗାତିଦ ହରାସେନ୍‌ତାନ୍‌ଲଃ ଆଇଙ୍ଗ୍‌ତାଃତେ ହିଜୁଃକାନାଏ ଆଡଃ ଇନିଃକେ ଜମ୍‌ ଏମଃ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ତାଃରେ ଜେତ୍‌ନାଃ ବାନଆଁଃ ।’ ");
INSERT INTO unx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ଆଡଃ ଇନିଃ କାଜିରୁହାଡ଼େୟାଏ, ‘ଆଲମ୍‌ ଦୁକୁଇୟାଁଃ ନାହାଁଃଦ ଦୁଆର୍‌ ହାଣ୍ଡେଦାକାନା ଆଡଃ ହନ୍‌କତାୟାଁଃ ଆଇଙ୍ଗ୍‌ଲଃକ ଗିତିଜାକାନା । ଆଇଙ୍ଗ୍‌ ବିରିଦ୍‌କେଦ୍‌ତେ ଜେତ୍‌ନାଃ କାଇଙ୍ଗ୍‌ ଏମ୍‌ଦାଡ଼ିୟା ।’ ");
INSERT INTO unx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଇନିଃ ଆୟାଃ ଗାତିତାନିଃ ରେୟ ବିରିଦ୍‌କେଦ୍‌ତେ କାଏ ଏମାଇୟା, ଇମିନ୍‌ରେୟ, ଆୟାଃ ଗାତି ଘାଡ଼ି ଘାଡ଼ି ଆସିତାନ୍‌ ହରାତେ ଇନିଃ ବିରିଦ୍‌ୟାନ୍‌ଲଃ ଆୟାଃ ଗାତିରାଃ ଲାଗାତିଙ୍ଗ୍‌ ଲେକାଏ ଏମାଇୟା । ");
INSERT INTO unx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“ଆଡଃ ଆଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆସିପେ ଏନାରେଦ ଆପେକେ ଏମଃଆ, ଦାଣାଁଁଏପେ ଏନ୍‌ରେଦପେ ନାମେୟା, ଦୁଆର୍‌ ଠକ୍‌ ଠକାଏପେ ଏନ୍‌ରେଦ ଆପେ ନାଗେନ୍ତେ ନିଜଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ଚିୟାଃଚି ଜେତାଏ ଆସିତାନ୍‌ନିଃଦ ତେଲାଜମାଃ, ଆଡଃ ଦାଣାଁଁଏନିଃଦ ନାମେୟାଏ, ଆଡଃ ଠକ୍‌ ଠକାଏନିଃ ନାଗେନ୍ତେ ନିଜଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ଆପେକଏତେ ଅକନ୍‌ ଆପୁ ନେ'ଲେକା ମେନାଇୟା, ଆୟାଃ ହନ୍‌ ହାକୁ ଆସିରେଦ, ଚିନାଃ ଇନିଃକେ ବିଙ୍ଗ୍‌ ଏମାଇୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ଚାଏ ଇନିଃ ଜାରମ୍‌ ଆସିରେ ଚିୟାଃ ମାର୍‌ମାର୍‌ ଏମାଇୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ଏନ୍ତେ ଆପେ ଏତ୍‌କାନ୍‌କ ତାଇନ୍‌ରେୟ, ଆପେୟାଃ ହନ୍‌କକେ ବୁଗିନାଃ ଏମଃପେ ସାରିୟା, ତାବ୍‌ଦ ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ ଅକନ୍‌କଚି ଆଇଃକ୍‌କେ ଆସି ତାନାକ, ଇନ୍‌କୁକେ ଏନାଏତେ ଆଦ୍‌କା ପାବିତାର୍‌ ଆତ୍ମା କାଏଚି ଏମାକଆ !” ");
INSERT INTO unx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ୟୀଶୁ ମିଆଁଦ୍‌ କା ବାଖାଁଣ୍‌ ଦାଡ଼ିତାନ୍‌ ବଙ୍ଗାକେ ଅଡଙ୍ଗ୍‌ଇଁତାନାଏ ତାଇକେନା । ବଙ୍ଗା ଅଡଙ୍ଗ୍‌ୟାନ୍‌ଚି ଏନ୍‌ କା ବାଖାଁଣ୍‌ଦାଡ଼ି ହଡ଼ ବାଖାଁଣ୍‌କେଦାଏ, ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ମେନ୍‌ଦ ଇନ୍‌କୁଏତେ ଚିମିନ୍‌କ କାଜିକେଦା, “ୟୀଶୁ ବଙ୍ଗାକଆଃ ଗମ୍‌କେ ବାଲ୍‌ଜେବୁଲ୍‌ଆଃ ହରାତେ ବଙ୍ଗାକକେ ହାର୍‌ ଅଡଙ୍ଗ୍‌କତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ଏଟାଃକ ୟୀଶୁକେ ବିଡ଼ାଅ ନାଗେନ୍ତେ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଯେ ଆୟାଃ ସାଃ ରିୟାଃ ନେୟାଁ ଉଦ୍‌ବେନାଙ୍ଗ୍‌ ସିର୍ମାରେୟାଃ ମିଆଁଦ୍‌ ଚିହ୍ନାଁକ ଆସିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ୟୀଶୁ ଇନ୍‌କୁଆଃ ମନ୍‌ରେୟାଃ ଉଡ଼ୁଃ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଜେତା ରାଇଜ୍‌ ଆଇଃକ୍‌ତେଗି ବିନ୍‌ଗାଅକେଦ୍‌ତେ ଆକ ଆକଥାଲାରେ ଲାପ୍‌ଡ଼ାଇରେଦ ଏନ୍‌ ରାଇଜ୍‌ କା ତିଙ୍ଗୁନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ଆଡଃ ସାଏତାନ୍‌, ସାଏତାନ୍‌ଗି ହିଗାଡ଼୍‌କେଦ୍‌ତେ ବିନ୍‌ଗାଅରେଦ, ଏନ୍‌ ରାଇଜ୍‌ ଚିଲ୍‌କାତେ ତିଙ୍ଗୁନାଃ ? ଆଇଙ୍ଗ୍‌ ନେଆଁଁ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌ ଚିୟାଃଚି ଆପେଦ ଇନିଃ ବାଲ୍‌ଜେବୁଲ୍‌ରାଃ ହରାତେ ବଙ୍ଗାକକେ ଅଡଙ୍ଗ୍‌କତାନାଏ ମେନ୍ତେପେ ମେନେତାନା । ");
INSERT INTO unx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ଆଡଃ ଆଇଙ୍ଗ୍‌ ବାଲ୍‌ଜେବୁଲ୍‌ଆଃ ପେଡ଼େଃତେ ବଙ୍ଗାକଇଙ୍ଗ୍‌ ହାର୍‌ଅଡଙ୍ଗ୍‌କ ତାନ୍‌ରେଦ, ଆପେୟାଃ ହଡ଼କ ଅକଏୟାଃ ହରାତେକ ହାର୍‌ ଅଡଙ୍ଗ୍‌କତାନା ? ଏନା ନାଗେନ୍ତେ ଇନ୍‌କୁଗି ଆପେୟାଃ ବିଚାର୍‌ନିଃକ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପେଡ଼େଃତେ ବଙ୍ଗାକଇଙ୍ଗ୍‌ ହାର୍‌ଅଡଙ୍ଗ୍‌କ ତାନ୍‌ରେଦ ଏନାତେ ଆଟ୍‌କାରଃତାନା ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆପେତାଃତେ ତେବାଃକାନା । ");
INSERT INTO unx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ପେଡ଼େୟାନ୍‌ହଡ଼ ସବେନ୍‌ ହାଁତେୟାର୍‌ ସାବ୍‌କେଦ୍‌ତେ ଆୟାଃ ଅଡ଼ାଃରାଚାକେ ହରଏରେଦ ଆୟାଃ ମେନାଃତେୟାଃ ବୁଗିଲେକାତେ ତାଇନଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ମେନ୍‌ଦ ଚିମ୍‌ତା ଆୟାଃଏତେ ଆଦ୍‌କା ପେଡ଼େୟାନ୍‌ ହଡ଼ ଇନିଃଲଃ ଲାଡ଼ାଇକେଦ୍‌ତେ ହାରାଅରେ, ଅକ ହାଁତେୟାର୍‌ ଚେତାନ୍‌ରେ ଆଇଃକ୍‌ ଭାର୍‌ସାକାଦ୍‌ ତାଇକେନାଏ, ଏନା ସବେନାଃଏ ରେଜିଆ ଆଡଃ ରେଜାକାଦ୍‌ତେୟାଃ ହାଟିଙ୍ଗ୍‌ୟେଁଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ଜେତାଏ ଆଇଁୟାଃଲଃ ବାଙ୍ଗାଇନିଃ, ଆଇଁୟାଃ ବିରୁଧ୍‌ରେ ମେନାଇୟା ଆଡଃ ଜେତାଏ ଆଇଁୟାଃଲଃ କାଏ ହୁଣ୍ଡିନିଃ ଛିତିବିତିୟଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ସତ୍‌ରା ଆତ୍ମା ମିହୁଡ଼୍‌ତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ରେ, ରହଡ଼୍‌ ଠାୟାଦ୍‌କରେ ହନର୍‌ବାଡ଼ାକେଦ୍‌ତେ ରୁଡ଼ୁନ୍‌ ନାଗେନ୍ତେ ଦାଣାଁଁୟାଏ ଆଡଃ କାଏ ନାମ୍‌ତାରେ, ଇନିଃ କାଜିୟାଏ, ‘ଆଇଙ୍ଗ୍‌ ଅକନ୍‌ ଅଡ଼ାଃଏତେ ଅଡଙ୍ଗ୍‌କାନ୍‌ ତାଇକେନାଇଙ୍ଗ୍‌, ଏନ୍‌ ଅଡ଼ାଃତେଗି ସେନ୍‌ରୁହାଡ଼ାଇଙ୍ଗ୍‌,’ ଆଡଃ ଇନିଃ ଏନ୍‌ ଅଡ଼ାଃକେ ସାମାଅଡ଼ାଃ, ସାଫାକାନ୍‌ ଆଡଃ ସୁଗାଡ଼ାନ୍‌ଗି ନେଲେୟା । ");
INSERT INTO unx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ଆଡଃ ହିଜୁଃରୁହାଡ଼୍‌କେଦ୍‌ତେ ଏନା ଜଅଃସାଫାକାନ୍‌ ଆଡଃ ସିଙ୍ଗାରାକାନାଏ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ଏନ୍ତେ ଇନିଃ ସେନ୍‌କେଦ୍‌ତେ ଆୟାଃତାଃଏତେ ଆଦ୍‌କା ଏତ୍‌କାନ୍‌ ସାତ୍‌ଠୁ ଆତ୍ମାକକେ ମିଦ୍‌ତେ ଆଉକଆ, ଆଡଃ ଇନ୍‌କୁ ଏନାରେକ ବଲଆ ଆଡଃକ ତାଇନଃଆ । ଆଡଃ ଏନ୍‌ ହଡ଼ରାଃ ଦାସା ପାହିଲାଏତେ ଟୁଣ୍ଡୁ ଦାସା ପୁରାଃଗି ଏତ୍‌କାନ୍‌ ହବାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ୟୀଶୁ ନେଆଁଁ କାଜିତାନ୍‌ ଇମ୍‌ତା ଗାଦେଲ୍‌ହଡ଼କରେନ୍‌ ମିଆଁଦ୍‌ କୁଡ଼ି କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ଆମ୍‌କେ ଜାନାମାକାମ୍ ଆଡଃ ତଆ ଆନୁକାମ୍ ଏଙ୍ଗା ଚିମିନ୍‌ ସୁକୁତାନ୍‌ଗିୟାଃଏ !” ");
INSERT INTO unx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ମେନ୍‌ଦ ୟୀଶୁ ମେନ୍‌ରୁହାଡ଼ାଇୟାଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି ଆୟୁମ୍‌ତାନ୍‌ ଆଡଃ ମାନାତିଙ୍ଗ୍‌ତାନ୍‌କହଗି ଚିମିନ୍‌ ସୁକୁତାନ୍‌ଗିଆଃକ !” ");
INSERT INTO unx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ଗାଦେଲ୍‌ ହଡ଼କ ୟୀଶୁତାଃରେ ହୁଣ୍ଡିନ୍‌ ତାଇକେନ୍‌ରେ ଇନିଃ କାଜିଏଟେଦ୍‌କେଦାଏ, ନେ ପାରିୟାରେନ୍‌ ହଡ଼କ ଚିମିନ୍‌ ଏତ୍‌କାନ୍‌ଗିୟାଃକ, ଇନ୍‌କୁ ଚିହ୍ନାଁକ ନାମ୍‌ତାନା ମେନ୍‌ଦ ଯୁନୁସ୍‌ ନାବୀୟାଃ ଚିହ୍ନାଁ ବାଗିକେଦ୍‌ତେ ଇନ୍‌କୁନାଙ୍ଗ୍‌ ଜେତାନ୍‌ ଚିହ୍ନାଁ କା ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ନିନିବିରେନ୍‌କ ନାଗେନ୍ତେ ଯୁନୁସ୍‌ଦ ଚିହ୍ନାଁଏ ତାଇକେନାଏ, ଏନ୍‌ଲେକାଗି ମାନୱାହନ୍‌ ନେ ପାରିୟାରେନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ଏନ୍‌କାଅଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ଦାକ୍ଷିଣ୍‌ ଦିଶୁମ୍‌ରେନ୍‌ ରାନୀ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କଲଃ ବିଚାର୍‌ହୁଲାଙ୍ଗ୍‌ରେ ବିରିଦାଃଏ ଆଡଃ ଇନ୍‌କୁକେ ଚିଟାକଆ, ଚିୟାଃଚି ଇନିଃ ସୁଲିମାନ୍‌ଆଃ ସେଣାଁଁନ୍‌ କାଜି ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଆୟାଃ ଅତେଦିଶୁମ୍‌ରେୟାଃ ଟୁଣ୍ଡୁଏତେ ହିଜୁଃକାନ୍‌ ତାଇକେନା ଆଡଃ ନେଲିପେ ରାଜା ସୁଲିମାନ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ନିଃ ନେତାଃରିୟା । ");
INSERT INTO unx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ନିନିବିରେ ଯୁନୁସ୍‌ ନାବୀ ପ୍ରାଚାର୍‌କେଦ୍‌ ଇମ୍‌ତା ପାତିୟାର୍‌କେଦ୍‌ ହଡ଼କ ତିଙ୍ଗୁକେଦ୍‌ତେ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କଲଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଇନ୍‌କୁକେକ ଚିଟାକଆ, ଚିୟାଃଚି ଇନ୍‌କୁ ଯୁନୁସ୍‌ ପାର୍‌ଚାର୍‌କେଦ୍‌ ଇମ୍‌ତା ମନ୍‌ରୁହାଡ଼୍‌କେଦାକ, ଆଡଃ ନାହାଁଃ ଆଇଙ୍ଗ୍‌ କାଜିପେତାନାଇଙ୍ଗ୍‌, ଯୁନୁସ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ନିଃ ନେତାଃରେ ମେନାଇୟା । ");
INSERT INTO unx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ଜେତାଏ ହଡ଼ ଦିମି ଜୁଲ୍‌କେଦ୍‌ତେ ଦାନାଙ୍ଗ୍‌ରେ ଚାଏ ତାୱାଲାତାର୍‌ରେ କାଏ ମାଣ୍ଡାଅୟା ମେନ୍‌ଦ ବଲତାନ୍‌କ ମାର୍ସାଲ୍‌କ ନେଲେକା ମେନ୍ତେ ଦିର୍କାରେ ଦହୟା । ");
INSERT INTO unx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ଆପେୟାଃ ମେଦ୍‌ଦ ହଡ଼୍‌ମରେୟାଃ ଦିମି ତାନାଃ, ଆପେୟାଃ ମେଦ୍‌ ନିରାଲ୍‌ ମେନାଃରେଦ ଗଟା ହଡ଼୍‌ମତାପେୟାଃ ମାର୍ସାଲଃଆ, ମେନ୍‌ଦ ଏନା ଏତ୍‌କାନ୍‌ନଃରେ ଗଟା ହଡ଼୍‌ମ ତାପେୟାଃ ନୁବାଗଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ଏନାମେନ୍ତେ ଆମ୍‌ରେୟାଃ ମାର୍ସାଲ୍‌ ଆଲକା ନୁବାଗଃକା ମେନ୍ତେ ଚିର୍ଗାଲାକାନ୍‌ମେ । ");
INSERT INTO unx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ଆମାଃ ଗଟା ହଡ଼୍‌ମ ମାର୍ସାଲାକାନ୍‌ରେଦ ଆଡଃ ଏନାରେୟାଃ ଜେତାଏ ହାନାଟିଙ୍ଗ୍‌ କା ନୁବାଃରେଦ ଦିମି ଏନାରେୟାଃ ଜୁନୁଲ୍‌ତେ ମାର୍ସାଲ୍‌ମେତାନ୍‌ ଲେକାଗି ଏନା ଗଟା ମାର୍ସାଲଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ୟୀଶୁ କାଜିଚାବାକେଦ୍‌ଚି, ମିଆଁଦ୍‌ ଫାରୁଶୀ ଆମ୍‌ ଆଇଁୟାଃ ଅଡ଼ାଃରେ ଜମ୍‌ଆଉକେମେଁ ମେନ୍ତେ ବିନ୍ତିକିୟା; ଆଡଃ ଇନିଃ ବଲୟାନ୍‌ଲଃ ଜମ୍‌ ନାଙ୍ଗ୍‌ ଦୁବ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ମେନ୍‌ଦ ଇନିଃ କାଟା ତିଃଇ କାଏ ଆବୁଙ୍ଗ୍‌କେଦ୍‌ତେ ଜମ୍‌ତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ଏନ୍‌ ଫାରୁଶୀ ହାଏକାଟ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ଏନ୍ତେ ପ୍ରାଭୁ ଇନିଃକେ କାଜିକିୟାଏ, “ହେଗି, ଆପେ ଫାରୁଶୀକ ଡୁବ୍‌ନି ଆଡଃ ଥାଡ଼ିରାଃ ବାହାରିକପେ ଗାସାର୍‍ ଆବୁଙ୍ଗ୍‌ ତାନା, ମେନ୍‌ଦ ଆପେୟାଃ ମନ୍‌ ଏତ୍‌କାନାଃତେ ପେରେଜାକାନା । ");
INSERT INTO unx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ଏ ଡଣ୍ଡକ, ବାହାରି ବାବାଇନି ଚିୟାଃ ଇନିଃ ଭିତାର୍‌ହ କାଏ ବାଇୟାକାଦାଃ ? ");
INSERT INTO unx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ମେନ୍‌ଦ ଆପେ ଲଭ୍‌କେଦ୍‌ତେ ଅକ୍‌ନାଃ କାମିକାଦାପେ ଏନା ଗାରିବ୍‌କକେ ଏମାକପେ ଏନାରେ ଆପେ ସାର୍‌ତିଗି ସବେନାଃତେପେ ଫାର୍‌ଚିଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ଏ ଫାରୁଶୀକ ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଆପେ ପୁଦ୍‌ନା, ଆଡଃ କିଲିମିଲି ଆଡ଼ାଃସାକାମ୍‌ରେୟାଃ ଗେଲ୍‌ ହାନାଟିଙ୍ଗ୍‌ପେ ଏମ୍‌ତାନା ମେନ୍‌ଦ ନ୍ୟାୟ ବିଚାର୍‌ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଲାଡ଼୍‌ପେ ହେଡ଼ାଏତାନା । ଏନ୍‌ଲେକା ରିକା କା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ମେନ୍‌ଦ ଏନ୍‌ ସବେନାଃକେ ମାନାତିଙ୍ଗ୍‌ ତାନ୍‌ଲଃ ନ୍ୟାୟ ବିଚାର୍‌ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଲାଡ଼୍‌କେ ଆଲପେ ହେଡ଼ାଏୟା । ");
INSERT INTO unx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ଆପେ ଫାରୁଶୀକ ହାୟ ହାୟ, ଚିୟାଃଚି ଆପେ ସାମାଜ୍‌ ଅଡ଼ାଃରାଃ ଆୟାର୍‌ରେ ଦୁବ୍‌ନାଙ୍ଗ୍‌ ଆଡଃ ପିଟ୍‌ ପିଡ଼ିକରେ ଜହାର୍‌ତେଲା ନାଙ୍ଗ୍‌ପେ ସୁକୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଚିୟାଃଚି ଆପେ ଉକୁଆକାନ୍‌ ତପାଗାଡ଼ାଲେକାଃପେ, କା ସାରିତାନ୍‌ଲଃ ଏନା ଚେତାନ୍‌ରେ ହଡ଼କ ସେନେୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ଏନ୍ତେ ଆଇନ୍‌ ଇତୁକଏତେ ମିଆଁଦ୍‌ନିଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେ ଗୁରୁ ନେ କାଜିତେ ଆଲେକେ ଆମ୍‌ ହିନିସ୍ତାଲେତାନାମ୍ ।” ");
INSERT INTO unx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ୟୀଶୁ କାଜିକିୟାଏ, “ଏ ଆଇନ୍‌ ଇତୁକ ଆପେୟ ହାୟ ହାୟ, ଚିୟାଃଚି ଆପେ ପୁରାଃହାମ୍ବାଲ୍‌ ବାହାରମ୍‌ ହଡ଼କକେ ଲାଦିକାଦ୍‌କଆପେ, ମେନ୍‌ଦ ଆପେ ଏନ୍‌ ବାହାରମ୍‌ ଆପେୟାଃ ମିଆଁଦ୍‌ ସାର୍‌ସାର୍‌ତେହ ଜୁଟିଦ୍‌କେଦ୍‌ତେ କାପେ ଦେଙ୍ଗାତାନା । ");
INSERT INTO unx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଆପେ ନାବୀକଆଃ ନାଙ୍ଗ୍‌ ବୁଗିନ୍‌ ତପାଗାଡ଼ାପେ ବାଇୟାକାଦା । ଏନ୍‌ ନାବୀକକେ ଆପେୟାଃ ହାଡ଼ାମ୍‌ହଡ଼କ ଗଜାକାଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ନାହାଁଃ ଆପେ ଆପେୟାଃ ହାଡ଼ାମ୍‌ହଡ଼କଆଃ କାମିରେୟାଃ ଗାୱାପେ ପେରେଜେତାନା; ଆଡଃ ଏନାତେପେ ସୁକୁଃତାନା, ଇନ୍‌କୁଦ ନାବୀକକେ ଗଏଃକେଦ୍‌କଆକ ଆଡଃ ଆପେ ଇନ୍‌କୁଆଃ ତପାଗାଡ଼ାପେ ବାଇକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ଏନାମେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ସେଣାଁଁତେ କାଜିୟାକାଦାଏ, ଆଇଙ୍ଗ୍‌ ଆପେତାଃତେ ନାବୀକ ଆଡଃ ପ୍ରେରିତ୍‌କକେ କୁଲ୍‌କୁଆଇଙ୍ଗ୍‌, ଇନ୍‌କୁଏତେ ଚିମିନ୍‍କକେ ଗଏଃକଆକ ଆଡଃ ଏଟାଃକକେ ସାତାଅକଆକ । ");
INSERT INTO unx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ଏନାମେନ୍ତେ ଅତେଦିଶୁମ୍‌ରାଃ ମୁନୁଏତେ ସବେନ୍‌ ନାବୀକଆଃ ଲିଙ୍ଗିୟାନ୍‌ ମାୟୋମ୍‌ରେୟାଃ ଲେକା ନେ ପାରିୟାରେନ୍‌କଏତେ ଇଦିୟଃଆ, ");
INSERT INTO unx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ହେଗି, ହାବିଲ୍‌ଆଃ ମାୟୋମ୍‌ଏତେ ବେଦି ଆଡଃ ମାନ୍ଦିର୍‌ରେୟାଃ ପାବିତାର୍‌ ଠାୟାଦ୍‌ ଥାଲାରେ ଗଏଃୟାନ୍‌ ଜିଖ୍‌ରିୟା ମାୟୋମ୍‌ ଜାକେଦ୍‌, ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଏନାରେୟାଃ ଲେକା ନେ ପାରିୟାରେନ୍‌କଏତେ ଇଦିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ଏ ହସଡ଼ ଆଇନ୍‌ ଇତୁକ, ଆପେୟାଃ ସାଜାଇ ପୁରାଃ ବରୱାନ୍‌ଗି ହବାଅଆଃ, ଚିୟାଃଚି ଆପେ ସେଣାଁଁରେୟାଃ ଚାଭିପେ ଇଦିକେଦାଃ ଆଡଃ ଆପେୟଗି କାପେ ବଲଆକାନା ଚି ବଲତାନ୍‌କକେ ହ କେସେଦାକାଦ୍‌କଆପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଆଡଃ ଇନିଃ ଏନ୍ତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ ଇମ୍‌ତା, ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ପୁରାଃଗି ବିରୁଧ୍‌କିୟାଃକ ଆଡଃ ପୁରାଃ କାଜିକ ଇନିଃକେ କୁଲିଗରଙ୍ଗ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ଆଡଃ ଇନ୍‌କୁ ଇନିୟାଃ ମଚାରେୟାଃ ଜେତାନ୍‌ ଭୁଲ୍‌କାଜିତେ ସାବିନାଙ୍ଗ୍‌ ଲଡଇତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ଏନ୍ତେ ପୁରାଃ ହାଜାର୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ହୁଣ୍ଡିୟାନା, ଆଡଃ ଆକ ଆକଗି ଇପ୍‌ଲିଙ୍ଗ୍‌ଅଃତାନ୍‌କ ତାଇକେନା, ଇମ୍‌ତାଙ୍ଗ୍‌ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ପାହିଲା କାଜିୟାଦ୍‌କଆଏ, ଫାରୁଶୀକଆଃ ସାବାଃ ହଲଙ୍ଗ୍‌ ଲେକାନ୍‌ ହସଡ଼ ବିଷାଏହେତେ ଚିର୍ଗାଲାକାନ୍‌ ତାଇନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ସବେନ୍‌ ଉକୁଆକାନ୍‌ତେୟାଃ ନେଲଆଃ ଆଡଃ ସବେନ୍‌ ଦାନାଙ୍ଗ୍‌ଆଁକାନ୍ ତେୟାଃଦ ସାରିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ଆପେ ନୁବାଃରେ କାଜିକାଦ୍‌ତେୟାଃ ମାର୍ସାଲ୍‌ରେ ଆୟୁମଃଆ ଆଡଃ ଆପେ ଭିତାର୍‌ ବାଖ୍‌ରାରେ ଉକୁକେଦ୍‌ତେ କାଜିକାଦ୍‌ତେୟାଃ, ସାଡ଼୍‌ମି ଚେତାନ୍ଏତେ ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ଏ ଆଇଁୟାଃ ଗାତିକ, ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ହଡ଼୍‌ମ ଗଗଏଃକକେ, ଆଡଃ ତାୟମ୍‌ତେ ଜେତ୍‌ନାଃ କା ରିକା ଦାଡ଼ିକକେ ଆଲ୍‌ପେ ବରଆକଆ । ");
INSERT INTO unx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ମେନ୍‌ଦ ଆପେ ବରଆଇ ଲାଗାତିଙ୍ଗ୍‌ନିଃକେ ଆଇଙ୍ଗ୍‌ ଉଦୁବାପେୟା, ଗଏଃକି ତାୟମ୍‌ତେ ନାରାକ୍‌ରେ ହୁରାଙ୍ଗ୍‌ଏଣ୍ଡାରେୟାଃ ପେଡ଼େଃତାଇନ୍‌ନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରଆଇପେ; ହାଁ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଇନିଃକେଗି ବରଆଇପେ । ");
INSERT INTO unx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ଚିୟାଃ ମଣେୟାଁ ଗେରଁୱାକ ବାରିଆ ସିକାତେ କାକ ଆଖ୍‌ରିଙ୍ଗ୍‌ୟଃଆ ? ଆଡଃ ଏନ୍‌ରେୟ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃକେହଁ କାଏ ରିଡ଼ିଙ୍ଗ୍‌ଇତାନା । ");
INSERT INTO unx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ହେଗି, ଆପେୟାଃ ବହଃରାଃ ସବେନ୍‌ ଉବ୍‌ହ ଲେକାକାନା । ଆଲ୍‌ପେ ବରଏୟା, ଆପେ ପୁରାଃ ଗେରଁୱାକଏତେ ପୁରାଃଗି ଗନଙ୍ଗ୍‌ଆଃଁପେ । ");
INSERT INTO unx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ହଡ଼କଆଃ ଆୟାର୍‌ରେ ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ସାରିୟାଃଇଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିରେଦ ମାନୱାହନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଁତ୍‌କଆଃ ଆୟାର୍‌ରେ ଇନିଃକେ ସାରିୟାଃଇଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିୟା । ");
INSERT INTO unx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ମେନ୍‌ଦ ହଡ଼କଆଃ ଆୟାର୍‌ରେ ଆଇଙ୍ଗ୍‌କେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ମେନ୍ତେ କାଜିନିଃକେ ମାନୱାହନ୍‌ହ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଁତ୍‌କଆଃ ଆୟାର୍‌ରେ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ମେନ୍ତେ କାଜିୟା । ");
INSERT INTO unx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“ଆଡଃ ମାନୱାହନ୍‌ଆଃ ବିରୁଧ୍‌ରେ ଜେତାଏ କାଜିରେଦ ଇନିଃକେ ଛାମା ଏମଃଆ, ମେନ୍‌ଦ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ବିରୁଧ୍‌ରେ ନିନ୍ଦା କାଜିକ କାଜିନିଃକେ ଛାମା କା ଏମଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ଆଡଃ ଇନ୍‌କୁ ଆପେକେ ସାମାଜ୍‌ ଅଡ଼ାଃତେ, ଲାଟ୍‌ସାହାବ୍‌କତାଃ ଆଡଃ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ ହାକିମ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ତେକ ଆଉପେରେ, ଆପେ ଚିଲ୍‌କା ଆଡଃ ଚିକ୍‌ନାଃପେ କାଜିରୁହାଡ଼େୟା ଆଡଃ ଚିକ୍‌ନାଃପେ କାଜିୟାଃ ମେନ୍ତେ ଆଲ୍‌ପେ ପାହାମେୟା । ");
INSERT INTO unx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ପାବିତାର୍‌ ଆତ୍ମା ଆପେକେ କାଜି ଲାଗାତିଙ୍ଗ୍‌ତେୟାଃ ଏନ୍‌ ଦିପିଲିରେଗି ଇତୁପେୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ଗାଦେଲ୍‌ ହଡ଼କଏତେ ଜେତାଏ ହଡ଼ କାଜିକିୟାଏ, “ହେ ଗୁରୁ, ଆଇଁୟାଃ ହାଗାଇଙ୍ଗ୍‌କେ ଆପୁଏତେ ନାମାକାଦ୍‌ ଖୁର୍ଜିକେ ଆଇଁୟାଃଲଃ ହାଟିଙ୍ଗ୍‌ୟେଁମେ ମେନ୍ତେ କାଜିୟାଇମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଏ ଗାତି, ଆବେନାଃ ବିଚାର୍‌ନିଃ ଚାଏ ହାଟିଙ୍ଗ୍‌ଏନିଃ ମେନ୍ତେ ଅକଏ ଆଇଙ୍ଗ୍‌କେ ସାଲାକାଦିଙ୍ଗ୍‌ଆଏ ?” ");
INSERT INTO unx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଆଡଃ ଇନିଃ କାଜିୟାଦ୍‌କଆଏ, “ନେଲେପେ, ସବେନ୍‌ ହାୟାହେତେ ଆତମାକାନ୍‌ପେ; ଜେତାଏୟାଃ ମେନାଃତେୟାଃ ପୁରାଃଗିରେୟ ଏନାରେ ଇନିୟାଃ ଜୀଦାନ୍‌ ବାନଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ମିଆଁଦ୍‌ ଜନ୍‌କା କାଜି ଉଦୁବାଦ୍‌କଆଏ, “ଜେତାଏ ମିଆଁଦ୍‌ କିସାଁଣ୍‌ ହଡ଼ଆଃ ଲୟଙ୍ଗ୍‌ରେ ପୁରାଃ ଜ ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ଇନିଃ ମନ୍‌ରେ ଉଡ଼ୁଃକେଦାଏ, ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ? ଆଇଁୟାଃ ଜ ଦହତେ ଠାୟାଦ୍ ବାନଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ଏନ୍ତେ ଇନିଃ ମେନ୍‌କେଦାଏ, ଆଇଙ୍ଗ୍‌ ନେକାୟା, ଆଇଁୟାଃ ଭାଣ୍ଡାର୍‌ ଅଡ଼ାଃ ଉତୁଡ଼୍‌କେଦ୍‌ତେ ଆଦ୍‌କା ମାପ୍‌ରାଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ ବାଇୟାଃ, ଆଡଃ ଏନ୍ତାଃରେ ଆଇଁୟାଃ ସବେନ୍‌ ଜ ଆଡଃ ବୁଗିନ୍‌ତେୟାଃକଇଙ୍ଗ୍‌ ଦହୟା । ");
INSERT INTO unx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଆଡଃ ଆଇଙ୍ଗ୍‌ ଜୀଉତାଇୟାଁଃକେଇଙ୍ଗ୍‌ କାଜିୟା, ଏ ଜୀଉ, ଆମାଃତାଃରେ ପୁରାଃ ସିର୍ମା ନାଗେନ୍ତେ ପୁରାଃ ବୁଗିନ୍‌ତେୟାଃ ଦହଆକାନା, ରୁଡ଼ୁନ୍‌ମେ, ଜମ୍ ନୁଁଏମେ ଆଡଃ ସୁକୁତେ ତାଇନଃମେ । ");
INSERT INTO unx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ କାଜିକିୟାଏ, ଆମ୍‌ ଡଣ୍ଡ, ନେ ନିଦାରେ ଆମାଃ ଜୀଉ ଆମାଃତାଃଏତେ ଇଦିୟଃଆ, ତାବ୍‌ଦ ଆମ୍‌ ଆମାଃ ନାଙ୍ଗ୍‌ ସବେନ୍‌ ହୁଣ୍ଡିଆକାଦ୍‌ତେୟାଃ ଅକଏୟାଃ ହବାଅୱା ।” ");
INSERT INTO unx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଅକଏ ଆୟାଃ ନାଗେନ୍ତେ ଖୁର୍ଜି ହୁଣ୍ଡିନିଃ ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ନାଙ୍ଗ୍‌ କାଏ କିସାଁଣାଃ, ଇନିଃନାଙ୍ଗ୍‌ ନେ ଲେକାଗି ହବାଅୱା । ");
INSERT INTO unx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଆଡଃ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, “ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ଜୀନିଦ୍‌ ତାଇନଃ ନାଗେନ୍ତେ ଚିକ୍‌ନାଃବୁ ଜମାଃ ଆଡଃ ଚିକ୍‌ନାଃବୁ ନୁଁଏୟା, ଚାଏ ହଡ଼୍‌ମରେ ଚିକ୍‌ନାଃବୁ ତୁସିଙ୍ଗ୍‌ୟେଁନା ମେନ୍ତେ ଆପେୟାଃ ଜୀଉରେ ଆଲ୍‌ପେ ଉଡ଼ୁଃୟା । ");
INSERT INTO unx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ଜମେୟାଁଃଏତେ ଜୀଉ ଆଡଃ ଲିଜାଃଏତେ ହଡ଼୍‌ମ ମାରାଙ୍ଗ୍‌ଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","କାଉୱା ଚେଣେଁକକେ ନେଲ୍‌କପେ, ଇନ୍‌କୁ କାକ ହେରେୟା ଆଡଃ କାକ ଇରେୟା, ଆଡଃ ଇନ୍‌କୁଆଃ ଭାଣ୍ଡାର୍‌ ଅଡ଼ାଃ ଚାଏ ଗୋଦାମ୍ ଅଡ଼ାଃ ବାନଃରେୟ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କୁକେ ଆସୁଲ୍‌କତାନାଏ । ଆପେ ଚେଣେଁକଏତେ ଚିମିନ୍‌ ଆଦ୍‌କାଗିପେ ମାରାଙ୍ଗ୍‌ଆଃ ! ");
INSERT INTO unx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ଆପେକଏତେ ଅକଏ ଉଡୁଃକେଦ୍‌ତେ ଆୟାଃ ଜୀଉକେ ମିଦ୍‌ ଘାଡ଼ି ପସାଦାଡ଼ିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ଏନ୍ତେ ଆପେ ହୁଡିଙ୍ଗ୍‌ଉତାର୍‌ତେୟାଃକେହ କାପେ କାମିଦାଡ଼ିରେଦ ଚିକ୍‌ନାଃ ମେନ୍ତେ ବାକିକାଜି ନାଗେନ୍ତେପେ ପାହାମ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ବାହାକକେ ନେଲେପେ, ଇନ୍‌କୁ କାକ କାମିୟାଃ ଚି କାକ ତୁକୁଇତାନା, ହଲେହଁ ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ସୁଲିମାନ୍‌ହଁ ଆୟାଃ ସବେନ୍‌ ସୁଗାଡ଼ାନ୍‌ତେୟାଃଏତେ ନେ ମିଆଁଦ୍‌କ ଲେକା କାଏ ସିଙ୍ଗାରାକାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ଏନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ତିସିଙ୍ଗ୍‌ ମେନାଃ ଆଡଃ ଗାପା ଚୁଲ୍ଲାରେ ହାଁଣବଃତାନ୍‌ ଅତେରାଃ ତାସାଦ୍‌କେ ନେ ଲେକାଏ ସିଙ୍ଗାରେରେଦ, ଏ ହୁଡିଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ତାନ୍‌କ, ଚିୟାଃ ଇନିଃ ନେଆଁଁଏତେ ଆଦ୍‌କା ଆପେକେ କାଏ ତୁସିଙ୍ଗ୍‌ପେୟା ? ");
INSERT INTO unx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“ଆଡଃ ଚିକ୍‌ନାଃବୁ ଜମେୟାଁ ଆଡଃ ଚିକ୍‌ନାଃବୁ ନୁଁଏୟା ମେନ୍ତେ ମନ୍‌ରେ ଆଲ୍‌ପେ ନାମ୍‌ବାଡ଼ାୟା ଆଡଃ ଆଲ୍‌ପେ ଉଡ଼ୁଗେୟା । ");
INSERT INTO unx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କ ନେ ସବେନାଃ ଦାଣାଁଁବାଡ଼ାଃକ, ଆଡଃ ନେ ସବେନାଃ ଆପେୟାଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଏନା ଆପେୟାଃ ସିର୍ମାରେନ୍‌ ଆପୁ ସାରିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଦାଣାଁଁଏପେ ଆଡଃ ନେ ସବେନାଃହ ଆପେକେ ଏମଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ଏ ହୁଡିଙ୍ଗ୍‌ ଗୋଟ୍‌କ ଆଲ୍‌ପେ ବରଏୟା ଆପେୟାଃ ଆପୁଦ ଆପେକେ ଆୟାଃ ରାଇଜ୍‌ ଏମଃନାଙ୍ଗ୍‌ ସୁକୁଆକାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ଆପେୟାଃ ମେନାଃତେୟାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌ କେଦ୍‌ତେ କଏଁକକେ ଏମାକପେ, କା ମାଇଲାଅଃ ପାଏସାମୁନା ଆପେନାଙ୍ଗ୍‌ ବାଇୟେପେ, କା ଖାରାପଃ ଖୁର୍ଜି ସିର୍ମାରେ ଦହଏପେ, ଏନ୍ତାଃରେ କୁମ୍ବୁଡ଼ୁ କାଏ ତେବାଃଏୟା ଆଡଃ ନିଦିର୍‌ କାଏ ଜମେୟାଁ । ");
INSERT INTO unx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ଚିୟାଃଚି ଆପେୟାଃ ଖୁର୍ଜି ତାଇନଃତାଃରେଗି ଆପେୟାଃ ମନ୍‌ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ଆପେୟାଃ ମାୟାଙ୍ଗ୍‌ ପାଟେକେଦ୍‌ତେ କାମିନାଙ୍ଗ୍‌ ସେକାଡ଼ାକାନ୍‌ପେ ଆଡଃ ଆପେୟାଃ ଦିମି ଜୁଲାକାନ୍‌ ତାଇୟଃକା । ");
INSERT INTO unx_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ଆଡଃ ଏନ୍‌ ହଡ଼କଲେକାଅଃପେ, ଇନ୍‌କୁ ଆବୁଆଃ ଗମ୍‌କେ ଆଣ୍‌ଦିଏତେ ଚିଉଲାଏ ରୁହାଡ଼ାଃ ଆଡଃ ଇନିଃ ହିଜୁଃକେଦ୍‌ତେ ଠକ୍‌ ଠକାଏରେଦ ଇନିଃ ନାଗେନ୍ତେ ଇମ୍‌ତା ଦୁଆର୍‌ବୁ ନିଜେୟା ମେନ୍ତେକ ନେଲ୍‌ହରାଇତାନା । ");
INSERT INTO unx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ଅକନ୍‌ ଦାସିକକେ ଆକଆଃ ଗମ୍‌କେ ଏୟନାକାନ୍‌ ଆଡଃ ସେକାଡ଼ାକାନ୍‌ ହିଜୁଃନାମ୍‌କରେ ଏନ୍‌ ଦାସିକ ଚିମିନ୍‌ ସୁକୁତାନ୍‌ଗିୟାକ, ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଇନିଃ ମାୟାଙ୍ଗ୍‌ ପାଟେକେଦ୍‌ତେ ଇନ୍‌କୁଲଃ ଜଜମ୍‌ ନାଗେନ୍ତେ ଦୁବ୍‌କଆଏ ଆଡଃ ହିଜୁଃକେଦ୍‌ତେ ଇନ୍‌କୁକେ ସୁସାର୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଆଡଃ ଇନିଃ ଥାଲାନିଦା ଚାଏ ସିମ୍‌କରାଃ ହିଜୁଃକେଦ୍‌ତେ ଇନ୍‌କୁକେ ନେ ଲେକାଏ ନାମ୍‌କରେଦ ଏନ୍‌ ଦାସିକ ଚିମିନ୍‌ ସୁକୁତାନ୍‌ଗିୟାକ । ");
INSERT INTO unx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ମେନ୍‌ଦ ନେଆଁଁ ଆଟ୍‌କାରେପେ, ଅଡ଼ାଃରେନ୍‌ ଗମ୍‌କେ କୁମ୍ବୁଡ଼ୁ ହିଜୁଃ ଦିପିଲି ସାରିକାଇରେଦ ଇନିଃକେ ଆୟାଃ ଅଡ଼ାଃରାଃ ସିନ୍ଧି କାଏ ଉତୁଡ଼୍‌ରିକା ଇଚିକାଇତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ଏନା ନାଗେନ୍ତେ ଆପେୟ ସାପ୍‌ଡ଼ାଅକାନ୍‍ ତାଇନ୍‌ପେ, ଚିୟାଃଚି ଆପେ କାପେ ଉଡ଼ୁଃତାନ୍‌ ଦିପିଲିରେଗି ମାନୱାହନ୍‌ ହିଜୁଃଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ କୁଲିକିୟାଏ, “ହେ ପ୍ରାଭୁ ଚିୟାଃ ଆମ୍‌ ଆଲେକେ ଚି ସବେନ୍‌କକେ ନେ ଜନ୍‌କା କାଜି କାଜିୟାଲେତାନାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ଆଡଃ ପ୍ରାଭୁ କାଜିରୁହାଡ଼୍‌କେଦାଏ, “ଏନ୍ତେ ଗୁସିୟାଁ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌କକେ ବୁଗିନ୍‌ ନେଡାରେ ଜମେୟାଃଁ ଏମାକ ନାଗେନ୍ତେ ଅକଏକେ ଇନିଃ ସାଲାକିଆଏ, ଏନ୍‌ଲେକାନ୍‌ ପାତିୟାର୍‌ରଃ ଆଡଃ ସେଣାଁଁନ୍‌ ଭାଣ୍ଡାରି ଅକଏ ତାନିଃ ? ");
INSERT INTO unx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ଆୟାଃ ଗୁସିୟାଁ ନେ'ଲେକା କାମିତାନ୍ ଦାସିକେ ହିଜୁଃ ନାମିରେ ଇନିଃ ସୁକୁତାନ୍‌ଗିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଇନିଃ ଏନ୍‌ ଦାସିକେ ଆୟାଃ ସବେନ୍‌ ମେନାଃତେୟାଃରେନ୍‌ ଗୁସିୟାଁ ଦହଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ମେନ୍‌ଦ ଏନ୍‌ ଦାସି, ଆଇଁୟାଃ ଗୁସିୟାଁରାଃ ହିଜୁଃତେୟାଃ ବିଲାମଃତାନାଃ ମେନ୍ତେ ମନ୍‌ତାୟାଃରେ କାଜିକେଦ୍‌ତେ ଦାସିକ ଆଡଃ କାମ୍‌ଡ଼ିକକେ ଦାଦାଲ୍‌, ଆଡଃ ଜଜମ୍‌ ନୁଁ ଆଡଃ ବୁଲଃ ଏଟେଦ୍‌ରେଦ, ");
INSERT INTO unx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ଏନ୍‌ ଦାସିଆଃ ଗମ୍‌କେ ଇନିଃ କାଏ ଉଡ଼ୁଃ ହୁଲାଙ୍ଗ୍‌ରେ ଆଡଃ କାଏ ସାରି ଦିପିଲିରେ ହିଜୁଃଆଏ ଆଡଃ ଇନିଃକେ ପୁରାଃ ଦୁକୁ ଏମାଇତାନ୍‌ଲଃ ଟୁକ୍‌ଡ଼ା ଟୁକ୍‌ଡ଼ା ମାଆଃଇୟାଏ, ଏନ୍ତେ କା ବିଶ୍ୱାସ୍‌ତାନ୍‌କଲଃ ହାନାଟିଙ୍ଗ୍‌ଆଏ ଏମାଇୟା । ");
INSERT INTO unx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“ଆୟାଃ ଗମ୍‌କେୟାଃ ମନ୍‌ ସାରିକେଦ୍‌ତେ କାଏ ସେକାଡ଼ାକାନ୍‌ ଆଡଃ ଇନିୟାଃ ମନେଲେକା କା କାମିକେଦ୍‌ ଦାସି ପୁରାଃଗିୟାଏ ଦାଲଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ମେନ୍‌ଦ କା ସାରିକେଦ୍‌ତେ ଦାଲଃଲେକା କାମିକେଦ୍‌ନିଃ ହୁଡିଙ୍ଗ୍‌ଲେକାଏ ଦାଲଃଆ । ଆଡଃ ପୁରାଃ ନାମାକାଦ୍‌କଏତେ ପୁରାଃ ଆସିୟଃଆ; ଆଡଃ ହଡ଼କ ପୁରାଃଗିକ ଏମାକାଇନିଃଏତେ ପୁରାଃଗିକ ଆସିୟା । ");
INSERT INTO unx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ଆଇଙ୍ଗ୍‌ ଅତେରେ ସେଙ୍ଗେଲ୍‌ ଜୁଲ୍‌ନାଙ୍ଗ୍‌ ହିଜୁଆକାନାଇଙ୍ଗ୍‌, ଆଡଃ ଆଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନାଇଙ୍ଗ୍‌, ଜାଲ୍‌ଦିଗି ସେଙ୍ଗେଲ୍‌ ଜୁଲଃକା । ");
INSERT INTO unx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ମେନ୍‌ଦ ମିଆଁଦ୍‌ ବାପ୍ତିସ୍ମାଏତେ ଆଇଙ୍ଗ୍‌କେ ବାପ୍ତିସ୍ମାଅଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଆଡଃ ଏନା ଆଉରିଚାବାଃଅ ଜାକେଦ୍‌ ଦୁକୁତେ ପୁରାଃଗିଇଙ୍ଗ୍‌ ବିତ୍‌ଲାଅକାନା । ");
INSERT INTO unx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ଚିୟାଃ ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ରେ ଜୀଉସୁକୁ ଏମ୍‌ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ମେନ୍ତେପେ ଆଟ୍‌କାରିଙ୍ଗ୍‌ତାନା ? ବାନଃଗି, ମେନ୍‌ଦ ବିନ୍‌ଗାଅ ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ହିଜୁଃକାନା । ");
INSERT INTO unx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ନାହାଁଃଏତେଦ ମିଆଁଦ୍‌ ପାରିବାର୍‌ରେନ୍‌ ପାଞ୍ଚ୍‌ଝାନ୍‌ ହଡ଼କ ବିନ୍‌ଗାଅଆଃକ, ତିନ୍‌ଝାନ୍‌ ବାର୍‌ହଡ଼୍‌କିନାଃ ବିରୁଧ୍‌ରେ ଆଡଃ ବାର୍‌ହଡ଼୍‌ ତିନ୍‌ଝାନ୍‌କଆଃ ବିରୁଧ୍‌ରେ । ");
INSERT INTO unx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ହନ୍‌କଡ଼ା ବିରୁଧ୍‌ରେ ଆପୁ, ଆଡଃ ଆପୁ ବିରୁଧ୍‌ରେ ହନ୍‌କଡ଼ା, ହନ୍‌କୁଡ଼ି ବିରୁଧ୍‌ରେ ଏଙ୍ଗା, ଆଡଃ ଏଙ୍ଗା ବିରୁଧ୍‌ରେ ହନ୍‌କୁଡ଼ି, କିମିନ୍‌ ବିରୁଧ୍‌ରେ ହାନାର୍‌ତେ ଆଡଃ ହାନାର୍‌ତେୟାଃ ବିରୁଧ୍‌ରେ କିମିନ୍‌ତେ, ବିନ୍‌ଗାଅଆଃକ ।” ");
INSERT INTO unx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କକେ କାଜିୟାଦ୍‌କଆଏ, ଆପେ ସିଙ୍ଗିହାସୁରଃସାଃଏତେ ରିମିଲ୍‌ ରାକାବ୍‌ତାନ୍‌ପେ ନେଲେତାନ୍ ଇମ୍‌ତା ଦାଆଃ ଗାମାୟାଏ ପେ ମେନେତାନା ଆଡଃ ନେକାଅଃ ତାନ୍‌ଗିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ଆଡଃ ଦାକ୍ଷିଣ୍‌ ହୟ ହୟତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ସିତୁଙ୍ଗ୍‌ୟେଁଆଏ ପେ ମେନେତାନା ଆଡଃ ନେକାଅଃ ତାନ୍‌ଗିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ଏ ବେଦାହଡ଼କ, ଆପେ ଅତେ ଆଡଃ ସିର୍ମାରେୟାଃ ଚିହ୍ନାଁପେ ଆଟ୍‌କାର୍‌ଉରୁମ୍‌ ଦାଡ଼ିୟାଃ ମେନ୍‌ଦ ନେ ଦିପିଲିରେୟାଃ ଚିହ୍ନାଁ ଚିଲ୍‌କା କାପେ ନେଲ୍‌ଉରୁମେତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ଚିନାଃମେନ୍ତେ ଠାଉକାନ୍‌ ଲେକାଗି ନେଲଃତେୟାଃ ଆପେଗି କାପେ ବିଚାରେତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ଆମାଃ ବାଇରିଲଃଦ ହାକିମ୍‌ତାମ୍‌ ସେନଃତାନ୍‌ରେ ଇନିଃଏତେ ଅଡଙ୍ଗ୍‌ଅଃ ନାଙ୍ଗ୍‌ ହରାରେଗି ଉଡ଼ୁଃଇମେ, କା'ରେଦ ଇନିଃ ବିଚାର୍‌ନିଃତାଃତେ ଥାଇଜ୍‌ଇଦିମେଁୟାଏ, ଆଡଃ ବିଚାର୍‌ନିଃ ସିପାଇକଆଃ ତିଃଇରେ ଜିମାମେଁୟା ଆଡଃ ସିପାଇଦ ଜେହେଲ୍‌ମେଁୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ଆଇଙ୍ଗ୍‌ କାଜିୟାମ୍‌ ତାନାଇଙ୍ଗ୍‌, ତାମ୍ବା ସିକା କାଉଡ଼ି କାଉଡ଼ି ଆଉରି ହାଲ୍‌ଚାବାଏ ଜାକେଦ୍‌ ଏନ୍ତାଃଏତେ କାମ୍‌ ଅଡଙ୍ଗ୍‌ ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ଏନ୍‌ ଦିପିଲିରେ ଚିମ୍‌ନାଙ୍ଗ୍‌ ହଡ଼କ ହିଜୁଆକାନ୍‌ ତାଇକେନାକ, ଇନ୍‌କୁ ଏନ୍‌ ଗାଲିଲ୍‌ରେନ୍‌କଆଃ କାଜି ୟୀଶୁକେ କାଜିକିୟାକ, ପିଲାତୁସ୍ଦ ଚିଲ୍‌କା ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ବିଶ୍ୱାସ୍‌ ତାନ୍‌କଆଃ ମାୟୋମ୍‌ ଦାଣେଁରାକାବ୍‌ ଜାଁତୁକଆଃ ମାୟୋମ୍‌ଲଃ ମେସାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଚିୟାଃ ନେ ଗାଲିଲ୍‌ରେନ୍‌କ ସବେନ୍‌ ଗାଲିଲ୍‌ରେନ୍‌ କଆଃଏତେ ଆଦ୍‌କା ପାପିକ ତାଇକେନ୍‌ ନାଗେନ୍ତେ ନେ ଦୁକୁକ ସାହାତିଙ୍ଗ୍‌କେଦାଃ, ନେଆଁଁପେ ଆଟ୍‌କାରେ ତାନାଚି ? ");
INSERT INTO unx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ବାନଃଗି ମେତାପେତାନାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଆପେ ପାପ୍‌ହେତେ କାପେ ମନ୍‌ରୁହାଡ଼୍‌ ରେଦ ଆପେ ସବେନ୍‌କ ନେ ଲେକାଗି ଜିୟନଃଆପେ । ");
INSERT INTO unx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ଆଡଃ ଶିଲୋହରେ ଦାର୍‌ୱାନ୍‌ ଅଡ଼ାଃ ଏନ୍‌ ଆଠ୍‌ରା ଝାନ୍‌ ହଡ଼କରେ ଉୟୁଃୟାନା ଆଡଃ ଇନ୍‌କୁକେ ଗଏଃକେଦ୍‌କଆଏ, ଇନ୍‌କୁଆଃ ବିଷାଏରେ ଚିନାଃପେ ଉଡ଼ୁଃତାନା ? ଚିୟାଃ ଇନ୍‌କୁ ସବେନ୍‌ ଯୀରୁଶାଲେମ୍‌ରେନ୍‌କଏତେ ଆଦ୍‌କା ପାପିକ ତାଇକେନା ମେନ୍ତେଚିପେ ଆଟ୍‌କାରେ ତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ବାନଃଗି ମେତାପେ ତାନାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଆପେ ପାପ୍‌ହେତେ କାପେ ମନ୍‌ରୁହାଡ଼େରେଦ ଆପେ ସବେନ୍‌କ ନେ ଲେକାଗି ଜିୟନଃଆପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଏନ୍ତେ ୟୀଶୁ ନେ ଜନ୍‌କା କାଜି କାଜିକେଦାଏ, “ଜେତାଏ ମିଆଁଦ୍‌ହଡ଼ ଆୟାଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ିରେ ମିଆଁଦ୍‌ ଲଆଦାରୁ ରୟାକାଦ୍‌ ତାଇକେନାଏ, ଆଡଃ ଇନିଃ ଏନାରେ ଜ ନାମେନାଗେନ୍ତେ ହିଜୁଃୟାନାଏ, ମେନ୍‌ଦ ମିଆଁଦ୍‌ ହ ଜ କାଏ ନାମ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ଏନାମେନ୍ତେ ଇନିଃ ମାଳିହଡ଼କେ କାଜିକିୟାଏ, ‘ନେଲେମେ ଆପି ସିର୍ମାଏତେ ନେ ଲଆଦାରୁରେ ଜ ନାମେନାଗେନ୍ତେ ହିଜୁଃତାନାଇଙ୍ଗ୍‌ ମେନ୍‌ଦ କାଇଙ୍ଗ୍‌ ନାମେତାନା, ଏନା ମାଏଃମେ, ଚିକାନାଙ୍ଗ୍‌ ଅତେ ଏସେରେତାନାଏ ?’ ");
INSERT INTO unx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ମେନ୍‌ଦ ମାଳିହଡ଼ କାଜିକେଦାଏ, ‘ହେ ଗମ୍‌କେ, ଏନାକେ ନେ ସିର୍ମାହଗି ତାଇରିକାଏମେଁ, ଆଇଙ୍ଗ୍‌ ଏନାକେ ଉର୍‌ବିହୁର୍‌କେଦ୍‌ତେ ସାରାହାସା ପେରେଜେୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ଇଦୁ ହିଜୁଃସିର୍ମା ନେଆଁଁରେ ଜ ନାମ୍‌ ସାକାଅଆଃ, କା'ରେଦ ତାୟମ୍‌ତେ ଏନାକେ ମାଆଃଇଚିମେ ।’” ");
INSERT INTO unx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ୟୀଶୁ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ମିଆଁଦ୍‌ ଯିହୁଦୀକଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ଇତୁକତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ଆଡଃ ନେଲେପେ ଏନ୍ତାଃରେ ଆଠ୍‌ରା ବାରାଷ୍‌ଏତେ ମିଆଁଦ୍‌ କୁଡ଼ିକେ ଏତ୍‌କାନ୍‌ ଆତ୍ମା ଏସେରାକାଇତେ ନାରାଦୁରାଇତାନ୍‌ ତାଇକେନାଏ, ଇନିଃ ଉଙ୍ଗୁଦ୍‌କେଦ୍‌ତେ ତାଇକେନାଏ, ଜେତାଲେକାତେ ସିଧାତିଙ୍ଗୁଃ କାଏ ଦାଡ଼ିତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ୟୀଶୁ ଇନିଃକେ ନେଲ୍‌କିୟାଏ ଆଡଃ ନାଡ଼େଃତେ ହାକାଅତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ଏ କୁଡ଼ି, ଆମାଃ ନାରାଦୁରା ଦୁକୁଏତେ ବୁଗିକାନାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ଆଡଃ ୟୀଶୁ ଇନିଃରେ ତିଃଇ ଦହକେଦାଏ ଆଡଃ ଇନିଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ବୁଗିନ୍‌ୟାନାଏ, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାରାଙ୍ଗ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ୟୀଶୁ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ବୁଗିକିୟାଏ ନେଆଁଁତେ ସାମାଜ୍‌ଅଡ଼ାଃରେନ୍‌ ଆଗୁଆଇ ଖିସ୍‌ୟାନାଏ, ଆଡଃ ହଡ଼କକେ କାଜିକେଦ୍‌କଆଏ, “ଛ'ମାହାଁ ମେନାଃ ଏନାରେ କାମି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌କରେ ବୁଗିନଃ ନାଗେନ୍ତେ ହିଜୁଃପେ, ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେଦ କାହା ।” ");
INSERT INTO unx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ମେନ୍‌ଦ ପ୍ରାଭୁ ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟା, “ଆପେ ସବେନ୍‌ ବେଦାହଡ଼କ, ଚିୟାଃ ଆପେ ସବେନ୍‌କ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଆପେୟାଃ ଉରିଃକ୍‌ ଚି ଗାଧାକକେ ଗଣାଁଏତେ ରାଡ଼ାକେଦ୍‌ତେ ଦାଆଃ ନୁଁ ତେ କାପେ ଇଦିକତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ଆଡଃ ନେ କୁଡ଼ିହନ୍‌ଦ ଆବ୍ରାହାମ୍‌ଆଃ କୁଡ଼ିହନ୍‌ ତାନିଃ, ନେଲିପେ ଇନିଃ ସାଏତାନ୍‌ରାଃ ତନଲ୍‌ରେ ଆଠ୍‌ରା ବାରାଷ୍‌ ତଲାକାଇତାଇନାଏ, ଚିୟାଃ ଇନିଃକେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଏନାଏତେ ରାଡ଼ାଇତେୟାଃ କା ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା ?” ");
INSERT INTO unx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ୟୀଶୁ ନେଆଁଁ କାଜିକେଦ୍‌ ଇମ୍‌ତା, ଇନିୟାଃ ସବେନ୍‌ ମୁଦାଇକ ଗିହୁଃୟାନାକ ମେନ୍‌ଦ ହଡ଼କ ୟୀଶୁଆଃ ଆକ୍‌ଦାନ୍ଦାଅକାମି ନେଲ୍‌କେଦ୍‌ତେ ରାସ୍‌କାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ଏନ୍ତେ ୟୀଶୁ କୁଲିକେଦାଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଚିନାଃ ଲେକା ? ଆଇଙ୍ଗ୍‌ ଏନାକେ ଚିନାଃତେଗିଇଙ୍ଗ୍‌ ଜକାଏୟା ? ");
INSERT INTO unx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ଏନା ମିଆଁଦ୍‌ ମାନିଜାଙ୍ଗ୍‌ଲେକା, ଏନା ମିଆଁଦ୍‌ ହଡ଼ ଇଦିକେଦ୍‌ତେ ଆୟାଃ ବାଖ୍‌ଡ଼ିରେ ହେର୍‌କେଦାଏ, ଏନା ହାରାୟାନା ଆଡଃ ମାରାଙ୍ଗ୍‌ ଦାରୁୟାନା, ସିର୍ମାରେନ୍‌ ଚେଣେଁକ ଏନାରାଃ କତକରେକ ଥକାକେଦା ।” ");
INSERT INTO unx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଆଡଃଗି ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଚିନାଃତେଗିଇଙ୍ଗ୍‌ ଜକାଏୟା ? ");
INSERT INTO unx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ଏନା ରାନୁ ଲେକାଃ, ଏନା ଜେତା କୁଡ଼ି ଏନା ଆଉକେଦ୍‌ତେ ତିନ୍‌ କେଜି ମାଇଦାରେ ଏନା ଆଉରି ରାନୁଚାବାଅଃ ଜାକେଦ୍‌ ସିପୁଦ୍‌କେଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ୟୀଶୁ ଇତୁକତାନ୍‌ଲଃ ସାହାର୍‌ ସାହାର୍‌ ଆଡଃ ହାତୁ ହାତୁ ପାରମ୍‌ୟାନ୍ତେ ଯୀରୁଶାଲେମ୍‌ସାଃ ସେନଃତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ଜେତାଏମିହୁଡ଼୍‌ କୁଲିକିୟାଏ, “ହେ ପ୍ରାଭୁ ଚିୟାଃ ବାଞ୍ଚାଅଃ ହଡ଼କ କାଟିଃଲେକାଃକ ?” ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ରେସେଦ୍‌ ଦୁଆର୍‌ତେ ବଲଃନାଗେନ୍ତେ ଚିହୁଲାନ୍‌ପେ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଏନାରେ ବଲନାଙ୍ଗ୍‌ ପୁରାଃ ହଡ଼କ ସାନାଙ୍ଗ୍‌ଆଃ ମେନ୍‌ଦ କାକ ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଆଡଃ ଗୁସିୟାଁ ବିରିଦ୍‌ୟାନ୍ତେ ଦୁଆର୍‌ ହାଣ୍ଡେଦ୍‌ତାରେ, ତାୟମ୍‌ତେ ଆପେ ରାଚାରେପେ ତିଙ୍ଗୁନାଃ ଆଡଃ ଦୁଆର୍‌ରେପେ ଠକ୍‌ଠକାଏୟା ଆଡଃ ‘ହେ ପ୍ରାଭୁ ନିଜାଲେମ୍‌’ ମେନେୟା, ମେନ୍‌ଦ ଇନିଃ ମେତାପେୟାଏ, ‘ଆପେ କତାଃରେନ୍‌କ ତାନ୍‌ପେ ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ଏନ୍ତେ ଆପେ ମେନେୟା, ଆଲେ ଆମାଃଲଃ ଜମ୍‌ ଆଡଃ ନୁଁ ତାଇନାଲେ ଆଡଃ ଆମ୍‌ ଆଲେୟାଃ ହରାକରେ ଇତୁକେଦ୍‌ଲେୟାମ୍ । ");
INSERT INTO unx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ମେନ୍‌ଦ ଇନିଃ ମେନେୟାଏ, ‘ଆପେ ଅକଏ ଆଡଃ କତାଃରେନ୍‌କ ତାନ୍‌ପେ ଏନା କାଇଙ୍ଗ୍‌ ସାରିୟାଃ, ଏ ଏତ୍‌କାନ୍‌ କାମିକେନ୍‌କ, ଆପେ ସବେନ୍‌ ଆଇଙ୍ଗ୍‌ତାଃଏତେ ଆତମଃପେ । ");
INSERT INTO unx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ଆପେ ଚିମ୍‌ତା ଆବ୍ରାହାମ୍‌, ଇସାକ୍‌, ଯାକୁବ୍‌ ଆଡଃ ସବେନ୍‌ ନାବୀକକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ଦୁବାକାନ୍‌ ଆଡଃ ଆପେକେ ବାହାରିରେ ଅଡଙ୍ଗ୍‌ଆଁକାନ୍‌ ତେୟାଃପେ ନେଲେୟା । ଇମ୍‌ତା ଏନ୍ତାଃରେ ରାନାଆଃ ଆଡଃ ଡାଟା ହାବ୍‌ ରିଡିଦଃଆ, ");
INSERT INTO unx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ହଡ଼କ ପୁରାବ୍‌ ଆଡଃ ପାଶ୍ଚିମ୍‌, ଉତ୍ତାର୍‌ ଆଡଃ ଦାକ୍ଷିଣ୍‌ସାଃଏତେ ହିଜୁଃକେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ଜଜମ୍‌ ନାଙ୍ଗ୍‌କ ଦୁବାଃ । ");
INSERT INTO unx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ଆଡଃ ନେଲେପେ, ସାର୍‌ତିଗି, ତାୟମ୍‌ରେନ୍‌କ ଆୟାରଃଆ ଆଡଃ ଆୟାର୍‌ରେନ୍‌କ ତାୟମଃଆ ।’” ");
INSERT INTO unx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ଏନ୍‌ ଦିପିଲିରେଗି ଚିମିନ୍‌ ଫାରୁଶୀକ ହିଜୁଃୟାନ୍ତେ ୟୀଶୁକେ କାଜିକିୟାଃକ, “ନେତାଃଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନଃମେ, ହେରୋଦ୍‌ ଆମ୍‌କେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, “ଜୁ ନେଆଁଁ ଏନ୍‌ ତୁୟୁକେ କାଜିୟାଇପେ, ‘ଆଇଙ୍ଗ୍‌ ତିସିଙ୍ଗ୍‌ ଆଡଃ ଗାପା ବଙ୍ଗାକଇଙ୍ଗ୍‌ ଅଡଙ୍ଗ୍‌କଆ ଆଡଃ ଦୁକୁଆକାନ୍‌କଇଙ୍ଗ୍‌ ବୁଗିକଆ ଆଡଃ ଆପି ମାହାଁରେଇଙ୍ଗ୍‌ ସେକାଡ଼ଃଆ ।’ ");
INSERT INTO unx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ଏନ୍‌ରେୟ ତିସିଙ୍ଗ୍‌ ଆଡଃ ଗାପା ଆଡଃ ମେୟାଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌କେ ହନର୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ସାର୍‌ତିଗି ଜେତାଏ ନାବୀ ଯୀରୁଶାଲେମ୍‌ ଏତେ ଏଟାଃ ଜାଗାରେ ଗଜଃ କା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ହେ ଯୀରୁଶାଲେମ୍‌, ହେ ଯୀରୁଶାଲେମ୍‌ ଆମ୍‌ ନାବୀକକେମ୍‌ ଗଏଃକେଦ୍‌କଆ ଆଡଃ ଆମ୍‌ତାଃତେ କୁଲାକାନ୍‌କକେ ଚିଦ୍‌ଗିଗଏଃ କେଦ୍‌କଆମ୍‌, ଏଙ୍ଗାସିମ୍‌ ଆୟାଃ ହନ୍‌କକେ ଆପ୍‌ରବ୍‌ ଲାତାର୍‌ରେ ଆବ୍‌ରୁମ୍‌ ତପାକତାନ୍‌ଲେକା ଚିମିନ୍‌ସା ଆଇଙ୍ଗ୍‌ ଆମାଃ ହନ୍‌କକେ ହୁଣ୍ଡିସାନାଙ୍ଗ୍‌କେଦାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଆପେ କାପେ ସାନାଙ୍ଗ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ନେଲେପେ, ଆପେୟାଃ ମାନ୍ଦିର୍‌ ଆପେତାଃରେ ହାଦୁଡ଼୍‌ନାଙ୍ଗ୍‌ ବାଗିୟଃତାନା । ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ‘ପ୍ରାଭୁଆଃ ନୁତୁମ୍‌ତେ ହିଜୁଃତାନ୍‌ନିଃକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଶିଷ୍‌ ଏମାଇକାଏ ମେନ୍ତେ ଆପେ ଆଉରି କାଜି ଜାକେଦ୍‌ ନାହାଁଃଏତେ ଆଡଃ ଆଇଙ୍ଗ୍‌କେ କାପେ ନେଲିୟାଁଃ ।’” ");
INSERT INTO unx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ମୁସିଙ୍ଗ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ୟୀଶୁ ଫାରୁଶୀକଆଃ ମିଆଁଦ୍‌ ଆଗୁଆଇରାଃ ଅଡ଼ାଃରେ ହଲଙ୍ଗ୍‌ ଜଜମ୍‌ନାଙ୍ଗ୍‌ ସେନଃୟାନାଏ ଆଡଃ ଇନିଃକେ ଲଡଇତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ନେଲେପେ, ମିଆଁଦ୍‌ କାଟା ତିଃଇ ମଁଃ'ତାନ୍‌ ହଡ଼ ଇନିୟାଃ ଆୟାର୍‌ତେ ହିଜୁଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ୟୀଶୁ “ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ବୁଗି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଚି କା” ମେନ୍ତେ ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକକେ କୁଲିକେଦ୍‌କଆଏ । ମେନ୍‌ଦ ଇନ୍‌କୁ ହାପାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ଆଡଃ ୟୀଶୁ ଏନ୍‌ ହଡ଼କେ ସାବ୍‌ତାନ୍‌ଲଃ ବୁଗିକିୟାଏ ଆଡଃ କୁଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆ, “ଆପେକଏତେ ଜେତାଏରାଃ ହନ୍‌କଡ଼ା ଚାଏ ଉରିଃକ୍‌ କୁଆଁରେ ଉୟୁଃକରେ ଚିୟାଃ ଇନିଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ କାଏ ଅଡଙ୍ଗ୍‌ଇଁୟା ?” ");
INSERT INTO unx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ଆଡଃ ଇନ୍‌କୁ ନେ ସବେନ୍‌ କାଜିନାଙ୍ଗ୍‌ ଇନିଃକେ କାକ କାଜିରୁହାଡ଼୍‌ ଦାଡ଼ିୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ୟୀଶୁ କେଡ଼ାକାନ୍‌ ହଡ଼କକେ ଚେତାନ୍‌ଠାୟାଦ୍‌ ସାଲାତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ, ନେ ଜନ୍‌କା କାଜି ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆ, ");
INSERT INTO unx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ଜେତାଏ ହଡ଼ ଆଣ୍‌ଦି ଜମେୟାଁଃରେ କେଡ଼ାମେରେଦ ଚେତାନ୍‌ ଠାୟାଦ୍‌ରେ ଆଲ୍‌ମେ ଦୁବାଃ, ଇଦୁ ଇନିଃ ଆମାଃଏତେ ଆଦ୍‌କା ମାଇନାନ୍‌ ହଡ଼କେ କେଡ଼ାକାଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ଆମ୍‌ ଆଡଃ ଇନିଃକେ କେଡ଼ାକେଦ୍‌ମେନିଃ ହିଜୁଃଲେନ୍‌ତେ, ‘ମାର୍‌ ନେ ଠାୟାଦ୍‌ରେ ନେ ହଡ଼କେ ଦୁବ୍‌ଇଚିମେଁ’ ମେତାମେଁୟାଏ, ଏନ୍ତେ ଆମ୍‌ ଗିହୁଃୟାନ୍ତେ ସବେନ୍‌ଏତେ ଲାତାର୍‌ ଠାୟାଦ୍‌ରେମ୍‌ ଦୁବାଃ । ");
INSERT INTO unx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ମେନ୍‌ଦ ଆମ୍‌ କେଡ଼ାଅଃରେ କେଡ଼ାକାଦ୍‌ମେନିଃ ହିଜୁଃକେଦ୍‌ତେ, ‘ଏ ଗାତି ଚେତାନ୍‌ରେ ଦୁବ୍‌ମେଁ’ ମେତାମେଁକାଏ ମେନ୍ତେ ସବେନାଃଏତେ ଲାତାର୍‌ ଠାୟାଦ୍‌ରେ ସେନ୍‌କେଦ୍‌ତେ ଦୁବ୍‌ମେଁ, ଏନ୍ତେ ଆମାଃଲଃ ଜଜମ୍‌ ଦୁବାକାନ୍‌କଆଃ ଆୟାର୍‌ରେମ୍‌ ମାଇନଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ଜେତାଏ ମାରାଙ୍ଗ୍‌ୟେଁନ୍‌ନିଃଦ ହୁଡିଙ୍ଗ୍‌ୟଁଃଆଏ ଆଡଃ ଜେତାଏ ହୁଡିଙ୍ଗ୍‌ୟଃଁନିଃଦ ମାରାଙ୍ଗ୍‌ଆଁଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ଏନ୍ତେ ୟୀଶୁ କେଡ଼ାକେନ୍‌ନିଃକେ କାଜିକିୟାଏ, “ଆମ୍‌ ସିଙ୍ଗିରେୟା ଚାଏ ଆୟୁବ୍‌ରେୟାଃ ଜମେୟାଃ ବାଇରେଦ, ଆମାଃ ଗାତିକକେ ଚି ହାଗାକକେ ଚି କୁପୁଲ୍‌କକେ ଚି ହପର୍‌ଜାପାଃରେନ୍ କିସାଁଣ୍‌କକେ ଆଲମ୍‌ କେଡ଼ାକଆ, କା'ରେଦ ଇନ୍‌କୁ କେଡ଼ାରୁହାଡ଼୍‌ମେଁୟାକ ଆଡଃ ନେଆଁଁଗି ଆମାଃ ଜ ନାମଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ମେନ୍‌ଦ ଆମ୍‌ ମାରାଙ୍ଗ୍‌ ଜମେୟାଁଃମ୍ ବାଇରେଦ, ରେଙ୍ଗେଃକକେ, ଟୁଣ୍ଟାକକେ, କେପାକକେ ଆଡଃ କାଣାଁକାନ୍‌କକେ କେଡ଼ାକମେ, ");
INSERT INTO unx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ଆଡଃ ଆମ୍‌ ଧାଇନଃଆମ୍‌, ଇନ୍‌କୁଦ କାକ ଏମ୍‌ରୁହାଡ଼୍‌ ଦାଡ଼ିୟାମେଁୟା ମେନ୍‌ଦ ଧାର୍‌ମାନ୍‌କଆଃ ଜୀଉବିନିରିଦ୍‌ରେ ଜ ନାମେୟାମ୍ ।” ");
INSERT INTO unx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ୟୀଶୁଲଃ ଦୁବାକାନ୍‌କଏତେ ମିଆଁଦ୍‌ ହଡ଼ ନେ କାଜି ଆୟୁମ୍‌କେଦା, ଇନିଃ ୟୀଶୁକେ କାଜିକିୟାଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ଜମେନିଃ ସୁକୁତାନ୍‌ଗିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ମିଆଁଦ୍‌ ହଡ଼ ମାରାଙ୍ଗ୍‌ ଜମେୟାଃଁ ବାଇକେଦାଏ ଆଡଃ ପୁରାଃଗି ହଡ଼କକେ କେଡ଼ାକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ଜଜମ୍ ନେଡାରେ ଇନିଃ, ମାର୍‌ ହିଜୁଃପେ, ସବେନାଃ ସେକାଡ଼ାକାନା ମେତାକୁମ୍ ମେନ୍ତେ ଆୟାଃ ଦାସିକେ କେଡ଼ାକାନ୍‌କତାଃ କୁଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ମେନ୍‌ଦ କେଡ଼ାକାନ୍‌କ ମିଆଁଦ୍‌ ମନ୍‌ୟାନ୍ତେ ଛାମା ଆସିକ ଏଟେଦ୍‌କେଦା । ସିଦାନିଃ, ‘ଅତେଇଙ୍ଗ୍‌ କିରିଙ୍ଗ୍‌ଆଃକାଦା ଆଡଃ ସେନ୍‌କେଦ୍‌ତେ ଏନାକେ ନେନେଲ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଆଇଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଛାମା ଆସିମେ’ ମେନ୍ତେ ବିନ୍ତିମେତାନାଇଙ୍ଗ୍‌ ମେନ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ଆଡଃ ଏଟାଃନିଃ, ପାଞ୍ଚ୍‌ ଆଡ଼୍‌ନା ଉରିଃକ୍‌କଇଙ୍ଗ୍‌ କିରିଙ୍ଗ୍‌କାଦ୍‌କଆ ଆଡଃ ଇନ୍‌କୁକେ ଆଟ୍‌କାର୍‌ଉରୁମ୍‌ ନାଗେନ୍ତେ ସେନଃତାନାଇଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ନାଙ୍ଗ୍‌ ଛାମା ଆସିମେ ମେନ୍ତେ ବିନ୍ତିମେଁ ତାନାଇଙ୍ଗ୍‌ ମେନ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ଏଟାଃନିଃ, ‘ଆଇଙ୍ଗ୍‌ ଆଣ୍‌ଦିୟାକାନାଇଙ୍ଗ୍‌, ଏନାନାଗେନ୍ତେ କାଇଙ୍ଗ୍‌ ସେନ୍‌ଦାଡ଼ିୟାଃ’ ମେନ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“ଏନ୍‌ ଦାସି ହିଜୁଃକେଦ୍‌ତେ ଗମ୍‌କେ ତାୟାଃକେ ନେ ସବେନ୍‌ ଉଦୁବ୍‌କିୟାଏ । ଏନ୍ତେ ଅଡ଼ାଃ ଗମ୍‌କେ ଖିସ୍‌କେଦ୍‌ତେ ‘ହାତୁରେୟାଃ ଚାକାର୍ ଆଡଃ ରେସେଦ୍‌ ହରାକତେ ସେନଃମେ ଆଡଃ ରେଙ୍ଗେଁଃତାନ୍‌କକେ ଆଡଃ ଟୁଣ୍ଟାକାନ୍‌କକେ ଆଡଃ କେପାକକେ ଆଡଃ କାଣାଁକାନ୍‌କକେ ନେତାଃ ଆଉକୁମ୍’ ମେନ୍ତେ ଏନ୍‌ ଦାସିକେ କାଜିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ଆଡଃ ଏନ୍‌ ଦାସି କାଜିକିୟାଏ, ‘ହେ ଗମ୍‌କେ, ଆମ୍‌ ଆଚୁଆକାଦ୍‌ଲେକା ବାଇୟାନା ମେନ୍‌ଦ ନାହାଁଃହଁ ଠାୟାଦ୍ ମେନାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ଏନ୍ତେ ଅଡ଼ାଃ ଗୁସିୟାଁ ଆୟାଃ ଦାସିକେ କାଜିକିୟାଏ, ‘ଜୁ ସେନଃମେ, ଆଡଃ ନାଗାର୍‌ରେୟାଃ ହରା ଗେନାକଏତେ, କଚାକଏତେ ହଡ଼କକେ କେଡ଼ା ଆଉକମେ, ଆଡଃ ଆଇଁୟାଃ ଅଡ଼ାଃକେ ହଡ଼ତେ ପେରେଜ୍‌କମେ । ");
INSERT INTO unx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ଆଇଙ୍ଗ୍‌ଦଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଏନ୍‌ କେଡ଼ାକାନ୍‌କଏତେ ଜେତାଏ ଆଇଁୟାଃ ଜମେୟାଃଁ କାକ ଚାଖାଅୟାଃ ।’” ");
INSERT INTO unx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ମିସା ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ୟୀଶୁଲଃ ସେନଃତାନ୍‌କ ତାଇକେନା, ଆଡଃ ଇନିଃ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ଜେତାଏ ହଡ଼ ଆଇଙ୍ଗ୍‌ତାଃତେ ହିଜୁଃରେଦ ଆୟାଃ ଆପୁ ଆଡଃ ଏଙ୍ଗା, କୁଡ଼ି ଆଡଃ ହନ୍‌କ, ହାଗାକ ଆଡଃ ମିଶିକ, ହେଗି ଆୟାଃ ଜୀଉକେହ ଆଇଙ୍ଗ୍‌ଏତେ ଆଦ୍‌କା ଦୁଲାଡ଼୍‌ରେଦ ଇନିଃ ଆଇଁୟାଃ ଚେଲା କାଏ ହବାଦାଡ଼ିୟଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଆଡଃ ଜେତାଏ ଆୟାଃ କ୍ରୁଶ୍‌ ଗଅଃକେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌କେ କାଏ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ରେଦ, ଇନିଃ ଆଇଁୟାଃ ଚେଲା କାଏ ହବାଦାଡ଼ିୟଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“ଆପେକଏତେ ଗୁମ୍ମାଟ୍‌ ବାବାଇ ସାନାଙ୍ଗ୍‌ନିଃ ଚି ସିଦାରେ ଦୁବ୍‌କେଦ୍‌ତେ ଏନାକେ ବାଇଟୁଣ୍ଡୁ ନାଗେନ୍ତେ ଇଦୁ ଆଇଁୟାଃତାଃରେ ଲାଗାତିଙ୍ଗ୍‌ ପାଏସା ମେନାଃ ଚି କା ମେନ୍ତେ କାଏ ଲେକାୟା ? ");
INSERT INTO unx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","କା'ରେଦ ଇନିଃ ନିହିଁଗାଡ଼ାକେ ପାଟାଅକେଦ୍‌ତେ ଟୁଣ୍ଡୁକାଏ ଦାଡ଼ିରେଦ ସବେନ୍‌ ନେନେଲ୍‌ ହଡ଼କ ଇନିଃକେ ଲାନ୍ଦାଇୟାକ । ");
INSERT INTO unx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ନେ ହଡ଼ ବାବାଇ ଏଟେଦ୍‌କେଦାଏ ମେନ୍‌ଦ ଟୁଣ୍ଡୁ କାଏ ଦାଡ଼ିକେନା ମେନ୍ତେକ ମେନେୟା । ");
INSERT INTO unx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“ଆଡଃ ଜେତା ରାଜା ଗେଲ୍‌ ହାଜାର୍‌ ପାଲ୍‌ଟାନ୍‌କକେ ସାବ୍‌କେଦ୍‌ତେ ଅକଏୟାଃଚି କୋଡ଼ିଏ ହାଜାର୍‌ ପାଲ୍‌ଟାନ୍‌ ମେନାକଆଃ ଏନ୍‌ ରାଜାଲଃ ମାପାଃତୁପୁଇଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଅଡଙ୍ଗ୍‌ଅଃ ସିଦାରେ ଏନ୍‌ ରାଜାଏତେ ପୁରାଃ କେଟେଦ୍‌ ମେନାଇୟାଃଚି କାହା ମେନ୍ତେ ଇନିଃ ଚିନାଃ ଦୁବ୍‌କେଦ୍‌ତେ କାଏଚି ଉଡ଼ୁଃଇୟା ? ");
INSERT INTO unx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","କାଏ ଦାଡ଼ିରେଦ, ଏଟାଃ ରାଜା ସାଙ୍ଗିନ୍‌ରେ ତାଇନ୍‌ ଇମ୍‌ତାଗି ଇନିଃ କାଜିଇଦିନିଃକେ କୁଲ୍‌କେଦ୍‌ତେ ସୁକୁଜୀଉରେ ତାଇନଃ ନାଙ୍ଗ୍‌ ବିନ୍ତିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ନେ ଲେକାତେ ଆପେକଏତେ ଜେତାଏ ଆକଆଃ ସବେନ୍‌ ମେନାଃତେୟାଃ କାକ ବାଗିରେଦ ଆଇଁୟାଃ ଚେଲା କାକ ହବାଦାଡ଼ିୟଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ବୁଲୁଙ୍ଗ୍‌ ବୁଗିନାଃ, ମେନ୍‌ଦ ବୁଲୁଙ୍ଗ୍‌ ସାବାଗଃରେଦ ଏନା ଚିଲ୍‌କାତେ ଆଡଃମିସା ସିବିଲ୍‌ରୁହାଡ଼ଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ଏନା ଅତେନାଙ୍ଗ୍‌ ଚାଏ ସାରାଗାଡା ନାଗେନ୍ତେୟ କାମିରେ କା ହିଜୁଃଆ; ହଡ଼କ ଏନାକେ ଏଣ୍ଡାଃୟାକ । ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଲୁତୁର୍ ମେନାଃନିଃ ଆୟୁମେକାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ମୁସିଙ୍ଗ୍‌ ହୁଲାଙ୍ଗ୍‌ ସବେନ୍‌ ମାଲ୍‌ହାରମ୍‌କ ଆଡଃ ପାପି ହଡ଼କ ୟୀଶୁଆଃ କାଜି ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଇନିଃତାଃତେ ହିଜୁଃତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ମେନ୍‌ଦ ଫାରୁଶୀକ ଆଡଃ ଆଇନ୍‌ ଇତୁକ କୁରୁମ୍‌ଡୁରୁମ୍‌ୟାନ୍‌ଲଃ ମେନ୍‌କେଦାଃକ, “ନିଃ ପାପିକକେ ସୁକୁଆକୁତାନାଏ ଆଡଃ ଆକଆଃଲଃ ଜମେତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ ନେ ଜନ୍‌କା କାଜି ଉଦୁବାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ଆପେକଏତେ ଜେତାଏୟାଃ ମଣେଁହିସି ମିଣ୍ଡିକ ତାଇନ୍‌ରେଦ ଆଡଃ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ ଆଦଃରେଦ ଚିୟାଃ ଇନିଃ ଏନ୍‌ ଉପୁନ୍‌ହିସି ଗେଲ୍‌ଅରେୟା ମିଣ୍ଡିକକେ ବିର୍‌ରେ କାଏ ବାଗିକଆ ଆଡଃ ଏନ୍‌ ଆଦାକାନ୍‌ନିଃକେ ଆଉରିନାମି ଜାକେଦ୍‌ କାଏଚି ଦାଣାଁଁବାଡ଼ାଇୟା ? ");
INSERT INTO unx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ଆଡଃ ଇନିଃକେ ନାମ୍‌ତାଇରେଦ ରାସ୍‌କାତାନ୍‌ଲଃ ଆୟାଃ ତାରାନ୍‌ରେୟାଏ ଗଅଃଆଉୱିୟା, ");
INSERT INTO unx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ଆଡଃ ଅଡ଼ାଃତେ ହିଜୁଃକେଦ୍‌ତେ ଆୟାଃ ଗାତିକକେ ଆଡଃ ହପର୍‌ଜାପାଃରେନ୍‌କକେ କେଡ଼ାହୁଣ୍ଡିକେଦ୍‌ତେ ‘ଆଇଁୟାଃଲଃ ରାସ୍‌କାନ୍‌ପେ, ଆଇଁୟାଃ ଆଦାକାନ୍‌ ମିଣ୍ଡିକେଇଙ୍ଗ୍‌ ନାମ୍‌ରୁହାଡ଼୍‌କିୟା’ ମେତାକଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ନେ ଲେକାଗି ମନ୍‌ରୁହାଡ଼୍‌ କା ଲାଗାତିଙ୍ଗ୍‌ ଉପୁନ୍‌ହିସି ଗେଲ୍‌ଅରେୟା ଧାର୍‌ମାନ୍‌କଏତେ ଆଦ୍‌କା ମିଆଁଦ୍‌ ମନ୍‌ରୁହାଡ଼୍‌ତାନ୍‌ ପାପି ନାଗେନ୍ତେ ସିର୍ମାରେନ୍‌କ ରାସ୍‌କାଅଆଃକ । ");
INSERT INTO unx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ଚାଏ ଜେତାଏ କୁଡ଼ିରାଃ ଗେଲ୍‌ ସିକା ମେନାଃରେଦ ଆଡଃ ମିଆଁଦ୍‌ ଆଦଃରେଦ, ଚିୟାଃ ଇନିଃ କାଏ ଦିମିୟା ଆଡଃ ଅଡ଼ାଃକେ କାଏ ଜଗେୟା ଆଡଃ ଆଉରି ନାମେଜାକେଦ୍‌ ଚିହୁଲ୍‌ତେ କାଏଚି ଦାଣାଁଁବାଡ଼ାୟା ? ");
INSERT INTO unx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ଆଡଃ ଏନା ନାମ୍‌କେଦ୍‌ରେ ଆୟାଃ ଗାତିକକେ ଆଡଃ ହପର୍‌ଜାପାଃରେନ୍‌କକେ କେଡ଼ାହୁଣ୍ଡିକେଦ୍‌ତେ, ଆଇଁୟାଃଲଃ ରାସ୍‌କାନ୍‌ପେ, ଆଇଁୟାଃ ଆଦାକାନ୍‌ ସିକାଇଙ୍ଗ୍‌ ନାମ୍‌ରୁହାଡ଼୍‌କାଦା ମେତାକଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ନେ ଲେକାଗି ମିଆଁଦ୍‌ ମନ୍‌ରୁହାଡ଼୍‌ତାନ୍‌ ପାପି ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଁତ୍‌କ ରାସ୍‌କାଅଆଃକ ।” ");
INSERT INTO unx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଏନ୍ତେ ୟୀଶୁ ଆଡଃଗି କାଜିକେଦାଏ, “ଜେତାଏ ହଡ଼ଆଃ ବାର୍‌ହଡ଼୍‌ କଡ଼ାହନ୍‌କିନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ଇନ୍‌କିନ୍‌ଏତେ ଲିଟା ହନ୍‌ କାଜିକିୟାଏ, ‘ହେ ଆବା, ମେନାଃତେୟାଃଏତେ ଆଇଁୟାଃ ହାଟିଙ୍ଗ୍‌ ଏମାଇଙ୍ଗ୍‌ମେ ।’ ଏନ୍ତେ ଏନ୍‌ ହଡ଼ ଆୟାଃ ମେନାଃତେୟାଃ ହାଟିଙ୍ଗ୍‌ଆଁଦ୍‌କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ଚିମିନ୍‌ ମାଃ ତାୟମ୍‌ତେ ଲିଟା ହନ୍‌ ଏନ୍‌ ସବେନାଃ ହୁଣ୍ଡିକେଦ୍‌ତେ ସାଙ୍ଗିନ୍‌ ଦିଶୁମ୍‌ତେ ସେନଃୟାନାଏ ଆଡଃ ଏନ୍ତାଃରେ ଏତ୍‌କାନ୍‌ କାମିକରେ ତାଇକେନା ଏନ୍ତେ ଆୟାଃ ସବେନାଃତେୟାଃ ଛିତିବିତିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ଇନିଃ ସବେନାଃ ଚାବାକେଦ୍‌ଚି, ଏନ୍‌ ଦିଶୁମ୍‌ରେ ପୁରାଃ ରିଙ୍ଗାୟାନା ଆଡଃ ଇନିଃ ରେଙ୍ଗେଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ଏନ୍ତେ ଇନିଃ ସେନଃୟାନ୍ତେ ଏନ୍‌ ଦିଶୁମ୍‌ରେନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ତାଃରେ ଦାସିତାଇକେନାଏ, ଏନ୍‌ ହଡ଼ ଆୟାଃ ପିଡ଼ିରେ ସୁକୁରି ଗୁପିତେ ଇନିଃକେ କୁଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ଆଡଃ ଇନିଃ ସୁକୁରି ଜମ୍‌ତେୟାଃ ଆୟାଃ ଲାହିଦ୍‌ ବିଏ ସାନାଙ୍ଗ୍‌ତାନ୍ ତାଇକେନାଏ ଆଡଃ ଜେତାଏ ଇନିଃକେ କାକ ଏମାଇତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ଏନ୍ତେ ଇନିଃ ପାହାମ୍‌ ରୁହାଡ଼୍‌କେଦ୍‌ତେ କାଜିକେଦାଏ, ପୁରାଃଗି ସାରେଜ୍‌ଉତାରଃ ଲେକା ଜମେୟାଃଁ ଆପୁଇଁୟାଃ ଚିମିନ୍‌ ନାଲାକତାଃରେ ମେନାଃ ଆଡଃ ଆଇଙ୍ଗ୍‌ ନେତାଃରେ ରେଙ୍ଗେଃତେ ଗଜଃତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ଆଇଙ୍ଗ୍‌ ବିରିଦ୍‌କେଦ୍‌ତେ ଆପୁଇଙ୍ଗ୍‌ତାଃ ସେନଃଆଇଙ୍ଗ୍‌ ଆଡଃ କାଜିୟାଇଙ୍ଗ୍‌, ହେ ଆବା, ଆଇଙ୍ଗ୍‌ ସିର୍ମାରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆଡଃ ଆମାଃ ଆୟାର୍‌ରେ ପାପ୍‌କାଦାଃଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ଆଇଙ୍ଗ୍‌ ଆମାଃ ହନ୍‌ କାଜିୟଃଲେକାନିଃ ନାହାଁଲାଇଙ୍ଗ୍‌, ଆମ୍‌ ଆମାଃ ନାଲା କାମିତାନ୍‌ ଦାସିକ ଲେକା ଦହିଙ୍ଗ୍‌ମେଁ । ");
INSERT INTO unx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ଏନ୍ତେ ଇନିଃ ବିରିଦ୍‌ୟାନ୍ତେ ଆପୁତେତାଃ ସେନଃୟାନାଏ । ମେନ୍‌ଦ ଇନିଃ ସାଙ୍ଗିନ୍‌ରେଗି ତାଇକେନ୍‌ ଇମ୍‌ତା ଆପୁତେ ଇନିଃକେ ନେଲ୍‌କିଃତେ ଲିବୁଆଇକିୟାଏ, ଆଡଃ ନିର୍‌ ଦାରମ୍‌କିୟାଏ, ଆଡଃ ହାଁବୁଦ୍‌କିଃତେ ଚଅଃ'କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ହନ୍‌ ଇନିଃକେ କାଜିକିୟାଏ, ‘ହେ ଆବା, ଆଇଙ୍ଗ୍‌ ସିର୍ମାରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆଡଃ ଆମାଃ ଆୟାର୍‌ରେଇଙ୍ଗ୍‌ ପାପ୍‌କାଦାଃ, ଆଇଙ୍ଗ୍‌ ଆୟାର୍‌ତେ ଆମାଃ ହନ୍‌ କାଜିୟଃଲେକାନିଃ ନାହାଁଲିଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ମେନ୍‌ଦ ଆପୁ ଆୟାଃ ଦାସିକକେ କାଜିୟାଦ୍‌କଆଏ, ‘ବୋଦେଗି ! ସବେନାଃଏତେ ବୁଗିନ୍‌ ଲିଜାଃ ଅଡଙ୍ଗ୍‌ୟେଁପେ ଆଡଃ ଇନିଃକେ ତୁସିଙ୍ଗ୍‌ଇପେ ଆଡଃ ଇନିୟାଃ ତିଃଇରାଃ ସାର୍‌ସାର୍‌ରେ ମୁଦାମ୍‌ ଆଡଃ କାଟାରେ ଜୁତା ଚାଏ ଖାର୍‌ପା ତୁସିଙ୍ଗ୍‌ଇପେ । ");
INSERT INTO unx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ଆଡଃ କିରିକାନ୍‌ ବାଛା ଆଉକେଦ୍‌ତେ ଗଜିପେ, ଆବୁ ଜମ୍‌କେଦ୍‌ତେବୁ ରାସ୍‌କାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ନେ ହନିଙ୍ଗ୍‌କଡ଼ାଦ ଗଜାକାନ୍‌ ତାଇକେନାଏ ଆଡଃ ଜୀହୁଦ୍‌ରୁହାଡ଼ାକାନାଏ, ଇନିଃ ଆଦାକାନ୍‌ ତାଇକେନାଏ ଆଡଃ ନାମ୍‌ରୁହାଡ଼ାକାନାଏ, ଆଡଃ ଇନ୍‌କୁ ରାସ୍‌କାଅଃ ଏଟେଦ୍‌କେଦାକ ।’ ");
INSERT INTO unx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ଆଡଃ ଇନିୟାଃ ମାରାଙ୍ଗ୍‌ ହନ୍‌ ପିଡ଼ିରେ ତାଇକେନାଏ, ହିଜୁଃତାନ୍‌ଲଃ ଅଡ଼ାଃତାଃ ସେଟେର୍‌ୟାନ୍‌ତେ ଦୁରାଙ୍ଗ୍‌ତାନ୍‌, ସୁସୁନ୍‌ତାନ୍‌କଆଃ ସାଡ଼ି ଆୟୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ଏନ୍ତେ ଇନିଃ ଦାସିକଏତେ ମିଆଁଦ୍‌ନିଃକେ ଆୟାଃତାଃତେ କେଡ଼ାକେଦ୍‌ତେ ‘ନେଆଁଁ ଚିନାଃ ହବାଅଃତାନାଃ’ ମେନ୍ତେ କୁଲିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘ହାଗାମ୍‌ ତାମାଃ ହିଜୁଆକାନାଏ’ ମେନ୍‌କିୟାଏ, ‘ଆଡଃ ଇନିଃ ବୁଗିନ୍‌ ବୁଗିନାଏ ନାମ୍‌ରୁହାଡ଼ାକାନା ମେନ୍ତେ ଆପୁମ୍‌ ମିଆଁଦ୍‌ କିରିୟାକାନ୍‌ ବାଛା ଗଜାକାଇୟାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“ମେନ୍‌ଦ ମାରାଙ୍ଗ୍‌ ହନ୍ତେକଡ଼ା ଖିସ୍‌ୟାନାଏ ଆଡଃ ଅଡ଼ାଃତେ କାଏ ବଲ ସାନାଙ୍ଗ୍‌କେଦା, ଏନାତେ ଆପୁତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଇନିଃକେ ବିନ୍ତିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ମେନ୍‌ଦ ଇନିଃ ଆପୁତେକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, ‘ନେଲେମେ, ନିମିନ୍‌ ବାରାଷ୍‌ ହବାୟାନା ଆଇଙ୍ଗ୍‌ ଆମାଃ ଦାସି ଲେକାଇଙ୍ଗ୍‌ କାମିତାନା ଆଡଃ ଆମାଃ ଜେତାନ୍‌ ଆନ୍‌ଚୁ ଚିଉଲାହଗି କାଇଙ୍ଗ୍‌ ଟଟାଃକେଦା ଆଡଃ ଆମ୍‌ ଆଇଁୟାଃ ଗାତିକଲଃ ରାସ୍‌କାଃଅ ନାଗେନ୍ତେ ଚିଉଲାହ ମିଆଁଦ୍‌ ମେରମ୍‌ ହନ୍‌ହଁ କାମ୍‌ ଏମାକାଦିଇୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ମେନ୍‌ଦ ଆମାଃ ନେ ହନ୍‌ ବେଶ୍ୱାକଲଃ ଆମାଃ ସବେନ୍‌ ମେନାଃତେୟାଃ ଜମ୍‌ଚାବାକେଦାଏ, ଆଡଃ ନାହାଁଃ ଅଡ଼ାଃତେ ହିଜୁଃକାନ୍‌ ଇମ୍‌ତା ଆମ୍‌ ଇନିୟାଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ କିରିକାନ୍‌ ବାଛା ଗଏଃକିୟାମ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ମେନ୍‌ଦ ଆପୁତେ କାଜିକିୟାଏ, ‘ହେ ହନ୍‌, ଆମ୍‌ ଜାନାଅ ଆଇଙ୍ଗ୍‌ଲଃ ତାଇନଃତାନାମ୍‌ ଆଡଃ ଆଇଁୟାଃ ସବେନାଃ ଆମାଃଗି ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ମେନ୍‌ଦ ରାସ୍‌କାଅଃ ଆଡଃ ସୁକୁଅଃଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା ଚିୟାଃଚି ନେ ହାଗାମ୍‌ଦ ଗଜାକାନାଏ ତାଇକେନା ଆଡଃ ଜୀହୁଦ୍‌ରୁହାଡ଼ାକାନାଏ; ଇନିଃ ଆଦାକାନାଏ ତାଇକେନା ଆଡଃ ନାମ୍‌ରୁହାଡ଼ାକାନାଏ ।’” ");
INSERT INTO unx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, “ମିଆଁଦ୍‌ କିସାଁଣ୍‌ ହଡ଼ଆଃ ଭାଣ୍ଡାରି ତାଇକେନାଏ, ଇନିଃ ମେନାଃତେୟାଃକ ଛିତିବିତି ତାନାଏ ମେନ୍ତେ କିସାଁଣାଃ ଆୟାର୍‌ରେ ଭାଣ୍ଡାରିକ ଚିଟାକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ଏନ୍ତେ କିସାଁଣ୍‌ ଇନିଃକେ ହାକାଅତାନ୍‌ଲଃ କାଜିକିୟାଏ, ‘ଆମାଃ ବିଷାଏରେ ଚିନାଃଇଙ୍ଗ୍‌ ଆୟୁମ୍‌ତାନା ? ଆମାଃ ଭାଣ୍ଡାରି କାମିରାଃ ହିସାବ୍‌ ଏମାଇଙ୍ଗ୍‌ମେ, ଆମ୍‌ ଆୟାର୍‌ତେ ଭାଣ୍ଡାରି କାମ୍‌ ତାଇନ୍‌ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ଏନ୍‌ ଭାଣ୍ଡାରି ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ମେନ୍ତେ ଆୟାଃ ମନ୍‌ରେୟାଏ ଉଡୁଃକେଦାଃ, ଗମ୍‌କେତାଇଙ୍ଗ୍‌ଦ ଭାଣ୍ଡାରି କାମି ରେଜିଙ୍ଗ୍‌ତାନାଏ । ଉର୍‌କେଦ୍‌ତେ କାମିଲେକା ଆଇଁୟାଃ ପେଡ଼େଃ ବାନଃଆ, ଆଡଃ କଏଁତେଇଙ୍ଗ୍‌ ଗିହୁଃତାନା । ");
INSERT INTO unx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ଭାଣ୍ଡାରିକାମିଏତେଇଙ୍ଗ୍‌ ଅଡଙ୍ଗ୍‌ଏନ୍‌ରେଦ ହଡ଼କ ଆକଆଃ ଅଡ଼ାଃରେକ ଦହିଙ୍କା ମେନ୍ତେ ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ଏନାଇଙ୍ଗ୍‌ ସାରିୟାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଗମ୍‌କେୟାଃ ରିଣୀସାବାକାଦ୍‌କଏତେ ମିମିଆଦ୍‌କକେ କେଡ଼ାକେଦ୍‌କଆଏ । ସିଦାନିଃକେ କୁଲିକିୟାଏ, ‘ଆମ୍‌ ଆଇଁୟାଃ ଗମ୍‌କେୟାଃ ଚିମିନାଙ୍ଗ୍‌ ରିଣୀମ୍‌ ଇଦିକାଦା ?’ ");
INSERT INTO unx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ଇନିଃ କାଜିକିୟାଏ ‘ମଣେଁହିସି ଟିନ୍‌ ସୁନୁମ୍‌ ।’ ଏନ୍ତେ ଇନିଃ, ‘ମାର୍‌ ଆମାଃ ବହି ଆଉୱେମେ ଆଡଃ ଦୁବ୍‌ଧାବ୍‌କେଦ୍‌ତେ ବାର୍‌ହିସି ଗେଲେୟା ଅଲେମେ’ ମେନ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ଏନ୍ତେ ଏଟାଃନିଃକେ କାଜିକିୟାଏ, ‘ଆମ୍‌ ଚିମ୍‌ନାଙ୍ଗ୍‌ ରିଣୀମ୍‌ ଇଦିକାଦା ?’ ‘ମିଦ୍‌ ହାଜାର୍‌ ବାସ୍ତା ଗହମ୍‌’ ମେନ୍‌ରୁହାଡ଼୍‌କିୟାଏ । ଇନିଃ କାଜିକିୟାଏ, ‘ଆମାଃ ବହି ଆଉୱେମେ ଆଡଃ ଇରାଲିୟାଶାଅ ବାସ୍ତା ଅଲ୍‌ତାମେ ।’ ");
INSERT INTO unx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“ଏନ୍ତେ ଇନିଃ ସେଣାଁଁତେୟାଏ କାମିୟାକାଦା ମେନ୍ତେ ଇନିୟାଃ ଗମ୍‌କେ ଏନ୍‌ କା ଧାର୍‌ମାନ୍‌ ଭାଣ୍ଡାରିକେ ସାହାରାଅକିୟାଏ । ନେ ପାରିୟାରେନ୍‌ ହଡ଼କଦ ଆକଆଃ ଦିପିଲିରେନ୍ ହଡ଼କଆଃ ନାଗେନ୍ତେ ମାର୍ସାଲ୍‌ରେନ୍‌ ହନ୍‌କଆଃଏତେ ଆଦ୍‌କାକ ସେଣାଁଁନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆପେ ସାଂସାର୍‌ରେୟାଃ କା ଧାର୍‌ମାନ୍‌ ଖୁର୍ଜିତେ ଗାତିକ ବାଇକପେ, ଏନ୍ତେ ଏନା ଟୁଣ୍ଡୁଅଃ ଇମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କୁ ଜାନାଅ ଜାନାଅ ତାଇନଃ ଠାୟାଦ୍‌ରେକ ଦହପେୟା । ");
INSERT INTO unx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ସବେନାଃଏତେ ହୁଡିଙ୍ଗ୍‌ଆଁରେ ପାତିୟାର୍‌ରଃ ଲେକାନ୍‌ନିଃ ପୁରାଃ ବିଷାଏରେହଗି ପାତିୟାର୍‌ରଃ ଲେକାନ୍‌ନିଃ ତାନିଃ ଆଡଃ ସବେନାଃଏତେ ହୁଡିଙ୍ଗ୍‌ଆଁରେ କା ପାତିୟାର୍‌ରଃ ଲେକାନ୍‌ନିଃ ପୁରାଃ ବିଷାଏରେହଗି କା ପାତିୟାର୍‌ରଃ ଲେକାନ୍‌ନିଃ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ଏନାମେନ୍ତେ ଆପେ ସାଂସାର୍‌ରେୟାଃ ଖୁର୍ଜିରେ କା ପାତିୟାର୍‌ରଃ ଲେକାପେ ତାଇନଃରେଦ, ସାର୍‌ତିତେୟାଃ ଅକଏ ଏମାପେୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ଆଡଃ ଆପେ ଏଟାଃନିୟାଃ ବିଷାଏରେ ପାତିୟାର୍‌ରଃ ଲେକା କାପେ ତାଇନ୍‌ରେଦ ଆପେକେ ଅକଏ ଆପେୟାଃତେୟାଃକେ ଏମାପେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ଜେତାଏ ବାରିଆ ଗମ୍‌କେକିନାଃ ଦାସି କାଏ ହବାଦାଡ଼ିୟଃଆ, ଚିୟାଃଚି ଇନିଃ ମିହୁଡ଼୍‌କେ ହିଲାଙ୍ଗ୍‌ଇୟାଏ ଆଡଃ ଏଟାଃ ମିହୁଡ଼୍‌କେ ଦୁଲାଡ଼ିୟାଏ, ଚାଏ ମିଆଁଦ୍‌ନିଃଲଃ ମେସାନାଏ ଆଡଃ ଏଟାଃନିଃଲଃ କାଏ ମେସାନା । ଆପେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଡଃ ଖୁର୍ଜି ବାରାନାଃରେ କାପେ ଦାସିଦାଡ଼ିନା ।” ");
INSERT INTO unx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ଟାକା ପାଏସାରାଃ ହାୟାତାନ୍‌ ଫାରୁଶୀକ ନେ ସବେନ୍‌ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ, ଇନିଃକେକ ହିଲାଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେଦ ହଡ଼କଆଃ ଆୟାର୍‌ରେ ଧାର୍‌ମାନ୍‌ପେ ଉଦୁବଃତାନା, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେୟାଃ ମନ୍‌ ସାରିୟାଏ । ହଡ଼କଆଃ ଥାଲାରେ ମାରାଙ୍ଗ୍‌ଅଃଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାନ୍‌ମାଙ୍ଗରେ ହିଲାଙ୍ଗ୍‌ଅଃଲେକା । ");
INSERT INTO unx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ମୁଶାରାଃ ଆନ୍‌ଚୁ ଆଡଃ ନାବୀକ ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ଜାକେଦ୍‌କ ତାଇକେନା, ଇମ୍‌ତାଙ୍ଗ୍‌ଏତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସିର୍ମା ରାଇଜ୍‌ରେୟାଃ ସୁକୁକାଜି ଉଦୁବଃତାନା ଆଡଃ ସବେନ୍‌କ ପେଡ଼େଃଲଃ ଏନାରେ ବଲଃତାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ସିର୍ମା ଆଡଃ ଅତେ ଜିୟନଃଆ ମେନ୍‌ଦ ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁରେୟାଃ ମିଆଁଦ୍‌ ଅନଲ୍‌ ହଗି କା ଜିୟନଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ଜେତାଏ ହଡ଼ ଆୟାଃ କୁଡ଼ିକେ ବାଗିକେଦ୍‌ତେ ଏଟାଃନିଃଲଃ ଆଣ୍‌ଦିନ୍‌ରେଦ ଇନିଃ ଆପାଙ୍ଗିର୍‌ନିଃ ତାନିଃ ଆଡଃ କଡ଼ାତେ ବାଗିୟାକାନ୍‌ କୁଡ଼ିକେ ଜେତାଏ ଆଣ୍‌ଦିୟଃରେଦ ଇନିଃ ଆପାଙ୍ଗିର୍‌ନିଃ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“ମିଆଁଦ୍‌ କିସାଁଣ୍‌ ହଡ଼ ତାଇକେନାଏ, ଇନିଃ ବାଇଗିନିଆ ଲିଜାଃ ଆଡଃ ବୁଗିନ୍‌ ସୁଗାଡ଼୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଅଃଁତାନ୍‌ ଆଡଃ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ପୁରାଃ ରାସ୍‌ବାସ୍‌ରେୟାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ମେନ୍‌ଦ ଲାଜାର୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ କଏଁହଡ଼ ଘାଅତେ ପେରେଜାକାନ୍‌ ତାଇକେନାଏ, ଇନିଃକେ କିସାଁଣ୍‌ ହଡ଼ରାଃ ଅଡ଼ାଃ ବଲଦୁଆର୍‌ତାଃରେ ବାଗିତୁକାକାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ନେ କିସାଁଣ୍‌ ହଡ଼ଆଃ ମେଜ୍‌ଏତେ ଉୟୁଗଃତାନ୍‌ କେଚାଃତେୟାଃଲଃ ଆୟାଃ ଲାହିଦ୍‌ ବିଏ ସାନାଙ୍ଗ୍‌ତାନାଏ ତାଇକେନା, ସେତାକହ ହିଜୁଃଲେନ୍ତେ ଇନିୟାଃ ଘାଅ ଜାଲ୍‌ଇତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“ଏନ୍ତେ ନେକା ହବାୟାନା, ନେ ରେଙ୍ଗେଃ ହଡ଼ ଗଏଃୟାନାଏ ଆଡଃ ଦୁଁତ୍‌କ ଆବ୍ରାହାମ୍‌ଆଃ କୟଙ୍ଗ୍‌ରେକ ତେବାଃକିୟା, ଆଡଃ ଏନ୍‌ କିସାଁଣ୍‌ ହଡ଼ହଗି ଗଏଃୟାନାଏ ଆଡଃ ତପାକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ଇନିଃ ପାତାଲ୍‌ରେ ଦୁକୁସାହାତିଙ୍ଗ୍‌ତାନ୍‌ ଇମ୍‌ତା ଆରିଦ୍‌ରାକାବ୍‌କେଦାଏ ଆଡଃ ସାଙ୍ଗିନ୍‌ରେ ଆବ୍ରାହାମ୍‌ ଆଡଃ ଆୟାଃ କୟଙ୍ଗ୍‌ରେ ଲାଜାର୍‌କେ ନେଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ଏନ୍ତେ ଇନିଃ ହାକାଅକିଃତେ କାଜିକିୟାଏ, ‘ହେ ଆବା, ଆବ୍ରାହାମ୍‌ ଲିବୁଆଇଙ୍ଗ୍‌ମେଁ ଆଡଃ ଲାଜାର୍‌କେ କୁଲ୍‌ତାଇମ୍‌ ଇନିଃ ଆୟାଃ ସାର୍‌ସାର୍‌ରାଃ ଚୁଟି ଦାଆଃରେ ତୁପୁକେଦ୍‌ତେ ଆଲାଙ୍ଗ୍‌ତାଇୟାଁଃକେ ତୁତ୍‌କେନେକାଏ, ଆଇଙ୍ଗ୍‌ଦ ନେ ସେଙ୍ଗେଲ୍‌ରେ କାଲ୍‌ପାଅଃତାନାଇଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ମେନ୍‌ଦ ଆବ୍ରାହାମ୍‌ କାଜିକିୟାଏ, ‘ଏ ହନ୍‌, ନେଆଁଁ ଉଡ଼ୁଃଇମେ, ଆମ୍‌ଦ ଜୀନିଦ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଆମାଃ ବୁଗିନାଃମ୍‌ ନାମ୍‌ଚାବାକେଦାଃ ଆଡଃ ଏନ୍‌ ଲେକାଗି ଲାଜାର୍‌ ପୁରାଃ ଦୁକୁ ନାମ୍‌କେଦାଏ, ମେନ୍‌ଦ ନାହାଁଃ ଇନିଃ ନେତାଃରେ ଜୀଉରାଡ଼େଃ ନାମେତାନାଏ ଆଡଃ ଆମ୍‌ କାଲ୍‌ପାଅଃତାନାମେ । ");
INSERT INTO unx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ଆଡଃ ନେଆଁଁଏତେ ଆଦ୍‌କା ମାରାଙ୍ଗ୍‌ ହୁୱାଙ୍ଗ୍‌ ଆଲେ ଆଡଃ ଆପେ ଥାଲାରେ ମେନାଃ, ନେତାଃଏତେ ହାନ୍‌ପାରମ୍‌ ଆପେତାଃ ଜେତାଏ କାକ ସେନ୍‌ଦାଡ଼ିୟା ଆଡଃ ହାନ୍‌ପାରମ୍‌ରେନ୍‌କ ନେ ପାରମ୍‌ ଆଲେତାଃ କାକ ହିଜୁଃଦାଡ଼ିୟାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ଇନିଃ କାଜିକିୟାଏ, ‘ତାବ୍‌ଦ ହେ ଆବା, ଲାଜାର୍‌କେ ଆପୁଇଁୟାଃ ଅଡ଼ାଃତେ କୁଲ୍‌ତାଇମ୍‌, ମେନ୍ତେଇଙ୍ଗ୍‌ ବିନ୍ତିମେ ତାନା । ");
INSERT INTO unx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ଚିୟାଃଚି ଆଇଁୟାଃଦ ମଣେୟାଁ ହାଗାଇଙ୍ଗ୍‌କ ମେନାକଆ, ଇନିଃ ଇନ୍‌କୁତାଃ ପାର୍‌ଚାରେକାଏ, ଆଡଃ ଚେତାଅକକାଏ, କା'ରେଦ ଇନ୍‌କୁହଗି ନେ ଦୁକୁ ଠାୟାଦ୍‌ତେକ ସେଟେରାଃ ।’ ");
INSERT INTO unx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“ଆବ୍ରାହାମ୍‌ କାଜିକିୟାଏ, ‘ମୁଶା ଆଡଃ ନାବୀକଆଃ ପୁଥି ଇନ୍‌କୁତାଃରେୟାଃ; ଆମାଃ ହାଗାକ ଇନ୍‌କୁଆଃ କାଜିକ ଆୟୁମେକା ।’ ");
INSERT INTO unx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ଇନିଃ କାଜିକିୟାଏ, ‘ହେ ଆବା ଆବ୍ରାହାମ୍‌, ବାନଃଗି ! ମେନ୍‌ଦ ଗଜାକାନ୍‌କଏତେ ଜେତାଏ ଇନ୍‌କୁତାଃତେ ସେନଃରେଦ ଇନ୍‌କୁ ହେୟାତିଙ୍ଗେଆକ ଆଡଃ ପାପ୍‌ହେତେ ମନ୍‌ରୁହାଡ଼େୟାକ ।’ ");
INSERT INTO unx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ମେନ୍‌ଦ ଇନିଃ କାଜିକିୟାଏ, ‘ଇନ୍‌କୁ ମୁଶା ଆଡଃ ନାବୀକଆଃ କାଜି କାକ ମାନାତିଙ୍ଗ୍‌ରେଦ, ଗଜାକାନ୍‌କଏତେ ଜେତାଏ ଜୀଉବିରିଦଃରେୟ କାକ ମାନାତିୟାଁଃ ।’” ");
INSERT INTO unx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, “ଅକ ବିନିଡ଼ାଅ ହରାତେ ହଡ଼ ପାପ୍‌ରେ ଉୟୁଗଃଆ, ଏନ୍‌ ସବେନାଃ ଜାରୁଡ଼୍‌ଗି ହିଜୁଃଆ, ମେନ୍‌ଦ ଅକଏୟାଃ ହାରାତେ ନେୟାଁ ହବାଅଃଆ, ଇନିୟାଃ ଟୁଣ୍ଡୁ ଦାସା ଚିମିନ୍‌ ବରୱାନ୍‌ଗି ହବାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ଜେତାଏ ନେ ହୁଡିଙ୍ଗ୍‌କଏତେ ମିଆଁଦ୍‌ନିଃକେ ପାପ୍‌ରେ ଉୟୁଃ ରିକାଇଏତେଦ, ଇନିଃ ଆଇଃଗି ହଟଃରେ ଜାନ୍ତାଦିରି ହାକାକେଦ୍‌ତେ ଦରେୟାରେ ହୁଦ୍‌ମାଅଃତେୟାଃ ଆୟାଃ ନାଗେନ୍ତେ ବୁଗିନ୍‌ ହବାଅଃତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ଏନାତେ ଆପେ ଚିର୍ଗାଲ୍‌କାନ୍‌ପେ, ହାଗାମ୍ ତାମାଃ ପାପ୍‌ଏରେଦ ଇନିଃକେ ଏଗେର୍‌କେଦ୍‌ତେ ଚେତାଇମେଁ, ଆଡଃ ଇନିଃ ହେୟାତିଙ୍ଗ୍‌ରେଦଃ ଛାମାଇମେଁ । ");
INSERT INTO unx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ଇନିଃ ସିଙ୍ଗିସାଟୁବ୍‌ରେ ସାତ୍‌ଧାଅଁଁ ଆମାଃ ବିରୁଧ୍‌ରେ ପାପ୍‌ପେରେଦ, ଆଡଃ ସିଙ୍ଗିସାଟୁବ୍‌ରେ ସାତ୍‌ଧାଅଁଁ ଆମାଃତାଃତେ ରୁହାଡ଼୍‌ୟାନ୍ତେ ଆଇଙ୍ଗ୍‌ ହେୟାତିଙ୍ଗ୍‌ତାନାଇଙ୍ଗ୍‌ ମେନ୍‌ରେଦ ଇନିଃକେ ଛାମାଇ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ଆଡଃ ପ୍ରେରିତ୍‌କ କାଜିକିୟା, “ହେ ପ୍ରାଭୁ ଆଲେୟାଃ ବିଶ୍ୱାସ୍‌ ଆଦ୍‌କାଏମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ପ୍ରାଭୁ ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କେଦା, “ଆପେୟାଃ ବିଶ୍ୱାସ୍‌ ମିଆଁଦ୍‌ ମାନିଜାଙ୍ଗ୍‌ଲେକା ମେନାଃରେଦ, ଆମ୍‌ ତୁଦଃମେଁ ଆଡଃ ଦରେୟାରେ ରୟଃମେ ମେନ୍ତେ ନେ ତୁଁତ୍‌ଦାରୁକେ କାଜିରେ, ଏନା ଆପେୟାଃ ଆନ୍‌ଚୁକେ ମାନାତିୟାଁଃଏ । ");
INSERT INTO unx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ଆପେକଏତେ ଜେତାଏୟାଃ ମିଆଁଦ୍‌ ସିହୁଃ ଚାଏ ଗୁପି ଦାସି ମେନାଇରେଦ, ଇନିଃ ପିଡ଼ିଏତେ ହିଜୁଃଲଃଗି, ଅକଏ ମାର୍‌ ଜଜମ୍‌ ଦୁବ୍‌ମେଁ ମେତାଇୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ମେନ୍‌ଦ ଇନିଃ ‘ଆଇଁୟାଃ ଜମେୟାଃଁ ବାଇୟେମେଁ, ଆଡଃ ପାଟେକେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଆଉରିଙ୍ଗ୍‌ ଜମେ ନୁଁଏ ଜାକେଦ୍‌ ସୁସାରିଙ୍ଗ୍‌ମେ ଆଡଃ ଏନ୍‌ ତାୟମ୍‌ତେ ଆମ୍‌ ଜମ୍‌ନୁଁଏମେ’ ମେତାଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ଚିୟାଃ ଇନିଃ ଏନ୍‌ ଦାସିକେ ଆଚୁକାନ୍‌ କାମିକ କାମିକେଦାଏ ମେନ୍ତେ ଧାନ୍ୟାବାଦ୍‌ ଏମାଃଏ ? ");
INSERT INTO unx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ନେ'ଲେକାତେ ଆପେୟ ସବେନ୍‌ ଆଚୁଆକାନ୍‌ କାମିକ ଚାବାକେଦ୍‌ତେ, ଆବୁ ପାତିୟାର୍‌ରଃ ଲେକାନ୍‌ ଦାସିକ ନାହାଁଲାବୁ, ଆବୁଆଃ ଲାଗାତିଙ୍ଗ୍‌ କାମିକବୁ କାମିକେଦାଃ ମେନ୍ତେ କାଜିପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃତାନ୍‌ ଇମ୍‌ତା, ଶମିରୋନ୍‌ ଆଡଃ ଗାଲିଲ୍‌ ଦିଶୁମ୍‌ ଥାଲା ଥାଲାତେ ସେନଃତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ଇନିଃ ମିଆଁଦ୍‌ ହାତୁତେ ବଲତାନ୍‌ ଇମ୍‌ତା ଗେଲ୍‌ ନାଗେଘାଅତାନ୍‌ ହଡ଼କ ସାଙ୍ଗିନ୍‌ରେକ ତିଙ୍ଗୁୟାନ୍ତେ ଇନିଃକେ ଦାରମ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ଆଡଃ ଇନ୍‌କୁ “ହେ ୟୀଶୁ ଦାୟାଲେମେଁ” ମେନ୍ତେକ କାଉରିକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ଇନିଃ ଇନ୍‌କୁକେ ନେଲ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ସେନଃପେ ଆଡଃ ଯାଜାକ୍‌କତାଃ ଉଦୁବେନ୍‌ପେ ।” ଆଡଃ ଇନ୍‌କୁ ସେନଃତାନ୍‌ଲଃକ ଫାର୍‌ଚିୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ଆଇଙ୍ଗ୍‌ ବୁଗିକାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ ନେଲ୍‌ୟାନ୍‌ଚି କାଉରିକେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ତାନ୍‌ଲଃ ହିଜୁଃରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ଆଡଃ ୟୀଶୁଆଃ କାଟାସୁବାରେ ଅମ୍ବାଃକେଦ୍‌ତେ ଇନିଃକେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌କିୟାଏ, ଆଡଃ ଇନିଃଦ ଶମିରୋନିରେନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ୟୀଶୁ କୁଲିକେଦ୍‌କଆଏ, “ଚିୟାଃ ସବେନ୍‌ ଗେଲ୍‌ ହଡ଼କ କାକଚି ଫାର୍‌ଚିୟାନା ? ଏଟାଃ ନାଅଝାନ୍‌କ କତାଃରେକଆଃ ? ");
INSERT INTO unx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ଚିୟାଃ ନେ ଏଟାଃ ଦିଶୁମ୍‌ରେନ୍‌ ନିଃକେ ବାଗିକିଃତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌ ନାଗେନ୍ତେ ଆଡଃ ଜେତାଏ କାକ ରୁହାଡ଼୍‌ୟାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ଏନ୍ତେ ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ମାର୍‌ ବିରିଦ୍‌ମେ ଆଡଃ ସେନଃମେ ବିଶ୍ୱାସ୍‌ତାମାଃ ବୁଗିକାଦ୍‌ମେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ମିସା, ଚିମ୍‌ନାଙ୍ଗ୍‌ ଫାରୁଶୀକ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଚିଉଲା ହିଜୁଃଆ ମେନ୍ତେ କୁଲିକିୟାଃକ, ୟୀଶୁ ମେନ୍‌ରୁହାଡ଼ାଦ୍‌କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆପେୟାଃ ନେନେଲ୍‌ରେ କା ହିଜୁଃଆ, ");
INSERT INTO unx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ଆଡଃ ହଡ଼କ ନେଲେପେ ନେତାଃରେୟା, ଚାଏ ନେଲେପେ ଏନ୍ତାଃରେୟା, ମେନ୍ତେ କାକ କାଜିୟା, ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆପେ ଥାଲାରେଗିୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, “ଏନ୍‌ ନେଡା ହିଜୁଃତାନା, ଆପେକେ ମାନୱାହନ୍‌ଆଃ ମିପିୟାଦ୍‌ ହୁଲାଙ୍ଗ୍‌କଏତେ ମିଆଁଦ୍‌ ହୁଲାଙ୍ଗ୍‌ ନେନେଲ୍‌ ସାନାଙ୍ଗ୍‌ପେୟା, ମେନ୍‌ଦ କାପେ ନେଲେୟା । ");
INSERT INTO unx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ହଡ଼କ କାଜିୟାପେୟାକ, ‘ଇନିଃ ନେତାଃରିୟା, ଚାଏ ହେନ୍ତାଃରିୟା,’ ମେନ୍‌ଦ ଆଲ୍‌ପେ ସେନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ଜୁଲ୍‌ତାନ୍‌ହିଚିର୍‌ଦ ସିର୍ମାଲାତାର୍‌ ନେ'ସାଃଏତେ ଏଟାଃସାଃ ଜାକେଦ୍‌ ସିର୍ମାକେ ମାସ୍କାଲେୟାଏ, ଏନ୍‌ ଲେକାଗି ମାନୱାହନ୍‌ଆଃ ହିନିଜୁଃ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ମେନ୍‌ଦ ସିଦାତେ ଇନିଃକେ ପୁରାଃଗି ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଆଡଃ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କ ଇନିଃକେକ ହିଲାଙ୍ଗ୍‌ଇଁଆ । ");
INSERT INTO unx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ଆଡଃ ନୁହୁଁରାଃ ପାରିୟାରେ ଜେ'ଲେକା ହବାୟାନା, ମାନୱାହନ୍‌ଆଃ ହୁଲାଙ୍ଗ୍‌ରେହଗି ଏନ୍‌ଲେକା ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ନୁହୁଁ ଲାଉକାରେ ଦେଏଃୟାନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଜାକେଦ୍‌ ଇନ୍‌କୁ ଜମ୍‌ ନୁଁତାନ୍ ଆଣ୍‌ଦି ଆଡଃ ଆଣ୍‌ଦିଏମଃତାନ୍‌କ ତାଇକେନା, ଇମ୍‌ତାଗି ଟୁଡା ହିଜୁଃୟାନ୍ତେ ସବେନ୍‌କକେ ଜିୟନ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଲୁଟ୍‌ଆଃ ହୁଲାଙ୍ଗ୍‌ରେହ ଏନ୍‌କାୟାନା, ଇନ୍‌କୁ ଜମ୍ ନୁଁତାନ୍, କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ତାନ୍‌, ରଏତାନ୍‌ ଆଡଃ ଅଡ଼ାଃ ବାଇତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ମେନ୍‌ଦ ଲୁଟ୍‌ ସୋଦମ୍‌ ଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ ଇମ୍‌ତା ସିର୍ମାଏତେ ସେଙ୍ଗେଲ୍‌ ଆଡଃ ଗାନ୍ଧାକ୍‌ ଗାମାକେଦାଏ ଆଡଃ ଏନ୍‌ ସବେନ୍‌କକେ ଜିୟନ୍‌ କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ଏନ୍‌ ଲେକାଗି ମାନୱାହନ୍‌ଆଃ ଉଦୁବଃ ହୁଲାଙ୍ଗ୍‌ରେ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଜେତାଏ ସାଡ଼୍‌ମିରେ ତାଇନଃରେଦ ଆଡଃ ଇନିୟାଃ ମେନାଃତେୟାଃକ ଅଡ଼ାଃରେ ତାଇନ୍‌ରେଦ, ଏନା ଇଦିନାଗେନ୍ତେ ଆଲକାଏ ଆଡ଼୍‌ଗୁନ୍‌କା, ଆଡଃ ଏନ୍‌ଲେକାଗି ପିଡ଼ିଲୟଙ୍ଗ୍‌ରେ ତାଇନ୍‌ନିଃ ଦୟାତେ ଆଲକାଏ ରୁହାଡ଼୍‌କା । ");
INSERT INTO unx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲୁଟ୍‌ କୁଡ଼ିତେକେ ପାହାମିପେ । ");
INSERT INTO unx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ଜେତାଏ ଆୟାଃ ଜୀଉ ବାଞ୍ଚାଅ ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଏନା ଆଦେୟାଏ, ଆଡଃ ଜେତାଏ ଏନା ଆଦେରେଦ ଏନାଏ ବାଞ୍ଚାଅୟା । ");
INSERT INTO unx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଏନ୍‌ ନିଦାରେ ବାର୍‌ହଡ଼୍‌ ମିଆଁଦ୍‌ ପାର୍‌କମ୍‌ରେକିନ୍‌ ଗିତିଃକାନ୍‌ରେଦ ମିହୁଡ଼୍‌କେ ଇଦିୟଃଆ ଆଡଃ ମିହୁଡ଼୍‌କେ ବାଗିଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ବାରିଆ କୁଡ଼ିକିନ୍‌ ମିଦ୍‌ତେ ଜନ୍ତାଦିରିରେକିନ୍‌ ରିଦ୍‌କାତେରେଦ ମିଆଁଦ୍‌ନିଃକେ ଇଦିୟଃଆ ଆଡଃ ଏଟାଃନିଃକେ ବାଗିଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ବାର୍‌ହଡ଼୍‌ ଅତେରେକିନ୍‌ ତାଇନ୍‌ରେଦ ମିଆଁଦ୍‌ନିଃକେ ଇଦିୟଃଆ ଆଡଃ ଏଟାଃନିଃକେ ବାଗିଅଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ଇନ୍‌କୁ କୁଲିକିୟାଃକ, “ହେ ପ୍ରାଭୁ କତାଃରେ ନେ ସବେନାଃ ହବାଅଆଃ ?” ଆଡଃ ଇନିଃ “ଅକ୍‌ତାଃରେ ମାଁଡ଼ା ମେନାଃ, ଏନ୍ତାଃରେ ଗିଦିକ ହୁଣ୍ଡିୟଃଆଃ” ମେନ୍‌ରୁହାଡ଼ାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ଜାନାଅ ବିନ୍ତି ଆଡଃ ଭାର୍‌ସା କା ହୁଡିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ମେନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ମିଆଁଦ୍‌ ଜନ୍‌କା କାଜି ଉଦୁବାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“ଜେତାଏ ସାହାର୍‌ରେ ମିଆଁଦ୍‌ ବିଚାର୍‌ନିଃ ତାଇକେନାଏ, ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ କାଏ ବରଆଇ ତାଇକେନା ଚି ହଡ଼କକେ କାଏ ମାନାତିଙ୍ଗ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ଆଡଃ ଏନ୍‌ ସାହାର୍‌ରେ ମିଆଁଦ୍‌ ରାଣ୍ଡିକୁଡ଼ି ତାଇକେନାଏ, ଇନିଃ ଏନ୍‌ ବିଚାର୍‌ନିଃତାଃ ମଣେଁସା ହିଜୁଃୟାନ୍ତେ, ‘ଆଇଁୟାଃ ବାଇରିକତାଃ ଏତେ ଆଇଙ୍ଗ୍‌କେ ନ୍ୟାୟ ଏମାଇଙ୍ଗ୍‌ମେ’ ମେନ୍ତେ ବିନ୍ତିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ଇନିଃ ଚିମିନ୍‌ଦିନ୍‌ କାଏ ମାନାତିଙ୍ଗ୍‌କେଦାଃ, ମେନ୍‌ଦ ତାୟମ୍‌ତେ, ଆଇଙ୍ଗ୍‌ ଦ ‘ପାର୍‌ମେଶ୍ୱାର୍‌କେ କାଇଙ୍ଗ୍‌ ବରଆଇତାନା ଚି ହଡ଼କକେ କାଇଙ୍ଗ୍‌ ମାନାତିଙ୍ଗ୍‌କତାନା’ ");
INSERT INTO unx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ଏନ୍‌ରେୟ ନେ ରାଣ୍ଡିକୁଡ଼ି ବିତ୍‌ଲାଇଙ୍ଗ୍‌ ତାନାଏ, ଏନାତେ ଆଇଙ୍ଗ୍‌ ଇନିୟାଃ ଚେତାନ୍‌ରେ ହବାକାନ୍‌ କା ଲାଗାତିଙ୍ଗ୍‌ କାମି ନାଙ୍ଗ୍‌ ନ୍ୟାୟ ରିକାଏୟାଇଙ୍ଗ୍‌ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନିୟାଃ ଗହରାଅ ଆୟୁମେଆଇଙ୍ଗ୍‌, କା'ରେଦ ଇନିଃ ଜାନାଅ ଜାନାଅ ହିଜୁଃକେଦ୍‌ତେ ହାଏରାନିଆଁ ମେନ୍ତେ ଆୟାଃ ମନ୍‌ରେ କାଜିକେଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ଆଡଃ ପ୍ରାଭୁ କାଜିକେଦାଏ, “ଏନ୍‌ ଏତ୍‌କାନ୍‌ ବିଚାର୍‌ନିଃ ଚିକ୍‌ନାଃ କାଜିକେଦାଏ ଏନା ଆୟୁମେପେ । ");
INSERT INTO unx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ନିଦାସିଙ୍ଗି ହାକାଅଇତାନ୍‌ ଆୟାଃ ସାଲାକାନ୍‌କଆଃ ନାଙ୍ଗ୍‌ ଥିମ୍ବାସାମାଏ ସାହାତିଙ୍ଗ୍‌ରେହ ଚିୟାଃ ନ୍ୟାୟ କାଏ ରୁହାଡ଼ାକଆ ? ");
INSERT INTO unx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିପେତାନାଇଙ୍ଗ୍‌, ଇନିଃ ଇନ୍‌କୁରେ ହବାକାନ୍‌ ଏତ୍‌କାନ୍‌ କାଜିକ ସାଙ୍ଗିନେ ନାଙ୍ଗ୍‌ ଜାଲ୍‌ଦିଗି ନ୍ୟାୟ ଏମ୍‌ରୁହାଡ଼ାକଆଏ । ଏନ୍‌ରେୟ, ମାନୱାହନ୍‌ ହିଜୁଃଇମ୍‌ତା, ଚିୟାଃ ଅତେରେ ବିଶ୍ୱାସ୍‌ ନାମେୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ଆବୁ ଧାର୍‌ମାନ୍‌ଗିୟାଃବୁ ମେନ୍ତେ ଆକରେ ଭାର୍‌ସାଏତାନ୍ ଆଡଃ ଏଟାଃକକେ ହିଲାଙ୍ଗ୍‌କତାନ୍‌, ଚିମିନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ୟୀଶୁ ନେ ଜନ୍‌କା କାଜି କାଜିୟାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ବାର୍‌ହଡ଼୍‌ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃତେ ବିନ୍ତିତେକିନ୍‌ ସେନଃୟାନା, ମିଆଁଦ୍‌ନିଃ ଫାରୁଶୀ ଆଡଃ ଏଟାଃନିଃ ମାଲ୍‌ହାରମ୍‌ନିଃ । ");
INSERT INTO unx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“ଫାରୁଶୀ ଆତମ୍‌ରେ ତିଙ୍ଗୁୟାନ୍ତେ ବିନ୍ତିକେଦାଏ, ‘ହେ ପାର୍‌ମେଶ୍ୱାର୍‌, ଆଇଙ୍ଗ୍‌ ଏଟାଃ ହଡ଼କଲେକା ନାହାଁଲାଇଙ୍ଗ୍‌, ଇନ୍‌କୁଦ ରେଃକ୍‌ନିଃକ, ଏତ୍‌କାନ୍‌କାମିକ, ଆପାଙ୍ଗିର୍‌କ ତାନ୍‌କୁ ଆଡଃ ନେ ମାଲ୍‌ହାରମ୍‌ନିଃ ଲେକାହ ନାହାଁଲାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ଆଇଙ୍ଗ୍‌ ହାପ୍ତାରେ ବାର୍‌ସାଇଙ୍ଗ୍‌ କାଟାବ୍‌ତାନା ଆଡଃ ଗଟା କାମିୟାକାଦ୍‌ରେୟାଃ ଗେଲ୍‌ହିସା ହାନାଟିଙ୍ଗ୍‌ ଏମ୍‌ତାନାଇଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“ଆଡଃ ମାଲ୍‌ହାରମ୍‌ନିଃ ସାଙ୍ଗିନ୍‌ରେ ତିଙ୍ଗୁୟାନ୍ତେ ସିର୍ମାସାଃତେ ସାଙ୍ଗିଲ୍‌ ନାଙ୍ଗ୍‌ କାଏ ସାହାଁସ୍‌କେଦା ମେନ୍‌ଦ ଆୟାଃ କୁଡ଼ାମ୍‌ ଥାପ୍‌ଡ଼ିତାନ୍‌ଲଃ କାଜିକେଦାଏ, ‘ହେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌ ପାପି ତାନିଙ୍ଗ୍‌ ଲିବୁଆଇଙ୍ଗ୍‌ମେଁ ।’” ");
INSERT INTO unx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ଏନ୍ତେ ୟୀଶୁ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ମାଲ୍‌ହାରମ୍‌ନିଃ ଫାରୁଶୀଏତେ ଆଦ୍‌କା ଧାର୍‌ମାନ୍‌ ମେନ୍ତେ ଲେକାୟାନା ଆଡଃ ଅଡ଼ାଃତେ ସେନଃୟାନା । ଜେତାଏ ମାରାଙ୍ଗ୍‌ୟେଁନ୍‌ନିଃଦ ହୁଡିଙ୍ଗ୍‌ୟଁଃଆଏ ଆଡଃ ଜେତାଏ ହୁଡିଙ୍ଗ୍‌ୟଃଁନିଃଦ ମାରାଙ୍ଗ୍‌ଆଁଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଆଡଃ ୟୀଶୁ ସିଟିଆ ହନ୍‌କକେ ଜୁଟିଦ୍‌କକାଏ ମେନ୍ତେ ହଡ଼କ ଇନ୍‌କୁକେ ଇନିଃତାଃ ଆଉକେଦ୍‌କଆକ, ମେନ୍‌ଦ ଚେଲାକ ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେକ ମାରାଙ୍ଗ୍‌ମଚାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ ଆୟାଃତାଃ ହାକାଅକେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, “ହୁପ୍‌ଡିଙ୍ଗ୍‌ ହନ୍‌କକେ ଆଇଙ୍ଗ୍‌ତାଃ ହିଜୁଃରିକାକପେ ଆଡଃ ଇନ୍‌କୁକେ ଆଲ୍‌ପେ ରୁହାଡ଼୍‌କଆ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ଦ ନେ'ଲେକାନ୍‌କଆଃଗିଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଜେତାଏ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌କେ, ହୁଡିଙ୍ଗ୍‌ହନ୍‌ ଲେକା କାଏ ତେଲାଏରେଦ ଇନିଃ ଜେତାଲେକାତେ ଏନାରେ କାଏ ବଲଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ଆଡଃ ମିଆଁଦ୍‌ ହାକିମ୍‌ ୟୀଶୁକେ କୁଲିକିୟାଏ, “ଏ ବୁଗିନ୍‌ ଇତୁନିଃ, ଜାନାଅ ଜୀଦାନ୍‌ ନାମେ ନାଗେନ୍ତେ ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ?” ");
INSERT INTO unx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ୟୀଶୁ କୁଲିକିୟାଏ, “ଆମ୍‌ ଚିନାଃମେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ ବୁଗିନ୍‌ ମେନ୍ତେମ୍‌ କାଜିଇଙ୍ଗ୍‌ତାନା ? ମିଆଁଦ୍‌ନିଃ ଏସ୍‌କାର୍‌ ବୁଗିନାଏଃ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଃ ଆଡଃ ଜେତାଏକାହା । ");
INSERT INTO unx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ଆମ୍‌ ଆନ୍‌ଚୁମ୍‌ ସାରିତାନା, ‘ଆଲମ୍‌ ଆପାଙ୍ଗିର୍‌ରାଃ, ଆଲମ୍‌ ଗଗଏୟାଃ, ଆଲମ୍‌ କୁମ୍ବୁଡ଼ୁଇୟା, ହସଡ଼ଗାୱା ଆଲମାଃ, ଏଙ୍ଗା ଆପୁ କିନ୍‌କେ ମାନାତିଙ୍ଗ୍‌କିନ୍‌ମେ ।’” ");
INSERT INTO unx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ଇନିଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ନେ ସବେନ୍‌ ଆନ୍‌ଚୁ ମିଦ୍‌ସିଟିଆଏତେଇଙ୍ଗ୍‌ ମାନାତିଙ୍ଗ୍‌ ଆଉକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ୟୀଶୁ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନିଃକେ କାଜିକିୟାଏ, “ନାହାଃଁହଁ ମିଆଁଦ୍‌ କାଜିତେମ୍‌ ଜାଞ୍ଜିଆକାନାଃ, ଜୁ ଆମ୍‌ ଆମାଃ ସବେନାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ଏନା ରେଙ୍ଗେଃତାନ୍‌କକେ ଏମାକମେ, ଏନ୍ତେ ସିର୍ମାରେ ଖୁର୍ଜିମ୍‌ ନାମେୟା ଆଡଃ ହିଜୁଃକେଦ୍‌ତେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ମେନ୍‌ଦ ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନିଃଦ ପୁରାଃଗି ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନାଏ, ଚିୟାଃଚି ଇନିଃଦ ପୁରାଃଗି କିସାଁଣ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ୟୀଶୁ ଇନିଃକେ ପୁରାଃ ହୁଡିଙ୍ଗ୍‌ଜୀଉକାନ୍‌ ନେଲ୍‌କିଃତେ କାଜିକେଦାଏ, “ଅକନ୍‌ ହଡ଼କଆଃ ଟାକା ପାଏସା ମେନାଃ, ଏନ୍‌ କିସାଁଣ୍‌ ହଡ଼କନାଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ବଲଃ ପୁରାଃଗି ହାମ୍ୱାଲାଃ । ");
INSERT INTO unx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","କିସାଁଣ୍‌ ହଡ଼ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ବଲଏତେ ସୁଇ ଉଣ୍ଡୁଃତେ ଉଁଟ୍‌ ପାରମଃତେୟାଃ ରାୱାଲାଃ ମେତାଦ୍‌କଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଆଡଃ ନେଆଁଁ ଆୟୁମ୍‌ତାନ୍‌କ ମେନ୍‌କେଦାଃ, “ତାବ୍‌ଦ ଅକଏ ଜୀଉବାଞ୍ଚାଅ ନାମ୍‌ ଦାଡ଼ିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ମେନ୍‌ଦ ୟୀଶୁ କାଜିକିୟାଏ, “ହଡ଼କତେ କା ହବାଦାଡ଼ିୟଃ କାଜି ପାର୍‌ମେଶ୍ୱାର୍‌ତେ ହବାଦାଡ଼ିୟଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ନେଲେମେ, ଆଲେଦ ସବେନାଃ ବାଗିକେଦ୍‌ତେ ଆମ୍‌କେଲେ ଅତଙ୍ଗ୍‌କେଦ୍‌ମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ନାଗେନ୍ତେ ଆପ୍‌ନାଃ ଅଡ଼ାଃ ଚାଏ କୁଡ଼ି ଚାଏ ହାଗା ଚାଏ ଏଙ୍ଗା ଆପୁକ ଚାଏ ହନ୍‌କକେ ବାଗିକାଦ୍‌ ସବେନ୍‌ ହଡ଼କ, ");
INSERT INTO unx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ନେ ସାମାଏରେଗି ଏନାଏତେ ଆଦ୍‌କାକ ନାମେୟା ଆଡଃ ହିଜୁଃ ଦିପିଲିରେ ଜାନାଅ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌କ ନାମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ୟୀଶୁ ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ ଗେନାତେ ଇଦିକେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, “ନେଲେପେ ଆବୁ ଯୀରୁଶାଲେମ୍‌ତେବୁ ସେନଃତାନା ଆଡଃ ମାନୱାହନ୍‌ଆଃ ବିଷାଏରେ ନାବୀକ ଅଲାକାଦ୍‌ ସବେନାଃ ପୁରାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ଇନିଃ ସାଅଁସାର୍‌ ହଡ଼କଆଃ ତିଃଇରେ ଏମଃଆଏ । ଇନ୍‌କୁ ଇନିଃକେକ ଲାନ୍ଦାଇୟା, ହିଲାଙ୍ଗ୍‌ଇଁୟା, ଆଡଃକ ବେଜିୟା । ");
INSERT INTO unx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ହାଁଣ୍‌ସାଇୟା ଆଡଃକ ଗଜିୟା, ଇନିଃ ଆପି ମାହାଁରେ ଜୀଉବିରିଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ମେନ୍‌ଦ ଇନ୍‌କୁ ନେ କାଜିକ ଜେତ୍‌ନାଃ କାକ ମୁଣ୍ଡିକେଦାଃ, ନେ କାଜି ଇନ୍‌କୁଆଃ ଆୟାର୍‌ରେ ଉକୁଆକାନ୍‌ ତାଇକେନା, ଆଡଃ ଇନ୍‌କୁ କାଜିୟାକାନ୍‌ତେୟାଃ କାକ ଆଟ୍‌କାର୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ୟୀଶୁ ଯିରିହୋ ସାହାର୍‌ତେ ସେଟେର୍‌ତାନ୍‌ ତାଇକେନ୍‌ରେ ମିଆଁଦ୍‌ କାଣାଁକାନ୍‌ ହଡ଼ ହରାଗେନାରେ ଦୁବ୍‌କେଦ୍‌ତେ କଏଁ ତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ଆଡଃ ପୁରାଃ ହଡ଼କ ସେନ୍‌ପାରମଃତାନ୍‌ ଆୟୁମ୍‌କେଦ୍‌କଚି, “ନେଆଁଁ ଚିକ୍‌ନାଃ ହବାଅଃତାନାଃ” ମେନ୍ତେ କୁଲିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ ପାରମଃତାନାଏ” ମେନ୍ତେକ ଉଦୁବ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ଏନ୍ତେ ଇନିଃ “ହେ ୟୀଶୁ, ହେ ଦାଉଦ୍‌ଆଃ ହନ୍‌ ଲିବୁଆଇଙ୍ଗ୍‌ମେଁ” ମେନ୍ତେ କାଉରିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ଆୟାରାକାନ୍‌କ ହାପାନ୍‌ମେ ମେନ୍ତେକ ମାରାଙ୍ଗ୍‌ମଚାକିୟାଃ, ମେନ୍‌ଦ ଇନିଃ, “ହେ ଦାଉଦ୍‌ଆଃ ହନ୍‌ ଦାୟାଇଙ୍ଗ୍‌ମେ” ମେନ୍ତେ ଆଡଃଗି ହାକାଅକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ୟୀଶୁ ତିଙ୍ଗୁୟାନ୍ତେ ଇନିଃକେ ଆଇଙ୍ଗ୍‌ତାଃ ଆଉୱିପେ ମେନ୍ତେ ଆଚୁକେଦ୍‌କଆ ଆଡଃ ନାଡ଼େଃୟାନ୍‌ଚି କୁଲିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ଆମ୍‌ ଚିନାଃମ୍‌ ଆସିତାନା, ଆଇଙ୍ଗ୍‌ ଆମାଃ ନାଙ୍ଗ୍‌ ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ମେନ୍ତେମ୍ ସାନାଙ୍ଗ୍‌ତାନା” ମେନ୍ତେ କୁଲିକିୟାଏ । ଇନିଃ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ମେଦ୍‌ତାଇଙ୍ଗ୍‌ ଆଡଃମିସା ନେଲ୍‌ ଦାଡ଼ିକା ।” ");
INSERT INTO unx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ୟୀଶୁ କାଜିକିୟାଏ, “ତାବ୍‌ଦ ମେଦ୍‌ତାମ୍‌ ନାମ୍‌ଜମେମେଁ; ଆମାଃ ବିଶ୍ୱାସ୍‌ ଆମ୍‌କେ ବୁଗିକେଦ୍‌ମେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ଆଡଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଗି ଇନିଃ ନେଲ୍‌ ଦାଡ଼ିକେଦାଏ, ଆଡଃ ୟୀଶୁକେ ଅତଙ୍ଗ୍‌ଇଁତାନ୍‌ଲଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାରାଙ୍ଗ୍‌କିୟାଏ ଆଡଃ ସବେନ୍‌ ହଡ଼କ ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାନାରାଙ୍ଗ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ଆଡଃ ୟୀଶୁ ଯିରିହୋ ନୁତୁମ୍‌ ହାତୁରେ ବଲୟାନ୍‌ଲଃ ଥାଲା ଥାଲାତେ ସେନଃତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ଆଡଃ ନେଲେପେ ଜଖିୟ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ, ଇନିଃ ମାଲ୍‌ହାରମ୍‌କଆଃ ଗମ୍‌କେ ଆଡଃ କିସାଁଣ୍‌ ହଡ଼ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଇନିଃ ୟୀଶୁକେ ଚିଲ୍‌କାନ୍ ହଡ଼ ତାନିଃ ମେନ୍ତେ ନେଲ୍‌ସାନାଙ୍ଗ୍‌ ତାଇକେନାଏ, ଚିୟାଃଚି ଇନିଃ ବୁଟିୟା ହଡ଼ ତାଇକେନାଏ ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କରାଃତେ କାଏ ନେଲ୍‌ ଦାଡ଼ିକିୟା । ");
INSERT INTO unx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ଏନାତେ ଇନିଃ ୟୀଶୁ ପାରମ୍‌ ହରାରେ ନିର୍‌ ଆୟାର୍‌କେଦ୍‌ତେ ୟୀଶୁକେ ନେଲ୍‌ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ଲଆଦାରୁରେ ଦେଏଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଏନ୍‌ ଠାୟାଦ୍ ସେଟେର୍‌ୟାନ୍‌ତେ ୟୀଶୁ ସାଙ୍ଗିଲ୍‌ ରାକାବ୍‌କେଦ୍‌ତେ ଇନିଃକେ ନେଲ୍‌କିୟାଏ ଆଡଃ କାଜିକିୟାଏ, “ଜଖିୟ ମାର୍‌ ଆଡ଼୍‌ଗୁଃମେ, ତିସିଙ୍ଗ୍‌ଦ ଆମାଃ ଅଡ଼ାଃରେ ଆଇଙ୍ଗ୍‌କେ ତାଇନ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ଆଡଃ ଜଖିୟ ଆଡ଼୍‌ଗୁ ଧାବ୍‌ୟାନ୍ତେ ରାସ୍‌କାତେ ୟୀଶୁକେ ଦାରମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ମେନ୍‌ଦ ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ କୁରୁମ୍‌ଡୁରୁମ୍‌ୟାନାକ ଆଡଃ ମେନ୍‌କେଦାଃକ, “ଇନିଃ ପାପିହଡ଼ଆଃ ଅଡ଼ାଃରେ ପେଡ଼ାଅଃତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ମେନ୍‌ଦ ଜଖିୟ ତିଙ୍ଗୁୟାନ୍ତେ ପ୍ରାଭୁକେ କାଜିକିୟାଏ, “ନେଲେମେ ହେ ପ୍ରାଭୁ, ଆଇଙ୍ଗ୍‌ତାଃରେ ମେନାଃତେୟାଃହେତେ ଆଧା, ରେଙ୍ଗେଃତାନ୍‌କକେଇଙ୍ଗ୍‌ ଏମାକଆ, ଆଡଃ ବେଦାତେ ଜେତାଏତାଃଏତେ ଜେତ୍‌ନାଃ ଆଉକାଇରେଦ ଚାର୍‌ଗୁନା ଏମ୍‌ରୁହାଡ଼େୟାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ତିସିଙ୍ଗ୍‌ ନେ ଅଡ଼ାଃରେ ଜୀଉବାଞ୍ଚାଅ ତେବାଃକାନା, ଚିୟାଃଚି ନେ ହଡ଼, ହଁ'ଦ ଆବ୍ରାହାମ୍‌ଆଃ ହନ୍‌ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ଚିୟାଃଚି ମାନୱାହନ୍‌ଦ ଆଦାକାନ୍‌କକେ ନାନାମ୍ ଆଡଃ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ହିଜୁଆକାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ହଡ଼କ ନେଆଁଁ ଆୟୁମ୍‌ତାନ୍‌ ତାଇକେନ୍‌ଇମ୍‌ତା, ଇନିଃ ମିଆଁଦ୍‌ ଜନ୍‌କା କାଜି କାଜିଏଟେଦ୍‌କେଦାଃଏ, ଚିୟାଃଚି ଇନିଃଦ ଯୀରୁଶାଲେମ୍‌ ନାଡ଼େଃରେ ତାଇକେନାଏ ଆଡଃ ଇନ୍‌କୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ବଦେଗି ଉଦୁବଃଆ ମେନ୍ତେ ଆଟ୍‌କାରେତାନ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ଇନିଃ କାଜିକେଦାଏ, “ମାରାଙ୍ଗ୍‌ ଜାତିରେନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ରାଇଜ୍‌ ଚାଲାଅରେୟାଃ ଇନିତୁ ନାମ୍‌ ନାଙ୍ଗ୍‌ ସାଙ୍ଗିନ୍‌ ଦିଶୁମ୍‌ତେ ସେନଃୟନା ଆଡଃ ଇନିଃ ଏନ୍ତାଃଏତେ ଠାଉକା ନେଡାରେ ହିଜୁଃରୁହାଡ଼୍‌ ନାଙ୍ଗ୍‌ ଉହାଟ୍‌କାଦ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ଏନାମେନ୍ତେ ଇନିଃ ଆୟାଃ ଦାସିକଏତେ ଗେଲ୍‌ଝାନ୍‌କକେ ହାକାଅକେଦ୍‌ତେ ମିମିଆଦ୍‌ ହଡ଼କକେ ଗେଲ୍‌ଠୁ ସୋନା ସିକା ଏମାଦ୍‌କଆଏ । ‘ଆଉରିଙ୍ଗ୍‌ ହିଜୁଃରୁହାଡ଼୍‌ ଜାକେଦ୍‌ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ଏପେ’ ମେତାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ମେନ୍‌ଦ ଆୟାଃ ଦିଶୁମ୍‌ରେନ୍‌କ ଇନିଃକେ ଖିସ୍‌ଆଇତାନ୍‌କ ତାଇକେନା, ଆଡଃ ‘ଏନ୍‌ହଡ଼ ଆଲେୟାଃ ରାଇଜ୍‌ରେ ରାଜା ହବାଅଃକାଏ ନେଆଁଁ ଆଲେ କାଲେ ସାନାଙ୍ଗ୍‌ତାନା’ ମେନ୍ତେ କାଜିସେଟେର୍‌ନିଃକେ କାଜିସେଟେର୍‌ତେ ଇନିୟାଃତାଃକ କୁଲ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ଏନ୍‌ରେହ ଇନିଃ ରାଇଜ୍‌ନାମ୍‌କେଦାଏ, ଆଡଃ ହିଜୁଃରୁହାଡ଼୍‌ୟାନାଏ । ଏନ୍ତେ ସୋନା ସିକା ନାମାକାଦ୍‌ ଦାସିକଏତେ ମିଆଁଦ୍‌ନିଃ ଚିମିନାଙ୍ଗ୍‌ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ କେଦ୍‌ତେ ପସାକାଦାଃକ ଏନା ସାରିନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ତାଃ ହାକାଅକପେ ମେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ସିଦାନିଃ ହିଜୁଃୟାନ୍ତେ କାଜିକିୟାଏ, ‘ହେ ଗମ୍‌କେ, ଆମ୍‌ ଏମାକାଦ୍‌ ସୋନା ସିକାଏତେ ଆଇଙ୍ଗ୍‌ ଗେଲ୍‌ଠୁ ସୋନା ସିକା ଆଦ୍‌କା ପସାକାଦାଇଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ଇନିୟାଃ ଗମ୍‌କେ କାଜିକିୟାଏ, ‘ସାବାସ୍‌, ଆଇଁୟାଃ ବୁଗିନ୍‌ ଦାସି ! ଆମ୍‌ ବୁଗିନ୍‌ ଆଡଃ ପାତିୟାର୍‌ରଃ ଲେକାନ୍‌ ଦାସି ତାନ୍‌ମେ । ଆମ୍‌ ହୁଡିଙ୍ଗ୍‌ତେୟାଃରେ ପାତିୟାର୍‍ରଃ ଲେକାମ୍‌ କାମିକାଦ୍‌ ହରାତେ, ଆମ୍‌ ଗେଲ୍‌ ନାଗାର୍‌ରେନ୍‌ ଆକ୍‌ତେୟାର୍‌ନିଃ ହବାଅଃଆମେ ।’ ");
INSERT INTO unx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ଏଟାଃ ଦାସି ହିଜୁଃୟାନ୍ତେ କାଜିକିୟାଏ, ‘ହେ ପ୍ରାଭୁ, ଆମ୍‌ ଏମାକାଦ୍‌ ସୋନା ସିକାଏତେ ମଣେୟାଁ ସୋନା ସିକା ଆଦ୍‌କା ପସାୟାନା ।’ ");
INSERT INTO unx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ଇନିୟାଃ ଗୁସିୟାଁ ଇନିଃକେ କାଜିକିୟାଏ, ‘ଆମ୍‌ଦ ମଣେୟାଁ ନାଗାର୍‌ରେନ୍‌ ଗମ୍‌କେୟଃମେଁ ।’ ");
INSERT INTO unx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“ଏନ୍ତେ ଆଡଃଗି ଏଟାଃ ଦାସି ହିଜୁଃୟାନ୍ତେ କାଜିକିୟାଏ, ‘ହେ ପ୍ରାଭୁ ନେଲେମେ ଆମ୍‌ ଏମାକାଦ୍‌ ସୋନା ସିକାକେ ତାରାଲିଜାଃରେଇଙ୍ଗ୍‌ ଦହପଟମାକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ଆମ୍‌ କେଟେଦ୍‌ ମନ୍‍ରେନ୍‌ ହଡ଼ ତାନ୍‌ମେ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ବରଆମେ ତାଇକେନାଇଙ୍ଗ୍‌, ଆମ୍‌ କାମ୍‌ ଦହତେୟାଃ ଇଦିୟାଃମେ ଆଡଃ କାମ୍‌ ହେର୍‌ତେୟାଃ ଇର୍‌ଇଦିୟାଃମେ ।’ ");
INSERT INTO unx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ଇନିୟାଃ ପ୍ରାଭୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, ‘ଏ ଏତ୍‌କାନ୍‌ ଦାସି, ଆମାଃ କାଜିତେଗିଙ୍ଗ୍‌ ବିଚାର୍‌ମେୟାଃ । ଆଇଙ୍ଗ୍‌ କେଟେଦ୍‌ ମନ୍‌ରେନ୍‌ ହଡ଼ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ଦହ ଏନାଇଙ୍ଗ୍‌ ଇଦିୟା ଆଡଃ କାଇଙ୍ଗ୍‌ ହେର୍ ଏନାଇଙ୍ଗ୍‌ ଇର୍‌ଇଦିୟାଃ, ଏନା ସାରିତାନାମ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ଚିନାଃମେନ୍ତେ ଆମ୍‌ ଆଇଁୟାଃ ଟାକାକେ ବେଙ୍କ୍‌ରେ କାମ୍‌ ଦହକେଦା ? ଆଇଙ୍ଗ୍‌ ହିଜୁଃରୁହାଡ଼୍‌କେଦ୍‌ତେ ସବେନ୍‌ ମୁଲ୍‌'କାନ୍‌ତାର୍‌ଲଃ ଟାକା ନାମ୍‍ରୁହାଡ଼୍‌ କେଦ୍‌ତେୟାଃଇଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“ଏନ୍ତେ ଇନିଃ ତିଙ୍ଗୁଜାପାଃକାନ୍‌ ହଡ଼କକେ କାଜିୟାଦ୍‌କଆଏ, ଏନ୍‌ ସୋନା ସିକା ଇନିଃତାଃଏତେ ରେଃଜିପେ ଆଡଃ ଗେଲ୍‌ ସୋନା ସିକା ନାମାକାଦ୍‌ ହଡ଼କେ ଏମାଇପେ । ");
INSERT INTO unx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ମେନ୍‌ଦ ଇନ୍‌କୁ କାଜିକିୟା ‘ହେ ପ୍ରାଭୁ, ଗେଲ୍‌ ସୋନା ସିକା ଇନିଃତାଃରେୟା । ");
INSERT INTO unx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ଇନିଃ ମେନ୍‌ରୁହାଡ଼ାଦ୍‌କଆଏ, ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ସବେନ୍‌ ମେନାଃନିଃକକେ ଏମଃଆ, ମେନ୍‌ଦ ଜେତାଏତାଃରେ ବାନଃଆ, ଇନିଃତାଃଏତେ ଅକ୍‌ନାଃ ମେନାଃ ଏନାହଗି ଇଦିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ମେନ୍‌ଦ ଆଲେରେ ଇନିଃ ରାଇଜେକାଏ ଏନା କା ସାନାଙ୍ଗ୍‌ତାନ୍ ତାଇକେନ୍‌ ଆଇଁୟାଃ ବାଇରିକକେ ନେତାଃ ଆଉକୁପେ ଆଡଃ ଆଇଁୟାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ମାଃଆକପେ ।’” ");
INSERT INTO unx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ୟୀଶୁ ନେଆଁଁ କାଜିକେଦ୍‌ଚି, ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃ ନାଗେନ୍ତେ ଆୟାଃ ଚେଲାକତାଃଏତେ ଆୟାର୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ଆଡଃ ଜାଇତୁନ୍‌ ନୁତୁମ୍‌ ବୁରୁ ହେପାଦ୍‌ରେ ତାଇନ୍‌ତାନ୍‌ ବେତ୍‌ଫାଗି ଆଡଃ ବେଥ୍‌ନିଆ ହାତୁତାଃ ସେଟେର୍‌ୟାନ୍‌ଚି ଇନିଃ ଆୟାଃ ବାର୍‌ହଡ଼୍‌ ଚେଲାକିନ୍‌କେ ନେଆଁଁଏ କାଜିକେଦ୍‌କିନା, ");
INSERT INTO unx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ଆବେନାଃ ଆୟାର୍‌ରେୟାଃ ହାତୁତେ ସେନଃବେନ୍‌, ଆଡଃ ଏନାରେ ବଲଇମ୍‌ତାଗି ଆବେନ୍‌ ତଲାକାନ୍‌ ଗାଧାହନ୍‌କେବେନ୍ ନାମିଆଁ, ଇନିଃରେ ଜେତାଏ ହଡ଼ ଚିଉଲାହ କାଏ ଦୁବାକାନା, ଇନିଃକେ ରାଡ଼ା ଆଉୱିବେନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ଜେତାଏ ଚିନାଃମେନ୍ତେ ଇନିଃକେବେନ୍ ରାଡ଼ାଇତାନା ମେନ୍ତେ କୁଲିବେନ୍‌ରେଦ, ଇନିଃକେ ମେତାଇବେନ୍‌, ନିଃ'ତାଃରେ ପ୍ରାଭୁଆଃ କାମିମେନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ଏନ୍‌ କୁଲାକାନ୍‌କିନ୍‌ ସେନଃୟାନ୍ତେ ୟୀଶୁ କାଜିୟାଦ୍‌କିନ୍‌ ଲେକା ନାମ୍‌କିୟାଃକିନ୍ । ");
INSERT INTO unx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ମେନ୍‌ଦ ଇନ୍‌କିନ୍‌ ଗାଧାହନ୍‌କେ ରାଡ଼ାଇତାନ୍‌ଇମ୍‌ତା ଇନିୟାଃ ଗମ୍‌କେକ “ଚିକାନାଗେନ୍ତେ ରାଡ଼ାଇତାନାବେନ୍‌ ମେନ୍ତେ କୁଲିକେଦ୍‌କିନାକ ?” ");
INSERT INTO unx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ଇନ୍‌କିନ୍‌, “ନିଃତାଃରେ ପ୍ରାଭୁଆଃ କାମିମେନାଃ” ମେନ୍ତେ କାଜିୟାଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ଇନ୍‌କିନ୍‌ ଗାଧାହନ୍‌କେ ୟୀଶୁତାଃତେ ଆଉକିୟାକିନ୍‌, ଆଡଃ ଗାଧା ଚେତାନ୍‌ରେ ଆକିନାଃ ଲିଜାଃକିନ୍‌ ଆଟେଦ୍‌କେଦା ଆଡଃ ୟୀଶୁକେ ଦୁବ୍‌କିୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ଆଡଃ ଇନିଃ ସେନଃତାନ୍‌ରେ ହଡ଼କ ଆକଆଃ ଲିଜାଃ ହରାରେକ ଆଟେଦ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ଆଡଃ ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ ନାଡ଼େଃତେ ସେଟେର୍‌ତାନ୍‌ ଇମ୍‌ତା ଏନ୍ତାଃରେୟାଃ ଜାଇତୁନ୍‌ ବୁରୁତେ ସେନଃ ହରାତାଃତେ ସେଟେର୍‌ୟାନ୍‌ଚି ଆୟାଃ ଚେଲାକଆଃ ଗଟାଗହଣାଁ ରାସ୍‌କାୟାନାକ ଆଡଃ ନେଲାକାଦ୍ ତାଇକେନ୍‌ ସବେନ୍‌ ଆକ୍‌ଦାନ୍ଦାଅ କାମି ନାଗେନ୍ତେ କାଉରିତାନ୍‌ଲଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାନାରାଙ୍ଗ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ଆଡଃ କାଜିକେଦାକ, “ପ୍ରାଭୁଆଃ ନୁତୁମ୍‌ତେ ହିଜୁଃତାନ୍‌ ରାଜାକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଶିଷ୍‌ ଏମାଇକାଏ, ସିର୍ମା ଦିଶୁମ୍‌ରେ ଜୀଉସୁକୁ ଆଡଃ ସାଲାଙ୍ଗିଉତାର୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ଗାଦେଲ୍‌ହଡ଼କଏତେ ଚିମିନ୍‌ ଫାରୁଶୀକ କାଜିକେଦାଃକ, ହେ ଗୁରୁ ଆମାଃ ଚେଲାକକେ ହାପାଅଃନାଙ୍ଗ୍‌ ମାରାଙ୍ଗ୍‌ମଚାକମ୍ । ");
INSERT INTO unx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ଇନିଃ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, ଆଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, “ନିକୁ ହାପାନ୍‌ରେଦ ଦିରିକ ହାକାଅବିରିଦାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ ସାହାର୍‌ତେ ନାଡ଼େଃୟାନ୍‌ଚି ସାହାର୍‌କେ ନେଲ୍‌କେଦାଏ ଆଡଃ ଏନାନାଗେନ୍ତେ ରାଆଃକେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ଆଡଃ କାଜିକେଦାଏ, “ଆମ୍‌ଗି ତିସିଙ୍ଗ୍‌ ସୁକୁରାଃ ବିଷାଏକ ସାରିକାଦ୍‌ତେୟାଃମ୍, ମେନ୍‌ଦ ନାହାଁଃ ଏନା ମେଦ୍‌ତାମ୍‌ଏତେ ଉକୁଆକାନା । ");
INSERT INTO unx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆମ୍‌ତାଃ ହିଜୁଃଆ, ଏନ୍‌ରେ ଆମାଃ ବାଇରିକ ଢିପାୟାକ ଆଡଃ ଆମ୍‌କେ ବିହୁର୍‌ମେଁୟାକ ଆଡଃ ସବେନ୍‌ସାଃଏତେ କେସେଦ୍‌ବିହୁର୍‌ମେଁୟାକ । ");
INSERT INTO unx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ଆମ୍‌ ଆଡଃ ଆମାଃ ହନ୍‌କକେ ହାସାରେକ ମିଦ୍‌ପେୟା । ଆମାଃ ଚେତାନ୍‌ରେ ଦିରି ଚେତାନ୍‍ ଦିରି ତିରିୟାଁକାନ୍‍ କା ତାଇନା, ଚିୟାଃଚି ଆମ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ହିଜୁଆକାନ୍‌ ଦିପିଲିକେ କାମ୍‌ ନେଲ୍‌ଉରୁମ୍‌କେଦାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ଏନ୍ତେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ବଲୟାନ୍‌ତେ ଇନିଃ ସବେନ୍‌ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ତାନ୍‌କକେ ହାର୍‌ଅଡଙ୍ଗ୍‌ ଏଟେଦ୍‌କେଦ୍‌ଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିକେଦାଏ ଯେ ଧାରାମ୍‌ପୁଥିରେ ନେଆଁଁ ଅଲାକାନା, ‘ଆଇଁୟାଃ ଅଡ଼ାଃ ବିନ୍ତିଅଡ଼ାଃ ତାନାଃ’ ମେନ୍‌ଦ ଆପେ ନେଆଁଁକେ କୁମ୍ବୁଡ଼ୁକଆଃ ତାଇନଃ ଠାୟାଦ୍‌ପେ ବାଇୟାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ୟୀଶୁ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଇତୁକତାନାଏ ତାଇକେନାଏ, ମେନ୍‌ଦ ମୁଲ୍‌ ଯାଜାକ୍‌କ, ଆଇନ୍‌ ଇତୁକ ଆଡଃ ହଡ଼କଆଃ ମୁଖିଆକ ଇନିଃକେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ମେନ୍‌ଦ ଚିକ୍‌ନାଃବୁ ଚିକାୟା ନେଆଁଁ କାକ ନାମ୍‌ଦାଡ଼ିକେଦାଃ, ଚିୟାଃଚି ସବେନ୍‌ ହଡ଼କଦ ଇନିୟାଃ କାଜି ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଜୁରୁଆକାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌କଏତେ ମୁସିଙ୍ଗ୍‌ ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ହଡ଼କକେ ଇତୁକତାନ୍‌ ଆଡଃ ସୁକୁକାଜି ଉଦୁବାକତାନ୍‌ ତାଇକେନ୍‌ରେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ପ୍ରାଚିନ୍‌କଲଃ ଇନିଃତାଃତେ ହିଜୁଃଲେନ୍ତେ, ");
INSERT INTO unx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ଇନିଃକେକ କୁଲିକିୟାଃ, “ଆମ୍‌ ଅକ ଆକ୍‌ତେୟାର୍‌ତେ ନେଆଁଁକମ୍‌ ରିକାତାନା ? ନେ କାମିକ ରିକାନାଗେନ୍ତେ ଅକଏ ନେ ଆକ୍‌ତେୟାର୍‌ ଏମାକାଦ୍‌ମେଆ ?” ");
INSERT INTO unx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ଇନିଃ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ହଁ ମିଆଁଦ୍‌ କାଜିଙ୍ଗ୍‌ କୁଲିପେୟା, ଆଡଃ ଆପେ କାଜିରୁହାଡ଼ିଙ୍ଗ୍‌ପେ, ");
INSERT INTO unx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ଆଃ ବାପ୍ତିସ୍ମା ସିର୍ମାରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ଚି ମାନୱାତାଃଏତେ ତାଇକେନା ?” ");
INSERT INTO unx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ଏନ୍ତେ ଇନ୍‌କୁ ଆକ ଆକରେକ ଉଡ଼ୁଃକେଦା, “ଆବୁ, ‘ସିର୍ମାରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ’ ମେନେରେଦ ଇନିଃ ‘ଚିକାନାଙ୍ଗ୍‌ ଯୋହାନ୍‌ରେ କାପେ ବିଶ୍ୱାସ୍‌କେଦା’ ମେତାବୁଆଏ ? ");
INSERT INTO unx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ମେନ୍‌ଦ ହଡ଼କ ସାଃଏତେ ମେନେରେଦ ସବେନ୍‌ ହଡ଼କ ଆବୁକେ ଚିଦ୍‌ଗିବୁଆକ, ଚିୟାଃଚି ବାପ୍ତିସ୍ମା ଏମଃନିଃ ଯୋହାନ୍‌ ନାବୀ ତାନିଃ ମେନ୍ତେ ଇନ୍‌କୁ ପୁରାଃଗି ଭାର୍‌ସାକାଦାକ ।” ");
INSERT INTO unx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଏନ୍ତେ ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଏନା କତାଃଏତେ ତାଇକେନା ଏନା କାଲେ ସାରିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ହଁ ଅକ ପେଡ଼େଃତେ ଏନାକଇଙ୍ଗ୍‌ ରିକାତାନା, କାଇଙ୍ଗ୍‌ ଉଦୁବାପେୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ୟୀଶୁ ହଡ଼କକେ ନେ ଜନ୍‌କା କାଜି ଏଟେଦ୍‌କେଦ୍‌ଆଏ, “ମିଆଁଦ୍‌ ହଡ଼ ଦାଖ୍‌ବାକ୍‌ଡ଼ି ବାଇକେଦାଏ, କାର୍‌କାମିହଡ଼କକେ କାର୍‌ ଏମ୍‌କେଦ୍‌ତେ ପୁରାଃ ସାମାଏ ଜାକେଦ୍‌ ଏଟାଃ ଦିଶୁମ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ଇରୋଃଅ ଦିପିଲିରେ ଇନିଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ିରେୟାଃ ଜ ଏମାଇଙ୍ଗ୍‌ପେ ମେନ୍ତେ ମିଆଁଦ୍‌ ଦାସିକେ କାର୍‌ କାମିହଡ଼କତାଃତେ କୁଲ୍‌କିୟାଏ, ମେନ୍‌ଦ କାର୍‌କାମିହଡ଼କ ଇନିଃକେ ଦାଲ୍‌କିୟାଃକ ଆଡଃ ସାମାତିଃଇଗି କୁଲ୍‌ରୁହାଡ଼୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ଇନିଃ ଏଟାଃ ଦାସିକେ କୁଲ୍‌କିୟାଏ, ଇନ୍‌କୁ ଇନିଃକେହ ଦାଲ୍‌କିୟାଃକ ଆଡଃ ହିଲାଙ୍ଗ୍‌କିଦ୍‌ତେ ସାମାତିଃଇଗି କୁଲ୍‌ରୁହାଡ଼୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ଇନିଃ ଆଡଃଗି ଆପିୟାନିଃକେହ କୁଲ୍‌କିୟାଏ, ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ଘାଅକିଃତେକ ଅଡଙ୍ଗ୍‌ଏଣ୍ଡାଃକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ଏନ୍ତେ ଦାଖ୍‌ବାକ୍‌ଡ଼ିରାଃ ଗମ୍‌କେ ମେନ୍‌କେଦାଏ, ‘ଚିନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ? ଆଇଁୟାଃ ଦୁଲାଡ଼୍‌ ହନିଙ୍ଗ୍‌କଡ଼ାକେ କୁଲିୟାଇଙ୍ଗ୍‌, ଇଦୁ ଇନ୍‌କୁ ଇନିଃକେ ମାଇନିୟାକ ।’ ");
INSERT INTO unx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ମେନ୍‌ଦ କାର୍‌କାମିହଡ଼କ ଇନିଃକେ ନେଲ୍‌କିଦ୍‌ଚି ମେପେନ୍‌ୟାନାକ, ‘ନିଃଗି ଗୁସିୟାଁରାଃ ହନ୍‌ ତାନିଃ ଦଲାବୁ ଗଜିୟା, ତାବ୍‌ଦ ନିୟାଃ ହାନାଟିଙ୍ଗ୍‌ ଆବୁଆଃଗି ହବାଅଆଃ ।’ ");
INSERT INTO unx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ଦାଖ୍‌ବାକ୍‌ଡ଼ିଏତେ ଅଡଙ୍ଗ୍‌ଏଣ୍ଡାଃକିୟାଃକ ଆଡଃ ଗଏଃକିୟାଃକ । “ୟୀଶୁ କୁଲିକେଦ୍‌କଆ, ‘ନାହାଁଃଦ ଦାଖ୍‌ବାକ୍‌ଡ଼ି ଗମ୍‌କେ ଇନ୍‌କୁକେ ଚିକ୍‌ନାଃଏ ଚିକାକଆ ? ");
INSERT INTO unx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ଇନିଃ ହିଜୁଃକେଦ୍‌ତେ ଏନ୍‌ କାର୍‌କାମିହଡ଼କକେ ଗଏଃକଆଏ ଆଡଃ ଦାଖ୍‌ବାକ୍‌ଡ଼ି ଏଟାଃକକେ ଏମାକଆଏ ।’” ହଡ଼କ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ମେନ୍‌କେଦାଃକ, “ଆଲକାଏ ଏନ୍‌କାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ୟୀଶୁ ଇନ୍‌କୁସାଃ ନେଲ୍‌କେଦ୍‌ତେ କୁଲିକେଦ୍‌କଆଏ, “ତାବ୍‌ଦ ଧାରାମ୍‌ପୁଥିରେୟାଃ ନେ କାଜିରାଃ ମୁଣ୍ଡି ଚିକ୍‌ନାଃ ତାନାଃ ?” “‘ଅଡ଼ାଃ ବାବାଇକ ଅକ ଦିରିକେକ ଆତମ୍‌ ଏଣ୍ଡାଃକେଦା, ଏନ୍‌ ଦିରି ଅଡ଼ାଃରାଃ କଚାଦିରି ବାଇୟାକାନା ।’ ");
INSERT INTO unx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ଏନ୍‌ ଦିରିରେ ଉୟୁଗଃନିଃ ଗୁଣ୍ଡାଅଃଆଏ ଆଡଃ ଏନା ଜେତାଏରେ ଉୟୁଗଃରେଦ ଇନିଃକେ ରିଦିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଇନିଃ ନେ ଜନ୍‌କା କାଜି ଆବୁକେ କାଜିୟାଦ୍‌ବୁଆଏ ନେଆଁଁ ସାରିକେଦ୍‌ତେ ଏନ୍‌ ଦିପିଲିରେଗି ଇନିଃକେ ସାସାବ୍ ସାନାଙ୍ଗ୍‌ ତାଇକେନାକ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଗାଦେଲ୍ ହଡ଼କକେ ବରକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ଏନାତେ ଇନ୍‌କୁ ୟୀଶୁଆଃ କାଜିରେ ଭୁଲ୍‌ ସାବିନାଙ୍ଗ୍‌ ଚିମିନ୍‌ ହଡ଼କ ଆପାନ୍‌କେ ଧାର୍‌ମାନ୍‌ ମେନ୍ତେ ଉଦୁବେନ୍‌ତାନ୍‌କକେ କୁଲ୍‌କେଦ୍‌କଆକ, ଜେ'ଲେକାଚି ଇନ୍‌କୁ ଇନିଃକେ ସାବ୍‌କେଦ୍‌ତେ ରୋମ୍‌ରେୟାଃ ପେଡ଼େଃ ଆଡଃ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ ଲାଟ୍‌ସାହେବ୍‌ତାଃରେକ ଜିମାଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ଏନାତେ ଇନ୍‌କୁ କୁଲିକିୟାଃକ, “ହେ ଗୁରୁ, ଆମ୍‌ ବୁଗିଲେକାତେମ୍‌ କାଜିତାନା ଆଡଃ ଇତୁତାନା ଆଡଃ ହଡ଼କଆଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ କାମ୍‌ ନେନେଲାଃ, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ହରା ସାର୍‌ତିତେମ୍‌ ଇତୁତାନା, ଏନାଲେ ସାରିତାନା । ");
INSERT INTO unx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","କାଜିୟାଲେମ୍‌, ଚିୟାଃ ଆଲେ କାଇସାର୍‌କେ କାର୍‌ ଏମାଇ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଚି କା ?” ");
INSERT INTO unx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁଆଃ ବେଦା ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ମୁସିଙ୍ଗ୍‌ରାଃ ନାଲା ସିକା ଆଉୱାଇଙ୍ଗ୍‌ପେ, ନେଆଁଁ ଅକଏୟାଃ ମୁରୁତ୍‌ ଆଡଃ ଅନଲ୍‌ ତାନାଃ ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “କାଇସାର୍‌ଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ତାବ୍‌ଦ କାଇସାର୍‌ଆଃ କାଇସାର୍‌କେ ଏମାଇପେ, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଏମାଇପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ଇନ୍‌କୁ ହଡ଼କଆଃ ଆୟାର୍‌ରେ ୟୀଶୁଆଃ କାଜିରେ କାକ ସାବ୍‌ ଦାଡ଼ିକିୟାଃ, ଆଡଃ ଇନିୟାଃ କାଜିରୁହାଡ଼୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନ୍‌ଲଃ ହାପାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ସାଦୁକିକଏତେ ଚିମିନ୍‌ହଡ଼କ ୟୀଶୁତାଃତେକ ହିଜୁଃୟାନା, ଇନ୍‌କୁଦ ଜୀଉବିନିରିଦ୍‌ ବାନଃଆମେନ୍ତେକ କାଜିୟା, ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ କୁଲିକିୟାଃକ, ");
INSERT INTO unx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ହେ ଗୁରୁ, ଜେତାଏ ହଡ଼ଆଃ ହନ୍‌ଗାଁଣା ବାନ୍‌କୁୟାନ୍ତେ ଆୟାଃ କୁଡ଼ିତେକେ ଗଏଃବାଗିରେ ହାଗାତେ ଇନିୟାଃ କୁଡ଼ିତେକେ ଆଣ୍‌ଦିୟଃକା ଆଡଃ ହାଗାତେୟାଃ ନୁତୁମ୍‌ତେ ହନ୍‌ ପସାକକାଏ, ନେଆଁଦ ମୁଶା ଆଲେ ନାଗେନ୍ତେ ଅଲାକାଦାଏ ମେନ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ନେଲେମେ ସାତ୍‌ ହାଗିୟା ତାଇକେନାକ, ଆଡଃ ମାରାଙ୍ଗ୍‌ନିଃ ଆଣ୍‍ଦିକେଦ୍‍ତେ ବେଗାର୍‌ ହନ୍‌ଗାଁଣାତେ ଗଏଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ଆଡଃ ବାରିୟାନିଃ ଇନିଃକେ ଆଣ୍‌ଦିୟାନାଏ ଆଡଃ ଇନିଃହ ବେଗାର୍‌ ହନ୍‌ଗାଁଣାତେ ଗଏଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ଏନ୍ତେ ଆପିୟାନିଃ ଇନିଃକେ ଆଣ୍‌ଦିୟାନାଏ ଆଡଃ ନେ ଲେକାଗି ସାତ୍‌ ହାଗିୟାକହଁ ବେଗାର୍‌ ହନ୍‌ଗାଁଣାତେ ଗଏଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ତାୟମ୍‌ତେ, କୁଡ଼ିୟଗି ଗଏଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ନାହାଁଃଦ ଜୀଉବିନିରିଦ୍‌ ଇମ୍‌ତା ଇନିଃ ଅକଏୟାଃ କୁଡ଼ି ହବାଅଆଃଏ ? ଏନ୍‌ ସାତିୟ ହାଗିୟାକଦ ଇନିଃକେ ଆଣ୍‌ଦିୟାକାନ୍‌ ତାଇକେନାକ ।” ");
INSERT INTO unx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ୟୀଶୁ ମେନ୍‌ରୁହାଡ଼ାଦ୍‌କଆଏ, “ନେ ଦିପିଲିରେନ୍‌ ହନ୍‌କ ଆଣ୍‌ଦିୟଃତାନା ଆଡଃକ ଆଣ୍‌ଦିକତାନା । ");
INSERT INTO unx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ମେନ୍‌ଦ ହିଜୁଃତାନ୍‌ ପାରିୟାରେ ଜୀହୁଦଃ ହଡ଼କ ଆଡଃ ଗଜାକାନ୍‌କଏତେ ଜୀଉବିନିରିଦ୍‌ଲେକାନ୍‌ ହଡ଼କ କାକ ଆଣ୍‌ଦିୟଃଆ ଆଡଃ କାକ ଆଣ୍‌ଦିନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ଆଡଃ ଇନ୍‌କୁ ଆଡଃମିସା କାକ ଗଏଃଦାଡ଼ିୟଃଆ, ଚିୟାଃଚି ଇନ୍‌କୁଦ ସିର୍ମାରେନ୍‌ ଦାସିକଲେକା, ଆଡଃ ଜୀଉବିନିରିଦ୍‌ରେନ୍‌ ହନ୍‌କ ହବାୟାନ୍ତେ ଇନ୍‌କୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌କୁ । ");
INSERT INTO unx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ମେନ୍‌ଦ ଗଜାକାନ୍‌କ ଜୀଉବିନିରିଦ୍‌ କାଜି ମୁଶାହଁ ଚୁପାଦ୍‌ରେୟାଃ କାଜିତେ ଉଦୁବାକାଦାଏ, ଏନ୍‌ରେ ଇନିଃ ପ୍ରାଭୁକେ କାଜିକିୟାଏ, ‘ଆମ୍‌ ଆବ୍ରାହାମ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଆଡଃ ଇସାକ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଆଡଃ ଯାକୁବ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନ୍‌ମେ ।’ ");
INSERT INTO unx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ନେଲେମେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଗଜାକାନ୍‌କଆଃଦ ନାହାଁଲିଃ, ମେନ୍‌ଦ ଜୀହୁଦ୍‌ତାନ୍‌କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଃ, ଇନିଃ ନାଗେନ୍ତେଦ ସବେନ୍‌କ ଜୀହୁଦଃତାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ଆଇନ୍‌ ଇତୁକଏତେ ଚିମିନ୍‌କ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ହେ ଗୁରୁ ଆମ୍‌ ବୁଗିନାମ୍‌ କାଜିୟାକାଦାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ଆଡଃ ଜେତାଏ ଇନିଃକେ ଜେତ୍‌ନାଃ କୁଲିନାଙ୍ଗ୍‌ କାକ ସାହାଁସ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ହଡ଼କ ଖ୍ରୀଷ୍ଟ୍‌ ଦାଉଦ୍‌ଆଃ ହନ୍‌ ତାନିଃ ମେନ୍ତେ ଚିନାଃମେନ୍ତେକ କାଜିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ନେଆଁଁ ଦାଉଦ୍‌ ଆଇଃକ୍‌ଗି ଦୁରାଙ୍ଗ୍‌ ପୁଥିରେ କାଜିତାନାଏ, “‘ପ୍ରାଭୁ ଆଇଁୟାଃ ପ୍ରାଭୁକେ କାଜିୟାଇତାନାଏ, ଆଇଁୟାଃ ଜମ୍‌ତିଃ ସାଃରେ ଦୁବାକାନ୍‌ମେଁ, ");
INSERT INTO unx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ଆଇଙ୍ଗ୍‌ ଆମାଃ ବାଇରିକକେ ପୁରା ଆଉରିଙ୍ଗ୍‌ ହାରାଅକ ଜାକେଦ୍‌ ।’” ");
INSERT INTO unx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“ଦାଉଦ୍‌ଦଃ ଇନିଃକେ ‘ପ୍ରାଭୁ’ ମେତାଇତାନାଏ, ଏନ୍ତେ ଖ୍ରୀଷ୍ଟ୍‌ ଚିଲ୍‌କାତେ ଇନିୟାଃ ହନ୍‌ ତାନିଃ ?” ");
INSERT INTO unx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ସବେନ୍‌ ହଡ଼କ ଆୟୁମ୍‌ତାନ୍‌ ତାଇକେନ୍‌ରେ, ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ଆଇନ୍‌ ଇତୁକତାଃଏତେ ଚିର୍ଗାଲାକାନ୍‌ପେ, ଇନ୍‌କୁ ଜିଲିଙ୍ଗ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନ୍‌ବାଡ଼ା, ଆଡଃ ପିଟ୍‌ ପିଡ଼ିକରେ ଜହାର୍‌ତେଲା ଆଡଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଆୟାର୍‌ରେ ଦୁବ୍‌ନାଙ୍ଗ୍‌ ଆଡଃ ମାରାଙ୍ଗ୍‌ ଜମ୍‌ନୁଁକରେ ସିଦା ଠାୟାଦ୍‌ରେ ଦୁବ୍‌ନାଙ୍ଗ୍‌ ସୁକୁକଆ । ");
INSERT INTO unx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ଇନ୍‌କୁ ରାଣ୍ଡିକୁଡ଼ିକଆଃ ଅଡ଼ାଃକ ଉଦେତାନା ଆଡଃ ବେଦାତେ ଜିଲିଙ୍ଗ୍‌ ଜିଲିଙ୍ଗ୍‌ଗିକ ବିନ୍ତିୟା । ଏନ୍‌ଲେକାନ୍‌ ହଡ଼କଦ ଆଦ୍‌କା ସାଜାଇକ ନାମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ୟୀଶୁ ଆରିଦ୍‌ ରାକାବ୍‌କେଦ୍‌ତେ କିସାଁଣ୍‌ ହଡ଼କ ଆକଆଃ ଦାନ୍‌ ଏମଃ ଖାଜ୍‌ନା ବାକାସ୍‌ରେ ସାଜୁତାନ୍‌ ନେଲ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ଇନିଃ ମିଆଁଦ୍‌ ରେଙ୍ଗେଃ ରାବାଙ୍ଗ୍‌ ରାଣ୍ଡିକୁଡ଼ି ବାରିଆ ହୁପ୍‌ଡିଙ୍ଗ୍‌ ତାମ୍ବା ସିକା ସାଜୁତେୟାଃ ନେଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ନେ ରେଙ୍ଗେଃ ରାଣ୍ଡିକୁଡ଼ି ସବେନ୍‌କଏତେ ଥିମ୍ୱା ଏମାକାଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ଏନ୍‌ ସବେନ୍‌କଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ନାଙ୍ଗ୍‌ ଦାନ୍‌ ବାକାସ୍‌ରେ ଆକଆଃ ଆଦ୍‌କା ମେନାଃତେୟାଃଏତେ କାଟିଃଲେକା ସାଜୁଆକାଦାଃକ ମେନ୍‌ଦ ନିଃ ଆୟାଃ ଜୀଉ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ଅକ୍‌ନାଃ ତାଇକେନା, ଏନା ସବେନାଃଏ ସାଜୁଆକାଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ୟୀଶୁଆଃ ଚିମିନ୍‌ ଚେଲାକ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃ ସୁଗାଡ଼୍‌ ଦିରିତେ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃ ଦାନ୍‌ ରାକାବାକାନ୍‌ ତେୟାଃତେ ସିଙ୍ଗାରାକାନା ମେନ୍ତେ କାଜିକେଦାଃକ, ମେନ୍‌ଦ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“ଏନ୍‌ ଦିପିଲି ହିଜୁଃଆ, ଏନାରେ ଆପେ ନେଲେତାନ୍‌ ସବେନାଃ ହାଦୁଡ଼ଃଆ, ଦିରି ଚେତାନ୍‍ ଦିରି ତିରିୟାଁକାନ୍‍ କା ତାଇନା ।” ");
INSERT INTO unx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ୟୀଶୁଆଃ ଚେଲାକ କୁଲିକିୟାଃକ, “ହେ ଗୁରୁ, ନେଆଁଦ ଚିଉଲା ହବାଅଃଆ ? ଆଡଃ ନେ ସବେନାଃ ହବାଅଃରେୟା ଚିକାନ୍‌ ଚିହ୍ନାଁ ଉଦୁବଃଆ ?” ");
INSERT INTO unx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ଇନିଃ କାଜିକେଦାଏ, “ଚିର୍ଗାଲାକାନ୍‍ପେ, ଆଲ୍‌ପେ ବେଦାଅଆଃ, ପୁରାଃ ହଡ଼କଦ ଆଇଙ୍ଗ୍‌ ଇନିଃଗି ତାନିଙ୍ଗ୍‌ ଆଡଃ ସାମାଏ ନାଡ଼େଃକାନା ମେନ୍ତେ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେକ ହିଜୁଃଆ, ଇନ୍‌କୁକେ ଆଲ୍‌ପେ ଅତଙ୍ଗ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ଆପେ ମାପାଃତୁପୁଇଙ୍ଗ୍‌ ଆଡଃ ହାଲାଗୁଲାରେୟାଃ କାଜି ଆୟୁମେରେ ଆଲ୍‌ପେ ଆକ୍‌ବାକାଅଆଃ, ନେ କାଜିକଦ ସିଦାରେ ହବାଅଃଗି ଲାଗାତିୟାଃଁ, ମେନ୍‌ଦ ଟୁଣ୍ଡୁ କା ହିଜୁଃଧାବାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ଏନ୍ତେ ୟୀଶୁ ଆଡଃଗି ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ହଡ଼କଦ ହଡ଼କଆଃ ବିରୁଧ୍‌ରେ ଆଡଃ ରାଇଜ୍‌ ରାଇଜ୍‌ରେୟାଃ ବିରୁଧ୍‌ରେକ ବିରିଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ମିଦ୍‌ତାଃରେ ଅତେ ପୁରାଃ ଏକ୍‌ଲାଅଃଆ, ରିଙ୍ଗା ଆଡଃ ଦୁକୁ, ଆଡଃ ବରଆନ୍‌ତେୟାଃକ ଆଡଃ ସିର୍ମାଏତେ ମାପ୍‌ରାଙ୍ଗ୍‌ ଚିହ୍ନାଁକ ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ମେନ୍‌ଦ ଏନ୍‌ ସବେନାଃ ସିଦାରେ, ହଡ଼କ ଆଇଁୟାଃ ନୁତୁମ୍‌ ନାଗେନ୍ତେକ ସାବ୍‌ପେୟା ଆଡଃକ ସିଗିଦ୍‌ପେୟା । ଇନ୍‌କୁ ସାମାଜ୍‌ ଅଡ଼ାଃକରେକ ଜିମାପେୟା ଆଡଃକ ଜେହେଲ୍‌ପେୟା, ଆଡଃ ରାଜାକଆଃ ଆଡଃ ହାକିମ୍‌କଆଃ ଆୟାର୍‌ରେକ ଇଦିପେୟା । ");
INSERT INTO unx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ମେନ୍‌ଦ ନେଆଁଁ ଆପେୟାଃ ନାଗେନ୍ତେ ଗାୱାଇ ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ମେନ୍‌ଦ ଚିନାଃ କାଜିରୁହାଡ଼େୟାଲେ ମେନ୍ତେ ସିଦାରେ କା ଉଡ଼ୁଃକେଦ୍‌ତେ ଆପେୟାଃ ମନ୍‌ରେ ଉହାଟେପେ । ");
INSERT INTO unx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆପେକେ ନେ'ଲେକାନ୍‌ ବାଚାନ୍‌ରେୟାଃ ପେଡ଼େଃ ଆଡଃ ସେଣାଁ ଏମାପେୟାଇଙ୍ଗ୍‌ ଯେ, ଆପେୟାଃ କାଜିକେ ଆପେୟାଃ ବାଇରିକ ହସଡ଼ କାଜିତାନାଃ ମେନ୍ତେ କାକ କାଜିରୁହାଡ଼୍‌ ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ଆପେୟାଃ ଏଙ୍ଗା ଆପୁକ ଆଡଃ ହାଗାକ ଆଡଃ କୁଟୁମ୍‌କୁପୁଲ୍‌କ ଆଡଃ ଗାତିକ ସାବ୍‌ଇଚିପେୟା ଆଡଃ ଆପେକଏତେ ଚିମିନ୍‌କକେ ଗଏଃଇଚିକଆକ । ");
INSERT INTO unx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ଆଇଁୟାଃ ନୁତୁମ୍‌ ନାଙ୍ଗ୍‌ ସବେନ୍‌ ହଡ଼କ ଆପେକେ ଖିସ୍‌ଆପେୟାକ । ");
INSERT INTO unx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ମେନ୍‌ଦ ଆପେୟାଃ ବହଃଏତେ ମିଆଁଦ୍‌ ଉବ୍‌ହ କା ଜିୟନଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ଆପେ ସାହାତିଙ୍ଗ୍‌ ତାନ୍‌ଲଃ ଆପେୟାଃ ଜୀଉପେ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ଯୀରୁଶାଲେମ୍‌ ଫାଉଦ୍‌ତେ କେସେଦ୍‌ବିୟୁରାକାନ୍‌ ନେଲେ ଇମ୍‌ତା, ଏନାଦ ଉତୁଡ଼୍‌ଧାବଆଃ ମେନ୍ତେ ସାରିପେ । ");
INSERT INTO unx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ଇମ୍‌ତା ଯିହୁଦା ପାର୍‌ଗାନ୍‌ରେ ତାଇନଃତାନ୍‌କ ବୁରୁତେକ ନିର୍‌ତେବାଃକା, ଯୀରୁଶାଲେମ୍‌ ଥାଲାରେ ତାଇନ୍‌ତାନ୍‌କ ଅଡଙ୍ଗ୍‌ଅଃକାକ ଆଡଃ ହାତୁକରେ ତାଇନ୍‌ତାନ୍‌କ ସାହାର୍‌ତେ ଆଲକାକ ବଲଃକା । ");
INSERT INTO unx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ଚିୟାଃଚି ସବେନ୍‌ ଅଲାକାନ୍‌ତେୟାଃ ପୁରାଅଃ ନାଗେନ୍ତେ ନେ ହୁଲାଙ୍ଗ୍‌କଦ ସାଜାଇଅଃରେୟାଃ ହୁଲାଙ୍ଗ୍‌ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ମେନ୍‌ଦ ଏନ୍‍ ଦିପିଲିରେନ୍‌ ବାର୍ଜିଆକାନ୍‍ କୁଡ଼ିକଆଃ ଆଡଃ ତଆ ନୁନୁଆକତାନ୍‍ ଏଙ୍ଗାକଆଃ ନାଗେନ୍ତେ ଚିମିନ୍‌ ବରୱାନ୍‌ଗି ଦୁକୁ ହବାଅଆଃ । ଚିୟାଃଚି ଅତେଦିଶୁମ୍‌ରେଦ ମାରାଙ୍ଗ୍‌ ଦୁକୁ ଆଡଃ ନେ ହଡ଼କରେ ଏନେସେଦ୍ ଠଗଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ଇନ୍‌କୁ ତାରାଉଡ଼ିତେ ମାଗଆଃକ ଆଡଃ ସବେନ୍‌ ଦିଶୁମ୍‌ରେନ୍‌କତାଃତେକ ତଲ୍‌ଇଦିୟଆଃ ଆଡଃ ଏଟାଃ ଜାତିରେନ୍‌କଆଃ ଦିପିଲି ଆଉରି ପୁରାଅଃଜାକେଦ୍‌ ଯୀରୁଶାଲେମ୍‌କେ ଏଟାଃ ଜାତିରେନ୍‌କ ଏନେଁୟା । ");
INSERT INTO unx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ସିଙ୍ଗି, ଚାଣ୍ଡୁଃ, ଆଡଃ ଇପିଲ୍‌କରେ ଚିହ୍ନାଁକ ଉଦୁବଃଆ । ଦରେୟା ଆଡଃ ଆଲ୍‌ପୁଙ୍ଗ୍‌ରେୟାଃ ସାଡ଼ିରେ, ଅତେରେ ଜାତିରେନ୍‌କ ଦୁକୁତେକ ଆକ୍‌ବାକାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ଅତେଦିଶୁମ୍‌ତେ ହିଜୁଃତାନ୍‌ ସାଙ୍କାଟ୍‌କେ ନେଲ୍‌ହରାତାନ୍‌ଲଃ ହଡ଼କ ବରତେ ଗଜଃ ଲେକାକ ହବାଅଃଆ, ଚିୟାଃଚି ସିର୍ମାରେୟାଃ ପେଡ଼େଃୟାନ୍‌ତେୟାଃକ ଏକ୍‌ଲାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ଏନ୍‌ ସାମାଏରେ ହଡ଼କ ମାନୱାହନ୍‌କେ ପେଡ଼େଃ ଆଡଃ ପୁରାଃ ମାନାରାଙ୍ଗ୍‌ଲଃ ରିମିଲ୍‌ରେ ହିଜୁଃତାନ୍‌କ ନେଲିୟା । ");
INSERT INTO unx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ଚିମ୍‌ତାଙ୍ଗ୍‌ ନେଆଁଁକ ଏଟେଜଃରେ ତିଙ୍ଗୁନ୍‌ପେ ଆଡଃ ସାଙ୍ଗିଲେପେ, ଚିୟାଃଚି ଆପେୟାଃ ମୁକ୍ତିଦ ନାଡ଼େୟଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁକେ ନେ ଜନ୍‌କା କାଜି କାଜିୟାଦ୍‌କଆଏ, “ଲଆଦାରୁ ଆଡଃ ସବେନ୍‌ ଦାରୁ ଆଡଃ ଏଟାଃ ଦାରୁକଏତେ ଇତୁନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ଏନା ସୁଡ଼ାଅଃତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ଜେଟ୍‌ସିଙ୍ଗି ନାହାଃଁଦ ନାଡ଼େୟାକାନା ମେନ୍ତେପେ ସାରିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ଏନ୍‌ଲେକାଗି, ନେଆଁଁ ସବେନାଃ ହବାଅଃତାନ୍‌ପେ ନେଲେ ଇମ୍‌ତା ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ରାଇଜ୍‌ ନାଡ଼େୟାକାନା ମେନ୍ତେ ସାରିପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, “ନେ ସବେନାଃ ଆଉରି ହବାଅଃ ଜାକେଦ୍‌ ନେ ଦିପିଲିରେନ୍‌ ହଡ଼କ କାକ ଟୁଣ୍ଡୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ସିର୍ମା ଆଡଃ ଅତେ ଟୁଣ୍ଡୁଉତାରଃଆ, ମେନ୍‌ଦ ଆଇଁୟାଃ କାଜିକ କା ଟୁଣ୍ଡୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ଚିର୍ଗାଲାକାନ୍‌ପେ, କା'ରେଦ ନୁଁରେୟାଃ ବୁନୁଲ୍‌ତେ ଆଡଃ ନେ ଜୀଦାନ୍‌ରେୟାଃ ଉଡ଼ୁଃକେଦ୍‌ତେ ଆପେୟାଃ ମନ୍‌ ହାମ୍ବାଲଆଃ ଆଡଃ ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆପେରେ ଆଚ୍‌କାତେ ଫାସ୍‌ରିଲେକା ହିଜୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ଏନାଦ ଏନ୍‌ ଫାଁସ୍‌ରି ଲେକାଗି ସବେନ୍‌ ଅତେରେନ୍‌କଆଃରେ ହିଜୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ଆପେ ନେ ସବେନ୍‌ ହିଜୁଃତେୟାଃକଏତେ ବାଞ୍ଚାଅ ଆଡଃ ମାନୱାହନ୍‌ଆଃ ଆୟାର୍‌ରେ ତିଙ୍ଗୁଃଦାଡ଼ିକାଲେ ମେନ୍ତେ ସବେନ୍‌ ଦିପିଲିରେ ଏୟନାକାନ୍‌ପେ ଆଡଃ ବିନ୍ତିପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଇତୁକତାନ୍‌ ଆଡଃ ସିଙ୍ଗିହାସୁର୍‌ୟାନ୍ତେ ଜାଇତୁନ୍‌ ବୁରୁରେ ତାଇନ୍‌ତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ଆଡଃ ସେତାଃୟାନ୍‌ରେଦ ସବେନ୍‌ ହଡ଼କ ଇନିୟାଃ କାଜି ଆୟୁମ୍‌ ନାଗେନ୍ତେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃତେ ଇନିଃତାଃକ ହିଜୁଃତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ପାସ୍‌କା ପାରାବ୍‌ ନୁତୁମଃତାନ୍‌ ସାବାଃ ହଲଙ୍ଗ୍‌ରେୟାଃ ପାରାବ୍‌ ନାଡ଼େଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ଆଡଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଆବୁ ୟୀଶୁକେ ଚିଲ୍‌କାବୁ ଗଜିୟା ମେନ୍ତେ ହରାକ ଦାଣାଁଁବାଡ଼ା ତାଇକେନା, ଇନ୍‌କୁଦ ହଡ଼କକେ ବରଆକତାନ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ଏନ୍ତେ ଗେଲ୍‌ବାର୍‌ ଚେଲାକଏତେ, ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା ନୁତୁମଃତାନ୍‌ ମିଆଁଦ୍‌ନିୟାଃରେ ସାଏତାନ୍‌ ବଲୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ଆଡଃ ଇନିଃ ସେନଃୟାନ୍ତେ ଆଇଙ୍ଗ୍‌ ୟୀଶୁକେ ଚିଲ୍‌କା ଆପେୟାଃ ତିଃଇରେ ଜିମାଇୟା ମେନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ସିପାଇକଆଃ ଗମ୍‌କେକଲଃ ବାଖାଁଣ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ଇନ୍‌କୁ ଟାକାଲେ ଏମାମେୟା ମେନ୍ତେ ରାସ୍‌କାତାନ୍‌ଲଃକ ହୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ଆଡଃ ଇନିଃ ରାଜିୟାନାଏ ଆଡଃ କା ହାଲାଗୁଲାଏତାନ୍‌ଲଃ ଇନ୍‌କୁଆଃ ତିଃଇରେ ୟୀଶୁକେ ସାବ୍‍ରିକାଇ ନାଗେନ୍ତେ ସୁଯୋଗ୍‌ ଦାଣାଁଁତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ସାବାଃ ହଲଙ୍ଗ୍‌ରେୟାଃ ପାରାବ୍‌ ଦିପିଲିରେ, ପାସ୍‌କା ପାରାବ୍‌ ନାଗେନ୍ତେ ମିଣ୍ଡିହନ୍‌ଆଃ ଦାଣେଁ ମାୟୋମ୍‌ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ୟୀଶୁ, ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌କେ “ପାସ୍‌କା ପାରାବ୍‌ ନାଙ୍ଗ୍‌ ଜମେୟାଃଁ ବାବାଇ ନାଗେନ୍ତେ” କୁଲ୍‌କେଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ଇନିଃକେ କୁଲିକିୟାକିନ୍‌, “ଆଲିଙ୍ଗ୍‌ ଅକ ଠାୟାଦ୍‌ରେ ବାଇୟାଲିଙ୍ଗ୍‌ ମେନ୍ତେମ୍‌ ସାନାଙ୍ଗ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ୟୀଶୁ ମେତାଦ୍‌କିନାଏ, “ନାଗାର୍‌ରେ ବଲଃ ଇମ୍‌ତା ଦାଆଃଚାଟୁ ତେଙ୍ଗଃକାଦ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ନାମିଁୟାବେନ୍‌, ଇନିଃ ବଲଃ ଅଡ଼ାଃତେ ଅତଙ୍ଗ୍‌ଇଁବେନ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ଆଡଃ ଅଡ଼ାଃରେନ୍‌ ଗମ୍‌କେ କେ କାଜିୟାଇବେନ୍, ‘ଗୁରୁ କୁଲିତାନାଏ, ବାଖ୍‌ରା ଅକ୍‌ତାଃରେୟା ? ଏନ୍ତାଃଦ ଆଇଁୟାଃ ଚେଲାକଲଃ ପାସ୍‌କା ପାରାବ୍‌ରେୟାଃ ଜମେୟାଁଃ ଜମେୟାଁଇଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ଇନିଃ ବାଇସେକାଡ଼ାକାନ୍‌ ମାରାଙ୍ଗ୍‌ ବାଖ୍‌ରା ଉଦୁବାବେନାଏ, ଏନ୍ତାଃରେ ବାଇୟେବେନ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ଇନ୍‌କିନ୍‌ ସେନଃୟାନ୍ତେ ୟୀଶୁ ଉଦୁବାଦ୍‌କିନ୍‌ଲେକା ନାମ୍‌କେଦାଃକିନ୍, ଆଡଃ ପାସ୍‌କା ପାରାବ୍‌ ନାଙ୍ଗ୍‌ ଜମେୟାଁଃକିନ୍‌ ବାଇକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ଆଡଃ ଏନ୍‌ ଦିପିଲି ସେଟେର୍‌ୟାନ୍‌ଚି ୟୀଶୁ ଆୟାଃ ପ୍ରେରିତ୍‌କଲଃ ଜଜମ୍‌ ନାଗେନ୍ତେ ଦୁବ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ୟେଁ ସିଦାରେ ନେ ପାସ୍‌କା ପାରାବ୍‌ରେୟାଃ ଜମେୟାଃଁ ଆପେଲଃ ଜଜମାଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ଆଇଙ୍ଗ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ଏନାରାଃ ସବେନ୍‌ ମୁଣ୍ଡି ଆଉରି ଉଦୁବଃ ଜାକେଦ୍‌ ଆଡଃ ଚିଉଲାହ କାଇଙ୍ଗ୍‌ ଜମାଃ ମେତାପେତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ଆଡଃ କାଟୋରା ଆଉକେଦ୍‌ତେ, ଇନିଃ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌ତାନ୍‌ଲଃ ମେତାଦ୍‌କଆଏ, “ଆପେୟାଃ ଥାଲାରେ ନେଆଁଁ ହାଟିଙ୍ଗ୍‌ୟେଁପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ଆଇଙ୍ଗ୍‌ଦ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆଉରି ହିଜୁଃଜାକେଦ୍‌ ଆଇଙ୍ଗ୍‌ ଦାଖ୍‌ରାସି ଆଡଃ ଚିଉଲାଅ କାଇଙ୍ଗ୍‌ ନୁଁଇଆ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ଆଡଃ ଇନିଃ ହଲଙ୍ଗ୍‌ ସାବ୍‌କେଦ୍‌ତେ, ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍ ଏମ୍‌କିୟାଏ ଆଡଃ ଏନାକେ କେଚାଃକେଦ୍‌ତେ ଇନ୍‌କୁକେ ଏମ୍‌ତାନ୍‌ଲଃ କାଜିୟାଦ୍‌କଆଏ, “ନେଆଁଁ ଆଇଁୟାଃ ହଡ଼୍‌ମତାନାଃ, ଆପେ ନାଗେନ୍ତେ ଏମଃତାନା, ଆଇଙ୍ଗ୍‌କେ ପାହାମିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ନେଆଁଁ ରିକାଏପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ଏନ୍‌ଲେକାଗି, ଇନିଃ ଆୟୁବ୍‌ଜମେୟାଃଁ ତାୟମ୍‌ତେ କାଟୋରା ସାବ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ନେ କାଟୋରା ଆଇଁୟାଃ ମାୟୋମ୍‌ତେ ଆପେୟାଃ ନାଙ୍ଗ୍‌ ଲିଙ୍ଗିୟଃତାନ୍ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଜିନାମାରାଃ ନାୱାନିୟାମ୍‌ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ମେନ୍‌ଦ ନେଲେପେ ଆଇଙ୍ଗ୍‌କେ ସାବ୍‌ଇଚିନିୟାଃ ତିଃଇ ଆଇଁୟାଃଲଃ ମେଜ୍‌ରେୟା । ");
INSERT INTO unx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ମାନୱାହନ୍‌ ଆୟାଃ ନାଗେନ୍ତେ ଦହାକାନ୍‌ ଲେକାଏ ସେନଃତାନା, ମେନ୍‌ଦ ବାଇରିକଆଃ ତିଃଇରେ ଇନିଃକେ ସାବ୍‌ରିକାନିଃ ହାୟ୍ ହାୟ୍ ଚିମିନ୍‌ ଦୁକୁନାମେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ଆଡଃ ଇନ୍‌କୁ ଆବୁଏତେ ନେ କାମି କାମିନିଃ ଅକଏ ତାନିଃ ମେନ୍ତେ ଆକ ଆକରେକ କୁଲିବାଡ଼ାକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ଚେଲାକ ଆବୁଏତେ ଅକଏ ମାରାଙ୍ଗ୍‌ନିଃ ଆଟ୍‌କାରଃଆଏ ମେନ୍ତେକ ଏପ୍‌ରାଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଏଟାଃ ଜାତିରେନ୍‌କଆଃ ରାଜାକ ଇନ୍‌କୁରେକ ରାଇଜେତାନା, ଆଡଃ ଇନ୍‌କୁଆଃରେ ଆକ୍‌ତେୟାର୍‌ ତାନ୍‌କକେ ଗାତିକ କାଜିୟଃତାନା । ");
INSERT INTO unx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ମେନ୍‌ଦ ଆପେ ଆଲ୍‌ପେ ନେକାଅଆଃ, ଆପେୟାଃ ଥାଲାରେ ମାରାଙ୍ଗ୍‌ନିଃ ହୁଡିଙ୍ଗ୍‌ନିଃଲେକା, ଆଡଃ ଆଗୁଆଇନିଃ ସୁସାର୍‌ନିଃ ଲେକା ତାଇନଃକାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ଅକଏ ମାରାଙ୍ଗ୍‌ଆଏ, ଜଜମ୍‌ରେ ଦୁବାକାନ୍‌ନିଃ ଚି ଦାସି ? ଚିୟାଃ ଜଜମ୍‌ରେ ଦୁବାକାନ୍‌ନିଃ କାଏ ମାରାଙ୍ଗ୍‌ଆଁ ? ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେୟାଃ ଥାଲାରେ ମିଆଁଦ୍‌ ଦାସିଲେକାଃଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ଆଇଁୟାଃ ବିନିଡ଼ାଅକରେ ଆଇଙ୍ଗ୍‌ଲଃ ତାଇକାନ୍‌କ ଆପେଗି ତାନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ଆଡଃ ଆପୁଇଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌କେ ରାଇଜ୍‌ ରିକାଏରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ଏମାକାଦିଙ୍ଗ୍‌ ଲେକା ଆଇଙ୍ଗ୍‌ହଁ ଆପେକେ ଆକ୍‌ତେୟାର୍‌ ଏମାପେତାନାଇଙ୍ଗ୍‌, ");
INSERT INTO unx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ଜେ'ଲେକାଚି, ଆପେ ଆଇଁୟାଃ ରାଇଜ୍‌ରେ ଆଇଁୟାଃ ମେଜ୍‌ରେପେ ଜମ୍‌ନୁଁଏୟା ଆଡଃ ରାଜ୍‌ଗାଦିରେ ଦୁବ୍‌କେଦ୍‌ତେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ବାରା କିଲିକଆଃପେ ବିଚାରେୟା । ");
INSERT INTO unx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ଏ ଶିମୋନ୍‌, ଏ ଶିମୋନ୍‌, ନେଲେମ୍ ଚାଷି ଗହମ୍‌କେ ହାଟାଃରେ କେଲାଅକେଦ୍‌ତେ ପେଟେଃକେ ଆତମେଲେକା, ଆପେକେ ବିଡ଼ାଅ ମେନ୍ତେ ସାଏତାନ୍‌ହଗି ବୁଗିନ୍‌ ହଡ଼କତାଃଏତେ ଏତ୍‌କାନ୍‌ ହଡ଼କକେ ଆଲ୍‌ଗାଅରେୟାଃ ଆନ୍‌ଚୁଇ ନାମାକାଦା । ");
INSERT INTO unx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ମେନ୍‌ଦ ଆମାଃ ବିଶ୍ୱାସ୍‌ ଆଲକା ଚାବାଃଅ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆମାଃ ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ବିନ୍ତିୟାକାଦାଃ, ଆଡଃ ଆମ୍‌ ରୁହାଡ଼୍‌ରେଦ ଆମାଃ ହାଗାକକେ ପକ୍‌ତାକମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ ଆମ୍‌ଲଃ ଜେହେଲ୍‌ତେ ସେନ୍‌ ଆଡଃ ଗଜଃ ନାଗେନ୍ତେ ସାପ୍‌ଡ଼ାଅକାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ୟୀଶୁ ମେତାଇଜାଏ, “ଏ ପାତ୍‌ରାସ୍‌, ତିସିଙ୍ଗ୍‌ଗି ସାଣ୍ଡିସିମ୍‌ ରାଆଃ ସିଦାରେ ଆପିସା ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ମେନ୍ତେମ୍‌ ମେନେୟା, ନେଆଁଁଇଙ୍ଗ୍‌ ମେତାମ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କୁଲିକେଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆପେକେ ବେଗାର୍‌ ପାଏସାମୁନା, ଥାଇଲା, ଆଡଃ ଖାର୍‌ପାତେଇଙ୍ଗ୍‌ କୁଲ୍‌କେଦ୍‌ପେରେ, ଚିୟାଃ ଜେତ୍‌ନାଃତେପେ ଜାଞ୍ଜିୟାନା ?” “ଜେତ୍‌ନାଃତେ କାହା” ମେନ୍ତେକ କାଜିରୁହାଡ଼୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ମେନ୍‌ଦ ନାହାଁଃ ପାଏସାମୁନା ତାଇନଃନିଃ ଏନା ଇଦିକାଏ, ଆଡଃ ଥାଇଲାହଁ, ଆଡଃ ଅକଏତାଃରେ ତାରାଉଡ଼ି ବାନଆଃ ଇନିଃ ଆୟାଃ ଲିଜାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ମିଆଁଦ୍‌ କିରିଙ୍ଗ୍‌ୟେଁକାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ନେଆଁ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ଇନିଃ କା ଧାର୍‌ମାନ୍‌ ହଡ଼କଲଃ ଲେକାୟାନାଏ,’ ଆଡଃ ଆଇଙ୍ଗ୍‌ ମେତାପେ ତାନାଇଙ୍ଗ୍‌, ନେଆଁଁ ଆଇଁୟାଃରେ ହବାଅଃଗିୟା । ହେଗି, ଧାରାମ୍‌ପୁଥିରେ ଆଇଁୟାଃ ବିଷାଏରେ ଅଲାକାନ୍‌ତେୟାଃଦ ସାର୍‌ତିଗି ହବାଅଃଗିୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ଚେଲାକ କାଜିକିୟାଃକ, “ହେ ପ୍ରାଭୁ, ନେଲେମେ ବାରିଆ ତାରାଉଡ଼ି ନେତାଃରେୟା ।” ଇନିଃ ମେତାଦ୍‌କଆଏ, “ଇମ୍‌ନାଙ୍ଗ୍‌ରେ ହବାକଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ୟୀଶୁ ସାହାର୍‌ହେତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ଲଃ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ସେନଃତାନ୍‌ଲେକା ଜାଇତୁନ୍‌ ବୁରୁତେ ସେନଃୟାନା, ଆଡଃ ଇନିୟାଃ ଚେଲାକହ ଅତଙ୍ଗ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ଏନ୍‌ ଠାୟାଦ୍‌ରେ ସେଟେର୍‌ୟାନ୍‌ଚି ମେତାଦ୍‌କଆଏ, “ବିଡ଼ାଅରେ ଆଲ୍‌ପେ ଉୟୁଗଃକା ମେନ୍ତେ ବିନ୍ତିପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ୟୀଶୁ ମିଆଁଦ୍‌ ଦିରିହୁଦ୍‌ମାଃ ଇମ୍‌ନାଙ୍ଗ୍‌ ସାଙ୍ଗିନ୍‌ ଇନ୍‌କୁଏତେ ଆତମ୍‌ୟାନାଏ, ଆଡଃ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ବିନ୍ତିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ହେ ଆବା, ଆମ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ନେ କାଟୋରା ଆଇଙ୍ଗ୍‌ଏତେ ଆତମେଁମେ, ଏନ୍‌ରେୟ ଆଇଁୟାଃ ସାନାଙ୍ଗ୍‌ଲେକାଦ କାହା ମେନ୍‌ଦ ଆମାଃ ସାନାଙ୍ଗ୍‌ଲେକା ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ସିର୍ମାସାଃଏତେ ମିଆଁଦ୍‌ ସିର୍ମାରେନ୍‌ ଦାସି ଇନିଃକେ ପେଡ଼େଜି ନାଗେନ୍ତେ ଇନିଃତାଃତେ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ଆଡଃ ୟୀଶୁ ପୁରାଃ ଦୁକୁୟାନ୍ତେ ପୁରାଃଗି ବିନ୍ତିଗରୋଙ୍ଗ୍‌କେଦାଃଏ ଆଡଃ ଇନିୟାଃ ବାଲ୍‌ବାଲ୍‌ଦାଆଃ ଅତେରେ ଜରତାନ୍‌ ସାକିଦ୍‌ ମାୟୋମ୍‌ଲେକାୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଇନିଃ ବିନ୍ତିକେଦ୍‌ତେ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ଆୟାଃ ଚେଲାକତାଃ ରୁହାଡ଼୍‌ୟାନ୍‌ଚି, ଇନ୍‌କୁକେ ଦୁଡ଼ୁମାକାନ୍‌ ନାମ୍‍କେଦ୍‍କଆଏ, ଆଡଃ ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ଇନିଃ କୁଲିକେଦ୍‌କଆଏ, “ଚିନାଃମେନ୍ତେପେ ଦୁଡ଼ୁମ୍‌ତାନା ? ମାର୍‌ ବିରିଦ୍‌ପେ ଆଡଃ ବିଡ଼ାଅରେ ଆଲ୍‌ପେ ଉୟୁଗଃକା ମେନ୍ତେ ବିନ୍ତିପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ୟୀଶୁ ନେଆଁଁ କାଜିତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତାଗି ନେଲେପେ ଗାଦେଲହଡ଼କ ହିଜୁଃୟାନା, ଆଡଃ ଗେଲ୍‌ବାର୍‌ ଚେଲାକଏତେ ଯିହୁଦା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଚେଲା ଇନ୍‌କୁକେ ଆୟାର୍‌ତେ ଆଉକେଦ୍‌କଆ ଆଡଃ ୟୀଶୁକେ ଚଅଃ'ଇ ନାଗେନ୍ତେ ଇନିଃତାଃତେ ନାଡ଼େଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ମେନ୍‌ଦ ୟୀଶୁ ମେତାଇଜାଏ, “ଏ ଯିହୁଦା, ଚିୟାଃ ଆମ୍‌ ମାନୱାହନ୍‌କେ ଚଅଃ'ଇତାନ୍‌ଲମ୍‌ ସାବ୍‌ଇଚିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ୟୀଶୁଲଃ ତାଇକେନ୍‌କ ହବାଅଃତେୟାଃ ନେଲ୍‌କେଦ୍‌ତେ କାଜିକିୟାକ, “ହେ ପ୍ରାଭୁ ଚିୟାଃ ଆଲେ ତାରାଉଡ଼ିତେଲେ ମାଆଃକଆ ? ");
INSERT INTO unx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ଆଡଃ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଦାସିରାଃ ଜମ୍‌ ଲୁତୁର୍‌କେ ମାଆଃଖାଣ୍ଡାଅକେଦାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ମେନ୍‌ଦ ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କେଦାଏ, “ନେଆଁଦ କାହା” ଆଡଃ ଏନ୍‌ ଦାସିଆଃ ଲୁତୁର୍‌ ଜୁଟିଦ୍‌କେଦ୍‌ତେ ଇନିଃକେ ବୁଗିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃତାଃ ହିଜୁଆକାନ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ, ମାନ୍ଦିର୍‌ ହରକଆଃ ଗୁସିୟାଁକ, ଆଡଃ ପ୍ରାଚିନ୍‌କକେ କାଜିୟାଦ୍‌କଆଏ, “ଚିୟାଃ ଆପେ କୁମ୍ବୁଡ଼ୁସାବ୍‌ଲେକା ତାରାଉଡ଼ି ଆଡଃ ଭଙ୍ଗାଟ୍‌କ ସାବ୍‌କେଦ୍‌ତେପେ ହିଜୁଆକାନା ? ");
INSERT INTO unx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ ମାନ୍ଦିର୍‌ରେ ଆପେଲଃ ତାଇକେନ୍‌ଇମ୍‌ତା ଆପେ ଆଇଙ୍ଗ୍‌ରେ ତିଃଇ କାପେ ଜିଲିଙ୍ଗ୍‌କେଦାଃ । ମେନ୍‌ଦ ନେଆଁଁ ଆପେୟାଃ ସାମାଏ ତାନାଃ ଆଡଃ ନୁବାଃରେୟାଃ ରାଇଜ୍‌ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ଇନ୍‌କୁ ୟୀଶୁକେ ସାବ୍‌ଇଦିକିଃତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କଆଃ ଅଡ଼ାଃତେକ ଇଦିକିୟାଃ, ଆଡଃ ପାତ୍‌ରାସ୍‌ ସାଙ୍ଗିନ୍‌ରେ ତାଇକେଦ୍‌ତେ ଦୟା ଦୟା ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ମେନ୍‌ଦ ଇନ୍‌କୁ ଅଡ଼ାଃରାଚାରେ ସେଙ୍ଗେଲ୍‌ତିଙ୍ଗ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ ଦୁବ୍‌ୟାନା, ଆଡଃ ପାତ୍‌ରାସ୍‌ହ ଇନ୍‌କୁଲଃ ଦୁବ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ମିଆଁଦ୍‌ କାମ୍‌ଡ଼ି ଇନିଃକେ ସେଙ୍ଗେଲ୍‌ଜାପାଃରେ ଦୁବାକାନ୍‌ ନେଲ୍‌କିଃତେ ନେଲ୍‌ବାଇକିୟାଏ ଆଡଃ ମେନ୍‌କେଦାଏ, “ନିଃ ହଗି ୟୀଶୁଲଃ ତାଇକେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ମେନ୍‌ଦ ଇନିଃ ଦଦାଦ୍‌ତାନ୍‌ଲଃ କାଜିକିୟାଏ, “ଏ କୁଡ଼ି ଆଇଙ୍ଗ୍‌ଦ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ଆଡଃଘାଡ଼ିକାଦ୍‌ ତାୟମ୍‌ତେ ଏଟାଃ ହଡ଼ ଇନିଃକେ ନେଲ୍‌କିଦ୍‌ତେ ମେତାଇଜାଏ, “ଆମ୍‌ହ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ନିଃ ତାନ୍‌ମେ ।” ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ଏ ହଡ଼ ଆଇଙ୍ଗ୍‌ଦ ନାହାଁଲିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ମିଦ୍‌ଘାଣ୍ଟାଲେକା ତାୟମ୍‌ତେ ଆଡଃ ଏଟାଃନିଃ କାଜିକେଦାଏ, “ସାର୍‌ତିଗି ନିଃହ ଇନିଃଲଃ ତାଇକେନାଏ, ନିଃଦ ଗାଲିଲ୍‌ରେନ୍‌ ନିଃ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଏ ହଡ଼, ଆମ୍‌ କାଜିତାନ୍‌ତେୟାଃ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ।” ପାତ୍‌ରାସ୍‌ ନେଆଁଁ କାଜିତାନ୍‌ ଇମ୍‌ତାଗି ସାଣ୍ଡିସିମ୍‌ ରାଆଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ଏନ୍ତେ ପ୍ରାଭୁ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ପାତ୍‌ରାସ୍‌କେ ଆରିଦ୍‌କିୟାଏ, ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ସାଣ୍ଡିସିମ୍‌ ରାଆଃ ସିଦାରେ ଆପିସା ଆଇଙ୍ଗ୍‌ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ମେନେୟାମ୍‌ ମେନ୍ତେ ପ୍ରାଭୁ କାଜିକାନ୍‌ କାଜିକେ ପାହାମ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ଆଡଃ ପାତ୍‌ରାସ୍‌ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ କୁସୁଦ୍‌ କୁସୁଦ୍‌ ରାଆଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ୟୀଶୁକେ ସାବାକାଇ ହଡ଼କ ଲାନ୍ଦାଇତାନ୍‌ଲଃ ଦାଲ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ଇନିୟାଃ ମେଦ୍‌ ତଲ୍‌ଜାପିଦ୍‌କିଃତେ କୁଲିକିୟାଃକ, “ଆମ୍‌ ପରେ ନାବୀ ତାନ୍‌ମେ, ମାର୍‌ ଉଦୁବାଲେମ୍‌, ଅକଏ ଥାପ୍‌ଡ଼ିକେଦ୍‌ମେଁୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ଆଡଃ ଏଟାଃ ଏଟାଃ ପୁରାଃ ହିଲାଙ୍ଗ୍‌କାଜି ଇନିୟାଃ ବିରୁଧ୍‌ରେକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ଆଙ୍ଗ୍‌ୟାନ୍‌ଲଃଗି ହଡ଼କଆଃ ପ୍ରାଚିନ୍‌କ ଆଡଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ, ଆଇନ୍‌ ଇତୁକ ହୁଣ୍ଡିୟାନା ଆଡଃ ୟୀଶୁକେ ଆକଆଃ ପାଞ୍ଚେଟ୍‌ତେ ଇଦିକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“ଆମ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ତାନ୍‌ମେରେଦ ମାର୍‌ କାଜିୟାଲେମ୍‌” ମେନ୍ତେ କାଜିକିୟାକ, ୟୀଶୁ ମେନ୍‌ରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେରେହ ଆପେ କାପେ ବିଶ୍ୱାସେୟା, ");
INSERT INTO unx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ଆଡଃ ଆଇଙ୍ଗ୍‌ ଜେତ୍‌ନାଃଇଙ୍ଗ୍‌ କୁଲିପେରେୟ ଆପେ କାପେ କାଜିରୁହାଡ଼ାଇୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ମେନ୍‌ଦ ନାହାଁଃଏତେ ମାନୱାହନ୍‌ ସବେନ୍‌ ପେଡ଼େୟାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଜମ୍‌ତିସାଃରେ ଦୁବାକାନ୍‌ ନେଲଃଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ଆଡଃ ସବେନ୍‌କ କୁଲିକିୟାଃକ, “ତାବ୍‌ଦ, ଚିୟାଃ ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେ ?” ଇନିଃ ମେତାଦ୍‌କଆଏ, “ଆମ୍‌ ଇନିଃଗି ତାନ୍‌ମେ ମେନ୍ତେ ଆପେଗିପେ କାଜିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ଏନ୍ତେ ଇନ୍‌କୁ ମେନ୍‌କେଦାଃ, “ନାହାଁଃଦ ଆବୁଆଃ ଆଡଃ ଚିକାନ୍‌ ଗାୱା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ? ଆବୁଦ ଇନିୟାଃ ମଚାଏତେଗି ଆୟୁମ୍‌କେଦାଃବୁ ।” ");
INSERT INTO unx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ସବେନ୍‌ ପାଞ୍ଚେଟ୍‌ରେନ୍‌କ ବିରିଦ୍‌ୟାନ୍ତେ ୟୀଶୁକେ ପିଲାତୁସ୍‌ତାଃତେକ ଇଦିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ଚିଟାଇତାନ୍‌ଲଃ କାଜିକେଦାକ, “ନେ ହଡ଼, କାଇସାର୍‌କେ କାର୍‌ ଆଲପେ ଏମାଇ ମେନ୍ତେ ହଡ଼କକେ ଉସ୍‌କୁର୍‌କ ତାନ୍‌ ଆଡଃ ଆପାନ୍‌କେ ଖ୍ରୀଷ୍ଟ୍‌, ରାଜା ମେନ୍ତେ କାଜିନ୍‌ତାନ୍‌ଲେ ଆୟୁମ୍‌କାଇଜା ।” ");
INSERT INTO unx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ଏନ୍ତେ ପିଲାତୁସ୍‌ ୟୀଶୁକେ କୁଲିକିୟାଏ, “ଆମ୍‌ ଚିନାଃ ଯିହୁଦୀକଆଃ ରାଜାତାନ୍‌ମେଁ ?” ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ “ଆମ୍‌ଗିମ୍‌ କାଜିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ଏନ୍ତେ ପିଲାତୁସ୍‌ ମୁଲ୍‌ ଯାଜାକ୍‌କକେ ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କକେ କାଜିୟାଦ୍‌କଆଏ, “ନେ ହଡ଼ରେ ଜେତାନ୍ ଗୁହ୍ନାଁ କାଇଙ୍ଗ୍‌ ନାମେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ମେନ୍‌ଦ ଇନ୍‌କୁ ଆଡଃପୁରାଃଗି କାଜିକେଦାଃକ, “ଇନିଃ ଗାଲିଲ୍‌ଏତେ ନେତାଃ ଜାକେଦ୍‌ ଗଟା ଯିହୁଦାରେନ୍‌କକେ ଇତୁକତାନ୍‌ଲଃ ଉସ୍‌କୁର୍‌କତାନା ।” ");
INSERT INTO unx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ପିଲାତୁସ୍‌ ଗାଲିଲ୍‌ ନୁତୁମ୍‌ ଆୟୁମ୍‌କେଦ୍‌ଚି କୁଲିକେଦ୍‌କଆଏ, “ଚିୟାଃ ନେ ହଡ଼ ଗାଲିଲ୍‌ରେନ୍‌ ତାନିଃଚି ?” ");
INSERT INTO unx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ୟୀଶୁ ହେରୋଦ୍‌ଆଃ ରାଇଜ୍‌ରେନ୍‌ ତାନିଃ ନେଆଁଁ ଆଟ୍‌କାର୍‌କେଦ୍‌ଚି ପିଲାତୁସ୍‌ ଇନିଃକେ ହେରୋଦ୍‌ତାଃତେ କୁଲ୍‌କିୟାଏ । ଇନିଃଦ ଏନ୍‌ହୁଲାଙ୍ଗ୍‌ରେ ଯୀରୁଶାଲେମ୍‌ରେ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ଆଡଃ ହେରୋଦ୍‌ ୟୀଶୁକେ ନେଲ୍‌କିଃତେ ପୁରାଃଗି ରାସ୍‌କାୟାନାଏ, ଇନିଃଦ ୟୀଶୁଆଃ କାଜିକାମି ବିଷାଏରେ ଆୟୁମାକାଦ୍‌ ତାଇକେନାଏ, ଏନାନାଗେନ୍ତେ ଇନିଃ ୟୀଶୁକେ ନେନେଲ୍‌ ସାନାଙ୍ଗ୍‌ତାନାଏ ତାଇକେନା, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନିୟାଃ ଜେତାନ୍‌ ମାରାଙ୍ଗ୍‌ ପେଡ଼େୟାନ୍‌ କାମି ନେଲେଆଇଙ୍ଗ୍‌ ମେନ୍ତେ ଆସ୍ରାଏତାନା ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ଏନାନାଗେନ୍ତେ ହେରୋଦ୍‌ ଇନିଃକେ ପୁରାଃ କାଜିକ କୁଲିକିୟାଏ, ମେନ୍‌ଦ ୟୀଶୁ ଜେତ୍‌ନାଃ କାଏ କାଜିରୁହାଡ଼୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ତିଙ୍ଗୁୟାନ୍ତେ ପୁରାଃଗି ଇନିଃକେ ଚିଟାକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ଏନ୍ତେ ହେରୋଦ୍‌ ଆଡଃ ଆୟାଃ ସିପାଇକଲଃ ଇନିଃକେ ହିନିସ୍ତାକିଃତେ ଲାନ୍ଦାକିୟାଃକ ଆଡଃ ରାଙ୍ଗ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌କିଃତେ ପିଲାତୁସ୍‌ତାଃତେକ କୁଲ୍‌ରୁହାଡ଼୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ଗି ପିଲାତୁସ୍‌ ଆଡଃ ହେରୋଦ୍‌ ବାରାନ୍‌କିନ୍‌ ଗାତିୟାନାକିନ୍‌, ସିଦାଦ ଇନ୍‌କିନ୍‌ ବାଇରିକିନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ପିଲାତୁସ୍‌, ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କକେ, ହାକିମ୍‌କକେ ଆଡଃ ହଡ଼କକେ କେଡ଼ାହୁଣ୍ଡିକେଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ଆଡଃ କାଜିୟାଦ୍‌କଆଏ, “ନିଃ ହଡ଼କକେ ବାଗ୍‌ଡ଼ାଅନିଃ ତାନିଃ ମେନ୍ତେ ଆପେ ଆଇଁୟାଃତାଃପେ ଆଉକିୟା । ଆଡଃ ନେଲେପେ ଆପେୟାଃ ଆୟାର୍‌ରେଗି କୁଲିକିୟାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଆପେ ଚିଟାଇତାନ୍‌ ଜେତାନ୍‌ ଗୁହ୍ନାଁ ନିଃରେ କାଇଙ୍ଗ୍‌ ନାମ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ଆଡଃ ହେରୋଦ୍‌ହ କାଏ ନାମାକାଦାଃ, ଏନାତେ ଇନିଃ ନିଃକେ ଆବୁତାଃତେ କୁଲ୍‌ରୁହାଡ଼୍‌କିୟାଃ, ନେଲେପେ ଗଜିଲେକାନ୍‌ ଜେତାନ୍‌କାମି ନିଃ କାଏ କାମିୟାକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ହାଁଣ୍‌ସାକିଃତେ ଆଡ଼ାଃଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ଏନ୍‌ ପାରାବ୍‌ରେ ହଡ଼କ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ହଡ଼କେ ଆଡ଼ାଃଇ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ଆଡଃ ସବେନ୍‌କ ମିଦ୍‌ୟାନ୍ତେ କାଉରିକେଦାଃକ, “ନେ ହଡ଼କେ ଗଜିମେଁ ଆଡଃ ବାରବ୍‌ବାକେ ଆଲେ ନାଗେନ୍ତେ ଆଡ଼ାଃଇମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ହାତୁରେ ହବାଲେନ୍‌ ହାଲାଗୁଲା ଆଡଃ ହଡ଼ ଗଏଃକେନ୍‌ ନାଗେନ୍ତେ ବାରବ୍‌ବା ଜେହେଲାକାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ପିଲାତୁସ୍‌ ୟୀଶୁକେ ଆଡ଼ାଃଇ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌କିୟା ଏନାମେନ୍ତେ ଆଡଃଗି ହଡ଼କକେ କାଜିୟାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ମେନ୍‌ଦ ଇନ୍‌କୁ କାଉରିକେଦାଃକ, “କ୍ରୁଶ୍‌ରେ କିଲାଇମେ, କ୍ରୁଶ୍‌ରେ କିଲାଇମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ଏନ୍ତେ ପିଲାତ୍ ଆପିସାତେ କାଜିୟାଦ୍‌କଆଏ, “ଚିକା ନାଗେନ୍ତେ, ନେ ହଡ଼ ଚିକାନ୍‌ ଏତ୍‌କାନ୍‌ କାମିୟାକାଦାଏ ? ଆଇଙ୍ଗ୍‌ ଗଜିଲେକାନ୍‌ ଜେତାନ୍‌ ଗୁହ୍ନାଁ ଇନିଃରେ କାଇଙ୍ଗ୍‌ ନାମାକାଦା, ଏନାମେନ୍ତେ ଇନିଃକେ ହାଁଣ୍‌ସାକିଃତେଇଙ୍ଗ୍‌ ବାଗିୟା ।” ");
INSERT INTO unx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ମେନ୍‌ଦ ଇନ୍‌କୁ ପୁରାଃଗି କାଉରିତାନ୍‌ଲଃ ୟୀଶୁକେ କ୍ରୁଶ୍‌ରେ ରାକାବିମେଁ ମେନ୍ତେ ଆସିତାନ୍‌କ ତାଇକେନା, ଆଡଃ ଇନ୍‌କୁଆଃ କାଉରିରେୟାଃ ଜିନିତାଅ ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ଏନ୍ତେ ପିଲାତୁସ୍‌, ଇନ୍‌କୁ ଆସିତାନ୍‌ ଲେକା ରିକାଏପେ ମେନ୍ତେ ଆଚୁକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ଇନିଃ ଇନ୍‌କୁ ଆସିତାନ୍‌ ହଡ଼କେ, ଅକଏଚି ହାଲାଗୁଲା ଆଡଃ ହଡ଼ ଗଏଃକେନ୍‌ନାଙ୍ଗ୍‌ ଜେହେଲାକାନ୍‌ ତାଇକେନାଏ ଇନିଃକେ ଇନ୍‌କୁ ନାଗେନ୍ତେ ଆଡ଼ାଃକିୟା, ମେନ୍‌ଦ ୟୀଶୁକେ ଇନ୍‌କୁଆଃ ସାନାଙ୍ଗ୍‌ ଲେକା ଜିମାକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ଇଦିତାନ୍‌ ତାଇକେନ୍‌ରେ ହାତୁଏତେ ହିଜୁଃତାନ୍‌ ଶିମୋନ୍‌ ନୁତୁମ୍‌ କୁରିନିରେନ୍‌ ହଡ଼କେ ସାବ୍‌କିୟାଃକ ଆଡଃ ୟୀଶୁଆଃ ତାୟମ୍‌ ତାୟମ୍‌ତେ କ୍ରୁଶ୍‌ ଇଦି ନାଗେନ୍ତେ ଇନିଃକେ ଗଅଃଚିକାକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ପୁରାଃ ହଡ଼କ ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟାକ ଇନ୍‌କୁ ଥାଲାରେ ଇନିଃ ନାଙ୍ଗ୍‌ କୁଡ଼ାମ୍ ଥାପ୍‌ଡ଼ି ଆଡଃ ରାଆଃତାନ୍‌ କୁଡ଼ିକହ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁସାଃ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ହେ ଯୀରୁଶାଲେମ୍‌ରେନ୍‌ କୁଡ଼ିହନ୍‌କ, ଆଇଁୟାଃ ନାଙ୍ଗ୍‌ ଆଲ୍‌ପେ ରାଆଃୟା, ମେନ୍‌ଦ ଆପେୟାଃ ଆଡଃ ଆପେୟାଃ ହନ୍‌କ ନାଙ୍ଗ୍‌ ରାଆଃଏପେ । ");
INSERT INTO unx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ନେଲେପେ ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ହିଜୁଃଆ ଏନାରେ ହଡ଼କ ମେନେଆଁଁ, ‘କା ହାମ୍ବାଲଃ ଦାଡ଼ିତାନ୍‌ କୁଡ଼ି ଆଡଃ ଚିଉଲାହ କା ହାମ୍ବାଲାକାନ୍‌ ଲାହିଦ୍‌ ଆଡଃ ଚିଉଲାହ ତଆ କା ନୁନୁଆକ ସୁକୁତାନ୍‌ଗିଆଃ ।’ ");
INSERT INTO unx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ଏନ୍ତେ ଇନ୍‌କୁ କାଜିୟା, ‘ଏ ବୁରୁକ ଆଲେରେ ଉୟୁଗଃପେ ଆଡଃ ଏ ଟୁଙ୍ଗୁରିକ ଆଲେକେ ଦାନାଙ୍ଗ୍‌ଲେପେ ।’ ");
INSERT INTO unx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ଇନ୍‌କୁ ହାରିୟାର୍‌ ଦାରୁକେ ନେ'ଲେକାଇରେଦ ରହଡ଼ାକାନ୍‌ ଦାରୁରାଃ ଚିନାଃ ହବାଅଆଃ ?” ");
INSERT INTO unx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ଇନ୍‌କୁ ଇନିଃଲଃ ଗଏଃନାଗେନ୍ତେ ଏତ୍‌କାନାଃ କାମିକେନ୍‌ ଆଡଃଗି ବାର୍‌ହଡ଼୍‌କିନ୍‌କେ ହ ଇଦିକେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ଇନ୍‌କୁ “ବହଃଜାଙ୍ଗ୍‌” ନୁତୁମଃତାନ୍‌ ଠାୟାଦ୍‌ତେ ସେଟେର୍‌ୟାନ୍‌ଚି ଏନ୍ତାଃରେ ଇନିଃକେ ଆଡଃ ଏନ୍‌ ଏତ୍‌କାନ୍‌ କାମିକେନ୍‌କିନ୍‌ଏତେ ମିଆଁଦ୍‌କେ ଇନିୟାଃ ଜମ୍‌ସାଃ ଆଡଃ ଏଟାଃନିଃକେ ଲେଙ୍ଗାସାଃରେ କ୍ରୁଶ୍‌ରେକ କିଲାକେଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ଏନ୍ତେ ୟୀଶୁ ମେନ୍‌କେଦାଏ, “ହେ ଆବା ଇନ୍‌କୁକେ ଛାମାକମେଁ, ଚିୟାଃଚି ଇନ୍‌କୁ ଚିନାଃ କାମିତାନାକ ଏନା କାକ ସାରିତାନା ।” ଆଡଃ ଚିଠା ଉୟୁଃକେଦ୍‌ତେ ଇନିୟାଃ ଲିଜାଃକେ ହାଟିଙ୍ଗ୍‌କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ହଡ଼କ ତିଙ୍ଗୁୟାନ୍ତେ ନେଲ୍‌ତାନ୍‌କ ତାଇକେନା, ଆଡଃ ହାକିମ୍‌କହ ଇନିଃକେ ଲାନ୍ଦାକିଃତେ ମେନ୍‌କେଦାଃକ, “ଇନିଃଦ ଏଟାଃକକେ ବାଞ୍ଚାଅକେଦ୍‌କଆଏ, ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାଲାକାନ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ତାଇନିଃରେଦ ଆପାନ୍‌କେ ବାଞ୍ଚାଅନ୍‌କା ।” ");
INSERT INTO unx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ସିପାଇକହ ହିଜୁଃଲେନ୍ତେ ଇନିଃକେ ଲାନ୍ଦାକିୟାଃକ ଆଡଃ ମେହେର୍‌ ରାସିକ ଆନୁକିୟାଃ, ");
INSERT INTO unx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ଆଡଃ କାଜିକିୟାକ, “ଆମ୍‌ ଯିହୁଦୀକଆଃ ରାଜା ତାନ୍‌ମେରେଦ ଆପାନ୍‌କେ ବାଞ୍ଚାଅଏନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ଆଡଃ “ନିଃ ଯିହୁଦୀକଆଃ ରାଜାତାନିଃ” ମେନ୍ତେ ମିଆଁଦ୍‌ ଅନଲ୍‌ ଇନିୟାଃ ଚେତାନ୍‌ରେ ଅଲାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ଏନ୍ତେ ହାକାକାନ୍‌ ଏତ୍‌କାନ୍‌ କାମିକିନ୍‌ଏତେ ମିଆଁଦ୍‌ନିଃ ୟୀଶୁକେ ହିଲାଙ୍ଗ୍‌କିଃତେ କାଜିକିୟାଏ, “ଆମ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ତାନ୍‌ମେରେଦ, ଆପାନ୍‌କେ ଆଡଃ ଆଲିଙ୍ଗ୍‌କେ ବାଞ୍ଚାଅଲିଙ୍ଗ୍‌ମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ମେନ୍‌ଦ ଏଟାଃନିଃ ଇନିଃକେ ମାରାଙ୍ଗ୍‌ମଚାକିଦ୍‌ତେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆମ୍‌ହଦ ନେ ଲେକା ସାଜାଇ ନାମେତାନାମ୍, ପାର୍‌ମେଶ୍ୱାର୍‌କେ କାଚିମ୍‌ ବରଇତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ଆଲାଙ୍ଗ୍‌ଦ ଲାଗାତିଙ୍ଗ୍‌ଲେକା ସାଜାଇଅଃତାନାଲାଙ୍ଗ୍‌, ଆଲାଙ୍ଗ୍‌ କାମିକାଦ୍‌ରେୟାଃ ନାଲାଲାଙ୍ଗ୍‌ ନାମେତାନା, ମେନ୍‌ଦ ନିଃ ଜେତାନ୍‌ ଏତ୍‌କାନାଃ କାଏ କାମିୟାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ଏନ୍ତେ ଇନିଃ କାଜିକିୟାଏ, “ହେ ୟୀଶୁ ଆମାଃ ରାଇଜ୍‌ରେମ୍‌ ତେବାଃଇମ୍‌ତା ଆଇଙ୍ଗ୍‌କେ ପାହାମିଙ୍ଗ୍‌ମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ସାର୍‌ତିଗି କାଜିୟାମ୍‌ ତାନାଇଙ୍ଗ୍‌, ତିସିଙ୍ଗ୍‌ ଆମ୍‌ ଆଇଁୟାଃଲଃ ପାରାଦେସ୍‌ରେମ୍‌ ତାଇନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ଇମ୍‌ତା ତିକିନ୍‌ସିଙ୍ଗି ହବାକାନ୍‌ ତାଇକେନା, ଆଡଃ ତାର୍‌ସିଙ୍ଗ୍‌ ତିନ୍‌ଘାଣ୍ଟା ଜାକେଦ୍‌ ଗଟା ଦିଶୁମ୍‌ ନୁବାଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ସିଙ୍ଗି ହ ନୁବାଃୟାନାଏ, ଆଡଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଃ ହାନାଟିଙ୍ଗ୍‌ ଦାନାଙ୍ଗ୍‌ଲିଜାଃ ଥାଲା ଥାଲାତେ ଚେଚାଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ୟୀଶୁ ପୁରାଃ କାଉରିକେଦ୍‌ତେ ମେନ୍‌କେଦାଏ, “ହେ ଆବା, ଆଇଁୟାଃ ଆତ୍ମା ଆମାଃତିଃଇରେଇଙ୍ଗ୍‌ ଜିମାଏତାନା ।” ନେଆଁଁ କାଜିକେଦ୍‌ତେ ଜୀଉତାୟାଃ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ଏନ୍ତେ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଗମ୍‌କେ ନେଆଁଁ ନେଲ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାନାରାଙ୍ଗ୍‌କେଦ୍‌ତେ କାଜିକେଦାଏ, “ସାର୍‌ତିଗି ନିଃ ଧାର୍‌ମାନ୍‌ ହଡ଼ ତାଇକେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ଆଡଃ ନେଆଁଁ ନେନେଲ୍‌ନାଗେନ୍ତେ ହୁଣ୍ଡିୟାକାନ୍‌ ସବେନ୍‌ ହଡ଼କ ହବାୟାନ୍‌ତେୟାଃ ନେଲ୍‌କେଦ୍‌ତେ, ଦୁକୁତେ ଆକଆଃ କୁଡ଼ାମ୍ ଥାପ୍‌ଡ଼ିତାନ୍‌ଲଃ ରୁହାଡ଼୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ମେନ୍‌ଦ ୟୀଶୁଆଃ ସବେନ୍‌ ନେପେଲ୍‌ଉପ୍‌ରୁଙ୍ଗ୍‌କ ଆଡଃ ଗାଲିଲ୍‌ଏତେ ଅତଙ୍ଗ୍‌ଆଉକାଇ କୁଡ଼ିକ ସାଙ୍ଗିନ୍‌ରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ନେଆଁଁ ନେଲ୍‌ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ନେଲେପେ ଯିହୁଦୀକଆଃ ହାରାମାଥିୟା ସାହାର୍‌ରେ ଯୋଷେଫ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼, ଇନିଃ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ମିହୁଡ଼୍‌ ବୁଗିନ୍‌ ଆଡଃ ଧାର୍‌ମାନ୍‌ ହଡ଼ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ଯିହୁଦୀକଆଃ ନାଗାର୍‌ରେନ୍‌ ହାରାମାଥିୟା ଇନ୍‌କୁଆଃ ଉଡ଼ୁଃ ଆଡଃ କାମିରେ କାଏ ମେସାକାନ୍‌ ତାଇକେନା । ଆଡଃ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ନେଲ୍‌ହରାତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ଇନିଃ ପିଲାତୁସ୍‌ତାଃ ସେନଃୟାନ୍ତେ ୟୀଶୁଆଃ ଗଏଃ ହଡ଼୍‌ମକେ ଆସିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ଏନ୍ତେ ଇନିଃ ଏନାକେ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ, ଫାର୍‌ଚି ନିରାଲ୍‌ ଲିଜାଃଲଃ ପଟମ୍‌କେଦାଏ ଆଡଃ ଦିରିଏତେ ଉର୍‌ଲେଦ୍‌ ତପାଗାଡ଼ାରେ ଦହକେଦାଏ, ଏନାରେଦ ଚିଉଲାହ ଜେତାଏକେ କାକ ତପାକାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ଦ ସାପ୍‌ଡ଼ାଅନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତାଇକେନା, ଆଡଃ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ନାଡ଼େୟାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ଗାଲିଲ୍‌ଏତେ ୟୀଶୁଲଃ ହିଜୁଆକାନ୍‌ କୁଡ଼ିକହ ଅତଙ୍ଗ୍‌କିୟାକ, ତପାଠାୟାଦ୍‌ ଆଡଃ ଇନିୟାଃ ହଡ଼୍‌ମ ଚିଲ୍‌କାତେ ଦହାକାନା ଏନାକ ନେଲ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ଏନ୍ତେ ଇନ୍‌କୁ ରୁହାଡ଼୍‌ୟାନ୍ତେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌କ ବାଇକେଦା । ଆଡଃ ଆନ୍‌ଚୁଲେକା ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେକ ରୁଡ଼ୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ହାପ୍ତାରେୟାଃ ପାହିଲା ହୁଲାଙ୍ଗ୍‌ ସେତାଃ ଇଦାନ୍ ନୁବାଃ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଏନ୍‌ କୁଡ଼ିକ ଆକଆଃ ବାଇୟାକାଦ୍‌ ବୁଗିନ୍‌ ସହାନ୍‌ତେୟାଃ ଆଉକେଦ୍‌ତେ ତପାଗାଡ଼ା ଠାୟାଦ୍‌ତାଃକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ଆଡଃ ଇନ୍‌କୁ ତପାଠାୟାଦ୍‌ରାଃ ଦୁଆର୍‌ଏତେ ପୁରାଃ ମାରାଙ୍ଗ୍‌ ଦିରିକେ ବାଟି ଆତମାକାନ୍‌କ ନେଲ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ମେନ୍‌ଦ ଇନ୍‌କୁ ବଲୟାନ୍ତେ ପ୍ରାଭୁ ୟୀଶୁଆଃ ହଡ଼୍‌ମ କାକ ନାମ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ଆଡଃ ଇନ୍‌କୁ ନେଆଁଁତେ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ, ନେଲେପେ ଝାକ୍‌ମାକ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍‌ ବାର୍‌ହଡ଼୍‌ ଇନ୍‌କୁଆଃ ଜାପାଃରେକିନ୍‌ ତିଙ୍ଗୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ଇନ୍‌କୁ ବରତେ ଅତେସାଃ ତିରୁବାକାଦ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଇନ୍‌କିନ୍‌ କାଜିୟାଦ୍‌କଆକିନ୍‌, “‘ଆପେ ଜୀଉଦ୍‌ତାନ୍‌କକେ ଗଜାକାନ୍‌କଆଃ ଥାଲାରେ ଚିନାଃମେନ୍ତେପେ ଦାଣାଁଁଇତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ଇନିଃ ନେତାଃରେ ବାଙ୍ଗାଇୟା, ଇନିଃଦ ଜୀଉବିରିଦାକାନାଏ ! ଗାଲିଲ୍‌ରେ ତାଇକାନ୍‌ ଇମ୍‌ତା ଇନିଃ ଚିକ୍‌ନାଃ ମେତାକାପେ ତାଇନାଏ, ଏନା ପାହାମେପେ । ");
INSERT INTO unx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ମାନୱାହନ୍‌ ପାପିକଆଃ ତିଃଇରେ ସାବ୍ଇଚିୟଃଆଏ, ଆଡଃ କ୍ରୁଶ୍‌ରେ ଗଜଃଆଏ ଆଡଃ ଆପି ମାହାଁରେ ଜୀଉବିରିଦ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।’” ");
INSERT INTO unx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିୟାଃ କାଜିକ ପାହାମ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ତପାଗାଡ଼ାଏତେ ରୁହାଡ଼୍‌କେଦ୍‌ତେ, ଇନ୍‌କୁ ନେ ସବେନ୍‌କାଜି ଏଗାରାଝାନ୍‌ ଚେଲାକକେ ଆଡଃ ସବେନ୍‌ ଏଟାଃ ହଡ଼କକେ ଉଦୁବାଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌, ଯୋହାନ୍ନା, ଯାକୁବ୍‌ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌, ଆଡଃ ଏଟାଃକ ନେ କାଜି ପ୍ରେରିତ୍‌କକେ ଉଦୁବାଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନ୍‌କୁଆଃ କାଜିକେ କାକ ବିଶ୍ୱାସ୍‌କେଦାଃ, ଚିୟାଃଚି ଇନ୍‌କୁଆଃ କାଜି ଆକକେ ସାମାକାଜିଲେକା ଆଟ୍‌କାର୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ପାତ୍‌ରାସ୍‌, ବିରିଦ୍‌ୟାନ୍ତେ ତପାଗାଡ଼ାତେ ନିର୍‌କେଦାଏ, ଆଡଃ ଇନିଃ ଉଙ୍ଗୁଦ୍‌କେଦ୍‍ତେ ପାତ୍‌ଲା ଲିଜାଃ ଏସ୍‌କାର୍‌ ଦହାକାନ୍‌ତେୟାଃ ନେଲ୍‌କେଦାଏ, ଆଡଃ ହବାକାନ୍‌ତେୟାଃ ନେଲ୍‌କେଦ୍‌ତେ ଆୟାଃ ମନ୍‌ରେ ଆକ୍‌ଦାନ୍ଦାଅ ତାନ୍‌ଲଃ ଅଡ଼ାଃତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ନେଲେପେ ଏନ୍‌ହୁଲାଙ୍ଗ୍‌ଗି ଇନ୍‌କୁଏତେ ବାର୍‌ହଡ଼୍‌ ଇମ୍ମାୟୁସ୍‌ ନୁତୁମ୍‌ ହାତୁତେ ସେନଃତାନ୍‌କିନ୍‌ ତାଇକେନା, ଏନ୍‌ ହାତୁ ଯୀରୁଶାଲେମ୍‌ଏତେ ସାତ୍‌ମାଇଲ୍‌ ଲେକା ସାଙ୍ଗିନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ଇନ୍‌କିନ୍‌ ନେ ହବାକାନ୍‌ ସବେନ୍‌ କାଜିକ ବାଖାଁଣେତାନ୍‌କିନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ଚିମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କିନ୍‌ ବାଖାଁଣ୍‌ତାନ୍‌ ଆଡଃ କୁପୁଲିତାନ୍‌ଲଃ ସେନଃତାଇକେନାକିନ୍‌ ୟୀଶୁ ଆଇଃକ୍‌ହଗି ନାଡ଼େଃୟାନ୍ତେ ଇନ୍‌କିନ୍‌ଲଃ ଗାତିୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ମେନ୍‌ଦ ଇନ୍‌କିନାଃ ମେଦ୍‌ ଦାନାଙ୍ଗ୍‌କାନ୍‌ତାଇକେନା, ଏନାନାଗେନ୍ତେ ଇନ୍‌କିନ୍‌ ଇନିଃକେ କାକିନ୍‌ ନେଲ୍‌ଉରୁମ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ଇନିଃ ଇନ୍‌କିନ୍‌କେ କୁଲିକେଦ୍‌କିନାଏ, “ଆବେନ୍‌ ସେନଃତାନ୍‌ଲଃ ଚିକାନ୍‌ କାଜିବେନ୍‌ କୁପୁଲିତାନା ଆଡଃ ହୁଡିଙ୍ଗ୍‌ଜୀଉକାନା ? ");
INSERT INTO unx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ଏନ୍ତେ ଇନ୍‌କିନ୍‌ଏତେ କ୍ଲେୟପା ନୁତୁମ୍‌ନିଃ, କାଜିରୁହାଡ଼୍‌କିୟାଏ, ଆମ୍‌ ଚିନାଃ ଯୀରୁଶାଲେମ୍‌ରେ ଡେରାଏତାନ୍‌ରେହ ତିସିଙ୍ଗ୍‌ ନେ ହବାକାନ୍‌ କାଜିକ ଆମ୍‌ ଏସ୍‌କାର୍‌ଗି କାମ୍‌ ସାରିୟାଃ ?” ");
INSERT INTO unx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ୟୀଶୁ କୁଲିକେଦ୍‌କିନାଏ, “ଚିଲ୍‌କାନ୍‌ କାଜି ?” “ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁଆଃ ବିଷାଏ,” ମେନ୍ତେକିନ୍‌କାଜିକିୟାଃ । “ଇନିଃ ନାବୀ ତାଇକେନାଏ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଡଃ ହଡ଼କଆଃ ଆୟାର୍‌ରେ କାମି ଆଡଃ କାଜିରେ ପେଡ଼େୟାନ୍‌ ହଡ଼ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ଆଲେୟାଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ହାକିମ୍‌କ ଇନିଃକେ ଗନଏଃ ସାଜାଇ ଏମ୍‌ ନାଗେନ୍ତେକ ଏମ୍‌ଏଣ୍ଡାଃକିୟାଃ ଆଡଃ କ୍ରୁଶ୍‌ରେକ କିଲାଗଏଃକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ମେନ୍‌ଦ ଆଲେ ଇନିଃ ଇସ୍ରାଏଲ୍‌ରେନ୍‌କକେ ମୁକ୍ତି ଏମାକଆ ମେନ୍ତେ ଆସ୍ରାଏତାନ୍‌ଲେ ତାଇକେନା । ନେ ସବେନାଃ ହବାକାନ୍‌ତେୟାଃ ତିସିଙ୍ଗ୍‌ଲଃ ଆପି ମାହାଁ ହବାଅଃତାନା । ");
INSERT INTO unx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ଆଡଃଗି ଆଲେୟାଃ ଗାତିରେନ୍‌ ଚିମିନାଙ୍ଗ୍‌ କୁଡ଼ିକ, ଆକ୍‌ଚାକାଅ କାଦ୍‌ଲେୟାକ, ଇନ୍‌କୁ ଇଦାନ୍‌ରେ ତପାଗାଡ଼ାତାଃକ ସେନ୍‌କେନା, ");
INSERT INTO unx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନିୟାଃ ଗଏଃହଡ଼୍‌ମ କାକ ନାମ୍‌କେଦାଃ । ଇନ୍‌କୁ ରୁହାଡ଼୍‌କେଦ୍‌ତେ କାଜିୟାଦ୍‌ଲେୟାକ, ଆଲେ ଦୁଁତ୍‌କେ ନେଲାଦ୍‌କିନାଲେ, ଇନ୍‌କିନ୍‌ ୟୀଶୁ ଜୀହୁଦ୍‌ଗିୟାଏ ମେତାଦ୍‌ଲେୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ଏନ୍ତେ ଆଲେୟାଃ ଗାତିକଏତେ ଚିମ୍‌ନାଙ୍ଗ୍‌କ ତପାଗାଡ଼ାତାଃକ ସେନଃୟାନା ଆଡଃ କୁଡ଼ିକଆଃ କାଜିଲେକାକ ନାମ୍‌କେଦାଃ, ମେନ୍‌ଦ ୟୀଶୁକେ କାକ ନେଲ୍‌କିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ୟୀଶୁ ମେତାଦ୍‌କିନାଏ, “ଏ ଡଣ୍ଡକିନ୍‌ ଆଡଃ ନାବୀକଆଃ ସବେନ୍‌ କାଜି ବିଶ୍ୱାସ୍‌ନାଙ୍ଗ୍‌ ମନ୍‌କେଟେୟାକାନ୍‌ ହଡ଼କିନ୍‌ ! ");
INSERT INTO unx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ଚିୟାଃ ଖ୍ରୀଷ୍ଟ୍‌ ନେ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ ଆଡଃ ଆୟାଃ ମାନାରାଙ୍ଗ୍‌ରେ ବଲ କା ଲାଗାତିଙ୍ଗ୍‌ତାନ୍‌ ତାଇକେନା ?” ");
INSERT INTO unx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ମୁଶା ଆଡଃ ସବେନ୍‌ ନାବୀକଏତେ ଏଟେଦ୍‌କେଦ୍‌ତେ ଗଟା ଧାରାମ୍‌ପୁଥିରେ ଆୟାଃ ବିଷାଏରେ ଅଲାକାନ୍‌ କାଜିକରେୟାଃ ମୁଣ୍ଡି ଉଦୁବାଦ୍‌କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଏନ୍ତେ ଇନ୍‌କୁ ଆକସେନଃତାନ୍‌ ତାଇକେନ୍‌ ହାତୁତେ ସେଟେର୍‌ୟାନ୍‌ଚି ୟୀଶୁ ଆୟାର୍‌ତେ ସେନଃତାନ୍‌ ଲେକାଏ ଉଦୁବେନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ମେନ୍‌ଦ ଇନ୍‌କିନ୍‌ “ଦେଲା ଆଲିଙ୍ଗ୍‌ଲଃ ତାଇନଃମେଁ, ଆୟୁବଃତାନା ଆଡଃ ସିଙ୍ଗିହାସୁରଃତାନା” ମେନ୍ତେ କାଜିକିୟାଃକିନ୍‌, ଆଡଃ ଇନିଃ ଇନ୍‌କିନ୍‌ଲଃ ତାଇନଃ ନାଗେନ୍ତେ ବଲୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ଇନିଃ ଇନ୍‌କିନ୍‌ଲଃ ଜମ୍‌ଦୁବ୍‌ୟାନ୍‌ଚି ହଲଙ୍ଗ୍‌କେ ସାବ୍‌କେଦ୍‌ତେ, ଆଶିଷ୍‌ ଏମ୍‌କେଦାଏ, ଆଡଃ ଏନା କେଚାଃକେଦ୍‌ତେ ଏମାଦ୍‌କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ଏନ୍ତେ ଇନ୍‌କିନାଃ ମେଦ୍‌ ରାଡ଼ାୟାନା ଆଡଃ ଇନ୍‌କିନ୍‌ ୟୀଶୁକେ ନେଲ୍‌ଉରୁମ୍‌କିୟାକିନ୍, ଆଡଃ ଇନିଃ ଇନ୍‌କିନ୍‌ତାଃଏତେ ଦାନାଙ୍ଗ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ଆଡଃ ଇନ୍‌କିନ୍‌ ଆକିନ୍‌ଆକିନ୍‌ରେ କୁଲିୟାନାକିନ୍‌, “ଚିୟାଃ ଇନିଃ ହରାରେ ଆଲାଙ୍ଗ୍‌ଲଃ ବାଖାଁଣ୍‌ତାନ୍‌ ଆଡଃ ଧାରାମ୍‌ପୁଥିରେୟାଃ ମୁଣ୍ଡି ଉଦୁବାଲାଙ୍ଗ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଆଲାଙ୍ଗ୍‌ଆଃ ମନ୍‌ ରାସ୍‌କାତେ କା'ଚି ଜୁଲଃତାନ୍‌ ତାଇକେନା ?” ");
INSERT INTO unx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ଆଡଃ ଇମ୍‌ତାଗି ଇନ୍‌କିନ୍‌ ବିରିଦ୍‌ୟାନ୍ତେ ଯୀରୁଶାଲେମ୍‌ତେକିନ୍‌ ରୁହାଡ଼୍‌ୟାନା ଆଡଃ ଏଗାରାଝାନ୍‌ ଚେଲାକ ଆଡଃ ଇନ୍‌କୁଆଃ ଗାତିକ ହୁଣ୍ଡିୟାକାନ୍‌କିନ୍‌ ନାମ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“ସାର୍‌ତିଗି ପ୍ରାଭୁ ଜୀଉବିରିଦାକାନାଏ ଆଡଃ ଶିମୋନ୍‌ତାଃ ନେଲ୍‌ଇଚିୟାନାଏ” ମେନ୍ତେ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ହରାରେ ହବାଲେନ୍‌ତେୟାଃ ଆଡଃ ଚିଲ୍‌କାତେ ହଲଙ୍ଗ୍‌ କେଚାଃତାନ୍‌ରେ ଆଲିଙ୍ଗ୍‌ ଇନିଃକେ ନେଲ୍‌ଉରୁମ୍‌କିୟାଃ ଏନା ଇନ୍‌କୁକେ ଉଦୁବାଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ଇନ୍‌କିନ୍‌ ନେ କାଜି କାଜିତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ପ୍ରାଭୁ ୟୀଶୁ ଆଇଃକ୍‌ଗି ଇନ୍‌କୁଆଃ ଥାଲାରେ ତିଙ୍ଗୁୟାନାଏ, ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଆପେରେ ଜୀଉସୁକୁ ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ମେନ୍‌ଦ ଇନ୍‌କୁ ଆକ୍‌ଦାନ୍ଦାଅୟାନ୍‌ଲଃ, ବରକେଦ୍‌ତେ ଆବୁ ବଙ୍ଗାବୁ ନେଲ୍‌କିୟାଃ ମେନ୍ତେକ ଆଟ୍‌କାର୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ଇନିଃ କାଜିୟାଦ୍‌କଆଏ, “ଚିନାଃମେନ୍ତେପେ ବରତାନା, ଆଡଃ ଆପେୟାଃ ମନ୍‌ରେ ଆଡ଼ାଃଉଡ଼ୁଃ ଚିନାଃମେନ୍ତେ ଅମନଃତାନା ? ");
INSERT INTO unx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ଆଇଁୟାଃ ତିଃଇ ଆଡଃ କାଟା ନେଲେପେ, ଆଇଙ୍ଗି ତାନିଙ୍ଗ୍‌ ! ଜୁଟିଦିଙ୍ଗ୍‌ପେ ଆଡଃ ନେଲ୍‌ବାଇଙ୍ଗ୍‌ପେ, ଆଇଙ୍ଗ୍‌ରେପେ ନେଲେତାନ୍‌ଲେକାନ୍‌ ଜାଙ୍ଗ୍‌ ଜିଲୁ ବଙ୍ଗାରେଦ ବାନଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ଇନିଃ ନେଆଁଁ କାଜିକେଦ୍‌ଚି ଇନ୍‌କୁକେ ଆୟାଃ ତିଃଇ ଆଡଃ କାଟା ଉଦୁବାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ଆଡଃ ଇନ୍‌କୁ ରାସ୍‌କାତେ କାକ ପାତିୟାର୍‌ତାନ୍‌ ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅକାନ୍‌ ତାଇକେନ୍‌ରେ, “ଚିୟାଃ ଆପେତାଃ ହୁଡିଙ୍ଗ୍‌ଲେକା ଜମେୟାଃଁ ମେନାଃଚି ?” ମେନ୍ତେ ଇନିଃ କୁଲିକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଆନ୍ଦାଗାକାନ୍‌ ହାକୁ ହୁଡିଙ୍ଗ୍‌ଲେକାକ ଏମ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ଆଡଃ ଇନିଃ ଏନା ତେଲାକେଦ୍‌ତେ ଇନ୍‌କୁଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଜମ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ଏନ୍ତେ ଇନିଃ ମେତାଦ୍‌କଆଏ, ମୁଶାରାଃ ଆନ୍‌ଚୁ ପୁଥିରେ ଆଡଃ ନାବୀକଆଃ ଆଡଃ ଦୁରାଙ୍ଗ୍‌ ପୁଥିରେ ଆଇଁୟାଃ ବିଷାଏରେ ସବେନ୍‌ ଅଲାକାନ୍‌ତେୟାଃ ପୁରାଅଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଏନ୍‌କାଜି ଆପେଲଃ ତାଇକେନ୍‌ ଇମ୍‌ତାଙ୍ଗ୍‌ କାଜିକାଦ୍‌ପେୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ଏନ୍ତେ ଇନିଃ ଧାରାମ୍‌ପୁଥି ଆଟ୍‌କାର୍‌ଉରୁମେଁ ନାଗେନ୍ତେ ଇନ୍‌କୁଆଃ ମନ୍‌କେ ସେଣାଁଁକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ନେଆଁଁ ଅଲାକାନା, ଖ୍ରୀଷ୍ଟ୍‌ ଦୁକୁସାହାତିଙ୍ଗ୍‌ ଆଡଃ ଆପି ମାହାଁରେ ଗଜାକାନ୍‌କଏତେ ଜୀଉବିରିଦ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ");
INSERT INTO unx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ଆଡଃ ଯୀରୁଶାଲେମ୍‌ଏତେ ଏଟେଦ୍‌କେଦ୍‌ତେ ସବେନ୍‌ ଦିଶୁମ୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କକେ ଇନିୟାଃ ନୁତୁମ୍‌ତେ ହେୟାତିଙ୍ଗ୍‌ରେୟାଃ ଆଡଃ ପାପ୍‌ ଛାମାରେୟାଃ କାଜି ଉଦୁବ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ଆଡଃ ଆପେ ନେ କାଜିରେୟାଃ ଗାୱାଇକ ତାନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ନେଲେପେ ଆଇଙ୍ଗ୍‌ ଆପୁଇଁୟାଃ ବାନାର୍‌ସା କାଜି ଆପେତାଃତେ କୁଲେୟା; ମେନ୍‌ଦ ଚେତାନ୍‌ ପେଡ଼େଃ ଆଉରିପେ ନାମେଜାକେଦ୍‌ ଯୀରୁଶାଲେମ୍‌ ସାହାର୍‌ରେ ତାଇନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ୟୀଶୁ ଇନ୍‌କୁକେ ବେଥ୍‌ନିଆ ସାମ୍‌ନାଙ୍ଗ୍‌ତେ ଅଡଙ୍ଗ୍‌ ଇଦିକେଦ୍‌କଆଏ ଆଡଃ ଆୟାଃ ତିଃଇ ରିମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁକେ ଆଶିଷ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ଆଡଃ ଇନିଃ ଇନ୍‌କୁକେ ଆଶିଷ୍‌କତାନ୍‌ଲଃ ଇନ୍‌କୁଏତେ ବିନ୍‌ଗାଅୟାନାଏ ଆଡଃ ସିର୍ମା ଦିଶୁମ୍‌ତେ ଇଦିୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଜହାର୍‌କିଃତେ ପୁରାଃ ରାସ୍‌କାତାନ୍‌ଲଃ ଯୀରୁଶାଲେମ୍‌ତେକ ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌ତାନ୍‌ଲଃ ଜାନାଅ ମାନ୍ଦିର୍‌ଅଡ଼ାଃରେକ ତାଇକେନା ।");
INSERT INTO unx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ଏନେଟେଦ୍‌ରେ କାଜି ତାଇକେନା, ଆଡଃ କାଜି ପାର୍‌ମେଶ୍ୱାର୍‌ଲଃ ତାଇକେନା, ଆଡଃ କାଜି ପାର୍‌ମେଶ୍ୱାର୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ଇନିଃ ଏନେଟେଦ୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଲଃ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ପାର୍‌ମେଶ୍ୱାର୍‌ ସବେନାଃ ଇନିଃତେ ବାଇୟାକାଦା, ଆଡଃ ବାଇୟାକାନ୍‌ ତେୟାଃଏତେ ଜେତ୍‌ନାଃ ଇନିଃକେ ବାଗିକେଦ୍‌ତେ କା ବାଇୟାକାନା, ");
INSERT INTO unx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ଇନିଃରେ ଜୀଦାନ୍‌ ତାଇକେନା ଆଡଃ ଏନ୍‌ ଜୀଦାନ୍‌ ହଡ଼କଆଃ ମାର୍ସାଲ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ମାର୍ସାଲ୍‌ ନୁବାଃରେ ଜୁଲଃତାନା, ମେନ୍‌ଦ ନୁବାଃ ଏନାକେ କାଏ ଆଟ୍‌କାର୍‌ଉରୁମ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ପାର୍‌ମେଶ୍ୱାର୍‌ତେ କୁଲାକାନ୍‌ ମିଆଁଦ୍‌ କାଜିଏମ୍‌ନିଃ ତାଇକେନାଏ, ଇନିୟାଃ ନୁତୁମ୍‌ ଯୋହାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ଇନିଃ ଏନ୍‌ ମାସ୍କାଲ୍‌ରେୟାଃ ଗାୱା ଉଦୁବ୍‌ ନାଗେନ୍ତେ ହିଜୁଃୟାନାଏ, ଜେ'ଲେକାଚି ଇନିୟାଃ ହରାତେ ସବେନ୍‌ ହଡ଼କ ବିଶ୍ୱାସେଆ । ");
INSERT INTO unx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ଇନିଃ ଆଇଃକ୍‌ଗି ଏନ୍‌ ମାସ୍କାଲ୍ କାଏ ତାଇକେନା; ମେନ୍‌ଦ ଏନ୍‌ ମାସ୍କାଲ୍‌ରେୟାଃ ଗାୱା ଏମ୍‌ ନାଗେନ୍ତେ ହିଜୁଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ଏନା ସାର୍‌ତି ମାର୍ସାଲ୍‌ ତାଇକେନା, ହେଗି ସବେନ୍‌ ହଡ଼କକେ ମାସ୍କାଲ୍‌କତାନ୍‌ ମାର୍ସାଲ୍‌ ଅତେଦିଶୁମ୍‌ରେ ହିଜୁଃତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ଇନିଃ ଅତେଦିଶୁମ୍‌ରେ ତାଇକେନାଏ, ଆଡଃ ଅତେଦିଶୁମ୍‌ ଇନିଃତେ ବାଇୟାନା, ଏନ୍‌ରେୟ ଅତେଦିଶୁମ୍‌ରେନ୍‌କ ଇନିଃକେ କାକ ସାରିକିୟା । ");
INSERT INTO unx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ଇନିଃ ଆୟାଃ ଦିଶୁମ୍‌ତେ ହିଜୁଃୟାନାଏ ମେନ୍‌ଦ ଆୟାଃ ହଡ଼କ ଇନିଃକେ କାକ ଦାରମ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ମେନ୍‌ଦ ଆଇଃକ୍‌କେ ଦାରମିତାନ୍‌କକେ, ଆଡଃ ଆୟାଃ ନୁତୁମ୍‌ରେ ବିଶ୍ୱାସେତାନ୍‌ ସବେନ୍‌ ହଡ଼କକେ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ହବାଅଃରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ଏମାଦ୍‍କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ଇନ୍‌କୁ ମାୟୋମ୍‌ତେଦ କାହା, ହଡ଼୍‌ମରେୟାଃ ମନେତେଦ କାହା ଆଡଃ ହଡ଼ଆଃ ମନେତେଦ କାହା ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଃକ୍‌ଗି ଆକଆଃ ଆପୁ । ");
INSERT INTO unx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ଆଡଃ ଏନ୍‌ କାଜି ହଡ଼୍‌ମ ସାବ୍‌କେଦା, ପୁରାଃ ଦାୟା ଆଡଃ ସାର୍‌ତିତେ ପେରେଜାକାନ୍‌, ଆବୁଆଃ ଥାଲାରେ ଡେରାକେଦାଏ ଆଡଃ ଆବୁ ଇନିୟାଃ ମାନାରାଙ୍ଗ୍‌ବୁ ନେଲ୍‌କେଦା ଏନା ଆପୁଆଃ ମିଆଁଦ୍‌ଗି ହନ୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଆଡଃ ଯୋହାନ୍‌ ଇନିୟାଃ ଗାୱା ଏମ୍‌ତାନ୍‌ଲଃ, କାଉରିକେଦ୍‌ତେ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ଅକଏୟାଃ କାଜି କାଜିତାଇକେନାଇଙ୍ଗ୍‌ ଇନିଃ ନିଃଗିତାନିଃ, ‘ଆଇଁୟାଃ ତାୟମ୍‌ତେ ହିଜୁଃଗିଆଏ, ମେନ୍‌ଦ ଇନିଃ ମାରାଙ୍ଗ୍‌ଆଁଏ, ଚିୟାଃଚି ଇନିଃଦ ଆଇଁୟାଃ ଜାନାମ୍‌ ସିଦାରେ ତାଇକେନାଏ ।’” ");
INSERT INTO unx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ଇନିୟାଃ ପେରେଜାକାନ୍‌ ଦାୟାଏତେ ଆବୁ ସବେନ୍‌କକେ ଆଶିଷାକାଦ୍‌ବୁଆଏ, ହେଗି, ଆଶିଷ୍‌ ଚେତାନ୍‌ ଆଶିଷ୍‌ ଏମାକାଦ୍‍ବୁଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ପାର୍‌ମେଶ୍ୱାର୍‌ ମୁଶାରାଃ ହରାତେ ଆନ୍‌ଚୁ ଏମ୍‍କେଦାଏ, ମେନ୍‌ଦ ଦାୟା ଆଡଃ ସାନାର୍‌ତି ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ହରାତେ ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଜେତାଏ ଚିଉଲାହ କାକ ନେଲ୍‌, ମେନ୍‌ଦ ଇନିୟାଃ ମିଆଁଦ୍‌ଗି ହନ୍‌, ଆପୁଆଃ କୟଙ୍ଗ୍‌ରେ ଦୁବାକାନ୍‌ନିଃ ଇନିଃକେ ଉଦୁବ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ଯୀରୁଶାଲେମ୍‌ରେନ୍‌ ଯିହୁଦୀ ହାକିମ୍‌କ ଚିମିନ୍‌ ଯାଜାକ୍‌କକେ ଆଡଃ ଲେବୀକକେ ଯୋହାନ୍‌ତାଃତେ “ଆମ୍‌ ଅକଏ ତାନ୍‌ମେ” ମେନ୍ତେ କୁଲି ନାଗେନ୍ତେକ କୁଲ୍‌କେଦ୍‍କଆ । ଇମ୍‌ତା ଇନିଃ ନେ ଗାୱା ଏମ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ଯୋହାନ୍‌ କାଏ ଦଦାଦ୍‍ତାନ୍‌ଲଃ ଉଦୁବ୍‍କେଦାଏ, “ଆଇଙ୍ଗ୍‌ ମାସି ନାହାଁଲିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ଏନ୍ତେ ଇନ୍‌କୁ ଯୋହାନ୍‌କେକ କୁଲିକିୟା, “ତାବ୍‌ଦ ଆମ୍‌ ଅକଏ ତାନ୍‌ମେ ?” “ଚିୟାଃ ଆମ୍‌ ଏଲିୟ ତାନ୍‌ମେ ?” ଇନିଃ ମେନ୍‌କେଦାଏ, “କାହାଗି, ଆଇଙ୍ଗ୍‌ ନାହାଁଲିଙ୍ଗ୍‌ ।” “ଚିୟାଃ ଆମ୍‌ ଏନ୍‌ ନାବୀ ତାନ୍‌ମେ ?” ଇନିଃ ମେନ୍‌ରୁହାଡ଼ାଦ୍‍କଆଏ, “କାହାଗି ।” ");
INSERT INTO unx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ଏନ୍ତେ ଇନ୍‌କୁ କାଜିକିୟାକ, “ତାବ୍‌ଦ ଆମ୍‌ ଅକଏ ତାନ୍‌ମେ ଆଲେକେ ଉଦୁବାଲେମ୍‌, ଚିୟାଃଚି ଆଲେକେ ଅକନ୍‌କ କୁଲାକାଦ୍‌ଲେୟାକ, ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଆମ୍‌ ଆପାନ୍‌କେ ଅକଏ ତାନ୍‌ମେ ମେନ୍ତେମ୍‌ କାଜିନ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ଯୋହାନ୍‌ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, ଯିଶାୟ ନାବୀ କାଜିଲେଦ୍ କାଜିଲେକା : “ଆଇଙ୍ଗ୍‌ ବିର୍‌ରେ କାଉରିତାନ୍‌ନିୟାଁଃ ସାଡ଼ି ତାନିଙ୍ଗ୍‌ : ପ୍ରାଭୁଆଃ ହରା ସିଧାଏପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ଆଡଃ ଏନ୍‌ କୁଲ୍‌ଲେନ୍‌କ ଫାରୁଶୀକଏତେକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ଇନ୍‌କୁ ଯୋହାନ୍‌କେକ କୁଲିକିୟା, “ଆମ୍‌ଦ ମାସି ନାହାଁଲାଃମେ, ଏଲିୟ ହଁ ନାହାଁଲାଃମେ ଆଡଃ ଏନ୍‌ ନାବୀହ ନାହାଁଲାଃମେ, ମେନ୍‌ଦ ଚିନାଃ ମେନ୍ତେମ୍‌ ବାପ୍ତିସ୍ମାକତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ଯୋହାନ୍‌ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ଦ ଦାଆଃତେ ବାପ୍ତିସ୍ମାପେ ତାନାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଆପେୟାଃ ଥାଲାରେ ମିଆଁଦ୍‌ ହଡ଼ ତିଙ୍ଗୁଆକାନାଏ ଇନିଃକେ ଆପେ କାପେ ସାରିୟା । ");
INSERT INTO unx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ଆଇଁୟାଃ ତାୟମ୍‌ତେ ହିଜୁଃନିଃ ଇନିଃଗି ତାନିଃ, ଇନିୟାଃ ଖାର୍‌ପାରେୟାଃ ତନଲ୍‌ ରାଡ଼ାଏ ଲେକାନ୍‌ନିଃ ନାହାଁଲିଙ୍ଗ୍‌” ମେନ୍ତେ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ନେ କାଜିକ ଯାର୍ଦାନ୍‌ ଗାଡ଼ା ହାନ୍‍ ପାରମ୍‍ରେୟାଃ ବେଥ୍‌ନିଆରେ ହବାୟାନା ଏନ୍ତାଃରେ ଯୋହାନ୍‌ ବାପ୍ତିସ୍ମା ଏମାକତାନ୍‍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଯୋହାନ୍‌ ୟୀଶୁକେ ଆୟାଃତାଃତେ ହିଜୁଃତାନ୍‍ ନେଲ୍‌କିୟାଏ, ଆଡଃ ମେନ୍‌କେଦାଏ, “ନେଲିପେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମିଣ୍ଡିହନ୍‌, ଇନିଃ ଅତେଦିଶୁମ୍‌ରେୟାଃ ପାପ୍‌କେ ଗଅଃ ଇଦିୟାଏ ! ");
INSERT INTO unx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ଆଇଁୟାଃ ତାୟମ୍‌ତେ ମିହୁଡ଼୍‌ ହିଜୁଃଆଏ ଇନିଃ ଆଇଁୟାଃତାଃଏତେ ପୁରାଃ ମାରାଙ୍ଗ୍‌ ମେନ୍ତେଇଙ୍ଗ୍‌ କାଜିଲେଦ୍ ହଡ଼ ନିଃଗି ତାନିଃ, ଇନିଃଦ ଆଇଁୟାଃ ଜାନାମ୍‌ଏତେ ସିଦାରେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିଉରୁମିତାନ୍ ତାଇକେନା, ମେନ୍‌ଦ ଇନିଃ ଇସ୍ରାଏଲ୍‌ ହଡ଼କତାଃରେ ଉଦୁବଃକାଏ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଦାଆଃତେ ବାପ୍ତିସ୍ମାକ ନାଙ୍ଗ୍‌ ହିଜୁଃକାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ଆଡଃ ଯୋହାନ୍‌ ଗାୱା ଏମ୍‌ତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ଆତ୍ମାକେ ଦୁଦୁମୁଲ୍‌ ଲେକା ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁତାନ୍‍ ଆଡଃ ଇନିଃରେ ତାଇନଃତାନ୍‌ ନେଲ୍‍କିୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ଆଇଙ୍ଗ୍‌ହଁ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ନେଲ୍‌ଉରୁମି ତାଇକେନା ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ ଦାଆଃତେ ବାପ୍ତିସ୍ମା ଏମ୍‌ ନାଙ୍ଗ୍‌ କୁଲ୍‌କାଦିଙ୍ଗ୍‌ନିଃ, ଆଇଙ୍ଗ୍‌କେ କାଜିକିୟାଁ, ‘ଆମ୍‌ ଆତ୍ମାକେ ମିଆଁଦ୍‌ ହଡ଼ରେ ଆଡ଼୍‌ଗୁତାନ୍ ଆଡଃ ଇନିଃରେ ତାଇନ୍‌ତାନ୍ ନେଲିୟାମ୍‌, ଇନିଃଗି ପାବିତାର୍‌ ଆତ୍ମାତେ ବାପ୍ତିସ୍ମା ଏମାକତାନ୍‍ନିଃ ତାନିଃ ।’ ");
INSERT INTO unx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ଆଡଃ ଆଇଙ୍ଗ୍‌ ନେଲ୍‍କେଦାଃଇଙ୍ଗ୍‌, ଆଡଃ ନିଃଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ମେନ୍ତେ ଗାୱାଇଙ୍ଗ୍‌ ଏମେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଯୋହାନ୍‌ ଆୟାଃ ଚେଲାକଏତେ ବାର୍‍ହଡ଼୍‌କିନ୍‌ଲଃ ଏନ୍ତାଃରେ ଆଡଃଗି ତିଙ୍ଗୁଆକାନ୍‍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ଇନିଃ ୟୀଶୁକେ ସେନ୍‍ପାରମଃତାନ୍ ନେଲ୍‍କେଦ୍‍ତେ କାଜିକେଦାଏ, “ନେଲିପେ, ନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମିଣ୍ଡିହନ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ଆଡଃ ଏନ୍‍ ବାରାନ୍‌ ଚେଲାକିନ୍‍ ଇନିଃ ନେଆଁଁ କାଜିତାନ୍‌ ଆୟୁମ୍‌କେଦ୍‌ଚି ୟୀଶୁକେ ଅତଙ୍ଗ୍‌କିୟାକିନ୍‌ ");
INSERT INTO unx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ୟୀଶୁ ହେତାରୁହାଡ଼୍‌କେଦ୍‍ଚି, ଇନ୍‌କିନ୍‌ ଅତଙ୍ଗ୍‌ଇଁତାନ୍‌ ନେଲ୍‍କେଦ୍‍କିନାଏ ଆଡଃ ମେତାଦ୍‌କିନାଏ, “ଚିକ୍‌ନାଃବେନ୍ ନାମ୍‌ତାନା ?” ଆଡଃ ଇନ୍‌କିନ୍‌ ମେନ୍‌ରୁହାଡ଼ାଇୟାକିନ୍‌, “ଏ ରାବି” କତାଃରେମ୍‌ ତାଇନ୍‍ତାନା ? ");
INSERT INTO unx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ମାର୍‌ “ହିଜୁଃକେଦ୍‍ତେ ନେଲେବେନ୍‍” ମେତାଦ୍‍କିନାଏ । ଏନାମେନ୍ତେ ଇନ୍‌କିନ୍‌ ସେନଃୟାନ୍ତେ ଇନିଃ ତାଇନ୍‍ତାନ୍‍ ଠାୟାଦ୍‍କିନ୍‍ ନେଲ୍‍କେଦାଃ, ଇମ୍‍ତାଙ୍ଗ୍‌ଦ ଚେତାନ୍ ସିଙ୍ଗିରାଃ ଉପୁନ୍‌ ଘାଡ଼ି ହବାକାନ୍‍ ତାଇକେନା, ଆଡଃ ଏନ୍‍ ହୁଲାଙ୍ଗ୍‌ ଇନିଃଲଃକିନ୍‌ ତାଇନ୍‍ୟାନା, ");
INSERT INTO unx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ଯୋହାନ୍‌ଆଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ୟୀଶୁକେ ଅତଙ୍ଗ୍‌କାଇ ଏନ୍‌ ବାରିଆ ଚେଲାକିନ୍ଏତେ ମିଆଁଦ୍‌ନିଃ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ଆଃ ହାଗାତେ ଆନ୍ଦ୍ରିୟାସ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ଆନ୍ଦ୍ରିୟାସ୍‌ ଆୟାଃ ହାଗାତେ ଶିମୋନ୍‌କେ ନାମ୍‌କେଦ୍‌ତେ କାଜିକିୟା, “ଆଲିଙ୍ଗ୍‌ ମାସିକେ ନାମାକାଇଜାଲିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ଆଡଃ ଇନିଃ ଶିମୋନ୍‌କେ ୟୀଶୁତାଃତେ ଆଉକିୟା, ୟୀଶୁ ଇନିଃକେ ନେଲ୍‍କେଦ୍‍ତେ କାଜିକିୟା, “ଆମ୍‌ ଯୋହାନ୍‌ଆଃ ହନ୍‌ ଶିମୋନ୍‌ ତାନ୍‌ମେ, ଆମ୍‌ କେଫା, ଏନାରେୟାଃ ମୁଣ୍ଡି ‘ପାତ୍‌ରାସ୍‌’ ମେନ୍ତେମ୍‌ ନୁତୁମଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ୟୀଶୁକେ ଗାଲିଲ୍‌ତେ ସେନଃ ସାନାଙ୍ଗ୍‌କିୟା । ଇନିଃ ଫିଲିପ୍‌କେ ନାମ୍‌କିଃତେ ମେତାଇୟାଏ, “ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ଆନ୍ଦ୍ରିୟାସ୍‌ ଆଡଃ ପାତ୍‌ରାସ୍‌ଲେକା ଫିଲିପ୍‌ ହଗି ବେଥ୍‌ସାଇଦା ସାହାର୍‌ରେନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ଫିଲିପ୍‌ ନିଥ୍‌ନିୟେଲ୍‌କେ ନାମ୍‌କିଃତେ ମେତାଇୟାଏ, “ମୁଶା ଅଲାକାଦ୍‌ ଆନ୍‌ଚୁ ପୁଥିରେ ଆଡଃ ନାବୀକହ ଅଲାକାଦ୍‌ ହଡ଼କେ ଆଲେ ନାମାକାଇୟାଃ ଇନିଃ ଯୋଷେଫ୍‌ ହନ୍‌ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିଥ୍‌ନିୟେଲ୍‌ କୁଲିକିୟାଏ, “ଚିୟାଃ ନାଜ୍‌ରେତ୍‌ଏତେ ଜେତ୍‌ନାଃ ବୁଗିନ୍‌ ଅଡଙ୍ଗ୍‌ଦାଡ଼ିଅଃଆ ?” ଫିଲିପ୍‌ ମେନ୍‌ରୁହାଡ଼ାଇୟା, “ମାର୍‌ ହିଜୁଃକେଦ୍‍ତେ ନେଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ୟୀଶୁ, ନିଥ୍‌ନିୟେଲ୍‌କେ ଆୟାଃତାଃ ହିଜୁଃତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ କାଜିକେଦାଏ, “ନେଲିପେ, ନିଃ ସାର୍‌ତିଗି ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ତାନିଃ, ଇନିଃରେ ଜେତାଏ ବେଦା ବାନଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିଥ୍‌ନିୟେଲ୍‌ ଇନିଃକେ କୁଲିକିୟା, “ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଚିଲ୍‌କାତେମ୍‌ ସାରିକେଦିୟାଁ ?” ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଫିଲିପ୍‌ ଆମ୍‌କେ କେଡ଼ାକେଦ୍‌ମେ ସିଦାରେ ଆମ୍‌ ଲଆଦାରୁ ବୁଟାରେମ୍‌ ତାଇକେନା, ଇମ୍‌ତା ଆଇଙ୍ଗ୍‌ ନେଲ୍‌କେଦ୍‍ମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ଏନ୍ତେ ନିଥ୍‌ନିୟେଲ୍‌ କାଜିକେଦାଃଏ, “ଏ ରାବି, ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନ୍‌ମେ; ଆମ୍‌ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ରାଜା ତାନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ୟୀଶୁ କାଜିକିୟାଏ, “ଚିୟାଃ ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ଲଆଦାରୁ ବୁଟାରେଇଙ୍ଗ୍‌ ନେଲ୍‌ଲେଦ୍‍ମେୟା ମେନ୍ତେ କାଜିୟାଦ୍‌ମାଇଙ୍ଗ୍‌, ଏନାମେନ୍ତେମ୍‌ ବିଶ୍ୱାସେତାନା ? ଆମ୍‌ ଏନାଏତେହ ମାପ୍‌ରାଙ୍ଗ୍‌ ବିଷାଏତେୟାଃକ ନେଲେୟାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ଇନିଃ ଆଡଃଗି ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌ ଆପେ ସିର୍ମା ନିଜାକାନ୍‌ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଁତ୍‌କ ମାନୱାହନ୍‌ ଚେତାନ୍‌ରେ ରାକାବ୍‌ତାନ୍‌ ଆଡଃ ଆଡ଼୍‌ଗୁନ୍‌ତାନ୍‌ପେ ନେଲ୍‌କଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ଆପି ମାହାଁ ହୁଲାଙ୍ଗ୍‌ରେ ଗାଲିଲ୍‌ରେୟାଃ କାନା ହାତୁରେ ଆଣ୍‌ଦି ହବାଅଃ ତାଇକେନା, ଆଡଃ ୟୀଶୁଆଃ ଏଙ୍ଗାତେ ଏନ୍ତାଃରେ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକକେ ହଗି ଏନ୍‌ ଆଣ୍‌ଦି ଅଡ଼ାଃତେ କେଡ଼ାକାନ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ଚିମ୍‌ତା ଦାଖ୍‌ରାସି ଚାବାୟାନା, ୟୀଶୁଆଃ ଏଙ୍ଗାତେ ଇନିଃକେ କାଜିକିୟା, “ଇନ୍‌କୁତାଃରେ ଦାଖ୍‌ରାସି ବାନଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ୟୀଶୁ ମେନ୍‌ରୁହାଡ଼ାଇୟାଏ, “ଆଇଙ୍ଗ୍‌ଲଃ ଆମାଃ ଚିକାନ୍‌ ନାତା ? ଆଇଁୟାଃ ନେଡା ଆଉରି ସେଟେରାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ମେନ୍‌ଦ ୟୀଶୁଆଃ ଏଙ୍ଗାତେ ଦାସିକକେ କାଜିୟାଦ୍‌କଆଏ, “ଇନିଃ ଆପେକେ କାଜିପେ ଲେକା କାମିପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ଆଡଃ ଯିହୁଦୀକଆଃ ଫାର୍‌ଚିଅଃନାଙ୍ଗ୍‌ ଏନ୍ତାଃରେ ଦିରିତେ ବାଇୟାକାନ୍‌ ତୁରିୟା ଘୁମା ଦହାକାନ୍‌ ତାଇକେନା, ମିଆଁଦ୍‌ରେ ମିଦ୍‌ହିସି ଚାଏ ତିରିଶ୍‌ ଗ୍ୟାଲେନ୍‌ ଦାଆଃ ସାବେତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ୟୀଶୁ ଦାସିକକେ କାଜିୟାଦ୍‌କଆଏ, “ନେ ଘୁମାକରେ ଦାଆଃ ପେରେଃତାପେ” ଆଡଃ ଇନ୍‌କୁ ଘୁମାରେ ଦାଆଃ ଦୁଲ୍‌ ପେରେଃକେଦା । ");
INSERT INTO unx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ନାହାଃଁଦ ଏନ୍‌ ଦାଆଃଏତେ କାଟିଃ ଅଡଙ୍ଗ୍‌ୟେଁପେ ଆଡଃ ମାରାଙ୍ଗ୍‌ଜଜମାଃରେନ୍‌ ଗମ୍‌କେତାଃ ଇଦିପେ ।” ଏନ୍ତେ ଇନ୍‌କୁ ଏନ୍‌ ଦାଆଃକେ ଇଦିକେଦାଃକ, ");
INSERT INTO unx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ଆଡଃ ମାରାଙ୍ଗ୍‌ଜଜମାଃରେନ୍‌ ଗମ୍‌କେ ଏନ୍‌ ଦାଖ୍‌ରାସି ବାୟାକାନ୍ ଦାଆଃକେ ଚାଖାଅକେଦାଃ ଆଡଃ ଏନା ଅକ୍‌ତାଃଏତେ ହିଜୁଆକାନା ଏନା କାଏ ସାରିକେଦା, ମେନ୍‌ଦ ଏନ୍‌ ଦାଆଃ ଅଡଙ୍ଗ୍‌କେନ୍‌ ଦାସିକ ସାରିତାଇକେନାକ । ଏନ୍ତେ ଇନିଃ ଦୁହ୍ଲାକଡ଼ାକେ ଗେନାତେ ହାକାଅକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ଆଡଃ କାଜିକିୟାଏ, “ସବେନ୍‌ ହଡ଼କ ସିଦାତେ ବୁଗିନ୍‌ ଦାଖ୍‌ରାସିକ ଏମାକଆ ଆଡଃ ହଡ଼କ ନୁଁ ଆସ୍‌ଦିୟାନ୍‌ରେ ସାବାଃତେଆଃକ ଏମାକଆ, ମେନ୍‌ଦ ଆମ୍‌ ବୁଗିନ୍‌ ଦାଖ୍‌ରାସି ନାହାଁଃ ଜାକେଦ୍‌ ଦହାକାଦାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ନେ'ଲେକା ୟୀଶୁ ଗାଲିଲ୍‌ରେୟାଃ କାନା ହାତୁରେ ଆୟାଃ ପାହିଲା ପେଡ଼େୟାନ୍‌ କାମି ଏଟେଦ୍‌କେଦାଏ ନେ'ଲେକା ଇନିଃ ଆୟାଃ ମାନାରାଙ୍ଗ୍‌ ଉଦୁବ୍‌କେଦାଏ ଆଡଃ ଇନିୟାଃ ଚେଲାକ ଇନିଃରେକ ବିଶ୍ୱାସ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ଏନ୍‌ ତାୟମ୍‌ତେ ୟୀଶୁ ଆଡଃ ଇନିୟାଃ ଏଙ୍ଗାତେ, ହାଗାତେ, ଆଡଃ ଚେଲାକ କପର୍‌ନାହୁମ୍‌ ସାହାର୍‌ତେ ସେନଃୟାନା ଆଡଃ ଏନ୍ତାଃରେ ଚିମିନ୍‌ ମାହାଁଲେକା ତାଇନ୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ଆଡଃ ଯିହୁଦୀକଆଃ ପାସ୍‌କା ପାରାବ୍‌ ନାଡ଼େୟାକାନ୍‌ ତାଇକେନା, ଆଡଃ ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ଇନିଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଉରିଃକ୍‌କ, ମିଣ୍ଡିକ, ଦୁଦୁମୁଲ୍‌କକେ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ତାନ୍‌କକେ ଆଡଃ ଦୁବାକାନ୍‌ ପାଏସା ଭାଞ୍ଜାଅତାନ୍‌କକେ ନାମ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ଏନ୍ତେ ଇନିଃ ବାଏହାର୍‌ ରେୟାଃ ହାଁଣ୍‌ସା ବାଇକେଦ୍‍ତେ ସବେନ୍‌ ମିଣ୍ଡି ଆଡଃ ଉରିଃକ୍‌କକେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‍କଆଏ ଆଡଃ ପାଏସା ଭାଞ୍ଜାଅତାନ୍‌କଆଃ ଗାଣ୍ଡୁକକେ ଉଦୁର୍‌ବାଟିକେଦାଏ ଆଡଃ ପାଏସାକ ଛିତିବିତିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ଆଡଃ ଦୁଦୁମୁଲ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌କକେ କାଜିୟାଦ୍‌କଆଏ, “ନିକୁକେ ନେତାଃଏତେ ଇଦିକପେ । ଆପୁଇଁୟାଃ ଅଡ଼ାଃ କିରିଙ୍ଗ୍‌ ଆଖ୍‌ରିଙ୍ଗ୍‌ ଅଡ଼ାଃ ଆଲ୍‌ପେ ବାଇୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ନେଆଁ ନେଲ୍‌କେଦ୍‌ତେ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ତେୟାଃ ଇନିୟାଃ ଚେଲାକ ପାହାମ୍‌କେଦାକ, “ଆମାଃ ଅଡ଼ାଃ ନାଗେନ୍ତେ ଆଇଁୟାଃ ଚିହୁଲ୍‌ତେୟାଃ ଇଣିଁଜଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ଏନ୍ତେ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କ ୟୀଶୁତାଃ ହିଜୁଃରୁହାଡ଼୍‌କେଦ୍‌ତେ ନେଆଁଁ କୁଲିକିୟାଃକ, “ଆମ୍‌ ନେ ସବେନାଃ କାମି ନାଗେନ୍ତେ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦାମ୍‌ ମେନ୍ତେ ଆଲେ ଚିଲ୍‌କାଲେ ସାରିୟା ? ଆଡଃ ଚିକାନ୍‌ ଚିହ୍ନାଁତେ ଆଲେକେମ୍‌ ଉଦୁବାଲେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ନେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃକେ ହାଦୁଡ଼୍‌ ତାପେ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଏନାକେ ଆପି ମାହାଁରେ ବାଇରୁହାଡ଼େୟାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ଆଡଃ ଯିହୁଦୀକ କାଜିକିୟାଃକ, “ନେ ମାନ୍ଦିର୍‌କେ ବାଇକେସେଦ୍‌ନାଙ୍ଗ୍‌ ଛୟାଲିଶ୍‌ ସିର୍ମା ଲାଗାଅୟାନା, ଚିୟାଃ ଆମ୍‌ ଆପି ମାହାଁରେ ଆଡଃମିସା ବାଇରୁହାଡ଼େୟାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ମେନ୍‌ଦ ୟୀଶୁ ଆୟାଃ ହଡ଼୍‌ମରେୟାଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଃ କାଜି କାଜିତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ଏନ୍ତେ ଇନିଃ ଗଜାକାନ୍‌କ ଏତେ ଜୀଉବିରିଦ୍‌ୟାନ୍ତେ ଇନିୟାଃ ଚେଲାକ ଇନିଃ ନେ କାଜିଏ କାଜିଲେଦା ନେଆଁକ ପାହାମ୍‌କେଦାଃ । ଏନ୍ତେ ଧାରାମ୍‌ପୁଥିରେ ଆଡଃ ୟୀଶୁ କାଜିକେଦ୍‌ କାଜିରେକ ବିଶ୍ୱାସ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ଆଡଃ ୟୀଶୁ ପାସ୍‌କା ପାରାବ୍‌ ଦିପିଲିରେ ଯୀରୁଶାଲେମ୍‌ରେ ତାଇକେନ୍‌ ଇମ୍‌ତା ପୁରାଃ ହଡ଼କ ଇନିଃ କାମି ତାଇକେନ୍‌ ଚିହ୍ନାଁକ ନେଲ୍‌କେଦ୍‌ତେ ଇନିଃତାଃରେକ ବିଶ୍ୱାସ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ କାଏ ବିଶ୍ୱାସ୍‌କେଦ୍‌କଆ, ଚିୟାଃଚି ଇନିଃ ହଡ଼କଆଃ ମନ୍‌କେ ସାରିତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ମାନୱା ନାଗେନ୍ତେ ଜେତାଏ ଗାୱାକ ଇନିୟାଃ ଲାଗାତିଙ୍ଗ୍‌ କା ତାଇକେନା, ଚିୟାଃଚି ମାନୱାରାଃ ମନ୍‌ସୁରୁଦ୍‌ରେ ଚିକ୍‌ନାଃ ମେନାଃ ଏନାଦ ଇନିଃ ଆଇଃକ୍‌ଗି ସାରିତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ଫାରୁଶୀକଏତେ ନିକଦୀମ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ, ଇନିଃ ଯିହୁଦୀକଆଃ ମିଆଁଦ୍‌ ଆଗୁଆଇ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ଇନିଃ ମିଆଁଦ୍‌ ନିଦା ୟୀଶୁତାଃ ହିଜୁଃକେଦ୍‌ତେ କାଜିକିୟା, “ହେ ଗୁରୁ, ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ସାଃଏତେ ଇତୁନିଃ ହିଜୁଆକାନାମ୍‌ ଏନାଦଲେ ସାରିୟାଃ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଜେତାଏଲଃ କା ତାଇନ୍‌ରେଦ ଇନିଃ ଆମ୍‌ କାମିକାଦ୍ ଚିହ୍ନାଁକ କାଏ କାମିଦାଡ଼ିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟା, “ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାମେତାନା, ଜେତାଏ କାଏ ଜାନାମ୍‌ରୁହାଡ଼୍‌ରେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ କାଏ ନେଲ୍‌ଦାଡ଼ିୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନିକଦୀମ୍‌ କୁଲିକିୟାଏ, “ହଡ଼ ହାଡ଼ାମ୍‌ୟାନ୍ତେ ଚିଲ୍‌କାତେ ଜାନାମ୍‌ରୁହାଡ଼୍‌ ଦାଡ଼ିୟାଃ ?” “ଇନିଃ ଚିୟାଃ ଆଡଃମିସା ଏଙ୍ଗାତେୟାଃ ଲାହିଦ୍‍ରେ ବଲକେଦ୍‌ତେ ଜାନାମ୍‌ ଦାଡ଼ିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାମେତାନା, ଦାଆଃ ଆଡଃ ଆତ୍ମାତେ କାକ ଜାନାମ୍‌ରୁହାଡ଼ଃରେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ଜେତାଏ କାକ ବଲଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ହଡ଼୍‌ମଏତେ ଜାନାମାକାନ୍‌ତେୟାଃ ହଡ଼୍‌ମଗି ତାନାଃ ଆଡଃ ଆତ୍ମାଏତେ ଜାନାମାକାନ୍‌ତେୟାଃ ଆତ୍ମାଗି ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ଜାନାମ୍‌ରୁହାଡ଼୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ମେନ୍ତେଇଙ୍ଗ୍‌ କାଜିୟାଦ୍‍ମେଆ, ଏନାତେ ଆଲମ୍‌ ହାଏକାଟଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ହୟ ଆୟାଃ ସାନାଙ୍ଗ୍‌ ଲେକାତେ ହୟତାନା ଆଡଃ ଏନାରେୟାଃ ଲାବ୍‌ଜା ଆୟୁମଃତାନା, ମେନ୍‌ଦ ଏନା ଅକସାଃ ଏତେ ହିଜୁଃତାନା ଆଡଃ ଅକ୍‌ତାଃତେ ସେନଃତାନା ଏନା କା ସାରିୟଃଆ । ଆତ୍ମାଏତେ ସବେନ୍‌ ଜାନାମାକାନ୍‌କ ନେ'ଲେକାଗିଆଃକ ।” ");
INSERT INTO unx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନିକଦୀମ୍‌ ଇନିଃକେ କୁଲିକିୟାଏ, “ନେଆଁଁ ଚିଲ୍‌କାତେ ହବାଦାଡ଼ିୱାଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ୟୀଶୁ କାଜିକିୟାଏ, “ଚିୟାଃ ଆମ୍‌ ଇସ୍ରାଏଲ୍‌ରେନ୍‌କଆଃ ଗୁରୁ ତାନ୍‌ମେ ଆଡଃ ନେଆଁଁ କାମ୍‌ ସାରିୟା ?” ");
INSERT INTO unx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାମେତାନା, “ଆଲେ ସାରିୟାକାଦ୍‌ କାଜିଲେ କାଜିତାନା ଆଡଃ ନେଲାକାନ୍‌ରେୟା ଗାୱାଲେ ଏମେତାନା ଆଡଃ ଆପେ ଆଲେୟାଃ ଗାୱା କାପେ ମାନାତିଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ଆଇଙ୍ଗ୍‌ ନେ ଅତେରେୟାଃ କାଜିଙ୍ଗ୍‌ କାଜିୟାଦ୍‍ପେରେ କାପେ ପାତିୟାରେତାନା, ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ସିର୍ମାରେୟାଃ କାଜିଙ୍ଗ୍‌ କାଜିୟାପେରେ ଚିଲ୍‌କାତେପେ ପାତିୟାରେଆ । ");
INSERT INTO unx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ଅକନ୍‌ ମାନୱାହନ୍‌ ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁଆକାନାଏ, ଇନିଃକେ ବାଗିକିଃତେ ଆଡଃ ଜେତାଏ ହଡ଼ ଚିଉଲାହ ସିର୍ମାତେ କାଏ ରାକାବାକାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ଆଡଃ ମୁଶା ବିର୍‌ରେ ପିତାଲ୍‌ ବିଙ୍ଗ୍‌କେ ଖୁଁଟାରେ ରାକାବି ଲେକା ମାନୱାହନ୍‌କେହଗି ରାକାବଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ଇନିଃରେ ବିଶ୍ୱାସ୍‌ତାନ୍‌କଦ ଜାନାଅ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌କ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଅତେଦିଶୁମ୍‌କେ ପୁରାଃଗି ଦୁଲାଡ଼୍‌କେଦାଏ ଆଡଃ ଆୟାଃ ମିଆଁଦ୍‌ଗି ଦୁଲାଡ଼୍‌ହନ୍‌କେ ଏମ୍‍କିୟାଏ, ଇନିଃରେ ବିଶ୍ୱାସ୍‌ତାନ୍‍କଦ କାକ ଜିୟନଃଆ ମେନ୍‌ଦ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌କ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ହନ୍‍କେ ଅତେଦିଶୁମ୍‌ରାଃ ବିଚାର୍‌ ନାଗେନ୍ତେଦ କାହା, ମେନ୍‌ଦ ଅତେଦିଶୁମ୍‌କେ ଇନିଃତେ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ କୁଲ୍‍କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ଜେତାଏ ହନ୍‌ରେ ବିଶ୍ୱାସ୍‍ତାନ୍‍ନିଃ କାଏ ସାଜାଇୟାଃ ମେନ୍‌ଦ କା ବିଶ୍ୱାସ୍‍ତାନ୍‍ନିଃ ସାଜାଇୟାକାନାଏ, ଚିୟାଃଚି ଇନିଃଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମିଆଁଦ୍‌ଗି ହନ୍ଆଃ ନୁତୁମ୍‌ରେ କାଏ ବିଶ୍ୱାସ୍‌କାଦା । ");
INSERT INTO unx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ଆଡଃ ଏନ୍‌ ବିଚାର୍‌ ନେଆଁଁଗି ତାନାଃ, ମାର୍ସାଲ୍ ଅତେଦିଶୁମ୍‌ରେ ହିଜୁଆକାନା, ମେନ୍‌ଦ ହଡ଼କ ମାର୍ସାଲ୍‍ ଏତେ ନୁବାଃକେ ଆଦ୍‌କାକ ଦୁଲାଡ଼୍‌କେଦାଃ ଚିୟାଃଚି ଇନ୍‌କୁଆଃ କାମିକଦ ଏତ୍‍କାନାଃ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ଏତ୍‍କାନ୍‌ କାମିତାନ୍‌କଦ ମାର୍ସାଲ୍‍କେ କାକ ଦୁଲାଡ଼ାଃ, ଆଡଃ ମାର୍ସାଲ୍‌ତାଃତେ କାକ ହିଜୁଃଆ, ଚିୟାଃଚି ଇନ୍‌କୁଆଃ ଏତ୍‌କାନ୍‌ କାମି ମାର୍ସାଲ୍‍ରେ ଉଦୁବଃକା ମେନ୍ତେ ଇନ୍‌କୁ କାକ ସାନାଙ୍ଗ୍‌ଆଁଃ । ");
INSERT INTO unx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ମେନ୍‌ଦ ଜେତାଏ ସାର୍‌ତି କାମି କାମିୟାଏ, ଇନିଃ କାମିକାଦ୍‌ତେୟାଃକ ଜେ'ଲେକା ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାନାଙ୍ଗ୍‌ଲେକା କାମିକେଦାଏ ମେନ୍ତେ ଉଦୁବଃକା, ଏନାମେନ୍ତେ ଇନିଃ ମାର୍ସାଲ୍‌ତାଃଏ ହିଜୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ନେଆଁଁ ତାୟମ୍‌ତେ, ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ଯିହୁଦା ଦିଶୁମ୍‌ତେକ ସେନଃୟାନା ଆଡଃ ଇନିଃ ଇନ୍‌କୁଲଃ ଏନ୍ତାଃରେ ତାଇନ୍‍ୟାନ୍ତେ ବାପ୍ତିସ୍ମାକତାନ୍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ଆଡଃ ଯୋହାନ୍‌ହଁ ସାଲିମ୍‌ ଜାପାଃ ଏନନ୍‌ରେ ବାପ୍ତିସ୍ମାକତାନ୍ ତାଇକେନାଏ, ଚିୟାଃଚି ଏନ୍ତାଃରେଦ ପୁରାଃଗି ଦାଆଃ ତାଇକେନା, ଆଡଃ ହଡ଼କ ବାପ୍ତିସ୍ମାଅଃ ନାଗେନ୍ତେ ହିଜୁଃତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ଯୋହାନ୍‌ଦ ଇମ୍‌ତାଙ୍ଗ୍‌ ଜାକେଦ୍‌ କାଏ ଜେହେଲାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ଏନ୍ତେ ଯୋହାନ୍‌ଆଃ ଚିମିନ୍‍ ଚେଲାକ ଆଡଃ ମିଆଁଦ୍‌ ଯିହୁଦୀ, ଫାର୍‌ଚିଅଃରେୟା ବିଷାଏରେ କୁପୁଲିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ଇନ୍‌କୁ ଯୋହାନ୍‌ତାଃତେ ହିଜୁଃୟାନ୍ତେ କାଜିକିୟା, “ହେ ଗୁରୁ” ଯାର୍ଦାନ୍‌ ହାନ୍‌ ପାରମ୍‍ ଆମାଃଲଃ ତାଇକେନ୍‍ନିଃ, ଇନିୟାଃ ନାଗେନ୍ତେ ଆମ୍‌ ଗାୱା ଏମ୍‌କେଦାଃ, ନେଲିମେ ଇନିଃ ବାପ୍ତିସ୍ମାକତାନାଏ, ଆଡଃ ସବେନ୍‌କ ଇନିଃତାଃ ସେନଃତାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଯୋହାନ୍‌ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ସିର୍ମାସାଃଏତେ କା ଏମଃରେଦ ହଡ଼ ଜେତ୍‌ନାଃ କାଏ ନାମ୍‍ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘ଆଇଙ୍ଗ୍‌ଦ ମାସି ନାହାଁଲିଙ୍ଗ୍‌ ମେନ୍‌ଦ ଇନିୟାଃ ଆୟାର୍‌ରେ କୁଲାକାନାଇଙ୍ଗ୍‌’ ମେନ୍‍କେଦାଃଏ, ଏନାରେୟାଃ ଗାୱା ଆପେଗି ତାନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ଜେତାଏ ଆଣ୍‌ଦିୟଃନିଃ ଦ ଦୁହ୍ଲାକଡ଼ାରାଃ ତାନିଃ, ମେନ୍‌ଦ ଦୁହ୍ଲାତାଃ ତିଙ୍ଗୁକେଦ୍‌ତେ ଇନିୟାଃ କାଜି ଆୟୁମ୍‌ତାନ୍ ଗାତି ଦୁହ୍ଲାରାଃ କାଜିତେ ପୁରାଃଗି ରାସ୍‌କାଅଃଆ । ଏନାତେ ଆଇଁୟାଃ ନେ ରାସ୍‌କାଦ ନାମ୍‌ଚାବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ଇନିଃକେ ମାରାଙ୍ଗ୍‌ ହବା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ ହୁଡିଙ୍ଗ୍‌ଅଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ଚେତାନ୍ଏତେ ହିଜୁଃନିଃ ସବେନ୍‌କଏତେ ମାରାଙ୍ଗ୍‌ଆଁଏଃ । ଅତେସାଃଏତେ ହିଜୁଃନିଃ ଅତେରେନ୍‍ନିଃ ତାନିଃ ଆଡଃ ଅତେସାଃଏତେ କାଜିୟାଏ ମେନ୍‌ଦ ସିର୍ମାସାଃଏତେ ହିଜୁଃନିଃ ସବେନ୍‌କଏତେ ମାରାଙ୍ଗ୍‌ଆଁଏଃ । ");
INSERT INTO unx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ଇନିଃ ନେଲାକାଦ୍‍ ଆଡଃ ଆୟୁମାକାଦ୍ ତେୟାଃରାଃ ଗାୱାଇ ପେରେଃକେଦା ମେନ୍‌ଦ ଇନିୟାଃ ଗାୱା ଜେତାଏ କାକ ମାନାତିଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ମେନ୍‌ଦ ଇନିୟାଃ ଗାୱା ଅକଏ ମାନାତିଙ୍ଗ୍‌ନିଃ, ପାର୍‌ମେଶ୍ୱାର୍‌ ସାର୍‌ତିଗିୟାଏ ମେନ୍ତେ ଏନ୍‌ କାଜିରେ ମୋହର୍‌କାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ପାର୍‍ମେଶ୍ୱାର୍‌ତାଃଏତେ କୁଲାକାନ୍‍ନିଃଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି କାଜିୟାଏ, ଚିୟାଃଚି ପାର୍‍ମେଶ୍ୱାର୍‌ଦ ଇନିଃକେ ଆୟାଃ ଆତ୍ମା ପୁରାଃଗି ଏମିୟା । ");
INSERT INTO unx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ଆପୁଦ ଆୟାଃ ହନ୍‌କେ ଦୁଲାଡ଼ାଃଏ ଆଡଃ ସବେନାଃ ଇନିୟାଃ ତିଃଇରେ ଏମ୍ଉତାରାକାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ହନ୍‍ରେ ବିଶ୍ୱାସ୍‌ତାନ୍‍ନିୟାଃ ଜାନାଅଜୀଦାନ୍‍ ମେନାଃ, ମେନ୍‌ଦ ହନ୍‌କେ କାଏ ଦାରମ୍‌ତାନ୍‌ନିଃ ଜୀଦାନ୍‌ କାଏ ନେଲେୟା, ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଏନେସେଦ୍ ଇନିଃରେ ତାଇନ୍‍ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ଫାରୁଶୀକ, ୟୀଶୁ ଯୋହାନ୍‌ ଏତେ ଆଦ୍‌କା ଚେଲାକେଦ୍‍ତେ ବାପ୍ତିସ୍ମାକତାନାଏ ମେନ୍ତେକ ଆୟୁମ୍‍କେଦା ନେଆଁଁ ୟୀଶୁ ଆଟ୍‌କାର୍‍କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ୟୀଶୁ ଆୟାଃତେଗି କାଏ ବାପ୍ତିସ୍ମାକ ତାଇକେନା ମେନ୍‌ଦ ଇନିୟାଃ ଚେଲାକ ବାପ୍ତିସ୍ମା ଏମାକତାନ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ନେ ସବେନାଃ ଆଟ୍‌କାର୍‌କେଦ୍‌ଚି ଇନିଃ ଯିହୁଦା ଦିଶୁମ୍‌ ବାଗିକେଦାଏ ଆଡଃ ଗାଲିଲ୍‌ତେ ସେନ୍‌ରୁହାଡ଼୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ଆଡଃ ଇନିଃକେ ଶମିରୋନ୍ ଦିଶୁମ୍‌ ଥାଲା ଥାଲାତେ ସେନଃ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ଏନ୍ତେ ୟୀଶୁ ଶମିରୋନ୍‍ରେଆଃ ଶିଖର୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହାତୁତେ ସେଟେର୍‌ୟାନାଏ, ଏନା ଯାକୁବ୍‌ ଆୟାଃ ହନ୍‌ ଯୋଷେଫ୍‌କେ ଏମାକାଇ ଅତେ ଜାପାଃରେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ଏନ୍ତାଃରେ ଯାକୁବ୍‌ଆଃ କୁଆଁ ତାଇକେନା, ଆଡଃ ୟୀଶୁ ହରା ସେସେନ୍‍ତେ ଲାଗାୟାନ୍ତେ, କୁଆଁତାଃରେ ଦୁବ୍‌ୟାନାଏ । ଇମ୍‍ତାଦ ତିକିନ୍‌ସିଙ୍ଗି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଏନ୍ତେ ମିଆଁଦ୍‌ ଶମିରୋନ୍‍ରେନ୍‍ କୁଡ଼ି ଦାଆଃ ବୁରାଃତେ ହିଜୁଃୟାନାଏ, ଆଡଃ ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ନୁଁଏ ଦାଆଃ ଏମାଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ଇମ୍‌ତାଙ୍ଗ୍‌ ଇନିୟାଃ ଚେଲାକଦ ଜମେୟାଃଁ କିରିଙ୍ଗ୍‌ତେ ସାହାର୍‍ତେ ସେନାକାନ୍ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ଏନ୍‍ କୁଡ଼ି ୟୀଶୁକେ କାଜିକିୟାଏ, “ଆମ୍‌ ଯିହୁଦୀ ତାନ୍‌ମେ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଶମିରୋନ୍‍ରେନ୍‍ ତାନିଙ୍ଗ୍‌, ଆମ୍‌ ଚିଲ୍‍କାତେ ନୁଁଏ ଦାଆଃ ଆସି ଦାଡ଼ିତାନାମ୍‌ ?” ଚିୟାଃଚି ଯୀହୁଦିକଦ ଶମିରୋନି କଲଃ କାକ ମେସାଅଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଏନେମ୍‍ତେୟାଃ ଆଡଃ ଦାଆଃ ଆସିନିଃ ଅକଏ ତାନିଃ, ଏନାମ୍ ସାରିରେଦ, ଆମ୍‌ ଇନିଃକେ ଆସିତେୟାଃ ଆଡଃ ଇନିଃ ଆମ୍‌କେ ଜୀନିଦ୍‌ ଦାଆଃ ଏମାମ୍‍ତେୟାଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ଏନ୍‌ କୁଡ଼ି କାଜିକିୟାଏ, “ଗମ୍‌କେ, ଆମାଃତାଃରେ ବୁରାଃତେଆଃଦ ବାନଆଃ ଆଡଃ କୁଆଁଦ ଇକିରା, ଏନ୍‌ ଜୀନିଦ୍‌ ଦାଆଃ କତାଃଏତେମ୍ ନାମେୟା ? ");
INSERT INTO unx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ଚିୟାଃ ଆମ୍‌ ଆଲେୟାଃ ଆପୁ ଯାକୁବ୍‌ ଏତେ ମାରାଙ୍ଗ୍‌ଆଁମ୍‌ ? ଇନିଃ ନେ କୁଆଁ ଏମାଦ୍‍ଲେୟାଏ ଆଡଃ ଏନାଏତେ ଆଇଃକ୍‌ହଗି ନୁଁକେଦାଏଃ, ଏନ୍‌ଲେକା ଇନିୟାଃ ହନ୍‌ହପନ୍‌କ ଆଡଃ ଇନିୟାଃ ଉରିଃକ୍‌, ମେରମ୍‌କହଁ ନୁଁକେଦାଃକ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ନେ ଦାଆଃ ନୁଁଏନିଃକେ ତେତାଙ୍ଗ୍‌ ରୁହାଡ଼ିଆ, ");
INSERT INTO unx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଏମାଇ ଦାଆଃ ନୁଁଏ ହଡ଼ ଚିଉଲାହ କାଏ ତେତାଙ୍ଗଆଃ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଏମାଇ ଦାଆଃ ଇନିଃରେ ଜାନାଅ ଜୀଦାନ୍‌ ଜାକେଦ୍‌ ଲିଙ୍ଗିୟଅଃ ଦାଆଃରେୟାଃ କୁଆଁଦାଆଃ ବାଇୟଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ଏନ୍‌ କୁଡ଼ି କାଜିକିୟାଏ, “‘ହେ ଗମ୍‌କେ,’ ଆଇଙ୍ଗ୍‌କେ ଏନ୍‌ ଦାଆଃ ଏମାଇଙ୍ଗ୍‌ମେ, ଜେ'ଲେକାଚି ଆଇଙ୍ଗ୍‌ ଆଲକାଇଙ୍ଗ୍‌ ତେତାଙ୍ଗିଙ୍ଗ୍‌କାଃ, ଆଡଃ ଦାଆଃ ବୁରାଃନାଙ୍ଗ୍‌ ନେତାଃତେ ଆଲକାଇଙ୍ଗ୍‌ ହିଜୁଃକା ।” ");
INSERT INTO unx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ୟୀଶୁ ଇନିଃକେ ମେନ୍‌କିୟାଏ, “ଜୁ ଆମାଃ କଡ଼ାକେ କେଡ଼ାଇମେ,” ଆଡଃ “ନେତାଃ ହିଜୁଃବେନ୍‍ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ଏନ୍‌ କୁଡ଼ି ମେନ୍‌ରୁହାଡ଼ାଇୟାଏ, “ଆଇଁୟାଃ କଡ଼ା ବାଙ୍ଗାଇୟାଃ ।” ୟୀଶୁ ମେନ୍‌ରୁହାଡ଼ାଇୟାଏ, “ଆଇଁୟାଃ କଡ଼ା ବାଙ୍ଗାଇୟାଃ ମେନ୍ତେ ବୁଗିନାମ୍‌ କାଜିକେଦା, ");
INSERT INTO unx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ଆମ୍‌ଦ ମଣେୟାଁତାଃ ଅଡ଼ାଃୟାନାମ୍‌ ଆଡଃ ଆମାଃଲଃ ନାହାଁଃ ତାଇନ୍‍ତାନ୍‍ନିଃ ଆମାଃ କଡ଼ା ନାହାଁଲିଃ, ନେଆଁଁ ଆମ୍‌ ସାର୍‌ତିଗି କାଜିୟାକାଦାମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ଏନ୍‌ କୁଡ଼ି ମେନ୍‌କିୟାଏ, “ହେ ଗମ୍‌କେ, ଆମ୍‌ ନାବୀ ତାନ୍‌ମେ, ନେଆଁଁ ଆଇଙ୍ଗ୍‌ ନେଲ୍‌ଦାଡ଼ିତାନା । ");
INSERT INTO unx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“ଆଲେୟାଃ ହାଡ଼ାମ୍ ହଡ଼କ ନେ ବୁରୁରେ ପାର୍‍ମେଶ୍ୱାର୍‍ଆଃକ ସେୱା କେଦାଃ ମେନ୍‌ଦ ଆପେ ଯିହୁଦୀକ ମେନେତାନା, ଅକନ୍‌ ଜାଗାରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସେୱା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଏନା ଯୀରୁଶାଲେମ୍‌ରେ ମେନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଏ କୁଡ଼ି କାଜିତାଇୟାଁଃ ପାତିୟାରେମେଁ, ଏନ୍‍ ଦିପିଲି ହିଜୁଃଆ ଅକ ଦିପିଲିରେ ଆପେ ନେ ବୁରୁରେ ଚି ଯୀରୁଶାଲେମ୍‌ରେହଁ ଆପୁଆଃ କାପେ ସେୱା ରିକାଗିଆ । ");
INSERT INTO unx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ଆପେ ଶମିରୋନ୍‌ରେନ୍‌କ କା ସାରିନିଃକେପେ ସେୱାଇତାନା; ଆଲେ ଯିହୁଦୀକ ସାରିତାନ୍‍ନିଃକେ ସେୱାଇତାନାଲେ, ଚିୟାଃଚି ଜୀଉବାଞ୍ଚାଅନିଃ ଯୀହୁଦିକଏତେ ହିଜୁଃତାନା । ");
INSERT INTO unx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ମେନ୍‌ଦ ଦିପିଲି ହିଜୁଃଆ ଆଡଃ ନାହାଁଃ ସେଟେରାକାନା, ଏନାରେ ସାର୍‌ତି ସେୱାଇନିଃକ ଆତ୍ମା ଆଡଃ ସାନାର୍‍ତିତେ ଆପୁକେକ ସେୱାଇୟା, ଆପୁଦ ନେ ଲେକାନ୍ ସେୱାଇତାନ୍‍କକେ ନାମ୍‍ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ପାର୍‌ମେଶ୍ୱାର୍‌ ଆତ୍ମା ତାନିଃ ଆଡଃ ଇନିଃକେ ସେୱାଇତାନ୍‍କ ଆତ୍ମାରାଃ ପେଡ଼େଃତେ ଏସ୍‌କାର୍‌ ଆଡଃ ସାନାର୍‌ତିତେ ସେୱାଇ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ଏନ୍‌ କୁଡ଼ି ଇନିଃକେ ମେତାଇୟାଏ, “ଖ୍ରୀଷ୍ଟ୍‌ ନୁତୁମ୍‌ତାନ୍‍ ମାସି ହିଜୁଆଃଏ, ଏନାଇଙ୍ଗ୍‌ ସାରିତାନା, ଇନିଃ ହିଜୁଃକେଦ୍‍ତେ ସବେନାଃଏ ଉଦୁବାଲେୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ୟୀଶୁ ମେତାଇୟାଏ, “ଆଇଙ୍ଗ୍‌ ଇନିଃ ତାନିଙ୍ଗ୍‌, ଅକଏଚି ଆମାଃଲଃ ଜାଗାର୍‍ତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ଆଡଃ ଏନ୍‍ ଦିପିଲିରେ ଇନିୟାଃ ଚେଲାକ ହିଜୁଃୟାନା ଆଡଃ ଇନିଃ ମିଆଁଦ୍‌ କୁଡ଼ିଲଃ ଜାଗାର୍‌ତାନ୍‌ ନେଲ୍‍କେଦ୍‍ତେ ହାଏକାଟ୍‍ୟାନାକ । ଏନ୍‍ରେହ ଜେତାଏ ଆମ୍‌ ଚିକ୍‌ନାଃମ୍ ସାନାଙ୍ଗ୍‌ତାନା ଚାଏ ନିଃଲଃ ଚିନାଃ ମେନ୍ତେମ୍‍ ଜାଗାର୍‍ତାନା ମେନ୍ତେ ଜେତାଏ କାକ କୁଲିକିୟା । ");
INSERT INTO unx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ଏନ୍ତେ ଏନ୍‍ କୁଡ଼ି ଆୟାଃ ଚାଟୁ ବାଗିତୁକାକେଦ୍‌ତେ, ହାତୁତେ ସେନଃୟାନାଏ ଆଡଃ ଏନ୍ତାଃରେ ହଡ଼କକେ କାଜିୟାଦ୍‍କଆଏ, ");
INSERT INTO unx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ଏଲା ମିଆଁଦ୍‌ ହଡ଼ ନେଲିପେ, ଇନିଃ ଆଇଙ୍ଗ୍‌ କାମିକାଦ୍‌ ସବେନାଃ ଆଇଙ୍ଗ୍‌କେ ଉଦୁବାଦିଇୟାଁ, ଇଦୁ ଇନିଃ ମାସି ତାନିଃ ଚି କାହା ?” ");
INSERT INTO unx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ଇନ୍‌କୁ ସାହାର୍‌ଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ଏନ୍ତେ ଇନିୟାଃ ଚେଲାକ ବିନ୍ତିକେଦ୍‍ତେ କାଜିକିୟାଃକ, “ହେ ଗୁରୁ, ଜେତ୍‌ନାଃ କାଟିକାନ୍‌ ଜମେମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, “ଆପେ ଅକ ଜଜମ୍‍ ବିଷାଏରେ କାପେ ସାରିଆଃ, ଏନ୍‍ ଜମେୟାଃଁ ଆଇଁୟାଃତାଃରେୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ଏନ୍ତେ ଚେଲାକ ଆକ ଆକରେ ମେପେନ୍‍ୟାନାକ, “ଜେତାଏ ମିହୁଡ଼୍‌ ଇନିଃକେ ଜମେୟାଃଁ ଆଉୱାକାଇୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିକେଦ୍‍କଆଏ, “ଆଇଙ୍ଗ୍‌କେ କୁଲାକାନ୍‍ନିୟାଃ ମନେଲେକା ସେସେନ୍‍ ଆଡଃ ଇନିଃ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଇଙ୍ଗ୍‌ କାମି ଚାବାଏତେୟାଃ ଆଇଁୟାଃ ଜମେୟାଃଁ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ଚିୟାଃ ଆପେ ଚାର୍‍ ମାହିଁନା ତାୟମ୍‌ତେ ଇରୋଃ ତେବାଗାଃ ମେନ୍ତେ କାପେ କାଜିତାନା ? ହେରାକାନ୍‌ ପିଡ଼ିକେ ଆରିଦ୍‍ରାକାବେପେ ଏନା ଇରୋଃ ନାଗେନ୍ତେ ବିଲି ଚାବାକାନା ନେଆଁଁ ଆଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା । ");
INSERT INTO unx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ନାହାଁଃ ଜାକେଦ୍‌ ଇରୋଃନିଃ ନାଲା ନାମ୍‍ତାନାଏ, ଆଡଃ ଜାନାଅ ଜୀଦାନ୍‌ ନାଗେନ୍ତେ ଜ'ଆଏ ହୁଣ୍ଡିତାନା, ଜେ'ଲେକା ଏନାତେ ହେରଃନିଃ ଆଡଃ ଇରୋଃନିଃ ବାରାନ୍‍କିନ୍‌ ମିଦ୍‍ତେକିନ୍‌ ରାସ୍‌କାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ମିଆଁଦ୍‌ ହଡ଼ ହେରେତାନାଏ ଆଡଃ ଏଟାଃନିଃ ଇରେତାନାଏ, ନେ କାଜିଦ ସାର୍‌ତିଗିଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ଆପେ କାପେ କାମିୟାକାଦ୍‍ତେୟାଃ ଇରେ ନାଗେନ୍ତେଇଙ୍ଗ୍‌ କୁଲ୍‌କେଦ୍‍ପେୟା । ଏଟାଃକ କାମିୟାକାଦାଃ ଆଡଃ ଆପେ ଇନ୍‌କୁଆଃ କାମିରେ ଆଦାଏପେ ନାମାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ଆଡଃ ଏନ୍‌ ସାହାର୍‌ରେନ୍‌ ଶମିରୋନିକଏତେ ପୁରାଃ ହଡ଼କ ୟୀଶୁରେକ ବିଶ୍ୱାସ୍‌କେଦାଃ, ଚିୟାଃଚି ଏନ୍‍ କୁଡ଼ିଦ “ଇନିଃ ଆଇଙ୍ଗ୍‌ କାମିକାଦ୍‌ ସବେନାଃ ଆଇଙ୍ଗ୍‌କେ ଉଦୁବାଦିଇୟାଁ” ମେନ୍ତେ ଗାୱା ଏମ୍‍କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ଏନାମେନ୍ତେ ଶମିରୋନିରେନ୍ ଇନିଃତାଃ ହିଜୁଃଲେନ୍ତେ ଆମ୍‌ ଆଲେଲଃ ତାଇନ୍‍ମେ ମେନ୍ତେକ ବିନ୍ତିକିୟାଃ ଆଡଃ ଇନିଃ ଏନ୍ତାଃରେ ବାର୍‍ସିଙ୍ଗ୍‌ ତାଇନ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ଆଡଃ ଇନିୟାଃ କାଜି ନାଗେନ୍ତେ ଆଦ୍‌କା ହଡ଼କ ବିଶ୍ୱାସ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ଆଡଃ ଇନ୍‌କୁ ଏନ୍‍ କୁଡ଼ିକେ କାଜିକିୟାଃକ, “ନାହାଁଃଦ ଆମାଃ କାଜି ନାଗେନ୍ତେ କାଲେ ବିଶ୍ୱାସ୍‌ତାନା, ଚିୟାଃଚି ଆଲେଦ ନାହାଁଃ ଆୟୁମାକାଦାଲେ ଆଡଃ ନିଃ ସାର୍‌ତିଗି ଅତେଦିଶୁମ୍‌ରାଃ ଜୀଉବାଞ୍ଚାଅନିଃ ତାନିଃ ନେଆଁଲେ ସାରିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ଆଡଃ ବାର୍‌ସିଙ୍ଗ୍‌ ତାୟମ୍‌ତେ ୟୀଶୁ ଏନ୍ତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ଗାଲିଲ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ୟୀଶୁ ଆୟାଃତେଗି ଗାୱା ଏମ୍‍କେଦାଏ, “ନାବୀ ଆୟାଃ ଦିଶୁମ୍‌ରେ କାଏ ମାଇନଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ଇନିଃ ଗାଲିଲ୍‌ତେ ତେବାଃୟାନ୍‍ଚି, ଗାଲିଲ୍‍ରେନ୍‍କ ଇନିଃକେ ଦାରମ୍‍କିୟାଃ । ଇନ୍‍କୁଦ ଯୀରୁଶାଲେମ୍‌ରେଆଃ ପାରାବ୍‌ ଦିପିଲିରେ ଇନିଃ କାମିକେଦ୍ ସବେନାଃ ନେଲାକାଦ୍‍କ ତାଇକେନା, ଚିୟାଃଚି ଇନ୍‍କୁହ ପାରାବ୍‍ତେକ ସେନ୍‌କେନା । ");
INSERT INTO unx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ୟୀଶୁ ଆଡଃଗି ଗାଲିଲ୍‌ରେୟାଃ କାନା ହାତୁରେ ତେବାଃୟାନା, ଏନ୍ତାଃରେଦ ଇନିଃ ଦାଆଃକେ ଦାଖ୍‌ରାସି ବାଇୟାକାଦ୍‌ ତାଇକେନାଏ । ଆଡଃ ଏନ୍ତାଃରେ ମିଆଁଦ୍‌ ଗମ୍‌କେ ତାଇକେନାଏ, ଇନିୟାଃ ହନ୍‌ କପର୍‌ନାହୁମ୍‌ ସାହାର୍‌ରେ ଦୁକୁତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ଆଡଃ ୟୀଶୁ ଯିହୁଦା ଏତେ ଗାଲିଲ୍‌ତେ ହିଜୁଆକାନାଏ ମେନ୍ତେ ଇନିଃ ଆୟୁମ୍‌କେଦ୍‌ଚି ଇନିଃତାଃତେ ସେନଃୟାନାଏ, ଆଡଃ ଆମ୍‌ ହିଜୁଃକେଦ୍‍ତେ ଆଇଁୟାଃ ହନ୍‍କେ ବୁଗିମେ ମେନ୍ତେ ବିନ୍ତିକିୟାଏ, ଚିୟାଃଚି ଇନିଃଦ ଗଜଃଲେକାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆପେ ଚିହ୍ନାଁ ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମି କାପେ ନେଲେରେଦ କାପେ ବିଶ୍ୱାସେଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ଏନ୍‍ ଗମ୍‌କେ ମେତାଇୟାଏ, “ହେ ଗୁରୁ, ଆଇଁୟାଃ ହନ୍‌ ଗଜଃ ସିଦାରେ ହିଜୁଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ୟୀଶୁ ଇନିଃକେ ମେନ୍‌ରୁହାଡ଼ାଇୟାଏ, “ଜୁ, ସେନଃମେ, ଆମାଃ ହନ୍‌ ଜୀହୁଦଃଆଏ ।” ଏନ୍‌ ହଡ଼ ୟୀଶୁ କାଜିକାଇ କାଜିରେ ବିଶ୍ୱାସ୍‌କେଦ୍‍ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ଆଡଃ ଇନିଃ ସେନଃତାନ୍‌ ତାଇକେନ୍‌ରେ ଇନିୟାଃ ଦାସିକ ଇନିଃକେ ସେନ୍‍ଦାରମ୍‍କିୟାଃକ ଆଡଃ “ହନ୍‌ତାମାଃ ଜୀହୁଦ୍‌ୟାନାଏ” ମେନ୍ତେକ ଉଦୁବ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ଏନ୍ତେ ଇନିଃ ଅକ ଦିପିଲିରେ ବୁଗି ଏଟେଦ୍‌ୟାନାଏ ମେନ୍ତେ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‍କଆଏ । ଆଡଃ ଇନ୍‌କୁ ହଲା ହୁଡିଙ୍ଗ୍‌ ସିଙ୍ଗି ମିଦ୍‌ ଘାଣ୍ଟାରେ ଇନିୟାଃ ଉରିୟୁ ବାଗିକିୟାଏ ମେନ୍ତେ ଇନ୍‌କୁ କାଜିକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ଆଡଃ ହନ୍‍ତାମାଃ ଜୀହୁଦଃଆଏ ମେନ୍ତେ ୟୀଶୁ କାଜିୟାଇ ଦିପିଲିରେଗି ନେକାୟାନା ଏନା ଆପୁତେ ଆଟ୍‌କାର୍‍କେଦାଏ, ଏନ୍ତେ ଇନିଃ ଆଡଃ ଇନିୟାଃ ଅଡ଼ାଃରେନ୍‌କ ୟୀଶୁରେକ ବିଶ୍ୱାସ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ୟୀଶୁ ଯିହୁଦାଏତେ ଗାଲିଲ୍‌ରେ ହିଜୁଃୟାନ୍ତେ ନେଆଁଁ ବାର୍‌ସାତେ ପେଡ଼େୟାନ୍‌ କାମି କାମିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ନେଆଁଁ ତାୟମ୍‌ତେ, ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃୟାନାଏ, ଚିୟାଃଚି ଯିହୁଦୀକଆଃ ପାରାବ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଯୀରୁଶାଲେମ୍‌ରାଃ ମିଣ୍ଡି ଦୁଆର୍‌ ଜାପାଃରେ ମିଆଁଦ୍‌ ବାନ୍ଦା ମେନାଃ, ଏବ୍ରୀ କାଜିତେ ଏନାଦ ବେଥେସ୍‌ଦା ନୁତୁମଃତାନା । ଏନ୍‌ ବାନ୍ଦାରେ ମଣେୟାଁ ପିଣ୍ଡ୍‌ଗି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ଏନ୍ତାଃରେ ପୁରାଃ ଦୁକୁତାନ୍‍କ, କାଣାଁକ, ଛୁଟାକ ଆଡଃ ରହଡ଼ାକାନ୍‍କ ବାଟିଆକାନ୍‍ କେପା ତାଇକେନାକ । ଇନ୍‍କୁଦ ଦାଆଃ ହେଲତେଆଃ ନେଲ୍‍ହରାତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ଚିୟାଃଚି ମିସା ମିସାଦ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ବାନ୍ଦାରେ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ ଦାଆଃ ହେଲତାଇକେନାଏ ଆଡଃ ଦାଆଃ ହେଲୟାନ୍‌ ତାୟମ୍‌ତେ, ଅକଏ ସିଦାତେ ଏନାରେ ଆଡ଼୍‌ଗୁୟାନ୍‍ନିଃ ଇନିୟାଃ ସବେନ୍‌ ଦୁକୁଏତେ ବୁଗିଅଃତାନ୍‍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ଏନ୍ତାଃରେ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ, ଇନିଃ ହିସିଗେଲ୍‌ ଇରାଲିୟା ବାରାଷ୍‌ଏତେ ହାସୁତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ୟୀଶୁ ଇନିଃକେ ବାଟିଆକାନ୍‍ ନେଲ୍‌କିୟାଏ ଆଡଃ ଏନ୍‌ଲେକା ପୁରାଃ ମାହାଁ ହେତେ ମେନାଇୟା ଏନା ଆଟ୍‌କାର୍‍କେଦ୍‍ତେ, “ଚିୟାଃ ଆମ୍‌ ବୁଗିଅଃ ସାନାଙ୍ଗ୍‌ତାନାମ୍‌” ମେନ୍ତେ କୁଲିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ଏନ୍‌ ହାସୁତାନ୍‍ନିଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଗମ୍‌କେ, ଦାଆଃ ହେଲଃତାନ୍ ଇମ୍‌ତା ବାନ୍ଦାରେ ଆଡ଼୍‌ଗୁଇଙ୍ଗ୍‌ନିଃ ଜେତାଏ ବାଙ୍ଗ୍‌କୁଆ ଆଡଃ ଆଇଙ୍ଗ୍‌ ସେଟେର୍‍ ସିଦାରେ ଏଟାଃନିଃ ଆଡ଼୍‌ଗୁ ଆୟାରେନ୍‍ତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ୟୀଶୁ ଇନିଃକେ ମେତାଇୟାଏ, “ବିରିଦ୍‌ମେ, ପାର୍‌କମ୍‌ତାମାଃ ଗଅଃକେଦ୍‌ତେ ସେନଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ଆଡଃ ଇମ୍‍ତାଗି ଏନ୍‌ ହଡ଼ ବୁଗିୟାନାଏ ଆଡଃ ଆୟାଃ ପାର୍‌କମ୍‌ ଗଅଃକେଦ୍‌ତେ ସେନଃୟାନାଏ । ଏନା ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତାଇକେନା, ");
INSERT INTO unx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ଏନାମେନ୍ତେ ଯିହୁଦୀକ ବୁଗିଆକାନ୍‍ ହଡ଼କେ କାଜିକିୟାଃକ, “ତିସିଙ୍ଗ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତାନାଃ, ପାର୍‌କମ୍‌ ଗଅଃ ଆମ୍‌କେ କା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ମେନ୍‌ଦ ଇନିଃ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଆଇଙ୍ଗ୍‌କେ ବୁଗିକେଦ୍‍ନିଃ ପାର୍‌କମ୍‌ ଗଅଃକେଦ୍‌ତେ ସେନଃମେ ମେତାଦିୟାଁଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ କୁଲିକିୟାଃକ, “ପାର୍‌କମ୍‍ତାମାଃ ଗଅଃକେଦ୍‌ତେ ସେନଃମେ ମେତାଦ୍‍ମେ ହଡ଼ ଅକଏ ତାନିଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ମେନ୍‌ଦ ଏନ୍‌ ବୁଗିଆକାନ୍ ହଡ଼ ୟୀଶୁ ଅକଏ ତାନିଃ ନେଆଁଁ କାଏ ସାରିତାନ୍ ତାଇକେନା, ଏନ୍ତାଃରେ ଗାଦେଲ୍‌ ହଡ଼କ ତାଇକେନ୍‌ ହରାତେ ୟୀଶୁଦ ଦାନାଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ନେଆଁଁ ତାୟମ୍‌ତେ ୟୀଶୁ, ବୁଗିଆକାନ୍‌ ହଡ଼କେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ନାମ୍‍କିୟାଏ ଆଡଃ ମେତାଇୟାଏ, “ନେଲେମେ ଆମ୍‌ ବୁଗିଆକାନାମ୍‌, ଆଡଃ ଆଲମ୍‌ ପାପ୍‌ପେଆ କା'ରେଦ ନେଆଁଏତେ ଆଦ୍‌କା ଏତ୍‍କାନ୍ ଦୁକୁରେ ଉୟୁଗଃଆମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ଏନ୍‍ ହଡ଼ ସେନଃୟାନ୍ତେ, ଆଇଙ୍ଗ୍‌କେ ବୁଗିକେଦ୍‌ ହଡ଼ ୟୀଶୁ ତାନିଃ ମେନ୍ତେ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କକେ ଉଦୁବାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ଏନ୍ତେ ୟୀଶୁ ନେ କାମିକେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ କାମିକେଦ୍‌ ମେନ୍ତେ ଯିହୁଦୀକ ଇନିଃକେ ସାସାତିକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଆପୁଇଙ୍ଗ୍‌ ତାଇୟାଁଃ ଜାନାଅ କାମିତାନାଏ ଆଡଃ ଏନ୍‌ଲେକା ଆଇଙ୍ଗ୍‌ ହଗି କାମିତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ଏନ୍ତେ ଯିହୁଦୀକ ୟୀଶୁକେ ପୁରାଃଗି ଗଗଏଃ ସାନାଙ୍ଗ୍‌କେଦାକ, ଚିୟାଃଚି ୟୀଶୁ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌କେ କାଏ ମାନାତିଙ୍ଗ୍‌କେଦାଃ, ଆଡଃ ନେଆଁଁ ନାଗେନ୍ତେ ଏସ୍‍କାର୍‌ କାହା, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଇନିଃ ଆୟାଃ ଆପୁ ମେନ୍‍କେଦାଏ ଆଡଃ ଆପାନ୍‌କେ ପାର୍‍ମେଶ୍ୱାର୍‌ଲଃ ଜକା କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ଏନ୍ତେ ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ହନ୍‌ ଆୟାଃତେ ଜେତ୍‌ନାଃ କାଏ କାମିଦାଡ଼ିୟାଃ, ଆପୁକେ କାମିକେଦ୍‍ତେୟାଃ ନେଲ୍‌କିଃତେ ଏନା ଏସ୍‍କାର୍ ଇନିଃ କାମିୟାଏ, ଆପୁ କାମିକାଦ୍‍ ସବେନ୍‌ କାମିକ ହନ୍‍ହ ଏନାଲେକାଗି କାମିକାଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ଚିୟାଃଚି ଆପୁଦ ହନ୍‍କେ ଦୁଲାଡ଼ିତାନାଏ ଆଡଃ ଇନିଃ ଆୟାଃ କାମିକାଦ୍ ସବେନାଃ ଉଦୁବାଇତାନାଏ ଆଡଃ ଆପେ ଚିଲ୍‍କା ହାଏକାଟଆଃ ଏନାମେନ୍ତେ ନେଆଁଁଏତେ ଆଡଃ ମାରାଙ୍ଗ୍‌ କାମି ଉଦୁବାଇୟା । ");
INSERT INTO unx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ଆପୁ ଜେ'ଲେକା ଗଜାକାନ୍‍କକେ ଜୀଉବିରିଦ୍‌କେଦ୍‌ତେ ଜୀଦାନ୍‌ ଏମାଃଏ ଏନ୍‌ଲେକା ହନ୍‌ହଗି ଆୟାଃ ସାନାଙ୍ଗ୍‌ତାନ୍‍କକେ ଜୀଦାନ୍‍ ଏମାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ଆଡଃ ଆପୁଦ ଆଇଃକ୍‌ଗି ଜେତାଏକେ କାଏ ବିଚାର୍‌କଆ ମେନ୍‌ଦ ଗଟାବିଚାର୍‍ ନାଗେନ୍ତେ ଇନିଃ ଆୟାଃ ହନ୍‍କେ ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ନେଆଁଁମେନ୍ତେ ସବେନ୍‌କ ଆପୁକେ ମାଇନିତାନ୍‍ଲେକା ହନ୍‍କେହ ମାଇନିଆକ । ହନ୍‍କେ କାଏ ମାଇନିନିଃ କୁଲାକାଇ ଆପୁକେ ହଗି କାଏ ମାଇନିଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆଇଁୟାଃ କାଜି ଆୟୁମ୍‍ତାନ୍‍ ଆଡଃ ଆଇଁୟାଃ କୁଲ୍‍ନିଃରେ ବିଶ୍ୱାସ୍‌ତାନ୍‍ ହଡ଼ ଜାନାଅ ଜୀଦାନ୍‍ ନାମାକାଦାଃଏ ଆଡଃ ଇନିଃ କାଏ ବିଚାର୍‌ଆଃ; ମେନ୍‌ଦ ଇନିଃ ଗନଏଃ ଏତେ ଜୀଦାନ୍‌ରେ ପାରମ୍‌ ସେଟେର୍‍କାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌ ଏନ୍‌ ଦିପିଲି ହିଜୁଃଆ, ନାହାଁଃ ହଗି ହିଜୁଆକାନା, ଏନାରେ ଗଜାକାନ୍‍କ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‍ଆଃ ସାଡ଼ିକ ଆୟୁମେୟା ଆଡଃ ଆୟୁମେକ ଜୀହିଦଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ଆପୁଦ ଆୟାଃତେଗି ଜୀହିଦଃତାନ୍‍ ଲେକା, ହନ୍‍କେ ହଗି ଆୟାଃତେଗି ଜୀହିଦଃରେୟାଃ ପେଡ଼େଃ ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ଆଡଃ ଇନିଃ ମାନୱାହନ୍‌ ତାନିଃ ମେନ୍ତେ ଇନିଃକେ ବିଚାର୍‌ରେୟା ପେଡ଼େଃ ଏମାକାଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ନେଆଁଁତେ ଆଲ୍‌ପେ ହାଏକାଟଆଃ, ଏନ୍‌ ଦିପିଲିଦ ହିଜୁଃଆ ଏନାରେ ସବେନ୍‌ ତପାକାନ୍‍କ ଇନିୟାଃ ସାଡ଼ିକ ଆୟୁମେୟା ");
INSERT INTO unx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ଆଡଃ ଇନ୍‌କୁ ତପାକାନ୍‍ଏତେ ଅଡଙ୍ଗ୍‌ଆଁକ, ବୁଗିନ୍‌ଆଃ କାମିକାଦ୍‌କ ଜୀଦାନ୍‌ ନାମେ ନାଗେନ୍ତେ ଆଡଃ ଏତ୍‍କାନାଃ କାମିକାଦ୍‌କ ବିଚାର୍‌ରେୟାଃ ସାଜାଇ ନାମେ ନାଗେନ୍ତେ ଇନ୍‌କୁଆଃ ଜୀଉବିନିରିଦ୍‌ ହବାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ପେଡ଼େଃତେ ଜେତ୍‌ନାଃ କାଇଙ୍ଗ୍‌ କାମିଦାଡ଼ିୟାଃ, ଆଇଙ୍ଗ୍‌କେ ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିତାନ୍‍ ଲେକାଗିଇଙ୍ଗ୍‌ ବିଚାରେତାନା ଆଡଃ ଆଇଁୟାଃ ବିଚାର୍‌ ସାର୍‍ତିଗିଆଃ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ଆଇଁୟାଃ ମନେଲେକା କାହା ମେନ୍‌ଦ କୁଲାକାନ୍‍ନିୟାଃ ମନେଲେକା ସେସେନ୍ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଗାୱା କାଜିରେଦ ଆଇଁୟାଃ ଗାୱା କା ସାର୍‌ତିୱାଃ । ");
INSERT INTO unx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ଆଇଁୟାଃ ଗାୱା ପେରେଃନିଃ ଏଟାଃ ତାନିଃ ଆଡଃ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଇନିଃ ଏମେତାନ୍ ଗାୱା ସାର୍‌ତିଗିଆଃ ନେଆଁଇଙ୍ଗ୍‌ ଇତୁଆନ୍‍ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ଆପେ ଯୋହାନ୍‌ତାଃତେ ହଡ଼କକେ କୁଲ୍‍କେଦ୍‍କଆ ଆଡଃ ଇନିଃ ସାନାର୍‌ତିରେଆ ଗାୱା ଏମ୍‌କେଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ଆଇଙ୍ଗ୍‌କେ ହଡ଼ସାଃଏତେ ଗାୱା କା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ମେନ୍‌ଦ ଆପେୟାଃ ବାଞ୍ଚାଅଃ ନାଗେନ୍ତେଦ ନେ ସବେନାଃ କାଜିତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଯୋହାନ୍‌ ଜୁଲଃତାନ୍‍ ଆଡଃ ମାସ୍କାଲେତାନ୍‍ ଦିମି ତାଇକେନାଏ, ଆଡଃ ଆପେକେ ଇନିୟାଃ ମାର୍ସାଲ୍‍ରେ ଘାଡ଼ିକାଦ୍ ରାସ୍‍କା ସାନାଙ୍ଗ୍‌ ଲେଦ୍‍ପେୟା । ");
INSERT INTO unx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ମେନ୍‌ଦ ଯୋହାନ୍‌ଆଃ ଗାୱାଏତେ ମାରାଙ୍ଗ୍‌ ଗାୱା ଆଇଁୟାଃତାଃରେୟା, ଚିଆଃଚି ଆପୁଇଙ୍ଗ୍‌ ଏମାକାଦ୍ କାମିକକେ ଚାବାଏ ନାଗେନ୍ତେ ଏମାକାଦିୟାଁଏ, ଆଇଙ୍ଗ୍‌ ଅକନ୍‌ କାମିକ ରିକାତାନାଇଁଙ୍ଗ୍‌ ଏନ୍‌ସବେନାଃ ଆପୁଇଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଃଁଏ ଏନାରେୟାଃ ଗାୱା ଏମେତାନା । ");
INSERT INTO unx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ଆଡଃ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦ୍ ଆପୁ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଗାୱା ଏମେତାନାଏ, ଆପେ ଇନିୟାଃ ସାଡ଼ି ଚିଉଲାହଗି କାପେ ଆୟୁମାକାଦାଃ ଆଡଃ ଇନିୟାଃ ମେଦ୍‍ମୁହାଁଡ଼୍‌ କାପେ ନେଲାକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ଆଡଃ ଇନିୟାଃ କାଜି ଆପେରେ କା ତାଇନ୍‍ତାନା, ଚିୟାଃଚି ଆପେଦ ଇନିଃ କୁଲାକାଇନିଃରେ କାପେ ବିଶ୍ୱାସ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ଆପେ ଧାରାମ୍‌ପୁଥିରେ ଦାଣାଁଁଏ ତାନାପେ, ଚିୟାଃଚି ଆପେଦ ଏନାରେ ଜାନାଅ ଜୀଦାନ୍‌ବୁ ନାମେୟା ମେନ୍ତେପେ ଆଟ୍‌କାରେତାନା । ଆଡଃ ଏନାଗି ଆଇଁୟାଃ ଗାୱା ଏମେତାନା । ");
INSERT INTO unx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ମେନ୍‌ଦ ଜୀଦାନ୍‌ ନାମ୍‌ ନାଗେନ୍ତେ ଆପେକେ ଆଇଁୟାଃତାଃତେ ହିଜୁଃ କା ସାନାଙ୍ଗ୍‌କେଦ୍‍ପେୟା । ");
INSERT INTO unx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ଆଇଙ୍ଗ୍‌ ହଡ଼କତାଃ ଏତେ ମାଇନ୍ କାଇଙ୍ଗ୍‌ ନାମେତାନା, ");
INSERT INTO unx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ମେନ୍‌ଦ ଆପେ ଚିଲ୍‍କାନ୍ ହଡ଼ ତାନ୍‌ପେ ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାରିତାନାଇଙ୍ଗ୍‌, ଚିୟାଃଚି ଆପେୟାଃ ମନ୍‍ରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦୁଲାଡ଼୍‌ ବାନଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ଆଇଙ୍ଗ୍‌ ଆପୁଆଃ ନୁତୁମ୍‌ତେଗି ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ଆଡଃ ଆପେ କାପେ ଦାରମ୍‍ତାନା, ଏଟାଃନିଃ ଆୟାଃ ନୁତୁମ୍‌ତେଗି ହିଜୁଃରେଦ ଇନିଃକେ ଆପେ ଦାରମିୟା । ");
INSERT INTO unx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ଆପେ ମିଆଁଦ୍‌ନିଃ ଏଟାଃନିଃଏତେ ମାଇନ୍‍ପେ ନାମ୍‍ତାନା ଆଡଃ ଏନ୍‍ ମିଆଁଦ୍‌ଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଏତେ ହିଜୁଃତାନ୍‍ ମାଇନ୍‍ କାପେ ଦାଣାଁଁଏତାନା, ଏନ୍ତେଦ ଚିଲ୍‍କାତେପେ ବିଶ୍ୱାସ୍‌ଦାଡ଼ିୟାଃ ? ");
INSERT INTO unx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ଆଇଙ୍ଗ୍‌ ଆପୁଆଃ ଆୟାର୍‌ରେ ଚିଟାପେୟା ଏନ୍‌ଲେକା ଆଲ୍‌ପେ ଆଟ୍‌କାରେୟା, ଆପେ ଅକନ୍‌ ମୁଶାରେ ଆସ୍ରାଏତାନାପେ ଇନିଃଗି ଆପେୟାଃ ଚିଟାନିଃ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ଆପେ ମୁଶାରେପେ ବିଶ୍ୱାସେରେଦ ଆଇଙ୍ଗ୍‌ରେ ହଗି ବିଶ୍ୱାସେତେଆଃ, ଚିୟାଃଚି ଇନିଃଦ ଆଇଁୟାଃ ବିଷାଏରେ ଅଲ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ମେନ୍‌ଦ ଆପେ ମୁଶାରାଃ ଅନଲ୍‌ରେ କାପେ ବିଶ୍ୱାସେରେଦ, ଚିଲ୍‍କାକେଦ୍‍ତେ ଆଇଁୟାଃ କାଜିରେପେ ବିଶ୍ୱାସେଆ ?” ");
INSERT INTO unx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ଏନା ତାୟମ୍‌ତେ ୟୀଶୁ ଗାଲିଲ୍‌ ଚାଏ ତିବିରିୟା ଦରେୟା ହାନ୍‌ ପାରମ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ଆଡଃ ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟାଃକ, ଚିୟାଃଚି ଇନ୍‍କୁଦ ହାସୁତାନ୍ କରେ ଇନିଃ କାମିକେଦ୍‌ ଚିହ୍ନାଁକ ନେଲ୍‍କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ଆଡଃ ୟୀଶୁ ବୁରୁ ଚେତାନ୍‌ରେ ଦେଏଃୟାନ୍ତେ ଏନ୍ତାଃରେ ଆୟାଃ ଚେଲାକଲଃ ଦୁବ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ଆଡଃ ଯିହୁଦୀକଆଃ ପାସ୍‌କା ପାରାବ୍‌ ନାଡ଼େଃଜାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ଆଡଃ ୟୀଶୁ ଆରିଦ୍‍କେଦ୍‍ତେ, ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ଆୟାଃତାଃତେ ହିଜୁଃତାନ୍‌ ନେଲ୍‍କେଦ୍‍କଆଏ, ଆଡଃ ଇନିଃ ଫିଲିପ୍‌କେ କାଜିକିୟାଏ, “ନିକୁଆଃ ଜମେ ନାଗେନ୍ତେ ପୁରାଃ ହଲଙ୍ଗ୍‌ କତାଃଏତେବୁ କିରିଙ୍ଗ୍‌ୟେଁଆ ?” ");
INSERT INTO unx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ମେନ୍‌ଦ ଇନିଃ ଫିଲିପ୍‍କେ ଆଟ୍‌କାରି ନାଗେନ୍ତେ ନେଆଁଁ କାଜିକିୟାଏ, ଇନିଃଦ ଚିକ୍‌ନାଃଇଙ୍ଗ୍‌ ଚିକାୟା ଏନା ଆଇଃକ୍‌ଗି ସାରିତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ଫିଲିପ୍‌ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ମିଆଁଦ୍‌ନିଃ ହୁଡିଙ୍ଗ୍‌ଲେକାଏ ଜମେରେୟଗି, ହଲଙ୍ଗ୍‌ ପୁରାଅଃନାଙ୍ଗ୍‌ ୨୦୦ ରୁପାରାଃ ସିକାତେ ହଲଙ୍ଗ୍‌ କିରିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ଏନ୍ତେ ଚେଲାକଏତେ ମିଆଁଦ୍‌ନିଃ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ରାଃ ହାଗାତେ ଆନ୍ଦ୍ରିୟ ଇନିଃକେ ମେନ୍‌କିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ନେତାଃରେ ମିଆଁଦ୍‌ ସେପେଡ଼େଦ୍‍ ମେନାଇୟା, ଇନିଃତାଃରେ ମଣେୟାଁ ଗହମ୍‌ରାଃ ହଲଙ୍ଗ୍‌ ଆଡଃ ବାରିଆ ହାକୁ ମେନାଃ, ମେନ୍‌ଦ ନେଆଁଁ ନିମିନାଙ୍ଗ୍‌ ହଡ଼କ ନାଗେନ୍ତେ କା ହବାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ୟୀଶୁ ଚେଲାକକେ କାଜିୟାଦ୍‍କଆଏ, “ହଡ଼କକେ ଦୁବ୍‍କପେ,” ଏନ୍ତାଃରେ ପୁରାଃ ତାସାଦ୍‌ ତାଇକେନା, ଆଡଃ ସବେନ୍‌ ହଡ଼କ ଦୁବ୍‍ୟାନାକ, ଇନ୍‌କୁଦ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ କଡ଼ାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ୟୀଶୁ ହଲଙ୍ଗ୍‌କେ ସାବ୍‌କେଦାଏ ଆଡଃ ବିନ୍ତିକେଦ୍‍ତେ ଦୁବାକାନ୍‍କକେ ହାଟିଙ୍ଗ୍‌ଆଁଦ୍‍କଆଏ, ଏନ୍‍ଲେକାଗି ହାକୁକେହ ଇନ୍‌କୁକେ ଏମାଦ୍‍କଆଏ, ଆଡଃ ଇନ୍‌କୁ ଆକଆଃ ସାନାଙ୍ଗ୍‌ ଲେକା ଜମ୍‌କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ଆଡଃ ଇନ୍‌କୁ ବି'ୟାନାକ, ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‍କଆଏ, “ସାରେଜାକାନ୍ କେଚାଃକ ହୁଣ୍ଡିପେ, ଜେତ୍‌ନାଃ ଆଲକା ନକ୍‌ସାନଃକା ।” ");
INSERT INTO unx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ଏନ୍ତେ ଇନ୍‌କୁ ଏନ୍‌ କେଚାଃ ହଲଙ୍ଗ୍‌ ହୁଣ୍ଡିକେଦାଃକ ଆଡଃ ହଡ଼କ ଏନ୍‌ ମଣେୟାଁ ଗହମ୍‌ ହଲଙ୍ଗ୍‌ରେୟାଃ କେଚାଃଏତେ ବିଇକେଦ୍‍ତେ, ସାରେଜାକାନ୍‌ କେଚାଃଏତେ ବାରା ଟୁଙ୍କିକ ପେରେଃକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଏନ୍ତାଃରେ ତାଇକେନ୍‌ ହଡ଼କ ୟୀଶୁ କାମିକେଦ୍‌ ନେ ଚିହ୍ନାଁ ନେଲ୍‍କେଦ୍‍ତେ ମେନ୍‍କେଦାଃ, “ସାର୍‌ତିଗି ଅତେଦିଶୁମ୍‌ରେ ହିଜୁଃତାନ୍‍ ନାବୀ ନିଃ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ଇନ୍‌କୁ ହିଜୁଆଃକ ଆଡଃ ସାବ୍‌କେଦ୍‌ତେ ରାଜାଇୟାଁକ ନେଆଁଁ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ, ୟୀଶୁ ଆଇଃକ୍‌ ଏସ୍‍କାର୍‍ଗି ବୁରୁତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆୟୁବ୍‌ୟାନ୍‌ଚି ୟୀଶୁଆଃ ଚେଲାକ ଦରେୟା ଗେନାତେକ ଆଡ଼୍‌ଗୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ଆଡଃ ଇନ୍‌କୁ ଲାଉକାରେ ଦେଏଃୟାନ୍ତେ ଦରେୟା ହାନ୍‌ ପାରମ୍‍ କପର୍‌ନାହୁମ୍‌ସାଃତେକ ସେନଃତାନ୍‍ ତାଇକେନା । ଇମ୍‌ତାଲଃ ନୁବାଗାକାନ୍‌ ତାଇକେନା ଆଡଃ ୟୀଶୁ ଇନ୍‍କୁତାଃ କାଏ ହିଜୁଃକାନ୍‍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ହୟ ହୟକେଦ୍‌ତେ ଦରେୟା ଆଲ୍‌ପୁଙ୍ଗ୍‌ତେ ଏକ୍‌ଲାଅଃତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ଇନ୍‌କୁ ପାଞ୍ଚ୍‌ ଚାହେ ଛ କିଲୋମିଟର୍‌ ଲାଉକା ଇଦିକେଦ୍‍ଚି, ୟୀଶୁକେ ଦରେୟାରେ ସେସେନ୍‍ତାନ୍ ଆଡଃ ଲାଉକା ନାଡ଼େଃତେ ହିଜୁଃତାନ୍‍ ନେଲ୍‍କେଦ୍‍ତେ ବରକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, “ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ ଆଲ୍‌ପେ ବରଏୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଲାଉକାରେ ରାକାବ୍‌ନାଙ୍ଗ୍‌ ସୁକୁୟାନାକ ଆଡଃ ଇମ୍‍ତାଗି ଇନ୍‌କୁ ସେନଃତାନ୍‌ ଠାୟାଦ୍‌ତେ ଲାଉକା ସେଟେର୍‍ୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଦରେୟା ହାନ୍‌ ପାରମ୍‌ରେ ତିଙ୍ଗୁଆକାନ୍‌ ହଡ଼କ ନେଆଁଁ ନେଲ୍‌ କେଦାକ, ଏନ୍ତାଃରେ ମିଆଁଦ୍‌ ଲାଉକା ବାଗିକେଦ୍‌ତେ ଆଡଃ ଏଟାଃ ଲାଉକା କା ତାଇକେନା ଆଡଃ ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ଲାଉକାରେ କାଏ ବଲୟାନା ମେନ୍‌ଦ ଇନିୟାଃ ଚେଲାକ ଏସ୍‍କାର୍ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ମେନ୍‌ଦ ପ୍ରାଭୁ ଧାନ୍ୟାବାଦ୍‌ ଏମ୍‌କେଦ୍‌ଚି ଇନ୍‌କୁ ହଲଙ୍ଗ୍‌ ଜମ୍‌କେଦ୍ ଠାୟାଦ୍ ନାଡ଼େଃ ତିବିରିୟାଏତେ ଆଡଃଚିମିନ୍‌ ଲାଉକା ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ଏନ୍ତେ ଗାଦେଲ୍‌ ହଡ଼କ ୟୀଶୁ ନେତାଃରେ ବାଙ୍ଗାଇୟାଃ ଆଡଃ ଇନିୟାଃ ଚେଲାକହ ବାଙ୍ଗ୍‌କଆ ନେଆଁଁ ନେଲ୍‍କେଦ୍‍ତେ, ଆକଗି ଲାଉକାରେ ଦେଏଃୟାନ୍ତେ ୟୀଶୁକେ ଦାଣାଁଁଇତାନ୍‍ଲଃ କପର୍‌ନାହୁମ୍‌ତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ହଡ଼କ ୟୀଶୁକେ ଦରେୟା ହାନ୍‍ ପାରମ୍‌ରେ ନାମ୍‍କିଃତେ କୁଲିକିୟାକ, “ହେ ଗୁରୁ, ଆମ୍‌ ନେତେ ଚିମ୍‍ତାମ୍ ହିଜୁଃୟାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆପେ ଚିହ୍ନାଁ ନେଲ୍‍କେଦ୍‍ତେ କା ମେନ୍‌ଦ ହଲଙ୍ଗ୍‌ପେ ଜମ୍‍କେଦାଃ ଆଡଃପେ ବିଇୟାନା ଏନାମେନ୍ତେପେ ଦାଣାଁଁଇଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ଜିୟନଃ ଜମେୟାଃଁ ନାଗେନ୍ତେ ଆଲ୍‌ପେ କାମିୟା ମେନ୍‌ଦ ଜାନାଅ ଜୀଦାନ୍‌ ଜାକେଦ୍‌ ତାଇନଃ ଜମେୟାଃଁ ନାଗେନ୍ତେ କାମିପେ, ଏନା ମାନୱାହନ୍‌ ଏମାପେୟାଏ । ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପୁଦ, ଇନିଃତାଃରେ ଆୟାଃ ମୋହର୍‌ ଏମାକାଦାଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ଇନ୍‌କୁ ମେନ୍‌ରୁହାଡ଼ାଇୟା, “ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଲେତେ ସାନାଙ୍ଗ୍‌ତାନ୍‌ କାମି କାମିନାଗେନ୍ତେ ଚିନାଃଲେ ଚିକାୟା ?” ");
INSERT INTO unx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କୁଲାକାନ୍‌ନିଃରେ ବିଶ୍ୱାସେପେ, ନେଆଁଁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାମି ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ଏନ୍ତେ ଇନ୍‌କୁ କୁଲିକିୟାକ, “ଆମାଃତାଃରେ ଆଲେ ବିଶ୍ୱାସେ ନାଗେନ୍ତେ, ଅକ ଚିହ୍ନାଁମ୍‍ ଉଦୁବେତାନା ? ଆମାଃ ଚିକାନ୍‌ କାମିତେଲେ ବିଶ୍ୱାସ୍‍ ଦାଡ଼ିୟାଃ ? ");
INSERT INTO unx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ଆଲେୟାଃ ହାଡ଼ାମ୍‍ ହଡ଼କ ବିର୍‍ରେ ମାନ୍ନାକ ଜମ୍‍କେଦାଃ, ଧାରାମ୍‌ପୁଥିରେ ନେଆଁଁ ଅଲାକାନା, ‘ଇନିଃ ଜମ୍‍ ନାଗେନ୍ତେ ସିର୍ମାଏତେ ହଲଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ଏମାଦ୍‍କଆଏ ।’” ");
INSERT INTO unx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ଏନ୍ତେ ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ସାର୍‍ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ମୁଶା ଆପେକେ ହଲଙ୍ଗ୍‌ ଏମାଦ୍‌ପେତେୟାଃ, ସିର୍ମାଏତେ ହିଜୁଆକାନ୍‌ ହଲଙ୍ଗ୍‌ କା ତାଇକେନା, ମେନ୍‌ଦ ଆପୁଇଙ୍ଗ୍‌ ସିର୍ମାଏତେ ସାର୍‌ତି ହଲଙ୍ଗ୍‌ ଏମାପେତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁୟାନ୍‍ ଆଡଃ ଅତେଦିଶୁମ୍‌କେ ଜୀଦାନ୍‌ ଏମେତାନ୍ ହଲଙ୍ଗ୍‌ ଦ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହଲଙ୍ଗ୍‌ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ଇନ୍‌କୁ ୟୀଶୁକେକ କାଜିକିୟା, “ହେ ପ୍ରାଭୁ, ଏନ୍‍ ହଲଙ୍ଗ୍‌ ଆଲେକେ ସବେନ୍‌ଇମ୍‌ତା ଏମାଲେମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, “ଜୀଦାନ୍‌ ହଲଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌ ଆଇଁୟାଃତାଃ ହିଜୁଃନିଃ ଚିଉଲାହ କାଏ ରେଙ୍ଗେଜଆଃ ଆଡଃ ଆଇଙ୍ଗ୍‌ରେ ବିଶ୍ୱାସେନିଃ ଚିଉଲାହ କାଏ ତେତାଙ୍ଗଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ମେନ୍‌ଦ ଆପେ ଆଇଙ୍ଗ୍‌କେ ନେଲ୍‍କେଦିଙ୍ଗ୍‌ ରେୟ କାପେ ବିଶ୍ୱାସ୍‌ତାନା ମେନ୍ତେଇଙ୍ଗ୍‌ କାଜିୟାପେ ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ଆପୁ ଏମାକାଇଙ୍ଗ୍‌ ସବେନ୍‌କ ଆଇଁୟାଃତାଃତେକ ହିଜୁଃଆ, ଆଡଃ ଆଇଁୟାଃତାଃ ହିଜୁଃନିଃକେ ଜେତାଲେକାତେ କାଇଙ୍ଗ୍‌ ଅଡଙ୍ଗ୍‌ଇଁୟା । ");
INSERT INTO unx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଦ ଆଇଁୟାଃ ମନେଲେକା କାମି ନାଗେନ୍ତେ କାହା ମେନ୍‌ଦ କୁଲ୍‌ନିୟାଃ ସାନାଙ୍ଗ୍‌କେ ପୁରାଏ ନାଗେନ୍ତେ ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁଆ କାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ଆଡଃ ଅକନ୍‌କକେ ଇନିଃ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଦିଙ୍ଗ୍‌ୟାଁ ଇନ୍‌କୁଏତେ ମିହୁଡ଼୍‌କେହଁ କା ଆଦ୍‌କେଦ୍‌ତେ ଟୁଣ୍ଡୁ ହୁଲାଙ୍ଗ୍‌ରେ ଏନ୍‌ ସବେନ୍‌କକେ ଜୀଉବିରିଦ୍‌କଆଇଙ୍ଗ୍‌, ନେଆଁଗି ଇନିୟାଃ ଇଛାସାନାଙ୍ଗ୍‌ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ଚିଆଃଚି ହଡ଼କ ହନ୍‍କେ ନେଲ୍‍କେଦ୍‌ତେ ଇନିଃତାଃରେକ ବିଶ୍ୱାସେଆ, ଆଡଃ ଇନ୍‌କୁ ଜେ'ଲେକା ଜାନାଅ ଜୀଦାନ୍‌କ ନାମେଆ, ନେଆଁଗି ଆପୁଇଁୟାଃ ଇଛାସାନାଙ୍ଗ୍‌ ତାନାଃ । ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ଟୁଣ୍ଡୁ ହୁଲାଙ୍ଗ୍‌ରେ ଜୀଉବିରିଦ୍‌କଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ଯିହୁଦୀକ ୟୀଶୁଆଃ ବିଷାଏରେ ନଗମ୍‍ତଗମ୍‌ତାନ୍‍କ ତାଇକେନା, ଚିୟାଃଚି ଇନିଃଦ “ଆଇଙ୍ଗ୍‌ ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁଆକାନ୍‌ ହଲଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌” ମେନ୍‍କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ଏନ୍ତେ ଇନ୍‌କୁ କାଜିକେଦା, “ଚିୟାଃ ନିଃ ଯୋଷେଫ୍‌ ହନ୍ତେକଡ଼ା ୟୀଶୁ ନାହାଲିଃ ? ଆବୁ ଇନିୟାଃ ଏଙ୍ଗା ଆପୁକିନ୍‌କେ ସାରିୟାଃବୁ, ଇନିଃ ସିର୍ମାହେତେ ଆଡ଼୍‌ଗୁଆକାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ ନାହାଁଃ ଚିନାଃମେନ୍ତେ କାଜିତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଆପେ ଆପେରେ ଆଲ୍‌ପେ ନଗମ୍‍ତଗମ୍‍ଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ଆଇଙ୍ଗ୍‌କେ କୁଲାକାନ୍ ଆପୁ କାଏ ଥାଇଜ୍‌ରେଦ ଜେତାଏ ଆଇଁୟାଃତାଃ କାଏ ହିଜୁଃଦାଡ଼ିୟାଃ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ତାୟମ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଜୀଉ ବିରିଦିୟା । ");
INSERT INTO unx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ନାବୀକଆଃ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ଏସ୍‌କାର୍‌ ସବେନ୍‌କ ଇତୁନାଃକ ।’ ଆଇଁୟାଃ ଆପୁତାଃଏତେ ଆୟୁମାକାଦ୍ ଆଡଃ ଇତୁଆକାଦ୍ ସବେନ୍‌ ହଡ଼କ, ଆଇଁୟାଃତାଃତେକ ହିଜୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ଜେତାଏ ଆପୁକେ କାଏ ନେଲାକାଇୟାଃ, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ହିଜୁଆକାନ୍‍ନିଃ ଏସ୍‍କାର୍‌ ଆପୁକେ ନେଲାକାଇୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ବିଶ୍ୱାସେନିଃ ଜାନାଅ ଜୀଦାନ୍‌ ନାମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ଜୀଦାନ୍‌ ହଲଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ଆପେୟାଃ ହାଡ଼ାମ୍‍ ହଡ଼କ ବିର୍‍ରେ ଏନ୍‌ ମାନ୍ନାକ ଜମ୍‍କେଦା, ଏନ୍‌ରେହ ଗଏଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ମେନ୍‌ଦ ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁଆକାନ୍‌ ହଲଙ୍ଗ୍‌ ନେଆଁଁ ତାନାଃ, ଏନା ଜମେନିଃ କାଏ ଗଜଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁଆକାନ୍‌ ଜୀଦାନ୍‌ ହଲଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌, ନେ ହଲଙ୍ଗ୍‌ ଜେତାଏ ଜମେରେଦ ଜାନାଅ ଜାନାଅ ଜାକେଦ୍‌ ଜୀହିଦଃଆଏ । ହେଗି ଆଇଙ୍ଗ୍‌ ଏମେ ହଲଙ୍ଗ୍‌ ଆଇଁୟାଃ ମାସ୍ ତାନାଃ, ଏନା ଅତେଦିଶୁମ୍‌କେ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ଏମେୟାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ଏନା ନାଗେନ୍ତେ ଯିହୁଦୀକ ଆକ ଆକରେକ ଏପେଗେର୍‍ୟାନ୍ତେ ମେନ୍‍କେଦାଃ, “ଇନିଃ ଚିଲ୍‍କାତେ ଆୟାଃ ମାସ୍ ଜମେନାଙ୍ଗ୍‌ ଆବୁକେ ଏମ୍‌ ଦାଡ଼ିବୁୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆଏ, “ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆପେ ମାନୱାହନ୍‌ଆଃ ମାସ୍ କାପେ ଜମେରେଦ ଆଡଃ ଇନିୟାଃ ମାୟୋମ୍‌ କାପେ ନୁଁଏରେଦ ଆପେରେ ଜୀଦାନ୍‌ ବାନଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ଆଇଁୟାଃ ମାସ୍ ଜମେନିଃ ଆଡଃ ଆଇଁୟାଃ ମାୟୋମ୍‌ ନୁଁଏନିଃ ଜାନାଅ ଜୀଦାନ୍‌ ନାମେୟାଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ ତାୟମ୍ ହୁଲାଙ୍ଗ୍‌ରେ ଇନିଃକେ ଜୀଉ ବିରିଦିୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ଆଇଁୟାଃ ମାସ୍‍ଦ ସାର୍‌ତି ଜମେୟାଃଁ ତାନାଃ ଆଡଃ ଆଇଁୟାଃ ମାୟୋମ୍‌ ସାର୍‌ତି ନୁଁଏୟାଃ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଆଇଁୟାଃ ମାସ୍ ଜମେନିଃ ଆଡଃ ଆଇଁୟାଃ ମାୟୋମ୍‌ ନୁଁଏନିଃ ଆଇଙ୍ଗ୍‌ରେ ତାଇନ୍‍ତାନାଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନିଃରେଇଙ୍ଗ୍‌ ତାଇନ୍‍ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ଜୀନିଦ୍‌ ଆପୁ ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‍କେଦିୟାଁଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପୁଆଃ ହରାତେ ଜୀହୁଦଃତାନ୍‍ଲେକା ଆଇଙ୍ଗ୍‌କେ ଜମ୍‍ନିଃ ଆଇଁୟାଃ ହରାତେ ଜୀହିଦଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁଆକାନ୍‌ ହଲଙ୍ଗ୍‌ ନେଆଁଁ ତାନାଃ, ହାଡ଼ାମ୍‍ ହଡ଼କ ଜମ୍‍କେଦ୍‍ ଆଡଃକ ଗଏଃୟାନା ଲେକାଦ କାହା, ମେନ୍‌ଦ ନେ ହଲଙ୍ଗ୍‌ ଜମେନିଃ ଜାନାଅ ଜାନାଅ ଜାକେଦ୍‌ ଜୀହିଦଃଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","କପର୍‌ନାହୁମ୍‌ ହାତୁରେୟାଃ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ଇତୁକତାନ୍‍ଲଃ ଇନିଃ ନେ କାଜି କାଜିୟାଦ୍‍କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ଏନ୍ତେ ୟୀଶୁଆଃ ଚେଲାକଏତେ ପୁରାଃକ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ମେନ୍‍କେଦାଃ, “ନେ କାଜି କେଟେଦ୍‍ଗିୟା, ନେଆଁଁ ଅକଏ ଆୟୁମ୍‍ଦାଡ଼ିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ମେନ୍‌ଦ ୟୀଶୁକେ ଜେତାଏ କାକ କାଜିରେହଁ, ଚେଲା ତାୟାଃକ ନେ କାଜି ନାଗେନ୍ତେ ନଗମ୍‍ତଗମ୍‍ୟାନାକ ନେଆଁଁ ଆୟାଃ ଜୀଉରେ ସାରିକେଦ୍‍ତେ ମେତାଦ୍‌କଆଏ, “ଚିୟାଃ ଆପେ ନେଆଁଁ ନାଗେନ୍ତେ ଆଡ଼ାଃଉଡ଼ୁଃଗଃ ତାନାପେ ? ");
INSERT INTO unx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ଏନ୍ତେ ଆପେ ମାନୱାହନ୍‌କେ ସିଦା ତାଇକେନ୍‌ ଠାୟାଦ୍‌ତେ ରାକାବ୍‍ତାନ୍‍ପେ ନେଲିରେଦ ଚିନାଃ ଚିକାୱାଃ ? ");
INSERT INTO unx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ଆତ୍ମା ଜୀଦାନ୍‌ ଏମଃନିଃ ତାନିଃ, ହଡ଼ରାଃ ପେଡ଼େଃ ଜେତ୍‌ନାଃ କାମି କାଏ ଦାଡ଼ିୟା । ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଜୀଦାନ୍‌ ଏମଃ ଆତ୍ମାକେ ଆପେ ଜେ'ଲେକା ଆଟ୍‌କାର୍‌ଉରୁମ୍‌ ଦାଡ଼ିୟାପେ ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ନେ ସବେନାଃ କାଜିକେଦାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ଏନ୍‌ରେୟ ଆପେକଏତେ ଚିମିନ୍‌କ କାକ ବିଶ୍ୱାସ୍‌ତାନା,” ଚିୟାଃଚି ୟୀଶୁଦ ଏନ୍‌ କା ବିଶ୍ୱାସ୍‍ତାନ୍‍ ଚିମିନ୍‌କକେ ଆଡଃ ବାଇରିକଆଃ ତିଃଇରେ ସାବ୍‍ରିକାଇ ହଡ଼କେୟଗି ମୁନୁଏତେ ସାରିତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ଇନିଃ ଆଡଃଗି ମେତାଦ୍‌କଆଏ, “ଏନାମେନ୍ତେ ଆପୁଇଁୟାଃ ସାଃଏତେ ଲିବୁଇ କା ହିଜୁଃରେଦ, ଜେତାଏ ଆଇଁୟାଃତାଃ କାକ ହିଜୁଃଦାଡ଼ିୟାଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ନେଆଁ ନାଗେନ୍ତେ ଇନିୟାଃ ଚେଲାକଏତେ ପୁରାଃକ ରୁହାଡ଼୍‌ୟାନା ଆଡଃ ଇନିଃକେ କାକ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ କାଜିୟାଦ୍‍କଆଏ, ଚିୟାଃ ଆପେକେୟ ଆଇଙ୍ଗ୍‌କେ ବାଗିକେଦ୍‌ତେ ସେନଃ ସାନାଙ୍ଗ୍‌ପେ ତାନା ? ");
INSERT INTO unx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ୟୀଶୁକେ ମେନ୍‌ରୁହାଡ଼ାଇୟାଏ, “ହେ ଗମ୍‌କେ, ଆଲେ ଅକଏତାଃତେଲେ ସେନାଃ ? ଜାନାଅ ଜୀଦାନ୍‌ରେୟାଃ କାଜିଦ ଆମାଃତାଃରେୟା, ");
INSERT INTO unx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ଆମ୍‌ ଜୀନିଦ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପାବିତାର୍‌ ହନ୍‌ ୟୀଶୁ ତାନ୍‌ମେ ମେନ୍ତେଲେ ବିଶ୍ୱାସ୍‌କାଦାଃ ଆଡଃ ସାରିକାଦାଲେ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଚିୟାଃ ଆଇଙ୍ଗ୍‌ ଆପେ ଗେଲ୍‌ବାର୍‌ ଚେଲାକକେ କାଇଙ୍ଗ୍‌ ସାଲାକାଦ୍‍ପେଆଚି ? ଆଡଃ ଆପେକଏତେ ମିଆଁଦ୍‌ନିଃ ସାଏତାନ୍‌ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଇନିଃ ଶିମୋନ୍‌ ହନ୍ତେକଡ଼ା ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦାରାଃ କାଜି କାଜିକେଦାଏ, ନିଃଦ ଗେଲ୍‍ବାର୍‍ ଚେଲାକଏତେ ମିଆଁଦ୍‌ନିଃ ଆଡଃ ଇନିୟାଃ ସାବ୍‌ଇଚିନିଃ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ଏନ୍‌ ତାୟମ୍‌ତେ ୟୀଶୁ ଗାଲିଲ୍‌ରେ ହନର୍‌ ବାଡ଼ାକେଦାଏ; ଚିୟାଃଚି ଯିହୁଦୀକଆଃ ହାକିମ୍‌କ ଇନିଃକେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ ତାଇକେନାକ ଏନାମେନ୍ତେ ଇନିଃକେ ଯିହୁଦାତେ କା ସେନ୍‌ ସାନାଙ୍ଗ୍‌କିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ଯିହୁଦୀକଆଃ ଜାମ୍‍ଡ଼ା ପାରାବ୍‍ରେୟାଃ ନେଡା ନାଡ଼େଃୟାନ୍‌ଚି, ");
INSERT INTO unx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ୟୀଶୁଆଃ ହାଗାକ ଇନିଃକେ କାଜିକିୟାଃକ, “ଆମ୍‌ ନେତାଃଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଯିହୁଦାତେ ସେନଃମେ, ଏନ୍ତାଃରେ ଆମାଃ ଚେଲାକ ଆମ୍‌ କାମିତାନ୍‌ ପେଡ଼େୟାନ୍‌ କାମିକ ନେଲେକା । ");
INSERT INTO unx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ଚିୟାଃଚି ଜେତାଏ ଆଇଃକ୍‌ଗି ଉଦୁବେନ୍‍ ସାନାଙ୍ଗ୍‌ରେଦ ଦାନାଙ୍ଗ୍‌ରେ ଜେତ୍‌ନାଃ କାଏ କାମିୟା, ନେୟାଁମ୍‌ କାମିତାନ୍‍ରେଦ ଅତେଦିଶୁମ୍‌ରେନ୍‍କତାଃରେ ଉଦୁବେନ୍‍ମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ଚିୟାଃଚି ଇନିୟାଃ ହାଗାକହଁ ଇନିଃତାଃରେ କାକ ବିଶ୍ୱାସ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ଏନାମେନ୍ତେ ୟୀଶୁ କାଜିକେଦ୍‍କଆଏ, “ନାହାଁଃ ଜାକେଦ୍‌ ଆଇଁୟାଃ ଠାଉକାନ୍‌ ନେଡା ଆଉରି ସେଟେରାଃ, ମେନ୍‌ଦ ଆପେୟାଃନାଙ୍ଗ୍‌ ଠାଉକାନ୍‌ ନେଡା ଜାନାଅଗି ନେଡାକାନା । ");
INSERT INTO unx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ସାଂସାର୍‍ ଆପେକେ କାଏ ହିଲାଙ୍ଗ୍‌ପେୟା, ମେନ୍‌ଦ ଏନା ଆଇଙ୍ଗ୍‌କେ ହିଲାଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ତାନା, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ଏନାରେୟାଃ କାମି ଏତ୍‍କାନ୍‍ଗିୟାଃ ମେନ୍ତେ ଗାୱାଇଙ୍ଗ୍‌ ଏମ୍‌ଆଉତାନା । ");
INSERT INTO unx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ଆପେ ପାରାବ୍‍ତେ ସେନଃପେ, ଆଇଙ୍ଗ୍‌ ପାରାବ୍‍ତେ କାଇଙ୍ଗ୍‌ ସେନ୍‍ତାନା, ଚିୟାଃଚି ଆଇଁୟାଃ ନେଡାଦ ନାହାଁଃ ଜାକେଦ୍‌ ଆଉରି ହିଜୁଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଆଡଃ ଇନିଃ ନେ ସବେନ୍‌ କାଜି କାଜିକେଦ୍‌ଚି ଗାଲିଲ୍‌ରେ ତାଇନ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ୟୀଶୁଆଃ ହାଗାକ ପାରାବ୍‍ତେ ସେନଃୟାନ୍‍ଚି, ୟୀଶୁହଁ ନେପେଲ୍‍ରେଦ କା ମେନ୍‌ଦ ଉକୁ ଉକୁ ଲେକାତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ଏନ୍ତେ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କ ଇନିଃକେ ପାରାବ୍‍ରେ ଦାଣାଁଁଇତାନ୍‌କ ତାଇକେନା ଆଡଃକ ମେନ୍‌କେଦାଃ, “ଇନିଃ କତାଃରିୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ଏନ୍ତେ ଗାଦେଲ୍‌ ହଡ଼କ ଆକ ଆକରେ ୟୀଶୁଆଃ ବିଷାଏରେ ପୁରାଃ ହାୟମ୍‌ ହାୟମେତାନ୍‍କ ତାଇକେନା । ଆଡଃ ଚିମିନ୍‍କ କାଜିକେଦା, “ଇନିଃ ବୁଗିନ୍‌ ହଡ଼ ତାନିଃ,” ଆଡଃ ଚିମିନ୍‍କ କାଜିକେଦା, “କାହାଗି ଇନିଃ ହଡ଼କକେ ବେଦାକୁତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ଏନ୍‍ରେୟ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କଆଃ ବରତେ ଜେତାଏ ଇନିୟାଃ ବିଷାଏରେ ନେପେଲ୍‌ରେ କାକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ପାରାବ୍‍ରେୟାଃ ଥାଲାମାଲା ସେନଃୟାନ୍‍ଚି ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃତେ ସେନ୍‌କେଦ୍‌ତେ ଇତୁଏଟେଦ୍‌ କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ଯିହୁଦୀକଆଃ ହାକିମ୍‌କ ହାୟକାଟ୍‍ୟାନ୍ତେ ମେନ୍‍କେଦାଃକ, “ନିଃ ବେଗାର୍‌ ପାଢ଼ାଅକେଦ୍‌ତେ ଚିଲ୍‌କା ନେ ଲେକା ଇତୁକତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ଏନାତେ ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ଆଇଁୟାଃ ଇନିତୁ ଆଇଁୟାଃ ନାହାଁଲାଃ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ହିଜୁଆକାନା । ");
INSERT INTO unx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଜେତାଏ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମନେଲେକା ରିକା ସାନାଙ୍ଗ୍‌ରେଦ, ଇନିଃ ଆଇଁୟାଃ ଇନିତୁ ପାର୍‌ମେଶ୍ୱାର୍‍ ସାଃଏତେ ଚାଏ ଆଇଁୟାଃ ପେଡ଼େଃତିଙ୍ଗ୍‌ କାଜିତାନା ଏନା ସାରିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଜେତାଏ ଆୟାଃତେ କାଜିନିଃ ଆୟାଃ ମାନାରାଙ୍ଗ୍‌ ନାମ୍‍ବାଡ଼ାଏଃ, ମେନ୍‌ଦ ଜେତାଏ ଆଇଃକ୍‌କେ କୁଲ୍‍ନିୟାଃ ମାନାରାଙ୍ଗ୍‌ ନାମ୍‍ବାଡ଼ାଏନିଃ ସାର୍‌ତିଗିୟାଏ; ଆଡଃ ଇନିଃତାଃରେ ଏତ୍‌କାନ୍‌ଆଃ ବାନଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ଚିୟାଃ ମୁଶା ଆପେକେ ଆନ୍‌ଚୁ କାଏ ଏମାକାଦ୍‌ପେୟା ? ଏନ୍‍ରେୟ ଆପେକଏତେ ଜେତାଏୟ ଆନ୍‌ଚୁ କାକ ମାନାତିଙ୍ଗ୍‌ତାନା, ଆପେ ଚିକାନାଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌କେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ତାନାପେ ?” ");
INSERT INTO unx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ଗାଦେଲ୍‌ ହଡ଼କ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଆମ୍‌କେ ବଙ୍ଗା ଏସେରାକାଦ୍‌ମେୟାଁଏ, ଅକଏ ଆମ୍‌କେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ମିଆଁଦ୍‌ ପେଡ଼େୟାନ୍‌ କାମିଙ୍ଗ୍‌ କାମିୟାକାଦ୍‍ ନାଗେନ୍ତେ ଆପେ ସବେନ୍‌କ ହାଏକାଟଃତାନା । ");
INSERT INTO unx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ନେୟାଁମେନ୍ତେ ମୁଶା ଆପେୟାଃ ହନ୍‌କକେ ଖାତ୍‌ନାଅରେୟାଃ ଆନ୍‌ଚୁ ଏମାକାଦ୍‍ପେୟାଏ, ଏନାଦ ମୁଶାଏତେ କାହା ମେନ୍‌ଦ ହାଡ଼ାମ୍‍ ହଡ଼କଆଃ ସାଃଏତେଗି, ଆଡଃ ଆପେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ କଡ଼ାହନ୍‌କକେ ଖାତ୍‍ନାଅକତାନାପେ । ");
INSERT INTO unx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ମୁଶା ଅଲାକାନ୍‌ ଆନ୍‌ଚୁ ଆଲକା ଟଟାଗଃକା ମେନ୍ତେ ରୁଡ଼ୁନ୍‍ ହୁଲାଙ୍ଗ୍‌ରେ ମିଆଁଦ୍‌ କଡ଼ାହନ୍‌ରାଃ ଖାତ୍‌ନାଅଃରେଦ, ଆଇଙ୍ଗ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ମିଆଁଦ୍‌ ହଡ଼କେ ପୁରାଗି ବୁଗିକାଇ ହରାତେ, ଆପେ ଚିନାଃ ଆଇଙ୍ଗ୍‌କେପେ ଏସେଦାଇଙ୍ଗ୍‌ ତାନା ? ");
INSERT INTO unx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ମେଦ୍‍ମୁହାଁଡ଼୍‌ ନେଲ୍‍କେଦ୍‍ତେ ଆଲ୍‌ପେ ବିଚାର୍‌ଆଃ, ମେନ୍‌ଦ ସାର୍‌ତି ଲେକାତେ ବିଚାର୍‌ ରିକାଏପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ଯୀରୁଶାଲେମ୍‌ରେନ୍‍ ହଡ଼କଏତେ ଚିମିନ୍‍କ କାଜିକେଦା, “ଚିୟାଃ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କ ଗଏଃ ନାଙ୍ଗ୍‌କ ସାନାଙ୍ଗ୍‌ତାନ୍‍ ହଡ଼ ନିଃ ନାହାଲିଃ ଚି ? ");
INSERT INTO unx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ନେଲିପେ, ନିଃ ନେତାଃରିୟା, ନେପେଲ୍‌ରେ ଜାଗାର୍‌ତାନାଏ ଆଡଃ ଇନ୍‌କୁ ଜେତ୍‌ନାଃ କାକ କାଜିୟାଇତାନା, ଚିୟାଃ ଆଗୁଆଇକ ଇନିଃକେ ମାସି ତାନିଃ ମେନ୍ତେ ସାର୍‌ତିଗିକ ଆଟ୍‌କାର୍‍କେଦାଃ ଚି ? ");
INSERT INTO unx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ଇନିଃ ଅକ୍‌ତାଃରେନ୍‌ ତାନିଃ ନେୟାଁବୁ ସାରିତାନା, ମେନ୍‌ଦ ମାସି ହିଜୁଃରେ ଇନିଃ କତାଃରେନ୍‍ ତାନିଃ ଏନା ଜେତାଏ କାକ ସାରିଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ଏନ୍ତେ ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଇତୁକତାନ୍‍ଲଃ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ଚିୟାଃ ଆପେ ଆଇଙ୍ଗ୍‌କେ ସାରିତାନାପେ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଅକ୍‌ତାଃରେନ୍‌ ତାନିଙ୍ଗ୍‌ ଏନାପେ ସାରିତାନାଚି ? ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃତେଗି କାଇଙ୍ଗ୍‌ ହିଜୁଆକାନା ମେନ୍‌ଦ ଆଇଁୟାଃ କୁଲ୍‍ନିଃ ସାର୍‌ତିଗିୟାଏ, ଆପେ ଇନିଃକେ କାପେ ସାରିତାନା, ");
INSERT INTO unx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ସାରିତାନାଇଙ୍ଗ୍‌ ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଇନିଃତାଃଏତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ଆଡଃ ଇନିଃ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ସାସାବ୍ ସାନାଙ୍ଗ୍‌କିୟାଃକ, ଏନ୍‍ରେୟ ଜେତାଏ ଇନିଃରେ ତିଃଇ କାକ ଜିଲିଙ୍ଗ୍‌କେଦାଃ, ଚିୟାଃଚି ଇନିୟାଃ ନେଡାଦ ଇମ୍‌ତାଜାକେଦ୍‌ କା ସେଟେରାକାନ୍‍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ମେନ୍‌ଦ ଗାଦେଲ୍‌ ହଡ଼କଏତେ ପୁରାଃ ହଡ଼କ ଇନିଃରେକ ବିଶ୍ୱାସ୍‌ କେଦାଃ ଆଡଃକ କାଜିକେଦା, “ଚିୟାଃ ମାସି ହିଜୁଃରେ ନିଃ କାମିୟାକାଦ୍ ପେଡ଼େଃରାଃ କାମିଏତେ ଆଦ୍‌କା କାମିକଚି କାମିୟା ?” ");
INSERT INTO unx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ଫାରୁଶୀକ ହଡ଼କକେ ୟୀଶୁଆଃ ବିଷାଏରେ ନେୟାଁ ହାୟମ୍‌ ହାୟମ୍‌ତାନ୍‍କ ଆୟୁମ୍‍କେଦ୍‍କଆ, ଏନ୍ତେ ଫାରୁଶୀକ ଆଡଃ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଇନିଃକେ ସାସାବ୍‍ନାଙ୍ଗ୍‌ ଦାରୱାନ୍‌କକେ କୁଲ୍‍କେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ହୁଡିଙ୍ଗ୍‌ ଦିପିଲି ଜାକେଦ୍‌ ଆପେଲଃ ତାଇନିଃକ୍‌, ଏନ୍ତେ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦ୍‍ନିଃତାଃତେ ସେନଃଆଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦାଣାଁଁଇଙ୍ଗ୍‌ରେୟ କାପେ ନାମିୟାଁ ଆଡଃ ଆଇଙ୍ଗ୍‌ ତାଇନଃତାଃ ଆପେ କାପେ ସେନ୍‍ଦାଡ଼ିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ଏନ୍ତେ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କ ଆକ ଆକରେକ ଜାଗାର୍‌କେଦାଃ, “ନିଃ କତାଃତେ ସେନଃନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ ତାନାଏ ଯେ ଆବୁ ଇନିଃକେ କାବୁ ନାମିୟାଁ ? ଚିୟାଃ ଇନିଃ ଗ୍ରୀକ୍‌ ହଡ଼କଆଃ ଥାଲାରେ ନେତେ ହେନ୍ତେୟାକାନ୍ ଆବୁଆଃ ହଡ଼କତାଃ ସେନଃଆଏ ଆଡଃ ଗ୍ରୀକ୍‌ ହଡ଼କକେ ଇତୁକଆଏ ? ");
INSERT INTO unx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦାଣାଁଁଇଙ୍ଗ୍‌ରେୟ କାପେ ନାମିୟାଁ ଆଡଃ ଆଇଙ୍ଗ୍‌ ତାଇନଃତାଃ କାପେ ସେନ୍‍ଦାଡ଼ିୟା ମେନ୍ତେ ଇନିଃ କାଜିକେଦ୍‍ କାଜି ଚିକ୍‌ନାଃତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ଟୁଣ୍ଡୁ ହୁଲାଙ୍ଗ୍‌, ଚାଏ ପାରାବ୍‍ରେୟାଃ ମାରାଙ୍ଗ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ୟୀଶୁ ତିଙ୍ଗୁୟାନ୍ତେ କାଉରିକେଦ୍‌ତେ କାଜିକେଦାଏ, “ଜେତାଏ ତେତାଙ୍ଗ୍‌ରେଦ ଆଇଁୟାଃତାଃତେ ହିଜୁଃକାଏ, ଆଡଃ ");
INSERT INTO unx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ଜେତାଏ ଆଇଙ୍ଗ୍‌ରେ ବିଶ୍ୱାସ୍‌ତାନ୍‌ନିଃ ନୁଁଏକାଏ, ଧାରାମ୍‌ପୁଥିରେ କାଜିକାନ୍‌ଲେକା, ‘ବିଶ୍ୱାସ୍‍ତାନ୍‌ନିୟାଃ ଜୀଉଏତେ ଜୀଦାନ୍‌ ଦାଆଃରେୟାଃ ଗାଡ଼ାକ ଲିଙ୍ଗିକାତେୟଃଆ ।’” ");
INSERT INTO unx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଇନିଃକେ ବିଶ୍ୱାସୀତାନ୍‌କ, ତାୟମ୍‌ତେ ଅକନ୍‌ ଆତ୍ମାକେକ ନାମିୟାଁ, ଇନ୍‌କୁଆଃ ବିଷାଏରେ ଇନିଃ ନେ କାଜି କାଜିକେଦାଏ, ଚିୟାଃଚି ଇମ୍‌ତା ଜାକେଦ୍‌ ୟୀଶୁଆଃ ମାନାରାଙ୍ଗ୍‌ କା ହବାକାନ୍‌ ତାଇକେନ୍‌ ହରାତେ ପାବିତାର୍‌ ଆତ୍ମାଦ କାଏ ଏମାକାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ପୁରାଃ ହଡ଼କଏତେ ଚିମିନ୍‌କ ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ମେନ୍‍କେଦାଃକ, “ନିଃ ସାର୍‌ତିଗି ନାବୀ ତାନିଃ !” ");
INSERT INTO unx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ଏଟାଃକ ମେନ୍‌କେଦାଃ, “ଇନିଃ ମାସି ତାନିଃ !” ମେନ୍‌ଦ ଚିମିନ୍‍କ ମେନ୍‍କେଦାଃ, “ମାସି ଗାଲିଲ୍‌ଏତେ କାଏ ହିଜୁଃଆ ? ");
INSERT INTO unx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ମାସି ଦାଉଦ୍‌ଆଃ କିଲିଏତେ ଆଡଃ ଦାଉଦ୍‌ ତାଇକେନ୍‌ ବେଥ୍‌ଲେହେମ୍‌ ସାହାର୍‌ଏତେ ହିଜୁଆଏଃ ମେନ୍ତେ ଧାରାମ୍‌ପୁଥିରେ କା'ଚି କାଜିକାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ଏନାତେ ଗାଦେଲ୍‌ ହଡ଼କ ଇନିୟାଃ ନାଗେନ୍ତେକ ବିପିଙ୍ଗାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ଆଡଃ ଇନ୍‌କୁଏତେ ଚିମିନ୍‍କ ୟୀଶୁ ସାବଃକାଏ ମେନ୍ତେ ସାନାଙ୍ଗ୍‌ତାନ୍‍କ ତାଇକେନା ମେନ୍‌ଦ ଜେତାଏ ଇନିଃରେ ତିଃଇ କାକ ଜିଲିଙ୍ଗ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ଦାରୱାନ୍‌କ ରୁହାଡ଼୍‌ୟାନ୍‌ଚି, ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଫାରୁଶୀକ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‍କଆକ, “ଚିନାଃ ମେନ୍ତେ ଇନିଃକେ କାପେ ଆଉକିୟା ?” ");
INSERT INTO unx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ଦାରୱାନ୍‌କ ମେତାଦ୍‌କଆକ, “ନେ ହଡ଼ କାଜିତାନ୍‌ଲେକା ଜେତାଏ ହଡ଼ ଚିଉଲାହ କାଏ କାଜିୟାକାଦାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ଏନ୍ତେ ଫାରୁଶୀକ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆକ, “ଆପେକେୟଗିଚି ଇନିଃ ବେଦାକାଦ୍‌ପେୟାଏ ? ");
INSERT INTO unx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ହାକିମ୍‌କଏତେ ଚାଏ ଫାରୁଶୀକଏତେ ଚିୟାଃ ଜେତାଏ ଇନିଃରେ ବିଶ୍ୱାସ୍‌କାଦାକ ? ଏନା ସାରିକାଦାପେଚି ? ");
INSERT INTO unx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","କାହା ! ମେନ୍‌ଦ ମୁଶାରାଃ ଆନ୍‌ଚୁ କାକ ସାରିତାନ୍‍ ନାଗେନ୍ତେ ନେ ଗାଦେଲ୍‌ ହଡ଼କ ସାର୍‌ପାୱାକାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ନିକଦୀମ୍‌, ଅକଏଚି ସିଦାରେ ୟୀଶୁତାଃତେ ସେନ୍‌କାନ୍‌ ତାଇକେନାଏ ଆଡଃ ଇନିଃ ଇନ୍‌କୁଏତେ ମିହୁଡ଼୍‌ ତାଇକେନାଏ, ଇନିଃ କୁଲିକେଦ୍‍କଆଏ, ");
INSERT INTO unx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ମିଆଁଦ୍‌ ହଡ଼ତାଃଏତେ ଆଉରି ଆୟୁମ୍‍ ଜାକେଦ୍‌ ଆଡଃ ଇନିୟାଃ ଚାଇଲ୍‌ ଚାଲାନ୍‌ ଆଉରି ସାରି ଜାକେଦ୍‌ ଆବୁଆଃ ଆନ୍‌ଚୁ ଚିୟାଃ ଇନିୟାଃ ବିଚାରେୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ଇନ୍‌କୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଃକ, “ଆମ୍‌ହଗିଚି ଗାଲିଲ୍‌ରେନ୍ ହଡ଼ ତାନ୍‌ମେ ? ନେଲ୍‌ ନାମେମେ, ଗାଲିଲ୍ଏତେ ଜେତାଏ ନାବୀ କାଏ ଅଡଙ୍ଗ୍‌ଅଃଆ ?” ");
INSERT INTO unx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ଏନ୍ତେ ସବେନ୍‌କ ଆକଆଃ ଆକଆଃ ଅଡ଼ାଃତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ମେନ୍‌ଦ ୟୀଶୁ ଜାଇତୁନ୍‌ ବୁରୁତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଆଙ୍ଗ୍‌ୟାନ୍‌ଚି ୟୀଶୁ ମାନ୍ଦିର୍‌ତେ ରୁହାଡ଼୍‌ୟାନାଏ ଆଡଃ ସବେନ୍‌ ହଡ଼କ ଇନିଃତାଃରେ ହୁଣ୍ଡିୟାନାକ ଆଡଃ ଇନିଃ ଦୁବ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁକେ ଇତୁକେଦ୍‍କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ଆଇନ୍‌ ଇତୁକ ଆଡଃ ଫାରୁଶୀକ ଆପାଙ୍ଗିର୍ କାମିରେ ସାବ୍‍କାନ୍‍ କୁଡ଼ିକେ ଆଉକେଦ୍‌ତେ ସବେନ୍‌କଆଃ ଥାଲାରେକ ତିଙ୍ଗୁକିୟା ଆଡଃ ୟୀଶୁକେ କାଜିକିୟାଃକ, ");
INSERT INTO unx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ହେ ଗୁରୁ, ନେ କୁଡ଼ି ଆପାଙ୍ଗିର୍‌ କାମି କାମିତାନ୍ ଇମ୍‍ତାଗି ସାବ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଆଲେୟାଃ ଆନ୍‌ଚୁରେ ମୁଶା ନେ ଲେକାନ୍ କୁଡ଼ିକକେ ଦିରି ଚିଦ୍‍ଗି ଗଏଃକପେ ମେନ୍ତେ ଆଲେକେ ଆଚୁଆକାଦ୍‍ଲେୟାଏ, ନାହାଁଃ ଆମ୍‌ ଚିନାଃ ମେନେତାନାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ୟୀଶୁକେ ଚିଟାଇରାଃ ହରାନାମ୍ ନାଗେନ୍ତେ ବିଡ଼ାଅ ତାନ୍‍ଲଃ ଇନ୍‌କୁ ନେୟାଁ କୁଲିକିୟାଃକ । ମେନ୍‌ଦ ୟୀଶୁ ତିରୁବ୍‍ୟାନ୍‌ଲଃ ସାର୍‍ସାର୍‍ତେ ଅତେରେ ଅଲ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ଏନ୍ତେ ଇନ୍‌କୁ କୁଲିତାନ୍ ଇମ୍‍ତାଗି ଇନିଃ ବିରିଦ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆଏ, “ଆପେୟାଃ ଥାଲାରେ କା ପାପ୍‌କାଦ୍‌ନିଃ ସିଦାତେ ଇନିଃକେ ଦିରି ଚିଦ୍‌ଗିକାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ଏନ୍ତେ ଆଡଃଗି ଇନିଃ ତିରୁବ୍‍ ରୁହାଡ଼୍‌କେଦ୍‍ତେ ଅତେରେ ସାର୍‍ସାର୍‍ତେ ଅଲ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ଇନ୍‌କୁ ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ ମାପ୍‍ରାଙ୍ଗ୍‌ଏତେ ହୁପ୍‌ଡିଙ୍ଗ୍‌ ଜାକେଦ୍‌ ମିମିଆଦ୍‌ତେକ ଅଡଙ୍ଗ୍‌ୟାନା, ୟୀଶୁ ଏସ୍‍କାର୍‍ଗି ତାଇନ୍‍ୟାନାଏ ଆଡଃ ଏନ୍‍ କୁଡ଼ି ଥାଲାରେ ତିଙ୍ଗୁଆକାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ଏନ୍ତେ ୟୀଶୁ ତିଙ୍ଗୁୟାନ୍‌ତେ ଇନିଃକେ କାଜିକିୟାଏ, “ଏ କୁଡ଼ି ଆମ୍‌କେ ଚିଟାତାନ୍‍କ କତାଃରେକଆଃ ? ଚିୟାଃ ଜେତାଏ ଆମ୍‌କେ କାକ ସାଜାଇକେଦ୍‌ମେଆଚି ?” ");
INSERT INTO unx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ଇନିଃ କାଜିକିୟାଏ, “ହେ ଗମ୍‌କେ, ଜେତାଏ ଦ କାହା,” ଏନ୍ତେ ୟୀଶୁ ମେତାଇୟାଏ, “ଆଇଙ୍ଗ୍‌ ହଁ ଆମ୍‌କେ କାଇଙ୍ଗ୍‌ ସାଜାଇମେତାନା, ଜୁ ସେନଃମେ ଆଡଃ ଆୟାର୍‍ତେ ଆଲମ୍‌ ପାପ୍‌ କାମିୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ୟୀଶୁ ଆଡଃମିସା ଫାରୁଶୀକକେ ଇତୁତାନ୍‌ଲଃ କାଜିକେଦ୍‍କଆଏ, “ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ମାସ୍କାଲ୍‍ ତାନିଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ନିଃ ଜୀଦାନ୍‌ରେୟାଃ ମାସ୍କାଲ୍‍ ନାମେୟାଏ । ଆଡଃ ନୁବାଃରେ କାଏ ସେନେୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ଏନ୍ତେ ଫାରୁଶୀକ ଇନିଃକେ କାଜିକିୟାଃକ, “ଆମ୍‌ ଆମାଃ ନାଗେନ୍ତେ ଗାୱାଇ ଏମେତାନାମ୍‌, ଆମାଃ ଗାୱା ସାର୍‌ତି ନାହାଁଲାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “କାହାଗି, ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଗାୱାଇଙ୍ଗ୍‌ ଏମେତାନ୍‌ରେଅ ଆଇଁୟାଃ ଗାୱା ସାର୍‌ତିଗିୟା । ଆଇଙ୍ଗ୍‌ଦ କତାଃଏତେଇଙ୍ଗ୍‌ ହିଜୁଆକାନା ଆଡଃ କତାଃତେଇଙ୍ଗ୍‌ ସେନଃତାନା ନେୟାଁଇଙ୍ଗ୍‌ ସାରିତାନା ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ କତାଃଏତେଇଙ୍ଗ୍‌ ହିଜୁଃକାନା ଆଡଃ କତାଃତେଇଙ୍ଗ୍‌ ସେନାଃ, ଏନା ଆପେ କାପେ ସାରିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ଆପେ ହଡ଼କଲେକାପେ ବିଚାରେତାନା, ଆଇଙ୍ଗ୍‌ ଜେତାଏକେ କାଇଙ୍ଗ୍‌ ବିଚାର୍‍କତାନା । ");
INSERT INTO unx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ବିଚାରେରେଦ ଆଇଁୟାଃ ବିଚାର୍‌ ସାର୍‌ତିଗିୟାଃ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ କାଇଙ୍ଗ୍‌ ଏସ୍‍କାରାଃ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ ଆପୁଲଃ ମେନାଇୟାଁ । ");
INSERT INTO unx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ଆଡଃ ବାର୍‍ହଡ଼୍‌କିନାଃ ଗାୱା ମିଦଃରେ, ଇନ୍‌କିନାଃ କାଜିତେୟାଃ ସାର୍‌ତିଗିୟା ନେୟାଁ ଆପେୟାଃ ଆନ୍‌ଚୁ ପୁଥିରେ ଅଲାକାନା । ");
INSERT INTO unx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଗାୱାଇଙ୍ଗ୍‌ ଏମେତାନା ଆଡଃ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାନ୍ ଆପୁ ଆଇଁୟାଃନାଙ୍ଗ୍‌ ଗାୱା ଏମେତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ଏନ୍ତେ ଇନ୍‌କୁ କୁଲିକିୟାଃକ, “ଆପୁମ୍‌ତାମାଃ କତାଃରିୟାଃ ?” ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଆପେ ଆଇଙ୍ଗ୍‌କେ ଆଡଃ ଆପୁଇଙ୍ଗ୍‌କେ କାପେ ସାରିୟାଃ । ଆଇଙ୍ଗ୍‌କେ ଆପେ ସାରିରେଦ ଆପୁଇଙ୍ଗ୍‌କେହ ସାରିତେୟାଃପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ନେ କାଜି ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେୟାଃ ଭାଣ୍ଡାର୍‌ ଅଡ଼ାଃ ଜାପାଃରେ ଇତୁକତାନ୍‌ ଇମ୍‌ତା କାଜିକେଦାଏ, ଆଡଃ ଜେତାଏ ଇନିଃକେ କାକ ସାବ୍‌କିୟାଃ ଚିୟାଃଚି ଇନିୟାଃ ନେଡା ଇମ୍‌ତାଙ୍ଗ୍‌ ଜାକେଦ୍‌ କା ତେବାଃକାନ୍‍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଆଡଃମିସା ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ସେନଃତାନାଇଙ୍ଗ୍‌ ଆଡଃ ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦାଣାଁଁଇୟାଁପେ ମେନ୍‌ଦ ଆପେୟାଃ ପାପ୍‌ରେପେ ଗଜଃଆ । ଆଇଙ୍ଗ୍‌ ସେନଃତାଃତେ କାପେ ସେନ୍‌ଦାଡ଼ିୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ଯିହୁଦୀକଆଃ ହାକିମ୍‌କ ଆକ ଆକରେକ ମେନ୍‍କେଦାଃ, “ଚିୟାଃ ଇନିଃ ଆଇଃକ୍‌ଗି ଗଜଃଇଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିତାନାଏଚି, ଏନାନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ସେନଃତାଃତେ କାପେ ସେନ୍‌ ଦାଡ଼ିୟା ମେନ୍ତେ କାଜିତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆପେ ନେ ଅତେଦିଶୁମ୍‌ରେ ଜାନାମ୍‌କାନାପେ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ସିର୍ମାତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ । ଆପେ ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌କ ତାନ୍‌ପେ, ଆଇଙ୍ଗ୍‌ ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ନାହାଁଲାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ମେତାପେ ତାନାଇଙ୍ଗ୍‌, ଆପେ ଆପେୟାଃ ପାପ୍‌ରେ ଗଜଃଆପେ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ଗି ଇନିଃ ତାନିଙ୍ଗ୍‌ ଏନା କାପେ ବିଶ୍ୱାସେରେଦ ଆପେୟାଃ ପାପ୍‌ରେଗି ଗଜଃଆପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ କୁଲିକିୟାଃକ, “ଆମ୍‌ ଅକଏ ତାନ୍‌ମେ ?” ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ମୁନୁଏତେଗି କାଜିୟାକାଦ୍‌ପେୟାଇଙ୍ଗ୍‌ ଇନିଃ ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ଆପେୟାଃ ବିଷାଏରେ କାଜି ଆଡଃ ବିଚାର୍‌ ନାଗେନ୍ତେ ଆଇଁୟାଃତାଃରେ ପୁରାଃଗି କାଜି ମେନାଃ । ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‌ନିଃ ସାର୍‌ତିଗିୟାଏ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନିଃତାଃଏତେ ଆୟୁମ୍‍କାଦ୍‍ତେୟାଃ ସବେନାଃ ଅତେଦିଶୁମ୍‌ରେ ଉଦୁବେତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ୟୀଶୁ ଆପୁଆଃ ବିଷାଏରେ ଇନ୍‌କୁକେ କାଜିୟାକତାନ୍‌ ତାଇକେନାଏ, ଏନା ଇନ୍‌କୁ କାକ ଆଟ୍‌କାର୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ଏନ୍ତେ ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, “ଆପେ ଚିମ୍‌ତା ମାନୱାହନ୍‌କେ ଚେତାନ୍‌ତେପେ ରାକାବିୟା, ଇମ୍‌ତା ଆଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ଗି ଇନିଃ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେପେ ସାରିୟାଃ ଆଡଃ ଆଇଙ୍ଗ୍‌ଏତେ ଜେତ୍‌ନାଃ କାଇଙ୍ଗ୍‌ କାମି, ମେନ୍‌ଦ ଆପୁ ଇତୁଆକାଇଙ୍ଗ୍‌ଲେକା ନେ କାଜିକଇଙ୍ଗ୍‌ କାଜିକାଦା ମେନ୍ତେପେ ଆଟ୍‌କାର୍‌ଉରୁମେୟାଁ । ");
INSERT INTO unx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ଆଡଃ ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‌ନିଃ ଆଇଙ୍ଗ୍‌ଲଃରିୟା, ଇନିଃ ଆଇଙ୍ଗ୍‌କେ ଏସ୍‍କାର୍‍ଗି କାଏ ବାଗିୟାକାଦିୟାଁ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଜାନାଅଗି ଇନିଃକେ ସୁକୁଆଇଲେକା କାମିରିକାଇଃକ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ୟୀଶୁ ନେୟାଁ କାଜିତାନ୍ ତାଇକେନ୍‌ରେ ପୁରାଃ ହଡ଼କ ଇନିଃତାଃରେକ ବିଶ୍ୱାସ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ଏନ୍ତେ ୟୀଶୁତାଃରେ ଅକନ୍‌ ଯିହୁଦୀକ ବିଶ୍ୱାସ୍‌ତାନ୍‌କ ତାଇକେନା, ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେ ଆଇଁୟାଃ ଇନିତୁ ମାନାତିଙ୍ଗ୍‌ରେଦ ସାର୍‌ତିଗି ଆଇଁୟାଃ ଚେଲାକ ତାନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ଆଡଃ ଆପେ ସାର୍‌ତିକେ ଆଟ୍‌କାରେୟା, ଆଡଃ ଏନ୍‌ ସାର୍‍ତିଗି ଆପେକେ ଆଡ଼ାଃପେୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ଇନ୍‌କୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଆଲେଦ ଆବ୍ରାହାମ୍‌ଆଃ କିଲିରେନ୍‌କ ତାନ୍‍ଲେ ଆଡଃ ଚିଉଲାହଗି ଜେତାଏକଆଃ ଦାସି କାଲେ ତାଇକେନା ଚିନାଃମେନ୍ତେ ଆପେ ରାଡ଼ାଅଆଃପେ ମେନ୍ତେମ୍‌ କାଜିତାନା ? ନେୟାଁରାଃ ମୁଣ୍ଡି ଚିନାଃ ତାନାଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌ ପାପ୍‌କାମିତାନ୍‍ ସବେନ୍‌କ ପାପ୍‍ରେୟାଃ ଦାସିତାନ୍‍କୁ । ");
INSERT INTO unx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ଦାସି ଜାନାଅ ଜାନାଅ ଅଡ଼ାଃରେ କାଏ ତାଇନାଃ ମେନ୍‌ଦ ହନ୍‌ ଜାନାଅ ଜାନାଅ ତାଇନାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ଏନାମେନ୍ତେ ହନ୍‌ ରାଡ଼ାପେରେଦ, ଆପେ ସାର୍‍ତିଗିପେ ରାଡ଼ାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ଆପେ ଆବ୍ରାହାମ୍‌ଆଃ କିଲିରେନ୍‌କ ତାନ୍‌ପେ ନେୟାଁ ଆଇଙ୍ଗ୍‌ ସାରିତାନାଇଙ୍ଗ୍‌ ମେନ୍‌ଦ ଆଇଁୟାଃ ଇନିତୁ କାପେ ତେଲାଏତାନା ଏନାମେନ୍ତେ ଆପେ ଆଇଙ୍ଗ୍‌କେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ତାନାପେ । ");
INSERT INTO unx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ଆଇଙ୍ଗ୍‌ ଆପୁଇଙ୍ଗ୍‌ତାଃରେ ନେଲାକାଦ୍‌ତେୟାଃ କାଜିତାନାଇଙ୍ଗ୍‌ ମେନ୍‌ଦ ଆପେ ଆପେୟାଃ ଆପୁ କାଜିକାଦ୍‍ଲେକା କାମିୟାଃପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ଇନ୍‌କୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଆବ୍ରାହାମ୍‌ ଆଲେୟାଃ ଆପୁ ତାନିଃ ।” ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେ ସାର୍‌ତିଗି ଆବ୍ରାହାମ୍‌ଆଃ ହନ୍‌ ତାନ୍‍ପେରେଦ ଆବ୍ରାହାମ୍‌ଆଃ କାମି ଲେକା କାମିତେୟାଃପେ । ");
INSERT INTO unx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ଆଇଙ୍ଗ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ଆୟୁମ୍‌କେଦ୍‌ ସାର୍‌ତିକାଜି ବାଗିକେଦ୍‌ତେ ଏଟାଃତେୟାଃ କାଇଙ୍ଗ୍‌ ଉଦୁବାପେତାନା ହଲେହଁ ଆଇଙ୍ଗ୍‌କେ ନାହାଁଃ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ତାନାପେ, ଆବ୍ରାହାମ୍‌ ଏନ୍‍ଲେକା କାମି କାଏ କାମିକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ଆପେ ସବେନ୍‌ ଆପେୟାଃ ଆପୁଆଃ କାମିକ ରିକାତାନାପେ ।” ଇନ୍‌କୁ ୟୀଶୁକେ କାଜିକିୟାଃକ, “ଆଲେ ଆପାଙ୍ଗିର୍‌ କାମିରେନ୍‌ ହନ୍‌କ ନାହାଁଲାଲେ । ଆଲେୟାଃଦ ମିଆଁଦ୍‌ଗି ଆପୁ ଇନିଃଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେୟାଃ ଆପୁ ତାନିଃରେଦ ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ତେୟାଃପେ ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ହିଜୁଃକାନାଇଙ୍ଗ୍‌ ଆଡଃ ନାହାଁଃ ନେତାଃରିୟାଁ । ଆଇଙ୍ଗ୍‌ଦ ଆଇଁୟାଃ ପେଡ଼େଃତେ କାଇଙ୍ଗ୍‌ ହିଜୁଆକାନା ମେନ୍‌ଦ ଆପୁ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁଏ । ");
INSERT INTO unx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ଆପେ ଆଇଁୟାଃ କାଜି ଚିନାଃ ମେନ୍ତେ କାପେ ଆଟ୍‌କାର୍‌ଉରୁମେତାନା ? ଚିୟାଃଚି ଆପେଦ ଆଇଁୟାଃ ଇନିତୁ ଆୟୁମ୍‌ ନାଙ୍ଗ୍‌ କାପେ ସାହାତିଙ୍ଗ୍‌ ଦାଡ଼ିତାନା । ");
INSERT INTO unx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ଆପେ ଆପେୟାଃ ଆପୁ ସାଏତାନ୍‌ରାଃ ହନ୍‌କ ତାନ୍‌ପେ ଆଡଃ ଆପେୟାଃ ଆପୁଆଃ ସାନାଙ୍ଗ୍‌ଲେକା କାମି ସାନାଙ୍ଗ୍‌ତାନାପେ । ଇନିଃ ମୁନୁଏତେ ହଡ଼ ଗଗଏଃନିଃ ତାଇକେନାଏ ଆଡଃ ସାର୍‌ତିରେ କାଏ ତିଙ୍ଗୁ କେଟେଦ୍‌ୟାନା, ଚିୟାଃଚି ଇନିଃରେଦ ସାର୍‌ତି ବାନଆ । ଇନିଃ ହସଡ଼ କାଜି କାଜିତାନ୍ ଇମ୍‌ତା ଆୟାଃତେଗି କାଜିୟାଏ ଚିୟାଃଚି ଇନିଃଦ ହସଡ଼ନିଃ ଆଡଃ ହସଡ଼ରେନ୍ ଆପୁ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିତାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ ଆଇଁୟାଃ କାଜି କାପେ ପାତିୟାରେତାନା । ");
INSERT INTO unx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ଆଇଁୟାଃତାଃରେ ପାପ୍‌ ମେନାଃ ମେନ୍ତେ ଆପେକଏତେ ଅକଏ ଚିଟାଇଙ୍ଗ୍‌ୟାଁଏ ? ଆଇଙ୍ଗ୍‌ ସାର୍‌ତି କାଜି କାଜିରେଦ ଚିନାଃ ମେନ୍ତେ ଆଇଁୟାଃ କାଜିକେ କାପେ ପାତିୟାରେତାନା ? ");
INSERT INTO unx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଜେତାଏ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ହିଜୁଃକାନାଏ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି ଆୟୁମେୟାଏ । ଆପେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ କାପେ ହିଜୁଃକାନା ଏନାମେନ୍ତେ ଇନିୟାଃ କାଜି କାପେ ଆୟୁମେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ଯିହୁଦୀକ ୟୀଶୁକେ କୁଲିକିୟାଃକ, “ଆମ୍‌ ଶମିରୋନିରେନ୍ ତାନ୍‌ମେ ଆଡଃ ଆମ୍‌କେ ବଙ୍ଗା ଏସେରାକାଦ୍‍ମେୟାଁଏ, ନେୟାଁ ଚିନାଃ ଆଲେ ଠାଉକା କାଲେ କାଜିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ବାନଃଗି ଆଇଙ୍ଗ୍‌କେ ବଙ୍ଗା କାଏ ଏସେରାକାଦିୟାଁ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପୁଇଙ୍ଗ୍‌କେ ମାଇନିତାନାଇଙ୍ଗ୍‌ ଆଡଃ ଆପେ ଆଇଙ୍ଗ୍‌କେ କାପେ ମାଇନିଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ଆଇଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ଗି ଆଇଁୟାଃ ମାନାରାଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ଦାଣାଁଁତାନା ମେନ୍‌ଦ ମିଆଁଦ୍‌ନିଃ ମେନାଇୟା ଇନିଃ ଦାଣାଁଁଏଃ ଆଡଃ ବିଚାର୍‌ ରିକାଏଃ । ");
INSERT INTO unx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆଇଁୟାଃ କାଜି ମାନାତିଙ୍ଗ୍‌ନିଃ ଚିଉଲାଅ କାଏ ଗଜଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ଯିହୁଦୀକ ୟୀଶୁକେ କାଜିକିୟାଃକ, “ନାହାଁଃ ଆଲେ ସାରିକେଦାଃଲେ, ଆମ୍‌କେ ବଙ୍ଗା ଏସେରାକାଦ୍‍ମେୟାଏ, ଆବ୍ରାହାମ୍‌ ଆଡଃ ନାବୀକ ଗଏଃୟାନା ଆଡଃ ଆଇଁୟାଃ କାଜି ମାନାତିଙ୍ଗ୍‌ନିଃ ଗନଏଃ ଚିଉଲାଅ କାଏ ନେଲେୟା ମେନ୍ତେ କାଜିତାନାମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ଚିୟାଃ ଆମ୍‌ ଆଲେୟାଃ ଗଏଃକାନ୍‌ ଆପୁ ଆବ୍ରାହାମ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ଆଁମ୍‌ ? ନାବୀକହଗି ଗଏଃୟାନାକ, ଆମ୍‌ ଆମ୍‌ଗି ଅକଏ ମେନ୍ତେମ୍ ଉଡ଼ୁଃତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃଗି ମାନାରାଙ୍ଗ୍‌ଲେରେଦ ଆଇଁୟାଃ ମାନାରାଙ୍ଗ୍‌ ଜେତ୍‌ନାଃ ବାନଆଃ । ଅକନ୍‌ ଆପୁଇଙ୍ଗ୍‌କେ ଆପେ ଆଲେୟାଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ମେତାଇତାନାପେ, ଇନିଃ ଆଇଁୟାଃ ମାନାରାଙ୍ଗ୍‌ ରିକାଏତାନା । ");
INSERT INTO unx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ଏନ୍‍ରେୟ ଆପେ ଇନିଃକେ କାପେ ସାରିତାନା, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ସାରିୟାଃଇଙ୍ଗ୍‌, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ମେନ୍ତେ କାଜିରେଦ ଆଇଙ୍ଗ୍‌ହଗି ଆପେଲେକାଇଙ୍ଗ୍‌ ହସଡ଼ଃତେୟାଃ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ସାରିୟାଃଇଙ୍ଗ୍‌ ଆଡଃ ଇନିୟାଃ କାଜି ମାନାତିଙ୍ଗ୍‌ ତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ଆପେୟାଃ ଆପୁ ଆବ୍ରାହାମ୍‌ ଆଇଁୟାଃ ହିଜୁଃ ହୁଲାଙ୍ଗ୍‌କେ ନେନେଲ୍ ନାଗେନ୍ତେ ରାସ୍‌କାଅଃତାନାଏ ତାଇକେନା ଆଡଃ ଏନା ନେଲ୍‌କେଦ୍‌ତେ ରାସ୍‌କାୟାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ଏନ୍ତେ ଯିହୁଦୀକ ଇନିଃକେ କାଜିକିୟାଃକ, “ଆମ୍‌କେଦ ନାହାଁଃ ଜାକେଦ୍‌ ପାଚାଶ୍‌ ବାରାଷ୍‌ କା ହବାକାନା, ଚିୟାଃ ଆମ୍‌ ଆବ୍ରାହାମ୍‌କେ ନେଲାକାଇୟାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆବ୍ରାହାମ୍‌ଆଃ ଜାନାମ୍‌ ସିଦାଏତେ ଆଇଙ୍ଗ୍‌ ମେନାଇୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଚିଦ୍‍ଗି ନାଗେନ୍ତେ ଦିରିକ ସାବ୍‌କେଦା, ମେନ୍‌ଦ ୟୀଶୁ ଉକୁକେଦ୍‌ତେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ୟୀଶୁ ସେନଃତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଜାନାମ୍‌ଏତେ କାଣାଁକାନ୍‍ ମିଆଁଦ୍‌ ହଡ଼କେ ନେଲ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ଆଡଃ ଇନିୟାଃ ଚେଲାକ ଇନିଃକେ କୁଲିକିୟାଃକ, “ହେ ଗୁରୁ, ଅକଏୟାଃ ପାପ୍‌ ଖାତିର୍‌ ନିଃ କାଣାଁକେଦ୍‌ତେ ଜାନାମ୍‍ୟାନାଏ ? ଚିୟାଃ ଆୟାଃ ପାପ୍‌ତେଗିଚି ଆୟାଃ ଏଙ୍ଗା ଆପୁକିନାଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଇନିୟାଃ କାଣାଁକାନ୍‌ତେୟାଃ ଆୟାଃ ଚାଏ ଆୟାଃ ଏଙ୍ଗା ଆପୁକିନାଃ ପାପ୍‌ ନାଗେନ୍ତେଦ କାହାଗି ମେନ୍‌ଦ ନିଃତାଃରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାମି ଉଦୁବଃକା ମେନ୍ତେ ଇନିଃ କାଣାଁକେଦ୍‌ତେ ଜାନାମ୍‌ କାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ସିଙ୍ଗି ତାଇନ୍‌ ତାଇନ୍‌ଗି ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‍ନିୟାଃ କାମି ଆବୁକେ କାମି ଲାଗାତିୟାଃଁ, ଅକ ଘାଡ଼ିରେ ଜେତାଏ କାକ କାମି ଦାଡ଼ିୟାଃ ଏନ୍‌ଲେକାନ୍‌ ନିଦା ହିଜୁଃତାନା । ");
INSERT INTO unx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ରେ ତାଇନ୍ ଜାକେଦ୍‌ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ମାର୍ସାଲ୍‌ ତାନିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ନେୟାଁ କାଜିକେଦ୍‌ତେ ୟୀଶୁ ଅତେରେ ବେଏକ୍‌କେଦାଏ ଆଡଃ ଏନ୍‍ ବେଏକ୍‌ହାସାକେ ଲସଦ୍‌କେଦ୍‌ତେ ଏନ୍‌ ହଡ଼ରାଃ ମେଦ୍‌ରେ ଗସଃକେଦାଏ, ଆଡଃ ଇନିଃକେ ମେତାଇୟାଏ, ");
INSERT INTO unx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“ଜୁ ସେନଃମେ ଆଡଃ ‘ଶିଲୋହ’ ନୁତୁମ୍‌ ବାନ୍ଦାରେ ଆବୁଙ୍ଗ୍‌ଅଃମେ ।” ଇନିଃ ସେନଃୟାନ୍ତେ ଆବୁଙ୍ଗ୍‌ୟାନାଏ ଆଡଃ ନେନେଲ୍‍ତାନ୍‍ଲଃ ଅଡ଼ାଃତେ ହିଜୁଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ଏନାତେ ହପର୍‌ଜାପାଃରେନ୍‍କ ଆଡଃ ଅକନ୍‌କ ଇନିଃକେ ସିଦା କଏଁତାନ୍‌ ନେଲାକାଇକ, କାଜିକେଦାଃକ “ଦୁବ୍‍କେଦ୍‌ତେ କଏଁତାନ୍‍ ତାଇକେନ୍‍ନିଃ ଚିୟାଃ ନିଃଗି ନାହାଲିଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ଚିମିନ୍‌କ କାଜିକେଦା, “ନିଃଗି ତାନିଃ” ଆଡଃ ଏଟାଃକ କାଜିକେଦା, “ବାନଃ ନିଃ ଇନିଃଲେକାନିଃ ତାନିଃ ।” ଏନାତେ ଇନିଃ ଆଇଃକ୍‌ଗି କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ଇନିଃଗି ତାନିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ କୁଲିକିୟାଃକ, “ଚିଲ୍‌କାତେ ନାହାଁଃ ଆମ୍‌ ନେଲ୍‌ଦାଡ଼ିତାନାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ଇନିଃ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଏନ୍‍ ୟୀଶୁ ନୁତୁମ୍‌ ହଡ଼ ବେଏକ୍‌ହାସାକେ ଲସଦ୍‌କେଦ୍‌ତେ ଆଇଁୟାଃ ମେଦ୍‍ରେ ଗସଃକେଦାଏ ଆଡଃ ଶିଲୋହରେୟାଃ ବାନ୍ଦାତେ ସେନ୍‌କେଦ୍‌ତେ ଆବୁଙ୍ଗ୍‌ଅଃମେ ମେତାଦିୟାଁଏ । ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ସେନ୍‌କେଦ୍‌ତେ ଆବୁଙ୍ଗ୍‌ୟାନ୍‌ ତର୍‌ସା ନେଲ୍‌ ଦାଡ଼ିକେଦାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ଇନ୍‌କୁ ଇନିଃକେ କୁଲିକିୟାଃକ, “ଇନିଃ କତାଃରିୟା ?” ଇନିଃ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ଏନ୍ତେ ଜାନାମ୍‌ଏତେ କାଣାଁତାଇକେନ୍‌ ହଡ଼କେ ଇନ୍‌କୁ ଫାରୁଶୀକତାଃତେ ଇଦିକିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ୟୀଶୁ ଅକନ୍‌ ହୁଲାଙ୍ଗ୍‌ ହାସା ଲସଦ୍‌କେଦ୍‍ତେ କାଣାଁ ହଡ଼ରାଃ ମେଦ୍‌ ବୁଗିକାଇତାଇକେନାଏ, ଏନା ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ଏନାମେନ୍ତେ ଇନିଃ ଚିଲ୍‌କାତେ ନେଲ୍‌ ଦାଡ଼ିକେନାଏ, ଏନା ଫାରୁଶୀକ ଇନିଃକେ ଆଡଃମିସା କୁଲିକିୟାଃକ । ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଇନିଃ ଆଇଁୟାଃ ମେଦ୍‌ରେ ଲସଦ୍‌ ହାସାକେ ଗସଃକେଦାଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆବୁଙ୍ଗ୍‌ୟାନାଇଙ୍ଗ୍‌ ଏନ୍ତେ ନାହାଁଃ ନେଲ୍‌ ଦାଡ଼ିତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ଏନ୍ତେ ଫାରୁଶୀକଏତେ ଚିମିନ୍‌କ କାଜିକେଦା, “ନେୟାଁ କାମିକାଦ୍‌ ହଡ଼ ପାର୍‌ମେଶ୍ୱାର୍‌ସାଃଏତେ ନାହାଁଲିଃ, ଚିୟାଃଚି ଇନିଃଦ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌କେ କାଏ ମାନାତିଙ୍ଗ୍‌ତାନା ।” ଆଡଃ ଏଟାଃକ କାଜିକେଦା, “ପାପିହଡ଼ ଚିଲ୍‌କାତେ ନେ ଲେକାନ୍ ପେଡ଼େୟାନ୍‌ କାମିକ କାମିଦାଡ଼ିୟାଏ ?” ଏନ୍ତେ ଆକଆଃ ଥାଲାରେ ବିପିଙ୍ଗାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ଏନାମେନ୍ତେ ଫାରୁଶୀକ ଏନ୍‌ ହଡ଼କେ ଆଡଃମିସା କୁଲିକିୟାଃକ, “ଆମାଃ ମେଦ୍‌ ବୁଗିକେଦ୍‌ମେୟାଏ ଇନିୟାଃ ବିଷାଏରେ ଆମ୍‌ ଚିନାଃମ୍‌ ମେନେତାନା ?” ଇନିଃ ମେତାଦ୍‌କଆଏ, “ଇନିଃ ମିଆଁଦ୍‌ ନାବୀ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ଇନିଃ କାଣାଁ ତାଇକେନାଏ ଆଡଃ ନାହାଁଃ ନେଲ୍‌ ଦାଡ଼ିକେଦାଏ, ଏନ୍‌ ମେଦ୍‌ ବୁଗିୟାକାନ୍‌ ହଡ଼ଆଃ ଏଙ୍ଗା ଆପୁକିନ୍‌କେ ଆଉରି କୁଲିକିନ୍‌ ଜାକେଦ୍‌ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କ କାକ ପାତିୟାର୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ଆଡଃ ଇନ୍‌କୁ ଇନ୍‌କିନ୍‌କେ କୁଲିକେଦ୍‍କିନାକ, “ମେଦ୍‌ କାଣାଁକେଦ୍‍ତେ ଜାନାମାକାନ୍‍ ହନ୍‌ ତାବେନାଃ ନିଃଗି ତାନିଃଚି ? ଚିଲ୍‌କାତେ ନାହାଁଃ ଇନିଃ ନେଲ୍‌ ଦାଡ଼ିତାନାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ଇନିୟାଃ ଏଙ୍ଗାଆପୁକିନ୍‌ ମେତାଦ୍‌କଆକିନ୍‌, “ଇନିଃ ଆଲିଙ୍ଗ୍‌ୟାଁଃ ହନ୍‌ ତାନିଃ ଆଡଃ ମେଦ୍‌ କାଣାଁକେଦ୍‌ତେ ଜାନାମ୍‍କାନ୍‌ ତାଇକେନାଏ ନେୟାଁଲିଙ୍ଗ୍‌ ସାରିକାଦା, ");
INSERT INTO unx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ମେନ୍‌ଦ ଇନିଃ ଚିଲ୍‌କାତେ ନାହାଁଃ ନେଲ୍‌ ଦାଡ଼ିତାନାଏ ଏନା କାଲିଙ୍ଗ୍‌ ସାରିୟାଃ, ଚାଏ ଅକଏ ଇନିୟାଃ ମେଦ୍‌ ବୁଗିକିୟାଏ ଏନାହ କାଲିଙ୍ଗ୍‌ ସାରିୟାଃ । ଇନିଃକେ କୁଲିପେ, ଇନିଃଦ ସେୟାନାନ୍‌ଗିୟାଏ, ଆୟାଃ କାଜି ଆଇଃକ୍‌ଗି କାଜିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ଇନିୟାଃ ଏଙ୍ଗାଆପୁକିନ୍ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କଆଃ ବରତେ ନେ ସବେନାଃକିନ୍ କାଜିକେଦା, ଚିୟାଃଚି ଜେତାଏ ୟୀଶୁକେ ମାସି ତାନିଃ ମେନ୍ତେ ମାନାତିଙ୍ଗ୍‌ରେଦ ଇନିଃ ସାମାଜ୍‌ଅଡ଼ାଃଏତେ ଆତମଃଆଏ ମେନ୍ତେ ଯିହୁଦୀକ ଆକ ଆକରେକ ରୋଜୋଟକାଦ୍ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ଏନାମେନ୍ତେ ଇନିୟାଃ ଏଙ୍ଗାଆପୁକିନ୍‌ କାଜିୟାଦ୍‌କଆକିନ୍‌, “ଇନିଃ ସେୟାନାନ୍‌ଗିୟାଏ; ଇନିଃକେ କୁଲିପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ଏନ୍ତେ ଇନ୍‌କୁ ଏନ୍‌ ମେଦ୍‌ କାଣାଁକାନ୍‌ ହଡ଼କେ ଆଡଃମିସା କେଡ଼ାକେଦ୍‍ତେ କାଜିକିୟାଃକ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆୟାର୍‌ରେ କିରିୟାକେଦ୍‌ତେ ସାର୍‌ତି କାଜିମେ, “ଆଲେ ସାରିତାନାଲେ ଅକ ହଡ଼ ଆମ୍‌କେ ନେନେଲ୍‌ ନାଙ୍ଗ୍‌ ପେଡ଼େଃ ଏମାକାଦ୍‌ମେୟାଁଏ, ଇନିଃ ପାପିତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ଏନ୍ତେ ଇନିଃ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଇନିଃ ପାପିହଡ଼ ତାନିଃ ଚାଏ ନାହାଁଲିଃ ଏନା କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ? ମିଆଁଦ୍‌ କାଜି ସାରିତାନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ କାଣାଁ ତାଇକେନାଇଙ୍ଗ୍‌, ଆଡଃ ନାହାଁଃ ନେଲ୍‌ ଦାଡ଼ିତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଆଡଃଗି କୁଲିକିୟାଃକ, “ଇନିଃ ଚିକ୍‌ନାଃ ଚିକାକେଦ୍‍ମେୟାଏ ? ଆଡଃ ଚିଲ୍‌କାତେ କାଣାଁକାନ୍‌ ମେଦ୍‌ତାମାଃ ବୁଗିକେଦ୍‌ମେୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ଇନିଃ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ସିଦାରେ ଆପେକେ କାଜିୟାଦ୍‌ପେୟାଇଙ୍ଗ୍‌, ଆଡଃ ଆପେ କାପେ ଆୟୁମ୍‌କେଦାଃ, ଚିନାଃ ମେନ୍ତେ ଆଡଃଗି ଆୟୁମ୍‌ ସାନାଙ୍ଗ୍‌ତାନାପେ ? ଚିୟାଃ ଆପେୟଚି ଇନିୟାଃ ଚେଲା ବାଇୟଃ ସାନାଙ୍ଗ୍‌ତାନାପେ ?” ");
INSERT INTO unx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ସାର୍‌ପାଅକେଦ୍‌ତେ କାଜିକିୟାଃକ, “ଆମ୍‌ ଇନିୟାଃ ଚେଲା ତାନ୍‌ମେ ମେନ୍‌ଦ ଆଲେ ମୁଶାରାଃ ଚେଲାକ ତାନ୍‍ଲେ । ");
INSERT INTO unx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ମୁଶାଲଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଜାଗାର୍‍ତାନ୍ ତାଇକେନାଏ ନେୟାଁଲେ ସାରିତାନା ମେନ୍‌ଦ ନିଃ କତାଃଏତେ ହିଜୁଃକାନାଏ, ଏନା କାଲେ ସାରିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ଏନ୍‍ ହଡ଼ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‍କଆଏ, “ଇନିଃ କତାଃଏତେ ହିଜୁଃକାନାଏ ଏନା କାପେ ସାରିୟାଃ ଆଡଃ ଇନିଃ ଆଇଁୟାଃ ମେଦ୍‌ ବୁଗିକେଦିୟାଁଏ, ନେୟାଁଦ ଆକ୍‌ଦାନ୍ଦାଅ କାଜିତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ପାର୍‌ମେଶ୍ୱାର୍‌ ପାପିକଆଃ ବିନ୍ତି କାଏ ଆୟୁମାଃ, ନେୟାଁବୁ ସାରିତାନା, ମେନ୍‌ଦ ଜେତାଏ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ସୁସାରିରେଦ ଆଡଃ ଆୟାଃ ମନେଲେକାତେ ସେସେନ୍‍ରେଦ ଇନିୟାଃ ବିନ୍ତି ଆୟୁମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ଅତେଦିଶୁମ୍‌ରେୟାଃ ମୁନୁଏତେ ଜେତାଏ ହଡ଼ ଜାନାମ୍‌କାଣାଁକେ ବୁଗିତେୟାଃ, ଚିଉଲାହ କା ଆୟୁମ୍‌କାନା । ");
INSERT INTO unx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ନେ ହଡ଼ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ କାଏ ହିଜୁଃକାନ୍‌ରେଦ ଚିଉଲାହ ଜେତ୍‌ନାଃ କାଏ କାମି ରିକାଦାଡ଼ିତେୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ଇନ୍‌କୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଃକ, “ଆମ୍‌ଦ ପାପ୍‌ରେ ଜାନାମ୍‌କେଦ୍‌ତେ ପାପ୍‌ରେ ମେନାମେଆ ଆଡଃ ଆମ୍‌ଚି ଆଲେକେ ଇତୁ ସାନାଙ୍ଗ୍‌ତାନାମ୍‌ ?” ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ସାମାଜ୍‌ଅଡ଼ାଃଏତେ ବାହାରି ଅଡଙ୍ଗ୍‌କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ଇନ୍‌କୁ ଇନିଃକେ ସାମାଜ୍‌ଅଡ଼ାଃଏତେ ବାହାରି ଅଡଙ୍ଗ୍‌କିୟାଃକ, ନେୟାଁ ୟୀଶୁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନିଃକେ ନେଲ୍‍ନାମ୍‍ତାଇଲଃ କୁଲିକିୟାଏ, “ଚିୟାଃ ଆମ୍‌ ମାନୱାହନ୍‌ତାଃରେ ବିଶ୍ୱାସେତାନାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ଇନିଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେ ପ୍ରାଭୁ, ଇନିଃ ଅକଏ ତାନିଃ କାଜିମେ, ଆଇଙ୍ଗ୍‌ଦ ଇନିଃରେ ବିଶ୍ୱାସେଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆମ୍‌ ଇନିଃକେ ନେଲାକାଇୟାମ୍‌, ଆଡଃ ଇନିଃ ଆମାଃଲଃ ଜାଗାର୍‍ତାନ୍‌ନିଃଗି ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ଏନ୍ତେ ଇନିଃ “ହେ ପ୍ରାଭୁ, ଆଇଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ ତାନାଇଙ୍ଗ୍‌” ମେତାଇୟାଏ ଆଡଃ ଇନିଃକେ ଅମ୍ବାଃକେଦ୍‌ତେ ଜହାର୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ୟୀଶୁ ମେତାଇୟାଏ, “ହଡ଼କଆଃ ବିଚାର୍‌ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ।” କା ନେଲ୍‍ତାନ୍‍କ ନେଲେୟାକ ଆଡଃ ନେନେଲ୍‌ତାନ୍‌କ କାଣାଁୱାଃ । ");
INSERT INTO unx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ଇନିଃଲଃ ତାଇକେନ୍‌ ଫାରୁଶୀକ ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ମେନ୍‍କେଦାଃକ, “ଚିୟାଃ ଆଲେୟଚି କାଣାଁକାନାଲେ ?” ");
INSERT INTO unx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେ କାଣାଁକାନ୍‌ରେଦ ଆପେୟାଃ ପାପ୍‌ କା ତାଇନ୍‍ତେୟାଃ, ମେନ୍‌ଦ ଆଲେ ନେଲେତାନାଲେ, ନେୟାଁ ନାହାଁଃ କାଜିତାନାପେ ଏନାମେନ୍ତେ, ଆପେୟାଃ ପାପ୍‌ ତାଇନଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ୟୀଶୁ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଜେତାଏ ଦୁଆର୍‌ହରା ମିଣ୍ଡିଅଡ଼ାଃରେ କା ବଲଃନିଃ ମେନ୍‌ଦ ଏଟାଃସାଃଏତେ ରାକାବ୍‍କେଦ୍‍ତେ ବଲଃନିଃ, କୁମ୍ବୁଡ଼ୁ ଆଡଃ ରେରେଃକ୍‌ନିଃ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ଦୁଆର୍‌ହରା ବଲଃନିଃ ମିଣ୍ଡିକଆଃ ଗୁପିନିଃ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ଇନିୟାଃ ନାଗେନ୍ତେ ଦୁଆର୍‌ ହରନିଃ ଦୁଆର୍‌ ନିଜେୟାଏ ଆଡଃ ଇନିଃ ଆୟାଃ ମିଣ୍ଡିକକେ ନୁତୁମ୍‌ ସାବ୍‌କେଦ୍‌ତେ ହାକାଅକରେ ମିଣ୍ଡିକ ଇନିୟାଃ କାଜିକ ଆୟୁମାଃ ଆଡଃ ଇନିଃ ବାହାରି ଅଡଙ୍ଗ୍‌ଇଦିକଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ଆଡଃ ଆୟାଃ ସବେନ୍‌ ମିଣ୍ଡିକକେ ବାହାରି ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଆଃ ଆୟାର୍‌ ଆୟାର୍‌ରେ ସେସେନାଏ ଆଡଃ ମିଣ୍ଡିକ ସବେନ୍‌ ଆୟାଃ ଦୟା ଦୟାତେକ ଅତଙ୍ଗ୍‌ଇଁୟା ଚିୟାଃଚି ଇନ୍‍କୁଦ ଇନିୟାଃ ଲାବ୍‌ଜାକ ସାରିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ମେନ୍‌ଦ ଇନ୍‌କୁ ଏଟାଃନିଃକେ ଚିଉଲାହ କାକ ଅତଙ୍ଗ୍‌ଇଁୟା ମେନ୍‌ଦ ଇନିଃତାଃଏତେ ସାଙ୍ଗିନ୍‌ତେକ ନିରାଃ, ଚିୟାଃଚି ଇନ୍‍କୁଦ ଇନିୟାଃ ଲାବ୍‌ଜା କାକ ସାରିୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ୟୀଶୁ ନେ ଜନ୍‌କା କାଜି କାଜିୟାଦ୍‌କଆଏ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନିୟାଃ କାଜିକେଦ୍‌କାଜି ଚିନାଃତାନାଃ ଏନା କାକ ମୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ଏନ୍ତେ ୟୀଶୁ ଆଡଃମିସା କାଜିୟାଦ୍‌କଆଏ, “ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ମିଣ୍ଡିକଆଃ ଦୁଆର୍‌ ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ଆଇଁୟାଃଏତେ ସିଦାରେ ହିଜୁଆକାନ୍‍ ସବେନ୍‌କ କୁମ୍ବୁଡ଼ୁ ଆଡଃ ରେରେଃକ୍‌କ ତାନ୍‍କୁ ମେନ୍‌ଦ ମିଣ୍ଡିକ ଇନ୍‌କୁଆଃ କାଜି କାକ ଆୟୁମ୍‍କେଦା । ");
INSERT INTO unx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ଦୁଆର୍‌ ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌, ଜେତାଏ ଆଇଁୟାଃ ହରାତେ ବଲରେଦ ଇନିଃ ବାଞ୍ଚାଅଃଆଏ, ଇନିଃ ଭିତାର୍‌ତେ ଅଡଙ୍ଗ୍‌ ବଲଃରେ ଚାରା ନାମେଗିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","କୁମ୍ବୁଡ଼ୁଦ କୁମ୍ବୁଡ଼ୁ, ଗଗଏଃ ଆଡଃ ଜିୟନ୍‌ ନାଗେନ୍ତେ ଏସ୍‌କାର୍‌ ହିଜୁଆଏଃ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଜୀଦାନ୍‌କ ନାମେକା, ଆଦ୍‌କାଗି ନାମେକା ମେନ୍ତେଇଙ୍ଗ୍‌ ହିଜୁଆକାନା । ");
INSERT INTO unx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ଆଇଙ୍ଗ୍‌ ଏନ୍‌ ବୁଗିନ୍‌ ଗୁପିନିଃ ତାନିଙ୍ଗ୍‌, ବୁଗିନ୍‌ ଗୁପିନିଃ ମିଣ୍ଡିକ ନାଗେନ୍ତେ ଆୟାଃ ଜୀଉ ଏମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ଅକଏ ଗୁପିନିଃ ନାହାଲିଃ, ଇନିଃଦ ନାଲାନାମ୍‌ନିଃ ତାନିଃ ଆଡଃ ମିଣ୍ଡିକ ଆୟାଃ ନାହାଁଲାଃକ ଏନାମେନ୍ତେ ଇନିଃ ହୁଣ୍ଡାର୍‌ ହିଜୁଃତାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ମିଣ୍ଡିକକେ ନିର୍‌ ବାଗିତାକୁଆଏ ଆଡଃ ହୁଣ୍ଡାର୍ ମିଣ୍ଡିକକେ ରେଃକ୍‌କେଦ୍‌ତେ ଛିତିବିତି ତାକଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ଏନ୍‌ ହଡ଼ ନିର୍‌ ବାଗିତାକୁଆଏ, ଚିୟାଃଚି ଇନିଃ ନାଲାନାମ୍‌ନିଃ ତାନିଃ ଆଡଃ ମିଣ୍ଡିକ ନାଗେନ୍ତେ କାଏ ଉଡ଼ୁଃୟା । ");
INSERT INTO unx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ଆଇଙ୍ଗ୍‌ ବୁଗିନ୍‌ ଗୁପିନିଃ ତାନିଙ୍ଗ୍‌, ଜେ'ଲେକା ଆପୁଇଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌କେ ସାରିୟାଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପୁଇଙ୍ଗ୍‌କେ ସାରିୟାଇଙ୍ଗ୍‌, ");
INSERT INTO unx_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ଏନ୍‌ଲେକାଗି ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ମିଣ୍ଡିକକେ ସାରିୟାଇଙ୍ଗ୍‌ ଆଡଃ ଆଇଁୟାଃ ମିଣ୍ଡିକ ଆଇଙ୍ଗ୍‌କେ ସାରିୟାଃକ । ଆଇଙ୍ଗ୍‌ ମିଣ୍ଡିକ ନାଗେନ୍ତେ ଆଇଁୟାଃ ଜୀଉ ଏମ୍‌ ନାଗେନ୍ତେ ସେକାଡ଼ାକାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ଆଇଁୟାଃ ଆଡଃଗି ଏଟାଃ ମିଣ୍ଡିକ ମେନାକଆ, ଇନ୍‌କୁ ନେ ମିଣ୍ଡିଅଡ଼ାଃରେନ୍‍ ନାହାଁଲାଃକ । ଇନ୍‍କୁକେହଗି ଆଇଙ୍ଗ୍‌କେ ଆଉ ଲାଗାତିୟାଃଁ ଆଡଃ ଇନ୍‌କୁ ଆଇଁୟାଃ ଲାବ୍‌ଜାକ ଆୟୁମେୟା ଏନ୍ତେ ମିଆଁଦ୍‌ ଗୋଟ୍‌ ଆଡଃ ମିଆଁଦ୍‌ ଗୁପିନିଃ ତାଇନାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଜୀଉକେ ଏମ୍‌କେଦ୍‌ ହରାତେ ଆପୁ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ ତାନାଏ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଜୀଉକେ ଆଡଃମିସା ନାମ୍‍ରୁହାଡ଼େ ନାଗେନ୍ତେ ଏମେତାନିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ଜେତାଏ ଆଇଁୟାଃ ଜୀଉକେ ଆଇଙ୍ଗ୍‌ତାଃଏତେ କାକ ଇଦିୟା ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ତେଗି ଏନାକେ ଏମାଃଇଙ୍ଗ୍‌ । ଏନାକେ ଏମ୍‌ ଆଡଃ ଇଦି ରୁହାଡ଼୍‌ରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ଆଇଁୟାଃ ମେନାଃ । ନେ ଆନ୍‌ଚୁ ଆଇଙ୍ଗ୍‌ ଆପୁଇଙ୍ଗ୍‌ତାଃଏତେ ନାମ୍‍କାଦାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଆଡଃଗି ନେ କାଜି ନାଗେନ୍ତେ ଯିହୁଦୀକ ବିପିଙ୍ଗାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ଇନ୍‌କୁଏତେ ପୁରାଃକ କାଜିକେଦା, “ଇନିଃକେ ବଙ୍ଗା ଏସେର୍‌କିୟାଏ, ଆଡଃ ଇନିଃ ବାଲୁଅଃତାନାଏ, ଇନିୟାଃ କାଜି ଚିନାଃ ମେନ୍ତେପେ ଆୟୁମେତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ମେନ୍‌ଦ ଏଟାଃକ କାଜିକେଦା, “ବାନଃଗି ବଙ୍ଗା ଏସେର୍‌କାଇ ହଡ଼ ନେ ଲେକା କାଏ କାଜିୟା, ଚିୟାଃ ବଙ୍ଗା ମେଦ୍‌ କାଣାଁକାନ୍‌ନିଃକେ ବୁଗି ଦାଡ଼ିୟାଏ ?” ");
INSERT INTO unx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ଏନ୍ତେ ଯୀରୁଶାଲେମ୍‌ ମାନ୍ଦିର୍‌ଅଡ଼ାଃକେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ଜିମାଅଃରେୟାଃ ପାରାବ୍‌ ସେଟେର୍‌ୟାନା ଆଡଃ ଏନା ରାବାଙ୍ଗ୍‌ ସାହା ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ଆଡଃ ୟୀଶୁ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ସୁଲିମାନ୍‌ ନୁତୁମ୍‌ ପିଣ୍ଡ୍‌ଗିରେ ହନର୍‌ତାନ୍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ଏନ୍ତେ ଯିହୁଦୀକ ଇନିଃକେ ହୁଣ୍ଡି ବିୟୁର୍‍କିଃତେ କାଜିକିୟାଃକ, “ଆମ୍‌ ଆଲେକେ ଚିମିନ୍‍ ଜାକେଦ୍‌ ଆଲେୟାଃ ମନ୍‌ରେ ଆଡ଼ାଃଉଡ଼ୁଃରେମ୍ ଦହଲେୟା ? ଆମ୍‌ ମାସି ତାନ୍‍ମେରେଦ ଆଲେକେ କାଜିୟାଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆପେକେ ସିଦାରେ କାଜିୟାଦ୍‍ପେୟାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଆପେ କାପେ ପାତିୟାରେତାନା । ଆପୁଇଁୟାଃ ନୁତୁମ୍‌ତେ ପେଡ଼େୟାନ୍‌ କାମିକ ଆଇଙ୍ଗ୍‌ କାମିକାଦ୍ କାମି ଆଇଁୟାଃ ଗାୱା ଏମେତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ମେନ୍‌ଦ ଆପେ ଆଇଁୟାଃ ମିଣ୍ଡିକ ନାହାଁଲାପେ ମେନ୍ତେ କାପେ ପାତିୟାରେତାନା । ");
INSERT INTO unx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ଆଇଁୟାଃ ମିଣ୍ଡିକ ଆଇଁୟାଃ ଲାବ୍‌ଜାକ ଆୟୁମାଃ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେଇଙ୍ଗ୍‌ ସାରିୟାଃ, ଏନ୍ତେ ଇନ୍‌କୁ ଦୟା ଦୟାତେକ ଅତଙ୍ଗ୍‌ଇଁୟା । ");
INSERT INTO unx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ଜାନାଅ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌ ଏମାଃଇଙ୍ଗ୍‌, ଆଡଃ ଇନ୍‌କୁ ଚିଉଲାହ କାକ ଜିୟନଃଆ; ଆଇଁୟାଃ ତିଃଇଏତେ ଇନ୍‌କୁକେ ଜେତାଏ କାକ ରେଃକ୍‌ଇଦି ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ଆପୁଇଙ୍ଗ୍‌ ଅକ୍‌ନାଃ ଏମାକାଦିୟାଃଁଏ ଏନା ସବେନାଃଏତେ ମାରାଙ୍ଗ୍‌ଆଁଃ ଆଡଃ ଇନ୍‌କୁକେ ଆପୁଆଃ ତିଃଇଏତେ ଜେତାଏ କାକ ରେଃକ୍‌ଇଦି ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ଆଇଙ୍ଗ୍‌ ଆଡଃ ଆପୁଇଙ୍ଗ୍‌ ମିଆଁଦ୍‌ଗି ତାନ୍‍ଲିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ, ଯିହୁଦୀକ ଇନିଃକେ ଚିଦ୍‍ଗି ନାଗେନ୍ତେ ଆଡଃମିସା ଦିରିକ ହାଲାଙ୍ଗ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ମେନ୍‌ଦ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆପୁତାଃଏତେ ପୁରାଃ ବୁଗିନ୍‌ କାମିକ ଆପେକେଇଙ୍ଗ୍‌ ଉଦୁବାଦ୍‌ପେୟା, ଏନାଏତେ ଅକ କାମି ନାଗେନ୍ତେ ଚିଦ୍‍ଗିଙ୍ଗ୍‌ତାନାପେ ?” ");
INSERT INTO unx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ଯିହୁଦୀକ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଃକ, “ଆଲେ ଆମ୍‌କେ ବୁଗିନ୍‌ କାମି ନାଗେନ୍ତେ ଦିରି କାଲେ ଚିଦ୍‌ଗିମ୍‌ତାନା ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ନିନ୍ଦାଇତାନ୍‌ ନାଗେନ୍ତେ ଆଡଃ ଆମ୍‌ ହଡ଼ ତାନ୍‍ମେରେୟ ପାର୍‌ମେଶ୍ୱାର୍‌ ମେନ୍ତେ କାଜିନ୍‌ତାନାମ୍‍ ଏନାମେନ୍ତେ ଦିରି ଚିଦ୍‍ଗିମେତାନାଲେ ।” ");
INSERT INTO unx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆପେୟାଃ ଆନ୍‌ଚୁ ପୁଥିରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ମେନ୍‌କେଦାଏ, ‘ଆପେ ପାର୍‌ମେଶ୍ୱାର୍‌କ ତାନ୍‌ପେ ।’ ");
INSERT INTO unx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ଆଲେ ସାରିଆଃଲେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ଜାନାଅ ସାର୍‌ତିଗିଆ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି ଉଦୁବ୍‌ଲେନ୍‌କକେ ପାର୍‌ମେଶ୍ୱାର୍‌କ ତାନ୍‌ପେ ମେତାକତାନ୍‍ରେଦ ଆଡଃ ଧାରାମ୍‌ପୁଥିରେୟାଃ କାଜି କା ଆତମ୍‍ଦାଡ଼ିୟଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ଆପୁ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌କେ ସାଲାକେଦ୍‌ତେ ପାବିତାର୍‌ କାମି ନାଙ୍ଗ୍‌ ଜିମାଇଙ୍ଗ୍‌ତାନ୍‌ଲଃ ନେ ଅତେଦିଶୁମ୍‌ତେ କୁଲାକାଦିୟାଁ । ଆଇଙ୍ଗ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିକେଦାଃଇଙ୍ଗ୍‌, ଏନାତେଚି ଆପେ ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌କେମ୍‌ ନିନ୍ଦାଇତାନା ମେନ୍ତେପେ କାଜିୟାଇଙ୍ଗ୍‌ତାନା ? ");
INSERT INTO unx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ଆପୁଆଃ କାମିକ କାଇଙ୍ଗ୍‌ କାମିତାନ୍‍ରେଦ ଆଲ୍‌ପେ ପାତିୟାର୍‌ରିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଇନିୟାଃ ମନେଲେକା କାମିତାନ୍‍ରେଦ ଆଇଙ୍ଗ୍‌କେ କାପେ ପାତିୟାର୍‍ରେହଗି ଆଇଁୟାଃ ପେଡ଼େୟାନ୍‌କାମିକେ ବିଶ୍ୱାସେପେ, ଏନ୍ତେ ଆପୁ ଆଇଁୟାଃରିୟା ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପୁରିୟାଁ ନେଆଁଁ ଆପେ ଇତୁଆଃ ଆଡଃ ଆଟ୍‌କାର୍‍ଉରୁମେଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ଏନ୍ତେ ଆଡଃମିସା ଯିହୁଦୀକ ୟୀଶୁକେ ସାସାବ୍‍ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌କେଦାଃକ, ମେନ୍‌ଦ ଇନ୍‌କୁଆଃ ତିଃଇଏତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ଏନ୍ତେ ୟୀଶୁ ଆଡଃଗି ଯାର୍ଦାନ୍‌ ହାନ୍‍ପାର୍‍ମ୍‌ ଯୋହାନ୍‌ ସିଦା ବାପ୍ତିସ୍ମା ଏମାକତାନ୍ ତାଇକେନ୍‌ ଠାୟାଦ୍‌ତେ ସେନଃୟାନାଏ ଆଡଃ ଏନ୍ତାଃରେ ତାଇନ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ଆଡଃ ପୁରାଃ ହଡ଼କ ଇନିଃତାଃତେକ ହିଜୁଃୟାନା ଆଡଃ ଯୋହାନ୍‌ଦ ଜେତାନ୍‌ ପେଡ଼େୟାନ୍‌ କାମି କାଏ କାମିକେଦାଃ, ମେନ୍‌ଦ ଯୋହାନ୍‌ ଇନିୟାଃ ବିଷାଏରେ କାଜିକାଦ୍‌ ସବେନାଃ ସାର୍‌ତିଗି ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ଆଡଃ ଏନ୍ତାଃରେ ପୁରାଃ ହଡ଼କ ଇନିଃରେକ ପାତିୟାର୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେଥ୍‌ନିଆରେନ୍‌ ମିଆଁଦ୍‌ ଲାଜାର୍‌ ନୁତୁମ୍‌ ହଡ଼ ଉରିୟୁତେ ଦୁକୁତାନ୍‌ ତାଇକେନାଏ । ମାରିୟାମ୍‌ ଆଡଃ ଆୟାଃ ମିଶି ମାର୍ଥା ବାରାନ୍‌କିନ୍‌ ଏନ୍‌ ସାହାର୍‌ରେ ତାଇନ୍‌ ତାଇନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ଅକନ୍‌ କୁଡ଼ିଚି ପ୍ରାଭୁଆଃ କାଟାରେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ ଗସଃକିୟାଏ, ଆଡଃ ଇନିୟାଃ କାଟାକେ ଆୟାଃ ଉବ୍‍ତେ ଜଦ୍‍କେଦାଏ, ଇନିଃ ଏନ୍‍ ମାରିୟାମ୍‌ ତାନିଃ ଆଡଃ ଆୟାଃ ହାଗାତେ ଲାଜାର୍‌ ଉରିୟୁତାନାଏ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ଏନ୍ତେ ଏନ୍‌ ମିଶିକିନ୍ ୟୀଶୁତାଃତେ କାଜିକୁଲ୍‌କେଦାଃକିନ୍‌, “ହେ ପ୍ରାଭୁ ନେଲେମେ ଆମ୍‌ ଦୁଲାଡ଼ିତାନ୍‌ନିଃ ଉରିୟୁତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ୟୀଶୁ ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ତେ କାଜିକେଦାଃଏ, “ନେ ଦୁକୁ ଲାଜାର୍‌ଆଃ ଗନଏଃ ନାଗେନ୍ତେଦ କାହା, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାଇନାନ୍‌ ନାଗେନ୍ତେ ଆଡଃ ଏନାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ମାଇନାନ୍‌ନଃକାଏ ମେନ୍ତେ ଏନା ହବାକାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ୟୀଶୁଦ ମାର୍ଥା ଆଡଃ ଇନିୟାଃ ମିଶିତେ ମାରିୟାମ୍‍କେ ଆଡଃ ଲାଜାର୍‌କେ ଦୁଲାଡ଼୍‌କତାନ୍‍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ଲାଜାର୍ ଉରିୟୁତେ ଦୁକୁତାନାଏ ତାଇକେନା ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ ରେହଁ ୟୀଶୁ ତାଇକେନ୍‌ ଠାୟାଦ୍‍ତାଃରେ ଆଡଃ ବାର୍‍ସିଙ୍ଗ୍‌ ତାଇନ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ଏନ୍ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ କାଜିୟାଦ୍‌କଆଏ, “ଦଲା ଯିହୁଦା ନାଗାର୍‌ତେବୁ ସେନ୍‌ରୁହାଡ଼ାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ଚେଲାକ ୟୀଶୁକେ କାଜିକିୟାଃକ, “ହେ ଗୁରୁ, ଚିମିନ୍‌ ମାହାଁ ସିଦାରେ ଆମ୍‌କେ ଯିହୁଦୀକ ଦିରି ଚିଦ୍‍ଗିନାଙ୍ଗ୍‌କ ସାନାଙ୍ଗ୍‌ ତାଇକେନା, ହଲେହଁ ଆମ୍‌କେ ଏନ୍ତାଃତେ ଆଡଃଗି ସେନଃ ସାନାଙ୍ଗ୍‌ମେଁ ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ସିଙ୍ଗିସାଟୁବ୍‍ରେ ବାରା ଘାଣ୍ଟା ବାନଆଃଚି ? ଜେତାଏ ସିଙ୍ଗିମାସ୍କାଲ୍‌ରେ ସେସେନ୍‍ରେଦ କାଏ ତହଦଃଆ, ଚିୟାଃଚି ଇନିଃ ନେ ଅତେଦିଶୁମ୍‌ରାଃ ମାସ୍କାଲ୍‍କେ ନେଲାଏଃ । ");
INSERT INTO unx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ମେନ୍‌ଦ ଜେତାଏ ନିଦାରେ ସେସେନ୍‍ରେଦ ଇନିଃ ତହଦଃଆଏ, ଚିୟାଃଚି ଇନିୟାଃ ମାର୍ସାଲ୍‌ ବାନଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ନେୟାଁ କାଜିକେଦ୍‍ ତାୟମ୍‌ତେ ୟୀଶୁ ଆୟାଃ ଚେଲାକକେ ଆଡଃଗି ମେତାଦ୍‌କଆଏ, “ଆବୁଆଃ ଗାତି ଲାଜାର୍‌ ଦୁଡ଼ୁମାକାନାଏ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ଏୟନ୍‌ନାଙ୍ଗ୍‌ ସେନ୍‌ତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ଚେଲାକ ୟୀଶୁକେ କାଜିକିୟାଃକ, “ହେ ପ୍ରାଭୁ, ଇନିଃ ଦୁଡ଼ୁମାକାନ୍‍ରେଦ ବୁଗିୟଃଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ୟୀଶୁ ଆୟାଃ ଗନଏଃ ବିଷାଏରେ କାଜିକେଦାଏ, ମେନ୍‌ଦ ଚେଲାକ ସାର୍‌ତିଗି ଦୁଡ଼ୁମ୍‌ତାନାଏ ମେନ୍ତେକ ଆଟ୍‌କାର୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ଏନାତେ ୟୀଶୁ ଇନ୍‌କୁକେ “ଲାଜାର୍‌ ଗଏଃୟାନାଏ ମେତାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ଆଡଃ ଆପେୟାଃ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଏନ୍ତାଃରେ କା ତାଇନ୍‌କେଦ୍‌ତେ ରାସ୍‌କାଅଃ ତାନାଇଙ୍ଗ୍‌, ଜେ'ଲେକା ଆପେ ପାତିୟାରେୟାପେ, ମେନ୍‌ଦ ଦଲା ଇନିଃକେ ନେଲ୍‌ତେବୁ ସେନା ।” ");
INSERT INTO unx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ଏନ୍ତେ ଦିଦୁମ୍‍ କାଜିୟଃତାନ୍‌ ଥୋମା ଆୟାଃ ଗାତିକକେ କାଜିୟାଦ୍‌କଆଏ, “ଦଲାବୁ ସବେନ୍‌କ ଗୁରୁଲଃ ସେନାବୁ ଆଡଃ ଆବୁହଗି ଇନିଃଲଃବୁ ଗଜଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଏନ୍ତେ ୟୀଶୁ ସେଟେର୍‌କେଦ୍‌ତେ, “ଲାଜାର୍‍କେ ତପାଗାଡ଼ାରେ ତପାତେୟାଃ ଚାର୍‍ଦିନ୍ ହବାଃଅତାନା” ମେନ୍ତେ ଆୟୁମ୍‍କେଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ବେଥ୍‌ନିଆ ଯୀରୁଶାଲେମ୍‌ଏତେ ତିନ୍‌ କିଲୋମିଟର୍‌ଏତେହ କାମ୍‌ତିସାଙ୍ଗିନ୍‌ରେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ଆଡଃ ପୁରାଃ ଯିହୁଦୀକ ମାର୍ଥା ଆଡଃ ମାରିୟାମ୍‌ଆଃ ହାଗା ଲାଜାର୍‌ ବିଷାଏରେ ଇନ୍‌କିନ୍‌କେ ଜୀଉରାଡ଼େଃ ଏମଃ ନାଗେନ୍ତେକ ହିଜୁଃକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ଏନ୍ତେ ମାର୍ଥା ୟୀଶୁ ହିଜୁଃତାନାଏ ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ଚି ଇନିଃକେ ସେନ୍‍ଦାରମ୍‍କିୟାଏ, ମେନ୍‌ଦ ମାରିୟାମ୍‌ ଅଡ଼ାଃରେଗି ଦୁବାକାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ଆଡଃ ମାର୍ଥା ୟୀଶୁକେ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ ନେତାଃରେମ୍ ତାଇକାନ୍‌ରେଦ ଆଇଁୟାଃ ହାଗାଇଙ୍ଗ୍‌ କାଏ ଗଜାକାନ୍ତେୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ମେନ୍‌ଦ ଆମ୍‌ ନାହାଁଃ ହଁ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ଆସିତେୟାଃ ସବେନାଃ ଏମାମେୟାଏ, ଏନା ଆଇଙ୍ଗ୍‌ ସାରିତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ୟୀଶୁ ମାର୍ଥାକେ କାଜିକିୟାଏ, “ହାଗାମ୍ ତାମାଃ ଜୀଉ ନାମ୍‌କେଦ୍‌ତେ ଆଡଃଗି ବିରିଦାଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମାର୍ଥା ଇନିଃକେ କାଜିକିୟାଏ, “ଇନିଃ ଟୁଣ୍ଡୁ ଦିପିଲିରେ ଜୀଉବିନିରିଦ୍‍ରେୟାଃ ନେଡାରେ ଜୀଉବିରିଦାଃଏ, ଏନା ଆଇଙ୍ଗ୍‌ ସାରିତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଜୀଉବିନିରିଦ୍‌ ଆଡଃ ଜୀଦାନ୍‌ ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌, ଜେତାଏ ଆଇଁୟାଃରେ ବିଶ୍ୱାସେତାନ୍‍ନିଃ ଗଜଃରେୟ ଜୀଉଦଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ଆଡଃ ଜେତାଏ ଜୀହୁଦଃତାନ୍‌ନିଃ ଆଡଃ ଆଇଁୟାଃରେ ବିଶ୍ୱାସେତାନ୍‍ନିଃ ଚିଉଲାଅ କାଏ ଗଜଃଆ, ନେଆଁଁ ଚିନାଃ ବିଶ୍ୱାସେତାନାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ଇନିଃ ୟୀଶୁକେ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଅତେଦିଶୁମ୍‌ତେ ଅକଏୟାଃ ହିଜୁଃରାଃ ତାଇନ୍‌କେନା, ଇନିଃ ଆମ୍‌ଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ମାସି ତାନ୍‍ମେଁ ନେୟାଁ ଆଇଙ୍ଗ୍‌ ବିଶ୍ୱାସେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ନେୟାଁ କାଜିକେଦ୍‌ଚି, ମାର୍ଥା ଆୟାଃ ମିଶିତେ ମାରିୟାମ୍‌କେ ଉକୁକେଦ୍‌ତେ କେଡ଼ାକିୟାଏ, ଆଡଃ ମେତାଇୟାଏ, “ଗୁରୁ ହିଜୁଃୟାନାଏ ଆଡଃ ଆମ୍‌କେ କେଡ଼ାମ୍‌ତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ଇନିଃ ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ଚି, ବିରିଦ୍‍ ଧାବ୍‍ୟାନାଏ ଆଡଃ ୟୀଶୁତାଃତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ୟୀଶୁ ଇମ୍‌ତା ଜାକେଦ୍‌ ହାତୁତେ କାଏ ତେବାଃକାନ୍‍ ତାଇକେନା, ମେନ୍‌ଦ ମାର୍ଥା ଦାରମ୍‌ ଠାୟାଦ୍‍ତାଃରେଗି ଇନିଃ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ଏନ୍ତେ ଜୀଉରାଡ଼େଃ ନାଙ୍ଗ୍‌ ଅକନ୍‌ ଯିହୁଦୀକ ଅଡ଼ାଃରେ ମାରିୟାମ୍‌ଲଃ ତାଇକେନାକ, ଇନ୍‌କୁ ମାରିୟାମ୍‌କେ ଇମ୍‌ତାଗି ବିରିଦ୍‌କେଦ୍‌ତେ ବାହାରି ଅଡଙ୍ଗ୍‌ତାନ୍‌ ନେଲ୍‌କିଃତେ ଇନିଃ ରାଆଃ ନାଗେନ୍ତେ ତପାଗାଡ଼ାତେ ସେନଃତାନାଏ ମେନ୍ତେ ଆଟ୍‌କାର୍‌ତାନ୍‌ଲଃ ଇନିୟାଃ ଦୟା ଦୟାକ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ଏନ୍ତେ ମାରିୟାମ୍‌ ୟୀଶୁ ତାଇକେନ୍‍ତାଃ ତେବାଃୟାନ୍‌ଚି, ଇନିଃ ୟୀଶୁକେ ନେଲ୍‍ତାଇଲଃଗି ଇନିୟାଃ କାଟା ସୁବାରେ ଉୟୁଃୟାନାଏ ଆଡଃ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ ନେତାଃରେମ୍‍ ତାଇନ୍‍କାନ୍‌ରେଦ ହାଗାଇଙ୍ଗ୍‌ ତାଇୟାଃଁ କାଏ ଗଜାକାନ୍‌ତେୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ୟୀଶୁ ଇନିଃ ରାଆଃତାନ୍ ଆଡଃ ଇନିଃଲଃ ହିଜୁଃକାନ୍ ଯିହୁଦୀକକେହ ରାଆଃତାନ୍ ନେଲ୍‍କେଦ୍‍ତେ, ପୁରାଃ ଦୁକୁତେ ଆତ୍ମାରେ ବିଲ୍‌କାଅୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ଆଡଃ କୁଲିକେଦ୍‌କଆଏ, “ଅକ୍‌ତାଃରେପେ ତପାକିୟା ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାଃକ, “ହେ ପ୍ରାଭୁ, ଏଲା ହିଜୁଃକେଦ୍‍ତେ ନେଲିମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ୟୀଶୁ ରାଆଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ଏନ୍ତେ ଯିହୁଦୀକ କାଜିକେଦାଃକ, “ନେଲିପେ, ୟୀଶୁ ଲାଜାର୍‍କେ ଚିମିନ୍‌ ଦୁଲାଡ଼ି ତାଇକେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ମେନ୍‌ଦ ଇନ୍‌କୁଏତେ ଚିମିନ୍‍କ କାଜିକେଦା, “ଇନିଃ ଏନ୍‌ କାଣାଁକାନ୍‌ ହଡ଼କେ କାଏ ନେଲ୍‌ରିକାକିୟାଚି ? ଚିନାଃ ଇନିଃ ଲାଜାର୍‌ରାଃ ଗନଏଃ କାଏ ରକାଅଦାଡ଼ିତେୟାଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ଏନ୍ତେ ୟୀଶୁ ଆଡଃମିସା ଆୟାଃ ମନ୍‍ରେ ପୁରାଃ ଖିସ୍‌କେଦ୍‌ତେ ତପା ଠାୟାଦ୍‌ତେ ସେନଃୟାନାଏ, ଏନା ମିଆଁଦ୍‌ ଲାପାଙ୍ଗା ତାଇକେନା, ଆଡଃ ଏନାରେୟାଃ ଦୁଆର୍‌ତାଃ ମିଆଁଦ୍‌ ଦିରି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ୟୀଶୁ “ଦିରିକେ ବାଟିଆତମେପେ” ମେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ଏନ୍ତେ ଗଜାକାନ୍‍ନିୟାଃ ମିଶିତେ ମାର୍ଥା କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ନାହାଁଃଦ ଇନିଃ ସହାନ୍‍କାତେୟଃଆଏ, ଚିୟାଃଚି ଇନିଃ ଗଜାକାନ୍‌ତେୟାଃ ଚାର୍‍ଦିନ୍‍ ହବାଅଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ୟୀଶୁ ମାର୍ଥାକେ କାଜିକିୟାଏ, “ଆମ୍‌ ବିଶ୍ୱାସେରେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ନେଲେୟାମ୍‌, ଚିୟାଃ ନେୟାଁ କାଇଙ୍ଗ୍‌ କାଜିକାମ୍‌ତାଇନା ?” ");
INSERT INTO unx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ଏନ୍ତେ ଇନ୍‌କୁ ଦିରିକେ ବାଟି ଆତମ୍‍କେଦାଃକ । ଆଡଃ ୟୀଶୁ ସାଙ୍ଗିଲ୍‍ ରାକାବ୍‍କେଦ୍‍ତେ କାଜିକେଦାଃଏ, “ହେ ଆବା, ଆମ୍‌ ଆଇଁୟାଃ ବିନ୍ତି ଆୟୁମ୍‍କେଦାମ୍‌ ମେନ୍ତେ ଧାନ୍ୟାବାଦ୍‌ ଏମାମ୍‌ ତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ଆମ୍‌ ଆଇଁୟାଃ ବିନ୍ତି ସବେନ୍‌ଇମ୍‌ତା ଆୟୁମାଃମ୍‌, ଏନା ଆଇଙ୍ଗ୍‌ ସାରିୟାଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ନେ ଚାରିୟସାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁମ୍‌ ମେନ୍ତେ ବିଶ୍ୱାସେ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ନେୟାଁ କାଜିକେଦାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଇନିଃ ନେୟାଁ କାଜିକେଦ୍‌ଚି, କାଉରିକେଦ୍‌ତେ ହାକାଅକିୟାଏ, “ଏ ଲାଜାର୍‌, ଅଡଙ୍ଗ୍‌ଅଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ଏନ୍ତେ ଇନିଃ ଅଡଙ୍ଗ୍‌ୟାନା, ଆୟାଃ ତିଃଇ କାଟା ଲିଜାଃତେ ତଲାକାନ୍‌ ତାଇକେନା ଆଡଃ ଇନିୟାଃ ମେଦ୍‍ମୁହାଁଡ଼୍‌ ଗାମ୍‍ଛାତେ ତଲ୍‍ ବିୟୁରାକାନ୍ ତାଇକେନା । ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଇନିଃକେ ତଲାକାନ୍‌ତେୟାଃ ରାଡ଼ାଇପେ ଆଡଃ ସେନ୍‍ଇଚିଃପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ମାରିୟାମ୍‌ତାଃ ହିଜୁଃଲେନ୍ ପୁରାଃ ଯିହୁଦୀକ ୟୀଶୁ କାମିକେଦ୍‌ତେୟାଃ ନେଲ୍‍କେଦ୍‍ତେ ଇନିଃରେକ ବିଶ୍ୱାସ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ମେନ୍‌ଦ ଇନ୍‌କୁଏତେ ଚିମିନ୍‍କ ଫାରୁଶୀକତାଃ ସେନ୍‌କେଦ୍‌ତେ ୟୀଶୁ କାମିକେଦ୍‍ତେୟାଃ ଉଦୁବାଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ଏନାମେନ୍ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଫାରୁଶୀକ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌କେଦ୍‍ତେ କାଜିକେଦାଃକ, “ଆବୁ ଚିନାଃବୁ ଚିକାତାନା ? ନେଲିପେ, ଏନ୍‍ ହଡ଼ଦ ପୁରାଃ ପେଡ଼େୟାନ୍‌ କାମିକ କାମିତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ଆବୁ ଇନିଃକେ ନେ ଲେକାଗିବୁ ବାଗିତାଇରେଦ ସବେନ୍‌ ହଡ଼କ ଇନିଃରେକ ବିଶ୍ୱାସେୟା, ଆଡଃ ରୋମିରେନ୍‍କ ହିଜୁଃକେଦ୍‍ତେ ଆବୁଆଃ ମାନ୍ଦିର୍‌ ଆଡଃ ଦିଶୁମ୍‍ ବାର୍‌ନାଃକେକ ରେଃକ୍‌ ଇଦିୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ଏନ୍ତେ ଇନ୍‌କୁଏତେ ମିଆଁଦ୍‌ କାୟଫା ନୁତୁମ୍‌ ହଡ଼, ଏନ୍‍ ବାରାଷ୍‌ରେନ୍‌ ସାଲାକାନ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେ ସବେନ୍‌ ଚିମିନ୍‌ ଡଣ୍ଡକ ତାନ୍‌ପେ, ");
INSERT INTO unx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ହଡ଼କ ନାଗେନ୍ତେ ମିହୁଡ଼୍‌ଗି ଗଜଃକାଏ ଆଡଃ ଗଟା ଜାତି ଆଲକାକ ଜିୟନଃକା ଏନା ଆପେୟାଃ ନାଗେନ୍ତେ ପୁରାଃଗି ବୁଗିନାଃ ମେନ୍ତେ କାପେ ଆଟ୍‌କାରେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","କାୟଫା ନେ କାଜିଦ ଆଇଃକ୍‌ତେଗି କାଏ କାଜି, ମେନ୍‌ଦ ଏନ୍‍ ବାରାଷ୍‌ରେନ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ତାଇନ୍‌ହରାତେ, ୟୀଶୁ ଏନ୍‍ ଜାତିକ ନାଗେନ୍ତେ ଗଜଃଆଏ ମେନ୍ତେ ଇନିଃ ନେ ଆୟାର୍‌କାଜିକ କାଜିକେଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଆଡଃ ଏନ୍‌ ଜାତିକ ନାଗେନ୍ତେ ଏସ୍‍କାର୍‍ କାହା ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନେତେ ହେନ୍ତେୟାକାନ୍‍ ହଡ଼କକେ ମିଦ୍‍ରେ ହୁଣ୍ଡିକ ନାଗେନ୍ତେ କାଜିକେଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ଏନ୍‍ହୁଲାଙ୍ଗ୍‌ତାଃଏତେ ୟୀଶୁକେ ଗଜି ନାଗେନ୍ତେ ଯିହୁଦୀକ ଆକରେକ ରୋଜୋଟକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ଏନାମେନ୍ତେ ୟୀଶୁ ଯିହୁଦୀକଆଃ ନେପେଲ୍‌ରେ ଆଡଃ କାଏ ହନର୍‍କେଦାଃ, ମେନ୍‌ଦ ଏନ୍ତାଃ ବାଗିକେଦ୍‌ତେ ବିର୍‌ରେୟାଃ ନାଡ଼େଃ ଦିଶୁମ୍‍ ଇଫ୍ରାଇମ୍ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସାହାର୍‍ତେ ସେନଃୟାନାଏ, ଆଡଃ ଆୟାଃ ଚେଲାକଲଃ ଏନ୍ତାଃରେ ତାଇନ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ଯିହୁଦୀକଆଃ ପାସ୍‌କା ପାରାବ୍‌ ନାଡ଼େୟାକାନ୍‌ ତାଇକେନା, ପାରାବ୍‌ ସିଦାରେ ପୁରାଃ ହଡ଼କ ଆକଆଃ ଫାର୍‌ଚିୟଃ ନାଗେନ୍ତେ ଦିଶୁମ୍‍କଏତେ ଯୀରୁଶାଲେମ୍‌ତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ଏନ୍ତେ ଇନ୍‌କୁ ୟୀଶୁକେ ଦାଣାଁଁବାଡ଼ାତାନ୍‍ଲଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ଇମ୍‌ତା ଆକ ଆକଗିକ କୁପୁଲିୟାନା, “ଆପେ ଚିନାଃପେ ଉଡ଼ୁଃତାନା ? ଚିୟାଃ ଇନିଃ ପାରାବ୍‍ରେ କାଏ ହିଜୁଃଆ ?” ");
INSERT INTO unx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଫାରୁଶୀକ ୟୀଶୁକେ ସାବି ନାଗେନ୍ତେ ଇନିଃ କତାଃରିୟା, ଏନା ଜେତାଏ ସାରିରେଦ ଉଦୁବାଲେପେ ମେନ୍ତେ ଆଚୁକାଦ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ୟୀଶୁ ପାସ୍‌କା ପାରାବ୍‌ରେୟାଃ ଛ ଦିନ୍ ସିଦାରେ ବେଥ୍‌ନିଆତେ ସେନଃୟାନାଏ, ଏନ୍ତାଃରେ ୟୀଶୁ ଗନଏଃ ଏତେ ଜୀଉବିରିଦାକାଇ ଲାଜାର୍‌ରାଃ ଅଡ଼ାଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ଇନ୍‌କୁ ଏନ୍ତାଃରେ ଇନିୟାଃ ନାଗେନ୍ତେ ଆୟୁବ୍‍ ଜମେୟାଁକ ବାଇକେଦାଃ ଆଡଃ ମାର୍ଥା ସୁସାର୍‌ରେୟାଃ ବାହାରମ୍‌ ଇଦିକାଦ୍‌ ତାଇକେନାଏ, ଏନ୍ତେ ୟୀଶୁଲଃ ଦୁବାକାନ୍‍କ ଥାଲାରେ ଲାଜାର୍‌ହଗି ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ଏନ୍ତେ ମାରିୟାମ୍‌ ଆଧା ଲିଟର୍‌ ପୁରାଃ ଫାର୍‌ଚି ଗନଙ୍ଗ୍‌ଆଁନ୍‌ ଜଟାମାଂସି ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ ଆଉକେଦ୍‌ତେ ୟୀଶୁଆଃ କାଟାରେ ଦୁଲ୍‌କେଦାଏ ଆଡଃ ଇନିୟାଃ କାଟା ଆୟାଃ ଉବ୍‍ତେ ଜଦ୍‍କେଦାଏ ଆଡଃ ସୁନୁମ୍‍ରେୟାଃ ବୁଗିନ୍‌ ସହାନ୍‍ତେ ଅଡ଼ାଃ ପେରେଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ୟୀଶୁଆଃ ଚେଲାକଏତେ ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଚେଲା ତାଇକେନାଏ, ଅକଏଚି ୟୀଶୁକେ ବାଇରିକଆଃ ତିଃଇରେ ଜିମାଇ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌ ତାଇକେନ୍‌ନିଃ କାଜିକେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ନେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌କେ ୩୦୦ ହୁଲାଙ୍ଗ୍‌ରାଃ ନାଲା ସିକାରେ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ଏନ୍‌ ପାଏସା ଚିନାଃମେନ୍ତେ ରେଙ୍ଗେଃକକେ କା ଏମ୍‍ୟାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ରେଙ୍ଗେଃତାନ୍‍କଆଃ ନାଗେନ୍ତେ ଉଡ଼ୁଃତାଇକେନାଏ ମେନ୍ତେ ଇନିଃ ନେଆଁଁ କାଏ କାଜିକେଦା ମେନ୍‌ଦ ଇନିଃ କୁମ୍ବୁଡ଼ୁ ତାଇକେନାଏ ଆଡଃ ଇନିଃତାଃରେ ଟାକା ଥାଇଲାଃ ତାଇକେନ୍‌ ହରାତେ ଏନାରେ ସାଜୁତେୟାଃ ଇନିଃ କୁମ୍ବୁଡ଼ୁ ଇଦି ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ମେନ୍‌ଦ ୟୀଶୁ କାଜିକେଦାଃଏ, “ଇନିଃକେ ବାଗିତାଇପେ ଚିୟାଃଚି ଆଇଁୟାଃ ତପାଅଃ ହୁଲାଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଇନିଃ ଏନାକେ ଦହଏକାଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ରେଙ୍ଗେଃକଦ ସବେନ୍‌ଇମ୍‌ତା ଆପେଲଃ ତାଇନାଃକ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେଲଃ ସବେନ୍‌ଇମ୍‌ତା କାଇଙ୍ଗ୍‌ ତାଇନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ଯିହୁଦୀକଏତେ ଗାଦେଲ୍‌ ହଡ଼କ ୟୀଶୁ ବେଥ୍‌ନିଆରେ ମେନାଇୟା ମେନ୍ତେ ସାରିକେଦାଃକ ଆଡଃ ୟୀଶୁଆଃ ନାଗେନ୍ତେ ଏସ୍‍କାର୍‍ କାହା ମେନ୍‌ଦ ୟୀଶୁ ଗଏଃକାନ୍‍କଏତେ ଜୀଉବିରିଦାକାଇ ଲାଜାର୍‌କେ ନେଲି ନାଗେନ୍ତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ଏନ୍ତେ ଲାଜାର୍‌କେହଗି ଗଜି ନାଗେନ୍ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କ ରୋଜୋଟକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ଚିୟାଃଚି ଇନିୟାଃ ନାଗେନ୍ତେ ଯିହୁଦୀକଏତେ ପୁରାଃ ହଡ଼କ ଇନ୍‌କୁକେ ମାନାତାଇକେନାକ ଆଡଃ ୟୀଶୁରେକ ବିଶ୍ୱାସ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ପାସ୍‌କା ପାରାବ୍‍ତେ ହିଜୁଃକାନ୍ ଗାଦେଲ୍‌ ହଡ଼କ ୟୀଶୁ ଯୀରୁଶାଲେମ୍‌ତେ ହିଜୁଃତାନାଏ ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ଚି, ");
INSERT INTO unx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ଇନ୍‌କୁ କିତା ଢାଉଡ଼ା ସାବ୍‌କେଦ୍‌ତେ ଇନିଃକେ ଦାରମି ନାଗେନ୍ତେକ ଅଡଙ୍ଗ୍‌ୟାନା ଆଡଃ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଃକ “ହୋଶାନ୍ନା, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନୁତୁମ୍‌ତେ ହିଜୁଃତାନ୍‍ନିୟାଃ ଧାଇନ୍‌ ହବାଅଃକା, ଇସ୍ରାଏଲ୍‌ରେନ୍ ରାଜାରାଃ ଧାଇନ୍‌ ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ଧାରାମ୍‌ପୁଥିରାଃ ଅନଲ୍‌ ଲେକାତେ, ୟୀଶୁ ଗାଧାହନ୍‌ ନାମ୍‌କିଃତେ ଇନିଃରେ ଦେଏଃୟାନାଏ, ");
INSERT INTO unx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ସିୟୋନ୍‌ରେନ୍‌ ହନ୍‌କୁଡ଼ି, ଆଲମ୍‌ ବରଏୟା, ନେଲିମେ ଆମାଃ ରାଜା ଗାଧାହନ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ହିଜୁଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ଇନିୟାଃ ଚେଲାକ ନେ କାଜିକେ ଇମ୍‌ତା କାକ ଆଟ୍‌କାର୍‍ ଉରୁମ୍‍କେଦାଃ ମେନ୍‌ଦ ୟୀଶୁଆଃ ମାଇନାନ୍‌ ତାୟମ୍‌ତେ ନେ ସବେନାଃ ଇନିୟାଃ ବିଷାଏରେ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ ତାଇକେନା ଆଡଃ ଇନିଃକେ ଇନ୍‌କୁ ନେ ସବେନାଃକ ରିକାକାଦ୍‌ ତାଇକେନା ଏନା ଇନ୍‌କୁ ପାହାମ୍‌କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ଆଡଃ ୟୀଶୁ ଲାଜାର୍‌କେ ତପା ଗାଡାଏତେ ହାକାଅକିୟାଏ ଆଡଃ ଗଏଃକାନ୍‍କଏତେ ଜୀଉବିରିଦ୍‌କିୟାଏ ଇମ୍‌ତା ଇନିଃଲଃ ତାଇକେନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ଗାୱାକ ଏମ୍‌ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ଚିମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କୁ ୟୀଶୁ ନେ ପେଡ଼େୟାନ୍‌ କାମି କାମିକାଦାଃଏ ମେନ୍ତେ ଆୟୁମ୍‌କେଦାଃ ଇମ୍‌ତାଙ୍ଗ୍‌ ଏନ୍‍ ଗାଦେଲ୍‍ହଡ଼କ ଇନିଃଲଃ ନେପେଲ୍‌ ନାଗେନ୍ତେ ଅଡଙ୍ଗ୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ଏନ୍ତେ ଫାରୁଶୀକ ଆକ ଆକରେକ କାଜିକେଦା, “ନେଲେତାନାପେଦ, ଆବୁତେ ଜେତ୍‌ନାଃ କା ବାଇୟଆଃ ନେଆଁଁ ଆଟ୍‌କାରେପେ, ନେଲ୍‌କପେ, ଅତେଦିଶୁମ୍‌ରେନ୍‌ ସବେନ୍‌କ ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟାଃକ ।” ");
INSERT INTO unx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ପାରାବ୍‍ରେ ସେୱା ନାଗେନ୍ତେ ହିଜୁଆକାନ୍‍କଏତେ ଚିମିନ୍‍ ହଡ଼କ ଗ୍ରୀକ୍‌ରେନ୍‍କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ଇନ୍‌କୁ ଗାଲିଲ୍‌ରେୟାଃ ବେଥ୍‌ସାଇଦାରେନ୍ ଫିଲିପ୍‌ତାଃ ହିଜୁଃକେଦ୍‌ତେ କୁଲିକିୟାଃକ, “ହେ ଗମ୍‌କେ, ଆଲେ ୟୀଶୁକେ ନେନେଲ୍ ସାନାଙ୍ଗ୍‌ତାନାଲେ ।” ");
INSERT INTO unx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ଫିଲିପ୍‌ ଆନ୍ଦ୍ରିୟାସ୍‌ତାଃ ସେନ୍‌କେଦ୍‌ତେ କାଜିକିୟାଏ, “ଏନ୍ତେ ଆନ୍ଦ୍ରିୟାସ୍‍ ଆଡଃ ଫିଲିପ୍ ୟୀଶୁକେକିନ୍‌ କାଜିକିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ୟୀଶୁ ଇନ୍‌କିନ୍‌କେ ମେତାଦ୍‌କିନାଏ, “ମାନୱାହନ୍‌ଆଃ ମାଇନାନ୍‌ରେୟାଃ ନେଡା ସେଟେରାକାନା । ");
INSERT INTO unx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଗହମ୍‌ଜାଙ୍ଗ୍‌ ଅତେରେ ଉୟୁଃକେଦ୍‍ତେ କା ଗଜଃରେଦ ଏନା ଏସ୍‍କାର୍‍ଗି ତାଇନାଃ, ମେନ୍‌ଦ ଏନା ଗଜଃରେଦ ପୁରାଃ ଜ ଜଅଃ'ଆ । ");
INSERT INTO unx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଜେତାଏ ଆୟାଃ ଜୀଉକେ ଦୁଲାଡ଼େୟାଏ ଇନିଃ ଏନାକେ ଆଦେୟାଏ ଆଡଃ ଜେତାଏ ଆୟାଃ ଜୀଉକେ ନେ ଅତେଦିଶୁମ୍‌ରେ ହିଲାଙ୍ଗ୍‌ୟେଁଆ, ଇନିଃ ଏନାକେ ଜାନାଅ ଜୀଦାନ୍‌ ନାଗେନ୍ତେ ବାଞ୍ଚାଅୟା । ");
INSERT INTO unx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ସୁସାରିଙ୍ଗ୍‌ରେଦ ଇନିଃ ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌କାଏ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ତାଇନଃତାଃରେ ଆଇଙ୍ଗ୍‌କେ ସୁସାର୍‌ନିଃହ ତାଇନାଃଏ, ଆଡଃ ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ସୁସାରିଙ୍ଗ୍‌ରେଦ ଆପୁଇଙ୍ଗ୍‌ ଇନିଃକେ ମାଇନିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ନାହାଃଁଦ ଆଇଁୟାଃ ମନ୍‌ ଆକ୍‌ବାକାଅକାନା, ଚିନାଃ ଆଡଃଇଙ୍ଗ୍‌ କାଜିୟା ? ହେ ଆବା, ନେ ନେଡାଏତେ ଆଇଙ୍ଗ୍‌କେ ବାଞ୍ଚାଅଇଙ୍ଗ୍‌ମେ ମେନ୍ତେଇଙ୍ଗ୍‌ କାଜିୟାଚି ? ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ନେୟାଁ ନାଗେନ୍ତେଗିଇଙ୍ଗ୍‌ ହିଜୁଃକାନା, ଜେ'ଲେକାଚି ଆଇଙ୍ଗ୍‌ ନେ ଦୁକୁରାଃ ନେଡାରେଇଙ୍ଗ୍‌ ସାହାତିଙ୍ଗ୍‌ ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ହେ ଆବା ଆମାଃ ନୁତୁମ୍‌ ମାନାରାଙ୍ଗ୍‌ଅଃକା,” ମେନ୍‌କେଦ୍‌ଚି ସିର୍ମାଏତେ ନେ କାଜି ଆୟୁମ୍‌ୟାନା, “ଆଇଙ୍ଗ୍‌ ଏନା ମାଇନାନ୍‌କାଦାଇଙ୍ଗ୍‌ ଆଡଃ ଏନାକେ ଆଡଃଗିଇଙ୍ଗ୍‌ ମାଇନାନ୍‌ନେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ଏନ୍ତାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ଏନା ଆୟୁମ୍‌କେଦ୍‌ତେ ରିମିଲ୍‍ ସାଡ଼ିଲେନା ମେନ୍ତେକ କାଜିକେଦା । ଏଟାଃକ ମେନ୍‍କେଦାଃ, “ଦୁଁତ୍‌ ଇନିଃଲଃ ଜାଗାର୍‍କେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ନେ କାଜି ଆଇଁୟାଃ ନାଗେନ୍ତେଦ କାହା, ମେନ୍‌ଦ ଆପେ ନାଗେନ୍ତେ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ନାହାଃଁଦ ନେ ଅତେଦିଶୁମ୍‌ରେୟାଃ ବିଚାର୍‌ ସେଟେରାକାନା, ନାହାଁଃ ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ଗମ୍‌କେ ବାହାରି ହୁରାଙ୍ଗ୍‌ଅଁଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ଆଡଃ ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‍ଏତେ ଚେତାନ୍‌ତେ ରାକାବଃରେଦ, ସବେନ୍‌କକେ ଆଇଙ୍ଗ୍‌ତାଃତେଇଙ୍ଗ୍‌ ଥାଇଜ୍‌ ଇଦିକଆ । ");
INSERT INTO unx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ଇନିଃ ଚିଲ୍‍କା ଗନଏଃରେ ଦୁକୁନାମେୟାଏ, ଏନା ନେ କାଜି ହରାତେ ଉଦୁବ୍‍କେଦା । ");
INSERT INTO unx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ସବେନ୍‌ ହଡ଼କ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ମାସି ଜାନାଅ ଜାନାଅଗି ତାଇନାଃଏ ମେନ୍ତେ ଆଲେୟାଃ ଆନ୍‌ଚୁରେ ଆୟୁମାକାଦାଃଲେ, ଏନ୍ତେ ଆମ୍‌ ଚିଲ୍‌କାତେ ମାନୱାହନ୍‍ ଚେତାନ୍‌ତେ ରାକାବଃଗିୟାଏ ମେନ୍ତେମ୍‌ କାଜିତାନା ? ନେ ମାନୱାହନ୍‌ ଅକଏ ତାନିଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ଏନ୍ତେ ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, “ଆଡଃ ହୁଡିଙ୍ଗ୍‌ ନେଡାଗି ମାସ୍କାଲ୍ ଆପେଲଃ ତାଇନାଃ, ନୁବାଃ ଆପେକେ କାଏ ଏସେର୍‌ପେ ନାଗେନ୍ତେ ମାସ୍କାଲ୍‍ ଆପେଲଃ ତାଇନଃ ଇମ୍‌ତାଗି ମାସ୍କାଲ୍‌ରେ ସେସେନେପେ ଆଡଃ ନୁବାଃରେ ସେସେନ୍‍ନିଃ କତାଃତେ ସେନଃତାନାଏ ଏନା କାଏ ସାରିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ଆପେ ମାସ୍କାଲ୍‍ରେନ୍ ହଡ଼ ବାଇୟଃ ନାଗେନ୍ତେ ମାସ୍କାଲ୍ ଆପେଲଃ ତାଇନଃ ଇମ୍‍ତାଗି ମାସ୍କାଲ୍‍ରେ ବିଶ୍ୱାସେପେ ।” ୟୀଶୁ ନେ ସବେନାଃ କାଜିକେଦ୍‌ଚି ସେନଃୟାନାଏ ଆଡଃ ଇନ୍‍କୁତାଃଏତେ ଉକୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ୟୀଶୁ ଇନ୍‌କୁଆଃ ଆୟାର୍‌ରେ ପେଡ଼େୟାନ୍‌ କାମିକ କାମିକେଦ୍‌ରେୟ ଇନ୍‌କୁ ଇନିଃତାଃରେ କାକ ବିଶ୍ୱାସ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ନେ ଲେକାତେ ଯିଶାୟ ନାବୀୟାଃ କାଜି ପୁରାୟାନା, “ହେ ପ୍ରାଭୁ, ଆଲେୟାଃ କାଜିରେ ଅକଏ ବିଶ୍ୱାସ୍‌କାଦା ? ଆଡଃ ପ୍ରାଭୁଆଃ ପେଡ଼େଃ ଅକଏତାଃରେ ଉଦୁବାକାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ଆଡଃ ଏନାତେ ଇନ୍‌କୁ କାକ ବିଶ୍ୱାସ୍‌ ଦାଡ଼ିକେନା, ଚିୟାଃଚି ଯିଶାୟ ଆଡଃଗି କାଜିକାଦାଏ : ");
INSERT INTO unx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କୁଆଃ ମେଦ୍‍କେ କାଣାଁ କାଦାଃଏ ଆଡଃ ମନ୍‌ ତାକଆଃକେ କେଟେଦ୍ କାଦାଃଏ ଏନାମେନ୍ତେ ଇନ୍‌କୁଆଃ ମେଦ୍‌ତେ କାକ ନେଲ୍‌ଦାଡ଼ିୟାଃ ଆଡଃ ଆକଆଃ ମନ୍‌ତେ କାକ ଆଟ୍‌କାର୍‌ ଦାଡ଼ିୟାଃ ଆଡଃ ଇନ୍‌କୁ ଆଇଁୟାଃରେ ମନ୍‌ କାକ ରୁହାଡ଼୍‌ ଦାଡ଼ିୟାଃ ଆଡଃ ଆଲେ ଇନ୍‌କୁକେ କାଲେ ବୁଗିକଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଯିଶାୟ ଇନିୟାଃ ମାନାରାଙ୍ଗ୍‌ ନେଲ୍‍କେଦ୍‍ତେ ଆଡଃ ଇନିଃକେ ଉଦୁବ୍‍କେଦ୍‍ତେ ଏନାକେ କାଜିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଏନ୍‌ରେୟ ଯିହୁଦୀକଆଃ ହାକିମ୍‌କଏତେ ପୁରାଃ ହଡ଼କ ଇନିଃରେକ ବିଶ୍ୱାସ୍‌କେଦାଃ, ମେନ୍‌ଦ ଫାରୁଶୀକଆଃ ନାଗେନ୍ତେ ଆଡଃ ସାମାଜ୍‌ଅଡ଼ାଃଏତେ ଆତମଃରେୟାଃ ବରତେ ଇନ୍‌କୁ କାକ ଉଦୁବେନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ଚିୟାଃଚି ଇନ୍‍କୁଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାଇନାନ୍‌ଏତେ ଆଦ୍‌କା ହଡ଼କଆଃ ମାଇନାନ୍‌କେକ ଦୁଲାଡ଼୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ୟୀଶୁ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ଜେତାଏ ଆଇଙ୍ଗ୍‌ରେ ବିଶ୍ୱାସେତାନ୍‌ନିଃ ଆଇଁୟାଃରେ ଏସ୍‌କାର୍‌ କାହା ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ନିଃରେୟ ବିଶ୍ୱାସାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ଆଡଃ ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ନେଲାକାଦିଙ୍ଗ୍‌ୟାଁଏ, ଇନିଃ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ନିଃକେୟ ନେଲାକାଇଜାଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ଆଇଁୟାଃରେ ବିଶ୍ୱାସେନିଃ ନୁବାଃରେ ଆଲକାଏ ତାଇନଃକା ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ମାସ୍କାଲ୍ ଲେକା ଅତେଦିଶୁମ୍‌ତେଇଙ୍ଗ୍‌ ହିଜୁଃକାନା । ");
INSERT INTO unx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ଜେତାଏନିଃ ଆଇଁୟାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ କାଏ ବିଶ୍ୱାସେରେଦ ଆଇଙ୍ଗ୍‌ ଇନିୟାଃ କାଇଙ୍ଗ୍‌ ବିଚାରେୟାଃ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ରାଃ ବିଚାର୍‌ ନାଗେନ୍ତେଦ କାହା ମେନ୍‌ଦ ଅତେଦିଶୁମ୍‌କେ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ହିଜୁଃକାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ହିଲାଙ୍ଗ୍‌ନିଃ ଆଡଃ ଆଇଁୟାଃ କାଜି କା ମାନାତିଙ୍ଗ୍‌ନିୟାଃ ବିଚାର୍‍ନିଃ ମେନାଇୟାଃ, ଆଇଙ୍ଗ୍‌ କାଜିୟାକାଦ୍ କାଜିଗି ଟୁଣ୍ଡୁହୁଲାଙ୍ଗ୍‌ରେ ଇନିୟାଃ ବିଚାରେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ନେଆଁଁ ସାର୍‌ତିଗିଆ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ଆଇଁୟାଃ ପେଡ଼େଃତେ କାଇଙ୍ଗ୍‌ କାଜିୟାକାଦାଃ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଚିନାଃଇଙ୍ଗ୍‌ କାଜିୟା ଆଡଃ ଚିନାଃଇଙ୍ଗ୍‌ ଜାଗାରେୟା ଏନା ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ ଆପୁ ଆଇଙ୍ଗ୍‌କେ ଆଚୁକାଦିୟାଁଏ । ");
INSERT INTO unx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ଆଡଃ ଇନିୟାଃ ଆନ୍‌ଚୁଦ ଜାନାଅ ଜୀଦାନ୍‌ ତାନାଃ ଏନା ଆଇଙ୍ଗ୍‌ ସାରିୟାଃ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଅକନ୍‌ କାଜିକ କାଜିୟାଇଙ୍ଗ୍‌ ଏନା ଆପୁଇଙ୍ଗ୍‌ ଆଚୁକାଦ୍‌ ଲେକାଇଙ୍ଗ୍‌ କାଜିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ପାସ୍‌କା ପାରାବ୍‌ରେୟାଃ ସିଦାରେ ୟୀଶୁ ନେ ଅତେଦିଶୁମ୍‍ଏତେ ଆପୁତାଃତେ ସେନଃରେୟା ନେଡା ସେଟେର୍‍କାନା ମେନ୍ତେ ସାରିକେଦ୍‌ଚି ଇନିଃ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ଆୟାଃ ହଡ଼କକେ ଦୁଲାଡ଼୍‌କେଦ୍‌କଆଏ ଆଡଃ ଇନ୍‌କୁକେ ଇନିୟାଃ ପୁରାଃ ଦୁଲାଡ଼୍‌ ଉଦୁବାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ୟୀଶୁ ଆଡଃ ଆୟାଃ ଚେଲାକ ଆୟୁବ୍‍ ଜମେୟାଁଃରେ ତାଇକେନାକ, ଇମ୍‌ତା ସାଏତାନ୍‌ ଶିମୋନ୍‌ରାଃ ହନ୍ତେକଡ଼ା ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦାରାଃ ମନ୍‌ରେ ୟୀଶୁକେ ବାଇରିକଆଃ ତିଃଇରେ ଜିମାଇ ନାଗେନ୍ତେ ମନ୍‍ବାଇ ଚାବାକାଦ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ଇମ୍‌ତା ଆପୁ ସବେନ୍‌ ଆକ୍‌ତେୟାର୍‌ ଆଇଁୟାଃ ତିଃଇରେ ଏମାକାଦାଃଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ହିଜୁଃକାନାଇଙ୍ଗ୍‌ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃତେ ସେନ୍‌ରୁହାଡ଼ାଇଙ୍ଗ୍‌ ମେନ୍ତେ ୟୀଶୁ ସାରି ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ଇନିଃ ଜଜମ୍‍ ଠାୟାଦ୍‍ଏତେ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ଆୟାଃ ତୁସିଙ୍ଗ୍‌କାନ୍‌ ବାହାରି ଲିଜାଃ ଦହକେଦ୍‌ତେ ଆୟାଃ ମାୟାଙ୍ଗ୍‌ରେ ମିଆଁଦ୍‌ ଗାମ୍‌ଛା ପାଟେୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ଏନ୍ତେ ବାସାନ୍‍ରେ ଦାଆଃ ଦୁଲ୍‍କେଦ୍‍ତେ ଚେଲାକଆଃ କାଟା ଆବୁଙ୍ଗ୍‌ ଏଟେଦ୍‌କେଦାଏ, ଆଡଃ ମାୟାଙ୍ଗ୍‌ରେ ପାଟେୟାକାନ୍‍ ଗାମ୍‌ଛାତେ ଜଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଏନ୍ତେ ଇନିଃ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ତାଃତେ ହିଜୁଃୟାନାଏ, ଆଡଃ ଅକଏଚି କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ଚି ଆଇଁୟାଃ କାଟା ଆବୁଙ୍ଗ୍‌ଇଁୟାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଙ୍ଗ୍‌ ରିକାତାନ୍‌ତେୟାଃ ନାହାଁଃ କାମ୍‌ ସାରିୟାଃ, ମେନ୍‌ଦ ଏନା ତାୟମ୍‌ତେମ୍‌ ଆଟ୍‌କାରେୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପାତ୍‌ରାସ୍‌ ଇନିଃକେ କାଜିକିୟାଏ, “ଆମ୍‌ ଚିଉଲାଅ ଆଇଁୟାଃ କାଟା ଆଲମ୍‌ ଆବୁଙ୍ଗ୍‌ଇଁୟା” ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ଆବୁଙ୍ଗ୍‌ମେରେଦ ଆମ୍‌ ଆଇଁୟାଃ ଚେଲା କାମ୍‌ ହବାଦାଡ଼ିୟଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ଏନ୍ତେ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆଇଁୟାଃ କାଟା ଏସ୍‍କାର୍‍ କାହା, ମେନ୍‌ଦ ଆଇଁୟାଃ ତିଃଇ ଆଡଃ ବହଃକେହଗି ଆବୁଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଉମେନ୍‌କାନ୍‌ନିଃକେ କାଟା ଏସ୍‌କାର୍‌ ଆବୁଙ୍ଗ୍‌ ଲାଗାତିୟାଃଁ; ଇନିୟାଃ ଗଟା ହଡ଼୍‌ମଦ ଫାର୍‌ଚିୟାକାନା ଆଡଃ ମିହୁଡ଼୍‌କେ ବାଗିକେଦ୍‌ତେ ଆପେ ସବେନ୍‌କ ଫାର୍‌ଚିୟାକାନାପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ଚିୟାଃଚି ଇନିଃ ଆୟାଃ ସାବ୍‍ରିକାଇନିଃକେ ସାରିକାଇ ତାଇନାଏ ଏନାମେନ୍ତେ ଇନିଃ କାଜିକେଦାଃଏ, “ମିହୁଡ଼୍‌କେ ବାଗିକେଦ୍‌ତେ ଆପେ ସବେନ୍‌କ ଫାର୍‌ଚିୟାକାନାପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ୟୀଶୁ ଇନ୍‌କୁଆଃ କାଟା ଆବୁଙ୍ଗ୍‌କେଦ୍‍ଚି ଆୟାଃ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ୟାନାଏ ଆଡଃ ଆୟାଃ ଜଜମ୍‌ ଠାୟାଦ୍‌ରେ ଦୁବ୍‍ରୁହାଡ଼୍‌ୟାନାଏ, ଏନ୍ତେ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‍କଆଏ, “ଆଇଙ୍ଗ୍‌ ଆପେ ନାଗେନ୍ତେ ରିକାକାଦ୍‌ତେୟାଃ ଆଟ୍‌କାରେତାନାପେଚି ?” ");
INSERT INTO unx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“ଆପେ ଆଇଙ୍ଗ୍‌କେ ହେ ଗୁରୁ ଆଡଃ ହେ ପ୍ରାଭୁ, ମେନ୍ତେପେ କାଜିୟାଇଙ୍ଗ୍‌ତାନା ଏନା ବୁଗିନ୍‌ଗିପେ କାଜିତାନା ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଇନିଃଗି ତାନିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ଆଇଙ୍ଗ୍‌ ଆପେୟାଃ ପ୍ରାଭୁ ଆଡଃ ଗୁରୁ ତାନିଙ୍ଗ୍‌ ହଲେହଁ ଆପେୟାଃ କାଟା ଆବୁଙ୍ଗ୍‌କେଦାଃଇଙ୍ଗ୍‌, ଏନ୍‌ଲେକା ଆପେୟଗି ମିଆଁଦ୍‌ନିଃ ଏଟାଃନିୟାଃ କାଟା ଆବୁଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ଆଇଙ୍ଗ୍‌ ଆପେୟାଃ ନାଗେନ୍ତେ କାମିକାଦ୍‍ଲେକା ଆପେୟ ରିକାଏପେ, ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆପେକେ ମିଆଁଦ୍‌ ନାମୁନା ଉଦୁବାକାଦ୍‌ପେୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଦାସି ଆୟାଃ ଗମ୍‌କେଏତେ କାଏ ମାରାଙ୍ଗ୍‌ଆଁଃ, ଆଡଃ କାଜିଏମ୍‌ନିଃ ଆୟାଃ କୁଲ୍‌ନିଃତାଃଏତେ କାଏ ମାରାଙ୍ଗ୍‌ଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ନାହାଃଁଦ ଆପେ ନେ ସାର୍‌ତିକେ ସାରିୟାଃକାଦାଃପେ, ଏନାକେ ରିକାଏରେଦ ଆପେ ସୁକୁତାନ୍‌ଗିୟାଃପେ । ");
INSERT INTO unx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ଆଇଙ୍ଗ୍‌ ଆପେ ସବେନ୍‌କଆଃ ବିଷାଏରେ କାଇଙ୍ଗ୍‌ କାଜିତାନା, ଆଇଙ୍ଗ୍‌ ସାଲାକାଦ୍ ହଡ଼କକେ ସାରିକାଦ୍‌କଆଇଙ୍ଗ୍‌, ମେନ୍‌ଦ ଧାରାମ୍‌ପୁଥିରେୟାଃ କାଜି ପୁରାଅଃ ନାଗେନ୍ତେ ନେ ଲେକା ହବାଅଃତାନା ‘ଆଇଁୟାଃଲଃ ହଲଙ୍ଗ୍‌ ହାଟିଙ୍ଗ୍‌ ଜମ୍‍ନିଃ ଆଇଁୟାଃ ବିରୁଧ୍‌ରେ ବିରିଦ୍‌ୟାନାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ନେୟାଁ ହବାଅଃରେ ଆପେ ଆଇଙ୍ଗ୍‌କେ ‘ଆଇଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌’ ମେନ୍ତେପେ ବିଶ୍ୱାସେ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଏନା ହବାଅଃ ସିଦାରେ ଆପେକେ ନାହାଃଁତେଗି ଉଦୁବାପେତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଜେତାଏ ଆଇଙ୍ଗ୍‌ କୁଲାକାଇନିଃକେ ସୁକୁଆଇନିଃ ଆଇଙ୍ଗ୍‌କେ ସୁକୁଆଇଙ୍ଗ୍‌ୟାଁଏ, ଆଡଃ ଆଇଙ୍ଗ୍‌କେ ସୁକୁଆଇଙ୍ଗ୍‌ନିଃ ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‌ନିଃକେ ସୁକୁଆଇୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ୟୀଶୁ ନେ ସବେନ୍‌ କାଜି କାଜିକେଦ୍‌ଚି ଆତ୍ମାରେ ଆକ୍‌ବାକାଅୟାନାଏ ଆଡଃ ଗାୱା ଏମ୍‌ତାନ୍‌ଲଃ କାଜିକେଦାଃଏ, “ସାର୍‌ତିଗିଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆପେକଏତେ ମିଆଁଦ୍‌ନିଃ ଆଇଙ୍ଗ୍‌କେ ବାଇରିକଆଃ ତିଃଇରେ ସାବ୍‍ରିକାଇଙ୍ଗ୍‌ୟାଁଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ୟୀଶୁ ଅକଏକେ କାଜିତାନାଏ ମେନ୍ତେ ଚେଲାକ ଆଡ଼ାଃଉଡ଼ୁଃ ତାନ୍‍ଲଃ ଆକ ଆକରେକ ଆପ୍‍ରିଦ୍‍ୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ଆୟାଃ ଚେଲାକଏତେ ମିଆଁଦ୍‌ ଚେଲା ଅକଏକେଚି ୟୀଶୁ ଦୁଲାଡ଼ିତାନ୍‌ ତାଇକେନାଏ, ଏନ୍‍ ଚେଲା ୟୀଶୁଆଃ ଗେନାରେ ଦୁବ୍‍କାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ଏନ୍ତେ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ଇନିଃକେ ଚୁଣ୍ଡୁଲ୍‍କେଦ୍‍ତେ କାଜିକିୟାଏ, “ଇନିଃ ଅକଏକେ କାଜିତାନା ଏନା କୁଲି'ମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ଇନିଃ ଦୁବ୍‌କେଦ୍‌ତେ ୟୀଶୁଆଃ କୁଡ଼ାମ୍‍ରେ ଟେଣ୍ଡେର୍‍ୟାନାଏ ଆଡଃ କୁଲିକିୟାଏ, “ହେ ପ୍ରାଭୁ ଇନିଃ ଅକଏ ତାନିଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଙ୍ଗ୍‌ ହଲଙ୍ଗ୍‌ରାଃ କେଚାଃ ତୁପୁକେଦ୍‍ତେ ଅକଏକେ ଏମିୟାଇଙ୍ଗ୍‌ ଏନ୍‍ ହଡ଼ ଇନିଃଗି ତାନିଃ ।” ଏନ୍ତେ ଇନିଃ ଏନ୍‌ ହଲଙ୍ଗ୍‌ରାଃ କେଚାଃକେ ତୁପୁକେଦ୍‍ତେ ଶିମୋନ୍‌ ଇଷ୍କାରିୟତ୍‌ରାଃ ହନ୍ତେକଡ଼ା ଯିହୁଦାକେ ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ଏନ୍ତେ ଇନିଃ ହଲଙ୍ଗ୍‌ କେଚାଃ ଇଦିକେଦ୍‌ଚି ଇମ୍‍ତାଗି ସାଏତାନ୍‌ ଇନିଃକେ ଏସେର୍‍କିୟାଏ । ଏନ୍ତେ ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆମାଃ କାମିତେୟାଃ କାମି ଧାବେମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ମେନ୍‌ଦ ଇନିଃ ଚିନାଃ ମେନ୍ତେ ଇନିଃକେ ନେ କାଜି କାଜିକିୟାଏ, ଏନା ଦୁବାକାନ୍‍କଏତେ ଜେତାଏ କାକ ସାରିକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ଯିହୁଦାତାଃ ଟାକା ଥାଇଲାଃ ତାଇକେନା, ଏନାମେନ୍ତେ ଚେଲାକଏତେ ଚିମିନ୍‌କ ଉଡ଼ୁଃକେଦାଃଚି ପାରାବ୍‌ ନାଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ତେୟାଃକ କିରିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଆଡଃ ରେଙ୍ଗେଃକକେ ହୁଡିଙ୍ଗ୍‌ ଲେକା ଏମାକ ନାଗେନ୍ତେ ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ଏନ୍ତେ ଯିହୁଦା ହଲଙ୍ଗ୍‌ କେଚାଃ ତେଲାକେଦ୍‌ଚି ଇମ୍‍ତାଗି ଅଡଙ୍ଗ୍‍ଧାବ୍‍ୟାନାଏ, ଆଡଃ ଇମ୍‌ତା ନୁବାଃକାନ୍‍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଯିହୁଦା ଅଡଙ୍ଗ୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ ୟୀଶୁ କାଜିକେଦାଃଏ, “ନାହାଁଃଦ ମାନୱାହନ୍‌ରାଃ ମାଇନାନ୍‌ ଉଦୁବ୍‌ୟାନା ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ମାଇନାନ୍‌ ଇନିୟାଃ ହରାତେ ଉଦୁବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଆଡଃ ପାର୍‍ମେଶ୍ୱାର୍‌ରାଃ ମାଇନାନ୍‌ ଇନିୟାଃ ହରାତେ ଉଦୁବ୍‌ୟାନ୍‌ରେଦ, ପାର୍‌ମେଶ୍ୱାର୍‌ହଗି ମାନୱାହନ୍‌କେ ଆୟାଃତାଃରେ ମାଇନାନ୍‌ନିୟା ଆଡଃ ଇମ୍‌ତାଗି ଇନିଃକେ ମାଇନାନିୟା । ");
INSERT INTO unx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ୟୀଶୁ କାଜିକେଦାଏ, ‘ଏ ହନ୍‌କ, ଆଇଙ୍ଗ୍‌ ଆପେଲଃ ଆଡଃ ଘାଡ଼ିକାଦ୍‍ଗି ତାଇନାଇଙ୍ଗ୍‌, ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦାଣାଁଁଇୟାଁପେ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଯିହୁଦୀ ହାକିମ୍‌କକେ କାଜିୟାକାଦ୍‍କଲେକା ନାହାଁଃ ଆପେକେଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ଆଇଙ୍ଗ୍‌ ସେନଃତାଃତେ କାପେ ସେନ୍‌ଦାଡ଼ିୟା ।’ ");
INSERT INTO unx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ଆପେ ଦୁପୁଲାଡ଼୍‌ରେ ତାଇନ୍‌ପେ, ନେ ନାୱା ଆନ୍‌ଚୁ ଆଇଙ୍ଗ୍‌ ଆପେକେ ଏମାପେତାନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ଆପେକେ ଦୁଲାଡ଼୍‌କାଦ୍‍ପେଲେକା ଆପେୟ ଦୁପୁଲାଡ଼୍‌ରେ ତାଇନ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ଆପେ ଦୁଲାଡ଼୍‌ରେପେ ତାଇନ୍‍ରେଦ ଆଇଁୟାଃ ଚେଲାକ ତାନ୍‌ପେ ମେନ୍ତେ ସବେନ୍‌ ହଡ଼କ ସାରିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ୟୀଶୁକେ କୁଲିକିୟାଏ, “ହେ ପ୍ରାଭୁ ଆମ୍‌ କତାଃତେମ୍‍ ସେନଃତାନା ?” ୟୀଶୁ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ସେନଃତାନ୍‌ତାଃ ନାହାଁଃ ଆମ୍‌ କାମ୍‍ ଅତଙ୍ଗ୍‌ଦାଡ଼ିୟାଃ ମେନ୍‌ଦ ତାୟମ୍‍ତେମ୍‌ ଅତଙ୍ଗ୍‌ଇଁୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ପାତ୍‌ରାସ୍‌ ଇନିଃକେ କୁଲିକିୟାଏ, “ହେ ପ୍ରାଭୁ ଆଇଙ୍ଗ୍‌ ନାହାଁଃ ଚିକାନାଙ୍ଗ୍‌ ଆମ୍‌କେ ଅତଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ଦାଡ଼ିମେୟା ? ଆଇଙ୍ଗ୍‌ ଆମାଃ ନାଗେନ୍ତେ ଆଇଁୟାଃ ଜୀଉ ଏମ୍‌ନାଙ୍ଗ୍‌ ସେକାଡ଼ାକାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଚିୟାଃ ଆମ୍‌ ସାର୍‌ତିଗି ଆଇଁୟାଃ ନାଙ୍ଗ୍‌ ଜୀଉ ଏମ୍‌ନାଙ୍ଗ୍‌ ସେକାଡ଼ାକାନାମ୍‌ ? ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ସାର୍‍ତିଗି କାଜିୟାମ୍‍ତାନାଇଙ୍ଗ୍‌, ସାଣ୍ଡିସିମ୍‌ ଆଉରି ରାଆଃ ସିଦାରେ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ କାଇଙ୍ଗ୍‌ ସାରିୟାଃ ମେନ୍ତେ ଆପିସା ଆମ୍‌ କାଜିୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ୟୀଶୁ କାଜିକେଦାଏ, “ଆପେୟାଃ ମନ୍‌ ଆଲକା ଆକ୍‌ବାକାଅଃକା, ଆପେ ପାର୍‌ମେଶ୍ୱାର୍‌ରେ ବିଶ୍ୱାସେପେ ଆଡଃ ଆଇଙ୍ଗ୍‌ରେୟ ବିଶ୍ୱାସେପେ । ");
INSERT INTO unx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ଆଇଁୟାଃ ଆପୁଇଁୟାଃ ଅଡ଼ାଃରେ ପୁରାଃ ତାଇନଃତେ ଠାୟାଦ୍‍ ମେନାଃ, ଆଡଃ କା'ତାଇନ୍‌କାରେଦ ଆଇଙ୍ଗ୍‌ ଆପେନାଙ୍ଗ୍‌ ଠାୟାଦ୍‌ ବାଇବାଇତେ ସେନ୍‌ତାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିୟାପେତେୟାଃଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ଆଡଃ ଆଇଙ୍ଗ୍‌ ସେନ୍‌କେଦ୍‌ତେ ଆପେନାଙ୍ଗ୍‌ ଠାୟାଦ୍ ବାଇସେକାଡ଼୍‌ଲେରେ ଆଡଃମିସା ହିଜୁଃଆଇଙ୍ଗ୍‌ ଆଡଃ ଆଇଙ୍ଗ୍‌ ତାଇନଃତାଃରେ ଆପେୟ ତାଇନଃ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ତାଃତେ ଆପେକେ ଇଦିପେୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ଆଇଙ୍ଗ୍‌ ଅକ୍‌ତାଃତେ ସେନଃତାନାଇଙ୍ଗ୍‌ ଏନ୍‌ ଠାୟାଦ୍‌ରାଃ ହରା ଆପେ ସାରିୟାଃପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ଥୋମା ଇନିଃକେ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ କତାଃତେମ୍‍ ସେନଃତାନା ଏନା ଆଲେ କାଲେ ସାରିୟା, ଏନ୍ତେ ଚିଲ୍‌କାତେ ହରାଲେ ସାରି ଦାଡ଼ିୟା ?” ");
INSERT INTO unx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌ ହରା, ସାର୍‌ତି ଆଡଃ ଜୀଦାନ୍‌, ଆଇଙ୍ଗ୍‌କେ ବାଗିକେଦ୍‌ତେ ଜେତାଏ ଆପୁତାଃ କାକ ସେଟେର୍‌ ଦାଡ଼ିୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ଇନିଃ ମେତାଦ୍‌କଆଏ, “ଆପେ ଆଇଙ୍ଗ୍‌କେ ସାର୍‌ତିଗି ସାରିକାଇଙ୍ଗ୍‌ରେଦ ଆପୁଇଙ୍ଗ୍‌କେହ ସାରିକାଇତେୟାଃପେ, ନାହାଃଁଏତେ ଆପେ ଇନିଃକେପେ ସାରିତାନା ଆଡଃ ଇନିଃକେପେ ନେଲାକାଇଜାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ଫିଲିପ୍‌ ୟୀଶୁକେ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ଆଲେକେ ଆପୁକେ ଉଦୁବାଲେମେ, ଇମ୍‌ନାଙ୍ଗ୍‌ଗି ଆଲେୟାଃ ସାନାଙ୍ଗ୍‌ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଏ ଫିଲିପ୍‌, ନିମିନ୍‌ ମାହାଁଏତେ ଆଇଙ୍ଗ୍‌ ଆପେଲଃ ମେନାଇୟାଃଁ ଚିୟାଃ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ କାମ୍‌ ସାରିକାଦିଁୟାଃ, ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ନେଲାକାଦିଙ୍ଗ୍‌ନିଃ ଆପୁକେ ନେଲାକାଇଜାଏ, ଆଲେକେ ଆପୁକେ ଉଦୁବାଲେମେ ମେନ୍ତେ ଚିଲ୍‍କାତେମ୍‌ କାଜିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ଆଇଙ୍ଗ୍‌ ଆପୁତାଃରେ ମେନାଇୟାଃଁ ଆଡଃ ଆପୁ ଆଇଙ୍ଗ୍‌ରିୟା, ଚିୟାଃ ନେଆଁଁ ଆମ୍‌ କାମ୍‍ ପାତିୟାରେତାନା, ଆଇଙ୍ଗ୍‌ ଆପେକେ କାଜିୟାପେତାନ୍‍ କାଜିକ ଆଇଙ୍ଗ୍‌ତାଃଏତେ କାଇଙ୍ଗ୍‌ କାଜିୟାଃ ମେନ୍‌ଦ ଆପୁ ଆଇଙ୍ଗ୍‌ରେ ତାଇନ୍‌କେଦ୍‌ତେ ଆୟାଃ କାମିକ କାମିତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ଆଇଙ୍ଗ୍‌ ଆପୁତାଃରେ ମେନାଇୟାଃଁ ଆଡଃ ଆପୁ ଆଇଙ୍ଗ୍‌ରିୟାଃ ଏନା ବିଶ୍ୱାସେପେ, ଏନା କା'ରେଦ, ଆଇଙ୍ଗ୍‌ କାମିକାଦ୍‌ କାମିକ ନାଗେନ୍ତେ ପାତିୟାରିଙ୍ଗ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ରେ ବିଶ୍ୱାସେତାନ୍‌କ, ଆଇଙ୍ଗ୍‌ କାମିକାଦ୍‍ କାମିକ କାମିୟା ଆଡଃ ଏନାଏତେ ଆଦ୍‌କା ମାପ୍‌ରାଙ୍ଗ୍‌ କାମିକ କାମିୟା, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ଆପୁତାଃତେ ସେନଃତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ଆଡଃ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ସବେନାଃ ଆସିତେୟାଃ ଆଇଙ୍ଗ୍‌ ଆପେନାଙ୍ଗ୍‌ କାମିୟାଇଙ୍ଗ୍‌, ଏନାତେ ଆପୁଆଃ ମାଇନାନ୍‌ ହନ୍ଆଃ ହରାତେ ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ଆପେ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ଜେତ୍‍ନାଃପେ ଆସିରେଦ ଏନାଇଙ୍ଗ୍‌ ରିକାୟା । ");
INSERT INTO unx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ରେଦ ଆଇଁୟାଃ ଆନ୍‌ଚୁପେ ମାନାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ଆଇଙ୍ଗ୍‌ ଆପୁକେଇଙ୍ଗ୍‌ ବିନ୍ତିୟା ଆଡଃ ଇନିଃ ଆପେଲଃ ଜାନାଅ ଜାନାଅ ତାଇନଃ ନାଗେନ୍ତେ ଏଟାଃ ଜୀଉରାଡ଼େଃ ଏମଃନିଃକେ ଏମାପେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ଇନିଃ ସାର୍‌ତି ଆତ୍ମା ତାନିଃ, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ରାଃ ସାର୍‌ତି ବିଷାଏକେ ଉଦୁବେୟାଏ । ଅତେଦିଶୁମ୍‌ ଇନିଃକେ କାଏ ସାରିୟାଃ, ଚିୟାଃଚି ଅତେଦିଶୁମ୍‌ ଇନିଃକେ କାଏ ନେଲ୍‌ ଦାଡ଼ିୟାଃ ଚାଏ କାଏ ନାମ୍‌ ଦାଡ଼ିୟାଃ । ମେନ୍‌ଦ ଆପେ ଇନିଃକେ ସାରିୟାଃପେ ଚିୟାଃଚି ଇନିଃ ଆପେଲଃ ମେନାଇୟା ଆଡଃ ଆପେରେ ତାଇନଃଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ଆଇଙ୍ଗ୍‌ ସେନଃୟାନ୍‌ ତାୟମ୍‌ତେ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ଟୁଆର୍‌ଲେକା କାଇଙ୍ଗ୍‌ ବାଗିପେୟା, ଆଇଙ୍ଗ୍‌ ଆପେତାଃତେ ରୁହାଡ଼୍‌ ହିଜୁଃଆଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ଆଡଃ କାଟିଃ ଘାଡ଼ିକାଦ୍‌ରେ ଅତେଦିଶୁମ୍‌ ଆଇଙ୍ଗ୍‌କେ କାଏ ନେଲିୟାଃଁ, ମେନ୍‌ଦ ଆପେ ଆଇଙ୍ଗ୍‌କେ ନେଲିୟାଃଁପେ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ଜୀହିଦ୍‌ ମେନାଇୟାଃଁ ଆଡଃ ଆପେୟ ଜୀହିଦ୍‌ଗି ତାଇନାଃପେ । ");
INSERT INTO unx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ଆଇଙ୍ଗ୍‌ ଆପୁଲଃ ମେନାଇୟାଃଁ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପେରେ ମେନାଇଙ୍ଗ୍‌ ଲେକା ଆପେ ଆଇଁୟାଃରେ ମେନାପେୟା ଏନା ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ହିଜୁଃରେପେ ସାରିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ଜେତାଏ ଆଇଁୟାଃ ଆନ୍‌ଚୁ ନାମ୍‌କେଦ୍‌ତେ ମାନାତିଙ୍ଗ୍‌ନିଃ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ାଃଏ, ଆଡଃ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ନିଃକେ ଆପୁଇଙ୍ଗ୍‌ ଦୁଲାଡ଼ିୟାଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ହଁ ଇନିଃକେ ଦୁଲାଡ଼ିୟାଇଙ୍ଗ୍‌ ଆଡଃ ଇନିଃତାଃରେ ଉଦୁବେନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା କାହା, ଏଟାଃ ଯିହୁଦା ୟୀଶୁକେ କାଜିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ନେଆଁଁ ଚିଲ୍‌କା ହବାଅଆଃ ? ଚିନାଃମେନ୍ତେ ଆମ୍‌ ଅତେଦିଶୁମ୍‌ରେ କା ଉଦୁବେନ୍‌କେଦ୍‌ତେ ଆଲେତାଃରେ ଉଦୁବେନ୍‌ ସାନାଙ୍ଗ୍‌ତାନାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ରେଦ ଇନିଃ ଆଇଁୟାଃ କାଜି ମାନାତିୟାଁଏ ଆଡଃ ଆପୁଇଙ୍ଗ୍‌ ଇନିଃକେ ଦୁଲାଡ଼ିୟାଏ ଆଡଃ ଆପୁଇଙ୍ଗ୍‌ ଆଡଃ ଆଇଙ୍ଗ୍‌ ହିଜୁଃକେଦ୍‌ତେ ଇନିଃଲଃ ତାଇନାଃଲିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଆଇଙ୍ଗ୍‌କେ କାଏ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ନିଃ ଆଇଁୟାଃ କାଜି କାଏ ମାନାତିୟାଃଁ ଆଡଃ ଆପେ ଆୟୁମ୍‍ତାନ୍‌ କାଜି ଆଇଁୟାଃ ନାହାଁଲାଃ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଇଙ୍ଗ୍‌ନିଃ ଆପୁଇଁୟାଃ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ଆଇଙ୍ଗ୍‌ ଆପେଲଃ ତାଇକେନ୍‌ ଇମ୍‌ତା ନେ କାଜିକ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ମେନ୍‌ଦ ଏନ୍‌ ଜୀଉରାଡ଼େଃ ଏମଃ ପାବିତାର୍‌ ଆତ୍ମାକେ ଆପୁ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ କୁଲିୟାଏ ଇନିଃ ଆପେକେ ସବେନାଃ ଇତୁପେୟାଏ ଆଡଃ ଆପେକେ କାଜିକାଦ୍‌ପେତେୟାଃ, ପାହାମ୍‌ ରିକାପେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ଆଇଙ୍ଗ୍‌ ଆପେକେ ଜୀଉସୁକୁ ବାଗିୟାପେତାନାଇଙ୍ଗ୍‌, ଆଇଁୟାଃ ଜୀଉସୁକୁ ଏମାପେତାନାଇଙ୍ଗ୍‌, ଅତେଦିଶୁମ୍‌ ଏମ୍‍ଲେକା କାଇଙ୍ଗ୍‌ ଏମାପେତାନା, ଆପେୟାଃ ମନ୍‌ ଆଲକାଏ ଆକ୍‌ବାକାଅଃକା ଆଡଃ ଆଲକାଏ ବରଏକା । ");
INSERT INTO unx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘ଆଇଙ୍ଗ୍‌ ସେନଃତାନାଇଙ୍ଗ୍‌ ଆଡଃ ଆପେତାଃତେଇଙ୍ଗ୍‌ ହିଜୁଃରୁହାଡ଼ାଃ’ ମେନ୍ତେ ଆପେକେ କାଜିକାଦ୍‌ପେତେୟାଃ ଆୟୁମ୍‍କାଦାଃପେ । ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ତେୟାଃପେ ରେଦ ଆଇଙ୍ଗ୍‌ ଆପୁତାଃତେଇଙ୍ଗ୍‌ ସେନଃତାନା ମେନ୍ତେ ରାସ୍‌କାଅଃତେୟାଃପେ, ଚିୟାଃଚି ଆପୁଦ ଆଇଙ୍ଗ୍‌ଏତେ ମାରାଙ୍ଗ୍‌ଆଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ଏନା ହବାଃଅ ଦିପିଲିରେ ଆପେ ଜେ'ଲେକା ବିଶ୍ୱାସେ ନାଗେନ୍ତେ ଏନା ଆଉରି ହବାଃଅ ସିଦାରେ ଆପେକେ କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ଆଇଙ୍ଗ୍‌ ଆପେଲଃ ପୁରାଃ କାଇଙ୍ଗ୍‌ ଜାଗାରେୟା, ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ଗମ୍‌କେ ହିଜୁଃତାନାଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ରେ ଇନିୟାଃ ଜେତାନ୍‌ ପେଡ଼େଃ ବାନଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ମେନ୍‌ଦ ଆପୁ ଆଚୁକାଦ୍‌ ଲେକାଇଙ୍ଗ୍‌ କାମିୟାଃ, ଏନାତେ ଆଇଙ୍ଗ୍‌ ଆପୁକେଇଙ୍ଗ୍‌ ଦୁଲାଡ଼ାଃ ମେନ୍ତେ ଅତେଦିଶୁମ୍‌ ଆଟ୍‌କାରେକାଏ । “ବିରିଦ୍‌ପେ, ଦଲା ନେତାଃଏତେବୁ ସେନଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ଆଇଙ୍ଗ୍‌ ସାର୍‌ତି ଦାଖ୍‌ନାଡ଼ି ତାନିଙ୍ଗ୍‌ ଆଡଃ ଆପୁଇଙ୍ଗ୍‌ କିଷାନ୍‌ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ଆଇଙ୍ଗ୍‌ତାଃରେ ତାଇନଃ ଜେତାନ୍‌ କତ କା ଜଅଃ'ତେୟାଃକେ ମାଆଃ ଆତମେୟାଁଏ ଆଡଃ ଜଅଃ'ତାନ୍‍ କତ ଆଦ୍‌କା ଜଅଃ'କା ମେନ୍ତେ ଏନାକେ ମାଆଃକେଦ୍‌ତେ ସାଫା ଫାର୍‌ଚିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ଆପେଦ ଆଇଙ୍ଗ୍‌ କାଜିୟାଦ୍‌ କାଜିରେୟାଃ ହରାତେପେ ଫାର୍‌ଚି ଚାବାକାନା । ");
INSERT INTO unx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ଆଇଙ୍ଗ୍‌ରେ ତାଇନ୍‍ପେ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପେରେ ତାଇନାଃଇଙ୍ଗ୍‌, କତ ଦାଖ୍‌ନାଡ଼ିରେ କା ତାଇନ୍‍ରେଦ ଆଇଃକ୍‌ତେଗି କା ଜଅଃ ଦାଡ଼ିୟଃଆ, ଏନ୍‌ ଲେକାତେ ଆପେୟ ଆଇଁୟାଃରେ କାପେ ତାଇନ୍‍ରେଦ କାପେ ଜଅଃ ଦାଡ଼ିୟଃଆ । ");
INSERT INTO unx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ଆଇଙ୍ଗ୍‌ ଦାଖ୍‌ନାଡ଼ି ତାନିଙ୍ଗ୍‌, ଆପେ କତକ ତାନ୍‌ପେ, ଆଇଙ୍ଗ୍‌ରେ ତାଇନ୍‌ତାନ୍‌କ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁରେ ତାଇନ୍‌ତାନ୍‌ ହଡ଼କ ପୁରାଃ ଜଆଃକ । ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ବେଗାର୍‍ଦ ଆପେ ଜେତ୍‌ନାଃ କାପେ କାମି ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ଜେତାଏ ଆଇଙ୍ଗ୍‌ରେ କାଏ ତାଇନ୍‍ରେଦ ଇନିଃ ମାଆଃକାନ୍‌ କତଲେକାଏ ଏଣ୍ଡାଗଃଆ, ଆଡଃ ରହଡ଼ଃଆଏ; ଏନ୍‌ଲେକାନ୍‌ କତକେ ହଡ଼କ ହୁଣ୍ଡିକେଦ୍‌ତେ ସେଙ୍ଗେଲ୍‍ରେକ ହୁଦ୍‌ମାୟା ଆଡଃ ଏନା ଲଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ଆପେ ଆଇଙ୍ଗ୍‌ରେ ତାଇନ୍‍ରେ ଆଡଃ ଆଇଁୟାଃ କାଜି ଆପେରେ ତାଇନ୍‍ରେଦ ଆପେ ଜେତ୍‌ନାଃ ସାନାଙ୍ଗ୍‌ତେୟାଃ ଆସିପେ ଆଡଃ ଆପେୟାଃ ନାଗେନ୍ତେ ଏନା ହବାଅଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ଆପେ ପୁରାଃ ଜ ଜଅଃ'ରେ ଆଇଁୟାଃ ଆପୁଇଙ୍ଗ୍‌ ମାଇନାନଃଆଏ ଆଡଃ ଆପେ ଆଇଁୟାଃ ବୁଗିନ୍‌ ଚେଲାପେ ବାଇୟଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ଆପୁ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼୍‌କାଦିଙ୍ଗ୍‌ ଲେକା ଆଇଙ୍ଗ୍‌ ଆପେକେ ଦୁଲାଡ଼୍‌କାଦ୍‍ପେୟାଇଙ୍ଗ୍‌, ଆଇଁୟାଃ ଦୁଲାଡ଼୍‌ରେ ତାଇନ୍‍କାନ୍‍ପେ । ");
INSERT INTO unx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ଆଇଙ୍ଗ୍‌ ଆପୁଇଁୟାଃ ଆନ୍‌ଚୁ ମାନାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ଆୟାଃ ଦୁଲାଡ଼୍‌ରେ ତାଇକାନ୍‌ ଲେକାଗି ଆପେୟଗି ଆଇଁୟାଃ ଆନ୍‌ଚୁପେ ମାନାତିଙ୍ଗ୍‌ରେ ଆଇଁୟାଃ ଦୁଲାଡ଼୍‌ରେପେ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ଆଇଁୟାଃ ରାସ୍‌କା ଆପେରେ ତାଇନ୍‍କା ଆଡଃ ଆପେୟାଃ ରାସ୍‌କା ପୁରାଅଃ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆପେକେ ନେଆଁଁ କାଜିୟାଦ୍‌ପେୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ଆଇଙ୍ଗ୍‌ ଆପେକେ ଦୁଲାଡ଼୍‌କାଦ୍‍ପେ ଲେକା ଆପେୟ ଦୁପୁଲାଡ଼୍‌ପେ, ନେଆଁଁ ଆଇଁୟାଃ ଆନ୍‌ଚୁ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ଜେତାଏ ଆୟାଃ ଗାତିକଆଃ ନାଗେନ୍ତେ ଆୟାଃ ଜୀଉ ଏମଃନିୟାଃଏତେ ମାରାଙ୍ଗ୍‌ ଦୁଲାଡ଼୍‌ ଜେତ୍‌ନାଃ ବାନଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ଆଇଙ୍ଗ୍‌ ଆପେକେ ଏମାକାଦ୍‌ ଆନ୍‌ଚୁକେପେ ମାନାତିଙ୍ଗ୍‌ରେଦ ଆପେ ଆଇଁୟାଃ ଗାତିକ ତାନ୍‌ପେ । ");
INSERT INTO unx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ଆଇଙ୍ଗ୍‌ ଆପେକେ ଆଡଃ ଦାସି ମେନ୍ତେ କାଇଙ୍ଗ୍‌ କାଜିପେତାନା, ଚିୟାଃଚି ଗମ୍‌କେ ଚିନାଃ କାମିତାନ୍‌ତେୟାଃ, ଦାସି କାଏ ସାରିୟାଃ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେ ଗାତି ମେନ୍ତେ କାଜିପେତାନାଇଙ୍ଗ୍‌ ଚିୟାଃଚି ଆଇଁୟାଃ ଆପୁଇଙ୍ଗ୍‌ତାଃଏତେ ଆୟୁମ୍‌କାଦ୍‌ ସବେନାଃ ଆପେକେ ଉଦୁବାକାଦ୍‌ପେୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ଆପେ ଆଇଙ୍ଗ୍‌କେ କାପେ ସାଲାକାଦିୟାଁଃ ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାଲାକାଦ୍‍ପେୟାଇଙ୍ଗ୍‌ । ଆପେ ଜେ'ଲେକା ପୁରାଃଗି ଜ ଦାଡ଼ିୟଃଆପେ ଆଡଃ ଏନ୍‌ ଜ ଜାନାଅଗି ତାଇନଃକା ମେନ୍ତେଇଙ୍ଗ୍‌ ସାଲାକାଦ୍‌ପେୟା । ଏନାତେ ଆପେ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ଆପୁକେ ଜେତ୍‌ନାଃ ଆସିତେୟାଃ ଆପେକେ ଏମାପେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ଆଇଙ୍ଗ୍‌ ଆପେକେ ଦୁଲାଡ଼୍‌ପେତାନ୍‌ ଲେକାଗି ଆପେ ଆପେଗି ଦୁପୁଲାଡ଼୍‌ପେ, ନେଆଁଁ ଆଇଁୟାଃ ଆନ୍‌ଚୁ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ଅତେଦିଶୁମ୍‌ ଆପେକେ ହିଲାଙ୍ଗ୍‌ପେରେଦ, ଆପେକେ ହିଲାଙ୍ଗ୍‌ ସିଦାରେ ଆଇଙ୍ଗ୍‌କେ ହିଲାଙ୍ଗ୍‌କାଦିୟାଁଏ ଏନା ସାରିପେ । ");
INSERT INTO unx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ଆପେ ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ତାଇକାନ୍‌ରେଦ ଅତେଦିଶୁମ୍‌ ଆପେକେ ଆଇଃକ୍‌ ଲେକାଗି ଦୁଲାଡ଼୍‌କାପେତେୟାଃଏ । ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେ ଅତେଦିଶୁମ୍‌ଏତେ ସାଲାକାଦ୍‌ପେୟାଇଙ୍ଗ୍‌, ଆଡଃ ଆପେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ନାହାଁଲାପେ ଏନାତେ ଆପେକେ ଅତେଦିଶୁମ୍‌ ହିଲାଙ୍ଗ୍‌ପେତାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ଦାସି ଆୟାଃ ଗମ୍‌କେଏତେ କାଏ ମାରାଙ୍ଗ୍‌ଆଃ ମେନ୍ତେ କାଜିୟାଦ୍‍ପେ କାଜି ପାହାମେପେ । ଇନ୍‌କୁ ଆଇଙ୍ଗ୍‌କେ ସିଗିଦ୍‍କାଦିଙ୍ଗ୍‌ ରେଦକ ଆପେକେୟଗି ସିଗିଦ୍‍ପେୟାକ, ଇନ୍‌କୁ ଆଇଁୟାଃ କାଜି ମାନାତିଙ୍ଗ୍‌ଲେରେ ଆପେୟାଃ କାଜିକେୟକ ମାନାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ମେନ୍‌ଦ ଇନ୍‌କୁ ଆଇଁୟାଃ ନୁତୁମ୍‌ ନାଗେନ୍ତେ ନେ ସବେନାଃ ଆପେକେୟ ରିକାପେୟାକ, ଚିୟାଃଚି ଇନ୍‌କୁ ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‌ନିଃକେ କାକ ସାରିୟା ? ");
INSERT INTO unx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ଆଇଙ୍ଗ୍‌ ହିଜୁଃକେଦ୍‍ତେ ଇନ୍‌କୁକେ କାଇଙ୍ଗ୍‌ କାଜିକାକରେଦ ଇନ୍‌କୁଆଃ ପାପ୍‌ କା ହବାଅଃତେୟାଃ, ମେନ୍‌ଦ ନାହାଁଃ ଆକଆଃ ପାପ୍‌ ନାଗେନ୍ତେ ଇନ୍‌କୁ ଜେତ୍‌ନାଃ କାକ ବାହାନା ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଆଇଙ୍ଗ୍‌କେ ହିଲାଙ୍ଗ୍‌ନିଃ ଆଇଁୟାଃ ଆପୁକେହଗି ହିଲାଙ୍ଗ୍‌ଆଁଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ଜେତାଏ କାକ କାମିୟାକାଦ୍ କାମି ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁଆଃ ଥାଲାରେ କାଇଙ୍ଗ୍‌ କାମିକେଦ୍‌ରେଦ ଇନ୍‌କୁଆଃ ପାପ୍‌ କା ହବାଅଃତେୟାଃ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ କାମିକାଦ୍‌ତେୟାଃ ନାହାଁଃ ଇନ୍‌କୁ ନେଲ୍‍କାଦାଃକ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆଡଃ ଆପୁଇଙ୍ଗ୍‌ ବାରାନ୍‌କିନ୍‌କେ ହିଲାଙ୍ଗ୍‌କାଦ୍‌ଲିୟାଁକ । ");
INSERT INTO unx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ମେନ୍‌ଦ ‘ଇନ୍‌କୁ ଆଇଙ୍ଗ୍‌କେ ସାମାଗିକ ହିଲାଙ୍ଗ୍‌କିଦିୟାଃଁ ।’ ଇନ୍‌କୁଆଃ ଆନ୍‌ଚୁରେ ନେ କାଜି ଅଲାକାନ୍‌ତେୟାଃ ପୁରାଅଃ ନାଗେନ୍ତେ ନେ'ଲେକା ହବାଅଃତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ଆପୁତାଃଏତେ ଆପେତାଃ ଆଇଙ୍ଗ୍‌ କୁଲି ଜୀଉରାଡ଼େଃ ଏମଃନିଃକେ ଚାଏ ଆପୁତାଃଏତେ ହିଜୁଃତାନ୍‍ ସାନାର୍‌ତିରେନ୍‍ ଆତ୍ମା ହିଜୁଃରେ ଆଇଁୟାଃ ବିଷାଏରେ ଗାୱା ଏମେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ଆଡଃ ଆପେୟ ଆଇଁୟାଃ ବିଷାଏରେ ଗାୱାପେ ଏମେୟା, ଚିୟାଃଚି ଆପେଦ ମୁନୁଏତେ ଆଇଁୟାଃଲଃ ତାଇକେନାପେ । ");
INSERT INTO unx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ଆପେ ଜେ'ଲେକା ବିଶ୍ୱାସ୍‌କେ ଆଲ୍‌ପେ ଆଦେକା ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ନେ ସବେନ୍‌ କାଜିଇଙ୍ଗ୍‌ ଉଦୁବାଦ୍‍ପେୟା । ");
INSERT INTO unx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ଇନ୍‌କୁ ଆପେକେ ସାମାଜ୍‌ଅଡ଼ାଃଏତେ ଆତମ୍‌ପେୟାକ, ଏନ୍‌ଦିପିଲି ହିଜୁଃଆ, ଚିମ୍‌ତାଙ୍ଗ୍‌ ଜେତାଏନିଃ ଆପେକେ ଗଏଃପେୟାଏ, ଇମ୍‌ତାଙ୍ଗ୍‌ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସେୱାତାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ ଆଟ୍‌କାରେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ଆଡଃ ଇନ୍‌କୁ ଆପେକେ ନେକାପେୟାକ ଚିୟାଃଚି ଇନ୍‌କୁ ଆପୁ ଆଡଃ ଆଇଙ୍ଗ୍‌କେ କାକ ସାରିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ମେନ୍‌ଦ ଏନ୍‍ ଦିପିଲି ସେଟେର୍‍ରେ ଆଇଙ୍ଗ୍‌ ଆପେକେ ନେ କାଜି କାଜିକାପେ ତାଇକେନାଇଙ୍ଗ୍‌, ଏନା ପାହାମେ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ନେ ସବେନ୍‌ କାଜି ଆପେକେ କାଜିୟାଦ୍‌ପେୟାଇଙ୍ଗ୍‌ । “ଆଇଙ୍ଗ୍‌ ଆପେଲଃ ତାଇକେନ୍‌ ଇମ୍‌ତା ମୁନୁଏତେ ନେ ସବେନ୍‌ କାଜି କାଇଙ୍ଗ୍‌ କାଜି । ");
INSERT INTO unx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ମେନ୍‌ଦ ନାହାଁଃ ଆଇଙ୍ଗ୍‌କେ କୁଲ୍‌ନିଃତାଃତେ ସେନଃତାନାଇଙ୍ଗ୍‌, ହଲେହଁ ଅକ୍‌ତାଃତେମ୍‌ ସେନଃତାନା ମେନ୍ତେ ଆପେକଏତେ ଜେତାଏ କାପେ କୁଲିଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ଆଡଃ ନାହାଁଃ ଆଇଙ୍ଗ୍‌ ଆପେକେ ନେ ସବେନ୍‌ କାଜି କାଜିୟାପେତାନ୍‌ ହରାତେ ଆପେ ଆପେୟାଃ ମନ୍‌ସୁରୁଦ୍‌ରେ ପୁରାଃଗିପେ ହୁଡିଙ୍ଗ୍‌ଜୀଉକାନା । ");
INSERT INTO unx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ସେନଃତେୟାଃ ଆପେୟାଃ ନାଙ୍ଗ୍‌ ପୁରାଃ ବୁଗିଅଆଃ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ସେନ୍‌ରେଦ ଜୀଉରାଡ଼େଃ ଏମଃନିଃ କାଏ ହିଜୁଃଆ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ସେନ୍‌ରେଦ ଇନିଃକେ ଆପେତାଃତେଇଙ୍ଗ୍‌ କୁଲିୟା । ");
INSERT INTO unx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ଆଡଃ ଇନିଃ ହିଜୁଃରେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କଆଃ ପାପ୍‌ରେୟାଃ ଏତ୍‌କାନ୍‌ ବିଷାଏ, ଧାର୍‌ମାନ୍‌ ବିଷାଏ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବିଚାର୍‌ ବିଷାଏରେ ଉଦୁବେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ପାପ୍‌ ବିଷାଏରେ ଇନ୍‌କୁ କାକ ଠାଉକା, ଚିୟାଃଚି ଇନ୍‌କୁ କାକ ବିଶ୍ୱାସେତାନା ");
INSERT INTO unx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଧାର୍‌ମାନ୍‌ ବିଷାଏରେ ଇନ୍‌କୁ କାକ ଠାଉକା, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ଆପୁତାଃତେ ସେନଃତାନାଇଙ୍ଗ୍‌, ଆପେ ଆଡଃ କାପେ ନେଲିୟାଃଁ । ");
INSERT INTO unx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ବିଚାର୍‌ ବିଷାଏରେ ଇନ୍‌କୁ କାକ ଠାଉକା, ଚିୟାଃଚି ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ଗମ୍‌କେଦ ବିଚାର୍‌ ଚାବାକାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ଆଇଙ୍ଗ୍‌ତାଃରେ ଆପେକେ ଆଡଃ ପୁରାଃଗି କାଜି ଉଦୁବାପେ ନାଙ୍ଗ୍‌ ମେନାଃ ମେନ୍‌ଦ ନାହାଁଃ ଆପେ ଏନାକେ କାପେ ସାହାତିଙ୍ଗ୍‌ ଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ମେନ୍‌ଦ ଇନିଃ, ଏନ୍‌ ସାର୍‌ତିରେନ୍‌ ଆତ୍ମା ହିଜୁଃରେ, ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହରା ଉଦୁବ୍‌କେଦ୍‌ତେ ଆପେକେ ସବେନ୍‌ ସାର୍‌ତିରେ ଆୟାର୍‌ ଇଦିପେୟାଏ । ଚିୟାଃଚି ଇନିଃଦ ଆୟାଃ ପେଡ଼େଃତେ କାଏ କାଜିୟା ମେନ୍‌ଦ ଆଇଃକ୍‌ ଆୟୁମ୍‌ତେୟାଃଗି କାଜିୟାଏ, ଆଡଃ ହିଜୁଃ ବିଷାଏକ ଉଦୁବାପେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ଇନିଃ ଆଇଙ୍ଗ୍‌କେ ମାଇନାନ୍‌ ଏମାଇଙ୍ଗ୍‌ୟାଁଏ, ଚିୟାଃଚି ଇନିଃଦ ଆଇଙ୍ଗ୍‌ କାଜିତେୟାଃ ଇଦିୟାଏ ଆଡଃ ଆପେକେ ଉଦୁବାପେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ଆପୁଇଁୟାଃ ସବେନାଃତେୟାଃ ଆଇଁୟାଃ ତାନାଃ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ କାଜିକେଦାଇଙ୍ଗ୍‌, ପାବିତାର୍‌ ଆତ୍ମା ଆଇଙ୍ଗ୍‌ ଏମ୍‌ତେୟାଃ ଇଦିୟାଏ ଆଡଃ ଆପେକେ ଉଦୁବାପେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ଆପେ ଆଡଃ କାଟିଃ ଘାଡ଼ିକାଦ୍‍ରେ କାପେ ନେଲିୟାଃଁ, ଏନ୍ତେ ଆଡଃ କାଟିଃ ଘାଡ଼ିକାଦ୍‍ରେପେ ନେଲିୟାଃଁ ।” ");
INSERT INTO unx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ଏନ୍ତେ ୟୀଶୁଆଃ ଚେଲାକଏତେ ଚିମିନ୍‍କ ଆକ ଆକରେକ କୁପୁଲିୟାନା, “କାଟିଃ ଘାଡ଼ିକାଦ୍‍ରେ କାପେ ନେଲିୟାଃଁ ଆଡଃ କାଟିଃ ଘାଡ଼ିକାଦ୍‍ରେପେ ନେଲିୟାଃଁ ଆଡଃ ‘ଆଇଙ୍ଗ୍‌ ଆପୁତାଃତେଇଙ୍ଗ୍‌ ସେନଃତାନା’ ମେନ୍ତେ ଇନିଃ କାଜିତାନ୍‌ତେୟାଃ ଚିନାଃ ତାନାଃ ? ");
INSERT INTO unx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ଏନ୍ତେ ଇନ୍‌କୁ କାଜିକେଦାଃକ, ‘କାଟିଃ ଘାଡ଼ିକାଦ୍‍’ ମେନ୍ତେ କାଜିରାଃ ମୁଣ୍ଡି ଚିନାଃ ତାନାଃ ? ଇନିଃ ଚିନାଃଏ କାଜି ତାନାଃ ଏନା ଆଲେ କାଲେ ସାରିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ଚେଲାକ ଇନିଃକେ କୁଲିନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନାକ ମେନ୍ତେ ଆଟ୍‌କାର୍‌କେଦ୍‌ଚି ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆଡଃ କାଟିଃ ଘାଡ଼ିକାଦ୍‌ରେ କାପେ ନେଲିୟାଃଁ ଆଡଃ କାଟିଃ ଘାଡ଼ିକାଦ୍‌ରେପେ ନେଲିୟାଃଁ, ମେନ୍ତେଇଙ୍ଗ୍‌ କାଜିୟାଦ୍‌ପେୟା ଏନା ନାଗେନ୍ତେଚି ଆପେ ଆପେରେଗି କୁପୁଲିୟଃତାନାପେ ? ");
INSERT INTO unx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଅତେଦିଶୁମ୍‌ ରାସ୍‌କାଅଃ ଇମ୍‌ତା ଆପେ ରାଆଃଏୟା ଆଡଃ ଏୟମେଁୟା, ଆପେ ଦୁକୁଃଆପେ ମେନ୍‌ଦ ଆପେୟାଃ ଦୁକୁ ରାସ୍‌କାରେ ବାଇୟଆଃ । ");
INSERT INTO unx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ମିଆଁଦ୍‌ ଆଣ୍‌ଦି କୁଡ଼ିରାଃ ହନ୍‌ ଜାନାମ୍‌ ଦିପିଲି ସେଟେର୍‍ୟାନ୍‍ରେ ଦୁକୁ ନାମେୟାଏ, ମେନ୍‌ଦ ଇନିଃ ହନ୍‌ ଜାନାମ୍‌ ତାୟମ୍‌ତେ ଅତେଦିଶୁମ୍‌ରେ ମିଆଁଦ୍‌ ହନ୍‌ ଜାନାମ୍‍ୟାନାଏ ମେନ୍ତେ ଆୟାଃ ଦୁକୁକେ ଆଡଃ କାଏ ପାହାମାଃ । ");
INSERT INTO unx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ଏନ୍‌ଲେକାଗି ନାହାଃଁଦ ଆପେ ଦୁକୁଃତାନାପେ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆପେକେ ଆଡଃମିସା ନେଲ୍‍ପେୟାଇଙ୍ଗ୍‌ ଆଡଃ ଆପେୟାଃ ମନ୍‌ ରାସ୍‌କାତେ ପେରେଜଃଆ ଆଡଃ ଏନ୍‌ ରାସ୍‌କା ଆପେତାଃଏତେ ଜେତାଏ କାକ ଇଦିଦାଡ଼ିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ଏନ୍‍ ହୁଲାଙ୍ଗ୍‌ ଆପେ ଆଇଙ୍ଗ୍‌କେ ଜେତ୍‌ନାଃ କାପେ କୁଲିୟାଁ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ସାର୍‌ତିଗି କାଜିୟାପେ ତାନାଇଙ୍ଗ୍‌, ଆପେ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ଆପୁଇଙ୍ଗ୍‌କେ ଜେତ୍‍ନାଃପେ ଆସିରେଦ ଇନିଃ ଏନାକେ ଏମାପେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ନାହାଁଃ ଜାକେଦ୍‌ ଆପେ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେ ଜେତ୍‌ନାଃ କାପେ ଆସିକାଦାଃ, ଆସିପେ ଆଡଃ ଆପେୟାଃ ରାସ୍‌କା ପେରେଜଃ ନାଗେନ୍ତେ ଆପେ ଏନାପେ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ଆଇଙ୍ଗ୍‌ ଆପେକେ ଜନ୍‌କା କାଜିତେ ନେ ସବେନ୍‌ କାଜିକ କାଜିକାଦ୍‌ପେୟାଇଙ୍ଗ୍‌ । ମେନ୍‌ଦ ଏନ୍‍ ଦିପିଲି ହିଜୁଃଆ, ଇମ୍‌ତା ଆଇଙ୍ଗ୍‌ ଜନ୍‌କା କାଜିତେ କାଇଙ୍ଗ୍‌ ଉଦୁବାପେୟା, ମେନ୍‌ଦ ଆପୁଇଁୟାଃ ବିଷାଏ ଆପେକେ ଉଦୁବ୍‌ଉତାର୍‌ପେୟା । ");
INSERT INTO unx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆପେ ଆଇଁୟାଃ ନୁତୁମ୍‌ତେପେ ଆସିୟା; ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପେୟାଃନାଙ୍ଗ୍‌ ଆପୁତାଃ ବିନ୍ତିୟାଇଙ୍ଗ୍‌ ଏନା କାଇଙ୍ଗ୍‌ କାଜିପେତାନା । ");
INSERT INTO unx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ଆପୁ ଆଇଃକ୍‌ଗି ଆପେକେ ଦୁଲାଡ଼ାଃଏ, ଚିୟାଃଚି ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼୍‌କାଦିୟାଃଁପେ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆପୁତାଃଏତେ ହିଜୁଃକାନାଇଙ୍ଗ୍‌ ଏନା ବିଶ୍ୱାସ୍‌କାଦାଃପେ । ");
INSERT INTO unx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ଆଇଙ୍ଗ୍‌ ଆପୁତାଃଏତେ ଅତେଦିଶୁମ୍‌ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ଆଡଃ ନାହାଁଃ ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ ବାଗିକେଦ୍‌ତେ ଆପୁତାଃତେ ସେନଃତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ୟୀଶୁଆଃ ଚେଲାକ କାଜିକିୟାଃକ, “ନେଲେମେ, ନାହାଃଁଦ ଆମ୍‌ ଜନ୍‌କା କାଜିତେଦ କାହା ମେନ୍‌ଦ ଫାର୍‌ଚିଗି କାଜିତାନାମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ନାହାଁଃ ଆଲେ ଆଟ୍‌କାର୍‌କାଦା, ଆମ୍‌ ସବେନାଃମ୍‌ ସାରିୟାଃ ଆଡଃ ଜେତାଏ ଆମ୍‌କେ ଜେତ୍‌ନାଃ କୁଲି କା ଲାଗାତିୟାଃଁ । ଏନାତେ ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେମ୍‌ ହିଜୁଆକାନା ଏନାଲେ ବିଶ୍ୱାସେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ଚିୟାଃ ନାହାଃଁପେ ବିଶ୍ୱାସେତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ନେଲେପେ, ଏନ୍‍ ଦିପିଲି ହିଜୁଃତାନା, ହେଗି ଏନା ସେଟେର୍‌ୟାନା, ଚିମ୍‌ତାଙ୍ଗ୍‌ ଆପେ ଛିତିବିତିକେଦ୍‌ତେ ଜେତେକ ଆପେୟାଃ ଆପାନ୍‌ ଅଡ଼ାଃତେପେ ସେନଃଆ, ଆଡଃ ଆଇଙ୍ଗ୍‌କେ ଏସ୍‌କାର୍‌ଗି ବାଗିତାଇଙ୍ଗ୍‌ରେୟ ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ଏସ୍‌କାରଃଆଃ, ଚିୟାଃଚି ଆପୁ ଆଇଁୟାଃଲଃ ମେନାଇୟା । ");
INSERT INTO unx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ଆପେ ସବେନ୍‌ ଆଇଁୟାଃରେ ଜୀଉସୁକୁ ନାମେ ନାଗେନ୍ତେ ନେଆଁଁ ଆଇଙ୍ଗ୍‌ କାଜିୟାଦ୍‍ପେୟା । ଅତେଦିଶୁମ୍‌ରେ ସାସାତିପେ ନାମେୟା ମେନ୍‌ଦ ଆଲପେ ବରଏୟା, ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌କେ ଜିତାୱାକାଦାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ୟୀଶୁ ନେଆଁଁ କାଜିକେଦ୍‌ଚି ସିର୍ମାସାଃ ସାଙ୍ଗିଲ୍‍ ରାକାବ୍‍କେଦ୍‍ତେ କାଜିକେଦାଃଏ, ହେ ଆବା ନେଡା ସେଟେରାକାନା, ହନ୍‌ ଆମ୍‌କେ ମାଇନାନ୍‌ମେ ନାଗେନ୍ତେ ହନ୍‍ତାମାଃକେ ମାଇନିମେ । ");
INSERT INTO unx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ଆମ୍‌ ଇନିଃକେ ସବେନ୍‌ ହଡ଼କଆଃରେ ଆକ୍‌ତେୟାର୍‌ରେ ନାଙ୍ଗ୍‌ ଏମାକାଇୟାମ୍‌, ଜେ'ଲେକା ଆମ୍‌ ଇନିଃକେ ଏମାକାଇ ସବେନ୍‌ ହଡ଼କକେ ଜାନାଅ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌ ଏମ୍‌ଦାଡ଼ିୟାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ଆଡଃ ମିଆଁଦ୍‌ଗି ସାର୍‌ତି ପାର୍‌ମେଶ୍ୱାର୍‌ ଆମ୍‌ ତାନ୍‌ମେ, ଆମ୍‌କେ ଆଡଃ ଆମ୍‌ କୁଲାକାଇ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌କେ ସାରିତେୟାଃଗି ଜାନାଅ ଜାନାଅରେୟାଃ ଜୀଦାନ୍‌ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଅକନ୍‌ କାମି ଏମାକାଇଙ୍ଗ୍‌ ତାଇନାମ୍‌ ଏନ୍‌ କାମି ଆଇଙ୍ଗ୍‌ ଟୁଣ୍ଡୁକେଦ୍‌ତେ ଅତେଦିଶୁମ୍‌ରେ ଆମ୍‌କେ ମାଇନାନ୍‌ କାଦ୍‌ମେଁୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ନାହାଁଃ, ହେ ଆବା, ଅତେଦିଶୁମ୍‌ ବାଇୟାନ୍‌ ସିଦାରେ ଆମାଃଲଃ ତାଇକେନ୍‌ ଇମ୍‌ତା ଆଇଁୟାଃ ଅକନ୍‌ ମାନାରାଙ୍ଗ୍‌ ତାଇକେନା ଏନ୍‌ ମାନାରାଙ୍ଗ୍‌ତେ ଆଇଙ୍ଗ୍‌କେ ଆମାଃଲଃ ମାନାରାଙ୍ଗ୍‌ ରିକାଇଙ୍ଗ୍‌ମେଁ । ");
INSERT INTO unx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ଅତେଦିଶୁମ୍‌ରେନ୍‍କଏତେ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଦିଙ୍ଗ୍‌ ହଡ଼କକେ, ଆମାଃ ନୁତୁମ୍‌ ଉଦୁବାକାଦ୍‍କଆଇଙ୍ଗ୍‌, ଇନ୍‌କୁ ଆମାଃକ ତାଇକେନା ଆଡଃ ଆମ୍‌ ଇନ୍‌କୁକେ ଏମାକାଦିୟାଁମ୍‌ ଆଡଃ ଇନ୍‌କୁ ଆମାଃ କାଜିକ ମାନାତିଙ୍ଗାଁକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଅକ୍‌ନାଃକ ଏମାକାଦିୟାଁମ୍‌ ଏନ୍‌ ସବେନାଃ ଆମାଃ ସାଃଏତେଗି ହିଜୁଆକାନା, ଏନା ଇନ୍‌କୁ ନାହାଃଁକ ଆଟ୍‌କାର୍‍କାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ଚିୟାଃଚି ଆମ୍‌ ଏମାକାଦିଙ୍ଗ୍‌ କାଜିକ ଇନ୍‌କୁକେ ଏମାକାଦ୍‍କଆଇଙ୍ଗ୍‌ ଆଡଃ ଇନ୍‌କୁ ଏନାକ ତେଲାକାଦାଃ; ଆଇଙ୍ଗ୍‌ ଆମାଃ ସାଃଏତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌ ଏନା ସାର୍‌ତିଗିକ ଆଟ୍‌କାର୍‍କାଦାଃ, ଆଡଃ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁମ୍‌ ଏନା ବିଶ୍ୱାସ୍‌କାଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁ ନାଗେନ୍ତେ ବିନ୍ତିତାନାଇଙ୍ଗ୍‌, ଅତେଦିଶୁମ୍‌ ନାଗେନ୍ତେ କାହା ମେନ୍‌ଦ ଆମ୍‌ ଏମାକାଦିଙ୍ଗ୍‌ ହଡ଼କଆଃ ନାଗେନ୍ତେ ବିନ୍ତିତାନାଇଙ୍ଗ୍‌, ଚିୟାଃଚି ଇନ୍‍କୁଦ ଅାମାଃଗି ତାନ୍‍କୁ । ");
INSERT INTO unx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ଆଡଃ ଆଇଁୟାଃ ସବେନାଃ ଆମାଃ ତାନାଃ, ଆଡଃ ଆମାଃ ସବେନାଃ ଆଇଁୟାଃ ତାନାଃ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁଆଃ ହରାତେ ମାଇନାନ୍‌ କାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ଆଡଃ ନାହାଁଃ ଆଇଙ୍ଗ୍‌ ନେ ଅତେଦିଶୁମ୍‌ରେ କାଇଙ୍ଗ୍‌ ତାଇନାଃ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଅତେଦିଶୁମ୍‌ରେକ ତାଇନାଃ, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଆମାଃତାଃତେ ହିଜୁଃତାନାଇଙ୍ଗ୍‌ । ଏ ପାବିତାର୍‌ ଆବା ! ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଦିଙ୍ଗ୍‌ ନୁତୁମ୍‌ରାଃ ପେଡ଼େଃତେ ବାଞ୍ଚାଅକମେ, ଆମ୍‌ ଏମାକାଦିଙ୍ଗ୍‌ ନୁତୁମ୍‌ତେ, ଆମ୍‌ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଜେ'ଲେକା ମିଦ୍‌ତାନ୍‌ଲାଙ୍ଗ୍‌, ଏନ୍‌ଲେକା ଇନ୍‌କୁ ମିଦଃକାକ । ");
INSERT INTO unx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ଆଇଙ୍ଗ୍‌ ଇନ୍‍କୁଲଃ ତାଇକେନ୍‌ ଇମ୍‌ତା ଆମ୍‌ ଏମାକାଦ୍‍ ଆମାଃ ନୁତୁମ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ବାଞ୍ଚାଅକେଦ୍‌ତେ ବୁଗିଲେକା ଯାତାନ୍‌କାଦ୍‌କଆଇଙ୍ଗ୍‌, ଆଡଃ ଧାରାମ୍‌ପୁଥିରାଃ ଅନଲ୍‌ ଜେ'ଲେକା ସାର୍‌ତିୟଆଃ, ଏନାମେନ୍ତେ ଏନ୍‌ ଜିୟନଃ ହନ୍‌କେ ବାଗିକେଦ୍‌ତେ ଇନ୍‌କୁଏତେ ଜେତାଏ କାକ ଜିୟନାକାନା । ");
INSERT INTO unx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ନାହାଁଃ ଆମାଃତାଃତେଇଙ୍ଗ୍‌ ହିଜୁଃତାନା ଆଡଃ ଇନ୍‌କୁଆଃ ମନ୍‌ରେ ଆଇଁୟାଃ ରାସ୍‌କା ପେରେଜଃ ନାଗେନ୍ତେ ଅତେଦିଶୁମ୍‌ରେ ତାଇନ୍‌କେଦ୍‌ତେଗି ଆଇଙ୍ଗ୍‌ ନେ ସବେନାଃ କାଜିତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ଆମାଃ କାଜି ଏମାକାଦ୍‌କଆଇଙ୍ଗ୍‌, ଆଡଃ ଅତେଦିଶୁମ୍‌ ଇନ୍‌କୁକେ ହିଲାଙ୍ଗ୍‌କାଦ୍‌କଆଏ, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଜେ'ଲେକା ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ନାହାଁଲାଇଙ୍ଗ୍‌ ଏନ୍‌ଲେକା ଇନ୍‌କୁ ନେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ନାହାଁଲାକ । ");
INSERT INTO unx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ଆମ୍‌ ଇନ୍‌କୁକେ ଅତେଦିଶୁମ୍‌ଏତେ ଇଦିକୁମେ ମେନ୍ତେ କାଇଙ୍ଗ୍‌ ବିନ୍ତିମେତାନା, ମେନ୍‌ଦ ଆମ୍‌ ଇନ୍‌କୁକେ ଏତ୍‌କାନ୍‌ଏତେ ବାଞ୍ଚାଅକମେ ମେନ୍ତେ ବିନ୍ତିମେତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ଆଇଙ୍ଗ୍‌ ଜେ'ଲେକା ଅତେଦିଶୁମ୍‌ରେନ୍‌ ନାହାଁଲାଇଙ୍ଗ୍‌ ଏନ୍‌ଲେକା ଇନ୍‌କୁ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ନାହାଁଲାକ । ");
INSERT INTO unx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ସାନାର୍‌ତିତେ ଇନ୍‌କୁକେ ପାବିତାର୍‌ କାମି ନାଙ୍ଗ୍‌ ଜିମାକମେ; ଆମାଃ କାଜିଦ ସାର୍‌ତି ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଜେ'ଲେକା ଅତେଦିଶୁମ୍‍ତେମ୍‌ କୁଲ୍‍କାଦିୟାଁ, ଏନ୍‌ଲେକା ଆଇଙ୍ଗ୍‌ହଁ ଇନ୍‌କୁକେ ଅତେଦିଶୁମ୍‌ତେ କୁଲାକାଦ୍‌କଆଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ଆଡଃ ଇନ୍‌କୁ ହଁ ସାନାର୍‌ତିରେକ ପାବିତାରଃକା ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁ ନାଗେନ୍ତେ ପାବିତାର୍‌ କାମି ନାଙ୍ଗ୍‌ ଜିମାନ୍‌ ତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁଆଃ ନାଗେନ୍ତେ ଏସ୍‍କାର୍ କାହା ମେନ୍‌ଦ ଇନ୍‌କୁଆଃ କାଜିରେୟାଃ ହରାତେ ଆଇଙ୍ଗ୍‌ରେ ବିଶ୍ୱାସେତାନ୍‌ ସବେନ୍‌କଆଃ ନାଗେନ୍ତେ ବିନ୍ତିତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ହେ ଆବା ! ଇନ୍‌କୁ ଜେତେକ ଜେ'ଲେକା ମିଦଃକାକ ମେନ୍ତେ ଇନ୍‌କୁଆଃ ନାଙ୍ଗ୍‌ ବିନ୍ତିମେତାନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ଆମାଃରେ ଆଡଃ ଆମ୍‌ ଆଇଁୟାଃରେ ମେନାମେ ଲେକା, ଇନ୍‌କୁହ ସବେନ୍‌କ ଆବୁରେ ତାଇନଃକାକ, ଜେ'ଲେକାଚି ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁମ୍‌ ଏନା ଅତେଦିଶୁମ୍‌ରେନ୍‌କ ବିଶ୍ୱାସେୟା । ");
INSERT INTO unx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଦିଙ୍ଗ୍‌ ମାନାରାଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ଏମାକାଦ୍‌କଆଇଙ୍ଗ୍‌, ଆମ୍‌ ଆଡଃ ଆଇଙ୍ଗ୍‌ ମିଦ୍‌କାନ୍‌ ଲେକା ଇନ୍‌କୁହ ମିଦଃକାକ । ");
INSERT INTO unx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ଆଇଙ୍ଗ୍‌ ଇନ୍‍କୁରେ ଆଡଃ ଆମ୍‌ ଆଇଁୟାଃରେ ମେନାମେୟା, ଏନାତେ ଇନ୍‌କୁ ମିଦ୍‌ ଉତାରଃକା ଆଡଃ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁମ୍‌ ଆଡଃ ଦୁଲାଡ଼୍‌କାଦିୟାଁମ୍‌ ଲେକା ଇନ୍‌କୁକେହ ଦୁଲାଡ଼ାକାଦ୍‌କଆମ୍‌ ମେନ୍ତେ ଅତେଦିଶୁମ୍‌ରେନ୍‌କ ଆଟ୍‌କାରେକା । ");
INSERT INTO unx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ହେ ଆବା, ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଦିଙ୍ଗ୍‌ ହଡ଼କ ଆଇଙ୍ଗ୍‌ ତାଇନଃତାଃରେକ ତାଇନଃକା, ଏନାତେ ଇନ୍‌କୁ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଦିଙ୍ଗ୍‌ ମାନାରାଙ୍ଗ୍‌କ ନେଲେକା ମେନ୍ତେ ସାନାଙ୍ଗ୍‌ତାନାଇଙ୍ଗ୍‌, ଚିୟାଃଚି ଆମ୍‌ଦ ଅତେଦିଶୁମ୍‌ ବାଇୟେ ସିଦାରେ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼୍‌କାଦିୟାଁମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ଏ ଧାର୍‌ମାନ୍ ଆବା, ଅତେଦିଶୁମ୍‌ ଆମ୍‌କେ କାଏ ସାରିୟାକାଦ୍‌ମେୟା ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ସାରିୟାକାଦ୍‍ମେୟାଇଙ୍ଗ୍‌ ଆଡଃ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁମ୍‌ ଏନା ନିକୁ ସାରିୟାକାଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଅକନ୍‌ ଦୁଲାଡ଼୍‌ରେମ୍‌ ଦୁଲାଡ଼୍‌କାଦିୟାଁ ଏନ୍‍ ଦୁଲାଡ଼୍‌ ଇନ୍‍କୁରେ ତାଇନଃକା, ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନ୍‍କୁରେ ତାଇନଃନାଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ଆମାଃ ନୁତୁମ୍‌ ଉଦ୍‌ବାକାଦ୍‌କଆଇଙ୍ଗ୍‌ ଆଡଃ ଉଦୁବାକୁଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ୟୀଶୁ ନେ ବିନ୍ତି ଚାବାକେଦ୍‌ଚି, ଆୟାଃ ଚେଲାକଲଃ କିଦ୍‌ରୋନ୍‌ ଲର୍‍ ହାନ୍‍ ପାରମ୍‍ତେ ସେନଃୟାନାକ, ଏନ୍ତାଃରେ ମିଆଁଦ୍‌ ବାଗାନ୍‌ ତାଇକେନା, ଏନାରେ ଇନିଃ ଆଡଃ ଆୟାଃ ଚେଲାକ ବଲୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ୟୀଶୁକେ ସାବ୍‌ରିକାନିଃ ଯିହୁଦା, ଏନ୍‍ ଠାୟାଦ୍‍କେ ସାରିକାଦ୍‌ ତାଇକେନାଏ, ଚିୟାଃଚି ୟୀଶୁ ଆୟାଃ ଚେଲାକଲଃ ପୁରାଃ ଦିପିଲି ଏନ୍‌ ଠାୟାଦ୍‌ତେ ସେନାକାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ଏନ୍ତେ ଯିହୁଦା, ପାଲ୍‌ଟାନ୍‌କ, ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ଫାରୁଶୀକ ସାଃଏତେ ଦାରୱାନ୍‌କକେ ଆଉକେଦ୍‌ତେ ଦିମି ଆଡଃ ହାଁତେୟାର୍‌ ସାବ୍‌କେଦ୍‌ତେ ଏନ୍ତାଃତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ଏନାତେ ୟୀଶୁ ଆୟାଃରେ ହିଜୁଃତାନ୍‌ ହବାଅଃତେୟାଃ ସବେନାଃ ସାରିକେଦ୍‍ତେ ଅଡଙ୍ଗ୍‌ୟାନା ଆଡଃ ଆପେ ଅକଏକେ ଦାଣାଁଁତାନାପେ ମେତାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁକେ” ମେନ୍ତେକ କାଜିରୁହାଡ଼୍‌କିୟା । ୟୀଶୁ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ ।” ଆଡଃ ୟୀଶୁକେ ସାବ୍‌ରିକାନିଃ ଯିହୁଦା ଇନ୍‍କୁଲଃ ତିଙ୍ଗୁଆକାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ୟୀଶୁ ଚିମ୍‌ତାଙ୍ଗ୍‌ ଇନ୍‌କୁକେ “ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌” ମେତାଦ୍‌କଆଏ, ଇମ୍‌ତା ଇନ୍‌କୁ ଇମ୍‍ତାଗି ଦୟା ରୁହାଡ଼୍‌କେଦ୍‍ତେ ଅତେରେକ ଉୟୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ ଆଡଃମିସା କୁଲିକେଦ୍‌କଆଏ, “ଆପେ ଅକଏକେ ଦାଣାଁଁତାନାପେ ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟା, “ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁକେ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ୟୀଶୁ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ୟୀଶୁ ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌ ମେନ୍ତେ ସିଦାରେ କାଜିୟାଦ୍‍ପେୟାଇଙ୍ଗ୍‌ । ଆପେ ଆଇଙ୍ଗ୍‌କେ ଦାଣାଁଁତାନ୍‍ରେଦ ନିକୁକେ ସେନ୍‍ରିକାକପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“ଆବା, ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଏମାକାଦିଙ୍ଗ୍‌ ହଡ଼କଏତେ ମିହୁଡ଼୍‌କେହଁ କାଇଙ୍ଗ୍‌ ଆଦାକାଇୟାଃ ।” ଇନିଃ ନେ କାଜି କାଜିକେଦାଃଏ, ଜେ'ଲେକାଚି ଇନିୟାଃ ନେ କାଜି ପୁରାୱାଃ । ");
INSERT INTO unx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ତାଃରେ ତାରାଉଡ଼ି ତାଇକେନା, ଏନାକେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଇନିଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଦାସିକେ ମାଆଃକିୟାଏ ଆଡଃ ଜମ୍‌ସାଃରାଃ ଲୁତୁର୍‍କେ ମାଆଃଖାଣ୍ଡାଅକେଦାଏ, ଏନ୍‍ ଦାସିଆଃ ନୁତୁମ୍‌ ମାଲ୍‌ଖ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ଏନ୍ତେ ୟୀଶୁ ପାତ୍‌ରାସ୍‌କେ କାଜିକିୟାଏ, “ଆମାଃ ତାରାଉଡ଼ିକେ ଖାପ୍‌ରେ ଦହଏମେ, ଆପୁ ଏମାକାଇଙ୍ଗ୍‌ କାଟୋରାରେ ଚିୟାଃ ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ନୁଁଇୟା ?” ");
INSERT INTO unx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ଏନ୍ତେ ପାଲ୍‍ଟାନ୍‌କ, ପାଲ୍‍ଟାନ୍‍ରେନ୍ ଗମ୍‌କେ ଆଡଃ ଯିହୁଦୀକଆଃ ଦାରୱାନ୍‌କ ୟୀଶୁକେ ସାବ୍‍ଇଦିକେଦ୍‍ତେ ତଲ୍‍କିୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ସିଦାତେ କାୟଫାରାଃ ହୟାଁର୍‍ତେ ହାନାନ୍‌ତାଃତେକ ଇଦିକିୟାଃ, ଇନିଃଦ ଏନ୍‍ ସିର୍ମାରେନ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ସବେନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ହଡ଼ ଗଜଃରେଦ ବୁଗିୟଆଃ ମେନ୍ତେ ଯିହୁଦୀ ହାକିମ୍‌କକେ କାଜିକାଦ୍‌କ ତାଇକେନାଏ, ଇନିଃ ଏନ୍‌ କାୟଫା ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଏଟାଃ ମିହୁଡ଼୍‌ ଚେଲା ୟୀଶୁକେ ଅତଙ୍ଗ୍‌ ଇଦିକିୟାଏ, ଏନ୍‍ ଏଟାଃ ଚେଲା ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ନେପେଲ୍‌ ଉପୁରୁମ୍ ହଡ଼ ତାଇକେନାଏ, ଏନାମେନ୍ତେ ଇନିଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଅଡ଼ାଃରାଚାତେ ୟୀଶୁଲଃ ବଲୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ ରାଚା ଦୁଆର୍‍ତାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ତାଇକେନାଏ, ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଲଃ ନେପେଲ୍ ଉରୁମାକାନ୍‌ ଏଟାଃ ଚେଲା ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଦୁଆର୍‌ ହରତାନ୍ କୁଡ଼ିକେ କାଜିକିୟାଏ, ଆଡଃ ପାତ୍‌ରାସ୍‌କେ ଅଡ଼ାଃ ଭିତାର୍‌ତେ ଇଦିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ଏନ୍ତେ ଦୁଆର୍‌ ହରତାନ୍ ଏନ୍‌ କାମ୍‌ଡ଼ି କୁଡ଼ି ପାତ୍‌ରାସ୍‌କେ କାଜିକିୟାଏ, “ଚିୟାଃ ଆମ୍‌ ହଁ ନେ ହଡ଼ଆଃ ଚେଲାକଏତେ ମିଆଁଦ୍‌ନିଃ ନାହାଁଲାମ୍‌ ?” ଇନିଃ ମେତାଇଜାଏ, “ଆଇଙ୍ଗ୍‌ ନାହାଁଲିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ରାବାଙ୍ଗ୍‌ତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଦାସିକ ଆଡଃ ଦାରୱାନ୍‌କ ସେଙ୍ଗେଲ୍ ତିଙ୍ଗ୍‌କେଦ୍‍ତେ ତିଙ୍ଗୁଆକାନ୍‍ଲଃ ଜୁରୁବ୍‍ ତାଇକେନାକ । ପାତ୍‌ରାସ୍‌ହଁ ଇନ୍‍କୁଲଃ ତିଙ୍ଗୁକେଦ୍‍ତେ ଜୁରୁବ୍‍ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ୟୀଶୁକେ ଆୟାଃ ଚେଲାକ ବିଷାଏରେ ଆଡଃ ଆୟାଃ ଇନିତୁ ବିଷାଏରେ କୁଲିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ରେ ସବେନ୍‌ଇମ୍‌ତା ସବେନ୍‌କତାଃରେ କାଜିୟାକାଦାଇଙ୍ଗ୍‌, ଯିହୁଦୀକ ହୁଣ୍ଡିନ୍‌ତାନ୍‍ ସବେନ୍‍ତାଃରେ, ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଆଡଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଆଇଙ୍ଗ୍‌ ଇତୁକେଦ୍‍କଆ ଆଡଃ ଦାନାଙ୍ଗ୍‌ରେ ଜେତ୍‌ନାଃ କାଇଙ୍ଗ୍‌ କାଜିକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ଚିନାଃମେନ୍ତେ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲିତାନାମ୍‌ ? ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ ଚିନାଃ କାଜିୟାକାଦ୍‌କଆଇଙ୍ଗ୍‌ ଏନା ଆୟୁମ୍‌କେନ୍‌କକେ କୁଲିକମ୍‌, ନେଲେମେ, ଆଇଙ୍ଗ୍‌ କାଜିକାଦ୍‌ତେୟାଃ ଇନ୍‌କୁ ସାରିୟାଃକ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ୟୀଶୁ ନେଆଁଁ କାଜିକେଦ୍‌ ଇମ୍‌ତା ନାଡ଼େଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ମିଆଁଦ୍‌ ଦାରୱାନ୍‌ ଇନିଃକେ ଥାପ୍‌ଡ଼ିକେଦ୍‍ତେ କାଜିକିୟାଏ, “ଆମାଃ ନାମିୟାଙ୍ଗ୍‌ ସାହାଁସ୍‌, ଚିୟାଃ ଆମ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କେ ନେ ଲେକା କାଜିରୁହାଡ଼ାଇତାନାମ୍ ?” ");
INSERT INTO unx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଙ୍ଗ୍‌ ଏତ୍‍କାନାଃ କାଜିକାଦ୍‍ରେଦ ନେତାଃରେ ଜେତେକଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ସାବୁଦ୍‌ ଉଦୁବେମେ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ବୁଗିନ୍‌ କାଜି କାଜିକାଦ୍‌ରେଦ ଚିନାଃମେନ୍ତେମ୍‌ ଥାପ୍‌ଡ଼ିଙ୍ଗ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ଏନ୍ତେ ହାନାନ୍‌ ଇନିଃକେ ତଲାକାନ୍‍ତେଗି ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ କାୟଫାତାଃତେ କୁଲ୍‍କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ତିଙ୍ଗୁକେଦ୍‍ତେ ସେଙ୍ଗେଲ୍ ଜୁରୁବ୍‌ତାନ୍‌ ତାଇକେନାଏ, ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ କୁଲିକିୟାକ, “ଚିୟାଃ ଆମ୍‌ ହଁ ଇନିୟାଃ ଚେଲାକଏତେ ମିହୁଡ଼୍‌ ନାହାଁଲାମେ ?” ଇନିଃ ଦଦାଦ୍‌ୟାନ୍ତେ କାଜିକେଦାଃଏ, “ଆଇଙ୍ଗ୍‌ ନାହାଁଲିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଦାସିକଏତେ ମିହୁଡ଼୍‌, ଅକଏକେଚି ପାତ୍‌ରାସ୍‌ ଲୁତୁର୍‍ ମାଃ ଖାଣ୍ଡାଅକାଇ ତାଇକେନାଏ, ଇନିୟାଃ ମିହୁଡ଼୍‌ କୁପୁଲ୍‌ କାଜିକେଦାଃଏ, “ଆଇଙ୍ଗ୍‌ ଚିନାଃ ଆମ୍‌କେ ଇନିଃଲଃ ବାଖ୍‌ଡ଼ିରେ କାଇଙ୍ଗ୍‌ ନେଲାକାମ୍‌ ତାଇକେନା ?” ");
INSERT INTO unx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଆଡଃଗି ଦଦାଦ୍‌ୟାନ୍ତେ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ନାହାଁଲିଙ୍ଗ୍‌” ଇମ୍‍ତାଗି ସାଣ୍ଡିସିମ୍‌ ରାଆଃକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ସେତାଃ ଇଦାନ୍‌ରେ ଇନ୍‌କୁ ୟୀଶୁକେ କାୟଫାତାଃଏତେ ଲାଟ୍‌ସାହେବ୍‌ଆଃ ଅଡ଼ାଃ ଭିତାର୍‌ତେକ ଇଦିକିୟା । ଜେ'ଲେକା କା ସତ୍‌ରାକେଦ୍‌ତେ ପାସ୍‌କା ପାରାବ୍‌ରେ ଜମେୟାଃଁ ଜମ୍‌ଦାଡ଼ିୟାଏ, ଏନାମେନ୍ତେ ଯିହୁଦୀ ହାକିମ୍‌କ ଲାଟ୍‌ସାହେବ୍‌ଆଃ ଅଡ଼ାଃତେ କାକ ବଲୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ଏନ୍ତେ ପିଲାତୁସ୍‌ ଇନ୍‍କୁତାଃତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ କୁଲିକେଦ୍‍କଆଏ, “ଆପେ ନେ ହଡ଼କେ ଚିନାଃମେନ୍ତେ ଚିଟାଇତାନାପେ ?” ");
INSERT INTO unx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ନେ ହଡ଼ ଏତ୍‍କାନ୍‌ କାମି କାଏ କାମିକାଦ୍‌ରେଦ ଆମାଃ ତିଃଇରେ କାଲେ ଏମିତେୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ଏନ୍ତେ ପିଲାତୁସ୍ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେ ଇନିଃକେ ଇଦିକେଦ୍‌ତେ, ଆପେୟାଃ ଆନ୍‌ଚୁ ଲେକାତେ ଇନିୟାଃ ବିଚାରେପେ ।” ଯିହୁଦୀକ ଇନିଃକେ କାଜିକିୟାକ, “ଜେତାଏକେ ଗଜି ନାଗେନ୍ତେ ଆଲେତାଃରେ ଆକ୍‌ତେୟାର୍‌ ବାନଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ୟୀଶୁକେ ଚିଲ୍‍କାନ୍ ଗନଏଃତେ ଗଜଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଏନ୍‌ ବିଷାଏରେ ଇନିଃ କାଜିଲେଦ୍‍ କାଜି ପୁରାଅଃ ନାଗେନ୍ତେ ଇନ୍‌କୁ ନେକା କାଜିକେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ପିଲାତୁସ୍‌ ଆୟାଃ ମାହାଲ୍‌ତେ ବଲ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ୟୀଶୁକେ କେଡ଼ାକିୟାଏ ଆଡଃ କୁଲିକିୟାଏ, “ଆମ୍‌ ଯିହୁଦୀକଆଃ ରାଜା ତାନ୍‍ମେଚି ?” ");
INSERT INTO unx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଚିୟାଃ ଆମ୍‌ ନେ କାଜି ଆମ୍‌ତେଗି କାଜିତାନାମ୍‌ ଚି ଏଟାଃକ ଆଇଁୟାଃ ବିଷାଏରେ ଆମ୍‌କେ ନେୟାଁକ ଉଦ୍‌ବାକାଦ୍‌ମେୟାଁ ?” ");
INSERT INTO unx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତୁସ୍ କାଜିରୁହାଡ଼୍‌କେଦାଃଏ, “ଆଇଙ୍ଗ୍‌ ଯିହୁଦୀ ତାନିଙ୍ଗ୍‌ଚି ? ଆମାଃ ଜାତିରେନ୍‍କ ଆଡଃ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆମ୍‌କେ ଆଇଁୟାଃ ତିଃଇରେକ ଏମାକାଦିୟାଁ । ଆମ୍‌ ଚିନାଃମ୍ ଚିକାକାଦାଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ୟୀଶୁ କାଜିକିୟାଏ, “ଆଇଁୟାଃ ରାଇଜ୍‌ ନେ ଅତେଦିଶୁମ୍‌ ଲେକା ନାହାଁଲାଃ, ଆଇଁୟାଃ ରାଇଜ୍‌ ନେ ଅତେଦିଶୁମ୍‌ ଲେକା ତାଇନ୍‌ତେୟାଃରେଦ ଆଇଙ୍ଗ୍‌ ଯିହୁଦୀ ହାକିମ୍‌କଆଃ ତିଃଇରେ କାଇଙ୍ଗ୍‌ ଏମଃନାଙ୍ଗ୍‌ ଆଇଁୟାଃ ଦାସିକ ମାପାଃତୁପୁଇଙ୍ଗ୍‌ତେୟାଃକ, ମେନ୍‌ଦ ଆଇଁୟାଃ ରାଇଜ୍‌ ଏନ୍‍ଲେକ୍‌ନାଃ ନାହାଁଲାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ଏନ୍ତେ ପିଲାତୁସ୍ ଇନିଃକେ କୁଲିକିୟାଏ, “ଚିୟାଃ ଆମ୍‌ ମିଆଁଦ୍‌ ରାଜା ତାନ୍‌ମେ ଚି ?” ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଙ୍ଗ୍‌ ରାଜା ତାନିଙ୍ଗ୍‌ ମେନ୍ତେ, ଆମ୍‌ଗି କାଜିତାନାମ୍‌ । ସାର୍‌ତିରେୟାଃ ଗାୱା କାଜି ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଜାନାମାକାନା ଆଡଃ ଅତେଦିଶୁମ୍‌ତେ ହିଜୁଆକାନାଇଙ୍ଗ୍‌, ଜେତାଏ ସାର୍‌ତିରେନ୍ ହନ୍‌ ତାନିଃ ଇନିଃ ଆଇଁୟାଃ କାଜି ଆୟୁମାଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତୁସ୍‌ ୟୀଶୁକେ କୁଲିକିୟାଏ, “ସାର୍‌ତି ଚିନାଃତାନାଃ ?” ଏନ୍ତେ ନେଆଁଁ କାଜିକେଦ୍‌ଚି ଇନିଃ ଆଡଃଗି ଯିହୁଦୀକତାଃତେ ହିଜୁଃ ରୁହାଡ଼୍‌ୟାନାଏ, ଆଡଃ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆଏ, “ସାଜାଇ ଏମ୍‌ନାଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ ଇନିଃରେ ଜେତାନ୍‍ ଗୁହ୍ନାଁ କାଇଙ୍ଗ୍‌ ନାମେତାନା । ");
INSERT INTO unx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ପାସ୍‌କା ପାରାବ୍‌ରେ ଆପେନାଙ୍ଗ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ଆଡ଼ାଃତେୟାଃ ଆପେୟାଃ ରିତିରେ ମେନାଃ, ଏନାମେନ୍ତେ ଆପେୟାଃ ନାଗେନ୍ତେ ଯିହୁଦୀକଆଃ ରାଜାକେଇଙ୍ଗ୍‌ ଆଡ଼ାଃତାଇୟା, ମେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନା ଚି ?” ");
INSERT INTO unx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ଏନ୍ତେ ସବେନ୍‌କ କାଉରିକେଦ୍‍ତେ କାଜିକେଦାଃକ, “ବାନଃଗି, ନିଃକେଦ କାହା, ମେନ୍‌ଦ ବାରବ୍‌ବାକେ ଏମାଲେମ୍‌ ।” ଏନ୍‌ ବାରବ୍‌ବା ମିଆଁଦ୍‌ ରେରେଃକ୍‌ନିଃ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ଏନ୍ତେ ପିଲାତୁସ୍ ୟୀଶୁକେ ଇଦିକିଃତେ ହାଁଣ୍‍ସା ରିକାକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ଆଡଃ ପାଲ୍‍ଟାନ୍‍କ ଜାନୁମ୍‌ କତରାଃ ଟୁପୁରି ଗାଲାଙ୍ଗ୍‌କେଦ୍‍ତେ ବହଃରେ ଟୁପୁରିକିୟାକ ଆଡଃ ଇନିଃକେ ବାଇଗିନିଆ ରାଙ୍ଗ୍‌ରାଃ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ଆଡଃ ଇନ୍‌କୁ ୟୀଶୁଆଃ ନାଡ଼େଃତେ ସେନ୍‌କେଦ୍‌ତେ କାଜିକିୟାକ, “ଏ ଯିହୁଦୀକଆଃ ରାଜା ଜହାର୍‍ !” ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ଥାପ୍‌ଡ଼ିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତୁସ୍‌ ଆଡଃମିସା ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ହଡ଼କକେ କାଜିୟାଦ୍‌କଆଏ, “ନେଲେପେ, ଇନିଃକେ ସାଜାଇ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇନିୟାଃରେ ଜେତାନ୍ ଗୁହ୍ନାଁ କାଇଙ୍ଗ୍‌ ନାମ୍‌କେଦା, ନେଆଁଁ ଆପେ ସାରିପେ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ଆପେତାଃତେଇଙ୍ଗ୍‌ ଅଡଙ୍ଗ୍‌ଆଉୱିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ଏନ୍ତେ ୟୀଶୁ ଜାନୁମ୍‌ ମୁକୁଟ୍‌ ଆଡଃ ବାଇଗିନିଆ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌କେଦ୍‍ତେ ଅଡଙ୍ଗ୍‌ୟାନା । ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ନେଲିପେ ! ନିଃ ନେ ହଡ଼ ।” ");
INSERT INTO unx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ଏନ୍ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ମାନ୍ଦିର୍‌ ଦାରୱାନ୍‌କ ଇନିଃକେ ନେଲ୍‍କେଦ୍‍ତେ “କ୍ରୁଶ୍‌ରେ କିଲାଇମେ ! କ୍ରୁଶ୍‌ରେ କିଲାଇମେ !” ମେନ୍ତେକ କାଉରିକେଦା । ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେଗି ଇନିଃକେ ଇଦିପେ ଆଡଃ କ୍ରୁଶ୍‌ରେ କିଲାଇପେ, ଆଇଙ୍ଗ୍‌ଦ ଇନିଃକେ ସାଜାଇ ନାଗେନ୍ତେ ଜେତାନ୍ ଗୁହ୍ନାଁ କାଇଙ୍ଗ୍‌ ନାମ୍‌କେଦା ।” ");
INSERT INTO unx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଯିହୁଦୀକ ପିଲାତୁସ୍‍କେ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଆଲେତାଃରେ ଆନ୍‌ଚୁ ମେନା ଆଡଃ ଏନ୍‍ ଆନ୍‌ଚୁ ଲେକାତେ ଇନିୟାଃ ଗଜଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଚିୟାଃଚି ଇନିଃଦ ଆଇଃକ୍‌ଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନିଃ” ମେନ୍ତେ କାଜିକାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ, ପିଲାତୁସ୍‌ ପୁରାଃଗି ବରକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ଆଡଃ ପିଲାତୁସ୍‌ ମାହାଲ୍‌ତେ ବଲ ରୁହାଡ଼୍‌ୟାନାଏ ଏନ୍ତେ ୟୀଶୁକେ କୁଲିକିୟାଏ, “ଆମ୍‌ ଅକ୍‌ତାଃଏତେମ୍‌ ହିଜୁଃକାନା ?” ମେନ୍‌ଦ ୟୀଶୁ ଇନିଃକେ କାଏ କାଜିରୁହାଡ଼୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ଏନ୍ତେ ପିଲାତୁସ୍‌ ଇନିଃକେ କାଜିକିୟାଏ, “ଚିନାଃମେନ୍ତେ କାମ୍‍ କାଜିୟାଇଙ୍ଗ୍‌ତାନା ? ଆମ୍‌କେ ରାଡ଼ାରେୟାଃ ଆଡଃ କ୍ରୁଶ୍‌ରେ କିଲାରେୟାଃ ଆକ୍‌ତେୟାର୍‌ ଆଇଙ୍ଗ୍‌ତାଃରେ ମେନାଃ, ଚିୟାଃ ନେଆଁଁ ଆମ୍‌ କାମ୍‌ ସାରିତାନା ?” ");
INSERT INTO unx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ୟୀଶୁ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆମ୍‌କେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ଆକ୍‌ତେୟାର୍‌ କା ନାମ୍‌କାନ୍‌ରେ, ଆଇଁୟାଃ ବିରୁଧ୍‌ରେ ଆମାଃ ଜେତାନ୍‌ ଆକ୍‌ତେୟାର୍‌ କା ତାଇନ୍‌ତେୟାଃ । ଏନାତେ ଆଇଙ୍ଗ୍‌କେ ଅକଏ ଆମାଃ ତିଃଇରେ ଜିମାକାଦିୟାଁଏ ଇନିୟାଃ ପାପ୍‌ ପୁରାଃ ଏତ୍‌କାନ୍‌ଗିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ପିଲାତୁସ୍‌ ନେୟାଁ ଆୟୁମ୍‌କେଦ୍‌ଚି, ୟୀଶୁକେ ରାଡ଼ାଇ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌କେଦାଃଏ, ମେନ୍‌ଦ ଯିହୁଦୀ ହଡ଼କ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଃକ, “ଆମ୍‌ ନେ ହଡ଼କେ ରାଡ଼ାଇରେଦ, ଆମ୍‌ କାଇସାର୍‌ଆଃ ଗାତି ନାହାଁଲାଃମେ, ଅକଏ ଆଇଃକ୍‌କେଗି ରାଜା ମେନ୍ତେ କାଜିୟାଏ, ଇନିଃ କାଇସାର୍‌ଆଃ ବିରୁଧ୍‌ରେ କାଜିୟାଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ଏନ୍ତେ ପିଲାତୁସ୍‌ ନେ କାଜିକ ଆୟୁମ୍‌କେଦ୍‌ଚି, ୟୀଶୁକେ ଅଡଙ୍ଗ୍‌କିୟାଏ ଆଡଃ “ଚାଟେନ୍‌ଲାପାଙ୍ଗା” ଅକ୍‌ନାଃଚି ଏବ୍ରୀ ଜାଗାର୍‌ତେ “ଗାବ୍‌ବାଥା” ନୁତୁମଃତାନା, ଏନ୍‌ ବିଚାର୍‌ ଠାୟାଦ୍‌ତାଃରେ ବିଚାର୍‌ ନାଙ୍ଗ୍‌ ଦୁବ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ପାସ୍‌କା ପାରାବ୍‌ ସାପ୍‍ଡ଼ାଅନ୍‍ ହୁଲାଙ୍ଗ୍‌ରେୟାଃ ତିକିନ୍‌ସିଙ୍ଗି ସିଦାରେ ଇନିଃ ଯିହୁଦୀକକେ କାଜିୟାଦ୍‌କଆଏ, “ନେଲିପେ ନିଃ ଆପେୟାଃ ରାଜା !” ");
INSERT INTO unx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ଇନ୍‌କୁ କାଉରିକେଦାଃକ, “ଇନିଃକେ ଗଜିମେଁ ! ଗଜିମେଁ ! କ୍ରୁଶ୍‌ରେ କିଲାଇମେ ।” ପିଲାତୁସ୍‌ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆଏ, “ଆପେୟାଃ ରାଜାକେ କ୍ରୁଶ୍‍ରେଇଙ୍ଗ୍‌ କିଲାଇୟା ମେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନାଚି ?” ମୁଲ୍‌ ଯାଜାକ୍‌କ କାଜିରୁହାଡ଼୍‌କିୟାଃକ, “କାଇସାର୍‌ ଏସ୍‌କାର୍‌ ଆଲେୟାଃ ରାଜା ତାନିଃ ଆଡଃ ଜେତାଏ ରାଜା ନାହାଲିଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ଏନ୍ତେ ୟୀଶୁ କ୍ରୁଶ୍‌ରେ କିଲାଅଃକାଏ ମେନ୍ତେ ପିଲାତୁସ୍ ଇନିଃକେ ଇନ୍‌କୁଆଃ ସାନାଙ୍ଗ୍‌ ଲେକାତେ ଏମାଦ୍‍କଆଏ । ଏନ୍ତେ ଇନ୍‌କୁ ୟୀଶୁକେ ସାବ୍‌କେଦ୍‌ତେ ଇଦିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ୟୀଶୁ ଆୟାଃ କ୍ରୁଶ୍‍କେ ଗଅଃକେଦ୍‌ତେ “ବହଃଜାଙ୍ଗ୍‌ ନୁତୁମ୍‌ ଠାୟାଦ୍‌” ଅକ୍‌ନାଃଚି ଏବ୍ରୀ ଜାଗାର୍‌ତେ “ଗାଲ୍‌ଗାଥା” ମେନ୍ତେ କାଜିୟଃତାନା, ଏନ୍ତାଃତେ ହିଜୁଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ଏନ୍ତାଃରେ ଇନ୍‌କୁ ଇନିଃକେ ଆଡଃ ଇନିଃଲଃ ବାର୍‍ହଡ଼୍‌କିନ୍‍କେ କ୍ରୁଶ୍‌ରେ କିଲାକେଦ୍‍କିନାକ, ମିଆଁଦ୍‌ନିଃକେ ଆୟାଃ ଜମ୍‍ ସାଃରେ ଆଡଃ ମିଆଁଦ୍‌ନିଃକେ ଲେଙ୍ଗା ସାଃରେ ଆଡଃ ୟୀଶୁକେ ଥାଲାରେ କିଲାକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ଆଡଃ ପିଲାତୁସ୍ ମିଆଁଦ୍‌ ଅନଲ୍‌ଚିଠା ଅଲ୍‌କେଦ୍‌ତେ କ୍ରୁଶ୍‌ରେ ଲାଟ୍‌କାଅକେଦାଃଏ, ଆଡଃ ଏନାରେ “ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ ଯିହୁଦୀକଆଃ ରାଜା” ମେନ୍ତେ ଅଲାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ୟୀଶୁ କ୍ରୁଶ୍‌ରେ କିଲାୟାନ୍‌ ଠାୟାଦ୍‍ ହାତୁ ନାଡ଼େଃରେ ତାଇକେନ୍‌ ନାଗେନ୍ତେ ଏନ୍‍ ଅନଲ୍‌ଚିଠାକେ ପୁରାଃ ଯିହୁଦୀକ ପାଢ଼ାଅକେଦାଃ ଆଡଃ ଏନା ଏବ୍ରୀ, ଲାଟିନ୍‌, ଆଡଃ ଗ୍ରୀକ୍‌ ଜାଗାର୍‌ରେ ଅଲାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ଏନ୍ତେ ଯିହୁଦୀକଆଃ ମୁଲ୍‌ ଯାଜାକ୍‌କ ପିଲାତୁସ୍‌କେ କାଜିକିୟାଃକ, “ଯିହୁଦୀକଆଃ ରାଜା ମେନ୍ତେ ଆଲମ୍‌ ଅଲେୟା ମେନ୍‌ଦ ‘ଆଇଙ୍ଗ୍‌ ଯିହୁଦୀକଆଃ ରାଜା ତାନିଙ୍ଗ୍‌’ ମେନ୍ତେ କାଜିକେଦ୍‌ତେୟାଃ ଅଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ପିଲାତୁସ୍‌ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ଅଲାକାଦ୍‌ତେୟାଃ ଅଲାକାଦାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ୟୀଶୁକେ କ୍ରୁଶ୍‌ରେ କିଲାକେଦ୍‌ତେ, ସିପାଇକ ଇନିୟାଃ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃ ଆଉକେଦ୍‌ତେ ଚାର୍‍ତାଃରେ ହାଟିଙ୍ଗ୍‌କେଦାଃକ, ମିଆଁଦ୍‌ ସିପାଇ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ହାଟିଙ୍ଗ୍‌ ଆଡଃ ପାଟେଲିଜାଃକେଅକ ଆଉକେଦାଃ, ଏନା କା ତୁନାକାନ୍‌ ତାଇକେନା ମେନ୍‌ଦ ଚେତାନ୍‌ଏତେ ଲାତାର୍‌ ଜାକେଦ୍‌ ତିଃଇଲଃ ରଅଃକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ଏନାମେନ୍ତେ ଇନ୍‌କୁ ଆକ ଆକରେକ କାଜିକେଦା, “ନେଆଁଁକେ କାବୁ ଚାଗାଡ଼େୟା ମେନ୍‌ଦ ନେଆଁଁ ଅକଏୟାଃ ହବାଅଆଃ ଏନାମେନ୍ତେ ଚିଠାବୁ ସାଲାୟା ।” ଧାରାମ୍‌ପୁଥିରେୟାଃ କାଜି ସାର୍‌ତିଅଃ ନାଗେନ୍ତେ ନେ ସବେନ୍‌ ହବାୟାନା, “ଇନ୍‌କୁ ଆଇଁୟାଃ ଲିଜାଃକ ହାଟିଙ୍ଗ୍‌ୟାନା ଆଡଃ ଆଇଁୟାଃ ପାଟେଲିଜାଃ ନାଙ୍ଗ୍‌ ଚିଠାକ ସାଲାକେଦା ।” ଏନାତେ ସିପାଇକ ନେ'ଲେକାକ ରିକାକେଦା । ");
INSERT INTO unx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ୟୀଶୁଆଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌ ଆଡଃ ଏଙ୍ଗାତେୟାଃ ମିଶିତେ, କ୍ଲୋପାରାଃ କୁଡ଼ିତେ ମାରିୟାମ୍‌ ଆଡଃ ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌ ୟୀଶୁଆଃ କ୍ରୁଶ୍‍ ଜାପାଃରେକ ତିଙ୍ଗୁଆକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ୟୀଶୁ ଆୟାଃ ଏଙ୍ଗାତେକେ ଆଡଃ ଆଇଃକ୍‌ ଦୁଲାଡ଼ିତାନ୍ ଚେଲାକେ, ଜାପାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ନେଲ୍‍କେଦ୍‍କିନାଏ, ଏଙ୍ଗାତେକେ କାଜିକିୟାଏ, “ନେଲିମେ ହନ୍‍ତାମାଃକେ ।” ");
INSERT INTO unx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ଏନ୍ତେ ୟୀଶୁ ଏନ୍‌ ଚେଲାକେ କାଜିକିୟାଏ, “ନେଲିମେ, ଇନିଃ ଆମାଃ ଏଙ୍ଗା” ଆଡଃ ଇମ୍‌ତାଙ୍ଗ୍‌ଏତେ ଏନ୍‍ ଚେଲା ଇନିଃକେ ଆୟାଃ ଅଡ଼ାଃତେ ଇଦିକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ସବେନାଃ ନାହାଁଃ ପୁରାଚାବାକାନା ମେନ୍ତେ ୟୀଶୁ ସାରିକେଦ୍‌ଚି, ଧାରାମ୍‌ପୁଥିରେୟାଃ କାଜି ପୁରାଅଃ ନାଗେନ୍ତେ ଇନିଃ କାଜିକେଦାଃଏ, “ଆଇଙ୍ଗ୍‌କେ ତେତାଙ୍ଗିଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ଏନ୍ତାଃରେ ମେହେର୍‌ ରାସିତେ ପେରେଜାକାନ୍‌ ମିଆଁଦ୍‌ ଚାଟୁ ଦହାକାନ୍‍ ତାଇକେନା । ଏନ୍ତେ ଇନ୍‌କୁ ସ୍ପଞ୍ଜ୍‌କେ ମେହେର୍‌ ରାସିରେ ତୁପୁକେଦାଃକ, ଆଡଃ ଏନାକେ ଏସୋବ୍‌ ଡାଙ୍ଗ୍‌ରେ ଗୁତୁକେଦ୍‍ତେ ଇନିୟାଃ ମଚା ହେପାଦ୍‍ତେ ନୁଁଏ ନାଗେନ୍ତେ ଏମ୍‍କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ଏନ୍ତେ ୟୀଶୁ ମେହେର୍‌ ରାସି ନୁଁକେଦ୍‌ତେ, କାଜିକେଦାଃଏ, “ନେଆଁଁ ପୁରାୟାନା” ଏନ୍ତେ ଆୟାଃ ବହଃ ତିରୁବ୍‍କେଦ୍‌ତେ ଜୀଉ ଟୁଣ୍ଡୁକେଦା । ");
INSERT INTO unx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ସାପ୍‍ଡ଼ାଅନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତାଇକେନା, ଆଡଃ ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ମାରାଙ୍ଗ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତାଇକେନ୍‌ ନାଗେନ୍ତେ ଯିହୁଦୀ ହାକିମ୍‌କ ଗଏଃ ହଡ଼୍‌ମକେ କ୍ରୁଶ୍‌ରେ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଜାକେଦ୍‌ ତାଇନଃକା ମେନ୍ତେ କାକ ସାନାଙ୍ଗ୍‌ ତାଇକେନା । ଏନାତେ ଇନ୍‌କୁ କିଲାକାନ୍‌କ ଜାଲ୍‌ଦି ଗଜଃକାକ ମେନ୍ତେ ଇନ୍‌କୁଆଃ କାଟା ଠଏଜଃକା ଆଡଃ ଇନ୍‌କୁକେ କ୍ରୁଶ୍‌ଏତେ ଆଡ଼୍‌ଗୁଃକାକ ମେନ୍ତେ ପିଲାତୁସ୍‍କେକ ବିନ୍ତିକିୟାଃ । ");
INSERT INTO unx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ଏନ୍ତେ ସିପାଇକ ହିଜୁଃକେଦ୍‌ତେ ୟୀଶୁଲଃ କିଲାକାନ୍‌ ବାରାନ୍‌କିନାଃ କାଟାକେ ଠଏଜ୍‌କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ମେନ୍‌ଦ ଇନ୍‌କୁ ୟୀଶୁତାଃ ହିଜୁଃୟାନ୍ତେ, ଇନିଃକେ ଗଜାକାନ୍‌କ ନେଲ୍‌କିୟାଃ, ଏନାତେ ଇନ୍‌କୁ ଇନିୟାଃ କାଟାକେ କାକ ଠଏଜ୍‌କେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ମେନ୍‌ଦ ସିପାଇକଏତେ ମିଆଁଦ୍‌ନିଃ ବାର୍ଛାତେ ଇନିୟାଃ କୁଡ଼ାମ୍‌ରେ ସବଃକିୟାଏ, ଆଡଃ ଇମ୍‌ତାଗି ମାୟୋମ୍‌ ଆଡଃ ଦାଆଃ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଆଡଃ ନେଆଁଁ ନେଲ୍‍କାଦ୍‍ନିଃ ଗାୱା ଏମାକାଦାଏ, ଜେ'ଲେକାଚି ଆପେୟଗି ବିଶ୍ୱାସେୟାପେ । ଆଡଃ ଇନିୟାଃ ଗାୱା ସାର୍‌ତିଗିୟା, ଆଡଃ ଇନିଃ ସାର୍‌ତି କାଜିତାନାଏ ଏନା ଆଇଃକ୍‌ଗି ସାରିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“ଇନିୟାଃ ଜେତାନ୍ ଜାଙ୍ଗ୍‌ କା ଠଏଜଆଃ” ନେ କାଜିଦ ଧାରାମ୍‌ପୁଥିରେ ପୁରାଅଃ ନାଗେନ୍ତେ ନେ ସବେନାଃ ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ଧାରାମ୍‌ପୁଥିରେ ଆଡଃମିଆଁଦ୍‌ କାଜି ଅଲାକାନା, “ଇନ୍‌କୁ ଅକଏକେ କିଲାକିୟାଃକ,” ହଡ଼କ ଇନିଃକେ ନେଲିୟାକ । ");
INSERT INTO unx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ଏନ୍‌ ତାୟମ୍‌ତେ ହାରାମାଥିୟା ସାହାର୍‌ରେନ୍ ଯୋଷେଫ୍‌, ୟୀଶୁଆଃ ହଡ଼୍‌ମ ଇଦି ନାଗେନ୍ତେ ପିଲାତୁସ୍‍କେ ବିନ୍ତିକିୟାଏ, ଇନିଃ ୟୀଶୁଆଃ ମିଆଁଦ୍‌ ଚେଲା ତାଇକେନାଏ, ମେନ୍‌ଦ ଯିହୁଦୀକଆଃ ବରତେ କାଏ ଉଦୁବେନ୍‍ୟାନା, ଆଡଃ ପିଲାତୁସ୍ ଆଚୁକେଦ୍‍ଚି ୟୀଶୁଆଃ ହଡ଼୍‌ମ ଇଦିକେଦ୍‌ତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ଏନ୍‌ ନିକଦୀମ୍‌ ସିଦାରେ ନିଦା ଇମ୍‌ତା ୟୀଶୁତାଃତେ ହିଜୁଃୟାନାଏ, ଇନିଃ ଯୋଷେଫ୍‌ଲଃ ହିଜୁଃୟାନାଏ । ଆଡଃ ଇନିଃ ତିରିଶ୍‌ କେଜି ବୁଗିନ୍‌ ସହାନ୍‌ସୁନୁମ୍ ଆଡଃ ମେସାକାନ୍ ଗାନ୍ଦ୍‌ରାସ୍‌ ଆଉକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ୟୀଶୁଆଃ ହଡ଼୍‌ମକେକିନ୍‌ ଆଉକେଦାଃ ଏନ୍ତେ ଯିହୁଦୀକଆଃ ତପାରେୟାଃ ରିତିଲେକାତେ ଏନାକେ ବୁଗିନ୍‌ ସହାନ୍‌ ସୁନୁମ୍‌ ଆଡଃ ଫାର୍‌ଚି ନିରାଲ୍‌ ଲିଜାଃରେ ପଟମ୍‌କେଦାଃକିନ୍ । ");
INSERT INTO unx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ଆଡଃ ୟୀଶୁ କ୍ରୁଶ୍‌ରେ କିଲାୟାନ୍‌ ଠାୟାଦ୍‌ତାଃରେ ମିଆଁଦ୍‌ ବାଗାନ୍‌ ତାଇକେନା, ଆଡଃ ବାଗାନ୍‌ରେ ମିଆଁଦ୍‌ ନାୱା ତପା ଠାୟାଦ୍ ତାଇକେନା, ଏନାରେ ଜେତାଏ ଚିଉଲାହ କାକ ତପାକାଦ୍‍କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ଯିହୁଦୀକଆଃ ସାପ୍‌ଡ଼ାଅନ୍‌ ହୁଲାଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଇନ୍‌କିନ୍‌ ୟୀଶୁକେ ଏନ୍ତାଃରେଗି ଦହକିୟାକିନ୍, ଚିୟାଃଚି ଏନ୍‌ ତପା ଠାୟାଦ୍‍ ନାଡ଼େଃରେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ହାପ୍ତାରେୟାଃ ପାହିଲା ହୁଲାଙ୍ଗ୍‌ ସେତାଃ ଇଦାନ୍ ନୁବାଃ ତାଇକେନ୍‌ ଇମ୍‌ତା ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌ ତପାଗାଡ଼ା ଠାୟାଦ୍‌ତେ ହିଜୁଃକେଦ୍‌ତେ ପୁରାଃ ମାରାଙ୍ଗ୍‌ ଦିରିକେ ତପାଗାଡ଼ା ଠାୟାଦ୍‌ଏତେ ଆତମ୍‌କାନ୍‌ ନେଲ୍‍କେଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ଏନ୍ତେ ଇନିଃ ନିର୍‍କେଦ୍‍ତେ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ଆଡଃ ୟୀଶୁ ଦୁଲାଡ଼ିତାନ୍‌ ଏନ୍‌ ଏଟାଃ ଚେଲାତାଃତେ ତେବାଃୟାନା ଆଡଃ ମେତାଦ୍‌କିନାଏ, “ଇନ୍‌କୁ ପ୍ରାଭୁକେ ତପାଗାଡ଼ାଏତେ ଇଦିକିୟାକ ଆଡଃ କତାଃରେକ ଦହକିୟା ଏନା କାଲେ ସାରିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଏନ୍‌ ଏଟାଃ ଚେଲା ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ତପାଠାୟାଦ୍‍ତେ ସେନଃୟାନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ଆଡଃ ଏନ୍‌ ବାରାନ୍‍କିନ୍ ମିଦ୍‍ତେକିନ୍ ନିର୍‍କେଦାଃ ମେନ୍‌ଦ ଏଟାଃ ଚେଲା ପାତ୍‌ରାସ୍‌କେ ନିର୍‌ବାଗିକେଦ୍‌ତେ ସିଦାରେ ତପାଠାୟାଦ୍‍ତେ ସେଟେର୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ଆଡଃ ଇନିଃ ଉଙ୍ଗୁଦ୍‌କେଦ୍‍ତେ ପାତ୍‌ଲା ଲିଜାଃ ଏସ୍‌କାର୍‌ ଦହକାନ୍‌ତେୟାଃ ନେଲ୍‌କେଦାଏ ମେନ୍‌ଦ କାଏ ବଲୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ଏନ୍ତେ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ଇନିୟାଃ ତାୟମ୍‌ତେ ସେଟେର୍‌ୟାନାଏ ଆଡଃ ତପାଠାୟାଦ୍‍ରେ ବଲକେଦ୍‌ତେ ଏନ୍‌ ପାତ୍‌ଲା ଲିଜାଃ ଉୟୁଗାକାନ୍‌ ନେଲ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ଆଡଃ ୟୀଶୁଆଃ ବହଃରେ ତଲ୍‌ବିହୁରାକାନ୍‌ ଲିଜାଃ ଏନ୍‌ ପାତ୍‌ଲା ଲିଜାଃଲଃ କା ତାଇନ୍‌କେନା ମେନ୍‌ଦ ଏଟାଃରେ ପୋଟମାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ଏନ୍ତେ ସିଦାରେ ତପାଠାୟାଦ୍‍ତାଃ ସେଟେର୍‌ୟାନ୍ ଏନ୍‌ ଏଟାଃ ଚେଲାହ ବଲୟାନାଏ, ଆଡଃ ଇନିଃ ନେଲ୍‍କେଦ୍‍ତେ ବିଶ୍ୱାସ୍‌କେଦାଃଏ । ");
INSERT INTO unx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ଇନିଃକେ ଗଏଃକାନ୍‍କଏତେ ଜୀଉବିରିଦଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ ନେ କାଜିକେ, ଇନ୍‌କୁ ଇମ୍‌ତାଜାକେଦ୍ କାକ ଆଟ୍‌କାର୍‌ଉରୁମେଁ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ଏନ୍ତେ ଏନ୍‌ ବାରାନ୍‌ ଚେଲାକିନ୍ ଆକିନାଃ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ୟାନାକିନ୍ । ");
INSERT INTO unx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ମେନ୍‌ଦ ମାରିୟାମ୍‌ ରାଆଃତାନ୍‍ଲଃ ତପାଠାୟାଦ୍‍ତାଃରେ ତିଙ୍ଗୁଆକାନାଏ ତାଇକେନା । ଚିମ୍‌ତାଙ୍ଗ୍‌ ରାଆଃତାନ୍‍ଲଃ ତପାଠାୟାଦ୍ ଭିତାର୍‌ତେ ଉଙ୍ଗୁଦ୍‌କେଦ୍‍ତେ ନେଲ୍‌କେଦାଃଏ, ");
INSERT INTO unx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ଇମ୍‌ତା ପୁଣ୍ଡି ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ଆଁକାନ୍‌ ବାରିଆ ଦୁଁତ୍‌କିନ୍ ୟୀଶୁଆଃ ହଡ଼୍‌ମ ଦହକାନ୍ ଠାୟାଦ୍‌ରେ ଦୁବାକାନ୍‌ ନେଲ୍‍କେଦ୍‍କିନାଏ, ମିଆଁଦ୍‌ନିଃ ବହଃସାଃରେ ଆଡଃ ମିଆଁଦ୍‌ନିଃ କାଟାସାଃରେ । ");
INSERT INTO unx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ଆଡଃ ଇନ୍‌କିନ୍‌ କୁଲିକିୟାଃକିନ୍‌, “ଏ ମାଈ, ଚିନାଃ ମେନ୍ତେମ୍ ରାଆଃ ତାନା ?” ଇନିଃ ଇନ୍‌କିନ୍‌କେ କାଜିୟାଦ୍‌କିନାଏ, “ଇନ୍‌କୁ ଆଇଁୟାଃ ପ୍ରାଭୁକେ ଇଦିକିୟାଃକ ଆଡଃ ଇନିଃକେ ଅକ୍‌ତାଃରେ ଦହକିୟାଃକ ଏନା କାଇଙ୍ଗ୍‌ ସାରିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ଏନ୍ତେ ନେଆଁଁ କାଜିକେଦ୍‌ଚି ଇନିଃ ଦୟାସାଃତେ ହେତାକେଦାଏ ଆଡଃ ୟୀଶୁକେ ତିଙ୍ଗୁଆକାନ୍‌ ନେଲ୍‍କିୟାଏ, ମେନ୍‌ଦ ଇନିଃ ୟୀଶୁ ତାନିଃ ମେନ୍ତେ କାଏ ସାରିକେଦାଃ । ");
INSERT INTO unx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଏ ମାଈ, ଆମ୍‌ ଚିନାଃ ମେନ୍ତେ ରାଆଃତାନାମ୍‌ ? ଆଡଃ ଅକଏକେ ଦାଣାଁବାଡ଼ା ତାନାମ୍‌ ?” ଏନ୍‌ କୁଡ଼ି ୟୀଶୁକେ ବାଖ୍‌ଡ଼ିରେନ୍ ମାଳିହଡ଼ ତାନିଃ ମେନ୍ତେ ଆଟ୍‌କାର୍‌କେଦ୍‍ତେ, କାଜିକିୟାଏ, “ହେ ଗମ୍‌କେ, ଆମ୍‌ ଇନିଃକେ ଇଦିକାଇରେଦ ଇନିଃକେ ଅକ୍‌ତାଃରେମ୍ ଦହକିୟା ଏନା ଉଦୁବାଇଙ୍ଗ୍‌ମେଁ ଆଡଃ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ଇଦିକିୟାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଏ ମାରିୟାମ୍‌,” ଇନିଃ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ ଏବ୍ରୀ ଜାଗାର୍‌ତେ କାଜିକିୟାଏ, “ରାବ୍‍ବୁନି” ନେୟାଁରାଃ ମୁଣ୍ଡି “ହେ ଗୁରୁ” । ");
INSERT INTO unx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ୟୀଶୁ ଇନିଃକେ କାଜିକିୟାଏ, “ଆଇଙ୍ଗ୍‌କେ ଆଲମ୍‌ ସାବାକାଇଙ୍ଗ୍‌, ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ଦ ନାହାଁଃ ଜାକେଦ୍‌ ଆପୁଇଙ୍ଗ୍‌ତାଃତେ ଆଉରି ସେନ୍‌ରୁହାଡ଼ାଇଙ୍ଗ୍‌ । ମେନ୍‌ଦ ହାଗାଇଙ୍ଗ୍‌ତେକତାଃ ସେନ୍‌କେଦ୍‌ତେ କାଜିୟାକମ୍, ‘ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଆପୁ ଆଡଃ ଇନ୍‌କୁଆଃ ଆପୁ, ଆଇଁୟାଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଡଃ ଇନ୍‌କୁଆଃ ପାର୍‌ମେଶ୍ୱାର୍‍ ତାଃତେଇଙ୍ଗ୍‌ ସେନ୍‌ରୁହାଡ଼୍‌ତାନା ।’” ");
INSERT INTO unx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ଆଡଃ ମାଗ୍‌ଦାଲିନି ମାରିୟାମ୍‌ ସେନ୍‌କେଦ୍‌ତେ ଚେଲାକକେ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ପ୍ରାଭୁକେ ନେଲାକାଇୟାଇଙ୍ଗ୍‌, ଆଡଃ ଇନିଃ ନେ କାଜିକ ଆଇଙ୍ଗ୍‌କେ କାଜିକାଦିୟାଁଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ହାପ୍ତାରେୟାଃ ପାହିଲା ହୁଲାଙ୍ଗ୍‌ ଆୟୁବଃତାନ୍ ଇମ୍‌ତା ଯିହୁଦୀକଆଃ ବରତେ ଚେଲାକ ହୁଣ୍ଡିୟାନାକ ଆଡଃ ମିଆଁଦ୍‌ ଅଡ଼ାଃରେ ଦୁଆର୍‌ ହାଣ୍ଡେଦ୍‌କେଦ୍‌ତେ ତାଇକେନାକ, ଇମ୍‌ତା ୟୀଶୁ ହିଜୁଃକେଦ୍‌ତେ ଆକଆଃ ଥାଲାରେ ତିଙ୍ଗୁୟାନାଏ ଆଡଃ ମେତାଦ୍‌କଆଏ, “ଆପେରେ ଜୀଉସୁକୁ ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଇନିଃ ନେଆଁଁ କାଜିକେଦ୍‌ଚି ଇନ୍‌କୁକେ ଆୟାଃ ତିଃଇକେ ଆଡଃ ଆୟାଃ ସାଡ଼େଜାଙ୍ଗ୍‌କେ ଉଦୁବାଦ୍‌କଆଏ । ଏନ୍ତେ ଚେଲାକ ପ୍ରାଭୁକେ ନେଲ୍‌କେଦ୍‌ତେ ପୁରାଃଗି ରାସ୍‌କାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ୟୀଶୁ ଆଡଃଗି କାଜିୟାଦ୍‌କଆଏ, “ଆପେରେ ଜୀଉସୁକୁ ତାଇନ୍‌କା, ଆପୁଇଙ୍ଗ୍‌ କୁଲାକାଇଙ୍ଗ୍‌ ଲେକା ଆଇଙ୍ଗ୍‌ହଁ ଆପେକେ କୁଲ୍‌ପେତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ଇନିଃ ନେଆଁଁ କାଜିକେଦ୍‌ଚି ଇନ୍‌କୁଆଃ ଚେତାନ୍‌ରେ ଅମ୍‍କେଦାଃଏ, ଆଡଃ “ନେ ପାବିତାର୍‌ ଆତ୍ମାକେ ତେଲାଇପେ ମେତାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ଆପେ ହଡ଼କଆଃ ପାପ୍‌ ଛାମାକରେଦ ଇନ୍‌କୁଆଃ ପାପ୍‌ ଛାମାୱାଃ, ଆପେ କାପେ ଛାମାକରେଦ ଇନ୍‌କୁଆଃ ପାପ୍‌ କା ଛାମାୱାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ଦିଦୁମ୍‌ କାଜିୟଃତାନ୍ ଥୋମା ଗେଲ୍‌ବାର୍‌ ଚେଲାକଏତେ ମିହୁଡ଼୍‌ ତାଇକେନାଏ । ଇନିଃ ୟୀଶୁ ହିଜୁଃଲେନ୍ ଇମ୍‌ତା ଚେଲାକଲଃ କାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ଏନ୍ତେ ଏଟାଃ ଚେଲାକ ଇନିଃକେ କାଜିକିୟାଃକ, “ଆଲେ ପ୍ରାଭୁକେ, ନେଲାକାଇୟାଃଲେ ।” ମେନ୍‌ଦ ଇନିଃ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ଇନିୟାଃ ତିଃଇରେ କିଲାରେୟାଃ ଚିହ୍ନାଁ କାଇଙ୍ଗ୍‌ ନେନେଲ୍‌ ଜାକେଦ୍‌ ଆଡଃ ଆଇଁୟାଃ ସାର୍‌ସାର୍‌ତେ କିଲାରେୟାଃ ଚିହ୍ନାଁକେ କାଇଙ୍ଗ୍‌ ଜୁଟିଦେ ଜାକେଦ୍‌ ଆଡଃ ତିଃଇତେ ଇନିୟାଃ ସାଡ଼େଜାଙ୍ଗ୍‌ରେ କାଇଙ୍ଗ୍‌ ଜୁଟିଦେ ଜାକେଦ୍‌ କାଇଙ୍ଗ୍‌ ବିଶ୍ୱାସେୟା ।” ");
INSERT INTO unx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ମିଦ୍‌ ହାପ୍ତା ତାୟମ୍‌ତେ ଇନିୟାଃ ଚେଲାକ ଆଡଃଗି ଅଡ଼ାଃରେକ ତାଇକେନା ଆଡଃ ଥୋମା ଇନ୍‍କୁଲଃ ତାଇକେନାଏ, ଦୁଆର୍‌ ହାଣ୍ଡେଦାକାନ୍‍ ତାଇକେନ୍‍ରେୟ ୟୀଶୁ ହିଜୁଃୟାନାଏ ଆଡଃ ଥାଲାରେ ତିଙ୍ଗୁକେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, “ଆପେରେ ଜୀଉସୁକୁ ତାଇନ୍‌କା ।” ");
INSERT INTO unx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ଏନ୍ତେ ଇନିଃ ଥୋମାକେ କାଜିକିୟାଏ, “ଆମାଃ ସାର୍‌ସାର୍‌ଲଃ ଜୁଟିଦେମେଁ ଆଡଃ ଆଇଁୟାଃ ତିଃଇ ନେଲେମେ, ଆଡଃ ତିଃଇତାମାଃ ଜିଲିଙ୍ଗ୍‌ୟେଁମେ ଆଡଃ ସାଡ଼େଜାଙ୍ଗ୍‌ତାଃରେ ଜୁଟିଜେମେଁ, କା ବିଶ୍ୱାସେନିଃଦ କାହା ମେନ୍‌ଦ ବିଶ୍ୱାସେନିଃ ହବାଅଃମେଁ ।” ");
INSERT INTO unx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ଥୋମା କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଁୟାଃ ପ୍ରାଭୁ ଆଡଃ ଆଇଁୟାଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ୟୀଶୁ କାଜିକିୟାଏ, “ଏ ଥୋମା, ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ନେଲ୍‌କେଦ୍‍ତେମ୍ ବିଶ୍ୱାସୀଙ୍ଗ୍‌ତାନା, ମେନ୍‌ଦ କା ନେଲ୍‌କେଦ୍‌ତେ ବିଶ୍ୱାସ୍‌ତାନ୍‌କ ସୁକୁତାନ୍‍ଗିୟାଃ ।” ");
INSERT INTO unx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ୟୀଶୁ ଚେଲାକଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ନେ'ଲେକା ପୁରାଃ ଏଟାଃ ପେଡ଼େୟାନ୍‌ କାମିକ କାମିକେଦାଃଏ । ଏନା ସବେନ୍‌ ନେ ପୁଥିରେ କା ଅଲାକାନା । ");
INSERT INTO unx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ମେନ୍‌ଦ ୟୀଶୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ମାସି ତାନିଃ, ନେୟାଁପେ ବିଶ୍ୱାସେକା ଆଡଃ ନେଆଁଁ ବିଶ୍ୱାସ୍‌କେଦ୍‍ତେ ଇନିୟାଃ ନୁତୁମ୍‌ତେ ଆପେ ଜୀଦାନ୍‌ପେ ନାମେକା ମେନ୍ତେ ନେଆଁଁରେ ଅଲାକାନା । ");
INSERT INTO unx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ଏନ୍‌ ତାୟମ୍‌ତେ ୟୀଶୁ ଆଡଃମିସା ତିବିରିୟା ଦରେୟା ଗେନାରେ ଆୟାଃ ଚେଲାକତାଃରେ ଉଦୁବେନ୍‌ୟାନାଏ । ନେୟାଁ ନେ ଲେକା ହବାଲେନା : ");
INSERT INTO unx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଦିଦୁମ୍ କାଜିୟଃତାନ୍ ଥୋମା ଆଡଃ ଗାଲିଲ୍‌ରେୟାଃ କାନା ହାତୁରେନ୍‌ ନିଥ୍‌ନିୟେଲ୍‌ ଆଡଃ ଜେବଦୀୟାଃ ବାରାନ୍ ହନ୍‌କିନ୍‌ ଆଡଃ ଇନିୟାଃ ଚେଲାକଏତେ ଆଡଃ ବାର୍‌ହଡ଼୍‌ ମିଦ୍‍ତାଃରେକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ଆଡଃ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆଏ, “ଆଇଙ୍ଗ୍‌ ହାକୁ ସାବ୍‌ନାଙ୍ଗ୍‌ ସେନଃତାନାଇଙ୍ଗ୍‌ ।” ଇନ୍‌କୁ ଇନିଃକେ କାଜିକିୟାଃକ, “ଆଲେୟ ଆମାଃଲଃ ସେନାଲେ,” ଇନ୍‌କୁ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ତେ ଲାଉକାରେକ ଦେଏଃୟାନା, ମେନ୍‌ଦ ଏନ୍‌ ନିଦାରେ ଜାଲୋମ୍‌ତେ ହାକୁ କାକ ସାବ୍‍ ଦାଡ଼ିୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ଆଡଃ ଆଙ୍ଗ୍‌ୟାନ୍‍ଚି ୟୀଶୁ ଦରେୟା ଗେନାରେ ତିଙ୍ଗୁୟାନାଏ, ହଲେହଁ ଚେଲାକ ନିଃ ୟୀଶୁ ତାନିଃ ମେନ୍ତେ କାକ ସାରିତାନ୍ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଏନ୍ତେ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ହେ ଦୁଲାଡ଼୍‌ ହନ୍‌କ ଚିୟାଃ ଆପେତାଃରେ ହାକୁ ମେନାକଆ ?” ଇନ୍‌କୁ “କାହା” ମେନ୍ତେ କାଜିରୁହାଡ଼୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆ, “ଲାଉକାରାଃ ଜମ୍‌ସାଃତେ ଜାଲୋମ୍‍କେ ହୁଦ୍‌ମାଏପେ, ଏନାରେ ଆପେ ହାକୁ ନାମ୍‍କଆପେ ।” ଏନ୍ତେ ଇନ୍‌କୁ ଜାଲୋମ୍‌କେ ହୁଦ୍‌ମାକେଦ୍‌ତେ ପୁରାଃ ହାକୁକ ନାମ୍‌କେଦ୍‌କଆ, ମେନ୍‌ଦ ପୁରାଃ ପେଡ଼େଃତେ ଥାଇଜ୍‌କେଦ୍‌ରେୟ କାକ ଥାଇଜ୍‌ ଦାଡ଼ିୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ଏନ୍ତେ ୟୀଶୁ ଅକନ୍‌ ଚେଲାକେ ଦୁଲାଡ଼ିତାନ୍‍ ତାଇକେନାଏ, ଇନିଃ ପାତ୍‌ରାସ୍‌କେ କାଜିକିୟାଏ, “ନିଃଦ ପ୍ରାଭୁ ତାନିଃ ।” ନିଃଦ ପ୍ରାଭୁ ତାନିଃ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌, ସାମା ହଡ଼୍‌ମ ତାଇକେନ୍‌ହରାତେ ମାୟାଙ୍ଗ୍‌ରେ ଲିଜାଃ ପାଟେୟାନ୍‌ଚି ଦରେୟାରେ ଡେଗାଅକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ମେନ୍‌ଦ ଏଟାଃ ଚେଲାକ ହାକୁତେ ପେରେଜାକାନ୍‍ ଜାଲୋମ୍‌ ଥାଇଜ୍‌କେଦ୍‌ତେ ହୁଡିଙ୍ଗ୍‌ ଲାଉକାତେକ ହିଜୁଃୟାନା, ଚିୟାଃଚି ଇନ୍‍କୁଦ ଦରେୟା ଗେନାଏତେ ପୁରାଃ ସାଙ୍ଗିନ୍‍ରେଦ କାହା, ମେନ୍‌ଦ ଦୁଇଶହାତ୍‌ ଲେକା ସାଙ୍ଗିନ୍‍ରେ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ଆଡଃ ଇନ୍‌କୁ ଦରେୟା ଖାଇଁଣ୍‌ରେ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ ଆଙ୍ଗରାସେଙ୍ଗେଲ୍‍ରେ ହାକୁ ରାପାଃକାନ୍‍ ଆଡଃ ହଲଙ୍ଗ୍‌ ମାଣ୍ଡାୱାକାନ୍‌ ନେଲ୍‍କେଦାଃକ । ");
INSERT INTO unx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁକେ କାଜିୟାଦ୍‌କଆଏ, “ନାହାଁଃ ଆପେ ସାବାକାଦ୍‍ ହାକୁକଏତେ କାଟିଃଲେକା ଆଉକୁପେ ।” ");
INSERT INTO unx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ସେନଃୟାନ୍ତେ ୧୫୩ ଠୁ ମାପ୍‌ରାଙ୍ଗ୍‌ ହାକୁତେ ପେରେଜାକାନ୍‌ ଜାଲୋମ୍‍କେ ଦରେୟା ଖାଇଁଣ୍‌ତେ ଥାଇଜ୍‌ ଆଉକେଦାଃଏ । ନିମିନ୍‌ ହାକୁକ ତାଇକେନ୍‌ରେୟ ଜାଲୋମ୍‌ କା ଟଟାଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ୟୀଶୁ କାଜିୟାଦ୍‌କଆଏ, “ହିଜୁଃପେ ଆଡଃ ଜମେପେ ।” ମେନ୍‌ଦ “ଆମ୍‌ ଅକଏ ତାନ୍‌ମେ ?” ମେନ୍ତେ ଇନିଃକେ କୁଲି ନାଗେନ୍ତେ ଚେଲାକଏତେ, ଜେତାଏ କାକ ପେଡ଼େଃକେଦାଃ, ଚିୟାଃଚି ଇନ୍‍କୁଦ ନିଃ ପ୍ରାଭୁ ତାନିଃ ମେନ୍ତେ ସାରିତାନ୍‍ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଏନ୍ତେ ୟୀଶୁ ହିଜୁଃୟାନାଏ ଆଡଃ ହଲଙ୍ଗ୍‌ ଆଉକେଦ୍‌ତେ ଇନ୍‌କୁକେ ଏମାଦ୍‍କଆଏ, ଆଡଃ ଏନ୍‌ ଲେକା ହାକୁ ହଗି ଏମାଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ନେୟାଁଲଃ ଆପିସା, ୟୀଶୁ ଗଏଃକାନ୍‍କଏତେ ଜୀଉବିରିଦ୍‌କେଦ୍‌ତେ ଆୟାଃ ଚେଲାକତାଃରେ ଉଦୁବ୍‍ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ଏନ୍ତେ ଇନ୍‌କୁ ଜମ୍‍କେଦ୍‍ ତାୟମ୍‌ତେ ୟୀଶୁ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌କେ କୁଲିକିୟାଏ, “ଏ ଯୋହାନ୍‌ଆଃ ହନ୍‌ ଶିମୋନ୍‌, ଚିୟାଃ ଆମ୍‌ ନିକୁଏତେ ଆଦ୍‍କାମ୍‍ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ତାନା ?” ଇନିଃ କାଜିକିୟାଏ, “ହେଗି ପ୍ରାଭୁ ଆଇଙ୍ଗ୍‌ ଦୁଲାଡ଼୍‌ମେଁ ତାନାଇଙ୍ଗ୍‌, ଏନା ଆମ୍‌ ସାରିତାନାମ୍‍,” ୟୀଶୁ ଇନିଃକେ ମେତାଇୟାଏ, “ଆଇଁୟାଃ ମିଣ୍ଡି ହନ୍‌କକେ ଗୁପିକମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ୟୀଶୁ ବାର୍‌ସାତେ ଇନିଃକେ କୁଲିକିୟାଏ, “ଏ ଯୋହାନ୍‌ଆଃ ହନ୍‌ ଶିମୋନ୍‌, ଚିୟାଃ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ତାନାମ୍ ?” ଇନିଃ କାଜିକିୟାଏ, “ହେଗି ପ୍ରାଭୁ ଆଇଙ୍ଗ୍‌ ଦୁଲାଡ଼୍‌ମେଁ ତାନାଇଙ୍ଗ୍‌, ଏନା ଆମ୍‌ ସାରିତାନାମ୍ ।” ୟୀଶୁ ମେତାଇୟାଏ, “ଆଇଁୟାଃ ମିଣ୍ଡିକକେ ଗୁପିକମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ୟୀଶୁ ଆପିସାତେ ଇନିଃକେ କୁଲିକିୟାଏ, “ଏ ଯୋହାନ୍‌ଆଃ ହନ୍‌ ଶିମୋନ୍‌, ଚିୟାଃ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ତାନାମ୍‌ ?” ୟୀଶୁ ଆପିସାତେ ଚିୟାଃ ଆମ୍‌ ଦୁଲାଡ଼ିଙ୍ଗ୍‌ତାନାମ୍‌ ? ମେନ୍ତେ କୁଲିକିୟାଏ, ନେଆଁଁତେ ପାତ୍‌ରାସ୍‌ ହୁଡିଙ୍ଗ୍‌ଜୀଉୟାନାଏ । ଏନାତେ ପାତ୍‌ରାସ୍‌ ମେତାଇୟାଏ, “ହେ ପ୍ରାଭୁ ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେଗି ଦୁଲାଡ଼୍‌ମେଁ ତାନାଇଙ୍ଗ୍‌ ଏନା ସବେନାଃ ଆମ୍‌ ସାରିତାନାମ୍‌ ।” ୟୀଶୁ କାଜିକିୟାଏ, “ମିଣ୍ଡି ତାଇୟାଃଁକକେ ଗୁପିକମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ଆଇଙ୍ଗ୍‌ ସାର୍‌ତିଗି କାଜିୟାମେ ତାନାଇଙ୍ଗ୍‌, “ଆମ୍‌ ସେପେଡ଼େଦ୍ ତାଇକେନ୍‌ରେ ଆମ୍‌ ସେକାଡ଼୍‌କେଦ୍‍ତେ ଆମାଃ ସାନାଙ୍ଗ୍‌ଲେକା ଜାହାତାଃଗି ସେନଃତାନ୍‌ ତାଇକେନାମ୍ ମେନ୍‌ଦ ହାଡ଼ାମ୍‍ ଇମ୍‌ତା ଆମାଃ ତିଃଇ ଜିଲିଙ୍ଗ୍‌ୟେଁଆମ୍‌ ଆଡଃ ଏଟାଃନିଃ ଆମାଃ ମାୟାଙ୍ଗ୍‌ ତଲେୟାଏ ଆଡଃ ଆମ୍‌ କାମ୍‍ ସାନାଙ୍ଗ୍‌ତାଃତେ ଇଦିମେୟାଁଏ ।” ");
INSERT INTO unx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ପାତ୍‌ରାସ୍‌ ଚିଲ୍‍କା ଆୟାଃ ଗନଏଃ ହରାତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାନାରାଙ୍ଗ୍‌ ରିକାଇୟାଏ, ଏନାରେୟାଃ ଇସାରା ଏମ୍‌କେଦ୍‌ତେ ୟୀଶୁ ଏନା କାଜିକେଦାଏ । ଏନ୍ତେ ଇନିଃ “ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ” ମେନ୍ତେ ପାତ୍‌ରାସ୍‌କେ କାଜିକିୟା । ");
INSERT INTO unx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ପାତ୍‌ରାସ୍‌ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ, ଏଟାଃ ଚେଲାକେ ଦୟାହରା ହିଜୁଃତାନ୍‌ ନେଲ୍‌କିୟାଏ, ଅକଏକେଚି ୟୀଶୁ ଦୁଲାଡ଼ିତାନ୍ ତାଇକେନାଏ, ଇନିଃ ଆୟୁବ୍‌ ଜମେୟାଁଃରେ ୟୀଶୁଆଃ କୁଡ଼ାମ୍‌ରେ ଟେଣ୍ଡେର୍‌କେଦ୍‌ତେ କୁଲିକାଇତାଇନାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌କେ ବାଇରିକଆଃ ତିଃଇରେ ସାବ୍‌ରିକାନିଃ ଅକଏ ତାନିଃ ?” ");
INSERT INTO unx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପାତ୍‌ରାସ୍‌ ଇନିଃକେ ନେଲ୍‍କେଦ୍‍ତେ ୟୀଶୁକେ କୁଲିକିୟାଏ, “ହେ ପ୍ରାଭୁ, ନିୟାଃ ବିଷାଏରେ ଚିନାଃ ମେନେତାନାମ୍ ?” ");
INSERT INTO unx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ୟୀଶୁ ଇନିଃକେ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଁୟାଃ ହିଜୁଃ ଜାକେଦ୍‌ ଇନିଃ ତାଇନ୍‍କାଏ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନ୍‌ରେଦ ଆମାଃ ଚିନାଃ ସେନଃତାନା ? ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ଇଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ଏନାତେ ନେ ଚେଲା କାଏ ଗଜଃଆ ମେନ୍ତେ ହାଗାକତାଃରେ କାଜି ନିତିର୍‌ୟାନା, ମେନ୍‌ଦ ଇନିଃ କାଏ ଗଜଃଆ ମେନ୍ତେ ୟୀଶୁ କାଏ କାଜିକାଦ୍‌ତାଇନା, ଇନିଃ ଆଇଙ୍ଗ୍‌ ହିଜୁଃ ଜାକେଦ୍‌ ତାଇନଃକାଏ ନେଆଁଁ ଆଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ରେଦ ଆମାଃ ଚିନାଃ ଚିକାଅଃଆ ? ମେନ୍ତେ କାଜିକାଦ୍‌ତାଇନାଏ । ");
INSERT INTO unx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ନେ କାଜିକରାଃ ଗାୱା ଏମେତାନ୍‌ ଆଡଃ ନେ କାଜିକ ଅଲାକାଦ୍‌ ଚେଲା ନିଃଗି ତାନିଃ ଆଡଃ ନିୟାଃ କାଜିତେୟାଃ ସାର୍‌ତିଗିୟାଃ ନେୟାଁବୁ ସାରିତାନା । ");
INSERT INTO unx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ୟୀଶୁ କାମିକାଦ୍‍ କାଜିକାମିକ ପୁରାଃଗିୟା, ଏନା ମିମିଆଦ୍‌ତେ ଅଲେରେଦ ଅକଏସାରି ଏନ୍‍ ଅନଲ୍‌ ପୁଥିକ ଅତେଦିଶୁମ୍‌ରେ ଦହ ନାଗେନ୍ତେ ଠାୟାଦ୍‌ କା ହବାଅଃତେୟାଃ ନେଆଁଁ ଆଇଙ୍ଗ୍‌ ଆଟ୍‌କାରେତାନା ।");
INSERT INTO unx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ହେ ଦୁଲାଡ଼୍‌ ଥିୟଫିଲସ୍‌, ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ପାହିଲା ଚିଟାଉ ଲୁକ୍‌ ପୁଥିରେ ୟୀଶୁ କାମିକାଦ୍‌ ଆଡଃ ଇତୁକାଦ୍‌ ସବେନାଃ ଆୟାଃ କାମିରାଃ ଏନେଟେଦ୍‌ତାଃଏତେ ");
INSERT INTO unx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ସିର୍ମାଦିଶୁମ୍‌ତେ ଇଦିୟଃ ହୁଲାଙ୍ଗ୍‌ ଜାକେଦ୍‌ ହବାକାନ୍‌ତେୟାଃ ଅଲାକାଦାଇଙ୍ଗ୍‌ । ସିର୍ମାଦିଶୁମ୍‌ତେ ଇଦିୟଃ ସିଦାରେ ୟୀଶୁ ଆୟାଃ ସାଲାକାନ୍‌ ପ୍ରେରିତ୍‌କକେ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ପେଡ଼େଃତେ ଇତୁକାଦ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ୟୀଶୁ ଆୟାଃ ଗନଏଃ ତାୟମ୍‌ତେ ପୁରାଃ ସାବୁତ୍‌ରାଃ କାଜି ଏମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁତାଃରେ ଆଇଃକ୍‌ଗି ଜୀନିଦ୍‌ ମେନ୍ତେ ଉଦୁବ୍‌ୟାନା, ଆଡଃ ବାର୍‌ହିସି ମାହାଁ ଇନ୍‍କୁତାଃରେ ମିସା ମିସା ଉଦୁବ୍‌ୟାନ୍‌ଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେୟାଃ କାଜିକଏ ଉଦୁବାଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ଆଡଃ ୟୀଶୁ ଇନ୍‌କୁଲଃ ଜମ୍‌ତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଇନ୍‌କୁକେ ନେଆଁଁ ଆଚୁକାଦ୍‌କ ତାଇକେନାଏ, ଆପେ ଯୀରୁଶାଲେମ୍‌ ଆଲ୍‌ପେ ବାଗିୟା, ମେନ୍‌ଦ ଆପୁଇଁୟାଃ ବାନାର୍‌ସା କାଜି ଆୟୁମାକାଦ୍‌ତେୟାଃକେ ନେଲ୍‌ହରାଏପେ । ");
INSERT INTO unx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ଚିୟାଃଚି ଯୋହାନ୍‌ଦ ଦାଆଃତେ ବାପ୍ତିସ୍ମା ଏମାଦ୍‌କଆଏ, ମେନ୍‌ଦ ଆପେ ହୁଡିଙ୍ଗ୍‌ ମାହାଁ ତାୟମ୍‌ତେ ପାବିତାର୍‌ ଆତ୍ମାତେ ବାପ୍ତିସ୍ମାୱାଃପେ । ");
INSERT INTO unx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ମୁସିଙ୍ଗ୍‌ ହୁଲାଙ୍ଗ୍‌ ପ୍ରେରିତ୍‌କ ହୁଣ୍ଡିକେଦ୍‌ତେ ୟୀଶୁକେ କୁଲିକିୟାକ, “ହେ ପ୍ରାଭୁ, ଚିୟାଃ ଆମ୍‌ ନେ ଦିପିଲିରେଗି ଇସ୍ରାଏଲ୍‌କତାଃରେ ଆଡଃଗି ରାଇଜ୍‌ ଏମେତାନାମ୍‌ ?” ");
INSERT INTO unx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ୟୀଶୁ ଇନ୍‌କୁକେ ମେତାଦ୍‌କଆ, “ଆପୁ ଆୟାଃ ଆପ୍‌ନାଃ ପେଡ଼େଃତେ ଦହାକାଦ୍‌ ନେଡା ଚାଏ ଦିପିଲିକେ ସାରି ନାଗେନ୍ତେ ଆପେୟାଃ ନାଙ୍ଗ୍‌ ନାହାଁଲାଃ । ");
INSERT INTO unx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ମେନ୍‌ଦ ପାବିତାର୍‌ ଆତ୍ମା ଆପେତାଃ ହିଜୁଃରେ, ଆପେ ପେଡ଼େଃପେ ନାମେୟା ଆଡଃ ଯୀରୁଶାଲେମ୍‌ରେ, ଗଟା ଯିହୁଦା, ଶମିରୋନ୍‌ ଆଡଃ ଅତେରାଃ ଟୁଣ୍ଡୁ ଜାକେଦ୍‌ ଆଇଁୟାଃ ଗାୱାପେ ହବାଅଆଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ଇନିଃ ନେଆଁଁ କାଜିକେଦ୍‌ଚି, ଇନ୍‌କୁ ଇନିଃକେ ନେଲିତାନ୍‍ଲଃ ଇନିଃ ସିର୍ମାତେ ଇଦିୟାନା, ଆଡଃ ମିଆଁଦ୍‌ ରିମିଲ୍‌ ଇନିଃକେ ଇନ୍‍କୁତାଃଏତେ ଦାନାଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ୟୀଶୁ ସିର୍ମାତେ ଇଦିୟଃତାନ୍‌ ତାଇକେନ୍‌ରେ ଇନ୍‌କୁ ସିର୍ମାସାଃ ସାଙ୍ଗିଲାକାଦ୍ ତାଇକେନ୍‌ ଇମ୍‌ତା, ବାର୍‌ହଡ଼୍‌ ଇମ୍‌ତାଗି ପୁଣ୍ଡି ଲିଜାଃ ତୁସିଙ୍ଗ୍‌କେଦ୍‌ତେ ଇନ୍‍କୁତାଃରେକିନ୍ ତିଙ୍ଗୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ଆଡଃ କାଜିକେଦାକିନ୍‌, “ଏ ଗାଲିଲ୍‌ରେନ୍ ହଡ଼କ, ଚିନାଃମେନ୍ତେ ସିର୍ମାସାଃ ସାଙ୍ଗିଲ୍‌କେଦ୍‌ତେ ତିଙ୍ଗୁଆକାନାପେ ? ନେ ୟୀଶୁଗି ଆପେତାଃଏତେ ସିର୍ମାତେ ଇଦିୟାକାନା । ମେନ୍‌ଦ ଆପେ ଇନିଃକେ ସିର୍ମାତେ ସେନଃତାନ୍‌ ନେଲ୍‌କିଃ ଲେକାଗି ହିଜୁଃରୁହାଡ଼ାଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ଏନ୍ତେ ପ୍ରେରିତ୍‌କ ଜାଇତୁନ୍‌ ନୁତୁମ ବୁରୁଏତେ ଯୀରୁଶାଲେମ୍‌ତେକ ସେନଃରୁହାଡ଼୍‌ୟାନା, ଏନା ନାଗାର୍‌ତାଃଏତେ ମିଦ୍‌ କିଲୋମିଟର୍‌ ଲେକା ସାଙ୍ଗିନ୍‌ରେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ଇନ୍‌କୁ ଯୀରୁଶାଲେମ୍‌ ନାଗାର୍‌ତେ ବଲୟାନାକ ଆଡଃ ଆକ ତାଇନଃ ତାଇକେନ୍‌ ଚେତାନ୍‌ କୁଠାତେ ସେନଃୟାନାକ । ଏନ୍‌ ପ୍ରେରିତ୍‌କଆଃ ନୁତୁମ୍‌ ପାତ୍‌ରାସ୍‌, ଯୋହାନ୍‌, ଯାକୁବ୍‌, ଆନ୍ଦ୍ରିୟ, ଫିଲିପ୍‌, ଥୋମା, ବାର୍ଥୋଲମି, ମାଥିଉ, ଆଲ୍‌ଫିୟନାଃ ହନ୍‌ ଯାକୁବ୍‌, ଚିହୁଲ୍‌ନିଃ ଶିମୋନ୍‌ ଆଡଃ ଯାକୁବ୍‌ଆଃ ହନ୍‌ ଯିହୁଦା ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ଇନ୍‌କୁ ସବେନ୍‌କ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିକେଦ୍‌ତେ ବିନ୍ତିତାନ୍‌କ ତାଇକେନା ଆଡଃ ଇନ୍‌କୁଲଃ କୁଡ଼ିକ, ୟୀଶୁଆଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌ ଆଡଃ ଆୟାଃ ହାଗାକ ହୁଣ୍ଡିୟଃତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ଚିମିନ୍‌ ମାହାଁଁ ତାୟମ୍‌ତେ ଲାଗ୍‌ଭାଗ୍‌ ତୁରିୟାହିସି ବିଶ୍ୱାସୀ ହାଗାକଆଃ ସାମିଲାନ୍‌ ଥାଲାରେ ପାତ୍‌ରାସ୍‌ ତିଙ୍ଗୁକେଦ୍‌ତେ କାଜିକେଦା, ");
INSERT INTO unx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ହେ ଦୁଲାଡ଼୍‌ ହାଗା ମିଶିକ, ଅକନ୍‌ ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା ୟୀଶୁକେ ସାବ୍‌ରିକାଇ ନାଗେନ୍ତେ ବାଇରିକକେ ଆୟାର୍‌ଆଉକାକ ତାଇକେନା, ଇନିୟାଃ ବିଷାଏରେ ଦାଉଦ୍‌ ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଃକେଦ୍‌ତେ କାଜିକାଦ୍‌ତେୟାଃ, ଧାରାମ୍‌ପୁଥିରେୟାଃ କାଜି ପୁରାଅଃ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ଚିଆଃଚି ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦା ଆବୁଆଃ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ମିହୁଡ଼୍‌ ତାଇକେନାଏ ଆଡଃ ଆବୁଆଃ ସେୱାକାମି ନାଗେନ୍ତେ ଇନିଃ ସାଲାକାନ୍‌ ତାଇକେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦାରାଃ ଏତ୍‌କାନ୍‌ କାମିରାଃ ନାଲାତେ ମିଆଁଦ୍‌ ପିଡ଼ି କିରିଙ୍ଗ୍‌ୟାଁକାନ୍‌ ତାଇକେନା ଆଡଃ ଇନିଃ ଏନ୍‌ ପିଡ଼ିରେ ତାବେର୍‌ତେ ଉୟୁଃୟାନା ଆଡଃ ଆୟାଃ ଲାହିଦ୍‌ ଫାଡ଼ାଃୟାନ୍‌ତେ ଏନ୍‌ ଭିତାର୍‌ରେୟାଃ ସବେନ୍‌ ପଟାକ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଆଡଃ ଯୀରୁଶାଲେମ୍‌ରେ ତାଇନ୍‌ତାନ୍ ସବେନ୍‌ ହଡ଼କ ନେଆଁଁ ସାରିକେଦ୍‌ତେ, ଆକଆଃ ଜାଗାର୍‌ତେ ଏନ୍‌ ପିଡ଼ିରାଃ ନୁତୁମ୍‌ ହକଲ୍‌ଦମା ମେନ୍ତେକ ନୁତୁମ୍‌କେଦା, ଏନାରାଃ ମୁଣ୍ଡିଦ “ମାୟୋମ୍‌ରାଃ ପିଡ଼ି” ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ଚିୟାଃଚି ଦୁରାଙ୍ଗ୍‌ପୁଥିରେ ଅଲାକାନା, ଇନିୟାଃ ଅଡ଼ାଃ ସିଃସଏଃଗି ହବାଅଃକା; ଏନାରେ ଜେତାଏ ଆଲକାକ ତାଇନଃକା । ନେଆଁଁହଗି ଅଲାକାନା, ଇନିୟାଃ କାମି ଏଟାଃନିଃ ନାମେକାଏ । ");
INSERT INTO unx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ଏନାମେନ୍ତେ ପ୍ରାଭୁ ୟୀଶୁଆଃ ଜୀଉବିନିରିଦ୍‌ରାଃ ଗାୱା ହବାଅଃ ନାଗେନ୍ତେ ଆଡଃମିହୁଡ଼୍‌ ଆବୁଲଃ ମେସାଅଃ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ୟୀଶୁ ଯୋହାନ୍‌ତାଃଏତେ ବାପ୍ତିସ୍ମା ହବାୟାନ୍‌ ହୁଲାଙ୍ଗ୍‌ତାଃଏତେ ୟୀଶୁ ସିର୍ମାତେ ଇଦିୟଃ ହୁଲାଙ୍ଗ୍‌ ଜାକେଦ୍‌ ସବେନ୍‌ ଦିପିଲିରେ ପ୍ରାଭୁ ୟୀଶୁ ଆବୁଲଃ ହିଜୁଃ ସେନଃ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଅକନ୍‌ ହଡ଼କ ଆବୁଆଃ ଝୁଣ୍ଡ୍‌ରେ ତାଇକେନାକ, ଇନ୍‌କୁଏତେ ମିହୁଡ଼୍‌କେ ଆବୁଲଃ ଇନିୟାଃ ଜୀଉବିନିରିଦ୍‌ରେୟାଃ ଗାୱା ଏମ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ଏନାତେ ଇନ୍‌କୁ ମାଥିଆସ୍‌ ଆଡଃ ଯୋଷେଫ୍‌, ଅକଏକେଚି ବାର୍ଶବାସ୍‌ ମେନ୍ତେ କାଜିୟାଃକ ଆଡଃ ଜୁସ୍ତସ୍‌ ମେନ୍ତେହଁ କାଜିୟାଃକ, ନେ ବାର୍‌ହଡ଼୍‌କିନ୍‌କେ ସାଲାକେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ଏନ୍ତେ ଇନ୍‌କୁ ବିନ୍ତିତାନ୍‍ଲଃ କାଜିକେଦାକ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ ସବେନ୍‌କଆଃ ମନ୍‌ସୁରୁଦ୍‌ରେୟାଃ ଉଡ଼ୁଃ ସାରିୟାଃମେ । ନେ ବାର୍‌ହଡ଼୍‌କିନ୍‌ଏତେ ଆମାଃ ହରାତେ ସାଲାକାନ୍‌ନିଃ ଅକ୍‌ନିଃ ତାନିଃ ଏନା ଆଲେକେ ଉଦୁବାଲେମେ । ");
INSERT INTO unx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଏନ୍‌ ହଡ଼ ଇଷ୍କାରିୟତ୍‌ ଯିହୁଦାରାଃ ଠାୟାଦ୍‌ରେ ପ୍ରେରିତ୍‌ କାମି କାମିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ଏନ୍ତେ ଇନ୍‌କୁ ଚିଟ୍‌ପଟ୍‌ ସାଲାକେଦାକ ଆଡଃ ମାଥିଆସ୍‌ଆଃ ନୁତୁମ୍‌ରେ ଅଡଙ୍ଗ୍‌ୟାନା । ଏନ୍ତେ ଇନିଃ ଗେଲ୍‌ମିଆଁଦ୍‌ ପ୍ରେରିତ୍‌କଲଃ ମେସାୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ପେଣ୍ଟିକଷ୍ଟ୍‌ ପାରାବ୍‌ ତେବାଃୟାନ୍‌ଚି, ସବେନ୍‌ ବିଶ୍ୱାସୀକ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିଆକାନ୍‍କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଇମ୍‌ତାଙ୍ଗ୍‌ ଦୁଦ୍‌ଗାର୍‌ ହୟ ହୟତାନ୍‍ଲେକା ସିର୍ମାଏତେ ସାଡ଼ି ଆୟୁମ୍‌ୟାନା ଆଡଃ ଇନ୍‌କୁ ଦୁବାକାନ୍‌ ତାଇକେନ୍‌ ଗଟା ଅଡ଼ାଃରେ ପେରେଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ଏନ୍ତେ ଇନ୍‌କୁ ସେଙ୍ଗେଲ୍‍ ଲେକାନ୍ ଆଲାଙ୍ଗ୍‌କ ବିପିଙ୍ଗାଅଃତାନ୍ ନେଲ୍‌କେଦାକ ଆଡଃ ଏନା ଏନ୍ତାଃରେ ତାଇକେନ୍‌ ମିମିଆଦ୍‌ ହଡ଼ରେ ଆଡ଼୍‌ଗୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ଇନ୍‌କୁ ସବେନ୍‌କ ପାବିତାର୍‌ ଆତ୍ମାତେକ ପେରେଃୟାନା ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମା ଇନ୍‌କୁକେ ଦେଙ୍ଗାକେଦ୍‌କ ଲେକାଗି ଏଟାଃ ଏଟାଃ ଜାଗାର୍‌ତେ କାଜି ଏଟେଦ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ଅତେଦିଶୁମ୍‌ରେୟାଃ ଏଟାଃ ଏଟାଃ ଦିଶୁମ୍‌ଏତେ ହିଜୁଆକାନ୍‍ ଯିହୁଦୀ ଧାରାମାନ୍‌ ହଡ଼କ ଇମ୍‌ତା ଯୀରୁଶାଲେମ୍‌ରେକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ଇନ୍‌କୁ ନେ ଲାବ୍‌ଜା ଆୟୁମ୍‌କେଦ୍‌ଚି, ଗାଦେଲ୍‌ ହଡ଼କ ହିଜୁଃ ହୁଣ୍ଡିୟାନା ଆଡଃ ସବେନ୍‌କ ଆକଆଃ ଆକଆଃ ଜାଗାର୍‌ତେ ଖ୍ରୀଷ୍ଟ୍‌ ବିଶ୍ୱାସୀକକେ କାଜିତାନ୍‌ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆକ୍‌ଚାକାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ଆଡଃ ଇନ୍‌କୁ ସବେନ୍‌କ ଆକ୍‌ଦାନ୍ଦାଅୟାନା ଆଡଃ ହାଏକାଟ୍‍ୟାନ୍ତେ କୁପୁଲିୟାନାକ, “ନେଲେପେ, ଚିୟାଃ ନେ ସବେନ୍‌ କାଜିତାନ୍‍ ହଡ଼କ ଗାଲିଲ୍‌ରେନ୍‌ ନାହାଁଲାକ ? ");
INSERT INTO unx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ତାବ୍‌ଦ ଆବୁ ସବେନ୍‌କ ଚିଲ୍‍କାତେ ଇନ୍‌କୁକେ ଆବୁଆଃ ଆପ୍‌ନାଃ ଜାଗାର୍‌ତେ କାଜିତାନ୍‌ବୁ ଆୟୁମ୍‌କତାନା ? ");
INSERT INTO unx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ଆବୁ ପାର୍ଥିୟା, ମାଦିୟା, ଏଲାମିୟା, ମେସପଟାମିଆ, ଯିହୁଦା, କାପାଦକିଆ, ପନ୍ତ, ଆଡଃ ରୋମ୍‌ ଏସିଆରେନ୍‍କ, ");
INSERT INTO unx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ଫ୍ରୁଗିଆ, ପାମ୍ପିଲିଆ, ମିସାର୍‌, କୁରିନି ନାଡ଼େଃରେଆଃ ଲିବିୟାରେନ୍‍କ ଆଡଃ ରୋମିଏତେ ହିଜୁଃକାନ୍ ");
INSERT INTO unx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ଯିହୁଦୀ ଆଡଃ ଯିହୁଦୀ ଧାରାମ୍‌ରେ ମେସାକାନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କ, ଚିମିନ୍‌ କ୍ରିତ୍‌ରେନ୍‌ ଆଡଃ ଆରାବ୍‌ରେନ୍‍ ହଡ଼କ ତାନ୍‌ବୁ, ଏନ୍‌ରେୟ ଆବୁ ଆବୁଆଃ ଜାଗାର୍‌ତେ ଇନ୍‌କୁକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାପ୍‌ରାଙ୍ଗ୍‌ କାମିରାଃ କାଜିକ କାଜିତାନ୍‌ବୁ ଆୟୁମ୍‌କତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ଆଡଃ ଇନ୍‌କୁ ସବେନ୍‌କ ଆକ୍‌ଦାନ୍ଦାଅ ଆଡଃ ଆଡ଼ାଃଉଡ଼ୁଃୟାନ୍‌ଲଃ ଆକ ଆକଗି କୁପ୍‌ଲିୟାନାକ, “ନେଆଁରାଃ ମୁଣ୍ଡି ଚିନାଃ ତାନାଃ ?” ");
INSERT INTO unx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ମେନ୍‌ଦ ଏଟାଃ ହଡ଼କ ବିଶ୍ୱାସୀକକେ ଲାନ୍ଦା ଏସେଦ୍‌ତାନ୍‌ଲଃ କାଜିକେଦ୍‌କଆକ, “ଇନ୍‌କୁ ନାୱା ଦାଖ୍‌ରାସି ପୁରାଃଗି ନୁଁକେଦ୍‌ତେ ବୁଲାକାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଗେଲ୍‌ମିଆଁଦ୍‌ ଚେଲାକଲଃ ତିଙ୍ଗୁୟାନାଏ ଆଡଃ କାଉରିକେଦ୍‌ତେ ଉଦୁବ୍‌ ଏଟେଦ୍‌କେଦାଏ, “ଏ ଯିହୁଦୀ ହାଗାକ, ଆଡଃ ଯୀରୁଶାଲେମ୍‌ରେ ତାଇନ୍‍ତାନ୍‍ ସବେନ୍‌ ହଡ଼କ, ଆଇଙ୍ଗ୍‌ କାଜିତାନ୍‌ତେୟାଃ ବୁଗିଲେକା ଆୟୁମେପେ ଆଡଃ ଆଇଙ୍ଗ୍‌ ନେ ବିଷାଏରେ କାଜିପେତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ଆପେ ନେ ହଡ଼କକେ ବୁଲଃତାନାକ ମେନ୍ତେପେ ବିଚାରେତାନା, ମେନ୍‌ଦ କାହାଗି, ନାହାଁଃଦ ସେତାଃରାଃ ଅରେୟା ସାଡିକାନା । ");
INSERT INTO unx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ମେନ୍‌ଦ ଯୋଏଲ୍‌ ନାବୀ କାଜିକାଦ୍‌ କାଜି ନେଆଁଁ ତାନାଃ : ");
INSERT INTO unx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିତାନାଏ, ‘ତାୟମ୍ ହୁଲାଙ୍ଗ୍‌କରେ ଆଇଙ୍ଗ୍‌ ନେ ସବେନାଃ ରିକାଏୟାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ସବେନ୍‌ ହଡ଼କ ଚେତାନ୍‌ରେ ଆଇଁୟାଃ ଆତ୍ମାକେଇଙ୍ଗ୍‌ ଦୁଲିୟା ଆଡଃ ଆପେୟାଃ କଡ଼ାହନ୍‌ କୁଡ଼ିହନ୍‌କ ଆୟାର୍‌କାଜିକ କାଜିୟା, ଆଡଃ ଆପେୟାଃ ସେପେଡ଼େଦ୍‍କ ଦାର୍‌ଶାନ୍‌କ ନେଲେୟା, ଆଡଃ ଆପେୟାଃ ପ୍ରାଚିନ୍‌କ କୁମୁୟାଁ । ");
INSERT INTO unx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ହେଗି, ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌କରେ ଆଇଁୟାଃ ଦାସିକ ଆଡଃ କାମ୍‌ଡ଼ିକରେହଗି, ଆଇଁୟାଃ ଆତ୍ମାକେଇଙ୍ଗ୍‌ ଦୁଲିୟା, ଆଡଃ ଇନ୍‌କୁ ଆଇଁୟାଃ ଆୟାର୍‌କାଜିକ ଉଦୁବେୟା । ");
INSERT INTO unx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ଆଇଙ୍ଗ୍‌ ଚେତାନ୍‌ ସିର୍ମାରେ ପେଡ଼େୟାନ୍‌ କାମିକ ଆଡଃ ଅତେଦିଶୁମ୍‌ରେ ଆକ୍‌ଦାନ୍ଦାଅ ଚିହ୍ନାଁଁକଇଙ୍ଗ୍‌ ରିକାୟା । ଅତେଦିଶୁମ୍‌ ମାୟୋମ୍‌, ସେଙ୍ଗେଲ୍ ଆଡଃ ପୁରାଃ ସୁକୁଲ୍‌ତେ ପେରେଜଃଆ; ");
INSERT INTO unx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ପ୍ରାଭୁଆଃ ମାରାଙ୍ଗ୍‌ ଆଡଃ ମାନାରାଙ୍ଗ୍‌ ହୁଲାଙ୍ଗ୍‌ ହିଜୁଃ ସିଦାରେ ସିଙ୍ଗି କୁଲ୍‌କୁଲ୍‌ ନୁବାଗଃଆ, ଆଡଃ ଚାଣ୍ଡୁଃ ମାୟୋମ୍‌ ଲେକା ହବାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ଆଡଃ ଏନ୍‌ ଦିପିଲିକରେ ଜେତାଏ ପ୍ରାଭୁଆଃ ନୁତୁମ୍‌ତେ ବିନ୍ତିୟାଏ, ଇନିଃ ଜୀଉ ବାଞ୍ଚାଅ ନାମେୟାଏ ।’ ");
INSERT INTO unx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହାଗାକ, ନେ କାଜି ଆୟୁମେପେ, ପୁରାଃ ପେଡ଼େୟାନ୍ କାମିକ, ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ଆଡଃ ଚିହ୍ନାଁକ ନାଗେନ୍ତେ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କୁଲାକାନ୍‌ନିଃ ତାନିଃ ମେନ୍ତେ ଆପେୟାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ପକ୍‌ତା ସାବୁଦ୍‌ ହବାକାନା । ଏନାକ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେୟାଃ ଥାଲାରେ ଇନିୟାଃ ହରାତେ ରିକାକାଦାଏ ଏନାପେ ସାରିତାନା । ");
INSERT INTO unx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ସାନାଙ୍ଗ୍‌ ଲେକାତେ ୟୀଶୁକେ ଆପେୟାଃ ତିଃଇରେ ଜିମାଇ ନାଗେନ୍ତେ ପାହିଲାରେ ମନ୍‌ ବାଇୟାକାଦ୍‌ ତାଇକେନାଏ ଆଡଃ ଆପେ ଇନିଃକେ କା ଧାର୍‌ମାନ୍‌ ହଡ଼କଆଃ ହରାତେ କ୍ରୁଶ୍‌ରେପେ କିଲାକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଗନଏଃରାଃ ତନଲ୍ ରାଡ଼ାକେଦ୍‌ତେ ଜୀଉବିରିଦ୍‌କିୟାଏ, ଚିୟାଃଚି ଗନଏଃ ଇନିଃକେ ଦହ କାଏ ଦାଡ଼ିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଦାଉଦ୍‌ ଇନିୟାଃ ବିଷାଏରେ କାଜିକାଦାଏ, “‘ଆଇଙ୍ଗ୍‌ ପ୍ରାଭୁକେ ସବେନ୍‌ ଇମ୍‌ତା ଆଇଁୟାଃ ଆୟାର୍‌ରେ ନେଲି ତାଇକେନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ଆଲକାଇଙ୍ଗ୍‌ ଏକ୍‌ଲାଅଃକା ମେନ୍ତେ ଇନିଃ ଆଇଁୟାଃଲଃ ମେନାଇୟା । ");
INSERT INTO unx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ଏନା ନାଗେନ୍ତେ ଆଇଁୟାଃ ମନ୍‌ସୁରୁଦ୍‌ ରାସ୍‌କାତେ ପେରେଜାକାନା, ଆଡଃ ଆଲାଙ୍ଗ୍‌ତାଇୟାଁଃ ଲାନ୍ଦା ରାସ୍‌କାତେ ପେରେଃୟାନା । ଆଡଃ ଆଇଁୟାଃ ଗନଏଃ ହଡ଼୍‌ମ ଆସ୍ରାଏତାନ୍‍ଲଃ ଜୀହିଦଃଆ, ");
INSERT INTO unx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ଚିୟାଃଚି ଆମ୍‌ ଆଇଁୟାଃ ଜୀଉକେ ଗନଏଃଗାଡ଼ାରେ କାମ୍‌ ବାଗିୟା, ଆଡଃ ଆମାଃ ପାବିତାର୍‌ ଦାସିକେ ତପାଗାଡ଼ାରେ ଜିୟନଃ ନାଗେନ୍ତେ କାମ୍‌ ବାଗିୟା । ");
INSERT INTO unx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ଜୀଦାନ୍‌ରାଃ ହରା ଉଦୁବାକାଦିୟାଁମ୍‌, ଆଡଃ ଆମାଃ ହେପାଦ୍‌ରେ ଆଇଙ୍ଗ୍‌କେ ରାସ୍‌କାତେମ୍‌ ପେରେଜିୟାଁ ।’ ");
INSERT INTO unx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହାଗା ମିଶିକ, ଆଇଙ୍ଗ୍‌ ଆପେକେ ଆବୁଆଃ ପୁର୍‌ଖାହାଡ଼ାମ୍‌କଆଃ ରାଜା ଦାଉଦ୍‌ଆଃ ବିଷାଏରେ ସାଫାସାଫା କାଜି ଦାଡ଼ିୟାଇଙ୍ଗ୍‌ । ଇନିଃ ଗଏଃକେଦ୍‌ତେ ତପାୟାନାଏ ଆଡଃ ଇନିୟାଃ ତପାଠାୟାଦ୍ ତିସିଙ୍ଗ୍‌ ଜାକେଦ୍‌ ଆବୁଆଃ ଥାଲାରେମେନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ଇନିଃଦ ନାବୀ ତାଇକେନାଏ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ବାନାର୍‌ସା ଏମାକାଇ ତାଇକେନାଏ, ଏନା ଇନିଃ ସାରିକାଦ୍‌ ତାଇକେନାଏ । ଦାଉଦାଃ କିଲିକଏତେ ମିହୁଡ଼୍‌ ରାଜ୍‌ଗାଦିରେ ଦୁବାଏ ମେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ବାନାର୍‌ସା ଏମାକାଦ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ପାର୍‌ମେଶ୍ୱାର୍‌ ହିଜୁଃ ଦିପିଲିରେ ଅକ୍‌ନାଃ ରିକା ନାଗେନ୍ତେ ସେନଃତାନା, ଏନା ଦାଉଦ୍‌ ସାରିକେଦ୍‌ତେ, ମାସିଆଃ ଜୀଉବିନିରିଦ୍‌ ବିଷାଏରେ କାଜିକାଦାଏ, “‘ଇନିଃକେ ଗନଏଃଗାଡ଼ା କାଏ ବାଗିକିୟା, ଆଡଃ ଆୟାଃ ହଡ଼୍‌ମ ତପାଗାଡ଼ାରେ କା ଜିୟନ୍‌ୟାନା ।’ ");
INSERT INTO unx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ପାର୍‌ମେଶ୍ୱାର୍‌ ନେ ୟୀଶୁକେଗି ଜୀଉବିରିଦ୍‍କିୟାଏ ଆଡଃ ଆବୁ ସବେନ୍‌କ ଏନାରାଃ ଗାୱାକତାନ୍‍ବୁ । ");
INSERT INTO unx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ୟୀଶୁ ଆୟାଃ ଆପୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଜମ୍‌ତିସାଃତେ ବିରିଦ୍‌କାନା ଆଡଃ ଆପୁଆଃ ବାନାର୍‌ସା ଲେକାତେ ପାବିତାର୍‌ ଆତ୍ମା ନାମ୍‍କେଦାଏ, ଆଡଃ ନାହାଁଃ ଆପେ ନେଲେତାନ୍‌ତେୟାଃ ଆଡଃ ଆୟୁମେତାନ୍‌ତେୟାଃ ଇନିୟାଃ ବାର୍‌ଦାନ୍‌ ତାନାଃ । ଏନା ଇନିଃ ଆବୁଆଃ ଚେତାନ୍‌ରେ ଦୁଲାକାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ଚିୟାଃଚି ଦାଉଦ୍‌ଦ ସିର୍ମାତେ କାଏ ରାକାବ୍‌ ମେନ୍‌ଦ ଇନିଃ ଆଇଃକ୍‌ଗି କାଜିକେଦାଏ, ‘ପ୍ରାଭୁ ଆଇଁୟାଃ ପ୍ରାଭୁକେ କାଜିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ଆଇଙ୍ଗ୍‌ ଆମାଃ ବାଇରିକକେ ପୁରା ଆଉରିଙ୍ଗ୍‌ ହାରାଅକ ଜାକେଦ୍‌ ଆମ୍‌ ଆଇଁୟାଃ ଜମ୍‍ତିସାଃରେ ଦୁବାକାନ୍‍ମେ ।’ ");
INSERT INTO unx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ଆପେ କ୍ରୁଶ୍‌ରେ କିଲାକାଇ ୟୀଶୁକେ, ପାର୍‌ମେଶ୍ୱାର୍‌, ପ୍ରାଭୁ ଆଡଃ ମାସି ମେନ୍ତେ ନୁତୁମ୍‍କିୟାଏ, ନେଆଁଁ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ସାର୍‍ତିଗିକ ଆଟ୍‌କାରେକା ।” ");
INSERT INTO unx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ହଡ଼କଆଃ ମନ୍‌ସୁରୁଦ୍‌ ରଅଃୟାନା ଆଡଃ ଇନ୍‌କୁ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଏଟାଃ ପ୍ରେରିତ୍‌କକେ କାଜିୟାଦ୍‍କଆକ, “ହେ ହାଗାକ, ଆଲେ ଚିନାଃଲେ ଚିକାୟା ?” ");
INSERT INTO unx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ଆପେ ପାପ୍‍ ଏତେ ମନ୍‌ରୁହାଡ଼େପେ ଆଡଃ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ନୁତୁମ୍‌ତେ ବାପ୍ତିସ୍ମାଅଃପେ, ଏନ୍ତେ ଆପେୟାଃ ପାପ୍‌କ ଛାମାଅଃଆ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାର୍‌ଦାନ୍‌, ପାବିତାର୍‌ ଆତ୍ମାକେପେ ନାମିୟା । ");
INSERT INTO unx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନେ ବାନାର୍‌ସା କାଜିଦ ଆପେୟାଃ ଆଡଃ ଆପେୟାଃ ହନ୍‌କଆଃ ନାଗେନ୍ତେ, ଆଡଃ ଆବୁଆଃ ପ୍ରାଭୁ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଃକ୍‌ଗି କେଡ଼ାକାଦ୍‌ ସାଙ୍ଗିନ୍‍ରେନ୍ ସବେନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ପାତ୍‌ରାସ୍‌ ଆଡଃଗି ପୁରାଃ କାଜିକ କାଜିକେଦ୍‌ତେ ଇନ୍‌କୁକେ କାଜିଗରଙ୍ଗ୍‌କେଦ୍‌ତେ କାଜିକେଦ୍‌କଆ, “ନେ ପାରିୟାରେନ୍‌ ଏତ୍‌କାନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ହିଜୁଃତାନ୍‌ ସାଜାଇଏତେ ପ୍ରାଭୁ ଆପେକେ ବାଞ୍ଚାଅପେକା ।” ");
INSERT INTO unx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ଏନ୍ତେ ଇନ୍‌କୁଏତେ ଚିମିନ୍‌ ହଡ଼କ ଇନିୟାଃ କାଜି ସୁକୁତେ ତେଲାକେଦ୍‍ଲଃ ବିଶ୍ୱାସ୍‌କେଦାକ ଆଡଃ ବାପ୍ତିସ୍ମାୟାନାକ । ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଆପି ହାଜାର୍‌ ଲେକା ହଡ଼କ କାଲିସିୟାରେକ ମେସାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ଆଡଃ ଇନ୍‌କୁ ଏନ୍‌ ପ୍ରେରିତ୍‌କଆଃ ଇନିତୁରେ, ମେନେସାରେ, ହଲଙ୍ଗ୍‌ କେଚାଃରେ ଆଡଃ ବିନ୍ତିରେ ତାଇନ୍‍ତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ପ୍ରେରିତ୍‌କ ପୁରାଃ ପେଡ଼େୟାନ୍‍କାମି, ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ, ଆଡଃ ଚିହ୍ନାଁ କାମିକେଦ୍‌ ହରାତେ ସବେନ୍‌ ହଡ଼କ ଆକଆଃ ଜୀଉରେ ହାଏକାଟ୍‌ତେ ପେରେଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ସବେନ୍‌ ବିଶ୍ୱାସୀକ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିୟାନ୍‌ଲଃ ଆକତାଃରେ ତାଇକେନ୍‌ ସବେନ୍‌ ମେନାଃତେୟାଃ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ଆଡଃ ଇନ୍‌କୁ ଆକଆଃ ସବେନ୍‌ ଲୟଙ୍ଗ୍‌କ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ଟାକା ପାଏସାକେ ମିମିଆଦ୍‌‌ନିଃକେ ଲାଗାତିଙ୍ଗ୍‌ ଲେକା ସବେନ୍‌କ ହାପ୍‍ଟିଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ଇନ୍‌କୁ ମାନ୍ଦିର୍‌ଅଡ଼ାଃରେ ସବେନ୍‌ହୁଲାଙ୍ଗ୍‌ ମିଦ୍‍ତାଃରେ ହୁଣ୍ଡିକେଦ୍‌ତେ ଆକଆଃ ଅଡ଼ାଃକରେ ହଲଙ୍ଗ୍‌ କେଚାଃତାନ୍‌ଲଃ ରାସ୍‌କାତେ ଆଡଃ ଲେବେଃ ମନ୍‌ସୁରୁଦ୍‌ତେ ଜମ୍‍ତାନ୍‍ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ଆଡଃ ଇନ୍‌କୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ତାଇକେନାକ ଆଡଃ ସବେନ୍‌ ହଡ଼କ ଇନ୍‌କୁକେ ସୁକୁଆକ ତାଇକେନାକ । ଆଡଃ ପ୍ରାଭୁ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ପାରିତ୍ରାଣ୍‌ ନାମେତାନ୍‌ ହଡ଼କକେ କାଲିସିୟାରେ ମେସାକୁତାନ୍ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ମୁସିଙ୍ଗ୍‌ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ ବିନ୍ତି ଦିପିଲିରେ ତାର୍‍ସିଙ୍ଗ୍‌ ଆପିଘାଡ଼ି ଇମ୍‌ତାକ ମାନ୍ଦିର୍‌ତେକିନ୍ ସେନଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ଏନ୍ତାଃରେ ଜାନାମ୍‌ଏତେ କାଟା କୁଚୁଙ୍ଗ୍‌କାନ୍‌ ମିଆଁଦ୍‌ ହଡ଼, ମାନ୍ଦିର୍‌ ଅଡ଼ାଃତେ ବଲତାନ୍‌ ପୁରାଃ ହଡ଼କତାଃଏତେ କଏଁନାମେ ନାଗେନ୍ତେ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଃ ସୁଗାଡ଼ାନ୍‌ ନୁତୁମାକାନ୍‌ ଦୁଆର୍‌ତାଃତେ ଗଅଃ ଇଦିୟଃତାନ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ଇନିଃ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌କେ ମାନ୍ଦିର୍‌ତେ ବଲତାନ୍ ନେଲ୍‍କେଦ୍‍ତେ ଇନ୍‌କିନ୍‌କେ କଏଁ ଆସିକେଦ୍‍କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ ଇନିଃକେ ମିଦ୍‌ନାଜେର୍‌ରେ ନେଲ୍‌କିଃତେ, ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ଆଲିଙ୍ଗ୍‌ସାଃତେ ନେଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ଇନିଃ ଇନ୍‌କିନ୍‌ତାଃଏତେ ଜେତ୍‌ନାଃ ନାମେ ନାଗେନ୍ତେ ଆସ୍ରାଏତାନ୍‍ଲଃ ଇନ୍‍କିନ୍‌ସାଃତେ ନେଲ୍‍କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ କାଜିକିୟାଏ, “ରୁପା ଚାଏ ସୋନା ଆଇଙ୍ଗ୍‌ତାଃରେ ବାନଆଃ, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ତାଃରେ ମେନାଃତେୟାଃଇଙ୍ଗ୍‌ ଏମାମେତାନା, ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ନୁତୁମ୍‌ତେ ଆଚୁମେତାନାଇଙ୍ଗ୍‌ ବିରିଦ୍‌ମେ ଆଡଃ ସେନେମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ଏନ୍ତେ ଇନିଃ ଇନିୟାଃ ଜମ୍‍ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ ବିରିଦ୍‌କିୟା ଆଡଃ ଇମ୍‍ତାଗି ଇନିୟାଃ କାଟା ଆଡଃ କାଟାମୁକ୍‌ଣୀକରେ ପେଡ଼େଃ ନାମ୍‍କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ଆଡଃ ଇନିଃ ନିର୍‌ବିରିଦ୍‍ୟାନାଏ ଆଡଃ ସେନ୍‌ ଏଟେଦ୍‌କେଦାଏ । ଏନ୍ତେ ଇନିଃ ସେସେନ୍‌ତାନ୍‌ଲଃ, ଡେଗାଅତାନ୍‌ଲଃ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ତାନ୍‍ଲଃ ଇନ୍‌କିନ୍‌ଲଃ ମାନ୍ଦିର୍‌ତେ ବଲୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ଏନ୍ତାଃରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ଇନିଃକେ ସେନ୍‍ବାଡ଼ାତାନ୍ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ତାନ୍‌କ ନେଲ୍‍କିୟା, ");
INSERT INTO unx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ଆଡଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରାଃ ସୁଗାଡ଼ାନ୍‌ ଦୁଆର୍‌ତାଃରେ ଦୁବ୍‍କେଦ୍‌ତେ କଏଁ ଆସିତାଇକେନାଏ, ଇନିଃ ନିଃଗି ତାନିଃ ମେନ୍ତେ ନେଲ୍‍ଉରୁମ୍‍କିୟାକ ଆଡଃ ଇନିଃରେ ହବାକାନ୍‌ତେୟାଃ ସବେନ୍‌ ସାରିକେଦ୍‌ତେ ଇନ୍‌କୁ ପୁରାଃ ହାଏକାଟ୍‌ ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ସୁଲିମାନ୍‌ ନୁତୁମ୍‌ ପିଣ୍ଡ୍‌ଗିତାଃରେ ଏନ୍‌ ବୁଗିକାନ୍ ହଡ଼କେ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ଲଃ ନେଲ୍‌କେଦ୍‌ତେ ସବେନ୍‌ ହଡ଼କ ହାଏକାଟ୍‍ୟାନ୍ତେ ଇନ୍‍କିନ୍‌ତାଃକ ନିର୍‍ଆଉକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପାତ୍‌ରାସ୍‌ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌ତେ କାଜିୟାଦ୍‌କଆଏ, “ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କ, ଆପେ ନେ ହଡ଼ ନାଗେନ୍ତେ ଚିନାଃମେନ୍ତେପେ ହାଏକାଟଃତାନା, ଆଡଃ ଆଲିଙ୍ଗ୍‌କେପେ ନେଲ୍‌ତାନା ? ଆଲିଙ୍ଗ୍‌ ଆଲିଙ୍ଗ୍‌ୟାଁଃ ପେଡ଼େଃତେ ଚାଏ ଧାର୍‌ମାନ୍‌ତେ ଇନିଃକେ ସେସେନ୍‌ ନାଗେନ୍ତେ ପେଡ଼େଃଲିଙ୍ଗ୍‌ ଏମାକାଇୟା ମେନ୍ତେପେ ଉଡ଼ୁଃତାନାଚି ? ");
INSERT INTO unx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଆବ୍ରାହାମ୍‌, ଇସାକ୍‌, ଆଡଃ ଯାକୁବ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଆବୁଆଃ ପୁର୍‌ଖାହାଡ଼ାମ୍‌କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ଦାସି ୟୀଶୁକେ ମାଇନାନ୍‌କିୟା । ମେନ୍‌ଦ ଆପେ ଏନ୍‌ ୟୀଶୁକେ ଆକ୍‌ତେୟାର୍‌କଆଃ ତିଃଇରେ ଜିମାକିୟାପେ ଆଡଃ ପିଲାତୁସ୍‌ ଇନିଃକେ ରାଡ଼ାଇ ନାଗେନ୍ତେ ଉହାଟ୍‌କେଦ୍‌ରେୟ, ଆପେ ଇନିଃକେ କାପେ ସୁକୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ଇନିଃ ପାବିତାର୍‌ ଆଡଃ ଧାର୍‌ମାନ୍ ହଡ଼ ତାଇକେନାଏ, ମେନ୍‌ଦ ଆପେ ଇନିଃକେ କାପେ ସୁକୁୟାନା ଆଡଃ ଆୟାଃ ବାଦ୍‌ଲାରେ ହଡ଼ ଗଗଏଃନିଃକେ ରାଡ଼ାଇ ନାଗେନ୍ତେ ପିଲାତୁସ୍‌କେ ଆସିକିୟାପେ । ");
INSERT INTO unx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ଆପେ ଜୀଦାନ୍‌ ହରାତେ ସୁତୁଃଇଦିନିଃକେ ଗଏଃକିୟାପେ, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଗଜାକାନ୍‌କଏତେ ଜୀଉବିରିଦ୍‌କିୟା ଆଡଃ ଆଲେ ଏନାରାଃ ଗାୱାକ ତାନ୍‍ଲେ । ");
INSERT INTO unx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ଆପେ ନେଲାକାଇ ଆଡଃ ସାରିକାଇ ନେ କାଟା କୁଚୁଙ୍ଗ୍‌ ହଡ଼ ୟୀଶୁଆଃ ନୁତୁମ୍‌ରେ ବିଶ୍ୱାସ୍‌କେଦ୍‌ ନାଗେନ୍ତେ ପେଡ଼େଃନାମ୍‌କେଦାଏ । ଆଡଃ ୟୀଶୁରେ ବିଶ୍ୱାସ୍‌କେଦ୍‌ ନାଗେନ୍ତେ ବୁଗିୟାନାଏ, ନେଆଁଁ ଆପେ ସବେନାଃ ନେଲ୍‌ ଦାଡ଼ିତାନାପେ । ");
INSERT INTO unx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହାଗା ମିଶିକ, ନାହାଃଁଦ, ଆପେ ଆଡଃ ଆପେୟାଃ ଆଗୁଆଇକ ୟୀଶୁକେ ରିକାକିଃତେୟାଃ କା ସାରିତେ ରିକାକେଦାପେ ଏନାଇଙ୍ଗ୍‌ ସାରିତାନା । ");
INSERT INTO unx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ମେନ୍‌ଦ ମାସିଆଃ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌ ବିଷାଏରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ସବେନ୍‌ ନାବୀକଆଃ ହରାତେ ନାଙ୍କ ପାରିୟାରେ କାଜିକାଦ୍ ତାଇକେନ୍‌ କାଜି ନେ ଲେକାତେ ପୁରାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ଏନାମେନ୍ତେ ଆପେ ହେୟାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ସାଃତେ ରୁହାଡ଼୍‌ପେ ଏନାରେ ଇନିଃ ଆପେୟାଃ ପାପ୍‌କ ଛାମାପେୟାଏ, ");
INSERT INTO unx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ଆଡଃ ଆପେୟାଃ ପ୍ରାଭୁତାଃଏତେ ଜୀଉରାଡ଼େଃରେୟାଃ ଦିପିଲି ହିଜୁଃଆ, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେ ନାଗେନ୍ତେ ସିଦାରେ ସାଲାକାଇ ୟୀଶୁ ମାସିକେ ଆପେତାଃତେ କୁଲିୟା । ");
INSERT INTO unx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ପାର୍‌ମେଶ୍ୱାର୍‌ ସବେନାଃ ଆଉରି ବାଇରୁହାଡ଼େ ଜାକେଦ୍‌ ୟୀଶୁ ସିର୍ମାରେଗି ତାଇନାଏ ମେନ୍ତେ ପାବିତାର୍‌ ନାବୀକଆଃ ହରାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ନାଙ୍କ ପାରିୟାରେ କାଜିକାଦ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ନେ ବିଷାଏରେ ମୁଶାନାବୀ କାଜିକାଦ୍‌ ତାଇକେନାଏ, ‘ଆପେୟାଃ ପ୍ରାଭୁ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେୟାଃ ହେପାତ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଲେକା ମିଆଁଦ୍‌ ନାବୀକେ କୁଲିୟା । ଇନିଃ ଆପେୟାଃ ହାଗାକଏତେ ମିହୁଡ଼୍‌ ହବାଅଃଆଏ । ଇନିଃ ଆପେକେ କାଜିୟାପେତେୟାଃ ସବେନାଃ ମାନାତିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ମେନ୍‌ଦ ଏନ୍‌ ନାବୀଆଃ କାଜି କା ମାନାତିଙ୍ଗ୍‌ତାନ୍‌ ଜୀଉ ନାମାକାଦ୍‌ ସବେନ୍‌କକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆତମ୍‌କେଦ୍‌ତେ ଜିୟନ୍‌କଆ ।’ ");
INSERT INTO unx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ହେଗି, ଶାମୁଏଲ୍‌ ନାବୀ ଆଡଃ ଇନିୟାଃ ତାୟମ୍‌ତେ କାଜିକେଦ୍‌ ସବେନ୍‌ ନାବୀକହଗି ନେ ଦିପିଲିରେ ହବାଅଃତାନ୍‌ ଆୟାର୍‌କାଜିକ କାଜିକାଦାଃ । ");
INSERT INTO unx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ନାବୀକଆଃ ହରାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଅକ ବାନାର୍‌ସା ଏମାକାଦାଏ, ଏନା ଆପେ ନାଗେନ୍ତେ ହବାକାନା, ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆପେୟାଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କଲଃ ଅକ ରାଜିନାମା ବାଇୟାକାଦାଏ, ଆପେ ଏନାରେୟାଃ ହିସାପେ ନାମେୟା । ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବ୍ରାହାମ୍‌କେ କାଜିକାଇ ତାଇକେନା, ‘ଆପେୟାଃ କିଲିକଆଃ ହରାତେ ଆଇଙ୍ଗ୍‌ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କକେଇଙ୍ଗ୍‌ ଆଶିଷ୍‌କଆ ।’ ");
INSERT INTO unx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ଏନ୍‌ ଦାସିକେ ସାଲାକିୟା ଆଡଃ ଆପେ ସବେନ୍‌କକେ ଏତ୍‌କାନ୍‌ ହରାଏତେ ରୁହାଡ଼୍‌ ଆଉକେଦ୍‌ତେ ଆଶିଷ୍‌ନାଙ୍ଗ୍‌ ପାହିଲାତେ ଇନିଃକେ ଆପେତାଃତେ କୁଲ୍‌କିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ ହଡ଼କକେ କାଜିୟାକ ତାଇକେନ୍‌ରେ ଯାଜାକ୍‌କ, ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେନ୍‌ ଦାରୱାନ୍‌କଆଃ ଗମ୍‌କେ ଆଡଃ ସାଦୁକିକ ଇନ୍‍କିନ୍‍ତାଃତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ଏନ୍ତେ ଇନ୍‌କୁ ପୁରାଃଗିକ ଖିସ୍‌ୟାନା ଚିୟାଃଚି ୟୀଶୁ ଗନଏଃତେ ଜୀଉବିରିଦାକାନାଏ ମେନ୍ତେ ଏନ୍‌ ବାରାନ୍‌ ପ୍ରେରିତ୍‌କିନ୍‌ ଇତୁ ତାଇକେନାକିନ୍‌ । ଏନା ହରାତେ ଗଜାକାନ୍‌କଆଃ ଜୀଉବିନିରିଦ୍‌ ମେନାଃ ମେନ୍ତେ ସାବୁଦ୍‌କିନ୍‌ ଏମେତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ଏନାମେନ୍ତେ ଇନ୍‌କୁ ଇନ୍‌କିନ୍‌କେ ସାବ୍‍କେଦ୍‍କିନାକ । ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ ପୁରାଃ ବିଲାମ୍‌କାନ୍‌ ତାଇକେନ୍‌ ନାଗେନ୍ତେ ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଜାକେଦ୍‌ ଜେହେଲ୍‌ରେକ ଦହକେଦ୍‍କିନା । ");
INSERT INTO unx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ମେନ୍‌ଦ ଇନ୍‌କିନାଃ ଇନିତୁ ଆୟୁମ୍‍କେଦ୍‌କଏତେ ପୁରାଃ ହଡ଼କ ବିଶ୍ୱାସ୍‌କେଦା ଆଡଃ ଏନ୍‌ ହଡ଼କ ମଣେଁ ହାଜାର୍‌ ଲେକାକ ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଯିହୁଦୀକଆଃ ଆଗୁଆଇକ, ପ୍ରାଚିନ୍‌କ ଆଡଃ ଆଇନ୍‌ ଇତୁକ ଯୀରୁଶାଲେମ୍‌ରେକ ହୁଣ୍ଡିୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ଇନ୍‌କୁ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ହାନାନ୍‌, କାୟଫା, ଯୋହାନ୍‌, ଆଲେକ୍‌ଜାଣ୍ଡାର୍‌ ଆଡଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଅଡ଼ାଃରେନ୍‌ ଏଟାଃକଲଃ ନାପାମ୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ଇନ୍‌କୁ ପ୍ରେରିତ୍‌କକେ ଆକଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ତିଙ୍ଗୁକେଦ୍‌ତେ କୁଲିକେଦ୍‌କଆକ, “ଆପେ ନେ ସବେନାଃ ଚିଲ୍‌କା ରିକାତାନାପେ ? ଚିକାନ୍‌ ପେଡ଼େଃତେ ଚାଏ ଅକ ନୁତୁମ୍‌ତେ ନେ କାମିପେ ରିକାତାନା ?” ");
INSERT INTO unx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଃୟାନାଏ ଆଡଃ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‌କଆଏ, “ହଡ଼କଆଃ ଆଗୁଆଇକ ଆଡଃ ପ୍ରାଚିନ୍‌କ, ");
INSERT INTO unx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ତିସିଙ୍ଗ୍‌ ଆଲେ ନେ କାଟା କୁଚୁଙ୍ଗ୍‌କାନ୍‌ନିଃକେ ବୁଗିକାଇ ନାଗେନ୍ତେ ଆପେ ଆଲେକେ କୁଲିଲେତାନାପେ ଆଡଃ ଇନିଃ ଚିଲ୍‌କାତେ ବୁଗିୟାନା, ଏନା ସାରି ନାଗେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନ୍‌ରେଦ, ");
INSERT INTO unx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ଆପେ ସବେନ୍‌କ ଆଡଃ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ସାରିପେ, ଆପେ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ଅକନ୍‌ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌କେ କ୍ରୁଶ୍‌ରେ କିଲାକାଇ ତାଇକେନାପେ, ଇନିଃକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଗଜାକାନ୍‌କଏତେ ଜୀଉବିରିଦ୍‌କିୟା, ଇନିୟାଃ ନୁତୁମ୍‌ରାଃ ପେଡ଼େଃତେ ଏନ୍‌ ହଡ଼ ବୁଗିୟାନାଏ ଆଡଃ ଆପେୟାଃ ଆୟାର୍‌ରେ ତିଙ୍ଗୁଆକାନା । ");
INSERT INTO unx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଧାରାମ୍‌ପୁଥିରେ ୟୀଶୁଆଃ ବିଷାଏରେ ଅଲାକାନା, “‘ଅଡ଼ାଃ ବାବାଇକ ଅକନ୍‌ ଦିରିକେ ଆତମ୍‌ଏଣ୍ଡାଃକେଦାକ ଏନାଗି ଅଡ଼ାଃକଚାରାଃ ଦିରି ହବାୟାନା ।’ ");
INSERT INTO unx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ଇନିଃ ବେଗାର୍‌ ଜେତାଏତାଃରେ ଜୀଉବାଞ୍ଚାଅ ବାନଃଆ, ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବୁଆଃ ଜୀଉବାଞ୍ଚାଅ ନାଗେନ୍ତେ ଗଟା ଅତେଦିଶୁମ୍‌ରେ ଇନିୟାଃ ନୁତୁମ୍‌ ବେଗାର୍‌ ଆଡଃ ଜେତା ନୁତୁମ୍‌ କାଏ ଏମାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ଇନ୍‌କୁ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ଆଃ ଜୀଉରେକେଟେଦ୍‌ ନେଲ୍‍କେଦ୍‌ତେ ଆଡଃ ଇନ୍‌କିନାଃ କା ଇନିତୁ, କା ସେଣାଁଁନ୍‌ ହଡ଼କିନ୍ ତାନ୍‍କିନ୍‌ ଏନା ସାରିକେଦ୍‌ତେକ ହାଏକାଟ୍‍ୟାନା ଆଡଃ ଇନ୍‌କିନ୍‌ ୟୀଶୁଲଃ ତାଇକେନାକିନ୍‌ ମେନ୍ତେ ଇନ୍‌କୁ ଆଟ୍‌କାର୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନ୍‌କିନାଃ ବିରୁଧ୍‌ରେ ଜେତ୍‌ନାଃ କାକ କାଜିଦାଡ଼ିକେଦା ଚିୟାଃଚି ଏନ୍‌ ବୁଗିଆକାନ୍ ହଡ଼କେ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ଲଃ ତିଙ୍ଗୁଆକାନ୍‌କ ନେଲ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ଏନାମେନ୍ତେ ଇନ୍‌କୁ ପାଞ୍ଚେଟ୍‌ ଅଡ଼ାଃଏତେ ଅଡଙ୍ଗ୍‌ଅଃବେନ୍‌ ମେନ୍ତେ ଆଚୁକେଦ୍‌କିନାକ ଆଡଃ ଇନ୍‌କୁ ଆକ ଆକରେ ଇନ୍‌କିନାଃ ବିଷାଏରେକ ଜାଗାର୍‍ ଏଟେଦ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ଇନ୍‌କୁ କୁପ୍‌ଲିୟାନାକ, “ଆବୁ ନେ ହଡ଼କିନ୍‌କେ ଚିନାଃବୁ ଚିକାକିନା ? ଇନ୍‌କିନ୍‌ ସାର୍‍ତିଗି ମିଆଁଦ୍‌ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକିନ୍ କାମିକାଦା ଏନା ଯୀରୁଶାଲେମ୍‌ରେନ୍‌ ସବେନ୍‌କ ସାରିତାନା ଆଡଃ ଏନା ଆବୁ ବାନଃ ମେନ୍ତେ କାବୁ କାଜି ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ମେନ୍‌ଦ ନେ କାଜି ହଡ଼କତାଃରେ ଆଲକା ପାସ୍‍ରାଅଃକା, ଏନା ନାଗେନ୍ତେ ୟୀଶୁଆଃ ନୁତୁମ୍‌ତେ ଜେତା ହଡ଼କକେ ଆଲବେନ୍‌ କାଜିକଆ ମେନ୍ତେ ଇନ୍‍କିନ୍‌କେବୁ ଚେତାଅକିନା ।” ");
INSERT INTO unx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ଏନ୍ତେ ଇନ୍‌କୁ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌କେ ଆଡଃମିସା କେଡ଼ାକେଦ୍‍କିନାକ ଆଡଃ ୟୀଶୁଆଃ ନୁତୁମ୍‌ତେ ଜେତ୍‌ନାଃ ଆଲବେନ୍‌ କାଜିୟାଃ ଚାଏ ଆଲବେନ୍‌ ଇତୁକଆ ମେନ୍ତେକ ଆଚୁକେଦ୍‍କିନାକ । ");
INSERT INTO unx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ ଇନ୍‌କୁକେ କାଜିରୁହାଡ଼ାଦ୍‍କଆକିନ୍, “ଆଲିଙ୍ଗ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାନାତିଙ୍ଗ୍‌ତେୟାଃ ଚାଏ ଆପେୟାଃ କାଜି ମାନାତିଙ୍ଗ୍‌ତେୟାଃ ଅକ୍‌ନାଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆୟାର୍‌ରେ ଠାଉକାନ୍‌ଗିୟା ଏନା ଆପେ ଆପେଗି ବିଚାରେପେ । ");
INSERT INTO unx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ଚିୟାଃଚି ଆଲିଙ୍ଗ୍‌ ନେଲାକାଦ୍‌ତେୟାଃ ଆଡଃ ଆୟୁମାକାଦ୍‌ତେୟାଃ କା ଉଦୁବ୍‍କେଦ୍‍ତେ କାଲିଙ୍ଗ୍‌ ତାଇନ୍‍ଦାଡ଼ିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ଏନ୍ତେ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ହଡ଼କ ଇନ୍‌କିନ୍‌କେ ସାଜାଇ ଏମ୍‌ କା ହବାସାକାଅଆଃ, ଆଡଃ ପୁରାଃ ଚେତାଅତାନ୍‍ଲଃ ଇନ୍‌କିନ୍‌କେ ବାଗିକେଦ୍‍କିନାକ, ଚିୟାଃଚି ହଡ଼କ ଏନ୍‌ ହବାକାନ୍‌ତେୟାଃ ନେଲ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ଆକ୍‌ଦାନ୍ଦାଅ ଲେକାତେ ବୁଗିଆକାନ୍ ଏନ୍‌ ହଡ଼ଆଃ ବାର୍‌ହିସି ବାରାଷ୍‌ଏତେ ଆଦ୍‌କା ହବାଅଃତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ ରାଡ଼ାୟାନ୍‌ଚି, ଇନ୍‌କିନ୍‌ ଆକିନାଃ ଆପ୍‌ନାଃ ହଡ଼କତାଃତେ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କ ଆଡଃ ପ୍ରାଚିନ୍‌କ କାଜିକେଦ୍‌ତେୟାଃ ସବେନାଃ ଇନ୍‌କୁକେ ଉଦୁବାଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ବିଶ୍ୱାସୀକ ସବେନ୍‍ କାଜି ଆୟୁମ୍‌କେଦ୍‌ଚି ମିଦ୍‌ ମନ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ବିନ୍ତିକେଦାକ; “ହେ ଗମ୍‌କେ, ଆମ୍‌ ସିର୍ମା, ଅତେ, ଦରେୟା ଆଡଃ ଏନାରେୟାଃ ସବେନାଃ ବାବାଇନିଃ ତାନ୍‌ମେ ! ");
INSERT INTO unx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ଆମ୍‌ ଆମାଃ ଦାସି, ଆଲେୟାଃ ଆପୁ ଦାଉଦ୍‌ଆଃ ମଚାତେ ପାବିତାର୍‌ ଆତ୍ମାତେ ନେ କାଜି କାଜିକାଦାମ୍‌, “‘ନେ ସାଅଁସାର୍‌ ହଡ଼କ ଚିନାଃମେନ୍ତେ ଖିସ୍‍ୟାନାକ; ଆଡଃ ହଡ଼କ ଚିନାଃମେନ୍ତେ ସାମାକାଜିକ ରୋଜୋଟତାନା ? ");
INSERT INTO unx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ପ୍ରାଭୁଆଃ ବିରୁଧ୍‌ରେ ଆଡଃ ଆୟାଃ ସାଲାକାନ୍‌ ମାସିଆଃ ବିରୁଧ୍‌ରେ ଅତେଦିଶୁମ୍‌ରେନ୍‌ ରାଜାକ ସେକାଡ଼୍‌ୟାନା ଆଡଃ ହାକିମ୍‌କ ମିଦ୍‍ତାଃରେକ ହୁଣ୍ଡିୟାନା ।’ ");
INSERT INTO unx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ଚିୟାଃଚି ସାର୍‌ତି କାଜିଲେରେ ହେରୋଦ୍‌ ଆଡଃ ପନ୍ତିୟସ୍‌ ପିଲାତୁସ୍‌ ନେ ନାଗାର୍‌ରେ ସାଅଁସାର୍‌କଲଃ ଆଡଃ ଇସ୍ରାଏଲ୍‌ ହଡ଼କଲଃ ମେସାକେଦ୍‌ତେ ଆମାଃ ପାବିତାର୍‌ ଦାସି ୟୀଶୁ, ଅକଏକେଚି ଆମ୍‌ ମାସି ମେନ୍ତେମ୍‌ ଆଭିଷେକ୍‌କିୟା, ଇନିୟାଃ ବିରୁଧ୍‌ରେ ରୋଜୋଟକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ଆମାଃ ପେଡ଼େଃ ଆଡଃ ମନେଲେକାତେ ସବେନାଃ ହବାଅଃକା ମେନ୍ତେ ସିଦାରେ ଉହାଟ୍‌କାନ୍‌ ତାଇକେନା, ଏନାକେ ରିକାଏ ନାଗେନ୍ତେ ଇନ୍‌କୁ ହୁଣ୍ଡିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ଆଡଃ ନାହାଁଃଦ, ହେ ପ୍ରାଭୁ, ଇନ୍‌କୁ ଆଲେକେ ବତଙ୍ଗ୍‌ଲେତାନାକ ଏନା ନେଲେମେ ଆଡଃ ଆମାଃ ଦାସିକକେ ପୁରାଃ ପେଡ଼େୟାନ୍‌ତେ ଆମାଃ କାଜି କାଜି ନାଗେନ୍ତେ ଜୀଉରେକେଟେଦ୍‌ ଏମାଲେମେ । ");
INSERT INTO unx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ଆଡଃ ବୁଗିକ ନାଗେନ୍ତେ ଆମାଃ ତିଃଇ ଜିଲିଙ୍ଗ୍‌ୟେଁମେ ଆଡଃ ଆମାଃ ପାବିତାର୍‌ ଦାସି ୟୀଶୁଆଃ ନୁତୁମ୍‌ତେ ଚିହ୍ନାଁ ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ରିକା ନାଗେନ୍ତେ ପେଡ଼େଃ ଏମାଲେମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ଇନ୍‌କୁ ବିନ୍ତି ଟୁଣ୍ଡୁକେଦ୍‌ଚି ଆକ ହୁଣ୍ଡିକାନ୍ ଠାୟାଦ୍‌ତାଃରେ ଅତେ ଏକ୍‌ଲାଅୟାନା ଆଡଃ ସବେନ୍‌କ ପାବିତାର୍‌ ଆତ୍ମାତେକ ପେରେଃୟାନା ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜି ପୁରାଃ ଜୀଉରେ କେଟେଦ୍‌କେଦ୍‌ତେ ଉଦୁବ୍‍ ଏଟେଦ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ବିଶ୍ୱାସୀକ ମିଦ୍‌ ମନ୍‌ ଆଡଃ ମିଦ୍‌ ମନ୍‌ସୁରୁଦ୍‌ୟାନାକ । ଆଡଃ ଜେତାଏ ଆପ୍‌ନାଃ ମେନାଃତେୟାଃକେ ଆପ୍‍ନାଃ ତାନାଃ ମେନ୍ତେ କାକ କାଜି ତାଇକେନା, ମେନ୍‌ଦ ସବେନ୍‌କ ଆକଆଃ ମେନାଃତେୟାଃକେ ମିଦ୍‌ସାମାନ୍‌ଗିକ ହାପ୍‌ଟିଙ୍ଗ୍‌ୟଁଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ପ୍ରେରିତ୍‌କ ପୁରାଃ ପେଡ଼େଃତେ ପ୍ରାଭୁ ୟୀଶୁଆଃ ଜୀଉବିନିରିଦ୍‌ରାଃ ବିଷାଏରେ ଗାୱାକ ଏମ୍‌କେଦା ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କୁକେ ପୁରାଃ ଆଶିଷ୍‌ ଏମ୍‌କେଦ୍‍କଆଏ । ");
INSERT INTO unx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ଏନାତେ ଇନ୍‌କୁଆଃ ଜେତ୍‌ନାଃ କା ହାଟିଅଃ ତାଇକେନା, ଚିୟାଃଚି ଅକନ୍‌କଆଃ ପିଡ଼ି ଆଡଃ ଅଡ଼ାଃ ତାଇକେନା, ଇନ୍‌କୁ ଏନାକ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ଏନାରାଃ ଗନଙ୍ଗ୍‌ ଟାକା ପାଏସା ଆଉକେଦ୍‌ତେ ");
INSERT INTO unx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ପ୍ରେରିତ୍‌କକେ ଏମାକ ତାଇକେନାକ ଆଡଃ ଏନ୍‌ ପାଏସାକେ ଆକଆଃ ଲାଗାତିୟଃଁ ଲେକାକ ହାପ୍‌ଟିଙ୍ଗ୍‌ୟଁଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ଆଡଃ ସାଇପ୍ରସ୍‌ ନୁତୁମ୍‌ ଠାୟାଦ୍‌ରେ ଜାନାମାକାନ୍‌ ଲେବୀ କିଲିରେନ୍‌ ଯୋଷେଫ୍‌, ଅକଏକେଚି ପ୍ରେରିତ୍‌କ ବର୍ଣ୍ଣବାସ୍‌, ଏନାରାଃ ମୁଣ୍ଡିଦ “ଜୀଉରାଡ଼େଃରାଃ ହନ୍‌” ମେନ୍ତେକ ନୁତୁମ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ଇନିୟାଃ ମିଆଁଦ୍‌ ପିଡ଼ି ତାଇକେନା, ଏନାକେ ଇନିଃ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ତେ ଏନାରାଃ ଟାକା ପାଏସା ପ୍ରେରିତ୍‌କକେ ଏମାଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ହନାନିୟ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ଆୟାଃ କୁଡ଼ିତେ ସଫିରାଲଃ ହୁଡିଙ୍ଗ୍‌ଲେକା ଅତେ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ମେନ୍‌ଦ ହନାନିୟ ଆୟାଃ କୁଡ଼ିତେଲଃ ସାଲ୍‌ହାକେଦ୍‌ତେ, ଇନିଃ କାଟିଃଲେକା ଟାକା ପାଏସା ଆୟାଃ ନାଗେନ୍ତେ ଉକୁ ଦହକେଦା ଆଡଃ ବାକିତେୟାଃ ଇଦିକେଦ୍‌ତେ ପ୍ରେରିତ୍‌କଆଃ କାଟା ଲାତାର୍‌ରେ ଦହକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ପାତ୍‌ରାସ୍‌ ଇନିଃକେ କାଜିକିୟାଏ, “ଏ ହନାନିୟ, ପାବିତାର୍‌ ଆତ୍ମାରାଃ ଆୟାର୍‌ରେ ହସଡ଼ କାଜି ନାଗେନ୍ତେ ଆଡଃ ଅତେରାଃ ଗନଙ୍ଗ୍‌ଏତେ କାଟିଃଲେକା ଉକୁ ନାଗେନ୍ତେ ସାଏତାନ୍‌ ଚିନାଃମେନ୍ତେ ଆମାଃ ମନ୍‌ସୁରୁଦ୍‌କେ ଆକ୍‌ତେୟାର୍‌କେଦା ? ");
INSERT INTO unx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ ସିଦାରେ ଏନା ଚିୟାଃ ଆମାଃ କା ତାଇକେନା ? ଆଡଃ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦ୍‌ ତାୟମ୍‌ତେ ଏନ୍‌ ଟାକା ପାଏସା ଚିନାଃ ଆମାଃ ଆକ୍‌ତେୟାର୍‌ରେ କା ତାଇକେନା ? ତାବ୍‌ଦ ଚିନାଃମେନ୍ତେ ଆମ୍‌ ନେ'ଲେକା ଆମାଃ ମନ୍‌ସୁରୁଦ୍‌ରେମ୍‌ ଉଡ଼ୁଃକେଦା ? ଆମ୍‌ ହଡ଼କକେଦ କା ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆୟାର୍‌ରେ ବେଦାକାଜିମ୍‌ କାଜିକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ନେ କାଜିକ ଆୟୁମ୍‌କେଦ୍‌ଚି ହନାନିୟ ଅତେରେ ଉୟୁଃକେଦ୍‌ତେ ଗଏଃୟାନା, ଆଡଃ ନେ ବିଷାଏରେ ଆୟୁମ୍‌କେଦ୍‌ ସବେନ୍‌କ ପୁରାଃଗିକ ବରକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ସେପେଡ଼େଦ୍‍କ ହିଜୁଃକେଦ୍‌ତେ ଇନିଃକେ ଲିଜାଃତେ ପଟମ୍‍କିୟାକ ଆଡଃ ଗଅଃ ଅଡଙ୍ଗ୍‌କିତେ ତପାକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ଆପି ଘାଡ଼ିଲେକା ତାୟମ୍‌ତେ ଇନିୟାଃ କୁଡ଼ି ଅକ୍‌ନାଃ ହବାକାନ୍‌ତେୟାଃ କା ସାରିକେଦ୍‌ତେ ହିଜୁଃୟାନା ଆଡଃ ବଲୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ପାତ୍‌ରାସ୍‌ ଇନିଃକେ କୁଲିକିୟାଏ, “ଆବେନ୍ ନେ ପିଡ଼ିକେ ନିମ୍‍ନାଙ୍ଗ୍‌ତେଗିବେନ୍ ଆଖ୍‌ରିଙ୍ଗ୍‌କେଦାଚି ?” ଇନିଃ କାଜିରୁହାଡ଼୍‌କେଦାଏ, “ହେଗି, ନିମିନାଙ୍ଗ୍‌ତେଗି ।” ");
INSERT INTO unx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଇନିଃକେ କାଜିକିୟାଏ, “ପ୍ରାଭୁଆଃ ଆତ୍ମାକେ ବିଡ଼ାଅ ନାଗେନ୍ତେ ଆବେନ୍‌ ବାରାନ୍‌କିନ୍‌ ଚିନାଃ ମେନ୍ତେବେନ୍ ଉଡ଼ୁଃକେଦା ? ନେଲ୍‌କୁମ୍, ଆମାଃ କଡ଼ାକେ ତପାକେନ୍‍କ ଦୁଆର୍‌ତାଃରେ ମେନାକଆ ଆଡଃ ଇନ୍‌କୁ ଆମ୍‌କେ ହଗି ଗଅଃ ଅଡଙ୍ଗ୍‌ମେୟାଁକ ।” ");
INSERT INTO unx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","କାଜିକେଦ୍‌ ଇମ୍‍ତାଗି ଇନିଃ ଇନିୟାଃ କାଟା ଲାତାର୍‌ରେ ଉୟୁଃୟାନା ଆଡଃ ଗଏଃୟାନାଏ । ଏନ୍ତେ ସେପେଡ଼େଦ୍‍କ ବଲୟାନ୍‌ଚି ଇନିଃକେ ଗଏଃକାନ୍‌କ ନେଲ୍‌କିୟା ଆଡଃ ଇନ୍‌କୁ ଇନିଃକେ ଗଅଃ ଅଡଙ୍ଗ୍‌କିତେ କଡ଼ାତେୟାଃ ଜାପାଃରେକ ତପାକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ଗଟା କାଲିସିୟା ଆଡଃ ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ ସବେନ୍‌କ ପୁରାଃଗିକ ବରକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ପ୍ରେରିତ୍‌କ ପୁରାଃଗି ଆକ୍‌ଚାକାଅ କାମି ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ହଡ଼କଆଃ ଥାଲାରେକ କାମିକେଦା ଆଡଃ ସବେନ୍‌ ବିଶ୍ୱାସୀକ ସୁଲିମାନ୍‌ଆଃ ପିଣ୍ଡ୍‌ଗିତାଃରେ ହୁଣ୍ଡିୟଃ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ଇନ୍‌କୁଆଃ ବିଷାଏରେ ହଡ଼କ ବୁଗିନାଃ ଜାଗାର୍‌ତାନ୍‌ ତାଇକେନ୍‌ରେୟ ଏଟାଃ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ହଡ଼କ ଇନ୍‌କୁଲଃ ମେସାଅଃ ନାଗେନ୍ତେ ଜେତାଏ କାକ ସାହାସେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ମେନ୍‌ଦ ଗାଦେଲ୍‌ କଡ଼ା ଆଡଃ କୁଡ଼ିକ ପ୍ରାଭୁତାଃରେ ବିଶ୍ୱାସ୍‌କେଦ୍‌ତେ ଚିମିନ୍‌ ଚିମିନ୍‌ ହଡ଼କ ଏନ୍‌ ଝୁଣ୍ଡ୍‌ରେ ମେସାଅଃ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ପ୍ରେରିତ୍‌କଆଃ କାମି ବୁଗିଲେକା ହବାଅଃ ତାଇକେନା, ପାତ୍‌ରାସ୍‌ ହିଜୁଃ ତାଇକେନ୍‌ ଇମ୍‌ତା ହରାରେ ଆୟାଃ ଉମ୍ୱୁଲ୍ ଦୁକୁତାନ୍‍ ହଡ଼କଆଃରେ ଉୟୁଗଃକା ମେନ୍ତେ ହଡ଼କ ଦୁକୁତାନ୍‌କକେ ପାର୍‌କମ୍‌ ଆଡଃ ଜାଟିକରେ ଗଅଃ ଆଉକେଦ୍‌ତେ ହରାଗେନାରେ ଦହକ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଆଡଃ ଯୀରୁଶାଲେମ୍‌ରେୟାଃ ଚାରିୟସାଃରେନ୍ ନାଗାର୍‌କଏତେ ଗାଦେଲ୍‌ ହଡ଼କ ଦୁକୁତାନ୍‌ ଆଡଃ ସତ୍‌ରା ଆତ୍ମାତେ ଏସେରାକାନ୍‌ ହଡ଼କକେ ପ୍ରେରିତ୍‌କତାଃ ଆଉକତାଇକେନାକ ଆଡଃ ଇନ୍‌କୁ ସବେନ୍‌ ବୁଗିୟଃ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଆଡଃ ଆୟାଃ ସବେନ୍‌ ଦେଙ୍ଗାତାନ୍‌କ, ଅକନ୍‌କଚି ସାଦୁକି ଝୁଣ୍ଡ୍‌ରେନ୍‌ ତାଇକେନାକ, ଇନ୍‌କୁ ପ୍ରେରିତ୍‌କଆଃ ଚେତାନ୍‌ରେ ପୁରାଃଗି ହିସ୍‌ଙ୍ଗାତେ ପେରେଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ଇନ୍‌କୁ ପ୍ରେରିତ୍‌କକେ ସାବ୍‌କେଦ୍‌ତେ ଥାନାରେକ ଦହକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ମେନ୍‌ଦ ପ୍ରାଭୁଆଃ ଦୁଁତ୍‌ ଏନ୍‌ ନିଦାଗି ଥାନାରାଃ ଦୁଆର୍‌କେ ନିକ୍‌କେଦା, ଆଡଃ ପ୍ରେରିତ୍‌କକେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ମେତାଦ୍‌କଆ, ");
INSERT INTO unx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ଜୁ, ସେନଃପେ, ଆଡଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ନେ ନାୱା ଜୀଦାନ୍‌ ବିଷାଏରେ କାଜିୟାକପେ ।” ");
INSERT INTO unx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ପ୍ରେରିତ୍‌କ ଏନ୍‌ ଦୁଁତ୍‌ଆଃ କାଜି ମାନାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ସେତାଃ ଇଦାନ୍‌ରେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃତେ ବଲକେଦ୍‌ତେ ହଡ଼କକେ ଇତୁ ଏଟେଦ୍‌କେଦ୍‌କଆକ । ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଆଡଃ ଇନିୟାଃ ଦେଙ୍ଗାତାନ୍‌କ ହିଜୁଃକେଦ୍‌ତେ, ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ ଆଡଃ ଇସ୍ରାଏଲ୍‌ ହନ୍‌କଆଃ ସବେନ୍‌ ପ୍ରାଚୀନ୍‌କକେ କେଡ଼ା ହୁଣ୍ଡିକେଦ୍‍କଆକ ଆଡଃ ପ୍ରେରିତ୍‌କକେ ଆଉକ ନାଗେନ୍ତେ ହଡ଼କକେ ଜେହେଲ୍‌ତେ କୁଲ୍‌କେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ମେନ୍‌ଦ ସିପାଇକ ଥାନାତେ ସେଟେର୍‌ୟାନ୍‌ଚି ପ୍ରେରିତ୍‌କକେ ଏନ୍ତାଃରେ କାକ ନାମ୍‌କେଦ୍‌କଆ, ଏନ୍ତେ ଇନ୍‌କୁ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ତେ ହିଜୁଃରୁହାଡ଼୍‌କେଦ୍‌ତେ ଉଦୁବାଦ୍‌କଆକ, ");
INSERT INTO unx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ଆଲେ ଜେହେଲ୍‌ତେ ସେଟେର୍‌ୟାନ୍‌ଚି ଦୁଆର୍‌ ବୁଗିଲେକା ହାଣ୍ଡେଦାକାନ୍‌ ଆଡଃ ଦାରୱାନ୍‌କ ଦୁଆର୍‌ ହେପାଦ୍‌ରେ ହରତାନ୍‌ଲେ ନେଲ୍‌କେଦ୍‌କଆ, ମେନ୍‌ଦ ଦୁଆର୍‌ ନିଜ୍‌କେଦ୍‌ତେ ଭିତାର୍‍ରେ ଜେତାଏକେ କାଲେ ନାମ୍‍କେଦ୍‌କଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ମାନ୍ଦିର୍‌ ଅଡ଼ାଃ ହରକଆଃ ଗମ୍‌କେ ଆଡଃ ମୁଲ୍‌ ଯାଜାକ୍‌ ବାରାନ୍‌କିନ୍‌ ନେ କାଜିକ ଆୟୁମ୍‌କେଦ୍‌ତେ ପ୍ରେରିତ୍‌କଆଃ ଚିକ୍‌ନାଃ ହବାୟାନା ମେନ୍ତେ ଆକ୍‌ଚାକାଅୟାନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ଇମ୍‌ତା ମିଆଁଦ୍‌ ହଡ଼ ହିଜୁଃକେଦ୍‌ତେ ଇନ୍‌କୁକେ ଉଦୁବାଦ୍‌କଆଏ, “ଆୟୁମେପେ, ଆପେ ଥାନାରେ ଦହକାଦ୍‌କ ତାଇକେନ୍‌ ହଡ଼କ, ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ହଡ଼କକେ ଇତୁକତାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ଏନ୍ତେ ଦାରୱାନ୍‌କଆଃ ଗମ୍‌କେ, ଦାରୱାନ୍‌କଲଃ ସେନ୍‌କେଦ୍‌ତେ ପ୍ରେରିତ୍‌କକେ ଆଡଃମିସା ଆଉକେଦ୍‌କଆକ । ମେନ୍‌ଦ ଇନ୍‌କୁକେ ଜାବାର୍‌ଜାସ୍ତିତେ କାକ ଆଉକେଦ୍‌କଆ, ଚିୟାଃଚି ହଡ଼କ ଦିରିତେକ ଚିଦ୍‌ଗିବୁଆ ମେନ୍ତେ ଇନ୍‌କୁ ହଡ଼କକେ ବର ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ଇନ୍‌କୁ ପ୍ରେରିତ୍‌କକେ ଆଉକେଦ୍‌ତେ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ରେ ତିଙ୍ଗୁକେଦ୍‍କଆକ, ଆଡଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଇନ୍‌କୁକେ କୁଲିକେଦ୍‌କଆ, ");
INSERT INTO unx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ଆଲେ ଆପେକେ ନେ ହଡ଼ରାଃ ନୁତୁମ୍‌ତେ ଆଲ୍‌ପେ ଇତୁକଆ ମେନ୍ତେ ପୁରାଃଗିଲେ ଆଚୁକାଦ୍‌ପେ ତାଇକେନା, ମେନ୍‌ଦ ନେଲେପେ ଆପେ ଚିନାଃ ଚିକାକାଦାପେ, ଆପେ ଆପେୟାଃ ଇନିତୁରେ ଯୀରୁଶାଲେମ୍‌ରାଃ ଚାରିୟସାଃରେ ନିତିର୍‌କାଦାପେ ଆଡଃ ଏନ୍‌ ହଡ଼ରାଃ ମାୟୋମ୍‌ ନାଗେନ୍ତେ ଆପେ ଆଲେକେ ଚିଟା ନାଗେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ପାତ୍‌ରାସ୍‌ ଆଡଃ ଏଟାଃ ପ୍ରେରିତ୍‌କ କାଜିରୁହାଡ଼୍‌କେଦା, “ଆଲେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ମାନାତିଙ୍ଗ୍‌ ଲାଗାତିୟାଁ, ହଡ଼କକେ କାହାଗି । ");
INSERT INTO unx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ଆପେ ୟୀଶୁକେ କ୍ରୁଶ୍‌ରେ କିଲାଗଏଃକିଃ ତାୟମ୍‌ତେ ଆବୁଆଃ ପୁର୍‌ଖାହାଡ଼ାମ୍‌କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ୟୀଶୁକେ ଗନଏଃହେତେ ଜୀଉବିରିଦ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କକେ ହେୟାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ପାପ୍‌ ଛାମା ନାମେ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଆଗୁଆଇ ଆଡଃ ବାଞ୍ଚାଅନିଃ ଲେକା ଆୟାଃ ଜମ୍‌ତିସାଃରେ ଦହକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ଆଲେ ନେ ସବେନ୍‌ କାଜିକରାଃ ଗାୱାକ ତାନ୍‍ଲେ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌, ଆୟାଃ ମାନାତିଙ୍ଗ୍‌ତାନ୍‌ ହଡ଼କକେ ଏମାକାଦ୍‌କ ପାବିତାର୍‌ ଆତ୍ମାହଗି ନେଆଁଁରାଃ ଗାୱାତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ହଡ଼କ ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ଚି ପୁରାଃଗି ଖିସ୍‌ୟାନାକ ଆଡଃ ପ୍ରେରିତ୍‌କକେ ଗଗଏଃ ନାଙ୍ଗ୍‌କ ସାନାଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ମେନ୍‌ଦ ଗମଲିଏଲ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଫାରୁଶୀ, ଇନିଃ ଆଇନ୍‌ ଇତୁନିଃ ଆଡଃ ସବେନ୍‌ ହଡ଼କତାଃଏତେ ମାଇନ୍‌ ନାମେତାନ୍‌ ହଡ଼ ତାଇକେନାଏ । ଇନିଃ ପାଞ୍ଚେଟ୍‌ରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ପ୍ରେରିତ୍‌କକେ କାଟିଃ ଘାଡ଼ିକାଦ୍ ବାହାରିତେ ଅଡଙ୍ଗ୍‌କପେ ମେନ୍ତେ ଆଚୁକେଦ୍‍କଆ । ");
INSERT INTO unx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ କାଜିକେଦ୍‍କଆଏ, “ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କ, ଆପେ ନେ ହଡ଼କକେ ଚିକ୍‌ନାଃ ରିକାନାଙ୍ଗ୍‌ ସେନ୍‌ତାନାପେ ଏନ୍‌ ବିଷାଏରେ ଚିର୍ଗାଲାକାନ୍‍ପେ । ");
INSERT INTO unx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ଚିୟାଃଚି ଚିମିନ୍‌ ମାହାଁଁ ସିଦାରେ ଥିଉଦା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ଆଇଙ୍ଗ୍‌ ମାରାଙ୍ଗ୍‌ ହଡ଼ ତାନିଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିକେଦା, ଏନ୍ତେ ଇନିଃଲଃ ଉପୁନ୍‌ଶାଅ ଲେକା ହଡ଼କ ମେସାୟାନା । ମେନ୍‌ଦ ଇନିଃ ଗଏଃୟାନ୍ତେ, ଇନିଃକେ ଅତଙ୍ଗ୍‌ଇଁତାନ୍‌ ସବେନ୍‌କ ଛିତିବିତିୟାନାକ ଆଡଃ ଆୟାଃ ଝୁଣ୍ଡ୍‌ ଜିୟନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ଇନିୟାଃ ତାୟମ୍‌ତେ, ଗାଲିଲ୍‌ରେନ୍ ଯିହୁଦା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼, ନୁତୁମ୍‌ ଅଲ୍‌ ଦିପିଲିରେ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ପୁରାଃ ହଡ଼କ ଇନିଃକେ ଅତଙ୍ଗ୍‌କିୟାକ ମେନ୍‌ଦ ଇନିଃକେହଁ ଗଏଃକିୟାକ, ଏନ୍ତେ ଇନିଃକେ ଅତଙ୍ଗ୍‌ଇଁତାନ୍‌ ସବେନ୍‌କ ଛିତିବିତିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ଆଡଃ ନାଆଃଦଇଙ୍ଗ୍‌ କାଜିୟାପେତାନା, ନେ ହଡ଼କକେ ଜେତ୍‌ନାଃ କା ରିକାକେଦ୍‌ତେ ବାଗିତାକୁପେ ଆଡଃ ଇନ୍‌କୁକେ ସେନ୍‌ ଇଚିକୁପେ ଚିୟାଃଚି ଇନ୍‌କୁଆଃ କାମି ଚାଏ ଉଦ୍ଦେଶ୍‌ ହଡ଼କଆଃ ସାଃଏତେ ତାନାଃରେଦ ଏନା ଜିୟନଃଆ । ");
INSERT INTO unx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ମେନ୍‌ଦ ଏନା ପାର୍‌ମେଶ୍ୱାର୍‌ ସାଃଏତେ ହବାଅଃତାନ୍‌ରେଦ, ଆପେ ଇନ୍‌କୁକେ କାପେ ହାରାଅ ଦାଡ଼ିୟା, କା'ରେଦ ଆପେ ପାର୍‌ମେଶ୍ୱାର୍‌ଲଃ ଲାଡ଼ାଇତାନ୍‌ ଲେକାପେ ଆଟ୍‌କାରଃଆ ।” ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ହଡ଼କ ଗମଲିଏଲ୍‌ଆଃ ଆନାଚୁକ ଆୟୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ଇନ୍‌କୁ ପ୍ରେରିତ୍‌କକେ ହାକାଅକେଦ୍‌ତେ କୋର୍‌ଡାତେ ହାଁଣ୍‌ସାକୁତାନ୍‌ଲଃ ୟୀଶୁଆଃ ନୁତୁମ୍‌ତେ ଆଲ୍‌ପେ କାଜିୟା ମେନ୍ତେ ଆଚୁକେଦ୍‌କଆକ ଆଡଃ ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ଏନ୍ତେ ପାର୍‌ମେଶ୍ୱାରାଃ ନେପେଲ୍‌ରେ ଇନ୍‌କୁ ୟୀଶୁଆଃ ନୁତୁମ୍‌ ନାଗେନ୍ତେ ହିଲାଙ୍ଗ୍‌ଅଃଲେକାକ ଆଟ୍‌କାର୍‍ୟାନା ମେନ୍ତେ ରାସ୍‍କାଅଃତାନ୍‍ଲଃ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ଏତେ ସେନଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ଆଡଃ ଇନ୍‌କୁ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଆଡଃ ହଡ଼କଆଃ ଅଡ଼ାଃରେ ୟୀଶୁ, ମାସି ତାନିଃ ମେନ୍ତେ ଇତୁତାନ୍‌ଲଃ ନେ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଙ୍ଗ୍‌ କାକ ବାଗିକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ଚିମିନ୍‌ ମାହାଁ ତାୟମ୍‌ତେ ଚେଲାକ ପୁରାଃ ପସାଅଃତାଇକେନ୍‌ରେ ଗ୍ରୀକ୍‌ ଜାଗାର୍‌ତାନ୍‌ ଯିହୁଦୀକ, ଏବ୍ରୀ ଜାଗାର୍‌ତାନ୍‌ ଯୀହୁଦିକଲଃ ଏପ୍‌ରାଙ୍ଗ୍‌ୟାନାକ, ଚିୟାଃଚି ଇନ୍‌କୁ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ରାଃ ଲାଗାତିଙ୍ଗ୍‌ତେୟାଃ ହାଟିଙ୍ଗ୍‌ରେ ରାଣ୍ଡିକୁଡ଼ିକକେ ସୁସାର୍‌ ନାଗେନ୍ତେ କାକ ଧ୍ୟାନ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ଏନାମେନ୍ତେ ଗେଲ୍‌ବାର୍‌ ପ୍ରେରିତ୍‌କ ଆକଆଃ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ସବେନ୍‌ ବିଶ୍ୱାସୀକକେ କେଡ଼ା ହୁଣ୍ଡିକେଦ୍‌ତେ ମେତାଦ୍‌କଆକ, “ଆଲେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ଉଦୁବ୍‌ ବାଗିକେଦ୍‌ତେ, ଇନ୍‌କୁଆଃ ସୁସାର୍‌ରେ ତାଇନାଲେ, ନେଆଁଦ କା ବୁଗିନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ଏନାମେନ୍ତେ ହେ ହାଗା ମିଶିକ, ନେ କାମିରାଃ ବାହାରମ୍‌ ଏମାକ ନାଗେନ୍ତେ ଆପେୟାଃ ଥାଲାଏତେ ପାବିତାର୍‌ ଆତ୍ମା ଆଡଃ ସେଣାଁଁତେ ପେରେଜାକାନ୍‌ ଏୟାଝାନ୍‌ ମାଇନାନ୍‌ ହଡ଼କକେ ସାଲାକୁପେ । ");
INSERT INTO unx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ଏନ୍ତେ ଆଲେ ବିନ୍ତି ଆଡଃ ସେୱାକାମିରେ ପୁରା ସାମାଏଲେ ବିତାଅୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ପ୍ରେରିତ୍‌କଆଃ ନେ କାଜିରେ ସବେନ୍‌କ ସୁକୁୟାନାକ ଆଡଃ ଇନ୍‌କୁ ବିଶ୍ୱାସ୍‌ ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଜାକାନ୍‌ ସ୍ତିଫାନ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼, ଆଡଃ ଫିଲିପ୍‌, ପ୍ରଖର୍‌, ନିକନାର୍‌, ତିମୋନ୍‌, ପାର୍ମିନା, ଆନ୍ତିୟୋଖ୍‌ରେନ୍ ସାଅଁସାର୍‌ ହଡ଼ ନିକଲାସ୍‌ ଅକଏଚି ତାୟମ୍‌ତେ ଯିହୁଦୀ ଧାରାମ୍‌ରେ ମେସାୟାନା, ନେ ସବେନ୍‌କକେ ସାଲାକେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ଇନ୍‌କୁକେ ପ୍ରେରିତ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେକ ତିଙ୍ଗୁକେଦ୍‍କଆ ଆଡଃ ଇନ୍‌କୁଆଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହକେଦ୍‌ତେ ବିନ୍ତିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ନେ ଲେକାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ପାସ୍‍ରାଅଇଦିୟାନା ଆଡଃ ଯୀରୁଶାଲେମ୍‌ରେ ଜାଲ୍‌ଦିଗି ଚେଲାକଆଃ ଲେକାରେ ପୁରାଃ ଆଦ୍‍କାଇଦିୟାନା ଆଡଃ ଯାଜାକ୍‌ କଏତେ ପୁରାଃ ହଡ଼କ, ଏନ୍‌ ବିଶ୍ୱାସ୍‌କ ମାନାତିଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ପୁରାଃ ଆଶିଷ୍‌ ନାମ୍‌କେଦ୍‌ତେ ସ୍ତିଫାନ୍‌ ପେଡ଼େଃତେ ପେରେଃୟାନାଏ ଆଡଃ ହଡ଼କଆଃ ଥାଲାରେ ପୁରାଃ ପେଡ଼େୟାନ୍‌ କାମି ଆଡଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ରିକାତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ମେନ୍‌ଦ କୁରିନି ଆଡଃ ଆଲେକ୍‌ଜାଣ୍ଡ୍ରିଆ ନାଗାର୍‌ରେ ଦାସିୟେତେ ରାଡ଼ାକାନ୍‌ ଯୀହୁଦିକକେ ଇଦିକେଦ୍‌ତେ ବାଇୟାକାନ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃରେନ୍‌ ଚିମିନ୍‌ ହଡ଼କ ସ୍ତିଫାନ୍‌ଆଃ ବିରୁଧ୍‌ରେ କାଜିକେଦାକ । ଇନ୍‌କୁ ଆଡଃ କିଲିକିଆରେନ୍‌, ଆଡଃ ଏସିଆରେନ୍‍ ଚିମିନ୍‌ ଯିହୁଦୀକ ବିରିଦ୍‌କେଦ୍‌ତେ ସ୍ତିଫାନ୍‌ଲଃ ଏପେରାଙ୍ଗ୍‌ ଏଟେଦ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ମେନ୍‌ଦ ପାବିତାର୍‌ ଆତ୍ମା ସ୍ତିଫାନ୍‌କେ ଏମାକାଇ ସେଣାଁଁତେ କାଜିକତାନ୍‌ ତାଇକେନାଏ, ଏନାମେନ୍ତେ ଇନ୍‌କୁ ଇନିୟାଃ ବିରୁଧ୍‌ରେ ଜେତ୍‌ନାଃ କାକ କାଜି ଦାଡ଼ିୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ଏନ୍ତେ “ଆଲେ ସ୍ତିଫାନ୍‌କେ ମୁଶା ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବିରୁଧ୍‌ରେ ନିନ୍ଦା କାଜିତାନ୍‍ଲେ ଆୟୁମ୍‍କିୟା” ନେଆଁଁ କାଜିପେ ମେନ୍ତେ ଇନ୍‌କୁ ଚିମିନ୍‌ ହଡ଼କକେ ଟାକା ପାଏସା ଏମ୍‌କେଦ୍‌ତେ ଉସ୍‍କୁର୍‍କେଦ୍‍କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ନେ'ଲେକାତେ ଇନ୍‌କୁ ହଡ଼କକେ, ପ୍ରାଚିନ୍‌କକେ, ଆଡଃ ଆଇନ୍‌ ଇତୁକକେ ଉସ୍‍କୁର୍‍କେଦ୍‌ତେ ଇନିଃକେ ସାବ୍‌କିୟାକ ଆଡଃ ପାଞ୍ଚେଟ୍‌ତେକ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ଏନ୍ତେ ଇନ୍‌କୁ ଇନିୟାଃ ବିରୁଧ୍‌ରେ ଚିମିନ୍‌ ହସଡ଼ ଗାୱାକକେ ତିଙ୍ଗୁକେଦ୍‍କଆକ, ଅକନ୍‌କଚି, “ନେ ହଡ଼ ସବେନ୍‌ ଇମ୍‌ତା ଆବୁଆଃ ପାବିତାର୍‌ ମାନ୍ଦିର୍‌ ଆଡଃ ମୁଶାରାଃ ଆନ୍‌ଚୁ ବିରୁଧ୍‌ରେ ହିଲାଙ୍ଗ୍‌କାଜି କାଜି ନାଗେନ୍ତେ କାଏ ବାଗିତାନା” ମେନ୍ତେ କାଜିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ଚିୟାଃଚି ଆଲେ, ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁକେ ନେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃକେ ଜିୟନେଆ ଆଡଃ ମୁଶା ଏମାକାଦ୍‌ବୁ ରିତିରିୱାଜ୍‌କେ ବାଦ୍‍ଲାଅୟାଏ ମେନ୍ତେ ନେ ହଡ଼କେ କାଜିତାନ୍‍ଲେ ଆୟୁମ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ଇମ୍‌ତା ପାଞ୍ଚେଟ୍‌ରେ ଦୁବାକାନ୍‌ ସବେନ୍‌ ହଡ଼କ ଇନିଃକେ ମିଦ୍‌ଢିଟ୍‌ରେ ନେଲ୍‍କିୟାକ ଆଡଃ ଇନିୟାଃ ମେଦ୍‌ମୁହାଁଡ଼୍‌ ଦୁଁତ୍‌ଆଃ ମେଦ୍‍ମୁହାଁଡ଼୍‌ ଲେକାକ ନେଲ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ଏନ୍ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ସ୍ତିଫାନ୍‌କେ କୁଲିକିୟାଏ, “ଚିୟାଃ ନେ କାଜିକ ସାର୍‌ତି କାଜିତାନାଃଚି ?” ");
INSERT INTO unx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ସ୍ତିଫାନ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେ ହାଗାକ ଆଡଃ ଆପୁକ ଆୟୁମେପେ ! ଆବୁଆଃ ପୁର୍‌ଖା ଆପୁ ଆବ୍ରାହାମ୍‌ ହାରାନ୍‌ ସାହାର୍‌ରେ ତାଇନଃ ସିଦାରେ, ମାନାରାଙ୍ଗ୍‌ରେନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ ମେସପଟାମିଆରେ ଇନିଃକେ ଦାର୍‌ଶାନ୍‌ ଏମ୍‌କିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ଆଡଃ ଇନିଃକେ କାଜିକିୟାଏ, ‘ଆମାଃ ଅଡ଼ାଃରେନ୍‌କକେ ଆଡଃ ଦିଶୁମ୍‌କେ ବାଗିକେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଉଦୁବାମେ ଦିଶୁମ୍‌ତେ ସେନଃମେ ।’ ");
INSERT INTO unx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ଏନ୍ତେ ଇନିଃ ଆୟାଃ ଦିଶୁମ୍‌ କଲ୍‌ଦିୟଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ହାରାନ୍‌ ଦିଶୁମ୍‌ରେ ତାଇନଃ ନାଗେନ୍ତେ ସେନଃୟାନା, ଆଡଃ ଆବ୍ରାହାମ୍‌ଆଃ ଆପୁତେ ଗଏଃୟାନ୍‍ଚି ନାହାଁଃ ଆପେ ଅକନ୍‌ ଦିଶୁମ୍‌ରେ ତାଇନଃତାନାପେ, ଏନ୍‌ ଦିଶୁମ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଆଉକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ଇମ୍‌ତା ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବ୍ରାହାମ୍‌କେ ଏନ୍‌ ଦିଶୁମ୍‌ରେ ଜେତାନ୍ ହାନାଟିଙ୍ଗ୍‌ କାଏ ଏମ୍‌କିୟା, ଅତେରାଃ ମିଦ୍‍ଚାଣ୍ଡାଙ୍ଗ୍‌ହଁ କାଏ ଏମ୍‌କିୟା, ମେନ୍‌ଦ ଇନିୟାଃ ହନ୍‌ଗାଁଣା କାକ ତାଇକେନ୍‌ରେୟ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଆଡଃ ଆୟାଃ ହିଜୁଃତାନ୍‌ ପିଢ଼ିରେନ୍‌କକେ ଏନ୍‌ ଦିଶୁମ୍‌କେ ଆକ୍‌ତେୟାର୍‌ରେ ନାଙ୍ଗ୍‌ ଏମାପେୟାଇଙ୍ଗ୍‌ ମେନ୍ତେ ବାନାର୍‌ସା ଏମାକାଦ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ପାର୍‌ମେଶ୍ୱାର୍‌ ନେ'ଲେକାଏ କାଜିକାଇ ତାଇକେନା, ‘ଆମାଃ ହନ୍‍ଗାଁଣାକ ଦାସିୟଃଆ ଆଡଃ ଏଟାଃ ଦିଶୁମ୍‌ରେକ ତାଇନା ଏନ୍ତେ ଉପୁନ୍‌ ଶାଅ ସିର୍ମା ପୁରାଃଗିକ ସିଗିଦଃଆ । ");
INSERT INTO unx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ମେନ୍‌ଦ ଇନ୍‌କୁ ଅକ ହଡ଼କଆଃ ସେୱା ରିକାକଆକ, ଆଇଙ୍ଗ୍‌ ଏନ୍‌ ହଡ଼କଆଃ ବିଚାର୍‌ ରିକାଏୟାଇଙ୍ଗ୍‌, ଏନ୍‌ତାୟମ୍‌ତେ ଆପେୟାଃ କିଲିକ ଏନ୍‌ ଦିଶୁମ୍‌ଏତେକ ଅଡଙ୍ଗ୍‌ଆଁ ଆଡଃ ନେ ଠାୟାଦ୍‌ରେ ଆଇଁୟାଃ ସେୱା ରିକାଏୟାକ ।’ ମେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ କାଜିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ଏନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌, ଆବ୍ରାହାମ୍‌ଲଃ ମିଆଁଦ୍‌ ରାଜିନାମାରେୟାଃ ଚିହ୍ନାଁ ଲେକା ଖାତ୍‍ନାଅରେୟାଃ ଆନ୍‌ଚୁ ତଲ୍‌କେଦା । ଏନାତେ ଆବ୍ରାହାମ୍‌, ଆୟାଃ ହନ୍‌ ଇସାକ୍‌ଆଃ ଜାନାମ୍‌ରେୟାଃ ମିଦ୍‌ ହାପ୍ତା ତାୟମ୍‌ତେ ଆବ୍ରାହାମ୍‌ ଇନିଃକେ ଖାତ୍‌ନାଅକିୟାଏ, ଇସାକ୍‌ ଆୟାଃ ହନ୍‌ ଯାକୁବ୍‌କେ ଆଡଃ ଯାକୁବ୍‌ ଆୟାଃ ଗେଲ୍‌ବାର୍‌ ହନ୍‌କକେ ଖାତ୍‌ନାଅକେଦ୍‌କଆ, ଅକନ୍‌କଚି ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ଯାକୁବ୍‌ଆଃ ହନ୍‌କ ଆକଆଃ ହାଗା ଯୋଷେଫ୍‌କେ ହିସ୍‌ଙ୍ଗାକିୟାକ ଆଡଃ ଇନିଃକେ ମିସାର୍‌ ଦିଶୁମ୍‌ତେ ଦାସିୟଃ ନାଗେନ୍ତେ ଆଖ୍‌ରିଙ୍ଗ୍‌କିୟାକ । ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃଲଃ ତାଇକେନା, ");
INSERT INTO unx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ଆଡଃ ସବେନ୍‌ ଦୁକୁ ହାସୁଏତେ ଇନିଃକେ ସୁତୁଃ ଆଉକିୟାଏ । ଚିମ୍‌ତା ଯୋଷେଫ୍‌ ମିସାର୍‌ ଦିଶୁମ୍‌ରେନ୍‌ ଫାରୋ ରାଜାରାଃ ହେପାଦ୍‌ତେ ହିଜୁଃୟାନା, ଇମ୍‌ତା ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ସୁକୁଆନ୍‌ ଚାଇଲ୍‌ ଚାଲାନ୍‌ ଆଡଃ ସେଣାଁଁ ଏମ୍‌କିୟାଏ, ଆଡଃ ରାଜା, ଯୋଷେଫ୍‌କେ ମିସାର୍‌ ଦିଶୁମ୍‌ରେୟାଃ ଚାଲାଅନିଃ ଆଡଃ ସବେନ୍‌ ଅଡ଼ାଃରେନ୍‌ ହାକିମ୍‌ ଲେକାଏ ବାଇକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ଏନ୍ତେ ଗଟା ମିସାର୍‌ ଆଡଃ କିନାନ୍‌ ଦିଶୁମ୍‌ରେ ରିଙ୍ଗାୟାନ୍‌ତେ ହଡ଼କ ପୁରାଃ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌କେଦାକ । ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କ ଜେତାନ୍‌ ଜମେୟାଁଃ କାକ ନାମ୍‌ ଦାଡ଼ିକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ମେନ୍‌ଦ ଯାକୁବ୍‌ ମିସାର୍‍ରେ ଜମେୟାଁଃ ନାମଃତାନା ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ତେ, ଆୟାଃ ହନ୍‌କ, ଅକନ୍‌କଚି ଆବୁଆଃ ପୁର୍‌ଖାହାଡ଼ାମ୍‌ ହଡ଼କ ତାନ୍‌କ, ଇନ୍‌କୁକେ ପାହିଲାତେ ମିସାର୍‌ ଦିଶୁମ୍‌ତେ କୁଲ୍‍କେଦ୍‍କଆ । ");
INSERT INTO unx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ମିସାର୍‌ତେ ଇନ୍‌କୁ ବାର୍‌ସାତେ ସେନ୍‌କେନାକ ଇମ୍‌ତା ଯୋଷେଫ୍‌ ଆୟାଃ ହାଗାକତାଃରେ ନେପେଲ୍‌ ଉପୁରୁମ୍‌ୟାନା ଆଡଃ ମିସାର୍‌ରେନ୍‌ ରାଜା ଫାରୋ ଯୋଷେଫ୍‌ଆଃ ଅଡ଼ାଃରେନ୍‌କଆଃ ବିଷାଏରେ ସାରିୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ଏନ୍ତେ ଯୋଷେଫ୍‌ ଆୟାଃ ଆପୁ ଯାକୁବ୍‌ ଆଡଃ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌କକେ ମିସାର୍‌ତେ କେଡ଼ାକେଦ୍‍କଆ, ଇନ୍‌କୁ ଆପିହିସି ଗେଲ୍‌ମଣେୟାଁ ହଡ଼କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ଏନ୍ତେ ଯାକୁବ୍‌ ମିସାର୍‌ତେ ସେନଃୟାନା, ଏନ୍ତାଃରେ ଆଇଃକ୍‌ ଆଡଃ ଆୟାଃ ହନ୍‌କ ଗଏଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ଇନ୍‌କୁଆଃ ଗଏଃ ହଡ଼୍‌ମକେ ଶିଖିମ୍‌ତେକ ଇଦିକେଦା ଆଡଃ ଆବ୍ରାହାମ୍‌, ହାମର୍‌ ହଡ଼କତାଃଏତେ କିରିଙ୍ଗ୍‌କାଦ୍‌ ତପାଗାଡ଼ାରେ ଇନ୍‌କୁକେ ତପାକେଦ୍‍କଆ । ");
INSERT INTO unx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବ୍ରାହାମ୍‌କେ ଅକନ୍‌ ବାନାର୍‌ସା ଏମାକାଇ ତାଇକେନାଏ, ଏନା ପୁରାଅଃରେୟାଃ ଦିପିଲି ନାଡ଼େଃୟାନ୍‌ଚି ଆବୁଆଃ ହଡ଼କ ମିସାର୍‌ ଦିଶୁମ୍‌ରେ ପୁରାଃଗିକ ପସାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ଟୁଣ୍ଡୁରେ ଯୋଷେଫ୍‌ ବିଷାଏରେ କାଏ ସାରିତାନ୍‌ ମିଆଁଦ୍‌ ରାଜା ମିସାର୍‌ ଦିଶୁମ୍‌ରେ ରାଇଜ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ଇନିଃ ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କକେ ପୁରାଃଗି ସାସାତିକେଦ୍‌ତେ ସିଗିଦ୍‌କେଦ୍‌କଆ ଆଡଃ ଇନ୍‌କୁଆଃ ବାଲେଃହନ୍‌କ ଆଲକାକ ଜୀହୁଦଃକା ମେନ୍ତେ ଇନ୍‌କୁକେ ଏଣ୍ଡାଃରିକାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ଏନ୍‌ ଦିପିଲିରେ ମୁଶା ଜାନାମ୍‌ୟାନାଏ, ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ନେପେଲ୍‌ରେ ପୁରାଃ ସୁଗାଡ଼ାନ୍‌ଗି ତାଇକେନା । ଇନିଃ ଆପି ମାହିଁନା ଆପୁତେୟାଃ ଅଡ଼ାଃରେ ଆସୁଲ୍‍ୟାନା, ");
INSERT INTO unx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ଆଡଃ ଏନ୍‌ ହନ୍‌କେ ଅଡ଼ାଃଏତେ ବାହାରିରେକ ଦହକିୟା ଇମ୍‌ତା, ଫାରୋରାଃ ହନ୍ତେକୁଡ଼ି ଇନିଃକେ ନାମ୍‌କେଦ୍‌ତେ ଆୟାଃ ହନ୍‌ ଲେକାଏ ଆସୁଲ୍‍କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ଆଡଃ ମୁଶା ମିସାର୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କଆଃ ସେଣାଁଁତେ ଇତୁୟାନା ଆଡଃ ଆୟାଃ କାଜି କାମିରେ ପୁରାଃଗି ମାରାଙ୍ଗ୍‌ ହଡ଼ ହବାୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ମୁଶା ବାର୍‌ହିସି ବାରାଷ୍‌ରେନ୍‌ ହବାୟାନାଏ, ଇମ୍‌ତା ଇନିଃ ଆୟାଃ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହାଗାକକେ ମିସାର୍‌ରେନ୍‌ ହଡ଼କ ଚିଲ୍‌କାକ ନେଲ୍‌କତାନା, ଏନା ସାରିନାମ୍‌ ନାଗେନ୍ତେ ମନ୍‌ସୁରୁଦ୍‌ରେ ଉହାଟ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ଇନିଃ ଇନ୍‌କୁଏତେ ମିହୁଡ଼୍‌ନିଃକେ ଅନ୍ୟାୟ ରିକାଇତାନ୍‌ ନେଲ୍‌କିଃତେ ଦେଙ୍ଗାଇ ନାଙ୍ଗ୍‌ ମିସାର୍‌ରେନ୍‌ ହଡ଼କେ ବାଦ୍‌ଲା ଇଦିତାନ୍‌ଲଃ ଇନିଃକେ ଗଏଃକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ଆୟାଃ ହରାତେ ଆୟାଃ ହଡ଼କକେ ବାଞ୍ଚାଅକ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଃକ୍‌କେ ବେଭାରିତାନା, ଏନା ଇନ୍‌କୁ ଆଟ୍‌କାର୍‌ ଉରୁମେକାକ ମେନ୍ତେ ଇନିଃ ଉଡ଼ୁଃକେଦାଏ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଏନା କାକ ଆଟ୍‌କାର୍‌ ଉରୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ଇନିଃ ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ବାର୍‌ହଡ଼୍‌ ଇସ୍ରାଏଲ୍‌ ହଡ଼କିନ୍‌କେ ଲାପ୍‌ଡ଼ାଇତାନ୍ ନେଲ୍‌କେଦ୍‌କିନାଏ, ଆଡଃ ଏନ୍‌ ବାରାନ୍‌କିନ୍‌ ମେସାଅଃକାକିନ୍‌ ମେନ୍ତେ ସାନାଙ୍ଗ୍‌ତାନ୍‌ଲଃ କାଜିକେଦ୍‌କିନାଏ, ‘ଆୟୁମେବେନ୍‌, ଆବେନ୍‌ ବାରାନ୍‌କିନ୍‌ ହାଗାତାନ୍‌ବେନ୍‌ ଚିନାଃମେନ୍ତେବେନ୍‌ ଲାପ୍‌ଡ଼ାଇତାନା ?’ ");
INSERT INTO unx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ମେନ୍‌ଦ ଅକନ୍‌ ହଡ଼ ଏଟାଃ ମିହୁଡ଼୍‌କେ ଅନ୍ୟାୟ ରିକାଇ ତାଇକେନାଏ, ଇନିଃ ମୁଶାକେ ଇଲିଙ୍ଗ୍‌କେଦ୍‌ତେ କୁଲିକିୟା, ‘ଆଲିଙ୍ଗ୍‌ୟାଁଃ ହାକିମ୍‌ ଆଡଃ ବିଚାର୍‌ନିଃ ହବାଅଃ ନାଙ୍ଗ୍‌ ଅକଏ ଆମ୍‌କେ ସାଲାକାଦ୍‌ମେୟାଁ ?’ ");
INSERT INTO unx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘ହଲା ଏନ୍‌ ମିସାର୍‌ରେନ୍‌ ହଡ଼କେମ୍‌ ଗଏଃକିଃ ଲେକା ଆମ୍‌ ଚିନାଃ ଆଇଙ୍ଗ୍‌କେ ଗଗଏଃ ସାନାଙ୍ଗ୍‌ତାନାମ୍‌ ?’ ");
INSERT INTO unx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ମୁଶା ଏନ୍‌ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ, ମିସାର୍‌ ଦିଶୁମ୍‌ଏତେ ନିର୍‌ୟାନା ଆଡଃ ମିଦିୟନ୍‌ ଦିଶୁମ୍‌ରେ ତାଇନ୍‌ୟାନା । ଏନ୍ତାଃରେ ଆୟାଃ ବାରିଆ ହନ୍‌କିନ୍‌ ଜାନାମ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“ବାର୍‍ହିସି ବାରାଷ୍‌ ପୁରାୟାନ୍‌ ତାୟମ୍‌ତେ, ସିନାଇ ବୁରୁ ହେପାଦ୍‌ରେୟାଃ ବିର୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ଚୁପାଦ୍‌ରାଃ ସେଙ୍ଗେଲ୍ ଜୁନୁଲ୍‍ରେ ମୁଶାତାଃରେ ଉଦୁବେନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମୁଶା ଏନା ନେଲ୍‍କେଦ୍‌ତେ ପୁରାଃଗି ହାଏକାଟ୍‍ୟାନା ଆଡଃ ଇନିଃ ବୁଗିଲେକା ନେଲେ ନାଗେନ୍ତେ ଚୁପାଦ୍‌ ନାଡ଼େଃତେ ସେନଃୟାନା । ମେନ୍‌ଦ ଇନିଃ ପ୍ରାଭୁଆଃ ଲାବ୍‌ଜା ଆୟୁମ୍‌କେଦାଏ, ");
INSERT INTO unx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ଆଇଙ୍ଗ୍‌ ଆପେୟାଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌ ଆବ୍ରାହାମ୍‌, ଇସାକ୍‌, ଆଡଃ ଯାକୁବ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ତାନିଙ୍ଗ୍‌ ।’ ମୁଶା ବରତେ ଏକ୍‌ଲାଅୟାନା ଆଡଃ ନେଲ୍‌ ନାଗେନ୍ତେ କାଏ ସାହାସ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ପ୍ରାଭୁ ଇନିଃକେ କାଜିକିୟା, ‘ଖାର୍‌ପାତାମାଃ ହଲେଜେମେ, ଚିୟାଃଚି ଆମ୍‌ ତିଙ୍ଗୁଆକାନ୍‌ ଠାୟାଦ୍ ପାବିତାର୍‌ ଅତେ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ଆଇଙ୍ଗ୍‌ ମିସାର୍‍ରେ ଆଇଁୟାଃ ହଡ଼କଆଃ ସାସାତିକଇଙ୍ଗ୍‌ ନେଲାକାଦା । ଇନ୍‌କୁଆଃ ରାଆଃ ଗେରାଙ୍ଗ୍‌କଇଙ୍ଗ୍‌ ଆୟୁମ୍‌କାଦା ଆଡଃ ଇନ୍‌କୁକେ ତନଲ୍‌ଦାସିଏତେ ରାଡ଼ାକ ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ଆଡ଼୍‌ଗୁଆକାନା । ନାହାଁଃ ହିଜୁଃମେ, ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ମିସାର୍‌ତେଇଙ୍ଗ୍‌ କୁଲ୍‌ମେୟାଁ ।’ ");
INSERT INTO unx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“‘ଅକଏ ଆମ୍‌କେ ଆଲେୟାଃ ହାକିମ୍‌ ଆଡଃ ବିଚାର୍‌ନିଃ ହବାଅଃ ନାଙ୍ଗ୍‌ ସାଲାକାଦ୍‌ମାଏ ?’ ମେନ୍ତେକ କୁଲିକାଇ ଏନ୍‌ ମୁଶାଗି ଇସ୍ରାଏଲ୍‌ ହଡ଼କତାଃଏତେ ହିଲାଙ୍ଗ୍‌କାନ୍‌ ତାଇକେନା । ଇନିଃକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଚୁପାଦ୍‌ରାଃ ସେଙ୍ଗେଲ୍‌ ଜୁନୁଲ୍‌ତେ ଉଦୁବାକାନ୍‌ ଦୁଁତ୍‌ଆଃ ଦେଙ୍ଗାତେ ହଡ଼କଆଃ ହାକିମ୍‌ ଆଡଃ ଇନ୍‌କୁକେ ତନଲ୍‌ଏତେ ରାଡ଼ାକ ନାଗେନ୍ତେ କୁଲ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ଇନିଃ ମିସାର୍‌ରେ ଆଡଃ ସୁଫ୍‌ ଦରେୟାରେ ପୁରାଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ କାମିକେଦ୍‌ତେ ହଡ଼କକେ ମିସାର୍‌ ଦିଶୁମ୍‌ଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌କଆ, ଆଡଃ ବାର୍‌ହିସି ବାରାଷ୍‌ ଜାକେଦ୍‌ ବିର୍‌ରେ ସୁତୁଃ ଆଉକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ମୁଶା ଆଇଃକ୍‌ଗି ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କକେ କାଜିୟାଦ୍‌କଆ, ‘ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିଙ୍ଗ୍‌ ଲେକାଗି, ଆପେତାଃତେ ମିଆଁଦ୍‌ ନାବୀକେ କୁଲିୟା, ଇନିଃ ଆପେୟାଃ ହଡ଼କଏତେ ମିହୁଡ଼୍‌ ହବାଅଃଆଏ ।’ ");
INSERT INTO unx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ଏନ୍‌ ମୁଶାଗି ବିର୍‍ରେ ହୁଣ୍ଡିୟାକାନ୍‌ ଇସ୍ରାଏଲ୍‌ ହଡ଼କଲଃ ତାଇକେନାଏ । ଇନିଃ ସିନାଇ ବୁରୁରେ ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କଲଃ ଆଡଃ ଇନ୍‌କୁଲଃ ଜାଗାର୍‌ତାନ୍‌ ଦୁଁତ୍‌ଲଃ ତାଇକେନାଏ ଆଡଃ ଆବୁତାଃରେ ଉଦୁବେ ନାଗେନ୍ତେ ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃଏତେ ଜୀନିଦ୍‌ ବାଚାନ୍‌ ତେଲାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ମେନ୍‌ଦ ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କ ଇନିଃକେ କାକ ମାନାତିଙ୍ଗ୍‌କେନା, ଇନ୍‌କୁ ଇନିଃକେ ଉଦୁର୍‌ ଗେନାକେଦ୍‌ତେ ମିସାର୍‌ତେ ରୁହାଡ଼୍‌ ନାଗେନ୍ତେକ ମନ୍‌ସୁରୁଦ୍‌ରେ ଉଡ଼ୁଃକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ଏନାମେନ୍ତେ ଇନ୍‌କୁ ହାରୁନ୍‌କେକ କାଜିକିୟା, ‘ନାହାଁଃ ଆଲେକେ ସୁତୁଃ ଇଦି ନାଗେନ୍ତେ ଚିମିନ୍‌ ମାହାପୁରୁକକେ ବାଇକମ୍‌ । ଆଲେକେ ମିସାର୍‌ ଦିଶୁମ୍‌ଏତେ ଅଡଙ୍ଗ୍‌ ଆଉକାଦ୍‌ଲେ ଏନ୍‌ ମୁଶାଦ ଚିନାଃ ଚିକାୟାନାଏ ଏନା କାଲେ ସାରିୟା ।’ ");
INSERT INTO unx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ଏନ୍ତେ ଏନ୍‌ ଦିପିଲିରେ ଇନ୍‌କୁ ମିଆଁଦ୍‌ ଦାମୁର୍‌ହନ୍‌ରାଃ ମୁରୁତ୍‌ ବାଇକିୟାକ ଆଡଃ ଏନ୍‌ ଦାମୁର୍‌ହନ୍‌ ନାଗେନ୍ତେ ଦାଣେଁ ରାକାବ୍‍କେଦାକ । ଏନ୍ତେ ଆକଗି ବାଇୟାକାଦ୍‌ ଏନ୍‌ ମୁରୁତ୍‌ରାଃ ମାଇନଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ଭୋଜି ଜମ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ଏନାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‍କୁତାଃଏତେ ସାଙ୍ଗିନ୍‌ୟାନା ଆଡଃ ଇନ୍‌କୁକେ ସିର୍ମାରେନ୍‌ ଇପିଲ୍‌କକେ ସେୱା ନାଗେନ୍ତେ ବାଗିକେଦ୍‌କଆ । ନେ'ଲେକା ନାବୀକଆଃ ପୁଥିରେ ଅଲାକାନା, “‘ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କ, ଆପେ ବାର୍‍ହିସି ବାରାଷ୍‌ ଜାକେଦ୍‌ ବିର୍‌ରେ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଜାଁତୁକଆଃ ଦାଣେଁ କାପେ ରାକାବ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ମେନ୍‌ଦ ସେୱା ନାଗେନ୍ତେ ଆପେ ଅକନ୍‌ ମୁରୁତ୍‌କେ ବାଇକିୟାପେ, ଆଡଃ ଏନ୍‌ ମାଲେଖ୍‌ ମାହାପୁରୁଆଃ କୁମ୍ବା ଆଡଃ ଇପିଲ୍‌ ମାହାପୁରୁ, ରମ୍ପାରାଃ ମୁରୁତ୍‌କେପେ ଗଅଃକେଦା । ଏନାମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ବାବିଲୋନ୍‌ରେୟାଃ ହାନ୍‌ ପାରମ୍‌ତେଇଙ୍ଗ୍‌ ତଲ୍‌ କୁଲ୍‌ପେୟା ।’ ");
INSERT INTO unx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ବିର୍‌ରେ ଆବୁଆଃ ହାଡ଼ାମ୍‌ ହଡ଼କଲଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ତାଇନଃ କୁମ୍ବା ତାଇକେନା । ପାର୍‌ମେଶ୍ୱାର୍‌, ମୁଶାକେ ବାଇ ନାଗେନ୍ତେ ଆଚୁକାଇ ତାଇକେନ୍‌ ଲେକାଗି ବାଇୟାକାଦ୍‌ ତାଇକେନାଏ ଆଡଃ ମୁଶାକେ ଉଦୁବାକାଇ ନାମୁନା ଲେକାଗି ବାଇୟାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ତାୟମ୍‌ ଦିପିଲିକରେ ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କ ଆକଆଃ ଆପୁକତାଃଏତେ ନାମାକାଦ୍‌, ଏନ୍‌ କୁମ୍ବାକେ ଯିହୋଶୁୟଲଃ ଗଅଃକେଦ୍‌ତେ ସେନ୍‌ ଆୟାର୍‌ୟାନାକ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ତେ ହାରାଅକାନ୍‌ ଏଟାଃ ହଡ଼କଆଃ ଦିଶୁମ୍‌କେକ ଆକ୍‌ତେୟାର୍‌କେଦା । ଆଡଃ ଏନ୍‌ କୁମ୍ବା ଦାଉଦ୍‌ଆଃ ପାରିୟା ଜାକେଦ୍‌ ତାଇନ୍‌କେନା । ");
INSERT INTO unx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ଦାଉଦ୍‌, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନେପେଲ୍‌ରେ ସୁକୁଆନ୍‌ଗି ନେଲଃୟାନା, ଏନ୍ତେ ଇନିଃ ଯାକୁବ୍‌ଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ତାଇନଃ ଠାୟାଦ୍‌ ବାଇ ଇଚିଇଙ୍ଗ୍‌ମେ ମେନ୍ତେ କୁଲିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ମେନ୍‌ଦ ସୁଲିମାନ୍‌ ଇନିୟାଃ ନାଗେନ୍ତେ ମିଆଁଦ୍‌ ଅଡ଼ାଃ ବାଇକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“ମେନ୍‌ଦ ହଡ଼ ବାଇୟାକାଦ୍‌ ଅଡ଼ାଃରେ ସାଲାଙ୍ଗି ଉତାର୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ କାଏ ତାଇନା । ନାବୀ ନେ ଲେକାଏ କାଜିକାଦା, ");
INSERT INTO unx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ପ୍ରାଭୁ କାଜିତାନାଏ, ‘ସିର୍ମା ଆଇଁୟାଃ ରାଜ୍‌ଗାଦି ତାନାଃ, ଆଡଃ ଅତେ ଆଇଁୟାଃ କାଟାରେୟାଃ ଗାଣ୍ଡୁ ତାନାଃ । ଆପେ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଚିଲ୍‌କାନ୍ ଅଡ଼ାଃପେ ବାଇୟା ? ଆଇଁୟାଃ ରୁଡ଼ୁନ୍‌ ନାଗେନ୍ତେ ଠାୟାଦ୍‌ କତାଃରେୟା ? ");
INSERT INTO unx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ନେ ସବେନାଃ ଚିନାଃ ଆଇଙ୍ଗ୍‌ଗି କାଇଙ୍ଗ୍‌ ବାଇୟାକାଦା ?’ ");
INSERT INTO unx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“ସ୍ତିଫାନ୍‌ ଆଡଃଗି କାଜିକେଦା, ଆପେ ଚିମିନ୍‌ଗି କା ମାନାତିଙ୍ଗ୍‌ତାନ୍‌ ହଡ଼କ ତାନ୍‌ପେ ! ଆପେୟାଃ ମନ୍‌ସୁରୁଦ୍‌କ ପୁରାଃଗି ସତ୍‌ରାଗିୟା ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ନାଙ୍ଗ୍‌ ଆପେ ପୁରାଃଗି କା ଆୟୁମ୍‌ ହଡ଼କ ତାନ୍‌ପେ ! ଆପେ ଆପେୟାଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କ ଲେକାଃପେ, ଆପେୟଗି ସବେନ୍‌ ଇମ୍‌ତା ପାବିତାର୍‌ ଆତ୍ମାରାଃ ବିରୁଧ୍‌ରେ କାଜିତାନାପେ । ");
INSERT INTO unx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ଆପେୟାଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କଆଃ ହରାତେ କା ସାସାତିକାନ୍‌ ଜେତା ନାବୀ ମେନାକଆ ଚି ? ଧାର୍‌ମାନ୍ ଦାସିଆଃ ହିନିଜୁଃ ବିଷାଏରେ, ସିଦାରେ ଉଦୁବାକାଦ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜିକୁଲ୍‌କକେ ଆପେୟାଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କ ଗଏଃକେଦ୍‌କଆକ । ଆଡଃ ନାହାଁଃ ଆପେ ଇନିଃକେ ବାଇରିକଆଃ ତିଃଇରେ ଜିମାକେଦ୍‌ତେ ଗଏଃକିୟାପେ । ");
INSERT INTO unx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ଆପେ ଦୁଁତ୍‌କଆଃ ହରାତେ ଏମାକାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଆନ୍‌ଚୁପେ ନାମାକାଦା, ଏନ୍‌ରେୟ ଆପେ ଏନାକେ କାପେ ମାନାତିଙ୍ଗ୍‌କେଦା ।” ");
INSERT INTO unx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ହଡ଼କ ସ୍ତିଫାନ୍‌ଆଃ ନେ କାଜିକ ଆୟୁମ୍‌କେଦ୍‌ତେ ପୁରାଃଗିକ ଖିସ୍‌ୟାନା ଆଡଃ ଆୟାଃ ନାଗେନ୍ତେ ଖିସ୍‌ତେ ଡାଟା ହାବ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ମେନ୍‌ଦ ସ୍ତିଫାନ୍‌ ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଃୟାନ୍‌ଲଃ ସିର୍ମାତେ ଆରିଦ୍‍ରାକାବ୍‍କେଦା ଏନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ଆଡଃ ୟୀଶୁକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଜମ୍‌ତିସାଃରେ ତିଙ୍ଗୁଆକାନାଏ ନେଲ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ଆଡଃ ଇନିଃ କାଜିକେଦାଏ, “ନେଲେପେ, ଆଇଙ୍ଗ୍‌ ସିର୍ମା ନିଜାକାନ୍‌ ଆଡଃ ମାନୱାହନ୍‌କେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଜମ୍‍ତିସାଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ନେଲିତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ହଡ଼କ ପୁରାଃ କାଉରିତାନ୍‌ଲଃ ନେ କାଜି କା ଆୟୁମେ ନାଗେନ୍ତେ ଆକଆଃ ଲୁତୁର୍‌ରେ ତିଃଇ ଦହକେଦାକ । ଏନ୍ତେ ଇନ୍‌କୁ ସବେନ୍‌କ ମିଦ୍‌ୟାନ୍ତେ ଆୟାଃ ହେପାଦ୍‌ତେ ନିର୍‌କେଦାକ, ");
INSERT INTO unx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ଆଡଃ ଇନ୍‌କୁ ସାହାର୍‌ହେତେ ବାହାରି ଥାଇଜ୍‌କେଦ୍‌ତେ ଆୟାଃ ଚେତାନ୍‌ରେ ଦିରି ଚିଦ୍‌ଗିକିୟାକ । ହସଡ଼ ଗାୱା ଏମ୍‌ ହଡ଼କ ଶାଉଲ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସେପେଡ଼େଦ୍‌ଆଃ ଜିମାରେ ଇନ୍‌କୁଆଃ ଲିଜାଃକ ବାଗିକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ଇନ୍‌କୁ ସ୍ତିଫାନ୍‌ଆଃ ଚେତାନ୍‌ରେ ଦିରି ଚିଦ୍‌ଗିକେଦ୍‌ ଇମ୍‌ତା ଇନିଃ ପ୍ରାଭୁକେ ବିନ୍ତିକେଦ୍‌ତେ କାଜିକିୟା, “ହେ ପ୍ରାଭୁ ୟୀଶୁ, ଆଇଁୟାଃ ଆତ୍ମାକେ ତେଲାଏମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ଇନିଃ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ପୁରାଃ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦା, “ହେ ପ୍ରାଭୁ, ଇନ୍‌କୁଆଃ ବିରୁଧ୍‌ରେ ନେ ପାପ୍‌ ଆଲମ୍‌ ପାହେମେୟା ।” ନେୟାଁ କାଜିକେଦ୍‌ତେ ଜୀଉତାୟାଃ ଟୁଣ୍ଡୁକେଦା । ସ୍ତିଫାନ୍‌ଆଃ ଗଗଏଃରେ ଶାଉଲ୍‌ ମିଦ୍‌ମନ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ଶାଉଲ୍‌ ସ୍ତିଫାନ୍‌ଆଃ ଗଗଏଃରେ ମିଦ୍‌ମନ୍‌ୟାନାଏ । ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ତାଃଏତେ ଯୀରୁଶାଲେମ୍‌ରେୟାଃ କାଲିସିୟାକରେ ପୁରାଃଗି ସାସାତିକ ଏନେଟେଦ୍‌ୟାନା । ପ୍ରେରିତ୍‌କକେ ବାଗିକେଦ୍‌ତେ ଏଟାଃ ସବେନ୍‌ ବିଶ୍ୱାସୀକ ଯିହୁଦା ଆଡଃ ଶମିରୋନ୍‌ ପାର୍‌ଗାନ୍‌ରେ ଛିତିବିତିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ଚିମିନ୍‌ ଧାର୍‌ମାନ୍‌ ହଡ଼କ ପୁରାଃ କାଉରିକେଦ୍‌ତେ ଏୟମ୍‌ତାନ୍‌ଲଃ ସ୍ତିଫାନ୍‌ଆଃ ଗଏଃ ହଡ଼୍‌ମକେ ତପାକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ମେନ୍‌ଦ ଶାଉଲ୍‌ କାଲିସିୟାକେ ଜିୟନେ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌କେଦା, ଇନିଃ ଅଡ଼ାଃ ଅଡ଼ାଃ ବଲକେଦ୍‌ତେ ଖ୍ରୀଷ୍ଟ୍‌ ବିଶ୍ୱାସୀ ସବେନ୍‌ କଡ଼ା କୁଡ଼ିକକେ ଥାଇଜ୍‌ ଆଉକେଦ୍‌ତେ ଜେହେଲ୍‌ରେ ଦହକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ଛିତିବିତିୟାକାନ୍‌ ବିଶ୍ୱାସୀକ ଚାରିୟସାଃ ସେନ୍‌କେଦ୍‌ତେ ସୁକୁକାଜି ଉଦୁବ୍‍କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ଫିଲିପ୍‌ ଶମିରୋନ୍‌ରେୟାଃ ମାରାଙ୍ଗ୍‌ ନାଗାର୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ, ଏନ୍ତାଃରେନ୍‌ ହଡ଼କକେ ମାସିଆଃ ସୁକୁକାଜି ଉଦୁବ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ଫିଲିପ୍‌ଆଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଆଡଃ ଆୟାଃ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ନେଲ୍‌କେଦ୍‌ତେ ଗାଦେଲ୍‌ ହଡ଼କ ଆୟାଃ କାଜିରେ ମିଦ୍‌ମନ୍‌ତେକ ଆୟୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ପୁରାଃ ହଡ଼କତାଃଏତେ ସତ୍‌ରା ଆତ୍ମାକ କାଉରିତାନ୍‌ଲଃ ଅଡଙ୍ଗ୍‌ୟାନାକ, ପୁରାଃ ବାତ୍‌କାନ୍‌ ହଡ଼କ ଆଡଃ କାଟା କୁଚୁଙ୍ଗ୍‌କାନ୍‌ ହଡ଼କ ବୁଗିୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ଏନାତେ ଏନ୍‌ ନାଗାର୍‌ରେ ପୁରାଃଗି ରାସ୍‌କା ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ଏନ୍ତାଃରେ ଶିମୋନ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ, ଇନିଃ ଆୟାଃ ଦେଅଁଣା କାମିକେଦ୍‌ତେ ସିଦାଏତେଗି ଶମିରୋନ୍‌ରେନ୍‌ ହଡ଼କକେ ଆକ୍‌ଦାନ୍ଦାଅକାଦ୍‌କ ତାଇକେନାଏ । ଇନିଃ ଆଇଃକ୍‌କେଗି ମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ହଡ଼ ମେନ୍ତେ ଉଦୁବେନ୍‌ ତାଇକେନା, ");
INSERT INTO unx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ଆଡଃ ଏନ୍‌ ନାଗାର୍‌ରେନ୍‌ ସବେନ୍‌କ ଆଡଃ ସାମାଜ୍‌ରେନ୍‌ ସବେନ୍‌ ହୁପ୍‌ଡିଙ୍ଗ୍‌ ମାପ୍‌ରାଙ୍ଗ୍‌କ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଅକନ୍‌ ପେଡ଼େଃକେ ମାରାଙ୍ଗ୍‌ ମେନ୍ତେ କାଜିୟଃତାନା, ଏନା ଇନିଃଗି ତାନିଃ ମେନ୍ତେକ ମାନାତିଙ୍ଗ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ଏନ୍‌ ଦେଅଁଣାରାଃ ପେଡ଼େଃ ହରାତେ ପୁରାଃ ମାହାଁଁଏତେ ଇନିଃ ଶମିରୋନ୍‌ରେନ୍‌ ହଡ଼କକେ ଆକ୍‌ଦାନ୍ଦାଅକାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ମେନ୍‌ଦ ଫିଲିପ୍‌ତାଃଏତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ଆଡଃ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ନୁତୁମ୍‌ରେ ସୁକୁକାଜି ଆୟୁମ୍‌କେଦ୍‌ ହରାତେ ହଡ଼କଆଃ ବିଶ୍ୱାସ୍‌ ହବାୟାନା ଆଡଃ ଏନ୍‌ ପାର୍‌ଗାନ୍‌ରେନ୍ କଡ଼ା କୁଡ଼ି ସବେନ୍‌କ ବାପ୍ତିସ୍ମା ଇଦିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ଶିମୋନ୍‌ ହଗି ଏନ୍‌ କାଜିରେ ବିଶ୍ୱାସ୍‌କେଦା । ଫିଲିପ୍‌ କାମିକାଦ୍‌ ଆକ୍‌ଦାନ୍ଦାଅ କାମି ଆଡଃ ହାଏକାଟ୍‌ କାମିକ ନେଲ୍‌କେଦ୍‌ତେ, ଇନିଃ ବାପ୍ତିସ୍ମା ଇଦିକେଦ୍‌ତେ ଫିଲିପ୍‌ଲଃ ମିସାତେ ତାଇନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ଶମିରୋନ୍‌ରେନ୍‌ ହଡ଼କ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଜିକ ତେଲାକାଦା ମେନ୍ତେ ଯୀରୁଶାଲେମ୍‌ରେନ୍‌ ପ୍ରେରିତ୍‌କ ଆୟୁମ୍‌କେଦ୍‌ତେ, ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌କେ ଇନ୍‌କୁତାଃତେକ କୁଲ୍‌କେଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ଇନ୍‌କିନ୍‌ ଏନ୍ତାଃତେ ସେଟେର୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ ଶମିରୋନ୍‌ରେନ୍‌ ବିଶ୍ୱାସୀକ ପାବିତାର୍‌ ଆତ୍ମା ନାମେକାକ ମେନ୍ତେକିନ୍ ବିନ୍ତିକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ଚିୟାଃଚି ଇମ୍‌ତାଙ୍ଗ୍‌ ଜାକେଦ୍‌ ଇନ୍‌କୁଆଃଏତେ ଜେତାଏୟାଃ ଚେତାନ୍‌ରେ ପାବିତାର୍‌ ଆତ୍ମା କାଏ ଆଡ଼୍‌ଗୁକାନ୍‌ ତାଇକେନା । ଇନ୍‌କୁ ପ୍ରାଭୁ ୟୀଶୁଆଃ ନୁତୁମ୍‌ତେ ଏସ୍‌କାର୍‌ ବାପ୍ତିସ୍ମା ଇଦିକାଦ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ ଇନ୍‌କୁଆଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହକେଦ୍‌ଚି ଇନ୍‌କୁ ପାବିତାର୍‌ ଆତ୍ମାକେ ନାମ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌, ନେ ବାରାନ୍‌ ପ୍ରେରିତ୍‌କିନ୍‌ ବିଶ୍ୱାସୀକଆଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହକେଦ୍‌ତେ ଇନ୍‌କୁକେ ପାବିତାର୍‌ ଆତ୍ମାକିନ୍‌ ଏମାକତାନା, ନେୟାଁ ନେଲ୍‌କେଦ୍‌ତେ ଶିମୋନ୍‌ ଇନ୍‌କିନ୍‌କେ ଟାକା ପାଏସା ଏମ୍‌ତାନ୍‌ଲଃ ମେତାଦ୍‌କିନାଏ, ");
INSERT INTO unx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ଆଇଙ୍ଗ୍‌ ଏଟାଃକଆଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହଲେରେ, ଇନ୍‌କୁ ଜେ'ଲେକା ପାବିତାର୍‌ ଆତ୍ମା ନାମ୍‌ ଦାଡ଼ିୟାକ, ଏନାମେନ୍ତେ ନେ ପେଡ଼େଃ ଆଇଙ୍ଗ୍‌କେହଁ ଏମାଇଙ୍ଗ୍‌ବେନ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ ଇନିଃକେ କାଜିକିୟା, “ଆମାଃ ଟାକା ପାଏସା ଆମାଃଲଃ ଜିୟନଃକା, ଚିୟାଃଚି ଆମ୍‌ ଟାକା ପାଏସାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାର୍‌ଦାନ୍‌ କିରିଙ୍ଗ୍‌ ନାଗେନ୍ତେମ୍‌ ଉଡ଼ୁଃତାନା । ");
INSERT INTO unx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ଆଲେୟାଃ କାମିରେ ଆମାଃ ଜେତାନ୍‌ ହିସା ବାନଆଃ, ଚିୟାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନେପେଲ୍‌ରେ ଆମାଃ ମନ୍‌ସୁରୁଦ୍‌ କା ଠାଉକା । ");
INSERT INTO unx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ଏନାମେନ୍ତେ ଆମାଃ ନେ ଏତ୍‍କାନ୍‌ ଉଡ଼ୁଃ ନାଗେନ୍ତେ ହେୟାତିଙ୍ଗ୍‌ମେ, ନେ'ଲେକା ମନ୍‌ସୁରୁଦ୍‌ରେ ଉଡ଼ୁଃକେଦ୍‌ ନାଗେନ୍ତେ ପ୍ରାଭୁତାଃରେ ବିନ୍ତିମେ, ଇନିଃ ଆମ୍‌କେ ଛାମାମେୟାଁ । ");
INSERT INTO unx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ନେଲ୍‌ମେ ତାନାଇଙ୍ଗ୍‌, ଆମାଃ ମନ୍‌ସୁରୁଦ୍‌ ହିସ୍‌ଙ୍ଗାତେ ପେରେଜାକାନା, ଆମ୍‌ଦ ପାପ୍‌ ତନଲ୍‌ତେମ୍‌ ତଲାକାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌କେ ଶିମୋନ୍‌ ମେତାଦ୍‌କିନାଏ, “ଆବେନ୍‌ କାଜିକାଦ୍‌ତେୟାଃ ଆଇଙ୍ଗ୍‌ରେ ଆଲକା ହବାଅଃକା, ଏନାମେନ୍ତେ ଦାୟାକେଦ୍‌ତେ ଆଇଁୟାଃ ନାଙ୍ଗ୍‌ ପ୍ରାଭୁତାଃରେ ବିନ୍ତିବେନ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ପାତ୍‌ରାସ୍‌ ଆଡଃ ଯୋହାନ୍‌ ଗାୱା ଏମ୍‌କେଦ୍‌ ଆଡଃ ପ୍ରାଭୁଆଃ କାଜି ଉଦୁବ୍‌କେଦ୍‌ ତାୟମ୍‌ତେ, ଇନ୍‌କିନ୍‌ ଯୀରୁଶାଲେମ୍‌ତେକିନ୍‌ ରୁହାଡ଼୍‌ୟାନା । ରୁହାଡ଼୍‌ ହରାରେ ଇନ୍‌କିନ୍‌ ଶମିରୋନି ହଡ଼କ ତାୟୁଃତାନ୍‌ ପୁରାଃ ହାତୁକରେ ସୁକୁକାଜିକିନ୍‌ ଉଦୁବ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ପ୍ରାଭୁଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ଫିଲିପ୍‌କେ କାଜିକିୟା, “ସେକାଡ଼ାକାନ୍‌ମେ, ଆଡଃ ଯୀରୁଶାଲେମ୍‌ଏତେ ଗାଜା ନାଗାର୍‌ତେ ସେନଃତାନ୍‌ ଜମ୍‌ସାଃ ହରାତେ ସେନଃମେ ।” ନାହାଁଃ ଏନ୍‌ ହରା ବାନଆଃ, ଏନା ବିର୍‌ ଲେକା ମେନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ଫିଲିପ୍‌ ସେକାଡ଼୍‌କେଦ୍‌ତେ ସେନଃୟାନା । ଇମ୍‌ତା ଇଥିଓପିଆ ଦିଶୁମ୍‌ରେନ୍‌ କାଣ୍ଡାକି ନୁତୁମ୍‌ ରାନୀଆଃ ଆକ୍‌ତେୟାର୍‌ରେ ତାଇନ୍‌ତାନ୍‌ ସବେନ୍‌ ରାଇଜ୍‌ରେନ୍‌ ଖୁର୍ଜିକରାଃ ଭାଣ୍ଡାରି ତାଇକେନ୍‌ ମିଆଁଦ୍‌ ଚାକୁରା, ପାର୍‌ମେଶ୍ୱାର୍‌କେ ସେୱା ନାଗେନ୍ତେ ଯୀରୁଶାଲେମ୍‌ତେ ସେନାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ଇନିଃ ଆୟାଃ ସାଦମ୍‌ ଗାଡ଼ିରେ ଦୁବ୍‌କେଦ୍‌ତେ ଅଡ଼ାଃତେ ରୁହାଡ଼୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଯିଶାୟ ନାବୀଆଃ ପୁଥି କାଉରିତାନ୍‌ଲଃ ପାଢ଼ାଅତାନାଏ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ପାବିତାର୍‌ ଆତ୍ମା ଫିଲିପ୍‌କେ କାଜିକିୟା, “ଏନ୍‌ ସାଦମ୍‌ ଗାଡ଼ି ହେପାଦ୍‌ତେ ସେନଃମେ ଆଡଃ ଆୟାଃ ନାଡ଼େଃରେ ତାଇନ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ଫିଲିପ୍‌ ନିର୍‌ ନିର୍‌ ସେନ୍‌କେଦ୍‌ତେ ଏନ୍‌ କାମିହଡ଼କେ ଯିଶାୟ ନାବୀଆଃ ପୁଥି କାଉରିତାନ୍‌ଲଃ ପାଢ଼ାଅତେୟାଃ ଆୟୁମ୍‌କିୟାଏ । ଇନିଃ ଏନ୍‌ ଚାକୁରାକେ କୁଲିକିୟା, “ଆମ୍‌ ପାଢ଼ାଅତାନ୍‌ତେୟାଃ ସାରିଉରୁମ୍‌ ଦାଡ଼ିତାନାମ୍‌ ଚି ?” ");
INSERT INTO unx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ଚାକୁରା କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ କାକ ଉଦୁବାଇଙ୍ଗ୍‌ରେଦ ଚିଲ୍‌କାତେଇଙ୍ଗ୍‌ ସାରିଉରୁମ୍‌ ଦାଡ଼ିୟା ?” ଏନ୍ତେ ଇନିଃ ଫିଲିପ୍‌କେ ଆୟାଃଲଃ ସାଦମ୍‌ ଗାଡ଼ିରେ ଦୁବ୍‌ ନାଗେନ୍ତେ ବିନ୍ତିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ଇନିଃ ପାଢ଼ାଅ ତାଇକେନ୍‌ ଧାରାମ୍‌ପୁଥିରେୟାଃ ହିସା ନେୟାଁ ତାଇକେନା, “ଇନିଃ, ମାଆଃଇ ନାଗେନ୍ତେ ଇଦିୟଃତାନ୍ ମିଣ୍ଡିହନ୍‍ ଲେକାଃଏ, ଉବ୍‌ କାଇଁଚିନିୟାଃ ହେପାଦ୍‌ରେ ମିଣ୍ଡିହନ୍‌ କାଏ କାଉରି ଲେକା ଇନିଃ ଜେତ୍‌ନାଃ କାଏ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ଇନିଃକେ ଲାନ୍ଦାକିୟାକ ଆଡଃ ନ୍ୟାୟ ବିଚାର୍‌ କା ନାମ୍‌ୟାନା । ଇନିୟାଃ କିଲିକଆଃ ବିଷାଏରେ ଜେତାଏ କାକ କାଜି ଦାଡ଼ିୟା, ଚିୟାଃଚି ଅତେଦିଶୁମ୍‌ରେ ଆୟାଃ ଜୀଦାନ୍‌ ଟୁଣ୍ଡୁକାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ଚାକୁରା ଫିଲିପ୍‌କେ କୁଲିକିୟା, “ନାବୀ ଅକଏୟାଃ ବିଷାଏରେ କାଜିତାନା, ଆୟାଃ ବିଷାଏରେଗି ଚି ଏଟାଃନିୟାଃ ବିଷାଏରେ, ଏନା ଆଇଙ୍ଗ୍‌କେ ଦାୟାକେଦ୍‌ତେ କାଜିଙ୍ଗ୍‌ମେ ?” ");
INSERT INTO unx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ଏନ୍ତେ ଫିଲିପ୍‌ ଧାରାମ୍‌ପୁଥିରେୟାଃ ନେ ହିସାଏତେ ଏଟେଦ୍‌କେଦ୍‌ତେ ୟୀଶୁଆଃ ବିଷାଏରେ ଅଲାକାନ୍‌ ସବେନ୍‌ ସୁକୁକାଜି ଇନିଃକେ ଉଦୁବ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ଇନ୍‌କୁ ହରାରେ ସେନଃତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ମିଦ୍‌ତାଃରେ ଦାଆଃ ହୁଣ୍ଡିୟାକାନ୍‌ ଠାୟାଦ୍‌ତାଃରେକ ସେଟେର୍‌ୟାନା, ଏନ୍ତେ ଚାକୁରା ଇନିଃକେ କାଜିକିୟା, “ନେତାଃରେ ଦାଆଃ ମେନାଃ, ଆଇଙ୍ଗ୍‌କେ ବାପ୍ତିସ୍ମା ଇଦି ନାଗେନ୍ତେ ଚିନାଃ ଜେତାନ୍‌ ରୋକ୍‌ଟକ୍‌ ମେନାଃ ଚି ?” ");
INSERT INTO unx_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ଫିଲିପ୍‌ କାଜିକିୟାଏ, “ଆମ୍‌ ସବେନ୍‌ ମନ୍‌ସୁରଦ୍‌ତେମ୍‌ ବିଶ୍ୱାସ୍‌ତାନ୍‌ରେଦ ବାପ୍ତିସ୍ମା ଇଦି ଦାଡ଼ିୟାମ୍‌ ।” ଏନ୍ତେ ଇନିଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ ତାନିଃ ଏନା ଆଇଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ତାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ଚାକୁରା, ସାଦମ୍‌ ଗାଡ଼ି ଚାଲାଅତାନ୍‌ ହଡ଼କେ ସାଦମ୍‌ ଗାଡ଼ିକେ ତିଙ୍ଗୁଇମେ ମେନ୍ତେ ଆଚୁକିୟା । ଫିଲିପ୍‌ ଆଡଃ ଚାକୁରା ଦାଆଃ ଭିତାର୍‌ତେକିନ୍‌ ବଲୟାନା ଆଡଃ ଫିଲିପ୍ ଇନିଃକେ ବାପ୍ତିସ୍ମା ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ଇନ୍‌କିନ୍‌ ଦାଆଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ, ପ୍ରାଭୁଆଃ ଆତ୍ମା ଫିଲିପ୍‌କେ ଇଦିକିୟା । ଚାକୁରା ଇନିଃକେ ଆଡଃ କାଏ ନେଲ୍‌ ଦାଡ଼ିକିୟା, ମେନ୍‌ଦ ରାସ୍‍କାତେ ପେରେଃୟାନ୍‌ଲଃ ଆୟାଃ ହରାରେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ଆଡଃ କାଟିଃ ଘାଡ଼ିକାଦ୍‌ ତାୟମ୍‌ତେ ଫିଲିପ୍‌ ଆଇଃକ୍‌ ଆପାନ୍‌କେଗି ଆସ୍‌ଦଦ୍‌ ନୁତୁମ୍‌ ସାହାର୍‌ରେ ନାମ୍‌ୟାନା ଆଡଃ ଇନିଃ ଏନ୍ତାଃଏତେ କାଇସରିୟା ସାହାର୍‌ତେ ସେନଃ ହରାରେୟାଃ ସବେନ୍‌ ନାଗାର୍‌କରେ ସୁକୁକାଜି ଉଦୁବ୍‌ତାନ୍‌ଲଃ କାଇସରିୟାତେ ତେବାଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ଏନ୍‌ ଦିପିଲିକରେ ଶାଉଲ୍‌, ପ୍ରାଭୁଆଃ ଚେଲାକକେ ଗଏଃକଆଇଙ୍ଗ୍‌ ମେନ୍ତେ ବତଙ୍ଗ୍‌କ ତାଇକେନାଏ । ଏନ୍ତେ ଇନିଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ତାଃତେ ସେନଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ଆଡଃ ଦମାସ୍‌କସ୍‌ରେୟାଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ପ୍ରାଭୁକେ ଅତଙ୍ଗ୍‌ତାନ୍‌କକେ ନାମ୍‌କେଦ୍‌ତେ ତଲ୍‌କତାନ୍‌ଲଃ ଯୀରୁଶାଲେମ୍‌ତେ ସାବ୍‌ଆଉକ ନାଗେନ୍ତେ ଏନ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ତାଃଏତେ ଆନାଚୁ ଆଉକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ଶାଉଲ୍‌ ଦମାସ୍‌କସ୍‌ ନାଗାର୍‌ରେୟାଃ ହେପାଦ୍‌ତେ ହିଜୁଃ ସେଟେରଃତାନ୍‌ ଇମ୍‌ତା, ଆଚ୍‌କାତେ ସିର୍ମାଏତେ ମିଆଁଦ୍‌ ମାର୍ସାଲ୍‌ ଆୟାଃ ଚାରିୟସାଃରେ ଜୁଲ୍‌ ବିୟୁର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ଇନିଃ ଅତେରେ ଉୟୁଃୟାନା ଆଡଃ ମିଆଁଦ୍‌ ଲାବ୍‌ଜା ଆଇଃକ୍‌କେ କାଜିତାନ୍‌ ଆୟୁମ୍‌କେଦାଏ, “ହେ ଶାଉଲ୍, ହେ ଶାଉଲ୍‌, ଚିନାଃମେନ୍ତେ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେମ୍‌ ସିଗିଦିଇଙ୍ଗ୍‌ତାନା ?” ");
INSERT INTO unx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ଇନିଃ କାଜିକେଦାଏ, “ହେ ପ୍ରାଭୁ, ଆମ୍‌ ଅକଏ ତାନ୍‌ମେ ?” ଆଡଃଗି ଏନ୍‌ ଲାବ୍‌ଜା ଆୟୁମ୍‌ୟାନା, “ଆମ୍‌ ଅକଏକେମ୍‌ ସିଗିଦିତାନା, ଆଇଙ୍ଗ୍‌ ଏନ୍‌ ୟୀଶୁ ତାନିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ମେନ୍‌ଦ ବିରିଦ୍‌ମେ, ଆଡଃ ନାଗାର୍‌ତେ ସେନଃମେ, ଚିକ୍‌ନାଃ କାମି ରିକା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଏନା ଏନ୍ତାଃରେ ଆମ୍‌କେ କାଜିୟଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ଶାଉଲ୍‌ଲଃ ଗାତିରେ ହରାସେନ୍‌ ତାଇକେନ୍‌ ହଡ଼କ ଆକ୍‌ଚାକାଅକେଦ୍‌ତେ ତିଙ୍ଗୁୟାନାକ, ଇନ୍‌କୁ ଏନ୍‌ ଲାବ୍‌ଜା ଆୟୁମ୍‌କେଦାକ ମେନ୍‌ଦ ଜେତାଏକେ କାକ ନେଲ୍‌ ଦାଡ଼ିକେନା । ");
INSERT INTO unx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ଶାଉଲ୍‌ ଅତେହେତେ ବିରିଦ୍‍ୟାନା ଆଡଃ ନେଲ୍‌କେଦାଏ ମେନ୍‌ଦ ଜେତ୍‌ନାଃ କାଏ ନେଲ୍‌ ଦାଡ଼ିକେନା । ଏନାତେ ଇନ୍‌କୁ ଆୟାଃ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ ଦମାସ୍‌କସ୍‌ ଜାକେଦ୍‌ ସୁତୁଃ ଇଦିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ଆପି ମାହାଁ ଜାକେଦ୍‌ ଇନିଃ କାଏ ନେଲ୍‌ ଦାଡ଼ିତାଇକେନା ଆଡଃ ଏନ୍‌ ଦିପିଲିରେ କାଏ ଜମ୍‍ ନୁଁକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦମାସ୍‌କସ୍‌ରେ ହନାନିୟ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଚେଲା ତାଇକେନାଏ । ଇନିଃ ମିଆଁଦ୍‌ ଦାର୍‌ଶାନ୍‌ ନାମ୍‌କେଦାଏ, ପ୍ରାଭୁ ଇନିଃକେ କାଜିକିୟା, “ହନାନିୟ !” ଇନିଃ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେ ପ୍ରାଭୁ କାଜିମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ପ୍ରାଭୁ ଇନିଃକେ କାଜିକିୟା, “ମାର୍‌ ସେକାଡ଼ଃମେ ଆଡଃ ସିଧା ହରା ସେନ୍‌କେଦ୍‌ତେ ଯିହୁଦାରାଃ ଅଡ଼ାଃତେ ସେନଃମେ । ଏନ୍ତାଃରେ ତାର୍ଷିସ୍‌ ନାଗାର୍‌ତାଃଏତେ ହିଜୁଃକାନ୍‌ ଶାଉଲ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ଦାଣାଁଁଇମେ, ଚିଆଃଚି ଇନିଃ ବିନ୍ତିତାନାଏ, ");
INSERT INTO unx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ଆଡଃ ହନାନିୟ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ହିଜୁଃକେଦ୍‌ତେ ଆୟାଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହଲେରେ ଇନିଃ ଆଡଃମିସା ନେଲ୍‌ ଦାଡ଼ିୟାଏ ମେନ୍ତେ ଦାର୍‌ଶାନ୍‌ ନାମାକାଦ୍‌ ତାଇକେନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ହନାନିୟ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହେ ପ୍ରାଭୁ, ନେ ହଡ଼ ଯୀରୁଶାଲେମ୍‌ରେନ୍‌ ଆମାଃ ପାବିତାର୍‌ ହଡ଼କକେ ପୁରାଃ ବରୱାନ୍‌ ଦୁକୁକଏ ଏମାକାଦ୍‌କଆ, ଏନା ଆଇଙ୍ଗ୍‌ ପୁରାଃ ହଡ଼କତାଃଏତେଇଙ୍ଗ୍‌ ଆୟୁମାକାଦା । ");
INSERT INTO unx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ଆଡଃ ଇନିଃ ମୁଲ୍‌ ଯାଜାକ୍‌କତାଃଏତେ ଆକ୍‌ତେୟାର୍‌ ନାମ୍‌କେଦ୍‌ତେ ଦମାସ୍‌କସ୍‌ରେ ଆମ୍‌କେ ବିନ୍ତିତାନ୍‌ ହଡ଼କକେ ସାବ୍‌କେଦ୍‌ତେ ତଲ୍‌ଇଦି ନାଙ୍ଗ୍‌ ହିଜୁଃକାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ମେନ୍‌ଦ ପ୍ରାଭୁ ଇନିଃକେ କାଜିକିୟା, “ଜୁ ସେନଃମେ, ସାଅଁସାର୍‌ ହଡ଼କକେ, ରାଜା ଆଡଃ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କକେ ଆଇଁୟାଃ ନୁତୁମ୍‌ ଉଦୁବେ ନାଗେନ୍ତେ ଆଡଃ ଆଇଙ୍ଗ୍‌କେ ସେୱା ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇନିଃକେଇଙ୍ଗ୍‌ ସାଲାକାଇଜା । ");
INSERT INTO unx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ଆଇଁୟାଃ ନୁତୁମ୍‌ ନାଗେନ୍ତେ ଇନିଃକେ ଅକ ଦୁକୁକ ସାହାତିଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ଏନା ଆଇଙ୍ଗ୍‌ଗି ଇନିଃକେଇଙ୍ଗ୍‌ ଉଦୁବାଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ଏନ୍ତେ ହନାନିୟ ସେନଃୟାନାଏ ଆଡଃ ଶାଉଲ୍‌ ତାଇକେନ୍‌ ଅଡ଼ାଃତେ ବଲୟାନ୍‌ଲଃ ଇନିୟାଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହକେଦ୍‌ତେ କାଜିକିୟା, “ହାଗା ଶାଉଲ୍‌, ଆମ୍‌ ନେତାଃତେ ହିଜୁଃ ହରାରେ, ଅକ ପ୍ରାଭୁ ୟୀଶୁ ଆମ୍‌କେ ଦାର୍‌ଶାନ୍‌ ଏମାକାମ୍‌ ତାଇକେନାଏ, ଇନିଃ ଆଇଙ୍ଗ୍‌କେ କୁଲାକାଦିୟାଁ, ଜେ'ଲେକାଚି ଆମ୍‌ ଆଡଃମିସା ନେଲ୍‌ ଦାଡ଼ିୟାମ୍‌ ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମାରେ ପେରେଜଃଆମ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ଇମ୍‍ତାଗି ଶାଉଲ୍‌ଆଃ ମେଦ୍‍ହେତେ, ହାକୁଆଃ କାତି ଲେକା ଚିନାଃ ଉୟୁଃୟାନା ଆଡଃ ଇନିଃ ଆଡଃମିସା ନେଲ୍‍ ଦାଡ଼ିକେଦାଏ । ଇନିଃ ତିଙ୍ଗୁୟାନାଏ ଆଡଃ ବାପ୍ତିସ୍ମା ଇଦିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ଆଡଃ ତାୟମ୍‌ତେ ଜମ୍‌କେଦ୍‌ତେ ପେଡ଼େଃ ନାମ୍‌ରୁହାଡ଼୍‌କେଦାଏ । ଶାଉଲ୍ ଚେଲାକଲଃ ଦମାସ୍‌କସ୍‌ରେ ଚିମିନ୍‌ ଦିନ୍‌ ତାଇନ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ଆଡଃ ଇନିଃ ଇମ୍‌ତାଗି ସାମାଜ୍‌ ଅଡ଼ାଃକରେ, ୟୀଶୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌ତାନିଃ ମେନ୍ତେ ପ୍ରାଚାର୍‌ ଏଟେଦ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ଆୟାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ସବେନ୍‌କ ହାଏକାଟ୍‍ୟାନ୍‌ଲଃ କୁପ୍‌ଲିୟାନାକ, “ଯୀରୁଶାଲେମ୍‌ରେ ୟୀଶୁ ନୁତୁମ୍‌ ହଡ଼ରାଃ ସେୱାତାନ୍‌ ହଡ଼କକେ ଅକ ହଡ଼ ଗଏଃକ ତାଇକେନାଏ, ଇନିଃ ଚିନାଃ ନେ ହଡ଼ ନାହାଁଲିଃ ? ୟୀଶୁ ନୁତୁମ୍‌ରେ ସେୱାତାନ୍‌ ହଡ଼କକେ ତଲ୍‌କେଦ୍‌ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କତାଃତେ ଇଦି ନାଗେନ୍ତେ ଇନିଃ ଚିନାଃ ନେତାଃତେ କାଏ ହିଜୁଃକାନ୍‌ ତାଇକେନା ?” ");
INSERT INTO unx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ମେନ୍‌ଦ ଶାଉଲ୍‌ଆଃ ପ୍ରାଚାର୍‌ ପୁରାଃ ପେଡ଼େୟାନ୍‌ଗି ହବାୟାନା, ଆଡଃ ୟୀଶୁଗି ମାସିତାନିଃ ମେନ୍ତେ ଇନିୟାଃ ସାବୁତ୍‌ ପୁରାଃଗି ପକ୍‌ତାୟାନା ଯେ, ଦମାସ୍‌କସ୍‌ରେନ୍‌ ଯିହୁଦୀ ହଡ଼କ ନେ ବିଷାଏରେ ଇନିଃକେ କାକ କାଜିରୁହାଡ଼୍‌ ଦାଡ଼ିୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ଚିମିନ୍‌ ଦିନ୍ ସେନଃୟାନ୍‍ ତାୟମ୍‌ତେ, ଯିହୁଦୀ ହଡ଼କ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିକେଦ୍‌ତେ ଶାଉଲ୍‌କେ ଗଏଃ ନାଗେନ୍ତେକ ରୋଜୋଟକେଦା, ");
INSERT INTO unx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ମେନ୍‌ଦ ଇନ୍‌କୁଆଃ ରୋଜୋଟ ଶାଉଲ୍‌ ସାରିକେଦାଏ । ଇନିଃକେ ଗଏଃ ନାଗେନ୍ତେ ଇନ୍‌କୁ ନିଦା ସିଙ୍ଗି ନାଗାର୍‌ରେୟାଃ ଦୁଆର୍‌କରେକ ହରକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ମେନ୍‌ଦ ଶାଉଲ୍‌ଆଃ ଚେଲାକ ନୁବାଃ ଇମ୍‌ତା ଶାଉଲ୍‌କେ ମିଆଁଦ୍‌ ଟୁଙ୍କିରେ ଦହକେଦ୍‌ତେ ପାଚ୍‌ରି ହାନ୍‌ପାରମ୍‌ରେକ ଆଡ଼୍‌ଗୁକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ଶାଉଲ୍‌ ଯୀରୁଶାଲେମ୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ଚେଲାକଲଃ ମେସାନ୍‌ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌କେଦା । ମେନ୍‌ଦ ଇନିଃ ମିଆଁଦ୍‌ ଚେଲା ତାନିଃ ମେନ୍ତେ କାକଗି ବିଶ୍ୱାସ୍‌କେଦା ଆଡଃ ସବେନ୍‌କ ଇନିଃକେ ବରଆଇ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ଏନ୍ତେ ବର୍ଣ୍ଣବାସ୍‌ ଇନିଃକେ ପ୍ରେରିତ୍‌ ଚେଲାକତାଃତେ ଇଦିକେଦ୍‌ତେ ଦମାସ୍‌କସ୍‌ ହରାରେ ଶାଉଲ୍‌ ଚିଲ୍‌କା ପ୍ରାଭୁଆଃ ଦାର୍‌ଶାନ୍‌ ନାମାକାଦ୍‌ ତାଇକେନାଏ ଆଡଃ ପ୍ରାଭୁ ଚିଲ୍‌କା ଇନିଃକେ କାଜିକିୟା, ଏନ୍‌ ସବେନାଃ ଇନ୍‌କୁକେ ଉଦୁବାଦ୍‌କଆ । ଦମାସ୍‌କସ୍‌ରେ ୟୀଶୁଆଃ ନୁତୁମ୍‌ତେ ଶାଉଲ୍‌ ଚିଲ୍‌କା ବେଗାର୍‌ ବରତେ ପ୍ରାଚାର୍‌କେଦା, ଏନ୍‌ ସବେନାଃ ଇନ୍‌କୁକେ ବୁଗିଲେକାଏ ଉଦୁବାଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ଏନ୍ତେ ଶାଉଲ୍‌ ପ୍ରେରିତ୍‌ ଚେଲାକଲଃ ତାଇନ୍‌ୟାନାଏ ଆଡଃ ଯୀରୁଶାଲେମ୍‌ରେୟାଃ ଚାରିୟସାଃ ସେନ୍‌କେଦ୍‌ତେ ବେଗାର୍‌ ବରତେ ପ୍ରାଭୁଆଃ ନୁତୁମ୍‌ତେ ପ୍ରାଚାର୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ଇନିଃ ଗ୍ରୀକ୍‌ ଜାଗାର୍‌ତେ ବାଖାଁଣ୍‌ତାନ୍‌ ଯିହୁଦୀ ହଡ଼କଲଃ ବାଖାଁଣ୍‌ ତାଇକେନାଏ ଆଡଃ କାପ୍‌ଜିତାଇକେନାଏ, ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନିଃକେ ଗଏଃ ନାଗେନ୍ତେକ ରୋଜୋଟ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ଖ୍ରୀଷ୍ଟ୍‌ରେ ହାଗାକ ନେ କାଜି ସାରିକେଦ୍‌ତେ, ଶାଉଲ୍‌କେ କାଇସରିୟା ନାଗାର୍‌ତେକ ଇଦିକିୟା ଆଡଃ ଏନ୍ତାଃଏତେ ତାର୍ଷିସ୍‌ ସାହାର୍‌ତେକ କୁଲ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ନେ'ଲେକାତେ ଗଟା ଯିହୁଦା ପାର୍‌ଗାନ୍‌, ଗାଲିଲ୍‌ ଆଡଃ ଶମିରୋନ୍‌ରେୟାଃ କାଲିସିୟାକରେନ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ବିଶ୍ୱାସୀକ ସୁକୁଜୀଉରେ ତାଇକେନାକ ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମାରେୟାଃ ଦେଙ୍ଗାତେ ପେଡ଼େଃ ନାମ୍‌ତାନ୍‌ଲଃ ପସାଇଦିୟଃ ତାଇକେନାକ ଆଡଃ ପ୍ରାଭୁକେ ବରଭାକ୍ତିତାନ୍‌ଲଃ ଜୀଦାନ୍‌ ବିତାଅ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ପାତ୍‌ରାସ୍‌ ସବେନ୍‍ତାଃ ହରାସେନ୍‌ତାନ୍‌ଲଃ ଲୁଦା ସାହାର୍‌ରେ ତାଇନଃତାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପାବିତାର୍‌ ହଡ଼କତାଃତେ ନେପେଲ୍‌ ନାଗେନ୍ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ଏନ୍ତାଃରେ ପାତ୍‌ରାସ୍‌ ଏନିୟ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ନାମ୍‍କିୟା । ଇନିଃ ବାତ୍‌କାନ୍‌ ହରାତେ ଇରାଲିୟା ବାରାଷ୍‌ ଜାକେଦ୍‌ ପାର୍‌କମ୍‌ହେତେ ବିରିଦ୍‌ କାଏ ଦାଡ଼ିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପାତ୍‌ରାସ୍‌ ଇନିଃକେ କାଜିକିୟା, “ଏନିୟ, ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ ଆମ୍‌କେ ବୁଗିକାଦ୍‌ମେଆ । ବିରିଦ୍‌ମେ ଆଡଃ ପାର୍‌କମ୍‌ତାମାଃ ବିଲାକାଦ୍‌ତେୟାଃ ଉଠାଏମେ ।” ଇମ୍‌ତାଗି ଏନିୟ ବିରିଦ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଲୁଦା ଆଡଃ ଶାରୋନ୍‌ରେ ତାଇନଃତାନ୍‌ ସବେନ୍‌ ହଡ଼କ ଇନିଃକେ ନେଲ୍‌କେଦ୍‌ତେ ପ୍ରାଭୁରେ ବିଶ୍ୱାସ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଯୋପ୍‌ପା ସାହାର୍‌ରେ ଟାବିଥା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ବିଶ୍ୱାସୀ କୁଡ଼ି ତାଇକେନାଏ । ଇନିୟାଃ ଗ୍ରୀକ୍‌ ନୁତୁମ୍‌ ଦର୍କାସ୍‌, ନେଆଁରାଃ ମୁଣ୍ଡି ହବାଅଃତାନା “ମିଆଁଦ୍‌ ମିରିକ୍‌ ।” ଇନିଃ ଆୟାଃ ସବେନ୍‌ ନେଡାରେ ବୁଗିନ୍‌ କାମି କାମିତାଇକେନା ଆଡଃ ଗାରିବ୍‌ ହଡ଼କକେ ଦେଙ୍ଗାକତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ଏନ୍‌ ନେଡାରେ ଇନିଃ ବେମାର୍‌କେଦ୍‌ତେ ଗଏଃୟାନା । ହଡ଼କ ଇନିୟାଃ ହଡ଼୍‌ମକେ ନିୟାଁର୍‌କେଦାକ ଆଡଃ ମାହାଲା ଅଡ଼ାଃରେୟାଃ ଚେତାନ୍‌ କୁଠାରେକ ଦହକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଯୋପ୍‌ପା ସାହାର୍‌ ଲୁଦା ସାହାର୍‌ତାଃଏତେ ଥିମ୍ବା ସାଙ୍ଗିନ୍‌ରେ କା ତାଇକେନା । ପାତ୍‌ରାସ୍‌ ଲୁଦା ସାହାର୍‌ରେ ମେନାଇୟା ମେନ୍ତେ ଯୋପ୍‌ପାରେନ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ବିଶ୍ୱାସୀକ ଆୟୁମ୍‌କେଦ୍‌ଚି, ଇନ୍‌କୁ ବାର୍‌ହଡ଼୍‌କିନ୍‌କେ ଆୟାଃ ହେପାଦ୍‌ କୁଲ୍‌କେଦ୍‌ତେ ନେ'ଲେକା କାଜିଗହାର୍‌କେଦାକ, “ଦାୟାକେଦ୍‌ତେ ଆଲେତାଃତେ ଜାଲ୍‌ଦି ହିଜୁଃମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ପାତ୍‌ରାସ୍‌ ସେକାଡ଼୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଲଃ ସେନଃୟାନାଏ । ଏନ୍ତାଃତେ ସେଟେର୍‌ୟାନ୍‌ଚି ଇମ୍‌ତାଗି ହଡ଼କ ମାହାଲା ଅଡ଼ାଃରେୟାଃ ଚେତାନ୍‌ କୁଠାତେ ଇନିଃକେକ ଇଦିକିୟା । ଏନ୍ତାଃରେ ରାଣ୍ଡିକୁଡ଼ିକ ଇନିଃକେ ଜୁରୁବିୟୁର୍‌କେଦ୍‌ତେ ରାଆଃତାନ୍‌ଲଃ ଦର୍କାସ୍‌ ଜୀନିଦ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ସିଲାଇକାଦ୍‌ ତୁସିଙ୍ଗ୍‌ ଲିଜାଃ ଆଡଃ ଲିଜାଃକ ଇନିଃକେକ ଉଦୁବ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ପାତ୍‌ରାସ୍‌ ସବେନ୍‌କକେ ଏନ୍‌ କୁଠାଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌କଆ ଆଡଃ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ବିନ୍ତିକେଦା, ଏନ୍ତେ ଇନିଃ ଦର୍କାସ୍‌ଆଃ ଗଏଃ ହଡ଼୍‌ମସାଃତେ ହେତାରୁହାଡ଼୍‌କେଦ୍‌ତେ କାଜିକେଦା, “ଟାବିଥା, ବିରିଦ୍‌ମେ ।” ଦର୍କାସ୍‌ ନେଲ୍‌କେଦାଏ ଆଡଃ ପାତ୍‌ରାସ୍‌କେ ନେଲ୍‌କେଦ୍‌ତେ ଦୁବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ପାତ୍‌ରାସ୍‌ ଇନିୟାଃ ତିଃଇକେ ସାବ୍‌କେଦ୍‌ତେ ବିରିଦ୍‌କିୟା । ଏନ୍ତେ ଇନିଃ ହୁଣ୍ଡିୟାକାନ୍‌ ପାବିତାର୍‌ ହଡ଼କକେ ଆଡଃ ରାଣ୍ଡିକୁଡ଼ିକକେ ହାକାଅକେଦ୍‌ତେ ଦର୍କାସ୍‌କେ ଇନ୍‌କୁଆଃ ତିଃଇରେ ଜୀହୁଦ୍‌ଗି ଜିମାକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ନେ କାଜି ଗଟା ଯୋପ୍‌ପା ସାହାର୍‌ରେୟାଃ ଚାରିୟସାଃରେ ଆୟୁମ୍‌ୟାନା ଆଡଃ ପୁରାଃ ହଡ଼କ ପ୍ରାଭୁକେକ ବିଶ୍ୱାସ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ପାତ୍‌ରାସ୍‌ ପୁରାଃ ଦିନ୍‌ ଜାକେଦ୍‌ ଯୋପ୍‌ପାରେ ଶିମୋନ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ମୁଚିଆଃ ଅଡ଼ାଃରେ ତାଇନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାଇସରିୟା ନାଗାର୍‌ରେ କର୍ଣ୍ଣଲିୟ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତାଇକେନାଏ, ଇନିଃ “ଇଟାଲିରେନ୍‌ ପାଲ୍‌ଟାନ୍‌” ନୁତୁମଃତାନ୍‌ ରୋମାନ୍‌ ପାଲ୍‍ଟାନ୍‍କଆଃ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ଇନିଃ ଧାର୍‌ମାନ୍‍ ହଡ଼ ତାଇକେନାଏ । ଇନିଃ ଆଡଃ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌କ ପାର୍‌ମେଶ୍ୱାର୍‌‌କେକ ବର ତାଇକେନା । ଇନିଃ ଗାରିବ୍‌ ଯିହୁଦୀ ହଡ଼କକେ ଦେଙ୍ଗାକତାନ୍‌ ତାଇକେନା ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ସବେନ୍‌ ଇମ୍‌ତାଏ ବିନ୍ତିତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ମୁସିଙ୍ଗ୍‌ ତାର୍‌ସିଙ୍ଗ୍‌ ଆପି ଘାଡ଼ି ହବାଅଃତାଇକେନ୍‌ ଇମ୍‌ତାକରେ ଇନିଃ ମିଆଁଦ୍‌ ଦାର୍‌ଶାନ୍‌ରେ ପୁରା ନେଲ୍‌କେଦା ଯେ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ହିଜୁଃକେଦ୍‌ତେ ଇନିଃକେ ହାକାଅକିୟା, “ଏ କର୍ଣ୍ଣଲିୟ ।” ");
INSERT INTO unx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ଇନିଃ ବରତେ ଦୁଁତ୍‌ସାଃତେ ନେଲ୍‌କେଦା ଆଡଃ କାଜିକିୟାଏ, “ହେ ଗମ୍‌କେ, ଚିନାଃମ୍‌ କାଜିତାନା ?” ଦୁଁତ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ ଆମାଃ ବିନ୍ତି ଆଡଃ ଦାନ୍‌ ଏମଃରେ ସୁକୁଆକାନା ଆଡଃ ଇନିଃ ଆମ୍‌କେ କାଜିରୁହାଡ଼୍‌ ନାଗେନ୍ତେ ସେକାଡ଼ାକାନା । ");
INSERT INTO unx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ନାହାଁଃ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ କେଡ଼ାଆଉ ନାଗେନ୍ତେ ହଡ଼କକେ ଯୋପ୍‌ପାତେ କୁଲ୍‌କମେ । ");
INSERT INTO unx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ପାତ୍‌ରାସ୍‌ ଦରେୟା ଗେନାରେ ତାଇନ୍‌ତାନ୍‌ ଶିମୋନ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ମୁଚିଆଃ ଅଡ଼ାଃରେ ପେଡ଼ାହଡ଼ ଲେକାଏ ତାଇକେନା ।” ");
INSERT INTO unx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ନେଆଁ କାଜିକେଦ୍‌ତେ ଦୁଁତ୍‌ ସେନଃୟାନାଏ । ଏନ୍ତେ କର୍ଣ୍ଣଲିୟ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌ ବାର୍‌ହଡ଼୍‌ ଦାସିକିନ୍‌କେ ଆଡଃ ମିଆଁଦ୍‌ ସିପାଇ, ଅକଏଚି ଧାର୍‌ମାନ୍‌ ହଡ଼ ତାଇକେନାଏ, ଇନିଃକେ କେଡ଼ାଆଉକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ଇନିଃ ଇନ୍‌କୁକେ ସବେନାଃ ଉଦୁବ୍‍କେଦ୍‌ତେ ଯୋପ୍‌ପାତେ କୁଲ୍‍କେଦ୍‍କଆ । ");
INSERT INTO unx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଇନ୍‌କୁ ଯୋପ୍‌ପା ସାହାର୍‌ତେ ସେଟେରଃତାନ୍‌ ଇମ୍‌ତା ପାତ୍‌ରାସ୍‌ ମାହାଲା ଅଡ଼ାଃରେୟାଃ ଚେତାନ୍‌ କୁଠାତେ ବିନ୍ତି ନାଙ୍ଗ୍‌ ସେନ୍‌କେନାଏ । ଇମ୍‌ତାକ ତିକିନ୍‌ସିଙ୍ଗି ହବାଅଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ପାତ୍‌ରାସ୍‌କେ ପୁରାଃଗି ରେଙ୍ଗେଃକିଃ ହରାତେ ଜେତ୍‌ନାଃ ଜମ୍‌ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌କିୟା । ଜମେୟାଃଁ ସେକାଡ଼ଃତାଇକେନ୍‌ ଇମ୍‌ତା ଇନିଃ ମିଆଁଦ୍‌ ଦାର୍‌ଶାନ୍‌ ନାମ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ଇନିଃ ସିର୍ମା ନିଜାକାନ୍‌ ଆଡଃ ଏନାଏତେ ମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ଚାଦାର୍‌ ଲେକା ଉପୁନିୟା କଚାରେ ଡୁଙ୍ଗାକେଦ୍‌ତେ ଅତେ ଚେତାନ୍‌ତେ ଆଡ଼୍‌ଗୁଃତାନାଏ ନେଲ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ଏନାରେ ଚିମିନ୍‌ ରାକାମ୍‌ରେନ୍‌ ଜାଁତୁ, ଅତେରେ ରେଙ୍ଗାଅଃତାନ୍‌ ଜାଁତୁ ଆଡଃ ବିର୍‌ରେନ୍‌ ଅଡ଼େକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ଆଡଃ ଇନିଃ ମିଆଁଦ୍‌ ଲାବ୍‌ଜା ଆୟୁମ୍‌କେଦାଏ, “ଏ ପାତ୍‌ରାସ୍‌, ବିରିଦ୍‌ମେ ଆଡଃ ଗଏଃକେଦ୍‌ତେ ଜମ୍‍କୁମ୍ ।” ");
INSERT INTO unx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ କାଜିକେଦାଏ, “କାହାଗି, ପ୍ରାଭୁ, ଆଇଙ୍ଗ୍‌ ଚିଉଲାଅଗି କା ଫାର୍‌ଚିୟାକାନ୍‌ ଚାଏ ସତ୍‌ରାକାନ୍‌ ଜମେୟାଁଃ କାଇଙ୍ଗ୍‌ ଜମାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ଇନିଃ ଆଡଃମିସା ଏନ୍‌ ଲାବ୍‌ଜା ଆୟୁମ୍‌କେଦାଏ, “ପାର୍‌ମେଶ୍ୱାର୍‌ ଅକ୍‌ନାଃକେ ଫାର୍‌ଚିକାଦା, ଆମ୍‌ ଏନାକେ କା ଫାର୍‌ଚି ମେନ୍ତେ ଆଲମ୍‌ କାଜିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ନେ'ଲେକା ଆପିସାତେ ହବାୟାନ୍‌ ତାୟମ୍‌ତେ, ଚାଦାର୍‌ ଇମ୍‌ତାଗି ସିର୍ମାତେ ରାକାବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପାତ୍‌ରାସ୍‌ ଆୟାଃ ଦାର୍‌ଶାନ୍‌ରେୟାଃ ମୁଣ୍ଡି ଉଡ଼ୁଃକେଦ୍‌ତେ ଆକ୍‌ଦାନ୍ଦାଅଃତାନ୍‌ ଇମ୍‌ତା, କର୍ଣ୍ଣଲିୟ ଅକନ୍‌ ହଡ଼କକେ କୁଲାକାଦ୍‌କ ତାଇକେନା, ଇନ୍‌କୁ ଶିମୋନ୍‌ଆଃ ଅଡ଼ାଃ ନେଲ୍‌ଉରମ୍‌କେଦ୍‌ତେ ଆୟାଃ ଅଡ଼ାଃରାଚାରେୟାଃ ବଲଦୁଆର୍‌ତାଃରେ ତିଙ୍ଗୁକାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ଇନ୍‌କୁ ହାକାଅକେଦ୍‌ତେ କୁଲିକେଦାକ, “ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ପେଡ଼ାହଡ଼ ନେତାଃରେ ମେନାଇୟାଚି ?” ");
INSERT INTO unx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପାତ୍‌ରାସ୍‌ ଇମ୍‌ତାଜାକେଦ୍‌ ଏନ୍‌ ଦାର୍‌ଶାନ୍‌ରେୟାଃ ମୁଣ୍ଡି ଆଟ୍‌କାର୍‌ଉରୁମେ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌ ତାଇକେନା, ଇମ୍‌ତା ଆତ୍ମା କାଜିକିୟାଏ, “ଆୟୁମ୍‌ଲେମ୍‌, ଆମ୍‌କେ ଆପିହଡ଼ ଦାଣାଁମେତାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ଏନାତେ ମାର୍‌ ସେକାଡ଼୍‌କେଦ୍‌ତେ ଲାତାର୍‌ତେ ଆଡ଼୍‌ଗୁନ୍‌ମେ ଆଡଃ ଇନ୍‌କୁଲଃ ସେନ୍‌ ନାଗେନ୍ତେ ଆଲମ୍‌ ହିଚ୍‌କିଚାଃଅଆ, ଚିଆଃଚି ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁକେ କୁଲାକାଦ୍‌କଆଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଲାତାର୍‌ତେ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆ, “ଆପେ ଅକଏକେ ଦାଣାଁତାନାପେ ଇନିଃ ଆଇଙ୍ଗ୍‌ଗି ତାନିଙ୍ଗ୍‌, ଆପେ ଚିନାଃ ମେନ୍ତେପେ ହିଜୁଃକାନା ?” ");
INSERT INTO unx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇ କର୍ଣ୍ଣଲିୟ ଆଲେକେ କୁଲାକାଦ୍‌ଲେୟା । ଇନିଃ ମିହୁଡ଼୍‌ ଧାର୍‌ମାନ୍‌ ହଡ଼ ତାନିଃ । ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରୱାଇ ତାଇକେନା ଆଡଃ ସବେନ୍‌ ଯିହୁଦୀ ହଡ଼କ ଇନିଃକେ ମାଇନାଃକ । ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମିଆଁଦ୍‌ ପାବିତାର୍‌ ଦୁଁତ୍‌ କର୍ଣ୍ଣଲିୟକେ ଦାର୍‌ଶାନ୍‌ ଏମ୍‌କେଦ୍‌ତେ ଆମ୍‌କେ ଆୟାଃ ଅଡ଼ାଃତେ କେଡ଼ାଇଦିମେ ମେନ୍ତେ କାଜିକାଦା, ଜେ'ଲେକାଚି ଇନିଃ ଆମାଃତାଃଏତେ ଇତୁ ଦାଡ଼ିୟଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ପାତ୍‌ରାସ୍‌ ଇନ୍‌କୁକେ ଅଡ଼ାଃତେ କେଡ଼ାଇଦିକେଦ୍‌କଆ ଆଡଃ ଏନ୍‌ ନିଦା ଆୟାଃଲଃ ତାଇନ୍‌ ନାଗେନ୍ତେ ବିନ୍ତିକେଦ୍‌କଆ । ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଇନିଃ ସେକାଡ଼୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଲଃ ସେନଃୟାନାଏ । ଯୋପ୍‌ପାରେନ୍‌ ଚିମିନ୍‌ ବିଶ୍ୱାସୀକହଗି ଇନ୍‌କୁଲଃ ମିସାତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେୟାଃ ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ରେ ଇନ୍‌କୁ କାଇସରିୟା ସାହାର୍‌ତେକ ସେଟେର୍‌ୟାନା । ଏନ୍ତାଃରେ କର୍ଣ୍ଣଲିୟ ଆୟାଃ ହଡ଼ପେଡ଼ାକକେ ଆଡଃ ଆୟାଃ ଗାତିକକେ ହାକାଅକେଦ୍‌ତେ ଇନ୍‌କୁକେ ତାଙ୍ଗିତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପାତ୍‌ରାସ୍‌ ଭିତାର୍‌ତେ ବଲତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା କର୍ଣ୍ଣଲିୟ ଇନିଃକେ ଦାରମିତାନ୍‌ଲଃ ଆୟାଃ କାଟା ସୁବାରେ ଉୟୁଃକେଦ୍‌ତେ ଜହାର୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ମେନ୍‌ଦ ପାତ୍‌ରାସ୍‌ ଇନିଃକେ ବିରିଦ୍‍କେଦ୍‌ତେ କାଜିକିୟା, “ମାର୍‍ ତିଙ୍ଗୁନ୍‍ମେ, ଆଇଙ୍ଗ୍‌ହଁ ମିହୁଡ଼୍‌ ହଡ଼ ତାନିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ପାତ୍‌ରାସ୍‌ କର୍ଣ୍ଣଲିୟଲଃ ଜାଗାର୍‍ତାନ୍‍ଲଃଗି ଅଡ଼ାଃତେ ବଲୟାନା । ଏନ୍ତାଃରେ ପୁରାଃ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌ତେ, ");
INSERT INTO unx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ଇନିଃ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆ, “ଆପେ ସବେନ୍‌କ ସାରିତାନାପେ, ମିଆଁଦ୍‌ ଯିହୁଦୀ ହଡ଼ ଆୟାଃ ଧାରାମ୍‌ ବିଶ୍ୱାସ୍‌ ଲେକାତେ ସାଅଁସାର୍‌ ହଡ଼କଲଃ କାଏ ଦୁବ୍‌ତିଙ୍ଗୁନା । ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌କେ ଉଦୁବ୍‌କାଦିୟାଁ, ଜେତାଏକେ କା ଫାର୍‌ଚି ଚାଏ ସତ୍‌ରା ମେନ୍ତେ ଆଲମ୍‌ କାଜିକଆ । ");
INSERT INTO unx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ଏନାମେନ୍ତେ ଆମ୍‌ ଚିମ୍‌ତା ଆଇଙ୍ଗ୍‌କେ କେଡ଼ାଆଉ ନାଙ୍ଗ୍‌ କାଜିକେଦାମ୍‌, ଆଇଙ୍ଗ୍‌ ଜେତ୍‌ନାଃ କା କାଜିକେଦ୍‌ତେଇଙ୍ଗ୍‌ ହିଜୁଃୟାନା । ଆଇଙ୍ଗ୍‌ ସାରି ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା, ଆମ୍‌ ଚିନାଃମେନ୍ତେମ୍‌ କେଡ଼ାଆଉକାଦିୟାଁ ?” ");
INSERT INTO unx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍ଣ୍ଣଲିୟ କାଜିକିୟାଏ, “ଉପୁନ୍‌ମାହାଁଁରେ ଠିକ୍‌ ନେ ନେଡାରେ ତାର୍‌ସିଙ୍ଗ୍‌ ଆପି ଘାଡ଼ିକରେ ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଅଡ଼ାଃରେ ବିନ୍ତି ତାଇକେନାଇଙ୍ଗ୍‌ । ଇମ୍‌ତାଙ୍ଗି ଝାକ୍‌ମାକ୍‌ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ୟାଁକାନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ଆଇଁୟାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ତିଙ୍ଗୁୟାନା ଆଡଃ କାଜିକିୟାଁଏ, ");
INSERT INTO unx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘ଏ କର୍ଣ୍ଣଲିୟ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଆମାଃ ବିନ୍ତି ଆୟୁମାକାଦା ଆଡଃ ଗାରିବ୍‌ ହଡ଼କକେ ଦାନ୍‌ ଏମ୍‌ରେୟାଃ କାମିତେ ସୁକୁଆକାନା । ");
INSERT INTO unx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ଆଉ ନାଗେନ୍ତେ ଯୋପ୍‌ପା ସାହାର୍‌ତେ ଜେତାଏ ମିହୁଡ଼୍‌କେ କୁଲିପେ । ଇନିଃ ଦରେୟା ଗେନାରେ ତାଇନ୍‌ତାନ୍‌ ମୁଚି ଶିମୋନ୍‌ଆଃ ଅଡ଼ାଃରେ ପେଡ଼ାହଡ଼ ଲେକା ମେନାଇୟା ।’ ");
INSERT INTO unx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇମ୍‍ତାଗି ଆମ୍‌କେ କେଡ଼ାଆଉ ନାଙ୍ଗ୍‌ ହଡ଼କଇଙ୍ଗ୍‌ କୁଲ୍‌କେଦ୍‌କଆ ଆଡଃ ଆମ୍‌ ଲିବୁଇତାନ୍‌ଲଃ ହିଜୁଃୟାନାମ୍‌ । ପ୍ରାଭୁ ଆମ୍‌କେ ଅକ୍‌ନାଃ କାଜି ନାଗେନ୍ତେ ଆଚୁକାଦ୍‌ମା, ଏନା ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଆଲେ ନାହାଁଃ ସବେନ୍‌କ ନେତାଃରେଲେ ହୁଣ୍ଡିୟାକାନା ଆଡଃ ସାରିତାନାଲେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଲେଲଃ ମେନାଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ପାତ୍‌ରାସ୍‌ ଇତୁ ଏଟେଦ୍‌ତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ନାହାଁଃ ଆଇଙ୍ଗ୍‌ ଆଟ୍‌କାର୍‌ ଉରୁମ୍‌କେଦାଇଙ୍ଗ୍‌ ଯେ ସାର୍‌ତିଗି ପାର୍‌ମେଶ୍ୱାର୍‌ ସବେନ୍‌କକେ ମିଦ୍‌ଜକାଗି ନେଲାଃଏ । ");
INSERT INTO unx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ଜେତାଏ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରୱାଇୟା ଆଡଃ ଅକ୍‌ନାଃ ବୁଗିନାଃ ଏନା ରିକାଃଏ, ଇନିଃକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ସୁକୁଃଆଏ । ଏନ୍‌ ହଡ଼ ଜେତା ଜାତିରେନ୍‌ ତାଇନଃରେୟ ବାୟୁଃଆ । ");
INSERT INTO unx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ପାର୍‌ମେଶ୍ୱାର୍‌ ଇସ୍ରାଏଲ୍‌ ହଡ଼କତାଃତେ ଅକ କାନାଜି କୁଲାକାଦ୍‌ ତାଇକେନାଏ, ଏନାଗି ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ହରାତେ ଉଦୁବାକାନ୍‌ ଜୀଉସୁକୁରାଃ ସୁକୁକାଜି ତାନାଃ ଆଡଃ ନେ ୟୀଶୁଗି ସବେନ୍‌କଆଃ ପ୍ରାଭୁ ତାନିଃ, ଏନାଦପେ ସାରିତାନା । ");
INSERT INTO unx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ଯୋହାନ୍‌ ମନ୍‌ରୁହାଡ଼୍‌ରେୟାଃ ଆଡଃ ଦାଆଃରେ ବାପ୍ତିସ୍ମା ଇଦିରେୟାଃ କାନାଜି ଉଦୁବ୍‌କେଦ୍‌ ତାୟମ୍‌ତେ, ଗାଲିଲ୍‌ତାଃଏତେ ଏଟେଃକେଦ୍‌ତେ ଗଟା ଯିହୁଦା ଦିଶୁମ୍‌ରେ ସୁକୁକାଜି ଉଦୁବ୍‌ୟାନା, ଏନାଦପେ ସାରିତାନା । ");
INSERT INTO unx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ଆପେ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁଆଃ ବିଷାଏରେ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଚିଲ୍‌କା ୟୀଶୁଆଃ ଚେତାନ୍‌ରେ ପାବିତାର୍‌ ଆତ୍ମା ଆଡଃ ପେଡ଼େଃତେ ଆଭିଷେକ୍‌କିୟାଏ, ଏନାଦପେ ସାରିତାନା । ୟୀଶୁ ସବେନ୍‌ସାଃତେ ସେନ୍‌କେଦ୍‌ତେ ବୁଗିନାଃ କାମିକେଦାଏ ଆଡଃ ସାଏତାନ୍‌ତେ ଏସେରାକାନ୍‌ ହଡ଼କକେ ବୁଗିକେଦ୍‌କଆ, ଚିଆଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃଲଃ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଯିହୁଦା ଦିଶୁମ୍‌ରେ ଆଡଃ ଯୀରୁଶାଲେମ୍‌ ଦିଶୁମ୍‌ରେ ଇନିଃ ଅକ କାମିକଏ କାମିକେଦା, ଏନ୍‌ ସବେନାଃରେୟାଃ ଆଲେ ଗାୱାତାନ୍‌ଲେ । ଏନ୍ତେ ୟୀଶୁକେ ଇନ୍‌କୁ କ୍ରୁଶ୍‌ରେ କିଲାକେଦ୍‌ତେ ଗଏଃକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଆପିମାହାଁ ତାୟମ୍‌ତେ ଗନଏଃହେତେ ଜୀଉବିରିଦ୍‌କିୟା ଆଡଃ ହଡ଼କତାଃରେ ଉଦୁବେନ୍‌ଇଚିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ଇନିଃ ସବେନ୍‌କତାଃରେଦ କାଏ ଉଦୁବେନ୍‌ୟାନା, ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଅକ ହଡ଼କକେ ଆୟାଃ ଗାୱା ଏମ୍‌ନାଙ୍ଗ୍‌ ସିଦାରେ ସାଲାକାଦ୍‌କ ତାଇକେନା, ଇନ୍‌କୁତାଃରେ ଏସ୍‌କାର୍‌ ଉଦୁବେନ୍‌ୟାନାଏ । ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଗନଏଃହେତେ ଜୀଉବିରିଦ୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ ଆଲେ ଇନିଃଲଃ ଜମ୍‌ ନୁଁକେଦାଲେ । ");
INSERT INTO unx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ହଡ଼କତାଃରେ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଜୀନିଦ୍‌ ଆଡଃ ଗନଏଃ ହଡ଼କଆଃ ବିଚାର୍‌ ନାଗେନ୍ତେ ସାଲାକିୟା, ନେ କାଜିରେୟାଃ ଗାୱା ଏମ୍‌ ନାଗେନ୍ତେ ଇନିଃ ଆଲେକେ ଆଚୁକାଦ୍‌ଲେୟା । ");
INSERT INTO unx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ସବେନ୍‌ ନାବୀକ ଇନିୟାଃ ବିଷାଏରେ ଗାୱା ଏମ୍‌କେଦାକ, ଅକନ୍‌ ହଡ଼କ ଇନିଃତାଃରେକ ବିଶ୍ୱାସେୟା, ଇନ୍‌କୁ ଇନିୟାଃ ନୁତୁମ୍‌ରେୟାଃ ପେଡ଼େଃତେ ପାପ୍‌ ଛାମାକ ନାମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପାତ୍‌ରାସ୍‌ ନେ କାଜି କାଜିତାନ୍ ଇମ୍‌ତା, ଇନିୟାଃ କାଜି ଆୟୁମ୍‌ତାନ୍‌ ସବେନ୍‌ ହଡ଼କଆଃ ଚେତାନ୍‌ରେ ପାବିତାର୍‌ ଆତ୍ମା ଆଡ଼୍‌ଗୁୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ପାର୍‌ମେଶ୍ୱାର୍‌ ସାଅଁସାର୍‌ ବିଶ୍ୱାସୀ ହଡ଼କକେୟଗି ପାବିତାର୍‌ ଆତ୍ମାରେୟାଃ ବାର୍‌ଦାନ୍‌ ଏମାକତାନାଏ, ଏନା ନେଲ୍‌କେଦ୍‌ତେ ପାତ୍‌ରାସ୍‌ଲଃ ହିଜୁଃକାନ୍‌ ଯୋପ୍‌ପା ସାହାର୍‌ରେନ୍‌ ଯିହୁଦୀ ବିଶ୍ୱାସୀକ ହାଏକାଟ୍‍ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ଚିଆଃଚି ଯିହୁଦୀ ବିଶ୍ୱାସୀକ ଇନ୍‌କୁକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ ରିକାତାନ୍‌ ଆଡଃ ଏଟାଃ ଏଟାଃ ଜାଗାର୍‌ତେ କାଜିତାନ୍‌କ ଆୟୁମ୍‌କେଦ୍‌କଆ । ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ କାଜିକେଦ୍‌କଆଏ, ");
INSERT INTO unx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ଆବୁ ଲେକାଗି ନେ ହଡ଼କହ ପାବିତାର୍‌ ଆତ୍ମାକ ନାମ୍‌କିୟା । ଦାଆଃରେ ବାପ୍ତିସ୍ମା ଇଦି ନାଗେନ୍ତେ ଇନ୍‌କୁକେ ଚିନାଃ ଜେତାଏ ହକା ଦାଡ଼ିୟାଃକ ?” ");
INSERT INTO unx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ଏନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ନୁତୁମ୍‌ତେ ଦାଆଃରେ ବାପ୍ତିସ୍ମା ଇଦି ନାଗେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ଏନ୍ତେ ଇନ୍‌କୁ ଇନିଃକେ ଆଡଃ ଚିମିନ୍‌ ଦିନ୍‌ ଇନ୍‌କୁଲଃ ତାଇନ୍‌ ନାଗେନ୍ତେ କାଜିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ସାଅଁସାର୍‌ ହଡ଼କହଗି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ତେଲାକେଦାକ ମେନ୍ତେ ପ୍ରେରିତ୍‌କ ଆଡଃ ଯିହୁଦାରେନ୍‌ ଏଟାଃ ବିଶ୍ୱାସୀକ ଆୟୁମ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ପାତ୍‌ରାସ୍‌ ଚିମ୍‌ତା ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃୟାନା, ଇମ୍‌ତା ଖାତ୍‌ନାଅକାନ୍‌ ହଡ଼କ ଇନିୟାଃ ବିରୁଧ୍‌ରେ କାଜିକିୟାକ, ");
INSERT INTO unx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ଆପେ କା ଖାତ୍‌ନାଅକାନ୍‌ ସାଅଁସାର୍‌କଆଃ ଅଡ଼ାଃରେ ପେଡ଼ାହଡ଼ ଲେକାପେ ତାଇକେନା ଆଡଃ ଇନ୍‌କୁଲଃ ଜମ୍‌ ନୁଁକେଦାପେ ।” ");
INSERT INTO unx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ଏନାତେ ପାତ୍‌ରାସ୍‌ ଏନେଟେଦ୍‌ତାଃଏତେ ଅକ୍‌ନାଃ ହବାକାନ୍‌ ତାଇକେନା, ଏନା ସବେନାଃଏ ଉଦୁବାଦ୍‌କଆ, ");
INSERT INTO unx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ଆଇଙ୍ଗ୍‌ ଯୋପ୍‌ପା ସାହାର୍‌ରେ ବିନ୍ତି ତାଇକେନାଇଙ୍ଗ୍‌ ଇମ୍‌ତା ମିଆଁଦ୍‌ ଦାର୍‌ଶାନ୍‌ ନାମ୍‌କେଦାଇଙ୍ଗ୍‌ । ମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ଚାଦାର୍‌ରେୟାଃ ଉପୁନ୍‌ କଚାରେ ସାବ୍‌କେଦ୍‌ତେ ସିର୍ମାଏତେ ଡୁଙ୍ଗାଆଡ଼୍‌ଗୁଃ ତାଇକେନା ଆଡଃ ଆଇଁୟାଃ ଆୟାର୍‌ରେ ଆଟ୍‌କାଅୟାନ୍‌ ଲେକାଇଙ୍ଗ୍‌ ନେଲ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ଆଇଙ୍ଗ୍‌ ଏନାରେୟାଃ ଭିତାର୍‌ସାଃରେ ବୁଗିଲେକାଇଙ୍ଗ୍‌ ନେଲ୍‌କେଦ୍‌ ଇମ୍‌ତା, ଏନାରେ ଉପୁନିୟା କାଟାକାନ୍‌ ଜାଁତୁକ, ଅଡ଼ାଃରେ ଆସୁଲ୍‌ ଜାଁତୁକ ଆଡଃ ବିର୍‌ରେନ୍‌ ଜାଁତୁକ, ଅତେରେ ରେଙ୍ଗାଅଃତାନ୍‌ ଜାଁତୁକ ଆଡଃ ବିର୍‌ରେନ୍‌ ଅଡ଼େକକେଇଙ୍ଗ୍‌ ନେଲ୍‌କେଦ୍‌କଆ । ଆବୁଆଃ ଆଇନ୍‌ ଲେକାତେ କାବୁ ଜଜମ୍‌ ଜାଁତୁକହଗି ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ଏନ୍ତେ ଆଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌କେ କାଜିୟାଇଙ୍ଗ୍‌ତାନ୍‌ ଲାବ୍‌ଜା ଆୟୁମ୍‌କେଦାଇଙ୍ଗ୍‌, ‘ପାତ୍‌ରାସ୍‌, ବିରିଦ୍‌ମେ, ଆଡଃ ଗଏଃକେଦ୍‌ତେ ଜମ୍‌କମ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ କାଜିରୁହାଡ଼୍‌କେଦାଇଙ୍ଗ୍‌, ‘କାହାଗି ପ୍ରାଭୁ, ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ଜମ୍‌ ଦାଡ଼ିୟା । ନାହାଁଃ ଜାକେଦ୍‌ ଜେତା ସତ୍‌ରାତେୟାଃ ଚାଏ କା ଫାର୍‌ଚିତେୟାଃ କାଇଙ୍ଗ୍‌ ଜମାକାଦା ।’ ");
INSERT INTO unx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ସିର୍ମାଏତେ ଆଡଃମିସା ନେ ଲାବ୍‌ଜା ଆୟୁମ୍‌ୟାନା, ‘ପାର୍‌ମେଶ୍ୱାର୍‌ ଅକ୍‌ନାଃକେ ଫାର୍‌ଚିକାନା ମେନ୍ତେ କାଜିକାଦ୍‌ତେୟାଃକେ କା ଫାର୍‌ଚିକାନା ମେନ୍ତେ ଆଲମ୍‌ କାଜିୟା ।’ ");
INSERT INTO unx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ନେ'ଲେକା ଆପିସାତେ ହବାୟାନା, ଆଡଃ ଟୁଣ୍ଡୁରେ ଏନ୍‌ ସବେନ୍‌ ବିଷାଏକେ ସିର୍ମାତେ ଇଦି ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ଏନ୍‌ ନେଡାରେଗି, କାଇସରିୟାଏତେ ଆଇଙ୍ଗ୍‌ତାଃତେ କୁଲାକାନ୍‌ ଆପିହଡ଼କ ଆଇଙ୍ଗ୍‌ ତାଇନଃ ଅଡ଼ାଃତାଃତେକ ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ପାବିତାର୍‌ ଆତ୍ମା ଆଇଙ୍ଗ୍‌କେ ବେଗାର୍‌ ହିଚ୍‌କିଚାଅକେଦ୍‌ତେ ଜୁ ସେନଃମେ ମେନ୍ତେ କାଜିକିୟାଁ । ଯୋପ୍‌ପାରେନ୍‌ ନେ ତୁରିୟା ବିଶ୍ୱାସୀ ହାଗାକ ଆଇଙ୍ଗ୍‌ଲଃ କାଇସରିୟାତେକ ସେନ୍‌କେନା ଆଡଃ ଆଲେ ସବେନ୍‌କ କର୍ଣ୍ଣଲିୟଆଃ ଅଡ଼ାଃରେଲେ ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ଇନିଃ ଚିଲ୍‌କା ଆୟାଃ ଅଡ଼ାଃରେ ମିଆଁଦ୍‌ ଦୁଁତ୍‌କେ ତିଙ୍ଗୁକାନ୍‌ ନେଲାକାଇ ତାଇକେନାଏ, ଏନ୍‌ ବିଷାଏରେ ଆଲେକେ ଉଦୁବାଦ୍‌ଲେୟା । ଦୁଁତ୍‌ ଇନିଃକେ କାଜିକାଇ ତାଇକେନା, ‘ଯୋପ୍‌ପାତେ ଶିମୋନ୍‌ ପାତ୍‌ରାସ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼କେ ଆଉ ନାଗେନ୍ତେ ହଡ଼ କୁଲ୍‌କମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ଇନିଃ ହିଜୁଃକେଦ୍‌ତେ ଆମ୍‌କେ ଜୀଉବାଞ୍ଚାଅରେୟାଃ କାଜି କାଜିମେୟାଁ, ଏନା ହରାତେ ଆମ୍‌ ଆଡଃ ଆମାଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌କ ଜୀଉବାଞ୍ଚାଅପେ ନାମେୟା ।’ ");
INSERT INTO unx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ଆଡଃ ଆଇଙ୍ଗ୍‌ କାଜି ଏଟେଦ୍‌କେଦ୍‌ ଇମ୍‌ତା, ପାବିତାର୍‌ ଆତ୍ମା ଏନେଟେଦ୍‌ରେ ଆବୁଆଃ ଚେତାନ୍‌ରେ ଆଡ଼୍‌ଗୁୟାନ୍‌ ଲେକାଗି ଇନ୍‌କୁଆଃ ଚେତାନ୍‌ରେୟ ଆଡ଼୍‌ଗୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ପ୍ରାଭୁ କାଜିକାଦ୍‌ କାଜିଇଙ୍ଗ୍‌ ପାହାମ୍‍କେଦା, ‘ଯୋହାନ୍‌ଦ ଦାଆଃତେ ବାପ୍ତିସ୍ମା ଏମାଦ୍‌କଆଏ, ମେନ୍‌ଦ ଆପେ ପାବିତାର୍‌ ଆତ୍ମାତେ ବାପ୍ତିସ୍ମାୱାଃପେ ।’ ");
INSERT INTO unx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ପ୍ରାଭୁ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ତାଃରେ ବିଶ୍ୱାସ୍‌କେଦ୍‌ ହରାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବୁକେ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ବାର୍‌ଦାନ୍‌ ଏମାକାଦ୍‌ବୁ ଲେକାଗି ସାଅଁସାର୍‌ ବିଶ୍ୱାସୀକକେହଗି ଏନ୍‌ଲେକାନ୍‌ ବାର୍‌ଦାନ୍‌ ଏମାକାଦ୍‌କଆଏ, ଆଇଙ୍ଗ୍‌ ଅକଏ ତାନିଙ୍ଗ୍‌ ଯେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନେ କାମିକେଇଙ୍ଗ୍‌ ହକାଦାଡ଼ିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ଇନ୍‌କୁ ନେଆଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ହାପାୟାନାକ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌ତାନ୍‌ଲଃ କାଜିକେଦାକ, “ଏନାରେଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ସାଅଁସାର୍‌ ହଡ଼କକେୟଗି ହେୟାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଆଡଃ ଜୀଦାନ୍‌ ବାଞ୍ଚାଅଃ ନାଗେନ୍ତେ ସୁଯୋଗ୍‌ ଏମାକାଦ୍‌କଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ସ୍ତିଫାନ୍‌କେ ଗଏଃକିଃ ତାୟମ୍‌ତେ ବିଶ୍ୱାସୀ ହଡ଼କ ସାସାତି ନାମ୍‌କେଦ୍‌ ହରାତେ ଛିତିବିତିୟାନାକ, ଇନ୍‌କୁଏତେ ଚିମିନ୍‌ ହଡ଼କ ଯିହୁଦୀ ହଡ଼କତାଃରେ ଏସ୍‌କାର୍‌ ପ୍ରାଚାର୍‌ତାନ୍‌ଲଃ ଫିନିସିୟା, ସାଇପ୍ରସ୍‌ ଆଡଃ ଆନ୍ତିୟୋଖ୍‌ ଜାକେଦ୍‌କ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ମେନ୍‌ଦ ସାଇପ୍ରସ୍‌ ଟାପୁ ଆଡଃ କୁରିନି ନାଗାର୍‌ରେନ୍‌ ଏଟାଃ ଚିମିନ୍‌ ବିଶ୍ୱାସୀ ହଡ଼କ ଆନ୍ତିୟୋଖ୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ସାଅଁସାର୍‌ ହଡ଼କତାଃରେୟଗି ଗ୍ରୀକ୍‌ ଜାଗାର୍‌ତେ ପ୍ରାଭୁ ୟୀଶୁଆଃ ସୁକୁକାଜିକ ଉଦୁବ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ପ୍ରାଭୁଆଃ ପେଡ଼େଃ ଇନ୍‌କୁଲଃ ତାଇକେନା ଆଡଃ ପୁରାଃ ହଡ଼କ ବିଶ୍ୱାସ୍‌କେଦ୍‌ତେ ପ୍ରାଭୁସାଃତେ ମନ୍‌ରୁହାଡ଼୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ନେ କାନାଜି ଯୀରୁଶାଲେମ୍‌ କାଲିସିୟାତେ ସେଟେର୍‌ୟାନ୍‌ ଇମ୍‌ତା, ଇନ୍‌କୁ ବର୍ଣ୍ଣବାସ୍‌କେ ଆନ୍ତିୟୋଖ୍‌ତେ କୁଲ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ଇନିଃ ଏନ୍ତାଃତେ ସେଟେର୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଏନ୍‌ ହଡ଼କକେ ଚିଲ୍‌କାଏ ଆଶିଷ୍‌କାଦ୍‌କଆ, ଏନା ନେଲ୍‌କେଦ୍‌ତେ ଇନିଃ ରାସ୍‌କାୟାନାଏ ଆଡଃ ସବେନ୍‌ ମନ୍‌ସୁରୁଦ୍‌ତେ ପ୍ରାଭୁଆଃ ନାଙ୍ଗ୍‌ ପାତିୟାର୍‌ରଃ ଲେକା ତାଇନଃ ନାଗେନ୍ତେ ଇନ୍‌କୁକେ ଜୀଉରେ ରାସ୍‌କାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ବର୍ଣ୍ଣବାସ୍‌ ପାବିତାର୍‌ ଆତ୍ମାତେ ଆଡଃ ବିଶ୍ୱାସ୍‌ତେ ପେରେଜାକାନ୍‌ ମିଆଁଦ୍‌ ପୁରାଃ ବୁଗିନ୍‌ ହଡ଼ ତାଇକେନାଏ । ନେ'ଲେକାତେ ପୁରାଃ ହଡ଼କ ପ୍ରାଭୁରେ ମନ୍‌ରୁହାଡ଼୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ଏନ୍ତେ ବର୍ଣ୍ଣବାସ୍‌, ଶାଉଲ୍‌କେ ନାନାମ୍‌ତେ ତାର୍ଷିସ୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ଏନ୍ତାଃରେ ଇନିଃକେ ନାମ୍‌କେଦ୍‌ତେ ଆନ୍ତିୟୋଖ୍‌ତେ ଇଦିକିୟା । ଆଡଃ ମିଦ୍‌ ବାରାଷ୍‌ ଜାକେଦ୍‌ ବାରାନ୍‌କିନ୍‌ ଏନ୍ତାଃକରାଃ କାଲିସିୟାରେନ୍‌ ବିଶ୍ୱାସୀକଲଃ ମେସାକେଦ୍‌ତେ ପୁରାଃ ହଡ଼କକେ ଇତୁକେଦ୍‌କଆକ । ନେ ଆନ୍ତିୟୋଖ୍‌ରେନ୍‌ ବିଶ୍ୱାସୀକକେ ହଡ଼କ ପାହିଲାତେ ଖ୍ରୀଷ୍ଟିୟାନ୍‌ ମେନ୍ତେକ ନୁତୁମ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ଏନ୍‌ ଦିପିଲିକରେ ଚିମିନ୍‌ ନାବୀକ ଯୀରୁଶାଲେମ୍‌ହେତେ ଆନ୍ତିୟୋଖ୍‌ତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ଇନ୍‌କୁଏତେ ଆଗାବ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ଆତ୍ମାରେୟାଃ ପେଡ଼େଃତେ ପେରେଃୟାନ୍‌ଲଃ ଗଟା ଅତେଦିଶୁମ୍‌ରେ ମିଆଁଦ୍‌ ବରୱାନ୍‌ ରିଙ୍ଗା ହବାଅଃଆ ମେନ୍ତେ କାଜିଆୟାର୍‌କାଦ୍‌ ତାଇକେନା । ଏନା କ୍ଲାଉଦିଆ ରୋମ୍‌ରେନ୍‌ ମାରାଙ୍ଗ୍‌ ହାକିମ୍‌ ତାଇକେନ୍‌ ପାରିୟାରେ ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ଚେଲାକ ଯିହୁଦାରେ ତାଇନ୍‌ତାନ୍‌ ବିଶ୍ୱାସୀ ହାଗାକତାଃତେ ଇନ୍‌କୁଆଃ ଲାଗାତିଙ୍ଗ୍‌ ଲେକା ଦେଙ୍ଗା କୁଲେ ନାଗେନ୍ତେ ଉହାଟ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ଇନ୍‌କୁ ଟାକା ପାଏସା ହାରମ୍‌କେଦ୍‌ତେ ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃ ଶାଉଲ୍‌ଆଃ ତିଃଇରେ କାଲିସିୟାରେନ୍‌ ପ୍ରାଚିନ୍‌କତାଃତେ କୁଲ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ଏନ୍‌ ଦିପିଲିରେ ହେରୋଦ୍‌ ରାଜା କାଲିସିୟାରେନ୍‌ ଚିମିନ୍‍ ହଡ଼କକେ ସାସାତି ଏଟେଦ୍‌କେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ଇନିଃ ଯୋହାନ୍‌ଆଃ ହାଗାତେ ଯାକୁବ୍‌କେ ତାରାଉଡ଼ିତେ ଗଏଃକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ଯିହୁଦୀ ହଡ଼କ ନେ କାମି ନେଲ୍‌କେଦ୍‌ତେ ରାସ୍‌କାଅଃତାନାକ ଏନା ଇନିଃ ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ, ପାତ୍‌ରାସ୍‌କେୟଗି ତଲ୍‌କିୟାଏ । ନେଆଁ ସାବାଃ ହଲଙ୍ଗ୍‌ରେୟାଃ ପାରାବ୍‌ ଇମ୍‌ତା ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ଏନ୍ତେ ହେରୋଦ୍‌ ରାଜା ପାତ୍‌ରାସ୍‌କେ ତଲ୍‌କେଦ୍‌ତେ ଜେହେଲ୍‌ରେ ଦହକିୟାଏ । ଇନିଃକେ ହର ନାଗେନ୍ତେ ଉପୁନିୟା ଝୁଣ୍ଡ୍‌ରେନ୍‌ ପାଲ୍‌ଟାନ୍‌କଏତେ ମିପିହୁଡ଼୍‌ ଉପୁନିୟା ଝାନ୍‌ ସିପାଇକ ହରକିୟାକ । ପାସ୍‌କା ପାରାବ୍‌ ତାୟମ୍‌ତେ ସବେନ୍‌ ହଡ଼କଆଃ ଥାଲାରେ ଇନିଃକେ ବିଚାରି ନାଗେନ୍ତେ ହେରୋଦ୍‌ ରାଜା ଉହାଟ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ପାତ୍‌ରାସ୍‌ ଜେହେଲ୍‌ରେ ତାଇକେନ୍‌ ଇମ୍‌ତା କାଲିସିୟାରେନ୍‌ ହଡ଼କ ମିଦ୍‌ମନ୍‌ତେ ଇନିୟାଃ ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେକ ବିନ୍ତିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ହେରୋଦ୍‌ ରାଜା ଅକ ହୁଲାଙ୍ଗ୍‌ ପାତ୍‌ରାସ୍‌କେ ହଡ଼କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ତେ ଆଉ ନାଗେନ୍ତେ ଉହାଟ୍‌କାଦ୍‌ ତାଇକେନାଏ, ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେୟାଃ ସିଦା ନୁବାଃରେ ପାତ୍‌ରାସ୍‌ ବାର୍‌ହଡ଼୍‌ ହରତାନ୍‌କିନାଃ ଥାଲାରେ ଦୁଡ଼ୁମ୍‌କାନ୍‌ ତାଇକେନା । ଇନିଃ ବାରିୟା ସିକ୍‌ଡ଼ିତେ ତଲାକାନ୍‌ ତାଇକେନା ଆଡଃ ଜେହେଲ୍‌ରେୟାଃ ଦୁଆର୍‌ ଯାପାଃରେ ହରତାନ୍‌ ହଡ଼କ ହରତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ଇମ୍‌ତାଗି ପ୍ରାଭୁଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ହିଜୁଃକେଦ୍‌ତେ ତିଙ୍ଗୁୟାନା ଆଡଃ ଅଡ଼ାଃରେୟାଃ କୁଠା ମାର୍ସାଲ୍‌ତେ ପେରେଃୟାନା । ଦୁଁତ୍‌, ପାତ୍‌ରାସ୍‌ଆଃ ତାରାନ୍‌କେ ଏକ୍‌ଲାଅକେଦ୍‌ତେ ଇନିଃକେ ଦୁଡ଼ୁମ୍‌ଏତେ ବିରିଦ୍‌କିଃଲଃ କାଜିକିୟାଏ, “ଜାଲ୍‌ଦି ବିରିଦ୍‌ମେ !” ଇମ୍‌ତାଙ୍ଗି ପାତ୍‌ରାସ୍‌ଆଃ ତିଃଇରେ ତଲାକାନ୍‌ ସିକ୍‌ଡ଼ି ରାଡ଼ାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ଏନ୍ତେ ଦୁଁତ୍‌ କାଜିକିୟାଏ, “ମାୟାଙ୍ଗ୍‌ରେ ଲିଜାଃ ପାଟେନ୍‌ମେ, ଆଡଃ ଖାର୍‌ପାତାମାଃ ତୁସିୟେଁନ୍‌ମେ ।” ପାତ୍‌ରାସ୍‌ ଏନ୍‌ଲେକାଗି ରିକାକେଦ୍‌ ତାୟମ୍‌ତେ ଦୁଁତ୍‌ କାଜିକିୟାଏ, “ହଡ଼୍‌ମରେ ଚାଦାର୍ ଉୟୁକେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌କେ ଅତଙ୍ଗ୍‌ଇଁମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ଦୁଁତ୍‌ ରିକାତାଇକେନ୍‌ତେୟାଃ ସାର୍‌ତିତାନାଃ ଚି ନାହାଁଲାଃ ଏନା ପାତ୍‌ରାସ୍‌ କାଏ ସାରି ଦାଡ଼ିକେଦା । ଇନିଃ କୁମୁ ନେଲ୍‌ତାନାଇଙ୍ଗ୍‌ ମେନ୍ତେ ଉଡ଼ୁଃକେଦା । ଏନ୍‌ରେୟ ପାତ୍‌ରାସ୍‌ ଜେହେଲ୍‌ହେତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଦୁଁତ୍‌କେ ଅତଙ୍ଗ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ଇନ୍‌କିନ୍‌ ହରତାନ୍‌କଆଃ ମିଆଁଦ୍‌ ଆଡଃ ବାରିୟା ଠାୟାଦ୍‌ ପାରମ୍‌କେଦ୍‌ତେ ଟୁଣ୍ଡୁରେ ସାହାର୍‌ତେ ବଲ ହରାରେ ତାଇକାନ୍‌ ମେଡ଼େଦ୍‌ରେୟାଃ ଦୁଆର୍‌ତାଃତେକିନ୍‌ ସେଟେର୍‌ୟାନା । ଇମ୍‌ତା ଇନ୍‌କିନାଃ ନାଗେନ୍ତେ ଦୁଆର୍‌ ଆପାନ୍‌ତେଗି ନିଜ୍‌ୟାନା ଆଡଃ ଇନ୍‌କିନ୍‌ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନଃୟାନାକିନ୍‌ । ଇନ୍‌କିନ୍‌ ହରାରେ ସେନ୍‌ତାନ୍‌ ଇମ୍‌ତାଗି ଦୁଁତ୍‌ ପାତ୍‌ରାସ୍‌କେ ବାଗିକେଦ୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ଏନ୍ତେ ପାତ୍‌ରାସ୍‌ ଆଇଃକ୍‌ରେ ହବାୟାନ୍‌ତେୟାଃ ସାରି ଦାଡ଼ିକେଦ୍‌ତେ କାଜିକେଦା, “ନେଆଁ ସାର୍‌ତିତାନାଃ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ନାହାଁଃ ସାରି ଦାଡ଼ିତାନାଇଙ୍ଗ୍‌ ଯେ, ହେରୋଦ୍‌ତାଃଏତେ ଆଡଃ ଯିହୁଦୀ ହଡ଼କ ଅକ୍‌ନାଃ ହବାଅଃଆ ମେନ୍ତେ ଆସ୍ରାକାଦ୍‌ ତାଇକେନାକ, ପ୍ରାଭୁ ଏନାଏତେ ଆଇଙ୍ଗ୍‌କେ ବାଞ୍ଚାଅ ନାଗେନ୍ତେ ଦୁଁତ୍‌କେ କୁଲାକାଇ ତାଇକେନା ।” ");
INSERT INTO unx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ପାର୍‌ମେଶ୍ୱାର୍‌ ବାଞ୍ଚାଅକାଦିୟାଁଏ ମେନ୍ତେ ପାତ୍‌ରାସ୍‌ ଆଟ୍‌କାର୍‍କେଦାଏ, ଆଡଃ ଇନିଃ ଯୋହାନ୍‌ଆଃ ଏଙ୍ଗାତେ ମାରିୟାମ୍‌ଆଃ ଅଡ଼ାଃତେ ସେନଃୟାନା । ଯୋହାନ୍‌ଆଃ ଏଟାଃ ନୁତୁମ୍‌ ହବାଅଃତାନା ମାର୍କ । ଏନ୍ତାଃରେ ପୁରାଃ ହଡ଼କ ହୁଣ୍ଡିକେଦ୍‌ତେ ବିନ୍ତି ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପାତ୍‌ରାସ୍‌ ଅଡ଼ାଃରେୟାଃ ବାହାରି ଦୁଆର୍‌ରେ ଠକ୍‌ ଠକ୍‌କାଅକେଦା ଆଡଃ ରୋଦା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ କାମ୍‌ଡ଼ି କୁଡ଼ି ଅଡ଼ାଃ ବଲଦୁଆର୍‌ ନିଜ୍‌ ନାଗେନ୍ତେ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ପାତ୍‍ରାସ୍‍ଆଃ ଲାବ୍‌ଜା ଆୟୁମ୍‍ ଉରୁମ୍‍କେଦ୍‌ତେ ଇନିଃ ପୁରାଃଗି ରାସ୍‌କାୟାନା ଯେ, ବଲଦୁଆର୍‌ କା ନିଜ୍‌କେଦ୍‌ତେ ପାତ୍‌ରାସ୍‌ ବାହାରିରେ ତିଙ୍ଗୁଆକାନା ମେନ୍ତେ ଉଦୁବ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ଇନ୍‌କୁ ଇନିଃକେ କାଜିକିୟାକ, “ଆମ୍‌ ବାଲୁଅଃତାନାମ୍‌ ।” ମେନ୍‌ଦ ଇନିଃ “ନେଆଁ ସାର୍‌ତି ତାନାଃ” ମେନ୍ତେ ପୁରାଃତେ କାଜିକେଦା । ଏନ୍ତେ ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କେଦାକ, “ଇନିଃ ଆୟାଃ ଦୁଁତ୍‌ ତାଇନ୍‌ସାକାଅଃଆଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ପାତ୍‌ରାସ୍‌ ଦୁଆର୍‌କେ ଠକ୍‌ ଠକ୍‌କାଅକାତେ ତାଇକେନାଏ । ଟୁଣ୍ଡୁରେ ଇନ୍‌କୁ ଦୁଆର୍‌ ନିଜ୍‌କେଦ୍‌ତେ ଇନିଃକେ ନେଲ୍‌କିୟାକ ଆଡଃ ହାଏକାଟ୍‍ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ଇନିଃ ହାପାକାନ୍‌ପେ ମେନ୍ତେ ତିଃଇତେ କାଜିୟାଦ୍‍କଆ ଆଡଃ ପ୍ରାଭୁ ଇନିଃକେ ଚିଲ୍‌କା ଜେହେଲ୍‌ହେତେ ଅଡଙ୍ଗ୍‌ ଆଉକିୟା, ଏନ୍‌ ବିଷାଏ ଇନ୍‌କୁଆଃ ଆୟାର୍‌ରେ କାଜିକେଦା । ଏନ୍ତେ ଇନିଃ ନେ ସବେନ୍‌ କାଜି “ଯାକୁବ୍‌ ଆଡଃ ଏଟାଃ ସବେନ୍‌ ବିଶ୍ୱାସୀ ହାଗାକକେ” ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଆଚୁକେଦ୍‌କଆ ଆଡଃ ଇନିଃ ଏନ୍ତାଃଏତେ ଏଟାଃତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଆଙ୍ଗ୍‌ୟାନ୍‌ଚି ପାତ୍‌ରାସ୍‌ କତେ ସେନଃୟାନା ମେନ୍ତେ ହରତାନ୍‌ ହଡ଼କ ପୁରାଃଗି ଆକ୍‌ବାକାଅୟାନାକ । ଚିଆଃଚି ପାତ୍‌ରାସ୍‌ଲଃ ଚିକ୍‌ନାଃ ହବାୟାନା ଏନା ଇନ୍‌କୁ କାକ ସାରିକାଦ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ହେରୋଦ୍ ଇନିଃକେ ଦାଣାଁଆଉ ନାଗେନ୍ତେ ଆଚୁକେଦ୍‌କଆ ମେନ୍‌ଦ ଇନ୍‌କୁ ଇନିଃକେ କାକ ନାମ୍‌କିୟା । ଟୁଣ୍ଡୁରେ ହରତାନ୍‌ ହଡ଼କକେ କୁଲିକତାନ୍‌ଲଃ ଇନ୍‌କୁକେ ଗଏଃକ ନାଗେନ୍ତେ ଆନାଚୁ ଏମାଦ୍‌କଆ । ଏନ୍‌ ତାୟମ୍‌ତେ ହେରୋଦ୍‌ ଯିହୁଦା ପାର୍‌ଗାନ୍‌ ବାଗିକେଦ୍‌ତେ କାଇସରିୟାରେ ସେନ୍‌କେଦ୍‌ତେ ତାଇନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ହେରୋଦ୍ ରାଜା ସୋର୍‌ ଆଡଃ ସିଦୋନ୍‌ ନାଗାର୍‌ରେନ୍‌ ହଡ଼କକେ ପୁରାଃଗି ଖିସ୍‌କାନ୍‌ ତାଇକେନା, ଏନାତେ ଇନ୍‌କୁଏତେ ମିଦ୍‌ ଝୁଣ୍ଡ୍‌ ଇନିଃଲଃ ନେପେଲ୍‌ ନାଗେନ୍ତେ ଇନିଃତାଃତେକ ସେନଃୟାନା । ସିଦାତେ ଇନ୍‌କୁ ବାପାଇୟଃ ନାଗେନ୍ତେ ଦେଙ୍ଗା ନାଙ୍ଗ୍‌ ରାଜ୍‌ମାହାଲ୍‌କେ ନେଲ୍‌ହରତାନ୍‌ ବ୍ଲାଷ୍ଟସ୍‌ଲଃ ଜାଗାର୍‌କେଦାକ । ଏନ୍ତେ ଇନ୍‌କୁ ହେରୋଦ୍‌ତାଃ ସେନ୍‌କେଦ୍‌ତେ ବାପାଇୟଃ ନାଗେନ୍ତେକ ବିନ୍ତିକିୟା, ଚିୟାଃଚି ହେରୋଦ୍‌ ରାଜାରାଃ ଦିଶୁମ୍‌ହେତେ ଇନ୍‌କୁଆଃ ଦିଶୁମ୍‌ତେ ଜମେୟାଁ କୁଲଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ହେରୋଦ୍‌ ଟାହାରାୱାକାନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ରାଜା ତୁସିଙ୍ଗ୍‌ଅଁଃ ଲିଜାଃ ତୁସିଙ୍ଗ୍‌ୟାନାଏ ଆଡଃ ଆୟାଃ ରାଜ୍‌ଗାଦିରେ ଦୁବ୍‌କେଦ୍‌ତେ ହଡ଼କକେ ଜାଗାର୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ଏନା ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ କାଉରିକେଦ୍‌ତେ କାଜିକେଦାକ, “ନେଆଁ ଜେତା ହଡ଼ରାଃ ଜାଗାର୍‌ ନାହାଁଲାଃ ମେନ୍‌ଦ ମିଆଁଦ୍‌ କା ସାରିକାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଜାଗାର୍‌ତାନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ଇମ୍‌ତାଙ୍ଗି ପ୍ରାଭୁଆଃ ମିଆଁଦ୍‌ ଦୁଁତ୍‌ ଇନିଃକେ ଦାଲ୍‍କିଆ, ଚିଆଃଚି ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ କାଏ ମାଇନ୍‍କିଆ, ଆଡଃ ଇନିଃକେ ତିଜୁକ ଜମ୍‌କିଃ ହରାତେ ଗଏଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ପୁରାଃତେ ନିତିର୍‌ୟାନା ଆଡଃ ହାରାଇଦିୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃ ଶାଉଲ୍‌ ଆକିନାଃ ସେୱାକାମି ଚାବାକେଦ୍‌ତେ ଯୋହାନ୍‌ ଏଟାଃ ନୁତୁମ୍‌ ମାର୍କ ମେନ୍ତେହ କାଜିୟାଃକ, ଇନିଃକେ ଇଦିକେଦ୍‌ତେ ଯୀରୁଶାଲେମ୍‌ଏତେକ ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ଆନ୍ତିୟୋଖ୍‌ କାଲିସିୟାରେ ଚିମିନ୍‌ ନାବୀକ ଆଡଃ ଇତୁହଡ଼କ ତାଇକେନା, ଇନ୍‌କୁଏତେ ବର୍ଣ୍ଣବାସ୍‌, ନିଗର୍‌ ହଡ଼ ମେନ୍ତେ କାଜିୟଃ ତାଇକେନ୍‌ ଶିମୋନ୍‌, କୁରିନିରେନ୍‌ ଲୁସିୟସ୍‌, ଲାଟ୍‌ସାହେବ୍‌ ହେରୋଦ୍‌ଆଃ ଅଡ଼ାଃରେ ଆସୁଲ୍‌ହାରାକାନ୍‌ନିଃ ମନହେମ୍‌, ଆଡଃ ଶାଉଲ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ଇନ୍‌କୁ ପ୍ରାଭୁକେ ସେୱାତାନ୍‌ ଆଡଃ କାଟାବ୍‌ତାନ୍‍ ତାଇକେନ୍‌ ଇମ୍‌ତା ପାବିତାର୍‌ ଆତ୍ମା ଇନ୍‌କୁକେ କାଜିୟାଦ୍‍କଆ, “ଆଇଙ୍ଗ୍‌ ଅକ କାମି ନାଗେନ୍ତେ ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃ ଶାଉଲ୍‌କେ ସାଲାକାଦ୍‌କିନାଇଙ୍ଗ୍‌, ଏନାମେନ୍ତେ ଇନ୍‌କିନ୍‌କେ ଆଇଁୟାଃ ନାଙ୍ଗ୍‌ ଗେନା ଆତମ୍‌କିନ୍‌ପେ ।” ");
INSERT INTO unx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ଏନ୍ତେ ଇନ୍‌କୁ କାଟାବ୍‌କେଦ୍‌ତେ ଏନ୍‌ ବାରାନ୍‌କିନାଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହତାନ୍‌ଲଃ ବିନ୍ତିକେଦାକ ଆଡଃ ଇନ୍‌କିନ୍‌କେ ସେୱାକାମି ନାଗେନ୍ତେକ କୁଲ୍‌କେଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ନେ'ଲେକାତେ ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃ ଶାଉଲ୍‌ ପାବିତାର୍‌ ଆତ୍ମାତେ କୁଲ୍‌ୟାନାକିନ୍‌ ଆଡଃ ସେଲ୍ୟୁକିଆତେକିନ୍‌ ସେନଃୟାନା ଆଡଃ ଏନ୍ତାଃଏତେ ଦାଆଃ ଜାହାଜ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ସାଇପ୍ରସ୍‌ ଟାପୁତେକିନ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ଇନ୍‌କିନ୍‌ ସଲାମି ସାହାର୍‌ତେ ସେଟେର୍‌କେଦ୍‌ତେ ଯିହୁଦୀକଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ଉଦୁବ୍‌କେଦାକିନ୍‌ । ଯୋହାନ୍‌ ମାର୍କ ଇନ୍‌କିନ୍‌ଲଃ ତାଇକେଦ୍‌ତେ ଦେଙ୍ଗାକିନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ଇନ୍‌କୁ ସାଇପ୍ରସ୍‌ ଟାପୁ ପାରମ୍‌କେଦ୍‌ତେ ପାଫସ୍‌ ସାହାର୍‌ତେ ସେନଃୟାନାକ । ଏନ୍ତାଃରେ ଇନ୍‌କୁ ବାର୍‌ୟୀଶୁ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଯିହୁଦୀ ଦେଅଁଣା ହଡ଼ଲଃ ନାପାମ୍‌ୟାନାକ । ଇନିଃ ଆପାନ୍‌କେ ନାବୀ ମେନ୍ତେ କାଜିନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ସର୍ଗିୟସ୍‌ ପାଉଲୁସ୍‌ ମେନ୍ତେ ଇନିୟାଃ ମିଆଁଦ୍‌ ଗାତି ତାଇକେନାଏ, ଇନିଃ ଏନ୍‌ ଟାପୁରେନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ତାଇକେନାଏ । ସର୍ଗିୟସ୍‌ ପାଉଲୁସ୍‌ ମିହୁଡ଼୍‌ ସେଣାଁନ୍‌ ହଡ଼ ତାଇକେନାଏ । ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ଆୟୁମ୍‌ ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌କେଦ୍‌ ହରାତେ ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃ ଶାଉଲ୍‌କେ ଆୟାଃତାଃ କେଡ଼ାକେଦ୍‌କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ମେନ୍‌ଦ ଦେଅଁଣାହଡ଼ରାଃ ଗ୍ରୀକ୍‌ ନୁତୁମ୍‌ ଏଲିମାସ୍‌, ଏନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ଆଲକାଏ ବିଶ୍ୱାସେକା ମେନ୍ତେ ଇନିଃ ଇନ୍‌କୁକେ କାଜିକଟଙ୍ଗ୍‌ କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ମେନ୍‌ଦ ଶାଉଲ୍‌, ଅକଏକେଚି ପାଉଲୁସ୍‌ ମେନ୍ତେହ କାଜିୟାଃକ, ଇନିଃ ପାବିତାର୍‌ ଆତ୍ମାତେ ପେରେଃୟାନ୍‌ଲଃ ଦେଅଁଣାହଡ଼କେ ମିଦ୍‌ଢିଟ୍‌ଗି ନେଲ୍‌କିୟାଏ, ଆଡଃ କାଜିକିୟାଏ, ");
INSERT INTO unx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ଏ ସାଏତାନ୍‌ଆଃ ହନ୍‌, ଆମ୍‌ ସବେନ୍‌ ବୁଗିନ୍‌ ବିଷାଏରେୟାଃ ବାଇରିତାନ୍‌ମେ । ଆମ୍‌ ସବେନ୍‌ ଲେକାନ୍‌ ଏତ୍‌କାନ୍‌ ବେଦାତେ ପେରେଜାକାନାମ୍‌ ଆଡଃ ସବେନ୍‌ ଇମ୍‌ତା ପ୍ରାଭୁଆଃ ସାନାର୍‌ତି ହରାକେ ହସଡ଼ ମେନ୍ତେ କାଜି ନାଙ୍ଗ୍‌ ଚେଷ୍ଟାଏ ତାନାମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ନାହାଁଃଗି ପ୍ରାଭୁ ଆମ୍‌କେ ସାଜାଇ ଏମାମେୟାଁଏ, ଆମାଃ ମେଦ୍‌ କାଣାଁଅଃଆ ଆଡଃ ଚିମିନ୍‌ ନେଡା ଜାକେଦ୍‌ ସିଙ୍ଗିରେ ଜେତ୍‌ନାଃ କାମ୍‌ ନେଲ୍‌ ଦାଡ଼ିୟା ।” ଇମ୍‌ତାଙ୍ଗି ଏଲିମାସ୍‌ ଆୟାଃ ମେଦ୍‌ରେ ନୁବାଃ ଦାଲବ୍‌ୟାନ୍‌ ଲେକାଏ ଆଟ୍‌କାର୍‌କେଦା ଆଡଃ ଜେତାଏ ମିହୁଡ଼୍‌ ଆୟାଃ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ ସୁତୁଃଇଦିକାକ ମେନ୍ତେ ଦାଣାଁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ନେଆଁ ନେଲ୍‌କେଦ୍‌ତେ ଲାଟ୍‌ସାହେବ୍‌ ବିଶ୍ୱାସ୍‌କେଦାଏ, ଚିଆଃଚି ଇନିଃ ପ୍ରାଭୁଆଃ ଇନିତୁ ଆୟୁମ୍‌କେଦ୍‌ତେ ପୁରାଃଗି ଆକ୍‌ଚାକାଅଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ପାଉଲୁସ୍‌ ଆଡଃ ଆୟାଃଲଃ ମିସାତେ ହରାସେନ୍‌ତାନ୍‌କ ପାଫସ୍‌ତାଃଏତେ ଦାଆଃ ଜାହାଜ୍‌ତେ ପାମ୍ପିଲିଆ ନାଗାର୍‌ରେୟାଃ ପେର୍‌ଗା ସାହାର୍‌ତେକ ହିଜୁଃୟାନା, ଏନ୍ତାଃରେ ଯୋହାନ୍‌ ମାର୍କ ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌ତେ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ଇନ୍‌କୁ ପେର୍‌ଗାଏତେ ସେନ୍‌କେଦ୍‌ତେ ପିସିଦିଆରେୟାଃ ଆନ୍ତିୟୋଖ୍‌ତେକ ସେଟେର୍‌ୟାନା ଆଡଃ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ବଲକେଦ୍‌ତେକ ଦୁବ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁ ଆଡଃ ନାବୀକଆଃ ଅନଲ୍‌ ପାଢ଼ାଅକେଦ୍‌ ତାୟମ୍‌ତେ, ସାମାଜ୍‌ଅଡ଼ାଃରେନ୍‌ ଆଗୁଆଇକ ନେଆଁ କାଜିକୁଲ୍‌କେଦାକ, “ହାଗା ମିଶିକ, ହଡ଼କ ନାଗେନ୍ତେ ଜୀଉରେ ରାସ୍‌କାଅଃ ଲେକାନ୍‌ କାଜି ମେନାଃରେଦ, କାଜିପେ ମେନ୍ତେଲେ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ପାଉଲୁସ୍‌ ତିଙ୍ଗୁକେଦ୍‌ତେ, ହଡ଼କକେ ତିଃଇ ହିଲାଅତାନ୍‌ଲଃ କାଜିୟାଦ୍‌କଆ, “ନେତାଃରେ ମେନାପେ ସବେନ୍‌ ଇସ୍ରାଏଲ୍‌ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରୱାଇତାନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କ, ଆଇଁୟାଃ କାଜି ଆୟୁମେପେ, ");
INSERT INTO unx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ନେ ଇସ୍ରାଏଲ୍‌ ହଡ଼କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବୁଆଃ ପୁର୍‌ଖା ହଡ଼କକେ ସାଲାକେଦ୍‌କଆ ଆଡଃ ମିସାର୍‌ ଦିଶୁମ୍‌ରେ ଇନ୍‌କୁ ଏଟାଃ ଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କ ଲେକାକ ତାଇନଃ ତାଇକେନା, ଇମ୍‌ତା ଇନ୍‌କୁ ପୁରାଃ ଗାଦେଲ୍‌ ହଡ଼କ ହବାୟାନା । ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ପୁରାଃ ପେଡ଼େଃତେ ଇନ୍‌କୁକେ ମିସାର୍‌ ଦିଶୁମ୍‌ହେତେ ଅଡଙ୍ଗ୍‌ ଆଉକେଦ୍‌କଆ, ");
INSERT INTO unx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ଆଡଃ ଇନ୍‌କୁ ଇନିୟାଃ କାଜି କାକ ମାନାତିଙ୍ଗ୍‌ ତାଇକେନ୍‌ରେୟଗି, ଇନିଃ ବାର୍‌ହିସି ବାରାଷ୍‌ ଜାକେଦ୍‌ ବିର୍‌ରେ ଇନ୍‌କୁକେ ଆସୁଲ୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ଇନିଃ କିନାନ୍‌ ଦିଶୁମ୍‌ରେ ଏୟା କିଲିକଆଃ ଦିଶୁମ୍‌ ଜିୟନ୍‌କେଦ୍‌ତେ ଆୟାଃ ସାଲାକାନ୍‌ ହଡ଼କକେ ଏନ୍‌ ଦିଶୁମାଏ ଏମାଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“ନେ ସବେନାଃ ୪୫୦ ବାରାଷ୍‌ରେ ହବାୟାନା । ନେ ସବେନାଃରେୟାଃ ତାୟମ୍‌ତେ ନାବୀ ଶାମୁଏଲ୍‌ ଜାକେଦ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କୁ ନାଙ୍ଗ୍‌ ବିଚାର୍‌ ହଡ଼କକେ ସାଲାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ଆଡଃ ଇନ୍‌କୁ ମିଆଁଦ୍‌ ରାଜା ଆସିକେନାକ, ଇମ୍‌ତା ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କୁଆଃ ଚେତାନ୍‌ରେ ୪୦ ବାରାଷ୍‌ ଜାକେଦ୍‌ ରାଇଜେ ନାଗେନ୍ତେ ବେଞ୍ଜାମିନ୍‌ କିଲିରେନ୍‌ କୀଶ୍‌ଆଃ ହନ୍‌ ଶାଉଲ୍‌କେ ଏମ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ଏନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ରାଜ୍‌ଗାଦିହେତେ ଆତମ୍‌କେଦ୍‌ତେ, ଦାଉଦ୍‌କେ ଇନ୍‌କୁଆଃ ରାଜାଏ ବାଇକିୟା । ପାର୍‌ମେଶ୍ୱାର୍‌ ଦାଉଦ୍‌ଆଃ ବିଷାଏରେ ଗାୱା ଏମ୍‌କେଦ୍‌ତେ କାଜିକେଦା, ‘ଆଇଙ୍ଗ୍‌ ଚିଲ୍‌କା ହଡ଼କକେ ଦୁଲାଡ଼୍‌କଆଇଙ୍ଗ୍‌, ଯିଶିରାଃ ହନ୍‌ ଦାଉଦ୍‌ ଏନ୍‌ଲେକାନ୍‌ନିଃ ମିହୁଡ଼୍‌ ତାନିଃ । ଇନିଃ ଆଇଁୟାଃ ମନ୍‌ସୁରୁଦ୍‌ରେୟାଃ ଇଛାସାନାଙ୍ଗ୍‌ ଲେକା ସବେନାଃଏ କାମିୟା ।’ ");
INSERT INTO unx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ନେ ଦାଉଦାଃ କିଲିରେନ୍‌ ୟୀଶୁକେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆୟାଃ ବାନାର୍‌ସା ଲେକାତେ ଇସ୍ରାଏଲ୍‌ ହଡ଼କଆଃ ଜୀଉବାଞ୍ଚାଅନିଃ ବାଇକିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ୟୀଶୁ ଆୟାଃ କାମି ଏନେଟେଦ୍‌ ସିଦାରେ ଯୋହାନ୍‌ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ସବେନ୍‌ ହଡ଼କତାଃରେ ଉଦୁବ୍‌କେଦ୍‌ତେ କାଜିକେଦାଏ, ‘ଇନ୍‌କୁକେ ପାପ୍‌ହେତେ ହେୟାତିଙ୍ଗ୍‌ତାନ୍‌ଲଃ ଦାଆଃରେ ବାପ୍ତିସ୍ମା ଇଦି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।’ ");
INSERT INTO unx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ଆଡଃ ଯୋହାନ୍‌ ଆୟାଃ ସେୱାକାମି ଟୁଣ୍ଡୁଇତାନ୍‌ ଇମ୍‌ତା ହଡ଼କକେ କୁଲିକେଦ୍‌କଆ, ‘ଆଇଁୟାଃ ବିଷାଏରେ ଆପେ ଚିନାଃପେ ଉଡ଼ୁଃତାନା ? ଆପେ ଅକଏକେପେ ନେଲ୍‌ହରାତାନା, ଇନିଃ ଆଇଙ୍ଗ୍‌ ନାହାଁଲିଙ୍ଗ୍‌ । ମେନ୍‌ଦ ଆୟୁମେପେ, ଆଇଁୟାଃ ତାୟମ୍‌ତେ ଅକଏ ହିଜୁଃତାନାଏ, ଇନିୟାଃ ଖାର୍‌ପାରେୟାଃ ତନଲ୍‌ ରାଡ଼ାଏ ଲେକାନ୍‌ନିଃ ନାହାଁଲିଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ହେ ଇସ୍ରାଏଲ୍‌ ହାଗାକ, ଆବ୍ରାହାମ୍‌ଆଃ କିଲିରେନ୍‌ ହନ୍‌କ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରୱାଇତାନ୍‌ ସବେନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କ, ଆବୁକେଗି ନେ ଜୀଉବାଞ୍ଚାଅରେୟାଃ କାନାଜି ଏମାକାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ମେନ୍‌ଦ ଇନିଃ ଜୀଉବାଞ୍ଚାଅନିଃ ତାନିଃ ମେନ୍ତେ ଯୀରୁଶାଲେମ୍‌ରେ ତାଇନ୍‌ତାନ୍‌ ହଡ଼କ ଆଡଃ ଇନ୍‌କୁଆଃ ଆଗୁଆଇକ କାକ ସାରିକାଦ୍‌ ତାଇକେନା । ଇନ୍‌କୁ ସବେନ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ପାଢ଼ାଅଃ ତାଇକେନ୍‌ ନାବୀକଆଃ କାଜି କାକ ଆଟ୍‌କାର୍‌ଉରୁମେ ତାଇକେନା । ଏନ୍‌ରେୟ ଇନ୍‌କୁ ୟୀଶୁକେ ଚିଟାକେଦ୍‌ତେ ନାବୀକଆଃ କାଜିକେ ପୁରାକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ଇନ୍‌କୁ ଗନଏଃ ସାଜାଇ ଏମ୍‌ରେୟାଃ ଜେତାନ୍‌ ଗୁହ୍ନାଁ କାକ ନାମ୍‌କେଦ୍‌ରେୟ, ଇନିଃକେ ଗନଏଃ ସାଜାଇ ଏମ୍‌ ନାଗେନ୍ତେ ପିଲାତୁସ୍‌କେ କାଜିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ଇନିୟାଃ ବିଷାଏରେ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ ଲେକାଗି ସବେନ୍‌ କାମି ରିକାକେଦ୍‌ ତାୟମ୍‌ତେ ଇନ୍‌କୁ ଇନିଃକେ କ୍ରୁଶ୍‌ଏତେ ଆଡ଼୍‌ଗୁକିୟାକ ଆଡଃ ତପାଗାଡ଼ାରେ ଦହକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନିଃକେ ଗନଏଃହେତେ ଜୀଉବିରିଦ୍‌କିୟା, ");
INSERT INTO unx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ଆଡଃ ପୁରାଃ ମାହାଁ ଜାକେଦ୍‌ ଇନିଃଲଃ ଗାଲିଲ୍‌ଏତେ ଯୀରୁଶାଲେମ୍‌ତେ ହିଜୁଃ ସେନଃତାନ୍‌ ହଡ଼କତାଃରେ ଉଦୁବେନ୍‌ୟାନା । ଇନ୍‌କୁ ନାହାଁଃ ଇସ୍ରାଏଲ୍‌ ହଡ଼କତାଃରେ ଇନିୟାଃ ଗାୱାକ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ଆଡଃ ଆଲିଙ୍ଗ୍‌ ଆପେକେ ଏନ୍‌ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ ନେତାଃରେ ମେନାଲିୟାଁ, ଅକ୍‌ନାଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌ହଡ଼କକେ ବାନାର୍‌ସା ଏମାକାଦ୍‌କ ତାଇକେନାଏ, ");
INSERT INTO unx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ପାର୍‌ମେଶ୍ୱାର୍‌ ୟୀଶୁକେ ଜୀଉବିରିଦ୍‌କିଃ ହରାତେ ଆବୁ ନାଗେନ୍ତେ ନାହାଁଃ ପୁରାକାଦାଏ ଆଡଃ ଆବୁ ଇନ୍‌କୁଆଃ କିଲିରେନ୍‌କ ହବାକାନାବୁ । ଦାଉଦ୍‌ଆଃ ଦୁରାଙ୍ଗ୍‌ପୁଥି ୨ ଆଧ୍ୟାଏରେ ନେ'ଲେକା ଅଲାକାନା, “‘ଆମ୍‌ ଆଇଁୟାଃ ହନ୍‌, ତିସିଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ ଆମାଃ ଆପୁ ହବାୟାନାଇଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ଆଡଃ ତପାଗାଡ଼ାରେ ଆଲକାଏ ଜିୟନଃକା ମେନ୍ତେ ଇନିଃକେ ଗନଏଃହେତେ ଜୀଉବିରିଦି ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ନେ'ଲେକାଏ କାଜିକାଦ୍‌ ତାଇକେନା, ‘ଦାଉଦ୍‌କେ ଏମାକାଇ ବାନାର୍‌ସା ଲେକାଗି ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ପାବିତାର୍‌ ଆଡଃ ସାର୍‍ତିଗିଇଙ୍ଗ୍‌ ଆଶିଷ୍‌ମେୟାଁ ।’ ");
INSERT INTO unx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ଦୁରାଙ୍ଗ୍‌ପୁଥିରେୟାଃ ଏଟାଃତାଃରେ ଅଲାକାନା, ‘ଆମ୍‌ ଆମାଃ ପାବିତାର୍‌ ଦାସିକେ ତପାଗାଡ଼ାରେ ଜିୟନଃ ନାଗେନ୍ତେ କାମ୍‌ ବାଗିଇଚିୟା ।’” ");
INSERT INTO unx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଉଦ୍‌ ଆୟାଃ ଜୀନିଦ୍‌ ଦିପିଲିରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଇଛାସାନାଙ୍ଗ୍‌ ଲେକାଗି, ସୁସାର୍‌କେଦ୍‌ତେ ଜୀଉତାୟାଃ ଟୁଣ୍ଡୁକେଦା ଆଡଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କଲଃ ତପାୟାନାଏ । ଆୟାଃ ଗନଏଃ ହଡ଼୍‌ମ ତପାଗାଡ଼ାରେୟାଃ ହାସାରେ ମେସାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ମେନ୍‌ଦ ପାର୍‌ମେଶ୍ୱାର୍‌ ଅକଏକେ ଗନଏଃହେତେ ଜୀଉବିରିଦ୍‌କିୟାଏ, ଇନିଃ ହାସାରେ କାଏ ମେସାକାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ଏନାମେନ୍ତେ, ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହାଗାକ, ଆପେ ସବେନ୍‌କକେ ନେଆଁ ସାରି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ଯେ, ୟୀଶୁଆଃ ହରାତେ ଏସ୍‌କାର୍‌ ଆପେତାଃରେ ପାପ୍‌ ଛାମାରେୟାଃ କାନାଜି ଉଦୁବ୍‌କାନା । ଆଡଃ ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁ ହରାତେ ପାପ୍‌ହେତେ କା ରାଡ଼ା ଦାଡ଼ିକାନ୍‌ ସବେନ୍‌ ହଡ଼କ, ");
INSERT INTO unx_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ଏନ୍‌ ୟୀଶୁତାଃରେ ବିଶ୍ୱାସ୍‌କେଦ୍‌ ହରାତେ ଜୀଉବାଞ୍ଚାଅକ ନାମେୟା, ନେଆଁ ଆପେକେ ସାରି ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ । ");
INSERT INTO unx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ଏନାମେନ୍ତେ ଚିର୍ଗାଲ୍‌କାନ୍‌ପେ, ନାବୀକ କାଜିକାଦ୍‌ତେୟାଃ ଆପେରେ ଆଲକା ହବାଅଃକା, ");
INSERT INTO unx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘ଆଇଙ୍ଗ୍‌କେ ଲାନ୍ଦାଇଙ୍ଗ୍‌ତାନ୍‌ ହଡ଼କ, ଆପେ ଆକ୍‌ଦାନ୍ଦାଅକେଦ୍‌ତେ ଜିୟନଃପେ, ଚିଆଃଚି ତିସିଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ କାମିତାନ୍‌ତେୟାଃ, ଜେତାଏ ଆପେକେ ଉଦୁବାପେରେୟ ଆପେ କାପେ ବିଶ୍ୱାସେୟା ।’” ");
INSERT INTO unx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃ ବାଗିକେଦ୍‌ତେ ସେନଃ ତାଇକେନାକିନ୍‌ ଇମ୍‌ତା, ହଡ଼କ ଏଟାଃ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ହିଜୁଃ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ନେ ସବେନ୍‌ ବିଷାଏରେ ଆଡଃଗି ପୁରାଃତେ କାଜି ନାଙ୍ଗ୍‌ ଇନ୍‌କିନ୍‌କେ ବିନ୍ତିକେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ହଡ଼କ ପାଞ୍ଚେଟ୍‌ ବାଗିକେଦ୍‌ତେ ସେନଃୟାନ୍‌ ତାୟମ୍‌ତେ, ପୁରାଃ ଯିହୁଦୀ ଆଡଃ ସାଅଁସାର୍‌ହେତେ ଯିହୁଦୀ ଧାରାମ୍‌ତେ ବାଦ୍‌ଲାଅକାନ୍‌ ହଡ଼କ, ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌କେ ଅତଙ୍ଗ୍‌କେଦ୍‌କିନାକ । ପ୍ରେରିତ୍‌କ ଇନ୍‌କୁଲଃ ଜାଗାର୍‌କେଦାକ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାୟାଦ୍‌ତେ ଜୀଦାନ୍‌ ବିତାଅ ନାଗେନ୍ତେ ଉସ୍‍କୁର୍‍କେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ଏଟାଃ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ, ସାହାର୍‌ରେନ୍‌ ଲାଗ୍‌ଭାଗ୍‌ ସବେନ୍‌ ହଡ଼କ ପ୍ରାଭୁଆଃ ବାଚାନ୍‌ ଆୟୁମ୍‌ ନାଗେନ୍ତେକ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ଯିହୁଦୀ ହଡ଼କ ଗାଦେଲ୍‌ ହଡ଼କକେ ନେଲ୍‌କେଦ୍‌ତେ ହିସ୍‌ଙ୍ଗାତେ ପେରେଃୟାନାକ ଆଡଃ ପାଉଲୁସ୍‌ଆଃ କାଜିରେ କାଜିକଟଙ୍ଗ୍‌କେଦ୍‌ତେ ଇନିଃକେ ଲାନ୍ଦାକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ମେନ୍‌ଦ ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃଗି ବେଗାର୍‌ ବରତେ କାଜିକେଦାକିନ୍‌, “ଆପେତାଃରେ ପାହିଲାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ କାଜିୟଃ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା । ମେନ୍‌ଦ ଆପେ ଜାନାଅ ଜୀଦାନ୍‌ ନାମେକାଲେ ମେନ୍ତେ କାପେ ବିଚାର୍‌କେଦ୍‌ ହରାତେ, ଆଲିଙ୍ଗ୍‌ ଆପେକେ ବାଗିକେଦ୍‌ତେ ସାଅଁସାର୍‌ ହଡ଼କତାଃତେଲିଙ୍ଗ୍‌ ସେନା । ");
INSERT INTO unx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ଚିଆଃଚି ପ୍ରାଭୁ ଆଲିଙ୍ଗ୍‌କେ ନେ ଲେକାଏ ଆଚୁକାଦ୍‌ଲିୟାଁ, “‘ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ସାଅଁସାର୍‌ ହଡ଼କଆଃ ନାଗେନ୍ତେ ମାର୍ସାଲ୍‌ ଲେକାଇଙ୍ଗ୍‌ ବାଇୟାକାଦ୍‌ମା, ଜେ'ଲେକାଚି ସବେନ୍‌ ଅତେଦିଶୁମ୍‌ରେ ଜୀଉବାଞ୍ଚାଅ ନାମଃଆ ।’” ");
INSERT INTO unx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ସାଅଁସାର୍‌ ହଡ଼କ ନେଆଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ରାସ୍‌କାୟାନାକ ଆଡଃ ପ୍ରାଭୁଆଃ କାନାଜି ନାଗେନ୍ତେ ମାନାରାଙ୍ଗ୍‌କେଦାକ । ଅକ ହଡ଼କ ଜାନାଅ ଜୀଦାନ୍‌ ନାମେ ନାଗେନ୍ତେ ସାଲାୟାନାକ, ଇନ୍‌କୁ ଏନ୍‌ କାନାଜିରେ ବିଶ୍ୱାସ୍‌କେଦାକ ଆଡଃ ବିଶ୍ୱାସୀ ହବାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ପ୍ରାଭୁଆଃ ବାଚାନ୍‌ ଏନ୍‌ ପାର୍‌ଗାନ୍‌ରେୟାଃ ସବେନ୍‌ସାଃରେ ନିତିର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ମେନ୍‌ଦ ନାଗାର୍‌ରେନ୍‌ ଆଗୁଆଇ ହଡ଼କକେ ଆଡଃ ସାମାଜ୍‌ରେ ମାଇନ୍‌ ନାମେତାନ୍‌ ସାଅଁସାର୍‌ କୁଡ଼ିକ, ଅକନ୍‌କଚି ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରଭାକ୍ତିତାନାକ, ଇନ୍‌କୁକେ ଯିହୁଦୀ ହଡ଼କ ଉସ୍‌କୁର୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌କିନାଃ ବିରୁଧ୍‌ରେ ସାସାତି ଏଟେଦ୍‌କେଦାକ ଆଡଃ ଇନ୍‌କିନ୍‌କେ ଏନ୍‌ ପାର୍‌ଗାନ୍‌ତାଃଏତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ପ୍ରେରିତ୍‌କିନ୍‌ ଆକିନାଃ କାଟାରେୟାଃ ଧୁଡ଼ି ଇନ୍‌କୁଆଃ ବିରୁଧ୍‌ରେ କଟାବାଗିକେଦ୍‌ତେ ଇକନିୟାତେକିନ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଆଡଃ ଆନ୍ତିୟୋଖ୍‌ରେନ୍‌ ବିଶ୍ୱାସୀକ ପାବିତାର୍‌ ଆତ୍ମା ଆଡଃ ରାସ୍‌କାତେ ପେରେଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଇକନିୟାରେ ଏନ୍‌ଲେକାଗି ହବାୟାନା, ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃତେ ସେନ୍‌କେନାକିନ୍‌ ଆଡଃ ନେ'ଲେକା କାଜିକେଦାକିନ୍‌ ଯେ, ପୁରାଃ ଯିହୁଦୀ ହଡ଼କ ଆଡଃ ସାଅଁସାର୍‌ ହଡ଼କ ଖ୍ରୀଷ୍ଟ୍‌ତାଃରେ ବିଶ୍ୱାସ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ମେନ୍‌ଦ କା ବିଶ୍ୱାସ୍‌ତାନ୍‌ ଯିହୁଦୀକ ସାଅଁସାର୍‌ ହଡ଼କଆଃ ମନ୍‌କେ ଉସ୍‌କୁର୍‌କେଦ୍‌ତେ ବିଶ୍ୱାସୀକଆଃ ବିରୁଧ୍‌ରେ ଖିସ୍‌ରିକାକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ଏନ୍‌ରେୟ ପ୍ରେରିତ୍‌କିନ୍‌ ବେଗାର୍‌ ବରତେ ପ୍ରାଭୁଆଃ ବିଷାଏ ଏନ୍ତାଃରେ ଉଦୁବ୍‌କେଦାକିନ୍‌ ଆଡଃ ପୁରାଃ ଦିନ୍‌ ତାଇନ୍‌ୟାନାକିନ୍‌ । ଇନ୍‌କିନ୍‌ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ଆଡଃ ଆକ୍‌ଚାକାଅ କାମିକ ରିକାକେଦ୍‌ ହରାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାୟାଦ୍‌ତେ ନାମାକାନ୍‌ ପେଡ଼େଃ ବିଷାଏରେ କାଜିକେଦ୍‌ କାନାଜିକ ସାର୍‌ତି ତାନାଃ ମେନ୍ତେ ସାବୁଦ୍‌କିନ୍‌ ଏମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ନାଗାର୍‌ରେନ୍‌ ହଡ଼କ ବାର୍‌ହିସାରେ ବିନ୍‌ଗାଅୟାନାକ, ଇନ୍‌କୁଏତେ ଚିମିନ୍‌ ହଡ଼କ ଯିହୁଦୀ ହଡ଼କସାଃତେ ଆଡଃ ଚିମିନ୍‌ ହଡ଼କ ପ୍ରେରିତ୍‌କିନାଃ ସାଃତେ ହବାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ଏନ୍ତେ ଚିମିନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କ ଆଡଃ ଯିହୁଦୀ ହଡ଼କ ଆକଆଃ ଆଗୁଆଇକଲଃ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିକେଦ୍‌ତେ ହାଲାଗୁଲାତାନ୍‌ଲଃ ପ୍ରେରିତ୍‌କିନ୍‌କେ ଦିରିଲଃ ଚିଦ୍‌ଗିକେଦ୍‌ତେ ଗଏଃ ନାଗେନ୍ତେ ଉହାଟ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ପ୍ରେରିତ୍‌କିନ୍‌ ଏନ୍‌ ବିଷାଏରେ ସାରିକେଦ୍‌ତେ ଲୁକାୟନିଆ ଜିଲ୍ଲାରେୟାଃ ଲୁସ୍‌ତ୍ରା ଆଡଃ ଦର୍ବୀ ସାହାର୍‌ରେୟାଃ ଚାରିୟସାଃରେ ତାଇକାନ୍‌ ପାର୍‌ଗାନ୍‌ତେକିନ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ଆଡଃ ଏନ୍ତାଃରେ ସୁକୁକାଜିକିନ୍‌ ଉଦୁବ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍‌ତ୍ରାରେ ମିଆଁଦ୍‌ ଜାନାମ୍‌ହେତେ କାଟା କୁଚୁଙ୍ଗ୍‌କାନ୍‌ ହଡ଼ ତାଇକେନାଏ । ଇନିଃ ଚିଉଲାଅ କାଏ ସେନ୍‌ ଦାଡ଼ିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ଇନିଃ ଏନ୍ତାଃରେ ଦୁବ୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌ଆଃ କାଜି ଆୟୁମ୍‌ ତାଇକେନା । ପାଉଲୁସ୍‌ ଇନିଃକେ ମିଦ୍‌ ନାଜେର୍‌ରେ ନେଲ୍‌କେଦ୍‌ତେ, ବୁଗିୟଃ ନାଗେନ୍ତେ ଇନିୟାଃ ମନ୍‌ରେ ବିଶ୍ୱାସ୍‌ ହବାକାନା ମେନ୍ତେ ଆଟ୍‌କାର୍‌କେଦା, ");
INSERT INTO unx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ଆଡଃ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, “କାଟାରେ ପେଡ଼େଃ ଏମ୍‌କେଦ୍‌ତେ ତିଙ୍ଗୁନ୍‌ମେ !” ଏନ୍‌ ହଡ଼ ଡେଗାଅତାନ୍‌ଲଃ ଚାରିୟସାଃ ସେନ୍‌ ଏଟେଦ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ଏନ୍ତାଃରେ ତାଇକାନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ପାଉଲୁସ୍‌ଆଃ ନେ କାମି ନେଲ୍‌କେଦ୍‌ତେ, ଆକଆଃ ଲୁକାୟନିଆ ଜାଗାର୍‌ତେ କାଉରିତାନ୍‌ଲଃ କାଜି ଏଟେଦ୍‌କେଦାକ, “ମାହାପୁରୁକ ହଡ଼ ଲେକା ହବାକେଦ୍‌ତେ ଆବୁତାଃତେ ହିଜୁଃକାନାକ ।” ");
INSERT INTO unx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ଇନ୍‌କୁ ବର୍ଣ୍ଣବାସ୍‌କେ ଜିଅସ୍‌ ଆଡଃ ପାଉଲୁସ୍‌ ମୁଲ୍‌ କାଜିନିଃ ହବାକାନ୍‌ ହରାତେ ଇନିଃକେ ହେର୍‌ମିସ୍‌ ମେନ୍ତେକ ନୁତୁମ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ନାଗାର୍‌ରେୟାଃ ବାହାରିରେ ତାଇକାନ୍‌ ଜିଅସ୍‌ ମାନ୍ଦିର୍‌ରେନ୍‌ ଯାଜାକ୍‌, ଦୁଆର୍‌ ଜାପାଃତେ ଚିମିନ୍‌ ସାଁଣ୍‌କକେ ଆଡଃ ଗାଲାଙ୍ଗ୍‌କାନ୍‌ ବାହା ଆଉକେଦାଏ, ଚିଆଃଚି ଇନିଃ ଆଡଃ ଏନ୍ତାଃରେ ହୁଣ୍ଡିୟାକାନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କ ପ୍ରେରିତ୍‌କିନାଃ ନାଗେନ୍ତେ ଦାଣେଁ ରାକାବ୍‌ ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ଇନ୍‌କୁ ଅକ କାମି ନାଗେନ୍ତେକ କୁଲାକାନ୍‌ ତାଇକେନା, ଏନା ଆୟୁମ୍‌କେଦ୍‌ତେ ପ୍ରେରିତ୍‌କିନ୍‌ ଚାଏ ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃ ପାଉଲୁସ୍‌ ପୁରାଃଗି ଦୁକୁୟାନାକିନ୍‌ ଆଡଃ ଆକିନାଃ ଲିଜାଃ ଚେଚାଃକେଦ୍‌ତେ ଗାଦେଲ୍‌ ହଡ଼କଆଃ ଥାଲାତେ ନିର୍‌କେଦାକିନ୍‌ ଆଡଃ କାଉରିକେଦ୍‌ତେ କାଜିକେଦାକିନ୍‌, ");
INSERT INTO unx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ଆପେ ଚିନାଃମେନ୍ତେ ନେଆଁ ରିକାତାନାପେ ? ଆଲିଙ୍ଗ୍‌ହ ଆପେ ଲେକାଗି ହଡ଼ ତାନ୍‌ଲିଙ୍ଗ୍‌ । ଆପେ ଜେ'ଲେକାଚି ନେ ସବେନ୍‌ ସାମା ସାମାରେନ୍‌ ମାହାପୁରୁକକେ ବାଗିକେଦ୍‌ତେ ଜୀନିଦ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌, ଅକଏଚି ସିର୍ମା, ଅତେ, ଦରେୟା ଆଡଃ ଏନାରେ ତାଇନ୍‌ତାନ୍‌ ସବେନାଃକେ ବାଇୟାକାଦ୍‌ନିଃ ସାଃତେ ରୁହାଡ଼ାଃପେ । ଏନାମେନ୍ତେ ଆଲିଙ୍ଗ୍‌ ଆପେତାଃରେ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ ହିଜୁଃକାନାଲିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ପାର୍‌ମେଶ୍ୱାର୍‌ ସିଦା ପାରିୟାରେନ୍‌ ସବେନ୍‌ ହଡ଼କକେ ଆକଆଃ ଇଛାସାନାଙ୍ଗ୍‌ ଲେକାଏ ସେସେନ୍‌ଇଚିକାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ମେନ୍‌ଦ ଆୟାଃ ବୁଗିନ୍‌ କାମି ହରାତେ ସବେନ୍‌ ଇମ୍‌ତା ମେନାଇୟା ମେନ୍ତେ ସାବୁଦ୍‌ ଏମାକାଦାଏ । ଇନିଃ ସିର୍ମାଏତେ ଗାମାଦାଆଃ ଆଡଃ ଠାଉକାନ୍‌ ନେଡାରେ ଆଡ଼ାଃ ସାକାମ୍‌ ଜ'କଏ ଏମାଃ, ଇନିଃ, ଜମେୟାଁ ଆଡଃ ଆପେୟାଃ ମନ୍‌ସୁରୁଦ୍‌କେ ରାସ୍‌କାତେ ପେରେଜାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ପ୍ରେରିତ୍‌କିନ୍‌ ନେ'ଲେକା ପୁରାଃଗି ଚିମିନ୍‌ କାଜିକ କାଜିକେଦ୍‌ତେ ଏନ୍‌ ଗାଦେଲ୍‌ ହଡ଼କକେ ଦାଣେଁ ରାକାବ୍‌ହେତେ ହକାକେଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ମେନ୍‌ଦ ଚିମିନ୍‌ ଯିହୁଦୀକ ପିସିଦିଆରେୟାଃ ଆନ୍ତିୟୋଖ୍‌ ଆଡଃ ଇକନିୟାହେତେ ହିଜୁଃକାନ୍‌ ତାଇକେନାକ, ଇନ୍‌କୁ ଗାଦେଲ୍‌ ହଡ଼କକେ ଉସ୍‍କୁର୍‍କେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ ଦିରିତେ ଚିଦ୍‌ଗିକିୟାକ ଆଡଃ ଇନିଃ ଗଏଃୟାନାଏ ମେନ୍ତେ ଉଡ଼ୁଃକେଦ୍‌ତେ ସାହାର୍‌ରେୟାଃ ବାହାରିତେ ଅର୍‌ ଇଦିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ମେନ୍‌ଦ ବିଶ୍ୱାସୀକ ହିଜୁଃକେଦ୍‌ତେ ଆୟାଃ ଚାରିୟସାଃରେ ହୁଣ୍ଡି ବିୟୁର୍‌କିୟାକ ଏନ୍ତେ ଇନିଃ ତିଙ୍ଗୁକେଦ୍‌ତେ ସାହାର୍‌ତେ ରୁହାଡ଼୍‌ୟାନା । ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଇନିଃ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ ଦର୍ବୀତେକିନ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ ଦର୍ବୀରେ ସୁକୁକାଜି ଉଦୁବ୍‌କେଦ୍‌ତେ ପୁରାଃ ଚେଲାକକିନ୍‌ ବାଇକେଦ୍‌କଆ । ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ଲୁସ୍‌ତ୍ରା, ଇକନିୟା ଆଡଃ ପିସିଦିଆରାଃ ଆନ୍ତିୟୋଖ୍‌ତେକିନ୍‌ ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ଆଡଃ ଇନ୍‌କିନ୍‌ ଏନ୍ତାଃରେନ୍‌ ବିଶ୍ୱାସୀକକେ ଆକଆଃ ସାର୍‌ତି ବିଶ୍ୱାସ୍‌ରେ କେଟେୟଃ ନାଗେନ୍ତେ ଆଡଃ ଜୀଉରେ ରାସ୍‌କାଅଃ ନାଗେନ୍ତେ ଇନ୍‌କୁକେ ଇତୁକେଦ୍‌ତେ କାଜିକେଦ୍‌କଆକିନ୍‌, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ରେ ବଲ ନାଗେନ୍ତେ ଆବୁକେ ପୁରାଃ ଦୁକୁ ସାହାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ସେନ୍‌ ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ଇନ୍‌କିନ୍‌ ସବେନ୍‌ କାଲିସିୟାରେ ପ୍ରାଚିନ୍‌କକେ ସାଲାକେଦ୍‌କଆକିନ୍‌ ଆଡଃ କାଟାବ୍‌ତାନ୍‌ଲଃ ବିନ୍ତିକେଦାକିନ୍‌, ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ଅକ ପ୍ରାଭୁତାଃରେ ବିଶ୍ୱାସ୍‌କାଦାକିନ୍‌, ଇନିଃତାଃରେ ଇନ୍‌କୁକେ ଜିମାକେଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ତାୟମ୍‌ତେ ଇନ୍‌କିନ୍‌ ପିସିଦିଆ ପାର୍‌ଗାନ୍‌ ହରାତେ ସେନ୍‌କେଦ୍‌ତେ ପାମ୍ପିଲିଆ ଜିଲ୍ଲାତେକିନ୍‌ ହିଜୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ଏନ୍ତାଃରେୟାଃ ପେର୍‌ଗା ସାହାର୍‌ରେ ବାଚାନ୍‌ ଉଦୁବ୍‌କେଦ୍‌ତେ ଆତ୍ତାଲିଆ ସାହାର୍‌ତେକିନ୍‌ ସେନଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ଆଡଃ ଏନ୍ତାଃଏତେ ଇନ୍‌କିନ୍‌ ଦାଆଃ ଜାହାଜ୍‌ତେ ଆନ୍ତିୟୋଖ୍‌ତେ ସେନଃ ରୁହାଡ଼୍‌ୟାନାକିନ୍‌, ନେ ଆନ୍ତିୟୋଖ୍‌ରେ ନାହାଁଃ ହବାକାନ୍‌ କାମି ନାଗେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାୟାଦ୍‌ ହରାତେ ଇନ୍‌କିନ୍‌ ଜିମାକାନ୍‌ ତାଇକେନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ଇନ୍‌କିନ୍‌ ଆନ୍ତିୟୋଖ୍‌ରେ ସେଟେର୍‌କେଦ୍‌ତେ କାଲିସିୟାରେନ୍‌ ହଡ଼କକେ ହୁଣ୍ଡିକେଦ୍‌କଆକିନ୍‌ । ପାର୍‌ମେଶ୍ୱାର୍‌ ଇନ୍‌କିନାଃ ନାଗେନ୍ତେ ରିକାକାଦ୍‌ ତାଇକେନ୍‌ତେୟାଃ ଆଡଃ ସାଅଁସାର୍‌ ହଡ଼କଆଃ ବିଶ୍ୱାସ୍‌ ନାଗେନ୍ତେ ଚିଲ୍‌କା ହରାକଏ ଉଦୁବ୍‌କାଦ୍‌ ତାଇକେନା, ଏନ୍‌ ସବେନାଃ ଇନ୍‌କୁକେକିନ୍‌ ଉଦୁବାଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ଆନ୍ତିୟୋଖ୍‌ରେ ବିଶ୍ୱାସୀକଲଃ ପୁରାଃ ଦିନ୍‌କିନ୍‌ ତାଇନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଯିହୁଦାଏତେ ଚିମିନ୍‌ ହଡ଼କ ଆନ୍ତିୟୋଖ୍‌ତେ ହିଜୁଃକେଦ୍‌ତେ, ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁ ଲେକାତେ ଇନ୍‌କୁ କାକ ଖାତ୍‌ନାଅଃରେଦ ଜୀଉବାଞ୍ଚାଅ କାକ ନାମେୟା ମେନ୍ତେ ବିଶ୍ୱାସୀକକେ ଇତୁକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ନେ ବିଷାଏରେ ଇନ୍‌କୁଲଃ ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ଆଃ ପୁରାଃଗି କାପ୍‌ଜି ହବାୟାନା, ଏନାତେ ପାଉଲୁସ୍‌, ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃ ଆନ୍ତିୟୋଖ୍‌ରେନ୍‌ ଚିମିନ୍‌ ହଡ଼କ ଯୀରୁଶାଲେମ୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ପ୍ରେରିତ୍‌ ଆଡଃ କାଲିସିୟାରେନ୍‌ ପ୍ରାଚିନ୍‌କଲଃ ନେ ବିଷାଏରେ କାଜିଅଡଙ୍ଗ୍‌ଅଃକା ମେନ୍ତେକ ଉହାଟ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","କାଲିସିୟାରେନ୍‌ ହଡ଼କ ଇନ୍‌କିନାଃ ହରାସେନ୍‌ ନାଗେନ୍ତେକ ଦେଙ୍ଗାକେଦ୍‌କିନା, ଆଡଃ ଇନ୍‌କିନ୍‌ ଫିନିସିୟା ଆଡଃ ଶମିରୋନ୍‌ ହରାତେ ସେନଃ ଇମ୍‌ତା, ସାଅଁସାର୍‌ ହଡ଼କ ଚିଲ୍‌କା ହେୟାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ସାଃତେକ ରୁହାଡ଼୍‌କାନା, ଏନ୍‌ ବିଷାଏରେକିନ୍‌ ଉଦୁବ୍‌କେଦ୍‌କଆ; ନେ କାନାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ବିଶ୍ୱାସୀକ ପୁରାଃଗିକ ରାସ୍‌କାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ଇନ୍‌କିନ୍‌ ଯୀରୁଶାଲେମ୍‌ତେ ସେଟେର୍‌ୟାନ୍‌ଚି, କାଲିସିୟାରେନ୍‌ ହଡ଼କ, ପ୍ରେରିତ୍‌କ ଆଡଃ ପ୍ରାଚିନ୍‌କ ଇନ୍‍କିନ୍‍କେକ ଦାରମ୍‌କେଦ୍‌କିନା । ପାର୍‌ମେଶ୍ୱାର୍‌ ଆକିନାଃଲଃ ତାଇକେଦ୍‌ତେ କାମିକାଦ୍‌ ସବେନ୍‌ କାମିକ ଇନ୍‌କିନ୍‌ ଇନ୍‌କୁକେ ଉଦୁବ୍‌କେଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ମେନ୍‌ଦ ଫାରୁଶୀ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ଚିମିନ୍‌ ବିଶ୍ୱାସୀ ହଡ଼କ ତିଙ୍ଗୁକେଦ୍‌ତେ କାଜିକେଦାକ, “ସାଅଁସାର୍‌ ହଡ଼କଆଃ ଖାତ୍‌ନାଅ ହବାଅଃଗି ଲାଗାତିୟାଁ ଆଡଃ ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁକେ ମାନାତିଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଇନ୍‌କୁକେ କାଜି ଲାଗାତିୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ନେ ବିଷାଏରେ ଜାଗାର୍‌ ନାଗେନ୍ତେ ପ୍ରେରିତ୍‌କ ଆଡଃ ପ୍ରାଚିନ୍‌କ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ପୁରାଃଗି କାପ୍‌ଜିୟାନ୍‌ ତାୟମ୍‌ତେ ପାତ୍‌ରାସ୍‌ ତିଙ୍ଗୁକେଦ୍‌ତେ କାଜିକେଦା, “ହେ ହାଗା ମିଶିକ, ଆଇଙ୍ଗ୍‌ ସାଅଁସାର୍‌ ହଡ଼କତାଃରେ ସୁକୁକାଜି ଉଦୁବେକାଇଙ୍ଗ୍‌ ଆଡଃ ଇନ୍‌କୁ ଏନାରେକ ବିଶ୍ୱାସେକା ମେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଇଙ୍ଗ୍‌କେ ଆପେକଏତେ ପୁରାଃ ମାହାଁ ସିଦାରେ ସାଲାକାଦିୟାଁ, ଏନାଦପେ ସାରିତାନା । ");
INSERT INTO unx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ଆଡଃ ସବେନ୍‌କଆଃ ମନ୍‌ସୁରୁଦ୍‌ରେୟାଃ ଉଡ଼ୁଃ ସାରି ଦାଡ଼ିତାନ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌, ଆବୁକେ ଜେ'ଲେକା ପାବିତାର୍‌ ଆତ୍ମା ଏମାକାଦ୍‌ବୁଆଏ, ଏନ୍‌ଲେକାଗି ସାଅଁସାର୍‌ ହଡ଼କକେହ ଏମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁସାଃଏତେ ଗାୱାଏ ଏମାକାଦା । ");
INSERT INTO unx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ଇନ୍‌କୁଆଃ ଆଡଃ ଆବୁଆଃ ଥାଲାରେ ଜେତାନ୍‌ ଫାରାକ୍‌ କାଏ ଦହକାଦା । ଇନ୍‌କୁଆଃ ବିଶ୍ୱାସ୍‌ ହରାତେ ଇନିଃ ଇନ୍‌କୁଆଃ ମନ୍‌ସୁରୁଦ୍‌କଏ ଫାର୍‌ଚିକାଦା । ");
INSERT INTO unx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ତାବ୍‌ଦ ଯିହୁଦୀକଆଃ ରିତିରିୱାଜ୍‌ ଆଡଃ ଆନ୍‌ଚୁ, ଅକ୍‌ନାଃଚି ହାମ୍ବାଲ୍‌ ବାହାରମ୍‌ ଲେକାନାଃତାନାଃ, ଏନାକେ ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କ ଆଡଃ ଆବୁ କାବୁ ଗଅଃ ଦାଡ଼ିକେନା, ଏନ୍‌ ଆଡ଼୍‌ନାକେ ନାହାଁଃ ଆପେ ବିଶ୍ୱାସୀକଆଃ ତାରାନ୍‌ରେ ଲାଦିକେଦ୍‌ତେ ଚିନାଃମେନ୍ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବିଡ଼ାଅ ନାଗେନ୍ତେପେ ସାନାଙ୍ଗ୍‌ତାନା ? ");
INSERT INTO unx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","କାହାଗି, ଏନା କା ବୁଗିନାଃ । ଇନ୍‌କୁ ଜେ'ଲେକା ବିଶ୍ୱାସ୍‌କେଦ୍‌ତେ ଜୀଉବାଞ୍ଚାଅକ ନାମାକାଦା, ଏନ୍‌ ଲେକାଗି ଆବୁହ ବିଶ୍ୱାସ୍‌କେଦ୍‌ତେ ପ୍ରାଭୁ ୟୀଶୁଆଃ ସାୟାଦ୍‌ତେ ଜୀଉବାଞ୍ଚାଅବୁ ନାମାକାଦା ।” ");
INSERT INTO unx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ଆଃ ହରାତେ ସାଅଁସାର୍‌ ହଡ଼କଆଃ ଥାଲାରେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଅକ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକ ଆଡଃ ଆକ୍‌ଚାକାଅ କାମିକ କାମିକାଦ୍‌ ତାଇକେନାଏ । ଏନାକ ଇନ୍‌କିନ୍‌ତାଃଏତେ ଆୟୁମ୍‌କେଦ୍‌ତେ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ସବେନ୍‌କ ହାପାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ଇନ୍‌କିନ୍‌ କାଜି ଚାବାକେଦ୍‌ଚି, ଯାକୁବ୍‌ କାଜିକେଦାଏ, “ହେ ହାଗା ମିଶିକ, ଆଇଁୟାଃ କାଜି ଆୟୁମେପେ ! ");
INSERT INTO unx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ପାର୍‌ମେଶ୍ୱାର୍‌ ଚିଲ୍‌କା ଆୟାଃ ଲିନିବୁଇ ସାଅଁସାର୍‌ ହଡ଼କଏତେ ଚିମିନ୍‌କକେ ଆୟାଃ ନୁତୁମ୍‌ ନାଗେନ୍ତେ ସାଲାକାଦ୍‌କଆ, ଏନ୍‌ କାଜିକେ ଶିମୋନ୍‌ ଉଦୁବ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ନାବୀକଆଃ କାଜି ନେ କାଜିଲଃ ପୁରା ମେସାଅଃତାନା । ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା; ");
INSERT INTO unx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘ପ୍ରାଭୁ କାଜିୟାଃଏ, ନେ ତାୟମ୍‌ତେ ଆଇଙ୍ଗ୍‌ ହିଜୁଃ ରୁହାଡ଼ାଇଙ୍ଗ୍‌ ଆଡଃ ଦାଉଦ୍‌ଆଃ ତାଇନଃ ଠାୟାଦ୍‌କେ ଆଡଃମିସା ବାଇରୁହାଡ଼େୟାଇଙ୍ଗ୍‌ । ଆଇଙ୍ଗ୍‌ ଏନ୍‌ ଜିୟନ୍‌କାନ୍‌ତେୟାଃକେ ଆଡଃମିସା ବାଇରୁହାଡ଼େୟାଇଙ୍ଗ୍‌ ଆଡଃ ଏନାକେ କେଟେଦ୍‌ ରୁହାଡ଼େୟାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ଆଡଃ ସବେନ୍‌ ମାନୱା ହଡ଼କ ଆଇଙ୍ଗ୍‌ତାଃତେକ ହିଜୁଃଆ, ଆଇଙ୍ଗ୍‌ ଅକ ସାଅଁସାର୍‌ ହଡ଼କକେ ଆଇଁୟାଃ ହବାଅଃ ନାଗେନ୍ତେଇଙ୍ଗ୍‌ କେଡ଼ାକାଦ୍‌କଆ, ଇନ୍‌କୁ ସବେନ୍‌କ ଆଇଁୟାଃତାନ୍‌କ ମେନ୍ତେ ପ୍ରାଭୁ କାଜିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ନେ କାଜିକେ ପ୍ରାଭୁ, ନାଙ୍କ ପାରିୟାଏତେ କାଜିକାଦ୍‌ ତାଇକେନା ।’ ");
INSERT INTO unx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ଯାକୁବ୍‌ ଆଡଃଗି କାଜିକେଦା, ଆଇଁୟାଃ ବିଚାର୍‌ ନେଆଁତାନାଃ, ଅକ ସାଅଁସାର୍‌ ହଡ଼କ ପାର୍‌ମେଶ୍ୱାର୍‌ସାଃତେ ରୁହାଡ଼୍‌ତାନାକ, ଇନ୍‌କୁକେ ଆବୁ କାବୁ ହାଏରାନ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ମେନ୍‌ଦ ଇନ୍‌କୁ ମୁରୁତ୍‌କତାଃରେ ଦାନ୍‌ ରାକାବାକାନ୍‌ ସତ୍‌ରା ଜମେୟାଁ ଆଲକାକ ଜମେକା, ଜେତା କଡ଼ା ଚାଏ କୁଡ଼ିଲଃ ହଡ଼୍‌ମରେୟାଃ ଏତ୍‌କାନ୍‌ କାମି ଆଲକାକ ରିକାଏକା, ହଟଃ ଲିମ୍ବୁଦ୍‌କେଦ୍‌ତେ ଗଜାକାନ୍‌ ଜାଁତୁରାଃ ମାସ୍‌ ଚାଏ ମାୟୋମ୍‌ ଆଲକାକ ଜମେକା ମେନ୍ତେ ନେ ସବେନ୍‌ ବିଷାଏରେ କାଜିକତାନ୍‌ଲଃ ଇନ୍‌କୁତାଃତେ ମିଆଁଦ୍‌ ଚିଟାଉବୁ ଅଲେୟା । ");
INSERT INTO unx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ଚିୟାଃଚି ପୁରାଃ ସିଦାଏତେଗି ସବେନ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁ ପାଢ଼ାଅଃତାନା, ଆଡଃ ସବେନ୍‌ ସାହାର୍‌ରେ ଇନିୟାଃ କାଜି ଉଦୁବଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ଏନ୍ତେ ପ୍ରେରିତ୍‌କ ଆଡଃ କାଲିସିୟାରେନ୍‌ ପ୍ରାଚିନ୍‌କ, ଆଡଃ କାଲିସିୟାରେନ୍‌ ସବେନ୍‌କ, ଝୁଣ୍ଡ୍‌ରେନ୍‌ ଚିମିନ୍‌ ହଡ଼କକେ ସାଲାକେଦ୍‌ତେ, ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ଲଃ ଇନ୍‌କୁକେ ଆନ୍ତିୟୋଖ୍‌ତେ କୁଲ୍‌ ନାଗେନ୍ତେକ ଉହାଟ୍‌କେଦା । ବାର୍ଶବାସ୍‌ ନୁତୁମ୍‌ତେ ସାରିୟଃତାନ୍‌ ଯିହୁଦା ଆଡଃ ସିଲାସ୍‌, ନେ ବାରାନ୍‌କିନ୍‌କେ ଇନ୍‌କୁ ସାଲାକେଦ୍‌କିନାକ ଆଡଃ ଇନ୍‌କିନ୍‌ ବିଶ୍ୱାସୀକଆଃ ଥାଲାରେ ପୁରାଃଗି ମାଇନଃତାନ୍‌କିନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ଆଡଃ ବିଶ୍ୱାସୀକ ନେ ଚିଟାଉକେ ଇନ୍‌କିନାଃ ତିଃଇରେ କୁଲ୍‌କେଦାକ । “ଆନ୍ତିୟୋଖ୍‌, ସିରିୟା ଆଡଃ କିଲିକିଆ ପାର୍‌ଗାନ୍‌ରେନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କଏତେ ହିଜୁଃକାନ୍‌ ହାଗାକକେ ପ୍ରେରିତ୍‌କ ଆଡଃ କାଲିସିୟାରେନ୍‌ ପ୍ରାଚିନ୍‌କ ଜହାର୍‌ ମେନ୍ତେକ କାଜିକୁଲ୍‌କାଦା । ");
INSERT INTO unx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ଆଲେ ଆୟୁମେତାନାଲେ ଯେ, ଆଲେୟାଃ ଝୁଣ୍ଡ୍‌ହେତେ ଚିମିନ୍‌ ହଡ଼କ ଆପେତାଃତେ ସେନ୍‌କେଦ୍‌ତେ ଆପେୟାଃ ମନ୍‌ରେ ଦୁକୁଃଲେକାନ୍‌ କାଜିକ କାଜିକାଦା । ମେନ୍‌ଦ ଏନ୍‌ ବିଷାଏରେ ଆଲେ ଇନ୍‌କୁକେ କାଜି ନାଙ୍ଗ୍‌ ଜେତ୍‌ନାଃ କାଲେ ଆଚୁକାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ଆଡଃ ଆଲେ ସବେନ୍‌କ ମିଦ୍‌ ମନ୍‌ୟାନ୍‌ଲଃ ଚିମିନ୍‌ ଝାନ୍‌ କାଜିକୁଲ୍‌କକେ ସାଲାକେଦ୍‌ତେ ଆପେତାଃତେ କୁଲ୍‌ ନାଗେନ୍ତେଲେ ଉହାଟ୍‌କାଦା । ଇନ୍‌କୁ ଆବୁଆଃ ଦୁଲାଡ଼୍‌ ହାଗା ବର୍ଣ୍ଣବାସ୍‌ ଆଡଃ ପାଉଲୁସ୍‌ଲଃ ସେନାଃକ । ");
INSERT INTO unx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଇନ୍‌କିନ୍‌ ଆକିନାଃ ଜୀଦାନ୍‌କେ ପ୍ରାଭୁ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ନୁତୁମ୍‌ ନାଙ୍ଗ୍‌ ସାଙ୍କାଟ୍‌ରେ ଉୟୁଃକାଦାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ଆଲେ ଯିହୁଦା ଆଡଃ ସିଲାସ୍‌କେ ଆପେତାଃତେ କୁଲ୍‌କିନ୍‌ତାନାଲେ । ଆଲେ ଅକ୍‌ନାଃ ଅଲାକାଦାଲେ ଏନାକେଗି ଇନ୍‌କିନ୍‌ ଆପେକେ ଉଦୁବାପେୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ଚିମିନାଙ୍ଗ୍‌ ଲାଗାତିଙ୍ଗ୍‌ ଆଇନ୍‌କ ବାଗିକେଦ୍‌ତେ ଆପେ ଚେତାନ୍‌ରେ ଜେତାନ୍‌ ବାହାରମ୍‌ କା ଏମ୍‌ ନାଗେନ୍ତେ ଆଲେ ପାବିତାର୍‌ ଆତ୍ମାତାଃଏତେ ଆନାଚୁଲେ ନାମାକାଦା । ");
INSERT INTO unx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ଆପେ ମୁରୁତ୍‍କଆଃ ଆୟାର୍‌ରେ ଦାନ୍‌ ରାକାବାକାନ୍‌ ଜଜମାଃ ଆଲପେ ଜମେୟାଁ, ମାୟୋମ୍‌ ଆଲପେ ନୁଁଇଆ, ହଟଃ ଲିମ୍ବୁଦ୍‌କେଦ୍‌ତେ ଗଜାକାଇ ଜେତା ଜାଁତୁରାଃ ମାସ୍‌ ଆଲପେ ଜମେୟାଁ ଆଡଃ ଜେତା କଡ଼ା ଚାଏ କୁଡ଼ିଲଃ ହଡ଼୍‌ମରେୟାଃ ଏତ୍‌କାନ୍‌ କାମିକଏତେ ସାଙ୍ଗିନାକାନ୍‌ ତାଇନ୍‌ପେ । ଆପେ ନେ ସବେନ୍‌ କାମିକ କାପେ କାମିରେଦ ଆପେୟାଃ ବୁଗିନାଃ ହବାଅଃଆ । ଆଲେୟାଃ ଜହାର୍‌ ତେଲାଏପେ ।” ");
INSERT INTO unx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ଅକ କାଜିକୁଲ୍‌କିନ୍‌କେ କୁଲାକାନ୍‌ ତାଇକେନା, ଇନ୍‌କିନ୍‌ ଆନ୍ତିୟୋଖ୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ବିଶ୍ୱାସୀକଆଃ ସବେନ୍‌ ଝୁଣ୍ଡ୍‌କକେ ହୁଣ୍ଡିକେଦ୍‌ତେ ନେ ଚିଟାଉକେ ଏମାଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ଏନ୍ତାଃରେନ୍‌ ବିଶ୍ୱାସୀକ ଜୀଉରେ ରାସ୍‌କାନ୍‌ କାଜି ଚିଟାଉରେ ପାଢ଼ାଅକେଦ୍‌ତେ ରାସ୍‌କାତେ ପେରେଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଯିହୁଦା ଆଡଃ ସିଲାସ୍‌ ଆକିନ୍‌ଗି ନାବୀ ତାଇକେନାକିନ୍‌ ଆଡଃ ଇନ୍‌କିନ୍‌ ଆନ୍ତିୟୋଖ୍‌ରେନ୍‌ ବିଶ୍ୱାସୀକକେ ପୁରାଃ ନେଡା ଜାକେଦ୍‌ ଜାଗାର୍‌ତାନ୍‌ଲଃ ଇନ୍‌କୁକେ ଜୀଉରେ ରାସ୍‌କାନ୍‌ କାଜିକ ଏମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଆଃ ବିଶ୍ୱାସ୍‌କେ କେଟେଦ୍‌କେଦାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଏନ୍ତାଃରେ ଚିମିନ୍‌ ମାହାଁ ତାଇନ୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ ଅକ ହଡ଼କ ଇନ୍‌କିନ୍‌କେ କୁଲାକାଦ୍‌କିନ୍‌ ତାଇକେନାକ, ଇନ୍‌କୁତାଃ ସେନ୍‌ରୁହାଡ଼୍‌ ନାଗେନ୍ତେ ବିଶ୍ୱାସୀକ ଇନ୍‌କିନ୍‌କେ ସୁକୁଜୀଉତେ କୁଲ୍‌କେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ମେନ୍‌ଦ ସିଲାସ୍‌ ଏନ୍ତାଃରେ ତାଇନଃ ନାଗେନ୍ତେ ବୁଗିନାଃ ଆଟ୍‌କାର୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ପାଉଲୁସ୍‌ ଆଡଃ ବର୍ଣ୍ଣବାସ୍‌ ଆନ୍ତିୟୋଖ୍‌ରେ ଚିମିନ୍‌ ଦିନ୍‌ ତାଇନ୍‌ୟାନାକିନ୍‌ ଆଡଃ ଏଟାଃ ପୁରାଃ ହଡ଼କଲଃ ମେସାକେଦ୍‌ତେ ପ୍ରାଭୁଆଃ ବାଚାନ୍‌ ଉଦୁବ୍‌କେଦ୍‌କଆକ ଆଡଃ ଇତୁକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ଚିମିନ୍‍ ଦିନ୍‍ ତାୟମ୍‍ତେ ପାଉଲୁସ୍‌, ବର୍ଣ୍ଣବାସ୍‌କେ କାଜିକିୟା, “ଦଲା, ରୁହାଡ଼ାଃଲାଙ୍ଗ୍‌ ଆଡଃ ସବେନ୍‌ ସାହାର୍‌ରେନ୍‌ ଅକ ହାଗାକକେ ପ୍ରାଭୁଆଃ ବାଚାନ୍‌ ଉଦୁବ୍‌କାକ ତାଇକେନାଲାଙ୍ଗ୍‌, ଇନ୍‌କୁଲଃ ନେପେଲ୍‌କେଦ୍‌ତେ, ଇନ୍‌କୁ ଚିଲ୍‌କା ମେନାକଆ ଏନାଲାଙ୍ଗ୍‌ ନେଲାଉକଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ବର୍ଣ୍ଣବାସ୍‌, ଯୋହାନ୍‌ ନୁତୁମ୍‌ରେ ସାରିୟଃତାନ୍‌ ମାର୍କକେ ଆକିନାଃଲଃ ଇଦି ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌କାଦ୍‌ ତାଇକେନା, ");
INSERT INTO unx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ମେନ୍‌ଦ ପାଉଲୁସ୍‌ ମାର୍କକେ ଇଦି ନାଗେନ୍ତେ କାଏ ସାନାଙ୍ଗ୍‌କେଦା, ଚିଆଃଚି ଇନିଃ ସିଦାରେୟାଃ ହରାସେନ୍‌ରେ କାମି ଟୁଣ୍ଡୁଃ ଜାକେଦ୍‌ ଆକଲଃ କା ତାଇକେଦ୍‌ତେ ଇନ୍‌କୁକେ ପାମ୍ପିଲିଆରେ ବାଗିକେଦ୍‌ତେ ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ନେ ବିଷାଏରେ ପୁରାଃଗି କାପ୍‌ଜି ହବାୟାନା ଆଡଃ ଇନ୍‌କିନାଃ ବିନ୍‌ଗାଅ ହବାୟାନା । ବର୍ଣ୍ଣବାସ୍‌ ମାର୍କକେ ଇଦିକେଦ୍‌ତେ ସାଇପ୍ରସ୍‌ତେ ଦାଆଃ ଜାହାଜ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେକିନ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ମେନ୍‌ଦ ପାଉଲୁସ୍‌, ସିଲାସ୍‌କେ ସାଲାକିୟା ଆଡଃ ବିଶ୍ୱାସୀ ହାଗାକଆଃ ହରାତେ ପ୍ରାଭୁଆଃ ସାୟାଦ୍‌ରେ ଜିମାୟାନ୍‌ଲଃ ବିଦା ଇଦିକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ଇନିଃ ସିରିୟା ଆଡଃ କିଲିକିଆ ପାର୍‌ଗାନ୍‌ ହରାତେ ସେନଃୟାନା ଆଡଃ କାଲିସିୟାରେନ୍‌ ହଡ଼କକେ ବିଶ୍ୱାସ୍‌ରେ କେଟେଦ୍‌ ଇଦିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ପାଉଲୁସ୍‌ ଦର୍ବୀ ଆଡଃ ଲୁସ୍‌ତ୍ରାତେ ସେନଃୟାନା, ଏନ୍ତାଃରେ ତୀମଥି ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଖ୍ରୀଷ୍ଟିୟାନ୍‌ ହଡ଼ ତାଇନଃତାନ୍‌ ତାଇକେନାଏ । ଇନିୟାଃ ଏଙ୍ଗାତେ ମିଆଁଦ୍‌ ଖ୍ରୀଷ୍ଟ୍‌ ବିଶ୍ୱାସୀ ଯିହୁଦୀ ତାଇକେନାଏ, ମେନ୍‌ଦ ଆପୁତେ ଗ୍ରୀକ୍‌ ହଡ଼ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ଲୁସ୍‌ତ୍ରା ଆଡଃ ଇକନିୟାରେନ୍‌ ସବେନ୍‌ ବିଶ୍ୱାସୀକ ତୀମଥିଆଃ ବିଷାଏରେ ପୁରାଃ ବୁଗିନାଃକ କାଜି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ପାଉଲୁସ୍‌, ତୀମଥିକେ ଆୟାଃଲଃ ଇଦି ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌କେଦା, ଏନାତେ ଇନିଃ ତୀମଥିକେ ଖାତ୍‌ନାଅକିୟାଏ । ଚିଆଃଚି ଏନ୍ତାଃରେ ତାଇନଃତାନ୍‌ ସବେନ୍‌ ଯିହୁଦୀ ହଡ଼କ ତୀମଥିଆଃ ଆପୁତେକେ ଗ୍ରୀକ୍‌ ହଡ଼ ତାନିଃ ମେନ୍ତେକ ସାରିକାଦ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ଇନ୍‌କୁ ସାହାର୍‌ ହରାକରେ ସେନଃ ତାଇକେନ୍‌ ଇମ୍‌ତା, ବିଶ୍ୱାସୀକକେ ଯୀରୁଶାଲେମ୍‌ରେନ୍‌ ପ୍ରେରିତ୍‌ ଆଡଃ ପ୍ରାଚିନ୍‌କ ଠାହାରାଅକାଦ୍‌ ସବେନ୍‌ ଆନ୍‌ଚୁକେ ମାନାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେକ କାଜିକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ନେ'ଲେକାତେ କାଲିସିୟାକ ବିଶ୍ୱାସ୍‌ରେ ପୁରାଃଗିକ କେଟେଦ୍‌ୟାନା ଆଡଃ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ପସାଇଦିୟଃତାନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ଇନ୍‌କୁକେ ପାବିତାର୍‌ ଆତ୍ମା ଏସିଆ ପାର୍‌ଗାନ୍‌ରେ ବାଚାନ୍‌ ଉଦୁବ୍‌ ନାଗେନ୍ତେ କାଏ ଆଚୁକେଦ୍‌କ ହରାତେ ଇନ୍‌କୁ ଫ୍ରୁଗିଆ ଆଡଃ ଗାଲାତିୟ ପାର୍‌ଗାନ୍‌ତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ଇନ୍‌କୁ ମୁସିୟା ପାର୍‌ଗାନ୍‌ରେୟାଃ ସିମ୍‌ନାତେ ସେଟେର୍‌ୟାନ୍‌ଲଃ ବେଥ୍‌ନିଆ ପାର୍‌ଗାନ୍‌ତେ ସେନଃ ନାଙ୍ଗ୍‌ ଅଡଙ୍ଗ୍‌ଅଃ ଇମ୍‌ତା ୟୀଶୁଆଃ ଆତ୍ମା ଇନ୍‌କୁକେ କାଏ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ଏନାତେ ଇନ୍‌କୁ ମୁସିୟା ହରାତେ ସେନଃୟାନ୍‌ଲଃ ତ୍ରୋୟାସ୍‌ତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ଏନ୍‌ ନିଦାରେ ପାଉଲୁସ୍‌ ମିଆଁଦ୍‌ ଦାର୍‌ଶାନ୍‌ ନେଲ୍‌କେଦାଏ ଯେ, ମାକିଦନିଆରେନ୍‌ ମିଆଁଦ୍‌ ହଡ଼ ତିଙ୍ଗୁକେଦ୍‌ତେ ବିନ୍ତିତାନ୍‌ଲଃ କାଜିତାନାଏ, “ମାକିଦନିଆତେ ହିଜୁଃକେଦ୍‌ତେ ଆଲେକେ ଦେଙ୍ଗାଲେପେ !” ");
INSERT INTO unx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ପାଉଲୁସ୍‌ ନେ ଦାର୍‌ଶାନ୍‌ ନେଲ୍‌କେଦ୍‌ଚି ଆଲେ ମାକିଦନିଆତେ ସେନଃ ନାଗେନ୍ତେଲେ ସେକାଡ଼୍‌ୟାନା, ଚିଆଃଚି ଆଲେ ସାର୍‌ତିଗି ସାରିକାଦ୍‌ ତାଇକେନାଲେ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଏନ୍ତାଃରେନ୍‌ ହଡ଼କଆଃ ଥାଲାରେ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଆଲେକେ କେଡ଼ାକାଦ୍‌ଲେୟା । ");
INSERT INTO unx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ଆଲେ ତ୍ରୋୟାସ୍‌ତାଃଏତେ ଦାଆଃ ଜାହାଜ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ସାମଥ୍ରାକି ଟାପୁତେଲେ ସେନଃୟାନା, ଆଡଃ ଏଟାଃହୁଲାଙ୍ଗ୍‌ ନିୟାପଲି ସାହାର୍‌ତେଲେ ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ଏନ୍ତାଃଏତେ ଆଲେ ମାକିଦନିଆ ଜିଲ୍ଲାରେୟାଃ ମାରାଙ୍ଗ୍‌ ନାଗାର୍‌ ଫିଲିପିତେଲେ ସେନଃୟାନା । ଏନ୍‌ ନାଗାର୍‌ରେ ରୋମ୍‌ରେନ୍‌ ହଡ଼କହଗି ତାଇନଃତାନ୍‌ ତାଇକେନାକ । ଆଲେ ଏନ୍ତାଃରେ ଚିମିନ୍‌ଦିନ୍‌ ଲେକାଲେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଆଲେ ନାଗାର୍‌ହେତେ ଅଡଙ୍ଗ୍‌ୟାନ୍‌ଲଃ ନାହିଁ ଗେନାତେଲେ ସେନଃୟାନା । ଏନ୍ତାଃରେ ଯିହୁଦୀ ହଡ଼କ ହୁଣ୍ଡିକେଦ୍‌ତେ ବିନ୍ତି ତାଇକେନ୍‌ ମିଆଁଦ୍‌ ଠାୟାଦ୍‌ ତାଇନାଃ ମେନ୍ତେଲେ ଉଡ଼ୁଃକାଦ୍‌ ତାଇକେନା । ଆଲେ ଲାତାର୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ଏନ୍ତାଃରେ ହୁଣ୍ଡିୟାକାନ୍‌ କୁଡ଼ିକଲଃ ଜାଗାର୍‌କେଦାଲେ । ");
INSERT INTO unx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ଇନ୍‌କୁଆଃ ଥାଲାରେ ଥୁୟତିରା ନାଗାର୍‌ରେନ୍‌ ଲୁଦିୟା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ କୁଡ଼ି ତାଇକେନା । ଇନିଃ ବାଇଗିନିଆ ଲିଜାଃ ଆଖ୍‌ରିଙ୍ଗ୍‌ନିଃ ତାଇକେନାଏ । ଇନିଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରଭାକ୍ତି ତାଇକେନା ଆଡଃ ପାଉଲୁସ୍‌ କାଜିତାଇକେନ୍‌ତେୟାଃ ମନ୍‌ଧ୍ୟାନ୍‌ ଆୟୁମ୍‌କେଦ୍‌ତେ ମନ୍‌ସୁରୁଦ୍‌ରେ ତେଲାଏ ନାଗେନ୍ତେ ପ୍ରାଭୁ ଇନିଃକେ ସୁଯୋଗ୍‌ ଏମ୍‌କିୟାଏ । ");
INSERT INTO unx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ଇନିଃ ଆଡଃ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌କ ବାପ୍ତିସ୍ମା ଇଦିକେଦ୍‌ ତାୟମ୍‌ତେ ଆଲେକେ କେଡ଼ାକେଦ୍‌ତେ କାଜିକେଦ୍‌ଲେୟାକ, “ଆପେ ଆଇଙ୍ଗ୍‌କେ ପ୍ରାଭୁତାଃରେ ପାତିୟାର୍‌ରଃ ଲେକା ମେନାଇୟା ମେନ୍ତେପେ ବିଚାର୍‌ତାନ୍‌ ରେଦ, ଦେଲା ଆଇଁୟାଃ ଅଡ଼ାଃରେ ତାଇନ୍‌ପେ ।” ଇନିଃ ନେ'ଲେକା କାଜିକେଦ୍‌ତେ ଆୟାଃ ଅଡ଼ାଃରେ ତାଇନ୍‌ ନାଗେନ୍ତେ ଆଲେକେ ଉସ୍‌କୁର୍‌କେଦ୍‌ଲେୟା । ");
INSERT INTO unx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ମୁସିଙ୍ଗ୍‌ ଆଲେ ବିନ୍ତି ଠାୟାଦ୍‌ତେ ସେନଃ ତାଇକେନ୍‌ ଇମ୍‌ତା ମିଆଁଦ୍‌ କାମ୍‌ଡ଼ି କୁଡ଼ିଲଃ ନାପାମ୍‌ୟାନାଲେ । ଇନିୟାଃରେ ତାଇକାନ୍‌ ଏତ୍‌କାନ୍‌ ଆତ୍ମା ହରାତେ ଇନିଃ ଆୟାର୍‌କାଜିକଏ କାଜି ଦାଡ଼ିତାଇକେନା । ଇନିଃ ହଡ଼କଆଃ ଚିନାଃ ହବାଅଃଆ ଏନାକ ସିଦାରେ କାଜି ଦାଡ଼ି ତାଇକେନା । ଇନିଃ ଆୟାଃ ଗୁସିୟାଁକଆଃ ନାଙ୍ଗ୍‌ ପୁରାଃ ଟାକା ପାଏସାଏ କାମି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ଇନିଃ ପାଉଲୁସ୍‌ ଆଡଃ ଆଲେୟାଃ ଦୟା ଦୟା ହିଜୁଃକେଦ୍‌ତେ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାଏ, “ନେ ହଡ଼କ ସାଲାଙ୍ଗି ଉତାର୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଦାସିକ ତାନ୍‌କ । ଆପେ ଚିଲ୍‌କାତେ ଜୀଉବାଞ୍ଚାଅପେ ନାମେୟା, ଏନାକ କାଜିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ଏନ୍‌ କୁଡ଼ି ପୁରାଃ ମାହାଁ ଜାକେଦ୍‌ ନେ'ଲେକାଏ ରିକାକେଦା । ଏନ୍ତେ ପାଉଲୁସ୍‌ ଖିସ୍‌ୟାନ୍‌ଲଃ ଦୟା ହେତାକେଦ୍‌ତେ ଏତ୍‌କାନ୍‌ ଆତ୍ମାକେ କେଟେଦ୍‌କେଦ୍‌ତେ କାଜିକିୟା, “ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ଆଃ ନୁତୁମ୍‌ତେଇଙ୍ଗ୍‌ ଆଚୁମେତାନା, ଇନିଃତାଃଏତେ ଅଡଙ୍ଗ୍‌ଅଃମେ !” ଇମ୍‌ତାଗି ଏତ୍‌କାନ୍‌ ଆତ୍ମା ଇନିଃତାଃଏତେ ଅଡଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ଚିମ୍‌ତା ଇନିୟାଃ ଗୁସିୟାଁକ ଆକଆଃ ଟାକା କାମିରେୟାଃ ଆସ୍ରାକ ଆଦ୍‌କେଦା ମେନ୍ତେ ଆଟ୍‌କାର୍‌କେଦ୍‌ଚି, ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌କେ ସାବ୍‌କେଦ୍‌ତେ ବାଜାର୍‌ ପିଡ଼ି ଥାଲାତେ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ ହଡ଼କତାଃତେ ଅର୍‌ ଇଦିକେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ଇନ୍‌କୁ ଇନ୍‌କିନ୍‌କେ ରୋମି ହାକିମ୍‍କତାଃତେ ଆଉକେଦ୍‍କିନାକ ଆଡଃ କାଜିକେଦାକ, “ନେ ହଡ଼କିନ୍‌ ଯିହୁଦୀ ତାନ୍‌କିନ୍‌, ଆଡଃ ଆଲେୟାଃ ନାଗାର୍‌ରେ ହାଲାଗୁଲାଏ ତାନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ଇନ୍‌କିନ୍‌ ଆବୁଆଃ ଆନ୍‌ଚୁ ବିରୁଧ୍‌ ରିତିରିୱାଜ୍‌ ଇତୁକତାନାକିନ୍‌ । ଆବୁ ରୋମିରେନ୍‌ ହଡ଼କ ତାନ୍‌ବୁ, ଏନାତେ ନେ ସବେନ୍‌ କା ଲାଗାତିଙ୍ଗ୍‌ ରିତିରିୱାଜ୍‌ କାବୁ ମାନାତିଙ୍ଗ୍‌ ଦାଡ଼ିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କହଗି ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌ଆଃ ବିରୁଧ୍‌ରେ ମେସାୟାନାକ । ଏନ୍ତେ ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌ଆଃ ଲିଜାଃ ଚେଚାଃକେଦ୍‌ତେ ଇନ୍‌କିନ୍‌କେ ସଟାତେ ହାଁଣ୍‌ସା ନାଗେନ୍ତେ ରୋମି ହାକିମ୍‌କ ଇନ୍‌କୁକେ ଆଚୁକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ଇନ୍‌କୁ ଇନ୍‌କିନ୍‌କେ ପୁରାଃଗି ଦାଲ୍‌କେଦ୍‌ତେ ଜେହେଲ୍‌ରେ ଦହକେଦ୍‌କିନାକ ଆଡଃ ତାଲାକେଦ୍‌ତେ ହର ନାଙ୍ଗ୍‌ ଆଚୁକେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ନେ ଆନାଚୁ ନାମ୍‌କେଦ୍‌ତେ ଜେହେଲ୍‌ ହରନିଃ ଇନ୍‌କିନ୍‌କେ ମିଆଁଦ୍‌ ଭିତାର୍‌ କୁଠାତେ ଇଦିକେଦ୍‌ତେ ହାମ୍ବାଲ୍‌ ସାହାନ୍‌ରେୟାଃ ଅର୍‌ଗଡ଼୍‌ରେ ଇନ୍‌କିନାଃ କାଟାକେ ତଲ୍‌କେଦ୍‌କିନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ଥାଲାନିଦାରେ ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନୁତୁମ୍‌ତେ ବିନ୍ତି ଆଡଃ ମାନାରାଙ୍ଗ୍‌ରାଃ ଦୁରାଙ୍ଗ୍‌ ତାଇକେନାକିନ୍‌ ଆଡଃ ଏଟାଃ ଜେହେଲାକାନ୍‌ ହଡ଼କ ଏନା ଆୟୁମ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ଇମ୍‍ତାଗି ପୁରାଃତେ ଅତେ ଦିଲ୍‌କାଅୟାନା ଆଡଃ ଜେହେଲ୍‌ ଅଡ଼ାଃରାଃ ନିହିଁଗାଡ଼ା ଏକ୍‌ଲାଅୟାନା । ଇମ୍‍ତାଗି ସବେନ୍‌ ଦୁଆର୍‌କ ନିଜ୍‌ୟାନା ଆଡଃ ଜେହେଲାକାନ୍‌ ସବେନ୍‍ ହଡ଼କଆଃ ସିକିଡ଼ିକ ରାଡ଼ାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ଜେହେଲ୍ ହରନିଃ ଦୁଡ଼ୁମ୍‌ଏତେ ବିରିଦ୍‌ୟାନାଏ ଆଡଃ ଜେହେଲ୍‌ରେୟାଃ ଦୁଆର୍‌ ସବେନ୍‌ ନିଜାକାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ଉଡ଼ୁଃକେଦାଏ ଯେ, ଜେହେଲାକାନ୍‌ ସବେନ୍‌ ହଡ଼କ ନିର୍‌ୟାନାକ । ଏନାତେ ଇନିଃ ଆୟାଃ ତାରାଉଡ଼ି ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ ଆଇଃକ୍‌ଗି ଗଜେନ୍‌ ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ମେନ୍‌ଦ ପାଉଲୁସ୍‌ ପୁରାଃ କାଉରିକେଦ୍‍ତେ କାଜିକିୟା, “ଆମ୍‌ ଆପାନ୍‌କେ ଜେତ୍‌ନାଃ ଆଲମ୍‌ ନକ୍‌ସାନେନ୍‌ ଚିଆଃଚି ଆଲେ ସବେନ୍‌କ ନେତାଃରେ ମେନାଲେୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ଜେହେଲ୍‌ ହରନିଃ ଦିମି ଆଉ ନାଗେନ୍ତେ କାଜିକେଦ୍‌କଆ ଆଡଃ ଭିତାର୍‌ତେ ନିର୍‌ବଲୟାନା ଏନ୍ତେ ବରତେ ଏକ୍‌ଲାଅଃତାନ୍‌ଲଃ ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌ଆଃ କାଟା ଲାତାର୍‌ରେ ଉୟୁଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ଏନ୍ତେ ଇନ୍‌କିନ୍‌କେ ବାହାରିତେ ଅଡଙ୍ଗ୍‌କେଦ୍‌ତେ କୁଲିକେଦ୍‌କିନା, “ମାଇନାନ୍‌କିନ୍‌, ଜୀଉବାଞ୍ଚାଅ ନାମେ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌କେ ଚିନାଃ ରିକା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ ?” ");
INSERT INTO unx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ଇନ୍‌କିନ୍‌ କାଜିକିୟାକିନ୍‌, “ପ୍ରାଭୁ ୟୀଶୁରେ ବିଶ୍ୱାସେରେଦ, ଆମ୍‌ ଆଡଃ ଆମାଃ ଅଡ଼ାଃରେନ୍‌ ଜୀଉବାଞ୍ଚାଅପେ ନାମେୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ଏନ୍ତେ ଇନ୍‌କିନ୍‌ ଇନିଃକେ ଆଡଃ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌ ହଡ଼କକେ ପ୍ରାଭୁଆଃ ବାଚାନ୍‌ ଉଦୁବ୍‌କେଦ୍‌କଆକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ନିଦାରେୟାଃ ଏନ୍‌ ଦିପିଲିରେଗି ଜେହେଲ୍‌ ହରନିଃ ଇନ୍‌କିନ୍‌କେ ଇଦିକେଦ୍‌ତେ, ଆକିନାଃ ଘାଅକ ଚାପି ଆବୁଙ୍ଗ୍‌କେଦାଏ, ଆଡଃ ଇନିୟାଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ଇମ୍‌ତାଗି ବାପ୍ତିସ୍ମାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ଏନ୍ତେ ଇନିଃ ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌କେ ଆୟାଃ ଅଡ଼ାଃତେ ଇଦିକେଦ୍‌ତେ ଜମେ ନାଗେନ୍ତେ ଏମାଦ୍‌କିନା । ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ବିଶ୍ୱାସ୍‌କେଦ୍‌ ହରାତେ ଇନିଃ ଆଡଃ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ରାସ୍‌କାତେ ପେରେଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଆଙ୍ଗ୍‌ୟାନ୍‍ଚି ରୋମିରେନ୍‌ ହାକିମ୍‍କ ସିପାଇକତାଃରେ, “ଏନ୍‌ ହଡ଼କିନ୍‌କେ ଆଡ଼ାଃତାକିନ୍‌ପେ” ମେନ୍ତେକ କାଜିକୁଲ୍‍କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ଏନ୍ତେ ଜେହେଲ୍‌ ହରନିଃ ପାଉଲୁସ୍‌କେ କାଜିକିୟା, “ହାକିମ୍‌କ ଆମ୍‌କେ ଆଡଃ ସିଲାସ୍‌କେ ଜେହେଲ୍‌ହେତେ ରାଡ଼ାଃଅକାକିନ୍‌ ମେନ୍ତେ ହୁକୁମ୍‌ ଏମାକାନା । ନାହାଁଃ ଆବେନ୍‌ ଜୀଉସୁକୁତେ ସେନ୍‌ ଦାଡ଼ିୟାଃବେନ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ମେନ୍‌ଦ ପାଉଲୁସ୍‌ ସିପାଇକକେ କାଜିୟାଦ୍‍କଆ, “ଜେତାନ୍‌ ଗୁହ୍ନାଁଁ କାଲିଙ୍ଗ୍‌ କାମିକାଦ୍‌ରେୟ ଇନ୍‌କୁ ଆଲିଙ୍ଗ୍‌କେ ଦାଲ୍‌କାଦ୍‌ଲିୟାଁକ । ଆଲିଙ୍ଗ୍‌ ରୋମିରେନ୍‌ ହଡ଼କିନ୍ ତାନ୍‍ଲିଙ୍ଗ୍‌, ମେନ୍‌ଦ ଇନ୍‌କୁ ଆଲିଙ୍ଗ୍‌କେ ଜେହେଲ୍‌କେଦ୍‌ଲିୟାଁକ । ନାହାଁଃ ଇନ୍‌କୁ ଜେତାଏ ଆଲକାକ ସାରିଲେକା ଆଲିଙ୍ଗ୍‌କେ କୁଲ୍‌ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନାକ । ଆଲିଙ୍ଗ୍‌ ନେ'ଲେକା ହବାଅଃକା ମେନ୍ତେ କାଲିଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା । ରୋମିରେନ୍‌ ହାକିମ୍‌କ ଆକଗି ନେତାଃତେ ହିଜୁଃକେଦ୍‌ତେ ଆଲିଙ୍ଗ୍‌କେ ଜେହେଲ୍‌ହେତେ ରାଡ଼ାଲିଙ୍ଗ୍‌କାକ ।” ");
INSERT INTO unx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ସିପାଇକ ନେ କାଜି ରୋମିରେନ୍‌ ହାକିମ୍‍କକେ ଉଦୁବାଦ୍‌କଆକ । ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌ ରୋମିରେନ୍‌ ତାନ୍‌କିନ୍‌ ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ବରକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ଏନ୍ତେ ଇନ୍‌କୁ ସେନ୍‌କେଦ୍‌ତେ ଇନ୍‌କିନ୍‌ତାଃରେ ଜହାର୍‌ ବିନ୍ତିକେଦ୍‌ତେ ଇନ୍‌କିନ୍‌କେ ଜେହେଲ୍‌ହେତେ ରାଡ଼ାକେଦ୍‌କିନାକ ଆଡଃ ନାଗାର୍‌ ବାଗିକେଦ୍‌ତେ ସେନଃବେନ୍‌ ମେନ୍ତେକ କାଜିକେଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌ ଜେହେଲ୍‌ ବାଗିକେଦ୍‌ତେ ଲୁଦିୟାରାଃ ଅଡ଼ାଃତେ ସେନଃୟାନାକିନ୍‌ । ଏନ୍ତାଃରେ ଇନ୍‌କିନ୍‌ ବିଶ୍ୱାସୀକଲଃ ନେପେଲ୍‌ୟାନାକିନ୍‌ ଆଡଃ ଇନ୍‌କୁକେ ଜୀଉରେ ରାସ୍‌କାରେୟାଃ କାଜି ଏମ୍‌କେଦ୍‌ତେ ସେନଃୟାନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌ ଆମ୍ପିପଲି ଆଡଃ ଆପଲୋନିଆ ସାହାର୍‌ ହରାତେ ହରାସେନ୍‌ତାନ୍‌ଲଃ ଥେସ୍‌ଲନିକା ନାଗାର୍‌ତେକିନ୍‌ ସେଟେର୍‌ୟାନା । ଏନ୍ତାଃରେ ଯିହୁଦୀକଆଃ ମିଆଁଦ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ପାଉଲୁସ୍‌ ଆୟାଃ ରିତିରିୱାଜ୍‌ ଲେକାତେ ସାମାଜ୍‌ ଅଡ଼ାଃତେ ସେନଃୟାନା । ଏନ୍ତାଃରେ ଇନିଃ ଆପି ହାପ୍ତା ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଜାକେଦ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃ ସେନ୍‌କେଦ୍‌ତେ ହଡ଼କକେ ଧାରାମ୍‌ପୁଥିରେୟାଃ କାଜି ଜାଗାର୍‌କେଦ୍‌କଆ, ");
INSERT INTO unx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଆଡଃ ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନ୍‌ତେୟାଃ ଉଦୁବେତାନ୍‌ଲଃ ସାବୁଦ୍‌ ଏମ୍‌କେଦାଏ ଯେ, ମାସିଆଃ ଦୁକୁ ଆଡଃ ଗନଏଃହେତେ ଜୀଉ ବିନିରିଦ୍‌ ହବାଅଃ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା । ପାଉଲୁସ୍‌ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ଅକ ୟୀଶୁଆଃ ବିଷାଏରେ ଉଦୁବ୍‌କାଦାଇଙ୍ଗ୍‌, ଇନିଃ ଏନ୍‌ ମାସିଗି ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ଇନ୍‌କୁଏତେ ଚିମିନ୍‍ ହଡ଼କ ପାଉଲୁସ୍‌ କାଜିରେ ସାଲ୍‌ହାୟାନାକ ଏନ୍ତେ ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌ଲଃ ମେସାୟାନାକ, ଏନ୍‌ଲେକାଗି ପୁରାଃ ଆଗୁଆଇ କୁଡ଼ିକ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରଭାକ୍ତିତାନ୍‌ ଗ୍ରୀକ୍‌ ହଡ଼କଆଃ ମିଆଁଦ୍‌ ମାରାଙ୍ଗ୍‌ ଝୁଣ୍ଡ୍‌ ଇନ୍‌କିନ୍‌ଲଃ ମେସାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ମେନ୍‌ଦ ଯିହୁଦୀ ହଡ଼କ ହିସ୍‌ଙ୍ଗାୟାନାକ ଆଡଃ ଚିମିନ୍‌ ଝାନ୍‌ ଏତ୍‌କାନ୍‌ ହଡ଼କକେ ହୁଣ୍ଡିକେଦ୍‌ତେ ପୁରା ସାହାର୍‌ରେ ହାଲାଗୁଲାକେଦାକ । ଇନ୍‌କୁ ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌କେ ଦାଣାଁକେଦ୍‌ତେ ହଡ଼କତାଃତେ ଆଉକିନ୍‌ ନାଗେନ୍ତେ ଜେସନ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ହଡ଼ରାଃ ଅଡ଼ାଃତେକ ନିର୍‌କେଦା । ଚିଆଃଚି ଇନିଃଗି ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌କେ ଆୟାଃ ଅଡ଼ାଃରେ ତାଇନଃ ନାଗେନ୍ତେ କେଡ଼ାକାଦ୍‌କିନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ମେନ୍‌ଦ ଇନ୍‌କୁ ଏନ୍ତାଃରେ ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌କେ କା ନାମ୍‌କେଦ୍‌ ହରାତେ, ଜେସନ୍‌ ଆଡଃ ଏଟାଃ ଚିମିନ୍‌ ବିଶ୍ୱାସୀ ହାଗାକକେ ନାଗାର୍‌ରେନ୍‌ ହାକିମ୍‌କତାଃତେ ଥାଇଜ୍‌ ଇଦିକେଦ୍‌ତେ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାକ, “ନେ ହଡ଼କ ଅତେଦିଶୁମ୍‌ରେୟାଃ ଚାରିୟସାଃରେ ହାଲାଗୁଲାଏ ତାନାକ, ନାହାଁଃ ଇନ୍‌କୁ ଆବୁଆଃ ନାଗାର୍‌ତେକ ହିଜୁଃକାନା, ");
INSERT INTO unx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ଆଡଃ ଇନ୍‌କିନ୍‌କେ ଜେସନ୍‌ ଆୟାଃ ଅଡ଼ାଃରେ ଦହକାଦ୍‌କିନା । ୟୀଶୁ ନୁତୁମ୍‌ରେ ଆଡଃମିଆଁଦ୍‌ ରାଜା ମେନାଇୟା ମେନ୍ତେ କାଜିତାନ୍‌ଲଃ ଇନ୍‌କିନ୍‌ କାଇସାର୍‌ଆଃ ଆନ୍‌ଚୁ ଟଟାଃଏ ତାନାକିନ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ଇନ୍‌କୁଆଃ ନେ କାଜିକ ଆୟୁମ୍‌କେଦ୍‌ତେ ଗାଦେଲ୍‌ ହଡ଼କ ଆଡଃ ହାକିମ୍‌କ ପୁରାଃଗି ହାଲାଗୁଲାକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ହାକିମ୍‌କ ଜେସନ୍‌ ଆଡଃ ବିଶ୍ୱାସୀକତାଃଏତେ ଜାମାନାତ୍‌ ଇଦିକେଦ୍‌ତେ ଇନ୍‌କିନ୍‌କେ ଆଡ଼ାଃକେଦ୍‌କିନାକ । ");
INSERT INTO unx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ନୁବାଃୟାନ୍‌ଚି ବିଶ୍ୱାସୀ ହାଗାକ ପାଉଲୁସ୍‌ ଆଡଃ ସିଲାସ୍‌କେ ବେରିଆତେକ କୁଲ୍‌କେଦ୍‌କିନା । ଇନ୍‌କିନ୍‌ ଏନ୍ତାଃତେ ସେଟେର୍‌କେଦ୍‌ତେ ଯିହୁଦୀକଆଃ ସାମାଜ୍‌ ଅଡ଼ାଃତେକିନ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ଥେସ୍‌ଲନିକାରେନ୍‌ ହଡ଼କତାଃଏତେ ବେରିଆରେନ୍‌ ହଡ଼କ ପୁରାଃଗି ନାୱା ଉଡ଼ୁଃ ଆଡଃ ଇନିତୁକେ ଆୟୁମ୍‌ ନାଙ୍ଗ୍‌ ଇଛାସାନାଙ୍ଗ୍‌ତାନ୍‌ ହଡ଼କ ତାଇକେନା । ଇନ୍‌କୁ ୟୀଶୁଆଃ କାଜି ଆୟୁମ୍‌ ନାଗେନ୍ତେ ପୁରାଃ ସାନାଙ୍ଗ୍‌କେଦାକ ଆଡଃ ପାଉଲୁସ୍‌ ଉଦୁବ୍‌ ତାଇକେନ୍‌ତେୟାଃରାଃ ସାନାର୍‌ତି ସାରି ନାଗେନ୍ତେ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ଧାରାମ୍‌ପୁଥି ପାଢ଼ାଅ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ଇନ୍‌କୁଏତେ ପୁରାଃ ହଡ଼କ ବିଶ୍ୱାସ୍‌କେଦା । ଆଡଃ ସାମାଜ୍‌କରେ ନୁତୁମଃତାନ୍‌ ମାପ୍‌ରାଙ୍ଗ୍‌ ପୁରାଃ ଗ୍ରୀକ୍‌ କୁଡ଼ିକ ଆଡଃ କଡ଼ାକ ବିଶ୍ୱାସୀକଲଃ ମେସାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ମେନ୍‌ଦ ପାଉଲୁସ୍‌ ବେରିଆରେହ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ଉଦୁବେତାନାଏ ମେନ୍ତେ ଥେସ୍‌ଲନିକାରେନ୍‌ ଯିହୁଦୀ ହଡ଼କ ଆୟୁମ୍‌କେଦା, ଇମ୍‌ତା ଇନ୍‌କୁ ବେରିଆତେ ହିଜୁଃକେଦ୍‌ତେ ହାଲାଗୁଲାଏ ନାଗେନ୍ତେ ହଡ଼କକେ ଉସ୍‌କୁର୍‌କେଦ୍‌କଆକ । ");
INSERT INTO unx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ଇମ୍‌ତାଗି ବିଶ୍ୱାସୀ ହାଗାକ ପାଉଲୁସ୍‌କେ ଦରେୟା ଗେନାତେକ କୁଲ୍‌କିୟା, ମେନ୍‌ଦ ସିଲାସ୍‌ ଆଡଃ ତୀମଥି ନେ ବାରାନ୍‌କିନ୍‌ ବେରିଆରେ ତାଇନ୍‌ୟାନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ପାଉଲୁସ୍‍କେ ତେବାତୁକାଇତାନ୍‌ ହଡ଼କ ଆୟାଃଲଃ ଏଥେନ୍‌ସ୍‌ ଜାକେଦ୍‌କ ସେନଃୟାନା । ଏନ୍ତାଃଏତେ ଇନ୍‌କୁ ବେରିଆତେ ହିଜୁଃ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ସିଲାସ୍‌ ଆଡଃ ତୀମଥିକେ କାଜିକେଦ୍‌କିନାକ, “ଆବେନ୍‌ ଜାଲ୍‌ଦିଗି ସେନ୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌ଲଃ ମେସାଅଃବେନ୍‌” ମେନ୍ତେ ପାଉଲୁସ୍‌ କାଜିକାଦାଏ । ନେ ଆନାଚୁ ନାମ୍‌କେଦ୍‌ଚି ଇନ୍‌କିନ୍‌ ସେନଃୟାନାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ପାଉଲୁସ୍‌ ଏଥେନ୍‌ସ୍‌ରେ ସିଲାସ୍‌ ଆଡଃ ତୀମଥିଆଃ ନେଲ୍‌ହରାତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଏନ୍‌ ନାଗାର୍‌ ମୁରୁତ୍‌ ସେୱାରେ ପେରେଜାକାନ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ପୁରାଃଗି ମନ୍‌ଦୁକୁୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ଏନାତେ ଇନିଃ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ଯିହୁଦୀ ହଡ଼କଲଃ, ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରଭାକ୍ତିତାନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କଲଃ, ଆଡଃ ସାହାର୍‌ରେୟାଃ ଥାଲା ହରାକରେ ହିଜୁଃ ସେନଃତାନ୍‌ ହଡ଼କଲଃ ଏନ୍‌ ବିଷାଏରେ ଜାଗାର୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ଏନ୍ତେ ଚିମିନ୍‌ ଇପିକୁରିୟାନ୍‌ ଆଡଃ ସ୍ତୋୟିକ୍‌ ଇତୁ ହଡ଼କଲଃ ପାଉଲୁସ୍‌ଆଃ କାପ୍‌ଜି ହବାୟାନା । ଇନ୍‌କୁଏତେ ଚିମିନ୍‌ ହଡ଼କ କାଜିକେଦା, “ନିଃ ମିଆଁଦ୍‌ ବେଗାର୍‌ ଚିହ୍ନାଁର୍‌ ହଡ଼, ଚିନାଃକ କାଜି ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନାଏ ?” ଏଟାଃକ କାଜିକେଦା, “ଏଟାଃ କା ସାରିକାନ୍‌ ବଙ୍ଗାକଆଃ ବିଷାଏରେ ଇନିଃ ଉଦୁବ୍‌ତାନ୍‌ ଲେକାଏ ଆଟ୍‌କାରଃତାନା ।” ଇନ୍‌କୁ ନେ'ଲେକା କାଜିକେଦାକ ଚିଆଃଚି ଇନିଃ ୟୀଶୁ ଆଡଃ ଆୟାଃ ଜୀଉବିନିରିଦ୍‌ ବିଷାଏରେୟାଃ ସୁକୁକାଜିକେ ଉଦୁବ୍‌ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ଏନାମେନ୍ତେ ଇନ୍‌କୁ ପାଉଲୁସ୍‌କେ ସାବ୍‌ଇଦିକିୟାକ ଆଡଃ ଏରିୟପାଗସ୍‌ ନୁତୁମ୍‌ ନାଗାର୍‌ରେୟାଃ ପାଞ୍ଚେଟ୍‌ତେ ଆଉକେଦ୍‌ତେ କାଜିକିୟା, “ଆବେନ୍‌ ଅକ ନାୱା ଇନିତୁ ବିଷାଏରେ କାଜିତାନାବେନ୍‌, ଏନ୍‌ ବିଷାଏରେ ଆଲେ ସାରି ନାଗେନ୍ତେଲେ ସାନାଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ଆବେନ୍‌ କାଜିତାନ୍‌ ଚିମିନ୍‌ କାଜିକ ଆଲେକେ ଆକ୍‌ଚାକାଅଲେ ତାନା । ଆଲେ ଏନାରେୟାଃ ମୁଣ୍ଡି ସାରି ନାଗେନ୍ତେଲେ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ଏଥେନ୍‌ସ୍‌ରେନ୍‌ ହଡ଼କ ଆଡଃ ଏନ୍ତାଃରେ ତାଇନ୍‌ତାନ୍‌ ଏଟାଃ ଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କ ନାୱା ବିଷାଏ ଆୟୁମ୍‌ ନାଗେନ୍ତେ ଆଡଃ କାଜି ନାଗେନ୍ତେ ପୁରାଃ ବୁଗିନ୍‌ ଆଟ୍‌କାର୍‌କ ତାଇକେନା । ନେଆଁରେ ଇନ୍‌କୁ ପୁରାଃ ନେଡା ବିତାଅ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ପାଉଲୁସ୍‌ ନାଗାର୍‌ରେୟାଃ ଏରିୟପାଗସ୍‌ ନୁତୁମ୍‌ ପାଞ୍ଚେଟ୍‌ ଆୟାର୍‌ରେ ତିଙ୍ଗୁୟାନା ଆଡଃ କାଜିକେଦାଏ, “ଏଥେନ୍‌ସ୍‌ରେନ୍‌ ମାଇନାନ୍‌କ, ଆପେ ପୁରାଃଗି ଧାର୍‌ମାନ୍‌ ହଡ଼କ ଲେକାପେ ଆଟ୍‌କାରଃତାନା, ଏନାଇଙ୍ଗ୍‌ ନେଲ୍‌ପେ ତାନା । ");
INSERT INTO unx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ଚିୟାଃଚି ଆଇଙ୍ଗ୍‌ ଆପେୟାଃ ନାଗାର୍‌ରେ ହରାସେନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ମିଆଁଦ୍‌ ଦାଣେଁ ରାକାବ୍‌ ଠାୟାଦ୍‌ ନେଲ୍‌କେଦାଇଙ୍ଗ୍‌, ଏନାରେୟାଃ ବେଦି ଚେତାନ୍‌ରେ ‘ମିଆଁଦ୍‌ କା ସାରି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବିଷାଏରେ’ ଅଲାକାନ୍‌ ତାଇକେନା । ଆପେ ବେଗାର୍‌ ସାରିକେଦ୍‌ତେ ଅକ୍‌ନିଃକେ ସେୱାତାନାପେ, ନାହାଁଃ ଆୟାଃ କାଜି ଆପେତାଃରେଇଙ୍ଗ୍‌ ଉଦୁବ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ପାର୍‌ମେଶ୍ୱାର୍‌ ଅତେଦିଶୁମ୍‌ ଆଡଃ ଏନାରେ ତାଇକାନ୍‌ ସବେନ୍‌ ବିଷାଏ ବାଇକେଦାଏ । ଇନିଃ ସିର୍ମା ଆଡଃ ଅତେରେନ୍‌ ପ୍ରାଭୁ ତାନିଃ । ହଡ଼କ ବାଇକାଦ୍‌ ମାନ୍ଦିର୍‌ଅଡ଼ାଃକରେ ଇନିଃ କାଏ ତାଇନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ଆବୁ ଆୟାଃ ନାଗେନ୍ତେ କାମିକେଦ୍‌ତେ ଆଇଃକ୍‌କେ ଏମ୍‌ ଦାଡ଼ିୟାବୁ ଏନ୍‌ଲେକା ଜେତ୍‌ନାଃ କାଏ ସାନାଙ୍ଗ୍‌ଆଃ, ଚିୟାଃଚି ଇନିଃ ସବେନ୍‌କକେ ଜୀଦାନ୍‌, ସାହେଁଦ୍‌ ଆଡଃ ଆବୁଆଃ ସବେନ୍‌ ଲାଗାତିଙ୍ଗ୍‌ତେୟାଃ ଏମାଃଏ । ");
INSERT INTO unx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ମିଆଁଦ୍‌ ମାନୱାତାଃଏତେ ଇନିଃ ସବେନ୍‌ ହଡ଼କକେ ବାଇୟାକାଦ୍‌କଆ ଆଡଃ ଆୟାଃ ଆନାଚୁ ଲେକାତେ ଇନ୍‌କୁ ଅତେରେୟାଃ ସବେନ୍‌ତାଃରେ ମେନାକଆ । ଅକ ନେଡାରେ, ଅକଏ ଅକ ଠାୟାଦ୍‌ରେ ତାଇନା, ଏନା ମୁନୁଏତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଠାହାରାଅକାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ସବେନ୍‌ ହଡ଼କ ଜେ'ଲେକା ଆଇଃକ୍‌କେ ଦାଣାଁନାମ୍‌ ଦାଡ଼ିୟାଃକ, ଏନା ଆୟାଃ ଉଦ୍ଦେଶ୍‌ ତାଇକେନା । ଏନ୍‌ରେୟ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆବୁତାଃଏତେ ଜେତାଏୟାଃ ସାଙ୍ଗିନ୍‌ରେ ବାଙ୍ଗାଇୟା । ");
INSERT INTO unx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ଏନ୍‌ ବିଷାଏରେ ଜେତାଏ ମିହୁଡ଼୍‌ କାଜିକାଦାଏ, “ଆୟାଃତାଃରେଗି ଆବୁଆଃ ଜୀଦାନ୍‌ରେୟାଃ ଜୀହୁଦଃ, ଆସୁଲଃ, ଆଡଃ କାମି ଉଦାମ୍‌ ମେନାଃ ।” ଆପେୟାଃ ଦୁରାଙ୍ଗ୍‌ ଅନଲ୍‌କଏତେ ଚିମିନ୍‌ ହଡ଼କ କାଜିକାଦା, “ଆବୁ ଆୟାଃ ହନ୍‌କ ତାନ୍‌ବୁ । ");
INSERT INTO unx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ଆବୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହନ୍‌କ ହବାକାନ୍‌ ହରାତେ, ଆବୁ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଲେକାନ୍‌ ସଭାବ୍‌କେ ସୋନା, ରୁପା ଚାଏ ଦିରିତେ ବାଇୟାକାନ୍‌ ମୁରୁତ୍‌ଲଃ କାବୁ ଜକା ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ହଡ଼କ ପାର୍‌ମେଶ୍ୱାର୍‌କେ କାକ ସାରିକାଇ ନେଡାରେ ଇନିଃ କାଏ ଚିଟାକାକ ତାଇକେନା, ମେନ୍‌ଦ ନାହାଁଃ ଇନିଃ ସବେନ୍‌ ହଡ଼କକେ ଆକଆଃ ପାପ୍‌ ହରାଏତେ ମନ୍‌ରୁହାଡ଼୍‌ ନାଗେନ୍ତେ ଆଚୁକତାନା । ");
INSERT INTO unx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ଚିୟାଃଚି ଇନିଃ ମୁସିଙ୍ଗ୍‌ ହୁଲାଙ୍ଗ୍‌କେ ଠାହାରାଅକାଦା । ଏନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଇନିଃ ଆୟାଃ ସାଲାକାନ୍‌ ହଡ଼କଆଃ ହରାତେ ଗଟା ଅତେଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କକେ ନ୍ୟାୟ ବିଚାର୍‌କଆ । ଏନ୍‌ ହଡ଼କେ ଗନଏଃହେତେ ଜୀଉବିରିଦ୍‌କାଇ ହରାତେ ଇନିଃ ନେ କାଜିରେୟାଃ ସାନାର୍‌ତିକେ ସବେନ୍‌କକେ ଉଦୁବ୍‌କାଦ୍‌କଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ପାଉଲୁସ୍‌ତାଃଏତେ ଗନଏଃରେୟାଃ ଜୀଉବିନିରିଦ୍‌ ବିଷାଏରେ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଏତେ ଚିମିନ୍‌ ହଡ଼କ ଇନିଃକେକ ଲାନ୍ଦାକିୟା, ମେନ୍‌ଦ ଏଟାଃକ କାଜିକେଦାକ, “ଆବେନ୍‌ତାଃଏତେ ନେ ବିଷାଏରେ ଆଡଃମିସା ଆୟୁମ୍‌ ନାଗେନ୍ତେଲେ ସାନାଙ୍ଗ୍‌ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ନେଆଁ କାଜିକେଦ୍‌ତେ ପାଉଲୁସ୍‌ ପାଞ୍ଚେଟ୍‌ଏତେ ସେନଃୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ଦିୟନ୍‌ସିୟ ନୁତୁମ୍‌ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ମିଆଁଦ୍‌ ହଡ଼, ଦାମାରୀ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ କୁଡ଼ି ଆଡଃ ଚିମିନ୍‌ ହଡ଼କ ବିଶ୍ୱାସ୍‌କେଦାକ ଆଡଃ ଆୟାଃଲଃ ମେସାୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ନେଆଁଁ ତାୟମ୍‌ତେ ପାଉଲୁସ୍‌ ଏଥେନ୍‌ସ୍‌ ନାଗାର୍‌ ବାଗିକେଦ୍‌ତେ କରିନ୍ଥି ନାଗାର୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ଏନ୍ତାଃରେ ଇନିଃ ପନ୍ତସ୍‌ ପାର୍‌ଗାନ୍‌ରେ ଜାନାମାକାନ୍‌ ଆକ୍ୱିଲା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଯିହୁଦୀ ହଡ଼କେ ନାମ୍‌କିୟା । ରୋମିରେନ୍‌ ହାକିମ୍‌ କ୍ଲାଉଦିଆ ସବେନ୍‌ ଯିହୁଦୀକକେ ରୋମ୍‌ ନାଗାର୍‌ ବାଗି ନାଗେନ୍ତେ ଆଚୁକାଦ୍‌କ ତାଇକେନ୍‌ ହରାତେ ଇନିଃ ଚିମିନ୍‌ ମାହାଁ ତାୟମ୍‌ତେ ଆୟାଃ କୁଡ଼ି ପ୍ରିସ୍‌କିଲାଲଃ ଇଟାଲି ନାଗାର୍‌ହେତେ ହିଜୁଆକାନ୍‌ ତାଇକେନା । ପାଉଲୁସ୍‌ ଇନ୍‌କୁକେ ନେନେଲ୍‌ ନାଗେନ୍ତେ ସେନଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ଆଡଃ ଇନ୍‌କୁଲଃ ତାଇନ୍‌କେଦ୍‌ତେ ଏନ୍ତାଃରେ କାମିକେଦା, ଚିଆଃଚି ଇନିଃହଗି ଇନ୍‌କୁ ଲେକା କୁମ୍ବା ବାବାଇରେ କାମିକେଦ୍‌ତେ ଜୀହୁଦଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ଯିହୁଦୀ ଆଡଃ ଗ୍ରୀକ୍‌ ହଡ଼କଆଃ ମନ୍‌ରେ ବିଶ୍ୱାସ୍‌ ହବାଅଃ ନାଗେନ୍ତେ ସବେନ୍‌ ରୁଡ଼ୁନ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଇନିଃ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଜାଗାର୍‌ତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ସିଲାସ୍‌ ଆଡଃ ତୀମଥି ମାକିଦନିଆଏତେକିନ୍‍ ରୁହାଡ଼୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ ପାଉଲୁସ୍‌ ଯିହୁଦୀ ହଡ଼କତାଃରେ ୟୀଶୁଆଃ ସୁକୁକାଜି ଉଦୁବ୍‌ରେ ପୁରା ସାମାଏ ଏମ୍‌କେଦାଏ, ଆଡଃ ୟୀଶୁଗି ମାସି ତାନିଃ ମେନ୍ତେ ଗାୱା ଏମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ମେନ୍‌ଦ ଇନ୍‌କୁ ଆୟାଃ କାଜିକଟଙ୍ଗ୍‌ ରିକାକେଦ୍‌ତେ ଆୟାଃ ବିଷାଏରେ ନିନ୍ଦାକାଜିକ କାଜିକେଦା । ଏନାତେ ଇନିଃ ଆୟାଃ ଲିଜାଃରେୟାଃ ଧୁଡ଼ି କଟାକେଦ୍‌ତେ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆ, “ଆପେ ଜିୟନଃରେଦ ଏନାରେୟାଃ ଦାୟୀ ଆପେୟାଃଗି ତାନାଃ, ଆଇଁୟାଃ ନାହାଁଲାଃ । ନାହାଁଃ ଆଇଙ୍ଗ୍‌ ସାଅଁସାର୍‌ ହଡ଼କତାଃତେଇଙ୍ଗ୍‌ ସେନଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ଏନାତେ ଇନିଃ ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରଭାକ୍ତିତାନ୍‌ ତିତସ୍‌ ଜୁସ୍ତସ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସାଅଁସାର୍‌ ହଡ଼ଆଃ ଅଡ଼ାଃରେ ତାଇନଃ ନାଗେନ୍ତେ ସେନଃୟାନା । ଜୁସ୍ତସ୍‌ଆଃ ଅଡ଼ାଃ ସାମାଜ୍‌ ଅଡ଼ାଃ ନାଡ଼େଃରେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ସାମାଜ୍‌ଅଡ଼ାଃରେନ୍‌ ଆଗୁଆଇ କ୍ରୀଷ୍ପସ୍‌ ଆଡଃ ଆୟାଃ ଅଡ଼ାଃରେନ୍‌ ସବେନ୍‌ ହଡ଼କ ପ୍ରାଭୁତାଃରେ ବିଶ୍ୱାସ୍‌କେଦାକ ଆଡଃ କରିନ୍ଥିରେନ୍‌ ଆଡଃଗି ପୁରାଃ ହଡ଼କ ପାଉଲୁସ୍‌ଆଃ ଇନିତୁ ଆୟୁମ୍‌କେଦ୍‌ତେ ବିଶ୍ୱାସ୍‌କେଦାକ ଆଡଃ ବାପ୍ତିସ୍ମା ଇଦିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ମିଆଁଦ୍‌ ନିଦାରେ ପାଉଲୁସ୍‌ ଦାର୍‌ଶାନ୍‌ ନାମ୍‌କେଦାଏ, ଦାର୍‌ଶାନ୍‌ରେ ପ୍ରାଭୁ ଇନିଃକେ କାଜିକିୟା, “ଆଲମ୍‌ ବରଏୟା, ବାଚାନ୍‌ ଉଦୁବ୍‌କାତେମ୍‌, ଏନାକେ ଆଲମ୍‌ ବାଗିୟା, ");
INSERT INTO unx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ଚିଆଃଚି ଆଇଙ୍ଗ୍‌ ଆମାଃଲଃ ମେନାଇୟାଁଃ । ଜେତାଏ ଆମାଃ କାକ ନକ୍‌ସାନ୍‌ ଦାଡ଼ିୟା, ଚିଆଃଚି ନେ ନାଗାର୍‌ରେ ଆଇଁୟାଃ ପୁରାଃ ହଡ଼କ ମେନାକଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ଏନାତେ ପାଉଲୁସ୍‌ ଏନ୍ତାଃରେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ବାଚାନ୍‌ ଇତୁକେଦ୍‌ତେ ମିଦ୍‌ ବାରାଷ୍‌ ତୁରିୟା ମାହିଁନା ତାଇନ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ଗାଲିୟୋ ଆଖାୟା ପାର୍‌ଗାନ୍‌ରେନ୍‌ ରୋମାନ୍‌ ଲାଟ୍‌ସାହେବ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଯିହୁଦୀକ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିକେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ ସାବ୍‌କେଦ୍‌ତେ କାଚାଇରିତେକ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ଇନ୍‌କୁ କାଜିକେଦାକ, “ନେ ହଡ଼ ଆନ୍‌ଚୁ ବିରୁଧ୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ବରଭାକ୍ତି ନାଙ୍ଗ୍‌ ହଡ଼କକେ ଉସ୍‌କୁର୍‌କତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ପାଉଲୁସ୍‌ କାଜିରୁହାଡ଼୍‌ ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା, ଗାଲିୟୋ ଯିହୁଦୀ ହଡ଼କକେ କାଜିକେଦ୍‌କଆ, “ନେଆଁରେ ଜେତାନ୍‌ ଗୁହ୍ନାଁ ଚାଏ ଏତ୍‌କାନ୍‌ କାମି କାମିକାଦ୍‌ରେଦ, ଏ ଯିହୁଦୀ ହଡ଼କ, ଆଇଙ୍ଗ୍‌ ଧିରାଜ୍‌ରେ ଆପେୟାଃ କାଜି ଆୟୁମ୍‌ତେୟାଃ ଆଇଁୟାଃ ନାଙ୍ଗ୍‌ ବୁଗିନାଃ ହବାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ମେନ୍‌ଦ ନେ କାପ୍‌ଜି ଆପେୟାଃ ଆପ୍‌ନାଃ କାଜି, ନୁତୁମ୍‌ ଆଡଃ ଆନ୍‌ଚୁ ବିଷାଏରେୟାଃ ଏସ୍‌କାର୍‌ ତାନାଃ, ଏନାତେ ଆପେ ଆପେଗି ବିଚାର୍‌ରେପେ, ଆଇଙ୍ଗ୍‌ ନେ'ଲେକାନ୍‌ ବିଷାଏ କାଇଙ୍ଗ୍‌ ବିଚାରାଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ନେଆଁ କାଜିକେଦ୍‌ତେ ଇନିଃ ଇନ୍‌କୁକେ କାଚାଇରିହେତେ ହାର୍‍ଅଡଙ୍ଗ୍‌କେଦ୍‍କଆ । ");
INSERT INTO unx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ଇନ୍‌କୁ ସାମାଜ୍‌ଅଡ଼ାଃରେନ୍‌ ଆଗୁଆଇ ସସ୍ଥେନସ୍‌କେ ସାବ୍‌କେଦ୍‌ତେ କାଚାଇରି ଆୟାର୍‌ରେକ ଦାଲ୍‌କିୟା । ମେନ୍‌ଦ ଗାଲିୟୋ ଏନ୍‌ ବିଷାଏରେ ଜେତ୍‌ନାଃ କାଏ ଉଡ଼ୁଃକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ମେନ୍‌ଦ ପାଉଲୁସ୍‌ କରିନ୍ଥିରେନ୍‌ ବିଶ୍ୱାସୀ ହାଗା ମିଶିକଲଃ ପୁରାଃ ମାହାଁ ଜାକେଦ୍‌ ତାଇକେନାଏ । ଏନ୍ତେ ଇନ୍‌କୁ କେଙ୍କ୍ରେୟାଏତେ ଦାଆଃ ଜାହାଜ୍‌ରେ ସେନଃ ସିଦାରେ ଆୟାଃ କିରିୟାକାଦ୍‌ ଲେକାଗି ଇନିଃ ଆୟାଃ ବହଃରେୟାଃ ଉବ୍‌ ଠାଟୁୟାନାଏ । ଏନ୍ତେ ବିଶ୍ୱାସୀକକେ ବାଗିକେଦ୍‌ତେ ପ୍ରିସ୍‌କିଲା ଆଡଃ ଆକ୍ୱିଲାଲଃ ସିରିୟା ପାର୍‌ଗାନ୍‌ତେ ଦାଆଃ ଜାହାଜ୍‌ରେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ଇନ୍‌କୁ ଏଫିସୁସ୍‌ତେ ତେବାଃୟାନ୍‌ ତାୟମ୍‌ତେ ପାଉଲୁସ୍‌, ପ୍ରିସ୍‌କିଲା ଆଡଃ ଆକ୍ୱିଲାକେ ବିଦାକେଦ୍‌ତେ, ଇନିଃ ଏନ୍ତାଃରେ ସାମାଜ୍‌ ଅଡ଼ାଃତେ ସେନ୍‌କେଦ୍‌ତେ ଯିହୁଦୀ ହଡ଼କଲଃ ଜାଗାର୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ହଡ଼କ ଇନିଃକେ ଆଡଃଗି ପୁରାଃ ମାହାଁ ତାଇନ୍‌ ନାଗେନ୍ତେକ କାଜିକିୟା, ମେନ୍‌ଦ ଇନିଃ କାଏ ମାନାତିଙ୍ଗ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ବିଦାଅଃତାନ୍‌ ଇମ୍‌ତା ଇନିଃ ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆ, “ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଇଛାସାନାଙ୍ଗ୍‌ ତାଇନଃରେଦ, ଆଇଙ୍ଗ୍‌ ଆପେତାଃତେଇଙ୍ଗ୍‌ ହିଜୁଃ ରୁହାଡ଼ା ।” ଏନ୍ତେ ଇନିଃ ଏଫିସୁସ୍‌ତାଃଏତେ ଦାଆଃ ଜାହାଜ୍‌ରେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ଇନିଃ କାଇସରିୟାତେ ସେଟେର୍‌କେଦ୍‌ତେ ଏନ୍ତାଃଏତେ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃୟାନା ଆଡଃ କାଲିସିୟାରେନ୍‌ ହଡ଼କକେ ଜହାର୍‌କେଦ୍‌ତେ ଆନ୍ତିୟୋଖ୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ଏନ୍ତାଃରେ ଇନିଃ ଚିମିନ୍‌ଦିନ୍‌ ତାଇନ୍‌କେଦ୍‌ତେ ଗାଲାତିୟ ଆଡଃ ଫ୍ରୁଗିଆଃ ପାର୍‌ଗାନ୍‌ ହରାତେ ସେନଃୟାନା ଆଡଃ ହରାରେ ବିଶ୍ୱାସୀକକେ ଆକଆଃ ବିଶ୍ୱାସ୍‌ରେ ପେଡ଼େୟଃ ନାଗେନ୍ତେ ସବେନ୍‌କକେ ଉସ୍‌କୁର୍‌କେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ଏନ୍‌ ଦିପିଲିରେ ଆଲେକ୍‌ଜାଣ୍ଡ୍ରିଆ ନାଗାର୍‌ରେ ଜାନାମାକାନ୍‌ ଆପୋଲୋ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଯିହୁଦୀ ଏଫିସୁସ୍‌ତେ ହିଜୁଃୟାନା । ଇନିଃ ମିଆଁଦ୍‌ ପୁରାଃ ବୁଗିନ୍‌ କାଜି ଦାଡ଼ିନିଃ ଆଡଃ ଧାରାମ୍‌ପୁଥିରେ ଆୟାଃ ପୁରାଃ ସେଣାଁତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ଇନିଃ ପ୍ରାଭୁଆଃ ହରା ବିଷାଏରେ ଇତୁଆକାନାଏ ତାଇକେନା ଆଡଃ ପୁରାଃ ଆତ୍ମାରେ ଚିହୁଲ୍‌ତେ ୟୀଶୁଆଃ ବିଷାଏରେ ସାର୍‌ତିତେ ଇତୁ ତାଇକେନା । ମେନ୍‌ଦ ଇନିଃ ଯୋହାନ୍‌ଆଃ ବାପ୍ତିସ୍ମା ବିଷାଏରେ ଏସ୍‌କାର୍‌ ସାରିକାଦ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ଇନିଃ ବେଗାର୍‍ ବରତେ ଇତୁ ଏଟେଃକେଦ୍‌କଆ । ଆୟାଃ ଇନିତୁ ଆୟୁମ୍‌କେଦ୍‌ତେ ପ୍ରିସ୍‌କିଲା ଆଡଃ ଆକ୍ୱିଲା ଇନିଃକେ ଆକିନାଃ ଅଡ଼ାଃତେ ଇଦିକିୟାକିନ୍‌ ଆଡଃ ଏନ୍ତାଃରେ ଇନିଃକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ହରା ବିଷାଏରେ ପୁରାଃ ଠାଉକା ଲେକାତେ ଉଦୁବ୍‌କିୟାକିନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ଏନ୍ତେ ଆପୋଲୋ ଆଖାୟା ପାର୍‌ଗାନ୍‌ତେ ସେନଃ ସାନାଙ୍ଗ୍‌ ତାଇକେନ୍‌ ହରାତେ, ଏଫିସୁସ୍‌ରେନ୍‌ ବିଶ୍ୱାସୀକ ଇନିଃକେ ଦେଙ୍ଗାକିୟାକ ଆଡଃ ଇନିଃକେ ସୁକୁତେ ଦାରମ୍‌ ନାଗେନ୍ତେ କାଜିତାନ୍‌ଲଃ ଆଖାୟାରେନ୍‌ ବିଶ୍ୱାସୀକକେ ଚିଟାଉ ଅଲାଦ୍‌କଆକ । ଇନିଃ ଏନ୍ତାଃତେ ସେଟେର୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାୟାଦ୍‌ତେ ବିଶ୍ୱାସୀ ହବାକାନ୍‌ ହଡ଼କକେ ପୁରାଃଗି ଦେଙ୍ଗାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ୟୀଶୁ ମାସି ତାନିଃ ମେନ୍ତେ, ଆୟାଃ କେଟେୟାନ୍‌ କାପ୍‌ଜି ହରାତେ ଧାରାମ୍‌ପୁଥିଏତେ ସାବୁଦେତାନ୍‌ଲଃ ଉଦୁବ୍‌ତାନ୍‌ ଇମ୍‌ତା ଇନିଃ ଯିହୁଦୀକକେ ହାରାଅକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ଆପୋଲୋ କରିନ୍ଥିରେ ତାଇକେନ୍‌ ଇମ୍‌ତା, ପାଉଲୁସ୍‌ ସିଙ୍ଗିତୁରଃସାଃ ପାର୍‌ଗାନ୍‌କରେ ହରାସେନ୍‌ତାନ୍‌ଲଃ ଏଫିସୁସ୍‌ତେ ସେଟେର୍‌ୟାନା । ଏନ୍ତାଃରେ ଇନିଃ ଚିମିନ୍‌ ଚେଲାକଲଃ ନାପାମ୍‌ୟାନା ");
INSERT INTO unx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ଆଡଃ କୁଲିକେଦ୍‍କଆ, “ଆପେ ବିଶ୍ୱାସୀ ହବାୟାନ୍‌ ଇମ୍‌ତା ଚିନାଃ ପାବିତାର୍‍ ଆତ୍ମାକେପେ ନାମ୍‍କିୟା ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ପାବିତାର୍‌ ଆତ୍ମା ମେନ୍ତେ ଜେତାଏ ମେନାଇୟା, ନେ କାଜିୟ ଆଲେ କାଲେ ଆୟୁମ୍‌କାଦା ।” ");
INSERT INTO unx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ପାଉଲୁସ୍‌ କୁଲିକେଦ୍‌କଆଏ, “ତାବ୍‍ଦ, ଆପେ ଅକ ଲେକାନ୍‌ ବାପ୍ତିସ୍ମା ଇଦିକାଦାପେ ?” ଇନ୍‌କୁ କାଜିରୁହାଡ଼୍‌କିୟାକ, “ଯୋହାନ୍‌ଆଃ ବାପ୍ତିସ୍ମାରେ ।” ");
INSERT INTO unx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ପାଉଲୁସ୍‌ କାଜିକେଦ୍‌କଆଏ, “ଅକ ହଡ଼କ ପାପ୍‌ହେତେ ହେୟାତିଙ୍ଗ୍‌ ତାଇକେନାକ, ଯୋହାନ୍‌ଆଃ ବାପ୍ତିସ୍ମା ଇନ୍‌କୁ ନାଗେନ୍ତେ ଲାଗାତିଙ୍ଗ୍‌ ତାଇକେନା । ମେନ୍‌ଦ ଆୟାଃ ତାୟମ୍‌ତେ ଅକଏ ହିଜୁଃରାଃ ତାଇକେନା, ଇନିଃତାଃରେ ଚାଏ ୟୀଶୁତାଃରେ ବିଶ୍ୱାସ୍‌ ରିକା ଲାଗାତିୟାଃଁ ମେନ୍ତେ ଯୋହାନ୍‌ ଇସ୍ରାଏଲ୍‌ ହଡ଼କକେ କାଜିକାକ ତାଇକେନା ।” ");
INSERT INTO unx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ପ୍ରାଭୁ ୟୀଶୁଆଃ ନୁତୁମ୍‌ତେକ ବାପ୍ତିସ୍ମାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ପାଉଲୁସ୍‌ ଇନ୍‌କୁଆଃ ଚେତାନ୍‌ରେ ତିଃଇ ଦହକେଦାଏ ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମା ଇନ୍‌କୁ ଚେତାନ୍‌ରେ ଆଡ଼୍‌ଗୁୟାନା । ଇନ୍‌କୁ ରାକାମ୍‌ ରାକାମ୍‌ ଜାଗାର୍‌ତେ କାଜିକେଦାକ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାନାଜିକ ଉଦୁବ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ଇନ୍‌କୁ ସବେନ୍‌ ଗେଲ୍‌ବାର୍‌ ହାଗାକ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ପାଉଲୁସ୍‌ ଆପି ଚାଣ୍ଡୁଃ ଜାକେଦ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ବେଗାର୍‌ ବରତେ ହଡ଼କଲଃ ଜାଗାର୍‌ତାନ୍‌ଲଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ବିଷାଏରେ ଇନ୍‌କୁଆଃ ମନ୍‌କରେ ବିଶ୍ୱାସ୍‌ ଉପ୍‌ଜାଅ ସାନାଙ୍ଗ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ମେନ୍‌ଦ ଇନ୍‌କୁଏତେ ଚିମିନ୍‌ ହଡ଼କ କେଟେଦ୍‌ ମନ୍‌ରେନ୍‌ ତାଇକେନାକ, ଇନ୍‌କୁ କାକ ବିଶ୍ୱାସ୍‌କେଦା । ଇନ୍‌କୁ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ସବେନ୍‌କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ପ୍ରାଭୁଆଃ ହରା ବିଷାଏରେ ଏତ୍‌କାନ୍‌ କାଜିକ କାଜିକେଦା । ଏନାତେ ପାଉଲୁସ୍‌ ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌କଆ ଆଡଃ ବିଶ୍ୱାସୀକକେ ଇଦିକେଦ୍‌ତେ ସବେନ୍‌ ହୁଲାଙ୍ଗ୍‌ ତିରାନସ୍‌ ନୁତୁମ୍‌ ଇତୁନ୍‌ ଅଡ଼ାଃତାଃରେ ଜାଗାର୍‌ତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ବାର୍‌ ସିର୍ମା ଜାକେଦ୍‌ ନେଆଁଁ ହବାୟାନା । ଏସିଆ ପାର୍‌ଗାନ୍‌ରେ ତାଇନ୍‌ତାନ୍‌ ପୁରାଃ ଯିହୁଦୀ ଆଡଃ ସାଅଁସାର୍‌ ହଡ଼କ ପ୍ରାଭୁଆଃ ବାଚାନ୍‌ ଆୟୁମ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ପାର୍‌ମେଶ୍ୱାର୍‌ ପାଉଲୁସ୍‌ଆଃ ହରାତେ ମାପ୍‍ରାଙ୍ଗ୍‌ ଆକ୍‌ଦାନ୍ଦାଅ କାମିକଏ ରିକାକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ନେ'ଲେକାଚି ପାଉଲୁସ୍‌ ସାବାକାଦ୍‌ ରୁମାଲ୍‌ ଆଡଃ ଲିଜାଃକ ବେମାର୍‌ ହଡ଼କତାଃତେ ଇଦିୟଃରେ ଇନ୍‌କୁ ବୁଗିୟଃ ତାଇକେନାକ ଆଡଃ ଇନ୍‌କୁଆଃ ହଡ଼୍‌ମଏତେ ଏତ୍‌କାନ୍‌ ଆତ୍ମାକ ଅଡଙ୍ଗ୍‌ଅଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ଚିମିନ୍‌ ହନର୍‌ବାଡ଼ାତାନ୍ ଯିହୁଦୀ ହଡ଼କହଗି ପ୍ରାଭୁ ୟୀଶୁଆଃ ନୁତୁମ୍‌ ସାବ୍‌କେଦ୍‌ତେ ବଙ୍ଗା ହାର୍‌ଅଡଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌କେଦାକ । ଇନ୍‌କୁ ଏତ୍‌କାନ୍‌ ଆତ୍ମାକକେ କାଜିକ ତାଇକେନାକ, “ପାଉଲୁସ୍‌ ଉଦୁବ୍‌ତାନ୍‌ ୟୀଶୁଆଃ ନୁତୁମ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ଆଚୁମେତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ସ୍କେବା ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଯିହୁଦୀ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ଆଃ ଏୟା କଡ଼ା ହନ୍‍କ ଏନ୍‍ଲେକାକ କାମିତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ମେନ୍‌ଦ ଏତ୍‍କାନ୍‍ ଆତ୍ମା ଇନ୍‌କୁକେ କାଜିକେଦ୍‌କଆ, “ଆଇଙ୍ଗ୍‌ ୟୀଶୁକେଇଙ୍ଗ୍‌ ସାରିୟା ଆଡଃ ପାଉଲୁସ୍‌ଆଃ ବିଷାଏରେଇଙ୍ଗ୍‌ ସାରିୟା, ମେନ୍‌ଦ ଆପେ ଅକଏ ତାନ୍‌ପେ ?” ");
INSERT INTO unx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ଏତ୍‍କାନ୍‍ ଆତ୍ମାତେ ଏସେରେକାନ୍‌ ହଡ଼, ଇନ୍‌କୁକେ ପୁରାଃ ପେଡ଼େଃଲଃ ସାବ୍‌କେଟେଦ୍‌କେଦ୍‌ତେ ଥାପୁଇଃତାନ୍‌ ଇମ୍‌ତା ଇନ୍‌କୁଆଃ ଲିଜାଃକ ଚାଗାଡ଼୍‌ୟାନା ଆଡଃ ଇନ୍‌କୁଆଃ ହଡ଼୍‌ମକରେ ଘାଅବାଡ଼ାକେଦ୍‌ତେ ଇନିୟାଃ ଅଡ଼ାଃଏତେ ନିର୍‌ୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ଏଫିସୁସ୍‌ରେ ତାଇନ୍‍ତାନ୍ ସବେନ୍‌ ଯିହୁଦୀ ଆଡଃ ସାଅଁସାର୍‌ ହଡ଼କ ନେ ବିଷାଏ ଆୟୁମ୍‌କେଦ୍‌ତେ ବରତେ ପେରେଃୟାନାକ ଆଡଃ ଏନ୍ତାଃରେ ପ୍ରାଭୁ ୟୀଶୁଆଃ ନୁତୁମ୍‌ ଆଡଃଗି ପୁରାଃତେ ମାଇନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ବିଶ୍ୱାସୀକଏତେ ପୁରାଃ ହଡ଼କ ହିଜୁଃକେଦ୍‍ତେ ଆକଆଃ ଏତ୍‌କାନ୍‌ କାମିକ ରିକାକାଦ୍‌ତେୟାଃ ହଡ଼କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେକ ମାନାତିଙ୍ଗ୍‌ୟାନା ଆଡଃକ ଉଦୁବ୍‍କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ଦେଅଁଣାକାମି ରିକାତାନ୍‍କଏତେ ପୁରାଃ ହଡ଼କ ଆକଆଃ ପୁଥିକ ଆଉ ହୁଣ୍ଡିକେଦ୍‌ତେ ହଡ଼କଆଃ ସାମ୍‍ନାଙ୍ଗ୍‌ରେକ ଅଣ୍ଡର୍‌କେଦା । ଇନ୍‌କୁଆଃ ପୁଥିକରାଃ ଗନଙ୍ଗ୍‌ ଲେକାକେଦ୍‌ରେ ବାର୍‌ହିସି ଗେଲ୍‌ ହାଜାର୍‌ ରୁପା ସିକା ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ନେ'ଲେକାତେ ପ୍ରାଭୁଆଃ ବାଚାନ୍‌ ପୁରାଃଗି ନିତିର୍‌ୟାନା ଆଡଃ ପୁରାଃତେ ପେଡ଼େଃଇଦିୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ନେଆଁଁ ସବେନ୍‌ ହବାୟାନ୍‌ ତାୟମ୍‌ତେ ପାଉଲୁସ୍‌ ମାକିଦନିଆ ଆଡଃ ଆଖାୟା ହରାତେ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃ ନାଙ୍ଗ୍‌ ମନ୍‌ରେ ଉହାଟ୍‌କେଦା । ଇନିଃ କାଜିକେଦାଏ, “ଏନ୍ତାଃତେ ସେନ୍‌ ତାୟମ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଜାରୁଡ଼୍‌ଗି ରୋମ୍‌ତେହଗି ସେନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ଏନାତେ ଇନିଃ ଆଇଃକ୍‌କେ ଦେଙ୍ଗାଇତାନ୍‌ ବାରାନ୍‌କିନ୍‌ ତୀମଥି ଆଡଃ ଏରାଷ୍ଟକେ ମାକିଦନିଆତେ କୁଲ୍‌କେଦ୍‌କିନା, ମେନ୍‌ଦ ଆଇଃକ୍‌ଗି ଏସିଆ ଦିଶୁମ୍‌ରେ ଆଡଃଚିମିନ୍‌ ମାହାଁ ତାଇନ୍‌ୟାନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ଏନ୍‌ ଦିପିଲିରେ ପ୍ରାଭୁଆଃ ହରା ବିଷାଏ ନାଗେନ୍ତେ ଏଫିସୁସ୍‌ରେ ପୁରାଃ ବରୱାନ୍‌ଗି ହାଲାଗୁଲା ହବାୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ଦିମତ୍ରିୟ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସୁନାରିହଡ଼ ଆର୍ତ୍ତେମୀ ମାହାପୁରୁଆଃ ରୁପାରାଃ ମାନ୍ଦିର୍‌ ବାଇତାଇକେନାଏ, ନେ କାମିରେ କାମିତାଇକେନ୍‌ ହଡ଼କ ପୁରାଃଗି ଟାକା ପାଏସାକ ନାମେ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ଏନାମେନ୍ତେ ଇନିଃ କାମିତାନ୍‌ ସବେନ୍‌ ହଡ଼କକେ ଆଡଃ ଏନ୍‌ ଲେକାନ୍‌ କାମିତାନ୍‌ ଏଟାଃସାଃରେନ୍‌ ହଡ଼କକେ ହାକାଅକେଦ୍‌ତେ କାଜିକେଦ୍‌କଆ, “ମାଇନାନ୍‌କ, ନେ କାମିରେ ଆବୁ ସବେନ୍‌କ ପୁରାଃଗି ଟାକା ପାଏସାବୁ କାମିତାନା ଏନାଦପେ ସାରିତାନା । ");
INSERT INTO unx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ନାହାଁଃ ନେ ହଡ଼ ପାଉଲୁସ୍‌ ଚିନାଃଏ ଚିକାଏତାନା, ଏନା ଆପେ ନେଲ୍‌ ଦାଡ଼ିତାନାପେ ଆଡଃ ଆୟୁମ୍‌ ଦାଡ଼ିତାନାପେ । ଇନିଃ କାଜିତାନାଏ, ହଡ଼ଆଃ ତିଃଇତେ ବାଇକାନ୍‌ ମାହାପୁରୁକ ମାହାପୁରୁ ନାହାଁଲାକ, ଆଡଃ ଇନିଃ ନେତାଃରେ ଏଫିସୁସ୍‌ ଆଡଃ ପୁରା ଏସିଆ ପାର୍‌ଗାନ୍‌ରେ ପୁରାଃ ହଡ଼କକେ ନେ ବିଷାଏରେ କାଜିକତାନା । ");
INSERT INTO unx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ଏନାତେ ଆବୁଆଃ କାମାନି ଜିୟନ୍‌କେନଃଆ, ଇମ୍‌ନାଙ୍ଗ୍‌ ଏସ୍‌କାର୍‌ କାହାଗି, ମେନ୍‌ଦ ଅକ ମାହାପୁରୁ ଆର୍ତ୍ତେମୀକେ ଗଟା ଏସିଆରେ ଆଡଃ ପୁରା ଅତେଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କ ବରଭାକ୍ତିତାନା, ଏନ୍‌ ପୁରାଃମାରାଙ୍ଗ୍‌ ଆର୍ତ୍ତେମୀ ମାହାପୁରୁଆଃ ମାନାରାଙ୍ଗ୍‌ କା ତାଇନା ଆଡଃ ମାନ୍ଦିର୍‌ ଜିୟନଃଆ, ଏନାରେୟାଃ ବରମେନାଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ଗାଦେଲ୍‌ ହଡ଼କ ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଖିସ୍‍ତେକ ପେରେଃୟାନା ଆଡଃ କାଉରିକେଦ୍‍ତେ କାଜିକେଦାକ, “ଏଫିସୁସ୍‌ରେନ୍‌କଆଃ ଆର୍ତ୍ତେମୀ ମାହାପୁରୁଆଃ ମାରାଙ୍ଗ୍‌ ହବାଅଃକା ।” ");
INSERT INTO unx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ନେ ହାଲାଗୁଲା ଗଟା ନାଗାର୍‌ରେ ନିତିର୍‌ୟାନା । ଆଡଃ ଗାଦେଲ୍‌ ହଡ଼କ ପାଉଲୁସ୍‌ଲଃ ହରାସେନ୍‌ତାନ୍‌ ମାକିଦନିଆରେନ୍‌ ଗାୟସ୍‌ ଆଡଃ ଆରିସ୍ତାର୍ଖକେ ସାବ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ମାରାଙ୍ଗ୍‌ ଆଖ୍‌ଡ଼ାତେକ ଥାଇଜ୍‌ ଇଦିକେଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ପାଉଲୁସ୍‌ ଆଇଃକ୍‌ଗି ଗାଦେଲ୍‌ ହଡ଼କ ଆୟାର୍‌ତେ ସେନ୍‌ ନାଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌କେଦାଏ, ମେନ୍‌ଦ ବିଶ୍ୱାସୀକ କାକ ସେନ୍‌ ଇଚିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ଚିମିନ୍‌ଝାନ୍‌ ଏସିଆରେ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ ପାଉଲୁସ୍‌ଆଃ ଗାତିକ ନେଆଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ ମାରାଙ୍ଗ୍‌ ଆଖ୍‌ଡ଼ାତେ ଆଲକାଏ ସେନ୍‌କା ମେନ୍ତେ ମିହୁଡ଼୍‌ତାଃରେ କାଜିଗହାର୍‌ କାଜିକୁଲ୍‌କେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ନେ ଘାଡ଼ି ଭିତାର୍‌ରେ ଗଟା ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ହଡ଼କ ଖିସ୍‌ତେ ପେରେଃୟାନାକ । ହଡ଼କ ଏଟାଃ ଏଟାଃ ଝୁଣ୍ଡ୍‌ରେ ରାକାମ୍‌ ରାକାମ୍‌କ କାଉରିତାନ୍‌ ତାଇକେନା, ଚିଆଃଚି ଇନ୍‌କୁଏତେ ଚିମିନ୍‌ ହଡ଼କ ଏନ୍ତାଃରେ ଚିନାଃନାଙ୍ଗ୍‌କ ହୁଣ୍ଡିକାନା ଏନାହ କାକ ସାରିକାଦ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ହଡ଼କଏତେ ଚିମିନ୍‌ ହଡ଼କ କାଜିକେଦାକ ଯେ, ଆଲେକ୍‌ଜାଣ୍ଡାର୍‌ ନେଆଁ ନାଗେନ୍ତେ ଦାୟୀ ତାନିଃ, ଚିଆଃଚି ଯିହୁଦୀ ହଡ଼କ ଇନିଃକେ ଆୟାର୍‌ରେ ତିଙ୍ଗୁକାଇ ତାଇକେନାକ । ଏନ୍ତେ ଆଲେକ୍‌ଜାଣ୍ଡାର୍‌ ତିଃଇ ଉଠାଅକେଦ୍‌ତେ ହଡ଼କକେ ହାପାଅଃପେ ମେନ୍ତେ ଠାରାଅକେଦ୍‌କଆ ଆଡଃ ବିଶ୍ୱାସୀକଆଃସାଃଏତେ କାଜିତାନ୍‌ଲଃ ଇନିଃ ବୁଝାଅକ ନାଙ୍ଗ୍‌ ଚେଷ୍ଟାକେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ମେନ୍‌ଦ ଇନିଃ ମିଆଁଦ୍‌ ଯିହୁଦୀ ତାନିଃ, ମେନ୍ତେ ସାରିକେଦ୍‌ତେ ଇନ୍‌କୁ ସବେନ୍‌କ ମିସାତେ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାକ, “ଏଫିସୁସ୍‌ରେନ୍‌ ଆର୍ତ୍ତେମୀ ମାହାପୁରୁଆଃ ମାରାଙ୍ଗ୍‌ଅଃକା ।” ନେ'ଲେକା ବାର୍‌ ଘାଡ଼ି ଜାକେଦ୍‌କ କାଉରିକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ଟୁଣ୍ଡୁରେ ସାହାର୍‌ରେନ୍‌ ମୁନ୍‌ସି ହଡ଼କକେ ହାପାଅଃ ନାଗେନ୍ତେ କାଜିକେଦ୍‌କଆ, “ଏଫିସୁସ୍‌ରେନ୍‌ ହାଗାକ, ସବେନ୍‌କ ସାରିତାନା ଯେ, ଏଫିସୁସ୍‌ ନାଗାର୍‌ରେନ୍‌ ଆର୍ତ୍ତେମୀ ମାହାପୁରୁଆଃ ମାନ୍ଦିର୍‌ ଆଡଃ ସିର୍ମାଏତେ ଆଡ଼୍‌ଗୁକାନ୍‌ ପାବିତାର୍‌ ମୁରୁତ୍‌ରାଃ ବାଞ୍ଚାଅ ହବାଆଉଃତାନା । ");
INSERT INTO unx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ଜେତାଏ ନେଆଁକେ କାହା ମେନ୍ତେ କାକ କାଜି ଦାଡ଼ିୟା । ଏନାତେ ଆପେ ସବେନ୍‌କ ହାପାଅଃପେ ଆଡଃ କା ଲାଗାତିଙ୍ଗ୍‌ ଲେକା ଜେତାନ୍‌ କାମି ଆଲପେ କାମିୟା । ");
INSERT INTO unx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ନେ ହଡ଼କିନ୍‌ ମାନ୍ଦିର୍‌ହେତେ ଜେତ୍‌ନାଃ କାକିନ୍‌ କୁମ୍ବୁଡ଼ୁକାଦା, ଚାଏ ଆବୁଆଃ ମାହାପୁରୁ ବିଷାଏରେ ଜେତାନ୍‌ ଏତ୍‌କାନାଃ କାକିନ୍‌ କାଜିକାଦା, ଏନ୍‌ରେୟ ଆପେ ନେ ହଡ଼କିନ୍‌କେ ନେତାଃତେପେ ଆଉକାଦ୍‌କିନା । ");
INSERT INTO unx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ଦିମତ୍ରିୟ ଆଡଃ ଇନିୟାଃ କାମି ହଡ଼କଆଃ ବିରୁଧ୍‌ରେ ଜେତାନ୍‌ କାଜି ମେନାଃରେଦ, ଏନା ବିଚାରେ ନାଗେନ୍ତେ ଆବୁଆଃ ଆକ୍‌ତେୟାର୍‌ ନାମାକାଦ୍‌ ହଡ଼କ ମେନାକଆ ଆଡଃ କାଚାଇରି ମେନାଃ, ଏନ୍ତାଃରେ ଏନ୍‌ ବିରୁଧ୍‌କାନ୍‌ କାଜିକ ଉଦୁବଃଆ । ");
INSERT INTO unx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ମେନ୍‌ଦ ନେଆଁଏତେ ଆଡଃ ଆଦ୍‌କାପେ ସାନାଙ୍ଗ୍‌ତାନ୍‌ରେଦ, ଆପ୍‌ନାଃ ଦିଶୁମ୍‌ରେନ୍‌ ହଡ଼କଆଃ ଆଇନ୍‌ ମାନାତିୟଁଃ ପାଞ୍ଚେଟ୍‌ରେ ଏନା ବିଚାରଃକା । ");
INSERT INTO unx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ଚିଆଃଚି ତିସିଙ୍ଗ୍‌ ଅକ୍‌ନାଃ ହବାକାନା, ଏନା ବରୱାନ୍‌ଗିଆ ଏନା ହିସିଙ୍ଗାତେ ନେଆଁ ହବାକାନା ମେନ୍ତେ ଆଲେୟାଃ ବିରୁଧ୍‌ରେ କାଜିୟଃତାନା । ଆଲେ ନେ ସବେନ୍‌ ହାଲାଗୁଲାରେୟାଃ ଜେତାନ୍‌ ବୁଗିନ୍‌ କାଜି କାଲେ କାଜି ଦାଡ଼ିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ନେ ସବେନ୍‌ କାଜି କାଜିକେଦ୍‌ତେ ଇନିଃ ଗାଦେଲ୍‌ ହଡ଼କକେ ହାପାକେଦ୍‌କଆଏ ଆଡଃ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ହଡ଼କକେ ବିଦାକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ହାଲାଗୁଲା ଚାବାୟାନ୍‌ ତାୟମ୍‌ତେ, ପାଉଲୁସ୍‌ ବିଶ୍ୱାସୀକକେ ହୁଣ୍ଡିକେଦ୍‌ତେ ଜୀଉରେ ରାସ୍‌କାଅଃ ଲେକାନ୍‌ କାଜି ଉଦୁବାଦ୍‌କଆଏ । ଇନ୍‌କୁତାଃଏତେ ବିଦା ଇଦିକେଦ୍‌ତେ ଇନିଃ ମାକିଦନିଆତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ଇନିଃ ଏନ୍‌ ସବେନ୍‌ ପାର୍‌ଗାନ୍‌ ହରାତେ ସେନଃୟାନା ଆଡଃ ବିଶ୍ୱାସୀ ହଡ଼କକେ ଜୀଉରେ ରାସ୍‌କାଅଃରାଃ କାଜି କାଜିକେଦ୍‌କଆ । ଏନ୍ତେ ଇନିଃ ଗ୍ରୀସ୍‌ ଦିଶୁମ୍‌ତେ ହିଜୁଃୟାନା, ");
INSERT INTO unx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ଏନ୍ତାଃରେ ଆପି ମାହିଁନା ତାଇନ୍‌ୟାନାଏ । ଇନିଃ ସିରିୟାତେ ସେନଃ ନାଗେନ୍ତେ ସେକାଡ଼େନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଯିହୁଦୀ ହଡ଼କ ଇନିକେ ଗଏଃ ନାଗେନ୍ତେକ ରୋଜୋଟତାନା ମେନ୍ତେ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନିଃ ମାକିଦନିଆ ହରାତେ ରୁହାଡ଼୍‌ ନାଗେନ୍ତେ ଉହାଟ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ବେରିଆ ନାଗାର୍‌ରେ ତାଇନ୍‌ତାନ୍‌ ପୁରସ୍‌ଆଃ ହନ୍‌ ସୋପାତ୍ର, ଥେସ୍‌ଲନିକାରେନ୍‌ ଆରିସ୍ତାର୍ଖ ଆଡଃ ସେକୁନ୍ଦ, ଦର୍ବୀରେନ୍‌ ଗାୟସ୍‌, ଏସିଆ ପାର୍‌ଗାନ୍‌ରେନ୍‌ ତୁଖିକ୍‌, ତ୍ରଫିମ୍‌ ଆଡଃ ତୀମଥି ଇନିଃଲଃ ସେନଃୟାନାକ । ");
INSERT INTO unx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ନେ ଏୟାଝାନ୍‌ ହଡ଼କ ସିଦାରେ ସେନ୍‌କେଦ୍‌ତେ ତ୍ରୋୟାସ୍‌ରେ ଆଲେକେ ତାଙ୍ଗିକାଲେ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ସାବାଃ ହଲଙ୍ଗ୍‌ ପାରାବ୍‌ ତାୟମ୍‌ତେ ଆଲେ ଫିଲିପି ସାହାର୍‌ଏତେ ଦାଆଃ ଜାହାଜ୍‌ରେ ସେନଃକେଦ୍‌ତେ ମଣେଁମାହାଁ ତାୟମ୍‌ତେ ତ୍ରୋୟାସ୍‌ରେ ଏନ୍‌ ଏୟାଝାନ୍‌ ହଡ଼କଲଃ ମେସାୟାନାଲେ ଆଡଃ ଏନ୍ତାଃରେ ମିଦ୍‌ ହାପ୍ତା ତାଇନ୍‌ୟାନାଲେ । ");
INSERT INTO unx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ହାପ୍ତାରେୟାଃ ସିଦା ହୁଲାଙ୍ଗ୍‌ ସିଙ୍ଗିହାସୁର୍‌ରେ ଆଲେ ମେନେସାରାଃ ହଲଙ୍ଗ୍‌ କେଚାଃ ମିଦ୍‌ତାଃରେ ହୁଣ୍ଡିକେଦ୍‌ତେ ମାନାତିଙ୍ଗ୍‌କେଦାଲେ । ପାଉଲୁସ୍‌ ହଡ଼କକେ ଥାଲାନିଦା ଜାକେଦ୍‌ ଜାଗାର୍‌କେଦ୍‌କଆଏ, ଚିଆଃଚି ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଇନିଃ ଏନ୍‌ ଠାୟାଦ୍‌ ବାଗିକେଦ୍‌ତେ ସେନଃରାଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ଆଲେ ଅକ ଚେତାନ୍‌ କୁଠାରେ ହୁଣ୍ଡିକାନ୍‌ ତାଇକେନାଲେ, ଏନ୍ତାଃରେ ପୁରାଃ ଦିମିକ ଜୁଲଃତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ଏନ୍ତାଃରେ ଇଉଟିକସ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ସେପେଡ଼େଦ୍‌ ଖିଡ଼୍‌କି ଚେତାନ୍‌ରେ ଦୁବାକାନ୍‌ ତାଇକେନା ଆଡଃ ପାଉଲୁସ୍‌ ଜାଗାର୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଇନିଃକେ ଦୁଡ଼ୁମିତାଇକେନା । ଏନ୍ତେ ଇନିଃ ପୁରା ଦୁଡ଼ୁମ୍‌ୟାନାଏ ଆଡଃ ଆପି ମାହାଲା ଚେତାନ୍‌ହେତେ ଲାତାର୍‌ରେ ଉୟୁଃୟାନା । ଇନ୍‌କୁ ଇନିଃକେ ବିରିଦ୍‌କିୟାକ ଇମ୍‌ତା ଇନିୟାଃ ଜୀଉ ଟୁଣ୍ଡୁକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ମେନ୍‌ଦ ପାଉଲୁସ୍‌ ଲାତାର୍‌ତେ ଆଡ଼୍‌ଗୁକେଦ୍‌ତେ ଇନିଃକେ ହାମ୍ବୁଦ୍‌କିୟାଏ ଆଡଃ କାଜିକେଦାଏ, “ଆଲପେ ଆଡ଼ାଃଉଡ଼ୁଗଃଆ, ଇନିଃ ଜୀନିଦ୍‌ଗି ମେନାଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ଏନ୍ତେ ଇନିଃ ଚେତାନ୍‌ତେ ରାକାବ୍‌ ରୁହାଡ଼୍‌ୟାନାଏ ଆଡଃ ହଲଙ୍ଗ୍‌ କେଚାଃକେଦ୍‍ତେ ଜମ୍‍କେଦାଏ, ଏନ୍ତେ ସିଙ୍ଗିତୁରଃ ଜାକେଦ୍‌ ଇନ୍‌କୁଲଃ ପୁରାଃଗି ଜାଗାର୍‌କେଦା ଆଡଃ ଏନ୍ତାଃଏତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ହଡ଼କ ସେପେଡ଼େଦ୍‌କେ ଜୀନିଦ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ଆୟାଃ ଅଡ଼ାଃତେକ ଇଦିକିୟା ଆଡଃ ପୁରାଃଗି ଜୀଉରାଡ଼େଃକ ନାମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ଆଲେ ସିଦାରେ ଦାଆଃ ଜାହାଜ୍‌ରେ ଦେଏଃକେଦ୍‌ତେ ଆସେସ୍‌ ନାଗାର୍‌ତେଲେ ସେନଃୟାନା । ଏନ୍ତାଃଏତେ ଆଲେ ପାଉଲୁସ୍‌କେ ଦାଆଃ ଜାହାଜ୍‌ରେ ଇଦି ନାଗେନ୍ତେଲେ ଉହାଟ୍‌କାଦ୍‌ ତାଇକେନା, ଚିଆଃଚି ଇନିଃ ଅତେ ହରାରେ ସେନ୍‌କେଦ୍‌ତେ ଏନ୍‌ ଠାୟାଦ୍‌ତେ ସେଟେରା ମେନ୍ତେ କାଜିକାଦ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ଇନିଃ ଚିମ୍‌ତା ଆଲେଲଃ ଆସେସ୍‌ରେ ନାପାମ୍‌ୟାନା, ଆଲେ ଇନିଃକେ ଦାଆଃ ଜାହାଜ୍‌ରେ ଇଦିକେଦ୍‌ତେ ମିତିଲିନ୍‌ ନାଗାର୍‌ତେଲେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ଏନ୍ତାଃଏତେ ଆଡଃଗି ସେନଃକେଦ୍‌ତେ ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଖିଅସ୍‌ ଟାପୁତାଃଲେ ସେଟେର୍‌ୟାନା । ଆଡଃମୁସିଙ୍ଗ୍‌ ତାୟମ୍‌ତେ ଆଲେ ସାମସ୍‌ ଟାପୁତେ ସେଟେର୍‌କେଦ୍‌ତେ, ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ମିଲିତସ୍‌ ନାଗାର୍‌ତେଲେ ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ଏସିଆ ପାର୍‌ଗାନ୍‌ରେ ଆଡଃ ଆଦ୍‌କା ନେଡା କା ଇଦିକେଦ୍‌ତେ ଏଫିସୁସ୍‌ ଗେନା ଗେନାତେ ଦାଆଃ ଜାହାଜ୍‌କେ ଇଦି ନାଗେନ୍ତେ ପାଉଲୁସ୍‌ ଉହାଟ୍‌କେଦାଏ । ଆଡଃ ହବାସାକାଅଃରେଦ, ପେଣ୍ଟିକଷ୍ଟ୍‌ ହୁଲାଙ୍ଗ୍‌ରେ ଯୀରୁଶାଲେମ୍‌ତେ ଜାଲ୍‌ଦି ସେଟେର୍‌ ନାଙ୍ଗ୍‌ ଇନିଃ ଉହାଟ୍‌କାଦ୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ପାଉଲୁସ୍‌ ମିଲିତସ୍‌ତାଃଏତେ ଏଫିସୁସ୍‌ କାଲିସିୟାରେନ୍‌ ପ୍ରାଚିନ୍‌କକେ ଆୟାଃଲଃ ନେପେଲ୍‌ ନାଗେନ୍ତେ କାଜିକୁଲ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ଇନ୍‌କୁ ପାଉଲୁସ୍‌ତାଃ ତେବାଃୟାନ୍‌ଚି ଇନିଃ କାଜିକେଦାଏ, “ଏସିଆ ପାର୍‌ଗାନ୍‌ ସେଟେର୍‌ୟାନ୍‌ ପାହିଲା ହୁଲାଙ୍ଗ୍‌ତାଃଏତେ ଆଇଙ୍ଗ୍‌ ଚିଲ୍‌କା ଆପେଲଃ ଆଦ୍‌କା ନେଡା ବିତାଅକାଦାଇଙ୍ଗ୍‌, ଏନା ଆପେ ସାରିକାଦାପେ । ");
INSERT INTO unx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ଯିହୁଦୀ ହଡ଼କ ଆଇଙ୍ଗ୍‌କେ ଗଗଏଃ ନାଗେନ୍ତେକ ରୋଜୋଟ ତାଇକେନ୍‌ ହରାତେ ଆଇଙ୍ଗ୍‌ ପୁରାଃ ଦୁକୁହାସୁ ସାହାତିଙ୍ଗ୍‌କେଦାଇଙ୍ଗ୍‌, ଏନ୍‌ରେୟ ଆଇଙ୍ଗ୍‌ ପ୍ରାଭୁଆଃ ଦାସି ଲେକା ଲେବେଃ ମନ୍‌ତେ ଆଡଃ ପୁରାଃ ରାଆଃତାନ୍‌ଲଃ ଆଇଁୟାଃ କାମି କାମିକାଦାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ଆପେ ସାରିତାନାପେ, ଆଇଙ୍ଗ୍‌ ହଡ଼କତାଃରେ ଉଦୁବ୍‌ତାନ୍‌ ଇମ୍‌ତା ଆଡଃ ଆପେୟାଃ ଅଡ଼ାଃରେ ଇତୁତାନ୍‌ ଇମ୍‌ତା ଆପେୟାଃ ବୁଗିନାଃ ହବାଅଃ ଲେକା ଜେତାନ୍‌ ବିଷାଏ ଉଦୁବ୍‌ ନାଗେନ୍ତେ କାଇଙ୍ଗ୍‌ ହିଚ୍‌କିଚାଅକାଦା । ");
INSERT INTO unx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ଯିହୁଦୀ ଆଡଃ ସାଅଁସାର୍‌ ସବେନ୍‌କକେ ଆଇଙ୍ଗ୍‌ ପୁରାଃଗି ଚିର୍ଗାଲାନ୍‌ କାଜିକଇଙ୍ଗ୍‌ କାଜିକାଦ୍‌ପେ ତାଇକେନା, ଜେ'ଲେକା ଇନ୍‌କୁ ଆକଆଃ ପାପ୍‌କ ହେୟାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ପାର୍‌ମେଶ୍ୱାର୍‌ସାଃତେକ ହିଜୁଃରୁହାଡ଼ା ଆଡଃ ପ୍ରାଭୁ ୟୀଶୁତାଃରେ ବିଶ୍ୱାସ୍‌ ରିକାଏୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ନାହାଃଁଦ ପାବିତାର୍‌ ଆତ୍ମାରାଃ ଆନାଚୁ ମାନାତିଙ୍ଗ୍‌କେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଯୀରୁଶାଲେମ୍‌ତେଇଙ୍ଗ୍‌ ସେନଃତାନା, ଏନ୍ତାଃରେ ଆଇଁୟାଃ ଚିକ୍‌ନାଃ ହବାଅଃଆ ଏନା କାଇଙ୍ଗ୍‌ ସାରିୟା । ");
INSERT INTO unx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ପାବିତାର୍‌ ଆତ୍ମା ଆଇଙ୍ଗ୍‌କେ ଚେତାଅକାଦିୟାଁ ଚି, ସବେନ୍‌ ନାଗାର୍‌ରେ ଆଇଙ୍ଗ୍‌ ଜେହେଲ୍‌ରେ ସାଜାଇ ଆଡଃ ଦୁକୁଇଙ୍ଗ୍‌ ନାମେୟା । ");
INSERT INTO unx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଆପ୍‌ନାଃ ଜୀଦାନ୍‌କେ ଜେତ୍‌ନାଃ ଲେକା କା ଆଟ୍‌କାର୍‌କେଦ୍‌ତେ, ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ସାୟାଦ୍‌ ବିଷାଏରେ ପ୍ରାଭୁ ୟୀଶୁ ଆଇଙ୍ଗ୍‌କେ ଅକ ସୁକୁକାଜି ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଏମାକାଦିଙ୍ଗ୍‌ ସେୱାକାମିକେ ଜେ'ଲେକା ପୁରା ଦାଡ଼ିୟାଇଙ୍ଗ୍‌, ନିମିନାଙ୍ଗ୍‌ ଏସ୍‌କାର୍‌ ଆଇଁୟାଃ ଇଛାସାନାଙ୍ଗ୍‌ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ରାଇଜ୍‌ ବିଷାଏରେ ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆପେ ସବେନ୍‌କତାଃତେଇଙ୍ଗ୍‌ ସେନାକାନା । ନାହାଁଃ ଆଇଙ୍ଗ୍‌ ସାରିତାନାଇଙ୍ଗ୍‌ ଯେ, ଆପେକଏତେ ଜେତାଏ ଆଇଙ୍ଗ୍‌କେ ଆଡଃମିସା କାପେ ନେଲିୟାଁ । ");
INSERT INTO unx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ଏନାମେନ୍ତେ ତିସିଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ ଆପେତାଃରେ ଗାୱା ଏମ୍‌ତାନାଇଙ୍ଗ୍‌ ଯେ, ଆପେକଏତେ ଜେତାଏ ଜିୟନଃରେଦ ଏନାରେୟାଃ ଦାୟୀ ଆଇଙ୍ଗ୍‌ ନାହାଁଲିଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ଚିଆଃଚି ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ଗଟା ଉଦ୍ଦେଶ୍‌ ଆପେତାଃରେ ଉଦୁବ୍‌ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ହିଚ୍‌କିଚାଅକାଦା । ");
INSERT INTO unx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ଏନାମେନ୍ତେ ଆପେ ଆଗୁଆଇ ଲେକା ଆପାନ୍‌କେ ଆଡଃ ପାବିତାର୍‌ ଆତ୍ମା ଏମାକାଦ୍‌ପେ ବିଶ୍ୱାସୀ ଗୋଟ୍‌ କକେ ଯାତ୍‌ନାଅକପେ । ମିଣ୍ଡିଗୁପିନିଃ ଲେକା ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାଲିସିୟାକେ ଯାତ୍‌ନାଏପେ । ଅକ କାଲିସିୟାକେଚି ଇନିଃ ଆୟାଃ ହନ୍‌ଆଃ ମାୟୋମ୍‌ ହରାତେ ଆପ୍‌ନାଃ ବାଇୟାକାଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ଆଇଙ୍ଗ୍‌ ସାରିତାନାଇଙ୍ଗ୍‌, ଆଇଙ୍ଗ୍‌ ସେନଃ ତାୟମ୍‌ତେ ଆପେ ଥାଲାତେ ହସଡ଼ ଇତୁକ ହିଜୁଃଆ ଆଡଃ ବିଶ୍ୱାସୀକକେ ହସଡ଼ ଇନିତୁକ ଇତୁକଆ । ଇନ୍‌କୁ ମିଣ୍ଡିଗୋଟ୍‌କେ ନକ୍‌ସାନ୍‌କତାନ୍‌ ବରୱାନ୍‌ ହୁଣ୍ଡାର୍‌କ ଲେକାନ୍‌କ ତାନ୍‌କ । ");
INSERT INTO unx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ନେଡା ସେଟେରା, ଚିମ୍‌ତା ଆପେୟାଃ ଆପ୍‌ନାଃ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ଚିମିନ୍‌ ହଡ଼କ ବିଶ୍ୱାସୀକକେ ହସଡ଼ କାଜି କାଜିକେଦ୍‌ତେ ଏଟାଃ ହରାତେକ ଇଦିକଆ । ");
INSERT INTO unx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ଏନାମେନ୍ତେ ଏୟନାକାନ୍‌ ତାଇନ୍‌ପେ, ଆଇଙ୍ଗ୍‌ ନିଦା ସିଙ୍ଗି ମେଦ୍‌ ଦାଆଃ ଜରକେଦ୍‌ତେ ଆପି ସିର୍ମା ଜାକେଦ୍‌ ଆପେ ସବେନ୍‌କକେଇଙ୍ଗ୍‌ ଇତୁକାଦ୍‌ପେୟା, ନେୟାଁ ପାହାମେପେ । ");
INSERT INTO unx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ନାହାଁଃ ଆଇଙ୍ଗ୍‌ ଆପେକେ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ତିଃଇରେ ଆଡଃ ଆୟାଃ ସାୟାଦ୍‌ରାଃ କାନାଜିରେଇଙ୍ଗ୍‌ ଜିମାପେତାନା, ଏନା ଆପେକେ ବାଇକେଟେଦ୍‌ପେ ନାଗେନ୍ତେ ଆଡଃ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ପାବିତାର୍‌କାନ୍‌ ହଡ଼କ ନାଗେନ୍ତେ ହବାଅଃ ସବେନ୍‌ ଆଶିଷ୍‌, ଆପେକେ ଏମ୍‌ ଦାଡ଼ି ଲେକାନାଃ ତାନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ଆଇଙ୍ଗ୍‌ ଜେତାଏୟାଃ ରୁପା, ସୋନା ଚାଏ ଲିଜାଃ ନାମେ ନାଗେନ୍ତେ କାଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ଆପେ ସାରିତାନାପେ, ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ନେ ବାରାନ୍‌ ତିଃଇତେ କେଟେଦ୍‌ କାମି କାମିକେଦ୍‌ତେ ଆପ୍‌ନାଃ ଆଡଃ ଆଇଁୟାଃଲଃ ମିସାତେ କାମିତାନ୍‌କଆଃ ଲାଗାତିଙ୍ଗ୍‌ତେୟାଃ ପୁରାକାଦାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‘ନାମେତାଃଏତେ ଦାନ୍‌ ଏମ୍‌ରେ ପୁରାଃ ରାସ୍‌କାମେନାଃ,’ ପ୍ରାଭୁ ୟୀଶୁ ଆଇଃକ୍‌ଗି କାଜିକାଦ୍‌ ନେ କାଜିକେ ପାହାମ୍‌କେଦ୍‌ତେ, ନେ'ଲେକା କେଟେଦ୍‌ କାମି କାମିକେଦ୍‌ତେ ନାରାଦୁରା ହଡ଼କକେ ଦେଙ୍ଗା ଲାଗାତିଙ୍ଗ୍‌ୟାଁଃ, ନେ ବିଷାଏରେ ଆଇଙ୍ଗ୍‌ ସବେନ୍‌ ଇମ୍‌ତା ଆପେକେ ନାମୁନାଇଙ୍ଗ୍‌ ଉଦୁବ୍‌କାଦା ।” ");
INSERT INTO unx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ପାଉଲୁସ୍‌ ନେଆଁଁ କାଜି ଚାବାକେଦ୍‌ତେ, ଇନିଃ ଇନ୍‌କୁଲଃ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ବିନ୍ତିକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ସବେନ୍‌କ ରାଆଃକେଦ୍‌ତେ ଇନିଃକେ ହାମ୍ବୁଦ୍‌କିୟାକ ଆଡଃ ପାବିତାର୍‌ ଚଅଃକେଦ୍‌ତେ ବିଦାକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ଇନ୍‌କୁ ଆଇଃକ୍‌କେ ଆଡଃମିସା କାକ ନେଲ୍‌ ଦାଡ଼ିୟା ମେନ୍ତେ ଇନିଃ କାଜିକେଦ୍‌ ହରାତେ ଇନ୍‌କୁ ପୁରାଃଗିକ ହୁଡିଙ୍ଗ୍‌ ଜୀଉୟାନା । ଇନ୍‌କୁ ଇନିଃଲଃ ଦାଆଃ ଜାହାଜ୍‌ ନାଡ଼େଃତେକ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ଇନ୍‌କୁକେ ବିଦାକେଦ୍‌ତେ ଆଲେ ଏନ୍ତାଃଏତେଲେ ସେନଃୟାନା । ଆଡଃ ଦାଆଃ ହରା ପାରମ୍‌କେଦ୍‌ତେ ଆଲେ କୋସ୍‌ ଟାପୁତେଲେ ସେଟେର୍‌ୟାନା । ଏନାରେୟାଃ ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ରୋଡସ୍‌ ଟାପୁ ହରାତେ ପାତ୍‌ରା ନାଗାର୍‌ତେଲେ ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ଏନ୍ତାଃଏତେ ଫିନିସିୟା ପାର୍‌ଗାନ୍‌ତେ ସେନଃତାନ୍‌ ମିଆଁଦ୍‌ ଦାଆଃ ଜାହାଜ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେଲେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ଏନ୍ତେ ସାଇପ୍ରସ୍‌ ଟାପୁ ନେଲ୍‍ତାନ୍‌ ମିଆଁଦ୍‌ ଠାୟାଦ୍‌ତାଃଲେ ସେଟେର୍‌ୟାନା । ଏନ୍ତାଃଏତେ ଏନାରେୟାଃ ଜମ୍‌ସାଃ ହରାତେ ଆଲେ ସିରିୟା ପାର୍‌ଗାନ୍‌ତେଲେ ସେନଃୟାନା । ଆଲେ ସୋର୍‌ ନାଗାର୍‌ରେ ଦାଆଃ ଜାହାଜ୍‌ଏତେଲେ ଆଡ଼୍‌ଗୁୟାନା, ଚିଆଃଚି ନେ ଦାଆଃ ଜାହାଜ୍‌ଏତେ ସାମାନ୍‌କ ଆଡ଼୍‌ଗୁରାଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ଏନ୍ତାଃରେ ଆଲେ ଚିମିନ୍‌ ବିଶ୍ୱାସୀକକେ ନାମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଲଃ ମିଦ୍‌ ହାପ୍ତାଲେ ତାଇନ୍‌ୟାନା । ପାବିତାର୍‌ ଆତ୍ମାରାଃ ଆନାଚୁ ନାମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ପାଉଲୁସ୍‌କେ ଯୀରୁଶାଲେମ୍‌ତେ ଆଲମ୍‌ ସେନା ମେନ୍ତେକ କାଜିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ମେନ୍‌ଦ ଇନ୍‌କୁଲଃ ମିଦ୍‌ ହାପ୍ତା ତାଇନ୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ, ଆଲେ ଇନ୍‌କୁକେ ବାଗିକେଦ୍‌ତେ ଆଲେୟାଃ ହରାରେଲେ ସେନଃୟାନା । ଆଲେକେ ବିଦା ଏମ୍‌ ନାଗେନ୍ତେ ଇନ୍‌କୁ ସବେନ୍‌କ ଆକଆଃ କୁଡ଼ି ଆଡଃ ହନ୍‌କଲଃ ନାଗାର୍‌ ବାହାରି ଦରେୟା ଗେନା ଜାକେଦ୍‌କ ହିଜୁଃୟାନା । ଏନ୍ତାଃରେ ଆଲେ ସବେନ୍‌କ ଇକ୍‌ଡ଼ୁମ୍‌କେଦ୍‌ତେ ବିନ୍ତିକେଦାଲେ । ");
INSERT INTO unx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ଏନ୍ତେ ଆଲେ ଇନ୍‌କୁକେ ବିଦାକେଦ୍‌ତେ, ଦାଆଃ ଜାହାଜ୍‌ରେ ଦୁବ୍‌ୟାନାଲେ ଆଡଃ ଇନ୍‌କୁ ଅଡ଼ାଃତେକ ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ସୋର୍‌ ନାଗାର୍‌ହେତେ ଆଲେ ପତଲ୍‌ମାଇ ସାହାର୍‌ତେଲେ ସେଟେର୍‌ୟାନା, ଏନ୍ତାଃରେ ବିଶ୍ୱାସୀକକେ ଜହାର୍‌କେଦ୍‌ତେ ଇନ୍‌କୁଲଃ ମୁସିଙ୍ଗ୍‌ଲେ ତାଇନ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ଆଲେ ଏନ୍‌ ଠାୟାଦ୍‌ ବାଗିକେଦ୍‌ତେ କାଇସରିୟା ନାଗାର୍‌ତେଲେ ସେଟେର୍‌ୟାନା । ଏନ୍ତାଃରେ ଆଲେ ସୁକୁକାଜି ଉଦୁବ୍‌ତାନ୍‌ ଫିଲିପ୍‌ଆଃ ଅଡ଼ାଃରେଲେ ତାଇନ୍‌ୟାନା, ଯୀରୁଶାଲେମ୍‌ରେ ଦେଙ୍ଗା ନାଗେନ୍ତେ ସାଲାକାନ୍‌ ଏୟାଝାନ୍‌କଏତେ ଫିଲିପ୍‌ ମିହୁଡ଼୍‌ ତାଇକେନାଏ । ");
INSERT INTO unx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ଇନିୟାଃ ଉପୁନିୟାଝାନ୍ କା ଆଣ୍‌ଦିକାନ୍‌ କୁଡ଼ିହନ୍‍ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ କାନାଜିକ ଉଦୁବ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ଆଲେ ଏନ୍ତାଃରେ ପୁରାଃ ମାହାଁ ତାଇନ୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ, ଯିହୁଦାଏତେ ଆଗାବ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ନାବୀ ଏନ୍ତାଃତେ ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ଇନିଃ ଆଲେତାଃ ହିଜୁଃକେଦ୍‌ତେ, ପାଉଲୁସ୍‌ଆଃ କାସ୍‌ନା ଇଦିକେଦାଏ, ଆଡଃ ଆଇଃକ୍‌ଗି ଆୟାଃ ତିଃଇ ଆଡଃ କାଟା ତଲ୍‌କେଦ୍‌ତେ କାଜିକେଦା, “ପାବିତାର୍‌ ଆତ୍ମା ଆଇଙ୍ଗ୍‌କେ ଉଦୁବ୍‌କାଦିୟାଁ ଯେ, ନେ କାସ୍‌ନା ଅକଏୟାଃ ତାନାଃ, ଇନିଃକେ ଯୀରୁଶାଲେମ୍‌ରେ ଯିହୁଦୀ ହଡ଼କ ନେ'ଲେକାଗି ତଲ୍‌କେଦ୍‌ତେ ସାଅଁସାର୍‌ ହଡ଼କଆଃ ତିଃଇରେକ ଜିମାଇୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ନେଆଁଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ଆଲେ ଆଡଃ ଏନ୍‌ ଠାୟାଦ୍‌ରେ ତାଇକେନ୍‌ ଏଟାଃ ହଡ଼କ ପାଉଲୁସ୍‌କେ ଯୀରୁଶାଲେମ୍‌ତେ ଆଲମ୍‌ ସେନା ମେନ୍ତେଲେ ବିନ୍ତିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ମେନ୍‌ଦ ପାଉଲୁସ୍‌ କାଜିରୁହାଡ଼୍‌କେଦ୍‍କଆଏ, “ଆପେ ନେଆଁ ଚିନାଃପେ ଚିକାଏତାନା ? ଚିନାଃମେନ୍ତେ ନେ ଲେକା ରାଆଃକେଦ୍‌ତେ ଆଇଁୟାଃ ମନ୍‌ସୁରୁଦ୍‌କେ ହୁଡିଙ୍ଗ୍‌ ଜୀଉ ତାନାପେ ? ଯୀରୁଶାଲେମ୍‌ରେ ଏସ୍‌କାର୍‌ ତଲେନ୍‌ ନାଗେନ୍ତେ କାହା, ମେନ୍‌ଦ ପ୍ରାଭୁ ୟୀଶୁଆଃ ନୁତୁମ୍‌ ନାଗେନ୍ତେ ଗନଏଃ ହବାଅଃରେୟ ଆଇଙ୍ଗ୍‌ ସେକାଡ଼୍‌କାନାଇଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ଇନିଃ ଆଲେୟାଃ କାଜି କାଏ ମାନାତିଙ୍ଗ୍‌କେଦ୍‌ ହରାତେ ଆଲେ ହାପାୟାନାଲେ ଆଡଃ “ପ୍ରାଭୁଆଃ ମନେଲେକା ହବାଅଃକା” ମେନ୍ତେ କାଜିକେଦାଲେ । ");
INSERT INTO unx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ଏନ୍ତାଃରେ ଚିମିନ୍‌ ମାହାଁ ତାଇନ୍‌କେଦ୍‌ତେ ଆଲେ ଆଲେୟାଃ ଜିନିଷ୍‌କ ସାଜ୍‌ଡ଼ାଅକେଦ୍‌ତେ ଯୀରୁଶାଲେମ୍‌ତେଲେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","କାଇସରିୟାରେ ଚିମିନାଙ୍ଗ୍‌ ଚେଲାକ ଆଡଃ ସାଇପ୍ରସ୍‌ରେନ୍‌ ମନାସନ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ବିଶ୍ୱାସୀହଗି ଆଲେଲଃ ମିସାତେ ସେନଃୟାନା । ଆଡଃ ମନାସନ୍‌ ଆଲେକେ ଆୟାଃ ଅଡ଼ାଃରେ ତାଇନଃ ନାଙ୍ଗ୍‌ ଇଦିକେଦ୍‌ଲେୟାଏ । ");
INSERT INTO unx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ଆଲେ ଯୀରୁଶାଲେମ୍‌ରେ ସେଟେର୍‌ୟାନ୍‌ ଇମ୍‌ତା ଏନ୍ତାଃରେନ୍‌ ବିଶ୍ୱାସୀ ହଡ଼କ ଆଲେକେ ରାସ୍‌କାତେକ ଦାରମ୍‌କେଦ୍‌ଲେୟା । ");
INSERT INTO unx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ପାଉଲୁସ୍‌ ଆଲେଲଃ ଯାକୁବ୍‌କେ ନେନେଲ୍‌ ନାଗେନ୍ତେ ସେନଃୟାନା, ଏନ୍ତାଃରେ କାଲିସିୟାରେନ୍‌ ସବେନ୍‌ ପ୍ରାଚିନ୍‌କ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ପାଉଲୁସ୍‌ ଇନ୍‌କୁକେ ଜହାର୍‌କେଦ୍‌କଆ ଆଡଃ ଆୟାଃ କାମି ହରାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ସାଅଁସାର୍‌ ହଡ଼କ ଥାଲାରେ ଅକ କାମିକଏ କାମିକେଦା, ଏନା ସବେନାଃଏ ଉଦୁବାଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ଆୟାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ ତାୟମ୍‌ତେ ଇନ୍‌କୁ ସବେନ୍‌କ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାନାରାଙ୍ଗ୍‌କ ରିକାକେଦା । ଏନ୍ତେ ଇନ୍‌କୁ କାଜିକେଦାକ, “ହାଗା ପାଉଲୁସ୍‌, ଆମ୍‌ ନେଲ୍‌ ଦାଡ଼ିତାନାମ୍‌, ଚିଲ୍‌କା ହାଜାର୍‌ ହାଜାର୍‌ ଯିହୁଦୀ ହଡ଼କ ପ୍ରାଭୁ ୟୀଶୁତାଃରେ ବିଶ୍ୱାସ୍‌ତାନାକ ଆଡଃ ଇନ୍‌କୁ ସବେନ୍‌କ ଆନ୍‌ଚୁ ମାନାତିଙ୍ଗ୍‌ରେ ଚିହୁଲ୍‌କେଦ୍‌ତେ ମେନାକଆ । ");
INSERT INTO unx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ଇନ୍‌କୁ କାଜି ଆୟୁମ୍‌କାଦାକ ଯେ, ଆମ୍‌ ସାଅଁସାର୍‌ ହଡ଼କଆଃ ଦିଶୁମ୍‌ରେ ତାଇନ୍‌ତାନ୍‌ ଯିହୁଦୀ ହଡ଼କକେ ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁ ବାଗି ନାଗେନ୍ତେ, ଇନ୍‌କୁଆଃ ହନ୍‌କକେ କା ଖାତ୍‌ନାଅ ନାଗେନ୍ତେ ଆଡଃ ଯିହୁଦୀ ରିତିରିୱାଜ୍‌ କା ମାନାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେମ୍‌ ଇତୁକତାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ଆମ୍‌ ନେତାଃତେମ୍‌ ସେଟେରାକାନା ମେନ୍ତେ ଇନ୍‌କୁ ସାର୍‌ତିଗିକ ଆୟୁମେୟା । ତାବ୍‌ଦ ଚିନାଃବୁ ଚିକାଏୟା ? ");
INSERT INTO unx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ଏନାମେନ୍ତେ ଆଲେ ସାନାଙ୍ଗ୍‌ତାନାଲେ, ଆମ୍‌ ମିଆଁଦ୍‌ କାମି କାମିମେ, ନେତାଃରେ ମେନାକ ଉପୁନ୍‌ ହଡ଼କ ମିଆଁଦ୍‌ କିରିୟାକାଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ଇନ୍‌କୁଲଃ ସେନଃମେ ଆଡଃ ଫାର୍‌ଚିଅଃରେୟାଃ ରିତିରିୱାଜ୍‌ ମାନାତିଙ୍ଗ୍‌ ନାଗେନ୍ତେ ଇନ୍‌କୁଲଃ ମେସାକେଦ୍‌ତେ ଦାଣେଁରାକାବଃ ନାଙ୍ଗ୍‌ ଖାର୍ଚାଅଃତେୟାଃ ଏମେମେ, ଏନ୍ତେ ଇନ୍‌କୁ ଆକଆଃ ଆପ୍‌ନାଃ ବହଃରାଃ ଉବ୍‌ ଟାଠୁନାଃକ । ଏନାତେ ଆମାଃ ବିଷାଏରେ କାଜିକାନ୍‌ ଜେତାନ୍‌ କାଜି ସାର୍‌ତି ନାହାଁଲାଃ, ମେନ୍‌ଦ ଆମ୍‌ ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁ ଲେକାମ୍‌ ସେସେନ୍‌ତାନା, ମେନ୍ତେ ସବେନ୍‌କ ଆଟ୍‌କାରେୟା । ");
INSERT INTO unx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ମେନ୍‌ଦ ଅକ ସାଅଁସାର୍‌ ହଡ଼କ ବିଶ୍ୱାସୀକାନାକ, ଇନ୍‌କୁତାଃତେ ଆଲେ ମିଆଁଦ୍‌ ଚିଟାଉଲେ ଅଲ୍‌ କୁଲ୍‌କାଦା, ଏନାରେ ଆଲେ ଆଚୁକାଦାଲେ, ଇନ୍‌କୁ ମୁରୁତ୍‌କତାଃରେ ଦାନ୍‌ ରାକାବାକାନ୍‌ ଜମେୟାଁଃ ଆଲକାକ ଜମେକା, ମାୟୋମ୍‌ ଆଲକାକ ନୁଁଏକା, ହଟଃ ଲିମ୍ବୁଦ୍‌କେଦ୍‌ତେ ଗଜାକାଇ ଜାଁତୁରାଃ ମାସ୍‌ ଆଲକାକ ଜମେକା ଆଡଃ ଇନ୍‌କୁ କଡ଼ା ଚାଏ କୁଡ଼ିଲଃ ହଡ଼୍‌ମରାଃ ଏତ୍‌କାନ୍‌ ସାମ୍ପାର୍କ୍‌କ ଆଲକାକ କାମିକା ।” ");
INSERT INTO unx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ଏନ୍ତେ ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ପାଉଲୁସ୍‌ ଏନ୍‌ ଉପୁନ୍‌ ହଡ଼କଲଃ ଫାର୍‌ଚିନ୍‌ରେୟାଃ ରିତିରିୱାଜ୍‌ ରିକା ନାଗେନ୍ତେ ମାନାତିଙ୍ଗ୍‌ୟାନା । ଏନ୍ତେ ଇନିଃ ମାନ୍ଦିର୍‌ତେ ସେନ୍‌କେଦ୍‌ତେ ଫାର୍‌ଚିନ୍‌ରେୟାଃ କାମି ଚିଉଲା ଟୁଣ୍ଡୁଃଆ ଆଡଃ ଚିମ୍‌ତା ଦାଣେଁରାକାବ୍‌ ହବାଅଃଆ, ଏନା ଉଦୁବ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ଫାର୍‌ଚିନ୍‌ରେୟାଃ ଏୟାମାହ ଟୁଣ୍ଡୁଃତାନ୍‌ ଦିପିଲିରେ ଏସିଆ ପାର୍‌ଗାନ୍‌ରେନ୍‌ ଚିମିନ୍‌ ଯିହୁଦୀ ହଡ଼କ ପାଉଲୁସ୍‌କେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେକ ନେଲ୍‌କିୟା । ଇନ୍‌କୁ ଏନ୍ତାଃରେ, ଏନ୍ତାଃରେନ୍‌ ଗଟା ଗାଦେଲ୍‌ ହଡ଼କକେ ଉସ୍‌କୁର୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ ସାବ୍‌କିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ଇନ୍‌କୁ କାଉରିକେଦ୍‌ତେ କାଜିକେଦାକ, “ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କ, ଆଲେକେ ଦେଙ୍ଗାଲେପେ ! ନେ ହଡ଼ ଚାରିୟସାଃ ସେନ୍‌କେଦ୍‌ତେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହଡ଼କଆଃ ବିରୁଧ୍‌ରେ, ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁ ଆଡଃ ନେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃ ବିରୁଧ୍‌ରେ ଇତୁତାନା । ଆଡଃ ନାହାଁଃ ଇନିଃ ଚିମିନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କକେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃ ଭିତାର୍‌ତେ ଆଉକେଦ୍‌ତେ ନେ ପାବିତାର୍‌ ଠାୟାଦ୍‌କେ ସତ୍‌ରାଏ ତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ଇନ୍‌କୁ ନାଗାର୍‌ରେ ଏଫିସୁସ୍‌ରେନ୍‌ ତ୍ରଫିମ୍‍କେ ପାଉଲୁସ୍‌ଲଃ ନେଲାକାଇ ତାଇକେନାକ, ଏନାତେ ପାଉଲୁସ୍‌ ତ୍ରଫିମ୍‌କେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃତେ ଇଦିତାନା ମେନ୍ତେ ଇନ୍‌କୁ ଉଡ଼ୁଃକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ଗଟା ନାଗାର୍‌ରେ ହାଲାଗୁଲା ନିତିର୍‌ୟାନା, ଆଡଃ ହଡ଼କ ପାଉଲୁସ୍‌କେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃଏତେ ବାହାରିତେକ ଅର୍‌ ଅଡଙ୍ଗ୍‌କିୟା । ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେୟାଃ ଦୁଆର୍‌କ ହାଣ୍ଡେଦ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ଇନ୍‌କୁ ଇନିଃକେ ଗଗଏଃ ନାଗେନ୍ତେକ ଚେଷ୍ଟା ତାଇକେନ୍‌ ଇମ୍‌ତା ଗଟା ଯୀରୁଶାଲେମ୍‌ରେ ହାଲାଗୁଲାତେ ପେରେଃକାନା ମେନ୍ତେ ରୋମାନ୍‌ରେନ୍‌ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃତାଃତେ କାନାଜି ସେଟେର୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ଇମ୍‍ତାଗି ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃ ସିପାଇକକେ ଆଡଃ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇକକେ ଇଦିକେଦ୍‌ତେ ଏନ୍ତାଃତେ ସେଟେର୍‌ୟାନା । ହଡ଼କ ଇନିଃକେ ଇନ୍‌କୁଲଃ ନେଲ୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ କା ଦାଲ୍‌କେଦ୍‌ତେ ବାଗିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃ ପାଉଲୁସ୍‌କେ ବାରିୟା ସିକ୍‌ଡ଼ିତେ ତଲି ନାଗେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ଏନ୍ତେ ଇନିଃ କୁଲିକେଦ୍‌କଆଏ, “ନେ ହଡ଼ ଅକଏ ତାନିଃ ଆଡଃ ଇନିଃ ଚିନାଃ ଚିକା କାଦାଏ ?” ");
INSERT INTO unx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ଗାଦେଲ୍‌ ହଡ଼କଏତେ ଚିମିନ୍‌ ହଡ଼କ ରାକାମ୍‌ ରାକାମ୍‌ କାଜିକେଦ୍‌ତେ କାଉରିକେଦାକ । ନେ'ଲେକା କାଉରିକେଦାକ ଚି, ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃ ହାଲାଗୁଲା ଚିନାଃମେନ୍ତେ ହବାଅଃତାନା ଏନା କାଏ ସାରିଦାଡ଼ିୟାନା । ଏନାତେ ଇନିଃ ପାଉଲୁସ୍‌କେ ସିପାଇକଆଃ ଗାଡ଼୍‌ ଭିତାର୍‌ତେ ଇଦି ନାଗେନ୍ତେ ସିପାଇକକେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ଇନ୍‌କୁ ପାଉଲୁସ୍‌କେ ଇଦିକେଦ୍‌ତେ ଗାଡ଼୍‌ରେୟାଃ ପାଉଁଚ୍‌ତାଃ ସେଟେରଃତାନ୍‌ରେ ଗାଦେଲ୍‌ ହଡ଼କଆଃ ଖିସ୍‌ ନେଲ୍‌କେଦ୍‌ତେ ସିପାଇକ ପାଉଲୁସ୍‌କେ ଗଅଃକେଦ୍‌ତେ ଇଦିକିୟାକ । ");
INSERT INTO unx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ସବେନ୍‌ ହଡ଼କ ଆୟାଃ ଦୟା ଦୟା ଅତଙ୍ଗ୍‌ ଆଉକେଦ୍‌ତେ “ଇନିଃକେ ଗଜିପେ” ମେନ୍ତେ କାଉରିତାନ୍‌ଲଃ କାଜିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ସିପାଇକ ପାଉଲୁସ୍‌କେ ଗାଡ଼୍‌ ଭିତାର୍‌ତେ ଇଦି ଇମ୍‌ତା ପାଉଲୁସ୍‌ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃକେ କାଜିକିୟା, “ଆଇଙ୍ଗ୍‌ ଆବେନ୍‌କେ ଜେତ୍‌ନାଃ କାଜି ଦାଡ଼ିୟାଇଙ୍ଗ୍‌ଚି ?” ଇନିଃ କୁଲିକିୟାଏ, “ଆମ୍‌ ଗ୍ରୀକ୍‌ ଜାଗାର୍‌ତେ କାଜିତାନାମ୍‌, ଗ୍ରୀକ୍‌ ହଡ଼ ତାନ୍‌ମେଚି ? ");
INSERT INTO unx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ଏନ୍‌ରେଦ ଚିମିନ୍‌ ମାହାଁ ସିଦାରେ ମିସାର୍‌ରେନ୍‌ ଅକ ହଡ଼ ହାଲାଗୁଲାକେଦ୍‌ତେ ଉପୁନ୍‌ ହାଜାର୍‌ ବରୱାନ୍‌ ଗଗଏଃ ହଡ଼କକେ ଇଦିକେଦ୍‌ତେ ବିର୍‌ରେ ସେଟେର୍‌ୟାନା, ଆମ୍‌ ଚିନାଃ ଏନ୍‌ ହଡ଼ ନାହାଁଲାମେ ?” ");
INSERT INTO unx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ପାଉଲୁସ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ଆଇଙ୍ଗ୍‌ କିଲିକିଆ ପାର୍‌ଗାନ୍‌ରେୟାଃ ତାର୍ଷିସ୍‌ ସାହାର୍‌ରେ ଜାନାମାକାନ୍‌ ଯିହୁଦୀ ହଡ଼ ତାନିଙ୍ଗ୍‌ । ଦାୟାକେଦ୍‌ତେ ନେ ହଡ଼କତାଃରେ ଜାଗାର୍‌ ଇଚିଙ୍ଗ୍‌ମେ ।” ");
INSERT INTO unx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ଇନିଃ ପାଉଲୁସ୍‌କେ କାଜି ଇଚିକିୟାଏ, ଏନ୍ତେ ପାଉଲୁସ୍‌ ଅଡ଼ାଃପାଉଁଚ୍‌ ଚେତାନ୍‌ରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ହଡ଼କକେ ହାପାଅଃ ନାଗେନ୍ତେ ତିଃଇ ରିମ୍‌କେଦ୍‌ତେ ଇସାରାକେଦ୍‌କଆ । ଇନ୍‌କୁ ହାପାୟାନ୍‌ ତାୟମ୍‌ତେ ପାଉଲୁସ୍‌ ଏବ୍ରୀ ଜାଗାର୍‌ତେ କାଜିକେଦା, ");
INSERT INTO unx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ଦୁଲାଡ଼୍‌ ହାଗାକ ଆଡଃ ଆପୁକ, ଆଇଙ୍ଗ୍‌ ଆପେୟାଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ଆପ୍‌ନାଃ ନାଗେନ୍ତେ କାଜିତାନ୍‌ତେୟାଃ ଆୟୁମେପେ,” ");
INSERT INTO unx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ଇନିଃ ଇନ୍‌କୁଲଃ ଏବ୍ରୀତେ ଜାଗାର୍‌ତାନ୍‌ ଆୟୁମ୍‌କେଦ୍‌ତେ ଇନ୍‌କୁ ଆଡଃଗି ହାପାୟାନାକ ଆଡଃ ପାଉଲୁସ୍‌ ଆଡଃଗି କାଜିଇଦିକେଦା, ");
INSERT INTO unx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ଆଇଙ୍ଗ୍‌ ମିହୁଡ଼୍‌ ଯିହୁଦୀ ତାନିଙ୍ଗ୍‌, କିଲିକିଆ ପାର୍‌ଗାନ୍‌ରେୟାଃ ତାର୍ଷିସ୍‌ ସାହାର୍‌ରେଇଙ୍ଗ୍‌ ଜାନାମ୍‌ କାନା, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଯୀରୁଶାଲେମ୍‌ରେଇଙ୍ଗ୍‌ ଆସୁଲ୍‌ ହାରାକାନା ଆଡଃ ଗମଲିଏଲ୍‌ତାଃଏତେ ଇନିତୁଇଙ୍ଗ୍‌ ନାମାକାଦା । ଆଇଙ୍ଗ୍‌ ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କଆଃ ଆନ୍‌ଚୁ ବୁଗିଲେକାଇଙ୍ଗ୍‌ ଇତୁକାନା ଆଡଃ ଆପେୟାଃ ଲେକା ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ନାଗେନ୍ତେ ଚିହୁଲାନ୍‌ଗି ତାଇକେନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ଆଇଙ୍ଗ୍‌ ପ୍ରାଭୁଆଃ ହରାକେ ଅତଙ୍ଗ୍‌ତାନ୍‌ ହଡ଼କକେ ସାସାତିକେଦ୍‌ତେ ଗଏଃକ ତାଇକେନାଇଙ୍ଗ୍‌ । କଡ଼ା କୁଡ଼ି ସବେନ୍‌କକେ ତଲ୍‌କେଦ୍‌ତେ ଜେହେଲ୍‌ରେ ଜିମାକ ତାଇକେନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ଆଇଁୟାଃ ନେ କାଜି ସାର୍‌ତି ତାନାଃ, ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ଆଡଃ ପାଞ୍ଚେଟ୍‌ରେନ୍‌ ସବେନ୍‌କ ନେଆଁରେୟାଃ ଗାୱାତାନ୍‌କ । ନେ ହଡ଼କକେ ତଲ୍‌କେଦ୍‌ତେ ଆଡଃ ସିକିଡ଼ିରେ ତଲ୍‌କେଦ୍‌ତେ ସାଜାଇ ଏମାକ ନାଗେନ୍ତେ ଯୀରୁଶାଲେମ୍‌ତେ ଇଦିକ ନାଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ତାଃଏତେ ଅନଲ୍‌ ଚିଟାଉ ଇଦିକେଦ୍‌ତେ, ଦମାସ୍‌କସ୍‌ ନାଗାର୍‌ରେ ତାଇନ୍‌ତାନ୍‌ ଯିହୁଦୀ ହାଗାକତାଃତେଇଙ୍ଗ୍‌ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ଆଇଙ୍ଗ୍‌ ସେନଃତାନ୍‌ ତାଇକେନ୍‌ ଇମ୍‌ତା ଦମାସ୍‌କସ୍‌ ନାଗାର୍‌ତେ ତେବାଗଃ ତାଇକେନ୍‌ରେ ସିର୍ମାଏତେ ମିଆଁଦ୍‌ ହିଚିର୍‌ଲେକା ମାର୍ସାଲ୍‌ ଆଚ୍‌କାଗି ଆଇଁୟାଃ ଚାରିୟସାଃରେ ମାର୍ସାଲ୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ଆଡଃ ଆଇଙ୍ଗ୍‌ ଅତେରେଇଙ୍ଗ୍‌ ଉୟୁଃୟାନା ଏନ୍ତେ ଆଇଙ୍ଗ୍‌ ନାଗେନ୍ତେ ନେ ଲାବ୍‌ଜାଇଙ୍ଗ୍‌ ଆୟୁମ୍‌କେଦା, ‘ହେ ଶାଉଲ୍, ହେ ଶାଉଲ୍‌, ଚିନାଃମେନ୍ତେ ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେମ୍‌ ସିଗିଦିଇଙ୍ଗ୍‌ତାନା ?’ ");
INSERT INTO unx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ଆଇଙ୍ଗ୍‌ କୁଲିକିୟାଇଙ୍ଗ୍‌, ‘ପ୍ରାଭୁ, ଆମ୍‌ ଅକଏ ତାନ୍‌ମେ ?’ ଇନିଃ ଆଇଙ୍ଗ୍‌କେ କାଜିରୁହାଡ଼୍‌କିୟାଁ, ‘ଆମ୍‌ ଅକଏକେମ୍‌ ସାସାତିତାନା, ଆଇଙ୍ଗ୍‌ ଏନ୍‌ ନାଜ୍‌ରେତ୍‌ରେନ୍‌ ୟୀଶୁ ତାନିଙ୍ଗ୍‌ ।’ ");
INSERT INTO unx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ଆଇଁୟାଃଲଃ ତାଇକେନ୍‌ ହଡ଼କ ଏନ୍‌ ମାର୍ସାଲ୍‌କ ନେଲ୍‌କେଦା, ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ଲଃ ଜାଗାର୍‌ତାନ୍‌ ହଡ଼ଆଃ ଲାବ୍‌ଜା କାକ ଆୟୁମ୍‌ ଦାଡ଼ିୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ଆଇଙ୍ଗ୍‌ କୁଲିକିୟାଇଙ୍ଗ୍‌, ‘ପ୍ରାଭୁ, ଆଇଙ୍ଗ୍‌ ଚିନାଃ ଚିକାଏୟାଇଙ୍ଗ୍‌ ?’ ପ୍ରାଭୁ ଆଇଙ୍ଗ୍‌କେ କାଜିକେଦିୟାଁ, ‘ବିରିଦ୍‌ମେ, ଆଡଃ ଦମାସ୍‌କସ୍‌ତେ ସେନଃମେ, ପାର୍‌ମେଶ୍ୱାର୍‌ ଆମାଃ ନାଗେନ୍ତେ ଅକ କାମି ଦହକାଦା, ଏନା ଏନ୍ତାଃରେ ଆମ୍‌କେ ଉଦୁବାମେୟାଁ ।’ ");
INSERT INTO unx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ଏନ୍‌ ମାର୍ସାଲ୍‌ରେୟାଃ ପୁରାଃ ମାର୍ସାଲ୍‌ତେ ଆଇଁୟାଃ ମେଦ୍‌ତାଇୟାଁଃ ବିଗ୍‌ଡ଼ାଅୟାନା ଆଡଃ କାଇଙ୍ଗ୍‌ ନେଲ୍‌ଦାଡ଼ିୟାନା । ଏନାମେନ୍ତେ ଆଇଁୟାଃଲଃ ମିସାତେ ସେନ୍‌ତାଇକେନ୍‌ ହଡ଼କ ଆଇଁୟାଃ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌କେ ଦମାସ୍‌କସ୍‌ତେକ ସୁତୁଃଇଦିକିୟାଁ । ");
INSERT INTO unx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ଏନ୍‌ ନାଗାର୍‌ରେ ହନାନିୟ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଧାର୍‌ମାନ୍‌ ହଡ଼ ତାଇକେନାଏ । ଇନିଃ ଆବୁଆଃ ଆନ୍‌ଚୁ ମାନାତିଙ୍ଗ୍‌ନିଃ ତାଇକେନାଏ ଆଡଃ ଏନ୍ତାଃରେ ତାଇନ୍‌ତାନ୍‌ ଯିହୁଦୀ ହଡ଼ ସବେନ୍‌କ ଇନିଃକେ ପୁରାଃଗିକ ମାଇନି ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ଇନିଃ ଆଇଁୟାଃତାଃତେ ହିଜୁଃକେଦ୍‌ତେ ନାଡ଼େଃରେ ତିଙ୍ଗୁୟାନା ଆଡଃ କାଜିକେଦାଏ, ‘ହାଗା ଶାଉଲ୍‌, ଆମ୍‌ ଆଡଃମିସାମ୍‌ ନେଲ୍‌ଦାଡ଼ିୟା ।’ ଏନ୍‌ ନେଡାରେଗି ଆଇଙ୍ଗ୍‌ ଆଡଃମିସା ନେଲ୍‌ ଦାଡ଼ିକେଦ୍‌ତେ, ଇନିଃକେଇଙ୍ଗ୍‌ ନେଲ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ଇନିଃ କାଜିକେଦାଏ, ‘ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆମ୍‌କେ ଆୟାଃ ଇଛାସାନାଙ୍ଗ୍‌ ସାରି ନାଗେନ୍ତେ, ଆୟାଃ ଧାର୍‌ମାନ୍‌ ଦାସିକେ ନେଲି ନାଗେନ୍ତେ ଆଡଃ ଆୟାଃ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଆୟାଃ ଆପ୍‌ନାଃ ଲାବ୍‌ଜାତେ ଜାଗାର୍‌ ନାଗେନ୍ତେ ସାଲାକାଦ୍‌ମେୟା । ");
INSERT INTO unx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ଚିଆଃଚି ଆମ୍‌ ଅକ୍‌ନାଃ ନେଲାକାଦାମ୍‌ ଆଡଃ ଆୟୁମ୍‌କାଦାମ୍‌, ଏନା ସବେନ୍‌କତାଃରେ ଉଦୁବେ ନାଗେନ୍ତେ ଆମ୍‌ ଆୟାଃ ଗାୱାମ୍‌ ହବାଅଃଆ । ");
INSERT INTO unx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ଆଡଃ ନାହାଁଃ, ଚିନାଃମେନ୍ତେମ୍‌ ବିଲାମେତାନା ? ବିରିଦ୍‌ମେ, ବାପ୍ତିସ୍ମା ଇଦିମେ ଆଡଃ ଆୟାଃ ନୁତୁମ୍‌ରେ ବିନ୍ତିକେଦ୍‌ତେ ଆମାଃ ସବେନ୍‌ ପାପ୍‌କ ଫାର୍‌ଚିୟଃଆ ।’ ");
INSERT INTO unx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ଆଇଙ୍ଗ୍‌ ଯୀରୁଶାଲେମ୍‌ ରୁହାଡ଼୍‌କେଦ୍‌ତେ ଏନ୍ତାଃରେୟାଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ବିନ୍ତିତାଇକେନ୍‌ ଇମ୍‌ତା, ଦାର୍‌ଶାନ୍‌ ନେଲ୍‌କେଦାଇଙ୍ଗ୍‌, ");
INSERT INTO unx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ଏନ୍‌ ଦାର୍‌ଶାନ୍‌ରେ ପ୍ରାଭୁକେ ନେଲ୍‌କିୟାଇଙ୍ଗ୍‌ । ଇନିଃ ଆଇଙ୍ଗ୍‌କେ କାଜିକେଦିୟାଁ, ‘ଜାଲ୍‌ଦି ଯୀରୁଶାଲେମ୍‌ ବାଗିମେ, ଚିଆଃଚି ନେତାଃରେନ୍‌ ହଡ଼କ ଆଇଁୟାଃ ବିଷାଏରେ ଏମାକାଦ୍‌ ଗାୱା କାକ ଆୟୁମେୟା ।’ ");
INSERT INTO unx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ଆଇଙ୍ଗ୍‌ କାଜିରୁହାଡ଼୍‌କେଦାଇଙ୍ଗ୍‌, ‘ପ୍ରାଭୁ ଆଇଙ୍ଗ୍‌ ସାମାଜ୍‌ ଅଡ଼ାଃକରେ ସେନ୍‌କେଦ୍‌ତେ ଆମାଃତାଃରେ ବିଶ୍ୱାସ୍‌ତାନ୍‌ ହଡ଼କକେ ଚିଲ୍‌କାଇଙ୍ଗ୍‌ ତଲ୍‌କତାଇକେନା ଆଡଃ ଦାଲ୍‌କ ତାଇକେନା, ଏନା ଇନ୍‌କୁ ବୁଗିଲେକାକ ସାରିକାଦା, ");
INSERT INTO unx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ଆଡଃ ଆମାଃ ବିଷାଏରେ ସ୍ତିଫାନ୍‌ ଗାୱା ଏମ୍‌ତାଇକେନ୍‌ ଇମ୍‌ତା ଇନିଃକେ ଦିରିତେ ଚିଦ୍‌ଗି ଗଏଃକିୟାକ, ଆଇଙ୍ଗ୍‌ ଏନ୍ତାଃରେଇଙ୍ଗ୍‌ ତାଇକେନା, ଆଡଃ ଇନିୟାଃ ଗନଏଃରେଇଙ୍ଗ୍‌ ସାଲ୍‌ହାକାନ୍‌ ତାଇକେନା ଆଡଃ ଇନିଃକେ ଗଏଃତାନ୍‌ ହଡ଼କଆଃ ଲିଜାଃକଇଙ୍ଗ୍‌ ହରତାଇକେନା ।’ ");
INSERT INTO unx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ପ୍ରାଭୁ ଆଇଙ୍ଗ୍‌କେ କାଜିକେଦିୟାଁ, ‘ଜୁ, ଆଇଙ୍ଗ୍‌ ଆମ୍‌କେ ପୁରାଃ ସାଙ୍ଗିନ୍‌ ସାଅଁସାର୍‌ ହଡ଼କତାଃତେଇଙ୍ଗ୍‌ କୁଲ୍‌ମେୟାଁ ।’” ");
INSERT INTO unx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ହଡ଼କ ପାଉଲୁସ୍‌ ନେ କାଜି କାଜିତାନ୍‌ ଜାକେଦ୍‌ ଆୟୁମ୍‌ ତାଇକେନାକ, ମେନ୍‌ଦ ଏନ୍‌ ତାୟମ୍‌ତେ ଇନ୍‌କୁ ପୁରାଃ କାଉରିକେଦ୍‌ତେ କାଜି ଏଟେଃକେଦାକ, “ଇନିଃକେ ଅତେଦିଶୁମ୍‌ଏତେ ବାହାରି ଅଡଙ୍ଗ୍‌ଇଁପେ, ଇନିଃକେ ଗଜିପେ, ଇନିୟାଃ ଜୀନିଦ୍‌ ତାଇନଃରେୟାଃ ଜେତାନ୍‌ ଆକ୍‌ତେୟାର୍‌ ବାନଃଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ଇନ୍‌କୁ କାଉରିତାନ୍‍ଲଃ ଆକଆଃ ଲିଜାଃ ହିର୍‌କେଦାକ ଆଡଃ ଚେତାନ୍‌ତେ ଧୁଡ଼ି ହିର୍‌ଚିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ପାଉଲୁସ୍‌କେ ଗାଡ଼୍‌ ଭିତାର୍‌ତେ ଇଦି ନାଗେନ୍ତେ ରୋମ୍‌ରେନ୍‌ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃ ସିପାଇକକେ ଆଚୁକେଦ୍‌କଆ ଆଡଃ ଯିହୁଦୀ ହଡ଼କ ଚିନାଃମେନ୍ତେ ଆୟାଃ ବିରୁଧ୍‌ରେ ନେ'ଲେକା କାଉରିତାନାକ, ଏନା ସାରି ନାଗେନ୍ତେ ଇନିଃକେ କର୍‌ଡାତେ ହାଁଣ୍‌ସାଇ ନାଙ୍ଗ୍‌ ଆଚୁକେଦ୍‌କଆଏ । ");
INSERT INTO unx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ମେନ୍‌ଦ ଇନିଃକେ ତନଲ୍‌ ଇମ୍‌ତା ପାଉଲୁସ୍‌ ଏନ୍ତାଃରେ ତାଇକାନ୍‌ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇନିଃକେ କାଜିକିୟା, “ଜେତା ଗୁହ୍ନାଁଁରେ ନାହାଁଃ ଜାକେଦ୍‌ କା ଚିଟାକାନ୍‌ ରୋମିରେନ୍‌ ହଡ଼କେ ହାଁଣ୍‌ସାତେୟାଃ ଚିନାଃ ଆଇନ୍‌ ଲେକାତେ ବୁଗିନାଃ ତାନାଃ ?” ");
INSERT INTO unx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ନେଆଁ ଆୟୁମ୍‌କେଦ୍‌ତେ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇନିଃ ସେନ୍‌କେଦ୍‌ତେ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃକେ କାଜିକିୟା, “ଆବେନ୍‌ ଚିନାଃବେନ୍‌ ଚିକାଏତାନା ? ଏନ୍‌ ହଡ଼ ରୋମିରେନ୍‌ ତାନିଃ ।” ");
INSERT INTO unx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ଏନ୍ତେ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃ ପାଉଲୁସ୍‌ତାଃତେ ସେନ୍‌କେଦ୍‌ତେ କୁଲିକିୟା, “ଆମ୍‌ ଚିନାଃ ମିଆଁଦ୍‌ ରୋମିରେନ୍‌ ତାନ୍‌ମେ ?” ପାଉଲୁସ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ହାଁ, ଆଇଙ୍ଗ୍‌ ତାନିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃ କାଜିକେଦାଏ, “ପୁରାଃ ଗନଙ୍ଗ୍‌ ଏମ୍‌କେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌ ମିଆଁଦ୍‌ ରୋମିରେନ୍‌ ହଡ଼ ହବାକାନାଇଙ୍ଗ୍‌ ।” ମେନ୍‌ଦ ପାଉଲୁସ୍‌ କାଜିରୁହାଡ଼୍‌କିୟାଏ, “ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ ଜାନାମ୍‌ହେତେଗି ରୋମିରେନ୍‌ ତାନିଙ୍ଗ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ଇମ୍‌ତାଗି ଅକ ହଡ଼କ ପାଉଲୁସ୍‌କେ କୁଲି ନାଗେନ୍ତେକ ସେନ୍‌ତାଇକେନା, ଇନ୍‌କୁ ତାୟମ୍‌ତେକ ରୁହାଡ଼୍‌ୟାନା ଆଡଃ ପାଉଲୁସ୍‌ ରୋମିରେନ୍‌ ତାନିଃ ମେନ୍ତେ ସାରିକେଦ୍‌ତେ ଆଡଃ ଇନିଃ ସିକିଡ଼ିତେ ପାଉଲୁସ୍‌କେ ତଲ୍‌ ନାଙ୍ଗ୍‌ ଆଚୁକାଦାଏ, ନେଆଁ ସାରିକେଦ୍‌ତେ, ଇନିଃ ପୁରାଃଗି ବରକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ଯିହୁଦୀ ହଡ଼କ ପାଉଲୁସ୍‌କେ ଚିନାଃମେନ୍ତେକ ଚିଟାଇତାନା, ଏନା ସାରି ନାଗେନ୍ତେ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇନିଃ ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ପାଉଲୁସ୍‌ଆଃ ସିକିଡ଼ି ତନଲ୍‌ତେୟାଃକ ରାଡ଼ାକେଦ୍‌ତେ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ ହବାଅଃ ନାଗେନ୍ତେ ମୁଲ୍‌ ଯାଜାକ୍‌କକେ ଆଚୁକେଦ୍‌କଆ । ଏନ୍ତେ ଇନିଃ ପାଉଲୁସ୍‌କେ ଇଦିକେଦ୍‌ତେ ଇନ୍‌କୁଆଃ ଆୟାର୍‌ରେ ତିଙ୍ଗୁକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ପାଉଲୁସ୍‌ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ସାଃତେ ମିଦ୍‌ନାଜେର୍‌ରେ ନେଲ୍‌କେଦ୍‌ତେ କାଜିକେଦା, “ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହାଗାକ, ତିସିଙ୍ଗ୍‌ ଜାକେଦ୍‌ ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ଜୀଦାନ୍‌ରେ ପାର୍‌ମେଶ୍ୱାର୍‌କେ ପୁରାଃ ମାଇନ୍‌ତାନ୍‌ଲଃ ଜୀଦାନ୍‌ ବିତାଅକାଦାଇଙ୍ଗ୍‌, ଏନ୍‌ ବିଷାଏରେ ଆଇଁୟାଃ ବିବେକ୍‌ ପୁରା ବୁଗିନ୍‌ଗିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ନେ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ହନାନିୟ, ପାଉଲୁସ୍‌ଆଃ ଜଆରେ ଚାଟ୍‌କାନ୍‌ ନାଗେନ୍ତେ ପାଉଲୁସ୍‌ଆଃ ନାଡ଼େଃରେ ତିଙ୍ଗୁଆକାନ୍‌ ହଡ଼କକେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ପାଉଲୁସ୍‌ ଇନିଃକେ କାଜିକିୟା, “ଏ ପୁଣ୍ଡିଆକାନ୍‌ ଭିତ୍‌, ପାର୍‌ମେଶ୍ୱାର୍‌ ସାର୍‌ତିଗି ଆମ୍‌କେ ଦାଲ୍‌ମେୟାଁ । ଆନ୍‌ଚୁ ଲେକାତେ ଆଇଁୟାଃ ବିଚାର୍‌ ନାଗେନ୍ତେ ଆମ୍‌ ଏନ୍ତାଃରେ ଦୁବାକାନାମ୍‌, ଏନ୍‌ରେୟ ଆଇଙ୍ଗ୍‌କେ ଦାଲ୍‌ ନାଙ୍ଗ୍‌ ଆଚୁକେଦ୍‌ତେ ଆମ୍‌ ଆନ୍‌ଚୁମ୍‌ ଟଟାଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ପାଉଲୁସ୍‌ଆଃ ନାଡ଼େଃରେ ତାଇକାନ୍‌ ହଡ଼କ ଇନିଃକେ କାଜିକିୟାକ, “ଆମ୍‌ ପାର୍‌ମେଶ୍ୱାର୍‌ଆଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌କେମ୍‌ ଲାନ୍ଦାଇତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ପାଉଲୁସ୍‌ କାଜିରୁହାଡ଼୍‌କେଦ୍‌କଆଏ, “ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହାଗାକ, ଇନିଃ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ତାନିଃ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ କାଇଙ୍ଗ୍‌ ସାରିକାଦ୍‌ ତାଇକେନା । ଧାରାମ୍‌ପୁଥିରେ ଅଲାକାନା, ‘ଆପେ ଆପେୟାଃ ହଡ଼କଆଃ ହାକିମ୍‌ଆଃ ବିଷାଏରେ ଏତ୍‌କାନାଃ ଆଲପେ କାଜିୟା ।’” ");
INSERT INTO unx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ଯିହୁଦୀ ହଡ଼କଆଃ ଝୁଣ୍ଡ୍‌ରେ ଚିମିନ୍‌ ଫାରୁଶୀ ଆଡଃ ଚିମିନ୍ ସାଦୁକି ହଡ଼କ ମେନାକତେୟାଃ ନେଲ୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ରେ କାଉରିକେଦ୍‌ତେ କାଜିକେଦା, “ହେ ଇସ୍ରାଏଲ୍‌ରେନ୍‌ ହାଗାକ, ଆଇଙ୍ଗ୍‌ ଫାରୁଶୀ ତାନିଙ୍ଗ୍‌ ଆଡଃ ଫାରୁଶୀ କିଲିରେଇଙ୍ଗ୍‌ ଜାନାମ୍‌ କାନା । ଆଡଃ ଗଜାକାନ୍‌କଆଃ ଜୀଉବିନିରିଦ୍‌ ମେନାଃ ମେନ୍ତେ ଭାର୍‌ସାକାଦ୍‌ ହରାତେ ନେତାଃରେ ଆଇଁୟାଃ ବିଚାର୍‌ ହବାଅଃତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ନେ କାଜି କାଜିକେଦ୍‌ଚି ଇମ୍‌ତାଗି, ଫାରୁଶୀକଆଃ ଆଡଃ ସାଦୁକିକଆଃ ଥାଲାରେ କାପ୍‌ଜି ଏଟେଦ୍‌ୟାନା, ଏନ୍ତେ ଇନ୍‌କୁଆଃ ଝୁଣ୍ଡ୍‌ ବିପିଙ୍ଗାଅୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ଚିଆଃଚି ସାଦୁକିକ ଗଜାକାନ୍‌କଆଃ ଜୀଉବିନିରିଦ୍‌ ବାନଃଆ ଆଡଃ ଦୁଁତ୍‌କ, ଆଡଃ ଆତ୍ମା ବାଙ୍ଗ୍‌କଆ ମେନ୍ତେକ କାଜିୟାଃ, ମେନ୍‌ଦ ଫାରୁଶୀକ ନେ ଆପିୟାତେୟାଃରେକ ବିଶ୍ୱାସାଃ । ");
INSERT INTO unx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ଇନ୍‌କୁଆଃ ଥାଲାରେ ପୁରାଃଗି କାପ୍‌ଜି ହବାୟାନା ଆଡଃ ଫାରୁଶୀକଆଃ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ଚିମିନ୍‌ ଆଇନ୍‌ ଇତୁକ ତିଙ୍ଗୁୟାନ୍‌ଲଃ କେଟେୟାନ୍‌ଗି କାଜିକଟଙ୍ଗ୍‌କେଦ୍‌ତେ କାଜିକେଦାକ, “ଆଲେ ନେ ହଡ଼ତାଃରେ ଜେତାନ୍‌ ଗୁହ୍ନାଁଁ କାଲେ ନାମେତାନା, ହବାସାକାଅଆଃ ଜାରୁଡ଼୍‌ଗି ଇନିଃଲଃ ମିଆଁଦ୍‌ ଆତ୍ମା ଚାଏ ଦୁଁତ୍‌ କାଜିକାତେୟାଃଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","କାପ୍‌ଜି ନିମିନାଙ୍ଗ୍‌ ବରୱାନ୍‌ ଲେକା ହବାୟାନା ଯେ, ଗାଦେଲ୍‌ ହଡ଼କ ପାଉଲୁସ୍‌କେ ଟୁକ୍‌ଡ଼ା ଟୁକ୍‌ଡ଼ା ତାଇୟାକ ମେନ୍ତେ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇ ବରକେଦାଏ । ଏନାତେ ଇନିଃ ହାଲାଗୁଲାତାନ୍‌ ହଡ଼କଆଃ ଥାଲାଏତେ ପାଉଲୁସ୍‌କେ ଇଦି ଆତମ୍‌କିୟା ଆଡଃ ଇନିଃକେ ଗାଡ଼୍‌ ଭିତାର୍‌ତେ ଇଦିପେ ମେନ୍ତେ ସିପାଇକକେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ପ୍ରାଭୁ ଏନ୍‌ ନିଦାରେଗି ପାଉଲୁସ୍‌ତାଃରେ ତିଙ୍ଗୁକେଦ୍‌ତେ କାଜିକେଦା, “ଆଲମ୍‌ ବରଏୟା, ଆମ୍‌ ନେତାଃ ଯୀରୁଶାଲେମ୍‌ରେ ଆଇଁୟାଃ ନାଗେନ୍ତେ ଗାୱାମ୍‌ ଏମାକାଦା । ରୋମ୍‌ରେୟଗି ଆମ୍‌କେ ନେ'ଲେକାଗି ଗାୱା ଏମ୍‌ ଲାଗାତିୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ସେତାଃରେ ଚିମିନ୍‌ ଯିହୁଦୀ ହଡ଼କ ହୁଣ୍ଡିକେଦ୍‌ତେକ ରୋଜୋଟକେଦା । ପାଉଲୁସ୍‌କେ ଆଉରି ଗଜି ଜାକେଦ୍‌ ଇନ୍‌କୁ ଜମ୍‌ ନୁଁ କାକଆଃ ମେନ୍ତେକ କିରିୟାକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ବାର୍‌ହିସିହେତେ ଆଦ୍‌କା ହଡ଼କ ନେ'ଲେକା ରୋଜୋଟକାଦ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ଇନ୍‌କୁ ସେନ୍‌କେଦ୍‌ତେ ମୁଲ୍‌ ଯାଜାକ୍‌ ଆଡଃ ପ୍ରାଚିନ୍‌କକେ କାଜିକେଦ୍‌କଆକ, “ପାଉଲୁସ୍‌କେ ଆଉରି ଗଜି ଜାକେଦ୍‌ ଜେତ୍‌ନାଃ କାଲେ ଜମେୟାଁ ମେନ୍ତେ ଆଲେ କିରିୟାକାଦାଲେ । ");
INSERT INTO unx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ଏନାତେ ଆପେ ବେଦାତାନ୍‌ଲଃ ଇନିୟାଃ ବିଷାଏରେ ପୁରାଃ ଠାଉକାଲେକା ସାରି ସାନାଙ୍ଗ୍‌ତାନାଲେ ମେନ୍ତେ ଇନିଃକେ ଆପେତାଃତେ ଆଉ ନାଗେନ୍ତେ ନାହାଁଃ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ଲଃ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇତାଃତେ କାଜି କୁଲେପେ । ମେନ୍‌ଦ ଇନିଃ ଆପେତାଃତେ ହିଜୁଃ ସିଦାରେ ଆଲେ ଇନିଃକେ ହରାରେ ଗଜି ନାଗେନ୍ତେ ସେକାଡ଼ାକାନ୍‌ଗି ତାଇନାଲେ ।” ");
INSERT INTO unx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ମେନ୍‌ଦ ପାଉଲୁସ୍‍ଆଃ ମିଶିତେୟାଃ ହନ୍‌ ଇନ୍‌କୁଆଃ ରୋଜୋଟ କାଜି ଆୟୁମ୍‌କେଦ୍‌ତେ ଗାଡ଼୍‌ ଭିତାର୍‌ ସେନ୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ ଉଦୁବ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ଏନ୍ତେ ପାଉଲୁସ୍‌ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇକଏତେ ମିହୁଡ଼୍‌କେ କେଡ଼ାକେଦ୍‌ତେ କାଜିକିୟା, “ନେ ସେପେଡ଼େଦ୍‌କେ ହାଜାର୍‍ ସିପାଇକଆଃ ମାରାଙ୍ଗ୍‌ନିଃତାଃତେ ଇଦିମେ, ଚିଆଃଚି ଇନିଃ ଚିନାଃ ମିଆଁଦ୍‌ କାଜି ସାନାଙ୍ଗ୍‌ତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇ ଇନିଃକେ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇତାଃତେ ଇଦିକେଦ୍‌ତେ କାଜିକିୟା, “ତଲାକାନ୍‌ ପାଉଲୁସ୍‌ ଆଇଙ୍ଗ୍‌କେ କେଡ଼ାକେଦ୍‌ତେ ନେ ସେପେଡ଼େଦ୍‌କେ ଆବେନ୍‌ତାଃତେ ଆଉ ନାଗେନ୍ତେ କାଜିକେଦିୟାଁ, ଚିଆଃଚି ଇନିଃ ଆବେନ୍‌କେ ଚିନାଃ ମିଆଁଦ୍‌ କାଜି ସାନାଙ୍ଗ୍‌ତାନାଏ ।” ");
INSERT INTO unx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ହାଜାର୍‍ ସିପାଇକଆଃ ଆଗୁଆଇ ଇନିୟାଃ ତିଃଇ ସାବ୍‌କେଦ୍‌ତେ ଗେନାତେ ଇଦିକିୟାଏ ଆଡଃ କୁଲିକିୟାଏ, “ଆଇଙ୍ଗ୍‌କେ ଚିନାଃ କାଜିରାଃ ମେନାଃ, କାଜିମେ ?” ");
INSERT INTO unx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ଏନ୍ତେ ଇନିଃ କାଜିକେଦାଏ, “ଯିହୁଦୀ ଆକ୍‌ତେୟାର୍‌ ହଡ଼କ ରୋଜୋଟକାଦାକ ଯେ, ପାଉଲୁସ୍‌ଆଃ ବିଷାଏରେ ପୁରାଃ ଠାଉକାଲେକା ସାରି ନାଗେନ୍ତେ ସାନାଙ୍ଗ୍‌ତାନାକ ମେନ୍ତେ ବେଦାକେଦ୍‌ତେ, ପାଉଲୁସ୍‌କେ ଗାପା ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ତେ ଇଦି ନାଗେନ୍ତେ ଆବେନ୍‌କେକ କାଜିବେନା । ");
INSERT INTO unx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ମେନ୍‌ଦ ଆବେନ୍‌ ଇନ୍‌କୁଆଃ କାଜି ଆଲବେନ୍‌ ଆୟୁମେୟା, ଚିଆଃଚି ବାର୍‌ହିସିହେତେ ଆଦ୍‌କା ହଡ଼କ ଇନିଃକେ ଆଉରି ଗଜି ଜାକେଦ୍‌ କାଲେ ଜମେୟାଁ ମେନ୍ତେ କିରିୟାକାଦାକ ଆଡଃ ଉକୁକେଦ୍‌ତେ ଇନିୟାଃ ନେଲ୍‌ହରାତାନାକ । ନାହାଁଃ ଇନ୍‌କୁ ଆବେନାଃ କାଜି ଆୟୁମ୍‌ ନାଙ୍ଗ୍‌କ ତାଙ୍ଗିତାନା ।” ");
INSERT INTO unx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇ “ଆମ୍‌ ଆଇଙ୍ଗ୍‌କେ ନେ କାଜିମ୍‌ ଉଦୁବ୍‌କାଦିୟାଁ ଏନା ଜେତାଏକେ ଆଲମ୍‌ କାଜିକଆ ।” ମେନ୍ତେ କାଜିକେଦ୍‌ତେ ଇନିଃକେ କୁଲ୍‌କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ଏନ୍ତେ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇ ଆୟାଃ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇ, ବାର୍‌ହଡ଼୍‌କିନ୍‌କେ କେଡ଼ାକେଦ୍‌ତେ କାଜିକେଦ୍‌କିନା, “ତିସିଙ୍ଗ୍‌ନିଦା ନାଅ ଘାଡ଼ିକରେ କାଇସରିୟା ସାହାର୍‌ତେ ସେନଃ ନାଙ୍ଗ୍‌ ଗେଲ୍‌ହିସି ସିପାଇକଲଃ ସାଦମ୍‌ରେ ସେନ୍‌ତାନ୍‌ ଆପିହିସି ଗେଲ୍‌ ସିପାଇକକେ ଆଡଃ ଗେଲ୍‌ହିସି ବାର୍ଛା ସାବାକାଦ୍‌ ସିପାଇକକେ ସେକାଡ଼୍‌କବେନ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ଆବେନ୍‌ ପାଉଲୁସ୍‌ ନାଗେନ୍ତେ ସାଦମ୍‌ ଜଗାଡ଼୍‌କବେନ୍‌ ଜେ'ଲେକା ଇନ୍‌କୁ ପାଉଲୁସ୍‌କେ ସାଦମ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ଲାଟ୍‌ସାହେବ୍‌ ଫେଲିକ୍‌ସ୍‌ତାଃତେ ବୁଗିଲେକାକ ଇଦିସେଟେର୍‌ ଦାଡ଼ିୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ଏନ୍ତେ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇ ନେ'ଲେକା ମିଆଁଦ୍‌ ଚିଟାଉ ଅଲ୍‌କେଦାଏ । ");
INSERT INTO unx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ପୁରାଃ ମାଇନାନ୍‍ ଲାଟ୍‌ସାହେବ୍‌ ଫେଲିକ୍‌ସ୍‌କେ କ୍ଲାଉଦିଆ ଲୁସିୟସ୍‌ଆଃ ଜହାର୍‍ । ");
INSERT INTO unx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ଯିହୁଦୀ ହଡ଼କ ନେ ହଡ଼କେ ସାବ୍‌କେଦ୍‌ତେ ଗଗଏଃ ନାଙ୍ଗ୍‌କ ସାନାଙ୍ଗ୍‌ ତାଇକେନା । ଇନିଃ ମିଆଁଦ୍‌ ରୋମିରେନ୍‌ ହଡ଼ ତାନିଃ ମେନ୍ତେ ସାରିକେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଆଇଁୟାଃ ସିପାଇକଲଃ ସେନ୍‌କେଦ୍‌ତେ ଇନିଃକେଇଙ୍ଗ୍‌ ବାଚାଅକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ଇନ୍‌କୁଆଃ ବିରୁଧ୍‌ରେ ଇନିଃ ଚିନାଃ ଗୁହ୍ନାଁଁକାଦାଏ, ଏନା ସାରି ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଇନିଃକେ ଇନ୍‌କୁଆଃ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ତେଇଙ୍ଗ୍‌ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ମେନ୍‌ଦ ଇନିଃ ଗନଏଃ ଚାଏ ଜେହେଲ୍‌ରେ ସାଜାଇ ନାମେ ଲେକା ଜେତାନ୍‌ କାମି କାଏ କାମିକାଦା ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ସାରିକେଦାଇଙ୍ଗ୍‌ । ଆଡଃ ଆୟାଃ ବିରୁଧ୍‌ରେ ହବାକାନ୍‌ ଗୁହ୍ନାଁଁ କାଜି ଆକଆଃ ଆନ୍‌ଚୁ ବିରୁଧ୍‌ ବିଷାଏରେ ହବାକାନା । ");
INSERT INTO unx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ଆଡଃ ଇନିୟାଃ ବିରୁଧ୍‌ରେ ମିଆଁଦ୍‌ ରୋଜୋଟ ହବାକାନା ମେନ୍ତେ ସାରିକେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଇମ୍‌ତାଗି ଇନିଃକେ ଆବେନ୍‌ତାଃତେ କୁଲ୍‌ ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ଉହାଟ୍‌କେଦା । ଆୟାଃ ବିରୁଧ୍‌ରେୟାଃ ଗୁହ୍ନାଁଁକକେ ଆବେନାଃ ଆୟାର୍‌ରେ ଦହ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଆୟାଃ ବିରୁଧ୍‌ରେ କାଜିତାନ୍‌ ହଡ଼କକେଇଙ୍ଗ୍‌ କାଜିକାଦ୍‌କଆ ।” ");
INSERT INTO unx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ସିପାଇକ ଇନିଃ ଆଚୁକାଦ୍‌ ଲେକାଗି ପାଉଲୁସ୍‌କେ ଏନ୍‌ ନିଦାରେଗି ଆନ୍ତିପାତ୍ରି ନାଗାର୍‌ତେକ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ଏଟାଃ ହୁଲାଙ୍ଗ୍‌ ସେସେନ୍‌ତେ ସେନ୍‌ତାନ୍‌ ସିପାଇକ ଆଡଃ ସାଦମ୍‌ରେ ଦୁବ୍‌କେଦ୍‌ତେ ସେନ୍‌ତାନ୍‌ ସିପାଇକ ଇନିଃଲଃ ସେନ୍‌ ନାଗେନ୍ତେ ଗାଡ଼୍‌ତେକ ରୁହାଡ଼୍‌ୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ଇନ୍‌କୁ ପାଉଲୁସ୍‌କେ କାଇସରିୟାତେକ ଇଦିକିୟା, ଆଡଃ ଏନ୍ତାଃରେ ଇନ୍‌କୁ ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇଆଃ ଅନଲ୍‌ ଚିଟାଉଲଃ ପାଉଲୁସ୍‌କେୟ ଲାଟ୍‌ସାହେବ୍‌ଆଃ ତିଃଇରେକ ଜିମାକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ଲାଟ୍‌ସାହେବ୍‌ ଏନ୍‌ ଅନଲ୍‌ ଚିଟାଉ ପାଢ଼ାଅକେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ ଅକ ପାର୍‌ଗାନ୍‌ହେତେ ହିଜୁଃକାନାମ୍‌ ମେନ୍ତେ କୁଲିକିୟା । ପାଉଲୁସ୍‌ କିଲିକିଆ ପାର୍‌ଗାନ୍‌ରେନ୍‌ ତାନିଃ ମେନ୍ତେ ସାରିକେଦ୍‌ତେ, ");
INSERT INTO unx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ଇନିଃ କାଜିକିୟାଏ, “ଆମ୍‌କେ ଚିଟାମେତାନ୍‌ ହଡ଼କ ସେଟେର୍‌ୟାନ୍‌ ତାୟମ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଆମାଃ ବିଷାଏରେଇଙ୍ଗ୍‌ ଆୟୁମେୟାଁ ।” ଏନ୍ତେ ପାଉଲୁସ୍‌କେ ହେରୋଦ୍‌ ରାଜାରାଃ ମାହାଲ୍‌ଲଃ ତାଇକାନ୍‌ ମିଆଁଦ୍‌ କୁଠାରେ ଦହ ନାଗେନ୍ତେ ଆଚୁକେଦ୍‌କଆ । ");
INSERT INTO unx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ମଣେଁ ମାହାଁ ତାୟମ୍‌ତେ ମାରାଙ୍ଗ୍‌ ଯାଜାକ୍‌ ହନାନିୟ, ଚିମିନ୍‌ ଯିହୁଦୀ ପ୍ରାଚିନ୍‌କକେ ଆଡଃ ତର୍ତ୍ତୁଲସ୍‌ ନୁତୁମ୍‌ ମିଆଁଦ୍‌ ଓକିଲ୍‌ଲଃ କାଇସରିୟାତେକ ସେନଃୟାନା । ଇନ୍‌କୁ ଲାଟ୍‌ସାହେବ୍‌ ଫେଲିକ୍‌ସ୍‌ଆଃ ଆୟାର୍‌ରେ ପାଉଲୁସ୍‌ଆଃ ବିରୁଧ୍‌ରେ ଚିଟାନ୍‌କାଜିକ ଉଦୁବ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ଏନ୍ତେ ପାଉଲୁସ୍‌କେ ଏନ୍ତାଃତେକ ଆଉକିୟା ଆଡଃ ତର୍ତ୍ତୁଲସ୍‌ ମିମିଆଦ୍‌ତେ ଇନିୟାଃ ଚିଟାନ୍‌କାଜିକ ଉଦୁବ୍‌କେଦା, “ଏ ପୁରାଃ ମାଇନାନ୍‌ନିଃ, ଆବେନାଃ ସେଣାଁନ୍‌ ଆଗୁଆଇ ହରାତେ ଆଲେ ପୁରାଃ ଦିପିଲି ଜାକେଦ୍‌ ସୁକୁଜୀଉତେଲେ ତାଇନ୍‌ତାନା, ଆଡଃ ଆଲେୟାଃ ଦିଶୁମ୍‌ରେୟାଃ ବୁଗିନାଃ ନାଗେନ୍ତେ ପୁରାଃ ବୁଗିନ୍‌ କାମିକ କାମିକାନା । ");
INSERT INTO unx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ସବେନ୍‌ ଠାୟାଦ୍‌ତାଃରେ ଆଡଃ ସବେନ୍‌ ଦିପିଲିରେ ଆଲେ ନେଆଁକେଲେ ଦାରମେତାନା, ଆଡଃ ଆବେନାଃ ଧାନ୍ୟାବାଦ୍‌ଲେ ପାହାମେତାନା । ");
INSERT INTO unx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ଆଇଙ୍ଗ୍‌ ଆବେନାଃ ଆଦ୍‌କା ନେଡା ଇଦି ନାଗେନ୍ତେ କାଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା, ଏନାତେ ଆବେନ୍‌ ଦାୟାକେଦ୍‌ତେ ଆଇଁୟାଃ କାଟିଃଲେକା କାଜି ଆୟୁମେବେନ୍‌ ମେନ୍ତେଇଙ୍ଗ୍‌ ବିନ୍ତିତାନା । ");
INSERT INTO unx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ନେ ହଡ଼ଦ ପୁରାଃ ବରୱାନ୍‌ ହାଲାଗୁଲା ରିକାଏ ଲେକାନ୍‌ନିଃ ତାନିଃ ମେନ୍ତେଲେ ଆଟ୍‌କାରିତାନା, ଇନିଃ ଅତେଦିଶୁମ୍‌ରେୟାଃ ସବେନ୍‌ସାଃ ସେନ୍‌କେଦ୍‌ତେ ଯିହୁଦୀ ଥାଲାରେ ହାଲାଗୁଲାଏ ତାନା ଆଡଃ ଇନିଃ ନାଜ୍‌ରେତ୍‌ ଝୁଣ୍ଡ୍‌ରେନ୍‌ ମିଆଁଦ୍‌ ଆଗୁଆଇ ତାନିଃ । ");
INSERT INTO unx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ଇନିଃ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃକେ ସତ୍‌ରାଏ ନାଙ୍ଗ୍‌ ଚେଷ୍ଟା ତାଇକେନ୍‌ ଇମ୍‌ତା ଆଲେ ଇନିଃକେଲେ ସାବ୍‍କିୟା । ");
INSERT INTO unx_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ମେନ୍‌ଦ ହାଜାର୍‍ ସିପାଇକଆଃ ଆଗୁଆଇ ଲୁସିୟସ୍‌ ହିଜୁଃକେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ ପୁରାଃ ପେଡ଼େଃଲଃ ଆଲେତାଃଏତେ ଇଦିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ଆଲେ ଇନିୟାଃ ବିରୁଧ୍‌ରେ ଅକନ୍‌ ଚିଟାନ୍‌କାଜିକ କାଜିକାଦାଲେ, ଏନା ଆବେନ୍‌ଗି ନେ ହଡ଼କେ କୁଲିକେଦ୍‌ତେ ସାରି ଦାଡ଼ିୟାଃବେନ୍‌ ।” ");
INSERT INTO unx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ଯିହୁଦୀ ହଡ଼କହଗି ନେ ଚିଟାନ୍‌କାଜିରେ ମେସାକେଦ୍‌ତେ ନେ ସବେନ୍‌ କାଜିକ ସାର୍‌ତିତାନାଃ ମେନ୍ତେକ କାଜିକେଦା । ");
INSERT INTO unx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ଲାଟ୍‌ସାହେବ୍‌ ପାଉଲୁସ୍‌କେ କାଜି ନାଗେନ୍ତେ ଇସାରାକିୟା, ଆଡଃ ପାଉଲୁସ୍‌ କାଜିକେଦାଏ, “ଆଇଙ୍ଗ୍‌ ସାରି ତାନାଇଙ୍ଗ୍‌, ପୁରାଃ ବାରାଷ୍‌ହେତେ ଆବେନ୍‌ ନେ ଯିହୁଦୀ ହଡ଼କଆଃ ବିଚାର୍‌ନିଃ ହବାକାନାବେନ୍‌, ଏନାତେ ଆବେନାଃ ଆୟାର୍‌ରେ ଆଇଙ୍ଗ୍‌ ଆପ୍‌ନାଃ ବାଞ୍ଚାଅଃକାଜି କାଜି ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ରାସ୍‌କା କାନା । ");
INSERT INTO unx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ଆବେନ୍‌ ଆବେନ୍‌ଗି ସାରି ଦାଡ଼ିୟାଃବେନ୍‌ ଯେ, ଗେଲ୍‌ବାର୍‌ ହୁଲାଙ୍ଗ୍‌ଏତେ ଆଦ୍‌କା କା ହବାଅଃଆ ଆଇଙ୍ଗ୍‌ ଯୀରୁଶାଲେମ୍‌ତେ ସେୱା ନାଗେନ୍ତେଇଙ୍ଗ୍‌ ସେନାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ଯିହୁଦୀ ହଡ଼କ ଆଇଙ୍ଗ୍‌କେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେ ଜେତାଏଲଃ କାପ୍‌ଜିତାନ୍‌ କାକ ନେଲାକାଦିୟାଁ ଚାଏ ସାମାଜ୍‌ ଅଡ଼ାଃରେ ଚାଏ ନାଗାର୍‌ରେୟାଃ ଏଟାଃ ଜେତାନ୍‌ ଠାୟାଦ୍‌ରେ ହଡ଼କକେ ଏତ୍‌କାନ୍‌ କାମିରେ ଉସ୍‌କୁର୍‌ ନାଙ୍ଗ୍‌ କାକ ନେଲାକାଦିୟାଁ । ");
INSERT INTO unx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ଏନାତେ ଆଇଁୟାଃ ବିରୁଧ୍‌ରେ ନାହାଁଃ ଆଉୱାକାନ୍‌ ଚିଟାନ୍‌କାଜିକ ନାଗେନ୍ତେ ଇନ୍‌କୁ କାକ ଉଦୁବ୍‌ ଦାଡ଼ିୟା । ");
INSERT INTO unx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ଆଇଙ୍ଗ୍‌ ଆବେନ୍‌ତାଃରେ ମାନାତିଙ୍ଗ୍‌ ତାନାଇଙ୍ଗ୍‌ ଯେ ଅକ ହରାକେ ଇନ୍‌କୁ ହସଡ଼ ମେନ୍ତେକ କାଜିତାନା, ଏନ୍‌ ହରାକେ ଅତଙ୍ଗ୍‌କେଦ୍‌ତେ ଆଇଙ୍ଗ୍‌ ଆବୁଆଃ ପୁର୍‌ଖା ହାଡ଼ାମ୍‌କଆଃ ପାର୍‌ମେଶ୍ୱାର୍‌କେଇଙ୍ଗ୍‌ ସେୱାତାନା । ମେନ୍‌ଦ ଆଇଙ୍ଗ୍‌ହଗି ମୁଶା ନାବୀଆଃ ଆନ୍‌ଚୁ ଆଡଃ ନାବୀକଆଃ ପୁଥିରେ ଅଲାକାନ୍‌ ସବେନ୍‌ ବିଷାଏ ବିଶ୍ୱାସ୍‌ତାନାଇଙ୍ଗ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ନେ ହଡ଼କଆଃ ଲେକାଗି ପାର୍‌ମେଶ୍ୱାର୍‌ତାଃରେ ଆଇଁୟାଃ ମିଆଁଦ୍‌ ଆସ୍ରା ମେନାଃ ଚି, ଧାର୍‌ମାନ୍‌ ଆଡଃ ଏତ୍‌କାନ୍‌ ସବେନ୍‌ ହଡ଼କଆଃ ଗନଏଃହେତେ ଜୀଉବିନିରିଦ୍‌ ମେନାଃ । ");
INSERT INTO unx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ଏନାତେ ପାର୍‌ମେଶ୍ୱାର୍‌ ଆଡଃ ହଡ଼କଆଃ ସାମ୍‌ନାଙ୍ଗ୍‌ରେ ନିରାଲ୍‌ ବିବେକ୍‌ ଲେକାତେ ଚାଇଲ୍‌ ଚାଲାନ୍‌ ରିକା ନାଙ୍ଗ୍‌ ଆଇଙ୍ଗ୍‌ ସବେନ୍‌ ଇମ୍‌ତାଇଙ୍ଗ୍‌ ସାନାଙ୍ଗ୍‌ତାନା । ");
INSERT INTO unx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ପୁରାଃ ସିର୍ମାହେତେ ଯୀରୁଶାଲେମ୍‌ତାଃଏତେ ସାଙ୍ଗିନ୍‌ରେ ତାଇକେନ୍‌ ତାୟମ୍‌ତେ, ଆଇଁୟାଃ ଆପ୍‌ନାଃ ହଡ଼କ ନାଗେନ୍ତେ ଚିମିନ୍‌ ଟାକା ପାଏସା ଇଦି ନାଗେନ୍ତେ ଆଡଃ ଦାଣେଁ ରାକାବେ ନାଗେନ୍ତେ ଆଇଙ୍ଗ୍‌ ଏନ୍ତାଃତେଇଙ୍ଗ୍‌ ସେନାକାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ଆଇଙ୍ଗ୍‌ ଫାର୍‌ଚିନ୍‌ରେୟାଃ ରିତିରିୱାଜ୍‌ ଟୁଣ୍ଡୁଇ ତାଇକେନ୍‌ ଇମ୍‌ତା ଇନ୍‌କୁ ଆଇଙ୍ଗ୍‌କେ ମାନ୍ଦିର୍‌ ଅଡ଼ାଃରେକ ନେଲ୍‌କେଦିୟାଁ । ଇମ୍‌ତା ଆଇଙ୍ଗ୍‌ଲଃ ଗାଦେଲ୍‌ ହଡ଼କ କାକ ତାଇକେନା ଚାଏ ହାଲାଗୁଲା କା ହବାଅଃ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ମେନ୍‌ଦ ଏସିଆ ପାର୍‌ଗାନ୍‌ରେନ୍‌ ଚିମିନ୍‌ ଯିହୁଦୀ ହଡ଼କ ଏନ୍ତାଃରେକ ତାଇକେନା, ଇନ୍‌କୁଆଃ ଜେତ୍‌ନାଃ କାଜିରାଃ ତାଇକାନ୍‌ତେୟାଃ ରେଦ, ଇନ୍‌କୁ ଆକଗି ଆବେନାଃ ହେପାଦ୍‌ତେ ହିଜୁଃକେଦ୍‌ତେ ଆଇଁୟାଃ ବିରୁଧ୍‌ରେ ଚିଟାନ୍‌କାଜି କାଜି ଦାଡ଼ିକାତେତେୟାଃକ । ");
INSERT INTO unx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ଆଡଃଗି ଆଇଙ୍ଗ୍‌ ମାରାଙ୍ଗ୍‌ ପାଞ୍ଚେଟ୍‌ ଆୟାର୍‌ରେ ତିଙ୍ଗୁକାନ୍‌ ତାଇକେନାଇଙ୍ଗ୍‌ ଇମ୍‌ତା, ଆଇଙ୍ଗ୍‌ ଅକ ଏତ୍‌କାନ୍‌ କାମିରେୟାଃ ଗୁହ୍ନାଁଁରେଇଙ୍ଗ୍‌ ଚିଟାକାନା, ଏନା ନେତାଃରେ ଅକ ହଡ଼କ ମେନାକଆ, ଇନ୍‌କୁ କାଜିକାକ । ");
INSERT INTO unx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ଆଇଙ୍ଗ୍‌ ଇନ୍‌କୁଆଃ ଆୟାର୍‌ରେ ତିଙ୍ଗୁକେଦ୍‌ତେ ମିଆଁଦ୍‌ କାଜି ଏସ୍‌କାର୍‌ କାଜିକାଦ୍‌ ତାଇକେନାଇଙ୍ଗ୍‌, ଏନା ହବାଅଃତାନା, ‘ଗନଏଃ ହଡ଼କଆଃ ଜୀଉବିନିରିଦ୍‌ ମେନାଃ ମେନ୍ତେ ଆଇଙ୍ଗ୍‌ ବିଶ୍ୱାସ୍‌ତାନ୍‌ ହରାତେ ତିସିଙ୍ଗ୍‌ ବିଚାରଃତାନାଇଙ୍ଗ୍‌ ।’” ");
INSERT INTO unx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ଫେଲିକ୍‌ସ୍‌ ନେ ହରା ବିଷାଏରେ ବୁଗିଲେକାତେ ସାରିକାଦ୍‌ ହରାତେ ଆଡଃଗି କା ଆୟୁମ୍‌କେଦ୍‌ତେ କାଜିକେଦା, “ହାଜାର୍‌ ସିପାଇକଆଃ ଆଗୁଆଇ ଲୁସିୟସ୍‌ ସେଟେରାଏ ଇମ୍‌ତା, ଆଇଙ୍ଗ୍‌ ଆମାଃ ବିଷାଏରେୟାଃ କାଜିଇଙ୍ଗ୍‌ ଉହାଟେୟା ।” ");
INSERT INTO unx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ଇନିଃ ପାଉଲୁସ୍‌କେ ଜେହେଲ୍‌ରେ ଦହ ନାଙ୍ଗ୍‌ ମିଦ୍‌ଶାଅ ସିପାଇକଆଃ ଆଗୁଆଇକେ ଆଚୁକିୟା, ମେନ୍‌ଦ ପାଉଲୁସ୍‌କେ ସିକିଡ଼ିତେ କା ତଲ୍‌କେଦ୍‌ତେ ପୁରା ରାଡ଼ାଗି ତାଇନ୍‌କା ଆଡଃ ଆୟାଃ ଗାତିକ ନେପେଲ୍‌ ନାଙ୍ଗ୍‌ ହିଜୁଃରେ ଚାଏ ଆୟାଃ ଲାଗାତିଙ୍ଗ୍‌ତେୟାଃକ ଜଗାଅରେ, ଏମ୍‌ଇଚିକମ୍‌ । ");
INSERT INTO unx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ଚିମିନ୍‍ ହୁଲାଙ୍ଗ୍‌ରାଃ ତାୟମ୍‌ତେ ଫେଲିକ୍‌ସ୍‌ ଆୟାଃ ଯିହୁଦୀ କୁଡ଼ି ଦ୍ରୁସିଲାଲଃ ହିଜୁଃୟାନାଏ, ଇନିଃ ପାଉଲୁସ୍‌କେ କେଡ଼ାକେଦ୍‌ତେ ୟୀଶୁ ଖ୍ରୀଷ୍ଟ୍‌ତାଃରେ ବିଶ୍ୱାସ୍‌ ନାଙ୍ଗ୍‌ ଆୟାଃ କାଜି ଆୟୁମ୍‌କେଦା । ");
INSERT INTO unx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ମେନ୍‌ଦ ଚିମ୍‌ତା ପାଉଲୁସ୍‌ ଧାର୍‌ମାନ୍‌ ବିଷାଏ, ଆପ୍‌ନାଃ ମନ୍‌କେ ଥାବର୍‌ରେ ଦହ ଆଡଃ ହିଜୁଃତାନ୍‌ ବିଚାର୍‌ ହୁଲାଙ୍ଗ୍‌ ବିଷାଏରେ ଜାଗାର୍‌ ତାଇକେନାଏ, ଫେଲିକ୍‌ସ୍‌ ବରୟାନାଏ ଆଡଃ କାଜିକେଦାଏ, “ଆମ୍‌ ନାହାଁଃ ସେନଃ ଦାଡ଼ିୟାମ୍‌ । ସୁଯୋଗ୍‌ ନାମେରେ, ଆଡଃମିସା ଆମ୍‌କେଇଙ୍ଗ୍‌ କେଡ଼ାମେୟାଁ ।” ");
INSERT INTO unx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ଏନ୍‌ ନେଡାରେ ଇନିଃ ପାଉଲୁସ୍‌ତାଃଏତେ ଟାକା ପାଏସା ନାମେୟାଇଙ୍ଗ୍‌ ମେନ୍ତେ ଆସ୍ରାକାଦ୍‌ ତାଇକେନା, ଏନାମେନ୍ତେ ଇନିଃ ସବେନ୍‌ ଇମ୍‌ତା ଇନିଃକେ କେଡ଼ା ଆଉକେଦ୍‌ତେ ଜାଗାର୍‌ତାନ୍‌ ତାଇକେନା । ");
INSERT INTO unx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ନେ'ଲେକା ବାର୍‌ ସିର୍ମା ହବାୟାନ୍‌ ତାୟମ୍‌ତେ ପୋର୍କିୟସ୍‌ ଫେଷ୍ଟସ୍‌, ଫେଲିକ୍‌ସ୍‌ଆଃ ଠାୟାଦ୍‌ରେ ଲାଟ୍‌ସାହେବ୍‌ ଲେକାଏ ସାଲାୟାନା । ଫେଲିକ୍‌ସ୍‌, ଯିହୁଦୀ ହଡ଼କ ସୁକୁଆଇଙ୍ଗ୍‌କାକ ମେନ୍ତେ ସାନାଙ୍ଗ୍‌କେଦ୍‌ତେ ପାଉଲୁସ୍‌କେ କା ରାଡ଼ାକେଦ୍‌ତେ ଜେହେଲ୍‌ରେ ବାଗିକିୟା । ");
INSERT INTO unx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ଫେଷ୍ଟସ୍‌ ଏନ୍‌ ପାର୍‌ଗାନ୍‌ତେ ସେଟେର୍‌ୟାନ୍‌ରାଃ ଆପି ମାହାଁ ତାୟମ୍‌ତେ କାଇସରିୟାହେତେ ଯୀରୁଶାଲେମ୍‌ତେ ସେନଃୟାନା । ");
INSERT INTO unx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ଏନ୍ତାଃରେ ମୁଲ୍‌ ଯାଜାକ୍‌ ଆଡଃ ଯିହୁଦୀ ଆଗୁଆଇକ ଆଡଃମିସା ପାଉଲୁସ୍‌ଆଃ ବିରୁଧ୍‌ରେ ଚିଟାନ୍‌କାଜିକ ଫେଷ୍ଟସ୍‌ଆଃ ଆୟାର୍‌ରେ ବିନ୍ତିକେଦାକ । ");
INSERT INTO unx_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ପାଉଲୁସ୍‌କେ ଯୀରୁଶାଲେମ୍‌ତେ ଆଉ ନାଙ୍ଗ୍‌ ଆଚୁକମ୍‌ ମେନ୍ତେ ଇନ୍‌କୁ ଫେଷ୍ଟସ୍‌କେ କାଜିଗହାର୍‌କିୟାକ, ଚିଆଃଚି ଇନ୍‌କୁ ପାଉଲୁସ୍‌କେ ହରାରେ ଗଗଏଃ ନାଙ୍ଗ୍‌ ରୋଜୋଟକେଦ୍‌ତେ ଉହାଟ୍‌କାଦ୍‌ ତାଇକେନାକ । ");
INSERT INTO unx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ଫେଷ୍ଟସ୍‌ କାଜିକେଦାଏ, “ପାଉଲୁସ୍‌କେ କାଇସରିୟାରେୟାଃ ଜେହେଲ୍‌ରେ ଦହକାନା ଆଡଃ ଆଇଙ୍ଗ୍‌ ଏନ୍ତାଃତେ ଜାଲ୍‌ଦିଗିଇଙ୍ଗ୍‌ ସେନ୍‌ରୁହାଡ଼ା । ");
INSERT INTO unx_vpl VALU