﻿USE sofia;
DROP TABLE IF EXISTS sofia.ulk1902_vpl;
CREATE TABLE ulk1902_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ulk1902_vpl WRITE;
INSERT INTO ulk1902_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abele Iauali, abele Iesu Keriso ra kusi, abele Dauida ra uerem, abele Aberahama ra uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aberahama esomelu Isaaka; Isaaka esomelu Iakobo; Iakobo esomelu Iuda gako abara keimer giz; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda esomelu Faresa gako Zara Tamaraelam; Faresa esomelu Eseroma; Eseroma esomelu Arama; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arama esomelu Aminadaba; Aminadaba esomelu Naasona; Naasona esomelu Salemona; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salemona esomelu Boasa Rakabelam; Boasa esomelu Obeda Rutelam; Obeda esomelu Iese; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iese esomelu abele Dauida opole; Dauida opole esomelu Solomona Uria ai koskerlam; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona esomelu Reoboamo; Reoboamo esomelu Abia; Abia esomelu Asa; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa esomelu Iosefata; Iosefata esomelu Iorama; Iorama esomelu Usia; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia esomelu Iotama; Iotama esomelu Aasa; Aasa esomelu Esekia; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia esomelu Manase; Manase esomelu Amone; Amone esomelu Iosia; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia esomelu Iekonia gako abara keimer giz, abele kerker Isaraela namarare Babelonia ge areselam. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Abele kerker Isaraela bosi Babelonia ge Iekonia esomelu Salatiela; Salatiela esomelu Zerubabela; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabela esomelu Abiuda; Abiuda esomelu Eliakima; Eliakima esomelu Azora; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azora esomelu Sadoga; Sadoga esomelu Akeima; Akeima esomelu Eliuda; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eluida esomelu Eleazara; Eleazara esomelu Matana; Matana esomelu Iakobo; ");
INSERT INTO ulk1902_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakobo esomelu Iosefa Maria ra kimiar, Maria esomelu Iesu, abara nei atker Keriso. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dasmer, nosik uridili a ditimeda Aberahama bakedida Dauida dog foatin gaire nosik; a ditimeda Dauida dog bakedida abele kerker Isaraela namarare Babelonia ge foatin gaire nosik; a ditimeda Babelonia ge bakedida Keriso dog foatin gaire nosik. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Emereta Iesu Keriso esmelu mokakalam: Abara apu Maria au lagelage Josefaim, E deredare abara kem Lamar Zogolam, epe uiaba nole okakis. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ege Iosefa abara kimiar, abele le barkak tonar, E nole dikiapor Maria detage gaire le opem, E dikiapor gumik atuaki abima. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","E okabatagere abele gaire lu, dasmer, abele Opole ra Angela etomelu abi abele peim, kega, Iosefa ae, Dauida ra uerem, ma nole geum ma ko egaret Maria mara kosker; abelelam abara kem Lamar Zogolam. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","E esomelu abara kimiar uerem, ma abi nei etkeroa abim IESU; abelelam E uerkab abara ged uiaba uitelam. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Uao bakedida gaire lu uridili, iaueakai ageakarem Opole ra mer, abele perofeta, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Dasmer, abele neur ra kem ko esomeloa abele kimiar uerem, uiaba nei etkeroa abi Emanuela, tonar abele, ese etomeret, Ade Meribi okakis. ");
INSERT INTO ulk1902_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josefa ekiamulu utelam E ikerare abkoreb mokakalam Opole Angela ra mer, ko egaret abara kosker: ");
INSERT INTO ulk1902_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ege uiaba nole obapit kak bakedida abele kerker esomelu abara narbet kimiar uerem, E nei atker abi IESU. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Abele kerker ge Iesu esmelu muige Bethelema Iudaia ge, abele kerker ge Heroda opole, dasmer, makoi le tabakeuare naiger pekelam Ierusalemaem, ");
INSERT INTO ulk1902_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kega, Nade abele kimiar uerem esmelu Iudaia le la Opole? abelelam keriba erdali abara uer abele naiger peke, keriba tabakeuare abi esorgiru abim. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Heroda opole asor, E okasosok gako Ierusalema uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","E natameare gaire zogozogo le giz a aotale giz abele ged ge, E uiabi nautmerare nade Keriso esmelu. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Uiaba abi detagerare, Muige Bethelema Iudaia ge; abelelam perofeta detarare, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Mama Bethelema muige abele ged Iudaia, ma nole kebile gaire Juda opole; abelelam ma giz abele Tarima le, E sirdam Isaraela kara ged. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Heroda gumik emariklu taraisare gaire makoi le tabakeuare abim, E nautmerare uiabim, na kerker uiaba erdali abele uer. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Heroda naunarakare uiaba bakeuare Bethelemaem, kega, Bakeuare mamor deraimerare abele sursur uerem; ese uaba erdali, kari natomertare, kai naobukilu esorgiru abim. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ui ge aserare abele opole, ege uiaba bakeuare; dasmer, abele uer uiaba erdali naiger apek, kekiam uiaba opem, abele uer emerilu tumem abele kebi uerem ra uteb. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Uiaba erdali abele uer, uiaba au sererege. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Uiaba barot abele meta, uiaba erdali abele uerem gako abara apu Maria, a uiaba esorgiru abim; uiaba detuerare a itiru uiaba lu, ege uiaba naisuerare abim nase lu, abele gold, gako sus lipano, gako abele sus muro. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Uiabim natomertare abele peim ge Adelam uiaba nole ko bakomet Herodaim, ui ge bakeuare uiaba gedim nerute gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ui bakeuare, dasmer, abele Opole ra angela E natomertare Iosefaim abele peim ge, kega, Tekue, ma ais abele sursur uerem, gako abara apu, ua derareteder Aigupitoem, uaba emeridare kari naokaideroa kara mer marim, abelelam abele Heroda E deraimerare abele sursur uerem ko ipitare eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","E tekuelu a ais abele sursur uerem, gako abara apu abele ki ge, ui bakuidare Aigupitoem; ");
INSERT INTO ulk1902_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","E dauer niai niai Aigupito ge abele itudilu Heroda ra mop; iaueakai bakedida abele Opole ra mer perofeta detarare, kega, Kaka dabgiri kara uerem Aigupitolam. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heroda nardarare gaire makoi le abi okaderdare, abelelam E au uekuge E namarkare uader le narsare kimiar uerem giz Bethelema ge bakedida nener ge, ditimedare uiaba neis urut, gako uader kebile maike abkoreb, abele kerker ge Heroda deraimerare gaire makoi le. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ga akailu abele Ieremia perofeta ra mer, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ua aserare abele ebazoer Rama ge, abele au ebazoer op batapelare, Rasera E ezuer abara omasker, umer kak E paimilu, abelelam abara omasker eseamulu. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ege Heroda eumilu, dasmer, abele Opole ra angela etomelu Iosefaim abele peim ge Aigupito ge, ");
INSERT INTO ulk1902_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kega, Ma ais abele sursur uerem, gako abara apu, bakeuidare abele gedim Isaraela; abelelam emetu eumilu uader le deraimerare abele sursur uerem ipitare eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","E ge tekuelu ais abele sursur uerem, gako abara apu, ui ge bakeuidare abele gedim Isaraelaem. ");
INSERT INTO ulk1902_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Epe E asoli Arekilao Iudaia Opole Heroda ra kes abara aba, abelelam E au geum ko bakeam abele; ege peike abi etomelu abele peim ge Adelam, Ma bakeam abele ged Galilaiaem; ");
INSERT INTO ulk1902_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A E bakeam nerute uteb nei Nazareta E emerilu; ga akailu abele gaire perofeta ra mer, kega, E nei etkeroa Nazareta le. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Abele kerker Ioane, nei atker Bapataiso le, tabarki E marau abele Iudaia sumez ge, ");
INSERT INTO ulk1902_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kega, Ma obazgeda, abelelam kotor baselaia maike. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Abelelam E dali Isaia perofeta detager, kega, Abele kodo le ereretikri abele sumez ge, Uaba paret Opole ra gab, a dirup abara gab. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ege Ioane ra am uali kamela mus abara uak paur; abara leuer pem akerise ereger gako abele sumez isao. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ui bakeuare abim Ierusalema giz, gako Iudaia le uridili bakedilu Ioridano apek. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","E uiabi bapataiso Ioridano ge, a uiaba natomertare uiaba uite giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","E nardarare gaire Faresaio giz gako Sadukaio giz tabakeuare abim bapataisoem, E ui daratagerare, kega, Areg tabo ra omasker ae, nete uabi detomerta uaba deraret abele niai urker? ");
INSERT INTO ulk1902_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Uaba turum nagri abkoreb uaba obazgeda: ");
INSERT INTO ulk1902_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Uaba nole uabi dikiapore uaba nerkeplam, kega, Aberahama keriba aba; abelelam kaka uabi detager Ade umele depegeli baker peike ko Aberahama ra omasker. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Abele deumerupikeub tulik ikedilu maike lu giz ge; gaire lu uridili nole debe turum, E deregeir a dikri ur ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kaka uabi bapataiso abele ni iaueakai uaba obazger; epe nerute le kari keubu ekas E au kale kari tumge, kaka nole abkoreb tais abara teter gab; E uabi bapataiso abele Lamar Zogo, gako abele ur; ");
INSERT INTO ulk1902_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Abara tag nagri pat, E dirup abara kon etkemed; a E ais azig metaem gaire kon nole puip kak, ege kon ra gegur E disirkilu abele ur umer kak esameilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesu bakeamulu Galilaialam Ioridano ge Ioaneim, iauaekai E abi bapataiso. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ioane de abi daisumdalu, kega, Debele ma kari bapataiso, nako ma tabakeam karim? ");
INSERT INTO ulk1902_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesu etkalu abim, kega, Ma no bapataiso karim, abelelam abkoreb meribim bakedida gaire gelar barkak uridili; E mena abi asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ege E Iesuim bapataiso E tegemelu nilam dasmer, ege kotor nakesmulu, E erdalu Ade ra Lamar tabu mokakalam dibadib ise emerder abi kerem ge; ");
INSERT INTO ulk1902_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dasmer, abele kodo mer kotorlam, kega, Kara Uerem nase ge idali, kaka au sererege abim. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ege Iesu ais abele sumez ge abele Lamar de, iaueakai diabolo abi mirem. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesu baueru foate gaire gerger a foate gaire ki, E keubu uererege. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","E toabukilu abele le mirem, kega, Ese mama Ade ra Uerem, ma detager gaire baker a depegire leuer ise. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","E etkalu, kega, Emetu detarare, Nole leuer tepteb le eded, epe Ade ra mer uridili etomeret abi telam. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ege diabolo ko egaredelu Iesu abele zogo uteb, E ekueilu abele zogo meta tot ge, ");
INSERT INTO ulk1902_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","E abi detager abim, Ese mama Ade ra Uerem, ma eupemar a ekueilu sepge, abelelam emetu detarare, E abi mer tigri abara angela giz uiaba mari egared uiaba taglam, nole mara teter itur nerute baker ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu abi detager abim, Emetu detarare, kega, Ma nole mirem abele Opole mara Ade. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ege diabolo ko ais abim abele au pereper paserem, E abi etomeret abim gesep baselaia uridili, gako uiaba debe lu giz; ");
INSERT INTO ulk1902_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ege E abi detager abim, Kaka mari nakuar marim gaire lu uridili, ese mama kari erkepsam a esorgiru. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu abi detager abim, Ma adem bakeam Satana, abelelam emetu detarare, Mama abi esorgiru abele Opole mara Ade, E tepeteb mama abi memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ege diabolo abi dikaer, dasmer, epe angela tabarki abi memeg le giz abim. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesu asoli Ioane asirikilu abele au dubare meta, epe E bakeamulu Galilaiem. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Eabi dikaer Nazareta, E bakeamulu a emerilu Kapernaumge maike gur tauer ge, abele Sebulona a Nafatali ra nener. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iaueakai bakedida abele mer Isaia perofeta, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Abele ged Sebulona, gako abele ged Nafatali, abele gab abele gur ge Ioridano apek, Galilaia nogle giz ra ged; ");
INSERT INTO ulk1902_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abele le giz emerilu kupikupi ge uiaba erdali abele au be; uiaba le giz emerilu abele ged gako abele eud mar, uiaba erdali abele be batoamerti. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Abele kerker Iesu ditimeda ko marau, kega, Uaba obazgeda; abelelam kotor baselaia maike. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu ekasereder maike abele Galilaia gur ge, E abi erdali neisi le, Simona abara nei Peteru, gako Anederea abara keimer, uiaba net bataueret abele gur ge; abelelam ui darali umele larem. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","E uiabi detager, Ua kari narmili, kaka uaba depegimelu le asaperem. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ui darali dikaerei uiaba net a abi irmilei. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","E dikaer abele uteb, E ko erdali nerute neisi le Iakobo Zebedaio ra uerem, gako Ioane abara keimer, abele nar ge gako uiaba aba Sebedaio, uiaba ko euer uiaba net atoatelam; E uiabi darabgeri neisi le. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Uiaba sobkak dikaerei abele nar gako uiaba aba, a abi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ege Iesu deraueilu Galilaia uridili, E uiabi ereuerem uiaba sunago giz, E natomertare debe mer abele baselaia ge, a idigiri gim le giz gako asiasi gim abele ged uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ege abara mer esauer a aserare Suria uridili; epe uiaba taraisare abim gim le giz uridili a gaire tonar gim; gako uader le asiasi demoni giz uiabi dedkoli, a uader le paim gim gako le giz ibibi; E uiaba uridili nadgiri. ");
INSERT INTO ulk1902_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ege le lakub abi irmilare, gaire le Galilaialam, a Dekapolelam, a Ierusalemalam, a Iudaialam, a Ioridano apek. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ege E darasmerare abele le lakub, epe E ogi abele paser ge, ege emerilu, epe abara kaimeg giz tabakeuare abim; ");
INSERT INTO ulk1902_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ege E uiabi detager a ereuerem uiabim, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Uerkab uader le gebegeb nerkep; abelelam uiaba uteb kotor baselaia. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Uerkab uader le okasosok; abelelam nagri uiaba okadraseked. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Uerkab uader le mapodan tonar; abelelam uiaba nagri gobar atagor abele ged. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Uerkab uader le uererege a niap ge abele barkak tonarlam; abelelam uiaba gem osmeda. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Uerkab uader le nagri nasenas; abelelam E uiabi ko nasenas. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Uerkab uader le og kak nerkep; abelelam uiaba abi erdali abele Ade. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Uerkab uader le demeger abele mapodanuem; abelelam nei atkeroa Ade ra uerem giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Uerkab uader le dedkoli abele barkak tonarlam; abelelam uiaba nagri kotor baselaia. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Uerkab uaba ese uiaba adud mer uabim, a uabi dedkoeda a bes mer uabim, a gaire adud uridili uabim karielam. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Uaba sererege a bapereker; abelelam uaba nagri au bodomalam kotor baselaiaim; abelelam uiaba ikerare mokakalam gaire perofeta giz kekiam uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ege uaba gesep ra sol; ese sol nole kurabkurab a nade lu uaba kurabem? nolea nerute lu ko abkoreb ikerare no bataueret adem a le esapili. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Uaba gesep datki. Umer kak ispili abele uteb tumge paser ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Uiaba nole disirik abele lamepa, a iketilu muige abele kumete; epe iketilu abele lamepa ra uteb, iaueakai datki nagri le uridili abele meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Uaba datki mokakalam le la opem, iaueakai uiaba erdali uaba debe tonar, uiaba naospered uaba Aba emeri kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Uaba nole dikiaporare kaka tabakeamud ko detui abele gelar, gako abele gaire perofeta giz ra mer; kaka nole tabakeamud ko detui, epe bakedida. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Abelelam a ageakar kaka uabi detagered, Eseamulu abele kotor ge gako abele gesep ge, epe nole aseamur kak abele iota, gako kebi uar mog abele gelar giz, a mena bakedida gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dasmerare, ese le detui abele kebi gelar, a ereuerem le mokakalam, E nei eteker kebi kale abele kotor baselaia; epe ese le ikeli pako ereuerem abele, E nei eteker au kale abele kotor baselaia. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Abelelam kaka uabi detagered, Ese nole aule uaba barkak tonar tumem abele gaire aotale giz gako Faresaio giz, umer kak uaba barot abele kotor baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ua aserare gaire aule giz uiaba mer, Ma nole le ipit eumida; ese le ipit eumida nerute le, E bodomalam abele meratager. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Epe kakanale uabi detagered, Ese le tababu ueku abara boai, E nagri bodomalam abele meratager; ese le abi detager abara boai, Raka, E nagri bodomalam abele meratager; ege ese nerute le abi detager nerute le, Paim le ae, E nagri bodomalam abele ur Genaim. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ese ma abi ikuar mara zeku lu abele bao ge, epe ma ko dikiapore mara boai nagri nerute lu mari ueku, ");
INSERT INTO ulk1902_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ma dikaereti mara zeku lu abele uteb abele bao opem, epe ma bakeam; kekiam abi itikubi mara boai, a ko takomed a ikuar mara zeku lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ma dudum abi itikubi abele le ezoli abara gaire lu mari dog, peirdi uaba okakis abele gab ge; iaueakai nole mari emarid abele meratager abele le ezoli abara lu, a ko mari emarid abele meratager tarima le, E tarima le mari emarid abele memeg le, a memeg le mari emarid abele audubare meta. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ageakar kaka mari detager, Ma umer kak ko esomed, pe bakedida abara mani. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ua aserare aule giz ra mer, Ma nole kogem; ");
INSERT INTO ulk1902_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Epe kakanale uabi detagered, Ese le dasmer abele kosker E abi lag, E emetu kogem abim abara nerkep. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ese mara tuter pone mari nadkoli ma dekeamur a adem; abelelam debele nerute mog mara gem abi, a adud batauered mara gem kemerkemer Genaim. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ese mara tuter tag mari nadkoli, ma isimi adem, abelelam debele nerute mog mara gem abi, a adud batauered mara gem kemerkemer Genaim. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Uiaba mer kega, Ese le imud abara kosker, debele ko ikuar abim abele dituaki jauali; ");
INSERT INTO ulk1902_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Epe kakanale uabi detagered, Ese le imud abara kosker, epe nole ko kak, E abi namarik kogem; ese le ispilu abele amu kosker E dali kogem. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ua aserare aule giz uiaba nerute mer, Ma nole bes iskosi, epe ma abi ikuar abele Opole lu ma emetu iskosi; ");
INSERT INTO ulk1902_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Epe kakanale, kaka uabi detagerare, Nole iskosi kak; nole iskosi abele kotor ge, abelelam Ade ra bao ge; ");
INSERT INTO ulk1902_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Gako abele gesep ge, abelelam abele uteb ekueilu abara teter; gako Ierusalema, abelelam au Opole ra uteb. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma nole iskosi mara kerem ge, abelelam ma umer kak dipegili netat mara mus ko kakekake a golegole. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Epe uaba mer mokakalam, Uao, uao; Nole, nole; abelelam abele mer aule gaire mer, abara giz adudelam. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ua aserare uiaba mer, Bodomalam abele pone, nerute pone, a bodomalam abele tereg nurute tereg; ");
INSERT INTO ulk1902_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Epe kakanale uabi detagerare, Uaba nole imara abele adud; ese nerute le mara tuter peik bage erese, ma ko batauerik nerute. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ese le lagelage mari ikerare abele meratagerem, E ais mara gem uali, ma ikuar mara au gem uali. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ese le mari bamesili abi kemem bakeamulu abele netat mail, ma ko bakeamulu abim neis mail. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma abi ikuar abele le mari damosare, ma nole adem dimu abele le lagelage damosare mani marielam. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ua aserare uiaba kega, Ma abi nasenase abele le emerilu maike, a deralu abele le mari ueku; ");
INSERT INTO ulk1902_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Epe kaka uabi daratagerare, Uaba abi nasenase uiaba le giz uabi ueku, uaba debe mer ikuar uader le uabi adud mer egali, uaba abi nasenase uader le uabi deralu, uaba abi esorerapare uader le uabi bes mer gako uabi dedkoli; ");
INSERT INTO ulk1902_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Iaueakai uaba Baba emerilu abele kotor ge abara uerem giz uabim; E abi emarid abara lem uiabim uader le adud tonar, a uader le debe tonar, E abi emarida irmir ko abi uader le barkak tonar, gako uader le adud tonar. ");
INSERT INTO ulk1902_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Abelelam ese uaba abi nasenase uader le uabi nasenase, nalu uaba bodomalam nagri? nako telona giz nole ikerare mokakalam abele tonar? ");
INSERT INTO ulk1902_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ese uaba tepteb nasenase uaba boai, nalu lu aule uaba ikerare? nako telona giz nole ikerare mokakalam? ");
INSERT INTO ulk1902_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dasmerare, abkoreb uaba debe tonar kemerkemer, mokakalam uaba Baba emerilu kotor ge, E debele kemerkemer. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Uaba nole nakuarare uaba nase lu le ra opem, iaueakai uiaba erdali ua mokakalam ikerare; ege nole uaba bodomalam nagri abielam uaba Aba emerilu kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Epe ike, ese ma abi nase lu nakuarare, ma nole maber dibiri mara opem mokakalam bes le giz a sunago ge, a gab ge, iaueakai le giz uiabi naosepereda. Ageakar kaka uabi detagereda, Uiaba nagri bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ese ma nakuarare uader nase lu, debele mara ber tag nole asmer kak abele lu mara tuter tag ikerare: ");
INSERT INTO ulk1902_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iaueakai gaire mara nase lu nole le asmer kak; epe mara Baba dasmerauem abele lu mude ge, E mari ikuar paret kak mari bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ese ma abi esorerapare, ma nole mokakalam bes le giz; abelelam uiaba lagelag esorerapare sunago ge a gab uasuli opem gaire le, iaueakai gaire le uiabi darasmerare. Ageakar kaka uabi detagereda, Uiaba nagri bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ese ma esorerapare, ma ge bao mabi uteb ge, a dimi abara te, ege ma abi esorerapare mara Baba penoka dali ardar kak uteb ge; mara Baba E darasmerare abele ardar kak uteb ge, E mari nakuaroa paret kak mari bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ese uaba esorerapare nole mer mer ko etomeret mokakalam gaire nog le giz; abelelam uiaba dikiaporare ese gaire mer Ade uiabi nase ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dasmerare, uaba nole mokakalam uiaba; abelelam uaba Aba ge erdar gaire lu uridili uaba nole nagri, a ua nole amosi kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dasmerare, uaba esorerapare mokakalam: Keriba Aba kotor ge, zogoem mara nei. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mamoro mara baselaia sepem uatabu. Ikeroa mabara lag abele gesep ge, mokakalam kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Keribi ikuar leuer abkoreb abele gerger. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Adem dikri keriba uit, mokakalam keriba dikri ui uridili keribim dedkoeda. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nole keribi tegeredare abele mirem; epe keriba ditkedarare uitelam; Abelelam mari dog baselaia, a adigir, a deseper, niai karem. Amen. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Abelelam ese uaba dikri le la uit; ege uaba Aba dali kotor ge adem dikri uaba uit. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ese uaba nole dikri le la uit, uaba Abet nole ua dikri uaba uit. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ese uaba leuer baili, nole opauzi mokakalam bes le giz; abelelam uiaba dedkoli uiaba op, iaueakai gaire le nardarare uiaba leuer baili. Ageakar ka uabi detagereda, Uiaba bodomalam nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ese ma leuer baili, ma idu desas mabara kerem; a dirup mara op; ");
INSERT INTO ulk1902_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Iaueakai gaire le nole ardar kak ma leuer baili, epe mara Aba penoka dali ardar kak uteb ge; a mara Aba E ua dasmerare abele ardar kak uteb, E mari etomer paret kak mari bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Uaba nole aukase deraimerare uaba gesep lu, a nagri degem gako lee umele eseamulu, a nagri le eroam, E abi daiui a ko eroam: ");
INSERT INTO ulk1902_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Epe uaba aukase deraimerare uaba kotor lu, nole degem a nole lee umer kak eseamulu, nole le eroam, E abi daiui a ko eroam; ");
INSERT INTO ulk1902_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Abelelam abele uteb uaba lu nagri, a uaba nerkep abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Abele pone, gem ra lamepa; ese mara pone debele, a mara gem datki uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ese mara pone adud, a mara gem kupikup uridili. Dasmer, ese kupikup abele be muige mari dog, uaiai au kupikup! ");
INSERT INTO ulk1902_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Umer kak le memeg neis opole; abelelam E derar nerute le, epe E nase nerute le; ese nole, E ekpi nerute le ge, epe dituaki nerute le. Uaba umer kak memeg le Adim a gako mamona. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Abelelam kaka uabi detagereda, Uaba nole okadeskeda uaba eded, na leuer uaba eroare, a na ni uaba ereare; gako uaba gem na lu uaba ameare. Nako eded nole aule abele leuerlam, gako abele gem abele amelam? ");
INSERT INTO ulk1902_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Uaba dasmerare ebur giz epereda; uiaba nole saido dikri, a nole deregeir, a nole azig saido meta ge; epe uaba Aba, emerilu kotor ge, uiabi darasisieda. Nako uaba nole au debele uiabim? ");
INSERT INTO ulk1902_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na le dali uaba umele abara okadeskeda, E asaimer abara eded netat kubita? ");
INSERT INTO ulk1902_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nalugem uaba okadeskeda uaba am uali? Ua dikiaporare abele sumez goago, nako tonar omeilu; uiaba nole dorge a nole erat. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kaka uabi detagereda, Ege Solomona, gako abara au debe lu giz, E nole abara am uali mokakalam abele nerute uiaba. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ese Ade abi ikuar mokakalam am uali abele gaire lu ged sumez, eded abele gerger a ko batauered idim ge abele amei uteb, nako uaba nole au debe am uali nagri, uaba kebi oituli? ");
INSERT INTO ulk1902_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dasmerare, uaba nole okadeskeda, gako mer mokakalam, Na leuer meriba aroare? a na ni meriba ere? a na am uali meriba amear? ");
INSERT INTO ulk1902_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Abelelam gaire lu peike gaire nogle giz deraimerare; abelelam uaba Aba penoka dali abele kotor ge, E dasmerauem gaire lu uridili abkoreb uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ege uaba kekiam deraimerare abele Ade ra baselaia, gako abara barkak tonar, iaueakai uaba gaire lu uridili nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dasmerare, uaba nole okadeskeda abele idim ge; abelelam okadeskeda idim ge abgerger abara lu, abkoreb abele gerger abara adud. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ua nole abi meratager kak nerute le, iaueakai E uabi ko nole meratager. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Abelelam abele meratager ua abi meratager, E ko uabi meratager; abele tonar lu uaba abi detali, a E ko uabi detali. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nalu ma abi dasmeri lu puipi mara le la pone ge, a ma nole umer kak abele au lu mara pone ge? ");
INSERT INTO ulk1902_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nalugem ma detager mara le, Abkoreb kaka atperedelu lu puipi mara pone; dasmer, abele au lu nagri mara pone ge? ");
INSERT INTO ulk1902_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mama bes le, kekiam batauereda abele au lu mara pone ge; iaueakai ma erdali paret kak abi atperedelu abele lu puipi mara le la pone ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nole abkoreb uaba ikuar abele zogo lu omai giz, a ua nole dikri uaba penina gaire borom giz ra opem, mena esapirda uiaba teter, a ko batauered uabi eregili mogamog. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ua abi damsare, iaueakai uabi nakuarare; a uaba deraimerare, epe uaba erdali; a uaba abi dida mudumud iaueakai uabim diski. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Abelelam ese le abi damsare E nagri; abele le deraimer E abi erdali; a diski abele le abi dida mudumud. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nete le uabim, ese mara uerem mari namosi aretoem, nako ma abi ikuar baker? ");
INSERT INTO ulk1902_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A ko mari namosi larem, nako ma abi ikuar tabo? ");
INSERT INTO ulk1902_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Dasmerare, uaba adud le, ese uaba umele nakuarare debe lu uaba omasker giz, nako uaba Aba penoka dali kotor ge, nole uabi nakuarare au debe lu giz uiaba le abi damsare? ");
INSERT INTO ulk1902_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Gaire lu uridili uaba lag le giz uabi ikerare, mokakalam uabi ikerare uiabim; abelelam abele gelar gako gaire perofeta giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Uaba barot abele kebi gab te ge; abelelam au te abele au gab te ge, a aule abele gab a gaire le ekaseredi bakeaud. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Abelelam kebi te abele gab te ge, a kebi kale abele gab a bakedida eded, a neis neis le erdali. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ege uaba mamor dasmerare gaire perofeta bes, uiaba tabarki uabim mamoe am uali, epe muige arega luko uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ua erdali uiaba turum. Nako le edobemeda uina moda abele lu daradar, pako suke abele lu zegerzeger? ");
INSERT INTO ulk1902_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ege mokakalam debe lu giz uridili kepu debe turum, epe abele adud lu a ko adud turum nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Umer kak debe lu nagri adud turum, umer kak adud lu a ko nagri debe turum. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gaire lu uridili nole debe turum, a ismi batauerda abele ur ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dasmerare, uaba erdali uiaba turum. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Umer kak barota kotor baselaia uiaba uridili kari mer mokakalam, Opole ae, Opole ae; epe abele le ikerare kara Aba ra lag penoka dali kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Gaire le kari detagarare niai gerger, Opole ae, Opole ae, nako keriba nole perofeta mara nei ge? a mara nei ge ko keriba dituaki gaire demoni giz? a mara nei ge ko keriba ikerare gaire adigir? ");
INSERT INTO ulk1902_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kaka paret kak detagerare uiabim, Kaka nole umer kak uabim; ua bakeuare adem karielam, uaba adud tonar. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Dasmerare, ese le asoli kara mer giz peike E ko ikeli, kaka abi babisdarie E pardale, E ikeli abara meta abele neid ge; ");
INSERT INTO ulk1902_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Epe irmir apu a dodo tabarki a uak uami abi abele meta ge; umer kak edibida, abelelam giz tumem abele neid ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ese le asoli kara mer giz ike a nole ikeli, E babisdarie abele paim le, E ikeli abara meta tumem abele ue ge; ");
INSERT INTO ulk1902_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Epe irmir apu a dodo tabarki a uag uami abi abele meta ge; epe edibida barabeda mogmog. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu ra gaire mer eseamulu, epe gaire le lakub abi damared abara giz mer. ");
INSERT INTO ulk1902_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Abelelam E ereuerem uiabim mokakalam le nagri sirdam, a nole mokakalam aotale giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu uatabu abele paerlam, epe abi irmili gaire le lakub. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dasmerare, nerute lepera tabarki a etkobeilu abim, kega, Opole ae, ese ma lag ma umele kari idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ege Iesu ra tagu itirimuriklu a itutilu abim, E kega, Kara lag mari idigir. Epe sobkak idigir abara leper. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ege Iesu abi detager, kega, Debele ma nole atomeret kak nerute le; a ma bakeamulu mabu, etomeret abele zogo le, a ma abi ikuar zeku lu mokakalam Mose ra gelar, atamelam uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ege Iesu Kaperenauma tabarki, epe abele kerem le, abele netat handed le abara nosik, E tabaruk a abi damsare, ");
INSERT INTO ulk1902_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kega, Opole ae, kara memeg le eidi meta ge gimgim, abele kegar au asiasi. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ege Iesu abi detager, kega, Mena kaka bakeamulu a abi idigir ");
INSERT INTO ulk1902_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kerem le, netat handed le abara nosik, abi detager, kega, Opole ae, nole abkoreb ma tabakeam bao muige kara meta; epe netat mara mer tabarki, a idigir kara memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Abelelam kaka nerute le kari sirdam, a kaka sirdam abele gaire ares le; ese kaka abi detager nerute le, Ma bakeam, epe E bakeam; a nerute le, Ma tabakeam, a ko tabakeam; pako kara memeg le, Ma ikeli abele lu, epe E ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ege Iesu asoli, E au damared, E uiabim detagerare gaire le abi irmilare, kega, Ageakar kaka uabi detagerare, kaka nole erdali nerute Isaraela le nagri au oituli mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kaka uabi detagerare kega, Gaire le tabakeuare naigerlam a siailam, ko kemem okakis eroare Aberahama, a Isaaka, a Iakobo, abele kotor baselaia ge: ");
INSERT INTO ulk1902_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Epe ged kemle uerem giz uiaba imuare abele kupikup adige, a nagri au ebazuer a tereg ikukumared. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ege Iesu abi detager abele kerem le, handed le abara nosik, Ma bakeam, mokakalam mara oituli, a ko ikeli marim abkoreb. Epe akaida abara memeg le abele haua ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Epe Iesu balu abele Peteru ra meta ge, E abi erdali abele apu Peteru ra kosker eidi abele urueri gim. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","E itutilu abele kosker ra tag, epe akaida abara urueri gim; a E tekueilu abi memeg le uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Epe kikem, uiaba taraisare gaire le demoni barota; epe namuare adud lamar giz abele abara merlam, E idigiri uiaba gim le giz: ");
INSERT INTO ulk1902_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iaueakai bakedida abele Isaia ra mer, kega, E ais meriba gebegeb, a ko bakuar meriba gim. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ege Iesu dasmerare gaire le lakub abi derumeda, epe E uiabi detagerare, Ua bakeuare nerute apek. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Epe nerute aotale tabarki, a abi detager, kega, Ereuer le, kaka mari irmili gaire uteb ma bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ege Iesu abi detager, kega, Arobe nagri abara kur, a ebur giz epereda nagri uteb uteidi; ege Le la Uerem E nole abara uteb uteidi. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ege nerute abara kaimeg giz abi detager, Opole ae, ma kari namarid kaka kekiam bakeam etkobei kara aba. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ege Iesu abi detager, Kari narmili; a dikaer eud le giz uiaba etkobei eud le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","E atiem abele nar, epe abara kaimeg giz abi irmilare. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Dasmerare, abele au uag tabarki abele gur ge, epe gaire zauber etatakoi abele nar; a E uteidi. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Epe abara kaimeg giz tabakeam, a abi itir, kega, Opole ae, ma uerkab keribim, a keriba maike nabaumer. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ege E uiabi detagerare, kega, Nalugelam uaba geum, uaba kebikebi oituli? Epe E tekueilu, a dasiumda abele uag pako abele gur, iaueakai au metalug. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ege uiaba le giz abi damared, kega, Au kale abele Opole, abelelam uag a gur aserei. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ege E bakeamulu nerute apek abele ged Geregese tabarki, ege obapitei neis le demoni badariei tabakeamlam aolam, uiaba au saserim, umer kak nerute le ekase abele gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Darasmer, neis le ereretikri, kega, Nalu mara mer keribim, Iesu ae, Ade ra Uerem? Nako ma tabakeam ike keribim ikeli asiasi a nole bakedida abele niai kerker? ");
INSERT INTO ulk1902_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ege muriz ge abele gaire borom degemeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Uiaba demoni giz abi damsare, kega, Ese ma keribim imuare adige, ma keribim namarid gaire borom giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ege E abi detager uiabim, Ua bakeuare. Ui ge baos adem, a bakeuare abele gaire boromaem; darasmerare, abele borom au isir baupamarti abele au uak gur ge, a baum eseamulu abele gur ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ege gaire le asisiem a koreder bamer, a baos abele uteb ge, a natomertare gaire lu uridili, a pako gaire lu ikeli neis le demoni dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dasmerare, gaire le uridili tabarkare abele utebelam a obapitare Iesuim; uaiba abi erdarare, epe uiaba abi damsare, A ma bakeam adem keriba gedlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ege Iesu atiem abele nar ge, a bakeamulu nerute apek, epe baos tabara uteb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dasmerare, uiaba egardare abim abele le ibibi, E eidi abele sik; Iesu abi nardarare uiaba oituli, epe E abi detager abele le ibibi, Kara uerem ae, mara nerkep ua saserim, emetu adem dikri mara uit. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dasmerare, uader aotale le tababu dikiaporare uiaba nerkep ge, Abele le adud mer egali Adim. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ege Iesu de nardarare uiaba dikiaporare, epe E uiabim, kega, Nalugelam uaba adud dikiaporare uaba nerkep ge? ");
INSERT INTO ulk1902_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Abelelam nade lu perper? nako abele mer abi detager, Mara uit emetu idigir; a nako abele mer abi detager, Tekuei, ma ge bakeam? ");
INSERT INTO ulk1902_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ueakai uaba opasereret Le la Uerem nagri sirdam abele geseb ge E idigir uit giz, (E abim detager le ibibi), Ma ge tekuei, a ais mabara sik, a bakeam mabara meta. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","E ge tekueilu, a bakeamulu tabara metaem. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Epe le lakub abi erdarare, uiaba sererege, a desperare Adim, E nakuarare abele sirdam le mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ege Iesu bakeamulu adem abele utebelam, epe E erdali abele le emreder abele meta ge a asesereder zegu mani, abara nei Mataio; E abi detager, Ma kari narmili, ege E tekueilu, a abi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ege E sep ge eidi abele meta a leuer eroli, dasmerare, gaire telona giz a pako uite le giz a tabakeuare uiaba eidi okakis Iesuim, pako abara kaimeg giz, a leuer erolare. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Faresaio giz abi erdali, uiabi abi detagerare abara kaimeg giz, Nalugelam uaba Ereuerem le kemem leuer eroli a gaire telona giz pako uite le giz? ");
INSERT INTO ulk1902_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ege Iesu asoli, E uiabi daratagerare, Nole abkoreb lukup le gaire gim kak le, epe mamoro abkoreb gaire le gimgim. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ua bakeuare a ereuerem nalu tonar abele mer, Kaka lagelag abele nasenas, a nole abele zegu lu; abelelam kaka nole tabarki darabgerare gaire le barkak tonar, epe uite le giz uiaba obazgeda. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ege Ioane ra kaimeg giz tabakeuare abim, kega, Nalugem keriba gaire kerker leueru baili, a pako gaire Faresaio, epe mara kaimeg giz nole leueru baili? ");
INSERT INTO ulk1902_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ege Iesu de uiabi daratagerare, Umer kak okasosok gaire kaimeg le, abele le kerkar ispit abara kosker, abele uader gerger uiabi kemem, a niai kerker tabarki le ispit adem bakeamulu uiabielam, epe uiaba leueru baili. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nole nerute le umele ekpi emeret gem uali abele kerkar mog uali; abelelam atoat abele emeret gem uali abara ekpi, iaueakai au atoatatoat. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Umer kak kerkar uaina etatakoi abele emeret gegur tarpor: ese mokakalam gegur tarpor erperidlu, a uaina epaiteredlu, a gaire gegur tarpor dedkoli: epe etatakoi abele kerkar uaina abele kerkar gegur tarpor, iaueakai mamoro debele. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","E uiabi daratagerare abele gaire mer, Dasmer, abele kole tabarki E abim etkobeilu, kega, Kara neur emetu eumida; a ma tabakeam a dikmerik mara tagu abara tumge, iaueakai eded. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ege Iesu tekueilu, a abara kaimeg giz abi irmilare. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Dasmer, abele kosker E nagri mam gim tuelf gaire urut, E bakeamulu Iesu ra sor ge, a abi itutilu abara am uali ub ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Abelelam E tababu dikiapor muige abara nerkep, Ese kaka no itutilu abara am uali, a kara eded nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ege Iesu baseker, a abi erdalu, E detager, kega, Kara neur, mara nerkep au saserim, a ma eded maba oitulam. Ege abele kosker eded abele haua ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ege Iesu balu abele kole ra meta ge, E darasmerare gaire lekub a burar diperi a uiaba ebazuer, ");
INSERT INTO ulk1902_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","E uiabi daratagerare, Ua bakeuare adem; abelelam abele neur nole eud kak, E no uteid. Ege uiaba abi neg degarare abim. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ege lekub namuare, a E balu, a erpeilu neur ra tag; ege ekueilu abele neur. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Abele mer aserare abele ged uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu adem bakeamulu abele utebelam, epe uiaba abi narmilei neis sadamer le, a ereretikri, kega, Dauida ra Uerem, ma keribi nasenas. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","E balu abele meta ge, a neis sadamer le tabakeamulei abim; a Iesu uiabi daratager neis le, Nako uaba karim oituli kaka umele abele lu ikeli? Epe uiaba detaut, Uao, Opole. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ege E uiabi natutilu uiaba pone, a uiabi daratager, kega, Mokakalam uaba oituli, a ko ikeli abkoreb uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ege uiaba pone bakaerei; ege Iesu de au kase daratager neis le, kega, Uaba nole atomeret kak nerute le. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","A neis le bakeamulei, a merkem abele mer abielam abele ged ge uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Neis le bakeamulei; darasmerare, uiaba tegaret abele le te dabimdabim a demoni ko balu muige. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","E abi imuare abele demoni; ege le mamoro mer etakalu, abele le te dabimdabim: ege lekub uiaba abi damarare, a mer detagerare, kega, Emeretalam meriba nole erdali nerute lu mokakalam Isaraela ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A Faresaio giz abielam detagerare, kega, Abele au demoni abi dog, abelelam E umele namuare demoni giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ege Iesu deraueli gaire utebe uridili pako kebi utebe, a ereuerem uiaba sunago ge, a marau abele baselaia ra debe mer, E nadgirare gim le uridili, pako au asiasi gim le abele ged ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","E nardare gaire lekub, epe E au nasenase uiaba, abelelam uiaba au sagim a dekaertare, mokakalam mamoe giz nole le asesered kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ege E uiabi detagerare, abara kaimeg giz, Epe gaire abele saido isimare, a no neis neis le dorge; ");
INSERT INTO ulk1902_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Peike uaba damsare abele Opole, abara saido isimare, E ko namarkare uader le dorge abara saido isimare. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ege E darabgerare abara kaimeg giz tuelf le, E uiabi nakuarare abele sirdam gaire adud lamar, a ko namuare uiabi, pako nadgirare gim le uridili, a pako au asiasi gim uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Uiaba nei gaire apostolo tuelf le; a kekiam, Simona, abara nei Peteru, a Anederia abara keimer; a Iakobo Zebedaio ra uerem, pako Ioane abara keimer; ");
INSERT INTO ulk1902_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo, a Batolomaio; a Toma, a Mataio telona le; a Iakobo Alefaia ra uerem, pako Lebaio abara nei Tadaio; ");
INSERT INTO ulk1902_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simona Kanana le, pako Iuda Isakariota, E abi keserkeser. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ege Iesu de namarkare uiaba tuelf le, E uiabi daratagerare, kega, Uaba nole bakeuare abele gab uiaba nogle giz, a ua ko nole bakeuare gaire Samaria utebem; ");
INSERT INTO ulk1902_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A debele ua bakeuare gaire mamoe Isaraela ra boai badimirida. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","A ua bakeuare, a marau, kega, Kotor baselaia maike. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ua nadgirare gim le giz, a darapare lepera le, a nakiamare eud le giz, a daramuare demoni giz: uaba turum nagri, a uaba ko naisuerare. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Uaba nole gol, a silua, a baras uaba uak: ");
INSERT INTO ulk1902_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ua bakeuare nole aisare epei, a nole neis am uali, pako teter gab, a koket; abelelam abkoreb ikuar leuer abele le dorge ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ese uteb pako kebi uteb ua baos, nautumerare nade abele le emeri abkoreb, a ua bameroa a ko bakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A ua barota nerute boai ge, uaba uiabi sererege a tag deguat. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ese abkoreb abele boai, a ua ko nakuarare uaba debe mer; ese abele boai nole abkoreb, iako takomeda uabim uaba debe mer. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ese le nole agared kak uabim, a nole asor kak uaba mer, a ua bakeuare adem abele metalam pako abele utebelam, uaba tekuei a teter gab ditkeda sep uaba teterlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ageakar kaka uabi detagered, Abele itimer gerger kebi bodomalam Sodomaem a Gomoraem tumem abele uteb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Dasmer, kaka uabi demarida mokakalam mamoe giz eipu gaire luko giz; abelelam uaba pardali mokakalam tabo, a au mapodan mokakalam lupe. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","A ua bako le giz: abelelam uiaba uabi demarida abele mer atager, a ko uiaba uabi demarida uiaba sunago ge, ");
INSERT INTO ulk1902_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A uabi eguatumur tarima le a opole uiaba opem karielam, a ikeli ageakarem uiabim pako uiabim nogle giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ese uiaba uabi demarida, uaba nole okadeskeda nako a nalu uaba mer detaut; abelelam E uabi etomeret abele haua ge nerute mer uaba detaut. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Abelelam uaba nole detaut, epe uaba Aba abara Lamar zogo detaut muige uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nerute le tabara narbet namarida ko eumid, a aba namarida abara omasker: a omasker giz tekue uiaba aba, iaueakai uiabi ipiti eumid. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gaire le uridili uabi derar kara neilam; epe abele le niaiem tekuei bakedida mop ge, E ko eded. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ese uiaba uabi dedkoli nerute uteb, a ua ko kored bakeuare nerute utebem; abelelam a ageakar kaka uabi detagereda, Umer kak uaba basiki Isaraela ra uteb uridili, mena Le la Uerem tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nole aule ereuer le tumem abele le abi ereuerem, a ko nole aule abele memeg le tumem abara opole. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Au debele okakis ereuer le mokakalam abele le abi ereuerem, a ko abele memeg le mokakalam abara opole. Ese uiaba nei atker abele boai ra opole Belezebul, nako uiaba nole ikeli mokakalam abara boai? ");
INSERT INTO ulk1902_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Dasmerare, uaba nole geum kak uiabim; abelelam nole nerute lu ispili, a umele paret kak etomeret; a nole nerute lu mud ge, a umele etomeret. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ege kara mer uabi detagereda kupikup ge, a uaba etomeret abele datki: a abele mer ua aserare uaba grip ge, a uaba etomeret tumem meta. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Uaba nole geum uader le uaba gem ipit eumid, a umer kak uiaba ipit eumid uaba lamar; a mamoro uaba geum abele le E umele dedkoli abele lamar pako gem Genaim. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nako nole bodomalam neis kebi ebur abele asari? nole nerute abi abele sep ge a uaba Aba mamoro dasmeri. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A uaba mus uridili emetu etager. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Peike uaba nole geum kak, uaba aule tumem gaire kebi ebur giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Dasmerare, ese le kari etomeret gaire le la opem, a kaka ko etomeret abim kara Aba ra opem abele kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ese le kari asared le la opem, a kaka ko asared abim kara Aba la opem penoka kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Uaba nole dikiaporauem kaka tabarki dekuarare mapodan abele geseb ge; kaka nole tabarki dekuarare abele mapodan, epe abele teibur aosos tulik. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Abelelam kaka tabarki dekuarare ueku abele le pako abara aba, a pako abele neur uerem ko ueku abara apu, a abele kosker ueku kimiar ra apu; ");
INSERT INTO ulk1902_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A ikeli le abara boai ko abi kurab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Abele le au nasenas abara aba pako abara apu a E kebi omare karim, nole karim abkoreb; a abele le au nasenas abara uerem, pako abara neur, a E kebi omare karim, a ko nole abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ese le nole ais abara satauro, pako nole kari narmili, nole karim abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Abele le erpei abara eded, a ko abi abielam; ege abele le dedkoli abara eded karielam, a ko nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Abele le uabi egared, E kari egared, abele le kari egared, a E egared abele le kari namarid. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Abele le egared nerute perofeta a perofeta nei ge, E nagri bodomalam abele perofetalam; a abele le egared nerute le barkak tonar a le barkak tonar nei ge, E nagri bodomalam abele le barkak tonar. ");
INSERT INTO ulk1902_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ese le abi ikuar no ni gebegeb abele tanelu ge abim nerute kebile ko eri, abele nei kaimeg giz, ageakar kaka uabi detagered, Nole abu kak abara bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Emetu Iesu mer tigri abara kaimeg giz tuelf le, ege E adem bakeamulu abele utebelam, a ereuerem pako etomeret uiaba utebim. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ege Ioane asoli abele audubare meta ge Keriso ra dorge, epe E abi namarida neis abara kaimeg giz, ");
INSERT INTO ulk1902_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","A abim kega, Nako mama le tabarki, a nako keriba ko naokaili nerute le? ");
INSERT INTO ulk1902_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ege Iesu uiabi daratager, kega, Ua bakeamulei a etomeret Ioaneim a gaire lu uaba asoli, pako dasmerei: ");
INSERT INTO ulk1902_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gaire le pone asadamer bakaerti, uader le ibibi nakasiri, a lepera idigir, pako grip batapili a asoli, uader le eumid ko eded akaida, a etomeret abele debe mer uiabim gaire lu kak le. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","E gaire debe lu nagri abele le, nole kari asared kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Uiaba bakeamulei, ege Iesu uiabim marau le lakub Ioaneialam, Nalugem uaba bakeuare a dasmerare abele sumez ge? Nako abele mebud uag demali? ");
INSERT INTO ulk1902_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nalugem uaba bakeuare a dasmerare? Nako abele le am uali gebegeb uali? Dasmerare, uiaba am uali gebegeb am uali, bameri opole ra meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nalugelam uaba bakeuare dasmerare? Nako perofeta? Ageakar kaka uabi detagerare, E aule tumem perofeta. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Abelelam E pedali, mer detali abim, Dasmer, kaka namarid kara merkem mara opem, E paret mara gab mara opem. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ageakar kaka uabi detagered, Nole nerute le tekuei a esmelu kosker giz, aule tumem Ioane Bapataiso, epe abele le kebi kale abele kotor baselaia, E aule tumem abim. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ditimedlu Ioane Bapataiso ra kerker a bakedid peirdi, kotor ra baselaia gaire le etager, a uiaba saserim le etager ais. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Abelelam gaire perofeta giz mer detautarare, pako abele gelar giz bakedid Ioaneim. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ese uaba lagelag abi egared, a Elia pedali, E emeretalam naokaili ko tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Abele le grip nagri asoli, debele E asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nalu kara mer babisdarie abele nosik le? Mokakalam kebile giz, uiaba bamer abele zegur uteb ge, uiaba darabgerare uiaba kaimeg, ");
INSERT INTO ulk1902_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Kega, Keriba uabi burar diberi, a uaba nole ginar keribim; a keriba uabi ebazuer, a uaba nole ebazoli op detapili keribim. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Abelelam Ioane tabarki E nole eroli a nole eri, ege uiaba mer abim, E nagri demoni abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ege Le la Uerem ko tabarki E eroli a eri, ege uiaba mer abim, Dasmer, E au leuer lag, a au lagelag uaina eri, a telona ra kaimeg pako uit le giz! Epe nei atker abele pardale barkak tonar abara omasker. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ege E dauersili gaire uteb ikerare gaire abara adigir, abelelam uiaba nole obazgeda kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Korasina ae; kaka au nasenase marim! Betesaida ae; kaka au nasenase marim! abelelam, ese ikerare gaire adigir Turo a Sidonaim emeretlam, uiaba obazgeda abele zegerzeger uali pako abele bi. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Peike kaka uabi detagerare, Kebikebi Turo a Sidona abele gerger itimer uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mama Kaperenauma, ko agisilu bakedid kotor ge, a ma ko abi batauered muige abele seol; abelelam ese ikerare Sodomaem gaire adigir mari dog, E mena niai tekuei bakedid peirdi. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Peike kaka uabi detagerare, Kebikebi abele ged Sodoma abele gerger itimer marim. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Peike abele haua ge Iesu abi detager, kega, Kaka marim esoao, kara Baba ae, kotor Opole pako geseb ge, abelelam ma ispi gaire lu ike gaire pardale le giz pako umele le, a ma etomeret gaire lu ike uiabim gaire uerem giz: ");
INSERT INTO ulk1902_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Peike kara Baba ae, abelelam mara lag mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kara Aba kari nakuarare gaire lu uridili; nole le erdali abele Uerem, epe abele Aba; a nole le erdali abele Aba, epe Uerem tepteb, pako nerute le Uerem lagelag abi etomeret. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ua karim tabakeuare uaba au asiasi, a peper lu baguarare, a kaka uabi ikuar sagim kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uaba baguare kara lu bao, a pako uaba kari ereuerem; abelelam kakanali le gebgeb nerkep a mapodan: iaueakai uaba lamar nagri nerezili utebe ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Abelelam kara lu bao nole peper kak, a kara lu nole sagim kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Abele kerker, Iesu nakas kon gedub ge abele sabath; abara kaimeg giz uererege, uiaba tagpote ismi kon ra pote a uiaba eroli. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ege Faresaio giz uiabi erdali, a uiaba kega abim, Dasmer, mara kaimeg giz ikerare abele lu nole abkoreb sabath ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","E uiabim detagerare, Nako uaba nole etagare kak abele lu Dauida ikeli E uererege, pako gaire le abi kemem; ");
INSERT INTO ulk1902_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","E balu Ade ra meta a eroli areto didmerik opem, E nole abkoreb teroli, pako gaire le abi kemem, a tepteb gaire zogozogo le giz? ");
INSERT INTO ulk1902_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nako uaba nole etagare abele gelar ge, gaire sabath uridili zogozogo le datupid abele sabath muige abele zogo meta, a uiaba nole adud kak? ");
INSERT INTO ulk1902_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kaka uabi detagerare, Ike abele le aule tumem abele zogo meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ese uaba umele tonar abele mer, Kaka au lagelag abele nase, a nole abele zegur lu, uaba nole bodomalam le nole adud kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Abelelam Le la Uerem sabath Opole. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E bakeamulu abele utebelam, ege E balu uiaba sunago ge: ");
INSERT INTO ulk1902_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Dasmer, abele le abara tag euselu, epe uiaba abi itimer kega, Nako abkoreb le idigir sabath ge? iaueakai uiaba ko nagri mer ais abielam. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ege E uiabi detagerare, Nete le uabim, nagri netat mamoe, ese ekesmeri abele au uak sabath ge, nako E nole ko etaruk abele au uaklam? ");
INSERT INTO ulk1902_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nako le nole aule abele mamoe? Peike abkoreb debe tonar abele sabath ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","E abi detager abele le, Mara tag idrimurik. Epe abara tag idrimurik, a ko debele mokakalam nerute. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Faresaio giz baosi adige, uiaba mer atager abim ko abi ipit eumid. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ege Iesu erdali, epe bakeamulu adem abele uteblam; a gaire le lakub abi irmilare, E uiabi uridili idigir, ");
INSERT INTO ulk1902_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","E uiaba aukase detagerare nole abi atomeret kak: ");
INSERT INTO ulk1902_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iaueakai bakedida abele perofeta Isaia ra mer, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Dasmer, kara memeg le kaka dabgiri, kaka abi nase ge, a abim sererege kara nerkep; kaka abi ikuar kara Lamar abi tumge, E etomeret abele meratager uiabim gaire nogle giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","E nole asareda, E nole ereretikri, a nole nerute le asoli abara kodo mer abele gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","E nole narbeid abele mebud pakesa, E nole asameida abele uik kebikebi datki, a mena E upinati abele meratager ko saserim. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Abara nei ko abi oituli abele gaire nogle giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ege tais abim abele le demona balu muige, abele le E sadamer, a E ko te dabimdabim: E abi idigir, a mamor mer etkalu, a ko dasmer, abele le sadamer pako te dabimdabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ege gaire le lakub uridili abi damered, a uiaba mer, kega, Nako nole Dauida ra Uerem pedali? ");
INSERT INTO ulk1902_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gaire Faresaio giz aserare, a uiaba mer abielam, Ese nole Belezebul demona giz opole, umer kak abele le demona imud. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ege Iesu opasereret uiaba dikiaporare, E uiabi daratagerare, Gaire baselaia uridili ese kurabkurab a uekueku, nole niai tekuei, a sobkak eseamulu; a gaire uteb uridili, pako boai giz, ese kurabkurab a uekueku, nole niai tekuei. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ese Satana imuare Satana, ege abi kurabkurab, a uekueku abim; Nako niaiem tekuei abara baselaia? ");
INSERT INTO ulk1902_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ese kaka imuare demoni giz Belezebulelam, a nete imuare demoni uaba omasker giz? abele lu peike ikeli uiaba meratager uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ese Ade ra Lamarlam kaka imuare demoni giz, emetu bakedid uabim Ade ra baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nako umele nerute le balu abele saserim le la meta, a ko itkamer abara lu? mena kekiam didbare abele saserim le, epe itkamer abara lu abara meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Abele le nole kari lakak E nole kari kemem; Abele le nole etami kari dog, a ko debek. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Abele lu kaka uabi detagerare, Uit uridili pako adud mer, umele idigir lelam; ege abele le adud mer abele Lamar, umer kak le idigir. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ese le abi adud mer abele Le la Uerem, umele idigir, ege abele le abi adud mer abele Lamar zogo, umer kak idigir abele eded, pako niai eded. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Uaba nei atker abele debe lu, a ko debele abara turum; ese nole, uaba nei atker abele adud lu, a ko adud abara turum; abelelam turum atamelam gaire lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tabo ra omasker ae, uaba le au adud, nako uaba umele debe mer egali? Abelelam gaire lu le la nerkep ge, a ko te detaut. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gaire debe lu tais abele le debe tonar abara lu muige abara nerkep; ege abele le adud tonar ko tais gaire adud lu, abara adud lu muige abara nerkep. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kaka uabi detagerare, Gaire kebi mer uridili le detaut, uiaba etomeret abele gerger meratager. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Abelelam mara mer barkak mari desperet, a mara mer ko mari desauersili. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ege uader aotale le pako Faresaio giz, kega, Ereuer le, keriba lagelag ma detomertare nerute atamelam mabielam. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","E etkalu uiabim, kega, Abele nosik adud le pako eruam sus uiaba karim deraimer nerute atamelam; ege umer kaka uiabi dekuarare, a tepeteb Iona perofeta ra atamelam: ");
INSERT INTO ulk1902_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Abelelam mokakalam Iona muige abele au lar kem ge neis netat gerger ge, a neis netat ki ge; mokakalam Le la Uerem ko muige sep ge neis netat gerger ge, pako neis netat ki ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nineua le ko tekuei abele gerger meratager kemem abele nosik adud le pako eruam sus abkoreb; abelelam uiaba obazged Iona ra marau; dasmer, ike abele le aule tumem Iona. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kosker opole koki apek ko tekuei kemem abele nosik abele meratager; abelelam E tabarki abele bakedid geseb ge, a asoli Solomona ra pardale; dasmer, ike abele le aule tumem Solomona. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ese osmeda adige abele adud lamar lelam, E degemeli abele ni kak ged, a deraimer nerezi uteb, a nole erdali. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","E detager, kega, Kaka ko akomeda karabara meta, emeret kaka emeri; E bakeam a erdali nole le kak, a emetu paret dirup. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ege E bakeamulu, a taraisare uader sefen lamar au adud abi tumge, ege uiaba barot a bamer; ege au adud mop abele le, a kebi adud abara giz. Mokakalam ikeli abkoreb abele nosik le adud. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","E uiabi detaut abele le lakub, dasmer, ekuei adige abara apu, pako abara keimer giz, uiaba lagelag abi mer atager. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ege nerute le abi detager, Dasmer, ekuei adige mara apu, pako mara keimer giz, uiaba lagelag mari mer uanatager. ");
INSERT INTO ulk1902_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","E abi etkalu, kega, abele le abim detager, Nete kara apu? a nete kara keimer? ");
INSERT INTO ulk1902_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","E tabara tag idrimur tabara kaimeg giz, kega, Dasmer, kara apu, pako kara keimer giz! ");
INSERT INTO ulk1902_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Abelelam abele le ikeli kara Baba ra lag penoka kotor ge, E dali kara keimer, pako kara berbet, a kara apu. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Abele gerger Iesu esomelu abele metalam, a emeri seb ge, maike abele gur ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ege gaire le lakub netat gedim abim, abelelam E bakeam ekauerti abele nar, a emeri, a gaire le lakub uridili tekuei abele gur dege. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","E uiabim daratagerare gaire lu mer babisdarie, kega, Dasmer, nerute amorda le bakeamulu ko emor. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ege abara saido dikri, epe uader kep abi abele gab ge, ege gaire ebur giz epereda eroli. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Uader kep abi abele uteb neid ge, kebi sep nagri; ege dudum erperida, abelelam abele sep kebi kale; ");
INSERT INTO ulk1902_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","A lem eupumada eueri; a uatuet, abelelam nole sip kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Uader kep abi abele sumez lu daradara; a gaire sumez lu daradara omeida a detarapi. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Epe uader kep abi abele debe sep ge, epe turum nagri, uader handed, a uader sikesti, a uader therti. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Abele le grip nagri ko asoli, debele E asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ege abara kaimeg giz tabaruka abim, a abim kega, Nalugem ma uiabim detagereda no mer babisdarie? ");
INSERT INTO ulk1902_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ege E etkalu uiabim, kega, Uabi ikuar, iaueakai uaba umele gaire gumik lu abele kotor baselaia ge, a uiabi nole akuar kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Abelelam abele le nagri lu, a ko abim ikuar, ege abara gaire lu dordor; a abele le nole lu kak, a ais abielam abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Abele lu kaka uabi detagereda mer babisdarie; abelelam uiaba dasmer, a nole dasmer; a uiaba aserare, a nole aserare, pako uiaba nole akiapor kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ege bakedidlu uiabim Isaia ra mer daratagerare, kega, Uaba aserauem, a nole asoli, a uaba no dasmer, a nole erdali: ");
INSERT INTO ulk1902_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Abelelam gaire le la nerkep abele ged au dobodob, pako asor kak uiaba grip, a uiaba pone esameida; ege nole asmer kak uiaba pone, pako asor kak uiaba grip, iaueakai uiaba nerkep nole asor kak, a depegili uiaba, a kaka ko ikuar eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Uerkab uaba pone, abelelam uaba dasmerare, pako uaba grip, abelelam ua aserare. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Abelelam ageakar kaka uabi detagereda, kega, Gaire perofeta, pako le barkak tonar, uiaba au lagelag dasmerare gaire lu uaba erdali, a nole ardar kak; a uiaba ko lagelag aserare abele gaire lu ua aserare, a nole asor kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Dasmerare, ua aserauem abele tonar mer babisdarie abele le saido dikri. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ese le asoli abele baselaia ra mer, ese nole akiapor kak, ege adud le abim tabarki, a ais adem abele saido emetu dikri abi nerkep ge. Abele le pedali egared abele saido abele gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Epe abele le egared abele saido tumem neid ge, abele le E asoli abele mer, a sobkak egared pako sererege; ");
INSERT INTO ulk1902_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ege nole sip kak abim, a nole niaiem ekue; abelelam menaba asiasi a dedkoli abele merlam tabarki, E sobkak upiditilu a ekesmeri. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Abele le egared abele saido abele sumez lu daradar, abele le E asoli abele mer, epe abara nerkep okadeskedi gaire lu abele gesep ge, pako abele bes lu lag a edarabi abele mer, epe nole turum kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ege abele le egared abele saido debe seb ge, abele le E asoli abele mer, a erpei; a turum nagri, uader uan handed, a uader sikesti, a uader therti. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","E ko etomeret uiabim nerute mer babisdarie, kega, Kotor baselaia mokakalam nerute le debe saido dikri abi ged ge: ");
INSERT INTO ulk1902_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Le giz uteid, ege kurab le tabakeam, a dikri abele ditania muige abara saido, ege E bakeamulu adem. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Abele saido barperida, a turum nagri, ege erdalu abele ditania. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ege tarim le la boai, abara memeg le, tabarki, a abim kega, Opole ae, nako ma nole dikri abele debe saido mabi ged ge? Dasmer, nagelam abele ditania? ");
INSERT INTO ulk1902_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ege E uiabi daratagerare, Abele lu nerute le kari kurab ge ikeli. Ege abara memeg le abim detaut, kega, Nako ma lagelag keriba bakeuare ismi adem abele gaire lu? ");
INSERT INTO ulk1902_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","E daratagerare, Nole; mena uaba darubum okakis abele saido, ese uaba paret adem abele ditania. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dikaer, no ikedi, mena omeida neis lu bakedida abele nur ge a ismi; ese nur tabarki, kaka uiabi detaut, uader le ismi, Uaba kekiam etami abele ditania, pako uaba ko didbari gaire lager, a urim disirik; ege abele saido, ua etami a azirik kari saido meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","E uiabim etomeret nerute mer babisdarie, kega, Kotor baselaia mokakalam abele sinapi ra kep, a nerute le ais, a emor tabara ged ge: ");
INSERT INTO ulk1902_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kebi kale abele kep tumem gaire kep uridili; ese emetu omeida, E aule tumem gaire nur lu, mena keubu au kale, a gaire ebur giz epereda tabakeuare uteid abi tam ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","E uiabim daratagerare nerute mer babisdarie, kega, Kotor baselaia mokakalam abele lu ise, nerute kosker ais ikedilu muige abele falaua neis netat mitkar, a keubu dabueri uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ege Iesu de detaut abele gaire lu uridili mer babisdarie gaire le lakub; E uiabim detaut no mer babisdarie: ");
INSERT INTO ulk1902_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ueakai bakedid abele perofeta ra mer, kega, Kaka detaut no mer babisdarie, kaka uabi etomeret gaire gumik lu gizlam abele ditimedlu geseb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ege Iesu dikaer abele le lakub, a balu abele meta ge; ege abara kaimeg giz tabakeuare abim, kega, Ma keribi etomeret tonar abele mer babisdarie abele ditania abele ged ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ege E etkalu uiabim, kega, Abele le debe saido dikri, abele Le la Uerem; ");
INSERT INTO ulk1902_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ege abele ged abele geseb ge peike; abele debe saido, abele baselaia ra le; a abele ditania, adud le giz ra omasker; ");
INSERT INTO ulk1902_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Abele le kari kurab ge E dikri abele gaire lu, abele diabolo pedali; abele mur ge, abele geseb ge ra mop; abele ismi le, uiaba gaire angela giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Peike mokakalam ditania etami a urim disirik abele ur ge; mokakalam ikeli abkoreb abele geseb ge ra mop. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Le la Uerem namarkare abara angela uiaba taraisare muige abara baselaialam uiaba le asareda, pako uader le adud tonar; ");
INSERT INTO ulk1902_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A uiabi batauered muige abele urueri amei; nagri ebazuer, pako tereg ikupamaretlare. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ege uiaba barkak tonar au zorom, mokakalam lem, abele uiaba Aba ra baselaia ge. Abele le grip nagri ko asoli, debele E asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kotor baselaia mokakalam abele idolu ispi abele ged ge, a nerute le erdali, epe E ko ispi, a bakeam sererege, a terapei abara lu giz uridili, a abi bodomalam abele ged ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kotor baselaia mokakalam luge asesered le, E mamoro deraimer debe penina gaire lu bodomalam: ");
INSERT INTO ulk1902_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E erdali nerute debe penina au bodomalam, ege E bakeam terapei abara lu giz uridili, a abi bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kotor baselaia mokakalam abele net dikri batauered abele gur ge, a nagri gaire tonar lar uridili: ");
INSERT INTO ulk1902_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ege mitkar, a uiaba eguatumur abele tauer ge, a bamer, iterar debe lar a aretare epei ge, epe adud lar giz no batauered. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mokakalam mop abele geseb ge; angela giz bakeuare nakesmurare adud le giz, pako barkak le giz, ");
INSERT INTO ulk1902_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ege uiaba batauered uiabim adud le giz abele urueri amei; nagri ebazuer pako tereg ikupamaretlare. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ege Iesu uiabim daratagerare, kega, Nako uaba emetu asered abele gaire lu uridili? Uiaba abim detaut, Uao, Opole ae. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ege E uiabim daratagerare, kega, Dasmerare, aotale le uridili emetu ereuerem abele kotor baselaia, uiaba mokakalam tarim le la boai, E tais emeret lu pako kerkar lu tabara luga metalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ege Iesu bakedidlu gaire mer babisdarie, E bakeamulu adem abele uteblam. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","E bakeamulu a osmeda taba ged ge, E uiabi ereuerem uiaba sunago, a uiaba abi damared, a mer detagerare, kega, Abele la E nagelam abara pardale pako adigir? ");
INSERT INTO ulk1902_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nako nole tonar le abara uerem? nako nole nei Maria abara apu? abara kaimer giz Iakobo, a Iose, pako Simona, a Iuda? ");
INSERT INTO ulk1902_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nako nole meribi dog abara berbet uridili? a nagelam abele le nagri gaire lu uridili? ");
INSERT INTO ulk1902_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ege uiaba abim asered. Epe Iesu uiabim daratagerare, Nole nerute perofeta nole zorom kak, epe tepteb abara boai ge nole abi zorom kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Epe Iesu nole gaire adigir ikeli abele uteb ge, abelelam uiaba nole oatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Abele kerker Heroda opole asoli Iesu ra tonar, ");
INSERT INTO ulk1902_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","E uiabim detaut tabara memeg le, Ioane Bapataiso pedali, ko eded akaida eudelam, abelelam gaire adigir E ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Abelelam Heroda emetu erpei Ioane, a ko abi didbare, a abi aziriklu abele au dubare meta ge, epe Herodialam, Filipo ra kosker abi narbetelam. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Abelelam Ioane abi detaut, kega, Nole abkoreb ma abi ispi, a ko ekai mara kosker. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","E lagelag abi ipiti eumid, epe E geum gaire le lakub, uiaba dikiaporare E perofeta pedali. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ege abele gerger itutarare Heroda esemelu, Herodia ra neur ginar diger uiabi opem, E abi sererege Herodaim. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Abele lu E aukase abim detager, a mer nakesmulu, ko abim ikuar nerute lu E abi damos. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","E, abara apu abi namarida, a abi detaut, kega, Ma kari ikuar ike, abele Ioane Bapataiso ra kerem abele tanelu ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ege opole au asiasi, epe abele mer nakesmululam, pako gaire le eidi leuer eroare abi kemem, E mer tigri a abi ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","E abi namarid nerute le ismi Ioane ra kerem abele au dubare meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ege tais abara kerem abele tanelu ge, a abi ikuar abele neur; abele neur ko abi ikuar abara apu. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ege abara kaimeg giz abim tabakeurare, a ais abara gem a etkobei; a uiaba bakeuare Iesuim, a abi etomertare. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu abele asoli, E bakeamulu adem abele uteblam abele nar ge, E tepteb emeri abele lekak uteb ge: ege le lakub aserare, a uiaba abi irmilare tabakeuare tauer gab ge, gaire uteblam. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ege Iesu bakeamulu, a uiaba nardarare abele gaire le lakub, abara nase baruk uiabim, E idigir uiaba gim le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bakedilu abele kikem, ege abara kaimeg giz abim tabakeuare, kega, Abele uteb le kak iridi, a niai niai abele gerger; ma uiabi namarkare abele le lakub, iaueakai uiaba bakeuare gaire uteb, leuer terapei a uiaba erolare. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Epe Iesu uiabim detaut, Nole abkoreb uiaba bakeuare; ua naisuerare, leuer, a uiaba erolare. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ege uiaba abim detautare, Meriba nole leuer kak ike, epe no areto faif, a neis lar. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","E uiabim detaut, kega, Karim tais ike. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","E uiabim detaut abele gaire le lakub, Uaba eidi abele soge ge; E tais faif areto, pako neis lar, a edimrualu abele kotor, a esoao, a ko areto itur, a naisuerare tabara kaimeg giz, a abara kaimeg giz naisuerare abele le lakub. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ege uiaba eroare, a kem osomeda ui uridili, a ui aratare kaier, tuelf gaire epei mitkar. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Uiaba eroare, nako faif thausan no kimiar, a kosker pako kebile giz nole atager kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Epe Iesu de dudum namarkare tabara kaimeg giz a atiem abele nar ge, kekiam bakeuare nerute apekem; E mena namarkare abele le lakub bakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","E namarkare abele le lakub bakeuare, epe E tepteb ogi bakeamulu abele paser, a esorerapare. Bakedilu abele kikem, E tepteb abele uteb ge emrilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Abele nar muige abele karem ge, au zauber a nar agiri; abelelam uag opem uami. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ege Iesu bakeamulu uiabi erdali, abele neis a neis abele ki ge le asesered, E ekasereder abele zauber tum ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ege abara kaimeg giz ui abi erdalare, E ekasereder tumem abele zauber ge, ege uiaba okasosok, a uiaba dikiaporare, kega, Lamar pedali, ege uiaba au geum, a ko au sasemi. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ege Iesu de sobkak uiabi daratagerare, kega, Uaba nerkep au saserim, kakanali, nole geum kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Epe Peteru abim detaut, kega, Opole ae, ese mamanali, ma kari natager kaka bakeam marim tumem abele gur ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ege E abi detager, Ma tabakeam. Ege Peteru eupumalu abele narlam a ekasereder tumem abele gur ge, E bakeamulu Iesuim. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","E dasmer abele au uag, a E geum ge, epe ditimedlu a badimedlu, a ereretikri, kega, Abele Opole ae, ma kari uerkaben. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ege Iesu de tag itrimuriklu, a abi erpeilu, a abim kega, Mama le kebikebi oituli, nalugelam mama asared? ");
INSERT INTO ulk1902_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A uiaba neis le atiem abele nar ge, epe metalug, a nole uag kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ege uader le muige abele nar tabakeuare abim esorgiru, a mer kega, Ageukar mamanali Ade ra Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Uiaba akarida abele nerut apek, a bakedilu abele ged Genesareta. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gaire ged kemle uiaba abi erdali, a merkem namarkare abele pekem uridili, a uiaba taraisare abim gaire gim le giz uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Uiaba abi daramasare no kebikebi ituti uba ge abara am uali; a idigir uiaba gim uridili no kebikebi abi ituti. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ege aotale le pako Faresaio giz uiaba tabakeuare Iesuim Ierusalemlam, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Nalugem mara kaimeg giz datupida aule giz uiaba mer? abelelam uiaba leuer eroli a tag nole ogarup kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","E etkalu uiabim, kega, Nalugem ua ko datupida Ade ra gelar gaire aule ra mer? ");
INSERT INTO ulk1902_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Abelelam Ade detaut, kega, Ma mamoro asoli mabi abera a apuera; a, Nerute abele le adud mer abele baba pako abele apu, a ko ipit eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Epe uaba detagerare, kega, Ese le detaut abele aba pako abele apu, Ese nerute lu kari dog abkoreb marim, abele emetu Adim ikuar peike; ");
INSERT INTO ulk1902_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A nole ko asoli taba abera a apuera. Uaba dedkoli Ade ra gelar mokakalam, uaba emereta merlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Uaba bes le giz, abkoreb uabim abele Isaia ra mer epili, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Abele ged uiaba karim maiem uiaba telam, pako kari naospered uiaba mitelam; ege uiaba nerkep muriz ge karielam. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Uiaba no kari esorerapare, uiaba ikerare abele mizmiz le ra gelar. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ege E dabgerare abele gaire le lakub, E uiabim detaut, Ua aserare a mamor asoli: ");
INSERT INTO ulk1902_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Abele lu ikedilu le ra te nole le dedkoli; epe abele lu osmeda telam le dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ege abara kaimeg giz abim tabakeuare, a abim kega, Nako ma umele gaire Faresaio giz mari ueku, uiaba asarare abele mer? ");
INSERT INTO ulk1902_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","E etkalu, kega, Gaire lu uridili kara Aba penoka dali kotor ge nole amorda kak, E eiu adem. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","No dikaer uiabim: uiaba sadamer le ko datkimoardare sadamer le. Ese abele sadamer le datkimoardare nerute sadamer le, epe uiaba neis le ekesmiri abele au uak. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ege Peteru abim detaut, kega, Ma keribi etomeret abele mer babisdarie. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ege Iesu detager, Nako uaba mena nole asor kak? ");
INSERT INTO ulk1902_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nako uaba mena umer kak, gaire lu uridili ikedi abele te a ko irmi abele kem ge, ege imuda abele sumez ge? ");
INSERT INTO ulk1902_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ege gaire lu tabakeuare a osmeda abele telam, epe giz nerkeplam; abele lu le dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Abelelam nerkeplam tabakeam abele adud dikiapor, a le ipit eumilu, a kogem, a eruam, a bes mer, pako adud mer: ");
INSERT INTO ulk1902_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gaire lu peike le dedkoli; ege abele le leuer eroli a tag nole aruba kak, umer kak le dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ege Iesu bakeamulu adem abele utebelam, E osmeda abele ged Turo a Sidona. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dasmer, ababe Kanana kosker E tabarki abele peklam, a ereretikri abim, kega, Abele Opole ae, Dauida ra Uerem, ma kari omare, kara neur au adud abele demoni nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Epe E nole mer kak abim. Ege abara kaimeg giz abim tabakeuare abi damsare, kega, Ma abi namarid ege bakeamulu, abelelam E mena meribi irmili a ereretikri. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","E etkalu, kega, Ade nole kari namarida uader le, no mamoe Isaraela ra boai badimirida. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ege E tabakeam abim a etkobeilu, kega, Abele Opole ae, ma kari upinati. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ege E etkalu, kega, Nole abkoreb omasker ra leuer ko ais batauered omai giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","E abi detager, Abele Opole ae, ageakar marim: epe nerute omai giz eroare puipi leuer abi laulau ge uiaba tebude. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ege Iesu abim detager, kega, Kosker ae, mara oituli aule: mara lag mokakalam a ko ikeli abkoreb marim. Epe abara neur ko akaida abele haua ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu bakeamulu adem abele utebelam, E osmeda maike abele Galilaia keper ge; E ogi abele paserem, a emrilu seb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ege abim tabakeuare gaire le lakub, uiaba nagri uader le ibibi, a uader le sadamer, a uader le te dabimdabim, a uader le gebgeb, pako uader le gaire tonar gim, uiaba abi ituti Iesu ra teter ge; E uiabi nadgerare: ");
INSERT INTO ulk1902_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ege gaire le lakub abi damreda, abelelam uiaba abi erdarare uader le te dabimdabim a mer detaut, a uader le gebgeb ko kemerkemer, a uader le ibibi ko nakasir, a uader le sadamer ko darasmerare; ege uiaba abi despereda abele Isaraela Ade. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ege Iesu darabgerare abara kaimeg giz, kega, Kaka niabi nasenase abele le lakub, abelelam thri gerger peirdi uiaba emri kari dog, a nole leuer kak. Kaka umer kak uiabi namarkare ko bakeuare, a nole leuer aro kak, mena uiaba uererege abele gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ege abara kaimeg giz abi detagerare, Meriba nagelam gaire areto nagri abele sumez ge, iaueakai dordor le ra kem osmeda? ");
INSERT INTO ulk1902_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu uiaba daratgerare, kega, Nako naket areto uabi dog? Ege uiabi detager, Sefen; a uader kebi lar. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","E uiabi daratagerare abele gaire le lakub, Uaba baidi abele seb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","E etaruk sefen areto a uader lar, a esoao, a itur, epe abi naisuerare abara kaimeg giz, a abara kaimeg giz ko naisuerare dordor le lakub. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ege uiaba uridili eroare, a kem osmeda; a uiaba etaker abele leuer kaier, a mitkar sefen gaire epei. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Uiaba le eroarem foa thausan no kimiar, a kosker pako kebile giz nole atager kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","E uiabi namarkare abele le lakub bakeuare, E bakeamulu, a atiem abele nar ge. E bakeamulu abele ged Magadalena. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ege Faresaio giz pako Sadukaio giz abim tabakeuare, a uiaba abi mirem, kega, Ma keribi detomertare nerute atamelam kotorlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","E etkalu uiabim, kega, Mena kikem a uaba mer, kega, Debe lem barki: abelelam kotor ge au mam mam. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Abele kebi gereger a uaba mer ko, kega, Peirdi au irmir abele gereger: abelelam au mam mam dali, pako au kuba abele kotor ge. Uaba bes le giz, uaba umele etage kotor ra tonar, nako uaba nole umer kak urut atamelam? ");
INSERT INTO ulk1902_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Abele nosik le adud, pako kogem le giz, uaba karim deraimerare nerute atamelam; umer kak nerute atamelam uabi nakuarare, a tepteb Iona perofeta ra atamelam. E dikaerlu uiabim, a adem bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ege abara kaimeg giz tabarki abele nerute apek, a uiaba okataprik ko areto ais. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesu uiabim detager, Uaba au derarati adem abele Faresaio giz ra leuen, pako Sadukaio giz ra leuen. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ege uiaba mer atager, kega, Abara merlam, abelelam meriba nole areto tais. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Epe Iesu opasereret, E uiabim detager, Nalu uaba mer atager, uaba kebikebi oituli, abelelam uaba nole areto tais? ");
INSERT INTO ulk1902_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nako uaba mena asor kak, a uaba nole dikiapor faife areto, pako faife thausan le, naket epei arota? ");
INSERT INTO ulk1902_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A ko sefen areto, pako foa thausan le, naket epei arota? ");
INSERT INTO ulk1902_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nako uaba mena nole asor kak, nole abele areto kaka uabi detager? Epe ua au derarati adem abele Faresiao giz ra leuen, pako Sadukaio giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ege uiaba umele, nole areto ra leuen E uiabi detager au derarti adem, epe Faresaio giz ra giz mer, pako Sadukaio giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu bakeamulu abele Kaisaria Filipo ra nener, E itimerare abara kaimeg giz, kega, Nalu gaire le la mer, karim nete? ");
INSERT INTO ulk1902_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Uiaba abi detagerare, Uader le la mer, mama Ioane Bapataiso; a uader le, mama Elia; a uader le, Ieremia, pako nerute perofeta. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","E uiabim detager, Nako uaba, nalu uaba mer, karim nete? ");
INSERT INTO ulk1902_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ege Simona Peteru abi detaut, kega, Mama Keriso, Ade ra Uerem eded. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ege Iesu etkalu abim, kega, Mama uerkab Simona Ba‐Jona: abelelam nole le mari etomeret, epe kara Aba dali kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kaka mari detager, Mamanali Peteru, ka ko emoare kara ekalesia tumem abele neide ge; umer kak ur aseamur kak ra te abi tum ge ");
INSERT INTO ulk1902_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kaka keubu mari nakuar kotor baselaia ra ki; ese nerute lu ma didibari abele geseb ge, a ko didibari abele kotor ge; ese nerute lu ma detue abele geseb ge, a ko detue abele kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","E uiabi daraisumdarare abara kaimeg giz nole ko atomeret kak nerute le E Iesu Keriso dali. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Abele kerker Iesu ditimedlu ko natomertare abara kaimeg giz abkoreb E Ierusalemaem bakeamulu, ko gaire lu aiasi ikeli abim gaire aule giz pako zogozogo le giz pako aotale giz, uiaba abim ipitare eumida, E ko eded akaida thri gerger. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ege Peteru abi datkimalu, a abi daisumdalu, kega, Opole ae, muriz ge marielam abele lu, umer kak bakedida marim abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ege E egeremalu Peteruim, a abim, kega, Satana ae, ma bakeam kara sor ge: ma mokakalam lu kari bamsili; abelelam ma nole lakak Ade ra lu, epe mamor le la lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iesu uiabi detager abara kaimeg giz, Ese le lagelag kari narmili, nole abkoreb ko irmili tabara lag, debele E ko ais tabara satauro, a kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Abelelam ese le omare tabara eded, E abi: epe abele le dedkoli tabara eded karielam, E ko nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Abelelam nalu lu abkoreb, ese abele le nagri geseb ge uridili, a ko dedkoli abara eded? a nalu lu ikuar abele le ko bodomalam abara eded? ");
INSERT INTO ulk1902_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Abelelam Le la Uerem tabarki kemem pako abara angela taba Aba ra zorom ge; epe E bodomalam le giz abkoreb uiaba dorge. ");
INSERT INTO ulk1902_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ageakar kaka uabi detagereda, Uader le ike nole eud kak, mena dasmerare Le la Uerem ko tabarki abara baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Eseamud sikes gerger, ege Iesu tegardare Peteru, a Iakobo, a Ioane abara keimer, a uiaba bakeuare abele pereper paserem, uiaba tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","E depegili uiaba opem, abara op au zoromzorom mokakalam lem ise, abara am uali au kakekake mokakalam datki ise. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ko dasmer, Mose a Elia natomelu uiabim, a uiaba mer atager abim. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peteru abi detager Iesuim, kega, Opole ae, debele meriba emeri ike; ese ma lag, keriba ikeli ike nole niai meta thri; mara nerute, a Mose ra nerute, a Elia ra nerute ko. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dasmer, abele zoromzorom baz uiaba natkamda: ko dasmer, abele kodo mer bazelam, kega, Kara Uerem nase ge pedali, kaka abim sererege; uaba mamor abi asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Abara kaimeg giz aserare, ege uiaba etkobei, a uiaba au geum. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ege Iesu uiabi bakeamulu, E uiabi itut, a uiabi kega, Uaba tekue, uaba nole geum kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Uiaba pate uiaba pone, a nole nerute le erdali, epe Iesu tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Uiaba tabatueli abele paserlam, ege Iesu daraisumdarare uiabim, kega, Uaba nole atomeret kak nerute le abele lu uaba dasmerare, mena Le la Uerem ko eded akaida eudlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abara kaimeg giz abi itimerare, kega, Nalu aotale giz uiaba mer, kekiam Elia tabarki? ");
INSERT INTO ulk1902_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ege Iesu etkalu uiabim, kega, Elia kekiam tabarki, a ko ditimed gaire lu uridili: ");
INSERT INTO ulk1902_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A kaka uabi detager, Emetu Elia tabarki, a uiaba nole abi asmer kak, epe uiaba ikeli abim gaire lu uridili uiaba lagelag. Mokakalam Le la Uerem, a ko uiaba abi dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ege abara kaimeg giz uiaba opasereret E uiabi detager abele tonar Ioane Bapatiso. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Uiaba baosi abele lekub ge, ege nerute le kei tabakeam abim, E kokomamu abim, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Opole ae, ma abi omare kara uerem, E paim gim nagri au asiasi, abelelam gaire gerger ekesmiri abele ur ge, mokakalam gaire gerger abele ni ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kaka ais abim mara kaimeg giz, a uiaba umer kak abi idigir. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ege Iesu etkalu, kega, Abele nosik le nole oatur kak a barbar tonar, kaka uabi dog naket gerger? kaka uabi mena omare naket gerger? E karim tegaret. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu abi daisumdalu, ege adem esomelu adige abele demona abielam; epe abele uerem ko eded akaida, ditimedlu abele haua ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Iesu ra kaimeg giz abim tabakeuare, uiaba tepteb, kega, Nalugem keriba umer kak abi imuare? ");
INSERT INTO ulk1902_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ege Iesu uiabi detager, Abelelam uaba nole oatur kak: ageakar kaka uabi detager, Ese uaba oituli abkoreb abele sinapi ra turum, a uaba detagerare abele paser, Ma bakeam abele uteb ge; E umele bakeam; nole nerute lu ko obogai uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Epe tepteb abele esorerapare pako abele leuer baili umele adem bakeuare gaire lu mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Uiaba nakasir Galilaia ge, ege Iesu uiabi daratagerare, Abele Le la Uerem namarid gaire le la tag: ");
INSERT INTO ulk1902_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Uiaba ko abi ipit eumilu, a ko eded thri gerger. Ege uiaba au okasosok. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Uiaba baosi Kaperanaumaem, gaire le tabakeuare Peteruim, uiaba tameleb giz erpei abele zeku lu, a abim, kega, Nako uaba ereuer le nole ikeli zeku lu? ");
INSERT INTO ulk1902_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","E uiabi detager, E ikeli. E balu abele meta ge, epe kekiam Iesu abi detager, kega, Simona ae, nako ma dikiapor? Netede tameleb erpei telo pako zeku lu gesep opole? Nako uiaba omasker nako nogle? ");
INSERT INTO ulk1902_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ege Peteru abim detager, Gaire nogle. Epe Iesu abi detager, Peike omasker no emeri. ");
INSERT INTO ulk1902_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","A nerute uiaba mena mudi mer meribim, ma bakea mabele gur ge, a ma batauered nerute uk, abele kekiam lar ma nagri ma tetaruka; a ko diske abara te, epe ma erdali abele setatara; ma ais uiabim ikuar mara a kara ko. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Abele baua ge Iesu ra kaimeg giz abim tabakeuare, kega, Nete aule kotor baselaia ge? ");
INSERT INTO ulk1902_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ege Iesu dabgiri abele kebi uerem, a abi ekueilu uiaba opem, ");
INSERT INTO ulk1902_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","A uiaba kega, Ageakar kaka uabi detager, Ese uaba nole depegeli a ko mokakalam kebile ise, umer kak uaba bao abele kotor baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dasmer, ese le tababu gebgeb mokakalam abele kebi uerem ike, E aule kotor baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ese nerute lo egaret abele kebile mokakalam kara nei ge, E kari nagaret. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ese nerute le dedkoli nerute uiabim kebi kale kari oituli, debele abele le didibari etatimir au baker abara pereg, a gurim batimed au muimui karem ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Uaiai abele gesep ge gaire lu dedkoli! abelelam mena tabarki gaire lu dedkoli; epe uaiai abim le dedkoli tonar! ");
INSERT INTO ulk1902_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ese mara tag mari nadkoli pako mara teter, debele ma isimi adem batauered; debele ma bao abele eded mara tag kebikebi nako ibibi, au adud mari batauered abele ur asam kak neis tag a neis teter. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ese mara pone mari nadkoli, ma dekeamur adem batauered; debele ma bao abele eded a netat pone, au adud mari batauered abele ur genaim a neis pone. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Uaba nole dedkoli nerute uiaba ike kebi kale; abelelam kaka uabi detager, Uiaba angela dali kotor ge ner kak uiaba dasmered kara Aba ra op dali kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Abelelam Le la Uerem tabarki a uerkab abele le badimirid. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nako uaba dikiapor? ese le nagri handed mamoe, ese netat mamoe badimirid, nako nole dikaer paser ge nainete naine mamoe, a E bakeam deraimer abele netat mamoe badimirid? ");
INSERT INTO ulk1902_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ese E erdali, ageakar kaka uabi detager, E aukase sererege abele, a kebikebi abele nainete naine nole adimir kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mokakalam uaba Aba dali kotor ge, nole lakak nerute uiaba ike kebi kale ko abi. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ese mara le mari nadkoli, ma bakeam a abi baraditug uaba neis le tepteb: ese E mari asoli, ma emetu erpei mabara le. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ese nole mari asoli, ma bakeam tais nerute le nako neis le, iaueakai ageakarem neis le la mer, pako neis netat le. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ese E nole asoli uiaba neis le, ma abi etomeret abele ekalesia: ese E nole asoli abele ekalesia, ma abi dikiapor mokakalam kupikupi le, pako telona le. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ageakar kaka uabi daratagerare, Gaire lu uridili uaba didibare abele geseb ge, a ko didibare abele kotor ge: a gaire lu uridili ua ko detue abele geseb ge, a ko detue abele kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kaka uabi ko daratagerare, Ese uaba neis le abele geseb ge netate dikiapor nerute lu ko abi damsare kara Aba kotor ge, E ikeli abkoreb neis le la lag. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Abelelam abele uteb etami neis le pako neis netat le kara nei ge, kaka uiabi kemem. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ege Peteru abim tabakeam, kega, Opole ae, naket kerker kara le kari nadkoli, a kaka mena abi omare? nako sefen kerker? ");
INSERT INTO ulk1902_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ege Iesu abi detager, kega, Kaka nole mari detager, Sefen kerker; epe Sefente sefen. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Abele tonar kotor baselaia abkoreb nerute opole, E dikiapor deraimer tabara lu gaire abara memeg le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","E ditimed mer atager, E tegared nerute memeg le nagri abara talen ten thausan. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","E umer kak erdali lu abi bodomalam abkoreb; abara opole uiabi detager, Ais bodomalam abele le, pako abara kosker, a gaire abara omasker giz, pako abara lu uridili, iaueakai nagri lu kari bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ege abele memeg le abim etkobeilu a esorgilu, kega, Opole ae, ma mena kari omare, kaka keubu ko bodomalam mara lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ege abele Opole au nasenase tabara memeg le, E no namarid abara mani nole bodom kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Abele memeg le bakeam, E erdali nerute abara kaimeg memeg le E nagri abara handed denari; E abi erpei, a ko erpei abara pereg, a abim kega, Ma kari bodomalam kara lu mari dog. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ege abele kaimeg memeg le abim etkobei abara teter ge, a abi damos, kega, Ma kari omare, kaka keubu ko bodomalam mara lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Epe E umer kak, a ko bakeam abi taisili audubare meta ge, mena bodomalam gaire lu eseamud. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Uader abara kaimeg memeg le giz erdali gaire lu E ikeli, uiaba an uekueku, uiaba bakeuare, a natomertare uiaba opole gaire lu uridili E ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Abara opole abi dabgiri, a abim detager, kega, Abele adud memeg le ae, kaka mari omare, kaka no mari namarid nole bodom kak gaire kara lu mari dog: ");
INSERT INTO ulk1902_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nako ma nole omare kak mabara kaimeg memeg le, mokakalam kaka mari omare? ");
INSERT INTO ulk1902_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ege abara opole au uekueku, E abi namarid uader le abi dedkoed, mena eseamud bodomalam gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mokakalam kara Aba kotor ge E ikeli uabim abkoreb, ese uaba nole tababu omare uaba nerkep kemerkemer uaba le giz uabi dedkoeda. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ege Iesu eseamulu uader abara mer, ege E dikaelu Galilaia, a bosi Iudaia sep ge apek Ioridano. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gaire lekub abim irmilare; epe E uiaba nadgirare abele uteb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ege gaire Faresaio giz abim tabakeuare, a uiaba abi mirem, kega, Nako gelar nagri nerute le dituaki abara kosker a gaire luglam? ");
INSERT INTO ulk1902_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ege E uiabi etkalu, kega, Nako uaba nole etage, abele le detagem le gizlam, E ikeli neis le kimiar pako kosker, ");
INSERT INTO ulk1902_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","E uiabi detager, Abele lu kimiar dekaerti abara aba pako abara apu, a abara kosker ekpi; iaueakai neis le netat gem? ");
INSERT INTO ulk1902_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Peike nole ko neis le, epe neis le netat gem. Dasmer, uader le Ade daratkaprida, nole le atakeamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ege uiaba abim daratagerare, Nalugem Mose de mer tigri ko ikuar abele jauali kosker abi dituaki? ");
INSERT INTO ulk1902_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ege E uiabi detager, Ege uaba nerkepu au kelarkelar, abelelam Mose uabi ikuar ko dituaki uaba kosker; epe nole mokakalam gizlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kakanali uabi detager, kega, Ese le dituaki tabara kosker a nole ko kak, a ko ispi nerute kosker, E kogem; ese le ispi abele amuam kosker, E dali kogem. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ege abara kaimeg giz abim daratagerare, Ese tonar abkoreb kimiar a kosker, debele nole ispili kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","E uiabi detager, Umer kak gaire le uridili egaret abele mer, a uader le tepteb abkoreb ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Abelelam uader eunuka umele kebi ueremlam, a uader eunuka uiaba tababu eunukaem abele kotor baselaialam. Ese le umele egaret, debele E egaret. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ege egardare abim gaire kebile giz, iaueakai abara tag dikmerik uiaba tum ge, a esorerapare, ege abara kaimeg giz uiaba daraisumdarare. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ege Iesu uiabi detager, Nole aisumdar kak, karim tabakeuare: abelelam uiaba ike abkoreb mokakalam kotor baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E uiabi dikmerik abara tag, ege E adem bakeam abele utebelam. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dasmer, nerute le abim tabakeam, kega, Debe merkem ae, nalu debe lu kaka ikeli, iaueakai kaka nagri eded aseamur kak? ");
INSERT INTO ulk1902_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","E abim etkalu, Nalu ma kari babeid kaka debele? nole nerute le debele, epe Ade tepteb: ese ma lagelag eded, ma mamor asesered gaire gelar giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","E abim detaut, Nade? Ege Iesu abim etkalu, kega, Ma nole le ipiti eumilu, Ma nole eruam, Ma nole bes ageakarem, ");
INSERT INTO ulk1902_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ma mamor omare mabi abera a apuera; Ma ko abi omare abele le emeri mai kes, mokakalam ma omare marim. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ege abele makeriam abim detaut, Ka umele asesered gaire lu uridili kebi ueremlam; a nalu lu kaier kaka nole ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu abim detager, Ese ma lagelag debele kemerkemer, mara tonar ma bakeam a ko terapei gaire mara lu, ma uiabi nakuarare gaire lu kak le, iaueakai mara lu nagri kotor ge gaire debe lu giz, a ma tabakeam, kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ege abele makeriam asoli abele mer, E adem bakeam au okasosok; abelelam gaire abara lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iesu detager abara kaimeg giz, Ageakar kaka uabi detager, Au beber lu giz ra apu a bao kotor baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kaka uabi detager, Kamela umele bao abele nila neb ge, epe lu giz ra apu umer kak erdali Ade ra baselaia. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Abara kaimeg giz aserare, a uiaba aukase damred, a uiaba mer, kega, Ese mokakalam, nete le umele eded? ");
INSERT INTO ulk1902_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu uiabi dasmer, a uiabi detager, Le giz umer kak abele lu; epe Ade umele gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ege Peteru de abim detaut, kega, Dasmer, keriba dikaer gaire lu uridili, a keriba mari narmili; nalu keriba lu nagri? ");
INSERT INTO ulk1902_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ege Iesu uiaba detager, Ageakar kaka uabi detager, Uaba kari narmili, ese Le la Uerem egimuru taba opole bao ge a zorom ge, abele ko ditimedlu, a uaba ko bagiri opole bao ge tuelf, a mer atager Isaraela ra nosik tuelf. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ese nerute le dikaer meta, pako keimer giz, a berbet giz, pako aba, a apu, pako kosker, a omasker giz, a ged giz, kara neilam, E nagri dordor gaire lu mokakalam netate handed, a ko nagri eded aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","A gaire le kekiam, a ko keubu; a uader le keubu, a ko kekiam. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Abelelam kotor baselaia abkoreb nerute tarim le, kebi gerger E bakeam a mer atager uader le ikeli abara uina gedub, a ko uiabi bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","E uiabi detager uader le dorge ikerare netate gerger a netate denari, E uiabi namarkare abara uina gedub. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Abele thri haua ge, E bakeam a ko erdali uader le bako abele zekur uteb, a nole dorge kak; ");
INSERT INTO ulk1902_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","E uiabi detager, Ua ko bakeuare abele uina gedub, a kaka uabi daisuerare lu abkoreb. Ege uiaba ko bakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","E ko bakeam abele sikis haua ge, pako nain haua, E ko ikeli mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Abele ten haua, pako eleuen E ko bakeam, E ko erdali uader le bako a nole dorge kak; E uiabi detager, Nalugem uaba bako ike abele gerger kemerkemer, a nole dorge kak? ");
INSERT INTO ulk1902_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","A uiaba abi detagerare, Nole le keribi detager. E uiabi detager, Ua ko bakeuare abele uina gedub, a uaba nagri lu abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ege kikem tabarki, abele tarim le abara uina gedub E detager abara sirdam memeg le, Dabgerare gaire gedub le, ma uiaba nakuarare uiaba bodomalam, ditimedilu keubu le ge, a bakedilu kekiam le ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Uiaba tabakeuare uader le ditimedilu abele ten haua, pako eleuen haua ge, uiaba nagri netate denari. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ege kekiam le tabarkare, a uiaba dikiaporare uiaba lu aule nagri; a uiaba netate denari ko daragri. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Uiaba erdarare abele, uiaba mude mer darameare abele tarim le, ");
INSERT INTO ulk1902_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kega, Netate abele haua ge uiaba keubu le dorge, a ma abkoreb uiaba lu keriba lu, keriba au asiasi abele dorgelam, pako abele gereger au urueri. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","E detager abele nerute uiabielam a abi kega, Makanali, nole kara adud tonar marim; nako meriba nole mer atager abele netate denari? ");
INSERT INTO ulk1902_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma ekao mabara lu, ma bakeam; kara dikiapor peike kaka ko ikuar keubu le, mokakalam kaka mari ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nako kaka nole karbabu sirdam karbara lu? Nako ma kari op ausiausi kara nase marim? ");
INSERT INTO ulk1902_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mokakalam uader le kekiam a ko keubu, a uader keubu le a ko kekiam. Abelelam gaire le uridili aserare, a neis le mamor epei. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu ogi bakeam Ierusalemaem, E ais abara kaimeg giz tuelf le, abele gab ge uiaba tepteb, E uiabi kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Dasmer, meriba ogi Ierusalemaem; a ko namarid Le la Uerem abele au zogozogo le giz pako aotale giz; uiaba abi dedkoare a ko eumilu, ");
INSERT INTO ulk1902_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Uiaba abi namarid uiabim gaire nogle, iaueakai uiaba abi neg degarare, pako damerik, a ko abi satauroem: E ko eded akaida thri gerger. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ege abi tabaruk uiaba apu Zebedaio ra uerem okakis abara neis kimiar uerem, a abi etkobeilu, a damosdare nerute lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","E abim detager, kega, Nalu lu ma laglag? E abim detaut, Ma uiabi daratager neis kara uerem emeri mari dog, nerute le mara tuter pek, a nerute le mar ber pek, mara baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ege Iesu etkalu, a uiabi kega, Uaba umer kak abele lu ua kari namosi. Nako uaba umele ereli abele tanelu kaka are, a ko bapatiso abele kari bapatiso ge? A neis le abim kega, Keriba umele. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","E uiabi daratager, Uaba ereli kara tanelu, a ko bapataiso kara bapatiso; epe abele le emeri kara tuter pek, pako kara ber pek, nole kara dorge abi ikuar, a uader le kara Aba nakuarare abkoreb uiaba emetu derser. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Uiaba ten le aserare, uiaba nerkep au uekueku abele neis le. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ege Iesu uiaba dabgerare, E uiabim kega, Ua umele gaire nogle uiaba tarim le nagri E uiabi asesered, a uader aule uiabi tumge E uiabi sirdam. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Uaba nole mokakalam; ese le uaba lagelag aule, debele E uaba memeg le; ");
INSERT INTO ulk1902_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ese le uaba lagelag esaimer, E uaba sorge ekase; ");
INSERT INTO ulk1902_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mokakalam Le la Uerem nole tabarki memeg le taraisare, a E uiaba memeg le, a ko ikuar abara eded bodomalam gaire le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Uiaba osmed Ierikolam, gaire le lakub abi irmilare. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dasmer, neis le pone asadamer emrilei abele gab ge, a uiaba aserei Iesu tabakeam, uiaba ereretikri, kega, Opole ae, Dauida ra uerem, ma keribi omare. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ege gaire le lakub uiabi daraisumdarare: epe neis le au ereretikri, kega, Opole ae, Dauida ra uerem, ma keribi omare. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ege Iesu ekueilu, a darabgere neis le, E uiabi kega, Nalu lu uaba lagelag kaka uabim ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","A ui ge abi detagerei, Opole ae, keriba pone bakaerti. ");
INSERT INTO ulk1902_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ege Iesu au nasenase, a natutilu uiaba pone: ege sobkak ui ge pone bakaerti, a ui ge abi irmilei. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Uiaba maike Ierusalema, a bosi Bethefage, abele Oliua paser, ege Iesu namariklu neis tabara kaimeg giz, ");
INSERT INTO ulk1902_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A kega, Ua bakeamlam abele uteb uaba opem, ege uaba sobkak erdali abele asina didbarda, abara uerem okakis: a uaba uiaba detue, a karim tegared. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ese nerute le uabi nerute mer detager, a uaba abi detager, Opole lagelag; E sobkak uabi ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Epe gaire lu uridili ikerare, iaueakai bakedilu abele perofeta ra mer, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Uaba abi detagerare Siona ra neur uerem, Dasmer, mara Opole marim tabarki, E gebegeb tonar, E egimulu abele asina, a abara uerem ko. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ege neis abara kaimeg giz bekeamulei, a ko ikeli mokakalam Iesu uiabim mer tigri; ");
INSERT INTO ulk1902_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ui ge dagaretlei abele asina pako abara uerem, a uiaba am uali dikmerikare abi sor ge, a Iesu ko egimulu. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Abele gaire le lakub uiaba am uali esegarare abele gab ge, a uader le isemar lu tam, a esegarare abele gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abele gaire le lakub uader le kekiam pako uader le irmili, a uiaba ereretikri, kega, Hosana abele Dauida ra Uerem: Mapodan le tabarki Opole ra nei, Hosana gaire lu tumge. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","E bosi Ierusalema, abele uteb uridili boro, a mer kega, Nete le dali? ");
INSERT INTO ulk1902_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ege le lakub uiaba kega, Abele Iesu ike, Nazareta perofeta, Galilaialam. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu bao Ade ra zogo meta ge, E namuare uridili adige gaire le lu terarpeirare abele zogo meta ge, a erasigilu laulau uader le mani bodomalam, pako sik uader le dibadib bodomalam; ");
INSERT INTO ulk1902_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","E uiabim detager, Emetu detali, Kara meta nei atker esorerapare meta; a uaba ikerare mokakalam baker kur ge eruam le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ege abim tabakeuare abele zogo meta ge, uader le pone asamasam, pako uader le ibibi; E uiabi nadgirare. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gaire au zogozogo le giz pako aotale giz a uiaba erdali abara adigir E ikeli, a kebile giz ereretikri abele zogo meta, kega, Hosana abele Dauida ra Uerem; ege uiaba au uekueku, ");
INSERT INTO ulk1902_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ege uiaba abim kega, Nako ma asoli uiaba mer? Ege Iesu uiabi etkalu, Uao; nako uaba nole atager kak, Ma derser uedakiriare gaire sursur uerem giz uiaba telam, pako nano uerem giz? ");
INSERT INTO ulk1902_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","E uiabi dikaer, a bakeam abele uteblam Bethania tabarki, a emrilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Abele kebi gerger E iako takomeda abele utebim, E uererege. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","E dasmer nerute suke abele gab ge, E tabarki, a erdali a nole lu kak abi dog, no lam tepteb; E abim kega, Ma nole ko omeid mara turum niai karem. Epe abele suke sobkak uatuet. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Abara kaimeg giz uiaba erdali a uiaba abi damerare, a mer kega, Nako abele suke ike keserkeser ekeamud? ");
INSERT INTO ulk1902_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A Iesu uiabi detager, kega, Ageakar kaka uabi detager, Ese uaba oituli, a nole asared kak, uaba ko ikerare nole abele lu suke tepteb, epe ese uaba detagerare abele paser, Ma agisi ma ko bataueret abele gur ge, E umele bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gaire lu uridili uaba karim damosare abele esoreraparlam, a oaturlam nagri, uaba ko nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E balu abele zogo meta, a ereuerem, E abim tabakeuare au zogozogo le giz pako aule giz abele ged ge, a uiaba mer, kega, Nalu abele sirdam ma ikeli gaire lu? Nete le marim ikuar abele sirdam? ");
INSERT INTO ulk1902_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ege Iesu uiabim etkalu, kega, Kaka uabi itimer netat mer, ese uaba kari etomeret, a kaka ko uabi etomeret abele sirdam gaire lu kaka ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nako Ioane ra bapataiso nagelam? nako kotorlam, nako lelam? Ege uiaba mer atager, kega, Ese meriba daratager, kega, Kotorlam; ege E meribim detager, Nalugelam uaba nole oatur kak abim? ");
INSERT INTO ulk1902_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ese meriba abi detagerare, Lelam; meriba geum gaire le lakub; abelelam uiaba uridili dikiaporare Ioane E perofeta. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ege uiaba Iesuim etkalu, kega, Keriba umer kak. E uiabim detager, Kaka umer kak uabi etomeret abele sirdam kaka ikeli gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nako uaba dikiapor? Nerute le neis abara uerem; E bakeam abele narbet uerem, a abim kega, Makanali ma bakeam peirdi abele gerger kara uina gedub dorge ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ege E abim etkalu, kega, Kaka nole lakak; keubu ko obazgeda, E bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","E ko bakeam nerute uerem, a abara netat mer mokakalam, Ege E abim etkalu, kega, Opole ae, Kaka umele bakeam; epe no mer, a nole bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nete le neis uerem ikeli taba aba ra lag? Ege uiaba abim kega, Narbet uerem. Ege Iesu uiabim etkalu, Ageakar kaka uabi detager, Kekiam telona giz pako gab kosker giz abele Ade ra baselaia ge bardare, a uaba keubu. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Abelelam Ioane kekiam uabim tabarki barkak tonar ra gab, ege uaba nole abi oatur kak; ege gaire telona giz pako gab kosker giz abi egardare; a uaba umele erdali, a uaba nole keubu obazged, ueakai abim oituli. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Uaba aserare nerute mer babisdarie: Nerute tarim le, E ikeli tabara uina gedub, E kar dirumed, a daiui abele uteb uina detager, a ko ikeli au kar, E uiabim nakuarare gaire uina gedub le, E bakeam muriz gedim. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maike nur abi, E uiabim namarkare abara memeg le giz uiaba uina gedub le, ko taraisare gaire uina turum. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ege uiaba gaire uina gedub le erpeirare abara memeg le giz, uiaba damarka nerute, a ipit eumilu nerute, a nerute le uiaba baker erborare. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","E uader memeg le ko namarkare gaire le keubu, mokakalam a neis neis memeg le kekiam: a uiaba ko dedkolare uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Epe keubu E namarid tabara uerem uiabim, E dikiapor, kega, Uiaba geum kara uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","A gaire uina gedub le uiaba erdali abara uerem, ege uiaba mer atager, Abara kesem peike; tabakeuare meriba abi ipit eumilu, iaueakai meriba ais abara ged. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ege uiaba abi erpeirare a ko batauerd adige uina gedublam, epe uiaba abi ipitare eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dasmer, ese opole tabarki, E ged kem le, nalu lu ikeli uiabim gaire uina gedub le? ");
INSERT INTO ulk1902_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ege uiaba abi detagerare, E aukase narsare gaire le adud tonar, E ko nakuarare abele uina gedub uader le ko dorge ikerare, a uiaba abi ikuarare turum gaire urut. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu uiabi detager, Nako uaba nole etag abele jauali zogo, Abele baker gaire meta tonar le desauersili, a dikri, a mena ko ikeli kop tumge; abele lu Opole ikeli, meriba dasmerare, a abi damreda? ");
INSERT INTO ulk1902_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Abelelam kaka uabi detager, Ade ra baselaia ais adem uabielam, a ko nakuar nerute ged, ueakai tais abara turum. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ese le abi tumgeabele baker abara lidi erpei: epe abele le baker abi tumge, E mogmog a diskimir. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Au zogozogo le giz pako Faresaio giz aserare abara mer babisdarie, a uiaba opasereret uiabielam Iesu detager. ");
INSERT INTO ulk1902_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ege uiaba lagelag abi erpeirare, a uiaba geum lekublam, abelelam uiaba dikiaporare E perofeta dali. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ege Iesu ko etomeret uader mer babisdarie uiabim, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kotor baselaia abkoreb nerute opole, E derser leuer sererege tabara uerem, ");
INSERT INTO ulk1902_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","E namarkare tabara memeg le uiabim gaire le emetu aserare abele mer tigri, Ua tabakeuare leuer aroem; a uiaba nole lakak tabakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","E ko namarkare uader abara memeg le, a mer kega, Dasmer, kaka emetu derser gaire leuer; kara kau emetu ipitare, a gaire ebur debe kemkem narsare, kaka emetu derser gaire lu uridili, ua tabakeuare leuer aroem. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","A uiaba baokarid, a uiaba keubu bamarkare, nerute le tabara ged, a nerute le tabara lu bodomalam; ");
INSERT INTO ulk1902_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A uader le uiaba erpeirare abara memeg le, a uiaba dedkolare, pako ipit eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Abele opole asoli E au urker, E uiabi namarkare gaire tabara ares le, uiaba narsare gaire le dedkolare abara memeg le, a ko digeare uiaba uteb. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","E uiabim detager tabara memeg le, Emetu derser leuer, a nole abkoreb uiaba le emetu mer namarid. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dasmer, uaba bakeuare gaire au gab, a gaire le uridili uaba erdali, uaba etomeret abele leuer. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ege abara memeg le tabakeuare gaire au gab, a uiaba etami uader le, adud a uader le debele; abele leuer uteb mitkar lelam, uiaba eidi leuer eroare. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Abele opole tabalu abele meta, E uiabi dasmer uiaba eidi leuer eroare, E erdali nerute le nole nagri am uali abkoreb leuer aro am uali; ");
INSERT INTO ulk1902_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","E abim detaut, Makanali ae, nalugelam ma tabakeam badare abele meta, ma nole nagri abele leuer aro am uali? Ege E nole mer kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Abele opole abi detager tabara memeg le, Uaba didbare abara teter pako abara tag, abi ais batauered adige abele kupikup ge; nagri au ebazuer pako abele tereg ikupamaretlare. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Abelelam uader le no aserare, a neis neis le mamor irmilare. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ege Faresaio giz tabakeuare, a uiaba mer atager, Nalu lu meriba abi mirem abi merlam? ");
INSERT INTO ulk1902_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A uiaba namarkare abim uiaba kaimeg giz kemem pako Herodiano giz, abi kega, Ereuer le ae, keriba umele ma le ageakar, mama ereuerem Ade ra gab pako ageakar, ma nole geum nerute le: abelelam ma nole dikiapore nerute le. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dasmer, ma keribi etomeret, Nako ma dikiapor? Abkoreb ko ikuar Kaisaraim zegu lu, a nole? ");
INSERT INTO ulk1902_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iesu opasereret uiaba nerkep adud, a uiabi kega, Uaba bes le giz, nalugelam uaba kari mirem? ");
INSERT INTO ulk1902_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kari natomertare mani abele zegu lu. Ege uiaba abi ikuar nerute denari. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","E uiabi detager, Nete ra op abele, pako abele jauali? ");
INSERT INTO ulk1902_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A uiaba abi detagerare, Kaisara ra op. Ege E uiabi detager, Dasmer, Kaisara ra lu Kaisaraim ikuar; Ade ra lu Adim ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Uiaba aserare, epe uiaba au kase damereda, a uiaba abi dikaer, a adem bakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Peike abele kerker Sadukaio giz abim tabakeuare, uiaba dikiaporare nole le ko eded akaid eudelam: uiaba abi itimerare, ");
INSERT INTO ulk1902_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kega, Ereuer le ae, Mose keribi mer tigri, Ese eumilu nerute le, a nole uerem kak, abara keimer ko ispi abara kosker, iaueakai nagri kusi abi keimerlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Keribi dog emri sefen gaire uerem: a narbet uerem ispi abara kosker, E eumilu a nole uerem kak, abara keimer ko ispi abara kosker: ");
INSERT INTO ulk1902_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mokakalam nerute keimer, mena bakedida sefen le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Abele kosker keubu eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dasmer, ese keubu gerger tabarki, nete le uiabielam ais abele kosker? abelelam uiaba kosker uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ege Iesu etkalu uiabim, kega, Uaba didmirik, abelelam uaba asmer kak abele jauali zogo, pako Ade ra adigir. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Abelelam keubu gerger tabarki uiaba ko eded akaida eudlam, nole kosker aspili kak, a nole kimiar aspili kak, uiaba mokakalam Ade ra angela giz kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Abele ko eded akaida eudlam, nako uaba nole atager kak Ade ra mer uabim, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kaka Aberahama ra Ade, a Isaaka ra Ade, a Iakobo ra Ade? Abele Ade nole eud le giz ra Ade, epe mamor eded le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gaire lekub aserare, ege uiaba abi damreda abara giz merlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Gaire Faresaio giz aserare Sadukaio le nole abi mer kak, ege uiaba etamiare abele uteb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ege nerute uiaba gelar ereuer le, abi itimer mirem kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ereuer le ae, na gelar aule? ");
INSERT INTO ulk1902_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ege Iesu abi etkalu, Ma abi omare abele Opole mara Ade mara nerkep kemerkemer, a mara lamar kemerkemer, a mara akiapor kemerkemer. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Abele gelar kekiam, pako aule. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mokakalam abara neisem, Ma abi omare abele le emri mai kesi, mokakalam ma omare mabu. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Peike neis gelar giz abele gelar uridili, pako abele gaire perofeta giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Faresaio giz netate gedim, ege Iesu de uiabi nautumerare, ");
INSERT INTO ulk1902_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Kega, Nako uaba dikiaporare abele Keriso? nete ra uerem? Ege uiabi abi detagerare, Dauida ra Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","E uiabi detager, Dasmer, Nako Dauida nei atker Lamarlam, E abara Opole, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Abele Opele abi detager kara Opole, Ma emri kara tuter tag, mena kaka ikeli uader le marim kurabkurab mokakalam lu detager mara teter? ");
INSERT INTO ulk1902_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dasmer, ese Dauida E nei atker Opole, a nalugelam E ko nei atker abara uerem? ");
INSERT INTO ulk1902_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ege nole nerute le umele abim etkalu, a ditimedlu abele gerger nole nerute le ko saserim itimer abim nerute lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ege Iesu detager gaire le lakub, pako abara kaimeg giz, ");
INSERT INTO ulk1902_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kega, Aotale giz pako Faresaio giz bakiri Mose ra bas. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Peike uaba mamor asarare a uaba ikerare lu uridili uiaba daratagerare, mamor asarare: epe uaba nole ereuerem uiaba tonar giz; abelelam uiaba no mer detaut, a umer kak ikerare abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Abelelam uiaba didbare au lu beber uiaba dikemerik le giz uiaba tabo ge; ege uiaba umer kak uiaba kebi kei etadmir. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Gaire uiaba dorge uridili ikerare, iaueakai le giz uiabi darasmerare: uiaba ikerare au filakteri, pako ko au sisero uiaba am uali, ");
INSERT INTO ulk1902_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Uiaba au sererege eidi abele aule ra uteb leuer ero, pako aule ra bao sunago ge, ");
INSERT INTO ulk1902_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pako gaire le uiabi nasege segur uteb ge, a gaire le giz uiaba nei natkerauem, Rabi ae, Rabi ae. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ege uaba nole nei atker Rabi; abelelam netate uaba Ereuer le, abele Keriso idali, a uaba uridili keimer giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Uaba nole nerute le geseb ge nei atker uaba aba; abelelam netate uaba Baba, penoka dali kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Uaba nole nei atker ereuer le, abelelam netate uaba Ereuer le, Keriso idali. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Epe abele le aule uabim, E uabim memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ese nerute le tababu babei E aule, E ekekeli; Ese nerute le E tababu gebgeb, E bataili uiabim tumge uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Uaiai uaba aotale pako Faresaio, bes le giz! abelelam uaba dimi abele kotor baselaia lelam; abelelam uaba umer kak barot, a uaba ko daraisumdarare uader le barota. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Uaiai uaba aotale pako Faresaio, bes le giz! abelelam uaba ais eseamulu mai kosker uiaba meta, a uaba esorerapare au pereper ikerare ispilu; abele lulam Ade ra urker aule uabi tumge. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Uaiai uaba aotale pako Faresaio, bes le giz! abelelam uaba deraueili gur ge pako sep ge iaueakai uaba nagri nerute le uaba esorerapare; ese uaba erpei, a uaba ikerare Gena ra le E au adud uabielam. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Uaiai uaba datkimuar sadamer le, a uaba mer, Ese le iskosi abele zogo meta nolea kar, epe le iskosi abele zogo meta ra golo, niaiem peike! ");
INSERT INTO ulk1902_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Le giz paim ae, pako sadamer; abelelam nade aule, nako abele golo, pako abele zogo meta zogoem abele golo? ");
INSERT INTO ulk1902_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A nerute, Ese le iskosi abele zegu lu bao, nolea kar; epe abele iskosi abele zegu lu abi tumge, niaiem peike. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Le giz paim ae, pako sadamer; abelelam nade lu aule, nako zegu lu, nako bao ge zogoem abele zegu lu? ");
INSERT INTO ulk1902_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dasmer, abele le iskosi abele bao zegu lu, E iskosi gaire lu uridili abi tumge. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Abele le iskosi abele zogo meta, E abi iskosi, pako le emeri muige abele zogo meta. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Abele le iskosi abele kotor ge, E iskosi Ade ra bao, pako le abi dog egimulu. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Uaiai uaba aotale pako Faresaio, bes le giz! uaba ikuar kebi lu abele mili pako abele aneto pako abele kumina, a gaire au lu uaba ispilu abele gelarlam, abele barkak tonar, pako abele omare, pako abele oituli: abkoreb ikelare lu ike, a nole dikaer lu peike. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Uaba datkimuar sadamer le, uaba dirimid abele lag, a mamor irusere kemerkemer abele kamela. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Uaiai uaba aotale pako Faresaio, bes le giz! uaba dirup abele tanelu ge ra sor pako abele kumeti, epe muige mitkar lu itike pako abele adud tonar giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mama le Faresaio sadamer, mama kekiam dirup muige abele tanelu ge pako abele kumeti, iaueakai ogo kak kemerkemer abele sor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Uaiai uaba aotale pako Faresaio, bes le giz! abelelam uaba mokakalam ao giz, adige au kakekake, debele le dasmer, epe muige mitkar eud le la lid, pako gaire adud lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mokakalam uaba, adige mokakalam barkak tonar le ise gaire le ra opem, epe muige uaba au mitkar abele bes mer pako abele tonar barbar. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Uaiai uaba aotale pako Faresaio, bes le giz! abelelam uaba emoare gaire perofeta uiaba ao, a ko deiriem uiaba ao le barkak tonar giz, ");
INSERT INTO ulk1902_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A uaba mer kega, Ese keriba abi dog emri abele kerker keriba aba giz emeret, umer kak keriba okakis uiaba narsare perofeta giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Peike abele mer uabu etomeret uabim, uaba omasker gaire le giz narsare gaire perofeta giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","A uaba ko mitkar abele tonar lu uaba aba giz lam. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ege uaba tabo, tabo areg ra omasker giz, nako uaba derar abele urker Genaim? ");
INSERT INTO ulk1902_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dasmer abele lu, kaka uabi namarida perofeta giz, pako pardali le giz, pako aotale le giz; uader le uaba narsare, pako satauroem; a uader le uaba damarika uaba sunago, pako deraimerare nerute uteb a nerute uteb; ");
INSERT INTO ulk1902_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iaueakai bakedida uabi dog gaire le giz barkak tonar uiaba mam uabielam emetu epaitered abele geseb ge, ditimedelu Abela ra mam, le barkak tonar, a bakedilu Zakaria ra mam, abele Barakaio ra uerem, uaba ipiti eumid abele kesi zogo meta pako zegu lu bao ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ageakar kaka uabi detager, Gaire lu uridili tabarki tumem abele nosik. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ierusalema ae, Ierusalema ae, le ipitare gaire perofeta giz, pako baker erboro le giz emetu namarid marim! kaka au lagelag etami mara omasker giz, mokakalam faul akuadare abara omasker muige abara peo, epe uaba nole la kak! ");
INSERT INTO ulk1902_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dasmer, uaba meta dikaertare a ko pisoger nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Abelelam kaka uabi detager, Uaba umer kak kari dasmer, mena keubu uaba kari daratagerare, Uerkab le tabarki Opole ra nei. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ege Iesu osmelu adem abele zogo metalam, epe abara kaimeg giz abim tabakeuare, a abi etomeret uader gaire meta giz abele zogo meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A Iesu uiabi detager, Nako uaba nole asmer kak gaire lu uridili? Ageakar kaka uabi detager, Nole nerute baker igi tumem nerute baker, iako uababuare ueseamulu. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","E emri abele Oliua paser, ege abara kaimeg giz abim tabakeuare uiaba tepteb, a uiaba kega, Ma keribi detagerare, Na kerker tabarki abele gaire lu? a nalu atamelam ma tabarki, pako abele geseb ra mop? ");
INSERT INTO ulk1902_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ege Iesu etkalu uiabim kega, Mamoro nole nerute le uabi didmirik. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Abelelam gaire le tabarki kara nei ge, kega, Kakanali abele Keriso; uiaba ko didmirik gaire le. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Uaba aserare abele barseda, pako ares ra mer; uaba nole okasosok, abelelam abkoreb bakedida peike gaire lu uridili, a nole tabarki abele mop ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Abelelam nerute ged bakeuare barseda nerute ged, pako nerute baselaia a nerute baselaia, iaueakai memeig tabarki pako gim gim a demali nerute uteb a nerute uteb. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Peike gaire lu uridili abele ditimeda gaire lu asiasi. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ege uiaba uabi namarkare abele asiasi, pako uiaba uabi deres eumida; a gaire ged uridili uabi derar kara neilam. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Abele kerker gaire le asareda, nerute le mirem nerute le, a uiaba ueku uek. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A gaire perofeta bes tabarki, a uiaba didmirik gaire le. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gaire le la nerkep gebgeb, abelelam au kale omeid abele adud tonar. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Epe abele le niaiem tekue mena bakedida mop ge, E ko eded. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A ko etomeret debe baselaia ra mer gaire ged narid, ko ikeli ageakarem gaire ged narid; iaueakai bakedilu abele mop ge tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ese uaba erdali abele derar lu a dedkolare, mokakalam Daniela perofeta detaut, E tekue abele zogo uteb (le etage mamor dikiapor:) ");
INSERT INTO ulk1902_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Uaba Iudaia le abele kerker, uaba derar gaire paser: ");
INSERT INTO ulk1902_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Abele le meta tumge nole ko tabu bao ais nerute lu tabara metalam: ");
INSERT INTO ulk1902_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Abele le sumez ge nole ko akomeda tabara am uali ais. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Uaiai gaire kosker kem kem pako kosker uerem uerem abele kerker! ");
INSERT INTO ulk1902_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Uaba esorerapare iaueakai uaba nole derar abele zeru urut, pako abele sabath ge: ");
INSERT INTO ulk1902_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Abelelam abele kerker bakedida au asiasi, nole abkoreb ditimeda gaire lu detagem abele geseb ge bakedida, peirdi nole mokakalam keubu gerger. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ese nole teupai abele kerker, umer kak nerute le eded: epe sobkak eseamud abele kerker uiabielam emetu depegemerdare. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ese nerute le uabi detager abele kerker, Dasmer, Keriso ike, pako pedali; uaba nole abi asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Abelelam gaire Keriso bes tabarki, pako perofeta bes, uiaba ikerare gaire au atamelam pako adigir; iaueakai didmirik uader le emetu depegemelu, ese umele. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dasmer, kaka kekiam uabi detomerta. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Iaueakai ese uiaba uabi detager, Dasmer, E penoka sumez ge; uaba nole bakeuare abim: Dasmer, E muige uteb ge, uaba nole uiabi asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Abelelam mokakalam perper bilba abele naiger pek, a ko datki abele ziai pekem; mokakalam Le la Uerem ko tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Abelelam abele uteb nagri eud le, gaire aeto abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ese emetu eseamud abele asiasi abele kerker, ege abele lem au kupikup nole be kak, abele meb nole meb gerib kak, a uer giz nabuda abele kotorlam, kotor ge demali gaire ares lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ege erdali abele kotor ge abele atamelam Le la Uerem: a gaire nosik le abele geseb ge au ebazuer, a uiaba erdali Le la Uerem tabarki gaire baz abele kotor ge, pako abele adigir a au zorom zorom. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","E namarkare tabara angela giz pako abele maber au bumer, a uiaba taraisare foa uag peklam uader le emetu depegemelu, ditimeda kotor paikai a bakedilu nerute paikai. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Uaba dikiaporare abele mer babisdarie abele suke; Ese kerkar omeida abara girikupi tam, pako au lamalam; uaba umele urueri urut maike: ");
INSERT INTO ulk1902_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mokakalam uaba, ese uaba erdali gaire lu uridili, uaba umele E maike abele gab te ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ageakar kaka uabi detager, Nole eseamud abele nosik, mena bakedilu gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Eseamulu abele kotor ge, pako abele geseb ge, epe kara mer giz nole aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ege abele kerker pako abele haua ge nole le asmer kak, a angela giz kotor ge nole umer kak, ege kara Aba tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mokakalam Noa ra kerker, abkoreb Le la Uerem ko tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Abelelam mokakalam abele kerker mega ogiri nole tabarki, uiaba eroli a ereli, a uiaba kosker ispida pako namarid, bakedilu abele kerker Noa balu abele tabara nar ge, ");
INSERT INTO ulk1902_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A uiaba umer kak abele mega ogiri tabarki, a uiaba uridili ais adem eseamulu; mokakalam Le la Uerem ko tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Abele kerker neis le emri sumez ge; nerute le ais, a nerute le ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Neis kosker edatimiri abele uteb saito edatimiri; nerute kosker ais, a nerute kosker ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Peike, uaba nole ute kak, abelelam uaba umer kak na haua ge uaba Opole tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Uaba dasmer abele lu, ese tarim le ra boai umele abele haua ge eruam le tabakeam abele ki ge, E umele asesered, E nole dikaer tabara meta ko daiui. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Abele lu uaba mamor derser; abelelam abele haua ge uaba nole akiapor kak, Le la Uerem tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nete abele ageakar memeg le pako debe akiapor, abara opole E ikosi a sirdam gaire memeg le, E uiabi ikuar uiaba leuer gaire haua abkoreb? ");
INSERT INTO ulk1902_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Uerkab abele memeg le, ese abara opole tabarki, a abi erdali mena ikeli abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ageakar kaka uabi detager, E abi ikosi ko sirdam abara gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ese abele adud memeg le E tababu detager tabara nerkepu, Kara opole uapum tabakeam; ");
INSERT INTO ulk1902_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","E ipit tabara kaimeg memeg le, a ko eroare pako ereli okakise uader le turtur ereli; ");
INSERT INTO ulk1902_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Abele memeg le ra opole tabarki abele gerger nole asesere kak, pako abele haua E nole asmer kak, ");
INSERT INTO ulk1902_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","E au bodomalam ikuar abim, a ko abi ikuar abara uteb kemem gaire bes le giz; nagri au ebazuer pako tereg ikupamaretlare. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Abele kerker kotor baselaia abkoreb ten gaire neur, uiaba ais uiaba lamepa, a uiaba bakeuare obapit abele le kerkar kosker ispid. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","A uiaba faif neur pardali nagri, a faif neur paim paim nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Uader neur paim paim, no lamepa ais, a nole ide kak; ");
INSERT INTO ulk1902_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Epe uader neur pardali, uiaba tarpor ide ais kemem lamepa. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ege au uapum tabarki abele le kerkar kosker ispili, epe uiaba uridili uteid uaepiti a ko uteid. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Eipu ki ge tabarki abele le ereretikri tabarki, Dasmer, abele le kerkar kosker ispili tabakeam, uaba bakeuare abi obapit. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ege neur uridili bako, a derser uiaba lamepa. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ege paim paim neur uiaba uiabi daratagerare pardali neur, Uaba keribi ikuar ide; abelelam keriba lamepa maike asameida. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Epe pardali neur uiabi etkalu, kega, Nole abkoreb keribim pako uabim; debele uaba bakeuare uader le lu terapei, ua ko bodomalam uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Uiaba bakeuare ko bodomalam, epe abele le kerkar kosker ispili tabakeam; uiaba le emetu derser uiaba barota kemem okakis abim abele leuer sererege; ege abele te dimilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Keubu uader neur ko tabakeuare, a uiaba kega, Opole ae, Opole ae, ma diski abele te keribim. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","E uiabi etkalu, kega, Ageakar kaka uabi detager, kaka nole asmer kak uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Peike, uaba nole ute kak, abelelam uaba umer kak abele gerger pako abele haua ge Le la Uerem tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mokakalam nerute le muriz ge bakeam, E darabgerare tabara memeg le giz, E uabi ikuar abara gaire lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","E ikuar nerute le faif talen, a nerute le neis, a nerute le netat, abkoreb abele gaire lu le umele; epe E bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Abele le faif talen E bakeam ko terapei, E ko nagri uader faif talen. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mokakalam abele le nagri neis talen, E ko nagri uader neis talen. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Epe abele le nagri netat talen E bakeam a daiui abele seb, a ko ispilu abara opole ra mani. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Gaire ki ge eseamulu abele memeg le ra opole tabarki, a uiaba mer atager abi luglam. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Abele le nagri faif talen E tabakeam a ko tais uader faif talen, a abi kega, Opole ae, ma kari ikuar faif talen; dasmer, kaka ko nagri uader faif talen. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Abara opole abi detager, Au debele abele debe megmeg le ae, pako ageakar; ma ageakar abele uader kebi lu, kaka mari ikosi ko sirdam gaire au lu; ma tabakeam balu abele mara opole ra sererege. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Abele le nagri neis talen E tabakeam a abi detager, kega, Opole ae, ma kari ikuar neis talen; dasmer, kaka nagri uader neis talen. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ege abara opole abi detager, Au debele abele debe memeg le ae, pako ageakar; ma ageakar uader kebi lu, kaka mari ikosi ko sirdam gaire au lu; ma tabakeam balu abele mara opole ra sererege. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Abele le nagri netat talen E tabakeam a abi detager, kega, Opole ae, kaka erdali mama au peper tonar le, ma ismi abele uteb ma nolea saito tigri, ma ko etami lu abele uteb ma nole depegelu: ");
INSERT INTO ulk1902_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Epe kaka au geum, a kaka bakeam ko ispilu mara talen abele seb ge; dasmer, mara lu ike. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Abara opole abi etkalu, kega, Adud memeg le ae, pako au gebgeb, ma umele kaka ismi abele uteb kaka nole saito tigri, a kaka ko etami lu abele uteb kaka nole depegelu: ");
INSERT INTO ulk1902_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Peike abkoreb, ese ma ikuar kara mani uader le mani terapei, iaueakai kaka tabakeam ko nagri kara lu pako abara bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dasmer, uaba tais abele talen abielam, a ko ikuar abele le nagri ten gaire talen. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Abelelam, ese le nagri lu, a ko ikuar abim lu, iaueakai au gaire lu abi dog: epe ese le nolea lu kak, debele ais adem abielam abele lu E nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Uaba imud abele memeg le nole abkoreb, abele kupikupi adige, nagri au ebazuer pako tereg ikupamaretlare. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ese Le la Uerem tabarki tabara zorom, pako zogo angela giz uridili kemem abi dog, epe E egimuru tabara bao zorom ge: ");
INSERT INTO ulk1902_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Etami abara opem gaire ged narida uridili; E nakesmulu uiabim, mokakalam le asesered mamoe, E nakesmulu nani, pako mamoe; ");
INSERT INTO ulk1902_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ege ikedi mamoe abara tuter tag, a nani abara ber tag. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Abele Opole uiabi detager uader le abara tuter tag, Uaba tabakeuare uaba emetu kara Aba uabi ikuar debe mer, uaba uteb abele baselaia, emetu derser uabim a nole detagem abele geseb ge: ");
INSERT INTO ulk1902_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Abelelam kaka uererge, a uaba kari ikuar leuer kaka eroli; a kaka niap, a uaba kari ikuar ni kaka aree; a kaka supe le, a uaba kari egared: ");
INSERT INTO ulk1902_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kaka nole nesur kak, a uaba kari ikuar am uali; a kaka gimgim, a uaba kari dasmer; kaka emeri abele audubare meta, a uaba tabakeuare kari dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Barkak tonar le giz uiaba etkalu, kega, Opole ae, na gerger keriba erdali ma uererege, a keriba mari asisiem? pako niap, a keriba mari ikuar ni ma ereri? ");
INSERT INTO ulk1902_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na gerger keriba mari erdali ma supe le, a keriba mari egared? pako nole nesur kak, a keriba mari ikuar am uali? ");
INSERT INTO ulk1902_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na gerger keriba mari erdali ma gimgim, pako ma emeri abele audubare meta ge, a keriba bakeuare mari dasmerare? ");
INSERT INTO ulk1902_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ege Opole uiabi etkalu, kega, Ageakar kaka uabi detager, Abelelam uaba ikerare nerute le kebi kale kara keimer ike, kakanali uaba ikerare. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","E uiabi detager uader le abara ber tag, Uaba le adud tonar, bakeuare adem karielam, abele ur niai karem, emetu derser abkoreb abele diabolo pako tabara angela giz: ");
INSERT INTO ulk1902_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Abelelam kaka uererege, a uaba nole kari ikuar leuer; a kaka niap, a uaba nole kari ikuar ni kaka aree: ");
INSERT INTO ulk1902_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kaka sup le, a uaba nole kari egared; kaka nole nesur kak, a uaba nole kari ikuar am uali; kaka gimgim, kaka emeri abele audubare meta, uaba nole kari dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ege uiaba etkalu abim, kega, Opole ae, na gerger keriba mari erdali ma uererege, pako niap, pako supe le, pako nesur kak, pako gimgim, pako emeri abele audubare meta, a keriba nole mari memege le? ");
INSERT INTO ulk1902_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","E uiabim etkalu, kega, Ageakar kaka uabi daratagerare, Abelelam uaba nole ikerare nerute le kebi kale uiaba ike, epe kakanali uaba nole ikerare. ");
INSERT INTO ulk1902_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ege uiaba bakeuare peike abele asias niai karem: epe barkak tonar le giz ko bakeuare abele eded niai karem. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu eseamulu abara mer uridili, E uiabi detager tabara kaimeg giz, ");
INSERT INTO ulk1902_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Uaba umele, eseamud neis gereger abele paseka ikeli, a Le la Uerem namarid ko satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Abele kerker etami gaire zogozogo le giz, pako aotale giz, pako aule giz abgedlam abele zogo le ra meta ge, abara nei Kaiafa; ");
INSERT INTO ulk1902_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","A uiaba mer atager nalu lu umele mirem erpei, pako ipitare eumilu Iesu. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","A uiaba kega, Nole ikeli abele uetpur, iaueakai abele ged ataperetlam. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu emri Bethania, Simona lepera ra meta, ");
INSERT INTO ulk1902_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nerute kosker abim tabakeam nagri abele alabasa tarpor, muige abele ide debe lagelag au bodomalam, E epaitered abara kerem, a E eidi leuer aroem. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Abara kaimeg giz uiaba erdali, uiaba nerkepu au asiasi, a uiaba kega, Nalugelam abele lu dedkoli? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Abelelam, ese terapei abele ide debe lagelag, mena gaire lu bodomalam a ko nakuarare gaire lu kak le. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu umele, E uiabi kega, Nalugem uaba bamsili abele kosker? abelelam E debe lu karim ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abelelam uaba mena emri okakis gaire lu kak le, epe kakanali uabim nole niai emri. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Abelelam E epaitered abele ide debe lagelag kara gem kekiam, keubu kara etkobei. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ageakar, kaka uabi detager, Gaire ged uridili abele geseb ge etomertare abele euangelia, a ko etomeret abele lu abele kosker ikele mena ko dikiapor abim. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nerute le abele tuelf lelam, abara nei Iuda Isakariota, E bakeam gaire au zogozog le giz, ");
INSERT INTO ulk1902_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","A uiabi kega, Nalu lu uaba kari ikuar, a kaka abi ikuar uabim? Ege uiaba abi ikuar mani thirti. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Abele gerger ge E ditimed mirem abim, na kaua umele ko abi erpei. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Abele kekiam gerger abele areto nole isi kak, abara kaimeg giz Iesuim tabakeuare, a abim kega, Nade uteb ma lagelag keriba derser ko paseka eroare? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ege E uiabi detager, kega, Uaba bakeuare abele uteb, a nerute le uaba abi daratagerare, Abele Ereuer le mari detager, Kara mop maike; kaka ikeli abele paseka mara meta, kaka pako kara kaimeg giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ege abara kaimeg giz ikerare mokakalam Iesu mer tigri, a ko derser abele paseka. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kikem tabarki, E eidi leuer ero kemem tuelf le. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Uiaba eroare, E uiabi detager, Ageakar, kaka uabi detager, uabielam nerute le kari mirem. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A uiaba au asiasi, a uiaba ditimeda abim detagerare, Opole ae, nako kaka? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","E uiabi etkalu, kega, Abele le kemem akameida abara tag, pako kara tag abele tanelu ge, E dali abele le kari mirem. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Le la Uerem bakeamulu, mokakalam detarer abim; epe abele le Le la Uerem abi mirem uaiai abele le! debele abele le nole aosmer kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ege Iuda, le abi mirem, abi etkalu, kega, Rabi ae, nako kaka? E abi detager, Eko mama detager. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Uiaba eroare, Iesu ekao abele areto, a esoao, a itur; a uiabim nakuarare tabara kaimeg giz, kega, Tekao, aroem; kara gem ike. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","E tanelu ekao, a esoao, a uiabim nakuarare, kega, A ui uridili areem; ");
INSERT INTO ulk1902_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Abelelam kara mam ike, abele mam kerkar gelar ko epaitered gaire le giz adem dikri le ra uite giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kaka uabi detager, kega, Kaka nole aree kak abele uina turumlam, mena bakedida abele gerger kaka ko aree abele kerkar uaina uabi kemem kara Aba ra baselaia. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Uiaba emetu uedakiriare nerute ued, a uiaba Oliua paserem bakeamuda. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ege Iesu uiabi detager, Uaba uridili ezigmada karielam abele ki ge; emetu detali, kega, Kai le mamoe asesered ipiti, epe mamoe giz kepu bamarid. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ese kaka ko eded akaida, kaka kekiam bakeam Galilaiaem, a uaba keubu. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Epe Peteru abi detager, kega, Ese ui uridili marim ezigmada, kai nolea. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu abi detager, kega, Ageakar kaka mari detager, kega, Abele ki ge, kimiar faul nole ereretikri kak, a neis netat ma kari nasared. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peteru iako elele detager, kega, Ese kaka mari kemem naumilu, kaka nole mari asared kak. Uiaba uridili daratagered abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Uiaba baosi kemem Iesu abele ged nei Gethesemane, E uiabi detager, tabara kaimeg giz, Uaba bamer ike, a kaka bakeam peike ko esorerapare. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","E bakeuare kemem Peteru pako Zebedaio ra neis uerem, E au asiasi a ko okasosok. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","E uiabi detager, Kara nerkepu au asiasi, bakedida abele eud; uaba ko bamer ike, pako kari kemem uti kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","E kebikebi bakeam, a E etkobeilu, a esorerapare, kega, Kara Aba ae, ese umele, adem abele tanelu karielam; epe nole kara lag ikeli, mabara lag ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","E ko akomed a erdali abara kaimeg giz uiaba uteid, E detager Peteruim, Nako, uaba nole saserim kari kemem uti kak abele netat haua ge? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uaba uti kak a esorerapare, iaueakai uaba nole mirem barota; merkepu au lagelag, a gem gebegeb. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","E iako bakeam, a esorerapare, kega, Kara Aba ae, ese nole umele adem abele tanelu karielam, mena kaka aree, mabara lag ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E iako akomeda a uiaba erdali ko uteid, abelelam uiaba pone au perper. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","E uiabi dikaer, a ko bakeam esorerapare abele neis netat bakeam, E no netat mer detager. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","E iako akomeda a erdali abara kaimeg giz, E uiabi kega, Uaba uteid, a nerbazi: dasmer, maike abele haua Le la Uerem ko abi mirem gaire uit le giz ra tag. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bako, meriba bakeuare: dasmer, E maike abele le kari mirem. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Dasmer, E mer detaut, Iuda tabarki, nerute le tuelf lelam, E kemem gaire le lakub, pako zogozogo le giz, a aule giz abgedlam, uiaba nagri teibur aososo tulik pako gabgab. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Abele le abi mirem E uiabi etomeret nerute atamelam, kega, Abele le kaka abi eskos, E dali: uaba abi erpeirare. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","E sobkak tabarki Iesuim, a abi kega, Rabi ae; a abi eskos. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu abi detager, kega, Makanali, nalugem ma tabakeam? A uiaba tabakeuare a tag giz Iesui dog emarirare, a ko erpeirare. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dasmer, nerute le Iesui dog E ekao tabara teibur aososo tulik iseda, E ipiti nerute zogozogo le giz ra memeg le abara laip ismilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu abim detager, Mara teibur aososo tulik ko ikedi taba gedge; abelelam uiaba uridili ekao abele teibur aososo tulik, a ko eumilu abele teibur aososo tuliklam. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nako ma dikiapor kaka nole umele damosi kara Aba ko namarkare karim gaire angela giz tumem gaire legiona tuelf? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nako nole bakedida gaire iauali zogo, abkoreb bakedida abele gaire lu? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Peirdi abele haua kige, Iesu detager gaire le lakub, Nako uaba karim tabakeuare, gaire teibur aososo tulik, pako gabgab ko erpei mokakalam idikeda le ise? Meriba bamer abele zogo meta, kaka uabi ereuerem gaire gerger, a uaba nole kari erpei. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gaire lu uridili ikerare, iaueakai bakedilu gaire perofeta giz uiaba iauali. Abara kaimeg giz abi dikaerti, a uiaba derar. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Uiaba Iesu erpeirare, a abi datkimuardare Kaiafaim zogo le, a gaire aotale giz le pako aule giz netate gedim. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Epe Peteru muriz ge abi irmili, zogo le ra meta tabarki, a balu a emri kemem gaire memeg le, E lagelag erdali abele mop. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ege gaire zogo le giz pako aule giz pako gaire tarim le uridili uiaba deraimerare uader le bes ageakarem Iesuim, iaueakai uiaba abi ipitare eumilu: ");
INSERT INTO ulk1902_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Epe nole erdali; a ko tabakeuare gaire bes ageakarem, a nole ardar kak. Keubu neis le bes ageakarem tabakeamlei, a kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Abele le keribi detager, Kaka umele Ade ra zogo meta ezageri, kaka umele ko ikeli neis netate gerger. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Abele zogo le ekue, a abim kega, Nako ma nole mer etkalu? nako neis le ra mer marim? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Epe Iesu nole mer kak. Ege zogo le abim detager, kega, Kaka mari detager, Ma iskosi keribim edede Ad ra nei, nako mama Keriso Ade ra Uerem? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ege Iesu abi detager, Eko, mama detager; kaka uabi detager, Keubu uaba erdali Le la Uerem E emri tuter tag abele adigir kemer le, E ko tabakeam gaire kotor baz giz ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Abele zogo le tabara am uali etoat, a uiabi kega, E adud mer egali Adim: nako, nole ko abkoreb nerute ageakarem meribim? dasmer, uaba aserare peirdi abara adud mer egali Adim. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nako uaba dikiaporare? Ege uiaba daratagerare, kega, Abkoreb E eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ege uiaba mos iduari abara opem; a uader le tag giz ipitare abim, ");
INSERT INTO ulk1902_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","A uiaba mer kega, Keriso ae, mase keribi etomertare, nete le mari ipiti? ");
INSERT INTO ulk1902_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Epe Peteru E adige emri abele meta ge; nerute memeg neur abim tabakeamulu kega, Mama nerute le kemem Iesu Galilaia le. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","E abi asared uiaba opem uridili, kega, Kaka umer kak abele lu ma kari detager. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","E teosomeda abele maisu ge, a nerute memeg neur ko abi erdali, E detager uader le, Abele le E kemem Iesu Nazareta le. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","E ko abi asared, a ditimeda adud mer egali, kega, Kaka umer kak abele le. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kebikebi, uader le tekueilu, a uiaba kega, Peteruim, Ageakar ma nerute le uiabielam; abelelam keriba umele mara kodomer. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","E ko adud mer egali, a iskosi, kega, Kaka umer kak abele le. Ege kimiar faul sobkak ereretikri. ");
INSERT INTO ulk1902_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Epe Peteru ko dikiapor abele mer Iesu abi detager, Nole kimiar faul ereretikri kak, ma neis netat kari asared. Ege osomed E au ezoli. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gerger osakeida, gaire zogozogo le giz uridili, pako aule giz abgedlam uiaba mer atager Iesu ko abi ipit eumilu: ");
INSERT INTO ulk1902_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Uiaba abi didbari, ege uiaba datkimoardare a abi ikuar Pontio Pilato abele opole. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iuda umele, abele le abi mirem, E ko obazgeda, a ko ikuar thirti gaire mani gaire zogozogo le, pako aule giz, ");
INSERT INTO ulk1902_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kega, Kaka au uit le, abelelam kaka mirem abele le nole uit kak. A uiaba abi kega, Nako keribim abele lu? epe ma mabu abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","E batauered abele gaire mani abele zogo meta ge, E adem bakeam; E bakeam a tababu baudubari. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gaire zogozogo le giz uiaba ekao abele gaire mani, a kega, Abele lu gelar, umer kak ikedilu abele mani uteb ge gaire zogo lu ikedi, abelelam mam bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Uiaba mer atager, epe abi bodomalam le ikeli kakekak tanelu ra ged, a ko etkobeilu gaire sup le. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Abelelam nei atker abele ged, Mam ra ged, bakedida peirdi abele gerger. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iaueakai bakedelu Ieremia perofeta ra mer, kega, Uiaba ekao abele thirti mani, abele le bodomalam, uader Isaraela ra omasker uiaba abi bodomalam; ");
INSERT INTO ulk1902_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","A uiaba abi bodomalam le ikeli kakekak tanelu ra ged, mokakalam abele Opole uiabi detager. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu ekueilu opole ra opem; abele opole abi itmer, kega, Nako mama Iudaia le giz ra Opole? Iesu abi etkalu, Eko, mama detager. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gaire zogozogo le giz pako aule giz uiaba abi etomertare gaire abara mer, epe E nole mer kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato abi detager, Nako ma asoli gaire lu uiaba mari etomertare? ");
INSERT INTO ulk1902_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Epe E nole abi etkalu netate mer; abelelam abele opole au damred. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Opole ra tonar namarid nerute uetpur abele gaire le lakubem nerute le didbari, uiaba lagelag. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Abele kerker uiaba nagri nerute le didbari, au adud le, abara nei Barabasa. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","A uiaba netate uteb ge, Pilato uiabi detager, Nete le uaba lagelag kaka uabi namarid? Nako Barabasa? Nako Iesu, le nei atker Keriso? ");
INSERT INTO ulk1902_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Abelelam E umele uiaba kurablam abim ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","E egemeru abele mer atager bao ge, abele merkem tabakeam tabara koskerlam, kega, Ma nole abi dedkoli abele le barkak tonar; abelelam kaka au asiasi kara peim abim abele gerger. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gaire zogozogo le giz pako aule giz uiaba namarkare gaire le lakub uiaba abi daratagerare, Barabasa namarid, a Iesu ipit eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Abele opole uiabi detager, kega, Nete le neis le peike uaba lagelag kaka uabi namarid? Ege uiaba daratagerare, Barabasa. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato uiabi etkalu, kega, Nalu lu kaka ikeli Iesuim, abele le nei atker Keriso? Ege uiaba uridili abi daratagerare, Abi satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Opole uiabi etkalu, Nalu adud E ikeli? A uiaba aukase ereretikri, kega, Abi satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato umele uiaba nole asoli abara mer, a uiaba au sasemi, E ekao abele ni abara tag dirup gaire le lakub ra opem, a uiabi kega, Kaka ogog kak abele barkak tonar le ra mam: uabu abele. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Abele ged uridili abi daratagerare, kega, Keribi tumge, pako keriba omasker giz, abara mam. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","E Barabasa namarid uiabielam, E abi damarik Iesu, a ko ikuar abi satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gaire ares le uiaba datkimoardare Iesu abele opole ra meta, a uiaba netate gedim abim gaire ares le uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Uiaba iki adem abara am uali, a uiaba abi ame abele mamam am uali. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Uiaba euerare abele aper abele lu zegerzeger, a uiaba dikmerik abi kerem ge, a uiaba ikedirare abele kokeda abi tuter tag ge, a uiaba kokmamu abim, kega, Uaiai abele Iudaia le giz ra Opole! ");
INSERT INTO ulk1902_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Uiaba abi mosu iduare, a uiaba edarkare abele kokeda a ko ipitare abi kerem ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Uiaba emetu abi neg degarare, a uiaba detueare adem abele am uali, a ko abi ame tabara am uali, ege uiaba abi datkimoardare ko satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Uiaba bakeuare, a uiaba erdarare nerute Kurene le, abara nei Simona; a uiaba damsare abim ko ais abara satauro. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Uiaba abele utebe tabarki nei atker Gologotha, tonar abele, Kerem lid ra uteb, ");
INSERT INTO ulk1902_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Uiaba abi ikuar abele uinega ataperet okakis abele kurab lu E ereri; E kebikebi ere, a umer kak ere. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Uiaba abi satauroem, ege uiaba terapei abara am uali, a luglug ikeli netede ekardare: iaueakai bakedilu abele perofeta ra mer, Uiaba terapeirare gaire kara am uali, a uiaba luglug ikeli kara gem uali. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Uiaba bamer abele utebe abi asesered; ");
INSERT INTO ulk1902_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uiaba dikmerik tumem abi kerem ge abele jauali, abele lu abi emerered, Abele Iesu Iudaia le giz ra Opole. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Uiaba abi satauroem kemem abi dog neis eruam le, nerute le tuter tag, a nerute le ber tag. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gaire le nakasir, uiaba abi adud mer nakarare, a uiaba kerem abi dirilare, ");
INSERT INTO ulk1902_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kega, Mama le zogo meta ezageri, a neis netat gerger ko ikeli, ma mabu eded. Ese mama Ad ra Uerem, ma mabu tarabu abele sataurolam. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mokakalam zogozogo le giz, pako aotale giz, pako aule giz, uiaba abi neg degarare a kega, ");
INSERT INTO ulk1902_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","E umele uader le idigir, a nole umer kak tababu idigir: Ese E dali Isaraela Opole debele E uatabu peirdi abele sataurolam, iaueakai keriba abi oituli. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","E Adim oituli; debele peirdi E abi idigir, ese E abi omare: abelelam E detager, kaka Ade ra Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mokakalam abele neis eruam le kemem abi dog satauroem, uiaba abi adud mer egali taba opem. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ditimedlu abele sikes haua kupikupi ged ge uridili bakedilu abele nain haua ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Maike nain haua Iesu au ereretikri, kega, Eli, Eli, lama sabakethani? tonar abele, Kara Ad, kara Ad, nalugem ma kari nakaerti? ");
INSERT INTO ulk1902_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Uader le bako aserare, ege uiaba kega, E Elia dabgeri. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nerute le uiabielam E koreder ekao abele sap, a akameilu abele uinega, a agisilu pater ge, a abi ikuar ere. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A uiaba uridili abi daratagerare, Dikaer; meriba dasmer, nako Elia umele tabarki ko abi idigir. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iesu ko au ereretikri, epe namarid tabara lamar. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dasmer, abele uali demed zogo meta muige tababu batoat kotorlam a giz ge; abele sep demali; a neide nakesmur; ");
INSERT INTO ulk1902_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gaire ao emetu te diski; gaire zogo le ko eded akaida eudlam; ");
INSERT INTO ulk1902_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Emetu abara ko eded akaida, uiaba bakeuare abele zogo uteb, gaire le uiaba dasmerare. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Abele kerem le netate handed nosik le, pako uader le kemem Iesu abi asesered, uiaba erdarare abele sep demali, pako gaire lu ikerare, a uiaba au geum, kega, Ageakar Ade ra Uerem idali. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Gaire kosker giz uiaba muriz ge abi dasmerare, uiaba Iesu abi irmilare Galilaialam, uiaba abi memeg: ");
INSERT INTO ulk1902_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Uiabi kemem Maria Magadalena, pako Maria Iakobo a Iose uiaba apu, a Zebedaiora uerem uiaba apu. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Abele kikem tabarki, nerute le lu giz ra apu Arimathia le, abara nei Iosefa, E nerute Iesu ra kaimeg giz: ");
INSERT INTO ulk1902_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E bakeamulu Pilatoim abi damos abele Iesu ra gem. Pilato uiabi detager ko abi ikuar abele gem. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosefa ais abele gem, a sopem erebe abele uali lino og kak, ");
INSERT INTO ulk1902_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A ikedilu tabara ao ge kerkar, E daiui abele neide: E erparik nerute au baker abele ao ra te, E bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magadalena pako nerute Maria, uaiba emrilei obakuei abele ao ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Abele nerute gerger, abele gerger maike abele derser gerger, gaire zogozogo le giz, pako Faresaio giz netate gedim Pilatoim, ");
INSERT INTO ulk1902_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kega, Opole ae, keriba ko dikiaporare abele bes le E emetu detager, Abele kerker eded, eseamud neis netate gerger kaka ko tekue. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dasmer, ma uiabi detager ko dimilu abele ao, mena bakedilu neis netate gerger, iaueakai nole abara kaimeg giz bakeuare ki ge ko abi eruam, a uiaba ko daratagerare abele ged, E ko tekueilu eudlam; iaueakai au bes keubu, abele kekiam bes. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato uiabi detager, Uaba nagri asesered le; ua bakeuare uabu dimrare. ");
INSERT INTO ulk1902_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Uiaba bakeuare, a dimrare abele ao ge, a ikedi atamelam abele baker, a uader le ikedi uiabi asesered. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabath eseamulu, baneigiri abele kekiam gerger sefen, Maria Magadalena pako nerute Maria ui bakeamlam abi dasmer abele ao ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dasmer, abele aukase demali: abelelam abele Opole ra angela kotorlam tarabu, E bakeam erbariklu adem abele baker ao telam, E egimulu abi tumge. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Abara op mokakalam perper ise, pako abara am uali au kakakak mokakalam kiona ise: ");
INSERT INTO ulk1902_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Uiaba asesered le au geum a durdur barki, uiaba tarbigrare mokakalam eud le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Abele angela uiabi detager neis kosker, kega, Uaba nole geum kak; abelelam kaka umele uaba deraimer Iesu le, emetu satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","E nole ike, abelelam E ko eded akaid, mokakalam E detager. Ua tabakeamlam abi dasmeram abele uteb abele Opole emetu uteid. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ua bakeamlam dudum etomeret abara kaimeg giz, E akaid eudelam; dasmer, E kekiam bakeamulu Galilaiaem, uaba keubu; uaba ko abi erdali abele uteb: dasmer, kaka etomeret uabim. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ui bakeamlei dudum abele aolam, ui geum a au sererege; a koreder etomeret abara kaimeg giz. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ui bakeamlei etomeret abara kaimeg giz, dasmer, Iesu ui obapit a kega, Kaka uabi omare. A neis kosker tabakeamlam, a itut abara teter ge, a abi esorgiru. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iesu uiabi detager, Uaba nole geum kak: ua bakeamlam etomeret kara keimer giz, uiaba ko bakeuare Galilaiaem, uiaba kari erdali. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ui bakeamlei, dasmer, uader asesered le bakeuare abele uteb, a natomertare gaire zogozogo le giz abele gaire lu uridili ikerare. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A uiaba etami okakis gaire aule, uiaba mer atager, a ko nakuarare gaire mani uiabim abele gaire ares le, ");
INSERT INTO ulk1902_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","A uiabi kega, Uaba natomertare abara kaimeg giz ki ge tabakeuare, a abi eruam, epe uaba uteid. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ese opole asoli, a keriba abi idkubi, iaueakai uaba nagri debele. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A uiaba egardarare abele gaire mani, a uiaba ikelare mokakalam uiaba uiabi ereuerem: abele mer esali gaire Iudaia le giz bakedilu peirdi. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abara kaimeg giz bekeuare Galilaiaem, eleuen gaire le, abele paser ge Iesu uiabi mer tigri. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Uiabi abi erdali, a uiaba abi esorgiru: epe uader le nole oatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu tabarki, a uiabi detager, kega, Emetu kari nakuar abele sirdam uridili, abele kotor ge pako abele geseb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dasmer, uaba bakeuare gaire ged narida uridili ko uiabi ereuerem, pako uiabi bapataiso Babe ra nei ge, pako abele Uerem, pako abele Lamar Zogo: ");
INSERT INTO ulk1902_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Uaba uiabi ereuerem, a asesered gaire lu uridili kaka uabi detager: dasmer, kaka ko uabi kemem gaire gerger uridili, bakedilu abele geseb ra mop. Amen. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Abele ditimedilu Iesu Keriso ra debe merkem, Ade ra Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mokakalam gaire perofeta detali, kega, Kaka emarida karbara merkem mara op, ko paret mara gab; ");
INSERT INTO ulk1902_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Le kodo ereretikri soge purge, kega, Paret Iehoua ra gab, barditug abara gab giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ioane ko bapataiso abele soge purge, a marau bapataiso ra obazgeda ko detue adud giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iako abim bakeuare le Iudaia uridili, a uiaba Ierusalemalam, E uiabi bapataiso uridili, abele Ioridano dodo, uiaba detaut uiaba adud giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kamela mus Ioane ra am uali, abara uak kau ra paur; E pem ereg a isas ra sumes are: ");
INSERT INTO ulk1902_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","E marau, kega, Nerute kara sorge ekas adigir kari tumge, kaka nole abkoreb eparisili a detue abara teter gab mukub. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kaka uabi bapataiso nilam; E dali uabi bapataiso Lamar Zogolam. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Abele kerker ge, Iesu ekasereder Nazaretalam Galilaiage, Iesu Ioane de bapataiso abele Ioridano ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","E nilam ekueilu, E egremalu kotor nakesmulu, a Lamar Zogo epereda abi tumge, mokakalam dibadib: ");
INSERT INTO ulk1902_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iako kodo mer uataba kotorlam, kega, Mama kara Uerem nasge, kaka mari sererege. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dudumge Lamar Zogo abi emarida soge purem. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Foate gaire gerger E soge purge emeri, Satana de abi mirem; abi dog gaire ebur marmar; angela giz abara memeg. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Emetu Ioane didbari, Iesu bakeamulu Galilaiaem, ko marau Ade ra debe merkem, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kerker ge tabarki, a Ade ra baselaia maike; uaba obazgeda, a debe merkem oituli. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","E ekas keper dege Galilaia, E dasmer Simona a Anederea tabara keimer net gurem dikri: abelelam ui darali umele larem. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu ui darali daratager, kega, Kari narmili, kaka uabi depegemelu ko le asaperem. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ui darali dudum net dekaerei, a abi irmilei. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","E ko kebikebi ekasereder, E dasmer Iakobo Zebedaio ra uerem, a Ioane abara keimer, nar ge muigi, a net euelei. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E sobkak ui darali ereretikrei: ui darali Zebedaio uiaba aba dekaerei nar tumge, a gaire memeg, a abi irmilei. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Uiaba Kapernauma tabakeuare; sabath ge E dudum sunago tabao, a ereuerem. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tabara ereuerem uiaba damered: abelelam E uiabi ereuerem mokakalam le pardale, a nole mokakalam aotale giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nerute le nagri sumes lamar muige abele sunago; E ereretikri, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Iesu Nazaretalam, keriba nako marim? nako, mama tabarki keribi adem dipit? kaka mari opasereret, Ade ra Zogo. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu abi daisumdalu, kega, Bamer, a teosmeda abielam. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Abele sumes lamar abi ezagri, a au ereretikri, epe teosmed abielam. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Uiaba uridili damered, a mer atager, kega, Nalu pedali? nako abele kerkar ereuerem? abelelam sumes lamar giz E sirdam adigir, uiaba abi asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Epe sobkak E ekoseli gaire ged ge Galilaia deraueili. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Uiaba teosmeda sunagolam, sobkak uiaba tabarot kemem Ioane a Iakobo metaem, abele Simona a Anederea ra meta. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simona kosker ra apu uteid, gem urueri: uiaba sobkak abi etomelu. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","E keitekas abi tag erpeilu; sobkak urueri dekaida, E uiabi memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kikem, lem baraigida, uiaba abim taraisare gaire, gim le, a gaire le sumes lamar nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gaire ged uridili netate gedim op meta. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","E idigiri gaire tonar gim le, a imuda sumes lamar giz; E nole gaire demoni emarida ko mer egali, abelelam uiaba abi opasereret. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nede be iuaokaer, E ekueilu a teosmeda, a nogutebem bakeamud, abele esorerapare. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simona, a abara boai, abi irmilare. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Uiaba abi erdali, uiaba abi detager, kega, Ui uridili mari naraimeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","E uiabim detaut, kega, Minabakeuare gaire maiged, a kaka marau abele; abelelam kara dorge dali. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","E marau muige gaire uiaba sunago Galilaia uridili, a demoni giz imuda. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Abim keitoabuki nerute lepera, a abim ermeder, abi detager, kega, Ese mama laglag, mama umele kari nadgiri. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","E abi omare, a tag itrimuda, a abi ituti, a abi detager, kega, Kara lag; ma idigiri ");
INSERT INTO ulk1902_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","E emetu detager abele mer, sobkak lepera dekaida abielam, E idigir. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","E abi mer tigri, a abi emarida, ");
INSERT INTO ulk1902_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","A abi detager, kega, mamor dasmer, atager kak nerute le; bakeamuda, mabu natomelu abi zogo tarim le, a ikuar gaire lu Mose mer tigri uiabim; atamelam mama emetu idigir. ");
INSERT INTO ulk1902_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","E bakeamuda, a ditimeda ko daratagerare, a detager deraueili, abelelam Iesu nole umer kak paret kak ekas abele ged, E soge purge emeri; gaire le abim tabakeuare abgedlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gerger giz barki, E iako Kaperenauma uatabu; ui asereda E muige meta. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sobkak gaire le netate gedim, meta mui osmeda, pako adige; E uiabim Ade ra mer marau. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Uiaba abim tabakeuare, nerute le ibibi egardare, neis a neis le abi bakeuarare. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Uiaba umer kak abi dog maiem bakeuare mitkarlam: uiaba meta tumge ezagarare E muige, a lemlem ismi, uiaba sik dikri gim le tumge igimrare. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu erdarda uiaba oituli, E le ibibi detager, kega, Kara uerem, emetu adem dikri mara uit giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Uader aotale giz abele emeri, a tababu dikiapor muige uiaba nerkep ge, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Nalugelam le dali detager mokakalam? E Ade desauersili, nete le umele uit dikri, Ade tepteb? ");
INSERT INTO ulk1902_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sobkak Iesu opasereret muige abara nerkep abele uiaba dikiapor muige uiaba nerkep, E uiabim detager, kega, Nako uaba dikiapor mokakalam muige uaba nerkep? ");
INSERT INTO ulk1902_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nako perper, le ibibi egali, kega, Emetu adem dikri mara uit giz; pako egali, kega, Tekue, mabara sik ekau, a bakeamu? ");
INSERT INTO ulk1902_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ko uabim paret kak, Le la Uerem adigiri gaire uit geseb ge adem dikri, (E le ibibi detager, kega,) ");
INSERT INTO ulk1902_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kaka mari natager, kega, Tekue, mabara sik ekau, a mabara meta bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","E ekueda, a sobkak tabara sik ekaida, a E osmeda uiaba op uridili; abelelam uiaba uridili damereda, a Ade despili, kega, Meriba nole dasmerauem tonar mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E iako keper dege degemili; gaire le abim tabakeuare, E uiabim ereuerem. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","E uteb esaimelu, E Leui, Alefaio ra uerem, dasmer meta dipumeda emeri, E abi detager, kega, Kari narmili, E ekueilu a abi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Abele iobaru, E abara meta ge emeri leuer ero, telona giz a uit le giz kemem emeri Iesui dog, a abara kaimeg giz; abelelam gaire le uiaba abi irmilare. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aotale giz a Faresaio giz abi dasmer kemem leuer ero telona giz a uit le giz, uiaba tabara kaimeg giz daratagerare, kega, Nako E kemem leuer ero a ereli telona giz a uit le giz? ");
INSERT INTO ulk1902_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu asoli abele mer, E uiabim daratagerare, kega, Saserim le giz lukup kemle lakak, gim le giz lagelag; kaka nole tabarki ko gaire barkak tonar dabgeri, debele gair uit le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ioane ra kaimeg giz, a gaire Faresaio ra kaimeg giz leuer baili; uiaba tabakeuare a abi detager, kega, Nalugelam Ioane ra kaimeg giz a gaire Faresaio ra kaimeg giz leueru baili, a mara kaimeg giz nole leueru baili? ");
INSERT INTO ulk1902_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu uiabi detager, kega, Nako, umele gaire boai le ispida ko leueru baili, le ispida uiabi dog emeri? uiaba umer kak leueru baili, le ispida mena uiabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kerker niai tabarki, le ispida uiabielam egared, abele gaire gerger uiaba leueru baili. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nole le kerkar mog uali itkedi okakis buzibuzi am uali; akeulam buzibuzi mog uali de kerkar mog ualilam ekep itkedi, iako au atoatatoat. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nole le epaiteret kerkar uaina muige emeret tarpor giz; epe gegur tarpor giz arperiklam, uaina epaiteredlu, epe sor giz adud: mamor ko kerkar gegur tarpor epaiteret kerkar uaina. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Abele iobaru, E ekas kon gedub ge abele sabath; abara kaimeg giz kon itakemarare, a eroarare, gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Faresaio giz abi detager, kega, Dasmer, nako uiaba lu akerare nole abkoreb sabath? ");
INSERT INTO ulk1902_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","E uiabi detager, kega, Nako uaba nole etagerare Dauida de ikeli, leuer aro kak, uerer eudili, a gaire abara kaimeg giz? ");
INSERT INTO ulk1902_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","E Ade zogo meta ge tabalu, Abiatara ra kerker, zogo tarim le, E derser areto eroli, abele nole abkoreb nogle tero, mamor zogozogo le tepteb, E abara kaimeg nakuarare? ");
INSERT INTO ulk1902_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","E uiabi detager, kega, Sabath emetu ikeli le la uai kedeua, a nole le ikeli sabath uaikedeua; ");
INSERT INTO ulk1902_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Abelelam Le la Uerem sabath ra Opole. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","E iako sunago balu; abele nerute le tag euselu. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Uiaba abi keikei dasmerare, nako, E abi idigiri sabath ge; uiaba ko abara mer atrumda. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","E le tag euselu detager, kega, Eipu ekueda. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","E uiabi detager, kega, Nako, abkoreb debe lu ikeli sabath ge, nako adud lu ikeli? ko idigiri, nako ipit eumid? Uiaba bazeguar. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","E uiabi urkerem deraueli dasmerare, abara nerkep isir uiaba tonarlam bamesili, E le detager, kega, Mara tag uaimari. Abara tag uaimari; ueakai abara tag ekaida debele mokakalam nerute. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Faresaio giz teosmeda, a sobkak mer atagere, pako Herodiano giz, ko abi ipit eumida. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu a abara kaimeg giz bakeauda abele keper ge; gaire le abi irmili Galilaialam, pako Iudaialam, ");
INSERT INTO ulk1902_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pako Ierusalemalam, pako Idumealam, pako Ioridanolam sager op, pako uiaba maike Turo a Sidona, gaire le abim tabakeuare, abelelam uiaba asereda abara dorge ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","E abara kaimeg giz mer tigri, ko kebi nar tais abi naokaili gaire lelam, uiaba abi atkaplam. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","E gaire le nadgirare; abelelam ui uridili gim nagri abi atkap ueakai abi itutilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Uite lamar giz abi dasmerare, uiaba abim bakesmeri, a ereretikri, kega, Mamanali Ade ra Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","E uiabim elele mer tigri, uiaba abi atomeret kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","E paserem ogi, a dabgeri gaire le E laglag; uiaba abim tabakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","E depeger tuelf le, ko abi kemem emri, a E uiabi namarkare ko marau. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Adgiri uiabi nakuarare ko nadgirare gaire gim le, a demoni giz imuda. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","E Simona nei atker Peteru; ");
INSERT INTO ulk1902_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Pako Iakobo Zebedaio ra uerem, a Ioane Iakobo ra keimer; E uiabi nei atker Boanerege, tonar, Girgir ra uerem: ");
INSERT INTO ulk1902_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pako Anederea, a Filipo, a Batolomaio, a Mataio, a Toma, a Iakobo Alefaia ra uerem, a Tadaio, a Simona Kanana le, ");
INSERT INTO ulk1902_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Pako Iuda Isakariota, abi keser keser: uiaba metaem barot. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ege gaire le netat gedim, abelelam uiaba umer kak leuer aroare. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Abara boai aserare, uiaba tabaos, ko abi terpei; uiaba detager, kega, E paim paim. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aotale giz Ierusalemalam tabakeuare uiaba detager, kega, Belezebul abi dog, E demoni giz imuda opolelam demoni giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","E uiabi darabgerare, a uiabi daratagerare gaire mer babisdarie, kega, Nako, Satana umele Satana imuda? ");
INSERT INTO ulk1902_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ese nerute baselaia epuli, abele baselaia umer kak niaiem ekue. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ese nerute uteb epuli, abele uteb umer kak niaiem ekue. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ese Satana tababu barili, a epuli, E umer kak niaiem ekue, tabara mop tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nerute le umer kak saserim le la meta ge badari, a abara lu itkamri, ese nole kekiam saserim le didbari; iako abara meta itkamri. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ageakar kak uabi detagereda, kega, Gaire ezubameli, a gaire uit uerem le giz ko detue: ");
INSERT INTO ulk1902_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Abele le Lamar Zogo ditagi, nole atue kak niaiem, epe abkoreb abim ikuar niai bodomalam; ");
INSERT INTO ulk1902_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Abelelam uiaba detager, kega, Uit lamar abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Abara keimer pako apu abim tabakeuare; a adige bako, uiaba namarida abi dabgeri. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gaire le netate gedim abi derumeda bameri; uiaba abi detagerare, kega, Ma dasmer, mara apu a mara keimer giz adige, mari naraimeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","E uiabi detaut, kega, Nete kara apu a kara keimer giz? ");
INSERT INTO ulk1902_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","E dasmerare uiaba abi derumeda bameri, E detagereda, kega, Dasmer, kara apu a kara keimer giz! ");
INSERT INTO ulk1902_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Abelelam abele le Ade ra lag ikeli, E dali kara keimer, a kara berbet, a kara apu. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","E iako degerati ko ereuerem keper tauer ge, gaire le netate gedim abim, abelelam E nar atiem, a emri, uiaba uridili tauer ge bamer. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Gaire mer E uiabim ereuerem mer babisdarie, E uiabidaratagerare abara okadeskeda, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Uaba aserauem; Dasmer, nerute amorda le bakeam ko emor: ");
INSERT INTO ulk1902_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E dikri, a uader kep gab dege abi, epe ebur giz kotorlam tabakeuda abele eroare. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Uader kep tumem neidge abi, kebi seb ge; sobkak omeili, abelelam lerkar seb ge: ");
INSERT INTO ulk1902_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Gerger eupamada, a eueri, a eumili, abelelam nole sip kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Uader kep lu eipu daradara ge omeili, a detarapi, abelelam nole turum kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Uader kep debe seb ge abi, a omeili, a esali, a turum turum; a turum therti nagri, a sikesti; a uan handed. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","E uiabim detagereda, kega, Le grip nagri ko asoli, debele E asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","E tepteb emri, gaire le abi dog emri, pako tuelf le, abi itmer tonar abele mer babisdarie. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","E uiabim detagereda, kega, Gaire mu tonar Ade ra baselaia uabi dekuarare ko opaserertem; emetu ikeli abele gaire lu abkoreb uiabim nogle giz: ");
INSERT INTO ulk1902_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Abelelam ui ko dasmerare, epe nole asmer kak; a asoli, epe nole asor kak; uiaba depegelam, a uiaba uit ko detue. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","E uiabim detagereda, kega, Nako, uaba nole asmer kak abele mer babisdarie? epe nako uaba ko umele gaire mer babisdarie uridili? ");
INSERT INTO ulk1902_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Abele amorda le, emor Ade ra mer. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abele uader le gab ge, abele mer uiabi dog emor; uiaba asereda, epe Satana tabarki, abele mer uiabi nerkep ge emor ekadari. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Abele uader tumem neid ge emor; uiaba abele mer asereda, a sobkak sererge erperida; ");
INSERT INTO ulk1902_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Epe nole sip kak muige uiaba nerkep ge, abelelam nole niaiem ekue; menaba asiasi a dedkoli abele merlam tabarki, sobkak uiaba bakesmiri. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abele uader le eipu daradara ge emor; uiaba abele mer asoli, ");
INSERT INTO ulk1902_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Epe gaire dikiapor lu lag geseb ge uiabi nerkep ge badari, pako geseb lu okardarem, pako uader lu lag, abele mer etarapi, epe nole turum kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ege uader emor debe seb ge; uiaba abele mer asoli, a mamor erpeili, a turum turum, uader therti, a uader sikesti, a uader uan handed. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","E uiabim detagereda, kega, Nako, lamepa ikedi kumete lokod ge, a laulau lokod ge? epe nole tum ge ikedi lamepa uteb? ");
INSERT INTO ulk1902_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Epe nole lu ispili, a nole opasereret kak; pako nole mud ge lu, a nole akmer kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ese nerute le grip nagri ko asoli, debele E asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","E uiabim detagereda, kega, Uaba mamoro aserauem; abele tonar uaba detare, ko uabim detare; a ko uabi daisuerare le asereda. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Le nagri, ko abi ikuar; le nole nagri kak, ko ekada abele lu abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","E detagereda, kega, Ade ra baselaia mokakalam le kep dikri seb ge; ");
INSERT INTO ulk1902_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","E ko uteid, a ekeamlu ki ge a gerger, abele kep uai omeida, a bataile, E nole umer kak nagelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tababu seb ge omeili; uai kekiam, sik keubu, epe turum agiag. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Turum agiag, epe namarida ko tigri, kerker ge nurabi. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","E detagereda, kega, Na lu meriba ko abkoreb Ade ra baselaia? na lu abkoreb abele babisdarie? ");
INSERT INTO ulk1902_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Abele mokakalam sinapi kep, emetu emor, kebikebi kep tumem gaire kep uridili geseb ge emor, ");
INSERT INTO ulk1902_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Emetu emor, E omeida, a aule tumem gaire lu ekekri, epe gaire au tam disiri; a gaire ebur epereda mudi ge igiredi. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","E Ade ra mer uiabim detagereda, mokakalam gaire mer babisdarie, abkoreb uiaba umele asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","E nole uiabim atager kak, ese nole mer babisdarie; uiaba mud uteb ge, E uiabim, abara kaimeg giz, gaire tonar mer detaut. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Abele gerger kikem, E uiabim daratagereda, kega, Minaba atiem nerut apekem. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Uiaba emetu le lakub emarida, uiaba abi egared nar ge atiem. Uader kebi nar abi doakri. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Au ui tabarki, a gaire zauber nar etatkoi, a mitkar. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","E amaz ge kor ge uteidi: uiaba abi itir, a abi detager, kega, Kole, mama laglag ki nabaume? ");
INSERT INTO ulk1902_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","E tekue, uag daisumda, a gur detager, kega, Bamer, debe meda. Iako uag ekeamulu, ege metalu. ");
INSERT INTO ulk1902_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","E uiabim daratagereda, kega, Nalugelam uaba geum mokakalam? nako uaba nole oatur kak? ");
INSERT INTO ulk1902_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Uiaba au geumu, a mer atagere, kega, Nete dali, uag a gur abi asoli? ");
INSERT INTO ulk1902_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Uiaba nerute apek tauer ge tabarki, abele Gadara le la ged. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","E narlam eupamada, epe sobkak nerute le uit lamar bada abim obapit: abele le gaire aolam tabakeam, ");
INSERT INTO ulk1902_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","E gaire ao ge emri; nole le umele abi didbari, a malil par nolea: ");
INSERT INTO ulk1902_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dordor abi didbari, teter ge a tage malil paru, abele tage a teter didbari, E dergeiri; nole le umer kak abi maiem ekepli. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ki ge, a gerger ge, E mena emerilu abele gaire paser, a gaire ao ge, E ereretikri, a abara gem baker de esakeilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","E muriz ge Iesui dasmer, E koreder abim a esorgiru. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","E au kodo ereretikri, kega, Kaka nako marim, Iesu Ade ra Uerem, au kale? Kaka marim bali Ade ra op, nole kari asiasi nakeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Abelelam, E abi detager, kega, Ma lamar uit teosmeda lelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","E abi itmer, kega, Mara nei nako? E detaut, kega, Kara nei legeona; abelelam keriba gaire. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","E elele abim bali, kega, Nole keriba amu kak ab gedelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Abele borom au isir gorgor paser ge erueda. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gaire demoni giz abi damseda, kega, Keribi demarida gaire boromem, ko keriba uiabim badari. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu sobkak uiabi emarida. Abele uit lamar giz teosmeda, a gaire borom ge barti; epe borom isir uamen uamen koreder au gorgorlam keperem, (uiaba maike tu thausan;) iako gune obaiter. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Le giz borom naseserdare koreder ge, a gedim, pako gaire ged daratagerare. Uiaba tabakeuare, a dasmer abele tonar ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Uiaba Iesuim tabakeuare, uiaba abele le dasmer demoni legeona dedkoli emeri, a ameare, a tonar tonar; epe uiaba geum. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Uiaba le erdali mer poipi detaut gaire tonar le demoni dedkoli, a tonar borom giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Uiaba ditimeda abi damosare, ko uiaba ged dekaer. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","E nar atiem, le demoni dedkoli abi damos ko abi dog emeri. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","E nole laglag, E abi detager, kega, Bakeam mabara ged, a mabara boai, a uiabi natomertauem abele gaire au lu Opole de marim ikeli, a mari omare. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","E bakeamud, a ditimeda marau Dekapolem gaire au lu Iesu de abim ikeli; epe uiaba uridili damreda. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu emetu iako atiem nerut apek, gaire le netate gedim abim; E meg tauer ge emeri. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dasmer, nerute sunago kole tabarki, abara nei Iairo; E abi dasmer, E ekesmiri tabara teter ge, ");
INSERT INTO ulk1902_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","A abim elele bali, kega, Kara kebi neur maike eumida; debele ma tabakeam a mabara tag abi tum ge dikmerik, ueakai abi idigiri, E ko eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","E abi kemem bakeam; a gaire le lakub abi irmili, uiaba abi ditkabda. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Abele nerut kosker mam gim tuelf gaire urut babusedari. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","E au asias dimegeroa gaire lukup kemlelam, abara lu eseemuda, uiabi nakuarare lukup bodomalam, nole adigir kak, epe mena au gim. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","E Iesu ra tonar asoli, E eipu gaire le ekasereder Iesu isorge, abara am uali ekepeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Abelelam E detager, kega, Ese kaka abara am uali tepteb ekepeli, kara gim akaida. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sobkak abara mam diruruarti; E umele abara gem akaida abele gimlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sobkak Iesu abara nerkep ge opasereret nerute adigir osmeda abielam, E gaire le ge eipu egreemalu, a detager, kega, Nete kara am uali ge ekepeli? ");
INSERT INTO ulk1902_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abara kaimeg giz detagereda, kega, Mama dasmer gaire le mari natkabda, nako tonar mama detager, kega, Nete kari dog ekepeli? ");
INSERT INTO ulk1902_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","E op etarer ko kosker deraimerer abele lu ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kosker geum a durdur barki, abelelam E umele abele lu abi dog ikeli, E abara op ge ekesmer, a ageakar abi detager ueeseamur. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","E abi detager, kega, Kara neur, mabi oaturlam ma eded akaida; mapodan kem bakeamulu, ma eded akaida mabara gimlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","E mena detaut abele mer, sunago kole merkem tabarki, a abi detager, kega, Mara neur eumida; nako iako kole bamesili? ");
INSERT INTO ulk1902_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu asoli abele mer, E sunago kole detager, kega, Ma nole geum kak epe oituli. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E uiabi daraisumdarda, nole le kak abi irmili, mamor Peteru, a Iakobo, a Ioane Iakobo ra keimer. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Uiaba sunago kole ra meta tabakeuare; a uiabi saserimem nardarare, a ebazoli, ueu baudaredelare. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","E badari, a uiabi daratagereda, kega, Nako uaba saserim, a ebazoli? abele neur nole eud kak, E uteidi. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Uiaba abi neg degarare. E emetu uiaba uridili adige namuare, E neur ra aba a apu tegared, a uiaba neis a neis le abi dog, a barot neur ra uteb. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","E neur ra tag erpeilu, a abi detager, kega, Talitha kumi; tonar abele mer, Neur, kaka mari natager, Ekue. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sobkak neur tekuelu, a bakeamulu; tuelf abara urut. Uiaba au kase damreda. ");
INSERT INTO ulk1902_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","E elele uiabi mer tigri, nole nerute le atomeret kak abele mer; epe E uiabi detager, kega, Debele leuer abi ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E bakeam ab gedelam, a tabara ged ge tabarki; abara kaimeg giz abi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabath ge, E ditimeda sunago ge ereuerem; gaire le asereda damreda, kega, Nagelam abele gaire dorge abi dog? nako pardali abi ikuar, ueakai gaire dorge adigir mokakalam abara tag ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nako nole tonar le abele? nako nole Maria rauerem, Iakobo ra keimer, a Iose, a Iuda, a Simona? nako abara berbet nole meribi dog? uiaba abi derar. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu uiabi daratagereda, kega, Nole perofeta ekekri, tepteb abara ged ge, a abara boai, a abara uteb ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E nole umer kak nerut adigir ikeli peike, abele dorge tepteb, abara tag gaire gim le dikmerik, a uiabi nadgirauem. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","E au damreda uiabielam uatur kak. E bakeamuda deraueida abele gaire kebi uteb ge, a okadeskeda. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","E tuelf le darabgerare, a ditimeda uiabi namarida neisi le a neisi le; a adigir uiabi nakuarare tumem gaire uite lamar; ");
INSERT INTO ulk1902_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","E uiabi mer tigri, kega, Lu aisis kak abele bakeam, no koket tepteb; nolo epei kak, nole leuer kak, a nole mani kak muige uak; ");
INSERT INTO ulk1902_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","A no teter gab ameare; a nole neis am uali ameare. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","E uiabi daratagereda, kega, Uaba nerute meta ge badari, emri abele, a iako bakeauare. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Uiaba le giz uabi agared kak, a nole uabi asor kak, uaba bakeam abele gedelam, sep ditkeda uaba teter gablam uiabi atamelam. Ageakar, kaka uabi detagereda, kega, Niaiem gerger itmer, kebi bodamalam Sodomaem a Gomoraem tumem abele ged ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Uiaba bakeauda, a marau, kega, Mamor uaba gaire le obazegeda. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gaire uit lamar uiaba namuda, a gaire gim le uiaba ide epaitered, a uiabi nadgirare. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heroda opole asoli, abelelam abara nei ekoseli; E detager, kega, Ioane Bapataiso eded akaida eudelam, abelelam E gaire adigir ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Uader detager, kega, Elia pedali. Uader detager, kega, Perofeta pedali, abelelam E nerute perofeta mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heroda asoli, E detager, kega, Ioane pedali, karielam abara kerem derapeida, E eded akaida eudelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Emetu Heroda namarkare Ioane terpeirare, a abi didbare muige au dubare meta ge Herodialam, Filipo ra kosker abara narbet: abelelam E abi ispilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Abelelam Ioane Heroda detager, kega, Nole marim abkoreb mara narbet ra kosker ispida. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Abelelam Herodia Ioane urker, a E lagelag abi ipit; a nole umer kak; ");
INSERT INTO ulk1902_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Abelelam Heroda Ioane geum, E opasereret Ioane barkak tonar, a zogo le, E abi asesereda. E abi asoli, a ikeli gaire dorge, a abi sererge asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Gerger abkoreb tabarki, abele gerger Heroda eosmelu, E dersemer uiabim gaire opole giz, a gaire kole, a gaire tarim le Galilaia ge; ");
INSERT INTO ulk1902_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia ra neur balu, a ginar diger, Heroda pako uiaba abi dog emri a sererge; opole neur detager, kega, Kari nautumer lu mara laglag, kaka mari nakuar. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","E abi mer nakesmulu detager, kega, Kaka mari nakuar gaire lu mama kari nautumer, mokakalam kara baselaia mog. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","E teosmeda, a abara apu detager, kega, Nalu kaka damos? Abara apu detager, kega, Ioane Bapataiso ra kerem. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sobkak E iako opole badari, a abi detager, kega, Kaka laglag mama mena kari nakuar Ioane Bapataiso ra kerem abele tanelu ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Opole ra nerkep beber barki; epe E nole abi azer kak, abele mer akesmulam, a uiabielam abi dog bamer leuer eroare. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Opole sobkak memeg le namarida, a abi mer tigri, kega, Abara kerem tegaret. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","E bakeamuda, a Ioane ra kerem derapeida muige au dubare meta ge, a abara kerem tegaret tanelu ge, a neur ikuar; a neur abara apu ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ioane ra kaimeg giz aserare, ui bakeuare, a abara gem tegardare, a ao ge ikedarare. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesu ra kaimeg giz tabakeuare abim; a abim daratagerare gaire dorge uiaba ikelare, a uiaba ereuerem. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","E uiabi detagereda, kega, Mi nabakeuare le kak utebem, ueakai ner nabazier. Abelelam gaire le uatupili, a nole uteb ko leuer ero. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Uiaba nar ge gumik atiem abele le kak utebem. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Gaire le lakub dasmer uiaba atiem, gaire le abi opaserertem, a koreder ge abim gaire gedelam uridili, uiaba kekiam tabarki, a netat gedim abim. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","E bakeam a gaire le dasmerauem, a uiabi nasge, abelelam uiaba mokakalam mamoe giz nole le asesered kak; a E uiabi ditimeda ereuerem gaire lu dordor. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kikem, abara kaimeg giz abim tabakeuare, a detager, kega, Soge pur ike, a kikem: ");
INSERT INTO ulk1902_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Uiabi namarkare gaire gedim, a gaire utebem, leuer arapem uiaba aroem; abelelam uiaba nole leuer kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","E uiabi detagereda, kega, Uaba uiabi leuer nakuarare. Uiaba abi detager, kega, Nako, keriba bakeuare leuer arapem tu handed denari ko bodomalam, ko uiabi asisiem? ");
INSERT INTO ulk1902_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","E uiabi detagereda, kega, Naket areto uabi dog? bakeam dasmer. Uiaba edali, a detager, kega, Faif, a neis lar. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","E uiabi mer tigri ko nosik bameri tumem abele golegole soge ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Uiaba nosik bameri, uader uan handed nosik, uader fifeti nosik. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","E emetu faif areto tais, a neisi lar, E kotor dimiruarti, a esoao, a areto itur; a abara kaimeg giz nakuarare uiaba opem idedi; E neisi lar ditker uiabim uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Uiaba uridili leuer eroare, a kem osmeda. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Uiaba leuer mog, a lar mog etakarare, epe tuelf epei osmeda. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mokakalam faif thausan gaire kimiar, areto eroare. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","E sobkak abara kaimeg giz elele daratirieda nar ge bartiri, ko atiem nerut apekem Bethesaida opem, abara dorge gaire le namarida. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","E emetu uiabi namarida, E paserem ogi esorerapare. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bakedilu abele kikem, nar eip karem ge, a Iesu tepteb geseb ge emrilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","E uiabi darasmerare uzelam sagim, abelelam uag opem uami; ki apek foa, E uiabim tabarki, zauber tum ge ekas; mokakalam E uiaba dege ekas. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Uiaba abi erdali zauber tum ge ekas, uiaba dikiapor lamar pedali, epe uiaba au ereretikri; ");
INSERT INTO ulk1902_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Abelelam ui uridili abi dasmer, epe uiaba geum. Sobkak E uiabi detagereda, kega, Saserimem; kai nali, nole geum kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","E uiabim nar ge ekauererti; epe uag ekaida: uiaba abi au kase damereda. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Uiaba nole akiapor kak abele areto, abelelam uiaba nerkep kelarkelar. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Uiaba emetu esaimeda atiem, uiaba tabarki Genesareta ged, a ged ge ekarida. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Uiaba emetu ekarida narlam, sobkak uiabi abi opasereretem, ");
INSERT INTO ulk1902_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A gedim kored deraueida, a ditimeda gim le giz bakuarda tumem sik, a kei tegardare abele uteb Iesu emri. ");
INSERT INTO ulk1902_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Abele uteb, a ged, a gedub E tabarki, uiaba gaire gim le tegardare ugab ge ikedi, a abi damsare ko abara am uali dege ekpi; uiaba uridili abi ekpi nadgirauem. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Faresaio giz, a uader aotale giz, netat gedim abim Ierusalemalam. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Uiaba dasmer uader abara kaimeg giz areto er oare a ogog tag arub kak, uiaba mer mer. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Abelelam Faresaio giz, a Iudaia giz, nole leuer aro kak, ese nole mamoro tag ogarub kak, uiaba aule ra tonar irmirauem. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Uiaba tabarki leuer araplam, nole leuer aro kak, ese nole ogarup kak. A dordor tonar uiaba erpei, a ikerare, tanelu ogdirup, a tanelu tonar, a malil tanelu, a gaire sik. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Faresaio giz a aotale giz abi itmer, kega, Nako mara kaimeg giz nole irmili aule giz ra tonar, epe leuer arouem a tag ogarup kak? ");
INSERT INTO ulk1902_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","E uiabi daratagereda, kega, Isaia mamoro uabim bes le giz perofetaem, emetu detali, kega, Abele ged ge kari naospereda uiaba mitelam, a uiaba nerkep kara muriz ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Uiaba sagim karim esorerapare, a gaire le la tonar ereuerem lelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Uaba Ade ra gelar dekaierta, a le la tonar elele erpei. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","E uiabi daratagereda, kega, Uaba tonar Ade ra gelar dituaki, ueakai uaba tonar irmireda. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mose detager, kega, Mabi abera, a mabi apuera naospili; E dali tabara aba a apu desauersili, debele abi ipit eumilu: ");
INSERT INTO ulk1902_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Epe uaba detagerare, kega, Ese nerute le tabara aba, a apu detager, kega, Abele kara lu mari upinati Korabana, tonar abele, Emetu Adim ikuar; ");
INSERT INTO ulk1902_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Uaba nole abi amari kak, ko nerut lu ikeli abem a apuem; ");
INSERT INTO ulk1902_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Abele uaba tonar lelam, Ade ra mer dedkoli; a gaire lu mokakalam uaba ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ege E iako gaire le lakub derabgerare abim, E uiabi detagereda, kega, Uaba uridili kari asoli pako akmerem: ");
INSERT INTO ulk1902_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nole sor lu le nerkep ge badari, umele abi dedkoli; mamoro gaire lu abi nerkeplam osmeda, abele gaire lu le dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ese nerute le grip nagri ko asoli, debele E asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","E metaem balu gaire le kublam, abara kaimeg giz abim eutumer tonar mer babisdarie. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","E uiabim daratagereda, kega, Nako uaba ko nole umer kak? Nako uaba nole akmer kak, nole sor lu le kem ge badari, umele le dedkoli; ");
INSERT INTO ulk1902_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Abelelam nole abara kem ge badari, mamor teibur ge, a sumez ge imuda, a leuer uridili mamor ikeroa? ");
INSERT INTO ulk1902_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Edetager, kega, Abele lu lelam osmeda, abele lu le dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Abelelam mui le nerkeplam osmeda gaire adud dikiapor, a kogem, a eruam, a le ipit eumilu, a keserkeser, ");
INSERT INTO ulk1902_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","A lu lag, a uit tonar, a okardar, a opelid, a erkepagau, a ezu bameli, a baospili, a paim tonar: ");
INSERT INTO ulk1902_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Abele gaire adud tonar pedali mui nerkeplam eosmeda, a le dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E tekue ab gedelam, a nener Turo a Sidona bakeamulu. E nerute meta badari, a nole lakak nerute le abi dasmer; epe E nole umer kak ispili. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nerute kosker, abara neur nagri uit lamar, E asoli Iesu pedali, E tabakeam a Iesu ra teter ge asorgiru: ");
INSERT INTO ulk1902_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Abele kosker Heleni kosker, Surofoiniki osmeda. E Iesui damos ko demoni imuda abara neurlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Epe E abi detager, kega, Kekiam gaire uerem kem osmeda; nole abkoreb uerem ra leuer tais, a omai giz nakuarare. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kosker abi detaut, kega, Ageakar, Opole; epe omai giz deroli laulau muige gaire leuer puipi uerem giz aroem. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","E koskerim detager, kega, Abele merlam, ma bakeam; demoni emetu bakeam marara neurlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kosker tabara meta tabarki, E dasmer demoni nole akar, a abara neur uteidilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","E iako bakeamulu Turo a Sidona nenerlam, a Galilaia keper tabarki, eipu Dekapoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uiaba abim tegared nerut lo grip batapeli, a lukluk mer; uiaba abi damos ko tabara tag abi tum ge dikmerik. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","E gumik abi tegared gaire lekublam, a abara neisi baur kei abara neis grip deraimilu, a mosu itu, a abara uerut itutilu; ");
INSERT INTO ulk1902_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A kotorem egremalu, a ner batauerdelu, a abi detager, kega, Efatha, tonar abele mer, Diski. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sobkak abara neis grip darauskilu, a abara uerut kerar detue, a E barkak mer egali. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","E uiabim mer tigri, kega, Nole, nerute le atager kak: E sagim uiabim mer tigri, uiaba elele daratagerare abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Uiaba au kase damereda, kega, E mamoro ikeroa gaire lu uridili: E gaire grip batapeli ikeli a asoli, a gaire te dabim, ko mer detaut. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Abele gaire gerger, dordor le lakub, a uiaba nole leuer kak, E tabara kaimeg giz darabgerare, a uiabi detagereda, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Kaka le lakub nasenase, abelelam uiaba thri gerger kari dog emri, a nole leuer aro kak; ");
INSERT INTO ulk1902_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ese kaka uiabi meta namarida, a nole leuer aro kak, uiaba gab ge durdur; abelelam uader muriz gedelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abara kaimeg giz abi detagerare, kega, Nagelam areto, abele soge purge, uiabi darasisieda? ");
INSERT INTO ulk1902_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","E uiabim nautumereda, kega, Nako, naket areto uabi dog? Uiaba detagerare, kega, Sefen. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","E le lakub mer tigri ko seb ge emereda; E gaire areto sefen tekadarare, a esoao, a itiri, a abara kaimeg giz nakuarare, uiaba opem ikedi; a uiaba le lakub opem ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Uader kebi lar uiabi dog: Iesu esoao, a uiabi detagereda ko ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Uiaba eroare, a kem osmeda: a uiaba leuer mogmog etaker, a gaire epei sefen arot. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Maike foa thausan, ui uridili leuer eroare; E uiabi namarida. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sobkak E, pako abara kaimeg giz, nar ge ekauererti, a ged Dalmanutha atiem. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Faresaio giz abim tabakeuare, a ditimeda abi basaret, ko abi mirem, abi itmer atamelam kotorlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","E au nerezi muige abara mar, kega, Nako abele nosik le atamelam deraimer? Ageakar, kak uabi detagereda, kega, Nole akuar kak atamelam abele nosik le. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","E uiabi dekaer, iako nar ge ekauererti, a nerut apek atiem. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Uiaba okataprik ko leuer ais; no netat areto uiabi dog nar ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","E uiabi mer tigri, kega, Beber dasmer, abele Faresaio ra leuen, a Heroda ra leuen mamoro dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Uiaba mer atagere, kega, Abelelam meriba nole areto kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Epe Iesu opasereret, E uiabi detager, kega, Nako uaba mer atager abele nole leuer kak? Nako uaba nole umer kak, uaba nole akiapor kak? nako uaba tumtum nerkep? ");
INSERT INTO ulk1902_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nako uaba pone nagri, a nole asmer kak? a grip nagri, a nole asor kak? a nole akiapor kak? ");
INSERT INTO ulk1902_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ababurge kaka faif areto itiri uiabim faif thausan, naket epei osmeda uaba etaker abele leuer mog? Uiaba abi detager, kega, Tuelf. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A gaire areto sefen uiabi foa thausan, naket epei osmeda uaba etaker abele leuer mog? Uiaba abi detager, kega, Sefen. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","E uiabi daratagereda, kega, Nako uaba nole akiapor kak? ");
INSERT INTO ulk1902_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Uiaba Bethesaida tabakeuare. Uiaba nerute le asamasam abim tegaret, a abi damos ko abi itut. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","E tage asamasam le erpei, a abi dadkimortare abgedelam; E emetu abara neis pone mos ermeda, a tage abi tumge ikedi, E abi itmer, kega, Nako ma nole nerute lu dasmer? ");
INSERT INTO ulk1902_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","E kotor dasmer, a detager, kega, Kaka gaire le dasmer, mokakalam dordor lu nakasir. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","E iako tabara tage ikedi tumem abara neis pone; a E lidem dasmer, E ueakai debele, a gaire lu mamoro dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","E abi namarida abara metaem, a detager, kega, Nole bakeamu utebem abele. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu pako, abara kaimeg giz, gaire utebem Kaisaria Filipo bakeuare; eipu gab ge, Iesu abara kaimeg giz eutumer, kega, Nako gaire le natagere, kaka nete? ");
INSERT INTO ulk1902_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Uiaba detaut, kega, Ioane Bapataiso; epe uader detager, Elia; a uader detager, Nerute perofeta giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","E uiabi daratagereda, kega, Nako uaba detager, kaka nete? Peteru abi detaut, kega, Mama Keriso. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","E uiabi mer tigri, nole nerut le abi atager kak abele. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","E ditimeda uiabi ereuerem, Le la Uerem ko asiasi, a aule giz abi derar, a gaire tarim le, a zogozogo le giz, a aotale giz, ko abi ipit eumilu, a keubu thri gerger E iako eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E paret kak detager abele mer. Ege Peteru abi datkimalu, a ditimeda abi daisumda. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ege E egremalu, a abara kaimeg giz dasmerauem, E Peteru daisumda, kega, Mama Satana, bakeam kara sorge; ma nole akiapor kak Ade ra lu, mamoro le la lu. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","E emetu le lakub, kemem abara kaimeg giz, darabgereda, E uiabi detagereda, kega, Nerute le laglag kari narmili, mamoro E tababu obogai, a abara satauro bakuar, a kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Abelelam ese nerute le laglag abara eded asisiem abele ko abi; epe ese nerute le abara eded abi, karielam pako Euangelia, abele ko ededem. ");
INSERT INTO ulk1902_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Abelelam ese nerute le geseb ge uridili terapei, a abara eded abi, nalu bodomalam abim? ");
INSERT INTO ulk1902_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nade lu le ikuar abara eded bodomalam? ");
INSERT INTO ulk1902_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Abelelam ese nerute le kari sirip ge, pako kara mer, eipu abele nosik adud le pako eruam le, abkoreb Le la Uerem ko abi sirip ge, E tabarki kemem gaire angela zogo, abara Aba zorom ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","E uiabi daratagereda, kega, Ageakar, kaka uabi detagereda, kega, Uader gaire le ge tekue, nole eud kak, kekiam uiaba Ade ra baselaia dasmerauem tabarki kemem adgiri. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Eseamuda abele gaire gerger sikes, Iesu Peteru tegadare, a Iakobo, a Ioane, a uiabi taraisare tumem perepere paser, uiaba tepteb: abara gem uiabi opem depegemelu. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Abara am uali zoromzorom, kakekake mokakalam kiona ise; le ogarup umer kak ko kakekake mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Elia a Mose uiabim paret kak; a uiaba mer atager Iesuim. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peteru Iesui detager, kega, Opole ae, debele meriba emri ike, keriba thri nole niai meta akerare; mara nerute, Mose ra nerute, a Elia ra nerute ko. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","E nole akiapor kak abele mer E detager; abelelam uiaba au geum. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Uiaba natkamda baz de; abele kodo mer teosmeda bazelam, kega, Kara Uerem nasge idali: uaba mamor abim asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sobkak uiaba bager, a nole le asmer kak, epe Iesu tepteb uiabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Uiaba paserlam tabatueli, Iesu uiabi mer tigri, uiaba nole atomeret kak abele lu uiaba emetu dasmerare, pe kekiam Le la Uerem eded akaida eudelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Uiaba abele mer mamor asesered, a uiaba mer atager tonar abele eded akaida eudelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Uiaba abi eutumer, kega, Nako, aotale giz detagereda, kega, Elia ko kekiam tabarki? ");
INSERT INTO ulk1902_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","E uiabi detagereda, kega, Ageakar, Elia ko kekiam tabakeam, gaire lu ko barditug; mokakalam emetu detali Le la Ueremlam, E ko au asiasi, a abi desauersili. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kaka uabi detagereda, kega, Elia emetu tabarki, uiaba emetu abim ikeli uiaba lag, mokakalam emetu detali abielam. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Uiaba abara kaimeg giz tabarki, uiaba dasmer gaire le lakub uiabi dog deraueili, a aotale giz uiabim mer atager. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Uiaba uridili abi dasmerare, sobkak uiaba damreda, a abim koreder kega, Maiem. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","E aotale giz itmer, kega, Nako uaba uiabi mer atager? ");
INSERT INTO ulk1902_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nerute le kublam detaut, kega, Tarim le ae, kaka marim tegardelu kara uerem, nagri lamar te dabim dabim; ");
INSERT INTO ulk1902_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","E abi erpei, a E darbor: E serur ge, a tereg ikupmaretili, a gem kerar: kaka emetu mara kaimeg giz detager, ko abi imuda; epe uiaba umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","E uiabi detaut, kega, Uaba nosik oatur kak, nade mop kaka uabi dog emerili? nade mop kaka uabi mabus? E karim tegaret. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ui abim tegaret Iesuim; E abi dasmer, sobkak uit lamar abi darbor; a E sebge ekesmeri, a epeteli, a serur ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu abara aba itmer, kega, Na kerker abele lu abim tabarki? E detaut, kega, Ditimeda kebi uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Gaire kerker E abi ur ge batauered, a ko ni batauered, ueakai abi ipit eumilu: ese mama umele, ma keribi upinati, a keribi omare. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu abi detager, kega, Ese mama umele! Gaire lu eseamuda umele abi abele le oituli ");
INSERT INTO ulk1902_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sobkak abele uerem ra aba ereretikri, a ezoli detagereda, kega, Opole, kaka oituli, kara kebi oituli upinati. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu gaire le lakub dasmer netat gedim koreder, E uit lamar daisumda, a abi detager, kega, Mama lamar te dabimdabim a grip batapili, kaka marim mer tigri, abielam toesmeda, a nole abi nerkep ge iako barot. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","E ereretikri, a abi darbor, a tosemeda; abele uerem mokakalam le eud; iueakai gaire le batagereda, kega, E dali eumida. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Iesu abara tag datkimoartare, a abi tekuelu; E tababu tekue. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesu meta ge barot, abara kaimeg giz gumik abim eutumer, kega, Nalugem keriba umer kak abim imuare? ");
INSERT INTO ulk1902_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","E uiabi daratagereda, kega, Abele lu mokakalam nole tabarki, mamoro esorerapare, a leuer baili tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Uiaba ab gedelam teosmeda, a eipu Galilaia nakaseredi; E nole lakak nerute le abi dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Iesu abara kaimeg giz ereuerem, a uiabi detagereda, kega, Le la Uerem ko emarida uiabim gaire le la tag, uiaba ko abi ipit eumilu; uiaba emetu abi ipit eumilu, E iako eded akaida keubu gerger thri. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Epe uiaba nole akmer kak abele mer, ui geum ko abim eutumer. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Uiaba Kaperanauma tabarki; E muige meta, E uiabim eutumer, kega, Nalu uaba gab ge basareda? ");
INSERT INTO ulk1902_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Uiaba baziguar: abelelam uiaba gab ge basared, nete aule. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu emri, a tuelf le dabgeri, a uiabi detagereda, kega, Ese nerute le laglag ko kekiam, E uiaba uridili sorge ekasered, a E uiabim uridili memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","E nerute kebi uerem egaret, a abim ekueilu uiaba opem: a tag ge erpei, E uiabi detagereda, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Abele le nerute uerem mokakalam egaret, muige kara nei, E kari nagaret: a abele le kari nagaret, E nole kari nagaret tepteb, mamoro E dali kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioane abi detaut, kega, Kole ae, keriba nerute le erdali demoni giz imuda mara nei de: E nole meribi armili kak, ki emetu abi daisumda, abelelam E nole meribi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Epe Iesu detager, kega, Nole abi asiumdar kak; nole nerute le adigir ikeli, muige kara nei, ko sobkak kari nasauersili. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Abele le nole meribi dedkoli, E meribi kemem. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Abele le ni sor uabi ikuar, abelelam uaba Keriso ra boai, ageakar, kaka uabi detagereda, nole ab kak bodomalam abim. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ese nerute le dedkoli nerute kebile kari oituli, debele abim idid baker abara pereg didbare, a E gurim batimed. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ese mara tag mari nadkoli, ismi adem; debele ma ededem barot netate tag, a adud neis tag gena barot, abele ur asam kak: ");
INSERT INTO ulk1902_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Abele nole eud kak uiaba gegedar, a ur asam kak niaiem. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ese mara teter mari nadkoli, ismi adem; debele ma ededem barot netate teter a adud neis teter genaim batauered, abele ur asam kak niaiem: ");
INSERT INTO ulk1902_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Abele nole eud kak uiaba gegedar, a ur asam kak niaiem. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ese mara pone mari nadkoli, dikiamur; debele ma Ade ra baselaia barot a netate pone, adud neis pone gena ra ur batauered: ");
INSERT INTO ulk1902_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Abele nole eud kak uiaba gegedar, a ur asam kak niaiem. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gaire le uridili ko sol ur de. ");
INSERT INTO ulk1902_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol debe lu: ese nole kurabkurab, nako uaba iako kurabem? Uaba sol mamoro nagri muige uabi nerkep ge, uaba ko demeger nerute a nerute. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E ab gedelam tekue, a bakeam Iudaia nener ge abele Ioridano apek; iako gaire le netat gedim abim; E uiabi ereuerem, mokakalam abara tonar. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Faresaio giz tabakeuare, a uiaba abi eutumer, kega, Nako, gelar nagri nerute le abara kosker dituaki? Uiabi abi mirem. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ege E uiabi detaut kega, Nako Mose uabi mer tigri? ");
INSERT INTO ulk1902_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Uiaba detager, kega, Mose de emarida ko jauali detali, epe kosker dituaki. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu uiabi detaut, kega, E detali abele gelar abelelam uaba nerkep kelarkelar. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Emeret ditimeda gaire lu detagem, Ade uiaba detagem kimiar, a kosker. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Abelelam, kimiar abara aba a apu dekaerti, a abara kosker ekpi; ");
INSERT INTO ulk1902_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Uiaba neis le netat gem; iako nole neis gem, epe netat gem. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Abelelam, Ade de daratkaprida, nole le atakeamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Muige meta, abara kaimeg giz iako abi eutumer tonar abele mer. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","E uiabi detagereda, kega, Ese kimiar abara kosker dituaki, a ko nerute tegared, E abi kogem: ");
INSERT INTO ulk1902_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ese kosker abara kimiar dituaki, iako nerute tegared, E kogem. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Uiaba gaire kebile abim tegardare, ueakai E uiabi itut; abara kaimeg giz uiaba gaire le tegardare daisumdarare. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu dasmer, abara nerkep asiasi, E uiabim detagereda, kega, Kebi omasker karim taramarkare, nole uiabi aisumdar kak; abelelam, Ade ra baselaia uiabi koreb. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ageakar, kaka uabi detagereda, kega, Ese nerute le Ade ra baselaia nole erpei kak mokakalam kebile, E nole abele ge badare. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","E uiabi egared, a abara tag uiabi tumge ikedi, a debe mer uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu gab ge ekasered, nerute le kei koreder temerida, a abim kokomam, a abim eutumer, kega, Debe Kole ae, nalu kara dorge ikeli ueakai kaka nagri eded aseamur kak? ");
INSERT INTO ulk1902_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu abi detager, kega, Nako ma nagali kaka debele? nole nerute debele, epe Ade tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mama gelar giz umele, kega, Ma nole ipit eumilu; Ma nole ko kak; Ma nole eruam kak; Ma nole bes mer nerute le ataut kak; Ma nole nerute le okardar kak; Ma mamoro mara aba a apu naospereie. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","E Iesuim detuat, kega, Kole, kaka emetu irmili abele gaire lu kebi ueremlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu abi dasmer, a abi omare, a abi detager, kega, Netate lu ma nolea; bakeamu, a mabara lu terapei, a gaire le lu kak nakuarare, iako mara lu nagri kotor ge; a tabakeam satauro ekadar, a kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Abara nerkep beber abele merlam, a E ezoli bakeamuda; abelelam E lu giz ra apu. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu dasmer deraueili, a abara kaimeg giz detagereda, kega, Au sagim lu giz ra apu ko barot Ade ra baselaia! ");
INSERT INTO ulk1902_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abara kaimeg giz au geum abele abara merlam. Iesu iako uiabi detagereda, kega, Kara omasker, au sagim gaire le lu lag Ade ra baselaia barot! ");
INSERT INTO ulk1902_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela norgor ko badari atketelu nebge, a le lu giz ra apu etkoprida Ade ra baselaia bardari. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Uiaba au geum, a mer atager, kega, Nete le umele ko eded? ");
INSERT INTO ulk1902_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu uiabi dasmer, a detagereda, kega, Le nole umer kak abele, Ade umele, E umele gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peteru ditimeda ko abi detager, kega, Dasmer, keriba emetu dekaer keriba lu uridili, a mari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu detaut, kega, Ageakar kaka uabi detagereda, kega, Ese nerute le meta dekaer, a keimer giz, a berbet giz, a aba, a apu, a abara kosker, a uerem giz, a ged giz, karielam, a euangelia, ");
INSERT INTO ulk1902_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Peirdi abele gerger, E iako egared uan handed meta, a keimer giz, a berbet giz, a apu giz, a uerem giz, a dordor ged, asiasi kemem; kerker ge niaiem eded aseamur kak ko egared. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","A gaire le kekiam ko keubu; a gaire keubu ko kekiam. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Uiaba Ierusalemaem gab ge ekasered; Iesu kekiam bakeam: uiaba damreda; a abi irmili geum. E iako gaire tuelf le tegared, a ditimeda ko uiabi detagereda abele gaire lu abim ko tabarki, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Dasmer, mi Ierusalemaem nogi; uiaba Le la Uerem emarik uiabim tarim giz, gaire zogozogo le, pako aotale giz; uiaba ko abim mer akesmur ko eumida, a uiabim gaire nogle nakuarare: ");
INSERT INTO ulk1902_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Uiaba ko abi neg degarare, a abi damerik, a abi mos akeida, a abi ipit eumida; abele gerger thri, E iako eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Iakobo a Ioane, Zebedaio ra uerem giz, Iesuim tabarki, a detager, kega, Kole ae, ki laglag mama keribim ikeli abele lu ki lagelag. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","E uiabi detagereda, kega, Nalu lu ua laglag kaka uabim ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Uiaba abi detagereda, kega, Keribi dekuar ko keribi emri, nerute tuter pek, a nerute ber pek, mara zorom ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iesu uiabi detagereda, kega, Uaba nole umer kak abele lu uaba damseda. Nako, uaba umele ko tanelu ereli kaka ko are? a bapataiso egared kari bapataiso? ");
INSERT INTO ulk1902_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Uiaba abi detagereda, kega, Ki umele. Iesu uiabi detagereda, kega, Uaba ko tanelu ereli kaka ko are; a bapataiso egared kari bapataiso: ");
INSERT INTO ulk1902_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Epe ko emri kara tuter pek, a kara ber pek, nole kara dorge nakuar; mamoro uiabim emetu derser. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ten le asoli, uiaba ditimeda Iakobo a Ioane urker. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Epe Iesu uiabi dabgerare, a uiabi detagereda, kega, Uaba umele uiaba tonar dikiapor sirdam gaire nogle, a uiaba kabdigili; a gaire aule uiabi sirdam. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nole mokakalam uabi dog: ese nerute le uabi dog laglag ko aule, debele E uaba memeg le: ");
INSERT INTO ulk1902_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ese nerute le uabi dog laglag kekiam, E memeg le uabim uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mokakalam Le la Uerem nole tabarki memeg le taraisare, mamoro E uiabim memeg le, a abara eded nakuar ko eded bodomalam uiabim gaire le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Uiaba Ieriko tabarki: Iesu a abara kaimeg giz kemem gaire le lakub osmeda Ierikolam, nerute le pone sademer gab deg emri, E lu damos, abara nei Baratimaio, Timaio ra uerem. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","E asoli abele Iesu Nazaretalam, E ditimeda ereretikri, kega, Iesu Dauida ra uerem, kari omare. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dordor le abi daisumdarare ko baimilu: E elele ereretikri, kega, Dauida ra uerem, kari omare. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu tekue, a detager, kega, Abi dabgeri. Uiaba sademer le dabgeri, a abi detager, kega, Saserimem: tekue, E mari dabgeri. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","E abara am uali adem, a tekue, a Iesuim bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu abi detaut, kega, Nalu ma laglag kaka marim ikeli? Sademer le abi detager, kega, Raboni ae, kara pone iako bakaerti. ");
INSERT INTO ulk1902_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu abi detager, kega, Bakeam, ma eded mabi oatulam. E sobkak pone bakaerti, a Iesu irmili abele gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Uiaba maike Ierusalema, a Bethefage, a Bethania, abele paser ge Oliua, Iesu namarida neisi abara kaimeg giz, a uiabim detager, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ua bakeamlam abele ged uaba opem: ua abele tabarki, ua ko dasmeram asina ra uerem didbarda, abi sor agimur kak; abi detue, karim tegared. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ese nerute le uabi detager, kega, Nalu uaua ikeli abele? ua detautam, Opole abi laglag: E sobkak abi emarida. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ui bakeamulei, a asina ra uerem erdali abele mai gab ge esakri didbare; ui abi detue. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Uader le abele ekue, ui detager, kega, Nalugem ua asina ra uerem detue? ");
INSERT INTO ulk1902_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ui ge uiabi detagereda mokakalam Iesu mer tigri: epe uiaba ui namariklam. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Uiaba asina ra uerem Iesuim egardale, a uiaba dordor am uali abi sorge dikmerikare; a E abi sorge egimulu. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gaire le lakub uiaba dordor am uali gab ge esegarare: uader lu tam ismi, a gab ge esegarare. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Uiaba kekiam le, a uiaba armi le, ereretikri, kega, Hosana; Uerkab abele le Opole ra nei tabarki: ");
INSERT INTO ulk1902_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uerkab Dauida ra baselaia, meriba aba, tabarki Opole ra nei: Hosana gaire lu tum ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu Ierusalema tabarki, a zogo meta ge badari; E deraueilu dasmer gaire lu uridili; kikem E Bethania nakaseredi, kemem gaire tuelf le. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Iuaokaer, uiaba tabakeuare Bethanialam, E uerer ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","E suke erdalu muriz ge lam nagri, E bakeam dasmer, ese turum nagri: E abele tabarki, E no lam dasmer; nole tabarki kerker turum. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ege E suke detager, kega, Nole le mara turum aro kak niai karem. Abara kaimeg giz asereda. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Uiaba Ierusalema ge tabarki; Iesu zogo meta ge badari, a ditimeda uiabi daratirieda gaire le lu terapeirare zogo meta muige, a bau lu terapeirare eraskida, a uiaba dibadib terapeirare, uiaba gaire sik eraskida; ");
INSERT INTO ulk1902_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pako E nole nerute le amari kak tanelu tais zogo meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iesu uiabi ereuerem, kega, Nako, nole autar kak, Ko kara meta nei atker, kega, Esorerapare meta uiabim gaire le uridili? epe uaba emetu depegereda abele mokakalam baker kur ge uiabim gaire eruam le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aotale giz asereda, a zogozogo le giz, uiaba deraimer ko abi ipit: uiaba abi geum, abelelam gaire le lakub abara ereuer damereda. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Gaire kikem, E osmeda ab gedelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Idim ge, uiaba gab ge ekasered maike abele suke, ui dasmer abele suke ekeamulu giz ge ditimeda. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peteru dikiapor, epe abim detager, kega, Rabi, dasmer, abele suke mama desauersili, abele ekeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu uiabim detaut, kega, Ua ko Adim oituli. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ageakar, kaka uabi detagereda, kega, Ese nerute le abele paser ge mer detager, kega, Ma eupumar, a gur ge baraigida; a nole abara nerkep emarili, E ko egared abele mer E detager, oitulilam. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Abelelam, kaka uabi detagereda, kega, Gaire lu uridili uaba damos esorerapare ge, oituli uaba ko nagri, epe uaba ko nagri. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ua taba ko esorerapare, ese nerute le uabi dedkoeda, abi emariklu; iako uaba Aba kotor ge uaba uit emarik. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ese uaba nole emarik, iako uaba Aba, kotor ge, nole uabi uit giz emarik. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Uiaba iako Ierusalema takomeda: E muige zogo meta ekasereder, epe zogozogo le giz abim tabakeuare, a aotale giz, a au le giz; ");
INSERT INTO ulk1902_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","A abi detager, kega, Nalu abele sirdam mama ikeli abele gaire lu? a nete le marim ikuar abele sirdam ko mama ikeli abele gaire lu? ");
INSERT INTO ulk1902_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu uiabi detager, kega, Kai uabim eutumer nerute mer, ese ua kari natautare, kaka ko uabi detagerare abele sirdam kaka ikeli abele gaire lu. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioane ra bapataiso, nako kotorlam, nako lelam? kari nataut. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ege uiaba mer atagere, kega, Ese meriba detagerare, kega, Kotorlam; ege E detager, kega, Nalugelam uaba nole abi agared kak? ");
INSERT INTO ulk1902_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ese meriba detagerare, kega, Lelam: uiaba geum gaire lelam, abelelam gaire le uridili Ioane egared mokakalam perofeta kar. ");
INSERT INTO ulk1902_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ege uiaba Iesuim detaut, kega, Keriba umer kak. Iesu uiabim detager, kega, Kaka nole uabi atager kak abele sirdam gaire lu kaka ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu ko ditimeda uiabim detager gaire mer babisdarie, kega, Nerute le uina gedub akerare, a kar derumeda, a uak dakeili ko uina igmesi, a eskare emoarare, a gedub le nakuarare, a muriz ged bakeamuda. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nurge, E nerute memeg le mamarida uiabim gaire gedub le, ko uina turum taisare uiabielam. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Uiaba abi terpei, a abi damarik, a abi dituaki, nole lu kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","E iako uiabim nerute memeg le namarida; a ui bakiru abi erborare, abara kerem nakesmuare a emetu dedkoare, uiaba abi dituaki. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","E iako nerute namarida; a uiaba abi ipit eumida: a ko uader gaire; a uader damarik, a uader ipit eumida. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","E nagri netat uerem nasge: E keubu abi namarida uiabim, kega, Uiaba ko kara uerem geum ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Uiaba gaire gedub le mer atagere, kega, Ab kesem peik; tabakeuare, meriba abi ipit, a gaire abara lu, meriba lu. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ege uiaba abi terpei, a ipit eumida, a adige batauerem uina gedublam. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Uina gedub ra opole nalu ko ikeli? E ko tabarki a uiabi gedub le atkirua, a uina gedub uader le nakuarare. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nako uaba nole jauali zogo atager kak, kega, Abele baker uiaba gaire le meta emorare dituaki, emetu ikeli abele meta serer ge: ");
INSERT INTO ulk1902_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Abele lu Opole de ikeli, meriba dasmerare, a damareda? ");
INSERT INTO ulk1902_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Uiaba deraimeri ko abi terpei, epe uiaba gaire le lakub geum ge; abelelam uiaba umele abele mer babisdarie E uiabi detager: uiaba abi dikaerti, a bakeamuda. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Uiaba uader Faresaio giz Iesuim namarida, a Herodiano giz, ko abara mer asesered. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Uiaba tabarki, a abi detager, kega, Kole, keriba umele mama le ageakar, a nole le geum kak; ma nole akiapor kak le la op, mamoro Ade ra gab ageakar ereuerem: Nako, barkak Kaisaraim lu nakuar, a nolea? ");
INSERT INTO ulk1902_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nako, keriba ko ikuar, a keriba nole akuar kak? Epe E opasereret uiaba okardare, a uiabim detager, kega, Nalugelam uaba kari mirem? denari kari nakuar, kaka dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Uiaba nerute tais, E uiabi detager, kega, Abele nete ra op, a aotale? Uiaba abi detager, kega, Kaisara. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iesu uiabim detaut, kega, Kaisara ra lu Kaisaraim nakuar, a Ade ra lu Adim nakuar. Uiaba abi damreda. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukaio giz abim tabakeuare, uiaba dikiapor nole eded akaida; uiaba abi nautumer, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ereuer le ae, Mose keribi detali, kega, Ese nerute le la keimer eumida, a abara kosker dikaerti, a nole uerem kak, abara keimer abele kosker egared, ko abi keimer kesem. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sefen keimer giz: abele narbet kekiam ko ispida epe eumida, nole kesem kak; ");
INSERT INTO ulk1902_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nerute keimer kosker egared, epe eumida nole kesem kak; mokakalam nerute keimer: ");
INSERT INTO ulk1902_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sefen keimer giz nole kesem kak. Keubu kosker eumida. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Niaiem, uiaba tekue abele eded akaida, nete ra kosker uiaba? Abelelam emetu gaire sefen le abi egared uiaba kosker. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu uiabim detaut, kega, Abele giz uaba didmirik, nako uaba nole umer kak jauali zogo, a Ade ra adigir? ");
INSERT INTO ulk1902_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ese uiaba eded akaida eudelam, kosker agared kak, a akuar kak; uiaba ko abkoreb gaire angela kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Abele eud le giz, ko eded akaida; nako uaba nole Mose ra jauali atager kak, Ade abi detager lulam, kega, Kaka Abarahama ra Ade a Isaaka ra Ade, a Iakobo ra Ade? ");
INSERT INTO ulk1902_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","E nole Ade kak eud le giz, mamor Ade gaire eded: abelelam uaba au didmirik. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nerute aotale giz kei tabakeam, E uiaba mer atager asoli, a opasereret Iesu de uiabim barkak detaut, E abi eutumer, kega, Nade aule gaire gelar uridili? ");
INSERT INTO ulk1902_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu abi detaut, kega, Abele aule gelar giz uridili, kega, Isaraela ma asoli Iehoua meriba Ade, Iehoua tepteb: ");
INSERT INTO ulk1902_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ma ko Iehoua laglag mara Ade, a mara nerkep netat, a mara mar netat, a mara saserim kemer kemer. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mokakalam abele gelar neisiem, kega, Ma ko omare le mari dog emeri mabi koreb. Nole nerut au gelar tumem abele neisi gelar. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aotale abi detager, kega, Uao Kole, ageakar mama detager; Ade netat; E tepteb: ");
INSERT INTO ulk1902_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Le abi laglag abara nerkep netat, a abara pereg netat, a abara mar netat, a abara saserim uridili, a omare le abi dog emeri abi koreb, abele lu kar tumem gaire lu nakuar uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu dasmer E barkak detaut, E abi detager, kega, Ma nole muriz kak Ade ra baselaia. Nole nerute le saserim ko abi eutumer. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu muige zogo meta ereuerem, a detager, kega, Nalugelam aotale giz detagereda, kega, Keriso Dauida ra uerem? ");
INSERT INTO ulk1902_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dauida detager Lamar Zogolam, kega, Iehoua kari Opole detager, kega, Ma emri kara tuter tag pek, pako kaka eseamuda mara keubu le giz ikedi ko mara teter mas. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dauida abara nei atker Opole; nalugelam E abara uerem? Le lakub abi sererge asoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu uiabim daratagered muige abara ereuerem, kega, Aotale giz dasmer, uiaba laglag nakasir perepere am uali, a laglag gaire le uetpur uteb ge uiabim naospereda, ");
INSERT INTO ulk1902_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","A uiaba laglag gaire op sik muige sunago giz, a gaire op sik uetpur ge: ");
INSERT INTO ulk1902_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Uiaba itkamer gaire lu muige meta mai kosker giz ra meta, a perepere esorerapare abele itkamare; uiaba ko nagri au uit bodomalam ko. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu mani epei op emeri, a dasmer uiaba tonar epei ge mani batauereda: gaire lu giz ra apu aule batauereda. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nerute mai kosker tabakeam, nole lu kak, a neis kebi mani natimeda, mokakalam netate fathen. ");
INSERT INTO ulk1902_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesu abara kaimeg giz darabgerare, a uiabim daratagereda, kega, Ageakar, kaka uabi detager, kega, Abele mai kosker, nole lu kak, abele batauereda mani epei ge uiabi uridili tumem batauereda: ");
INSERT INTO ulk1902_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Abelelam uiaba uridili batauereda uiaba au lu giz ra apulam; E natimeda uridili nole lu kaklam, abele abara leuer terapei. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ege E teosmeda zogo metalam, nerute abara kaimeg giz abi detager, kega, Kole, dasmer, gaire au baker a gaire meta giz! ");
INSERT INTO ulk1902_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu abi detaut, kega, Ma dasmer gaire au meta giz abele? nole nerute baker ko igi tumem nerute baker, a nole abu kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu tumem paser ge Oliua emeri, zogo meta op, Peteru a Iakobo a Ioane a Anederea gumik abim eutumer, ");
INSERT INTO ulk1902_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ma keribi detagerare abele kerker ko tabarki abele gaire lu, a nalu atamelam abele gaire lu uridili ko tabarki? ");
INSERT INTO ulk1902_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ege Iesu uiabim detaut, a ditimeda detager, kega, Mamoro dasmer nerute le uabi okardare; ");
INSERT INTO ulk1902_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Abelelam gaire le ko kara nei ge tabarki, a detager, kega, Kakanali Keriso; a gaire le didmirki. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Uaba barseda aserare, a barseda daratagereda, nole geum kak; abkoreb abele kekiam tabarki; mop uarem. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Abelelam nerute ged tekue obapit nerute ged, a nerute baselaia obapit nerute baselaia: a demali ko nagri uader ged, a memeig giz tabarki, a urker: abele ditimeda giz gaire asiasi. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Uaba mamoro dasmer; uiaba uaba kotem emarik; a uaba ipit sunago ge; a uaba tegared gauana giz a au opole giz ra op karielam, uiabim atamelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Abkoreb kekiam euangelia marau uiabim gaire ged uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ese uiaba uaba tegared, a uaba emarida, uaba nole kekiam deraimeri a dikiapor na mer ko detager; abele gerger ua ko detager, abele mer uabi nakuar; a nole uaba detager, mamoro Laniar Zogo. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nerute keimer abara keimer emarida ko eumida, mokakalam aba abara ueremem; a uerem giz tekue obapit uiaba aba a apu, a ui emarida ko eumida. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gaire le ko uabi derar kara neilam, ese nerute le erpei mop ge tabarki, E ko eded. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ese uaba uite lu dasmer atkolam, Daniela perofeta emetu detager, tekue nug uteb ge, (le etage mamoro dikiapor,) kerker peik, uiaba gaire le Iudaia emeri ko paser ge koreder: ");
INSERT INTO ulk1902_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ese le meta tumge emeri, E nole muige meta abu kak, a nole abara meta badari ko nerute lu tais: ");
INSERT INTO ulk1902_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ese le gedub emeri, E nole akomeret kak, tabara am uali tais. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Uaiai uiaba gaire kosker kem kem, a uiaba nano emeli abele gerger giz! ");
INSERT INTO ulk1902_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Uaua ko bamereda, ueakai abele lu nole nur ge tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Abelelam ko au asiasi abele gerger giz, nole mokakalam ditimeda gaire lu Ade detagem pako irdi, a nole mokakalam niaiem. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ese Opole nole tuprik abele gerger giz, nole le kak umele eded: Epe E tuprik abele gaire gerger, uiabielam gaire le depegili, E digmiri. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ese nerute le uabi detager, kega, Dasmer, Keriso ike; a dasmer, Keriso idali; nole uaba abi asor kak: ");
INSERT INTO ulk1902_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Abelelam gaire Keriso bes, a gaire perofeta bes ko tabarki, a uiaba natomertare gaire atamelam a gaire adigir, ko didmirki gaire le depegili, ese umele. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Uaba ko dikiaporare: dasmer, kaka emetu uabi detagereda. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Keubu abele gaire gerger asiasi, lem au kupikup nole be kak, a meb nole meb gerib kak, ");
INSERT INTO ulk1902_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","A kotor uer giz nabuda, a gaire kotor adigir deskerdi. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","A uiaba ko dasmer Le la Uerem baz giz ge tedegemele, kemem au adigir a zorom zorom. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","E tabara angela giz namarida, ko taraisare abara le giz emetu depegili foa uag peklam, ditimeda geseb, paikai ge pako kotor paikai ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Uaba ko ereuerem abele mer babisdarie abele suke: girkupi tam, a lam eperekili, uaba umele bar maike; ");
INSERT INTO ulk1902_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mokakalam, ese uaba dasmer abele gaire lu tabarki, mamoro dikiapor, abele kerker maike abele gab te. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ageakar, kaka uabi detager, kega, Nosik le peik nole abu kak, kekiam abele gaire lu tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kotor ge a geseb ge ko abu; a kara mer giz nole abu kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Epe abele gerger pako haua iamdali le nole umer kak, angela giz kotor ge nole umer kak, a Uerem nole umer kak, epe Aba tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Uaba mamoro dasmer, a derser, a esorerapare; abelelam uaba nole umer kak abele gerger. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mokakalam le muriz gedim bakeam, tabara meta dekaerti, a tabara memeg giz sirdam nakuarare, a le gab te asesere abi mer tigri ko derser. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Abelelam ua ko derser: abelelam uaba nole umer kak abele gerger meta ra Kole ko tabarki, ese kikem, ese eip ki, ese kimiar faul ereretikri, ese idim ge: ");
INSERT INTO ulk1902_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Epe E sobkak tarabarakua, a uabi erdali uteid. ");
INSERT INTO ulk1902_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Abele mer kaka uabi detagereda, kaka uiabim gaire le uridili detagereda, Derser. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Neis gerger iobaru, paseka akerare, a areto nole isi kak; zogozogo le giz, a aotale giz ko deraimeri abi terpei okardarem, a abi ipit eumida. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A uiaba detager, kega, Nole abele ikeli uetpur ge, iaueakai abele ged ataperetlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","E emri Bethania, muige Simona lepera ra meta, E emri leuer aroem, nerute kosker abim tabakeam nagri alabasa tarpor, muige muro ido lu; E emetu tarpor daraturumda, E abi kerem ge epaiteredelu. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Uader le urker, a mer mer, kega, Nalugelam abele muro epaitered? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Abelelam ese emetu terapei, abele bodomalam tumem thri handed denari a ko ikuarare gaire le lu kak. A uiaba abi urker. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Iesu detager, kega, Nole abi ataperet kak; nalugem uaba abi bamsili? abelelam E debe dorge karim ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abelelam le giz nole lu kak no uabi dog emeri, uaba umele uiabim debe dorge nakeli abele gerger uaba laglag; epe kaka nole niai emeri uabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kosker emetu ikeli abele lu E umele: E kekiam kara gem dedered kari natkobei. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ageakar, kaka uabi detagereda, kega, Gaire ged uridili geseb ge ko euangelia marao, abele ko etomeret kosker ra dorge, mena ko dikiapor abim. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nerute le, abele tuelf lelam, nei Iuda Isakariota, E bakeam uiabim zogozogo le giz, ko abi keserkeser uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Uiaba asereda, uiaba sererge, a abi detager ko mani abi ikuar. E deraimeri ko Iesu keserkeser. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Abele kekiam gerger areto nole isi kak, abele kerker uiaba paseka ipit, abara kaimeg giz abi detager, kega, Nade uteb mama lag keriba ko paseka ero? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","E neis abara kaimeg giz namariklu, a uiabi detager, kega, Ua bakeamulei utebem, nerute le uabi obapit a nini tarpor erpei: abi irmilei; ");
INSERT INTO ulk1902_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","E abele ge badari, uaba meta kemle detagereda, kega, Kole de detager, Nade suble uteb, kaka a kara kaimeg giz paseka eroarem? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ege E uabi degeredi nerut au uteb kotor, emetu derser a eseger: a uaba ko derser keribim. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abara kaimeg giz neis bakeamulei, a uteb ge tabarki, a erdarei mokakalam E uiabi daratager; epe uiaba paseka derser. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kikem Iesu a tuelf le kei tabarkeda. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Uiaba baido, a leuer eroare, Iesu detager, kega, Ageakar, kaka uabi detagereda, kega, Nerute uabielam kari keserkeser, abele le kari dog eroli. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Uiaba ditimeda okasosok, a abi detager, kega, Nako kaka? a nerute kega, Nako kaka? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu uiabim detaut, kega, Nerute uaba tuelf lelam, le itili kari dog tanelu ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Le la Uerem bakeamulu mokakalam abim detali: epe uaiai abele le Le la Uerem keserkeser! debele abele le nole aosmer kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Uiaba eroare, Iesu areto ekao, a esoao, a itur a uiabi nakuarare, a daratagerare, kega, Tekao aroem: kara gem ike. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","E tanelu ekao, a esoao, a uiabi nakuarare: a ui uridili areem. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","E uiabi daratagereda, kega, Kara mam ike, abele kerkar gelar, epaitered uiabim gaire dordor le. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ageakar, kaka uabi detagereda, kega, Kaka nole iako aree kak abele uina turumlam, kekiam tabarki abele gerger kaka ko aree kerkar uina Ade ra baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Uiaba emetu uedakiriare nerute ued, uiaba Oliua paserem bakeamuda. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu uiabi daratagereda, kega, Uaba uridili ko ezigmada karielam abele ki ge: emetu detali, kega, Kai le mamoe asesered ipit, epe mamoe giz kepu bamarida. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Emetu kaka eded akaida, kaka kekiam bakeam Galalaiem a uaba keubu. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peteru abi detager, kega, Ese ui uridili marim ezigmada, kai nolea. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu abi detager, kega, Ageakar, kaka mari detager, kega, Thri ma ko kari nasared, abele ki ge, a kimiar faul nole neisi ereretikri kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","E iako elele detager, kega, Ese kaka mari kemem naumilu, kaka nole mari asared kak. Uiaba uridili daratagereda abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Uiaba nerute utebem tabaruda, nei Gethesemane: E abara kaimeg giz daratagereda, kega, Uaba bameri ike, kai esorerapare. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","E Peteru, a Iakobo, a Ioane taraisare, a ditimeda ko okasosok, a nerkep okabatageli; ");
INSERT INTO ulk1902_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","E uiabi daratagereda, kega, Kara mar au asiasi bakedid abele eud; ua ge bamer, a derser. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E kebi kebi bakeam, a seb ge etkobeilu, a esorerapare, ko abele haua abielam abi, ese umele. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","E detager, kega, Aba, Baba, mama umele gaire lu eseemuda; karielam ekao abele tanelu; epe nole kara lag ikeli mabara lag ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","E ko akomed a uiabi erdali uteid, E Peteruim detager, kega, Simona, ma uteid? ma nole saserim kak ko derser netat haua ge? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ua ko derser, a esorerapare, ueakai uaba nole mirem barot: lamar saserim, epe gem gebgeb. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iesu iako bakeam ko esorerapare, a detager abele netat mer. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","E iako takomeda, a uiabi erdali iako uteid, abelelam uiaba pone beber, a uiaba umer kak nerute mer abi detaut. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iesu thri tabakeam, a uiabi daratagereda, kega, Ua ko uteid, a nerbazi; sina, haua ike; dasmer, emetu Le la Uerem keserkeser uiabim gaire uit le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bako, mi nabakeuare; dasmer, E maike le kari keserkeser. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","E abele mer detager, sobkak Iuda tabarki, nerute le tuelf lelam, a abi kemem gaire le uridili teibur tulik a gabagaba taraisare, uiabielam zogozogo le giz, a aotale giz, a au le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Abele le abi keserkeser uiabim daratagereda nerute atamelam, kega, Le kaka abi eskos, E dali; uaba abi erpeirare, a elele tegardare. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","E sobkak tabarki, E abim bakeam, a abi detager, kega, Rabi ae; a abi eskos. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Uiaba abim tag giz itrimuda, a abi terpei. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nerute le uiabielam tekue, a teibur aososo tulik iseda, a kole zogozogo le giz ra memeg le ipit, a abara laip ismilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu uiabi daratagereda, kega, Nako, ua tabakeuare karim eruam le ise, a gaire teibur aososo tulik, a gaire gabagaba kari tais? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaka uabi dog gaire gerger giz zogo meta ge okadeskeda, uaba nole kari arpeir kak; bakedilu eski abele zogo mer detali. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Uiaba uridili abi dekaerti, a koreder bameri. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nerute makeriam abi irmili, E aole a uali lino batkam: a makeriam giz abi erpeirare; ");
INSERT INTO ulk1902_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","E uali lino igilu, a aole uiabielam koreder ge bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Uiaba Iesu datkimuardare abim kole zogozogo le giz: gaire kole zogozogo le giz netate gedim abim, a aotale giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A Peteru muriz ge abi irmili, abele uteb meta ge, kole zogozogo le giz ra meta; E kemem emeri uiabi dog memeg le giz, a abi ur ge gebaugeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Gaire kole zogozogo le giz, pako gaire tarim le giz deraimerare abielam nerute tonar, ko abi ipit eumilu; epe nole ardar kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dordor le abielam bes mer detager, a dordor tonar mer uiaba detagerare. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Uader le bako, a abielam bes mer detagerare, kega, ");
INSERT INTO ulk1902_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Keriba asereda E detager, kega, Kaka, ko abele meta ezageri, tagu ikeli, a thri gerger kaka ko nerut ikeli, a nole tagu ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Epe nole netate gab uiaba mer detagerare. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Abele kole zogozogo le giz eipu tekue, a Iesuim eutumer, kega, Nako ma nole mer etkalu? nako mer uiaba tais marielam? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Epe E bazeguar, a nole mer kak. Ege kole zogozogo le giz iako abim eutumer, a abi detager, kega, Ma Keriso nali, Aosperera ra Uerem me? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu detaut, kega, Kakanali; uaba ko dasmer Le la Uerem adigir tuter tag emeri, a ko tabakeam gaire kotor baz giz ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Abele kole zogozogo le giz tababu tabara am uali etoat, a detager, kega, Epe nalu nerute merume le? ");
INSERT INTO ulk1902_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Uaba emetu asereda Adim op mer detagereda; nalu uaba dikiapor? Uiaba uridili mer nakesmur, kega, Abkoreb E ko eumida. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Uader le ditimeda abi mos itu, a abara op demdare, a abi detapiare, a abi detager, kega, Ma ko perofeta; a memeg le giz abi ipitare tag de. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","A Peteru lokod ge emeri, nerute neur, abele kole zogozogo le giz ra memeg, tabakeam; ");
INSERT INTO ulk1902_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","E Peteru erdali ur ge gebaugeli, E abi dasmer, a detager, kega, Mama nerute le kemem Iesu. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Epe E asared, kega, Kaka nole umer kak, kaka nole opasereret kak abele lu ma detager. E osmeda abele maisu ge; a kimiar faul ereretikri. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Neur memeg le iako abi erdali, a ditimeda detager uiabim akuelem, kega, E dali nerute uiabielam. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E iako asared. Nole uapum kak, gaire akuelem iako abi detager, kega, Ageakar ma nerute le uiabielam, ma Galilaia le, ma uiabim netate kodomer. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peteru ditimeda adud mer egali, kega, Kaka nole umer kak abele le uaba detager. ");
INSERT INTO ulk1902_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kimiar faul neisiem ereretikri. A Peteru dikiapor abele mer Iesu abi detager, kega, Kimiar faul nole neisi ereretikri, ma ko thri kari nasared. E dikiapor, a E bazoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ege idim ge gaire kole zogozogo le giz, a au le giz, a aotale giz, pako gaire tarim le giz ko mer atagere; uiaba emetu Iesu didbare, uiaba abi egared, a Pilato nakuar. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato abi eutumer, kega, Nako mama Iudaia le giz ra Opole? E abi detaut, kega, Eko mama detager. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Zogozogo le giz gaire mer abi okadiridili. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato iako abi eutumer, kega, Ma nole ataut kak? dasmer gaire mer uiaba mari naridili. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Epe Iesu nole ataut kak; abelelam Pilato au damred. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Uetpur kerker E uiabim emarida nerute le didbar, uiaba laglag. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nerute le nei Barabasa, didbare gaire le opole basardare, uiaba le ipit eumilu abele kerker opole asaredelam. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gaire le uridili uiaba elele ereretikri, a ditimeda abim eutumer ko uiabim ikeli mokakalam ababur ge ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato uiabim detaut, kega, Nako, uaba laglag kaka uabi dakuarare Iudaia le giz ra Opole? ");
INSERT INTO ulk1902_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Abelelam E umele uiaba, gaire kole zogozogo le giz, Iesu nakuar kurablam. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gaire kole zogozogo le giz gaire le namarida, ko detager, kega, Barabasa keribim emarik. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato iako uiabim detaut, kega, Nalu lu uaba lagelag kaka ikeli abim, abele le uaba nei atker Iudaia le giz ra Opole? ");
INSERT INTO ulk1902_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Uiaba iako ereretikri, kega, Abi satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato uiabim detagereda, kega, Nalu adud Eikeli? A uiaba elele ereretikri, kega, Abi satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato lagelag gaire le lakub ra nerkep ko sererge, E Barabasa uiabim namarida, a emetu Iesu damrik, E abi ikuar ko satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gaire ares le abi kebi metaem tegared, nei Praitorio, a ares le nosik taraisare. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Uiaba abi mamam am uali amer, zegerzeger lager euer aperem, a abi kerem dameare; ");
INSERT INTO ulk1902_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","A ditimeda ko abi detager, kega, Uaiai, Iudaia le giz ra Opole! ");
INSERT INTO ulk1902_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Uiaba abara kerem pater de ipit, a abi mosu iduare, a kokomamu, a abi erkepsam. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Uiaba emetu abi neg degarare, uiaba mamam am uali igi, a abara am uali ami, a abi adige tegared ko satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Uiaba nerute le Kurene namarida abara satauro kodrom, Simona nei, E uiabi dog maike bakeuda sumezlam, abele le Alesandero a Rufa ra aba. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Uiaba abi tegared abele uteb Gologotha, tonar abele, Kerem lid ra uteb. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Uiaba abi ikuar uaina etaperet okakis muro: epe E nole erpei kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Uiaba emetu abi satauroem, uiaba abara gaire am uali uaderapei, a luglug ikeli, nete de ekadare. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Opem abele haua thri, uiaba abi satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Abele jauali detali abara tonarlam etomeret, kega, IUDAIA LE GIZ RA OPOLE. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Neisi eruam le kemem abi dog satauroem; nerute le abi tuter tag, a nerute le abi ber tag. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bakedida iski abele zogo mer emeret detali, kega, Netat abim babei kemem uite le giz. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Gaire le satauro seb ge nakasir desauersili, a kerem dirilare, kega, Ma zogo meta ezageri, a thri gerger ko ikeli, ");
INSERT INTO ulk1902_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ma mabu idigiri, a sataurolam uatabu. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mokakalam gaire kole zogozogo le giz abi desauersili, a aotale giz, kega, E uader le idigir, a nole umer kak tababu idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Debele Keriso, Isaraela le giz la Opole, peidi uatabu sataurolam, keriba abi dasmer, a oituli. Abele neisi le kemem abi satauroem abi desauersili. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Opem haua sikes, kupkup ged ge uridili bakedilu abele nain haua. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Abele nain haua Iesu au ereretikri, kega, Eloi, Eloi, lama sabakethani? tonar abele, Kara Ade, kara Ade, nalugem ma kari nakaerti? ");
INSERT INTO ulk1902_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Uader le bako, aserare, uiaba detagereda, kega, Dasmer, E Elia dabgeri. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nerute le koreder, sap uinega akmei, a pater ge dasirilu, a abi ikuar ko eree, a detager, kega, Sina; mi dasmer, Elia ko uatabu abi tatkurda. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu emetu au ereretikri, Epe namarid tabara lamar. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Abele uali demed zogo meta muige tababu batoat, kotorlam a giz ge, ");
INSERT INTO ulk1902_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Abele kerem le, asesered netate handed ares le, abim opem tekue, erdalu tonar abara eumida, E detager, kega, Ageakar, Ade ra Uerem idali. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Gaire kosker giz tekue muriz ge dasmer; uiabi dog Maria Magadalena, a Maria kebi Iakobo ra apu, a Iose, a Salome; ");
INSERT INTO ulk1902_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Uiaba, Iesu irmilare E Galilaia ge, a abim dorge ikeli; a gaire kosker abi kemem irmilare Ierusalemaem. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kikem, abele derser gerger, sabath iuaokaer, ");
INSERT INTO ulk1902_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iosefa Arimathia le tabarki, le umele, a ekosili, E nerute le Ade ra baselaia naokaili; E saserim Pilatoim bakeam, a Iesu ra gem damos. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato karom ese E eumida: E kerem le, asesered netate handed ares le, dabgeri, a abi eutumer, kega, Nako, emeret E eumida? ");
INSERT INTO ulk1902_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","E asoli kerem lelam, E Iesu ra gem nakuar abim Iosefa. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","E uali lino mog terapei, a E tatkurda, a uali lino de abi sopem, a baker kur daiui abi azeriklu; a au baker erparik gab dimilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magadalena, a Maria, Iose ra apu dasmer abele uteb abi ikedilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Abele sabath iobaru, Maria Magadalena, a Maria, Iakobo ra apu, a Salome debe laglag lu terapei, uiaba ko Iesu ra kem dedered. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Uiaba aoem tabarki bane ge, abele kekiam gerger sefen, kerker lem eupamada. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Uiaba mer atager, kega, Nete de meribim baker erparik abele kur telam? ");
INSERT INTO ulk1902_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ui dasmer, a erdali baker emetu kei erparkei: au baker peik. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Uiaba aoem barot, a makeriam dasmer tuter pek emeri, zazer uali ame; uiaba bazigmaret. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","E uiabim detager, kega, Uaba azigmaret kak: uaba Iesu Nazareta le deraimer, abele le emetu satauroem; E iako eded akaida; E nole ike; dasmer abele uteb uiaba abi ikedi! ");
INSERT INTO ulk1902_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ua bakeamlam, a abara kaimeg giz a Peteruim detager, kega, E kekiam bakeamulu uabi opem Galilaiaem; uaba ko abi erdali abele uteb, mokakalam ababur ge E uabim detager. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Uiaba sobkak teosmeda, a koreder aolam; uiaba durdur, a orida: epe uiaba nole nerute le mer atager kak; abelelam ui geum ge. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu emetu eded akaida idim ge, abele gerger kekiam sefen, E Maria Magadalena kekiam paret kak osmeda, E sefen demoni ditrida abele koskerlam. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","E dali bakeamulu, a uiabim gaire le Iesu ra kemem natomelu, uiaba noge okasosok a bazoli. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Uiaba asereda Iesu eded akaida, pako E kosker paret kak osmeda, uiaba nole oatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Abele gaire lu iobaru, Iesu paret kak osmeda nerute tonar uiabim neisi uiaba boai, ui gab ge gedub bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ui bakeam a uiaba boai natomelu; epe uiaba ui nole oatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Keubu, Iesu paret kak osmeda uiabim gaire elefen le, uiaba aroem; E uiabi nakereda nole oatur kaklam, a kelarkelar nerkep, abelelam uiaba nole oatur kak abele gaire le abi dasmer E eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ege E uiabim detagereda, kega, Ua bakeuare gaire ged narida uridili, a ko euangelia marao uiabim gaire le uridili. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ese nerute le oituli, a emetu bapataiso, E ko eded: ese nerute le nole oatur kak, E ko eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abele gaire atamelam ko irmilare gaire le oituli: uiaba ko demoni giz dituaki kara nei de; uiaba ko detager uader ged ra kodomer; ");
INSERT INTO ulk1902_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Uiaba ko tabu giz erpei, ese uiaba eudeud lukup ereli, uiaba nole eud kak; uiaba ko tag giz gim le giz dikmerik, uiaba nadgirauem. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iesu Opole emetu uiabim daratagereda, iako abim bakuarda kotorem, a Ade ra tuter tag emeri. ");
INSERT INTO ulk1902_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ui bakeuare, a marao gaire ged uridili, Opole uiabi kemem dorge, a abele mer ageakarem, gaire adigir de irmili. Amen. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Abele mer gaire le giz elele detarare abkesem, abele mer keriba emetu erdarda, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mokakalam uiaba nakuarare keribim, ui ge emetu erdarare, pako memeg le giz ditimeda abele mer, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Abelelam kaka dikiapor, abele kai deraimer gaire lu uridili peirdi ika ditimedilu, kaka daotare abkesem marim, opole Teofilo; ");
INSERT INTO ulk1902_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ueakai ma umele ageakar abele gaire lu, emetu mari ereuerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Abele kerker ge Heroda, Iudaia opole, nerute zogo kemle, abara nei Zakaria, Abia ra nosik: abara kosker, Arona ra boai, abara nei Elisabeta. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ui barkak tonar Ade ra op ge, uiaba irmilei Iehoua ra mer gelar giz, nole asauersili kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ui ge daralei nole uerem kak, abelelam Elisabeta E soaso, ui ge akailei aule bailei. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","E ikerer tabara dorge, E zogo le Ade ra op ge, E tabara nosik erag, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mokakalam zogo le la tonar, abara dorge E badarer Iehoua ra zogo meta ge, E urim iger debe laglag lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Uiaba gaire le lakub giz esorerapare adige, abele kerker iger debe laglag lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ege Iehoua ra angela de abi etomelu, tuter pek debe laglag lu bao ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","A Zakaria de abi emetu erdar, abele ge ezigmalu, au geum baruk. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ege angela de abi detager, kega, Zakaria ae, ma nolea geum kak: abelelam mara esorarapare Ade de emetu asoli, mara kosker Elisabeta de ia mara uerem, keubu uaesemur abi nei atker Ioane. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A marim sererserer bai, iako gaire le sererege abielam: ");
INSERT INTO ulk1902_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Abelelam E aule Iehoua ra opem, nole uaina are kak, pako gorog, a mitkar Lamar Zogo abele ge, ditimedelu abele kerker ge E osmelu. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A darabgerare tababim Isaraela le ra omasker Iehouaim uiaba Ade. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","E kekiam Elia ra op ge, a adigir gako saserim, a nerkep depeger abem a apuem a omaskerem, darapegerare uiabim asorkaklam debe pardalem a debe tonarem; a ege derser abged abkoreb Iehouaim. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A Zakaria etkalu abim angelaim, kega, Nalu atamelam iaka nakaielu umele nabailu? Na gabe, emetu kaka aule baida, pako kara kosker aule baida. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A angela eutumer abim detager, kega, Kakanali Gaberiela, kaka nakuei Ade ra op ge; kari pe taramarida iaka natomelu abele debe mer iaka marim. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A dasmer, mabe te dabimdabim, baida nole mer agar kak, iski abele gerger abelegelam mabe kara mer ma desardili abele lu pem keubu erdare ageakar. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A ab gedge dekailare Zakaria mer aridarid, a uapum bakeam a Ade ra zogo meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","A ege teosmelu adem, mer atager kak uiabim; uiaba abi damrare, ege kerker nerute atamelam zogo meta ge, ege E opu darakiriare uiabim, ege E dabimdabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","A ege abara gerger desmulu, ege ko takomelu tabara boaiem. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A ege keubu gerger basemerare abara kosker Elisabeta kem eskemer; ege E gumik dauer, a faife abara meb, a daraketarare, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ege Ade ikeli gerger karim, a kari uanasmerare, E adem depegi kara sirip. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A ege abara meb sikes, Ade de angela temariklu, nei Gaberiela, Galilaiaem a Nazaretaem, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Abi gobar detager, Dauida ra boai kimiarem, a E Iosefai akemelu tababim kimiarem, abara nei Maria. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Abele angela tababu abi detager, kega, Kaka au omare marim, Iehoua uadoa mari dog; ma uerkab kosker gaire kosker ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ege abi dasmer, ege abara okasosok baruk abele merlam, E dikiapore nalu lu pe omare dali. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A angela de abi detager, kega, Maria ae, ma nole geum kak; abelelam Ade mari au omare. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dasmer, ma keubu ia kem eskemer, ese ma esmeloa kimiare uerem, a nei etkeroa Iesu. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","E au kale, a nei etkeroa, Ageakar Opole ra Uerem: a Ade de abi nakuar ko emeri Dauida ra sik, abara aba: ");
INSERT INTO ulk1902_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","E opole obaina Iakobo ra boai ge; abara baselaia ge nole mop kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ege Maria de angela itimer, kega, Ua nade, ka nole kimiar ardar kak? ");
INSERT INTO ulk1902_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A ge angela etkalu abim, kega, Lamar Zogo natabu, a Ageakar Opole ra adigir mari tumge; abelelam mabara uerem zogo, tabara nei, Ada ra Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dasmer, mara boai Elisabeta, E aule, emetu kem eskemer abara kimiar uerem: sikes meb abele kerker, E soaso. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Abelelam Ade umele gaire lu uridili E ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ege Maria de abi detager, kega, Kaka Iehoua ra memeg le; uao debele pema nakaida kari abkoreb mara mer. Ege angela de abi dakaelu. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ege Maria ekueilu abele kerker ge, dudumge bakeamulu dordor paserem, Iuda ra utebem; ");
INSERT INTO ulk1902_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ege E bakeamulu Zakaria ra meta ge balu, a Elisabeta eskos. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ege Elisabeta de asor Maria ra nas, ege uerem dekumur a detatimir muige kem ge; pako Elisabeta ra mitkar Lamar Zogo; ");
INSERT INTO ulk1902_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ege E ereretikri au kase, a detager, kega, Uerkab kosker ma, pako abele uerem uerkab osmeda. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nako abele lu, tabakeamud karim kara Opole ra apu? ");
INSERT INTO ulk1902_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Dasmer, iski a ikeli kodo mer de, mara omare karim ka asoli, ege ko uerem bagererdilu muige kara kem ge sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ege uerkab kosker ra oditur; abelelam ageakar mer Iehoua de pe etomeret abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ege Maria detaut, kega, Kara nerkep baospili Iehouaim, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ege kara nerkep au sererege Ade, E kari nazemoada. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A akai lu Iehoua de dasmer abele abara kosker memeg nole aule kak: abele kerker ge ditimedelu, ege gaire nosik uerkab karim. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Abelegelam E dali au adigiri nagri, E gaire au lu karim ikeli; abara nei zogo le. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","E au omare gaire le la geum, bauder gaire nosik. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ege saserim tabara tag, E adem gaire le lagelage aule dikiapor uiaba nerkep. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ege naimartare uader opole baolam, ege uader ge nogoka emereder ga baker aule. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ege darasisilare uader le uiaba uererege debe leuer; uader luglug le no bakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ege abi upiditidare tabara memeg le Isaraela, E abi au omare: ");
INSERT INTO ulk1902_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aberahama pako abara omasker niaiem, mokakalam abim detaut meriba aba giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ege Maria de abi dog, nako neis netate meb, gako akomeda tabara boaiem. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ege bakedilu Elisabeta ra meb osemelu; ege kimiar uerem osemelu. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ui aserare ge, abara boai giz, Iehoua au omare abi; ui ge sererege abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ga eit gerger, uiaba egared abele uerem peritome; uiaba lagelage abi nei atker Zakaria, taba aba ra nei. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ege abara apu ge uiabi detaut, kega, Nole abele; epe tabara nei Ioane. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ui ge abi detagerare, kega, Mara ko boai obatkereda Ioane nei. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ui ge abara aba opu mer detagerare, Ma pe nako ma dikiapore abara nei? ");
INSERT INTO ulk1902_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","E ge uiabi daratagerare, kega, Seleti tekadarare karim; E detali, Abara nei Ioane. Ui ge au kasege damrare. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ege akailu merkar etkalu, tabara uerut detue, E mer detaut, a au esoao Adim. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ege uader maike abi dog ga erdarare uiabim ga geum barkare; abele mer dordor paser ge Iudaia ge ga esao. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ui ge emetu aserare ga dikiaporare, kega, Nalu uerem dali? Abelelam Iehoua ra tag abi dog pako abi upinati. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ege abara aba dauer Zakaria mitkar Lamar Zogo, E ekerer perofeta dorge, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Esoao Isaraela ra Ade, Iehoua pedali; E meribi dasmer E meribi dazimoareta abara ged ge, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iski sekerise meribim uerkab Dauida ra boai ge abara memeg le, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mokakalam ge emeret ge, Iehoua de daratagerare gaire zogo perofeta, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mamoro pemi uridili uader le gizlam pe meribi dirieda, tag abgered urkerem meribim; ");
INSERT INTO ulk1902_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","E au omare meriba aba giz, gako dikiapor tom akoar zogo; ");
INSERT INTO ulk1902_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Beskak mer E nakuar Aberahama meriba aba, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","E meribi dikuarda meriba azimoaret, uader tag au kelarkelar, meriba nole geum kak meriba memeg le, ");
INSERT INTO ulk1902_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","E zogo pako oditireda abi op ge, gaire gerger uridili meriba eded. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A mama kebile ae, uiaba gaire le mari nei atker Ageakar Opole ra perofeta: abelegelam ma kekiam Iehoua ra opem derser abara gab ge; ");
INSERT INTO ulk1902_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mamanali natomertare abele azigmoaret uiabim abara ged, pako adem dikri uiaba uit giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Epe Ade pe meriba nasge dali, a kotor datki meribim. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Datki ga baziarare gesepem kupikupiem, datki moar degrered meriba teter gab karem. ");
INSERT INTO ulk1902_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ege abele uerem ga batai, abara nerkep saserim, sumez ge emri, ga abi etomertare Isaraela le giz abi. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Abele kerker ge Kaisara Augusto mer tigri, kega, Detaruem gesepem uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Abele kerker ditimedare abele jauali Kurenio sirdamu Suria ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ui ge uridili bakeauare ga detarare, taba gedlam. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ege Iosefa ge tabakeamulu Galilaia, Nazareta uteblam, Iudaiaim Dauida ra uteb, nei atker Bethelema, abelelam Dauida ra boai abara kus; ");
INSERT INTO ulk1902_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Detalei okakis Maria taba kosker ei, E dikiapor abi kem ko eskemer. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ui ge emrilei, abele kerker ge abi esmelu. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ege abara kimiar uerem esmelu; E sursur derap, egaredlu kau meta ge irdilu, abelelam uiaba meta mitkar nolea abkoreb emeri okakis. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Abele ged ge daralei sumez ge mamoe asesered, ui ki ge daralei mamoe asesered. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dasmer, Iehoua ra angela ege ekue ireder, au zoromzorom deraueirer Iehoua ra zorom: uiaba geum barkei. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ege angela de uiabi daratagerare, Uaba nole geum kak; abelelam dasmerare, kaka tais peka uabim debe mer, obaker gaire le uridili au sererserer ober: ");
INSERT INTO ulk1902_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Abelelam ge abele gerger ge eosmelu, Dauida uteb ge, Iesu Keriso, uaba Azigmoareta. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Abele atamelam; Uaba erdar sursur uerem eid kau ra meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ege dumdumge angela de okakis gaire urker ge kotor ge, epe uiaba desperare Iehoua, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ua ge desperare Ade ra kotor lu, uerkab ge gesepem, au omare le uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ege angela giz bakeauare kotorem, ui ge mamoe giz naseseredlare a mer nakesmurare, kega, Debele mi nabakeauare Bethelemaem, ko dasmerare abele lu Iehoua de meribi uadetametare. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ui ge dudum bakeauare, ege Maria uiaba nardardare, a Iosefa, a sursur uerem kau meta ge iperedare. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ege uiaba erdali, epe uiaba etomeret abele mer uiaba emetu asoli abele ueremlam. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Epe uiaba uridili emetu asoli abele mer; epe uiaba au damreda abele lu mamoe asesered le etomeret uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ege Maria de erpei gaire mer uridili, abara nerkep dikiapor. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ege mamoe asesered le takomed, uiaba despereda pako esoao Adim, abelelam gaire lu uridili uiaba emetu asoli, pako dasmer etomeret uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ege abara kerker tabarki, eit gerger abele uerem peritom, epe uiaba abi nei atker Iesu, angela kekiam nei detker, abara apu nolea kem kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ege eseamulu uiaba gerger ogdirup abi, mokakalam Mose ra gelar giz, epe uiaba tais abim Ierusalemaem, irdilei Iehoua ra opem, ");
INSERT INTO ulk1902_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Mokakalam detarer Iehoua ra gelar giz, kega, Ese kimiar uerem narbet uridili zogo Iehouaim,) ");
INSERT INTO ulk1902_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ese ikuar abele baokeilu, mokakalam etomeret Iehoua ra gelar giz, kega, Neis luk, ua nako neis kebi dibadib. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ege dasmer, nerute le emeri Ierusalema ge, nei Simeona; abara tonar barkak E au geum Adim, epe abim naokaili upinati Isaraela; ege Lamar Zogo abi tumge. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ege abi natomelu Lamar Zogo, nolea eumida, kekiam erdali Iehoua ra Keriso. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ege E bakeamulu zogo meta Lamar Zogolam; abele uerem Iesu abara aba a apu uiaba abi tegaret, uiaba ikeli abkoreb mokakalam gelar giz, ");
INSERT INTO ulk1902_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Epe abi tegaret abele uerem abara tag, ege esoao Adim, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Iehoua ae, debele ma ikuar mara memeg le uerkab bakeamulu, mokakalam mara mer; ");
INSERT INTO ulk1902_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Abelelam kara pone emetu dasmer abele mara azigmoaret, ");
INSERT INTO ulk1902_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ege ma derser opem gaire ged uridili; ");
INSERT INTO ulk1902_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Abele datki erperida gaire zuber ged, pako zoromzorom mara ged Isaraela. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ege Iosefa pako abara apu uiaba damered gaire lu etomeret abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ege Simeona E uerkab uiabim, ege abi detager Maria abara apu, kega Dasmer, abele uerem iridi uader ekesmeri a ko ekuei gaire le lakub Isaraela; abele atamelam uiaba abi dedkoli; ");
INSERT INTO ulk1902_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ege ekos dikedilu mara nerkep teibur aosos tulik; ueakai paret kak dikiapor nerkep gaire le. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nerute perofeta kosker dauere, abara nei Ana, Fanuelu ra neur, Asera ra nosik; ege emetu aule, E ge taba kimiar okakis daralei abele kerker ge E neur dauer, ege sefen abara urut tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Abele kosker zogo meta ge emeri, nako eiti foa abara urut, nole akaeret kak abele zogo metalam, E Ade ra memeg le, pako leuer baili, a esorerapare gerger ge a ki ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Abele kerker ge, E bakeamulu esoao Adim, E abi detagerare uiabim gaire le giz naokaili Ierusalema ra azigmoaret. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ege ui ge eseamulei gaire lu ikeli abkoreb Iehoua ra gelar giz, epe ui ge akomelei Galilaiaem, uiaba uteb Nazareta. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ege abele uerem ge batai, abara nerkep au saserim, no au pardar dauer: Ada ra omare abi tum ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ege abara aba a apu ui bakeamulei Ierusalemaem, nerute urut a nerute urut netpur paseka ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ege abara urut tuelf tabarki, epe uiaba bakeauare Ierusalemaem, mokakalam tonar uetpur. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ege abara gerger desmulu, epe uiaba akomeda, abele uerem Iesu emeri Ierusalema ge; ege Iosefa pako abara apu uiaba nolea umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ui ge dikiapore abele uerem uiabi okakis, ege uiaba ki gab ge asameilu; ui ge abi ge deraimerare taba boai giz pako uader umele abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ui ge nole abi ardar kak, a ui gako akomelei Ierusalemaem, abi deraimerei. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ege thri gerger barkare, ui ge abi erdali zogo meta ge, ege emeri muige ereuerem ge, E lagelage asoli, a gako uiabi nautumerare ereuerem tonarem. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ege uiaba asolare abim au pardar mer detaut, uiaba au damerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ege ui ge au kase damerei emetu abi erdarei; ege abi apuet detaut, kega, Kara uerem ma nalu pem a keribim? Dasmer, kaka pako mara aba ki au asi ki darasardei mari naraimerei. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Epe tabara mer uiabi daratager, kega, Nalugem naba kari naraimereie? Uaba nole umer kak, abkoreb kaka emeri kara Aba ra meta ge idali? ");
INSERT INTO ulk1902_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","A ui ge nole abi mer asor kak nakueiredar. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ege ui ge okakis bakeauare Nazareta tabarki; a uiaba memeg: ege apu ge gaire lu giz nerkep derpeilare. ");
INSERT INTO ulk1902_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ege pardar ge omeilu a gako Iesu ra gem, ege Ade au omare abi gako le uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ege fifitin urut abele kerker ge, Tiberio Kaisara emeri opole, Ponotio Pilato Iudaia sirdam, Heroda ge Galilaia opole, pako Filipo ra narbet Ituria opole pako nerute ged Trakoniti, pako Lusanio Abilene opole, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ana gako Kaiafa uiaba zogo le giz, ege Iehoua ra mer abim tabakeam Ioane, Sakaria ra uerem, sumez ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Epe E bakeamulu nerute apek Ioridano ge, natomertare tonar obazgeda a bapataiso, ueakai uit adem dikri; ");
INSERT INTO ulk1902_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mokakalam mer detali jauali ge Isaia perofeta, kega, Abele kodo mer ereretikri sumez ge, ueakai paret Iehoua ra gab, adem dirup. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A mitkar muimui uteb uridili, a gaire paser pako daip uridili nolea aule kak; gaire lu barbar ko barditug, pako uteb no baker ko ikeli debe gab. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Gaire le uridili dasmer azigmoaret Adelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ege E uiabi detaut, kega, gaire le lakub abim tabakeuare uiaba lagelag bapataiso, Mama tabo ereg ra omasker ae, nete etomeret uabim debele derser Iehoua ra urker niaiem? ");
INSERT INTO ulk1902_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Debele uaba turum nagri abkoreb obazgeda, a uaba nerkep nolea dikiapore, kega, Aberahama keriba aba; abelelam kaka uabim detaut, Ade umele depegeli baker peike ko Aberahama ra omasker. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Abara tulik mena ikedili lu giz ge: ese gaire lu uridili nolea turum kak, ei uaesem urem uadikri. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ege gaire le giz abi itimerare, kega, Nalu lu ki akerare? ");
INSERT INTO ulk1902_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ege E uiabim daratagerare, kega, Ese le nagri neis am uali, debele am uali kak le uaikuar; pako le nagri leuer, abkoreb ikeli mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ege telona giz bakeauare abim, kega, Keriba lagelag bapataiso, Ereuerem le ae, nalu lu ki akerare? ");
INSERT INTO ulk1902_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Epe E uiabim detaut, kega, Uaba nole au kase dikiapore lu bodomalam uabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ege uader ares le giz abi itimerare, kega, Nalu ki akerare? Epe E uiabim detaut, kega, Uaba nole urker nerute le, pako uaba nole bes mer nerute le; uaba mamoro emeri naokaili uaba bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Abele ged ge dekailare, gako nerkep ge uiaba dikiaporare Ioaneim, nako Keriso pedali; ");
INSERT INTO ulk1902_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ege Ioane de daratagerare, kega, Kai uabi bapataiso ni ge; ia nerute le tabakeam aule kari tumge, nole abkoreb kaka detue abara teter gab mukub: E uabi bapataiso abele Lamar Zogo, gako abele ur: ");
INSERT INTO ulk1902_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Abara tag nagri pat, E dirup abara kon etkemed; a E ais azirig metaem gaire kon nole puip kak, ege kon ra gegur E disirkilu abele ur umer kak esameilu. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Uader abara gaire mer okadeskeda etomeret abele ged. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ege Ioane abi barditug Heroda opole, epe Herodialam Filipo ra kosker abi narbet, pako gaire lu adud Heroda ikeli; ");
INSERT INTO ulk1902_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ege abele lu etami okakis gaire lu uridili, E abi namarid Ioane abele au dubar meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ege E bapataiso abele ged uridili, a ko Iesuim bapataiso, E esorerapare, ege abele kotor nakesmulu, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Epe abele Lamar Zogo uatabu abi tumge, abara roai mokakalam dibadib ise, ege abele kodo mer kotorlam, kega, Mama kara Uerem idali; kaka mari sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ege Iesu, abara urut thirti tote, gaire le dikiaporare E Iosefa ra uerem, a ko Heli ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A Matata ra uerem, a Leui ra uerem, a Meleki ra uerem, a Iana ra uerem, a Iosefa ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","A Matatia ra uerem, a Amosa ra uerem, a Nauma ra uerem, a Eseli ra uerem, a Nanga ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","A Maata ra uerem, a Matatia ra uerem, a Semei ra uerem, a Iosefa ra uerem, a Iuda ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","A Ioana ra uerem, a Resa ra uerem, a Zorobabela ra uerem, a Salatiela ra uerem, a Neri ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","A Meleki ra uerem, a Adi ra uerem, a Kosama ra uerem, a Elemodama ra uerem, a Eru ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","A Iose ra uerem, a Eliezara ra uerem, a Iorima ra uerem, a Matata ra uerem, a Leui ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","A Simeona ra uerem, a Iuda ra uerem, a Iosefa ra uerem, a Ionana ra uerem, a Eliakima ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","A Melea ra uerem, a Menana ra uerem, a Matata ra uerem, a Natana ra uerem, a Dauida ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","A Iese ra uerem, a Obeda ra uerem, a Boasa ra uerem, a Salemona ra uerem, a Naasona ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","A Aminadaba ra uerem, a Arama ra uerem, a Eseroma ra uerem, a Faresa ra uerem, a Iuda ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","A Iakobo ra uerem, a Aberahama ra uerem, a Tara ra uerem, a Nakora ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","A Saruka ra uerem, a Ragau ra uerem, a Paleka ra uerem, a Hebera ra uerem, a Sala ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","A Kainana ra uerem, a Afasada ra uerem, a Sema ra uerem, a Noa ra uerem, a Lameka ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","A Metusela ra uerem, a Enoka ra uerem, a Iareda ra uerem, a Malelila ra uerem, a Kainana ra uerem, ");
INSERT INTO ulk1902_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","A Enosa ra uerem, a Seta ra uerem, a Adamu ra uerem, a Ade ra uerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ege Iesu takomeda Ioridanolam, ege abi Lamar Zogo mitkar, epe Lamar Zogo abi ais sumez ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ege diabolo de abi mirem. Abele foate gaire gerger E nolea leuer aro kak, gerger eseamulu: keubu abara uerer baruk. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Epe diabolo abi detager, kega, Ese ma Ade ra Uerem, debele ma detager baker peike depegemelu leuer. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Epe Iesu abi detaut, kega, Ege emetu detali, Nolea no leuer eroli ueakai le eded nagri, epe Ade ra merlam uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Epe diabolo abi ais nerute au perepere paserem abi etomeret gaire baselaia, ege daradgeredi. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Epe diabolo abi detager, kega, Kaka mari ikuar abele sirdam uridili, pako uiaba zorom: abelelam emetu karim ikuar; ese nerute le kaka lagelage, kaka abim nakuar. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ese ma esorgiru karim, kaka marim ikuar gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Epe Iesu abim detaut, kega, Satana, ma adem bakeam kara sorge; abelelam emetu detali, Ma esorgiru mara Ade, ege abi memeg le tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ege E abi ais Ierusalemaem, ege abi ekue tumge abele zogo meta ge, a abi detager, kega, Ese ma Ade ra Uerem, ma eupumar abele uteblam: ");
INSERT INTO ulk1902_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Abelelam emetu detali, Iehoua mer tigri, Abara angela giz upinati marim: ");
INSERT INTO ulk1902_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Uiaba marim tegareda uiaba tag, ueakai mara teter nolea baker itut. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Epe Iesu abim detaut, kega, Abele mer, kega, Ma nolea mirem abele Opole mara Ade. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ege diabolo abara mirem uridili eseamuda, epe E adem bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Epe Iesu ko akomeda Galilaiaem, Lamar abim au adigiri; ege gaire le asoli abara tonar deraueli apek uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ege E ereuerem uiaba sunagoem, ege gaire le uridili abi despered. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ege E Nazareta tabarki, ege E bataili abele ged ge: epe E barot abele sunago sabath ge, mokakalam abara tonar, ege E tekue ko etag. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ege abim ikuar jauali Isaia perofeta. Epe E diski abele jauali, epe nagri abele mer emetu detali, ");
INSERT INTO ulk1902_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ege kari tumge Lamar Opole, abelelam E kari depegili etomeret abele mer uader nolea lu kak; ege E kari namarid idigiri uiaba nerkep okasosok, etomeret debe mer uader nolea uteb kak, pako diski pone sadmer, pako omare uader asiasi gaire gerger, ");
INSERT INTO ulk1902_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ko etomeret urut Opole sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ege jauali ditarat, E ikuar memeg le, ege lokod ge emeri: epe gaire le dasmerare abim sunago ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Epe E ditimeda detagerare uiabim, kega, Abele gerger ageakarem abele jauali, uaba aserare. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ege uiaba uridili abi despered, ege uiaba au damered gaire debe mer abara telam. A uiaba detaut, kega, Nako Iosefa ra uerem pedali? ");
INSERT INTO ulk1902_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Epe E uiabim daratagerare, Abkoreb uaba karim detaut, Lukup kemle, mabu idigiri: gaire lu uridili ma ikeli Kapernauma, ki emetu asoli, debele ma ikeli mara ged kar peike. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ege E detager, kega, Ageakar, kaka uabim detaut, Nolea abkoreb perofeta emeri abara ged kar. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E ko detager, kega, Ageakar, kaka uabim detaut, Abele kerker Elia emeri Isaraela, uader kosker uiaba kimiar eumid, epe kotor dimi thri urut pako sikes meb, abele ged uridili uererege; ");
INSERT INTO ulk1902_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Epe Elia nolea bakeam uiabim, ege no Sarefta, Saidona ra uteb, a nerute koskerim abara kimiar emetu eumid. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ege emeri Isaraela uader lepera, abele kerker Elisaia perofeta emeri; a uiaba nolea le ogarup kak, ege no Naamana, Suria le. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ege uiaba asoli abele lu, uiaba sunago ge ueku nagri; ");
INSERT INTO ulk1902_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ege uiaba ekue, a abi emarid nerute apek, ege uiaba abi tag erpei egardare nerute muimui uteb paserem uiaba uteb, ueakai uiaba abi bataueret muige. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ege E ekasereder uiaba opem, a bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Epe E bakeamulu Kaperanauma, Galilaia ra uteb. Ege E uiabim ereuerem sabath ge: ");
INSERT INTO ulk1902_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ege uiaba au damered abara merlam; abelelam abara mer nagri sirdam. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nerute le sunago ge emeri, E nagri lamar uit demoni giz; ege E ereretikri au kase, ");
INSERT INTO ulk1902_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Kega, Uaiai! Iesu Nazareta le, ma nalugelam keribim? ege ma tabakeamulu ueakai keriba baum? ege kaka umele marim, Ade ra Zogo. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Epe Iesu abi daisumda, kega, Bamer, ma adem osmeda abielam. Epe demoni abi ekesmeri uiabi opem, epe abim osmeda, nolea adud nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Epe uiaba uridili au damered, ege uiaba mer atager, kega, Nalu abele mer? E dali nagri adigiri pako sirdam, abelelam E uiabi daisumda uit lamar giz, epe uiaba adem osmed adige. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Epe abele mer abielam gaire le asolare gaire apek uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ege dekaelu abele sunago, E barot Simona ra meta: ege Simona ra kosker abara apu nagri gim, gem urueri, au kale; ege uiaba abim damosi. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Epe E ekue maike abi dog, ege abi daisumda abele gim urueri; epe sobkak eseamud: epe E ekue, a uiabi memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Uiaba uridili nagri gim, nerute gimlam a nerute gimlam, ege uiaba tais uiabim lem baraigida; ege abara tag itut nerute le a nerute le, pako idigiri uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ege gaire demoni giz uiaba osmed, ereretikri, kega, Mamanali Keriso Ade ra Uerem. Ege E uiabi daisumda, ege uiaba umer kak mer atager abim; abelelam uiaba umele E Keriso. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ege gerger ge, epe E osmed, E bakeamulu nerute le kak uteb: ege gaire le lakub giz uiaba abi deraimerare, epe abim tabakeauare, a uiaba abi erpeilare, ueakai E nolea bakeamulu abele gedlam. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ege E uiabim detager, kega, Abkoreb kaka marau Ade ra baselaia gaire ged: abelelam kaka emarid. ");
INSERT INTO ulk1902_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Epe E marau abele sunago giz Galilaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ege E ekue nerute pek, abele ni Genesareta ge, ege gaire le lakub uiaba esaimelu, uiaba lagelage asolare Ade ra mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Epe E erdali neisi nar gur tauer nerute apek abele ni ge; nolea le kak, uiaba bakeauare net ogarup. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Epe E bakeamulu nerute nar ge, Simona ra nar, E abi damosi, Ma elele ami abele nar nerute apek abele ni ge. Epe E emeri lokod ge, E uiabi ereuerem, gaire le lakub, abele narlam. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ege abara marau eseamulu, E abi detager Simona, Ma elele abele keper ge, ueakai uaba net esapili, a lar nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simona abi detager, kega, Opole, abele ki ge keriba au sagim, nolea lar nagri: epe mara mer nagri, abelelam kaka net ko bataueret. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Abele lu uiaba emetu ikeli, epe uiaba net esapili gaire lar mitkar; epe uiaba net batoatare: ");
INSERT INTO ulk1902_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ege uiaba opu darakiriare uader emeri nerute nar ge, tabakeauare uiabi upidaratidalare. Epe uiaba tabakeauare, ege neisi nar mitkar, maike bataili. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ege Simona Peteru umele, epe abi ekesmeri Iesu ra teter ge, kega, Opole, ma bakeamulu karielam, abelelam kaka uit le. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Abelelam E abi damered, pako uader kemem abim, abelelam gaire lar uiaba nagri; ");
INSERT INTO ulk1902_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ege mokakalam Iakobo pako Ioane, Zebedaio ra omasker, uiaba larem okakis Simona. Epe Iesu abi detager, Simona, Ma nolea geum kak; ditimed peirdi gaire le nagri marielam. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ege uiaba nar akaridalie, epe uiaba gaire lu uridili dikaer, a uiaba abi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","E bakeamulu nerute uteb ge, nerute le nagri gim, abara gem lepera mitkar: ege E Iesu erdali, epe abim ekesmeri tabara opem, E abi damosi, kega, Opole, ese ma lagelage, ma umele kara gem ogdirup. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Epe abara tag itrimud, E abi itut, kega, Kaka lagelage; mari ogdirup. Epe abara gim lepera akaid. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Epe E abi detaut, Ma nolea etomeret nerute le: debele ma bakeam abi etomeret abele zogozogo le, ma abi ais tonar ogdirup, mokakalam Mose ra gelar giz, ueakai uiaba umele abele atamelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Abele mer E osmed, gaire le asolare abim: epe gaire le lakub giz tabakeauare uiaba lagelage abi asolare, pako idigiri uiaba gim. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","E bakeamulu le kak uteb, ege esorerapoilu. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nerute gerger, E uiabi ereuerem; ege Faresaio giz pako ereuer le abele gelar giz, uiaba tabakeauare nerute uteb Galilaialam, pako Iudaia, pako Ierusalema; ege nagri Opole ra adigiri, abelelam E nadgirare uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dasmer, nerute le uiaba tegared taba siklam gim nagri E ibibi; uiaba lagelage abim tegared, a abi ais Iesu ra opem. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","A uiaba nolea umer kak, abelelam abele meta mitkar gaire le lakub, epe uiaba bakeauare meta tumge ezagerare Iesu muige, a lemlem ismi, uiaba sik dikri gim le tumge igimerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ege E erdali uiaba oituli, E abi detager, kega, Mara uit emetu idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Epe aotale giz pako Faresaio giz uiaba dikiaporare, kega, Nete le dali E adud mer Adim? Nete umele uit idigiri, no Ade tepteb? ");
INSERT INTO ulk1902_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Epe Iesu erdali uiaba dikiaporare, E uiabi detaut, kega, Nako dikiaporare uaba nerkep? ");
INSERT INTO ulk1902_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nako lu nolea beber, kega, Ege mara uit adem dikri: nako, Ma ekue bakeam? ");
INSERT INTO ulk1902_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Abelelam ueakai uaba umele Ade ra Uerem, E nagri sirdam geseb ge uit dikri, (ege E abi detager ibibi le,) Kaka mari detager, Ma ekue, bakeam ais mara sik, a bakeam mabara meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Epe E ekueid uiaba opem, ege tabara sik ekau, a bakeam tabara meta, E Adim naospered. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Uiaba uridili au damrare, uiaba naospered Adim; ege uiaba au geum, kega, Abelelam kerkar abele lu meriba erdalare abele gerger. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ege abele lu eseamulu, epe E osmed, ege E erdali nerute telona giz, abara nei Leui, ege E emeri meta dipumed: E abi detager, kega, Kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Epe gaire lu uridili dikaer, E sobkak abi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ege Leui E ikeli uetpur abara meta ge abim: gaire telona giz abi kemem, pako uader uteid baiter uiaba eroli okakis ");
INSERT INTO ulk1902_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Faresaio giz a aotale giz, uiaba mudi mer abara kaimeg giz, kega, Nalugelam uaba eroli a ereli okakis telona giz a uit le giz? ");
INSERT INTO ulk1902_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu uiabim detaut, kega, Saserim le giz lukup kemle lakak; gim le giz laglag. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kaka nolea tabarki ko gaire barkak tonar dabgeri, debele gaire uit le giz, ueakai uiaba obazgeda. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ege uiaba abi detaut kega, Nalugelam Ioane ra kaimeg giz leueru baili, pako esorerapare, pako Faresaio ra kaimeg giz; ege mara kaimeg giz uiaba eroli a ereli? ");
INSERT INTO ulk1902_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ege Iesu uiabim detager, kega, Nako, umele gaire boai le ispida ko leueru baili, le ispida uiabi dog? ");
INSERT INTO ulk1902_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kerker niai tabarki; le ispida uiabielam egared, abele gaire gerger uiaba leueru baili. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ege E uiabim detager, nerute mer babisdarie, kega, Nole le kerkar mog uali itkedi okakis buzibuzi am uali; kerkar mog ualilam ekep itkedi, iako kerkar mog ualilam nole abkoreb buzibuzi am uali. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nole le epaiteret kerkar uaina muige buzibuzi tarpor giz; epe tarpor giz arperiklam, uaina epaiteredoa, epe sor giz adud. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ese ko kerkar tarpor giz sorem, debele epaiteret kerkar uaina, ueakai debele. ");
INSERT INTO ulk1902_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nole le ereli emeret uaina, a iako ko sobkak lagelag kerkar uaina: abelelam E detager, kega, Emeret uaina debele. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Abele sabath ge nener kekiam gerger, E iako ekas kon gedub ge; epe abara kaimeg giz kon itarakerare, ege uiaba tag itmerare, a uiaba eroare. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ege uader Faresaio giz uiabim daratagerare, kega, Nalu uaba lu akerare nole abkoreb sabath ge? ");
INSERT INTO ulk1902_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu uiabim detaut, kega, Nako uaba nole etage Dauida de ikeli, leuer aro kak, uerer eudili, a gaire abara kaimeg giz; ");
INSERT INTO ulk1902_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","E Ade ra zogo meta ge balu, E erdali areto derser, E eroli, a uiabi nakuarare uader abi kemem; abele leuer nolea abkoreb nogle eroli, no zogozogo le giz tepteb? ");
INSERT INTO ulk1902_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ege E uiabim detager, kega, Abele Le la Uerem sabath opole. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nerute sabath ge, E iako sanago ge balu, E uiabi ereuerem: nerute le abara tuter tag euselu. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ege aotale giz pako Faresaio giz uiaba abi deraimerare, nako, E idigri sabath ge; ueakai nagri mer ais abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","E umele uiaba dikiapore; epe E abi detager, nerute le tag euselu, Ma ekue, E ekue muige. E sobkak ekue. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Epe Iesu uiabim detager, Kaka uabi nautumerare nerute lu, Nako, abkoreb omare abele sabath ge, nako nolea? nako eded, nako ipit? ");
INSERT INTO ulk1902_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ege E abi darasmerare uiaba uridili, epe abi detager, nerute le tag euselu, Mara tag itrimud. Epe E ikeli abkoreb: epe abara tag debele, mokakalam nerute. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Epe uiaba au urker; ege uiaba mer atager nalu lu uiaba ikeli abkoreb Iesuim. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Abele gaire gerger, Iesu bakeamulu nerute paser ge E esorerapare; E Adim damosi ki ge ueeseamur. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ege gerger ge, epe dabgiri abara kaimeg giz; E depeger tuelf le, ege uiabi nei atker Aposotolo; ");
INSERT INTO ulk1902_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simona, nei atker Peteru, pako Anederia tabara keimer, a Iakobo pako Ioane, a Filipo a Batolomaio, ");
INSERT INTO ulk1902_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","A Mataio a Toma, a Iakobo Alefaio ra uerem, pako Simona, nei atker Zelote, ");
INSERT INTO ulk1902_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","A Iuda Iakobo ra uerem, pako Iuda Isakariota, abi keserkeser; ");
INSERT INTO ulk1902_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ege E bakeam okakis uiabim, E ekue debe uteb, pako abara kaimeg giz, pako gaire le lakub Iudaialam, pako Ierusalemalam, pako nerute apek Turo a Sidona, ege uiaba tabakeauare lagelage abim asoli, a uiaba dikiapore uiaba gaire gim, E uiabi nadgirare; ");
INSERT INTO ulk1902_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Uader au asiasi uit lamar, ege E uiabi idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ege gaire le lakub uridili uiaba lagelag abi dog ekepili: abelelam E nagri adigiri, ege uiaba uridili idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ege E dasmer abara kaimeg giz, E uiabi detager, kega, Uerkab uaba nolea lu kak: abelelam uaba Ade ra baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Uerkab uaba uererege peirdi: abelelam uaba kem osmeda. Uerkab uaba ezoli peirdi: abelelam uaba sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Uerkab uaba uader au urker uabim, pako uabim daratirieda, pako dedkoli uaba nei mokakalam adud lu, Le la Ueremlam. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Debele uaba sererege abele gerger ge, pako uaba eupemad a sererege: abelelam, dasmer, nagri kotor ge uaba bodomalam: abelelam abkoreb uiaba aba ikerare mokakalam gaire perofeta giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mokakalam, uaiai, uaba lu giz ra apu! abelelam uaba nagri debele. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Uaiai, uaba kem osmed! abelelam uaba uererge. Uaiai, uaba sererege peirdi! abelelam uaba okasosok, pako ezoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Uaiai, uader uridili dede mer uabim! abelelam uiaba aba ikeli abkoreb mokakalam perofeta bes. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Epe kaka uabim detager, uaba asoli kara mer, Uaba omare le uabim derarti, pako uaba debe mer uader nolea omare kak, ");
INSERT INTO ulk1902_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Uaba uerkab le kupeiatimed, uaba esorerapare uader bes mer uabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ese nerute le mari ipit mara ikabu tetapim, ma ikuar nerute ikabu tetapim; ese nerute le ais mara au am uali, ma nolea daisumda mara gem uali. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Debele ma nakuarare uader uridili mari namosed; ese nerute le mara lu gatkam le, ma nolea ko tais. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mokakalam uaba nerkep dikiaporare uiaba ikeli abkoreb uabim, debele uaba ikeli mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ese uaba omare uader omare uabim, nalu esoao abkoreb abele lu? abelelam gaire uit tonar le giz omare uiabim, uiabi omare. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ese uaba debe dorge ikeli uiabim, gaire le uabim debe dorge, nalu uaba esoao abkoreb abele lu? abelelam gaire uit le uiaba ikeli abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ese uaba ikuar mani uader damosi uabim, a uaba ko dikiapore keubu nagri lu, nalu esoao abkoreb abele lu? abelelam uit le ikuar mani le damosi, ueakai nagri lu abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Debele uaba omare uader uabim derarti, pako urker uabim, debele uaba debe dorge uiabim, pako ikuar mani uader uabi damosi, uaba nolea dikiapore lu abkoreb; ueakai bodomalam nagri, uaba Ade ra omasker: abelelam E omare uit le, pako gaire adud le. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Debele au nasenase uaba omare, mokakalam uaba Aba, abara omare au nasenase. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ua nole abi meratager kak, iaueakai uaba ko nole abi meratager: uaba nolea bodomalam uiabim, ueakai uaba nolea bodomalam: debele uaba adem dikri uiaba uit, ueakai uaba uit adem dikri: ");
INSERT INTO ulk1902_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Debele uiabim ikuar, ueakai uabi ikuar; E uiabim ikuar debe uali E badigamo, E sapili pako dikri, E mitkar osmed adige, abelelam uaba turum nagri, a ko uaba turum nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ege E uiabim detager nerute abara mer babisdarie, kega, Nako, umele nerute sadamer tegaret nerute sadamer? epe nako uiaba neis okakis ekesmeri ao ge? ");
INSERT INTO ulk1902_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kaimeg giz nole aule kak abara ereuer le: mokakalam abara ereuer le, debele. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nalugelam ma dasmer lu puipi nerute le la pone ge, ma nolea umer kak au lu mara pone ge? ");
INSERT INTO ulk1902_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nalugelam ma abi detager, mara le, Karim mara pone, kaka adem abele lu puipi mara pone ge: ma nolea umer kak au lu mara pone ge? Ma bes le, ma kekiam adem abele au lu mara pone ge, ueakai ma umele adem puipi nerute le la pone ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Umer kak lu debele adud turum nagri; pako lu adud umer kak debe turum nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Abelelam gaire lu turum nagri, ueakai gaire le umele. Abelelam nolea le etobemed suke ra turum zegerzeger lu, pako nolea le etobemed turum uina ge dardar lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ege gaire le debe E tais lu debele lu debele tonar, E ikedi muige abara nerkep; abele le adud E tais lu adud lu adud lam E ikedi abara nerkep; abelelam gaire lu muige E abi etomeret abara te. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nalugelam uaba etomeret karim, Opole, Opole, a uaba nolea ikeli mokakalam kara mer? ");
INSERT INTO ulk1902_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ese nerute le karim tabakeam a asoli kara mer, pako E ikeli, kaka uiabi etomeret le mokakalam abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mokakalam nerute le ikeli abara meta, E daiui muimui, E ikedi giz ge neid ge: epe ni dodo au kase babuselu, ege umer kak dimali: abelelam abele giz E ikedi neid ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ese nerute le asoli, a nolea ikeli, E mokakalam le ikeli abara meta tumem sep ge, nolea giz kak: ege abele ni dodo au kase babuselu, epe abele meta mogem erapei. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ege abara mer uridili eseamulu, abele ged uiaba asorare, epe E iako bakeamulu Kaperenauma ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ege abele le, asesered netat handed, abara memeg le E nagri gim maike eumid, E abim au omare. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ege E asoli Iesu pedali, E namarid aule giz Iudaia Iesuim damosi E bakeam abara meta ge, E lagelage idigiri gim le, abara memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ege uiaba tabakeauare Iesuim, epe uiaba au elele damosi, kega, Abkoreb, abele le, ma ko ikeli abara lag; ");
INSERT INTO ulk1902_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Abelelam E au omare meriba ged, ege E ikeli keriba sunago. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Epe Iesu bakeamulu gaire le abi kemem. Ege E maike meta ge, epe le, asesered netat handed le, E namarid abara boai Iesuim, kega, Opole, nolea abkoreb ma barot muige kara meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Abele lu kaka dikiapore nolea abkoreb kak bakeam marim; debele no mara mer, ueakai kara memeg le adem idigiri abara gim. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Abelelam kaka nerute le E sirdam karim, kaka sirdam uader ares le: ese kaka abi detager nerute le, Ma bakeam, E bakeam; pako nerute le, Tabakeam, E tabakeam; pako kara memeg le, Ma ikeli abele lu, E ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ege Iesu asoli abele lu, E abi damared; E egreemalu, E uiabim detager, gaire le lakub uiaba abi irmili, Kaka uabim detager, Kaka nole umer kak nerute Isaraela le nagri au oituli mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ege uader namarid, a uiaba akomed meta ge, uiaba erdali abele memeg le, E gimgim, abara gim emetu akaida. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kebi gerger, E bakeamulu nerute uteb ge, nei atker Naina; ege uader abara kaimeg giz E uiabi kemem, pako gaire le lakub. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ege E maike te abele uteb ge, dasmer, uiaba bakuare nerute le emetu eumid, abara apu E netat abara uerem, abara kimiar emetu eumid: abele ged gaire le emeri abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ege Opole abim erdali, E au omare a au nasenase abim, ege abi detager, Ma nolea ezoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ege E bakeam maike, E itut abele bao; epe, uiaba bakuare le eumid, uiaba ekue. E abi detager, Makeriam, kaka marim detager, Ma ekue. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Epe, abele le eumid, E emeri, E mer etkalu. Epe E ikuar abara apu. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ege uiaba uridili au geum: ege uiaba Adim naospered, kega, Ege E ekue meribim abele perofeta, E au kale; Ade E dasmer abara ged. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ege abele mer abielam deraueli Iudaia uridili, pako nerute apek. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ege Ioane ra kaimeg giz gaire lu uridili uiabi abi etomertare. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Epe Ioane dabgiri abara kaimeg giz neis le, ege uiabi namariklu Opoleim, kega, Nako mama le tabakeamu, nako keriba naokaili nerute le? ");
INSERT INTO ulk1902_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ege ui bakeamulei Iesuim, kega, Ioane Bapataiso keribim namarid marim, E detager, kega, Nako mama le tabakeam, nako keriba naokaili nerute le? ");
INSERT INTO ulk1902_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Abele gerger gaire gim le E idigiri, pako asiasi gim, pako demoni giz; pako ikuar ueakai gaire le pone sadmer uiaba bakaerti. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Epe Iesu uiabim detaut, kega, Ua bakeamulam, uaba etomeret Ioaneim gaire lu uaba emetu erdali, pako lu uaba emetu asoli; sadmer bakaerti, pako ibibi le emetu ekasereder, pako lepera emetu ogdirup, a grip eudgamad emetu diski asoli, uader eumid uiaba ko ekuei, a debe mer marau uiabim uader le nolea lu kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","E uerkab le, nolea mudi mer karim. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ege Ioane ra kaimeg giz ui bakeamulei, epe E marau gaire le lakub Ioaneim, Nalu lu uaba bakeauare sumez ge erdalare? nako abele mebud uag demali? ");
INSERT INTO ulk1902_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nalu lu uaba bakeauare erdalare? nako le am uali gebgeb? Dasmer, uader am debe uali, pako debe leuer eroare, uiaba mamoro emeri opole ra meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nalu lu uaba bakeauare erdalare? nako perofeta? Ageakar, kaka uabi detager, E aule perofeta giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Abelelam, E pedali, abele mer detali abim, Dasmer, kaka emarid kara merkem le mara opem, E paret mara gab mara opem. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kaka uabim detager, Nolea perofeta osmelu koskerlam aule mokakalam Ioane Bapataiso: epe le kebile Ade ra baselaia ge, E aule abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Abele ged uiaba Adim naospered abele mer uiaba emetu asoli, pako telona giz, abelelam Ioane E uiabim bapataiso, abara bapataiso. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Epe Faresaio giz, pako ereuer gelar giz, uiaba adem Ade ra sirdam, abelelam uiaba nolea lagelag abara bapataiso. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ege Opole detager, Abele nosik, nako lu mokakalam kaka uiabim natomeret? nako lu uiaba koreb? ");
INSERT INTO ulk1902_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mokakalam kebile giz uiaba emeri zegur uteb ge, uiaba dabgiri, kega, Ege keriba sirumer uabim, a uaba nolea sererege baberkeri; ege keriba au ezoli uabim, a uaba nolea ezoli keribim. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Abelelam Ioane Bapataiso tabarki, nolea areto eroli, a nolea uaina ereli; a uaba detager, kega, E nagri demoni abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ege Ade ra Uerem tabarki, E eroli, a ereli; a uaba detager, kega, Dasmer, abele le E au lagelag leuer eroli, a pako uaina ereli, telona giz la le pako uit le! ");
INSERT INTO ulk1902_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Abele le pardale, E gaire abara uerem, E debe mer abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ege nerute le, Faresaio giz, E abi detager, Meriba eroare okakis. Ege E bakeamulu Faresaio ra meta, epe E eidi, a eroli. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dasmer, nerute kosker abele uteb, abele kosker E uit le; ege emetu erdali E eidi eroli Faresaio ra meta, epe E tais nerute tarpor, debe laglag mitkar, ");
INSERT INTO ulk1902_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","E ekue isorge Iesu ra teter, E ezoli, ege abara ebeb babused Iesu ra teter, E idigiri abara mus, E eskos abara teter, pako desao abara gem abele lukup, debe laglag. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ege Faresaio le umele Iesu E mer abim, epe E dikiapore muige abara nerkep, Ese abele le E perofeta, nako E umele abele kosker, pako abara tonar, ege E abi itut: abelelam abele kosker E uit le. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Epe Iesu abi detager, kega, Simona, kara mer marim, ege E abi detager, Ereuer le, ma detager. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Neisi le uiaba damosi nerute le ra mani: nerute le abi damosi denari faif handed, a nerute le fifte. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ege uiaba nolea mani nakuar abkoreb abara mani, epe E uiabi omare, E idigiri uiabim nolea ko dikiapore bodomalam abara mani. Debele ma kari detager, Nete aule abara omare abim? ");
INSERT INTO ulk1902_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ege Simona mer etkalu, kega, Kaka dikiapore, abele le gaire abara mani E abi idigiri. Ege E abim detager, Mara mer barkak. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Epe Iesu egreemalu abele kosker, ege abi detager Simona, Nako, ma umele abele kosker? Kaka balu muige mara meta, ma nolea tais ni kara teter ge: epe abele kosker abara ebeb E babused kara teter ge, E idigiri abara mus. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma nolea karim eskos: epe E dali, nolea ner kak karim eskos, abele ge ditimedlu abele meta ge balu. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma nolea desao kara kerem abele lukup de: epe E dali, E desao kara teter abele lukup, debe laglag. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Abelelam, kaka detager marim, Ege gaire abara uit uridili emetu idigiri; abelelam E au omare: epe le kebile abara lu emetu idigiri, abara omare kebile. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ege E abi detager, abele kosker, Mara uit emetu idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Uader uiaba eidi eroare, a uiaba dikiapore muige uiaba nerkep, Nete le dali, E idigiri uit? ");
INSERT INTO ulk1902_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ege E abi detager, abele kosker, Ma eded abelelam ma oituli; Ma uerkab bakeamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Keubu, Iesu iako deraueli gaire ged pako gaire uteb, ege E etomeret debe mer Ade ra baselaia ge: ege abara kaimeg giz, tuelf le, uiaba emeri abi okakis, ");
INSERT INTO ulk1902_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pako uader kosker nagri gim pako lamar uit emetu idigiri, Maria Magadalena, epe E sefen demoni giz abi dog emetu imuda, ");
INSERT INTO ulk1902_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Pako Ioana, Kusa ra kosker, Heroda ra memeg le E sirdam, pako Susana, pako uader kosker, uiaba abim memeg le uiaba lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ege gaire le lakub uiaba etami okakis, ege uiaba tabakeauare nerute gedlam a nerute gedlam, epe E uiadim detager nerute mer babisdarie: ");
INSERT INTO ulk1902_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nerute amorda le bakeamu ko emor: ege abara saido dikri, epe uader abele kep abi gab ge; uader bakeauare abele gab uiaba teter temaiseletare, a pako ebur giz uiaba eroli. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Uader kep abi uteb neid ge; ege E omeili, epe E uatuet, abelelam nolea bebeb. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A uader kep abi lu daradara ge; epe okakis omeili lu daradara ge, epe E detarapi. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ege uader kep abi debe seb ge, E omeili, E turum nagri, uader uan handed. E detager abele gaire lu, epe E ereretikri, kega, Le la grip nagri ko asoli, debele E asoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ege abara kaimeg giz abi itimer tonar abele mer babisdarie. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Epe E mer etkalu uiabim, Emetu ikuar uabim iaueakai uaba umele gaire lu gumik Ade ra baselaia ge: epe uader mer babisdarie uiabim gaire le; iaueakai uiaba nolea dasmer, uiaba dasmerare, pako uiaba nolea asoli, uiaba aserare. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tonar abele mer babisdarie: abele saido, Ade ra mer pedali. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Abele uader le gab ge emeri, ege uiaba asoli; epe Satana tabarki a abele mer uiabi nerkep ge emor ekadari, iaueakai nolea oituli, a nolea eded nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Abele uader tumem neid ge, uiaba abole mer asoli, a sobkak sererege erpei; a uiaba nolea sip kak, a uiaba no neisi neisi gerger oituli, abele gerger mirem tabarki, uiaba sobkak bakesmeri. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Abele uader lu eipu daradara ge emor, uiaba abele mer asoli, uiaba bakeauare epe gaire dikiapore lu lag geseb ge uiaba nerkep ge badari, pako geseb lu okardarem, pako uader lu lag, abele mer etarapi, abelelam turum nolea ageg. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Abele uader emor debe seb ge, uiaba abele mer asoli, a mamoro epeili, ageakar erpei uiaba nerkep ge, a turum nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nolea le lamepa dislik ispilu tanelu ge, pako ikedi sik lokodo ge; debele ikedi tumem giz lamepa ge, iauaekai nagri datki uiaba tabakeauare barot abele meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Abelelam nole lu ispilu, a nolea opasereret kak; pako nole mud ge lu, a nolea akmer kak, epe keubu etomeret. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Abelelam, debele uaba mamoro asoli: abelelam le nagri lu, a ko abim ikuar; epe le nole lu kak, a ais abielam abele lu E dikiapore abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ege abara apu, pako abara keimer giz, uiaba tabakeauare abi deraimerare, a uiaba umer kak abi maiem, abelelam gaire le lakub. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ege uader uiaba abim detager, kega, Ege mara apu pako mara keimer giz uiaba adige ekue, uiaba lagelag marim erdali. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ege E uiabim detaut, kega, Ese gaire le giz asoli Ade ra mer, a uiaba ikeli, uiaba kara apu a kara keimer giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ege nerute gerger, E bakeamulu, okakis tabara kaimeg giz, a nar atiem; ege E uiabim detager, kega, Mi nabakeauare nerute apek abele keper ge: epe uiaba atiem. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ege uiaba atiem, E uteidi: epe au uag tabarki abele keper ge; ege gaire zauber nar etatkoi, a mitkar, maike E baitili, uiaba au geum. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Epe uiaba tabakeam, a abi itir, kega, Opole, opole, keriba maike baume. Epe E tekue, a uag daisumda, pako abele au zauber: uiaba ekeamulu, iauaekai metalug. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ege E uiabim detager, Nade uaba oituli? Ege uiaba au geum, pako au damred; ege uiaba mer atager, kega, Nete dali, abelelam E abi detager abele uag, pako abele ni, epe uiaba abi aserei? ");
INSERT INTO ulk1902_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ege uiaba nerute apek tauer ge tabarki, abele Gadara le la ged, abele apek keper ge, E abkoreb Galilaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ege E narlam eupamada, epe sobkak obapit nerute le abele uteb, E emeretelam nagri demoni giz abi dog; ege nolea am uali kak, a nolea emeri meta ge, epe E ao ge emeri. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ege E abi erdali Iesu, E au kodo ereretikri, a E ekesmeri abara opem, ege E abi elele detager, kega, Kaka nako marim, Iesu Ade ra Uerem au kale? Kaka marim bali, nole kari asiasi nakeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Abelelam, E abi detager, kega, Ma lamar uit teosmeda lelam. Abelelam gaire gerger E abi erpei: ege uiaba abi didbari malil par, pako lu dimili abara teter, a uiaba abi asesered; ege E umele malil par dergeir, epe demoni giz abi ais sumez ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ege Iesu abi itimer, kega, Mara nei nako? E detaut, kega, Kara nei Legeona; abelelam gaire demoni giz kemem abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ege uiaba abi damsare, Ma nolea detager keribi bakeauare muimui uteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gaire borom abele gorgor paser ge erueda: ege uiaba abi damsare, kega, Debele ki nabakeauare nabarte muige borom ge. E uiabim namarida. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Epe gaire demoni giz baos adem lelam, a bakeauare borom ge barot: ga baupamaret muimui uteb keper ge, ege gaire borom guni baitarare. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Abele le giz, borom naseseredlare, erdalare abele lu E ikerer, epe uiaba au koreder bamer, a ged ge gaire uteb daratagerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ui ge tabakeauare dasmerare abele lu E ikerer; ga tabakeauare Iesuim, uiaba erdalare le demoni giz dedkoli, emetu tabaos, a E emeri Iesu teter ge, E ame, a tonar tonar: ege uiaba au geum. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ui ge le erdalare, a uiaba natomertare uiaba le nagri demoni giz dedkoli, emetu idgiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abele uteb Gadara ge uridili, uiaba ko abi damsare, kega, Keriba ged ma dekaer; abelelam ui au geum: ege E ko bakeamulu nar ge, E atiem. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Le demoni dedkoli teosmeda, E abi damos abi dog emeri: epe E nolea la kak, a abi emariklu, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Bakeamu mabara ged, a mabara boai, a uiabi natomertauem abele gaire au lu Ade de marim ikeli. Ege E bakeamulu a natomeret gaire uteb uridili, gaire au lu pe Iesu de abim ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu iako takomeda nerute apek, epe gaire le lakub netate utebem; abelelam abi naokailare. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dasmer, nerute sunago kole tabaruk, abara nei Iairo; E Iesuim dasmer, E ekesmeri Iesu ra teter ge, abim elele bar, kega, Debele ma tabakeamu kara meta ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Abelelam abara neur E netat, nako abara urut tuelf, maike eumid. Ege E bakeamulu, a gaire lakub abi dirumedare. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nerute kosker mam gim dauer, tuelf gaire abara urut, abara lu desemulu lukup keimle naisuelare, ege abara gim nolea eseamuda, ");
INSERT INTO ulk1902_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ege bakeamulu Iesu sor ge, E itut abara am uali deg: ege abara mam gim desemulu. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Epe Iesu uiabi detager, kega, Netide kari natutida? Uiaba detaut, kega, Ua? Ui ge, Peteru pako uader le, abi kemem detagerare, Opole, ege gaire le lakub mari dirumedare, nako debele ma detager, Netide kari natutida? ");
INSERT INTO ulk1902_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ege Iesu detager, kega, Nerute le lut kari natutida: abelelam kaka umele nagri adgiri karielam emetu bakeamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ege abele kosker E umele E nolea gumik abim, ege E bakeamulu au durdur, a abara opem E ekesmeri; E abi etomeret abele ged uridili abele lu E abi itut abelelam abara gim emetu idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Epe E abi detager, kega, Kara neur, mara nerkep saserim, maba oatulam ma eded akaida maba gimlam; ma uerkab bakeamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","E mena detaut abele mer, nerute le sunago kole tabarki E sirdam, abi detager, kega, Mara neur emetu eumid; debele ma nole kole bamesili. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ege Iesu asoli abele mer, epe E abi detaut, kega, Ma nolea geum kak: ma oituli, ueakai E nagri eded. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ege E balu muige meta ge, E nolea la kak nerute le abi irmili, no Peteru, pako Iakobo, pako Ioane, pako neur ra aba, pako abara apu. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ege uiaba uridili au kase ebazoli, abi au omare: epe E detager, kega, Uaba nolea elele ebazoli; neur nolea eud kak, E uteidi. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ege uiaba abi neg degarare, abelelam uiaba umele E emetu eumid. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ege E uiabi adem adige, gaire le emeri muige, epe E abi erpei abara tag, E dabgeri, kega, Neur, ma ekue. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ege abara lamar ko takomed, epe E ekueilu: a E detager, kega, Debele leuer abi ikuar eroli. ");
INSERT INTO ulk1902_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Epe abara aba a apu uiaba au kase damreda: ege E uiabi daisumda nolea abi etomeret nerute le, abele lu emetu ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ege E darabgerare abara kaimeg giz, tuelf le, ege E uiabim nakuarare abele adigiri, pako abele sirdam demoni giz uridili dituaki, pako gaire gim le giz uiabi idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ege E uiabi namarida ko natomertare Ade ra baselaia ge, a uiabi idigiri gaire gim le. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ege E uiabim detager, kega, Uaba nole lu aisare kak abele bakeamu, nole koket kak, nole epei kak, nole leuer kak, a nole mani kak; a nole neisi am uali ameare. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Uaba nerute meta ge badari, emeri abele, a iako bakeamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Uiaba le giz uabim agared kak, a nolea uabi asor kak, uaba bakeamu abele gedlam, sep ditkeda uaba teter gablam, uiabi atamelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ege uiaba bakeauare, deraueli gaire ged, a natomertare Ade ra debe mer, a uiabi idigiri gaire gim le uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ege Heroda opole asoli gaire lu uridili emetu ikeli: epe abara nerkep au okasosok, abelelam uader detager, kega, Ioane Bapataiso ko eded akaida eudelam; ");
INSERT INTO ulk1902_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","A uader detager, kega, Elia pedali paret kak; epe uader detager, kega, Nerute perofeta emeretlam, E ko eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heroda detager, kega, Kaka derapeida Ioane ra kerem: nete le kaka asoli gaire mer mokakalam? E lagelag abi dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ege kaimeg giz ko takomeda, uiaba abim etomertare gaire lu uiaba emetu ikeli. Epe E uiabi ais nerute uteb, nolea le kak, abele ged nei atker Bethesaida. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ege gaire le lakub uiaba emetu umele, a uiaba abi irmilare: ege E uiabi agiz, E uiabi detager tonar Ade ra baselaia ge, pako idigiri uader le lagelag eded. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ege maike lem baraigida; epe gaire tuelf le tabarki, a abi detager, kega, Debele ma namarida gaire le lakub, iaueakai uiaba bakeauare gaire uteb, abele kebi uteb maike, uiaba emeri, a leuer deraimer: abelelam abele uteb nolea le kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ege E uiabi detager, kega, Uaba uiabi leuer ikuar. Ege uiaba abi detager, kega, Meriba nolea leuer kak, no faif areto a lar neisi; debele keriba ko bakeamu leuer terapei uiabim peike gaire le lakub. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Abelelam mokakalam faif tausan le uridili. Ege E uiabim detager, kega, abara kaimeg giz, Uaba uiabim detager debele uiaba manoro emeri, fifte le gaire nosik. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ege uiaba ikerare abkoreb mokakalam abara mer, a uiabim uridili detagereda, kega, Gaire nosik uaba mamoro emeri. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Epe E tais faif areto a lar neisi, E kotor dimirualu, a esoao, a itur; a uiabi nakuarare, abara kaimeg giz, a uiaba naisuerare abele gaire le lakub. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ege uiaba eroare, ege uiaba uridili gem osmeda; epe uiaba kaier leuer arot epei ge, ege tuelf epei osmeda, leuer mogmog. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","E tepteb esorerapare, abara kaimeg giz uiaba okakis: epe E uiabi nautumerare, kega, Nako gaire le la mer karim nete? ");
INSERT INTO ulk1902_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ege uiaba abi detautare, kega, Ioane Bapataiso; epe uader detager, kega, Elia; a uader detager, kega, Nerute perofeta emeretlam, E ko eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ege E uiabim detager, kega, Nako uaba mer karim nete? Epe Peteru abi detaut, kega, Mama Keriso Adelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Epe E uiabim daraisumdarare, kega, Nolea nerute le etomeret abele lu; ");
INSERT INTO ulk1902_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kega, Abkoreb gaire lu asias Ade ra Uerem, pako aule giz abi dikaer, pako zogozogo le giz, pako aotale giz, uiaba abi ipitare, a thri gerger ko eded. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ege E uiabim gaire le uridili detager, kega, Ese nerute le lagelag kari narmili, mamoro E tababu obogai, abara satauro bakuar gaire gerger, a kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Abelelam, ese nerute le lagelag abara eded asisiem, abele ko abi; ese nerute le abara eded abi karielam, abele ko ededem. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Abelelam, ese nerute le geseb ge uridili terapei, a abara mar abi, pako adem, nalu bodomalam abim? ");
INSERT INTO ulk1902_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ese nerute le kari sirip ge, pako kara mer, abkoreb Le la Uerem ko abi sirip ge, E tabarki kemem gaire angela zogo, abara Aba zorom ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ageakar, kaka uabim detager, kega, Uader peike, uiaba nole eud kak, kekiam uiaba Ade ra baselaia dasmerauem. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ege gaire mer eseamulu, nako eit gerger, epe E abi ais Peteru, pako Ioane, pako Iakobo, ege uiaba ogi nerute tumem perepere paser ge, E esorerapare. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","E esorerapare, a abara op depegemelu, E kakekak abara ame uali, au zoromzorom. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dasmer, ege neisi le uiaba abi mer atagerem, Mose pako Elia; ");
INSERT INTO ulk1902_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ui etomeret au zoromzorom, ege uiaba mer atager tonar abara eumid keubu, Ierusalema ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ege Peteru au uteidi pako uader abi kemem: ege uiaba ekiam, a uiaba erdalare abara au zoromzorom, pako neisi le uiaba ekue okakis. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Epe ui bakeamulei, a Iesu dikaer, epe Peteru abi detager Iesuim, kega, Opole, debele meriba emeri peike: keriba thri meta akerare; mara nerute, Mose ra nerute, a Elia ra nerute: ege E nole akiapore kak abele mer detager. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Abele gaire mer, uiaba natkamda baz de, a uiaba ispilu: ege uiaba au geum, abele baz maike. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Le la mer teosmeda abele bazelam, kega, Kara Uerem nasge idali: uaba abim asoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ege abele mer sobkak eseamulu, epe uiaba erdali Iesu, E tepteb. A uiaba nolea mer kak, a uiaba nolea etomeret nerute le, abele kerker, gaire lu uiaba erdalare. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Idim ge, uiaba paserlam batueli, epe uiaba obapit gaire le lakub. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dasmer, nerute le ereretikri le lakublam, kega, Ereuere le ae, kaka mari damosi, ma dasmer kara uerem; abelelam kara uerem netate: ");
INSERT INTO ulk1902_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dasmer, ege E nagri abara gim lamar uit, epe E ereretikri, E udud, abara te ueker, E bapegiri, E nolea sobkak osmelu. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kaka damosi mara kaimeg giz, uiaba dituaki osmeda adige; a uiaba nolea umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ege Iesu detaut, kega, Abele nosik nolea oatur kak, pako erar, kaka uabim kemem naket gerger? pako omare uabim naket gerger? mara uerem karim tegaret. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ege E tabakeamu, E ekesmeri, E udud, abele demoni giz, epe Iesu daisumda abele uit lamar, pako idigiri abele uerem, E ikuar abara aba. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ege uiaba uridili au damreda Ade ra atamelam. Epe uiaba uridili au damreda gaire lu Iesu de ikeli, epe E uiabi detager, abara kaimeg giz, ");
INSERT INTO ulk1902_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Uaba mamoro asoli abele mer: abelelam Ade ra Uerem maike uadikuarare le la tag. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","A uiaba nolea umer kak abele mer, ege uiaba nolea erdali, abelelam uiaba nolea asoli abele lu: ege uiaba au geum abi itimer tonar abele mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ege uiaba asareda, nete le aule. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ege Iesu opasereret abele dikiapore uiaba nerkep, epe E erpei nerute kebi uerem, E ekue maike abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ege E uiabi daratagerare, kega, Ese nerute le tegared abele kebi uerem kari nei ge, ege E karim tegared: ese nerute le karim tegared, ege E tegared abele le kari namarida: abelelam E kebile ise uabim dali, E aule. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ege Ioane de abi detager, kega, Opole, keriba erdali nerute le E imud demoni giz mari nei ge; epe keriba abi daisumdardar, abelelam E nolea meribi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ege Iesu abi detager, kega, Uaba nolea daisumda: ese nerute le nole meribi dedkoli, E meribi okakis. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ege abara kerker maike tabarki, E iako takomeda kotor ge, ege E bakeamulu Ierusalema ge, ");
INSERT INTO ulk1902_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ege uader ko namarkare abi kekiam: ui ge bakeauare bamer nerute uteb Samaria ge, ui abim derserare. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","A uiaba nolea abi la kak, abelelam E bakeamulu Ierusalema ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ege neis abara kaimeg giz, Iakobo a Ioane, ui erdalei, ui detagerei, kega, Opole, nako ma lagelag ki datagerei debele ur uatabu kotorlam, ueakai ui obaum, mokakalam Elia de ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A Iesu sorem egreemalu, E uiabi barditug, kega, Uaba nolea umer kak tonar muige uaba nerkep. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Abelelam Ade ra Uerem tabarki nolea dedkoli le la eded, epe E tabarki ueakai gaire le eded nagri. Ui ge bakeauare nerute utebem. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ui ge bakeauare abele gab ge, ege nerute le abi detager, kega, Opole, kaka mari narmili gaire uteb ma bakeamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ege Iesu de abi detager, kega, Arobe nagri abara kur, pako gaire epereda ebur nagri uteb uteidi; epe Le la Uerem nolea uteb kak uteidi. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ege E detager nerute le, Ma kari narmili. Ege abim detaut, kega, Opole, ma kari nakuar kaka kekiam nabakeamulu atkobeilu kara aba. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A Iesu abi detager, kega, Debele ikedi le eumida uiaba etkobei; marim abkoreb ma ekue etomeret Ade ra baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ege nerute le abi detager, kega, Opole, kaka mari narmili; epe ma kari nakuar kaka kekiam bakeamu natomertare karbara boai. ");
INSERT INTO ulk1902_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ege Iesu de abi detager, kega, Ese nerute le erpei abele uet abara tag, a dikaer, a ko sorem egreemalu, E nolea abkoreb Ade ra baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Keubu, Opole depegeli uader sefenti, E uiabi namarida neisi a neisi le kekiam abara opem, gaire uteb uridili, E keubu. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ege E uiabi daratagerare, kega, Abele saito itraker au kase, neisi a neisi le uiaba dorge ikeli: debele uaba damosi Opole abara saito itraker, iaueakai gaire le namarida ikeli abara dorge. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ua obakeauare: dasmer, kaka uiabi namarida mokakalam kebi mamoe giz eipu luko. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Uaba bakeauare, nolea ais mani epei, a pako epei, a teter gab: uaba nolea damareda omare le uabi obapit gab ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ese uaba barot nerute meta ge, uaba kekiam meta kemle abi detager, kega, Uerkab uabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ese le debele uabim, a uaba abim debele; ese nolea uabim debele, uaba ko takomeda. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","A uaba emeri abele meta, eroli a ereli abele gaire lu uiaba uabim uadaisuerare: abelelam abkoreb bodomalam le dorge ikeli. Uaba nolea bakeauare nerute meta a nerute meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ese uaba nerute uteb ge barot, a uiaba omare uabim, a ua eroare gaire leuer uiaba uabim derseri: ");
INSERT INTO ulk1902_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Uaba nadgirare uader gim le, a ua daratagerare, kega, Ade ra baselaia maike uabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ese uaba nerute uteb ge barot, a uiaba nole uabi omare, debele ua bakeauare giz akos uteb, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Abele sep uaba uteb, ege sep batagerda keribi dog, a keriba ditkeda uabim: debele uaba umele abele lu, ege Ade ra baselaia maike uabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kaka uabi detager, kega, Abele gerger kebi bodomalam Sodomaem abele uteb ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Korasina ae; kaka au nasenase marim! Bethesaida ae; kaka au nasenas marim! abelelam ese ikeli Turo a Sidonaim atamelam emetu ikeli uabim, nako, emeretelam uiaba emetu obazgeda, emeri mokakalam zegerzeger uali pako tibitibi uali. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kebi bodomalam Turo a Sidona abele gerger ia uabi itimer. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Marim Kaperenauma, uige mari uanageserare armem, a keubu ma ekesmeri muige abele Hedisge. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ese le asoli uabim, mokakalam kari asoli; ese nerute le uabi dituaki, mokakalam kari natuaki; ese nerute le kari natuaki, epe E natuaki abele le kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ui ge ko tabakomeret, abele sefenti gaire le, uiaba sererege, kega, Opole, ege demoni giz uiaba asoli keribi, mara nei ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ege E uiabim daratagerare, kega, Kaka erdali Satana, E ekesmeri kotorlam, mokakalam perper ise. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dasmer, kaka uabi ikuar abele sirdam ko tabo E sapiri pako bokani, pako saserim uridili le tekelar: nole nerute lu adud uabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Uaba nole sererege abele lu, ege demoni giz uabi asoli; debele uaba sererege abele lu, iaueakai uaba nei emetu uadetar kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Peike abele haua ge, Iesu ra lag au sererege, Lamar Zogolam, kega, Kaka mari esoao, kara Aba, kotor Opole pako geseb ge, abelelam ma ispilu abele lu uader umele pako pardar, a natomertare abele lu kebi uerem ge: uao, kara Aba, abele mara lag peike. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ege kara Aba gaire lu E kari naisuer: nole le ardar kak abele Uerem, epe abara Aba; nole le erdali abele Aba epe abara Uerem, pako nerute le abara Uerem E lagelage abi etomeret. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ege E basker taba kaimegem, a kebi mer uiabim, Uerkab abele pone emetu erdali uader lu uaba erdada: ");
INSERT INTO ulk1902_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Abelelam kaka uabim detager, kega, Gaire perofeta pako opole giz, ui lagelage uaerdarare abele lu ua erdada, a uiaba nole ardar kak; a uiaba lagelage asoli abele lu uaba emetu asoli, a uiaba nole asor kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dasmer, ege nerute le ekuei, ereuerem gelar giz, E abi mirem, kega, Ereuer le, nalu lu kaka ikeli ueakai kaka nagri eded niaiem niai karem? ");
INSERT INTO ulk1902_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ege E abi detager, kega, Nalu detali muige abele gelar? nalu mer ma etag? ");
INSERT INTO ulk1902_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ege E etkalu, kega, Ma omare Opole mara Ade, mara nerkep kemerkemer, mara mar kemerkemer, mara saserim kemerkemer, mara akiapor kemerkemer; ma omare le mai kes mari dog, mokakalam mari omare. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ege E abi detager, kega, Mara mer barkak: ma ikeli abkoreb mokakalam, ueakai ma eded nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Epe E lagelage tababu barkakem, E Iesui detager, kega, Kaka umele, na le mai kes kari dog? ");
INSERT INTO ulk1902_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ege Iesu de detaut, kega, Nerute le tabakeamu Ierusalemlam Ieriko ge; ege uader lu gatkamer le giz abi erpeirare, abara ame uali digirare, a ipitare, a ui ga bakeuare, ege imereder maike eud. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ege nerute zogo le, E bakeamulu abele gab ge: E abi erdar, a abielam degab etaruklu. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A mokakalam, nerute Leui le, E osmelu abele uteb gab ge, E bakeamulu E erdali, abielam degab etaruklu. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","A nerute Samaria le, E bakeamulu abele uteb gab ge: E erdar abele le emeri, E au omare abi, ");
INSERT INTO ulk1902_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ege E bakeamu, erep abara ziz, a lukup epaitered pako uaina; ege E agisilu ebur sor ge igimulu, E ais nerute meta, E abi asesered. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nerute idim ge, E meme demareredlu, ege E ikuar neisi denari meta kemleim, a abi detager, kega, Ma abi asesered; ese nerute lu E lagelage, ma terapei abi ikuar, ka iako tarakomelu, mari bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Uiabielam neis netate le, nete le mai kes darali abim nerute le lu gatkamer le giz erepeidarda? ");
INSERT INTO ulk1902_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ege abim detaut, kega, Le abi omare. Ege Iesu de abi detager, kega, Ma ko bakeam mokakalam ikeroa. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ui ge bakeuare, ege bakeamulu nerute uteb: nerute kosker, abara nei Maretha, E tegaredlu Iesu tabara meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tabara berbet, nei atker Maria, ege emereder maike Iesui teter ge, E lagelage uaeasor Iesu ra mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ege Maretha de sagim deger taba boaiem; ege E ekueilu, a abi detager, kega, Opole, nalu, ma nole kari dikiapore, epe kari le lut nakuar peike tepteb derser gaire lu? ma ge abi detager, kari upinati. ");
INSERT INTO ulk1902_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ege Iesu de abi detager, kega, Maretha, Maretha, ma lu lag gesebge, no pama geseb lu dikiapoare: ");
INSERT INTO ulk1902_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nerute lu pe debele; ege Maria de dikiapore debe lu, nole nerute le abielam ais. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iesu emri nerute uteb ge, ege E esorerapare, eseemuda, ege nerute abara kaimeg giz, E abi detager, kega, Opole, debele ma keribi dereuerare abele esorerapare, mokakalam Ioane de tabara kaimeg giz nereuerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ege E uiabi detager, kega, Ua esorerapauem mokakalam, kega, Keriba Aba kotor ge, zogoem mara nei. Mamoro mara baselaia sepem uatabu. Ikeroa mabara lag abele geseb ge, mokakalam kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Keribi ikuar leuer, nerute gerger a nerute gerger, keribi abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Adem dikri keriba uit; abelelam keribibu dikri ui uridili keribi dedkoeda. Nole keriba tegeredare abele mirem, epe keribi ditkedarare uitelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","E ge uiabi nautumerare, kega, Nete uaba tebud, E bakeamulu eipu ki ge, E abi detager, kega, A ma tais neisi netat areto, keubu iako bodomalam; ");
INSERT INTO ulk1902_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Abelelam, kara tebud emetu tabakeam, a kaka nole leuer kak abi ikuar; ");
INSERT INTO ulk1902_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","E ge abi detager, muige taba meta ge, Nalu ma kari naogatili: emetu peike meta dimiredare, emetu ki eididare omaskerkem; kaka umer kak nakiamlu mari nakuare? ");
INSERT INTO ulk1902_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kaka uabi detager, kega, Ese E nole ekue abi ikuar, abelelam abara tebud, epe E ikuar gaire lu uridili E laglag, abelelam E elele damosi. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kaka uabi detager, kega, Debele uaba damos, ueakai uaba nagri; uaba deraimer, ueakai nagri; uaba mudmud, E uabi diski. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Abelelam, ese le abi damos, E nagri; le deraimer, a erdali; le mudmud, E abi diski. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ese uerem areto damos tabara abalam, nako E abi baker ikuar? Ese abi damos nerute lar, nako E ikuar tabo, a nolea lar kar ikuar? ");
INSERT INTO ulk1902_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ese abi damos kalkal ra uer, nako E ikuar bokani, a nolea ikuar kalkal uer? ");
INSERT INTO ulk1902_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Uaba adud tonar, ese uaba umele gaire debe lu naisuerare uaba omasker, mokakalam uaba Aba, emeri Kotor ge, E uabi uadekuarare Lamar Zogo uaba damos? ");
INSERT INTO ulk1902_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","E imud nerute demoni, ege E te dabimdabim. Ege demoni baos abielam, ege E mer etkalu, abele le te dabimdabim; ui ge gaire le giz abi damerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Uader le batagelare, kega, Belezebul, demoni giz opole, abelelam E umeli demoni imud. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Uader le giz abi mirem, ege uiaba abi deraimerare atamelam kotorlam. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ege E opasereret uiaba dikiaporare, E uiabi daratagerare, kega, Gaire baselaia uridili epuli eseamuda; pako boai epuli nolea niaiem ekue. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ese Satana tababu barili a epuli, nako E umele niaiem ekue, pako abara baselaia? abelelam, pe ua detager, kega, Belezebul, abelelam ka demoni imuda. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ese kaka namuare demoni Belezebuloelam, netide uanamuare demoni giz a uaba omasker giz? abelelam keubu gerger ge, uabi uaditimerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ese Ade ra tag kaka imud demoni giz, ege Ade ra baselaia emetu tabaruka. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ese saserim le nagri ares lu taba meta uanaseseredauem, ia atko kak lu uadaragiri: ");
INSERT INTO ulk1902_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ese au saserim le uatabakeamu abi uaekesmer, abara ares lu uadais, E au oituli tabara ares lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ese nerute le nolea kari la kak, E nolea kari kemem; ese nerute le nole etami kari dog okakis, E tabara lu derapei. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ese lamar uit obaos lelam, E degemli uatuet uteb, ege E deraimer nerezi uteb; nolea uteb kak, ege E detager, kega, Kai ko tarakomelu karba meta, emeret kaka emeri. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","E bakeamulu taba utebem ge, erdar emetu dirup esemulu. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ege E bakeamulu, taraisare uader sefen lamar, ui au adud abi tumge; a bakeuare barot muige, a bamer: ege E au adud abele le la mop, abele gerger ge ditimedelu. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","E detager abele lu, ege nerute kosker ge, E ereretikri, eipu le lakub, a abi detager, kega, Uerkab ma E osmeda abele kemlam, pako abele nano ma ereli. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","E abi detager, kega, Ageakar, E uerkab abele le asoli Ade ra mer, E asesereda. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ege gaire le lakub abim tabakeuare, ege E uiabi daratagerare, kega, Abele nosik au adud; uiaba deraimerare atamelam; a nolea atamelam kak, no abele atamelam Iona perofeta tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Abelelam, mokakalam Iona abele atamelam Nineua ge, abkoreb Ade ra Uerem abele nosik. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Abele kosker, opole ziai apek, E ekue okakis nosik le ge, abuar ge E uiabi nautumerare, a uiabi bodomalam: abelelam E tabakeam bazmirare ge, E lagelage ueasiri Solomona ra pardale; dasmer, ike abele nerute le, E au kale tumem Solomona. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ui ge bako Nineua ge, abele gerger ge uanautumerare abele nosik, E uiabi bodomalam: abelelam uiaba obazgeda Iona ra marau; dasmer, ike abele nerute le au kale tumem Iona. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nolea le emetu disirik lamepa, E ikedilu lokod ge, pako agud saito ge, E ikedi tumge, iaueakai uadatki gaire le emeri be ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pone lamepa ra gem: ese mara pone debele, mara gem uridili nagri datki; ese mara pone adud, a mara gem nolea datki kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Marim, nole kupkupi datki muige mari dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ese mara gem uridili nagri datki, nole kupkupi kak, E datki uridili, mokakalam lamepa datki mari dog, au bebe. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ege E detaut, nerute Faresaio de abi detager, kega, Kari okakis ereueda: Ege E balu, E emerilu ero. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ege Faresaio de abi erdar, ege E damerar, abelelam E no eroli, nole tag ogarup kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ege Opole abi detager, kega, Uaba Faresaio uaba dirup abele tanelu ge pako abele kumeti; epe muige pe mitkar poipi a adud tonar. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Uaba paim paim! Le ikeli sor ge, pako muige? ");
INSERT INTO ulk1902_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Debele ua aisare uaba lu omare; dasmer, gaire lu uridili uaba ogdirup. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Uaiai uaba Faresaio giz! abelelam ua aiseda ten mili, pako pekano, pako gaire lu uridili nagri nur ge, a ua dekaerta Ade ra itimer, pako abara omare: abkoreb ikeli abele lu, a nole dikaer abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Uaiai uaba Faresaio giz! abelelam ua au lagelag bao aule sunago ge, pako omare gizakos uteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Uaiai uaba aotale pako Faresaio, ua bes le giz! abelelam uaba mokakalam ao giz espi, ese le tumem uadegemeli, umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Epe nerute gelar giz, ereuer le, E abi detager, kega, Ereuer le, mama keribi dedkoeda, mara mer peike keribim. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ege E daratagerare, kega, Uaiai uaba gelar giz ko! abelelam uaba nole dekmerik uaba lu uaba no ikuar nerute le, uaba tag pem nole. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Uaiai uaba! abelelam uaba ao emorare perofeta, a uaba kaied giz a uiabi ipit. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Epe uaba etomeret tonar uaba kaied giz, pako sererege: abelelam uiaba ipit, a uaba emorare uiaba ao. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ege Ade ra pardali detaut, Kaka uiabi namarida perofeta pako aposetola giz; uiaba uader ipit a uader damrik; ");
INSERT INTO ulk1902_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Iaueakai abele nosik deraimer gaire perofeta ra mam, babused abele kerker ge ditimedelu geseb ge; ");
INSERT INTO ulk1902_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","A ditimed Abela ra mam bakedida Sakaria ra mam, uiaba ipit eipu neres ge, maike Zogo meta: ageakar, kaka uabi detagereda, kega, E deraimerare abele nosik. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Uaiai uaba gelar giz, ereuer le! abelelam ua aisare ki pardar: ua nole barot, a ua daisumda uader lagelag barot. ");
INSERT INTO ulk1902_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ege abele mer E uiabi detager, uiaba aotale a Faresaio giz au ueku; uige abi mirem itimerare gaire lu gem; ");
INSERT INTO ulk1902_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","A ui ge deraimerare abara merem E ua detaut, a ui ge natomertare. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ege gaire le lakub tabakeuare netat uteb ge etami, ege E ditimeda uiabi marao, tabara kaimeg giz, kega, Uaba dekaer Faresaio ra lu erperida, uiaba bes. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Abelelam nole lu ispilu, E natomertare: nole lu gumik, E natomertare. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ege gaire lu uridili kupkupi ge ua detautare, E detomertare datki; uader lu pe ua kebi mer lu muige uteb ge, E natomertare tumem meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kaka uabi detagereda, kabara tebud, Ua nolea geum uiaba no gem ipit, ese uaeseemu, iauaekai umer kak ko ikeli nerute lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Epe kaka uabi detomeret le uabi geum: Uaba abi geum, ese uaeseemu abi ua ipit, E sirdam iako batauered gena: ageakar, kaka uabi detagereda, kega, Uaba abi geum. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Uaba nolea bodomalam faif kebi ebur giz epereda neisi asari? Ade nole nerute ebur okataprik kak abara op. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A uaba mus uridili emetu etag, abelelam uaba nolea geum, uaba aule gaire kebi ebur. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kaka uabi detagereda, kega, Ese nerute le lut kara nei uanatomertare gaire le, Ade ra Uerem ko etomeret abara nei opem Ade ra angela. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ese nerute le kari asared le ra op uridili, E ko asared opem Ade ra angela. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ese nerute le adud mer Ade ra Uerem, E itikir: ese nerute le adud mer Lamar Zogo, E nolea itikir. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ese uaba eguatumur sunagoem, a opole, a tarim le, ua geum kak mer detautauem, nako ia detautare: ");
INSERT INTO ulk1902_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Abelegelam Lamar Zogo de uabi uaderuerare, abkoreb ia mer detautare. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ege nerute le kublam, abi detager, kega, Ereuer le, ma kara le detager, E uateragoa tabara sirdam lu karim. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ege E abi detager, kega, oe, netede kari nakuar abele sirdam uabim? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ege E uiabi daratagerare, kega, Ua asesered uaba nolea geseb lu lag: abelelam nolea le eded geseb lulam. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ege E uiabi daratagerare, nerute mer babisdarie, kega, Nerute le abara lu abi seb ge au turum turum: ");
INSERT INTO ulk1902_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","E dikiapor, kega, Nalu lu ka akere, epe nolea pe kes kak, karbara lu aodage? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","E detager, kega, Abele lu ka ikeli: kaka adem erapei karbara saido meta, kai ko au kale akailu; kaka etami okakis karbara turum, pako gaire debe lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A kaka abi detager, karbara lamar, kega, Kara lamar, ege marim gaire debe lu, E ikeli abkoreb dordor urut, ueakai ma mamoro emeri gaire urut ge, a eroli, a erer, a iako sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ege Ade de abi detager, kega, Ma paim le, mara iako lamar ki ge tais; netede ia ueais gaire mara lu ma derseri? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mokakalam le etami gaire lu, tabara lu, a nolea lu nagri Adelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ege E uiabi daratagerare, tabara kaimeg giz, kega, Abelelam kaka uabi detagereda, kega, Uaba nole au kase dikiapor uaba eded, na leuer uaba eroare; gako uaba gem, na lu uaba ameare. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ege eded aule leuer aroem, pako gem aule am ualilam. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Uaba dikiapor oreua, uiaba nolea saido dikri, a nolea saido itraker; a uiaba nolea uteb kak, a nolea saido meta kak; ege Ade de uiabi darasisiare: uaba au debele ebur giz! ");
INSERT INTO ulk1902_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nete uabielam umele ikeli dikiapor, au kale perper abara eded netat kubita? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ese uaba umer kak ikeli kebi lu, nalugelam pe ua au kase dikiapor uader lu? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Uaba dikiapor dap, nako tonar omeili: uiaba nolea dorge kak, nolea erat; kaka uabi detager, Solomona nolea am uali pako debele, nolea mokakalam uader lu debele. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ese Ade de ikeli mokakalam sumez am uali, abele gerger omeilu, iauaekai obatauered urem; nako au am uali uaba kebi oituli? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Uaba nolea deraimerare, nalu ia eroare, nalu ia ereare; uaba nerkep nolea dikiapor gaire lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Abelelam gaire lu uridili gaire ged geseb ge deraimerare: epe uaba Aba E umele gaire lu abkoreb uabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Debele ua mamoro deraimerare tabara baselaia, ueakai keubu gaire debe lu uaba nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Uaba nolea geum kak kebi mamoe giz; abelelam uaba Aba E lagelag uabi ikuar abele baselaia. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Debele uaba lu bodomalam, ueakai uabi ikuar; ueakai uaba nagri debe epei, kotor lu nolea eseamur kak, nolea maike eruam le, a nolea degem aro kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Abelelam abele uteb ge pe uaba lu nagri, uaba nerkep pe ko kemem. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Uaba dimiri uak ge, a uaba lamepa disirik; ");
INSERT INTO ulk1902_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Debele ua ikerauem abkoreb uader le dekaili uiaba opole, E ko takomer uetpurem; iaueakai ese E tabakeam a ipit abele gab te, uiaba sobkak diski. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Abele memeg le giz uiaba uerkab, uiaba opole E erdali uiaba ikeli abkoreb mokakalam, a mamoro derser: Ageakar, kaka uabi detager, E abara uali dimiri, a uiabi detager, Meriba ero, E bakeamu uiaba memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ese E tabakeamu eip ki, nako kimiar faul ereretikri, ese erdali uiaba ikeli mokakalam, uerkab uiaba memeg le giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Debele uaba umele abele lu, ese lu kemle E umele abele eruam le uatabaruk, E mamoro asesered, a nolea dikaer uiaba eruam tabara meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Abele lu ua derser: abelelam abele gerger ua nolea akiapor kak, Ade ra Uerem tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ege Peteru abi detager, kega, Opole, ege ma detager keribim abele mer babisdarie, nako le uridili? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ege Opole detager, kega, Nete memeg le sirdamu, ege E ageakar dikiapor, ege abara opole E ikuar abele sirdam abara memeg le, E uiabi ikuar leuer abkoreb abuar ge? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Abele memeg le E uerkab abara opole tabaruk a abi erdali, ege abara dorge mamoro ikerer. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ageakar, kaka uabi detager, E ikuar abele dorge E sirdam abara lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ese abele memeg le E dikiapor muige taba nerkep ge, Kara opole au uapum; ege E ipit uader memeg kimiar, pako uader memeg kosker, E ero, a ere, E paimpaim; ");
INSERT INTO ulk1902_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Abele opole tabaruk abele gerger ge abara memeg le nole arser kak, abele mog gerger E nole ardar kak, ege E au dulam, ege E tedais abara dorge okakis uader nole asor kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Abele memeg le umele opole dikiapor, a nole arser kak, nole ikeli gaire lu taba akiaporlam, E au damarik; ");
INSERT INTO ulk1902_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ese memeg le nole umer kak, ege E ikerer uader lu abkoreb damarik, E no kebi kebi damarik. Abelelam ese le ikuar gaire lu, E ko itimer gaire lu: Ege E gaire lu E asesereder, ui ge abi detagerare, Ma tais gaire lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kai tarabarki nabataueredelu abele ur gesepem: nalu lu kaka ko lagelag ese emetu dasiriklu? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Karbara bapataiso kaka bapataiso; kaka au asias mop ge bakedida! ");
INSERT INTO ulk1902_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nako uaba dikiapor kaka tarabarki dakuarare abele mapodan geseb ge? Kaka uabi detager, nole: epe mer bamsili: ");
INSERT INTO ulk1902_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Abelelam ditimed peirdi, faif le uiaba netat meta emeri, uiaba mer bamsili, neisi netat le neisi le mer daramesilare, a neisi le neis netat le mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abib ueremei mer bamesilei, aba a uerem; apu a neur; kimiar ra apu uerem ra kosker; kosker kimiar ra apu. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ege E uiabi daratagerare, gaire le lakub, Ese ua erdarare baz omeili koki peik, ua ge detager, Nako, irmer; epe ageakar. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ese uag uami ziai peik, a ua ge detagerauem, Nako, au gerger: epe ageakar. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Uaba bes le giz, ege uaba umele dikiapor tonar kotor a gesep; nalu atamelam uaba umer kak etag tonar abele urut? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nalu uaba nolea dikiapor barkak lu? ");
INSERT INTO ulk1902_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ese ma okakis bakeam nerute le, nagri abara lu mari dog, nole bodom kak, ma debe mer abim abele gab; ueakai nole mari eguatumur autmorem, le itimer mari uanakuar memeg le, ia memeg le mari uanakuar au dubar meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kaka mari detager, Ma nole ko eosmeda, kekiam mani aisuer. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Abele kerker uader tabakeuare, uiaba abi etomertare Galilaia le, abelelam Pilato asesered uiaba mam, pako mam tababu baotiare. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ege E de uiabi daratagerare, kega, Nako, uaba dikiapor epe au uit Galilaia le uridili, ueakai uiaba au sagim gaire lu abkoreb? ");
INSERT INTO ulk1902_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kaka uabi detagereda, Nolea: ese uaba nole obazgeda, abkoreb uaba uridili baum. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Uader eitin le, E erapei uiabi tumge abele kar Seloam ge, ege ui baum, nako, aule uiaba uit le uridili emeri Ierusalema ge? ");
INSERT INTO ulk1902_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kaka uabi detagerare, Nolea: ese uaba nole obazgeda, abkoreb uaba uridili baum. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ege E uiabi detager, abele mer babisdarie, Nerute le E nagri suke, ege E emor abara uina gedub ge; ege E bakeamulu deraimer turum, a nole erdali. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Epe E abi detager, le dorge uina gedub, Dasmer, neis netat urut kaka tarabarki daraimer turum abele suke, kaka nole turum ardar kak: debele ismi; epe nalu dedkoli abele sep? ");
INSERT INTO ulk1902_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ege E abi detaut, kega, Opole, debele no dikaer abele urutem, kaka giz daiue uaderauei, a gaire poipi: ");
INSERT INTO ulk1902_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ese turum uanagri, debele; iako nole, keubu debele ma ismi. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ege E uiabi ereuerem nerute sunago, sabath ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dasmer, nerute kosker nagri lamar E gebgeb, abara urut eitin; epe E no ersedi, umer kak mamoro ekuei. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ege Iesu de abi dasmer, ege E abi dabgeri, kega, Oe, epe mara gebgeb emetu eseamud. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ege abara tag abi dog dikmerik: ege E barkak ekueilu, ege E Ade desper. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Epe nerute le, E sirdam abele sunago, E au ueku abelelam Iesu idigir sabath ge, ege E uiabi daratagerare, gaire le lakub, Debele sikis gerger dorge ikeli: abkoreb uaba tabakeuare idigir, sabath nole. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ege Opole de abi detager, kega, Ma bes le, epe uaba nerute le sabath ge detuemer abara kau pako abara asina kau metalam, naogatare ni namerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Abele kosker, Aberahama ra neur, ege Satana de didibar, dasmer, abara urut eitin, nako nole abkoreb detuemer abara mukub sabath gerger ge? ");
INSERT INTO ulk1902_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ege E abele mer detager, epe uiaba uridili au ueku abim, sirip nagri: ege gaire le lakub uridili uiaba sererege abelelam gaire au lu E ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ege E detager, kega, Ade ra baselaia, nalu lu abkoreb? nalu lu kaka detaut mokakalam? ");
INSERT INTO ulk1902_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","E mokakalam sinapi ra kep, nerute le ais, E bataueret tabara gedub ge; ege E omeilu, keubu au kale; epe gaire ebur giz epereda tam ge uteid. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ege E ko detager, Ade ra baselaia, nalu lu mokakalam? ");
INSERT INTO ulk1902_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E mokakalam lu sik epiti, nerute kosker ais ikedi muige abele falaua neis netat mitkarem, a keubu uadarabuerare uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ege E bakeamulu uteb a kebi uteb giz, ege E ereuerem, a bakeamulu Ierusalema ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ege nerute le lut, abi detager, kega, Opole nako no neis a neis le eded nagri? Ege E uiabim daratagerare, ");
INSERT INTO ulk1902_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Uaba saserim ueakai uaba barot kebi te ge: abelelam kaka uabi detager, uader deraimer lagelag barot, a nole umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ese eseamud meta kemle ekuei, a dimi abele gab te, a uaba ekuei adige, gab te ipit, kega, Opole, Opole, keribim diski; E detaut, kega, Kaka nole umer kak uaba nagelam; ");
INSERT INTO ulk1902_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Epe uaba ditimeda detaut, kega, Keriba eroli a ereli mari op ge, ma ereuerem keriba gab giz; ");
INSERT INTO ulk1902_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ege E uiabi daratagerare, kega, Kaka nole umer kak uaba nagelam; ua karielam bakeauare, ua uridili adud tonar. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Uaba au ezoli tereg ikupamaretlare, ese uaba erdali Aberahama, pako Isaka, pako Iakobo, pako gaire perofeta uridili Ade ra baselaia ge, a uaba adem dikri. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ui ge tabakeauare sager pekem, pako koki pekem, pako ziai pekem, pako naiger pekem, ui bamer eroare Ade ra baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dasmer, uader keubu ko kekiam, uader kekiam ko keubu. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Abele gerger ge, uader Faresaio tabakeauare, uiaba abi detagerare, Ma adem bakeam: abelelam Heroda E lagelag mari ipit. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ege E uiabi daratagerare, Ua bakeauare, abi detager, abele arobe, Dasmer, kaka demoni adem namuda, a kaka nadgereda gim le abele gerger, pako idim ge, a nerute gerger kaka ikeli eseamuda. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Abkoreb kaka nagemeli abele gerger, pako idim ge, pako nerute gerger: abelelam umer kak nerute perofeta uaeumi nerute uteb, no Ierusalema ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ierusalema ae, Ierusalema, uaba ipit perofeta, pako uaba bakeru narborida uader uabim namarida! kaka lagelag natameare mabara omasker, mokakalam apu faul derap tabara uerem, a uaba nole la kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dasmer, uaba meta dikaer dedkoli; ageakar, kaka Uabi detager, Uaba nole kari umer kak, keubu gerger uaba detautare, kega, Uerkab abele le tabaruk Opole nei ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ege nerute sabath baruk, E bakeamulu nerute kole ra meta, Faresaio le, E lagelag ero, uiaba abi deraimer. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dasmer, nerute le abi opem, begur gim. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ege Iesu de uabi daratagerare, gaire Ereuer gelar giz pako Faresaio giz, kega, Nako abkoreb idigiri gim sabath ge, nako nolea? ");
INSERT INTO ulk1902_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ege uiaba mer baomare. Ege E abi erpei, a abi idigiri, E emariklu. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ege E uiabi daratagerare, kega, Na le nagri asina a kau ege ekesmer auak ge, nako nole sabath ge deguar? ");
INSERT INTO ulk1902_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Uiaba nole abi mer atuat kak abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ege E uiabi daratagerare nerute mer babisdarie uader namarida, E uiabi umele E dikiapor au lu E eidi; ege E uiabi daratagerare, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ese nerute le mari uanatager, kega, Bakeamu uetpurem, ma nole eidi au lu ge: nole nerute aule mari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ege emariklu le bakeamulu uabim, E mari detager, Ekemer pako abele kole: ege ma bakeamulu kebi lu sirip ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mokakalam mari namarida, ma kabeamu eidi kebi lu ge; iaueakai le namarid mari uanatager, kega, Tabakeamu, oe, ueakai ma bakeamu au kalu: iaueakai ma nagri zorom uiabi opem, uader eidi okakis mari dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Abelelam, ese nerute le tababu bakai aule, E kebile; ese nerute le tababu bakai kebile, E aule. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ege E abi detager, le abi namarida, Ese ma derser uetpurem, pako leuer aroem, ma nolea tebudem mer tigri, pako leem mara boai, pako luglug le maike mari dog; iaueakai uiaba ko mari mer tigri, mari bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ese ma derser uetpurem, ma mer tigri uiabim gaire le lu kak, pako atkurit atkurit, pako pone sadamer: ");
INSERT INTO ulk1902_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Iaueakai ma uerkab; abelelam uiaba umer kak mari bodomalam: ia mari bodomalam keubu gerger, gaire le oituli ko obako. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nerute le emeri okakis eroli, ege E asoli gaire lu, epe E abi detager, kega, Uerkab abele le leuer eroli Ade ra baselaia ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ege E abi detager, kega, Nerute le de derseri au uetpur; E mer tigri gaire leem: ");
INSERT INTO ulk1902_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ege abele uetpur gerger baruk, E namariklu abara memeg le uiabim uader namarkare, kega, Ua tabakeuare; abelelam gaire lu uridili emetu derser. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Epe uiaba mer batager, ui ge netate dikiaporare. Ege nerute le lut abi detager, kega, Kai sep arapeilu, abkoreb kaka nabakeamulu dasmer: debele ma kari namarik. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ege nerute le lut detager, kega, Kaka tais faif kau abele kaulam, kaka bakeamu, iaueakai kaka uiabi mirem: debele ma kari namarik. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ege nerute le detager, kega, Kaka nagri kosker, abelelam kaka umer kak bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ege abele memeg le tabakeamu, E abi detager, tabara opole, abele gaire lu. Le giz abele boai au urker, ege tabara memeg le detager, Ma dudum bakeamu mager gabem abele uteb ge, ma taraisauem gaire le nolea lu kak, pako atkurit atkurit le, pako gaire sadamer le. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ege memeg le lut abi detager, kega, Opole, ege emetu ge esemulu gaire lu ge ma natomeret, epe abele meta nole le kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ege abele opole de abele memeg le detager, kega, Ma bakeamulu au gabem, a asakirik, ma uiaba elele daratagerauem ko tabakeamu, iaueakai kara meta mitkar. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Abelegelam kaka uabi detagereda, nole nerute le uiabim mer tigri, eroli kara uetpur ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ege E okakis gaire lekub ge bakeamulu: ege egreemalu, a uiabi daratagerare, ");
INSERT INTO ulk1902_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ese nerute le karim tabakeamu, a nole derara tabara aba, a apu, a kosker, a omasker giz, a boai giz, a berbet giz, pako tabara eded, umer kak E dali kara kaimeg kar. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ese nerute le nole tabara satauro ais, a nole kari narmili, nole abkoreb kara kaimeg kar. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Na le lagelag baker kar ikeli? Debele emeri a dikiapor naket mani bodomalam nako abkoreb iaueakai ikeli eseemuda. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ueakai uiaba abi neg degarare, abelelam E giz ikeli, nole aseamur kak, ");
INSERT INTO ulk1902_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Uiaba detager, kega, Abele le E ditimeda ikeli, a nole aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na opole E lagelag ares nerute opole? Debele emeri a dikiapore nako umele ares abara le ten thausan, epe nerute le tabakeamu aresem, E nagri tuenti thausan le. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ese umer kak ares, debele nerute le emarik, abelelam E muriz ge, E daisumuda nole ares. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mokakalam abele le nole abkoreb kara kaimeg, ese E nole adem gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sol debe lu: ese nole kurabkurab, nako uaba iako kurabem? ");
INSERT INTO ulk1902_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nolea abkoreb sep ge, a nole abkoreb gaire poipi lu giz ge: epe adem bataueret. Ese le nagri grip, debele asoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ege telona uridili pako uit le, uiaba tabakeauare abim, uiaba lagelag asoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Epe Faresaio giz a aotale giz, uiaba mudi mer, kega, Abele le E kemem uit giz, epe uiaba ereueda okakis. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ege E uiabi daratagerare nerute mer babisdarie, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nete uaba le nagri mamoe netate handed, ese nerute mamoe obadimirik, ikedi nainte nain sumez ge, E bakeamu deraimer mamoe badimirida, E lagelag uaerdar? ");
INSERT INTO ulk1902_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ese E uaerdar, E uatekapsi, a sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ese abi boai giz uaerdarare, ege abara debud a maike le uiaba etami okakis, ege E uiabi daratagerare, kega, Debele meriba sererege, abelelam kaka ko erdali kara mamoe ge badimirida. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kaka uabi detager, kega, Mokakalam gaire le kotor ge au sererege le uit a emetu obazgeda, a kebi kebi sererege nainte nain le giz barkak nole dikiapor obazgeda. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nete kosker nagri ten mani, ese nerute mani badimirida, E lamepa disirik, meta ge poipi ame, elele deraimer E lagelag uaerdar? ");
INSERT INTO ulk1902_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ese uaerdar, E darabgeri abara debud pako maikle giz, kega, Debele meriba sererege, abelelam kaka erdali abele mani badimirida. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kaka uabi detager, kega, Mokakalam Ade ra angela kotor ge sererege, le uit a emetu obazgeda. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ege E uiabi daratagerare, Nerute le neisi abara uerem: ");
INSERT INTO ulk1902_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ege keimer tabara aba detager, kega, Baba, ma kari nakuar kara lu. Ege abara lu erag uiabi naisuer. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ege uader gerger basemerare, ege keimered tabara lu etami okakis, ege bakeamulu nerute muriz gedim; E no adud tonar. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ege abara lu esemulu, abele ged uererege; ege nole leuer kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","E bakeamulu emeri nerute le erdar abele ged ge; E abi emariklu abele utebem borom asisiem. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","E au lagelag borom ra poipi leuer, iaueakai abara gem osmeda: nole le abi lu ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ege E umele ge akailu, kega, kara Aba ra gaire memeg le, uiaba kaier areto gaire, a kaka uererege, mop ge eud! ");
INSERT INTO ulk1902_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Debele kaka nakueilu nabakeamulu karbara abem, a abi detager, Baba, kaka uit Le emeri kotor ge, pako mara opem: ");
INSERT INTO ulk1902_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nole abkoreb kaka mara uerem: debele kaka mokakalam nerute mara memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","E ekueilu bakeamulu tabara aba. Ege abi abet muriz ge erdali, epe E au nasenas, E au koreder, a abi erpei, a eskos. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","A ueremet abi detager, Baba, kaka emetu uit Le emeri kotor ge, pako mara opem: nole abkoreb kaka mara uerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ege abet tabara memeg le giz daratagerare, kega, Debele tais perper am uali, debele ame; a ring ame abara tag, a teter gab ame: ");
INSERT INTO ulk1902_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Debele tais kebi kau toertoer, ipit abele, mi aroare, a sererege: ");
INSERT INTO ulk1902_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Abelelam kara uerem peike, E eumida, a ko eded akaida; E badimirida, a ko erdali. Ege uiaba sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Abara narbet uerem emeri sumez ge: E tabakeamulu maike uiaba meta ge, ege asoli uiaba uarup erem, a uedakiriare. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A E dabgeri nerute memeg le, a abi itimer, kega, Nalu pe ua ikereda? ");
INSERT INTO ulk1902_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ege E abi detager, kega, Mara le tabakeamuda; epe mara abet ipit kebi kau au toertoer, abelelam E ko erdali E nagri eded. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Epe E au ueku, umer kak bao meta ge: abara aba E osemelu adige, E abi okadersemer. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ege E abi detager, abara aba, kega, Dasmer, gaire urut kaka mara memeg le, gaire mara mer kaka nole batauered: ma nole kari ikuar kebi nani, ki sererege debudkem: ");
INSERT INTO ulk1902_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ege mara uerem peike, dedkoli mara lu okakis adud kosker, E tabakeamuda, ma pe ipit kebi kau abim. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ege E abi detager, Kara uerem, mi emeri okakis, kara lu uridili, marim. ");
INSERT INTO ulk1902_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ege abkoreb mi sererege: abelelam mara le pedali, E eumida, a ko eded akaida; E badimirida, a ko erdali. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ege E tabara kaimeg giz daratagerare, Nerute lu giz, E nagri memeg le, E sirdam; Ege E abi etomelu, E dedkoli abara lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ege E abi dabger, kega, Nalu lu kaka mari asoli? ma natomer abele lu ma sirdameri; abelelam kaka umer kak ma memeg le sirdam. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Abele memeg le lut E dikiapor muige abara nerkep ge, Nalu lu ka akerer, abelelam kara opole E kari adem abele dorgelam memeg le sirdamelam? Kaka umer kak daiue; kaka sirip damosi. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kaka umele abele lu kaka ikeli, iaueakai ese E kari adem abele dorgelam, a uiaba ko kari nagared uiaba utebem. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ege E mer tigri nerute leem, a nerute leem, uiaba uridili nagri lu uiaba opole; E nerute le detager, Naket lu mari dog kara opole la? ");
INSERT INTO ulk1902_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","E abi detager, kega, Paita uakaisu netate handed. Ege E abi detager, kega, Ma erpei mabara jauali, ma dudum emeri, ma detar fifite. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ege E nerute le detager, Naket lu mari dog? E detaut, kega, Saito kori netate handed. Ege E abi detager, Ma erpei mara jauali, ma detar eiti. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ege abara opole desperer abele memeg le, abara tonar nole barkak, abelelam E au pardar: abelelam geseb le E aule dikiapor uiaba nosik tumem datki le. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kaka uabi detagereda, Abele mamona nole barkak tonar uabim, iaueakai uaba tebud keubu uabi tegaret uiaba meta niai karem. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ese le ageakar kebi lu, E ko ageakar au lu: Ese le nole barkak tonar kebi lu, E ko nolea barkak tonar au lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ese uaba nole ageakar, abele mamona nole barkak tonar, nete le uabi ikuar abele lu giz kar asesered? ");
INSERT INTO ulk1902_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ese uaba nole ageakar subele la lu, nete le uabi ikuar uaba lu? ");
INSERT INTO ulk1902_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Memeg le umer kak dorge ikeli uiabim neisi opole: abelelam E derar nerute le, E omare nerute le; epe nerute, E maike nerute le, a dituaki nerute le. Uaba umer kak Ade ra memeg le, pako mamona. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ege Faresaio giz aserare gaire lu uridili, uiaba lu lag; a uiaba abi negneg. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E uiabi daratagerare, kega, Uaba tonar no bes barkak le la opem; epe Ade umele dikiapore uaba nerkep: abelelam ese debe lu le la opem, E adud Ade ra opem. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Abele gelar giz pako perofeta bakedida Ioane: ditimedelu natomertare Ade ra baselaia ge, a gaire le batumu. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kotor a gesep sobkak uaeseamu, Ade ra gelar giz nolea nerute mog uar uaeseamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ese nerute le dituak abara kosker, a isipi nerute, E eruam: ese nerute le isipi abele kosker, abara kimiar dituak, E eruam. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nerute lu giz ra apu, E ame uali golegole gegur, pako mus uali, E mamor emeri gaire gerger uridili, a debe leuer ero: ");
INSERT INTO ulk1902_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nerute le nole lu kak, nei Lazaro, E eidi abi gab te ge, ege E badbad: ");
INSERT INTO ulk1902_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ege E lagelag ero lu giz ra leuer poipi, abi laulaulam; a omai giz esomed abara bad. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ege abele kerker ge, lu kak le eumilu, ege angela giz abi ais Aberahama ra marmot ge: ege luglug le eumilu, a etkobei. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","A Hedisge, E au asiasi nagri, E egreemalu, E muriz ge erdali Aberahama pako Lazaro E emeri abara marmot ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","E ereretikri, kega, Kara aba, Aberahama, ma kari omare, ma namarida Lazaro akmei tabara tag pem ni ge, ko itimoar kara uerut; abelelam kaka au asiasi abele ur au be. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ege Aberahama de abi detager, kega, Kara uerem, ma dikiapor, gaire debe lu ma nagri mara eded, a Lazaro nagri adud lu abara eded: a peirdi E nagri sererege, a ma au asiasi. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A nerute lu, meriba nagri auak eipu, abelelam keriba umer kak bakeamu uaba uteb, a uaba umer kak tabakeamu keriba uteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ege E abi detager, kega, Kara aba, kaka mari damosi ma abi temarida kara aba ra boai; ");
INSERT INTO ulk1902_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Abelelam faif kara le; ueakai uiaba mamoro asoli, nolea uiaba tabakeamu abele uteb, au asiasi. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ege Aberahama de abi detager, kega, Nagri Mose pako perofeta uiabi dog, iaueakai uiaba asoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","E ge abi detager, kega, Kara aba, Aberahama, nolea: debele nerute le iako takomeda eudelam, ueakai uiaba nagri obazegeda. ");
INSERT INTO ulk1902_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","E ge abi detager, kega, Ese uiaba nole asoli Mose pako perofeta, ese nerute le ko eded akaida, a uiaba nole asor kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","E ge tabara kaimeg giz daratagerare, kega, Umele uatabaruk lu uadatko: epe uaiai abele lu kemle! ");
INSERT INTO ulk1902_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Debele abi perege dimiri au baker sekerseker, a batauered gurim, adud dedkoli nerute kebile. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ua uabim: ese mara le adud tonar marim, ma barditug; ese obazegeda ma abi idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ese sefen gaber netate gerger adud tonar marim, pako sefen gaber netate marim egali, kega, Kaka obazegeda; ma abi idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ege kaimeg giz, Opole detagerare, kega, Ma upinati keriba oituli, ueakai aule. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ege Opole lut uiabi daratagerare, kega, Ese uaba oituli mokakalam sinapi ra turum, a uaba detager abele sukamina, Ma darbumu, a emor gur ge; a nolea ner kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nete uaba memeg le dali sep dereb, pako mamoe asesered, ese tabakeamu sumezlam, E detager, Ma tabakeamu naidi a ero? ");
INSERT INTO ulk1902_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nalu nolea abi detager, Ma derser leuer, pako teupeiem erpei mara ame uali, a derser gaire lu, a kaka eroli a aree; a esemud a ma ero a ere? ");
INSERT INTO ulk1902_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","E detager abele memeg le, iaueakai ikeli lu emetu abi etomereti? Nako nolea. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mokakalam uaba, ese esemuda ikeli gaire lu uridili kaka uabi etomeret, a uaba detager, kega, Keriba memeg le nolea debele; abelelam lu nolea abkoreb keriba ikeli, abele lu keriba emetu ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ege E bakeamulu Ierusalema ge, pako Samaria a Galilaia. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nerute uteb ge osmelu, ge obapitare ten lepera kem, ege uiaba ekue muriz ge: ");
INSERT INTO ulk1902_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ege uiaba ereretikri, kega, Iesu, Opole, keribi omare. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ege E uiabi nardarare, ege E uiabi daratagerare, kega, Bakeuare, ua natomertare zogozogo le. Ui ge bakeuare, epe uiaba idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nerute le emetu opasereret emetu idigir, E ko akomelu, ege Ade desper, a au ereretikri: ");
INSERT INTO ulk1902_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ekesmer abi teter ge, a abi esoao: E Samaria le. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ege Iesu de abi detager, kega, Emetu kaka ten le nadigirda. Nade nain le? ");
INSERT INTO ulk1902_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ui ge nole opasereret kak, akomeret kak, Ade esoao kak, no abele Samaria le. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ege E abi detager, Ma ekue, bakeamu: ege ma nagri eded mabi oatulam. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ege Faresaio giz ui abi itmerare, Na uar ge Ade ra baselaia uatabaruk? ege E uiabi daratagerare, kega, Ade ra baselaia nole uatabaruk erkep ge: ");
INSERT INTO ulk1902_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nole le detager, kega, Dasmer, peike! a nerute, Ike! abelelam dasmer, Ade ra baselaia nagri uabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ege E uiabi daratagerare, tabara kaimeg giz, Keubu gerger tabarki uaba lagelag erdali netate gerger Le la Uerem, a nole ardar kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A uader le giz, uiaba uabi detager, kega, Dasmer peiki! a nerute, Dasmer ike! uaba nole bakeamu, a nole armir kak: ");
INSERT INTO ulk1902_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Abelelam mokakalam ner be erperida nerute paikai kotor ge, a datki nerute paikai kotor ge; mokakalam gerger Le la Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Abkoreb kekiam gaire asiasi abim, a abele nosik uiaba abi dikaer. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mokakalam Noa de ikerer abuar ge, abkoreb abele gerger Le la Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Uiaba erolare, a erelare, a kosker nasiplare, a bakedida abele kerker Noa nar ge barot, epe meg abger tabarki, ege uiaba uridili baum. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mokakalam Lota de ikerer abuar ge; ui erolare, a erelare, a lu teraplare, a lu iritlare, a meta ikelare; ");
INSERT INTO ulk1902_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Abuar ge Lota dikaelu Sodoma, a ur a tei mokakalam irmer kotorlam ui ge baum: ");
INSERT INTO ulk1902_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mokakalam, abele gerger ge ia Le la Uerem uatabaruk. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ese le egimur meta tot ge abele gerger, abara lu muige meta ge, nolea uatabu uaeais: mokakalam le emeri sumez ge, nolea ko akomeret kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Uaba dikiapore Lota ra kosker. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ese nerute le deraimer abara eded emeri mapodan, E dedkoli: ese nerute le dedkoli, E nagri debele. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kaka uabi detagereda, kega, Abele ki, neisi le emeri netate sik; nerute le ais, a nerute no ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Neisi kosker edatimir; nerute kosker ais, a nerute no ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Neisi le emeri sumez ge; nerute le ais, a nerute no ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ui ge abi detagerare, kega, Opole, nade ikeli? Ege E uiabi daratagerare, kega, Abele uteb nagri eud le la gem, gaire aeto etami. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ege E uiabi detaut nerute mer babisidarie, iaueakai ner kak esorerapare, a nolea obogai; ");
INSERT INTO ulk1902_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","E uiabi daratagerare, kega, Nerute autumer le emeri nerute uteb, E nole geum Adim, pako leem: ");
INSERT INTO ulk1902_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Abele uteb nagri kosker, emetu eumida abara kimiar; E ko bakeamulu abim gaire gerger, a abi detager, kega, Ma itimer, le nagri kara lu abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Uader gerger umer kak asoli: a keubu ga dikiapore muige taba nerkep ge, kega, Kaka nole geum Adim, pako leem; ");
INSERT INTO ulk1902_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","A nerute, abele kosker, emetu eumida abara kimiar, E ner kak kari namosili, kaka ko nautumerare abi lu gem, iaueakai nole kari aogat kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ege Opole lut uiabi daratagerare, Ua aserare autumer le la mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ege Ade uapum abelelam gaire abara le, uiaba ner kak ereretikri gerger ge a ki ge, nako uiaba itimer uiaba lu? ");
INSERT INTO ulk1902_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kaka uabi detagereda, E dudum nautumerare uiaba lu. Ese Le la Uerem uatabaruk, nako E nagri le abim oituli geseb ge? ");
INSERT INTO ulk1902_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E ge daratagerare abele mer babisidarie uiabim uader le, uiaba dikiapor oituli, a uader dituaki: ");
INSERT INTO ulk1902_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Neisi le bakeamulei zogo meta ge esorerapare; nerute Faresaio, a nerute telona. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Faresaio no tepteb ekue, E gebgeb esorerapare abele mer, Ade, kaka marim esoao, kaka nole mokakalam uader lu gatkamer le, adud tonar, a eruam, a nole mokakalam abele telona. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gaire sabath ge, neis gaber kaka leuer baili; kaka mari naisuere ten lu kaka erdali. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Abele telona ekuei muriz ge, umer kak kotorem egreemalu, epe marmot ge bamu, a detager, kega, Kara Ade, ma omare kaka uit le. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kaka uabi detager, kega, Abele le bakeamu taba metaem, E debele, nole mokakalam nerute: abelelam E lagelag aule, le kebile; abele le E lagelag kebile, E aule. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ege uiaba tais sursur sursur uerem, iaueakai E uiabi uaituti: ege kaimeg giz erdarare, ege uiaba daisumdarare. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Iesu de nardarare, a uiabi darabgerare, kega, Karim sursur sursur uerem taraisare, ua nolea daraisumdarare: abelelam mokakalam uader emeri Ade ra baselaia. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ageakar, kaka uabi detagereda, Ese nerute le nolea erpei Ade ra baselaia, E mokakalam kebile, umer kak ko bardare. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ege nerute kole lut abi itimer, kega, Ereuer debele, nalu lu kaka ikeli, iaueakai kaka nagri eded aseamur kak? ");
INSERT INTO ulk1902_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A Iesu de abi detager, kega, Nalu ma detager kaka debele? nolea le debele, netate Ade tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ege ma umele Ade ra gelar, Ma nolea adud tonar, Ma nolea ipit eumilu nerute le, Ma nolea eruam, Ma nolea bes mer, Mamoro asoli mabi abera a apuera. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ege E abi detager, kega, Kaka irmili gaire lu uridili kebi ueremlam. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ege Iesu de asoli abara mer, ege abi detager, kega, Netate lu ma nolea erdali: ma terapei mara lu uridili, ma naisuerare uader le nole lu kak, iaueakai ma nagri debe lu kotor ge: a ma tabakeam, kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ege E asoli abele mer, abara nerkep au asiasi; abelelam E lu giz ra apu. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Epe Iesu abi dasmer, E detager, kega, Au beber lu giz ra apu barota Ade ra baselaia! ");
INSERT INTO ulk1902_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamela norgor ko badare atketlu muige, a le lu giz ra apu etkoprida Ade ra baselaia badare. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Uader le giz aserare abele mer, a uiaba detagerare, kega, Ese mokakalam, nete le umele eded? ");
INSERT INTO ulk1902_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ege E uiabi daratagerare, kega, Abele lu le umer kak ikeli, epe Ade umele ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Epe Peteru abi detager, kega, Dasmer, keriba dikaer gaire lu uridili, a keriba mari irmili. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ege E uiabi daratagerare, kega, Ageakar, kaka uabi detager, kega, Ese nerute le dikaer tabara meta, pako aba a apu, pako tabara le, pako tabara kosker, a omasker, Ade ra baselaialam, ");
INSERT INTO ulk1902_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Epe E nagri gaire dordor lu peirdi, pako kerker ge niaiem, eded aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","E ge naisare tuelf le, E uiabi daratagerare, Dasmer, mi nabakeuare Ierusalemaem, iaueakai ageakarem gaire lu uridili perofeta giz detarare abele mer abim Le la Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Abelelam, E nakuarare uiabim gaire nogle, ui ge abi negdegarare, a abi dedkoli, a uiaba mosu ituare: ");
INSERT INTO ulk1902_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","A uiaba abi damarik, a abi ipit eumilu: a thri gerger E ko eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A uiaba umer kak asoli gaire lu; ege ispilu abele mer uiabim, uiaba umer kak abele mer, E uiabi daratagerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ege E maike Ieriko ge, a nerute sadamer le emeri gab ge E lu damosi: ");
INSERT INTO ulk1902_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ege E asor gaire le lakub bakeuare, E uiabi nautumerare, kega, Nalu abele lu? ");
INSERT INTO ulk1902_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ui ge abi detagerare, kega, Iesu, Nazareta le, E bakeamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ege E ereretikri, kega, Iesu, Dauida ra Uerem, ma kari omare. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ui ge, uader kekiam, a abi daisumdarare, Ma baimi: epe E au kase ereretikri, Dauida ra Uerem, ma kari omare. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ege Iesu ekuei, a uiabi daratagerare, kega, Karim tegardare; ege abi maiem, a abi itimer, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nalu lu ma laglag, kaka marim akere? E abim detaut, kega, Opole, kara pone bakaerti. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ege Iesu de abi detager, kega, Mara pone obakaelei: mabi oatulam ma nagri eded. ");
INSERT INTO ulk1902_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ege abara pone bakaelei, E abi irmili, E Ade deseper: ege abele le uridili ui nardarare, epe uiaba Ade desepereda. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E Ieriko ge osemelu, a bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Dasmer nerute le, abara nei Sakaio; E au telona le, a lu giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E laglag dasmer, Iesu nako; a umer kak abelelam gaire le lakub, a nerute, E teupei. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ege E au koreder gaire le la opem, E ogi nerute lu ge, nei sukamoru, E laglag abi dasmer: abelelam E abi gab dirier. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ege Iesu tabakeamulu abele uteb ge, a egreemalu, a abi erdar, E abi detager, kega, Sakaio, ma tarabu; abkoreb kaka emeri mara meta abele gerger. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ege E tabu, abi detager, E au sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ege gaire le giz abi erdarare, a uiaba mudmer, kega, E bakeamu uit le la meta. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A Sakaio ekuei, a abi detager, kega, Opole, dasmer, kaka arage karbara lu uader nole lu kak; ese nerute le au ueku karim kaka uapum, a kaka bodomalam neis a neis gaber. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ege Iesu de abi detager, kega, Azimoaret tabarki abele boai abele gerger ge, abelelam E dali Aberahama ra uerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Abelelam Ade ra Uerem tabarki deraimerare le badimirida, ueakai uerkabu. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ui ge dimiruartare abele lu, ege E uiabim ko detager nerute mer babisdarie, iaueakai maike Ierusalema, abelelam ui dikiaporare Ade ra baselaia pe detomereta. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Abelelam E uiabi detager, kega, Nerute kele bakeamu nerute muriz gedim, ueakai nagri lu, a E lagelag opole, a iako takomeda. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ege E darabgerare ten abara memeg le, E uiabi naisuerare ten paun, E uiabi daratagerare, Ua erapare a iako uatabakomeret. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ege abara ged au ueku abim, abelelam uiaba emarkare, a detagerare, kega, Keriba nole lagelag abele le keriba opole. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","E ge ko akomelu abelelam E nagri lu, ueakai E opole, ege E uiabi darabgerare, tabara memeg le, nagri abara mani uiabi dog, iaueakai E umele nako abara mani dordor lu terapei. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A nerute le tabakeamulu, a abi detager, kega, Kole, mara paun, kaka nagri ten paun ko. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","E abi detager, kega, Au debele, debe memeg le: abelelam ma ageakar kebi lu, ma sirdam ten uteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nerute le tabakeamu, a abi detager, kega, Kole, mara paun, kaka nagri faif paun ko. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","E abi detager, kega, Ma sirdam faif uteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nerute le tabakeamu, a abi detager, kega, Kole, dasmer, mara paun, kaka ikedi ages: ");
INSERT INTO ulk1902_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Abelelam kaka mari geum, kaka umele mara tonar: ma ais abele lu ma nolea ikedi lokod ge, ma igiri abele saito ma nolea ariti kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ege E abi detager, kega, abele memeg le adud tonar, Mara mer abelelam kaka mari bodomalam. Ma umele kara tonar, kaka ais abele lu kaka nolea ikedi lokod ge, a igiri abele saito nolea kara aritilam; ");
INSERT INTO ulk1902_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nalugelam ma nolea ais kara mani abele meta mani terapei, iaueakai kaka iako tarakomelu nagri lu abkoreb? ");
INSERT INTO ulk1902_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","E uiabi daratagerare, uader obako, Uaba itkamer abele paun, ikuar nerute le ten paun. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ui ge abi detagerare, kega, Kole, nagri ten paun. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Abelelam kaka uabi detagereda, Ese le nagri lu, E ais; ese nerute le nolea lu kak, E itkamer abara lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nerute, uader kari derar, uiaba nolea kari lakak ko uiaba opole, uaba kari eguatumur peike abele uteb ge, uaba ipit kara opem. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ege mer eseemulu, E kekiam bakeamulu Ierusalema ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ege maike Bethefage a Bethania, abele paser ge, nei Oliua, epe E namarid neis abara kaimeg giz, ");
INSERT INTO ulk1902_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","E uiabi daratager, kega, Ua bakeamulam abele uteb uabi opem, ese ua osemedariei abele uteb ge, uaba erdali kebi asina didbaredi, nolea le abi sor agimur kak: uaba abi detue, karim tegared. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ese nerute le uabi itimer, Nalugelam uaba abi detue? A ua abi detageram, kega, Opole abi lagelag. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ui ge bakeamulei, a ui erdali, mokakalam abara mer uiabi daratager, ");
INSERT INTO ulk1902_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ui ge detuei abele kebi asina, a uader le giz uiabi nautumerare, kega, Nalugem uaba detuei abele kebi asina? ");
INSERT INTO ulk1902_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A uiaba detaut, kega, Opole abi lagelag. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ege ui abi egaredelei Iesuim: ui ge uiaba ame uali abi sor ge dikmerikare abele kebi asina ge, ui ge Iesui agiserare abi sorge igimerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","E bakeamulu, a uiaba ame uali gab ge esagerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ege maike abele gorgor paser ge, nei Oliua, ui ge, abara kaimeg giz uridili, ditimedarare sererege, uiaba au ereretikri Ade despelare, abelelam atamelam uridili uiaba erdali; ");
INSERT INTO ulk1902_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ege uiaba detautare, kega, Uerkab pe abele Opole, tabarki Iehoua ra nei ge: uerkab kotor ge, a deseper abele lu tumege. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ege uader Faresaio giz, pako lekub ge, uiaba abim detager, kega, Ereuer le, ma bardaratkare mabara kaimeg giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","E uiabi daratagerare, kega, Kaka uabi detager, ese uiaba nole mer kak, a baker peike umele detaut. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Maike, E erdali abele uteb, E ezoli, ");
INSERT INTO ulk1902_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","E abi detager, kega, Ese ma umele abele gerger, abele lu ueakai marim debele! a nerute, ma nole erdali. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Abelelam keubu gerger uatabaruk, gaire uaba taip uanartare a uanatumdare, uader au ueku uabim, uiaba deraueli marim, gaire uteb uridili, ");
INSERT INTO ulk1902_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A uiaba mari ikeli no sep ise, pako mara omasker muige mari dog; nole nerute baker ko igi tumem nerute baker muige mari dog; abelelam ma nole umer kak na uar ge uatabaruk mari uanardar. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","E balu muige zogo meta, ge, E namuare adem uader le uiaba lu terapeirare, ");
INSERT INTO ulk1902_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","E uiabi daratagerare, kega, Emetu detali, Kara meta, esorerapare meta: a uaba ikeli mokakalam baker kur ge eruam le giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ege E ereuerem muige zogo meta gaire gerger. A zogozogo le giz, pako aotale giz, pako tarim le, abele ged ge, ege uiaba lagelag abi ipit: ");
INSERT INTO ulk1902_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","A nerute, uiaba umer kak ikeli; abelelam abele ged ge uridili au lagelag abi asoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nerute gerger, E ereuerem abele ged ge, muige zogo meta, a etomeret debe mer, a uiaba zogozogo le giz a aotale giz, a aule giz ekue; ");
INSERT INTO ulk1902_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","A uiaba abi detager, kega, Mase ma keribi detager, Nalu abele sirdam ma ikeli abele gaire lu? nete le mari ikuar abele sirdam? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","E uiabi detaut, kega, Kaka uabi itimer netate merem: ua kari natagerare: ");
INSERT INTO ulk1902_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nako Ioane ra bapataiso nagelam, nako kotorlam, nako lelam? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A ui mer batagerare, kega, Ese meriba detaut kotorlam; mena E meribi detager, kega, Nalugelam uaba nole abi oituli? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ese meriba detager, kega, lelam; epe abele ged ge meribi bakeru ditimeda: abelelam ui ge dikiaporare Ioane perofeta. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Epe uiaba detaut, kega, Keriba umer kak nagelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Epe Iesu uiabi daratagerare, kega, Kaka umer kak uabi etomeret abele sirdam kaka ikeli gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ege E uiabi daratagerare abele mer babisdarie: Nerute le ikeli uina gedub, E uiabi nakuarare uader dorge ikeli abele gedub ge, a E bakeamu muriz gedim gaire gerger barkare. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ege nurge baruk, E uiabim, gedub le, emariklu nerute memeg le, abele uina turum ko tais: ege uader le, emeri abele gedub ge, uiaba abi damarik, abele le no akomelu nolea turum asis kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A E ko emariklu nerute memeg le: a uiaba abi ko damarik, a abi dituaki, E ko akomelu nole turum asis kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ege E ko namarkare neisi netate le: a uiaba abi naresedare maike uaeeumidare, a ui ge abi adem bakeuidare. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ege abele gedub kem le lut dikiapore, kega, Nalu ka akailu? kaka namariklu kabara nasnas uerem: nako, uiaba abi erdali, a abi omare. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","A gedub le giz abi erdarare, ege uiaba mer batagerare, kega, Abkesem peike: mi abi apitare, iaueakai mi aisare abara ged. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","A uiaba adem emarikare sorem abele gedublam, a ui abi ipitare eumilu. Nalu lu gedub kem le lut uiabim ikeli abkoreb? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","E tabakeamulu, a gedub asesered le narsare, E ko nakuarare uina gedub uiabim uader le. A ui ge asorare, a uiaba detaut, kega, Nolea. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","E uiabi dasmer a detager, kega, Nalu mer emetu detali, Abele baker tonar tonar le lut adem batauered, a mena ais meta kop tum ge? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ese le ekesmeri abele baker ge tumem, a lid erapei; a ese baker etugered abi tumge, no obamuare. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ege zogozogo le giz, pako aotale giz, uiaba lagelag abi erpei abele haua ge; a uiaba au geum abele ged; abelelam uiaba umele, abele mer uiabim babisdarie. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ui ge deraimerare, a uader namarkare abi dasmerare, a uiaba bes oituli, iaueakai nagri mer, a uiaba ais ikuar opole ra tagem a sirdamem. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","A ui ge abi itimerare, kega, Ereuer le ae, keriba umele ma barkak detaut pako ereuer, ma nole omare nerute le, a dikaer nerute le, epe ma ereuerem ageakar Ade ra gab: ");
INSERT INTO ulk1902_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nako, abkoreb keriba ko ikuar Kaisaraim zegu lu, a nolea? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","A E umele uiaba dikiapore, ege E uiabi daratagerare, kega, Nalugelam uaba kari mirem? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Debele ua kari denari natomertare. Nete ra op abele, pako abele detarda? Ui detagerare, kega, Kaisara. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ege E uiabi daratagerare, kega, Kaisara ra lu, Kaisaraim ikuar; Ade ra lu, Adim ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ui umer kak derpeirare abara mer le op ge abele ged ge: a ui abara mer damerare, a uiaba mer kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Uader Sadukaio giz, abim tabakeuare, a ui dikiaporare, kega, Nole le ko eded akaida eudelam; a uiaba abi itimerare, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ereuer le ae, Mose detali keribim, Ese nerute le la keimer eumida, abara kosker dikaerti, a nole uerem kak, abara keimer abele kosker egared, ko keimer kesem. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sefen keimer giz: narbet kekiam ko ispida abara kosker, epe eumid, nole kesem kak; ");
INSERT INTO ulk1902_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A nerute keimer abele kosker egared, epe eumid, nolea kesem kak, mokakalam nerute keimer. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A thri le ko ispid; mokakalam bakedida sefen le, uiaba eumida, nole kesem kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A keubu, kosker eumida. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ese ko eded akaida tabarki, nete le uiabielam ais abele kosker? abelelam sefen le egared abele kosker. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu uiabim detaut, kega, Peirdi, abele eded, kimiar kosker ispid: ");
INSERT INTO ulk1902_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","A uiaba nagri debele, abele ko eded akaid, a nagri niaiem kerker, uiaba nole ispid kosker, a nole ispid kimiar: ");
INSERT INTO ulk1902_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","A uiaba nolea ko eumid: epe uiaba mokakalam angela; a uiaba Ade ra omasker, a le giz ko eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Abele ko eded akaida eudelam, Mose de natomertare abele lu, nerute lu dardar, ko etomeret Iehoua Aberahama ra Ade, a Isaaka ra Ade, a Iakobo ra Ade. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","E nole uiaba Ade, abele le eumida, epe le giz eded: abelelam le uridili eded abielam. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ege uader aotale giz abi detager, kega, Ereuer le ae, mara mer au barkak. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Keubu uiaba nolea ko saserim abi itimer nerute lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ege E uiabi daratagerare, kega, Nako uader detaut, Keriso, Dauida ra uerem? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ege Dauida de detaut, Salamo jauali, E detager, kega, Iehoua, kara Opole detager, kega, Ma emeri kara tuter tag pek, ");
INSERT INTO ulk1902_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kaka ikeli uader mari derar, abele uteb ma teter emeri. ");
INSERT INTO ulk1902_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Abele lu Dauida de etomeret abara Opole, nako ikeli abara uerem? ");
INSERT INTO ulk1902_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ege E uiabim detager, tabara kaimeg giz, a gaire le uridili abele ged ge, uiaba asarare, ");
INSERT INTO ulk1902_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ege uaba mamoro dasmerare gaire le aotale giz, uiaba digemeli perper am uali, ege uiaba lagelag gaire le uiabi omare pur uteb ge, pako aule bao sunago ge, a aule lu eidi abele uteb ge leuer eroare; ");
INSERT INTO ulk1902_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ege uader dedkoli mai kosker ra meta, a uiaba esorerapare au perper: E ispilu, a keubu uiaba au bodomalam. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ege E egreemalu, E erdali lu giz ra apu, uiaba batauered uiaba mani, abele uteb mani ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ege E erdali nerute mai kosker, nole lu kak, E batauered neisi kebi mani. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ege E uiabi detager, kega, Ageakar, kaka uabi detager, kega, Abele mai kosker, abara mani batauered, E aule uiabi dog uridili: ");
INSERT INTO ulk1902_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Abelelam uiaba uridili batauered uiaba mani, gaire uiaba lulam: ege abele mai kosker, nolea lu kak, E batauered abara kebi mani uridili, abkoreb abara eded. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ege uader mer batagerare abele lu muige zogo meta ge, ege mamoro derser debe baker, pako uader zeku lu muige zogo meta, E uiabim daratagerare, kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ege gaire lu uaba dasmerare, keubu gerger tabarki, nole baker ko igi tumem nerute baker, a nole abu kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ui ge abi itimerare, kega, Ereuer le, na kerker ge gaire lu tabarki? a nalu atamelam gaire lu tabarki? ");
INSERT INTO ulk1902_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","E uiabim detaut, kega, Uaba mamoro dikiaporare, nerute le uabi okardare: abelelam gaire le ko uatabarkare kara nei ge, kega, Kakanali. Ege abele kerker maike: uaba nole uiabim irimili. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ese uaba asoli ares, a mirem, a uaba nole geum: abkoreb kekiam abele lu uatabaruk, a mop uarem. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","E uiabi daratagereda, kega, Nerute ged tekuei obapit nerute ged, a nerute baselaia obapit nerute baselaia: ");
INSERT INTO ulk1902_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Au demali ia uanagiri abele uteb ge, a nerute uteb ge, a uererege, a gimgim, a urker, a gaire atamelam kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Gaire lu nole tabarki, a uiaba uabi erpei, a dedkoli, a uiaba uabi uademarkar sunagoem, pako audbar metaem, a uiaba uabi uadeguatare opole giz opem, kara neilam. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Abele gaire lu uabim atamelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Abele lu, debele ikedi uabi nerkep ge, iaueakai uaba nole kekiam deraimer, a dikiapor na mer ko detager: ");
INSERT INTO ulk1902_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Abelelam kaka uabi dekuarda abele mer, a pardar, umer kak nerute le uabi asared, uaba au saserim. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A uaba ab giz emarik, a keimer giz, a boai giz; a uader uabi ipit eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Gaire le uridili ko uabi derar, kara neilam. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","A uaba kerem mus, nole nerute mus abi. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ese uaba debe tonar, a uaba eded nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ese uaba erdali Ierusalema ge, urker ares deraueli, a uaba dikiapor maike dedkoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Abele gerger uader emeri Iudaia ge, debele uiaba bakeuare paserem; uader emeri muige abele uteb ge, debele ui adem obakeuare; uader emeri sumez ge, uiaba nole ko akomeda muige abele uteb ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Abelelam abele kerker bodomalam, iaueakai gaire lu ageakarem emetu detarare. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Uaiai uiaba kosker kem, pako uiaba nano emeli abele gerger giz! abelelam au asias tabarki abele ged ge, pako urker. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A uiaba eumid teibur aosaos tulik gargerlam, a uiaba no bakeamu gaire ged uridili: a gaire nogle uiaba dedkoli Ierusalema, a keubu abele nogle giz uiaba erdali uiaba mop. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Lem kotor ge nagri atamelam, pako meb, a uer giz; geseb ge gaire ged nagri geum, a gur ge maisu a zauber nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Gaire le no eumida abele geum ge, a naokaili gaire lu ko tabarki gesepem: abelelam urker kotorlam demali. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Epe uiaba erdali Le la Uerem tabarki baz kotor ge, E au adigri au zoromzorom. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ese ditimeda gaire lu, debele uaba bager a kerem iteare; abelelam maike uaba eded nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","E uiabim detager, nerute mer babisdarie, kega, Uaba dasmerare abele suke pako gaire lu uridili: ");
INSERT INTO ulk1902_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ese lulam eperekilu, a uaba dasmer, a uaba umele maike urueri urut. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Abkoreb, ese uaba erdali abele lu emetu ikeli, a uaba dikiapor Ade ra baselaia maike. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ageakar, kaka uabi detager, kega, Abele nosik le nole abu kak, kekiam abele gaire lu uridili tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kotor a geseb ko abu, a kara mer giz nole abu kak, ");
INSERT INTO ulk1902_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ua mamoro dasmer, iaueakai uaba nerkep nole beber, a gebgeb, a paim, a nole badumu geseb lugem, abelelam abele gerger keserkeser tabarki: ");
INSERT INTO ulk1902_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Abelelam mokakalam pom tabarki, gaire le uridili emeri geseb ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Debele uaba mamoro dasmer, a derser, a ner kak esorerapare, iaueakai uaba au saserim, gaire lu maike tabarki, a mamoro ekuei opem Le la Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Abara tonar E ereuerem gerger ge, muige zogo meta, ki ge osmed, E emeri nerute paser, nei atker Oliua. ");
INSERT INTO ulk1902_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Idim ge, abele ged ge uridili tabakeuare abele zogo meta ge, lagelag asarare abara mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ege maike uetpur, areto nole aber kak, abele nei atker Paseka. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Zogozogo le, pako aotale giz uiaba deraimerare nalu tonar uiaba ko abi ipitare; abelelam uiaba au geum abele ged. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ege Satana balu muige Iuda, nei atker Isakariota, abara nerkep, E nerute tuelf le. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","E bakeamulu zogozogo le a pako ares kerem le, a uiabi daratagerare, kega, Nalu ka akailu, iaueakai abi keserkeser uabim? ");
INSERT INTO ulk1902_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ege ui au sererege, a abi detagerare ko abim mani naisuerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Abara nerkep au sererege, E ditimedelu abi deraimer, na uarge umele abi keserkeser, a abi uiabi uanatomeretare, a nole lekub kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ege abele gerger, areto nole aber kak, tabarki, abkoreb paseka ipit. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ege E uiabi namariklu Peteru a Ioane, a daratager, kega, Ua bakeamulam derseram abele paseka, abkoreb meribim mi aroare. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Epe uiaba abi detager, kega, Na uteb ge mama lagelag ki derserei? ");
INSERT INTO ulk1902_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ege E uiabi daratager, kega, Dasmeram, ese ua erdariei abele uteb muige, a ua op nerute le dipitiei, E ais nini tarpor; a ua abi irmirauam abele meta ge obaoa. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","A uaba itimer boai kemle, Ereuer le mari detager, kega, Nade suble la uteb, paseka derser ki aroare, kaka pako kara kaimeg giz? ");
INSERT INTO ulk1902_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ege E uabi natomelu nerute au uteb kotor, emetu derser: a uaba paseka derser. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ui bakeamulei, a erdarei, mokakalam abara mer: epe uiaba paseka derser. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ege abele haua ge, ui baid eroare, epe abara kaimeg giz tuelf le, E uiabi kemem. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ege E uiabi daratagerare, kega, Kara lag, kaka au lagelag kekiam eroli abele paseka uabim, a kara asias nole tabarki: ");
INSERT INTO ulk1902_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Abelelam kaka uabi detagereda, kega, Kaka nole ko eroli, kekiam Ade ra baselaia ge eseemud. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","E tanelu ekao, a esoao, a uiabi daratagerare, kega, Uaba erpei abele tanelu, a uabu nakuarare: ");
INSERT INTO ulk1902_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Abelelam kaka uabi detagered, Kaka nole eroli uina turum ge, kekiam Ade ra baselaia tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","E areto ekao, a esoao, a itur, a uiabi nakuarare, a uiabi daratagerare, kega, Kara gem peike, E uabi nakuarare: uaba ikeli kara atamelam. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ege emetu leuer eroare, a tanelu ekao ko, E uiabi daratagerare, kega, Abele tanelu kerkar tom kara mam, uabim epaitered. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dasmer, kari dog abele laulau ge, nerute le la tag, E kari keserker. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Le la Uerem obakeamu mokakalam abim gobarem: epe abele le abi keserkeser, Uaiai! ");
INSERT INTO ulk1902_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ui ge ditimedare deraimerare, nete le ikeli abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A uiaba asared, nete le aule. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","E uiabi daratagerare, kega, Nogle la opole, uiaba opole; uader uiabi sirdam, etomereti uiaba au debe tonar. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","A uaba nole mokakalam: ese le uabim aule, E mokakalam kebile; ese le sirdamu, E memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Epe nete le aule, nako le eidi eroli, nako memeg le? nako nole le eidi eroli? epe kaka uabi kemem mokakalam nerute memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Epe uaba mamoro emeri kari mirem: ");
INSERT INTO ulk1902_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mokakalam kara Aba E kari ikuar abara baselaia, abkoreb kaka uabi ikuar, ");
INSERT INTO ulk1902_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Iaueakai uaba eroli, a ereli, abele leuer aro uteb kara baselaia ge, a emeri opole bao ge, a itimer Isaraela tuelf nosik. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ege Opole abi detager, kega, Simona, Simona, dasmer, Satana au lagelag uabim, iuaeakai E uabim derser, mokakalam saito derser: ");
INSERT INTO ulk1902_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","A kaka Adim damosi marim, iaueakai mara oituli nole aseemur kak: marim, ese depegeli mara nerkep, a mama au saserim mara le. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ege E abim detaut, kega, Opole, kaka marim okakis bakeamu audubar meta, pako eumida. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ege E abi detager, kega, Peteru, kaka mara natager, kega, Kimiar faul nole ereretikri kak abele ki, a kekiam thri kari nasared ma nole kari umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ege E uiabi daratagerare, kega, Kaka uabi demarida, uaba nole epei mani, a pako epei, a teter gab, nako uaba nole nerute lu kak? A uiaba abi detager, kega, Nolea. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","E uiabi daratagerare, kega, Abele lu, ese nerute le nagri epei mani, debele erpei, a pako epei; le nole teibur aosos tulik, debele abara am uali terapei, ko nagri. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Abelelam kaka uabi detagereda, kega, Debele karim ageakarem abele lu emetu detar, A okakis etag uader uit tonar le; abelelam pe gaire lu karim emetu detarda maike detomeret. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Uiaba abi detagerare, kega, Opole, dasmer, neis teibur aosos tulik. E uiabi daratagerare, kega, Sina. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A E bakeamulu adem digemli nerute paser, nei Oliua, mokakalam abara tonar; abara kaimeg giz abi irmilare. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Abele uteb ge, E emeri, a uiabi daratagerare, kega, Uaba esorerapare, iaueakai nole mirem tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ege E bakeamulu adem uiabielam, mokakalam baker murzem batauered; E kokamamu, a esorerapare. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","E abi detager, kega, Aba, ese ma lagelag, abele tanelu karielam adem: kara lag nole ikeli, debele mabara lag ikeroa. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Angela kotor ge abi etomelu, E ikuar saserim. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","E au asias, a elele esorerapare: abara mereg mokakalam kepmam, E abi sep ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","E emetu esorerapare, a ekueilu bakeamulu taba kaimegem, a uiabi naradarare ui ge utirdeder, uiaba nerkep au beber, ");
INSERT INTO ulk1902_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","E uiabi daratagerare, kega, Nalugelam uaba uteidi? ua bako, esorerapare, iaueakai nole mirem barot. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","E uiabi meratager, a dasmer, gaire le lakub pako Iuda, nerute le tuelf lelam, E kekiam uiabi dog; a maiem Iesuim, E lagelag eskos. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","A Iesu abi detager, kega, Iuda, ma keserkeser Le la Uerem, a eskos? ");
INSERT INTO ulk1902_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Uiaba umele abele lu uiaba ikeli, ui ge abi detagerare, kega, Opole, nako ki uiabi daramerkare abele teibur aosos tulika? ");
INSERT INTO ulk1902_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nerute le uiabielam E ipit zogozogo le la memeg le, E dikiam abara tuter laip. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","A Iesu de uiabi daratagerare, kega, Sina. E itut abara laip, a ko barkak. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iesu uiabim detager, gaire zogozogo le, pako kerem le abele zogo meta ge, pako aule giz, ui tabakeauare abim, Nako uaba karim tabakeauare, gaire teibur aosos tulik, a gabagaba kem, mokakalam deraimerare lugatkamer le? ");
INSERT INTO ulk1902_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mi okakis zogo meta ge, gaire gerger, a uaba tag nole kari erpei: a uaba ikeli abele ki, a kupikupi sirdam. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","A ui ge abi erpeirare, a tegared zogozogo le giz ra meta. A Peteru muriz ge abi irimli. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ui ge ur eskaisirare muige meta ge, a uiaba lokod ge emeri, a Peteru uiabi kemem. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nerute memeg neur, E abi erdali emeri maike ur ge, E dasmer, a detager, kega, Abele le E Iesuim okakis. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","E abi asared, kega, Neur, kaka nole umer kak abele le. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mena, nerute le ko abi erdar, a kega, Ma uiaba le. A Peteru abi detager, kega, Nolea kaka. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ege emetu netate haua, nerute le lut elele detager, kega, Ageakar, abele le E abi kemem: abelelam E Galilaia le. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peteru abi detager, kega, Kaka nole umer kak abele lu mama detautili. Epe kimiar faul sobkak ereretikri, abele kerker E mer egali. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ege Opole egreemalu, E abi dasmer Peteru. Epe Peteru de ga dikiapor Iesu ra mer ge, abi detager, kega, Kimiar faul nole ereretikri, ma neis netat kari nasared. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ege Peteru adem eosmelu, a au ezoli. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Uader uiaba Iesu erpeirare, a abi negneg, a damarik. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Uiaba demed abara op, a uiaba abara op erap, a itimer, kega, Ma dikiapor, nete mari ipit? ");
INSERT INTO ulk1902_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Gaire mer, a uader abi adud meru ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ege gerger ge, gaire kerem le, abele ged ge, uiaba etami netat uteb, pako zogozogo le giz a aotale giz; epe uiaba abi egared uiabi opem, a kega, ");
INSERT INTO ulk1902_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ese ma Keriso kar, ma detaut keribim. Epe E uiabim detager, kega, Ese kaka uabi detager, a uaba nole kari oituli: ");
INSERT INTO ulk1902_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ese kaka uabi itimer, a uaba nole kari natautare. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","E ditimeda peirdi, Ade ra Uerem emeri tuter peik, Ade ra au adigri. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ui uridili abi detaut, kega, Nako mama Ade ra Uerem? E uiabi daratagerare, kega, Karim pe ua abele mer tegareda. ");
INSERT INTO ulk1902_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","A uiaba detaut, kega, Nalugelam meriba iako ko deraimer uader etomereti? abelelam meriba emetu asoli abara mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ege uiaba uridili bako, a abi egardare Pilatoim, ");
INSERT INTO ulk1902_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A abi etomeretare, kega, Keriba erdali abele le, E mer desakili abele ged ge, E daisumda nole Kaisarai lu aisuerare, kega, E Keriso Opole. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A Pilato abi itimer, kega, Nako ma Iudaia giz Opole? Ege E abim detaut, kega, Eko, mama detager. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato de uiabi daratagerare, zogozogo le, a le lakub, Kaka nole nerute uit lu ardar kak abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","A uiaba mena elele detager, kega, Epe E desakili abele ged ge, E ereuerem Iudaia uridili, E ditimeda Galilaia, a bakedida abele uteb. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ege Pilato abele lu asor, E nautumerare, kega, E Galilaia le? ");
INSERT INTO ulk1902_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","E umele E Heroda ra baselaia le, E abi Herodaim ikuar, abele kerker E emeri Ierusalem ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroda de Iesu erdali, E au sererege: abelelam gaire gerger E lagelag abi dasmer, E asoli, kega, E gaire lu ikeli; E lagelag dasmer atamelam ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","E abi itimer gaire merem; epe E nole abi detager nerute mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A zogozogo le a aotale giz, ui bako, a elele abi etomeret. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroda pako abara ares le, uiaba abi dituaki, a abi negneg, a zoromzorom uali ame, a ko Pilatoim egaredare. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ege Pilato a Heroda, uiaba ko debele abele gerger: abelelam uiaba kekiam ueku ueku. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ege Pilato de etami netat uteb zogozogo le, a tarim le, abele ged ge, ");
INSERT INTO ulk1902_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","E uiabi daratagerare, Ua tegardare abele le karim, mokakalam pe desakili abele ged: dasmer, kaka itimer uaba op, kaka nole ardar kak nerute lu abi dog, nole abkoreb gaire mer uaba abi etomeret: ");
INSERT INTO ulk1902_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A Heroda nole umer kak: abelelam kaka uabi demarida abim; dasmer, nole nerute lu ikeli iaueakai abkoreb eumida. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Abele lu kaka kekiam barditug, a keuba kaka abi adem. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Debele, E namarid nerute le uiabim, abele uetpur ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Le lakub uridili, uiaba ereretikri, kega, Adem abele le, debele Barabasa emarida keribim: ");
INSERT INTO ulk1902_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Abele le azirkare muige audbar meta, E adud tonar abele uteb ge, a le ipit eumida. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Epe Pilato ko uiabim mer detaut, abelelam E lagelag Iesu adem; ");
INSERT INTO ulk1902_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","A uiaba au kase ereretikri, kega, Satauroem, satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","E neisi netat gaber E detaut, kega, Nalu adud E ikeli? Kaka nole umer kak adud lu ikeli iaueakai abkoreb eumida: debele kaka abi barditug, a keubu namarida. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","A uiaba elele ereretikri, a damos, iauaekai abi satauroem. Uiaba kodomer au saserim, pako zogozogo le giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ege Pilato de uiabi daratagerare, kega, Uaba lag ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ege E abi adem detue nerute le uiabielam, muige audbar metalam, abelelam E au adud tonar, a le ipit, uiaba au lagelag abi adem emarik; Epe E Iesui uiabi nakuarare, mokakalam uiaba lag. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Uiaba abi tegared, epe uiaba erpei Simona, nerute Kurene, le, E tabakeam sumezlam, a uiaba abi ikuar abele satauro, E kodrom dikemerik, a Iesui irmili. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A gaire le lakub abi irmili, a kosker giz, a uiaba bazuer. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A Iesu uiabim egreemalu, a daratagerare, kega, Ierusalema neur giz, uaba nole ezoli karim, debele ua uabu baguauem pako uaba omasker. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Dasmer, keubu kerker tabarki uader detaut, kega, Uerkab soasoa, kosker nole uerem kak, pako nano are kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Abele kerker, le giz detaut, kega, Debele paser keribi tumge abi; a uiaba detager, kega, Daip mudige ki nabaspe. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Abelelam ese ikeli abele kereskeres lu, nalu lu ikeli abkoreb uatuet lu? ");
INSERT INTO ulk1902_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Neisi uit le taragardare abi okakis, kem eumidare. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","A baos abele uteb, nei atker, Kerem lid ra uteb, a uiaba abi satauro abele uteb ge, okakis neisi uit le, nerute tuter peik, nerute ber peik. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Epe Iesu abi detager, kega, Kara Aba, ma uiabi idigir; abelelam uiaba umer kak abele lu uiaba ikeli. A ui ge abara am uali barapeirare, a luglug ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abele ged, uiaba ekuei a dasmerare. Tarim le pako uiaba abi negneg, a kega, E uader idigir; ese E Keriso, debele tababu idigir, Ade abi sererege. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ege ares le giz abi neg degarare, uiaba abim bakeuare abi ikuar uinega, ");
INSERT INTO ulk1902_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","A uiaba detautare, kega, Ese ma Iudaia Opole mabu idigir. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Abele jauali detali tumge Heleni mer, a Roma, a Heberu, Abele Iudaia giz ra Opole. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nerute le emered abi dog, adud mer abim, kega, Ese ma Keriso, debele mabu idigir, pako keribi. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","A nerute le abi daisumda, kega, Nako ma nole Adim geum, abelelam meriba okakis bodomalam? ");
INSERT INTO ulk1902_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Abkoreb meriba bodomalam; abelelam meriba bodomalam abkoreb abele lu meriba ikeli: epe abele le, E nole adud ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A E Iesui detager, kega, Opole, ese ma tabakeamu mara baselaia ma nole kari okataprik. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ege Iesu de abi detaut, kega, Ageakar, kaka mari detager, Abele gerger meriba obapit Paradaiso. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ege abele haua sikes baruk, abele ged kupikupi, bakedilu abele nain haua ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Epe lem kupikupi: abele uali demed, muige zogo meta, tababu batoat. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ege Iesu au ereretikri, kega, Kara Ab, kaka mari ikuar karbara lamar mari tagem: E abele mer detaut, abara eud baruk. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Epe abele kerem le, asesered netate handed ares le, E erdali abele lu, E Adim damer, kega, Ageakar, abele le tabara tonar barkak. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ege uader le giz etameare abele uteb ge, uiaba dasmerare abele lu, a marmot ge bamuare, a bakomeret. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A uader abi umele, uiaba ekuei muriz ge, pako uader kosker giz abi irmilare Galilaialam, a uiaba dasmerare abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Dasmer, nerute le, nei Iosefa, E tarim le, E debe tonar, ");
INSERT INTO ulk1902_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(E nole upinati uiaba mer, pako abele sirdame, pako abele lu), E Arimathia le. E Iudaia ra uteb, E naokaili Ade ra baselaia ge: ");
INSERT INTO ulk1902_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","E bakeam Pilatoim, E damosi Iesu ra gem. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","E tais, a sopem ereb abele uali lino, E ikedi abele ao ge, baker kur, nole atkobeir kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Abele gerger uetpur, maike sabath. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ege uader kosker, abi kemem tabakeauare Galilaialam, uiaba irmilare, a dasmer abele ao ge, abara gem azirik. ");
INSERT INTO ulk1902_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ege uiaba ko akomeda, a derser lu debe laglag, pako uakasu debe laglag. Ege uiaba nerezi sabath ge, abkoreb Ade ra mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ege ditimedelu abele gerger sabath ge, uiaba bakeuare abele ao ge, bane ge, uiaba ais abele lu debe laglag emetu derser, uader kosker uiabi kemem. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ege uiaba erdali abele baker aolam emetu diski. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ege uiaba barot muige, uiaba nole erdali Iesu ra gem. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ege uiaba operem abele lu: dasmer, neis le ekuei uiaba opem, am zoromzorom uali: ");
INSERT INTO ulk1902_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ege uiaba au geum, a uiaba op esorgiru sepem, ege uiaba detager, kega, Nalu uaba deraimer? E emetu eded akaid, nole uiabi kemem eud le giz, ");
INSERT INTO ulk1902_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","E nole abele uteb, E ko ekuei: uaba dikiapor abara mer abele kerker ge uaba okakis emeri Galilaia ge, ");
INSERT INTO ulk1902_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","E detager, kega, Abkoreb Le la Uerem ikuar uit le la tag, a satauro, a neisi netate gerger ko eded akaid. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","A uiaba dikiapor abara mer. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ege uiaba ko akomed abele aolam, a uiaba etomeret gaire lu uiabim eleuen le, a pako le uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Magadalena, a Ioana, a Maria Iakobo ra apu, pako uiaba uridili, uiaba etomeret abele lu uiabim aposetelo giz. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","A ui ge abele mer dikiaporare, kega, No mer pe deke; abelelam nole oatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ege Peteru ge ekueilu, E au koreder aoem; E esorgiru, E erdar no uali gaire eskeder; A E akomelu tabara metaem, a damer abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dasmer, neisi le uiaba bakeamulei abele gerger ge nerute utebem, nei Emau, ditimed Emau bakedida Ierusalema sikiste setatio. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ege uiaba mer atager abele gaire lu uridili ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ege uiaba mer atager, a deraimer, epe Iesu maike uiabi dog, a uiaba okakis bakeamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","A uiaba pone darasam, abelelam uiaba nole abi erdali. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ege E uiabi daratager, kega, Nalu mer pe ua batagreiei, pe ua dekase, a uaba pone mokakalam okasosok? ");
INSERT INTO ulk1902_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nerute le uiaba, nei Kaleopa, E abi detager, kega, Nako mama emeri Ierusalema, mama nole umer kak peirdi gaire lu osemeda? ");
INSERT INTO ulk1902_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","E uiabi daratager, kega, Nalu lu? A uiaba detaut, kega, Abele lu Iesu Nazareta le, E perofeta, E au saserim gaire lu ikeli, pako abara mer Ade ra opem, pako abele ged uridili: ");
INSERT INTO ulk1902_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Zogozogo le giz, pako meriba tarim le, uiaba ikuar bodomalam eumilu, a uiaba abi satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Keriba dikiapor E uerkab Isaraela. A gaire lu uridili, abele gerger thri gerger, abele lu ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Keriba au damreda, uader kosker keribielam, uiaba bakeam banege a aoem; ");
INSERT INTO ulk1902_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Uiaba nole erdali abara gem, a uiaba bakeamu abele merkem, kega, Keriba erdali angela giz ui keribim detomereta, E emetu ko eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Uader keribielam, uiaba bakeamu aoem, uiaba erdali mokakalam kosker detaut: a uiaba nole abi erdali. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ege E uiabi daratagerare, kega, Le paim, a peper nerkep, nole oituli gaire lu uridili gaire perofeta giz etomereti! ");
INSERT INTO ulk1902_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Abkoreb Keriso kekiam au asias gaire lu mokakalam, a keubu abara zorom tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Epe E uiabi etomereti gaire lu, emetu detali abielam jauali uridili, E ditimeda Mose bakedida perofeta uridili. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ege maike abele uteb ge uiaba bakeamu: epe E mokakalam no bakeamu. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ege uiaba saserim detaut, kega, Debele ma keribim emeri peike: abelelam gerger ise maike kikem. Epe E barot, a uiaba emeri. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ege E eidi eroli okakis uiabim, epe areto erpei, a esoao, a itur, a uiabi naisuerare. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Epe uiaba pone bakaelei, a abi dasmerei; E uiabielam badimiriklu. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Epe uiaba mer atager, kega, Nako meriba nerkep mokakalam ur muige, abuar ge meribi detager gab ge, E meribi detomelu abele jauali? ");
INSERT INTO ulk1902_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ui ge ekueilei abele haua ge, akomelei Ierusalemaem, a nardarare eleuen le, uiaba etamiare okakis uader uiabi kemem, ");
INSERT INTO ulk1902_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ui ge uiabi daratagerare, kega, Ageakar, Opole ko eded akaida, E etomereti Simonaem. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A ui ge detautei abele gaire lu ikeli gab ge, a uiabi erdali a areto itur. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","A uiaba mer batager abele lugelam, a Iesu ekueilu uiabi opem, a uiabi daratagerare, kega, Uerkab uabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ege uiaba au geum, a ui dikiaporare uiaba lamar pemi erdarda. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ege E uiabi daratagerare, kega, Nalu uaba okasosok? nalugelam uaba nerkep basareda? ");
INSERT INTO ulk1902_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Debele uaba mamoro dasmer, kara tag peike, pako kara teter, abelelam kaka: uaba kari erpei, a kari dasmer; lamar nole med kak, a nole lid kak, mokakalam uaba kari dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ege E emetu uiabi daratagerare abele mer, E uiabi natomertare tabara tag, a teter. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A uiaba nole oatur kak, abelelam uiaba au sererege, a damared, E uiabi daratagerare, kega, Nako uaba nagri leuer? ");
INSERT INTO ulk1902_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ege uiaba abi ikuar nerute lar mog emetu urim, a nerute mog melikerio. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ege E narpeilu, a nareg uiabi opem. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A E uiabi daratagerare, kega, Abele mer kaka uabi detagereda, abele kerker kaka uabi kemem, abkoreb iako ageakarem gaire lu uridili emetu detali karielam Mose ra gelar, pako perofeta giz, a Salamo. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Epe E depegeli uiaba nerkep, iaueakai uiaba mamoro asoli jauali; ");
INSERT INTO ulk1902_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","E uiabi daratagerare, kega, Emetu detali, Abkoreb Keriso asiasi, a thri gerger ko eded akaida eudlam; ");
INSERT INTO ulk1902_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iaueakai natomertare obazgeda, a adigiri uit ged uridili, abara nei ge, ditimeda Ierusalema. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Uaba upinati abele lu. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dasmer, kaka uabim namarida nerute le, kara Aba uabi uadetomertare: debele uaba emeri abele uteb, nei Ierusalema, iaueakai uaba nagri adigir kotor ge. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ege E uiabi ais sor ge, bakedida Bethania: ege tabara tag nagaisilu, E uerkab uiabim. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ege E uiabim uerkab, E uiabi dikaer, E bakeamu kotorem. ");
INSERT INTO ulk1902_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ui ge abim esorgiru; a bakomeret Ierusalemaem, a uiaba au sererege: ");
INSERT INTO ulk1902_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Uiaba ner kak bakeamu zogo meta, uiaba Ade despered. Amen. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Abele Logo degraret, Ade dog abele Logo, a Ade Logo, ");
INSERT INTO ulk1902_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","E ko Ade dog degraret. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E ge gaire lu detagem eseamulu; a nole nerute lu, E nole atagem kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Eded abi dog; a eded gaire le daratkeda. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Abele be de daratkeda muige kupkupi ge; a kupkup nole arpeir kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ege nerute le tabaruk, Ade de temariklu, nei atker Ioane. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","E dali tabaruk ageakarem, abele lugem ko datki ageakarem, epe gaire le uridili odaratare abielam. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","E dali nole abele datki, E tabaruk ko ageakarem datki penoka ekas. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Abele datki kar, ko daratkeare gaire le uridili, sepem tabarkare. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","E geseb ge, a geseb abi atagemlam, a geseb nole abi ardar kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","E abara boai tabaruk, a abara boai nole abi agaret kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ui uridili abi egardare, a odaratarare abi nei de, E uiabim adigir nakuarare ko Ade ra omasker: ");
INSERT INTO ulk1902_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Uiaba nole mamlam aosos, a nole gem ra lag, a nole le ra lag, epe Adelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Logo depeger le gem ise, a E meribi dog emrilu, (a keriba abara zorom dasmerare, zorom mokakalam Aba ra Uerem netat,) mitkar omare, a ageakar. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioane abi ageakarem, a ereretikri, kega, Idali kaka detautili, kega, Nerute le kari sorge ikas au kale kari tumge; abelegelam E kekiam, ka keubu. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Meriba uridili nagri no omare tumem no omare abi mitkarlam. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Abele gelar Mose de dekuarare, abele omare a ageakar tonar, Iesu Kerisolam. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nole le Ade asmer kak; epe abara Uerem tepteb taba Aba ra marmot, E etomeret. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ge Ioane de ageakarem peik, uiabi Iudaia giz gaire zogo le a gaire Leui namarida Ierusalemlam, ko abi itmerare, kega, Ma nete? ");
INSERT INTO ulk1902_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","E natomertare, a nole agem kak; a mamoro natomertare, kega, Kaka nole Keriso. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Uiaba abi itmerare, kega, Ma nete? Ma Elia ao? E etkalu, kega, Kaka nolea. Ma perofeta ao? E etkalu, Nolea. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Uiaba abi detagerare, kega, Ma nete? Ma natkar keribi uiabim tedautare keribi pe tedemarida. Nako mara mer marielam? ");
INSERT INTO ulk1902_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","E detaut, kega, Kaka kodo ereretikrili soge purge, kega, Barditugili Iehoua ra gab, mokakalam Isaia perofeta detauter. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Uader Faresaio taramarkare. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Uiaba abi itmerare, a abi detagerare, kega, Nalugem ma bapataiso, ese ma nole Keriso, a nole Elia, a nole nerute perofeta? ");
INSERT INTO ulk1902_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ioane uiabim etkalu, kega, Kaka bapataiso ni de; nerute uabi eipu ekuei uaba asmer kak, ");
INSERT INTO ulk1902_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E dali kari sorge ikas au kale kari tumem, kaka nole abkoreb ko detue abara teter gab mukub. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Abele gaire lu Bethabara ge ikerare, Ioridano ge sager pek, ge abele uteb ge Ioane de bapataiso. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iuoakaer, Ioane de Iesu dasmer abim tabakeam, a E detager, kega, A ma dasmer Ade ra Arenio, ko adem dikri gaire geseb uit! ");
INSERT INTO ulk1902_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","E dali kari atautelam, kega, Nerute le kari sorge ikas au kale kari tumge; abelelam E kekiam, ka keubu. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kaka nole abi ardar kak; debele abi etomer Isaraela ibim, abelelam kaka tabaruk ko bapataiso ni de. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ioane de ageakarem, a detager, kega, Kaka Lamar Zogo dasmer kotorlam tepelu dibadiba ise, a abi kerem ge egimulu. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kaka nole abi ardar kak: epe E dali kari taramarida ko bapataiso ni de, E kari natager, kega, Abele le ma dasmer Lamar Zogo ueeperoa abi kerem ge ueegimurua, E dali bapataiso Lamar Zogo de. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kaka dasmer, a kaka ageakarem, kega, Ade ra Uerem pedali. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iako iuaokaer, Ioane ekueilu, a neis abara kaimeg giz; ");
INSERT INTO ulk1902_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","E Iesu dasmer, ekasereder, E daratager, kega, Ua dasmeram Ade ra Arenio! ");
INSERT INTO ulk1902_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Abele neis kaimeg abara mer aserei, ui darali Iesu irmilei. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu egreemalu, a darasmer ui darali abi irmili, a ui darali detagerei, kega, Nalu ua deraimerei? Ui natkalei abim, kega, Rabi (tonar, Ereuer le), ma nade emri? ");
INSERT INTO ulk1902_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","E ui darali detagerei, kega, Ua tabarkam, a dasmeram. Ui darali bakeamulei a dasmerei abara uteb, a abi kemem emrilei abele gerger ge: abelelam maike kige. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nerute le uiabielam Ioane aserei, a abi irmilei, pe Anederea, Simona Peteru ra keimer. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","E kekiam erdalu abara keimer Simona, a abi detager, kega, Ki Mesaia erdali, (tonar abele nei, Keriso.) ");
INSERT INTO ulk1902_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","E Iesuim egaredelu. Iesu abi dasmer, a detager, kega, Ma Simona Iona ra uerem; mari nei natkeri Kefa, (tonar abele nei, Peteru.) ");
INSERT INTO ulk1902_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iuaokaer, Iesu laglag Galalaiem bakeam, E Filipo erdalu, a abi detager, Kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo Bethesaidalam, uteb Anederea a Peteru. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo de Nathaniela erdalu, a abi detager, kega, Keriba abi erdali Mose de abielam gelar ge, a gaire perofeta detar, Iesu Nazaretalam, Iosefa ra uerem. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathaniela de abi detager, kega, Nako, umelo nerute debe lu ua tabakeamur Nazaretalam? Filipo abi detager, Ma tabakeam dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iesu Nathaniela dasmer abim tabakeam, a abi detager, kega, Dasmer, Isaraela kar, nole bes kak abi dog! ");
INSERT INTO ulk1902_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathaniela abi detager, kega, Nade ma kari nasmer? Iesu etkalu, a abi detager, kega, Kaka mari nasmeli suke mudge, a Filipo nole mari abger kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathaniela abim etkalu, kega, Rabi, ma Ade ra Uerem, a Isaraela ra Opole. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu etkalu, a abi detager, kega Ma oituli abelelam kaka mari natageri, kega, Kaka mari nasmili suke mudge? mena ma keubu dasmer gaire au lu tumem abele. ");
INSERT INTO ulk1902_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iesu abi detager, kega, Ageakar, ageakar kaka uabi detagereda, kega, Uarem uaba ko dasmerare kotor uanakesmur, a gaire Ade ra angela uatabatuer iako uabog tumem Le la Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Abele gerger thri, nerute ispilu Kana Galilaiem; a Iesu ra apu pedali: ");
INSERT INTO ulk1902_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Uiaba Iesu a abara kaimeg giz taraisare abele aspirem. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Uaina eseamulu, Iesu ra apu abi detager, kega, Uiaba nole uaina kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu abi detager, kega, Kosker, nako ma karim? kara kerker nole uatabaruk. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Abara apu, uiabim gaire memeg le, daratagerare, kega, Abele mer E uabi detagereda, ikerare. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Peike sikis gaire baker tarpor, namer ko dirup irmili Iudaia le la tonar, tu me thri bathi absaimarsaimar. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu uiabi detagereda, kega, Tedarakeusarare abele gaire tarpor niu. Uiaba tedarakeusarare mitkarem uadarabuerare. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","E uiabi detagereda, kega, Ge tigrare, a ekadarare abim uetpur ra opole. Ege uiaba ekadarare. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Emetu uetpur ra opole tepdeskerare abele ni, depegemelu uaina, a nole umer kak nagelam, (gaire memeg le umele uiabi atatkolam,) uetpur ra opole le ispilu ereretikri, ");
INSERT INTO ulk1902_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","A abi detager, Tonar gaire le uridili ko kekiam debe uaina dersemrare; a emetu au kase ereare, ege kebi debe uaina nakuarare: ma mena debe uaina edagili, a peirdi. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Abele degraretelu gaire Iesu ra adigir, E ikerare abele Kana ge Galilaia, a abi zorom etomelu; abara kaimeg giz abi odaratarare. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Abele baruk E Kaperenaumem bakeamulu, Iesu, a abara keimer giz, a abara kaimeg giz: uiaba nole dordor gerger ab ged ge bamer. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iudaia ra paseka maike, a Iesu bakeamulu Ierusalamem. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","E nardarare gaire le zogo meta ge, uiaba kau, a mamoe, a dibadiba eraplare, a gaire le mani eraplare emereder. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","E dordor kebi lager iskapsir, a uiabi adem mamuare zogo metalam, mamoe kem, a kau kem; a gaire le ra mani darapaitare, a gaire uiaba laulau dararaskilare. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A gaire le dibadiba eraplare, E daratagerare, kega, Taisare abele gaire lu; nole ikerare kara Aba ra meta lu garap meta. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Abara kaimeg giz dikiaporare abele mer emeret ge detarer, kega, Au laglag abele mara meta kari irmida. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gaire Iudaia le natkartare, a abi detagerare, kega, Nalu atamelam ma keribi detomertare mama ikeli abele gaire lu? ");
INSERT INTO ulk1902_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu uiabim etkalu, a detaut, kega, Eogerdi abele meta, kaka iako ikeli thri gerger. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Gaire Iudaia le detagereda, kega, Fote sikis gaire urut abele meta ikeli, nako ma ko ikeli thri gerger ge? ");
INSERT INTO ulk1902_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ege Iesu de detaut taba gem ra meta. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","E emetu eded akaida eudelam, abara kaimeg giz dikiaporare abele mer E uiabi daratagerare: uiaba odaratarare abele Zogo mer detarer, gako nerute mer Iesu de detauter. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","E Ierusalema ge abele uetpur ge paseka, abele gerger ge, gaire le abara nei odaratarare, abelelam uiaba dasmerare gaire abara atamelam E ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Iesu nole tababu bamerik uiabim, abelelam E umele gaire le uridili, ");
INSERT INTO ulk1902_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A abelelam nole abi abkoreb nerute le ko etomereti nerute le la tonar; abelelam E umele abele gaire lu muige le la nerkep ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Abele nerute le Faresaio, nei Nikodemo, Iudaia tarim le: ");
INSERT INTO ulk1902_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","E ki ge Iesuim tabakeam, a abi detager, kega, Rabi, keriba umele ma ereuer le tarabu Adelam: abelelam nole nerute le umele ikeli abele gaire atamelam mama ikeli, ese Ade nole abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu etkalu, a abi detager, kega, Ageakar, ageakar, kaka mari natagere, Ese nerute le nole iako esmeda, E umer kak Ade ra baselaia dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo abi detaut, kega, Nalugem aule umele ko eosmeda? nako E umele ko neisem badari taba apu kem ge, a iako esmeda? ");
INSERT INTO ulk1902_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu etkalu, kega, Ageakar, ageakar, kaka mari natager, Ese nerute le nole esmeda ni de a Lamar de, E nole umer kak Ade ra baselaia badari. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Abele gemlam esmeda, gem pedali; abele Lamarlam esmeda, lamar pedali. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nole amer kak abele mer kaka mari natagere, kega, Ido lu uaba iako esmerare. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Uag uami abele uteb E laglag, ma bumer asoli, a nole ardar kak E nagelam, a E nagedim bakeam: mokakalam gaire le Lamar de esmerare. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo etkalu, a abi detager, kega, Nako umele gaire lu pedali? ");
INSERT INTO ulk1902_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu etkalu, a abi detager, kega, Nako, ma Isaraela ereuer le, a nole erdali abele gaire lu? ");
INSERT INTO ulk1902_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ageakar, ageakar, kaka mari natager, kega, Keriba detagereda abele gaire lu keriba erdarda, a ageakarem abele gaire lu keriba dasmereda; epe uaba nole arpeir kak abele keriba ageakarem. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ese kaka uabi detagereda gaire lu geseb ge, a uaba nole oatur kak, nako uaba onatareda ese kaka uabi detagereda gaire lu kotor ge? ");
INSERT INTO ulk1902_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nole nerute le ogi kotorem, epe mamoro E kotorlam uatabu, abele Le la Uerem kotor ge emri. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mokakalam Mose taba armem agisilu abele soge purge, pako mokakalam Le la Uerem ko arem agisilu: ");
INSERT INTO ulk1902_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Epe gaire le abim onatareda, ko nagri eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Abele absaimarsaimar Ade ra omare gesepem, gako E ikuar abara Uerem netate, epe nole eud kak, abele le abi oituli, mamoro E nagri eded aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ade nole emarida abara Uerem gesepem ko gesep mer barditug; epe mamoro gesep eded abielam. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Abele le abi oituli nole mer barditug abim: abele le nole oatur kak emetu mer barditug abim, abelelam E nole oatur kak abele nei Ade ra Uerem netate. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Abele mer barditug, datki gesepem tabarki, gaire le kupkup laglag tumem datki, abelelam uiaba dorge adud. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gaire le adud ikereda, uiaba datki derarteda, a nole datkim tabakeuare, uiaba dorge akmelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gaire le ageakar ikereda, uiaba datkim tabakeuare, ko uiaba dorge paret kak, abele emetu ikereda Adim. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Abele gaire lu iobaru, Iesu a abara kaimeg giz bakeuare Iudaia gedim, E uiabi kemem bamer, a bapataiso. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ege Ioane ko Ainonem bapataiso, abele maike Salim, abelelam au ni pedali: uiaba tabakeuare, a bapataisoem. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Abelelam Ioane nole aziri kak au dubar meta. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ioane ra kaimeg giz a nerute uiaba Iudaia le giz basardare abele tonar ogarup. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Uiaba Ioaneim tabakeuare, a abi detagereda, kega, Rabi, abele le mari dog, Ioridano apek, mama emetu abi ageakarem, dasmer, E ko bapataiso, a gaire le uridili abim tabakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ioane etkalu, a detager, kega, Nerute le umer kak ko nerute lu erpeilu, ese nole abi ikuar kotorlam. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Uaba kari ageakarem, karielam detaut, kega, Kaka nole Keriso, epe kaka taramarida abi opem. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Abele le kosker nagri emetu abim babeida, E dali ko ispida: abele le aspidar le la boai ekue, a abi asoli, au sererge abele le ispida ra kodo mer: abele kara sererge kemerkemer. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","E ko bataili, kaka ko ekekeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Le kotorlam uatabu, E tumem gaire lu uridili: le geseplam, E geseplam, a ko gesep mer atager: le kotorlam uatabu, E tumem gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Abele lu E emetu dasmer a asoli, E ageakarem peik; a nole le abara ageakarem erpei. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Abele le abara ageakarem erpei, E dedkomet, kega, Ade ageakar. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","E dali Ade de temarida mer atagerem gaire Ade ra mer: abelelam E nole Lamar Zogo ikuar au tale lu ge de. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Abet abele Uerem omare, a gaire lu uridili abi tagem aisuer. ");
INSERT INTO ulk1902_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Abele le Ueremem oituli, E nagri eded aseamur kak: abele le nole Ueremem asor kak, E nole eded asmer kak, epe Ade ra urker abi tumge dikmerik. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Opole umele gaire Faresaio aserare, kega, Iesu ko taraisare a bapataiso kaimeg giz tumege Ioane, ");
INSERT INTO ulk1902_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Epe Iesu nole bapataiso kak, mamoro abara kaimeg giz), ");
INSERT INTO ulk1902_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","E Iudaia dekaelu, a iako Galilaiem bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Abara dorge ko eipu Samaria bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","E nerute utebem Samaria tabarki, nei Sikara, maike abele kebi ged Iakobo de tabara uerem Iosefaim ikuar: ");
INSERT INTO ulk1902_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iabobo ra ni peike. Iesu ni padige emri memelam, gem barapare: eipu gerger. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nerute Samaria kosker tabaruk, ni atatkoem: Iesu abi detager, kega, Kari ni nakuar ko areem. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Abara kaimeg giz utebem bakeuare ko leuer arapem. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria kosker abi detager, kega, Nako, ma Iudaia le, karim niem namosi, Samaria kosker? (Gaire Iudaia le a Samaria le nole meme kak.) ");
INSERT INTO ulk1902_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu detaut, a abi detager, kega, Ese mama umele abele lu Ade ikuar, pako le dali mari natager, Kari ni nakuar; ese mama emetu abi damos, E ko mari nakuar eded ni. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ege kosker abi detager, kega, Kole, ma nole nisor kak, ni kopkopni: nagelam mari dog eded ni? ");
INSERT INTO ulk1902_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nako, ma aule tumem keriba aba Iakobo, abele ni keribi ikuar, E ko eri abele ni, a abara uerem giz, a abara ebur giz? ");
INSERT INTO ulk1902_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu detaut, a abi detager, kega, Gaire le uridili ereare abele ni ge, uiaba iako niap ge: ");
INSERT INTO ulk1902_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Eko le aree abele ni kaka ikuar, E nole niap kak niai karem; abele ni kaka ko abi ikuar, mena abi kem ge ni tomeili eded aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Koskeret iako abi detager, kega, Opole, karim abele ni tekau, iako nole niap kak, iako kaka nole tabakeam ko ni tigur. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu abi detager, kega, Bakeamu, mabara kimiar tegared, iako tabakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Koskeret etkalu, kega, Kaka nole kimiar kak. Ege Iesu de abi detager, kega, Ageakar mama detaut, kega, Kaka nole kimiar kak: ");
INSERT INTO ulk1902_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Epe faif mara gaire kimiar; E dali mari dog emri, nole mara kimiar: peik ageakar mama detager. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Koskeret abi detager, kega, Kole, kaka erdali mama perofeta. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Keriba kaied abele paser ge esorerapare, ege uaba detager, Ierusalema uteb kar esorerapare. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu abi detager, kega, Kosker, kari asoli, kerker tabarki, uaba nole esorerapare Abem abele paser ge, a nole Ierusalema ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Uaba umer kak uaba esorerapare nitim; ki umele abele keriba esoreraparem: Iudaia gizelam edede. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kerker ia uatabu, a peirdi, gaire le esorerapare, ko Abem esorerapare lamarem, a ageakarem; abelelam Aba deraimer gaire le mokakalam ko abim esorerapare. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ade Lamar; uiaba abim esorerapare, mamoro lamarem esorerapare, a ageakarem. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kosker abi detager, kega, Kaka umele Mesaia ia uatabu (nei atker, Keriso:) E emetu tabi, E keribi detomereta gaire lu uridili. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iesu abi detager, kega, Eko, kakanali mari mer atagere. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Abara kaimeg giz tabarki, a ezigmada, abelelam E koskerim mer detager; epe nole nerute le abi detager, kega, Nalu ma deraimer? a nalugem ma abi mer atagerem? ");
INSERT INTO ulk1902_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kosker tabara nisor ikedilu, a utebem bakeamulu, a gaire le daratagerare, kega, ");
INSERT INTO ulk1902_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Tabakeuare, dasmerare abele le kari natagere gaire lu kaka ikeli: nako, Keriso dali? ");
INSERT INTO ulk1902_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Uiaba uteblam tabaosi, a abi dog tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Inoka dali, kaimeg giz abi ekailu, a detager, kega, Rabi, ero. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","E uiabi daratagerare, kega, Kara nagri leuer ko ero uaba nole umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Abelelam kaimeg giz mer atager, kega, Nako, nerute le abi leuer ikuar? ");
INSERT INTO ulk1902_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesu uiabi detager, kega, Kara leuer ko ikeli abara lag, kari namarida, a ko eseamuda abara dorge. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nako, uaba nole detager, kega, Foa gaire meb nur tabarki? Dasmer, kaka uabi detager, kega, Uaba eti, a gaire gedub dasmer, nunur kerker nur abi. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Le ikid bodomalam nagri, a leuer ageg etag ededem aseamur kak; ko le emor, a le ikid okakis sererge. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mokakalam, ageakar abele mer detaut, kega, Nerute le emor, a nerute ikid. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kaka uabi demarid ko ikid abele uaba sagim kak: uader le sagim, epe uaba barot uiaba sagim. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Gaire Samaria le abi oituli abele uteblam, abele kosker merlam, kega, E kari natager gaire lu uridili kaka ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Epe gaire Samaria le abi dog tabarki, uiaba abi damos uiaba kemem emri: E abele ge emri neis gerger. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gaire uader le oituli abi merlam; ");
INSERT INTO ulk1902_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Uiaba koskerem detager, kega, Keriba nole oituli mara mer atautelam; abelelam keribibu asoli, a keriba umele, ageakar Keriso idali, geseb uridili ededem. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Abele neis gerger iobaru, E bakeamaulu Galilaiem. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Abelelam Iesu detager, kega, Perofeta nole ekosili abi ged ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","E Galilaia tabarki, gaire Galilaia le abi egared, abelelam uiaba dasmer gaire lu E ikeli Ierusalema ge, abele uetpur ge; abelelam uiaba kemem uetpurim bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iesu iako Kana Galilaia tabarki, abele uteb E ikeli ni iauaeakai uaina. Nerute kole ra uerem gimgim Kaperenauma. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","E asoli, kega, Iesu Galilaia tabarki Iudaialam, E abim tabakeam, a abim bali ko tabakeam abara uerem idigiri, abelelam E maike eumida. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu abi detager, kega, Ese uaba nole asmer kak gaire atamelam pako adigir, uaba nole uatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kolelut abi detager, kega, Opole, ma tabakeam, kara uerem ue eumi. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu abi detager, kega, Bakeam, mara uerem eded akaida. Abele le oituli abele mer Iesu de abi detager, E bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E penoka ekas, abara memeg giz abi obapit, a abi detaut, kega, Mara uerem eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","E uiaba nautumer, abele haua E ko ditimeda ko eded. Uiaba abi detaut, kega, Ab gerger haua sefen, urueri abi dekaerti. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baba umele abele haua, Iesu abi detager, kega, Mara uerem eded akaida: E pako abara boai uridili oituli. ");
INSERT INTO ulk1902_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Abele neisem adigiri Iesu ikeli, kerker ge tabarki Galilaia Iudaialam. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Abele gaire lu iobaru Iudaia le giz ra uetpur; Iesu Ierusalemaem bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Abele Ierusalema ge nerute keper, maike mamoe ra te, nei Heberu, Betheseda, faif bereg nagri. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Gaire le abele ge emri, le gimgim, a pone asamasam, a ibibi, a euselu, uiaba naokaili ni dakeili. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kerker ge angela uatabu ni ge, ko ni dakeili; abele le kekiam bakmeida, ese emetu ni dakeili, abara gim dekaeda abele gimlam nagri. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Abele nerute le, therti eit urut E gimgim. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu abi dasmer uteidilu, umele E emeretelam, E abi detager, kega, Nako ma lagelag eded? ");
INSERT INTO ulk1902_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Gim le abi detaut, kega, Kole, nole le kari nagaret keperem, ese ni dakeili: kaka beber nagemeli, penoka nerute kekiam abi. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iesu abi detager, kega, Ekue, mabara sik ekau, a bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sobkak abele le akaida, a abara sik ekau, a bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Abele gerger sabath ge. Abelelam Iudaia le giz nadgirda le detager, kega, Sabath peik, nole abkoreb marim ko ekau mabara sik. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","E uiabim detaut, kega, Abele le kari nadgiri, E kari natauti, kega, Mabara sik ekau, a bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Uiaba abi itimer, kega, Nete le mari natauti, kega, Mabara sik ekau, a bakeam? ");
INSERT INTO ulk1902_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Le nadgiri umer kak nete; abelelam Iesu gumik bakeamulu, gaire le lakub lam. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Abele iobaru, Iesu abi dasmer muige zogo meta, a abi detager, kega Dasmer, emetu mari nadgiri; nole uit iako ikeli, iauaeakai nole nerute au uit marim tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Abele le bakeam, a gaire Iudaia le giz detager, kega, Iesu de abi idigiri. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Abelelam Iudaia le giz Iesu deskemrare, a deraimerare ko abi ipitare eumilu, abelelam E ikeli abele gaire lu sabath ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ege Iesu uiabim detaut, kega, Kara Aba dorge ikeli, a peirdi, kaka ko dorge ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Abelelam Iudaia le giz au saserim ko abi ipitare eumilu, abelelam E nole sabath datupida tepteb, epe E iako detauti, kega, Ade abara Ab kar, pako E dali a Ade abkoreb. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iesu detaut, a uiabim daratagerare, kega, Ageakar, ageakar, kaka uabi detagereda, Uerem umer kak tababu dorge ikeli, epe mamoro E Ab dasmer ikeli: gaire lu E ikerare, Uerem ko abele keli. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Abelelam Aba Uerem nas, a abi etomelu gaire lu E eker: E ko abi etomelu gaire au lu tumen abele, uaba ko damreda. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mokakalam Aba gaire eud obakiam, a uiabi nadgirare; mokakalam Uerem nadgirare gaire le E laglag. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ege Aba nole nerute le itmer, E emetu gaire itmer uridili ikuar Ueremem; ");
INSERT INTO ulk1902_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Eko gaire le uridili Uerem naospereda, mokakalam uiaba Aba naospereda. Abele le nole Uerem naospereda, E ko nole Aba naospereda, abi emariklu. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ageakar, ageakar, kaka uabi detagereda, kega, Abele le kara mer asoli, a abi oituli kari namarida, E nagri eded aseamur kak, a nole itmer bau, E emetu bakeam eudelam ededem. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ageakar, ageakar, kaka uabi detagereda, kega, Kerker ge maike uatabu, a peirdi, gaire eud Ade Ueremer ra kodo mer asoli; uiaba asoli ko ededem. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mokakalam Aba eded nagri abi dog; mokakalam E Uerem ikuar ko nagri eded abi dog: ");
INSERT INTO ulk1902_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Emetu abi ikuar adigir ko itmer, abelelam E Le la Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nole abele ezigmada; abelelam kerker uatabu, gaire le aolam ko asoli abara kodo mer, ");
INSERT INTO ulk1902_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","A ko obakiam; gaire debe lu ikeli, ededem obakiam; a gaire uit ikeli, eudem obakiam. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kaka nole umer kak nerute lu ikeli karababu; kaka itmer mokakalam kaka asoli: kaka barkak itmer, abelelam kaka nole kara lag deraimer, mamoro Baba ra lag, kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ese karababu karim ageakarem, nole ageakar kaka karim ageakarem. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Debele nerute karim ageakarem; kaka umele ageakar, abele mer E karim ageakarem. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Uaba Ioaneim namarida, E ageakarem abele ageakar. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kaka nole egaret ageakar lelam: epe kaka detagere abele gaire lu, iaueakai uaba ko eded. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","E lamepa be, pako batoamerdi; uaba laglag sererge abele be abi dog kerker ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Aule kara ageakarem tumem Ioane; abelelam gaire dorge Baba kari nakuar ko eseamuda, abele gaire dorge kaka ikeli, ko karim ageakarem, kega, Baba de kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Emetu kari ageakarem Baba de kari namarida. Uaba nole asoli abara kodo mer, epe abara nog uaba asmer kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Abara mer nole uabi nerkep ge; abelelam uaba nole uatur kak abim, E namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Uaba deraimerare jauali zogo ge, abelelam uaba dikiapor uaba eded nagri aseamur kak abielam; abele karim ageakarem. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Uaba obogai karim tabakeuare, ko eded nagri. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kaka nole agaret kak naospili lelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kaka uaba umele, nole uaba nerkep ge Ade ra lag. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kaka tabarki karba Aba ra nei ge, uaba nole kari agaret kak: ese nerute le tabarki taba nei ge, uaba ko abi egaret. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Epe nako uaba ko oituli, uaba baospili egaret uabielam, a nole araimer kak naospereda Adelam tepteb? ");
INSERT INTO ulk1902_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nole akiapor kak kaka uaba detauti Abem; nerute ko uaba detaut, ege Mose, uaba abim oituli. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ese uaba Mose egaret, uaba kari ko nagaret, abelelam E kari naotali. ");
INSERT INTO ulk1902_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ese uaba nole egaret gaire jauali E detali, nako uaba egaret gaire kara mer? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Abele iobaru, Iesu bakeam kei apek Galilaia keper ge, pe Tiberia. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gaire le netate gedim abi irmili, abelelam uiaba dasmerare gaire atamelam E ekere, tumem gaire gim le. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iesu paserem ogi, a kemem emri abara kaimeg giz. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Paseka maike, nerute Iudaia giz ra uetpur. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu etilu, a gaire le lakub dasmer abim tabakeuare, E Filipo detaut, kega, Meriba nagelam leuer terapei, ko uiabi darasisiare? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","E detager abele ko abi mirem: epe E umele abele lu ko ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo abi detaut, kega, Nole uiaba abkoreb abele leuer terapei tu handed denari, iauaekai uiaba nagri kebi leuer mog. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nerute abara kaimeg giz, pe Anederea, Simona Peteru ra keimer, abi detager, kega, ");
INSERT INTO ulk1902_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Nerute makeriam ike nagri faif areto kon, a neisi lar: epe nako dali uiabim gaire le lakub mokakalam? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu detaut, kega, Gaire le bameri. Au soge dali. Epe gaire kimiar bameri, mokakalam faif thausan etag. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iesu gaire areto ekau; emetu esoao, E kaimeg giz naisuerare, a uiaba gaire le bamer naisuerare; a neisi lar ko, abkoreb uiaba lag. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Uiaba kem osmeda, E abara kaimeg giz detager, kega, Gaire leuer mog etagarare, a nole nerute lu adem. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Uiaba etagerare, a gaire tuelf epei artare, abele gaire mog areto kon faif, kaier uiaba leuer aroem. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Emetu gaire le dasmer abele atamelam Iesu de ikeli, uiaba detager, kega, Ageakar, perofeta idali, emetu detaut ko uatabu gesepem. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu umele uiaba ko elele abi egaret, ko abi ekairare opole, E iako gumik bakeamulu paserem. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kikem, abara kaimeg giz keperem batueri; ");
INSERT INTO ulk1902_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","A nar ge bateri, a atiem keper ge datuperti Kaperenauma ge. Ki ge, Iesu nole uiabi dog tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Keper au zauber au uaglam. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Emetu uiaba uzer mokakalam tuente faif a therti gaire setadia, uiaba Iesui dasmer tumem keper ge ekase, a maike nar ge: uiaba geum. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","E uiabi detaut, kega, Kakanali; uaba nole geum kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Uiabi sererge abi tigemertare nar ge ekauerertare; epe uiaba sobkak ia karida ab ged ge uiaba atiem. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Idim ge, gaire le lakub nerute apek ekue, a dasmer nole nar kak abele, epe abele nar tepteb abara kaimeg giz ekauerertare, Iesu nole uiabi kemem ekauererti nar ge, ege abara kaimeg giz tepteb atiem, ");
INSERT INTO ulk1902_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Gaire nar barkarki Tiberialam, maike abele uteb uiaba areto eroare iobaru Iesu de esoao): ");
INSERT INTO ulk1902_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Emetu le lakub dasmerare Iesu nole akar pedali, pako abara kaimeg giz, uiaba gaire nar ge batiri, a Kaperenauma ge atiem, Iesu deraimerare. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Uiaba abi erdali kei apek abele keper, uiaba abi detaut, kega, Rabi, ma ge tabarki na gerger ge? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu uiabi detaut, kega, Ageakar, ageakar, kaka uabi detagereda, Uaba nole kari naraimeli abelelam uaba dasmer gaire atamelam, mamaro uaba areto eroarem, a kem osmeda. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nole sagim kak buzbuz leuer, epe mamoro niai leuer, a tabarki eded aseamur kak, Le la Uerem ko uabi ikuar; abelelam Baba, pe Ade, abi detakobi. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Uiaba abi detaut, kega, Nalu keriba dorge, ki ko ikeli Ade ra dorge? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu uiabi detaut, kega, Ade ra dorge peik, ko oituli abim, E temarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Uiaba abi detaut, kega, Nalu atamelam mama ikeli, ki ko dasmer, a marim oituli? nalu mara dorge? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Keriba kaied mana erolare soge purge; mokakalam emetu detali, kega, E uiabi areto nakuarare kotorlam ko eroare. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu uiabi detaut, kega, Ageakar, ageakar, kaka uabi detager, Mose nole areto uabi ikuar kotorlam; epe mamoro kara Aba uabi dekuarda areto kar kotorlam. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Abelelam Ade ra areto dali kotorlam tabi, a eded nakuarare gesepem. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Uiaba abi detaut, kega, Kole, keribi dekuarare areto dali. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesu uiabi detager, kega, Kaka eded areto: abele le karim tabakeam, E nole iako uererge: abele le karim oituli, E nole iako ni ap. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kaka uabi detagereda, kega, Emetu uaua kari nasmereda, pe nole uatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ui uridili Baba de kari nakuar ko karim tabakeuare; abele le karim tabakeam, kaka nole abi atua kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Abelelam kaka nole kotorlam tarabu ko ikeli kara lag, mamoro abara lag, E kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Baba ra lag peike, kari namarida, kega, Kaka nole nerute dekaerti, E kari nakuar, epe kaka ko ekiamda keubu gerger ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Abara lag peike, kari namarida, kega, Gaire le uridili Uerem dasmerare, a abi oituli, uiaba eded nagri aseamur kak: epe kaka ko uiabi nakiamda keubu gerger ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iudaia le giz abi gumik mer atagere, abelelam E detaut, kega, Kaka areto kotorlam tarabu. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Uiaba detaut, kega, Nako, nole Iesu pedali, Iosefa ra uerem, pe nako, meriba nole umer kak abara aba a apu? nalugem E detaut, kega, Kaka kotorlam tarabu? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Abelelam Iesu detaut, a uiabim detagereda, kega, Uaba nole gumik mer atager kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Le nole umer kak karim tabakeam, ese nole abi egared Baba de, kari namarida: epe kaka ko abi ekiamda keubu gerger ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Emetu detali gaire perofeta ge, kega, Ade de uiabi uridili nereuereda. Gaire le uridili asereda Babalam, a emetu nereuereda uiaba karim tabakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nole nerute le Baba dasmer, mamoro E Adelam, E Baba dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ageakar, ageakar, kaka uabi detagereda, kega, Abele le karim oituli, E nagri eded aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kaka eded areto. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Uada kaied mana erolare soge purge, uiaba baumer. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Abele areto kotorlam tabu, ese le eroli, E nole eud kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kaka eded areto kotorlam tarabu; ese le eroli areto peik, E ko eded niai karem: abele areto kaka ko ikuar, abele kara gem, kaka ko ikuar ueakai gesepem eded. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iudaia le giz basaredelare, kega, Epe nalu le dali ko ikuar abara gem aroem? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu uiabi detaut, kega, Ageakar, ageakar, kaka uabi detagereda, ese uaba nole eroli Le la Uerem ra gem, pako abara mam ere, uaba nole eded kak muige uaba nerkep ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Abele le kara gem eroli, pako kara mam ere, E nagri eded aseamur kak; epe kaka ko abi ekiamda keubu gerger ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Abelelam kara gem leuer kar, a kara mam ni kar. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Abele le kara gem eroli, a kara mam ereli, E muige kara nerkep ge, a kaka abi nerkep ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mokakalam Baba eded kari namarida, a kaka ko eded Babalam: mokakalam abele le kari naroli, E ko eded karielam. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Abele areto kotorlam tarabu: nole mokakalam kaied giz erolare, gako baum: abele le areto idali eroli ko eded niai karem. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","E abele gaire lu detagereda muige sunago, E nereuereda Kaperenauma ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gaire abara kaimeg giz abele asarare, uiaba detager, kega, Beber abele mer; nete umele asoli? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu umele, taba nerkep ge, abara kaimeg giz gumik mer atager abele, E uiabim detaut, kega, Nako, abele uabi bamsili? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nako, ese uaba dasmer Le la Uerem abara emeret utebem ogi? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lamar de idgiri, gem nole lu kar: abele gaire mer kaka uabi detagereda, lamar pedali, pako eded. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Uader uabielam nole oatur kak. Iesu umele gizlam uiaba nole oatur kak, a abele le abi keserkeser. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","E detaut, kega, Abelelam kaka uabi detagereda, le umer kak karim tabakeam, ese nole abi ikuar Baba de. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Abele merlam, gaire abara kaimeg giz iako takomeda, a nole abi kemem bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iesu tuelf le detagereda, kega, Nako uaba ko laglag akomeda? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simona Peteru abi detaut, kega, Kole, nitim keriba bakeam? mari dog gaire eded mer aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ki oituli, a opasereret, mama Keriso, Ade ra Uerem niai eded. ");
INSERT INTO ulk1902_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesu uiabi detaut, kega, Nako kaka uabi iterare tuelf le, a nerute uaba diabolo? ");
INSERT INTO ulk1902_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","E Iudalam detager, Simona Isakariota ra uerem: abelelam E ko abi keserker, E nerute tuelf lelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Abele gaire lu iobaru, Iesu Galilaiaem ekas: E nole la kak Iudaiaem ekas, abelelam Iudaia le giz deraimerare abi ipitare. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Maike Iudaia le giz ra uetpur, abele nerazi meta uetpur. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Abara keimer giz abi detautare, kega, Ge dekaer, a Iudaiaem bakeam, ueakai mara kaimeg giz dasmerare gaire lu ma ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ege nole le dorge mudige ikeli, ese E lagelag E natomertare. Ese mama ikeli abele gaire lu, mama natomertare gesepem. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ege abara keimer giz nole abi oatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iesu uiabim detautare, kega, Kara kerker ge nole tabarki; a peirdi uaba kerker. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Geseb nole umer kak uabi derarti; epe kari derarti, abelelam kaka uiaba adud dorge giz natomertare. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Uaba bakeauare abele uetpurem: peirdi kaka nole bakeam abele uetpur; abelelam kara kerker nole tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","E emetu detager abele mer uiabim, E Galilaiem emri. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Abara keimer giz emetu uetpurem bakeamuda, E ko bakeam, epe E gumik ekas, nole paret kak ekas. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Iudaia le giz, uetpur ge, abi deraimerare, a detautare, kega, E nade? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Gaire le lakub abim basardare: uader detaut, kega, E debele; a uader, kega, Nolea, E gaire le didmirki. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Epe nole le abi paret kak detautare, uiaba Iudaia le giz geum. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Uetpur ge eipu, Iesu zogo metaem bakeamuda, a okadaraskeda. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iudaia le giz damreda, a detaut, kega, Nalu le abele jauali umele, a nole ereuer kak? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu uiabim detaut, kega, Nole karielam kara ereuere, epe abielam, kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ese nerute le lagelag abara lag ikeli, E ereuer akmer, nako Adelam, nako kaka detaut karbabu. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Abele le tababu detaut, E deraimer tababu baospili: abele le deraimer ko abi despereda, abi emarida, E dali ageakar, nole barbar tonar abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nako, Mose nole gelar uabi ikuar, a nole nerute uabielam gelar irmili? Epe nako uaba deraimer kari uanapitare? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Gaire le lakub abim detaut, kega, Demoni mari dog: niti de mari naraimeli mari uanapit? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu uiabim detaut, kega, Kaka emetu nerute dorge ikeli, a uaba uridili damreda. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose peritom uabi ikuar, (epe nole Mosealam, mamoro kerem lelam;) uaba le peritom sabath ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ese nerute le peritom erpei sabath ge, ueakai nole Mose ra gelar datupida; nako uaba kari urker abelelam kaka le idigiri sabath ge? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nole erkepse irmi irmili pone, mamoro erkepse irmi irmili barkak itmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Eko uader le Ierusalemlam detaut, kega, Nako E dali uiaba deraimerare ko ipitare? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dasmer, E paret kak mer detautili, a uiaba nole nerute mer abi detaut, Nako, gaire kole umele, kega, Keriso kar idali? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Epe meriba umele E nagelam; a Keriso tabarki, nole le umele E nagelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesu ereretiki zogo meta ge, E okadeskeda a detager, kega, Uaba kari umele, a uaba umele kaka nagelam; kaka nole karbabu tabarki, E ageakar, kari namarida, a uaba abi umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kaka abi umele; abelelam kaka abielam, E kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Uiaba deraimerare abi terpeirare: a nole le abim tag itirimuda, abelelam abara kerker nole tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gaire lekublam abi oituli; uiaba detager, kega, Ese Keriso tabarki, nako, E ko ikeli gaire atamelam tumem E ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Gaire Faresaio asoli uiaba lekub abim basardare abele gaire lu; gaire zogo kemle a gaire Faresaio namarida gaire asesered le abi terpeirare. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iesu uiabim detaut, kega, Teupai kaka uabi dog emri, kerker maike kaka abim bakeamulu, kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Uaba ko kari naraimereda, a nole kari ardar kak: abele uteb kaka bakeamulu, uabu umer kak ko bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Gaire Iudaia le giz mer atager, kega, Nagedim E bakeam, a meriba nole abi ardar kak? nako, E ko bakeam uiabim gaire le bamarida Helene dog, a gaire Helene okadeskeda? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nalu abele mer, E detagereda, kega, Uaba kari naraimereda, a nole kari ardar kak: abele uteb kaka bakeamulu, uaba umer kak ko bakeam? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Keubu gerger, abele au gerger uetpur ge, Iesu tekueilu, a ereretikri, a detager, kega, Ese nerute le niap, karim tabakeam ko aree. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Abele le karim oituli, mokakalam zogo jauali detager, kega, Edede ni ko babusdarie abi nerkeplam. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","E detager abele Lamar Zogolam, uiaba gaire le abi oituli ko erpei abele. Lamar Zogo nole tabarki; abelelam Iesu nole eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Uader lekublam asoli abele mer, uiaba detager, kega, Ageakar, E perofeta pedali. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Uader datager, kega, E Keriso. A uader detager, kega, Nako, Keriso osmeda Galilaialam? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nako, nole zogo jauali detager, kega, Keriso tabarki Dauidalam, a Bethelemalam, abele Dauida ra uteb? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Abielam gaire le lakub barsardare. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Uader uiaba lagelag abi terpei, a nole le abim tag itirimuda. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gaire asesered le akomeda gaire zogo kemle pako Faresaio giz; uiaba uiabim detaut, kega, Nalugelam uaba nole abi tegaret? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Gaire asesered le detager, kega, Nole le mer egali mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Gaire Faresaio uiabim detaut, kega, Nako emetu uabi didmirki? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nako, nerute le abim oituli gaire opolelam, a gaire Faresaiolam? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Abele nosik le gelar umer kak, ko eumida. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo uiabim detaut, (E Iesuim bakeam ki ge, E nerute uiabielam), ");
INSERT INTO ulk1902_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nako, meriba gelar ra tonar ko kekiam bodomalam ikuar, a nole kekiam le itmer abele lu E ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Uiaba detaut, a abi detager, kega, Nako ma Galilaialam? Deraimer, a dasmer: nole perofeta dikedida Galilaialam. ");
INSERT INTO ulk1902_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Uiaba uridili tabara uteb bamarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iesu Oliua paserem bakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Idim ge, Iesu iako zogo meta ge balu, gaire le lakub abim tabakeuare; E emri, a uiabim okadeskeda. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Uiaba aotale giz pako Faresaio giz abim tegaret nerute eruam kosker, emetu erpei kerker eruamlam; a eipu ekueirare, ");
INSERT INTO ulk1902_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","A Iesuim detager, kega, Eruere le, abele kosker keriba eruamem terpei. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Emetu Mose keribi mer tigri, muige gelar, ko bakeru itimdare mokakalam: nako mara mer abim? ");
INSERT INTO ulk1902_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Uiaba detaut abele ge ko abi mirem, ueakai nagri mer ais abielam. Iesu esorgiru, a seb ge detali tagu. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Uiaba elele abi itmerare, E tekue, a uiabim detaut, kega, Debele le eruam kak kekiam bakeru abi itimdi. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","E iako esorgiru, a seb ge detali tagu. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Uiaba emetu asoli, uiaba nerute a nerute eosmeda, ditimeda aule a mop ge itiagi: Iesu tepteb pako kosker eipu ekueilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu etilu, a kosker tepteb dasmer, a abi detager, Kosker, uiaba nade marim mer ais? nako nole le mari bakeru natimdi? ");
INSERT INTO ulk1902_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","E detaut, kega, Opole, nolea kar. Iesu iako abim detager, kega, Ka ko nole mari bakeru natimili: bakeam; iako nole eruam kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu iako uiabim detaut, kega, Kaka geseb datki: abele le kari narmili E nole kupkupi ge bakeam, epe E nagri datki eded. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Faresaio giz abi detautare, kega, Mabu ma ageakarem; nole ageakar mara mer. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu uiabim detaut, kega, Ese karababu kari ageakarem, kara mer ageakar; abelelam kaka umele kaka nagelam, a kai na gedim bakeam; uaba nole umer kak kaka nagelam, a kai na gedim bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Uaba erkepse irmi gem ge irmili; kaka nole nerute le erkepse irmi. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ese kaka erkepse irmi, ageakar kaka erkepse irmi; abelelam kaka nole tepteb, epe kaka pako Baba, kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Emetu detali muige uaba gelar, kega, Ageakar abele mer neisi le ageakarem. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Karbabu kari ageakarem, a Baba, kari namarida, kari ageakarem. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Uiaba abi detautare, kega, Mara Aba nade? Iesu detaut, Uaba nole kari umer kak, a kara Aba: ese uaba kari umele, uaba kara Aba umele. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Abele gaire mer Iesu detaut mani epei ge, E zogo meta ge okadeskeda: a nole le abi terpei; abelelam abara kerker nole tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu iako uiabim detaut, kega, Kai nabakeamulu, a uaba ko kari naraimerare, a uaba ko eumida uabi uitelam: uaba umer kak ko bakeam abele utebem kaka bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iudaia le giz mer atager, kega, Nako, tababu ko abi ipit, abelelam E detager, kega, Uaba umer kak ko bakeam abele utebem kaka bakeam? ");
INSERT INTO ulk1902_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","E uiabim detaut, kega, Uaba lokodlam; kaka kotorlam: uaba geseplam; kai nole geseplam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Abelelam kaka uabi detager, kega, Uaba ko eumida uaba uitelam: ese uaba nole egaret Kakanali, uaba ko eumida uabi uitelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Uiaba abi detautare, kega, Mama nete? Iesu uiabi detaut, kega, Pedali kaka uabi detager gizlam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kaka nagri dordor lu ko detager, a ko dikiapor uabim: E ageakar, kari namarida; kaka gesepem detager gaire lu kaka asoli abielam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Uiaba nole akmer kak E Abaem uiabim detager. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iesu uiabim detaut, kega, Ese uaba Le la Uerem armem tagis, uaba ko akmer kakanali, a kaka nole karbabu nerute lu ikeli, epe mokakalam Baba kari ereuerem, kaka detaut abele gaire lu. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","E kari dog, kari namarida; E nole kari nakaerti; abelelam kaka gaire lu ikeli abim sererge. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","E detager abele gaire lu, a gaire le abim oituli. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iesu detager, uiabim gaire Iudaia le giz abim oituli, kega, Ese kara mer niaiem uabi dog, uaba kara kaimeg giz kar; ");
INSERT INTO ulk1902_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Uaba ko ageakar akmer, abele ageakar ko uabi emariklu. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Uiaba abi detautare, kega, Keriba Aberahama ra omasker, a nole didbare nerute le dog: epe nako ma detager, Keriba ko emariklu? ");
INSERT INTO ulk1902_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu uiabim detaut, kega, Ageakar, ageakar, kaka uabi detager, kega, Abele le uit ikeli, E uite ra memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Abele memeg le nole uteb ge niaiem emri: mamoro uerem niaiem emri. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ese Uerem uabi emariklu, uaba ageakar emariklu. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kaka umele uaba Aberahama ra omasker; epe nako uaba deraimer kari ipit, abelelam kara mer nole uabi nerkep ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kaka detager kaka dasmer kari Baba dog: a uaba ikerare abele gaire lu uaba asoli uaba abalam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Uiaba abi detautare, kega, Aberahama keriba aba. Iesu uiabi detaut, kega, Ese uaba Aberahama ra omasker, uaba ko ikeli Aberahama ra dorge. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Peirdi uaba naraimer ko kari napit, nerute le uabi detager ageakar, kaka asoli Adelam: Aberahama nole ikeli mokakalam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Uaba ikeli uaba aba ra dorge. Uiaba abi detager, kega, Keriba nole eruam omasker; netate keriba Aba, Ade. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu uiabim detaut, kega, Ese Ade uaba Aba, uaba ko kari lag: abelelam kaka nabue, a ge tabarki Adelam; kaka nole karbabu tabarki, epe E kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nako uaba nole akmer kak kara mer? Abelelam uaba umer kak kara mer asoli. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Uaba uaba abalam diabolo, uaba lagelag uaba abara lag ikeli. E dipe le gizelam, a nole ageakar, abelelam nole nerute ageakar abi dog. Ese E bes mer detaut, E detaut tababielam; abelelam E besbes, a aba bes apu. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Abelelam kaka ageakar detaut, uaba nole kari oatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nitide uabim kari uit natomerti? Ese kaka ageakar detaut, epe nako uaba nole kari oatur kak? ");
INSERT INTO ulk1902_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Abele le Adelam, Ade ra mer asoli: uaba nole asor kak, abelelam uaba nole Adelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iudaia giz abi detaut, kega, Nako, keriba nole barkak detaut ma Samaria le, a demoni mari dog? ");
INSERT INTO ulk1902_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu detaut, kega, Kara nole nagri demoni; ege kaka kara Aba naospereda, a uaba kari nakekeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kaka nole deraimer karababu naospereda: ege nerute le deraimer, a baraditug. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ageakar, ageakar, kaka uabi detager, kega, Ese nerute le kara mer asoli, E nole eud asmer kak niai karem. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iudaia giz abi detautare, Peirdi keriba umele mari dog demoni. Aberahama emetu eumida, pako gaire perofeta; a mama detager, kega, Ese nerute le kara mer asoli, E eud asmer kak niai karem. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nako, mama aule tumem keriba aba Aberahama emetu eumida? a gaire perofeta ko eumida: nete mama depegili? ");
INSERT INTO ulk1902_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu detaut, kega, Ese kaka karababu baospili, nole ageakar karababu naospili: kara Aba kari naospili; E dali uaba detaut uaba Ade; ");
INSERT INTO ulk1902_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Uaba nole abi umer kak: kaka abim umele; ese kaka detaut, kega, Kaka nole abi umer kak, kaka iako besbes mokakalam uaba; epe kaka abim umele, a abara mer asoli. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Uaba aba Aberahama sererge kara gerger dasmer; E emetu dasmer, E ko sererge. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iudaia giz abi detautare, kega, Mara urut nole fifeti, epe nako mama Aberahama dasmer? ");
INSERT INTO ulk1902_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu uiabim detaut, kega, Ageakar, ageakar, kaka uabi detager, Kakanali, Aberahama aosmer kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Uiaba baker taisare ko abi itimdare: a Iesu gumik bakeamulu, a teosmelu zogo metalam. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu ekas idimirki, E dasmer nerute le sadamer kerker ge osmelu. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abara kaimeg giz abi nautmerare, kega, Rabi, nete adud, E dali, nako abara aba a apu, abelelam E esmelu sadamer? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu detaut, kega, E nole adud, a abara aba a apu nolea: epe Ade ra dorge abi tumge etomeret. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Meriba dorge ko ikerare abara dorge, kari namarida, gerger ge; ki ko tabarki, nole le umer kak dorge ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kaka geseb datki, abele kerker kaka geseb ge emri. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","E emetu detager abele, E mos ekeilu gesepem, a sep mog detagem moselam, abara pone asauem, ");
INSERT INTO ulk1902_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A abi detager, kega, Bakeam, dirup Siloam keper (tonar abele nei, Namarida). E bakeam, a dirup, iako tabakeam mamoro dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Abara boai, pako gaire le, emeret abi dasmer sadamer, uiaba detager, kega, Nako nole E dali lugem bamos? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Uader detager, kega, Eko, E dali: a uader, kega, Nolea, E abi kaise. E detager, kega, Kakanali. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Uiaba abi detager, kega, Nako abele tonar mara neisi pone diski? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","E detaut, kega, Abele le, nei atker Iesu, sep mog detagem, a kara neisi pone asauem, a kari natager, kega, Bakeam Siloamem, a dirup: kaka bakeam, a dirup, epe kaka bakaerti. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Uiaba abi detager, kega, E nade? E detaut, kega, Kaka umer kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Uiaba emeret sadamer le tegardare uiabim Faresaio giz. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Abele sabath ge Iesu sep mog detagem, a abara neisi pone diski. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Faresaio giz iako abim bautumer, kega, Nako tonar ma bakaerti? E uiabim detaut, kega, E sep mog kara neisi pone asauem, kaka dirup, epe bakaerti. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Uader Faresaio giz detager, kega, Abele le nole Adelam, E nole sabath irmili. Uader detaut, kega, Nako, adud le umele ikeli gaire atamelam mokakalam? Uiaba nakesmulu. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Uiaba iako sadamer detaut, kega, Nako mara mer abim, abelelam E mara neisi pone diski? E detager, kega, E perofeta. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Iudaia giz nole egaret abele tonar emeret E sadamer le, a peirdi bakaerti, uiaba kekiam abara aba a apu dabgeri, ");
INSERT INTO ulk1902_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","A uiaba nautumer, kega, Nako, uaba uerem idali sadamer esmelu? Nalu tonarlam E bakaerti peirdi? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Abara aba a apu uiabim detaut, kega, Ki umele keriba uerem peik, a E sadamer esmeda: ");
INSERT INTO ulk1902_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Epe ki umer kak nalugelam peirdi E bakaerti; a ki umer kak nete de abara neisi pone diski: E aule, abi itmer; E umele tababu detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abara aba a apu abele detaut, abelelam uiaba Iudaia giz geum: Iudaia giz netate mer, kega, Ese nerute le abi abeilu Keriso pedali, uiaba ko abi imuare sunagolam. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Abelelam abara aba a apu detager, kega, E aule; abi itmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Uiaba iako neisi dabgeri abele sadamer le, a abi detager, kega, Ade despili: keriba umele adud le dali. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","E detaut, kega, Ese E adud le, kaka umer kak: netate lu kaka umele, emeret kaka sadamer, a peirdi kaka bakaerti. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Uiaba iako abi detaut, kega, Nalu E ikeli marim? nalugem E mara neisi pone diskilu? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","E uiabim detaut, kega, Kaka emetu uabi detager, a uaba nole asor kak: epe nako uaba lagelag ko abara memeg le? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Uiaba adud mer abim, a detaut, kega, Mama abara memeg le; mamoro keriba Mose ra memeg le. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Keriba umele Ade Mose detaut: epe ki umer kak nagelam abele le dali. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Abele le uiabim detaut, kega, Dame lu peik, uaba nole umer kak E nagelam, a E emetu kara neisi pone diski. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Meriba umele Ade nole adud le asoli: ese nerute le Adim esorerapare, pako abara dorge ikeli, E ko abi asoli. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Netede asoli emeret ge nerute le umele diski neisi pone abele le sadamer teosmelu? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ese nole Adelam abele le, E nole umer kak nerute lu ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Uiaba abi detaut, kega, Ma eosmeda uitelam, nako ma keribi okadeskeda? Uiaba abi imuare. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu asoli uiaba emetu abi imuare; E abi erdali, a abi detager, kega, Nako, ma Ade ra Uerem oituli? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","E detaut, kega, Opole, nete dali, ueakai kaka ko abi oituli? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu abi detaut, kega, Ma abi umele, a E dali mari mer atagere. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","E detaut, kega, Opole ae, kaka oituli. E abi esorgiru. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu detager, kega, Kaka geseb ge tabarki ko barditug, ueakai bakaerti gaire le asmer kak; epe gaire le dasmer ko sadamer. ");
INSERT INTO ulk1902_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Uader Faresaio giz abi dog asoli abele, uiaba abi detautare, kega, Nako, keriba ko sadamer? ");
INSERT INTO ulk1902_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu uiabim detaut, kega, Ese uaba sadamer, uaba nole adud nagri; epe uaba detager, kega, Keriba dasmer: uaba uit mena dali. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ageakar, ageakar, kaka uabi detager, kega, Abele le nole balu mamoe giz gab te ge, a ogi nerute gab ge, E eruam le, a lu gatkamer le. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Abele le gab ge balu, E mamoe giz asesered. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Gab asesered le ko diski abim; ege gaire mamoe giz aserare abara kodo mer: E darabgerare gaire nei gaire abara mamoe, a uiaba adige tegaret. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ese emetu gaire abara mamoe adige tegaret, E ko kekiam bakeam, a gaire mamoe abi irmili: abelelam uiaba akmer abara kodo mer. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Uiaba nole sub le irmili, epe abi derarti: abelelam uiaba akmer kak sub le giz ra kodo mer. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu uiabim detaut abele mer babisdarie: epe uiaba nole akmer kak abara mer, E uiabim detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iesu iako uiabim detaut, kega, Ageakar, ageakar, kaka uabi detager, kega, Kaka mamoe giz ra te. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gaire le uridili kekiam tabarki, uiaba gaire eruam le, a gaire lu gatkamer le: a gaire mamoe nole uiabim asoli. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kai te nali; ese nerute le kari dog balu, E ko eded, ako balu, a eosmelu, a ko leuer nagri. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ese eruam le tabarki, E tabarki ko eruam, a ko ipit eumilu, a lu gatkamer: kaka tabarki ueakai uiaba eded nagri, a ko au nagri. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Kaka mamoe giz asesered le kar: abele le mamoro mamoe asesered, E abara eded ikuar uiabim mamoe giz. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Abele le bodomalam erpei, a nole mamoe giz asesered le, a gaire mamoe nole tabara mamoe, E luko dasmer kei tabakeam, E gaire mamoe darakaertare, a koreder emerilu, epe gaire mamoe eregili luko de, uiaba kepu bamarida: ");
INSERT INTO ulk1902_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","E koreder emerilu, abelelam E bodomalam erpeilu, E nole gaire mamoe dikiapor. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Kakanali mamoe giz asesered le kar; kaka umele gaire kara mamoe, a uiaba kari umele. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mokakalam Baba kari nasmeli, abkoreb kaka Baba nasmeli; kaka ko ikuar karbaba eded uiabim gaire mamoe. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kaka nagri uader mamoe, nole abele kalam: kaka ko a uiaba tegaret, a uiaba ko kara kodo mer aserare; iaueakai netate uteb gaire mamoe, a netate asesered le. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ege kara Aba kari omare, abelelam kaka karbara eded ikuar, iako takalu. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nole nerute le itke karielam, kaka karbabu ikuar: kara adigir nagri ko kara eded ikuar, a kara adigir nagri iako takalu. Abele gelar kaka erpei kara Abalam. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gaire Iudaia le nakesmulu abele gaire merlam. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dordor uiabielam detaut, kega, Demoni abi dog, E paim paim; nalugelam uaba abi asoli? ");
INSERT INTO ulk1902_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ege uader detager, kega, Nole demoni le la mer peike. Nako, demoni umele diski sadamer le la neisi pone? ");
INSERT INTO ulk1902_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Abele Ierusalema ge uetpur: dilik bar ge; ");
INSERT INTO ulk1902_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","A Iesu ekas zogo meta, muige Solomona ra maisu ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iudaia giz netate gedim abi derumeda, a abi detager, kega, Ma keribi bamsili naket gerger? Ese mama Keriso, paret kak keribim detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu uiabim detaut, kega, Kaka emetu uabi detagereda, uaba nole arpeir kak: abele gaire dorge kaka ikeli kara Aba ra nei ge, abele kari ageakarem. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Uaba nole arpeir kak, abelelam uaba nole kara mamoe giz. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Gaire kara mamoe asoli kara kodo mer, a kaka uiabi umele, a uiaba kari irmili: ");
INSERT INTO ulk1902_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A Kaka ko uiabim ikuar eded aseamur kak; a uiaba nole eud kak niaiem niai karem, a nole le uiabi natkedarare kara taglam. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kara Aba, aule tumem gaire lu uridili, E uiaba kari nakuar: a nole le umele uiaba natkedarare kara Aba ra taglam. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kaka pako Aba, ki netat. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iudaia giz baker tais ko abi itimdare. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iesu uiabim detager, kega, Dordor gaire debe dorge kaka uabi detomereta karba Abalam; na dorgelam uaba kari bakeru natimeda? ");
INSERT INTO ulk1902_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Iudaia giz abi detaut, kega, Keriba nole mari bakeru natimeda debe dorgelam, epe aospilam; abelelam mama le, a mabu bakeli Ade. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu uiabim detaut, kega, Nole uaba gelar aotar kak, kega, Kaka detaut, Uaba ade giz? ");
INSERT INTO ulk1902_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ese E emetu detager, kega, Uiaba gaire ade, uiabim gaire le Ade ra mer tabarki (a nole umer kak ko desak abele zogo mer detar), ");
INSERT INTO ulk1902_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nako, uaba detager abi abei abele Aba zogoem a gesepem namarida, kega, Ma baospili; abelelam kaka detager, kega, Kaka Ade ra Uerem? ");
INSERT INTO ulk1902_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ese kaka nole ikeli abele gaire kara Aba ra dorge, nole kari agaret kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ese kaka ikeli, a uaba nole kari agaret kak, debele gaire dorge egaret: iaueakai uaba umele a egaret kega, Aba karim muige, a kaka muige kara Aba. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Uiaba iako deraimer abi terpei: ege E uiabielam ispilu uiaba taglam. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","E iako bakeamulu Ioridano apek, abele uteb Ioane de kekiam bapataiso; a abele ge E emri. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gaire le abim tabakeauare, a mer atager, kega, Ioane nole ikeli nerute atamelam; epe ageakar gaire mer uridili Ioane de abi abeilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Gaire le abi oituli pedali. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nerute le gimgim, Lazaro Bethania le, Maria pako Maretha abi narbete ra uteb. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Abele Maria Kole basao muro de, a tabara neisi teter itkir mus de, abara berbet gimgim, pe Lazaro. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Neisi abara berbet abim namarida, a detager, kega, Kole, ma dasmer E mama abi nasge, E gimgim. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iesu asoli, a detager, kega, Nole niai eud abele gim, epe ko Ade despereda, iaueakai Ade ra Uerem despereda. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu Maretha omare, a tabara keimer, a Lazaro. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","E asoli E gimgim, E iako emri abele uteb neisi gerger. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Abele iobaru, E abara kaimeg giz detager, kega, Meriba iako bakeauare Iudaiaem. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ege kaimeg giz abi detager, kega, Rabi, emeret ge Iudaia giz mari deraimer ko bakeru mari natimdare; nako ma iako bakeam abele? ");
INSERT INTO ulk1902_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu detaut, kega, Nako, nole tuelf gaire haua gerger ge? Ese nerute le gerger ge ekas, E nole teter itur, abelelam E geseb datki dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ese nerute le kige ekas, E ko teter itur, abelelam datki nole abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Abele gaire lu E detaut: keubu abele, E uiabim detager, kega, Lazaro uteid, meriba boai; kaka bakeam iaueakai kaka abi itiri uteidelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Abara kaimeg giz abi detaut, kega, Opole, ese E uteid, E iako eded. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu abara eud detaut; uiaba dikiapor, kega, E detaut uteid, a nerezi. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Abelelam Iesu paret kak detaut uiabim, kega, Lazaro eumida. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Uabielam kaka sererge, abelelam kaka nole nali, iaueakai uaba oituli; epe mi nabakeauare abim. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma, nei atker, Didumo, tabara keme kaimeg giz detaut, kega, Mi ko nabakeauare, abi kemem eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesu tabarki, E dasmer foa gerger, E ao ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethania maike Ierusalema, mokakalam fiftin gaire setadia: ");
INSERT INTO ulk1902_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Dordor Iudaia le tabakeuare Marethaem a Mariaem, ui ko baimilei ui berbetlam. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maretha asoli, kega, Iesu tabarki, E bakeam abim obapit: Maria penoka muige meta. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maretha Iesu detager, kega, Kole, ese ma ge emri, kara berbet nole eud kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Peirdi kaka umele, gaire lu uridili ma damos Adelam, E ko mari ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu abi detaut, kega, Mara berbet ko eded akaida. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maretha abi detager, kega, Kaka umele E ko eded akaida abele keubu gerger. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu abi detaut, kega, Kaka abele eded akaida, pako eded: abele le karim oituli, ese eud, E ko eded: ");
INSERT INTO ulk1902_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Abele le eded karielam, pako karim oituli, E nole eud kak niaiem niai karem. Nako, ma egaret abele mer? ");
INSERT INTO ulk1902_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","E abi detaut, kega, Eko, Opole: kaka dikiapor mama Keriso, Ade ra Uerem, gesepem tarabu. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","E emetu abele mer detaut, E bakeamulu, a Maria abara keimer gumik dabgeri, a detager, kega, Opole emetu tabarki, E mari dabgeri. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","E abele asoli, E sobkak tekue, a abim bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu nole uteb ge tabarki, E no emri abele uteb Maretha abi obapit. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iudaia giz abi dog meta ge, abi baimida, uiaba dasmer Maria sobkak tekue, a adem bakeam, uiaba abi irmili, a detager, kega, E aoem bakeam ko ezoli abele. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria tabarki Iesu dog, a abi dasmer, E ekesmer abara teter ge, a abi detager, kega, Opole, ese ma ge emri, kara berbet nole eud kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu abi dasmer ezoli, a Iudaia giz abi kemem bakeam ko ezoli, E kemge nerezi, a okasosok, ");
INSERT INTO ulk1902_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A detager, kega, Nade uaba abi ikederare? Uiaba detager, kega, Opole, tabakeam a dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu ezoli. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iudaia giz detaut, kega, Dasmer, E abim au omare! ");
INSERT INTO ulk1902_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Epe uader detaut, kega, Nako, abele le sadamer le la neisi pone diski, E umer kak daisumda a nole eud kak abele le? ");
INSERT INTO ulk1902_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu iako taba nerkep ge nerezi, a aoem tabarki. Kur peik, baker te ge dimilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu detager, kega, Baker adem. Maretha, abara berbet eumida, detaut, kega, Opole, E simelag: ege foa abara gerger. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iesu abi detaut, kega, Nako, kaka nole mari natager, ese mama oituli, ma ko dasmer Ade ra adigir? ");
INSERT INTO ulk1902_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Uiaba baker adem uteblam eud le uteid. Iesu kotorem etilu, a detaut, kega, Baba, kaka marim esoao, abelelam ma kari asoli. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kaka umele mama mena kari asoli: kaka emetu abele detager abelelam gaire le lakub derumeda, iaueakai uiaba ko egaret ma kari namarid. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","E emetu detaut abele, E elele ereretikri, kega, Lazaro, teosmeda. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Epe eud le osmeda, abara teter pako abara tag emetu sopem irpi ualiu, a abara op sopem irpi tauelu. Iesu uiabim detaut, kega, Abi detue, a abi emariklu ko bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iudaia giz Mariaem tabaruda dasmerare gaire lu Iesu de ikerer, uader abi oituli. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Epe uader uiabielam Faresaioim barkare, a uiabi daratagerare gaire lu Iesu de ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Zogo kemle giz, pako Faresaio giz netate gedim ko mer atager, kega, Mi nako? abelelam gaire adigir abele le ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ese meriba abi dekaerti mokakalam, gaire le uridili abi oituli: epe gaire Roma tabarkare meriba ged, a meriba uteb uaditkamarare. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nerute uiabielam, nei Kaiafa, tarim zogo kemle abele urut ge, uiabim detager, kega, Uaba umer kak nerute lu, ");
INSERT INTO ulk1902_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","A nole akiapor kak, ido lu meribim nerute le ko eumida ab ged ra kes, a ged uridili nole eud kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","E nole noge detaut ege: E tarim zogozogo le abele urut ge, E perofetaem, kega, Iesu ko eumida ab ged ra kes: ");
INSERT INTO ulk1902_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A nole ab ged ra kes tepteb, epe ko netate gedim gaire Ade ra uerem bamarida, iako netate uteb. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Uiaba okaikes, a ditimeda abele gerger ge deraimer ko abi ipit eumida. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Abelelam Iesu nole paret kak bakeam Iudaia ge, epe E bakeam abele ged maike soge purge, nei Efaraima; a kemem emri abara kaimeg giz pedali. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iudaia giz ra paseka maike: gaire le bakeauare Ierusalemem ab gedelam ko kekiam tereiem, a keubu paseka. ");
INSERT INTO ulk1902_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Uiaba Iesu deraimer, a etkemdare zogo meta muige, kega, Nalu uaua dikiapor? Nako, E uetpurem tabakeam? ");
INSERT INTO ulk1902_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Uiaba gaire tarim zogozogo le, pako gaire Faresaio gelar ekos, kega, Ese nerute le umele abele uteb E emri, abara dorge ko etomeret, ueakai uiaba abi terpei. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sikes gaire gerger epe paseka akerare, Iesu Bethania tabarki, Lazaro dali, abele le eded akaida eudelam Iesu de. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Uiaba abele leuer derser abim: Maretha memeg le; Lazaro uiabi kemem leuer ero abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria muro netate paun tekalu, lu kar, a Iesu ra neisi teter dedered, a itkir abi mus de: mitkar abele meta muro lag de. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nerute abara kaimeg giz, nei Iuda Isakariota, Simona ra uerem, abele le ko abi keserkeser, E detager, kega, ");
INSERT INTO ulk1902_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Nalugelam nole terapei abele muro, bodomalam thri handed denari, ko ikuar gaire le lu kak? ");
INSERT INTO ulk1902_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","E nole abele detaut abelelam E gaire le lu kak omare; epe E eruam le, a epei abi dog, E tais gaire lu arot. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iesu detager, kega, Nole abi ekai; E abele ge ikedilu a ko tabarki abele gerger kari natkobei. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gaire le lu kak mena uabi dog; kaka nole niaiem uabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dordor Iudaia giz umele E abele ge emri: uiaba tabakeuare, nole Iesuelam tepteb, epe uiaba lagelag Lazaro ko dasmer, abele le eded akaida eudelam Iesu de. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Gaire tarim zogozogo le mer atager ko Lazaro ipit eumilu; ");
INSERT INTO ulk1902_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Abelelam gaire Iudaia bakeuare, a Iesu oituli abielam. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Iuaokaer, gaire le lakub uetpurem tabakeuare asoli, kega, Iesu ko tabakeam Ierusalemem, ");
INSERT INTO ulk1902_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Uiaba pama lislis taisare, a bakeuare abi obapit, a ereretikri, kega, Hosana: Isaraela Opole despili, Iehoua nei ge tabakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu nerute kebi asina erdalu, E abi tumge egimulu; mokakalam mer detali, kega, ");
INSERT INTO ulk1902_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ma nole geum kak Ziona ra neur; dasmer, mara Opole tabakeam, asina ra uerem egimulu. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Abara kaimeg giz nole akmer kak abele gaire lu gizlam: epe emetu Iesu despereda, uiaba dikiapor, kega, Emetu detali abele gaire lu abielam, a emetu uiaba ikerare abele gaire lu abim. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Gaire le abi dog ageakarem E Lazaro dabgiri aolam, a abi eded akaida eudelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Abelelam gaire le lakub bakeuare abi obapit uiaba asoli E ikeli abele atamelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Abelelam Faresaio giz mer atager, kega, Uaba dasmer, uaba umer kak nerute lu; dasmer, geseb ge uridili abi irmili. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Uader Helene giz kemem gaire le uetpurem tabakeuare ko esorerapare: ");
INSERT INTO ulk1902_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ui Filipoim tabakeuare, Bethesaida Galilaia le, a abi eutumer, kega, Kole, ki lagelag Iesu dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo bakeam a Anedereaim detager: epe Anederea a Filipo tabakeamulei, a Iesuim detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu uiabim detaut, kega, Kerker idali, Le la Uerem despili. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ageakar, ageakar, kaka uabi detager, kega, Ese nerute kon kep nole seb ge abi, a uatuet, E tepteb ipe: ese E uatuet, E au turum. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Abele le abara eded nasge, abele ko abi: epe abele le abara eded dedkoli geseb ge, E ko eded nagri aseamur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ese nerute le kara memeg le, abara dorge kari narmili; abele uteb kaka emri, kara memeg le la uteb dali: ese nerute le kari memeg le, Baba de abi despili. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Peirdi kara nerkep okasosok; nalu kaka ko detaut? Baba kari nakai abele kerkerlam. Epe abelelam kaka tabarki abele kerker ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba, mabara nei despili. Ege kodo mer uatabu kotorlam, kega, Kaka emetu despili, kaka iako despili. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gaire le abele bako asoli, a detaut, kega, Girgir dali: uader detager, kega, Angela abi mer egali. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu detaut, kega, Abele kodo mer nole uatabu karim, epe uabim. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Peirdi dulam gesepem tabarki: peirdi ko adem imu geseb tarim le. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A kaka, ese kari nagaret armem geseblam, kaka ko eguatumur gaire le uridili karim. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","E abele ge detaut, ko etomeret abele eud ko abim tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Gaire le abi detaut, kega, Keriba asoli gelarlam, kega, Keriso niaiem tekue: nalugelam mama detaut, kega, Ko armem egaret Le la Uerem? Nete Le la Uerem dali? ");
INSERT INTO ulk1902_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iesu uiabim detaut, kega, Datki teupei uabi dog. Bakeuare kerker uaba datki nagri uabi dog, kupkupilam uabim tabarki: abele le ki ge degemili, E nole umer kak E na gedim bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Datki egaret kerker datki uabi dog, ueakai uaba datki ra uerem. Iesu abele detaut, E bakeamulu, a uiabielam ispilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E ikerare gaire adigir uiabi opem, epe uiaba nole abim oatur kak: ");
INSERT INTO ulk1902_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ueakai eski abele mer Isaia perofeta de detaut, kega, Opole, nete de egaret keriba merkem? A neteim paret kak Iehoua ra tag? ");
INSERT INTO ulk1902_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Uiaba umer kak oituli, abelelam Isaia de iako detaut, kega, ");
INSERT INTO ulk1902_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","E uiaba gaire pone darasamare, a uiaba nerkep imirida; ueakai uiaba nole asmer kak gaire pone de, a nole akiapor kak nerkep de, akomelam, a kaka uiabi nadgirare. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Abele Isaia de detaut, abelelam E abara zorom dasmer; E abi abeilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gaire uiabielam tarim le abi oituli; epe uiaba nole etomeret kak gaire Faresaiolam, uiabi amulam sunagolam: ");
INSERT INTO ulk1902_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Abelelam lu kar uiabim despili lelam, tumem despili Adelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesu ereretikri, a detaut, kega, Abele le kari oituli, E nole kari oituli tepteb, epe abim kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Abele le kari nasmili, E abi dasmer kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kaka nabue geseb datki, ueakai nole kupkup ge emri gaire le uridili karim oituli. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ese nerute le gaire kara mer asoli, a nole oatur kak, kaka nole abi itmer: abelelam kaka nole gesepem tabarki ko eutumer, epe gesepem ko ededem. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Abele le kari natuaki, a nole kara mer egaret, abi dog dulam: abele mer kaka detaut, E dali abi dulam keubu gerger. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kaka nole karbabu detaut; epe Baba de kari namarida, E kari gelar nakuar abele lu kaka ko detager, a detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kaka umele eded aseamur kak abara gelar; abele gaire mer kaka detager, abkoreb Baba de kari nataut, eko kaka detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paseka nole aker kak, Iesu umele abara kerker tabarki ko bakeamulu geseplam tabara Abem, E emetu tabara boai omare gesepem, E uiabi omare, a mop ge tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kikem leuer ero, diabolo ikedi Iuda Isakariota ra nerkep, Simona ra uerem, ko abi keserkeser, ");
INSERT INTO ulk1902_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu umele Aba de nakuar abi tagem gaire lu uridili, pako E Adelam, a E Adim iako bakeam, ");
INSERT INTO ulk1902_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Abelelam emetu leuer ero, E ekueda, a abara am uali adem; E mog uali esolu. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","E ni epaitere ezerem, a ditimeda ko dedered abara kaimeg giz ra teter, a itkir mog uali de abi asodalam. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","E Simona Peteruim toabukilu. E Iesuim detaut, kega, Opole, nako, ma kara neisi teter dedered? ");
INSERT INTO ulk1902_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu abi detaut, kega, Abele lu kaka ikeli, ma umer kak peirdi; mamoro ma niaiem umele. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peteru abi detaut, kega, Ma nole kara neisi teter dedered niai karem. Iesu abi detaut, kega, Ese kaka nole mari dedered, ma nole lu kak nagri kari dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona Peteru abi detaut, kega, Opole, nole kara neisi teter tepteb, epe kara neisi tag, a kara kerem ko. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu abi detaut, kega, Abele le emetu dedered, nole lu kar iako abi dedered, epe neisi teter tepteb, ueakai kerkar eseamuda: uaba kerkar, epe nole uaba uridili. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","E opasereret abele le ko abi keserkeser: abelelam E detaut, kega, Uaba nole kerkar uridili. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","E emetu uiaba teter dedered, E iako tabara am uali tekalu, a iako emri, a uiabim detaut, kega, Nako, uaba umele abele lu kaka uabim ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Uaba kari nabei, Ereuere le, a Opole, uaba debe detaut, abelelam kakanali. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ese kaka, Opole kar, a Ereuere le kar, a emetu uaba teter dedered, debele uaba uabu dedered uaba teter. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kaka emetu tonar uabi dekuarda, ueakai uaba ikerare abkoreb kaka uabi ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ageakar, ageakar, kaka uabi detager, kega, Memeg le nole aule tumem abara opole; a nole abele le namarida tumem abele le abi namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ese uaba umele abele gaire lu, debe mop uabim ua se ikerare. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kaka nole uaba uridili detager: kaka umele gaire le kaka dabgered: ueakai bakedida mer detali kega, Abele le kari dog leuer ero, E emetu abara teter kari natiri. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kaka uabi detager, a nole bakedida abele lu, ueakai ese bakedida, uaba ko dikiapor kakanali. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ageakar, ageakar, kaka uabi detager, kega, Abele le egaret le kaka namarida, E kari egaret: abele le kari egaret, E abi egaret, kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Emetu Iesu abele detaut, abara lamar okasosok, E daratagerare, kega, Ageakar, ageakar, kaka uabi detager, nerute uabielam ko kari keserkeser. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kaimeg giz erkepu baskare, uiaba kok bagagarare, nete de abeida. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nerute abara kaimeg giz, Iesu ra marmot ge uteidilu, Iesu abi nasge. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simona Peteru abim opu batimeda, a abi detager, kega, Keribi detager na le E detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","E dali, Iesu ra marmot uteidilu, egreemalu a abi detager, kega, Opole, nete? ");
INSERT INTO ulk1902_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ege Iesu detaut, kega, Le dali kaka ko mog leuer ikuar, ese emetu akmeilu. E emetu mog leuer akmeilu, E ekalu a Iuda ikuar, Simona Isakariota ra uerem. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Abele mog leuer iobaru, Satana abi nerkep balu. Iesu abi detaut, kega, Abele lu ma ko ikeli, elele ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nole nerute le, uiabielam kemem Iesu leuer ero, umele nalugelam E detaut abele mer abim. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Uader dikiapor, abelelam Iuda dog epei, Iesu abi detaut, kega, Ma erapei gaire lu meribi koreb abele uetpur ge: nerute, ko ikuar uader lu uiabim gaire le lu kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","E emetu mog leuer erpeilu, E sobkak eosmelu; a ki ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","E emetu eosmelu, Iesu detaut, kega, Peirdi, Le la Uerem despili, a Ade despili abielam. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ese E Ade despili, Ade ko abi despili, a ko elele abi despili. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Omasker, teupei kaka uabi dog. Uaba ko kari naraimili; mokakalam kaka Iudaia giz detaut, mokakalam kaka uabi detaut peirdi, kega, Abele uteb kaka bakeamulu, uaba umer kak ko bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kaka uabi ikuar kerkar gelar, kega, Uaba dorge ko uabu omare: mokakalam kaka uabi omare, abkoreb uaba omare uabu. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ese uaba uabu omare, gaire le uridili ko umele uaba kara kaimeg giz. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Peteru abi detaut, kega, Opole, ma na gedim bakeam? Iesu abi detaut, kega, Peirdi ma umer kak kari narmili; niaiem ma ko kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peteru abi detaut, kega, Opole, nalugelam kaka umer kak mari narmili peirdi? Kaka ko ikuar kara eded mara kes. ");
INSERT INTO ulk1902_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesu abi detaut, kega, Eko, ma ko ikuar mara eded kara kes? Ageakar, ageakar, kaka mari natagere, kega, kimiar faul nole ereretikri, ma ko kekiam thri kari nasared. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nole okasosok uaba nerkep: uaba Adim oituli, karim oituli ko. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Dordor uteb kara Aba ra meta ge; ese nolea; kaka emetu uabi detagereda; abelelam kai nabakeamulu uteb derser uabim. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ese ka nabakeamulu uteb derser uabim, kaka iako tarabue, uabi taisare karbabim: ueakai uaba kari kemem emri. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Uaba umele abele uteb kaka nabakeamulu, uaba gab umele ko. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma abi detager, kega, Opole, keriba umer kak ma na gedim bakeam; a nalugem keriba gab umele? ");
INSERT INTO ulk1902_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu abi detaut, kega, Kaka gab, a ageakar, a eded; nole le Abem bakeam, ese nole gab kari dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ese uaba kari umele, uaba kara Ab umele ko: peirdi uaba abi umele, a abi dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo abi detaut, kega, Opole, keribi Abet detomereta, a sina. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu abi detaut, kega, Nako, kaka emeret uabi dog, mama Filipo nole kari nasmeli? abele le kari nasmer, E kara Aba nasmeli; nako mama detaut, kega, Abet keribi detomereta? ");
INSERT INTO ulk1902_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nako, ma nole dikiapor kak, kaka muige Abaim, pako Aba karim muige? Abele gaire lu kaka uabi detager, kaka nole karbabu detager; epe Baba kari muige, E ikeli abele gaire dorge. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kari nagaret, kaka muige Abaim a Aba kari muige: ese nolea, debele egaret dorgelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ageakar, ageakar, kaka uabi detager, kega, Abele le karim oituli, gaire dorge kaka ikeli, E ko ikeli: epe E ko au ikeli tumem abele, abelelam kaka nabakeamulu karba Abem. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Gaire lu uridili ua damsare kara nei ge, kaka ikeli abele, ueakai Aba despili Uermet. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ese uaba lu damos kara nei ge, kaka ko ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ese uaba kari lag, uaba ko kara gelar irmili. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kaka ko Babim bali, ueakai E ko uabi ikuar nerute Upiatidar, ko uaba kemem emri niai karem, ");
INSERT INTO ulk1902_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Abele ageakar Lamar: gesep umer kak abi egaret; abelelam uiaba abi asmer kak, a nole abi akmer kak: epe uaba abi umele; abelelam E uabi dog emri, a E mena dali uabi nerkep ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kaka nole uabi dikaer mokakalam ab kak a apu kak uerem giz; kaka ko uabim tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Menaba gesep nole kari asmer kak; epe uaba kari nasmerare: abelelam kaka eded, ua ko eded. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Abele gerger uaba ko umele, kega, Kaka muige kara Aba, a uaba muige kari dog, a kaka muige uabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Abele le kara gelar nagri, a abele irmili, E kari lag: abele le kari lag Baba abi lag, a ka ko abi lag a kari natomelu abim. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ege Iuda (nole Isakariota) abi detaut, kega, Opole, nako mabu ko keribi detomertare, a nole gesepem ko? ");
INSERT INTO ulk1902_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu abi detaut, kega, Ese le kari lag, E mena kara mer erpei: kara Baba ko abi lag, epe ki tabarki abim, a abi kemem emri. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Abele le nole kari lag, E nole kara mer erpei: abele mer uaba asoli nole kara mer, epe Baba de kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kaka emetu detaut abele gaire mer uabim, kaka mena uabi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Abele Upiatidar, Lamar Zogo, Baba de ko namarida kari nei ge, E ko uabi dereuered gaire lu uridili, a ko uabim dikiaporare gaire lu uridili kaka uabi detager. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mapodan kaka uabi dog ikeli; kaka uabi ikuar kara mapodan: kaka nole uabi ikuar mokakalam gesep ikuar. Nole okasosok uaba nerkep, a nole geum. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Uaba emetu asoli kaka uabi detager, kega, Kai nabakeamulu, kaka iako tabakeam uabim. Ese uaba kari lag, uaba ko sererge kara mer, kega, Kaka Abem nabakeamulu: abelelam kara Aba aule kari tumge. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Peirdi kaka uabi detager, a nole bakedida, iaueakai ese bakedida, uaba ko egaret. ");
INSERT INTO ulk1902_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kaka nole iako perepere mer atager uabim, abelelam geseb tarim ko tabarki: a nole nerute abara lu kari dog; ");
INSERT INTO ulk1902_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ueakai geseb umele kaka Babe lag, a kaka ikeli mokakalam Baba de kari mer tigri. Tekue, nabakeuare. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kaka uina kar, kara Aba uina paret le. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","E ko ismi gaire tam kari dog nole turum kak: a gaire tam turum turum E ko paret, ueakai au turum. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Uaba peirdi kerkar, kara merlam kaka uabi detager. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Uaba bameri kara nerkep ge, a kaka uabi nerkep ge emri. Mokakalam tam nole umer kak tababu turum, ese nole ekpi uina ge; a mokakalam uaba nole umer kak, ese nole kara nerkep ge bameri. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Kaka uina, uaua gaire tam: Abele le kara nerkep ge emri, a kaka muige abi nerkep, E dali ko au turum: abelelem uaba umer kak nerute lu ikeli ese kaka muriz ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ese nerute le nole kara nerkep ge emri, debele abi adem ismi mokakalam tam, ueakai uatuet: gaire le etkemet, a urem dikri, a urem. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ese uaba kara nerkep ge bameri, a kara mer uabi nerkep ge tarageri, ua ko damsare gaire lu uaba lagelag, ueakai ikeli uabim. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Babim despereda, ese uaba au turum turum; iauaekai uaba kara kaimeg giz. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mokakalam Aba kari omare, abkoreb kaka uabi omare: kara omare ge niaiem tekue. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ese uaba kara gelar irmili, uaba ko niaiem tekue kara omare ge: mokakalam kaka Baba ra gelar irmili, epe kaka niaiem tekue abi omare ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kaka emetu uabim detaut abele gaire mer, ueakai kara sererge niaiem tekue uabi nerkep ge, ueakai uaba sererge kemerkemer. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kara gelar peik, kega, Uaba ko omare uabu, mokakalam kaka uabi omare. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ese nerute le abara eded ikuar taba boai bodomalam, nole nerute le la omare aule tumem ike. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ese uaba ikeli gaire lu kaka uabi mer tigri, uaba kara boai. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kaka nole iako uabi detager uaba memeg le giz; abelelam memeg le umer kak abele lu abara opole ikeli: kaka detaut uaba kara boai; abelelem gaire lu uridili kaka asoli kara Abalam, kaka uabi detomeret. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Uaba nole kari natarare, epe kaka uabi ditararda, a uabi depegereda, ueakai ua bakuare turum turum, a uaba turum niaiem tekue: ueakai Baba de ua dekuarare gaire lu uridili ua abi damsare kari neilam. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kaka abele uabi mer tigri, iauaekai ua ko uabu omare. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ege geseb ge uabi derar, uaba umele emetu kekiam kari derar, uaba keubu. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ese uaba geseplam, geseb ko lagelag abara boai: abelelam uaba nole geseplam, epe kaka uabi depegerare geseplam, abelelam geseb uabi derar. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dikiaporare kara mer kaka uabi detager, kega, Memeg le nole aule tumem abara opole. Ese uiaba emetu kari natkoli, uiaba ko uabi dedkoeda; ese uiaba emetu kara mer erpei, uiaba ko uaba mer erpei. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Abele gaire lu uridili uiaba uabim ikeli kara neilam, abelelam uiaba nole abi umer kak kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ese kaka nole tarabu ko uiabi daratagerare, uiaba nole uit kak: peirdi nole nerute lu ko uiaba uit batkamda. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Abele le kari naorar, E kara Abet naorarti. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ese kaka nole ikeli gaire lu uiaba opem, nole nerute le ikeli, uiaba nole uit kak: peirdi uiaba kari nasmer, a kari naorti, pako kara Aba ko. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Iaueakai bakedida abele mer detali uiaba gelar ge, kega, Uiaba no kari naorarti. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ese Upiatidar tabarki, kaka ko uabim emarida Abalam, pe ageakar Lamar, uatabu Abalam, E ko karim ageakar. ");
INSERT INTO ulk1902_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Uaba ko karim ageakar, abelelam uaba kari dog emri gizlam. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Kaka emetu uabi detager abele gaire lu, ueakai uaba nole mar bamarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Uiaba ko uabi dituaki sunagolam: kerker ko tabarki abele le uabi ipitare, E ko dikiapor E Ade ra dorge ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Uiaba ko ikeli abele gaire lu, abelelam uiaba nole umer kak Aba, a kaka. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kaka uabi detagereda abele gaire lu, ueakai kerker tabarki, uaba ko dikiaporauem kaka emetu uabi detaut. Kaka nole uabi detager abele gaire lu gizlam, abelelam kaka uabi dog emri. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Peirdi kai nabakeamulu abim kari namarida: nole nerute le uabielam kari eutumer, kega, Mai na gedim bakeam? ");
INSERT INTO ulk1902_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Uaba nerkep au okasosok, abelelam kaka uabi detager abele gaire mer. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ege kaka uabi detager ageakar, kega, Debele uabim kaka bakeam: abelelam ese kaka nole bakeam, Upiatidar nole tabarki uabim: ese kaka bakeam, kaka ko abi emarida uabim. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","E emetu tabarki, E ko geseb ge akmerem tonar uit, a barkak, a mer barditug: ");
INSERT INTO ulk1902_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Uitelam, abelelam uiaba nole karim oituli: ");
INSERT INTO ulk1902_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Barkaklam, abelelam kaka Babaim bakeam, uaba nole iako kari asmer kak: ");
INSERT INTO ulk1902_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mer bardituglam, abelelam emetu barditug geseb kole. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kara no nagri dordor lu ko uabi detager, epe peirdi uaba nole umer kak egaret. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mamoro E tabarki, pe ageakar Lamar, E ko uabi eguatumur ageakar uridili: abelelam E nole tababu detaut: mamoro E ko detager abele gaire lu E asoli: uabi detomeret gaire lu ko tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","E ko kari naospili: abelelam E ko tais karielam, a uabi detomertare. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Abele gaire lu Babi dog kara lu; abelelam kaka detaut, kega, E ko karielam tais, a uabi detomertare. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Menaba, uaba nole kari asmer kak: iako menaba, uaba ko kari nasmer, abelelam kai Abem nabakeamulu. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Uader abara kaimeg giz tababu mer atager, kega, Nalu E meribim detaut, kega, Menaba, uaba nole kari nasmer; iako menaba, uaba ko kari nasmer abelelem kai Abem nabakeamulu? ");
INSERT INTO ulk1902_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Uiaba detager, kega, Nalu E detaut, kega, Menaba? Meriba nole akmer kak abele mer E detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu umele uiaba laglag abim bautumer, E uiabim detaut, kega, Nako uaba uabu deraimerare kara merlam detaut, kega, Menaba, uaba nole kari nasmer, iako menaba, uaba ko kari nasmer? ");
INSERT INTO ulk1902_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ageakar, ageakar, kaka uabi detagereda, kega, Ua ko ebazoli, a okabatagereda, a geseb ko sererge: uaba ko okasosok, abele uaba okasosok ko depegili ko sererge. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kosker maike esmelu E beber nerkep, abelelam abara kerker tabarki; emetu uerem esmelu, E nole iako dikiapor abele asiasi, abelelam E sererge nerute le geseb ge esmelu. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Peirdi, uaba nagri okasosok: kai iako uabi dasmer, ege uaba nerkep sererge, nole nerute le uabi sererge itker. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Abele gerger dali uaba nole nerute lu damos karielam. Ageakar, ageakar, kaka uabi detager, kega, Abele gaire lu uaba damos Babalam muige kara nei ge, E ko uabi dekuarare. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Emeret a peirdi, uaba nole damos nerute lu muige kara nei ge: debele damsare, a uaba ko egaret, ueakai uaba sererge mitkar. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kaka emetu uabi detager abele gaire lu mer babisdarie: kerker ia uatabaruk, kaka nole uabi detager mer babisdarie, epe kaka ko uabim paret kak detaut Abem. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Abele gerger, uaba ko damos kara neilam: kaka nole uabi detager, kega, Kaka Abem damos uabim. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aba uabi omare, abelelam uaba kari lag, a egaret, kega, Kaka Babalam. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kaka nabue Babalam, a gesepem tabarki: kaka iako geseb dekaelu, a Abem bakeam. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Abara kaimeg giz abi detager, kega, Dasmer, peirdi, mama paret kak detaut, a nole mer babisdarie detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Peirdi, keriba umele mama opasereret gaire lu uridili, nole lu kar marim nerute le ko marim eutumer: abelelam keriba dikiapor mama tarabu Adelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu uiabi detaut, kega, Nako, peirdi, uaba dikiapor? ");
INSERT INTO ulk1902_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Dasmer, kerker ko tabarki, ia ike, uaba ko kepu bamarida boaiem, a kaka tepteb: nolea kaka tepteb, abelelam Aba kari dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kaka uabi detager abele gaire lu, ueakai uaba mapodan nagri karielam. Uaba asiasi nagri geseb ge: ua ko saserim, kaka emetu geseb degmori. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu abele gaire mer detaut; a E kotor dimirualu, a detaut, kega, Baba, kerker tabarki; mara Uerem despili, ueakai Uermet mari naospili. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mokakalam mama abi sirdam ikuar tumem gaire le uridili, ueakai E ko uiabi ikuar eded aseamur kak, gaire le mama abi ikuar. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Abele eded aseamur kak, kega, Uiaba ko mari nasmereda Ade kar netat, a Iesu Keriso mama namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kaka emetu mari naospili geseb ge, kaka emetu eseamuda abele dorge ma kari nakuar ko akere. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Baba, peirdi, kari naospili mara kemem zorom ge meribielam emeret ge, nole geseb kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kaka emetu mara nei etomeret uiabim gaire le mama kari nakuar geseplam: uiaba mara le, mama uiaba kari nakuar: uiaba emetu mara mer irmili. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Peirdi, uiaba umele marielam gaire lu uridili ma kari nakuar: ");
INSERT INTO ulk1902_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Abelelam kaka emetu uiabim ikuar gaire mer ma kari nakuar: uiaba emetu egaret, a uiaba umele marielam kaka nabue, a uiaba egaret, kega, Mama kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kaka uiabielam esorerapare: kaka nole esorerapare uiabielam gesepem, epe uiaba mama kari nakuar, abelelam uiaba mara le: ");
INSERT INTO ulk1902_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A gaire kara lu uridili mara lu, a gaire mara lu kara lu; kaka aule uiabielam. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Peirdi, kaka nole geseb ge emri, epe uiaba geseb ge emri, a kai marim nabakeamulu. Zogozogo Aba, uiabi asesered mara nei ge, abele uiaba ma kari nakuar, ueakai uiaba netat, meribi kaiser. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kaka mena uiabi dog geseb ge, kaka uiabi nasesered mara nei ge: kaka uiabi nasesered mama kari nakuar, nole nerute abi kak, eud uerem tepteb abi; ueakai bakedida abele zogo mer emetu detali. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Peirdi, kai marim nabakeamulu: kaka detaut abele mer abele geseb ge, ueakai kara sererge bakedida uiaba nerkep. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kaka emetu mara mer uiabim nakuarare; a geseb uiabi derarti, abelelam uiaba nole geseplam, mokakalam kaka nole geseplam. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kaka nole mari namos ko uiabi egaret geseplam, epe mamoro mama uiabi nasesered adudelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Uiaba nole geseb le, kara kaiser nole gesep le. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uiabim barkakem ikeli mara ageakar de; ageakar mara mer. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mokakalam mama kari gesepem namarida, mokakalam kaka uiabi gesepem namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kaka karababu ikuar uiabim, ueakai, uiaba barkakem ikeli ageakar de. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kaka nole esorerapare uiabim tepteb, epe uiabim ko kari oituli uiaba merlam: ");
INSERT INTO ulk1902_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ueakai ui uridili netat; mara kaiser Baba muige kara nerkep, a kaka muige mara nerkep ge, ueakai uiaba netat meribi koreb: ueakai geseb ko oituli ma kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Abele zoromzorom ma kari nakuar, kaka emetu uiabi nakuarare, ueakai uiaba netat, meribi koreb netat: ");
INSERT INTO ulk1902_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kaka muige uiabi nerkep ge, a mama muige kara nerkep ge, ueakai uiaba netat: ueakai gesep umele mama kari namarida, a uiabi omare, abkoreb mama kari omare. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baba, kaka lagelag uiaba mama kari nakuar ko kari kemem emri kara uteb ge; ueakai uiaba kara zorom dasmerare abele mama de kari nakuar; abelelam ma kari omare emeret, a nole geseb aker kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Geseb ge nole mari opasereret kak, Aba barkak: epe kaka mari opasereret, a uiaba umele mama kari namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kaka emetu mara nei uiabim etomeret; kaka iako etomeret; ueakai omare nagri uiaba nerkep, abkoreb mama kari omare, a kaka muige uiaba nerkep ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu emetu detaut abele gaire mer, E pako abara kaimeg giz bakeuare dodo datuparare, nei Kederon, E pako abara kaimeg giz abele gedubem tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iuda, abi keserkeser, umele abele uteb: abelelam Iesu gaire bakeam abele uteb, kemem abara kaimeg giz. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iuda taraisare gaire ares le, a gaire tarim le, uiabielam gaire zogo le, a gaire Faresaio, a kei tabarkare gaire lamepa kem, a gaire be kem, a gaire ares lu. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu umele gaire lu ko abim tabarki, E maiem bakeamulu, a uiabim detager, kega, Netede uaba deraimerare? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Uiaba abi detaut, kega, Iesu Nazaret le. Iesu uiabim detaut, kega, Kai nali. Iuda, abi keserkeser, uiabi kemem bako. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Emetu Iesu detager, kega, Kai nali, uiaba bazik bakeuare, a seb ge bakesmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","E iako uiabim eutumer, kega, Netede uaba deraimerare? Uiaba detaut, kega, Iesu Nazaret le. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu detaut, kega, Kaka emetu uabi detagereda, kega, Kai nali: ese uaba kari naraimeli, uiabi namarkare, ko bakeuare: ");
INSERT INTO ulk1902_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ueakai bakedida abara mer, kega, Nole nerute le abi uiabielam mama kari nakuar. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simona Peteru nagri tebur ausos tulik, E iselu, a etaueriklu tarim zogozogo le ra memeg le, a abara tuter laip dikiam. Nei abele memeg Maliko. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iesu Peteru detager, kega, Mabara tebur ausos tulik iako sorge dasiri: nako, kaka nole are kak abele tanelu Baba de kari nakuar? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kole ra ares le giz, a Iudaia tarim le, Iesu terpeirare, a abi didbarare. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kekiam uiaba abi tegaret Anaem; abelelam E Kaiafa ra naiuet, tarim zogo le abele urut ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Abele Kaiafa Iudaia giz daratagerare, kega, Debele netate le ko eumilu ab ged ra kes. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Peteru, a nerute kaimeg giz abi irmilei: tarim zogozogo le opasereret abele nerute kaimeg giz, E Iesu dog balu tarim zogo le ra meta ge; ");
INSERT INTO ulk1902_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peteru meta te ge tekueilu. Abele nerute kaimeg giz tarim zogo le opasereret, iako teosmelu, a neur te asesered detaut, a Peteru muige tegaredilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Neur te asesered Peteruim detager, kega, Nako, ma nole nerute abara kaimeg giz? E detaut, kega, Kaka nole. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gaire memeg le a gaire kole bako, a ur etoamerdare zirulam; a uiaba gebaugare: Peteru ui kemem, bako gebaugare. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tarim zogo le Iesu eutumer uiabielam abara kaimeg giz, pako ereuer tonar. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu abi detaut, kega, Kaka paret kak gesepem detaut; kaka sunago ge ereuerem, a zogo meta ge, Iudaia giz netate uteb ge; kaka nole nerute lu mude ge detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nalugem ma kari nautumer? uiabi nautumerare, gaire le kara mer aserare, kaka uiabi detagereda: dasmer, uiaba umele gaire mer kaka detaut. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","E emetu abele ge detaut, nerute tarim le abele tekueilu Iesu tagu detapi, a detager kega, Nako, ma detaut mokakalam zogo kemleem? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu abi detaut, kega, Ese kaka adud mer detaut, detomerti nalu adud: ese debe mer, nalugelam ma kari napit? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ana abi didbari a emarida Kaiafaem, zogo tarim le. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simona Peteru ekueilu ge bauger. Uiaba abi detager, kega, Nako, ma nole nerute abara kaimeg giz? E asared, a detaut, kega, Kaka nole. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nerute zogo tarim le la memeg le, boai abele le Peteru abara laip dismilu, detaut, kega, Nako, kaka nole mari nasmer abi dog gedub ge? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peteru iako asared: epe sobkak kimiar faul ereretikri. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Uiaba Iesu Kaiafaelam tagaret kot metaem, abele banege. Uiaba nole barot abele kot meta, ueakai uiaba nole uit kak, ko paseka eroli. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilato uiabim eosmeda, a detager, kega, Nako uaba mer ko aisare le idali? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Uiaba abi detaut, kega, Ese E nole adud ikeli, keriba nole abi emarik marim. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato uiabim detaut, kega, Uaba abi egardare, a abi eutumer abkoreb uaba gelar. Iudaia giz abi detaut, kega, Nole keribim abkoreb ko le ipit eumida: ");
INSERT INTO ulk1902_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ueakai Iesu ra mer bakedida, E emetu detager, a natomertare tonar eud E ko eumilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato iako balu kot metaem, a Iesu dabgeri, a abi detager, kega, Nako, ma Iudaia giz ra Opole? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu detaut, kega, Nako, mabu detager abele, ege nerute le mari natageri? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato detaut, kega, Nako, kaka Iudaia le? Mara ged, a zogo tarim le giz mari namarida karim: nalu ma ikeli? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu detaut, kega, Kara baselaia nole geseplam: ese kara baselaia geseplam, gaire kara kaimeg giz ko bares, ueakai nole kari emarik gaire Iudaiaem: peirdi, kara baselaia nole abele ge lam. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato abi detager, kega, Nako, ma opole? Iesu detaut, kega, Ma detager kaka opole. Abelelam kaka naosmeda, abelelam kaka gesepem tarabu, ueakai kaka ko ageakar ageakarem. Gaire le uridili ageakalam kara kodo mer asoli. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato de abi detaut, kega, Nalu ageakar? Emetu abele detager, E iako osmeda uiabim gaire Iudaia le, a uiabim detager, kega, Kaka nole uit ardar kak abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Epe uaba tonar ka ko uabim amariklu nerute le paseka kerker ge: nako, uaba lagelag ka ko uabim emarida Iudaia giz Opole? ");
INSERT INTO ulk1902_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Uiaba iako au ereretikri, a detager, kega, Nole E dali, debele Barabasa. Ege Barabasa nerute eruam le. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato Iesu tegaret, a abi damrik. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Gaire ares le zegerzeger aper euerare, a abi kerem ge ameare, a abi dameare mam mam am uali; ");
INSERT INTO ulk1902_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","A abim tabarki, a detaut, kega, Uaiai, Iudaia giz Opole! Uiaba abi detapiare. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato iako teosmelu, a uiabi detager, kega, Dasmer, kaka abi tegaret uabim, ueakai uaba dasmer kaka nole nerute uit ardar kak abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iesu teosmeda, zegerzeger aper dameare, a mam mam am uali dameare. Pilato uiabi detager, kega, Le das! ");
INSERT INTO ulk1902_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gaire zogo tarim le, a gaire asesered le abi dasmer, uiaba elele ereretikri, kega, Satauroem, satauroem. Pilato uiabim detaut, kega, Ua abi egardare, a satauroem: abelelam kaka nole nerute uit ardar kak abi dog. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Gaire Iudaia le abi detaut, kega, Keriba gelar nagri, abkoreb abele gelar E ko eumida, abelelam tababu akailu Ade ra Uerem. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato abele mer asoli, E au geum; ");
INSERT INTO ulk1902_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","E iako kot meta balu, a Iesuim eutumer, kega, Ma na gedelam? Iesu nole abim etkalu. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato abi detager, kega, Nako, ma nole karim natkarti? ma nole umele kara nagri adigir ko mari satauroem, a kara nagri adigir ko mari emariklu? ");
INSERT INTO ulk1902_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu detaut, kega, Ese nole mari nakuar kotorlam, Ma nole adigir nagri kari tumge: abelelam au uit abele le kari nakuar marim. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Abele ge lam Pilato deraimer ko abi emariklu: Iudaia giz elele ereretikri, kega, Ese ma abele le emarida, ma nole Kaisara ra boai: abele le tababu akailu opole, E Kaisara ra keubu le. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato abele mer asoli, E Iesu adige tegaret, a kot bau ge emerilu, nei atker, Baker esegemelu, a Heberu kodo mer, Gabatha. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kerker ge Paseka derser: mokakalam eipu gerger. E Iudaia giz detager, kega, Dasmer, uaba Opole! ");
INSERT INTO ulk1902_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Uiaba elele ereretikri, kega, Egardare, egardare, abi satauroem. Pilato uiabi detager, kega, Nako, kaka uaba Opole satauroem? Gaire zogo tarim le etkalu, kega, Keriba nole opole kak, Kaisara tepteb. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","E abi emarik uiabim, ko satauroem. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Uiaba Iesu egardare: E osmeda tabara satauro tababu kodorom, a utebem bakeam, nei atker, Kerem lid ra uteb, Heberu nei, Gologotha: ");
INSERT INTO ulk1902_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Abele uteb ge, uiaba abi satauroem, neisi le abi kemem, nerute apek, a nerute apek, a Iesu eipu. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato atamelam jauali detali, a tumem satauro dikmerik. Abele detali kega, IESU NAZARETA LE, IUDAIA LE GIZ RA OPOLE. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Dordor Iudaia giz abele jauali detagerare: abelelam maike au uteb abele uteb uiaba Iesu satauroem: emetu detali Heberu, a Helene, a Roma ra kodo mer. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Iudaia zogo tarim le Pilatoim detaut, kega, Nole autar kak, Iudaia giz Opole; epe tababu detager, kega, Kaka Iudaia giz Opole. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato detaut, kega, Abele kaka detali, kaka detali. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Gaire ares le emetu Iesu satauroem, uiaba abara am uali ekadarare, a foa derapeir, abkoreb uiaba ares le; am uali kot ko: abele am uali kot nole adket kak, kemer kemer euer. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Uiaba mer atagere, kega, Meriba nole aspas kak, a debele lugulug deraimer niti ra lu: ueakai jauali bakedida, kega, Uiaba kara am uali derapeiare, a kara am uali kot lugulug ikeli. Abele gaire lu ares le giz ikeli. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesu ra satauro dege abara apu ekueilu, pako abara apu ra keimer, Maria, Kelopa ra kosker, a Maria Magadalena. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesu abara apu dasmer, pako abele kaimeg E nasge, maike tekueilu, E abara apu detager, kega, Kosker, dasmer mara uerem! ");
INSERT INTO ulk1902_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","E ko detager abele kaimeg, Dasmer mara apu! Abele kaimeg abi tegaredelu abara uteb abele haua ge. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Abele iobaru, Iesu umele, kega, Gaire lu uridili eseemuda. Ueakai jauali bakedida, E detager, kega, Kaka ni ap. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Abele ge nerute tanelu, mitkar uinega: uiaba sab akmei uinega de, a hisop paikai ge dikmeriklu, a abara te ge agisilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Emetu Iesu uinega erpeilu, E detager, kega, Eseemuda: E abara kerem esorgiru, a lamar emariklu. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iudaia giz Pilatoim bareda ko uiaba teter erapei, a uiaba egardare, ueakai uiaba gem nole emerered sabath ge, (abelelam gerger derser, au gerger abele sabath.) ");
INSERT INTO ulk1902_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Uiaba gaire ares le tabakeuare, a kekiam le ra teter erapei, a nerute abi kemem satauro: ");
INSERT INTO ulk1902_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Epe uiaba Iesuim tabarki, a dasmer E eumida, uiaba nole abara teter arapeir kak: ");
INSERT INTO ulk1902_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Epe nerute uiaba gaire ares le abi ber ge dabu ekos, a sobkak mam a ni babuser. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Le ardali ageakarem, abara mer ageakar: E umele, ageakar E detaut, ueakai uaba oituli. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Emetu ikeli abele gaire lu, ueakai bakedida abele mer detali, kega, Nole arapeir kak nerute abara lid. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nerute mer emetu detali, kega, Uiaba ko abi dasmer uiaba dab akoselam. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Abele iobaru, Iosefa Arimathea le, nerute Iesu ra kaimeg, E gumik abelelam E Iudaia giz geum, a Pilatoi damos ko Iesu ra gem tegaret: ege Pilato emarik. E tabakeam, a Iesu ra gem egaret. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo ko tabakeam, abele le ki ge Iesuim bakeam, E muro tais a alo atapetem, mokakalam uan handed paun beber. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Uiaba Iesu ra gem egardare a uali lino de sopem, kemem gaire debe lagelag lu, mokakalam Iudaia giz ra tonar etkobei. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Abele gedub ge, uteb uiaba Iesu satauroem, nagri kerkar ao, nole eud le akedir kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Uiaba Iesu abele ge ikedilu, abelelam gerger ge derser uiaba Iudaia le, (epe ao maike.) ");
INSERT INTO ulk1902_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kekiam gerger sefen, Maria Magadalena tabakeam, bane ge, aoem, a baker dasmer, emetu adem aolam. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","E koreder emerilu, a Simona Peteruim tabarki, pako nerute memeg le Iesu nasge, a uiabi daratager, kega, Uiaba emetu Opole egaret aolam, keriba umer kak nade uiaba abi ikedi. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peteru, pako abele nerute kaimeg osmelei, a bakeamulei aoem. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ui koreder emerilei: nerute kaimeg Peteru esaimeda, a ao ge kekiam tabarki; ");
INSERT INTO ulk1902_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","E diketilu, a uali dasmer ipe; E nole bao. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simona Peteru ko tabarki, abi irmili, a ao ge balu; a uali lino dasmer ipe, ");
INSERT INTO ulk1902_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pako mog uali abara kerem sopem, nole netate ipe kemem uali lino, tepteb ipe nerute uteb nole atarat kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nerute kaimeg balu ko, abele le kekiam aoem tabarki, E ko dasmer, a oituli. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Uiaba nole akmer kak abele mer detali, kega, Abkoreb abim iako eded akaida eudelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Neisi kaimeg iako tabara uteb bakeamudariei. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria tekue adige ao ge ezoli: E tegreamalu a ezoli, a dasmer muige abele ao ge; ");
INSERT INTO ulk1902_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","E neisi angela darasmer, zazer uali darame eder emrilei, nerute kerem ge, a nerute teter ge, abele uteb Iesu ra gem ikedilu. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Uiaba abi detager, kega, Kosker, nalugem mama ezoli? E uiabim detaut, kega, Abelelam uiaba kara Opole egareda, kaka umer kak abele uteb uiaba abi ikedarare. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Emetu abele detager, E egreamalu, a Iesu dasmer tekue, E nole umer kak Iesu pedali. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu abi detaut, kega, Kosker, nalugem ma ezoli? ma niti deraimeri? E dikiapor E gedub paret arup le, E abi detaut, kega, Kole, ese mama abi egaret, kari natager abele uteb mama abi ikedi, ueakai kaka ko abi agaretelu. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu abi detager, kega, Maria. E tegreamalu a abi detager, kega, Raboni: tonar, Ereue le. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu abi detaut, kega, Nole kari atutir kak; abelelam kaka nole karba Babim ogi: bakeamulu uiabim kara keimer giz, a uiabi daratagerare, kega, Kaka Abem pako uaba Aba ogi, kara Ade a uaba Ade. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magadalena kei bakeamulu, a kaimeg giz daratagerare, kega, Kaka emetu Opole dasmer; pako tonar E emetu detager abele abim. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ki ge abele gerger, kekiam gaire sefen, emetu demare gaire te abele uteb uiaba netate gedim, abelelam uiaba Iudaia le geum ge, Iesu tabakeamulu a eipu ekueilu, a uiabi detager, kega, Mapodan uabim. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Emetu abele detager, E abara neisi tag a abara ber uiabi natomelu. Abara kaimeg giz sererge Opole dasmer. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iesu iako uiabi detager, kega, Mapodon uabim: kaka uabi namarida mokakalam Baba kare namarida. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","E emetu abele detager, E uiabim nerezi, a detager, kega, Lamar Zogo egaret: ");
INSERT INTO ulk1902_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Abele gaire le la uit uaba ko emarik, abele ko uiabim emarik: abele uaba dekaer, abele ko dekaer. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma, nerute tuelf lelam, nei atker Didumo, nole uiabi dog kerker Iesu tabarki. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kaimeg giz abi detager, kega, Keriba emetu Opole dasmer. E uiabim detaut, kega, Ese kaka nole dasmer sok tulik ziz abara neisi tag, a kara baur kei sok tulik ziz ge aziriklu, a kara tag abara ber ge aziriklu, kaka nole uatur kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Gaire gerger eit iobaru, abara kaimeg giz muige meta, a Toma uiabim kemem. Gaire te emetu demare, Iesu batimedilu, a uiabim eipu ekueilu, a detager, kega, Mapodan uabim. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","E Toma detager, kega, Mabara baur kei tekau, a dasmer kara neisi tag; a mabara tag tekau, a kara ber ge aziriklu: ma nole uatur kak, debele oituli. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma abi detaut, kega, Kara Opole, a kara Ade. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesu abi detaut, kega, Toma ma oituli abelelam ma kari dasmer: uiaba uerkab le gaire le oituli, a nole asmer kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Dordor atamelam Iesu ikelare opem abara kaimeg giz, a nole detali abele jauali ge: ");
INSERT INTO ulk1902_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Emetu abele gaire lu detali ueakai uaba dikiaporauem, kega, Iesu Keriso kar, Ade ra Uerem: ueakai uaba onatereda, uaba ko eded nagri abi neilam. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Abele lu iobaru, Iesu iako tababu natomertare uiabim kaimeg giz, Tiberia keper ge; abele tonar tabara natomertare. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Netate gedim Simona Peteru, a Toma, nei atker Didumo, a Nathaniela, Kana Galilaia le, a neisi Zebedaio ra uerem, a neisi abara kaimeg giz. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simona Peteru uiabi detager, kega, Kai nabakeamulu net asaperem. Uiaba abi detaut, kega, Ki ko nabakeuare mari kemem. Uiaba bakeuare, a nar ge ekauererti; abele ki ge, uiaba nole lar kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ege idim ge, Iesu tauer ge tekueilu: kaimeg giz nole umer kak Iesu dali. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iesu uiabi detager, Kega, Omasker, nako, uaba leuer nagri? Uiaba abi detaut, kega, Nolea. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","E uiabim detager, kega, Net dikri nar tuter peik, a uaba ko dasmer. Uiaba dikri, epe uiaba umer kak net eguatumur, abelelam lar dordor. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Abele kaimeg Iesu nasge Peteru detager, kega, Opole pedali. Simona Peteru asoli, kega, Opole pedali, E tabara uali kot ame (abelelam E no gem), E gurim eupamalu. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kaier kaimeg giz tabakeuare kebi nar tumge (abelelam uiaba nole muriz geseplam, mokakalam fifte eit fathom), net eguatumur gaire lar kem. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Uiaba gesepem tabarki, uiaba ur dasmer, a lar tumge, pako leuer. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu uiabi detager, kega, Uader lar kei tais uaba asaperem peirdi. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simona Peteru ekauerelu, a net gesepem eguatumulu, mitkar au larlam, uan handed a fifte thri: a net nole atoat kak au larlam. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu uiabi detager, kega, Tabakeuare, leuer aroare. Nole nerute uiabielam kaimeg giz saserimem abim eutumer, kega, Ma nete? abelelam uiaba umele Opole dali. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu tabakeamulu leuer ais, a uiabi ikuar pako lar kem. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Abele thri Iesu tababu natomertare uiabim kaimeg giz, keubu E eded akaida eudelam. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Uiaba emetu eroare, Iesu Simona Peteru detager, kega, Simona, Iona ra uerem, ma kari lag uiabi tumge? E abi detager, kega, Eko, Opole; ma umele kaka mari lag. E abi detager, kega, Kara kebi mamoe giz darasisiare. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","E iako neisi abi detager, kega, Simona, Iona ra uerem, ma kari lag? E abi detager, kega, Eko, Opole; ma umele kaka mari lag. E abi detager, kega, Kara mamoe giz darasisiare. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","E iako thri abi detager, kega, Simona, Iona ra uerem, ma kari lag? Peteru okabatageli abelelam E thri abi detager, kega, Ma kari lag? E abi detaut, kega, Opole ma umele gaire lu uridili; a ma umele kaka mari lag. Iesu abi detager, kega, Kara mamoe giz darasisiare. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ageakar, ageakar, kaka mari natager, kega, Ma makeriam emeret mabu eso, ma bakeam mabara lag: ma aule mabara tag nagisi, a nerute ko mari uanaso, a mari uanagared abele ma nole la kak. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E abele detager, abara tonar eud etomet Ade despili. E emetu abele detager, E ko abi detager, kega, Kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peteru egreamalu, a dasmer abele kaimeg Iesu nasge, E irmili ko; E dali Iesu ra marmot ge uteidilu ki ge eroare, a detager, kega, Opole, nete ko mari keserkeser? ");
INSERT INTO ulk1902_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peteru abi dasmer, a Iesui detager, kega, Opole, E dali nako? ");
INSERT INTO ulk1902_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu abi detager, kega, Ese kaka lagelag E kari naokaili, nako abele marim? ma kari narmili. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Abele mer ekoseli uiabim keimer giz, kega, Abele kaimeg le nole eud kak: Iesu nole abi detager, kega, Ma nole eud kak, epe, Ese kaka lagelag E kari naokaili, nako abele marim? ");
INSERT INTO ulk1902_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Abele kaimeg le E ageakarem abele gaire lu, a abele gaire lu detali: a meriba umele ageakar abara ageakar. ");
INSERT INTO ulk1902_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Dordor gaire uader lu Iesu de ikerare, ese detali uridili, kaka dikiapor nole abkoreb gesepem gaire jauali. Amen. Richard Clay & Sons, Limited, London & Bungay ");
ALTER TABLE ulk1902_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
