﻿USE sofia;
DROP TABLE IF EXISTS sofia.uli_vpl;
CREATE TABLE uli_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uli_vpl WRITE;
INSERT INTO uli_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iye mele babiorol rechokwe re hamodoh mo imol Jesus Kristus le daowe yael David, ngo David ila ye budoh mo irel daowe yael Abraham. ");
INSERT INTO uli_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6","Ye chap mo irel Abraham sa budoh irel King David, le iye mele babioror daokala: Abraham ila temal Isaac, ngo Isaac ila temal Jacob, ngo Jacob ila temal Judah mo mekla wol bisil; iwe ngo Judah ila temal Perez mo Zerah (ngo seler ila Tamar), Perez ila temal Hezron ngo Hezron ila temal Ram, ngo Ram ila temal Amminadab, ngo Amminadab ila temal Nahshon, ngo Nahshon ila temal Salmon, ngo Salmon ila temal Boaz (ngo sil ila Rahab), ngo Boaz ila temal Obed (ngo Ruth mele sil), ngo Obed ila temal Jesse, ngo Jesse ila temal King David. ");
INSERT INTO uli_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Ye chap irel molwe wol mol David yee, la hola yodwe re hachuyar yarmetal Israel mo wol Babylon. Iwe ngo David ila temal Solomon (mala sil ila molwe ril Uriah), Solomon ila temal Rehoboam, ngo Rehoboam ila tamal Abijah; ngo Abijah ila tamal Asa; ngo Asa ila temal Jehoshaphat, ngo Jehoshaphat ila temal Jehoram, ngo Jehoram ila temal Uzziah, ngo Uzziah ila temal Jotham, ngo Jotham ila temal Ahaz, ngo Ahaz ila temal Hezekiah, ngo Hezekiah ila temal Manasseh, ngo Manasseh ila temal Amon, ngo Amon ila temal Josiah mo Jehoiachin mo mekla wol bisil. ");
INSERT INTO uli_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Irel yodwe re hachuya yarmetal Israel mo wol Babylon yee, la hola yodwe bungul yal subdoh Jesus, ngo Jehoiachin ila temal Shealtiel, ngo Shealtiel ila temal Zerubbabel, ngo Zerubbabel ila temal Abiud, ngo Abiud ila temal Eliakim, ngo Eliakim ila temal Azor, ngo Azor ila temal Zadok, ngo Zadok ila temal Achim, ngo Achim ila temal Eliud, ngo Eliud ila temal Eleazar, ngo Eleazar ila temal Matthan, ngo Matthan ila temal Jacob, ngo Jacob ila temal Joseph, ngo Joseph ila ril Maria. Iwe ngo Maria ila sil Jesus we rema ffesangu ngali bo Kristus. ");
INSERT INTO uli_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Seg mo faw dalel yarmat le ye chap mo irel Abraham yee, la hola David, ngo wol seg mo faw dalel yarmat mo irel David yee, la hola yodwe re hachuchuyar loh yarmat wol Babylon, ngo wol seg mo faw dalel yarmat mo irel yodle ngal yodwe ye subdoh Kristus iyang. ");
INSERT INTO uli_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iye sengal wululul yal subdoh Jesus Kristus. Maria we sil ila re kapta bo rebe paoy fengal mo Joseph, ngo imol yodwe rebe paoy sew ngo Maria sala gola le yesa siyal irel mala kkamelal Espritu Santus. ");
INSERT INTO uli_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph ila semal mal le pangal yad ngo ye hafle pangal formel. Iwe ngo yete dipli bo yebe hatayikofa depel Maria luwul yarmat. Iwe yesa luwaley le re bele mehal le tor le be gola. ");
INSERT INTO uli_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yodwe chil luluwaley fedaley kofal molwe ngo semal angelusel Samol sa llah ngali luwul yal ddal sa kangalu bo “Joseph, le chol daowe yael David, ho towe motog le hobe hasi Maria bo yam habulupoy. Bo mala kkamelal Espritu Santus mele sa siyal Maria iyang. ");
INSERT INTO uli_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ye bele dimolowagili semal yalwich tarmal ngo hosa hadeda bo Jesus, bo fal mala be hadorar yarmat mo irel mekla molfidir.” ");
INSERT INTO uli_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pangal meka ngo ye weldoh bo fael mala be llah loh meka yalol Samol le katos mo irel profeta kowe we re sor bo, ");
INSERT INTO uli_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Fefel we ye birgo ila bele siyal le yebe dimolowagili semal yalwich mal le rebe ffesangu ngali bo Immanuel” (fal yidle ila, “Deus ye mel irech”). ");
INSERT INTO uli_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yela mmat Joseph ngo ye sala foru mokwe angelusel Samol ye kangalu, yesa loh ye sala paoy ngal Maria. ");
INSERT INTO uli_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Iwe ngo tor fael sew le re masor sew yee, yela dimolowagili yalwich mal we lol. Iwe ngo Joseph sa hadeda bo Jesus. ");
INSERT INTO uli_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus ye sub mo Bethlehem wol Judea, irel yodla ngo Yerodes mele king. Te ssulay mo wol miril yal subdoh yalwich we ngo tot mal le re gola kofal fis resa bidiy mo meteral rebe loh Jerusalem. ");
INSERT INTO uli_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Resa budoh kasiy, “Ifa iy yalwich we sa subdoh le be mel bo yar Jews king? Hasa wiri fis la hawrel le ye bidah mo meteral, iwe hasa budoh bo habe hasrowu.” ");
INSERT INTO uli_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yodwe King Yerodes yela rongrong molwe ngo tayfel loh lal depal, ngo wol ila sengal yarmat wol pangaloh Jerusalem. ");
INSERT INTO uli_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yesa hateyli fengalir panger tamol temarong mo sensel Hatobtob we yesa kasiyar le ye sor bo, “Iya lobosle Kristus be subdoh mo iyang?” ");
INSERT INTO uli_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iwe ngo resa hatefali le re sor bo, “Irel haplom we Bethlehem we ye mel wol Judea, bo ika meka profeta we re tefa lal babior: ");
INSERT INTO uli_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Gel haplom la Bethlehem le ho mel wol Judea, te gel mele ho hartal totol mo irel mekla haplomol tamol wol Judea; bele budoh semal mo irem le iy mele be lamalir ngo ye kekadarlahor yarmetal Israel ka layi.’” ");
INSERT INTO uli_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Iwe ngo Yerodes sa ffesangur rechokwe re bidiy mo meteral bo rebe ttey le tor le be gola. Yerodes sala gola mo irer yodle ye llah fis we iyang. ");
INSERT INTO uli_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iwe yesa fangloh ir Bethlehem le ye kangalur bo: “Ha loh ha bela meri hamayu yalwich la, ngo ha bela wiri chog ngo hasa budoh kangaluyey, bo ngang ibe wol loh ibela hasrowu.” ");
INSERT INTO uli_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Yodwe resa chuy le resa loloh ngo resa wol wiri fis we resa moal wiri mo meteral. Yodwe rela wiri ngo resa rraey ngo ye cchehas lal deper! Yesa hamo fis we mo imor yee, la ppoloh mo wol lobos we ye mel yalwich we iyang. ");
INSERT INTO uli_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Rela bulong lal imw we re sala wiri yalwich we mo Maria we sil, resa hasubgudiy resa hasrowu yalwich we. Resa fang yar presen le hoal, frankincense, mo myrrh. ");
INSERT INTO uli_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Iwe resa tefael ngal bugter le resa dabey sera yalap bo Deus sa hagolal ngalir luwul yar ddal le re towol tefael loh irel Yerodes. ");
INSERT INTO uli_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wol miril molwe resa loh ngo semal angelusel Samol sa llah ngal Joseph luwul yal ddal le ye kangalu bo, “Yerodes ila sa memeri fedaley yalwich la bo yebe limeseloh. Ila chemdah hobe hasi yalwich la mo mala sil hasa kewag loh woal Egypt ha sala paoy iyang. Ibe yigil sor bo habe tefael ngo hasa moch tefael.” ");
INSERT INTO uli_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph sa chemdah chog sa hasi yalwich we mo molwe sil resa chuy chog bongol we resa loh woal Egypt, ");
INSERT INTO uli_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ila lobosle rela mel iyang yee, la yigil mes Yerodes. Re foru mele bo bela llahloh le katos mokwe yalol Samol le profeta we ye sor bo, “Isa ffesanguwey mala layi mo woal Egypt.” ");
INSERT INTO uli_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yodwe Yerodes yela gola le rechokwe re bidiy mo meteral resa hachepra ngo sa kkel yal song. Yesa fang yalol bo rebe limeserloh panger yalwich tarmal mo woal Bethlehem mo loboka ye harpa Bethlehem, le yalwich mal ka moch ruwow lepal ragir sa bidiy wototol — le sala chichiy ngal yodwe rechokwe re bidiy mo meteral re kangalu irel kofal fis we ye llahdoh. ");
INSERT INTO uli_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iwe ye sala llahloh le mokwe profeta Jeremiah ye sor ila katos: ");
INSERT INTO uli_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Resa rongrong yalol sew formel mo wol Ramah, yalol yael yarmat tetang le ye bbareg lal deper. Rachel ila ye tetangdi yalwich kala lol; tay mechal bo rebe hafel lal depal, bo panger ngo resa rol mes.” ");
INSERT INTO uli_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wol miril yal mes Yerodes ngo semal angelusel Samol sa llah ngal Joseph luwul yal ddal mo woal Egypt ngo sa kangalu bo, ");
INSERT INTO uli_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Chemdah, hasi yalwich la mo mala sil hasa tefael ngal Israel, bo rechokwe re luluwaley bo rebe lliy yalwich la ila resa rol mes.” ");
INSERT INTO uli_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iwe Joseph sa chemdah sa hasi yalwich we mo molwe sil resa tefael ngal Israel. ");
INSERT INTO uli_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Iwe ngo yodwe Joseph yela rongrong le Archelaus sa liwli Yerodes we temal, le sa mel bo tamol woal Judea ngo sa motog le be loh loboswe. Sa cholop mekla resa kangalu mo irel yal dal le be foru. Iwe sa loh irel mokwe faluyel Galilee. ");
INSERT INTO uli_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ye sala hasu imwla imwal woal sew haplom le rema sor bo Nazareth. Iwe mokwe profeta kowe re sor irel kofal yalwich we ila sala llah le katos: “Re bele ffesangu ngali le iy semal re Nazareth.” ");
INSERT INTO uli_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Irel yodla ngo Johannes Baptista yesa budoh solbos le ye tolmay loh mo woal Judea sa chapiy yal foloy. ");
INSERT INTO uli_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ye sor bo, “Ha tagul tang molfidmi, bo mala Lamliyel Laeng ila sa harep!” ");
INSERT INTO uli_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Johannes molwe profeta Isaiah ye kekapta kofal irel yodwe ye sor bo, “Ye tetawul semal mo lobosla ye tolmay loh le ye sor bo, ‘Ha hafle sew yalap bo yalepal Samol; ha hawwele mala yalepal!’” ");
INSERT INTO uli_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mekla mengagul Johannes ila ye ffaor mo irel yulol kameng ngo ye tertar gil karbow ngo mekla ma mongoy ila malhawael me honey. ");
INSERT INTO uli_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yarmat resa budoh irel, le re budoh mo Jerusalem mo mekla faluyel Judea mo pangal fulu kala ye harpa mololul we Jordan. ");
INSERT INTO uli_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Resa budoh sor mekla molfidir ngo re baptismus mo irel Johannes mo lal mololul we Jordan. ");
INSERT INTO uli_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yodwe Johannes yela wiri we sa cholop Pharisees mo Sadducees le resa budoh irel bo rebe baptismus ngo sa kangalur bo, “Hami parchoyoh kala, itey le ye kangalugmi le be yoh le habe kewag tang hagerger la Deus be fang? ");
INSERT INTO uli_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ha foru tot formel le be kaweraloh le hasa tagul tang mekla molfidmi. ");
INSERT INTO uli_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ha towe luluwaley le be yoh le habe kewag tang hagerger la igle habe sor bo Abraham ila chapdohmi. Iy be kangalugmi le Deus ila be yoh le yebe hasi feas ka sa foru bo yarmetal daola yael Abraham! ");
INSERT INTO uli_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sew tomiyom ila sa fel le yebe supiloh mo wol bol pangal ire kala tor uwal bo be pepedah wulyef. ");
INSERT INTO uli_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngang iy baptismusgilugmi ngal chael yebe kaweraloh le sa rrig lal dipmi irel molfidmi, iwe ngo yeramtala bela budoh mo wol miriy ila be baptismusgilugmi irel Espritu Santus mo yaef. Iwe ngo iy ila ye tagiyet mo imoy; Ngang ila iy totol bo bwela kala yal mwo ngo ye tafel le iy be hasi. ");
INSERT INTO uli_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yesa fel lital yengang kala yal le yema hayagi uwal milay la yal iyang. Yesa hasi ikla ye moway sa yetolong yilim, ngo ye hasi ikla tayikof sa fisgi wol yaef la tema gul.” ");
INSERT INTO uli_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Irel yodla ngo Jesus sa chuy mo Galilee sa budoh irel Johannes irel mololul we Jordan bo Johannes yebe baptismusgili. ");
INSERT INTO uli_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Iwe ngo Johannes ye luwaley bo be liwel yael Jesus luluwal. Johannes sa kangalu bo, “Ngang mele ibe baptismus mo irem, ngo gel ho sala budoh irey!” ");
INSERT INTO uli_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iwe ngo Jesus sa hatefali ngo sa sor bo, “Si bele foru mwo iye igla. Sibe foru le be iye sengal ila ngo siya foru pangal mekla Deus ye dipli.” Iwe Johannes sa moch dipli. ");
INSERT INTO uli_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yodwe chog Jesus ye baptismus, ngo yesa bidah mo lal mololul we. Iwe ngo laeng sa sugeg ngali, ngo sala wiri Espritu Santus we yael Deus le sa bidiy le ye wochog semal dove. ");
INSERT INTO uli_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iwe ngo resa rongrong mele le ye bidiy mo wol laeng, “Iye mele layi, le iy hartal hachangi.” ");
INSERT INTO uli_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iwe ngo Espritu Santus sa hakela depel Jesus sa paliloh irel loboswe ye tolmay loh bo fal mala be budoh Moniyan be hagela hare be weg depal. ");
INSERT INTO uli_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wol miril yal melegili fayeg ral mo fayeg bong le tor mele ye mongoy ngo sa kkel yal koloh. ");
INSERT INTO uli_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iwe ngo Moniyan we sa budoh irel Jesus sa kangalu bo, “Hare gel Lol Deus ngo hosa kangalu faeska bo be mel bo flowa.” ");
INSERT INTO uli_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iwe ngo Jesus sa sor bo, “Babior we ye santus ye sor, ‘Yarmat ila te flowa chog mele rebe molow iyang, bo mekla yalol Deus mele rebe molow iyang.’” ");
INSERT INTO uli_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iwe ngo Moniyan we sa hasiloh Jesus wol Jerusalem irel Haplom we ye Santus, ye sala yitli lobowe ye hartal tagiyet mo wol Templum we. ");
INSERT INTO uli_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Iwe ngo yesa kangalu bo, “Hare gel Lol Deus ngo hosa llutdiy, bo babior we ye santus ye sor bo, ‘Deus be kangalur angelus kowe lol mele rebe faor ngalug; rebe holugdah lal mekla payur, bo ila ngo ye towe bbareg fael pechem irel feas.’” ");
INSERT INTO uli_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iwe ngo Jesus sa sor bo, “Babior we ye santus ye wol sor bo, ‘Ho towe tapeli Samol la yami Deus hagelgel.’” ");
INSERT INTO uli_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iwe ngo Moniyan we sa hasidah Jesus wol sew tayit le ye tagiyet sala kkewar ngali pangal meka faluyel faileng le mo lepal mala momayel. ");
INSERT INTO uli_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Iwe Moniyan we sa kangalu bo, “Pangal meka ngo iy be ngaloh igle hobe hasubgudiy ngo hosa hasrowuyey.” ");
INSERT INTO uli_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iwe Jesus sa sor bo, “Chuy mo igla ho, Satan! Babior we ye santus ye sor bo, ‘Deus chog mele habe hasrowu ngo ha tagul ngali, ngo tor semal mo solbos!’” ");
INSERT INTO uli_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iwe ngo Moniyan we sa chutang Jesus ngo angelus resa budoh resa tipingi Jesus. ");
INSERT INTO uli_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yodwe Jesus yela rongrong bo resa yetolong Johannes lal kalbus, ngo ye sa loh wol Galilee. ");
INSERT INTO uli_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yete mel woal Nazareth bo ye loh sala mel mo wol Capernaum, sew haplom lengchel Laom we Galilee. ");
INSERT INTO uli_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iye sengal mele bo fael mala bela llah le katos mokwe profeta Isaiah ye sor, ");
INSERT INTO uli_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mekla faluyel Zebulun mo mekla faluyel Naphtali, woal yalap we ye loh leted, rel Jordan rela sere, Galilee, faluyer Gentiles! ");
INSERT INTO uli_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Rechokla re mel luwul ruchupung ila re bele wiri sew teram le ye palleng. Iwe ngo rechokla re mel luwul ruchupung lobola liliyer chomes ila bele werdiy sew teram uwor.” ");
INSERT INTO uli_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ila yodla ye chap yael Jesus foloy le ye sor bo, “Ha tagul tang molfidmi bo mala Lamliyel Laeng ila sa harep!” ");
INSERT INTO uli_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yodwe Jesus ye dedarloh woal ngachel Laom we Galilee ngo sala wiri rumal bisbis le chol fita, Simon (we rema ffesangu bo Pedrus) mo Andrew we bisil le re fefita irel wug we yar. ");
INSERT INTO uli_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iwe Jesus sa kangalur bo, “Ha dabeyey, bo ibe haskuna ngalugmi fitel yarmat.” ");
INSERT INTO uli_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yodwe chog ngo resa tahcheloh wug kowe yar resa dabey. ");
INSERT INTO uli_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ye loh sala wol wiri rumal bisbis, James mo John le lol Zebedee. Re mel irel Zebedee we temer yuchul boat la war le re fofaor fadaley wug kowe yar. Jesus sa ffesangur, ");
INSERT INTO uli_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ngo yodwe chog ngo resa ligdi boat we mo molwe temer ngo resa dabey. ");
INSERT INTO uli_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus ye balsagililoh pangal Galilee, le ye fofoloy lal imwel ttey kowe, le kofal Hapatpat Momay we kofal mala Lamliyel Laeng, ngo ye hachuya metmetal tomay mo uwol yarmat. ");
INSERT INTO uli_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesa pallengloh molwe kaptal wol pangal mokwe faluyel Syria, iwe yarmat resa hasirdoh irel, panger rechokla re tomay le ikla resa hafohoy irel semat mo samat tomay, mo rechoka yor moniyan uwor, mo rechokla rema piyom, mo rechoka resa mehatugut, ngo panger ngo Jesus ye hachuya yar tomay. ");
INSERT INTO uli_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Feraketaw yarmat le re dabey le re budoh mo woal Galilee mo woal haplom we Decapolis, mo Jerusalem, mo Judea, mo fulu kala tot real mololul we Jordan rela sere. ");
INSERT INTO uli_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus yela wiri buwa we, iwe ngo sa bidah wol sew tayit sala marodiy mo iyang. Iwe ngo mokwe re dabeyal resa tteydoh irel, ");
INSERT INTO uli_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ngo sa chaep yal foloyur: ");
INSERT INTO uli_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Be momay lal deper rechokla re gola le ye tayikel yar tugul; bo mala Lamliyel Laeng ila sa mel bo yar! ");
INSERT INTO uli_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Be momay lal deper rechokla sa tayikof lal deper igla; bo Deus bele hamomayu lal deper! ");
INSERT INTO uli_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Be momay lal deper rechokla ye totol lal yar luluwal; bo be yoh ngalir molwe Deus sa faesul hatugulu! ");
INSERT INTO uli_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Be momay lal deper rechokla ye cchehas lal deper bo rebe foru mekla ye fel mo irel Deus; bo re bele mel le ye kel lal deper bo re gola le Deus ye mel irer! ");
INSERT INTO uli_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Be momay lal deper rechoka ye ffaho deper ngalir yarmat; bo Deus yebe wol ffaho depal ngalir! ");
INSERT INTO uli_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Be momay lal deper rechoka ye taldag lal buler; bo rebe wiri Deus! ");
INSERT INTO uli_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Be momay lal deper rechoka re yengangel hopos; bo Deus be ffesangur bo lol! ");
INSERT INTO uli_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Be momay lal deper rechokla yarmat re kekafohoyur bo fal mala re foforu mekla ye fel mo irel Deus; bo mala Lamliyel Laeng ila sa mel bo yar! ");
INSERT INTO uli_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Be momay lal dipmi irel yodla yarmat rebe hapatpat tayikof ngalugmi, ngo re hafohoyugmi, ngo re ffaor kaptami le ye tayikof bo fal mala hami choluway. ");
INSERT INTO uli_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ha hamomayu lal dipmi bo mala paliyel hafohoy kala yami ila ye mel wol laeng le fal ngalugmi. Iye sengal wululul hafohoy le re faor ngalir profeta kowe muswe. ");
INSERT INTO uli_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Hasa wochog hasiga ngalir pangal yarmat. Hare ye chuyloh mala tadel ngo towol yoh le sibe foru be taed. Towol yor pelal, si bele ppedaloh ngo yarmat re bele suru fedaley. ");
INSERT INTO uli_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Hasa wochog teram ngalir yarmetal faileng. Sew haplom le re hasudah mo woal sew tayit ila towe yoh le be mol. ");
INSERT INTO uli_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tor semal le be hagsu sew habul sa yetolong fael sew tapiy, bo yebe far yetedah wol mala faesul liliyel habul, bo yebe wer ngalir panger rechokla re mel yilim. ");
INSERT INTO uli_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Be wol ila sengal teram la yami. Ye tugul le be wol werloh imor panger yarmat bo rebe wiri mekla ye momay le ha foforu, ngo re bele hapingpinga mala Tammi le ye mel woal laeng. ");
INSERT INTO uli_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ha towe luluwaley le isa budoh bo ibe homolaho Hatobtob we yael Moses mo foloy kowe yar profeta kowe. Ite budoh bo ibe hachuyaloh, bo ibudoh bo ibe foru yebe llahloh le foloy kala yar ila ye katos. ");
INSERT INTO uli_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Habe memangi chog le yodle ye chil mel laeng mo talop, ngo tor sugfed mo irel Hatobtob we le be chuy yee, la hola miril faileng. ");
INSERT INTO uli_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iwe ngo yeramtala be hatawsi sugfed mo irel Hatobtob we, ngo ye foloyur yarmat rebe foru mala iy ye foloyu, ngo ye bela mel le be hartal totol mo irel mala Lamliyel Laeng. Ngo ligdi bo yeramtala be talenga Hatobtob la yael Deus ngo yesa foloyur yarmat bo rebe foru mala isa foru, ngo yebe tagiyet mo irel mala Lamliyel Laeng. ");
INSERT INTO uli_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iy be kangalugmi le be yoh le habe loh irel mala Lamliyel Laeng igle ye momay wegdegmi mo imor mokwe sensel Hatobtob we mo Pharisees kowe irel yami ma foru mekla ye fel mo irel Deus. ");
INSERT INTO uli_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Hasa moal rongrong molwe re kangalur yarmat muswe bo, ‘Ha towe hachuyaloh yael semal nngas; semal le be foru mele ngo rebe hasiloh irel liliyel tatelal hapatpat.’ ");
INSERT INTO uli_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngo ibe kangalugmi igla le: semal le be ssong ngal bisil ngo rebe hasiloh irel liliyel tatelal hapatpat. Semal le be kangalu mala bisil bo, ‘Gel ila tayichalmwo pelam!’ ngo rebe hasilong lal ttey. Iwe ngo semal le be kangalu bisil bo, ‘Ho buch ngo tayichalmwo pelam,’ ngo yebe loh Infiyerno. ");
INSERT INTO uli_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Hare hosa loh ho bela fang yam maligach ngal Deus wol altar la yal, ngo sa mmang ngalug le yor yal molwe bisim ssong ngalug, ");
INSERT INTO uli_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ngo hosa ligdi maligach we yam metal altar we, ngo hosa loh irel yodla chog bo ho bela hoposo llepdami mo mala bisim, iwe ngo hosa moch tefael bo hobe fang maligach we yam ngal Deus. ");
INSERT INTO uli_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Hare semal sa yichingewah le be hasug loh irel liliyel tatelal hapatpat, ngo hosa hafle llepdami irel yodla be chil yoh mo imol mala habe loh irel liliyel tatelal hapatpat. Bo ha bela hola chog lobola ngo bele hasug loh irel chol tetal we. Iwe ngo chol tetal we bele fangloh gel irel police, ngo police re bele yutlug long lal kalbus. ");
INSERT INTO uli_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ibe kangalugmi le ila lobola ha bela paoy iyang. Habe paoy iyang yee, lessiyal yal be yoh yami bakking ngo re moch hachuyah mo kalbus. ");
INSERT INTO uli_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Hasa mol rongrong we re sor bo, ‘Ho towe pera yael semal habulupoy.’ ");
INSERT INTO uli_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Iwe ngo iy be kangalugmi igla le semal le be kalngal semal fefel, ngo sa luluwal tayikof ngali, ila yesa for maltemay mo lal yal luluwal ngal fefel la. ");
INSERT INTO uli_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hare rel metam rela gilemera mele sa hasngalug molfid, ngo hosa haltu bo hobe ppedaloh. Bo ye momay tot le be chuy sugfed mo uwom mo imol mala rebe ppedug long lal Infiyerno. ");
INSERT INTO uli_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hare sere mala poam mele sa hasngalug molfid, ngo hosa supiy hobe ppedalo. Ye momay tot le be torloh sere poam mo imol mala rebe ppedug long lal Infiyerno. ");
INSERT INTO uli_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Hasa rongrong we re sor bo, ‘Semal le yebe mehal mo fefel la ril ngo be tefa sedep babiorol mahelal habulupoy sa fang ngal fefel we.’ ");
INSERT INTO uli_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iwe ngo ibe kangalugmi igla le: hare semal mal ye hachuya fefel la ril le te fal mala fefel we yete katos ngali, ila ngo mal we mele ye tayikof irel yal la fangloh fefel we bo bela molfid, ngo semal le bela rili fefel we, ngo sa molfid bo sa hasi yael semal habulupoy. ");
INSERT INTO uli_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Hasa wol rongrong le re kangalur yarmat muswe bo, ‘Ha towe hatawsi mekla hasa hatugulu, habe foru mekla hasa hatugulu ngal Deus bo habe foru. ");
INSERT INTO uli_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iwe ngo ibe kangalugmi igla le: ha towe hatugulu mo fael metal Deus mekla habe foru. Ha towe hatugulu mo fael idel laeng mekla habe foru bo laeng mele liliyel Deus; ");
INSERT INTO uli_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","hare ha teptap idel talop bo ila mala liliyel pechel, hare Jerusalem bo ila mala haplomol King la ye hartal tagiyet. ");
INSERT INTO uli_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ha towe hatugulu mekla habe foru le habe tapeli mekla chimmi bo yami tugul bo towe yoh le habe foru seyal mekla yall chimmi bo be mosus hare towe mosus. ");
INSERT INTO uli_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mala chog habe sor ila, ‘Ngo’ hare ‘Yeb’ — te tugul mele ha bela moch kapta mo wol miril ngo ye budoh mo irel Moniyan. ");
INSERT INTO uli_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Hasa rongrong we resa moal sor bo, ‘Paliyel sefeas metal yarmat ila wol sefaes metal yarmat, ngo paliyel seyay ngi ila wol seyay ngi.’ ");
INSERT INTO uli_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngo ligdi bo ibe kangalugmi igla le: ha towe palili tayikof la semal sa faor ngalugmi. Hare semal ye ppigiri tepam rela gilemera, ngo hosa wigdi ngali rela gilchegil bo yebe wol ppigiri. ");
INSERT INTO uli_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hare semal sa hasugloh lal court bo be hastangug mala mengagol holongom, ngo hosa wol ngaley coat la mengagom. ");
INSERT INTO uli_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Iwe ngo hare semal saldaw sa hakela ngalug bo hobe hasi lital irel sew mile, ngo hosa hasi irel ruwow mile. ");
INSERT INTO uli_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hare semal ye hafalpecheh bo hobe fang ngali sew formel ngo hosa ngaley. Ngo hare semal be dangroh sew formel le be teptap iyang, ngo sa moch hatefali ngo hosa ngaley. ");
INSERT INTO uli_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Hasa rongrong mwo we re sor, ‘Habe hachangir wol maryarmi ngo hasa hafobidrir rechokla re tayikof ngalugmi.’ ");
INSERT INTO uli_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Iwe ngo igla ila ibe kangalugmi bo: ha hachangir rechokla re tayikof ngalugmi ngo hasa mapelar rechokla rema hafohoyugmi bo rebe yolbuw, ");
INSERT INTO uli_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","bo habe mel bo lol mala Tammi wol laeng. Ye foru yaal bo be werdiy uwor rechoka re tayikof mo rechoka re momay, ye fang yud ngalir rechoka rema foru meka ye momay mo ika rema foru meka ye tayikof. ");
INSERT INTO uli_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Meda fal le Deus be fang paliyal ngalugmi le hare ha hachangir chog rechokla re hachangugmi? Bo chol hatteyel paliyel raeg mwo ngo wol ila senger. ");
INSERT INTO uli_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngo hare maryarmi chog mele hama hapatpat ngalir, ila ngo meda mele hasa foru le ye wel tang ika yarmat rema faesul foforu? Rechoka mwo rete Kristiano ngo wol ila senger! ");
INSERT INTO uli_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Habe mel chog le ha fel — le habe tappel chog mala Tammi woal laeng le ye fel. ");
INSERT INTO uli_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Habe kemahoy bo hade la faor wegdeg kala ye momay bo yami kawerwer luwul yarmat. Hare ha bela kawerwer wegdeg ka luwul yarmat cholop, ngo tor paliyal le be holahmi mo irel mala Tammi wol laeng. ");
INSERT INTO uli_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Iwe ngo yodla habe fang formel ngal semal yarmat le yesa kkel yal hafohoy, ngo ha towe tap kawerwer mala hasa foru, bo hade la tappilir rechokla rema forgirloh lal imwel mepel ka iwe mo lal yalap. Rema foru bo fal mala yarmat rebe ma hapingpingar. Ibe hatugulu ngalugmi le sa faesul moll paliyer le resa ngaler. ");
INSERT INTO uli_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Iwe ngo yodla ho bela tipingi semal yarmat le sa kkel yal hafohoy, ngo hobe foru le mala mwo maryarem le ye kkel yami fel fengal ngo towe gola kofal. ");
INSERT INTO uli_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ila ngo hami chog llufulumi mele habe gola kofal. Ngo mala Tammi bela wiri mala hosa foru le yarmat re togla ngo be fang paliyal ngalug. ");
INSERT INTO uli_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Yodla habe mepel ngo ha towe wochog rechokla rema forgirloh. Rema dipli bo rebe su ngo resa mepel lal imwel mepel ka, iwe mo tabtabol yalap ka bo pangal yarmat ngo rebe wirir. Ibe hatugulu ngalugmi le rechoka ila sa moll paliyer. ");
INSERT INTO uli_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yodla habe mepel ngo hasa loh lal senggil kala yami hasa pilta hatam, ngo hasa mepel ngal mala Tammi le site ma wiri. Ngo mala Tammi ye wiri molwe hasa foru le hami loh chog ila yebe holbuwahmi. ");
INSERT INTO uli_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Yodla habe mepel ngo ha towe hacholpa hapatpat kala tor pelal bo hade wochog Gentiles kowe re luluwaley le Deus be rongrong yalor bo ye lellay mepel kala yar. ");
INSERT INTO uli_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Towe ila sengal yami mapel. Mala Tammi sa faesul gola mekla ha hafohoy iyang mo imol mala habe dangro. ");
INSERT INTO uli_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Be iye sengal yami ma mapel: ‘Tamem le ho mel woal laeng: Be ssor mala idem le ye santus; ");
INSERT INTO uli_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","hobe budoh bo yamem Llulap; le habe talenga yalom woal talop le be wochog woal laeng. ");
INSERT INTO uli_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fang ngalugmem mongoy la habe hangi igla. ");
INSERT INTO uli_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Hachuya fael tayikof kala hasa foru, le be wochog yamem hachuya fael tayikof kala resa foru ngalugmem. ");
INSERT INTO uli_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ho towe hasugmemloh irel hagelgel la ye weres, bo hobe hadorahmem mo irel Moniyan.’ Bo mala Lamliyem, mo ssor, mo falmay la yam ila tor siyal. Amen. ");
INSERT INTO uli_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Hare habe hachuya mo lal yami luluwal mekla re faor ngalugmi le ye tayikof ngo mala Tammi wol laeng be wol hachuya mo lal yal luluwal tayikof kala hasa foru. ");
INSERT INTO uli_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Iwe ngo hare habe te hachuya mo lal yami luluwal tayikof kala sibis resa faor ngalugmi ngo be wol ila sengal mala Tammi wol laeng bo towe hachuya mo lal yal luluwal tayikof kala hami hasa foru. ");
INSERT INTO uli_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Yodla ha bela supiy halmi ngo ha towe ma hafohoyuloh wol metami bo hade la wochog rechokwe rema forgirloh fael metal yarmat. Ir ila re tay ma hallimdir bo yarmat rebe gola le resa supiy haler. Ibe hatugulu ngalugmi le rechokla ila sa faesul moll paliyer. ");
INSERT INTO uli_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yodla hobe supiy halam gel semal ngo hobe ma yurmat ngo ho taldi chomom, ");
INSERT INTO uli_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bo rede gola le hosa supiy halam, bo halachog mala Tammi le si tema wiri mele be gola. Ngo mala Tammi le ye wiri mekla ha foru llufulumi mele yebe holbuwahmi. ");
INSERT INTO uli_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ha towe hattey mmalmi mo wol talop bo churchur de hatawsi hare ye yewloh hare chomachoh re peraloh. ");
INSERT INTO uli_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ha far hattey mmalmi mo wol laeng, le churchur towe hatawsi ngo towe yewloh ngo towe yoh le chomachoh rebe pere; ");
INSERT INTO uli_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","bo luluwal kala yami ila pangal yad ngo be mel chog lobola ye mel mmal kala yami iyang. ");
INSERT INTO uli_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Meka metach ila ye wochog sew habul le hawrel holong. Hare be ffod metami ngo be wol teram mekla holongmi, ");
INSERT INTO uli_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ngo hare ha metafis le tayorloh mele hama wiri, ila ngo mekla holongmi ila be mel luwul rochupung. Iwe ngo hare bela torloh teram la lal mekla dipmi ila ngo be ifa lepal yal rochupung lal mekla dipmi! ");
INSERT INTO uli_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ye towe fel le be semal boy ngo rumal yal masta; bo ila ngo yebe hachangi semal ngo ye hafobidiri ila semal; hare yebe momay wegdegel ngal semal ngo ye tolpagililoh ila semal. Towe yoh le hobe mel bo boyel Deus ngo ho wol mel bo boyel salpiy. ");
INSERT INTO uli_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ila fal le ikangalugmi bo: ha towe merhagili bo de tor mele habe mongoy hare ha yul bo habe molow, hare ha merhagili bo de tor mengag le habe mengag iyang. Ifa sengal, te palleng pelal molow mo imol mongoy? Iwe ngo te palleng pelal holong mo imol mengag? ");
INSERT INTO uli_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ha kemahor mael yeyal ka: re tema fod milay ngo re tema gil uwal milay re sala haliliya lal soko; mala Tammi wol laeng mele ma hammaler. Ifa sengal, ye te palleng pelami mo imor mael yeyal ka? ");
INSERT INTO uli_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Itey semal hami le be yoh le be hassulayiloh tot yodol yal molow irel yal merhagililoh chog? ");
INSERT INTO uli_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Meda fal le habe merhagili bo de tor mengagmi iyang? Ha kemahoy floras kala ye tumuldah chog le re tema yengang ngo re tema ffaor mengagur. ");
INSERT INTO uli_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ibe kangalugmi le King Solomon mwo le ye mmal, ngo tor mengagol le ye wochog kamdidiyel sepoy floras ka. ");
INSERT INTO uli_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Deus mele ye hamengagu fadil ka iy chog yal tumuldah le fadil ka ye mel igla ngo la walsu ngo ye tamel loh bo yesa fisngegloh. Te fasul tugul le Deus yebe fang mengagumi? Ila lepal wechichil yami tugul! ");
INSERT INTO uli_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ila ha towe merhagili hare: ‘Iya lobole be budoh ha lai, mo limmi, mo mengagoi mo iyang?’ ");
INSERT INTO uli_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Ika meka Gentiles rema toa luluwaleloh chog.) Pangal mekla habe mmal iyang ngo mala Tammi wol laeng ye gola. ");
INSERT INTO uli_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pangal meka ngo Deus be hammal ngalugmi igle ha itol dipmi irel yami foru yengangel mala Lamliyel Deus mo mekla ye fel depal iyang. ");
INSERT INTO uli_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ha towe merhagili kofal walsu bo ye wol cholop mekla sibe luwaley irel kofal walsu. Tor fal le sibe wol chila mekla weresel seral mo seral. ");
INSERT INTO uli_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ha towe hatugulu yael semal tayikof bo ila ngo Deus towe hatugulu yami tayikof, ");
INSERT INTO uli_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","bo Deus ila yebe hatugulu yami tayikof le be wochog yami hatugulu kofer yarmat, le be faor ngalugmi le be hafedeg ngal mekla hami hama faor ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Meda mele hola wiri pesla sepoy mo lal metal mala bisim ngo hola tuwiri tabol hapepey la lal ila metam? ");
INSERT INTO uli_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Be ifa sengal ngo ho sala kangalu semal bisim bo hobe hachuya pesla sepoy lal metal le hare gel mwo ngo ye mel setab hapepey lal ila metam ngo ho tuwiri? ");
INSERT INTO uli_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gel ho foforiyeg! Hobe moal hachuya mwo tabol hapepey la lal mala metam, ngo bele moch ffod yam wiri le hobe hachuya pesla sepoy mo lal metal mala bisim. ");
INSERT INTO uli_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ha towe ngaler peska meka ye santus — bo rebe far ttagul chog resa gusugmi. Ha towe pped ngalir pabiy yises kala marmi le ha hachangi bo rebe suru fadaley. ");
INSERT INTO uli_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Habe dongor ngo be yoh ngalugmi; habe meri ngo habe wiri; habe hapungpungu hatam, ngo be sugeg ngalugmi. ");
INSERT INTO uli_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bo pangal yarmat le rebe dongor ngo be yoh ngalir, ngo te tugul le be meri ngo be wiri, be sugeg hatam ngal yeramtala be hapungpungu. ");
INSERT INTO uli_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hami temer yalwich be yoh ngalugmi le lomi be dongor hal flowa ngo hami hasa fang ngali feas? ");
INSERT INTO uli_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hare gel semal mal le yor lom, ngo mala lom sa dongor hal yig, ngo ye tugul le gel ho towe fang ngali semal parchoyoh. ");
INSERT INTO uli_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mala ila lepal yami tayikof ngo ha gola mekla ye momay le habe fang ngalir mekla lomi. Iwe ngo be ifa lepal momay le mala Tammi wol laeng yebe fang ngalir rechokla rema dodongor ngali? ");
INSERT INTO uli_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Habe faor ngalir yarmat mekla hami ha dipli bo yarmat rebe faor ngalugmi; bo ila fal Hatobtob kowe yael Moses, iwe mo foloy kowe yar profeta kowe re foloyu ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ha bulong mo irel hatam la ye wachich bo mala hatmal Infiyerno ila ye palleng, ngo mala yalepal ila ye mechrag ngo ye cholop yarmat le rema dabey. ");
INSERT INTO uli_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Iwe ngo mala hatmal molow ila ye wechich ngo mala yalepal ila ye weres le halfedmal yarmat le rema wiri. ");
INSERT INTO uli_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Habe hafalugmi irer profeta kala rete katos; re bela budoh iremi le re bele wochog woar saaf kowe, ngo luluwal kala yar ila ye wochog bolof kowe re machoh. ");
INSERT INTO uli_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ha be golar mo irel wegdigir. Ire ka yor chil ila tema buyoy uwal le grapes, ngo fadil ka sima ddub iyang, ila te ma buyoy uwal le fig. ");
INSERT INTO uli_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sehay ire le be cchapipidah ngo be momay mekla uwal, ngo sehay le be tayikof tumlal ngo yebe tayikof mekla uwal. ");
INSERT INTO uli_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sehay ire le be cchapipidah, ila towe yoh le bela buyoy mekla uwal le be tayikof, ngo sehay le be tayikof mala tumlal ila towe yoh le be momay mekla uwal. ");
INSERT INTO uli_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Te tugul sehay ire le be tayikof mekla uwal ngo rebe supiloh resa ppedadah wulyef. ");
INSERT INTO uli_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ila ha bele moch la golar profeta kala rete katos mo irel mekla wegdigir. ");
INSERT INTO uli_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Te panger rechokla rema ffesanguyey bo ‘Samol, Samol’ ngo rebe bulong lal mala Lamliyel Laeng, bo halachog rechokla rema foru mekla mala Temay wol laeng ye dipli mele rebe bulong iyang. ");
INSERT INTO uli_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yodla bela budoh Rael Tatelal Hapatpat ngo ye cholop le re bele kangaluyey bo, ‘Samol, Samol! Fael mala idem mele ha kapta mala yalol Deus ngalir yarmat iyang, ngo fael mala idem mele sa cholop moniyan le hasa hachuyar mo uwor yarmat. Iwe ngo ye wol cholop kkemal kala hasa foru irel mala idem.’ ");
INSERT INTO uli_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Iwe ngo Ngang ibele kangalur bo, ‘Ngang ila ifasul toglahmi. Ha chuy mo irey, hami chotayikof kala!’ ");
INSERT INTO uli_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Iwe ngo rechokla re rongrong ngo re talenga meka yaloy, ila rebe wochog semal mal le ye repiy le ye hasuy imwla imwal wol hohyal. ");
INSERT INTO uli_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yela kkel yal ppotog sala ssogdah mololul ngo ye burloh wol fuluy ngo ye mmordoh yang. Ngo tor mele imw we ye foru bo mil mala ye hassu wol hohyal. ");
INSERT INTO uli_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Iwe ngo rechokla re rongrong meka yaloy ngo re temechal talenga, le re wochog semal mal le ye buch bo ye hasu imwla imwal wol piy. ");
INSERT INTO uli_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yela kkel yal ppotog sala ssogdah mololul ngo ye burloh wol fuluy, ngo ye mmordoh yang, sa ppungdiy imw we sala medardarloh.” ");
INSERT INTO uli_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yodwe yela mol yael Jesus sor meka, ngo buwa we ye luwdah irel wululul yal foloy. ");
INSERT INTO uli_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesus ila yete hafedeg ngalir mokwe sensel Hatobtob we; bo iy ila ye foloy le yor kkelel mokwe ye kekapta. ");
INSERT INTO uli_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yodwe yela bidiy Jesus mo wol tayit we ngo ye feraketaw yarmat le resa dabey. ");
INSERT INTO uli_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Iwe sala budoh semal mal irel le ye pachngali mesel pekel, sa hasubugudiy mo imol sa kangalu bo, “Hare ye fel mo lal depom le hobe hachuya mesel pekel le mo uwoy ngo hosa hachuya.” ");
INSERT INTO uli_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus sa cchangloh sala yangsi mal we ngo sa kangalu bo, “Ye fel mo lal depey, bele chuy mesla mo uwom!” Irel yodwe chog ngo sa chuyloh mesel pekel we mo uwol mal we. ");
INSERT INTO uli_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iwe Jesus sa kangalu bo, “Talenga! Tor le hobe kangalu mele isa faor ngalug, ngo ligdi bo hobe loh irel temarong we bo ye bela kemahoh. Ngo hosa fang maligach we Moses ye sor, le ila mele bele mel le yam tugul ngalir pangal yarmat le sa chuy mesel pekel mo uwom.” ");
INSERT INTO uli_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yodwe Jesus yela hola doh Capernaum, ngo yesa budoh semal Tamol saldawel Roma irel, sa hafalpechey bo be tipingi: ");
INSERT INTO uli_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Samol, boy la yai ila sa yol chog irel mala imwey le sa kkel yal tomay, le tay yoh le be mmagudgud ngo sa kkel yal hafohoy.” ");
INSERT INTO uli_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iwe Jesus sa sor bo, “Ibele loh ibela hachuya yal tomay.” ");
INSERT INTO uli_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Saldaw we sa sor bo, “Aa yeb, tor kofay le hobe budoh irel imwla imwey bo mele chog hobe sor yalom, ngo boy la yai ila be chuy yal tomay. ");
INSERT INTO uli_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngang mwo ngo yor tot saldaw le re tagiyet mo imoy, ngo yor tot le re totol: ibe kangalu iye semal bo, ‘Ho loh!’ ngo be loh, ngo ibe kangalu ila semal bo, ‘Budoh!’ ngo yebe budoh; ngo ibe kangalu boy la yai bo, ‘Foru mele!’ ngo yema foru.” ");
INSERT INTO uli_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ye lluwdah Jesus irel meka sa rongrong, ngo sa kangalur rechokwe re dedabey bo, “Ibe kangalugmi le ited wiri mwo semal mo wol Israel le, le iye lepal kkelel yal tugul. ");
INSERT INTO uli_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ibe hatugulu ngalugmi le ye cholop yarmat le rebe budoh mo rel laeng la meteral mo meldow le rebe maroro lengchel Abraham, mo Isaac, mo Jacob irel mala Lamliyel Laeng. ");
INSERT INTO uli_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iwe ngo rechokla medalbo rebe mel irel lobola Lamliyel Laeng, ila re bele ppedirwey mo iyang re bela mel luwul rochupung, re bela tetang ngo re ketangtingi ngir mo iyang.” ");
INSERT INTO uli_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iwe Jesus sa kangalu tamol saldaw we bo, “Tefal loh llubugtam, bo mekla hosa chepar iyang, ila bele yoh ngalug.” Irel yodwe chog ngo sa chuy yael boy we tomay. ");
INSERT INTO uli_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus ye loh irel molwe bugtal Pedrus ngo sala wiri sil molwe ril Pedrus le ye mel wol bet bo ye tomay le ye kkel bichikeral mala gil. ");
INSERT INTO uli_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus ye yangsi molwe paol ngo ye chuyloh molwe bichikeral, iwe sa chemdah chog sala kemahoy mele be hammal ngal Jesus. ");
INSERT INTO uli_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yela lefhafdoh ngo ye cholop rechokla yor moniyan uwor le yarmat re hasirdoh irel Jesus. Hal sepad chog hapatpat le Jesus ye sor, ngo ye chuyloh moniyan kowe mo uwor. Ngo ye hachuya yar tomay rechoka re tomay. ");
INSERT INTO uli_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ye foru mele bo fal mala bela llahloh le ye katos mokwe profeta Isaiah ye sor irel bo, “Ye hachuya yach tomay ngo wol hachuya maes mo uwoch.” ");
INSERT INTO uli_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus ye wiri buwa we yesa ttey ngali ngo sa kangalur mokwe re dabeyal bo rebe loh mo rel chaelwe sere. ");
INSERT INTO uli_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sala budoh semal mokwe sensel Hatobtob we ngo sa kangalu Jesus bo, “Sensey, isa fel le te tugul solbos le hobe loh iyang ngo ibe daboh.” ");
INSERT INTO uli_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus sa sor bo, “Fox mwo ngo yor ngeter, ngo mael yeyal ka ngo yor hafter, ngo mala Layur Retalop ila tor solbos le be yoldiy mo iyang bo yebe hasoso.” ");
INSERT INTO uli_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ye mel semal mokwe re dabeyal le ye kangalu Jesus bo, “Sensey, widyey ibe tefael loh ibela leba mala temay.” ");
INSERT INTO uli_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus sa sor bo, “Dabeyey, ligdir chomes rebe leba yar mes.” ");
INSERT INTO uli_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesus mo mokwe re dabeyal re dage seyay boat. ");
INSERT INTO uli_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Re tedaploh chog ngo sa kkel doh sew yaeng lal laom we, ngo sa mmel bele moos boat we. Irel yodle ngo Jesus ye masor. ");
INSERT INTO uli_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mokwe re dabeyal resa fangludah ngo resa kangalu bo, “Samol, hadoragich. Igla ila si bele mes!” ");
INSERT INTO uli_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus sa sor bo, “Meda mele hasa rusmes iyang? Tehal sugfed yami tugul!” Iwe yesa sudah sa kangalu yaeng mo law bo rebe posoloh, iwe sala malululoh. ");
INSERT INTO uli_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pangerloh ngo re lluwdah. Iwe resa sor bo, “Yarmat meda mele? Yaeng mo law mwo ngo rema talenga yalol!” ");
INSERT INTO uli_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ye budoh Jesus irel mokwe faluyel Gadara le ye mel rel chael we rewe sere, sala chungur rumal mal le re buyoy mo luwul tot peey. Rechoka ila yor moniyan uwor ngo ye kkel yar melad. Ila fal le tayor le yema mechal bo yebe dabedoh yalap le. ");
INSERT INTO uli_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Irel yodla chog ngo resa ttawul le re sor bo, “Gel mala lol Deus, meda mele hosa luluwaley ngalugmem? Hosa budoh le hobe fang yamem hagerger mo imol yodla rebe hagerugmem iyang?” ");
INSERT INTO uli_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ye mel sew pulgul pabiy le re momongoy le re te ddawloh. ");
INSERT INTO uli_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Iwe moniyan kowe resa hafalpechey Jesus le re sor bo, “Hare ho bele ddabohmem loh mo uwor rechoka, ilang ngo hosa fangloh hamem ha bela mel uwor pabiy kalay.” ");
INSERT INTO uli_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus sa kangalur bo, “Ha loh,” Iwe resa chuy re sala mel uwor pabiy kowe. Iwe ngo panger pabiy kowe ngo resa hamdawey mo wol metal hohyal we resa pungdiy lal chaelwe re sala malom loh. ");
INSERT INTO uli_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Iwe resa ddar rechokwe re kekammaler pabiy kowe resa loh luwul haplom, re sala kapta ngalir yarmat pangal mokwe resa wiri mo molwe ye wel ngal mal we rumal we yor moniyan uwor. ");
INSERT INTO uli_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iwe pangal yarmetal haplom we ngo resa loh irel Jesus; ngo yodwe rela wiri ngo resa hafalpechey bo yebe chuy mo woal molwe faluyer. ");
INSERT INTO uli_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus ye dabey seyay boat sa supiloh mololul we le be tefael ngal molwe haplomol. ");
INSERT INTO uli_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Iwe ngo tot yarmat resa hasidoh semal mal irel le ye mahatugut le ye yol wol sew bet. Yodwe Jesus ye wiri lepal kelel tugul we yar, ngo sa kangalu mal we ye pachngali meswe bo, “Layi, hakkela lal depom! Sa chuy fael yam molfid.” ");
INSERT INTO uli_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iwe ngo tot mokwe sensel Hatobtob we resa luluwaley long chog lal deper bo, “Mal le ila sa hapatpat tayikof irel Deus!” ");
INSERT INTO uli_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus ye gola luluwal kowe yar, ngo sa sor bo, “Meda mele la ila sengal yami luluwal tayikof iyang? ");
INSERT INTO uli_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ifa sew le ye mechrag le sibe sor, ‘Sa chuy fael yam molfid,’ hare sibe sor bo, ‘Sudah hobe darloh’? ");
INSERT INTO uli_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ibele hatuglu ngalugmi le, mele Layur Retalop ila yor kkelel wol talople, le be hachuya fael molfid.” Iwe yesa kangalu mal we ye mahatugut bo, “Sudah, hosa hasi mala giyem, ngo hosa loh bugtam!” ");
INSERT INTO uli_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mal wesa sudah chog yesa loh llubugtal. ");
INSERT INTO uli_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yodwe yarmat re wiri molwe ngo resa motog, ngo resa hapingpinga Deus bo fael yal fang kkelel yarmat. ");
INSERT INTO uli_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus sa ligdi loboswe sa dedarloh sala wiri semal chol hateyel paliyel raeg, le Matthew idal, le ye maroro lal yofis la yal. Jesus sa kangalu bo, “Dabeyey.” Matthew sa sudah sa dabey Jesus. ");
INSERT INTO uli_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yodwe ye momongoy Jesus irel imw we imwel Matthew, ngo ye cholop chol hateyel paliyel raeg mo chotayikof kowe le resa budoh irel Jesus mo mokwe re dabeyal irel tis we re mel iyang. ");
INSERT INTO uli_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tot Pharisees kowe re wiri ngo resa kasiya mokwe re dabeyel Jesus bo, “Meda mele sensey la yami yela mongoy ngalir rechokla ila senger iyang?” ");
INSERT INTO uli_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus ye rongrong mokwe re sosor, ngo sa hatefali le ye sor bo, “Rechoka rete tomay, ila tor fal togta le be budoh irer bo rechokla chog re tomay mele yema budoh togta irer. ");
INSERT INTO uli_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ha loh ha bela gola fael molwe Babior we ye Santus ye sor bo: ‘Ite dipli le habe teptap mael bo yami maligach ngalyey, bo momayel hagiyeg mele idipli.’ Ite budoh bo ibe ffesangur rechokla re momay, bo rechokla re tayikof mele ibudoh bo ibe fesangur.” ");
INSERT INTO uli_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Re budoh mokwe re dabeyel Johannes Baptista irel Jesus resa kasiya bo, “Meda fal le hamem mo Pharisees kowe hama toa supiy halmem, ngo mekla re dabeyem re tema supiy haler?” ");
INSERT INTO uli_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus sa sor bo, “Ha luluwaley ngo be yoh le yebe tayikof deper chol gubulul sew habulupoy la hare be chil mel mal we yal habulupoy we irer? Ye tugul le towe ila sengal! Ngo ye mel yodla bela hola ngo re bele hastangir mal we, iwe ngo re bele moch supiy haler. ");
INSERT INTO uli_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tor semal le be hasi sedep mengag le ye tefoy sa depacha ngal sew mengag le yesa bes. Mengag we chil tefoy ila yebe rref fengal sala hapallingiloh molwe terral mengag we. ");
INSERT INTO uli_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ngo wol tor semal le ma kak wine kowe ye tafoy sa yetolong lal liliyel wine kowe sa ssulay, bo be ttar liliyel wine we sa ssulay, sala serloh wine we. Wine ka ye tefoy ila rebe yetelong lal liliyel wine kowe ye tefoy, ila ngo roruwow ngo tor mele be foru.” ");
INSERT INTO uli_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yodwe Jesus ye sor molwe ngo semal tamol kowe yar Jews sa budoh irel, sa hasubgudiy mo imol ngo sa kangalu bo, “Ye moch mesloh chog semal lefechig layi, dabeyey ho bela yetedah pom uwol bo yebe molow.” ");
INSERT INTO uli_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iwe Jesus sa sudah sa dabey yeramtawe, iwe ngo mokwe re dabeyal re wol dabey. ");
INSERT INTO uli_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ye sala budoh semal fefel mo lutugrul Jesus sa yangsi ngachel molwe mengagol. Fefel le ila ye tomay le sa seg mo ruwow raeg yal machpol. ");
INSERT INTO uli_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Fefel we sa luluwaley long chog lal depal le ye sor bo, “Hare ibe yangsi chog mala mengagol ngo be chuy yai tomay.” ");
INSERT INTO uli_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus ye tagul sala wiri fefel we ngo sa kangalu bo, “Layi, hakkela lal depom! Tugul la yam mele sa hachuya yam tomay.” Yodwe chog ngo ye chuyloh tomay we yael fefel we. ");
INSERT INTO uli_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iwe Jesus sa bulong lal imw we imwel tamol we. Yodwe yela wiri rechokwe rema mosik wol maes mo yarmat le resa rol nnganga fengal, ");
INSERT INTO uli_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ngo Jesus sa kangalur bo, “Ha rowey ligtam pangamiloh! Lefechig la ila te mes bele yal masor chog!” Iwe ngo panger rechokwe ngo resa maligili Jesus. ");
INSERT INTO uli_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yodwe chog sa buyoy pangal yarmat ligtam, ngo Jesus sa bulong lal senngil we sa holudah molwe paol lefechig we ngo sa chemdah. ");
INSERT INTO uli_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iwe sa pallengloh kaptal molwe wol pangal loh fuluwe. ");
INSERT INTO uli_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus sa chuy mo loboswe sa dedarloh ngo rumal mal le re metafis resa dabey. Resa tetawulagili le re sor bo, “Yebe ffaho depom ngalugmem, ho mala Lol David!” ");
INSERT INTO uli_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yodwe Jesus ye bulong yilim ngo metafis kowe rumal resa budoh irel ngo Jesus sa kasiyar bo, “Ha chepar le be yoh le ibe hachuya yami metafis?” Iwe ngo ir resa sor bo, “Ngo, ha chepar!” ");
INSERT INTO uli_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iwe Jesus sa yangsi mokwe meter ngo sa sor bo, “Bele chuy yami metafis le mil mala ha chepar!” ");
INSERT INTO uli_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iwe sala ffod tefael mokwe meter sala momay loh. Jesus sa kangalu hamayur bo, “Tor le habe kangalu mele!” ");
INSERT INTO uli_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iwe ngo ir re far loh re sala kapta fadaley pangal lobos mo woal fuluwe kofal molwe Jesus ye foru. ");
INSERT INTO uli_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yodwe ye loh mal we rumal, ngo tot yarmat resa hasidoh semal mal irel Jesus. Mal le ila tema mmal bo be hapatpat bo yor moniyan uwol. ");
INSERT INTO uli_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yodwe chog ye chuy moniyan we, ngo mal we sa chap yal hapatpat ngo pangal yarmat ngo resa lluwdah. Iwe resa sor bo, “Tedyor mwo mo fael sew le si wiri tappel mele mo wol Israel!” ");
INSERT INTO uli_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Iwe ngo Pharisees kowe resa sor bo, “Mala tamol moniyan mele ye fang kkelal bo yebe hachuchuy moniyan.” ");
INSERT INTO uli_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus sa loh wol pangal loh fuluy mo haplom. Ye fofoloy fedal lal imwel ttey kowe, le ye fofoloyu Hapatpat Momay we kofal mala Lamliyel Laeng, ngo ye hachuya pangal metmetal maes mo tomay mo uwor yarmat. ");
INSERT INTO uli_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yodwe yela wiri buwa kowe iwe leper, ngo sa kkel yal fahor bo resa merahrah ngo tor re tipingiyer, le resa wochog saaf kowe tor re matmeter. ");
INSERT INTO uli_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iwe sa kangalur mokwe re dabyal bo, “Sa cholop uwal milay ngo tor chol yengangal le rebe hateyili fengali. ");
INSERT INTO uli_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hala hafalpechey yeramtala yal milay le, bo yebe fang tot chol yengang bo re bela hatteyili fengali mekla uwal milay le.” ");
INSERT INTO uli_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus ye fesangu fengalir Apostel kowe seg mo rumal yesa fang kkeler, bo be yoh le rebe hachuchuy moniyan mo pangal metmetal maes mo tomay mo uwor yarmat. ");
INSERT INTO uli_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ika meka ider Apostel kowe seg mo rumal: yeramtala metamo ila Simon (le rema ffesangu ngali bo Pedrus) mo Andrew we bisil; James mo Johannes we bisil, le lol Zebedee; ");
INSERT INTO uli_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip mo Bartholomew; Thomas mo Matthew, we ma hattey paliyel raeg; James le lol Alphaeus, mo Thaddaeus; ");
INSERT INTO uli_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Mo Simon we ye hachangi molwe faluyal, mo Judas Iscariot, we ye yichinngewa Jesus. ");
INSERT INTO uli_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus ye hagloyur loh chowe seg mo rumal le ika meka ye kangalur: “Ha towe loh irel mekla faluyer Gentiles hare mekla haplomor yarmetal Samaria. ");
INSERT INTO uli_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ha roloh irer yarmetal Israel kala resa mwael loh le resa wochog saaf kowe re tay gola lobosle rebe loh iyang. ");
INSERT INTO uli_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ha loh ha bela foloy le habe sor bo, ‘Mala Lamliyel Laeng ila sa harep!’ ");
INSERT INTO uli_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ha hachuya yar yarmat tomay, ngo hasa hamolowa tefaelir chomes, ha hachuya metmetal meskala ye mel uwol yarmat, ngo ha hachuchuy moniyan. Yor mele yesa yoh ngalugmi le tor paliyal, ila habe fang le towe yor palimi. ");
INSERT INTO uli_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ha towe kak hoal, silver, hare kobra checha lal hagechel mengagmi; ");
INSERT INTO uli_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ha towe kak tutuwel dodongor irel maleka la yami hare liwilil mekla mengagmi hare yami bwela hare sohmi. Semal chol yengang ngo faesul tugul le rebe ngaley mekla yebe teptap. ");
INSERT INTO uli_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ha bela budoh irel sew haplom le ye palleng hare sew haplom le ye wechich, ngo hasa loh ha bela meri semal le be mechal bo habe paoy irel, iwe ngo hasa paoy chog irel yee, hala chuy mo wol haplom we. ");
INSERT INTO uli_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ha bela bulong lal sew imw ngo hasa kangalur chol imw we bo, ‘Hopos be mel iremi.’ ");
INSERT INTO uli_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hare chol imw we re dipli molwe hasa budoh irer, ngo hasa ligdi habong we hasa sor bo be mel irer; ngo hare rete dipli molwe hasa budoh irer, ngo hasa hasi tefali habongol hopos we yami. ");
INSERT INTO uli_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Iwe ngo hare yor tot bugat hare haplom le rete dipli molwe hasa budoh irer, hare rete talenga yalomi, ila ngo hasa ligdi lobowe ngo hasa yuchgaloh boll mo irel mekla pechemi. ");
INSERT INTO uli_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ibe hatugulu ngalugmi le yodla Rael Tatelal Hapatpat, iwe ngo Deus yebe kawraloh le ye kkel tot yal fahor yarmetal Sodom mo Gomorrah mo imor chol haplom la! ");
INSERT INTO uli_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ha talenga! Ibele hagloyugmiloh le bele wochog bo siya fangloh tot saaf luwulur sew pulgul wolves. Habe hamarhahmi le be wochog parchoyoh, ngo ha hamaluluyahmi le be wochog doves kowe. ");
INSERT INTO uli_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ha llugu dipmi, bo yor yarmat le rebe ddorfugumi resa hasugmiloh irel imwel tatelal hapatpat, ngo rebe wwodugmi mo lal imwel ttey kowe. ");
INSERT INTO uli_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Fael ngang mele rebe hasugmiloh irel tatelal hapatpat mo fael meter tamol mo king bo habe kapta Hapatpat Momay we ngalir mo ngalir Gentiles. ");
INSERT INTO uli_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yodla rebe hasugmiloh irel tatelal hapatpat, ngo ha towe merhagili mele habe sor mo wululul yami be sor; bela hola yodla ngo Espritu Santus la yael mala Tammi ye bele kangalugmi mele habe sor. ");
INSERT INTO uli_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iwe ngo mekla ha bela kapta ila te yalomi, bo yebe budoh mo irel Espritu Santus la yael mala Tammi le iy mele be fang yami luluwal irel mekla habe kapta. ");
INSERT INTO uli_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Yarmat re bele fangloh mekla spegil bisir bo rebe llimeserloh, ngo temer yalwich, ila bele wol ila sengal mala rebe faor ngal layur. Yalwich ila re bele tagul ngal mokwe wulutugur resa fangloh ir bo rebe llimeserloh. ");
INSERT INTO uli_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pangal yarmat ngo re bele hafobdurugmi le fael ngang. Iwe ngo te tugul semal le yebe yedamgel yee, siyal yal mes ngo be daor. ");
INSERT INTO uli_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yodla re bela hafohoyugmi mo irel sew haplom, ngo hasa ddar habe loh irel haplom la sew. Ibe hatugulu ngalugmi le towe pagel moll yengang kala yami mo wol pangal haplomol Israel ngo sa budoh mala Layur Retalop. ");
INSERT INTO uli_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tor semal yalwichil skun le ye tagiyet mo imol yal sensey; ngo tor semal slave le ye tagiyet mo imol yal masta. ");
INSERT INTO uli_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ila, semal yalwichil skun ila ye tugul le be fel lal depal hare bela mel le be tappel sensey la yal, ngo semal slave ila be fel lal depal le hare be tappili masta la yal. Hare rebe ffesangu temal sew haleng bo Beelzebul, ila ngo panger chol haleng we ngo re bele ffesangu ngalir tot yid le ye kkel tot yal taiykof! ");
INSERT INTO uli_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ila ha towe metagur yarmat. Te tugul mele ye mwol ngo be llah, ngo pangal meka ye mwol ngo yarmat rebe gola. ");
INSERT INTO uli_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mele ikekangalugmi luwul rochupung habe tefael ngali habe kapta lal werloh, ngo meka hasa rongrong le ted yor le ye gola ila ha bela kapta fadaley. ");
INSERT INTO uli_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ha towe metagur rechokla be yoh le rebe llimeseloh mekla holongmi, ngo towe yoh le rebe lliy mekla ngulmi; habe far metagu Deus bo iy mele be yoh le yebe llimesehmiloh, ngo ye lliy mekla ngulmi mo lal Infiyerno. ");
INSERT INTO uli_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Be sefaes chog kobre checha ngo be yoh le habe chuwayi ngal rumal sparrow. Iwe ngo tor semal mael ka le be ppungdiy wototol le mala Tammi yebe togla. ");
INSERT INTO uli_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Iwe ngo hami ila mekla mo yall chimmi ngo sa mol irel papa. ");
INSERT INTO uli_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ila ha towe motog bo ye palleng palami mo imor sparrow ka. ");
INSERT INTO uli_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Te tugul semal le be kapta fedaley luwul yarmat le iy choluway, ngo be wol ila sengal yai be kapta le iy choluway mo fael metal mala Temay wol laeng. ");
INSERT INTO uli_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Iwe ngo te tugul semal le be kapta fadaley luwul yarmat le te iy choluway, ngo be wol ila sengal yai be kapta le te iy choluway mo fael metal mala Temay woal laeng. ");
INSERT INTO uli_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ha towe luluwaley le isa budoh bo iy be hasidoh hopos lal faileng le. Yeb, ite budoh bo ibe hasidoh hopos bo seyay sayden mele ihasidoh. ");
INSERT INTO uli_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Isa budoh bo ibe foru yalwich tarmal bo rebe tagul tang temer, ngo wol ila senger yalwich fefel bo rebe tagul tang seler, ngo fefel kala yor rir rebe tagul tang sil mekla rir; ");
INSERT INTO uli_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Semal ngo far chol family la yal mele be kkel yal hattohar ngali. ");
INSERT INTO uli_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Iwe ngo te tugul semal le ye hachangi temal hare sil, mo imoy ila ye tafel le be mel bo re dabeyey. Iwe ngo te tugul semal le ye hachengi lol tarmal hare tarfefel mo imoy ila ye wol tafel le be mel bo re dabeyey. ");
INSERT INTO uli_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Semal le yebe te hasi yal krud sa dabeyey, ngo ye tafel le be mel bo re dabeyey. ");
INSERT INTO uli_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Semal le molwal chog llufulyal mele ye yedamgili, ila ngo be far ppung tangi molow la yal, iwe ngo semal le yebe fangloh yal nngas bo yagliyey ila be yoh ngali molow. ");
INSERT INTO uli_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Semal le be hakkola ngalugmi, ila ngo ye wol hakkola ngalyey, ngo semal le yebe hakkola ngalyey, ngo ye hakkola ngal yeramtala ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Semal le yebe hakkola ngal semal profeta bo fael mala semal profeta molwe, ngo be wol yoh ngali payel hachigchig la yar profeta. Ngo semal le ye hakkola ngal semal yarmat le ye momay bo fal mala ye momay yeramtawe, ngo yebe wol yoh ngali payel hachigchig la yar rechokla re momay. ");
INSERT INTO uli_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Be tugul lal dipmi, le semal le yebe holu chael semal rechoka ye hartal totol mo luwulur meka choluway bo fael mala iy semal choluway, ila ye tugul bo yor yal payel hachigchig le be yoh ngali.” ");
INSERT INTO uli_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yodwe Jesus ye moll yal kangalur chowe seg mo rumal meka rebe foru ngo yesa chuy mo loboswe sa loh bela haskun ngo ye foloy fedal irel haplom kowe ye harpa loboswe. ");
INSERT INTO uli_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yodwe ye mel Johannes Baptista lal kalbus, ngo sa rongrong kofal mokwe Kristus ye foforu, ngo sa hagloyurloh tot mokwe re dabeyal irel. ");
INSERT INTO uli_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iwe re sala kasiya Jesus bo, “Kangalugmem, gel yeramtawe Johannes ye sor le be budoh, hare ye chil mel semal le ila yeramtala habe widi?” ");
INSERT INTO uli_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus sa hatefali le ye sor bo, “Ha tefael loh ha sala kangalu Johannes meka hasa rongrong mo meka hasa wiri: ");
INSERT INTO uli_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","rechoka re metafis ila resa wiri formel, rechoka ye mes pecher ila sa mmal le rebe darloh, rechoka re mesel pekel ila sa chuy mo uwor, cho talengbat ila resa ma rongrong formel, chomes ila resa molow tefael, ngo Hapatpat Momay we ila resa foloyu ngalir mael hafohoy. ");
INSERT INTO uli_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ifa lepal momayel deper rechokla yete yeyewal deper irey!” ");
INSERT INTO uli_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yodwe resa loh mokwe re dabeyel Johannes, ngo Jesus yesa kapta kofal Johannes ngalir buwa we iwe leper: “Yodwe ha loh irel Johannes loboswe ye tolmay loh, ngo meda mele ha luluwaley le ha bela wiri? Seyal fadil le yaeng ye fifildi fedaley? ");
INSERT INTO uli_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Meda mele ha loh ha bela wiri? Semal mal le ye mengag irel mengag kowe ye kamdidiy? Rechokla rema mengag tappel mengag kala ye kamdidiy, ila rema mel lal imw kowe imwer tamol! ");
INSERT INTO uli_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ha kangaluyey, meda iy mala ha loh ha bela wiri? Semal profeta? Ila sengal, ibe kangalugmi le hasa wiri semal le ye tagiyet mo imwol semal profeta. ");
INSERT INTO uli_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Johannes mele babior we ye santus ye kapta kofal we ye sor bo: ‘Deus ye sor bo, ibele fangloh re hagloy le yai be hamoloh mo imoam bo bela hafle mala yalepam.’ ");
INSERT INTO uli_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ibe hatugulu ngalugmi le Johannes Baptista ila ye tagiyet mo imoal pangal yarmat lal faileng. Ngo ligdi bo yeramtala ye hartal totol mo irel mala Lamliyel Laeng ila ye tagiyet mo imoal Johannes. ");
INSERT INTO uli_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yodwe Johannes ye fofoloyu molwe yalol Deus yee, la holadoh igla ngo mala Lamliyel Laeng, ila sa kkel yal hafohoy irel yar rechoka fedeg ngali, ngo rechoka re fedeg ngali, ila resa luluwaley le rebe hasi bo rebe lamliloh. ");
INSERT INTO uli_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Panger profeta kowe mo Hatobtob we yael Moses yee, la holadoh Johannes ngo re kapta chog kofal mala Lamliyel Laeng; ");
INSERT INTO uli_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","hare habe mechal le habe chepar irel mekla yalor, ila ngo Johannes mele Elijah, we re faesul sor yal be budoh. ");
INSERT INTO uli_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ha hasuy talengmi, hare yor talengmi! ");
INSERT INTO uli_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Igla, meda mele ibe haweweli ngalir yarmetal ralleka? Resa rol wochog sibis yalwich kowe re rol maroro fedal loboka liliyel market, le rema tteydoh yarmat iyang. Sibis ila re bele ttawul ngalir ikla sibis le re bele sor bo, ");
INSERT INTO uli_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Hasa mosikel rraey ngalugmi, ngo hami ha temechal barog! Hasa yewaw tang ngalugmi, ngo hami ha temechal tang!’ ");
INSERT INTO uli_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yodwe yela budoh Johannes ngo yete ma yul wine, ngo yema supiy hal bo yal maligach, ngo pangal yarmat ngo resa sor bo, ‘Ye mel semal moniyan uwol!’ ");
INSERT INTO uli_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yodwe yela budoh molwe Layur Retalop, ngo ye ma mongoy ngo yema yul le ye hafedeg ngalir chog pangal yarmat, iwe ngo resa sor bo, ‘Ha kemahoy mal le! Ye toa hamongolap ngo ye toa yul wine. Ye hamareyar ngalir chol hateyel paliyel raeg mo cho tayikof!’ Mala repiyel Deus ila sa llah le ye katos mo irel mekla resa wiri le ye budoh mo iyang.” ");
INSERT INTO uli_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yarmetal haplom kala Jesus ye foru dolpal kkemal kala yal mo iyang, ila re temechal bo rebe tagul tang molfidir, iwe sa kkaftoroy ngalir chol haplom kowe. ");
INSERT INTO uli_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ifa lepal hafohoy la bele hola Chorazin! Ngo be wol ifa lepal hafohoy le be holahmi hami yarmetal Bethsaida! Hare ye wochog mala kkemal kala isa foru ngalugmi mele iforu mo woal Tyre mo Sidon, ila ngo sa ssulay chog yael yarmat mengag irel tutuw ngo re hamormordah felang uwor, rebe kawraloh le resa tagul tang molfidir. ");
INSERT INTO uli_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ibe hatugulu ngalugmi le yodla Rael Tatelal Hapatpat, ngo Deus yebe kkel tot yal fahor yarmetal Tyre mo Sidon mo imomi. ");
INSERT INTO uli_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Iwe ngo gel Capernaum! Ho dipli hobe hatagitahdah hobe hola laeng? Deus yebe ppedugdiy Infiyerno! Hare ye wochog mala kkemal kowe iy foru ngalugmi mele iy wol foru mo woal Sodom, ila ngo Sodom ila be chil mel chog igla! ");
INSERT INTO uli_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Habe hatugulu mo lal dipmi le yodla Rael Tatelal Hapatpat, ngo Deus be kkel tot yal fahoy Sodom mo imoami!” ");
INSERT INTO uli_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Irel yodla ngo Jesus sa sor bo, “Temay, Samol wol laeng mo wol talop! Hosa hachigchig bo hosa kkewar ngalir rechokla rete sallap mala ho lebagil tangir rechokla re repiy ngo re sallap. ");
INSERT INTO uli_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Temay, gel ho dipli bo yebe weldoh meka le be iye sengal. ");
INSERT INTO uli_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Mala Temay ye fang ngalyey pangal meka. Tor semal le ye gola mala Lol bo halachog mala Temal, ngo tor le ye gola mala Temal bo halachog mala Lol, mo rechokla mala Lol sa duwler bo yebe hagolal ngalir mala Temal. ");
INSERT INTO uli_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ha budoh irey pangami rechokla hasa peyagus irel kekal mekla ye cchow, bo Ngang ibe fang ngalugmi hasoso. ");
INSERT INTO uli_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ha hasi weres ka yai habe yetedah uwomi, ngo hasa kay mo irey bo Ngang ila iy maluluy, ngo ye totol mele depey, ila ngo habe wiri liliyel yami hasoso. ");
INSERT INTO uli_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mala ibele yetedah uwomi ila ye mechrag ngo ye ppal.” ");
INSERT INTO uli_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Te ssulay mo wol miril, irel sew Sabbath, ngo Jesus mo mokwe re dabeyal re dedarloh luwul tot milayel wheat. Mokwe re dabeyal resa ffichfich sibol wheat kowe resa mongoy bo resa rol mesel koloh. ");
INSERT INTO uli_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Yodwe Pharisees kowe re wiri molwe re foforu ngo resa kangalu Jesus bo, “Kemahoy, ye tafel ngal Hatobtob we yach le meka re dabeyem rebe foru tappel mala resa foru rall Sabbath!” ");
INSERT INTO uli_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus yesa hatefali le ye sor bo, “Ha ted yawli mwo kaptal molwe David ye foru irel yodwe iy mo mokwe choluwal re mesel yar koloh iyang? ");
INSERT INTO uli_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Iy mo mokwe choluwal re bulong lal imw we imwel Deus, re sala hangi flowa we re tap maligach ngal Deus, le ye tafel ngal Hatobtob bo halachog temarong ka mele ma yoh le rebe ma hangi. ");
INSERT INTO uli_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ha ted yawli mo irel Hatobtob we yael Moses, le pangal Sabbath ngo temarong ka rema hatawsi Hatobtobol Sabbath mo lal Templum we, ngo re tema tayikof iyang? ");
INSERT INTO uli_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ibe kangalugmi le yor mele ye mel iga le ye palleng pelal mo imoal Templum we. ");
INSERT INTO uli_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Babior we ye Santus ye sor bo, ‘Mala idipli ila momayel hagiyeg, ngo te mael kala hama tape maligach.’ Hare ha gola fael mele, ngo ha towe hatugulu yar tayikof sibis le tor mele re hadre; ");
INSERT INTO uli_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","bo mala Layur Retalop mele iy Samol le ye lamli Sabbath.” ");
INSERT INTO uli_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus ye chuy mo loboswe yesa loh irel sew imwel ttey kowe, ");
INSERT INTO uli_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","le ye mel semal mal iyang le ye mes sere mala paol. Ye mel tot yarmat lobowe le re luluwaley bo rebe ffaeg derel Jesus. Iwe resa kasiya bo, “Ifa sengal ye tayikof ngal Hatobtob le yach le sibe hachuchuy tomay mo uwor yarmat rall Sabbath?” ");
INSERT INTO uli_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus yesa hatefali ngo sa sor bo, “Itey semal hami le hare ye halsemal lol saaf ngo la wol Sabbath, ngo yesa ppunglong lal sew lib le ye yod, ngo iy bela te bidiy ye bela yetedah? ");
INSERT INTO uli_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ye palleng pelal semal yarmat mo imol semal saaf! Ila Hatobtob we yach ye teladgich le sibe tipingi semal wol Sabbath.” ");
INSERT INTO uli_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iwe sa kangalu mal we ye mes sere paol bo, “Hawweleloh mala poam.” Mal we ye haweleloh molwe paol sala momayloh le sa tappel chog rewe sere. ");
INSERT INTO uli_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iwe Pharisees kowe resa loh re sala luluwaley mele rebe foru ngo sa yoh le rebe llimeseloh Jesus. ");
INSERT INTO uli_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yodwe Jesus yela rongrong kofal molwe resa luluwaley rebe faor ngali, ngo sa chuy mo loboswe yesa loh. Ye cholop yarmat le resa dabey. Ye hachuya yar tomay panger rechoka re tomay, ");
INSERT INTO uli_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","iwe ngo Jesus yesa kangalur bo tor semal le rebe kangalu kofal. ");
INSERT INTO uli_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ye faor mele bo yebe llahloh le ye katos mokwe yalol Deus we profeta Isaiah ye sor bo: ");
INSERT INTO uli_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iye boy we yai we ihatugulu, le ihachangi, ngo ye fel depey irel. Ibele fangdiy Espritu Santus la yai uwol, ngo ye bele kapta loh mekla isa hatugulu ngalir chol sere mo sere lam. ");
INSERT INTO uli_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ye towe hapaliyel hare ye ttawul ngalir yarmat, hare ye foloy fedal lal yalap le be palleng yalol. ");
INSERT INTO uli_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ngo ye towe hopiyloh seyal fadil le sa bbordiy, hare ye gululoh bbulul sew habul le ye yaliyel mala bulal. Yebe tabochog yal yengang yee, la hola yodla pangal formel ngo sa fel. ");
INSERT INTO uli_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ngo pangal yarmat ngo re bele yetedah deper uwol.” ");
INSERT INTO uli_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Iwe ngo tot yarmat resa hasidoh semal mal irel Jesus. Mal we ila ye metafis ngo tema hapatpat bo yor moniyan uwol. Jesus sa hachuya yael mal we tomay, iwe sala yoh le ye kapatpat ngo ye wiri formel. ");
INSERT INTO uli_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Panger rechokwe we ngo resa lluwdah irel molwe Jesus sa foru. Iwe resa kasiy le re sor bo, “Te iye mal we Lol David?” ");
INSERT INTO uli_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yodwe Pharisees kowe re la rongrong molwe ngo resa sor bo, “Yema hachuchuy moniyan, bo Beelzebul le yar tamol mele ye fang kkelal bo be foru.” ");
INSERT INTO uli_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus ye gola luluwal kowe yar, iwe yesa kangalur bo, “Chol sew fulu le rebe harere resa rol fedeg fengal, ila towe ssulay yar mel. Ngo sew haplom hare sew haleng le rebe harere resa rol fedeg fengal ila rebe taroproploh. ");
INSERT INTO uli_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Hare chol sere re fedeg ngal chol sere mo irel mala Lamliyel Satan, ila ngo sa faesul mehalhal mala lamliyal, ngo towol ssulay ngo bele taroproploh. ");
INSERT INTO uli_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hami ha sor bo iy ma hachuchuy moniyan bo fal mala Beelzebul mele ye fang kkeley bo iy be foru. Ila ngo itey le ye fang kkeler mekla wochilami bo rebe hachuchuy moniyan? Mekla re foforu mele sa hatosiya le hami ha tabung! ");
INSERT INTO uli_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yeb, te ila sengal, te Beelzebul mele ye fang kkeley bo Espritu Santus le yael Deus mele ye fang kkeley bo ibe hachuchuy moniyan. Ila mala sa hatosiya le mala Lamliyel Deus ila sa faesul mel iremi. ");
INSERT INTO uli_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Tor semal le be yoh ngali le be hatawsilong imwel semal mal le ye kkel, yesa hasiloh mekla lital. Yebe moal fargu mwo mal we ye kkel, ila ngo sa moch yoh le be hachwera lital imw we. ");
INSERT INTO uli_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Semal le te ppiliyey, ila ngo ye hatohar ngalyey; semal le yete tipingiyey irel hatteyel yarmat, ila ngo iy ye ketaropropar yarmat. ");
INSERT INTO uli_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ila fal le ikangalugmi bo: te tugul sew tayikof le semal yarmat ye foru hare ye sor hare re hapatpat tayikof loh irel Deus, ngo be chuy molfidel; iwe ngo semal le yebe hapatpat tayikof loh irel Espritu Santus, ngo towe chuy molfidil. ");
INSERT INTO uli_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Semal le ye kapta sew formel le ye hattohar ngal mala Layur Retalop, ngo be chuy fael molfid we sa foru: ngo semal le ye kapta sew formel le ye hattohar ngal Espritu Santus, ngo towe chuy fael molfid we sa foru — igla sa loh le tor siyal. ");
INSERT INTO uli_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Hare be momay uwal sehay ire ila ngo ire la ila ye momay. Hare be tayikof ire la, ngo be tayikof mekla uwal. Sima gola kofal sehay ire mo irel igegel mekla uwal. ");
INSERT INTO uli_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hami parchoyoh kala — be ifa sengal yami kapta mekla ye momay le hami ha rol tayikof? Bo meka sima kaptawey mo irel yewach, ila ikla mekla ye ssoeg lal bulach. ");
INSERT INTO uli_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Semal yarmat le ye momay ye hasidoh mekla ye momay mo irel momay kala ye kekateyili; ngo semal le ye tayikof ila yebe hasidoh mekla ye tayikof mo irel tayikof kala ye kekateyili. ");
INSERT INTO uli_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Be tugul lal dipmi le bela hola yodla Rael Tatelal Hapatpat, ngo semal ngo ye bele hamdefa fael pangal hapatpat kala ye kapta le tor pelal. ");
INSERT INTO uli_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mekla ha sor mele rebe tapeli irel yar hatugulu kofmi hare ha bung hare ha tabung.” ");
INSERT INTO uli_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iwe ngo tot mokwe sensel Hatobtob we mo tot Pharisees re kangalu Jesus bo, “Sensey, ha dipli habe wurug le hobe foru sew kkemal.” ");
INSERT INTO uli_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus sa kangalur bo, “Yesa kkel hemas tayikofer yarmat fael mwole, bo re tay talenga yalol Deus! Ha dipli habe wiri yai foru sew kkemal? Yeb! Kkemal la be yoh le habe wiri ila tappel kkemal we Deus ye foru ngali profeta Jonah. ");
INSERT INTO uli_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah iwe solral yal mel lal siyal raswe, le be ila sengal mala Layur Retalop le be wol solral le be mel fael bol. ");
INSERT INTO uli_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yodla Rael Tatelal Hapatpat, ngo yarmetal Nineveh re bele sudah ngo re bele kapta yami tayikof, bo fael mala ir re tagul tang molfidir irel yodwe re rongrong yael Jonah foloy; ngo ibe kangalugmi le yor mele ye mel iga le ye tagiyet mo imol Jonah. ");
INSERT INTO uli_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yodla Rael Tatelal Hapatpat, ngo Queen we wol Sheba bele sudah ngo bele sor yami tayikof. Bo fal mala ye sala budoh mo wol mala faluyal irel King Solomon bo be talenga yal folol harepiy. Ngo ibe kangalugmi le yor mele ye mel iga, le ye tagiyet mo imol Solomon! ");
INSERT INTO uli_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Yodla be chuy semal moniyan mo uwol semal yarmat, ngo bele loh sala ffag fedal solboy le be hasoso mo iyang. Hare tor solbos le ye wiri, ");
INSERT INTO uli_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ngo bele iy chog yal sor bo, ‘Ibele tefael loh irel molwe imwey. Iwe yesa tefael loh irel molwe imwal sala wiri le tor le ye mel iyang, ngo ye kilil, ngo pangal formel ngo ye fel igegal. ");
INSERT INTO uli_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yesa loh sala fesangurdoh fismol moniyan le sa kkel tot yar tayikof mo imol, resa budoh paoy lobowe. Iwe ye bele la paoy yaramtawe le bele kkel yal tayikof mo imol molwe metamo. Iye mele bele wel ngalir rechokla re tayikof raleka.” ");
INSERT INTO uli_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus ye chil kapatpat ngalir yarmat, ngo resa budoh mokwe wol bisil mo molwe sil. Resa su ligtam ngo resa kasiy hare be yoh le rebe hapatpat ngal Jesus. ");
INSERT INTO uli_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Iwe semal mo lobowe yesa kangalu Jesus bo, “Kalloh, molwe solom mo mokwe wol bisim ikla re su ligtam le re dipli rebe hapatpat ngalug.” ");
INSERT INTO uli_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus sa hatefali ngalir ngo sa sor bo, “Itey mele seley? Itey mele bisiy?” ");
INSERT INTO uli_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iwe yesa sid ngalir mokwe re dabeyal ngo sa sor bo, “Ha kaladoh! Ika meka seley mo wol bisiy! ");
INSERT INTO uli_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Semal le ye foru mekla mala Temay wol laeng ye dipli bo yebe foru, ngo ila mala bisiy, mo mengay, mo seley.” ");
INSERT INTO uli_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Rallawe chog ngo Jesus yesa ligdi imw we, yesa loh lengchel laom we sala marodiy bo yebe foloy. ");
INSERT INTO uli_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ngo buwa we resa rol longbaloh, yesa chudah yuchul seyay boat sala mel yuchul boat we, iwe ngo re sa su buwa we iwe leper wol ngachel laom we. ");
INSERT INTO uli_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ye cholop mekla ye kangalur le ye teptap fiyongol hawewe. “Ye mel semal mal le ye buyoy bela fadgu milay la yal. ");
INSERT INTO uli_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yodwe yela hamro faesol ire kowe yal fedah, ngo tot mo iyang ye ppungdiy lal yalap, ngo mael yeyal resa hangiloh. ");
INSERT INTO uli_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Iwe ngo tot ila ye ppungdiy lobos kowe ye cholop feas iyang, le ye hal sugfed bol le ye mel iyang. Ila te ssulay ngo sa tumul bo te masosol bol la ye mel iyang. ");
INSERT INTO uli_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iwe ngo yela kkarloh yaal ngo sa habatbetaloh fedah kowe ye moch tumul, bo te yodoloh mekla wahral luwul bol. ");
INSERT INTO uli_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Iwe ngo fedah kowe tot ye ppungdiy luwul ire kowe yor chil. Resa tumuldah ire kowe yor chil sala totawoloh fedah kowe. ");
INSERT INTO uli_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Iwe ngo tot ye ppungdiy lobo kowe ye momay bol iyang, yela pallengdah sala yor uwal. Yor ika kasubguy uwal, ngo yor ika kaweleg uwal, ngo yor ika kasilig uwal.” ");
INSERT INTO uli_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Iwe ngo Jesus sa hasiyaloh yal hapatpat le ye sor bo, “Ha talenga hare yor talengmi!” ");
INSERT INTO uli_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iwe ngo mokwe re dabeyel Jesus resa budoh irel resa kasiya bo, “Meda mele homa teptap fiyong le hobe hapatpat ngalir yarmat iyang?” ");
INSERT INTO uli_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus sa hatefali ngo sa sor bo, “Repiy la ye llebag mo irel mala Lamliyel Laeng, ila sa yoh ngalugmi iwe ngo ted yoh ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bo yeramtala yor formel irel, ila bele cholop tot mala rebe ngaley sala far cholop hemas ngali. Ngo yeramtala tor formel irel, ila lepal sugfed le ye mel irel ngo rebe hastangi. ");
INSERT INTO uli_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Fal mele iteptap fiyong ka irel yai hapatpat ngalir, ila mil mala rema kalloh ngo re tuwiri, rela hataleng ngo re tarongrong, ngo re temedaf. ");
INSERT INTO uli_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bo be llah le katos mokwe profeta Isaiah ye sor irer: ‘Habe talenga, talenga, ngo ha towe medaf, ngo habe kalloh, kalloh, ngo tor mele habe wiri, ");
INSERT INTO uli_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","bo fal mala yesa buch lal chimmi, ngo hasa talengbat ngo ye pelat metami. Hare te ila sengal ngo habe wiri ngal metami, ngo ha rongrong ngal talengmi, ngo ha bele medaf, ngo ha bele tagul ngalyey bo ila molwe Deus ye sor. Iwe ngo Ngang ibele hachuya yami tomay.’ ");
INSERT INTO uli_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Iwe ngo hami, ifa lepal yami yolbuw! Mekla metami ye wiri formel, ngo mekla talengmi ye rongrong. ");
INSERT INTO uli_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ibe hatugulu ngalugmi le ye cholop profeta, ngo ye wol cholop mekla Lol Deus le ye kkel yar dipli bo rebe wiri mekla hasa wiri ngo ye temmal, ngo re dipli rebe rongrong mekla hami hasa rongrong, iwe ngo re tarongrong. ");
INSERT INTO uli_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ha hasuy talengmi bo habe medaf irel fael molwe fiyongol chol fadol milay we. ");
INSERT INTO uli_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Rechokla re rongrong kofal mala Lamliyel Laeng ngo re temedaf, ila re wochog faesol ire kowe ye ppungdiy lal yalap. Moniyan ye budoh chog yesa hasiloh mala yalol Deus mo lal deper. ");
INSERT INTO uli_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Faesol ire kowe ye ppungdiy luwul feas, ila re wochog rechoka re rongrong mala yalol Deus ngo ye rraey lal deper iyang. ");
INSERT INTO uli_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Iwe ngo yete ssulay ngalir bo yete mmoch long lal deper. Ngo yodla bela holar weres mo hafohoy bo fael mala yalol Deus, ngo resa tahchaloh mala yalol Deus. ");
INSERT INTO uli_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Faesol ire kowe ye ppungdiy luwul walwol kowe yor chil, ila re wochog rechoka re rongrong mala yalol Deus, iwe ngo yar merahrah irel molow le yar wol talop mo yar hachangi mekla mmaler, mele sa totawoloh mala yalol Deus sala tor loh uwar. ");
INSERT INTO uli_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Iwe ngo faesol ire kowe ye ppungdiy sala tumuldah mo luwul bol kala ye momay, ila re wochog rechokla re rongrong mala yalol Deus ngo re medaf iyang, sala yor uwar, le tot ikla kasubguy, ngo tot ikla kaweleg, ngo tot ikla kasilig.” ");
INSERT INTO uli_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus sa wol kangalur sew fiyong le ye sor bo: “Mala Lamliyel Laeng ila iye sengal. Ye mel semal mal le yela fadgu milay la yal ngal fedah kowe ye momay. ");
INSERT INTO uli_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lubungul seral le sa pangal yarmat ngo resa masor, ngo semal cho tayikof sa budoh yesa fod fadil luwul wheat kowe lal milay we yal mal we iwe ngo yesa loh. ");
INSERT INTO uli_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yodwe yela pallengdah fedah kowe le sa buyoy uwal, ngo sa wol la tumuldah fadil kowe. ");
INSERT INTO uli_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Boy we yael mal we yal milay we sa budoh irel sa kangalu bo, ‘Fedah kowe ye momay mele ho fadgu ngal milay we yam. Ila ngo iya mele yela budoh fadil ka mo iyang?’ ");
INSERT INTO uli_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Iwe ngo yesa sor bo, ‘Semal cho tayikof mele ye foru mele.’ Iwe resa kasiya bo, ‘Ho dipli bo ha bela pulngudah fadil kala?’ Iwe ngo yesa sor bo, ");
INSERT INTO uli_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Yeb, habe pulngudah fadil kala, ngo ha bele terah fengalidah mo tot fedah kala. ");
INSERT INTO uli_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ha ligdi bo be tumul sew dah wheat kala mo fadil kala yee, yela hola yodla yebe masow wheat kala iyang. Iwe ngo isa moch kangalur chol yengang kala rebe tarhadah mwo fadil kala, ngo resa hohoyu fengali le be sew mo sew pulgul resa fisgi. Iwe ngo re moch hatteyili fengali wheat kala resa yetolong lal soko we yai.’” ");
INSERT INTO uli_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus sa wol kangalur sew fiyong le ye sor bo: “Mala Lamliyel Laeng ila iye sengal. Semal mal ye hasi sefaes faesol mustard sala fadgu wol milay la yal. ");
INSERT INTO uli_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ila faesol ire la ye hartal wechich mo luwul pangal faesol ire. Iwe ngo yela tumuldah sala mel le ye hartal palleng mo luwul pangal ire. Iwe sala mel le sehay ire le mael yeyal rema budoh ffaor hafter wol mekla ral.” ");
INSERT INTO uli_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus ye wol kangalur sew fiyong le ye sor bo, “Mala Lamliyel Laeng ila iye sengal: Semal fefel ye kak habboloh sa polongal flowa sala habolaho pangal flowa we.” ");
INSERT INTO uli_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus ye teptap fiyong bo yebe kapta pangal meka ngalir buwal yarmat kowe iwe leper; tor mele yema kangalur le yebe te teptap fiyong iyang. ");
INSERT INTO uli_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ye foru mele iye sengal bo bela llah le ye katos mokwe profeta kowe re sor: “Iy be ma teptap fiyong irel yodka iy be ma hapatpat ngalir; iy bele kangalur tot formel le tor le ye gola, mo irel yodwe chog ye subdoh faileng le yee, la holadoh igla ka.” ");
INSERT INTO uli_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yodwe Jesus ye ligdir buwa we sa bulong yilim, ngo mokwe re dabeyal resa budoh irel resa kangalu bo, “Kangalugmem fael molwe fiyongol fadil kowe wol milay we.” ");
INSERT INTO uli_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus sa kangalur bo, “Yeramtawe ye hamro fedah kowe ye momay wol milay we, ila iy mele molwe Layur Retalop; ");
INSERT INTO uli_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","milay we ila faileng le; fedah kowe ye momay ila rechokla re mel irel mala Lamliyel Laeng; fadil kowe ila rechokla re tayikof; ");
INSERT INTO uli_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","yeramtawe ye tayikof we ye hamro fadil kowe ila Moniyan. Molwe yodol yal doh milay we ila miril faileng. Iwe ngo chol yengangel milay we, ila angelus kala Lol Deus. ");
INSERT INTO uli_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yodla re bela hatteyili fadil kowe ngo resa fisgi, ila ye hafedeg ngal chog yodla be budoh miril faileng iyang: ");
INSERT INTO uli_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","mala Layur Retalop bele hagloyurloh angelus kowe lol, bo re bela hatteyili fengalir panger rechokla rema hasngal yarmat molfid mo pangerloh ikla rema faor tayikof, ");
INSERT INTO uli_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","bo rebe ppedirlong luwul yaef, irel lobosla re bela rol tetang ngo re ketangtingi mekla ngir mo iyang. ");
INSERT INTO uli_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iwe ngo mekla Lol Deus ila re bele werloh le re bele wochog ddolol yaal, mo irel mala Lamliyel mala Temer. Ha talenga hare yor talengmi! ");
INSERT INTO uli_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mala Lamliyel Laeng ila iye sengal. Semal mal yela wiri sew mokwe ye kkel yal chang le tor le ye wiri mo woal sew milay. Yesa lebaloh le yesa momay depal. Yesa loh chog sala tap chuway pangal mekla lital, yesa tafael yesa chuwayiloh milay we. ");
INSERT INTO uli_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Iwe ngo mala Lamliyel Laeng ila wol iye sengal. Semal mal le ye feffag fedal yises kowe ye kamdidiy, ");
INSERT INTO uli_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ngo yodwe yela wiri sew le ye kkel yal momay, ngo yesa loh sala tap chuway pangal mekla lital, iwe sala chuwayi yises we. ");
INSERT INTO uli_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Iwe ngo mala Lamliyel Laeng ila iye sengal. Tot chol fita rela wug ngo ye cholop metmetal yig le re hola. ");
INSERT INTO uli_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yodwe yela ssog wug we yar ngo resa yafsi ngal fuluy. Iwe resa marodiy resa hayagi fetangi yig kowe ye momay, mo ikowe ye tayikof. Resa yetolong ikowe ye momay lal chug, ngo re ppedaloh ikowe ye tayikof. ");
INSERT INTO uli_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Be iye sengal irel yodla be budoh miril faileng: angelus kowe re bele loh re sala hasir rechokwe re tayikof mo luwullur ikowe re momay. ");
INSERT INTO uli_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Resa ppedirlong wulyef ngo re bele rol tetang ngo re ketangtingi fadaley mekla ngir.” ");
INSERT INTO uli_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus ye kasiyar bo, “Hasa medaf irel meka?” Iwe ngo resa sor bo, “Ngo.” ");
INSERT INTO uli_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iwe yesa sor bo, “Fael mele ila panger mokwe sensel Hatobtob we resa mel bo re dabeyey mo irel mala Lamliyel Laeng, ngo resa wochog semal yarmat le ye mel sew imw imwal le yesa girawey mekla yesa ssulay mo ikala ye tefoy mo lal lobola yema yitet lital iyang.” ");
INSERT INTO uli_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yodwe ye moll yael Jesus kangalur rechokwe fiyong kowe ngo yesa ligdi lobowe ");
INSERT INTO uli_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","sa tafael ngal molwe haplamol sala foloy lal imwel ttey we, ngo rechokla re rongrong mokwe ye sor ila re lluwdah iyang. Resa kasiy bo, “Iya mele yela hasi repiyal mo iyang? Ngo, ifa sengal kofal kkemal kala yal? ");
INSERT INTO uli_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Te iye iy molwe lol sallap we? Te Maria mele sil, ngo te James, mo Joseph, mo Simon, mo Judas, makawe wol bisil? ");
INSERT INTO uli_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ngo te panger mokwe wol mwengal ngo rema mel wol haplom le? Ila ngo iya lobole yela gola meka mo iyang?” ");
INSERT INTO uli_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iwe re sala te kadagiloh. Jesus sa kangalur bo, “Pangal lobos ngo rema hassaror profeta mo iyang. Halachog mekla yarmetal faluyel profeta we, mo wol yarmetal mele re tema hassaro.” ");
INSERT INTO uli_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Te cholop kkemal kala ye foru ige bo fael mala tor yar tugul. ");
INSERT INTO uli_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Irel yodla ngo Yerodes Antipas we tamol wol Galilee sa rongrong kofal Jesus. ");
INSERT INTO uli_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yesa kangalur tamol kowe wocchilal bo, “Yeramtala ila Johannes Baptista le sa molow tefael mo irel maes. Ila fal le yor kkelal le be ffaor kkemal.” ");
INSERT INTO uli_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yerodes molwe ye sor le rebe ddorfi Johannes resa hohoyu, resa yetolong lal kalbus. Ye foru mele le fael Herodias we ril Philip we bisil. ");
INSERT INTO uli_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bo ye mel sew yad le Johannes Baptista ye kangalu Yerodes bo, “Ye tafel le hobe rili Herodias!” ");
INSERT INTO uli_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Iwe Yerodes sa luluwaley le be llimeseloh, ngo ye metagur Jews kowe bo re yitili Johannes le iy semal profeta. ");
INSERT INTO uli_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yodwe yela hola rallawe bungul yal subdoh Yerodes, ngo lefechig we lol Herodias yesa barog mo imor chol tteydoh we. Yesa momay depel Yerodes ngali, ");
INSERT INTO uli_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ngo yesa kangalu bo, “Isa hatugulu ngalug le te tugul mele hobe dongor ngo ibe fang ngalug!” ");
INSERT INTO uli_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Molwe sil sa kangalu lefechig we mele yebe dongor. Iwe ngo iy, sala sor bo, “Fang ngalyey chog igla molwe chemel Johannes Baptista le be mel lal sew plate!” ");
INSERT INTO uli_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sa tayikof depel king we, ngo ligdi bo fael pedal hapatpat we yesa hatugulu mo imor panger rechokwe ye fesangurdoh, mele yesa sor bo rebe ngaley lefechig we molwe ye dodongor. ");
INSERT INTO uli_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iwe yesa sor bo re bela supiyloh molwe uyel Johannes mo lal kalbus. ");
INSERT INTO uli_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Re sala hasidoh molwe chemel Johannes le ye mel lal sew plate, resa ngaley lefechig we, ngo iy yesa hasiloh irel molwe sil. ");
INSERT INTO uli_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mokwe re dabeyel Johannes resa budoh hasi molwe porgol re sala leba. Ngo resa loh re sala kangalu Jesus. ");
INSERT INTO uli_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yodwe Jesus yela rongrong molwe kofal Johannes, ngo sa dage seyey boat sa loh solbos le tor loh yarmat iyang sala iy loh chog. Yarmat rela rongrong molwe yesa loh ngo resa ligdi mokwe haplomor resa dar wol fuluy resa meraloh. ");
INSERT INTO uli_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesus sa dediy mo yuchul boat we ngo yodwe yela wiri leper buwa we ngo sa ddidoh yal fahor, iwe yesa hachuya yar tomay rechokwe re tomay mo luwulur. ");
INSERT INTO uli_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yela llefhafdoh, ngo mokwe re dabeyel Jesus resa budoh irel resa kangalu bo, “Hole hamderar yarmat bo re bele loh, bo re bela chuway fedal haler luwul haplom kalay.” ");
INSERT INTO uli_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iwe Jesus sa kangalur bo, “Heramo rete loh, hala fang haler hami!” ");
INSERT INTO uli_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iwe ngo resa hatefali ngo resa sor bo, “Hal limay flowa mo rumal yig mele ye mel.” ");
INSERT INTO uli_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus sa sor bo, “Ha hasidoh irey.” ");
INSERT INTO uli_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yesa kangalur yarmat bo rebe marodiy wol fadil kowe; iwe yesa hasi flowa we limay mo yig we rumal, sa kaladah woal laeng, ngo sa kangalu Deus yal hachigchig. Yesa dipi flowa kowe sa ngaler mokwe re dabeyal, ngo mokwe re dabeyal resa yildi ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pangal yarmat ngo re mongoy, ngo re madloh iyang. Iwe ngo mokwe re dabeyel Jesus resa hateyili fengali mokwe lutgul, ngo ye ssog seg mo ruwow bachebach iyang. ");
INSERT INTO uli_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Leper mal le re mongoy, ila rebe lemngeras le rete papa fefel mo yalwich. ");
INSERT INTO uli_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesus ye kangalur mokwe re dabeyal bo rebe dage boat we resa hamoloh rel laom we sere, irel yodwe ye chil kekalahor yarmat. ");
INSERT INTO uli_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wol miril yal halhor yarmat, ngo sa bidah wol sew tagitat bo bela mapel. Yela llefhafdoh, ngo sa Jesus loh chog lobowe. ");
INSERT INTO uli_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yela yodla ngo sa ddaw loh boat we. Sa kkel doh yaeng, ngo law sa kekalluya fedaley boat we. ");
INSERT INTO uli_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Llepdal suluw ngal wolow kolok lemerral, ngo Jesus sa budoh irel mokwe re dabeyal le ye dedardoh wol taed. ");
INSERT INTO uli_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yodla rela wiri le ye dedarloh wol chal, ngo sa kkel yar rusmes. Resa tawulagili luwol yar rusmes le re sor bo, “Semal yalus!” ");
INSERT INTO uli_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yodla chog ngo Jesus sa maliliy ngalir le ye sor bo, “Ha haakkela lal dipmi, Ngang mele, ha towe motog!” ");
INSERT INTO uli_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Iwe Pedrus sa maliliy ngo sa sor bo, “Samol, hare tos le gel mala ngo hosa ffesanguyey bo ibe darwol taed isa buyoy irem.” ");
INSERT INTO uli_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus sa sor bo, “Budoh!” Iwe Pedrus sa dediy mo yuchul boat we sa darloh irel Jesus le ye dar wol taed. ");
INSERT INTO uli_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngo yodwe Pedrus yela lulwaleloh kkelel yang we, ngo sa budoh yal motog, ngo sa chaep yal duddubloh luwul taed. Yesa tawul loh le ye sor bo, “Samol, hadorayey!” ");
INSERT INTO uli_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesus sa cchangloh sala ddorfi ngo sa kangalu bo, “Ye hal sugfed yam tugul! Meda mele hola ye yeyewal iyang?” ");
INSERT INTO uli_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Resa chudah yuchul boat we ngo yela malululoh. ");
INSERT INTO uli_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Iwe ngo mokwe re dabeyal we re mel yuchul boat we resa hasrowu Jesus. Ngo resa sor bo, “Tos bo gel molowe Lol Deus!” ");
INSERT INTO uli_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Resa supiloh laom we re sala budoh wol Gennesaret ");
INSERT INTO uli_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ngo yarmatal lobowe re gula Jesus. Iwe resa hagloyurloh yarmat wol pangal lobo kawe bo re bela hasidoh rechoka re tomay irel Jesus. ");
INSERT INTO uli_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Resa hafalpechey hare be mechal bo rechokla re tomay rebe yangsi ngachel mala mengagol; panger rechokla re yangsi molwe mengagol, ngo ye chuy yar tomay. ");
INSERT INTO uli_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Iwe ngo tot Pharisees mo mokwe sensel Hatobtob we re budoh mo wol Jerusalem resa budoh irel Jesus resa kasiya bo, ");
INSERT INTO uli_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Meda fal le mekla re dabeyem rete talenga foloy kowe yar chapdoh kowe yach iyang? Rete ma tela payur mo imol mala rebe mongoy, le be wolulul yach ma foru!” ");
INSERT INTO uli_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus sa sor bo, “Meda fal le hami hate talenga yalol Hatobtob we yael Deus bo ha dabey ikla yami le hami ha fofoloyu? ");
INSERT INTO uli_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Deus ye sor bo, ‘Habe hasrowu tammi mo silmi, ngo te tugul semal le ye sor sew formel le ye taiykof irel tamal hare sil ngo rebe llimeseloh.’ ");
INSERT INTO uli_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iwe ngo hami ha foloyu le semal le yor tot formel irel le be yoh le be teptap be tipingi ngal sil mo temal ngo yesasor bo, ‘Mele ila yal Deus.’ ");
INSERT INTO uli_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ila ngo tayor pelal le be wol hammale molwe temal. Iye sengal wolulul yami tay ma talenga yalol Deus, bo fal mala habe dabey ikla hami hasa fofoloyu. ");
INSERT INTO uli_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hami sibis yarmat le ha rol fforiyeg. Ye bung Isaiah irel molwe ye sor irel kofmi we ye sor bo, ");
INSERT INTO uli_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Deus ye sor bo, Rechoka rema hasrowuyey mo irel yar hapatpat, ngo te ila wey mo lal mekla deper. ");
INSERT INTO uli_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tor pelal le rebe hasrowuyey bo hatobtob kala re fofoloyu, ila foriyel yarmat ngo re sala foruloh le yai hatobtob!’” ");
INSERT INTO uli_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iwe ngo Jesus sa fesangur buwa we bo rebe budoh irel ngo yesa kangalur bo, “Ha talenga bo habe medaf iyang! ");
INSERT INTO uli_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Te meka ma bulong lal yewal semal yarmat mele be hatayikofa, bo far ikla ma buyoy mo iyang mele yema hatayikofa.” ");
INSERT INTO uli_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iwe ngo mokwe re dabeyal resa budoh irel ngo resa kangalu bo, “Ho togla le Pharisees kowe ila sa bbareg deper irel mekla hosa sor?” ");
INSERT INTO uli_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus sa hatefali ngo sa sor bo, “Mala Temay wol laeng yebe tirgidah pangal mekla te fadguyal. ");
INSERT INTO uli_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ha towe luluwaley kofer! Re metafis ngo re wol mel bo meter ikla re metafis; ngo yodla semal metafis be pali semal le ye wol metafis, ngo ir rorumal ngo rebe chepraglong lal lib.” ");
INSERT INTO uli_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedrus sa sor bo, “Hamdefa ngalugmem fael fiyong la.” ");
INSERT INTO uli_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus sa kangalur bo, “Hami mwo ngo hated wol medaf? ");
INSERT INTO uli_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ha temedaf le te tugul mele yebe bulong lal yewal semal yarmat, ngo yebe bulong lal siyal ngo ye moch la pedaloh. ");
INSERT INTO uli_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngo ligdi bo mekla yema buyoy mo lal yewal semal yarmat, ila ye buyoy mo lal mala bulal. Ikla mekla yema hatayikofa yarmat. ");
INSERT INTO uli_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mala bulal mele ma budoh luluwal tayikof kala ma pali ngali yebe lilimmesloh yarmat, pera ril semal ngo ye wol faor tot wegdeg le ye tayikof; peraf, kachapar mo tongtongol kaptal yarmat. ");
INSERT INTO uli_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ika mekla ma hatayikofa yarmat. Iwe ngo habe te tela paomi ngo hasa mongoy, le hate dabey molwe re kangalugmi habe ma foru — mele ila tema hatayikofa yarmat.” ");
INSERT INTO uli_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus sa chuy mo lobowe sa loh solbos le ye harpa mekla faluyel Tyre mo Sidon. ");
INSERT INTO uli_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Semal fefel Canaan le ma mel lobowe sa budoh irel. Yesa tawulagililoh le ye sor bo, “Mala Lol David! Be ffaho dopom ngalyey! Lefechig la layi ila sa mel semal moniyan uwol, ngo sa tayikof mala wululul.” ");
INSERT INTO uli_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Iwe ngo Jesus tor mele ye kangalu. Mokwe re dabeyal resa budoh resa hafalpechey le re sor bo, “Kangalu fefel la bo be loh! Yesa dedabegich le sa hachrongdoh chog!” ");
INSERT INTO uli_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus sa hatefali ngo sa sor bo, “Re fangdoh ngang bo ibe budoh irer yarmetal Israel kala resa wochog saaf kowe resa mwael.” ");
INSERT INTO uli_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iwe ngo fefel we sa budoh sa ppung hasubgudiy mo imol mokwe pechel ngo sa kangalu bo, “Tipingiyey melap!” ");
INSERT INTO uli_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus sa hatefali le ye sor bo, “Ye tafel le sibe hasi meka haler yalwich ka siya ppedaloh bo haler pes.” ");
INSERT INTO uli_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Fefel we sa hatefali le ye sor bo, “Tos melap, ngo ligdi bo pes mwo ngo ma hangi lutgul mongoy kala ma ppungdiy mo wol tis la yael masta la yal.” ");
INSERT INTO uli_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iwe ngo Jesus sa sor bo, “Gel semal fefel le ye palleng yam tugul! Mala ho dipli ila yebe yoh ngalug.” Yodla chog ngo sa chuy moniyan we mo wol tarfefel we lol fefel we. ");
INSERT INTO uli_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus sa chuy mo lobowe sa dedarloh wol ngachel Chael we Galilee. Yesa bidah wol sew tagitat sala marodiy mo iyang. ");
INSERT INTO uli_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tot buwal yarmat resa budoh irel le re kakdoh cho tomay kala ye mes pecher mo ikala re metafis, mo ikala re tayma dohloh, mo ikala re togla hapatpat. Iwe ngo ye wol cholop ikala re hasirdoh le re wol tomay resa yitilir imol Jesus; iwe Jesus yesa hachuya yar tomway. ");
INSERT INTO uli_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yarmat re lluwdah irel molwe resa wiri le rechokwe re togla hapatpat, ila sa yoh le rebe hapatpat, ngo rechokwe re tema dohloh, ila resa tefael ngal llifador. Iwe ngo rechokwe ye mes pecher ila re sama darloh; ngo ikowe re metafis, ila resa wiri formel. Iwe ngo panger ngo resa rrol hapingpinga Deus. ");
INSERT INTO uli_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus sa fesangur mokwe re dabeyal sa kangalur bo, “Isa fahor rechoka bo sa solral yar mel irey. Iwe ngo igla ngo tor mele rebe mongoy. Ite dipli le ibe fangloh ir le tor mele ibe hamongoyu ngalir bo rede la remasol loh irel yodla re loloh bugter iyang.” ");
INSERT INTO uli_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mokwe re dabeyal resa kasiya bo, “Iya mo lal tolmay loh le mele ha bela werwer mongoy mo iyang le be lap haler buwa le iyang?” ");
INSERT INTO uli_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus sa kasiyar bo, “Ifa lepal flowa le ye mel iremi?” Iwe ngo resa sor bo, “Fisyoy flowa mo fedmal yig pachigchig.” ");
INSERT INTO uli_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iwe Jesus sa kangalur buwa we bo rebe marodiy wototol. ");
INSERT INTO uli_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Iwe sa hasi flowa we fisyoy mo yig we fedmal, ngo sa kangalu Deus yal hachigchig, sa dipiy sa ngaler mokwe re dabeyal, ngo mokwe re dabeyal resa fang ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Panger ngo re mongoy ngo ye lap haler. Iwe ngo mokwe re dabeyel Jesus resa hateyili fengali mokwe lutgul sala ssoeg fusuw bachebach iyang. ");
INSERT INTO uli_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Leper mal le re mongoy ila fangeras ngo te papa fefel mo yalwich. ");
INSERT INTO uli_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iwe ngo Jesus sa halhor yarmat ngo sa chudah yuchul seyay boat sa loh irel mokwe faluyel Magadan. ");
INSERT INTO uli_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tot Pharisees mo Sadducees re budoh irel Jesus le re luluwaley bo rebe hapagu. Iwe resa kangalu bo yebe faor sew kkemal le ila mele yebe halleha le ye fel mo fael metal Deus. ");
INSERT INTO uli_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus sa hatefali ngo sa kangalur bo, “Irel yodla be dol yaal ngo hama sor bo, ‘Bele momay rael bo sa chechaloh lal laeng.’ ");
INSERT INTO uli_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Iwe ngo be lemerral ngo hama sor bo, ‘Ye bele ppotog bo sa checha ngo ye roch lal laeng.’ Ma yoh ngalugmi le habe kaldah lal laeng ngo hasa sor kofal yayural, iwe ngo ye teyoh ngalugmi le habe hamdefa hagilel meka bele weweldoh raleka? ");
INSERT INTO uli_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yesa kkel yar tayikof yarmetal fael mwole, bo re tay talenga yalol Deus! Ha dodongor bo ibe kkewar ngalugmi sew kkemal? Yeb! Kkemal la be yoh le habe wiri ila tappel kkemal we Deus ye faor ngal profeta Jonah.” Iwe ngo sa ligdir sa loh. ");
INSERT INTO uli_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yodwe mokwe re dabeyel Jesus re loh mo rel laom we sere, ngo resa maliglaloh le rebe kak flowa. ");
INSERT INTO uli_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus sa kangalur bo, “Habe hafalugmi irel habboloh we yar Pharisees mo Sadducees kowe.” ");
INSERT INTO uli_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Resa kapta fengali luwulur le re sor bo, “Ye sor molwe bo fael mala tor flowa le si hasi.” ");
INSERT INTO uli_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus ye gola molwe re kapta ngo sa sor bo, “Meda mele ha kekapta yal tor flowa iyang? Ila lepal yal halsugfed yami tugul! ");
INSERT INTO uli_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hated rol medaf chog? Hate luluwaley yodwe idipiy flowa we lemay bo haler mal kowe lemngeras? Fodow bachebach le ye ssoeg irel mokwe lutgul? ");
INSERT INTO uli_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Iwe ngo ifa sengal flowa kowe fisyoy we haler mal kawe fangeras? Fodow bachebach le ye ssog irel mokwe lutgul? ");
INSERT INTO uli_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Meda mele hala temedaf le te flowa mele ikekapta kofal ngalugmi iyang? Ha hafalugmi irel habboloh we yar Pharisees mo Sadducees!” ");
INSERT INTO uli_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Iwe ngo mokwe re dabeyal resa moch medaf le yete sor bo rebe hafalir irel habboloh ka rema faor ngal flowa, bo foloy kowe yar Pharisees mo Sadducees mele rebe hafallir iyang. ");
INSERT INTO uli_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus ye loh irel fulu kala ye harpa haplom we Caesarea Philippi, ngo la lobola, ngo sa kasiyar mokwe re dabeyal bo, “Itey mele yarmat re sor bo iy mele molwe Layur Retalop?” ");
INSERT INTO uli_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iwe ngo ir resa sor bo, “Sibis re sor bo Johannes Baptista, ngo sibis re sor bo Elijah, iwe ngo sibis re sor bo Jeremiah hare semal profeta kowe.” ");
INSERT INTO uli_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iwe yesa kasiyar bo, “Iwe ngo hami? Ha sor bo Ngang itey?” ");
INSERT INTO uli_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Pedrus sa hatefali le ye sor bo, “Gel Kristus we Lol Deus.” ");
INSERT INTO uli_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus sa sor bo, “Ye momay ngalug ho Simon la lol John! Bo hapatpat la hosa kapta le tos ila te budoh mo irel yarmat, bo mala Temay wol laeng mele ye fang ngalug. ");
INSERT INTO uli_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ila ibe kangalug ho Pedrus: gel sew porow, ngo woal porow la mele ibe hasuy halesiya la yai iyang. Ngo towe yoh le be kkel maes mo imol. ");
INSERT INTO uli_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ibele ngalloh mekla kiyel mala Lamliyel Laeng; ngo mekla yete tal mo wol talop ila towe tal mo woal laeng, ngo mekla ye tal mo wol talop ila be tal mo woal laeng.” ");
INSERT INTO uli_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iwe ngo Jesus sa hatobtob ngalir mokwe re dabeyal bo tor semal le rebe kangalu le iy Jesus mele Kristus. ");
INSERT INTO uli_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ye chaep irel yodle sa loh le Jesus sa hamdefa ngalir mokwe re dabeyal le ye sor bo, “Ye tugul le ibe loh Jerusalem bo ibela hafohoy mo irer mal kowe mo tamol temarong kala mo sensel hatobtob kala. Rebe llimeseyeyloh ngo bela solral mo wol miril, ngo isa molow tefael mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedrus sa paliloh mo medaw sa kkaftoroy ngali le ye sor bo, “Samol, Deus ye towe hatela le rebe foru mala! Towe yoh le be wel ngalug mala!” ");
INSERT INTO uli_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus sa tagul sa kangalu Pedrus bo, “Chuy tangyey ho Satan! Hosa pagu mala yalapay bo luluwal la yam, ila te budoh mo irel Deus bo ye budoh mo irel yarmat.” ");
INSERT INTO uli_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iwe Jesus sa kangalur mokwe re dabeyal bo, “Semal le be dabeyey, ngo be mmaliglaloh kofal lufulyal sa hasi yal krud sa dabeyey. ");
INSERT INTO uli_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Semal le yebe hachangi yal ngas ngo yebe ppung tangi; ngo te tugul semal le yebe mes bo fael ngang ngo yebe molow. ");
INSERT INTO uli_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Meda mele mmalel semal yarmat le hare yela yoh ngali mmal le lal faileng le, ngo yesa ppung tangi molow la yal? Ye tugul le tor! Tor mele yebe chil yoh ngali le yebe fang ngo sa wol yoh ngali molow we yal. ");
INSERT INTO uli_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bo mala Layur Retalop, ila bele budoh luwul falmay la yael mala Temal le iy mo angelus kala lol. Iwe ngo yebe fang paliyer yarmat le yebe dabey igegel yael semal mo semal yengang. ");
INSERT INTO uli_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ibe hatugulu ngalugmi le yor tot yarmat iga le re towe rol mes yee, la hola yodla rebe wiri mala Layur Retalop le yebe budoh le sa mel le King.” ");
INSERT INTO uli_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yela wolral mo wol miril ngo Jesus sa fesangu Pedrus mo bisbis we rumal, James mo Johannes yesa palirdah wol sew tayit le ye tagiyet sala rol ir loh chog mo iyang. ");
INSERT INTO uli_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yodwe re chil kekal ngali ngo sa yusuwel loh molwe wol Jesus. Wol molwe metal sa wochog ddolol yaal, ngo molwe mengagol yesa kkel yal bbech ngo ye ttarfisfis. ");
INSERT INTO uli_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iwe ngo rosolmol mokwe wocholuwal ngo resa wiri Elijah mo Moses le re kapatpat mo Jesus. ");
INSERT INTO uli_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iwe ngo Pedrus sa maliliy ngo sa kangalu Jesus bo, “Samol, ye momay mele siya mel iga. Hare ho dipli ngo isa foru suluw tento, le be sew imwom ngo sew imwel Moses ngo sew imwel Elijah.” ");
INSERT INTO uli_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yodwe ye chil kapatpat ngo sedep darmiy le ye bbechrag sa budoh uwor ngo sa bidiy yalol Deus mo iyang le ye sor bo, “Iye mele Layi le ihachangi, ha talenga yalol!” ");
INSERT INTO uli_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yodwe mokwe re dabeyal rela rongrong molwe ngo sa kkel yar motog resa ngerchapdiy wototol. ");
INSERT INTO uli_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus yesa budoh yesa yetedah paol uwor ngo sa sor bo, “Ha sudah. Ha towe motog!” ");
INSERT INTO uli_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Iwe rela tterdah ngo tayor le ye mel loboswe bo sa halachog Jesus. ");
INSERT INTO uli_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Rela bibidiy mo wol tayit we ngo Jesus sa kangalur bo, “Tor semal le habe kangalu molwe hasa wiri yee, la hola yodla mala Layur Retalop be molow tefael mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iwe ngo mokwe re dabeyal resa kasiya Jesus bo, “Meda fal le mokwe sensel Hatobtob we re sor le Elijah mele be hamodoh?” ");
INSERT INTO uli_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus sa sor bo, “Tos bo Elijah mele be hamodoh bo yebe hafle pangal formel. ");
INSERT INTO uli_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ibe kangalugmi le Elijah ila sa faesul mel ngo ye tagel ngalir yarmat, iwe resa faor ngali mele ir re dipli rebe faor ngali. Be wol ila sengal chog mala rebe faor ngal mala Layur Retalop.” ");
INSERT INTO uli_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iwe mokwe re dabyal re medaf le iy ye kapta kofal Johannes Baptista. ");
INSERT INTO uli_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yodwe rela tefaeldoh irel buwa we ngo semal mal sa budoh irel Jesus yesa hasubgudiy imol, ");
INSERT INTO uli_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","yesa kangalu bo, “Samol, fahoy tarmal la layi! Yema budoh yal tomay le yema piyom le ye kkel. Yebe kkel ngali ngo ma chepragdah wulyef ngo ye ddorlong locchol. ");
INSERT INTO uli_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Isa mol hasidoh irer meka choluwam ngo ye temmal le rebe hachuya yal tomay.” ");
INSERT INTO uli_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus sa kangalur bo, “Hami rechoka, ifa lepal yami ted chepar mo yami tabung! Be ifa lepal ssulayel yai mel ngalugmi? Ngo be ifa lepal ssulayel yai halelayiloh repiyey ngalugmi? Ha hasidoh yalwich tarmal la irey!” ");
INSERT INTO uli_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus sa kangalu moniyan we bo yebe chuy mo uwol yalwich tarmal we, ngo yodwe chog ngo sa chuyloh mo uwol. ");
INSERT INTO uli_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Iwe ngo mokwe re dabyal resa budoh irel sala rol ir loh chog, ngo resa kasiya bo, “Meda mele ye teyoh le hamem ha hachchuya moniyan we iyang?” ");
INSERT INTO uli_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus sa hatefali ngo yesa sor bo, “Be ila sengal bo ye telap yami tugul. Ibe hatugulu ngalugmi le hare yor yami tugul le be lepal sefaes faesol mustard, ngo be yoh le habe kangalu tagitat le bo, ‘Hobe chuy mo iga hosa loh mo iglay, ngo be yoh!’ Te tugul mele iy ngo be yoh ngalugmi le habe foru!” ");
INSERT INTO uli_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iwe ngo sa mepel chog mo yach supiy halach mele be yoh le be chuy tappel mele iyang; tayor sew formel mo solbos le be chuy iyang. ");
INSERT INTO uli_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yodwe pangal mokwe re dabeyel Jesus resa ttey fengal wol Galilee, ngo yesa kangalur bo, “Mala Layur Retalop ila be yohlong lal payur yarmat bo rebe llimeseloh, ");
INSERT INTO uli_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ngo bela solral mo wol miril, ngo sa molow tefael mo irel maes.” Yesa kkel yal tayikof lal deper mokwe re dabeyal. ");
INSERT INTO uli_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yodwe Jesus mo mokwe re dabyal rela budoh wol Capernaum, ngo re sala budoh rechokwe rema hattey paliyel raeg le mil hammalel Templum we, resa budoh irel Pedrus ngo resa kasiya bo, “Sensey la yami ma fang paliyel raeg le mil hammalel Templum?” ");
INSERT INTO uli_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedrus sa sor bo, “Yema fang.” Yodwe Pedrus ye bulong yilim ngo Jesus sa moal maliliy le ye sor bo, “Simon, meda mele yam luluwal? Itey le ma fang semat mo semat tax mo paliyel raeg ngal king ka lal faileng le? Yarmetal fuluwe, hare rechoka re wasoladoh wol fuluwe?” ");
INSERT INTO uli_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedrus sa hatefali ngo sa kangalu bo, “Wasola.” Iwe ngo Jesus sa sor bo, “Hare be ila sengal ngo chol fuluwe ila re towe fang paliyel raeg. ");
INSERT INTO uli_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngo ligdi bo site dipli le sibe hatayikofa lal deper rechoka. Ila ho loh irel laom we ho sala halgadiy sew yaw iyang. Ngo metamol yig la be hoteg, ngo hosa yafsi ngo hobe wiri sefaes faesol salpiy mo lal mala yewal le be lap yach paliyel raeg le mil Templum. Hosa hasi ho sala fang ngalir bo yach paliyel raeg. ");
INSERT INTO uli_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Irel yodla ngo yesa budoh mokwe re dabeyel Jesus irel resa kasiya bo, “Itey semal le ye hartal tagiyet mo irel mala Lamliyel Laeng?” ");
INSERT INTO uli_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iwe ngo Jesus yesa fesangu semal yalwich sala hasu mo imor, ");
INSERT INTO uli_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ngo yesa sor bo, “Ibe hatugulu ngalugmi le hare habe te yusuwili wegdegmi habe wochog yalwich, ila ngo ha towe hola mala Lamliyel Laeng. ");
INSERT INTO uli_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yeramtala ye hartael tagiyet mo irel mala Lamliyel Laeng ila yeramtala ye hatetalo sala wochog yalwich le. ");
INSERT INTO uli_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Semal le be hakkola ngal semal tappel yalwich ka le fael Ngang, ila ye hakkola ngalyey. ");
INSERT INTO uli_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Hare semal le be wigdi depel semal yalwich ka bo be ppung tangi tugul la yal ngalyey, ngo ye momay le yeramtala be farhadah sedep porow fael mala yuyal re sala ppedaloh llemdaw. ");
INSERT INTO uli_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ifa lepal tayikofal ngal faileng le, le ye cholop mekla ma forur yarmat bo yebe ppung tangir yar tugul. Meka ila pangal yad ngo ma weldoh, iwe ngo ifa lepal tayikofal ngal yeramtala iy mele ye chapidoh meka. ");
INSERT INTO uli_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Hare sere pom, hare pechem mele ye forug le be ppung tangug yam tugul, ngo hosa supiyloh hobe ppedaloh! Ye momay le hobe hola molow la tor siyal le tor sere pom hare pechem, mo imol mala yebe mel chog pom mo pechem, iwe ngo re ppeduglong luwul yaef la tor siyal. ");
INSERT INTO uli_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hare sefaes mala metam mele ye foru le be ppung tangug yam tugul, ngo hosa haltuloh hobe ppedaloh! Ye momay le hobe hola molow la tor siyal le be hal sefaes metam, mo imol mala be rufeas metam iwe ngo re ppeduglong luwul yaef la tor siyal. ");
INSERT INTO uli_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ha kemahoy bo hade hafobidrir yalwich ka. Ibe kangalugmi le yar angelus wol laeng, ila pangal yad ngo re mel irel mala Temay woal laeng. ");
INSERT INTO uli_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mala Layur Retalop ye budoh bo yebe hadorar rechokla resa mwaelloh. ");
INSERT INTO uli_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Meda mele yami luluwal irel semal mal le hare be subguy lol saaf, iwe ngo sa tamel loh semal mo luwulur? Yebe ligdi ila duweg mo duwmal le re momongoy fedal fadil wol tayit, ngo sa loh ye bela meri iwe ye tamel loh. ");
INSERT INTO uli_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ibe kangalugmi le yodla bela wiri, ngo yebe kkel yal rraey irel saaf la semal mo imol ikla duweg mo duwmal le rete loh solbos. ");
INSERT INTO uli_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wol ila sengal mala Tammi wol laeng, bo yete dipli semal tapel yalwich ka le be wol tamel loh. ");
INSERT INTO uli_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Hare semal bisim sa molfid ngalug, ngo hosa loh irel ho bela kangalu tayikof la sa foru. Hobe loh irel bela hamiloh chog ngo hosa kaptapat ngali. Hare ye talenga yalom ila ngo sa yoh tefael ngalug molwe bisim. ");
INSERT INTO uli_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Iwe ngo hare yete talenga yalom, ngo hosa fesangu semal hare rumal bo rebe daboh bo ‘pangal mekla semal ye sor bo derel semal, ngo chola rumal hare solmol mele yami tugul,’ le ye wochog molwe babior we ye santus ye sor. ");
INSERT INTO uli_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hare ye temechal talenga yalom, ilang ngo hosa sor pangal mokwe ngal halesiya. Hare ye temechal chog talenga yalor yarmetal halesiya, ngo hosa yitli le be wochog semal Gentile hare semal chol hatteyel paliyel raeg. ");
INSERT INTO uli_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ila ibe kangalugmi pangamiloh le: meka ha te hatla mo woal talop, ila towe tal mo woal laeng, ngo mekla ha hatla mo woal talop, ila ye tal mo woal laeng. ");
INSERT INTO uli_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ngo ibe wol kangalugmi tot: te tugul sew yad le rumal hami be sew chog yar luluwal irel sew formel le re mapela, ngo mala Temay woal laeng be fang ngalugmi. ");
INSERT INTO uli_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te tugul solbos le re bela chufengal rumal hare solmol fael mele idey, ngo Ngang ila ibe mel irer.” ");
INSERT INTO uli_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iwe ngo Pedrus sa budoh irel Jesus sa kasiya bo, “Samol, hare mala bisiy ma tayikof ngalyey loh chog, ngo be fal fodow yai hachuya mo lal yai luluwal? Be fal fusuw?” ");
INSERT INTO uli_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus sa hatefali ngo sa sor bo, “Te fael fusuw, bo be fael fisig mo fusuw. ");
INSERT INTO uli_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ibe kangalugmi bo mala Lamliyel Laeng ila iye sengal. Ye mel semal king le ye luluwaley le yebe kemahoy babiorol slapiy kala boy kowe yal rema foru. ");
INSERT INTO uli_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ye moch chapiydah le bele foru, iwe ngo resa hasidoh semal boy kowe le sa fodow sell dolla mala molfidil. ");
INSERT INTO uli_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ye telap slapiy irel boy we le be hachuya mokwe molfidil iyang, iwe king we sa sor le rebe fang loh yeramtawe mo fefel we ril mo yalwich kowe lol bo rebe tap chuway ir bo slave, ngo re wol tap chuway pangal mekla lital, ila ngo be yoh le be hachuya mokwe molfidil. ");
INSERT INTO uli_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Iwe ngo boy we yesa ppung hasubgudiy imol king we, yesa sor bo, ‘Fael pechem chog ngo ho towe nngat. Ngang ibe hatefali pangal slapiy la lom.’ ");
INSERT INTO uli_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","King we yesa fahoy, iwe yesa hachuya molwe molfidil mal we mo lal yal luluwal ngo sa tahche yeramtawe be loh. ");
INSERT INTO uli_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Iwe ngo mal we sa buyoy ligtam re sala werfengal mo semal boy kowe choluwal le ye mel fodow dolla le molfidil ngali, iy mal we moch buyoy. Yesa ddorfi sa yornga yesa kangalu bo, ‘Hobe hatefali molwe molfidim ngalyey!’ ");
INSERT INTO uli_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Boy we choluwal yesa ppungdiy imol ngo yesa sor bo, ‘Fael pechem chog ngo ho towe nngat. Ngang ibe hatefali mala molfidiy!’ ");
INSERT INTO uli_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Iwe ngo mal we ye temechal, ye far fangloh iy kalbus yebe paoy yee, yela rel chuy molwe molfidil. ");
INSERT INTO uli_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yodwe boy kowe sibis rela wiri molwe sa foru, ngo tay fel deper iyang. Iwe resa loh irel king we re sala kangalu pangal mokwe. ");
INSERT INTO uli_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iwe sa fesngulong boy we yilim yesa kangalu bo, ‘Gel semal boy le tor pelam! Isa hachuya mo lal yai luluwal lepal slapiy we molfidim ngalyey bo fael haffalpech we yam ngalyey. ");
INSERT INTO uli_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gel hobe wol fahoy boy la choluwam le be wochog yai fahoh.’ ");
INSERT INTO uli_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","King we sa kkel yal ssong, yesa fangloh boy we lal kalbus bo re bela fang yal hagerger yee, la hola yodla be fang pangal loh mokwe molfidil.” ");
INSERT INTO uli_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iwe ngo Jesus sa hasiyaloh le ye sor bo, “Be iye sengal le mala Temay wol laeng yebe faor ngal semal mo semal hami, igle te hachuya mo lal yal luluwal mekla, semal bisil ye faor ngali.” ");
INSERT INTO uli_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yodwe ye moll yael Jesus sor mokwe ngo sa chui mo wol Galilee sa loh irel mokwe faluyel Judea we ye paoy rel Mololul we Jordan mo rewe sere. ");
INSERT INTO uli_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ye feraketaw yarmat le re dabey, iwe ngo yesa hachuya yar tomay ikowe re tomay. ");
INSERT INTO uli_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tot Pharisees re budoh irel le re luluwaley bo rebe hagla. Iwe resa kasiya bo, “Ye tal mo irel Hatobtob we yach la semal mal yebe hachuya yal habulupoy le te tugul mele fefel we ye hadre?” ");
INSERT INTO uli_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus sa hatefali ngo yesa sor bo, “Ha ted yawli mwo babior we ye santus we ye sor bo, irel mala chapdagel ngo Deus le ye hasubu pangal formel ye forur yarmat le mal mo fefel? ");
INSERT INTO uli_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iwe ngo Deus sa sor bo, ‘Ila fal le semal mal be ligdi sil mo temal, sa chungal fefel we yal habulupoy re sala sew chog.’ ");
INSERT INTO uli_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ila re tay rumal mo iyang bo resa sew chog. Yarmat re towe hamhela mekla Deus sa hachufengali.” ");
INSERT INTO uli_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iwe ngo Pharisees kowe resa kasiya bo, “Ila ngo meda fal le Moses yela fang hatobtob we ye sor bo, yebe yoh le semal mal be fang ngal fefel we yal habulupoy sew babiorol mahelal habulupoy ngo sa moch hachuya fefel we?” ");
INSERT INTO uli_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus sa hatefali ngo sa sor bo, “Moses ye taldi ngalugmi bo be yoh le habe hachuya fefel kala yami habulupoy bo, fal mala ha tema talenga foloy bo ye kkef repimi. Ngo irel yodwe ye sub pangal formel ngo te ila sengal mala wululul. ");
INSERT INTO uli_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ibe kangalugmi le hare semal mal ye hachuya fefel la yal habulupoy le te fal mala fefel we yete katos ngali, ila ngo mal we yebe molfid le hare yela rili semal fefel mo solbos.” ");
INSERT INTO uli_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mokwe re dabeyal resa kangalu bo, “Hare ila chog mele be yoh le semal mal yebe hachuya fefel la yal habulupoy iyang, ila ngo ye far momay le re towe ma habulupoy.” ");
INSERT INTO uli_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus sa sor bo, “Foloy le ila te yar pangal yarmat bo yar chog rechokla Deus yesa fang ngalir. ");
INSERT INTO uli_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ye cholop metmetal mekla tot yarmat towe yoh le rebe habulupoy iyang. Tot yarmat ila rela faesul subdoh chog ngo ila senger; ngo tot ila fael mala yarmat mele re foru le be ila senger; ngo tot ila rete habulupoy bo fael mala Lamliyel Laeng. Ha ligdir rechokla ye yoh ngalir foloy le bo rebe talenga.” ");
INSERT INTO uli_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tot yarmat re kakloh yalwich irel Jesus bo yebe yetedah paol uwor ngo ye mapelar, ngo mokwe re dabeyal resa kkaftoroy ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus sa sor bo, “Ha towe hapolahor yalwich kala, ha ligdir bo rebe budoh irey, bo mala Lamliyel Laeng ila yar rechokla re tappilir yalwich ka.” ");
INSERT INTO uli_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iwe ngo yesa yetedah paol uwor yesa mapelar. Iwe ngo yesa ligdir sa loh. ");
INSERT INTO uli_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Fael sew yad ngo semal mal ye budoh irel Jesus sa kasiya bo, “Sensey, meda sew formel le ye momay le ibe foru bo yebe yoh ngalyey molow la tor siyal?” ");
INSERT INTO uli_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus sa hatefali ngo sa sor bo, “Meda mele hola kasiyayey kofal meka ye momay iyang? Hal Semal le ye mel le ye momay. Ila hobe dabey hatobtob ka hare ho dipli le be yoh ngalug molow la tor siyal.” ");
INSERT INTO uli_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mal we yesa kasiy bo, “Hatobtob kefa?” Jesus sa hatefali ngo yesa sor bo, “Ho towe llimeseloh semal; ho towe pera ril semal; ho towe peraf; ho towe tongtong kaptal semal; ");
INSERT INTO uli_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","hasrowu tamom mo solom; ngo hobe hachangir yarmat le be wochog yam hachangi halongom.” ");
INSERT INTO uli_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mal we sa hatefali ngo yesa sor bo, “Italenga pangal hatobtob kala. Meda tot mele ibe chil foru?” ");
INSERT INTO uli_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus sa kangalu bo, “Hare ho dipli le hobe fel, ila ngo hosa loh ho sala tap chuway pangal loh mekla litam, ngo hosa fang mala slapiyal ngalir maelhafohoy, ilang ngo bele yor mmalem mo wol laeng; ngo hosa budoh hobe dabeyey.” ");
INSERT INTO uli_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yodwe tarmal we yela rongrong mokwe, ngo sa loh le sa tayikof depal iyang bo iy iwe semal rechokwe ye mmal. ");
INSERT INTO uli_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iwe ngo Jesus sa kangalur mokwe re dabeyal bo, “Ibe hatugulu ngalugmi le ye kkel yal weres le rechokla re mmal rebe dohlong lal mala Lamliyel Laeng. ");
INSERT INTO uli_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ibele tefael ngali: ye kkel tot yal weres le semal rechoka ye mmal yebe bulong irel mala Lamliyel Laeng, mo imol semal camel le be bulong lal chechel seyay did.” ");
INSERT INTO uli_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yodwe mokwe re dabeyal rela rongrong molwe ngo re lluwdah iyang. Iwe resa kasiya bo, “Ila ngo itey le be daor?” ");
INSERT INTO uli_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus yesa kal ngalir ngo yesa hatefali le ye sor bo, “Mele ila towe yoh ngalir yarmat, ngo Deus ila pangal formel ngo yema yoh irel.” ");
INSERT INTO uli_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Iwe ngo Pedrus sa sor bo, “Kaladoh, hamem hasa ttahcheloh pangal formel hasa daboh. Meda mele be yoh ngalugmem?” ");
INSERT INTO uli_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus sa kangalur bo, “Be tugul lal dipmi le yodla bela mel mala Layur Retalop irel mala liliyal le ye falmay irel Mwola ye Tefoy, ngo hami meka re dabeyey, le seg mo rumal ila habe wol mel irey irel mekla lilimi bo habe lamli halengel Israel ka seg mo ruwow. ");
INSERT INTO uli_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Iwe ngo panger rechokla resa ligdaloh imwer, hare wol bisir, hare mwenger, hare temer, hare seler, hare laiyur, hare yar milay bo fael Ngang, ila be kasubguy mekla le be yoh ngalir ngo be wol yoh ngalir molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iwe ngo ye cholop rechokla re hamo igla, le rebe hamir ngo rechokla re hamir le rebe hamo. ");
INSERT INTO uli_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Mala Lamliyel Laeng ila iye sengal. Lemaguyugul seral ngo semal mal sala ffaeg chol yengangel milayel grape la yal. ");
INSERT INTO uli_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ye fel mo irel mal we le be fang paliyer le be lepal mala faesul paliyer chol yengang, le be seral ngo sefaes faesol salpiy kowe silver. Iwe yesa fangloh ir bo re bela yengang woal milayel grape we yal. ");
INSERT INTO uli_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yela loh irel lobowe liliyel market we rema to tteydoh yarmat iyang irel molwe sa duwow kolok, ngo sala wirir tot mal le re susu fedal le tor mele re foforu. ");
INSERT INTO uli_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iwe ngo yesa kangalur bo, ‘Ha wol loh ha bela yengang irel milayel grape we, ngo be momay palimi le ibe fang.’ ");
INSERT INTO uli_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Iwe resa loh. Iwe ngo wol ila sengal chog mala ye foru irel seg mo ruwow kolok mo suluw kolok. ");
INSERT INTO uli_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yela harep ngal lemow kolok ngo yesa loh irel lobowe liliyel market we rema to tteydoh yarmat iyang, sala wol wirir tot mal le re chil susu fedal loboswe. Iwe yesa kasiyar bo, ‘Meda mele ha sala hatolpaloh raley le le tor mele ha foforu iyang?’ ");
INSERT INTO uli_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Iwe resa hatefali le re kangalu bo, ‘Tor le ye fang yamem yengang.’ Iwe yesa kangalur bo, ‘Ila ngo hasa loh ha bela yengang wol milayel grape we yai.’ ");
INSERT INTO uli_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Molwe yela llefhafdoh ngo yeramtawe yal milay we sa kangalu tamol yengang we yal bo, ‘Fesangur chol yengang kowe bo hobe fang paliyer. Hobe homol fang paliyer rechokwe re hamirdoh irel yengang sa loh yee, la hartal ngo hosa moch fang paliyer ikowe re metamol yengang.’ ");
INSERT INTO uli_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Rechokwe ye chap yar yengang irel lemow kolok ila be semal ir ngo sefaes faesol salpiy kowe silver paliyel. ");
INSERT INTO uli_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yodwe rechokwe re homol yengang rela budoh rebe hasi paliyer, ngo re kachog bo ir yebe cholop tot paliyer. Iwe ngo ir mwo ngo be semal, ngo wol sefaes faesol salpiy kowe silver mele paliyel. ");
INSERT INTO uli_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Resa hasi salpiy kowe layur ngo sa chap yar lunglung irel yeramtawe ye fang yar yengang. ");
INSERT INTO uli_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Iwe ngo resa sor bo, ‘Rechoka ye moch chap yar yengang ila halsew awa le re yengang iyang, ngo hamem ila seral loh yamem yengang fael karkeral yaal, iwe ngo ho hafidgiloh chog palimem!’ ");
INSERT INTO uli_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yeramtawe yal milay we sa kangalu semal rechokwe bo, ‘Maryarey, talenga. Ngang ite kacheprah irel mala paliyemi. Hami iwe ye fel dipmi le be sefaes faesol salpiy kowe silver mele paliyel semal hami lal seral. ");
INSERT INTO uli_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hasi mala paliyem hosa loh llubugtam. Ngang idipili ibe ngaley yeramtale ye hamirdoh irel yengang lepal chog salpiy la isa fang ngalug. ");
INSERT INTO uli_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ifa sengal, ngang tor kkeley le ibe foru mele idipli ngal layi salpiy? Hare ho ngoll irel mele ye momay yai hagiyeg?’” ");
INSERT INTO uli_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesus sa hasiyaloh fiyong we le ye sor bo, “Rechokla re hamir ila rebe hamo, iwe rechokla re hamo ila rebe hamir.” ");
INSERT INTO uli_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yodwe Jesus ye bibidah Jerusalem ngo sa fesangur mokwe re dabeyal we seg mo rumal re sala musloh, iwe ngo resa dedarloh ngo ye kapatpat ngalir. ");
INSERT INTO uli_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Yesa kangalur bo, “Ha talenga, si bele bidah Jerusalem le ila lobola ye bele yoh long mele Layur Retalop lal payur tamol temarong kowe mo mokwe sensel Hatobtob we. Re bele la hatugulu le be mes. ");
INSERT INTO uli_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ngo resa fang iy ngalir Gentiles, rebe tape kamemmal, ngo re wwodu, ngo re krudu; ngo ligdi bo bela solral mo wol miril ngo yesa molow tafael.” ");
INSERT INTO uli_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iwe ngo molwe ril Zebedee mo rumal tarmal lol resa budoh, yesa cchemdi fael metal Jesus ngo yesa hafalpechey bo yebe tipingir. ");
INSERT INTO uli_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus yesa kasiya fefel we bo, “Meda mele ibe hammal ngalug?” Iwe ngo fefel we sa sor bo, “Hatugulu ngalyey le irel yodla ho bela mel bo King, ngo rorumal tarmal ka layi ngo rebe mel lengachem, semal be maroro rela gilemra irem, ngo semal mo rela gilchegil.” ");
INSERT INTO uli_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus sa sor bo, “Ha togla mekla ha dodongor. Be yoh le habe yul mo irel kapal hafohoy la ngang ibe yul mo iyang?” Iwe ngo ir resa hatefali resa sor bo, “Be yoh ngalugmem.” ");
INSERT INTO uli_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus sa kangalur bo, “Hami ila habe yul mo irel kap la yai, ngo tor kkeley le ibe duwley semal le be mel rela gilemra, hare gilchegil irey. Loboskla ila liliyer rechokla mala Temao sa faesul hafle bo liliyer.” ");
INSERT INTO uli_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yodwe ikowe seg we wol re dabeyel Jesus rela rongrong kofal molwe, ngo yesa budoh yar ssong ngalir bisbis we rumal. ");
INSERT INTO uli_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iwe Jesus sa fesangu fengalir panger ngo sa kangalur bo, “Hami ngo ha gola le fuluka rete chepar irel Deus le mal kala yar ila yor kkeler uwor yarmat, ngo tamol kala yar ila re lamlirloh panger yarmat. ");
INSERT INTO uli_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Hami ila towe ila sangmi. Hare semal mo luwulumi ye dipli le yebe tagiyet, ila ngo yebe hatetalo bo be mel bo boyer ikala sibis. ");
INSERT INTO uli_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iwe ngo hare semal mo luwulumi ye dipli bo yebe hamo, ila ngo yebe mel bo yar ikala sibis slave, ");
INSERT INTO uli_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","le be wochog molwe Layur Retalop le te budoh bo yarmat rebe hammale, bo ye budoh yebe hammaler yarmat, ngo ye fangloh yal nngas bo be demerir yarmat cholop.” ");
INSERT INTO uli_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yodwe Jesus mo mokwe re dabeyal re chuy tang Jericho, ngo sew buwal yarmat le ye palleng resa daber. ");
INSERT INTO uli_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Rumal mal le re metafis le re maroro wol ngachel yalap re rongrong le Jesus sa dedarloh mo loboswe. Iwe sa chap yar tawul le re sor bo, “Mala Lol David! Fahohmem melap!” ");
INSERT INTO uli_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Buwa we resa kkaftoroy ngalir ngo resa kangalur rebe ppoloh. Iwe ngo ir resa tawul le sa palleng tot yalor le re sor bo, “Mala Lol David! Hobe fahohmem, melap!” ");
INSERT INTO uli_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus sa ppoloh ngo sa fesangur. Yesa kasiyar bo, “Meda mele ha dipli bo ibe hammal ngalugmi?” ");
INSERT INTO uli_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Iwe ngo resa hatefali ngo resa kangalu bo, “Ha dipli melap le hobe foru habe wiri formel!” ");
INSERT INTO uli_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iwe Jesus sa fahor sa yangsi mokwe meter. Yodwe chog ngo sa mmal le rebe wiri formel iwe resa dabey. ");
INSERT INTO uli_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yodwe Jesus mo mokwe re dabeyal rela harpadoh Jerusalem, ngo re budoh Bethphage irel molwe Tayitel Olives. Rela holadoh lobowe ngo Jesus yesa hamwoarloh rumal mokwe re dabeyal. ");
INSERT INTO uli_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Iwe yesa kangalur bo: “Ha hamwoloh irel haplom lay. Ha bela hola ngo habe wiri semal donkey le ye lemtag le ye mel mala lol lengchel. Ha besir hasa hasirdoh irey. ");
INSERT INTO uli_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hare semal ye sor sew formel iyang ngo hasa kangalu bo, ‘Masta we be teptap’; iwe ngo mal we ye bele fang donkey kowe habe hasirdoh.” ");
INSERT INTO uli_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Be iye sengal bo fael mala yebe llah le katos mokwe profeta kowe re sor bo: ");
INSERT INTO uli_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ha kangalu haplom la Zion bo, Kalloh, king we yam ila sa budoh irem! Iy ye hatetalo le ye dagedoh semal donkey mo mala lol iy donkey we.” ");
INSERT INTO uli_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iwe mokwe re dabeyal re loh re sala foru molwe Jesus ye kangalur: ");
INSERT INTO uli_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","re hasidoh donkey we mo molwe lol, resa yetedah cloaks kowe hoter uwol donkey we mo molwe lol iwe Jesus yesa bidah sala marro wol hoter kowe. ");
INSERT INTO uli_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sew buwal yarmat le re cholop resa feraglaloh mengag kowe hoter lal yalap, ngo tot ikla resa sopsop paddol resa wol feraglaloh lal yalap we. ");
INSERT INTO uli_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ikala re hamo mo ikowe re dedabedoh miril Jesus resa tetawul le re sor bo, “Hapingpinga mala Lol David! Deus yebe holbuwa yeramtala ye budoh fael mala idel Samol! Hapingpinga Deus!’ ");
INSERT INTO uli_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yodwe Jesus ye budoh Jerusalem ngo sa gurangdah yarmat wol ballel haplom we. Yarmat resa kasiy bo, “Itey mala?” ");
INSERT INTO uli_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iwe ngo buwa we resa hatefali ngo resa sor bo, “Iye mele Jesus le semal profeta le ye budoh mo Nazareth we ye mel wol Galilee.” ");
INSERT INTO uli_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus ye bulong lal Templum we ye sala ddabsulurwey panger rechokwe re chuchuway. Iwe ngo ye hacheppa fedaley tis kowe yar chol hadidilel salpiy kowe mo mokwe liliyer rechokwe re chuchuway ngo re tetap chuway pigeons. ");
INSERT INTO uli_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iwe yesa kangalur bo, “Ye teftaf lal Babior we ye Santus we Deus ye sor bo, ‘Templum le yai be mel le sew imwel mapel.’ Iwe ngo hami hasa wilgi hasa itol le imwer chomachoh!” ");
INSERT INTO uli_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Rechokla re metafis mo ikala ye teyikel pecher re budoh irel lal Templum we iwe ngo iy yesa hachuya yar tomay. ");
INSERT INTO uli_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yesa budoh yar ssong tamol temarong kowe mo mokwe sensel Hatobtob we, irel yodwe rela wiri mokwe Jesus ye foru le ye momay, ngo yalwich resa tawulagili loh mo lal Templum we le re sor bo, “Sibe hapingpinga mala Lol David!” ");
INSERT INTO uli_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Iwe resa kasiya Jesus le re sor bo, “Ho rongrong mekla re sosor?” Jesus yesa hatefali ngo yesa sor bo, “Irongrong. Ha ted yawli mwo molwe lal Babior we ye Santus? Babior we ye Santus ye sor bo, ‘Hasa foloyu ngalir yalwich kala resa madelaploh mo ikla re ppachigchig le rebe fang hapingping le ye hartal momay.’” ");
INSERT INTO uli_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesus sa ligdir yesa buyoy mo woal haplom we sa loh woal Bethany sala sebong iyang. ");
INSERT INTO uli_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Llemalyelel ralawe seral irel yar la tetefaldoh mo Bethany ngo Jesus sa kkoloh. ");
INSERT INTO uli_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ye kalloh sala wiri sehay ire le rema sor bo fig le ye mel wol ngachel yalap, iwe ngo yesa loh iyang sala kemahoy le ye cholop yul ngo tor uwal. Iwe sa kangalu ire we bo, “Tayor fael sew le be chil yor uwam!” Irel yodwe chog ngo ye betbatloh ire we. ");
INSERT INTO uli_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mokwe re dabeyal re wiri molwe ngo re lluwdah iyang. Iwe resa kasiy le re sor bo, “Meda mele ye foru ngo sala ila sengal ttiril yal betbat loh ire la iyang?” ");
INSERT INTO uli_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iwe ngo Jesus sa hatefali ngo sa sor bo, “Ibe hatugulu ngalugmi le hare ha chepar, ngo te yeyewal dipmi ngo be yoh ngalugmi le habe foru molwe isa faor ngal ire le. Ngo te iye chog bo be yoh le habe kangalu tagitat le bo, ‘Llangdah ho sala ppungdiy mo leted,’ ngo yebe foru. ");
INSERT INTO uli_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hare yor yami tugulul ladep ila ngo te tugul mele habe dongor luwul yami mepel ngo be yoh ngalugmi!” ");
INSERT INTO uli_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus ye tefal ngal Templum we; ye fofoloy ngo tamol temarong mo mal kowe yar re budoh irel resa kasiya le re sor bo, “Meda kofom le ho la foru meka? Itey le ye fang kkelem le hobe foru meka?” ");
INSERT INTO uli_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus sa hatefali ngo yesa kangalur bo, “Ibele kasiyahmi sew chog kasiy. Iwe ngo hare ye yoh le ha hatefali, ila ngo ibe kangalugmi lobosle ye budoh kkeley mo iyang irel meka ifoforu. ");
INSERT INTO uli_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iya mele ye budoh kkelel Johannes le be ma baptismus mo iyang: ye budoh mo irel Deus hare irel yarmat?” Iwe resa rol fedgagili fengali uwor le re sor bo, “Meda mele sibe sor? Hare sibe sor bo, ‘Ye budoh mo irel Deus,’ ila ngo ye bele kangalgich bo, ‘Ila ngo, meda mele ha te chepar ngal Johannes iyang?’ ");
INSERT INTO uli_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iwe ngo hare si sor le, ‘Ye budoh mo irel yarmat,’ ila ngo si motog mekla yarmat rebe foru, bo panger ngo yesa tugul lal depar le Johannes ila iy semal profeta.” ");
INSERT INTO uli_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iwe resa kangalu Jesus bo, “Ha togla.” Ngo isa kangalur bo, “Wol ila sengay bo ngang iy towe kangalugmi lobosle ye budoh kkeley mo iyang bo ibe foru meka. ");
INSERT INTO uli_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Meda mele yami luluwal irel mele? Ye mel semal mal le ye mel rumal tarmal lol. Ye loh sala kangalu iwe ye moal yarmat bo, ‘Ho loh layi ho bela yengang woal milayel grape we igla.’ ");
INSERT INTO uli_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Iwe ngo iy yesa sor bo, ‘Ite dipli bo ibe loh,’ ngo yela wol miril ngo sa liwel yal luluwal iwe yesa loh. ");
INSERT INTO uli_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Iwe ngo molwe temer sa loh irel iwe semal ngo wol ila sengal chog mele ye kangalu. Yesa hatefali ngo yesa sor bo, ‘Ngo melap, ibe loh,’ iwe ngo ye temechal loh. ");
INSERT INTO uli_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Itey semal mo irer chowe rumal le ye talenga yalol molwe temer?” Iwe ngo ir resa sor bo, “Iwe moal yarmat.” Iwe Jesus sa kangalur bo, “Ibe kangalugmi: le rechoka rema hattey paliyel raeg mo rechoka rema tap chuway halonger ila rebe hamoloh irel mala Lamliyel Deus mo imomi. ");
INSERT INTO uli_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Johannes Baptista iwe ye budoh iremi bo yebe kkewar ngalugmi yalap la ye wwel le habe dabey, ngo hami ha te chepar ngali. Iwe ngo chol hatteyel paliyel raeg mo rechoka rema tap chuway halonger, ila re chepar ngali. Irel yodwe mwo hala wiri mele ngo te ttagul yami luluwal bo habe chepar ngali.” ");
INSERT INTO uli_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus sa sor bo, “Ha wol talenga sew fiyong. Ye mel semal mal le yela faor sew milayel grape yal wol mala bugtal. Yesa foru yororal ngo ye kilngi sew lib bo liliyel wungwungul chael grape. Iwe ngo yesa hasu sew imwel pos. Iwe yesa fang ngalir sibis chol hammalel milay bo rebe kamahoy ngo iy yesa ligdi molwe bugtal yesala malekah. ");
INSERT INTO uli_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Yela hola yodwe rebe gilsi uwal milay we, ngo sa fangloh boy kowe yal irer chol hammalel milay we bo re bela hasi mele yildil mo irel uwal milay we. ");
INSERT INTO uli_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Rechokwe resa ddorfir boy kowe yael mal we, iwe resa lliy fedaley semal ngo re hacchifi ila semal, iwe ngo re llimeseloh ila semal. ");
INSERT INTO uli_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mal we yesa wol hagloyurloh tot boy kowe yal le resa choaloap tot mo imor ikowe metamo, ngo wol iwe chog sengal mele chol hammalel milay we re faor ngalir. ");
INSERT INTO uli_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Yela hartal loh ngo yesa hagloyuloh tarmal we lol irer, le ye sor bo, ‘Ye tugul le rebe hasrowu tarmal le layi.’ ");
INSERT INTO uli_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Iwe ngo yodwe chol hammalel milay we rela wiri tarmal we lol mal we, ngo resa rol sor bo, ‘Iye tarmal we lol mal we yal milay le. Ha budoh bo sibe llimeseloh bo sibe hasi mele bugtal bo bugtach!’ ");
INSERT INTO uli_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Iwe resa ddorfi resa ppedawey mo yulgul milay we resa llimeseloh.” ");
INSERT INTO uli_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesus yesa kasiyar bo, “Hare yodla bela budoh yeramtawe yal milay we ngo mada mele yebe faor ngalir chol hammalel milay we yal?” ");
INSERT INTO uli_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iwe resa hatefali ngo resa sor bo, “Ye tugul le yebe llimeserloh rechokla re tayikof, ngo yesa fang milay we ngalir sibis le bela hola yodla be gil uwal milay we ngo rebe fang yildil mo iyang.” ");
INSERT INTO uli_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus sa kangalur bo, “Ha ted yawli mwo molwe Babior we ye Santus ye sor? ‘Feas we sallap kowe re ppedaloh bo tor pelal, ila feas la sala mel le ye hartal palleng pelal. Mele ila Samol mele ye foru le be iye sengal; ye foru le tor hapagol yal kamdidiy!’” ");
INSERT INTO uli_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jesus sa taboloh yal hapatpat le ye sor bo, “Ibe kangalugmi le mala Lamliyel Deus, ila rebe hasi tangugmi re sala ngaler rechokla be yoh le rebe faor mekla ye momay.” ");
INSERT INTO uli_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Semal le yebe ppungdiy wol feas le, ngo iy ila yebe gufedfed loh; ngo hare yebe ppungdiy feas le wol semal ngo yebe hapetpeteloh. ");
INSERT INTO uli_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tamol temarong kowe mo Pharisees kowe re rongrong fiyong kowe yael Jesus ngo re sa gola le Jesus ye kekapta kofer, ");
INSERT INTO uli_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","iwe resa luluwaley le rebe ddorfi. Ngo re metagur buwa kowe iwe leper bo resa itol le Jesus ila semal profeta. ");
INSERT INTO uli_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus sa wol teptap fiyong irel yal hapatpat ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mala Lamliyel Laeng ila iye sengal; semal king yela foru sew gubulul habulupoy bo yal tarmal la lol. ");
INSERT INTO uli_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yela hola yodwe rebe gubul iyang ngo yesa hagloyurloh tot boy kowe yal bo re bela fesangurdoh rechokwe sa hamol kangalur bo rebe budoh irel gubul we. Iwe ngo ir ikewe ye dengag ir re temechal budoh. ");
INSERT INTO uli_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Iwe yesa hagloyur boy kowe tot bo re bela fesangur chol gubul we le sa kangalur hapatpat la rebe sor: ‘Gubul le yai ila pangal formel ngo sa faesul hafelfel. Karbow kala ye hartal momay mo luwulur karbow kala layi ila resa lliy. Pangal formel ngo sa fel. Ha budoh dabey gubulul habulupoy!’ ");
INSERT INTO uli_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Iwe ngo rechokwe re fesangur rebe loh irel gubul we ila re temechal loh, bo rete kaddagiloh, semal ir ngo ye loh irel yal yengang: sibis re loh irel yar milay ngo sibis re loh irel yar stowa, ");
INSERT INTO uli_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","iwe ngo ikowe sibis resa ddorfir boy kowe resa wwodur ngo re llimeserloh. ");
INSERT INTO uli_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King we sa kkel yal ssong; iwe sa hagloyur loh saldaw kowe lol re sala llimeserloh rechokwe re llir loh boy kowe yal. Iwe ngo saldaw kowe re wol fisgiloh molwe haplomor rechokwe. ");
INSERT INTO uli_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Iwe King we yesa fesangur boy kowe sibis ngo yesa kangalur bo, ‘Gubul le yai ila pangal formel ngo sa moll hafforol, ngo rechokowe idengag ir bo rebe budoh ila te faesul yor kofer le rebe budoh. ");
INSERT INTO uli_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ha buyoy lal yalap kala ngo lepal yarmat le ha wirir ngo hasa fesangurdoh bo rebe dabey gubul le.’ ");
INSERT INTO uli_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iwe boy kowe resa buyoy lal tabtabol yalap kowe re sala hatteyilidoh panger rechokla re wirir le cho momay fengal mo cho tayikof. Iwe resa ttey long yarmat sala ssogloh lal lobowe rebe gubul iyang. ");
INSERT INTO uli_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“King we yesa bulong bela kemahor cho tteydoh we ngo sala wiri semal mal le yete mengagol gubulul habulupoy. ");
INSERT INTO uli_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","King we sa kasiya le ye sor bo, ‘Maryarey, ifa sengal chog ngo ho sala dohlong yilim le ho te mengagol gubulul habulupoy? Mal we tor mele ye sor. ");
INSERT INTO uli_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Iwe ngo king we sa kangalur boy kowe bo, ‘Ha fargu mekla paol mo mekla pechel, ngo hasa ppedawey ligtam luwul ruchupung. Ila lobola bela tetang ngo ye ketangtingi mekla ngil mo iyang.’” ");
INSERT INTO uli_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesus yesa hasiyaloh fiyong we le ye sor bo, “Ye cholop le ye dengag ir ngo hal fedmal le ye duwler.” ");
INSERT INTO uli_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pharisees kowe re loh re sala kapta mele rebe foru ngo sala yoh le rebe hapagu Jesus ngal tot kasiy. ");
INSERT INTO uli_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Iwe resa hagloyurloh irel Jesus tot mokwe re dabeyer mo tot ikowe choluwal Yerodes. Iwe resa kasiya bo, “Sensey, ha gola le mekla ho kapta ila ye katos. Ho ma foloyu ngalir yarmat mekla ye katos le depel Deus, le ho te merhagili mekla yarmat re luluwaley bo ho hafidgirloh chog yarmat. ");
INSERT INTO uli_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kangalugmem, meda mele yam luluwal? Ye fel mo irel Hatobtob we yach le sibe ma ffaeg paliyel raeg ngal mala Llulupal Roma hare yeb?” ");
INSERT INTO uli_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iwe ngo Jesus ye gola luluwal kowe yar we ye tayikof, iwe yesa sor bo, “Hami sibis yarmat le ha fforiyeg! Meda mele ha luluwaley le habe hapaguyey iyang? ");
INSERT INTO uli_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ha kkewar ngalyey sefaes faesol salpiy kala yarmat rema fang bo paliyel raeg.” Iwe resa hasidoh sefaes faesol salpiy irel, ");
INSERT INTO uli_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ngo yesa kasiyar bo, “Yongol itey ngo idel itey mele?” ");
INSERT INTO uli_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Iwe ngo ir resa sor bo, “Yongol mo idel molwe Llulupal Roma.” Iwe Jesus sa kangalur bo, “Ila ngo hasa ngaley mala Llulupal Roma mekla lamliyel, ngo ha ngaley Deus ikala lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Re lluwdah irel yodwe rela rongrong molwe; iwe resa ligdi resa loh. ");
INSERT INTO uli_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Rallawe chog ngo tot mo irer Sadducees kowe re sor bo tor mele molow tefael mo irel maes resa budoh irel Jesus. ");
INSERT INTO uli_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Iwe resa sor bo, “Sensey, Moses ye sor le hare ye mes semal mal ngo tor lol, ngo mala bisil yebe rili fefel we ril bo be yor layur, ngo resa yitli le lol mal we sa mes. ");
INSERT INTO uli_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ye mel fismol mal le re bisbis le rema mel iga. Iwe mol yarmat ye riri ngo tedyor lol ngo yesa mes. Iwe ngo iwe harumalel yarmat yesa rili fefel we. ");
INSERT INTO uli_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iwe ngo wol ila sengal chog mele ye wel ngal iwe harumalel, mo hasolmolol yarmat yee, rela retloh bisbis we fismol. ");
INSERT INTO uli_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yela wol miril loh ngo yesa moch mes fefel we. ");
INSERT INTO uli_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Iwe bela ralla chomes rebe molow tefael mo irel maes, ngo itey mele be mel fefel we bo ril? Pangerloh ngo iwe re rili fefel we.” ");
INSERT INTO uli_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus sa hatefali ngo yesa sor bo, “Ila lepal yami machey! Be ila sangmi bo ha temedaf irel yadol Babior we ye Santus, ngo ha togla mala kkalel Deus. ");
INSERT INTO uli_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bo yodla chomes re bela molow tefae mo irel maes, ngo re bele wochog angelus kala woal laeng, ngo re towol riri. ");
INSERT INTO uli_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Iwe ngo hare kofer chomes irel yar molow tefael mo irel mas: hami ha ted yawli mwo mokwe Deus ye kangalugmi? ");
INSERT INTO uli_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Deus ye sor bo, ‘Ngang mele yael Abraham, mo Isaac, mo Jacob, Deus.’ Iy yar cho molow Deus, ngo te yar chomes Deus.” ");
INSERT INTO uli_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yodwe buwa we re rongrong foloy kowe yal ngo re lluwdah iyang. ");
INSERT INTO uli_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yodwe Pharisees kowe rela rongrong bo Sadducees kowe resa ppoloh bo re tay gola mele rebe hapagu ngal Jesus, ngo resa ttey fengal, ");
INSERT INTO uli_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","iwe ngo semal mo luwulur le iy semal sensel Hatobtob we sa luluwaley le yebe hapagu ngali Jesus sew kasiy. ");
INSERT INTO uli_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Yesa kasiya bo, “Sensey, ifa sew mo luwul mokwe yalol Hatobtob we le ye hartal palleng fal?” ");
INSERT INTO uli_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus sa hatefali ngo sa sor bo, “‘Hobe hachangi Samol la yami Deus mo lal pangal loh dopom, mo irel pangal loh ngulum, mo lal pangal loh yam luluwal.’ ");
INSERT INTO uli_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iye mele ye hartal tagiyat, ngo ye hartal palleng fal mo irel yalol Hatobtob we. ");
INSERT INTO uli_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mala harwowal mo irel yalol Hatobtob we le ye wol palleng fal ila: ‘Hobe hachang yarmat le be wochog yam gel hachangug.’ ");
INSERT INTO uli_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pangal loh Hatobtob we yael Moses mo foloy kowe yar profeta kowe, ngo ye mel luwul yalol hatobtob le ruwow.” ");
INSERT INTO uli_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yodwe tot Pharisees kowe re ttey fengal ngo Jesus sa kasiyar, ");
INSERT INTO uli_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Meda mele yami luluwal irel kofal Kristus? Ifa mele yal daoy?” Resa hatefali ngo resa sor bo, “Daowe yael David.” ");
INSERT INTO uli_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iwe ngo Jesus sa kasiyar bo, “Ila ngo meda fal le Espritu Santus yela hatarma lal depel David bo yebe ffesangu bo ‘Samol’ iyang? Iy David ye sor bo: ");
INSERT INTO uli_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Samol ye kangalu yai Samol: Marro iga rele gilemra irey yee, la hola yodla iy be yitlirlong fael pechem rechokla re tayikof ngalug.’ ");
INSERT INTO uli_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hare David ye ffesangu bo ‘Samol’, ila ngo be ifa sengal chog ngo Kristus sala mel bo chol daowe yael David?” ");
INSERT INTO uli_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tor semal le ye yoh ngali le yebe hatefali kasiy kowe yael Jesus, iwe ngo wol miril yodla sa loh, ngo tayor le ye chil mechal le yebe kasiya sew formel. ");
INSERT INTO uli_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iwe ngo Jesus sa kapatpat ngalir buwa kowe mo mokwe re dabeyal. ");
INSERT INTO uli_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mokwe sensel Hatobtob we mo Pharisees kowe mele yor kkeler le rebe hamdefa Hatobtob we yael Moses. ");
INSERT INTO uli_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ila habe talenga ngo ha foru pangal mekla re kangalugmi le habe foru; iwe ngo ha towe somla mekla wigdigir, bo ir retema foru mekla rema foloyu. ");
INSERT INTO uli_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rema hakkela ngalir yarmat bo rebe hasi mekla ye cchow, ngo ye weres kekkal wol yefral yarmat, iwe ngo sehad mwo haddur, ngo re tema hallenga bo rebe tipingir yarmat. ");
INSERT INTO uli_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pangal mekla rema foru, ngo rema foru bo mil mala yarmat rebe wirir. Ha kemahoy lalepal mekla resa fargudah wol mekla mangor, mo payur le ye mel padpedal yalol Babior we ye Santus iyang. Ha wol kemahoy yelel midril mekla mengagur! ");
INSERT INTO uli_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Rema dipli chog rebe mel irel loboskla liliyer cho tagiyet mo irel gubul ka, ngo ye faesul tugul liliyer mo lal imwel ttey ka, ");
INSERT INTO uli_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","re dipli bo yarmat rebe ma hasrowur mo irel loboka liliyel market le yema toa tteydoh yarmat iyang, ngo rebe ma ffesang ngalir bo ‘Sensey’. ");
INSERT INTO uli_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Re towe ffesang ngalugmi bo ‘Sensey,’ bo pangmi, ngo ha rol bisbis ngo hal semal chog Sensey. ");
INSERT INTO uli_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iwe ngo tor semal mo wol talop le habe ffesang ngali bo, ‘Temay’ bo hal semal chog Tammi le ye mel woal laeng. ");
INSERT INTO uli_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Re towe wol ffesang ngalugmi bo ‘Tamol’ bo hal semal yami tamol le iy Kristus. ");
INSERT INTO uli_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yeramtala ye hartal tagiyet mo luwulumi ila be mel bo yami boy. ");
INSERT INTO uli_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Semal le yebe hatagita ngo yebe totol, ngo semal le yebe hatetalo ngo yebe tagiyat. ");
INSERT INTO uli_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Ifa lepal tayikof le yebe holahmi hami mekla sensel Hatobtob we, mo hami Pharisees kala ye foriyeg yawmi! Bo hasa pilta tangir yarmat hatmal mala Lamliyel Laeng, le hami ngo ha towe bulong iyang, iwe ngo hate tahcher rechokla re yeyedamgel, bo rebe bulong iyang! ");
INSERT INTO uli_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ifa lepal tayikof le yebe holahmi hami mekla sensel Hatobtob we mo Pharisees kla ye fforiyeg yawmi! Hama waey ddawloh, ngo ha darsupiloh fuluy palingling, le mil chog mala habe wigdi depel semal yarmat ngal foloy kala yami; ngo bela weg depel semal ngal foloy kala yami, ila ngo hami hasa foru le be fael ruwow yal be kkel tot yael yaramtawe hagerger mo imoami mo lal Infiyerno! ");
INSERT INTO uli_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ifa lepal tayikof la be holahmi hami rechokla ha togla mekla ha foforu, ngo ha pepalir yarmat! Ha foloyu le ha sor bo, ‘Hare semal ye hatugulu sew formel fael idel Templum we, ngo ila mwo te foru molwe sa hatugulu; ngo hare ye hatugulu molwe fael idel hoal kala lal Templum we, ila ngo ye tugul le be foru molwe yesa hatugulu.’ ");
INSERT INTO uli_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ha togla mekla ha foforu ngo ha buch! Ifa sew le ye paling pelal, hoal kala hare Templum la ye foru hoal kala bo yebe santus? ");
INSERT INTO uli_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ha wol foloayu le ha sor bo, ‘Hare semal ye hatiwgiliy sew formel fal idel altar we, ngo ila mwo te foru molwe sa hatiwgiliy; ngo hare ye hatiwgiliy molwe fal idel maligach la wol altar we ila ngo ye tiwgil le yebe foru molwe yesa hatiwgiliy.’ ");
INSERT INTO uli_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ila lapal yamiy metafis! Ifa sew le ye paling pelal, maligach la hare altar la ye foru maligach la bo yebe santus? ");
INSERT INTO uli_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ila yodla semal be hatiwgiliy sew formel mo fal idal altar la ngo iy yesa hatiwgiliy fal idal altar mo pangal makla ye mel iyang; ");
INSERT INTO uli_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ngo hare semal ye hatiwgiliy sew formel mo fal idal Templum we, ila ngo sa wol hatiwgiliy mo fal mala idal Deus le ye mel lal Templum we; ");
INSERT INTO uli_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","hare semal ye hatiwgiliy sew formel mo fal mala idal lang ngo yesa hatiwgiliy mo fal idal Chiala liliyel Deus mo fal idal yeramtala ye mwaro iyang. ");
INSERT INTO uli_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ifa lepal hafohoy la be holahmi hami mekla sensel Hatobtob we mo Pharisees kala ye foriyeg yawmi! Hama tap maligach ngal Deus kassugfed chog mo irel meka delal mongoy le tappel mint, dill, mo cumin, iwe ngo ha tahchaloh foloy kala ye paleng pelal mo irel Hatobtob le, le tappel tugulul ladep, ffahol ladep, mo katos. Habe dabey foloy ka ngo ligdi bo ha towe tahchaloh ikla tot. ");
INSERT INTO uli_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ha togla mekla ha foforu ngo ha peppalir yarmat! Hama hadiyoli mekla limmi bo be chuy lang mo iyang, iwe ngo hama yorngaloh ka semal camel. ");
INSERT INTO uli_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ifa lepal tayikof le be holahmi hami mekla sensel Hatobtob we mo Pharisees kala ye foriyeg yawmi! Hama tela lugul kap mo tapiy kala yami ngo mekla lal, ila ye ssogol mekla ye yoh ngalugmi mo irel yami fedeg mo chehaw. ");
INSERT INTO uli_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hami Pharisees kala ha togla mekla ha foforu! Ha tela mwo lal kap kala yami, ila ngo yebe wol momay mekla lugul! ");
INSERT INTO uli_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ifa lepal tayikof le be holahmi hami mekla sensel Hatobtob we, mo Pharisees kala ye foriyeg yawmi! Ha wochog pekowe ye pen bbech sala momay mekla lugul, ngo mekla lal ila ye ssogol chi mo mekla sa mongongow. ");
INSERT INTO uli_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wol hafedeg ngalugmi chog le ha kekallehal momay ngalir yarmat ngo ha foriyeg, ngo ha ssogol molfid. ");
INSERT INTO uli_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ifa lepal tayikof la yebe holahmi hami mekla sensel Hatobtob we, mo Pharisees kala ye foriyeg yawmi! Hasa hallimdi mekla peyer profeta kowe mo rechokwe ye ssor Deus mo irer, iwe ngo ha kekawwulyaloh chog; ");
INSERT INTO uli_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ngo hama sor bo hare ha mel wol mwol chapdoh kowe yami, ngo ha towe faor molwe ir re foru we re llimeserloh profeta kowe. ");
INSERT INTO uli_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ila hasa spegil sor le hami ha chapdoh mo irer rechokwe re llimeserloh profeta kowe! ");
INSERT INTO uli_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ha loh ha bela hamalloloh mekla chapdoh kowe yami re chapidah! ");
INSERT INTO uli_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hami parchoyoh ngo hami lol parchoyoh! Be ifa sengal chog ngo hasa luwaley le habe kkewag tang Infiyerno? ");
INSERT INTO uli_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ibe kangalugmi le ibele fang ngalugmi tot profeta mo tot cho repiy mo sensey; ha bele llimeseloh sibis ir, ngo ha krudur tot, ngo ha wwodur ikla tot mo lal imwel ttey kala yami, ngo ha meri fedaler ikla sibis mo woal sew mo sew haplom bo habe llir. ");
INSERT INTO uli_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hagerger le bele holahmi ila fael rechokla re momay le re llimeserloh le ye chap mo irel Abel yee, la holadoh Zechariah we lol Berechiah. Zechariah iwe hami Jews ha llimeseloh mo llepdal Templum we mo altar we. ");
INSERT INTO uli_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ibele kangalugmi le hagergerel meka, ila be holahmi yarmetal fael mwole! ");
INSERT INTO uli_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Ho llimeserloh profeta kowe ngo ho hacchifir re hagloy kowe yael Deus we ye fangwey irem! Be fael fodow yai dipli ibe hatteyili fengalir panger mekla lom, le be wochog semal malog fefel kowe yema hatteyili fengali mekla pipiyal fael mekla paol, ngo gel ho temechal bo ibe foru! ");
INSERT INTO uli_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ila, Templum la yam ila yarmat re bele tahchaloh sala poel chog. ");
INSERT INTO uli_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ibe kangalug le bele chap igla sa loh, le tayor fael sew le hobe chil wiriyey yee, yela hola yodla hobe sor bo, ‘Deus yebe holbuwa yeramtala yebe budoh fael mala idel Samol.’” ");
INSERT INTO uli_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ye chuy Jesus mo irel Templum we le bele loh ngo resa budoh mokwe re dabeyal irel resa hatarofa yebe kemahoy imw kowe. ");
INSERT INTO uli_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesa kangalur bo, “Ye momay le habe kemahoy pangal imw ka. Ibe kangalugmi mele: tor sefaes feas ka le be mmochdiy liliyal, bo pangal ngo yebe mmedardardiy wototol.” ");
INSERT INTO uli_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus ye maroro wol molwe Tayitel Olives, ngo mokwe re dabeyal resa budoh irel le ir loh chog. Iwe resa kangalu bo, “Kangalugmem hare yinged mele yebe weldoh pangal meka iyang. Iwe ngo meda mele yebe weldoh le hagilel yodla hobe budoh, mo yodla ye bele miril faileng.” ");
INSERT INTO uli_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus sa sor bo, “Habe llugu dipmi bo semal de kacheprahmi. ");
INSERT INTO uli_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ye cholop yarmat le resa yeyedamgili bo rebe kapta meka yaloy le re bela budoh ngo re bele sor bo, ‘Ngang mele Kristus!’ Ngo ye cholop yarmat le ir tappel rechoka re bele kacheprar. ");
INSERT INTO uli_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Habe rongrong pupungul fedeg ka ye rep mo kaptal fedeg kala ye ddaw, iwe ngo ha towe rusmes. Tappel meka ila ye tugul le be weldoh, ngo halachog ila ted ila mele miril faileng. ");
INSERT INTO uli_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sew mo sew fuluy, ila re bele rol fedeg fengal; sew mo sew lam re bele rol fedeg fengal. Ye bele laengda ngo falmor pangal lobos. ");
INSERT INTO uli_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pangal meka ngo ye wochog bbareg la yebe hola semal cho siyal irel yodla yesa kikilsi yal tomay. ");
INSERT INTO uli_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Iwe ngo re bele ddorfugmi resa fang hami rebe hagrehmi ngo re llimesehmilog. Pangal yarmat ngo re bele hafobdurugmi le fael ngang. ");
INSERT INTO uli_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Irel yodla ngo ye cholop yarmat le bele torloh yar tugul; re bele yichingewar sibis ngo re hafobidrir sibis. ");
INSERT INTO uli_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Iwe ngo ye cholop le re bele forgirloh bo ir profeta, iwe ngo ye cholop le re bele cheparloh irer. ");
INSERT INTO uli_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bele ila sangal yal palleng loh tayikof luwul yarmat, iwe ngo bele tayikelloh yar hachangcheng yarmat. ");
INSERT INTO uli_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngo ligdi bo yeramtala be yedamgel yebe hola mala haygugulloh pangal formel ila yebe daor. ");
INSERT INTO uli_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iwe ngo Hapatpat Momay le kofal mala Lamliyel Laeng, ila re bele foloyu wol pangal ballel faileng le, le sew tugul ngalir panger yarmat. Iwe ngo sa moch budoh miril faileng. ");
INSERT INTO uli_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Habe wiri Molwe ‘Ye Haetael Hamotog’ le bele yaelloh ngulmi iyang, we profeta Daniel ye kapta. Le yebe su lobola ye santus.” (Madfagili fael mele!) ");
INSERT INTO uli_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Irel yodla ngo rechokla re mel Judea rebe ddar rebe loh wol tayit. ");
INSERT INTO uli_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hare semal mal ye mel wol imwla imwal, iwe ngo ye towe bidiy hasi mekla lital mo yilim. ");
INSERT INTO uli_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hare semal ye mel woal yal milay, iwe ngo towe tefael ngal imw we imwal bela hasi mengagol. ");
INSERT INTO uli_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ifa lepal yar be hafohoy fefel kala re siyal mo ikla ye chil ppachigchig layur! ");
INSERT INTO uli_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ha mepel ngal Deus bo ha towe rol kkewag irel yodla llifang hare Sabbath! ");
INSERT INTO uli_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bo hafohoy irel yodla ila be kkel hemas mo imol pangal hafohoy ka sa budoh irel yodwe ye subdog talople yee, la hola igla. Ila tayor sew hafohoy le be chil budoh fael sew le be wochog mele. ");
INSERT INTO uli_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngo ligdi bo Deus sa moll yal hawechi mala bungul, bo hare be te foru ngo tor le be molow. Bo fael rechoka yesa duwler bo re wolol mele sa hawechidoh bungul hafohoy la iyang. ");
INSERT INTO uli_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Iwe hare semal ye kangalug bo, ‘Kalladoh, Kristus iye le!’ hare ye sor bo, ‘Kallaloh, iye lay!’ — Iwe ngo ha towe chepar ngali. ");
INSERT INTO uli_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bo yor rechokla re bele la budoh le tot re bele forgirloh bo ir Kristus, ngo tot ikla re bele forgirloh bo ir profeta. Re bele ffaor kkemal kala yar bo hare be yoh le meka mwo Lol Deus ngo rebe wigdi deper. ");
INSERT INTO uli_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ha talenga! Isa kangalugmi mele mo imol mala bela hola yodla. ");
INSERT INTO uli_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hare yarmat re kangalugmi bo, ‘Ha kalloh, iye lay ye mel lal tolmay loh lay!’ Ngo ha towe loh lobola; hare re sor bo, ‘Ha kaladoh, iye le ye mwol iga!’ ngo ha towe chepar iyang. ");
INSERT INTO uli_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bo mala Layur Retalop le be budoh le be wochog ffis, le be ffis fedal lal laeng le be chaep mo meterral sa loh meldew. ");
INSERT INTO uli_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Te tugul loboska yor mael maes iyang ngo rebe tteydoh vultures iyang. ");
INSERT INTO uli_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bela wol miril hafohoy la, ngo bele gul yaal ngo towol wer meram. Ngo bele pungpungdiy fiis, ngo mekla kkelel laeng ila ye towol mel liliyal. ");
INSERT INTO uli_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iwe ngo mala hagilel mala Layur Retalop, ila bele llahdoh mo lal laeng; ngo pangal yarmetal talop ngo re bele tetang irel yodla rebe wiri mala Layur Retalop, le yebe budoh mo luwul darmiy luwul mala kkelal mo falmay la yal. ");
INSERT INTO uli_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ye bele ddig rappa, ngo bele hagloyurloh angelus kowe lol yisre mo yisre talople, ngo re bele la hatteyili fengalir yarmat kala lol le sa duwler mo wol pangal loh faileng le. ");
INSERT INTO uli_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Yor mele habe medaf iyang mo irel ire le fig. Yodla be chaep yal fetaer mekla ral, ngo ye fetaerwey mekla yull, ngo hami ha bele gola le sa harep llereg. ");
INSERT INTO uli_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yebe ila sengal chog yodla ha bela wiri meka bele llahdoh, iwe ngo ha bele gola le yodwe ila sa harep le bele chaep. ");
INSERT INTO uli_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Hade maligili le meka ila be weldoh mo imol mala rechoka re chil molow igla rebe mes. ");
INSERT INTO uli_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Be moaloh laeng mo talop, ngo mele yaloy ila tor fael sew le be moaloh. ");
INSERT INTO uli_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tor semal le ye gola hare yinged mele be hola yod la hare awa la. Angelus kala wol laeng mwo, ngo re togla; bo halachog Deus mele ye gola. ");
INSERT INTO uli_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Budohol mala Layur Retalop, ila be wochog mokwe ye weldoh irel molwe wolmwol Noah. ");
INSERT INTO uli_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ral kowe imol molwe ye burssogloh fuluy, ngo yarmat re popaoy le rema mongoy, ngo re yulul, ngo rema rol riri fengal yee, la hola yodwe ye bulong Noah lal Ark we: ");
INSERT INTO uli_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ngo re togla mele bele wel ngalir yee, la hola yodwe ye burssogloh fuluy sa hasirloh panger. Be iye sengal yodla be budoh mala Layur Retalop. ");
INSERT INTO uli_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Irel yodla ngo rumal mal ila rebe mel wol milay; semal ila rebe hasiloh, ngo semal ila be meldiy. ");
INSERT INTO uli_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rumal fefel ila rebe mel irel imwel fforol flowa; semal ila rebe hasiloh, ngo semal ila be meldiy. ");
INSERT INTO uli_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ha matalladugmi, bo ha togla seral le be budoh Samol la yami iyang. ");
INSERT INTO uli_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hare yeramtawe imwal imw we ye gola yodla be budoh cho machoh we iyang, ngo habe hatugulu mo lal dipmi le bele paoy le towe masor, bo cho machoh we de bulong lal imwe imwal. ");
INSERT INTO uli_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ila hami habe hafelfel chog bo mala Layur Retalop, ila yebe budoh irel sew awa le ha te luluwaley loh le be budoh iyang. ");
INSERT INTO uli_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ila ngo, itey semal boy le ye katos ngo ye repiy? Yeramtawe masta we yal sa yitol le iy mele be kekamahoy boy kowe tot, bo be ma fang haler irel yodol mongoy. ");
INSERT INTO uli_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ifa lepal yal be rraey boy la irel mala masta we bela budoh sala wiri yal foforu meka. ");
INSERT INTO uli_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ibe kangalugmi le masta we bele yitliy boy we le iy mele bele kekamahoy pangal mokwe lital. ");
INSERT INTO uli_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Iwe ngo hare iy semal boy kowe ye tayikof, ngo iy chog llufulyal ngo bele luluwaley le masta we yal ila towe ttiril tefael, ");
INSERT INTO uli_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ngo bele chap yal lliy fedaler boy kowe chilal, ngo ye mongoy ngo ye yul ngalir rechokla retoa habbelas. ");
INSERT INTO uli_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Iwe ngo masta we yal boy we be tefael seral, le boy we te luluwaley loh le be tefael, ngo irel sew yad le ye towe gola. ");
INSERT INTO uli_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Masta we bele ddabeyloh, le be wochog mokwe rema faor ngalir rechoka rema fforiyeg. Ye bele la tetang ngo ye ketangtingi fedaley mekla ngil. ");
INSERT INTO uli_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Irel yodla ngo mala Lamliyel Laeng ila be iye sengal. Fael sew yad ngo ye mel seg lefechig le re hasi habbul kala yar resa loh bo re bela wiri semal mal le bele habulupoy. ");
INSERT INTO uli_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Limmal ir ila re buch, ngo limmal ir ila re repiy. ");
INSERT INTO uli_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ikowe re buch re hasi habbul kowe yar, ngo tor holugul chall le re hasi, ");
INSERT INTO uli_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ikowe re repiy re kak holugul chael habbul kowe yar. ");
INSERT INTO uli_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iwe ngo mal we yebe habulupoy ye te ttirdoh. Iwe ngo lefechig kowe resa chichim fedal irel yar hadol yee, re mmasorloh. ");
INSERT INTO uli_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Yela lugulbong, ngo yesa ttawul semal yarmat le ye sor bo, ‘Yesa budoh mal we yebe habulupoy! Ha budoh habe wiri!’ ");
INSERT INTO uli_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Resa mmatdah lefechig kowe seg resa hammal wikel habbul kowe yar. ");
INSERT INTO uli_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Iwe ngo ikowe re buch resa kangalur ikowe re repiy bo, ‘Ha fang chael habbul ka yamem bo bele gulloh.’ ");
INSERT INTO uli_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Iwe ngo lefechig kowe re repiy resa sor bo, ‘Towe mmal bo towe yoh fengal chaell yach habbul. Ha loh stowa bo ha bela chuway yami.’ ");
INSERT INTO uli_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Iwe ngo lefechig kowe re buch resa loh bo re bela chuway chael habbul kowe yar; yodwe resa loh ngo mal we be habulupoy yesa budoh. Lefechig we limmal we re faesul fel resa dabeylong yilim irel gublul habulupoy we, iwe ngo resa piltaloh hatam we. ");
INSERT INTO uli_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Yela ssulayloh, ngo lefechig kowe tot resa moch tefaldoh. Resa maliliy le re hapallingi yalor le re sor bo, ‘Sugu hatam le melap bo habe bulong!’ ");
INSERT INTO uli_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mal we be habulupoy yesa sor bo, ‘Itowe sugu bo ngang ituglahmi.’” ");
INSERT INTO uli_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iwe ngo Jesus sa hasiyaloh le ye sor bo, “Habe llugu dipmi bo ha togla ralla iy, hare awa le iy mele yebe budoh mala Layur Retalop iyang. ");
INSERT INTO uli_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Irel yodla ngo mala Lamliyel Laeng ila be iye sengal; fael sew yad ngo semal mal sa luluwaley bele ligdi mala bugtal bela malekah; yesa ffesangur boy kowe yal sa kangalur rebe kekamahoy mokwe lital. ");
INSERT INTO uli_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ye fang ngalir salpiy le ye fed sallepal semal mo semal ir: ye fang ngal semal limngeras faesol salpiy le hoal, ngo ye fang ngal semal rungeras, ngo ye fang ngal ila semal sangeras. Iwe ngo sa moch loh irel malekah we yal. ");
INSERT INTO uli_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Boy we ye yoh ngali limngeras faesol salpiy ila yodwe chog, ngo sa hayengangali salpiy we ye hasi sala wol yohdoh limngeras mo iyang. ");
INSERT INTO uli_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wol ila sengal chog mele boy we ye hasi rungeras faesol salpiy ye foru iwe sala wol yoh ngali rungeras faesol salpiy. ");
INSERT INTO uli_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Iwe ngo boy we ye hasi sangeras faesol salpiy, ye loh sala kilingi sew lib sa lebagili salpiy we lol masta we yal iyang. ");
INSERT INTO uli_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Yela ssulayloh, ngo sa tefaldoh masta we yar boy kowe ngo ir resa budoh bo rebe pangi salpiy kowe. ");
INSERT INTO uli_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Boy we ye hasi limngeras faesol salpiy yesa budoh sa fang wol limngeras. Iwe yesa sor bo, ‘Ho fang ngalyey limngeras faesol salpiy. Kemahoy! Wol limngeras faesol salpiy iye le ye yoh ngalyey.’ ");
INSERT INTO uli_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Masta we sa kangalu bo, ‘Ye momay mele hosa foru. Gel semal boy kowe ho momay, ngo homa katos irel yam hammale meka ye wechich. Ila ibele yutlug le hobe kekamahoy ikla ye paleng. Budoh irey hobe dabeyey irel rraey le yai!’ ");
INSERT INTO uli_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Iwe ngo boy we ye hasi rungeras faesol salpiy yesa bulong ngo yesa sor bo, ‘Ho fang ngalyey rungeras faesol salpiy. Kemahoy! Wol rungeras faesol salpiy ika sa wol yoh ngalyey.’ ");
INSERT INTO uli_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Iwe masta we sa sor bo, ‘Ye momay mele hosa foru! Homa katos irel yam hammale meka ye wechich, ila ibele yutlug hobe kekamahoy ikla ye ppalingling. Bulong bo hobe dabeyey irel rraey le yai!’ ");
INSERT INTO uli_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Iwe ngo boy we ye hasi sengeras faesol salpiy sa bulong ngo sa sor bo, ‘Igula le gel semal rechokwe ho tema fahor yarmat: homa gilsi uwal melai kate faduguyem ngo ho hoteli fangali uwal melai ka hote hamormor faesol ire iyang. ");
INSERT INTO uli_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngang iy metagug, iwe isa loh isla lebagili salpiy we lom. Kemahoy! Salpiy we lom iye!’ ");
INSERT INTO uli_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Masta we yal sa sor bo, ‘Gel semal boy le ho tayikof, ngo ho tehayreg! Ho gola le ima kak mongoy mo lobola te ngang mele ifod iyang, ngo ima kak mongoy mo lobokkala ite hamormor faesol ire iyang, hare te ila sengal we ho sor? ");
INSERT INTO uli_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Medalbo iye ngo hobe yetolong salpiy la layi lal bank, ila ngo be yoh ngaliyey pangal salpiy la, mo mala winal irel yodla ibela tefal. ");
INSERT INTO uli_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ha hasi tangi salpiy la, ngo hasa ngaley yeramtala ye mel seg sengeras faesol salpiy irel. ");
INSERT INTO uli_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bo panger rechokla yor sugfed formel irer, ngo be cholop mele be yoh ngalir sala far cholop hemas; ngo yeramtala tor formel irel, ila lepal sugfed le ye mel irel ngo rebe hasi tangi. ");
INSERT INTO uli_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ila boy le tor pelal ila habe ppedawey ligtam luwul ruchupung: bo bela tetang ngo ye ketangtingi mekla ngil mo iyang.’ ");
INSERT INTO uli_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Yodla bela budoh molwe Layur Retalop le sa mel bo semal King, ngo panger angelus ngo re bele dabedoh, ngo iy ye bele marro wol chiya la liliyel king, ");
INSERT INTO uli_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","iwe ngo panger yarmetal sere mo sere lam, ngo re bele tteydoh imol. Iwe ngo bele hamhelar le rebe ruwow tteyal mo iyang, le be wochog yael semal chol matmetal mael kowe ma hamus fetangi saaf mo goats. ");
INSERT INTO uli_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ye bele yitlir rechokla re momay rela gilemra irel, ngo ye yitlir ikla tot rela gilchegil. ");
INSERT INTO uli_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Iwe ngo King we bele kangalur rechokwe re mel rela gilemra bo, ‘Ha budoh hami rechokla mala Temay sa holbuwahmi. Ha budoh bo mele lamliyey ila bele mel bo yami, le sa faesul hafle chog irel yodwe ye subdoh faileng iyang. ");
INSERT INTO uli_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ila mesel koloh ngo ha fang halay, ngo ila mesel betbat ngo ha fang lemey chael, ngo ila wasoladoh ngo ha hasiyeyloh irel imw kala yimmi, ");
INSERT INTO uli_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","yela tor mengaguy ngo ha fang mengaguy, ngo ila tomay ngo ha hammalyey, ngo ila mel lal kalbus ngo ha budoh tefael mo irey.’ ");
INSERT INTO uli_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Iwe ngo rechokwe re momay re bele kasi bo, ‘Samol, yinged mele ha wurug le ho kolog ngo ha fang halam, hare ho betbat ngo ha fang lemom chael? ");
INSERT INTO uli_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yinged mele ha wurug le ho wasoladoh, ngo ha hasugloh irel imw kala yimem, hare tor mengagum ngo ha fang mengagum? ");
INSERT INTO uli_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yinged mele ha wurug le ho tomay, hare ho mel lal kalbus, ngo hamem ha tefael mo irem?’ ");
INSERT INTO uli_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","King we bele sor bo, ‘Ibe kangalugmi le te tugul sew yad le ha foru ngal semal rechoka ye hartal totol mo luwul meka wol bisiy, ngo ha for ngaliyey!’ ");
INSERT INTO uli_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Iwe ngo bele kangalur rechokla re mel rela gilchegil bo, ‘Ha chuy tangiyey hami rechokla ha tafel mo fael metal Deus. Ha roloh irel yaefla tor siyal le sa faesul hafelfel ngali Satan mo moniyan kala lol! ");
INSERT INTO uli_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ila mesel koloh, ngo ha temechal fang halay, ngo ila betbat ngo ha tafang lemey chael; ");
INSERT INTO uli_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ila wasoladoh, ngo ha temechal hasiyeloh irel imw kala yimmi, ngo la tor mengaguy, ngo ha temechal fang mengaguy, ngo ila tomay ngo imel lal kalbus ngo ha temechal hammalyey.’ ");
INSERT INTO uli_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Iwe ngo re bele kasiya bo, ‘Samol, yinged seral le ha wurug le ho koloh, hare ho betbat, hare ho wasoladoh, hare tor mengagum, hare ho tomay, hare ho mel lal kalbus ngo ha temechal tupungug?’ ");
INSERT INTO uli_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","King we bele hatefali le bele sor bo, ‘Ibe kangalugmi le te tugul sew yad le ha temechal tipingi semal rechoka re hartal totol, ngo hami ha temechal tipingiyey.’ ");
INSERT INTO uli_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Rechoka, ila rebe loh irel hagerger la tor siyal, iwe ngo rechokla re momay ila rebe loh irel molow la tor siyal.” ");
INSERT INTO uli_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yodwe Jesus ye moll yal foloyu pangal mokwe, ngo yesa kangalur mokwe re dabeyal bo, ");
INSERT INTO uli_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Hami ngo ha gola le sa fe rubong ngo sa hola molwe Bungul Paska, ngo mala Layur Retalop ila re bele fangloh bo re bela krudu.” ");
INSERT INTO uli_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iwe ngo tamol temarong mo mal kowe yar resa rol ttey fengal irel imw we imwel Caiaphas, we iy mele Llulupal Temarong, ");
INSERT INTO uli_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bo rebe meri sew fil le be yoh rebe ddorfi Jesus re sala llimeseloh le tor le be gola. ");
INSERT INTO uli_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Iwe resa sor bo, “Si towe foru irel bong le bo yarmat rede wahaha fedal.” ");
INSERT INTO uli_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus ye mel woal Bethany irel mala imwel Simon, semal mal le sa hafohoy irel mesel pekel. ");
INSERT INTO uli_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesus ye momongoy ngo sa bulong semal fefel le ye hasi sew molor kowe ye ffaor mo irel alabaster le yor lokowe ye cchaw paliyal iyang. Sa sugu lowe sa chaelfi ngal molwe chemel Jesus. ");
INSERT INTO uli_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mokwe re dabeyal re wiri molwe, ngo sa budoh yar ssong. Resa kasiy bo, “Meda mele yesa hatolpaloh lola iyang? ");
INSERT INTO uli_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hare ye wochog mala re taepe chuway lole, ngo ye cholop salpiy le be yohdoh mo iyang resa fang ngalir mael hafohoy!” ");
INSERT INTO uli_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus ye gola mokwe re sosor iwe sa kangalur bo, “Meda mele hala kekapta mekla le be tayikof depel fefel le iyang? Sew formel le ye momay mele fefel le sa foru ngaliyey. ");
INSERT INTO uli_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hami ila pangal yad ngo be yor mael hafohoy iremi, iwe ngo ngang ila te pangal yad ngo ibe mel ngalugmi chog. ");
INSERT INTO uli_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mele fefel le ye foru, ila yesa chaelfi ngaliyey lole bo yebe hafle mele holongoy mo imol yodla rebe lebayey iyang. ");
INSERT INTO uli_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ibe hatugulu ngalugmi igla le te tugul solbos mo lal faileng le, le rebe foloyu Ebangelium le mo iyang, ngo rebe kapta kofal mele fefel le sa foru bo yebe ma mmang ngalir yarmat.” ");
INSERT INTO uli_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iwe ngo semal mo luwulur chowe seg mo rumal le Judas Iscariot mala idal, ye loh irer tamol temarong kowe ye sala kasiyar, ");
INSERT INTO uli_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Meda mele habe fang ngaliyey le hare ngang ibe fang ngalugmi Jesus?” Iwe resa pangiloh silig faesol salpiy kowe silver resa ngaley. ");
INSERT INTO uli_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Iwe ngo sa chaep yael Judas mwemeri sew yad le yebe fel bo yebe hayholong Jesus lal payur rechokwe. ");
INSERT INTO uli_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Metamol rall mo irel molwe Bungul Flowa we tema yor Habboloh iyang, ngo mokwe re dabeyel Jesus resa budoh irel resa kasiya bo, “Iya lobosle ho dipli bo ha bela hafle bo si bela foru yach Mongol Paska mo iyang?” ");
INSERT INTO uli_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus sa kangalur bo, “Ha loh irel semal mal le ye mel wol haplom lay, ngo hasa kangalu bo: ‘Sensey we ye sor bo, Sa hola awa we yai; Ngang mo mokwe re dabeyey habe foru Mongol Paska we mo irel imw la yimom.’” ");
INSERT INTO uli_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mokwe re dabeyel Jesus re foru mokwe ye kangalur bo re bela foru, iwe resa loh re sala hafle Mongol Paska we. ");
INSERT INTO uli_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yela llefhafdoh, ngo sa budoh Jesus mo chowe seg mo rumal we re dabeyal resa marodiy bo rebe rol mongoy. ");
INSERT INTO uli_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yodwe resa rol momongoy ngo Jesus sa kangalur bo, “Ibe kangalugmi le ye mel semal mo luwulumi le ye bele fangloh ngang.” ");
INSERT INTO uli_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iwe sala tayikofloh lal deper mokwe re dabeyal. Iwe ngo sa chaep yael semal mo semal ir kasiy bo, “Samol, te ngang mala ho luluwaley hare?” ");
INSERT INTO uli_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iwe Jesus sa hatefali ngo sa sor bo, “Semal le be sew chog yamem chiri halmem flowa lal tohoh le, ngo ila yeramtala yebe fangloh ngang. ");
INSERT INTO uli_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Molwe Layur Retalop, ila bele mes le yebe wochog molwe Babior we ye Santus ye sor, ngo ligdi bo ifa lepal kkelel yal be hafohoy yeramtala be fangloh mala Layur Retalop! Ye far momay le yete subdoh yeramtala!” ");
INSERT INTO uli_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas we ye fangloh Jesus yesa kasiya Jesus bo, “Sensey, te ngang mala ho luluwaley, hare?” Jesus sa hatefali ngo sa sor bo, “Ila sengal le ho sor.” ");
INSERT INTO uli_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yodwe re momongoy, ngo Jesus sa hasi sew flowa sa mapela, yesa dipi flowa we, yesa ngaler mokwe re dabeyal. Yesa kangalur bo; “Ha hasi habe hangi, mele ila holongoy.” ");
INSERT INTO uli_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Iwe yesa hasi sew kap yesa kangalu Deus yal hachigchig, iwe yesa ngaler ngo sa sor bo, “Ha hasi pangmi habe yul mo iyang, ");
INSERT INTO uli_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mele ila cchay le ye bele mel bo tugulul bogtag le yael Deus, mele cchay ila bele serloh bo yagilir panger yarmat, bo yebe chuy fael molfid. ");
INSERT INTO uli_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ibe kangalugmi le tayor fael sew le ibe chil yul wine le yee, la hola yodla ibe yul wine la ye tefoy mo irel lobosla Lamliyel mala Temay.” ");
INSERT INTO uli_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iwe resa yawli sew ton ngo resa loh irel molwe Tayitel Olives. ");
INSERT INTO uli_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iwe ngo Jesus sa kangalur bo, “Bongey le chog ngo pangmi ngo ha bele ddar tangiyey, bo Babior we ye Santus ye sor bo, ‘Deus bele llimeseloh chol matmetal saaf we, ngo saaf kowe ila re bele medardar fedal.’ ");
INSERT INTO uli_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngo ligdi bo wol miril mala ibe molow tefel mo irel maes, ngo ibe hamoloh mo imomi wol Galilee.” ");
INSERT INTO uli_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Iwe ngo Pedrus sa kangalu Jesus bo, “Tor fael sew le ibe lugdug, le ila mwo panger ika sibis ngo re lugdug loh!” ");
INSERT INTO uli_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus sa kangalu Pedrus bo, “Ibe kangalug le imol mala be kkogo mael bongey, ngo bele fael suluw yam sor bo ho toglayey.” ");
INSERT INTO uli_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedrus sa hatefali ngo sa sor bo, “Ila mwo idaboh irel maes, ngo tor fael sew le ibe sor bo ituglah!” Iwe ngo panger ikowe sibis ngo wol ila sengal chog mele re sor. ");
INSERT INTO uli_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iwe ngo Jesus mo mokwe re dabeyal resa loh solbos le rema sor bo Gethsemane ngo yesa kangalur bo, “Ha paoy mo iga bo ngang ibe loh mo iglay bo ibela mapel.” ");
INSERT INTO uli_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesus yesa ffesangu Pedrus mo rorumal tarmal kowe lol Zebedee. Sa kkel weresel mo tayikofel lal depal, ");
INSERT INTO uli_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","sa kangalur bo, “Sa kkel weresel mo tayikofel lal mele depey le sa fesugfed ngo bele ppediyeydiy wototol. Ha mel iga habe dabeyey irel metlag.” ");
INSERT INTO uli_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sa dar tangir sugfed, ngo yesa ngarchapdiy wototol sa mepel le ye sor bo, “Temay Deus, hare be mmal ngo hosa hachuya tangiyey kapal hafohoy le! Iwe ngo ligdi bo te mele depey mele hobe dabey, bo mala depom mele iy be dabey.” ");
INSERT INTO uli_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iwe yesa tefael loh irel mokwe re dabeyal we solmol ngo sala wirir le resa masor; ngo yesa kangalu Pedrus bo, “Meda mele ye foru le hami rosolmol ngo mala mwo sew awa, ngo ye temmal le habe dabeyey irel metlag iyang? ");
INSERT INTO uli_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ha mmat habe metlag ngo ha mepel bo de weg dipmi ngal molfid. Ye kkel dipmi ngo tayikel holongmi.” ");
INSERT INTO uli_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus sa wol tefael loh sala mapel, “Temay Deus, hare towe mmal le be te budoh kapal hafohoy le, le ibe te yulmi, ila ngo mala dopom mele ibe dabey.” ");
INSERT INTO uli_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yela wol tefaeldoh fael sew, ngo sala wiri mokwe re dabeyal le re masor; bo sa kkel yar chow. ");
INSERT INTO uli_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesus sa wol ligdir sa loh sala mapel. Ila mala hasluwel yal la mapel le ye wol tefael ngali chog mepel kowe yal. ");
INSERT INTO uli_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Iwe yela tefaeldoh irel mokwe re dabeyal ngo sa kangalur bo, “Ha chil memasor? Ha kalloh! Sa hola yodwe molwe Layur Retalop be yoh long lal payur choto hamolfid. ");
INSERT INTO uli_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ha sudah siya loh. Ha kalloh, yeramtawe ye fangloh ngang iye lay!” ");
INSERT INTO uli_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yodwe Jesus ye chil kapatpat ngo sa dohdoh Judas we iy semal mokwe re dabeyal we seg mo rumal. Ye cholop yarmat le ye palirdoh le re kak sayden mo tabtabol ire le tamol temarong mo mal kowe yar mele re hagloyurdoh. ");
INSERT INTO uli_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yeramtawe ye fangloh Jesus, sa moll yal kangalur buwa we hagil la yebe foru le ye sor bo: “Semal le ibe fesngo, ngo ila yeramtala iy. Ha ddorfi habe hasi.” ");
INSERT INTO uli_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas sa dar wwel ngal Jesus sa kangalu bo, “Sensey, hopos be mel irem,” iwe ngo sa fesngo. ");
INSERT INTO uli_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus sa kangalu bo, “Maryarey, hatturug irel mekla hobe foru!” Iwe resa ddorfi Jesus resa hamachuhamayu. ");
INSERT INTO uli_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Semal rechokwe ye dabey Jesus sa yuldadah sayden we lol sa ffela ngal boy we yael Llulupal Temarong we, sala supiloh sere molwe talengal. ");
INSERT INTO uli_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus sa kangalu bo, “Hatefalilong sayden la lom lal mala liliyal. Panger rechokla rema kak sayden ngo rema mes irel saydan. ");
INSERT INTO uli_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ho togla le be yoh le ibe kangalu mala Temay bo yebe tipingiyey, le be yodle chog ngo be yoh le be fangdoh fedngeras mwo angelus? ");
INSERT INTO uli_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hare ye wochog bo ye foru le ila sengal, ila ngo be ifa sengal ngo sa katos mokwe Babior we ye Santus ye sor bo yebe weldoh.” ");
INSERT INTO uli_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iwe Jesus sa hapatpat ngalir buwa we le ye sor bo, “Meda fal le ha sala budoh mo lomi sayden mo tabtabol ire bo habe dorfiyey, le ye wochog molwe ngang semal mael tayikof? Pangal ral ngo ima marro isa foloy lal Templum we ngo ha te dorfiyey. ");
INSERT INTO uli_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngo ligdi bo pangal meka ngo be wel bo bela llah le ye katos mokwe profeta kowe re tefa lal Babior we ye Santus.” Iwe ngo panger mokwe re dabeyal ngo resa ddar tangi. ");
INSERT INTO uli_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Rechokwe re ddorfi Jesus resa hasiloh irel imw we imwel Caiaphas, we Llulupal Temarong, le ila lobola mokwe sensel Hatobtob we mo mal kowe yar resa rol ttey fengal mo iyang. ");
INSERT INTO uli_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedrus ye dedaber le ye dedar chog mo medaw yee, rela hola yororol imw we imwel Llulupal Temarong we. Ye bulong lal yoror we sala marodiy irer pos kowe bo be kemahoy mele rebe faor ngal Jesus. ");
INSERT INTO uli_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tamol temarong kowe mo panger chol Ttey we choluwar ngo re mwemweri mele rebe tungudah bo derel Jesus bo hare be yoh le rebe llimeseloh; ");
INSERT INTO uli_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ye cholop le ye buyoy mo imor yarmat sala tungtung kaptal Jesus, iwe ngo ila mwo ngo tor mele re wiri bo derel. Ye la wol miril loh ngo sa sudah rumal mal ngo resa sor bo, ");
INSERT INTO uli_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Mal le ye sor bo, ‘Be yoh ngali yei le ibe hamdera Templum le yael Deus ngo bela solral mo wol miril ngo isa hasu tefali.’” ");
INSERT INTO uli_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Llulupal Temarong we sa sudah ngo sa kasiya Jesus bo, “Tor mele hobe sor bo tefaelel mekla resa sor bo derem?” ");
INSERT INTO uli_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iwe ngo Jesus te malili. Llulupal Temarong we sa wol malili ngali le ye sor bo, “Hobe hatugulu ngalugmem fael mala idel Deus, hare gel Kristus we Lol Deus.” ");
INSERT INTO uli_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus sa hatefali ngo sa sor bo, “Gel mele ho sor. Iwe ngo ibe kangalugmi pangmiloh le igla sa loh, ngo ha bele wiri mala Layur Retalop le be marro rela gilemra irel yeramtala ye Hartal Tagiyet le be bidiy mo wol laeng luwul darmi!” ");
INSERT INTO uli_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Llulupal Temarong we sa mesreyi mokwe mengagol ngo sa sor bo, “Yesa hapatpat tayikof irel Deus! Tayor pelal le yarmat rebe budoh sor derel. Hasa rongrong hapatpat tayikof kowe ye sor we te katos irel Deus. ");
INSERT INTO uli_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ila go mada mele habe chil sor iyang?” Resa sor bo, “Iy mele ye tabung, ila ye momay le be mes.” ");
INSERT INTO uli_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Iwe resa gutdah wol molwe metal ngo re lliy fadaley; iwe ngo rechokwe re ppigri resa sor bo, ");
INSERT INTO uli_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kristus! Hare gel semal profeta ngo hosa kangalugmem hare itey le ye ppugrug!” ");
INSERT INTO uli_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedrus ye marro ligtam lal yororol imw we ngo semal lefechig kowe boyel Llulupal Temarong we sa budoh irel sa sor bo, “Wol gel semal mokwe re dabeyel Jesus we semal yarmetal Galilee.” ");
INSERT INTO uli_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngo Pedrus ye sor mo imor pangerloh le ye togla Jesus. Ye hatefali le ye sor bo, “Itugla fael mekla ha sosor!” ");
INSERT INTO uli_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ngo yesa buyoy mo metal hatmal yoror we. Semal lefechig le semal boy sala wiri ngo sa kangalur mal kowe loboswe bo, “Yeramtale ila semal mokwe re dabeyel Jesusel Nazareth.” ");
INSERT INTO uli_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedrus sa wol sor bo, “Ibe hatugulu le itugla mal la!” ");
INSERT INTO uli_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tey ssulay mo wol miril ngo mal kowe re su lobowe resa budoh irel Pedrus ngo resa kangalu bo, “Gel semal mokwe chilal Jesus bo si gula mo irel ddigil yam hapatpat!” ");
INSERT INTO uli_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Iwe ngo Pedrus sa sor bo, “Ibe hatugulu mo fael metael Deus le ye katos meka i sosor! Deus la yai be fang yai hagerger hare ikachapar! Itugla mal la!” Yodwe chog ngo sa kkogo mael, ");
INSERT INTO uli_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ngo sa mmang ngal Pedrus molwe Jesus ye kangalu we ye sor bo: “Imol mala be kkogo mael, ngo bele fael suluw yam sor bo ho toglayey.” Yesa buyoy mo yulgul yoror we sala tetang mo iyang le sa kkel tayikofel lal depal. ");
INSERT INTO uli_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Llemaliyel chog ngo panger mal kowe yar mo tamol temarong kowe resa rol ttey bo rebe mweri mele be mel bo derel Jesus bo hare be yoh le rebe llimeseloh. ");
INSERT INTO uli_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Resa chena ngo resa hasiloh irel Pilatus we semal yarmetal Roma we iy mele tamol Aam. ");
INSERT INTO uli_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yodwe Judas yela gola le resa hatugulu le re bele llimeseloh Jesus ngo sa rrig lal depal sa hatefali faesol salpiy we silig we silver ngalir mal kowe yar mo tamol temarong kowe. ");
INSERT INTO uli_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ngo sa sor bo, “Isa molfid bo isa fangloh semal mal le tor mele ye hadre bo re bela llimeseloh!” Iwe ngo ir resa sor bo, “Meda mele hamem ha bela kekadagi iy mala iyang? Gel mele yam haffaor mala!” ");
INSERT INTO uli_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas sa ppedadiy faesol salpiy kowe lal Templum we ngo sa ligdir; sa loh sala fargu yuyal. ");
INSERT INTO uli_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tamol temarong kowe resa hasi faesol salpiy kowe ngo resa sor bo, “Mele ila salpiyel ccha, ngo ye tafel mo irel Hatobtob we yach le sibe chila ngal molwe salpiyel Templum.” ");
INSERT INTO uli_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","La sew loh chog deper irel salpiy we, ngo resa tapeli salpiy we bo rebe chuwayi sedep bugat le rema sor bo Bugtael Choel Fforel Raw bo liliyel peyer wasola. ");
INSERT INTO uli_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ila fal le resa hadeda malmal le bo “Bugtal Cha” yee la hola doh rralka. ");
INSERT INTO uli_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iwe ngo molwe profeta Jeremiah sa moal sor ila sala llah le katos: “Resa hasi faesol salpiy we silig we silver le ila lepal mele yesa tugul mo irer yarmetal Israel bo rebe fang bo paliyal, ");
INSERT INTO uli_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ngo resa tapeli salpiy le bo rebe chuwayi sedep bugat Bugtael Choel Fforel Rawwe, le ila sengal le Samol ye kangaluyey.” ");
INSERT INTO uli_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus ye su imol Pilatus bo Pilatus be haddogoyu. Iwe yesa kasiya bo, “Gel mele king we yar Jews?” Jesus sa hatefali ngo sa sor bo, “Gel mele ho sor.” ");
INSERT INTO uli_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iwe ngo te palili mokwe mal kowe yar mo tamol temarong kowe re sor bo derel. ");
INSERT INTO uli_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Iwe ngo Pilatus sa kasiya bo, “Ho tarongrong lepal mekla derem le re sosor?” ");
INSERT INTO uli_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ye kkel yal lluwdah Pilatus irel molwe tor sepad hapatpat kowe le Jesus ye palili. ");
INSERT INTO uli_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pangal Bungul Paska, ngo Pilatus yema to hachuya semal mo lal kalbus le yarmat cholop rebe dangro. ");
INSERT INTO uli_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Irel yodla ngo ye mel semal chol kalbus le Jesus Barabbas mala idal le pangal yarmat ngo re gola. ");
INSERT INTO uli_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iwe ngo yodwe resa ttey fengal buwa we ngo Pilatus sa kasiyar bo, “Ifa semal le iy be taldi? Jesus Barabbas hare Jesus we rema ffesangu ngali bo Kristus?” ");
INSERT INTO uli_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ye faesul gola le tamol kowe yar Jews resa fang ngali Jesus bo fal yar loltemay. ");
INSERT INTO uli_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yodwe Pilatus ye maroro lal imwel tatelal hapatpat we, ngo sa budoh yalol molwe ril irel le ye sor bo: “Tor mele hobe faor ngal mal la bo tor mele ye hadre, bo iddelagili bongwe ngo ye kkel yai weres irel.” ");
INSERT INTO uli_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tamol temarong kowe mo mal kowe yar resa kangalur chog yarmat bo rebe dangro Pilatus yebe taldi Barabbas, ngo sa fang Jesus bo rebe llimeseloh. ");
INSERT INTO uli_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Iwe ngo Pilatus sa kasiyar buwa we bo, “Itey mo irel chole rumal le ha dipli bo ibe taldi?” Iwe resa sor bo, “Barabbas!” ");
INSERT INTO uli_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus sa kasiyar le ye sor bo, “Ila ngo meda mele ibe faor ngal Jesus le rema ffesangu ngali bo Kristus?” Resa hatefali ngo resa sor bo: “Krudu!” ");
INSERT INTO uli_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ngo Pilatus sa kasiyar le ye sor bo, “Meda tayikof le sa foru?” Iwe ngo resa chapiy yar tetawul le resa hartaloh lepal yalor le re sor bo: “Krudu!” ");
INSERT INTO uli_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yodwe Pilatus yela gola le tayor pelal le be taboloh yal hapatpat bo de budoh wahaha, ngo yesa tela paol mo imor buwa we ngo sa sor bo, “Te ngang mele yai haffaor le be mes mal le! Bo hami mele yami haffaor!” ");
INSERT INTO uli_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pangerloh buwa we ngo resa hatefali le re sor bo, “Ligdi kofal yal mes be mel uwomem mo meka lomem!” ");
INSERT INTO uli_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iwe ngo Pilatus sa taldi ngalir Barabbas; wol miril yar wwodu Jesus ngo yesa fangloh bo re bela krudu. ");
INSERT INTO uli_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Saldaw kowe resa hasilong Jesus lal imwe imwel tamol aam we, ngo resa rol ttey fengal mo panger saldaw kowe choluwar. ");
INSERT INTO uli_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Resa hachuya mokwe mengagol resa hamengagu ngal sew mengag kowe ye checcha. ");
INSERT INTO uli_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Iwe resa ffaor marel ral ire kowe yor chil resa hamwarmware ngali ngo re yetolong setab ire lal paol; resa hasubgudiy imol resa tapeli fedaley kamemal ngo rema sor bo, “Be ssulay King le yar Jews!” ");
INSERT INTO uli_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Resa gutdah uwol ngo re hasi tabol ire we resa wwodu ngal molwe chemal. ");
INSERT INTO uli_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yodwe yela moll yar tapeli fedaley kamemal, ngo resa hachuya mengag we re moch yetedah uwol, ngo resa hasi ikowe faesul mengagol resa hatefalidah uwol. Iwe resa paliloh bo re bela krudu. ");
INSERT INTO uli_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yodwe re loloh ngo re sala chungu semal mal le ye budoh mo Cyrene le Simon idal, saldaw kowe resa dding ngali bo yebe hasi krud we yael Jesus. ");
INSERT INTO uli_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Resa budoh solbos we rema sor bo Golgotha, le fael mele ila “Liliyel Pol Fusug.” ");
INSERT INTO uli_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","La lobole ngo resa fang lemel Jesus wine le resa peda ngal semat tafey le ye merat, ngo la wol miril yal songu ngo ye tay mechal yul. ");
INSERT INTO uli_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Iwe resa krudu ngo resa hamhela mokwe mengagol uwor. ");
INSERT INTO uli_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ngo resa marodiy lobowe resa kekamahoy. ");
INSERT INTO uli_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Fael yal be mes ila ye teftaf woal chemel krud we le ye sor bo: “Iye mele Jesus King we yar Jews.” ");
INSERT INTO uli_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Iwe resa krudu rumal cho tayikof mo lengchel Jesus, semal mo rela gilemra ngo semal mo rela gilchegil. ");
INSERT INTO uli_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iwe ngo rechokwe rema dardoh lobowe rema yuchuchgaloh chemer ngo re hapatpat tayikof ngal Jesus le rema sor bo: ");
INSERT INTO uli_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Gel molwe ho sor bo hobe hatawsi Templum we ngo bela solral ngo hosa hasu tefali! Hadorah hare gel Lol Deus! Bidiy mo wol krud la!” ");
INSERT INTO uli_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wol ila sengal chog yar tamol temarong kowe mo mokwe sensel Hatobtob we mo mal kowe yar tapeli fadaley kamemal le re sor bo: ");
INSERT INTO uli_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ye hadorar sibis ngo ye teyoh be hadora iy llufulyal! Te ila king we yar yarmetal Israel? Hare ye bidiy mo wol krud la igla, ila ngo sibe chepar ngali! ");
INSERT INTO uli_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ye luglug depal irel Deus ngo ye sor le iy Lol Deus. Siya kemahoy hare Deus yebe mechal hadora igla!” ");
INSERT INTO uli_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wol ila senger mael tayikof we rumal we re krudur bo re wol hapatpat tayikof ngal Jesus. ");
INSERT INTO uli_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yodwe yela wwel yaal, ngo sa ruchupungloh luwul fuluy le suluw awa ssulayel. ");
INSERT INTO uli_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Molwe yela suluw kolok, ngo Jesus sa tawulagililoh le ye sor bo, “Eli, Eli, lema sabachthani?” Fal mele ila ye sor bo, “Yai Deus, yai Deus, meda mele hosa ttahcheyeyloh iyang?” ");
INSERT INTO uli_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tot rechokwe re su loboswe re rongrong yalol ngo resa sor bo, “Yesa fefasangu Elijah!” ");
INSERT INTO uli_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sa hamdaloh semal ir, sala hasi sedep forwa sa chiri irel sew wine kowe ye ppal paliyal yesa yetedah wol setab ire, ngo yesa hadingadah irel molwe yewal bo be yul. ");
INSERT INTO uli_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Iwe ngo rechokwe sibis resa sor bo, “Siya widi! Si bele kemahoy hare Elijah yebe budoh hadora!” ");
INSERT INTO uli_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesa wol ttawul loh Jesus ngo ye chuyloh yal ngas. ");
INSERT INTO uli_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iwe ngo sa ssahagloh mengag we ye chechengag we hopel Templum we sala rudep mo iyang. Sa falmor talop ngo ye mehalhal loh feas ngo ");
INSERT INTO uli_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","sa sugegloh pey ngo ye cholop mokwe Lol Deus we resa mes le re molow tefael. ");
INSERT INTO uli_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Resa rol chuy mo lal mokwe peyer, ngo la wol miril yal molow tefael Jesus mo irel maes ngo resa loh irel Haplom we ye Santus. Iwe ngo ye cholop le ye wirir mo iyang. ");
INSERT INTO uli_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yodwe tamol saldaw we mo saldaw kowe re mel irel we re kekamahoy Jesus re wiri falmor we mo pangal mokwe ye weldoh ngo resa rusmes. Iwe ngo sa sor bo, “Katos le iy Lol Deus!” ");
INSERT INTO uli_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ye cholop fefel lobowe le re rol kekaladoh mo medaw, le re dabedoh Jesus mo wol Galilee le rema kekamale. ");
INSERT INTO uli_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ye mel Mary Magdalene mo molwe ril Zebedee mo Mary we sil James mo Joses luwullur fefel kowe. ");
INSERT INTO uli_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yodwe yela llefhaf, ngo semal mal le ye mmal le semal yarmetael Arimathea sa hola doh loboswe; mala idal ila Joseph le wol iy semal re dabeyel Jesus. ");
INSERT INTO uli_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ye loh irel Pilatus sala dangro molwe porgol Jesus. Iwe ngo Pilatus sa fang yalol bo rebe fang ngal Joseph molwe porgol Jesus. ");
INSERT INTO uli_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iwe Joseph yesa hasi sew mengag le ye tefoy sa dugmi ngal molwe holongol Jesus, ");
INSERT INTO uli_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","yesa hasi ye sala yetolong lal sew pey yal le ted ssulay yar kilngilong mo wol pegil sew hogyal. Iwe yesa hatapuladoh sew porow le ye palleng sa pilta ngal hatmal pewe. Iwe ngo sa ligdi. ");
INSERT INTO uli_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene mo Mary we semal re maroro loboswe le re sapngal pewe. ");
INSERT INTO uli_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yela rallawe seral ngo Sabbath, ngo tamol temarong kowe mo Pharisees kowe resa budoh irel Pilatus ");
INSERT INTO uli_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ngo resa kangalu bo, “Tamol, sa mmang ngalugmem mala yalol mael mmachoh yewal we irel yodwe ye chil molow le ye sor bo, ‘Be solral ngo isa molow tefael mo irel maes.’ ");
INSERT INTO uli_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Fang yalom bo re bela posa mala peyal yee, la hola mala ha solralel bo dela yoh le mokwe re dabeyal re bela pere mala porgol, re sala kangalur yarmat le yesa molow tefael mo irel maes. Kachepar la ila be kel tot yal tayikof mo imol iwe metamo.” ");
INSERT INTO uli_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus sa kangalur bo, “Ibele fang pos ngo hasa loh bo ha bela haluglugu yami posa peyla.” ");
INSERT INTO uli_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iwe resa loh re sala haluglugu peywe le re yitet yar hagil irel porow we piltal peywe. Iwe ngo resa ligdir pos kowe bo rebe posa. ");
INSERT INTO uli_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lemeralel ralawe Sunday wol miril molwe bungul Sabbath, ngo Mary Magdalene mo Mary we semal resa loh re bela tefael mo irel peywe. ");
INSERT INTO uli_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Re tedaploh chog ngo yesa falmor; semal angelusel Samol sa bidiy mo wol laeng, sa hatapululoh porow we piltal peywe sa maro uwol. ");
INSERT INTO uli_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ye llahdoh le ye wochog ffis ngo mekla mengagol ila ye bbechrag. ");
INSERT INTO uli_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ppos kawe res rerrer irel kelel yar motog, iwe resa wochog maelmes kawe. ");
INSERT INTO uli_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angelus we yesa kangalur fefel kowe bo, “Ha towe motog. Igula le hami ha meridoh Jesus we re krudu. ");
INSERT INTO uli_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ye tay mel iga; yesa molow tefael mo irel maes, le igegel chog molwe ye sor. Ha budoh habe kemahoy loboswe ye yol iyang. ");
INSERT INTO uli_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ha hatturugmiloh ha bela kangalur mokwe re dabeyal bo yesa molow tefael mo irel maes. Yesa hamoloh mo imomi wol Galilee le ila lobosla ha bela wiri mo iyang. Ha towe maligili mele iy sa kangalugmi.” ");
INSERT INTO uli_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yodwe chog ngo resa ligdi peywe resa loh le re motog ngo re rraey. Resa ddar bo re bela kangalur mokwe re dabeyal. ");
INSERT INTO uli_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Re tedaploh chog ngo Jesus sa budoh irer ngo sa kangalur bo, “Hopos be mel iremi.” Resa budoh resa cchimdiy lengchel mokwe pechel resa hasrowu. ");
INSERT INTO uli_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesus sa kangalur bo, “Ha towe motog. Ha loh ha bela kangalur mokwe wol bisiy bo rebe loh woal Galilee bo ila lobosla ha bela rol wer fengal mo iyang.” ");
INSERT INTO uli_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Yodwe resa loloh fefel kowe ngo saldaw kowe re posa peywe resa tefael ngal haplom re sala kangalur tamol temarong kowe pangal mokwe yesa weldoh. ");
INSERT INTO uli_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tamol temarong kowe mo mal kowe yar resa ttey bo rebe gola mele rebe foru. Ye cholop salpiy le re ngaler saldaw kowe ngo resa kangalur bo, ");
INSERT INTO uli_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Habe sor le mokwe re dabeyal re budoh llubong resa pera molwe porgol irel yodla hami hasa rol masor. ");
INSERT INTO uli_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Iwe ngo hare Aam we bela rongrong mele, ngo hamem hasa moch gola mele habe foru le hami habe bung iyang. Ila tor mele hami habe merah iyang.” ");
INSERT INTO uli_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pos kowe resa hasi salpiy kowe ngo resa foru molwe resa kangalur bo rebe foru. Yela hola doh raleka, ngo ila hapatpat le Jews rema kapta fedaley. ");
INSERT INTO uli_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chowe seg mo semal we re dabeyel Jesus resa loh irel tayit we woal Galilee irel loboswe Jesus ye kangalur bo rebe loh iyang. ");
INSERT INTO uli_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ila mwo molwe tot ir ye ted tugul deper irel, ngo pangerloh ngo re hasrowu irel yodwe rela wiri. ");
INSERT INTO uli_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus sa harpardoh ngo sa kangalur bo, “Mala Temay wol laeng sa fang kkeley bo ibe lamli pangal formel mo wol laeng mo wol talop. ");
INSERT INTO uli_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ila ha loh pangal lobos ha bela forur panger yarmat bo rebe mel bo re dabeyey: Ha baptismusgilir, irel idel Temal, mo Lol, mo Espritu Santus, ");
INSERT INTO uli_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ngo hasa foloyu ngalir bo rebe talenga pangal meka sa moll yai kangalugmi. Iwe ngo Ngang ibe mel chog iremi pangal yad yee, la hola miril faileng.” ");
INSERT INTO uli_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iye Hapatpat Momay we kofal Jesus Kristus le Lol Deus. ");
INSERT INTO uli_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ye chaep mo irel babior we profeta Isaiah ye tefa: “Ye sor Deus bo, ‘Iye re hagloy we yai, le ibele hagloyu loh bo be hamo bo be sugu mala yalepam.’ ");
INSERT INTO uli_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Semal yarmat ila ye tetawul mo lobowe ye tolmay loh le ye sor bo: ‘Ha hafle mala yalepal Samol; ha haforu bo be wwel bo yebe darloh iyang!’” ");
INSERT INTO uli_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Iwe ngo Johannes sa lahdoh mo lal lobowe ye tolmay loh, ye baptismus yegilir yarmat ngo ye fofoloy le ye sor bo, “Ha tagul tang molfidmi ngo hasa baptismus bo ila ngo Deus yebe hachuya fal molfidmi.” ");
INSERT INTO uli_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ye cholop yeramtal Judea mo mekla haplomol Jerusalem le re budoh rebe talenga foloy kala yael Johannes. Ngo resa budoh puwafay ngo re baptismus lal mololul we Jordan. ");
INSERT INTO uli_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johannes ye mengag irel yulol camel ngo ye tertaer gil kanbow. Iwe ngo yema mongoy fedal chog malhawael mo luchfaes. ");
INSERT INTO uli_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Sa kangalur yarmat le ye sor bo, “Yeramtala bele budoh mo wol miriy ila ye tagiyet mo imoy. Yol bwela kala yal mwo ngo tor mmaley le ngang ibe haborohdiy bo ibe besi. ");
INSERT INTO uli_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngang ibaptismu yegulugmi irel chael ngo iy yebe baptismu yegulugmi irel Espritu Santus.” ");
INSERT INTO uli_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Te sulay mo wol miril ngo Jesus sa budoh woal Nazareth, we ye mel irel mokwe faluyel Galilee ngo Johannes sa baptismu yegili Jesus mo lal mololul we Jordan. ");
INSERT INTO uli_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yodwe chog ye bidah Jesus mo lal chael we ngo sa wiri laeng le sa sugeg ngo sa bidiy Espritu Santus uwol le ye llehal semal dove ");
INSERT INTO uli_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iwe ngo sa bidiy yalol Deus mo woal laeng le ye sor bo, “Gel mele layi le ihachangug, ngo ye fel depey irem.” ");
INSERT INTO uli_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yodwe chog ngo Espritu Santus sa hakkela lal depel Jesus bo be loh lal tolmay loh we, ");
INSERT INTO uli_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","le fayeg ral le ye ppaoy iyang irel lobowe ye cholop mael kowe re machoh iyang. Ngo sa budoh Satan bo be hagla hare be weg depel Jesus. Ngo angelus kowe resa budoh bo rebe tipingi Jesus. ");
INSERT INTO uli_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yela wol miril yar yetolong Johannes lal kalbus ngo Jesus sa loh wol Galilee bo bela hagolal ngalir yarmat Hapatpat Momay we ye budoh mo irel Deus. ");
INSERT INTO uli_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Iwe ngo sa sor bo, “Yodwe iye sa budoh ngo mala Lamliyel Deus ila sa harep! Ha tagul tang molfidmi iwe ngo hasa chepar irel Hapatpat Momay le!” ");
INSERT INTO uli_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Irel yodwe Jesus ye dedarloh wol ngachel Laom we Galilee ngo yesa wiri rumal mal le rema fita, le Simon mo Andrew we bisil le re wuwug. ");
INSERT INTO uli_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus sa kangalur bo, “Ha dabeyey bo ibe haskuna ngalugmi fital yarmat.” ");
INSERT INTO uli_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Irel yodwe chog ngo resa ligdi wug we yar ngo resa dabey Jesus. ");
INSERT INTO uli_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesus yesa sar darloh sugfed ye sala wiri wol rumal bisbis, James mo John le lol semal mal le Zebedee idal, le re mel yuchul wala war le re foforu wug kala yar. ");
INSERT INTO uli_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yodwe chog Jesus ye wirir ngo sa fesangur. Iwe mal we rumal resa ligdi Zebedee, we temer, mo chol yangang kawe yar, yuchul wawe, ngo resa dabey Jesus. ");
INSERT INTO uli_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus mo mokwe re dabeyal re loh yee rela hola doh sew haplom le rema sor bo Capernaum mala idal. Yodwe yela hola Sabbath ngo sa loh Jesus lal imwel ttey we ngo sala chaepiy yal foloy. ");
INSERT INTO uli_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rechokwe re rongrong foloy kowe yael Jesus ila re luwdah bo yete haffedeg ngalir sensel Hatobtob we le rebe foloy. Jesus ye fofoloy le ye wochog semal le yor kkelel foloy kala yal. ");
INSERT INTO uli_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Irel yodwe chog ngo sa bulong semal mal le yor moniyan uwol lal imwel ttey we ngo sa ttawul le ye sor bo, ");
INSERT INTO uli_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Gel Jesusel Nazareth, meda mele hobe faor ngalugmem? Hosa budoh le hobe hachuyahmem? Ngang ifaesul golah. Gel re hagoloy we yael Deus we ye Santus!” ");
INSERT INTO uli_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus sa kangalu moniyan we bo, “Ppoloh ngo hosa chuy mo uwol mal la!” ");
INSERT INTO uli_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Irel yodwe chog ngo moniyan we sa foru mal we bo be rer fedal ngo ye ttawul ngo ye chuyloh mo uwol. ");
INSERT INTO uli_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pangal yarmat ngo re lluwdah irel molwe Jesus sa foru. Iwe resa rol kasiy fengal luwulur, “Ifa sengal mele, sew foloy le moch tefoy doh? Yeramtale ila yor kkelal bo moniyan mwo ngo re ma talenga yalol.” ");
INSERT INTO uli_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iwe ngo yodwe chog ngo sa medar molwe kaptal Jesus wol pangal mokawe faluyel Galilee. ");
INSERT INTO uli_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sa chuy Jesus mo mokwe re dabeyal mo irel imwel ttey we resa loh irel imw we imwel Simon mo Andrew, le James mo John re daber. ");
INSERT INTO uli_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ye mel sil molwe ril Simon lal giyal le ye kkel bechel irel yal tomay ngo yodwe chog Jesus ye holadoh lobowe ngo resa kangalu kofal tomay we. ");
INSERT INTO uli_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sa loh Jesus irel sala holudah paoll sa hachemdage. Irel yodwe chog ngo sa chuy yal tomay sa budoh faor mekla yebe hammal ngalir. ");
INSERT INTO uli_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wol miril molwe sa dol yaal ngo sa lefhafdoh ngo resa hasirdoh irel Jesus panger rechokwe re tomay mo rechokwe yor moniyan uwor. ");
INSERT INTO uli_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Panger yeramtal haplom we ngo resa ttey doh metal imw we. ");
INSERT INTO uli_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ye cholop yarmat le re tomay le ye cholop metmetal maes kala ye mel uwor le Jesus sa hachuya iwe mo rechokla ye ssog moniyan uwor. Ye teyoh le moniyan kowe re sor sew formel bo ir ngo re gola le iy yeramtawe. ");
INSERT INTO uli_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lemeralel seral mo imol mala be werloh ngo sa mmat Jesus sa ligidi imw we. Sa loh mo yulgul hasohsoh we le torloh yarmat iyang, sala paoy iyang yebe mapel. ");
INSERT INTO uli_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yesa loh Simon mo mokwe choluwal re sala memeri fedaley lobole ye mel iyang. ");
INSERT INTO uli_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ngo yodwe rela wiri ngo resa kangalu bo, “Pangal yarmat ngo resa memerug.” ");
INSERT INTO uli_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus sa hatfaeli, “Si bele loh irel haplom kala ye repdoh iga. Ibela wol foloy mo iyang bo ila mele fal yai budoh.” ");
INSERT INTO uli_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iwe ngo Jesus sa loh wol pangal mokwe faluyel Galilee le ye fofoloy lal imwel ttey kowe yar ngo ye kkachuchuy moniyan mo uwor rechoka or moniyan uwor. ");
INSERT INTO uli_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Semal mal le ye pachngali mesel pekel ye budoh irel Jesus sa hasubguydi ngo sa hafalpechey bo yebe tipingi. Sa sor bo, “Hare ye fel mo lal dopom ngo be yoh le hobe hachuya tomay le mo uwoy.” ");
INSERT INTO uli_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus sa fahoy sa cchangloh sala yangsi ngo sa sor bo, “Ngoa, ye fel mo lal depey, bele chuy tomay la mo uwom.” ");
INSERT INTO uli_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Irel yodwe chog ngo sa chuy mesel pekel we mo uwol, iwe ngo sa momay loh molwe woal. ");
INSERT INTO uli_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iwe Jesus sa hakkela yal hapatpat ngali ngo sa kangalu bo bele loh. ");
INSERT INTO uli_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jesus sa hatobtob ngal mal we le ye sor bo, “Tor le hobe kangalu mele isa foru ngalug. Ho bele loh ngo hosa wweloh irel temarong we bo yebe kemahoy hare chil yor mesel pekel uwom hare tayor, iwe ngo hosa fang maligach we Moses ye sor le ila mala yam tugul ngalir yarmat le sa chuy meswe mo uwom.” ");
INSERT INTO uli_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iwe ngo mal we sa loh sala kapta fedaley molwe Jesus ye faor ngali. Ye sala kapta fedaley pangal lobos le ila fal le Jesus tay yoh le ye loh luwul yarmat mo wol sew mo sew haplom. Sala mel Jesus solboy le tor yarmat iyang, ila mwo ngo yarmat re meridoh le re budoh mo pangal lobos. ");
INSERT INTO uli_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","La fedral mo wol miril ngo Jesus sa tefael ngal Capernaum iwe ngo resa kapta fedaley le Jesus sa tefael ngal molwe bugtal. ");
INSERT INTO uli_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iwe ngo ye cholop yarmat le resa ttey doh le tayor lobos le rebe paoy iyang. Metal hatmal imw we mwo ngo sa wol ssog irel yarmat. Jesus sa foloyu ngalir mokwe yalol Deus. ");
INSERT INTO uli_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iwe ngo sa budoh famal mal le re hasidoh semal mal le ye mes pechel mo paol. ");
INSERT INTO uli_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ngo tayoh le rebe harpa Jesus bo sa cholop hamaes yarmat lengchel. Iwe re sala hattare solbos mo woal imw we mo irel lufulyel lobowe ye mel Jesus iyang. La mol yar hattere solbos mo irel imw we ngo resa habidiyo chotomay we mo iyang le ye mel lal sew chob. ");
INSERT INTO uli_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iwe ngo Jesus sa wiri kkelel yar tugul ngo yesa kangalu chotomay we bo, “Layi, sa chuy fael yam molfid.” ");
INSERT INTO uli_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yor tot mokwe sensel Hatobtob we le re maroro lobowe le re luluwaley long chog lal deper le re sor bo, ");
INSERT INTO uli_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Meda mele la iye sengal yael yeramtale hapatpat iyang? Mele ila sa sew hapaliyel ngal Deus. Bo halachog Deus mele ma yoh le be hachuya fael moldif!” ");
INSERT INTO uli_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yodwe chog ngo Jesus sa gola mele rechokwe re luluwaley ngo sa kangalur bo, “Meda fal le la ila sengal yami luluwal iyang? ");
INSERT INTO uli_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ifa sew le ye mechrag le ibe kangalu chotomay le, ‘Sa chuy fael yam molfid, hare sudah bo hobe hasi chob la giyem ngo hosa loh?’ ");
INSERT INTO uli_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ibele kewar ngalugmi le mele Layur Retalop ila yor kkelal lal talople le be hachuya fael molfid.” Iwe sa kangalu yeramtawe ye tomay bo, ");
INSERT INTO uli_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ibe kangalug igla, sudah ngo hosa hasi chob we giyem hosa loh lubugtam!” ");
INSERT INTO uli_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yodwe chog re chil kekal ngal tomay we ngo yesa sudah, sa hasi chob we giyal sa loh le ye nngat. Panger rechokwe lobowe ngo re lluwdah irel molwe Jesus sa foru ngal chotomay we ngo resa hapingpinga Deus le re sor bo tediyor fael sew le re wiri mele iye sengal. ");
INSERT INTO uli_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus sa wol tefael ngal Laom we Galilee. Resa ttey doh yarmat irel ngo iy sa chaepiy yal foloyur. ");
INSERT INTO uli_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ye dedarloh sala wiri semal chol hateyel paliyel raeg le Levi mala idal le lol Alphaeus le ye maroro lal yofis la yal. Jesus sa kangalu bo, “Dabeyey.” Levi sa sudah chog sa dabey. ");
INSERT INTO uli_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yela wol miril ngo Jesus sala mongoy irel imw we imwel Levi. Ye cholop chol hateyel paliyel raeg mo rechokla yarmat rete dipli wegdigir le re mel irel Jesus mo mokwe re dabeyal irel tis we. ");
INSERT INTO uli_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tot mokwe sensel Hatobtob we le sibis Pharisees resa wiri Jesus le ye momongoy irer rochokwe rete dipli wegdigir mo rechokwe chol hateyel paliyel raeg. Iwe ngo resa kasiya mokwe re dabeyel Jesus bo, “Meda fal le Jesus yela mongoy ngalir ttaper rechokla iyang?” ");
INSERT INTO uli_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus ye rongrong mokwe re sosor ngo sa hatfaeli le ye sor bo, “Rechokla rete tomay ila tor fal le togta be loh irer bo rechokla re tomay mele ma budoh togta irer. Ite budoh ibe ffesangur rechokla ye momay wegdigir bo ibudoh bo ibe ffesangur choto hamolfid.” ");
INSERT INTO uli_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","La seral mo iyang ngo mokwe re dabeyel Johannes Baptista mo Pharisees kowe resa supiy haler. Ngo resa budoh tot yarmat resa kasiya Jesus bo, “Meda fal le mekla re dabeyel Johannes Baptista mo mekla re dabeyer Pharisees kowe re supiy haler ngo mekla re dabeyem rete supiy haler iyang?” ");
INSERT INTO uli_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus sa sor bo, “Ha chichiy le rechokla re ffesangur loh irel sew gubulul habulupoy le re bela loh ngo tor mele rebe mongoy? Yodla ye mel mal la yal gubul la irer, ngo ye tafel le rebe supiy haler. ");
INSERT INTO uli_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngo ligdi bo ye mel ralela rebe hasi tangir mal we, ila ngo bele moch fel le rebe supiy haler. ");
INSERT INTO uli_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tor semal le ma hasi sedep mengag kowe ye tefoy sa depecha ngal sedep mengag kowe sa bes. Semal le be foru mele ngo bele hapalingiloh tarral mengag we sa bes. ");
INSERT INTO uli_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ngo tor semal le be wol mmal le be yitet long wine ka ye tefoy lal liliyel wine ka gil mael le sa bes, bo ila ngo wine la be hatawsi liliyel wine we gil mael sala serloh wine we, iwe sala towas fengal roruwow. wine ka ye tefoy ila ye momay le be bulong lal mekla liliyal le ye tefoy.” ");
INSERT INTO uli_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sew Sabbath ngo Jesus mo mokwe re dabeyal re dedarloh wol tot milayel wheat, ngo mokwe re dabeyal resa fichfich uwal wheat kowe. ");
INSERT INTO uli_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Iwe ngo Pharisees kowe resa kangal Jesus bo, “Kalloh, ye tafel ngal yach Hatobtob le mekla re dabeyem rebe foru mala wol Sabbath!” ");
INSERT INTO uli_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iwe ngo Jesus sa hatefaeli ngo sa sor bo, “Ha ted yawli mwo kaptal molwe David ye foru irel yodwe tayorloh haler mo mokwe woccholuwal we resa rol mesel koloh? ");
INSERT INTO uli_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Re bulong irel imw we imwel Deus re sala hangi flowa kowe resa taep maligach. Irel yodla ngo Abiathar mele Llulupal Temarong.” ");
INSERT INTO uli_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesus sa kangalur Pharisees kowe bo, “Sabbath ila ye sub le fal ngalir yarmat, ngo yarmat rete subdoh le fal ngal Sabbath. ");
INSERT INTO uli_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ila fal le mele Layur Retalop ila wol iy mele Samol le ye lamli Sabbath.” ");
INSERT INTO uli_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iwe ngo Jesus sa tefael ngal imwel ttey we le ye mel semal mal iyang le ye mes sere mala paol. ");
INSERT INTO uli_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yor tot yarmat lobowe le re memmesa hamayu Jesus bo hare be hachuya yael mal we tomay wol Sabbath iwe ngo resa itol bo derel. ");
INSERT INTO uli_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus sa kangalu mal we bo, “Budoh mo iga.” ");
INSERT INTO uli_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iwe ngo Jesus sa kasiyar yarmat, “Meda mele Hatobtob we yach ye sor bo sibe foru wol Sabbath? Sibe tipingi semal hare sibe hafohoyu? Sibe hamolowa semal hare sibe limesloh semal?” Iwe ngo tor mele ir re sor. ");
INSERT INTO uli_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus sa kal fedal luwulur rechokwe luwul yal ssong ngo sa tayikof depal irer irel yar tabung ngo ye kkef repiyer. Iwe sa kangalu mal we bo, “Hadingawey mala poam.” Mal we ye hadingawey chog molwe paol ngo ye chuyloh mes we mo iyang. ");
INSERT INTO uli_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iwe ir Pharisees kowe resa ligdi imwel ttey we re sala wol chufengal mo sibis mokwe woccholuwal Yerodes bo rebe tteyagili mele rebe foru ngo sa yor bol le rebe limeseloh Jesus. ");
INSERT INTO uli_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus mo mokwe re dabeyal resa roloh irel Laom we Galilee ngo sew buwal yarmat re daber, le re budoh mo wol Galilee, mo wol Judea, ");
INSERT INTO uli_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mo wol Jerusalem, mo mokwe faluyel Idumea, mo fulu kowe ye mel mo meralahol Jordan, iwe mo fulu kowe ye harepa haplom kowe Tyre mo Sidon. Pangerloh rechoka ngo re budoh irel Jesus bo resa rongrong mekla sa foforu. ");
INSERT INTO uli_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hasfalu lepal buwa we, iwe Jesus sa kangalur mokwe re dabeyal bo rebe hapsaloh seyay waa bo yebe mel yuchul bo resa hadibal fengal yarmat loboswe. ");
INSERT INTO uli_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sa cholop yarmat le yesa hachuya yar tomay. Panger rechoka re tomay ngo resa hadidiy long chog luwul yarmat bo re bela yangsi Jesus. ");
INSERT INTO uli_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iwe ngo rechokwe yor moniyan uwor, ila rebe wiri chog Jesus ngo resa hachapragirdiy mo imol ngo resa tawulahgili le re sor bo, “Gel molwe Lol Deus!” ");
INSERT INTO uli_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesus sa hasu yal hapatpat ngalir le ye sor bo, “Ha towe sor ngang.” ");
INSERT INTO uli_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iwe ngo Jesus yesa bidah wol sew tagitat le ye fesangur mal kowe ye duweler. Iwe resa budoh irel ");
INSERT INTO uli_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ngo yesa duweler chowe seg mo rumal sa hadedar bo Apostel. Iwe ngo Jesus sa kangalur bo, “Isa duwlehmi bo habe mel bo wol chilay. Ibele wol fangloh hami bo ha bela foloy fedal. ");
INSERT INTO uli_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ngo bele yor kkelmi le habe hachuchuy moniyan mo uwor yarmat.” ");
INSERT INTO uli_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ika rechokwe seg mo rumal we Jesus ye duweler: Simon (we Jesus ye hadeda ngali bo Pedrus); ");
INSERT INTO uli_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James mo molwe bisil we John we lol Zebedee (we Jesus ye hadedar bo Boanerges, fal mala ila “Lol Parr”); ");
INSERT INTO uli_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mo Andrew, mo Philip, mo Bartholomew, mo Matthew, mo Thomas, mo James we lol Alphaeus, Thaddaeus, Simon we semal Patriot, ");
INSERT INTO uli_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mo Judas Iscariot we ye fangloh Jesus. ");
INSERT INTO uli_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iwe sa loh Jesus irel molwe bugtal ngo sa wol ttey doh sew buwal yarmat le tay yoh le iy mo mokwe re dabeyal rebe ffaeg haler. ");
INSERT INTO uli_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yodwe mokwe chol bugtal Jesus rela rongrong kofal, ngo resa loh bo re bela hasi bo yarmat resa sosor le yesa buch. ");
INSERT INTO uli_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tot mokwe sensel Hatobtob we re budoh mo wol Jerusalem re sor bo, “Sa mel Beelzebul uwol.” Ngo resa wol sor bo, “Mala tamol moniyan mele sa fang kelel Jesus bo ye be yoh le be hachuchuy moniyan.” ");
INSERT INTO uli_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iwe ngo Jesus sa fesangur rechokwe bo rebe budoh irel bo yebe fiyongo ngalir tot fiyongol hawewe. Sa kangalur bo, “Be ifa sengal chog ngo Satan sa hachuya Satan? ");
INSERT INTO uli_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hare sew fuluy le rebe rure yarmat mo iyang ngo resa fedeg fengal, ngo ye tugul chog le be medarloh fulula. ");
INSERT INTO uli_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hare chol sew haleng le rebe hamahlar bo rebe rure mo iyang ngo resa rol fedeg, ila ngo ye tugul le rebe rol medarloh. ");
INSERT INTO uli_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ngo hare mala lamliyel Satan be hamahal bo be rure mo iyang, ngo towe yoh le be ssulay bo yebe medarloh. ");
INSERT INTO uli_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Towe yoh le semal yebe hatawsi ngo ye pere imwel semal mal le ye kkel le ye bete fargu mwo mal we ye kkel; iwe ngo sa moch yoh le be hasi mokwe lital. ");
INSERT INTO uli_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ihatugulu ngalugmi le be chuy fael yar yarmat molfid mo pangal mekla tayikof le re sor irel Deus. ");
INSERT INTO uli_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Iwe ngo semal le ye sor sew formel le ye tayikof irel Espritu Santus ngo towe yoh le be chuy fael yal molfid, bo sa foru sew molfid le tor siyal.” ");
INSERT INTO uli_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jesus ye sor mele bo tot yarmat re sosor le, “Jesus ila yor moniyan uwol.”) ");
INSERT INTO uli_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iwe ngo yesa budoh molwe sil mo mokwe wol bisil Jesus. Resa su ligtam resa kasiylong Jesus yilim. ");
INSERT INTO uli_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ye mel sew buwal yarmat le re maroro resa langbaloh Jesus, ngo resa kangalu bo, “Kalloh, molwe solom mo mokwe wol bisim iyer kala re mel ligtam le re kekasiy long gel.” ");
INSERT INTO uli_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus sa sor bo, “Itey iy mala seley? Ngo itey ir mekla wol bisiy?” ");
INSERT INTO uli_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jesus yesa kal ngalir rechokwe re maroro lengchel ngo sa sor bo, “Ha kalloh! Ika meka seley mo wol bisiy! ");
INSERT INTO uli_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Semal le ye foru mala Deus ye dipli, ngo ila mala bisiy mo mengay mo seley.” ");
INSERT INTO uli_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus sa wol chapiy yal foloy woal ngachel Laom we Galilee. Ye cholop yarmat le re langbaloh Jesus. Yesa chuy mo luwulur sala mel yuchul seyai boat le ye mel leted. Iwe ngo yarmat dolap resa rol su mo ngachel ted. ");
INSERT INTO uli_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ye teptap fiyong bo ye cholop mekla be foloyu ngalir. Iwe ngo sa sor bo, ");
INSERT INTO uli_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ha talenga! Ye mel semal mal le yela fadgu milay la yal. ");
INSERT INTO uli_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yodwe yela hamro kowe yal wol milay we ngo tot ye mordiy wol ngachel yalap, iwe ngo mael yeyal re budoh resa hangiloh. ");
INSERT INTO uli_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iwe ngo tot ila ye pung diy wol bol ka yor feas iyang le te cholop bol ka ye momay iyang. Te ssulay ngo sa tumul. ");
INSERT INTO uli_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Iwe ngo yela kkarloh yaal ngo sa habatbeta loh fedah kawe ye moch tumul bo te yod loh mokwe wahral luwul bol. ");
INSERT INTO uli_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tot fedah kowe ye pungdiy luwul waluwol kowe yor chil. Yela palengdah ire kowe yor chil sala farorloh fedah kowe iyang sala tor loh uwal. ");
INSERT INTO uli_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Iwe ngo ikala tot le ye pungdiy lobokla ye momay bol iyang, ila ye tumul. Yela palengdah ngo ye cholop uwal. Tot fedah ka ila kasilig uwal, ngo tot ila kaweleg, ngo tot ila kasubguy.” ");
INSERT INTO uli_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iwe Jesus sa hasiyaloh yal hapatpat le ye sor bo, “Ha talenga hare yor talengmi!” ");
INSERT INTO uli_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yodwe sa Jesus loh chog ngo tot rechokwe re rongrong foloy kowe yal mo mokwe re dabeyel Jesus we seg mo rumal resa budoh irel resa kangalu bo be hamdefa ngalir fal fiyong kowe. ");
INSERT INTO uli_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus yesa kangalur bo, “Hami ila Deus yesa kangalugmi mekla ye lebag mo irel mala Lamliyal. Ngo ikla sibis ila resa rol rongrong pangal hamedaf ka mo irel fiyong, ");
INSERT INTO uli_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","bo fael mala ‘Re kalloh, kalloh, ngo tor mele re wiri; ngo re talenga, talenga, ngo rete medaf, bo hare re medaf ngo rebe tagul ngal Deus bo Deus yebe hachuya fael yar molfid.’” ");
INSERT INTO uli_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iwe Jesus sa kasiyar bo, “Ha temedaf irel fael fiyong le? Ila ngo be ifa sengal chog ngo hasa medaf irel fiyong kala tot? ");
INSERT INTO uli_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chol milay we ila chol fadol mala yalol Deus. ");
INSERT INTO uli_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yor tot yarmat le re tapel faesol ire kowe ye pungdiy wol ngachel yalap. Yodla chog re rongrong mala yalol Deus ngo Satan sa budoh hasiloh. ");
INSERT INTO uli_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ngo rechokla tot re tapel faesol ire kowe ye pungdiy loboka ye cholop feas iyang. Yodla chog re rongrong mele yalol Deus ngo ye sa raey deper iyang resa talenga. ");
INSERT INTO uli_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngo hala chog ila yete mmoch long lal deper, sala tessulay ngalir. Ngo hare bela budoh hafohoy hare weres le fal mala yalol Deus ngo yema ttir yal tefael deper. ");
INSERT INTO uli_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tot yarmat ila re tapel faesol ire kowe ye pungdiy luwul waluwol ka yor chil. Ika rechokla re rongrong mala yalol Deus ");
INSERT INTO uli_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ngo yar merahrah bo rede tafel wol yar mel, mo yar chehaw, mo pangal mekla ye kkel deper bo be yoh ngalir, sala kkel long lal yar luluwal sala totawoloh mala yalol Deus sala tor uwal mala yalol Deus mo irer. ");
INSERT INTO uli_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngo tot yarmat ila re tapel faesol ire kowe ye pungdiy loboka ye momay bol iyang. Re rongrong mala yalol Deus ngo re talenga sala yor uwal mala yalol Deus le, tot ikala kasilig, tot ikala kaweleg, ngo tot ikala kasubuguy.” ");
INSERT INTO uli_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus sa taboloh yal hapatpat ngo sa sor bo, “Yor le ma hagsu sew habul sa yitlilong fael sew tapiy, hare fael sew bet? Ye towe far yetedah wol mala liliyel habul? ");
INSERT INTO uli_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pangal meka ye mwol ngo yebe lahloh lal werloh, ngo pangal meka ye totoloh irel formel ngo be hachuchuyloh totoal. ");
INSERT INTO uli_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ha hasu talengmi, hare yor talengmi!” ");
INSERT INTO uli_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ngo ye wol kangalur bo, “Ha hasu talengmi irel mekla hama rongrong. Sangsengal yami hatugulu kofal semal ila be ila sengal le Deus be foru ngalugmi, ngo halachog ila ye bele far kkel tot. ");
INSERT INTO uli_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Semal le yor formel irel ila ye cholop mele rebe ngaley, ngo semal le tor formel irel ngo lepal sugfed le ye mel irel ngo rebe hasi tangi.” ");
INSERT INTO uli_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus sa sor bo, “Mala Lamliyel Deus ila ye wochog semal yarmat le yela hamormor faesol ire wol milay la yal. ");
INSERT INTO uli_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ye masor lobong yee la raeldah ngo sa yichdah tumulul fedah kowe. Ngo iy ye togla chog mele ye foru sala ila sengal. ");
INSERT INTO uli_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bol we mele ye tipngi fedah kowe bo be tumul sala yor uwal. Metamol ngo be sugdah molwe hahal mo sibol mo luwul bol, iwe ngo sa moch yor uwal. ");
INSERT INTO uli_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yodwe bela masow mokwe uwal iyang, ngo sa budoh yeramtawe bo bele supiy ngal kama we yal bo sa hola yodla be hasi uwal milay we iyang.” ");
INSERT INTO uli_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus ye sor bo, “Meda mele sibe sor irel igegel mala Lamliyel Deus? Ifa sew fiyong le sibe tapeli le be hamdefa? ");
INSERT INTO uli_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ye wochog bo iye sengal. Semal mal ye hasi sefaes faesol mustard le ila faesol ire la ye hartal wechich mo lal faileng le, sa hasi sala fedagu. ");
INSERT INTO uli_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yela wol miril ngo yela tumul sala mel le sehay ire le ye hartal paleng mo luwul pangal ire. Yela buyoy mekla ral le hasfaluy mekla lelepal. Mael yeyal ka rema budoh ffaor hafter wol mekla ral.” ");
INSERT INTO uli_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus ye foloyu mokwe yalol ngalir yarmat le tapel fiyong ka mele ye teptap bo yebe hamedaf iyang. ");
INSERT INTO uli_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ye tema foloyur le be te teptap tot fiyongol hawewe ka ngo ligdi bo yodwe bela ir loh chog mo mokwe re dabeyal ngo bele moch la hamdefa pangal mekla pachigchigil ngalir. ");
INSERT INTO uli_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Leplaliyolol ralawe chog ngo sa kangalur mokwe re dabeyal bo, “Siya loh mo rel laom le rela sere.” ");
INSERT INTO uli_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iwe resa ligdi chol teydoh we. Resa chudah mokwe re dabeyal yuchul boat we sa faesul mel Jesus iyang resa hasi resa roloh. Wol yor fedal boat le chiler. ");
INSERT INTO uli_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tessulay yar teteragloh ngo sa kkeldoh yaeng ngo yesa loalo le yesa lululdah law yuchul boat we le sa fesugfed chog ngo resa mwos. ");
INSERT INTO uli_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ye mel Jesus woal molwe miril boat we le ye masor le ye yuldah wol sew yulolong. Mokwe re dabeyal resa fangludah ngo resa kangalu bo, “Sensey, hote luluwaley le si bele mes?” ");
INSERT INTO uli_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus sa sudah sa kangal yangwe bo, “Ppoloh!” ngo ye kangalu law bo, “Peslag!” Sala malululoh yaeng we ngo ye peslagloh taed we. ");
INSERT INTO uli_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iwe ngo Jesus sa kangalur mokwe re dabeyal bo, “Meda mele ha motog iyang? Tedyor chog yami tugul?” ");
INSERT INTO uli_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iwe ngo sa kkel yar rol motog ngo sa chaep yar kasiy fengal uwor bo, “Itey yeramtale le yaeng mo law mwo, ngo rema talenga yalol!” ");
INSERT INTO uli_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus mo mokwe re dabeyal re budoh rel Laom we Galilee mo rewe sere irel molwe haplomol Gerasa. ");
INSERT INTO uli_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Irel yodwe yela diloh Jesus mo yuchul boat we ngo sala chungu semal mal le ye buyoy mo irel pey kala lal hohyal. Mal le ila yor moniyan uwol. ");
INSERT INTO uli_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yema mel fedal chog luwul pey kowe. Tayor semal le ye chil yoh le yebe chena. ");
INSERT INTO uli_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ye cholop ral kala rema chena paol mo pechel ngo yema musdui chen ngo ye hatawsiy parang kala ma mel irel mekla pechel. Hasfaluy lepal mala kkelal le tayor semal le ye chil yoh le be hamachu. ");
INSERT INTO uli_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lebong mo leral yal memel fedal chog luwul pey mo luwul tayit le ma tetawul fedal chog ngo ma iy chog yal tefa fedaley halongol irel feas ka ye kkang. ");
INSERT INTO uli_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Chil ddaw chog ngo sa wiri Jesus iwe sa hamed ngali sala pung hasubugudiy mo imol. ");
INSERT INTO uli_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ngo yesa tawulagliloh le ye sor bo, “Jesus le Lol Deus le ye Hartael Tagiyet! Meda mele ho dipli hobe faor ngaliyey? Fael idel Deus, ngo fael pechem ngo ho towe hafohoyuyey!” ");
INSERT INTO uli_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Ye sor mele le fael molwe Jesus ye sor bo, “Chuy ho moniyan mo uwol mal le!”) ");
INSERT INTO uli_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iwe ngo Jesus sa kasiya, “Ifa idem?” Ngo mal we sa sor bo, “Mele idey ila ‘Buwa’ bo hamem ila ha feraketaw!” ");
INSERT INTO uli_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ngo sa tefael mo tefael ngali yal kekefael pechey Jesus bo ye towe hachuya moniyan kowe mo wol haplom le. ");
INSERT INTO uli_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ye cholop, cholop pabiy le re harpar le re momongoy wol sew tagitat. ");
INSERT INTO uli_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Moniyan kowe resa kekefael pechey Jesus le re sor bo, “Fang loh hamem ha bela mel wol pabiy kalay.” ");
INSERT INTO uli_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesa fangloh ir ngo moniyan kowe resa chuy mo uwol mal we, re sala bulong lefdogol pabiy kowe. Pangerloh pabiy kowe, le malbo be ruwow sengras ngo resa hamdadiy mo wol tagitat we re sala mmus long lal laom we re sala rol malomloh. ");
INSERT INTO uli_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mal kowe rema kekamaler pabiy kowe resa ddar re sala sor fedal luwul haplom we mo luwulur chol milay kowe mokwe resa wiri. Resa magloh yarmat re bela wiri molwe sa wel. ");
INSERT INTO uli_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Rela budoh irel Jesus re sala wiri mal we ye ssoeg moniyan uwol le ye maroro le sa yor mengagul ngo sa repiy. Panger rechokwe ngo resa rol motog. ");
INSERT INTO uli_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Rechokwe re wiri pangal mokwe ye weldoh lobowe re sala kangalur yarmat mokwe ye wel ngal mal we yor moniyan uwol mo kofal pabiy kowe. ");
INSERT INTO uli_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iwe resa kangal Jesus bo be chuy mo wol molwe faluyer. ");
INSERT INTO uli_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yodwe Jesus sa chudah yuchul boat we ngo mal we ye moch chuy moniyan mo uwol yesa hafael pechey ngo sa kangalu bo, “Ibe daboh!” ");
INSERT INTO uli_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngo Jesus ye temechal. Ngo ligdi bo ye kangalu bo, “Ho loh lubugtam ho bela kangalur lepal mele Samol sa faor ngalug mo lepal momayel yal hagiyeg ngalug.” ");
INSERT INTO uli_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mal we sa chuy sa loh woal pangal haplom we Decapolis le ye kekangalur yarmat lepal molwe Jesus sa faor ngali. Panger rechoka re rongrong meka ngo re lluwdah iyang. ");
INSERT INTO uli_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa tefael Jesus ngal rel laom we sere. Ye cholop yarmat le resa ttey doh irel. ");
INSERT INTO uli_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairus we semal cho tagiyet mo irel imwel ttey we ye budoh lobowe. Molwe yela wiri chog Jesus ngo sa ppungdiy mo lengchel mokwe pechel ");
INSERT INTO uli_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ngo sa hafael pechey le ye sor bo, “Tarfefel la layi ila sa kkel yal tomay. Fael pechem ngo hobe budoh bo hobe yetedah poam uwol bo be chuy yal tomay bo de mes!” ");
INSERT INTO uli_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iwe ngo Jesus sa dabey. Ye feraketaw yarmat le re dabeloh le resa hapilsedaw ngali. ");
INSERT INTO uli_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ye mel semal fefel le sa hafohoy bo sa seg mo ruwow ragel yal machpol. ");
INSERT INTO uli_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sa puw togta irel ngo yete chuy yal tomay. Sa retloh lol salpiy irel paliyel yal tafey bo be chuy yal tomay ngo ye far kekeloh chog. ");
INSERT INTO uli_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yodwe yela rongrong kofal Jesus ngo yesa bulong luwul buwa we ye sala budoh mo lutugurul. ");
INSERT INTO uli_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ye luwaley long chog lal depal le ye sor bo, “Ibe yangsi chog mala mengagol ngo be chuy yai tomay.” ");
INSERT INTO uli_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ye yangsi chog molwe mengagol ngo ye chuy loh tomay we yal. Iy chog ngo sa meyafilong lal depal le sa chuy sew loh tomay we yal. ");
INSERT INTO uli_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yodwe chog ngo Jesus sa meyafiy molwe kamalal le ye buyoy mo uwol. Sa tagul tefael luwul buwa we ngo sa kasiy le ye sor bo, “Itey mele sa yangsi mele mengaguy?” ");
INSERT INTO uli_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mokwe re dabeyal resa sor bo, “Ho wiri lepal yarmat le re hadibal ngalug, meda mele hola kasiy le ye yangsug iyang?” ");
INSERT INTO uli_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iwe ngo Jesus ye chil kekal fedal bo be gola le iy molwe. ");
INSERT INTO uli_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Fefel we ye sala chichiloh molwe sa wel ngali ngo sala budoh le sa rerer irel yal rusmes. Sala hasubugudiy mo imol mokwe pechel Jesus ngo sa kangalu molwe tosal. ");
INSERT INTO uli_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus yesa kangalu bo, “Layi, tugul la yam mele sa hachuya yam tomay. Ho loh luwul hopos bo tomay la yam ila sa chuy.” ");
INSERT INTO uli_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yodwe Jesus ye sor molwe ngo sa budoh tot yarmat mo irel imw we imwel Jairus resa kangal Jairus bo, “Molwe lom ila sa mes. Ngo tayor pelal le hobe hamachlokku fedaley Sensey la.” ");
INSERT INTO uli_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus te itol talengal irel mokwe re sosor ngo hala chog ila ye kangalu Jairus bo, “Ho towe rusmes, bo hobe far chepar.” ");
INSERT INTO uli_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ngo Jesus sa sor bo tor le be dabey bo hala chog Pedrus mo James mo John we bisil mele rebe dabey. ");
INSERT INTO uli_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Rela hola doh molwe imwel Jairus ngo Jesus sa wirir yarmat le resa somawel fedal mo yar rol tetang ngo re nganga fengal. ");
INSERT INTO uli_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yela bulong ngo sa kangalur bo, “Meda mele hasa rol somawel fedal iyang? Ngo meda mele ha rol tetang iyang? Yalwich le ila te mes bo yal masor chog.” ");
INSERT INTO uli_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yesa chaep yar tapeli Jesus kamemal ngo iy yesa ddaberwey ligtam. Yesa hasi molwe temal mo sil yalwich we mo chowe solmol we re dabeyal resa bulong lal sengil we ye yol yalwich we iyang. ");
INSERT INTO uli_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sa holudah molwe paol ngo sa kangalu bo, “Talitha koum” fael imele ila ye sor bo, “Tarfefel la chemdah!” ");
INSERT INTO uli_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yodwe chog ngo sa chemdah ngo sa chaep yal dar fedal. (Sa seg mo ruwow lepal ragel tarfefel le.) Panger rechokwe ngo resa lluwdah. ");
INSERT INTO uli_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus yesa hatobtob ngalir le tor semal le rebe kangalu molwe ngo sa sor bo, “Ha fang hal tarfefel le bo be mongoy.” ");
INSERT INTO uli_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus ye chuy mo loboswe yesa tefael ngal molwe faluyal le mokwe re dabeyal re dabey. ");
INSERT INTO uli_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iwe la Sabbath ngo sa chapiy yal foloy mo lal imwel tey we. Ye cholop yarmat le re mel lobowe. Panger rechokwe re rongrong foloy kowe yal ngo re lluwdah iyang. Resa rol kasiy fengal uwor le re sor bo, “Iya lobosle yela hasi meka repiyal mo iyang? Ngo if sengal yal ma foru kkemal ka? ");
INSERT INTO uli_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Te sellap we lol Maria mele? Te iy molwe bisil James mo Joseph mo Judas mo Simon? Te woal haplom le mele ma mel mokwe wol mwengal iyang?” Iwe re sala te kekadagiloh mekla yema sor. ");
INSERT INTO uli_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus sa kangalur bo, “Pangal lobos ngo rema hasaror profeta mo iyang, hala chog wol faluyal mo irel yerametal mo yal haleng mele te ila sengal mo iyang.” ");
INSERT INTO uli_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tay yoh le be faor kemal kowe yal iwe sala fedmal chog chotomay mele ye yetedah paol uwor iwe ngo ye chuy yar tomay. ");
INSERT INTO uli_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesus ye luwdah irer rechokwe bo tor yar tugul. Iwe ngo Jesus sa loh irel hasohsoh kowe ye harpa lobowe bo bela foloy mo iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesa hateyelirdoh mokwe re dabeyal we seg mo rumal. Yesa hagloyur rebe loh le rebe rumal mo rumal. Sa fang kkamaler bo be yoh le rebe hachuchuy moniyan mo uwor yarmat. ");
INSERT INTO uli_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iwe ngo sa kangalur bo, “Ha bele la malekah ngo tor mele habe hasi bo hala chog mekla shomi mele habe hasi. Tor flowa le habe hasi ngo ha towe kaek liliyel litami. Tor salpiy le be mel lal hagchel mekla mengagmi. ");
INSERT INTO uli_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Habe yaya bwela ngo mengagmi chog ikala ye mel uwomi.” ");
INSERT INTO uli_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ngo ye wol kangalur bo, “Te tugul solbos le hala hola ngo hare re ffesangugmi habe mel iyang ngo hasa mel. Ngo sew chog imw le habe mel iyang yee la hola yodla habe chutang loboswe. ");
INSERT INTO uli_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hare hala budoh irel sew haplom ngo ire re temchal ffesangugmi hare rete talenga yalomi ila ngo hasa ligdi ngo hasa hachuya loh bol haplom la mo irel pechemi. Bo yebe mel le sew hagil ngalir.” ");
INSERT INTO uli_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iwe resa loh re sala foloyu ngalir yarmat bo rebe tagul tang molfidir. ");
INSERT INTO uli_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ye cholop moniyan le re hachuya mo uwor yarmat. Ngo ye cholop chotomay kala re chalif ngalir hapgep sa chuya yar tomay. ");
INSERT INTO uli_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Yerodes sa rongrong mokwe kofal Jesus we sa medarloh pangal lobos. Tot yarmat re sor bo, “Iy Johannes Baptista le sa molow tefael! Ila fal le sa yor kelal le be ffaor kkemal.” ");
INSERT INTO uli_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngo tot re sor bo, “Iy Elijah” ngo ikala tot re sor bo, “Iy semal profeta le ye hafedeg ngali chog semal profeta kowe muswe.” ");
INSERT INTO uli_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yodwe Yerodes yela rongrong molwe ngo sa sor bo, “Yeramtala ila Johannes Baptista we ngang mele isor bo rebe supiloh molwe uyal le sa molow tefael!” ");
INSERT INTO uli_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Iy Yerodes molwe ye sor bo re bela dorfi Johannes bo rebe fargu resa yetolong lal kalbus. Ye foru meka bo fal Herodias we sa rili we faesul ril Philip we bisil. ");
INSERT INTO uli_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Johannes Baptista sa kangalu loh chog Yerodes bo, “Ye tafel le hobe rili mala ril bisim!” ");
INSERT INTO uli_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias sa hamachu long chog yal ssong lal depal irel Johannes. Iwe sa luluwaley bo yebe limeseloh Johannes ngo ye teyoh bo yagel Yerodes. ");
INSERT INTO uli_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yerodes ila ye motog Johannes bo ye gola le Johannes ila ye fel ngo ye santus. Iwe ila mele Johannes yela daor iyang. Yerodes ye dipli bo be ma rongrong foloy kala yael Johannes. Pangal yodkala be rongrong foloy kala yal ngo tema pos yal luluwal iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","La wol miril ngo Herodias sa gola mele be foru. Yodwe bungul yal subdoh Yerodes ngo iy Yerodes sa foru sew gubul bo yar panger rechokla re tagiyet mo irel aam mo mekla tamol saldaw mo to rechokla re tagiyet mo wol mekla faluyel Galilee. ");
INSERT INTO uli_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Iwe sa budoh lefechig we lol Herodias sa barog. Yesa cchehas Yerodes mo panger rechokwe ye ffesangurdoh. Iwe Yerodes sa kasiya lefechig we bo, “Meda mele ho dipli bo be yoh ngalug? Te tugul mele ho dipli ngo be yoh le iy be fang ngalug.” ");
INSERT INTO uli_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yesa hatugulu ngali le ye sor bo, “Te tugul mele hobe kasiyayey ngo ibe fang ngalug. Be yoh le ibe fang ngalug setab mo irel panal meka lamliyey!” ");
INSERT INTO uli_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iwe ngo lefechig we sa loh sala kasiya molwe sil bo, “Meda mele ibe sor?” Iwe ngo molwe sil sa kangalu bo, “Molwe chemwel Johannes Baptista.” ");
INSERT INTO uli_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yodwe chog ngo sa tefael loh lefechig we irel Yerodes sala kangalu le ye sor bo, “Idipli le hobe fang ngaliyey chog igala molwe chemwel Johannes Baptista le be mel lal sew pleet!” ");
INSERT INTO uli_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sa kel tayikofel depel King we ngo towol yoh le be te talenga yalol lefechig we bo sa mol yal fang yalol mo imor panger chol tteydoh we. ");
INSERT INTO uli_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Iwe sa fang loh semal pos kowe sa kangalu bela hasidoh molwe chemwel Johannes. Sa loh pos we irel kalbus we sala supiloh molwe uyel Johannes. ");
INSERT INTO uli_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sa yetolong lal sew pleet sa hasidoh sa ngaley lefechig we. Ngo lefechig we sa hasiloh sala ngaley molwe sil. ");
INSERT INTO uli_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yodwe mokwe re dabeyel Johannes rela rongrong kofal molwe, ngo resa budoh hasi molwe porgol re sala leba. ");
INSERT INTO uli_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostel kowe resa tefaeldoh irel Jesus resa kangalu mokwe resa foru mo ikwe resa haskuna. ");
INSERT INTO uli_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tay yoh le Jesus mo mokwe re dabeyal rebe ffag haler bo ye cholop yarmat le re bubudoh irer mo ikala re loloh. Iwe Jesus sa kangalur bo, “Hami siya roloh mo solbos le tor yarmat iyang bo ha bela hasoso mwo sugfed.” ");
INSERT INTO uli_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iwe resa dage seyai boat resa loh solbos le tor loh yarmat iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ir re gil ngalir rechokwe re cholop we re wirir yar loh. Re budoh yarmat mo wol sew mo sew haplom resa dar wol fuluy re sala homol hola loboswe mo imol Jesus mo mokwe re dabeyal. ");
INSERT INTO uli_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yodwe yela diloh Jesus mo yuchul boat we sala wiri lepal buwa we iwe lepal ngo kkel yal fahor bo resa wochog saaf kowe tor le ye kekefalir. Iwe sa chapiy yal foloyur le ye cholop mekla ye kangalur. ");
INSERT INTO uli_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yodwe sa pal loh yaal ngo mokwe re dabeyal resa budoh resa kangalu bo, “Igla ila sa pal loh yaal ngo lobosle ila tor le ma mel iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hafengar loh yarmat rebe loh irel milay kala mo hasohsoh kala ye harepdoh bo re bela chuway haler iyang.” ");
INSERT INTO uli_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus sa kangalur bo, “Ha fang haler hami!” Ngo resa kangalu bo, “Ho luluwaley le ha bela tapeliloh rubguy faesol salpiy kowe silver bo paliyel flowa bo habe hamongoyu ngalir?” ");
INSERT INTO uli_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iwe Jesus sa kasiyar bo, “Ifa lepal flowa le ye mel iremi? Ha loh ha bela kamahoy.” Yodwe rela gola ngo resa kangalu bo, “Limay flowa mo rumal yig.” ");
INSERT INTO uli_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesus sa kangalu mokwe re dabeyal bo rebe hamhalar buwa we le rebe sew mo sew tteyal. Ngo resa kangalur bo rebe marrodiy wol fadil kowe. ");
INSERT INTO uli_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Iwe resa rol marodiy le re sew mo sew tteyal. Yor tot tteyal le kasubguy ngo yor tot le kallemeg yarmat iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iwe ngo Jesus sa hasi flowa we limay mo yig we rumal sa kaledah wol laeng ngo sa kangal Deus yal hachigchig. Ngo sa dipi flowa kowe ngo sa kangalur mokwe re dabeyal bo rebe yildi uwor yarmat. Ngo re wol yildi yig we rumal uwor panger yarmat. ");
INSERT INTO uli_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Panger ngo re mongoy ngo re maedloh iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Iwe ngo mokwe re dabeyal resa hateyili fengali lutgul flowa mo yig kowe sala ssog seg mo ruwow bechebach iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Leper mal le re mongoy lobowe ila limngeras. ");
INSERT INTO uli_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Irel yodwe chog ngo Jesus sa kangalu mokwe re dabeyal bo rebe dage boat we ngo resa hamwoloh mo imol wol Bethsaida le ye mel rel laom we rela sere ngo iy ye bele halahor buwa we. ");
INSERT INTO uli_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wol miril yal habungur ngo sa bidah wol sew tagitat bela mapel iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yela lefhafdoh ngo boat we sa mel lochochol laom we, iwe ngo Jesus sa iy loh chog lobowe. ");
INSERT INTO uli_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesa wiri mokwe re dabeyal le resa tapey keler irel yar fadol bo re fefadol ngal chapil yaeng. Iwe yela lemaral ngo sa budoh Jesus irer le ye dedarloh wol taed, le sa fesugfed chog ngo ye bele ttepal tangir. ");
INSERT INTO uli_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Iwe ngo ir resa wiri le ye dedarloh wol taed we. Iwe ngo resa kacchog bo iy semal yalus, iwe resa rol tawul ngo re sor bo, “Yalus!” ");
INSERT INTO uli_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Panger ngo resa rol motog irel yodwe rela wiri iyang. Yodla chog ngo Jesus sa malili ngalir le ye sor bo, “Hakela lal dipmi bele ngang mele, ha towe motog!” ");
INSERT INTO uli_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iwe ngo sa bidah irer yuchul boat we ngo ye malululoh yaengwe. Panger mokwe re dabeyal ngo resa lluwdah irel molwe resa wiri. ");
INSERT INTO uli_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ir resa somawel fedal irel hamongol buwa we limngeras le tediyor mele ye medaf lal deper iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iwe resa supiloh laom we re sala hola Gennesaret resa lemtagluloh boat we mo iyang. ");
INSERT INTO uli_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yodwe chog re chutang boat we ngo sa gil Jesus ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Iwe chog ngo yarmat resa rol hamed fedaley wol fuluwe we le tetugul lobole re rongrong le sa mel iyang ngo resa kaekdoh chotomay le re mel lal giyer. ");
INSERT INTO uli_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pangal lobos le be loh iyang le te tugul hare luwul haplom hare luwul imw, hare wol milay, hare lobowe liliyel market le ma toa tteydoh yarmat iyang, ngo rema budoh irel rebe hafael pechey bo hare hare mele chog chotomay rebe yangsi ngachel mala mengagul. Panger rechokwe re yangsi molwe mengagul ngo ye chuyloh yar tomay. ");
INSERT INTO uli_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tot Pharisees mo tot mokwe sensel Hatobtob we le re budoh mo wol Jerusalem resa rol langbaloh Jesus. ");
INSERT INTO uli_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Resa wiri tot mokwe re dabeyel Jesus le rete tala payur ngo resa mongoy. Rete dabey mokwe Pharisees kowe re kangalur yarmat bo rebe ma foru. ");
INSERT INTO uli_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Bo ir Pharisees mo pangerloh Jews ngo re dabey felel mekla re guladoh mo irer mokwe chaepdohor le retema mongoy le re bete tela payur. ");
INSERT INTO uli_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ngo towe yoh le rebe hangi sew mongoy ka ye budoh mo market le rebe te chiri. Ye cholop mekla kkor re muswe le re chil dedabey le tapel chog igegel yar ma tela yar tohoh, mo raw, mo tapiy, mo yar ma wubub chob.) ");
INSERT INTO uli_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iwe ngo ir Pharisees mo mokwe sensel Hatobtob we resa kasiya Jesus bo, “Meda fal le mekla re dabeyem rete dabey mekla kkol chaepdoh kowe yach muswe le si chil ma foforu ngo ir resa mongoy le rete tela payur?” ");
INSERT INTO uli_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iwe ngo Jesus sa kangalur bo, “Surel profeta Isaiah mokwe ye sor iremi! Hami sibis choto kachapar le igegel chog mokwe ye tefa we ye sor bo: ‘Deus ye sor bo yarmat rema hasrowuyey mo irel yar hapatpat, ngo tor luwalel mo lal deper. ");
INSERT INTO uli_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ila tor fal ngalir le rebe hasrowuyey, bo foloy kala yar ila foriyel yarmat, ngo resa itol bo holongol hatobtob kala yael Deus!’ ");
INSERT INTO uli_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Hasa tahcheloh hatobtob kala yael Deus ngo hasa talenga chog ikala foriyel yarmat.” ");
INSERT INTO uli_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iwe ngo Jesus sa taboloh ngo sa sor bo, “Hami hasa gola mele habe foru bo habe tahcheloh hatobtob kala yael Deus bo habe dabey ikala yami lufulumi. ");
INSERT INTO uli_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses ye sor bo, ‘Hobe hasrowu tamom mo solom, ngo semal le be hapatpat tayikof ngal temal hare sil, ila ngo ye momay le yebe mes.’ ");
INSERT INTO uli_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Hami hasa foloyu ngalir yarmat le hare semal le hare yor formel irel le be teptap be hamwal ngal molwe temal hare sil, ngo be yoh le be sor bo, ‘Yai maligach mele!’ ");
INSERT INTO uli_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Bo yagel mala de hamwal ngal molwe temal mo sil. ");
INSERT INTO uli_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Iye sengal foloy kala yami ngalir yarmat le ye kekamolaho pedal mekla yalol Deus. Chil cholop ikala ye wochog mele le hami ha foforu.” ");
INSERT INTO uli_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iwe ngo Jesus sa wol ffesang tefaelir buwa we fal sew ngo sa kangalur bo, “Ha talenga hamayu meka ibele sor bo habe medaf. ");
INSERT INTO uli_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tor sew formel le be bulong lofodgol semal le be hatayikofa yeramtawe bo, ");
INSERT INTO uli_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","far ika yema buyoy mo lofodgol mele yema hatayikofa.” ");
INSERT INTO uli_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yodwe Jesus ye ligdi buwa we ngo sa bulong yilim ngo mokwe re dabeyal resa kasiya fael hamedaf we. ");
INSERT INTO uli_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iwe ngo Jesus sa kasiyar bo, “Hami mwo ngo ha ted wol medaf? Tor mele be bulong lofodgol semal yarmat le be hatayikofa, ");
INSERT INTO uli_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","bo fal mala te bulong lal mala depal bo ye bulong chog lal mala siyal ngo sa moch la pedaloh.” (Jesus sa kapta molwe le ye sa sor bo pangal mongoy ngo sa fel le sibe mongoy.) ");
INSERT INTO uli_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ngo sa wol taboloh yal hapatpat le ye sor bo, “Meka yema buyoy mo lofodgol semal mele yema hatayikofa yeramtawe. ");
INSERT INTO uli_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bo mekla yema buyoy mo lal depel semal mo semal mele yema budoh luluwal tayikof mo iyang sala hasi ngal gich metmetal molfid ka: perafel peteg, chote habulupoy le resa faor maltemay, lilimesloh yarmat, ");
INSERT INTO uli_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ngo re faor maltemay ngal ril semal, mo chehaw, fforol pangal metmetal tayikof, kachapar, hatolop, loltemay, hatayikofel kaptal semal, hattodah mo wegdegel buch. ");
INSERT INTO uli_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pangal tayikof ka ngo yema buyoy mo lal yael semal luluwal sala hatayikofa.” ");
INSERT INTO uli_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesus sa chuy sa loh solbos le ye harpa haplom we idal Tyre. Ye sala bulong lal sew imw ngo yete dipli le yarmat rebe gola le iy ye mel loboswe, ngo ligdi bo yetyoh le be mwol. ");
INSERT INTO uli_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ye mel semal fefel le ye mel semal yalwich tarfefel lol le yor moniyan uwol le irel chog yodwe ye rongrong kofal Jesus ngo yesa bodoh irel sala pung hasubguydiy mo imol mokwe pechel. ");
INSERT INTO uli_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Fefel we ila semal re Gentiles le ye sub mo wol haplom we Phoenicia we ye mel wol Syria. Yesa hafaelpechey Jesus bo be hachuya moniyan mo uwol tarfefel we lol. ");
INSERT INTO uli_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iwe ngo Jesus sa kangalu bo, “Siya hamngoyur mwo yalwich ka. Bo ye tafel le sibe hasi mongoy ka haler yalwich siya pedaloh bo haler pes.” ");
INSERT INTO uli_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Fefel we sa sor bo, “Ila sengal Malap, ngo ligdi bo pees ka mwo ma mel fael tis ngo ma mongoy meka lutgul haler yaluwich!” ");
INSERT INTO uli_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iwe ngo Jesus sa kangalu bo, “Fael pedal hapatpat kala hosa sor lete felel mokwe ngang iy sor, mele ho bele tefael ngal bugtam iyang. Ho bele la wiri le moniyan we ila yesa chuy mo wol tarfefel we lom.” ");
INSERT INTO uli_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iwe fefel we sa tefael ngal molwe bugtal sala wiri yalwich we lol le ye yol lal molwe giyal le tosol le sa chuy moniyan we mo uwol. ");
INSERT INTO uli_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus sa chuy tangi haplom we Tyre sa loh Sidon, sa chuy sa loh irel Laom we Galilee le ye loh irel fuluyel haplom we Decapolis. ");
INSERT INTO uli_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tot yarmat re sala hasidoh semal mal irel le ye talengbat le ye tema mmwal le be haptpat. Iwe resa hafaelpechey bo be yetedah paol uwol. ");
INSERT INTO uli_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iwe ngo Jesus sa pali mal we tangi buwa we ngo sa yetolong haddol lal mokwe talengal ngo sa chaelyewa molwe haddol sa yangsi molwe yawal mal we. ");
INSERT INTO uli_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iwe ngo Jesus sa kaledah wol laeng ngo sa ngas loh, iwe ngo sa kangal mal we bo, “Ephphatha” fael mele ila sugegloh. ");
INSERT INTO uli_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Irel yodwe chog ngo mal we yesa rongrong formel ngo ye mmwal le yebe hapatpat bo sa chuyloh molwe ye hawersiy yewal bo deyoh be hapatpat. ");
INSERT INTO uli_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iwe ngo Jesus sa hatobtob ngalir buwa we le tor semal le rebe kangalu. Ngo lepal kkelel yal hatobtob ngalir bo re towe sor ngo ila lepal kkelel yar kekapta fedaley. ");
INSERT INTO uli_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Panger rechokwe re rongrong mokwe ngo re luwdah iyang. Iwe ngo resa sor bo, “Ye momay pangal meka yeramtale yema foru. Ila mwo chotalengbat ngo yema hachuya yar talengbat ngo rechoka tema mmwal rebe hapatpat ngo yema foru bo yebe mmwal le rebe hapatpat.” ");
INSERT INTO uli_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tesulay mo wol miril ngo sew buwal yarmat le ye palleng resa wol ttey fengal yee la tayorloh haler, ngo Jesus sa ffesangur mokwe re dabeyal ngo sa kangalur bo, ");
INSERT INTO uli_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Sa budoh yai fahor rechoka bo sa solral yar mel irey le tor mele re mongoy. ");
INSERT INTO uli_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Hare iy be fang loh ir lubugter le iye tor mele re mongoy ngo re bela remasol loh irel yar kkoloh bo ye ddaw lobos kala tot ir re budoh mo iyang.” ");
INSERT INTO uli_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mokwe re dabeyal resa kasiya bo, “Iya mele si bela kakdoh haler rechoka iye leper mo iyang le tor mongoy lobosle?” ");
INSERT INTO uli_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iwe Jesus sa kasiyar bo, “Ifa lepal flowa le ye mel iremi?” Iwe ngo resa sor bo, “Fisyoy.” ");
INSERT INTO uli_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iwe ngo yesa kangalur buwa we bo rebe marorodiy wototol. Iwe sa hasi flowa we fisyoy sa kangal Deus yal hachigchig, yesa dipiy flowa kowe, sa ngaler mokwe re dabeyal bo rebe hamhela uwol buwa we. Ngo ir resa foru molwe ye kangalur. ");
INSERT INTO uli_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iwe ngo ye wol mel fedmal yig pachigchig. Jesus sa kangal Deus yal hachigchig ngo sa wol kangalur mokwe re dabeyal bo rebe wol hamhela uwor buwa we. ");
INSERT INTO uli_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Panger rechokwe fangeras ngo re mongoy, mongoy yee rela maed. Iwe ngo mokwe re dabeyel Jesus resa hateyili mokwe ye mel diy ngo ye ssog fisuw bechebach mo iyang. ");
INSERT INTO uli_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iwe ngo Jesus ye halahor chog buwa we ngo iy mo mokwe re dabeyal resa dage seyay boat resa loh wol molwe faluyel Dalmanutha. ");
INSERT INTO uli_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tot Pharisees re budoh irel Jesus ngo sa chaep yar hapaliyel ngali. Re dipli bo rebe foru sew formel le rebe hagla ngal Jesus. Iwe resa kangalu be faor sew kkemal le be halehaloh hare iy ye fel mo irel Deus. ");
INSERT INTO uli_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iwe ngo Jesus sa halalai yal ngas dah ngo sa sor bo, “Meda mele yarmetal fael mwoka re dodongor kkemal iyang? Yeb, ibe kangalugmi le tor tugulul meka le be holar rechoka!” ");
INSERT INTO uli_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesa chuy tangir sa tefael dah yuchul boat we resa loh rel laom we rewe sere. ");
INSERT INTO uli_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mokwe re dabeyel Jesus re maligli rebe kak flowa le be cholop, iwe sala halseyay chog mele re hasi. ");
INSERT INTO uli_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iwe ngo Jesus sa hatobtob ngalir le ye sor bo, “Hasa kemahoy fengalugmi ngo ha hamrehahmi irel haboloh we yar Pharisees mo haboloh we yael Yerodes.” ");
INSERT INTO uli_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iwe resa kapta fengali chog uwor le re sor bo, “Ye sosor mele bo fael mala tor flowa le si hasi.” ");
INSERT INTO uli_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus sa gola mokwe re sosor iwe sa sor bo, “Meda mele ha kekapta yal tor flowa iyang? Ha ted rol gola ngo ha ted rol medaf chog? Ye chil pelat chog lal mekla chimi? ");
INSERT INTO uli_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yor metami ngo tor mele hama wiri? Yor talengmi ngo tor mele hama rongrong? Hate memangi ");
INSERT INTO uli_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yodwe idipiy flowa we limay ngo hasa yildi uwol lemngeras yarmat? Fodow bechebach le ye ssog irel flowa kowe ye luteg le ha hasi?” Iwe ngo resa sor bo, “Seg mo ruwow bechebach.” ");
INSERT INTO uli_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ngo Jesus yesa kasiy, “Iwe ngo yodwe idipiy flowa we fisyoy ngo hasa yildiy uwol fangeras yarmat? Ngo fodow bechebach le ye ssog irel flowa kowe lutgul le ha hasi?” Iwe ngo resa sor bo, “Fusuw.” ");
INSERT INTO uli_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ngo Jesus yesa kasiyar bo, “Ila mwo ngo hated rol medaf chog?” ");
INSERT INTO uli_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Rela budoh wol Bethsaida ngo tot yarmat resa hasidoh semal mal le ye metafis irel Jesus resa hafalpechey bo be yangsi. ");
INSERT INTO uli_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus sa holu paol mal we yesa palawey mo yulgul hasohsoh. Wol miril yael Jesus gutfi mokwe metal ngo sa yetedah paol uwol ngo sa kasiya bo, “Yor mele hosa wiri?” ");
INSERT INTO uli_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iwe mal we sa tardah ngo sa sor bo, “Isa wirir yarmat ngo ligdi bo re wochog bo ire le re dedar fedal.” ");
INSERT INTO uli_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus sa wol yetedah mokwe paol uwol mokwe metal mal we. Irel yod le ngo mal we yesa haffado yal kaloh ngo sa tefael llifadol mokwe metal le sa wiri pangal formel le ye ffod. ");
INSERT INTO uli_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus sa halho mal we lubugtal le sa kangalu bo, “Ho towe tefael loh irel hasohsoh la.” ");
INSERT INTO uli_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iwe ngo Jesus mo mokwe re dabeyal resa loh wol tot haplom lengchel Caesarea Philippi. Yar loloh ngo sa kasiyar bo, “Ha kangaluyey, yarmat rema sor bo Ngang itey?” ");
INSERT INTO uli_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iwe ngo resa sor bo, “Sibis re sor bo gel Johannes Baptista ngo sibis re sor bo gel Elijah, ngo wol sibis re sor bo gel semal profeta kowe.” ");
INSERT INTO uli_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesus yesa kasiyar, “Iwe ngo hami, ha sor bo Ngang itey?” Pedrus sa sor bo, “Gel Kristus.” ");
INSERT INTO uli_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iwe ngo Jesus sa hatobtob ngalir bo, “Tor le habe kangalu le Ngang iy.” ");
INSERT INTO uli_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iwe ngo Jesus sa chapiy yal foloyur mokwe re dabeyal le ye sor bo, “Mala Layur Retalop ila be kkel yal hafohoy ngo mal kowe yar mo tomol temarong kowe mo mokwe sensel Hatobtob we re bele fangloh iy. Rebe limeseloh ngo bela solral mo wol miril ngo sa molow tefael.” ");
INSERT INTO uli_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ye hamdefa hamayu ngalir mele bo rebe medaf iyang. Iwe Pedrus sa paliloh Jesus mo medaw sa chapiy yal kkaftoroy ngali. ");
INSERT INTO uli_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iwe ngo Jesus sa tagul tefael sa kal ngalir mokwe re dabeyal ngo sa kkaftoroy ngal Pedrus le ye sor bo, “Satan, hadawah tangyey. Luluwal kala yam ila tebudoh mo irel Deus bo ye budoh mo irel yarmat!” ");
INSERT INTO uli_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iwe ngo Jesus yesa ffesangur buwa we mo mokwe re dabeyal. Yesa kangalur bo, “Semal le ye dipli le be dabeyey ngo be tahcheloh luwalel lufulyal, sa hasi yal krud ngo sa dabeyey. ");
INSERT INTO uli_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Semal le be hafali yal molow ngo be pung tangi. Ngo semal le bete hafaliloh yal molow le fal ngang mo Ebangelium le ngo be molow. ");
INSERT INTO uli_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Meda mele mmwalel semal yarmat le bela yoh ngali pangal meka ye mel lal faileng le ngo ye teyoh ngali molow la tor siyal? Ye tugul le tor! ");
INSERT INTO uli_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bo tayor mele be chil foru le be yoh ngali molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hare fael mwole sa ssogol molfid ngo yarmat re tay kekadagiloh Deus iwe ngo semal sa maligilyey mo foloy ka yai, ila ngo mala Layur Retalop be wol mmaligi yeramtala irel yodla bela budoh luwul falmay la yael mala Temal le rebe chusew doh mo angelus kala re santus.” ");
INSERT INTO uli_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iwe ngo sa taboloh yal hapatpat ngo sa sor bo, Ihatugulu ngalugmi le yor tot mo luwulmi igla le re towe mes yee la hola yodla re bela wiri mala Lamliyel Deus le yebe lahdoh luwul kelel mala kamelal.” ");
INSERT INTO uli_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wolral mo wol miril ngo Jesus sa ffesangu Pedrus, mo James mo John sa palirdah wol sew tayit le ye tagiyet re sala rol ir loh chog mo iyang. Yodwe re kekal ngali Jesus ngo sa yusuweloh molwe woal. ");
INSERT INTO uli_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mokwe mengagol ila sa kkel yal bechrag le tor semal mo lal failengle, le be sopa le be hola mala bbechragel. ");
INSERT INTO uli_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iwe ngo rosolmol mokwe re dabeyel Jesus ngo resa wiri Elijah mo Moses le re rol kapatpat fengal mo Jesus. ");
INSERT INTO uli_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedrus sa kangal Jesus bo, “Sensey, sa momay mele sila budoh iga. Ha bele hasu suluw tento bo sew imwom, ngo sew imwel Moses ngo sew imwel Elijah.” ");
INSERT INTO uli_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedrus ye tay gola mele yebe sor bo iy mo mokwe chilal ngo sa kkel yar rol motog. ");
INSERT INTO uli_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sa budoh sedep darmi sala halururloh, iwe ngo sa malilidiy Deus mo luwul darmiy we le ye sor bo, “Iye mele Layi le ihartal hachangi. Ha talenga yalol!” ");
INSERT INTO uli_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Rela kekal fedal ngo tayor semal le re wiri bo sa hala chog Jesus mele ye mel irer. ");
INSERT INTO uli_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Rela bibidiy mo wol tayit we ngo Jesus sa kangalur bo, “Tor semal le habe kangalu molwe hasa wiri yee la hola yodla yebe molow tefael mala Layur Retalop mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iwe re talenga mokwe Jesus ye kangalur, resa kasiy fengal chog uwor hare meda fal iy molwe ye sor bo, “Molow tefael mo irel maes?” ");
INSERT INTO uli_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Iwe resa kasiya Jesus, “Meda fael le mokwe sensel Hatobtob we rela sor bo Elijah mele be hamodoh iyang?” ");
INSERT INTO uli_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus sa sor bo, “Elijah ila be hamodoh bo be hafle pangal formel. Iwe ngo meda fal le Babior we ye Santus ye sor bo mala Layur Retalop ila yebe kkel yal hafohoy ngo yarmat rebe mmwodaloh iyang? ");
INSERT INTO uli_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ibe kangalugmi le Elijah ila sa faesul mel ngo yarmat re faor ngali mele ir re dipli, le tappel chog molwe Babior we ye Santus ye sor irel.” ");
INSERT INTO uli_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yodwe rela budoh irer mokwe chiler ngo ye mel sew buwal yarmat le resa langbarloh, iwe makawe sensel Hatobtob we resa kekapaliyel ngalir. ");
INSERT INTO uli_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yodwe buwa we rela wiri Jesus ngo re lluwdah. Iwe resa hamed ngali resa habungu. ");
INSERT INTO uli_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus sa kasiyar mokwe re dabeyal, “Meda mokwe ha rol kekapaliyel fengal mo rechoklay iyang?” ");
INSERT INTO uli_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Semal mal mo luwul buwa we sa sor bo, “Sensey, isa hasidoh yalwich tarmal le layi irem bo sa mel semal moniyan uwol ngo tay mmwal bo be maliliy. ");
INSERT INTO uli_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pangal yodka ma kkel doh moniyan uwol ngo moniyan we yema pedadiy wototol. Iwe ngo sa buyoy burbur mo lal yewal ngo ma kketangtingi mekla ngil ngo ye remmasowloh mala holngol. Sa mol yai kangalur mokwe re dabeyem bo rebe hachuya moniyan mo uwol ngo ye temmwal ngalir.” ");
INSERT INTO uli_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus sa kangalur bo, “Ifa lepal yami ted rol chepar hami rechoka! Be ifa lepal ssulayel yai mel ngalugmi? Ngo be chil ifa lepal yai halelayi repiyey iremi? Ha hasidoh yalwich la irey.” ");
INSERT INTO uli_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iwe resa hasidoh irel Jesus. Yodwe chog moniyan we ye wiri Jesus ngo sa yal sew kkel loh molwe uwol yalwich tarmal we. Yesa pedadiy wototol sa tapolpol fedal ngo ye buyoy burbur mo lal yewal. ");
INSERT INTO uli_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus sa kasiya molwe temal yalwich tarmal we bo, “Sa ifa lepal ssulayel mele uwol?” Mal we sa sor bo, “Lebel chog yal yalwich ngo sa pachngali. ");
INSERT INTO uli_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sa cholop yod kala moniyan le ma foforu le be limeseloh irel yal ma hadrodah wulyef ngo ye hadrolong locchol. Hare be mmwal ngalug ngo hosa fahohmem bo hobe tipingumem!” ");
INSERT INTO uli_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus sa kangal bo, “Ngoa, be mmwal ngalye igle gel be mmwal ngalug. Pangal formel ngo be mmwal ngalir rechoka yor yar tugul.” ");
INSERT INTO uli_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yodwe chog ngo mal we sa tawul le sor bo, “Yor yai tugul ngo hala chog ila ye telap. Tipingyey bo be kkel tot yai tugul.” ");
INSERT INTO uli_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus sa wiri buwa we le resa mmitre ngalir ngo sa kangalu moniyan we bo, “Gel yalus la homa foru bo yarmat rebe talengbat ngo re togla hapatpat. Isa kangalug bo hobe chuy mo uwol yalwich la ngo tayor fael sew le hobe chil tefael doh uwol!” ");
INSERT INTO uli_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iwe ngo sa nngaloh moniyan we ngo sa kkel loh molwe ye mel uwol yalwich tarmal we. Iwe ngo sa moch chuyloh mo uwol. Sa mmaluloh yalwich we le sa wochog semal chomes. Pangal yarmat ngo resa sor bo, “Yesa mes!” ");
INSERT INTO uli_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Iwe ngo Jesus sa holu molwe paol yalwich we sa tipingi yalwich we bo be sudah. ");
INSERT INTO uli_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wol miril yael Jesus mo mokwe re dabeyal bulong yilim le sa rol ir loh chog ngo resa kasiya bo, “Meda mele yela teyoh le habe hachuya moniyan we iyang?” ");
INSERT INTO uli_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iwe Jesus sa sor bo, “Tayor mele be chil chuy we iyang, bo sa halachog mepel mele be chuy iyang.” ");
INSERT INTO uli_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesus mo mokwe re dabeyal resa chuy tangi loboswe resa loh luwul Galilee. Yete depel Jesus le yarmat rebe gola lobosle ye mel iyang ");
INSERT INTO uli_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bo mil mala ye chil kekaskuna ngalir mokwe re dabeyal mele: “Mala Layur Retalop ila bele yoh long lal payur rechokala rebe limeseloh. Ngo halachog ila bela solral mo wol miril ngo be molow tefael.” ");
INSERT INTO uli_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Re temedaf irel fael molwe ye haskuna ngalir ngo re motog le rebe kasiya. ");
INSERT INTO uli_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iwe rela budoh woal Capernaum ngo wol miril yar bulong yilim ngo Jesus sa kasiya mokwe re dabeyal bo, “Meda mokwe ha rol kekapaliyel fengal iyang mo lal yalap we?” ");
INSERT INTO uli_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Iwe ngo tor mele re palili ngali bo mil mala lal yalap we ngo resa rol hapaliyel fengal luwulur hare itey semal ir le ye hartael tagiyet. ");
INSERT INTO uli_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus sa marodi ngo sa ffesangur chowe seg mo rumal ngo sa kangalur bo, “Semal le be dipli le be hamwo ngo iy yebe foru le iy yebe la hamirloh ngo be mel bo boyel pangal yarmat.” ");
INSERT INTO uli_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesa ffesangu semal yalwich sala hasu mo imor. Ngo sa holu long lomolal ngo sa kangalur bo, ");
INSERT INTO uli_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Semal le be hamwale semal yalwich ka le fael ngang, ngo iy ye hamwalyey. Ngo le be hamwalyey ngo te ngang chog mele ye hamwale, bo ye wol hamwal yeramtala ye fangdoh ngang.” ");
INSERT INTO uli_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John ye kangal Jesus bo, “Sensey, ha wiri semal mal le ye kkachuchuy moniyan mo uwor yarmat le ye tteptap mala idem, iwe hasa kangalu bo yebe poloh, bo te iy chilach.” ");
INSERT INTO uli_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iwe ngo Jesus sa kangalur bo, “Ha towe hapolaho, bo tor semal le be foru sew kkemal le ye teptap mele idey le be yoh le towe ssulay mo wol miril ngo sa sor meka ye tayikof irey. ");
INSERT INTO uli_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Semal le be tema hapaliyel ngalgich ngo iy chilach. ");
INSERT INTO uli_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Isa hatugulu ngalugmi le te tugul semal le be fang sugfed chael bo limmi le fal mala hami choluway ngo ye tugul le be yor paliyel yal hachigchig. ");
INSERT INTO uli_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Hare semal yebe wigdi depel semal yalwich ka tangyey, ngo ye momay le sibe feragu sew porow kowe ye paleng ngal mala uyal siya pedaloh leted. ");
INSERT INTO uli_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Iwe ngo hare sere mala poam mele ye wigdi depom tangyey, ila ngo hosa supiloh be chuy. Ye momay le hobe bulong luwul molow la tor siyal le be halsere poam mo imol mala be rure poam ngo ho loh Infiyerno irel yafla tor siyal. ");
INSERT INTO uli_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lebola yil kala retema mes re be hangir, ngo yaef la tema gul yebe fisgir. ");
INSERT INTO uli_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ngo hare sere mala pechem mele ye wigdi depom tangyey, ngo hosa supiloh be chuy, ye momay le ho bela bulong irel molow la tor siyal le halsere pechem mo imol mala be rure pechem ngo ho loh Infiyerno. ");
INSERT INTO uli_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ngo hare sefaes mala metam mele ye weged depom tangyey, ngo hosa haltuloh be chuy, ye momay le hobe bulong irel mala Lamliyel Deus le be halsefaes metam mo imol mala be refaes metam ngo ho loh Infiyerno. ");
INSERT INTO uli_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ila lobola ye mel ‘yil kala re tema mes le re kekangi meka halongor yarmat iwe mo yaef la tema gul le ye fifisgir yarmat.’ ");
INSERT INTO uli_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Panger yarmat ngo re bele tefoy tefael irel yaef, le be wochog sew maligach le ye tefoy tefael irel hasiga. ");
INSERT INTO uli_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Hasiga ila ye momay; ngo hare bela chuyloh yal taed ila ngo be ifa sengal ngo hasa foru tefaeli le be taed? Be wochog yal paleng pelal hasiga ila be ila sengal yal paleng pelal yami mareyar, ila hami habe hafle fengaliy ila ngo be pos llepdami.” ");
INSERT INTO uli_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iwe ngo Jesus sa ligdi loboswe sa loh wol mokwe faluyel Judea iwe ngo sa supiloh Mololul we Jordan. Yarmat resa wol wuwumag ngali ngo iy sa wol chapiy yal foloy fael sew. ");
INSERT INTO uli_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tot Pharisees re sala budoh rebe hagla Jesus. Iwe resa kangalu bo, “Kangalugmem hare ye fel mo irel Hatobtob we yach le semal mal rebe mehal mo yal habulupoy?” ");
INSERT INTO uli_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iwe ngo Jesus sa hatefaeli le ye sor bo, “Meda hatobtob le Moses ye fang ngalugmi?” ");
INSERT INTO uli_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iwe ngo resa sor bo, “Moses yesa hatela le semal mal yebe yigil tefa babiorol yal mehal mo yal habulupoy ngo sa moch yoh le yebe hachuya habulupoy we yal.” ");
INSERT INTO uli_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus yesa kangalur bo, “Moses ye foru hatobtob le bo yami bo fael mala ha chiyemmay. ");
INSERT INTO uli_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Iwe ngo irel yodwe Deus ye hasub pangal formel ngo ye foru mal mo fefel le ye wochog molwe babior we ye santus ye sor. ");
INSERT INTO uli_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ila fal le semal mal be ligdi molwe temal mo molwe sil re sala sew chog mo habulupoy we yal. ");
INSERT INTO uli_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Iwe ngo chole rumal ila re bele sew chog. Re tay rumal mo iyang bo resa semal chog. ");
INSERT INTO uli_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ila tor semal le be hamahla mele Deus sa hachu fengali bo be sew chog.” ");
INSERT INTO uli_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yodwe resa tefael long lal imw we ngo mokwe re dabeyel Jesus resa kasiya kofal iy molwe. ");
INSERT INTO uli_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iwe sa kangalur bo, “Semal mal le rebe mehal mo yal habulupoy ngo resa wol la popoy sew mo semal fefel ila sa molfid, bo sa tayikof ngal yal habulupoy. ");
INSERT INTO uli_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wol ila sengal chog semal fefel le rebe mehal mo yal habulupoy ngo resa wol la popoy sew mo semal mal bo sa molfid, bo sa tayikof ngal yal habulupoy.” ");
INSERT INTO uli_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tot yarmat re kakdoh yalwich irel Jesus bo be yetedah paol uwor ngo mokwe re dabeyal resa kaftoroy ngalir rechokwe. ");
INSERT INTO uli_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yodwe Jesus yela gola molwe ngo sa ssong ngo sa kangalur mokwe re dabeyal bo, “Ha ligdir yalwich kala bo rebe budoh irey. Ha towe hapolahor bo mala Lamliyel Deus ila yar tapper rechoka. ");
INSERT INTO uli_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ihatugulu ngalugmi le semal le be te tagul ngal mala Lamliyel Deus le be wochog yalwich ka, ngo towe doh long iyang.” ");
INSERT INTO uli_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iwe ngo sa holur long yalwich kowe lomolal ngo sa yetedah paol uwol semal mo semal ir ngo sa mapelar. ");
INSERT INTO uli_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Irel yael Jesus loloh ngo semal mal sa hamdadoh irel ngo sa hasubgudiy mo imol ngo sa kasiya le ye sor bo, “Sensey Momay, meda mele ibe foru ngo sa yoh ngalyey molow la tor siyal?” ");
INSERT INTO uli_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iwe ngo Jesus sa kasiya bo, “Meda mele hola sor bo iy momay iyang? Tor semal le ye momay bo halachog Deus mele ye momay. ");
INSERT INTO uli_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ho gola hatobtob kowe ye sor bo: ‘Ho towe limeseloh semal, ho towe pere ril semal, ho towe peraf, ho towe tungu kaptal semal, ho towe kachapar, iwe ngo hobe hasrowu tamom mo solom.’” ");
INSERT INTO uli_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iwe mal we sa sor bo, “Sensey, yodwe chog iy chil yalwich yee la hola doh igla, ngo ifaesul kekasrowu chog pangal hatobtob ka.” ");
INSERT INTO uli_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus sa hafeda mal we luwul yal sa fahoy ngo sa kangalu bo, “Chil mel chog sew formel le hobe foru. Ho loh ho sala taep chuway pangal mekla mmalem iwe hosa fang mekla salpiyal ngalir malhafohoy. Ila ngo be yoh ngalug mmal la ye mel mo wol laeng. Iwe ngo hosa budoh bo hobe dabeyey.” ");
INSERT INTO uli_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yodwe mal we yela rongrong molwe Jesus ye sor ngo sa welloh wol molwe metal. Yesa loh le sa tayikof depal bo yagel mala iy ila semal yarmat le ye mmal. ");
INSERT INTO uli_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus sa kal fedal luwulur mokwe re dabeyal ngo sa kangalur bo, “Ifa lepal yal weres ngalir rechokla re mmal le rebe dohlong lal mala Lamliyel Deus!” ");
INSERT INTO uli_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Resa lluwdah mokwe re dabeyal irel pedal hapatpat kowe resa rongrong. Jesus sa taboloh yal hapatpat le ye sor bo, “Re wol layi, ye weres ngalir yarmat le rebe dohlong lal mala Lamliyel Deus. ");
INSERT INTO uli_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Iwe ngo ye kkel tot yal weres ngal semal yarmat le ye mmal le be dohlong lal mala Lamliyel Deus mo imol semal kamang le be dohlong lal chechel sew did.” ");
INSERT INTO uli_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Re lluwdah mokwe re dabeyel Jesus irel mokwe ye sor ngo resa kasiy fengal uwor le re sor bo, “Ila ngo itey le be chil daor?” ");
INSERT INTO uli_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus sa hafeda hamayur ngo sa sor bo, “Mele ila towe yoh ngalir yarmat le rebe foru, bo halachog Deus mele be mmal le be hadholong semal yarmat lal mala Lamliyal, bo pangal formel ngo ma mmal ngal Deus.” ");
INSERT INTO uli_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Iwe ngo Pedrus sa sor bo, “Kaladoh, ifa sengal hamem le hasa ligdiloh pangal formel ngo hasa daboh?” ");
INSERT INTO uli_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus sa kangalur bo, “Katos, ngo ligdi bo te tugul semal le yebe ligdi bugtal, hare bisil, hare mwengal, hare sil, hare temal, hare lol, hare yal milay bo fael ngang mo Ebangelium le ");
INSERT INTO uli_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ngo be cholop mele be yoh ngali fael mwole. Le be fael subguy yal cholop loh imwal, mo bisil, mo mwengal, mo sil, mo lol, mo yal milay. Iwe ngo be chungu mekla hafohol mo weresel. Iwe ngo irel yodka bele budoh, ngo be yoh ngali molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iwe ngo ye cholop le ye hamo igla le yebe hamir, ngo ye cholop le ye hamir igla le ye bele hamo.” ");
INSERT INTO uli_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus mo mokwe re dabeyal re dedarloh lal yalap we ye bidah Jerusalem. Jesus ye kekamo ngo mokwe re dabeyal we re dedabey ila resa merahrah. Ngo rechokwe re dedabedoh mirir ila resa wol motog. Jesus sa wol ffesangur loh mokwe re dabeyal we seg mo rumal mo solbos ngo sa kangalur mokwe bele wel ngali. ");
INSERT INTO uli_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesus sa kangalur bo, “Ha talenga! Si bele loh Jerusalem lobola molwe Layur Retalop be yohlong lal payur tamol temarong kowe mo mokwe sensel Hatobtob we mo iyang. Ngo ir re bele hatugulu le bele mes. Ngo re bele fang loh iy lal payur Gentiles, ");
INSERT INTO uli_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","rebe tapeli kamemal ngo re gutfi ngo re wodu ngo re limeseloh. Ngo bela solral mo wol miril ngo yebe molow tefael mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Iwe ngo resa budoh mokwe lol Zebedee we James mo John irel Jesus. Resa kangal Jesus bo, “Sensey, ye mel sew formel le hamem ha dipli bo hobe foru ngalugmem.” ");
INSERT INTO uli_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iwe ngo Jesus sa sor bo, “Meda iy mala ibe faor ngalugmi?” ");
INSERT INTO uli_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngo ir resa sor bo, “Yodla ho bela marodiy irel chiya la liliyem mo irel mala Lamliyem ngo ha dipli bo habe maroro lengchem. Semal hamem be mel mo rela gilemra ngo semal mo rela gilchegil.” ");
INSERT INTO uli_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus sa kangalur bo, “Ha togla fael mala ha dodongor. Be yoh le habe yul mo irel tohogol hafohoy le ye faesul tugul le ngang ibe yulmi? Hare be yoh le habe baptismus le be igegel yai be baptismus?” ");
INSERT INTO uli_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iwe ngo ir resa sor bo, “Be yoh ngalugmem.” Jesus sa kangalur bo, “Ila ngo habe yul mo irel tohoh la ye tugul le iy be yulmi, ngo ha baptismus le be igegel yai be baptismus. ");
INSERT INTO uli_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngang ila tor kkeley le ibe duwle le iy mele yebe mel rela gilemra mo rela gilchegil irey. Deus mele yebe fang ngalir rechoka yesa faesul hafle lobos kala bo liliyer.” ");
INSERT INTO uli_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yodwe chowe seg we re dabeyal rela rongrong meka ngo resa ssong ngal James mo John. ");
INSERT INTO uli_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iwe ngo Jesus sa ffesang fengalir ngo sa kangalur bo, “Hami ngo ha gola fuluka rete chepar irel Deus le mal kala yar ila yor kkeler uwor yarmat ngo tamol kala yar ila re lamlirloh panger yarmat. ");
INSERT INTO uli_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Iwe ngo hami ila towe ila sangmi. Hare semal hami le ye dipli be tagiyet mo luwulmi, ila ngo yebe hatetaloy bo yebe mel bo boyer ikala sibis. ");
INSERT INTO uli_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Hare semal hami ye dipli bo be hamo ngo be mel le boyer panger yarmat. ");
INSERT INTO uli_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngo mele mwo Layur Retalop ngo te budoh bo yarmat rebe hammale, bo ye budoh bo iy yebe hammaler yarmat. Ye fangloh yal ngas bo be demerir panger yarmat.” ");
INSERT INTO uli_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Resa budoh Jericho ngo irel yodwe bele loh Jesus mo mokwe re dabeyal mo sew buwal yarmat, ngo ye mel semal mal le ye metafis le Bartimaeus idal le lol Timaeus le ye maroro ngachel yalap le ye dodongor hammalel. ");
INSERT INTO uli_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yodwe yela rongrong le Jesusel Nazareth we molwe ngo sa chaep yal tetawulagili bo, “Jesus le lol David! Be ffaho dopom ngalyey!” ");
INSERT INTO uli_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ye cholop le ye kaftoroy ngali ngo ye kangalu bo be poloh. Iwe ngo yesa far hapalingidah tot yalol irel yal tetawulagililoh bo, “Mala Lol David, ffaho dopom ngalyey!” ");
INSERT INTO uli_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus sa poloh ngo sa sor bo, “Ha ffesangu.” Iwe resa ffesangu resa kangalu bo, “Hakkela dopom! Sudah bo yesa ffesangug!” ");
INSERT INTO uli_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iwe ngo sa pedaloh cloak we hotal sa sudah chog sa budoh irel Jesus. ");
INSERT INTO uli_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus sa kasiya mal we, “Meda mele ho dipli bo ibe hammal ngalug?” Mal we sa sor bo, “Sensey, idipli bo ibe wiri formel fael sew.” ");
INSERT INTO uli_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus sa kangalu bo, “Ho loh, tugul la yam mele sa hachuya yam metafis.” Irel yodwe chog ngo mal we sa wiri formel iwe sa dabey Jesus. ");
INSERT INTO uli_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Rela budoh wol molwe Tayitel Olives we ye mel lengchel Bethphage mo Bethany we ye mel lengchel Jerusalem ngo Jesus sa hafdale rumal mokwe re dabeyal bo rebe hamoloh mo imol. ");
INSERT INTO uli_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yesa kangalur bo, “Ha loh irel haplom lay. Ha bela hola doh ngo ye mel semal donkey le ye lemtag le tedyor semal le ye dehdah mwo iyang. Ha besi mala ffarol hasa paladoh iga. ");
INSERT INTO uli_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Hare semal be kasiyahmi hare meda mele ha besi ffarol mael la iyang, ngo hasa kangalu bo Masta we be teptap iyang, ngo be mol chog ngo sa hatefaeli.” ");
INSERT INTO uli_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iwe resa loh re sala wiri donkey we le ye lemtag ngal surel metal hatemal sew imw mo ngachel yalap. Yodwe re bebesi ffarol mael we ngo ");
INSERT INTO uli_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tot rechokwe re su lobowe resa kasiyar bo, “Meda mele ha bele foru ngal mael la le ha sala bebesiy mala ffarol?” ");
INSERT INTO uli_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iwe ngo ir resa kangalur mokwe Jesus ye kangalur. Iwe ngo chowe re resa tehacher bo rebe loh. ");
INSERT INTO uli_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Iwe resa hasidoh donkey we irel Jesus. Resa yitlidah cloak kowe hoter uwol mael we. Iwe ngo Jesus sa marodah uwol. ");
INSERT INTO uli_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ye cholop le sa feraglaloh hotal cloak lal yalap we. Ngo tot re kak paddol resa feraglaloh lal yalap we. ");
INSERT INTO uli_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Rechokwe re hamo mo ikowe re dedabedoh miril re tetawulagliloh le re sor bo, “Sibe hapingpinga Deus! Deus yebe holbuwa yeramtala ye budoh mo irel mala idel Samol! ");
INSERT INTO uli_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Deus yebe holbuwa mala lamliyel King David le temach le ye bele budoh! Sibe hapingpinga Deus le ye hartal tagiyet!” ");
INSERT INTO uli_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus ye budoh wol Jerusalem sa bulong lal Templum we sala balsi fedaley pangal formel. Iwe ngo yagil mala sa bong ralawe, iwe Jesus mo mokwe re dabeyal we seg mo rumal resa loh wol Bethany. ");
INSERT INTO uli_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ralawe seral irel yar la tetefaeldoh mo Bethany ngo Jesus sa kalloh. ");
INSERT INTO uli_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ngo yela kaleloh medaw, sala wiri sahay ire le rema sor bo fig le ye cholop yul. Iwe sa loh bela kamahoy hare yor uwal. Ye loh sala wiri le ye cholop yul ngo tor uwal bo ted hola yodla be yor uwal iyang. ");
INSERT INTO uli_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesus sa kangalu ire we bo, “Tayor semal le be chil mongoy mekla uwam gel ire le!” Iwe ngo mokwe re dabeyal re rongrong mokwe Jesus ye sor. ");
INSERT INTO uli_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yodwe rela hola doh Jerusalem ngo Jesus sa bulong ye sala ddabsulur wey panger rechokwe re chuchuway mo ikowe re fefang chuway mo lal Templum we. Iwe ngo ye hachappa fedaley tis kowe yar chol hadidilil salpiy mo mokwe liliyer rechoka re chuchuway pigeons. ");
INSERT INTO uli_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesus te dipli le semal be hasilong sew formel lal lemelal Templum we. ");
INSERT INTO uli_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iwe ngo sa foloyur yarmat le ye sor bo, “Ye teftaf lal Babior we ye Santus we Deus ye sor bo, ‘Templum le yai ila yebe mel bo sew imwel mepel le yar panger yarmat.’ Iwe ngo hami hasa yitol le imwer chomachoh!” ");
INSERT INTO uli_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iwe ngo tamol temarong kowe mo mokwe sensel Hatobtob we resa rongrong mele, iwe sa chaep yar memer fedaley sew formel le rebe limeseloh Jesus iyang. Iwe ngo re metagu bo yagil mala pangal yarmat ngo resa lluwdah irel foloy kowe yal. ");
INSERT INTO uli_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yela lefhaf doh ngo Jesus mo mokwe re dabeyal resa chuy tang haplom we. ");
INSERT INTO uli_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lemaguyogul chog ralawe seral le re dedarloh lal yalap ngo re sala wiri ire we le sa mesdiy mo lal molwe sibol yee la hola mokwe wahral. ");
INSERT INTO uli_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sa mmang ngali Pedrus molwe Jesus ye foru ngal ire we. Iwe sa kangalu Jesus bo, “Sensey, kaleloh! Ire we ho sig ngali ila sa mes!” ");
INSERT INTO uli_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iwe ngo Jesus sa kangalur bo, “Be tugul lal dipmi irel Deus. ");
INSERT INTO uli_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ibe hatugulu ngalugmi le te tugul semal le be yor yal tugulul ladep, iwe ngo te yeyewal depal, ngo be yoh le be kangal tagitat le be chuy sala pungdi mo leted ngo Deus be hayaho ngali. ");
INSERT INTO uli_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ila fal le ikangalugmi bo habe dongor sew formel luwul yami mapel, ngo habe hatugulu lal dipmi le sa yoh, ila ngo te tugul mele habe dongor ngo be yoh ngalugmi. ");
INSERT INTO uli_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Iwe ngo ha bela mepel ngo yebe ffahoy dipmi ngo ha hachuya mo lal yami luluwal mekla ha ssong ngal semal iyang, ila ngo mala Tammi wol laeng be ffaho depal ngalugmi ngo ye hachuya fael yami molfid. ");
INSERT INTO uli_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Hare be te ffaho dipmi ngalir yarmat, ila ngo mala Tammi wol laeng ye towe ffaho depal ngalugmi irel molfid kala yami.” ");
INSERT INTO uli_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Resa wol tefaeldoh wol Jerusalem. Ye dedarlong Jesus lal Templum we ngo sa budoh tamol temarong kowe mo mokwe sensel Hatobtob we mo mal kowe yar iwe ngo resa kasiya bo, ");
INSERT INTO uli_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Meda igegam le hola foforu meka? Itey le ye fang kkelem?” ");
INSERT INTO uli_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iwe ngo Jesus sa kangalur bo, “Ibele kasiyahmi sew chog kasiy. Iwe ngo hare ye yoh le ha hatefaeli, ila ngo ibe kangalugmi lobosle ye budoh kkeley mo iyang irel meka ifoforu. ");
INSERT INTO uli_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ha kangaluyey hare ye budoh kkelel Johannes mo iya le be ma baptismus: ye budoh mo irel Deus hare irel yarmat?” ");
INSERT INTO uli_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Resa rol fedgagli fengali uwor le re sor bo, “Meda mele sibe sor? Hare sibe sor bo, ‘Ye budoh mo irel Deus,’ ngo ye bele sor bo ‘Ila ngo meda mele hate chepar ngal Johannes iyang?’ ");
INSERT INTO uli_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hare si sor le, ‘Ye budoh mo irel yarmat...’” (Resa metagur yarmat bo panger yarmat ngo resa chepar bo Johannes ila semal profeta.) ");
INSERT INTO uli_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iwe tefaelel kasiy we yael Jesus ila re sor bo, “Ha togla.” Iwe Jesus sa kangalur bo, “Hare ila sengal ila ngo ngang itowe kangalugmi lobosle ye budoh kkeley mo iyang bo ibe foru meka.” ");
INSERT INTO uli_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iwe ngo Jesus sa hapatpat ngalir le ye teptap fiyong, le ye sor bo, “Ye mel semal mal le ye foru sew milayel grape bo yal iwe sa yorora. Iwe sa kilngi sew lib bo liliyel wungungul chael grape. Iwe ngo sa hasu sew imw bo imwer re matmetal milay we. Iwe ngo yesa hamler re matmat kowe iyang ngo yesa ligdi molwe bugtal sala malekah. ");
INSERT INTO uli_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yodwe yela masow grape kowe uwal milay we iyang, ngo mal we sa fangloh semal boy kowe lol irer chol hammalel milay we bo rebe fang ngali mele yildil mo irel uwal milay we. ");
INSERT INTO uli_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Iwe ngo ir re matmat kowe re hasi resa lliy boy we, resa hatefaeli le tor mele re ngaley. ");
INSERT INTO uli_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Iwe ngo mal we yal milay we sa wol fangloh semal boy kowe lol irer rechokwe. Iwe ngo ir re hasi resa wwodu molwe chemal ngo re hafohoyu fedaley. ");
INSERT INTO uli_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mal we sa wol fangloh semal boy kowe lol. Iwe ngo ir rechokwe re hasi chog resa limeseloh. Ye retloh boy kowe lol mal we le iye sengal chog mekla re faor ngalir, le tot ikla re hafohoyur ngo tot ikla re limeserloh. ");
INSERT INTO uli_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Iwe sala tarmal we chog spegil lol we ye kkel yal hachangi mele yela mel diy. La hartal loh ngo sa fangloh molwe lol ngo sa sor bo, ‘Ye tugul lal depey le rebe hasrowu mele layi.’ ");
INSERT INTO uli_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Rechokwe rela wiri chog molwe lol ngo resa sor bo, ‘Iye molwe lol yeramtawe bugtal mele. Ha rodoh sibe limeseloh bo sibe bugtali mele bugtal!’ ");
INSERT INTO uli_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Iwe resa ddorfi tarmal we resa limeseloh resa pedawey mo yilgul milay we.” ");
INSERT INTO uli_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iwe ngo Jesus sa kasiyar bo, “Meda mele mal we yal milay we bele foru? Ye bele budoh llir rechokwe ngo yesa ngaler sibis milay we. ");
INSERT INTO uli_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ha ted yawli mwo mele mo lal babior we ye santus? ‘Feas we chol hasul imw re pedaloh bo tor pelal ila feas la sala mel le ye hartal paleng pelal. ");
INSERT INTO uli_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mele ila Samol mele ye foru le be iye sengal; ye foru le tor hapagol yal kkamdidiy!’” ");
INSERT INTO uli_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mokwe metael yalor Jews resa luluwaley rebe ddorfi Jesus bo resa gola le fiyongor molwe yesa kangalur. Iwe ngo re metagu buwa we, iwe resa ligdi Jesus resa loh. ");
INSERT INTO uli_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Resa fangloh tot Pharisees kawe mo tot mokwe choluwal Yerodes bo re bela hapagu Jesus ngal tot kasiy. ");
INSERT INTO uli_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Resa budoh irel resa sor bo, “Sensey, hamem ha gola le ye katos mekla ho sosor ngo ho tela sar mmerahrah mwo irel makla yarmat re luluwaley. Ho hafidgir loh chog panger yarmat. Ho sala foloyu ngal yarmat mala ye katos le depel Deus. Kangalugmem hare ye fel mo irel Hatobtob we yach le sibe ffaeg paliyel raeg ngal mala Llulupal Roma? Sibe ffaeg hare si towe ffaeg?” ");
INSERT INTO uli_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yodwe chog ngo Jesus yesa gola luluwal kowe yar. Iwe ngo sa kasiyar bo, “Meda mele ha luluwaley habe hapaguyey iyang? Ha hasidoh sefaes salpiy kowe silver bo iy be kamahoy.” ");
INSERT INTO uli_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iwe resa hasidoh sefaes salpiy silver resa ngaley. Iwe ngo Jesus sa kasiyar bo, “Yongol itey mo idel itey mele?” Iwe ngo ir resa sor bo, “Yongol mo idel molwe Llulupal Roma.” ");
INSERT INTO uli_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus sa kangalur bo, “Hare ila sengal ngo hasa ngaley mala Llulupal Roma mekla lamliyal ngo hasa ngaley Deus ikala lamliyel Deus.” Iwe re sala toglaloh mele rebe sor irel Jesus. ");
INSERT INTO uli_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tot mo irer Sadducees kowe rema sor bo tor mele molow tefael mo irel maes, re budoh irel Jesus resa kangalu bo, ");
INSERT INTO uli_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Sensey, Moses ye tefadiy hatobtob le bo yach ngo ye sor bo: ‘Hare la mes semal mal ngo tor layur mo mala ril, ngo molwe bisil mal we sa mes be rili fefel we, bo bela yor layur ngo yebe yitilir bo lol mal we bisil we sa mes.’ ");
INSERT INTO uli_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ye mel fismol bisbis ngo ila chog mol yarmat mele yor ril ngo yela mesloh ngo tor lol. ");
INSERT INTO uli_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Iwe molwe harumalel yarmat sala rili fefel we ngo yela mesloh mal we ngo wol tor lol. Ye wol ila sengal iwe hasolmolol yarmat. ");
INSERT INTO uli_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pangerloh bisbis we fismol ngo re riliy fefel we. Iwe panger ngo re mesloh le tor chog layur. Yela wol miril loh ngo yesa moch mes fefel we. ");
INSERT INTO uli_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Itey semal mo irer irel yodla re bela molow tefael mo irel maes le be mel bo ril fefel we? Pangerloh ngo iwe re rili fefel we.” ");
INSERT INTO uli_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus sa kangalur bo, “Ila lepal yami machey! Ha gola fal? Mil mala ha temdaf irel yadol Babior we ye Santus ngo ha togla mala kkelel Deus. ");
INSERT INTO uli_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yodla chomes re bela molow tefael mo irel maes ngo re bele hafedeg ngalir chog angelus kala wol laeng le retema riri. ");
INSERT INTO uli_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iwe ngo kofal yar yarmat molow tefael mo irel maes: ha ted yawli mwo molwe kaptal ire we ye bbulbul we ye mel lal Babior we yael Moses? Ye teftaf iyang we Deus ye kangalu Moses bo, ‘Ngang mele yael Abraham mo Isaac mo Jacob Deus.’ ");
INSERT INTO uli_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Iy yar chomolow Deus ngo te iy yar chomes Deus. Hami ila sa paleng yami machey!” ");
INSERT INTO uli_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ye mel semal sensel Hatobtob we loboswe le ye rongrong mokwe re kekapta. Ye rongrong tefaelel kasiy kowe yar Sadducees kowe le ye bung. Iwe sa budoh irel Jesus sa kasiya bo, “Ifa sew mo luwul mokwe yadol hatobtob we le ye palleng fal?” ");
INSERT INTO uli_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus sa sor bo, “Mala ye hartal palleng fal ila iye sengal: ‘Ha talenga hami yeramtal Israel! Samol la yach Deus ila iy chog mele yach Samol. ");
INSERT INTO uli_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Habe hachangi Samol le yami Deus mo lal dipmi, mo pangal loh ngulmi, kkelmi mo yami luluwal.’ ");
INSERT INTO uli_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mala harwowal le ye wol palleng fal, ila hobe hachangir yarmat le be wochog yam gel hachangug. Tor sew mo luwul yadol hatobtob we le ye palleng fal mo imol mele ruwow.” ");
INSERT INTO uli_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sensel Hatobtob we sa kangal Jesus bo, “Ila sengal ho sensey! Ye katos mala ho sor le Samol chog mele Iy Deus. Tor semal mo solbos bo iy loh chog. ");
INSERT INTO uli_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ila semal ngo yebe hachang Deus mo lal depal mo pangal loh yal luluwal mo pangal loh kkelal, ngo yebe hachang yarmat le be wochog yal iy hachangi wol halongol. Ye palleng pelal le sibe dabey meka ruwow mo irel Hatobtob we mo imol mala sibe taep maligach mael, mo maligach kala tot le sima fang ngal Deus mo woal altar.” ");
INSERT INTO uli_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yodwe Jesus yela gola le ye momay mokwe sensel Hatobtob we ye sor, ngo sa kangalu bo, “Gel ila ho tay ddaw tang mala Lamliyel Deus.” La wol miril chog mele ngo tayor mele re chil mechal kasiya Jesus. ");
INSERT INTO uli_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Irel yodwe Jesus ye fofoloy lal Templum we, ngo sa kasiyar bo, “Ifa sengal chog ngo mokwe sensel Hatobtob we re sala sor bo Kristus ila chol daowe yael David? ");
INSERT INTO uli_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Espritu Santus ye hatarma lal depel David bo yebe sor bo: ‘Samol ye kangalu yai Samol: Maro mo rela gilemra irey yee la hola yodla ibe yitilirlong fael pechem rechokla re tayikof ngalug.’ ");
INSERT INTO uli_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Iy mwo David ngo ye ffesangu bo ‘Samol’. Ila be ifa sengal chog ngo Kristus sala mel bo iy semal chol daowe yael David?” Sew buwa re tetalenga mokwe yalol Jesus ngo ye rraey lal deper iyang. ");
INSERT INTO uli_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yodwe ye fofoloyur ngo sa kangalur bo, “Habe hafalugmi irer mokwe sensel Hatobtob we. Re dipli bo rebe dedaer fedal le re mengag irel mengag kowe ye lelay ngo re dipli bo yarmat rebe ma hasrowur mo loboka ma toa cholop doh chog yarmat iyang. ");
INSERT INTO uli_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ngo rema duwley chog lobos kala ye momay bo liliyer mo lal imwel ttey ka ngo re wol dipli bo rebe ma mel irel lobos kala liliyer chotagiyet mo irel gubul ka. ");
INSERT INTO uli_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ye ffal deper uwor fefel kala sa mes rir le rema hasi tangir bugter iwe ngo rema forurloh irel mepel kala yar le ye lelay bo yarmat rebe wiri, ila yebe hartal kkel yar hagerger.” ");
INSERT INTO uli_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yodwe Jesus ye maro lengchel liliyel maligach we lal Templum we ngo ye kakemahor yarmat yar ppepe yar maligach. Ye cholop rechokla re mmwal le ye cholop salpiy le re pedalong lal kahol we. ");
INSERT INTO uli_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iwe ngo ye mel semal fefel le sa mes mala ril ngo sa kkel yal hafohoy le ye wol budoh sa pedalong rufeas kobre checha lal liliyel maligach we. ");
INSERT INTO uli_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesus sa ffesang fengalir mokwe re dabeyal sa kangalur bo, “Ibe kangalugmi le fefel le ye hafohoy ila ye palleng mele ye pedalong lal liliyel maligach la mo imwor rechokwe tot. ");
INSERT INTO uli_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Rechokla ila hal sugfed mele re hasi mo irel salpiy kala layur le ye cholop resa yetolong lal liliyel maligach la. Iwe ngo fefel la ila ye kkel yal hafohoy ngo sa fang loh lepal mala hammalel le ye mel irel bo yal maligach.” ");
INSERT INTO uli_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Irel yodwe Jesus sa buyoy mo lugul Templum we ngo semal mokwe re dabeyal sa kangalu bo, “Kaleloh ho Sensey! Temmoh ikla imw le ye fetfat ngal feas kowe ye momay!” ");
INSERT INTO uli_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus sa sor bo, “Ha wiri lepal pallengel imw ka? Tor sew feas ka le be mel diy liliyal bo pangal ngo be medardar diy wototol.” ");
INSERT INTO uli_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus ye maroro wol molwe Tayitel Olives lufulyel loh Templum we, ngo Pedrus mo James mo John mo Andrew resa budoh irel le ir loh chog. ");
INSERT INTO uli_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Iwe resa kangal Jesus bo, “Kangalugmem hare yinged mele yebe weldoh maka iyang. Iwe ngo hosa kangalugmem hagilel yodla be weldoh iyang.” ");
INSERT INTO uli_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus sa kangalur bo, “Habe llugu dipmi bo semal de kachaprahmi. ");
INSERT INTO uli_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ye cholop yarmat le resa yeyedamgel bo rebe kapta meka yaloy le re bela budoh ngo re bele sor bo, ‘Ngang mele Kristus!’ Ngo ye cholop yarmat le ir taper rechoka re bele kacheprar. ");
INSERT INTO uli_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ha towe rusmes irel kaptal fedeg ka sa harep doh mo kaptal fedeg ka chil ddaw. Tappel meka ila ye tugul le be weldoh ngo halachog ila temil mala bele budoh miril faileng. ");
INSERT INTO uli_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sew mo sew fuluy ila re bele rol fedeg fengal. Sere mo sere tamol re bele rol fedeg fengal. Ye bele falmor ngo ye laengda. Pangal hafohoy ka ngo be wochochog semal chosiyal le sa kkilsi yal tomay. ");
INSERT INTO uli_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Hami mwo ngo habe llugu dipmi bo re bele dorfugmi resa hasugmiloh lal imwel tatelal hapatpat. Re bele wodugmi mo lal imwel ttey kala yar ngo ha bele la su mo imor tamol mo king le fael ngang bo habe kangalur Hapatpat Momay le. ");
INSERT INTO uli_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Imol mala be budoh miril faileng ngo towe mmwal le habe te foloyu mwo Ebangelium le ngal pangal fuluy. ");
INSERT INTO uli_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Iwe ngo yodla re bela dorfugmi resa hasugmiloh irel imwel tatelal hapatpat, ngo towe ted kkeral chog ngo sa yeyewal dipmi irel mekla habe sor. Bela hola yodla ngo hasa sor mekla ha gola habe sor le Espritu Santus ye fang ngalugmi. Bo mekla ha bele kapta ila te yalomi bo ye budoh mo irel Espritu Santus. ");
INSERT INTO uli_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yarmat re bele fangloh spegil bisir bo re bela llirloh, ngo temer yalwich ila be wol ila senger ngal layur. Yalwich ila re bele hapaliyel ngalir wulyotugur ngo re fangloh ir bo re bela llirloh. ");
INSERT INTO uli_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pangal yarmat ngo re bele hafobdurugmi le fael ngang. Ngo semal le yebe yedamgel chog yee lessiyal yal mes ngo yebe daor. ");
INSERT INTO uli_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ha bele wiri Molwe Ye ‘Hartael Hamotog’ le bele ccheloh ngulmi iyang le bele la su lobola te sul mo sengal le be su iyang.” (Le be yawli mele ngo be medfagili fael mele!) “Ila ngo rechokla re mel wol Judea ila re bele hawdah wottayit. ");
INSERT INTO uli_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Semal mal le yebe mel wol imwal, ngo ye towe wumes fedal le hare yebe bulong yilim bo ye bela kak lital. ");
INSERT INTO uli_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Semal le be mel wol yal milay ngo ye towol tefael ngal imw we imwal bela hasi hotal. ");
INSERT INTO uli_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ifa lepal yar be hafohoy fefel kala re siyal mo ikala ye chil ppachigchig layur! ");
INSERT INTO uli_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ha mepel ngal Deus bo dela weldoh meka ngo llifang! ");
INSERT INTO uli_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bo hafohoy le bele budoh ila ye kkel hamas tang pangal hafohoy ka sa budoh le ye chaep chog irel yodwe Deus ye foru faileng le yee la holadoh raleka. Ngo tayor sew hafohoy le be chil budoh mo fael sew le be wochog mele. ");
INSERT INTO uli_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ngo ligdi bo Samol sa hawechidoh lepal mala ssulayel bungul, bo hare yete foru ngo tor le yebe molow. Bo fael rechoka yesa duwler bo lol mele sa hawechidoh lepal ssulayel hafohoy la iyang. ");
INSERT INTO uli_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Iwe hare semal yebe kangalugmi bo, ‘Ha kaladoh! Kristus we iye!’ hare ‘Ha kaleloh! Iye lay!’ Iwe ngo ha towe chepar ngali. ");
INSERT INTO uli_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iwe ngo yor rechokla re bele budoh le yor ir le re bele forgirloh bo ir Kristus ngo yor ikala re bele forgirloh bo ir profeta. Re bele hafodlohor yarmat irel mekla repiyer mo kkemal kala yar bo hare be yoh le rechoka mwo Deus sa duwler ngo be weg deper ngalir. ");
INSERT INTO uli_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Habe llugu dipmi! Bo isa kangalugmi pangal meka mo imol yodla yebe weldoh iyang. ");
INSERT INTO uli_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Lal ral kalay wol miril hafohoy le, ngo bele gul yaal ngo ye towol wer meram ");
INSERT INTO uli_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ngo bele mordiy fisil lal laeng ngo ye taroprop yalwelang. ");
INSERT INTO uli_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ngo bele lahdoh mala Layur Retalop mo luwul darmiy luwul mala kkelal mo falmay la yal. ");
INSERT INTO uli_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iwe ngo ye bele fangloh angelus kowe lol lal pangal rerel failengle bo rebe hahofagi fengalir rechokla Deus sa duwler. ");
INSERT INTO uli_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Iye mele habe medaf iyang mo irel sehay fig. Yodla be chaep yal feter mekla ral ngo ye yichwey mekla yul ngo hami ha bele gola le sa harep llereg. ");
INSERT INTO uli_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tappel chog yodla ha bela wiri meka sa weweldoh, ngo ha bele gola le yodwe ila sa harep le ye bele hola gich. ");
INSERT INTO uli_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Hade maligili le meka ila be weldoh mo imol mala rebe mes rechoka re chil molow fael mwole. ");
INSERT INTO uli_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Be moaloh laeng mo talop ngo meka yaloy ila tor fael sew le be moa. ");
INSERT INTO uli_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Tor semal le ye gola ralla mo awa la yebe weldoh meka iyang. Angelus kala mwo wol laeng mo mala Lol Deus ngo re togla, bo halachog Deus le Temal mele ye gola. ");
INSERT INTO uli_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ha itol dipmi ngo hasa llugu dipmi bo ha togla hare yinged mele yebe holahmi iy yodla. ");
INSERT INTO uli_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ye wochog semal mal le bele ligidi mala bugtal bo bela malekah ngo yesa kangal semal mo semal boy kowe lol mele yebe foru. Iwe ngo yesa kangalu re metmetal hatam we bo towe masor. ");
INSERT INTO uli_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ila ha towe masor bo ha togla sew yad le yebe budoh mala tamol imw la iyang. Sew ila yebe budoh llefhaf, hare lugul bong, hare lemeral, hare llemaliyel. ");
INSERT INTO uli_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Hare ha tedaploh chog ngo yesa budoh, ngo tayikof le bela wurugmidoh le ha masor. ");
INSERT INTO uli_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Meka isa sor ila yaloy ngalugmi ngo yaloy ngalir panger yarmat: Ha towe masor!” ");
INSERT INTO uli_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Irel yodle ngo sa fe rural mo imol molwe Bungul Paska mo iwe Bungul Flowa we tema yor Habboloh iyang, ngo tamol temarong kowe mo mokwe sensel Hatobtob we resa memeri sew fil le rebe ddorfi Jesus bo rebe limeseloh le tor le yebe gola. ");
INSERT INTO uli_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iwe ngo resa sor bo, “Si towe foru mele irel bong le bo rede wehaha fedal yarmat iyang.” ");
INSERT INTO uli_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus ye mel woal Bethany irel mala imwel Simon we ye pachngali mwo mesel pekel. Yodla Jesus ye momongoy ngo sa bulong semal fefel le ye hasi sew molor le ye faor mo irel alabaster le yor loy kowe ye momay boel ngo ye chaw paliyal iyang le ye yultul loh nard. Sa sugu loy we sa chaelfi ngal molwe chemel Jesus. ");
INSERT INTO uli_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Resa ssong tot rechokawe re mel loboswe ngo resa sor bo, “Meda pelal yal la hatolpaloh loy la? ");
INSERT INTO uli_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yebe yoh le rebe taep chuway ngo be ligid sulbuguy faesol salpiy kowe silver mala paliyal bo rebe fang ngalir mael hafohoy.” Iwe resa kasigsig ngal fefel we. ");
INSERT INTO uli_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus sa kangalur bo, “Ha ligdi! Meda mele hala keketal ngali iyang? Iy yesa faor ngalyey sew formel le ye momay ngo ye kkamdidiy. ");
INSERT INTO uli_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hami ila pangal yad ngo be yor chog mael hafohoy iremi. Te tugul sew yad le habe dipli ngo be yoh le habe hamaler. Ngo ngang ila fotot ngo itowol mel iremi. ");
INSERT INTO uli_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iy yesa foru lepal mala ye mmal le yebe foru. Yesa chaelfi mele holngoy bo be hafle mo imol yodla bela liblib. ");
INSERT INTO uli_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ibele hatugulu ngalugmi le te tugul solbos mo lal failengle le ha bela foloyu Ebangelium le mo iyang, ngo yebe mmang ngalugmi mele fefel le yesa foru.” ");
INSERT INTO uli_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iwe ngo Judas Iscariot we semal mo irer chowe seg mo rumal we re dabeyel Jesus, yesa loh irel tamol temarong kowe ye sala kangalur bo yebe fang ngalir Jesus. ");
INSERT INTO uli_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yesa momay deper irel molwe rela rongrong molwe ye sor. Resa hatugulu bo rebe fang ngali salpi. Iwe Judas yesa memer sew yad le yebe fel bo yebe hayaholong Jesus lal payur. ");
INSERT INTO uli_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Metamol ral mo irel molwe Bungul Flowa we tema yor Haboloh iyang, ralawe rema lliy saaf kowe rema hangi irel Mongol Paska, ngo mokwe re dabeyel Jesus resa kasiya bo, “Iya solbos le ho dipli bo ha bela hafle bo si bela faor yach Mongol Paska mo iyang?” ");
INSERT INTO uli_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iwe Jesus sa hagloyu rumal ir le sa kangalur bo, “Ha bidiy luwul haplom ngo ha bela chungu semal mal le ye hasi sew rumel chael. ");
INSERT INTO uli_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ha dabeloh irel imw la bela bulong iyang ngo hasa kasiya yeramtala imwal bo, ‘Sensey we ye kasiy hare ifa senggil we iy mo mkwe re dabeyal rebe faor Mongol Paska we mo iyang?’ ");
INSERT INTO uli_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Iwe ngo ye bele kewar ngalugmi sew senggil le ye palleng le ye mel irel dalla wulural le sa faesul momay mala lal. Ila lobosla ha bela hafle bo sibe mel iyang.” ");
INSERT INTO uli_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Resa loh mokwe re dabeyel Jesus irel haplom we re sala wiri le pangal mokwe ye sor ngo ye ppalu ngali. Iwe resa faor yar Mongol Paska. ");
INSERT INTO uli_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yela lefhafdoh ngo sa budoh Jesus mo mokwe re dabeyal we seg mo rumal. ");
INSERT INTO uli_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yodwe resa mel irel tis we le resa momongoy ngo Jesus sa kangalur bo, “Ibe kangalugmi le ye mel semal mo luwulumi rechoka si momongoy sew le bele fangloh ngang.” ");
INSERT INTO uli_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sa tayikof lal deper mokwe re dabeyal ngo sa semal mo semal ir yar kasiya bo, “Te ngang mala ho sosor, hare?” ");
INSERT INTO uli_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus sa kangalur bo, “Yeramtala iy sosor ila semal mo luwulumi chole seg mo rumal le be sew chog yamem chichi halmem flowa lal tohoh le. ");
INSERT INTO uli_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mele Layur Retalop ila bele mes le yebe wochog molwe Babior we ye Santus ye sor. Ngo ifa lepal kkelel hafohoy le be hola yeramtala yebe fangloh mala Layur Retalop! Ye far momay le yete subdoh!” ");
INSERT INTO uli_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yodwe re momongoy ngo Jesus sa hasi sedep flowa sa mapela, ngo ye kangal Deus yal hachigchig. Iwe sa dipiy sa ngaler mokwe re dabeyal ngo sa kangalur bo, “Ha hasi. Mele ila holongoy.” ");
INSERT INTO uli_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iwe ngo sa hasi sew kap ngo sa kangal Deus yal hachigchig, ngo yesa hadayu ngalir ngo panger ngo re yul mo iyang. ");
INSERT INTO uli_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesus sa sor bo, “Mele ila cchay le bele serloh bo yaglir panger yarmat, ngo mele cchay ila ye bele mel bo tugulul bogtag le yael Deus ngalugmi. ");
INSERT INTO uli_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ibe kangalugmi le tayor fael sew le ibe chil yul wine le yee, la hola yodla ibe yul wine la ye tefoy mo irel mala Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iwe resa yawli sew ton ngo resa loh irel molwe Tayitel Olives. ");
INSERT INTO uli_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus sa kangalur bo, “Pangami ngo ha bele ddar ngo ha bele ligdiyey le be wochog molwe Babior we ye Santus ye sor, ‘Deus ye bele lliy re metmetal saaf we, ngo saaf kowe ila re bele medardar fedal.’ ");
INSERT INTO uli_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngo halachog ila bela wol miril yal hamolowa tefaeliyey mo irel maes ngo ibe hamo ngal Galilee mo imomi.” ");
INSERT INTO uli_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Iwe ngo Pedrus sa sor bo, “Tor fael sew le ibe ligdug, le ila mwo panger rechoka sibis ngo re ligdugloh.” ");
INSERT INTO uli_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus sa kangalu Pedrus bo, “Ibe kangalug igla le imol harwowel kkogol malog bongey, ngo gel ila bele fael suluw yam sor bo ho toglayey.” ");
INSERT INTO uli_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Iwe ngo Pedrus sa hakkeladah tot yal hapatpat ngo sa sor bo, “Ila mwo ila daboh irel maes ngo tor fael sew le ibe sor mala!” Iwe ngo panger ikowe sibis ngo wol ila sengal chog mele re sor. ");
INSERT INTO uli_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Resa budoh irel solbos le rema sor bo Gethsemane ngo Jesus sa kangalur mokwe re dabeyal bo, “Ha marodiy iga bo ngang iy bela mapel.” ");
INSERT INTO uli_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesa ffesangu Pedrus mo James mo John resa loh. Sa kkel weresel mo tayikofel lal depel Jesus. ");
INSERT INTO uli_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Iwe sa kangalur bo, “Sa kkel weresel mele depey le sa fesugfed ngo bele pediyey diy wototol. Ha mel iga habe matlagiyey.” ");
INSERT INTO uli_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesa dar tangir sugfed ngo yesa ungdiy wototol ngo sa mapel ngal Deus bo hare be yoh le iy ye towe bulong luwul hafohoy ka. ");
INSERT INTO uli_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iwe ngo sa mapel, “Temay Deus, pangal formel ngo ma yoh irem. Hachuya tangyey kapal hafohoy le. Ngo ligdi bo te mekla idipli mele hobe foru, bo mala ho dipli mele hobe foru.” ");
INSERT INTO uli_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iwe ngo yela tefael ngo rosolmol mokwe re dabeyal ngo resa masor. Yesa kangal Simon Pedrus bo, “Simon, hosa masor? Mala mwo sew awa ngo towe mmal le hobe mmat iyang?” ");
INSERT INTO uli_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Iwe yesa kangalur bo, “Ha mmat bo habe mepel bo hade weg ngal molfid. Ye kkel ngoel ngo tay kkel holong.” ");
INSERT INTO uli_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sa wol tefael loh fael sew sala mepel le ye wol tefael ngal chog mepel kowe yal. ");
INSERT INTO uli_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iwe yela tefaeldoh irer mokwe re dabeyal ngo resa wol masor bo tay mmal yar hadol. Ngo re tay gola mele rebe kangalu. ");
INSERT INTO uli_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yela hasluwel yal tefaeldoh irer ngo sa kangalur bo, “Ha chil rol masor ngo ha kkasoso? Maila bo sa hola yodwe! Ha kalloh, molwe Layur Retalop iye sa yoh loang lal payur choto hamolfid. ");
INSERT INTO uli_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hale sudah siya loh. Ha kalloh, yeramtawe ye fang loh ngang iye lay!” ");
INSERT INTO uli_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ye chil kapatpat Jesus ngo sa budoh Judas we iy semal chowe seg mo rumael. Ye palirdoh tot yarmat le re kak sayden mo tebtabol ire le tamol temarong kowe mo mokwe sensel Hatobtob we mo mal kowe yar mele re hagloyur doh. ");
INSERT INTO uli_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yeramtawe ye fangloh Jesus ye fang sew hagil ngal buwa we le ye sor bo, “Semal le iy be fesngo ngo ila mele iy. Ha ddorfi hasa hasiloh hasa itol dipmi irel.” ");
INSERT INTO uli_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yodwe chog Judas ye hola doh lobowe ngo sa dar wwel ngal Jesus sa kangalu bo, “Sensey!” Iwe ngo Judas sa fesngo. ");
INSERT INTO uli_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iwe resa ddorfi Jesus resa hamachu hamayi. ");
INSERT INTO uli_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iwe ngo semal rechokwe ye su loboswe sa yuldadah sayden we lol sa ssupiloh sere talengal boy we lol Llulupal Temarong we. ");
INSERT INTO uli_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus sa malili ngo sa sor bo, “Hasa yitili bo ngang semal mael machoh, le ha sala budoh fengal mo lomi sayden mo tebtabol ire bo habe ddorfiyey? ");
INSERT INTO uli_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sa seral mo seral yami ma wiryey yai fofoloy lal Templum we ngo ha te dorfiyey. Ngo halachog ila meka ila yebe palu ngal mokwe ye mel lal Babior we ye Santus.” ");
INSERT INTO uli_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iwe pangal mokwe re dabeyel Jesus ngo resa ddar resa ligdiloh. ");
INSERT INTO uli_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ye mel semal tarmal le ye yaya irel setab mengag le ye dedabey Jesus. Re memmel le rebe ddorf ");
INSERT INTO uli_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ngo ye ddar sa ttahchadiy mengag we ye yaya iyang. ");
INSERT INTO uli_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iwe resa hasiloh Jesus irel imwel Llulupal Temarong we. Ila lobole resa ttey tamol temarong kowe mo mal kowe yar mo mokwe sensel Hatobtob we iyang. ");
INSERT INTO uli_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrus ye dedaber le ye dedar mo medaw yee la bulong lal yororol imw we imwel Llulupal Temarong we. Sa marodiy luwulur pos kowe bo be rangi irel yaef we. ");
INSERT INTO uli_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tamol temarong kowe mo pangerloh chol Ttey we yar ngo re memeri mele be mel bo derel Jesus bo hare be yoh le rebe llimeseloh. Iwe ngo tor mele re wiri bo derel. ");
INSERT INTO uli_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ye cholop le sa ffaordah chog kaptal Jesus ngo mekla re sor ila te hafedeg fengal. ");
INSERT INTO uli_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Iwe ngo resa sudah tot mal ngo resa tungudah mele kaptal le re sor bo, ");
INSERT INTO uli_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ha rongrong le Jesus ye sor bo, ‘Ye bele hamderaloh Templum le foriyel yarmat, ngo bela solral mo wol miril ngo yesa hasu tefaelidah sew le te foriyel yarmat.’” ");
INSERT INTO uli_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ir mwo ngo te hafedeg fengal mekla re sor. ");
INSERT INTO uli_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Llulupal Temarong we sa sudah mo imol pangal loh yarmat ngo yesa kasiya Jesus bo, “Yor mele hobe sor irel mekla re sor bo derem?” ");
INSERT INTO uli_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Iwe ngo Jesus sa poloh chog le tor mele ye sor. Llulupal Temarong we sa wol kasiya le ye sor bo, “Gel Kristus we Lol Deus we ye ssor?” ");
INSERT INTO uli_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus sa sor bo, “Ngo Ngang. Iwe ngo pangami ngo ha bele wiri mala Layur Retalop le be maro rela gilemra irel yeramtala ye Hartal Tagiyet ngo habe wol wiri le yebe budoh mo lal laeng luwul darmi!” ");
INSERT INTO uli_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Llulupal Temarong we sa hatawsi molwe mengagul ngo sa sor bo, “Tayor pelal le yarmat rebe chil budoh bo rebe ffaeg derel! ");
INSERT INTO uli_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hasa rongrong hapatpat tayikof kowe yesa sor loh irel Deus. Ila ngo meda mele habe sor irel?” Resa rol ppil fengal panger ngo resa sor bo: Iy mele ye tabung. Ila sibe llimeseloh. ");
INSERT INTO uli_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sa chaep yar tot rechokwe gutdah uwol Jesus ngo resa dugmi molwe metal ngo resa lliy. Ngo resa sor bo, “Sor hare itey mele ye llug?” Iwe ngo pos kowe resa hasi resa pigri fedaley. ");
INSERT INTO uli_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ye chil mel Pedrus lal yoror we ngo sa budoh semal lefechig kowe yael Llulupal Temarong we boy lengchel. ");
INSERT INTO uli_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yodwe yela wiri Pedrus we ye rerangi ngo sa hafeda hamaiyu ngo sa kangalu bo, “Wol gel semal rechokwe ho mel irel Jesusel Nazareth we.” ");
INSERT INTO uli_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Iwe ngo Pedrus sa kacheprar le ye sor bo, “Itugla yeramtala, ngo itugla fael mekla ho sosor.” Pedrus sa buyoy mo lal yalepalwey hatemal yoror we. Irel yodla chog ngo sa kkogo moal mael. ");
INSERT INTO uli_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Boy we sa wol la wiri Pedrus ngo sa kangalur rechokwe re susu fedal bo, “Semal rechokwe ilay!” ");
INSERT INTO uli_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Iwe ngo Pedrus sa wol sor bo, “Te ngang.” Te sulay mo wol miril ngo semal rechokwe re su lobowe yesa wol kangal Pedrus bo, “Towe yoh le hobe sor bo te gel semal ir bo gel semal re Galilee.” ");
INSERT INTO uli_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedrus sa sor bo, “Iy bele hatugulu mo fael metal Deus le ye katos meka isosor. Deus be hageryey hare te katos meka iy sosor. Itugla yeramtala ha kekapta kaptal!” ");
INSERT INTO uli_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Irel yodwe chog ngo sa kkogo harwowel mael ngo sa mmang ngal Pedrus molwe Jesus ye kangalu we ye sor bo, “Imol mala be kkogo harwowel mael ngo yebe fael suluw le hobe sor bo ho toglayey.” Yesa kkel bbargel lal depel Pedrus ngo yesa tang. ");
INSERT INTO uli_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lemaguyog chog ngo tamol temarong kowe mo mal kowe yar mo mokawe sensel Hatobtob we mo panger loh chol Ttey we resa hanngeta yar ttey bo rebe gola mele rebe foru. Resa chena Jesus resa palaloh irel Pilatus. ");
INSERT INTO uli_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus sa kasiya bo, “Gel mele king we yar Jews?” Iwe ngo Jesus sa kangalu bo, “Gel mele ho sor.” ");
INSERT INTO uli_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ye cholop mekla tamol temarong kowe re sor le derel Jesus. ");
INSERT INTO uli_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Iwe Pilatus sa wol kasiya le ye sor bo, “Kemahoy lepal mekla yarmat re sosor le derem, tor mele hobe sor iyang?” ");
INSERT INTO uli_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ye lluwdah Pilatus irel molwe Jesus ye tay mechal sor sepad hapatpat. ");
INSERT INTO uli_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pangal yal ma hola molwe Bungul Paska ngo Pilatus yema toa hachuya semal mo lal kalbus le yarmat cholop rebe dangro. ");
INSERT INTO uli_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Irel yodle ngo ye mel semal mal le Barabbas idal mo luwulur chol kalbus kowe le ye daber rechokwe re fedeg ngal Am. Luwul wahaha we ngo ye llimeseloh semal yarmat. ");
INSERT INTO uli_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Rela ttey fengal buwa we ngo resa dangro Pilatus molwe yema faesul foru. ");
INSERT INTO uli_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Iwe Pilatus sa kasiyar bo, “Ha dipli bo ibe taldi king le yar Jews?” ");
INSERT INTO uli_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatus ye faesul gola le tamol temarong kowe re hasidoh Jesus irel le fael yar loltomay irel. ");
INSERT INTO uli_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Iwe ngo tamol temarong kowe resa hakkela ngalir chog yarmat bo rebe kangalu Pilatus le Barabbas mele yebe taldi. ");
INSERT INTO uli_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iwe ngo Pilatus sa wol maliliy ngalir buwa we le ye sor bo, “Meda mele ha dipli le iy be faor ngal yeramtale ha sor bo yar Jews king?” ");
INSERT INTO uli_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Resa tawulagli le re sor bo, “Ha krudu!” ");
INSERT INTO uli_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus sa kasiyar bo, “Meda tayikof le yeramtale sa foru?” Iwe ngo resa hapalingi tot yar tawulagli le re sor bo, “Ha krudu!” ");
INSERT INTO uli_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus ye dipli le yebe hafle deper buwa we iwe sa taldi Barabbas ngo sa sor bo rebe wwodu Jesus ngo resa hasiloh bo re bela krudu. ");
INSERT INTO uli_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Saldaw kowe resa hasilong Jesus lal yororol imw we imwel tamol Aam we ngo resa rol ttey fengal mo panger saldaw kowe choluwar. ");
INSERT INTO uli_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Resa hamengagu ngal sew mengagucha ngo resa ffaor marel ral ire we yor chil iwe resa hamarmare ngali. ");
INSERT INTO uli_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Iwe resa budoh hasorol tamol ngali ngo resa sor bo, “Yebe sulay King le yar Jews!” ");
INSERT INTO uli_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Resa wwodu molwe chemal ngal setab ire ngo re gutdah uwol ngo resa hasubgudiy resa cchem ngali. ");
INSERT INTO uli_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yodwe rela mol irel yar tapeli fedaley kamemal ngo resa hachuya mengagucha we re hamengagu ngali resa hatefaelidah molwe faesul mengagol uwol. Iwe resa paliloh bo re bela krudu. ");
INSERT INTO uli_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yodwe re loloh ngo re sala chungu semal mal le Simon idal le ye budoh mo solbos sa bubulong lal haplom we. Iwe ngo saldaw kowe resa ddingi ngali bo yebe hasi krud we yael Jesus. (Simon ila semal yeramtal Cyrene ngo iy mele temal Alexander mo Rufus.) ");
INSERT INTO uli_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Resa paliloh Jesus irel loboswe rema sor bo Golgotha, le fael mele ila “Liliyel Pol Fusug”. ");
INSERT INTO uli_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","La lobole ngo resa fang lemel Jesus wine le resa peda ngal samat tafey le rema sor bo myrrh ngo Jesus ye temechal yul. ");
INSERT INTO uli_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Iwe resa krudu ngo resa hamahla mokwe mengagol uwor wol miril yar sulbeli hare mengag kefa mele semal mo semal ir yebe hasi. ");
INSERT INTO uli_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Re krudu irel molwe sa duwow kolok lemaliyel. ");
INSERT INTO uli_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ye teftaf fael yar krudu le ye sor bo, “King we yar Jews.” ");
INSERT INTO uli_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Re wol krudu rumal chotayikof mo lengchel Jesus le semal mo rela gilemra ngo semal mo rela gilchegil. ");
INSERT INTO uli_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Ila sala lahloh le tos molwe Babior we ye Santus ye sor, “Yesa chilag ngalir chotayikof irel hagerger kala yar.”) ");
INSERT INTO uli_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Rechokla re dedarloh lengchel lobowe ila rema yuchgaloh chemer ngo resa hapatpat tayikof loh irel Jesus le rema sor bo, “Yuu! Gel molwe ho sor bo hobe hatawsi Templum we ngo bela solral ngo sa mol yam hasu tefaeli! ");
INSERT INTO uli_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ila, bidiy mo woal krud la bo hode mes!” ");
INSERT INTO uli_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ye wol ila senger tamol temarong kowe mo mokwe sensel Hatobtob we bo re tape Jesus kamemal le rema sor bo, “Ye yoh ngali le yebe hamolowar yarmat ngo ye teyoh le be hamolowa iy llufulyal! ");
INSERT INTO uli_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Siya kemahoy Kristus le yar re Israel King, le hare be bidiy mo wol krud la igla, ila ngo sibe chepar ngali!” Wol ila senger rechokwe rumal we re krud sew mo Jesus bo ye wol tayikof yar hapatpat ngali. ");
INSERT INTO uli_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yodwe yela wwel yaal ngo sa ruchupung loh wulfuluy le suluw awa sulayel. ");
INSERT INTO uli_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Molwe yela suluw kolok ngo Jesus sa tawulagliloh le ye sor bo, “Eloi, Eloi, lema sabachthani?” Fael mele ila ye sor bo, “Yai Deus, yai Deus, meda mele hosa ttahcheyey loh iyang?” ");
INSERT INTO uli_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tot rechokwe re mel lobos we re rongrong yalol Jesus ngo resa sor bo, “Ha talenga, yesa fefesangu Elijah!” ");
INSERT INTO uli_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sa hamdaloh semal mo irer le ye hasi sedep forwa le yesa chiri ngal wine kowe ye mwall sa fodadah wol setab ire sa hadingadah irel molwe yewal Jesus ngo sa sor bo, “Ha widyey sibe kemahoy hare Elijah be bidiy be hachuya mo wol krud le!” ");
INSERT INTO uli_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus ye ttawul loh ngo sa chuyloh yal ngas. ");
INSERT INTO uli_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iwe ngo sa ssahagloh mengag we ye hopa Templum we sala rudep mo iyang. ");
INSERT INTO uli_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tamol saldaw we ye su mo imol krud we ye wiri yael Jesus mes. Iwe ngo sa sor bo, “Tosol bo mal le ila Lol Deus!” ");
INSERT INTO uli_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yor tot fefel le re kekaladoh mo medaw. Luwelur fefel kowe ngo ye mel Mary Magdalene mo Salome mo Mary, we sil James we miril yarmat ngo wol sil Joses. ");
INSERT INTO uli_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ye chaep chog yar dabey Jesus irel yodwe ye chil mel wol Galilee iwe ngo rema kekamale fedaley. Ye cholop fefel kala re dabedoh wol Jerusalem le re mel lobowe. ");
INSERT INTO uli_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yodwe sa pal loh yaal ngo sa dohdoh Josephel Arimathea we. Iy ila semal chol Ttey we ngo ye ssor fael yal yengang. Joseph ye chil wiwidi yodla be budoh mala Lamliyel Deus iyang. Rallale ila rael yar Hafelfel (mele ila rallawe bele chaep Sabbath). Sa yedamgel Joseph sala dangoro Pilatus molwe porgol Jesus bo yebe hasi. ");
INSERT INTO uli_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ye lluwdah Pilatus irel molwe yela rongrong bo sa mes Jesus. Iwe sa ffesangu tamol saldaw we sa kasiya hare sa sulay yal mes Jesus. ");
INSERT INTO uli_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","La wol miril molwe Pilatus sa rongrong mokwe tamol saldaw we ye kangalu, ngo sa moch kangalu Joseph bo bela hasi molwe porgol Jesus. ");
INSERT INTO uli_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iwe Joseph sala chuwayi sew mengag ngo sa hachuyadiy Jesus mo woal krud ngo sa hasi mengag we sa dugmi ngali. Yesa hasi molwe porgol Jesus yesa yetolong lal sew pey le ye kil long mo wolpegil sew hohyal. Iwe sa hatapuludoh sew porow le ye palleng sa pelta ngal hatmal pey we. ");
INSERT INTO uli_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene mo Mary we sil Joses re kekemahoy re sala gola loboswe ye mel molwe porgol Jesus iyang. ");
INSERT INTO uli_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","La wol miril Sabbath ngo Mary Magdalene, Salome mo Mary we sil James re sala chuway loy bo re bela chalfi ngal molwe porgol Jesus. ");
INSERT INTO uli_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lemaliyelel ralawe Sunday irel yodwe ye moch tehach yaal ngo resa loh irel pey we. ");
INSERT INTO uli_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Yodwe re loloh ngo resa kekasiy fengal le re sor bo, “Itey le bela hatapulu ngalgich peltal pey we?” (Sew porow le hasfalu mala lepal.) Iwe rela kalloh re sala wiri porow we le sa faesul tapol tang hatmal pey we. ");
INSERT INTO uli_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Rela bulong lal pey we ngo re sala wiri semal tarmal le ye maroro rela gilemra irer le ye mengag irel sew mengag le ye bech, iwe ngo sa budoh yar motog. ");
INSERT INTO uli_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Iwe yesa kangalur bo, “Ha towe motog! Igula le hami ha memeri Jesusel Nazareth we re krudu. Ye taymel iga bo yesa molow tefael mo irel maes! Ha kalloh, iga loboswe re itol iyang. ");
INSERT INTO uli_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ha loh ha bela kangalur mokwe re dabeyal mo Pedrus hapatpat le: ‘Ye bele hamoloh mo imomi wol Galilee, ngo ila lobosla ha bela wiri mo iyang le sa faesul kangalugmi.’” ");
INSERT INTO uli_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iwe resa buyoy mo lal pey we, resa ddar le sa ccheloh ngulur ngo re motog. Ngo tor mele re kangalur yarmat bo resa rusmes. ");
INSERT INTO uli_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Lemaliyelel Sunday mo wol miril yael Jesus molow tefael mo irel maes ngo ye mwoal llah ngal Mary Magdalene we iy Jesus ye hachuya moniyan kowe fismol mo uwol. ");
INSERT INTO uli_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yesa loh sala kangalur mokwe chilal le re tetang luwul tayikofel lal deper. ");
INSERT INTO uli_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yodwe rela rongrong we Mary Magdalene ye sor bo ye wiri Jesus le yesa molow tefael ngo rete chepar ngali. ");
INSERT INTO uli_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","La wol miril mele ngo Jesus sa llah ngal rumal mokwe re dabeyal ngo ye semat igegel yal llah ngalir irel yodwe re dedarloh luwul fuluy. ");
INSERT INTO uli_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Rela tefael le rela kangalur ikowe sibis ngo rete chepar iyang. ");
INSERT INTO uli_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yela wol miril loh ngo Jesus sa llah ngalir mokwe re dabeyal we seg mo semal irel yodwe re momongoy iyang. Iwe ngo yesa kaftoroy ngalir bo tay luglug lal deper irel mokwe ye kangalur. Ye mmay mekla repiyer bo rete chepar ngalir rechokwe resa wiri Jesus le sa molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iwe sa kangalur bo, “Ha roloh lal faileng le bo ha bela foloyu Ebangelium le ngalir panger yarmat. ");
INSERT INTO uli_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Semal le yebe chepar ngo yebe baptismus ngo yebe daor. Ngo semal le yebe te chepar ngo rebe hagre. ");
INSERT INTO uli_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Rechokla resa chepar ila sa yor kkaler le yebe llah mo irel yar bele hachuchuy moniyan le irel mele idey ngo re bele gola yalol sew mo sew laam. ");
INSERT INTO uli_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Iwe ngo haramwo re holu parchoyoh ka hare re mongoy suup ngo tor mele rebe foru. Iwe ngo rebe yetedah payur uwor chotomay ngo yebe chuy yar tomway.” ");
INSERT INTO uli_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wol miril yael Jesus hapatpat ngalir ngo yesa loh woal laeng sala mel rela gilemra irel Deus. ");
INSERT INTO uli_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iwe ngo mokwe re dabeyel Jesus resa loh re sala foloy fedal pangal lobos ngo Samol ma tipingir bo yebe tugul le foloy kala yar ila ye katos le ye lah mo irel kkemal kala re foforu. IYE MELE HARWOWEL HAYGUGUL LOH EBANGELIUM LE Fefel kowe resa loh irel Pedrus mo mokwe wol marerel re sala kangalur pangal loh mokwe resa rongrong. Yela wol miril mele ngo spegil iy Jesus sa fang ngalir mokwe re dabeyal pedal hapatpat la ye santus le kaptal molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ssarolwom ho Theophilus: Ye cholop yarmat le resa yedamgili bo rebe tefadiy ragregel mekla sa weldoh luwulmem le sa tugul depmem iyang. ");
INSERT INTO uli_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Re tefadiy lal babior mekla siya rongrong mo irer rechokla re mol wiri meka ngo re foloyu mekla kaptal. ");
INSERT INTO uli_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ssarolwom ho Theophilus, isa cchiy hamayu pangal meka mo irel mala chapdageldah ngo isa luluwaley bo ye momay le ibe tefadiy ragregel meka bo yiglug. ");
INSERT INTO uli_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ibele foru mele bo hobe gola mala tosol kofal pangal mokwe resa foloyu ngalug. ");
INSERT INTO uli_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wolmol Yerodes we kingel Judea ngo ye mel semal temarong le Zechariah mala idal le ye budoh mo irel rel halengel temarong we yael Abijah. Fefel la ril ila Elizabeth mala idal; ila ye budoh mo irel haleng we yael Aaron we sew halengel temarong. ");
INSERT INTO uli_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Rorumal ngo ye fel yar popoa sew mo fael metal Deus ngo re talenga pangal hatobtob kowe yael Samol mo foloy kowe yal. ");
INSERT INTO uli_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tor layur yalwich bo ye teyoh le ye siyal Elizabeth, ngo igla ila ir rorumal ngo resa malelap mo yulolap. ");
INSERT INTO uli_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Irel yodwe rel halengel temarong we yael Abijah mele re yengang ngo Zechariah ye foforu yengang kowe temarong rema foru lal Templume we. ");
INSERT INTO uli_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yodle ngo sa tugul le Zechariah mele yebe hagsu incense we wol altar we. Iwe yesa bulong lal Templum we yael Samol. ");
INSERT INTO uli_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Irel yodwe sa gus incense we ngo yarmat re ttey le re memapelmo merawayel loboswe ye mel Altar we rema fifis incense uwol. ");
INSERT INTO uli_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Semal angelusel Samol yesa llah ngali le ye su mo rela gilemra irel altar we. ");
INSERT INTO uli_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Yodwe Zechariah ye wiri ngo yesa lluwdah ngo sa budoh yal motog. ");
INSERT INTO uli_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Iwe ngo angelus we sa kangalu bo, “Ho towe motog ho Zechariah! Deus yesa rongrong yalol mapel we yam, ila ngo Elizabeth we rim ye bele siylagili semal yalwich mal. Iwe ngo hobe hadeda bo Johannes. ");
INSERT INTO uli_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yebe kkel yam raey mo cchehas ngo ye wol cholop rechokla yebe kkel yar raey irel yodla yebe subdoh iyang. ");
INSERT INTO uli_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yebe mel le semal mal le ye tagiyet mo fael metal Samol. Ye towe ma yul wine hare hachi ka ye kkel. Ye bela subdoh chog ngo ye mel Espritu Santus uwol. ");
INSERT INTO uli_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iwe ngo ye cholop yeramtal Israel le bele hatefalir ngal Samol le yar Deus. ");
INSERT INTO uli_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ye bele hamo mo imol Samol le yebe kkel, ngo ye kkemal le yebe wochog profeta Elijah. Ye bele wol hatefali fengalir temtam mo loaloy; ngo ye wol hatefalir yarmat ngal yalap la ye fel; ngo ye hafle ngal Samol mekla lol.” ");
INSERT INTO uli_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah sa kangal angelus we bo, “Be ifa sengal ngo isa gola le yebe yoh mekla ho sosor? Ngang ila isa malelap ngo mala riy ila sa wol yulolap.” ");
INSERT INTO uli_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angelus we yesa sor bo, “Ngang Gabriel. Ima su fael metal Deus, le iy mele ye fangdoh ngang bo ibe kangalug hapatpat momay le. ");
INSERT INTO uli_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Iwe ngo gel ho ted chepar irel meka ikangalug. Iwe ngo bela hola mala yodol ngo bele llah le ye katos meka ikangalug. Ila towol mmal le hobe hapatpat le fal mala ho te chepar irel meka iy sa kangalug. Ho bele paoy le towol mmal le hobe hapatpat yee la hola yodla ihatugulu ngalug bo be llah le ye katos meka iy kangalug.” ");
INSERT INTO uli_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chowe re wiwidi Zechariah resa luluwaley hare meda mele sa sulay lal Templum we iyang. ");
INSERT INTO uli_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yodwe yela buyoy ngo tay mmal le yebe hapatpat. Iwe chog ngo resa gola le Samol yesa llah ngali mo lal Templum we. Tor sepad hapatpat le ye mmal le yebe kangalur. Iwe yesa pongpong ngalir chog. ");
INSERT INTO uli_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yela haw bungul yal yengang mo lal Templum we ngo Zechariah sa tefael loh lubugtal. ");
INSERT INTO uli_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yela wol miril ngo yesa siyal molwe ril, iwe ngo lemow meram le ye mel chog irel imw we imwer. ");
INSERT INTO uli_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iwe ngo yesa sor bo, “Igala ila Samol yesa holbuwayey bo yesa hachuyaloh maa we yai!” ");
INSERT INTO uli_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Yela wolow meram yael Elizabeth siyal ngo Deus yesa fangdiy angelus we Gabriel irel sew haplom woal Galilee le Nazareth mala idal. ");
INSERT INTO uli_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Angelus we ye hasidoh sew hapatpat irel semal lefechig le Maria idal. Maria ila resa faesul kapta mo semal mal le Joseph idal bo rebe ppao fengal. Joseph ila ye budoh mo irel daowe yael King David. ");
INSERT INTO uli_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yesa budoh angelus we irel lefechig we ngo yesa kangalu bo, “Ha rrayi lal depom! Samol ye mel irem ngo yesa holbuwah mo luwulur fefel!” ");
INSERT INTO uli_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Iwe sala weres loh lal depel Maria irel mokwe yalol angelus we ngo yesa luluwaley loh chog hare meda fael mokwe yalol angelus we ngali. ");
INSERT INTO uli_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Iwe angelus we yesa kangalu bo, “Maria, ho towe motog. Ye fel depel Deus irem. ");
INSERT INTO uli_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ho bele siyal le hobe dimolwagili semal yalwich mal. Iwe ngo hobe hadeda bo Jesus. ");
INSERT INTO uli_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yebe tagiyet ngo rebe ffesangu le iy Lol Deus we ye Hartal Tagiyet. Samol Deus ye bele foru le be mel bo semal king, le be wochog David we yal chaep, ");
INSERT INTO uli_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ngo ye bele mel le kingel haleng we yael Jacob le towe yor siyal ngo mala lamliyal ila tor yugul!” ");
INSERT INTO uli_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria sa kangalu angelus we bo, “Ngang semal birgo. Be ifa sengal chog ngo sala mmal mala ho sosor?” ");
INSERT INTO uli_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelus we sa kangalu bo, “Be bidiy Espritu Santus uwom ngo mala kamalal Deus be mel uwom. Ila fal yalwich le ye santus le rebe ffesangu bo Lol Deus. ");
INSERT INTO uli_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Luluwaley Elizabeth we chol bugtam. Iwe re sor bo towe yoh le yebe loloy ngo yela igla le sa yulolap ngo sa wolow mermal yal siyal. ");
INSERT INTO uli_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bo tor mele towe yoh ngal Deus le yebe foru.” ");
INSERT INTO uli_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iwe ngo Maria sa sor bo, “Ngang re haforol yalol Samol. Ligdi bo yebe faor ngaliyey le be wochog ikala hosa sor.” Iwe ngo angelus we sa ligdi Maria ye sa loh. ");
INSERT INTO uli_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yela wol miril ngo Maria sa hamallo fedaley ngo yesa yesa loh le ye nngat wol sew haplom le ye meldah wol tayit mo wol Judea. ");
INSERT INTO uli_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yela bulong lal imw we imwel Zechariah re sala wer fengal mo Elizabeth. ");
INSERT INTO uli_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yodwe Elizabeth ye rongrong chog lliyalol Maria ngo yesa mmagud yalwich we mo lal siyal. Iwe ngo yesa bidiy Espritu Santus uwol Elizabeth. ");
INSERT INTO uli_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ngo yesa tawulagliloh le ye sor bo, “Ho hartal yolbuw mo luwur panger fefel ngo yebe wol yolbuw yalwich la ho bele dimolowagili! ");
INSERT INTO uli_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Meda mele sala wel ngaliyey mele iyang. Meda mele sil Samol la yai sala budoh tefael mo irey iyang? ");
INSERT INTO uli_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yodwe chog iy rongrong lliyalom ngo sa mmagud yalwich le mo lal mele siyey irel yal raey. ");
INSERT INTO uli_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ifa lepal yam raey le yela tugul lal depom le mala yalol Samol ngalug ila ye bele llah le ye katos!” ");
INSERT INTO uli_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria ye sor bo, “Mele buley ila ye kapingpinga Samol; ");
INSERT INTO uli_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","sa momay depel mele nguluy bo fael Deus le yai Demer, ");
INSERT INTO uli_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","bo ye chil luluwaleyey chog le ngang re haforol yalol le iy totol! Bele chaep igla sa loh le pangal yarmat ngo re bele ffesanguyey bo iraey, ");
INSERT INTO uli_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","le fal mekla ye paleng fal le Deus le ye Hartal Tagiyet sa foru ngalyey: Ye santus mala idal; ");
INSERT INTO uli_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pangal yad ngo ye kaweraloh ffahol ladep la yal ngalir rechoka rema hasrowu. ");
INSERT INTO uli_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yesa kaweraloh mala kkelal ngo ye hataropropa yar luluwal rechokla re hattodah. ");
INSERT INTO uli_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yesa hatetalordiy King kala re tagiyet mo wol mekla liliyer ngo ye hatagitardah rechoka re totol. ");
INSERT INTO uli_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yesa fang ngalir rechokla re hafohoy pangal mekla ye momay, ");
INSERT INTO uli_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ngo yesa ddaberloh rechoka re mmal le tor mele ye fang ngalir. Ye yitli chog liliyel molwe ye hatugulu ngalir chapdoh kowe yach. ");
INSERT INTO uli_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yesa budoh tipingi Israel we yal re hagoloy. Ye luluwaley chog le yebe kkewar ngal Abraham mo panger chol daowe yal ffahol ladep la tor siyal!” ");
INSERT INTO uli_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malbo be suluw meram yal mel Maria irel Elizabeth ngo yesa moch tefael ngal bugtal. ");
INSERT INTO uli_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yela hola yodwe yebe molow Elizabeth iyang ngo ye dimolowagili semal yalwich mal. ");
INSERT INTO uli_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mekla yeramtal mo rechokla re harpa resa rongrong molwe ye kamdidiy we Samol yesa faor ngali Elizabeth. Iwe ngo panger fengal mo Elizabeth ngo yesa raey lal deper. ");
INSERT INTO uli_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yela haw bungul yalwich we ngo resa budoh bo rebe hagilla ngo re hadeda ngal Zechariah we idel molwe temal. ");
INSERT INTO uli_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Iwe ngo molwe sil sa sor bo, “Yeab! Mala idal ila be mel bo Johannes.” ");
INSERT INTO uli_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iwe ngo resa kangalu bo, “Iwe ngo ifa sengal mala tor semal yeramtam le ila sengal idal!” ");
INSERT INTO uli_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Iwe resa pongpong ngal Zechariah hare ifa sew yid le ye dipli bo yebe hadeda ngali yalwich we. ");
INSERT INTO uli_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah yesa dongor sew mokwe rema teftaf uwol ngo yesa tefadiy bo Johannes mele idal. Pangerloh ngo re lluwdah irel molwe. ");
INSERT INTO uli_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Irel chog yodle ngo Zechariah sa mmal le yebe kaptapat. Iwe ngo yesa chaep yal hapingpinga Deus. ");
INSERT INTO uli_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pangaer rechokwe re tteydoh ngo sa budoh yar motog. Iwe ngo sa palengloh kaptal meka mo wol pangal loh lobowle mo wol Judea. ");
INSERT INTO uli_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Panger rechokwe re rongrong kaptal molwe ngo resa luluwaley long lal deper ngo resa kasiy bo, “Be ifa sengal yalwich le wagey? Yesa lleloh le ye mel mala kkelel Samol uwol.” ");
INSERT INTO uli_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espritu Santus yesa bidiy woal Zechariah we temal Johannes. Iwe Zechariah yesa kaptaloh mokwe yalol Deus: ");
INSERT INTO uli_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Siya hapingpinga Samol Deus we yar re Israel! Yesa budoh bo be tipingir ngo ye hataldagir mekla lol. ");
INSERT INTO uli_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yesa hayaho ngalgich Demer we ye tagiyet le ye budoh mo irel daowe yael David we yal re hagoloy. ");
INSERT INTO uli_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Muswe chog ngo yesa hatugulu ngalgich mo irer profeta kowe lol we re santus, ");
INSERT INTO uli_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","le iy yebe hadoragich mo irer rechoka re hatodah ngalgich ngo ye taldigich mo irer rechoka re hafobidirigich. ");
INSERT INTO uli_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ye sor bo yebe kaweraloh ffahol ladep la yal ngalir chapdoh kowe yach. Iwe ngo ye mel chog lal le yebe foru mokwe ye mel lal bogtag we yal ngalgich we ye santus. ");
INSERT INTO uli_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ye hatosiya ngal Abraham we yach chapdoh le yesa hatugulu le yebe hafaligich mo irer rechokla re hattohar ngalgich. Iwe ngo ye taldigich bo sibe foru mekla yalol le si towe motog, ");
INSERT INTO uli_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","bo si bela mel le sibe santus ngo si fel mo fael metal irel yodle si molow iyang. ");
INSERT INTO uli_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Gel layi, re bele ffesangug le gel semal profeta le lol Deus we ye Hartal Tagiyet. Ho bele hamo mo imol Samol bo ho bela hafle mala yalepal, ");
INSERT INTO uli_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ngo hobe kangalur mokwe lol bo ir ila re bele daor bo ye bele hachuya molfidir. ");
INSERT INTO uli_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Deus le yach ila ye malulu ngo ye ffaho depal. Ye bele fang ngalgich termal molow, ");
INSERT INTO uli_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","le ye bele werdiy mo wol laeng le yebe werloh uwor rechokla re mel luwul rochopung ngo resa harpal mes bo yebe maldi yalap la yebe hasgichloh luwul falmay.” ");
INSERT INTO uli_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yela doh yalwich we ngo ye kkel ngo ye fel depel Deus irel, ngo yema mel fedal chog loboka ye tolmay loh yee la hola yodwe ye budoh irer re Israel. ");
INSERT INTO uli_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Irel yodla ngo Llulupal Tamol we Augustus sa fangloh yalol bo rebe pangir panger yarmat wol balel loh mekla faluyel Roma. ");
INSERT INTO uli_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mele metamol yar bele papa yarmat ngo Quirinius mele Aam woal Syria. ");
INSERT INTO uli_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sa semal ngo ye loh wol haplomol bo be la tefadiy idal lal babior. ");
INSERT INTO uli_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sa chuy Joseph mo Nazareth we ye mel wol Galilee, sa loh irel haplom we Bethlehem we ye mel woal Judea irel lobos we ye sub David mo iyang. Ye loh Joseph woal Bethlehem bo iy semal chol daowe yael David. ");
INSERT INTO uli_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Resa loh bo re bela tefadiy ider lal babior mo Maria we resa hatugulu bo re bele paoy fengal. Irel yodle ngo sa siyal Maria. ");
INSERT INTO uli_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Rela mel woal Bethlehem ngo sa hola yodwe ye bele dimolow iyang. ");
INSERT INTO uli_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yela dimolowagili mala metamol lol ngo semal mal, resa dugmi ngal mengag resa holadi lal sew mokwe liliyel hal mael bo tayor liliyer irel imw we imwer wasola. ");
INSERT INTO uli_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ye mel tot chol matmetal mael mo halugloh llubungul ralale le re mat ngalir mael kala layur. ");
INSERT INTO uli_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iwe ngo semal angelusul Samol yesa llah ngalir ngo yesa tarmaegdiy falmay la yael Samol uwor. Iwe ngo yesa kkel yar motog. ");
INSERT INTO uli_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angelus we sa kangalur bo, “Ha towe motog! Isa hasidoh sew hapatpat momay ngalugmi le be raey depel pangal yarmat iyang. ");
INSERT INTO uli_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Igla mele ye sub Demer we yami mo woal molwe haplomol David — Kristus we Samol! ");
INSERT INTO uli_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iye mele hagilal ngalugmi. Habe loh ngo habe wiri semal yalwich le ye dudug ngal mengag ngo ye yol lal sew mokwe liliyel hal mael.” ");
INSERT INTO uli_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Re tedap loh chog ngo sa ssogloh lal laeng irel sew pulgul angelus le resa chila angelus we semal le resa kekapingpinga Deus luwul yar toton le re sor bo: ");
INSERT INTO uli_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Habe hasrowug ho Deus le ho mel wol laeng le ho Hartal Tagiyet, ngo hopos wol talop ngalir rechokla ye fel depel Deus ngalir!” ");
INSERT INTO uli_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yodwe resa tefael loh angelus kowe wol laeng ngo chol matmetal mael kowe resa kapta fengali bo, “Siya roloh Bethlehem si bela kemahoy molwe sa weldoh we Samol sa kangalgich.” ");
INSERT INTO uli_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iwe resa hattirirloh re sala wiri Maria mo Joseph ngo re wiri yalwich we le ye yol lal sew mokwe liliyel hal mael. ");
INSERT INTO uli_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yodwe chol matmetal saaf kowe rela wiri yalwich we ngo resa kangalu Maria mo Joseph mokwe angelus we ye kangalur irel kofal yalwich we. ");
INSERT INTO uli_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Panger rechokwe re rongrong mokwe chol matmetal saaf kowe re sor ngo re lluwdah iyang. ");
INSERT INTO uli_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria ye memangi pangal meka ngo ye kkel yal luluwalelong chog lal depal. ");
INSERT INTO uli_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Resa tefael loh chol matmetal mael kowe re toton le re kapingpinga Deus irel pangal mokwe re rongrong ngo resa wiri ngal meter le tappel chog mokwe angelus we ye kangalur. ");
INSERT INTO uli_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yela sew week mo wol miril ngo sa hola yodwe re bele hagilla yalwich we. Iwe resa hadeda ngali bo Jesus le ila yidwe angelus we ye kangal Maria mo imol yodwe yebe siyal. ");
INSERT INTO uli_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yela hola yodwe Joseph mo Maria re bele la foru maligach we be hachuya tab mo uwor le be wochog molwe Moses ye sor irel Hatobtob we yal, ngo re wol hasiloh yalwich we wol Jerusalem bo re bela fang ngal Samol. ");
INSERT INTO uli_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ye teftaf lal babiorol hatobtob we yael Samol le ye sor bo, “Yalwich mal le be subdoh ngo habe fang ngal Samol, ngo metamol lomi mal le be subdoh mal ngo habe wol fang ngal Samol.” ");
INSERT INTO uli_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Re wol loh bo re bela fang yar maligach le be rumal doves, hare rumal pigeons kowe chil ppachigchig bo ila mele hatobtob we yael Samol ye sor. ");
INSERT INTO uli_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Irel yodla ngo ye mel semal mal le ma mel Jerusalem le Simeon mala idal. Iy semal mal repiy ngo ye hasrowu Deus. Iwe ngo iy ye wiwidi yodla rebe daor re Israel iyang. Iwe ngo ye mel mala kkamlal Espritu Santus uwol, ");
INSERT INTO uli_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ngo ye hatugulu ngali le towe pagel mes ngo sa wiri Kristus we Samol ye hatugulu bo yebe fangdiy. ");
INSERT INTO uli_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espritu Santus yesa hakkela lal depel Simeon bo yebe loh lal Templum we. Yodwe Joseph mo Maria rela hasidoh Jesus lal Templum we bo rebe faor ngali mokwe Hatobtob we ye sor, ");
INSERT INTO uli_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ngo Simeon sa holulong yalwich we llomolal ngo sa kangalu Deus yal hachigchig le ye sor bo: ");
INSERT INTO uli_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Samol, hosa foru igla molwe ho faesul hatugulu, hole fang mele re haforol yalom bo yebe loh luwul hopos. ");
INSERT INTO uli_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Isa spegil wiri ngal metay Demer we hosa fang, ");
INSERT INTO uli_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ngo hosa hafle bo pangal yarmat ngo rebe wiri: ");
INSERT INTO uli_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","sew teram le yebe kaweraloh mala depom ngalir Gentiles ngo ye hasidoh falmay la yam ngalir yeramtal Israel kowe lom.” ");
INSERT INTO uli_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ye lluwdah molwe sil mo molwe temal yalwich we irel mokwe Simeon ye sor we kofal yalwich we. ");
INSERT INTO uli_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon yesa mapelar ngo yesa kangal Maria we sil Jesus bo, “Yalwich le ila Deus yesa duweley yebe rebe taroprorloh sibis ngo ye hadorar sibis wol Israel. Ye bele mel le sew hagil mo irel Deus le yecholop yarmat le rebe hattohar ngali. ");
INSERT INTO uli_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ngo iy ye bele hallehaloh mekla deper le ye mwol. Bbaregel lal depom ila yebe wochog sew sayden kowe ye kkang ngo yebe hatawsi mala bullom.” ");
INSERT INTO uli_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ye mel semal profeta fefel le sa yulolap le Anna idal le sa mes mala ril. Iy lol Phanuel we yeramtal haleng we yael Asher. Ye hal fisuw raeg yal riri ngo yesa mes mala ril ngo yela yodle ngo sa walig mo faw lepal ragel. Tor fael sew le ye ligdi Templum we. Llobong mo llerael ngo yema kekasrowu Deus irel yal ma mapel mo yal ma supiy hal. ");
INSERT INTO uli_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Irel chog yodle ngo yesa budoh sa kangal Deus yal hachigchig ngo ye kapta kofal yalwich we ngalir panger rechokwe re wiwidi Deus bo be taldir yeramtal Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yodwe Maria mo Joseph rela hamallo pangal mokwe hatobtob we yael Samol ye sor bo rebe foru ngo resa tefael ngal Nazareth we haplomor we ye mel woal Galilee. ");
INSERT INTO uli_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yela doh yalwich we le ye kkel ngo ye toayal ngo ye fel depel Deus irel. ");
INSERT INTO uli_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pangal raeg ngo mokwe wulutugul Jesus rema loh Jerusalem re bela dabey molwe Bungul Paska. ");
INSERT INTO uli_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yodwe sa seg mo ruwow lepal ragel Jesus ngo resa loh re bela dabey molwe Bungul Paska we rema faesul loh iyang. ");
INSERT INTO uli_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yodwe yela mol bong we ngo resa tetefael loh lubugter, ngo Jesus ye mel tefael woal Jerusalem ngo mokwe wulutugul re togla; ");
INSERT INTO uli_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","re kachog hare ye dedabey doh mokwe choluwar. Yela seral lluyloh yar loloh ngo sa moch chaep yar memer fedaley luwulur makwe yeramter mo wol mareyarer. ");
INSERT INTO uli_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Iwe ngo re tuwiri, iwe resa wol tefael ngal Jerusalem re sala meri mo iyang. ");
INSERT INTO uli_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yela hasolralel yar meri ngo resa moch la wiri mo lal Templum we le ye maroro luwulur tot mokwe sensel Hatobtob we le ye tetalengar ngo ye wol kekadogoyur. ");
INSERT INTO uli_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Panger rechokwe re rongrong mokwe ye kekapta ngo re lluwdah irel momayel lal chemal irel kasiy kowe yal mo tefalel kasiy kala yar ngali. ");
INSERT INTO uli_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Re lluwdah mokwe wulutugul irel molwe rela wiri mo loboswe. Ngo molwe sil sa kangalu bo, “Meda mele ho sala faor ngalugmem mele iyang layi? Ngang mo mele tamom ila hasa rusmes loh chog luwul yamem memer fedaleh.” ");
INSERT INTO uli_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus sa hatefali ngalir ngo sa sor bo, “Meda mele ha memeriyey iyang? Ha togla le ngang ibe mel lal imw le imwel mala Temay?” ");
INSERT INTO uli_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iwe ngo re temedaf irel fael molwe Jesus ye kangalur. ");
INSERT INTO uli_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iwe Jesus sa daber resa tefael ngal Nazareth. Ye sala mel ngo yema talenga chog yalor irel pangal formel. Pangal meka ngo molwe sil ye holmmachulong chog lal depal. ");
INSERT INTO uli_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yela doh Jesus ngo ye repiy, ngo ye toayal, ngo ye fel depel Deus mo yarmat irel. ");
INSERT INTO uli_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yesa seg mo lemow ragel yael Tiberius mel bo Llulupal Tamol, ngo Pontius Pilate mele Aam wol Judea, ngo Yerodes mele tamol wol Galilee, ngo Philip we bisil Yerodes mele tamol wol Iturea mo Trachonitis, ngo Lysanias mele tamol Abilene, ");
INSERT INTO uli_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ngo Annas mo Caiaphas mele Llulupal Temarong. Irel yodla ngo Johannes we lol Zechariah ye mel lal sew tolmay loh ngo Deus yesa fangdoh yalol irel. ");
INSERT INTO uli_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Iwe ngo Johannes sa loh irel pangal haplom kowe lengchel Melelul Jordan sala foloy le ye sor bo, “Ha tagul tang mekla molfidmi bo habe baptismus ila ngo Deus yebe hachuya fael yami molfid.” ");
INSERT INTO uli_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ye teftaf lal babior we yael profeta Isaiah we ye sor bo: “Semal yarmat ila ye tetawul mo lobowe ye tolmaylohla le ye sor bo, ‘Ha hafle mala yalepal Samol ngo ha hawele yalap la yebe dabey! ");
INSERT INTO uli_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pangal loway ngo habe hassugudah, ngo pangal tagitat mo tayit ngo habe hafiyaloh mo wol bol. Pangal yalap kala ye chibchib fedal ngo habe foru bo yebe wwelsagloh, ngo yalap kala ye piruwruw fedal ila habe hachaliloh. ");
INSERT INTO uli_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Panger yarmat ngo re bele wiri Demer we Deus yebe fangdiy!’” ");
INSERT INTO uli_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ye cholop yarmat le resa loh irel Johannes bo yebe baptismusgilir. Iwe ngo Johannes yesa kangalur bo, “Hami parchoyoh kala! Itey le ye kangalugmi le habe kkewag tang hagerger la Deus ye bele fangdiy? ");
INSERT INTO uli_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ha foru mekla yebe halahaloh le hasa tagul tang mekla molfidmi. Iwe ngo ha towe rol kapta fengali uwomi mala Abraham mele chapdohmi. Ibe kangalugmi le be yoh ngal Deus le be hasi feas ka sa ffaor chol daowe yael Abraham mo iyang! ");
INSERT INTO uli_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Iy tomiyom we ila yesa fel le ye bele supiyloh ire ka mo wol bol. Pangal ire kala ye tayikof uwal ngo yebe supidiy wototol ngo ye pedadah wulyef.” ");
INSERT INTO uli_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iwe yarmat resa kasiya, “Meda mele habe foru?” ");
INSERT INTO uli_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ngo iy yesa kangalur bo, “Semal le ruwow mengagol halongol ngo be fang sew ngal semal le tor mengagol. Ngo semal le yor hal mongoy ngo yesa fang hal yarmat.” ");
INSERT INTO uli_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tot chol hateyel paliyel raeg le re budoh rebe baptismus re kasiya bo, “Sensey, meda mele hamem habe foru?” ");
INSERT INTO uli_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yesa kangalur bo, “Ha towe hattey paliyel raeg le be ma ligdaloh lepal mala resa faesul hatugulu.” ");
INSERT INTO uli_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tot saldaw resa wol kasiya bo, “Iwe ngo ifa sengal hamem? Meda mele hamem habe foru?” Yesa kangalur bo, “Ha towe kak salpiy mo irel yarmat le hare habe ddeyir hare ha tungu kapter. Hale hafel dipmi irel mekla palimi.” ");
INSERT INTO uli_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iwe sa kel loh lal deper yarmat ngo sa chaep yar kekayewela hare far Johannes mele Kristus. ");
INSERT INTO uli_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iwe Johannes yesa kangalur pangerloh bo, “Ngang iy baptismusgilumi irel chael, ngo ye mel semal le bele moch budoh le ye tagiyet mo imoy. Yol mwo bwela kala yal ngo tor mmaley le iy be besi. Iy mele yebe baptismusgilugmi irel Espritu Santus mo yaef. ");
INSERT INTO uli_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yesa fel lital yengang kala yal le yema hayyagi uwal milay la yal iyang. Yesa hasi ikla ye momay sa yetolong yilim, ngo ye hasi ikla tayikof sa fisgi wol yaef la tema gul.” ");
INSERT INTO uli_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ye cholop sangsengal yael Johannes foloyu Hapatpat Momay we ngalir yarmat ngo ye hakkela ngalir bo rebe yisuwili wigdigir. ");
INSERT INTO uli_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Johannes ye hasi sa kkaftoroy ngal Yerodes we iy mele Tamol le fael molwe ye rili Herodias we ril molwe bisil ngo ye cholop meka tayikof le ye wol foru. ");
INSERT INTO uli_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iwe ngo Yerodes yesa wol foru sew le sa kkel tot yal tayikof bo ye yetolong Johannes lal kalbus. ");
INSERT INTO uli_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yela wol miril yael Johannes baptismusgilir panger yarmat ngo yesa wol baptismusgili Jesus. Yodwe Jesus ye memapel ngo sa sugeg lang, ");
INSERT INTO uli_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","iwe ngo Espritu Santus le ye llehal semal dove sa bidiy uwol Jesus. Iwe ngo yesa malilidiy Deus mo woal laeng le ye sor bo, “Gel layi le ihachangug, ngo ye fel depey irem.” ");
INSERT INTO uli_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yodwe Jesus yela chapiy yal yengang ngo ye bele silig lepal ragel. Yarmat re yitili Jesus bo iy lol Joseph. Joseph iwe lol Heli. ");
INSERT INTO uli_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Iwe ngo Heli we lol Matthat, Matthat we lol Levi, Levi we lol Melchi, Melchi we lol Jannai, Jannai we lol Joseph, ");
INSERT INTO uli_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph we lol Mattathias, Mattathias we lol Amos, Amos we lol Nahum, Nahum we lol Esli, Esli we lol Naggai, ");
INSERT INTO uli_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai we lol Maath, Maath we lol Mattathias, Mattathias we lol Semein, Semein we lol Josech, Josech we lol Joda, ");
INSERT INTO uli_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda we lol Joanan, Joanan we lol Rhesa, Rhesa we lol Zerubbabel, Zerubbabel we lol Shealtiel, Shealtiel we lol Neri. ");
INSERT INTO uli_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri we lol Melchi, Melchi we lol Addi, Addi we lol Cosam, Cosam we lol Elmadam, Elmadam we lol Er. ");
INSERT INTO uli_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er we lol Joshua, Joshua we lol Eliezer, Eliezer we lol Jorim, Jorim we lol Matthat, Matthat we lol Levi, ");
INSERT INTO uli_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi we lol Simeon, Simeon we lol Judah, Judah we lol Joseph, Joseph we lol Jonam, Jonam we lol Eliakim, ");
INSERT INTO uli_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim we lol Melea, Melea we lol Menna, Menna we lol Mattatha, Mattatha we lol Nathan, Nathan we lol David, ");
INSERT INTO uli_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David we lol Jesse, Jesse we lol Obed, Obed we lol Boaz, Boaz we lol Salmon, Salmon we lol Nahshon, ");
INSERT INTO uli_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon we lol Amminadab, Amminadab we lol Admin, Admin we lol Arni, Arni we lol Hezron, Hezron we lol Perez, Perez we lol Judah, ");
INSERT INTO uli_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah, we lol Jacob, Jacob we lol Isaac, Isaac we lol Abraham, Abraham we lol Terah, Terah we lol Nahor, ");
INSERT INTO uli_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor we lol Serug, Serug we lol Reu, Reu we lol Peleg, Peleg we lol Eber, Eber we lol Shelah, ");
INSERT INTO uli_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah we lol Cainan, Cainan we lol Arphaxad, Arphaxad we lol Shem, Shem we lol Noah, Noah we lol Lamech, ");
INSERT INTO uli_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech we lol Methuselah, Methuselah we lol Enoch, Enoch we lol Jared, Jared we lol Mahalaleel, Mahalaleel we lol Kenan, ");
INSERT INTO uli_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan we lol Enosh, Enosh we lol Seth, Seth we lol Adam, Adam we lol Deus. ");
INSERT INTO uli_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Yela tefael Jesus mo Jordan ngo yesa mel Espritu Santus uwol. Iwe ngo Espritu Santus sa paliloh lal tolmayloh we bo Satan be hagla hare be weg depal ngal molfid. Yela wol miril fayeg ral le tor mele ye hangi ngo yesa mesel koloh. ");
INSERT INTO uli_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan sa kangalu bo, “Hare gel molwe Lol Deus ngo hosa kangal feas le bo yebe mel bo sew flowa.” ");
INSERT INTO uli_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iwe ngo Jesus sa sor bo, “Babior we ye Santus ye sor bo, ‘Te flowa chog mele yema molow yarmat iyang.’” ");
INSERT INTO uli_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iwe chog ngo Satan yesa palidah Jesus solboy le ye tagiyet sala kkewar ngali pangal faluyel talople. ");
INSERT INTO uli_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Satan yesa kangalu bo, “Ibe fang ngalug pangal meka bo yisuwom mo yam falmay bo pangal meka ngo yisuwey le be yoh le ibe fang ngal tetugul semal le idipli. ");
INSERT INTO uli_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hare hobe hasrowuyey ila ngo pangal meka ngo yebe mel bo yisuwom.” ");
INSERT INTO uli_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus sa sor bo, “Babior we ye Santus ye sor bo, habe hasrowu Samol la yami Deus ngo iy chog mele habe ma mapel ngali.” ");
INSERT INTO uli_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Iwe Satan sa hasiloh Jesus woal Jerusalem sala itol loboswe ye hartal tagiyet mo woal Templum we ngo sa kangalu bo, “Hare tos bo gel molwe Lol Deus ngo hosa llutdiy mo iga. ");
INSERT INTO uli_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bo Babior we ye Santus ye sor bo, ‘Deus be kangalur angelus kowe lol bo rebe hafallug.’ ");
INSERT INTO uli_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ngo ye wol sor bo, ‘Angelus kala rebe holug dah lal mekla payur bo yede sug pechem irel feas.’” ");
INSERT INTO uli_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus sa sor bo, “Babior we ye Santus ye sor bo, ‘Ho towe tape hagelgel Samol la yam Deus.’” ");
INSERT INTO uli_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Yodwe yela ret metmetal hagelgel irel yael Satan hagla ngal Jesus, iwe ngo yesa ligdi. ");
INSERT INTO uli_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iwe ngo Jesus yesa tefael ngal Galilee ngo mala kkamelal Espritu Santus yesa mel uwol. Yesa palengloh kaptal Jesus wol pangal loh fulu le. ");
INSERT INTO uli_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yema foloy lal imwel ttey kowe iwe ngo panger yarmat ngo rema kapingpinga. ");
INSERT INTO uli_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iwe Jesus sa loh Nazareth we ye faholdah mo iyang. Yela Sabbath ngo sa loh irel imwel tteywe le ila sengal le rema faesul foru. Yesa sudah bo be yawli Babior we ye Santus. ");
INSERT INTO uli_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Iwe resa ngaley babior we tefayel profeta Isaiah. Yesa yoldaloh sala wiri loboswe ye teftaf mo iyang bo, ");
INSERT INTO uli_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Espritu Santus we ye budoh mo irel Deus ila sa mel uwoy bo fael mala yesa duwleyey bo ibe hasidoh Hapatpat Momay le ngalir mael hafohoy. Yesa fang ngang bo ibe kangalur rechoka re kalbus le re bele chuy, ngo rechoka re metafis le re bele wiri formel, iwe ngo rechoka re hafohoyur ila re bele tal. ");
INSERT INTO uli_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Iwe ngo ibe kaptaloh le sa hola yodla Samol be hadorar mekla lol iyang.” ");
INSERT INTO uli_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesus yesa limiloh babior we ngo sa ngaley yeramtawe yema kekamale mo lal imwel tteywe ngo sala marodiy. Panger rechokwe re mel lal imwel tteywe ngo resa ffad ngali chog. ");
INSERT INTO uli_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iwe ngo Jesus sa kangalur bo, “Molwe hasa rongrong we iy sa yawli mo lal Babior we ye Santus ila, igla mele yesa ppalu ngali.” ");
INSERT INTO uli_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iwe ngo panger rechokwe loboswe ngo re sor bo tusurel ngo re lluwdah irel hapatpat kowe ye kangalur le ye momay. Iwe ngo resa kasiy bo, “Te iye molwe lol Joseph?” ");
INSERT INTO uli_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesa kangalur bo, “Iy gula le ha bele kangaluyey hapatpat we rema sor bo, ‘Togta, hola hachuya yam tomay.’ Iwe ngo ha bele wol kangaluyey bo iy be foru mo wol mele haplomoy tappel mokwe hasa rongrong we iy foru mo wol Capernaum.” ");
INSERT INTO uli_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesus sa taboloh le ye sor bo, “Ibe kangalugmi le tor profeta le ye ssor mo wol faluyal. ");
INSERT INTO uli_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ha talenga! Ye katos bo ye cholop fefel kowe sa mes rir mo wol Israel wolmwol Elijah irel yodwe ye tay ppotogloh lal suluw mo setab raeg ngo yesa kkeldoh sew laengda wol pangal loh Israel. ");
INSERT INTO uli_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Iwe ngo Elijah yete loh irer wol Israel bo ye far loh mo woal Zarephath le faluyel Sidon irel semal fefel le sa mes ril. ");
INSERT INTO uli_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ye cholop yarmat le resa hafohoy irel mesel pekel we mo woal Israel wolmwol Elisha. Iwe ngo tor semal le Elisha ye hachuya mesle mo uwol bo halachog Naaman we semal yeramtal Syria.’ ");
INSERT INTO uli_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yodwe panger rechokwe re mel lal imwel tteywe rela rongrong mokwe iwe ngo panger ngo resa ssong. ");
INSERT INTO uli_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Resa sudah chog resa yurawey Jesus mo lugul haplom we resa hasidah lobowe ye tagiyet mo irel tayit we ye mel molwe haplomor iyang. Resa luluwaley le re bela hadrowey mo woal ngachel tayit we. ");
INSERT INTO uli_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Iwe ngo iy sa darlong luwul buwa we sala buyoy mo rewe sera sa loh lobole iy ye luluwaley be loh iyang. ");
INSERT INTO uli_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iwe ngo Jesus sa loh Capernaum le haplomol Galilee. Ila lobosla yela foloy ngalir yarmat mo iyang wol sew Sabbath. ");
INSERT INTO uli_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pangal yarmat ngo re lludah irel foloy kala yal bo ye luglug fael yal foloy. ");
INSERT INTO uli_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ye mel semal mal lal imwel tteywe le yor moniyan uwol. Yesa tawullagililoh le ye sor bo, ");
INSERT INTO uli_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Cchuy mo iremem! Meda mele hosa luluwaley ngalugmem gel Jesusel Nazareth? Hosa budoh bo hobe llugmem? Ngang ila i gulah. Gel yeramtawe ye santus we hobudoh mo irel Deus!” ");
INSERT INTO uli_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus sa kkaftoroy ngal moniyan we le ye sor bo, “Ppoloh ngo hosa chuy mo wol yeramtela!” Irel yodwe ngo moniyan we yesa pedadiy mal we mo imor pangal yarmat ngo tor mele ye foru. Iwe ngo sa chuyloh moniyan we mo uwol mal we. ");
INSERT INTO uli_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Panger ngo re lluwdah ngo resa rol kapta fengali chog uwor le re sor bo, “Hapatpat meda meka iye sengal le la yor kkelal mo kkamelal le yeramtale yebe kkaftoroy ngalir chog moniyan ka ngo resa chuy.” ");
INSERT INTO uli_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesa paleng loh kaptal Jesus wol pangal loh Galilee. ");
INSERT INTO uli_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus ye chutang imwel tteywe sa loh irel imw we imwel Simon. Molwe sil molwe ril Simon ila ye tomay ngo ye kkel bichikeral. Iwe resa kangalu kofal. ");
INSERT INTO uli_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesa loh sala su lengachel bet we giyal ngo yesa hachuya yael fefel we tomay. Sala chuyloh molwe bichikeral, iwe sa chemdah chog sala ffaor mekla yebe hammal ngalir. ");
INSERT INTO uli_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wol miril molwe sa dol loh yaal ngo pangerloh rechokwe re tomay irel semat mo semat maes ngo mokwe wol maryerer re hasirdoh irel Jesus. Jesus yesa yetadah paol woal semal mo semal ir, iwe ngo sa chuyloh yar tomay. ");
INSERT INTO uli_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ye cholop yarmat le ye chuy moniyan mo uwor. Yebe chuy moniyan ka ngo rema tawullagililoh le rema sor bo, “Gel molwe Lol Deus!” Jesus sa kangalur moniyan kowe bo re towe malili bo fal mala ir re gola le iy mele Kristus. ");
INSERT INTO uli_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lemaygugul ralawe seral ngo sa chuy Jesus mo luwul haplom sa loh solboy le torloh yarmat iyang. Iwe ngo sa chaep yar yarmat memmer fedaley. Yodwe rela wiri ngo resa luluwaley sew formel le rebe foru le iy towol ligdir iyang. ");
INSERT INTO uli_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Iwe ngo yesa kangalur bo, “Ibe wol la foloyu mo wol haplom kala tot Hapatpat Momay le kofal mala Lamliyel Deus, bo ila fael yael Deus ye fangdoh ngang.” ");
INSERT INTO uli_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iwe yesa taboy yal foloy fedal lal imwel ttey kowe wol pangal loh Judea. ");
INSERT INTO uli_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Seral ngo Jesus ye su wol ngachel Laom we Gennesaret ngo yarmat resa rol hadibal ngali bo rebe rongrong molwe yalol Deus. ");
INSERT INTO uli_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ye sala wiri ruyay boat le resa hasredah wulpiy. Chol fita kowe resa ligdi boat kowe re sala tetaldi fedaley wug kowe yar. ");
INSERT INTO uli_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus yesa chudah yuchul seyay boat kowe le wal Simon. Yesa kangalu bo be hattawey sugfed boat we tang piy. Jesus yesa maroro yuchul boat we sa fofoloy ngalir buwa we. ");
INSERT INTO uli_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yodwe yela mol yal hapatpat ngo Jesus sa kangalu Simon bo, “Hattawey sugfed boat le lobosla ye yod ngo hasa halgaloh wug we yami bo habe fita.” ");
INSERT INTO uli_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon sa sor bo, “Masta, sa bongwe chog yamem fita yee la ral loh ngo tor mele ha hola. Iwe ngo hare ila sengal le ho sor, ila ngo ha bele halgaloh wug ka yamem.” ");
INSERT INTO uli_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Iwe resa halgaloh wug we yar ngo hasfaluy lepal yig le ye bulong iyang le sa fesugfed ngo bele towas wug we iyang. ");
INSERT INTO uli_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iwe resa hagil ngalir rechokwe choluwar yuchul boat we seyay bo rebe budoh tipingir. Iwe re sala budoh resa hayda boat we ruyay yee la ssogloh le resa momos. ");
INSERT INTO uli_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yodwe Simon Pedrus yela wiri molwe yesa iwe sengal ngo yesa hasubgudiy mo imol Jesus ngo yesa kangalu bo, “Chuy mo irey ho Samol bo ngang semal choto hamolfid!” ");
INSERT INTO uli_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ye te medaf Simon mo mokwe choluwal irel lepal yig kowe resa hola. ");
INSERT INTO uli_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wol ila senger chowe rumal we chilal Simon, James mo John we lol Zebedee. Jesus sa kangal Simon bo, “Ho towe motog, bo bele chaep igla sa loh ngo hami ha bele fita yarmat.” ");
INSERT INTO uli_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iwe resa yuradah boat kowe wulpiy ngo resa tahcheloh pangal formel, resa dabey Jesus. ");
INSERT INTO uli_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sew yad le Jesus ye mel woal sew haplom ngo ye wol mel semal mal iyang le yesa hafohoy irel mesel pekel. Yodwe yela wiri chog Jesus ngo yesa haborohdi wototol ngo yesa kangalu bo, “Hare ye fel mo lal depom temay ngo be yoh le hobe hachuya tomay le mo uwoy.” ");
INSERT INTO uli_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus sa cchangloh sala yangsi mal we ngo sa sor bo, “Ngo, ye fel mo lal depey bele chuy tomay la mo uwom.” Yodwe chog ngo sa chuyloh meswe mo uwol mal we. ");
INSERT INTO uli_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iwe Jesus yesa hatobtob ngal mal we bo tor semal le be kangalu. Iwe ngo yesa kangalu bo, ho loh irel temarong we bo be kemahoh. Iwe ngo hosa fang maligach we Moses ye sor bo yebe mel bo sew hagil ngal pangal yarmat le yesa chuy mesel pekel we mo uwom. ");
INSERT INTO uli_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iwe sala far palengloh molwe kaptal Jesus. Buwa kowe resa budoh irel bo rebe talenga yal hapatpat ngo ye hachuya yar tomay. ");
INSERT INTO uli_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Iwe ngo Jesus yema toaloh lobos kowe tema yor yarmat iyang bo bela mapel. ");
INSERT INTO uli_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Seral le Jesus ye fofoloy ngo re maroro tot Pharisees mo tot mokwe sensel Hatobtob we loboswe le re budoh mo Jerusalem mo wol pangal mokwe haplomol Galilee mo Judea. Molwe kkamelal Deus ila yesa mel uwol Jesus bo yebe yoh le be hachuya yael yarmat tomay. ");
INSERT INTO uli_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ye sala budoh tot yarmat le re hasidoh semal mal le ye mahatugut le ye mel lal sew chob. Re luluwaley bo rebe hasilong yilim bo re bela holadiy mo imol Jesus. ");
INSERT INTO uli_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Iwe ngo tor solbos le rebe dohlong mo iyang bo sa hadibal hamas yarmat. Iwe resa hasidah woal wungul imw we resa hattare solbos mo woal imw we resa habidiyo chotomay we mo imol Jesus lal longob we. ");
INSERT INTO uli_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yodwe Jesus yela wiri kkelel tugul we yar rechokwe ngo yesa kangalu mal we bo, “Maryerey, sa chuy fael yam molfid.” ");
INSERT INTO uli_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mokwe sensel Hatobtob we mo Pharisees kowe resa chapiy yar lunglung fengal le re sor bo, “Itey mal le ye kekapaliyel ngal Deus? Tor semal yarmat le be yoh le be hachuya fael molfid bo halachog Deus mele be yoh irel!” ");
INSERT INTO uli_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus ye gola luluwal kowe yar ngo sa kangalur bo, “Meda fal le ila sengal yami luluwal iyang? ");
INSERT INTO uli_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ifa sew le ye mechrag le iy be sor, ‘Yesa chuy fal yam molfid’ hare iy be sor bo, ‘Sudah hobe darloh’? ");
INSERT INTO uli_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ila ibele kkewar ngalugmi le mala Layur Retalop ila yor kkelal woal talople bo yebe hachuya fael molfid.” Iwe yesa kangal mal we ye mahatgut bo, “Ibe kangalug igla, sudah hosa hasi chob la giyem hosa loh lubugtam.” ");
INSERT INTO uli_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Irel yodwe chog ngo mal we yesa sudah mo imol panger yarmat ngo yesa hasi molwe giyal sa loh lubugtal le yesa kkapingpinga Deus. ");
INSERT INTO uli_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pangerloh rechokwe ngo resa rol lluwdah. Iwe ngo yesa kkel yar rol motog. Iwe resa hapingpinga Deus le re sor bo, “Moch igla mele siya wiri tot formel le tediyor mwo mo fael sew le si wiri!” ");
INSERT INTO uli_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yela wol miril ngo yesa loh Jesus sala wiri semal chol hateyel paliyel raeg le rema sor bo Levi le ye maroro lal yofis la yal. Jesus sa kangalu bo, “Dabeyey.” ");
INSERT INTO uli_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi yesa ttahchadiy pangal formel yesa dabey Jesus. ");
INSERT INTO uli_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Iwe Levi yesa foru sew gubul le ye paleng irel imw we imwal bo yael Jesus. Ye cholop chol hateyel paliyel raeg mo wol tot yarmat le re mel irer. ");
INSERT INTO uli_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tot Pharisees mo tot mokwe sensel Hatobtob we choluwar re lunglung ngal mokwe redabeyel Jesus le re sor bo, “Meda mele hala mongoy ngo ha yul ngalir chol hateyel paliyel raeg mo rechokla yarmat rete dipli wegdegir iyang?” ");
INSERT INTO uli_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus sa kangalur bo, “Rechoka rete tomay ila tor fal le togta be loh irer, bo rechokla re tomay togta ye mela tefael mo irer. ");
INSERT INTO uli_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ite budoh le ibe ffesangur rechokla re momay, bo ibudoh ffesangur ika re tohamolfid bo yebe rrig lal deper.” ");
INSERT INTO uli_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tot yarmat re kangalu Jesus bo, “Mokwe redabeyel Johannes ila rema tosupiy haler ngo re mapel ngo wol ila mele mokwe redabeyar Pharisees kowe rema foru. Ngo ikla redabeyem ila re tema poloh mo irel mongoy mo yul.” ");
INSERT INTO uli_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus sa kangalur bo, “Ha luluwaley ngo be yoh le habe hapolohor chol gubulul sew habulupoy le re towe mongoy irel yodla ye chil mel mal la ye habulupoy irer? Towe yoh! ");
INSERT INTO uli_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ye mel ralla rebe hasi tangir mal we ye habulupoy. Iwe ngo ir re bele moch supiy haler.” ");
INSERT INTO uli_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus yesa wol kangalur sew fiyong le ye sor bo, “Tor semal le yema mesreyi sedep mengag le ye tefoy yesa depecha ngal sew le sa sulay. Hare be ila sengal ngo bele hatawsi mengag we ye tefoy. Bo madpil mengag we ye tefoy ila towe hafedeg ngal iwe yesa sulay. ");
INSERT INTO uli_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ngo tor semal le yema yitetlong wine ka chil tefoy lal liliyel wine ka sa sulay bo be towas. Hare be ila sengal ngo be towasloh liliyel wine we sa sulay sala serloh wine we chil tefoy. Ila ngo tayor mele sibe chil tapeli ngali liliyel wine we sa sulay. ");
INSERT INTO uli_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wine ka ye tefoy ila ye momay le be bulong chog lal liliyel wine ka ye tefoy. ");
INSERT INTO uli_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tor semal le bela wol miril yal yul wine ka sa sulay ngo be chil mechal le be yul ika ye tefoy. Yebe sor bo, ‘Wine ka yesa sulay mele ye momay.’” ");
INSERT INTO uli_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sew Sabbath ngo Jesus ye dedarloh luwul tot milayel wheat. Iwe ngo mokwe redabeyal resa fichfich yadel wheat kowe resa muldu resa hangi. ");
INSERT INTO uli_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iwe ngo tot Pharisees kowe resa kasiy, “Meda mele ha foforu mala Hatobtob we yach ye sor bo si towe ma foru wol Sabbath iyang?” ");
INSERT INTO uli_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus sa kangalur bo, “Ha ted yawli mwo kaptal molwe David ye foru irel yodwe iy mo mokwe choluwal re mesel koloh iyang? ");
INSERT INTO uli_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David ye bulong lal imw we imwel Deus yesa hasi flowa we resa tap maligach ngal Deus yesa mongoy ngo ye wol fang haler mal kowe choluwal, ngo iwe Hatobtob we yach ye sor bo halachog temarong ka mele ma yoh le rebe ma hangi flowa la.” ");
INSERT INTO uli_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iwe sa kangalur bo, “Mala Layur Retalop ila iy Samol le ye lamli Sabbath.” ");
INSERT INTO uli_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yela wol sew Sabbath ngo Jesus ye loh irel sew imwel ttey sala foloy. Ye mel semal mal lal imw we le ye mes rel paol rela gilemra. ");
INSERT INTO uli_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iwe ngo tot sensel Hatobtob we mo tot Pharisees kowe re memeri sew formel le be mel bo derel Jesus. Iwe resa mmesa hamayu hare yor le Jesus yebe hachuya yal tomay woal Sabbath. ");
INSERT INTO uli_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Iwe ngo Jesus ye gola luluwal kowe yar. Iwe sa kangalu mal we bo, “Sudah hosa budoh mo iga.” Yesa langdah mal we sala su loboswe. ");
INSERT INTO uli_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesus sa kasiyar, “Meda mele Hatobtob we yach ye telad ngalgich bo sibe foru wol Sabbath? Sibe hamaler yarmat hare sibe hafohoyur? Sibe hadora semal mo irel maes hare sibe limeseloh?” ");
INSERT INTO uli_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesa kal fedal luwulur panger ngo yesa kangal mal we bo, “Hadingawey mala pom.” Mal we ye foru molwe iwe ye sala tefael loh llifadol molwe paol. ");
INSERT INTO uli_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Iwe sa kkel yar ssong ngo resa kapta fengali lufulyer mele be yoh le rebe foru ngal Jesus. ");
INSERT INTO uli_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Irel yodle ngo Jesus sa bidah wol sew tayit bo bela mapel. Sebongloh yal mel loboswe le ye memapel ngal Deus. ");
INSERT INTO uli_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yela rael loh ngo yesa ffesangur mokwe redabeyal yesa duwley seg mo rumal mo luwulur ngo yesa hadedaer bo Apostel. ");
INSERT INTO uli_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ika meka ider Apostel kowe seg mo rumal Simon (we hadeda bo Pedrus) mo Andrew we bisil, iwe mo James mo John, mo Philip mo Bartholomew, ");
INSERT INTO uli_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Iwe mo Matthew mo Thomas, mo James we lol Alphaeus, mo Simon (we semal Patriot). ");
INSERT INTO uli_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iwe mo Judas we lol James, mo Judas Iscariot we ye fangloh Jesus. ");
INSERT INTO uli_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yodwe Jesus mo mokwe redabeyal rela bidiy mo wol tayit we ngo Jesus sala su mo solbos le ye wwelloh ngo ye cholop mokwe redabeyal iyang. Ye mel sew buwal yarmat lobowe le re budoh mo irel pangal mokwe faluyel Judea mo Jerusalem mo haplom kala ye harpa taaed iwe mo wol Tyre mo Sidon. ");
INSERT INTO uli_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Resa rodoh bo rebe talenga foloy kowe yal ngo ye hachuya yar tomay. Rechokla resa hafohoy irel moniyan ila re budoh ngo ye wol hachuya moniyan mo uwor. ");
INSERT INTO uli_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pangal yarmat ngo re yedamgell bo rebe yangsi bo yebe chuy yar tomay irel kkemal la ye mel uwol. ");
INSERT INTO uli_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iwe ngo Jesus sa kal ngalir mokwe redabeyal ngo sa kangalur, “Be momay lal dipmi hami rechokla ha hafohoy bo mala Lamliyel Deus ila sa mel bo yami! ");
INSERT INTO uli_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Be momay lal dipmi hami rechokla hama kkoloh loh chog bo Deus yebe fang hammalmi! Be momay lal dipmi hami rechokla ha tetang igla bo habe rol memael! ");
INSERT INTO uli_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Be momay lal dipmi irel yodla yarmat rebe hafobdurugmi ngo re ddabohmiloh ngo re hapatpat tayikofloh iremi ngo re sor bo ha moniyan. Pangal meka ngo rebe faor ngalugmi le fael mala hami redabeyel mele Layur Retalop! ");
INSERT INTO uli_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ha hacchahsi lal dipmi le bela weldoh meka bo hami ila habe barog irel yami rraey bo ye paleng paliyel yami hafohoy le ye mel woal laeng. Ila sengal chog mele chapdoh kowe yar re faor ngalir profeta kowe. ");
INSERT INTO uli_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Be kkel tayikofal lal dipmi hami rechokla ha mmal igla, bo sa ila chog lepal mmalmi ila! ");
INSERT INTO uli_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Be kkel tayikofal lal dipmi rechokla ha maed loh chog igla, bo hable kkoloh! Be kkel tayikofal lal dipmi hami rechokla ha memael igla, bo be hafohoy lal dipmi ngo ha tang! ");
INSERT INTO uli_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Be kkel tayikofal lal dipmi igla le yarmat rebe hapingpingahmi bo wol ila sengal chog yar mokwe chapdohor hapingpingar rechokwe re forigirloh bo ir profeta. ");
INSERT INTO uli_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ibe kangalugmi rechokla ha rongrong foloy ka yai: Habe hachangir rechokla re tayikof ngalugmi, ngo ha faor mekla ye momay ngalir rechokla re hafobrugmi. ");
INSERT INTO uli_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ha holbuwar rechokla rema hasi ngalugmi tayikof. Iwe ngo ha mapelar rechokla ye tayikof wigdigir ngalugmi bo rebe momay. ");
INSERT INTO uli_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Hare semal ye ppigri sere tepam, ngo hosa wigid ngali rela sere bo be wol ppigri. Ngo hare ruwow mengagom ngo semal sa hasi tangug sew, ngo hosa wol ngaley ila sew. ");
INSERT INTO uli_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hobe mmol ngalir panger yarmat. Hare semal yebe hasi sew litam ngo ho towe la dongoroy tefaeli. ");
INSERT INTO uli_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ha faor ngalir yarmat mekla mahi ha dipli le yarmat rebe faor ngalugmi. ");
INSERT INTO uli_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Hare ho hachangir chog rechokla re hachangugmi ila ngo meda fal le Deus yebe holbuwahmi iyang? Choto hamolfid mwo ngo re hachangir chog rechokla re chang mo irer! ");
INSERT INTO uli_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hare habe momay ngalir chog rechokla rema momay ngalugmi, ila ngo meda fal le Deus yebe holbuwahmi iyang? Choto hamolfid mwo ngo ma wol ila senger. ");
INSERT INTO uli_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hare habe mmol ngalir chog rechokla re mmol ngalugmi ila ngo meda fal le Deus yebe holbuwahmi iyang? Choto hamolfid ngo rema mmol ngalir choto hamolfid bo re gola le be tefael ngalir lepal mala ir re fang. ");
INSERT INTO uli_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Towe ila sangmi! Habe hachangir ngo ha wol hammay ngalir rechokla re tayikof ngalugmi. Habe hammolagmi ngo ha towe luluwaley le be yor paliyal. Bo paliyel yami hachigchig ila yebe paleng ngo ha bele mel bo lol Deus le ye Hartal Tagiyet. Bo Deus ila ye momay ngalir rechoka rete ma metpengag ngo tayikof wigdigir. ");
INSERT INTO uli_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Be ffaho lal dipmi le be wochog mala Tami le ye ffaho depal. ");
INSERT INTO uli_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ha towe hatugulu yal tayikof semal yarmat ila ngo Deus towe hatugulu yam tayikof. Ha towe hatugulu yael semal yarmat hagerger ila ngo Deus towe hatugulu yami hagerger. Hachuya mo lal dipmi tayikof kala yarmat resa faor ngalugmi, ila ngo Deus be hachuya mo lal depal tayikof kala hasa foru ngali. ");
INSERT INTO uli_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ha mmol ngalir yarmat ila ngo Deus be mmol ngalugmi. Katosol le bele cholop mele be yoh ngalugmi le bele semal hami ngo takkel chog ngo towe ret. Lepal yami momay ngal yarmat ngo be ila lepal yael Deus momay ngalugmi.” ");
INSERT INTO uli_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iwe Jesus sa kangalur sew fiyong: “Towe yoh le semal metafis be pali semal metafis. Rebe foru mele ngo rebe cheprag long lallib. ");
INSERT INTO uli_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tor semal yalwichil skun le ye tagiyet mo imol yal sensey. Halachog ila panger yalwichil skun ngo re bela hammaloloh yar skun ngo re bele moch hafedeg ngal yar sensey. ");
INSERT INTO uli_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Meda mele ho bela ppad irel sepoy pes le ye mel lal metal mala bisim le gel mwo ngo ho tuwri tabol ire la ye mel lal ila metam? ");
INSERT INTO uli_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Be ifa sengal chog ngo ho sala kangalu mala bisim, ‘Fael pechem bisiy, widyey ibe hachuya pes la sepoy mo lal mala metam,’ le gel mwo ngo ho tuwri tabol ire la lal ila metam? Gel ila ho fforiyeg! Metamol ngo hobe hachuya petal ire la ye mel lal mala metam, ila ngo bele moch ffod yam wiri pesla sepoy le hobe hachuya mo lal metal mala bisim. ");
INSERT INTO uli_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Sehay ire le be cchapipiy tumlal ngo yebe momay mekla uwal. Sehay ire le be tayikof tumlal ngo yebe tayikof mekla uwal. ");
INSERT INTO uli_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pangal metmetal ire ngo sima gola mo irel igegel mekla uwal. Towe yoh le hobe gil maey mo yuchul laech, ngo towe yoh le ho bela gil grape mo yichul bebay. ");
INSERT INTO uli_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Semal yarmat le ye momay ila yema kawraloh mekla ye momay mo lal depal. Semal le be tayikof ngo mekla tayikof mele yema kawraloh. Bo meka sima kapta ila ikla mekla ye ssog lal depach. ");
INSERT INTO uli_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Meda mele hama ffesanguyey bo, ‘Samol, Samol, ngo hate ma foru mekla ima kangalugmi bo habe foru? ");
INSERT INTO uli_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Te tugul semal le yebe budoh irey ngo ye talenga ngo ye foru meka yaloy, ngo ibe kkewar ngalugmi tappel iy yeramtala. ");
INSERT INTO uli_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ye wochog semal yarmat le ye hasuy imw la imwal le ye kilingidiy libel dayifel imw la imwal sala fetalehadah mo wol porow. Yela bidah law ngo te towas bo ye kkel mala hassul. ");
INSERT INTO uli_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Te tugul semal le ye rongrong foloy ka yai ngo te foru ila ye wochog semal yarmat le ye hasu imw la imwal ngo tor dayifal. Yela bidah chog law sa hatawsi sewaloh!” ");
INSERT INTO uli_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yodwe Jesus ye mol yal kangalur yarmat pangal mokwe ngo yesa chuy sa loh wol Capernaum. ");
INSERT INTO uli_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ye mel semal tamol saldaw lobowe le ye mel semal boy yal le ye kkel yal hachangi. Boy le yal ila yesa kel yal tomay le yesa harpal mes. ");
INSERT INTO uli_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yodwe tamol saldaw we yela rongrong kofal Jesus ngo yesa fang loh tot mal kowe yar yeramtal Israel irel Jesus bo re bela kangalu bo yebe budoh hachuya yael boy we tomay. ");
INSERT INTO uli_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Rela budoh irel Jesus ngo resa hafaelpechey. “Mal le ila ye paleng pelal le hobe tipingi ");
INSERT INTO uli_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","bo ye hachangir panger meka chol fuluyach ngo yesa hasu sew imwel ttey bo yach.” ");
INSERT INTO uli_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iwe Jesus yesa daber. Rela harpadoh imw we ngo tamol saldaw we sa fang tot mokwe maryerel bo re bela kangalu Jesus bo, “Jesus, ho towe haweresug irel mele melap bo tor kofay le gel hobe budoh irel imw le imwey. ");
INSERT INTO uli_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iwe ngo ngang tor mmaley le ibe buyoy irem bo gel semal yarmat le ho tagiyet. Mele chog hobe sor yalom ngo boy le yai ila be chuy tomay. ");
INSERT INTO uli_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngang mwo ngo yor tot tamol saldaw le re tagiyet mo imoy ngo yor layi saldaw. Ibe kangalu iye semal bo, ‘Ho loh!’ ngo iy yesa loh; ngo ibe kangalu ila semal bo, ‘Budoh!’ ngo iy yesa budoh; ngo ibe kangalu slave le yai bo, ‘Foru mele!’ ngo iy yesa foru.” ");
INSERT INTO uli_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus ye lluwdah irel molwe yela rongrong mele. Yesa tagul ngalir buwa we re dadabedoh miril yesa kangalur, “Ibe kangalugmi le ited wiri mwo semal mo wol Israel le iye lepal kkelel yal tugul le iye sengal.” ");
INSERT INTO uli_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yodwe mokwe wol maryerel tamol saldaw we rela tefael ngal imw we re sala wiri boy we le yesa chuy yal tomay. ");
INSERT INTO uli_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Te sulay mo wol miril ngo Jesus yesa loh wol sew haplom le rema sor bo Nain ngo mokwe redabeyal mo sew buwal yarmat re dabey. ");
INSERT INTO uli_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Irel yodwe yela hola doh hatemal yororol haplom we ngo resa buyoy yarmat le chol liblib. Tarmal le ye mes ila, ila chog lol semal fefel le sa mes ril. Ye cholop yeramtal haplom we le re dabey fefel we. ");
INSERT INTO uli_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yodwe Samol yela wiri chog fefel we ngo sa budoh yal fahoy ngo yesa kangalu bo, “Ho towe tang.” ");
INSERT INTO uli_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Iwe yesa darngal kaholol meswe ye sala yangsi. Rechokwe re kekasiloh kahol we resa ppoloh. Jesus yesa sor bo, “Ibe kangalug gel tarmal le bo, chemdah!” ");
INSERT INTO uli_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mal we ye mes sa chemdah ngo sa chapiy yal hapatpat ngo Jesus yesa paliloh tarmal we irel molwe sil. ");
INSERT INTO uli_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pangal yarmat ngo yesa kkel yar motog ngo resa hapingpinga Deus. “Semal profeta le ye tagiyet iye yesa llah mo luwuluch; Deus yesa budoh bo yebe hadorar meka lol.” ");
INSERT INTO uli_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesa palengloh molwe kaptal Jesus wol Judea mo pangal fuluy mo haplom. ");
INSERT INTO uli_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yodwe mokwe redabeyel Johannes rela kangalu pangal mokwe Jesus yesa foru, ");
INSERT INTO uli_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ngo Johannes yesa ffesangur rumal mo irer bo yebe fang loh ir irel Samol bo re bela kasiya hare, “Gel molwe Johannes ye sor bo yebe budoh hare chil mel semal mo solbos?” ");
INSERT INTO uli_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yodwe rechokwe rela budoh irel Jesus ngo resa kangalu bo, “Johannes Baptista ye fang doh hamem habe kasiyah hare, gel yeramtawe iy ye sor bo yebe budoh hare chil mel semal mo solbos?” ");
INSERT INTO uli_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Irel yodla chog ngo sa cholop le Jesus sa hachigrar mo irel yar tomay ngo ye hachuya metmetal maes mo moniyan mo uwor ngo ye cholop le iy ye wol hachuya yar metafis. ");
INSERT INTO uli_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesus yesa hatefali ngo yesa kangalur bo, “Ha loh ngo ha sala kangal Johannes meka hami hasa wiri ngo ha rongrong. Rechoka re metafis ila resa wiri formel, rechoka te mmal rebe darloh ila resa darloh, rechoka ye pach ngalir mesel pekel ila yesa chuy mo uwor, rechoka re talengbat ila resa rongrong formel, chomes ila resa molow tefael mo irel maes, ngo Hapatpat Momay we ila resa foloyu ngalir mael hafohoy. ");
INSERT INTO uli_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ifa lepal momayel deper rechokla te yeyewal deper irey!” ");
INSERT INTO uli_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wol miril yar loh re hagloy kowe yael Johannes ngo Jesus yesa chapiy yal kapta kofal Johannes ngalir buwa we: “Irel yodwe ha roloh irel Johannes lal tolmay loh we, meda mele ha luluwaley le ha bela wiri? Seyal yall fadil le yaeng ye fiffildi? ");
INSERT INTO uli_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Meda mele ha loh ha bela kemahoy? Semal mal le ye mengag irel mengag kowe ye kkamdidi? Rechokla rema mengag irel mengang ka ila re mel luwul mmal ngo rema mel lal imw kowe imwer tamol. ");
INSERT INTO uli_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ha kangaluyey, meda mele ha loh ha bela kemahoy? Semal profeta? Tos le ila sangal. Ngo hal ila yeramtala hasa wiri ila ye tagiyet mo imol semal profeta. ");
INSERT INTO uli_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bo Johannes molwe babior we ye santus ye sor irel: ‘Deus ye sor bo, ibele fangloh re hagloy we yai bo bela hafle mala yalepam.’” ");
INSERT INTO uli_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesus ye sor bo, “Ibele kangalugmi le tor semal le ye tagiyet tangi Johannes. Iwe ngo halachog ila yeramtala ye hartal totol mo irel mala Lamliyel Deus ila ye tagiyet mo imol Johannes.” ");
INSERT INTO uli_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Panger rechokwe ngo re rongrong mokwe Jesus ye sor. Le ir fengal mo rechokwe rema hattey paliyel raeg ngo resa talenga mekla yalol Deus le ye fel, ila panger ngo resa baptismus irel Johannes. ");
INSERT INTO uli_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Iwe ngo Pharisees mo mokwe sensel Hatobtob we rete dabey mala depel Deus ngalir iwe ngo re temechal baptismus irel Johannes. ");
INSERT INTO uli_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesus sa taboloh yal hapatpat ngo sa sor bo, “Sa ifa senger yeramtal fael mwole? Meda mele yebe haweweli ngalir? Ifa sengal wululur? ");
INSERT INTO uli_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Resa wochog sibis yalwich le re maroro loboska liliyel market le rema toa tteydoh yarmat iyang. Sibis ir re bele ttawul ngalir ikla tot le re sor bo, ‘Sila mosikil harraey ngalugmi ngo hami ha temchal barog. Sila yewaw tang ngalugmi ngo hami ha temchal tang!’ ");
INSERT INTO uli_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yela budoh Johannes Baptista ngo yema supiy hal le yal maligach ngo te ma yul wine ngo hami ha sor bo yor moniyan uwol! ");
INSERT INTO uli_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yela budoh mele Layur Retalop ngo yema mongoy ngo ma yul ngo hami ha sor bo, ‘Ha kemahoy yeramtale ye mongolaep ngo ye toayul wine. Iwe ngo yema hammaryar ngalir chol hatteyel paliyel raeg mo chotayikof.’ ");
INSERT INTO uli_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Repiy la yael Deus le ye momay ila yesa llahloh le ye katos mo irel wegdigir rechokla sa yoh ngalir.” ");
INSERT INTO uli_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ye mel semal Pharisees le ye ffesangu Jesus bo re bela mongol fehaf iwe Jesus sa loh irel imw we imwal yesa marodiy ye bele mongoy. ");
INSERT INTO uli_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wol haplom we ye mel semal fefel iyang le iy semal choto hamolfid. Yela rongrong bo Jesus ye momongoy irel molwe imwel Pharisee we ngo sala hasidoh sew molor kowe ye ffaor mo irel alabaster le ye ssogol loy. ");
INSERT INTO uli_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ye budoh sala su mo lugutugur, lengchel mokwe pechel Jesus le ye tetang yesa tturturdiy mokwe chael metal wol mokwe pechpechal pechel Jesus. Iwe yesa hapalpaley mokawe pechel ngal mokwe yael chemal. Iwe ngo yesa fesngo ngo ye chaelfi ngal loywe. ");
INSERT INTO uli_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yodwe Pharisees we yela wiri molwe ngo yesa luluwaley long chog lal depal le, “Hare semal halongol profeta mele ngo be gola kofal fefel le yesa budoh ye yangsi, yebe gola le iy semal choto hamolfid.” ");
INSERT INTO uli_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus yesa maliliy ngo yesa kangalu bo, “Simon, ye mel sew formel le ibe kangalug.” Simon yesa sor bo, “Ngoa, ho Sensey, kangaluyey.” ");
INSERT INTO uli_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus sa cchidage le ye sor bo, “Ye mel rumal mal le rela hamolfid salpiy mo irel semal yarmat le, yarmat rema hamolfid salpiy mo irel. Semal ye hasi lumbuguy ngo semal ye hasi lemeg. ");
INSERT INTO uli_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tor semal rechokwe le ye chil yoh bo be hatefali lepal salpiy we ye hasiy. Iwe mal we yesa hamolaho mokwe molfidir rorumal. Iwe ifa semal rechoka le yebe kkel yal hachangi yeramtawe ye fang salpiy ngalir?” ");
INSERT INTO uli_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Iwe ngo Simon sa sor bo, “Yai luluwal ngo yeramtala ye cholop molfidil le ye iy mal we ye hamolaho.” Jesus yesa kangalu bo, “Ye bung mala ho sor.” ");
INSERT INTO uli_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesa tagul ngal fefel we ngo yesa kangal Simon bo, “Ho wiri fefel le? Ibudoh irel imw le imwom ngo tor chael le ho fang ngalyey bo ibe kililiy pechey iyang. Iwe ngo fefel le yesa hadudu meka pechey irel meka chael metal ngo sa hapalpaley ngal meka yall chemal. ");
INSERT INTO uli_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yodwe ibudoh ngo gel hote fesngoyey. Iwe ngo fefel le iye ted ppoloh mo irel yal fesngoloh chog meka pechpechal pechey. ");
INSERT INTO uli_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tor hapgep le ho chalfi ngal mele chemey ngo iy iye yesa chalfi meka pechey ngal loy. ");
INSERT INTO uli_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ibe kangalug bo lepal kkelel hachangcheng la yal le yesa kawraloh ila sa tugul bo pangal mokwe molfidil we ye cholop ngo sa chuy. Iwe ngo semal le ye wechich molfidil le ye chuy ila ye wechich hachangcheng la ye kawraloh.” ");
INSERT INTO uli_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iwe ngo Jesus yesa kangalu fefel we bo, “Yesa chuy fael yam molfid.” ");
INSERT INTO uli_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tot rechokwe re mel irer resa rol kasiy fengal uwor le re sor bo, “Itey mele le yema hachuya yar yarmat molfid?” ");
INSERT INTO uli_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iwe ngo Jesus yesa kangalu fefel we bo, “Tugul la yam mele yesa hadorah, ho loh luwul hopos.” ");
INSERT INTO uli_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Te sulay mo wol miril ngo Jesus sala malekah fedal wol sew mo sew haplom le yela foloyu Hapatpat Momay we kofal mala Lamliyel Deus. Chowe seg mo rumal re dabey, ");
INSERT INTO uli_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","iwe mo wol tot fefel le yesa hachuya moniyan mo metmetal tomay mo uwor: Mary (we rema ffesang ngali bo Magdalene), we ye chuy fismol moniyan mo uwol. ");
INSERT INTO uli_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Iwe mo Joanna we ril Chuza we semal rechokwe ye tagiyet mo irel imw we imwel Yerodes; iwe mo Susanna mo wol tot fefel le re tapeli mekla hamaler llufulyer bo hammalel Jesus mo mokwe redabeyal. ");
INSERT INTO uli_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Resa rorodoh chog yarmat mo wol sew mo sew haplom irel Jesus. Yodwe sa cholop doh yarmat ngo Jesus yesa kangalu fiyong le: ");
INSERT INTO uli_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ye mel semal mal le yela fadgu milay la yal. Yodwe yela hamro faesol ire kowe yal woal milay we, ngo tot ye ppungdiy lal yalap, iwe yarmat resa suru fedaley ngo mael yeyal re budoh resa hangiloh. ");
INSERT INTO uli_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tot ikla ye pungdiy lobos kala ye faesfos. Ye tumuldah ngo ye betbatloh bo ye telap chael lobowe. ");
INSERT INTO uli_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tot fedah kowe ye pungdiy luwul ire kowe yor chil re sala tumul sewdah iwe sala farorloh fedah kowe irel ire kowe yor chil. ");
INSERT INTO uli_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Iwe ngo tot ila ye pungdiy loboka ye momay bol iyang. Yela tumuldah yee la paleng sala yor uwal le be sehay ngo kasubguy uwal.” Iwe ngo Jesus sa hasiyaloh yal hapatpat le ye sor bo, “Ha talenga hare yor talengmi!” ");
INSERT INTO uli_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mokwe redabeyel Jesus re kasiya hare meda fael fiyong we. ");
INSERT INTO uli_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus yesa kangalur bo, “Repiy la ye llebag le kofal mala Lamliyel Deus ila yesa yoh ngalugmi. Iwe ngo yarmat cholop ila fiyong mele ye teptap bo yebe hamdefa meka ngalir, bo mil mala haremwo re kaloh kaloh ngo re towe wiri, ngo rela talenga talenga ngo re towe medaf. ");
INSERT INTO uli_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Iye mele fael fiyong we: faesol ire we ila mala yalol Deus. ");
INSERT INTO uli_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Faesol ire kowe ye pungdiy lal yalap ila ye wochog rechokla re rongrong mala yalol Deus ngo Satan ye budoh yesa hachuya mo lal deper bo deyoh le rebe chepar re sala molow. ");
INSERT INTO uli_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Iwe ngo faesol ire kowe ye pungdiy lobos kowe ye faesfos ila ye wochog rechokla re rongrong mala yalol Deus ngo ye rraeyloh lal deper iyang. Iwe ngo yete sulay ngalir bo ye temachlong lal deper. Re bela chungu weres ngo ye ttir yal pung tangir yar tugul. ");
INSERT INTO uli_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Iwe ngo faesol ire kowe ye pungdiy luwul ire kala yor chil ila ye wochog rechokla re rongrong mala yalol Deus ngo yar merahrah irel molow le yar wol talop mo yar hachangi mekla mmaler mele yesa totawoloh mala yalol Deus sala tor uwal mala yalol Deus mo irer. ");
INSERT INTO uli_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Iwe ngo faesol ire kowe ye pungdiy loboka ye momay bol iyang ila ye wochog rechokla re rongrong mala yalol Deus iwe ngo ye mmochlong lal deper, iwe resa yedamgel chog yee la yor uwal mala yalol Deus mo irer. ");
INSERT INTO uli_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Tor semal le be hagsu sew habul yesa yetolong fael sew tapiy hare fael bet. Sima far hasi siya yetedah wol mokwe liliyel habul bo bela bulong semal ngo be wiri werel habul we. ");
INSERT INTO uli_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Te tugul sew formel le ye llebag ngo yebe llahloh. Ngo te tugul sew formel le be mel luwul ruchupung ngo be llahloh lal werloh. ");
INSERT INTO uli_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ila ha itol dipmi irel yami ma hataleng bo semal le yor formel irel ngo yebe wol yoh ngali tot. Iwe ngo semal le tor formel irel ngo lepal sugfed le ye mel irel ngo rebe wol hasi tangi.” ");
INSERT INTO uli_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mokwe wol bisil Jesus mo molwe sil re budoh irel ngo ye teyoh le re rol wer fengal bo sa cholop yarmat irel. ");
INSERT INTO uli_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iwe ngo semal yesa kangalu Jesus bo, “Molwe solom mo mokwe wol bisim ikala re mel ligtam le re dipli bo habe rol wer fengal.” ");
INSERT INTO uli_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus yesa kangalur bo, “Rechokla re rongrong mala yalol Deus ngo re itol deper iyang mele seley mo bisiy.” ");
INSERT INTO uli_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Seral le Jesus mo mokwe redabeyal re dage seyay boat ngo Jesus yesa kangalur bo, “Siya loh mo rel laom le rela sere.” Iwe resa loh. ");
INSERT INTO uli_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yodwe re teteragloh ngo Jesus yesa masor loh. Re tedaploh chog ngo yesa kkel doh sew yaeng lal laom we ngo yesa momos boat we, ngo resa mel luwul hammerah. ");
INSERT INTO uli_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mokwe redabeyal resa faengludah ngo resa kangalu bo, “Masta, Masta! Sible mes!” Yesa chemdah Jesus yesa malili ngal yaeng mo lokowe re sala possloh. Iwe sala malululoh. ");
INSERT INTO uli_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iwe ngo yesa kasiyar bo, “Ifa tugul we yami?” Ir resa lluwdah ngo re motog ngo resa kasiy fengal uwor. “Itey mal le yebe malili ngal yaeng mo law ngo rema talenga yalol?” ");
INSERT INTO uli_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesus mo mokwe re dabeyal resa teragloh irel mekla faluyel Gerasa le ye mel rel Laom we Galilee rela sere. ");
INSERT INTO uli_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yodwe yela hola fulu ngo Jesus sala chungu semal mall haplom we le yor moniyan uwol. Yesa sulay yal tayma mengag ngo tayma mel lubugtal bo sa mamel fedal chog luwul tot pey. ");
INSERT INTO uli_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yodwe mal we yela wiri Jesus ngo yesa tawul le ye hapalingi yalol. Ngo yesa hachepragidiy mo imol Jesus ngo yesa malili moniyan we uwol le ye hapalingi yalol. “Jesus le Lol Deus le ye Hartal Tagiyet meda mele ho luluwale ngalyey? Fael pechem ngo ho towe hafohoyuyey!” ");
INSERT INTO uli_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Moniyan we ye sor mele bo fal mala Jesus yesa kangalu bo be chuy mo uwol mal we. Yesa cholop yodka yema kkel doh moniyan wol mal we le haramwo re chena paol mo pechel ngo yema musdu. Iwe ngo moniyan we yesa hasiloh lobokla le ye tolmayloh. ");
INSERT INTO uli_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus yesa kasiya mal we bo, “Ifa idem?” Iwe yesa sor bo, “Ngang Buwa.” Ye sor mele bo fal mala ye cholop moniyan uwol. ");
INSERT INTO uli_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Moniyan kawe resa hafal pechey Jesus bo towe fang diy ier lal Infiyerno. ");
INSERT INTO uli_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ye mel sew mwodol pabiy lengcher le re momongoy wol sew teplag. Ngo moniyan kowe resa hafael pechey Jesus bo be tahcher bo re bela mel uwol pabiy kowe. Iwe yesa tahcher. ");
INSERT INTO uli_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iwe moniyan kowe resa chuy mo uwol mal we re sala mel uwol pabiy kowe. Resa hamdawey pabiy kowe mo wol metal teplag we resa muslong lal chael we yar malom loh. ");
INSERT INTO uli_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chol hamongol pabiy kowe re wiri mokwe ye weldoh. Iwe re sala sor fedal luwul haplom ngo re wol kangalur chol milay. ");
INSERT INTO uli_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Resa roloh yarmat bo rebe kemahoy mele sa wel. Rela budoh irel Jesus re sala wiri mal we le ye mel lengchel le sa chuy moniyan mo uwol, ngo yesa mengag, ngo yesa repiy. Panger rechokwe ngo resa motog. ");
INSERT INTO uli_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Rechokwe re wiri molwe ye wel resa kangalur rechokwe re moch budoh sangsengal yael Jesus hachuya moniyan mo uwol mal we. ");
INSERT INTO uli_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iwe ngo pangal yeramtal fulu we ngo resa kangalu Jesus bo be chuy bo yesa kkel yar motog. Iwe Jesus yesa chudah yuchul boat we sa loh. ");
INSERT INTO uli_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mal we sa chuy moniyan mo uwol yesa hafaelpech ngal Jesus le ye sor bo, “Fael pechem ngo ibe daboh.” Iwe ngo Jesus sa halho le ye kangalu bo, ");
INSERT INTO uli_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hola tefael loh lubugtam bo ho bela sor mokwe Deus sa faor ngalug.” Iwe mal we yesa loh luwul haplom we ye sala sor fedal mokwe Jesus yesa faor ngali. ");
INSERT INTO uli_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yodwe Jesus yela tefael ngal rel chael we sere ngo resa tteydoh yarmat bo rebe habngu bo resa rraey irel bo sa ssulay yar wedwed loh chog irel. ");
INSERT INTO uli_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iwe ngo yesa budoh semal mal le Jairus idal le iy semal tamol imwel tteywe yar. Yesa hasubgudiy mo imol Jesus ngo yesa hafaelpech bo Jesus yebe dabeloh irel imw la imwal. ");
INSERT INTO uli_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bo mala lol le moch seg mo ruwow lepal ragel ila sa cchow yal tomay ngo ila chog lepal lol tarfefel. Yodwe Jesus ye dedarloh ngo yarmat resa rol hapilsedaw doh mo isre mo isre iy. ");
INSERT INTO uli_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ye mel semal fefel luwulur rechokwe le sa seg mo ruwow raeg yal machpol. Sa tapeliloh lol salpiy irel paliyer togta ngo tor semal ir le ye yoh bo be hachuya yal tomay. ");
INSERT INTO uli_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yesa hadidilong luwul buwa we mo lutugrul Jesus sala yangsi ngachel molwe mengagol. Yodwe chog ngo ye chuyloh yal tomay. ");
INSERT INTO uli_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus sa kasiy, “Itey le ye yangsiyey?” Semal ngo ye sor bo te iy. Pedrus sa sor bo, “Masta, be ifa sengal chog ngo siya gola irel buwa le resa hadibal ngalug.” ");
INSERT INTO uli_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iwe ngo Jesus sa wol sor, “Semal sa yangsiyey, bo imeyafi le ye buyoy kkemal mo uwoy.” ");
INSERT INTO uli_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Fefel we sa gola le yarmat resa gola bo iy molwe, iwe ngo yesa budoh irel Jesus le yesa rerer irel yal rusmes. Ye sala hasubgudiy mo imol Jesus. Fefel we yesa kangalu Jesus mo imol pangal yarmat fael mele yela yangsi iyang mo igegel ttiril yal chuyloh yal tomay. ");
INSERT INTO uli_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iwe Jesus yesa kangalu bo, “Layi, yam tugul mele yesa hachuya yam tomay. Ho loh luwul hopos.” ");
INSERT INTO uli_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yodwe ye chil kapatpat Jesus ngo semal re kakal hapatpat yesa budoh mo irel imw we imwel Jairus sa kangalu Jairus bo, “Sa mes molwe lom. Le maila yam hamachluku fedaley Sensey la.” ");
INSERT INTO uli_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus ye rongrong molwe ngo yesa kangalu Jairus bo, “Ho towe rusmes. Yebe luglug lal depom ngo be molow tefael mala lom.” ");
INSERT INTO uli_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yodwe yela hola doh imw we ngo te depal le yarmat rebe dabeylong yilim. Halachog Pedrus mo John mo James mo molwe sil mo temal yalwich we mele re bulong. ");
INSERT INTO uli_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pangal yarmat lobowe ngo resa tetangdi yalwich we ngo Jesus yesa kangalur bo, “Ha towe rol tang bo yalwich le ila yete mes bele yal masor chog.” ");
INSERT INTO uli_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Resa mmaligli bo re gola le sa mes yalwich we. ");
INSERT INTO uli_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesus yesa holu molwe paol yalwich we ngo yesa kangalu bo, “Chemdah!” ");
INSERT INTO uli_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yodwe chog yesa molow tefael tarfefel we. Iwe ngo sa chemdah. Ngo Jesus yesa kangalur bo rebe fang hal tarfefel we bo yebe mongoy. ");
INSERT INTO uli_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Re lluwdah mokwe wulutugul yalwich we irel molwe. Iwe Jesus yesa kangalur bo tor semal le rebe kangalu kofal molwe. ");
INSERT INTO uli_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus ye ffesang fengalir chowe seg mo rumal. Yesa fang kkameler mo kkeler bo be yoh le rebe hachuchu moniyan mo metmetal tomay mo uwol yarmat. ");
INSERT INTO uli_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yesa hagloyur bo re bela foloyu ngal yarmat kofal mala Lamliyel Deus ngo re hachuya yar yarmat tomay. ");
INSERT INTO uli_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Imol molwe Jesus yebe hagloyurloh ngo yesa kangalur bo, “Ha bele loh irel malekah le tor mele habe hasi. Ha towe kak sohmi mo yami botow mo yami paey mo lomi salpiy. Liwilil mwo mekla mengagmi ngo ha towe kak. ");
INSERT INTO uli_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Te tugul sew imw solboy le rebe hammalgumi mo iyang ngo hasa mel chol irel imw yee la hola yodla habe chuytang haplom la iyang. ");
INSERT INTO uli_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sew haplom le yarmat rebe te hammalgumi mo iyang ngo hasa yuchgaloh bol haplom la mo irel pechemi bo habe hagulal ngalir bo tayikof molwe resa foru.” ");
INSERT INTO uli_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iwe resa loh chowe seg mo rumal wol sew mo sew haplom bo re bela foloyu kofal Hapatpat Momay we ngo re hachuya yar yarmat tomay. ");
INSERT INTO uli_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yodwe Yerodes we tamol wol Galilee yela rongrong kofal pangal mokwe yesa weldoh ngo sa kkel yal somawel fedal bo tot yarmat re sor bo Johannes Baptista yesa molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Iwe ngo sibis re sor bo yesa llahdoh Elijah ngo tot re sor le semal profeta kowe muswe mele yesa molow tefael. ");
INSERT INTO uli_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yerodes sa sor bo, “Ngang molwe isor bo rebe supiloh molwe chemel Johannes. Ila ngo itey mal le isa rongrong kaptal?” Iwe ye sala ye yedamgel fedal mele be yoh le be wiri Jesus iyang. ");
INSERT INTO uli_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Rela tefael chowe seg mo rumal resa budoh kangal Jesus pangal mokwe resa foru. Iwe Jesus yesa palir resa loh wol sew haplom le Bethsaida idal le rol ir chog. ");
INSERT INTO uli_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yodwe yarmat cholop rela rongrong kofal yal loh ngo resa meriloh. Jesus yesa ffesangur sa kangalur kofal molwe Lamliyel Deus ngo ye hachuya yar tomay rechokla re tomay. ");
INSERT INTO uli_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yela harep dolol yaal ngo chowe seg mo rumal resa budoh irel Jesus resa kangalu bo, “Hole halahor yarmat bo rebe loh woal milay kala ye repdoh mo hasohsoh bo re bela ffaeg fedal haler mo lobos le rebe mel iyang. Lobos le ila ye halugloh ngo tor loh formel iyang.” ");
INSERT INTO uli_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iwe ngo Jesus yesa kangalur bo, “Ha fang haler hami.” Iwe ngo resa sor bo, “Hal limay flowa mo rumal yig mele ye mel iremem. Hare ho luluwaley bo habe loh ha bela chuwaydoh haler buwa le iye leper?” ");
INSERT INTO uli_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Malbo be limngeras mal lobowe.) Jesus yesa kangalur mokwe redabeyal bo, “Ha kangalur yarmat bo rebe marodiy le rebe sew mo sew buwa le be kalemeg iyang.” ");
INSERT INTO uli_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yela mol yar mokwe redabeyal foru mokwe ye sor, ");
INSERT INTO uli_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ngo Jesus yesa hasi flowa we limay mo yig we rumal sa kaledah wol laeng, sa kangalu Deus yal hachigchig sa depiy flowa kowe mo yig kowe sa ngaler mokwe redabeyal bo re be yildi uwor yarmat. ");
INSERT INTO uli_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Panger yarmat ngo re mongoy ngo ye laploh haler iyang. Mokwe redabeyal resa hateyili fengali lutgul mongoy kowe ngo ye ssog seg mo ruwow bachebach iyang. ");
INSERT INTO uli_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Seral le Jesus loh chog yal memapel ngo mokwe redabeyal resa budoh irel. Iwe ngo Jesus yesa kasiyar bo, “Yarmat dolap re sor bo Ngang itey?” ");
INSERT INTO uli_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iwe ngo ir resa sor bo, “Sibis re sor bo gel Johannes Baptista ngo sibis re sor bo gel Elijah ngo wol tot re sor bo gel semal profeta kowe muswe le yesa molow tefael.” ");
INSERT INTO uli_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Iwe ngo Jesus yesa kasiyar, “Iwe ngo hami ha sor bo Ngang itey?” Pedrus yesa sor bo, “Gel Kristus we ye budoh mo irel Deus.” ");
INSERT INTO uli_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iwe ngo Jesus yesa kangalur ngalir bo, “Ha hafali chog bo tor semal le habe kangalu le ngang Kristus. ");
INSERT INTO uli_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesus ye wol kangalur bo, “Mala Layur Retalop ila yebe kkel yal hafohoy. Mal kowe yar mo tamol temarong kowe mo mokwe sensel Hatobtob we re bele fangloh iy. Rebe limeseloh ngo bela solral mo wol miril ngo yebe molow tefael mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesus yesa kangalur pangarloh, “Hare semal ye dipli bo be dabeyey ngo be maliglaloh kofal lufulyal ngo pangal ral ngo be hasi yal krud yesa dabeyey. ");
INSERT INTO uli_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Semal le yebe hachangi yal nngas ngo yebe pung tangi, ngo te tugul semal le yebe mes le fal ngang ngo yebe molow. ");
INSERT INTO uli_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Meda mmalel semal le ye bela lamliloh faileng le ngo ye teyoh ngali molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hare semal le be maa irey mo foloy ka yai ila ngo mala Layur Retalop be wol maa irel. Irel yodla yebe budoh luwul falmay la yal mo mala Temal mo angelus kala re santus. ");
INSERT INTO uli_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ibe hatugulu ngalugmi le yor tot yarmat le re mel iga le re towe pagel mes ngo resa wiri mala Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bele sew week mo wol miril yal sor meka ngo Jesus yesa pali Pedrus mo John mo James resa bidah wol sew tayit bo re bela mapel. ");
INSERT INTO uli_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yodwe Jesus ye memapel ngo sa wel loh woal molwe metal. Iwe ngo mokwe mengagul ila sa bbechragloh le ye mmaluplup. ");
INSERT INTO uli_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Re tedaploh ngo sa mel rumal mal irel Jesus le resa kapatpat ngali. Mal kowe ila Moses mo Elijah. ");
INSERT INTO uli_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Re lahdoh luwul mala falmayel laeng le re kakapta kofal yal bela foru mala depel Deus le iy Jesus bele la mes wol Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrus mo mokwe choluwal resa rol kkul masorloh. Rela mmatloh re sala wiri falmay we yael Jesus mo mal we rumal we re su lengchel. ");
INSERT INTO uli_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yodwe re loh chowe rumal ngo Pedrus yesa kangalu Jesus bo, “Masta, ifa lepal momayel mele hamem hala mel iga! Ha bele hasu suluw imw bo sew imwom, ngo sew imwel Moses ngo sew imwel Elijah.” (Pedrus ye sosor mokwe le ye togla fal.) ");
INSERT INTO uli_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yodwe ye chil kapatpat ngo sedep darmi sa llurdoh uwor ngo yesa kkel loh yar motog mokwe re dabeyel Jesus irel darmi we yesa halururloh. ");
INSERT INTO uli_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iwe ngo yesa mmalilidiy Deus mo luwul darmi we le ye sor bo, “Iye mele layi le iy hartal hachangi, ha talenga yalol!” ");
INSERT INTO uli_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yodwe la ppoloh yalol yarmat we ngo sa Jesus loh chog mele ye mel loboswe. Ngo mokwe redabeyel Jesus rete kapta kofal mele. Tor semal le re kangalu fael yodla mokwe re wiri. ");
INSERT INTO uli_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ralawe seral ngo Jesus mo mokwe redabeyal we solmol re sala bidiy mo wol tayit we ngo sew buwal yarmat resa budoh irel Jesus. ");
INSERT INTO uli_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Semal mal yesa tawul mo luwul buwa we le ye sor bo, “Sensey, fael pechem ngo hobe kemahoy tarmal le layi bo iye chog layi iye. ");
INSERT INTO uli_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yebe ddidoh moniyan la uwol ngo yema tawul ngo ye piyom ngo ye buyoy burbur mo lal yewal. Iwe ngo moniyan le yema hawsu fedaley ngo ye weres le yebe chuy mo uwol. ");
INSERT INTO uli_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iy sa hafael pecher meka redabeyem bo rebe hachuya moniyan le mo uwol ngo ye temmal ngalir.” ");
INSERT INTO uli_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus yesa sor bo, “Ila lepal yami te luglug mo machey! Be ifa lepal sulayel yai mel ngalugmi ngo hasa moch medaf? Be ifa lepal yai halelayiloh chog repiyey iremi?” Iwe ngo yesa kangalu mal we bo, “Hasidoh tarmal la lom iga.” ");
INSERT INTO uli_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yodwe yesa bubudoh tarmal we ngo moniyan we uwol yesa pedadiy wototol le yesa piyom. Jesus yesa kkasigsig ngal moniyan we bo be chuy mo uwol tarmal we. Iwe ngo yesa chuy moniyan we mo uwol ngo Jesus yesa hatefali tarmal we ngal molwe temal. ");
INSERT INTO uli_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iwe ngo panger rechokwe ngo re lluwdah irel kkelel mala kkamelal Deus. Yarmat re chil luluwaley fedaley pangal mokwe Jesus ye foforu ngo Jesus yesa kangalur mokwe redabeyal bo, ");
INSERT INTO uli_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ha towe maligli mele ibele kangalugmi! Mala Layur Retalop ila ye bele yoh long lal payur yarmat.” ");
INSERT INTO uli_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iwe ngo mokwe redabeyel Jesus re togla fael molwe ye kangalur. Fal mele ila Deus ye hamwalo tangir bo rede medaf iyang ngo ir re motog bo rebe kasiy kofal molwe. ");
INSERT INTO uli_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Resa rol happaliyel fengal mokwe redabeyel Jesus hare itey semal mo luwulur le ye hartael tagiyet. ");
INSERT INTO uli_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus ye gola luluwal kowe yar. Iwe yesa hasi semal yalwich yesa hasu lengchel. ");
INSERT INTO uli_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Iwe yesa kangalur bo, “Te tugul semal le yebe hammale semal tappel yalwich le, le fal mele idey ngo ye hammalyey. Iwe ngo te tugul semal le yebe hammalyey ngo ye wol hammale yeramtala ye fangdoh ngang. Yeramtala ye hartael totol mo luwulumi pangmiloh, ila yeramtala ye hartael tagiyet.” ");
INSERT INTO uli_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John yesa sor bo, “Masta, ha wiri semal mal le ye kkachuchu moniyan fael idem. Iwe ngo hasa kangalu bo yebe ppoloh bo te iy chilach.” ");
INSERT INTO uli_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus sa kangalur mo mokwe redabeyal bo, “Ha towe hapolaho bele semal le be tema happaliyel ngalugmi ngo iy choluwami.” ");
INSERT INTO uli_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yodwe sa harep yael Jesus loh wol laeng ngo yesa hatugulu mo lal depal le bele loh Jerusalem. Iwe sa chuy sa loh. ");
INSERT INTO uli_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yesa hamwowar loh mokwe re kakal yalol irel sew haplom mo wol Samaria bo re bela hafle pangal formel. ");
INSERT INTO uli_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Iwe ngo yeramtal haplom we rete dipli bo Jesus yebe budoh irer bo resa faesul gola bo iy le ye loloh Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yodwe James mo John we redabeyal rela gola molwe ngo resa sor bo, “Samol, ho dipli le habe fofosdiy yaef mo wol laeng bo be bidiy llirloh?” ");
INSERT INTO uli_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesa tagul Jesus sa kkaftoroy ngalir. ");
INSERT INTO uli_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Iwe Jesus mo mokwe redabeyal resa loh mo wol sew haplom. ");
INSERT INTO uli_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yodwe re loloh ngo semal mal yesa kangalu Jesus bo, “Te tugul lobos le hobe loh iyang ngo ngang ibe daboh.” ");
INSERT INTO uli_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus yesa kangalu bo, “Fox mwo ngo yor liliyer, ngo mael yeyal ka ngo yor hafter, ngo mala Layur Retalop ila tor solbos le liliyel yal hasoso.” ");
INSERT INTO uli_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesus yesa wol kangal semal mal bo, “Dabeyey.” Mal we yesa sor bo, “Ibe loh mwo ibela leba mala temay.” ");
INSERT INTO uli_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus sa kangal mal we bo, “Ligdir chomes bo rebe leba yar mes. Ho loh ho bela foloyu ngalir yarmat kofal mala Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Semal mal sa wol sor bo, “Samol, ibe daboh ngo hal ila ibe loh mwo ibela habungur mekla yeramtay.” ");
INSERT INTO uli_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus yesa kangalu bo, “Semal le be kamchogchogu bol yal milay ngo ye kekal tefael chog, ila ngo iy ila tor pelal ngal mala Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yela wol miril meka ngo Samol yesa duwler fisig mo rumal mal ngo yesa hagloyurloh le re rumal mo rumal le rebe hamwoloh mo imol wol sew mo sew haplom mo pangal lobos kala iy yebe loh iyang. ");
INSERT INTO uli_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesa kangalur bo, “Sa cholop uwal milay ngo ye telap chol yengang le rebe hateyili fengali. Ha mapel ngal yeramtala yal milay la bo yebe fang chol yengang bo rebe hateyili uwal milay le yal. ");
INSERT INTO uli_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ha loh! Iy bele halhohmi le habe wochog fadiyel saaf luwulur bolof. ");
INSERT INTO uli_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ha towe kak yami hagech hare botow ngo ha towe bwela. Iwe ngo ha towe keketalmoch fedal irel yami habungur yarmat mo lal yalap. ");
INSERT INTO uli_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te tugul sew imw le habe bulong iyang ngo metamol mala habe sor ila, ‘Hopos be mel irel imw le.’ ");
INSERT INTO uli_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hare yor semal yarmat le ye pos mo lal imw la ngo hasa fang yami hopos ngali. Iwe ngo hare tor ila ngo ha towe fang. ");
INSERT INTO uli_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ha peslag chog irel sew imw, ha mongoy ngo ha yul mekla rebe fang ngalugmi bo chol yengang ila ma yor paliyer. Ha towe chuy mo irel sew imw ngo ha loh mo irel sew. ");
INSERT INTO uli_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Te tugul sew haplom le hala budoh iyang ngo re hakkula ngalugmi ngo hasa mongoy mekla rebe fang ngalugmi. ");
INSERT INTO uli_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hasa hachuya yar yarmat tomay ngo hasa kangalur bo mala Lamliyel Deus ila yesa harpar. ");
INSERT INTO uli_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Iwe ngo sew haplom le ha bela hola doh ngo rete hakkula ngalugmi ila ngo hasa chuy mo iyang hasa buyoy lal yalap ngo hasa sor bo, ");
INSERT INTO uli_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Boll mwo haplom le ye pach ngal meka pechemem ngo ha bele yuchgaloh bo hami habe gola le tayikof mekla ha foforu. Ngo hal ila habe gola le mala Lamliyel Deus ila sa harep ngalugmi.’ ");
INSERT INTO uli_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Isa hatugulu ngalugmi le bela hola yodla Rael Tatelal Hapatpat ngo Deus yebe kawraloh le ye kkel yal fahoy Sodom mo imol haplom la! ");
INSERT INTO uli_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ha tehafohoy hami yeramtal Chorazin! Iwe ngo be wol ifa lepal yami hafohoy hami yeramtal Bethsaida! Bo hare kkemal ka, re foru mo wol faliyey mele re foru mo wol Tyre mo Sidon ila ngo sa ssulay chog yar marrodiy resa mengag tutuw ngo re hamormordah felang uwor bo rebe kawraloh le resa tagul tang mekla molfidir. ");
INSERT INTO uli_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Irel yodla Rall Tatelal Hapatpat ngo Deus yebe kawraloh le ye kkel yal ffaho depal ngalir yeramtal Tyre mo Sidon mo imwomi. ");
INSERT INTO uli_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iwe ngo hami yeramtal Capernaum, hasa depli le habe hatagitahmidah bo habe hola laeng? Hami ila habe ppungdiy infiyerno!” ");
INSERT INTO uli_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesus yesa kangalur mokwe redabeyal bo, “Semal le yebe talenga yalomi ila ngo ye talenga yalol. Iwe ngo semal le be te talenga yalomi ila ngo te talenga yaloy, iwe ngo yete talenga yalol yeramtala ye fang doh Ngang.” ");
INSERT INTO uli_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Rela tefael le sa rraey lal deper. Resa sor bo “Samol, moniyan mwo ngo re talenga yalomem irel kkamelal mala Idem!” ");
INSERT INTO uli_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus yesa sor bo, “Isa wiri Satan le ye wochog ffis yal ppungdiy mo wol laeng. ");
INSERT INTO uli_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ha talenga! Isa fang kkelmi bo be yoh le habe darloh wol parchoyoh mo sil mallebong ngo ha lliyloh mala kkelel Satan ngo tor mele habe waes iyang. ");
INSERT INTO uli_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ha towe cchehasel mala moniyan yesa talenga yalomi bo mala habe cchehas iyang ila mekla yidmi le sa teftaf mo wol laeng.” ");
INSERT INTO uli_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Irel yodla ngo Espritu Santus yesa hakkela yael Jesus rraey. Iwe ngo Jesus sa sor bo, “Temay Deus, le gel Samolel laeng mo talop! Ibe kangalug yam hachigchig bo hosa kewar ngalir rechokla tor mele re gola mekla ho lebagli tangir rechokla re sor bo re repiy ngo re sallap. Temay Deus, ye katos le iye sengal mala gel ho dipli le hobe foru. ");
INSERT INTO uli_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Mala Temay sa fang ngalyey pangal formel. Tor le ye gola mala Lol bo halachog mala Temal, ngo tor le ye gola mala Temal bo halachog mala Lol iwe mo rechokla mala Lol yesa duwler bo yebe hagelal ngalir iy mala Temal.” ");
INSERT INTO uli_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yodwe, ila ir loh chog ngo Jesus sa tagul ngalir mokwe redabeyal ngo yesa sor bo, “Ha teyolbuw le ha sala wiri mekla hasa wiri! ");
INSERT INTO uli_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ibe kangalugmi le ye cholop profeta mo king le re yelyal bo rebe wiri mekla hami hasa wiri ngo rete wiri. Iwe ngo re yelyal bo rebe rongrong mekla hami hasa rongrong ngo ir re tarongrong.” ");
INSERT INTO uli_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Semal mokwe sensel Hatobtob we ye budoh bo ye luluwaley le yebe hagla Jesus. Iwe ngo yesa kasiya Jesus bo, “Sensey, meda mele ibe foru ngo sa yoh ngalyey molow la tor siyal?” ");
INSERT INTO uli_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus yesa sor bo, “Meda mele Babior we ye Santus ye sor? Be ifa sengal yam hamdefa?” ");
INSERT INTO uli_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iwe mal we yesa sor bo, “‘Hobe hachengi Samol la yam Deus mo lal depom, mo irel ngulum, mo irel kkelem, mo irel yam luluwal’; Iwe ngo ‘Hosa hachangir yarmat le be wochog yam gel hachangug.’” ");
INSERT INTO uli_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus sa sor bo, “Tusurem. Hobe foru mala ngo hobe molow.” ");
INSERT INTO uli_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Iwe sensel Hatobtob we ye dipli le be kawraloh le tusurel irel mokwe ye sosor. Iwe yesa kasiya Jesus le ye sor bo, “Itey ir mekla ibe hachangir?” ");
INSERT INTO uli_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus yesa sor bo, “Fael sew yad ngo ye mel semal mal le ye bibidiy mo Jerusalem le be loh Jericho ngo chomachog resa ddorfi, resa ddeyi mokwe mengagul ngo re lliy le rela ligdi ngo yesa fesugfed ngo sa mes. ");
INSERT INTO uli_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yela ppalu ngal yodle, ngo semal temarong mele yela dabediy yalap we sala wiri mal we. Iwe sa loh sala dar mo rel yalap rewe sere. ");
INSERT INTO uli_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wol ila sengal semal Levite bo ye wol la budoh sa loh sala kemahoy yeramtawe. Iwe ngo sa wol loh sala dar mo rel yalap rewe sere. ");
INSERT INTO uli_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Iwe ngo semal yeramtal Samaria yela dar doh lobowe sala ppaludah wol mal we. Ye wiri chog ngo sa ddidoh yal fahoy. ");
INSERT INTO uli_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yesa budoh irel sa chalfi mokwe giltal ngal gapgep mo wine, iwe sa dugmi ngal mengag. Iwe sa hasi mal we yesa yetedah wol mael we lol sa hasiloh irel sew im kowe imwer wasola bo yebe la hamale mo iyang. ");
INSERT INTO uli_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","La ralowe seral ngo yesa hasi rufaes faesol salpiy sa ngaley yeramtawe imwal imw we. Iwe yesa kangalu bo, ‘Hosa hammale yeramtale. Ibela tefaeldoh ngo lepal mele hosa hammale ngali ngo ibe wol fang paliyal.’” ");
INSERT INTO uli_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iwe ngo Jesus sa hasiyaloh fiyong we yal ngo sa kasiya mal we bo, “Yalel depom ngo ifa semal mo irer chowe solmol le ye hachangi mal we chomachog re lliy?” ");
INSERT INTO uli_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Iwe ngo sensel Hatobtob we yesa sor bo, “Yeramtawe ye hammale.” Iwe ngo Jesus yesa kangalu bo, “Ho loh ho sala foru le be ila sengal.” ");
INSERT INTO uli_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus mo mokwe redabeyal re loloh ngo Jesus yesa bulong woal sew haplom ngo semal fefel le Martha idal yesa ffesangu loh irel mala bugtal. ");
INSERT INTO uli_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ye mel semal fefel bisil Martha le Mary idal. Ye sala maro lengchel mokwe pechel Samol sa tetalenga foloy kowe yal. ");
INSERT INTO uli_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Iwe sa lolmoch Martha irel lepal mokwe ye foforu. Yesa budoh irel Jesus ngo yesa kangalu bo, “Samol, hote hafaliloh le mele bisiy sa tahche ngalyey pangal yengang ka bo be ngang chog yai foru? Kangalu bo yebe budoh tipingyey!” ");
INSERT INTO uli_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Samol sa sor bo, “Martha, Martha, ye cholop mekla hosa marhagili loh chog le tay pos depom iyang. ");
INSERT INTO uli_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ngo sew chog formel mele ye paleng pelal. Mary yesa duwley ila ye bung ngo tor semal le yebe hasi tangi.” ");
INSERT INTO uli_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Seral ngo Jesus ye memapel solbos le ir mo mokwe redabeyal. Yela mol mo irel mapel ngo samel mokwe redabeyal yesa kangalu bo, “Samol, kangalugmem mapel le be wochog yael Johannes ma kangalur mokwe redabeyal.” ");
INSERT INTO uli_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iwe Jesus yesa kangalur bo, “Habe mapel, ngo habe ma sor bo: ‘Tamem: Yebe ssoar mala Idem le ye santus; Yebe budoh ngalugmem mala Lamliyem. ");
INSERT INTO uli_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fang halmem seral mo seral. ");
INSERT INTO uli_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ffaho depom ngalugmem irel yamem molfid, bo hamem ila yema ffaho depmem ngalir rechokla re tayikof ngalugmem. Ho towe hasugmemloh luwul hagelgel kala ye weres.’” ");
INSERT INTO uli_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesus yesa kangalur mokwe redabeyal bo, “Hare ye wochog bo sa lugulbong ngo semal hami yesa loh irel imwel mala maryerel ngo sala kangalu bo, ‘Fang ngalyey mwo sulyoy flowa. ");
INSERT INTO uli_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Semal maryerey iye moch budoh mo irel malekah ngo tor mele iy be fang bo hal mo irel imw la imwey!’ ");
INSERT INTO uli_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ngo hare ye wochog bo iy molwe maryerel yesa maliliwey mo yilim le ye sor bo, ‘Ho towol hachrong ngalyey bo sa lok hatam ngo ngang mo meka layi ngo hasa masor. Itowol chemdah bo ibe fang ngalug formel.’ ");
INSERT INTO uli_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ila ngo be ifa sengal? Ibe kangalugmi le ila mwo yete depal yebe chemdah ngo yebe chemdah bo yebe fang ngalug flowa mo pangal mekla ho temmal iyang le te fal mala ha mareyar bo fal mala hote maa, le hobe dongorloh chog formel. ");
INSERT INTO uli_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ila iy be kangalugmi: Habe dongor ngo be yoh ngalugmi; habe meri ngo habe wiri; hobe hapungpungu hatam ngo be sugeg ngalug. ");
INSERT INTO uli_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bo te tugul semal le be dongor ngo be yoh ngali, ngo semal le be meri ngo be wiri, ngo semal le be hapungpungi hatam ngo yebe sugeg ngali. ");
INSERT INTO uli_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Be yoh le semal hami mal kala yor lol, le lol yebe dongor hall yig ngo iy yesa fang ngali semal parchoyoh? ");
INSERT INTO uli_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Hare lol yebe dongor hall faiyel maelog ngo iy yesa fang silmaelobong? ");
INSERT INTO uli_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hami mwo mele ha tayikof, ngo ha gola mekla ye momay le habe fang ngal mekla lomi. Ila ngo be ifa lepal kkelel mala kkamelal Espritu Santus le laeng yebe fang ngalir rechokla re dedangro!” ");
INSERT INTO uli_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus ye hachuyaloh semal moniyan mo uwol semal mal le tay ma maliliy. Yodwe yela chuy moniyan we ngo yesa yoh le mal we ye kkapatpat. Ye lluwdah buwa we irel molwe. ");
INSERT INTO uli_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Iwe ngo tot yarmat re sor bo, “Mala ila Beelzebul we tamol moniyan, mele ye fang kkelal bo yebe hachuchuy moniyan.” ");
INSERT INTO uli_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Iwe ngo tot yarmat re luluwaley bo rebe hagla Jesus iwe resa kangalu bo be foru sew kkemal le be kawraloh le ye fel depel Deus ngali. ");
INSERT INTO uli_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngo Jesus ye gola mokwe re luluwaley iwe yesa kangalur bo, “Chol sew fuluy le rebe te sew chog bo re fefedeg fengal ila ye towe sulay yar mel. Ngo chol sew bugat le rebe te depsew chog ngo rebe taroprop. ");
INSERT INTO uli_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Iwe ngo hare be harere mala lamliyel Satan ngo resa rol fedeg fengal ngo be ifa sengal ngo resa molow? Hami ha sor le ima hachuchuy moniyan bo fal mala Beelzebul mele ye fang kkeley. ");
INSERT INTO uli_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hare Beelzebul mele ye fang kkeley bo ibe hachuchuy moniyan, ila ngo itey le ye fang kkeler mokwe choluwami bo rebe ma hachuchuy moniyan? Mokwe choluwamiy resa kawraloh le hami ha tabung! ");
INSERT INTO uli_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yeab, te ila sengal. Ima hachuya moniyan irel mala kkelel Deus. Iwe ngo ila mele yesa kawraloh le mala Lamliyel Deus ila yesa holahmi. ");
INSERT INTO uli_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Hare semal mal le ye kkel ngo yor yal pitgil fedeg yebe matngali imw la imwal ila ngo ye towe taroprop mekla lital. ");
INSERT INTO uli_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Iwe ngo hare semal le ye kkel tot mo imol ye budoh yesa fedeg ngali sala lliy, ila ngo bele hasiloh pangal pitgil fedeg kowe mal we ye yetedah depal uwol ngo bele hasi sa yilldi fedaley mokwe litael mal we, we ye pera. ");
INSERT INTO uli_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Semal le te ppilyey ila ngo ye hattohar ngalyey; ngo semal le yete tipingyey irel hatteyel yarmat ngo iy ila ye kkataropropar yarmat. ");
INSERT INTO uli_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Yodla ye bela chuy semal moniyan mo uwol semal yarmat ngo ye bele la darfedal lal tolmayloh kala ye palpal bo be meri solbos le ye bela hasoso mo iyang. Ngo hare tor solbos le ye wiri ngo bele sor bo, ‘Iy bele tefael ngal yimwe imwey.’ ");
INSERT INTO uli_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iwe ngo bele tefael sala wiri yimwe imwal le sa kilil ngo sa momay. ");
INSERT INTO uli_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iwe ngo bele loh sala fesangurdoh fismol moniyan le ye kkel tot yar tayikof mo imol resa budoh mel loboswe. Iwe ngo sala mel yeramtawe le sa kkel tot yal tayikof mo imol molwe metamo.” ");
INSERT INTO uli_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yodwe yela mol yael Jesus sor molwe ngo yesa maliliy semal fefel mo luwul buwa wele ye sor bo, “Yebe momay depel fefel la ye silaglug ngo ye hafohlah!” ");
INSERT INTO uli_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesus sa hatefali ngo sa sor bo, “Yebe far momay deper rechokla resa rongrong mala yalol Deus ngo re itol deper iyang!” ");
INSERT INTO uli_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yodwe buwa we re langbaloh ngo yesa tabo yal hapatpat ngalir. “Yesa kkel tayikofel yarmat fael mwole. Re dodongor sew kkemal. Iwe ngo tor sew kkemal le rebe wiri bo halachog kkemal we Deus ye faor ngal Jonah mele rebe wiri. ");
INSERT INTO uli_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Profeta Jonah iwe iy mele sew hagil ngalir yeramtal Nineveh ila be wol ila sengal mala Layur Retalop bo yebe mel le wol sew hagil ngalir yeramtal fael mwole. ");
INSERT INTO uli_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yodla Rall Tatelal hapatpat ngo mala Queenel Sheba yebe sudah bo yebe sor derer yeramtal fael mwole, bo igil mala sala malekahdoh mo wol mala faluyal le ye ddawloh bo be talenga folol repiy kala yael King Solomon. Iwe ngo ibe kangalugmi le yor mele ye mel iga le ye tagiyet mo imol Solomon. ");
INSERT INTO uli_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yodla Rall Tatelal hapatpat ngo yeramtal Nineveh rebe sudah bo rebe sor dermi bo igil molwe resa tagul tang molfidir irel molwe re rongrong foloy kowe yael Jonah, iwe ngo ibe hatugulu ngalugmi le yor mele ye mel iga le ye tagiyet mo imol Jonah! ");
INSERT INTO uli_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Tor semal le be hagsu sew habul ngo sa lebagli hare ye yetolong fael sew tapiy. Yebe far hasi yesa yetedah wol mokwe liliyel habul bo bela bulong semal ngo yebe wiri werel habul we. ");
INSERT INTO uli_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mekla metam ila ye wochog sew habul le hawerel mala halongom. Yebe ffod mekla metam ngo pangamloh ngo yebe teram. Iwe ngo yebe tayikof mekla metam ngo pangamloh ngo yebe mel luwul ruchupung. ");
INSERT INTO uli_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hobe llugu depom bo de chuyloh teram la ye mel uwom ho sala mel luwul rochupung. ");
INSERT INTO uli_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hare pangamloh ngo ye teram le tor sugfed mo uwom le ye mel luwul rochopung, ila ngo ho bele teramloh le be wochog bo ye werdah sew habul uwom.” ");
INSERT INTO uli_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yodwe yesa mol Jesus irel hapatpat ngo semal Pharisees yesa ffesngu bo re bela mongoy. Iwe sa bulong marodiy bo be mongoy. ");
INSERT INTO uli_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ye lluwdah Pharisees we irel molwe Jesus yete tela paol mo imol mala be mongoy. ");
INSERT INTO uli_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Samol sa kangalu bo, “Hami Pharisees ila hama tela lugul tohog mo tapiy kala yami ngo mekla dipmi ila ye ssogol tayikof. ");
INSERT INTO uli_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ha rol buch! Te Deus le ye foru mala lugul mele ye wol foru mala lal? ");
INSERT INTO uli_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Habe far fang yadol tohog mo tapiy kala yami ngalir mael hafohoy ila ngo yebe tefoy ngo ye chuy taab mo iyang. ");
INSERT INTO uli_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Be kkel tayikofel lal dipmi Pharisees! Hama tape maligach ngal Deus sugfed mo irel delal mongoy le tappel mint mo rue mo metmetal delal mongoy kala tot iwe ngo ha tolpagliloh ikla ye fel iwe mo hachangchengel Deus. Habe ma foru meka ngo halachog ila ha towe tahcheloh ikla tot. ");
INSERT INTO uli_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ha terol hafohoy hami Pharisees! Ha dipli chog chiya kala liliyer chotagiyet bo ha bela maro iyang mo lal imwel ttey ka. Ngo yarmat re kawraloh yar hasarohmi mo lobos ka liliyel market le rema toa tteydoh yarmat mo iyang. ");
INSERT INTO uli_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ha terol hafohoy! Hasa rol wochog pey kowe tor hagilal le yarmat rema dar fedal uwol ngo re togla.” ");
INSERT INTO uli_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iwe ngo semal sensel Hatobtob we yesa kangalu bo, “Sensey, hosa hamaalugmem irel mekla hosa sor!” ");
INSERT INTO uli_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus yesa sor bo “Iwe ngo ha tehafohoy hami sensel Hatobtob we! Hama yitetdah meka ye cchow uwor yarmat le ye weres ngalir le rebe hasi. Iwe ngo sehad mwo mekla hademi ngo ye teyoh habe halenga habe tipingir irel mekla hasiyer. ");
INSERT INTO uli_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ha tehafohoy! Hasa halimdi hamayu peyer profeta kowe mokwe chapdohmi re limeserloh. ");
INSERT INTO uli_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hami chog ngo hasa kawraloh le ye fel dipmi irel meka, mokwe chapdohmi re foru. Ir re limeseloh profeta kowe ngo hami hasa foru mekla peyer. ");
INSERT INTO uli_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ila fal le molwe Repiyel Samol ye sor bo, ‘Ibele fang ngalir profeta mo re kakal yaloy; ngo ir re bele llir tot ngo re hafohoyur tot.’ ");
INSERT INTO uli_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ila re bele hagrer yeramtal fael mwole bo fael profeta kowe ye chap yar lilimeserloh chog mo irel molwe subdohol talople yee iye sa hola doh igla. ");
INSERT INTO uli_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ye chap mo irel yar limeseloh Abel yee la hola doh yar limeseloh Zechariah we re limeseloh mo lepdal altar we mo Loboswe ye Santus. Ila, re bele hagerger yeramtal fael mwole, le fael profeta kowe resa llir. ");
INSERT INTO uli_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ila ha tehafohoy hami meka sensel Hatobtob we! Hami mele ha hasi kiyel hatemal imwel repiy la iwe ngo hami ha temechal bulong ngo hasa piltar rechokla re ye yedamgel bo rebe bulong!” ");
INSERT INTO uli_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yela wol miril molwe Jesus yesa ligdi buwa we ngo mokwe sensel Hatobtob we mo Pharisees kowe resa kawraloh yar hafobdiri iwe ngo sa cholop kasiy kala resa kasiya, ");
INSERT INTO uli_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bo hare rebe ddorfi yal be sor sew formel le ye machey. ");
INSERT INTO uli_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bele fedngeras yarmat le resa rol hadibal fengal. Jesus ye mol kangalur mokwe redabeyal bo, “Habe hafalugmi irel mekla wegdigir Pharisees le ye wochog habboloh — mele iy ye sor ila kachepar kala yar. ");
INSERT INTO uli_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pangal meka ye mwol hare ye llebag ngo yebe llahloh. ");
INSERT INTO uli_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ila ngo mekla ha kapta luwul rochupung ila yarmat rebe rongrong mo lal werloh. Iwe ngo te tugul mele ha lungu fengali mo yilim ngo yarmat rebe tawulagili fedaley pangal lobos. ");
INSERT INTO uli_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Iy be kangalugmy hami re wol mareyarey le ha towe metagur rechokla re limeseloh holong ngo bela wol miril ngo tayor sew tayikof le be chil yoh le rebe foru. ");
INSERT INTO uli_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Iy be kewar ngalugmi yeramtala habe metagu. Deus mele habe metagu bo iy mele yor kkelal le be wol miril yal limeseloh semal ngo sa ppedilong infiyerno. Ha chepar ngalyey le ila yeramtala habe metagu! ");
INSERT INTO uli_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tema limmal sparrow ngo rufaes cobra checha paliyal? Iwe ngo tor semal mo luwulur le Deus ye maligliloh. ");
INSERT INTO uli_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mekla mwo yael chimi ngo sa mol yael Deus pangi. Ila ha towe motog bele ye paleng pelami mmo imor sparrow ka. ");
INSERT INTO uli_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ibe hatugulu ngalugmi le te tugul semal le yebe kawraloh mo luwul yarmat le iy choluway ngo be wol ila sengal le mala Layur Retalop yebe wol foru ngali mo imor angelus kala lol Deus. ");
INSERT INTO uli_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ngo te tugul semal le yebe kawraloh luwul yarmat le te iy choluway ngo be wol ila sengal le mala Layur Retalop be foru ngali mo imor angelus kala lol Deus. ");
INSERT INTO uli_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Semal le yebe sor sew formel le ye tayikof irel mala Layur Retalop ngo be yoh le be chuy yal molfid. Iwe ngo te tugul semal le yebe hapatpat tayikof irel Espritu Santus ngo towe chuy yal molfid. ");
INSERT INTO uli_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Hare rebe hasugmiloh re bela taldugmi lal imwel ttey hare imor aam hare tamol, ngo ha towe merahrah irel mekla habe sor hare wululul yami be taldugmi. ");
INSERT INTO uli_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bo Espritu Santus bele kangalugmi mekla habe sor irel yodla.” ");
INSERT INTO uli_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Semal yarmat mo luwulur buwa we yesa kangalu Jesus bo, “Sensey, kangal mala bisiy bo yebe hamhela mekla bugtamem le mala tamem sa ligid ngalugmem.” ");
INSERT INTO uli_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus yesa kangalu bo, “Itey le yesa fang kkaley le iy be hatugulu kofal hare iy hamhela mekla bugtami uwomi?” ");
INSERT INTO uli_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Iwe ngo yesa taboloh yal hapatpat ngalir panger, “Habe llugu dipmi ngo ha hafalugmi irel metmetal chehaw, bo yael semal molow semal ila yete budoh mo irel mekla lital, le ila mwo ifa lepal yal mmal.” ");
INSERT INTO uli_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iwe ngo Jesus yesa kangalur fiyong le: “Ye mel semal mal le ye mmal ngo ye cholop mongol mala bugtal. ");
INSERT INTO uli_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sa paoy sa luluwaley loh chog. ‘Tayor solbos le ibe haliliyaloh mongoy ka iyang. Meda mele ibele foru? ");
INSERT INTO uli_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iye mele iy bele foru, yal luluwaley loh chog lufulyal; Ibele hamdera soko ka yai ngo isa fatleha tot le yebe palingling bo be daw mongoy mo meka litay iyang. ");
INSERT INTO uli_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Iwe ngo ibele sor bo: Mal yolbuw. Yesa yoh ngalug pangal mokwe ye momay bo hammalem irel fedeeg raeg. Hola hamaluyagloh, hobe mongoy ngo ho yul ngo ho hameseg fedal!’ ");
INSERT INTO uli_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iwe ngo Deus sa kangalu bo, ‘Gel semal buch! Bongey le chog mele be chuy yam ngas. Iwe ngo itey mele bele tapeli pangal mokwe hosa haliliya bo hammalem?’” ");
INSERT INTO uli_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesus sa hasiyaloh fiyong we ngo sa sor bo: “Be iye sengal wululur rechokla resa hatteyloh chog mekla liter ngo re tafel mo fael metal Deus.” ");
INSERT INTO uli_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iwe ngo Jesus yesa kangalur mokwe redabeyal bo, “Ila ikangalugmi bo ha towe marhagili kofal mengagumi hare halmi bo de tor loh ha sala mes. ");
INSERT INTO uli_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Molow ila ye paleng fal mo imol mongoy, ngo holong ila ye paleng tot fal mo imol mengag. ");
INSERT INTO uli_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ha kemahoy mwiliy kala le re tema fod mongoy ngo re tema hattey uwal milay ngo tor yar soko. Ngo Deus mele yema fang haler. Hami ila ye paleng pelami mo imor mael yeyal ka! ");
INSERT INTO uli_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Itey semal hami le yebe yoh ngali le yebe hassulayi yodol yal molow le hare yebe merahrah loh chog. ");
INSERT INTO uli_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hare ika mwo ye wechich ngo ye temal ngalugmi ila ngo meda mele ha bela hawersi loh chog dipmi irel ikla tot iyang? ");
INSERT INTO uli_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ha kemahoy floras kala maltumuldah chog le tor le ye fedagu. Re tema yengang ngo re tema ffaor mengagur. Ibe kangalugmi le King Solomon mwo irel lepal mokwe mmalel ngo tor mengagul le ye wochog kkamdidiyel sew floras ka. ");
INSERT INTO uli_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Deus mele ye hamengagu fadil ka maltumuldah chog le ye mel iga igla ngo bela walsu ngo towol mel bo bele fisngegloh. Ila ngo bela hami ngo Deus towe hamengagugmi? Ila lepal wechichil yami tugulul ladep! ");
INSERT INTO uli_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ila ha towe hayewola dipmi, hare meda mele habe hangi ngo ha yulmi. ");
INSERT INTO uli_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Rechoka rete chepar irel Deus ila rema luluwaley loh chog meka.) Mala Tami ye gola pangal mekla ha temmal iyang. ");
INSERT INTO uli_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ila, habe far itol chog dipmi irel mala Lamliyal bo ila ngo pangal meka ngo yebe hammal ngalugmi. ");
INSERT INTO uli_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ha towe motog hami ikla fedmal, bo mala Tami ila yesa fel depal bo be fang ngalugmi mala Lamliyal. ");
INSERT INTO uli_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hala tap chuway mekla litami hasa ngaler mael hafohoy mekla salpiyal. Iwe ngo hasa kak yami botow kowe tema towas hasa halililong mmalmi woal laeng iyang. Ila lobola tor sugfed mala mmalmi le yebe pungloh mo iyang bo tor chomacho le be harepdoh iyang iwe ngo tor churchur le yebe hatawsi. ");
INSERT INTO uli_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mekla dipmi ila ye mel chog lobola ye mel mmalmi iyang. ");
INSERT INTO uli_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Habe llugu dipmi irel pangal mekla be weldoh. Ngo hasa hagsu yami habul, ");
INSERT INTO uli_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","be wochog boy kowe re wiwidi masta la yar bo be tefael mo irel sew gubulul habulupoy. Yodla ye bela tefael, ngo yebe ffichfichiy chog hatam ngo resa sugu. ");
INSERT INTO uli_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Be ifa lepal momayel lal deper boy kala irel yodla bela tefael masta la yar ngo ye wirir le re mmat le re wiwidi. Iy be kangalugmi le masta we yebe fedhaloh chog botow we yal ngo yesa kangalur bo rebe marodiy ngo iy yesa ffaor haler. ");
INSERT INTO uli_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Be ifa lepal momayel lal deper le masta we bela wirirdoh ngo re faesul fel le te tugul hare lugulbong hare yesa ligdi lugulbong. ");
INSERT INTO uli_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ngo yebe tugul lal dipmi irel mele. Hare semal le imwal sew imw ngo ye gola yodla be budoh semal chomachoh iyang ila ngo iy towe ligdi imw we imwal bo chomachoh we yede dohlong iyang. ");
INSERT INTO uli_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iwe ngo hami mwo ngo habe faesul hafelugmi chog, bo mala Layur Retalop ila yebe budoh irel sew yad le hami ha towe dap iyang.” ");
INSERT INTO uli_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedrus sa sor bo “Samol, hamem chog mele ho luluwaley ngalugmem fiyong le hare ho luluwaley ngalir panger yarmat?” ");
INSERT INTO uli_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Samol sa sor bo, “Ila ngo itey iy boy la ye momay ngo ye repiy? Ila yeramtala masta la yal yebe hametmeta ngali mokwe lital ngo bela hola yodol mongoy ngo iy mele yebe ma fang haler boy kala tot. ");
INSERT INTO uli_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ifa lepal momayel lal depel boy la irel yodla masta la yal ye bela wiridoh le ye foforu pangal meka! ");
INSERT INTO uli_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iy be hatugulu ngalugmi le masta la be itol boy la bo be lamli pangal mekla lital. ");
INSERT INTO uli_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Iwe ngo hare boy we ye luluwaley ngo be ssulay ngo moch tefael masta we yal, ngo yesa chapiy yal lliy fedaley boy kowe tot le fengal mal mo fefel, iwe ngo ye mongoy ngo ye habbelas, ");
INSERT INTO uli_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ila ngo bela seral le bela budoh masta we ngo boy we ye towe dap iyang. Masta we bele tagul chog yesa fang yal hagerger bo yebe hagulal ngali le mokwe sa foru ila ye tayikof. ");
INSERT INTO uli_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Boy la ye gola mele masta la yal ye dipli le be foru ngo iy yete foru, ila yebe kkel hagerger la rebe faor ngali. ");
INSERT INTO uli_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Iwe ngo boy la ye togla mele masta la yal ye dipli ngo yesa foru sew formel le masta la yal te dipli ila rebe fang yal hagerger le towe kkel. Lepal mele yeramtawe ye foru ngo ila lepal le rebe ngaley. Yebe cholop mele yeramtawe be fang, ngo be cholop mele rebe faor ngali. ");
INSERT INTO uli_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Isa budoh le ibe fisgiloh faileng le, ngo ifa lepal yai hable hare sa faesul gus! ");
INSERT INTO uli_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ye mel sew baptismus le iy bele bulong iyang le be weres lal depey iyang igla yee la hola yodla bela moll. ");
INSERT INTO uli_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ha luluwaley le ibudoh ibe hasidoh hopos lal faileng le? Yeb, te hopos mele ihasidoh, bo ibudoh le ibe hatarporpar yarmat. ");
INSERT INTO uli_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Igla sa loh le sew bugat le re limal yeramtal ila re bele mehal bo rebe rure mo iyang. Ila solmol re bele hapaliyel ngal ila rumal, ngo ila rumal re bele hapaliyel ngal ila solmol. ");
INSERT INTO uli_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mekla temer yalwich ila re bele hapaliyel ngal mal kala layur, ngo mekla layur re bele hapaliyel ngal mekla temer. Mekla seler ila re bele hapaliyel ngal fefel kala layur, ngo fefel kala layur re bele hapaliyel ngal mekla seler. Fefel ila re bele hapaliyel ngal fefel kala ril layur. Iwe ngo fefel kala ril layur ila re bele hapaliyel ngal mekla sil rir.” ");
INSERT INTO uli_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus yesa wol kangalur yarmat bo, “Yodka ha wiri sedep darmiy le ye bidah mo Meldew, ngo hama sor ye bele ppotog, iwe ngo ma ppotog. ");
INSERT INTO uli_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iwe ngo habe mafi yaeng le ye yugugdoh mo Iyor, ngo hama sor bo bele bichikar, iwe ngo ma bichikar. ");
INSERT INTO uli_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ha rol foforiyeg! Hare ma yoh le habe kal ngali meka wol talop mo lal laeng ngo hasa sor kofal yayural, ngo ila ngo meda fal le hala togla kofal fael yodka igla iyang? ");
INSERT INTO uli_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Meda fal le yela teyoh ngalugmi le be hami chog lluflumi hasa hatugulu mele ye fel le habe foru iyang? ");
INSERT INTO uli_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hare semal sa hapaliyel ngalug le ye sor le be hasugloh court ngo hosa yedamgel bo hobe hopossoloh mala lepdami mo imol mala hobe loh court. Hare hobe te foru mele ila ngo ye bele hasugloh court. Iwe ngo court ye bele fangloh gel irer police, bo rebe yitluglong lal kalbus. ");
INSERT INTO uli_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ibe kangalugmi le hobe te fang lepal salpiy la court sa hatugulu le hobe fang, ngo towe yoh le rebe hachuyah mo lal kalbus.” ");
INSERT INTO uli_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Irel yodla ngo tot yarmat re mel loboswe le re kekangalu Jesus kofer yeramtal Galilee kowe Pilatus ye limeserloh irel yodwe re fefang yar maligach ngal Deus. ");
INSERT INTO uli_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus sa hatefali ngo sa sor bo, “Mala la ila sengal yar limeserloh yeramtal Galilee kala, hami luluwaley le ila mele tugulul le ye kkel yar molfid mo imor yeramtal Galilee kala tot? ");
INSERT INTO uli_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Te ila sengal! Ibe kangalugmi le habe te tagul tang mekla molfidmi ngo pangmiloh ngo habe wochog rechokla re limeserloh. ");
INSERT INTO uli_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ifa senger rechokwe seg mo walmol we ye pungdiy hoas we uwor mo wol Siloam re sala rol mes? Ha luluwaley le ika rechoka yesa tugul le ye kkel yar tayikof mo imor pangerloh yarmat wol Jerusalem? ");
INSERT INTO uli_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Te ila sengal! Ibe kangalugmi le habe te tagul tang mekla molfidmi ngo pangmiloh ngo habe wochog rechoka re mes.” ");
INSERT INTO uli_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iwe ngo Jesus yesa kangalur fiyong le: “Ye mel semal mal le ye mel sehay ire kowe rema sor bo fig le ye mel wol milay la yal. Yema toa la ffaeg uwal ngo tor mele yema wiri. ");
INSERT INTO uli_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Iwe yesa kangalu chol yengangel milay we yal bo, ‘Kemahoy, sa suluw raeg yai ma budohloh chog iga, le ibe ffaag uwal ire le ngo tema yor. Hola supidiy! Meda fal le bela mel be hapelsedaw doh iga le tor pelal?’ ");
INSERT INTO uli_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Iwe ngo chol milay we sa kangalu bo, ‘Hobe ligdi mwo melap lal sew raeg bo ibele kiling tebaliliy chapil ire la bo ibe pisiy. ");
INSERT INTO uli_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ngo hare la raeg lay ngo sa yor uwal ila ngo sa momay. Iwe ngo hare tor chog uwal ngo siya moch supidiy.’” ");
INSERT INTO uli_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Woal sew Sabbath ngo Jesus ye fofoloy lal sew imwel ttey. ");
INSERT INTO uli_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ye mel semal fefel loboswe le sa seg mo waluw raeg yal tomay loh chog irel moniyan la ye mel uwol. Sa bbor mala tagrul le tay yoh le be wweloh. ");
INSERT INTO uli_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yodwe Jesus yela wiri ngo yesa kangalu bo, “Bele chuy yam tomay.” ");
INSERT INTO uli_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iwe Jesus yesa yetedah paol uwol fefel we. Yodwe chog ngo sa wwel tefael loh molwe tagrul fefel we ngo yesa hapingpinga Deus. ");
INSERT INTO uli_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sa ssong molwe tamol ttey we bo Jesus sa hachuchuy yar yarmat tomay woal Sabbath. Iwe yesa kangalur yarmat bo, “Wolral le sima yengang iyang. Ila ha budoh raleka te Sabbath bo yebe hachuchuy tomay mo uwomi.” ");
INSERT INTO uli_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Samol sa hatefali ngo sa sor bo, “Ha toa kachepar! Hare mwo rall Sabbath ngo yema yoh le semal hami be besi ffarol lol karbow hare donkey mo lobos kala liliyer sa palirloh bo bela fang lemer chael. ");
INSERT INTO uli_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Igla ila ye mel semal chol daowe yael Abraham le sa seg mo waluw raeg le Satan sa wali. Sibe hachuya yal tomay woal Sabbath hare yeb?” ");
INSERT INTO uli_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Resa rol maa loh ir rechokwe re hapaliyel ngali irel mokwe ye kekapta, ngo sa momay deper yarmat cholop we irel pangal mokwe yesa foru. ");
INSERT INTO uli_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iwe Jesus sa kasiyar, “Ifa sengal wululul mala Lamliyel Deus? Meda mele iy be hawewe ngali? ");
INSERT INTO uli_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mala ila iye sengal: semal yarmat yela hasi sew faesol mustard sala fedagu wol milay la yal. Yela tumuldah sala mel bo sehay ire. Iwe ngo mael yeyael re sala ffaor hafter wol mekla ral.” ");
INSERT INTO uli_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesus sa wol kasiy, “Meda mele ibe haweweli ngal mala Lamliyel Deus? ");
INSERT INTO uli_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mala ila iye sengal. Semal fefel le ye kak habboloh sa poloy ngal flowa yee la boloh.” ");
INSERT INTO uli_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus ye loloh Jerusalem ngo ye wol fofoloy fedal luwul haplom ka ye ppalingling mo ika ye ppachigchig. ");
INSERT INTO uli_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iwe ngo semal yesa kasiy “Ifa sengal Malap, be hal fedmal loh chog yarmat le rebe molow?” Jesus sa hatefali ngo yesa sor bo, ");
INSERT INTO uli_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ha yedamgel bo habe dohlong lal hatam la ye wechich, bo ye cholop yarmat le rebe yedamgel bo rebe bulong mo iyang ngo re towe dohlong. ");
INSERT INTO uli_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mastal imw we bele sudah sa piltaloh hatam we. Iwe ngo hami ila ha bele su ligtam le ha bele fichfichi hatam we ngo ha bele sor bo ‘Sugu ngalugmem hatam le melap bo habe bulong.’ Iwe ngo iy ye bele hatefali ngalugmi ngo bele sor bo, ‘Iy tugla lobos le ha budoh mo iyang!’ ");
INSERT INTO uli_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Iwe ngo hami ha bele sor bo, ‘Hamem hama daboh irel mongoy mo yul, iwe ngo gel homa foloy wol molwe falumem!’ ");
INSERT INTO uli_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Iwe ngo iy ye bele wol sor bo, ‘Iy tugla lobos le ha budoh mo iyang. Ha chuy mo irey bo pangami ngo ha rol tayikof!’ ");
INSERT INTO uli_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Irel yodla resa ddabohmiloh ngo ha bele rol tang ngo ha hatangtingi mekla ngimi bo ha bele wiri Abraham, mo Isaac, mo Jacob, mo panger profeta kowe le re mel irel mala Lamliyel Deus. ");
INSERT INTO uli_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yarmat re bele rodoh mo rel laeng la Meteral mo rel laeng la Meldew. Iwe ngo re wol budoh mo rel laeng la Ifang mo rel laeng la Iyor. Le re bele la rol marorodiy irel gubul la ye mel irel mala Lamliyel Deus. ");
INSERT INTO uli_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iwe ngo rechokla re hamo ila re bele hamir ngo rechokla re hamir ila re bele hamo.” ");
INSERT INTO uli_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Irel yodla chog ngo tot Pharisees kowe resa budoh irel Jesus resa kangalu bo, “Ho bele chuy chog mo iga igla bo hobe loh mo solbos bo Yerodes ila yesa luluwaley le yebe limesehloh.” ");
INSERT INTO uli_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus sa sor bo, “Ha loh ha bela kangalu fox la bo: ‘Ngang iy kachuchuy moniyan ngo iy hachuya yar yarmat tomay igla mo walsu, ngo bela hasolralel ngo bele moch mol yai yengang.’ ");
INSERT INTO uli_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ye tugul le iy be chil la malekah igla mo walsu mo ralela seral. Ye tafel le yebe mes semal profeta mo solbos le bete Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem! Jerusalem! Ha limeseloh profeta kowe ngo ha hacchifir re hagloy kowe yael Deus we iy ye hagloyur wey iremi. Ifa lepal yai dipli le ibe hateyili pangal yarmat le be tappel chog malog fefel kowe rema hateyili fengalir mokwe pipiyer fael payur. Iwe ngo hami ha temchal bo ibe foru! ");
INSERT INTO uli_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Templum we yami ila Deus ye bele ttahchaloh. Ibele hatugulu ngalugmi le ha towol wiriyey yee, la budoh yodla ha bele sor bo, ‘Deus yebe holbuwa yeramtala be budoh fael mala Idel Samol.’” ");
INSERT INTO uli_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sew Sabbath ngo Jesus sa loh bo bela mongoy irel imwel semal tamol kowe yar Pharisees ngo yarmat re kekemahoy. ");
INSERT INTO uli_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sala budoh semal mal irel Jesus. Mal le ila ye bobo mekla pechel mo mekla paol. ");
INSERT INTO uli_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iwe ngo Jesus sa maliliy le ye kasiyar mokwe sensel Hatobtob we mo Pharisees kowe bo, “Ye fel ngal yach Hatobtob le sibe hachuya yar yarmat tomay woal Sabbath hare yeb?” ");
INSERT INTO uli_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Iwe ngo tor mele re sor. Iwe Jesus sa hachuya yael mal we tomay ngo sa halho. ");
INSERT INTO uli_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iwe yesa kangalur bo, “Hare semal hami le ye mel semal tarmal hare semal karbow le lol le ye pungdiy lal sew chael kkil wol Sabbath, ngo ye towe yetedah bo yagel mala Sabbath?” ");
INSERT INTO uli_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iwe ngo ye teyoh ngalir bo rebe hatefali kasiy we yael Jesus. ");
INSERT INTO uli_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesus ye wiri le tot chol gubul we re duduweley chog lobos kala liliyer chotagiyet bo re bela mel iyang. Iwe yesa kangalur pangerloh fiyong le: ");
INSERT INTO uli_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Hare semal ye ffesangug ha bela dabey sew gubulul habulupoy, ngo ho towe budoh chog ngo ho sala meri lobos kala liliyer chotagiyet hobe la maroro iyang. Bo ye dela mel semal le ye tagiyet tot mo imom le re wol dengag iy irel gubul la, ");
INSERT INTO uli_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","iwe ngo yeramtawe ye dengag hami sala budoh irem ngo sa kangalug bo, ‘Hobe chuy mo lobosla bo yeramtale be ppaoy iyang.’ Iwe ngo gel ho bele la maa loh iwe ho sala mel irel lobos la liliyer rechokwe re hartal totol. ");
INSERT INTO uli_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yodla rebe fesangugloh irel sew gubul, ngo hobe loh ho sala far mel irel lobos kowe liliyer rechoka re hartal totol, bo bela budoh yeramtawe ye fesangug doh ngo bele sor bo, ‘Mararey, budoh bo hobe ppaoy mo lobos le ye momay.’ Iwe ngo ho bele ssor mo irer chol tteydoh kowe. ");
INSERT INTO uli_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bo semal le yebe hatagitadah ngo yebe totol, ngo semal le yebe hatetalo ngo yebe tagiyet.” ");
INSERT INTO uli_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iwe Jesus yesa kangalu yeramtawe ye foru gubul we bo, “Yodla ho bela ffaor mongol leweleliyol, hare mongol fehaf ngo ho towe fesangur wol mararem, hare bisim hare chol bugtam, hare rechokla re mmal le re harpah bo rebe daboh irel mongo. Bo ir ila rebe wol fesangug bo ho bela daber irel mongoy bo paliyel molwe hosa faor ngalir. ");
INSERT INTO uli_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yodla ho bela foru sew gubul le ye paleng ngo hosa fesangur rechoka re hafohoy, mo rechoka re tayikel, mo rechoka re mahatgut, mo rechoka re metafis. ");
INSERT INTO uli_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ila ngo hobe yolbuw bo towe yoh le rebe hatefali paliyel molwe hosa faor ngalir. Deus mele bele fang paliyal ngalug irel yodla rechokla re momay rebe molow tefael mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yodwe semal mal kowe ye maroro irel tis we ye rongrong molwe ngo yesa kangalu Jesus, “Be rraey lal deper rechokla re bela dabey gubul la irel mala Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus sa kangalu bo, “Ye mel semal mal le yela foru sew gubul paleng ngo ye cholop yarmat le ye fesangur doh iyang. ");
INSERT INTO uli_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yodwe yela hola yodol gubul we ngo sa fang loh semal boy kowe yal bo bela kangalur yarmat bo, ‘Ha budoh bo, pangal formel ngo sa fel!’ ");
INSERT INTO uli_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Iwe ngo sa semal ir ngo ye sor fael mele towe mmal le bela dabey gubul we iyang. Yeramtawe metamo ye kangalu boy we bo, ‘Isa chuwayi sew bugat le ibele la balsi mwo, ila fael pechem ngo towe mmal le iy be daboh.’ ");
INSERT INTO uli_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ngo ila semal sa sor bo, ‘Isa chuwayi seg karbow le isa loloh bo ibela hayengangalir bo iy be gola kofer. Ila fael pechem ngo towe mmal le ibe daboh.’ ");
INSERT INTO uli_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iwe ngo semal sa wol sor bo, ‘Ngang ila imoch habulupoy chog. Ila ye towe mmal le ibe daboh.’ ");
INSERT INTO uli_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Boy we sa tefael loh irel masta we yal sala kangalu pangal mokwe. Iwe masta we sa ssong sa kangalu boy we bo, ‘Haturug bo hobe buyoy lal tabtabol yalap kala, mo lepedpedal imwel haplom le bo ho bela fesangur doh rechokla re hafohoy, mo rechokla ye mes pecher, mo rechokla re metafis, mo rechokla re mahatgut.’ ");
INSERT INTO uli_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te sulay ngo boy we sa kangalu masta we yal bo, ‘Pangal mokwe ho sor ngo sa mol yai foru, ngo chil paleng lobos le be chil daw tot yarmat iyang.’ ");
INSERT INTO uli_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Iwe ngo masta we sa kangalu boy we bo, ‘Hola buyoy lal yalap kala ye buyoy lugul hasohso, mo yalap kala ye pachigchig bo hobe fofosdoh yarmat bo be ssogloh lal imw le imwey. ");
INSERT INTO uli_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ibe kangalugmi le tor semal mo irer rechokwe iy mol dengag ir metamo le yebe songu sugfed mo irel mongol gubul le yai!’” ");
INSERT INTO uli_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ye mel fael sew yad le ye feraketaw yarmat le re dedabeloh Jesus ngo yesa tagul ngalir ngo sa kangalur bo, ");
INSERT INTO uli_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Semal le yebe budoh irey ngo yebe te kkel yal hachangyey mo imol yal hachangi temal mo sil mo ril mo lol mo bisil mo mengal ngo yete wol hachangiyey mo imol yal hachangi iy lufulyal, ila ngo towe yoh le be mel bo redabeyey. ");
INSERT INTO uli_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Semal le yebe te hasi yal krud ngo sa dabeyey ngo towe yoh le be mel bo redabeyey. ");
INSERT INTO uli_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Hare semal hami ye luluwaley le be foru sew imw tagiyet ngo be marodiy mwo be luluwaley hare be lap salpiyal le be mol yengangal hare yeb. ");
INSERT INTO uli_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hare be te iye sengal le be foru ngo wol miril yal hamallo mala dayifal ngo towe mol yengang we. Iwe ngo semal le bela wiri yengang we le yete mol bo ye telap salpiyal ila yebe tape yeramtawe kamemal. ");
INSERT INTO uli_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Iwe ngo re bele sor bo, ‘Mal le ila ye chapidah yal yengang ngo ye towe mol.’ ");
INSERT INTO uli_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hare semal king ye hasi seg sangeras lol yarmat le re bela fedeg ngal wol semal king le riyeg sangeras mekla re ppilyal ila ngo, metamol chog ngo yebe luluwaley mwo hare yebe yoh le rebe llir chol rewe sere. ");
INSERT INTO uli_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Hare yela gola le towe mmal ngo ye bele hagloyur loh tot yarmat irel king we semal irel yodla ye chil ddawloh bo rebe hafel fengali lepder bo re towe fedeg. ");
INSERT INTO uli_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ila be wol ila sangmi, le tor semal hami le be mel bo re dabeyey le hare yebe te ligdiloh pangal formel. ");
INSERT INTO uli_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Hasiga ila ye momay ngo ligdi bo be chuyloh molwe tadel, ngo tayor mele sibe chil faor ngali le be taed tefael. ");
INSERT INTO uli_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ye tema kof ngal bol hare hamalel fedah; sima pedaloh bo tayor pelal. Ha talenga hare yor talengmi!” ");
INSERT INTO uli_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ye mel seral le ye cholop chol hateyel paliyel raeg mo rechokwe yarmat rete dipli wegdigir le re budoh bo rebe talenga foloy kowe yael Jesus. ");
INSERT INTO uli_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisees kowe mo mokwe sensel Hatobtob we resa chapiy yar lunglung fengal le re sor bo, “Mal le yema hammaler ngo ye mongoy ngalir rechoka yarmat rete dipli wegdigir.” ");
INSERT INTO uli_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iwe Jesus sa kangalur fiyong le: ");
INSERT INTO uli_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hare ye wochog mala ye mel semal mo luwulumi le ye mel subguy saaf lol iwe ngo sa mwael loh semal mo luwulur, ila ngo meda mele yebe foru? Yebe ligdi ila duweg mo diwmal le re momongoy fedal fadil ngo sala meri ila yesa mwael loh yee yodle yela wiri iyang. ");
INSERT INTO uli_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ye bela wiri ngo ye bele hayefra irel lepal yal rraey, ");
INSERT INTO uli_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","sa hasi tefaliloh irel molwe bugtal. Iwe ngo ye bele fesangur doh mokwe wol maryarel mo rechokla re harpa ngo bele kangalur bo, ‘Yesa momay depey bo iy sa wiri saaf we layi we ye mwael loh. Si bele rol gubul!’ ");
INSERT INTO uli_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ibe kangalugmi le be wol ila sengal yal be paleng rraey la wol laeng irel semal choto hamolfid le be harrig lal depal irel molfidil mo imor duweg mo diwmal yarmat le re luluwaley le tor pelal le rebe harrig lal deper irel molfidir. ");
INSERT INTO uli_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Hare ye wochog mala semal fefel le ye mel seg faesol salpiy lol iwe ngo sa tamel loh sefaes mo iyang, ila ngo meda mele yebe foru? Ye bele hagsu sew habul ngo sa yalguwa lal imw we imwal bo be meri hamayi pangal lobos yee, yela wiri. ");
INSERT INTO uli_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yodla bela wiri ngo bele fesangur mokwe wol maryarel mo rechokwe re harpa ngo bele kangalur bo, ‘Yesa momay depey bo isa wiri faesol salpiy we layi we ye tamel loh. Si bele rol gubul!’ ");
INSERT INTO uli_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iy be kangalugmi le be ila sengal chog yar rraey angeluse kala Lol Deus irel semal choto hamolfid le sa harrig lal depal irel molfidel.” ");
INSERT INTO uli_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus yesa taboloh yal hapatpat le ye sor bo, “Ye mel semal mal le rumal lol tarmal. ");
INSERT INTO uli_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iwe miril yarmat yesa kangalu molwe temer bo, ‘Fang ngalyey mele yebe mel bo yusuwey mo irel mekla yusuwom igla.’ Iwe molwe temer yesa hamhela mokwe iy ye lamli uwor tarmal kowe lol. ");
INSERT INTO uli_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yela fedral mo wol miril ngo tarmal we miril yarmat yesa tap chuwayloh mokwe ye yoh ngali mo irel molwe temer. Iwe yesa hasi molwe salpiyal sa ligdi molwe bugtal yesa loh wol fulule ye ddawloh. Iwe sala hatolpa fedaley salpiy kowe lol irel wegdeg kala tayikof. ");
INSERT INTO uli_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yesa tapeliloh pangal salpiy kowe lol. La wol miril ngo sa budoh sew langda wol fuluwe. Ye sala mel tarmal we le sa hafohoy. ");
INSERT INTO uli_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Iwe ye sala yengang ngal semal yeramtal fuluwe. Yal yengang ila yema hamongoy pabiy. ");
INSERT INTO uli_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yesa kekable hare be ma hangi mokwe hal pabiy kowe ngo tor semal le yema fang hal. ");
INSERT INTO uli_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","La wol miril ngo sa ppunglong sew luluwal lal chemal ngo sa sor bo, ‘Panger rechokwe rema yengang ngal molwe temay ngo ye cholop haler. Iwe ngo ngang iye ibele mes irel yai kkoloh. ");
INSERT INTO uli_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ibele sudah chog ngo isa loh irel molwe temay ngo isa kangalu bo, “Isa molfid ngal Deus ngo imolfid ngalug le gel temay. ");
INSERT INTO uli_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tayfel le hobe fesanguyey bo ngang lom. Ho bele yitilyey le ngang chog semal lom chol yengang.” ’ ");
INSERT INTO uli_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Iwe yesa sudah chog sa tefael loh irel molwe temal. “Ye chil ddaw tang imw we ngo molwe temal yesa wiri. Iwe ngo sa ddidoh yal fahoy. Yesa hamed ngali sala hola doh llomolal sa fesngo fedaley. ");
INSERT INTO uli_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iwe ngo tarmal we sa sor bo, ‘Temay, iy sa molfid ngal Deus ngo iy molfid ngalug. Tayfel le hobe fesanguyey bo ngang lom.’ ");
INSERT INTO uli_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iwe ngo molwe temal sa ffesangur doh boy kowe lol yesa kangalur bo, ‘Ha hatturugmi! Ha hasidoh mengag we ye hartal momay bo habe hamengagu ngal tarmal le. Hasa yetedah sew ring irel mala haddol ngo hasa fang yal bwela. ");
INSERT INTO uli_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ha sala hasidoh karbow we ye hartal beday bo habe lliy bo sibe rol gubul! ");
INSERT INTO uli_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bo tarmal le layi ila ye mes ngo igla ila yesa molow tefael. Ye tamel loh ngo igla iye yesa tefaeldoh.’ Iwe yesa chap gubul we. ");
INSERT INTO uli_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Irel yodla ngo ye mel tarmal we ye mol yarmat wol milay. Yela tetefaldoh le yesa kekarpa imw we imwer ngo yesa rongrong yalol mosik mo yalol barog. ");
INSERT INTO uli_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Iwe yesa fesangu semal boy kowe yesa kasiya, ‘Meda mele sa wel?’ ");
INSERT INTO uli_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Boy we yesa kangalu bo, ‘Molwe bisim ila sa tefaeldoh ngo molwe tami sa lliy karbow we ye hartal beday bo sa tefael molwe bisim le yete mes.’ ");
INSERT INTO uli_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sa ssong tarmal we mol yarmat tay mechal be bulong yilim. Iwe yesa buyoy molwe temal yesa hafalpechey be bulong. ");
INSERT INTO uli_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Iwe yesa hapaliyel ngal molwe temal. ‘Kemahoy, lepal raeg ka iy sa yengang ngalug le isa wochog semal boy, ngo ted yor sew mekla ho sor le ite talenga. Meda mele hosa ngaleyey? Semal mwo kamang le ho fang ngalyey bo habe rol gubul mo mekla wol maryarey ngo tor! ");
INSERT INTO uli_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Iwe ngo mele lom le sala hatolpaloh salpiyel pangal mokwe mokwe ho fang ngali irel mekla tor pelal mo fefel ka rema tape chuway halongor, ngo yela tefaeldoh chog ngo hosa lliy karbow we ye hartal beday bo yal gubul!’ ");
INSERT INTO uli_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Molwe temer sa sor bo, ‘Layi, gel ila pangal yad ngo ho mel irey, ngo pangal meka ilamli ngo lamliyem. ");
INSERT INTO uli_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Iwe ngo towe mmal le sibe te gubul, bo sa momay depach bo molwe bisim ila ye mes ngo igla ngo yesa molow. Ye tamel loh ngo igla ngo yesa tefaeldoh.’” ");
INSERT INTO uli_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus ye kangalur mokwe redabeyal bo, “Semal mal le ye mmal le ye mel semal boy yal le yema kekamahoy mekla lamliyal. Mal we sa rongrong le boy we yal sa kakatolpa fedaley salpiy kowe lol, ");
INSERT INTO uli_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","iwe yesa fesngulong boy we yilim sa kangalu bo, ‘Ifa sengal mele kofom le isa rongrong? Tefa sew babior bo babiorol meka litay le ho kekamahoy bo ho towol mel iyang.’ ");
INSERT INTO uli_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iwe boy we sa luluwaley long chog lal depal, ‘Masta le bele hachuyayey mo irel yengang le yai. Meda mele ibe foru? Itayikel le ibe ma faor yengang ka ye weres, ngo imaa le ibe ma dongor fedal chog formel. ");
INSERT INTO uli_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Isa gola mele ibe foru! Ila ngo yodla ibela chuy mo irel yengang le yai ngo bele yor maryarey le rebe fesanguyey loh irel imw kala imwer.’ ");
INSERT INTO uli_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yesa fesangur panger rechokwe re molfid ngal masta we. Yesa kasiya yeramtawe metamo bo, ‘Ifa lepal molfidim ngal masta we yai?’ ");
INSERT INTO uli_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yeramtawe yesa sor bo, ‘Subguy barinel hapgep.’ Iwe ngo mal we sa kangalu bo, ‘Babiorol mala molfidim iye, marrodiy hosa tafa diy bo lemeg.’ ");
INSERT INTO uli_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Iwe ngo yesa kasiya iwe semal. ‘Iwe ngo gel, ifa lepal molfidim?’ Yeramtawe yesa sor bo, ‘Sangeras tutuwel wheat.’ Iwe ngo mal we yesa kangalu bo, ‘Babiorol mala molfidim iye, hobe tefadiy bo walbuguy.’ ");
INSERT INTO uli_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Masta we ye hapingpinga boy we lol irel molwe ye foru bo yeramtal talople ila ye kkel yar machohchoh irel hafelfelel chog mekla ir rebe mmal iyang mo imor ikla re yeyedamgel ngal mala Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesus yesa taboloh le ye sor bo, “Ibe kangalugmi le habe ffaor maryarmi le habe tapeli meka mmalmi wol talop le ngo yodla bela tor loh ngo habe hola molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Semal le yema katos irel meka ye pachigchig ila yebe wol katos irel meka ye palingling. Iwe ngo semal le ye tema katos irel meka ye pachigchig, ila towe wol katos irel meka ye palingling. ");
INSERT INTO uli_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hare habe te katos irel meka ye pachigchig irel hafelfelel meka woal talople, ila ngo be ifa sengal chog ngo resa lugu ngalugmi mmal la ye katos? ");
INSERT INTO uli_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hare hobe te hammal lital semal ila ngo itey le be mechal fang ngalug ikla litam? ");
INSERT INTO uli_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tor semal boy le be rumal yal masta. Yebe hafobdiri ila semal ngo ye hachang ila semal. Yebe momay ngal ila semal ngo yebe tayikof ngal ila semal. Towe yoh le habe yengang ngal Deus ngo ha wol yengang ngal salpiy.” ");
INSERT INTO uli_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisees kowe rela rongrong pangal mokwe ngo resa rol tape Jesus kamemal bo fael mala ir re hachang salpiy. ");
INSERT INTO uli_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesus sa kangalur bo, “Hami chog yami forugugmiloh mo lal metael yarmat ngo Deus ye gola luluwal kala yami. Bo mekla yarmat re luluwaley le ye paleng pelal ila tor pelal mo irel Deus. ");
INSERT INTO uli_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Hatobtob we yael Moses mo babior kowe yar profeta kowe ila re fofoloyu Hapatpat Momay we kofael mala Lamliyel Deus yee, la hola doh Johannes Baptista. Pangal yarmat ngo resa yedamgel bo rebe rongrong. ");
INSERT INTO uli_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Iwe ngo ligdi bo ye mechrag tot le be chuyloh laeng mo talop mo imol Hatobtoble le be chuy sugfed mo iyang. ");
INSERT INTO uli_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Semal mal le yebe ddabeloh yal habulupoy ngo sa wol la rili semal fefel ila sa faor maltemay. Ngo semal fefel le resa mehal mo yal habulupoy ngo sa wol la rili semal mal ila ngo iy mal la sa wol faor maltemay. ");
INSERT INTO uli_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ye mel semal mal le ye mmal le yema mengag chog mengag kowe ye cchow paliyal ngo ye mel chog luwul mmal pangal ral. ");
INSERT INTO uli_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ye wol mel semal mal le ye hafohoy le Lazarus idal le ye choeloh irel meragus le yarmat rema toa hasidoh metal hatmal imw we imwel mal we ye mmal. ");
INSERT INTO uli_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ye luluwaley le yebe ma hangi mormorol mongoy kala yebe pungdiy mo irel tis we yael mal we. Pes ka mwo ngo rema budoh resa liwgi fedaley metal mokwe meragusul. ");
INSERT INTO uli_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yela mes mal we ye hafohoy ngo angelus resa budoh hasi bo bela maroro mo lengchel Abraham irel gubul la ye hartal paleng wol laeng. Iwe ngo yela mes mal we ye mmal, ngo yarmat resa hasi re sala leba. ");
INSERT INTO uli_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ye sala mel irel lobosla liliyer chomes le ye kkel yal hafohoy mo iyang. Yela kaledah sala wiri Abraham le ye ddawloh le ye mel Lazarus lengchel. ");
INSERT INTO uli_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iwe yesa fofos le ye sor bo, ‘Abraham le gel Temay! Hobe fahoyey. Hagloyu diy Lazarus bo be chiri sehad mala haddol luwul chael bo be hatturalong lal yeway be halufungu bo yesa kkel yai hafohoy luwul yaef!’ ");
INSERT INTO uli_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Iwe Abraham sa sor bo, ‘Layi, ho chil memangi yodwe ho molow we ho mel chog luwul pangal mmal? Ngo Lazarus iwe pangal metmetal hafohoy ngo ye mel iyang. Iwe ngo igla ila yesa momay depal mo iga ngo gel ila hosa mel luwul bbareg. ");
INSERT INTO uli_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iwe ngo igla ila sa mel sew formel lepdach le tor le be yoh le be chuy mo igla sa budoh iga. Iwe ngo tor le be yoh le be chuy mo iga sa buyoy igla.’ ");
INSERT INTO uli_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Iwe mal we ye mmal sa sor bo, ‘Temay Abraham, fael pechem ngo hobe hagloyuloh Lazarus irel imw la imwel mala temay. ");
INSERT INTO uli_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ye mel limmal mal bisiy le re mel iyang, ye bela hadpa ngalir bo rede la wol budoh lobos le liliyel bbareg.’ ");
INSERT INTO uli_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham sa sor bo, ‘Mekla wol bisim ila Moses mo profeta kowe resa hadpar. Mekla wol bisim ila be yoh le rebe talenga yalol ‘Moses mo Profeta kowe.’ ");
INSERT INTO uli_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Iwe ngo mal we ye mmal sa sor bo, ‘Temay Abraham, mekla ila ye ted lap ngalir! Hare semal ye molow tefael mo irel maes ngo yesa loh irer ngo rebe tagul tang molfidir.’ ");
INSERT INTO uli_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham sa sor bo, ‘Hare rebe te talenga yalol Moses mo profeta kowe, ngo ila mwo yela molow tefael semal mo irel maes ngo re towe chepar.’” ");
INSERT INTO uli_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus sa kangalur mokwe redabeyal bo, “Meka ma hasi ngal yarmat molfid ila ye faesul tugul le ma weldoh, iwe ngo ifa lepal hafohoy le be hola yeramtala yema foru maka. ");
INSERT INTO uli_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ye momay tapper rechokla le yarmat rebe hogoydah porow fael mekla yuyer resa ppedirloh lemdaw mo imol mala semal ir yede hasi ngal semal yalwich ka molfid. ");
INSERT INTO uli_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ila habe llugu dipmi irel mekla hama foru! “Hare semal bisim sa molfid, ngo hosa kaftoroy ngali, iwe ngo hare yesa rrig lal depal iyang, ila ngo hosa hachuyaloh luwalel mo lal depom. ");
INSERT INTO uli_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Hare be lal seral ngo fael fusuw yal molfid ngalug, iwe ngo wol miril sew molfid ka ngo sa budoh irem, yesa kangalug bo sa rrig depal, ila ngo hosa hachuyaloh luwalel mo lal depom.” ");
INSERT INTO uli_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostel kowe resa kangalu Samol bo, “Hakkela yamem tuglul laddep.” ");
INSERT INTO uli_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Samol sa sor bo, “Hare yor yami tugulul laddep le be lepal sefaes feasol mustard, ila ngo be yoh le habe kangal ire ka bo, ‘Tarhag dah ho sala fod leted!’ Iwe ngo ire la be talenga yalom. ");
INSERT INTO uli_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Hare ye wochog mala ye mel semal boy lol semal hami, le ma yengang woal milay hare ma kakamahor saaf. Yodla bela tefaeldoh mo woal milay ngo hama kangalu bo yebe hattiridoh bo yebe mongoy? ");
INSERT INTO uli_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ye tugul bo towe ila sengal! Habe far kangalu bo, ‘Hola ffaordoh mwo halay ngo hosa widyey ibe mongoy ngo iyul chael formel. Ibe rel moll ngo gel hosa moch mongoy.’ ");
INSERT INTO uli_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Boy we ila ye foforu yal yengang, ila ngo tor fal le habe kangalu yal hachigchig. Ila sengal hare yeb? ");
INSERT INTO uli_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ye hafedeg ngalugmi chog. Yodla ha bela hamallo pangal mekla habe foru ngo ha bele sor bo, ‘Gich chog sibis boy le si foforu yach yengang.’” ");
INSERT INTO uli_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yodwe Jesus ye loh Jerusalem ngo ye dar lepdal Samaria mo Galilee. ");
INSERT INTO uli_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yela harpadoh sew hasohsoh sala chungur seg mal le resa hafohoy irel mesel pekel. Re su chog mo medaw ngo ");
INSERT INTO uli_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","resa tawulagili, “Jesus! Masta! Fahohmem!” ");
INSERT INTO uli_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus yela wirir ngo yesa kangalur bo, “Ha roloh irel temarong kowe bo rebe kemahohmi hare sa chuy mesla mo uwomi.” Re chil dedarloh ngo sa chuyloh mesel pekel we mo uwor. ");
INSERT INTO uli_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yodwe semal mo irer yela gola bo sa chuyloh meswe mo uwol, ngo yesa tefael le ye tetawulagililoh yal kapingpinga Deus. ");
INSERT INTO uli_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesa hasubugudiy mo lengchel mokwe pechel Jesus ngo sa kangalu yal hachigchig. Mal we ila iy semal yeramtal Samaria. ");
INSERT INTO uli_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ngo Jesus sa sor bo, “Seg mal kowe ye moch chuy yar tomay, ila ngo ifa ir ikowe duwmal? ");
INSERT INTO uli_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Meda mele la wasola le chog mele yela tefaeldoh be kangal Deus yal hachigchig iyang?” ");
INSERT INTO uli_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesus sa kangalu bo, “Sudah bo hobe loh. Tugul la yam mele sa hachuya yam tomay.” ");
INSERT INTO uli_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tot Pharisees kowe re kasiya Jesus yodle be budoh mala Lamliyel Deus iyang. Jesus sa sor bo, “Mala Lamliyel Deus ila bele budoh ngo towe wochog meka sima faesul wiri. ");
INSERT INTO uli_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tor semal le be sor, ‘Ha kaladoh, molwe iye!’ hare ‘Ha kalloh, molwe ilay!’; bo mala Lamliyel Deus ila ye mel iremi.” ");
INSERT INTO uli_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iwe ngo yesa kangalur mokwe redabeyal bo, “Ye mel sew yad le bela hola ngo ha bele kekkable bo habe wiri seral mo irel mala falmayel mele Layur Retalop. Iwe ngo ha towe wiri. ");
INSERT INTO uli_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yor rechokla rebe kangalugmi bo ‘Ha kalloh iglay!’ hare, ‘Ha kaladoh iga!’ Iwe ngo hami ha towe talenga mekla re sosor. ");
INSERT INTO uli_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yal bela tefaeldoh mala Layur Retalop ila be igegel yod kowe yema ffis fedal lal laeng. ");
INSERT INTO uli_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Metamo ngo yebe kkel yal hafohoy, ngo yarmat fael mwole rebe hafobdiriy. ");
INSERT INTO uli_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yodla bela budoh mala Layur Retalop ila yebe wochog molwe wol mwol Noah. ");
INSERT INTO uli_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pangal yarmat ngo re rol kukubul ngo re riri fengal yee, la hola yodwe Noah ye bulong lal boat we ngo sa burssogloh ye sala mesloh pangal yarmat. ");
INSERT INTO uli_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wol ila sengal chog molwe wol mwol Lot. Pangal yarmat ngo re rol kukubul ngo re chuchuway ngo re memilay ngo re kekassu imw. ");
INSERT INTO uli_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ralawe Lot ye chuy tang Sodom ngo sa bidiy yaef mo sulfur mo wol laeng le ye wochog potog yar mesloh panger yarmat. ");
INSERT INTO uli_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Be ila sengal ralla bela budoh mala Layur Retalop. ");
INSERT INTO uli_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Bela ralale ngo semal le ye mel wol imwal ngo towe bulong yilim be hasi lital. Be wol ila sengal chog semal le yebe mel wol yal milay bo ye towe tefael ngal imwal. ");
INSERT INTO uli_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ha towe maligili molwe ye wel ngal molwe ril Lot! ");
INSERT INTO uli_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Semal le yebe hachangi yal nngas ngo be pung tangi, ngo te tugul semal le yebe mes le fael ngang, ngo yebe molow. ");
INSERT INTO uli_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ibe kangalugmi le bongol la ngo hare be mel rumal yarmat le rebe masor wol chog sew be, ngo semal ila rebe hasiloh ngo semal ila bela meldiy. ");
INSERT INTO uli_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Rumal fefel le rebe fofor mongoy: semal ila rebe hasiloh, ngo semal ila bela meldiy.” ");
INSERT INTO uli_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mokwe redabeyal resa kasiya, “Iya mele be weldoh mele mo iyang ho Samol?” Jesus sa sor bo, “Solbos le be yor chomes iyang, ngo ma tteydoh vultures iyang.” ");
INSERT INTO uli_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus sa kangalur mokwe redabeyal sew fiyong bo be haskuna ngalir bo rebe ma mapel loh chog ngo towe ma tayikel deper. ");
INSERT INTO uli_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ye mel semal chol tatelal hapatpat wol sew haplom le te motog Deus ngo tema hafalir yarmat. ");
INSERT INTO uli_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ngo ye mel semal fefel le sa mes yal habulupoy wol haplom we le sa ma budoh loh chog irel chol tatelal hapatpat we le ye kekefalpechey bo be tipingi. Fefel we sa kangalu chol tatelal hapatpat we bo, ‘Taldiyey mo irel yaramtala ye kekepaliyel ngalyey!’ ");
INSERT INTO uli_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ye sulay loh le chol tatelal hapatpat we ye temechal bo be tipingi fefel we. Yela wol miril ngo sa sor bo, ‘Ila mwo iy te motog Deus ngo iy te hafalir yarmat ngo iy bele tipingi fefel le. ");
INSERT INTO uli_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ibele taldi mo irel meka yesa weres iyang. Hare ibe te taldi, ngo ibele nguch irel yal budoh loh chog irey!’” ");
INSERT INTO uli_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iwe ngo Samol sa taboloh, “Hasa rongrong molwe mal we ye tayikof yal ma hapatpat ye sor. ");
INSERT INTO uli_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ila ngo Deus, towe tipingir mekla lol le re tetang ngali lubong mo leral bo yebe tipingir? Hare yebe keketalmoch irel yal be tipingir? ");
INSERT INTO uli_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ibe kangalugmi le iy ila be ttir yal hayho ngalir mekla re dipli. Ila ngo ye bela tefaeldoh mala Layur Retalop ngo be yor le iy yebe wiri le yor yal tugul mo wol talop le?” ");
INSERT INTO uli_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus ye wol yawli fiyong le ngalir rechokwe rema luglug ngalir chog wol halongor, iwe ngo rema tolpagilirloh yarmat: ");
INSERT INTO uli_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Seral ngo ye mel rumal mal le rela mapel lal Templum we. Semal Pharisees mo semal chol hateyel paliyel raeg. ");
INSERT INTO uli_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisees we sala muslog mo solbos sa mapel, ‘Hosa hachegcheg ho Deus le ngang iy te chehaw, ngo iy tema kachepar, ngo iy tema faor maltemay le be wochog yarmat cholop. Hosa hachigchig irel mala ngang ila iy te wochog yeramtala yema hattey paliyel raeg le ye mel mo iglay. ");
INSERT INTO uli_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Be sew wik ngo ma rural le iy ma supiy helay ngo iy ma fang ngalug sugfed mo irel salpiy ka ma yoh ngalyey.’ ");
INSERT INTO uli_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ngo yeramtawe ma hattey paliyel raeg ye su chog mo medaw le yete terdah le ye tutugu mala metal ubal ngo sa sor bo, ‘Deus, fahoy depom ngalyey bo ngang semal choto hamolfid!’” ");
INSERT INTO uli_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesus sa sor bo, “Ibe kangalugmi le te Pharisees we bo yeramtawe yema hattey paliyel raeg mele yela tefael ngal bugtal ngo sa fel mo fael metal Deus. Bo panger rechoka rebe hatagitar ngo rebe totol, ngo panger rechoka re hatetalor ngo rebe tagiyet.” ");
INSERT INTO uli_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tot yarmat re hasirdoh yalwich kala layur irel Jesus bo yebe yetedah paol uwor bo be mapelar. Mokwe redabeyal re wirir ngo resa kaftoroy ngalir irel molwe resa foru. ");
INSERT INTO uli_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngo Jesus yesa fesangur yalwich kowe ngo yesa sor bo, “Ha ligdir yalwich kala bo rebe budoh irey. Ha towe hapolahor bo mala Lamliyel Deus ila yar rechokla re tappilir yalwich ka! ");
INSERT INTO uli_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ha itol dipmi irel mele! Semal le be te hatugulu depal irel mala Lamliyel Deus le be wochog yal tugul semal yalwich ka ngo towe yoh ngali.” ");
INSERT INTO uli_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Semal mal kowe metal yalor Jews sa kasiya Jesus, “Sensey Momay, meda mele iy be foru ngo sa yoh ngalyey molow la tor siyal?” ");
INSERT INTO uli_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus sa kasiya, “Meda mele ho fesanguyey bo iy momay iyang? Tor semal le ye momay bo halachog Deus mele ye momay. ");
INSERT INTO uli_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ho gola hatobtob kowe: ‘Ho towe faor maltemay; ho towe limeseloh semal; ho towe peraf; ho towe tungu kaptal semal; hasrowu tamom mo solom.’” ");
INSERT INTO uli_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mal we yesa hatefali le ye sor, “Yodwe chog iy chil yalwich yee, yela holadoh igla ngo ima talenga chog pangal hatobtob ka.” ");
INSERT INTO uli_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yodwe Jesus yela rongrong mele ngo yesa kangalu bo, “Chil mel chog sew formel le hobe foru. Hola tape chuway pangal mekla litam ngo hosa hasiy mala salpiyal hosa ngaler maelhafohoy, ila ngo be paleng mmal la be holah mo wol laeng. Ngo hosa budoh bo hobe dabeyey.” ");
INSERT INTO uli_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yodwe mal we yela rongrong mele ngo sa kel tayikofel depal bo iy semal rechokwe ye mmal. ");
INSERT INTO uli_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus yesa gola lepal tayikofel depal ngo yesa sor bo, “Ifa lepal yal weres ngalir rechokla re mmal le rebe dohlong irel mala Lamliyel Deus! ");
INSERT INTO uli_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ye kkel yal weres ngal semal le ye mmal le be hola mala Lamliyel Deus mo imol semal kamang le be bulong lal chechel seyay did.” ");
INSERT INTO uli_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Rechokwe re rongrong mokwe ye sor resa kasiya bo, “Ila ngo itey mele yebe daor?” ");
INSERT INTO uli_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus yesa kangalur bo, “Meka towe yoh ngal yarmat ila be yoh ngal Deus.” ");
INSERT INTO uli_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedrus sa sor bo, “Kaladoh! Hasa tahcheloh bugtamem bo habe daboh!” ");
INSERT INTO uli_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus yesa kangalu, “Ila sengal, iwe ngo ibe hatugulu ngalugmi le te tugul semal le be ligdiloh bugtal hare ril hare bisil hare wulutugul hare lol le fael mala Lamliyel Deus, ");
INSERT INTO uli_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ngo ye paleng mala be yoh ngali fael mwoka, ngo be yoh ngali molow la tor siyal irel yod kala yebe budoh.” ");
INSERT INTO uli_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus sa palir chowe seg mo rumal we redabeyal re sala mus tang buwa we ngo yesa kangalur bo, “Ha talenga! Si bele roloh wol Jerusalem le ila lebola pangal mokwe profeta kowe re tefa irel kofal molwe Layur Retalop ngo bele la ppalu ngali le katos. ");
INSERT INTO uli_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bele yoh long lal payur Gentiles le re bele tapeli kamemal ngo re hapatpat tayikof irel ngo re gutdah uwol. ");
INSERT INTO uli_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Re bele wwodu ngo re limeseloh ngo bela solral mo wol miril ngo yesa molow tefael mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tor sew mokwe ye sor le mokwe redabeyal re medaf iyang. Mekla halongol fal ila ye llebag tangir ngo re togla mokwe Jesus ye kekapta kofal. ");
INSERT INTO uli_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yodwe Jesus yela harpadoh Jerico ngo ye mel semal mal le ye metafis le ye maroro wol ngchel yalap. Mal we ila yema dodongor loh chog hammalel. ");
INSERT INTO uli_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yodwe ye rongrong yalol yarmat yar dedarloh mo lengchel ngo yesa kasiy bo, “Meda mele?” ");
INSERT INTO uli_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Resa kangalu bo, “Jesusel Nazareth we iye sa dedarloh mo iga.” ");
INSERT INTO uli_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ngo yesa tawulagililoh le ye sor bo, “Jesus le lol David! Fahoy depom ngalyey!” ");
INSERT INTO uli_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Rechokwe re kekamo resa kaftoroy ngali bo be ppoloh. Iwe ngo iy yesa far hapalingidah tot yalol, “Lol David! Fahoy depom ngalyey!” ");
INSERT INTO uli_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus sa ppoloh ngo sa sor bo rebe paliloh mal we ye metafis irel. Yela harpa ngo Jesus yesa kasiya bo, ");
INSERT INTO uli_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Meda mele ho dipli bo ibe faor ngalug?” Ngo iy sa sor bo, “Idipli bo ibe wiri formel melap.” ");
INSERT INTO uli_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus yesa kangalu bo, “Ila ngo ho bele wiri formel. Yam tugulul laddep mele sa hachuya yam tomay.” ");
INSERT INTO uli_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yodwe chog ngo mal we sa wiri formel yesa dabey Jesus ngo yesa kangal Deus yal hachigchig. Yodwe buwa we rela wiri molwe ngo resa hapingpinga Deus. ");
INSERT INTO uli_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus ye bulong wol Jericho le ye loloh wol Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ye mel semal tamol hatteyel paliyel raeg le ye mmal le Zacchaeus mala idal. ");
INSERT INTO uli_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ye yedamgili bo be wiri yeramtala rema sor bo Jesus. Iwe ngo ye temmal le yebe wiri Jesus bo iy semal mal wechich ngo ye cholop yarmat loboswe. ");
INSERT INTO uli_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iwe yesa hamdaloh mo imol buwa we ye sala haradah yuchul sehay sycamore bo yebe wiri Jesus le ye bela dardoh loboswe. ");
INSERT INTO uli_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yodwe Jesus yela hola doh lobowe ngo yesa kaladah ngo sa kangalu Zacchaeus, “Hatturugdiy ho Zacchaeus bo ngang ibe mel irel imw we imwom igla.” ");
INSERT INTO uli_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus yesa hattiridiy le sa momay depal bo iy ye dipli le Jesus yebe ppaoy irel imw we imwal. ");
INSERT INTO uli_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Panger rechokwe re wiri molwe ngo resa chapiy yar lunglung le re sor bo, “Mal le ye bele loh irel imw la imwel yeramtala ye toa hamolfid!” ");
INSERT INTO uli_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacchaeus yesa sudah ngo sa kangalu Samol bo, “Talenga! Ibele fang ngalir maelhofohoy setob mo irel mekla litay, ngo hare isa kachepra semal le isa hasi lital, ila ngo ibe hatefali ngali le be fael faw yal cholop tang mekla lital le ngang ihasi.” ");
INSERT INTO uli_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus sa kangalu bo, “Deus yesa hardorar chol imw le igla bo mal le ila wol iy semal chol daowe yael Abraham. ");
INSERT INTO uli_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mala Layur Retalop ye budoh bo be merir ngo ye hadorar rechokla resa mwael loh.” ");
INSERT INTO uli_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yodwe yarmat re chil tetalenga molwe ngo Jesus sa taboloh yal hapatpat le sa kangalur sew fiyong. Irel yodle ngo sa harep le Jesus bele hola Jerusalem. Iwe ngo panger rechokwe ngo resa luluwaley le mala Lamliyal Deus ila sa harep le bele llahdoh. ");
INSERT INTO uli_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iwe Jesus yesa sor bo, “Ye mel semal mal le ye tagiyet le be loh wol sew fuluy le ye ddawloh bo re bela habulango fael tamol ngo sa tefael ngal bugtal. ");
INSERT INTO uli_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Imol molwe be loh ngo sa fesangu fengalir boy kowe yal we seg. Be semal ir ngo ye ngaley sefaes faesol salpiy kowe hoal ngo sa kangalur bo, ‘Ha kemahoy lepal mele be yohdoh mo irel yami be hayengangali salpiy kala irel yodle iy tamel ngalugmi iyang.’ ");
INSERT INTO uli_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Iwe mokwe chol faluyal resa hafobdiriloh. Resa hagloyur loh tot yarmat mo wol miril bo re bela sor bo: ‘Hamem hate dipli mal le bo yebe mel bo yamem king.’ ");
INSERT INTO uli_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Yela mel mal we bo semal king ngo yesa tefael ngal molwe bugtal. Irel yodla chog ngo yesa sor bo be budoh boy kowe irel bo yebe gola lepal salpiy le sa yohdoh mo irel saliy kowe ye fang ngalir. ");
INSERT INTO uli_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Iwe metamo sa budoh ngo sa kangalu bo, ‘Ngang ila seg faesol salpiy le hoal mele ye yohdoh mo irel salpiy we ho fang ngalyey bo iy be hayengangali.’ ");
INSERT INTO uli_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Iwe ngo sa kangalu bo, ‘Ye momay mala ho foru. Gel semal boy le ho momay. Ila, fal mala ye fel yam yengtali meka ye pachigchig, mele iy bele yitulug bo hobe lamli seg haplom iyang.’ ");
INSERT INTO uli_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yela budoh iwe harumalel boy yesa sor bo, ‘Iwe ho fang bo ibe hayengangali, ila limfaes faesol salpiy hoal mele ye yohdoh mo iyang.’ ");
INSERT INTO uli_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Iwe ngo king we yesa kangalu bo, ‘Gel ila ho bele lamli lemow haplom.’ ");
INSERT INTO uli_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yela budoh boy we semal ngo sa sor bo, ‘Melap, salpiy hoal we lom iye ilebaglilong lal sedep mengag. ");
INSERT INTO uli_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Imetagug bo ho tema fahor yarmat. Homa hasi mekla te litam, ngo homa hasi mekla te gel mele ho fadgu.’ ");
INSERT INTO uli_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Iwe ngo king we yesa kangalu bo, ‘Gel semal boy le ho tayikof! Hapatpat kala hosa sor mele ibele tapeli irel yai hatugulu yam hagerger. Ho gola le ngang semal yarmat le itema fahor yarmat, ngo ima hasi mekla te litay ngo ihasi mekla te ngang mele ifadgu. ");
INSERT INTO uli_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Meda fal le hote itol salpiy la layi lal bank iyang? Ila ngo ibela tefael ngo isa hasi le sa yor win iyang.’ ");
INSERT INTO uli_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iwe yesa kangalur rechokwe re su loboswe bo, ‘Ha hasi faesol salpiy la mo irel ngo hasa ngaley boy la seg faesol salpiy le ye mel irel.’ ");
INSERT INTO uli_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ngo ir resa sor bo, ‘Melap, iy ila sa faesul mel seg faesol salpiy hoal irel!’ ");
INSERT INTO uli_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Iwe yesa kangalur bo, ‘Ibe kangalugmi le semal le yor tot formel irel ila ye cholop mele rebe ngaley ngo yeramtala tor mele yor irel, ila lepal sugfed le ye mel irel ngo rebe hasi tangi.’ ");
INSERT INTO uli_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Iwe ngo rechokla re ma hapaliyel ngalyey le rete dipliyey bo ibe mel bo yar king, ila habe hasirdoh iga bo habe llirdiy fael metay!’” ");
INSERT INTO uli_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yela mol yael Jesus sor molwe ngo yesa hamo resa roloh Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yodwe re harpadoh Bethphage mo Bethany mo irel molwe Tayitel Olives ngo yesa hamowarloh rumal mokwe redabeyal le yesa kangalur mekla re bela foru. ");
INSERT INTO uli_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ha hamo loh irel haplom lay. Ha bela bulong iyang ngo habe wiri semal donkey le ye hogoy le tedyor mwo le ye dage. Ha basi mala ffarol ngo hasa palidoh iga. ");
INSERT INTO uli_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Hare semal yesa kasiyahmi hare meda fal le ha basi iyang, ngo hasa kangalu bo Masta we yebe teptap.” ");
INSERT INTO uli_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Resa loh re sala wiri pangal mokwe le igegel chog mokwe Jesus ye kangalur. ");
INSERT INTO uli_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yodwe re bebesi mael we ngo yeramtawe lol sa kasiyar, “Meda mele hasa bebesi mael la iyang?” ");
INSERT INTO uli_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iwe ngo resa sor bo, “Masta we yamem yebe teptap iyang.” ");
INSERT INTO uli_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iwe resa hasiloh mael we irel Jesus. Resa yitetdah mengag uwol mael we ngo resa tipingi Jesus be chudah yuchul. ");
INSERT INTO uli_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yodwe yesa dadageloh mael we ngo yarmat resa fferagloh mengag lal yalap we. ");
INSERT INTO uli_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yodwe yesa harpa Jerusalem le yesa mel irel yalap we ye bidiy mo wol molwe Tayitel Olives, ngo buwa paleng we re dabeyal resa chapiy yar kangal Deus yal hachigchig irel pangal mokwe ye weldoh we resa wiri. Resa kapingpinga Deus le ye paleng yalor le re sor bo, ");
INSERT INTO uli_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Deus be holbuwa king la ye budoh fael mala Idel Samol! Hopos mo Falmay be mel chog irel Deus le ye mel wol laeng!” ");
INSERT INTO uli_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Iwe ngo tot Pharisees kowe re mel luwul buwa we resa kangalu Jesus bo, “Sensey, kangalur mekla redabeyem bo rebe ppoloh!” ");
INSERT INTO uli_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus sa sor bo, “Ibe kangalugmi le hare ir rebe ppoloh, ila ngo pangal loh feas ka ngo re bele chapiy yar tawul.” ");
INSERT INTO uli_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yela kalngal haplom we irel yodwe sa harpadoh ngo yesa tang irel yal fahoy, ");
INSERT INTO uli_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ngo sa sor bo, “Dehabel mele ho gola mele be hasi ngalug hopos. Iwe ngo igla ila ho ted gola! ");
INSERT INTO uli_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ye bele hola yodla rechokla re tayikof ngalug re bele langbahloh ngo re yororah, ngo re foru bo tayor le be bulong hare ye buyoy. Ngo re bele chapiy yar llug le rebe fedegdoh mo pangal lobos. ");
INSERT INTO uli_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Re bele hamderahloh le tor sefaes le be mmochdiy liliyal ngo re limeserloh rechokla re mel lal yoror la yam, bo fael mala gel ho togla yodwe Deus ye budoh bo be hadaorah iyang.” ");
INSERT INTO uli_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iwe yesa bulong Jesus lal Templum we sala ddabsulurwey rechokwe re tetap chuway formel iyang, ");
INSERT INTO uli_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","le ye kangalur bo, “Ye teftaf lal Babior we ye Santus le Deus ye sor bo, ‘Templum le yai ila yebe mel bo sew imwel mapel.’ Ngo hami hasa itol bo imwer chomachoh!” ");
INSERT INTO uli_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pangal ral ngo Jesus ma foloy lal Templum we. Tamol temarong kowe mo mokwe sensel Hatobtob, we mo mokwe metal yalor yarmat resa luluwaley bo rebe limeseloh Jesus. ");
INSERT INTO uli_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Iwe ngo tor mele re gola le rebe for ngali bo fal mala pangal loh yarmat ngo re talenga foloy kowe yal ngo rete dipli le rebe te rongrong sepad mo iyang. ");
INSERT INTO uli_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Seral le Jesus ye kekaskun yarmat mo lal Templum we, ngo ye fofoloyu ngalir Hapatpat Momay we ngo tamol temarong kowe mo mokwe sensel Hatobtob we resa rol chufengal mo mal kowe yar ");
INSERT INTO uli_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","resa budoh irel resa kangalu bo, “Kangalugmem hare iya mele yela budoh kkelem mo iyang le gel hobe foloyu meka ika sengal? Itey le ye fang ngalug kkelem?” ");
INSERT INTO uli_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus sa kangalur bo, “Ha widyey ibe kasiyahmi mwo sew kasiy, igla. Ha kangalyei, ");
INSERT INTO uli_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Iya mele ye budoh molwe kkelel Johannes le be baptismus mo iyang. Ye budoh mo irel Deus hare ye budoh mo irel yarmat?” ");
INSERT INTO uli_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iwe ngo sa chap yar hachocho fengal uwor le re sor bo, “Meda mele sibe sor? Hare sibe sor bo, ‘Ye budoh mo irel Deus,’ ila ngo iy ye bele sor bo, ‘Meda fal le hate chepar ngal Johannes iyang?’ ");
INSERT INTO uli_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iwe ngo hare sibe sor bo, ‘Ye budoh mo irel yarmat,’ ila ngo buwa le iga re bele hacchifgich bo ir ila ye tugul lal deper le Johannes ila semal profeta.” ");
INSERT INTO uli_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iwe resa sor bo, “Ha togla lobos le ye budoh mo iyang.” ");
INSERT INTO uli_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus sa sor bo, “Ila ngo ngang itowe kangalugmi lobole ye budoh kkeley mo iyang le ibe foru meka.” ");
INSERT INTO uli_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iwe ngo Jesus yesa kangalur rechokwe fiyong le: “Fael sew yad ngo ye mel semal mal le ye fadgu sew milayel grape, iwe ngo yesa hafle ngalir sibis yarmat bo rebe kekamale. Iwe ngo iy ye sala malekah le ye ssulay. ");
INSERT INTO uli_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yela hola yodwe re bele gilsi grape kowe iyang, ngo mal we yesa hafdaleloh semal boy kowe lol irer rechokwe re kekamahoy milay we bo bela hasi mele yildil mo irel uwal milay we. Chol milay kowe resa lliy boy we ngo resa fang tefael loh le tor mele ye hasi. ");
INSERT INTO uli_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Iwe ngo mal we yesa wol fang loh semal boy kowe; iwe ngo chol milay kowe resa wol lliy ngo re hatalngali fedaley ngo resa wol fang tefael loh iy le tor mele ye hasi. ");
INSERT INTO uli_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mal we yesa wol fangloh semal boy; ngo chol milay kowe re hasi resa hawsi resa pedawey lugul yoror. ");
INSERT INTO uli_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Iwe yeramtawe yal vineyard we sa sor bo, ‘Ila ngo meda mele iy bele foru? Iy bele fangloh mele layi le iy hachangi; bo ye tugul le rebe hasrowu!’ ");
INSERT INTO uli_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngo yodwe chol milay kowe rela wiri ngo resa kapta fengali uwor bo, ‘Iye mal we lol yeramtawe bugtal mele. Siya limeseloh, ila ngo ye be mel mele bo bugtach!’ ");
INSERT INTO uli_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Iwe resa ppediwey mo lugul vineyard we re sala limeseloh mo iyang.” Jesus yes kasiyar bo, “Meda mele yeramtawe yal vineyard we yebe foru ngalir chol milay kowe? ");
INSERT INTO uli_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ye bele budoh sa llir mal kala ngo sa ngaler sibis vineyard we bo rebe hammale.” Molwe rechokwe rela rongrong mele ngo resa sor bo, “Towe yoh mala ila sengal!” ");
INSERT INTO uli_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus yesa kal ngalir ngo yesa kasiyar bo, “Ila ngo meda fal mele ye mel lal babior we ye santus? ‘Feas we chol hasul imw we re pediloh bo tor pelal mele sala mel bo ila mele ye hartal paleng pelal mo luwol pangal.’ ");
INSERT INTO uli_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Panger rechoka rebe ppungdiy wol feas la ngo rebe gufedfedloh; iwe ngo hare yebe ppungdiy feas la uwol semal ngo yebe hapetteloh sala wochog mormorol piy.” ");
INSERT INTO uli_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mokwe sensel Hatobtob we mo tamol temarong kowe resa memmeal bo rebe dorfi chog Jesus mo loboswe bo resa gola le ir molwe Jesus yesa fiyongo kofar. Iwe ngo re metagur rechokwe re ssoeg loboswe. ");
INSERT INTO uli_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Iwe resa widi ngal sew yad le yebe mmal. Resa ffag paliyer sibis mal bo re bela forurloh le re katos, iwe resa halahor bo re bela mekada Jesus bo rebe ddorfi mo irel yal hapatpat bo hare be yoh le ir rebe fanglong iy lal paol Aamel Roma la yor kkelal. ");
INSERT INTO uli_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ir spy ka resa kangalu Jesus bo, “Sensey, ha gola le mekla ho sosor ngo ho foloyu ila ye bung. Ha gola le gel ila ho hafidgiloh chog semal mo semal yarmat. Homa foloyu chog mala ye katos le kofal mala depel Deus ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kangalugmem igla, ye fel mo irel Hatobtob we yach hare ye tafel le sibe fang paliyel raeg ngal mala Llulupal Roma?” ");
INSERT INTO uli_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iwe ngo Jesus ye gola mekad we yar ngo yesa kangalur bo, ");
INSERT INTO uli_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ha kewar ngalyey sefaes faesol salpiy kowe silver. Yongol itey ngo idel itey mele ye mel uwol?” Ngo ir resa sor bo, “Llulupal Aam we.” ");
INSERT INTO uli_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iwe Jesus yesa kangalur bo, ‘Ila ngo, hasa fang ngal Llulupal Aam la mekla lamliyel Llulupal Aam, ngo hasa fang ngal Deus ikla Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ye teyoh ngalir le rebe dorfi Jesus irel sepad hapatpat, mo imor yarmat kowe loboswe. Iwe resa poloh le re tay malili bo resa lluwdah irel tefalel kasiy we yar. ");
INSERT INTO uli_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Iwe ngo tot mo irer Sadducees kowe re sor bo tor mele molow tefael mo irel maes, resa budoh irel Jesus ngo resa sor bo, ");
INSERT INTO uli_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Sensey, Moses ye tefa hatobtob le bo yach: ‘Hare semal mal ye mes ngo yesa ligdi fefel la ril le tor layur, ila ngo mal la bisil yebe ppaoy ngaliy fefel we bo hare be yor layur bo rebe mel bo lol mal we sa mes.’ ");
INSERT INTO uli_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ye mel fismol mal le re bisbis; iwe moal yarmat ye riri ngo tedyor lol ngo yesa mes. ");
INSERT INTO uli_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Iwe ngo molwe harumalel yarmat sa wol rili fefel we, ngo wol tappel chog molwe mele ye wel ngali. ");
INSERT INTO uli_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Iwe ngo iwe hasolmolol yarmat yesa wol rili. Panger bisbis we fismol ngo ye hafedegloh chog molwe ye wel ngalir, panger ngo re rili fefel we ngo re mesloh le tor layur. ");
INSERT INTO uli_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yela wol miril loh ngo yesa moch mes fefel we. ");
INSERT INTO uli_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Iwe, ralla bela molow tefael yarmat mo irel maes, ngo itey semal ir le be mel fefel we bo ril? Bo iwe panger chowe fismol ngo re ppaoy ngal fefel we.” ");
INSERT INTO uli_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus sa kangalur bo, “Mal mo fefel fael mwole mele rema riri, ");
INSERT INTO uli_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","iwe ngo mal mo fefel kala ye fel igeger le rebe molow tefael mo irel maes ila rebe molow irel yodla be budoh ila re towe riri. ");
INSERT INTO uli_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Re bele wochog angelus ngo re towol mes. Ika meka lol Deus bo resa molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Iwe ngo Moses ye halehaloh le ye katos le chomes ila resa molow tefael mo irel maes. Irel lobowe ye kapta kofal peel ire we ye bulbul ngo ye sor irel Samol bo, ‘Deus we yael Abraham, mo Isaac, mo Jacob.’ ");
INSERT INTO uli_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Te iy yar chomes Deus, bo iy yar chomolow Deus, bo iy ila panger yarmat ngo re molow mo irel.” ");
INSERT INTO uli_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sibis sensel Hatobtob we resa malili le re sor bo, “Ye momay tefalel kasiy we yamem ho Sensey!” ");
INSERT INTO uli_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Re sor mele bo re tay mechal bo rebe wol kasiya tot kasiy. ");
INSERT INTO uli_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus yesa kasiyar bo, “Ifa sengal chog ngo re sala sor le Kristus ila semal chol daowe yal David? ");
INSERT INTO uli_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bo David iwe ye spegil sor mo lal babior we Psalm we ye sor bo, ‘Samol ye kangal yai Samol bo: Marro mo rele gilemra irey ");
INSERT INTO uli_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","yee, la hola yodla iy be yitilir rechokla re tayikof ngalug bo liliyel pechem.’ ");
INSERT INTO uli_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David yema ffesang ngali bo ‘Samol’; ila ngo be ifa sengal ngo Kristus ye sala budoh mo irel daowe yael David?” ");
INSERT INTO uli_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Irel yodwe pangal yarmat ngo re tetalenga mokwe ye sosor, ngo Jesus yesa kangalur mokwe redabeyal bo, ");
INSERT INTO uli_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Habe llugu dipmi irer mekla sensel Hatobtob we, le rema dipli chog bo rebe darfedal le re mengag irel mengag kowe ye lelay, ngo rema dipli le yarmat rebe ma hasaror mo loboka liliyel market le rema toa tteydoh yarmat iyang; rema duwley chog chiya kowe ye musloh mo lal imwel ttey kowe, ngo rema dduwel chog chiya kala liliyer cho tagiyet bo liliyer mo irel gubul kala rema la dabey. ");
INSERT INTO uli_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yema ffal deper uwor fefel kala sa mes rir, ngo re pere tangir mekla bugtar, iwe ngo rema kkawerwer mapel kala yar le ye lelay. Ila yebe hartal kkel yar hagerger.” ");
INSERT INTO uli_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yela kaloh Jesus sala wirir sibis rechokwe ye cholop layur salpiy le re pepelong yar maligach lal liliyel maligach we ye mel lal Templum we, ");
INSERT INTO uli_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iwe ngo ye wol wiri semal fefel le ye kkel yal hafohoy ngo sa mes ril, le ye pedilong rufaes kobre checha lal liliyel maligach we. ");
INSERT INTO uli_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesus yesa sor bo, “Ibe kangalugmi le fefel la ye hafohoy ngo yesa mes ril ila ye paleng maligach le ye fang mo imor panger rechokla sibis. ");
INSERT INTO uli_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bo rechokla tot ila re fang yar maligach mo irel salpiy kala layur le ye cholop. Iwe ngo fefel le iye lepal yal hafohoy ila sa fangloh pangal salpiy la hammalel le ye mel irel bo yal maligach.” ");
INSERT INTO uli_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tot mokwe redabeyel Jesus re kekapta Templum we, irel mala kamdidiyal mo momayel mekla hawwulyal mo maligach kala rema fang ngal Deus mo iyang. Iwe ngo Jesus yesa sor bo, ");
INSERT INTO uli_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Pangal meka ha wiri ngo ye mel sew yad le bele budoh le tor sefeas feas ka ye fetfatdah le be chil mel diy liliyal; bo pangal ngo ye bele taroprop diy wototol.” ");
INSERT INTO uli_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iwe ngo resa kasiya bo, “Sensey, yinged iy yodla ho sosor? Ngo meda mele yebe weldoh ngo siya gola le yesa hola iy yodla bele weldoh iy mekla iyang?” ");
INSERT INTO uli_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus yesa sor bo, “Ha llugu dipmi bo rede kacheprahmi. Bo ye cholop le ye bele budoh le yebe tapeli mele idey, le rebe sor bo, ‘Ngang mele Kristus ngo yesa hola yodwe!’ Iwe ngo ha towe daber. ");
INSERT INTO uli_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ha towe motog le ha bela rongrong kaptal fedeg mo wahehe; bo ikla mekla yebe moal hamodoh, iwe ngo halachog ila te harep miril faileng.” ");
INSERT INTO uli_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesa taboloh ngo yesa sor bo, “Sew mo sew fulu ila re bele fedeg fengal; iwe ngo sere mo sere tamol ila re bele fedeg fengal. ");
INSERT INTO uli_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ye bele kkel folmor mo langda mo misilpig pangal lobos. Yor mekla ye hamotog ngo ye wel le ye bele bidiy mo lal laeng. ");
INSERT INTO uli_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Imol mala yebe wel meka ngo re be dorfugmi ngo re llugmi; re bele fangloh hami bo re bela hatugulu kofami mo lal imwel ttey kala yar ngo rebe yitlugmlong lal kalbus; rebe hasugmilong fael meter king mo tamol le fael ngang. ");
INSERT INTO uli_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ika yod kala habe kapta kofal Hapatpat Momay we iyang. ");
INSERT INTO uli_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ha hatugulu mo lal yami luluwal le ha towe merah irel yodla le hare meda mele habe sor irel yami taldugmi, ");
INSERT INTO uli_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","bo ngang mele iy be fang ngalugmi repiymi mo mekla habe sor le tor semal rechokla rebe hapaliyel ngalugmi le be yoh ngali le yebe pagu mekla hami habe sor. ");
INSERT INTO uli_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mekla wulutugmi mo wol bismi mo chol bugtami mo wol maryarmi mele re be fangloh hami; ngo yor tot hami le rebe limeserloh. ");
INSERT INTO uli_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pangal yarmat ngo re bele hafobudrugmiy le fael ngang. ");
INSERT INTO uli_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Iwe ngo tor seyal mekla yaelchimi le be pungloh. ");
INSERT INTO uli_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ha yedamgel bo ila ngo habe daor. ");
INSERT INTO uli_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Yodla ha bela wiri Jerusalem le sa longobloh irel saldaw, ngo ha bele gola le ye towol ssulay ngo ye bele gufedfedloh. ");
INSERT INTO uli_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iwe ngo rechokla re mel wol Judea re bele ddar bo rebe bidah luwul tayit; ngo ikla re mel luwul haplom re bele hawloh, ngo ikla re mel mo lugul haplom ila re towol bulong luwul haplom. ");
INSERT INTO uli_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bo ila mala fael ‘Yodol Hagerger,’ bo yebe hayaho pangal mokwe Babior we ye Santus ye sor. ");
INSERT INTO uli_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yebe kkel yar hafohoy fefel kala re siyal iwe mo fefel kala ye chil loyuchol layur! Yebe kkel hafohoy la yebe budoh wol fuluy; iwe ngo hagerger la yael Deus yebe holar yarmat. ");
INSERT INTO uli_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sibis ir ila rebe mes irel sayden, ngo ikla sibis ila re bele hasir bo chol kalbus wol sew mo sew fuluy; ngo rechokla tor yar tugulul ladep ila re bele budoh lamliloh Jerusalem yee, la hola yodla yodol. ");
INSERT INTO uli_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Yor mekla bele wel ngal yaal mo meram mo fiis. Ngo pangal meka faluyel talople ngo re bele motog taed le bele kkel mo pupungul law. Iwe ngo bele pog deper. ");
INSERT INTO uli_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yarmat re bele remasol loh irel yar motog irel mala ye bele budoh wol talople, bo pangal mekla lal laeng ngo bele chuy mo liliyal. ");
INSERT INTO uli_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iwe ngo ye bele llahdoh mala Layur Retalop le yebe budoh wol sedep darmiy luwul mala kkelal mo falmay la yal. ");
INSERT INTO uli_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yebe chap yal weldoh meka ngo hasa terah metami hasa hakkela lal dipmi, bo yami molow ila yesa harep.” ");
INSERT INTO uli_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iwe ngo Jesus yesa kangalur fiyong le: “Ha luwaley sehay fig hare te tugul sehay ire. ");
INSERT INTO uli_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yodla habe wiri le sa fetar, ngo hasa gola le sa harep lerreg. ");
INSERT INTO uli_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Be wol ila sangal chog irel yodla ha bela wiri meka le yesa weweldoh bo ha bele gola le mala Lamliyel Deus ila ye bele budoh. ");
INSERT INTO uli_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ha luwaley chog le pangal meka ngo yebe weldoh mo imol mala rebe mes rechoka re molow igla. ");
INSERT INTO uli_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yebe moaloh laeng mo talop ngo meka yaloy ila tor mo fael sew le be moa. ");
INSERT INTO uli_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Habe llugu dipmi bo hade gubul loh chog ngo ha habelasloh chog ngo ha merahloh chog irel mekla mmalmi wol talople, bo hade tedap loh chog ngo sa hola ralla iy ha sala yoh iyang, ");
INSERT INTO uli_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","le be wochog bo ya yoh irel sew tafich. Bo ralla iy ila yebe holar panger yarmat mo pangal lobos mo wol talop le. ");
INSERT INTO uli_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ha llugu dipmi ngo ha memapel pangal yodol bo be yor kkelmi bo habe daor irel yodla habe la bulong luwul pangal meka ye bele weldoh ngo yebe yoh le ha bela su imol mala Layur Retalop.” ");
INSERT INTO uli_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Irel yodka ngo Jesus ye fofoloy chog lal Templum we. Iwe ngo bela lefhafdoh ngo yesa bidah wol molwe Tayitel Olives sala mel iyang yee, la rael. ");
INSERT INTO uli_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ngo pangal yarmat ngo rema loh irel Templum we pangal lemagugul seral mo seral bo re bela talenga foloy kowe yal. ");
INSERT INTO uli_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yesa harep molwe Bungul Flowa we tema yor Habboloh iyang, we rema sor bo Paska. ");
INSERT INTO uli_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tamol temarong kowe mo mokwe sensel Hatobtob we resa memeri sew fil le be yoh le rebe limeseloh Jesus le tor le be gula bo mil mala re metagur yarmat. ");
INSERT INTO uli_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iwe Satan sa wigid depel Judas we rema ffesangu bo Iscariot, we iy semal chowe seg mo rumal we redabeyel Jesus. ");
INSERT INTO uli_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iwe Judas yesa loh sala malili ngalir tamol temarong kowe mo tamol kowe yar mokwe posol Templum we irel igegel kofal yal be fang ngalir Jesus. ");
INSERT INTO uli_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ye fel deper iyang ngo resa sor bo rebe fang ngali Judas salpiy. ");
INSERT INTO uli_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ye dipli molwe; iwe sa chap yal memeri fedaley sew yad le yebe hayaho long Jesus lal payur le yarmat re towe gola. ");
INSERT INTO uli_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yesa hola yodwe iy mo irel molwe Bungul Flowa we tema yor Haboloh iyang we rema lliy saaf kowe bo Mongol Paska. ");
INSERT INTO uli_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus yesa hafdaleloh Pedrus mo John le kangalur bo, “Ha loh ha bela hafle Mongol Paska we bo sibe rol mongoy.” ");
INSERT INTO uli_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ngo ir resa kasiya bo, “Iya mele ho dipli le ha bela foru mo iyang?” ");
INSERT INTO uli_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus sa kangalur bo, “Ha bela bulong wol haplom la, ngo habe chungu semal mal le ye hasi sew rumel chael. Ha dabey miril yee, hala bulong lal imw la yebe bulong iyang, ");
INSERT INTO uli_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ngo hasa kangalu yeramtala imwal mala bo: ‘Sensey we ye sor bo habe kasiyah hare, ifa sengil we iy mo meka redabeyal rebe hangi Mongol Paska we mo iyang?’ ");
INSERT INTO uli_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iwe ngo iy ye bele kewar ngalugmi sew sengil le ye paleng le ye mel irel dalla uwol, ila lobola ha bela hafle pangal formel mo iyang.” ");
INSERT INTO uli_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iwe resa loh re sala wiri pangal mokwe le ye tappel chog molwe Jesus ye kangalur, iwe resa hafforu mongol Paska we. ");
INSERT INTO uli_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Molwe yela hola yodwe ngo Jesus ye sa marodiy irer mokwe redabeyal irel tis we. ");
INSERT INTO uli_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesus yesa kangalur bo, “Ye kel yai dipli le sibe hangi fengali mongol Paska le mo imol mala ibe mes! ");
INSERT INTO uli_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ibe kangalugmi le tayor fael sew le ibe chil mongoy mele Mongol Paska yee, la hola yodla ye be llah mala halongol fae melel Mongol Paska mo irel mala Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iwe ngo Jesus yesa hasi sew kap, sa kangal Deus yal hachigchig ngo sa sor bo, “Ha hasi habe yul mo iyang ngo hasa hadayu luwulumi. ");
INSERT INTO uli_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ibe kangalugmi le tayor fael sew le ibe chil yul mo irel wine le yee, la hola yodla yebe budoh mala Lamliyel Deus iyang.” ");
INSERT INTO uli_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iwe ngo yesa hasi sew flowa, sa kangalu Deus yal hachigchig. Yesa dipiy sa ngaler, ngo sa sor bo, “Mele ila holongoy, le isa fang bo yaglugmi. Ha faor mele bo iy be ma mmang ngalugmi.” ");
INSERT INTO uli_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wol ila sengal chog mele ye foru mo wol miril mongol fehaf we yar, bo ye ngaler kap we ngo sa sor bo, “Kap le ila bogtag la yael Deus le ye tefoy le mele cchay le bele serloh bo yaglugmi, mele ye bele mel bo tugulul. ");
INSERT INTO uli_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ha kalladoh! Yeramtala bele fangloh ngang, ila ye mel irech irel tis le igla! ");
INSERT INTO uli_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mala Layur Retalop ila bele mes bo ila mala Deus ye hatugulu, ngo ifa lepal tayikof la bele hola yeramtala bele fangloh mala Layur Retalop!” ");
INSERT INTO uli_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iwe resa chapiy yar kasiy fengal uwor hare itey semal mo luwulur le iy mele yebe foru molwe. ");
INSERT INTO uli_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Resa rol hapaliyel fengal mokwe redabeyel Jesus hare itey semal mo luwulur le yebe tagiyet. ");
INSERT INTO uli_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iwe Jesus yesa kangalur bo, “Kingel fuluy kala rete chepar irel Deus ila yor kkeler uwor layur yarmat, iwe ngo tamol sew mo sew fuluy ila re sor bo ‘Ir Maryarer pangal Yarmat.’ ");
INSERT INTO uli_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Iwe ngo hami ila towe ila sangmi; bo yeramtala ye hartal tagiyet mo luwulumi ila iy mele be mel le be hartal totol, iwe ngo yeramtala ye mel bo yami tamol, ila be mel le be wochog semal boy. ");
INSERT INTO uli_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Itey le ye tagiyet, yeramtala sa marodiy bele mongoy hare yeramtala yema ffaordoh hal mongoy? Ye tugul bo yeramtala sa marodiy bele mongoy. Iwe ngo ngang ila iy mel luwulumi le iy wochog semal boy. ");
INSERT INTO uli_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Pangal hafohoy ka ye holayey ngo hami ha dabeyey iyang le hate tahcheyeyloh. ");
INSERT INTO uli_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngang ibele kkelmi le be wochog yael mala Temay fang kkeley bo ibe lamlir mekla lol. ");
INSERT INTO uli_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Habe mongoy ngo ha yul chael formel mo irel tis la yai mo irel mala Lamliyey ngo habe marro wol chiya kala liliyer tamol bo habe lamli mokwe halengel Israel we seg mo ruwow. ");
INSERT INTO uli_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon! Talenga! Deus sa hatale ngal Satan bo be haglahmi pangamiloh, bo yebe hayagir chomomay tangir chotayikof le be wochog semal chol milay irel yal ma hayagiy wheat kala ye momay tang mekla pispisil. ");
INSERT INTO uli_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iwe ngo imemapelah gel Simon bo yede ppung tangug yam tugulul ladep. Iwe ngo ho bela tefael ngalyey ngo gel hobe hakkela yar tugul meka wol bisim.” ");
INSERT INTO uli_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Iwe ngo Pedrus sa sor bo, “Samol, isa faesul fel le ibe dabohloh lal kalbus ngo idaboh irel maes!” ");
INSERT INTO uli_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus sa kangalu bo, “Pedrus, ibe kangalug le towe kkogo malog bongey yee, la fael suluw yam sor le gel ho toglayey.” ");
INSERT INTO uli_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iwe Jesus sa kasiyar mokwe redabeyal, “Yodwe ifangloh hami ha bela foloy fedal we tor yami botow mo tutuw mo yami bwela, ngo yor mele ha hafohoy iyang?” Iwe ngo ir resa sor bo, “Tor mele ha hafohoy iyang.” ");
INSERT INTO uli_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iwe Jesus sa kangalur bo, “Ila ngo igla ila, te tugul semal hami le yor yal botow hare tutuw ngo yebe hasi; ngo semal le tor lol sayden ngo yesa tap chuway mala hotal bo yebe chuway lol sayden. ");
INSERT INTO uli_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bo ibe kangalugmi le mekla tamel lal yadol babior we ye santus we ye sor bo, ‘Rebe hachuy ngalir rechokla resa hatawsi hatobtob’ ila ye kapta kofay ngo be lah le ye katos. Bo pangal mekla ye teftaf le kofay ngo yebe llahloh le katos.” ");
INSERT INTO uli_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iwe ngo mokwe redabeyal resa sor bo, “Kaladoh ho Samol! Ruyay sayden ika!” Iwe ngo iy yesa sor bo, “Mayila bo sa lap!” ");
INSERT INTO uli_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus yesa chuy tang haplom we sa loh wol molwe Tayitel Olives we ye mala faesul loh iyang. Iwe ngo mokwe redabeyal re dabey. ");
INSERT INTO uli_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yodwe rela holadoh lobos we ngo sa kangalur bo, “Ha mapel bo de weg dipmi ngal molfid.” ");
INSERT INTO uli_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Iwe yesa daer tangir le be dawal nngulyel paol semal le yebe hacchifiloh sefaes feas, sala hasubgudiy mo iyang sa mapel. ");
INSERT INTO uli_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Iwe ngo sa sor bo, “Temay, hare ye fel mo lal depom ngo hosa hachuya tohogol hafohoy le tangyey. Ngo te mele depey mele hobe dabey, bo mala depom mele hobe dabey.” ");
INSERT INTO uli_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Semal angelusel laeng sa llah ngali ngo sa hakkela depal. ");
INSERT INTO uli_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesa kkel tayikofel lal depal ngo sa hakkela tot irel mapel, ngo sa llas le sa wochog ccha le ye tturturdiy wototol. ");
INSERT INTO uli_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesa sudah mo lobos we ye memapel iyang sa tefael loh irer mokwe redabeyal sala wirir le resa rol masorloh luwul tayikofel lal deper. ");
INSERT INTO uli_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iwe sa kangalur bo, “Meda mele ha memasor iyang? Ha mmat bo habe mapel bo de weg dipmi ngal molfid.” ");
INSERT INTO uli_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ye chil kapatpat Jesus ngo sa budoh sew buwal yarmat le Judas we iy semal chowe seg mo rumal mele ye palirdoh. ");
INSERT INTO uli_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Iwe ngo Jesus sa sor bo, “Judas, fesong la yam mele ho bele fangloh mele Layur Retalop iyang?” ");
INSERT INTO uli_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yodwe mokwe redabeyel Jesus we re mel irel rela wiri molwe bele wel ngo resa kasiy bo, “Samol, ha bele teptap sayden kowe?” ");
INSERT INTO uli_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iwe ngo semal ir yesa hasi chog yesa ffela boy we lol Llulupal Temarong we sala supiloh rel talengal rewe gilemra. ");
INSERT INTO uli_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Iwe ngo Jesus sa sor bo, “Mayila mala!” Iwe yesa yangsi molwe talengel mal we sala moa le tayor mele ye foru. ");
INSERT INTO uli_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iwe ngo Jesus sa kangalur tamol temarong kowe mo tamol mokwe posol Templum we mo mal kowe yar we re budoh bo rebe ddorfi bo, “Ha sala budoh mo lomi sayden mo metal paomi bo habe ddorfiyey, le ha sor bo ngang semal cho machog? ");
INSERT INTO uli_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pangal ral ngo iy ma mel iremi lal Templum we, iwe ngo hami hate luluwaley le habe dorfiyey. Iwe ngo igla mele sa hola awa we hami habe dorfiyey iyang, irel yodle sa yor kkelel moniyan iyang.” ");
INSERT INTO uli_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iwe resa ddorfi Jesus resa hasiloh irel imw we imwel Llulupal Temarong we; iwe ngo Pedrus ye dedaber le ye dedar chog mo medaw. ");
INSERT INTO uli_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ye mel sew yaef le resa hagsu mo lochochol yororol molwe imwel Llulupal Temarong we, iwe Pedrus sa loh sala maroro irer rechokwe re tebalililoh yaef we. ");
INSERT INTO uli_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yodwe semal boy fefel kowe yela wiri yal maroro lengchel yaef we, ngo sa haffeda hamayu ngo sa sor bo, “Mal le ila wol iy semal mokwe redabeyel Jesus!” ");
INSERT INTO uli_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Iwe ngo Pedrus sa sor bo, “Fefel la, itugla le iy yeramtala ho sosor!” ");
INSERT INTO uli_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tey sulay mo wol miril ngo sa wol gil Pedrus ngal semal mal. Iwe ngo mal we sa kangal Pedrus bo, “Wol gel semal redabeyel Jesus!” Iwe ngo Pedrus sa sor bo, “Yeb, te ngang!” ");
INSERT INTO uli_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Medalbo be sew awa mo wol miril ngo wol semal mal sa wol sor bo, “Ye tugul mo lal depey le mal le ila semal mokwe redabeyel Jesus bo wol iy semal re Galilee.” ");
INSERT INTO uli_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Iwe ngo Pedrus sa sor bo, “Itugla fael mekla ho kakapta ho mal la.” Irel yodwe ye chil kapatpat ngo sa kkogo sew mael. ");
INSERT INTO uli_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Samol sa tagul tefael sala haffeda hamayi Pedrus. Iwe ngo sa mmang ngali Pedrus molwe Samol ye kangalu we ye sor bo, “Imol mala be kkogo mael bongey, ngo bele fael suluw yam sor bo ho toglayey.” ");
INSERT INTO uli_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedrus sa buyoy mo yulgul yoror we sala tetang mo iyang irel tayikofel lal depal. ");
INSERT INTO uli_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mal kowe re poposa Jesus resa tapeli fedaley kamemal ngo re lliy. ");
INSERT INTO uli_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Resa dugmi molwe metal ngal sew mengag ngo resa kasiya bo, “Itey le ye ppigrug? Hagla hare hobe gola!” ");
INSERT INTO uli_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ngo ye cholop hapatpat tayikof kala re kangalu. ");
INSERT INTO uli_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yela raelloh ngo resa rol Ttey fengal chol ttey we le, mal kowe yar mo tamol temarong kowe, mo mokwe sensel Hatobtob we. Iwe ngo resa hasidoh Jesus imor. ");
INSERT INTO uli_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Iwe ngo resa kasiya bo, “Kangalugmem, gel mele Kristus?” Iwe ngo iy sa sor bo, “Hare ibe kangalugmi ngo ha towe chepar ngalyey; ");
INSERT INTO uli_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","iwe ngo ibe kasiyahmi sew kasiy ngo towe yoh le habe hatefali. ");
INSERT INTO uli_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngo ligdi bo bele chap igla sa loh le mala Layur Retalop ila bele maroro rela gilemra irel Deus la ye hartal tagiyet.” ");
INSERT INTO uli_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Iwe ngo panger ngo resa sor bo, “Ila ngo, gel molwe Lol Deus?” Iwe ngo iy sa sor bo, “Hami mele ha sor bo ngang.” ");
INSERT INTO uli_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iwe ngo ir resa sor bo, “Tayor pelal le yarmat rebe budoh sor derel! Gich siya spegil rongrong mokwe ye sor.” ");
INSERT INTO uli_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Resa sudah panger chol ttey we resa hasiloh Jesus imol Pilatus ");
INSERT INTO uli_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","le ila lobos la rela sor mokwe resa forudah bo derel Jesus mo iyang: “Hasa ddorfi mal le ye kekangalur yarmat tot formel le ye tafel. Ye kangalur bo re towe ma fang paliyel raeg ngal mala Llulupal Roma ngo ye sor bo iy mele Kristus le iy semal king.” ");
INSERT INTO uli_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus yesa kasiya bo, “Gel mele yar Jews king?” Iwe ngo Jesus sa sor bo, “Gel mele ho sor.” ");
INSERT INTO uli_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Iwe ngo Pilatus sa kangalur tamol temarong kowe mo buwa we bo, “Tor mele iy wiri le derel mal le.” ");
INSERT INTO uli_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Iwe resa hakkela dah yalor le re sor bo, “Foloy ka yal mele yesa chapidoh fedeg lepder yarmat wol pangal meka fuluyel Judea. Ye chap yal foloy mo wol Galilee ngo igla iye yesa hola gich.” ");
INSERT INTO uli_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Yodwe Pilatus yela rongrong molwe ngo sa kasiy, “Ifa sengal mal le, iy semal yeramtal Galilee?” ");
INSERT INTO uli_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yodwe yela gola le Jesus ila iy semal yeramtal Galilee we Yerodes mele ye lamli ngo yesa fangloh Jesus irel Yerodes. Iwe ngo irel yodla ngo Yerodes ye wol mel wol Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ye momay depel Yerodes irel yodwe yela wiri Jesus bo yesa rongrong kaptal ngo sa sulay yal luluwaley loh chog le be wiri. Ye luluwaley le Jesus be foru tot kkemal bo yebe wiri. ");
INSERT INTO uli_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ye cholop kasiy kala Yerodes ye kasiya Jesus ngo tor mele Jesus ye hatefal ngali. ");
INSERT INTO uli_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tamol temarong mo mokwe sensel Hatobtob we resa gibwey mo imol pangal yarmat ngo resa hakkela yar hapatpat le re sosor mekla derel Jesus. ");
INSERT INTO uli_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yerodes mo saldaw kowe lol resa tapeli fedaley Jesus kamemal ngo re hafohoyu fedaley. Iwe resa hamengagu ngali sew mengag kowe ye lelay resa fang tefael loh iy irel Pilatus. ");
INSERT INTO uli_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Iye yodle Yerodes mo Pilatus rela maryarloh iyang bo metamol ngo re tayikof fengal. ");
INSERT INTO uli_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus yesa hateyilir yarmat mo tamol temarong kowe mo mal kowe ngo sa kangalur bo, ");
INSERT INTO uli_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Ha hasidoh mal le irey ngo ha sor le ye tafel mekla ye kekangalur yarmat. Iwe ngo igla iy sa haddogyu le hami ha mel ngo tor mele iy wiri le ye tayikof iyang mo irel pangal mokwe hami ha sor le ye foru. ");
INSERT INTO uli_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Iwe ngo wol ila sengal Yerodes bo wol tor mele ye wiri le derel, le ila fal le sa hatefalidoh irech iyang. Tor mele mal le ye foru le bela yor fal le sibe limeseloh iyang. ");
INSERT INTO uli_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ila ibele fang iy bo rebe wwodu ngo siya tahche.” ");
INSERT INTO uli_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Panger buwa we ngo resa tawulagililoh le re sor bo, “Ha limeseloh! Ngo hasa taldi Barabbas.” ");
INSERT INTO uli_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas ila ye kalbus bo fal yal wohehe fedal wulfuluy ngo ye wol limeseloh semal yarmat.) ");
INSERT INTO uli_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus ye dipli bo be taldi Jesus. Iwe yesa wol tefael ngali mokwe sa moll yal kapta ngalir buwa we. ");
INSERT INTO uli_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Iwe ngo ir resa tawulagili chog le re sor bo, “Ha krudu! Ha krudu!” ");
INSERT INTO uli_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yela hasluwel yael Pilatus kapatpat ngalir ngo yesa sor bo, “Meda sew formel le sa foru le ye tayikof? Tor mele ngang iwiri le ye tayikof le ye foru le sibe limeseloh iyang. Ibele fangloh iy bo rebe wwodu ngo resa tahche bo be loh.” ");
INSERT INTO uli_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Iwe ngo resa tawulagili le re hartaloh lepal yalor le re sor chog bo rebe krudu Jesus. Iwe ngo Pilatus yesa dabey molwe re sor. ");
INSERT INTO uli_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iwe Pilatus sa hataldagi bo rebe foru mokwe yarmat re dodongor. ");
INSERT INTO uli_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yesa taldi mal we yarmat re dipli we ye kalbus bo fael tayikof kowe ye foru. Iwe ngo sa fang Jesus bo re bela foru ngali mele re dipli. ");
INSERT INTO uli_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Iwe saldaw kowe resa paliloh Jesus. Yodwe re loloh ngo re sa chungu semal mal Cyrene le Simon idal le ye budoh mo irel fuluy kala tot le ye bubudoh wol haplom we. Resa ddorfi resa yetedah krud we uwol bo yebe hasi sa dabey Jesus. ");
INSERT INTO uli_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sew buwal yarmat re dabedoh miril Jesus. Ye mel tot fefel luwulur le re tetangdi Jesus le ye paleng yalol yar tang. ");
INSERT INTO uli_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus sa tagul sa kangalur bo, “Fefel Jerusalem kala! Ha towe rol tangdiyey. Habe far tangdugmi mo mekla lomi! ");
INSERT INTO uli_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bo yor yod kala bela hola le yarmat re bele sor bo, ‘Rebe yolbuw fefel kala tor layur ngo tor le re dimolwagili ngo rete ma hadud!’ ");
INSERT INTO uli_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ila yod kala yarmat re bele kangal tayit ka bo, ‘Pungdiy uwomem!’ Ngo re kangal tagitat ka bo, ‘Lebagulmem!’ ");
INSERT INTO uli_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hare iye lepal hagerger le re fang ngal sangal le tor derel, ila ngo be ifa lepal yal kkel tot hagerger la rebe fang ngal semal le yor derel.” ");
INSERT INTO uli_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ye wol mel rumal mael tayikof le re wol hasir bo re bela mes sew mo Jesus. ");
INSERT INTO uli_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Yodwe rela holadoh lobos we rema sor bo, “Liliyel Pol Fusug” ngo resa krudu Jesus mo mal we rumal, le semal mo rewe gilemra ngo semal mo rewe gilchegil irel Jesus. ");
INSERT INTO uli_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iwe ngo Jesus sa sor bo, “Temay, fahoy depom ngalir bo re togla mekla resa foforu.” Saldaw kowe resa hamhela mokwe mengagol Jesus uwor le re sulbeli hare mengag kefa mele semal mo semal ir yebe hasi. ");
INSERT INTO uli_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yarmat resa rol su lobos we le re kekamahoy mokwe metal yalor Jews yar tetapeli Jesus kamemal: “Ye yoh le ye hadorar sibis; ila ha ligdi bo yebe hadora iy lufulyal bo hare iy Kristus we Deus ye duwley!” ");
INSERT INTO uli_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Saldaw kowe re wol tapeli kamemal: Re budoh irel resa fang ngali wine kowe ye hartal ppal paliyel. ");
INSERT INTO uli_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Iwe resa kangalu bo, “Hare gel mele yar Jews king ngo hosa hadorah!” ");
INSERT INTO uli_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ye teftaf woal molwe krudul Jesus le ye sor bo: “Iye mele King we yar Jews.” ");
INSERT INTO uli_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Semal rechokwe re krud sew mo Jesus yesa hapatpat tayikof ngali le ye sor bo: “Te gel mele Kristus? Hadorah ngo ho hadorahmem!” ");
INSERT INTO uli_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Iwe semal sa kkaftoroy ngali le ye sor bo, “Ho te metagu Deus? Pangach ngo ye hafedeg chog yach hagerger. ");
INSERT INTO uli_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iwe ngo ligdi bo gich ila sulmesengal le be yor yach hagerger bo fael mokwe si foru we tayikof ngo iy ila tor tayikof le ye foru.” ");
INSERT INTO uli_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iwe sa kangalu Jesus bo, “Luwaleyey ho Jesus irel yodla ho bela mel bo King!” ");
INSERT INTO uli_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus sa kangalu bo, “Ibe hatugulu ngalug le igla mele hobe mel irey Paradise.” ");
INSERT INTO uli_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","La seg mo ruwow kolok ngo gul loh yaal ngo sa ruchopungloh luwul fuluy yee, la hola suluw kolok; ");
INSERT INTO uli_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","iwe ngo mengag we ye hopa lal Templum we sa sahag mo llupwal sala rumadep mo iyang. ");
INSERT INTO uli_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus sa ttawul loh le ye sor bo, “Temay, isa tehach kofay ngalug!” Ye sor molwe iwe ngo sa mes. ");
INSERT INTO uli_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yodwe tamol saldaw we yela wiri molwe iwe sengal ngo sa hapingpinga Deus le sa sor bo, “Katos bo yaramtale ila semal yarmat le ye momay!” ");
INSERT INTO uli_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Rechokwe re ttey lobos we rela wiri pangal mokwe ye weldoh ngo resa tefael loh lubugter le resa ttugtugu metal wuber irel yal tayikof lal deper. ");
INSERT INTO uli_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Panger rechokwe re gola Jesus mo fefel kowe re dabedoh mo wol Galilee ngo re su chog mo medaw resa kekamahoy mokwe. ");
INSERT INTO uli_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ye mel semal mal le Joseph idal le ye budoh mo wol Arimathea, le sew haplom mo wol Judea. Iy semal mal le ye momay ngo ye ssor le ye wiwidi chog mala Lamliyel Deus. Wol iy semal chol Ttey we, ngo yete dipli mokwe resa hatugulu we resa foru. ");
INSERT INTO uli_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yesa loh irel Pilatus sala dangro molwe porgol Jesus. ");
INSERT INTO uli_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Iwe ye sala hachuyadiy molwe porgol Jesus mo wol krud we yesa dugmi ngal sew mengag ye sala yetolong lal sew pey le re kilngilong mo wol pegil sew hohyal le tedyor mwo le ye teptap iyang. ");
INSERT INTO uli_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Irel yodla ngo Halimralel yengang, iwe ngo towol sulay ngo bele hola Sabbath. ");
INSERT INTO uli_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Fefel kowe re dabedoh Jesus mo Galilee ila re dabey Joseph re sala wiri pey we mo sangsengal yar haliliya molwe porgol Jesus. ");
INSERT INTO uli_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Iwe resa tefael ngal mokwe bugter re sala hafle hapgep mo loy kala rebe chalfi ngal molwe porgol Jesus. Yela Sabbath ngo resa hasoso bo ila sengal le Hatobtob we ye sor. ");
INSERT INTO uli_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lemaguyugul ralawe Sunday ngo fefel kowe resa loh irel pey we le resa hasi loy kowe resa faesul hafle. ");
INSERT INTO uli_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Re sala wiri feas we piltal pewe le sa chuy tang hatmal pewe. ");
INSERT INTO uli_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Rala bulong lal pewe ngo taymel molwe porgol Samol Jesus iyang. ");
INSERT INTO uli_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Re sala su lobos we le resa somawel fedal irel molwe. Te sulay ngo re sala suloh rumal mal lengcher le ye ddoldol mekla mengagur. ");
INSERT INTO uli_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yesa kkel yar fefel kowe motog ngo resa haborohdi wototol ngo mal kowe resa sor bo, “Meda mele hala memeri yeramtala luwulur chomes iyang, le yeramtala ila yesa molow? ");
INSERT INTO uli_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ye taymel iga bo sa molow tefael mo irel maes. Ha luluwaley molwe ye kangalugmi irel yodwe ye mel wol Galilee. ");
INSERT INTO uli_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mala Layur Retalop ila be yohlong lal payur choto hamolfid, ngo rebe krudu ngo bela solral mo wol miril ngo yesa molow tefael.’” ");
INSERT INTO uli_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iwe ngo sa moch mmang ngalir fefel kowe mokwe yalol Jesus ngalir. ");
INSERT INTO uli_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Yodwe rela tefaeldoh mo irel pewe ngo resa kangalur chowe seg mo semal mo panger ikowe sibis pangal mokwe. ");
INSERT INTO uli_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iwe ngo ir fefel kowe ila Mary Magdalena, mo Joanna, iwe mo Mary we sil James. Ir mo fefel kowe tot we re mel irer mele re kangalur apostel kowe kofal maka. ");
INSERT INTO uli_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Apostel kowe re kacchog bo tor pelal mokwe fefel kowe re sor ngo ir rete chepar ngalir. ");
INSERT INTO uli_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Iwe Pedrus sa sudah chog sa hamdaloh irel pewe. La bulong iyang sala wiri le sa mengag kowe chog mele ye mel iyang. Iwe sa tefael loh lubugtal le sa lluwdah irel molwe sa weldoh. ");
INSERT INTO uli_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ralawe chog ngo ye mel rumal mokwe redabeyel Jesus le re loloh irel sew haplom le rema sor bo Emmaus le medalbo be fusuw mile tang Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yodwe re dedarloh ngo re kekapta pangal mokwe yesa weldoh. ");
INSERT INTO uli_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Luwul yar kekapta mokwe ngo Jesus sa harpardoh iwe resa rol la dedar sew loh. ");
INSERT INTO uli_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Re wiri ngo ye tagel ngalir. ");
INSERT INTO uli_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus sa kasiyar, “Meda mekla ha dedarloh ngo ha kekapta fengali?” Re sala suloh mwo luwul yal tayikofel lal deper. ");
INSERT INTO uli_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Semal ir le rema sor bo Cleopas sa kasiya, “Gel chog mo woal Jerusalem mele ho togla mokwe ye weldoh lal molwe fedral we sa loh?” ");
INSERT INTO uli_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iwe ngo Jesus sa kasiyar bo, “Meda iy mekla?” Iwe ngo resa sor bo, “Mokwe ye wel ngal Jesusel Nazareth. Mal le ila semal profeta ngo ye ssor mo irel Deus mo pangal yarmat bo yor kkelal irel makla ye sor ngo ye foru. ");
INSERT INTO uli_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tamol temarong kowe mo mokwe metal yaloch re fangloh iy bo rebe limeseloh. Iwe re sala krudu. ");
INSERT INTO uli_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Iwe ngo hamem ha luluwaley le iy mele yebe taldir re Israel mo lal payur rechokla re kekafohoyur. Igla ila sa hasolralel yal weldoh pangal meka. ");
INSERT INTO uli_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ha lluwdah irel mala tot fefel le wochilamem rela loh irel pey le irel molwe chil lemaguyog, ngo taymel molwe porgol Jesus iyang. ");
INSERT INTO uli_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Rela tefaeldoh ngo re sor bo ye llah ngalir sibis angelus le re kangalur bo sa molow tefael Jesus mo irel maes. ");
INSERT INTO uli_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tot hamem re loh irel pewe ngo re sala wiri le tos mokwe fefel kowe re sor.” ");
INSERT INTO uli_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iwe Jesus sa kangalur bo, “Ila lepal yami rol buch le hala te ttiril chepar irel pangal mokwe profeta kowe re sor! ");
INSERT INTO uli_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ye faesul tugul le be hafohoy Kristus irel pangal meka ngo yesa moch loh luwul falmay la yal?” ");
INSERT INTO uli_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iwe ngo Jesus yesa hamdefa ngalir pangal mokwe kofal we ye mel lal pangal Babior we ye Santus le ye chapiy mo irel babior kowe yael Moses yee, la babior kowe yar profeta kowe. ");
INSERT INTO uli_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yodwe rela harpadoh haplom we rebe poloh mo iyang, ngo Jesus sala foraloh le medalbo chil ddaw loh lobosla iy yebe loh iyang. ");
INSERT INTO uli_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Iwe resa hapolaho ngo resa kangalu bo, “Ppaoy iremem bo sa harep le bele bong.” Iwe Jesus sa daberlong lal imwe bo be ppaoy irer. ");
INSERT INTO uli_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yesa marodiy bo yebe daber irel mongoy, sa kak flowa sa mepla, iwe ngo sa dipiy sa ngaler. ");
INSERT INTO uli_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iwe ngo sa sugegloh mokwe meter, ngo sa gel ngalir Jesus. Iwe ngo ye tamel loh. ");
INSERT INTO uli_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iwe resa kapta fengali chog uwor bo, “Te iwe si meyafi le ye wochog sew yaef le ye gus mo llefrach irel yodwe ye kkapatpat ngalgich ngo ye kekamdefa ngalgich kofal Babior we ye Santus irel yodwe si dedarloh lal yalap we?” ");
INSERT INTO uli_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iwe resa sudah chog resa tefael ngal Jerusalem. Ila lobosle rela wirir chowe seg mo semal we redabeyel Jesus mo iyang, le re rol ttey fengal chog mo ikowe sibis. ");
INSERT INTO uli_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iwe resa sor bo, “Tos le sa molow tefael Samol, bo yesa llah ngal Simon!” ");
INSERT INTO uli_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Iwe chowe rumal resa hamdefa ngalir mokwe ir ye wel ngalir mo lal yalap we mo igegel yal gel Samol ngalir irel yodwe ye dipiy flowa we iyang. ");
INSERT INTO uli_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yodwe chowe rumal re kekangalir mokwe ngo re tedap loh chog, ngo iy Samol sa suloh mo luwulur ngo sa kangalur bo, “Hopos be mel iremi.” ");
INSERT INTO uli_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sa budoh yar rol motog mo yar rusmes bo resa sor le resa wiri semal yalus. ");
INSERT INTO uli_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iwe yesa kangalur bo, “Meda mele hasa motog ngo ye yeyewal yami luluwal iyang? ");
INSERT INTO uli_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ha kalngali meka payi mo meka pechey bo habe wiri le ngang iy mele. Ha yangsiyey bo habe gola le ngang ila yor fodgoy ngo yor chiy. Iwe ngo yalus ila tor fodgol ngo tor chil.” ");
INSERT INTO uli_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ye sor mele ngo yesa kkewar ngalir mokwe paol mo mokwe pechel. ");
INSERT INTO uli_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iwe ngo ted tugul chog lal deper, ngo hal ila sa kel yar rraey ye te tugul feddal yar luluwal. Iwe ngo sa kasiyar bo, “Tor mele sibe mongoy?” ");
INSERT INTO uli_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Resa ngaley sedep yig le sa mad. ");
INSERT INTO uli_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesa hangi mo imor panger bo rebe wiri. ");
INSERT INTO uli_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iwe ngo yesa kangalur bo, “Ika mokwe ikangalugmi kofal irel yodwe ichil mel iremi. Pangal mokwe ye teftaf we kofay mo irel Hatobtob we yael Moses mo babior kowe tefayer profeta kowe mo ikowe ye teftaf lal babior kowe rema sor bo Psalm ngo yesa llah le ye katos.” ");
INSERT INTO uli_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iwe sa hatarma yar luluwal bo rebe medfagili yadol Babior we ye Santus. ");
INSERT INTO uli_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iwe ngo sa kangalur bo, “Iye mele ye teftaf lal Babior we ye Santus: Kristus ila ye tugul le be hafohoy irel bbareg ngo ye tugul le bela solral mo wol miril ngo yesa molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ngo harrigil ladep mo ffahoyel ladep irel molfid ila rebe foloyu fael mele Idey ngalir chol sew mo sew fuluy, le be chap mo wol Jerusalem. ");
INSERT INTO uli_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hami mele tugul irel pangal meka. ");
INSERT INTO uli_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iwe ngo spegil ngang mele ibe fangdiy uwomi kkemal la sa faesul tugul mo irel mala Temay. Ngo hami habe widi chog mo wol haplom le mala kkelmi la be bidiy uwomi mo wol laeng.” ");
INSERT INTO uli_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iwe yesa hasirwey mo wol haplom we resa loh yee, rela hola Bethany ngo yesa hasdaloh mokwe paol uwor sa mapelar. ");
INSERT INTO uli_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yodwe ye memapelar ngo yesa chap yal bibidah woal laeng. ");
INSERT INTO uli_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Resa hasrowu ngo resa tefael ngal Jerusalem le sa kkel yar rraey. ");
INSERT INTO uli_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Re sala mel chog lal Templum we le re kekangalu Deus yal hachigchig. ");
INSERT INTO uli_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Imol mala be sub faileng le ngo sa faesul mel Hapatpat la ye mel irel Deus, ngo iy ye hafedeg ngal chog Deus. ");
INSERT INTO uli_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Irel mala chapdagel dah chog ngo Hapatpat la ila ye faesul mel irel Deus. ");
INSERT INTO uli_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Deus ye hasubu pangal formel mo iyang; tor sew meka ye subdoh le iy ye tamel iyang. ");
INSERT INTO uli_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iy Hapatpat le mele chapil molow. Iwe ngo molow mele ye hasi ngalir yarmat teram. ");
INSERT INTO uli_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Teram ila ma werloh luwul rochupung. Iwe ngo luwul rochupung tema yoh le be hachuya teram. ");
INSERT INTO uli_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Deus ye fangdoh re hagloy la yal, le semal mal le Johannes idal. ");
INSERT INTO uli_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Johannes ye budoh be kangalur yarmat kofal teram le bo panger rechokla rebe rongrong hapatpat le ngo rebe chepar. ");
INSERT INTO uli_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Johannes ila te iy mele teram; iy ye budoh bo be kapta kofal iy teram la. ");
INSERT INTO uli_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iye teram we ye katos we ye budoh lal faileng le yebe werloh uwor panger yarmat. ");
INSERT INTO uli_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hapatpat la sa mel lal faileng le, ila Deus ye foru faileng mo iyang, ngo hapatpat la ila ye tagel ngalir re faileng. ");
INSERT INTO uli_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ye budoh wol mala faluyal ngo mekla yarmetal faluyal re tagul tangi. ");
INSERT INTO uli_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Iwe ngo rechokwe re dipli mala ye budoh irer ngo re chepar ngali, ila iy ye fang kkeler bo rebe mel bo lol Deus. ");
INSERT INTO uli_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Resa mel bo Lol Deus le te wochochog yar la mel bo lol yarmat le rela subdoh ngo yarmat mele temer; bo ir ila re faesul mel le Deus mele Temer. ");
INSERT INTO uli_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pedal Hapatpat le ila yesa mel bo yarmat le ye ssogol haradiya mo katos iwe sa budoh mel luwuluch. Siya wiri falmay la yal le mala Tamal ye fang ngali bo mil mala iy chog Lol. ");
INSERT INTO uli_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johannes ye kapta kofal we ye tawulaglii we ye sor bo, “Iye yeramtawe ikekapta kofal, we isor bo, ‘Yebe hamirdoh mo wol miriy ngo ye tagiyet mo imoy bo iy ila ye faesul mel mo imol yodwe ngang isubdoh iyang.’” ");
INSERT INTO uli_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yesa cholop yal holbuwagich pangachloh irel haradiya la yal le ye paleng. ");
INSERT INTO uli_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Deus ye fang Hatobtob we ngal Moses bo be yebe hadayu ngalgich. Iwe ngo haradiya mo katos ila Jesus Kristus mele ye fang ngalgich. ");
INSERT INTO uli_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ted yor mwo semal le ye wiri Deus. Mala chog Lol le ye hafedeg ngal Deus ngo ye mel irel mala Temal, mele ye haglal ngalir yarmat Deus. ");
INSERT INTO uli_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tamol kowe yar Jews woal Jerusalem re fangloh tot temarong mo tot Levites irel Johannes bo re bela kasiya hare iy itey. ");
INSERT INTO uli_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Johannes ye mechal hatefaeli kasiy we yar. Ye hamdefar luwul yarmat le ye sor bo: “Te ngang Kristus.” ");
INSERT INTO uli_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iwe resa kasiy, “Ila ngo gel itey? Gel Elijah?” Johannes sa sor bo, “Yeb, te ngang.” Resa kasiy le re sor bo, “Gel Profeta we?” Yesa hatefaeli ngo sa sor bo, “Yeb.” ");
INSERT INTO uli_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Iwe resa sor bo, “Ila ngo hosa kangalugmem hare gel itey. Towe mmal le be tor tefalel kasiy le yamem bo ha bela kangalur rechokla re fang doh hamem. Ha bela kangalur bo gel itey?” ");
INSERT INTO uli_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Johannes sa hatefaeli le ye kapta mokwe yalol profeta Isaiah we ye sor bo: “Ngang ‘yalol semal yarmat le ye tetawul mo lal lobosla ye tolmay loh: Ha hawwele yalap la be budoh Samol iyang!’” ");
INSERT INTO uli_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Re hagloy kowe yar Pharisees kowe resa kasiya Johannes bo, ");
INSERT INTO uli_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Hare te gel Kristus hare Elijah hare Profeta we, ila ngo meda fal le homa baptismus iyang?” ");
INSERT INTO uli_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johannes sa hatefaeli ngo sa sor bo, “Ngang ima baptismus irel chael. Ngo ye mel semal mo luwulumi le hami ha togla. ");
INSERT INTO uli_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ila yeramtala yebe budoh mo wol miriy, le bwela kala yal mwo ngo tor kofay le ibe besi.” ");
INSERT INTO uli_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Pangal meka ngo ye weldoh mo wol Bethany we ye mel meteralel mololul we Jordan, irel loboswe Johannes ye babaptismusgilir yarmat mo iyang. ");
INSERT INTO uli_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yela ralawe seral ngo Johannes sa wiri Jesus le ye bubudoh irel, ngo sa sor bo, “Ilay iy Agnus we Lol Deus we yema hachuya molfidir re faileng! ");
INSERT INTO uli_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iye yeramtawe ikekapta kofal we isor bo, ‘Semal mal ila yebe budoh mo wol miriy, le ye tagiyet mo imoy bo fal mala ye faesul mel mo imol yodwe ngang iy subdoh iyang.’ ");
INSERT INTO uli_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngang iy wol togla le iy. Ibudoh le ima baptismus irel chael bo mil mala iy yebe gil ngalir yeramtael Israel.” ");
INSERT INTO uli_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Iwe ngo Johannes sa wol sor bo, “Iwiri Espritu Santus le ye bidiy mo woal laeng le ye wochog semal dove ye sala yopdiy uwol. ");
INSERT INTO uli_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Irel yodla ngo ited gola chog bo iy molwe. Iwe ngo hala chog ila Deus we ye fangdoh ngang bo ibe baptismus irel chael mele ye kangaluyey bo, ‘Hobe wiri Espritu Santus le be bidiy mo wol laeng sala yopdiy uwol semal mal; ila yeramtala yebe baptismusgilir yarmat irel Espritu Santus.’” ");
INSERT INTO uli_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Johannes sa sor bo, “Isa wiri ngal metay, ngo ibe hatosiya ngalugmi le iy molwe Lol Deus.” ");
INSERT INTO uli_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yela ralawe seral ngo Johannes sa wol su loboswe le ir mo rumal mokwe redabeyal, ");
INSERT INTO uli_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ngo yesa wiri Jesus le ye dedarloh. Iwe ngo Johannes yesa sor bo, “Ilay iy Agnus we Lol Deus!” ");
INSERT INTO uli_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Rechokwe rumal we redabeyal re rongrong molwe ye sor iwe resa loh re sala dabey Jesus. ");
INSERT INTO uli_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus ye ttagul sala wirir we re dedabedoh miril ngo sa kasiyar bo, “Meda mele ha memeri?” Iwe ngo resa hatefaeli ngo resa sor bo, “Iya mele homa mel iyang ho, Rabbi?” (Fael pedal hapatpat le ila “Sensey.”) ");
INSERT INTO uli_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iwe ngo Jesus yesa sor bo, “Ha budoh ha bela wiri.” (Yodle ngo bele faw kolok leplaliyol.) Iwe resa dabeloh Jesus re sala wiri lobowe yema mel iyang. Resa budoh paoy irel ralawe. ");
INSERT INTO uli_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Semal ir ila Andrew we bisil Simon Pedrus. ");
INSERT INTO uli_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Irel yodwe ngo Andrew sala meri fedaley Simon we bisil re sala wer fengal. Yesa kangalu bo, “Hamem hasa wiri Messiah we.” (Fael pedal hapatpat le ila “Kristus.”) ");
INSERT INTO uli_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Iwe yesa fesanguloh Simon irel Jesus. Jesus ye kal ngali ngo sa sor bo, “Mala idem ila Simon le gel lol John, ngo re bele ffesang ngalug bo Cephas.” (Idle le ila ye hafedeg ngal idle Pedrus le fal ila “porow.”) ");
INSERT INTO uli_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ralawe seral ngo Jesus sa sor bo yebe loh Galilee. Yela wiri Philip ngo sa kangalu bo, “Budoh hobe dabeyey!” ");
INSERT INTO uli_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Philip ila semal yeramatal Bethsaida, haplom we Andrew mo Pedrus rema mel iyang.) ");
INSERT INTO uli_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip yela wiri Nathanael ngo sa kangalu bo, “Hamem hasa wiri yeramtawe Moses ye tefadiy kofal lal babiorol Hatobtob we. Iye yeramtawe profeta kwe re wol tefa kofal lal babior. Iy Jesus we lol Joseph we semal re Nazareth.” ");
INSERT INTO uli_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael ye kasiy le ye sor bo, “Ifa momay le be budoh mo wol Nazareth?” Iwe ngo Philip yesa sor bo, “Budoh ho bela wiri.” ");
INSERT INTO uli_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yodwe Jesus yela wiri Nathanael le ye bubudoh irel ngo sa kapta kofael Nathanael le ye sor bo, “Yeramtala ila iy semal halongol re Israel; tor mele ye tafel mo irel igegel yal memel!” ");
INSERT INTO uli_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael yesa kasiy le ye sor bo, “Ifa sengal chog ngo ho sala golayey?” Jesus sa sor bo, “Imol yodwe Philip yebe ffesangug, ngo iwurug le ho mel fael ire we fig idal.” ");
INSERT INTO uli_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael sa hatefaeli ngo sa sor bo, “Sensey, gel molwe Lol Deus! Gel mele King wol Israel!” ");
INSERT INTO uli_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus sa sor bo, “Hosa chepar le fael molwe ikangalug bo iwurug mo fael fig we? Iwe ngo yor mekla ho bele wiri le yebe weldoh le be kkel yal palleng mo imol mele!” ");
INSERT INTO uli_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iwe ngo sa kangalur bo, “Iy kangalugmi mala tosal: ha bele wiri laeng le be sugeg ngo ha wiri angelus kala lol Deus, le sibis re bibidah ngo sibis re bibidiy wol mala Layur Retalop.” ");
INSERT INTO uli_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yela rural mo wol miril ngo re sala foru sew gublul habulupoy woal Cana le sew haplomol Galilee. Molwe sil Jesus ye mel loboswe. ");
INSERT INTO uli_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iwe ngo re dengag Jesus mo mokwe redabeyal bo rebe budoh irel gubul we. ");
INSERT INTO uli_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yodwe la retloh wine kowe ngo molwe sil Jesus sa kangalu bo, “Sa retloh wine.” ");
INSERT INTO uli_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus sa hatefaeli ngo sa sor bo, “Ho towe kangaluyey mele ibe foru bo ye ted hola fael idoy.” ");
INSERT INTO uli_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Molwe sil Jesus yesa kangalur boy kowe bo, “Mele yebe kangalugmi ngo hasa foru.” ");
INSERT INTO uli_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yor yar Jews hatobtob le ye sor kofael yar be ma tela payur. Ila fal le yela mel wolow rume bo liliyel chael loboswe. Be sew rume kowe ngo be riyeg hare silig gallon yadol. ");
INSERT INTO uli_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus sa kangalur boy kowe bo, “Ha hayda rume ka ngal chael.” Iwe resa hayda rume kawe yee, la ssog. ");
INSERT INTO uli_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Iwe yesa kangalur bo, “Ha yid mo iyang hasa hasiloh irel mal la ye kekamahoy hammalel gubul le.” Iwe boy kowe resa yid chael we resa hasiloh irel mal we. ");
INSERT INTO uli_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Iwe ngo mal we yela songu chael we sa mel loh bo wine, ngo ye togla lobos le ye budoh wine we mo iyang, (ngo boy kowe re yidfi chael we re gola). Iwe yesa ffesangu mal we ye moch habulupoy ngo sa kangalu bo, ");
INSERT INTO uli_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Pangal yarmat ngo rema fang mwo wine we ye hartal momay, ngo bela lap ngalir yarmat ngo resa moch fang wine la te yugul momay hames. Iwe ngo gel ho far itol wine le ye hartal momay yee, la yodle ngo hosa moch fang!” ");
INSERT INTO uli_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus ye foru mele metamol kkemal mo woal Cana we ye mel wol Galilee. Ila lobola ye halleha falmay la yal mo iyang, ngo mokwe redabeyal resa chepar ngali. ");
INSERT INTO uli_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wol miril mele ngo Jesus mo mokwe bisil mo mokwe redabeyal mo molwe sil resa rol loh Capernaum re sala melegili fedral iyang. ");
INSERT INTO uli_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Irel yodle ngo sa harep le re bele foru molwe Bungul Paska, iwe Jesus yesa loh Jerusalem. ");
INSERT INTO uli_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yela loh Jesus ye sala wirir tot mal mo lal Templum we le re tetap chuway karbow mo saaf mo pigeons, ngo ye wol yor chol hadidilil salpiy le re maroro irel tis kala yar. ");
INSERT INTO uli_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iwe yesa hasi setab tael bo yal wowo, sa ddabsulurwey panger mael kowe mo lal Templum we, le fengal saaf mo karbow; yesa hacheppaloh tis kowe yar chol hadidilil salpiy kowe ngo ye hamdera fedaley faesol salpiy kowe layur. ");
INSERT INTO uli_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yesa kangalur rechokwe re tetap chuway pigeons bo, “Ha hachuyar mael kala mo iga! Ha towe tapeli imw le imwel mala Temay bo sew liliyel chuway!” ");
INSERT INTO uli_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesa mmang ngalir mokwe redabeyal le babior we ye santus ye sor bo, “Kkelel yai hachang mala imwom ho Deus ila ye wochog bechel yaef mo lal depey.” ");
INSERT INTO uli_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ir tamol Jews kowe resa wol kasiya sew kasiy, “Meda kkemal la be yoh le hobe foru le hobe hatosiya ngalugmem le yor kofom le hobe for mele?” ");
INSERT INTO uli_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus sa hatefaeli, “Habe hamderaloh Templum le ngo ibe hasu tefaeli lal mala solral.” ");
INSERT INTO uli_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Iwe ngo resa kasiya bo, “Hobe hasu tefaeli lal solral? Templum le ila fayeg mo wolow raeg yar fatleha ngo ye moch moll!” ");
INSERT INTO uli_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Templum la Jesus ye kekapta kofal ila mala halongol iy Jesus. ");
INSERT INTO uli_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yodwe yela molow tefael mo irel maes ngo ye mmang ngalir mokwe redabeyal hapatpat we ye sor. Iwe re sala chepar irel babior we ye santus mo mokwe Jesus ye sor. ");
INSERT INTO uli_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yodwe ye mel Jesus Jerusalem irel yodol molwe Bungul Paska, ngo ye cholop le ye chepar ngali irel molwe rela wiri kkemal kowe ye foru. ");
INSERT INTO uli_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Iwe ngo Jesus ye taluglug ngalir bo iy ye gola lal deper pangerloh. ");
INSERT INTO uli_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tor pelal le semal be kangalu Jesus kofal semal mo semal bo iy Jesus ye faesul gola mekla ye mel lal mekla deper. ");
INSERT INTO uli_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ye mel semal mokwe metal yalor Jews le Nicodemus idal le iy semal Pharisees. ");
INSERT INTO uli_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lubungul seral ngo Nicodemus yesa loh irel Jesus sala kangalu bo, “Rabbi, hamem ha gola le gel semal sensey le Deus ye fangdoh. Tor semal le be yoh ngali le be foru kkemal kala gel ho foforu. Semal le be rel mel Deus irel ngo sa moch mmal ngali le be foru.” ");
INSERT INTO uli_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus sa hatefaeli ngo sa sor bo, “Ibe kangalug mala tosal: tor semal le be yoh le be wiri mala Lamliyel Deus le be te sub tefael fael sew.” ");
INSERT INTO uli_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus yesa kasiya, “Be ifa sengal chog ngo semal cholelap sala wol sub tefael fael sew. Ye tugul le towe yoh le be wol tefael loang lal siyel mala sil bo bela wol sub tefael!” ");
INSERT INTO uli_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus yesa sor bo, “Ibe kangalug mala katosal; tor semal le be yoh le be hola mala Lamliyel Deus le be te sub tefael mo irel chael mo Espritu Santus. ");
INSERT INTO uli_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yarmat ila re sub mo irel yarmat iwe ngo mekla ngulur ila ye sub mo irel Espritu Santus. ");
INSERT INTO uli_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ho towe lluwdah irel mele ikangalug bo pangamiloh ngo habe sub tefael fael sew. ");
INSERT INTO uli_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yaeng ila yema loh lobole ye dipli be loh iyang. Hama rongrong ngungul yaeng ngo ha togla hare iya mele ye budoh mo iyang hare iya mele ye loloh iyang. Ila sengal igeger panger rechokla re sub tefael mo irel Espritu Santus.” ");
INSERT INTO uli_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus yesa kasiy bo, “Ila ngo be ifa sengal chog ngo sala mmal mala?” ");
INSERT INTO uli_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus sa hatefaeli ngo yesa sor bo, “Gel semal sensey kala ho tagiyet mo woal Israel ngo ho togla mele? ");
INSERT INTO uli_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mele ikangalug ila ye katos: hami hama kapta meka ha gola ngo hama sor kofal mekla ha wiri. Iwe ngo tor semal hami le ye chepar iyang. ");
INSERT INTO uli_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ha techepar ngalyey irel meka ikekangalugmi le kofal meka lal talop le, ila ngo be ifa sengal chog ngo ha sala chepar ngalyey irel mekla iy be kangalugmi le kofal mekla wol laeng? ");
INSERT INTO uli_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ted yor mwo semal le ye loh wol laeng bo halachog mala Layur Retalop we ye bidiy mo woal laeng.” ");
INSERT INTO uli_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Be wochog yael Moses changilidah labud parang we woal ire we mo lal tolmay loh we, ila be wol ila sengal chog mala rebe faor ngali mala Layur Retalop, ");
INSERT INTO uli_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bo panger rechokla re chepar irel ngo be yoh ngalir molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Fal mala Deus ye kkel yal hachangir re faileng mele ye fangloh mala Lol bo panger rechokla re chepar irel ngo re towe mes bo yebe far yoh ngalir molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Deus yete fangdoh mala Lol woal talop le bo yebe hatugulu kofer re talop; ye fangdoh bo yebe hadorar. ");
INSERT INTO uli_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Semal le yebe chepar ngal mala Lol Deus ngo Deus towe fang yal hagerger. Iwe ngo semal le yebe te chepar, ngo sa faesul tugul yal hagerger le fael mala yete chepar ngal mala Lol Deus. ");
INSERT INTO uli_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iye sengal igegel hattugul: yela budoh teram lal faileng ngo yarmat re hachang luwul ruchupung mo imol teram bo ye tayikof mekla wigdigir. ");
INSERT INTO uli_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Semal le yema foru wegdeg kala tayikof ngo ye towe dipli teram ngo towe mechal le yebe budoh luwul teram bo yede llahloh mekla wegdegel le ye tayikof. ");
INSERT INTO uli_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Iwe ngo semal le yema foru mekla ye katos ila yema budoh luwul teram bo be llahloh mo irel mekla wegdegel le iy ye talenga yalol Deus. ");
INSERT INTO uli_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yela wol miril mele ngo Jesus mo mokwe redabeyal resa loh wol mokwe faluyel Judea. Jesus sala mel tot irer ngo ye baptismusgilir yarmat. ");
INSERT INTO uli_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Johannes ye wol baptismusgilir yarmat mo woal Aenon we yete ddaw tang Salim bo ila lobosla ye cholop chael iyang. Yarmat re bubudoh irel ngo iy yesa baptismusgilir. ");
INSERT INTO uli_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Yodle ngo re ted yotolong Johannes lal kalbus.) ");
INSERT INTO uli_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tot mokwe redabeyel Johannes resa hachocho ngal wol semal Jews irel kofal yar ir Jews ma tela payur bo hachuchuyel taab. ");
INSERT INTO uli_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Iwe resa loh irel Johannes resa kangalu bo, “Sensey, ho chil memangi mal we ho kapta kofal we ye mel irem mo wol ngachel mololul we Jordan rewe Meteral? Igla ila yesa ma baptismusgilir yarmat ngo pangal yarmat resa loloh irel!” ");
INSERT INTO uli_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johannes sa hatefaeli ngo sa sor bo, “Tor mele be yoh ngal semal le hare Deus be te fang ngali. ");
INSERT INTO uli_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hami mele yai tugul le ngang isor bo, ‘Te ngang mele Kristus, ngo halachog iye Deus yesa hamowayey doh mo imol.’ ");
INSERT INTO uli_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mal la be habulupoy ila bele lamli fefel la ril. Molwe mararel mal we ila ye wedwed, ngo ye kkataleng ngo yebe rraiy le bela rongrong lliyalol mal we ye bele habulupoy. Iye sengal kkelel yai rraey igla. ");
INSERT INTO uli_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ye tugul le iy ye bele tagiyet ngo ngang ibele totol.” ");
INSERT INTO uli_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yeramtala ye bidiy mo woal laeng ila ye tagiyet mo imol pangal. Yarmetal talop ila re budoh mo wol talop. Iwe ngo rema kapta chog meka mil talop. Iwe ngo yeramtala ye bidiy mo wol laeng ila ye tagiyet mo imol pangal. ");
INSERT INTO uli_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ye sosor mekla ye wiri ngo ye rongrong iwe ngo tor le ye chepar ngali irel mekla ye kekapta. ");
INSERT INTO uli_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Te tugul semal le ye chepar irel mekla ye fofoloyu ngo yesa tugulwey mo lal depal le Deus ila ye katos. ");
INSERT INTO uli_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yeramtala Deus ye fangdoh ila ye fofoloyu mekla yalol Deus, bo fal mala Deus ye fang Espritu Santus ngali. ");
INSERT INTO uli_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mala Temal ye hachangi mala Lol sala fang pangal formel bo yebe lamli. ");
INSERT INTO uli_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Semal le ye chepar ngal mala Lol ngo be yoh ngali molow la tor siyal. Iwe ngo semal le yete talenga yalol mala Lol ngo towe yoh ngali molow ngo Deus yebe yitili chog luwul hagerger. ");
INSERT INTO uli_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pharisees kowe resa rongrong le ye chocholop loh chog le Jesus yesa baptismusgilir bo redabeyal mo imol Johannes. ");
INSERT INTO uli_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Mala tosal ila tor le Jesus ye baptismusgili; bo mokwe chog redabeyal mele rema baptismusgilir yarmat.) ");
INSERT INTO uli_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yodwe Jesus ye rongrong mokwe yarmat re sosor irel ngo yesa chuy mo Judea sa tefael ngal Galilee; ");
INSERT INTO uli_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","yebe loh Galilee ngo ye tugul le be loh luwul Samaria. ");
INSERT INTO uli_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ye sala budoh woal sew haplom woal Samaria le Sychar idal, le ye harep ngal sew bugat we Jacob ye ngaley Joseph we lol bo bugtal. ");
INSERT INTO uli_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ye mel sew yido yael Jacob loboswe. Jesus yela holadoh loboswe ngo sa peyagus, iwe yesa marodiy lengchel chael we. Yodla ngo sa wwel yaal. ");
INSERT INTO uli_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ye sala budoh semal fefel Samaria bo yebe yid chael, ngo Jesus sa kangalu bo, “Fang lemey chael.” ");
INSERT INTO uli_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Re taymel mokwe redabeyal bo resa loh luwul haplom we bo re bela chuway rol haler.) ");
INSERT INTO uli_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Fefel we sa hatefaeli le ye sor bo, “Gel semal Jews ngo ngang semal yarmetal Samaria. Ifa sengal mala ho sala dongor lomom chael ngalyey?” (Ir Jews mo yarmetal Samaria ila re tema yaya fengal cup mo tapiy.) ");
INSERT INTO uli_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus sa sor bo, “Hare ye wochog bo ho gola mele Deus ma fang, ngo ho gola le iy mele ye dodongor ngalug lemal chael, ngo gel hobe far dongor ngali bo yebe fang ngalug chael la ma fang molow.” ");
INSERT INTO uli_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Fefel we sa sor bo, “Tor yam pakkit melap ngo yido le ila ye yod. Iya lobosle ho bela hasi chael la ma fang molow mo iyang? ");
INSERT INTO uli_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jacob we chapdohmem mele ye fang ngalugmem yido le. Jacob mo tarmal kala lol mo mael kala lol, ngo panger ngo rema yul mo irel chael le. Gel ho te luluwaley le ho tagiyet mo imol Jacob, hare?” ");
INSERT INTO uli_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus sa sor bo, “Semal le be yul mo irel yido le ngo be chil betbat fael sew, ");
INSERT INTO uli_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","iwe ngo semal le be yul mo irel chael la iy be fang ngo towol betbat fael sew. Chael la ibe fang ngali ila ye towe ret le bele fefang ngali chog chael la yema fang molow ngo ye fang ngali molow la tor siyal.” ");
INSERT INTO uli_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Fefel we sa sor bo, “Fang lemey iy chael la melap! Ila ngo itowol betbat fael sew iwe ngo itowol ma budoh yid chael iga.” ");
INSERT INTO uli_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus sa kangalu bo, “Ho loh ho bela fesangu mal we rim ngo hasa budoh.” ");
INSERT INTO uli_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Fefel we sa sor bo, “Tor riy.” Iwe ngo Jesus yesa sor bo, “Ho bung irel mala ho sor bo tor rim. ");
INSERT INTO uli_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sa limmal mal le hosa rilir ngo yeramtala ho paoy lufulyal igla ila te spegil rim. Tos mala ho kangaluyey.” ");
INSERT INTO uli_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Fefel we sa sor bo, “Isa gola melap, le gel semal profeta. ");
INSERT INTO uli_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chapdoh kowe yai wol Samaria ila rema mepel ngal Deus mo wol tayit le, ngo hami Jews ha sor bo wol chog Jerusalem mele sibe ma mapel ngal Deus mo iyang.” ");
INSERT INTO uli_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus yesa kangalu fefel we bo, “Hobe chepar ngalyey le ye mel yodla bela hola ngo tayor le be chil mepel ngal Deus mo wol tayit le hare wol Jerusalem. ");
INSERT INTO uli_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hami yarmetal Samaria ila ha togla le iy mele ha memapel ngali, ngo hamem Jews ila ha gola le iy mele ha memapel ngali, bo yalap la sibe daor mo iyang ila ye budoh mo irer Jews. ");
INSERT INTO uli_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Iy yodla ila yesa hola gich igla. Irel mala kkelel Espritu Santus ngo yarmat rebe mepel ngal Deus le rebe foru mepel kala ye katos le iy ye dipli. ");
INSERT INTO uli_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Deus ila iy Espritu Santus, iwe ngo irel mala kkelel Espritu Santus mele be yoh le yarmat rebe mepel ngal Deus iyang.” ");
INSERT INTO uli_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Fefel we sa kangalu bo, “Igula le Kristus yebe budoh, ngo yodla bela budoh ngo iy yebe kangalugmem pangal formel.” ");
INSERT INTO uli_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus sa hatefaeli ngo sa sor bo, “Ngang iy mala le iye ikapatpat ngalug.” ");
INSERT INTO uli_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Irel yodla ngo sa tefaeldoh mokwe redabeyel Jesus, ngo re lluwdah irel molwe rela wiri le ye kapatpat ngal semal fefel. Iwe ngo tor semal ir le ye kasiya fefel we bo, “Meda mele ho dipli?” Hare ye kasiya Jesus bo, “Meda fal le ho kapatpat ngal fefel le iyang?” ");
INSERT INTO uli_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iwe ngo fefel we sa ligdi rumel chael we lemal sa tefael ngal haplom we sala kangalur yarmat bo, ");
INSERT INTO uli_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ha budoh ha bela kemahoy semal mal le ye kapta ngalyey pangal meka iy sa foru. Te far iy mele Kristus?” ");
INSERT INTO uli_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Iwe resa buyoy mo wol haplom we resa loh irel Jesus. ");
INSERT INTO uli_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Irel yodla ngo mokwe redabeyel Jesus resa kekafaelpechey bo yebe hangi mwo sugfed formel. ");
INSERT INTO uli_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Iwe ngo Jesus sa hatefaeli ngo sa sor bo, “Yor helay mongoy le hami ha togla kofal.” ");
INSERT INTO uli_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mokwe redabeyal resa kasiy fengal uwor le re sor bo, “Hare yor le yesa hamol kakdoh mwo mongoy irel?” ");
INSERT INTO uli_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus sa kangalur bo, “Mongoy la helay ila mala ibe talenga yalol yeramtala ye fangdoh ngang ngo ibe hamallo yengang la ye fang ngalyey bo ibe foru. ");
INSERT INTO uli_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ye mel sew hapatpat we hama to sor bo, ‘Sa fe faw meram ngo si bele gilsi uwal milay bo ye bele masow.’ Iwe ngo iy be kangalugmi, ha kemahoy hamayi milay kala bo yesa masow uwal ngo sa hola yodla sibe gilsi iyang! ");
INSERT INTO uli_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mal la ye gilsi uwal milay we ila yesa hasi paliyel yal yengang. Iwe ngo sa hateyli fengali mokwe uwal milay we bo fal ngal molow la tor siyal. Mal we ye fedagu milay we mo mal we ye gisil uwal milay we ila ir rorumal ngo bele momay deper. ");
INSERT INTO uli_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hapatpat we rema toa sor ila katos, ‘Semal mele ma fod milay ngo semal mele ma gilsi uwal.’ ");
INSERT INTO uli_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Isa hagloyugmi bo ha bela gilsi uwal sew milay le te hami mele ha yengtali. Sibis mele re yengtali ngo hami mele hasa mmal iyang.” ");
INSERT INTO uli_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ye cholop yarmetael Samaria woal haplom we le resa chepar ngal Jesus bo fael molwe fefel we ye sor bo, “Ye kangaluyey pangal mokwe iy sa forudoh yee, la hola igla.” ");
INSERT INTO uli_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Rela budoh yarmetal Samaria kowe irel, ngo resa hafaelpechey bo be mel irer. Iwe Jesus yesa melegili rural irer. ");
INSERT INTO uli_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ye wol cholop tot yarmat le resa chepar le fael mokwe ye fofoloyu, ");
INSERT INTO uli_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","resa kangalu fefel we bo, “Igla ila hasa chepar le te fael mokwe ho kangalugmem, bo fael mala hamem hasa spegil rongrong mekla ye kapta ngo hasa gola le ye katos bo iy mele Demerel faileng.” ");
INSERT INTO uli_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Rural le Jesus ye melegili loboswe, ngo sa chuy sa loh Galilee. ");
INSERT INTO uli_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bo iy ye sor bo, “Profeta ila re tema ssor mo wol faluyer.” ");
INSERT INTO uli_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yodwe yela hola doh Galilee ngo yarmat resa rraey ngali irel molwe sala budoh irer. Bo ir re loh Jerusalem irel molwe Bungul Paska re sala wiri pangal mokwe ye foforu. ");
INSERT INTO uli_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iwe Jesus sa tefael ngal Cana we ye mel woal Galilee, loboswe ye weged chael ngal wine mo iyang. Ye mel semal tamol Am loboswe le ye mel semal tarmal lol wol Capernaum le ye tomay. ");
INSERT INTO uli_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yodwe tamol we yela rongrong bo yesa chuy Jesus mo Judea sa loh Galilee, ngo yesa loh irel Jesus sala hafaelpechey bo be loh Capernaum bo bela hachuya yael molwe lol tomay bo sa harep le bele mes. ");
INSERT INTO uli_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus sa kangalu bo, “Tor fael sew le semal hami be chepar le hare be tor kkemal le yebe wiri.” ");
INSERT INTO uli_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iwe ngo yeramtawe sa sor bo, “Dabeyey melap, siya loh mo imol mala be mes mala layi.” ");
INSERT INTO uli_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus sa kangalu bo, “Ho loh; mala lom ila ye towe mes!” Mal we ye loh bo ye chepar ngal Jesus. ");
INSERT INTO uli_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yodwe mal we ye loloh irel molwe bugtal ngo re sala wer fengal mo boy kowe yal ngo resa kangalu bo, “Tarmal we lom ila yesa chuy yal tomay.” ");
INSERT INTO uli_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yesa kasiyar yodle ye chuy yal tomay molwe lol iyang. Ngo ir resa sor bo, “Lalow irel molwe sew klok llepelalyol.” ");
INSERT INTO uli_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Iwe ngo yesa mmang ngali mal we le ila awa we Jesus ye kangalu bo, “Mala lom ila ye towe mes.” Iwe iy mo chol haleng we yal ngo resa chepar. ");
INSERT INTO uli_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iye mele harwowel kkemal le Jesus ye foru mo wol miril yal budoh mo wol Judea sa loh wol Galilee. ");
INSERT INTO uli_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yela wol miril ngo Jesus yesa loh wol Jerusalem bo ye bela dabey sew mokwe bungur Jews. ");
INSERT INTO uli_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iwe ngo wol Jerusalem ila ye mel sew chael le yor imwal le lemow mala brandal le ye mel lengchel molwe Hatmal Saaf. Iwe ngo irel yalol Hebrew ngo rema sor bo Bethzatha idel iy chael la. ");
INSERT INTO uli_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ye cholop cho tomay le re yol fedal fael branda kowe, le rechoka re metafis mo rechoka ye mes pecher mo rechoka re mahatgut. ");
INSERT INTO uli_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ye mel semal mal loboswe le sa silig mo waluw raeg yal tomay. ");
INSERT INTO uli_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus ye wiri we ye yol loboswe, ngo ye gola le sa sulay yael mal we tomay; iwe yesa kasiya bo, “Ho dipli le be chuy yam tomay?” ");
INSERT INTO uli_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mal we ye tomay sa hatefaeli ngo sa sor bo, “Tor le ma hasiyeylong lal chael le melap irel yodla yema gupgupdah, iy be chil ye yeyedamgel bo iy be bulong, ngo sa hamolong semal mo imoy.” ");
INSERT INTO uli_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus yesa kangalu bo, “Sudah, hosa hasi chob la giyem hosa darloh.” ");
INSERT INTO uli_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yodwe chog ngo yesa chuy yael mal we tomay, yesa hasi chob we giyal sa chap yal darloh. Ralawe ila Sabbath. ");
INSERT INTO uli_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iwe tamol kowe yar Jews resa kangalu mal we yesa chuy yal tomay bo, “Igla ila Sabbath ngo ye tafel ngal yach Hatobtob le hobe hasi chob la giyem hosa dar fedal.” ");
INSERT INTO uli_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mal we yesa sor bo, “Mal we ye hachuya yai tomay ye kangaluyey bo iy be hasi chob le giyey isa loh.” ");
INSERT INTO uli_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Resa kasiya, “Itey iy mal la ye kangalug bo hobe faor mele?” ");
INSERT INTO uli_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Iwe ngo mal we sa chuy yal tomay ye togla le iy mele Jesus, bo ye cholop yarmat loboswe ngo mal we ye tay wiriloh Jesus. ");
INSERT INTO uli_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yela wol miril ngo Jesus sala wiri mal we mo lal Templum we ngo yesa kangalu bo, “Kaladoh, igla ila sa chuy yam tomay; ligdi molfid kala homa foru bo de wel ngalug sew formel le be kkel tot mo imol iwe.” ");
INSERT INTO uli_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iwe ngo mal we sa loh sala kangalur tamol kowe yar Jews bo Jesus molwe ye hachuya yal tomay. ");
INSERT INTO uli_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iwe sa chap yar foru mekla yebe weres Jesus iyang bo fael molwe ye hachuya yael mal we tomay rall Sabbath. ");
INSERT INTO uli_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus sa kangalur bo, “Mala Temay ila pangal yad ngo yema yengang loh chog, ila ngang ibe wol yengang.” ");
INSERT INTO uli_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hapatpat we Jesus ye sor mele sa kkel deper tamol kowe yar Jews bo rebe limeseloh iyang. Te mil chog molwe ye hetawsi molwe Hatobtobol Sabbath bo wol mil molwe ye sor bo Deus ila spegil Temal. Mele sa foru ila ye wochog molwe iy yesa hafedeg ngal Deus. ");
INSERT INTO uli_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iwe Jesus sa kangalur bo, “Ibe kangalugmi mala tosal: tor mele be yoh le mala Lol be foruloh chog llufulyal; yema foru chog mekla ye wiri le mala Temal yema foru. Mekla mala Temal yema foru ila ikla chog mekla mala Lol yema wol foru. ");
INSERT INTO uli_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mala Temal ye hachangi mala Lol le yesa kkewar ngali pangal mekla iy yema foru. Yebe kkewar ngali mekla ye palleng tot mo imol mele bo yebe foru, iwe ngo pangami ngo habe lluwdah iyang. ");
INSERT INTO uli_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mala Temal yema hamolowa tefalir chomes. Iwe ngo wol ila sengal mala Lol bo yema fang molow ngalir rechokla ye dipli be fang ngalir. ");
INSERT INTO uli_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tay mala Temal mele yema hatugulu kofer yarmat. Bo yesa fang kkelel mala Lol bo iy mele be ma hatugulu, ");
INSERT INTO uli_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","bo fael mala pangal yarmat ngo rebe hasrowu mala Lol le be wochog yar ma hasrowu mala Temal. Iwe ngo semal le be te hassaro mala Lol, ila ngo yete hassaro mala Temal le ye fangdiy iy. ");
INSERT INTO uli_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ibe kangalugmi mala tosal: te tugul semal le ye talenga meka yaloy ngo ye chepar ngal yeramtala ye fangdoh ngang ngo yebe yoh ngali molow la tor siyal. Iy ila sa tugul kofal bo yesa chuy mo irel maes sa loh luwul molow. ");
INSERT INTO uli_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iy be kangalugmi mala tosal: sa bubudoh yodla — sa hola yodla chomes rebe rongrong yalol mala Lol Deus, ngo rechokla re rongrong ila rebe molow tefael. ");
INSERT INTO uli_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mala Temal mele chapil molow. Iwe ngo sa wol foru mala Lol bo yebe mel bo chapil molow. ");
INSERT INTO uli_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yesa fang kkelel mala Lol bo yebe hatugulu kofer yarmat bo iy mala Lol ila iy molwe Layur Retalop. ");
INSERT INTO uli_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ha towe lluwdah irel mele: sa bubudoh yodla panger chomes ngo rebe rongrong yalol, ");
INSERT INTO uli_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","iwe ngo re bele buyoy mo lal mekla peyer: Rechokla re momay ila re bele molow tefael, ngo rechokla re tayikof ila re bele molow tefael ngo ye bele holar yar hagerger. ");
INSERT INTO uli_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Tor mele be yoh le ibe foru le ibe tapeli chog kkeley llufulyey. Yai ma hatugul ila ima dabey chog mala Deus ye kangaluyey. Mekla ima hatugulu ila ye bung, bo itema luluwaley bo ibe foru mekla ngang idipli. Ima foru chog mekla yeramtala ye fangdoh ngang ye dipli. ");
INSERT INTO uli_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Hare ngang chog woal halongoy yai hatosiya kofay ila ngo ha towe itol le ila mala katosol. ");
INSERT INTO uli_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bo ye mel semal le iy mele yema hatosiya kofay, iwe ngo ngang igula le mekla yema sor bo kofai ila ye katos. ");
INSERT INTO uli_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hasa hagloyurloh re hagloy kowe yami irel Johannes ngo ye katos mekla ye kapta. ");
INSERT INTO uli_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mele ila te mil mala hare be mel semal yarmat bo tugulul meka ikekapta. Ikekapta meka bo fael mala hami habe daor. ");
INSERT INTO uli_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johannes ila ye wochog sew habul le ye werloh iwe ngo hami ye momay dipmi irel molwe werel. ");
INSERT INTO uli_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngo ligdi bo ye mel mala tugulul kofay le ye palleng tang tugul la Johannes ye sor irey: mekla ima foru ila mekla ye momay le mala Temay ye kangaluyey bo ibe foru. Ika meka ye kapta kofay ngo ye kkawraloh le mala Temay mele ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mala Temay le ye fangdoh ngang mele ye wol kapta kofay. Hami ha ted rongrong mwo yalol hare ha wiri metal. ");
INSERT INTO uli_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ila fal le hate yetolong mala ye kapta lal yami luluwal bo ha te chepar ngal yeramtala iy yesa fangdoh. ");
INSERT INTO uli_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hama yawli Babior we ye Santus bo hami ha luluwaley le ila lobosla ha bela wiri kofal molow la tor siyal mo iyang. Ngo iy Babior we ye Santus ila ye kapta kofay! ");
INSERT INTO uli_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Iwe ngo hami ha temechal budoh irey bo be yoh ngalugmi molow. ");
INSERT INTO uli_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ite memeri mele yarmat rebe hapingpingayey iyang. ");
INSERT INTO uli_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngang igula igegmi ngo iwol gola le tor changel Deus mo lal yami luluwal. ");
INSERT INTO uli_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ibudoh iremi le ngang ihasi kkelel mala Temay ngo hami ha te dipliyey. Ngo hare semal bela budoh iremi le ye hasi chog kkelal llufulyal ngo hami habe dipli. ");
INSERT INTO uli_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ha dipli le yarmat rebe hapingpingahmi ngo ha te yedamgel bo be yoh ngalugmi hapingping la be budoh mo irel Deus. Ila ngo be ifa sengal chog ngo hasa chepar irey? ");
INSERT INTO uli_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ha towe luluwaley le ngang mele ibe yichingewahmi ngal mala Temay. Moses we ha yetedah dipmi uwol mele yebe yichingewahmi. ");
INSERT INTO uli_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Hare tosol le ha chepar ngal Moses, ila ngo habe chepar ngalyey, bo iy Moses ye tefadiy kaptay lal babior. ");
INSERT INTO uli_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hare ha te chepar irel mekla iy ye tefa, ila ngo be ifa sengal chog ngo hasa chepar irel meka ngang ikekapta?” ");
INSERT INTO uli_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","La wol miril mele, ngo Jesus sa loh rel Laom Galilee (we rema wol sor bo Tiberias) mo rewe sere. ");
INSERT INTO uli_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sew buwal yarmat resa dabey bo resa wiri kkemal kowe ye foru irel yal hachuya yar yarmat tomay. ");
INSERT INTO uli_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus ye bidah wol sew tagitat sala marodi iyang le ir mo mokwe redabeyal. ");
INSERT INTO uli_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yodle ngo yesa harep Bungul Paska we. ");
INSERT INTO uli_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus ye kalloh sala wiri buwal yarmat we resa budoh irel, iwe sa kasiya Philip, “Iya mele be yoh le sibe chuway mongoy mo iyang le be lap bo sibe hamngoyu ngalir panger chole iye leper?” ");
INSERT INTO uli_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ye sor molwe le ye kekagla Philip; Iy Jesus yesa faesul gola mele be foru.) ");
INSERT INTO uli_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip sa hatefaeli, “Hare panger chole iye leper le haramwo be semal ngo sugfed hal flowa ngo be ligdi rubuguy faesol salpiy kowe silver le sibe fang ngo resa moch taw iyang.” ");
INSERT INTO uli_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrew we bisil Simon Pedrus ngo iy semal mokwe redabeyel Jesus yesa sor bo, ");
INSERT INTO uli_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ye mel semal tarmal iga le ye mel limay flowa mo rumal yig le ye hasi, ngo towe lap haler chole iye leper iyang.” ");
INSERT INTO uli_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus sa kangalur bo, “Ha kangalur yarmat bo rebe marodi wototol.” (Ye cholop fadil loboswe.) Iwe ngo panger yarmat ngo resa marodi; ngo yebe limngeras mal loboswe. ");
INSERT INTO uli_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus yesa hasi flowa we sa kangal Deus yal hachigchig, ngo yesa yildi uwor rechokwe re maroro loboswe. Ila chog sengal mele ye wol foru ngal yig kowe. Iwe ngo panger ngo ye laploh haler iyang. ");
INSERT INTO uli_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yodwe rela rol maed ngo sa kangalur mokwe redabeyal bo, “Ha hateyili fengali mekla lutgul bo si towe hatolpa.” ");
INSERT INTO uli_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Rela hateyili fengali pangal mokwe lutgul flowa we limay ngo ye ssog seg mo ruwow bachebach iyang. ");
INSERT INTO uli_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Molwe rela wiri kkemal we Jesus yesa foru ngo rechokwe re mel loboswe resa sor bo, “Ye tugul bo iye Profeta we yebe budoh lal faileng le!” ");
INSERT INTO uli_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus ye gola le re bele budoh hakkela ngali bo be mel bo King; iwe yesa wol loh luwul tayit le iy loh chog. ");
INSERT INTO uli_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yela llefhafdoh ngo mokwe redabeyel Jesus resa bidiy irel laom we. ");
INSERT INTO uli_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Resa dage seyay boat resa tetefael ngal Capernaum we ye mel rel taed we mo rewe sere. Iwe ngo yela bongloh ngo ted budoh chog Jesus irer. ");
INSERT INTO uli_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Irel yodwe ngo yesa mmor yaeng ngo ye loalo. ");
INSERT INTO uli_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bele suluw hare faw mile ddawel yar fefadol loh mokwe redabeyel Jesus ngo resa wiri iy Jesus le ye dedardoh woal taed. Yela harpadoh boat we ngo resa rol motog. ");
INSERT INTO uli_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iwe ngo Jesus sa kangalur bo, “Ha towe motog bele ngang iy mele!” ");
INSERT INTO uli_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Iwe resa moch mechal rebe hasi Jesus yuchul boat we, iwe ngo te sulay ngo resa hola loboswe re loloh iyang. ");
INSERT INTO uli_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","La rallawe seral ngo buwa we re mel rel tad we sere re sala luluwaley loh le hal seyay boat le ye budoh loboswe. Iwe ngo re gola le Jesus yete daber mokwe redabeyal yuchul boat bo yodwe re loh ngo iy ye tamel irer. ");
INSERT INTO uli_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ye budoh tot boat mo Tiberias re sala ser mo lengchel loboswe buwa we re mongoy flowa mo iyang wol miril yael Samol mapela. ");
INSERT INTO uli_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yodwe buwa we rela gola le ye tamel Jesus mo mokwe redabeyal loboswe ngo resa dabey boat kowe resa loh Capernaum bo re bela meri. ");
INSERT INTO uli_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yodwe rela wiri Jesus mo rel taed we sere ngo resa kasiya, “Sensey, yinged mele ho budoh iga?” ");
INSERT INTO uli_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus sa kangalur bo, “Ibe kangalugmi mala tosal: ha memeriyey le fael molwe ha mongoy flowa kowe ngo ye lap halmi pangamiloh iyang, ngo te mil mala ha medaf irel kkemal ka yai. ");
INSERT INTO uli_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ha towe yengangel chog mongoy ka ma tayikof loh, ha yengangel mongol molow la tor siyal. Iye mongoy la mala Layur Retalop be fang ngalugmi. Mele ila fael mala Deus le Temal sa itol hagil la yal uwol bo mil mala ye fel depal ngali.” ");
INSERT INTO uli_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iwe resa kasiya le re sor bo, “Meda mele habe foru ngo sala mmal le habe foru mekla Deus ye dipli?” ");
INSERT INTO uli_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus sa hatefaeli ngo sa sor bo, “Mala Deus ye dipli le habe foru ila habe chepar irel yeramtala iy Deus ye fangdoh.” ");
INSERT INTO uli_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Resa hatefaeli le re sor bo, “Meda kkemal le hobe foru bo habe wiri bo habe chepar irem? Meda mele hobe foru? ");
INSERT INTO uli_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chapdoh kowe yamem re mongoy manna mo lal tolmay loh we le ye wochog molwe babior we ye santus ye sor bo, ‘Ye fang ngalir flowa le ye bidiy mo woal laeng bo rebe mongoy.’” ");
INSERT INTO uli_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus sa sor bo, “Ibe kangalugmi mala tosal. Flowa we Moses ye fang ngalugmi ila te bidiy mo woal laeng. Mala Temay mele ye fang flowa la ye bidiy mo woal laeng. ");
INSERT INTO uli_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Flowa la Deus ye fang ila yeramtawe ye bidiy mo woal laeng bo yebe fang molow ngalir re faileng.” ");
INSERT INTO uli_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Iwe ngo resa sor bo, “Ila ngo hosa fang ngalugmem iy flowa la pangal yodol, melap.” ");
INSERT INTO uli_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus yesa kangalur bo, “Ngang mele flowal molow. Semal le be budoh irey ngo towol kkoloh fael sew. Ngo semal le be chepar irey ngo towol betbat fael sew. ");
INSERT INTO uli_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ibe kangalugmi le hami hasa wiriyey igla iwe ngo ha towe chepar irey. ");
INSERT INTO uli_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Panger rechokla mala Temay ye fang ngalyey ngo rebe budoh irey. Iwe ngo semal le yebe budoh irey ngo tor fael sew le ibe ttahcheloh. ");
INSERT INTO uli_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Fael yai bidiy mo woal laeng ila ibe foru mekla yeramtala ye fangdiy ngang ye dipli. Ite bidiy ibe foru ikala ngang idipli. ");
INSERT INTO uli_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yeramtala ye fang doh ngang ye dipli le tor semal mo irer rechoka ye fang ngalyey le ibe ttahcheloh; ngo bela miril faileng ngo panger ngo ibe hamolowa tefalir mo irel maes. ");
INSERT INTO uli_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mala Temay ye dipli le panger rechokla rebe wiri mala Lol ngo re chepar irel ila be yoh ngalir molow la tor siyal. Iwe ngo bela miril faileng ngo ibe hamolowa tefalir mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yarmat resa lunglung irel le fael molwe ye sor bo, “Ngang mele flowa la ye bidiy mo wol laeng.” ");
INSERT INTO uli_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iwe resa sor bo, “Mal le ila Jesus we lol Joseph, hare te iy? Si gula molwe sil mo molwe temal. Meda mele la igla ngo yesa sor bo iy ye bidiy mo woal laeng iyang?” ");
INSERT INTO uli_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus sa hatefaeli ngo sa sor bo, “Ha ppoloh mo irel yami rol lunglung. ");
INSERT INTO uli_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tor semal le be yoh le be budoh irey le be te mala Temay we ye fangdoh ngang mele yebe hasidoh irey. Iwe ngo bela miril faileng ngo ibe hamolowa tefaeli mo irel maes. ");
INSERT INTO uli_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profeta kowe re tefadiy lal babior bo, ‘Panger yarmat ngo rebe kkay mo irel Deus.’ Ila panger rechokla re rongrong ngo re gola yalol mala Temay ngo rebe budoh irey. ");
INSERT INTO uli_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ite sor le hare yor semal le yesa wiri mala Temay. Yeramtala ye budoh mo irel Deus mele yesa wiri. ");
INSERT INTO uli_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ibe kangalugmi mala tosal: semal le ye chepar ila yesa yoh ngali molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngang mele flowal molow. ");
INSERT INTO uli_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chapdoh kowe yami re mongoy manna mo lal tolmay loh we, iwe ngo la wol miril loh ngo re mes. ");
INSERT INTO uli_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngo flowa la ye bidi mo wol laeng ila semal le be hangi ngo towol mes. ");
INSERT INTO uli_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngang iy flowa la ye bidiy mo wol laeng. Ngo semal le be hangi flowa la ngo yebe molow le tor siyal. Flowa la ibe fang ila mele halongoy le ifang bo re faileng rebe molow.” ");
INSERT INTO uli_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesa chap yar hapaliyel fengal luwulur le re sor bo, “Be ifa sengal ngo mal le sa fang ngalgich mala halongol bo sibe hangi?” ");
INSERT INTO uli_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus sa kangalur bo, “Iy be kangalugmi mala tosal: hare habe te hangi mele halongol mele Layur Retalop ngo ha yulmi mele cchal ngo towe yoh ngalugmi molow. ");
INSERT INTO uli_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Semal le yebe hangi mele halongoy ngo ye yulmi mele cchay, ngo be yoh ngali molow la tor siyal, ngo bela miril faileng ngo iy be hamolowa tefaeli mo irel maes. ");
INSERT INTO uli_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bo mele halongoy ila holngol mongoy ngo mele cchay ila holngol meka sima yul. ");
INSERT INTO uli_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Semal le be hangi mele halongoy ngo ye yulmi mele cchay ila ngo iy yebe mel irey ngo ngang ibe mel irel. ");
INSERT INTO uli_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mala Temay le iy mele chapil molow mele ye fangdoh ngang, ngo fael iy mele ngang imolow iyang. Be wol ila sengal chog semal le yebe hangi mele halongoy; yebe molow le yagilyey. ");
INSERT INTO uli_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iye iy flowa la ye bidiy mo woal laeng. Ye te wochog flowa kowe chapdoh kowe yami re mongoy ngo la wol miril ngo resa mes. Yeramtala yebe hangi flowa le ila be molow le tor siyal.” ");
INSERT INTO uli_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus ye kapta meka irel yodwe ye fofoloy lal imwel ttey we wol Capernaum. ");
INSERT INTO uli_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ye cholop rechokwe re dabey le re rongrong molwe ngo resa sor bo, “Foloy le ila ye kkel yal weres. Itey le be mechal talenga tappel foloy le?” ");
INSERT INTO uli_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Re te kangal Jesus ngo iy ye gola le re lunglung irel kofal molwe. Iwe yesa kasiyar bo, “Iye mele sa hapagu yami luluwal? ");
INSERT INTO uli_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Be ifa sengal yami luluwal le hare ha bela wiri mala Layur Retalop le be tefael ngal lobosla ye budoh mo iyang? ");
INSERT INTO uli_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espritu Santus la ye budoh mo irel Deus mele yema fang molow, ngo mekla kkelel yarmat ila tor kofal. Hapatpat ka iy kangalugmi ila be fang ngalugmi Espritu Santus le ma fang molow. ");
INSERT INTO uli_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Iwe ngo tot hami ha te chepar.” (Jesus ye faesul gula rechokla re towe chepar mo ikla rebe fangloh iy.) ");
INSERT INTO uli_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iwe ngo Jesus sa taboloh yal hapatpat le ye sor bo, “Iye fal le ikangalugmi bo tor semal le be yoh le be budoh irey le hare mala Temay yebe te foru bo be yoh.” ");
INSERT INTO uli_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesa cholop mokwe redabeyal le resa tagul tangi le re tay mechal dabey le fael mokwe ye sor. ");
INSERT INTO uli_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iwe yesa kasiyar choweseg mo rumal we redabeyal bo, “Iwe ngo hami, ha wol dipli bo habe ligdiyey?” ");
INSERT INTO uli_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Pedrus sa hatefaeli ngo sa sor bo, “Samol, itey le habe loh irel? Gel mele ho hasi hapatpat la yema fang molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ngo igla hasa gola ngo hasa chepar le gel Yeramtawe ye Santus we ye budoh mo irel Deus.” ");
INSERT INTO uli_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus sa sor bo, “Ngang mele iduwlehmi hami chole seg mo rumal, hare te ngang? Ngo halachog ila semal mo luwulmi ila iy moniyan!” ");
INSERT INTO uli_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesus ye kekapta kofal Judas we lol Simon Iscariot. Judas ila iy semal chowe seg mo rumal. Ila mwo ngo yebe fangloh Jesus. ");
INSERT INTO uli_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yela wol miril mele, ngo Jesus ye sala malekah woal Galilee; ngo yete dipli le be malekahloh woal Judea bo tamol kowe yar Jews resa luluwaley bo rebe limeseloh. ");
INSERT INTO uli_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yesa harep sew bong le rema sor bo Bungul Fetadol, ");
INSERT INTO uli_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","iwe mokwe wol bisil Jesus resa kangalu bo, “Ho le chuy mo iga hosa loh woal Judea bo mokwe redabeyem rebe wiri mekla ho foforu. ");
INSERT INTO uli_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tor semal le ma lebagili mekla yema foru le hare ye dipli bo pangal yarmat ngo rebe gola. Ila hare ho foforu meka ila ngo hosa halehaloh bo pangal yarmetael faileng le ngo rebe golah!” ");
INSERT INTO uli_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Mokwe mwo wol bisil ngo rete chepar ngali.) ");
INSERT INTO uli_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus sa kangalur bo, “Ted hola mala yodol. Hami ila pangal yad ngo ye fel chog mo iremi. ");
INSERT INTO uli_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Towe yoh le yarmetael faileng le rebe hafobdurugmi, iwe ngo ngang rebe hafobdiriyey bo fael mala ima kangalur loh chog mekla wegdegir le ye tayikof. ");
INSERT INTO uli_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ha roloh hami bo ha bela dabey bong la. Ngang iy towe loh bo ye ted hola mala yodol.” ");
INSERT INTO uli_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iye mele ye kangalur. Iwe ngo iy yesa mel chog woal Galilee. ");
INSERT INTO uli_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wol miril yar loh mokwe wol bisil irel gubul we, ngo Jesus yesa wol loh le ye mwol igegel yal loh bo degil ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tamol kowe yar Jews re memeri fedaley mo irel gubul we. Iwe resa kasiy fedal Jesus luwulur yarmat. ");
INSERT INTO uli_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ye cholop le re lunglung irel kofal mo luwulur buwa we le re sor bo, “Yeramtala ila semal yarmat le ye momay,” ngo ikla sibis re sor bo, “Yeb, yema kachaperar yarmat.” ");
INSERT INTO uli_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ngo tor le ye kapta kofal le ye hapalingi yalol bo re metagur tamol kowe yar Jews. ");
INSERT INTO uli_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yela locholchol long gubul we ngo Jesus sa loh irel Templum we sala chapiy yal foloy. ");
INSERT INTO uli_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tamol kowe yar Jews re lluwdah irel ngo resa sor bo, “Ifa sengal chog ngo sala iye lepal golayel mal le yete dabey skun?” ");
INSERT INTO uli_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus sa hatefaeli ngo sa sor bo, “Meka ifofoloyu ila te yai chog foloy lufulyey, bo ye budoh mo irel Deus le iy mele ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Te tugul semal le ye dipli le yebe foru mekla ye fel mo irel Deus ngo yebe gola hare ye budoh mo irel Deus meka ngang ifofoloyu hare yai ffaordah chog. ");
INSERT INTO uli_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Semal le yalol chog lufulyal mele yema kapta, ila ye luluwaley bo yarmat rebe hapingpinga. Ngo semal le ye luluwaley bo yarmat rebe hapingpinga yeramtala ye fangdoh iy, ila ye katos ngo tema kachapar. ");
INSERT INTO uli_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses mele ye fang ngalugmi Hatobtob we, hare te iy? Ngo tor semal hami le ye dabey iy Hatobtob we. Meda mele ha luluwaley le habe limeseyeyloh iyang?” ");
INSERT INTO uli_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Buwa we resa hatefaeli ngo resa sor bo, “Yesa mel semal moniyan uwom! Itey le yesa luluwaley le yebe limesehloh?” ");
INSERT INTO uli_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus sa hatefaeli ngo sa sor bo, “Iforu sew kkemal ngo pangami ngo ha lluwdah iyang. ");
INSERT INTO uli_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ye sor bo habe hagilar yalwich mal kala lomi, iwe ngo te Moses mele ye chapidoh bo chapdoh kowe yami mele re chapiy, iwe ngo hami hasa ma hagilar yalwich mal wol Sabbath. ");
INSERT INTO uli_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Hare hami hama hagilar yalwich mal wol Sabbath bo hade hatawsi Hatobtob we Moses ye fang, ila ngo meda fal le ha song ngalyey irel mele ihachuya yael semal mal tomay woal Sabbath? ");
INSERT INTO uli_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ha towe ma hatugulu chog kofal formel mo irel mekla hama wiri ngal metami, habe ma hatugulu le habe dabey mala tosal.” ");
INSERT INTO uli_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tot yarmetal Jerusalem re sor bo, “Te iye iy mal we tamol kowe re luluwaley bo rebe limeseloh? ");
INSERT INTO uli_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ha kalloh! Ye kaptapat luwul yarmat ngo tor mele re sor irel! Hare resa far luluwaley bo hare iy Kristus? ");
INSERT INTO uli_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngo ligdi bo yodla bela budoh Kristus ngo tor le yebe gola lobosle ye budoh mo iyang. Iwe ngo mal le ila pangach ngo si gula lobosle ye budoh mo iyang.” ");
INSERT INTO uli_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yodwe Jesus ye fofoloy lal Templum we ngo ye kapatpat le ye hapalingi yalol le ye sor bo, “Ha katos le ha golayey ngo ha gola lobosle ibudoh mo iyang? Te ngang chog lufulyey le iforu bo ibe budoh. Yeramtala ye fangdoh ngang ila ye katos. Hami ha tugla le iy. ");
INSERT INTO uli_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iwe ngo ngang iy gula bo iy budoh mo irel ngo iy mele ye fangdoh ngang.” ");
INSERT INTO uli_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iwe ngo resa luluwaley bo rebe ddorfi iwe ngo tor semal le ye yangedah uwol bo ted hola mala yodol. ");
INSERT INTO uli_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ye cholop mo luwulur buwa we le resa chepar irel iwe resa kasiy bo, “Yodla bela budoh Kristus, ngo be cholop kkemal le be foru mo imol ika le yesa foru?” ");
INSERT INTO uli_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisees kowe re rongrong mokwe buwa we re lulungu irel kofal Jesus. Iwe ir Pharisees kowe mo tamol temarong kowe resa hagloyurloh tot pos kowe bo re bela ddorfi Jesus. ");
INSERT INTO uli_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus yesa sor bo, “Towol sulay yai mel iremi ngo iy bele loh irel yeramtala ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Habe meri fedaleyey ngo ha towe wiryey, bo towe yoh le habe loh lobosla iy bela mel iyang.” ");
INSERT INTO uli_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tamol kowe yar Jews resa kasiy fengal luwulur le re sor bo, “Iya iy mala ye bele loh iyang le si towe wiri? Hare be loh irel mekla haplamol Greece we yor yarmetal faluyach iyang bo ye bela foloy? ");
INSERT INTO uli_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ye sor le sibe meri ngo si towe wiri, ngo towe yoh le sibe loh irel lobola bela mel iyang. Meda fael iy mele ye sor?” ");
INSERT INTO uli_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Molwe hartal ral mo irel bong we mele ye hartal palleng fal. Yela ralale ngo Jesus yesa sudah sa kapatpat le ye hapalingi yalol le ye sor bo, “Te tugul semal le sa batbat ngo sa budoh irey bo yebe hachuya yal batbat. ");
INSERT INTO uli_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Babior we ye santus ye sor bo, ‘Te tugul semal le ye chepar irey ngo chael la ma fang molow ila be budoh mo irel.’” ");
INSERT INTO uli_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus ye kekapta kofal Espritu Santus le sa harep le bele holar rechokla re chepar irel. Iwe ngo irel yodla ngo Espritu Santus ye ted yoh ngalir bo fael mala Jesus ye ted bulong luwul falmay la yal. ");
INSERT INTO uli_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tot yarmat mo luwulur buwa we re rongrong molwe ye sor, ngo ir resa sor bo, “Ye katos bo mal le ila iy semal profeta!” ");
INSERT INTO uli_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tot ir re sor bo, “Iy mele Kristus!” Ngo sibis re sor bo, “Kristus ila ye towe budoh mo woal Galilee! ");
INSERT INTO uli_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Babior we ye santus ye sor bo Kristus ila be semal chol daowe yael King David, le yebe subdoh mo Bethlehem. Ila haplom we ma mel David iyang.” ");
INSERT INTO uli_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iwe sala rure buwa we mo iyang le fael Jesus. ");
INSERT INTO uli_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tot re luluwaley le rebe ddorfi Jesus ngo ligdi bo tor le ye yangedah uwol. ");
INSERT INTO uli_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yodwe rela tefael pos kowe ngo tamol temarong kowe mo Pharisees kowe resa kasiyar, “Meda mele ha te hasidoh Jesus iyang?” ");
INSERT INTO uli_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pos kowe resa hatefaeli ngo resa sor bo, “Ted yor mwo semal le ha rongrong yal hapatpat le ye wochog momayel yal hapatpat!” ");
INSERT INTO uli_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pharisees kowe resa kasiyar bo, “Hami mwo ngo ha chepar irel?” ");
INSERT INTO uli_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Hasa rongrong mwo le sa yor semal tamol hare semal Pharisee le sa chepar ngali? ");
INSERT INTO uli_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Buwa le ila re togla Hatobtob we yael Moses, ila Deus ye bele foru bo rebe mes!” ");
INSERT INTO uli_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Semal iy Pharisee kowe loboswe ila Nicodemus. Iye iy mal we sa moal loh bo re bela werfengal mo Jesus. Iwe ngo Nicodemus yesa kangalur ikowe sibis bo, ");
INSERT INTO uli_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Hatobtob we yach ye sor le towe yoh le sibe hatugulu yael semal hagerger, mo imol mala sibe rongrong mekla iy yebe sor, ngo si gula mekla iy ye foru.” ");
INSERT INTO uli_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Resa hatefaeli ngo resa sor bo, “Wol gel semal yarmetal Galilee? Hola yawli hamayi Babior we ye Santus, bo hobe gola le tor semal profeta le be budoh mo woal Galilee.” ");
INSERT INTO uli_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pangal yarmat ngo resa loh lubugter, iwe ngo Jesus yesa loh woal molwe Tayitel Olives. ");
INSERT INTO uli_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lemaliyelel chog rallawe seral ngo yesa tefael ngal Templum we. Pangal yarmat ngo resa ttey ngali. Yesa marodiy ngo yesa chapiy yal foloy. ");
INSERT INTO uli_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mokwe sensel Hatobtob we mo Pharisees kowe resa hasidoh semal fefel le re ddorfir mo semal mal le te yal habulupoy. Iwe resa kangalu fefel we bo bela su mo imoar panger. ");
INSERT INTO uli_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Iwe resa kangalu Jesus bo, “Sensey, fefel le ila yarmat re wirir le re masor sew mo semal mal le te yal habulupoy. ");
INSERT INTO uli_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Molwe ye mel irel Hatobtob we yach iwe, Moses ye sor bo semal fefel le be iye sengal wegdegel, ngo rebe hacchifi bo be mes. Meda mele gel hobe sor iyang?” ");
INSERT INTO uli_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Re sor mele bo rebe mekada Jesus bo mil mala be yor mele rebe sor bo derel. Iwe ngo Jesus sa rohdiy wototol sa tteftaf luwul bol irel molwe haddol. ");
INSERT INTO uli_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Re chil su loboswe le re kekadogoyu Jesus ngo yesa tterdah sa kangalur bo, “Semal hami le tor molfidil ngo iy mele yebe metamol hacchifi fefel la.” ");
INSERT INTO uli_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iwe yesa wol rohdiy sa tteftaf luwul bol. ");
INSERT INTO uli_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yodwe re rongrong molwe ngo resa semal mo semal loh le mal kowe yar mele re metamol loh. Iwe sala mel diy Jesus. Iwe ngo fefel we ye chil su loh chog loboswe. ");
INSERT INTO uli_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesa tterdah sa kangalu fefel we bo, “Ifa ir rechokwe? Tayor semal le ye mel diy le yebe hatugulu yam hagerger?” ");
INSERT INTO uli_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Fefel we sa hatefaeli ngo sa sor bo, “Tayor, melap.” Jesus sa sor bo, “Wol ila sengay bo tor mele ibe hatugulu bo yam hagerger. Ho loh, ngo ho towol for molfid fael sew.” ");
INSERT INTO uli_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus yesa wol kapatpat ngalir Pharisees kowe le ye sor bo, “Ngang mele hawerel faileng. Te tugul semal le be dabeyey ngo be yoh ngali mala termal molow, ngo tayor fael sew le be darloh luwul rochupung.” ");
INSERT INTO uli_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisees kowe resa kangalu bo, “Igla ila sa gel chog yam kekapta kofom. Iwe ngo mekla ho sosor ila tor tugulul.” ");
INSERT INTO uli_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus sa hatefaeli ngo sa sor bo, “Yeb, ila mwo ikekapta kofay lufulyey ngo meka iy kekapta ila ye katos, bo ngang igula lobosle ibudoh mo iyang mo lobosle ibe loh iyang. Hami ha togla lobosle ibudoh mo iyang hare lobosle ibe loh iyang. ");
INSERT INTO uli_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hami hama hatugul le ye sangsengal chog yar yarmat ma hatugul; iwe ngo ngang ila tor semal le ibe hatugulu kofal. ");
INSERT INTO uli_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Iwe ngo hare ibela hatugulu kofal semal, ngo hatugul la yai ila yebe katos, bo te ngang chog lufulyey mele iforu; bo mala Temay le ye fangdoh ngang ila ye mel irey. ");
INSERT INTO uli_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ye teftaf lal babiorol Hatobtob we yami le rumal yarmat le be sew chog yalor irel sew formel, ila ngo mala resor ila ye katos. ");
INSERT INTO uli_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngang ikekapta kofay lufulyey, iwe ngo mala Temay le ye fangdoh ngang ila ye wol kekapta kofay.” ");
INSERT INTO uli_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Resa kasiya bo, “Ifa iy mala tamom?” Jesus sa hatefaeli ngo sa sor bo, “Hami ila ha toglayey, ngo ha wol togla mala Temay. Hare ha golayey ila ngo habe wol gola mala Temay.” ");
INSERT INTO uli_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus ye sor pangal mokwe irel yodwe ye fofoloy lal sengil we ye mel kahol kowe rema yitetlong maligach iyang mo lal Templum we. Ngo tor semal le ye dorfi bo ted hola mala yodol. ");
INSERT INTO uli_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus sa wol kangalur fael sew bo, “Ibele loh ngo hami ha bele memeri fedaleyey. Iwe ngo hami ila habe mes loh luwul mekla molfidmi. Towe yoh le habe loh irel lobosla ngang iy be loh iyang.” ");
INSERT INTO uli_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iwe ngo tamol kowe yar Jews resa sor, “Meda fal iy mele ye sor bo towe yoh le sibe loh lobola iy ye be loh iyang. Hare fael mele ila yebe iy chog yal limeseloh?” ");
INSERT INTO uli_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus sa hatefaeli ngo sa sor bo, “Hami mele yarmetael faileng le, iwe ngo ngang ila ibidiy mo woal laeng. Te ngang yarmetal faileng le bo hami mele yarmetal faileng le. ");
INSERT INTO uli_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ila fal le ikangalugmi bo habe mes loh luwul mekla molfidmi. Habe mesloh luwul mekla molfidmi hare ha te chepar le ‘Ngang Ila Ngang’.” ");
INSERT INTO uli_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iwe resa kasiya, “Gel itey?” Jesus sa hatefaeli ngo sa sor bo, “Ngang yeramtawe isa moal kangalugmi metamo. ");
INSERT INTO uli_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ye cholop mele be yoh le ibe sor ngo ihatugulu irel kofami. Yeramtala ye fangdoh ngang ila ye katos. Iwe ngo mekla chog ngang irongrong mo irel ngo mele ikapta ngalir yarmetal faileng le.” ");
INSERT INTO uli_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Re temedaf le Jesus ye kekapta ngalir kofal mala Temal. ");
INSERT INTO uli_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iwe Jesus yesa kangalur bo, “Yodla ha bela yetedah mala Layur Retalop woal krud, ngo ha bele moch gola le ‘Ngang Ila Ngang’; iwe ngo ha bele moch gola le tor mele ma yoh le ngang ibe foru le ibe tapeli chog kkeley lufulyey, bo mekla chog mala Temay ye kangaluyey ibe sor, mele ima kapta. ");
INSERT INTO uli_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iwe ngo yeramtala ye fangdoh ngang ila ye mel irey; iy yete tahcheyey loh bo fael mala pangal yad ngo ima foru mekla ye fel depal iyang.” ");
INSERT INTO uli_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ye cholop rechokla re rongrong mokwe Jesus ye sor le re chepar irel. ");
INSERT INTO uli_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iwe ngo Jesus sa kangalur rechokwe resa chepar irel bo, “Hare habe dabey foloy ka yai ila ngo ye tugul le hami redabeyey; ");
INSERT INTO uli_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","iwe ngo ha bele gola mala ye katos. Iwe ngo mala ye katos mele yebe hataldagugmi.” ");
INSERT INTO uli_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Iwe ngo ir resa sor bo, “Hamem chol daowe yael Abraham. Ila ngo meda mele le hola sor bo habe tal iyang le ted yor mwo fael sew le ha mel bo yael semal slave?” ");
INSERT INTO uli_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus sa kangalur bo, “Ibe kangalugmi mala tosal: panger rechokla re molfid ngo resa mel bo yael molfid slave. ");
INSERT INTO uli_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Iwe ngo slave ila te ir spegil yarmetael bugat we re yengang ngali. Iwe ngo tarmal kala layur chol bugat we ila ir spegil yarmetal bugat we. ");
INSERT INTO uli_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hare mala Lol Deus yebe taldugmi, ila ngo ye tugul le habe tal. ");
INSERT INTO uli_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngang igula bo hami chol daowe yael Abraham. Iwe ngo hami ha luluwaley le habe limeseyeyloh bo fael mala ha te dipli foloy ka yai. ");
INSERT INTO uli_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngang iy kekapta kofal mekla mala Temay ye kkewar ngalyey, iwe ngo hami hama foru ikla mala tami ye kangalugmi.” ");
INSERT INTO uli_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Resa hatefaeli ngo resa sor bo, “Abraham mele tamem.” Iwe ngo Jesus sa sor bo, “Hare katos bo hami lol Abraham, ngo habe wol foru mekla iy ye foru. ");
INSERT INTO uli_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mala chog ngang iy foru ila iy kangalugmi mala ye katos le iy rongrong mo irel Deus, iwe ngo hami hasa luluwaley le habe limeseyeyloh. Abraham yete foru tappel mele iye sengal! ");
INSERT INTO uli_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hami hama foru mekla molwe tami yema foru.” Resa hatefaeli ngo resa sor bo, “Deus chog mele tamem ngo hamem ila spegil lol.” ");
INSERT INTO uli_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus sa kangalur bo, “Hare katos bo Deus mele Tami, ila ngo hami habe hachangyey bo ngang ibudoh mo irel Deus. Iwe ngo la igla ngo iye isa mel iga. Ite budoh wol kaley chog lufulyey bo iy Deus mele ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Meda fal le ha te medaf irel meka ikekapta iyang? Ha te medaf bo ha te dipli le habe taelenga yaloy. ");
INSERT INTO uli_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Moniyan mele Tami ngo hami ha dipli chog habe dabey mekla iy ye dipli. Moniyan yema faesul lilimesloh yarmat ngo ted yor mwo fael sew le yesa dabey rele ye katos, bo tor fael sew le yema katos. Ye bela kachapar ila ngo yesa foru mala ye faesul yoru, bo fal mala ye toa kachapar ngo iy mele temal pangal metmetal kachapar. ");
INSERT INTO uli_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Iwe ngo ngang ikangalugmi mala ye katos, ila fal le ha te chepar ngalyey iyang. ");
INSERT INTO uli_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Itey semal hami le yebe hatosiya le ngang imolfid? Hare ye katos meka ikekapta, ila ngo meda mele le ha te chepar ngalyey iyang? ");
INSERT INTO uli_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Semal le ye budoh mo irel Deus ila yebe talenga mekla yalol Deus. Iwe ngo hami ila ha te budoh mo irel Deus, le ila fal le ha te talenga mekla yalol iyang!” ");
INSERT INTO uli_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Resa kasiya Jesus le re sor bo, “Ye tabung molwe hamem ha sor bo gel semal yarmetael Samaria le yor moniyan uwom?” ");
INSERT INTO uli_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus sa hatefaeli ngo sa sor bo, “Tor moniyan uwoy. Ngang ihasrowu mala Temay, ngo hami ha te hasrowuyey. ");
INSERT INTO uli_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ite luluwaley le yarmat rebe hasrowuyey. Ye mel semal le re ppilyey le iy mele ye memeri mele ibe ssor iyang. ");
INSERT INTO uli_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ibe kangalugmi mala tosal: semal le yebe talenga foloy ka yai ngo tor fael sew le yebe mes.” ");
INSERT INTO uli_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iwe resa kangalu bo, “Yesa moch tugul lal depmem igla le yor moniyan uwom! Abraham mo profeta kowe mwo ngo re mes. Iwe ngo gel ho sor bo, te tugul semal le be talenga foloy kala yam ngo tor fael sew le yebe mes. ");
INSERT INTO uli_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham we tamem ngo ye mes; ho towe sor le gel ho tagiyet imol Abraham, hare ho sor bo ho tagiyet? Profeta kowe mwo ngo re wol mes. Ho luluwaley le gel semal meda?” ");
INSERT INTO uli_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus sa hatefael ngo sa sor bo, “Hare be ngang chog yai hasaroyey, ila ngo mala ssaroy ila tor loh pelal. Deus le Temay mele yema fang ssaroy le iy molwe hami ha sor bo yami Deus. ");
INSERT INTO uli_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ted yor fael sew le hami ha gola mala Temay, ngo ngang ila iy gula. Hare ibe sor le ngang iy tugla le iy, ila ngo ibele kachapar le ibele wochog hami. Ngang igula mala Temay ngo iy ma talenga yalol. ");
INSERT INTO uli_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham we tami ye cchehas irel mala iy yebe wiri yodla ngang ibe budoh iyang. Iy ye wiri ngo ye momay depal iyang.” ");
INSERT INTO uli_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iwe resa kangalu bo, “Ye ted yoh mwo lemeg lepal ragem ngo ho sor bo ho wiri Abraham?” ");
INSERT INTO uli_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus sa hatefaeli le ye sor bo, “Ibe kangalugmi mala tosal: Yimol yal sub Abraham, ngo ‘Ngang ila Ngang’ le ifaesul mel.” ");
INSERT INTO uli_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iwe resa kak feas bo rebe hacchifi. Iwe ngo Jesus yesa mwol tangir ngo yesa chuy mo irel Templum we. ");
INSERT INTO uli_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ye dedarloh Jesus sala wiri semal mal le yela faesul subdoh chog ngo ye metafis. ");
INSERT INTO uli_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mokwe redabeyal resa kasiya bo, “Molfidil itey mele yela subdoh chog mal le ngo ye metafis iyang? Molfidil chog iy lufulyal hare molfidir mekla wulutugul?” ");
INSERT INTO uli_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus yesa hatefaeli ngo sa sor bo, “Metafis la yael mal la ila ye te budoh mo irel mekla molfidil hare molfidir mekla wulutugul. Ye metafis bo fael mala yebe llah mala kkemalel Deus le yebe yengang uwol. ");
INSERT INTO uli_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Irel yodle ye chil rael, ngo ye tugul le sibe foru yengang kala yael Deus le iy mele ye fangdoh ngang; yesa harep le bele bong iwe ngo tayor semal le be chil mmal le yebe yengang. ");
INSERT INTO uli_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yodle iy chil mel lal faileng le ngo ngang mele termal faileng.” ");
INSERT INTO uli_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wol miril yael Jesus sor molwe ngo yesa gutdiy wototol sa polo ngal bol sala mel bo mochor; yesa hasi sa haped ngal mokwe metal mal we. ");
INSERT INTO uli_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Iwe ngo yesa kangalu bo, “Ho loh ho bela yurmat lal Chael we Siloam.” (Fael yidle ila “Hagloyu.” Iwe mal we yesa loh sala yurmat iwe ngo yesa tefael le yesa wiri formel. ");
INSERT INTO uli_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Rechokwe ye harep fengal imwer mo mal we mo ikowe rema wiri yael mal we dodongor fedal chog hammalel resa kasiy bo, “Te iye mal we yema marro yesa dongorloh chog hammalel?” ");
INSERT INTO uli_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tot re sor bo, “Iye iy yeramtawe,” ngo sibis re sor bo, “Yeb, te iy, bo semal mele le ye hafedeg chog wululur mo yeramtawe.” Iwe ngo mal we yesa sor bo, “Ngang iy mele.” ");
INSERT INTO uli_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Iwe ngo resa kasiya bo, “Ifa sengal chog ngo ho sala wiri formel?” ");
INSERT INTO uli_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mal we yesa sor bo, “Mal we rema sor bo Jesus mele ye kak mochor yesa hapidi ngal meka metay, ngo yesa kangaluyey bo ibe loh Siloam ibela yurmat iyang. Iwe isa loh, ngo yodla chog iyurmat ngo sa yoh le iwiri formel.” ");
INSERT INTO uli_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iwe ngo resa kasiya bo, “Ifa iy?” Ngo mal we yesa sor bo, “Itugla.” ");
INSERT INTO uli_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Iwe resa hasiloh mal we yesa chuy yal metafis irer Pharisees kowe. ");
INSERT INTO uli_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Rallawe Jesus ye polo bol we sala mel bo mochor we ye hachuya ngal yael mal we metafis ila rall Sabbath. ");
INSERT INTO uli_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iwe ngo Pharisees kowe resa wol kasiya mal we mele ye foru ngo sala yoh le ye wiri formel. Yesa kangalur bo, “Ye hapidi ngal tot mochor meka metay; iy sala yurmat, iwe ngo igla iye iy sa wiri formel.” ");
INSERT INTO uli_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tot Pharisees kowe resa sor bo, “Yeramtala ye foru mele ila yete budoh mo irel Deus bo yete dabey molwe hatobtobol Sabbath.” Iwe ngo tot ir re sor bo, “Be ifa sengal chog ngo semal choto hamolfid ye sala foru tappel kkemal ka ika sengal?” Iwe resa hamehal re sala rure mo iyang. ");
INSERT INTO uli_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Iwe ngo Pharisees kowe resa kasiya mal we fael sew, “Gel mele ho sor bo iy ye hachuya yam metafis. Meda mele hobe sor irel?” Mal we yesa sor bo, “Iy semal profeta.” ");
INSERT INTO uli_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tamol kowe yar Jews rete dipli le rebe chepar le mal we ila ye metafis ngo la ngo la igla ngo yesa chuy yal metafis. Re sala fesangurdoh mokwe wulutugul mal we ");
INSERT INTO uli_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ngo resa kasiyar bo, “Lomi yeramtale? Hami ha sor le yela subdoh chog ngo ye metafis. Ila ngo ifa sengal chog ngo sala chuy yal metafis?” ");
INSERT INTO uli_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mokwe wulutugul resa hatefaeli ngo resa sor bo, “Hamem ha gola le lomem mele. Iwe ngo ha gola le yela faesul subdoh chog ngo ye metafis. ");
INSERT INTO uli_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Iwe ngo ha togla mele ye foru ngo sa chuy yal metafis, ngo ha wol togla le ye hachuya yal metafis. Ha kasiya bele yesa mal. Be yoh le yebe hatefaeli kasiy kala yami!” ");
INSERT INTO uli_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mokwe wulutugul mal we re sor molwe bo re metagur tamol kowe yar Jews. Bo ir tamol kowe yar Jews resa hatugulu le hare semal yebe sor bo ye chepar le Jesus mele Kristus, ila ngo tayor fael sew le yeramtala ye sor bo ye chepar yebe chil bulong lal imwel ttey kowe yar. ");
INSERT INTO uli_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ila fal le mokwe wulutugul re sor bo, “Yesa mal; ha kasiya!” ");
INSERT INTO uli_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Resa wol fesangu tefaelidoh mal we yela subdoh chog ngo ye metafis resa kangalu bo, “Hobe hatugulu mo fael metal Deus le hobe sor mala tosal. Ha gola le mal we ye hachuya yam metafis ila iy semal choto hamolfid.” ");
INSERT INTO uli_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mal we sa hatefaeli ngo sa sor bo, “Itugla hare iy semal choto hamolfid hare yeb. Mala chog ngang iy gula ila iy metafis, iwe ngo yela igla ngo iy sa wiri formel.” ");
INSERT INTO uli_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Resa kasiya le re sor bo, “Meda mele ye faor ngalug? Ifa sengal yal hachuya yam metafis?” ");
INSERT INTO uli_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mal we yesa sor bo, “Sa mol yai kangalugmi ngo hami ha te talenga. Meda mele ha dipli habe wol rongrong fael sew iyang? Medalbo hami mwo ngo hasa wol dipli bo habe mel bo redabeyal, hare te ila sengal?” ");
INSERT INTO uli_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Resa hapatpat tayikof ngali ngo resa sor bo, “Gel mele redabeyal bo hamem ila re dabeyel Moses. ");
INSERT INTO uli_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ha gola le Deus ye malili ngal Moses; ngo yeramtala ila lobosle mwo ye budoh mo iyang ngo ha togla!” ");
INSERT INTO uli_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mal we yesa hatefaeli ngo sa sor bo, “Ye wel igegel mala! Ha togla lobosle ye budoh mo iyang, iwe ngo ye hachuya yai metafis! ");
INSERT INTO uli_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Si gula le Deus ye tema taelenga yalor choto hamolfid; iwe ngo yema taelenga yalor rechoka rema hasrowu, ngo re foru mekla iy ye dipli bo rebe foru. ");
INSERT INTO uli_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Subdohol chog faileng le yee, la hola doh igla ngo ted yor mwo semal le si rongrong le ye hachuya yael semal metafis. ");
INSERT INTO uli_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hare ye te budoh mal le mo irel Deus ila ngo tor sew formel le be mmal ngali le yebe foru.” ");
INSERT INTO uli_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Resa hatefaeli ngo resa sor bo, “Gel ila ho subdoh ngo ho faholdah mo luwul molfid. Iwe ngo igla ngo hosa luluwaley le hobe foloyugmem?” Iwe resa ddabeloh mo irel imwel ttey we. ");
INSERT INTO uli_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yodwe Jesus yela rongrong molwe sa wel ngo ye sala meri mal we sa kasiya bo, “Ye tugul depom irel mala Layur Retalop?” ");
INSERT INTO uli_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mwal we yesa hatefaeli ngo sa sor bo, “Kangaluyey le iy melap, bo ibe chepar irel!” ");
INSERT INTO uli_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus yesa kangalu bo, “Hosa faesul wiri. Iy mele ye kapatpat ngalug igla.” ");
INSERT INTO uli_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mal we yesa sor bo, “Samol, isa chepar!” Iwe ngo yesa hasubgudiy imoal Jesus. ");
INSERT INTO uli_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus yesa sor bo, “Ngang ibudoh lal faileng le bo ibe hatugulu kofer yarmat; bo rechokla re metafis rebe wiri formel, ngo rechoka rema wiri formel rebe metafis.” ");
INSERT INTO uli_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tot Pharisees kowe re mel lobowe re rongrong molwe ye sor ngo resa kasiya bo, “Ye tugul le te hamem mala ho kekapta kofmem le ha wol metafis, hare?” ");
INSERT INTO uli_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus yesa hatefaeli ngo sa sor bo, “Hare ha metafis ila ngo hami ila tor mele habe molfid iyang. Iwe ngo mala hami ha sor bo ha te metafis ila, hami ila ha chil mel luwul molfid.” ");
INSERT INTO uli_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus yesa sor bo, “Ibe kangalugmi mala tosal: semal le ye te bulong mo lal hatmal chomolol saaf kowe bo ye la herahdah sala bulong mo solbos, ila iy semal chomachoh. ");
INSERT INTO uli_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yeramtala yema bulong mo lal hatmal chomolol saaf kowe ila iy mele re matmetal saaf kowe. ");
INSERT INTO uli_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yeramtala posol hatmal chomol we yebe sugu hatam we ngali. Iwe ngo saaf kowe lol rebe rongrong yalol le yebe ffesangu mekla ider ngo re bele budoh irel. Iwe ngo iy ye bele palirwey. ");
INSERT INTO uli_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yodwe yesa palirwey mo yulgul chomol we, ngo ye bele hamo mo imoar, ngo saaf kowe re bele dabey bo re gola lliyalol. ");
INSERT INTO uli_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Saaf kowe ila re towe dabey semal yarmat mo solbos bo re togla lliyalol. Rebe far ddar tangi.” ");
INSERT INTO uli_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus ye kangalur Pharisees kowe fiyong le ngo ir re temedaf iyang. ");
INSERT INTO uli_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iwe Jesus yesa wol sor bo, “Ibe kangalugmi mala katosal: Ngang mele hatam ngalir saaf kowe. ");
INSERT INTO uli_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Panger rechokla re hamodoh mo imoy ngo cho machoh mo cho tayikof iwe ngo saaf kowe rete taelenga yalor. ");
INSERT INTO uli_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngang mele hatam. Te tugul semal le yebe budoh irey ngo yebe daor; Semal le be bulong mo irel hatam le, ngo bela buyoy ngo yebe wiri yolbuw. ");
INSERT INTO uli_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Cho machoh ila rema budoh rebe peraf, ngo re hattewas ngo re lilimesloh saaf. Iwe ngo ngang ibudoh le fael mala be yoh ngalugmi molow. Ila molow la ye hartal momay. ");
INSERT INTO uli_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ngang mele re mametal saaf le imomay; ngo ye fel mo irey le ibe fangloh yai ngas bo yiglir. ");
INSERT INTO uli_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Semal le re fang chog paliyal bo yebe kemahor saaf kowe ila te faesul iy semal re matmetal saaf ngo tor spegil lol saaf. Iy ila yebe wiri chog semal wolve ngo yebe ddar yesa tahcherloh saaf kowe. Iwe ngo wolve we bele lliy fedaler saaf kowe ngo re bele medardar fedal. ");
INSERT INTO uli_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mal we re fang paliyal ila yebe ddar bo re fang chog paliyal be yengang, ngo iy ye te kadagirloh saaf kowe. ");
INSERT INTO uli_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngang mele re matmetal saaf le imomay. Mala Temay ye golayey ngo Ngang igula mala Temay. Wol ila sengal yai golar saaf ka layi ngo ir re golayey. Ye fel mo irey le ibe fangloh yai ngas bo yiglir. ");
INSERT INTO uli_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ye chil yor tot layi saaf le re ted mel luwulur ika lal chomol le. Ihatugulu le ibe hateyilirdoh; ngo ir rebe taelenga yaloy. Ila ngo re bele ttey fengal chog panger saaf kowe mo solbos sala hal semal chog re matmeter. ");
INSERT INTO uli_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Mala Temay ye hachangiyey le fael mala ye fel mo irey le ibe fangloh yai ngas bo mil mala be yoh le ibe wol molow tefael. ");
INSERT INTO uli_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tor semal le be hasi tangyey molow le yai. Ibe fangloh yai ngas le ila wey mo lal depey. Yor kkeley le ibe fangloh yai ngas, ngo wol yor kkeley le ibe molow tefael. Iye mele mala Temay ye hatobtob ngalyey ibe foru.” ");
INSERT INTO uli_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Resa wol harere yarmat le fael hapatpat kewe yael Jesus. ");
INSERT INTO uli_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ye cholop le re sor bo, “Yor moniyan uwol! Yesa buch! Meda mele hala taelenga mekla ye sosor iyang?” ");
INSERT INTO uli_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Iwe ngo sibis ir re sor bo, “Semal le be yor moniyan uwol ngo towe yoh le be iye sengal yal hapatpat! Be ifa sengal ngo ye sala yoh le semal moniyan yebe hachuya yar yarmat metafis?” ");
INSERT INTO uli_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","La yodle ngo Llifang ngo resa kukubulu molwe Bungul Templum we mo woal Jerusalem. ");
INSERT INTO uli_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus ye dedarloh fael sew branda mo irel Templum we, le rema sor bo, “Branda we yael Solomon.” ");
INSERT INTO uli_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iwe ngo yarmat resa tteydoh irel ngo resa kasiya bo, “Be ifa lepal sulayel yam hayewla fedaley chog depmem hare gel itey? Kangalugmem mala tosal: gel mele Kristus?” ");
INSERT INTO uli_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus sa hatefaeli ngo yesa sor bo, “Sa mol yai kangalugmi ngo hami ha te chepar ngalyey. Meka ima foru irel kkelel mala Temay ila yema halehaloh kofay; ");
INSERT INTO uli_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","iwe ngo hami ha towe chepar iyang bo te hami layi saaf. ");
INSERT INTO uli_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngang igular saaf kala layi. Iwe ngo ir rema dabeyey bo re gola lliyaloy. ");
INSERT INTO uli_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Isa fang ngalir molow la tor siyal. Tayor fael sew le rebe mes. Tor semal le yebe hasir tangyey. ");
INSERT INTO uli_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mala Temay le ye fang ngalyey meka ila ye tagiyet mo imol pangal formel. Iwe ngo tor semal le be yoh le yebe hasi meka tang mala Temay. ");
INSERT INTO uli_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngang mo mala Temay ila ha sew chog.” ");
INSERT INTO uli_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iwe ngo yarmat resa kak feas bo rebe hacchifi le fael mokwe ye sor. ");
INSERT INTO uli_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus yesa kangalur bo, “Ye cholop mekla ye momay le isa foru mo luwulumi le mala Temay mele ye kangaluyey ibe foru; ifa sew mo luwul mokwe isa foru le ha bele hacchifyey iyang?” ");
INSERT INTO uli_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Resa hatefaeli ngo resa sor bo, “Ha te luluwaley le habe hacchufug le fael mekla ye momay le hosa foru. Ha luluwaley le ha bele hacchufug le fael mala hosa hapatpat tayikof irel Deus. Gel chog semal yarmat ngo ho sala forgugloh bo gel Deus!” ");
INSERT INTO uli_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus sa hatefaeli ngo sa sor bo, “Ye teftaf lal babiorol Hatobtob we yami le Deus ye sor bo, ‘Hami deus.’ ");
INSERT INTO uli_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Si gula le mekla babior we ye santus ye sor ila ye katos le tor siyal. Iwe ngo Deus ye ffesang ngalir rechokla bo ir deus. Ikala rechokla iy Deus ye fang yalol ngalir. ");
INSERT INTO uli_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iwe ngo ngang ila mala Temay ye duwleyey sa fangdoh ngang lal faileng le. Ila ngo be ifa sengal chog ngo ha sala sor bo iy sa hapatpat tayikof irel Deus, irel mala iy sor bo ngang Lol Deus? ");
INSERT INTO uli_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Hare iy tema foru mekla mala Temay ye dipli bo iy be foru, ilang ila mwo ha te chepar ngalyey. ");
INSERT INTO uli_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngo hare iy ma foru meka, ila ngo heramwo ha te chepar irey, ngo hasa chepar irel meka iy ma foru, bo habe gola le mala Temay ila ye mel irey ngo ngang iy mel irel.” ");
INSERT INTO uli_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Resa wol ttey ngal Jesus bo rebe ddorfi ngo ye teyoh ngalir. ");
INSERT INTO uli_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iwe Jesus yesa wol tefael ngal loboswe Johannes yema baptismusgilir yarmat mo iyang, we ye mel rel Mololul we Jordan mo rewe sere. ");
INSERT INTO uli_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ye cholop yarmat le re budoh irel Jesus. Iwe ngo resa rol kapta fengali uwor le re sor bo, “Johannes ila tor kkemal le ye foru ngo mekla ye sor irel mal le ila pangal ngo ye katos.” ");
INSERT INTO uli_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iwe ngo ye cholop rechokwe re mel loboswe le resa chepar irel Jesus. ");
INSERT INTO uli_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ye mel semal mal le Lazarus idal le yema mel woal Bethany le ye tomay. Bethany ila sew haplom le yema mel Mary mo Martha we bisil iyang. ");
INSERT INTO uli_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Iye Mary we ye chalfi mokwe pechel Samol ngal loy we ngo yesa hapalpale ngal mokwe yael chemal. Iy mengal Lazarus we ye tomay.) ");
INSERT INTO uli_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mokwe mengal Lazarus resa fangloh hapatpat irel Jesus le re sor bo: “Samol, molwe maryarem we ho hachangi ila yesa tomay.” ");
INSERT INTO uli_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yodwe Jesus yela rongrong molwe ngo yesa sor bo, “Tomay le yael Lazarus ila te iye mele be mes iyang. Yesa weldoh mele bo mil mala yebe fang hapingping ngal Deus. Ngo ye wol fang hapingping ngal mala Lol Deus.” ");
INSERT INTO uli_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus ye hachangi Martha mo molwe bisil Martha mo Lazarus. ");
INSERT INTO uli_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yodwe Jesus yela rongrong bo yesa tomay Lazarus, ngo rural le ye mel chog loboswe ye mel iyang. ");
INSERT INTO uli_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iwe ngo yesa kangalur mokwe redabeyal bo, “Siya tefael ngal Judea.” ");
INSERT INTO uli_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Iwe ngo mokwe redabeyal resa sor bo, “Sensey, ted sulay yael yarmat luluwaley bo rebe hacchufug mo lobola, ngo hosa wol sor bo hobe tefael loh iyang?” ");
INSERT INTO uli_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus yesa sor bo, “Te ma seg mo ruwow awa yal rael? Te tugul semal le yebe darloh lerral ngo towe cheprag bo ye wiri mala hawrel faileng. ");
INSERT INTO uli_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Iwe ngo hare ye darloh llobong ngo yebe cheprag bo tor hatawerel.” ");
INSERT INTO uli_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesus ye sor molwe ngo yesa wol sor bo, “Lazarus we maryarech ila yesa masor. Iwe ngo iy bele loh bo iy bela fanglu.” ");
INSERT INTO uli_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mokwe redabeyal resa hatefaeli ngo resa sor bo, “Samol, hare yesa masor ila ngo bele chuy yal tomay.” ");
INSERT INTO uli_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Fael molwe Jesus ye sor bo yesa masor Lazarus, ila Jesus ye kekangalur le Lazarus ila yesa mes. Iwe ngo ir re kachog bo iy ye sor bo Lazarus ila ye masor. ");
INSERT INTO uli_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesus yesa moch hamdefa ngalir le ye sor bo, “Lazarus ila yesa mes. ");
INSERT INTO uli_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Iwe ngo yesa momay depey irel mala iy tamel irel ngo yesa mes le mil mala hami habe chepar. Hami siya roloh irel.” ");
INSERT INTO uli_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas (we rema ffesangu bo Libbey) sa kangalur mokwe chilal bo, “Pangach ngo sibe dabey Sensey le yach, ila ngo be yoh le sibe dabey irel maes!” ");
INSERT INTO uli_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yela hola doh loboswe ngo sa fabong yar leba loh Lazarus. ");
INSERT INTO uli_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany ila ye teyoh sew mile ddawal tang Jerusalem. ");
INSERT INTO uli_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ngo ye cholop yarmetal Judea le re budoh irel Martha mo Mary bo rebe mel ngalir tot irel yodwe yesa mes molwe menger. ");
INSERT INTO uli_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yodwe Martha yela rongrong bo yesa budoh Jesus, ngo yesa loh bo re bela werfengal. Iwe ngo Mary ye mel chog lal imw we. ");
INSERT INTO uli_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha yesa kangalu Jesus bo, “Hare ho mel ho Samol, ila ngo towe mes molwe mengay! ");
INSERT INTO uli_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngo ligdi bo ngang igula le igla mwo ngo te tugul mele hobe dongor ngal Deus ngo iy yebe fang ngalug.” ");
INSERT INTO uli_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus yesa kangalu bo, “Mala mengam ila yebe molow tefael mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha yesa hatefaeli ngo yesa sor bo, “Ngang igula le bela miril faileng ngo yebe molow tefael mo irel maes.” ");
INSERT INTO uli_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iwe ngo Jesus yesa kangalu bo, “Ngang mele molow mo molow tefael mo irel maes. Te tugul semal le ye chepar irey ngo ila mwo yesa mes, ngo yebe molow tefael mo irel maes; ");
INSERT INTO uli_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","iwe ngo semal le ye chil molow ngo ye chepar irey ila tor fael sew le yebe mes. Ho chepar irel mele?” ");
INSERT INTO uli_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha yesa hatefaeli ngo sa sor bo, “Ila sengal ho Samol. Ichepar le gel Kristus we Lol Deus, we hobe budoh lal faileng le.” ");
INSERT INTO uli_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wol miril yael Martha sor molwe ngo yesa tefael loh sala fesangu Mary we bisil sala ir loh chog. Yesa kangalu bo, “Yesa budoh Sensey we ngo ye kekasiy gel.” ");
INSERT INTO uli_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Yodwe Mary ye rongrong chog molwe ngo yesa sudah sa hamdaloh bo re bela werfengal mo Jesus. ");
INSERT INTO uli_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jesus ye ted bulong luwul haplom we bo ye chil mel chog loboswe re werfengal mo Martha mo iyang.) ");
INSERT INTO uli_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Rechokwe re mel irel Mary lal imw we resa dabewey irel yodwe re wiri le ye buyoy le ye nngat. Ir re kachog bo Mary ye bele loh irel pewe bo bela tang mo iyang. ");
INSERT INTO uli_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yodwe Mary yela hola doh loboswe ngo sa wiri Jesus. Yesa hasubgudiy mo imol Jesus ngo yesa sor bo, “Samol, hare ho mel ila ngo towe mes molwe mengay!” ");
INSERT INTO uli_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesus yesa wiri Mary we ye tetang ngo ye wirir rechokwe re dabedoh we re wol tetang ngo iy yesa tayikof lal depal. ");
INSERT INTO uli_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iwe ngo yesa kasiyar bo, “Iya mele ha leba iyang?” Iwe ngo ir resa sor bo, “Samol, budoh bo ho bela wiri.” ");
INSERT INTO uli_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iwe ngo Jesus yesa tang. ");
INSERT INTO uli_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yarmat resa sor bo, “Ha kemahoy lepal yal hachangi Lazarus!” ");
INSERT INTO uli_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Iwe ngo tot mo luwulur resa sor bo, “Te iy mele ye hachuya yael mal we metafis? Ila ngo medal bo towe wol yoh le yebe foru bo ye towe mes Lazarus?” ");
INSERT INTO uli_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesa wol ddidoh tayikofel depel Jesus, iwe sa loh irel pewe. Iwe ngo pewe ila ye kkil long mo wol pegil sew hohyal iwe ngo ye pelat ngal sedep porow. ");
INSERT INTO uli_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus yesa sor bo, “Ha hachuya porow la!” Martha we mengal mes we yesa sor bo, “Samol, ye bele tayikof bol. Yesa faral yal liblib!” ");
INSERT INTO uli_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus yesa kangalu bo, “Ited kangalug mwo le hare hobe chepar ngo hobe wiri falmay la yael Deus?” ");
INSERT INTO uli_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Iwe resa hachuya porow we. Jesus sa kaledah wol laeng ngo yesa sor bo, “Temay Deus, hosa hachigchig irel yam ma talenga yaloy. ");
INSERT INTO uli_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngang igula le pangal yad ngo homa talenga yaloy, ngo ikapta mele bo fael mala rechoka re ppaoy iga rebe chepar le gel mele ho fangdoh ngang.” ");
INSERT INTO uli_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wol miril yal sor molwe ngo yesa fofos le ye hapalingi yalol le ye sor bo, “Lazarus, buyoy!” ");
INSERT INTO uli_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yela buyoy Lazarus ngo ye dudug mokwe paol mo pechel irel mengag kowe rema dugmi ngal maes ngo ye wol dugdugloh molwe metal ngal sedep mengag. Jesus yesa kangalur bo, “Ha taldiloh mengag kala mo uwol bo yebe tal.” ");
INSERT INTO uli_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ye cholop rechokwe re budoh bo rebe tefael mo irel Mary le re wiri molwe Jesus ye foru. Iwe ngo resa chepar irel. ");
INSERT INTO uli_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Iwe ngo yor tot ir le re tefael loh re sala kangalur Pharisees kowe molwe Jesus ye foru. ");
INSERT INTO uli_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pharisees kowe mo tamol temarong kowe resa loh irel chol Ttey we yar resa kangalur bo, “Meda mele si bele foru? Ha kemahoy lepal kkemal kala mal le yesa foru! ");
INSERT INTO uli_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Hare sibe ligdi yeramtale le be iye sengal chog ila ngo pangal yarmat ngo re bele chepar irel. Iwe ngo bele tagul mala amel Roma sa hatawsi Templum le yach mo mele faluyach!” ");
INSERT INTO uli_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ye mel semal le Caiaphas idal le iy mele Llulupal Temarong irel raeg la. Iy Caiaphas ye sor bo, “Tor mele hami ha gola! ");
INSERT INTO uli_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ha te luluwaley le ye far momay le yebe mes semal yarmat bo yaglir yarmat cholop mo imol mala rebe lir loh chol sew fuluy?” ");
INSERT INTO uli_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yete kapta molwe le yal chog luluwal bo mil molwe iy mele Llulupal Temarong irel raeg la, iwe yesa kapta le Jesus ila yebe mes bo yiglir yarmetal Jews. ");
INSERT INTO uli_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mele ila te fal ngalir chog Jews, bo wol fal ngalir panger mekla lol Deus le resa rol medardar fedal lal faileng le bo rebe hofag fengal. ");
INSERT INTO uli_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ye chap chog ralla sa loh le tamol kowe yar Jews resa luluwaley mele rebe foru ngo yesa yoh le rebe limeseloh Jesus. ");
INSERT INTO uli_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iwe Jesus ye tay ma halehaloh yal malekah fedal wol Judea. Yesa chuy mo loboswe yesa loh lengchel solbos le ye tolmay loh irel sew haplom le Ephraim idal ye sala mel irer mokwe redabeyal. ");
INSERT INTO uli_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yodla ngo yesa harep molwe Bungul Paska, ngo ye cholop yarmat le resa bibidah Jerusalem le re bela hachuya tab mo uwor bo yigil mala rebe fel mo irel Deus. Mele ila faesul kkor le rema foru mo imol bong le. ");
INSERT INTO uli_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iwe resa memeri fedaley Jesus. Rela ttey fengal mo lal Templum we ngo resa rol kasiy fengal bo, “Meda yami luluwal? Ye tugul le towe budoh yeramtale irel bong le, hare yebe budoh?” ");
INSERT INTO uli_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tamol temarong kowe mo Pharisees kowe resa fang yalor le semal le yebe gola lobosle ye mel Jesus iyang ngo yesa budoh kangalur, bo hare be yoh le re bela ddorfi bo rebe hasi. ");
INSERT INTO uli_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wolral mo imol molwe Bungul Paska ngo Jesus sa loh woal Bethany irel imw we imwel Lazarus. Ila mal we Jesus ye hamolowa tefaeli mo irel maes. ");
INSERT INTO uli_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Resa foru sew mongol fehaf bo yal mo loboswe. Martha mele ye fofor haler ngo Lazarus ye mel irel Jesus mo rechokwe irel tis we. ");
INSERT INTO uli_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Iwe Mary yesa hasi sew molorol loy kowe ye ffaor mo irel nard we ye chow paliyal yesa hasredi wol mokwe pechel Jesus. Iwe yesa teptap mokwe yael chemal yesa hapalpale ngal mokwe pechel Jesus. Yesa suk bool loy we ye momay lal imw we. ");
INSERT INTO uli_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariot we semal mokwe redabeyel Jesus ngo iy molwe yebe fangloh Jesus yesa sor bo, ");
INSERT INTO uli_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Meda mele site tapeli chuway loyle le be sulbuguy dolla paliyal bo sibe ngaler mael hafohoy mala salpiyal bo layur iyang?” ");
INSERT INTO uli_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ye sor molwe le te fal mala iy ye luluwaler mael hafohoy, bo mil mala iy ila ye machoh. Iy mele yema halili layur salpiy iwe ngo yema peraf mo iyang. ");
INSERT INTO uli_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iwe ngo Jesus yesa sor bo, “Ha ligdi fefel la! Ha ligdi bo yebe haliliya bo holgul ralla rebe lebayey iyang. ");
INSERT INTO uli_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pangal yad ngo ma yor mael hafohoy iremi, ngo ngang ila te pangal yad ngo iy be mel iremi.” ");
INSERT INTO uli_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ye cholop yarmat le re rongrong bo ye mel Jesus wol Bethany. Iwe resa loh loboswe le te Jesus chog mele re loh irel, bo re wol loh bo re bela wiri Lazarus we Jesus ye hamolowa tefaeli mo irel maes. ");
INSERT INTO uli_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Iwe tamol temarong kowe resa luluwaley le rebe wol limeseloh Lazarus, ");
INSERT INTO uli_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","bo yesa cholop Jews le resa tagul tangir bo resa chepar irel Jesus le fael molwe Jesus ye faor ngal Lazarus. ");
INSERT INTO uli_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yela ralawe seral ngo buwa we re budoh irel molwe Bungul Paska, resa rongrong le Jesus yebe budoh woal Jerusalem. ");
INSERT INTO uli_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Iwe resa kak paddol resa buyoy bo re bela wiri Jesus. Re tetawul le re sor bo, “Habe hapingpingah ho Deus! Deus mele yebe holbuwa yeramtala ye budoh fael idel Samol! Deus yebe holbuwa King la yar re Israel!” ");
INSERT INTO uli_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus yesa dage semal donkey kowe ye chil wechich le ye wochog molwe babior we ye santus ye sor irel bo, ");
INSERT INTO uli_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ho towe motog gel haplomol Zion! King we yami iye yesa budoh le ye dage semal donkey kowe ye chil wechich.” ");
INSERT INTO uli_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Irel yodla ngo mokwe redabeyal re temedaf irel molwe. Ngo yodwe yela molow tefael Jesus mo irel maes, ngo yesa kkaweraloh falmay la yal wol laeng, ngo yesa moch mmang ngalir le babior we ye santus ye sor mele irel kofal. Iwe ngo wol ila sengal mala re faor ngali. ");
INSERT INTO uli_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Rechokwe re mel irel yodwe Jesus ye hamolowa tefaeli Lazarus mo irel maes ngo ye fesanguwey mo lal pewe, re kapta fedaley molwe Jesus ye foru. ");
INSERT INTO uli_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ila fal le ye budoh buwa we irel iyang bo re rongrong le iy Jesus mele ye foru kkemal we. ");
INSERT INTO uli_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ngo Pharisees kowe resa kapta fengali le re sor bo, “Hasa wiri, tayor mele be chil yoh le sibe foru! Hate kalloh habe kemahoy, pangal yarmat ngo resa dabey!” ");
INSERT INTO uli_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tot yarmetael Greece re mel luwulur rechokwe resa loh Jerusalem bo re bela dabey molwe Bungul Paska. ");
INSERT INTO uli_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Re loh irel Philip (le semal yarmetal Bethsaida le sew haplom le ye mel woal Galilee) re sala kangalu bo, “Ha dipli melap bo habe rol werfengal mo Jesus.” ");
INSERT INTO uli_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Yesa loh Philip ye sala kangalu Andrew molwe. Iwe resa chufengal re sala kangalu Jesus. ");
INSERT INTO uli_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus sa hatefaeli ngo sa sor bo, “Yesa hola yodwe Deus yebe fang falmay la ye palleng ngal mala Layur Retalop. ");
INSERT INTO uli_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iy be kangalugmi mala tosal: sefaes uwal wheat le hare yebe te pungdi luwul bool bo yebe mes, ngo yebe mel chog le ye hal sefeas loh chog. Iwe ngo hare yebe mes ila ngo yebe cholop uwal. ");
INSERT INTO uli_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Semal le yebe hachangi yal ngas ngo yebe pung tangi; ngo semal le yete hachangi yal ngas wol talop le, ngo yebe yoh ngali molow la tor siyal. ");
INSERT INTO uli_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Semal le ye dipli bo yebe mel bo yai boy bo yebe yengang ngalyey ngo yebe dabeyey. Ngo solbos la iy be mel iyang ngo boy la yai yebe mel irey. Iwe ngo mala Temay yebe fang ssor ngal semal le yebe mel bo yai boy. ");
INSERT INTO uli_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Igla ila yesa tayikof depey, ngo meda mele ngang iy be sor? Iy be sor bo, ‘Temay Deus, ho towe habulangoyey luwul hafohoy le’? Ila mele fael yai budoh. Ibudoh bo ibe bulong luwul awal hafohoy le. ");
INSERT INTO uli_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Temay Deus, fang ssor ngal mala idem!” Iwe ngo yesa malilidiy Deus mo wol laeng le ye sor bo, “Isa mol fang ssor ngal mele Idey ngo ibele wol fang fael sew.” ");
INSERT INTO uli_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Buwa we re su lobos we re rongrong molwe. Tot ir re sor bo ngungul parr. Iwe ngo ikowe sibis re sor bo, “Semal angelus le yesa malili ngali!” ");
INSERT INTO uli_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ngo Jesus yesa kangalur bo, “Molwe hasa rongrong ila te fal ngalyey bo fal ngalugmi. ");
INSERT INTO uli_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yesa hola yodwe Deus yebe hatugulu kofer yarmetal faileng le, ngo ye bele hachuyaloh yeramtala ye lamli faileng le. ");
INSERT INTO uli_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yodla ibe tagiyet tang talop le, iwe ngo pangal yarmat ngo rebe budoh irey.” ");
INSERT INTO uli_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Ye sor molwe bo yarmat rebe gola wululul hafohoy la yebe mes iyang.) ");
INSERT INTO uli_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Buwa we resa hatefaeli ngo resa sor bo, “Hatobtob we yach ye kangalugich le Kristus ila yebe molow le tor siyal. Ngo meda mele hola sor le mala Layur Retalop ila rebe hatagitadah lemayural iyang? Itey iy mala Layur Retalop?” ");
INSERT INTO uli_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus yesa hatefaeli ngo sa sor bo, “Teram le ila yebe chil sulay sugfed yal mel luwulumi. Ha tataboloh chog mekla ha foforu irel yodle ye chil mel teram le iremi bo hade bulong luwul rochupung. Bo yeramtala yema darloh luwul rochupung ila ye togla lobosle ye loloh iyang. ");
INSERT INTO uli_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ila ha chepar ngal teram la irel yodle ye chil mel iremi bo habe mel bo yarmetal luwul teram.” Wol miril yael Jesus kapta molwe ngo yesa loh sala mwol tangir. ");
INSERT INTO uli_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Molwe mwo resa wiri pangal kkemal kowe Jesus ye foru mo fael meter ngo ir re techepar irel. ");
INSERT INTO uli_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bo molwe profeta Isaiah ye sor irel ila yebe llah le ye katos: “Samol, itey le ye chepar irel mokwe hamem hasa kapta? Itey semal le Samol yesa haleha ngali lepal mala kkelal?” ");
INSERT INTO uli_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iwe sala teyoh la rebe chepar bo Isaiah ye wol sor bo, ");
INSERT INTO uli_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Deus yesa piltaloh mekla meter, mo luluwal kala yar, bo yede yoh le rebe wiri formel ngo ye medaf yar luluwal. Deus ye sor bo, ‘Iy sa foru mele bo yede yoh le rebe tagul ngalyey bo iy be hachuya yar tomay.’” ");
INSERT INTO uli_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah ye kapta mele bo ye wiri falmay la yael Jesus iwe yesa kapta kofal Jesus. ");
INSERT INTO uli_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ngo ligdi bo ye cholop mokwe metal yalor Jews le re chepar irel Jesus, ngo fael mala re metagur Pharisees kowe mele rete kapta fedaley iyang bo Pharisees kowe rede hachuyar loh mo lal imwel ttey kowe yar. ");
INSERT INTO uli_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ye kkel tot yar dipli le yarmat mele rebe hapingpingar mo imol mala Deus mele yebe hapingpinar. ");
INSERT INTO uli_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus ye kapatpat le ye hapalingi yalol le ye sor bo, “Semal le ye chepar irey ngo te ngang chog mele ye chepar irey, bo ye wol chepar irel yeramtala ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iwe ngo semal le ye wiryey ngo ye wol wiri yeramtala ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ibudoh lal failengle le ngang teram, bo panger rechokla re chepar irey ngo rebe chuy mo luwul rochupung. ");
INSERT INTO uli_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hare semal le ye rongrong meka ikapta ngo yete dabey, ngo ngang itowe hatugulu kofal. Ite budoh le ibe hatugulu kofer re faileng le, bo ibudoh bo ibe hadorar. ");
INSERT INTO uli_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ye mel semal le iy mele yebe hatugulu kofal semal le yete dipilyey, ngo yete dabey meka yaloy. Meka sa mol yai kapta ila, ika meka yebe hatugulu kofal semal mo semal irel yodla miril faileng! ");
INSERT INTO uli_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mele ila ye katos, bo ite kapta le yaloy chog lufulyey bo mala Temay le ye fangdoh ngang mele ye kangaluyey mele ibe kapta. ");
INSERT INTO uli_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ngo Ngang igula le mekla yema sor ila yema fang molow la tor siyal. Meka ikapta ila, ika meka mala Temay ye kangaluyey bo ibe kapta.” ");
INSERT INTO uli_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ralale ila safe seral ngo sa hola molwe Bungul Paska. Jesus ye gola le sa hola yodwe iy yebe chutang talop le bo yebe loh irel mala Temal. Pangal yad ngo iy Jesus ye hachangir meka lol lal faileng le, ngo hachangcheng la yal ngalir ila tor siyal yee, yela hola miril faileng. ");
INSERT INTO uli_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus mo mokwe redabeyal re momongol fehaf. Iwe ngo yesa mol yael Moniyan we hadepdepa Judas we lol Simon Iscariot bo yebe fangloh Jesus. ");
INSERT INTO uli_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus ye gola le mala Temal yesa fang ngali pangal formel bo yebe lamli. Ngo ye gola le iy ye budoh mo irel Deus ngo ye bele tefael loh irel Deus. ");
INSERT INTO uli_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesa sudah mo irel tis we ngo yesa hachuya molwe lugul mengagol. Iwe yesa hasi sew tawon sa langba ngal molwe lochochol. ");
INSERT INTO uli_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Iwe yesa haseserdiy chael lal sew tapiy ngo sa chap yal haduduy pecher mokwe redabeyal, sa hapalpale ngal tawon we ye ffor lochochoel. ");
INSERT INTO uli_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yela hola doh Simon Pedrus ngo Simon sa kangalu bo, “Samol, ho luluwaley le hobe haduduy meka pechey?” ");
INSERT INTO uli_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus sa hatefaeli ngo yesa sor bo, “Ho temedaf irel mele ifoforu igla ngo bela seral ngo ho bele moch medaf.” ");
INSERT INTO uli_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedrus yesa sor bo, “Tor fael sew le hobe haduduy meka pechey!” Jesus sa kangalu bo, “Hare ibe te haduduy mekla pechem, ila ngo gel ho towol mel bo re dabeyey.” ");
INSERT INTO uli_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Pedrus yesa hatefaeli ngo yesa sor bo, “Samol, ila ngo te meka chog pechey mele hobe haduduy! Hobe wol haduduy meka payi mo mele chemey!” ");
INSERT INTO uli_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus yesa sor bo, “Semal le sa mol mo irel dudu ila ye towol dudu, bo mekla chog pechel mele yebe haduduy. Pangami ngo sa tefoy mekla holongmi, sa halachog semal mo luwulumi mele te ila sengal.” ");
INSERT INTO uli_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yeramtawe yebe fangloh Jesus ila, iy Jesus ye gola, ila fal le ye sor bo, “Pangamiloh ngo sa tefoy mekla holongmi, ngo sa halachog semal mo luwulumi mele te ila sengal.”) ");
INSERT INTO uli_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wol miril yael Jesus haduduy mokwe pecher ngo sa hatefaladah molwe lugul mengagol sa tefael loh irel molwe liliyal mo irel tis we. Iwe ngo yesa kasiyar bo, “Ha medaf irel molwe ye moch mol yai foru ngalugmi? ");
INSERT INTO uli_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hama ffesangu ngalyey bo Sensey mo Samol, iwe ngo meka hama sor ila ye bung, bo ila mala ngang. ");
INSERT INTO uli_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngang le yami Samol mo Sensey mele sa moch mol yai haduduy mekla pechemi. Ila be semal hami ngo ye haduduy pechel semal. ");
INSERT INTO uli_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iy sa kewar ngalugmi mele iy sa foru le be ila sengal le hami habe ma foru. ");
INSERT INTO uli_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iy be kangalugmi mala katosal: tor semal boy le ye tagiyet mo imol yal masta, ngo tor semal re hagloy le ye tagiyet mo imol yeramtala yema hagloyu. ");
INSERT INTO uli_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Igla ila hami hasa gola mele le ye katos. Ila hare habe ma foru mele, ila ngo habe mel le ye momay dipmi! ");
INSERT INTO uli_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Te pangami ngo ikekapta kofmi, bo ngang igular rechokla isa duwler. Ngo yesa llah le ye katos yalol babior we ye santus we ye sor bo, ‘Yeramtala ye mongoy ngalyey, ila yesa tagul sa happaliyel ngalyey.’ ");
INSERT INTO uli_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ikangalugmi mele igla mo imol mala be weldoh, bo ye bela weldoh ngo habe chepar le ‘Ngang ila Ngang.’ ");
INSERT INTO uli_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ibe kangalugmi mala katosal: Semal le yebe hakkula ngal semal le ifangdoh, ila ngo ye hakkula ngalyey. Ngo semal le yebe hakkula ngalyey, ngo ye wol hakkula ngal yeramtala ye fangdoh ngang.” ");
INSERT INTO uli_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wol miril yael Jesus sor mele ngo sa kkeldoh tayikofel lal depal, ngo yesa hamdefa ngalir le ye sor bo, “Ibe kangalugmi mala tosol: Semal hami ila ye bele fangloh ngang.” ");
INSERT INTO uli_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mokwe redabeyal resa kal fengal uwor luwul yar temedaf hare itey molwe Jesus ye kekapta kofal. ");
INSERT INTO uli_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Semal ir mokwe redabeyal ila ye marro lengchel. Ila iy yeramtawe iy Jesus ye hachangi. ");
INSERT INTO uli_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Pedrus sa pongpong ngali ngo yesa kangalu bo, “Kasiya hare itey iy mala ye kekapta kofal.” ");
INSERT INTO uli_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iwe yeramtawe yesa ger ngal Jesus ngo sa kasiya bo, “Itey ho Samol?” ");
INSERT INTO uli_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus sa hatefaeli ngo sa sor bo, “Yeramtala ibe ngaley sedep flowa le ibe chiri lal tohoh le.” Iwe yesa hasi sedep flowa sa chiri, yesa ngaley Judas we lol Simon Iscariot. ");
INSERT INTO uli_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yodwe chog Judas ye hasi flowa we ngo sa mel Satan uwol. Jesus yesa kangalu bo, “Haturug! Hola foru mele hobe foru!” ");
INSERT INTO uli_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tor semal mo irel tis we le ye gola hare meda fal le Jesus ye kangalu molwe iyang. ");
INSERT INTO uli_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ngo fael molwe Judas mele ye holu layur salpiy mele tot mokwe re dabeyel Jesus re kachog bo Jesus ye kangalu bo be loh ye bela chuway hamalel gubul we, hare bela fang formel ngalir mael hafohoy. ");
INSERT INTO uli_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas ye hasi chog madpil flowa we ngo sa buyoy ligtam. Irel yodla ngo yesa bong. ");
INSERT INTO uli_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yodwe sa loh Judas ngo Jesus sa sor bo, “Igla ila yesa llah ssor la yael molwe Layur Retalop, iwe ngo ssor la yael Deus ila yesa llah mo irel. ");
INSERT INTO uli_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iwe ngo hare yesa llah ssor la yael Deus mo irel mala Layur Retalop, ila ngo be igla chog ngo Deus yesa haleha ssor la yael mala Layur Retalop. ");
INSERT INTO uli_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hami re wol layi ila towol sulay ngo ibele lugdugmi. Hami ila habe meriyey, ngo ibe kangalugmi igla molwe ikangalur tamol kowe yar Jews we ikangalur we isor bo, ‘Towe yoh le habe loh irel lobola ngang ibe loh iyang.’ ");
INSERT INTO uli_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Igla ila ibele fang ngalugmi sew hatobtob le ye tefoy: Ha hachangi fengalugmi. Habe hachangi fengalugmi le be wochog yai hachangugmi. ");
INSERT INTO uli_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Habe hachangi fengalugmi ila ngo pangal yarmat ngo rebe gola le hami re dabeyey.” ");
INSERT INTO uli_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Pedrus sa kasiya bo, “Samol, iya lobosle hobe loh iyang?” Jesus sa hatefaeli ngo yesa sor bo, “Igla ila towe yoh le hobe dabeyeyloh lobola ibe loh iyang. Seral ngo ho moch dabeyey.” ");
INSERT INTO uli_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedrus yesa kasiya bo, “Samol, meda fal le towe yoh le ibe daboh igla iyang? Isa faesul hatugulu le ibe fangloh yai ngas bo yiglug!” ");
INSERT INTO uli_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus sa hatefaeli ngo yesa sor bo, “Hosa hatugulu le hobe fangloh yam ngas bo yigilyey? Ibe kangalug mala tosal: Imol mala be kkogo sew mael ngo bele fael suluw yam sor bo ho toglayey.” ");
INSERT INTO uli_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus sa kangalur bo, “Ha towe merah ngo towe yeyewal dipmi. Ha hatugulu lal dipmi irel Deus ngo ha wol hatugulu lal dipmi irey. ");
INSERT INTO uli_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ye cholop senggil irel mala imwel mala Temay, ngo ibele loh ibela ffor lilimi mo iyang. Bo hare te ila sengal, ila ngo itowe kangalugmi le ibele loh bo iy bela ffor lilimi mo iyang. ");
INSERT INTO uli_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ibele loh ibela ffor lilimi ngo bela wol miril, ngo isa tefael ibe hasugmiloh ha bela mel irel lobosla ima mel iyang. ");
INSERT INTO uli_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hami ha gola yalepal lobosla ibele loh iyang.” ");
INSERT INTO uli_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas sa kasiya bo, “Samol, ha togla lobosle ho be loh iyang, ila ngo be ifa sengal chog ngo ha sala gola mala yalepal?” ");
INSERT INTO uli_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus sa hatefaeli ngo sa sor bo, “Ngang mele yalap, ngo ngang mele katos, ngo ngang mele molow; tor semal le be yoh le be loh irel mala Temay le be te budoh mwo irey.” ");
INSERT INTO uli_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yesa kangalur bo, “Igla hasa golayey ila ha bele wol gola mala Temay. Iwe ngo igla ila hasa gola ngo ha wiri iy mala Temay.” ");
INSERT INTO uli_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip sa kangalu bo, “Samol, kewar ngalugmem mala Tamom ila ngo bele moch fel depmem.” ");
INSERT INTO uli_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus sa hatefaeli ngo sa sor bo, “Philip, sa sulay yai paoy ngalugmi ngo ha ted golayey chog? Semal le ye wiryey, ila ngo yesa wiri mala Temay. Ila ngo meda mele hola sor bo, ‘Kewar ngalugmem mala Tamom’ iyang? ");
INSERT INTO uli_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Philip, hote chepar le ngang imel irel mala Temay, ngo mala Temay ye mel irey?” Iwe ngo Jesus yesa kangalur mokwe redabeyal bo, “Meka iy kekapta ngalugmi ila te budoh mo irey. Bo mala Temay le ye mel irey mele ye foforu meka. ");
INSERT INTO uli_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ha chepar ngalyey le ngang iy mel irel mala Temay ngo mala Temay ye mel irey. Hare hate chepar iyang ila ngo hasa chepar irel meka iy sa foru. ");
INSERT INTO uli_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ibe kangalugmi mala tosal: Semal le ye tugul lal depal irey ngo be yoh ngali le yebe foru meka ima foru — ila sengal, yebe far paleng tot mekla iy yebe foru bo fal mala ngang ibele loh irel mala Temay. ");
INSERT INTO uli_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te tugul mele habe dongor fael mele idey ngo ibe foru, bo yebe llah ssor la yael Deus le Tamal mo irel mala Lol. ");
INSERT INTO uli_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Te tugul mele habe dongor fael mele idey ngo ibe foru. ");
INSERT INTO uli_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Hare ha hachangiyey ngo habe talenga yalol hatobtob ka yai. ");
INSERT INTO uli_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iwe ngo ibe dangro mala Temay ngo iy yebe fang ngalugmi semal re Hammal le pangal yad ngo yebe mel iremi. ");
INSERT INTO uli_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ila mala Espritu Santus le iy mele yebe kawraloh mekla ye katos le kofal Deus. Iwe ngo yarmetal faileng le ila towe yoh ngalir bo fael mala ir re towe wiri ngo re towe gola. Iwe ngo hami ila ha gola bo yesa mel iremi ngo ye mel luwulumi. ");
INSERT INTO uli_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Yodla ibe loh ngo itowe tahchegumiloh bo ibe chil tefaeldoh iremi. ");
INSERT INTO uli_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Towe sulay ngo yarmetal faileng le re towol wiryey ngo hami habe chil wiryey bo fael mala imolow mele hami habe wol molow iyang. ");
INSERT INTO uli_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bela hola yodla ngo ha bele gola le ngang iy mel irel mala Temay, iwe ngo hami ha mel irey le ye wochog ngang le iy mel iremi. ");
INSERT INTO uli_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Semal le ye dipli ngo ye taelenga yalol hatobtob ka yai ila ngo ye hachangiyey. Iwe ngo mala Temay yebe hachangi semal le ye hachangiyey. Ngo ngang ibe wol hachangi ngo ibe foru bo iy yebe golayey.” ");
INSERT INTO uli_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (te Judas Iscariot) yesa kasiy bo, “Samol, be ifa sengal yam foru bo hamem habe golah ngo yarmetael faileng le re towe golah?” ");
INSERT INTO uli_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus sa hatefaeli ngo yesa sor bo, “Te tugul semal le be hachangiyey ngo yebe taelenga yalol foloy ka yai. Iwe ngo mala Temay yebe hachangi. Iwe ngo ngang mo mala Temay habe budoh irel bo habe mel irel. ");
INSERT INTO uli_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Semal le yete hachangiyey, ngo ye towe taelenga yalol foloy ka yai. Ngo foloy kala hami hasa rongrong ila te yai bo ye budoh mo irel mala Temay le iy mele ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Isa kangalugmi mele irel yodle ichil mel iremi. ");
INSERT INTO uli_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Iwe ngo Re Hammal we ila Espritu Santus le mala Temay be fangdoh fael mele idey. Yebe harepiya ngalugmi pangal formel ngo ye hammang ngalugmi pangal mekla sa mol yai foloyu ngalugmi. ");
INSERT INTO uli_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Isa ligid ngalugmi hopos. Hopos le yai iye isa fang ngalugmi. Ite fang le ye wochog yar yarmetal faileng le ma fang. Ila ha towe merah, ngo ha towe rusmes, ngo ha towe motog. ");
INSERT INTO uli_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Hasa rongrong yai kangalugmi bo, ‘Ngang ibele loh ngo ibe chil tefaeldoh iremi. Hare ha hachangiyey ngo habe rraey irel mala ngang ibele loh irel mala Temay, bo iy ila ye tagiyet mo imoy. ");
INSERT INTO uli_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Isa kangalugmi mele igla mo imol yodla be weldoh pangal meka, bo bela weldoh ngo hami habe chepar. ");
INSERT INTO uli_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Towol sulay yach rol hapatpat bo yeramtala ye lamlir yarmetal faileng le ila ye bele budoh. Iwe ngo iy ila tor kkelal uwoy. ");
INSERT INTO uli_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yarmetal faileng le rebe gola le ngang ihachangi mala Temay. Ila fal le iforu pangal mekla iy ye kangaluyey bo ibe foru. “Ha sudah bo si bele chuy mo iga. ");
INSERT INTO uli_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ngang mele yilgil ire we ngo mala Temay mele chol hammalel. ");
INSERT INTO uli_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yema supiloh ra kala tor uwal ngo ye maldi ra kala yor uwal bo be cholop tot uwal. ");
INSERT INTO uli_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hami ila isa faesul maldugmi irel mokwe isa foloyu ngalugmi. ");
INSERT INTO uli_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Hami habe mel chog irey. Ngo ngang ibe mel chog iremi. Bo tor sera ral ire le be iy chog lufulyal ngo yesa yor uwal. Be yoh le be yor uwal igle ye chil tabtob ngal mala yilgil ire we. Ye wol hafedeg ngalugmi chog le towe yoh le be yor uwami le habe te mel irey. ");
INSERT INTO uli_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ngang mele yilgil ire we ngo hami mele mekla ral. Te tugul semal le yebe mel irey ngo ngang imel irel ngo yebe cholop uwal. Hare ibe tamel iremi ila ngo tor mele be mmal ngalugmi. ");
INSERT INTO uli_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Semal le yebe te mel irey ngo be wochog sera ral ire le resa pedaloh sala betbatloh. Ral ire kala ila sengal ila rebe hateyili fengali resa pedadah wulyef bo yebe fisngegloh. ");
INSERT INTO uli_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Hare habe mel irey ngo ha itol meka yaloy lal yami luluwal, ila ngo te tugul mele ha dipli habe dongor ngo be yoh ngalugmi. ");
INSERT INTO uli_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yebe llah falmay la yael mala Temay mo irel yal cholop uwami; irel yami mel bo redabeyey. ");
INSERT INTO uli_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngang ihachangugmi le ye wochog yael mala Temay hachangiyey. Ha mel chog irel hachangcheng le yai. ");
INSERT INTO uli_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Hare habe taelenga meka isa kangalugmi ngo habe mel chog irel hachangcheng la yai. Yebe wochog yai taelenga mekla mala Temay ye kangaluyey, ila ngang imel chog irel hachangcheng la yal. ");
INSERT INTO uli_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ikangalugmi mele bo be yoh ngalugmi rraey le yai, bo be kkel yami rraey. ");
INSERT INTO uli_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iye mele yai hatobtob: Habe hachangi fengalugmi le be wochog yai hachangugmi. ");
INSERT INTO uli_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hachangcheng la ye hartal palleng ila mala semal yebe fangloh yal ngas bo yiglir mekla maryarel. ");
INSERT INTO uli_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Iwe ngo hami wol maryarey igle ha foru meka ikangalugmi. ");
INSERT INTO uli_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Itay ma ffesangugmi bo hami boy, bo boy ila retema gola mele yar masta ye foforu. Isor le hami maryarey bo isa kangalugmi pangal mekla irongrong mo irel mala Temay. ");
INSERT INTO uli_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Te hami mele ha duwleyey. Ngang mele iduwlehmi ngo ihatugulugmi bo habe loh bo bela cholop uwami, le be tapel uwal ire kowe tor fael sew le be tayikof. Ngo te tugul mele ha dangro mala Temay fael mele Idey ngo be fang ngalugmi. ");
INSERT INTO uli_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iye mele ngang ibe kangalugmi bo habe foru: ha hachangi fengalugmi. ");
INSERT INTO uli_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Hare yarmetael faileng le resa hafobdurugmi ngo ha towe maligili le re metamol hafobdiriyey mo imomi. ");
INSERT INTO uli_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Hare ha chil mel bo yarmetal faileng le, ila ngo habe chang mo irer bo ha chil mel bo chiler. Iwe ngo ngang isa duwlehmi mo luwulur yarmetal faileng le, ila tay hami choluwar. Ila fal le resa hafobdurugmi iyang. ");
INSERT INTO uli_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Habe memangi chog molwe isa kangalugmi: ‘Tor boy le ye tagiyet mo imol yal masta.’ Hare re hafohoyuyey ila ngo rebe wol hafohoyugmi, ngo hare re talenga yalol foloy ka yai ila ngo rebe wol taelenga yalol foloy kala yami. ");
INSERT INTO uli_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngo ligdi bo rebe faor ngalugmi pangal meka bo fael mala hami layi, ngo ir re togla le iy mele ye fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Hare ite budoh hapatpat ngalir ngo towe llah le re molfid. Iwe ngo igla ila towol yoh le rebe sor bo re togla le molfid mekla re foforu. ");
INSERT INTO uli_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Semal le yebe hafobdiriyey ila ngo ye wol hafobdiri mala Temay. ");
INSERT INTO uli_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Hare ite foru yengang ka ted yor mwo semal le ye foru mo luwulur ila ngo towe llah yar tayikof irel molfid kala re foforu. Iwe ngo igla le resa wiri mele isa foru ila resa hafobdurugmem mo mala Temay. ");
INSERT INTO uli_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mele ila ye faesul tugul le be wel doh bo yebe llahloh le ye katos molwe ye teftaf lal babiorol Hatobtob we yar we ye sor bo: ‘Resa hafobdiriyey le tor fal.’ ");
INSERT INTO uli_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Espritu Santus mele Re Hammal le ye bele budoh le iy mele yebe halehaloh mekla ye katos le kofael Deus. Espritu Santus ila yebe budoh mo irel mala Temay. Iwe ngo ibele fangwey iremi bo yebe kapta kofay. ");
INSERT INTO uli_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Iwe ngo hami ila habe wol kapta kofay bo chapildah chog yai yengang ngo hami ha dabeyey. ");
INSERT INTO uli_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ikangalugmi mele bo hade tahcheloh yami tugul. ");
INSERT INTO uli_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Re bele hachuyahmiloh mo irel imwel ttey kala yar. Iwe ngo bela hola yodla ngo semal le yebe limeseloh semal hami ngo yebe luluwaley le iy yesa foru sew yengang kala yael Deus. ");
INSERT INTO uli_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yarmat re be faor ngalugmi meka bo fael mala re ted golayey ngo re ted gola mala Temay. ");
INSERT INTO uli_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Isa kangalugmi meka bo bela hola yodla rebe faor ngalugmi meka ngo be mmang ngalugmi meka ikangalugmi. “Ite faesul kangalugmi meka igwe bo, ichil mel iremi. ");
INSERT INTO uli_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Iwe ngo igla le ibele loh irel yeramtala ye fangdoh ngang, iwe ngo tor semal hami le ye kasiyayey lobole ibe loh iyang. ");
INSERT INTO uli_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Igla le isa kangalugmi meka ila bele kkel tayikofel lal dipmi. ");
INSERT INTO uli_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ibe kangalugmi mala tosal: Ye momay mele ibele chuy tangugmi, bo hare ibe te loh ngo Re Hammal la ila ye towe budoh iremi. Ngo hare ibe loh ngo ibe fangdoh iremi. ");
INSERT INTO uli_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yodla bela budoh Re Hammal la ngo yebe kewar ngalir yarmetal faileng lepal yar machey irel kofal molfid mo kofal meka ye bung mo kofal yael Deus hatugul irel kofer yarmetael faileng le. ");
INSERT INTO uli_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Re machey irel kofael molfid bo ir ila tor yar tugulul ladep irey; ");
INSERT INTO uli_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","re machey irel kofal mekla ye bung bo ngang ila ibele loh irel mala Temay ngo hami ha towol wiryey. ");
INSERT INTO uli_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ngo re machey irel kofael yael Deus hatugul bo yeramtala yema weged deper yarmetael faileng le ngal molfid ila Deus sa faesul hatugulu kofal. ");
INSERT INTO uli_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ye chil cholop mele ibe kangalugmi, ngo halachog ila bele cholop hemas ngalugmi. ");
INSERT INTO uli_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yodla bela budoh Espritu Santus le yema kawraloh mala ye katos le kofael Deus, ngo ye bele kangalugmi pangal mekla ye katos. Te mekla iy ye luluwaley mele yebe kapta kofal, bo yebe kapta kofael mala iy ye rongrong. Iwe ngo yebe wol kangalugmi kofal mekla yebe weldoh. ");
INSERT INTO uli_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yebe fang yai ssor bo ye bele kangalugmi mekla yaloy. ");
INSERT INTO uli_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pangal mekla ye mel irel mala Temay ngo yusuwey; ila fal le iy sor bo Espritu Santus yebe kangalugmi mekla ngang iy kangalu bo yebe kangalugmi. ");
INSERT INTO uli_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Towol sulay ngo hami ha towol wiryeyloh, ngo towe sulay mo wol miril ngo hasa wol wiryey.” ");
INSERT INTO uli_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tot mokwe redabeyal resa kasiy fengal uwor le re sor bo, “Meda fal mele ye kangalgich? Ye kangalgich le towol sulay ngo si towol wiri, ngo towe sulay ngo siya wol wiri. Ngo ye wol sor bo, ‘Ngang iy bele loh irel mala Temay ngo hami ha towol wiryey.’ ");
INSERT INTO uli_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Meda fal mele ‘towol sulay’? Si tugla fal mele ye kekapta kofal!” ");
INSERT INTO uli_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus ye gola le yor mele re dipli bo rebe kasiya. Iwe sa kangalur bo, “Isor bo, ‘Towol sulay ngo hami ha towol wiryeyloh, ngo towe sulay mo wol miril ngo hasa wol wiryey.’ Iye iy molwe ha kekasiy fengal uwomi? ");
INSERT INTO uli_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ibe kangalugmi mala tosal: Ha bele rol tang ngo bele tayikof lal dipmi. Iwe ngo yarmetal faileng le ila re bele rraey. Ye bele tayikof lal dipmi ngo mala tayikofel lal dipmi ila yebe liwel ngal rraey. ");
INSERT INTO uli_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yodla semal fefel yebe harpal dimolow ngo ye bele tayikof depal bo yesa hola yodla ye bele hafohoy irel yal bbareg iyang. Iwe ngo bela subdoh yalwich we lol ngo ye bele maliglaloh hafohoy we yal, bo yesa rraey bo yesa subdoh semal yalwich lal faileng le. ");
INSERT INTO uli_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ila sangmi igla bo ye bele tayikof dipmi. Iwe ngo ibela tefaeldoh iremi ngo hami ha bele rraey. Ila rraey la tor semal le yebe hasi tangugmi. ");
INSERT INTO uli_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Irel yodla ngo tayor mele habe chil dongor ngalyey. Ibe kangalugmi mala tosal: Mala Temay yebe fang ngalugmi pangal mekla habe dangro fael mele Idey. ");
INSERT INTO uli_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yesa holadoh igla ngo tedyor mwo sew formel la dongor fael mele Idey. Ha dongor bo yebe yoh ngalugmi bo yebe kkel yami rraey. ");
INSERT INTO uli_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ikekangalugmi meka le iteptap fiyong. Iwe ngo ye mel sew yad le itowol teptap fiyong, bo ibele haffadoloh yai hapatpat ngalugmi irel kofal mala Temay. ");
INSERT INTO uli_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Irel yodla ngo te tugul mele iy, ngo yebe yoh le habe dongor ngal mala Temay fael mele idey; iwe ngo tayor pelal le ngang ibe dongor ngali bo yaglugmi bo, ");
INSERT INTO uli_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","mala Temay ila ye hachangugmi bo hami ha hachangiyey ngo ha chepar le ngang ibudoh mo irel. ");
INSERT INTO uli_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ibudoh mo irel mala Temay isa budoh lal faileng le, ngo igla ibele chuy tang faileng le bo ibele tefael loh irel mala Temay.” ");
INSERT INTO uli_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iwe ngo mokwe redabeyal resa kangalu bo, “Igla ila hosa hawwel yam hapatpat ngalugmem le ho tay teptap fiyong, ");
INSERT INTO uli_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ila hamem hasa gola le gel ho gola pangal formel. Tayor pelal le semal yebe chil hadogoyug. Gel mele sa hatosiya ngalugmem le gel ho budoh mo irel Deus.” ");
INSERT INTO uli_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus yesa hatefaeli ngalir ngo yesa sor bo, “Hasa chepar igla? ");
INSERT INTO uli_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ye mel sew yad le towol sulay ngo ye bele hola gich. Iwe ngo pangami ngo ha bele rol taroprop fedal, le bele semal hami ngo ye loh lubugtal, iwe ngo bele la ngang loh chog. Iwe ngo halachog ila towe ila sengal bo mala ila Temay ye mel irey. ");
INSERT INTO uli_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Isa kangalugmi mele bo hare be yoh ngalugmi hopos le fael mala hami hasa mel irel le siya rol sew chog. Yarmetal faileng le rebe hafohoyu fedalehmi, iwe ngo hami hasa hakkela dipmi! Bo ngang ila isa lamliloh faileng le!” ");
INSERT INTO uli_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wol miril yael Jesus sor mele ngo yesa kaledah wol laeng ngo yesa sor bo, “Temay Deus, yesa hola awa we. Fang ssor ngal mala Lom bo mala Lom yebe fang ssor ngalug. ");
INSERT INTO uli_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bo gel mele ho fang kkelal bo yebe lamlir panger yarmat, bo hare yebe yoh le iy yebe fang molow la tor siyal ngalir panger rechokla gel ho fang ngali. ");
INSERT INTO uli_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Fael molow la tor siyal, ila mala yarmat rebe golah le gel chog Deus le ye katos iwe ngo re gola Jesus Kristus we ho fangdoh. ");
INSERT INTO uli_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Isa kawraloh ssor la yam mo wol talop; Isa hamalo yengang kowe ho fang ngalyey bo ibe foru. ");
INSERT INTO uli_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Deus Temay! Fang ssorol mele Lom mo irel lobola ho mel iyang, le be wochog ssor we ho fang ngali imol yodwe be subdoh faileng le. ");
INSERT INTO uli_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Isa hamdefa kofom ngalir rechokwe ho fang ngalyey mo lal faileng le, le gel mele ho lamlir, ngo gel mele ho fang ir ngalyey. Iwe ngo ir re talenga yalom. ");
INSERT INTO uli_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ngo igla ila resa gola le pangal meka ho fang ngalyey ngo ye budoh mo irem. ");
INSERT INTO uli_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Isa kangalur molwe ho kangaluyey ngo ir re talenga; resa gola le katos bo ngang ibudoh mo irem, ngo sa tugul deper le gel mele ho fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ite memapel bo yaglir yarmetal faileng le, bo rechokla ho fang ngalyey le resa mel bo lamliyem mele imemapel bo yaglir. ");
INSERT INTO uli_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pangal meka ye mel irey ngo lamliyem, ngo pangal ikla ye mel irem ngo lamliyey, yesa lah ssor le yai mo irer. ");
INSERT INTO uli_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Igla ila ngang ibele buyoy irem. Itay mel lal faileng le ngo ir ila re chil mel lal faileng le. Temay le ho Santus! Hadorar irel kamelal mala idem. Ila yid we ho fang ngalyey, bo be yoh le rebe sew chog le rebe wochog gich le si sew chog. ");
INSERT INTO uli_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yodwe imel irer ngo ihadorar irel kamelal mala idem le ila yid we ho fang ngalyey. Ikekafalir ngo tor semal ir le ye tamel loh, bo halachog yeramtawe ye tugul le yebe tamel loh — bo bela llah le katos molwe babior we ye santus ye sor. ");
INSERT INTO uli_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ngo igla ibele buyoy irem, ngo isa kapta meka lal faileng le bo fael mala be yoh rraey le yai ngalir le be kkel. ");
INSERT INTO uli_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Isa kangalur molwe yalom ngo yarmetal faileng le resa hafobdirir bo fael mala te ir yarmetal faileng le, le re wochog ngang, le te ngang yarmetal faileng le. ");
INSERT INTO uli_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ite dangroh le hobe hachuyar mo lal faileng le, bo idangroh le hobe hafalir bo rede yoh long lal paol Satan. ");
INSERT INTO uli_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Te ir yarmetael faileng le, le re wochog ngang, le te ngang yarmetael faileng le. ");
INSERT INTO uli_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Holbuwar bo rebe santus irel mala ye katos; Mala pedal yalom ila ye katos. ");
INSERT INTO uli_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ifangloh ir lal faileng le, le ye wochog yam fangdoh ngang lal faileng le. ");
INSERT INTO uli_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Isa fang ngang ngalug bo fal mala be wol yoh le rebe fang ir ngalug. ");
INSERT INTO uli_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Te ir chog mele imemapel ngalug bo yaglir, bo iwol memapel bo yaglir rechokla resa chepar irey, le fael mala yalom le meka redabeyey resa kapta ngalir. ");
INSERT INTO uli_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Deus Temay! Imemapel bo hare be yoh le panger ngo rebe sew chog. Hobe tipingir bo be yoh le pangach ngo sibe rol sew chog le be wochog gel mo ngang le si sew chog. Hobe tipingir bo rebe sew chog bo yarmetal faileng le rebe chepar le gel mele ho fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Isa fang ngalir ssor we ho fang ngalyey bo be yoh le rebe rol sew chog le be wochog gich le si sew chog: ");
INSERT INTO uli_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ngang imel irer ngo gel ho mel irey bo be kkel yar sew chog, bo hare yarmetael faileng le rebe gola le gel mele ho fangdoh ngang, ngo ho hachangir le ye wochog yam hachangiyey. ");
INSERT INTO uli_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Deus Temay! Ho fang ir ngalyey, ngo ngang idipli bo rebe mel irel lobosla ima mel iyang, bo be yoh le rebe wiri falmay la yai. Ila falmay we ho fang ngalyey. Bo imol molwe yebe sub faileng le ngo gel ho faesul hachangiyey. ");
INSERT INTO uli_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamay Deus le ho halongol katos! Yarmetael faileng le ila re toglah, iwe ngo ngang igulah, ngo rechoka ila resa gola le gel mele ho fangdoh ngang. ");
INSERT INTO uli_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ngang mele iforu le rebe golah. Ngo ibele tataboloh yai foru le be iye sengal, bo hare lepal mala changey mo irem, ngo yebe wol yoh ngalir; bo ila ngo ngang ibe wol mel irer.” ");
INSERT INTO uli_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wol miril yael Jesus mepel ngo iy mo mokwe redabeyal resa loh le re supiloh mololul wechich we Kidron, resa loh irel sew milay le ye mel loboswe. ");
INSERT INTO uli_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas we ye fangloh Jesus ye gola loboswe bo sa cholop yael Jesus mo mokwe redabeyal ma werfengal mo iyang. ");
INSERT INTO uli_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas yesa palir tot saldawel Roma mo tot mokwe posol Templum we le tamol temarong kowe, mo Pharisees kowe mele re hafdalerloh irel milay we, le re kak metal payur iwe mo habul mo duul. ");
INSERT INTO uli_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus ye gola pangal mokwe ye bele wel ngali. Iwe yesa gib ngalir ngo yesa kasiyar bo, “Itey le ha memeri?” ");
INSERT INTO uli_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ngo ir resa sor bo, “Jesusel Nazareth.” Ngo iy yesa sor bo, “Ngang iye.” Iwe ngo Judas we ye fangloh Jesus ye su luwulur rechokwe. ");
INSERT INTO uli_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yodwe Jesus ye kangalur bo, “Ngang iye,” ngo resa ger tefael resa ppungdiy wototol. ");
INSERT INTO uli_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesus yesa wol kasiyar bo, “Itey le ha memeri?” Ir resa sor bo, “Jesusel Nazareth.” ");
INSERT INTO uli_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus yesa kangalur bo, “Sa mol yai kangalugmi bo ngang iye. Hare ngang mele ha memeriyey, ila ngo hasa ligdir ika sibis bo rebe loh lufulyer.” ");
INSERT INTO uli_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Ye kapta mele bo molwe yesa moal sor ila yebe llah le ye katos: “Tamay Deus, tor semal mo luwulur rechokwe ho fang ngalyey le ye tamel loh.”) ");
INSERT INTO uli_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Pedrus ila ye mel seyay sayden lol. Yesa yuldadah chog sa ffela ngal boy we yael Llulupal Temarong we sala ssupiloh rel talengal rewe gilemra. Idel iy boy la ila Malchus. ");
INSERT INTO uli_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus yesa kangalu Pedrus bo, “Hatefalilong sayden la lom lal mala liliyal! Ho luluwaley le itowe yulmi kapal hafohoy la mala Temay sa fang ngalyey?” ");
INSERT INTO uli_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Saldawel Roma kowe mo tamol we yar, iwe mo mokwe posol Templum we resa ddorfi Jesus resa fargu, ");
INSERT INTO uli_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","resa hasiloh mwo irel Annas. Annas mele temal mala ril Caiaphas. Iwe ngo Caiaphas mele Llulupal Temarong irel raeg la. ");
INSERT INTO uli_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Iy Caiaphas mele ye kangalur tamol kowe yar Jews bo ye far momay le semal yarmat mele yebe mes le fal ngalir panger yarmat. ");
INSERT INTO uli_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pedrus mo semal mokwe redabeyel Jesus re dadabedoh miril Jesus. Yeramtawe choluwal Pedrus ila re gola fengalir mo Llulupal Temarong we. Ye dabelong Jesus lal yororol imw we imwel Llulupal Temarong we. ");
INSERT INTO uli_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Iwe ngo Pedrus ye mel mo ligtam le ye mel lengchel hatemal yororol imw we. Molwe choluwal Pedrus yesa tefaelwey sala hapatpat ngal fefel we ye mel irel hatemal yoror we, iwe ngo yesa fesangulong Pedrus. ");
INSERT INTO uli_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Fefel we irel hatemal yoror we yesa kasiya Pedrus bo, “Te wol gel semal mokwe redabeyel Jesus?” Iwe ngo Pedrus sa sor bo, “Yeb, te ngang.” ");
INSERT INTO uli_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ye kkel hareffoy, iwe boy kowe mo pos kowe resa tolu sew yaef resa su tebalililoh le re rerangir. Pedrus sa loh irer sala su lengcher yesa rerangi. ");
INSERT INTO uli_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Llulupal Temarong we ye hadogoyu Jesus irel kofal mokwe redabeyal mo kofal foloy kowe yal. ");
INSERT INTO uli_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus yesa hatefaeli le ye sor bo, “Pangal yad ngo ima foloy luwul yarmat; pangal yai ma foloy ngo ima foloy lal imwel ttey kowe, mo lal Templum we irel lobokla yarmat rema tteydoh iyang. Tor mele ye llebag mo irel meka ima foloyu. ");
INSERT INTO uli_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ila ngo meda mele hala kekadogoyuyey iyang? Ha kasiyar rechokla re rongrong mekla ima kapta. Ha kasiyar mekla ikangalur bele re gola mekla ikapta.” ");
INSERT INTO uli_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yodwe Jesus ye sor molwe ngo semal pos kowe loboswe yesa ppigri ngo sa kangalu bo, “Meda mele la ila sengal yam hapatpat ngal Llulupal Temarong la iyang!” ");
INSERT INTO uli_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus yesa hatefaeli le ye sor bo, “Hare isa sor sew formel le ye machey, ngo hosa sor bo panger rechoka iga ngo rebe gola. Iwe ngo hare ye bung mokwe isosor, ila ngo meda fal le ho ppigriyey?” ");
INSERT INTO uli_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Iwe Annas yesa fangloh Jesus le ye ffoar chog ngo resa hasiloh irel Caiaphas we iy mele Llulupal Temarong. ");
INSERT INTO uli_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedrus ye chil su loboswe le ye rerangi, ngo tot rechokwe loboswe resa kasiya bo, “Te gel semal mokwe redabeyel mwal lay?” Iwe ngo Pedrus yete hawwele yal hapatpat ngalir le iy semal, iwe yesa sor bo, “Yeb, te ngang.” ");
INSERT INTO uli_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Semal boy kowe yael Llulupal Temarong we ila yarmetal mal we Pedrus ye ssupiloh molwe talengal. Boy we yesa kasiya Pedrus bo, “Te gel molwe iwurug we ho mel irel mal lay mo woal milay we?” ");
INSERT INTO uli_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedrus yesa wol sor bo, “Yeb.” Yodla chog ngo sa kkogo sew mael. ");
INSERT INTO uli_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lemaguyugol chog rallawe seral ngo resa hasi Jesus mo irel imwe imwel Caiaphas resa hasiloh irel molwe bugtal Aam. Tamol kowe yar Jews rete bulong lal imw we imwel Aam bo rede tungaf ngo hare be yoh le re bela dabey mongol Paska we. ");
INSERT INTO uli_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilatus sa buyoy irer yesa kasiyar bo, “Meda mele mal le yesa hadre?” ");
INSERT INTO uli_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Resa hatefaeli ngo resa sor bo, “Hare tor tayikof le ye foru ila ngo ha towe hasidoh irem.” ");
INSERT INTO uli_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus yesa kangalur bo, “Ha hasi hami ha bela hatugulu kofal le habe dabey yami hatobtob.” Resa hatefaeli ngo resa sor bo, “Rete fang kkelmem le be yoh le habe limeseloh semal.” ");
INSERT INTO uli_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Yesa iye sengal mele bo yebe llah le ye katos molwe Jesus ye sor irel yodwe ye kapta wululul yal be mes.) ");
INSERT INTO uli_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus sa tefael long yilim sa fesangu Jesus ngo yesa kasiya bo, “Gel mele yar Jews King?” ");
INSERT INTO uli_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iwe ngo Jesus yesa kasiya bo, “Gel chog yam kasiy mala, hare yor le yesa kangalug kofay?” ");
INSERT INTO uli_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus yesa hatefaeli ngo yesa sor bo, “Ho chichiy le ngang semal Jews? Mekla yarmetal faliyem mo tamol temarong kowe mele re hasugdoh irey. Meda mele hosa hadre?” ");
INSERT INTO uli_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus yesa sor bo, “Mala lamliyey ila ye tamel lal faileng le; bo hare ye mel mala lamliyey lal faileng le, ngo mekla re pilyey rebe fedeg bo ngang ide yoh long lal payur tamol kala yar Jews. Yeb, mala lamliyey ila ye tamel lal faileng le!” ");
INSERT INTO uli_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Iwe Pilatus yesa kasiya bo, “Gel semal king?” Jesus yesa hatefaeli le ye sor bo, “Gel mele ho sor le ngang semal king. Ngang isubdoh lal faileng le bo ibe kapta kofal mala ye katos. Semal le yema kapta mala ye katos ila yebe taelenga meka ima kapta.” ");
INSERT INTO uli_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus yesa kasiya bo, “Mada mele katos?” Iwe ngo Pilatus yesa tefaelwey ligtam irer Jews kowe ngo yesa kangalur bo, “Tor mele ngang iwiri le derel yeramtale le hare ibe sor bo yebe mes. ");
INSERT INTO uli_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngo ligdi bo siya ma faesul foru le irel yodol mele Bungul Paska, ngo ima hachuya semal chol kalbus le hami ha dipli. Ha diply le ibe taldi ngalugmi King le yar Jews?” ");
INSERT INTO uli_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Iwe ngo ir resa tawulagililoh le re sor bo, “Yeb, te iy! Ha dipli Barabbas!” (Barabbas ila semal maelfefedeg ngo ye machoh.) ");
INSERT INTO uli_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Iwe Pilatus yesa fangloh Jesus bo re bela wwodu. ");
INSERT INTO uli_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Saldaw kowe resa foru sew ral ire kowe yor chil bo marel resa yetedah wol molwe chemal, iwe resa hamengagu ngal sew mengag le ye lelay ngo ye checcha mala ddolal. ");
INSERT INTO uli_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Resa budoh irel ngo resa sor bo, “Yebe sulay King le yar Jews!” Resa dar ngali ngo resa ppigri. ");
INSERT INTO uli_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus yesa wol tefaelwey irel buwa we ngo sa kangalur bo, “Ha kaladoh, ibele hasiwey yeramtawe iremi bo habe gola le tor derel le ngang iy wiri.” ");
INSERT INTO uli_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iwe Jesus yesa buyoy le ye mermar irel ral ire we yor chil ngo ye mengag irel mengag we ye lelay ngo ye checcha molwe ddolal. Pilatus yesa kangalur bo, “Ha kaladoh! Mal we iye le!” ");
INSERT INTO uli_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yodwe tamol temarong kowe mo mokwe posol Templum we rela wiri ngo resa tawulagililoh le re sor bo, “Ha krudu! Ha krudu!” Pilatus sa kangalur bo, “Ha hasi hami ha bela krudu. Tor mele ngang iy wiri le derel.” ");
INSERT INTO uli_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Buwa we resa hatefaeli ngo resa sor bo, “Ye mel irel hatobtob la yamem le hare semal yebe sor bo iy Lol Deus ngo yarmat rebe limeseloh.” ");
INSERT INTO uli_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Yodwe Pilatus yela rongrong molwe ngo yesa kkel loh tot yal motog. ");
INSERT INTO uli_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yesa tefael long yilim sala kasiya Jesus bo, “Iya lobosle ho budoh mo iyang?” Iwe ngo Jesus yete maliliy. ");
INSERT INTO uli_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatus sa kangalu bo, “Ho towe malili ngalyey? Ho togla le yor kkeley le ibe taldug, ngo ye wol yor kkeley le ibe fang gel bo re bela krudug?” ");
INSERT INTO uli_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus yesa hatefaeli ngo sa sor bo, “Mala kkelem uwoy ila Deus mele ye fang ngalug. Iwe ngo yeramtala ye fang long ngang lal pom mele yesa foru molfid la ye palleng.” ");
INSERT INTO uli_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yodwe Pilatus ye rongrong mele ngo yesa luwaley le yebe taldi Jesus. Iwe ngo buwa we resa tawulagili chog le re sor bo, “Hare hobe taldi yeramtala ila ngo te gel maryarel mala Llulupal Roma! Bo semal le yebe sor bo iy semal king ngo yesa hapaliyel ngal mala Llulupal Roma!” ");
INSERT INTO uli_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Yodwe Pilatus yela rongrong mokwe re sosor ngo yesa hasiwey Jesus mo ligtam. Iwe ngo Pilatus yesa marrodiy irel molwe liliyer chol tatelal hapatpat mo wol dayif we rema sor bo, “Gabbatha” (le ila mele idal mo irer Hebrew). ");
INSERT INTO uli_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yesa harep wwelel yaal ralale mo imol chog molwe Bungul Paska. Pilatus yesa kangalur yarmat bo, “King we yami iye!” ");
INSERT INTO uli_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Iwe ngo ir resa tawulagili le re sor bo, “Ha limeseloh! Ha limeseloh! Hala krudu!” Pilatus yesa kasiyar bo, “Ha dipli le ibe krudu king le yami?” Tamol temarong kowe resa hatefaeli ngo resa sor bo, “Mala Llulupal Roma mele yamem king!” ");
INSERT INTO uli_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Iwe Pilatus yesa fang Jesus bo re bela krudu. Iwe resa hasiy Jesus. ");
INSERT INTO uli_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesus yesa hayyefra krud we yal yesa buyoy mo yulgul hasohsoh yee, yela hola doh loboswe rema sor bo “Liliyel Pol Fusug.” (Hebrew rema sor bo “Golgotha.”) ");
INSERT INTO uli_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ila lobole rela krudu mo iyang. Iwe ngo re wol krudu rumal mal le re hallepda Jesus. ");
INSERT INTO uli_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus ye teftafdah wol sedep pap iwe yesa fang bo rebe chifilidah woal molwe krudul Jesus. Ye tafa mele le ye sor bo, “Jesusel Nazareth, King we yar Jews.” ");
INSERT INTO uli_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ye cholop le ye yawli molwe bo loboswe re krudu Jesus iyang ila ye te ddaw tang hasohsoh. Ye teftaf irel yalol Hebrew, mo Latin, mo Greek. ");
INSERT INTO uli_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tamol temarong kowe resa kangalu Pilatus bo, “Ho towe tefa le yar ‘Jews King’ bo, ye momay le hobe tefadah iyang le hobe sor bo, ‘Mal le ye sor bo, Ngang mele yar Jews King.’” ");
INSERT INTO uli_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatus yesa hatefaeli ngo sa sor bo, “Mele isa tefadiy ila, ila mala yebe mel iyang.” ");
INSERT INTO uli_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yela wol miril yar saldaw kowe krudu Jesus ngo resa hasi mokwe mengagol resa hamhela uwor we re famal. Semal saldaw kowe ngo ye hasi sew. Re wol hasi molwe mengagol we ye lelay we sewloh chog molwe doddorol. ");
INSERT INTO uli_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Saldaw kowe resa kapta fengali le re sor bo, “Si towe hatawsi mengag le bo si bele sulbweli hare itey semal gich le yebe hasi.” Iye sengal mele bo yebe llah le ye katos molwe babior we ye santus ye sor: “Resa hamhela mokwe mengaguy uwor ngo resa sulbweli le yebe hasi molwe mengaguy we ye lelay.” Iye sengal mele saldaw kowe re foru. ");
INSERT INTO uli_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Rechokwe re su lengchel molwe krudul Jesus ila Maria we sil, mo mala bisil, iwe mo Mary we ril Clopas mo Mary Magdalena. ");
INSERT INTO uli_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus ye wiri molwe sil mo molwe redabeyal we ye hachangi le re su lobowe, iwe ngo yesa kangalu molwe sil bo, “Lom ila.” ");
INSERT INTO uli_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Iwe yesa kangalu molwe redabeyal bo, “Solom ila.” Iye yodle molwe redabeyel Jesus ye fesangu Maria bo ye bela mel irel, irel bugtal. ");
INSERT INTO uli_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus ye gola le yela yodle ngo iy yesa hammalo pangal formel. Iwe yesa sor bo, “Isa betbat.” Ye sor mele bo yebe hallehaloh le ye katos molwe babior we ye santus ye sor irel. ");
INSERT INTO uli_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ye mel sew tohoh loboswe le ye ssogol wine kowe ye mwall. Iwe resa chiri sew forwa irel wine we resa yetedah wol sera ral hyssop resa hapecha ngal molwe yewal. ");
INSERT INTO uli_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus ye yulmi chog wine we ngo yesa sor bo, “Yesa moll!” Iwe yesa cchimdiy chog wototol ngo ye chuyloh yal ngas. ");
INSERT INTO uli_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iwe ngo tamol kowe yar Jews resa dangro Pilatus bo rebe hoppiy pecher rechokwe resa krudur, iwe ngo resa hachuyardiy mo woal krud. Re dongor molwe bo rallawe ila Halimralel yengang, ngo rete dipli le bela Sabbath ngo ye chil mel holong kowe woal krud. Bo Sabbath ila sew bong le ye palleng. ");
INSERT INTO uli_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Iwe saldaw kowe resa hoppiy pecher rechokwe re krud sew mo Jesus. ");
INSERT INTO uli_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iwe ngo rela budoh irel Jesus re sala wiri le yesa mes. Iwe re tay hoppiy mokwe pechel. ");
INSERT INTO uli_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Semal saldaw kowe ye hasi pochoch we sogol sa ddowu ngal molwe fael hadhadol Jesus, yodla chog ngo sa serdiy chael mo ccha wototol. ");
INSERT INTO uli_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Yeramtala ye wiri mele ila iy mele ye kapta kofal bo hare hami habe wol chepar iyang. Mala ye kapta ila ye katos, iy ngo ye gola le ye kapta mala katosal.) ");
INSERT INTO uli_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yela iye sengal mele bo be llah le ye katos molwe babior we ye santus ye sor: “Tor seyay mekla chil le be mahos.” ");
INSERT INTO uli_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ye wol mel lal babior we ye santus le ye sor bo, “Yarmat rebe kalngali yeramtala resa ddowu.” ");
INSERT INTO uli_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yela wol miril mele ngo Josephel Arimathea we yesa dangro Pilatus hare be yoh le yebe hasi molwe porgol Jesus. (Joseph ila wol iy semal mokwe redabeyel Jesus, ngo ye lebagili bo ye metagur tamol kowe yar Jews.) Pilatus ye kangalu bo be yoh le yebe hasi porog we, iwe Joseph sa loh sala hasi. ");
INSERT INTO uli_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus we yesa hamoal loh ye sala tefael mo irel Jesus lubungul seral, ye dabey Joseph, le ye hasi be subguy pawun irel loy le resa delali fengali myrrh mo aloes. ");
INSERT INTO uli_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mal kowe rumal re hasi molwe porgol Jesus resa dugmi ngal mengag, le re yitet loy iyang le re dabey mokwe kkor Jews irel haliliyel maes mo imol liblib. ");
INSERT INTO uli_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ye mel sew milay lengchel loboswe re krudu Jesus mo iyang le ye mel sew pey iyang le ye moch mol. Pele ila tedyor mwo le ye liblib iyang. ");
INSERT INTO uli_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Resa yetolong molwe porgol Jesus lal pewe bo ila pela ye harep, iwe ngo bele la rallawe seral ngo Sabbath. ");
INSERT INTO uli_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ye chil ruchupung lemeralel rallawe Sunday ngo Mary Magdalena yesa loh irel pewe ye sala wiri le sa chuyloh porow we piltal molwe hatemal pewe. ");
INSERT INTO uli_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yesa ddar sa loh irel Simon Pedrus mo apostel we semal we Jesus ye hachangi ye sala kangalur bo, “Resa hachuya Samol mo lal pewe, ngo ha togla lobosle re sala itol mo iyang!” ");
INSERT INTO uli_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Iwe Pedrus mo apostel we semal resa loh irel pey we. ");
INSERT INTO uli_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Resa loh le re ddar iwe ngo ye mmid iwe semal mo imol Pedrus iwe ye sala hamoal hola pewe. ");
INSERT INTO uli_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yesa kallong sala wiri mengag kowe ngo iy yete bulong. ");
INSERT INTO uli_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Pedrus ye hamirdoh chog yesa bulong lal pewe sala wiri mengag kowe ye mel wototol, ");
INSERT INTO uli_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","iwe mo mengag we ye dudug ngal molwe chemel Jesus, le ye tamel luwul mengag kowe tot bo ye musloh le ye lul fengal. ");
INSERT INTO uli_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ngo apostel we semal we ye moal hola pewe yesa wol bulong, ye sala wiri mokwe ngo yesa chepar. ");
INSERT INTO uli_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ir re temedaf chog irel molwe babior we ye santus ye sor le iy yebe molow tefael mo irel maes.) ");
INSERT INTO uli_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Iwe resa tefael ngal molwe bugter. ");
INSERT INTO uli_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary ye su yulgul pewe le ye tetang. Yodwe ye chil tetang ngo yesa hataeplong lal pewe ");
INSERT INTO uli_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","sala wiri rumal angelus le ye bbechrag mekla mengagur. Re maroro loboswe re itol molwe porgol Jesus iyang le semal ye mel mo wolul ngo semal mo wolpech. ");
INSERT INTO uli_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Iwe resa kasiya we bo, “Fefel la, meda mele ho tetang iyang?” Iwe ngo iy yesa sor bo, “Resa hasiloh Samol we yai, ngo itugla lobosle re sala itol mo iyang!” ");
INSERT INTO uli_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iwe yesa tagul tefael sala wiri Jesus le ye su loboswe; ngo ye togla le Jesus molwe. ");
INSERT INTO uli_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus yesa kasiya bo, “Fefel la, meda mele ho tetang iyang? Itey le ho memeri?” Fefel we yebe kachog le chol milay we iy molwe. Iwe yesa kangalu bo, “Hare gel melap mele ho hasi molwe porgol, ngo hosa kangaluyey lobosle ho itol iyang bo ibela hasi.” ");
INSERT INTO uli_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iwe ngo Jesus yesa sor bo, “Mary!” Ngo Mary yesa tagul ngali ngo sa sor irel yalol Hebrew bo, “Rabboni!” (Fael mele ila “Sensey.”) ");
INSERT INTO uli_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus yesa kangalu bo, “Ho towe yangsiyey bo ited loh irel mala Temay. Ho loh irer mokwe wol bisiy ngo hosa kangalur bo ibele tefael loh irel mala Temay le wol Temer, le yai Deus ngo wol yar Deus.” ");
INSERT INTO uli_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Iwe Mary Magdalena yesa loh ye sala kangalur mokwe redabeyel Jesus bo iy yesa wiri Samol. Iwe ngo ye wol kangalur molwe Jesus ye kangalu. ");
INSERT INTO uli_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lefhafel Sunday we ngo mokwe redabeyel Jesus resa rol ttey fengal lal sew imw resa loka mekla hatemal bo resa metagur tamol kowe yar Jews. Iwe ngo Jesus ye budoh sala su luwulur ngo sa sor bo, “Hopos be mel iremi.” ");
INSERT INTO uli_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","La wol miril yal sor molwe ngo yesa kewar ngalir mokwe paol mo fael molwe hadhadol. Yesa kkel yar rraey irel molwe resa wiri Samol. ");
INSERT INTO uli_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus sa wol kangalur bo, “Hopos be mel iremi. Ibele hagloyugmiloh le yebe wochog yael mala Temay hagloyuyeydoh.” ");
INSERT INTO uli_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iwe yesa yugugdah uwor ngo yesa sor bo, “Yebe mel Espritu Santus uwomi. ");
INSERT INTO uli_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hare habe hachuya fael yael yarmat molfid ngo yebe chuy, ngo hare hami habe te hachuya ngo towe chuy.” ");
INSERT INTO uli_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomas we semal mokwe redabeyel Jesus (we rema fesang ngali bo Lubbe) ila ye tamel irel yodwe ye budoh Jesus. ");
INSERT INTO uli_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Iwe rechokwe resa kangalu bo, “Hamem hasa wiri Samol!” Iwe ngo Thomas yesa kangalur bo, “Ibe te wiri ngo iyangsi gubul chifel kowe irel mokwe paol, ngo iyetolong payi irel giltal molwe hadhadol ngo iy towe chepar.” ");
INSERT INTO uli_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","La sew week mo wol miril ngo mokwe redabeyel Jesus resa wol ttey fengal yilim ngo yesa mel Thomas irer. Ye wol lok hatemal imw we re mel iyang, iwe ngo Jesus ye budoh sala su luwulur ngo yesa sor bo, “Hopos be mel iremi.” ");
INSERT INTO uli_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Iwe ngo yesa kangalu Thomas bo, “Budoh bo hobe kemahoy ngo ho yangsi gubul chifel kowe irel meka payi, iwe ngo ho yangsi fael mele hadhadoy. Ho towe hayeyewala depom. Hobe hatugulu lal depom!” ");
INSERT INTO uli_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas sa hatefaeli le yesa sor bo, “Yai Samol ngo yai Deus!” ");
INSERT INTO uli_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iwe ngo Jesus yesa kangalu bo, “Hosa moch chepar irel mala hosa wiryey? Be momay deper rechokla re te wiryey ngo re chepar irey!” ");
INSERT INTO uli_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ye cholop kkemal kala Jesus ye foru le mokwe redabeyal re wiri iwe ngo yete teftafdiy lal babior le. ");
INSERT INTO uli_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ika ila yesa teftafdiy lal babior bo fael mala habe chepar le Jesus ila iy Kristus we Lol Deus. Iwe ngo yami tugul irel mele yebe yoh ngalugmi molow iyang. ");
INSERT INTO uli_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yela wol mwiril mele ngo Jesus yesa wol llah ngalir mokwe redabeyal mo irel Laom we Tiberias. Iye sengal yal llah ngalir; ");
INSERT INTO uli_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Pedrus, mo Thomas (we rema fesangu bo Libbey), mo Nathanael (we semal yarmetal Cana le sew mokwe faluyel Galilee), mo tarmal kowe lol Zebedee, iwe mo wol rumal mokwe redabeyel Jesus resa rol ttey fengal. ");
INSERT INTO uli_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Iwe ngo Simon Pedrus yesa kangalur bo, “Ibele la fita.” Iwe ngo resa kangalu bo, “Habe daboh.” Iwe resa dage seyay boat resa loh re sala fitalbong yee, la rael loh ngo tor mele re hola. ");
INSERT INTO uli_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yela tehachdah yaal ngo Jesus ye su machngeted ngo mokwe redabeyal re togla bo Jesus molwe. ");
INSERT INTO uli_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iwe ngo Jesus yesa kasiyar bo, “Yor mele hasa hola?” Iwe ngo ir resa sor bo, “Tayissemalmwo.” ");
INSERT INTO uli_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesus yesa kangalur bo, “Ha halgaloh wug la yami mo rela gilemra mo irel boat la, ila ngo be yor mele ha be hola.” Iwe resa halgaloh wug we sala ssogloh irel yig le tay bang le rebe yafsi tefaelidah. ");
INSERT INTO uli_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yeramtawe redabeyal Jesus we Jesus ye hachangi sa kangalu Pedrus bo, “Samol we mala!” Yodwe Pedrus ye rongrong le Samol molwe ngo yesa fargudah molwe mengagol llupwal (bo ye hachuya mokwe mengagol) yesa mmusloh leted. ");
INSERT INTO uli_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Iwe ngo ikowe tot resa dagelong boat we hatalpiy le re lugsu wug we yar le sa ssogol yig. Rete ddaw tang fuluy bo medalbo yebe hal lemeg ngafal ddawer tang fuluy. ");
INSERT INTO uli_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yodwe resa dardah mo wulpiy ngo resa wiri yaef we yetoa le yor yig uwol, iwe mo flowa. ");
INSERT INTO uli_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iwe Jesus yesa kangalur bo, “Ha hasidoh tot yig kala ha moch hola.” ");
INSERT INTO uli_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Pedrus yesa herahdah yuchul boat we, iwe resa yuradah wug we wulpiy le ye ssogol yig, le subguy mo lemeg mo solmol pangal loh. Ila lepal yig we lal wug we ngo yete towas. ");
INSERT INTO uli_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus yesa kangalur bo, “Ha budoh bo habe mongoy.” Iwe ngo tor semal mokwe redabeyel Jesus le ye kkel depal le hare be kasiya bo, “Gel itey?” Bo re gola bo Samol molwe. ");
INSERT INTO uli_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iwe sa loh Jesus sala hasi flowa kowe sa ngaler, ngo wol ila sengal mele ye foru ngal yig kowe. ");
INSERT INTO uli_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iye mele hasluwel yael Jesus llah ngalir mokwe redabeyal mo wol miril yal molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Rela mol mo irel mongoy ngo Jesus sa kasiya Simon Pedrus bo, “Simon le gel lol John, ye kkel yam hachangiyey mo imor ika sibis?” Simon Pedrus sa hatefaeli le ye sor bo, “Ngoa, ila sengal ho Samol, gel ngo ho gola le ihachangug.” Jesus yesa kangalu bo, “Hafalir saaf ka layi.” ");
INSERT INTO uli_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesus sa wol kasiya tefaeli le ye sor bo, “Simon le gel lol John, ho hachangiyey?” Pedrus yesa hatefaeli ngo yesa sor bo, “Ngoa, ila sengal ho Samol, gel ho gola le ngang ihachangug.” Jesus yesa wol kangalu bo, “Hafalir saaf ka layi.” ");
INSERT INTO uli_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yela molwe hasluwal ngo Jesus yesa wol kasiya bo, “Simon le gel lol John, ho hachangiyey?” Yesa tayikof depel Pedrus irel molwe sa fael suluw yael Jesus kasiya bo, “Ho hachangiyey?” Iwe yesa kangalu bo, “Samol, pangal formel ngo gel ho gola; ho gola le ihachangug!” Iwe ngo Jesus yesa wol kangalu bo, “Hafalir saaf ka layi. ");
INSERT INTO uli_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ibe kangalug mala tosal: Yodwe ho chil tarmal ngo te tugul solbos le ho dipli bo hobe loh iyang ngo homa loh. Iwe ngo ho bela malelap, ngo ho bele hadingawey mekla pom, ngo semal yebe fargu sa palugloh solbos le gel hote dipli bo hobe loh iyang.” ");
INSERT INTO uli_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jesus ye kekapta wululul yal be mes Pedrus le yebe kawraloh falmay la yael Deus.) Iwe Jesus yesa kangalu bo, “Dabeyey!” ");
INSERT INTO uli_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedrus sa tagul tefael sala wiri molwe redabeyel Jesus we ye kkel yael Jesus hachangi. Iye iy yeramtawe ye roh ngal Jesus irel yodwe re momongol fehaf ngo yesa kasiya bo, “Samol, itey le yebe fangloh gel?” ");
INSERT INTO uli_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yodwe Pedrus yela wiri ngo yesa kasiya Jesus bo, “Samol, ifa sengal iye semal?” ");
INSERT INTO uli_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus sa hatefaeli, “Hare ngang idipli bo iyebe mel yee, la hola yodla ibe tefaeldoh iyang, ila ngo meda mele ho kasiy iyang? Dabeyey!” ");
INSERT INTO uli_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iwe sa medarloh kaptal molwe luwulur panger mokwe redabeyel Jesus, le yeramtale semal ila ye towe mes. Ngo ligdi bo Jesus yete sor le towe mes yeramtale. Jesus ye sor bo, “Hare ngang idipli bo be mel yee, la hola yodla iy be tefaeldoh iyang, ila ngo meda mele ho kasiy iyang?” ");
INSERT INTO uli_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iye molwe redabeyel Jesus we ye kapta kofael meka, ngo wol iy chog mele ye tefadiy meka lal babior. Iwe ngo hamem ha gola le meka iy ye kapta ila ye katos. ");
INSERT INTO uli_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ye cholop mekla Jesus ye wol foru. Hare pangal loh meka ngo ye teftafdiy lal babior, iwe ngo yai luluwal ila ye towe daw pangal babior kala lal faileng le. ");
INSERT INTO uli_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ssarol Wom Ho Theophilus: Irel metamol babior we yai ngo itefa kaptal pangal mokwe Jesus ye foru ngo ye foloyu irel yodwe ye chap yal yengang yee, la hola yodwe ");
INSERT INTO uli_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ye bidah woal laeng iyang. Imol yodwe ye bele bidah wol laeng ngo yesa foloyur mal kowe yesa duwler bo lol apostel le ye foloyur irel mala kkamelal Espritu Santus. ");
INSERT INTO uli_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Fayeg ral mo wol miril yodwe ye mes iyang ngo ye cholop yal ma llah ngalir, le ye holngol hatosiya ngalir le iy yesa molow tefael mo irel maes. Resa wiri ngal meter ngo iy ye kekapta ngalir kofal mala Lamliyel Deus. ");
INSERT INTO uli_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yodwe rela rol ttey fengal ngo yesa sor yalol le iye mele ye kangalur: “Ha towe chuy tang Jerusalem bo habe widi chog kkefang we isa kangalugmi kofal. Ila kkefang we mala Temay yesa hatugulu bo yebe fang. ");
INSERT INTO uli_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Johannes ye baptismus yarmat irel chael, iwe ngo saaf e fedbong ngo hami ha bele rol baptismus irel Espritu Santus.” ");
INSERT INTO uli_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yodwe apostel kowe re ttey ngal Jesus ngo resa kasiya bo, “Samol, igala mele ho bele hatefali ngalir re Israel molwe lamliyer?” ");
INSERT INTO uli_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus yesa kangalur bo, “Te hami mele habe gola yodla iy, bo yodla iy mo ralla iy ila yusuwel chog mala Temay. ");
INSERT INTO uli_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Halachog ila bela bidiy Espritu Santus uwomi ngo bele yor kkelmi, ngo ha bele mel bo yai tugul mo woal Jerusalem, mo woal pangal loh Judea mo Samaria, mo pangal balel faileng le.” ");
INSERT INTO uli_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wol miril yal sor mele ngo yesa llangdah mo imor yesa bidah woal laeng ngo ir re kekamahoy yee, sedep darmiy yela pilta loh. ");
INSERT INTO uli_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Re chil kekaldah wol laeng irel yodwe yesa ligdir, ngo sa su loh rumal mal mo lengcher le re mengag irel mokwe ye bbech, ");
INSERT INTO uli_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ngo resa sor bo, “Mall Galilee kala, meda mele hasa rol su hasa kakaledah chog woal laeng iyang? Jesus we sa lugdugmi yesa bidah woal laeng ila yebe tefaeldoh, le be wochog yami wiri igla irel yal bidah woal laeng.” ");
INSERT INTO uli_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iwe apostel kowe resa tefael loh Jerusalem le re budoh mo irel molwe Tayitel Olives, we be setab mile ddawal tang haplom we. ");
INSERT INTO uli_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Rela bulong wol haplom we resa bidah irel singil we re memel iyang: Ir Pedrus mo John mo James mo Andrew mo Philip mo Thomas mo Bartholomew mo Matthew mo James we lol Alphaeus, mo Simon we semal Patriot mo Judas we lol James. ");
INSERT INTO uli_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Rema toa ttey fengal rebe mapel, le ir mo mokwe wol bisil Jesus mo Maria we sil mo tot fefel. ");
INSERT INTO uli_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Fedral mo wol miril ngo resa ttey fengal chotugul kowe, le malbo rebe subguy mo riyeg leper pangerloh, ngo Pedrus yesa sudah bo yebe maliliy ngalir. ");
INSERT INTO uli_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Yesa sor bo, “Re wol bisiy, yebe llah le ye katos mokwe babior we ye santus we ye sor bo Espritu Santus ye kangalgich mo irel yael David kapta kofal Judas we ye palirdoh rechokwe re ddorfi Jesus. ");
INSERT INTO uli_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas iwe semal choluwach, we Jesus ye duwley bo chilach irel yengang.” ");
INSERT INTO uli_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas ye chuwayi sedep bugat mo irel salpiy we ye yoh ngali irel molwe ye foru we ye tayikof; ila lobowe yela mes mo iyang. Ye ppungdiy sala tar molwe siyal, sala tappolwey mokwe yadol siyal. ");
INSERT INTO uli_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Panger rechokwe re mel wol Jerusalem ngo re rongrong kaptal, iwe resa hadeda bugat la irel yalol faluyer le re sor bo bugtal Akeldama, le fael mele ila, “Bugtael Ccha.”) ");
INSERT INTO uli_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Bo ye teftaf lal molwe babiorol Psalm we ye sor bo, ‘Imw la imwal ila yebe poel chog; tor semal le yebe mel iyang.’ Ngo ye wol teftaf we ye sor bo, ‘Ligdi bo semal yebe yusuwiliy mo irel yengang la yal.’ ");
INSERT INTO uli_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Ila semal yebe chilagich irel yach mel bo tugulul yael Samol Jesus molow tefael mo irel maes. Be semal mal kowe ye mel irech irel pangal loh yod kowe gich si dabe fedaley Samol Jesus irel malekah iyang. Ye chap mo irel yodwe Johannes ye foloyu kofal baptismus yee, la hola yodwe Jesus ye chuy tang gich sa bidah wol laeng.” ");
INSERT INTO uli_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iwe resa duwley rumal mal: Matthias mo Joseph, we rema ffesangu bo Barsabbas (ngo wol sew idal ila Justus). ");
INSERT INTO uli_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Iwe ngo resa rol mepel le re sor bo, “Samol, ho gola yar panger yarmat luluwal. Kewar ngalugmem semal mo irer chole rumal le hasa duwler, ");
INSERT INTO uli_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","bo yebe mel bo semal apostel yebe liwli Judas we yesa chuy sa loh lobola faesul liliyal.” ");
INSERT INTO uli_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Iwe ngo resa hattugul uwor mal kowe rumal, ngo Matthias mele re hatugulu, iwe yesa chilar apostel kowe seg mo semal. ");
INSERT INTO uli_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yela hola molwe Bungul Pentecost, ngo panger rechokwe ye tugul lal deper ngo resa rol ttey fengal chog solbos. ");
INSERT INTO uli_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Re tedap loh chog ngo yesa ngung diy sew formel mo lal laeng le ye wochog ngungul yaeng le ye kkel, yesa ngunglong lal pangal loh imw we re rol maro iyang. ");
INSERT INTO uli_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iwe ngo resa wiri tot formel le ye wochog bbulul yaef le yesa iyyag fetang sa bidiy uwol semal mo semal ir. ");
INSERT INTO uli_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Panger ngo resa ssogol Espritu Santus ngo sa chaep yar yalol sew mo sew fuluy, bo Espritu Santus yesa foru le yebe mmal le rebe yalol sew mo sew fuluy. ");
INSERT INTO uli_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yor yarmetael Jews le re mel woal Jerusalem, Jews ka re hasrowu Deus, le re budoh mo woal pangal loh faluyel faileng le. ");
INSERT INTO uli_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yodwe re rongrong ngungul molwe ngo sa ttey fengal sew buwal yarmat le ye paleng. Resa lluwdah bo semal ir ngo ye rongrong yar apostel kowe maliliy irel yalol faluyal. ");
INSERT INTO uli_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Luwul yar lluwdah ngo resa sor bo, “Rechoka resa yalol faluyach, ngo ir yarmetal Galilee! ");
INSERT INTO uli_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ifa sengal mele pangach ngo si rongrong yar yalol faluyach? ");
INSERT INTO uli_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Iye gich yarmetal Parthia mo Media mo Elam. Iwe ngo sibis gich re budoh mo woal Mesopotamia, sibis mo Judea, sibis mo Cappadocia, mo Pontus, mo Asia. ");
INSERT INTO uli_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Iwe ngo sibis re budoh mo Phrygia, mo Pamphylia, mo Egypt, mo mokwe faluyel Libya lengchel Cyrene. Sibis gich re budoh mo Roma, le ");
INSERT INTO uli_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jews fengal mo Gentiles ka resa weg ngal taliw le yar Jews; iwe ngo sibis gich re budoh mo wol Crete mo Arabia — iwe ngo pangach loh ngo si rongrong yar yalol faluyach ngalgich le re sosor meka ye paleng le Deus yesa foru!” ");
INSERT INTO uli_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Luwul yar lluwdah mo yar tay medaf fedal ngo resa rol kasiy fengal chog uwor bo, “Meda fael mele sa iye sengal?” ");
INSERT INTO uli_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Iwe ngo sibis ir resa tape kamemal ngo resa sor bo, “Rechoka ila resa belasel wine!” ");
INSERT INTO uli_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iwe ngo yesa sudah Pedrus mo apostel kowe seg mo semal. Pedrus yesa maliliy ngalir buwa we le ye paleng yalol le ye sor bo: “Hami Jew ka woccholuwamem mo pangmi rechoka ha mel woal Jerusalem, ha talengayey bo iy be kangalugmi fael meka sa iye sengal. ");
INSERT INTO uli_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Rechoka ila rete belas, we hami ha sor; igla ila moch duwow kolok lemaliyel. ");
INSERT INTO uli_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Iye molwe profeta Joel ye kapta kofal we ye sor bo: ");
INSERT INTO uli_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Iye mele ibe foru lal ral kala hartal ral, yalol Deus yal sor: Ibe fangdiy Espritu Santus le yusuwey uwor pangerloh yarmat. Mal mo fefel kala lomi re bele foloyu mele yaloy; tarmal kala lomi re bele wiri meka yebe weldoh iwe ngo malelap re bele ddal. ");
INSERT INTO uli_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ngo, boy ka layi mwo, le mal mo fefel ngo ibe fangdiy Espritu Santus le yusuwey uwor irel yodla, ngo re bele foloyu mele yaloy. ");
INSERT INTO uli_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ibele ffaor kkemal mo hagil mo lal laeng mo wol talop. Ngo bele llah ccha mo yaef, mo burah le yebe wochog darmiy kelay ye masosol. ");
INSERT INTO uli_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bele gul loh yaal ngo ye chechaloh metal meram le bele ddolol ccha, mo imol mala yebe hola mala Bungul Samol le ye falmay. ");
INSERT INTO uli_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iwe ngo te tugul semal le be ffesang Samol bo yebe tipngi ngo yebe molow.’ ");
INSERT INTO uli_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ha taelenga hapatpat ka re Israel! Jesusel Nazareth ila iy semal mal we Deus yesa hatosiya ngalugmi mala kkelal mo irel kkemal mo hagil kowe Deus yesa foru irel. Hami hasa spegil gola mele bo ye weldoh meka mo luwulumi. ");
INSERT INTO uli_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ye dabey chog luluwal la yael Deus le yesa faesul hatugulu le be yoh ngalugmi Jesus; iwe ngo hami hasa lliy irel yami fangloh iy bo rechokla re toa hamolfid rebe krudu. ");
INSERT INTO uli_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngo Deus yesa hamolowa tefalidah mo irel maes, yesa taldi mo irel mala kkelel maes bo fael mala towe yoh le maes yebe hammachu. ");
INSERT INTO uli_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Bo David ye sor irel bo, ‘Iwiri Samol le ye mel imoy pangal yadol ngo ye mel chog rela gilemra irey ila tor mele ibe merah iyang. ");
INSERT INTO uli_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ila yesa rraey lal depey, ngo ye cchehas yai hapatpat, ");
INSERT INTO uli_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","bo ila mwo ngang semal re talop ngo sa luglug lal depey. Bo gel ho towe tahcheyey diy lal faileng le liliyer chomes; hare ho ligdadiy boy le lom bo yebe mongoangowloh lal lib. ");
INSERT INTO uli_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Hosa kkewar ngalyey yalepal molow; ngo hobe harraeyiyey irel yam mel irey.’ ");
INSERT INTO uli_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Rewol bisiy, ibe hawwele yai hapatpat ngalugmi irel kofal King David we yach chapdoh, we ye ffos idal. Ye mes resa leba, iwe ngo chil mel mele peyal irech igla. ");
INSERT INTO uli_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iy semal profeta ngo ye gola mala Deus ye hatugulu ngali: Deus ye hatugulu le yebe hasi semal mo irel chol daowe yael David bo be mel bo king le yebe wochog David. ");
INSERT INTO uli_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David ye gola molwe Deus yebe foru, ngo yesa kapta kofal yal be molow tefael Kristus mo irel maes irel molwe ye sor bo, ‘Yete meldiy lobola liliyer chomes; ngo yete meldiy mala porgol lal lib.’ ");
INSERT INTO uli_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Deus yesa hamolowa tefaeli iy Jesus le mo irel maes, iwe ngo hamem ha wiri ngal metmem le yesa molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Deus le Temal, yesa hatagitadah Jesus bo bela mel rela gilemra mo irel. Ngo Deus yesa fang ngali Espritu Santus, we yesa faesul hatugulu bo yebe fang. Mele hami hasa wiri, ngo ha rongrong igla ila yal kkefang le sa fangdiy irech. ");
INSERT INTO uli_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bo te David mele ye bidah wol laeng; David ye spegil sor bo, ‘Samol ye kangalu yai Samol: Marro mo rele gilemra irey ");
INSERT INTO uli_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","yee, la hola yodla iy be yitlir rechoka re tayikof ngalug bo rebe mel bo liliyel pechem.’ ");
INSERT INTO uli_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Panger re Israel ngo rebe gola le ye tugul le Jesus we hami ha krudu ila iy yeramtawe Deus yesa foru bo iy Samol ngo iy Kristus!” ");
INSERT INTO uli_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Yodwe yarmat re rongrong mele ngo resa motog, iwe ngo resa kasiya Pedrus mo apostel kowe tot bo, “Ila ngo meda mele hamem habe foru?” ");
INSERT INTO uli_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedrus yesa kangalur bo, “Habe harrig dipmi irel mekla molfidmi ngo hasa baptismus irel mala idel Jesus Kristus, bo ila ngo be chuy fael molfidmi; ila ngo be yoh ngalugmi Espritu Santus la yael Deus kkefang. ");
INSERT INTO uli_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bo ila mala Deus ye hatugulu ngalugmi mo mekla lomi mo panger rechokla re ddawloh — panger rechokla Samol le yach Deus yesa ffesangurdoh irel.” ");
INSERT INTO uli_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedrus yesa hakkela yal hapatpat ngalir ngo ye wol cholop mekla ye kangalur, ngo sa sor bo, “Ha hataldagugmi mo irel hagerger le bele budoh le yar rechoka re tayikof!” ");
INSERT INTO uli_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ye cholop ir le sa tugul lal deper irel foloy we yael Pedrus iwe resa rol baptismus; rallawe chog ngo malbo be solngrras le re chilar chotugul kowe. ");
INSERT INTO uli_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Resa itol deper irel yar kkay yalol foloy kowe yar apostel kowe mo yar hammal fengal mo yar daber irel mepel mo mongol fehaf we. ");
INSERT INTO uli_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ye cholop hagil mo kkemal kala apostel kowe re foru le panger yarmat ngo re lluwdah iyang. ");
INSERT INTO uli_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Panger chotugul kowe ngo re tetaboloh chog yar hammal fengal ngo re rol teptap fengal irel mekla hapitgir. ");
INSERT INTO uli_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rema tap chuway mekla bugter mo liter, ngo resa hamhela mekla salpiyal uwor panger, le semal ngo ye hasi fechel mala yebe tapeli irel mekla ye hafohoy iyang. ");
INSERT INTO uli_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pangal ral ngo rema rol ttey fengal mo lal Templum we, iwe ngo re wol ma ttey fengal mo lal mekla imwer resa rol mongoy luwul yal fel mo yal cchehas lal deper. ");
INSERT INTO uli_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rema kapingpinga Deus ngo ye momay lal deper irel yar yarmat momay ngalir. Pangal ral ngo Samol ye fefang chiler le rechokla resa daor. ");
INSERT INTO uli_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Seral irel suluw kolok lepelalyol, irel yodwe yodol mapel, ngo Pedrus mo John resa loh irel Templum we. ");
INSERT INTO uli_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ye mel semal mal irel loboswe rema sor bo Hatam Kamdidiy, le yela subdoh chog ngo ye mes mekla pechel. Pangal ral ngo yarmat rema hasiloh metal hatam le bo yebe dodongor salpiy mo irer rechoka rema bulong lal Templum we. ");
INSERT INTO uli_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yodwe ye wiri chog Pedrus mo John yar bubulong lal Templum we ngo yesa hafael pecher bo rebe fang ngali salpiy. ");
INSERT INTO uli_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Resa kalngali ngo Pedrus yesa kangalu bo, “Kalngalugmem!” ");
INSERT INTO uli_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iwe ngo mal we yesa kalngalir, bo ye kacchog hare yor mele rebe fang ngali. ");
INSERT INTO uli_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedrus yesa kangalu bo, “Tor layi salpiy. Iwe ngo ibele fang ngalug mala sa yoh ngalyey: Fael mala idel Jesus Kristusel Nazareth, ngo ibe kangalug bo sudah hosa darloh!” ");
INSERT INTO uli_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yesa holu rel paol rewe gilemra yesa tipingidah. Irel yodwe chog ngo yesa kkel loh mokwe pechel; ");
INSERT INTO uli_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yesa lutdah sa susu fedal, iwe ngo sa chap yal dedar fedal. Iwe yesa daber long lal Templum we le ye dedarloh ngo ye llulut ngo ye kapingpinga Deus. ");
INSERT INTO uli_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Rechokwe re mel yilim re wiri yal dedarloh mo yal kapingpinga Deus, ");
INSERT INTO uli_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ngo yodwe yela gel ngalir le iy mael hafohoy we yema maroro ngachel Hatam Kamdidiy we iy molwe ngo panger ngo resa lluwdah irel. ");
INSERT INTO uli_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yodwe mal we yesa dabey fedaley Pedrus mo John mo fael branda we rema sor bo yael Branda we yael Solomon, ngo yarmat resa lluwdah resa hamed ngalir. ");
INSERT INTO uli_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Yodwe Pedrus ye wirir rechokwe ngo yesa kasiyar bo, “Re Israel, meda mele hala lluwdah irel mele iyang, ngo meda mele ha sala ffad ngalugmem chog iyang? Hasa sor le yamem chog kkemal, hare yamem santus mele yela mmal le ha foru bo yeramtale be darloh iyang? ");
INSERT INTO uli_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Deus we yael Abraham, mo Isaac, mo Jacob, Deus we yael chapdoh kowe yach mele yesa fang ssarol Jesus we yal Boy. Iwe ngo hami ha fangloh iy ngo ha ttahcheloh mo fael metal Pilatus, ila mwo Pilatus ye sor bo yebe taldi. ");
INSERT INTO uli_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iy semal yarmat le ye momay ngo ye santus, iwe ngo hami ha tahcheloh, ha far hasi hasa dangro Pilatus bo yebe telad ngalugmi mael fefedeg we. ");
INSERT INTO uli_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hasa limeseloh yeramtala yema fang molow, ngo hala chog ila Deus yesa hamolowa mo irel maes — ngo hamem mele tugul irel mele. ");
INSERT INTO uli_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kkamelal mala idal mele yesa fang kkelel mal le ye mes meka pechel. Mele hami hasa wiri ngo hasa gola, ila ye yoh mo irel tugulul ladep irel mala idal; Yal tugulul ladep irel Jesus mele sa hachuya yal tomay, iye pangmi ngo hasa wiri. ");
INSERT INTO uli_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Iwe ngo igla rewol bisiy ila isa gola le molwe hami mo tamol ka yami ha foru ngal Jesus Kristus, ila ha foru luwul yami temedaf. ");
INSERT INTO uli_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Deus ye faesul kapta muswe mo irer panger profeta kowe le Kristus ila yebe hafohoy luwul bareg, iwe ngo igla ila yesa ppalu ngali molwe ye sor. ");
INSERT INTO uli_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ha harrigi dipmi irel mekla molfidmi ngo hasa tagul ngal Deus, bo yebe hachuya fael yami molfid. Hare habe foru mele, ");
INSERT INTO uli_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ila ngo ha bele kkel tefael irel haradiya la be budoh mo irel Samol, iwe ngo Deus yebe fang ngalugmi Jesus le iy Kristus le yesa faesul duwley bo yaglugmi. ");
INSERT INTO uli_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iy ila yebe mel chog wol laeng yee, la hola yodla pangal formel ngo bele tefoy tefael. Deus ye faesul sor chog mele muswe le profeta kowe re santus mele re kapta loh. ");
INSERT INTO uli_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bo iwe Moses ye sor, ‘Samol le yami Deus ye bele fang ngalugmi semal profeta le be wochog yal fangdoh ngang: semal le yebe budoh chog mo luwulumi. Hami habe talenga pangal mekla ye kangalugmi habe foru. ");
INSERT INTO uli_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Semal le yebe te taelenga mekla profeta la ye sor ngo rebe hayyagi tangir meka lol Deus, bo rebe limeseloh.’ ");
INSERT INTO uli_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Iwe ngo profeta kowe, Samuel mo ikowe re miridoh ngo re faesul kapta meka sa weweldoh fael mwoka. ");
INSERT INTO uli_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Meka ila Deus ye hatuguludoh chog mo irer profeta kowe lol le fal ngalugmi, iwe ngo ha mel irel Bogtag we Deus ye fang ngalir chapdoh kowe yami. Iye molwe ye kangalu Abraham bo, ‘Irel daola yam mele ibele holbuwar panger yarmetal talop le iyang.’ ");
INSERT INTO uli_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Iwe Deus yesa duwley Boy la lol ngo hami mele ye moal fangwey iremi, yebe holbuwahmi pangmiloh bo habe tagul tang wegdeg kala yami le ye tayikof.” ");
INSERT INTO uli_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedrus mo John re chil kapatpat ngalir yarmat ngo sibis temarong kowe, mo molwe tamol posel Templum we, mo sibis Sadducees kowe resa dohdoh. ");
INSERT INTO uli_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Resa rol ssong bo apostel we rumal resa fofoloyu ngalir yarmat le Jesus ye molow tefael mo irel maes, ngo hare be ila sengal ngo ye bele llahloh le ye katos le chomes rebe molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Iwe resa ddorfir resa yitilir long lal kalbus yee, la ralawe seral bo yodwe ngo sa bong. ");
INSERT INTO uli_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ngo ye cholop rechokwe re rongrong foloy kowe yar le resa chepar ngo yesa tugul lal deper; iwe ngo leper mal kala resa chepar irel yodle ila bele limngeras. ");
INSERT INTO uli_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yela ralawe seral ngo mal kowe yar Jews, mo tamol kowe yar mo mokwe sensel Hatobtob we resa ttey fengal mo wol Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Resa ttey ngal Annas we iy mele Llulupal Temarong, iwe mo Caiaphas, mo John mo Alexander, mo ikowe sibis we chol haleng we yal Llulupal Temarong we. ");
INSERT INTO uli_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Resa hasur apostel kowe mo imor ngo resa kasiyar bo, “Ifa sengal yami foru molwe? Yela budoh yami kkemal mo iya, ngo idel itey mele ha tapeli?” ");
INSERT INTO uli_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yesa bidiy Espritu Santus woal Pedrus iwe ngo Pedrus yesa sor bo, “Mal mo tamol: ");
INSERT INTO uli_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Hare ha kasiyahmem igla kofal molwe ye momay we ha foru ngal mal we ye mes pechel le hare meda mele ha foru ngo sala chuy yal tomay, ");
INSERT INTO uli_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ila ngo pangmi mo panger yarmetal Israel ngo ye momay le habe gola le mal le ye su imomi igla, ila ye chuyloh yal tomay irel kkamelal mala idel Jesus Kristus we semal re Nazareth. Ila yeramtawe hami ha krudu ngo Deus yesa hamolowa tefaelidah mo irel maes. ");
INSERT INTO uli_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesus molwe babior we ye santus yesor irel bo, ‘Feas la hami chol fatfetal dayif ha tolpagililoh, mele yela llahloh bo ye hartal palleng pelal mo imol pangal.’ ");
INSERT INTO uli_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yach molow ila ye mel chog irel; bo lal pangal loh ballel faileng le ngo tor semal mo solbos le Deus ye fang le be yoh le be hadoragich.” ");
INSERT INTO uli_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Re lluwdah chol ttey we irel molwe rela wiri lepal kkelel depel Pedrus mo John, iwe mo molwe rela gola le ir rorumal ngo chototol le tor yar skun. Iwe ngo resa moch gola le ir faesul choluwal Jesus. ");
INSERT INTO uli_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Iwe ngo tayor mele re chil gola le rebe sor bo resa wiri mal we yesa chuy yal tomay le ye su lengchel Pedrus mo John. ");
INSERT INTO uli_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Iwe resa kangalur bo rebe buyoy mo lal imwel Ttey we. Iwe sala rol ir loh chog chol Ttey we yar rol hapatpat. ");
INSERT INTO uli_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Resa rol kasiy fengal uwor bo, “Meda mele sibe faor ngalir mal ka? Panger yarmat wol Jerusalem ngo resa gola kkemal le rechoka resa foru, ngo towe yoh le gich sibe sor bo ir re kachapar. ");
INSERT INTO uli_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Hare sibe hapolahoy yal pallengloh mele ngalir yarmat, ila ngo sibele kangalur rechoka bo tayor fael sew le rebe chil maliliy ngalir yarmat fael mala Idel Jesus.” ");
INSERT INTO uli_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Iwe resa fesang tefaelirlong rechokwe ngo resa kangalur bo, tayor fael sew le rebe chil kapta kofal Jesus hare re foloy fael Idel Jesus. ");
INSERT INTO uli_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ngo Pedrus mo John resa hatefali ngalir le resa sor bo, “Hami mele habe hatugulu sew le ye fel mo fael metal Deus — hamem habe talenga yalomi, hare habe talenga yalol Deus. ");
INSERT INTO uli_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bo towe yoh le hamem habe ppoloh mo irel yamem kapta meka hasa spegil wiri ngo ha rongrong.” ");
INSERT INTO uli_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Iwe chol Ttey we resa tefael ngali mokwe resa moal kangalur le sa kkel yar hapatpat, iwe ngo resa moch tahcher. Resa gola le towe yoh le rebe hagrer, bo pangal yarmat ngo resa kapingpinga Deus irel mokwe sa weldoh. ");
INSERT INTO uli_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mal we re foru kkemal we uwol sala chuy yal tomay ila sa ligdi fayeg lepal ragel. ");
INSERT INTO uli_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Yodwe chog ye tal Pedrus mo John ngo resa tefael loh irer mokwe choluwar re sala kangalur mokwe tamol temarong kowe mo mal kowe yar resa sor. ");
INSERT INTO uli_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Molwe chotugul kowe re rongrong mele ngo resa ttey fengal ngo resa mepel ngal Deus: “Tamem le ho foru laeng mo talop, mo taed mo pangal meka ye mel iyang! ");
INSERT INTO uli_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Irel Espritu Santus mele ho kangal chapdoh we yamem, David, we yam boy, molwe ye sor bo, ‘Meda mele yarmetal Gentiles resa song iyang; meda mele yarmat resa foru mekad kala yar le tor pelal iyang? ");
INSERT INTO uli_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kingel talop le resa hafler, ngo resa ppil fengal tamol bo rebe fedeg ngal Samol mo Kristus la yusuwal.’ ");
INSERT INTO uli_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bo tos le Yerodes mo Pontius Pilatus re ppil fengal mo woal haplom le, le ir fengal mo Gentiles mo yarmetal Israel bo rebe lliy boy we lom we hosa foru bo Kristus. ");
INSERT INTO uli_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Resa ttey fengal luwul mala kkamelam mo mala depom bo rebe foru pangal mokwe, hosa faesul hatugulu bo yebe weldoh. ");
INSERT INTO uli_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iwe ngo igla ho Samol, talenga meka resa sor bo re bele foru ngalugmem, tupngugmem ho Samol bo yebe kkel depmem bo habe foloyu meka yalom. ");
INSERT INTO uli_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kawraloh mala kkelem, irel mala idel Boy la lom, Jesus, le ye Santus.” ");
INSERT INTO uli_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yodwe rela moll mo irel mepel ngo yesa falmor lobowe re ttey iyang. Yesa bidiy Espritu Santus uwor panger ngo sa chap yar kapta fedaley molwe yalol Deus, le sa kkel deper. ");
INSERT INTO uli_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sa sew chog yar chotugul kowe luluwal mo lal deper. Tor semal le ye sor bo hapitgil ila pitgil chog iy lufulyal, bo rema rol hammal fengal irel pangal mekla yor irer. ");
INSERT INTO uli_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Iwe ngo luwul mala kkeler ngo apostel kowe resa hatosiya yael Samol Jesus molow tefael mo irel maes, ngo Deus yesa fangdiy yolbuw uwor panger. ");
INSERT INTO uli_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tor semal mo luwulur le ye hafohoy. Rechokwe yor bugter hare imwer ngo resa tap chuway, resa hasidoh salpiy we ye yoh doh mo iyang, ");
INSERT INTO uli_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","resa ngaler apostel kowe; iwe ngo resa hamhela salpiy we uwol semal mo semal ir, le semal ngo re ngaley lepal mele be tapeli irel mekla ye hafohoy iyang. ");
INSERT INTO uli_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ila sengal Joseph, we semal Levite, ngo yesub mo woal Cyprus, ngo apostel kowe rema ffesangu bo Barnabas (fael mele ila “Yeramtala Yema Hakkela Ladep”), ");
INSERT INTO uli_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","bo ye tap chuway mala bugtal sa hasidoh salpiy we ye yoh doh mo iyang sa ngaler apostel kowe. ");
INSERT INTO uli_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iwe ngo semal mal le Ananias idal mo molwe ril we Sapphira, re tap chuway mala bugter. ");
INSERT INTO uli_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Iwe ngo resa kapta fengali mo molwe ril, bo Ananias yebe hasi tot mo irel salpiy we bo lol, iwe ngo sa hasi iwe ye mel diy sa ngaler apostel kowe. ");
INSERT INTO uli_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedrus yesa kangalu bo, “Ananias, meda chog mele ye foru ngo ho sala yoh long lal mala yalol Satan iyang, le hosa kachepra Espritu Santus irel yam holu tefaeli tot mo irel salpiy we ye yoh ngalug mo irel bugat we ho tap chuway? ");
INSERT INTO uli_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Imol molwe hobe tap chuway bugat we ngo ye faesul mel la bugtam; iwe ngo yela wol miril yam tap chuway ngo mala salpiyal ila lom. Meda mele hola luluwaley hobe foru tappel mala ila sengal iyang? Hote kacheprar yarmat — bo hosa kachepra Deus!” ");
INSERT INTO uli_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yodwe Ananias ye rongrong chog mele ngo ye pungdiy chog sa mes; ngo panger rechokwe re rongrong kofael mele ngo resa motog. ");
INSERT INTO uli_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Resa bulong sibis tarmal resa dugmi molwe holongol resa hasiwey re sala leba. ");
INSERT INTO uli_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Be suluw awa mo wol miril ngo sa bulong fefel we ril le ye togla molwe sa wel. ");
INSERT INTO uli_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedrus sa kasiya bo, “Kangaluyey, iye lepal pangal salpiy we ye yoh ngalugmi mo molwe rim mo irel molwe bugtami?” Fefel we sa sor bo, “Ngoa, ila lepal pangal salpiy we ye yoh doh.” ");
INSERT INTO uli_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Iwe Pedrus sa kangalu bo, “Meda fal le gel mo molwe rim ha luluwaley le habe hagla Espritu Santus iyang? Tarmal kowe rela leba molwe rim iyer kala resa mel lengchel hatam la igla, le re bele bulong rebe hasug!” ");
INSERT INTO uli_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yodwe chog ngo sa ppungdiy fefel we mo lengchel mokwe pechel Pedrus sa mes. Resa bulong tarmal kowe re sala wiri fefel we le sa mes, iwe resa hasiwey re sala leba lengchel molwe ril. ");
INSERT INTO uli_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Panger loh chotugul kowe mo panger rechokwe re rongrong kofal mele ngo sa kkel yar motog. ");
INSERT INTO uli_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ye cholop hagil mo kkemal ka apostel kowe re foru mo luwulur yarmat. Panger chotugul kowe ngo rema toa ttey fengal mo fael Branda we yael Solomon. ");
INSERT INTO uli_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tor semal rechokwe te chiler le ye yoh le ye daber, ila mwo ngo yarmat resa kapingpingar loh chog. ");
INSERT INTO uli_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Iwe ngo yesa chocholop loh chog choluwar — le mal mo fefel ka yesa tugul lal deper irel Samol. ");
INSERT INTO uli_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ila fal le yarmat resa ropropwey chotomay lal yalap. Resa hoalor woal bet mo lal chob bo hare mala mwo llurul Pedrus, ngo yebe bidah uwor tot ir le hare be darloh mo lengcher. ");
INSERT INTO uli_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Iwe ngo resa wumagdah yarmat mo irel haplom kowe lengchel Jerusalem, resa hachewardoh chotomay, mo rechoka yor moniyan uwor; panger ngo ye chuyloh yar tomay. ");
INSERT INTO uli_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Iwe ngo Llulupal Temarong we mo mokwe choluwal we chol rewe Sadducees, ila ye kkel yar rol ngol irer apostel kowe. Iwe resa luluwaley rebe faor ngalir sew formel. ");
INSERT INTO uli_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Resa ddorfir apostel kowe resa yitilir long lal kalbus. ");
INSERT INTO uli_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yela lefhaf diy ngo semal angelus kowe lol Samol sa sugu hatmal kalbus we sa palirwey apostel kowe mo iyang, iwe ngo sa kangalur bo, ");
INSERT INTO uli_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Hala su lal Templum we ngo hasa kangalur yarmat pangal mekla kofal molow le ye tefoy.” ");
INSERT INTO uli_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Apostel kowe re taelenga molwe angelus we ye sor. Molwe ye chil lemaguyog chog ngo resa rolong lal Templum we ngo resa chapiy yar foloy. Llulupal Temarong we mo mokwe choluwal resa fesangurdoh panger mal kowe yar Jews irel Ttey we yar we ye palleng; iwe ngo resa fangloh yalor kalbus bo rebe hasirdoh apostel kowe irer. ");
INSERT INTO uli_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Rela loh tamol pos kowe irel kalbus we ngo re tamel apostel kowe, iwe resa tefael loh irel Ttey we re sala sor bo, ");
INSERT INTO uli_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hala loh irel kalbus we ngo ye lok hatam ngo pos kowe re chil posaloh chog; iwe ngo hala sugaloh hatam kowe ngo tor yarmat yilim!” ");
INSERT INTO uli_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tamol temarong kowe mo molwe tamol posol Templum we rela rongrong mele, ngo resa hammeha hare iya mele resa loh apostel kowe iyang. ");
INSERT INTO uli_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iwe ngo sa bulong semal mal ngo sa kangalur bo, “Mal kowe ha yitilir long lal kalbus, ila re mel igla lal Templum we le re fofoloyur yarmat!” ");
INSERT INTO uli_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Iwe tamol pos we mo saldaw kowe lol resa loh re sala hasirdoh apostel kawe. Rete ddingir bo re motog bo yarmat rede hacchifir. ");
INSERT INTO uli_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Resa hasir long apostel kowe re sala hasur mo imor chol Ttey we ngo Llulupal Temarong we yesa kangalur bo, ");
INSERT INTO uli_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hasa hatobtob mmay ngalugmi bo ha towe foloy fael Idel Jesus. Kemahoy meka hasa foru! Hasa hapallingiloh yami foloy woal Jerusalem, ngo hasa foru le yebe llah le hamem mele ha sor bo yebe mes Jesus!” ");
INSERT INTO uli_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedrus mo apostel kowe tot resa hatefali ngo resa sor bo, “Deus mele habe taelenga yalol, te yarmat. ");
INSERT INTO uli_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Deus we yar chapdoh kowe yach mele ye hamolowa Jesus mo irel maes, mo wol miril yami limeseloh we ha chifilidah wol krud. ");
INSERT INTO uli_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Deus ye hamolowa tefali Jesus mo irel maes yesa hasi ye sala yitili rela gilemra irel. Jesus mele Tamol ngo Demer le yebe fang ngalir yarmetael Israel molower bo rebe harrig deper bo yebe chuy fael yar molfid. ");
INSERT INTO uli_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Hamem mele tugulul meka — le hamem iwe mo Espritu Santus we yael Deus kkefang ngalir rechoka re talenga yalol.” ");
INSERT INTO uli_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Molwe chol Ttey we rela rongrong mele ngo tay mmal yar ssong, ngo resa dipli le re bele fangloh apostel kowe bo rebe limeserloh. ");
INSERT INTO uli_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Iwe ngo semal ir Pharisees kowe le Gamaliel mala idal; le iy semal mokwe sensel Hatobtob we ngo ye ssor mo irer panger yarmat, yesa sudah mo luwulur chol Ttey we. Iwe yesa sor bo rebe hachuyar mwo Apostel kowe mo irel Ttey we, ");
INSERT INTO uli_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","iwe ngo yesa kangalur chol Ttey we bo, “Re Israel, ha luluwaley hamayu mekla hasa sor bo habe faor ngalir mal ka. ");
INSERT INTO uli_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ha chil gola Theudas we ye budoh mwo fael sew yad, we ye sor bo iy semal yarmat le ye tagiyet, iwe ngo be fabguy mal we re dabey bo chilal. Yodwe re limeseloh ngo panger mokwe chilal ngo re medarloh, iwe ngo ye moloh iy rel ttey we yal. ");
INSERT INTO uli_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wol miril mele ngo yesa budoh Judas we semal yarmetal Galilee irel yodwe re ppapa yarmat iyang. Ye cholop le ye dabey ngo yodwe yarmat rela limeseloh, ngo pangerloh mokwe choluwal ngo re wol medarloh. ");
INSERT INTO uli_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ngo iye sa budoh igla ila iy bele kangalugmi bo tor mele habe faor ngalir rechoka. Ha ligdir! Hare mekla re luluwaley rebe foru ila ye budoh mo irel yarmat, ila ngo yebe wol moloh. ");
INSERT INTO uli_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ngo hare ye budoh mo irel Deus, ila ngo towe yoh le habe hapolahor. Hare habe foru mele, ila ngo ha bele happaliyel ngal Deus!” Chol Ttey we re talenga molwe Gamaliel ye kangalur. ");
INSERT INTO uli_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Resa fesangur long apostel kowe, resa wwodur. Iwe ngo resa kangalur bo tayor fael sew le rebe chil foloy fael mala Idel Jesus. Iwe ngo resa moch tahcher. ");
INSERT INTO uli_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yodwe resa chuy apostel kowe mo irel Ttey we ngo resa rraey, bo Deus yesa foru yebe yor mmaler le rebe hafohoy luwul bbareg bo fael mala idel Jesus. ");
INSERT INTO uli_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Iwe sa pangal ral ngo resa ma foloyu Hapatpat Momay we mo lal Templum we mo lal imwer yarmat, la iye Hapatpat Momay we kofal Jesus le iy Kristus. ");
INSERT INTO uli_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yela wol miril yodwe resa cholop loh tot chotugul kowe ngo yesa chaep yar hachocho fengal Jews kowe rema yalol Greek mo ikowe re faesul ir Jews. Jews kowe rema yalol Greek resa sor bo mokwe fefel faluyer we sa mes rir, ila re tayma pangir irel yar ma pawon salpiy seral mo seral. ");
INSERT INTO uli_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iwe Apostel kowe seg mo rumal resa hateyilir pangerloh mokwe choluwar ngo resa kangalur bo, “Ye tafel le habe tahcheloh yamem foloyu mele yalol Deus bo hare habe hammale mwo yengangel salpiy. ");
INSERT INTO uli_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ila rewol bismem, ha duwley fismol mal mo luwulumi le rechokla ha gola le ye mel Espritu Santus uwor ngo re repiy, bo sibe yitlir bo ir mele rebe salepa igegel mele. ");
INSERT INTO uli_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ila ngo hamem ha bele itol chog depmem irel mepel mo foloy.” ");
INSERT INTO uli_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pangerloh chol ttey we ngo ye fel deper irel molwe Apostel kowe re sor, iwe resa duwley Stephen, le iy semal mal le ye mel Espritu Santus uwol ngo ye kkel yal tugul, iwe mo Philip, mo Prochorus, mo Nicanor, mo Timon, mo Parmenos, mo Nicolaus we semal Gentile le ye budoh mo wol Antioch le iy ye moch weg ngal taliw we yar Jews. ");
INSERT INTO uli_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chotugul kowe resa hasirdoh irel Apostel kowe; iwe ngo Apostel kowe resa yetedah payur uwor rechokwe ngo resa mapel. ");
INSERT INTO uli_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Iwe, sa chocholoploh chog le yesa tugul lal depal irel mala yalol Deus. Sa choloploh chotugul wol Jerusalem, iwe ngo sa wol cholop temarong kowe le resa weg ngal tugul le. ");
INSERT INTO uli_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen ila semal mal le Deus ye holbuwa ye sala kkemal. Ye cholop kkemal kala ye foru luwulur yarmat. ");
INSERT INTO uli_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Iwe sibis yarmetal imwel ttey we yar Freedmen (we ila mele idal we rema sor) resa hapaliyel ngali. Yor Jews irel tteyle le re budoh mo woal Cyrene mo Alexandria. Ir mo wol sibis Jews kowe le re budoh mo woal mokwe faluyel Cilicia mo Asia, mele sa chap yar hachocho ngal Stephen. ");
INSERT INTO uli_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ngo Espritu Santus ye fang repiyel Stephen le ye bela sor sew ngo tor mele rema paliyal ngali. ");
INSERT INTO uli_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Iwe resa fang salpiy ngalir sibis yarmat bo rebe kachapar le rebe sor bo, “Ha rongrong yael yeramtale hapatpat tayikofloh irel Moses mo Deus!” ");
INSERT INTO uli_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iye sengal mele re foru sala yoh le re hassongar yarmat mo mal kowe yar mo mokwe sensel Hatobtob we. Resa ddorfi Stephen resa hasiloh imol chol Ttey we. ");
INSERT INTO uli_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Iwe ngo resa hasir long sibis mal bo rebe tungu kaptal. Resa sor bo, “Mal le ila yema toa hapatpat tayikofloh irel Templum le ye santus, mo Hatobtob we yael Moses. ");
INSERT INTO uli_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ha rongrong yal sor bo Jesusel Nazareth yebe hamderadiy Templum le, ngo yebe liwili meka faesul kkoch we ye budoh mo irel Moses!” ");
INSERT INTO uli_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Panger rechokwe re marro irel Ttey we ngo resa haffeda chog Stephen, bo resa wiri wol molwe metal le sa wochog wol metal semal angelus. ");
INSERT INTO uli_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Llulupal Temarong we yesa kasiya Stephen bo, “Tos mele?” ");
INSERT INTO uli_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen yesa sor bo, “Rewol bisiy mo re wotemay, ha talengayey! Imol yodwe chapdoh we yach, Abraham, ye chuy bela mel wol Haran, ngo Deus we ye mel luwul falmay yesa llah ngali mo wol Mesopotamia ");
INSERT INTO uli_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ngo yesa kangalu bo, ‘Ligdir meka re bugtam mo mele faliyem, ngo hosa loh wol sew fuluy le ibele kkewar ngalug.’ ");
INSERT INTO uli_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Iwe ngo yesa chuy mo wol molwe faluyal sa loh sala mel wol Haran. Yela wol miril yal mes molwe temal Abraham, ngo Deus yesa kangalu bo yebe chuydoh wol fulu le hami hasa mel iyang igla. ");
INSERT INTO uli_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Deus ye tefang bugtal Abraham mo irel fulu le, sugfed mwo mo iyang ngo yete fang ngali. Ngo halachog ila Deus ye hatugulu ngali le yebe fang bo bugter mo chol daola yal. Yodla Deus ye foru promise le ngo ted yor lol Abraham. ");
INSERT INTO uli_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iye mele Deus ye kangalu: ‘Chol daola yam ila re bela mel le wasola wol sew fuluy; re bela mel bo re hagloy ngo yarmat rebe tapey ssubu fedaler irel fabuguy raeg. ");
INSERT INTO uli_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Halachog ila iy be fang yar hagerger chol fulu la rechoka re yengang ngalir. Iwe ngo bela wol miril ngo re bele chuy mo wol fulu la ngo rebe budoh bo iga mele rebe hasrowuyey mo iyang.’ ");
INSERT INTO uli_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Iwe ngo Deus yesa fang ngali Abraham sew hagil bo hagilel bogtag we. Iwe Abraham yesa faor hagil le ngal Isaac wol miril molwe sa sew wiik yal sub; Isaac yesa faor hagil le ngal Jacob we lol, iwe ngo Jacob yesa faor hagil le ngal tarmal kowe lol we seg mo rumal. Ika rechokwe chapdageldah dao ka yach. ");
INSERT INTO uli_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Mokwe lol Jacob resa loltemay ngal Joseph we bisir, iwe resa tap chuway Joseph bo bela mel bo semal slave woal Egypt. Ngo Deus ye mel irel Joseph, ");
INSERT INTO uli_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","sala hadora mo luwul weres mo hafohoy kowe ye bulong iyang. Yodwe Joseph yela budoh fael metal molwe kingel Egypt, ngo Deus yesa hafle wegdegel Joseph ngo ye fang repiyal. Iwe king we yesa duwley Joseph bo yebe mel bo Tamol Aam wol fuluwe bo yebe kemahoy pangal mokwe lamliyel. ");
INSERT INTO uli_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Iwe ngo sa budoh sew laengda woal pangal loh ballel Egypt mo Canaan, ngo ye cholop le sa hafohoy. Tayor mongoy le ye yoh ngalir chapdoh kowe yach. ");
INSERT INTO uli_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Iwe ngo Jacob yela rongrong le yor grain woal Egypt, ngo yesa hafdalerloh tarmal kowe lol we ikla chapdoh kowe yach. Ngo bele moch ila mele metamol yar loh woal Egypt. ");
INSERT INTO uli_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yela harwowel yar loh ngo Joseph yesa hagolal ngalir mokwe wol bisil le iy Joseph we bisir. Ngo moch iye yodle molwe kingel Egypt bele gola kofal daowe yael Joseph. ");
INSERT INTO uli_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iwe ngo Joseph yesa dengagloh Jacob we temal bo iy mo chol haleng we yar we re fisig mo limal ngo rebe bidiy woal Egypt. ");
INSERT INTO uli_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jacob ye bidiy woal Egypt, le ila lobole ir mo mokwe lol rela mel iyang yee, rela mes. ");
INSERT INTO uli_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Panger ngo rela liblib wol Shechem irel pewe Abraham ye chuwayi ngal salpiy mo irel halengel Hamor. ");
INSERT INTO uli_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Yela harpa yodwe Deus ye bele foru promise we ye kangalu Abraham, ngo resa feraketaw chol daole yach woal Egypt. ");
INSERT INTO uli_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yela yodle ngo semal king le ye togla kofal Joseph mele yesa lamli Egypt. ");
INSERT INTO uli_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yesa mekadar chapdoh kowe yach, ngo ye taiykof ngalir, iwe ngo ye hakkela ngalir bo rebe yitlirwey yalwich manguchnguch kowe layur ligtam bo rebe mes. ");
INSERT INTO uli_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Irel yodle mele ye subdoh Moses iyang, le semal yalwich kkamdidiy. Suluw meram yar kekamale yalwich le mo irel molwe bugter, ");
INSERT INTO uli_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ngo la yodwe resa hachuya mo irel molwe bugter, ngo fefel we layur tamol ye sala hasi sa fama, sa hafholadah le sa wochog bo spegil lol. ");
INSERT INTO uli_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Resa haskuna ngali pangal mokwe repiyer yarmetael Egypt, sala mel bo semal mal le ye sellap irel hapatpat ngo ye momay wegdegel. ");
INSERT INTO uli_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Yodwe yela fayeg lepal ragel Moses ngo yesa dipli bo yebe gola hare ifa sengal yar re Egypt hagiyeg ngalir re Israel kowe chol faluyal. ");
INSERT INTO uli_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Sala wiri semal ir le semal yarmetael Egypt ye lilliy fedaley, sa loh bela tipingi sala limeseloh re Egypt we. ");
INSERT INTO uli_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Ye kachog hare mokwe chol faluyal rebe medaf le Deus ye bele ppili bo yebe taldir. Ngo ir re temedaf.) ");
INSERT INTO uli_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yela ralawe seral ngo yesa wirir rumal re Israel le re fefedeg, ngo yesa memel le yebe hamhelar bo rebe poss. Iwe yesa kangalur bo, ‘Hate kalladoh, hami chog re Israel; meda mele ha sala fefedeg iyang?’ ");
INSERT INTO uli_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Iwe ngo, iwe semal we ye lilliy re Israel we semal, yesa ddingaloh Moses ngo yesa sor bo, ‘Itey le yesa sor bo hobe tamolugmem ngo ho salepa mele habe mel iyang? ");
INSERT INTO uli_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ho luluwaley le hobe wol limeseyeyloh be wochog yam limeseloh yarmetal Egypt we lalow?’ ");
INSERT INTO uli_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yodwe Moses ye rongrong chog mele ngo yesa ddar mo woal Egypt sala mel woal molwe faluyel Midian. Ila lobola yela lolu rumal tarmal mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“La fayeg raeg mo wol miril ngo semal angelus sa llah ngal Moses mo irel sehay ire le ye mel luwul bbul mo lal sew tolmayloh mo lengechel tayit we Sinai. ");
INSERT INTO uli_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ye lluwdah Moses irel molwe ye wiri, iwe yesa dar ngali bo yebe kemaho hamwayu. Iwe ngo yesa rongrong yalol Samol le ye sor bo: ");
INSERT INTO uli_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ngang Deus we yar chapdoh kowe yam, Deus we yael Abraham, mo Isaac, mo Jacob.’ Yesa rer Moses irel yal motog le tay mechal kal ngal ire we. ");
INSERT INTO uli_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Samol sa kangalu bo, ‘Hachuya bwela kala yam, bo lobosla ho su iyang ila ye Santus. ");
INSERT INTO uli_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Isa wiri lepal yar hafohoy mekla layi woal Egypt. Isa rongrong yalol tang kala yar ngo isa bidiy bo ibe taldir. Budoh! Igla ila ibele fangloh gel woal Egypt.’ ");
INSERT INTO uli_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses molwe re Israel kowe re ddabeloh. Iy molwe re kasiya bo ‘Itey le ye sor bo hobe tamolugmem ngo ho salepa mele habe mel iyang?’ Iy molwe Deus ye fangloh bo yebe lamlir mokwe lol, ngo ye taldir irel molwe kkamelal angelus we ye llah ngali mo irel ire we ye bbulbul. ");
INSERT INTO uli_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Sa palirwey re Israel kowe mo woal Egypt. Yor kkemal kala ye foru mo woal Egypt, mo Red Sea, mo lal tolmayloh we re mel frdal iyang lal molwe fayeg raeg. ");
INSERT INTO uli_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Iye iy Moses we ye kangalur yarmetal Israel bo, ‘Deus ye bele fang ngalugmi semal profeta le be wochog yal fangdoh ngang iremi, iwe ngo yeramtala ila yebe budoh chog mo luwulumi yarmetal Israel.’ ");
INSERT INTO uli_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Iy Moses molwe ye mel irer yarmetal Israel kowe re ttey lal tolmayloh we. Ye mel irer chapdoh kowe yach, ngo ye wol mel irel angelus we ye maliliy mo wol Tayitel Sinai. Ngo iy mele ye yoh ngali molwe yalol Deus bo yebe hadayu ngalgich. ");
INSERT INTO uli_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Iwe ngo chapdoh kowe yach re temechal taelenga yalol; re ttagul tangi ngo re hable hare be chil yoh le rebe tefael loh woal Egypt. ");
INSERT INTO uli_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Iwe ngo resa kangalu Aaron bo, ‘Ffaor lomem taodeb bo rebe metahmem. Ha tay gola mele sa wel ngal yeramtale Moses, we ye hasugmemwey mo woal Egypt.’ ");
INSERT INTO uli_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iwe resa foru sew liyos we ye wochog semal karbow, ngo resa fang yar maligach ngali, iwe ngo resa gubulu molwe ir chog yar foru. ");
INSERT INTO uli_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Iwe Deus yesa tagul tangir sa ligdir bo rebe hasrowu fedaley fis kala lal laeng. Ila molwe ye teftaf lal babior we yar profeta kowe we ye sor bo: ‘Yarmetal Israel! Te ngang mele ha liliy mael bo yami maligach ngali, irel molwe fayeg raeg yami mel lal tolmayloh we. ");
INSERT INTO uli_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tento we imwel Taodeb we Molech we ha kekasi fedaley, mo molwe liyosol Rephan, mele hami ha kekasrowu. Ila ibele hachuyagmiloh le hami ha bele ddawloh tot mo imol Babylon.’ ");
INSERT INTO uli_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Chapdoh kowe yach iwe ye mel Tentol Bogtag we irer irel yodwe re mel lal tolmayloh we iyang. Re foru Tento we le re hadabey ngal molwe Deus ye kangalu Moses be foru ngali, le ye sangsengal molwe Moses ye wiri. ");
INSERT INTO uli_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yela wol miril loh ngo chapdoh kowe yach we re hasi tento we mo irer ikowe yar chapdoh. Re hasi tento le irel yodwe re dabey Joshua. Re hasi resa loh wol fuluy we re hasi tangir rechokwe faluyer we Deus yesa ddaberloh mo iyang. Resa mel chog iyang yee, la holadoh molwe mool David. ");
INSERT INTO uli_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David ila ye fel depel Deus irel, ngo ye dangro Deus bo hare be mmal le iy David yebe foru sew imw bo imwel iy Deus la yael Jacob. ");
INSERT INTO uli_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Iwe ngo moch Solomon mele ye fatleha sew imw bo imwel Deus. ");
INSERT INTO uli_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Iwe ngo Deus la ye hartal tagiyet tema mel lal imw ka foruyer yarmat; ila molwe profeta we yela sor iyang bo, ");
INSERT INTO uli_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Laeng mele liliyey chiya, yalol Samol yal sor, iwe ngo Talop mele liliyel pechey. Tappel imw kefa mele habe foru bo imwey? Ifa mele liliyey le ibe mel iyang? ");
INSERT INTO uli_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Te spegil Ngang mele iforu pangal iy meka?’” ");
INSERT INTO uli_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stephen sa taboloh ngo sa sor bo, “Ye kkef repimi! Ifa lepal yal ruchupung lal mekla dipmi, ngo ifa lepal yami tema talenga mekla yalol Deus! Ha rol igeglir chog chapdoh kowe yami; hami mwo ngo hate talenga yalol Espritu Santus! ");
INSERT INTO uli_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yor mwo semal profeta kowe le chapdoh kowe yami rete hafohoyu fedaley? Re limeserloh mokwe re kakal yalol Deus we re kapta kofal molwe re haforol yalol Deus we ye momay. Iwe ngo la igla ngo hasa yichingewa ngo ha limeseloh. ");
INSERT INTO uli_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hami mele angelus re fang ngalugmi hatobtob we yael Deus, iwe ngo hami hate talenga!” ");
INSERT INTO uli_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Irel yodwe chol Ttey we re tetalenga mokwe Stephen ye sosor ngo tay mmal yar ssong ngo resa hatangtingi mokwe ngir. ");
INSERT INTO uli_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Iwe ngo Stephen, luwul yal mel Espritu Santus uwol, ngo yesa kalledah wol laeng sala wiri falmay la yael Deus, ngo ye wiri Jesus le ye su rela gilemra irel Deus. ");
INSERT INTO uli_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Iwe ngo yesa sor bo, “Ha kalloh! Isa wiri laeng le yesa sugeg, ngo molwe Layur Retalop iyelay ye su rela gilemra irel Deus!” ");
INSERT INTO uli_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Chol Ttey we resa pilta mokwe talenger ngal payur ngo resa ttawul. Iwe ngo resa hamed ngali resa ddorfi, ");
INSERT INTO uli_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","resa hasi re sala ppedawey mo lugul haplom we re sala hacchifi mo iyang. Rechokwe re foru meka resa ligdiy mokwe mengagur irel semal tarmal bo yebe kemahoy. Idel iy tarmal la ila Saul. ");
INSERT INTO uli_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Re kekacchifi Stephen ngo iy yesa ffesangu Samol le ye sor bo, “Samol Jesus, hasi mele nguluy!” ");
INSERT INTO uli_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Sa hasubgudiy ngo sa tawulagililoh, “Samol! Ho towe itol riyal molfid le uwor rechoka!” Molwe ye sor chog mele ngo yesa mes. ");
INSERT INTO uli_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Iwe ngo ye fel depel Saul irel molwe resa limeseloh yeramtawe. Ralale chog ngo yesa chaep yar hafohoyur chotugul kowe woal Jerusalem. Panger chotugul kowe ngo resa medardar fedal, re sala meldiy chog apostel kowe. Chotugul kowe resa roloh woal mokwe faluyel Samaria mo Judea. ");
INSERT INTO uli_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Sibis chotugul kowe re sala leba Stephen le re tetangdi le ye palleng yalol yar tang. ");
INSERT INTO uli_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Iwe ngo Saul yesa luluwaley le yebe hamolaholoh Eklesia we. Yesa loh irel sew mo sew imw sala yururwey Kristiano mo iyang le mal mo fefel, iwe yesa ppedirlong lal kalbus. ");
INSERT INTO uli_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Chotugul kowe resa medardar fedal resa roloh wol pangal lobos re sala foloyu Ebangelium we. ");
INSERT INTO uli_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip yesa loh woal haplom we ye paleng mo wol Samaria sala foloyu kofal Kristus ngalir rechokwe re mel iyang. ");
INSERT INTO uli_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yarmat re talenga hamayu mokwe Philip ye foloyu. Re talenga ngo re wiri kkemal kowe ye foru. ");
INSERT INTO uli_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yesa chuchuy moniyan mo uwor yarmat le rema ttawul loh ngo resa chuy. Ngo ye cholop rechoka re mahatgut mo rechoka ye mes pecher le ye chuyloh yar tomay. ");
INSERT INTO uli_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sa kkel yar yarmat rraey wol haplom we. ");
INSERT INTO uli_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ye mel semal mal le Simon idal le ye mel wol haplom we le yarmetal Samaria kowe rema lluwdah irel faolus kala yal. Ye kangalur yarmat le iy semal yarmat le ye tagiyet. ");
INSERT INTO uli_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Iwe ngo panger yarmat wol haplom we le, chototol mo chotagiyet ngo re talenga yalol. Re sor bo, “Iye kkemal we yael Deus we rema sor bo, ‘Kkemal we ye Hartal Tagiyet.’” ");
INSERT INTO uli_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Re talenga yalol bo yagil mala sa ssulay yar ma lluwdah ngo re fodloh irel faolus kowe yal. ");
INSERT INTO uli_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ngo yela yodwe resa chepar ngal foloy kowe yael Philip, le ila Hapatpat Momay we kofal mala Lamliyel Deus mo kofal Jesus Kristus, ngo resa rol baptismus, le fengal mal mo fefel. ");
INSERT INTO uli_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon mwo ngo ye wol chepar. Yodwe yesa baptismus ngo yesa dabey fedaley chog Philip. Ngo ye lluwdah irel hagil mo kkemal kowe ye wiri we Philip ye foru. ");
INSERT INTO uli_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apostel kowe woal Jerusalem resa rongrong le yarmetal Samaria resa talenga molwe yalol Deus; iwe resa fangloh Pedrus mo John irer. ");
INSERT INTO uli_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Rela budoh wol Samaria resa mapelar chotugul kowe bo hare yebe yoh ngalir Espritu Santus. ");
INSERT INTO uli_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bo yodla ngo ye ted bidiy Espritu Santus uwor; re rol baptismus chog irel idel Samol Jesus. ");
INSERT INTO uli_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pedrus mo John resa yetedah payur uwor, iwe ngo yesa bidiy Espritu Santus uwor. ");
INSERT INTO uli_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon ye wiri yal bidiy Espritu Santus uwor chotugul kowe irel yodwe apostel kowe re yetedah payur uwor. Iwe yesa fang salpiy ngal Pedrus mo John, ");
INSERT INTO uli_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ngo yesa sor bo, “Ha fang ngalyey kkemal la, bo hare te tugul semal le ibe yetedah payi uwol ngo yebe bidiy Espritu Santus uwol.” ");
INSERT INTO uli_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedrus yesa kangalu bo, “Ha chuy fengal mo salpiy la lom hasa loh Infiyerno, bo hosa luluwaley le hobe chuwayi kkefang la yael Deus ngal salpiy! ");
INSERT INTO uli_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tor doh igegam hare kofam irel yengang ka yamem, bo lal mala depom ila ye tafel mo fael metal Deus. ");
INSERT INTO uli_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ligdi luluwal la yam le ye tayikof. Iwe ngo hosa mepel ngal Samol bo be ffaho depal ngalug irel mala hola luluwaley tappel mele iye sengal. ");
INSERT INTO uli_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bo isa wiri le ye kkel yam loltomay ngo ho tay tal mo luwul molfid.” ");
INSERT INTO uli_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon sa kangalu Pedrus mo John bo, “Fael pechemi ngo habe mapel ngal Samol bo yagilyey, bo hare tor sew meka hasa sor le be wel ngalyey.” ");
INSERT INTO uli_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wol miril yar hatosiya mo yar foloyu ngalir yarmat molwe yalol Samol, ngo Pedrus mo John resa tefael loh woal Jerusalem. Iwe ngo irel yar loloh ngo re fofoloyuloh Hapatpat Momay le wol sew mo sew mokwe haplomol Samaria. ");
INSERT INTO uli_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Semal angelus kowe lol Samol sa kangalu Philip bo, “Hafleh hobe loh Iyor irel yalap la ye bidiy mo Jerusalem sa loh Gaza.” (Yalap le ila re tay teptap igla ka.) ");
INSERT INTO uli_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Iwe Philip yesa hafle sa loh. Iwe ye mel semal mall Ethiopia le semal eunuch. Iy semal mal le ye tagiyet bo iy mele ye holu salpiy la lol mala Queenel Ethiopia. Yodle ngo mal le yesa tetefael ngal bugtal. Ye loh wol Jerusalem bela hasrowu Deus, ngo igla yesa tetefael loh lobugtal le ye dage kuruma la wal. Yodle ye meraraloh, ngo ye yewaw mo irel babior we yael profeta Isaiah. ");
INSERT INTO uli_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Espritu Santus yesa kangalu Philip bo, “Ho loh ho bela harepa kuruma lay.” ");
INSERT INTO uli_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Sa loh Philip sala rongrong yal yeramtawe yeyawli babior we yael profeta Isaiah. Iwe ngo sa kasiya bo, “Ho medaf irel mekla ho yeyawli?” ");
INSERT INTO uli_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tamol we yesa hatfaeli le ye sor bo, “Be ifa sengal ngo isa medaf le be tor le be hamdefa ngalyey?” Iwe sa kangalu Philip bo yebe chudah yuchul kuruma we. Iwe Philip yesa chudah sala marro lengchel. ");
INSERT INTO uli_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Iye pedal lobowe yeramtawe ye yeyawli mo yuchul kuruma we: “Ye wochog semal saaf le resa hasiloh bo re bela lliy. Ye wochog semal fadiyel saaf le te maliliy irel yodwe re guru loh mokwe yulal. Sepad mwo hapatpat ngo yete sor. ");
INSERT INTO uli_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Resa tapeli kamemal ngo tor mmalel le re fang ngali. Tor semal le be mmal le yebe sor kofal daola yal, bo sa yug molow la yal mo wol talop le.” ");
INSERT INTO uli_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tamol we yesa kasiya Philip bo, “Kangaluyey hare itey mele profeta le ye kekapta kofal? Kofal iy lufulyal hare kofal semal mo solbos?” ");
INSERT INTO uli_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Philip yesa chapiy yael hapatpat mo irel mokwe yeramtawe yesa yawli we ye mel lal babior we ye santus. Iwe ngo yesa kangaliy Hapatpat Momay we kofal Jesus. ");
INSERT INTO uli_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Yodwe re dedabeloh yalap we ngo re sala budoh solbos le yor chael iyang, iwe ngo tamol we sa kangalu Philip bo, “Sew chael iye. Ila ngo meda mele be piltayey mo irel yai be baptismus?” ");
INSERT INTO uli_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Iwe tamol we sa sor bo be ppoloh kuruma we, ngo iy mo Philip resa dediy lal chael we ngo Philip sa baptismusgili mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yodwe re bidah mo lal chael we ngo Espritu Santus yesa hasiloh Philip. Tamol we tay wiriloh, iwe sa taboloh yal loh le sa rraey lal depal. ");
INSERT INTO uli_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip yela gola chog ngo yesa mel wol Azotus; iwe yesa loh wol Caesarea, iwe ngo irel yal loloh ngo ye fofoloyuloh Hapatpat Momay we wol sew mo sew haplom. ");
INSERT INTO uli_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Irel yodle ngo Saul sa taboloh chog yal memeal le yebe lir mokwe redabeyel Samol. Yesa loh irel Llulupal Temarong we, ");
INSERT INTO uli_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","sala dongor yal babior le be fang kkelal lal imwel ttey kowe wol Damascus, bo hare yor rechokla re dedabey mokwe Yalol Samol, ngo be yoh le iy yebe ddorfir, le mal mo fefel, sa hasi tefaelirloh woal Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yodwe Saul yesa harpadoh haplom we Damascus, ngo ye tedap ngo sa bidiy sew werloh mo woal laeng sala wersagloh loboswe ye mel iyang. Saul yesa pungdiy wototol, ");
INSERT INTO uli_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ngo yesa rongrong yalol semal yarmat le ye kasiya bo, “Saul, Saul! Meda mele hosa kekafohoyuyey iyang?” ");
INSERT INTO uli_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul yesa kasiya bo, “Gel itey ho, Samol?” Yalol yarmat we ye maliliy sa sor bo, “Ngang Jesus we ho kekafohoyu. ");
INSERT INTO uli_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sudah hosa bulong wol haplom la, ila lobola re bele la moch kangalug mele hobe foru mo iyang.” ");
INSERT INTO uli_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mal kowe choluwal Saul resa poloh, re tay maliliy; re rongrong lliyalol yarmat ngo tor le re wiri. ");
INSERT INTO uli_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sa sudah Saul ngo yela kalloh, ngo ye tay wiri formel. Iwe resa holu paol resa palalong woal Damascus. ");
INSERT INTO uli_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Solral le tor mele ye wiri; ngo irel yodla ngo tor mele ye mongoy ngo tor mele ye yulmi chal. ");
INSERT INTO uli_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ye mel semal mokwe redabeyel Samol woal Damascus le Ananias mala idal. Samol ye lah ngali luwul yal ddal ngo yesa fesangu le ye sor bo, “Ananias!” Ananias sa sor bo, “Ngang iye ho, Samol.” ");
INSERT INTO uli_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Samol sa kangalu bo, “Hafleh ngo hosa loh irel imw we imwel Judas we ye mel wol ngachel yalap we rema sor bo Yalap Wwel, ho sala kasiy semal mall Tarsus le Saul mala idal. Igla ila ye memapel, ");
INSERT INTO uli_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ngo yesa wiri mo lal yal luluwal semal mal le Ananias idal le ye bulong sa yetedah paol uwol bo yebe wer tefaeli formel.” ");
INSERT INTO uli_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias sa sor bo, “Samol, ye cholop yarmat le resa kangaluyey kofal yeramtala, iwe mo kofael mokwe ye hartael tayikof we yesa faor ngalir chotugul kowe lom mo woal Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Iwe ngo yesa budoh wol Damascus le tamol temarong kowe resa fang kkelal bo yebe ddorfir panger rechoka re kekasrowug.” ");
INSERT INTO uli_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Samol sa kangalu bo, “Ho loh, bele ngang isa duwley bo yebe yengang ngalyey le bela hagolal ngalir Gentiles, mo king mo meka yarmetal Israel mele idey. ");
INSERT INTO uli_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ngang ibele spegil kkewar ngali pangal mekla yebe hafohoy iyang bo yagilyey.” ");
INSERT INTO uli_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iwe sa loh Ananias, sala bulong lal imw we ye mel Saul iyang, yesa yetedah paol uwol ngo sa sor bo, “Saul bisiy, Samol yesa hagloyuyeydoh le spegil iy Jesus we ye llah ngalug mo lal yalap we irel yodwe ho bubudoh iga. Yesa hafdaleyeydoh bo hare gel hobe wiri tefaeli formel, ngo ye bidiy Espritu Santus uwom.” ");
INSERT INTO uli_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yodwe chog ngo yesa mormorloh tot formel le ye wochog yulol yig mo irel mokwe metal Saul, ngo yesa mmal le ye wiri formel. Yesa sudah iwe resa baptismusgili; ");
INSERT INTO uli_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Yela mol mo irel mongoy ngo yesa wol kkel tefael. Saul ye mel irer chotugul kowe woal Damascus irel fedral. ");
INSERT INTO uli_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Yesa darwwel loh irel imwel ttey kowe yar sala foloyu le Jesus ila iy Lol Deus. ");
INSERT INTO uli_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Panger rechokwe re rongrong foloy kowe yal ngo re lluwdah irel ngo resa kasiy bo, “Te iy molwe yema limeserloh rechokwe rema hasrowu Jesus mo woal Jerusalem? Te fael yal budoh wol faliyey ila yebe ddorfir tapper rechokla bo yebe hasirloh irer tamol temarong kowe?” ");
INSERT INTO uli_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Iwe ngo sa kekel loh chog foloy kowe yael Saul. Ngo tugulul mokwe ye sor irel mala Jesus le iy Kristus, ila ye llah le ye katos. Ngo Jews kowe re mel woal Damascus re tay gola mele rebe palili ngali. ");
INSERT INTO uli_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yela ssulayloh mo wol miril ngo resa ttey fengal Jews kowe resa kapta bo rebe limeseloh Saul, ");
INSERT INTO uli_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","iwe ngo ye che taelengel Saul irel mokwe resa kapta. Bong mo ral ngo re sama posa hatmal yororol haplom we bo hare be yoh le rebe limeseloh Saul. ");
INSERT INTO uli_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Llubungul seral ngo mokwe choluwal resa hasi Saul resa habuyoyu mo irel sew cheche mo woal pegil yororol haplom we, le ye mel lal sew bechebach resa harigrigidiy. ");
INSERT INTO uli_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sa loh Saul woal Jerusalem sala memeal bo yebe daber chotugul kowe. Iwe ngo ir re techepar le iy semal chiler, ngo panger ngo re metagu. ");
INSERT INTO uli_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Iwe Barnabas sa budoh tipingi, sa paliloh irer apostel kowe. Sala hamdefa ngalir yael Saul wiri Samol mo lal yalap we, mo yael Samol maliliy ngali. Iwe ngo ye kangalur kkelel yael Saul foloy fael Idel Jesus mo woal Damascus. ");
INSERT INTO uli_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Iwe Saul sa mel irer ngo sama foloy fedal wol Jerusalem fael Idel Samol ngo tor le iy ye metagu. ");
INSERT INTO uli_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yema hapatpat ngo ye hachocho ngalir Jews kowe rema yalol Greek, iwe ngo ir resa memeal bo rebe limeseloh. ");
INSERT INTO uli_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Molwe chotugul kowe rela rongrong kofal mele, ngo resa hasiloh Saul woal Caesarea iwe ngo resa hafengaloh iy woal Tarsus. ");
INSERT INTO uli_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Iwe irel yodla ngo sa posoloh Eklesia woal pangal loh Judea, mo Galilee, mo Samaria. Irel mala kkamelal Espritu Santus ngo yesa kkel loh tot lal deper chotugul kowe ngo ye choloploh tot chiler, irel yar mel le re hasrowu Samol. ");
INSERT INTO uli_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedrus yela malekah fedal ngo irel sew yad, ngo sala tefael mo irer mokwe lol Deus we re mel woal Lydda. ");
INSERT INTO uli_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ila lobola yela chungu semal mal le Aeneas idal, le ye mahatgut, ngo sa waluw raeg le sema mel chog wol bet bo tayma dohloh. ");
INSERT INTO uli_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedrus yesa kangalu bo, “Aeneas, Jesus Kristus yebe hachuya yam tomay. Sudah hosa limi mekla giyem.” Yodwe chog ngo yesa sudah Aeneas. ");
INSERT INTO uli_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Panger rechokwe re mel woal Lydda mo Sharon ngo re wiri mal we, iwe resa rol weg ngal Samol. ");
INSERT INTO uli_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iwe ngo ye mel semal fefel woal Joppa le Tabitha idal, le iy semal chotugul. (Mala idal irel Greek ila Dorcas le fal ila “monoch.”) Yema tapeli kkelal irel hafforol meka ye momay mo irel yal tipingir mael hafohoy. ");
INSERT INTO uli_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Irel yodle ngo ye tomay yee, la mes. Resa haduduy molwe holongol resa holo lal sew senggil mo irel dalla wulural. ");
INSERT INTO uli_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa ila yete ddaw tang Lydda. Iwe ngo yodwe chotugul kowe wol Joppa rela rongrong le Pedrus ye mel wol Lydda, ngo resa hagloyurloh rumal mal le re hasi mala yalor le re sor bo, “Fael pechem ngo hobe hatturugdoh iremem.” ");
INSERT INTO uli_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Iwe Pedrus yesa haliliy yesa daber. Yela dohdoh, ngo resa palidah irel senggil we wulural. Tot fefel le sa mes rir resa ttey ngal Pedrus le re tetang ngo re kekewar ngali pangal mengagol holong kowe mo sekketa kowe Dorcas ye foru irel yodwe ye chil molow iyang. ");
INSERT INTO uli_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedrus yesa habuyoyur rechokwe mo lal senggil we, ngo yesa hasubgudiy sa mapel. Iwe ngo yesa sor bo, “Tabitha, chemdah!” Tabitha yesa kalloh, ngo yodwe yela wiri Pedrus, ngo yesa chemdah. ");
INSERT INTO uli_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedrus yesa cchangloh sa tipingi bo yebe sudah. Yesa fesngur chotugul kowe le ye mel fefel kowe yesa mes rir luwulur. Yesa kkewar ngalir lefechig we le yesa molow tefael. ");
INSERT INTO uli_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Sa palleng loh kaptal mele woal Joppa, ngo ye cholop le sa tugul lal depal irel Samol. ");
INSERT INTO uli_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ye ssulay tot yal mel Pedrus woal Joppa, le yema mel irel Simon we semal chol yengangel hafforol gil karbow. ");
INSERT INTO uli_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ye mel semal mal wol Caesarea le Cornelius idal le yesa semal kapten irel rel saldawel Roma we rema sor bo, “Saldawel Italia.” ");
INSERT INTO uli_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iy semal yarmat le yema itol depal irel mapel; iy mo chol yal mel ngo rema hasrowu Deus. Ye cholop mekla ye foru le hammaler mael hafohol Jews, ngo yema toa mepel loh chog ngal Deus. ");
INSERT INTO uli_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Seral le bele luwul suluw kolok lleplaliyol ngo yesa llah ngali sew formel. Ye wiri hamayu semal angelus kowe lol Deus, le ye budoh irel ngo sa fesangu le ye sor bo, “Cornelius!” ");
INSERT INTO uli_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Sala haffada angelus we luwul yal motog ngo yesa sor bo, “Meda molwe ho sosor, melap?” Angelus we yesa kangalu bo, “Sa fel depel Deus irel mepel kala yam mo yengangel hammal kala yam, ila iy yesa fel le yebe talenga mele hobe sor. ");
INSERT INTO uli_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hagloyurloh sibis mal woal Joppa rebela meri semal mal le Simon Pedrus mala idal. ");
INSERT INTO uli_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ye memel irel imw we imwel Simon, we semal chol yengangel hafforol gil karbow. Imw la imwel Simon ila ye harpa taed.” ");
INSERT INTO uli_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ye loh angelus we ngo Cornelius yesa fesangu rumal tarmal kowe yal boy mo semal saldaw. Saldaw le ila iy semal mal le ye ssor Deus mo lal depal, ngo iy semal pos kowe re dabeyel Cornelius. ");
INSERT INTO uli_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cornelius yesa kangalur molwe sa wel, iwe ngo yesa hagloyurloh wol Joppa. ");
INSERT INTO uli_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yela rallawe seral ngo rechokwe re chil loloh chog le resa harpa Joppa. Molwe bele wwel yaal ngo Pedrus sa bidah wol imw we yema mel iyang bo bela mapel. ");
INSERT INTO uli_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yesa dipli le yebe hangi sugfed formel bo yesa koloh. Irel yodwe re chil fofor mongoy, ngo Pedrus yesa wiri sew formel. ");
INSERT INTO uli_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yesa wiri laeng le ye sugeg, iwe mo sew formel le ye wochog sew mengag kowe ye hammetag le ye kemachdah mekla tabdungul wulural sa bibidiy wol talop. ");
INSERT INTO uli_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ye ssog pangal metmetal mael wolfulu, mo mael leted mo mael yeyal lal mengag we. ");
INSERT INTO uli_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ngo yesa rongrong yalol Deus le ye sor bo, “Sudah ho Pedrus. Lliy mael ka bo hobe mongoy!” ");
INSERT INTO uli_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedrus sa sor bo, “Yeb, ho Samol! Tedyor fael sew le imongoy meka ted chuy tabol hare meka ye tungaf.” ");
INSERT INTO uli_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Iwe ngo Deus sa wol kangalu bo, “Ho towe luluwaley le hare ye chil tab meka Deus yesa hachuya yal tab.” ");
INSERT INTO uli_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Fael suluw la iye sengal mele, iwe ngo sa tefaeldah mengag we wol laeng. ");
INSERT INTO uli_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Yodwe Pedrus ye chil luluwaley fael molwe ye wiri, ngo mal kowe Cornelius ye hagloyurdoh resa gola lobosle ye mel imw le imwel Simon iyang. Yela yodle ngo resa rol su metal hatmal yoror we. ");
INSERT INTO uli_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Iwe ngo resa fofos long ngo resa kasiy, “Yor semal wasola iga le Simon Pedrus idal?” ");
INSERT INTO uli_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedrus ye chil luluwaley fedaley hare meda fael molwe ye wiri ngo Espritu Santus yesa kangalu bo, “Kalladoh, solmol mal ika resa budoh le re memerug. ");
INSERT INTO uli_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ila hamalloh ngo hosa bidiy, ho towe yeyewal irel yam daber bele ngang mele ihagloyurdoh.” ");
INSERT INTO uli_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Iwe sa bidiy Pedrus ngo yesa kangalur mal kawe bo, “Ngang yeramtala ha memeri. Meda mele ha memeriyey iyang?” ");
INSERT INTO uli_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Iwe ngo ir resa sor bo, “Kapten Cornelius mele ye hagloyugmemdoh. Iy semal yarmat le ye momay. Ye hasrowu Deus ngo ye ssor mo irer panger Jews. Semal angelus kowe lol Deus ye kangalu bo yebe dengag gel bo hobe loh irel imw la imwal, bo yebe talenga mekla hobe kapta.” ");
INSERT INTO uli_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pedrus yesa fesangur long mal kowe bo rebe mel irel, lubungul rallawe. Yela rallawe seral ngo yesa haliliy sa daber; iwe ngo sibis ir chotugul kowe wol Joppa resa daber. ");
INSERT INTO uli_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yela rallawe seral ngo resa hola Caesarea. Ila lobowe Cornelius ye wiwidir iyang, le iy mo mokwe chol bugtal mo mokwe maryarel we yesa fesangurdoh. ");
INSERT INTO uli_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Imol chog molwe Pedrus be bulong yilim ngo resa chufengal mo Cornelius. Iwe ngo Cornelius yesa hasubgudiy mo imol bo yebe hasrowu. ");
INSERT INTO uli_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedrus yesa kangalu bo, “Sudah bele ngang chog semal yarmat.” ");
INSERT INTO uli_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pedrus ye kapatpat ngal Cornelius irel yodwe re bubulong lal imw we sa ttey yarmat iyang. ");
INSERT INTO uli_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedrus yesa kangalur bo, “Hami ngo ha faesul gola le ye tab mo irel taliw we yar Jews le rebe ma budoh irer Gentiles hare re hagiyeg sew. Iwe ngo Deus yesa kkewar ngalyey le tor semal yarmat le ibe yitili le ye ted chuy tab mo uwol hare ye tungaf. ");
INSERT INTO uli_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ila fal le yodwe ha dengag ngang ngo isa budoh bo tor mele iwiri le ye tafel mo irel dengag we yami. Ila ibele kasiyahmi igla, ‘Meda mele ha dengag ngang iyang?’” ");
INSERT INTO uli_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius yesa sor bo, “Merelahol talengel lalow irel molwe suluw kolok llaplaliyol ngo imemapel lal imw le imwey. Itedaploh ngo sa suloh semal mal mo imoy le ye ddoldol mekla mengagol, ");
INSERT INTO uli_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","iwe ngo yesa sor bo, ‘Cornelius! Deus yesa rongrong mepel kala yam, ngo yesa gola yengangel hammal kala homa foforu. ");
INSERT INTO uli_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Fang loh semal wol Joppa bo bela meri semal mal le Simon Pedrus idal. Le ye mel irel mala imwel Simon we semal chol yengangel hafforol gil karbow, ngo ye harep ngal chog taed mala imwal.’ ");
INSERT INTO uli_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Iwe isa dengag gel ngo iye ho mechal budoh luwul momayel yam hagiyeg. Igla, siya rol ttey fengal fael metal Deus, bo sibe talenga mekla Deus yesa kangalug bo hobe sor.” ");
INSERT INTO uli_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedrus yesa chapiy yal hapatpat ngo sa sor bo, “Isa moch gola le ye katos le Deus ye hafidgirloh chog panger yarmat. ");
INSERT INTO uli_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Te tugul semal le be metagu Deus ngo ye foru meka ye momay ngo iy ye fel mo irel Deus, le te tugul chol fulu le iy. ");
INSERT INTO uli_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ha gola molwe yalol, we ye fang ngalir yarmetael Israel, we ye kapta loh Hapatpat Momay we kofal hopos we ye budoh mo irel Jesus Kristus, le iy Samol irel pangal formel. ");
INSERT INTO uli_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ha gola molwe ye palleng we sa weldoh wol pangal loh Israel, we ye chap mo wol Galilee wol miril yael Johannes foloyu kaptal baptismus. ");
INSERT INTO uli_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ha gola kofal Jesusel Nazareth mo igegel yael Deus fangdiy Espritu Santus uwol mo yal fang kkelal. Pangal lobos ngo ye loh iyang le ye foforu yengang kala ye momay. Yema hachuya kkalel Moniyan mo uwor yarmat. Ye yoh le ye for meka bo mil mala Deus ye mel irel. ");
INSERT INTO uli_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Hamem mele tugulul pangal mekla ye foru mo wol Israel iwe mo wol Jerusalem. Iwe ngo ir re limeseloh le re chifilidah wol sew krud. ");
INSERT INTO uli_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Iwe ngo yela solral mo wol miril ngo Deus yesa hamolwa tefaelidah mo irel maes; iwe ngo Deus yesa foru le Jesus yebe llah, ");
INSERT INTO uli_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","le towe llah ngalir panger yarmat, bo rechokla chog Deus yesa duwler bo rebe wiri mele yebe llah ngalir. Mala ila hamem rechokwe ha rol mongoy sew ngo ha rol yul sew mo Jesus wol miril yal molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iwe ngo yesa hatobtob ngalugmem bo habe foloyu Ebangelium we ngalir yarmat, ngo ha hatugulu ngalir yarmat le iy mele Deus yesa duwley bo yebe hatugulu kofer chomolow mo chomes. ");
INSERT INTO uli_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Panger profeta kowe ngo re sor kaptal, ngo re sor bo te tugul semal le be tugul lal depal irel, ngo be chuy fael molfidel irel kkamelal mala Idal.” ");
INSERT INTO uli_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Yodwe Pedrus ye chil kapatpat ngo sa bidiy Espritu Santus uwor panger rechokwe re tetalenga mokwe yalol. ");
INSERT INTO uli_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jews kowe resa faesul chepar, we re dabedoh Pedrus mo wol Joppa re lluwdah irel molwe Deus yela wol fangdiy kkefang we yal we Espritu Santus uwor Gentiles kowe. ");
INSERT INTO uli_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bo resa rongrong yar yalol sew mo sew fuluy, mo yar kapingpinga Deus le ye hartal tagiyet. Iwe ngo sa maliliy Pedrus le ye sor bo, ");
INSERT INTO uli_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Sa bidiy Espritu Santus uwor rechoka le ye wochog yal bidiy uwoch. Yor semal le be yoh le be hapolahor igla mo irel yar be baptismus irel chael?” ");
INSERT INTO uli_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Iwe yesa kangalur bo rebe baptismus irel mala Idel Jesus Kristus. Iwe ngo rechokwe resa kangalu Pedrus bo hare yebe mel mwo irer wol fedbong. ");
INSERT INTO uli_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iwe ngo apostel kowe mo chotugul kowe wol pangal loh Judea resa rongrong le sa holar Gentiles molwe yalol Deus. ");
INSERT INTO uli_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iwe ngo yodwe Pedrus yela tefael loh wol Jerusalem, ngo rechokwe re sor bo re dipli le Gentiles rebe hagil, resa hapatpat ngal Pedrus le re sor bo, ");
INSERT INTO uli_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Hosa loh ho sala mel irer Gentiles kowe re ted hagillar, iwe ngo ho mongoy ngalir!” ");
INSERT INTO uli_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Iwe Pedrus sa budoh hamdefa ngalir kofal pangal mokwe ye wel ngali, le ye chapiy mo irel mala chapdagel le ye sor bo: ");
INSERT INTO uli_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yodla imemapel wol Joppa, ngo isa wiri sew formel. Iwiri sew formel le ye wochog sew mengag kowe ye hammetag, le ye kemachdah mekla tabdongol, yesa bibidiy mo wol laeng yee, la poloh mo imoy. ");
INSERT INTO uli_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ila kallong ilal isala wiri le yor mael haffigir, mo mael machoh, mo mael leted, iwe mo mael yeyal iyang. ");
INSERT INTO uli_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iwe ngo isa rongrong yalol Deus le ye kangaluyey bo, ‘Sudah ho Pedrus; lliy mael kala bo hobe mongoy!’ ");
INSERT INTO uli_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Iwe ngo ngang isa sor bo, ‘Towe yoh ho, Samol. Bo tedyor fael sew le ye pachngal yeway mongoy ka ye tab, hare ika ye tungaf!’ ");
INSERT INTO uli_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Sa wol malilidiy Deus mo wol laeng fael sew le ye sor bo, ‘Ho towe luluwaley le hare chil tab meka Deus yesa hachuya yal tab.’ ");
INSERT INTO uli_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Fael suluw yal iwe sengal molwe, ngo sa tefaeldah mengag we wol laeng. ");
INSERT INTO uli_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Irel chog yodle ngo solmol mal le re hagloyurdoh mo wol Caesarea resa hola doh imw we imel iyang. ");
INSERT INTO uli_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Iwe ngo Espritu Santus yesa kangaluyey bo iy towe kketalmoch bo iy be daber. Wolmal chotugul mo woal Joppa le re dabeyeyloh woal Caesarea. Pangmem ngo ha loh irel imw we imwel Cornelius. ");
INSERT INTO uli_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ngo iy yesa kangalugmem sangsengal yal wiri semal angelus le ye su lal imw la imwal le ye kangalu bo, ‘Hagloyuloh semal wol Joppa, irel semal mal le Simon Pedrus mala idal. ");
INSERT INTO uli_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iyebe kangalug tot formel le gel mo wocchol yam mel ngo habe daor iyang.’ ");
INSERT INTO uli_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ngo yodla ye chap yai maliliy ngo yesa bidiy Espritu Santus uwor, le ye wochog yal bidiy uwoch irel yodwe ye chapdah meka iyang. ");
INSERT INTO uli_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iwe ngo yesa mmang ngalyey mokwe Samol sa mol sor: ‘Johannes ye baptismus yarmat irel chael, ngo hami habe rol baptismus irel Espritu Santus.’ ");
INSERT INTO uli_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Sa ffodloh le Deus ye fang ngalir ir Gentiles ka kkefang kowe ye fang ngalgich irel yodwe sa tugul lal depach irel Samol Jesus Kristus; ila ngo ngang itey le ibela luluwaley bo ibe hapolaho Deus!” ");
INSERT INTO uli_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Yodwe rela rongrong chog mele ngo resa ppoloh mo irel yar lunglung, ngo resa hapingpinga Deus le re sor bo, “Deus yesa wol foru bo yebe rrig deper Gentiles bo rebe molow!” ");
INSERT INTO uli_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Resa rol medardar fedal chotugul kowe irel molwe resa kekafohoyur wol miril yodwe yesa mes Stephen. Tot ir resa loh wol Phoenicia, ngo tot woal Cyprus, ngo tot woal Antioch, le re kekapta kofal Jesus ngalir chog Jews. ");
INSERT INTO uli_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ngo sibis chotugul kowe, le sibis mall Cyprus mo Cyrene, re loh woal Antioch re sala foloy ngalir Gentiles le re kangalur Hapatpat Momay we kofael Samol Jesus. ");
INSERT INTO uli_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ye mel mala kkelel Samol uwor, iwe ngo ye cholop yarmat le resa chepar resa tagul ngal Samol. ");
INSERT INTO uli_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yesa hola eklesia we Jerusalem kaptal mele, iwe resa fangloh Barnabas woal Antioch. ");
INSERT INTO uli_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yela hola doh Antioch sala wiri lepal yael Deus holbuwar yarmat. Iwe sala rraey lal depal, ngo yesa kangalur yarmat bo rebe itol deper irel yar tugul irel Samol. ");
INSERT INTO uli_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ila semal yarmat le ye momay. Ye mel Espritu Santus uwol ngo ye kkel yal tugul. Ila fal le yesa cholop yarmat le resa weg ngal Samol iyang. ");
INSERT INTO uli_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Iwe Barnabas yesa loh woal Tarsus bela meri Saul. ");
INSERT INTO uli_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Yodwe yela wiri ngo yesa hasiloh wol Antioch. Lluyel loh sew raeg le chole rumal rema ttey ngalir yarmetal eklesia we ngo resa foloyur le resa sew buwa le ye palleng. Moch wol Antioch mele ye chap yar ffesang ngalir chotugul kowe bo ir Kristiano. ");
INSERT INTO uli_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Irel yodla ngo sibis profeta resa chuy mo woal Jerusalem resa loh woal Antioch. ");
INSERT INTO uli_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Semal mo luwulur ila Agabus idal. Yesa sudah ngo irel mala kkelel Espritu Santus ngo yesa kapta kofal sew langda le ye kkel le yebe budoh wol pangal loh talop le. (Langda le ila ye budoh irel yodwe Claudius mele Llulupal Tamol.) ");
INSERT INTO uli_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Chotugul kowe resa hatugulu le semal ir ngo ye fang lepal mele yebe yoh irel bo hammaler chotugul kowe choluwar we re mel wol Judea. ");
INSERT INTO uli_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Re foru mele, ngo resa fangloh salpiy we le Barnabas mo Saul mele re hasiloh irer mal kowe yar irel Eklesia we. ");
INSERT INTO uli_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Irel yodle ngo King Yerodes yesa chapiy yal hafohoyur sibis Kristiano kowe. ");
INSERT INTO uli_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yesa sor bo rebe limeseloh James we bisil John, iwe resa limeseloh le re ffala ngal sayden. ");
INSERT INTO uli_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Molwe yela wiri le ye fel deper Jews kowe irel molwe yesa foru, ngo yesa wol ddorfi Pedrus yesa kalbusu. (Ye weldoh mele irel molwe Bungul Flowa we tema yor Habboloh iyang.) ");
INSERT INTO uli_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wol miril molwe resa ddorfi Pedrus resa kalbusu, ngo saldaw re sama posa le rema kaffamal irel sew yodol pos. Yerodes ye luluwaley le rebe hatugulu kofal mo imol yarmat cholop wol miril Paska. ");
INSERT INTO uli_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iwe resa yitili chog Pedrus lal kalbus. Kristiano kowe resa hakkelar chog irel yar mepel ngal Deus bo yagili. ");
INSERT INTO uli_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Llubungul rallawe ye bele la rral dah ngo Yerodes ye bele hasiloh Pedrus bo re bela hatugulu kofal mo imor yarmat cholop, ngo Pedrus ye masor llepder rumal pos kowe ngo ye ffor irel rutab chen. Iwe ngo yor pos le re mel metal hatmal yororol kalbus we. ");
INSERT INTO uli_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Re tadaploh chog ngo semal angelus kowe lol Samol yesa su lobowe, ngo sa werloh lal kalbus we. Angelus we yesa yuchgu molwe yefral Pedrus sa fangludah ngo sa kangalu bo, “Hatturug! Chemdah!” Yodwe chog ngo sa talichloh chen kowe mo wol mokwe paol Pedrus. ");
INSERT INTO uli_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Iwe angelus we sa sor bo, “Hallugu mala tarem ngo hosa hadage bwela kala yam.” Pedrus yesa foru molwe ngo angelus we yesa wol kangalu bo, “Yetedah mala mengagom uwom ngo hosa dabeyey.” ");
INSERT INTO uli_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedrus yesa dabewey miril angelus we mo lal kalbus we le ye togla hare tos molwe angelus we sa foru hare yal chog ddal. ");
INSERT INTO uli_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Re hatapela molwe metamol liliyel pos mo iwe harwowal, ngo resa moch hola hatam parang we hatemal yeror we ye telengal haplom we. Sa iy chog hatam we yal sugeg ngalir ngo ir resa buyoy ligtam. Resa dedarloh lal yalap we ngo ye tedaploh chog Pedrus, ngo ye tamel loh angelus we. ");
INSERT INTO uli_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iwe ngo Pedrus yesa moch medaf irel molwe sa wel ngali ngo sa sor bo, “Igla isa moch gola le ye halongol katos molwe! Samol yesa hafngadoh angelus we lol bo yebe hadorayey mo irel mele kkelel Yerodes mo pangal meka Jews ka re luluwaley le be wel ngalyey.” ");
INSERT INTO uli_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ye medaf loh chog irel mokwe sa wel ngali, ngo yesa loh irel imw we imwel Mary we sil John Mark. Ye cholop yarmat le resa ttey doh irel imw we resa rol memapel. ");
INSERT INTO uli_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedrus yesa hapungpungu hatam we, ngo semal boy fefel le Rhoda idal, sa loh bela sugu. ");
INSERT INTO uli_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ye gel ngali chog molwe lliyalol Pedrus ngo sa kkel yal rraey. Yete suga chog hatam we, ngo sa hamed tefaeli long lal imw we sala sor bo Pedrus molwe ye su ligtam. ");
INSERT INTO uli_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Iwe ngo resa kangalu bo, “Hosa buch!” Ngo iy ye kkel chog yalol le katos molwe. Iwe resa kangalu bo, “Ila ngo angelus we yal mala.” ");
INSERT INTO uli_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yodla ngo Pedrus ye chil kapungpunguloh chog hatam we. Wol miril ngo resa sugu hatam we re sala lluwdah irel molwe rela wiri Pedrus. ");
INSERT INTO uli_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Iwe ngo yesa pongpong ngalir bo re towe maliliy, ngo yesa hamdefa ngalir sangsengal yal Samol hasiwey mo lal kalbus. Yesa kangalur bo, “Ha kangalu James mo chotugul kowe tot mele.” Iwe yesa ligdir sa loh mo solbos. ");
INSERT INTO uli_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yela lemaliyeldah ngo resa somawel fedal pos kowe bo re togla mele ye foru ngo ye sala tamel loh Pedrus. ");
INSERT INTO uli_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yerodes sa sor bo rebe meri, ngo rela meri ngo re tiwri. Iwe sa sor bo rebe haduguyur pos kowe ngo resa limeserloh. Yela wol miril mele ngo sa chuy Yerodes mo woal Judea sala mel tot woal Caesarea. ");
INSERT INTO uli_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Sa kkel yal ssong Yerodes ngalir yarmetael Tyre mo Sidon, iwe ir resa ttey fengal re sala tefael mo irel. Metamol ngo rela hapatpat ngal Blastus le iy mele ye kekemahoy imw we imwer tamol, bo yebe tipingir. Iwe ngo resa roloh irel Yerodes bo re bela hapasso llepder, bo ir rema kak haler mo wol molwe faluyel king le. ");
INSERT INTO uli_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Seral ngo Yerodes yesa ppedeg long fael molwe mengagol tamol, ngo sa buyoy marro wol chiya we liliyal, ngo sa kapatpat ngalir yarmat. ");
INSERT INTO uli_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yarmat resa tawulagili bo, “Te semal yarmat mele ye maliliy bo semal deus!” ");
INSERT INTO uli_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Yodwe chog ngo angelus we lol Samol sa limeseloh Yerodes le fael molwe yete fang ssor ngal Deus, ngo sala foru bo iy Deus. Ye mes irel labud kala lal siyal. ");
INSERT INTO uli_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yodla ngo sa palleng yal daoloh molwe yalol Deus. ");
INSERT INTO uli_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Yela wol miril yael Saul mo Barnabas hamallo malekah we yar, ngo resa tefaeldiy mo woal Jerusalem le resa hasi John Mark bo choluwar. ");
INSERT INTO uli_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Eklesia we woal Antioch ila ye mel sibis profeta mo sibis sensey iyang; ir Barnabas mo Simeon (we rema sor bo iy Roch), mo Lucius (we ye budoh mo wol Cyrene), mo Manaen (we re faholdah chog sew mo Yerodes we iy semal Tamol Aam), iwe mo Saul. ");
INSERT INTO uli_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yodwe re kekasrowu Samol ngo rema supiy haler bo yar maligach, ngo Espritu Santus yesa kangalur bo, “Ha hamuslaho Barnabas mo Saul bo rebe foru yengang kala isa fesangur bo re bela foru.” ");
INSERT INTO uli_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Re supiy haler ngo re mapel, iwe ngo re yetedah payur uwor iwe ngo resa hafengarloh. ");
INSERT INTO uli_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas mo Saul resa loh woal Seleucia re sala terag mo iyang resa loh woal Cyprus, le Espritu Santus mele ye hagloyur. ");
INSERT INTO uli_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Rela hola Salamis, re sala foloyu molwe yalol Deus lal imwel ttey kowe yar. John Mark ye daber bo yebe tipingir irel yar yengang. ");
INSERT INTO uli_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Resa loh ffoch irel fulu we rema sor bo Paphos, re sala chungu semal tabtob le Bar‐Jesus mala idal le iy semal Jews ngo ye ssor bo iy semal profeta. ");
INSERT INTO uli_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iy maryarel molwe aamel fulu we, le Sergius Paulus mala idal ngo iy semal mal le ye momay lal chemal. Aam we yesa dengag Barnabas mo Saul bo ye dipli le yebe rongrong mala yalol Deus. ");
INSERT INTO uli_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Iwe ngo tabtob we Elymas (ila mala idal irel Greek) ye pipiltar, bo ye luluwaley le yebe wigdi depel aam we tang tugul we. ");
INSERT INTO uli_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Iwe sa bidiy Espritu Santus uwol Saul we rema wol fesangu bo Paulus; yesa haffeda hamayu tabtob we, ");
INSERT INTO uli_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ngo yesa sor bo, “Gel lol Moniyan! Ho hatohar ngal pangal meka ye momay. Ho ssogol pangal machohchoh ka yael moniyan, iwe ngo hosa yeyedamgili le hobe wigdi meka yalol Deus ngal kachapar! ");
INSERT INTO uli_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kemahoy mala paol Deus le bele bidiy uwom igla, le ho bele metafis ngo hote wol wiriloh mwo werel yayural.” Yodwe chog ngo Elymas yesa wiri sew roch le yesa piltaloh mokwe metal, iwe ngo sa darfedal le ye fefag yarmat bo rebe holu molwe paol bo rebe pali. ");
INSERT INTO uli_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Molwe aam we yela wiri molwe yesa iwe sengal ngo yesa tugul loh lal depal; bo ye kkel yal lluwdah irel foloy kowe kofal Samol. ");
INSERT INTO uli_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus mo mokwe choluwal resa terag mo woal Paphos resa budoh woal Perga, le sew haplom woal Pamphylia. Iwe ngo ila lobole John Mark ye ligdir mo iyang sa tefael ngal Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Resa chuy mo wol Perga resa budoh woal Antioch we ye mel woal Pisidia. Wol Sabbath ngo resa roloh irel imwel ttey we re sala marodiy mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wol miril yar yewaw mo irel babiorol Hatobtob we yael Moses mo babior kowe tafayer profeta kowe, ngo tamol imwel ttey we resa fangloh yalor irer le re sor bo, “Re wol bismem, ha dipli le hami habe maliliy ngalir yarmat bo hare yor sew hapatpat le habe kangalur le yebe hakkela lal deper.” ");
INSERT INTO uli_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Sa sudah Paulus, yesa pongpong ngalir bo rebe poloh, ngo yesa chapiy yal hapatpat ngalir: “Re Israel mo pangmi Gentiles ka ha mel iga le ha hasrowu Deus, ha taelenga! ");
INSERT INTO uli_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Deus we yar re Israel ye duwler chapdoh kowe yach le rebe mel bo setar yarmat le rebe hoy irel yodwe re mel bo wasola woal Egypt iyang. Iwe ngo irel mala kkelel iy Deus mele ye hasirwey mo woal Egypt iyang. ");
INSERT INTO uli_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Iwe ngo fayeg raeg luwul yar ma tolpagili, ngo iy ye kekamalerloh chog mo lal tolmayloh we. ");
INSERT INTO uli_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ye llir yarmetael fusuw mokwe faluyel Canaan, iwe yesa ngaler yarmetael Israel kowe lol bo faluyer ");
INSERT INTO uli_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","le rebe mel iyang irel fabuguy mo lemeg raeg. “Wol miril mele ngo yesa fang yar chol tatelal hapatpat yee, la hola wolmol profeta Samuel. ");
INSERT INTO uli_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ngo yodwe rela dongor yar king, ngo Deus yesa fang ngalir Saul we lol Kish we ye budoh mo irel haleng we yael Benjamin, bo yebe mel bo yar king irel fayeg raeg. ");
INSERT INTO uli_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Yela wol miril yal hachuya Saul mo fael Tamol ngo Deus yesa foru David bo yar king. Iye molwe Deus ye sor irel bo, ‘Isa wiri le David we lol Jesse mele tappel yarmat la idipli, yeramtala yebe foru pangal mekla ngang iy dipli le yebe foru.’ ");
INSERT INTO uli_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jesus we ye budoh mo irel daowe yael David ila, iy molwe Deus ye hatugulu bo yebe Demerir yarmetal Israel. Iy molwe Deus ye promise gili. ");
INSERT INTO uli_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Imol yodwe Jesus ye bele chapiy yal yengang ngo Johannes yesa foloyu ngalir panger re Israel bo rebe tagul tang mekla molfidir ngo resa baptismus. ");
INSERT INTO uli_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Iwe ngo yodwe Johannes yesa kkarpal hammalo yengang we yal, ngo yesa kangalur yarmat bo, ‘Ha yitli bo Ngang itey? Te ngang yeramtala ha wiwidi. Ha taelenga! Iy ila yebe hamirdoh mo wol miriy, ngo ngang mwo ngo tor mmaley le ibe hachuya bwela kala yal mo irel pechel.’ ");
INSERT INTO uli_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Re wochilay re Israel, le chol daowe yael Abraham, iwe mo pangmi Gentiles ka ha hasrowu Deus: gich mele re fangdoh kaptal molow le irech! ");
INSERT INTO uli_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bo rechokla re mel wol Jerusalem mo mal kala yar re togla le iy, iy Demer we, ngo re temedaf irel mokwe yalor profeta kowe ir rema talenga wol pangal Sabbath. Iwe rela foru meka irel yar fangloh Jesus bo yebe mes, ye sala far llah le ye katos mokwe yalor profeta kowe. ");
INSERT INTO uli_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ila mwo tor fal le rebe limeseloh, ngo re dangro Pilatus bo yebe fangloh bo re bela limeseloh. ");
INSERT INTO uli_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Yela wol miril yar foru ngali pangal meka Babior we ye Santus ye sor irel, ngo resa hachuyadiy mo wol krud resa yetolong lal lib. ");
INSERT INTO uli_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Iwe ngo Deus ye hamolowa tefaeli mo irel maes, ");
INSERT INTO uli_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ngo ye cholop rall ka ye llah ngalir rechokwe re dabey mo Galilee resa dabeloh wol Jerusalem. Igla ila resa mel bo yal tugul ngalir yarmetal Israel. ");
INSERT INTO uli_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Iwe ngo hamem hasa budoh habe hasidoh Hapatpat Momay le ngalugmi: molwe Deus ye promise gili ngalir chapdoh kowe yach le yebe foru, ila yesa foru igla bo yagilgich, le gich chol daola yar, irel yal hamolowa Jesus mo irel maes. Iwe ye teftaf lal babiorol Psalm: ‘Gel layi; igla mele isa mel bo Tamom!’ ");
INSERT INTO uli_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ngo iye mele Deus ye sor irel kofal yal hamolowa tefaeli mo irel maes, le tor fael sew le yebe mongongowloh lal lib: ‘Ibele fang ngalug yolbuw we ye santus we iy hatugulu ngal David.’ ");
INSERT INTO uli_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Iwe ngo solbos mo lal babior we ye santus le ye wol sor bo, ‘Ho towe ligdiloh re hagloy la lom bo yede mongongow loh lal lib.’ ");
INSERT INTO uli_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Bo yodwe ye molow David ngo ye foru mokwe yalol Deus, yela mes re sala leba irer chapdoh kowe yal, iwe ngo ye mongongowloh molwe porgol mo lal lib. ");
INSERT INTO uli_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Iwe ngo yeramtala Deus ye hamolowa mo irel maes ila te ila sengal. ");
INSERT INTO uli_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Pangmi re Israel ka wochilay ngo habe hatugulu mo lal dipmi, le yagel Jesus mele hamem hasa foloyu ngalugmi kofal hachuchuyel molfid iyang. Iwe ngo habe gola le te tugul semal le ye tugul lal depal irel, ngo yebe chuy mo luwul molfid kala towe yoh le Hatobtob we yael Moses yebe hachuyahmi mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ha hafalugmi bo de wel ngalugmi mokwe profeta kwe re sor bo: ");
INSERT INTO uli_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ha kalladoh hami rechokla hama tap kamemal meka. Ha lluwdah yami mes! Bo mele ifoforu igla ila sew formel le ha towe chepar iyang, le ila mwo semal ye hamdefa ngalugmi!’” ");
INSERT INTO uli_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Yodwe Paulus mo Barnabas re bele ligdi imwel ttey we, ngo yarmat resa hafalpecher bo rebe tefaeldoh irel Sabbath la sew bo rebe kangalur tot kaptal meka. ");
INSERT INTO uli_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Yela wol miril yar medar yarmat mo irel imwel ttey we ngo ye cholop Jews mo Gentiles kowe resa weg ngal Jews, le resa dabey Barnabas mo Paulus. Apostel ka resa kangalur bo rebe hakkela lal deper irel yar mel luwul haradiya la yael Deus. ");
INSERT INTO uli_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Yela hola Sabbath we sew ngo ye memeal chog le be retdoh yarmetal haplom we bo rebe talenga molwe yalol Samol. ");
INSERT INTO uli_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yodwe Jews kowe rela wiri lepal buwa we ngo yesa kkel yar loltomay. Resa hapaliyel ngal Paulus irel mokwe ye sosor ngo re hapatpat tayikofloh irel. ");
INSERT INTO uli_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Iwe ngo Paulus mo Barnabas resa wol hapaliyel ngalir le yesa kkel tot yalor. “Ye palleng pelal le hamem habe moal foloyu ngalugmi mwo mele yalol Deus. Iwe ngo hami ha tahchaloh ngo hate hafaliloh le yor mmalmi irel molow la tor siyal. Ila hamem ha bele lugdugmi hasa loh irer Gentiles. ");
INSERT INTO uli_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bo iye hatobtob la Samol yesa fang ngalugmom: ‘Isa forugmi bo sew teram ngalir Gentiles, bo hare pangerloh re faileng le ngo rebe molow.’” ");
INSERT INTO uli_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Yodwe Gentiles kowe re rongrong molwe, ngo resa rraey ngo re hapingpinga molwe yalol Samol; iwe ngo rechokwe yesa faesul tugul bo yebe yoh ngalir molow la tor siyal ila resa mel bo chotugul. ");
INSERT INTO uli_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Sa palleng yal daoloh molwe yalol Samol wol pangal loh fulu we. ");
INSERT INTO uli_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ngo Jews kowe resa hatarongardah mal kowe yar wol haplom we, mo fefel Gentiles kowe re tagiyet we re kekasrowu Deus. Sa chap yar hafohoyu Paulus mo Barnabas. Yela wol miril ngo resa ddaberloh mo wol molwe fuluyer. ");
INSERT INTO uli_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Apostel kowe resa yuchgaloh boll fulu we mo irel pecher irel yar ssong ngalir. Resa chuy resa loh mo wol Iconium. ");
INSERT INTO uli_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yesa rraey lal deper chotugul kowe wol Antioch ngo ye mel Espritu Santus uwor. ");
INSERT INTO uli_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ye wol iye sengal chog mala ye weldoh mo woal Iconium. Paulus mo Barnabas re loh irel imwel ttey we resala foloy iyang. Ye cholop Gentiles mo Jews le re weg re sala mel bo chotugul irel foloy kowe yar. ");
INSERT INTO uli_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Iwe ngo Jews kowe te weg deper, resa hassongar Gentiles kowe bo rebe fedeg ngalir chotugul kowe. ");
INSERT INTO uli_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ye ssulay yar mel apostel kowe wol fuluwe le ye kkel yar foloyu kofal Samol. Ngo Samol ye hallehaloh le ye katos mokwe re sosor, irel molwe ye fang kkeler bo rebe ffaor kkemal. ");
INSERT INTO uli_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Resa hamhela chol haplom we; sibis re ppilir Jews ngo sibis re ppilir apostel kowe. ");
INSERT INTO uli_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Resa chufengal sibis Gentiles mo Jews kowe mo mal kowe yar resa ppil fengal bo rebe hetalngalir ngo re hacchifir apostel kowe. ");
INSERT INTO uli_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Molwe apostel kowe rela rongrong molwe re bele foru ngo resa haw resa loh wol Lystra mo Derbe we ye mel wol Lycaonia, iwe mo fulu kowe ye tebalililoh Lycaonia. ");
INSERT INTO uli_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Re sala foloyu Hapatpat Momay we mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ye mel semal mal woal Lystra le ye mes mekla pechel, le yela subdoh chog ngo faesul ila sengal. Tedyor fael sew le ye mmal le yebe darloh. ");
INSERT INTO uli_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ye maroro loboswe yesa tetalenga foloy kowe yael Paulus. Paulus ye gola le mal we yesa chepar, iwe ngo be yoh le be chuy yal tomay. Iwe yesa kal ngali, ");
INSERT INTO uli_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ngo yesa kangalu le ye hapallingi yalol le ye sor bo, “Su weldah!” Sa lutdah mal we ngo sa chaep yal darfedal. ");
INSERT INTO uli_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Yodwe buwa we rela wiri molwe Paulus yesa foru, ngo yesa chaep yar tetawul ngo re kapatpat le re yalol Lycaonia le re sor bo, “Resa bidiy deus kowe luwuluch le resa igegelirloh yarmat!” ");
INSERT INTO uli_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Resa hadeda Barnabas bo iy Zeus, ngo re hadeda Paulus bo iy Hermes, bo fael mala iy mele metal yalor. ");
INSERT INTO uli_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Semal temarong kowe ma mepel ngal todeb we rema sor bo Zeus, we ye mel templum we yal lugul chog haplom we, yesa kak doh floras mo semal mo semal karbow mo matal hatmal yoror we. Temarong we mo buwa we ngo re dipli le rebe fang maligach ngalir apostel kowe. ");
INSERT INTO uli_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Yodwe Barnabas mo Paulus rela rongrong molwe chowe resa luluwaley bo rebele foru, ngo resa hamesreyi mokwe mengagur ngo resa hamdalong luwul buwa we ngo resa tettawul le re sor bo, ");
INSERT INTO uli_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Meda mele hala foru mele iye sengal iyang? Hamem ila, hamem yarmat le tappel chog hami! Ha budoh habe foloyu Hapatpat Momay we ngalugmi, bo habe wigdi dipmi tang meka tor pelal bo habe tagul ngal Deus la yema fang molow. Iy mele ye foru laeng mo talop, mo taed mo pangal meka ye mel iyang. ");
INSERT INTO uli_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Muswe ngo ye tahacher yarmat bo sibis ngo re loh lufulyer. ");
INSERT INTO uli_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Iwe ngo ye kekallehaloh chog yal mel irel meka ye momay le ye foforu: yema fang ngalugmi potog la ye bidiy mo wol laeng; ngo yema fang yami fedah, ngo yema fang halmi mongoy, ngo ye harraeyi lal dipmi.” ");
INSERT INTO uli_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Molwe mwo iwe sengal hapatpat kowe re kangalur yarmat, ngo ye memeal chog le towe mmal ngalir apostel kwe le rebe hapolahor yarmat mo irel yar fang maligach ngalir. ");
INSERT INTO uli_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ye mel sibis Jews le re budoh mo woal Antioch we ye mel woal Pisidia, ngo sibis re re budoh mo woal Iconium. Resa weged depel buwa we ngalir, resa hasi resa hacchifi Paulus, resa yurawey mo lugul haplom we le re kachog bo yesa mes. ");
INSERT INTO uli_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yodwe chotugul kowe resa ttey ngali ngo yesa chemdah, yesa tefael long wol haplom we. Yela rallawe seral ngo resa chufengal mo Barnabas resa loh woal Derbe. ");
INSERT INTO uli_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulus Mo Barnabas re foloyu Hapatpat Momay we woal Derbe ngo ye cholop choluwar le resa weg ngalir. Iwe resa tefael loh woal Lystra mo Iconium, iwe ngo resa moch loh woal Antioch we ye mel woal Pisidia. ");
INSERT INTO uli_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Resa hakkela lal deper chotugul kowe bo rebe mel le re kkel fael yar tugul. Resa foloyu ngalir le re sor bo, “Ye cholop weres kala sibe bulong luwulul mo imol mala sibe hola mala Lamliyel Deus.” ");
INSERT INTO uli_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Resa hatugulu tamol sew mo sew Eklesia kawe, iwe ngo luwul yar mapel mo yar supiy haler bo yar maligach, ngo resa hatobtob rechoka ngal Samol le ir re yetedah deper uwol. ");
INSERT INTO uli_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Wol miril yar loh woal sew mo sew mokwe haplamol Pisidia ngo resa budoh woal Pamphylia. ");
INSERT INTO uli_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Resa budoh foloyu hapatpat we mo Perga ngo resa chuy resa loh woal Attalia, ");
INSERT INTO uli_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","iwe ngo re sala terag mo iyang resa tefael ngal Antioch. Ila loboswe ye yoh ngalir haradiya we yael Deus mo iyang, sala yoh bo rebe foru yengang ka re moch hamallo. ");
INSERT INTO uli_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Yodwe rela budoh woal Antioch ngo resa hatteyili fengalir yarmetael Eklesia we, ngo resa kangalur pangal mokwe Deus yesa tipingi ngalir bo rebe foru mo sangsengal yal foru bo Gentiles rebe chepar. ");
INSERT INTO uli_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Iwe ngo ye ssulay yar mel irer chotugul kowe. ");
INSERT INTO uli_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Sibis mal re bidiy mo woal Judea resa budoh woal Antioch. Iwe ngo yesa chap yar foloyu ngalir chotugul kowe le re sor bo, “Towe yoh le hami habe daor le habe te hagil le be tappel molwe Hatobtob we yael Moses ye sor.” ");
INSERT INTO uli_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulus mo Barnabas resa hachocho ngalir rechokwe irel kofal molwe. Yela wol miril ngo resa hatugulu le Paulus mo Barnabas mo tot mal kowe yar woal Antioch, rebe bidah Jerusalem bo re bela tefael mo irer apostel kowe mo mal kawe yar irel kofal molwe. ");
INSERT INTO uli_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Eklesia we mele ye hafengarloh; irel yar loloh luwul Phoenicia mo Samaria ngo re kekangalur yarmat yar Gentiles sa weg ngal Deus; mele kaptal war ye harraeyiloh lal deper panger chotugul. ");
INSERT INTO uli_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Rela hola doh Jerusalem ngo Kristiano kowe mo apostel kowe mo mal kowe yar resa hammaler, iwe ngo ir resa kapta war ngalir, irel lepal mokwe resa foru fael yalol Deus. ");
INSERT INTO uli_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tot chotugul kowe choluwar Pharisees kowe resa sudah ngo resa sor bo, “Gentiles kala ila rebe hagil ngo sibe kangalur bo rebe wol dabey Hatobtob we yael Moses.” ");
INSERT INTO uli_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mal kowe yar mo apostel kowe resa ttey fengal bo rebe kapta kofael molwe. ");
INSERT INTO uli_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wol miril yar rol kapta kofal molwe ngo yesa sudah Pedrus ngo yesa sor bo, “Re wol bisiy, ha faesul gola we sa ssulay yael Deus duwleyey mo luwulumi bo iy bela foloyu Hapatpat Momay le ngalir Gentiles bo rebe rongrong bo rebe chepar. ");
INSERT INTO uli_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Iwe ngo Deus we ye gola yar panger yarmat luluwal, ye hallehaloh yal dipli le Gentiles ka rebe chepar irel yal fang ngalir Espritu Santus, le ye wochog yal fang ngalgich. ");
INSERT INTO uli_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yete faor gich le sibe diltangir; iwe ngo ye hachuya molfidir le fael mala re chepar. ");
INSERT INTO uli_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ila ngo meda fal le la igla ngo hasa luluwaley le habe hagla Deus irel yami haweresi ngalir chotugul mekla gich mo chapdoh kowe yach ngo te mmal ngalgich? ");
INSERT INTO uli_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ha ligdir! Gich siya chepar, ila siya daor irel haradiya we yael Samol Jesus. Ila be wol ila sengal ir.” ");
INSERT INTO uli_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Panger buwa we ngo re tay maliliy, resa taelenga yael Barnabas mo Paulus kangalur pangal kkemal kowe resa foru fael yalol Deus mo luwulur Gentiles. ");
INSERT INTO uli_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Yodwe rela mol irel yar hapatpat ngo sa maliliy James le ye sor bo, “Ha taelenga, re wol bisiy! ");
INSERT INTO uli_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon yesa hamdefa sangsengal yael Deus metamol kawraloh yal hafalir Gentiles, irel yal kak lol yarmat mo luwulur. ");
INSERT INTO uli_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mokwe yalor profeta kowe ila, ye ppalu ngal mele. Ila molwe babior we ye santus we ye sor bo, ");
INSERT INTO uli_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Wol miril mele ngo ibe tefael, yael Samol sor, ngo ibe hatefali molwe lamliyel David. Ibe foru tefaeli pangal mekla ye towas, ngo ihakkela bo yebe kkel fael sew. ");
INSERT INTO uli_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Iwe ngo bele pangerloh yarmat ngo re bele tefael ngalyey. Panger Gentiles kowe isa fesangur bo rebe mel bo layi ngo rebe budoh. ");
INSERT INTO uli_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ika meka yalol Samol le muswe chog ngo yesa kangalur yarmat bo rebe gola.’” ");
INSERT INTO uli_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","James yesa taboloh yal hapatpat le ye sor bo, “Yai luluwal ila si towe haweresir Gentiles ka resa weg ngal Deus. ");
INSERT INTO uli_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Sibe far tefa sew babior sibe kangalur bo re towe ma mongoy, mongoka ye tungaf bo resa tap maligach ngal liyos kala rema mapel ngali, iwe ngo rebe hachuyar mo luwul maltemay. Iwe ngo re towe ma mongoy ccha hare mael ka ye mes le rete hacheloh cchal bo re fargu yual, hare re fingdi yual. ");
INSERT INTO uli_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bo Hatobtob we yael Moses iwe sa ssulay yar ma yawliloh chog pangal Sabbath mo lal imwel ttey kowe, iwe ngo re foloyu mokwe yalol wol pangal haplom.” ");
INSERT INTO uli_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Iwe apostel kowe mo mal kowe yar mo pangerloh chol Eklesia we resa hatugulu bo rebe duwley fedmal mal mo luwulur bo rebe dabeloh Barnabas mo Paulus woal Antioch. Re duwler rumal mal le re ssor mo luwulur chotugul kowe le Judas we rema fesangu bo Barsabbas, iwe mo Silas, ");
INSERT INTO uli_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","iwe ngo resa ngaler sew babior bo rebe hasi. Babior we ye sor bo, “Hamem apostel ka mo mal ka le hamem wol bismi, hasa fang yamem habong ngalugmi pangmi Gentiles kala ha mel wol Antioch, mo Syria, mo Cilicia. ");
INSERT INTO uli_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Hasa rongrong le sibis yarmat re buyoy iremi, le re chuy mo iremem resa buyoy, iwe resa hatarporpahmi irel mekla re sor; tor mele hamem ha kangalur bo rebe buyoy kangalugmi. ");
INSERT INTO uli_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Iwe hamem hasa ttey fengal ngo hasa hatugulu bo habe duwley fedmal hamem bo rebe hasi ngalugmi mele yalomem. Ir ila re bele dabewey Barnabas mo Paulus le wol maryarmem le re chang. ");
INSERT INTO uli_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paulus mo Barnabas ila re tay hafaliloh yar ngas irel yengang ka yael Samol Jesus Kristus. ");
INSERT INTO uli_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ila hamem hasa hafengawey Judas mo Silas bo rebe spegil kangalugmi pangal meka hasa tefadiy lal babior. ");
INSERT INTO uli_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ye fel mo irel Espritu Santus, ngo yesa wol fel mo iremem hamem le ha towol haweresugmi le yebe kkel tangi hatobtob ka hami habe faesul dabey: ");
INSERT INTO uli_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ha towe mongoy, mongoka resa tap maligach ngal liyosol todep ka rema mepel ngalir; ha towe mongoy ccha; ha towe mongoy mael ka re mes le re fingdi uyer ngo rete hacheloh cchar; iwe ngo hasa hachuyahmi mo luwul maltemay. Habe rol fel igle ha yedamgel bo ha towe foru meka. Sa ila ngalugmi.” ");
INSERT INTO uli_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Resa loh mokwe re kekal yalor yee, rela budoh woal Antioch ngo resa hateyili fengalir chotugul kowe ngo resa ngaler babior we. ");
INSERT INTO uli_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Molwe yarmat rela yawli babior we ngo resa rraey irel hapatpat we ye hakkela lal deper. ");
INSERT INTO uli_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas mo Silas we rumal profeta ila ye ssulay yar hapatpat ngalir yarmat bo yebe kkel deper. ");
INSERT INTO uli_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Wol miril yael Judas mo Silas mel tot irer, ngo chotugul kowe resa habungur ngo resa halahor luwul hapos. Iwe Judas mo Silas resa tefael loh irer rechokwe re hafengardoh. ");
INSERT INTO uli_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus mo Barnabas ye ssulay tot yar mel woal Antioch. Ir mo wol tot chotugul kowe ngo re fofoloyu ngalir yarmat mala yalol Samol. ");
INSERT INTO uli_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Yela ssulay loh tot mo wol miril ngo Paulus sa kangalu Barnabas bo, “Si bele tefael loh woal pangal haplom kowe si foloyu molwe yalol Samol mo iyang, bo si bela tefael mo irer mokwe wol bisich ngo si gula hare sa ifa sengal yar memel.” ");
INSERT INTO uli_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas ye dipli bo John Mark yebe daber, ");
INSERT INTO uli_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","iwe ngo Paulus ye chichiy ngo ye tafel le yebe daber bo te mel ngalir yee, rela hammalo malekah we yar bo ye ligdir loh mo wol Pamphylia sa tefael. ");
INSERT INTO uli_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Iwe resa hachocho fengal le ye kkel, iwe resa mehal: Barnabas yesa hasi Mark resa terag resa loh Cyprus, ");
INSERT INTO uli_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","iwe ngo Paulus sa duwley Silas resa loh ngo chotugul kowe resa memapelar ngal Samol bo yebe hafallir. ");
INSERT INTO uli_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Yesa loh woal Syria mo Cilicia sala hakkela lal deper chotugul kawe iyang. ");
INSERT INTO uli_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus sa loh woal Derbe mo Lystra le ye mel semal Kristiano iyang le Timothy mala idal. Mala sil ila semal Jews ngo sa wol Kristiano. Iwe ngo mala temal ila semal re Greek. ");
INSERT INTO uli_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Panger chotugul kowe re mel wol Lystra mo Iconium ngo re gola le Timothy ila iy semal yarmat le ye momay. ");
INSERT INTO uli_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus ye dipli le yebe hasi Timothy bo choluwar, iwe yesa hagilla. Ye foru mele le fael mala panger Jews kowe re mel woal fulu kowe ngo re gola le molwe temael Timothy ila semal re Greek. ");
INSERT INTO uli_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Irel yar loloh irel sew mo sew haplom ngo rema kangalur chotugul hatobtob kowe apostel kowe mo tamol Eklesia kowe re mel Jerusalem resa hatugulu. Iwe ngo rema kangalur yarmat bo rebe dabey hatobtob kowe. ");
INSERT INTO uli_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Iwe yesa kkel loh Eklesia kowe ngo pangal ral ngo re chocholop loh chog chotugul. ");
INSERT INTO uli_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Resa darsupiloh mokwe faluyel Phrygia mo Galatia bo te depel Espritu Santus le rebe foloyu mokwe yalol Samol woal meka faluyel Asia. ");
INSERT INTO uli_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yodwe rela hola molwe hasisiyal Mysia, ngo resa memeal le re bele loh wol mele faluyel Bithynia, iwe ngo te depel Espritu Santus. ");
INSERT INTO uli_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Iwe resa taboloh malekah we yar mo woal Mysia resa loh woal Troas. ");
INSERT INTO uli_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lubungul ralla ngo yesa llah ngal Paulus semal yarmetal Macedonia, le ye su sa kekefael pechey le ye sor bo, “Budoh woal Macedonia bo hobe tupungugmem!” ");
INSERT INTO uli_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Yodwe chog Paulus ye wiri yeramtawe ye llah ngali ngo hasa haliliy bo ha bele loh woal Macedonia, bo hasa hatugulu mo lal depmem le Deus yesa fesangugmem bo ha bela foloyu Hapatpat Momay le ngalir rechokla wol Macedonia. ");
INSERT INTO uli_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hasa dabey barko mo woal Troas hasa terag hasa loh woal Samothrace, yela rallawe seral ngo hasa loh Neapolis. ");
INSERT INTO uli_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Hasa chuy mo iyang hasa bulong lufuluy yee, hala hola Philippi, sew haplom le ye mel woal molwe faluyel Macedonia. Philippi ila yarmetael Roma mele re hasohsoh iyang. Ha sala mel mwo iyang woal fedral. ");
INSERT INTO uli_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Yela Sabbath ngo hasa chuy mo luwul hasohsoh hasa buyoy wol ngachel sew mololul, solboy le ha kkachog bo Jews kowe rebe ttey fengal mo iyang bo rebe mapel. Hasa marodiy, hasa kapatpat ngalir fefel kowe re ttey doh lobowe. ");
INSERT INTO uli_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Semal rechokla ye rongrong yamem fofoloy ila Lydia, idal le ye budoh mo wol Thyatira. Yema tap chuway mengag kowe ye purple dolal. Iy semal fefel le ye hasrowu Deus, ngo Samol ye hatarma bo yebe taelenga hamayu mokwe Paulus ye sor. ");
INSERT INTO uli_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Yela wol miril yodwe iy mo mokwe chol yal mel resa rol baptismus, ngo yesa dengag hamem le ye sor bo, “Ha budoh ha bela mel irel imw la imwey igle sa tugul mo iremi le ngang yesa tugul lal depey ngal Samol.” Yesa hakkela ngalugmem chog bo habe roloh. ");
INSERT INTO uli_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Seral le ha loloh lobowe yarmat rema mepel iyang, ngo ha sala chungu semal lefechig le semal slave le yor moniyan uwol. Yema yoh le yebe sor kofal meka yema weldoh. Ye cholop salpiy le yesa yoh ngalir rechokla re yusuwiliy lefechig we le paliyel mekla yema kangalur yarmat irel kofer luwul walsu mo wattalngel. ");
INSERT INTO uli_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yesa dabey fedalehmem mo Paulus le ye tetawulagili le ye sor bo, “Rechoka ila ir re haforol yalol Deus le ye Hartal Tagiyet. Re kekangalugmi hare be ifa sengal ngo hasa daor!” ");
INSERT INTO uli_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Fedbong loh yal foforu mele ngo sa ssong Paulus, sa tagul tefael ngo sa kangalu moniyan we bo, “Irel mala Idel Jesus Kristus ngo isa kangalug bo hobe chuy mo uwol fefel la!” Yodwe chog ngo moniyan we yesa chuy mo uwol fefel we. ");
INSERT INTO uli_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Yodwe chog rechokwe re yusuwili fefel we rela gola le towol yoh ngalir salpiy mo irel fefel we, ngo resa ddorfi Paulus mo Silas resa yururloh irer tamol kowe irel lobowe rema ttey yarmat iyang. ");
INSERT INTO uli_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Resa hasirloh imor tamol Roma kowe ngo resa sor bo, “Rechoka ila ir Jews ngo resa kketaropropar yarmat wol mele haplamoch. ");
INSERT INTO uli_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Resa fofoloyu meka kkor le te palu ngal hatobtob ka yach; gich yarmetal Roma le si tapper chog rechokla re mel wol Roma, ngo towe yoh le sibe dabey hare si foru meka re sosor!” ");
INSERT INTO uli_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iwe buwa we resa daber resa lliy Paulus mo Silas. Iwe tamol kowe resa mesreyi mokwe mengagol Paulus mo Silas ngo resa sor bo rebe wwodur. ");
INSERT INTO uli_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Yela wol miril yar saldaw kowe wwodu Paulus mo Silas le ye kkel, ngo resa hasir resa ppedir long lal kalbus, iwe ngo resa kangalu re matmetal kalbus we bo yebe hammal hamayu yal loka kalbus we. ");
INSERT INTO uli_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wol miril yar kangalu re matmetal kalbus we meka, ngo iy yesa yitilir long lal singgil we ye hartal ketab long yilim, iwe ngo yesa fargu mokwe pecher llepadpedal tot petal ire kowe ye cchow. ");
INSERT INTO uli_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yela lugulbong ngo Paulus mo Silas re memapel ngo re toton ngal Deus, iwe ngo chol kalbus kowe tot re tetalengar. ");
INSERT INTO uli_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Re tedaploh ngo sa falmor, ngo yesa yuchuchgegloh kalbus we mo loboswe ye mel iyang. Yodwe chog ngo sa sugegloh pangal hatmal kalbus we, ngo sa ttalich loh chen kowe mo uwor panger chol kalbus kowe. ");
INSERT INTO uli_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Yela mmatdah re matmetal kalbus we sala wiri mokwe hatmal kalbus we le yesa sugegloh, ngo ye kachog hare resa ddar chol kalbus kowe. Iwe yesa yuldadah sayden we lol ngo sa memeal le bele iy chog yal limeseloh. ");
INSERT INTO uli_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Iwe ngo Paulus yesa ttawul le sa hartaloh lepal yalol, “Ho towe limesegloh! Pangmem ngo ha chil mel iga!” ");
INSERT INTO uli_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Re matmetael kalbus we sa dongor hatawrel ngo yesa hamdalong sa ppung hasubgudiy mo imol Paulus mo Silas le yesa rerer. ");
INSERT INTO uli_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Iwe ngo yesa palirwey mo ligtam ngo yesa kasiyar bo, “Meda mele ibe foru ngo isa daor?” ");
INSERT INTO uli_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ngo ir resa sor bo, “Hobe chepar ngal Samol Jesus ila ngo hobe daor — gel mo chol yam mel.” ");
INSERT INTO uli_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iwe ngo resa foloyu molwe yalol Samol ngali, iwe mo panger rechokwe re mel lal imw we. ");
INSERT INTO uli_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yodwe chog ngo re matmetal kalbus we yesa palir yesa hadudu mokwe ye was mo uwor iwe ngo iy mo chol yal mel ngo resa baptismus chog irel yodle. ");
INSERT INTO uli_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Iwe ngo yesa hasiloh Paulus mo Silas irel imw we imwal ye sala fang haler mongoy. Ir fengal mo chol yal mel ngo resa rraey bo fael mala sa tugul lal deper irel Deus. ");
INSERT INTO uli_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Yela lemaliyelel rallawe seral ngo tamol Roma kowe resa fangloh police le re kangalur bo, “Hala hachuyar mal kowe mo lal kalbus.” ");
INSERT INTO uli_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Iwe ngo re matmetal kalbus we sa kangalu Paulus bo, “Tamol kowe resa fang yalor le gel mo Silas ngo hasa tal. Hale loh luwul hopos.” ");
INSERT INTO uli_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Iwe ngo Paulus yesa kangalur police kowe bo, “Tor tayikof le ha foru ngo resa wwodugmem mo imwol pangal yarmat. Ngo hamem ila yarmetal Roma! Resa ppedugmem long lal kalbus iwe ngo la igla, ngo resa sor bo re bele fangloh chog hamem le tor loh le be gola. Towe yoh! Ir tamol Roma kala mele rebe spegil budoh iga bo rebe hachuyahmem.” ");
INSERT INTO uli_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Police kowe resa loh re sala kangalur tamol Roma kowe mokwe yalor; Iwe ngo molwe rela rongrong le Paulus mo Silas ila wol ir yarmetal Roma ngo sa kkel yar motog. ");
INSERT INTO uli_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Iwe resa loh re sala hafael pecher ngo re hachuyar mo lal kalbus, iwe ngo resa kangalur bo rebe chuy mo wol haplom we. ");
INSERT INTO uli_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Sa chuy Paulus mo Silas mo lal kalbus resa loh irel imw we imwel Lydia re sala rol werfengal mo chotugul kowe iyang; Resa hapatpat ngalir bo yebe kkel lal deper. Iwe ngo resa ligdir resa loh. ");
INSERT INTO uli_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulus mo Silas resa taboloh malekah we yar woal Amphipolis mo Apollonia yee, rela budoh woal Thessalonica, le ye mel sew imwel ttey iyang. ");
INSERT INTO uli_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Yesa loh Paulus irel imwel ttey we. Mele ila sew formel le yema faesul foru. Ila lobola ye ttey ngalir yarmat mo iyang irel suluw bungul Sabbath. Yesa kangalir yarmat mokwe yadol Babior we ye Santus. ");
INSERT INTO uli_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ye yawli ngo ye hamdefa mokwe yadol Babior we ye Santus, we ye hatosiya ngalir yarmat le Kristus ila yebe loh luwul hafohoy ngo yebe molow tefael mo irel maes. Paulus yesa kangalur bo, “Iy Jesus le ikekangalugmi kofal ila, Iy mele Kristus.” ");
INSERT INTO uli_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tot ir resa chepar resa dabey Paulus mo Silas; wol ila senger tot fefel kowe re tagiyet wol yar mel, iwe mo sibis re Greek kowe re hasrowu Deus, bo resa wol daber. ");
INSERT INTO uli_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Iwe resa loltemay Jews kowe ngo resa hateylir sibis rechokwe tor mele rema toangali ngo rema susu fedal chog lal yalap resala sew buwa. Iwe buwa we resa hatrongardah chol haplom we bo rebela hatawsilong imwel semal mal le Jason idal bo rebe meri Paulus mo Silas bo rebe hasirwey irer chol tteydoh kowe. ");
INSERT INTO uli_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ngo molwe rela tuwirir, ngo resa yurawey Jason mo tot chotugul kowe resa hasirloh imol tamol haplom we ngo resa tawulagili le re sor bo, “Mal ka ila pangal lobos le re loh iyang ngo re hasidoh tayikof iyang! Iwe ngo igla iye resa budoh wol mele haplomoch. ");
INSERT INTO uli_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iwe ngo Jason yesa hasi chog yesa yitilir lal imw la imwal. Ila panger rechoka ngo resa rol hatawsi hatobtob kowe yael Llulupal Tamol we, bo re sor le ye wol mel semal king le Jesus mala idal.” ");
INSERT INTO uli_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Molwe re sor mele ngo yesa hatrongardah buwa we mo makawe tamol haplom we. ");
INSERT INTO uli_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tamol kowe resa hakkela ngal chog Jason mo ikowe sibis bo rebe fang yee, rela fang lepal salpiy la ye faesul tugul le rebe fang ngo resa moch tal. Iwe ngo resa tahcher bo rebe loh. ");
INSERT INTO uli_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yela lefhafdoh chog ngo chotugul kowe resa hafengaloh Paulus mo Silas woal Berea. Re hola Berea ngo resa loh irel imwel ttey we. ");
INSERT INTO uli_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Iwe ngo rechokwe re mel lobowe ila ye teram sugfed yar luluwal mo imor ikowe re mel woal Thessalonica. Resa rol talenga hamayu foloy kowe luwul yal cchang lal deper. Iwe ngo pangal ral ngo rema kay mokwe yadol Babior we ye Santus bo rebe gola hare ye katos mokwe Paulus ye sosor. ");
INSERT INTO uli_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ye cholop Jews le resa chepar; iwe ngo ye cholop fefel Greek kala re tagiyet wol yar mel mo woal haplom we le resa chepar, ngo ye cholop mal Greek le resa wol chepar. ");
INSERT INTO uli_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Iwe ngo yodwe Jews kowe wol Thessalonica rela rongrong le Paulus yesa fofoloyu molwe yalol Deus wol Berea, ngo resa loh re sala hatrongardah yarmat mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yodle chog ngo chotugul kowe resa hahwadiy Paulus mo metal fulu; iwe ngo Silas mo Timothy re mel tefael woal Berea. ");
INSERT INTO uli_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mal kowe re hasiloh Paulus ila re dabey yee, rela hola Athens. Iwe ngo resa tefael ngal Berea re sala kangalu Silas mo Timothy le Paulus ye sor bo yebe mmal chog sew yad ngo resa meriloh. ");
INSERT INTO uli_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Yodwe Paulus ye wiwidi Silas mo Timothy woal Athens, ngo sa weresloh chog lal depal irel molwe yela wiri lepal yal cholop liyosel todeb wol haplom we. ");
INSERT INTO uli_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Iwe resa budoh hapatpat mo lal imwel ttey kowe yar le ir mo Jews mo Gentiles kowe re hasrowu Deus. Iwe ngo pangal ral ngo rema rol ttey fengal mo lobowe yarmat rema toa ttedoh iyang, iwe resa rol hapatpat mo rechoka rema budoh iyang. ");
INSERT INTO uli_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Iwe ngo sibis sensel Epicurean mo sibis sensel Stoic re wol hachocho ngali. Sibis ir re kasiy le re sor bo, “Meda mele mael habos le tor golayal ye luluwaley le yebe sor?” Ngo sibis ir resa sor bo, “Ye wochog bo ye kekapta todeb kala layur chol fuluy kala tot.” Re sor mele le mil molwe Paulus ye fofoloyu kaptal Jesus, mo kaptal molow tefael mo irel maes. ");
INSERT INTO uli_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Iwe resa hasi Paulus resa hasiloh irel ttey we rema sor bo Areopagus, we yar tamol haplom we ngo resa sor bo, “Ha dipli le habe gola kofal foloy le ye tefoy le gel ho kekapta kofal. ");
INSERT INTO uli_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tot mekla hasa rongrong le ho sosor ila moch iye yamem rongrong. Iwe ngo ha dipli le habe medaf iyang.” ");
INSERT INTO uli_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Pangerloh yarmetal Athens mo panger rechokla re memel iyang ngo rema dipli le rebe kapta, ngo re taelenga meka moch weldoh le ye tefoy.) ");
INSERT INTO uli_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Sa sudah Paulus mo imor chol ttey we ngo sa sor bo, “Isa wiri le hami yarmatael Athens ila ha itol dipmi irel yami hasrowu lomi todeb irel yami memel. ");
INSERT INTO uli_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bo irel yai dedar fedal luwul haplom mo yai kekamahoy loboka hama mepel mo iyang, ngo iwiri sew altar le ye teftaf iyang bo ‘Yael Deus la si tugla.’ Mala ha kekasrowu le ha togla, ila iye iy mala ngang ikapta kofal ngalugmi. ");
INSERT INTO uli_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Deus la ye foru faileng le mo pangal meka ye mel iyang, ila iy mele Samol woal laeng mo wol talop le. Ngo ye tema mel lal templum ka foriyel yarmat. ");
INSERT INTO uli_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Iwe ngo tor mele iy yebe mmali mo irel meka gich yarmat si foforu, bo iy mele ye fang molow, mo ngas, mo pangal formel ngalir pangal yarmat. ");
INSERT INTO uli_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ye foru pangal daodol yarmat mo irel semal chog yarmat. Ngo yesa foru le rebe hasoha pangal loh faileng le. Iy yesa faesul hatugulu yodol yar be mel mo sisiyal lobokla rebe mel iyang. ");
INSERT INTO uli_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ye foru mele bo hare ir rebe meri fedaley, bo hare luwul yar memeri fedaley ngo rebe wiri. Iwe ngo Deus ila yete ddaw tang semal mo semal gich; ");
INSERT INTO uli_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ila sengal molwe semal yarmat ye sor, we ye sor bo, ‘Iy mele si molow, ngo si mel, ngo si tetagul fedal lal paol.’ Ila sengal molwe sibis chol forel ton kowe yami re sor: ‘Gich lol.’ ");
INSERT INTO uli_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Iwe ngo mala gich lol Deus ila si towe luluwaley le Deus ila ye igegel liyos kala ye faor mo irel hol hare silver hare feas, le salepal yarmat ngo foriyel paol yarmat. ");
INSERT INTO uli_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Yod kowe yarmat re togla iy Deus, ila iy yesa hachuya mo lal yal luluwal. Ngo la igla ngo yesa kangalur panger yarmat bo rebe tagul tang pangal wegdegel moniyan. ");
INSERT INTO uli_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bo iy yesa faesul hatugulu rralla yeramtale iy yesa duwley yebe hatugulu kofer re talop. Iwe ngo yesa hatosiya mele ngalir yarmat irel molwe ye hamolowa iy mal la mo irel maes!” ");
INSERT INTO uli_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Yodwe re rongrong yael Paulus foloyu kaptal molow tefael mo irel maes, ngo sibis ir resa maligili. Iwe ngo sibis re sor bo, “Ha dipli le gel hobe kapta tefaeli kaptal meka fael sew.” ");
INSERT INTO uli_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Iwe ngo Paulus yesa ligdi ttey we. ");
INSERT INTO uli_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Sibis ir resa dabey le resa chepar. Ye mel Dionysius luwulur le iy semal chol ttey we yar tamol. Iwe ngo ye mel semal fefel le Damaris idal, iwe mo wol sibis yarmat le resa daber. ");
INSERT INTO uli_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yela wol miril mele ngo Paulus yesa chuy mo Athens yesa loh woal Corinth. ");
INSERT INTO uli_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ila lobola yela chungu semal Jews le Aquila idal le ye sub mo wol Pontus. Re moch budoh mo mala ril, le Priscilla idal mo wol Italia, bo Llulupal Tamol we Claudius sa fang yalol bo pangerloh Jews ngo rebe chuy mo wol Roma. Paulus ye loh bo bela tefael mo irer, ");
INSERT INTO uli_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","iwe sala mel mwo irer ngo ye daber irel yengang. Bo iy ila ye wochog rechoka le yema yoh ngalir salpiy bo hammaler mo irel yar ma ffaor tento. ");
INSERT INTO uli_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pangal Sabbath ngo yema kapatpat ngalir yarmat mo lal imwel ttey kowe yar le ye yedamgili bo Jews mo Greeks ngo rebe chepar ngali irel mekla ye sosor. ");
INSERT INTO uli_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Yodwe Silas mo Timothy rela dohdoh mo woal Macedonia, ngo yesa ma pangal yad ngo Paulus ye foloyu chog molwe kaptal Kristus le ye hatosiya ngalir Jews kowe le Jesus mele Kristus. ");
INSERT INTO uli_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Yodwe re hapaliyel ngali ngo re hapatpat tayikof loh irel, ngo iy yesa tagul chog sa yuchgaloh bbol fuluwe mo irel mokwe mengagol ngo yesa kangalur bo, “Hare hala mwael loh, ngo hami mele dipmi. Te ngang mele yai haffaor. Bo ngang ila bele chap igla sa loh le ibele tagul ngalir Gentiles.” ");
INSERT INTO uli_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Iwe yesa ligdir sa loh sala mel irel sew imw le imwel semal Gentile le Titus Justus mala idal. Mal le ila semal yarmat le ye hasrowu Deus. Imw la imwal ila ye harpa chog imwel ttey we yar. ");
INSERT INTO uli_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus we tamol imwel ttey we ila ye chepar irel Samol le iy fengal mo wochol yal mel. Iwe ngo ye wol cholop yarmat woal Corinth le re rongrong foloy kowe ngo re chapar iyang, iwe resa baptismus. ");
INSERT INTO uli_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lefhafel seral ngo Paulus yesa ddelagili le Samol ye kangalu bo, “Ho towe motog. Taboloh chog yam foloy le ho towe poloh, ");
INSERT INTO uli_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","bo ngang imel irem. Tor semal le be yoh le yebe llug bo ye cholop yarmat wol haplom le le layi.” ");
INSERT INTO uli_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iwe Paulus yesa mel wol haplom we irel sew mo setab raeg le ye fofoloyu ngalir yarmat molwe yalol Deus. ");
INSERT INTO uli_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Yodwe Gallio yesa mel bo Amel Roma wol Achaia, ngo Jews kowe resa ttey fengal resa ddorfi Paulus resa hasiloh irel imwel tatelal hapatpat we. ");
INSERT INTO uli_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Iwe ngo resa sor bo, “Yeramtale ila yesa wiwigdi deper yarmat bo rebe hasrowu Deus. Meka yesa foforu ila ye tafel ngal hatobtob we!” ");
INSERT INTO uli_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulus yesa memeal le yebe maliliy ngo Gallio yesa kangalur Jews kowe bo, “Hare kaptael sew mekla ye kkel yal tayikof, hare sew makla ye tafel le yeramtale yesa foru mele si kekapta igla, ila ngo yor tot pelal le ibe halelayi repiyey ngalugmi Jews. ");
INSERT INTO uli_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Iwe ngo mele ha kachocho fengal irel kofal hapatpat, mo idel yarmat mo kofal yami hatobtob, ila hala salepa chog kofal lufulumi. Ngang itowe hatugulu kofal mekla ila sengal!” ");
INSERT INTO uli_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iwe ngo yesa ddaberwey mo lal imwel tatelal hapatpat we. ");
INSERT INTO uli_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Iwe resa ddorfi Sosthenes we tamol imwel ttey we, resa lliy mo metal imwel tatelal hapatpat we. Iwe ngo Gallio yete kekadagiloh mwo molwe. ");
INSERT INTO uli_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Sa mel tefael Paulus irer chotugul kowe woal Corinth le ye ssulay tot. Iwe ngo yesa ligdir sa terag le ye hasi Priscilla mo Aquila resa loh woal Syria. Imol molwe re bele chuy mo woal Cenchreae ngo yesa gurchaliloh molwe chemal le fael sew promise yal le ye foru. ");
INSERT INTO uli_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Rela budoh woal Ephesus, ngo Paulus sa ligdi Priscilla mo Aquila. Sa bulong lal imwel ttey we yar sala hapatpat ngalir Jews kowe re mel iyang. ");
INSERT INTO uli_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Rechokwe re mel iyang resa kangalu bo yebe mel tot irer, ngo iy yete dipli le yebe mel irer. ");
INSERT INTO uli_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Yefar kangalur bo, “Hare ila mele depel Deus, ngo ibe tefaeldoh iremi fael sew.” Iwe yesa chuy mo wol Ephesus, sa terag sa loh. ");
INSERT INTO uli_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Yodwe yela hola Caesarea, ngo yesa chuy sa loh woal Jerusalem sala habungur Kristiano kowe re mel iyang, iwe ngo sa chuy sa loh wol Antioch. ");
INSERT INTO uli_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Yela wol miril yal mel tot woal haplom we, ngo yesa chuy yesa loh woal mokwe faluyel Galatia mo Phrygia, sala hakkela lal deper Kristiano kowe re mel iyang. ");
INSERT INTO uli_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Irel yodla ngo yesa budoh semal Jews wol Ephesus le Apollos idal, ngo ye sub mo woal Alexandria. Iy semal yarmat le ye sallap irel hapatpat, ngo ye wol sallap irel kaptael Babior we ye Santus. ");
INSERT INTO uli_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ila mwo kofal chog baptismus we yael Johannes mele ye gola ngo resa haskuna ngali foloy kowe yael Samol. Iwe ngo luwul yal cchehas lal depal ngo yesa kaptaloh ngo ye foloyu mala halongol kofal Jesus Kristus. ");
INSERT INTO uli_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Iwe ngo sa chaep yal foloy mo lal imwel ttey kowe yar le ye tay motog. Yodwe Priscilla mo Aquila re rongrong chog yalol foloy kowe yal ngo resa hasiloh irel molwe bugter resa budoh hamdefa ngali molwe halongol kofal Deus. ");
INSERT INTO uli_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Iwe Apollos yesa hatugulu bo yebe loh woal Achaia. Iwe ngo chotugul kowe woal Ephesus resa tipingi le re teftaf loh babior woal Achaia, resa kangalur mokwe chiler bo rebe hammale. Yodwe yela holar iyang ngo ye palleng yal tipingir rechokwe sa tugul lal deper, le fael haradiya la yael Deus. ");
INSERT INTO uli_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yema halusurloh panger Jews kowe le rebe hapaliyel ngali mo luwul yarmat irel kkelel mekla yema sor. Bo iy yema hatosiya mo irel Babior we ye Santus le Jesus mele Kristus. ");
INSERT INTO uli_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Yodwe ye chil mel Apollos woal Corinth, ngo Paulus yesa dar chog woal fuluy yee, la budoh woal Ephesus. Yela budoh sala chungur sibis Kristiano, ");
INSERT INTO uli_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","iwe ngo sa kasiyar bo, “Ye bidiy Espritu Santus uwomi irel yodwe ha Kristiano iyang?” Ngo ir resa sor bo, “Hated rongrong mwo le yor mala Espritu Santus.” ");
INSERT INTO uli_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulus yesa kasiyar bo, “Ila ngo ifa sengal yami baptismus?” Ngo ir resa sor bo, “Ha baptismus le tappel baptismus we Johannes ye foloyu.” ");
INSERT INTO uli_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Iwe ngo Paulus yesa kangalur bo, “Baptismus we yael Johannes ila yar rechoka resa tagul tang molfidir; iwe ngo Johannes ye kangalur yarmetal Israel bo rebe chepar irel yeramtala yebe hamirdoh mo wol miril, le ila mala Jesus.” ");
INSERT INTO uli_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Molwe re rongrong chog mele ngo resa baptismus irel mala idel Samol Jesus. ");
INSERT INTO uli_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulus yesa yetedah paol uwor, iwe ngo yesa bidiy Espritu Santus uwor; ngo resa yalol sew mo sew fuluy le re kapta mokwe yalol Deus. ");
INSERT INTO uli_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Leper mal ka ila rebe seg mo rumal. ");
INSERT INTO uli_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Suluw meram le Paulus yema loh irel imwel ttey we yar. Iwe ngo yema hapatpat ngalir yarmat ngo ye kkel yal foloy le ye yeyedamgilir chog bo rebe chepar irel mala Lamliyel Deus. ");
INSERT INTO uli_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ngo ye mel sibis ir le ye kkef repiyer, le rete chepar. Iwe ngo imor panger chowe re tteydoh ngo resa hapatpat tayikofloh irel mekla Kofal Samol. Iwe Paulus sa fesangur chotugul kowe resa hawagilir rechokwe rete chepar. Iwe ngo sama pangal ral ngo ye ma foloy mo lal imw we Tyrannus yema haskun iyang. ");
INSERT INTO uli_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Lal loh ruwow raeg le iye sengal chog mele Paulus yema foru. Ila panger rechokwe re mel woal mokwe faluyel Asia, le Jews fengal mo Gentiles ngo re rongrong molwe yalol Samol. ");
INSERT INTO uli_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Deus yesa fang kamalal Paulus bo yebe faor kkemal kowe ye kkel. ");
INSERT INTO uli_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Handkerchiefs mo mengagol yengang kala yema teptap iyang ngo rebe hasiloh irer chotomay, ngo yema chuyloh yar tomay ngo ye chuy moniyan mo uwor. ");
INSERT INTO uli_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Sibis Jews le rema malekah fedal ngo re kkachuchuy moniyan mo uwor yarmat, ila re hagla yar tapeli mala idel Samol Jesus bo rebe foru mele. Re kangalur moniyan kowe bo, “Irel mala idel Jesus we Paulus yema foloyu kaptal, ngo chuy mo uwol yeramtala.” ");
INSERT INTO uli_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Fismol tarmal lol Sceva we Llulupal Temarong we yar Jews mele re foforu mele. ");
INSERT INTO uli_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Iwe ngo moniyan we yesa kangalur bo, “Igula Jesus ngo irongrong kaptael Paulus; iwe ngo hami, hami itey?” ");
INSERT INTO uli_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Iwe ngo mal we ye mel moniyan we uwol yesa tagul ngalir sa llir le ye kkel yal fedeg. Iwe ngo resa ddar mo irel imw le imwal le resa rol waes ngo ye mesrere fedal mokwe mengagur. ");
INSERT INTO uli_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Panger Jews mo Gentiles kowe re mel woal Ephesus ngo re rongrong kaptal mele; pangerloh ngo yesa kkel yar motog. Iwe ngo yesa kkel loh tot yal ssor molwe idel Samol Jesus. ");
INSERT INTO uli_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ye cholop chotugul kowe le re budoh resa kaptaloh luwul yarmat mekla ir resa foru. ");
INSERT INTO uli_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ye cholop rechokwe rema folus le re hateyilidoh babior kala yar resa fisgi mo imol yarmat. Rela hapcha paliyel pangal loh babior kowe ngo ye hola lemeg sangeras dolla. ");
INSERT INTO uli_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ye ttir yal kkel loh mo yal daoloh molwe yalol Samol irel kkalel molwe resa foru. ");
INSERT INTO uli_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Yela wol miril pangal meka ngo Paulus yesa hatugulu le bele loh woal pangal loh Macedonia mo Achaia, ngo yesa loh woal Jerusalem. Paulus yesa sor bo, “Bela wol miril yai loh woal Jerusalem, ngo isa loh bo ibela tefael mo wol Roma.” ");
INSERT INTO uli_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Iwe ngo yesa hafengaloh Timothy mo Erastus, le rumal mokwe re tipingiyal, bo rebe loh wol Macedonia, ngo iy yesa mel tot wol mokwe faluyel Asia. ");
INSERT INTO uli_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Irel yodle ngo yor mele ye weldoh woal Ephesus le fael foloy kowe kaptal Samol. ");
INSERT INTO uli_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Semal chol sussul parang kowe silver, le Demetrius mala idal le yema ffaor liyosol templum we yael deus fefel we Artemis. Iwe ngo yengang le yal ila ye cholop salpiy le yema yoh ngalir chol yengang kala lol. ");
INSERT INTO uli_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Iwe yesa hateyili fengalir chol yengang kowe yal mo wol sibis le ye kekafedeg yar yengang, ngo yesa kangalur bo, “Re mal, ha gola le ye palleng yach mmal mo irel yengang le. ");
INSERT INTO uli_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Iwe ngo igla ngo hasa spegil wiri ngo ha rongrong meka yeramtale Paulus sa foforu. Yesa sor bo deus ka foruyel paol yarmat ila te deus, ngo yesa cholop le resa weg ngali mo woal Ephesus le mo wol meka faluyel Asia. ");
INSERT INTO uli_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ye hammerah mele bo yebe yoh le be hatayikofaloh kaptal yengang le yach. Iwe ngo te wol ila chog, bo templum le yael Artemis ngo bele tor loh kofal. Iwe ngo tewa yor loh ssarol deus le Artemis le pangal yarmat woal Asia mo faileng le ngo re kekasrowu!” ");
INSERT INTO uli_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Yodwe buwa we rela rongrong mokwe ye sosor ngo resa ssong ngo resa ttawulagili, “Artemis le woal Ephesus ila iy mele ye tagiyet!” ");
INSERT INTO uli_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ngo yesa pallengloh yalol tawul we yar wol haplom we, ngo resa ddorfi Gaius mo Aristarchus, le rumal yarmetael Macedonia we re dabedoh Paulus, iwe resa hasirloh irel liliyel ttey we. ");
INSERT INTO uli_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus ye wol dipli le yebe loh mo imol buwa we ngo chotugul kowe re temchal fang iy. ");
INSERT INTO uli_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Sibis yarmetael amm kowe maryarel, re fangloh hapatpat irel le re kekafael pechey bo towe llah loh loboswe. ");
INSERT INTO uli_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Irel yodla ngo sa taroprop ttey we: sibis ngo semat mele re tetawulagili bo dolper ila re togla fal yar rol ttey fengal. ");
INSERT INTO uli_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Sibis ir re kachog bo Alexander mele ye salepa meka bo ir Jews kowe resa yitliwey mo imor panger yarmat. Iwe Alexander yesa pongpong ngalir yarmat bo rebe ppoloh, ngo yesa kapatpat ngalir. ");
INSERT INTO uli_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ngo molwe yela gil ngalir le iy semal Jews, ila molwe sa pangerloh ngo re tawulagili chog sew hapatpat irel ruwow awa le rema sor bo: “Artemis le woal Ephesus ila iy mele ye tagiyet!” ");
INSERT INTO uli_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Iwe ngo hoolaas we woal haplom we yesa moch hapasso buwa we le ye kangalur bo: “Yarmetal Ephesus! Pangal yarmat ngo re gola le yarmetael haplom le Ephesus mele re kekamahoy templum we yael Artemis mo porow we ye ppungdiy mo woal laeng. ");
INSERT INTO uli_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tor semal le be yoh le yebe sor bo kachapar mele. Ila hami habe hapasohmidiy ngo ha towe foru sew formel le yebe tafel. ");
INSERT INTO uli_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Hasa hasirdoh mal ka iga le rete peraf lal templum ka, ngo tedyor mele ye tayikof le re sor irel deus le yach. ");
INSERT INTO uli_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Hare Demetrius mo chol yengang kala lol yor yar ssong ngal semal, ila ngo yor tamol kala yar yengang mekla, ngo ye musloh rall yach tatelal hapatpat; hare yor yami ssong ngo be yoh le habe hasiloh lobosla rema tetal hapatpat mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Iwe ngo hare chil yor tot le ha luluwaley, ila ngo hasa hasiloh irel ttey we yael fuluy. ");
INSERT INTO uli_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bo wol miril mele sa weldoh igla ngo malbo re bele sor le siya taroprop. Ngo tor mele sibe sor bo fael ttawul kowe sa iwe sengal.” ");
INSERT INTO uli_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Yela wol miril yal sor mele ngo yesa hamdera ttey we. ");
INSERT INTO uli_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Wol miril molwe yesa morraydiy hachorong kowe ngo Paulus yesa hateyili fengalir Kristiano kowe yesa hapatpat ngalir bo yebe hakkela lal deper ngo ye habungur. Iwe ngo yesa ligdir sa loh woal Macedonia. ");
INSERT INTO uli_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Yesa loh wol pangal fulu kowe ye sala hakkela lal deper yarmat irel foloy kala yal. Yela hola Achaia, ");
INSERT INTO uli_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ye sala mel iyang irel suluw meram. Yesa kkafelfel bo bele loh woal Syria ngo yesa rongrong le Jews kowe resa kapta bo rebe lliy. Iwe yesa hatugulu bo yebe tefael loh woal Macedonia. ");
INSERT INTO uli_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Iwe ngo Sopater we lol Pyrrhus, we semal yarmetael Berea, yesa dabey. Ila sengal Aristarchus mo Secundus, we re budoh mo woal Thessalonica bo re wol dabey. Gaius we ye budoh mo woal Derbe, mo Tychicus mo Trophimus, we re budoh mo wol mokwe faluyel Asia, iwe mo Timothy ngo re wol loh. ");
INSERT INTO uli_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Resa hamoloh re sala wudugmem mo wol Troas. ");
INSERT INTO uli_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yela wol miril molwe Bungul Flowa kowe tema yor Habboloh iyang ngo hasa terag mo wol Philippi hasa loh. Yela lemarral mo wolmwiril ngo hasa holardoh mo woal Troas, iwe hasa rol melegili sew wiik iyang. ");
INSERT INTO uli_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Yela lefhafel Sabbath ngo hasa rol ttey fengal bo habe mongol fehaf. Iwe ngo Paulus yesa hapatpat ngalir yarmat le ye hapatpat ngalir chog yee, la hola lugulbong, bo bela lemaliyel dah ngo iy ye bele loh. ");
INSERT INTO uli_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ye cholop habul le ye bulbul mo lal singgil we ye ketabdah lemayural we ha ttey iyang. ");
INSERT INTO uli_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ye mel semal tarmal le Eutychus mala idal, le ye maro lal sew window irel yodwe Paulus ye kapatpat iyang. Sa kekkel doh chog yael Eutychus hadol yee, masorloh. Sa tapulwey mo lal window we ye mel irel molwe hasoldalel imw we yesa ppungdiy wototol. Rela halengadah ngo yesa mes. ");
INSERT INTO uli_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Sa bidiy Paulus irer sa ngerchapdah uwol, iwe ngo yesa holu long lomolal. Iwe ngo yesa sor bo, “Ha towe merah bele ye chil molow!” ");
INSERT INTO uli_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Iwe yesa tefaeldah lal singgil we wulural ye sala dipiy flowa we, iwe resa rol mongoy. Paulus ye hapatpat ngalir le ye ssulay yee, la raelloh, ngo yesa ligdir. ");
INSERT INTO uli_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Resa hasiloh tarmal we sa molow tefael lubugtal le yesa momay deper. ");
INSERT INTO uli_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Hasa hamoloh irel barko we hasa terag hasa loh woal Assos. Ila lobola Paulus ye bela dabohmem mo iyang. Bo iy ye kangalugmem bo habe foru mele, bo iy ye bele dar mo wulfulu. ");
INSERT INTO uli_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Yodwe hala chungu mo wol Assos, ngo yesa dabohmem hasa loh wol Mitylene. ");
INSERT INTO uli_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Hasa terag mo iyang ngo la ralawe seral ngo hasa mel lengchel Chios. Ngo yela seral mo wol miril ngo hasa budoh wol Samos; ngo yela ralawe seral ngo hasa hola Miletus. ");
INSERT INTO uli_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulus yesa hatugulu bo habe terag ffochloh hasa ligdi Ephesus bo hade machlok fedal woal mokwe faluyel Asia. Yesa nngat bo yebe hola Jerusalem woal molwe Bungul Pentecost, igle yebe mmal. ");
INSERT INTO uli_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paulus ye mel woal Miletus ngo yesa dengagloh mal kowe yar irel halesiya we woal Ephesus bo rebe budoh bo rebe rol werfengal. ");
INSERT INTO uli_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Yodwe rela ttey fengal ngo yesa kangalur bo, “Hasa gola sangsengal yai memel irel yodwe iy mel iremi le ye chap mo irel yodwe iy holahmidoh mo woal meka faluyel Asia. ");
INSERT INTO uli_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Luwul chael metay mo yai hatetaloyey ngo iforu yengang kowe yai le ngang semal re haforol yalol Samol. Irel yod kowe ye kkel yai weres, le fael molwe Jews kowe re memeal bo rebe limeseyeyloh ngo ngang iyedamgel. ");
INSERT INTO uli_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Hami ha gola le tor mele ngang ima hammach tefaeli mo irel mekla yebe tipungugmi, irel yai foloy mo yai hamedaf ngalugmi luwul yarmat mo lal imw kowe yimmi. ");
INSERT INTO uli_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ibe kangalur Jews mo Gentiles bo rebe tagul tang mekla molfidir ngo resa tagul ngal Deus, ngo resa hatugulu lal deper irel Samol Jesus. ");
INSERT INTO uli_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Iwe ngo igla ila ibele taelenga mala yalol Espritu Santus, le ibele loh woal Jerusalem. Iwe ngo itugla mele ye bele la wel ngalyey mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mala chog igula ila Espritu Santus yesa kangaluyey le woal pangal haplom ngo kalbus mo hafohoy re wiwidiyey mo iyang. ");
INSERT INTO uli_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Iwe ngo ichichi ngo nngas le yai ila tor pelal mo irey. Iy yeyedamgel chog bo ibe hamallo yengang le Samol Jesus yesa ngaleyey bo iy be foru le ye sor bo ibe foloyu Hapatpat Momay le kofal haradiya la yael Deus. ");
INSERT INTO uli_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ima dar fedal luwulumi le ifofoloyu ngalugmi kofael molwe Lamliyel Deus. Iwe ngo igla ila isa gola le tayor semal hami le yebe chil wiriyey fael sew. ");
INSERT INTO uli_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ila isa hatugulu ngalugmi igla le hare semal hami yela maelloh, ngo te ngang mele yai haffor, ");
INSERT INTO uli_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","bo tor mele iholu tefaeli le ite kangalugmi mo irel mekla Deus ye dipli. ");
INSERT INTO uli_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ila ha hafallugmi ngo hasa hafalir rechokla Espritu Santus sa fang ngalugmi bo habe hafalir. Ha metalgi eklesia la yael Deus, le yesa foru bo spegil yal irel maligach we ye mes molwe Lol iyang. ");
INSERT INTO uli_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Igula le yodle chog ibele lugdugmi ngo mael fefedeg ka re bele budoh luwulumi, ngo re towe luluwaley le rebe yutlugmi. ");
INSERT INTO uli_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ye mel sew yad le sibis chog mo luwulumi mele rebe kachaperar chotugul kala bo rebe chepar ngalir. ");
INSERT INTO uli_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ha hafalugmi ngo ha towe maligili le luwul chael metay le lebong mo leral, ngo suluw raeg we ifoloyugmi pangmi iyang. ");
INSERT INTO uli_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Iwe ngo igla, ibe kangal Deus bo yebe hafalugmi, ngo irel kkamelal mala yalol ngo yebe fang ngalugmi haradiya la yal. Iwe ngo ye holbuwahmi irel yolbuw la Deus yesa hatugulu bo yebe fang ngalir panger mekla lol. ");
INSERT INTO uli_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tedyor fael sew le ichahwagili lol semal salpiy hare lol gold hare mengagol. ");
INSERT INTO uli_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Hami ngo hasa spegil gola le ngang iy tapeli meka payi bo ibe yengang hammaley mo hammaler meka choluway. ");
INSERT INTO uli_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Isa kewar ngalugmi mo irel pangal meka ima foru, le yema iye sengal kkelel yach yengang ngo sibe tipingir mael tayikel. Sibe luluwaley mokwe yalol Samol Jesus we ye sor bo, ‘Ye kkel rraiyel yach ma fang formel mo imol rraeyel yal ma yoh ngalgich formel.’” ");
INSERT INTO uli_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Yodwe ye mol Paulus mo irel hapatpat ngo resa rol hasubugudiy resa mapel. ");
INSERT INTO uli_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Panger ngo resa rol kekabngu luwul yar tetang. ");
INSERT INTO uli_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Sa kkel yal tayikof lal deper irel molwe ye sor bo malbo tayor fael sew le rebe chil rol werfangal. Iwe resa dabey resa loh irel barko we. ");
INSERT INTO uli_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Hasa habungur ngo hasa loh. Hasa terag wwelloh chog yee, hala budoh woal Cos. Yela ralawe seral ngo hasa hola Rhodes, iwe hasa chuy mo iyang hasa loh woal Patara. ");
INSERT INTO uli_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Iwe ha sala chungu seyay barko le yesa memeal bo bele loh woal Phoenicia, iwe hasa dabey hasa terag hasa loh. ");
INSERT INTO uli_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Hasa loh yee, hala hola solbos le yesa llah ngalugmem Cyprus mo iyang, iwe ngo hasa terag chog hasa dar mo Iyorol fuluy we hasa loh Syria. Hasa bulong wol Tyre, le ila haplom we barko we be hadidiloh peteg iyang. ");
INSERT INTO uli_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ila lobola hala chungur sibis chotugul mo iyang iwe hasa mel irer irel sew wiik. Iwe ngo irel mala kkamelal Espritu Santus ngo resa kangalu Paulus bo towe loh Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Iwe ngo yela hola yodwe ha bele ligdir iyang, ngo hasa chuy ngo hasa taboloh terag we yamem. Pangerloh mo mokwe rir mo yalwich kowe layur ngo re dabohmemwey mo wol haplom we iwe hasa rodiy wulpiy. Hasa rol hasubgudiy mo iyang ngo hasa rol mapel. ");
INSERT INTO uli_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Iwe ngo hasa rol habong fengal ngo hasa bidah yuchul barko we ngo ir resa tefael loh lubugter. ");
INSERT INTO uli_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Hasa taboloh terag we yamem, hasa chuy mo woal Tyre hasa loh woal Ptolemais, lobowe ha chungur sibis chotugul mo iyang, iwe hasa mele irer wol sebong. ");
INSERT INTO uli_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Yela rallawe seral ngo hasa chuy hasa loh yee, hala budoh woal Caesarea. Iwe hasa budoh mel irel imw we imwel Philip, we iy semal chol foloy. Iy semal chowe fismol we resa duwler bo re tipingiyer mo wol Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Famal lefechig kala lol le tedyor rir ngo rema foloyu molwe yalol Deus. ");
INSERT INTO uli_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sa fedral yamem mel lobowe ngo sa budoh semal profeta le Agabus idal le ye budiy mo woal Judea. ");
INSERT INTO uli_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yesa budoh iremem, yesa hasi molwe tarel Paulus, sa fargu ngal mokwe pechel mo paol ngo yesa sor bo, “Iye mele Espritu Santus ye sor: Yeramtala tarel mele ila be iye sengal mala Jews kala woal Jerusalem rebe faor ngali, iwe ngo rebe hasi resa fang iy ngalir Gentiles.” ");
INSERT INTO uli_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Molwe hala rongrong mele ngo hamem mo rechokwe re mel lobowe, ngo hasa rol hafael pechey Paulus bo towe loh woal Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ngo iy yesa kangalugmem bo, “Meda mekla ha foforu, le hasa tetang ngo ha kekatayikofa lal depey? Ngang ila isa fel le te mil chog mala re bela farguyey mo woal Jerusalem, ngo isa fel le ibe mes le fael Samol Jesus.” ");
INSERT INTO uli_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ye teyoh ngalugmem le habe wigdi depal, iwe hasa sor bo, “Sibe mapel bo hare sew le depel Samol mele yebe mmal.” ");
INSERT INTO uli_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wol miril yamem mel tot woal haplom we ngo hasa haliliy mokwe litamem hasa chuy hasa loh woal Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Iwe ngo sibis mokwe choluwamem we re budoh mo woal Caesarea re dabohmem resa palugmemloh irel imw we ha bela mel iyang; le imwel Mnason we ye budoh mo wol Cyprus ngo yesa ssulay chog yal mel bo semal Kristiano. ");
INSERT INTO uli_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yodwe hala budoh woal Jerusalem, ngo Kristiano kowe iyang re hammalehmem. ");
INSERT INTO uli_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Yela rallawe seral ngo Paulus yesa dabohmem ha sala tefael mo irel James; iwe ngo pangerloh mal kowe yar irel eklesia we ngo re mel lobowe. ");
INSERT INTO uli_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulus yesa habungur ngo ye kapta waal ngalir irel kofal pangal mokwe Deus yesa foru mo luwulur Gentiles, irel yengang kowe yael iy Paulus. ");
INSERT INTO uli_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Wol miril yar rongrong mokwe ye sosor ngo pangerloh ngo resa hapingpinga Deus. Iwe ngo resa sor bo, “Paulus bismem, ho wiri leper Jews ka resa weg ngal repiy le, iwe mo kkelel yar itol deper irel Hatobtob we. ");
INSERT INTO uli_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Resa rongrong le gel hosa foloyur Jews kala re mel woal mekla faluyer Gentiles, le hosa kekangalur bo rebe tahcheloh Hatobtob we yael Moses; hosa kangalur bo haramwo rete hagilla mekla layur, ngo haramwo rete dabey meka kkor Jews. ");
INSERT INTO uli_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ye tugul le rebe rongrong le gel hosa dohdoh. Ila ngo meda mele si bele foru? ");
INSERT INTO uli_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Iye mele ha dipli le gel hobe foru: Ye mel famal mal iga le resa faor yar promise ngal Deus. ");
INSERT INTO uli_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Hola daber ngo hosa daber irel hafforol hachuchuyel tab, iwe ngo hosa ffaeg paliyer salpiy ila ngo be yoh le rebe guruloh mekla chemer. Bo ila ngo panger yarmat ngo rebe gola le te katos mokwe resa sor irem; ngo gel ho chil dedabey chog Hatobtob we yael Moses. ");
INSERT INTO uli_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Iwe ngo Gentiles kowe resa weg ngal Kristiano ila hamem hasa faor sew babior hasa fangloh irer. Hasa kangalur bo re towe ma mongoy mongoka resa tap maligach ngal liyosol todeb ka yarmat rema mapel ngaliy, ngo re towe mongoy cchal mael, mo mael ka re llir le re fingdi uyer, iwe ngo rebe hachuyar mo luwul maltemay.” ");
INSERT INTO uli_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Iwe Paulus sa palir mal kowe, ngo la rallawe seral ngo resa foru hafforol hachuchuyel tab mo uwor, iwe ngo Paulus yesa bulong lal Templum we sala sor lepal bong le rebe mel iyang ngo yesa moch haw bungul yar tab. Ila yodla rebe fang yael semal mo semal ir maligach iyang. ");
INSERT INTO uli_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Yodwe yesa harpal haw molwe fisbong, ngo sibis Jews le re budoh mo wol mokwe faluyel Asia resa wiri Paulus mo lal Templum we. Iwe resa hataronngardah yarmat resa budoh dorfi Paulus. ");
INSERT INTO uli_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ngo resa tawulagili le re sor bo, “Mall Israel! Ha tupungugmem! Iye mal we ye loh pangal lobos ye sala foloyu ngalir yarmat bo rebe tagul tangir yarmetal Israel, ngo re tagul tangi Hatobtob we yael Moses iwe mo Templum le. Iwe ngo igla iye yesa kaklong Gentiles lal Templum le, le yesa tungaf loh lobole ye santus iyang!” ");
INSERT INTO uli_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Re sor mele le fael mala re wiri Trophimus we ye budoh mo woal Ephesus le ye dabedoh Paulus woal haplom we, ngo resa kachog hare sa dabey long Paulus lal Templum we.) ");
INSERT INTO uli_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Resa somawel fedal yarmat woal pangal haplom we, ngo resa ttey fengal ngo resa ddorfi Paulus resa yurawey mo lal Templum we. Yodwe chog ngo resa piltaloh hatmal Templum we. ");
INSERT INTO uli_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Resa memeal le re bele limeseloh Paulus, iwe ngo sa loh hapatpat irel tamol saldawel Roma we le yesa chaep fedeg wol pangal loh Jerusalem. ");
INSERT INTO uli_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Yodwe chog ngo tamol saldaw we yesa fesngur tot saldaw resa hamdadiy luwulur yarmat. Yodwe yarmat rela wiri we yesa papadoh saldaw ngo resa poloh mo irel yar lliy Paulus. ");
INSERT INTO uli_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tamol saldaw we sa dar ngal Paulus ngo sa kangalur saldaw kowe lol bo rebe chena ngal rutab chain. Iwe ngo yesa kasiy bo, “Itey mal le ngo meda mele yesa hadre?” ");
INSERT INTO uli_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Sibis ngo semat mele re tawulagili. Tamol saldaw we ye temmal yal kasiy yebe gola hare meda mele sa wel bo sa kkel yal fedegdeg hapatpat. Iwe yesa kangalur saldaw kowe lol bo rebe hasiloh Paulus lal yoror we yar saldaw. ");
INSERT INTO uli_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Re loh le moch terap we chog mele re hola, ngo saldaw kowe resa rogu Paulus bo tay mmal buwa we irel yar ssong. ");
INSERT INTO uli_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yarmat resa dabey miril le resa tawulagili chog bo, “Ha limeseloh!” ");
INSERT INTO uli_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Yodwe saldaw kowe resa memeal le re bele hasi long Paulus lal yoror we, ngo Paulus yesa kangalu tamol saldaw we bo, “Be yoh le ibe kangalug sew formel?” Tamol saldaw we yesa kasiya bo, “Yak, ho gola yalol Greek molwe? ");
INSERT INTO uli_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ila ngo te gel mall Egypt we ye hatarongardah yarmat bo rebe fedeg, we ye palir fangeras chol fedeg, we re kak metal payur resa buyoy lal tolmay loh we, hare gel?” ");
INSERT INTO uli_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulus yesa kangalu bo, “Ngang semal Jews le isub mo woal Tarsus we ye mel woal Cilicia, ngang semal yarmetael Roma. Fael pechemi ngo ha tahcheyey bo ibe hapatpat ngalir yarmat.” ");
INSERT INTO uli_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Iwe tamol saldaw we yesa tahche bo yebe hapatpat. Paulus yesa su wol terap we ngo yesa pungpung ngalir yarmat bo rebe ppoloh. Yodwe resa poloh yarmat, ngo Paulus yesa hapatpat ngalir le ye yalol Hebrew: ");
INSERT INTO uli_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Rewol bisiy mo rewol temay, ha talengayey bo ibe taldi kofay mo imomi!” ");
INSERT INTO uli_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Molwe rela rongrong yal hapatpat le ye yalol Hebrew, ngo resa posloh sugfed; iwe ngo Paulus yesa taboloh yal hapatpat ngalir: ");
INSERT INTO uli_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ngang semal Jews le isub mo woal Tarsus we ye mel woal Cilicia. Iwe ngo ifaholdah mo woal Jerusalem le, ngo iskun mo irel Gamaliel. Re foloyu hamayu ngalyey kofal Hatobtob we yar chapdoh kowe yach iwe ngo ihasrowu Deus le igegelugmi chog pangmi rechoka hasa ttey doh igla. ");
INSERT INTO uli_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ima limeserloh rechokwe redabey mokwe yalol Samol. Mal mo fefel ngo ima ddorfir isa ppedir loang lal kalbus. ");
INSERT INTO uli_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Llulupal Temarong we mo pangerloh chol Ttey we, ngo be yoh le rebe hatosiya ngalugmi le tos meka iy sosor. Re fang babior ngalyey bo ibe fang ngalir Jews kowe re mel woal Damascus, iwe isa loh ibela ddorfir rechoka isa chenar iwe ngo isa hasirdoh woal Jerusalem bo rebe fang yar hagerger. ");
INSERT INTO uli_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Irel yai loloh le isa kekarpadoh Damascus, le ye bele wwel yaal, ngo sa bidiy sew werloh le ye kkel mo wol laeng le itedap ngo sa bidiy uwoy. ");
INSERT INTO uli_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Isa ppungdiy wototol ngo isa rongrong lliyalol yarmat le ye sor bo, ‘Saul, Saul! Meda mele ho kekafohoyuyey iyang?’ ");
INSERT INTO uli_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Iwe ngo isa kasiya bo, ‘Gel itey molwe?’ Ngo iyesa kangaluyey bo, ‘Ngang Jesusel Nazareth we ho kekafohoyu.’ ");
INSERT INTO uli_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mal kowe re dabeyey re wiri werloh we ngo re tarongrong yalol yarmat we ye malili ngalyey. ");
INSERT INTO uli_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Isa kasiy bo, ‘Meda mele ibe foru, ho Samol?’ Iwe ngo Samol yesa kangaluyey bo, ‘Sudah hosa bulong woal Damascus, ila lobola re bele moch la kangalug mo iyang mele Deus yesa hatugulu bo hobe foru.’ ");
INSERT INTO uli_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Isa metafisloh irel werloh we, iwe mokwe choluway resa holu mele payi resa paliyey long woal Damascus. ");
INSERT INTO uli_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ye mel semal mal woal haplom la le Ananias mala idal. Iy semal mal le yema itol depal irel mapel, ngo yema hasrowu Hatobtob kowe, ngo ye ssor mo irer pangerloh Jews kowe re mel lobowe. ");
INSERT INTO uli_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ye budoh sa su lengchey ngo sa kangaluyey bo, ‘Bisiy Saul, wiri tefaeli formel!’ Yodla chog ngo isa wol wiri tefaeli formel. Iwe ngo isa kalngali. ");
INSERT INTO uli_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Yesa sor bo, ‘Deus we yar chapdoh kowe yach yesa duwleh bo hobe gola mala depal, ngo hobe wiri molwe Rehaforol yalol we ye momay, iwe ngo hobe rongrong yalol yal iy spegil maliliy. ");
INSERT INTO uli_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Bo ho bele mel bo yal tugul ngalir panger yarmat bo hobe kangalur mekla hosa wiri ngo ho rongrong. ");
INSERT INTO uli_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ila ngo meda mele ho wiwidi? Sudah bo hobe baptismus. Iwe ngo hosa mepel ngali ila ngo yebe chuy fael yam molfid.’ ");
INSERT INTO uli_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Iwe isa tefael loh woal Jerusalem. Imemapel lal Templum ngo sa llah ngalyey sew formel, ");
INSERT INTO uli_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","iwiri Samol ngo iy yesa kangaluyey bo, ‘Haturug bo hobe chuy mo woal Jerusalem bo yarmat re towe taelengah irel mekla hobe sor irel kofay.’ ");
INSERT INTO uli_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ngang isa sor bo, ‘Samol, resa spegil gola le ngang iloh irel imwel ttey kowe yar isala ddorfir ngo illir rechokwe ye tugul lal deper irem. ");
INSERT INTO uli_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Iwe ngo yodwe re limeseloh Stephen we yema foloyu kofam ngalir yarmat, ngo ngang iy mel irer ngo ye fel depey irel molwe re foru. Ngang mele iy matngali mokwe mengagur rechokwe re limeseloh Stephen.’ ");
INSERT INTO uli_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Iwe ngo Samol yesa kangaluyey bo, ‘Ibele hagloyugloh irer Gentiles kala re ddawloh.’” ");
INSERT INTO uli_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Yarmat re tetalenga meka Paulus ye sosor yee, la hola yodwe ye sor mele iyang; iwe ngo resa tetawul le resa kekartaloh lepal yalor le re sor bo, “Ha hachuya mo igla! Ha limeseloh! Tor pelal le yebe molow!” ");
INSERT INTO uli_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Resa rol tetawul ngo re wwod fedaley mokwe mengagur le resa habidage bool wulural. ");
INSERT INTO uli_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tamol saldawel Roma we sa kangalur saldaw kowe lol bo rebe hasi long Paulus lal yoror we yar saldaw. Iwe ngo yesa kangalur bo rebe wwodu bo hare rebe gola fael mele Jews kowe resa rol tetawul irel yar ssong ngali iyang. ");
INSERT INTO uli_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Iwe ngo yodwe resa fargu bo rebe wwodu ngo Paulus yesa kangal tamol saldaw we ye su lobowe bo, “Ye fel le hobe wwodu semal yarmetal Roma le hobe te hasiloh mwo lal imwel tatelal hapatpat hobe gola tayikof le yesa foru?” ");
INSERT INTO uli_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yodwe tamol saldaw we ye rongrong molwe ngo sa loh irel llulupal tamol we yal ye sala kasiya bo, “Meda mele hosa luluwaley le hobe foru? Mal we ila semal yarmetael Roma!” ");
INSERT INTO uli_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Llulupal tamol saldaw we sa loh irel Paulus ye sala kasiya bo, “Kangaluyey, gel semal yarmetal Roma?” Paulus yesa sor bo, “Ngo!” ");
INSERT INTO uli_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tamol saldaw we yesa sor bo, “Ye cholop salpiy le ifang ngo isa moch mel bo semal yarmetael Roma.” Paulus yesa sor bo, “Ngang isubdoh le ngang semal yarmetael Roma.” ");
INSERT INTO uli_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yodwe chog ngo rechokwe re memeal bo rebe hadogoyu Paulus resa su tefael. Iwe ngo sa budoh yael tamol saldaw we motog irel molwe sala gola bo Paulus ila iy semal yarmetael Roma ngo iy yesa chena. ");
INSERT INTO uli_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Llulupal tamol saldaw we ye chil dipli le yebe gola hare meda mele Jews kowe re ssong ngal Paulus iyang; yela rallawe seral ngo yesa hachuya chen kowe mo uwol Paulus, ngo yesa dengag tamol temarong kowe mo pangerloh choel Ttey we bo rebe ttey. Iwe yesa hasi Paulus ye sala hasu mo imor. ");
INSERT INTO uli_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulus yesa kal ngalir chol Ttey we ngo yesa sor bo, “Re wochilay re Israel! Ngang ila ye fel lal depey irel sangsengal yai memel doh mo fael metal Deus yee, la hola doh igla.” ");
INSERT INTO uli_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Llulupal Temarong we Ananias idal yesa kangalur rechokwe re su lengchel bo rebe ppigri molwe yewal Paulus. ");
INSERT INTO uli_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulus yesa kangalur bo, “Ye tugul le Deus yebe ppugrug, bo gel ila ho wochog pegil imw la ye bbech! Ho sala maro igla bo hobe hatugulu kofay le hobe dabey felel Hatobtob we, iwe ngo gel ho hatawsi Hatobtob we irel molwe ho kangalur bo rebe ppigriyey!” ");
INSERT INTO uli_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mal kowe re su lengchel Paulus resa kangalu bo, “Yesa tayikof yam hapatpat ngal Llulupal Temarong la yael Deus!” ");
INSERT INTO uli_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulus yesa sor bo, “Re wochilay re Israel! Itugla le iye mele Llulupal Temarong. Babior we ye santus ye sor bo, ‘Ha towe ma hapatpat tayikof loh irel yami tamol.’” ");
INSERT INTO uli_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Yodwe Paulus yela gola le rechokwe ila sibis ir Sadducees, ngo sibis ir Pharisees, ngo yesa malili long lal Ttey we le ye sor bo, “Re wochilay re Israel! Ngang ila semal Pharisees, ngo ngang ila layur Pharisees. Hasa hasiyeydoh iga bo habe hatugulu kofay le mil mala ye luglug depey le rechoka resa mes ila rebe chil molow tefael!” ");
INSERT INTO uli_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Yodwe chog ye sor mele ngo sa chaep yar hachocho fengal Pharisees kowe mo Sadducees kowe, le resa harere chol ttey we. ");
INSERT INTO uli_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sadducees kowe ila rema sor bo tor mele molow tefael mo irel maes, iwe ngo tor mele angelus mo ngoel; iwe ngo ir Pharisees kowe ila re chepar la rosuluw meka ngo yor.) ");
INSERT INTO uli_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Yesa palengdah ttawul kowe yar. Iwe ngo sibis mokwe sensel Hatobtob we le ir chol rewe Pharisees resa sudah ngo resa paliliy mokwe ikowe sibis re sosor. Re hapallingi yalor le re sor bo: “Tor mele ye tayikof le ha gola le yeramtale ye foru! Malbo tos le semal yalus hare semal angelus mele ye maliliy ngali!” ");
INSERT INTO uli_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Sa kkel loh yar hachocho fengal mo yar wahaha le tamol saldaw we yesa marherah bo rede mechigchigiloh Paulus. Iwe yesa kangalur saldaw kowe lol bo rebe loh irer chol ttey we bo re bela hasiy Paulus resa hasiloh lal yororol molwe bugter saldaw. ");
INSERT INTO uli_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lefhafel chog rallawe ngo Samol sa su mo lengchel Paulus ngo sa kangalu bo, “Ho towe motog! Hosa mel bo yai tugul mo wol Jerusalem le, be wol ila sengal mala ho bela foru mo wol Roma.” ");
INSERT INTO uli_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Yela lemaliyel rallawe seral ngo sibis Jews resa ttey fengal ngo resa kapta mele rebe foru ngal Paulus. Iwe resa rol hatugulu fengaliy le tor mele rebe mongoy hare re yulumi chal yee, yela wol miril yar limeseloh Paulus. ");
INSERT INTO uli_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Yebe ligdi fayeg leper rechokla re kapta le rebe foru mele. ");
INSERT INTO uli_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Iwe resa loh irel tamol temarong kowe mo mal kowe yar ngo re sala kangalur bo, “Hamem hasa rol hatugulu fengaliy le ha towe mongoy yee, la hola yodla habe limeseloh Paulus iyang. ");
INSERT INTO uli_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ila hami mo chol Ttey le habe fangloh yalomi irel tamol saldawel Roma we bo yebe fangdiy Paulus iremi. Habe kachapar bo habe hadogoyu bo hare habe gola tot kofal. Yodla ngo hamem ha bele faesul fel le habe limeseloh mo imol mala yebe hola doh iga.” ");
INSERT INTO uli_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Iwe ngo tarmal we lol molwe mengal Paulus ye rongrong mokwe resa kapta. Yesa loh irel molwe bugter saldaw sala kangalu Paulus. ");
INSERT INTO uli_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulus yesa fesangu semal tamol saldaw kowe sa kangalu bo, “Paliloh tarmal le irel tamol saldaw we yami; ye mel sew formel le ye bela kangalu.” ");
INSERT INTO uli_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Iwe tamol pos we yesa fesangu sa palaloh irel tamol saldaw we ngo yesa kangalu bo, “Chol kalbus we Paulus ye fesanguyey ngo yesa kangaluyey bo ibe paladoh tarmal le irem bo ye mel sew formel le yebe kangalug.” ");
INSERT INTO uli_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tamol saldaw we sa holu molwe paol tarmal we sa paliloh ngo yesa kasiya bo, “Meda mele hobe kangaluyey?” ");
INSERT INTO uli_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ngo iy yesa sor bo, “Tamol Jews kowe resa kapta le walsu ngo resa dangroh hare hobe hasiloh Paulus irel Ttey we yar. Iwe ngo ir re bele la forurloh le chol Ttey la re dipli bo rebe hadogoyu Paulus bo hare rebe gola tot kofal. ");
INSERT INTO uli_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Iwe ngo ho towe talenga mala rebe sor, bo be ligdi fayeg mal le rebe mwol le rebe wwedwed. Resa hatugulu fengaliy le tor mele rebe mongoy hare re yulumi chal yee, rela limeseloh Paulus. Igla ila resa fel le rebe foru mele ngo resa wedwed chog irel sew le hobe hatugulu.” ");
INSERT INTO uli_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tamol saldaw we yesa sor bo, “Tor le hobe kangalu bo hosa kangaluyey mele.” Iwe ngo yesa halho tarmal we. ");
INSERT INTO uli_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tamol saldaw we yesa fesangur rumal tamol saldaw kowe lol ngo yesa kangalur bo, “Hala hafler rubuguy saldaw bo rebe loh wol Caesarea, le ir mo fisig saldaw kowe rema dahdah wos, mo rubuguy saldaw kowe keey mele yar pitgil fedeg. Hala haliliy bo bela duwow klok bongey ngo hasa fel le habe loh. ");
INSERT INTO uli_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Fang lol Paulus wos bo yebe dahdah iyang, iwe ngo hasa hafale irel yami hasiloh yee, yela hola Tamol Aamwe Felix.” ");
INSERT INTO uli_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Iwe ngo Tamol saldaw we yar yesa tefa sew babior le iye sengal mekla ye mel iyang: ");
INSERT INTO uli_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ngang Claudius Lysias ihabong ngalug gel Tamol Aamwe Felix: Ssarolwom. ");
INSERT INTO uli_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jews kowe re ddorfi yeramtale ila resa memeal le re bele limeseloh. Iwe ngo isa moch la gola le iy semal yarmetal Roma, iwe hasa loh mo saldaw ka layi ha sala hasi. ");
INSERT INTO uli_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Imemeal le ibe gola fael mele re luluwaley le rebe limeseloh iyang, iwe isa hasiloh irel Ttey la yar. ");
INSERT INTO uli_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Isa moch la gola le tor sew formel le ye foru le be yor fal le yebe mes hare ye kalbus iyang. Mekla re sor bo yesa hadre, ila kofal chog yar hatobtob ir lufulyer. ");
INSERT INTO uli_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Iwe ngo ila rongrong le resa kapta bo re bele limeseloh, iwe ngo isa hafengawey irem. Isa kangalur rechokla re ssong ngali bo rebe hasi song kala yar resa hasiwey irem bo rebe kangalug.” ");
INSERT INTO uli_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Saldaw kowe re foru molwe ye kangalur. Re hasi Paulus llubungul rallawe resa hasiloh yee, rela hola Antipatris. ");
INSERT INTO uli_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Yela rallawe seral ngo saldaw kowe resa darloh chog resa tefael ngal molwe bugter saldaw, ngo ikowe sibis we re dahdah wos resa dabey Paulus. ");
INSERT INTO uli_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Re hasiloh Paulus woal Caesarea, re sala fang babior we ngal Tamol Aam we ngo re wol fang Paulus ngali. ");
INSERT INTO uli_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Tamol Aam we ye yawli babior we ngo yesa kasiya Paulus hare iy semal chol fulufa. Molwe yela gola le ye budoh Paulus mo woal Cilicia, ");
INSERT INTO uli_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ngo yesa sor bo, “Rebe rel budoh rechokla re ssong ngalug ngo siya moch rol tettal hapatpat.” Iwe ngo yesa sor bo rebe posa chog Paulus mo lal imw we imwel Tamol Aam. ");
INSERT INTO uli_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Yela limbong mo wol miril ngo Llulupal Temarong we Ananias idal yesa loh woal Caesarea, le ir mo sibis mal kowe yar mo semal chol tatelal hapatpat le Tertullus idal. Re sala su imol Tamol Aamwe Felix bo rebe sor mekla derel Paulus. ");
INSERT INTO uli_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Resa fesangu long Paulus ngo Tertullus sa chapiy yal sor mokwe derel le ye sor bo: “Ssarolwom ho Tamol Aam! Sa ssulay yamem mel luwul hopos le fael mala ye momay ngo ye repiy igegel yam kekadarlahohmem, ngo ye cholop meka ye palleng palal le hosa hammal ngal mele fulumem. ");
INSERT INTO uli_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Pangal lobos mo pangal yad ngo ye fel deper yarmat ngalug, ila hamem habe kangalug bo yesa palleng yam hachigchig. ");
INSERT INTO uli_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ite dipli le ibe hamachlukku fedaleh, ila ibe hafael pecheh bo hobe talenga mele sugfed le habe kangalug. ");
INSERT INTO uli_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Hasa wiri le mal le ila semal yarmat le ye hammerah; yema chapidoh fedeg luwulur Jews lal pangal faileng le, iwe ngo iy semal mekla meter chol rewe rema sor bo Nazarenes. ");
INSERT INTO uli_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Ye luluwaley le yebe hatungafa Templum we iwe ngo hamem hasa ddorfi. ");
INSERT INTO uli_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Hare hobe hadogoyu yeramtale ila ngo hobe gola pangal meka ha sosor irel.” ");
INSERT INTO uli_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jews kowe sibis resa wol hapatpat ngo resa sor bo pangal mokwe ye sor ngo ye katos. ");
INSERT INTO uli_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Iwe ngo Tamol Aam we yesa pongpong ngal Paulus bo yebe maliliy ngo Paulus yesa sor bo, “Igula le yesa cholop raeg yam tettal hapatpat wol faliyey, ila yesa rraey lal depey bo ibele taldi kofay mo imom. ");
INSERT INTO uli_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Gel ngo ho faesul gola le ye ted yoh seg mo rubong mo wol miril yodwe iloh Jerusalem bo ibela mepel iyang. ");
INSERT INTO uli_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Iwe ngo Jews ka ila re ted wiriyey mwo le ihachocho ngal semal mo lal Templum we hare ihatarongardah yarmat mo lal imwel ttey kowe hare solbos mo woal haplom we. ");
INSERT INTO uli_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Igla mwo ngo towe yoh ngalir le rebe kangalug tugulul mekla re sosor irey. ");
INSERT INTO uli_