﻿USE sofia;
DROP TABLE IF EXISTS sofia.ukronpu_vpl;
CREATE TABLE ukronpu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ukronpu_vpl WRITE;
INSERT INTO ukronpu_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Блаженна та людина, що не ходить на раду нечестивих, не стоїть на дорозі грішників і не сидить на зборищі глумливих! ");
INSERT INTO ukronpu_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Але в Законі Господнім її насолода і про Закон Його роздумує вдень та вночі. ");
INSERT INTO ukronpu_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","І буде вона як дерево, посаджене над водними потоками, що плід свій дає вчасно, і листя його не зів’яне. Що б вона не робила, щаститиме їй. ");
INSERT INTO ukronpu_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Не так нечестиві! Вони – як полова, що вітер розносить усюди. ");
INSERT INTO ukronpu_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Тому не встоять нечестиві на суді ані грішники – на зборах праведних. ");
INSERT INTO ukronpu_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Адже знає Господьжиттєвий шлях праведних, а шлях нечестивих загине. ");
INSERT INTO ukronpu_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Чому бентежаться народи і племена задумують марне? ");
INSERT INTO ukronpu_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Повстають царі землі, і можновладці гуртуються разом проти Господа й проти Його Помазанця. ");
INSERT INTO ukronpu_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","«Розірвемо їхні кайдани, – кажуть вони, – скинемо їхні пута!» ");
INSERT INTO ukronpu_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Той, Хто сидить на небесах, сміється, Володар глузує з них. ");
INSERT INTO ukronpu_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Тоді Він промовить до них у гніві Своєму і полум’ям люті Своєї настрашить їх: ");
INSERT INTO ukronpu_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","«Ось Я поставив царя Мого над Сіоном, Моєю святою горою». ");
INSERT INTO ukronpu_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Сповіщу-но я постанову Господню: Він промовив до мене: «Ти Мій Син, Я сьогодні породив Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Проси в Мене – і Я дам Тобі народи у спадок, і володіння Твоє – аж до країв землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ти уразиш їх жезлом залізним, як посуд, виріб гончаря, розіб’єш їх». ");
INSERT INTO ukronpu_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Отже, царі, схаменіться, отямтеся, судді землі! ");
INSERT INTO ukronpu_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Служіть Господеві зі страхом і радійте з тремтінням. ");
INSERT INTO ukronpu_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Цілуйте Сина, щоб Він не розгнівався і щоб ви не загинули на своєму шляху, бо гнів Його спалахне вмить. Блаженні ті, хто на Нього надію покладає! ");
INSERT INTO ukronpu_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Псалом Давидів, коли він втікав від свого сина Авесалома. ");
INSERT INTO ukronpu_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Господи, як багато супротивників у мене стало! Як багато тих, хто повстає проти мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Багато хто каже про мене: «Немає йому порятунку від Бога». Села ");
INSERT INTO ukronpu_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Але Ти, Господи, – щит для мене, слава моя, Ти підносиш мою голову. ");
INSERT INTO ukronpu_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Голосом моїм я кличу до Господа, і Він відповідає мені зі святої гори Своєї. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Я лягаю і сплю, прокидаюся знову, адже Господь мене підтримує. ");
INSERT INTO ukronpu_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Не боятимусь я десятків тисяч людей, що з усіх боків мене обступили. ");
INSERT INTO ukronpu_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Повстань, Господи! Врятуй мене, Боже мій! Адже Ти вражав усіх ворогів моїх у щелепу, трощив зуби нечестивих. ");
INSERT INTO ukronpu_vpl VALUES ("PS3_9","020_3_9","PSA","3","9","9","Тільки в Господа спасіння! Над народом Твоїм благословення Твоє, Господи. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Керівнику хору. На струнних інструментах. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Коли я кличу, дай мені відповідь, Боже моєї правди! Коли мені було тісно, Ти давав мені простір. Змилуйся наді мною і почуй мою молитву. ");
INSERT INTO ukronpu_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","О сини людські, доки ви честь мою безчестити будете? Доки будете любити марне й прагнути неправди? Села ");
INSERT INTO ukronpu_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Знайте ж, що Господь відокремив для Себе вірного слугу, Він чує, коли я кличу до Нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Тремтіть перед Ним і не грішіть; поміркуйте в серцях ваших на ложах ваших і заспокойтеся. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Принесіть жертви правди і надію на Господа покладайте. ");
INSERT INTO ukronpu_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Багато хто каже: «Хто нам покаже добро?» Пролий на нас світло Твого обличчя, Господи! ");
INSERT INTO ukronpu_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ти дав моєму серцю більшу радість, ніж у них в той час, коли зарясніло їхнє зерно й молоде вино. ");
INSERT INTO ukronpu_vpl VALUES ("PS4_9","020_4_9","PSA","4","9","9","У повному спокої я ляжу й засну, бо тільки Ти, Господи, даєш мені жити в безпеці. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Керівнику хору. Для виконання в супроводі сопілок. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Зваж на слова мої, Господи, зрозумій мій стогін! ");
INSERT INTO ukronpu_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Прислухайся до звуків мого зойку, Царю мій і Боже мій, бо Тобі я молюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Господи, вранці Ти почуй мій голос, вранці я постану перед Тобою й чекатиму. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Адже Ти не той Бог, Якому до вподоби беззаконня, зло не мешкатиме поряд із Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Не встоять пихаті перед Твоїми очима, Ти ненавидиш усіх тих, хто поводиться свавільно. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ти знищиш тих, що промовляють неправду; людина кровожерна й підступна гидка для Тебе, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Але я, завдяки великій Твоїй милості, увійду до дому Твого, поклонюся у бік Храму святині Твоєї, сповнений страхом побожним перед Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Господи, веди мене Твоєю правдою заради ворогів моїх; вирівняй шлях Твій переді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Адже немає у вустах їхніх щирості, їхній внутрішній світ – руїна, гортань у них – відкрита могила, язики у них слизькі. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Оголоси їм вирок, Боже! Нехай впадуть вони через підступні задуми свої, відкинь їх через численні беззаконня їхні, адже вони повстали проти Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","І тоді радітимуть усі, хто на Тебе надію покладає; їхні вигуки щастя лунатимуть вічно. Простягни Свій покров над ними, і звеселяться Тобою ті, що ім’я Твоє люблять. ");
INSERT INTO ukronpu_vpl VALUES ("PS5_13","020_5_13","PSA","5","13","13","Бо Ти благословляєш праведного, Господи, наче великим щитом, вкриваєш його Твоєю прихильністю. ");
INSERT INTO ukronpu_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Керівнику хору. У супроводі струнних інструментів. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Господи, не докоряй мені у гніві Твоєму, І не карай мене в люті Своїй. ");
INSERT INTO ukronpu_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Помилуй мене, Господи, бо я знемігся. Зціли мене, Господи, бо кістки мої зомліли. ");
INSERT INTO ukronpu_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Душа моя вкрай збентежена. А Ти, Господи, доки мовчатимеш? ");
INSERT INTO ukronpu_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Повернися до мене, Господи, визволи мою душу, врятуй мене заради милості Твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Адже в смерті немає згадки про Тебе. Хто прославить Тебе в царстві мертвих? ");
INSERT INTO ukronpu_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Я виснажився від стогнання мого, щоночі обливаю постіль свою плачем, сльозами ложе своє зволожую. ");
INSERT INTO ukronpu_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Очі мої змарніли від смутку, виснажилися через погрози моїх супротивників. ");
INSERT INTO ukronpu_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Відступіться геть від мене всі ті, хто поводиться свавільно, бо почув Господь голос плачу мого! ");
INSERT INTO ukronpu_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Почув Господь благання моє, Господь прийняв молитву мою. ");
INSERT INTO ukronpu_vpl VALUES ("PS6_11","020_6_11","PSA","6","11","11","Нехай засоромлені будуть і збентежені вкрай усі вороги мої, обернуться назад і вкриються ганьбою зненацька. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Жалобна пісня Давида, яку він співав Господеві стосовно Куша, із коліна Веніаміна. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Господи, Боже мій, на Тебе я надію покладаю. Врятуй мене від усіх, хто мене переслідує, визволи мене, ");
INSERT INTO ukronpu_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","щоб душу мою не розтерзав ворог; як лев; шматуватиме він – і не буде визволителя. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Господи, Боже мій! Якщо я зробив це, якщо є беззаконня на руках моїх, ");
INSERT INTO ukronpu_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","якщо злом я віддячив тому, хто жив у мирі зі мною, і якщо я супротивника мого грабував даремно, ");
INSERT INTO ukronpu_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","то нехай ворог переслідує мою душу, наздожене мене, і втопче в землю життя моє, і честь мою в пилюці перебувати змусить. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Устань, Господи, у гніві Твоєму, піднімися проти люті супротивників моїх, повстань за мене на суд справедливий, що Ти заповів. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Нехай оточить Тебе зібрання племен, а Ти сядеш над ним на висоті. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Нехай Господь судить народи! Суди мене, Господи, за моєю правдою і за невинністю моєю, о Всевишній! ");
INSERT INTO ukronpu_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Нехай же буде покладено край злу нечестивих, а праведного зміцни, Боже праведний, адже Ти випробовуєш серця й нутрощі. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Щит мій – Бог Всевишній, що рятує людей із справедливими серцями. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Бог – суддя праведний, це той Бог, Який щодня гнів справедливий виявляє. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Якщо хтось не навернеться, Він нагострить Свій меч, натягне Свій лук, націлить його ");
INSERT INTO ukronpu_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","і приготує смертоносну зброю, палючими зробить Свої стріли проти грішника. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ось той, хто зачинає беззаконня і вагітніє лихом, народить неправду. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Він рив яму, викопав її, але сам упаде в зроблену ним пастку. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Повернеться задумане ним лихо на його ж голову, і на маківку йому впаде власне насильство. ");
INSERT INTO ukronpu_vpl VALUES ("PS7_18","020_7_18","PSA","7","18","18","Прославлю Господа за Його правду й заспіваю хвалу імені Господа Всевишнього! ");
INSERT INTO ukronpu_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Керівнику хору. Виконання в стилі ґіттіт. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Господи, Володарю наш, яке величне ім’я Твоє усюди на землі! Ти підніс велич Свою понад небеса. ");
INSERT INTO ukronpu_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Із вуст малих дітей і немовлят Ти влаштував твердиню проти супротивників Твоїх, щоб змусити замовкнути ворога й месника. ");
INSERT INTO ukronpu_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Коли дивлюсь я на небеса Твої, творіння Твоїх пальців, на місяць і зорі, що Ти встановив їх, ");
INSERT INTO ukronpu_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","то роздумую: «Хто така людина, що Ти пам’ятаєш про неї, і хто син людський, що Ти турбуєшся про нього?» ");
INSERT INTO ukronpu_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Лише трохи применшив Ти його перед Богом і славою та величчю коронував його. ");
INSERT INTO ukronpu_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Ти поставив його панувати над творіннями Твоїх рук, усе підкорив йому під ноги: ");
INSERT INTO ukronpu_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","усю дрібну худобу й волів, а також польових звірів, ");
INSERT INTO ukronpu_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","птахів небесних і риб морських, усе живе, що проходить стежками моря. ");
INSERT INTO ukronpu_vpl VALUES ("PS8_10","020_8_10","PSA","8","10","10","Господи, Володарю наш, яке величне ім’я Твоє усюди на землі! ");
INSERT INTO ukronpu_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Керівнику хору. На мотив «Смерть сина». Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Славитиму Тебе, Господи, від щирого серця, сповіщатиму всі чудеса Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Радітиму й веселитимусь Тобою, співатиму імені Твоєму, Всевишній! ");
INSERT INTO ukronpu_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Коли вороги мої відсахнулися назад, то спіткнулися й загинули перед обличчям Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Бо Ти підтримав мене на суді у позові моєму проти них; Ти сів на престолі, судив по правді. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Ти звинуватив народи, згубив нечестивих, імена їхні стер навіки із пам’яті. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Руйнування ворога завершене навіки; його міста Ти викорінив, Господи, навіть пам’ять про них згинула. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","А Господь перебуватиме вічно, Він встановив для праведного суду престол Свій. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Він судитиме всесвіт за правдою, вершитиме суд народам справедливо. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","І буде Господь сховищем пригніченому, притулком у часи скорботи. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Надію покладатимуть на Тебе всі, хто знає ім’я Твоє, адже Ти не покинеш тих, хто прагне Тебе, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Співайте Господеві, Що мешкає на Сіоні, звіщайте народам Його звершення. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Бо Він вимагає розплати за кров невинних, пам’ятає про них, не забуває волання пригнічених. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Змилуйся наді мною, Господи, поглянь, як гнітять мене мої ненависники, підніми мене, віддали від воріт смерті, ");
INSERT INTO ukronpu_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","щоби звіщав я хвалу Тобі у воротах Доньки Сіону, радіючи порятунку Твоєму. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Народи попадали в яму, яку самі ж і викопали, упіймалися їхні ноги в сіть, яку вони ж таємно розставили. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Виявив Себе Господь, вчинивши суд: нечестивий потрапив у пастку вчинків своїх рук! Гіґайон. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Зійдуть нечестиві до царства мертвих – усі народи, що Бога забувають. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Але вбогий не назавжди буде забутий, і надія пригнічених не зникне навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Повстань, Господи! Нехай не перемагає людина! Нехай стануть народи на суд перед обличчям Твоїм! ");
INSERT INTO ukronpu_vpl VALUES ("PS9_21","020_9_21","PSA","9","21","21","Наведи жах на них, Господи, нехай пізнають народи, що вони – лише смертні люди. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS9_22","020_9_22","PSA","9","22","22","Чому, Господи, Ти стоїш осторонь, ховаєш Себе від нас у часи скорботні? ");
INSERT INTO ukronpu_vpl VALUES ("PS9_23","020_9_23","PSA","9","23","23","Нечестивий пихато переслідує пригніченого – нехай сам потрапить у задумані ним каверзи! ");
INSERT INTO ukronpu_vpl VALUES ("PS9_24","020_9_24","PSA","9","24","24","Бо хизується нечестивий пристрастями душі своєї і жадібний ганьбить, зневажає Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_25","020_9_25","PSA","9","25","25","Зухвало нехтує нечестивець тим, щоб Господа шукати, немає місця для Бога в жодному його підступному задумі. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_26","020_9_26","PSA","9","26","26","Його справи йдуть успішно повсякчас, занадто високі для нього закони справедливості Твоєї, глузує він з усіх супротивників своїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_27","020_9_27","PSA","9","27","27","Говорить він у серці своєму: «Не похитнуся, ніколи лихо мене не спіткає!» ");
INSERT INTO ukronpu_vpl VALUES ("PS9_28","020_9_28","PSA","9","28","28","Його вуста наповнені прокляттям, підступом і пригніченням, під язиком у нього лихо й сваволя. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_29","020_9_29","PSA","9","29","29","Залягає він у засідку біля огороджених поселень, у глухих місцевостях вбиває невинного, очі його стежать за вбогим. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_30","020_9_30","PSA","9","30","30","Чатує у схованці, немов лев у лігві; чигає, щоб схопити пригніченого; хапає бідаря, тягнучи його у свої сіті. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_31","020_9_31","PSA","9","31","31","Понівечений, він згинається й падає, і могутність нечестивця вражає знедолених і нещасних. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_32","020_9_32","PSA","9","32","32","Говорить безбожний у своєму серці: «Бог забув, Він сховав обличчя Своє, повік не побачить цього». ");
INSERT INTO ukronpu_vpl VALUES ("PS9_33","020_9_33","PSA","9","33","33","Повстань, Господи! Здійми руку Твою, Боже! Не забувай пригнічених! ");
INSERT INTO ukronpu_vpl VALUES ("PS9_34","020_9_34","PSA","9","34","34","Чому нехтує Богом нечестивий, говорить у своєму серці, що не відплатиш Ти за зло? ");
INSERT INTO ukronpu_vpl VALUES ("PS9_35","020_9_35","PSA","9","35","35","Але ж Ти бачиш! На утиск і гніт Ти уважно дивишся, щоб рукою Своєю покарати винного. Убогий Тобі ввіряється, Ти помічник сироті. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_36","020_9_36","PSA","9","36","36","Зламай же плече нечестивому й злому, відплати за його беззаконня так, щоб не знайшлося нічого після нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_37","020_9_37","PSA","9","37","37","Господь – Цар на віки вічні, згинуть народи чужі із землі Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS9_38","020_9_38","PSA","9","38","38","Бажання бідних Ти чуєш, Господи, підтримуєш їхні серця, схиляєш вухо Своє до їхнього зойку, ");
INSERT INTO ukronpu_vpl VALUES ("PS9_39","020_9_39","PSA","9","39","39","щоб здійснити правосуддя для сироти й пригніченого, щоб смертна людина не наводила більше жаху на землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Керівнику хору. Псалом Давидів. На Господа я надію покладаю. Як же ви можете казати мені: «Лети-но на гору, мов птах!» ");
INSERT INTO ukronpu_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Бо ось нечестиві натягують луки, прикладають стріли на тятиву, щоб у темряві стріляти в справедливих серцем. ");
INSERT INTO ukronpu_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Адже коли руйнуються підвалини, що може зробити праведний? ");
INSERT INTO ukronpu_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Господь у Своєму святому Храмі, Господь на Своєму небесному престолі. Його очі бачать, Його повіки випробовують синів людських. ");
INSERT INTO ukronpu_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Господь випробовує праведного, а нечестивого й того, хто любить насильство, ненавидить Його душа. ");
INSERT INTO ukronpu_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Він проллє дощем на нечестивих нещастя, вогонь, сірку, і вітер палючий – їхня частка з чаші гніву. ");
INSERT INTO ukronpu_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Бо праведний Господь, любить правду; тому тільки справедливі побачать Його обличчя. ");
INSERT INTO ukronpu_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Керівнику хору. У супроводі восьмиструнного інструмента. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Врятуй, Господи, бо не стало справедливого, бо зникли вірні з-посеред синів людських! ");
INSERT INTO ukronpu_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Марне говорять одне одному, вуста слизькі в них, глибоко в серці промовляють інше. ");
INSERT INTO ukronpu_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Нехай розрубає Господь кожні слизькі вуста й зухвалий язик тих, ");
INSERT INTO ukronpu_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","що говорять: «Нашим язиком здолаємо кого завгодно; вуста наші з нами – то хто нам пан?» ");
INSERT INTO ukronpu_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","«Через те, що грабують пригноблених, що бідняки стогнуть, нині повстану Я, – говорить Господь, – врятую від тих, хто зводить на них наклеп». ");
INSERT INTO ukronpu_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Слова Господні – слова чисті, немов срібло, що в горнилі земляному очищене, сім разів переплавлене. ");
INSERT INTO ukronpu_vpl VALUES ("PS11_8","020_11_8","PSA","11","8","8","Ти, Господи, берегтимеш нужденних, стерегтимеш нас від роду цього злого повіки, ");
INSERT INTO ukronpu_vpl VALUES ("PS11_9","020_11_9","PSA","11","9","9","поки навколо тиняються нечестиві й людська нікчемність у пошані. ");
INSERT INTO ukronpu_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Доки, Господи? Невже Ти забув мене навіки? Доки ховатимеш обличчя Своє від мене? ");
INSERT INTO ukronpu_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Доки тяжкі роздуми носитиму я в душі своїй і муку в серці своєму день у день? Доки величатиметься ворог мій наді мною? ");
INSERT INTO ukronpu_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Зглянься ж, дай мені відповідь, Господи, Боже мій! Очі мої просвіти, щоб сном смертним я не заснув, ");
INSERT INTO ukronpu_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","щоб не говорив мій ворог: «Я здолав його!» Щоб не раділи супротивники мої, коли я похитнуся. ");
INSERT INTO ukronpu_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Я ж бо на милість Твою покладаю надію, радітиме серце моє через порятунок, посланий Тобою, співатиму я Господеві, бо Він виявив до мене прихильність. ");
INSERT INTO ukronpu_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Керівнику хору. Давидів. Промовив безумний у своєму серці: «Немає Бога». Розбестились вони, огидними стали їхні вчинки, немає нікого, хто б чинив добро. ");
INSERT INTO ukronpu_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Господь із небес поглядає на синів людських, щоб побачити, чи є серед них розумний, що шукає Бога. ");
INSERT INTO ukronpu_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Усі як один вони збочили з дороги, зіпсувалися; немає того, хто робив би добро, жодного немає. ");
INSERT INTO ukronpu_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Невже не схаменуться всі ті, хто чинить беззаконня, хто пожирає народ мій, немов хліб, хто Господа не кличе? ");
INSERT INTO ukronpu_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Там, на шляху їхньому, охопить їх страх, адже Бог серед праведного роду. ");
INSERT INTO ukronpu_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Ви глузуєте зі сподівань пригнобленого, але Господь – його притулок. ");
INSERT INTO ukronpu_vpl VALUES ("PS13_7","020_13_7","PSA","13","7","7","О, хто дав би із Сіону порятунок Ізраїлеві! Коли Господь поверне з полону народ Свій, веселитиметься Яків, радітиме Ізраїль! ");
INSERT INTO ukronpu_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Псалом Давидів. Господи, хто може мешкати у Твоєму наметі? Хто житиме на Твоїй святій горі? ");
INSERT INTO ukronpu_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Той, хто ходить бездоганно життєвим шляхом і хто чинить правду; хто істину говорить у своєму серці ");
INSERT INTO ukronpu_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","і наклепів язиком своїм не зводить; не чинить зла ближньому своєму і нічого ганебного на свого ближнього не намовляє; ");
INSERT INTO ukronpu_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","очима своїми він не гляне на негідника, але тих, хто Господа боїться, шанує; навіть коли він склав собі присягу на збиток, то не змінить свого слова. ");
INSERT INTO ukronpu_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Срібла свого він на лихву не позичає і хабара проти невинного на суді не бере. Хто чинить усе це, той повіки не захитається. ");
INSERT INTO ukronpu_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Міхтам Давидів. Бережи мене, Боже, адже на Тебе я надію покладаю! ");
INSERT INTO ukronpu_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Сказав я Господеві: «Ти мій Володар, немає в мене іншого блага, окрім Тебе». ");
INSERT INTO ukronpu_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Також до святих, що на землі, і до шляхетних – до них моє бажання. ");
INSERT INTO ukronpu_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Нехай же численні скорботи спіткають тих, хто іншим богам прагне служити. Я не литиму їм крові жертовних виливань, не згадуватиму імен тих богів моїми вустами. ");
INSERT INTO ukronpu_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","ЛишеГосподь – наділений мені спадок і мій келих; Ти тримаєш мій жереб. ");
INSERT INTO ukronpu_vpl VALUES ("PS15_6","020_15_6","PSA","15","6","6","Межі мого наділу пролягли через приємні місця – так, гарний спадок для мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS15_7","020_15_7","PSA","15","7","7","Благословлю я Господа, Який дає мені поради, навіть уночі моє нутро наставляє мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS15_8","020_15_8","PSA","15","8","8","В уяві своїй завжди я бачу перед собою Господа, адже Він по правиці моїй, щоб я не похитнувся. ");
INSERT INTO ukronpu_vpl VALUES ("PS15_9","020_15_9","PSA","15","9","9","Тому радіє серце моє й веселиться слава моя, також тіло моє перебуватиме в безпеці, ");
INSERT INTO ukronpu_vpl VALUES ("PS15_10","020_15_10","PSA","15","10","10","бо не залишиш Ти душі моєї в царстві мертвих, не дозволиш вірному Твоєму побачити тління. ");
INSERT INTO ukronpu_vpl VALUES ("PS15_11","020_15_11","PSA","15","11","11","Ти стежку життя мені показуєш; наповнив мене радощами перед обличчям Твоїм, насолодою по правиці Твоїй навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Молитва Давидова. Почуй, о Господи, благання про правду; прислухайся до мого волання, зваж на мою молитву, що з вуст нелукавих лине. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Від Тебе Самого нехай прийде мені суд справедливий, нехай очі Твої побачать правду. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Ти випробував моє серце, дослідив мене вночі, переплавив мене, але не знайшов того, щоб слова мої розходилися з думками. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Щодо справ людських, то згідно зі словом, що вийшло з вуст Твоїх, я зберіг себе від того, щоб стати на шлях гнобителя. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Стопи мої крокували тільки Твоїми стежками, ноги мої не оступалися. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Я кличу до Тебе, бо Ти відповіси мені, Боже; нахили вухо Твоє до мене, почуй мову мою. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","З’яви дивну милість Твою, о Визволителю, Що рятуєш правицею Своєю тих, хто надію покладає на Тебе в протистоянні з ворогами. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Бережи мене мов зіницю ока, у тіні крил Твоїх сховай мене ");
INSERT INTO ukronpu_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","від нечестивих, що грабують мене, від смертельних ворогів моїх, що мене оточили. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Вони заплили жиром, вуста їхні говорять пихато. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Підкрадалися до мене таємно, а тепер оточили мене, їхні очі шукають нагоди, аби кинути мене на землю. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_12","020_16_12","PSA","16","12","12","Немов той лев, що прагне терзати здобич, і як лев молодий, що в засідці залягає. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_13","020_16_13","PSA","16","13","13","Піднімися, Господи, стань перед ним, кинь додолу його; мечем Своїм визволи душу мою від нечестивого, ");
INSERT INTO ukronpu_vpl VALUES ("PS16_14","020_16_14","PSA","16","14","14","рукою Твоєю від мужів, Господи, – від людей плинного світу, чия доля лише в цьому житті. То нехай же їхнє черево наповниться із Твоєї скарбниці нехай діти їхні наситяться і залишок передадуть малюкам своїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS16_15","020_16_15","PSA","16","15","15","А я в правді побачу обличчя Твоє, прокинувшись, образом Твоїм насичуватися буду. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Керівнику хору. Псалом раба Господнього Давида. Він заспівав слова цієї пісні Господеві того дня, коли визволив його Господь від руки всіх ворогів його й від руки Саула. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","І сказав він: «Я люблю Тебе, Господи, сило моя!» ");
INSERT INTO ukronpu_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Господь – бескид крутий для мене, твердиня моя і мій Визволитель. Мій Бог – моя скеля, на Нього я надію покладаю, Він – мій щит і ріг порятунку мого, притулок мій. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","До Господа прославленого кличу я – від ворогів моїх врятований буду. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Облягли мене пута смерті, потоки зради затягнули мене у вир. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Пута царства мертвих охопили мене, тенета смерті постали переді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","У скорботі моїй я кликав Господа й волав до Бога мого. Він почув мій голос зі святого Храму Свого, і волання моє до вух Його дійшло. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Тоді здригнулася земля, захиталась, затремтіли підвалини гір, стрепенулися, бо розгнівався Він. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Дим піднявся із ніздрів Його, і вогонь, що все пожирає, – із вуст Його, розжарене вугілля посипалося від Нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Він нахилив небеса і зійшов, і під ногами Його – хмара імли. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Він сів верхи на херувима й полетів, понісся на крилах вітру. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Морок зробив Він Своїм покровом, немов шатро навколо Нього – темні хмари дощові, клуби пилу. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Від сяйва, що перед Ним, випливають хмари – вони несуть град і спалахи вогню. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Тоді загримів на небесах Господь, Всевишній подав Свій голос – град і спалахи вогню. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","І пустив Він стріли Свої, і розсіяв ворогів, численними блискавками розгромив їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_16","020_17_16","PSA","17","16","16","Тоді з’явилися джерела води й підвалини всесвіту відкрилися від докору Твого, Господи, від подиху вітру із ніздрів Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_17","020_17_17","PSA","17","17","17","Він схилився з висоти, узяв мене, витягнув мене із вод глибоких. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_18","020_17_18","PSA","17","18","18","Визволив мене від сильного мого ворога й від ненависників моїх, що сильніші були від мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_19","020_17_19","PSA","17","19","19","Вони стали переді мною в день лиха, але Господь був моєю опорою. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_20","020_17_20","PSA","17","20","20","Він вивів мене на просторе місце, визволив мене, бо Він мене уподобав. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_21","020_17_21","PSA","17","21","21","Віддячив мені Господь за правдою моєю, за чистотою рук моїх винагородив мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_22","020_17_22","PSA","17","22","22","Адже я тримався шляхів Господніх і не чинив нечестиво, відвернувшись від мого Бога. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_23","020_17_23","PSA","17","23","23","Бо всі закони Його правосуддя – переді мною, і від постанов Його я не ухилявся. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_24","020_17_24","PSA","17","24","24","Я був бездоганний перед Ним і від гріха оберігав себе. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_25","020_17_25","PSA","17","25","25","Тому й винагородив мене Господь за правдою моєю, за чистотою рук моїх перед Його очима. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_26","020_17_26","PSA","17","26","26","Ти вірність виявляєш тому, хто сам вірний, з людиною бездоганною й Ти поводишся бездоганно, ");
INSERT INTO ukronpu_vpl VALUES ("PS17_27","020_17_27","PSA","17","27","27","із чистим Ти обходишся щиро, але з підступним – відповідно до його підступності. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_28","020_17_28","PSA","17","28","28","Адже Ти рятуєш людей смиренних, а тих, у кого очі зухвалі, принижуєш. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_29","020_17_29","PSA","17","29","29","Ти запалюєш мій світильник; Господь, Бог мій, освітлює мою темряву. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_30","020_17_30","PSA","17","30","30","Разом із Тобою я змушую вороже військо тікати, і з Богом моїм я долаю стіну. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_31","020_17_31","PSA","17","31","31","Бог! Бездоганний шлях Його, слово Господа чисте. Він – щит для всіх тих, хто на Нього надію покладає. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_32","020_17_32","PSA","17","32","32","Бо хто ще є Богом, окрім Господа? І хто є скелею, крім нашого Бога? ");
INSERT INTO ukronpu_vpl VALUES ("PS17_33","020_17_33","PSA","17","33","33","Бог підперізує мене силою і бездоганним чинить мій шлях. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_34","020_17_34","PSA","17","34","34","Він робить ноги мої, мов у лані, і ставить мене на узвишшях. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_35","020_17_35","PSA","17","35","35","Він привчає руки мої до битви, так що плечі мої можуть зігнути бронзовий лук. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_36","020_17_36","PSA","17","36","36","Ти дав мені щит порятунку Твого, і правиця Твоя підтримує мене, милість Твоя звеличує мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_37","020_17_37","PSA","17","37","37","Ти розширюєш мій крок піді мною, так що не тремтять мої ступні. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_38","020_17_38","PSA","17","38","38","Я переслідую ворогів моїх і наздоганяю їх, не повертаюся назад, поки їх не знищу. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_39","020_17_39","PSA","17","39","39","Я вражаю їх так, що не можуть більше встати, вони падають під мої ноги. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_40","020_17_40","PSA","17","40","40","Ти підперезав мене силою для битви, упокорив тих, хто повстав проти мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_41","020_17_41","PSA","17","41","41","Ти ворогів моїх обернув до мене спиною, і ненависників моїх я знищив. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_42","020_17_42","PSA","17","42","42","Вони волали про допомогу, але не було рятівника, до Господакликали, та Він їм не відповідав. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_43","020_17_43","PSA","17","43","43","Я стер їх у порох, у пил, що розноситься на крилах вітру; я топтав їх, як бруд на вулицях. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_44","020_17_44","PSA","17","44","44","Ти визволив мене від заколоту в народі, поставив мене головувати над іноземцями. Народи, яких я не знав, служать мені, ");
INSERT INTO ukronpu_vpl VALUES ("PS17_45","020_17_45","PSA","17","45","45","слухаються мене, лише почувши краєм вуха про мене. Сини чужинців плазують переді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_46","020_17_46","PSA","17","46","46","Понурилися сини чужинців і завмирають від страху, виходячи зі своїх укріплень. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_47","020_17_47","PSA","17","47","47","Живий Господь і благословенна Скеля моя! Нехай звеличений буде Бог порятунку мого! ");
INSERT INTO ukronpu_vpl VALUES ("PS17_48","020_17_48","PSA","17","48","48","Він – Бог, Який помсту за мене вчиняє, підкорює мені народи ");
INSERT INTO ukronpu_vpl VALUES ("PS17_49","020_17_49","PSA","17","49","49","й визволяє мене від ворогів моїх. Ти підніс мене над тими, хто повстав проти мене, врятував мене від людини жорстокої. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_50","020_17_50","PSA","17","50","50","За це я славитиму Тебе серед народів, Господи, та імені Твоєму співатиму хвалу. ");
INSERT INTO ukronpu_vpl VALUES ("PS17_51","020_17_51","PSA","17","51","51","Звеличує Він перемогою поставленого Ним царя і милість виявляє Своєму помазанцю Давиду й нащадкам його повіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Небеса проголошують славу Божу, і про діяння рук Його сповіщає небесна твердь. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","День у день виливають вони мову свою й щоночі відкривають знання. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Хоча без слів їхня мова і не чути звуків від них, ");
INSERT INTO ukronpu_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","по всій землі розходиться їхній голос, і до краю всесвіту – їхні слова. У небесах поставив Він шатро для сонця, ");
INSERT INTO ukronpu_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","і воно виходить із нього, немов наречений із весільної світлиці, і радіє, наче бігун, що пробігти має свою стежину. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","З одного краю небес воно виходить, пробігає коло до іншого краю, і ніщо не сховається від його спекоти. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Закон Господа бездоганний, оновлює душу. Одкровення Господні гідні довіри, мудрими роблять простих. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Настанови Господні справедливі, радують серце. Заповідь Господа промениста, просвітлює очі. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Страх Господній чистий, перебуває повіки. Закони правосуддя Господа істинні, усі вони праведні. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Вони бажаніші від золота, навіть від безлічі золота щирого; і солодші вони від меду, меду стільникового. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Тож Твій слуга бережеться ними; за їх дотримання – велика нагорода. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","А помилки свої – хто їх помітити може? Від неумисних провин очисти мене ");
INSERT INTO ukronpu_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","і від свідомих гріхів стримай раба Твого – нехай не панують наді мною. Тоді я буду досконалий і чистий від великого беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Нехай приємні Тобі будуть слова вуст моїх і роздуми серця мого, Господи, Скеле моя й Відкупителю мій! ");
INSERT INTO ukronpu_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Нехай відповість тобі Господь у день скорботи. Нехай підніме тебе ім’я Бога Якова. ");
INSERT INTO ukronpu_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Нехай пошле Він тобі допомогу зі Святилища і підтримає тебе із Сіону. ");
INSERT INTO ukronpu_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Нехай Він згадає усі твої жертвоприношення з прихильністю і твоїми цілопаленнями задоволений буде. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Нехай Він дасть тобі те, чого бажає твоє серце, здійснить усі твої наміри. ");
INSERT INTO ukronpu_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Ми радісно гукатимемо про твою перемогу, і в ім’я Бога нашого піднімемо знамена. Нехай виконає Господь усі прохання твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Тепер я знаю, що рятує Господь помазанця Свого, відповідає йому зі святих небес Своїх переможною силою правиці Своєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Дехто хвалиться колісницями, дехто – конями, а ми хвалитися будемо іменем Господа, Бога нашого. ");
INSERT INTO ukronpu_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Вони похилилися й впали, а ми встали й зміцнюємося. ");
INSERT INTO ukronpu_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Господи, даруй перемогу! Нехай Цар відповість нам того дня, коли ми кличемо до Нього! ");
INSERT INTO ukronpu_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Господи, цар радіє міці Твоїй і порятунком Твоїм надзвичайно веселиться. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ти дав йому те, чого бажало його серце, і благання вуст його не відхилив. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Але зустрів його рясними благословеннями, поклав йому на голову вінок зі щирого золота. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Він просив життя у Тебе – Ти дав йому, навіки наділив довголіттям. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Велика слава в нього через перемоги, даровані Тобою; Ти наділив Його славою й величчю. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Ти обдарував його благословеннями навіки, звеселив його радістю від присутності Твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Бо на Господа цар покладає надію, і завдяки милості Всевишнього він не похитнеться. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Знайде рука Твоя всіх ворогів Твоїх, правиця Твоя досягне Твоїх ненависників. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_10","020_20_10","PSA","20","10","10","Ти зробиш їх подібними до вогняної печі у час Твого з’явлення. У гніві Своєму Господь знищить їх, і вогонь їх спалить. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_11","020_20_11","PSA","20","11","11","Нащадків їхніх Ти знищиш із землі, і насіння їхнє – з-поміж синів людських. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_12","020_20_12","PSA","20","12","12","Бо вони задумують зло проти Тебе, плетуть каверзи, але не досягнуть мети. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_13","020_20_13","PSA","20","13","13","Ти зробиш їх ціллю для лука Свого, проти облич їхніх натягнеш тятиву. ");
INSERT INTO ukronpu_vpl VALUES ("PS20_14","020_20_14","PSA","20","14","14","Піднімися, о Господи, у міці Твоїй! Ми співатимемо й хвалитимемо могутність Твою. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Керівнику хору. На мотив «Лань на світанку». Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Боже мій, Боже мій, чому Ти покинув мене? Чому Ти стоїш осторонь, коли я волаю про порятунок? ");
INSERT INTO ukronpu_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Боже мій, я кличу вдень – Ти не відповідаєш, вночі – і немає мені спокою. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Але ж Ти – Святий; Ти, оточений хваліннями Ізраїлю, сидиш на престолі. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","На Тебе покладалися батьки наші, надію покладали, і Ти рятував їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","До Тебе волали й були визволені, на Тебе надію покладали й не зганьбилися. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Я ж – черв’як, а не людина, ганьба серед людей, засоромлений серед народу. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Усі, хто бачить мене, глузують з мене: кепкують вустами, похитують головою. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","«Він покладався на Господа, тож нехай визволить його, нехай врятує його, якщо Він його уподобав». ");
INSERT INTO ukronpu_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ти ж, Господи, вивів мене з утроби, навчив мене довіряти Тобі ще біля грудей моєї матері. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","На Тебе я покинутий від самого народження, від лона матері моєї Ти – мій Бог. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Не віддаляйся від мене, адже скорбота близько, а помічника немає. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Оточили мене численні бугаї, міцні бугаї з Башану обступили мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_14","020_21_14","PSA","21","14","14","Пащі свої роззявили на мене, немов лев, що терзає здобич і реве. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_15","020_21_15","PSA","21","15","15","Я розлився, як вода, і всі кістки мої роз’єдналися, серце моє перетворилося на віск, розтануло серед моїх нутрощів. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_16","020_21_16","PSA","21","16","16","Моя життєва сила висохла, немов череп’я, і язик мій прилип до піднебіння. Ти поклав мене до смертного пороху. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_17","020_21_17","PSA","21","17","17","Пси обступили мене, збіговисько злодіїв оточило мене, прокололи руки мої та ноги мої. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_18","020_21_18","PSA","21","18","18","Усі кістки свої я можу перелічити, а вони вирячилися й глузливо дивляться на мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_19","020_21_19","PSA","21","19","19","Вони ділять між собою мої шати й за одяг мій кидають жереб. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_20","020_21_20","PSA","21","20","20","А Ти, Господи, не віддаляйся! Сило моя, поспіши мені на допомогу. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_21","020_21_21","PSA","21","21","21","Визволи мою душу від меча, мою єдину – від псів. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_22","020_21_22","PSA","21","22","22","Врятуй мене від пащі лева, і від рогів диких биків – смиренну душу мою. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_23","020_21_23","PSA","21","23","23","Я звіщатиму ім’я Твоє братам моїм, посеред зібрання хвалитиму Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_24","020_21_24","PSA","21","24","24","Ті, хто Господа боїться, хваліть Його! Усі нащадки Якова славте Його! Тремтіть перед Ним, усі нащадки Ізраїля! ");
INSERT INTO ukronpu_vpl VALUES ("PS21_25","020_21_25","PSA","21","25","25","Бо не знехтував Він і не відцурався приниження убогого, і не відвернув обличчя Свого від нього, але почув, коли той волав до Нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_26","020_21_26","PSA","21","26","26","Тобі моя хвала у зібранні великому. Я виконаю обітниці мої перед тими, хто Його боїться. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_27","020_21_27","PSA","21","27","27","Бідняки їстимуть і наситяться, хвалитимуть Господа ті, хто Його шукає. Нехай живуть повіки серця ваші! ");
INSERT INTO ukronpu_vpl VALUES ("PS21_28","020_21_28","PSA","21","28","28","Згадають Господа й навернуться до Нього всі краї землі, і поклоняться перед Тобою усі сім’ї народів. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_29","020_21_29","PSA","21","29","29","Бо Господеві належить царство, Він править народами. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_30","020_21_30","PSA","21","30","30","Усі багатії землі будуть їсти й поклоняться Йому; схиляться на коліна всі, що сходять до смертного пороху й не можуть душу свою зберегти живою. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_31","020_21_31","PSA","21","31","31","Нащадки служитимуть Йому, розповідатимуть наступному поколінню про Володаря. ");
INSERT INTO ukronpu_vpl VALUES ("PS21_32","020_21_32","PSA","21","32","32","Прийдуть і звіщатимуть Його правду народові, що має народитися, про те, що зробив Він. ");
INSERT INTO ukronpu_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Псалом Давидів Господь – мій Пастир, я нічого більше не потребую. ");
INSERT INTO ukronpu_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Він дає мені спочинок на трав’янистих пасовищах, водить мене до тихих вод. ");
INSERT INTO ukronpu_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Він оживляє мою душу, веде мене стежками правди заради Свого імені. ");
INSERT INTO ukronpu_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Навіть коли я піду долиною тіней смерті, то не боятимусь зла, адже Ти зі мною; Твій жезл і Твій посох – вони заспокоюють мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Ти готуєш для мене святковий стіл на очах у моїх супротивників, Ти намастив мою голову олією, мій келих наповнений вщерть. ");
INSERT INTO ukronpu_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Тож нехай добро й милість супроводжують мене в усі дні мого життя, а я перебуватиму в домі Господньому повіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Псалом Давидів Господеві належить земля і все, що її наповнює, всесвіт і все, що живе в ньому. ");
INSERT INTO ukronpu_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Адже Він заклав її основи в глибинах морів і над ріками встановив її. ");
INSERT INTO ukronpu_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Хто може зійти на гору Господню? Хто зможе стати на Його святому місці? ");
INSERT INTO ukronpu_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Той, чиї долоні чисті й серце невинне, хто не надимався марно своєю душею й оманливо не присягався. ");
INSERT INTO ukronpu_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Отримає він благословення від Господа й виправдання від Бога, Спасителя Свого. ");
INSERT INTO ukronpu_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ось такий рід тих, хто шукає Його, шукає обличчя Твого, Боже Якова. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS23_7","020_23_7","PSA","23","7","7","Ворота, підніміть ваші верхи, підніміться, о двері вічні, щоб увійшов Цар слави! ");
INSERT INTO ukronpu_vpl VALUES ("PS23_8","020_23_8","PSA","23","8","8","Хто ж Він, цей Цар слави? Господь могутній і сильний, Господь сильний у битві. ");
INSERT INTO ukronpu_vpl VALUES ("PS23_9","020_23_9","PSA","23","9","9","Ворота, підніміть ваші верхи, підніміться, о двері вічні, щоб увійшов Цар слави! ");
INSERT INTO ukronpu_vpl VALUES ("PS23_10","020_23_10","PSA","23","10","10","Хто Він, цей Цар слави? Господь Воїнств, Він – Цар слави! Села ");
INSERT INTO ukronpu_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Псалом Давидів. До Тебе, Господи, я підношу мою душу. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Боже мій, на Тебе надію покладаю; тож не дай мені вкритися соромом, нехай вороги не радіють перемозі наді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Не дай жодному з тих, хто на Тебе надію покладає, бути посоромленим, але нехай вкриються ганьбою ті, хто безпідставно чинить віроломство. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Покажи мені, шляхи Твої, Господи, навчи мене стежок Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Веди мене істиною Твоєю й навчи мене, адже Ти – Бог спасіння мого, на Тебе я надію покладаю щодня. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Згадай, Господи, любов Твою й Твоє милосердя, адже вони споконвіку. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Гріхів юності моєї й беззаконь моїх не згадуй, але заради милосердя Твого згадай мене, заради доброти Твоєї, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Добрий і справедливий Господь, тому наставляє грішників на істинний шлях. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Він спрямовує смиренних до справедливості й покірливих навчає дороги Своєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Усі стежки Господні – милість та істина для тих, хто дотримується Його Завіту й одкровень. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_11","020_24_11","PSA","24","11","11","Заради імені Твого, Господи, прости беззаконня моє, бо велике воно. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_12","020_24_12","PSA","24","12","12","Хто той муж, що Господа боїться? Вкаже йому Бог дорогу, яку треба обрати. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_13","020_24_13","PSA","24","13","13","Душа його житиме в достатку, і нащадки його успадкують землю. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_14","020_24_14","PSA","24","14","14","Таємницю СвоюГосподьдовіряє тим, хто боїться Його, і Завіт Свій відкриває їм. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_15","020_24_15","PSA","24","15","15","Очі мої завжди звернені до Господа, бо Він звільняє ноги мої із пастки. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_16","020_24_16","PSA","24","16","16","Зглянься на мене й змилуйся наді мною, бо я самотній і пригнічений. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_17","020_24_17","PSA","24","17","17","Скорботи мого серця примножилися – виведи мене зі страждань моїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_18","020_24_18","PSA","24","18","18","Поглянь на приниження моє й муку мою і прости усі гріхи мої. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_19","020_24_19","PSA","24","19","19","Подивися на ворогів моїх, які численні вони стали і якою ненавистю лютою ненавидять мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_20","020_24_20","PSA","24","20","20","Збережи мою душу й визволи мене, не дай мені вкритися ганьбою, адже на Тебе надію покладаю. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_21","020_24_21","PSA","24","21","21","Невинність і справедливість нехай стережуть мене, бо на Тебе я покладаю надію. ");
INSERT INTO ukronpu_vpl VALUES ("PS24_22","020_24_22","PSA","24","22","22","Визволи, Боже, Ізраїля від усіх скорбот його! ");
INSERT INTO ukronpu_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Псалом Давидів. Суди мене, Господи, адже я ходив бездоганно, і на Господа я покладав надію непохитно. ");
INSERT INTO ukronpu_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Випробуй мене, Господи, оціни мене, досліди серце моє й моє нутро. ");
INSERT INTO ukronpu_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Бо милість Твоя перед моїми очима, тому я завжди ходжу в істині Твоїй. ");
INSERT INTO ukronpu_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Я не сиджу з нікчемними людьми й не піду з підступними. ");
INSERT INTO ukronpu_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Я ненавиджу зборище злодіїв і не сяду з нечестивими. ");
INSERT INTO ukronpu_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Омиватиму свої руки в невинності й навколо жертовника Твого, Господи, ходитиму, ");
INSERT INTO ukronpu_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","голосно звіщаючи подяку й проголошуючи всі чудеса Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Господи, я полюбив оселю Твого дому, те місце, де мешкає Твоя слава. ");
INSERT INTO ukronpu_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Не дай душі моїй загинути з грішниками й не згуби життя мого з людьми кровожерними, ");
INSERT INTO ukronpu_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","у чиїх руках злий задум і чиї правиці повні хабарів. ");
INSERT INTO ukronpu_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","А я бездоганно ходжу життєвим шляхом. Визволи мене й помилуй! ");
INSERT INTO ukronpu_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Нога моя стоїть на рівній землі; серед присутніх на великих зборах благословлятиму Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Псалом Давидів. Господь – моє світло й моє спасіння: кого мені боятись? Господь – твердиня мого життя: кого мені лякатись? ");
INSERT INTO ukronpu_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Коли наблизяться до мене злодії, щоб пожерти моє тіло, коли супротивники й вороги мої повстануть проти мене, вони спіткнуться й впадуть. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Якщо військо стане табором проти мене, моє серце страх не охопить; якщо війна спалахне проти мене – і тоді я почуватимусь у безпеці. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Одного лиш просив я в Господа, тільки того шукаю: щоб мешкати мені в домі Господньому всі дні життя мого, щоб споглядав я спокійГоспода й поринав у роздуми в Храмі Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Бо Він сховає мене в помешканні Своєму в день лиха, убереже мене під подолом Свого шатра й здійме мене на скелю. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Тоді піднесеться голова моя над ворогами моїми, що оточують мене, і принесу я біля шатра Його жертви з вигуком радості, співатиму й гратиму для Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Почуй, Господи, мій голос, адже кличу я, помилуй мене і дай мені відповідь. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","«До Тебе!» – каже серце моє. «Шукайте обличчя Моє!» Обличчя Твоє, Господи, шукатиму я. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Не відвертай обличчя Твого від мене, не відкинь у гніві раба Твого, адже Ти був допомогою моєю. Не покинь мене, не залиши, Боже спасіння мого! ");
INSERT INTO ukronpu_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Хоча мої батько й мати полишили мене, але Господь прийме мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Покажи мені, Господи, дорогу Твою і стежкою справедливості веди мене заради ворогів моїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Не віддавай мене на поталу супротивникам моїм, бо свідки неправдиві повстали проти мене й дихають насильством. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_13","020_26_13","PSA","26","13","13","Однак я твердо вірю, що побачу доброту Господню на землі живих. ");
INSERT INTO ukronpu_vpl VALUES ("PS26_14","020_26_14","PSA","26","14","14","Надійся на Господа, будь мужнім і серце своє зміцни. Надійся на Господа! ");
INSERT INTO ukronpu_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Псалом Давидів. До Тебе, Господи, я кличу, Скеле моя, не будь байдужим до мене! Якщо Ти мовчатимеш, я стану подібним до тих, що сходять до прірви. ");
INSERT INTO ukronpu_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Почуй голос благань моїх, коли я волаю до Тебе, коли я піднімаю руки свої до Святая Святих Храму Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Не став мене на один рівень із нечестивими, з тими, що роблять беззаконня, що про мир говорять із ближніми своїми, та в серцях у них зло. ");
INSERT INTO ukronpu_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Віддай їм за їхніми вчинками, за мірою зла у їхніх справах. Так, як вчинили руки їхні, віддай їм, поверни їм те, що вони заслужили. ");
INSERT INTO ukronpu_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","За те, що не задумуються вони над звершеннями Господа й над діянням рук Його, Він їх зруйнує й не відбудує знов. ");
INSERT INTO ukronpu_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Благословенний Господь, бо почув Він голос моїх благань. ");
INSERT INTO ukronpu_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Господь – твердиня моя й щит мій; на Нього покладалося моє серце. Він допоміг мені, і серце моє зраділо, тож піснею своєю я прославлю Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Господь – сила Свого народу, Він – рятівна твердиня для Свого помазанця. ");
INSERT INTO ukronpu_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Врятуй народ Твій і благослови Свій спадок; Будь їхнім Пастирем і веди їх повік! ");
INSERT INTO ukronpu_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Псалом Давидів. Віддайте Господеві, о сини Божі, віддайте Господеві славу й могутність! ");
INSERT INTO ukronpu_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Віддайте імені Господа славу, вклоніться Господеві в Його величному святилищі. ");
INSERT INTO ukronpu_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Голос Господа – над водами; Бог слави гримить, Господь – над водами могутніми. ");
INSERT INTO ukronpu_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Голос Господа сильний; Голос Господа величний. ");
INSERT INTO ukronpu_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Голос Господа ламає кедри, Господь ламає кедри Лівану. ");
INSERT INTO ukronpu_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Він змушує їх танцювати, як телят, а гори Ліван та Сиріон – немов молодого дикого бика. ");
INSERT INTO ukronpu_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Голос Господа викрешує язики полум’я. ");
INSERT INTO ukronpu_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Голос Господа змушує тремтіти пустелю, Господь потрясає пустелю Кадеш. ");
INSERT INTO ukronpu_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Голос Господа гне дуби й оголює ліси, а в Храмі Його всі вигукують: «Слава!» ");
INSERT INTO ukronpu_vpl VALUES ("PS28_10","020_28_10","PSA","28","10","10","Господь сидів над водами потопу; Господь як Цар сидітиме навіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS28_11","020_28_11","PSA","28","11","11","Господь дає міць Своєму народові; Господь благословляє народ Свій миром. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Псалом. Пісня Давидова на посвячення дому. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Величатиму Тебе, Господи, бо Ти витягнув мене із безодні й не дав ворогам моїм порадіти над моїм падінням. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Господи, Боже мій, я волав до Тебе, і Ти зцілив мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Господи, Ти вивів мою душу із царства мертвих, зберіг моє життя, щоб я не зійшов у провалля. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Співайте Господеві, вірні Йому, славте пам’ять Його святині. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Адже гнів Його триває лише мить, тоді як прихильність Його – на все життя. Звечора й усю ніч може тривати плач, але на ранок – вигуки радості. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","У добробуті перебуваючи, сказав я: «Не захитаюся повіки». ");
INSERT INTO ukronpu_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Господи, через Твою прихильність до мене Ти зробив гору мою непохитною твердинею. Та як тільки сховав Ти Своє обличчя, я збентежився. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","До Тебе, Господи, я кличу, і Володаря мого благаю. ");
INSERT INTO ukronpu_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Яка користь від того, що кров моя проллється, що зійду я до ями погибелі? Хіба славитиме Тебе порох мерця? Чи звіщатиме він Твою істину? ");
INSERT INTO ukronpu_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Почуй, Господи, і помилуй мене! Господи, будь мені помічником! ");
INSERT INTO ukronpu_vpl VALUES ("PS29_12","020_29_12","PSA","29","12","12","Ти ридання моє перетворив на веселий хоровод, зняв із мене лахміття й підперезав мене радістю, ");
INSERT INTO ukronpu_vpl VALUES ("PS29_13","020_29_13","PSA","29","13","13","щоб слава Тобі звучала й не змовкала. Господи, Боже мій, повіки славитиму Тебе! ");
INSERT INTO ukronpu_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","На Тебе, я Господи, покладаю надію, тож нехай не посоромлюся повіки! Врятуй мене у Своїй праведності! ");
INSERT INTO ukronpu_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Схили до мене вухо Твоє, поспіши визволити мене, будь для мене скелею пристановища, домом твердині, щоб врятувати мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Бо Ти моя скеля й твердиня моя; заради імені Твого веди мене й керуй мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Витягни мене з тенет, які вони для мене таємно розставили, адже ти моє пристановище. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","У руки Твої я ввіряю дух мій; визволи мене, Господи, Боже істини. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Ненавиджу тих, що шанують марних ідолів; я ж надію покладаю на Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Веселитимусь і радітиму Твоєму милосердю, бо Ти побачив моє пригнічення, дізнався про скорботи мого серця ");
INSERT INTO ukronpu_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","й не віддав мене в руки ворога мого на поталу, але поставив мої ноги на просторому місці. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Помилуй мене, Господи, бо тісно мені, згасли від смутку мої очі, моя душа й нутро моє. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Бо життя моє згасає в журбі, і роки мої – у зітханнях. Моя сила спіткнулася через гріхи мої, і кістки мої виснажилися. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Через усіх супротивників моїх став я ганьбою для своїх сусідів і страхом для тих, хто добре знав мене; хто бачить мене на вулиці – тікає від мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_13","020_30_13","PSA","30","13","13","Забутий я в серцях їхніх, немов померлий; став я немов розбитий глек. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_14","020_30_14","PSA","30","14","14","Бо чую я наклепи від багатьох, жах навколо. Змовляються вони разом проти мене, задумують життя моє забрати. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_15","020_30_15","PSA","30","15","15","Але я на Тебе надію покладаю, Господи! Кажу я: «Ти мій Бог!» ");
INSERT INTO ukronpu_vpl VALUES ("PS30_16","020_30_16","PSA","30","16","16","У Твоїй руці час мого життя; визволи мене від руки ворогів моїх і від тих, хто мене переслідує. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_17","020_30_17","PSA","30","17","17","Нехай засяє обличчя Твоє над рабом Твоїм, врятуй мене в милості Твоїй. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_18","020_30_18","PSA","30","18","18","Господи, нехай не буде мені соромно, що я до Тебе кличу. Нехай соромно стане нечестивим, нехай замовкнуть вони в царстві смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_19","020_30_19","PSA","30","19","19","Нехай оніміють вуста брехливі, що проти праведника говорять зухвало, пихато й з презирством. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_20","020_30_20","PSA","30","20","20","Які ж великі Твої блага, котрі приховав Ти для тих, хто боїться Тебе, які Ти здійснюєш на очах синів людських для тих, хто надію покладає на Тебе! ");
INSERT INTO ukronpu_vpl VALUES ("PS30_21","020_30_21","PSA","30","21","21","Ти вкриваєш їх покровом Свого обличчя від підступних змов людських, ховаєш їх у наметі Своєму від лайливих язиків. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_22","020_30_22","PSA","30","22","22","Благословенний Господь, Що з’явив мені дивовижну Свою милість, коли я був в оточеному ворогами місті. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_23","020_30_23","PSA","30","23","23","Я ж сказав у тривозі моїй: «Я вигнаний геть від очей Твоїх!» Але Ти почув голос благань моїх, коли я волав до Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_24","020_30_24","PSA","30","24","24","Любіть Господа, усі вірні Його! Оберігає Господь відданих Йому та відплачує сповна гордим. ");
INSERT INTO ukronpu_vpl VALUES ("PS30_25","020_30_25","PSA","30","25","25","Будьте мужніми й зміцніться серцем, усі, хто на Господа сподівається. ");
INSERT INTO ukronpu_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Псалом Давидів. Повчання. Блаженний той, чиї беззаконня прощені, чиї гріхи покриті! ");
INSERT INTO ukronpu_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Блаженна та людина, якій Господь не залічить її гріха, у дусі якої немає підступності! ");
INSERT INTO ukronpu_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Поки я мовчав, виснажилися мої кості через моє щоденне стогнання. ");
INSERT INTO ukronpu_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Бо вдень і вночі тяжіла наді мною рука Твоя; волога життєдайна в мені перетворилася на літню посуху. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Та визнав я свій гріх перед Тобою й не приховав моєї провини. Я сказав: «Визнаю перед Господом мої беззаконня», і Ти простив провину мого гріха. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Тому помолиться Тобі кожен вірний у той час, коли можна знайти Тебе, і навіть потік могутніх вод до нього не підступить. ");
INSERT INTO ukronpu_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ти – потаємний притулок для мене; Ти стерегтимеш мене від лиха, оточиш мене вигуками радості визволення. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","«Я тебе наставлятиму й спрямовувати тебе буду на шлях, яким належить тобі йти. Я буду давати поради, Моє око наглядає за тобою». ");
INSERT INTO ukronpu_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Тож не будьте як кінь чи мул, що не мають розуміння, чий норов треба стримувати вудилом і вуздечкою, бо інакше не наблизяться вони до тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Багато скорбот у нечестивого, а того, хто надію на Господа покладає, оточує Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Радійте в Господі й веселіться, праведні! Голосно співайте, усі щирі серцем! ");
INSERT INTO ukronpu_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Веселіться, праведні, у Господі! Справедливим личить хвалити Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Славте Господа під звуки арфи, співайте для Нього під ліру десятиструнну! ");
INSERT INTO ukronpu_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Співайте Йому нову пісню, грайте майстерно, зі звуком сурми! ");
INSERT INTO ukronpu_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Бо Слово Господа справедливе і всі Його дії гідні довіри. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Він любить праведність і справедливість; земля повна милості Господньої. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Словом Господа створені небеса, і духом вуст Його – усе воїнство їхнє. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Він збирає грудами води моря, кладе безодні океану в сховища. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Нехай боїться Господа вся земля; нехай тремтять перед Ним усі мешканці всесвіту. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Бо Він сказав – і стало, Він заповів – і з’явилося. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Господь руйнує намір народів, знищує задуми племен. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","А намір Господа стоятиме повіки, задуми Його серця – з роду в рід. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_12","020_32_12","PSA","32","12","12","Блаженний народ, чиїм Богом є Господь, народ, який Він обрав Собі у спадок. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_13","020_32_13","PSA","32","13","13","Господь поглядає з небес, бачить усіх синів людських. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_14","020_32_14","PSA","32","14","14","Із місця Свого перебування приглядається пильно до всіх, хто живе на землі, – ");
INSERT INTO ukronpu_vpl VALUES ("PS32_15","020_32_15","PSA","32","15","15","Творець усіх сердець їхніх із розумінням вникає в усі їхні дії. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_16","020_32_16","PSA","32","16","16","Царя не врятує численне військо, воїна не визволить велика сила. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_17","020_32_17","PSA","32","17","17","Кінь ненадійний для порятунку: великою силою своєю він не врятує. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_18","020_32_18","PSA","32","18","18","Ось очі Господні звернені на тих, хто боїться Його, хто на милість Його сподівається, ");
INSERT INTO ukronpu_vpl VALUES ("PS32_19","020_32_19","PSA","32","19","19","щоб від смерті врятувати їх і живити під час голоду. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_20","020_32_20","PSA","32","20","20","Душа наша в надії чекає на Господа, Він – наша допомога і щит. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_21","020_32_21","PSA","32","21","21","Ним радіє наше серце, бо на святе Його ім’я ми покладаємось. ");
INSERT INTO ukronpu_vpl VALUES ("PS32_22","020_32_22","PSA","32","22","22","Нехай милість Твоя, Господи, буде над нами, як ми на Тебе й сподіваємося. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Псалом Давидів, коли він вдавав із себе божевільного перед Авімелехом, був вигнаний від нього й пішов. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Благословлятиму Господа повсякчасно, хвала Йому завжди в моїх устах. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Душа моя хвалитиметься Господом; нехай почують смиренні й зрадіють. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Величайте Господа зі мною; звеличуймо разом ім’я Його! ");
INSERT INTO ukronpu_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Я шукав Господа, і Він відповів мені й від усіх жахів моїх визволив мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Хто погляд свій звертав на Нього, ті засяяли від радості, обличчя їхні не вкриються ганьбою. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Цей пригноблений кликав, і Господь почув і від усіх скорбот врятував його. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Ангел Господній стає табором довкола тих, хто боїться Його, і визволяє їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Скоштуйте й побачте, що добрий Господь! Блаженний той, хто надію на Нього покладає! ");
INSERT INTO ukronpu_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Бійтеся Господа, святі Його, адже немає нестатку ні в чому у тих, хто боїться Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Молоді леви терплять нестачу й голодують, а ті, хто Господа шукає, у жодному добрі нестатку не відчувають. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Приходьте, нащадки, послухайте мене, я навчу вас боятися Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Той, хто бажає насолоджуватися життям, хто хотів би бачити добро в усі дні, ");
INSERT INTO ukronpu_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","стримуй язик свій від зла й вуста свої від того, щоб говорити підступне. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Ухиляйся від зла й чини добро, шукай миру й прагни його. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Очі Господа – на праведних, і вуха Його до зойку їхнього прихилені. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Обличчя Господа – проти тих, хто чинить зло, щоб викорінити з землі пам’ять про них. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Кличуть праведні, і Господь чує й від усіх скорбот їх визволяє. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Близький Господь до людей зі зламаним серцем, і тих, у кого дух розбитий, Він рятує. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Багато лих у праведного, та від усіх них врятує його Господь. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Береже Він усі кістки його, жодна з них не буде зламана. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Зло приведе до смерті нечестивого, і ті, хто ненавидить праведника, будуть засуджені. ");
INSERT INTO ukronpu_vpl VALUES ("PS33_23","020_33_23","PSA","33","23","23","Визволяє Господь душі слуг Своїх, і не буде засуджений жоден із тих, хто надію на Нього покладає. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Псалом Давидів. Господи, втруться в суперечку з тими, хто зі мною сперечається, почни воювати з тими, хто воює проти мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Візьми щит і обладунки й повстань мені на допомогу! ");
INSERT INTO ukronpu_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Махни списом і загороди дорогу тим, хто переслідує мене. Скажи душі моїй: «Я – порятунок твій!» ");
INSERT INTO ukronpu_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Нехай посоромлені й принижені будуть ті, хто прагне згубити мою душу. Нехай розвернуться назад і вкриються ганьбою, хто зло проти мене задумує. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Нехай будуть вони як полова перед вітром, коли ангел Господній гнатиме їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Нехай шлях їхній буде темний і слизький, коли ангел Господній переслідуватиме їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","За те, що приховали для мене тенета без причини й безпідставно викопали яму для душі моєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Нехай погибель прийде на нього несподівано, й у тенетах, що він для мене таємно розставив, заплутається сам і впаде в них собі на погибель. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","А моя душа веселитись буде в Господі, піднесеться від радості через Твоє спасіння. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Усі кістки мої нехай скажуть: «Господи, хто подібний до Тебе? Ти визволяєш приниженого від того, хто сильніший від нього, приниженого й бідного – від того, хто грабує його». ");
INSERT INTO ukronpu_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Повстали проти мене жорстокі свідки, розпитують мене про те, чого я не знаю. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Віддячують мені злом за добро, тяжкою втратою моїй душі. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Та коли вони хворіли, я вдягався в лахміття, постом виснажував мою душу, та молитва моя поверталася в нутро моє без відповіді. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Я ходив, наче за другом чи братом моїм сумуючи, наче матір оплакуючи, схилившись понуро. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","А коли я спіткнувся, вони зраділи, і збиралися проти мене негідники, котрих я не знав, терзали мене безупинно. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Безбожними глузуваннями насміхалися, скреготіли на мене своїми зубами. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Володарю, доки Ти дивитимешся на це? Відведи мою душу від їхніх згубних вчинків, від цих левів самотню мою! ");
INSERT INTO ukronpu_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Я прославлю Тебе в зібранні великому, посеред велелюддя хвалитиму Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Нехай же не зловтішаються наді мною вороги мої неправедно, що даремно ненавидять мене. Нехай не підморгують очима зловтішно ті, хто ненавидить мене даремно. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Бо не про мир вони говорять, але на мирних мешканців землі задумують підступне. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Роззявляють на мене свої пащі, кажучи: «Ага! Ага! Побачили цю біду наші очі!» ");
INSERT INTO ukronpu_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Але ж і Ти, Господи, побачив це, не мовчи! Владико, не віддаляйся від мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS34_23","020_34_23","PSA","34","23","23","Пробудися і встань на мій суд, втруться в мою суперечку, Боже мій, Володарю мій! ");
INSERT INTO ukronpu_vpl VALUES ("PS34_24","020_34_24","PSA","34","24","24","Суди мене за правдою Твоєю, Господи, Боже мій; і нехай не зловтішаються вони наді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_25","020_34_25","PSA","34","25","25","Нехай не говорять вони в серцях своїх: «Ага, сталося, як ми хотіли!» Нехай не промовляють: «Ми проковтнули його!» ");
INSERT INTO ukronpu_vpl VALUES ("PS34_26","020_34_26","PSA","34","26","26","Нехай посоромляться й ганьбою вкриються всі, хто радіє моєму лихові. Нехай одягнуться у сором і безчестя ті, хто величається наді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS34_27","020_34_27","PSA","34","27","27","Нехай же веселяться й радіють ті, кому до вподоби моя правда; нехай завжди промовляють вони: «Хай звеличиться Господь, Що бажає миру слузі Своєму!» ");
INSERT INTO ukronpu_vpl VALUES ("PS34_28","020_34_28","PSA","34","28","28","Тоді язик мій проголошуватиме Твою правду, цілий день хвалитиме Тебе! ");
INSERT INTO ukronpu_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Керівнику хору. Псалом слуги Господнього, Давида. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Промовляє беззаконня до нечестивця в глибинах його серця, немає страху Божого перед його очима. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Адже він так сам себе улещує в очах своїх, що не може знайти гріха в собі, щоб його зненавидіти. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Слова вуст його – беззаконня й підступ; він неспроможний мислити розсудливо й робити добро. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Він задумує беззаконня навіть на своєму ложі, стає на недобрий шлях, не цурається зла. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Господи, Твоя милість сягає небес, Твоя вірність – аж до хмар. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Праведність Твоя – немов могутні гори, Твій справедливий суд – велика безодня. Людей і тварин Ти бережеш, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Яка дорогоцінна милість Твоя, Боже! Тому сини людські в тіні Твоїх крил спочивають безпечно. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Насичуються вони від достатку благ Твого дому, і потоком насолод Своїх Ти їх напуваєш. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Адже в Тебе джерело життя, у світлі Твоєму ми бачимо світло. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Продовж Свою милість для тих, хто Тебе знає, і праведність Свою – для щирих серцем. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Нехай не наступить на мене нога зухвалого, нехай не вижене мене рука нечестивого. ");
INSERT INTO ukronpu_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Поглянь-но: ось там упали ті, що чинять беззаконня, вони повалені й встати не можуть! ");
INSERT INTO ukronpu_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Псалом Давидів. Не роздратовуйся через злих людей, не заздри тим, хто чинить беззаконно; ");
INSERT INTO ukronpu_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","адже вони, немов трава, скоро засохнуть, і, як зелена поросль, зів’януть. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Покладай надію на Господа й роби добро, мешкай на землі й оберігай вірність. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Насолоджуйся Господом, і Він дасть тобі те, чого прагне твоє серце. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Розкрий перед Господом шлях, задуманий тобою, довірся Йому, і Він усе здійснить; ");
INSERT INTO ukronpu_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Він виведе твою правду, як світло дня, і справедливість твою – як сяйво сонця опівдні. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","У безмовній тиші будь перед Господом і на Нього сподівайся. Не роздратовуйся, коли дорога нечестивого успішна, коли він здійснює свої підступні задуми. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Вгамуй гнів і полиши роздратування, не дратуйся, бо це призводить лише до лиха. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Адже злодії будуть викорінені, а ті, хто надію покладає на Господа, вспадкують землю. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Ще трохи, і не стане нечестивого, придивишся до місця, де він був, а його там немає. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","А смиренні вспадкують землю і будуть насолоджуватись величним спокоєм. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Задумує нечестивий лихе на праведного й скрегоче на нього своїми зубами, ");
INSERT INTO ukronpu_vpl VALUES ("PS36_13","020_36_13","PSA","36","13","13","та Володар посміється з нього, адже Він бачить, що наближається день його покарання. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_14","020_36_14","PSA","36","14","14","Мечі із піхов дістають нечестиві й натягують свої луки, щоб на землю повалити пригніченого й бідняка, щоб згубити тих, чиї дороги справедливі. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_15","020_36_15","PSA","36","15","15","Та мечі їхні у їхні ж серця увійдуть, і луки їхні зламаються. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_16","020_36_16","PSA","36","16","16","Невеликий статок праведника кращий, ніж багатство численних нечестивців, ");
INSERT INTO ukronpu_vpl VALUES ("PS36_17","020_36_17","PSA","36","17","17","бо рамена нечестивих зламаються, а праведних підтримає Господь. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_18","020_36_18","PSA","36","18","18","Знає Господь дні невинних, і спадщина їхня буде повіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_19","020_36_19","PSA","36","19","19","Не будуть вони вкриті ганьбою в час біди і в дні голоду ситими будуть. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_20","020_36_20","PSA","36","20","20","Але нечестиві загинуть, і вороги Господа, як краса пасовищ, зникнуть, розвіються, мов дим. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_21","020_36_21","PSA","36","21","21","Позичає нечестивий, та не повертає боргу, а праведний милує і дає. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_22","020_36_22","PSA","36","22","22","Тому благословенні Господом успадкують землю, а прокляті Ним викорінені будуть. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_23","020_36_23","PSA","36","23","23","Господь утверджує кроки праведного мужа, і його шлях Йому до вподоби. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_24","020_36_24","PSA","36","24","24","Якщо той спіткнеться, то не впаде, бо Господь підтримує його за руку. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_25","020_36_25","PSA","36","25","25","Я був юнаком і вже постарів, та не бачив, щоб праведний був покинутий і щоб нащадки його просили хліба. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_26","020_36_26","PSA","36","26","26","Щодня він виявляє милосердя й позичає іншим, тому нащадки його будуть благословенні. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_27","020_36_27","PSA","36","27","27","Ухиляйся від зла й роби добро – і житимеш повік. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_28","020_36_28","PSA","36","28","28","Бо Господь любить справедливий суд і вірних Йому не покине. Вони будуть збережені навіки, а нащадки нечестивих будуть викорінені. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_29","020_36_29","PSA","36","29","29","Праведні вспадкують землю й мешкатимуть на ній повіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_30","020_36_30","PSA","36","30","30","Вуста праведного промовляють мудрість, і язик його говорить справедливе. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_31","020_36_31","PSA","36","31","31","Закон його Бога у нього в серці, тому не похитнуться його кроки. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_32","020_36_32","PSA","36","32","32","Нечестивий підстерігає праведного й шукає можливості його вбити. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_33","020_36_33","PSA","36","33","33","Та Господь не залишить його в руках зловмисника й не дасть звинуватити його на суді. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_34","020_36_34","PSA","36","34","34","Надійся на Господа й тримайся Його дороги, тоді Він звеличить тебе, щоб ти вспадкував землю, і побачиш ти, як будуть викорінені нечестиві. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_35","020_36_35","PSA","36","35","35","Я бачив жорстокого нечестивця, що буяв, немов міцно укорінене дерево з пишним листям. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_36","020_36_36","PSA","36","36","36","Та минув він, і ось тепер немає його; шукав я його, та не знайшов. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_37","020_36_37","PSA","36","37","37","Тримайся того, як поводиться невинний, і дивися на праведного, адже майбуття належить людині мирній. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_38","020_36_38","PSA","36","38","38","А всі беззаконні будуть знищені, майбуття нечестивих буде викорінене геть. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_39","020_36_39","PSA","36","39","39","Порятунок праведних – від Господа, Він твердиня їхня в час скорботи. ");
INSERT INTO ukronpu_vpl VALUES ("PS36_40","020_36_40","PSA","36","40","40","Допоможе їм Господь і визволить їх, визволить їх від нечестивих і врятує, бо на Нього вони покладають надію. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Псалом Давидів. На спомин. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Господи, не докоряй мені у гніві Твоєму й не картай мене у люті Твоїй. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Бо стріли Твої пронизали мене й рука Твоя мене тяжко вдарила. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Немає жодного цілого місця на моєму тілі через пересердя Твоє, немає здоров’я в кістках моїх через гріх мій. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Бо беззаконня мої накрили мою голову, немов важкий тягар, тяжіють наді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Смердять, ятріють мої рани через божевілля моє. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Похилений і занадто пригнічений, цілий день ходжу я понуро. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Бо стегна мої повні палючого болю, і немає цілого місця на тілі у мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Я заціпенілий і вкрай розбитий духом, волаю через стогони мого серця. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Володарю, усі бажання мої перед Тобою, і зітхання мої від Тебе не приховані. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Серце моє тріпотить, сила моя полишила мене, і світла в очах моїх не стало. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Мої друзі й приятелі уникають мене через мої побої, і близькі мої стали поодаль. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Розставляють пастки ті, хто шукає душі моєї; про загибель мою розмовляють ті, хто бажає мені зла; цілий день міркують про підступи. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","А я, наче глухий, не чую, як німий, не відкриваю вуст. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Я став ніби той, що не чує і в чиїх вустах немає виправдання. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Та на Тебе, Господи, сподіваюся; Ти відповіси мені, мій Володарю, мій Боже! ");
INSERT INTO ukronpu_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Бо казав я Тобі: «Нехай же вони не зловтішаються з мене; коли похитнулася нога моя, нехай не величаються наді мною». ");
INSERT INTO ukronpu_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Бо я стою хитаючись, і скорбота моя завжди переді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Адже я визнаю беззаконня моє, сумую через мій гріх. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","А вороги мої живі та могутні, численними стали ті, хто ненавидить мене даремно. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Вони віддячують мені злом за добро, ворогують проти мене за те, що я прагну добра. ");
INSERT INTO ukronpu_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Не покинь мене, Господи, Боже мій, не віддаляйся від мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Поспіши мені на допомогу, Володарю мій, Спасителю мій! ");
INSERT INTO ukronpu_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Керівнику хору Єдутуну. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Я сказав: «Я стежитиму за своїми життєвими дорогами, від гріха утримуватиму язик свій, вустам моїм поставлю перепону, поки нечестивий переді мною». ");
INSERT INTO ukronpu_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Я онімів, затих, мовчав навіть про добре, та біль мій внутрішній лише роз’ятрився, ");
INSERT INTO ukronpu_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","серце моє запалало зсередини. Коли я роздумував, загорівся вогонь, тоді я промовив язиком своїм: ");
INSERT INTO ukronpu_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","«Дай мені знати, Господи, час мого кінця і яка кількість моїх днів? Хотів би я знати, наскільки швидкоплинне життя моє. ");
INSERT INTO ukronpu_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Ось Ти дав мені днів лише на ширину долоні, і тривалість мого життя – як ніщо перед Тобою. Справді, кожна людина, що існує, – лише пара. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Так, людина снує в сутінках, марно клопочеться, накопичує, та не знає, хто забере все це. ");
INSERT INTO ukronpu_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Тож на що мені тепер надіятися, мій Володарю? Лише на Тебе моє сподівання. ");
INSERT INTO ukronpu_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Визволи мене від усіх беззаконь моїх, не віддавай мене на глузування нерозумним. ");
INSERT INTO ukronpu_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Я онімів, не відкриваю вуст моїх, бо Ти зробив так. ");
INSERT INTO ukronpu_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Відведи від мене удар Твій; від стусанів Твоїх я гину. ");
INSERT INTO ukronpu_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Докорами за беззаконня Ти караєш людину й нищиш її красу, як міль. Справді, кожна людина – марнота. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Почуй молитву мою, Господи, і прислухайся до зойку мого; не мовчи щодо сліз моїх, адже я лише приходько в Тебе, тимчасовий поселенець, як і всі прабатьки мої. ");
INSERT INTO ukronpu_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Відведи Свій суворий погляд від мене, щоб я трохи порадів, перш ніж я піду й мене не стане». ");
INSERT INTO ukronpu_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Непохитно я надіявся на Господа, і Він прихилився до мене й почув моє волання. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Він підняв мене зі згубної ями, із багнистої трясовини. Він поставив мої ноги на скелі, непохитними зробив мої стопи. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","І вклав Він в уста мої нову пісню – хвалу нашому Богові. Багато хто побачить це й наповниться страхом, і на Господа покладатися буде. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Блаженний той, хто поклав свою надію на Господа й хто не звертається до пихатих і схильних до брехні. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Численні чудеса, які Ти, Господи, Боже мій, здійснив, і задуми Твої щодо нас! Немає того, хто став би нарівні з Тобою! Я сповіщав би та розповідав про них, та настільки численні вони, що не переповісти. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Не забажав Ти ані жертви, ані дару, та вуха мої зробив чуйними. Ні цілопалення, ні жертви за гріх Ти не вимагав. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Тоді сказав я: «Ось я прийшов, у сувої книги написано про мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Я бажаю виконати Твою волю, мій Боже, і Закон Твій у нутрі моєму». ");
INSERT INTO ukronpu_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Я звіщав правду у великому зібранні; вуст своїх я не стуляв – Ти, Господи, знаєш. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Праведність Твою я не приховував у моєму серці, говорив про вірність Твою й спасіння Твоє. Не затаїв я милості й істини Твоєї перед великим зібранням. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Ти ж, Господи, не стримуй Свого милосердя від мене, Твоя милість та істина нехай завжди мене оберігають. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Бо оточили мене біди – немає їм ліку! Настигли мене беззаконня мої, так що не можу я бачити. Вони стали численнішими за волосся на моїй голові; серце моє завмерло. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_14","020_39_14","PSA","39","14","14","Нехай бажанням Твоїм, Господи, буде визволити мене! Господи, поспіши мені на допомогу! ");
INSERT INTO ukronpu_vpl VALUES ("PS39_15","020_39_15","PSA","39","15","15","Нехай посоромляться й ганьбою вкриються ті, хто шукає душі моєї, щоб забрати її. Нехай відсахнуться назад і спіткнуться ті, хто бажає мені зла. ");
INSERT INTO ukronpu_vpl VALUES ("PS39_16","020_39_16","PSA","39","16","16","Нехай вжахнуться через свій сором ті, що говорять мені: «Ага! Ага!» ");
INSERT INTO ukronpu_vpl VALUES ("PS39_17","020_39_17","PSA","39","17","17","Нехай же веселяться й радіють Тобою всі, хто шукає Тебе. Нехай ті, хто любить спасіння Твоє, говорять безупинно: «Звеличився Господь!» ");
INSERT INTO ukronpu_vpl VALUES ("PS39_18","020_39_18","PSA","39","18","18","Я ж принижений та бідний, нехай Владика думає про мене. Ти – Допомога моя і Визволитель мій; Боже мій, не зволікай! ");
INSERT INTO ukronpu_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Блаженний той, хто дбає про слабкого: у день лиха Господь його врятує. ");
INSERT INTO ukronpu_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Господь берегтиме його й додасть йому життєвих сил, нагородить його щастям на землі й не віддасть його на поталу ворогам. ");
INSERT INTO ukronpu_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Господь підтримає його на ложі під час недуги, відновить його повністю після хвороби. ");
INSERT INTO ukronpu_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Я сказав: «Господи, помилуй мене, зціли мою душу, бо я згрішив перед Тобою». ");
INSERT INTO ukronpu_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Вороги мої злісно говорять про мене: «Коли ж він нарешті помре й ім’я його загине?» ");
INSERT INTO ukronpu_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","А коли хто приходить побачитись зі мною, то промовляє нікчемні слова, у серці своєму збирає чутки про беззаконня, а потім виходить і поширює скрізь. ");
INSERT INTO ukronpu_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Шепочуться разом проти мене всі, хто ненавидить мене, думають про мене зле: ");
INSERT INTO ukronpu_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","«Кара за віроломство спіткала його; він зліг через хворобу й більше не встане». ");
INSERT INTO ukronpu_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Навіть близький друг мій, якому я довіряв, той, хто їв мій хліб, підняв на мене свою п’яту. ");
INSERT INTO ukronpu_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Ти ж, Господи, помилуй мене; підніми мене, і я віддячу їм! ");
INSERT INTO ukronpu_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Через це я дізнаюся, що Ти прихильний до мене, коли не вигукне переможно мій ворог наді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Адже Ти підтримаєш мене заради невинності моєї й поставиш мене перед обличчям Твоїм навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Благословенний Господь, Бог Ізраїлю, споконвіку й навіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Керівнику хору. Повчання синів Кореєвих. ");
INSERT INTO ukronpu_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Як олень лине до потоків води, так душа моя лине до Тебе, Боже. ");
INSERT INTO ukronpu_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Душа моя спрагла Бога, живого Бога. Коли ж прийду я й постану перед Богом? ");
INSERT INTO ukronpu_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Сльози мої були для мене хлібом вдень і вночі, коли говорили мені щодня: «Де твій Бог?» ");
INSERT INTO ukronpu_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Ось про що я згадую, і виливається від туги душа моя: коли проходив я у велелюдній ході, підступаючи до дому Божого із вигуками радості й слави серед святкового натовпу. ");
INSERT INTO ukronpu_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Чому ти сумуєш, душе моя, і чому журишся в мені? Сподівайся на Бога, адже я ще прославлятиму Його – мого Спасителя! ");
INSERT INTO ukronpu_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Боже мій, за Тобою сумує душа моя, тому я згадую про Тебе із землі Йордану, із висот Хермону, з гори Міцар. ");
INSERT INTO ukronpu_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Безодня до безодні кличе шумом Твоїх водоспадів; усі Твої буруни та хвилі пройшли наді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Удень заповість Господь Своїй милості прийти до мене, а вночі у мене лине Йому пісня, молитва Богові мого життя. ");
INSERT INTO ukronpu_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Скажу-но я Богові, скелі моїй: «Чому Ти забув мене? Чому я ходжу понуро, пригнічений ворогом?» ");
INSERT INTO ukronpu_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","У кістках моїх – виснаження; глузують з мене мої супротивники, щодня промовляючи до мене: «Де твій Бог?» ");
INSERT INTO ukronpu_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Чому ти сумуєш, душе моя, і чому журишся в мені? Сподівайся на Бога, адже я ще прославлятиму Його – Спасителя мого й Бога мого. ");
INSERT INTO ukronpu_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Суди мене, Боже, і вступися за мене в суперечці моїй із невірним народом, від людини підступної й беззаконної визволи мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Адже Ти – Бог, твердиня моя. Чому Ти відкинув мене? Чому я ходжу понуро, пригнічений ворогом? ");
INSERT INTO ukronpu_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Пошли Твоє світло й істину – нехай вони керують мною, нехай приведуть мене на гору святині Твоєї, до місця, де Ти мешкаєш. ");
INSERT INTO ukronpu_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Тоді я підійду до жертовника Божого, до Бога, Який дарує мені радість і втіху. І я прославлю Тебе грою на арфі, о Боже, Боже мій! ");
INSERT INTO ukronpu_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Чому ти сумуєш, душе моя, і чому журишся в мені? Сподівайся на Бога, адже я ще прославлятиму Його – Спасителя мого й Бога мого. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Керівнику хору. Повчання синів Корея. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Боже, ми чули своїми вухами, батьки наші розповідали нам про величні діяння, що вчинив Ти у давні дні. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Ти вигнав Своєю рукою народи, а предків наших насадив на цій землі, Ти вразив племена і вислав їх геть. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Адже не мечем своїм батьки наші взяли у спадок землю і не їхня міцна рука принесла їм перемогу, а Твоя правиця, Твоя міць і світло Твого обличчя, бо Ти вподобав їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Ти – Цар мій, Боже. Накажи дати перемогу Якову! ");
INSERT INTO ukronpu_vpl VALUES ("PS43_6","020_43_6","PSA","43","6","6","З Тобою ми здолаємо в битві супротивників наших, в ім’я Твоє потопчемо тих, хто повстав проти нас. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_7","020_43_7","PSA","43","7","7","Бо не на лук свій я покладаю надію і не меч мій дарує мені перемогу. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_8","020_43_8","PSA","43","8","8","Але Ти рятуєш нас від супротивників наших і ненависників наших вкриваєш ганьбою. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_9","020_43_9","PSA","43","9","9","Богом ми хвалимось цілий день і Твоє ім’я прославлятимемо повік. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS43_10","020_43_10","PSA","43","10","10","Тепер же Ти покинув і посоромив нас, і більше не виходиш разом із воїнствами нашими на битву. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_11","020_43_11","PSA","43","11","11","Ти змусив нас втікати назад від супротивника, і ненависники наші грабують нас. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_12","020_43_12","PSA","43","12","12","Ти віддав нас, як овець, на поїдання і розсіяв нас серед народів. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_13","020_43_13","PSA","43","13","13","Ти продав народ Твій за безцінь, не отримавши від його продажу жодного зиску. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_14","020_43_14","PSA","43","14","14","Ти вкрив нас ганьбою перед сусідами нашими, глузуванням і знущанням перед усіма, хто оточує нас. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_15","020_43_15","PSA","43","15","15","Приказкою глузливою Ти зробив нас серед народів, племена хитають насмішливо головами в наш бік. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_16","020_43_16","PSA","43","16","16","Щодня безчестя моє переді мною, і сором вкриває моє обличчя ");
INSERT INTO ukronpu_vpl VALUES ("PS43_17","020_43_17","PSA","43","17","17","через те, що голос лихослова й глузія я чую, через ворога й месника. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_18","020_43_18","PSA","43","18","18","Усе це лихо спіткало нас, хоча ми не забули Тебе й не зрадили Завіту Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_19","020_43_19","PSA","43","19","19","Серця наші не відступили назад, і наші стопи не збочили з Твоєї стежки. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_20","020_43_20","PSA","43","20","20","Але Ти вразив нас у пустельному місці, де мешкають шакали, і вкрив нас тінню смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_21","020_43_21","PSA","43","21","21","Якби ми забули ім’я Бога нашого й простягнули долоні наші до чужого бога, ");
INSERT INTO ukronpu_vpl VALUES ("PS43_22","020_43_22","PSA","43","22","22","хіба Бог не виявив би цього? Адже Він знає приховані глибини серця. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_23","020_43_23","PSA","43","23","23","Однак заради Тебе нас убивають щодня, вважають нас за овець, призначених на заколення. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_24","020_43_24","PSA","43","24","24","Прокинься! Чому Ти спиш, Владико? Пробудись! Не покидай нас навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_25","020_43_25","PSA","43","25","25","Чому Ти ховаєш Своє обличчя, забуваючи про приниження й гніт наш? ");
INSERT INTO ukronpu_vpl VALUES ("PS43_26","020_43_26","PSA","43","26","26","Адже до пороху земного зведена душа наша, до землі прилинуло нутро наше. ");
INSERT INTO ukronpu_vpl VALUES ("PS43_27","020_43_27","PSA","43","27","27","Повстань, будь нам допомогою! Визволи нас заради милості Твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Керівнику хору. На мотив «Лілея». Повчання синів Корея. Пісня кохання. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Зворушилося моє серце від слова прекрасного, я виконаю свій твір для царя. Язик мій – тростина вправного писця. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Ти став найгарнішим серед усіх синів людських, благодать вилилась на вуста твої, тому Бог благословив тебе навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Підпережи, о могутній, свої стегна мечем, славою твоєю й величчю! ");
INSERT INTO ukronpu_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","І в такому величному вбранні своєму переможно мчися верхи заради істини, смирення й правди. Нехай правиця твоя звершить грізні вчинки. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Твої стріли нагострені – нехай впадуть під твої ноги народи, нехай вразять вони серця ворогів царя. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Престол Твій, Боже, – повік-віків, жезл справедливості – жезл Твого Царства. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Ти полюбив правду й зненавидів беззаконня; тому помазав Тебе Бог, Твій Бог, олією радощів більше, ніж Твоїх друзів. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Миром, алое й корицею пашіють усі твої шати; із палаців, прикрашених слоновою кісткою, струни арф тебе радують. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Серед придворних шляхетних жінок твоїх – доньки царів. Стоїть цариця по твоїй правиці – уся в щирому золоті з Офіру. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Послухай-но, донько, обміркуй і ось до чого прихили твоє вухо: забудь народ твій і дім твого батька, ");
INSERT INTO ukronpu_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","і тоді цар зажадає твоєї краси, адже він – твій володар, тож вклонися йому. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Тоді донька Тируприйде з дарами й багатії з народу твого шукатимуть прихильності твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Уся слава доньки царя – усередині покоїв, її одяг гаптований золотом. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","У вишиваних шатах ведуть її до царя; весільних подруг підводять до тебе услід за нею, о царю. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Ведуть їх із радістю й веселощами, вони входять до палацу царя. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Замість предків твоїх, о царю, будуть сини твої; Ти поставив їх князями по всій землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Я зроблю так, що ім’я твоє пам’ятатимуть із роду в рід, тому народи прославлятимуть тебе повік-віків. ");
INSERT INTO ukronpu_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Керівнику хору. Синів Кореєвих пісня. На мотив аламот. ");
INSERT INTO ukronpu_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Бог – пристановище наше й міць, допомога в скорботах, що завжди знаходиться поруч. ");
INSERT INTO ukronpu_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Тому ми не злякаємось, хоч би навіть земля здригнулася й гори ринули в морську безодню, ");
INSERT INTO ukronpu_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","так що заревли б і запінилися води від їхнього падіння, і скелі б затремтіли від того збурення води. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Річкові потоки радують місто Боже, святилище, де мешкає Всевишній. ");
INSERT INTO ukronpu_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Бог посеред нього – воно не захитається; Бог допоможе йому ще вдосвіта. ");
INSERT INTO ukronpu_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Збентежилися народи, похитнулися царства, подав Він Свій голос – тане земля. ");
INSERT INTO ukronpu_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Господь Воїнств із нами; Твердиня наша – Бог Якова. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Підіть-но, погляньте на діяння Господа, які спустошення здійснив Він на землі, ");
INSERT INTO ukronpu_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","припиняючи війни аж до краю землі. Він ламає лук і розщеплює древко списа, колісниці спалює вогнем. ");
INSERT INTO ukronpu_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","«Вгамуйтеся й пізнайте, що Я – Бог; Я буду звеличений серед народів, звеличений на землі». ");
INSERT INTO ukronpu_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Господь Воїнств із нами, Твердиня наша – Бог Якова. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Керівнику хору. Псалом синів Кореєвих. ");
INSERT INTO ukronpu_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Усі народи, плескайте в долоні, вигуки радості нехай лунають на славу Богові. ");
INSERT INTO ukronpu_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Бо Господь Всевишній грізний, Він Цар великий над усією землею! ");
INSERT INTO ukronpu_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Він підкорив нам народи й племена кинув під наші ноги. ");
INSERT INTO ukronpu_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Він обрав для нас спадок – гордість Якова, якого полюбив. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Бог піднявся під радісні вигуки, Господь піднісся під голос сурми. ");
INSERT INTO ukronpu_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Співайте Богові, співайте! Співайте Цареві нашому, співайте! ");
INSERT INTO ukronpu_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Бо Цар усієї землі – Бог, співайте псалом із розумінням. ");
INSERT INTO ukronpu_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Бог царює над народами, Бог сидить на Своєму святому престолі. ");
INSERT INTO ukronpu_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Шляхетні з народів зібралися разом із народом Бога Авраамового, адже Богу належать захисники землі – Він високо піднесений над ними. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Пісня. Псалом синів Кореєвих. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Великий Господь і прославлений вельми у місті нашого Бога, на Своїй святій горі. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Краса невимовна, радість усієї землі – гора Сіон на північних околицях, місто великого Царя. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Бог перебуває в її палацах, Він знаний як твердиня. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Ось царі зібралися, пішли разом проти нас ");
INSERT INTO ukronpu_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","та, побачивши таку святість, здивувалися, збентежилися, пустилися навтіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Трепет охопив їх там, мука, як у породіллі. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Східним вітром розбив Ти кораблі Таршишу. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Про що ми чули раніше, те й побачили у місті Господа Воїнств, місті Бога нашого: Бог утверджує його навіки. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS47_10","020_47_10","PSA","47","10","10","Ми роздумували, Боже, про милість Твою всередині Твого Храму. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_11","020_47_11","PSA","47","11","11","Як ім’я Твоє, Боже, так і хвала Твоя – до самого краю землі! Твоя правиця сповнена правди. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_12","020_47_12","PSA","47","12","12","Радіє гора Сіон, веселяться доньки Юдеї через Твоє правосуддя. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_13","020_47_13","PSA","47","13","13","Обійдіть навколо Сіон, порахуйте його вежі. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_14","020_47_14","PSA","47","14","14","уважно розгляньте його укріплення, пройдіть між палацами, щоб потім ви розповіли наступному поколінню. ");
INSERT INTO ukronpu_vpl VALUES ("PS47_15","020_47_15","PSA","47","15","15","Адже це – Бог, наш Бог на віки вічні! Він вестиме нас аж до смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Керівнику хору. Синів Кореєвих псалом. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Послухайте це, усі народи, зважте, усі мешканці плинного світу, ");
INSERT INTO ukronpu_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","сини Адамові, сини людські, – як багаті, так і бідні. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Вуста мої промовлять мудрість, і роздуми мого серця – глибоке розуміння. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Схилю своє вухо до притчі, відкрию під звуки арфи мою загадку: ");
INSERT INTO ukronpu_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Чого мені боятися в дні лиха, коли беззаконня лукавих оточить мене – ");
INSERT INTO ukronpu_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","тих, хто на власні статки покладає надію й багатством своїм вихваляється? ");
INSERT INTO ukronpu_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Але ж брата ніхто не зможе викупити, ніхто не дасть Богові належного викупу за нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Бо занадто дорогим був би викуп за його душу, тому повік не досягти того, ");
INSERT INTO ukronpu_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","щоб хтось жив вічно й не побачив безодні смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Адже кожен бачить, що мудрі помирають, і поряд із ними дурень і невіглас гине, залишаючи іншим свої статки. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Могили стали для них вічним домом, помешканнями їхніми з роду в рід. А вони називали своїми іменами землі! ");
INSERT INTO ukronpu_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Але ж людина не завжди перебуватиме в пошані, подібна вона до тварин, що гинуть. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Так, життєві дороги їхні – невігластво! Однак їхні наступники схвалюють те, що в них на вустах. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_15","020_48_15","PSA","48","15","15","Немов вівці, вони приготовані для царства смерті; смерть пастиме їх, а на ранок праведники пануватимуть над ними. Їхня міць виснажиться, безодня смерті – омріяне житло для них. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_16","020_48_16","PSA","48","16","16","Але Бог викупить душу мою з-під влади царства мертвих, коли прийме мене до Себе. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS48_17","020_48_17","PSA","48","17","17","Не переймайся, коли хтось багатіє, коли посилюється слава дому його. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_18","020_48_18","PSA","48","18","18","Адже в час смерті нічого не візьме він із собою, слава його не зійде вслід за ним до царства мертвих. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_19","020_48_19","PSA","48","19","19","Навіть якщо за життя він вважав себе благословенним, – адже хвалять тебе люди, коли ти добре собі робиш, – ");
INSERT INTO ukronpu_vpl VALUES ("PS48_20","020_48_20","PSA","48","20","20","однак піде він до роду своїх предків, так що повік світла не побачить. ");
INSERT INTO ukronpu_vpl VALUES ("PS48_21","020_48_21","PSA","48","21","21","Людина в пошані, але нерозумна, подібна до тварин, що гинуть. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Псалом Асафів. Бог богів – Господь! Він промовляє, закликає землю від сходу сонця аж до заходу. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Із Сіону, досконалої краси, Бог з’явився в сяйві. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Іде наш Бог і не мовчить; вогонь перед Ним пожирає й навколо Нього сильно вирує. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Він закликає небеса вгорі і землю на суд зі Своїм народом: ");
INSERT INTO ukronpu_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","«Зберіть-но до Мене Моїх вірних, хто уклав Завіт зі Мною при жертві». ");
INSERT INTO ukronpu_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","І небеса сповіщатимуть правду Його, адже Суддя – Сам Бог! Села ");
INSERT INTO ukronpu_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","«Слухай, народе Мій, Я говоритиму; Ізраїлю, Я свідчити буду проти тебе: Я – Бог, твій Бог. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Не за жертвоприношення твої Я докорятиму тобі – твої цілопалення завжди переді Мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Я не прийму вола із твого дому, ані козлів із твоїх кошар. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Адже всі тварини в лісі – Мої, і худоба на тисячі пагорбів. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Я знаю кожного птаха в горах, і все, що рухається на полях, – зі Мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Якби Я був голодний, то не сказав би тобі про це, адже Мені належить всесвіт і все, що його наповнює. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Хіба Я їм м’ясо биків чи п’ю кров козлів? ");
INSERT INTO ukronpu_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Принеси Богові в жертву подяку й виконай перед Всевишнім твої обітниці. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Поклич Мене в день скорботи – Я визволю тебе, а ти Мене прославиш». ");
INSERT INTO ukronpu_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Нечестивому ж говорить Бог: «Як ти смієш Мої постанови сповіщати і Завіт Мій в устах своїх носити? ");
INSERT INTO ukronpu_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Ти ж ненавидиш настанови й кидаєш Слова Мої позад себе? ");
INSERT INTO ukronpu_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Коли ти бачиш крадія, заводиш із ним приязні стосунки; і від перелюбників маєш свою частку. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Вуста твої вживаєш для зла, і язик твій плете підступні каверзи. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Сидиш на суді, намовляєш на брата твого, проти сина своєї матері свідчиш ганебне. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_21","020_49_21","PSA","49","21","21","Ти чинив це, а Я мовчав, тому уявив ти собі, що Я такий, як ти. Я покараю тебе й виставлю звинувачення перед очима твоїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_22","020_49_22","PSA","49","22","22","Зрозумійте ж це ті, хто забуває Бога, щоб Я не розтерзав вас, і не буде кому врятувати. ");
INSERT INTO ukronpu_vpl VALUES ("PS49_23","020_49_23","PSA","49","23","23","Той, хто приносить у жертву подяку, шанує Мене; і тому, хто торує дорогу правди, покажу Я спасіння Боже». ");
INSERT INTO ukronpu_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Керівнику хору. Псалом Давидів, ");
INSERT INTO ukronpu_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","коли приходив до нього пророк Натан, після того, як Давид учинив перелюб із Вірсавією. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Помилуй мене, Боже, заради милості Твоєї, заради великого милосердя Твого загладь мої беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Обмий мене від переступу мого й від гріха мого мене очисти, ");
INSERT INTO ukronpu_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","адже я усвідомлюю беззаконня своє, і гріх мій завжди переді мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Проти Тебе Самого згрішив я і зло вчинив у Твоїх очах. Тому Ти справедливо виконуєш Свій вирок, бездоганно здійснюєш Твій суд. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Ось у беззаконні я народжений, і мати моя зачала мене в гріху. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ось істину Ти вподобав у надрах внутрішнього світу і мудрість сповіщаєш мені утаємничено. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Очисти мене гісопом від гріха – і буду чистий; ретельно обмий мене – і буду біліший від снігу. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Дай мені почути звуки веселощів і радості, нехай зрадіють кістки, вражені Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Відверни обличчя Своє від гріхів моїх і загладь усі мої беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Створи в мені серце чисте, Боже, і дух непохитний обнови всередині мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Не відштовхни мене від обличчя Свого й не забирай від мене Твого Святого Духа. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Поверни мені радість Твого спасіння і Духом Твоїм турботливим підтримай мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Тоді беззаконних я навчатиму шляхів Твоїх і грішники навернуться до Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Зніми з мене тягар вини кровопролиття, Боже, Боже мого спасіння, тоді язик мій радісно прославлятиме Твою праведність. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Володарю, відкрий вуста мої, і вони сповіщатимуть Тобі хвалу. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Бо жертвоприношення Тобі не до вподоби – я приніс би його, цілопалення Ти не бажаєш. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Жертва Богові – дух зламаний; серцем зламаним і розбитим Ти не знехтуєш, Боже. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ощаслив Сіон прихильністю Твоєю, збудуй стіни Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Тоді приємними Тобі будуть жертви правди, цілопалення та жертвоприношення, тоді покладуть на жертовник Твій волів. ");
INSERT INTO ukronpu_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Керівнику хору. Повчання Давидове, ");
INSERT INTO ukronpu_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","коли прийшов Доеґ-едомітянин до Саула й повідомив йому: «Давид у домі Ахімелеха». ");
INSERT INTO ukronpu_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Чому ти хизуєшся злодійством, сильний? Милість Божа зі мною цілий день! ");
INSERT INTO ukronpu_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Язик твій задумує загибель, він у тебе – немов нагострене лезо, підступнику! ");
INSERT INTO ukronpu_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Ти полюбив зло більше, ніж добро, брехню – сильніше, ніж правду говорити. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ти любиш усілякі згубні слова, о, підступний язику! ");
INSERT INTO ukronpu_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Але Бог уразить тебе навіки; вирве тебе й викине із шатра, і коріння твоє – із землі живих. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Тоді побачать це праведні й сповняться страхом, і сміятимуться над ним: ");
INSERT INTO ukronpu_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","«Ось муж, що не Бога зробив своєю твердинею, а покладався на безліч свого багатства, зміцнював себе згубною пристрастю своєю!» ");
INSERT INTO ukronpu_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","А я, немов ряснолиста маслина в домі Божому, на милість Божу сподіватимусь повік-віків. ");
INSERT INTO ukronpu_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Прославлятиму Тебе вічно перед Твоїми вірними за те, що Ти зробив, і надію покладатиму на ім’я Твоє, бо воно добре. ");
INSERT INTO ukronpu_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Керівнику хору. На мотив махалат. Повчання Давидове. ");
INSERT INTO ukronpu_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Промовив безумний у своєму серці: «Немає Бога». Розбестились вони, вчинили огидні беззаконня, немає нікого, хто б чинив добро. ");
INSERT INTO ukronpu_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Бог із небес поглядає на синів людських, щоб побачити, чи є серед них розумний, що шукає Бога. ");
INSERT INTO ukronpu_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Усі як один збочили з дороги, зіпсувалися; немає того, хто робив би добро, жодного немає. ");
INSERT INTO ukronpu_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Невже не схаменуться всі ті, хто чинить беззаконня, хто пожирає народ мій, немов хліб, хто Бога не кличе? ");
INSERT INTO ukronpu_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Там охопить їх страх, де немає чого боятися, Бо розкидає Бог кістки тих, хто оточив тебе; ти вкриєш їх ганьбою, адже Бог відцурався від них. ");
INSERT INTO ukronpu_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","О, хто дав би із Сіону порятунок Ізраїлеві! Коли Бог поверне з полону народ Свій, веселитиметься Яків, радітиме Ізраїль! ");
INSERT INTO ukronpu_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Керівнику хору. На струнних інструментах. Повчання Давидове, ");
INSERT INTO ukronpu_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","коли прийшли зіф’яни й сказали Саулові: «Хіба не у нас ховається Давид?» ");
INSERT INTO ukronpu_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Боже, врятуй мене іменем Твоїм і могутністю Своєю вступися на суді за мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Боже, почуй мою молитву, прислухайся до слів уст моїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Бо чужинці повстали проти мене й жорстокі серцем шукають душі моєї – ті, хто Бога не уявляє перед собою. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Ось Бог мені допомагає; Володар Вишній серед тих, хто підтримує мою душу. ");
INSERT INTO ukronpu_vpl VALUES ("PS53_7","020_53_7","PSA","53","7","7","Він віддячить за зло моїм супротивникам, знищить їх заради вірності Своєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS53_8","020_53_8","PSA","53","8","8","Із доброї волі принесу я Тобі жертву, прославлю ім’я Твоє, Господи, бо добре воно. ");
INSERT INTO ukronpu_vpl VALUES ("PS53_9","020_53_9","PSA","53","9","9","Адже від усіх скорбот Ти врятував мене, і око моє переможно дивилося на моїх ворогів. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Керівнику хору. На струнних інструментах. Повчання Давидове. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Прислухайся, Боже, до моєї молитви, не ховайся від мого благання; ");
INSERT INTO ukronpu_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","прислухайся до мене і дай мені відповідь! Я блукаю в тяжких думках своїх і зітхаю ");
INSERT INTO ukronpu_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","від голосу ворога, від утисків нечестивого. Бо вони наводять на мене беззаконня й гнівно ворогують зі мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Серце моє тремтить у моєму нутрі, жахи смерті напали на мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Страх і трепет увійшли в мене, і тремтіння охопило мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Сказав я: «Хто б дав мені крила голубині! Я полетів би й віднайшов спокій, ");
INSERT INTO ukronpu_vpl VALUES ("PS54_8","020_54_8","PSA","54","8","8","полинув би вдалечінь, спочив би в пустелі. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS54_9","020_54_9","PSA","54","9","9","Поспішив би знайти собі прихисток від рвучкого вітру й бурі». ");
INSERT INTO ukronpu_vpl VALUES ("PS54_10","020_54_10","PSA","54","10","10","Збентеж їх, Владико, розділи їм язики, бо бачу я насильство й заколот у місті. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_11","020_54_11","PSA","54","11","11","Удень та вночі вони обходять його на стінах, беззаконня й утиск всередині нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_12","020_54_12","PSA","54","12","12","Погибель серед міста, його гноблення й підступ не покидають вулиць. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_13","020_54_13","PSA","54","13","13","Адже не ворог ганьбить мене, – я перетерпів би це, – не ненависник мій величається наді мною, – я сховався б від нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_14","020_54_14","PSA","54","14","14","Але ти, кого я вважав одним цілим із собою, приятель мій, щирий друг мій, ");
INSERT INTO ukronpu_vpl VALUES ("PS54_15","020_54_15","PSA","54","15","15","з ким разом ми насолоджувалися щирим спілкуванням, у дім Божий ми ходили однодушно. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_16","020_54_16","PSA","54","16","16","Нехай же смерть спіткає їх, нехай вони зійдуть живими до царства мертвих, бо зло в їхніх помешканнях та в нутрощах їхніх. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_17","020_54_17","PSA","54","17","17","Я ж до Бога кличу, і Господь врятує мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_18","020_54_18","PSA","54","18","18","Увечері, вранці й опівдні я бідкаюся й бентежуся, і Він чує мій голос. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_19","020_54_19","PSA","54","19","19","Він мирно визволить мою душу від битви проти мене, бо численні ті, хто повстав на мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_20","020_54_20","PSA","54","20","20","Бог почує та упокорить їх, Той, Хто справіку сидить на престолі. Села Бо вони не змінюються й Бога не бояться. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_21","020_54_21","PSA","54","21","21","Підняв товариш мій руки свої на близьких друзів, знехтував своїм заповітом. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_22","020_54_22","PSA","54","22","22","Вуста його слизькі, немов масло, але війна в його серці; слова його ніжніші за олію, але вони – оголені мечі. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_23","020_54_23","PSA","54","23","23","Переклади свій тягар на Господа – і Він підтримає тебе; Він ніколи не дасть праведникові похитнутися. ");
INSERT INTO ukronpu_vpl VALUES ("PS54_24","020_54_24","PSA","54","24","24","Але Ти, Боже, скинеш їх до прірви загибелі. Люди кровожерні й підступні не дотягнуть навіть до половини своїх днів. А я на Тебе покладаюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Керівнику хору. На мотив «Голубка в далекій діброві». Міхтам Давидів, коли филистимляни схопили його в Ґаті. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Помилуй мене, Боже, бо цькує мене людина, цілий день, нападаючи, тисне на мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Цькують мене супротивники цілий день: багато-бо тих, хто гордовито воює проти мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","У день страху я на Тебе покладаю надію. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Я сподіваюся на Бога, Чиє слово прославляю, на Бога тільки й не боюся: що зробить мені тілесна істота? ");
INSERT INTO ukronpu_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Цілий день мої слова перекручують, усі їхні думки щодо мене – лише зло. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Вони сперечаються, спостерігають, стежать за моїми кроками, чатують на мою душу. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Не дай же їм уникнути кари за беззаконня; у гніві, Боже, кинь долілиць народи. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","О, якби полічив Ти мої поневіряння! Збери мої сльози в посудину, – хіба ж вони не у Твоїй книзі? ");
INSERT INTO ukronpu_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Тоді вороги мої обернуться назад, коли я покличу Тебе. Через це дізнаюсь я, що Бог зі мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","На Бога, Чиє слово я прославляю, на Господа, Чиє слово я славлю, ");
INSERT INTO ukronpu_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","на Бога покладаюсь я, тому не боятимуся: що зробить мені людина? ");
INSERT INTO ukronpu_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","На мені, Боже, обітниці, що дав я Тобі, – я виконаю обіцяні Тобі жертви подяки. ");
INSERT INTO ukronpu_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Бо Ти визволив мою душу від смерті, не дав спіткнутися нозі моїй, щоб я ходив перед Богом у світлі життя. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Керівнику хору. На мотив «Не згуби». Міхтам Давидів, коли він втік від Саула в печеру. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Помилуй мене, Боже, помилуй мене! Бо в Тобі лише знаходить притулок душа моя і в тіні Твоїх крил сховається, поки лихо мине. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Я кличу до Бога Всевишнього, до Бога, Який віддячує за мене ворогам моїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Він пошле з небес і врятує мене, посоромить того, хто прагне мене схопити; Села пошле Бог милість Свою й істину. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Душа моя – посеред левів; лежу я серед тих, що дихають полум’ям, серед синів людських, чиї зуби – списи й стріли, а язики їхні – гострий меч. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Піднімися понад небесами, Боже; над усією землею – слава Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Вони розкинули тенета стопам моїм; понурилася душа моя. Викопали переді мною яму – самі упали в неї! Села ");
INSERT INTO ukronpu_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Серце моє непохитне, Боже, непохитне серце моє! Співати буду й грати! ");
INSERT INTO ukronpu_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Прокинься, славо моя! Прокинься, ліро й арфо! Розбуджу-но я зорю досвітню! ");
INSERT INTO ukronpu_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Прославлю Тебе серед народів, Владико, співатиму Тобі поміж племенами. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Бо велика аж до небес милість Твоя і аж до хмар – істина Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Піднімися понад небесами, Боже; над усією землею – слава Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Керівнику хору. На мотив «Не згуби». Міхтам Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Чи справді ви, можновладці, говорите правду? Чи справедливо судите синів людських? ");
INSERT INTO ukronpu_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Авжеж! У серці чините беззаконня, на землі руки ваші наважуються на насильство. ");
INSERT INTO ukronpu_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Відступники нечестиві вже від утроби матері, блукають ще від лона материнського, брехню промовляючи. ");
INSERT INTO ukronpu_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Їхня отрута подібна до отрути зміїної, до отрути глухої рогатої змії, що затуляє свої вуха, ");
INSERT INTO ukronpu_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","щоб не чути голосу шептунів, які вміло складають свої заклинання. ");
INSERT INTO ukronpu_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Боже, розтрощи зуби в їхніх устах; вирви ікла у левів молодих, Господи! ");
INSERT INTO ukronpu_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Нехай зникнуть, як вода, що розтікається. Коли натягуватимуть лука, нехай стріли їхні будуть надломлені. ");
INSERT INTO ukronpu_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Нехай будуть немов слимак, що спливає слизом у спеку; як викидень у жінки, що сонця не бачив. ");
INSERT INTO ukronpu_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Перш ніж казани ваші відчують розпалений хмиз, – чи зелений ще, чи сухий вже, – нехай вихор рознесе його! ");
INSERT INTO ukronpu_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Радітиме праведник, коли побачить помсту на них, коли обмиє стопи свої у крові нечестивого. ");
INSERT INTO ukronpu_vpl VALUES ("PS57_12","020_57_12","PSA","57","12","12","Тоді скаже людина: «Справді, є плід у праведника! Справді, є Бог, Що судить на землі!» ");
INSERT INTO ukronpu_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Керівнику хору. На мотив «Не згуби». Міхтам Давидів, коли Саул послав людей стерегти його дім, щоб убити його. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Визволи мене від ворогів Моїх, Боже мій, захисти мене від тих, хто підноситься проти мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Від тих, що чинять беззаконня, визволи мене і від людей кровожерних врятуй мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Ось вони чатують на душу мою, сильні змовляються проти мене не за беззаконня моє чи гріх, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Немає беззаконня в мене, але збігаються вони й готуються до нападу. Піднімися назустріч мені й поглянь. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Ти, Господи, Боже Воїнств, Боже Ізраїлю, пробудися, щоб покарати всі народи; не помилуй жодного з нечестивих зрадників! Села ");
INSERT INTO ukronpu_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Вони повертаються в сутінках вечірніх, виють, немов пси, обступають місто звідусіль. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Ось вивергають вони ганьбу, в устах у них – мечі! На їхніх язиках приказка: «Хто чує?» ");
INSERT INTO ukronpu_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Але Ти, Господи, посмієшся з них, поглузуєш з усіх народів. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Сило моя, Тебе я пильную очікуючи, адже Ти, Боже, твердиня моя. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Бог, Що милує мене, піде поперед мене переможно; Бог покаже мені падіння супротивників моїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_12","020_58_12","PSA","58","12","12","Не вбивай їх, щоб не забув мій народ; розкидай їх силою Своєю і кинь їх долілиць, щите наш, Владико! ");
INSERT INTO ukronpu_vpl VALUES ("PS58_13","020_58_13","PSA","58","13","13","Гріх вуст їхніх – це слова, що губи їхні промовили. Нехай впіймані вони будуть гординею своєю за прокляття й кривду, що вони розповсюджують. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_14","020_58_14","PSA","58","14","14","Знищ їх у гніві, знищ, щоб не було їх! Тоді відомо стане аж до країв землі, що Бог володарює серед Якова. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS58_15","020_58_15","PSA","58","15","15","А вони повертаються в сутінках вечірніх, виють, немов пси, обступають місто звідусіль. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS58_16","020_58_16","PSA","58","16","16","Вони вештаються в пошуках їжі, та, не наситившись, ночують. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_17","020_58_17","PSA","58","17","17","А я буду співати про міць Твою і вранці радісно про милість Твою виспівувати. Адже Ти був для мене прихистком, притулком у день моєї скорботи. ");
INSERT INTO ukronpu_vpl VALUES ("PS58_18","020_58_18","PSA","58","18","18","Сило моя, Тобі я співатиму, адже Ти, Боже, твердиня моя, Бог, Який милує мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Керівнику хору. На мотив «Лілея свідчення». Міхтам Давидів. Для повчання. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Коли він виходив на війну проти Арам-Нагараїма й Арам-Цови, і коли Йоав повернувся і вразив дванадцять тисяч едомітів у Соляній долині. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Боже, Ти відкинув нас і зламав; Ти прогнівався на нас – повернися ж до нас знову! ");
INSERT INTO ukronpu_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Ти змусив землю тремтіти, вкрив її тріщинами; зціли її розломи, бо вона здригається. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Ти дав народові Своєму зазнати важких часів. Ти напоїв нас вином, від якого нас хитає. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Ти дав знамено тим, хто боїться Тебе, щоб вони, згуртувавшись навколо нього, стали недосяжними для ворожого лука. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Щоб улюблені Твої були визволені, врятуй нас правицею Своєю і дай нам відповідь. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Бог промовив у Своєму святилищі: «Урочисто святкуватиму перемогу, Я розділю Сихем і розміряю долину Суккот. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Мені належить Ґілеад, і Манассія – Мій, Єфрем – міць Моєї голови, Юда – Мій законодавець. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Моав – Моя чаша для омовіння, на Едом Я кину Свою сандалію, гукай радісно до Мене, о земле филистимлян!» ");
INSERT INTO ukronpu_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Хто введе мене в місто укріплене? Хто доведе мене до Едома? ");
INSERT INTO ukronpu_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Хіба не Ти, Боже, Котрий відкинув нас і не виходиш, Боже, з воїнствами нашими? ");
INSERT INTO ukronpu_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Подай нам допомогу в боротьбі з ворогом, адже марний порятунок людський. ");
INSERT INTO ukronpu_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","У Бозі ми виявимо силу, і Він розтопче наших ворогів. ");
INSERT INTO ukronpu_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Керівнику хору. На струнних інструментах. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Почуй, Боже, моє волання, зваж на мою молитву! ");
INSERT INTO ukronpu_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Від краю землі я кличу до Тебе в немочі мого серця. Підніми мене на скелю, що вища від мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Адже Ти – пристановище для мене, міцна вежа від нападів ворога. ");
INSERT INTO ukronpu_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Нехай би мешкав я в шатрі Твоєму вічно, спочивав би під покровом крил Твоїх безпечно. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Адже Ти, Боже, почув мої обітниці, дав мені спадщину тих, хто боїться Твого імені. ");
INSERT INTO ukronpu_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Додай цареві днів життя, продовж роки його в майбутніх поколіннях. ");
INSERT INTO ukronpu_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Нехай він перебуває вічно перед Богом, накажи милості й істині оберігати його. ");
INSERT INTO ukronpu_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Тоді я співатиму імені Твоєму повік, виконуючи мої обітниці щодня. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Керівнику хору, Єдутуну. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Лише в Бозі спокій моєї душі, від Нього моє спасіння. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Тільки Він – моя скеля і мій порятунок, твердиня моя – не захитаюся дуже. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Доки ви будете нападати на людину, усі разом добивати її, як похилену стіну, немов розхитану огорожу? ");
INSERT INTO ukronpu_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Радяться лише про те, щоб скинути її з високого місця, задоволення знаходять у брехні. Устами своїми благословляють, а в серці проклинають. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Лише в Бозі заспокоюйся, душе моя; бо лише на Нього надія моя. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Тільки Він – моя скеля і мій порятунок, твердиня моя – не захитаюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","У Бозі спасіння моє і слава моя; Він – могутня скеля моя, пристановище моє в Бозі. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_9","020_61_9","PSA","61","9","9","Народе, покладайся на Нього повсякчас, серця ваші виливайте перед Ним; Бог – пристановище наше. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS61_10","020_61_10","PSA","61","10","10","Сини людські – лише марнота, сини мужів – омана; якщо покласти їх на ваги, усі разом вони легші від пари. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_11","020_61_11","PSA","61","11","11","Не покладайтеся на гноблення інших і не хизуйтеся грабунком. Коли сила зростає, не прикладайте до неї серця. ");
INSERT INTO ukronpu_vpl VALUES ("PS61_12","020_61_12","PSA","61","12","12","Один раз Бог промовив, двічі я почув це: у Бога могутність, ");
INSERT INTO ukronpu_vpl VALUES ("PS61_13","020_61_13","PSA","61","13","13","у Тебе, Володарю, милість. Адже Ти віддячуєш кожному за його вчинки. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Псалом Давидів, коли він був у пустелі Юдейській. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Боже, Ти – мій Бог, Тебе я пристрасно шукаю. Душа моя спрагла Тебе, тіло моє тужить за Тобою у землі висохлій і виснаженій, де немає води. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Так я споглядав Тебе у святилищі, щоб побачити могутність Твою і славу. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Бо милість Твоя краща від самого життя, тому вуста мої хвалитимуть Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Я благословлятиму Тебе, поки житиму, в ім’я Твоє піднесу мої руки. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Неначе лоєм і олією, насичується душа моя, і вуста мої радісно прославляють Тебе, ");
INSERT INTO ukronpu_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","коли я згадую Тебе на моєму ложі, у нічні години роздумую про Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Бо Ти був мені допомогою, і в тіні Твоїх крил я радітиму. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Прилинула до Тебе душа моя, правиця ж Твоя підтримує мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","А ті, хто прагне загибелі для душі моєї, нехай зійдуть у глибини землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Нехай віддані мечу, вони стануть здобиччю лисиць. ");
INSERT INTO ukronpu_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Цар же нехай радіє Богом, нехай прославляють Його всі, хто Ним присягає, та замовкнуть вуста тих, хто промовляє неправду. ");
INSERT INTO ukronpu_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Боже, почуй мій голос, коли я скаржуся; убережи мою душу від погроз ворога. ");
INSERT INTO ukronpu_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Сховай мене від таємних задумів злочинців, від збурення тих, хто чинить беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Вони нагострили язики свої, немов мечі, націлили свої стріли – гіркі слова, ");
INSERT INTO ukronpu_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","щоб стріляти зі своїх засідок у невинного. Вони стріляють зненацька й не бояться. ");
INSERT INTO ukronpu_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Підбадьорюють себе у справі лихій, радяться, як таємно розставити тенета, і кажуть: «Хто їх побачить?» ");
INSERT INTO ukronpu_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Ретельно обдумують свої майбутні беззаконня: «Ми склали змову досконало!» Справді, глибока внутрішність людини та її серце! ");
INSERT INTO ukronpu_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Але Бог випустить у них стрілу зненацька – вони будуть уражені. ");
INSERT INTO ukronpu_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Він зробить так, що вони спіткнуться через язик свій і впадуть; відсахнуться від них усі, хто їх побачить. ");
INSERT INTO ukronpu_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Тоді страх охопить усіх людей, і будуть сповіщати про діяння Бога й про справи Його роздумувати. ");
INSERT INTO ukronpu_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Нехай праведник радіє в Господі й покладає на Нього надію. Тоді прославлені будуть усі щирі серцем. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Керівнику хору. Псалом Давидів. Пісня. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Тобі, Боже, належить тиха хвала на Сіоні, і перед Тобою будуть виконані обітниці. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Ти чуєш молитву; усе живе приходить до Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Здолали мене справи беззаконні, але Ти очистиш нас від переступів наших. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Блаженний той, кого Ти обираєш і наближуєш, щоб він мешкав у Твоїх дворах! Ми наситимося благами Твого дому, святого Твого Храму. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Ти справедливо відповідаєш нам діяннями, що страх наводять, Боже, Рятівнику наш, надіє всіх країв землі й далеких морів! ");
INSERT INTO ukronpu_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Ти, підперезаний могутністю, утверджуєш гори Своєю силою. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Ти втихомирюєш шум морів, шум їхніх хвиль і рик племен. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","І злякаються мешканці країв землі через знаменні діяння Твої. Вихід ранку й захід вечора Ти вигуками радості наповнюєш. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Ти турбуєшся про землю й напуваєш її, збагачуєш її щедро. Потік Божий повний води – Ти готуєш людям зерно, бо так влаштував Ти землю. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_11","020_64_11","PSA","64","11","11","Ти зволожуєш її ріллю, рівняєш її борозни, розм’якшуєш рясними дощами, благословляєш її збіжжя. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_12","020_64_12","PSA","64","12","12","Ти увінчуєш рік добротою Своєю, і стежки Твої крапають жиром. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_13","020_64_13","PSA","64","13","13","Крапають вологою пустельні пасовища, і радістю оперізуються пагорби. ");
INSERT INTO ukronpu_vpl VALUES ("PS64_14","020_64_14","PSA","64","14","14","Луги вдяглися отарами худоби, і долини вкрилися зерном. Усі радісно вигукують і співають! ");
INSERT INTO ukronpu_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Керівнику хору. Пісня. Псалом. Радісно вигукни Богові, уся земле! ");
INSERT INTO ukronpu_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Співайте славу імені Його, хвалу Йому гідно віддайте. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Скажіть Богові: «Які грізні діяння Твої! Заради великої могутності Твоєї плазують перед Тобою вороги Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Уся земля вклоняється Тобі й співає Тобі, співає славу імені Твоєму». Села ");
INSERT INTO ukronpu_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Прийдіть, погляньте на звершення Бога – Його справи викликають страх у синів людських. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Він перетворив море на суходіл, через річку перейшли вони ногами, там ми раділи в Ньому. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Він панує в могутності Своїй вічно, Його очі стежать пильно за народами – нехай не підносяться бунтівники! Села ");
INSERT INTO ukronpu_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Благословляйте, народи, Бога нашого й звіщайте голосно хвалу Йому. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Він зберіг серед живих душу нашу й не дав ногам нашим похитнутися. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Ти випробував нас, Боже, переплавив нас, як переплавляють срібло. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ти завів нас у сіть, поклав тягар на наші стегна. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Дозволив вершникам проїхати по головам нашим. Ми пройшли крізь вогонь і воду, але Ти вивів нас на благодатне місце. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Увійду я до дому Твого із цілопаленнями, виконаю для Тебе всі мої обітниці, ");
INSERT INTO ukronpu_vpl VALUES ("PS65_14","020_65_14","PSA","65","14","14","що їх висловили вуста мої і промовив язик мій у скорботі. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_15","020_65_15","PSA","65","15","15","Цілопалення жирних овець піднесу Тобі разом із димом від спалення баранів; я принесу Тобі в жертву биків і козлів. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS65_16","020_65_16","PSA","65","16","16","Прийдіть, послухайте, усі, хто боїться Бога, і я сповіщу вам, що Він зробив для душі моєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_17","020_65_17","PSA","65","17","17","До Нього я кликав моїми вустами, і хвала піднесена на язиці у мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_18","020_65_18","PSA","65","18","18","Якби я бачив беззаконня у своєму серці, то не почув би мене Володар. ");
INSERT INTO ukronpu_vpl VALUES ("PS65_19","020_65_19","PSA","65","19","19","Але Бог почув, зважив на голос моєї молитви! ");
INSERT INTO ukronpu_vpl VALUES ("PS65_20","020_65_20","PSA","65","20","20","Благословенний Бог, Що не відхилив моєї молитви й не забрав від мене милості Своєї! ");
INSERT INTO ukronpu_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Керівнику хору. На струнних інструментах. Псалом. Пісня. ");
INSERT INTO ukronpu_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Боже, змилуйся над нами й благослови нас; нехай засяє над нами Твоє обличчя, Села ");
INSERT INTO ukronpu_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","щоб на землі пізнали Твої дороги, і в усіх народах – Твоє спасіння. ");
INSERT INTO ukronpu_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Нехай прославлять Тебе народи, Боже, нехай прославлять Тебе усі народи! ");
INSERT INTO ukronpu_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Нехай радіють і радісно вигукують племена, бо Ти судиш народи справедливо й керуєш племенами на землі. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Нехай прославлять Тебе народи, Боже, нехай прославлять Тебе усі народи! ");
INSERT INTO ukronpu_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Земля принесла свій врожай; нехай благословить нас Бог, наш Бог! ");
INSERT INTO ukronpu_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Нехай благословить нас Бог, і боятимуться Його всі краї землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Керівнику хору. Псалом Давидів. Пісня. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Нехай устане Бог, нехай розсіються вороги Його; нехай втікають від Його обличчя ненависники Його! ");
INSERT INTO ukronpu_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Як розвіюється дим, так Ти їх розсій! Як тане віск від вогню, так нехай згинуть нечестивці від обличчя Божого. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","А праведники нехай радіють, нехай веселяться перед Богом і тішаться в радості. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Співайте Богові, грайте, підносьте ім’я Того, Села Хто на хмарах, як на колісниці, їде, Чиє ім’я – Господь; радійте перед обличчям Його! ");
INSERT INTO ukronpu_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Батько сиріт і Суддя вдів – Бог у Своїй Святій оселі. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Бог поселяє самотніх у дім, звільняє в’язнів на благодатні простори, а непокірні мешкають на виснаженій землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_8","020_67_8","PSA","67","8","8","Боже, коли Ти йшов перед народом, коли Ти крокував дикою пустелею, Села ");
INSERT INTO ukronpu_vpl VALUES ("PS67_9","020_67_9","PSA","67","9","9","земля здригалася, навіть небеса розпливалися перед обличчям Бога; перед Тим, Хто на Синаї, перед обличчям Бога Ізраїлю. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_10","020_67_10","PSA","67","10","10","Рясним дощем Ти зрошував, Боже, Свій спадок – землю Твою. А коли вона виснажувалася, Ти підтримував її. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_11","020_67_11","PSA","67","11","11","Твій люд поселився на ній; за добротою Твоєю, Боже, Ти підтримував пригнобленого. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_12","020_67_12","PSA","67","12","12","Володар промовив слово – сила-силенна благовісників передають його: ");
INSERT INTO ukronpu_vpl VALUES ("PS67_13","020_67_13","PSA","67","13","13","«Царі з військами зазнають поразки й втікають, а жінка, що мешкає вдома, ділить здобич війни. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_14","020_67_14","PSA","67","14","14","Навіть якщо ви затишно спочиваєте вдома, ви будете як та голубка, чиї крила вкриті сріблом, а пір’я її – переливним золотом». ");
INSERT INTO ukronpu_vpl VALUES ("PS67_15","020_67_15","PSA","67","15","15","Коли Всемогутній розсіяв царів на обраній Ним землі, це було як сніг, що випадає на гору Цальмон. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_16","020_67_16","PSA","67","16","16","Гора Божа – гора Башан; гора кількох вершин – гора Башан! ");
INSERT INTO ukronpu_vpl VALUES ("PS67_17","020_67_17","PSA","67","17","17","Чому ви заздрісно поглядаєте, гори з кількома вершинами, на гору, яку вподобав Бог, щоб перебувати на ній? Господь буде перебувати там повіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS67_18","020_67_18","PSA","67","18","18","Колісниць Божих – десятки тисяч, тисячі тисяч. Володар прийшов від Синаю у Своє святилище. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_19","020_67_19","PSA","67","19","19","Ти піднявся на висоту, полонив бранців, прийняв дари від людей, навіть від непокірних, щоб вони могли мешкати там, Господи Боже. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_20","020_67_20","PSA","67","20","20","Благословенний Володар! Він щоденно носить тягарі наші; Він – Бог, Який рятує нас. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS67_21","020_67_21","PSA","67","21","21","Бог для нас – Бог спасіння, і в Господа Володаря – визволення від смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_22","020_67_22","PSA","67","22","22","Так, Бог вразить голову ворогів Своїх, волохату маківку того, хто вперто ходить у своїх гріхах. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_23","020_67_23","PSA","67","23","23","Сказав Володар: «Із Башану поверну тебе, витягну з безодні морської, ");
INSERT INTO ukronpu_vpl VALUES ("PS67_24","020_67_24","PSA","67","24","24","щоб ти занурив ногу твою у кров ворогів і язики твоїх псів почастувалися нею». ");
INSERT INTO ukronpu_vpl VALUES ("PS67_25","020_67_25","PSA","67","25","25","Побачили вони ходу Твою, Боже, – як іде Бог мій, Цар мій у Святилищі. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_26","020_67_26","PSA","67","26","26","Попереду співаки йдуть, позаду – ті, хто грає на струнах, посередині – дівчата дзвенять на бубнах. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_27","020_67_27","PSA","67","27","27","Благословіть Бога на зборах, благословітьГоспода, нащадки Ізраїля. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_28","020_67_28","PSA","67","28","28","Там їх веде наймолодший Веніамін, потім князі Юди гуртом великим, а також князі Зевулонові й Нефалимові йдуть. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_29","020_67_29","PSA","67","29","29","Наказав Бог Твій зміцнити тебе. Дай, Боже, сили, як Ти робив це для нас раніше. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_30","020_67_30","PSA","67","30","30","Заради Храму Твого в Єрусалимі царі принесуть Тобі дари. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_31","020_67_31","PSA","67","31","31","Пригрози тому звірові в очереті, отому зібранню найсильніших телят народів, які забруднюють себе заради шматків срібла; розсій народи, що бажають війни. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_32","020_67_32","PSA","67","32","32","Прийдуть вельможні з Єгипту, Куш простягне свої руки до Бога. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_33","020_67_33","PSA","67","33","33","Царства землі, співайте Богові! Грайте на славу Володареві нашому, Села ");
INSERT INTO ukronpu_vpl VALUES ("PS67_34","020_67_34","PSA","67","34","34","Який їде на колісниці в небесах споконвічних: ось Він подасть Свій могутній голос. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_35","020_67_35","PSA","67","35","35","Визнайте, що сила у Бога, над Ізраїлем – Його велич, і могутність Його – на хмарах. ");
INSERT INTO ukronpu_vpl VALUES ("PS67_36","020_67_36","PSA","67","36","36","Страшний Бог у святилищі Своєму, Бог Ізраїлю, Який дає силу й міць народові. Благословенний Бог! ");
INSERT INTO ukronpu_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Керівнику хору. На мотив «Лілея». Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Врятуй мене, Боже, бо води дійшли аж до шиї! ");
INSERT INTO ukronpu_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Я загруз у глибокій трясовині й не маю опори; увійшов у глибокі води, вируючий потік накрив мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Я виснажився від крику, моє горло палає. Очі мої вичерпалися від сліз, виглядаючи мого Бога. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Ненависників моїх стало більше, ніж волосся на моїй голові. Численними стали вороги мої, що хочуть знищити мене безпідставно: те, чого я не забирав у них, усе ж мушу повернути. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Боже, ти знаєш мою нерозсудливість, і провина моя не прихована від Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Нехай же не будуть через мене засоромлені ті, хто на Тебе, Владико, Господи воїнств, покладає надію. Нехай не будуть принижені через мене ті, хто шукає Тебе, Боже Ізраїля! ");
INSERT INTO ukronpu_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Адже заради Тебе я несу ганьбу, і безчестя вкрило моє обличчя. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Вигнанцем став я для братів моїх і чужинцем для синів моєї матері; ");
INSERT INTO ukronpu_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","бо ревність до Дому Твого з’їдає мене, і образи тих, хто ганьбить Тебе, впали на мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Коли душа моя плакала постячись, то на ганьбу мені це обернулося. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Коли вдягав на себе лахміття, я став для них приказкою глузливою. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Пересуджують мене ті, хто сидить біля воріт, і наспівують про мене ті, що п’ють міцний напій. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","А я молюся до Тебе, Господи, у сприятливий час. Боже, за великою милістю Своєю дай мені відповідь, заради вірності обіцяному Тобою спасінню. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Визволи мене з багнюки – нехай я не загрузну, але врятуюся від ненависників моїх і від водних глибин! ");
INSERT INTO ukronpu_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Нехай не накриє мене бурхливий водний потік, і не поглине мене трясовина, і провалля не зімкне наді мною своєї пащі. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Дай мені відповідь, Господи, бо добра милість Твоя; повернися до мене з усією щедрістю милосердя Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Не ховай обличчя Свого від раба Твого, бо тісно мені. Поспіши відповісти мені! ");
INSERT INTO ukronpu_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Наблизься до душі моєї, визволи її; відкупи її заради ворогів моїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Ти знаєш, наскільки вкритий я ганьбою, соромом і безчестям – перед Тобою всі супротивники мої. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Ганьба розбила моє серце, і я розчавлений. Мав надію уникнути гніту, та не вдається, сподівався на втіху, та не знайшов її. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Але дали мені замість втішної їжі жовч; і під час спраги моєї напоїли мене оцтом. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Нехай трапеза їхня стане для них пасткою, а їхній добробут – тенетами. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Нехай потемніють їхні очі, щоб не бачили, а їхні стегна завжди тремтять. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Вилий на них Свій гнів, і лють обличчя Твого нехай впаде на них. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Нехай будуть спустошені поселення їхні; у шатрах їхніх нехай не буде мешканця. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Адже вони переслідують тих, кого Ти вразив, і про муки поранених Тобою розповідають. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Додай же і цей гріх до їхніх гріхів, і нехай не увійдуть вони до праведності Твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Нехай вони викреслені будуть із книги життя і не будуть записані разом із праведниками. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Я ж пригнічений і сповнений болю – нехай Твій порятунок, Боже, підніме мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Я прославлю ім’я Бога піснею і величатиму Його подякою. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Це буде приємніше Господеві, ніж віл, ніж молодий бичок із рогами й роздвоєними копитами. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Побачать пригнічені й зрадіють – ви, що Бога шукаєте, нехай серця ваші оживуть! ");
INSERT INTO ukronpu_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Бо прислухається до бідних Господь і в’язнів Своїх не цурається. ");
INSERT INTO ukronpu_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Нехай прославляють Його небеса і земля, моря і все, що роїться в них, ");
INSERT INTO ukronpu_vpl VALUES ("PS68_36","020_68_36","PSA","68","36","36","бо врятує Бог Сіон і збудує міста Юди. І поселяться там, і вспадкують їх, ");
INSERT INTO ukronpu_vpl VALUES ("PS68_37","020_68_37","PSA","68","37","37","нащадки рабів Його вспадкують їх, і ті, хто любить ім’я Його, мешкатимуть у них. ");
INSERT INTO ukronpu_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Керівнику хору. Псалом Давидів. На спомин. ");
INSERT INTO ukronpu_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Боже, визволи мене! Господи, поспіши мені на допомогу! ");
INSERT INTO ukronpu_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Нехай посоромляться й ганьбою вкриються ті, хто шукає душі моєї. Нехай відсахнуться назад і спіткнуться ті, хто бажає мені зла. ");
INSERT INTO ukronpu_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Нехай назад обернуться через свій сором ті, що говорять мені: «Ага! Ага!» ");
INSERT INTO ukronpu_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Нехай же веселяться й радіють Тобою всі, хто шукає Тебе. Нехай ті, хто любить спасіння Твоє, говорять безупинно: «Звеличився Бог!» ");
INSERT INTO ukronpu_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Я ж принижений та бідний. Боже, поспіши до мене! Допомога моя і Визволитель мій – Ти; Господи, не зволікай! ");
INSERT INTO ukronpu_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","У Тебе, Господи, я шукаю захисту, тож нехай не посоромлюся повіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","У Своїй праведності визволи мене і врятуй; схили до мене вухо Твоє і спаси мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Будь для мене скелею для оселі моєї, куди я завжди міг би прийти. Дай наказ врятувати мене, бо Ти моя скеля й твердиня моя. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Боже мій, визволи мене від руки нечестивого, від долоні беззаконного й кривдника. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Бо Ти – надія моя, Владико Господи, сподівання моє від часів юності моєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_6","020_70_6","PSA","70","6","6","На Тобі я утверджувався від самого народження; Ти витягнув мене з утроби матері моєї; Тобі – хвала моя безупинно! ");
INSERT INTO ukronpu_vpl VALUES ("PS70_7","020_70_7","PSA","70","7","7","Я став ніби знаком для багатьох, але Ти – тверде пристановище моє. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_8","020_70_8","PSA","70","8","8","Нехай вуста мої наповняться хвалою Тобі, цілий день оспівуючи красу Твою величну. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_9","020_70_9","PSA","70","9","9","Не залиши мене в час старості; не покинь мене, коли сила моя виснажиться. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_10","020_70_10","PSA","70","10","10","Бо подейкують про мене вороги мої, і ті, хто душу мою підстерігає, радяться разом між собою, ");
INSERT INTO ukronpu_vpl VALUES ("PS70_11","020_70_11","PSA","70","11","11","кажучи: «Бог покинув його. Переслідуйте й схопіть його, бо немає в нього рятівника!» ");
INSERT INTO ukronpu_vpl VALUES ("PS70_12","020_70_12","PSA","70","12","12","Боже, не віддаляйся від мене! Боже мій, поспіши мені на допомогу! ");
INSERT INTO ukronpu_vpl VALUES ("PS70_13","020_70_13","PSA","70","13","13","Нехай посоромлені будуть і загинуть супротивники душі моєї; нехай зодягнуться в ганьбу й безчестя ті, хто прагне вчинити мені зло. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_14","020_70_14","PSA","70","14","14","А я завжди сподіватимуся і все більше й більше хвалу Тобі примножувати буду. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_15","020_70_15","PSA","70","15","15","Вуста мої проголошуватимуть Твою праведність і спасіння Твоє цілий день, бо не знаю, як їх полічити! ");
INSERT INTO ukronpu_vpl VALUES ("PS70_16","020_70_16","PSA","70","16","16","Я увійду в роздуми про могутність Владики Господа, буду нагадувати всім про праведність Твою, що лише Тобі належить! ");
INSERT INTO ukronpu_vpl VALUES ("PS70_17","020_70_17","PSA","70","17","17","Боже, Ти вчив мене від часів юності моєї, і донині сповіщаю я чудеса Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_18","020_70_18","PSA","70","18","18","Тож і до старості й сивини, Боже, не покидай мене, аж поки не звіщу про силу правиці Твоєї поколінню цьому й усім прийдешнім – про могутність Твою. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_19","020_70_19","PSA","70","19","19","А праведність Твоя, Боже, до висот сягає; те, що вчинив Ти, – величне! Боже, хто подібний до Тебе? ");
INSERT INTO ukronpu_vpl VALUES ("PS70_20","020_70_20","PSA","70","20","20","Хоча Ти показав мені чимало тяжких скорбот, та знову Ти повертав мене до життя і з безодень землі знов виводив мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_21","020_70_21","PSA","70","21","21","Ти примножував велич мою й огортав мене втіхою Своєю. ");
INSERT INTO ukronpu_vpl VALUES ("PS70_22","020_70_22","PSA","70","22","22","Тож і я прославлю Тебе струнами ліри за вірність Твою, Боже мій; співатиму Тобі під звуки арфи, Святий Ізраїлів! ");
INSERT INTO ukronpu_vpl VALUES ("PS70_23","020_70_23","PSA","70","23","23","Радісно вигукують уста мої, коли я співаю для Тебе, і душа моя, яку Ти визволив, ");
INSERT INTO ukronpu_vpl VALUES ("PS70_24","020_70_24","PSA","70","24","24","також і язик мій цілий день промовлятиме правду Твою, бо посоромлені й ганьбою вкриті ті, хто прагнув вчинити мені зло. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Про Соломона. Боже, даруй Твоє правосуддя цареві і праведність Твою – синові царя. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Нехай судить він народ Твій справедливо й страдників Твоїх – чесно. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Нехай гори принесуть народові мир, а пагорби – праведність. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Нехай судить він пригнічених народу, врятує дітей бідняків і вразить гнобителя. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Будуть боятися Тебе, аж поки сонце і місяць існують, із роду в рід. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Нехай зійде він як дощ на покіс, як рясний дощ, що зрошує землю. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","У дні його нехай процвітає праведник і мир великий не припиняється, аж поки місяць не згасне. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Він пануватиме від моря й до моря і від ріки аж до країв землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Схилять перед ним коліна мешканці пустель, і вороги його лизатимуть пил. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Царі Таршишу й віддалених берегів платитимуть йому данину, царі Шеви і Севи піднесуть дари на знак покори. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","І вклоняться йому всі царі, усі народи служитимуть йому. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Бо врятує він бідного, коли той волатиме, і пригніченого, у якого немає помічника. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Він милість виявить убогому й бідняку і врятує душі злидарів. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Викупить душі їхні з-під влади насильства, адже кров їхня буде дорогоцінна в очах його. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Нехай він живе довго, і нехай дано йому буде золото Шеви. Нехай моляться за нього завжди, нехай цілий день благословляють його! ");
INSERT INTO ukronpu_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Нехай пшениці буде вдосталь на землі; на вершинах пагорбів нехай коливається колосся, немов на Лівані, і люд рясніє в містах, немов трава на землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Нехай ім’я його перебуває вічно, аж поки існує сонце. Через нього благословенними будуть усі народи; вони вважатимуть його тим, що щастя приносить. ");
INSERT INTO ukronpu_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Благословенний Господь, Бог Ізраїля, Який один лиш творить чудеса! ");
INSERT INTO ukronpu_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Благословенне ім’я слави Його повік, і вся земля наповниться Його славою! ");
INSERT INTO ukronpu_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Завершилися молитви Давида, сина Єссеєвого. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Псалом Асафів. Який же добрий Бог до Ізраїля, до чистих серцем! ");
INSERT INTO ukronpu_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","А в мене ледь не похитнулися мої ноги, мало не втратили опору мої стопи, ");
INSERT INTO ukronpu_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","коли я позаздрив нерозумним, побачивши добробут нечестивих! ");
INSERT INTO ukronpu_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Адже немає в них страждань до самої смерті й тіла їхні пашіють здоров’ям. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Вони вільні від тягарів людських, і труднощі людські не торкаються їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Тому пиха вкрила їм шию намистом, насильство вдягає їх неначе шати. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Вирячилися від жиру їхні очі – збулися в них розбещені задуми серця. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Глузують і говорять злісно, розмовляють зухвало про пригнічення. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","На небеса зазіхають вуста їхні, і язик їхній по землі походжає. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Тому туди ж народ Його звертається, п’ють собі жадібно воду повною мірою. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Вони говорять: «Як дізнається Бог? Хіба є знання у Всевишнього? ");
INSERT INTO ukronpu_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Ось вони нечестиві, але завжди безтурботні й примножують статки!» ");
INSERT INTO ukronpu_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Так чи не дарма я тримав у чистоті моє серце й обмивав у невинності мої руки? ");
INSERT INTO ukronpu_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Я був уражений картанням цілий день і докорами сумління – щоранку. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Якби сказав я сам собі: «Буду міркувати, як вони!», то цим я зрадив би рід синів Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","І роздумував я, щоб пізнати це, але воно було тяжким в очах моїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Аж поки не увійшов я до святилища Божого й не зрозумів, яким буде їхній кінець. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Так, Ти ставиш їх на стежках слизьких і потім штовхаєш їх до загибелі. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Як несподівано вони перетворилися на руїну, зникли, згинули від жаху! ");
INSERT INTO ukronpu_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Як сновидіння зникає після пробудження, так і Ти, Владико, повставши, їхні мрії обернеш на сором. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_21","020_72_21","PSA","72","21","21","Коли ж серце моє гарячилося й нутрощі мої терзалися, ");
INSERT INTO ukronpu_vpl VALUES ("PS72_22","020_72_22","PSA","72","22","22","тоді я був невігласом і нерозумним, мов худоба, перед Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_23","020_72_23","PSA","72","23","23","Та я завжди з Тобою: Ти тримаєш мою правицю у Своїй руці. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_24","020_72_24","PSA","72","24","24","Ти ведеш мене Своєю порадою, а потім приймеш мене у славу. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_25","020_72_25","PSA","72","25","25","Хто є в мене на небі, крім Тебе? Коли Ти зі мною, нічого на землі не хочу! ");
INSERT INTO ukronpu_vpl VALUES ("PS72_26","020_72_26","PSA","72","26","26","Виснажилося моє тіло й моє серце, та скеля серця мого й доля моя навіки – Бог! ");
INSERT INTO ukronpu_vpl VALUES ("PS72_27","020_72_27","PSA","72","27","27","Ось ті, хто далекий від Тебе, загинуть; Ти знищиш усіх, хто блукає вдалині від Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS72_28","020_72_28","PSA","72","28","28","А щодо мене, то добре мені наближатися до Бога; у Володаря Господа мій притулок, щоб я міг звіщати Його діяння. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Повчання Асафа. Боже, чому Ти покинув нас навіки? Чому гнів Твій палає на овець Твого пасовища? ");
INSERT INTO ukronpu_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Згадай громаду Свою, яку придбав Ти віддавна, викупив як плем’я Свого спадку, гору Сіон, на якій Ти оселився. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Спрямуй кроки Твої до вікових руїн – усе зруйнував ворог у святилищі! ");
INSERT INTO ukronpu_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Супротивники Твої ревли посеред місць зборів Твого народу, поставили знамена свої як знаки свого панування. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Поводилися ніби лісоруб, що замахнувся сокирою на гущавину лісу. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Та й тепер стесують разом різьблення Храму сокирами й топірцями. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Вогню віддали святилище Твоє, збезчестили, із землею зрівняли помешкання імені Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Промовили в серцях своїх: «Знищимо їх дотла!» Вони спалили усі місця зборів Божих на землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Ми не бачимо ознак Божих, немає більше пророка, і немає з нами того, хто знав би, доки так буде. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Доки, Боже, глумитиметься супротивник? Невже вічно глузуватиме ворог з імені Твого? ");
INSERT INTO ukronpu_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Чому Ти стримуєш руку Свою, правицю Свою? Витягни її із пахви, вразь їх! ");
INSERT INTO ukronpu_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Боже, Царю мій споконвічний, що здійснюєш спасіння посеред землі! ");
INSERT INTO ukronpu_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Ти розділив море міццю Своєю, розтрощив голови морським чудовиськам. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Ти розбив голову Левіятана, віддав його на поживу народові пустелі. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Ти висікав джерело і потік, Ти висушував ріки, завжди повноводні. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Тобі належить і день, і ніч; Ти встановив світило небесне й сонце; ");
INSERT INTO ukronpu_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Ти визначив усі межі землі, Ти створив літо й зиму. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Згадай, як ганьбив ворог Тебе, Господи, і народ безумний зневажав Твоє ім’я. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Не віддавай звірам душі голубки Своєї, про життя страдників Твоїх не забувай навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Поглянь на Завіт Свій, бо наповнилися темні кутки землі осередками насильства. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Нехай пригнічений не повертається посоромленим, пригноблений і бідний нехай прославлять ім’я Твоє. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Повстань, Боже, втруться в судову суперечку Свою; згадай, як ганьбить Тебе нерозумний цілий день. ");
INSERT INTO ukronpu_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Не забувай крику супротивників Своїх, лементу, що його здіймають безупинно бунтівники проти Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Керівнику хору. На мотив «Не згуби». Псалом Асафа. Пісня. ");
INSERT INTO ukronpu_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Славимо Тебе, Боже, славимо, бо близьке ім’я Твоє; люди проголошують чудеса Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Бо Ти сказав: «Я оберу певний час і справедливо судитиму. ");
INSERT INTO ukronpu_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Тане земля й мешканці її – Я утверджу її стовпи». Села ");
INSERT INTO ukronpu_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Сказав Я зухвалим: «Не бундючтеся!» – і нечестивим: «Не підносьте рога!» ");
INSERT INTO ukronpu_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Не підносьте високо роги ваші, не говоріть зухвало, твердо поставивши шию. ");
INSERT INTO ukronpu_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Бо не зі сходу, не із заходу й не з пустелі приходить піднесення. ");
INSERT INTO ukronpu_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Адже Бог – Суддя: одного принижує, іншого підносить. ");
INSERT INTO ukronpu_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Бо чаша в руці Господа – пінисте вино, повна суміші вона, і Він виливає з неї; навіть гущу її висмокчуть і вип’ють усі нечестивці землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","А я звіщатиму це повіки, співатиму Богові Якова: ");
INSERT INTO ukronpu_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","«Усі роги нечестивих повідрубую, а роги праведних піднесуться». ");
INSERT INTO ukronpu_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Керівнику хору. На струнних інструментах. Псалом Асафа. Пісня. ");
INSERT INTO ukronpu_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Відомий в Юдеї Бог, в Ізраїлі величне ім’я Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Був у Салемі намет Його, і помешкання Його – на Сіоні. ");
INSERT INTO ukronpu_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Там зламав Він полум’яні стріли лука, щит і меч, і війну припинив. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Ти осяяний величчю більше, ніж ті гори, що здобичі повні. ");
INSERT INTO ukronpu_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Міцні серцем стали здобиччю, заснули сном своїм останнім; Сильні мужі не можуть поворухнути своїми руками. ");
INSERT INTO ukronpu_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Від грізних докорів Твоїх, Боже Якова, застигли колісниця і кінь. ");
INSERT INTO ukronpu_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Ти – грізний, хто встоїть перед обличчям Твоїм у час гніву Твого? ");
INSERT INTO ukronpu_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","З небес Ти проголосив суд – земля злякалась і затихла, ");
INSERT INTO ukronpu_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","коли повстав Бог, щоб судити, щоб врятувати всіх пригнічених землі. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS75_11","020_75_11","PSA","75","11","11","Адже навіть гнів людський обернеться на славу Тобі, а рештою гніву Ти переможно оперезаєш Себе. ");
INSERT INTO ukronpu_vpl VALUES ("PS75_12","020_75_12","PSA","75","12","12","Давайте обітниці Господеві, Богові вашому, і виконуйте їх; усі, хто навколо Нього, нехай принесуть дар Грізному. ");
INSERT INTO ukronpu_vpl VALUES ("PS75_13","020_75_13","PSA","75","13","13","Він приборкує дух вождів, страшний Він для царів землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Керівнику хору, Єдутуну. Псалом Асафів. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Голосом своїм я волатиму до Бога, голосом моїм – до Бога, і Він прислухається до мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","У день скорботи моєї я шукав Володаря; цілу ніч моя рука була простягнута й не затерпла. Моя душа відмовлялася від втіхи. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Згадаю про Бога – і охопить мене трепет; пороздумую – і знемагає дух мій. Села. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Ти тримав розплющеними повіки очей моїх; я вражений і не можу говорити. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Подумав я про дні давноминулі, про роки давні. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Згадую наспіви мої вночі, із серцем своїм веду розмову, і дух мій дошукується: ");
INSERT INTO ukronpu_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Невже навіки покинув нас Володар і більше не буде прихильним? ");
INSERT INTO ukronpu_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Невже назавжди зникла Його милість, припинилося Його слово на всі наступні покоління? ");
INSERT INTO ukronpu_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Хіба забув Бог, як милувати, чи замкнув у гніві милосердя Своє? Села ");
INSERT INTO ukronpu_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Тоді сказав я: «Що гнітить мене, так це те, що Всевишній змінив дію правиці Своєї щодо нас». ");
INSERT INTO ukronpu_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Згадаю я про діяння Господа; нагадаю-но собі про чудеса стародавні. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_13","020_76_13","PSA","76","13","13","Споглядатиму всі справи Твої і про звершення Твої роздумувати буду. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_14","020_76_14","PSA","76","14","14","Боже, у святості шлях Твій! Який бог настільки великий, як наш Бог? ");
INSERT INTO ukronpu_vpl VALUES ("PS76_15","020_76_15","PSA","76","15","15","Ти – Бог, Який творить чудеса; Ти з’явив могутність Свою серед народів. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_16","020_76_16","PSA","76","16","16","Ти визволив рукою Своєю народ Твій, синів Якова і Йосифа. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS76_17","020_76_17","PSA","76","17","17","Побачили Тебе води, Боже, побачили Тебе води й затремтіли, здригнулися безодні. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_18","020_76_18","PSA","76","18","18","Потоками лилася вода із темних хмар, свій голос подали хмарини, і стріли Твої розліталися. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_19","020_76_19","PSA","76","19","19","Гуркіт Твого грому на небокраї, спалахи блискавок освітлювали всесвіт, земля тремтіла й здригалася. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_20","020_76_20","PSA","76","20","20","Шлях Твій пролягав через море, і стежки Твої – через води великі, та слідів Твоїх не було видно. ");
INSERT INTO ukronpu_vpl VALUES ("PS76_21","020_76_21","PSA","76","21","21","Ти вів, немов отару, народ Свій рукою Мойсея і Аарона. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Повчання Асафові. Послухай-но, народе мій, настанову мою, схиліть вуха свої до слів моїх вуст! ");
INSERT INTO ukronpu_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Відкрию в притчі вуста мої, промовлю загадки прадавніх часів, ");
INSERT INTO ukronpu_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","які ми чули й пізнали і які розповідали нам предки наші. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Не будемо приховувати їх від синів наших, розкажемо наступному поколінню про хвалу Господа й могутність Його, про чудеса, які Він здійснив. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Він засвідчив одкровення Своє Якову й встановив в Ізраїлі Закон Свій, який заповідав предкам нашим, щоб вони навчили нащадків своїх, ");
INSERT INTO ukronpu_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","щоб знало наступне покоління, щоб діти, що народитися мають, сповістили свого часу й своїм нащадкам. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Тоді вони сподівання своє покладуть на Бога, і не забуватимуть діянь Божих, і будуть дотримуватися Його заповідей. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Вони не будуть подібні до своїх предків, покоління впертого й бунтівного, роду, чиє серце непевне і чий дух невірний Богові. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Сини Єфремові, хоча й озброєні стрільці з лука, назад повернулися у день битви. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Не дотримувалися вони Завіту Божого й відмовилися ходити в Законі Божому. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Вони забули про Його звершення й чудеса, що Він їм показав. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Перед предками їхніми здійснив Він чудо в землі Єгипту, в околицях Цоану. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Він розділив навпіл море й провів їх через нього, і поставив води грудами. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Вів їх хмарою вдень, і цілу ніч – світлом вогню. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Він розсікав скелі в пустелі й напував їх, немов із великої безодні. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Із скелі вивів потоки, і потекли рікою води. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Але вони продовжували грішити проти Нього, бунтувати проти Всевишнього на висохлій землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Випробовували Бога в серцях своїх, вимагаючи їжу за своїми примхами. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Вони говорили зухвало проти Бога, кажучи: «Чи не міг би Бог накрити стіл у пустелі? ");
INSERT INTO ukronpu_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Ось Він вдарив скелю, і потекли води, хлинули потоки. Хіба ж не може Він дати хліба чи приготувати м’яса народові Своєму?» ");
INSERT INTO ukronpu_vpl VALUES ("PS77_21","020_77_21","PSA","77","21","21","Тому, коли почув це Господь, то розгнівався: вогонь загорівся проти Якова, і гнів Його спалахнув на Ізраїля, ");
INSERT INTO ukronpu_vpl VALUES ("PS77_22","020_77_22","PSA","77","22","22","бо не повірили вони Богові й не покладали надії на Його спасіння. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_23","020_77_23","PSA","77","23","23","Тож наказав Він хмарам вгорі, і відчинив ворота небес, ");
INSERT INTO ukronpu_vpl VALUES ("PS77_24","020_77_24","PSA","77","24","24","і дощем пролив на них манну, щоб їли, і дав їм зерно небесне. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_25","020_77_25","PSA","77","25","25","Хліб могутніх їла людина, Він послав їм їжі вдосталь. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_26","020_77_26","PSA","77","26","26","Він здійняв східний вітер у небесах і навів Своєю могутністю вітер південний. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_27","020_77_27","PSA","77","27","27","Дощем пролив Він на них м’ясо, немов пил, і, неначе пісок морський, – птахів крилатих, ");
INSERT INTO ukronpu_vpl VALUES ("PS77_28","020_77_28","PSA","77","28","28","яких розкидав Він серед табору, навколо помешкань їхніх. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_29","020_77_29","PSA","77","29","29","Вони їли й добре наситилися – Він задовольнив бажання їхнє. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_30","020_77_30","PSA","77","30","30","Та ще не встигли вони вгамувати своєї примхи, ще їжа була в них на вустах, ");
INSERT INTO ukronpu_vpl VALUES ("PS77_31","020_77_31","PSA","77","31","31","як гнів Божий піднявся проти них, і вигубив найбільш пишних із них, і повалив додолу юнаків Ізраїля. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_32","020_77_32","PSA","77","32","32","Та попри все це вони далі грішили й не вірили чудесам Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_33","020_77_33","PSA","77","33","33","Тому Він загубив дні їхні в марноті й роки їхні – у смутку. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_34","020_77_34","PSA","77","34","34","Коли Він вбивав їх, тоді вони шукали Його, і наверталися, і прагнули Бога. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_35","020_77_35","PSA","77","35","35","І згадували, що Бог – їхня скеля і що Бог Всевишній – їхній Визволитель. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_36","020_77_36","PSA","77","36","36","Тоді промовляли Йому лестощі устами своїми і язиками своїми неправду перед Ним говорили; ");
INSERT INTO ukronpu_vpl VALUES ("PS77_37","020_77_37","PSA","77","37","37","та серцями своїми не були вони з Ним щирі й не берегли вірності Його Завітові. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_38","020_77_38","PSA","77","38","38","Та Він, милостивий, прощав гріх і не знищував їх. Багато разів відвертав гнів Свій і не будив усієї Своєї люті. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_39","020_77_39","PSA","77","39","39","Він пам’ятав, що вони – тіло, вітер, що йде й не повертається. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_40","020_77_40","PSA","77","40","40","Скільки разів вони бунтували проти Нього в пустелі, засмучували Його в дикій землі! ");
INSERT INTO ukronpu_vpl VALUES ("PS77_41","020_77_41","PSA","77","41","41","Знову й знову випробовували Бога й засмучували Святого Ізраїлевого. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_42","020_77_42","PSA","77","42","42","Не пам’ятали ні діянь руки Його, ні того дня, коли Він визволив їх від ворога, ");
INSERT INTO ukronpu_vpl VALUES ("PS77_43","020_77_43","PSA","77","43","43","коли ознаки Свої показав у Єгипті й чудеса Свої в околицях Цоану. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_44","020_77_44","PSA","77","44","44","Він перетворив їхні ріки на кров, і з потоків своїх вони пити не могли. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_45","020_77_45","PSA","77","45","45","Він послав на них рої комах, які пожирали їх, і жаб, що губили їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_46","020_77_46","PSA","77","46","46","Він віддав врожай їхній гусені й збіжжя їхнє – сарані. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_47","020_77_47","PSA","77","47","47","Побив виноградники їхні градом і шовковиці – кригою. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_48","020_77_48","PSA","77","48","48","Він віддав на поталу градові їхню худобу й отари їхні – блискавкам. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_49","020_77_49","PSA","77","49","49","Він послав на них полум’я Свого гніву, лють, обурення й біду – посольство злих ангелів. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_50","020_77_50","PSA","77","50","50","Вирівняв стежку для гніву Свого; не утримав їхніх душ від смерті, але віддав життя їхнє на поталу моровиці. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_51","020_77_51","PSA","77","51","51","І вразив усіх первістків у Єгипті – перші плоди сили чоловічої в шатрах Хамових. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_52","020_77_52","PSA","77","52","52","Немов овець отару, Він вивів народ Свій, і, неначе стадо, провадив їх у пустелі. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_53","020_77_53","PSA","77","53","53","Вів їх у безпеці, так що вони не боялися, а ворогів їхніх вкрило море. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_54","020_77_54","PSA","77","54","54","І привів їх до границь святині Своєї, до тієї гори, яку здобула Його правиця. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_55","020_77_55","PSA","77","55","55","Прогнав перед ними народи, і простягнув мотузку землемірну, щоб спадок їхній переділити, і в наметах їхніх поселив племена Ізраїлеві. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_56","020_77_56","PSA","77","56","56","Але вони випробовували Бога Всевишнього, бунтували проти Нього й не дотримувалися Його одкровень. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_57","020_77_57","PSA","77","57","57","І відступали, і зраджували, як і батьки їхні; викручувалися, як висковзує з рук кривий лук. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_58","020_77_58","PSA","77","58","58","Гнівили Його в капищах на своїх пагорбах та ідолами своїми будили Його ревнощі. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_59","020_77_59","PSA","77","59","59","Почув Бог, і запалав гнівом, і геть відцурався Ізраїля. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_60","020_77_60","PSA","77","60","60","Покинув Оселю Свою в Шило – шатро, в якому Він мешкав серед людей. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_61","020_77_61","PSA","77","61","61","І віддав Він могутність Свою у полон і красу Свою – у руки ворога. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_62","020_77_62","PSA","77","62","62","Віддав Він народ Свій мечу на поталу й гнівом запалав на спадщину Свою. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_63","020_77_63","PSA","77","63","63","Юнаків їхніх пожер вогонь, а їхнім дівчатам весільних пісень не співали. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_64","020_77_64","PSA","77","64","64","Священники його попадали від меча, а вдови його не плакали. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_65","020_77_65","PSA","77","65","65","Тоді прокинувся Володар, немов від сну, неначе воїн, що витверезився від вина. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_66","020_77_66","PSA","77","66","66","І вразив ворогів його ззаду, вкрив їх вічною ганьбою. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_67","020_77_67","PSA","77","67","67","Тоді відцурався Він шатра Йосифового й не обрав племені Єфремового. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_68","020_77_68","PSA","77","68","68","Але вибрав Він плем’я Юди, гору Сіон, яку полюбив. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_69","020_77_69","PSA","77","69","69","Він збудував, немов висоти небес, святилище Своє, і, як землю, заклав основи його навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_70","020_77_70","PSA","77","70","70","І обрав Свого слугу Давида, узявши його від кошар овечих, ");
INSERT INTO ukronpu_vpl VALUES ("PS77_71","020_77_71","PSA","77","71","71","привів його від овечок дійних, щоб пасти Якова, народ Свій, Ізраїля, Свій спадок. ");
INSERT INTO ukronpu_vpl VALUES ("PS77_72","020_77_72","PSA","77","72","72","І він пас їх у невинності свого серця і вів їх розумно руками своїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Псалом Асафів. Боже, чужі народи увійшли у Твій спадок, спаплюжили Храм святині Твоєї, перетворили Єрусалим на руїни. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Віддали трупи рабів Твоїх на поживу птахам небесним, тіла вірних Твоїх – звірам земним. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Вони пролили кров їхню, як воду, навколо Єрусалима, немає кому поховати їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Ми стали ганьбою у сусідів наших, глузуванням і наругою у тих, хто нас оточує. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Доки, Господи, гнів Твій триватиме – вічно? Доки палатиме ревність Твоя, немов вогонь? ");
INSERT INTO ukronpu_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Вилий лють Свою на народи, які Тебе не знають, і на царства, що імені Твого не кличуть, ");
INSERT INTO ukronpu_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","бо пожерли вони Якова й спустошили його обійстя. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Не згадуй нам гріхів наших попередників; нехай милосердя Твоє поспішить нам назустріч, бо ми геть знесилені. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Допоможи нам, Боже спасіння нашого, заради слави імені Твого. Визволи нас і прости нам гріхи наші заради імені Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Чому мали б народи говорити: «Де Бог їхній?» Нехай же відомою стане серед народів помста за пролиту кров рабів Твоїх і нехай очі наші побачать це. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Нехай стогін в’язня дійде до обличчя Твого; могутністю руки Твоєї збережи життя приреченим на смерть. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Віддяч усемеро в саме нутро сусідам нашим за наругу їхню, якою вони ганьбили Тебе, Владико. ");
INSERT INTO ukronpu_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","А ми, народ Твій, вівці Твого пасовища, будемо прославляти Тебе вічно, з роду в рід сповіщати будемо хвалу Твою. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Керівнику хору. На мотив «Лілея». Свідчення. Псалом Асафів. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Почуй нас, о Пастирю Ізраїля! Ти, Що ведеш Йосифа, немов отару овець, Котрий сидиш на престолі між херувимами, з’яви Себе ");
INSERT INTO ukronpu_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","перед Єфремом, Веніаміном і Манассією! Пробуди могутність Свою й прийди, щоб врятувати нас! ");
INSERT INTO ukronpu_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Боже, віднови нас, засяй обличчям Твоїм, і ми будемо врятовані! ");
INSERT INTO ukronpu_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Господи, Боже Воїнств, доки таїтимеш гнів на молитви народу Свого? ");
INSERT INTO ukronpu_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Ти нагодував нас хлібом скорботним, напоїв нас сльозами сповна, ");
INSERT INTO ukronpu_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","зробив нас причиною суперечки між сусідами нашими, і глузують з нас вороги наші. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Боже Воїнств, віднови нас, засяй обличчям Твоїм, і ми будемо врятовані! ");
INSERT INTO ukronpu_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Ти приніс з Єгипту виноградну галузку, прогнав народи, а її насадив. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Ти очистив місце для неї – вона пустила своє коріння й наповнила землю. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Гори вкрилися її тінню, і кедри могутні – її гілками. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Розкинула свої пагони аж до моря і аж до ріки Євфрат – своє молоде галуззя. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Навіщо ж зруйнував Ти її огорожу, так що плоди її зривають усі перехожі? ");
INSERT INTO ukronpu_vpl VALUES ("PS79_14","020_79_14","PSA","79","14","14","Підриває її вепр лісовий, і все, що рухається на полях, об’їдає її. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_15","020_79_15","PSA","79","15","15","Боже Воїнств, повернися до нас, поглянь із небес, на нас подивися! Збережи цю виноградну лозу, ");
INSERT INTO ukronpu_vpl VALUES ("PS79_16","020_79_16","PSA","79","16","16","це коріння, яке насадила Твоя правиця, галуззя, яке Ти зміцнив для Себе. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_17","020_79_17","PSA","79","17","17","Вогнем обпалена, обсічена лоза, від докорів Твоїх гине люд Твій. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_18","020_79_18","PSA","79","18","18","Нехай рука Твоя буде над мужем правиці Твоєї, над сином людським, якого Ти зміцнив для Себе. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_19","020_79_19","PSA","79","19","19","Тоді ми не відступимо від Тебе; оживи нас, і будемо кликати ім’я Твоє. ");
INSERT INTO ukronpu_vpl VALUES ("PS79_20","020_79_20","PSA","79","20","20","Господи, Боже Воїнств, віднови нас! Нехай засяє над нами обличчя Твоє, і ми будемо врятовані! ");
INSERT INTO ukronpu_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Керівнику хору. У стилі ґіттіт. Псалом Асафів. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Радісно співайте Богові, твердині нашій, вигукніть переможно Богові Якова! ");
INSERT INTO ukronpu_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Заспівайте пісню, вдарте у бубон, заграйте на арфі милозвучній і лірі. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Сурміть у ріг на свято нового місяця і в повний місяць, у день святкування нашого. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Бо це постанова для Ізраїля, правило від Бога Якова. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Він встановив це як одкровення для Йосифа, коли Він проходив по землі Єгипетській. Я чув мову, якої не знав: ");
INSERT INTO ukronpu_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","«Я зняв ярмо з його плеч, його руки звільнилися від коша. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","У скорботі ти покликав Мене, і Я визволив тебе; відповідав тобі з-під покрову грозової хмари; випробовував тебе при водах Мериви. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Слухай, народе Мій, Я буду свідчити тобі. О Ізраїлю, якби ти послухався Мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Нехай не буде в тебе чужого бога, і не вклоняйся богові чужоземному. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Я – Господь, Бог твій, Який вивів тебе із землі Єгипетської. Розкрий свої вуста, і Я наповню їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Але народ Мій не слухався Мого голосу, Ізраїль не вподобав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Тому полишив Я їх владі впертості власних сердець – нехай ходять за своїми задумами. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","О, якби народ Мій слухався Мене, Ізраїль ходив би Моїми дорогами! ");
INSERT INTO ukronpu_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Ще трохи, і Я підкорив би ворогів їхніх і на супротивників їхніх простягнув би руку Мою. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Ті, хто Господа ненавидить, плазували б перед Ним, і час їхньої кари тривав би вічно. ");
INSERT INTO ukronpu_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Я годував би Ізраїля найкращою пшеницею й насичував би тебе медом зі скелі». ");
INSERT INTO ukronpu_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Псалом Асафів. Бог стоїть у божественному зібранні, судить серед богів: ");
INSERT INTO ukronpu_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","«Доки ви будете судити беззаконно й догоджати нечестивим? Села ");
INSERT INTO ukronpu_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Судіть чесно бідняка й сироту, виправдайте приниженого й злидаря. ");
INSERT INTO ukronpu_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Визволяйте вбогого й бідного, рятуйте їх від руки нечестивих. ");
INSERT INTO ukronpu_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Не знають, не розуміють судді, вони ходять у темряві. Здригаються всі основи землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Я сказав: „Ви – боги, усі ви – сини Всевишнього“, ");
INSERT INTO ukronpu_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","але ви помрете, як люди, попадаєте, як будь-хто інший із князів». ");
INSERT INTO ukronpu_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Повстань, Боже, суди землю, адже Ти приймеш у спадок усі народи! ");
INSERT INTO ukronpu_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Пісня. Псалом Асафів. ");
INSERT INTO ukronpu_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Боже, не залишайся в тиші, не мовчи й не заспокоюйся, о Боже! ");
INSERT INTO ukronpu_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Адже вороги Твої гомонять і ненависники Твої підняли голови. ");
INSERT INTO ukronpu_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Складають змову проти Твого народу й радяться проти тих, кого Ти бережеш. ");
INSERT INTO ukronpu_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Сказали вони: «Ходімо, знищимо їх з-поміж народів, і не згадається більше ім’я Ізраїля». ");
INSERT INTO ukronpu_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Змовилися одностайно, уклали проти Тебе угоду – ");
INSERT INTO ukronpu_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","шатри Едомові й ізмаїльтяни, Моав і аґаряни, ");
INSERT INTO ukronpu_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Ґевал, Аммон і Амалик, Филистея із жителями Тира. ");
INSERT INTO ukronpu_vpl VALUES ("PS82_9","020_82_9","PSA","82","9","9","Навіть Ассирія приєдналася до них, ставши сильним плечем для синів Лотових. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS82_10","020_82_10","PSA","82","10","10","Зроби з ними так, як із Мідіаном, як із Сісерою й Явіном при потоці Кішон, ");
INSERT INTO ukronpu_vpl VALUES ("PS82_11","020_82_11","PSA","82","11","11","що були знищені в Ен-Дорі й стали гноєм землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS82_12","020_82_12","PSA","82","12","12","Учини з вельможами їхніми, як з Оревом і Зевом, і з князями їхніми, як із Зевахом і Цальманом, ");
INSERT INTO ukronpu_vpl VALUES ("PS82_13","020_82_13","PSA","82","13","13","що говорили: «Візьмемо собі у спадок угіддя Божі». ");
INSERT INTO ukronpu_vpl VALUES ("PS82_14","020_82_14","PSA","82","14","14","Боже мій, нехай будуть вони, як курява, як полова на вітрі. ");
INSERT INTO ukronpu_vpl VALUES ("PS82_15","020_82_15","PSA","82","15","15","Як вогонь пожирає ліс і як полум’я обпікає гори, ");
INSERT INTO ukronpu_vpl VALUES ("PS82_16","020_82_16","PSA","82","16","16","так Ти пожени їх Своєю бурею й вихором Своїм збентеж їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS82_17","020_82_17","PSA","82","17","17","Вкрий їхні обличчя безчестям, і нехай шукають вони ім’я Твоє, Господи! ");
INSERT INTO ukronpu_vpl VALUES ("PS82_18","020_82_18","PSA","82","18","18","Нехай вони посоромляться й збентежаться навіки, нехай вкриються ганьбою й загинуть. ");
INSERT INTO ukronpu_vpl VALUES ("PS82_19","020_82_19","PSA","82","19","19","Нехай пізнають, що Ти, Чиє ім’я – Господь, лише Ти один Всевишній над усією землею. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Керівнику хору. На мотив ґіттіт. Псалом синів Кореєвих. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Які любі оселі Твої, Господи Воїнств! ");
INSERT INTO ukronpu_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Душа моя охоплена прагненням і тужить за дворам Господа, серце моє і тіло волають до Бога живого. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Навіть пташка знаходить собі домівку й ластівка – гніздо собі, щоби покласти пташенят своїх біля жертовників Твоїх, Господи Воїнств, Царю мій і Боже мій. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Блаженні ті, що живуть у домі Твоєму – вони безупинно прославлятимуть Тебе. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Блаженна людина, чия міць у Тобі, у чиєму серці стежки спрямовані до храму. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Проходячи долиною плачу, вони джерела води в ній відкривають, і ранній дощ вкриває її благословеннями. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Зростають їхні сили, з’являються вони перед Богом на Сіоні. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Господи, Боже Воїнств, почуй мою молитву, прислухайся, Боже Яковів! Села ");
INSERT INTO ukronpu_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Щите наш, Боже, подивися, поглянь на обличчя Твого помазанця. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Адже один день у Твоїх дворах кращий від тисячі днів деінде. Я вибрав би перебувати біля порогу дому Бога мого, аніж мешкати в наметах нечестивців. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Бо сонце і щит – Господь Бог! Він нагороджує милістю й славою Своєю; не позбавить Він добра тих, хто ходить у невинності. ");
INSERT INTO ukronpu_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Господи Воїнств! Блаженна людина, що на Тебе покладає надію! ");
INSERT INTO ukronpu_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Керівнику хору. Псалом синів Кореєвих. ");
INSERT INTO ukronpu_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Ти вподобав землю Свою, Господи, повернув із полону Якова. ");
INSERT INTO ukronpu_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Ти простив беззаконня народу Твого, покрив усі гріхи його. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Ти забрав від нас увесь Свій гнів, відвернув усю лють обличчя Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Віднови нас, Боже спасіння нашого, і припини Свій гнів на нас. ");
INSERT INTO ukronpu_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Невже Ти гніватимешся на нас вічно, продовжуватимеш гнів Свій із роду в рід? ");
INSERT INTO ukronpu_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Невже не оживиш нас знову, щоб народ Твій радів Тобою? ");
INSERT INTO ukronpu_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","З’яви нам, Господи, милість Свою і даруй нам Твоє спасіння. ");
INSERT INTO ukronpu_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Послухаю-но, що скаже Бог, Господь, адже Він скаже: «Мир!» народові Своєму й вірним Своїм. Лише б вони знову не повернулися до безглуздя! ");
INSERT INTO ukronpu_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Справді, близьке спасіння Його до тих, хто Його боїться, щоб слава Його замешкала в землі нашій. ");
INSERT INTO ukronpu_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Милість та істина зустрінуться, правда і мир поцілуються. ");
INSERT INTO ukronpu_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Істина проросте із землі, і правда з небес поглядатиме, ");
INSERT INTO ukronpu_vpl VALUES ("PS84_13","020_84_13","PSA","84","13","13","і дасть Господь добро, і земля наша принесе врожай. ");
INSERT INTO ukronpu_vpl VALUES ("PS84_14","020_84_14","PSA","84","14","14","Правда піде перед Ним, поставить на дорогу свої кроки. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Молитва Давидова. Прихили, Господи, вухо Своє, дай мені відповідь, бо я пригнічений і бідний. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Збережи душу мою, адже я вірний Тобі. Врятуй раба Твого, який довіряє Тобі, Ти – Бог мій; ");
INSERT INTO ukronpu_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","помилуй мене, Владико, бо до Тебе я кличу цілий день. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Даруй радість душі раба Свого, бо до Тебе, Владико, підношу душу мою. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Адже Ти, Владико, добрий і прощаєш, щедрий на милість для всіх, хто кличе до Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Зваж, Господи, на мою молитву, прислухайся до голосу мого благання. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","У день скорботи своєї я кличу до Тебе, адже Ти мені відповідаєш. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Немає подібного до Тебе серед богів, Владико, немає діянь таких, як Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Усі народи, створені Тобою, прийдуть і поклоняться перед Тобою, Володарю, і прославлять ім’я Твоє. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Бо Ти великий і твориш чудеса; Ти – Бог, тільки Ти! ");
INSERT INTO ukronpu_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Покажи мені, Господи, дорогу Твою, і я ходитиму в істині Твоїй. Зроби моє серце цілісним, щоб я боявся імені Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Прославлю Тебе, Владико, Боже мій, усім своїм серцем; прославлятиму ім’я Твоє вічно. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Бо велика милість Твоя до мене; Ти визволив душу мою від глибин царства смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_14","020_85_14","PSA","85","14","14","Боже, зухвальці повстали на мене, зборище гнобителів шукає душі моєї, не уявляють вони Тебе перед собою. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_15","020_85_15","PSA","85","15","15","Але Ти, Володарю, Бог милостивий і милосердний, довготерпеливий і багатий на милість та істину. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_16","020_85_16","PSA","85","16","16","Обернися до мене й помилуй мене; дай Свою міць рабу Твоєму й врятуй сина раби Твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS85_17","020_85_17","PSA","85","17","17","Дай мені знак, що Ти добрий до мене; тоді побачать це ті, хто ненавидить мене, і посоромляться, бо Ти, Господи, допоміг мені й втішив мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Псалом синів Кореєвих. Пісня. ");
INSERT INTO ukronpu_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Основи його – на горах святих. Господь любить ворота Сіону більше від усіх осель Якова. ");
INSERT INTO ukronpu_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Славне говорять про тебе, місто Боже! Села ");
INSERT INTO ukronpu_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Я нагадаю тим, хто знає мене, про Раав і Вавилон, ось Филистея і Тир із Кушем казатимуть: «Цей народився там». ");
INSERT INTO ukronpu_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","І про Сіон скажуть: «Такий-то й такий-то народився в ньому, і Сам Всевишній утвердить це місто». ");
INSERT INTO ukronpu_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Господь запише при переписі народів: «Цей народився там». Села ");
INSERT INTO ukronpu_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Співаючи й пританцьовуючи, скажуть: «Усі мої джерела в тобі, Сіоне!» ");
INSERT INTO ukronpu_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Пісня. Псалом синів Кореєвих. Керівнику хору. На мотив махалат лаанот. Повчання Гемана-езрахітянина. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Господи, Боже мого спасіння, вдень я волаю до Тебе, вночі – я перед Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Нехай молитва моя дійде до Твого обличчя, схили Твоє вухо до крику мого. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Бо душа моя наситилася стражданнями й життя моє наблизилося до царства смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Мене зараховано до тих, хто спускається до прірви; я став як муж, що не має сили. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Я покинутий між мертвими, немов ті убиті, що лежать у могилі, про яких Ти більше не згадуєш і які відкинуті від руки Твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Ти поклав мене в глибоку прірву, у темні закутки безодні. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_8","020_87_8","PSA","87","8","8","Твій гнів тяжіє наді мною, і усіма могутніми хвилями Твоїми Ти пригнітив мене. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS87_9","020_87_9","PSA","87","9","9","Ти віддалив від мене моїх знайомих, зробив мене огидою для них. Мене замкнуто, і я не можу вийти; ");
INSERT INTO ukronpu_vpl VALUES ("PS87_10","020_87_10","PSA","87","10","10","очі мої виснажилися від гніту. Я кликав до Тебе, Господи, щодня, простягав до Тебе свої долоні. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_11","020_87_11","PSA","87","11","11","Хіба Ти твориш чудеса для померлих? Чи духи померлих встануть, щоб славити Тебе? ");
INSERT INTO ukronpu_vpl VALUES ("PS87_12","020_87_12","PSA","87","12","12","Чи буде звіщатися в могилі милість Твоя і вірність Твоя – в безодні Погибелі? ");
INSERT INTO ukronpu_vpl VALUES ("PS87_13","020_87_13","PSA","87","13","13","Хіба серед мороку звіщають чудеса Твої і праведність Твою – у землі забуття? ");
INSERT INTO ukronpu_vpl VALUES ("PS87_14","020_87_14","PSA","87","14","14","Я ж, Господи, волаю до Тебе, із самого ранку моя молитва йде Тобі назустріч. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_15","020_87_15","PSA","87","15","15","Чому, Господи, Ти цураєшся душі моєї, ховаєш обличчя Твоє від мене? ");
INSERT INTO ukronpu_vpl VALUES ("PS87_16","020_87_16","PSA","87","16","16","Від юності своєї я пригнічений і виснажений, знесилився, несучи тягар жахів Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_17","020_87_17","PSA","87","17","17","Твоя лють пройшла наді мною, жахи Твої знесилили мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_18","020_87_18","PSA","87","18","18","Вони, як вода, оточують мене цілий день, разом облягають мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS87_19","020_87_19","PSA","87","19","19","Ти віддалив від мене приятеля й друга, темні закутки стали моїми знайомими. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Роздуми Етана-езрахітянина. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Про милість Господа повіки співатиму, з роду в рід звіщатиму Його вірність. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Кажу-бо я: навіки поставлена милість, на небесах утверджена Твоя вірність. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","«Уклав Я Завіт Свій з обраним Моїм, поклявся Я Давидові, рабу Своєму: ");
INSERT INTO ukronpu_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","навіки утверджу насіння Твоє, із роду в рід непохитно поставлю престол твій». Села ");
INSERT INTO ukronpu_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","І небеса прославлять чудеса Твої, Господи, Твою вірність – на зібранні святих. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Бо хто на хмарах може стати в один ряд із Господом? Хто серед синів Божих міг би бути подібним до Господа? ");
INSERT INTO ukronpu_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Бог трепетно вшанований на великій раді святих і грізний серед усіх, хто Його оточує. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Господи, Боже Воїнств, хто такий могутній, як Ти? Вірність Твоя – навколо Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Ти пануєш над розбурханим морем; коли здіймаються хвилі його, Ти втихомирюєш їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Ти вразив Раава, немов убитого в бою; Своїм раменом міцним Ти розсіяв ворогів Своїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Твої небеса і земля Твоя; Ти заснував всесвіт і все, що наповнює його. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Ти створив північ і південь; гори Тавор і Хермон веселяться іменем Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Рамено Твоє могутнє, рука Твоя міцна, піднесена правиця Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Правда й справедливість – основа Твого престолу, милість та істина йдуть перед Твоїм обличчям. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Блаженний народ, що знає звук сурми – у світлі Твого обличчя, Господи, вони ходять. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Іменем Твоїм веселяться цілий день і праведністю Твоєю підносяться. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Бо окраса їхньої міці – Ти, і завдяки прихильності Твоїй наш ріг піднесеться. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_19","020_88_19","PSA","88","19","19","Адже від Господа – щит наш, і від Святого Ізраїлевого – цар наш. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_20","020_88_20","PSA","88","20","20","Колись промовляв Ти у видінні вірним Своїм, кажучи: «Я подав допомогу воїну, підніс обраного з народу. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_21","020_88_21","PSA","88","21","21","Я знайшов Давида, раба Мого, олією святою помазав його. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_22","020_88_22","PSA","88","22","22","Рука Моя підтримає його, рамено Моє зміцнить його. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_23","020_88_23","PSA","88","23","23","Не здолає його ворог, і син беззаконня не буде його гнітити. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_24","020_88_24","PSA","88","24","24","Пошматую перед ним усіх ворогів його й розіб’ю ненависників його. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_25","020_88_25","PSA","88","25","25","Вірність і милість Моя з ним, і в ім’я Моє піднесеться ріг його. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_26","020_88_26","PSA","88","26","26","Покладу його руку на море, а його правицю – на ріки. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_27","020_88_27","PSA","88","27","27","Він буде кликати Мене: „Ти – мій Батько, мій Бог і скеля мого спасіння!“ ");
INSERT INTO ukronpu_vpl VALUES ("PS88_28","020_88_28","PSA","88","28","28","Я зроблю його первістком, вищим від усіх царів землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_29","020_88_29","PSA","88","29","29","Повіки берегтиму милість Мою до нього, і Завіт Мій з ним буде непорушним. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_30","020_88_30","PSA","88","30","30","Продовжу насіння його навіки, і престол його – як дні неба. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_31","020_88_31","PSA","88","31","31","Якщо ж залишать нащадки його Закон Мій і не будуть ходити за Моїми законами правосуддя, ");
INSERT INTO ukronpu_vpl VALUES ("PS88_32","020_88_32","PSA","88","32","32","якщо статутами Моїми знехтують і заповідей Моїх дотримуватися не будуть, ");
INSERT INTO ukronpu_vpl VALUES ("PS88_33","020_88_33","PSA","88","33","33","то Я жезлом покараю беззаконня їхні й ударами – їхні гріхи. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_34","020_88_34","PSA","88","34","34","Але милості Моєї не відійму від нього й не зраджу вірності Моєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_35","020_88_35","PSA","88","35","35","Не збезчещу Завіт Мій і того, що вийшло із вуст Моїх, не зміню. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_36","020_88_36","PSA","88","36","36","Одного разу заприсягнув Я святістю Моєю, як же тепер скажу Я неправду Давидові? ");
INSERT INTO ukronpu_vpl VALUES ("PS88_37","020_88_37","PSA","88","37","37","Насіння його повік перебуватиме, і престол його, як сонце, переді Мною, ");
INSERT INTO ukronpu_vpl VALUES ("PS88_38","020_88_38","PSA","88","38","38","як той місяць – свідок вірний на хмарах – навіки утверджений». Села ");
INSERT INTO ukronpu_vpl VALUES ("PS88_39","020_88_39","PSA","88","39","39","Але Ти знехтував, відкинув, розгнівався на Свого помазанця. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_40","020_88_40","PSA","88","40","40","Ти зневажив Завіт із рабом Своїм, кинув на землю вінець його. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_41","020_88_41","PSA","88","41","41","Ти зруйнував усі огорожі його, перетворив фортеці його на руїну. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_42","020_88_42","PSA","88","42","42","Грабують його всі, хто проходить дорогою; він став ганьбою для сусідів своїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_43","020_88_43","PSA","88","43","43","Ти підніс правицю супротивників його, порадував усіх його ворогів. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_44","020_88_44","PSA","88","44","44","Ти повернув назад вістря його меча й не підтримав його на війні. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_45","020_88_45","PSA","88","45","45","Ти поклав край його величі й престол його кинув на землю. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_46","020_88_46","PSA","88","46","46","Ти скоротив дні юності його, вкрив його соромом. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS88_47","020_88_47","PSA","88","47","47","Доки, Господи, ховатися будеш? Чи назавжди? Доки палатиме, як вогонь, гнів Твій? ");
INSERT INTO ukronpu_vpl VALUES ("PS88_48","020_88_48","PSA","88","48","48","Згадай, яке швидкоплинне життя моє! Для якого марного життя Ти створив усіх синів людських! ");
INSERT INTO ukronpu_vpl VALUES ("PS88_49","020_88_49","PSA","88","49","49","Чи може хто жити й не побачити смерті? Чи може хто врятувати душу свою від царства мертвих? Села ");
INSERT INTO ukronpu_vpl VALUES ("PS88_50","020_88_50","PSA","88","50","50","Де ж милість Твоя, яку раніше Ти з’являв, Володарю, про яку присягався Давидові вірністю Своєю? ");
INSERT INTO ukronpu_vpl VALUES ("PS88_51","020_88_51","PSA","88","51","51","Згадай, Володарю, ганьбу рабів Твоїх, яку я терплю в нутрі моєму від численних народів, ");
INSERT INTO ukronpu_vpl VALUES ("PS88_52","020_88_52","PSA","88","52","52","як безчестять вороги Твої, Господи, як неславлять сліди помазанця Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS88_53","020_88_53","PSA","88","53","53","Благословенний Господь повіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Молитва Мойсея, чоловіка Божого. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Владико, Ти був пристановищем нашим з роду в рід. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Перш ніж народилися гори й Ти утворив землю і всесвіт, від віку й до віку Ти – Бог. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Ти повертаєш людину назад у порох і кажеш: «Поверніться назад, сини людські!» ");
INSERT INTO ukronpu_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Адже тисяча років в очах Твоїх, немов день вчорашній, що минає, як сторожа вночі. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Потоком Ти несеш людей, немов сон минули вони; як трава, що вранці сходить, вранці цвіте й рясніє, а ввечері в’яне й засихає. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Ми щезаємо у гніві Твоєму, і через лють Твою ми збентежені. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Ти поклав наші беззаконня перед Собою, наші приховані гріхи вивів на світло Твого обличчя. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Бо всі дні наші проходять у люті Твоїй; роки наші згасають, немов стогін. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Днів наших – сімдесят років, а якщо є сила, то вісімдесят років, і найкраще в них забирає праця й смуток; вони минають швидко, і ми відлітаємо. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Хто знає силу гніву Твого? Страх перед Тобою, настільки великий, як і лють Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Навчи нас так лічити дні наші, щоб ми набули мудре серце. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Повернися ж, Господи, доки так буде? Змилуйся над рабами Твоїми! ");
INSERT INTO ukronpu_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Насичуй нас милістю Твоєю вранці, тоді ми веселитися й радіти будемо по всі дні наші. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Дай нам порадіти за ті дні, коли Ти упокорював нас, за ті роки, коли ми бачили лихо. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Нехай з’явиться Твоє діло рабам Твоїм, і велич Твоя – синам їхнім. ");
INSERT INTO ukronpu_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","І нехай перебуватиме прихильність Володаря, Бога нашого, на нас. Справу рук наших утверди для нас, справу рук наших зміцни нам. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Той, хто живе під покровом Всевишнього, у тіні Всемогутнього спочиватиме. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Скажу Господеві: «Пристановище моє й твердиня моя – Бог мій, на Нього я надію покладаю». ");
INSERT INTO ukronpu_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Адже Він визволить тебе від тенет людолова й від згубної моровиці. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Мов птах, вкриє тебе Своїм пір’ям, і під крилами Його спочиватимеш безпечно. Щит великий і обладунок – істина Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Не будеш боятися жаху нічного, ані стріли, що вдень летить, ");
INSERT INTO ukronpu_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","ані моровиці, що в пітьмі ходить, ані пошесті, що спустошує опівдні. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Впаде поруч із тобою тисяча ворогів, і десять тисяч – праворуч від тебе, але до тебе вони не наблизяться. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Тільки очима своїми будеш дивитися й побачиш покарання нечестивих. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Оскільки ти Господа – притулок мій, Всевишнього – зробив пристановищем своїм, ");
INSERT INTO ukronpu_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","не спіткає тебе лихо й хвороба не наблизиться до твого шатра. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Бо Він ангелам Своїм про тебе накаже, щоб оберігали тебе на всіх твоїх дорогах. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Вони понесуть тебе на своїх долонях, щоб не спіткнулася нога твоя об камінь. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","На лева й на кобру наступиш, розтопчеш молодого лева й змію. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","«За те, що він полюбив Мене, врятую його, піднесу його, бо він пізнав ім’я Моє. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Коли він покличе Мене, Я відповім йому, у біді з ним буду, визволю його й прославлю. ");
INSERT INTO ukronpu_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Довголіттям насичу його й з’явлю йому Моє спасіння». ");
INSERT INTO ukronpu_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Псалом. Пісня на день суботній. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Як добре славити Господа й співати імені Твоєму, Всевишній, ");
INSERT INTO ukronpu_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","звіщати вранці милість Твою і вірність Твою вночі ");
INSERT INTO ukronpu_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","на лірі десятиструнній і на арфі мелодійній! ");
INSERT INTO ukronpu_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Бо Ти порадував мене, Господи, діянням Своїм, я веселюся справами рук Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Які величні діяння Твої, Господи, і які глибокі задуми Твої! ");
INSERT INTO ukronpu_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Невіглас не знає, і нерозумний не збагне цього. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Хоча нечестиві розростаються, як трава, і розквітають усі, хто чинить беззаконня, це лише, щоб зникнути навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Ти ж, Господи, навіки піднесений. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Бо справді, вороги Твої, Господи, справді, вороги Твої загинуть, розсіються усі, хто чинить беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","А Ти підніс мій ріг, як ріг тура, – я намащений свіжою олією. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Око моє бачить падіння ворогів моїх, про злочинців, що проти мене повстали, чують мої вуха. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Праведник цвіте, мов пальма, височить неначе кедр на Лівані. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Посаджені в домі Господньому, вони цвістимуть у дворах Бога нашого. ");
INSERT INTO ukronpu_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Навіть у старості принесуть плоди, будуть соковитими та свіжими, ");
INSERT INTO ukronpu_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","щоб звіщати, що справедливий Господь, скеля моя, і немає у Ньому кривди. ");
INSERT INTO ukronpu_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Господь царює. Зодягнений Він у велич, Господь зодягнений і підперезаний силою. Тому твердо стоїть всесвіт, не захитається. ");
INSERT INTO ukronpu_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Престол Твій утверджений спрадавна, Ти – споконвіку. ");
INSERT INTO ukronpu_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Піднесли ріки, Господи, піднесли ріки Свій голос, підносять ріки хвилі свої. ");
INSERT INTO ukronpu_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Та могутніший, ніж шум вод великих, ніж могутні хвилі морські, – Господь могутній на висотах небес. ");
INSERT INTO ukronpu_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Одкровення Твої, безсумнівно, надійні; дому Твоєму, Господи, личить святість на довгії дні. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","О Боже помсти, Господи, Боже помсти, з’яви Себе! ");
INSERT INTO ukronpu_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Піднімися, Судде землі, віддай гордим по заслугам! ");
INSERT INTO ukronpu_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Аж доки нечестиві, Господи, доки нечестиві торжествувати будуть? ");
INSERT INTO ukronpu_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Вивергають, промовляють вони пиху, нахваляються всі, хто чинить гріх. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Народ Твій, Господи, вони вражають ударами й пригнічують Твій спадок. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_6","020_93_6","PSA","93","6","6","Вдову й приходька вбивають, сироту гублять ");
INSERT INTO ukronpu_vpl VALUES ("PS93_7","020_93_7","PSA","93","7","7","кажучи: «Не бачить Господь, і не вникає в це Бог Якова». ");
INSERT INTO ukronpu_vpl VALUES ("PS93_8","020_93_8","PSA","93","8","8","Схаменіться, невігласи серед народу! Коли ви станете розумнішими, безумці? ");
INSERT INTO ukronpu_vpl VALUES ("PS93_9","020_93_9","PSA","93","9","9","Той, Хто насадив вухо, хіба не почує? Чи Той, Хто око створив, не побачить? ");
INSERT INTO ukronpu_vpl VALUES ("PS93_10","020_93_10","PSA","93","10","10","Той, Хто народи карає, хіба не докорить? Той, Хто сам людині дає знання? ");
INSERT INTO ukronpu_vpl VALUES ("PS93_11","020_93_11","PSA","93","11","11","Господь знає думки людини, що вони – марнота. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_12","020_93_12","PSA","93","12","12","Блаженний муж, якого Ти наставляєш, Господи, і Законом Твоїм навчаєш його, ");
INSERT INTO ukronpu_vpl VALUES ("PS93_13","020_93_13","PSA","93","13","13","щоб заспокоїти його у дні лиха, поки буде викопана яма нечестивому! ");
INSERT INTO ukronpu_vpl VALUES ("PS93_14","020_93_14","PSA","93","14","14","Адже не покине Господь народу Свого й спадку Свого не полишить. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_15","020_93_15","PSA","93","15","15","Суд знову стане справедливим, і підуть услід за ним усі, праведні серцем. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_16","020_93_16","PSA","93","16","16","Хто стане за мене проти злодіїв? Хто стоятиме за мене проти тих, що чинять гріх? ");
INSERT INTO ukronpu_vpl VALUES ("PS93_17","020_93_17","PSA","93","17","17","Якби Господь не був допомогою моєю, то оселилася б душа моя в країні мовчання. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_18","020_93_18","PSA","93","18","18","Коли сказав я: «Хитається нога моя», милість Твоя, Господи, підтримала мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_19","020_93_19","PSA","93","19","19","Коли тривожні думки множаться в нутрі моєму, Твоя втіха збадьорює мою душу. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_20","020_93_20","PSA","93","20","20","Хіба може мати щось спільне з Тобою престол загибелі, що діє всупереч постанові Закону? ");
INSERT INTO ukronpu_vpl VALUES ("PS93_21","020_93_21","PSA","93","21","21","Натовпом тиснуть вони на душу праведника, і кров невинну засуджують на страту. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_22","020_93_22","PSA","93","22","22","Але Господь став моєю твердинею, і Бог мій – скеля мого притулку. ");
INSERT INTO ukronpu_vpl VALUES ("PS93_23","020_93_23","PSA","93","23","23","Він поверне проти них їхні власні гріхи і їхніми ж злодійствами знищить їх; знищить їх Господь, Бог наш. ");
INSERT INTO ukronpu_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Прийдіть, заспіваємо радісно Господу, вигукнемо піднесено скелі спасіння нашого. ");
INSERT INTO ukronpu_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Прийдемо перед обличчя Його з подякою, піснями прославимо Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Адже Господь – Бог великий і Цар могутніший від усіх богів. ");
INSERT INTO ukronpu_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","У руці Його глибини землі, і вершини гір належать Йому; ");
INSERT INTO ukronpu_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","море – Його, Він створив його, і суходіл Його руки утворили. ");
INSERT INTO ukronpu_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Прийдіть, поклонімося, впадемо долілиць, схилимо коліна перед Господом, Творцем нашим, ");
INSERT INTO ukronpu_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","бо Він – наш Бог, а ми – народ Його пасовища, вівці, про яких Він піклується. Сьогодні, коли ви почуєте Його голос, ");
INSERT INTO ukronpu_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","не зачерствійте серцями вашими, як у Мериві, як було того дня у Массі в пустелі, ");
INSERT INTO ukronpu_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","де спокушали Мене предки ваші, випробовували Мене, хоча й бачили Моє діяння. ");
INSERT INTO ukronpu_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Сорок років дратував Мене цей рід, тоді сказав Я: «Вони народ, що блукає серцем, не знають шляхів Моїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Тому присягнув Я у гніві Моєму: не увійдуть вони до Мого спокою!» ");
INSERT INTO ukronpu_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Співайте Господеві нову пісню; співай Господеві, уся земле! ");
INSERT INTO ukronpu_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Співайте Господеві, благословляйте ім’я Його, звіщайте день у день Його спасіння! ");
INSERT INTO ukronpu_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Розповідайте серед народів про славу Його, серед усіх племен – про чудеса Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Господь великий і вельми прославлений; Він грізніший за усіх богів. ");
INSERT INTO ukronpu_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Адже всі боги народів – лише ідоли, а Господь створив небеса. ");
INSERT INTO ukronpu_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Слава й велич перед обличчям Його, сила й краса у Його святилищі. ");
INSERT INTO ukronpu_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Віддайте Господеві, сім’ї народів, віддайте Господеві славу й силу. ");
INSERT INTO ukronpu_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Віддайте Господеві славу, належну Його імені. Несіть дар і йдіть у двори Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Вклоніться Господеві у величі святині. Тремти перед обличчям Його, уся земле! ");
INSERT INTO ukronpu_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Скажіть серед народів: «Господь царює!» Тому всесвіт утверджений непохитно; Він судитиме народи справедливо. ");
INSERT INTO ukronpu_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Нехай радіють небеса й веселиться земля; нехай гуркотить море і все, що наповнює його. ");
INSERT INTO ukronpu_vpl VALUES ("PS95_12","020_95_12","PSA","95","12","12","Нехай радіє поле і все, що в ньому; нехай вигукують піднесено усі дерева лісові ");
INSERT INTO ukronpu_vpl VALUES ("PS95_13","020_95_13","PSA","95","13","13","перед обличчям Господа, бо Він іде, іде судити землю. Він судитиме всесвіт справедливо і народи – за Своєю істиною. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Господь царює! Нехай веселиться земля, радіють численні острови! ");
INSERT INTO ukronpu_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Хмара й імла навколо Нього; справедливість і правосуддя – основа Його престолу. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Вогонь іде перед Ним і спалює навкруги ворогів Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Блискавки Його освітлюють всесвіт, земля бачить і тремтить. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Гори тануть, немов віск, перед обличчям Господа, перед обличчям Володаря всієї землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Небеса сповіщають Його правду, усі народи бачать Його славу. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Нехай соромом вкриються всі, хто служить ідолам, хто хвалиться нікчемними божками. Вклоніться Йому, усі боги! ");
INSERT INTO ukronpu_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Почув це Сіон і зрадів, звеселилися доньки Юди через суди Твої, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Адже Ти, Господи, Всевишній над усією землею, піднесений високо над усіма богами. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Ті, хто Господа любить, ненавидьте зло! Він береже душі Своїх вірних, визволяє їх від руки нечестивих. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Світло посіяне у праведника, і радість – у щирих серцем. ");
INSERT INTO ukronpu_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Радійте, праведні, у Господі, і славте пам’ять Його святині! ");
INSERT INTO ukronpu_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Псалом. Співайте Господеві нову пісню, бо Він здійснив чудеса; перемогу принесла Йому правиця Його і рамено Його святе. ");
INSERT INTO ukronpu_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Звістив Господь спасіння Своє, відкрив перед очима народів праведність Свою. ");
INSERT INTO ukronpu_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Згадав Він милість Свою й вірність Свою дому Ізраїля. Усі краї землі побачили спасіння Бога нашого. ");
INSERT INTO ukronpu_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Вигукни радісно Господеві, уся земле! Кричи від радості, веселися й співай! ");
INSERT INTO ukronpu_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Грайте Господеві на арфі, на арфі зі звуками співу! ");
INSERT INTO ukronpu_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Під звуки труб і сурми вигукуйте радісно перед Царем, Господом! ");
INSERT INTO ukronpu_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Нехай гуркотить море і все, що його наповнює, всесвіт і все, що мешкає в ньому. ");
INSERT INTO ukronpu_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Нехай ріки плещуть у долоні, нехай гори веселяться разом ");
INSERT INTO ukronpu_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","перед обличчям Господа, бо Він іде судити землю. Він судитиме всесвіт праведно й народи – справедливо. ");
INSERT INTO ukronpu_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Господь царює – нехай тремтять народи! Він сидить на херувимах – нехай здригнеться земля! ");
INSERT INTO ukronpu_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Господь великий на Сіоні, Він піднесений над усіма народами. ");
INSERT INTO ukronpu_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Нехай прославлять вони ім’я Твоє велике й грізне: воно святе! ");
INSERT INTO ukronpu_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Могутнє правління Царя любить правосуддя. Ти утвердив справедливість, здійснив суд і правду у Якова. ");
INSERT INTO ukronpu_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Піднесено славте Господа, Бога нашого, і вклоняйтеся біля підніжжя Його: Він святий! ");
INSERT INTO ukronpu_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Мойсей і Аарон серед священників Його, і Самуїл серед тих, хто кличе Його ім’я; кликали вони до Господа, і Він відповідав їм. ");
INSERT INTO ukronpu_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","У хмарному стовпі говорив до них; вони ж дотримувалися Його одкровень і постанов, які Він дав їм. ");
INSERT INTO ukronpu_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Господи, Боже наш, Ти відповідав їм! Ти був для них Богом, Який прощає, але й карав їх за провини їхні. ");
INSERT INTO ukronpu_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Піднесено славте Господа, Бога нашого, і вклоняйтеся на горі Його святій, бо святий Господь, Бог наш. ");
INSERT INTO ukronpu_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Псалом хвали. Вигукни радісно Господеві, уся земле! ");
INSERT INTO ukronpu_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Служіть Господеві з радістю, прийдіть перед обличчя Його зі співом піднесеним. ");
INSERT INTO ukronpu_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Пізнайте, що Господь є Бог, Він створив нас, і ми Йому належимо; ми – Його народ і вівці Його пасовища. ");
INSERT INTO ukronpu_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Увійдіть у ворота Його з подякою, у двори Його – із хвалою; славте Його й благословляйте ім’я Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Адже добрий Господь, милість Його навіки, із роду в рід вірність Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Псалом Давидів. Про милість і справедливість заспіваю; Тобі, Господи, я співатиму. ");
INSERT INTO ukronpu_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Я уважно стежитиму за дорогою невинною. Коли Ти прийдеш до мене? Ходитиму в невинності мого серця серед дому свого. ");
INSERT INTO ukronpu_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Не покладу перед очима своїми нічого підступного. Я ненавиджу вчинки невірних, вони не пристануть до мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Зіпсоване серце віддалене буде від мене; я не знатиму зла. ");
INSERT INTO ukronpu_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Того, хто таємно зводить наклепи на ближнього свого, я знищу; зарозуміло піднятих очей і гордого серця не терпітиму. ");
INSERT INTO ukronpu_vpl VALUES ("PS100_6","020_100_6","PSA","100","6","6","Очі мої – на вірних землі, щоб мешкали вони зі мною; Той, хто ходить невинним шляхом, мені служитиме. ");
INSERT INTO ukronpu_vpl VALUES ("PS100_7","020_100_7","PSA","100","7","7","Віроломний не житиме в домі моєму, і той, хто говорить неправду, не встоїть перед моїми очима. ");
INSERT INTO ukronpu_vpl VALUES ("PS100_8","020_100_8","PSA","100","8","8","Щоранку знищуватиму всіх нечестивців землі, щоб викорінити із міста Господнього всіх, хто чинить гріх. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Молитва страдника, коли він знемагає й виливає перед Господом свій жаль. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Господи, почуй мою молитву, і нехай дійде до Тебе мій зойк. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Не ховай від мене Твого обличчя у день, коли мені тісно, нахили до мене вухо Твоє. Того дня, коли я кличу, дай мені відповідь негайно. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Бо дні мої щезли, мов дим, і кості мої обгоріли, наче купа золи. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Немов витоптана трава, висохло серце моє, так що я забуваю їсти свій хліб. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Від голосу мого зітхання прилипли кості мої до тіла. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Я уподібнився до сича в пустелі, став немов пугач на руїнах. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Не сплю, став наче птах, що самотньо сидить на даху. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_9","020_101_9","PSA","101","9","9","Щодня вороги мої ганьблять мене, неславлять мене, промовляють ім’я моє, як прокляття. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_10","020_101_10","PSA","101","10","10","Я їм попіл замість хліба й питво моє зі сльозами змішую ");
INSERT INTO ukronpu_vpl VALUES ("PS101_11","020_101_11","PSA","101","11","11","через гнів Твій і лють, бо Ти підняв мене й кинув додолу. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_12","020_101_12","PSA","101","12","12","Дні мої – немов нахилена тінь, я сохну, наче трава. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_13","020_101_13","PSA","101","13","13","А Ти, Господи, житимеш повіки, і пам’ять про Тебе – із роду в рід. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_14","020_101_14","PSA","101","14","14","Ти встанеш, змилуєшся над Сіоном, бо настав час помилувати його, бо прийшла пора. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_15","020_101_15","PSA","101","15","15","Адже слуги Твої уподобали навіть каміння його, і милим став для них його пил. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_16","020_101_16","PSA","101","16","16","Тоді будуть боятися народи імені Господа, і всі царі землі – слави Твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_17","020_101_17","PSA","101","17","17","Бо відбудує Господь Сіон, з’явиться Він у славі Своїй. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_18","020_101_18","PSA","101","18","18","Зглянеться на молитву нужденних і не знехтує благаннями їхніми. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_19","020_101_19","PSA","101","19","19","Нехай записано це буде для прийдешнього покоління, і народ майбутнього прославлятиме Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_20","020_101_20","PSA","101","20","20","Бо Він поглянув із висот святині Своєї, Господь із небес подивився на землю, ");
INSERT INTO ukronpu_vpl VALUES ("PS101_21","020_101_21","PSA","101","21","21","щоб почути стогони в’язня й звільнити приречених на смерть, ");
INSERT INTO ukronpu_vpl VALUES ("PS101_22","020_101_22","PSA","101","22","22","щоб сповістити на Сіоні ім’я Господа й хвалу Його – в Єрусалимі, ");
INSERT INTO ukronpu_vpl VALUES ("PS101_23","020_101_23","PSA","101","23","23","коли зберуться народи й царства разом, щоб служити Господеві. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_24","020_101_24","PSA","101","24","24","Він виснажив силу мою в дорозі, скоротив мої дні. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_25","020_101_25","PSA","101","25","25","Я сказав: «Боже мій, не забирай мене в середині днів моїх, Той, Чиї роки – із роду в рід. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_26","020_101_26","PSA","101","26","26","На початку Ти заклав основи землі, і небеса – діяння рук Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_27","020_101_27","PSA","101","27","27","Вони згинуть, а Ти існуватимеш завжди; усі вони, як одяг, зносяться, і Ти поміняєш їх, немов старі шати, і вони зміняться. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_28","020_101_28","PSA","101","28","28","Але Ти – Той самий, і роки Твої нескінченні. ");
INSERT INTO ukronpu_vpl VALUES ("PS101_29","020_101_29","PSA","101","29","29","Сини рабів Твоїх житимуть, і нащадки їхні міцно стоятимуть перед Твоїм обличчям». ");
INSERT INTO ukronpu_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Псалом Давида. Благослови, душе моя, Господа, і все нутро моє прослав святе ім’я Його! ");
INSERT INTO ukronpu_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Благослови, душе моя, Господа, і не забувай усіх добрих діянь Його! ");
INSERT INTO ukronpu_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Він прощає всі беззаконня твої, зцілює всі твої хвороби, ");
INSERT INTO ukronpu_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","визволяє від безодні смерті життя твоє; Хто вінчає тебе милістю й щедротами, ");
INSERT INTO ukronpu_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","задовольняє бажання твої добром – тоді оновлюється, немов орел, юність твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Господь творить справедливість і правосуддя всім пригніченим. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Він показав шляхи Свої Мойсею і діяння Свої – синам Ізраїлевим. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Милостивий і милосердний Господь, довготерпеливий і щедрий на доброту. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Він не буде постійно вести судову суперечку й гнів триматиме не вічно. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Не за нашими гріхами Він вчинив нам і віддячив нам не так, як ми заслужили нашими переступами. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Адже як високо небо над землею, так звеличилася милість Його над тими, хто Його боїться. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Як далеко схід від заходу, так віддалив Він від нас наші беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Як милує батько синів, так милує Господь тих, хто боїться Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Бо Він знає нашу сутність, пам’ятає, що ми – порох. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Дні людини – немов трава; як цвіт польовий, так цвіте вона. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Як тільки вітер пронесеться над ним, не стане його, і більше не впізнає його місце, де він ріс. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","А милість Господа споконвіку й навіки над тими, хто боїться Його, і праведність Його – на синах синів, ");
INSERT INTO ukronpu_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","що бережуть Його Завіт і пам’ятають настанови Його, щоб їх виконувати. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Господь на небесах утвердив престол Свій, і Царство Його панує над усім. ");
INSERT INTO ukronpu_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Благословіть Господа, ангели Його, могутні силою, що виконують сказане Ним, слухаючись голосу Його слова! ");
INSERT INTO ukronpu_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Благословіть Господа, усі воїнства Його, слуги Його, що виконують Його волю! ");
INSERT INTO ukronpu_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Прославте Господа, усі діяння Його, на всіх місцях Його панування! Благослови, душе моя, Господа! ");
INSERT INTO ukronpu_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Благослови, душе моя, Господа! Господи, Боже мій, Ти звеличився, зодягнувся у славу й велич. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Він огортається світлом, немов шатами; розстилає небеса, як покривало; ");
INSERT INTO ukronpu_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","закладає на водах основи Своїх вишніх світлиць. Він робить хмари Своєю колісницею, крокує на крилах вітру. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Він робить Своїми посланцями вітри, Своїми слугами – полум’я вогню. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Він заклав землю на її основах, тому не похитнеться вона повік-віків! ");
INSERT INTO ukronpu_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Ти вкрив її безоднею, мов одягом, на горах стояли води, ");
INSERT INTO ukronpu_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","та від грізного крику Твого побігли вони, від голосу грому Твого пустилися навтіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Піднялися були в гори вони та спустилися в долини, до місця, яке Ти влаштував для них. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Ти поклав межу, яку вони не перейдуть, не вкриють вони знову землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Ти посилаєш води джерела в річища, між горами течуть вони, ");
INSERT INTO ukronpu_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","напувають усіх звірів польових; там втамовують свою спрагу дикі віслюки. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","При водах тих живуть птахи небесні, з-поміж гілля подають голос. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Він напуває гори з вишніх світлиць Своїх. Від плоду діянь Твоїх насичується земля. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Ти вирощуєш траву для худоби й збіжжя для потреб людини, щоб вивести їжу із землі, ");
INSERT INTO ukronpu_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","і вино, що серце людське веселить, щоб сяяло обличчя від олії і хлібом зміцнилося серце людини. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Насичуються дерева Господні, кедри ліванські, які Він насадив. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Там птахи в’ють гнізда, домівка лелеки – на кипарисах. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Високі гори диким козлам належать, скелі – притулок даманів. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Він створив місяць, щоб час визначати; сонце знає, коли йому заходити. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Ти наводиш темряву, і настає ніч, коли рухаються всі звірі лісові. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Молоді леви ричать за здобиччю, просячи собі у Бога їжу. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Сходить сонце – вони збираються разом і лягають у своє лігво. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_23","020_103_23","PSA","103","23","23","Людина виходить на свою працю й на роботу свою аж до вечора. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_24","020_103_24","PSA","103","24","24","Які численні діяння Твої, Господи! Усе Ти мудро створив; земля наповнена створіннями Твоїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_25","020_103_25","PSA","103","25","25","Ось море велике й просторе, там живина кишить без ліку, живі істоти – малі й великі. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_26","020_103_26","PSA","103","26","26","Там ходять кораблі, там цей Левіятан, якого Ти створив, щоб бавився він у морі. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_27","020_103_27","PSA","103","27","27","Усі вони очікують від Тебе, що Ти даси їм їжу своєчасно. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_28","020_103_28","PSA","103","28","28","Ти даєш їм – вони приймають, відкриваєш руку Твою – насичуються благом. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_29","020_103_29","PSA","103","29","29","Сховаєш обличчя Своє – вони бентежаться. Забираєш дух їхній – гинуть і повертаються в порох земний. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_30","020_103_30","PSA","103","30","30","Пошлеш духа Свого – вони створюються, і Ти оновлюєш обличчя землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_31","020_103_31","PSA","103","31","31","Нехай буде слава Господня навіки, нехай радіє Господь діянням Своїм! ");
INSERT INTO ukronpu_vpl VALUES ("PS103_32","020_103_32","PSA","103","32","32","Він погляне на землю, і вона затремтить; торкнеться до гір, і вони задимлять. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_33","020_103_33","PSA","103","33","33","Я співатиму Господевіусе життя моє; співатиму Богові моєму, поки існую. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_34","020_103_34","PSA","103","34","34","Нехай буде приємним Йому мій роздум: я радітиму в Господі. ");
INSERT INTO ukronpu_vpl VALUES ("PS103_35","020_103_35","PSA","103","35","35","Нехай згинуть грішники із землі й нечестивих більше не буде. Благослови, душе моя, Господа! Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Славте Господа, кличте ім’я Його; серед народів звіщайте діяння Його! ");
INSERT INTO ukronpu_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Співайте Йому, грайте для Нього, звіщайте всі чудеса Його, ");
INSERT INTO ukronpu_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","хваліться іменем Його святим! Нехай веселиться серце тих, хто шукає Господа! ");
INSERT INTO ukronpu_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Прагніть Господа й сили Його, шукайте обличчя Його завжди. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Пам’ятайте про чудеса Його, які Він здійснив, про знамення та суди Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","О нащадки Авраама, слуги Його, сини Якова, Його обранці! ");
INSERT INTO ukronpu_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Він – Господь, Бог наш; суди Його справедливі по всій землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Він вічно пам’ятає Завіт Свій, слово, яке Він заповів для тисяч поколінь, – ");
INSERT INTO ukronpu_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Завіт, який Він уклав з Авраамом, і присягу Його Ісааку. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Він встановив його статутом для Якова, як Завіт вічний для Ізраїля, ");
INSERT INTO ukronpu_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","кажучи: «Тобі віддам Я землю Ханаану як долю вашого спадку». ");
INSERT INTO ukronpu_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Коли вони були людом нечисленним, незначним, і мешкали як приходьки на ній, ");
INSERT INTO ukronpu_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","то мандрували вони від народу до народу, від одного царства до іншого племені. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Він не дозволяв нікому їх гнобити й докоряв за них царям: ");
INSERT INTO ukronpu_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","«Не чіпайте помазанців Моїх і пророкам Моїм не робіть зла». ");
INSERT INTO ukronpu_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Він накликав голод на землю, зламав стебло хлібне. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Послав перед ними чоловіка – у рабство був проданий Йосиф. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Його ноги стисли кайданами, на шию йому наклали залізо, ");
INSERT INTO ukronpu_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","до того часу, поки не здійснилося сказане Господом, поки слово Господа не очистило його. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Послав цар слуг своїх і розв’язав його; правитель народів звільнив його. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Він поставив його володарем над домом своїм і правителем над усім своїм майном, ");
INSERT INTO ukronpu_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","щоб він князів його міг стримувати на свій розсуд і старійшин його повчав. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Тоді прийшов Ізраїль до Єгипту, оселився Яків у землі Хамовій. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","І дуже розмножив Бог народ Свій і зробив його сильнішим від супротивників його, ");
INSERT INTO ukronpu_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","чиї серця Він налаштував, щоб ненавиділи Його народ, щоб лукавили вони з Його рабами. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Він послав Мойсея, слугу Свого, і Аарона, якого обрав Собі. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Вони з’явили знамення Його серед них і чудеса – у землі Хамовій. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Він послав морок, і стало темно, і вони не посміли суперечити Його слову. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Він перетворив води їхні на кров і умертвив рибу в них. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Закишіла земля їхня жабами, навіть у покоях царів їхніх були вони. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Він сказав, і прийшли рої мух, комарі були на всіх теренах їхніх. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Він дав їм замість дощу град, палючий вогонь – на землю їхню; ");
INSERT INTO ukronpu_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","він побив у них виноград та смоковницю, зламав дерева в їхньому краї. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Сказав Він, і прийшла сарана і гусінь – немає їм ліку! ");
INSERT INTO ukronpu_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","І з’їли вони всю траву в землі їхній, пожерли плоди їхніх ґрунтів. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_36","020_104_36","PSA","104","36","36","Тоді вразив Він усіх первістків у землі їхній – першоплоди сили чоловічої. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_37","020_104_37","PSA","104","37","37","І вивів Він ізраїльтян зі сріблом і золотом, не було серед племен їхніх того, хто спотикався. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_38","020_104_38","PSA","104","38","38","Зрадів Єгипет, коли вони вийшли, бо страх напав на нього через них. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_39","020_104_39","PSA","104","39","39","Розгорнув Бог хмару, як покривало, вдень, і вогонь, щоб світити вночі. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_40","020_104_40","PSA","104","40","40","Просив народ, і послав їм Господь перепілок і хлібом небесним наситив їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_41","020_104_41","PSA","104","41","41","Відкрив Він скелю – і полилися води, потекли рікою в сухій землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_42","020_104_42","PSA","104","42","42","Бо згадав Він слово Своє святе, що дав Авраамові, слузі Своєму. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_43","020_104_43","PSA","104","43","43","І вивів Він народ Свій у радості, обраних Своїх – із вигуком переможним. ");
INSERT INTO ukronpu_vpl VALUES ("PS104_44","020_104_44","PSA","104","44","44","Він дав їм землі народів, і вспадкували здобутки праці їхньої, ");
INSERT INTO ukronpu_vpl VALUES ("PS104_45","020_104_45","PSA","104","45","45","щоб вони дотримувалися Його постанов і берегли закони Його. Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Алілуя! Славте Господа, бо Він добрий, бо навіки Його милосердя! ");
INSERT INTO ukronpu_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Хто може виразити словами могутність Господа й сповістити всю хвалу Його? ");
INSERT INTO ukronpu_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Блаженні ті, хто стереже правосуддя, хто справедливо діє повсякчасно! ");
INSERT INTO ukronpu_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Згадай мене, Господи, заради прихильності до Свого народу, з’яви Себе мені в порятунку Твоєму, ");
INSERT INTO ukronpu_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","щоб міг я побачити добробут обраних Тобою, радіти радістю за народ Твій, похвалитися разом зі спадком Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","Згрішили ми, як і предки наші, вчинили беззаконно, діяли нечестиво. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Батьки наші в Єгипті не збагнули Його чудес, не пам’ятали величі милості Твоєї, але збунтувалися біля моря, моря Червоного. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Та Він все ж врятував їх заради Свого імені, щоб виявити Свою могутність. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Пригрозив Він морю Червоному, і висохло воно, і провів Він їх через безодні морські, як по пустелі. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","І врятував їх від руки ненависника, визволив від руки ворога. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Покрили води супротивників їхніх – жоден з них не лишився живим. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Тоді повірили вони словам Його й заспівали Йому хвалу. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Та швидко забули Його діяння, не чекали на пораду від Нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Запалали пристрастю в пустелі й випробовували Бога в дикій землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Тоді Він задовольнив прохання їхнє, але послав виснаження їхнім душам. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Та вони позаздрили Мойсею у стані й Аарону, святому Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Відкрилася земля, і поглинула Датана, і накрила все зборище Авірама. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Запалав вогонь серед їхнього зборища, полум’я пожерло нечестивих. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Вони зробили теля на Хориві й вклонилися істукану, вилитому з металу, ");
INSERT INTO ukronpu_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","проміняли Славу свою на зображення бика, що їсть траву. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Забули Бога, Рятівника свого, Що звершив великі діяння в Єгипті, ");
INSERT INTO ukronpu_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","чудеса в землі Хамовій, дії страшні на морі Червоному. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Він наказав би знищити їх, якби Мойсей, обранець Його, не став перед Ним у проломі, щоб відвернути гнів Його, аби Він не погубив їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","І знехтували вони Землею Бажаною, не повірили Його слову, ");
INSERT INTO ukronpu_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","і ремствували в шатрах своїх, і не слухали голосу Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Тоді Він простягнув руку Свою на них, щоб повалити їх в пустелі, ");
INSERT INTO ukronpu_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","і розкидати нащадків їхніх поміж народами, і розсіяти їх по чужих землях. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Вони пристали до Ваал-Пеора і їли жертви мертвим богам. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","І гнівили Бога вчинками своїми, тоді спалахнула серед них моровиця. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Постав Пінхас і вчинив суд, і моровиця припинилася. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Це зараховано було йому в праведність з роду в рід, навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","І розлютили Його при водах Мериви, і Мойсей зазнав через них лиха, ");
INSERT INTO ukronpu_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","бо засмутили вони його дух, і він говорив нерозсудливо своїми вустами. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Вони не знищили народів, про які сказав їм Господь, ");
INSERT INTO ukronpu_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","але змішалися з народами й навчилися діяти за їхніми вчинками; ");
INSERT INTO ukronpu_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","служили ідолам їхнім, які стали для них пасткою. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Приносили синів своїх і доньок у жертву бісам ");
INSERT INTO ukronpu_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","і проливали невинну кров, кров своїх синів і доньок, яких вони приносили в жертву ідолам ханаанським, і осквернилася земля кров’ю. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Вони стали нечистими через свої діяння, розпусно поводилися у своїх вчинках. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Тоді спалахнула лють Господа на народ Його, гидким став Йому спадок Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","І віддав Він їх у руки народів, і ненависники їхні панували над ними. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Вороги гнобили їх, і вони підкорилися під їхню руку. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Він багато разів визволяв їх, але вони бунтували у своїх задумах і занурилися у гріхи свої. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Але Він зглянувся на скорботу їхню, коли почув їхнє волання, ");
INSERT INTO ukronpu_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","і згадав про Завіт Свій з ними, і змилувався через велике Своє милосердя. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_46","020_105_46","PSA","105","46","46","І викликав співчуття до них у тих, хто тримав їх у полоні. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_47","020_105_47","PSA","105","47","47","Врятуй нас, Господи, Боже наш, і збери нас з-поміж народів, щоб прославити Твоє святе ім’я, піднесено співати Тобі хвалу. ");
INSERT INTO ukronpu_vpl VALUES ("PS105_48","020_105_48","PSA","105","48","48","Благословенний Господь, Бог Ізраїлю, споконвіку й повіки! І нехай скаже увесь народ: «Амінь!» Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Славте Господа, бо Він добрий, бо милість Його навіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Нехай скажуть це викуплені Господом, ті, кого Він визволив від руки ворога ");
INSERT INTO ukronpu_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","й зібрав із різних земель – зі сходу, заходу, з півночі й від моря. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Вони блукали в пустелі, дорогою в дикій землі, не знаходили там ні міста, ні поселення. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Були голодні й спраглі, виснажилися в них душі їхні. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Тоді заволали вони до Господа у своїй скорботі, і Він врятував їх від їхніх страждань. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","І повів їх шляхом прямим, щоб привести у місто, де будуть вони мешкати. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Нехай славлять Господа за милість Його й чудеса Його для синів людських, ");
INSERT INTO ukronpu_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","бо задовольнив Він душу спраглу й душу голодну наситив добром. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Вони сиділи в темряві й тіні смерті, закуті гнітом і залізом, ");
INSERT INTO ukronpu_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","за те, що повстали проти слів Бога й знехтували порадою Всевишнього. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Він упокорив серця їхні працею тяжкою, вони спіткнулися, і ніхто не допомагав. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Тоді заволали вони до Господа у своїй скорботі, і Він врятував їх від їхніх страждань. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","І вивів їх із темряви й тіні смерті, і розірвав їхні кайдани. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Нехай славлять Господа за милість Його й чудеса Його для синів людських, ");
INSERT INTO ukronpu_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","бо зламав Він двері бронзові й розбив засуви залізні. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Нерозумні, через шлях беззаконь і гріхів своїх вони були пригнічені. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Будь-яка їжа стала гидкою душам їхнім, і підступили вони до воріт смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Тоді заволали вони до Господа у своїй скорботі, і Він врятував їх від їхніх страждань. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Послав Своє слово й зцілив їх, і визволив їх від погибелі. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Нехай дякують Господеві за милість Його й чудеса Його для синів людських, ");
INSERT INTO ukronpu_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","і нехай приносять жертви подяки й сповіщають про діяння Його з вигуками радості. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Ті, хто виходить у море на кораблях, промишляють у великих водах, ");
INSERT INTO ukronpu_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","бачили діяння Господа й чудеса Його в глибині. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Він сказав – і піднявся вітер штормовий, здійняв високо хвилі. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Вони підняли кораблі до небес і скинули в безодню – душа моряків розтала через те лихо. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Кружляють, хитаються вони, немов п’яні, і вся мудрість їхня щезла. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Тоді заволали до Господа у своїй скорботі, і Він визволив їх від їхніх страждань. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Він перетворив вітер штормовий на тишу, і замовкли морські хвилі. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Тоді моряки зраділи, що стихли хвилі, і Він привів їх до бажаної пристані. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Нехай славлять Господа за милість Його й чудеса Його для синів людських. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Нехай величають Його в зібранні народу й на засіданні старійшин нехай прославляють Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Він перетворює ріки на пустелю й джерела води – на спраглу землю, ");
INSERT INTO ukronpu_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","землю родючу – на солончак за злі вчинки тих, хто живе на ній. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Він перетворює пустелю на болотистий став і землю висохлу – на джерела води. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","І поселяє там голодних, і вони будують місто для мешкання, ");
INSERT INTO ukronpu_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","засівають поля й насаджують виноградники, що приносять рясний врожай. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Він благословляє їх, і вони розмножуються вельми, і худоба в них не убуває. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Та коли зменшуються числом і поникають вони через утиск, лихо й журбу, ");
INSERT INTO ukronpu_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Він виливає презирство на шляхетних мужів, і блукають вони в пустелі, де немає дороги. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","А бідного Він підіймає із приниження і родину його робить численною, як отара овець. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Побачать це праведники й зрадіють, а кожен беззаконник стулить свої вуста. ");
INSERT INTO ukronpu_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Хто мудрий, нехай збереже ці слова й зрозуміє милість Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Пісня. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Серце моє непохитне, Боже; я співатиму й гратиму Тобі мою славу. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Прокинься, ліро й арфо! Розбуджу-но я зорю досвітню! ");
INSERT INTO ukronpu_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Я прославлю Тебе серед народів, Господи, співатиму Тобі поміж племенами. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Бо велика понад небеса милість Твоя і аж до хмар – істина Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Піднімися понад небесами, Боже; над усією землею – слава Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Щоб улюблені Твої були визволені, врятуй нас правицею Своєю і дай нам відповідь. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Бог промовив у Своєму святилищі: «Урочисто святкуватиму перемогу, Я розділю Сихем і розміряю долину Суккот. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Мені належить Ґілеад, і Манассія – Мій, Єфрем – міць Моєї голови, Юда – Мій законодавець. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Моав – Моя чаша для омовіння, на Едом Я кину Свою сандалію, гукай радісно до Мене, о земле филистимлян!» ");
INSERT INTO ukronpu_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Хто введе мене в місто укріплене? Хто доведе мене до Едома? ");
INSERT INTO ukronpu_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Хіба не Ти, Боже, Котрий відкинув нас і не виходиш, Боже, з воїнствами нашими? ");
INSERT INTO ukronpu_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Подай нам допомогу в боротьбі з ворогом, адже марний порятунок людський. ");
INSERT INTO ukronpu_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","У Бозі ми виявимо силу, і Він розтопче наших ворогів. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Керівнику хору. Псалом Давидів. Боже моєї хвали, не мовчи, ");
INSERT INTO ukronpu_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","адже нечестиві й підступні люди відкрили на мене вуста свої, говорять зі мною брехливим язиком. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Оточили мене словами ненависті й даремно воюють зі мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","За любов мою ворогують зі мною, а я заглиблюся в молитву. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Вони віддячують мені злом за добро й ненавистю – за мою любов. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Постав над ним нечестивця, і обвинувач нехай стане по його правиці. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Коли постане він перед судом, нехай виявиться винним і молитва його нехай вважається гріхом. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Нехай дні його будуть нечисленними, нехай інший займе його становище. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Нехай діти його стануть сиротами, а дружина його – вдовою. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Нехай нащадки його тиняються й жебрають, нехай просять на руїнах своїх домівок. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Нехай захопить лихвар усе, що є в нього, і чужі пограбують плоди його праці. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Нехай не буде нікого, хто виявив би йому співчуття, і над сиротами його нехай ніхто не змилується. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Нехай будуть викорінені його нащадки й зітреться ім’я його в наступному поколінні. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_14","020_108_14","PSA","108","14","14","Нехай згадаються перед Господом беззаконня його предків і гріх матері його не буде стертий. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_15","020_108_15","PSA","108","15","15","Нехай гріхи його будуть завжди перед Господом і нехай викорінена буде з землі пам’ять його ");
INSERT INTO ukronpu_vpl VALUES ("PS108_16","020_108_16","PSA","108","16","16","за те, що він не пам’ятав виявляти іншим милість, але переслідував пригніченого, бідного й зламаного серцем, щоб умертвити його. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_17","020_108_17","PSA","108","17","17","Він любив прокляття – воно прийде до нього; йому не подобалося благословення – воно від нього віддалиться. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_18","020_108_18","PSA","108","18","18","Оскільки він вдягався в прокляття, мов у шати, воно просякло, як вода, в його нутро, і, немов олія, – у його кістки. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_19","020_108_19","PSA","108","19","19","Нехай стане воно для нього одягом, у який він огортається, і поясом, яким він завжди підперізується. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_20","020_108_20","PSA","108","20","20","Така відплата від Господа тому, хто ворогує проти мене, і тим, хто зле говорить на душу мою. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_21","020_108_21","PSA","108","21","21","Ти ж, Господи, Володарю, вступися за мене заради імені Твого; через доброту милосердя Твого визволи мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_22","020_108_22","PSA","108","22","22","Адже я пригнічений і бідний і серце моє зранене в нутрі моєму. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_23","020_108_23","PSA","108","23","23","Я сную, немов похилена тінь, як сарану, струшують мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_24","020_108_24","PSA","108","24","24","Мої коліна ослабли від посту, і тіло моє геть виснажилося без олії. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_25","020_108_25","PSA","108","25","25","Я став посміховищем для них: ті, що бачать мене, похитують глузливо головами своїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_26","020_108_26","PSA","108","26","26","Допоможи мені, Господи, Боже мій, врятуй мене за милістю Твоєю. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_27","020_108_27","PSA","108","27","27","Нехай же знають, що це рука Твоя, що це Ти зробив, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_28","020_108_28","PSA","108","28","28","Нехай вони проклинають, а Ти благослови; вони повстануть, але посоромляться, а слуга Твій радітиме. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_29","020_108_29","PSA","108","29","29","Нехай вдягнуться в безчестя ті, хто проти мене ворогує, і огорнуться ганьбою, немов шатами. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_30","020_108_30","PSA","108","30","30","Я буду славити вустами моїми Господа завзято й серед велелюддя хвалитиму Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS108_31","020_108_31","PSA","108","31","31","Бо Він стоїть по правиці від бідняка, щоб врятувати його від тих, хто судить його душу. ");
INSERT INTO ukronpu_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Псалом Давидів. Промовив Господь Володареві моєму: «Сядь праворуч від Мене, доки Я не покладу ворогів Твоїх, як підніжок для Твоїх ніг». ");
INSERT INTO ukronpu_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Жезл сили Твоєї простягне Господь із Сіону – пануй серед ворогів Твоїх! ");
INSERT INTO ukronpu_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Народ Твій готовий у день з’явлення сили Твоєї, він вишикувався у величний святий стрій. Із надр досвітньої зорі, немов вранішня роса, народження Твоє. ");
INSERT INTO ukronpu_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Поклявся Господь і не відмовиться: «Ти – священник навіки за чином Мельхіседека». ");
INSERT INTO ukronpu_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Володар по правиці від Тебе, Він вразить царів у день гніву Свого. ");
INSERT INTO ukronpu_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Судитиме Він народи, вкриє землю трупами, вразить голову ворога на широкому полі. ");
INSERT INTO ukronpu_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Питиме із потоку при дорозі, тому підніме голову. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Алілуя! Я Господа славити буду всім серцем на раді справедливих і в зібранні. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Діяння Господа величні, бажані для всіх, хто вподобав їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Слава й велич – діяння Його, і правда Його перебуватиме повіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Пам’ятними зробив Він чудеса Свої; милостивий і милосердний Господь. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Їжу дає Він тим, хто боїться Його, пам’ятає вічно Завіт Свій. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Силу діянь Своїх з’явив Він народові Своєму, віддавши їм спадщину народів. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Діяння рук Його – істина й справедливість, усі настанови Його варті довіри. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_8","020_110_8","PSA","110","8","8","Вони утверджені на віки вічні, засновані на істині й справедливості. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_9","020_110_9","PSA","110","9","9","Він послав визволення Своєму народові, уклав навіки Свій Завіт. Святе й грізне ім’я Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS110_10","020_110_10","PSA","110","10","10","Початок мудрості – страх Господній. Добре розуміння мають усі, хто виконує Його настанови. Хвала Йому перебуватиме повіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Алілуя! Блаженний той, хто Господа боїться і в заповідях Його має велике задоволення! ");
INSERT INTO ukronpu_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Будуть сильними на землі нащадки його; покоління справедливих благословиться. ");
INSERT INTO ukronpu_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Достаток і багатство в домі його, і праведність його повік перебуватиме. ");
INSERT INTO ukronpu_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Сяє в темряві світло для справедливих: милостиве, милосердне й праведне воно. ");
INSERT INTO ukronpu_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Добре тому, хто милує й позичає, хто справи свої веде правосудно! ");
INSERT INTO ukronpu_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Бо він не похитнеться повіки; праведник буде у вічній пам’яті. ");
INSERT INTO ukronpu_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Не злякається лихої чутки, серце його непохитне, упевнене в Господі. ");
INSERT INTO ukronpu_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Утверджене його серце, не злякається, аж поки не побачить падіння ворогів своїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Він щедро роздав бідним, його праведність стоятиме повіки, ріг його піднесеться у славі. ");
INSERT INTO ukronpu_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Нечестивий побачить це й розгнівається, заскрегоче зубами своїми й розтане. Бажання нечестивців загине. ");
INSERT INTO ukronpu_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Алілуя! Хваліть, раби Господні, хваліть ім’я Господа! ");
INSERT INTO ukronpu_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Нехай буде ім’я Господнє благословенне віднині й повіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Від сходу сонця й до його заходу прославлене ім’я Господа! ");
INSERT INTO ukronpu_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Господь піднісся високо над усіма народами, вище небес Його слава. ");
INSERT INTO ukronpu_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Хто подібний до Господа, Бога нашого, Який, мешкаючи на висотах, ");
INSERT INTO ukronpu_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","схиляється подивитися на небеса і землю? ");
INSERT INTO ukronpu_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Він піднімає із пилу вбогого, із купи сміття підносить бідняка, ");
INSERT INTO ukronpu_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","щоб посадити його зі шляхетними, зі шляхетними його народу. ");
INSERT INTO ukronpu_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Він неплідну жінку вселяє в дім радісною матір’ю дітей. Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Коли Ізраїль виходив з Єгипту, Яків від народу чужоземного, ");
INSERT INTO ukronpu_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","тоді Юда став Його святинею, Ізраїль – Його володінням. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Море побачило це й кинулося навтіки, Йордан повернувся назад. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Гори скакали, немов барани, пагорби – наче ягнята. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Що з тобою, море, що ти втікаєш, і з тобою, Йордане, що ти назад повертаєшся? ");
INSERT INTO ukronpu_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Що це ви, гори, скакаєте, як барани, і ви, пагорби, – немов ягнята? ");
INSERT INTO ukronpu_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Тремти, земле, перед Володарем, перед Богом Якова, ");
INSERT INTO ukronpu_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Який перетворює скелю на водойму, кремінь – на джерело води. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Не нам, Господи, не нам, але імені Твоєму дай славу за милість і вірність Твою. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_10","020_113_10","PSA","113","10","10","Чому б народи говорили: «Де ж це Бог їхній?» ");
INSERT INTO ukronpu_vpl VALUES ("PS113_11","020_113_11","PSA","113","11","11","А Бог наш на небесах, Він чинить усе, що Йому до вподоби. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_12","020_113_12","PSA","113","12","12","Ідоли їхні – срібло й золото, витвір рук людських. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_13","020_113_13","PSA","113","13","13","У них є вуста, але вони не говорять; у них є очі, але вони не бачать; ");
INSERT INTO ukronpu_vpl VALUES ("PS113_14","020_113_14","PSA","113","14","14","у них є вуха, але не чують; вони мають ніздрі, але не відчувають запаху; ");
INSERT INTO ukronpu_vpl VALUES ("PS113_15","020_113_15","PSA","113","15","15","у них є руки, але не відчувають дотику; вони мають ноги, але не ходять; не видають звуків своєю гортанню. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_16","020_113_16","PSA","113","16","16","Подібними до них нехай стануть ті, хто їх робить, усі, хто на них надію покладає! ");
INSERT INTO ukronpu_vpl VALUES ("PS113_17","020_113_17","PSA","113","17","17","Ізраїлю, покладай надію на Господа – Він для них допомога й щит! ");
INSERT INTO ukronpu_vpl VALUES ("PS113_18","020_113_18","PSA","113","18","18","Доме Ааронів, покладай надію на Господа – Він для них допомога й щит! ");
INSERT INTO ukronpu_vpl VALUES ("PS113_19","020_113_19","PSA","113","19","19","Ті, хто Господа боїться, покладайте надію на Господа – Він для них допомога й щит! ");
INSERT INTO ukronpu_vpl VALUES ("PS113_20","020_113_20","PSA","113","20","20","Господь пам’ятає нас і благословить: благословить дім Ізраїлів, благословить дім Ааронів, ");
INSERT INTO ukronpu_vpl VALUES ("PS113_21","020_113_21","PSA","113","21","21","благословить тих, хто боїться Господа, малих і великих. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_22","020_113_22","PSA","113","22","22","Нехай Господь примножить вам добро, вам і нащадкам вашим! ");
INSERT INTO ukronpu_vpl VALUES ("PS113_23","020_113_23","PSA","113","23","23","Благословенні ви у Господа, Творця неба і землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_24","020_113_24","PSA","113","24","24","Небеса – Господеві належить небо, а землю Він дав синам людським. ");
INSERT INTO ukronpu_vpl VALUES ("PS113_25","020_113_25","PSA","113","25","25","Не мертві хвалитимуть Господа і не всі, хто сходить у країну мовчання, ");
INSERT INTO ukronpu_vpl VALUES ("PS113_26","020_113_26","PSA","113","26","26","але ми благословлятимемо Господа віднині й повіки. Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Люблю я Господа, бо Він чує мій голос, мої благання. ");
INSERT INTO ukronpu_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Через те, що прихилив Він вухо Своє до мене, я буду кликати до Нього всі дні мої. ");
INSERT INTO ukronpu_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Облягли мене кайдани смерті, муки царства мертвих спіткали мене, знайшов я скорботу й страждання. ");
INSERT INTO ukronpu_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Тоді я кликав ім’я Господа: «Господи, благаю, врятуй мою душу!» ");
INSERT INTO ukronpu_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Милостивий Господь і праведний, милосердний Бог наш. ");
INSERT INTO ukronpu_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Господь береже недосвідчених: я знемігся, та Він врятує мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Повернися, душе моя, до свого спокою, адже Господь віддячив тобі добром. ");
INSERT INTO ukronpu_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Бо Ти визволив душу мою від смерті, очі мої – від сліз, ногу мою – від спотикання. ");
INSERT INTO ukronpu_vpl VALUES ("PS114_9","020_114_9","PSA","114","9","9","Я буду ходити перед обличчям Господа на землі живих. ");
INSERT INTO ukronpu_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Я вірив Богові, коли говорив: «Я дуже пригнічений». ");
INSERT INTO ukronpu_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Сказав я у розпачі: «Кожна людина говорить неправду!» ");
INSERT INTO ukronpu_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Чим я віддячу Господеві за всі Його добродійства для мене? ");
INSERT INTO ukronpu_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Піднесу келих спасіння й покличу ім’я Господнє. ");
INSERT INTO ukronpu_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Виконаю усі свої обітниці Господеві перед усім народом Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Цінна в очах Господніх смерть Його вірних. ");
INSERT INTO ukronpu_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Благаю, Господи, я ж раб Твій, я раб Твій і син служниці Твоєї; Ти розв’язав мої пута! ");
INSERT INTO ukronpu_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Тобі принесу я жертву подяки й покличу ім’я Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Виконаю усі свої обітниці Господеві перед усім народом Його, ");
INSERT INTO ukronpu_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","у дворах дому Господнього, посеред тебе, Єрусалиме! Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Славте Господа, усі народи! Хваліть Його, усі племена! ");
INSERT INTO ukronpu_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Бо велика милість Його над нами й істина Господня – навіки. Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Славте Господа, бо Він добрий, бо навіки Його милосердя. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Нехай скаже Ізраїль: «Бо навіки Його милосердя!» ");
INSERT INTO ukronpu_vpl VALUES ("PS117_3","020_117_3","PSA","117","3","3","Нехай скаже дім Ааронів: «Бо навіки Його милосердя!» ");
INSERT INTO ukronpu_vpl VALUES ("PS117_4","020_117_4","PSA","117","4","4","Нехай скажуть ті, що бояться Господа: «Бо навіки Його милосердя!» ");
INSERT INTO ukronpu_vpl VALUES ("PS117_5","020_117_5","PSA","117","5","5","Із тісноти покликав я Господа – Господь відповів мені, вивів мене на просторе місце. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_6","020_117_6","PSA","117","6","6","Господь зі мною – не боятимуся! Що зробить мені людина? ");
INSERT INTO ukronpu_vpl VALUES ("PS117_7","020_117_7","PSA","117","7","7","Господь зі мною, щоб допомагати мені – буду дивитися переможно на моїх ненависників. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_8","020_117_8","PSA","117","8","8","Краще захисту шукати в Господа, ніж надіятися на людину. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_9","020_117_9","PSA","117","9","9","Краще захисту шукати в Господа, ніж надіятися на шляхетних мужів. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_10","020_117_10","PSA","117","10","10","Усі народи оточили мене, та іменем Господнім я знищив їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_11","020_117_11","PSA","117","11","11","Оточили мене, обступили з усіх боків, та іменем Господнім я знищив їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_12","020_117_12","PSA","117","12","12","Оточили мене, як бджоли, та згасли, немов вогонь у терені: іменем Господнім я знищив їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_13","020_117_13","PSA","117","13","13","Ти штовхнув мене, вороже, так сильно, щоб я впав, та Господь допоміг мені. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_14","020_117_14","PSA","117","14","14","Сила моя і пісня моя – Господь; Він став моїм спасінням. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_15","020_117_15","PSA","117","15","15","Голос радості й перемоги в наметах праведників: правиця Господня діє могутньо! ");
INSERT INTO ukronpu_vpl VALUES ("PS117_16","020_117_16","PSA","117","16","16","Правиця Господня піднята вгору, правиця Господня діє могутньо! ");
INSERT INTO ukronpu_vpl VALUES ("PS117_17","020_117_17","PSA","117","17","17","Не помру, але буду жити й розповідати про діяння Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_18","020_117_18","PSA","117","18","18","Господь покарав мене тяжко, та не віддав мене на смерть. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_19","020_117_19","PSA","117","19","19","Відчиніть мені брами правди, я увійду до них, прославлю Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_20","020_117_20","PSA","117","20","20","Це брама Господня, у яку входять праведні. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_21","020_117_21","PSA","117","21","21","Прославлю Тебе, бо Ти відповів мені й став моїм спасінням. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_22","020_117_22","PSA","117","22","22","Камінь, який відкинули будівничі, став наріжним каменем! ");
INSERT INTO ukronpu_vpl VALUES ("PS117_23","020_117_23","PSA","117","23","23","Від Господа це було, як дивно це в очах наших! ");
INSERT INTO ukronpu_vpl VALUES ("PS117_24","020_117_24","PSA","117","24","24","Цей день створив Господь: веселімося й радіймо сьогодні! ");
INSERT INTO ukronpu_vpl VALUES ("PS117_25","020_117_25","PSA","117","25","25","О Господи, врятуй же, о Господи, даруй нам успіх! ");
INSERT INTO ukronpu_vpl VALUES ("PS117_26","020_117_26","PSA","117","26","26","Благословенний Той, Хто йде в ім’я Господа! Благословляємо вас із дому Господнього! ");
INSERT INTO ukronpu_vpl VALUES ("PS117_27","020_117_27","PSA","117","27","27","Бог – це Господь, і Він осяяв нас. В’яжіть мотузками жертву святкову, ведіть до рогів жертовника. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_28","020_117_28","PSA","117","28","28","Ти – мій Бог, і я прославлю Тебе. Боже мій, я величатиму Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS117_29","020_117_29","PSA","117","29","29","Славте Господа, бо Він добрий, бо навіки Його милосердя. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Блаженні ті, чия дорога невинна, хто ходить по ній за Законом Господнім. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Блаженні ті, що дотримуються одкровень Його, усім серцем шукають Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Вони не чинять беззаконня, ходять Його шляхами. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Ти заповів настанов Твоїх триматися твердо. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","О, якби утверджувалися дороги мої в дотриманні постанов Твоїх! ");
INSERT INTO ukronpu_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Тоді не посоромився б я, дивлячись на всі Твої заповіді. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Буду славити Тебе в щирості серця, навчаючись законів правосуддя Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Постанов Твоїх я дотримуватися буду, не покидай же мене назавжди. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Як зможе юнак тримати стежку свою в чистоті? Дотримуючись Твого слова. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Усім серцем моїм шукаю Тебе, не дай мені ухилитися від заповідей Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","У серці моєму сховав я сказане Тобою, щоб не згрішив я проти Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Благословенний Ти, Господи! Навчи мене постанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Вустами моїми я звіщаю усі закони правосуддя із уст Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","На шляху одкровень Твоїх радію я, ніби великими статками. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Про настанови Твої я роздумую й стежки Твої споглядаю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Я підбадьорююся постановами Твоїми, не забуваю Твого слова. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Віддяч добром слузі Своєму, я житиму й буду дотримуватися слова Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Відкрий мої очі, і я побачу чудеса Закону Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Приходьком живу я на землі, не приховуй від мене заповідей Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Зомліла душа моя, прагнучи повсякчасно Твоїх законів правосуддя. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Ти звинуватив проклятих зухвальців, що від заповідей Твоїх ухиляються. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Зніми з мене ганьбу й сором, адже одкровень Твоїх я дотримуюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Хоча князі сидять і змовляються проти мене, та слуга Твій роздумує над постановами Твоїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Одкровення ж Твої – мої радощі, порадники мої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Прилинула до пороху душа моя, оживи мене згідно зі словом Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Я розповів Тобі про дороги свої, і Ти відповів мені; навчи мене постанов Своїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Дай мені зрозуміти шлях настанов Твоїх, і я роздумувати буду над чудесами Твоїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Розпливлася від смутку душа моя, зміцни мене згідно зі словом Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Дорогу неправди віддали від мене і Законом Твоїм як милістю мене обдаруй. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_30","020_118_30","PSA","118","30","30","Я обрав дорогу істини, закони правосуддя поставив перед собою. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_31","020_118_31","PSA","118","31","31","Я прилинув до одкровень Твоїх, Господи, не дай мені осоромитися. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_32","020_118_32","PSA","118","32","32","Побіжу я дорогою заповідей Твоїх, коли ти розуміння моє розшириш. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_33","020_118_33","PSA","118","33","33","Навчи мене, Господи, шляху постанов Твоїх, і я буду дотримуватися його до кінця. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_34","020_118_34","PSA","118","34","34","Дай мені розуміння, і я дотримуватися Закону Твого буду й виконуватиму його всім серцем. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_35","020_118_35","PSA","118","35","35","Поведи мене стежкою заповідей Твоїх, адже на ній я знаходжу задоволення. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_36","020_118_36","PSA","118","36","36","Прихили серце моє до Твоїх одкровень, а не до корисливості. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_37","020_118_37","PSA","118","37","37","Відведи очі мої, щоб не бачили марноти; оживляй мене на шляху Твоєму. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_38","020_118_38","PSA","118","38","38","Виконай усе сказане Тобою рабові Своєму, який боїться Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_39","020_118_39","PSA","118","39","39","Відверни від мене ганьбу, якої я жахаюся, адже закони правосуддя Твого добрі. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_40","020_118_40","PSA","118","40","40","О, як я прагну настанов Твоїх! Оживляй мене праведністю Своєю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_41","020_118_41","PSA","118","41","41","Нехай прийде до мене, Господи, милість Твоя, спасіння Твоє згідно зі словом Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_42","020_118_42","PSA","118","42","42","Тоді відповім я тому, хто словом ганьбить мене, адже я слову Твоєму довіряю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_43","020_118_43","PSA","118","43","43","Ніколи не забирай слова істини від моїх вуст, бо на суди Твої справедливі я сподіваюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_44","020_118_44","PSA","118","44","44","Я буду дотримуватися Закону Твого завжди, повік-віків, ");
INSERT INTO ukronpu_vpl VALUES ("PS118_45","020_118_45","PSA","118","45","45","і ходитиму вільно, бо настанов Твоїх я шукаю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_46","020_118_46","PSA","118","46","46","І говоритиму я про одкровення Твої перед царями, і не буду осоромлений; ");
INSERT INTO ukronpu_vpl VALUES ("PS118_47","020_118_47","PSA","118","47","47","і радітиму Твоїм заповідям, які я полюбив. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_48","020_118_48","PSA","118","48","48","Тоді простягну долоні свої до заповідей Твоїх, які я полюбив, і роздумувати буду про постанови Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_49","020_118_49","PSA","118","49","49","Згадай слово Своє до слуги Твого, на яке Ти заповів мені сподіватися. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_50","020_118_50","PSA","118","50","50","Це – втіха у скорботі моїй, що слово Твоє оживляє мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_51","020_118_51","PSA","118","51","51","Зухвальці надмірно насміхаються з мене, та від Закону Твого я не ухиляюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_52","020_118_52","PSA","118","52","52","Згадую Твої одвічні закони правосуддя, Господи, і втішаюся я. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_53","020_118_53","PSA","118","53","53","Жах охоплює мене через нечестивців, що Закон Твій полишають. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_54","020_118_54","PSA","118","54","54","Співом стали для мене постанови Твої в домі, де я мешкаю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_55","020_118_55","PSA","118","55","55","Я згадую вночі ім’я Твоє, Господи, і дотримуюся Закону Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_56","020_118_56","PSA","118","56","56","Моїм він став, бо настанов Твоїх я дотримуюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_57","020_118_57","PSA","118","57","57","Господи, – сказав я, – доля моя – дотримуватися Твоїх слів. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_58","020_118_58","PSA","118","58","58","Шукав я прихильності обличчя Твого усім серцем: помилуй мене згідно зі словом Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_59","020_118_59","PSA","118","59","59","Я обдумував дороги свої й повертав ноги мої до одкровень Твоїх, ");
INSERT INTO ukronpu_vpl VALUES ("PS118_60","020_118_60","PSA","118","60","60","поспішав і не зволікав виконувати заповіді Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_61","020_118_61","PSA","118","61","61","Кайдани нечестивців облягли мене, та не забув я Закону Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_62","020_118_62","PSA","118","62","62","Опівночі вставав я славити Тебе за справедливі суди Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_63","020_118_63","PSA","118","63","63","Я спільник усім, хто боїться Тебе й хто дотримується настанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_64","020_118_64","PSA","118","64","64","Милістю Твоєю, Господи, наповнена земля; навчи мене постанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_65","020_118_65","PSA","118","65","65","Добре вчинив Ти зі слугою Своїм згідно зі словом Твоїм, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_66","020_118_66","PSA","118","66","66","Доброго розуміння й пізнання навчи мене, адже я повірив заповідям Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_67","020_118_67","PSA","118","67","67","Перш ніж я зазнав страждання мого, я блукав, але тепер слова Твого дотримуюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_68","020_118_68","PSA","118","68","68","Добрий Ти і чиниш добро, тож навчи мене постанов Своїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_69","020_118_69","PSA","118","69","69","Плетуть зухвальці на мене неправду, я ж усім серцем триматимусь настанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_70","020_118_70","PSA","118","70","70","Нечулим, немов лій, стало їхнє серце, я ж Законом Твоїм себе підбадьорюю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_71","020_118_71","PSA","118","71","71","Добре мені, що постраждав я, щоб навчитися постанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_72","020_118_72","PSA","118","72","72","Ліпший для мене Закон Твій, аніж тисячі зливків золота й срібла. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_73","020_118_73","PSA","118","73","73","Руки Твої створили й утвердили мене; дай мені розуміння, і я навчуся заповідей Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_74","020_118_74","PSA","118","74","74","Побачать мене ті, хто боїться Тебе, і зрадіють, бо на слово Твоє я сподіваюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_75","020_118_75","PSA","118","75","75","Я знаю, Господи, що справедливі суди Твої, і через вірність Свою Ти дав мені зазнати страждання. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_76","020_118_76","PSA","118","76","76","Нехай милість Твоя стане втіхою моєю, згідно зі словом Твоїм, даним слузі Твоєму. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_77","020_118_77","PSA","118","77","77","Нехай прийде до мене милосердя Твоє, і я оживу, адже Закон Твій – втіха моя. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_78","020_118_78","PSA","118","78","78","Нехай же посоромляться зухвальці за те, що безвинно пригнічують мене; а я роздумувати буду над настановами Твоїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_79","020_118_79","PSA","118","79","79","Нехай навернуться до мене ті, хто боїться Тебе й знає одкровення Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_80","020_118_80","PSA","118","80","80","Нехай серце моє буде невинним щодо постанов Твоїх, щоб я не осоромився. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_81","020_118_81","PSA","118","81","81","Знемагає душа моя від туги за спасінням Твоїм, але я на слово Твоє сподіваюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_82","020_118_82","PSA","118","82","82","Тануть очі мої, на слово Твоє чекаючи й кажучи: «Коли Ти втішиш мене?» ");
INSERT INTO ukronpu_vpl VALUES ("PS118_83","020_118_83","PSA","118","83","83","Бо я став, немов міх у диму, та постанов Твоїх я не забуваю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_84","020_118_84","PSA","118","84","84","Скільки днів відведено слузі Твоєму? Коли ж Ти вчиниш суд над переслідувачами моїми? ");
INSERT INTO ukronpu_vpl VALUES ("PS118_85","020_118_85","PSA","118","85","85","Зухвальці викопали мені ями всупереч Закону Твоєму. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_86","020_118_86","PSA","118","86","86","Усі заповіді Твої – істина. Мене неправедно переслідують, допоможи мені. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_87","020_118_87","PSA","118","87","87","Мало не згубили мене на землі, та настанов Твоїх я не залишив. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_88","020_118_88","PSA","118","88","88","За милістю Своєю оживи мене, і я буду дотримуватися одкровення вуст Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_89","020_118_89","PSA","118","89","89","Навіки, Господи, слово Твоє утверджене на небесах; ");
INSERT INTO ukronpu_vpl VALUES ("PS118_90","020_118_90","PSA","118","90","90","з роду в рід – вірність Твоя. Ти утвердив землю, і вона стоїть; ");
INSERT INTO ukronpu_vpl VALUES ("PS118_91","020_118_91","PSA","118","91","91","за Твоїми законами правосуддя все стоїть донині, бо все Тобі служить. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_92","020_118_92","PSA","118","92","92","Якби Закон Твій не був моєю втіхою, то я загинув би в скорботі своїй. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_93","020_118_93","PSA","118","93","93","Я повіки не забуду настанов Твоїх, адже ними Ти оживляєш мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_94","020_118_94","PSA","118","94","94","Я – Твій, врятуй же мене, адже прагну я настанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_95","020_118_95","PSA","118","95","95","Нечестиві очікують, щоб погубити мене, та я роздумую над одкровеннями Твоїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_96","020_118_96","PSA","118","96","96","Я бачив межу всілякої досконалості, та заповідь Твоя безмежно широка! ");
INSERT INTO ukronpu_vpl VALUES ("PS118_97","020_118_97","PSA","118","97","97","Як люблю я Закон Твій! Роздумую над ним цілий день. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_98","020_118_98","PSA","118","98","98","Заповіддю Своєю Ти зробив мене мудрішим від ворогів моїх, бо вона навіки зі мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_99","020_118_99","PSA","118","99","99","Я став розумнішим від усіх вчителів моїх, бо одкровення Твої – мої роздуми. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_100","020_118_100","PSA","118","100","100","Я розумію більше, ніж старці, бо настанови Твої дотримую. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_101","020_118_101","PSA","118","101","101","Від усілякої лихої стежки утримую ноги мої, щоб виконувати Твоє слово. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_102","020_118_102","PSA","118","102","102","Від Твоїх законів правосуддя не відступаю, адже Ти навчаєш мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_103","020_118_103","PSA","118","103","103","Які солодкі для мого піднебіння слова Твої! Вони солодші, ніж мед, для вуст моїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_104","020_118_104","PSA","118","104","104","Від настанов Твоїх я набираюсь розуміння, тому ненавиджу всяку стежку неправди. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_105","020_118_105","PSA","118","105","105","Слово Твоє – світильник для ноги моєї і світло для стежки моєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_106","020_118_106","PSA","118","106","106","Присягнув я виконувати справедливі закони правосуддя Твого і виконаю це. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_107","020_118_107","PSA","118","107","107","Постраждав я занадто, Господи, оживи мене згідно зі словом Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_108","020_118_108","PSA","118","108","108","Добровільні жертви вуст моїх нехай приємними будуть Тобі, Господи, і навчи мене Твоїх законів правосуддя. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_109","020_118_109","PSA","118","109","109","Душа моя завжди в моїй руці, та Закону Твого я не забуваю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_110","020_118_110","PSA","118","110","110","Нечестиві розставили тенета для мене, але від настанов Твоїх я не ухиляюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_111","020_118_111","PSA","118","111","111","Я прийняв, як вічний спадок, одкровення Твої, адже вони – радість мого серця. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_112","020_118_112","PSA","118","112","112","Нахилив я серце своє до того, щоб дотримувати постанови Твої повіки, до кінця. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_113","020_118_113","PSA","118","113","113","Ненавиджу двоєдушних людей, а Закон Твій люблю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_114","020_118_114","PSA","118","114","114","Ти – сховище моє й щит; на слово Твоє сподіваюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_115","020_118_115","PSA","118","115","115","Відступіться від мене, злодії, і я буду дотримуватися заповідей Бога мого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_116","020_118_116","PSA","118","116","116","Підтримай мене згідно зі словом Твоїм, і я житиму; і не дай мені осоромитися в надії моїй. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_117","020_118_117","PSA","118","117","117","Підтримай мене, і я буду врятований, і постанови Твої завжди споглядатиму. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_118","020_118_118","PSA","118","118","118","Ти відкидаєш усіх, хто ухиляється від постанов Твоїх, бо хитрощі їхні – неправда. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_119","020_118_119","PSA","118","119","119","Немов золу, відкинеш Ти усіх нечестивців землі; тому я полюбив одкровення Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_120","020_118_120","PSA","118","120","120","Тремтить від страху перед Тобою тіло моє, і судів Твоїх я боюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_121","020_118_121","PSA","118","121","121","Я чинив правосудно й справедливо, – не залишай же мене на поталу моїм гнобителям. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_122","020_118_122","PSA","118","122","122","Заступися за слугу Свого на добро, не дай зухвалим пригнічувати мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_123","020_118_123","PSA","118","123","123","Очі мої тануть, чекаючи на Твій порятунок і на слова Твоєї правди. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_124","020_118_124","PSA","118","124","124","Вчини з рабом Своїм за милістю Твоєю й навчи мене постанов Своїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_125","020_118_125","PSA","118","125","125","Я – слуга Твій, настав мене, і я пізнаю одкровення Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_126","020_118_126","PSA","118","126","126","Час діяти, Господи: Законом Твоїм знехтували. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_127","020_118_127","PSA","118","127","127","Тому полюбив я заповіді Твої більше від золота, щирого золота; ");
INSERT INTO ukronpu_vpl VALUES ("PS118_128","020_118_128","PSA","118","128","128","тому всі настанови Твої визнаю справедливими, а всіляку стежку неправди ненавиджу. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_129","020_118_129","PSA","118","129","129","Дивовижні одкровення Твої, тому душа моя береже їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_130","020_118_130","PSA","118","130","130","Розкриття Твоїх слів просвітлює, напоумлює простих. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_131","020_118_131","PSA","118","131","131","Уста свої розкриваю й прагну, бо жадаю заповідей Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_132","020_118_132","PSA","118","132","132","Обернися до мене й змилуйся, як зазвичай поводишся Ти справедливо з тими, хто любить ім’я Твоє. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_133","020_118_133","PSA","118","133","133","Зміцни мої стопи словом Твоїм і не дай жодному беззаконню оволодіти мною. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_134","020_118_134","PSA","118","134","134","Визволи мене від гноблення людського, і я дотримуватися буду настанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_135","020_118_135","PSA","118","135","135","Обличчям Своїм осяй слугу Твого й навчи мене постанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_136","020_118_136","PSA","118","136","136","Потоками водними течуть мої очі, бо не дотримуються Закону Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_137","020_118_137","PSA","118","137","137","Праведний Ти, Господи, і справедливі суди Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_138","020_118_138","PSA","118","138","138","Одкровення, заповідані Тобою, досконало справедливі й істинні. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_139","020_118_139","PSA","118","139","139","Знесилився я через ревність мою, бо забули мої супротивники слова Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_140","020_118_140","PSA","118","140","140","Слово Твоє випробуване досконало, і слуга Твій любить його. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_141","020_118_141","PSA","118","141","141","Я нікчемний і зганьблений, але настанов Твоїх не забуваю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_142","020_118_142","PSA","118","142","142","Правда Твоя – правда вічна, і Закон Твій – істина. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_143","020_118_143","PSA","118","143","143","Тіснота й скорбота спіткали мене, але заповіді Твої – втіха моя. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_144","020_118_144","PSA","118","144","144","Правда одкровень Твоїх вічна, напоум мене, і я житиму. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_145","020_118_145","PSA","118","145","145","Я кличу всім серцем – дай мені відповідь, Господи, і я буду дотримуватися постанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_146","020_118_146","PSA","118","146","146","Я кличу Тебе, врятуй мене, і я буду дотримуватись одкровень Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_147","020_118_147","PSA","118","147","147","Перед ранковими сутінками волаю я, на слово Твоє сподіваюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_148","020_118_148","PSA","118","148","148","Випереджають очі мої ранкову сторожу, щоб роздумувати над словом Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_149","020_118_149","PSA","118","149","149","Почуй мій голос заради милості Твоєї, Господи, відповідно до справедливого суду Твого оживи мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_150","020_118_150","PSA","118","150","150","Наблизилися до мене зловмисники, та від Закону Твого віддалилися. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_151","020_118_151","PSA","118","151","151","Ти ж близько, Господи, і всі заповіді Твої – істина. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_152","020_118_152","PSA","118","152","152","Здавна знаю я про одкровення Твої, що Ти їх встановив навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_153","020_118_153","PSA","118","153","153","Поглянь на приниження моє й визволи мене, адже Закону Твого не забуваю я. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_154","020_118_154","PSA","118","154","154","Вступися в судову тяганину мою й визволи мене, оживи мене згідно зі словом Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_155","020_118_155","PSA","118","155","155","Далеке від нечестивців спасіння, бо не шукають постанов Твоїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_156","020_118_156","PSA","118","156","156","Щедроти Твої численні, Господи, оживи мене відповідно до справедливого суду Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_157","020_118_157","PSA","118","157","157","Численні переслідувачі й супротивники мої, але від одкровень Твоїх я не ухиляюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_158","020_118_158","PSA","118","158","158","Дивлюся на відступників з огидою, бо слова Твого вони не дотримують. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_159","020_118_159","PSA","118","159","159","Подивися, як люблю я Твої настанови, Господи, заради милості Твоєї оживи мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_160","020_118_160","PSA","118","160","160","Сутність слів Твоїх – істина, вічні справедливі закони правосуддя Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_161","020_118_161","PSA","118","161","161","Князі переслідують мене безвинно, але серце моє боїться Твого слова. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_162","020_118_162","PSA","118","162","162","Радію я слову Твоєму, наче спіткав здобич велику. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_163","020_118_163","PSA","118","163","163","Я ненавиджу неправду, бриджуся нею, Закон же Твій люблю. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_164","020_118_164","PSA","118","164","164","Сім разів на день прославляю Тебе за справедливі суди Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_165","020_118_165","PSA","118","165","165","Великий мир у тих, хто любить Закон Твій, немає в них спотикання. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_166","020_118_166","PSA","118","166","166","Очікую спасіння Твого, Господи, і виконую заповіді Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_167","020_118_167","PSA","118","167","167","Душа моя береже одкровення Твої і любить їх дуже. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_168","020_118_168","PSA","118","168","168","Я дотримуюсь настанов і одкровень Твоїх, бо всі дороги мої перед Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_169","020_118_169","PSA","118","169","169","Нехай наблизиться волання моє до обличчя Твого, Господи, дай мені розуміння, що відповідає слову Твоєму. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_170","020_118_170","PSA","118","170","170","Нехай прийде благання моє перед обличчя Твоє, визволи мене за словом Твоїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_171","020_118_171","PSA","118","171","171","Переливатимуться вуста мої хвалою, коли Ти навчиш мене постанов Своїх. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_172","020_118_172","PSA","118","172","172","Проголошуватиме язик мій слово Твоє, бо всі заповіді Твої – справедливі. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_173","020_118_173","PSA","118","173","173","Нехай рука Твоя буде мені допомогою, адже я обрав Твої настанови. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_174","020_118_174","PSA","118","174","174","Я прагну спасіння Твого, Господи, і Закон Твій – втіха моя. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_175","020_118_175","PSA","118","175","175","Нехай живе душа моя й прославляє Тебе і нехай допоможуть мені Твої закони правосуддя. ");
INSERT INTO ukronpu_vpl VALUES ("PS118_176","020_118_176","PSA","118","176","176","Заблукав я, немов вівця загублена. Шукай слугу Свого, адже заповідей Твоїх я не забув. ");
INSERT INTO ukronpu_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Пісня сходження. У скорботі своїй я кликав до Господа, і Він відповів мені. ");
INSERT INTO ukronpu_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Господи, визволи душу мою від уст неправдивих і язика віроломного. ");
INSERT INTO ukronpu_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Що тобі може дати і що ще додати віроломний язик? ");
INSERT INTO ukronpu_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Лише гострі стріли воїна з розжареним вугіллям дроку! ");
INSERT INTO ukronpu_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Горе мені, бо живу в Мешеху й мешкаю серед шатрів Кедару! ");
INSERT INTO ukronpu_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Достатньо вже мешкала душа моя з тими, хто ненавидить мир. ");
INSERT INTO ukronpu_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Я – за мир, але тільки заговорю – вони стають на війну. ");
INSERT INTO ukronpu_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Пісня сходження. Зводжу очі свої на гори – звідки ж прийде мені допомога? ");
INSERT INTO ukronpu_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Допомога моя від Господа, Творця небес і землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Він не дасть захитатися нозі твоїй, не задрімає Той, Хто береже тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Так, не задрімає й не засне Той, Хто стереже Ізраїля. ");
INSERT INTO ukronpu_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Господь – сторож твій; Господь – тінь твоя по правиці твоїй. ");
INSERT INTO ukronpu_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Сонце не вразить тебе вдень, ані місяць – вночі. ");
INSERT INTO ukronpu_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Господь оберігатиме тебе від усякого зла; Господь стерегтиме душу твою. ");
INSERT INTO ukronpu_vpl VALUES ("PS120_8","020_120_8","PSA","120","8","8","Господь оберігатиме тебе, коли ти будеш виходити й входити, віднині й навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Пісня сходження Давидова. Зрадів я, коли мені сказали: «Ходімо до дому Господнього!» ");
INSERT INTO ukronpu_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Наші ноги стоять у воротах твоїх, Єрусалиме. ");
INSERT INTO ukronpu_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Єрусалиме, що збудований щільно як місто, з’єднане в одне ціле, ");
INSERT INTO ukronpu_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","куди піднімаються племена, Господні племена, згідно з одкровенням, даним Ізраїлю, щоб прославляти там ім’я Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Бо там стоять престоли судні, престоли дому Давидового. ");
INSERT INTO ukronpu_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Просіть миру для Єрусалима: «Нехай у добробуті живуть ті, хто любить тебе! ");
INSERT INTO ukronpu_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Нехай мир буде в укріпленнях твоїх і добробут – у палацах твоїх!» ");
INSERT INTO ukronpu_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Заради братів моїх і друзів скажу я: «Мир тобі!» ");
INSERT INTO ukronpu_vpl VALUES ("PS121_9","020_121_9","PSA","121","9","9","Заради дому Господа, Бога нашого, я щиро бажатиму тобі добра, Єрусалиме! ");
INSERT INTO ukronpu_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Пісня сходження. До Тебе підношу я очі свої, о, Той, Хто мешкає на небесах! ");
INSERT INTO ukronpu_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Ось, як очі рабів – на руку їхніх володарів, як очі служниці – на руку її пані, так очі наші звернені до Господа, Бога нашого, доки Він не помилує нас. ");
INSERT INTO ukronpu_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Помилуй нас, Господи, бо досить наситилися ми безчестям, ");
INSERT INTO ukronpu_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","досить наситилася душа наша глузуванням пихатих, презирством від гордих. ");
INSERT INTO ukronpu_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Пісня сходження Давидова. Якби не був із нами Господь, – нехай скаже Ізраїль, – ");
INSERT INTO ukronpu_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","якби не був із нами Господь, коли повстали проти нас люди, ");
INSERT INTO ukronpu_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","то вони живцем поглинули б нас, коли на нас спалахнув їхній гнів. ");
INSERT INTO ukronpu_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Тоді води потопили б нас, потік пройшов би над нашою душею; ");
INSERT INTO ukronpu_vpl VALUES ("PS123_5","020_123_5","PSA","123","5","5","тоді пронеслися б над нашою душею води бурхливі. ");
INSERT INTO ukronpu_vpl VALUES ("PS123_6","020_123_6","PSA","123","6","6","Благословенний Господь, Який не дав нас на здобич ненависникам нашим! ");
INSERT INTO ukronpu_vpl VALUES ("PS123_7","020_123_7","PSA","123","7","7","Душа наша, мов птах, що звільнився з сильця ловців: тенета розірвалися, а ми визволені! ");
INSERT INTO ukronpu_vpl VALUES ("PS123_8","020_123_8","PSA","123","8","8","Допомога наша – в імені Господа, Творця небес і землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Пісня сходження. Ті, хто надію покладає на Господа, – немов гора Сіон, яка не захитається, але повік перебуває. ");
INSERT INTO ukronpu_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Як гори навколо Єрусалима, так Господь навколо Свого народу віднині й повіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","Не спочине жезл нечестивих над долею праведних, щоб не простягнули праведні руки свої до беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Господи, будь добрим до добрих і справедливих у серцях своїх! ");
INSERT INTO ukronpu_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","А тих, хто блукає манівцями своїми, нехай полишить Господь ходити разом із тим, хто чинить беззаконня. Мир над Ізраїлем! ");
INSERT INTO ukronpu_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Пісня сходження. Коли повертав Господь полон Сіону, ми були ніби уві сні. ");
INSERT INTO ukronpu_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Тоді наповнилися вуста наші сміхом і язик наш – вигуками радості. Тоді говорили серед народів: «Великі діяння звершив Господь для них!» ");
INSERT INTO ukronpu_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","«Великі діяння звершив Господь для нас!» – раділи ми. ");
INSERT INTO ukronpu_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Поверни ж, Господи, наших бранців, як потоки в Неґеві. ");
INSERT INTO ukronpu_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Ті, що зі сльозами сіють, з радісними піснями будуть жати. ");
INSERT INTO ukronpu_vpl VALUES ("PS125_6","020_125_6","PSA","125","6","6","Хто ходить і плачучи несе торбину з насінням, неодмінно повернеться з радісним співом, несучи свої снопи. ");
INSERT INTO ukronpu_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Пісня сходження Соломонова. Якщо Господь не будує дому, марно працюють над ним будівничі. Якщо Господь не стереже міста, марно пильнує охорона. ");
INSERT INTO ukronpu_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Марно ви вдосвіта встаєте, допізна сидите і їсте хліб скорботний, тоді як Він дає сон Своєму улюбленцеві. ");
INSERT INTO ukronpu_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Ось спадщина Господня – діти, нагорода від Нього – плід утроби. ");
INSERT INTO ukronpu_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Як стріли в руці воїна, так сини юності. ");
INSERT INTO ukronpu_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Блаженний той, хто наповнив ними свій сагайдак. Не осоромляться вони, коли говоритимуть із ворогами біля воріт міста. ");
INSERT INTO ukronpu_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Пісня сходження. Блаженний той, хто боїться Господа, хто ходить Його шляхами. ");
INSERT INTO ukronpu_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Ти їстимеш плоди праці рук своїх; блаженний ти і добре тобі! ");
INSERT INTO ukronpu_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Дружина твоя – немов плодовита лоза в покоях твого дому, діти твої – як віття олив навколо твого столу. ");
INSERT INTO ukronpu_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Ось так благословенний буде муж, що боїться Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Нехай благословить тебе Господь із Сіону, щоб ти міг бачити процвітання Єрусалима в усі дні життя свого ");
INSERT INTO ukronpu_vpl VALUES ("PS127_6","020_127_6","PSA","127","6","6","і щоб побачив ти синів своїх синів. Мир над Ізраїлем! ");
INSERT INTO ukronpu_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Пісня сходження. Досить пригнічували мене ще з юності, – нехай скаже Ізраїль, – ");
INSERT INTO ukronpu_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","досить пригнічували мене ще з юності, та не здолали мене! ");
INSERT INTO ukronpu_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","На спині моїй орали орачі, протягнули свої довгі борозни. ");
INSERT INTO ukronpu_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Господь праведний: Він розсік пута нечестивців. ");
INSERT INTO ukronpu_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Нехай осоромляться й назад відсахнуться всі, хто ненавидить Сіон. ");
INSERT INTO ukronpu_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Нехай стануть вони, як трава на даху, що засихає, перш ніж виросте, ");
INSERT INTO ukronpu_vpl VALUES ("PS128_7","020_128_7","PSA","128","7","7","якою жнець не наповнить долоні своєї, і той, хто снопи в’яже, не візьме її оберемком. ");
INSERT INTO ukronpu_vpl VALUES ("PS128_8","020_128_8","PSA","128","8","8","І не скажуть перехожі: «Благословення Господнього вам! Благословляємо вас іменем Господа!» ");
INSERT INTO ukronpu_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Пісня сходження. Із глибин кличу я до Тебе, Господи. ");
INSERT INTO ukronpu_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Володарю, почуй же мій голос, нехай схиляться вуха Твої до голосу благання мого! ");
INSERT INTO ukronpu_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Якщо беззаконня Ти, Господи, пильнуватимеш, хто ж встояти зможе, Владико? ");
INSERT INTO ukronpu_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Але в Тебе прощення, щоб мали страх перед Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Я покладаю надію на Господа, надію має душа моя, і на слово Його сподіваюся. ");
INSERT INTO ukronpu_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Душа моя на Владику чекає більше, ніж сторожа ранку, так, більше, ніж сторожа ранку! ");
INSERT INTO ukronpu_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Нехай Ізраїль сподівається на Господа, адже в Господа милість і велике визволення – у Нього. ");
INSERT INTO ukronpu_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","І Він визволить Ізраїля від усіх його беззаконь. ");
INSERT INTO ukronpu_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Пісня сходження Давидова. Господи, не гордилося серце моє, і не підносилися очі мої, не втручався я у великі й недосяжні для мене дива. ");
INSERT INTO ukronpu_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Хіба не втихомирював і не заспокоював я душі своєї, немов немовля, від грудей матері відлучене? Як відлучене від грудей немовля – душа моя в мені. ");
INSERT INTO ukronpu_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Нехай Ізраїль сподівається на Господа віднині й повіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Пісня сходження. Згадай, Господи, Давида й усі смирення його, ");
INSERT INTO ukronpu_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","коли він присягнув Господеві, дав обітницю Могутньому Богові Якова: ");
INSERT INTO ukronpu_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","«Не увійду в шатро свого дому, не ляжу на постіль мого ложа, ");
INSERT INTO ukronpu_vpl VALUES ("PS131_4","020_131_4","PSA","131","4","4","не дам сну очам моїм і повікам моїм дрімання, ");
INSERT INTO ukronpu_vpl VALUES ("PS131_5","020_131_5","PSA","131","5","5","аж поки не знайду місця для Господа, помешкання для Могутнього Якового Бога». ");
INSERT INTO ukronpu_vpl VALUES ("PS131_6","020_131_6","PSA","131","6","6","Ось ми чули про нього в Ефраті, знайшли його на полях Яара. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_7","020_131_7","PSA","131","7","7","Підійдімо ж до Його помешкання, вклонімося біля Його підніжжя. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_8","020_131_8","PSA","131","8","8","Повстань, Господи, прийди до місця Свого спокою, Ти й ковчег могутності Твоєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_9","020_131_9","PSA","131","9","9","Священники Твої нехай зодягнуться правдою і вірні Твої нехай радісно співають. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_10","020_131_10","PSA","131","10","10","Заради Давида, слуги Свого, не відвертай обличчя від Твого помазанця. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_11","020_131_11","PSA","131","11","11","Істинно присягався Господь Давидові, не зречеться Він цього: «Нащадка від плоду утроби твоєї посаджу на свій престол. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_12","020_131_12","PSA","131","12","12","Якщо дотримуватися будуть сини твої Завіту Мого й одкровень Моїх, яких Я навчу їх, то й сини їхні повік-віків на престолі твоїм сидітимуть». ");
INSERT INTO ukronpu_vpl VALUES ("PS131_13","020_131_13","PSA","131","13","13","Адже обрав Господь Сіон, уподобав мешкати на ньому: ");
INSERT INTO ukronpu_vpl VALUES ("PS131_14","020_131_14","PSA","131","14","14","«Це місце спочинку Мого на віки вічні, тут мешкати буду, бо Я вподобав його. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_15","020_131_15","PSA","131","15","15","Щедро благословлю його їжею, бідняків його насичу хлібом. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_16","020_131_16","PSA","131","16","16","Священників його зодягну спасінням, а вірні його будуть радісно співати. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_17","020_131_17","PSA","131","17","17","Там Я дам розростися рогові Давидовому, встановлю світильника Моєму помазанцеві. ");
INSERT INTO ukronpu_vpl VALUES ("PS131_18","020_131_18","PSA","131","18","18","Ворогів його зодягну соромом, а на ньому сяятиме вінок його». ");
INSERT INTO ukronpu_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Пісня сходження Давидова. Як же добре і як приємно жити братам разом! ");
INSERT INTO ukronpu_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Це як олія дорогоцінна на голові, що стікає на бороду, бороду Ааронову, на краї шат його стікає. ");
INSERT INTO ukronpu_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Це як роса на Хермоні, що сходить на гори Сіонські, бо там заповів Господь благословення – життя навіки! ");
INSERT INTO ukronpu_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Пісня сходження. Благословіть Господа, усі слуги Господні, що стоять вночі у домі Господньому. ");
INSERT INTO ukronpu_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Здійміть руки ваші до святилища й благословіть Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Нехай благословить тебе Господь із Сіону, Творець небес і землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Алілуя! Хваліть ім’я Господа! Хваліть, слуги Господні, ");
INSERT INTO ukronpu_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","що стоять у домі Господньому, у дворах дому Бога нашого! ");
INSERT INTO ukronpu_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Хваліть Господа, бо добрий Господь; співайте імені Його, бо це приємно, ");
INSERT INTO ukronpu_vpl VALUES ("PS134_4","020_134_4","PSA","134","4","4","адже Господь вибрав Собі Якова, Ізраїля – як власність для Себе. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_5","020_134_5","PSA","134","5","5","Бо пізнав я, що великий Господь і Володар наш вищий від усіх богів. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_6","020_134_6","PSA","134","6","6","Усе, що бажає Господь, Він робить на небесах і на землі, у морях і в усіх безоднях океану. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_7","020_134_7","PSA","134","7","7","Піднімає хмари від краю землі, творить блискавки з дощем, виводить вітер зі Своїх сховищ. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_8","020_134_8","PSA","134","8","8","Він вразив первістків Єгипту, від людини до худоби. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_9","020_134_9","PSA","134","9","9","Послав знамення й чудеса посеред тебе, о Єгипте, на фараона й на всіх його слуг. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_10","020_134_10","PSA","134","10","10","Він вразив численні народи й убив могутніх царів: ");
INSERT INTO ukronpu_vpl VALUES ("PS134_11","020_134_11","PSA","134","11","11","Сіхона, царя аморейського, Оґа, царя Башану, і всі царства Ханаану, ");
INSERT INTO ukronpu_vpl VALUES ("PS134_12","020_134_12","PSA","134","12","12","і віддав землі їхні у спадок, у спадок народові Своєму, Ізраїлеві. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_13","020_134_13","PSA","134","13","13","Господи, ім’я Твоє – навіки; Господи, пам’ять про Тебе – з роду в рід. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_14","020_134_14","PSA","134","14","14","Адже судитиме Господь народ Свій і змилується над рабами Своїми. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_15","020_134_15","PSA","134","15","15","Ідоли народів – лише срібло й золото, витвір рук людських. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_16","020_134_16","PSA","134","16","16","Є в них вуста, але вони не говорять; у них є очі, але вони не бачать; ");
INSERT INTO ukronpu_vpl VALUES ("PS134_17","020_134_17","PSA","134","17","17","у них є вуха, але вони не чують, і немає дихання в устах їхніх. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_18","020_134_18","PSA","134","18","18","Подібними до них нехай стануть ті, хто їх робить, усі, хто на них надію покладає. ");
INSERT INTO ukronpu_vpl VALUES ("PS134_19","020_134_19","PSA","134","19","19","Доме Ізраїлів, благослови Господа! Доме Ааронів, благослови Господа! ");
INSERT INTO ukronpu_vpl VALUES ("PS134_20","020_134_20","PSA","134","20","20","Доме Левіїв, благослови Господа! Ті, хто Господа боїться, благословіть Господа! ");
INSERT INTO ukronpu_vpl VALUES ("PS134_21","020_134_21","PSA","134","21","21","Благословенний із Сіону Господь, Який мешкає в Єрусалимі! Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Славте Господа, бо Він добрий, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Славте Бога над богами, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Славте Владику над владиками, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Того, Хто лише один здійснює чудеса великі, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Того, Хто створив небеса розумно, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Того, Хто розкинув землю над водами, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Того, Хто створив світила великі, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","сонце, щоб панувати над днем, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","місяць і зорі, щоб керувати ніччю, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Він вразив Єгипет через його первістків, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","і вивів Ізраїля з-поміж них, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","рукою сильною й плечем простягнутим, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Того, Хто Море Червоне розділив навпіл, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","і провів Ізраїля посеред нього, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","але жбурнув фараона й військо його в Море Червоне, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Він провів народ Свій через пустелю, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Він вразив великих царів, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","убив могутніх царів, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Сіхона, царя аморейського, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","й Оґа, царя Башану, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","і віддав їхню землю у спадок, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_22","020_135_22","PSA","135","22","22","у спадок Ізраїлеві, слузі Своєму, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_23","020_135_23","PSA","135","23","23","Того, Хто згадав нас у приниженні нашому, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_24","020_135_24","PSA","135","24","24","і визволив нас від супротивників наших, бо навіки Його милість; ");
INSERT INTO ukronpu_vpl VALUES ("PS135_25","020_135_25","PSA","135","25","25","Того, Хто дає їжу всьому живому, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS135_26","020_135_26","PSA","135","26","26","Славте Бога небес, бо навіки Його милість. ");
INSERT INTO ukronpu_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Біля річок Вавилона, там сиділи ми й плакали, згадуючи Сіон. ");
INSERT INTO ukronpu_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","На вербах посеред міста ми повісили наші арфи, ");
INSERT INTO ukronpu_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","бо там поневолювачі наші просили від нас слів пісні й гнобителі наші вимагали від нас радості: «Заспівайте нам одну з пісень Сіону!» ");
INSERT INTO ukronpu_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Як можемо ми пісню Господню на землі чужій співати? ");
INSERT INTO ukronpu_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Якщо я забуду тебе, Єрусалиме, нехай забуде правиця моя рухи свої. ");
INSERT INTO ukronpu_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Нехай прилипне язик мій до піднебіння, якщо я не пам’ятатиму тебе, якщо я не піднесу Єрусалима як найвищу радість мою. ");
INSERT INTO ukronpu_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Нагадай, Господи, синам Едомовим день захоплення Єрусалима, коли вони говорили: «Руйнуйте, руйнуйте його до самих підвалин!» ");
INSERT INTO ukronpu_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Донько Вавилона, приречена на спустошення, блаженний той, хто віддасть тобі за те, що ти накоїла нам! ");
INSERT INTO ukronpu_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Блаженний той, хто схопить і розіб’є об скелю твоїх немовлят! ");
INSERT INTO ukronpu_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Псалом Давидів. Буду славити Тебе всім серцем своїм, співатиму Тобі перед богами. ");
INSERT INTO ukronpu_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Поклонюся перед Храмом святині Твоєї і прославлю ім’я Твоє за милість Твою й істину, бо звеличив Ти понад усе ім’я Твоє й Слово Твоє. ");
INSERT INTO ukronpu_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Того дня, коли я кликав Тебе, Ти відповів мені, розбудив у душі моїй силу. ");
INSERT INTO ukronpu_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Прославлять Тебе, Господи, усі царі земні, коли почують слова вуст Твоїх, ");
INSERT INTO ukronpu_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","і будуть оспівувати дороги Господні, бо велика слава Господа. ");
INSERT INTO ukronpu_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Хоч високо Господь, але бачить смиренного й гордого впізнає здалека. ");
INSERT INTO ukronpu_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Навіть якщо я йтиму серед скорботи, Ти оживиш мене, простягнеш руку Твою проти гніву ворогів моїх, і врятує мене правиця Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Господь здійснить правосуддя для мене. Милість Твоя, Господи, повіки: не полишай того, що зробили руки Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Керівнику хору. Псалом Давидів. Господи, Ти дослідив мене й знаєш. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Сідаю я чи встаю – Ти знаєш; Ти розумієш думки мої здалека. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Ти спостерігаєш за мандрівкою моєю й відпочинком, і всі шляхи мої Тобі досконало відомі. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Ще немає слова на язиці у мене, а Ти, Господи, уже знаєш його досконало. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Ти оточив мене ззаду й спереду і поклав долоню Свою на мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Дивне для мене знання Твоє, піднесене, не можу його осягнути. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Куди піти я можу від Духа Твого? Куди втечу від обличчя Твого? ");
INSERT INTO ukronpu_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Якщо зійду на небеса – Ти там; чи в царстві смерті влаштую собі ложе – і там Ти! ");
INSERT INTO ukronpu_vpl VALUES ("PS138_9","020_138_9","PSA","138","9","9","Чи піднесусь на крилах досвітньої зорі, чи поселюся на краю моря – ");
INSERT INTO ukronpu_vpl VALUES ("PS138_10","020_138_10","PSA","138","10","10","навіть там рука Твоя поведе мене, триматиме мене правиця Твоя. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_11","020_138_11","PSA","138","11","11","А якщо скажу: «Напевно, темрява сховає мене і ніччю стане світло навколо мене», ");
INSERT INTO ukronpu_vpl VALUES ("PS138_12","020_138_12","PSA","138","12","12","то навіть темрява не буде темною для Тебе, і ніч буде сяяти, немов день: темрява як світло для Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_13","020_138_13","PSA","138","13","13","Адже Ти створив нутрощі мої, зіткав мене в утробі моєї матері. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_14","020_138_14","PSA","138","14","14","Буду славити Тебе за те, що дивовижно й чудово створений я. Дивні діяння Твої, і душа моя добре це знає! ");
INSERT INTO ukronpu_vpl VALUES ("PS138_15","020_138_15","PSA","138","15","15","Не були приховані від Тебе мої кості, коли я був створений у таємниці, витканий у глибинах землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_16","020_138_16","PSA","138","16","16","Твої очі бачили мій зародок, і в книзі Твоїй були записані всі дні, призначені для мене, коли жодного з них ще не було. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_17","020_138_17","PSA","138","17","17","Які ж дорогі для мене думки Твої, Боже! Яка ж величезна кількість їх! ");
INSERT INTO ukronpu_vpl VALUES ("PS138_18","020_138_18","PSA","138","18","18","Почну лічити їх – вони численніші, ніж пісок. Коли прокидаюся, я все ще з Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_19","020_138_19","PSA","138","19","19","О Боже, якби Ти знищив нечестивого! Віддаліться від мене, кровожерні! ");
INSERT INTO ukronpu_vpl VALUES ("PS138_20","020_138_20","PSA","138","20","20","Вони говорять про Тебе з лукавством, супротивники Твої підносяться марно. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_21","020_138_21","PSA","138","21","21","Як же не зненавидіти мені тих, хто ненавидить Тебе, Господи? Як не обридитися мені тими, хто повстає проти Тебе? ");
INSERT INTO ukronpu_vpl VALUES ("PS138_22","020_138_22","PSA","138","22","22","Ненавиджу їх повною ненавистю, вони стали мені ворогами. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_23","020_138_23","PSA","138","23","23","Досліди мене, Боже, і пізнай моє серце; випробуй мене і пізнай тривожні думки мої. ");
INSERT INTO ukronpu_vpl VALUES ("PS138_24","020_138_24","PSA","138","24","24","І подивися, чи не на хибній я дорозі, і поведи мене шляхом вічності. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Керівнику хору. Псалом Давидів. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Врятуй мене, Господи, від людини злої, оберігай мене від насильників, ");
INSERT INTO ukronpu_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","які зло задумують у серці, щодня збурюють війни. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Гострять язики свої, наче змії; отрута аспидова на губах у них. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Оберігай мене, Господи, від рук нечестивця, врятуй мене від насильників, що задумали похитнути мої стопи. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Горді приховали пастку й мотузки для мене, розтягнули сіті вздовж стежки, розставили мені тенета. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Я сказав Господеві: «Ти – мій Бог! Почуй, Господи, голос мого благання! ");
INSERT INTO ukronpu_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Господи, Владико, сило спасіння мого, Ти прикрив голову мою в день битви. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Не дай, Господи, нечестивому того, що він бажає, не дай здійснитися його задуму, бо він загордиться». Села ");
INSERT INTO ukronpu_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","Голови тих, хто оточив мене, нехай накриє лихо їхніх вуст. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Нехай впаде на них розжарене вугілля, нехай будуть вкинуті у вогонь, у провалля бездонне, щоб не встали більше. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Людина зі злим язиком не утвердиться на землі; насильника нехай вполює зло йому на погибель. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Я знаю, що Господь здійснить суд бідному, вчинить правосуддя пригнобленому. ");
INSERT INTO ukronpu_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Так, прославлятимуть праведні ім’я Твоє, житимуть справедливі перед обличчям Твоїм! ");
INSERT INTO ukronpu_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Псалом Давидів. Господи, до Тебе кличу, поспіши до мене! Прислухайся до голосу мого, коли я кличу до Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Нехай молитва моя постане як кадіння приємне перед обличчям Твоїм і піднесені долоні мої – як жертвоприношення вечірнє. ");
INSERT INTO ukronpu_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Господи, постав варту біля моїх вуст, стережи двері моїх губ. ");
INSERT INTO ukronpu_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Не дай серцю моєму ухилитися в бік зла, щоб чинити нечестиво разом із беззаконними людьми, що коять гріх; і нехай не скуштую я їхніх насолод. ");
INSERT INTO ukronpu_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Нехай картає мене праведник – це милість; нехай докоряє мені – це приємно, як олія на голову: не відмовиться голова моя від неї. Та все ще молюся я проти злодійства нечестивих: ");
INSERT INTO ukronpu_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Нехай би скинуті були судді їхні з країв скелі, і, може, тоді почули б слова мої, що вони лагідні. ");
INSERT INTO ukronpu_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Як орють землю й розбивають грудки на ній, так розкидані кості наші біля пащі царства смерті. ");
INSERT INTO ukronpu_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Але до Тебе, Господи, Владико, звернені мої очі; у Тобі я притулок знайшов, не покинь напризволяще душі моєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Убережи мене від тенет, що розкинуті для мене, і від сітей беззаконників. ");
INSERT INTO ukronpu_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Нехай впадуть нечестиві у свої ж пастки, поки я мину їх безпечно. ");
INSERT INTO ukronpu_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Роздуми Давидові, коли він був у печері. Молитва. Голосно до Господа волаю, голосно Господа благаю. ");
INSERT INTO ukronpu_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Виливаю перед Ним скаргу мою, розповів Йому про скорботу свою. ");
INSERT INTO ukronpu_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Коли знемагав у мені дух, Ти знав стежину мою. На дорозі, якою я йшов, вони сховали для мене пастку. ");
INSERT INTO ukronpu_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Поглянь, Господи, праворуч і побач: ніхто не впізнає мене, загинув притулок мій, нікому немає діла до душі моєї. ");
INSERT INTO ukronpu_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","До Тебе волаю я, Господи, кажучи: «Ти – пристановище моє, доля моя на землі живих». ");
INSERT INTO ukronpu_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Прислухайся до волання мого, бо знемігся я дуже; визволи мене від моїх переслідувачів, адже вони сильніші за мене. ");
INSERT INTO ukronpu_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Виведи з в’язниці душу мою, щоб прославити мені ім’я Твоє. Зберуться праведні довкола мене, коли Ти мені віддячиш. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Псалом Давидів. Господи, почуй мою молитву, прислухайся до благань моїх. Заради вірності й праведності Своєї дай мені відповідь. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Не судися з рабом Своїм, бо ніхто із живих не виправдається перед Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Бо ворог переслідує душу мою, втоптав у землю моє життя, змусив мене мешкати в темних закутках, подібно до померлих навіки. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Знемігся в мені дух мій, скам’яніло в мені серце моє. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Я згадую дні прадавні, роздумую про всі діяння Твої, споглядаю те, що зробили руки Твої. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Простягаю руки свої до Тебе; душа моя, як виснажена земля, Тебе прагне. Села ");
INSERT INTO ukronpu_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Поспіши відповісти мені, Господи, бо знемагає мій дух. Не ховай обличчя Твого від мене, бо стану я подібним до тих, хто сходить до прірви. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_8","020_142_8","PSA","142","8","8","Дай мені почути вранці про милість Твою, адже на Тебе я надію покладаю. Покажи мені дорогу, якою мені йти, адже до Тебе я підношу душу мою. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_9","020_142_9","PSA","142","9","9","Визволи мене від ворогів моїх, Господи, бо біля Тебе я шукаю притулок. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_10","020_142_10","PSA","142","10","10","Навчи мене виконувати волю Твою, адже Ти – Бог мій. Дух Твій добрий нехай веде мене по рівній землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_11","020_142_11","PSA","142","11","11","Заради імені Твого, Господи, оживи мене; заради праведності Твоєї виведи душу мою зі скорботи. ");
INSERT INTO ukronpu_vpl VALUES ("PS142_12","020_142_12","PSA","142","12","12","За милістю Своєю знищ ворогів моїх і вигуби всіх, хто пригнічує мою душу, адже я слуга Твій. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Псалом Давидів. Благословенний Господь, скеля моя, Що привчає руки мої до битви й пальці мої – до війни. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Він – милість моя, твердиня моя, пристановище моє й визволитель мій, щит мій, на Нього я надію покладаю; Він підкорює мені народ мій. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Господи, хто така людина, що Ти знаєш про неї, і син людський, що Ти думаєш про нього? ");
INSERT INTO ukronpu_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Людина – немов подих вітру; дні її – немов тінь, що минає. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Господи, нахили небеса і зійди, торкнися гір – і вони задимляться. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Блисни блискавкою й розсій їх, випусти стріли Свої й нажахай їх. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Простягни руку Твою з висоти, визволи мене й врятуй від великих вод, від рук чужинців, ");
INSERT INTO ukronpu_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","що вустами своїми марне промовляють і чия правиця діє неправедно. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Боже, пісню нову заспіваю Тобі, на лірі десятиструнній Тобі заграю – ");
INSERT INTO ukronpu_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Тому, Хто дає перемогу царям, визволяє Давида, слугу Свого, від лютого меча. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Визволи мене й врятуй від рук чужинців, що вустами своїми марне промовляють і чия правиця діє неправедно. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Тоді будуть сини наші немов молоді пагони, що розрослися, а наші доньки – наче різьблені колони майстерно збудованого палацу; ");
INSERT INTO ukronpu_vpl VALUES ("PS143_13","020_143_13","PSA","143","13","13","комори будуть повні різноманітним збіжжям; дрібної худоби нашої будуть тисячі, десятки тисяч на пасовищах наших; ");
INSERT INTO ukronpu_vpl VALUES ("PS143_14","020_143_14","PSA","143","14","14","бики наші будуть витривалими; не буде ні пролому в стіні, ні виходу в полон, ані зойку на вулицях наших. ");
INSERT INTO ukronpu_vpl VALUES ("PS143_15","020_143_15","PSA","143","15","15","Блаженний народ, що так йому ведеться; блаженний народ, чий Бог – Господь! ");
INSERT INTO ukronpu_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Хвала Давидова. Величатиму Тебе, Боже мій, Царю, і благословлятиму ім’я Твоє повік-віків ");
INSERT INTO ukronpu_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Щодня благословлятиму Тебе й хвалитиму ім’я Твоє повік-віків. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Великий Господь і вельми прославлений, і велич Його – неосяжна. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Покоління поколінню хвалитиме діяння Твої і про могутність Твою звіщатиме. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Про дивну славу величі Твоєї й про чудові діяння Твої я роздумувати буду. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Коли говоритимуть про силу грізних діянь Твоїх, і я звіщатиму про велич Твою. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","На згадку про велику доброту Твою будуть промовляти й про праведність Твою радісно співатимуть. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Милостивий і милосердний Господь, довготерпеливий і багатий милістю. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Добрий Господь до всіх, і милосердя Його над усіма Його творіннями. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Прославлять Тебе, Господи, усі творіння Твої, і вірні Твої благословлятимуть Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Про славу Царства Твого розповідатимуть і про могутність Твою промовлятимуть, ");
INSERT INTO ukronpu_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","щоб звістити синам людським про могутність Твою і про славу величі Царства Твого. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Царство Твоє – царство на всі віки, і панування Твоє – на всі покоління. Вірний Господь словам Своїм і праведний в усіх Своїх діяннях. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Господь підтримує усіх, хто падає, і випростовує всіх зігнутих. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Очі всіх на Тебе звернені з надією, і Ти даєш їм їжу своєчасно. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_16","020_144_16","PSA","144","16","16","Відкриваєш руку Свою й зичливо насичуєш усе живе. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_17","020_144_17","PSA","144","17","17","Праведний Господь в усіх Своїх дорогах і милостивий в усіх Своїх діяннях. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_18","020_144_18","PSA","144","18","18","Близький Господь до всіх, хто кличе Його, до всіх, хто кличе Його істинно. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_19","020_144_19","PSA","144","19","19","Бажання тих, хто боїться Його, Він здійснює, благання їхні чує і дає їм порятунок. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_20","020_144_20","PSA","144","20","20","Оберігає Господь усіх, хто любить Його, а всіх нечестивих знищить. ");
INSERT INTO ukronpu_vpl VALUES ("PS144_21","020_144_21","PSA","144","21","21","Хвалу Господеві проголосять уста мої, і благословлятиме усе живе Його святе ім’я повік-віків! ");
INSERT INTO ukronpu_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Алілуя! Хвали, душе моя, Господа! ");
INSERT INTO ukronpu_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Буду Господа хвалити все життя моє, співатиму Богові моєму, поки живу. ");
INSERT INTO ukronpu_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Не покладайте надії на мужів шляхетних, на людину, у якій немає порятунку. ");
INSERT INTO ukronpu_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Дух її виходить, і вона повертається в землю, – у той же день зникають усі її задуми. ");
INSERT INTO ukronpu_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Блаженний той, чия допомога – Бог Яковів, хто надію покладає на Господа, Бога свого, ");
INSERT INTO ukronpu_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Того, Хто створив небеса, землю, море й усе, що наповнює його, Хто вічно береже вірність Свою; ");
INSERT INTO ukronpu_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Того, Хто правосуддя чинить для пригнічених, дає хліб голодним. Господь звільняє в’язнів, ");
INSERT INTO ukronpu_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Господь відкриває очі сліпим, Господь випростовує зігнутих, Господь любить праведних. ");
INSERT INTO ukronpu_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Господь оберігає приходьків, сироту й вдову підтримує, а дорогу нечестивих викривлює. ");
INSERT INTO ukronpu_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Буде царювати Господь повіки, Бог твій, Сіоне, – з роду в рід. Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Алілуя! Як добре співати Богові нашому, яка ж приємна належна Йому хвала! ");
INSERT INTO ukronpu_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Господь відбудовує Єрусалим, збирає вигнанців Ізраїля; ");
INSERT INTO ukronpu_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","зцілює розбитих серцем і перев’язує їхні рани; ");
INSERT INTO ukronpu_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","обчислює кількість зірок і кожну називає поіменно. ");
INSERT INTO ukronpu_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Великий Володар наш і вельми сильний, розум Його безмірний. ");
INSERT INTO ukronpu_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Господь підтримує пригноблених, а нечестивих принижує аж до землі. ");
INSERT INTO ukronpu_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Віддайте Господеві подяку, співайте Богові нашому на арфі. ");
INSERT INTO ukronpu_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Він небеса вкриває хмарами, готуючи дощ для землі, Хто на горах вирощує траву, ");
INSERT INTO ukronpu_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","дає худобі їжу й пташенятам ворона, коли вони кричать. ");
INSERT INTO ukronpu_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Не міць коня Йому до вподоби, не силу стегон людських Він уподобав; ");
INSERT INTO ukronpu_vpl VALUES ("PS146_11","020_146_11","PSA","146","11","11","Господь уподобав тих, хто боїться Його, хто на милість Його сподівається. ");
INSERT INTO ukronpu_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Хвали, Єрусалиме, Господа; прославляй Бога твого, Сіоне! ");
INSERT INTO ukronpu_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Бо Він зміцнив засуви воріт твоїх, благословив синів твоїх посеред тебе. ");
INSERT INTO ukronpu_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Він встановлює мир на твоїх кордонах, насичує тебе відбірною пшеницею. ");
INSERT INTO ukronpu_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Він посилає наказ Свій землі, швидко біжить Його Слово. ");
INSERT INTO ukronpu_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Він дає сніг, немов вовну, розпорошує паморозь, наче попіл, ");
INSERT INTO ukronpu_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","кидає кригу Свою, ніби дрібні камінці; хто може встояти перед Його морозом? ");
INSERT INTO ukronpu_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Він пошле слово Своє, і все розтане, подує вітром Своїм – потечуть води. ");
INSERT INTO ukronpu_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Він звіщає слово Своє Якову, постанови й закони правосуддя – Ізраїлеві. ");
INSERT INTO ukronpu_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Він не зробив такого жодному іншому народові, і правосуддя законів вони не знають. Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Алілуя! Хваліть Господа з небес, прославляйте Його на висотах. ");
INSERT INTO ukronpu_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Хваліть Його, усі ангели Його, прославляйте Його, усі воїнства Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Хваліть Його, сонце і місяць, прославляйте Його, усі ясні зорі. ");
INSERT INTO ukronpu_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Хваліть Його, небеса небес, і води, що над небесами. ");
INSERT INTO ukronpu_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Хваліть ім’я Господа, бо Він наказав – і вони були створені. ");
INSERT INTO ukronpu_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Він утвердив їх на віки вічні – дав постанову, що не буде скасована. ");
INSERT INTO ukronpu_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Хваліть Господа з землі, морські чудовиська й усі безодні океану, ");
INSERT INTO ukronpu_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","вогонь і град, сніг і туман, вітер бурхливий, що виконує Його слово, ");
INSERT INTO ukronpu_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","гори й усі пагорби, дерева плодоносні й усі кедри, ");
INSERT INTO ukronpu_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","звірі й уся худоба, живина плазуюча й птахи крилаті, ");
INSERT INTO ukronpu_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","царі земні й усі племена, князі й усі судді землі, ");
INSERT INTO ukronpu_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","юнаки й дівчата, старі з юними – ");
INSERT INTO ukronpu_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","хваліть ім’я Господа, бо лише Його ім’я піднесене й велич Його – над землею й небесами! ");
INSERT INTO ukronpu_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Він підняв ріг народу Свого, прославив вірних Своїх – синів Ізраїлевих, народу, що близький Йому. Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Алілуя! Співайте Господеві нову пісню, хвалу Йому віддайте у зібранні вірних. ");
INSERT INTO ukronpu_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Нехай радіє Ізраїль своїм Творцем, сини Сіона нехай веселяться Царем своїм. ");
INSERT INTO ukronpu_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Хваліть ім’я Його в хороводі, співайте Йому з арфою й бубном, ");
INSERT INTO ukronpu_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","бо вподобав Господь народ Свій, прикрашає смиренних спасінням. ");
INSERT INTO ukronpu_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Нехай вірні веселяться у славі, радіють на своїх ложах. ");
INSERT INTO ukronpu_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Богові хвала піднесена на вустах у них і меч обосічний у їхній руці, ");
INSERT INTO ukronpu_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","щоб вчинити помсту народам, здійснити покарання над племенами, ");
INSERT INTO ukronpu_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","щоб зв’язати царів їхніх кайданами й вельмож їхніх – залізними ланцюгами, ");
INSERT INTO ukronpu_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","щоб звершити над ними записаний вирок. Така честь належить усім вірним Йому. Алілуя! ");
INSERT INTO ukronpu_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Алілуя! Хваліть Бога у святині Його, хваліть Його на Його могутній тверді небес. ");
INSERT INTO ukronpu_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Хваліть Його за могутні діяння Його, хваліть Його за безмірну велич Його. ");
INSERT INTO ukronpu_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Хваліть Його зі звуком сурми, хваліть Його на лірі й арфі. ");
INSERT INTO ukronpu_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Хваліть Його з бубном і хороводом, хваліть Його струнами й сопілкою. ");
INSERT INTO ukronpu_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Хваліть Його на звучних цимбалах, хваліть Його на дзвінких цимбалах. ");
INSERT INTO ukronpu_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Усе, що дихає, нехай хвалить Господа! Алілуя!");
INSERT INTO ukronpu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Книга родоводу Ісуса Христа, сина Давида, сина Авраама: ");
INSERT INTO ukronpu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Авраам був батьком Ісаака, Ісаак був батьком Якова, Яків був батьком Юди та його братів, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Юда був батьком Фареса та Зари від Тамари, Фарес був батьком Есрома, Есром був батьком Арама, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Арам був батьком Аммінадава, Аммінадав був батьком Наасона, Наасон був батьком Салмона, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Салмон був батьком Воаза від Рахав, Воаз був батьком Овіда від Рут, Овід був батьком Єссея, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Єссей був батьком Царя Давида. Давид був батьком Соломона від Урієвої вдови, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Соломон був батьком Ровоама, Ровоам був батьком Авії, Авія був батьком Аси, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Аса був батьком Йосафата, Йосафат був батьком Йорама, Йорам був батьком Осії, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Осія був батьком Йотама, Йотам був батьком Ахаза, Ахаз був батьком Езекії, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Езекія був батьком Манасії, Манасія був батьком Амоса, Амос був батьком Йосії, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Йосія був батьком Єхонії та його братів під час переселення у Вавилон. ");
INSERT INTO ukronpu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Після переселення у Вавилон Єхонія був батьком Салатиїла, Салатиїл був батьком Зоровавеля, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Зоровавель був батьком Авіюда, Авіюд був батьком Еліакима, Еліаким був батьком Азора, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Азор був батьком Садока, Садок був батьком Ахіма, Ахім був батьком Еліюда, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Еліюд був батьком Елеазара, Елеазар був батьком Маттана, Маттан був батьком Якова, ");
INSERT INTO ukronpu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Яків був батьком Йосифа, чоловіка Марії, від якої народився Ісус, названий Христом. ");
INSERT INTO ukronpu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Отже, від Авраама до Давида всього було чотирнадцять поколінь, від Давида до переселення у Вавилон – чотирнадцять поколінь і від переселення у Вавилон до Христа – чотирнадцять поколінь. ");
INSERT INTO ukronpu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Народження Ісуса Христа відбулося так: Марія, Його мати, була заручена з Йосифом. Перед їхнім одруженням виявилося, що вона вагітна від Святого Духа. ");
INSERT INTO ukronpu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Але Йосиф, її чоловік, був праведним і, не бажаючи зганьбити Марію, вирішив таємно відпустити її. ");
INSERT INTO ukronpu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Коли ж він про це думав, з’явився йому уві сні ангел Господній та сказав: «Йосифе, сину Давида, не бійся взяти Марію, дружину свою, бо зачате в ній – від Духа Святого. ");
INSERT INTO ukronpu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Вона народить Сина, і ти назвеш Його Ісус, бо Він спасатиме народ Свій від його гріхів». ");
INSERT INTO ukronpu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Усе це сталося, щоби сповнилось сказане Господом через пророка: ");
INSERT INTO ukronpu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ось діва завагітніє й народить Сина, і дадуть Йому ім’я Еммануїл», що перекладається «З нами Бог». ");
INSERT INTO ukronpu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Прокинувшись від сну, Йосиф зробив так, як звелів йому ангел Господній, і взяв Марію за дружину. ");
INSERT INTO ukronpu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Але не знав її, поки вона не народила Сина свого первонародженого, і він дав Йому ім’я Ісус. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Коли за днів царя Ірода у Віфлеємі юдейському народився Ісус, до Єрусалима прийшли мудреці зі Сходу ");
INSERT INTO ukronpu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","й спитали: «Де Цар юдеїв, Який народився? Бо ми бачили Його зірку на Сході й прийшли поклонитися Йому». ");
INSERT INTO ukronpu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Почувши про це, Цар Ірод занепокоївся, а з ним і весь Єрусалим. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Він покликав усіх первосвященників і книжників народу та запитав їх, де мав народитися Христос. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Вони відповіли йому: «У Віфлеємі в Юдеї, бо ось як написано пророком: ");
INSERT INTO ukronpu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","„І ти, Віфлеєме, земле Юдина, нічим не менший серед володінь Юдиних, бо з тебе вийде Володар, Який буде пасти народ Мій, Ізраїль“». ");
INSERT INTO ukronpu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Тоді Ірод таємно покликав мудреців та довідався в них про час, коли з’явилася зірка. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","І, надіславши їх до Віфлеєма, сказав: «Ідіть та добре розвідайте про Дитя, а коли знайдете, то сповістіть мене, щоб я також прийшов та поклонився Йому». ");
INSERT INTO ukronpu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Вислухавши царя, вони пішли. І ось зірка, яку бачили на сході, ішла перед ними, доки не зупинилася над місцем, де було Дитя. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Побачивши зірку, вони дуже зраділи. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Коли увійшли в дім, побачили Дитя з Марією, Його матір’ю, і, впавши ниць, вони поклонилися Йому; потім відкрили свої скарбниці й піднесли Йому дари: золото, ладан та смирну. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","І, отримавши застереження уві сні, щоб не верталися до Ірода, вони повернулися іншою дорогою до своєї країни. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Коли ж вони пішли, ангел Господній з’явився уві сні Йосифові й сказав: «Встань, візьми Дитя та Його матір і втікай до Єгипту. Залишайся там, доки я не скажу, бо Ірод шукатиме Дитя, щоб убити Його». ");
INSERT INTO ukronpu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Йосиф піднявся вночі, узяв Дитя та Його матір і пішов до Єгипту. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Він залишався там до смерті Ірода, щоб збулося сказане Господом через пророка: «З Єгипту Я покликав Мого Сина». ");
INSERT INTO ukronpu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Коли Ірод побачив, що мудреці його обманули, то дуже розлютився й наказав повбивати у Віфлеємі та всіх його околицях усіх хлопчиків віком від двох років і менше, згідно з часом, про який дізнався від мудреців. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Тоді збулося сказане через пророка Єремію: ");
INSERT INTO ukronpu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Голос чути в Рамі, плач та ридання велике. Рахіль плаче за своїми дітьми і не хоче втішитись, бо їх немає». ");
INSERT INTO ukronpu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Після смерті Ірода ангел Господній з’явився Йосифові уві сні в Єгипті ");
INSERT INTO ukronpu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","та сказав: «Встань, візьми Дитя та Його матір та йди в землю Ізраїльську, бо вмерли ті, що бажали забрати життя Дитини». ");
INSERT INTO ukronpu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Тоді він встав, узяв Дитя та Його матір і прийшов до землі Ізраїльської. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Але, почувши, що в Юдеї царює Архелай замість свого батька Ірода, Йосиф побоявся йти туди і, попереджений уві сні, пішов у землю Галілейську. ");
INSERT INTO ukronpu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Прибувши туди, оселився в місті, яке називалося Назарет, аби збулося сказане через пророків, що Він буде названий Назарянином. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","У ті дні прийшов Іван Хреститель і проповідував у пустелі Юдеї. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Він казав: «Покайтеся, бо наблизилось Царство Небесне!» ");
INSERT INTO ukronpu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Він той, про кого було сказано через пророка Ісаю: «Голос кличе в пустелі: „Приготуйте дорогу Господеві, вирівняйте шляхи для Нього!“» ");
INSERT INTO ukronpu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Іван же мав одяг із верблюжої шерсті й шкіряний пояс довкола стегон. Його їжею була сарана та дикий мед. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Тоді приходили до нього мешканці Єрусалима, усієї Юдеї та всієї околиці Йордану ");
INSERT INTO ukronpu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","й були охрещені Іваном у річці Йордані, визнаючи свої гріхи. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Але побачивши багатьох фарисеїв та садукеїв, які приходили охреститися, він сказав їм: «Роде гадючий! Хто порадив вам тікати від гніву, що наближається? ");
INSERT INTO ukronpu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Чиніть же плоди, достойні покаяння, ");
INSERT INTO ukronpu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","і не думайте говорити в собі: „Наш батько – Авраам!“ Бо кажу вам: Бог може з цього каміння створити дітей для Авраама! ");
INSERT INTO ukronpu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Уже й сокира лежить біля коріння дерев! Кожне дерево, яке не приносить доброго плоду, зрубають та вкидають у вогонь. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Я хрещу вас водою на покаяння, але після мене йде Сильніший за мене, Якому я не достойний нести сандалії. Він буде хрестити вас Духом Святим та вогнем. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","У Його руці лопата, і Він ретельно очистить Свій тік і збере Свою пшеницю до житниці, а полову спалить у невгасимому вогні». ");
INSERT INTO ukronpu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Тоді прийшов Ісус із Галілеї до Йордану, щоб Іван охрестив Його. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Іван же стримував Його, кажучи: ―Це мені треба хреститися в Тебе, а Ти йдеш до мене? ");
INSERT INTO ukronpu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ісус відповів йому: ―Облиш тепер так, бо нам належить виконати всю праведність. Тоді Іван дозволив Йому охреститися. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Тільки-но Ісус був охрещений, Він одразу вийшов із води, і ось небеса розкрилися Йому, і Він побачив Духа Божого, Який сходив на Нього, як голуб. ");
INSERT INTO ukronpu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","І голос із неба промовив: «Це Син Мій улюблений, Якого Я вподобав!» ");
INSERT INTO ukronpu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Тоді Дух повів Ісуса в пустелю, щоб диявол спокушав Його. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Там постив сорок днів та сорок ночей, і зрештою Він зголоднів. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Тоді спокусник, підійшовши, промовив до Нього: ―Якщо Ти Син Божий, скажи, щоб ці камені стали хлібами. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ісус же у відповідь сказав: ―Написано: «Не одним тільки хлібом буде жити людина, але кожним словом, яке виходить з уст Божих». ");
INSERT INTO ukronpu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Тоді диявол узяв Його до святого міста й, поставивши на покрівлю Храму, ");
INSERT INTO ukronpu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","сказав Йому: ―Якщо ти Син Божий, кинься вниз, бо написано: «Ангелам Своїм Він віддасть наказ про Тебе, і на своїх долонях вони понесуть Тебе, щоб не спіткнулася нога Твоя об камінь». ");
INSERT INTO ukronpu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ісус відповів йому: ―Також написано: «Не спокушай Господа, Бога твого!» ");
INSERT INTO ukronpu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Знову диявол узяв Ісуса, повів на дуже високу гору й показав Йому всі царства світу та їхню славу. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","І сказав Йому: ―Усе це Тобі віддам, якщо впадеш ніц та поклонишся мені. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Тоді Ісус відповів йому: ―Відійди, сатано! Бо написано: «Господу Богу твоєму поклоняйся і Йому єдиному служи». ");
INSERT INTO ukronpu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Тоді диявол залишив Ісуса, і ось прийшли ангели та служили Йому. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Почувши, що Івана ув’язнено, Ісус повернувся до Галілеї. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","І, залишивши Назарет, пішов жити до Капернаума біля моря в околицях Завулона та Нафталі, ");
INSERT INTO ukronpu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","щоб виповнилося те, що сказано через пророка Ісаю: ");
INSERT INTO ukronpu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Земля Завулона й земля Нафталі, дорогою до моря та за Йорданом, Галілея язичників. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Народ, який сидів у темряві, побачив велике світло, і над тими, хто сидить у країні смертної тіні, засіяло світло». ");
INSERT INTO ukronpu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Відтоді Ісус почав проповідувати та казати: «Покайтеся, бо наблизилось Царство Небесне!» ");
INSERT INTO ukronpu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Коли Ісус проходив біля Галілейського моря, то побачив двох братів: Симона, якого звали Петром, та Андрія, його брата, які закидали сіті в море, оскільки були рибалками. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Він сказав їм: «Ідіть за Мною, і Я зроблю вас ловцями людей». ");
INSERT INTO ukronpu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Вони ж відразу залишили сіті та пішли за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Потім пішов далі й побачив двох інших братів: Якова, сина Зеведеєва, та Івана, його брата. Вони сиділи в човні разом зі своїм батьком Зеведеєм та лагодили сіті. Ісус покликав і їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Вони відразу залишили човен та свого батька й пішли за Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ісус ходив по всій Галілеї, навчаючи в їхніх синагогах та проповідуючи Добру Звістку Царства Небесного. Він зцілював усі хвороби та недуги в народі. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Звістка про Ісуса розійшлася по всій Сирії. До Нього приводили всіх хворих і тих, що страждали на різні недуги, а також біснуватих, епілептиків та паралізованих, і Він зціляв їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Великі натовпи з Галілеї, Десятимістя, Єрусалима, Юдеї та з-за Йордану йшли за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Побачивши натовп, Ісус зійшов на гору; коли Він сів там, Його учні підійшли до Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Тоді Він відкрив Свої уста й навчав їх, кажучи: ");
INSERT INTO ukronpu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Блаженні бідні духом, бо їхнє Царство Небесне. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Блаженні ті, що плачуть, бо вони будуть втішені. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Блаженні смиренні, бо вони успадкують землю. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Блаженні голодні та спраглі праведності, бо вони наситяться. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Блаженні милостиві, бо вони отримають милість. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Блаженні чисті серцем, бо вони побачать Бога. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Блаженні миротворці, бо вони будуть названі синами Божими. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Блаженні переслідувані за праведність, бо їхнє Царство Небесне. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Блаженні ви, коли ображатимуть та переслідуватимуть вас, і казатимуть проти вас усяку брехню та зло через Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Радійте та веселіться, бо велика ваша нагорода на небі. Так само переслідували пророків, котрі були до вас. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ви – сіль землі. Але якщо сіль втратить солоність, то чим повернути її смак? Вона вже не придатна ні до чого, хіба що викинути її на вулицю, щоб її топтали люди. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ви – світло світу. Не можна сховати міста, яке стоїть на горі. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ніхто не запалює світильник, щоб поставити його під посудину, але ставить на поставець, і він світить усім у домі. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Нехай ваше світло так світить перед людьми, щоб вони бачили ваші добрі діла та прославляли вашого Небесного Отця. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Не думайте, що Я прийшов знищити Закон або Пророків. Я прийшов не знищити, але сповнити. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Бо істинно кажу вам: доки не мине небо та земля, ні одна йота й ні одна риска Закону не мине – усе здійсниться. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Якщо хтось порушить одну з цих найменших заповідей та навчатиме так людей, той буде названий найменшим у Царстві Небесному, а хто буде виконувати заповіді та навчатиме так людей, той буде названий великим у Царстві Небесному. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Бо кажу вам: якщо ваша праведність не перевершить праведності книжників та фарисеїв, то ніяк не увійдете до Царства Небесного. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ви чули, що було сказано людям у давнину: „Не вбивай!“Якщо хтось вб’є, підлягає суду. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Але Я кажу вам: кожен, хто гнівається на свого брата, підлягає суду. І кожен, хто скаже своєму братові: „Нікчема!“ – підлягає суду Синедріона. А той, хто скаже: „Дурень!“ – підлягає вогню Геєни. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Тому якщо навіть приносиш свій дар до жертовника й там згадаєш, що твій брат має щось проти тебе, ");
INSERT INTO ukronpu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","залиши свій дар там, перед жертовником, та йди спочатку примирися зі своїм братом, а потім прийди та принеси свій дар. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Примирися швидко зі своїм супротивником, поки ти з ним у дорозі, щоби противник не віддав тебе судді, а суддя – помічнику, і той не кинув тебе до в’язниці. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Істинно кажу тобі: не вийдеш звідти, поки не заплатиш усе до останнього кодранта. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ви чули, що було сказано: „Не чини перелюбу!“. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Але Я кажу вам: кожен, хто дивиться на жінку з пожадливістю, уже вчинив перелюб у своєму серці. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Якщо твоє праве око спокушає тебе, вирви його та викинь від себе. Бо краще для тебе втратити одну з частин твого тіла, аніж щоб усе тіло було кинуте в Геєну. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","І якщо твоя права рука спокушає тебе, відрубай її та викинь від себе. Бо краще втратити одну з частин твого тіла, аніж щоб усе тіло йшло до Геєни. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Було сказано: „Хто розлучається зі своєю дружиною, нехай дасть їй лист про розлучення“. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Але Я кажу вам: кожен, хто розлучається зі своєю дружиною, – за винятком статевої розпусти, – той штовхає її до перелюбу. І той, хто одружується з розлученою, чинить перелюб. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ви чули також, що було сказано людям у давнину: „Не клянись неправдиво, а виконуй перед Господом свої обітниці“. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Але Я кажу вам: не кляніться взагалі, ні небом, бо воно є Божим престолом, ");
INSERT INTO ukronpu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ні землею, бо вона є підніжжям Його ніг, ні Єрусалимом, бо це місто великого Царя. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Не кляніться й своєю головою, бо не можете жодної волосини зробити білою або чорною. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Слово ж ваше нехай буде: так – так, ні – ні. А все, що більше за це, – від лукавого. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ви чули, що було сказано: „Око за око і зуб за зуб“. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Але Я кажу вам: не противтеся злу. Якщо хтось вдарить тебе по правій щоці, підстав і другу. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","І тому, хто судиться з тобою, щоб забрати сорочку, віддай і свій верхній одяг. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","І коли хтось примусить тебе йти з ним милю, ти йди з ним дві. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Тому, хто просить у тебе, дай, і від того, хто бажає позичити в тебе, не відвертайся. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ви чули, що було сказано: „Люби ближнього свого та ненавидь свого ворога“. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Але Я кажу вам: любіть ворогів ваших, благословляйте тих, хто вас проклинає, робіть добро тим, хто ненавидить вас, і моліться за тих, хто кривдить та переслідує вас, ");
INSERT INTO ukronpu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","щоб ви були синами вашого Небесного Отця. Адже Він наказує Своєму сонцю сходити над злими й над добрими та посилає дощ на праведних і на неправедних. ");
INSERT INTO ukronpu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Якщо ви любите тільки тих, хто любить вас, яку нагороду маєте? Хіба митники не так само роблять? ");
INSERT INTO ukronpu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","І якщо ви вітаєте тільки ваших братів, що незвичайного робите? Хіба так не роблять і язичники? ");
INSERT INTO ukronpu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Отже, будьте досконалі, як і Отець ваш Небесний є досконалим. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Стережіться: не чиніть вашої праведностіперед людьми, щоб вони вас бачили. Бо не будете мати жодної винагороди від вашого Небесного Отця. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Отже, коли даєш милостиню, не сурми перед собою, як це роблять лицеміри в синагогах та на вулицях, щоб їх прославляли люди. Істинно кажу вам: вони вже отримують свою винагороду. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Коли ж ти даєш милостиню, нехай твоя ліва рука не знає, що робить права, ");
INSERT INTO ukronpu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","щоб твоя милостиня була таємна. Тоді твій Отець, Який бачить таємне, віддасть тобі явно. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Коли молитесь, не будьте як лицеміри, які люблять стояти й молитися в синагогах та на перехрестях вулиць, щоб їх бачили люди. Істинно кажу вам: вони вже отримують свою винагороду. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ти ж, коли молишся, увійди у свою кімнату та, зачинивши двері, помолися твоєму Отцю таємно. Тоді твій Отець, Який бачить таємне, віддасть тобі явно. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Коли молитесь, не говоріть багато, як язичники, які думають, що завдяки своїй багатослівності будуть вислухані. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Тож не будьте схожими на них, бо Отець ваш знає, які ви маєте потреби, перш ніж ви попросите в Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Тому моліться так: „Отче наш, Що на небесах, нехай святиться ім’я Твоє! ");
INSERT INTO ukronpu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Нехай прийде Царство Твоє! Нехай буде воля Твоя, як на небі, так і на землі! ");
INSERT INTO ukronpu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Хліб наш щоденний дай нам сьогодні. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","І прости нам провини наші, як і ми прощаємо винуватцям нашим. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","І не введи нас у спокусу, але визволи нас від лукавого. Бо Твоє є Царство, і сила, і слава навіки. Амінь!“ ");
INSERT INTO ukronpu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Якщо будете прощати людям їхні провини, то й Отець ваш Небесний простить вам. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Якщо ж ви не будете прощати людям, й Отець Небесний не простить провин ваших. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Коли ви постите, не будьте, як лицеміри, які сумують та виснажують свої обличчя, щоб показати людям, що вони постять. Істинно кажу вам: вони вже отримують свою винагороду. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ти ж, коли постиш, намасти свою голову та вмий своє обличчя, ");
INSERT INTO ukronpu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","щоб твій піст показувати не людям, а лише Отцеві, Який бачить таємне. І твій Отець, Який бачить таємне, віддасть тобі. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Не збирайте собі скарбів на землі, де міль та іржа нищать їх і де злодії підкопують та крадуть їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Натомість збирайте собі скарби на небі, де ані міль, ані іржа не нищать їх і де злодії не підкопують і не крадуть їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Бо де скарб твій, там буде й твоє серце. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Світлом для тіла є око. Тому якщо твоє око буде здорове, то все твоє тіло буде наповнене світлом. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Але якщо твоє око буде лихе, то й все тіло буде в темряві. Отже, якщо світло, яке в тобі, – це темрява, то наскільки ж велика ця темрява! ");
INSERT INTO ukronpu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ніхто не може служити двом господарям, бо одного ненавидітиме, а другого любитиме, або одним буде нехтувати, а іншому буде відданим. Не можете служити Богові та багатству. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Тому Я кажу вам: не турбуйтеся про життя ваше – що будете їсти чи що будете пити, ні про тіло ваше – що будете вдягати. Хіба життя не більше за їжу, а тіло – за одяг? ");
INSERT INTO ukronpu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Подивіться на птахів небесних: вони не сіють, не жнуть і не збирають у сховище, і все ж ваш Небесний Отець їх годує. Наскільки ж ви цінніші за них? ");
INSERT INTO ukronpu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","І хто з вас, турбуючись, може додати до свого зросту хоч один лікоть? ");
INSERT INTO ukronpu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Чому турбуєтеся про одяг? Подивіться на польові лілії, як вони ростуть: не працюють і не прядуть. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Та Я кажу вам: навіть Соломон у всій своїй величі не одягався так, як будь-яка з них. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Якщо ж Бог польову траву, котра сьогодні є, а завтра буде кинута у вогонь, так одягає, хіба не краще Він одягне вас, маловіри? ");
INSERT INTO ukronpu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Не турбуйтеся кажучи: „Що ми будемо їсти?“, або: „Що ми будемо пити?“, чи: „У що зодягнемось?“ ");
INSERT INTO ukronpu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Бо все це язичники шукають, але ваш Небесний Отець знає, що потребуєте цього. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Шукайте найперше Царства Божого й праведності Його, а все це додасться вам. ");
INSERT INTO ukronpu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Не турбуйтеся про завтрашній день, бо завтрашній день турбуватиметься про себе сам. Вистачає дневі своєї турботи. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Не судіть, щоб і вас не судили. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Бо яким судом судите, таким і вас судитимуть. І якою мірою міряєте ви, такою і вам виміряють. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Чому ж ти дивишся на скалку в оці твого брата, а колоди у своєму оці не помічаєш? ");
INSERT INTO ukronpu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Або як скажеш братові своєму: „Дозволь вийняти скалку з твого ока“, коли он колода у твоєму оці. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Лицеміре, витягни спочатку колоду зі свого ока, а тоді побачиш, як вийняти скалку з ока твого брата. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Не давайте святого псам і не кидайте перлин ваших перед свинями, щоб вони не потоптали їх ногами своїми й, обернувшись, не розірвали вас. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Просіть – і буде дано вам, шукайте – і знайдете, стукайте – і відчинять вам. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Бо кожен, хто просить, отримує, і хто шукає, знаходить, і тому, хто стукає, відчинять. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Чи є між вами людина, яка, коли її син просить хліба, подасть йому камінь? ");
INSERT INTO ukronpu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","І коли попросить риби, чи подасть йому гадюку? ");
INSERT INTO ukronpu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Отже, якщо ви, будучи злими, вмієте давати добрі дари вашим дітям, то наскільки більше ваш Отець Небесний дасть добра тим, хто просить у Нього? ");
INSERT INTO ukronpu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Отже, усе, чого бажаєте, щоб вам робили люди, так само й ви робіть їм, бо в цьому Закон та Пророки. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Входіть через вузькі ворота, бо широкі ті ворота й широка та дорога, які ведуть до загибелі, і багато є тих, хто входить ними. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Але вузькі ті ворота й вузька та дорога, які ведуть до життя, і мало тих, хто знаходить їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Стережіться лжепророків, які приходять до вас в овечих шкурах, а всередині вони – хижі вовки. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","За їхніми плодами впізнаєте їх. Хіба збирають виноград із терну чи смокву з будяків? ");
INSERT INTO ukronpu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Так, усяке добре дерево приносить добрий плід, а всяке погане дерево приносить поганий плід. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Не може добре дерево приносити поганий плід ані погане дерево приносити добрий плід. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Кожне дерево, яке не приносить доброго плоду, зрубують і кидають у вогонь. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Отже, за їхніми плодами впізнаєте їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Не кожен, хто говорить Мені: „Господи! Господи!“, увійде до Царства Небесного, а лише той, хто виконує волю Мого Небесного Отця. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Багато хто буде казати Мені того дня: „Господи! Господи! Чи не Твоїм ім’ям ми пророкували? Чи не Твоїм ім’ям виганяли демонів? І чи не Твоїм ім’ям робили багато чудес?“ ");
INSERT INTO ukronpu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Тоді скажу їм: „Я ніколи не знав вас! Відійдіть від Мене ви, що чините беззаконня!“ ");
INSERT INTO ukronpu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Кожен, хто чує ці Мої слова й виконує їх, схожий на чоловіка розумного, який збудував свій дім на камені. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Коли пішов дощ, ринули ріки, здійнялися вітри й вдарили в дім той, він не впав, бо мав основу на камені. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","А кожен, хто чує ці Мої слова й не виконує їх, схожий на чоловіка нерозумного, який збудував свій дім на піску. ");
INSERT INTO ukronpu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Коли пішов дощ, ринули ріки, здійнялися вітри й вдарили в дім той, він впав, і його падіння було велике». ");
INSERT INTO ukronpu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Коли Ісус закінчив промовляти ці слова, люди дивувалися Його вченню, ");
INSERT INTO ukronpu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","бо Він навчав їх як Той, Хто має владу, а не як їхні книжники. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Коли Ісус зійшов з гори, багато людей пішло за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","І ось один прокажений прийшов, поклонився Йому й промовив: ―Господи, якщо хочеш, Ти можеш мене очистити. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ісус простягнув руку, доторкнувся до нього й промовив: ―Хочу, будь чистим! І вмить чоловік очистився від прокази. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ісус сказав йому: ―Дивись, нікому не кажи про це, але йди, покажи себе священникові та принеси дар, який наказав Мойсей, їм на свідчення. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Коли ж Ісус увійшов до Капернаума, прийшов до Нього сотник, який просив Його, ");
INSERT INTO ukronpu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","кажучи: ―Господи, мій слуга лежить вдома паралізований і тяжко страждає. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ісус сказав йому: ―Я прийду та зцілю його. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Але сотник відповів: ―Господи, я не достойний, щоб Ти увійшов під мій дах, але скажи лише слово, і одужає мій слуга. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Бо і я людина підвладна й маю під своєю владою воїнів. Кажу одному: «Іди!» – і він іде, а іншому: «Прийди!» – і він приходить, і рабу моєму: «Зроби це!» – і він робить. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Почувши це, Ісус здивувався та промовив тим, що йшли за Ним: ―Істинно кажу вам: ні в кого в Ізраїлі Я не знайшов такої великої віри. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Кажу ж вам: багато хто прийде зі сходу та заходу і сядуть за стіл разом з Авраамом, Ісааком та Яковом у Царстві Небесному. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","А сини Царства будуть викинуті геть у темряву, де буде плач та скрегіт зубів. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","А сотникові Ісус сказав: ―Іди! Нехай станеться за твоєю вірою! І тієї ж миті його слуга одужав. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Прийшовши в дім Петра, Ісус побачив, що його теща лежить у гарячці. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Він доторкнувся до її руки – і гарячка залишила жінку. Вона встала та почала прислуговувати Йому. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Коли ж настав вечір, привели до Нього багатьох біснуватих. Він словом виганяв духів та зцілив усіх хворих на різні недуги, ");
INSERT INTO ukronpu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","щоб сповнились слова, сказані через пророка Ісаю: «Він узяв на Себе наші хвороби і поніс наші недуги». ");
INSERT INTO ukronpu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Побачивши навколо Себе багато народу, Ісус наказав учням відплисти на другий бік моря. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Тоді підійшов до Нього один книжник і сказав: ―Учителю, я піду за Тобою, куди б Ти не пішов! ");
INSERT INTO ukronpu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ісус відповів йому: ―Лисиці мають нори, птахи небесні – гнізда, а Син Людський не має, де голову прихилити. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","А інший з Його учнів сказав: ―Господи, дозволь мені спочатку піти та поховати мого батька! ");
INSERT INTO ukronpu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Але Ісус відповів: ―Іди за Мною й залиши мертвим ховати своїх мерців. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Потім Ісус зайшов у човен, за Ним увійшли і Його учні. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","І ось здійнялась на морі велика буря, так що хвилі заливали човен, а Він спав. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Учні підійшли й розбудили Його, кажучи: ―Господи, спаси нас, бо ми гинемо! ");
INSERT INTO ukronpu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Він сказав їм: ―Чому ви злякалися, маловіри? Тоді, піднявшись, наказав вітрам та морю, і настала велика тиша. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Люди дивувалися кажучи: ―Хто ж Він такий, що вітри та море підкоряються Йому? ");
INSERT INTO ukronpu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Коли Ісус прийшов на другий берег моря, у землю Гадаринську, Його зустріли двоє біснуватих, що вийшли з гробниць. Вони були дуже люті, так що ніхто не міг пройти тією дорогою. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","І ось вони закричали: ―Що Тобі до нас, Сину Божий? Ти прийшов сюди, щоб мучити нас завчасно? ");
INSERT INTO ukronpu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Неподалік від них паслося велике стадо свиней. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Демони просили Ісуса, кажучи: ―Якщо виганяєш нас, то надішли нас у це стадо свиней. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Він сказав їм: ―Ідіть! Тоді, вийшовши, вони увійшли у свиней, і ось стадо кинулося з кручі в море й потонуло у воді. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Свинопаси побігли й, діставшись до міста, сповістили про все, а також про біснуватих. ");
INSERT INTO ukronpu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","І ось усе місто вийшло Ісусові назустріч і, побачивши Його, благали, щоб Він залишив їхні околиці. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ісус сів у човен та, перепливши море, прибув до Свого міста. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","І ось до Нього принесли паралізованого, що лежав на носилках. Побачивши їхню віру, Ісус сказав паралізованому: «Не бійся, сину! Прощаються тобі гріхи твої!» ");
INSERT INTO ukronpu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Але деякі книжники почали говорити між собою: «Він богохульствує!» ");
INSERT INTO ukronpu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Тоді Ісус, знаючи їхні думки, сказав: «Чому ви думаєте погано у ваших серцях? ");
INSERT INTO ukronpu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Що легше сказати: „Прощаються твої гріхи!“ чи „Встань і ходи!“? ");
INSERT INTO ukronpu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Але щоб ви знали: Син Людський має владу на землі прощати гріхи». Тоді сказав паралізованому: «Встань, візьми свою постіль та йди додому!» ");
INSERT INTO ukronpu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","І, вставши, чоловік пішов додому. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Побачивши це, натовп злякався й почав прославляти Бога, Який дав людям таку владу. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Коли Ісус повертався звідти, то побачив чоловіка, на ім’я Матвій, що сидів при збиранні мита, і сказав йому: «Іди за Мною!» Той, вставши, пішов за Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","І коли Ісус сидів за столом у домі Матвія, то прийшло багато митників та грішників і їли разом з Ісусом та Його учнями. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Побачивши це, фарисеї сказали Його учням: ―Чому ваш Учитель їсть разом із митниками й грішниками? ");
INSERT INTO ukronpu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ісус же, почувши це, відповів: ―Не здорові потребують лікаря, а хворі. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ідіть же й навчіться, що значить: «Милосердя хочу, а не жертви».Бо Я прийшов покликати до покаяння не праведних, а грішників. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Тоді прийшли до Нього Іванові учні й запитали: ―Чому ми та фарисеї багато постимо, а Твої учні не постять? ");
INSERT INTO ukronpu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ісус відповів: ―Чи можете друзів нареченого змусити постити, доки наречений з ними? Але настануть дні, коли наречений забереться від них, і тоді поститимуть. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ніхто ж не пришиває латки з нової тканини до старої одежі, бо латка з неї збіжиться та відірве з одежі, і діра стає ще більшою. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ніхто не наливає молодого вина в старі бурдюки, адже бурдюки розірвуться – і вино виллється, а бурдюки пропадуть. Молоде вино вливають у нові бурдюки – і збережеться й одне, і друге. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Коли Ісус казав їм це, ось прийшов один із керівників синагоги, вклонився Йому та сказав: «Моя донька тільки що померла, але прийди та поклади на неї Свою руку – і вона оживе». ");
INSERT INTO ukronpu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Піднявшись, Ісус з учнями пішли за ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","І ось одна жінка, яка дванадцять років страждала на кровотечу, підійшовши ззаду, доторкнулася до краю Його одежі, ");
INSERT INTO ukronpu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","бо вона говорила сама собі: «Якщо хоч доторкнуся до Його одежі, то одужаю!». ");
INSERT INTO ukronpu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ісус же, повернувшись, побачив її та сказав: «Не бійся, донько! Твоя віра врятувала тебе». І жінка одразу була зцілена. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Коли Ісус прийшов у дім керівника синагоги, то побачив там сопілкарів та засмучених людей. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Він сказав їм: «Вийдіть, бо дівчинка не померла, а спить». Але вони почали глузувати з Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Коли ж натовп вивели, Ісус зайшов до кімнати, узяв дівчинку за руку, і вона встала. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Звістка про це розійшлася по всій тій країні. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Коли Ісус вийшов звідти, за Ним пішли двоє сліпих, які кричали: ―Змилуйся над нами, Сину Давидів! ");
INSERT INTO ukronpu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Коли ж Він увійшов у дім, сліпі підійшли до Нього, і Ісус запитав їх: ―Вірите, що Я можу це зробити? ―Так, Господи, – відповіли вони. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Тоді Він доторкнувся до їхніх очей, кажучи: ―За вірою вашою нехай станеться вам! ");
INSERT INTO ukronpu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","І їхні очі відкрилися. Ісус же суворо застеріг їх, кажучи: ―Дивіться, щоб ніхто не довідався! ");
INSERT INTO ukronpu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Але вони, вийшовши, розповідали про Нього всюди по тій країні. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Коли ж вони виходили, то ось привели до Нього німого чоловіка, який був біснуватим. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Як тільки демон вийшов, німий чоловік заговорив; і весь натовп дивувався кажучи: «Ніколи такого не траплялося в Ізраїлі». ");
INSERT INTO ukronpu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Але фарисеї казали: «Він виганяє демонів силою володаря демонів». ");
INSERT INTO ukronpu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ісус ходив через усі міста та села й навчав у їхніх синагогах, проповідуючи Добру Звістку Царства Небесного. Він зцілював усі хвороби та недуги. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Побачивши людей, Ісус змилосердився над ними, тому що вони були втомлені та безпорадні, як вівці, що не мають пастуха. ");
INSERT INTO ukronpu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Тоді Він промовив до своїх учнів: «Жнива насправді великі, а робітників мало, ");
INSERT INTO ukronpu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","тож просіть Господа жнив, щоб послав робітників на жнива Свої». ");
INSERT INTO ukronpu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Покликавши дванадцятьох Своїх учнів, Ісус дав їм владу виганяти нечистих духів та зцілювати всі хвороби й усі недуги. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ось імена дванадцятьох апостолів: перший – Симон, якого назвав Петром, та Андрій, його брат, Яків, син Зеведеїв, і Іван, його брат, ");
INSERT INTO ukronpu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Филип і Варфоломій, Фома і митник Матвій, Яків, син Алфеїв, і Тадей, ");
INSERT INTO ukronpu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Симон Кананит і Юда Іскаріот, який зрадив Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Цих дванадцятьох Ісус надіслав та наказав їм: «На дорогу язичників не йдіть і в міста самарянські не входіть. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","А йдіть краще до загублених овець дому Ізраїля. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ідіть та проповідуйте кажучи: „Наблизилось Царство Небесне“. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Хворих зцілюйте, мертвих воскрешайте, прокажених очищайте, демонів виганяйте. Даром отримали – даром давайте. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Не беріть ні золота, ні срібла, ні грошей до поясів своїх, ");
INSERT INTO ukronpu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ні торбини в дорогу, ні двох сорочок, ні взуття, ні палиці, бо робітник достойний своєї їжі. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","А коли увійдете в якесь місто чи село, дізнайтеся, хто в ньому достойний, і залишайтеся в нього, поки не вийдете. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Зайшовши в дім, привітайте його, кажучи: „Мир цьому дому!“ ");
INSERT INTO ukronpu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","І якщо той дім дійсно достойний, мир ваш зійде на нього. Якщо ж недостойний, ваш мир повернеться до вас. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","А якщо хтось не прийме вас і не послухає ваших слів, то, виходячи з того дому або з того міста, обтрусіть пил зі своїх ніг. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Істинно кажу вам: легше буде землі Содомській і Гоморрській у день суду, ніж тому місту. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ось Я посилаю вас, як овець поміж вовків. Тому будьте мудрі, як змії, та невинні, як голуби. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Стережіться людей, бо вони віддаватимуть вас до судів і у своїх синагогах битимуть вас. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Поведуть вас до правителів та царів заради Мене, на свідчення їм та язичникам. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Коли видаватимуть вас, не турбуйтеся, як і що казати, бо дано буде вам у той час, що казати: ");
INSERT INTO ukronpu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","не ви будете говорити, а Дух Отця вашого промовлятиме через вас. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Брат видасть на смерть брата, а батько – дитину. Повстануть діти проти батьків та вбиватимуть їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","І всі будуть ненавидіти вас через ім’я Моє. Але хто витримає до кінця, той буде спасенний. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Коли ж будуть вас переслідувати у цьому місті, тікайте до іншого. Істинно кажу вам: ви не закінчите обходити всі міста Ізраїлю, як прийде Син Людський. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Учень не вищий за свого вчителя, а раб не вищий за свого господаря. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Достатньо учневі стати, як його вчитель, і рабу стати, як його господар. Якщо господаря дому назвали Вельзевулом, то наскільки більше називатимуть так Його домашніх. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Не бійтеся їх, бо немає нічого захованого, що не відкрилося б, і нічого таємного, що не стало б відомим. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Те, що Я кажу вам у темряві, говоріть при світлі, і те, що чуєте на вухо, проповідуйте з дахів. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Не бійтеся тих, хто, вбиваючи тіло, не може вбити душі. Бійтеся більше Того, Хто може і душу, і тіло знищити в Геєні. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Хіба два горобці не продаються за асарій? Однак жоден із них не впаде на землю без відома Отця вашого. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","У вас же на голові навіть волосся пораховане. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Отже, не бійтеся: ви набагато цінніші за горобців. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Кожного, хто визнає Мене перед людьми, і Я визнаю перед Моїм Небесним Отцем. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Але кожного, хто зречеться Мене перед людьми, зрікусь і Я перед Моїм Небесним Отцем. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Не думайте, що Я прийшов принести мир на землю. Я прийшов принести не мир, а меч. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Адже Я прийшов, аби підняти „сина проти його батька, доньку проти її матері, невістку проти її свекрухи, ");
INSERT INTO ukronpu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","і ворогами людини будуть її домашні“. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Хто любитиме свого батька та матір більше, ніж Мене, той не достойний Мене, і хто любитиме сина або доньку більше, ніж Мене, той не достойний Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","І хто не бере хреста свого й не йде за Мною, той не достойний Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Хто зберігає життя своє, той втратить його, а хто втратить його заради Мене, знайде його. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Хто приймає вас, Мене приймає, а хто приймає Мене, приймає Того, Хто надіслав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Хто приймає пророка в ім’я пророка, отримає винагороду пророка, і хто приймає праведника в ім’я праведника, отримає винагороду праведника. ");
INSERT INTO ukronpu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","І хто дасть тільки чашу холодної води одному з цих малих в ім’я учня, – істинно кажу вам, – не втратить своєї винагороди». ");
INSERT INTO ukronpu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Коли Ісус закінчив навчати дванадцятьох Своїх учнів, то пішов звідти навчати та проповідувати в їхніх містах. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Іван, почувши у в’язниці про діла Христові, надіслав своїх учнів ");
INSERT INTO ukronpu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","спитати Його: ―Ти Той, Хто має прийти, чи нам чекати іншого? ");
INSERT INTO ukronpu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ісус у відповідь сказав: ―Ідіть і скажіть Іванові те, що ви бачите й чуєте: ");
INSERT INTO ukronpu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","сліпі прозрівають, каліки ходять, прокажені очищаються, глухі чують, мертві оживають, а бідним проповідується Добра Звістка. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","І блаженний той, хто не спокуситься через Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Коли ж вони пішли, Ісус почав говорити людям про Івана: «На що ви ходили подивитися в пустелю? На тростину, розхитану вітром? ");
INSERT INTO ukronpu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","На кого ви виходили дивитись? На людину в м’якій одежі? Але ті, що носять м’які одежі, знаходяться в царських палацах. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","То на кого ж ви ходили дивитись? На пророка? Так, Я кажу вам, навіть більше, ніж на пророка. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Він той, про кого написано: „Ось Я посилаю Мого посланця перед обличчям Твоїм, який приготує дорогу перед Тобою“. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Істинно кажу вам: серед народжених жінками ще не було більшого за Івана Хрестителя, але найменший у Царстві Небесному більший за нього. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Від днів Івана Хрестителя й донині Царство Небесне здобувається силою, і хто докладає зусиль, той здобуває його. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Адже всі Пророки та Закон пророкували до Івана. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","І якщо хочете знати, він – Ілля, який має прийти. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Хто має вуха, нехай слухає! ");
INSERT INTO ukronpu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Із ким же Мені порівняти цей рід? Він подібний до дітей, котрі сидять на базарі та, звертаючись до інших, ");
INSERT INTO ukronpu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","кажуть: „Ми грали вам на сопілці, а ви не танцювали. Ми співали вам жалібні пісні, а ви не ридали“. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Прийшов Іван, який не їсть і не п’є, а вони кажуть: „Має демона!“ ");
INSERT INTO ukronpu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Прийшов Син Людський, Який їсть і п’є, а вони кажуть: „Ось чоловік – ненажера й п’яниця, приятель митників та грішників“. Однак мудрість виправдана її власними ділами». ");
INSERT INTO ukronpu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Тоді Ісус почав докоряти містам, у яких сталося найбільше Його чудес, бо вони не покаялись: ");
INSERT INTO ukronpu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Горе тобі, Хоразине! Горе тобі, Віфсаїдо! Бо якби в Тирі та Сидоні сталися ті чудеса, які були у вас, то вони давно би покаялися в мішковині та попелі. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Проте кажу вам: Тиру та Сидону легше буде в день суду, ніж вам. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","І ти, Капернауме, чи будеш піднесений до неба? Ні, ти до пекла зійдеш! Коли б у Содомі сталися чудеса, які сталися в тебе, він залишився б донині. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Проте кажу вам: землі Содомській легше буде в день суду, ніж тобі». ");
INSERT INTO ukronpu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","У той час Ісус промовив у відповідь: «Славлю Тебе, Отче, Господи неба і землі, за те, що Ти приховав це від мудрих та розумних і відкрив дітям. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Так, Отче, бо такою була Твоя добра воля. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Усе Мені було доручено Моїм Отцем. Ніхто не знає Сина, окрім Отця, і ніхто не знає Отця, окрім Сина й того, кому Син хоче відкрити. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Прийдіть до Мене всі втомлені та обтяжені, і Я заспокою вас. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Візьміть на себе Моє ярмо й навчіться від Мене, бо Я лагідний та покірний серцем, і знайдете спокій вашим душам. ");
INSERT INTO ukronpu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Бо ярмо Моє добре і тягар Мій легкий». ");
INSERT INTO ukronpu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","У той час Ісус проходив у Суботу через засіяні поля пшениці. Його учні зголодніли й почали зривати колосся та їсти. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Фарисеї ж, побачивши це, сказали Йому: ―Ось Твої учні роблять те, чого не дозволено робити в Суботу! ");
INSERT INTO ukronpu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Тоді Він сказав їм: ―Ви не читали, що зробив Давид,коли зголоднів він, а також і ті, що були з ним? ");
INSERT INTO ukronpu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Як увійшов у Дім Божий та з’їв хліби покладання, котрі не дозволено було їсти ані йому, ані тим, хто був із ним, а тільки священникам? ");
INSERT INTO ukronpu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Або хіба ви не читали в Законі, що в Суботу в Храмі священники порушують Суботу й залишаються невинними? ");
INSERT INTO ukronpu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Але Я кажу вам: тут щось більше, ніж Храм. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Якби ви зрозуміли, що означає: «Милосердя хочу, а не жертви», то не засуджували б невинних. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Бо Син Людський – Господь Суботи. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Вирушивши далі, Він зайшов у їхню синагогу. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Там був чоловік із всохлою рукою. І щоб звинуватити Його, вони запитали: ―Чи дозволено зцілювати в Суботу? ");
INSERT INTO ukronpu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Він же промовив: ―Хто з вас, маючи одну вівцю, якщо вона впаде в Суботу в яму, не візьме й не витягне її? ");
INSERT INTO ukronpu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Наскільки ж людина цінніша за вівцю! Тому в Суботу дозволено робити добро. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Тоді сказав чоловікові: ―Простягни свою руку! Той простягнув, і його рука стала здоровою, як і друга. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Фарисеї ж вийшли та радились проти Нього, як Його вбити. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Дізнавшись про це, Ісус пішов звідти. За Ним пішло багато людей, і Він зцілив їх усіх. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Однак наказав їм, щоб не виявляли Його, ");
INSERT INTO ukronpu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","аби збулося сказане через пророка Ісаю: ");
INSERT INTO ukronpu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ось Слуга Мій, Якого Я обрав, Мій Улюблений, Якого вподобала душа Моя. Я покладу Духа Мого на Нього, і Він звіщатиме суд народам. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Він не буде ні сперечатися, ні кричати, і ніхто не почує Його голосу на вулицях. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Надломленої тростини Він не доламає, ґнота світильника, що тліє, не загасить, доки не встановить правосуддя. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","І на Його ім’я покладатимуть надію народи». ");
INSERT INTO ukronpu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Тоді привели до Нього біснуватого – сліпого та німого. Ісус зцілив його, так що німий говорив та бачив. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Усі люди дивувались та говорили: ―Чи це не Син Давидів? ");
INSERT INTO ukronpu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Але фарисеї, почувши це, казали: ―Він виганяє демонів не інакше, як силою Вельзевула, володаря демонів. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ісус же, знаючи їхні думки, відповів: ―Кожне царство, розділене в собі, буде спустошене, і кожне місто чи дім, розділені в собі, не встоять. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Якщо сатана виганяє сатану, то він розділився в собі самому. Як же тоді встоїть його царство? ");
INSERT INTO ukronpu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","І якщо Я виганяю демонів Вельзевулом, то ким виганяють ваші сини? Тому вони будуть вашими суддями. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Але якщо Я Духом Божим виганяю демонів, то прийшло до вас Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Або як може хтось увійти в дім сильного та забрати його майно, якщо спочатку не зв’яже сильного? Лише тоді пограбує його дім. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Хто не зі Мною, той проти Мене; і хто не збирає зі Мною, той розкидає. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Тому кажу вам: усякий гріх та богохульство проститься людям, але богохульство проти Духа не проститься. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","І якщо хтось скаже слово проти Сина Людського, йому проститься, але якщо хтось скаже проти Святого Духа, не проститься йому ні в цьому віці, ні в майбутньому. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Або визнайте дерево добрим і плід його добрим, або визнайте дерево поганим і плід його поганим.Бо дерево пізнається за плодом. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Роде гадючий, як ви можете казати добре, будучи злими? Адже чим переповнене серце, те говорять вуста. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Добра людина з доброї скарбниці виносить добро, а погана людина з лихого скарбу виносить зло. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Кажу вам: за кожне пусте слово, яке скажуть люди, вони відповідатимуть у день суду. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Бо з твоїх слів будеш виправданий і з твоїх слів будеш засуджений. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Тоді деякі книжники та фарисеї промовили: ―Учителю, ми хочемо побачити якесь знамення від Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ісус у відповідь промовив: ―Рід лукавий та невірний шукає знамення, та не дасться йому знамення, хіба що тільки знамення пророка Йони. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Адже так, як Йонабув у череві кита три дні та три ночі, так буде й Син Людський у серці землі три дні та три ночі. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Люди Ніневіївстануть на суд із цим родом і засудять його, бо вони покаялись через проповідь Йони, а ось тут Хтось більший за Йону. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Цариця Півднявстане на суд із цим родом і засудить його, бо вона прийшла з далекого краю землі послухати Соломонову мудрість, а ось тут Хтось більший за Соломона. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Коли нечистий дух виходить із людини, то йде в місця безводні шукати відпочинку й, не знаходячи, ");
INSERT INTO ukronpu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","каже: «Повернусь я у дім свій, звідки вийшов». І, повернувшись, знаходить його порожнім, заметеним та прибраним. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Тоді він іде й бере з собою інших сімох духів, гірших за себе, і входять та живуть там. І для людини останнє стає гіршим за попереднє. Так буде і з цим злим родом. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Коли Ісус ще говорив до народу, прийшли Його мати та брати і, стоячи надворі, бажали говорити з Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Хтось сказав Йому: ―Ось Твоя мати й Твої брати стоять надворі, бажаючи говорити з Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Він же у відповідь сказав тому, хто говорив: ―Хто Моя мати і хто Мої брати? ");
INSERT INTO ukronpu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","І, показавши рукою на Своїх учнів, промовив: ―Ось Моя мати та Мої брати. ");
INSERT INTO ukronpu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Бо той, хто виконує волю Мого Небесного Отця, є Моїм братом, сестрою і матір’ю. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Того ж дня Ісус, вийшовши з дому, сидів на березі моря. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","І зібрався біля Нього великий натовп, так що Він зайшов у човен та сів, а всі люди стояли на березі. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Він багато навчав їх притчами, кажучи: «Ось сіяч вийшов сіяти. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Коли він сіяв, деякі зерна впали біля дороги; птахи, налетівши, повидзьобували їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Інші впали на кам’янистий ґрунт, де не було багато землі, і відразу проросли, бо земля була неглибока. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Коли ж зійшло сонце, то опалило паростки, вони зів’яли й, не маючи коріння, всохли. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ще інші впали поміж терни. Терни виросли та заглушили їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","А інші впали в добру землю та дали врожай: одні в сто, інші в шістдесят, треті в тридцять разів більше. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Хто має вуха, нехай слухає!» ");
INSERT INTO ukronpu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Підійшовши, учні запитали Його: ―Чому Ти говориш до них притчами? ");
INSERT INTO ukronpu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Він же у відповідь сказав: ―Бо вам дано пізнати таємниці Царства Небесного, а їм не дано. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Адже тому, хто має, додасться, і матиме надмірно, а від того, хто не має, і те, що має, забереться. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Тому до них Я говорю притчами, бо вони, «дивлячись, не бачать, а слухаючи, не чують і не розуміють». ");
INSERT INTO ukronpu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Щодо них збувається пророцтво Ісаї, що каже: «Ви будете слухати й слухати, але ніколи не зрозумієте; будете дивитись і дивитись, але ніколи не побачите. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Бо серце цього народу згрубіло, важко стали чути вухами й очі свої заплющили, щоб не побачити очима, не почути вухами, не зрозуміти серцем і не навернутись, щоб Я зцілив їх». ");
INSERT INTO ukronpu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Блаженні очі, які бачать, і вуха, які чують. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Істинно кажу вам: багато пророків та праведників бажали побачити те, що ви бачите, і не побачили, та почути те, що ви чуєте, і не почули. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Отже, послухайте, що означає притча про сіяча. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","До кожного, хто слухає Слово про Царство й не розуміє його, приходить лукавий і викрадає посіяне в його серці. Це те, що посіяне біля дороги. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Посіяне ж на кам’янисту землю – це той, хто, почувши Слово, відразу з радістю приймає його. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Але він не має коріння в собі, є тимчасовим. Коли настають труднощі або гоніння за Слово, він відразу відпадає. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Посіяне серед тернів – це ті, що чують Слово, але турботи цього віку й омана багатства придушують Слово, і воно залишається безплідним. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","А посіяне в добру землю – це той, хто чує та розуміє Слово. Він насправді приносить врожай: у сто, у шістдесят або в тридцять разів більший. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ісус розповів їм іншу притчу: «Царство Небесне подібне до чоловіка, який посіяв добре насіння на своєму полі. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Але коли чоловік спав, прийшов його ворог, посіяв кукіль серед пшениці та пішов. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","А як зійшло посіяне та показався колос, тоді з’явився й кукіль. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Тоді прийшли слуги господаря та сказали йому: „Господарю, хіба ми не добре насіння посіяли на полі? Звідки ж узявся кукіль?“ ");
INSERT INTO ukronpu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Він відповів їм: „Це зробив ворог“. Раби запитали його: „Хочеш, щоб ми пішли та випололи його?“ ");
INSERT INTO ukronpu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Він сказав: „Ні, щоб, виполюючи кукіль, не повиривали й пшениці“. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Залиште, щоб обоє росли разом до жнив. А під час жнив я скажу женцям: „Зберіть спочатку кукіль та пов’яжіть його в снопи, щоб спалити, а пшеницю зберіть до моєї клуні“». ");
INSERT INTO ukronpu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ісус розповів їм іншу притчу: «Царство Небесне подібне до гірчичного зерна, яке чоловік узяв та посіяв на своєму полі. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Хоча воно і є найменшим серед усього насіння, але коли виростає, стає більшим за інші рослини й стає деревом, до якого прилітають птахи небесні та гніздяться на його гілках». ");
INSERT INTO ukronpu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ісус розповів їм ще іншу притчу: «Царство Небесне подібне до закваски, яку жінка взяла та поклала до трьох мір борошна,доки все вкисло». ");
INSERT INTO ukronpu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Усе це Ісус говорив людям притчами й нічого не говорив їм без притчі, ");
INSERT INTO ukronpu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","щоб збулося сказане через пророка: «Відкрию в притчі вуста Мої, розповім про приховане від початку світу». ");
INSERT INTO ukronpu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Тоді, відпустивши людей, Ісус зайшов у дім. Його учні підійшли до Нього, кажучи: ―Роз’ясни нам притчу про кукіль на полі. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Він, відповідаючи, сказав: ―Сіяч доброго насіння – це Син Людський. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Поле – це світ, добре насіння – це сини Царства, а кукіль – це сини лукавого. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ворог, який його посіяв, – це диявол. Жнива – це кінець світу, а женці – це ангели. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Отже, як збирають кукіль та палять його у вогні, так само буде при кінці світу. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Син Людський надішле своїх ангелів, і вони зберуть з Його Царства всі спокуси та тих, хто робить беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","І викинуть їх у вогняну піч, де буде плач та скрегіт зубів. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Тоді праведники сяятимуть, як сонце, у Царстві Свого Отця. Хто має вуха, нехай слухає! ");
INSERT INTO ukronpu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Царство Небесне подібне до скарбу, захованого в полі. Чоловік, знайшовши його, знов ховає і на радощах іде, продає все, що має, і купує те поле. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ще Царство Небесне подібне до купця, який розшукує гарні перлини. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Знайшовши одну дорогоцінну перлину, він іде, продає все, що має, і купує її. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ще Царство Небесне подібне до невода, закинутого в море, який зібрав багато всякої риби. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Коли він наповнився, його витягли на берег і, сівши, відібрали все добре в посуд, а непридатне викинули геть. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Так буде й при кінці світу: вийдуть ангели, відділять злих з-поміж праведних ");
INSERT INTO ukronpu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","і викинуть їх у вогняну піч, де буде плач та скрегіт зубів. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Чи зрозуміли ви все це? Вони відповіли: ―Так! ");
INSERT INTO ukronpu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Він сказав їм: ―Тому кожен книжник, навчений про Царство Небесне, подібний до господаря дому, який виносить зі своєї скарбниці нове й старе. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Коли Ісус закінчив розповідати ці притчі, то пішов звідти. ");
INSERT INTO ukronpu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Він прийшов на Свою батьківщину й навчав людей у їхній синагозі, так що вони були здивовані та казали: «Звідки в Нього така мудрість та сила? ");
INSERT INTO ukronpu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Чи Він не син теслі? Хіба Його мати не зветься Марією, а Його брати – Яків, Йосиф, Симон та Юда? ");
INSERT INTO ukronpu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Хіба всі Його сестри не серед нас? Звідки в Нього все це?» ");
INSERT INTO ukronpu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","І вони спокушалися через Нього. Ісус же сказав їм: «Не буває пророка без пошани, хіба тільки на своїй батьківщині та у своєму домі». ");
INSERT INTO ukronpu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","І не зробив там багато чудес через їхнє невір’я. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","У той час тетрарх Ірод почув про Ісуса ");
INSERT INTO ukronpu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","та сказав своїм слугам: «Це Іван Хреститель. Він воскрес із мертвих, і тому ці чудеса діються через Нього». ");
INSERT INTO ukronpu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Бо Ірод, схопивши Івана, зв’язав його та посадив до в’язниці через Іродіаду, дружину Филипа, свого брата, ");
INSERT INTO ukronpu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","тому що Іван казав йому: «Не годиться тобі одружуватися з нею!» ");
INSERT INTO ukronpu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ірод бажав би вбити його, але боявся народу, який вважав Івана пророком. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Коли святкували день народження Ірода, дочка Іродіади станцювала серед гостей і сподобалася Іродові. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","За це він клятвою обіцяв дати їй усе, що вона тільки попросить. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Вона ж, навчена своєю матір’ю, сказала: «Дай мені на блюді голову Івана Хрестителя». ");
INSERT INTO ukronpu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Цар засмутився, але через клятву й тих, що сиділи з ним за столом, наказав виконати її бажання. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Він надіслав людей до в’язниці відрубати Іванові голову. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Його голову принесли на блюді та віддали дівчині, а вона віднесла її своїй матері. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Після того учні Івана прийшли, забрали його тіло та поховали, а потім прийшли та сповістили про це Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Коли Ісус почув це, то сів у човен та відплив звідти в пустинне місце, щоб бути на самоті. Але люди з різних міст, дізнавшись про це, пішли пішки за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Вийшовши на берег, Ісус побачив багато людей, змилосердився над ними та зцілив їхніх хворих. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Коли настав вечір, Його учні підійшли й сказали: ―Тут пустинне місце, і година вже пізня, відпусти людей, щоби пішли в села та купили собі їжу. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ісус же сказав їм: ―Не треба їм іти, ви дайте їм їсти! ");
INSERT INTO ukronpu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Вони відповіли Йому: ―Ми тут маємо лише п’ять хлібів та дві рибини. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Він сказав: ―Принесіть їх Мені! ");
INSERT INTO ukronpu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ісус наказав людям посідати на траву. Потім узяв п’ять хлібів та дві рибини, подивився на небо, благословив їх і, розломивши, дав хліби учням, а учні роздали людям. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Усі їли та наситилися, і назбирали дванадцять повних кошиків залишків. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Тих, що їли, було близько п’яти тисяч чоловіків, не рахуючи жінок та дітей. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Відразу після цього Ісус звелів учням сісти в човен та переплисти на другий бік раніше за Нього, поки Він відпустить людей. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","А відпустивши людей, Ісус зійшов на гору, щоб помолитися на самоті. Коли настав вечір, Він залишився там один. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Човен віддалився вже далеко від берега, і через супротивний вітер його почали кидати хвилі. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","О четвертій сторожі ночіІсус пішов до Своїх учнів, ідучи по воді. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Побачивши, що Він іде по воді, учні жахнулись і з переляку закричали: «Це привид!» ");
INSERT INTO ukronpu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Але Ісус тієї ж миті заговорив до них: ―Будьте сміливі! Це Я! Не бійтеся! ");
INSERT INTO ukronpu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Тоді Петро сказав у відповідь: ―Господи, якщо це Ти, накажи, щоб я пішов до Тебе по воді! ");
INSERT INTO ukronpu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ісус сказав: ―Іди! І, вийшовши з човна, Петро почав іти по воді до Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Але, побачивши сильний вітер, злякався, почав тонути й закричав: ―Господи, спаси мене! ");
INSERT INTO ukronpu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ісус, одразу простягнувши руку, схопив його та промовив: ―Маловіре, чому ти засумнівався? ");
INSERT INTO ukronpu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Коли вони сіли в човен, вітер стих. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ті, що були в човні, вклонилися Йому, кажучи: «Ти істинно – Син Божий!» ");
INSERT INTO ukronpu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Перепливши море, вони прибули до Генезаретської землі. ");
INSERT INTO ukronpu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Люди з тієї місцевості впізнали Ісуса та надіслали звістку по всій околиці. До Нього принесли всіх хворих ");
INSERT INTO ukronpu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","і благали Його дозволити лише торкнутися до краю Його одягу, і всі, хто торкнувся, були зцілені. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Тоді деякі фарисеї та книжники з Єрусалима підійшли до Ісуса й запитали: ");
INSERT INTO ukronpu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Чому Твої учні порушують звичай наших батьків? Вони їдять, не помивши своїх рук. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Він же відповів їм: ―А чому ж ви порушуєте заповідь Божу через ваш звичай? ");
INSERT INTO ukronpu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Адже Бог сказав: «Шануй батька та матір»,а також: «Той, хто зневажає батька або матір, нехай буде покараний смертю!» ");
INSERT INTO ukronpu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ви ж говорите, що той, хто скаже батькові або матері: «Те, чим я міг би допомогти тобі, – дар Богові», ");
INSERT INTO ukronpu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","той може не шанувати своїх батьків. Так ви скасували Слово Боже через свій звичай. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Лицеміри, добре пророкував про вас Ісая, коли казав: ");
INSERT INTO ukronpu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«Цей народ шанує Мене лише устами, а серце його далеко від Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Даремно вони поклоняються Мені, навчаючи людей людських заповідей». ");
INSERT INTO ukronpu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Покликавши народ, Ісус промовив до них: «Слухайте та зрозумійте! ");
INSERT INTO ukronpu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Не те, що входить в уста, оскверняє людину, але те, що виходить з уст, оскверняє людину». ");
INSERT INTO ukronpu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Тоді учні підійшли до Нього й сказали: ―Чи знаєш, що фарисеї образилися, почувши ці слова? ");
INSERT INTO ukronpu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ісус відповів: ―Кожна рослина, яка не була посаджена Моїм Небесним Отцем, буде викоренена. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Облиште їх, вони сліпі поводирі сліпців. Якщо сліпий веде сліпого, то обидва впадуть в яму. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Петро у відповідь сказав: ―Поясни нам цю притчу. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Тоді Ісус запитав: ―Невже ви ще не розумієте? ");
INSERT INTO ukronpu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Не знаєте, що все, що входить в уста, потрапляє в шлунок і виходить геть? ");
INSERT INTO ukronpu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","А те, що виходить з уст, походить із серця, саме це й оскверняє людину. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Бо з серця виходять погані думки, вбивства, перелюб, статева розпуста, крадіж, неправдиві свідчення та богохульство. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Саме це оскверняє людину, а їсти немитими руками не оскверняє людини. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Вийшовши звідти, Ісус пішов до земель Тира й Сидона. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","І ось прийшла до Нього одна жінка-ханаанеянка з тієї землі. Вона казала благаючи: ―Господи, Сину Давида, змилуйся наді мною! Моя донька одержима злим духом. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Але Ісус нічого не відповів їй. Тоді підійшли Його учні та благали Його, кажучи: ―Допоможи їй та відпусти, бо вона йде за нами й кричить. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","У відповідь Він сказав: ―Я посланий лише до загиблих овець народу Ізраїля. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Вона ж, підійшовши, вклонилася Йому та сказала: ―Господи, допоможи мені! ");
INSERT INTO ukronpu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Він же відповів: ―Не годиться брати хліб від дітей та кидати щенятам. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Проте вона сказала: ―Так, Господи, але й щенята їдять крихти, які падають зі столу їхніх господарів. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Тоді Ісус відповів їй: ―О жінко, твоя віра велика! Нехай станеться, як ти бажаєш. І тієї ж миті її донька була зцілена. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Відійшовши звідти, Ісус пішов до Галілейського моря, зійшов на гору й сів там. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","І прийшло до Нього багато людей, які мали з собою кривих, сліпих, калік, німих та багатьох інших хворих. Вони поклали їх біля Його ніг, і Він зцілив їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Побачивши, що німі розмовляють, криві стають здоровими, каліки ходять і сліпі бачать, люди дивувались та прославляли Бога Ізраїлевого. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ісус же покликав Своїх учнів та сказав: ―Жаль Мені цих людей, тому що вже три дні залишаються зі Мною й не мають, що їсти. Я не хочу відпускати їх голодними, щоб не ослабли в дорозі. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Учні спитали Його: ―Звідки в пустелі нам взяти стільки хліба, щоб нагодувати такий натовп? ");
INSERT INTO ukronpu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ісус сказав їм: ―Скільки маєте хлібів? Вони відповіли: ―Сім і декілька малих рибин. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Він звелів людям сісти на землю. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Потім узяв сім хлібів та рибу, подякував, розламав та дав учням, а учні роздали людям. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Усі їли та наситились. І зібрали сім повних кошиків залишків. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Тих, хто їв, було чотири тисячі чоловіків, не рахуючи жінок та дітей. ");
INSERT INTO ukronpu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Відпустивши людей, Ісус сів у човен та відплив до землі Магадана. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Фарисеї та садукеї прийшли до Ісуса й випробовуючи Його, просили показати їм знамення з неба. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Він відповів їм: «Коли настає вечір, ви кажете: „Буде ясна погода, бо небо червоне“. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","А вранці кажете: „Сьогодні буде негода, бо небо похмуре“. Отже, обличчя неба ви можете розпізнати, а ознаки часу не можете? ");
INSERT INTO ukronpu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Рід лукавий та невірний шукає знамення, та не дасться йому знамення, хіба що тільки знамення Йони». І, залишивши їх, пішов геть. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Перепливши на інший берег, учні забули взяти хліб. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ісус сказав їм: ―Дивіться та стережіться закваски фарисейської та садукейської. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Вони ж міркували між собою, кажучи: ―Він каже так, тому що ми не взяли хліба. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Знаючи про це, Ісус промовив: ―Маловіри, чому ви міркуєте між собою, що не взяли хліба? ");
INSERT INTO ukronpu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Невже не розумієте? Не пам’ятаєте про п’ять хлібів для п’яти тисяч і скільки кошиків ви зібрали? ");
INSERT INTO ukronpu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ані про сім хлібів для чотирьох тисяч і скільки великих кошиків ви зібрали? ");
INSERT INTO ukronpu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Як ви не розумієте, що не про хліб Я кажу вам? Стережіться ж закваски фарисейської та садукейської. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Тоді вони зрозуміли, що Він казав їм стерегтися не хлібної закваски, а вчення фарисейського та садукейського. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Коли Ісус прийшов у землі Кесарії Филипової, то запитав Своїх учнів: ―За кого вважають люди Сина Людського? ");
INSERT INTO ukronpu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Тоді вони відповіли: ―Одні – за Івана Хрестителя, інші – за Іллю, ще інші – за Єремію або одного з пророків. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ісус же запитав їх: ―А ви за кого Мене вважаєте? ");
INSERT INTO ukronpu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Симон Петро відповів: ―Ти – Христос, Син Бога Живого! ");
INSERT INTO ukronpu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ісус відповів йому: ―Блаженний ти, Симоне, сину Йони, що не тіло та кров відкрили це тобі, а Отець Мій Небесний. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Я також кажу тобі: ти – Петро, і на цій скелі Я збудую Мою Церкву, і ворота пекла її не переможуть. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Я дам тобі ключі Царства Небесного; і те, що зв’яжеш на землі, буде зв’язане на небі, і те, що розв’яжеш на землі, буде розв’язане на небі. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Тоді наказав учням, щоб нікому не казали, що Він – Христос. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Відтоді Ісус почав пояснювати Своїм учням, що Йому належить іти до Єрусалима й багато страждати, бути відкинутим старійшинами, первосвященниками та книжниками, бути вбитим, але третього дня воскресне. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Тоді Петро, відкликавши Ісуса вбік, почав докоряти Йому, кажучи: ―Нехай помилує Тебе Бог, Господи! Хай з Тобою цього ніколи не станеться! ");
INSERT INTO ukronpu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ісус же, обернувшись до Петра, промовив: ―Відійди від Мене, сатано! Ти спокушаєш Мене, бо думаєш не про Боже, а про людське. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Тоді Ісус сказав Своїм учням: ―Якщо хтось хоче йти за Мною, нехай зречеться самого себе, візьме свій хрест та слідує за Мною. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Бо хто хоче спасти своє життя, втратить його, а хто втратить життя заради Мене, той знайде його. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Яка користь людині, якщо здобуде весь світ, а душу свою втратить? Або що дасть людина в обмін за свою душу? ");
INSERT INTO ukronpu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Адже Син Людський має прийти в славі Отця Свого разом зі Своїми ангелами й тоді воздасть кожному згідно з його ділами. ");
INSERT INTO ukronpu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Істинно кажу вам: деякі з присутніх не зазнають смерті, доки не побачать Сина Людського, Який приходить у Царстві Своєму. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Через шість днів Ісус узяв із Собою Петра, Якова та його брата Івана й вивів їх на високу гору. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Там Він преобразився перед ними: Його обличчя засяяло, мов сонце, а Його одяг став білим, як світло. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","І ось з’явились їм Мойсей та Ілля, які розмовляли з Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Петро звернувся до Ісуса й сказав: «Господи, добре нам тут бути! Якщо бажаєш, зробимо тут три намети: один для Тебе, один для Мойсея та один для Іллі». ");
INSERT INTO ukronpu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Коли він ще говорив, ось ясна хмара накрила їх, і з хмари промовив голос: «Це Син Мій улюблений, у Якому Моє вподобання. Його слухайте!» ");
INSERT INTO ukronpu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Почувши це, учні впали долілиць, бо дуже злякалися. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Але Ісус підійшов та, доторкнувшись до них, сказав: ―Встаньте, не бійтеся! ");
INSERT INTO ukronpu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Підвівши свої очі, вони нікого не побачили, окрім Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Коли вони сходили з гори, Ісус наказав їм: ―Не кажіть нікому про те, що ви бачили, доки Син Людський не воскресне з мертвих. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Учні запитали Його: ―Чому книжники кажуть, що Ілля має прийти першим? ");
INSERT INTO ukronpu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Тоді Ісус відповів: ―Ілля дійсно приходить для того, щоб відновити все. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Але кажу вам: Ілля вже прийшов, та не впізнали його й вчинили з ним усе, що схотіли. Так само й Син Людський має постраждати від них. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Тоді учні зрозуміли, що Він говорив про Івана Хрестителя. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Коли вони прийшли до людей, підійшов чоловік, упав на коліна перед Ісусом ");
INSERT INTO ukronpu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","і промовив: ―Господи, змилуйся над моїм сином, бо він – сновида й тяжко страждає, часто кидається у вогонь або у воду. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Я приводив його до Твоїх учнів, але вони не змогли його зцілити. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ісус же відповів: ―О роде невірний та розбещений, доки буду з вами? Доки терпітиму вас? Приведіть хлопчика сюди до Мене! ");
INSERT INTO ukronpu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ісус наказав демону, і той вийшов із хлопчика; тієї ж миті хлопець був зцілений. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Тоді учні підійшли до Ісуса й наодинці запитали: ―Чому ми не змогли вигнати демона? ");
INSERT INTO ukronpu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Він відповів: ―Через ваше маловір’я. Істинно кажу вам: якщо ви матимете віру, як гірчичне зерно, і скажете цій горі: «Перейди звідси туди!», – вона перейде. Нічого неможливого для вас не буде. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Але цей рід демонів виганяється лише постом та молитвою. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Коли ж вони разом зібралися в Галілеї, Ісус сказав їм: «Син Людський буде виданий у руки людські. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Його вб’ють, але третього дня Він воскресне». Учні дуже засмутилися. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Коли вони прибули до Капернаума, прийшли до Петра ті, що збирали дводрахмову данину, і запитали: ―Ваш учитель платить дводрахмову данину? ");
INSERT INTO ukronpu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Він відповів: ―Так! Коли ж Петро зайшов у дім, Ісус випередив його, запитавши: ―Симоне, як ти думаєш, від кого збирають данину або податок земні царі, від своїх синів чи від чужих? ");
INSERT INTO ukronpu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Симон відповів: ―Від чужих. Тоді Ісус сказав: ―Отже, сини вільні від податку. ");
INSERT INTO ukronpu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Але щоб не спокушати їх, іди до моря, закинь вудку й витягни першу рибу, яку впіймаєш. Відкривши їй рота, ти знайдеш статер. Візьми його та віддай їм за Мене й за себе. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","У той час учні прийшли до Ісуса, кажучи: ―Хто найбільший у Царстві Небесному? ");
INSERT INTO ukronpu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ісус покликав дитину, поставив її посеред них ");
INSERT INTO ukronpu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","і сказав: ―Істинно кажу вам: якщо не навернетесь і не станете, як діти, ніколи не увійдете в Царство Небесне. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Отже, хто впокориться, як ця дитина, той великий у Царстві Небесному. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","І хто приймає таку дитину в ім’я Моє, Мене приймає. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Якщо хтось спокусить одного з цих малих, що вірують у Мене, то для нього було б краще, якби йому повісили млинове жорно на шию й втопили у відкритому морі. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Горе світові від спокус, бо спокуси повинні приходити, але горе тій людині, через яку приходить спокуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Якщо твоя рука або нога спокушає тебе, відріж її та відкинь від себе: краще тобі увійти в життя покаліченим чи кульгавим, ніж, маючи дві руки або дві ноги, бути вкинутим у вогонь вічний. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","І якщо твоє око спокушає тебе, вирви його та відкинь від себе. Краще тобі увійти в життя однооким, ніж, маючи два ока, бути вкинутим у Геєну вогняну. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Стережіться, щоб ви не зневажали жодного з цих малих, бо кажу вам: їхні ангели на небі завжди бачать обличчя Мого Небесного Отця. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Адже Син Людський прийшов знайти та спасти загублене. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Як ви вважаєте, якщо в одного чоловіка буде сто овець і одна з них заблукає, чи не залишить він дев’яносто дев’ять на горах та не піде шукати заблудлу? ");
INSERT INTO ukronpu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","І коли станеться, що знаходить її, істинно кажу вам: радітиме нею більше, ніж дев’яноста дев’ятьма, які не заблукали. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Так само й ваш Небесний Отець не бажає, щоб загинув хоч один із цих малих. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Якщо твій брат згрішив проти тебе, іди та докори йому наодинці. Якщо він послухає, то ти повернув собі брата. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Якщо ж не послухає, візьми з собою ще одного або двох, щоб устами двох або трьох свідків підтвердилось кожне слово. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Якщо ж він відмовиться слухати, скажи Церкві. Якщо не послухається Церкви, нехай буде для тебе, як язичник і митник. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Істинно кажу вам: зв’язане вами на землі, буде зв’язане на небі, і все, розв’язане на землі, буде розв’язане на небі. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Знов істинно кажу вам: якщо двоє з вас на землі погодяться просити про щось, то все їм буде дано Моїм Небесним Отцем. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Адже там, де двоє або троє з вас зберуться в ім’я Моє, там і Я посеред них. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Тоді підійшов Петро та спитав Ісуса: ―Господи, як часто прощати брата, який згрішить проти мене? Чи до семи разів? ");
INSERT INTO ukronpu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ісус відповів йому: ―Не кажу тобі до семи, а до сімдесяти разів по сім. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Отже, Царство Небесне схоже на царя, який бажав розрахуватись зі своїми рабами. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Коли почав розраховуватись, привели до нього одного, який був винен десять тисяч талантів ");
INSERT INTO ukronpu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Оскільки він не мав, чим заплатити, господар наказав продати його, дружину, дітей та все його майно й заплатити борг. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Тоді раб, впавши ниць, благав його, кажучи: «Будь терплячим зі мною, і я все поверну тобі». ");
INSERT INTO ukronpu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Змилосердившись, господар того раба відпустив його та простив борг. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Коли той раб вийшов, то зустрів одного зі своїх товаришів, який був винен йому сто динаріїв, схопив його та почав душити кажучи: «Віддай мені все, що винен!» ");
INSERT INTO ukronpu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Тоді його товариш упав ниць та благав його, кажучи: «Будь терплячим зі мною, і я все поверну тобі». ");
INSERT INTO ukronpu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Але той не схотів і кинув його до в’язниці, доки не віддасть боргу. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Побачивши, що сталося, його товариші дуже засмутилися та пішли й сказали про все, що сталося, господареві. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Тоді, покликавши його, господар сказав йому: «Лукавий рабе! Я простив тобі весь борг, як ти просив мене! ");
INSERT INTO ukronpu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Хіба не належало тобі змилосердитись над твоїм товаришем, як і я змилосердився над тобою?» ");
INSERT INTO ukronpu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","І, розгнівавшись, господар віддав його катам, поки не віддасть боргу. ");
INSERT INTO ukronpu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Так зробить і Отець Мій Небесний з вами, якщо кожен із вас не прощатиме свого брата від усього серця. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Коли Ісус закінчив ці слова, Він вийшов із Галілеї та пішов в околиці Юдеї, що за Йорданом. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","За Ним ішло багато людей, і Він зцілив їх там. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","І підійшли до Нього фарисеї та, випробовуючи Його, запитали: ―Чи дозволено чоловікові розлучатися зі своєю дружиною з будь-якої причини? ");
INSERT INTO ukronpu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ісус же відповів: ―Хіба ви не читали, що Творець від початку «чоловіком та жінкою їх створив»? ");
INSERT INTO ukronpu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","І додав: «Тому залишить чоловік батька свого й матір свою і прилине до жінки своєї, і будуть двоє одним тілом». ");
INSERT INTO ukronpu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Тому більше не буде двох, а одне тіло. Отже, те, що Бог з’єднав, людина хай не роз’єднує. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Вони відповіли: ―Чому тоді Мойсей звелів дати їй лист про розлучення та відпустити? ");
INSERT INTO ukronpu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Він відповів: ―Мойсей через вашу жорстокість дозволив вам розлучатися з вашими дружинами, але від початку не було так. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Кажу ж вам: кожен, хто розлучається зі своєю дружиною – за винятком статевої розпусти – і одружується з іншою, чинить перелюб. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Тоді Його учні сказали: ―Якщо така справа чоловіка та жінки, то краще не одружуватись. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Він же відповів їм: ―Не всі розуміють це слово, а лише ті, кому це дано. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Бо є євнухи, які такими народилися, є євнухи, яких оскопили люди, і є євнухи, які оскопили себе самі заради Царства Небесного. Хто може зрозуміти, хай зрозуміє! ");
INSERT INTO ukronpu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Тоді привели до Нього дітей, щоб Він поклав на них руки та помолився, але учні забороняли їм. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ісус же сказав: «Пустіть дітей, не забороняйте їм приходити до Мене, бо таким, як вони, належить Царство Небесне». ");
INSERT INTO ukronpu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","І, поклавши на них руки, Він пішов звідти. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","І ось один чоловік підійшов та запитав: ―Учителю, що мені зробити доброго, щоб мати життя вічне? ");
INSERT INTO ukronpu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ісус відповів йому: ―Чому питаєш Мене про добре? Ніхто не є Добрий, окрім Самого Бога.Але якщо бажаєш увійти в Життя, виконуй заповіді. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Той запитав: ―Які? Ісус сказав: ―«Не вбивай», «Не чини перелюбу», «Не кради», «Не обманюй», ");
INSERT INTO ukronpu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","«Шануй батька та матір»,«Люби ближнього свого, як самого себе». ");
INSERT INTO ukronpu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Юнак відповів Йому: ―Усе це я зберіг змалку. Чого ще мені бракує? ");
INSERT INTO ukronpu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ісус відповів йому: ―Якщо бажаєш бути досконалим, піди, продай своє майно та роздай бідним, і матимеш скарб на небесах; а тоді приходь та слідуй за Мною. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Почувши ці слова, молодий чоловік відійшов засмучений, бо мав багато маєтків. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ісус же сказав своїм учням: ―Істинно кажу вам: важко багатому ввійти в Царство Небесне. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","І ще кажу вам: легше верблюдові пройти через вушко голки, ніж багатому ввійти в Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Коли учні почули це, то дуже здивувалися й запитали: ―Хто ж тоді може бути спасенний? ");
INSERT INTO ukronpu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Подивившись на них, Ісус відповів їм: ―Для людей це неможливо, але для Бога все можливо. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Тоді Петро сказав Йому: ―Ось ми залишили все та пішли за Тобою. Що ми будемо за це мати? ");
INSERT INTO ukronpu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ісус відповів йому: ―Істинно кажу вам: у новому світі, коли Син Людський сяде на Свій престол слави, то й ви, котрі пішли за Мною, сядете на дванадцятьох престолах, судячи дванадцять племен Ізраїля. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","І кожен, хто залишив дім, братів, сестер, батька, матір, дружину, дітей і поля заради Мого імені, той отримає в сто разів більше і вічне життя у спадок. ");
INSERT INTO ukronpu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Багато перших будуть останніми, а останні – першими. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Царство Небесне подібне до господаря, який рано-вранці вийшов найняти робітників до свого виноградника. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Погодившись із робітниками по одному динаріюв день, він послав їх до свого виноградника. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Вийшовши о третій годині, він побачив інших, які стояли на ринку без роботи. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Він сказав їм: „Ідіть і ви в мій виноградник, і дам вам по справедливості“. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Вони пішли. Вийшовши о шостій і о дев’ятій годині, зробив так само. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Коли вийшов об одинадцятій годині, побачив інших і сказав їм: „Чому ви стоїте весь день без роботи?“ ");
INSERT INTO ukronpu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Вони кажуть йому: „Тому що ніхто нас не найняв“. Він говорить: „Ідіть і ви в мій виноградник“. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Коли настав вечір, господар виноградника каже своєму управителеві: „Поклич робітників і заплати їм. Почни з останніх до перших“. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ті, що прийшли об одинадцятій годині, отримали кожен по динарію. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ті, що прийшли першими, думали, що отримають більше, але й вони отримали по динарію. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Отримавши, вони нарікали на господаря, ");
INSERT INTO ukronpu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","кажучи: „Ці останні працювали тільки одну годину, і ти зрівняв їх із нами, що зносили тягар дня та спеку“. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Він же сказав одному з них: „Друже, я не ображаю тебе, чи не за динарія ти домовлявся зі мною? ");
INSERT INTO ukronpu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Тож візьми своє і йди. Я ж хочу й цьому останньому дати, як тобі. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Хіба я не можу зробити того, що хочу, з тим, що моє? Чи твоє око заздрісне через те, що я добрий?“ ");
INSERT INTO ukronpu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Так останні будуть першими, а перші – останніми. Бо багато покликаних, та мало обраних». ");
INSERT INTO ukronpu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Прямуючи до Єрусалима, Ісус узяв дванадцятьох учнів окремо й дорогою сказав їм: ");
INSERT INTO ukronpu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ось ми йдемо до Єрусалима, і там Син Людський буде виданий первосвященникам і книжникам; вони засудять Його на смерть, ");
INSERT INTO ukronpu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","віддадуть язичникам для знущання, катування та розп’яття, але третього дня Він воскресне». ");
INSERT INTO ukronpu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Тоді підійшла до Нього мати синів Зеведеєвих разом зі своїми синами. Вклонившись, вона хотіла щось попросити в Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Він запитав її: ―Що бажаєш Мені сказати? Вона сказала: ―Накажи, щоб двоє моїх синів сиділи в Царстві Твоєму: один праворуч, а інший ліворуч від Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ісус у відповідь сказав їм: ―Не знаєте, чого просите. Чи зможете ви пити чашу, яку Я питиму, або хреститися хрещенням, яким Я хрещуся? Вони відповіли: ―Зможемо! ");
INSERT INTO ukronpu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Він сказав їм: ―Чашу Мою ви будете пити, і хрещенням, яким Я хрещуся, ви будете хрещені. Але щоб сидіти праворуч або ліворуч від Мене – не Мені це вирішувати: ці місця належать тим, кому приготовлені Моїм Отцем. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Решта десятеро учнів, почувши про це, обурилися на двох братів. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ісус же, покликавши їх, сказав: «Ви знаєте, що керівники народів володіють ними, а сильні світу панують над ними. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Але серед вас не так має бути: хто хоче стати великим між вами, той має стати вашим слугою. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","І хто хоче бути першим, нехай буде вашим рабом. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Так само й Син Людський прийшов не для того, щоб Йому служили, але щоб служити й віддати Своє життя як викуп за багатьох». ");
INSERT INTO ukronpu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Коли вони виходили з Єрихона, багато людей пішло за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","І ось двоє сліпих, котрі сиділи біля дороги, почувши, що Ісус проходить повз них, почали голосно кричати: ―Змилуйся над нами, Господи, Сину Давидів! ");
INSERT INTO ukronpu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Натовп докоряв їм, щоб мовчали. Але вони ще голосніше закричали: ―Змилуйся над нами, Господи, Сину Давидів! ");
INSERT INTO ukronpu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ісус зупинився, покликав їх та сказав: ―Що хочете, щоб Я зробив для вас? ");
INSERT INTO ukronpu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Вони відповіли: ―Господи, щоб відкрилися наші очі! ");
INSERT INTO ukronpu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ісус, змилосердившись, доторкнувся до їхніх очей – і вони відразу прозріли та пішли за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Коли наблизились до Єрусалима й прийшли у Вітфагію, до Оливної гори, Ісус надіслав двох учнів ");
INSERT INTO ukronpu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","та сказав їм: «Ідіть у село, яке перед вами, і відразу знайдете прив’язану ослицю й осля з нею; відв’яжіть їх та приведіть до Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","І якщо хтось спитає вас, скажіть, що Господь потребує їх і відразу ж їх поверне». ");
INSERT INTO ukronpu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Це сталося, щоб сповнились слова, сказані пророком: ");
INSERT INTO ukronpu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Скажіть дочці Сіону: „Ось Цар твій їде до тебе, покірний, верхи на ослиці та осляті, синові під’яремної“». ");
INSERT INTO ukronpu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Учні пішли й зробили, як наказав їм Ісус. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Привели ослицю й осля, поклали на них свій одяг, і Він сів верхи. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Багато людей стелили свій одяг по дорозі, інші ж різали гілки з дерев і також стелили по дорозі. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Люди, ідучи попереду та позаду Нього, викрикували: «Осанна Синові Давидовому!» «Благословенний Той, Хто йде в ім’я Господа!» «Осанна на Небесах!» ");
INSERT INTO ukronpu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Коли Він увійшов у Єрусалим, усе місто заворушилося питаючи: «Хто Він такий?» ");
INSERT INTO ukronpu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Народ же казав: «Це Ісус, пророк із Назарета, що в Галілеї». ");
INSERT INTO ukronpu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ісус увійшов у Храм та вигнав усіх тих, хто продавав і купував у Храмі, перевернув столи тих, хто міняв гроші, та місця тих, хто продавав голубів. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Він казав їм: «Написано: „Дім Мій буде називатися Домом Молитви“, а ви зробили з нього „притулок розбійників!“» ");
INSERT INTO ukronpu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","І приходили до Нього в Храм сліпі та криві, і Він зцілив їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Але первосвященники та книжники, побачивши чудеса, які Він робив, та дітей, які кричали в Храмі: «Осанна Синові Давидовому!» – обурилися ");
INSERT INTO ukronpu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","й сказали Йому: ―Чуєш, що вони говорять? Ісус же відповів їм: ―Так! А хіба ви ніколи не читали: «Із вуст малих дітей і немовлят Ти приготував Собі хвалу». ");
INSERT INTO ukronpu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Залишивши їх, Він вийшов із міста, пішов до Віфанії та заночував там. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Вранці, повертаючись до міста, Ісус зголоднів. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","І, побачивши біля дороги смоковницю, підійшов до неї, але нічого, окрім листя, не знайшов. Тоді промовив до неї: «Нехай же повік не буде плоду від тебе!» І смоковниця відразу всохла. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Побачивши це, учні здивувалися й запитали: ―Як смоковниця відразу всохла? ");
INSERT INTO ukronpu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ісус сказав у відповідь: ―Істинно кажу вам: якщо ви матимете віру й не будете сумніватися, то зробите не тільки те, що сталося зі смоковницею, але навіть якщо скажете цій горі: «Піднесися та кинься в море!» – станеться. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Усе, про що попросите в молитві з вірою, отримаєте. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Коли Він увійшов у Храм і навчав, до Нього підійшли первосвященники та старійшини народу й запитали: ―Якою владою Ти це робиш? І хто дав Тобі таку владу? ");
INSERT INTO ukronpu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","У відповідь Ісус сказав їм: ―Запитаю і Я вас про одне, і якщо відповісте Мені, Я скажу вам, якою владою це роблю. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Звідки було Іванове хрещення? З Неба чи від людей? Вони ж стали міркувати між собою, кажучи: ―Якщо скажемо: «З неба», Він запитає нас: «Чому ж ви не повірили йому?» ");
INSERT INTO ukronpu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Якщо ж ми скажемо: «Від людей», то боїмося людей, бо всі вважають Івана пророком. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Тож вони відповіли Ісусові: ―Не знаємо. Ісус сказав їм: ―Тоді і Я не скажу, якою владою це роблю. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Як ви вважаєте? В одного чоловіка було двоє синів. Він прийшов до першого й сказав: „Сину, іди та попрацюй сьогодні в моєму винограднику“. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Той відповів: „Не хочу!“ Але потім, розкаявшись, пішов. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Пішовши до другого, сказав так само. Той відповів: „Я піду, господарю!“ Але не пішов. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Хто з цих двох виконав волю батька?» Вони відповіли: ―Перший. Тоді Ісус сказав їм: ―Істинно кажу вам: митники та блудниці випереджають вас до Царства Божого. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Прийшов Іван до вас дорогою праведності, і ви не повірили йому, а митники та блудниці повірили. Ви ж, навіть побачивши це, все одно не розкаялися й не повірили йому. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Послухайте іншу притчу. Один чоловік-господар посадив виноградник, обвів його огорожею, вкопав у ньому давильню, збудував башту, здав його в оренду виноградарям та вирушив у подорож. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Коли настав час врожаю, він надіслав своїх рабів до виноградарів отримати свій прибуток. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Однак виноградарі схопили рабів, одного побили, іншого вбили, а ще іншого закидали камінням. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Тоді він надіслав інших рабів, більше, ніж раніше, але виноградарі вчинили з ними так само. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Нарешті надіслав до них свого сина, кажучи: «Мого сина поважатимуть!» ");
INSERT INTO ukronpu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Але виноградарі, побачивши сина, сказали один одному: «Це спадкоємець, ходімо та вб’ємо його, і спадщина дістанеться нам!» ");
INSERT INTO ukronpu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Вони схопили його, вивели з виноградника та вбили. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Коли прийде господар виноградника, що він зробить із цими виноградарями? ");
INSERT INTO ukronpu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Вони відповіли: ―Тих злодіїв жорстоко покарає, а виноградник віддасть іншим виноградарям, які сплатять його прибуток вчасно. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ісус сказав їм: ―Хіба ви ніколи не читали в Писанні: «Камінь, який відкинули будівничі, став наріжним каменем. Господь зробив це, і воно є дивним у наших очах»? ");
INSERT INTO ukronpu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Тому кажу вам: Царство Боже буде відібране від вас та дане народові, який буде приносити його плоди. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Хто впаде на цей камінь, буде розбитий, а той, на кого він впаде, буде розчавлений. ");
INSERT INTO ukronpu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Почувши ці притчі, первосвященники та фарисеї зрозуміли, що Він говорить про них, ");
INSERT INTO ukronpu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","і шукали нагоди схопити Ісуса, але боялися народу, який вважав Його пророком. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ісус у відповідь продовжив говорити притчами: ");
INSERT INTO ukronpu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Царство Небесне подібне до Царя, який приготував весілля для свого сина. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Він надіслав своїх рабів покликати запрошених на весілля, але ті не захотіли прийти. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Тоді надіслав інших рабів сказати запрошеним: «Ось я приготував обід, моїх волів та вгодовану худобу вже забито, усе готове. Приходьте на весілля!» ");
INSERT INTO ukronpu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Але вони знехтували й пішли: один – на своє поле, інший – торгувати. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Інші ж, схопивши його рабів, познущалися над ними та вбили їх. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Тоді цар обурився та надіслав своє військо, знищив тих убивць і спалив їхнє місто. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","І сказав своїм рабам: «Весілля вже готове, а запрошені виявились недостойними. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Отже, ідіть на перехрестя доріг та запрошуйте, кого зустрінете, на весілля». ");
INSERT INTO ukronpu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ті раби вийшли на дороги та покликали всіх, кого зустріли, – як поганих, так і добрих; і весільна зала наповнилася гостями. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Але коли цар прийшов подивитися на гостей, то побачив там чоловіка, який не був одягнений у весільний одяг. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","І сказав йому: «Друже, як ти зайшов сюди, не маючи весільного одягу?» Проте той мовчав. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Тоді Цар сказав слугам: «Зв’яжіть йому руки та ноги й викиньте до зовнішньої тьми. Там буде плач та скрегіт зубів. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Адже багато покликаних, та мало обраних». ");
INSERT INTO ukronpu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Тоді фарисеї пішли та радились, як спіймати Ісуса на слові. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","І надіслали до Нього своїх учнів разом з іродіанами, які запитали: ―Учителю, ми знаємо, що Ти праведний і правдиво навчаєш Божого шляху, ні на кого не зважаєш, адже не дивишся на людське обличчя. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Отже, скажи нам, як Ти вважаєш: чи годиться платити податок Кесареві, чи ні? ");
INSERT INTO ukronpu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Але Ісус, зрозумівши їхнє лукавство, сказав: ―Чому ви випробовуєте Мене, лицеміри? ");
INSERT INTO ukronpu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Покажіть Мені монету для податку. Вони принесли Йому динарій. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Він сказав їм: ―Чиє це зображення та напис? ");
INSERT INTO ukronpu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Вони відповіли: ―Кесаря! Тоді Він сказав їм: ―Тож віддайте Кесареві – Кесареве, а Богові – Боже! ");
INSERT INTO ukronpu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Почувши це, вони здивувалися й, залишивши Його, пішли геть. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Того ж дня прийшли до Нього садукеї, які кажуть, що не існує воскресіння з мертвих, і запитали Його: ");
INSERT INTO ukronpu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Учителю, Мойсей сказав: «Якщо хтось помре, не маючи дітей, то нехай його брат одружиться з дружиною померлого та підніме нащадка своєму братові». ");
INSERT INTO ukronpu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Було ж у нас семеро братів. Перший одружився та помер, і, не маючи дітей, залишив дружину своєму братові. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Так само другий і третій – аж до сьомого. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Після всіх померла й жінка. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Отже, при воскресінні дружиною котрого з семи вона буде? Адже всі мали її за дружину. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ісус у відповідь сказав їм: ―Помиляєтеся, бо не знаєте ані Писання, ані сили Божої. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","При воскресінні не одружуються й не виходять заміж, а є як ангели на небі. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","А щодо воскресіння з мертвих, хіба ви не читали, що сказав вам Бог: ");
INSERT INTO ukronpu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","«Я – Бог Авраама, Бог Ісаака і Бог Якова»?Він є Богом не мертвих, а живих! ");
INSERT INTO ukronpu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Почувши це, люди були здивовані Його вченням. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Фарисеї, почувши, що Він змусив садукеїв замовкнути, зібралися разом. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Один із них, учитель Закону, запитав Його, випробовуючи: ");
INSERT INTO ukronpu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Учителю, яка заповідь найбільша в Законі? ");
INSERT INTO ukronpu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Він відповів йому: ―«Люби Господа Бога свого всім серцем своїм, усією своєю душею і всім своїм розумінням!» ");
INSERT INTO ukronpu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Це перша та найбільша заповідь. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","А друга подібна до неї: «Люби ближнього свого, як самого себе». ");
INSERT INTO ukronpu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","На ці дві заповіді спираються весь Закон та Пророки. ");
INSERT INTO ukronpu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Коли зібралися фарисеї, Ісус запитав їх: ");
INSERT INTO ukronpu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―Що ви думаєте про Христа? Чий Він Син? Вони відповіли: ―Давидів! ");
INSERT INTO ukronpu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Він сказав: ―Як же тоді Давид у Дусі називає Його Господом, коли каже: ");
INSERT INTO ukronpu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«Господь сказав Господеві моєму: „Сядь праворуч від Мене, доки Я не покладу ворогів Твоїх, як підніжок для Твоїх ніг“». ");
INSERT INTO ukronpu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Отже, якщо Давид називає Його Господом, як Він може бути його Сином? ");
INSERT INTO ukronpu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","І ніхто не міг Йому відповісти ані слова. Від того дня ніхто не наважувався запитувати Його. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Тоді Ісус промовив до народу та до своїх учнів: ");
INSERT INTO ukronpu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«На місці Мойсея сидять книжники та фарисеї. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Отже, робіть та слухайтесь усього, що вони вам кажуть, але не робіть їхніх вчинків, адже вони говорять одне, а роблять інше. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Вони в’яжуть важкі тягарі, які важко нести, і кладуть їх на плечі людей, але самі й пальцем не хочуть їх поворухнути. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Вони роблять усі свої вчинки, щоб їх бачили люди: розширюють свої філактерії та збільшують китиці, ");
INSERT INTO ukronpu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","люблять почесні місця на бенкетах, перші місця в синагогах, ");
INSERT INTO ukronpu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","привітання на ринках та щоб люди їх кликали: Равві! ");
INSERT INTO ukronpu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Але ви не називайте себе Равві, бо Один у вас Равві, ви ж усі – брати. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Не називайте нікого на землі своїм Отцем, бо лише Один у вас Отець – Той, Що на Небі. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Також нікого не називайте Наставником, бо Один у вас Наставник – Христос. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Найбільший з вас нехай буде вам слугою. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Бо хто підноситиме себе, той буде принижений, а хто себе принижуватиме, буде піднесений. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Горе вам, книжники та фарисеї, лицеміри, бо ви зачиняєте Царство Небесне перед людьми: самі не входите й тим, хто бажає ввійти, не дозволяєте. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Горе вам, книжники та фарисеї, лицеміри, бо ви поїдаєте доми вдів і лицемірно довго молитесь. За це отримаєте ще більшу кару. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Горе вам, книжники та фарисеї, лицеміри, бо ви подорожуєте морем та суходолом, щоб здобути хоча б одного наверненого; і коли це стається, робите його сином Геєни, вдвічі гіршим за вас. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Горе вам, сліпі поводирі! Ви кажете: „Якщо хтось клянеться Храмом, то це нічого не значить, а якщо клянеться золотом Храму, то він зв’язаний присягою“. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ви безумні та сліпі! Адже що більше: золото чи Храм, який освячує золото? ");
INSERT INTO ukronpu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","І ще ви кажете: хто клянеться жертовником, це нічого не значить, а якщо клянеться даром, що на ньому, то він зв’язаний присягою. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Сліпці! Що більше: дар чи жертовник, який освячує дар? ");
INSERT INTO ukronpu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Отже, хто клянеться жертовником, клянеться ним і тим, що на ньому. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","І хто клянеться Храмом, клянеться ним і Тим, Хто живе в ньому. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","І хто клянеться небом, клянеться престолом Божим і Тим, Хто сидить на ньому. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Горе вам, книжники та фарисеї, лицеміри, бо ви даєте десятину з м’яти, кропу та тмину, але знехтували найважливішим у Законі: справедливістю, милістю та вірою. І це належить робити, і тим не нехтувати. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Сліпі поводирі, що відціджуєте комара, а ковтаєте верблюда. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Горе вам, книжники та фарисеї, лицеміри, бо ви очищуєте чашу та посуд ззовні, а всередині вони повні здирництва та ненажерливості. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Сліпий фарисею! Очисти спочатку чашу зсередини, щоб і ззовні вона стала чистою. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Горе вам, книжники та фарисеї, лицеміри, бо ви – як побілені гроби, які ззовні видаються гарними, а всередині повні кісток мерців та всякої нечистоти. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Так і ви ззовні видаєтеся праведними людьми, а всередині повні лицемірства та беззаконня. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Горе вам, книжники та фарисеї, лицеміри, бо ви будуєте гробниці пророкам, прикрашаєте пам’ятники праведникам ");
INSERT INTO ukronpu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","і кажете: „Якби ми жили за днів наших батьків, то не були б спільниками у крові пророків“. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Цим ви свідчите, що ви є синами тих, що вбивали пророків. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Сповніть же до кінця приклад ваших батьків. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Змії, поріддя гадюче! Як ви зможете уникнути суду Геєни? ");
INSERT INTO ukronpu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ось тому Я посилаю до вас пророків, мудреців та книжників. Декого з них ви вб’єте та розіпнете, а декого з них ви будете бити у ваших синагогах та гнати з міста до міста. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","І тому впаде на вас уся кров праведників, пролита на землі: від крові праведного Авеля до крові Захарії, сина Варахії, якого ви вбили між Храмом та жертовником. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Істинно кажу вам: усе це прийде на цей рід. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","О, Єрусалиме, Єрусалиме, що вбиваєш пророків і закидуєш камінням посланих до тебе! Скільки разів Я бажав зібрати твоїх дітей, як квочка збирає своїх курчат під крила, але ви не захотіли! ");
INSERT INTO ukronpu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ось ваш дім залишається порожнім. ");
INSERT INTO ukronpu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Бо кажу вам: віднині не побачите Мене, доки не скажете: „Благословенний Той, Хто йде в ім’я Господа!“» ");
INSERT INTO ukronpu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Коли Ісус виходив із Храму та віддалявся, Його учні підійшли, щоб показати Йому будівлі Храму. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Але Він сказав їм: ―Бачите все це? Істинно кажу вам: не залишиться тут каменя на камені, який не був би зруйнований. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Коли Ісус сидів на Оливній горі, Його учні підійшли до Нього й наодинці запитали: ―Скажи нам, коли все це станеться і яка ознака Твого приходу та кінця світу? ");
INSERT INTO ukronpu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ісус відповів їм: ―Дивіться, щоб ніхто не ввів вас в оману! ");
INSERT INTO ukronpu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Бо багато хто прийде в ім’я Моє й казатиме: «Я – Христос!» І багатьох введуть в оману. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ви почуєте про війни та чутки про війни. Дивіться, не лякайтеся: це має статися, але це ще не кінець. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Повстане народ проти народу й царство проти царства. У різних місцях будуть землетруси та голод. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Але все це – лише початок страждань. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Тоді видаватимуть вас на муки та вбиватимуть вас, усі народи будуть ненавидіти вас через ім’я Моє. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Тоді багато хто відступить, будуть зраджувати й ненавидіти одне одного. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Підніметься багато лжепророків, що багатьох зведуть в оману. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","І через ріст беззаконня любов багатьох згасне. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","А хто витримає до кінця, той буде спасенний. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ця Добра Звістка Царства буде проповідуватись у всьому світі на свідчення всім народам. І тоді настане кінець. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Коли побачите у святому місці гидоту спустошення, провіщену пророком Даниїлом, – хто читає, нехай зрозуміє, – ");
INSERT INTO ukronpu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","тоді ті, що в Юдеї, нехай тікають у гори. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Той, що буде на даху, хай не сходить взяти щось зі свого дому; ");
INSERT INTO ukronpu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","той, що в полі, хай не вертається взяти свою одежу. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Горе вагітним і тим, що будуть годувати грудьми в ті дні. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Моліться, щоб ваша втеча не сталася взимку або в Суботу. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Бо такого великого страждання не було від початку світу дотепер і ніколи не буде. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","І якби ті дні не були скорочені, то жодна людина не була б врятована, але заради обраних ті дні будуть скорочені. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Якщо тоді хтось скаже вам: «Ось тут Христос!» або «Ось Він!» – не вірте. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Бо постануть лжехристи та лжепророки й робитимуть великі знамення та чудеса, щоб ввести в оману, якщо можливо, і обраних. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ось Я попередив вас! ");
INSERT INTO ukronpu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Отже, якщо скажуть вам: «Ось Він у пустелі!» – не виходьте; «Ось Він у таємних кімнатах!» – не вірте. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Бо як блискавка виходить зі сходу й видно її аж на заході, таким буде й прихід Сина Людського. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Бо де буде труп, туди зберуться й орли. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Одразу після тих днів страждання «сонце померкне, і місяць не буде світити; зірки впадуть із неба, і сили небесні захитаються». ");
INSERT INTO ukronpu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Тоді на небі з’явиться знамення Сина Людського. І заголосять усі народи землі й побачать Сина Людського, Який приходить на хмарах небесних із великою силою та славою. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Він надішле Своїх ангелів, і вони гучним звуком сурми зберуть Його обраних із чотирьох вітрів, від одного кінця неба до другого. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Від смоковниці навчіться її притчі: коли гілка стає вже м’якою й пускає листя, ви знаєте, що літо близько. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Так і ви, коли побачите все це, знайте: прихід близько, уже біля дверей. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Істинно кажу вам: не мине цей рід, поки все це не станеться. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Небо та земля проминуть, але слова Мої не проминуть. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","А про той день і годину ніхто не знає: ні ангели небесні, ні Син, а тільки Отець. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Бо як було за днів Ноя, так буде й в годину приходу Сина Людського. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Як було в ті дні перед потопом: люди їли, пили, одружувались, виходили заміж аж до дня, коли Ной увійшов у ковчег, ");
INSERT INTO ukronpu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","і ніхто не знав, доки не прийшов потоп і не знищив усіх, – таким буде й прихід Сина Людського. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Тоді двоє будуть працювати в полі: одного буде взято, а іншого залишено. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Дві жінки будуть молоти на жорнах: одну буде взято, а іншу залишено. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Отже, пильнуйте, бо не знаєте, якого дня прийде ваш Господь. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Тож знайте, що якби господар дому знав, о якій сторожі приходить злодій, він пильнував би й не дозволив би вдертися до свого дому. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Тому і ви будьте готові, бо Син Людський прийде тієї години, про яку й не думаєте. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Хто вірний та розумний раб, якого господар поставив над іншими своїми слугами, щоб він давав їм їжу вчасно? ");
INSERT INTO ukronpu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Блаженний той раб, якого господар знайде, що він так робить. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Істинно кажу вам: він поставить його над усім своїм майном. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Але якщо той раб, будучи злим, скаже у своєму серці: «Мій господар запізнюється!» ");
INSERT INTO ukronpu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","– і почне бити своїх товаришів, їсти та пити з п’яницями, ");
INSERT INTO ukronpu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","то господар того раба прийде того дня, коли він не сподівається, і о тій годині, якої не знає. ");
INSERT INTO ukronpu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Він розітне його та призначить йому місце разом із лицемірами; там буде плач та скрегіт зубів. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Тоді Царство Небесне буде подібне до десяти дів, які взяли свої світильники й вийшли назустріч нареченому. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","П’ять із них були нерозумні, а п’ять – мудрі. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Нерозумні взяли світильники, але не взяли з собою олії. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","А мудрі разом зі своїми світильниками взяли й олію в глечиках. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Оскільки наречений запізнювався, усі задрімали й заснули. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Опівночі пролунав крик: «Ось наречений іде! Виходьте йому назустріч!» ");
INSERT INTO ukronpu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Тоді всі діви встали та приготували свої світильники. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Нерозумні сказали мудрим: «Дайте і нам вашої олії, бо наші світильники гаснуть». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","А мудрі у відповідь сказали: «Не можемо, щоб і нам часом не забракло. Ідіть і купіть собі». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Коли вони пішли купувати, прийшов наречений. Ті, що були готові, увійшли разом із ним на весілля, і ворота зачинилися. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Потім повернулися й інші діви та сказали: «Господарю! Господарю! Відчини нам!» ");
INSERT INTO ukronpu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Але він відповів: «Істинно кажу вам: я не знаю вас». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Отже, пильнуйте, бо не знаєте ні дня, ні години, коли Син Людський прийде! ");
INSERT INTO ukronpu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Подібно як чоловік, який, вирушивши в подорож, покликав своїх рабів і роздав їм своє майно. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Одному дав п’ять талантів, другому – два, іншому – один, кожному за його здібностями, і відразу вирушив. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Той, що отримав п’ять талантів, негайно пішов, вклав їх у діло й заробив ще п’ять. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Так само й той, що отримав два, заробив ще два. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","А той, що отримав один, пішов і закопав у землю срібло свого господаря. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Коли минуло багато часу, господар тих рабів повернувся, щоб розрахуватися з ними. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Прийшов той, що отримав п’ять талантів, приніс інші п’ять талантів і сказав: «Господарю, ти мені доручив п’ять талантів, ось я заробив ще п’ять талантів». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Господар сказав йому: «Добре, хороший та вірний рабе! У малому ти був вірний, над великим тебе поставлю. Увійди в радість твого господаря». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Прийшов той, що отримав два таланти, і сказав: «Господарю, ти мені доручив два таланти, ось я заробив ще два таланти». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Господар сказав йому: «Добре, хороший та вірний рабе! У малому ти був вірний, над великим тебе поставлю. Увійди в радість твого господаря». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Прийшов і той, що отримав один талант, і сказав: «Господарю, я знав, що ти жорстока людина: жнеш там, де не сіяв, і збираєш там, де не розкидав. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Я побоявся та пішов і сховав у землю твій талант. Ось твоє!» ");
INSERT INTO ukronpu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Господар сказав йому: «Злий та лукавий рабе! Ти знав, що я жну там, де не сіяв, і збираю там, де не розкидав?» ");
INSERT INTO ukronpu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Тобі слід було вкласти моє срібло в банк, щоб я, повернувшись, отримав своє з прибутком. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Заберіть від нього талант і віддайте тому, хто має десять талантів. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Бо тому, хто має, додасться, і матиме надмірно, а від того, хто не має, і те, що має, забереться. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","А цього негідного раба викиньте в зовнішню темряву, там буде плач та скрегіт зубів. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Коли ж прийде Син Людський у славі Своїй і всі ангели з Ним, тоді Він сяде на престолі Своєї слави. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Усі народи зберуться перед Ним, і Він відділить одних від інших, як пастух відділяє овець від кіз. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","І поставить овець праворуч від Себе, а кіз – ліворуч. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Тоді Цар скаже тим, хто праворуч: «Прийдіть, благословенні Мого Отця, й отримайте Царство, яке було приготовлене вам від початку світу. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Бо коли Я голодував, ви дали Мені їсти; коли страждав від спраги, ви дали Мені пити; коли був чужинцем, ви прийняли Мене; ");
INSERT INTO ukronpu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","коли був без одягу, ви одягли мене; коли був хворий, ви доглядали Мене; коли був у в’язниці, ви відвідали Мене». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Тоді праведні у відповідь скажуть Йому: «Господи, коли ми бачили Тебе голодним і нагодували, або спраглим і дали пити? ");
INSERT INTO ukronpu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Коли ми бачили Тебе чужинцем і прийняли, або без одягу та одягли? ");
INSERT INTO ukronpu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Коли бачили хворим або у в’язниці й прийшли до Тебе?» ");
INSERT INTO ukronpu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Цар відповість їм: «Істинно кажу вам: усе, що ви зробили одному з цих найменших Моїх братів, ви зробили Мені». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Тоді скаже тим, хто ліворуч: «Ідіть від Мене, прокляті, у вогонь вічний, який був приготовлений для диявола та його ангелів. ");
INSERT INTO ukronpu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Бо коли Я голодував, ви не дали Мені їсти; страждав від спраги, а ви не дали Мені пити; ");
INSERT INTO ukronpu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","коли був чужинцем, ви не прийняли Мене; коли був без одягу, ви не одягли Мене; коли був хворим і у в’язниці, ви не відвідали Мене». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Тоді вони у відповідь скажуть: «Господи, коли ми бачили Тебе голодним, або спраглим, або чужинцем, або без одягу, або хворим, або у в’язниці й не послужили Тобі?» ");
INSERT INTO ukronpu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Тоді Він відповість їм: «Істинно кажу вам: якщо ви не зробили це одному з цих найменших, то й Мені не зробили». ");
INSERT INTO ukronpu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","І підуть вони у вічне покарання, а праведні – у життя вічне. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Коли Ісус закінчив усе це говорити, Він звернувся до Своїх учнів: ");
INSERT INTO ukronpu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ви знаєте, що через два дні Пасха і Сина Людського буде видано на розп’яття». ");
INSERT INTO ukronpu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Тоді зібралися первосвященники та старійшини народу у дворі первосвященника, на ім’я Каяфа. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","І змовилися підступом схопити та вбити Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Але говорили: «Не у свято, щоб не сталося заворушення в народі». ");
INSERT INTO ukronpu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ісус був у Віфанії, у домі Симона прокаженого. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Коли Він сидів за столом, до Нього підійшла жінка, яка принесла алебастровий глечик із дуже дорогим миром, і вилила його на голову Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Побачивши це, учні обурилися й сказали: ―Навіщо така трата? ");
INSERT INTO ukronpu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Адже це миро можна було продати дорого та роздати бідним. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Але Ісус, знаючи це, сказав їм: ―Чому ви докоряєте жінці? Адже вона зробила добре діло для Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Бідних ви завжди маєте з собою,а Мене не завжди матимете. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Виливши миро на Моє тіло, вона приготувала Мене до поховання. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Істинно кажу вам: всюди, де буде проповідуватись ця Добра Звістка у всьому світі, будуть казати й те, що вона зробила, на згадку про неї. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Тоді один із дванадцятьох, якого звали Юда Іскаріот, пішов до первосвященників ");
INSERT INTO ukronpu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","і сказав: «Що ви дасте мені, якщо я віддам вам Ісуса?» Вони ж заплатили йому тридцять срібних монет. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Відтоді він шукав слушної нагоди, щоб Його видати. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","У перший день свята Опрісноків учні підійшли та запитали Ісуса: ―Де Ти хочеш, щоб ми приготували Тобі спожити Пасху? ");
INSERT INTO ukronpu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Він відповів: ―Ідіть у місто до такого-то чоловіка й скажіть йому: «Учитель каже: „Мій час наблизився, у тебе Я буду споживати Пасху з Моїми учнями“». ");
INSERT INTO ukronpu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Учні зробили, як наказав їм Ісус, та приготували там Пасху. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Коли ж настав вечір, Він сів до столу разом із дванадцятьма. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","А як вони їли, Ісус сказав їм: ―Істинно кажу вам: один із вас зрадить Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Вони дуже засмутилися й почали запитувати Його, один за одним: ―Це не я, Господи? ");
INSERT INTO ukronpu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Він сказав у відповідь: ―Той, хто опустить руку разом зі Мною в миску, той Мене зрадить. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Син Людський, безумовно, іде, як про Нього написано, але горе тому чоловікові, через якого зраджено Сина Людського. Було б краще тому чоловікові не народжуватись. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Юда, який зрадив Його, спитав: ―Це не я, Равві? Ісус відповів йому: ―Ти сказав! ");
INSERT INTO ukronpu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Коли вони їли, Ісус узяв хліб, благословив його, розламав та дав учням, кажучи: «Візьміть та їжте, це є тіло Моє». ");
INSERT INTO ukronpu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Потім узяв чашу, подякував і дав її учням, кажучи: «Пийте з неї всі, ");
INSERT INTO ukronpu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","бо це кров Моя, кров Нового Завіту, яка проливається за багатьох для прощення гріхів. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Кажу вам: не питиму більше з цього виноградного плоду до дня, коли питиму з вами нове вино в Царстві Мого Отця». ");
INSERT INTO ukronpu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","І, проспівавши пісні, вони пішли на Оливну гору. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Тоді Ісус сказав учням: ―Усі ви відмовитесь від Мене цієї ночі, бо написано: «Уражу пастиря – і вівці отари розсіються». ");
INSERT INTO ukronpu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Але після Мого воскресіння Я піду до Галілеї, і там ми зустрінемось. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Тоді Петро відповів Йому: ―Навіть якщо всі зречуться Тебе, я ніколи не зречусь. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ісус сказав йому: ―Істинно кажу тобі: цієї ночі, перед тим, як півень заспіває, ти тричі зречешся Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Петро ж наполягав: ―Навіть якщо треба буде померти разом із Тобою, усе одно я не зречуся. І всі учні сказали так само. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Тоді Ісус разом із ними прийшов до місця, яке називається Гефсиманія, і сказав учням: ―Посидьте тут, поки Я піду й помолюся там. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","І, узявши з Собою Петра та обох синів Зеведеєвих, почав сумувати та тривожитись. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Тоді сказав їм: ―Моя душа страждає смертельно! Залишайтеся тут та пильнуйте зі Мною. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","І, відійшовши трохи далі, Він упав долілиць та молився кажучи: «Отче Мій, якщо можливо, нехай ця чаша обмине Мене. Однак нехай буде не як Я хочу, а як Ти». ");
INSERT INTO ukronpu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Повернувшись до учнів, знайшов, що вони заснули, та сказав Петрові: ―Ви не могли навіть однієї години пильнувати зі Мною? ");
INSERT INTO ukronpu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Пильнуйте та моліться, щоб вам не впасти в спокусу. Бо дух бадьорий, а тіло немічне. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","І вдруге Він відійшов та молився кажучи: «Отче Мій, якщо неможливо, щоб ця чаша Мене обминула і щоб Я не пив її, то нехай станеться Твоя воля!» ");
INSERT INTO ukronpu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Коли Він повернувся до учнів, знову знайшов, що вони сплять, бо їхні очі були обтяжені. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Залишивши їх утретє, Він ще раз пішов молитися, промовляючи ті ж слова. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Потім прийшов до учнів і сказав їм: ―Ви все ще спите та відпочиваєте? Ось наблизилась година, і Син Людський віддається в руки грішників. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Вставайте, ходімо! Ось наближається Мій зрадник. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Коли Він ще говорив, ось підійшов Юда, один із дванадцятьох, і з ним великий натовп із мечами та киями – від первосвященників та старійшин народу. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Зрадник дав їм такий знак, кажучи: «Той, Кого я поцілую, це Він, арештовуйте Його!» ");
INSERT INTO ukronpu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Він одразу підійшов до Ісуса й промовив: ―Вітаю, Равві! – і поцілував Його. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ісус сказав йому: ―Друже, роби те, для чого ти прийшов! Тоді вони підійшли, наклали на Ісуса руки та заарештували Його. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","І ось один із тих, що були з Ісусом, простягнув руку, вихопив свій меч, ударив раба первосвященника й відрубав йому вухо. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Тоді Ісус сказав: «Поверни свого меча на його місце! Бо всі, хто береться за меч, від меча загинуть. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Чи ти думаєш, що Я не можу просити Отця Мого надіслати зараз більше дванадцяти легіонівангелів? ");
INSERT INTO ukronpu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Але як тоді сповниться Писання, яке каже, що так має статися?» ");
INSERT INTO ukronpu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","У той час Ісус звернувся до натовпу: «Ви вийшли проти Мене, як проти розбійника, з мечами та киями, щоб заарештувати Мене. Щодня Я сидів та навчав у Храмі, і ви не заарештовували Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Але все це сталося, щоб збулося Писання пророків». Тоді всі учні, залишивши Його, втекли. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ті, що схопили Ісуса, привели Його до первосвященника Каяфи, де зібралися книжники та старійшини. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Петро ж ішов за Ісусом на відстані до двору первосвященника й, зайшовши всередину, сів разом зі слугами, щоб побачити, чим усе скінчиться. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Первосвященники й весь Синедріон шукали неправдивого свідчення проти Ісуса, щоб засудити Його на смерть, ");
INSERT INTO ukronpu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","але не знаходили, хоча прийшло багато лжесвідків. Наостанок прийшли двоє, ");
INSERT INTO ukronpu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","які сказали: ―Він говорив: «Я можу зруйнувати Храм Божий і за три дні відбудувати його». ");
INSERT INTO ukronpu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Первосвященник, піднявшись, запитав Ісуса: ―Нічого не відповідаєш на те, що вони свідчать проти Тебе? ");
INSERT INTO ukronpu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Але Ісус мовчав. Первосвященник запитав Його: ―Заклинаю Тебе живим Богом, скажи нам: Ти – Христос, Син Божий? ");
INSERT INTO ukronpu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ісус відповів йому: ―Ти сказав це! Навіть більше скажу вам: відтепер побачите Сина Людського, Який сидить праворуч від Всемогутнього й приходить на хмарах небесних! ");
INSERT INTO ukronpu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Тоді первосвященник розірвав на собі одяг та сказав: ―Він богохульствує! Навіщо нам потрібні свідки? Ось тепер ви чули богохульство! ");
INSERT INTO ukronpu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Яке ваше рішення? Вони відповіли: ―Він заслуговує на смерть! ");
INSERT INTO ukronpu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Тоді почали плювати Ісусові в обличчя та бити кулаками, а інші били Його по щоках, ");
INSERT INTO ukronpu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","кажучи: «Пророкуй нам, Христе, хто Тебе вдарив?» ");
INSERT INTO ukronpu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Петро ж сидів назовні, у дворі. До нього підійшла одна зі служниць і сказала: ―І ти був з Ісусом із Галілеї. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Але Петро заперечив перед усіма, кажучи: ―Не знаю, про що ти говориш. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Коли він виходив за ворота, його побачила інша служниця й сказала тим, що були там: ―Цей чоловік теж був з Ісусом із Назарета. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Петро знову заперечив, поклявшись, що не знає Цього Чоловіка. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Згодом підійшли ті, що стояли там, і сказали Петрові: ―Ти й справді один із них, бо й мова твоя викриває тебе. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Тоді він почав клястися та присягати кажучи: ―Не знаю Цього Чоловіка! І одразу заспівав півень. ");
INSERT INTO ukronpu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Тоді Петро згадав слова, які сказав Ісус: «Перед тим, як заспіває півень, ти тричі зречешся Мене». І, вийшовши геть, він гірко заплакав. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Рано-вранці всі первосвященники та старійшини народу зібралися, щоб винести Ісусові смертельний вирок. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Вони зв’язали Ісуса та повели й передали Його Пилатові, наміснику. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Коли Юда-зрадник побачив, що Ісуса засуджено, він розкаявся й повернув тридцять срібників первосвященникам та старійшинам. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Він сказав: ―Я згрішив, видавши Невинного Чоловіка. А вони відповіли: ―Що нам до того? Твоє діло. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Тоді, кинувши срібло в Храмі, він вийшов та пішов і повісився. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Первосвященники взяли срібло та сказали: «Не годиться ставити ці гроші в Храмову скарбницю, бо вони є платою за кров». ");
INSERT INTO ukronpu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Порадившись, вони купили поле гончаря для похорону чужинців. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Тому те поле називається «Полем крові» до сьогоднішнього дня. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Тоді виповнилось сказане через пророка Єремію: «І взяли тридцять срібників – ціну Оціненого синами Ізраїля, ");
INSERT INTO ukronpu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","і віддали за поле гончаря, як наказав мені Господь». ");
INSERT INTO ukronpu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ісус представ перед намісником, і той запитав Його: ―Ти Цар юдеїв? Ісус відповів: ―Ти кажеш це! ");
INSERT INTO ukronpu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Коли первосвященники та старійшини звинувачували Його, Він нічого не відповідав. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Тоді Пилат запитав Його: ―Не чуєш, скільки проти Тебе свідчать? ");
INSERT INTO ukronpu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Але Він не відповідав йому на жодне слово, так що намісник дуже здивувався. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","На кожне свято намісник мав звичай відпускати народові одного з в’язнів, якого вони бажали. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Був тоді один відомий в’язень, на ім’я Ісус Варавва. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Коли вони зібралися, Пилат запитав: ―Кого з двох бажаєте, щоб я відпустив вам: Ісуса Варавву чи Ісуса, Який називається Христом? ");
INSERT INTO ukronpu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Бо він знав, що через заздрощі видали Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Поки Пилат сидів на місці для судді, його дружина надіслала до нього сказати: «Не роби нічого цьому Праведникові, бо сьогодні уві сні я багато страждала через Нього». ");
INSERT INTO ukronpu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Але первосвященники й старійшини переконали людей, щоб просили відпустити їм Варавву й вбити Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Намісник запитав: ―Кого з цих двох хочете звільнити? Вони відповіли: ―Варавву! ");
INSERT INTO ukronpu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Тоді Пилат звернувся до них: ―А що мені робити з Ісусом, Який зветься Христом? Вони всі сказали: ―Хай буде розіп’ятий! ");
INSERT INTO ukronpu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Він спитав: ―Яке ж зло Він скоїв? Але вони ще сильніше закричали: ―Хай буде розіп’ятий! ");
INSERT INTO ukronpu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Коли Пилат побачив, що нічого не може зробити й що заворушення в народі тільки зростає, він узяв воду та вмив руки перед натовпом, кажучи: ―Я не винний в Його крові! Дивіться самі! ");
INSERT INTO ukronpu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Увесь народ відповів: ―Нехай Його кров буде на нас і на наших дітях! ");
INSERT INTO ukronpu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Тоді Пилат відпустив їм Варавву, а Ісуса наказав бичувати та віддав на розп’яття. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Після цього воїни намісника відвели Ісуса в преторію, де біля Нього зібрали всю когорту. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Вони роздягли Його й накинули на Нього багряницю. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Сплели та поклали на голову вінок із тернини, а в праву руку дали тростину. І, вклонивши коліна перед Ним, глузували з Нього, кажучи: «Вітаємо Тебе, Царю юдеїв!» ");
INSERT INTO ukronpu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Потім вони плювали на Нього й, узявши тростину, били нею Ісуса по голові. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Коли закінчили знущатися, зняли з Ісуса плащ, надягнули на Нього Його одяг і відвели на розп’яття. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Коли вони виходили, то зустріли чоловіка з Кирени, на ім’я Симон, і змусили його нести хрест Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Коли прийшли на місце, яке називалося Голгофа (що означає «місце Черепа»), ");
INSERT INTO ukronpu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","дали Йому випити вина, змішаного з жовчю. Але, скуштувавши, Він не захотів випити. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Розіп’явши Ісуса, вони розділили між собою Його одяг, кидаючи жереб. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","А потім сіли там і стерегли Його. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Над Його головою прибили напис, на якому була Його провина: це ісус, цар юдеїв. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Тоді ж разом із Ним розіп’яли і двох розбійників: одного – праворуч, а іншого – ліворуч від Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ті, що проходили повз, богохульствували проти Нього. Вони хитали головами ");
INSERT INTO ukronpu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","й казали: «Ти ж збирався зруйнувати Храм і відбудувати його за три дні. Спаси Себе Самого. Якщо Ти Син Божий, то зійди з хреста!» ");
INSERT INTO ukronpu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Первосвященники разом із книжниками та старійшинами також насміхалися з Нього, кажучи: ");
INSERT INTO ukronpu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Інших рятував, а Себе не може врятувати! Якщо Він насправді Цар Ізраїля, то нехай зараз зійде з хреста, і ми повіримо в Нього! ");
INSERT INTO ukronpu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Він покладався на Бога, тож нехай тепер Бог врятує Його, якщо хоче. Адже Він казав: „Я Син Божий!“». ");
INSERT INTO ukronpu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Розбійники, розіп’яті разом із Ним, також насміхалися з Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Від шостої години настала темрява по всій землі – аж до дев’ятої години. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Десь о дев’ятій годині Ісус закричав гучним голосом: «Елі, Елі, лема савахтані?», що означає: «Боже Мій, Боже Мій, чому Ти покинув Мене?» ");
INSERT INTO ukronpu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Деякі з тих, що там стояли, почувши це, казали: «Він кличе Іллю!» ");
INSERT INTO ukronpu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Один із них одразу ж побіг, узяв губку, наповнив її кислим вином, настромив на тростину й дав Йому пити. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","А інші казали: «Облиш, побачимо, чи прийде Ілля спасти Його!» ");
INSERT INTO ukronpu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Але Ісус, знову голосно скрикнувши, віддав духа. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","І ось завіса в Храмі розірвалася надвоє зверху донизу, земля затряслася, і скелі розкололися. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Гроби відкрилися, і багато тіл померлих святих воскресло. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","І, вийшовши з гробів після воскресіння Ісуса, увійшли до святого міста та явилися багатьом. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Коли сотник і ті, що з ним стерегли Ісуса, побачили землетрус і те, що сталося, вони дуже злякалися й сказали: «Цей чоловік справді був Сином Божим!» ");
INSERT INTO ukronpu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Там було багато жінок, які стояли поодаль і дивилися. Вони прийшли за Ісусом із Галілеї та служили Йому. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Серед них були Марія Магдалина, Марія – мати Якова та Йосифа, і мати синів Зеведеєвих. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Коли настав вечір, прийшов багатий чоловік з Ариматеї, на ім’я Йосиф, який теж був учнем Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Він пішов до Пилата та попросив тіло Ісуса, і тоді Пилат наказав віддати тіло Йосифові. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Йосиф узяв тіло Ісуса, обгорнув у чисту льняну тканину ");
INSERT INTO ukronpu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","й поклав до своєї нової гробниці, яку висік у скелі. До входу в гробницю привалив великий камінь. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","А були там Марія Магдалина та друга Марія, які стояли навпроти гробниці. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Наступного дня, що після дня Приготування, первосвященники та фарисеї зібралися разом у Пилата ");
INSERT INTO ukronpu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","й сказали: ―Володарю, ми пригадали, що Той обманщик, коли ще був живий, казав: «Через три дні Я воскресну!» ");
INSERT INTO ukronpu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Тож накажи стерегти гробницю до третього дня. Щоб Його учні, прийшовши, не вкрали Його й не сказали народові, що Він воскрес із мертвих. І останній обман буде гірший від першого. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Тоді Пилат відповів: ―Ви маєте охорону, ідіть та охороняйте, як знаєте. ");
INSERT INTO ukronpu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Вони пішли, поставили охорону біля гробниці та закріпили камінь печаткою. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Після Суботи, на світанку першого дня тижня, Марія Магдалина та друга Марія прийшли подивитись на гробницю. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","І ось стався великий землетрус, бо ангел Господній, зійшовши з неба, підійшов, відкотив камінь від гробниці та сів на нього. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Його вигляд був, як блискавка, а одяг був білий, як сніг. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Від страху охорона затремтіла перед ним і стала, як мертва. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ангел сказав жінкам: «Не бійтеся! Я знаю, що ви шукаєте Ісуса, Який був розіп’ятий. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Немає Його тут: Він воскрес, як і казав. Підійдіть та подивіться на місце, де Він лежав. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ідіть скоріше та скажіть Його учням, що Він воскрес із мертвих. Він іде перед вами в Галілею, там Його побачите. Ось я сказав вам». ");
INSERT INTO ukronpu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Тоді жінки швидко відійшли від гробниці й зі страхом та великою радістю побігли й розповіли про все Його учням. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","І ось Ісус зустрів їх та сказав: «Радійте!» Вони ж наблизились, обійняли Його ноги та вклонилися Йому. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Тоді Ісус сказав їм: «Не бійтеся! Ідіть та сповістіть Моїх братів, щоб ішли до Галілеї, там Мене побачать». ");
INSERT INTO ukronpu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Коли вони ще йшли, деякі охоронці прийшли до міста й сповістили первосвященників про все, що сталося. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Тоді вони зібралися разом зі старійшинами й вирішили дати воїнам багато грошей, ");
INSERT INTO ukronpu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","сказавши їм: «Кажіть, що Його учні прийшли вночі та вкрали Його, поки ви спали». ");
INSERT INTO ukronpu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","А якщо про це почує намісник, ми його переконаємо та позбавимо вас від неприємностей. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Вони взяли гроші та вчинили, як були навчені. І ця чутка поширилась серед юдеїв до сьогоднішнього дня. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","А одинадцять учнів пішли до Галілеї, на гору, куди Ісус звелів їм прийти. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Там вони побачили Ісуса й вклонилися Йому, однак дехто з них засумнівався. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ісус підійшов до них та промовив: «Мені дана вся влада на небі й на землі. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Тож ідіть і зробіть учнями всі народи, охрещуючи їх в ім’я Отця, і Сина, і Святого Духа. ");
INSERT INTO ukronpu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Навчіть їх виконувати все, що Я заповів вам. І ось Я з вами в усі дні аж до кінця світу».");
INSERT INTO ukronpu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Початок Доброї Звістки Ісуса Христа, Сина Божого. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Як написано в пророка Ісаї: «Ось Я посилаю Мого посланця перед обличчям Твоїм, який приготує дорогу перед Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Голос кличе в пустелі: „Приготуйте дорогу Господеві, вирівняйте шляхи для Нього!“» ");
INSERT INTO ukronpu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","У пустелі з’явився Іван, який хрестив людей та проповідував хрещення покаяння для прощення гріхів. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","І приходили до нього люди з усієї Юдейської землі та всі мешканці Єрусалима й були охрещені Іваном у річці Йордані, визнаючи свої гріхи. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Іван носив одяг із верблюжої шерсті й шкіряний пояс довкола стегон. Він їв сарану та дикий мед. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Він проповідував та казав: «Після мене йде Сильніший за мене, Якому я не достойний навіть, схилившись, розв’язати ремінці Його сандалій. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Я хрещу вас водою, а Він буде хрестити вас Духом Святим». ");
INSERT INTO ukronpu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","У ті дні прийшов Ісус із Назарета, що в Галілеї, та був хрещений Іваном у Йордані. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Коли Ісус виходив із води, то відразу побачив розкриті небеса та Духа, Який сходив на Нього, як голуб. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","І голос із неба пролунав: «Ти Син Мій улюблений, Тебе Я вподобав!» ");
INSERT INTO ukronpu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","І зразу ж Дух повів Ісуса в пустелю. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Він пробув сорок днів у пустелі, і сатана спокушав Його. Там Він перебував серед диких звірів, і ангели служили Йому. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Після ув’язнення Івана Ісус прийшов до Галілеї, проповідуючи Добру Звістку Бога. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Він казав: «Настав час, і наблизилося Царство Боже. Покайтеся та увіруйте в Добру Звістку!» ");
INSERT INTO ukronpu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Коли Ісус проходив біля Галілейського моря, то побачив Симона та Андрія, брата Симонового, які закидали сіті в море, оскільки були рибалками. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ісус сказав їм: «Ідіть за Мною, і Я зроблю вас ловцями людей». ");
INSERT INTO ukronpu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Вони відразу залишили сіті та пішли за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Потім пішов трохи далі й побачив Якова, сина Зеведеєва, та Івана, його брата. Вони були в човні та лагодили сіті. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Він зараз же покликав їх. Вони залишили свого батька Зеведея з наймитами в човні та пішли за Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Коли прийшли до Капернаума, то відразу в Суботу пішли до синагоги, де Він почав навчати. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Люди дивувалися Його вченню, бо Він навчав їх як Той, Хто має владу, а не як книжники. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Саме тоді в синагозі був чоловік, одержимий нечистим духом. Він закричав ");
INSERT INTO ukronpu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","кажучи: ―Що Тобі до нас, Ісусе з Назарета? Ти прийшов знищити нас? Я знаю, Хто Ти – Святий Божий! ");
INSERT INTO ukronpu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Але Ісус наказав йому: ―Замовкни та вийди з нього! ");
INSERT INTO ukronpu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Тоді нечистий дух почав трясти чоловіка в конвульсіях і, голосно закричавши, вийшов із нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Усі здивувалися, так що запитували одне одного: «Що це таке? Нове вчення, яке має владу! Він наказує нечистим духам, і вони слухаються Його!» ");
INSERT INTO ukronpu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Звістка про Ісуса негайно розійшлася всюди, по всій Галілейській околиці. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Коли вийшли з синагоги, вони з Яковом та Іваном відразу прийшли в дім Симона та Андрія. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Теща Симона лежала в гарячці, тож зараз же сказали Ісусові про неї. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Він підійшов, узяв її за руку та підняв, і гарячка залишила жінку, так що вона почала прислуговувати їм. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Коли ж настав вечір, після заходу сонця, привели до Нього багатьох хворих та біснуватих. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Усе місто зібралося перед дверима. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Він зцілив багатьох хворих на різні недуги та з багатьох вигнав демонів. Не дозволяв демонам говорити, бо вони знали, Хто Він. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Рано-вранці Ісус встав ще до світанку, вийшов та пішов у пустинне місце й там молився. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Симон і ті, що були з ним, пішли шукати Його ");
INSERT INTO ukronpu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","й, знайшовши, сказали Йому: ―Усі шукають Тебе! ");
INSERT INTO ukronpu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Він відповів їм: ―Ходімо до інших міст, у сусідні села, щоб Я і там проповідував, адже для цього Я прийшов. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Він пішов та проповідував у їхніх синагогах по всій Галілеї, виганяючи демонів. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Одного разу до Нього прийшов прокажений, упав на коліна й благав: ―Якщо хочеш, можеш мене очистити. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ісус, змилосердившись, простягнув руку, доторкнувся до нього й промовив: ―Хочу, будь чистим! ");
INSERT INTO ukronpu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Тієї ж миті проказа залишила його, і він був очищений. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ісус негайно відіслав його та попередив ");
INSERT INTO ukronpu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","кажучи: ―Дивись, нікому не кажи нічого, але йди, покажи себе священникові та принеси жертву за своє очищення, як наказав Мойсей, їм на свідчення. ");
INSERT INTO ukronpu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Але той пішов і почав всюди проповідувати та поширювати цю звістку, так що Ісус більше не міг відкрито увійти в місто, а перебував у пустинних місцях, і люди приходили до Нього звідусіль. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Коли через декілька днів Ісус знов прийшов до Капернаума, розійшлася чутка, що Він удома. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Тоді зібралося так багато людей, що не було вже місця навіть біля дверей. Коли Ісус проповідував їм Слово, ");
INSERT INTO ukronpu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","прийшли до Нього якісь люди із паралізованим, якого несли четверо. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Побачивши, що не можуть пройти через натовп, вони зійшли на покрівлю й, розібравши її там, де був Ісус, спустили ліжко, на якому лежав паралізований. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Побачивши їхню віру, Ісус сказав паралізованому: «Сину, прощаються тобі гріхи!» ");
INSERT INTO ukronpu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Деякі книжники, які там сиділи, міркували у своїх серцях: ");
INSERT INTO ukronpu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Чому Він так говорить? Він богохульствує! Хто може прощати гріхи, окрім одного Бога?» ");
INSERT INTO ukronpu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Але Ісус, відразу дізнавшись Своїм Духом, про що вони в собі міркують, запитав їх: «Чому ви так роздумуєте у ваших серцях? ");
INSERT INTO ukronpu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Що легше сказати паралізованому: „Прощаються твої гріхи!“ чи „Встань, візьми своє ліжко й ходи!“? ");
INSERT INTO ukronpu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Але щоб ви знали: Син Людський має владу на землі прощати гріхи». І сказав паралізованому: ");
INSERT INTO ukronpu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Кажу тобі: встань, візьми своє ліжко та йди додому!» ");
INSERT INTO ukronpu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Той відразу ж встав, узяв своє ліжко та на очах у всіх вийшов. Усі були здивовані та прославляли Бога, кажучи: «Ніколи ми такого ще не бачили!» ");
INSERT INTO ukronpu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ісус знову пішов до моря. Увесь натовп приходив до Нього, і Він навчав їх. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Проходячи далі, Він побачив Левія, сина Алфеєвого, який сидів при збиранні мита, і сказав йому: «Іди за Мною!» Той, вставши, пішов за Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","І сталося, коли Ісус сидів за столом у домі Левія, то багато митників та грішників їли разом з Ісусом та Його учнями, адже їх було чимало, і вони слідували за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Книжники та фарисеї, побачивши, що Він їсть разом із митниками й грішниками, сказали Його учням: ―Чому Він їсть разом із митниками й грішниками? ");
INSERT INTO ukronpu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Але Ісус, почувши це, відповів їм: ―Не здорові потребують лікаря, а хворі. Я прийшов покликати до покаяння не праведних, а грішників. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","У той час, коли учні Івана та фарисеїв постилися, вони підійшли до Ісуса й запитали Його: ―Чому Іванові учні та учні фарисеїв постять, а Твої учні не постять? ");
INSERT INTO ukronpu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ісус відповів: ―Чи можете друзів нареченого змусити постити, доки наречений з ними? Доки наречений з ними, не можуть постити. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Але настануть дні, коли наречений забереться від них, і тоді, того дня, поститимуть. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ніхто не пришиває латки з нової тканини до старої одежі, адже латка з нової тканини збіжиться та відірве зі старої одежі, і діра стає ще більшою. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ніхто не вливає молодого вина в старі бурдюки, бо молоде вино розірве бурдюки – і вино та бурдюки пропадуть. Але молоде вино вливають у нові бурдюки. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Довелося Ісусові в Суботу проходити через засіяні поля. Його учні почали дорогою зривати колосся. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Фарисеї сказали Йому: ―Дивись! Чому вони в Суботу роблять те, чого не дозволено? ");
INSERT INTO ukronpu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Він сказав їм: ―Ви ніколи не читали, що зробив Давид,коли був у нужді й зголоднів він, а також і ті, що були з ним? ");
INSERT INTO ukronpu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Як увійшов у Дім Божий у часи первосвященника Авіатара та з’їв хліби покладання, котрі не дозволено їсти нікому, окрім священників,і як дав і тим, хто був із ним? ");
INSERT INTO ukronpu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Потім сказав їм: ―Субота створена для людини, а не людина для Суботи. ");
INSERT INTO ukronpu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Адже Син Людський – Господь і Суботи. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ісус знову зайшов у синагогу. Там був чоловік із всохлою рукою. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Фарисеї уважно стежили за Ісусом, чи зцілить його в Суботу, щоб звинуватити Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ісус сказав чоловікові, що мав всохлу руку: «Стань посередині!» ");
INSERT INTO ukronpu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Потім сказав їм: «У Суботу дозволено робити добро чи зло? Спасати життя чи вбивати?» Але вони мовчали. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Подивившись на них з обуренням та скорботою через впертість їхніх сердець, Він сказав чоловікові: «Простягни руку!» Той простягнув, і його рука була зцілена. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Фарисеї ж вийшли та радились з іродіанами проти Нього, як Його вбити. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ісус же разом зі Своїми учнями відійшов до моря. За Ним ішов великий натовп із Галілеї та Юдеї, ");
INSERT INTO ukronpu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Єрусалима, Ідумеї, з-за Йордану, з Тира та Сидона. Багато людей, почувши, що Він робить, прийшли до Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ісус звелів Своїм учням приготувати для Нього невеликий човен, щоб натовп не тиснув на Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Адже Він зцілив багатьох, і всі, що мали недуги, тиснулися, аби доторкнутися до Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Нечисті духи, коли бачили Його, падали долілиць перед Ним та кричали: «Ти – Син Божий!» ");
INSERT INTO ukronpu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Однак Він суворо наказував їм, щоб не виявляли Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ісус зійшов на гору та покликав до Себе, кого схотів Він, і вони прийшли до Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","І обрав дванадцятьох, яких назвав апостолами, щоб були з Ним, щоб посилати їх проповідувати ");
INSERT INTO ukronpu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","і щоб вони мали владу виганяти демонів. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Він обрав дванадцятьох: Симона, якому дав ім’я Петро, ");
INSERT INTO ukronpu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Якова, сина Зеведеєвого, і його брата Івана, яких назвав Воанергес, що означає «сини грому», ");
INSERT INTO ukronpu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Андрія, Филипа, Варфоломія, Матвія, Фому, Якова, сина Алфеєвого, Тадея, Симона Кананита ");
INSERT INTO ukronpu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","і Юду Іскаріота, який зрадив Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Потім, коли прийшов додому, знову зібрався великий натовп, так що Ісус та Його учні не могли навіть поїсти. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Рідні Ісуса, почувши про це, прийшли, щоб забрати Його, бо казали: «Він втратив розум». ");
INSERT INTO ukronpu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Книжники, які прийшли з Єрусалима, казали: «Він одержимий Вельзевулом! Він виганяє демонів силою володаря демонів». ");
INSERT INTO ukronpu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Тоді Ісус, покликавши їх до Себе, сказав їм притчами: «Як може сатана виганяти сатану? ");
INSERT INTO ukronpu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Якщо якесь царство розділене в собі, таке царство не зможе встояти. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","І якщо якийсь дім розділений в собі, такий дім не зможе встояти. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Якщо сатана повстав проти самого себе й розділився, то не зможе встояти. Але йому прийшов кінець. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ніхто не може увійти в дім сильного та пограбувати його майно, якщо спочатку не зв’яже сильного. Лише тоді пограбує його дім. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Істинно кажу вам: людям простяться всі гріхи та всі богохульства, ");
INSERT INTO ukronpu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","але той, хто богохульствує проти Святого Духа, не має прощення довіку, а має вічну провину». ");
INSERT INTO ukronpu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Він сказав це, бо вони говорили: «Він одержимий нечистим духом». ");
INSERT INTO ukronpu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Прийшли Його мати та брати і, стоячи надворі, послали до Нього, щоб покликати Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Люди, що сиділи навколо Нього, сказали Йому: ―Ось Твоя мати, Твої брати та сестри стоять надворі та кличуть Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Він відповів: ―Хто Моя мати і Мої брати? ");
INSERT INTO ukronpu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","І, подивившись на тих, хто сидів навколо, сказав: ―Ось Моя мати та Мої брати. ");
INSERT INTO ukronpu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Бо той, хто виконує волю Божу, є Мені братом, сестрою і матір’ю. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ісус знов почав навчати на березі моря. І зібрався біля Нього великий натовп, так що Він зайшов у човен та сів у ньому на морі, а всі люди були біля моря, на березі. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Він багато навчав їх притчами й казав до них у Своєму навчанні: ");
INSERT INTO ukronpu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Слухайте! Ось сіяч вийшов сіяти. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Коли він сіяв, деякі зерна впали біля дороги; прилетіли птахи та повидзьобували їх. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Інші впали на кам’янистий ґрунт, де не було багато землі, і відразу проросли, бо земля була неглибока. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Коли зійшло сонце, то опалило паростки, вони зів’яли й, не маючи коріння, всохли. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ще інші впали поміж терни. Терни виросли та задушили їх, і не дали врожаю. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","А інші впали в добру землю та дали врожай, який зійшов, виріс та вродив у тридцять, у шістдесят та в сто разів більше». ");
INSERT INTO ukronpu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","І сказав: «Хто має вуха, щоб слухати, слухайте!» ");
INSERT INTO ukronpu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Коли Ісус залишився на самоті, ті, що були разом із Ним та дванадцятьма, запитали Його про притчі. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Він відповів: «Вам дана таємниця Царства Божого, а для тих, хто ззовні, усе в притчах, ");
INSERT INTO ukronpu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","щоб „дивлячись очима, не бачили і, слухаючи вухами, не розуміли, щоб не повернулися і щоб не були прощені!“» ");
INSERT INTO ukronpu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Потім сказав: «Невже ви не зрозуміли цієї притчі? Як тоді ви зрозумієте всі притчі? ");
INSERT INTO ukronpu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Сіяч сіє Слово. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Те, що посіяне біля дороги, – це ті, що чують Слово; але коли чують, відразу приходить сатана й забирає Слово, посіяне в них. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Посіяне на кам’янисту землю означає тих, що, почувши Слово, відразу з радістю приймають його. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Але не мають коріння в собі, є тимчасовими. Коли настають труднощі або гоніння за Слово, вони відразу відпадають. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Посіяне серед тернів означає тих, що чують Слово, ");
INSERT INTO ukronpu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","але турботи цього віку, омана багатства та інших бажань придушують Слово, і воно залишається безплідним. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","А посіяне в добру землю означає тих, що чують Слово, приймають його та приносять врожай: один у тридцять, інший у шістдесят, інший у сто разів більший». ");
INSERT INTO ukronpu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ісус сказав їм: «Хіба хтось приносить світильник, щоб поставити його під посудину або під ліжко? Ні, його приносять, щоб поставити на поставець. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Бо немає нічого прихованого, що не було б відкритим, і нічого таємного, що не виявилося б. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Якщо хтось має вуха, нехай слухає!» ");
INSERT INTO ukronpu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","І сказав їм: «Будьте уважні, що ви чуєте. Адже якою мірою міряєте ви, такою і вам виміряють і додадуть вам. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Бо тому, хто має, додасться, і матиме надмірно, а від того, хто не має, і те, що має, забереться». ");
INSERT INTO ukronpu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Він сказав: «Царство Боже схоже на чоловіка, який засіяв поле. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","І чи спить чоловік, чи прокидається, вночі чи вдень, насіння сходить та росте, а як це – він сам не знає. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Земля сама приносить плід: спочатку стебло, потім колос, а потім повний колос зерна. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Коли ж врожай дозріває, він одразу надсилає женців із серпами, бо настали жнива». ");
INSERT INTO ukronpu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","І сказав Він: «До чого подібне Царство Боже? Якою притчею його пояснити? ");
INSERT INTO ukronpu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Воно подібне до гірчичного зерна. Коли його сіють у землю, воно є найменшим серед усього насіння на землі, ");
INSERT INTO ukronpu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","але коли виростає, стає більшим за всі рослини й пускає великі гілки, так що птахи небесні можуть гніздитися в його тіні». ");
INSERT INTO ukronpu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Багатьма такими притчами Він говорив їм Слово, стільки, скільки вони могли зрозуміти. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Не говорив їм без притчі, але коли був наодинці зі Своїми учнями, пояснював їм усе. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Коли настав вечір, Ісус сказав їм: «Переплиньмо на другий бік». ");
INSERT INTO ukronpu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Відпустивши людей, вони сіли в човен, де вже був Ісус. Інші човни попливли за ними. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","І здійнялася велика буря, і хвилі почали заливати човен, так що він вже наповнювався водою. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ісус був на кормі та спав на подушці. Учні розбудили Його, кажучи: ―Учителю, невже Тобі байдуже, що ми гинемо? ");
INSERT INTO ukronpu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Уставши, Він наказав вітрові та сказав морю: ―Тихо! Заспокойся! Вітер стих, і настала велика тиша. ");
INSERT INTO ukronpu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Він сказав їм: ―Чому ви злякалися? Чому ви все ще не маєте віри? ");
INSERT INTO ukronpu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Перелякані, вони казали один одному: ―Хто ж Він такий, що навіть вітер та море підкоряються Йому? ");
INSERT INTO ukronpu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Вони перепливли на другий берег Генезаретського моря, у землю Герасинську. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Коли Ісус вийшов із човна, відразу назустріч Йому вийшов із гробниць чоловік, одержимий нечистим духом. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Він мешкав у гробницях, і ніхто не міг його зв’язати навіть ланцюгами. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Його часто зв’язували кайданами та ланцюгами, але він розривав ланцюги та розбивав кайдани, і ніхто не міг його стримати. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Завжди, вдень та вночі, він перебував у гробницях та в горах, кричав та бився об каміння. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Побачивши Ісуса здалека, він прибіг, поклонився Йому ");
INSERT INTO ukronpu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","й голосно промовив: ―Що тобі до мене, Ісусе, Сину Бога Всевишнього? Заклинаю Тебе Богом, не муч мене. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Бо Ісус казав: «Нечистий духу, вийди з цього чоловіка!» ");
INSERT INTO ukronpu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ісус запитав його: ―Як тебе звати? Той відповів: ―Моє ім’я Легіон, бо нас багато. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","І дуже просив Ісуса, щоб Він не висилав їх із тієї місцевості. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","А було там велике стадо свиней, що паслося на горі. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Демони просили Ісуса: ―Надішли нас у свиней, щоб ми увійшли в них. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ісус дозволив їм. Нечисті духи, вийшовши з чоловіка, увійшли у свиней. Тоді все стадо, десь дві тисячі голів, кинулося з кручі в море та втопилося. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Свинопаси побігли та сповістили про це в місті та в селах. Тоді люди вийшли подивитися, що сталося. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Коли підійшли до Ісуса, то побачили, що одержимий, в якому був легіон демонів, сидить одягнений та при здоровому глузді, і вони злякалися. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ті, хто бачив, розповідали, що сталося з біснуватим і про свиней. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Тоді вони почали просити Ісуса, щоб Він залишив їхні околиці. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Коли Ісус сідав у човен, той, хто був біснуватим, просив Його, щоб Він узяв його з Собою. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Але Ісус не дозволив йому, сказавши: «Іди до себе додому, до своїх, та розкажи, як багато зробив для тебе Господь, як Він змилосердився над тобою». ");
INSERT INTO ukronpu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Той пішов і почав проповідувати в Десятимісті, як багато зробив для нього Ісус. І всі дивувалися цьому. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Коли Ісус на човні знов переплив на інший берег, навколо Нього зібрався великий натовп. А був Він біля моря. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","І прийшов один із керівників синагоги, на ім’я Яір, та, впавши Йому до ніг, ");
INSERT INTO ukronpu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","благав Його, кажучи: «Моя донька помирає, прийди та поклади на неї руки, щоб вона одужала та жила». ");
INSERT INTO ukronpu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ісус пішов разом із ним. Великий натовп слідував за Ним, люди з усіх боків тиснули на Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","І була там одна жінка, яка дванадцять років страждала на кровотечу. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Вона багато натерпілася від багатьох лікарів та витратила все, що мала, але не отримала ніякого полегшення, навпаки, їй ставало гірше. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Вона почула про Ісуса і в натовпі, підійшовши ззаду, доторкнулася до Його одежі. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Бо вона говорила: «Якщо хоч доторкнуся до Його одежі, то одужаю!» ");
INSERT INTO ukronpu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","І зараз же зупинилася її кровотеча, і вона відчула в тілі, що зцілилася від своєї недуги. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","А Ісус відразу відчув у Собі, що з Нього вийшла сила. Повернувшись до натовпу, запитав: ―Хто доторкнувся до Мого одягу? ");
INSERT INTO ukronpu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Учні сказали Йому: ―Ти ж бачиш, що натовп тисне на Тебе з усіх боків, а Ти запитуєш: «Хто доторкнувся до Мене?» ");
INSERT INTO ukronpu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Але Ісус озирався, щоб побачити, хто це зробив. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Тоді жінка зі страхом та тремтінням, знаючи, що сталося, підійшла та, впавши перед Ним, сказала всю правду. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ісус же сказав їй: «Донько, віра твоя врятувала тебе. Іди з миром і будь зцілена від твоєї хвороби». ");
INSERT INTO ukronpu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Коли Він ще говорив, прийшли з дому керівника синагоги та сказали: ―Твоя донька померла. Навіщо турбуєш Учителя? ");
INSERT INTO ukronpu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Але Ісус, не зважаючи на сказані слова, сказав керівникові синагоги: ―Не бійся, тільки віруй. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","І не дозволив нікому йти з Ним, окрім Петра, Якова та Івана, брата Якового. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Коли прийшли в дім керівника синагоги, то Ісус побачив метушню і тих, що дуже плакали й голосили. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Він увійшов та сказав їм: «Чому ви тривожитесь та плачете, дитина не померла, а спить». ");
INSERT INTO ukronpu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Але вони почали глузувати з Нього. Ісус же, наказавши всім вийти, узяв батька й матір дитини, а також тих, хто був із Ним, та увійшов туди, де лежала дитина. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Узяв дівчинку за руку й промовив до неї: «Таліта кум!» (що в перекладі означає: «Дівчинко, кажу тобі, встань!»). ");
INSERT INTO ukronpu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Дівчинка негайно піднялася й почала ходити. Їй було дванадцять років. Усі відразу жахнулися від великого дива. ");
INSERT INTO ukronpu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ісус суворо наказав їм, щоб про це ніхто не дізнався, і велів дати дівчинці їсти. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ісус вийшов звідти та прийшов на Свою батьківщину, а Його учні йшли за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Коли настала Субота, Він почав навчати людей у синагозі. Багато з тих, хто слухав Його, казали: «Звідки в Нього це? Що це за мудрість дана Йому? Як такі чудеса творяться Його руками? ");
INSERT INTO ukronpu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Хіба Він не тесля, син Марії? Хіба Він не брат Якова, Йосії, Юди та Симона? Хіба Його сестри не серед нас?» І вони спокушалися через Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ісус же сказав їм: «Не буває пророка без пошани, хіба тільки на своїй батьківщині, серед своїх родичів та у своєму домі». ");
INSERT INTO ukronpu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","І не зміг там зробити жодного чуда, тільки зцілив кількох хворих, поклавши на них руки. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","І дивувався через їхнє невір’я. Потім Ісус ходив по навколишніх селах і навчав. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Покликавши до Себе дванадцятьох, Ісус почав надсилати їх по двоє, даючи їм владу над нечистими духами. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ісус наказав їм: «Не беріть у дорогу ні хліба, ні торбини, ні грошей у пояс, а тільки одну палицю. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Взуйте сандалії й не беріть двох сорочок». ");
INSERT INTO ukronpu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Потім додав: «Коли увійдете в дім, там залишайтесь, поки не вийдете звідти. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Коли ж десь вас не приймуть або не слухатимуть, то, виходячи звідти, обтрусіть пил зі своїх ніг на свідчення проти них!» ");
INSERT INTO ukronpu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Вони пішли та проповідували, щоб люди покаялись, ");
INSERT INTO ukronpu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","і виганяли багатьох демонів, а багатьох хворих помазували олією та зцілювали. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Цар Ірод почув про Ісуса, оскільки Його ім’я ставало все більш відомим. Дехто казав: «Іван Хреститель воскрес із мертвих, і тому ці чудеса діються через Нього». ");
INSERT INTO ukronpu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Інші казали: «Це Ілля!» А ще інші: «Це пророк, як один зі стародавніх пророків». ");
INSERT INTO ukronpu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Але Ірод, почувши це, казав: «Іван, якого я стратив, воскрес із мертвих». ");
INSERT INTO ukronpu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Бо Ірод, надіславши схопити Івана, зв’язав його та посадив до в’язниці через Іродіаду, дружину Филипа, свого брата, з якою він одружився. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Іван казав Іродові: «Не годиться тобі одружуватися з дружиною твого брата!» ");
INSERT INTO ukronpu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Іродіада була ворожою до Івана та бажала вбити його, але не могла. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Адже Ірод боявся Івана і, знаючи, що він чоловік праведний та святий, захищав його. Слухаючи Івана, він дуже непокоївся, однак слухав його з насолодою. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Та настав сприятливий день, коли Ірод святкував свій день народження й влаштував бенкет для своїх вельмож, воєначальників та старійшин із Галілеї. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Дочка Іродіади увійшла до них та затанцювала, і так сподобалась Іродові й тим, що сиділи разом із ним за столом, що цар сказав дівчині: ―Проси все, що бажаєш, і я дам тобі. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","І поклявся їй: ―Усе, що тільки попросиш, дам тобі, навіть і пів царства. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Вона вийшла та запитала в матері: ―Що мені просити? Її мати відповіла: ―Голову Івана Хрестителя. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Тоді вона відразу увійшла до царя та просила: ―Хочу, щоб ти негайно дав мені на блюді голову Івана Хрестителя. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Цар дуже засмутився, але через клятву й тих, що сиділи з ним за столом, не схотів відмовити їй. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Тож цар відразу надіслав охоронця, наказавши принести голову Івана. Той пішов до в’язниці та відрубав Іванові голову, ");
INSERT INTO ukronpu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","приніс її на блюді та віддав дівчині, а вона віддала її своїй матері. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Коли про це довідались учні Івана, то прийшли, забрали його тіло й поклали в гробницю. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Апостоли повернулися до Ісуса й розповіли Йому про все, що зробили і як багато навчили людей. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ісус сказав їм: «Ідіть тепер у пустинне місце та відпочиньте трохи». Адже багато було тих, хто приходив та відходив, і вони не мали часу навіть поїсти. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Тож відпливли на човні в пустинне місце, щоб бути на самоті. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Але люди побачили їх та впізнали, тож побігли пішки з усіх міст та дісталися до того місця раніше за них. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Вийшовши на берег, Ісус побачив багато людей і змилосердився над ними, тому що вони були, як вівці, що не мають пастуха. І почав їх багато навчати. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Коли минуло чимало часу, Його учні підійшли до Нього й сказали: ―Тут пустинне місце, і година вже пізня. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Відпусти людей, щоби пішли в хутори та села, які навколо, та купили собі їсти. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Але Він сказав їм: ―Ви дайте їм їсти! Вони запитали: ―Чи нам піти купити хліба на двісті динаріїв і дати їм їсти? ");
INSERT INTO ukronpu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ісус сказав їм: ―Скільки хлібів у вас є? Ідіть та подивіться! Дізнавшись, вони сказали: ―П’ять хлібів та дві рибини. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Тоді наказав учням розсадити всіх на зеленій траві. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","І розсадили їх групами по сто та по п’ятдесят осіб. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ісус узяв ті п’ять хлібів та дві рибини, подивився на небо, благословив їх і, розломивши хліби, дав Своїм учням, щоб роздали людям. Так само роздали всім обидві рибини. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Усі їли та наситилися, ");
INSERT INTO ukronpu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","і назбирали дванадцять повних кошиків із залишками від риби. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Тих, хто їв, було п’ять тисяч чоловіків. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Відразу після цього Ісус звелів учням сісти в човен та переплисти на другий бік до Віфсаїди, а Він тим часом відпустить людей. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Відпустивши народ, Ісус пішов на гору, щоб помолитися. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Коли настав вечір, човен був посеред моря, а Він залишився сам на березі. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Побачивши, що учні ледве веслують через супротивний вітер, близько четвертої сторожі ночіІсус, ідучи по воді, пішов до них і хотів їх проминути. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Коли учні побачили, що Він іде по воді, подумали, що це привид, і закричали. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Адже всі, хто Його бачив, були налякані. Ісус відразу заговорив до них: «Будьте сміливі! Це Я! Не бійтеся!» ");
INSERT INTO ukronpu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Тоді Він увійшов до них у човен, і вітер стих. Учні дуже в собі здивувалися, ");
INSERT INTO ukronpu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","адже не зрозуміли чуда з хлібами: їхнє серце було закам’яніле. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Перепливши море, вони прибули до Генезаретської землі й причалили. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Коли вони вийшли з човна, люди відразу впізнали Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Вони оббігли всю ту околицю й почали на носилках приносити до Нього хворих. ");
INSERT INTO ukronpu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","І куди б Він не заходив, – у села, міста або хутори, – скрізь на майдани виносили хворих і благали Його дозволити лише торкнутися до краю Його одягу; і всі, хто торкався, зцілялися. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Прийшли до Нього фарисеї та деякі книжники з Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Вони побачили, що деякі Його учні їли немитими, тобто нечистими, руками. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Адже фарисеї, і взагалі юдеї, дотримуючись традиції старійшин, не їдять, доки не омиють старанно рук. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Вони не їдять принесеного з ринку, доки не омиються. Є ще багато іншого, чого вони дотримуються, як-от: миття чаш, глечиків, мідного посуду, а також і лежаків. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Тож фарисеї та книжники запитали Ісуса: ―Чому Твої учні не живуть згідно зі звичаєм наших батьків, а їдять немитими руками? ");
INSERT INTO ukronpu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Він відповів: ―Добре пророкував Ісая про вас, лицемірів, як написано: «Цей народ шанує Мене лише устами, а серце його далеко від Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Даремно вони поклоняються Мені, навчаючи людей людських заповідей». ");
INSERT INTO ukronpu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Залишивши заповідь Бога, ви тримаєтесь людських звичаїв. Миєте глечики та чаші й багато чого іншого робите. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Потім сказав їм: ―Ви спритно відкидаєте заповідь Божу, щоб зберегти ваш звичай. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Адже Мойсей сказав: «Шануй батька та матір»,а також: «Той, хто зневажає батька або матір, нехай буде покараний смертю!» ");
INSERT INTO ukronpu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ви ж говорите, що якщо людина скаже батькові або матері: «Те, чим я міг би допомогти тобі, – Корбан» (тобто дар Богові), ");
INSERT INTO ukronpu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","то ви вже дозволяєте йому нічого не робити для свого батька або матері. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Так ви скасовуєте Слово Боже через свій звичай, який ви ж і встановили. І багато подібного до цього ви робите. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Покликавши народ, Ісус знову промовив до них: «Слухайте Мене всі та зрозумійте! ");
INSERT INTO ukronpu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Не існує нічого, що би ззовні входило в людину та могло зробити її нечистою, але нечистою людину робить те, що виходить з неї. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Якщо хтось має вуха, щоб слухати, нехай слухає!» ");
INSERT INTO ukronpu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Коли Ісус залишив людей та увійшов у дім, Його учні запитали про цю притчу. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Він сказав їм: «Невже ви ще не розумієте? Не знаєте, що все, що входить ззовні, не може людину зробити нечистою? ");
INSERT INTO ukronpu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Бо їжа не потрапляє до серця, а йде до шлунка й потім виходить геть. Так Він оголосив чистою всю їжу». ");
INSERT INTO ukronpu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Потім сказав: «Оскверняє людину те, що виходить з неї. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Адже з серця людини виходять погані думки, статева розпуста, крадіж, вбивства, ");
INSERT INTO ukronpu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","перелюб, жадібність, злоба, лукавство, непристойність, заздрість, богохульство, гордість та дурість. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Усе це зло виходить зсередини та оскверняє людину». ");
INSERT INTO ukronpu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Вирушивши звідти, Ісус попрямував до земель Тира й Сидона. І, увійшовши в дім, не хотів, щоб хтось дізнався, що Він там, але не зміг утаїтись. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Одна жінка, яка мала доньку, одержиму нечистим духом, почувши про Ісуса, прийшла до Нього та впала на коліна перед Ним. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Жінка була гречанкою, родом із Сирійської Фінікії. Вона благала Ісуса вигнати демона з її доньки. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Але Він сказав: ―Нехай спочатку наситяться діти, адже не годиться брати хліб від дітей та кидати щенятам. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Вона ж відповіла Йому: ―Так, Господи, але й щенята під столом їдять крихти після дітей. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Він сказав їй: ―За ці слова йди, демон вийшов із твоєї доньки. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Вона пішла додому й знайшла дитину, що лежала в ліжку, і демон вийшов із неї. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ісус знов залишив околиці Тира й через Сидон вийшов до Галілейського моря на землі Десятимістя. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","І привели до Нього глухого, який говорив із труднощами, і просили, щоб Він поклав на нього руки. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ісус узяв його вбік від натовпу та вклав пальці йому у вуха і, плюнувши, торкнувся його язика. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Потім подивився на небо, зітхнув і сказав глухому: «Еффата!», що означає: «Відкрийся!» ");
INSERT INTO ukronpu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","І відразу відкрилися його вуха, язик розв’язався, і він почав говорити правильно. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ісус наказав не розповідати про це нікому. Та чим більше Він забороняв, тим більше вони розголошували. ");
INSERT INTO ukronpu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","І дивувалися вкрай, кажучи: «Він усе робить дуже добре: навіть глухим дає слух і німим – мову». ");
INSERT INTO ukronpu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","У ті дні, коли знову зібралося багато людей і не мали, що їсти, Ісус покликав учнів та сказав їм: ");
INSERT INTO ukronpu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Жаль Мені цих людей, тому що вже три дні залишаються зі Мною й не мають, що їсти. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","І якщо Я відпущу їх голодними додому, вони ослабнуть у дорозі, бо деякі прийшли здалека. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Учні відповіли Йому: ―Звідки в цій пустелі хтось зможе взяти стільки хліба, щоб нагодувати цих людей? ");
INSERT INTO ukronpu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ісус запитав: ―Скільки маєте хлібів? Вони відповіли: ―Сім. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ісус звелів людям сісти на землю. Потім узяв ті сім хлібів, подякував, розламав та дав Своїм учням, щоб вони роздали людям. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ще мали й кілька малих рибин, Він благословив їх і звелів роздати й рибу. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Усі їли та наситились. І зібрали сім повних кошиків залишків. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Тих, що їли, було приблизно чотири тисячі. Потім відпустив їх. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Після цього Ісус відразу сів у човен разом зі своїми учнями та відплив до землі Далманутської. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","До Ісуса підійшли фарисеї та почали сперечатися з Ним. Вони, випробовуючи Його, вимагали знамення з неба. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ісус, глибоко зітхнувши у Своєму дусі, сказав: «Чому цей рід шукає знамення? Істинно кажу вам: цьому роду не дасться ніякого знамення». ");
INSERT INTO ukronpu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","І, залишивши їх, знову сів у човен та вирушив на другий бік моря. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Учні забули взяти хліб і, крім однієї хлібини, не мали в човні більше нічого ");
INSERT INTO ukronpu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","А Ісус застерігав їх: ―Дивіться та стережіться закваски фарисейської та закваски Ірода. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Вони міркували між собою: ―Він говорить так, тому що ми не маємо хлібів. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Знаючи про це, Ісус сказав: ―Чому ви міркуєте між собою, що не взяли хліба? Невже ви не збагнули й не розумієте? Невже ваше серце все ще закам’яніле? ");
INSERT INTO ukronpu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Маєте очі, але не бачите? Маєте вуха, але не чуєте? Невже не пам’ятаєте? ");
INSERT INTO ukronpu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Коли п’ять хлібів Я розділив для п’яти тисяч, то скільки повних кошиків залишків ви зібрали? Вони відповіли: ―Дванадцять. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","― А сім хлібів для чотирьох тисяч? І скільки повних кошиків із залишками ви зібрали? Вони відповіли: ―Сім. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Тоді Ісус сказав їм: ―Усе ще не розумієте? ");
INSERT INTO ukronpu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Коли прийшли до Віфсаїди, привели до Ісуса сліпого й просили доторкнутись до нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Він узяв сліпого за руку, вивів за межі села й, послинивши йому очі, поклав на нього руки та запитав: ―Бачиш щось? ");
INSERT INTO ukronpu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Подивившись, він сказав: ―Бачу людей, але вони мов дерева, що ходять. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Тоді Ісус знов поклав руки на його очі. Чоловік подивився уважно, його зір повернувся, і він бачив усе чітко ");
INSERT INTO ukronpu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ісус вислав його додому та сказав: ―Не заходь у село й не розповідай нікому. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ісус зі Своїми учнями прийшов до сіл довкола Кесарії Филипової. Дорогою Ісус запитав Своїх учнів: ―За кого вважають Мене люди? ");
INSERT INTO ukronpu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Вони відповіли: ―Одні – за Івана Хрестителя, інші – за Іллю, ще інші – за одного з пророків. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Тоді Ісус спитав їх: ―А ви за кого Мене вважаєте? Петро сказав Йому: ―Ти – Христос! ");
INSERT INTO ukronpu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Тоді Він наказав їм нікому не казати про Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Потім почав навчати їх, що Синові Людському належить багато страждати, бути відкинутим старійшинами, первосвященниками та книжниками, бути вбитим, але через три дні Він воскресне. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Він говорив їм прямо про це. Тоді Петро, відкликавши Ісуса вбік, почав докоряти Йому. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ісус же повернувся, подивився на Своїх учнів та докорив Петрові, кажучи: ―Відійди від Мене, сатано! Бо ти думаєш не про Боже, а про людське. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","І, покликавши до Себе народ разом зі Своїми учнями, сказав їм: «Якщо хтось хоче йти за Мною, нехай зречеться самого себе, візьме свій хрест та слідує за Мною. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Бо хто хоче спасти своє життя, той втратить його, а хто втратить його заради Мене та Доброї Звістки, той спасе його. ");
INSERT INTO ukronpu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Яка користь людині, якщо здобуде весь світ, а душу свою втратить? ");
INSERT INTO ukronpu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Або що дасть людина в обмін за свою душу? ");
INSERT INTO ukronpu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Бо якщо хтось посоромиться Мене та Моїх слів перед цим грішним та невірним поколінням, того й Син Людський посоромиться, коли прийде в славі Свого Отця разом зі святими ангелами». ");
INSERT INTO ukronpu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","І сказав: «Істинно кажу вам: деякі з присутніх тут не зазнають смерті, доки не побачать Царства Божого, що прийшло в силі». ");
INSERT INTO ukronpu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Через шість днів Ісус узяв із Собою Петра, Якова та Івана й вивів тільки їх на високу гору. Там Він преобразився перед ними: ");
INSERT INTO ukronpu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Його одяг став блискучим і таким білим, що жоден відбілювач у світі не міг би так відбілити. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","І з’явились їм Мойсей та Ілля, які розмовляли з Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Петро сказав Ісусові: «Равві, добре нам тут бути! Зробімо три намети: один для Тебе, один для Мойсея та один для Іллі». ");
INSERT INTO ukronpu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Бо не знав, що сказати, такі налякані були. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Тоді з’явилася хмара, яка накрила їх, і з хмари промовив голос: «Це Син Мій улюблений, Його слухайте!» ");
INSERT INTO ukronpu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","І раптом, подивившись навкруги, вони нікого не побачили, окрім Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Коли вони сходили з гори, Ісус наказав їм, щоб не казали нікому про те, що бачили, доки Син Людський не воскресне з мертвих. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Вони зберегли це Слово для себе, тільки міркували між собою, що означає воскресіння з мертвих. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Потім вони запитали Його: ―Чому книжники кажуть, що Ілля має прийти першим? ");
INSERT INTO ukronpu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ісус відповів: ―Ілля дійсно має прийти першим, щоб відновити все. І, як написано про Сина Людського, Він має багато постраждати та бути приниженим. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Але кажу вам: Ілля прийшов, і вони вчинили з ним усе, що схотіли, як написано про нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Повернувшись до інших учнів, вони побачили навколо них великий натовп і книжників, які сперечалися з ними. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Як тільки ці люди побачили Ісуса, здивувалися й побігли привітати Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Він запитав їх: ―Чому ви сперечалися з ними? ");
INSERT INTO ukronpu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Один чоловік із натовпу відповів: ―Учителю, я привів до Тебе мого сина, бо він одержимий духом німоти. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Коли дух його хапає, то кидає на землю, з рота йде піна, хлопчик скрегоче зубами й ціпеніє. Я просив Твоїх учнів вигнати духа, але вони не змогли. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ісус у відповідь сказав: ―О роде невірний, доки буду з вами? Доки терпітиму вас? Приведіть хлопчика до Мене! ");
INSERT INTO ukronpu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","І привели хлопчика до Ісуса. Коли дух побачив Ісуса, відразу кинув хлопчика в судоми. Той, упавши на землю, покотився й пустив піну з рота. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ісус запитав його батька: ―Скільки часу з ним таке? Він відповів: ―З дитинства. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Часто дух кидає його у вогонь або у воду, щоб вбити його. Якщо можеш щось зробити, допоможи нам. Змилуйся над нами. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ісус же сказав йому: ―Якщо можеш?! Усе можливе для того, хто вірує! ");
INSERT INTO ukronpu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Тоді батько хлопчика скрикнув: ― Вірую! Допоможи моєму невірству. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Коли Ісус побачив, що люди збігаються, то наказав нечистому духові, кажучи: «Духу німий та глухий, наказую тобі: вийди з нього й більше не заходь у нього!» ");
INSERT INTO ukronpu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Скрикнувши, дух сильно потряс хлопця в конвульсіях і вийшов із нього. Хлопець став як мертвий, так що багато хто говорив, що він помер. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Але Ісус узяв його за руку, підняв його, і він устав. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Пізніше, коли Ісус увійшов у дім, учні наодинці запитали Його: ―Чому ми не змогли вигнати демона? ");
INSERT INTO ukronpu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ісус відповів: ―Цей рід можна вигнати лише молитвою та постом. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Вийшовши звідти, вони пройшли через Галілею. Ісус не хотів, щоб хтось дізнався про це, ");
INSERT INTO ukronpu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","бо Він навчав Своїх учнів та казав їм: «Син Людський буде виданий у руки людські. Його вб’ють, але через три дні Він воскресне». ");
INSERT INTO ukronpu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Однак учні не зрозуміли цих слів, а спитати Його боялися. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Коли вони прийшли в Капернаум і були в домі, Ісус запитав їх: ―Про що ви говорили в дорозі? ");
INSERT INTO ukronpu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Але вони мовчали, тому що в дорозі сперечалися між собою, хто з них найбільший. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Тоді Ісус присів, покликав до Себе дванадцятьох і сказав їм: ―Якщо хтось хоче бути першим, той хай буде останнім серед усіх та слугою для всіх. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ісус узяв дитину, поставив посеред них і, обійнявши її, сказав їм: ");
INSERT INTO ukronpu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Хто приймає таку дитину в ім’я Моє, той не Мене приймає, а Того, Хто надіслав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Іван сказав Йому: ―Учителю, ми бачили когось, хто Твоїм ім’ям виганяв демонів, та ми заборонили йому, бо він не ходить із нами. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Але Ісус сказав: ―Не зупиняйте його, бо немає такого, хто б робив чудо в ім’я Моє й відразу злословив би Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Той, хто не проти нас, той за нас. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Адже хто подасть вам чашу води в ім’я Моє, бо ви Христові, – істинно кажу вам, – не втратить своєї винагороди. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Якщо хтось спокусить одного з цих малих, що вірують у Мене, то було б краще, якби йому повісили млинове жорно на шию й кинули в море. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Якщо твоя рука спокушає тебе, відрубай її. Краще тобі увійти в життя покаліченим, ніж, маючи дві руки, іти до Геєни, у вогонь незгасимий, ");
INSERT INTO ukronpu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","де черв’як їхній не вмирає і вогонь не гасне. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Якщо твоя нога спокушає тебе, відрубай її. Краще тобі увійти в життя покаліченим чи кульгавим, ніж, маючи дві ноги, бути вкинутим до Геєни, ");
INSERT INTO ukronpu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","де черв’як їхній не вмирає і вогонь не гасне. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Якщо твоє око спокушає тебе, вирви його. Краще тобі увійти до Царства Божого однооким, ніж, маючи два ока, бути вкинутим у Геєну, ");
INSERT INTO ukronpu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","«де черв’як їхній не вмирає і вогонь не гасне». ");
INSERT INTO ukronpu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Бо кожен буде вогнем посолений і кожна жертва буде посолена сіллю. ");
INSERT INTO ukronpu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Сіль – добра річ, але якщо сіль втратить солоність, як її знов зробити солоною? Майте сіль самі в собі та зберігайте мир між собою. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ісус піднявся звідти та пішов в околиці Юдеї та в землі, що за Йорданом. До Нього знову сходилися натовпи, і Він, за звичаєм, знову навчав їх. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Підійшли фарисеї та, випробовуючи Його, запитували: ―Чи дозволено чоловікові розлучатися зі своєю дружиною? ");
INSERT INTO ukronpu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ісус у відповідь запитав: ―Що наказав вам Мойсей? ");
INSERT INTO ukronpu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Вони сказали: ―Мойсей дозволив написати їй листа про розлучення та відпустити. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ісус же сказав їм: ―Через вашу жорстокість він написав вам цю заповідь. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Від початку творіння Бог «чоловіком та жінкою їх створив». ");
INSERT INTO ukronpu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","«Тому залишить чоловік батька свого й матір свою і прилине до жінки своєї, ");
INSERT INTO ukronpu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","і будуть двоє одним тілом». Тому більше не буде двох, а одне тіло. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Отже, те, що Бог з’єднав, людина хай не роз’єднує. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","У домі учні знову запитали про це Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Він сказав: ―Кожен, хто розлучається зі своєю дружиною та одружується з іншою, чинить перелюб проти неї. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","І якщо дружина розлучається зі своїм чоловіком та одружується з іншим, також чинить перелюб. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Люди приносили до Нього дітей, щоб Він доторкнувся до них та благословив, але учні забороняли їм. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ісус же, побачивши це, розгнівався й сказав: «Пустіть дітей приходити до Мене й не забороняйте їм, бо таким, як вони, належить Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Істинно кажу вам: хто не прийме Царства Божого, як дитя, той не ввійде до нього!» ");
INSERT INTO ukronpu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Він обійняв дітей і, поклавши на них руки, благословив. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Коли Ісус відправився далі, підбіг до Нього один чоловік, упав перед Ним на коліна й запитав: ―Учителю добрий, що мені робити, щоб успадкувати життя вічне? ");
INSERT INTO ukronpu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ісус відповів йому: ―Чому ти називаєш Мене добрим? Ніхто не є Добрий, окрім Самого Бога. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ти знаєш заповіді: «Не вбивай», «Не чини перелюбу», «Не вкради», «Не обманюй», «Не кривдь», «Шануй твого батька та матір». ");
INSERT INTO ukronpu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Він відповів: ―Учителю, усе це я зберіг змалку. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ісус подивився на нього з любов’ю та сказав йому: ―Одного тобі ще бракує: піди, продай усе, що маєш, та роздай бідним, і матимеш скарб на небесах; а тоді приходь та слідуй за Мною. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Почувши це Слово, чоловік відійшов засмучений, бо мав багато маєтків. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ісус подивився навкруги та сказав Своїм учням: ―Як важко багатим увійти в Царство Боже! ");
INSERT INTO ukronpu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Учні були вражені словами Ісуса. Ісус знову сказав їм: ―Діти, як важко тим, хто покладається на багатства, увійти в Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Легше верблюдові пройти через вушко голки, ніж багатому ввійти в Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Тоді вони дуже здивувалися й казали між собою: ―Хто ж тоді може бути спасенний? ");
INSERT INTO ukronpu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Подивившись на них, Ісус сказав: ―Для людей це неможливо, але не для Бога, адже для Бога все можливо. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Петро почав говорити: ―Ось ми залишили все та пішли за Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ісус відповів: ―Істинно кажу вам: немає нікого, хто б залишив дім, братів, сестер, батька, матір, дітей і поля заради Мене та заради Доброї Звістки ");
INSERT INTO ukronpu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","і хто б не отримав у сто разів більше в цей час домів, братів, сестер, матерів, дітей і поля разом із гоніннями, а в майбутньому віці – вічне життя. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Багато перших будуть останніми, а останні – першими. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Вони йшли дорогою до Єрусалима. Ісус ішов попереду учнів, а вони, здивовані та сповнені страху, ішли за Ним. Він знов узяв дванадцятьох окремо й почав говорити про те, що має з Ним статися. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Ось ми йдемо до Єрусалима, і там Син Людський буде виданий первосвященникам і книжникам. Вони засудять Його на смерть та віддадуть язичникам. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ті насміхатимуться з Нього, плюватимуть на Нього, бичуватимуть Його та вб’ють, але через три дні Він воскресне». ");
INSERT INTO ukronpu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Яків та Іван, сини Зеведеєві, підійшли до Нього й сказали: ―Учителю, бажаємо, щоб Ти зробив для нас те, що ми попросимо. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Він запитав їх: ―Що бажаєте, щоб Я зробив для вас? ");
INSERT INTO ukronpu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Вони сказали Йому: ―Дозволь, щоб ми сиділи: один праворуч, а інший ліворуч від Тебе у славі Твоїй. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ісус сказав їм: ―Не знаєте, чого просите. Чи зможете ви пити чашу, яку Я п’ю, або хреститися хрещенням, яким Я хрещуся? ");
INSERT INTO ukronpu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Вони відповіли: ―Зможемо! Ісус сказав: ―Чашу, яку Я п’ю, ви будете пити, і хрещенням, яким Я хрещуся, ви будете хрещені. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Але сидіти праворуч або ліворуч від Мене – не Мені це вирішувати: ці місця належать тим, кому приготовлені. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Решта десятеро учнів, почувши про це, розгнівалися на Якова та Івана. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ісус же, покликавши їх, сказав: «Ви знаєте, що ті, кого вважають керівниками народів, володіють ними, а сильні світу панують над ними. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Але серед вас не так: хто хоче стати великим між вами, той має стати вашим слугою. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","І хто хоче бути першим, нехай буде рабом для всіх. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Адже Син Людський прийшов не для того, щоб Йому служили, але щоб служити й віддати Своє життя як викуп за багатьох». ");
INSERT INTO ukronpu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Вони прийшли до Єрихона, і, коли Ісус разом зі Своїми учнями та великим натовпом людей виходили з Єрихона, син Тимея, Вартимей, сліпий жебрак, сидів біля дороги. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Почувши, що Ісус із Назарета проходить, він почав кричати: ―Сину Давидів, змилуйся наді мною! ");
INSERT INTO ukronpu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Багато людей почали докоряти йому, щоб він замовк, але він ще голосніше закричав: ―Сину Давидів, змилуйся наді мною! ");
INSERT INTO ukronpu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ісус зупинився та сказав: «Покличте його!» Вони покликали сліпого, кажучи: «Не бійся! Вставай! Він кличе тебе». ");
INSERT INTO ukronpu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Той скинув верхню одежу, підскочив та прийшов до Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ісус у відповідь сказав: ―Що ти хочеш, щоб Я зробив для тебе? Сліпий Йому відповів: ―Равві, щоб я знову бачив! ");
INSERT INTO ukronpu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ісус сказав йому: ―Іди, твоя віра спасла тебе! Сліпий відразу ж прозрів та пішов дорогою за Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Коли наблизились до Єрусалима, до Вітфагії та Віфанії, до Оливної гори, Він надіслав двох Своїх учнів ");
INSERT INTO ukronpu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","та сказав їм: «Ідіть у село, яке перед вами, і відразу, як зайдете, знайдете прив’язане осля, на яке ще ніхто з людей не сідав; відв’яжіть його й приведіть. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","І якщо хтось спитає вас: „Чому це робите?“, скажіть: „Господь потребує його й відразу відішле назад“». ");
INSERT INTO ukronpu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Вони пішли й знайшли осля, прив’язане на вулиці біля воріт, і розв’язали його. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Дехто з тих, що стояли там, сказали їм: «Що ви робите? Чому відв’язуєте осля?» ");
INSERT INTO ukronpu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Вони відповіли, як звелів їм Ісус; тоді відпустили їх. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","І привели осля до Ісуса, поклали на нього свій одяг, і Він сів на нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Багато хто стелив свій одяг по дорозі, інші ж стелили по дорозі гілки, які відрізали на полях. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ті, що йшли попереду та позаду Нього, викрикували: «Осанна!» «Благословенний Той, Хто йде в ім’я Господа!» ");
INSERT INTO ukronpu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","«Благословенне Царство батька нашого Давида, яке надходить!» «Осанна на небесах!» ");
INSERT INTO ukronpu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Коли Він увійшов у Єрусалим, то пішов до Храму й оглянув усе. Та оскільки була вже пізня година, вийшов разом із дванадцятьма та пішли до Віфанії. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Наступного дня, коли виходили з Віфанії, Ісус зголоднів. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","І, побачивши здалека смоковницю, яка була вкрита листям, Він підійшов подивитися, чи немає на ній плодів. Але не знайшов нічого, окрім листя, бо не був ще час для смокви. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Тоді промовив до неї: «Нехай же повік ніхто не буде їсти твоїх плодів!» Його учні почули це. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Коли прийшли в Єрусалим, Ісус увійшов у Храм та вигнав усіх тих, хто продавав і купував у Храмі, перевернув столи тих, хто міняв гроші, та місця тих, хто продавав голубів. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Він не дозволяв нікому переносити через Храм будь-які речі. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Навчав і казав їм: «Хіба не написано: „Дім Мій буде називатися Домом Молитви для всіх народів“?А ви зробили з нього „притулок розбійників!“» ");
INSERT INTO ukronpu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Первосвященники та книжники почули про це й шукали нагоди вбити Ісуса, але боялися Його, бо весь народ був здивований Його вченням. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Коли наставав вечір, вони виходили з міста. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Вранці, проходячи повз смоковницю, вони побачили, що вона всохла від самого коріння. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Згадавши, що сталося напередодні, Петро сказав Йому: ―Равві, ось смоковниця, яку Ти прокляв, всохла! ");
INSERT INTO ukronpu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","У відповідь Ісус сказав: ―Майте віру в Бога! ");
INSERT INTO ukronpu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Істинно кажу вам: якщо хтось скаже цій горі: «Піднесися та кинься в море!» – і не буде сумніватися у своєму серці, а буде вірити, що станеться, як сказав, то так і буде. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Тому кажу вам: усе, про що молитесь і просите, вірте, що ви вже отримали, – і буде дано вам. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","І коли стоїте в молитві, то прощайте, коли маєте щось проти когось, щоб і Отець ваш Небесний простив вам провини ваші. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Але якщо не прощаєте, і Отець ваш Небесний не простить вам провин ваших. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Вони знову прийшли до Єрусалима. Коли Він ходив у Храмі, до Нього підійшли первосвященники, книжники та старійшини ");
INSERT INTO ukronpu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","й запитали Його: ―Якою владою Ти це робиш? Або хто дав Тобі таку владу робити це? ");
INSERT INTO ukronpu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ісус сказав їм: ―Запитаю і Я вас про одне. Скажіть Мені, і Я скажу вам, якою владою це роблю. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Іванове хрещення було з Неба чи від людей? Дайте Мені відповідь. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Вони ж стали міркувати між собою, кажучи: ―Якщо скажемо: «З неба», Він запитає: «Чому ж ви не повірили йому?» ");
INSERT INTO ukronpu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Якщо ж ми скажемо: «Від людей», – боїмося людей, бо всі вважали Івана пророком. ");
INSERT INTO ukronpu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Вони відповіли Ісусові: ―Не знаємо. Ісус сказав: ―Тоді і Я не скажу, якою владою це роблю. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ісус почав говорити їм у притчах: ―Один чоловік посадив виноградник, обвів його огорожею, вкопав давильню, збудував башту, здав його в оренду виноградарям та вирушив у подорож. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Коли настав час, він надіслав одного раба до виноградарів, щоб отримати свою частину врожаю. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Однак виноградарі схопили, побили його й відіслали назад ні з чим. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Тоді господар надіслав до них іншого раба. Але вони й тому розбили голову та відіслали з ганьбою. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Він надіслав ще одного, але вони його вбили. Також і багатьох інших: одних побили, а інших убили. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Нарешті надіслав до них свого єдиного улюбленого сина, кажучи: «Мого сина поважатимуть!» ");
INSERT INTO ukronpu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Але ті виноградарі сказали один одному: «Це спадкоємець, ходімо та вб’ємо його, і спадщина буде нашою!» ");
INSERT INTO ukronpu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Вони схопили його, вбили та вивели з виноградника. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Що ж зробить господар виноградника? Він прийде та вб’є виноградарів, а виноградник віддасть іншим виноградарям. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Хіба ви не читали в Писанні: «Камінь, який відкинули будівничі, став наріжним каменем. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Господь зробив це, і воно є дивним у наших очах». ");
INSERT INTO ukronpu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Вони зрозуміли, що Він про них сказав цю притчу, і шукали нагоди схопити Ісуса, але боялися народу. Тому залишили Його й відійшли. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Потім вони надіслали до Нього деяких фарисеїв та іродіан, щоб впіймати Його на слові. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ті прийшли та запитали Його: ―Учителю, ми знаємо, що Ти праведний, ні на кого не зважаєш, адже не дивишся на людське обличчя, а правдиво навчаєш Божого шляху. Чи годиться платити податок Кесареві, чи ні? Платити чи не платити? ");
INSERT INTO ukronpu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ісус, знаючи їхнє лицемірство, сказав їм: ―Чому ви випробовуєте Мене? Дайте Мені динарій, щоб побачити. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Вони принесли: Він сказав: ―Чиє це зображення та напис? ―Кесаря! ");
INSERT INTO ukronpu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Тоді Ісус сказав їм: ―Віддайте Кесареві Кесареве, а Богові – Боже! І вони дивувалися з Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Прийшли до Нього садукеї, які кажуть, що немає воскресіння з мертвих, і запитали Його: ");
INSERT INTO ukronpu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Учителю, Мойсей написав нам: «Якщо чийсь брат помре та залишить дружину, не залишивши жодної дитини, то нехай його брат візьме дружину померлого та підніме нащадка своєму братові». ");
INSERT INTO ukronpu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Було семеро братів. Перший одружився та помер, не залишивши дітей. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Другий одружився з вдовою, але він помер, не залишивши дітей, також і третій. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","І ніхто із сімох не залишив дітей. Після всіх померла й жінка. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","При воскресінні, коли воскреснуть, дружиною котрого з них вона буде? Адже всі семеро мали її за дружину. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ісус сказав їм: ―Чи не тому ви помиляєтеся, що не знаєте ані Писання, ані сили Божої? ");
INSERT INTO ukronpu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Бо коли воскресають з мертвих, не одружуються й не виходять заміж, а є як ангели на небі. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","А щодо воскресіння з мертвих, хіба ви не читали в книзі Мойсея про те, що сказав йому Бог при полум’ї вогню тернового куща: «Я – Бог Авраама, Бог Ісаака і Бог Якова»? ");
INSERT INTO ukronpu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Він є Богом не мертвих, а живих! Дуже помиляєтесь! ");
INSERT INTO ukronpu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Один із книжників, підійшовши, послухав, як вони говорили й, побачивши, що Ісус добре відповів садукеям, запитав Його: ―Яка заповідь перша з усіх? ");
INSERT INTO ukronpu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ісус відповів: ―Перша є: «Слухай Ізраїлю, Господь Бог твій – це єдиний Господь. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Люби Господа Бога свого всім серцем своїм, усією своєю душею, усім своїм розумом і всією силою своєю». ");
INSERT INTO ukronpu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","А друга: «Люби ближнього свого, як самого себе».Немає заповіді важливішої від цих двох. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Книжник сказав Йому: ―Добре, Учителю! Ти правильно сказав: Бог єдиний, і немає іншого, крім Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","І любити Його всім серцем, усім розумінням та всією силою, і любити ближнього, як самого себе, – це більше за всі цілопалення та жертви. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Побачивши, що він мудро відповів, Ісус сказав йому: ―Ти недалеко від Царства Божого! І більше ніхто не наважувався запитувати Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","У відповідь Ісус, навчаючи в Храмі, сказав: ―Чому книжники кажуть, що Христос є сином Давида? ");
INSERT INTO ukronpu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Адже сам Давид через Духа Святого сказав: «Господь сказав Господеві моєму: „Сядь праворуч від Мене, доки Я не покладу ворогів Твоїх, як підніжок для Твоїх ніг“». ");
INSERT INTO ukronpu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Якщо сам Давид називає Його Господом, як Він може бути його Сином? Багато людей слухало Його із задоволенням. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","У Своєму навчанні Він сказав: «Стережіться книжників: їм подобається одягатись у довгі одежі, вони люблять привітання на ринках, ");
INSERT INTO ukronpu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","перші місця в синагогах та почесні місця на бенкетах. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Вони з’їдають доми вдів, але прикриваються довгими молитвами. Вони отримають суворіше покарання». ");
INSERT INTO ukronpu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ісус сів навпроти скрині для пожертв і дивився, як люди клали гроші в скриню. Чимало багатіїв клали багато. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Але підійшла одна бідна вдова, яка поклала дві лепти, що разом складають один кодрант. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ісус покликав Своїх учнів і сказав їм: «Істинно кажу вам: ця бідна вдова поклала в скриню більше, ніж поклали всі інші. ");
INSERT INTO ukronpu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Адже всі клали зі свого достатку, а вона зі своєї бідності поклала все, що мала на прожиток». ");
INSERT INTO ukronpu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Коли Ісус виходив із Храму, один з Його учнів сказав Йому: ―Учителю, поглянь, яке каміння і які будівлі! ");
INSERT INTO ukronpu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ісус сказав йому: ―Ти бачиш ці величезні споруди? Не залишиться тут каменя на камені, який не був би зруйнований. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Потім, коли Ісус сидів на Оливній горі навпроти Храму, Петро, Яків, Іван та Андрій наодинці запитали Його: ");
INSERT INTO ukronpu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Скажи нам, коли все це станеться і яка ознака того, що все це скоро здійсниться? ");
INSERT INTO ukronpu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ісус почав їм говорити: ―Дивіться, щоб ніхто не ввів вас в оману! ");
INSERT INTO ukronpu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Бо багато хто прийде в ім’я Моє й казатиме: «Це Я!» І багатьох введуть в оману. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Коли почуєте про війни та чутки про війни, не лякайтеся: це має статися, але це ще не кінець. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Повстане народ проти народу й царство проти царства. У різних місцях будуть землетруси та голод. Але це – лише початок страждань. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Будьте обережні! Адже видаватимуть вас до судів і в синагогах битимуть вас. Поведуть вас до правителів та царів заради Мене, на свідчення їм. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Але спочатку Добра Звістка має проповідуватись усім народам. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Коли поведуть вас видавати до суду, не турбуйтеся, як і що казати. Але говоріть те, що буде дано вам у той час. Адже не ви будете говорити, а Дух Святий. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Брат видасть на смерть брата, а батько – дитину. Повстануть діти проти батьків та вбиватимуть їх. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","І всі будуть ненавидіти вас через ім’я Моє. Але хто витримає до кінця, той буде спасенний. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Коли побачите гидоту спустошення, що сидить там, де їй не слід, – хто читає, нехай зрозуміє, – тоді ті, що в Юдеї, нехай тікають у гори. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Той, що буде на даху, хай не сходить і не входить, аби взяти щось зі свого дому; ");
INSERT INTO ukronpu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","той, що в полі, хай не вертається взяти свою одежу. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Горе вагітним і тим, що будуть годувати грудьми в ті дні. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Моліться, щоб це не сталося взимку. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Бо в ті дні буде таке страждання, якого не було від початку світу, що його створив Бог, дотепер і ніколи не буде. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","І якби Господь не скоротив тих днів, то жодна людина не була б врятована, але заради обраних, яких Він обрав, Господь скоротив ті дні. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Якщо тоді хтось скаже вам: «Ось тут Христос!», «Ось Він там!» – не вірте. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Бо постануть лжехристи та лжепророки й робитимуть знамення та чудеса, щоб ввести в оману, якщо можливо, обраних. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ви ж стережіться. Я про все попередив вас! ");
INSERT INTO ukronpu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Але в ті дні, після того страждання, «сонце померкне, і місяць не буде світити; ");
INSERT INTO ukronpu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","зірки впадуть із неба, і сили небесні захитаються». ");
INSERT INTO ukronpu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Тоді побачать Сина Людського, Який приходить на хмарах із великою силою та славою. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Тоді Він надішле ангелів, і вони зберуть Його обраних із чотирьох вітрів, від одного краю землі до краю неба. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Від смоковниці навчіться її притчі: коли гілка стає вже м’якою й пускає листя, ви знаєте, що літо близько. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Так і ви, коли побачите, що це збувається, знайте: прихід близько, уже біля дверей. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Істинно кажу вам: не мине цей рід, поки все це не станеться. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Небо та земля проминуть, але слова Мої не проминуть. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","А про той день і про ту годину ніхто не знає: ні ангели небесні, ні Син, а тільки Отець. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Стережіться, пильнуйте, бо не знаєте, коли прийде той час. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Подібно як чоловік, який, вирушивши в подорож, залишив свій дім і дав своїм рабам владу, кожному своє доручення, а сторожеві наказав пильнувати. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Пильнуйте, бо не знаєте, коли господар дому прийде: увечері, опівночі, коли заспіває півень або вранці, ");
INSERT INTO ukronpu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","щоб, прийшовши несподівано, не знайшов вас уві сні. ");
INSERT INTO ukronpu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Те, що Я кажу вам, усім кажу: пильнуйте! ");
INSERT INTO ukronpu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Через два дні була Пасха та свято Опрісноків. Первосвященники та книжники шукали, як би підступом схопити та вбити Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Але говорили: «Не у свято, щоб не сталося якогось заворушення в народі». ");
INSERT INTO ukronpu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ісус був у Віфанії, у домі Симона прокаженого. Коли Він сидів за столом, прийшла одна жінка, яка принесла алебастровий глечик із дуже дорогим чистим нардовим миром. Вона розбила алебастровий глечик і вилила миро на голову Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Однак деякі з обуренням говорили між собою: ―Навіщо така трата мира? ");
INSERT INTO ukronpu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Це миро можна було продати більше, ніж за триста динаріїв, та роздати бідним. І докоряли їй. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Але Ісус сказав: ―Залишіть її, чому ви докоряєте їй? Вона зробила добре діло для Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Бідних ви завжди маєте з собоюі, коли схочете, можете їм допомогти, а Мене не завжди матимете. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Вона зробила, що змогла. Помазала миром Моє тіло, щоб приготувати до поховання. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Істинно кажу вам: всюди, де буде проповідуватись ця Добра Звістка у всьому світі, будуть казати й те, що вона зробила, на згадку про неї. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Юда Іскаріот, один із дванадцятьох, пішов до первосвященників, щоб видати їм Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Почувши про це, вони зраділи та обіцяли дати Йому грошей. І відтоді він шукав слушної нагоди, щоб Його видати. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","У перший день свята Опрісноків, коли приносили пасхальну жертву, учні запитали Ісуса: ―Де Ти хочеш, щоб ми пішли та приготували Тобі спожити Пасху? ");
INSERT INTO ukronpu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Він надіслав двох учнів і сказав їм: ―Ідіть у місто, вас зустріне чоловік, який нестиме глечик із водою. Ідіть за ним. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Куди він увійде, скажіть господареві дому: «Учитель питає: „Де Моя кімната, у якій Я буду споживати Пасху з Моїми учнями?“» ");
INSERT INTO ukronpu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","І він покаже вам нагорі велику прибрану й готову кімнату – там і приготуйте для нас. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Учні пішли й, прийшовши в місто, знайшли все саме так, як казав їм Ісус, та приготували там Пасху. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Коли настав вечір, Він прийшов разом із дванадцятьма. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","А як вони сиділи за столом та їли, Ісус сказав: ―Істинно кажу вам: один із вас, хто їсть зі Мною, зрадить Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Вони засмутилися й почали запитувати Його, один за одним: ―Це не я? ");
INSERT INTO ukronpu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Він сказав їм: ―Один із дванадцятьох, той, хто вмочає хліб разом зі Мною в миску. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Син Людський, безумовно, іде, як про Нього написано, але горе тому чоловікові, через якого зраджено Сина Людського. Було б краще тому чоловікові не народжуватись. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Коли вони їли, Ісус узяв хліб, благословив його, розламав та дав їм, кажучи: «Візьміть, це є тіло Моє». ");
INSERT INTO ukronpu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Потім узяв чашу, подякував і дав її учням, і пили з неї всі. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Він сказав їм: «Це кров Моя, кров Нового Завіту, яка проливається за багатьох. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Істинно кажу вам: не питиму більше з цього виноградного плоду до дня, коли питиму нове вино в Царстві Божому». ");
INSERT INTO ukronpu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","І, проспівавши пісні, вони пішли на Оливну гору. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Тоді Ісус сказав учням: ―Усі ви відмовитесь від Мене, бо написано: «Уражу пастиря – і вівці розсіються». ");
INSERT INTO ukronpu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Але після Мого воскресіння Я піду до Галілеї, і там ми зустрінемось. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Петро сказав Йому: ―Навіть якщо всі зречуться, я – ніколи. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ісус сказав йому: ―Істинно кажу тобі: цієї ночі, перед тим, як півень двічі заспіває, ти тричі зречешся Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Але Петро ще сильніше наполягав: ―Навіть якщо треба буде померти разом із Тобою, усе одно я не зречуся. І всі сказали так само. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Потім вони прийшли до місця, яке називається Гефсиманія, і Ісус сказав Своїм учням: ―Посидьте тут, поки Я помолюся. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Він узяв з Собою Петра, Якова та Івана й почав сумувати та тривожитись. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Він сказав їм: ―Моя душа страждає смертельно! Залишайтеся тут та пильнуйте. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","І, відійшовши трохи далі, упав на землю та молився, щоб, якщо можливо, ця година обминула Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Він казав: «Авва! Отче! Для Тебе все можливо! Нехай ця чаша обмине Мене. Але нехай буде не як Я хочу, а як Ти». ");
INSERT INTO ukronpu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Повернувшись, знайшов, що вони заснули, та сказав Петрові: ―Симоне, ти спиш? Чи не міг ти однієї години пильнувати? ");
INSERT INTO ukronpu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Пильнуйте та моліться, щоб вам не впасти в спокусу! Бо дух бадьорий, а тіло немічне. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","І знов відійшов та молився, кажучи ті ж слова. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Коли Він повернувся до учнів, знову знайшов, що вони сплять, бо їхні очі були обтяжені. Вони не знали, що відповісти Йому. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Коли прийшов утретє, сказав їм: ―Ви все ще спите та відпочиваєте? Досить, ось прийшла година, і Син Людський віддається в руки грішників. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Вставайте, ходімо! Ось наближається Мій зрадник. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","І відразу, коли Він ще говорив, підійшов Юда, один із дванадцятьох, і з ним натовп із мечами та киями – від первосвященників, книжників та старійшин. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Зрадник дав їм такий знак, кажучи: «Той, Кого я поцілую, це Він, арештовуйте Його й візьміть під варту!» ");
INSERT INTO ukronpu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Наблизившись, він відразу підійшов до Ісуса й сказав: «Равві!» – і поцілував Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Тоді вони наклали на Нього руки та заарештували Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Один із тих, хто стояв поруч із Ним, вихопив меч, ударив раба первосвященника й відрубав йому вухо. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Потім Ісус звернувся до них: «Ви вийшли проти Мене, як проти розбійника, з мечами та киями, щоб заарештувати Мене. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Щодня Я був із вами, навчав у Храмі, і ви не заарештовували Мене. Але це сталося, щоб збулося Писання». ");
INSERT INTO ukronpu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","І всі, залишивши Його, втекли. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Один юнак слідував за Ним, обгорнувшись у покривало на голе тіло. Вони схопили його, ");
INSERT INTO ukronpu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","але він, залишивши покривало, утік голий. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ісуса повели до первосвященника, де зібралися всі первосвященники, книжники та старійшини. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Петро ж ішов за Ісусом на відстані аж у двір первосвященника, сів разом зі слугами та грівся біля вогню. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Первосвященники й весь Синедріон шукали свідчення проти Ісуса, щоб вбити Його, але не знаходили. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Багато хто неправдиво свідчив проти Нього, але їхні свідчення не збігалися. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Деякі піднялися та неправдиво свідчили проти Нього, кажучи: ");
INSERT INTO ukronpu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ми чули, як Він казав: «Я зруйную цей Храм рукотворний і за три дні Я збудую інший, нерукотворний». ");
INSERT INTO ukronpu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Але і в цьому їхнє свідчення не підтвердилося. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Тоді первосвященник, піднявшись, став на середину й запитав Ісуса: ―Нічого не відповідаєш на те, що вони свідчать проти Тебе? ");
INSERT INTO ukronpu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Але Він мовчав і нічого не відповідав. Первосвященник запитав Його знову: ―Ти – Христос, Син Благословенного? ");
INSERT INTO ukronpu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ісус відповів: ―Я є. І ви побачите Сина Людського, Який сидить праворуч від Всемогутнього й приходить на хмарах небесних! ");
INSERT INTO ukronpu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Тоді первосвященник роздер свій одяг та сказав: ―Навіщо нам потрібні свідки? ");
INSERT INTO ukronpu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ви чули богохульство! Що скажете? І всі вони вирішили, що Він заслуговує на смерть. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Деякі почали плювати на Нього, закривали Йому обличчя та били кулаками, кажучи: «Пророкуй!» І слуги теж били Його в обличчя. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","У той час Петро був внизу, у дворі; туди підійшла й одна зі служниць первосвященника. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Коли вона побачила Петра, який грівся біля вогню, придивилася до нього й сказала: ―І ти був з Ісусом із Назарета. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Але Петро заперечив кажучи: ―Я не знаю й не розумію, про що ти говориш. Він вийшов геть на переддвер’я. І тоді заспівав півень. ");
INSERT INTO ukronpu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Служниця знов побачила його й почала казати всім присутнім: ―Цей чоловік – один із них! ");
INSERT INTO ukronpu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Але він знову заперечив цьому. Трохи пізніше ті, що були присутні там, сказали Петрові: ―Ти й справді один із них, бо ти галілеянин! ");
INSERT INTO ukronpu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Але він почав клястися та присягати кажучи: ―Не знаю Цього Чоловіка, про Якого ви говорите! ");
INSERT INTO ukronpu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","І одразу заспівав півень удруге. Тоді Петро згадав слова Ісуса: «Перед тим, як двічі заспіває півень, ти тричі зречешся Мене». І, згадавши, він гірко заплакав. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Вранці наступного дня первосвященники скликали раду разом зі старійшинами, книжниками та всім Синедріоном. Потім зв’язали Ісуса та повели й передали Його Пилатові. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Пилат запитав Його: ―Ти Цар юдеїв? Ісус відповів: ―Ти кажеш це! ");
INSERT INTO ukronpu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Первосвященники звинувачували Його в багатьох речах. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Пилат знов запитав Ісуса: ―Ти нічого не відповідаєш? Дивись, скільки проти Тебе обвинувачень! ");
INSERT INTO ukronpu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Але Ісус більше нічого не відповідав, і Пилат дуже здивувався. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","На кожне свято намісник відпускав їм одного з в’язнів, якого вони просили. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","У той час був один в’язень, на ім’я Варавва, який разом із бунтівниками був винний у вбивстві. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Люди прийшли й почали просити Пилата, щоб він зробив, як завжди. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Пилат відповів їм: ―Чи бажаєте, щоб я відпустив вам Царя юдеїв? ");
INSERT INTO ukronpu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Бо він знав, що через заздрощі первосвященники видали Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Але первосвященники вмовили людей просити, щоб краще відпустив їм Варавву. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Пилат знову звернувся до них: ―А що хочете, щоб я зробив із Тим, Кого називаєте Царем юдеїв? ");
INSERT INTO ukronpu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Вони ж знов закричали: ―Розіпни Його! ");
INSERT INTO ukronpu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Пилат запитав: ―Яке ж зло Він скоїв? Але вони ще сильніше закричали: ―Розіпни Його! ");
INSERT INTO ukronpu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","І так Пилат, бажаючи догодити людям, відпустив їм Варавву, а Ісуса наказав бичувати та віддав на розп’яття. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Воїни відвели Ісуса до двору, тобто до преторії, та скликали всю когорту. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Вони наділи на Нього багряницю, сплели та поклали на голову вінок із тернини. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","І почали вітати Його: «Вітаємо Тебе, Царю юдеїв!» ");
INSERT INTO ukronpu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Вони били Його тростиною по голові, плювали на Нього й, падаючи на коліна, вклонялися Йому. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Коли закінчили знущатися, зняли з Ісуса багряницю, надягнули на Нього Його одяг і відвели, щоб розіп’яти Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Воїни примусили одного перехожого, Симона з Кирени, що повертався з поля, батька Олександра та Руфа, нести хрест Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Привели Ісуса на Голгофу (що в перекладі означає «місце Черепа»). ");
INSERT INTO ukronpu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Дали Йому випити вина, змішаного з миррою, але Він не взяв. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Потім, розіп’явши Ісуса, вони розділили між собою Його одяг, кидаючи жереб, хто що візьме. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Коли Його розіп’яли, була третя година. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","І написали Його провину: цар юдеїв. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Разом із Ним розіп’яли двох розбійників: одного – праворуч, а іншого – ліворуч від Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","І збулося сказане у Святому Писанні: «Його зараховано до злочинців». ");
INSERT INTO ukronpu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ті, що проходили повз, богохульствували проти Нього. Вони хитали головами й казали: «Гей! Ти ж збирався зруйнувати Храм і відбудувати його за три дні. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Спаси Себе Самого, зійди з хреста!» ");
INSERT INTO ukronpu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Первосвященники разом із книжниками також насміхалися з Нього, кажучи між собою: «Інших рятував, а Себе не може врятувати! ");
INSERT INTO ukronpu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Якщо Він насправді Христос, Цар Ізраїля, то нехай зараз зійде з хреста, щоб ми побачили й повірили!» І ті, що були розіп’яті разом із Ним, також насміхалися з Нього. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Близько шостої години настала темрява по всій землі – аж до дев’ятої години. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","А о дев’ятій Ісус голосно закричав: «Елої, Елої, лема савахтані?» (що в перекладі означає: «Боже Мій, Боже Мій, чому Ти покинув Мене?») ");
INSERT INTO ukronpu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Деякі з тих, що там стояли, почувши це, казали: «Дивіться, Він кличе Іллю!» ");
INSERT INTO ukronpu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Хтось побіг, наповнив губку кислим вином, настромив на тростину й дав Йому пити, кажучи: «Облиште, побачимо, чи прийде Ілля зняти Його!» ");
INSERT INTO ukronpu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ісус же, голосно скрикнувши, віддав духа. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Завіса в Храмі розірвалася надвоє зверху донизу. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Сотник, який стояв навпроти Нього, побачивши, як Він помер, промовив: «Цей чоловік справді був Сином Божим!» ");
INSERT INTO ukronpu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Були там і деякі жінки, які стояли поодаль і дивилися. Серед них були Марія Магдалина, Марія – мати Якова молодшого та Йосії, і Саломія. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Коли Він був ще в Галілеї, вони слідували за Ним та служили Йому. Було й багато інших, які прийшли з Ним до Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Коли настав вечір, – а був день Приготування перед Суботою, – ");
INSERT INTO ukronpu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","прийшов Йосиф з Ариматеї, поважний радник, який теж очікував Царства Божого. Він наважився піти до Пилата та просити тіло Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Коли Пилат дізнався, що Ісус уже помер, то здивувався й, покликавши сотника, запитав у нього, чи давно Ісус помер. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Довідавшись від сотника, що Ісус дійсно помер, він віддав тіло Йосифові. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Йосиф купив льняну тканину і, знявши тіло Ісуса, обгорнув його в полотно й поклав до гробниці, яка була висічена в скелі. До входу в гробницю привалив камінь. ");
INSERT INTO ukronpu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Марія Магдалина та Марія, мати Йосії, дивилися, де Його поховали. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Після Суботи Марія, Марія Магдалина, Марія, мати Якова, і Саломія купили пахощі, щоб піти та намастити Його. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","На світанку першого дня тижня вони пішли до гробниці ");
INSERT INTO ukronpu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","й говорили між собою: «Хто відкотить нам камінь від входу в гробницю?» ");
INSERT INTO ukronpu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Але коли придивилися, то побачили, що камінь, який був дуже великий, відкочено. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Увійшовши до гробниці, побачили юнака, одягненого в білий одяг, який сидів праворуч. Вони дуже злякалися. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Але він сказав їм: «Не бійтеся! Ви шукаєте Ісуса з Назарета, Який був розіп’ятий? Немає Його тут: Він воскрес! Подивіться на місце, де Його поклали. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ідіть та скажіть Його учням та Петрові, що Він іде перед вами в Галілею, там Його побачите, як Він казав вам». ");
INSERT INTO ukronpu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Вони вийшли та побігли геть від гробниці, бо їх охопило тремтіння та подив. Вони нікому нічого не сказали, адже були охоплені страхом. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Після Свого воскресіння вранці першого дня тижня Ісус найперше з’явився Марії Магдалині, з якої вигнав сім демонів. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Вона пішла та сповістила Його учнів, які плакали та сумували. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Почувши, що Він живий і що вона Його бачила, вони не повірили. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Після цього, Він з’явився в іншому вигляді двом із них, які йшли до села. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Вони повернулися та сповістили іншим, але їм теж не повірили. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Нарешті Він з’явився одинадцятьом, коли вони були за столом. Він докоряв їм за їхню невіру та впертість, бо не повірили тим, хто бачив Його воскреслим із мертвих. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Потім промовив: «Ідіть по всьому світі та проповідуйте Добру Звістку всім людям! ");
INSERT INTO ukronpu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Хто повірить та охреститься, буде спасенний, а хто не повірить, буде засуджений. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Такі ознаки будуть супроводжувати тих, хто увірував: в ім’я Моє будуть виганяти демонів, говоритимуть новими мовами, ");
INSERT INTO ukronpu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","якщо братимуть до рук змій або вип’ють отруту, це не нашкодить їм, на хворих покладатимуть руки, і ті зціляться». ");
INSERT INTO ukronpu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Після того, як Господь Ісус промовив до них ці слова, Він вознісся на небо й сів праворуч від Бога. ");
INSERT INTO ukronpu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Вони пішли та проповідували по всьому світі, а Господь допомагав їм і підтверджував Слово ознаками, що його супроводжували.");
INSERT INTO ukronpu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Оскільки багато хто вже намагався скласти розповідь про події, які сталися між нами, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","у такий спосіб, як їх передали нам люди, що від самого початку були свідками й котрі стали служителями Слова, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","то і я вирішив, дослідивши все ретельно від самого початку, написати тобі, поважний Теофіле, усе послідовно, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","щоб ти міг досконало пізнати достовірність слів, яких був навчений. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","За днів Ірода, царя Юдеї, був один священник, на ім’я Захарія, із черги Авія, та його дружина, на ім’я Єлизавета, одна з дочок Аарона. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Вони обоє були праведні перед Богом, бездоганно виконуючи всі заповіді та настанови Господа. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","У них не було дітей, бо Єлизавета була безплідна, і обоє були похилого віку. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Одного разу, коли Захарія за порядком своєї черги служив перед Богом, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","згідно зі звичаєм священства, випало йому через жереб зайти до Храму Господнього та кадити. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Усе зібрання народу молилося зовні, коли прийшов час кадити. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Тоді ангел Господній з’явився перед ним, стоячи з правого боку жертовника для кадіння. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Коли Захарія побачив його, то жахнувся, і страх охопив його. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Але ангел сказав йому: ―Не бійся, Захаріє, твоя молитва почута! Твоя дружина Єлизавета народить тобі сина, і назвеш його Іван. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ти будеш радісним та щасливим, і багато хто радітиме його народженню. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Він буде великий перед Господом, вина та міцного напою не питиме; і Дух Святий наповнить його ще з лона його матері. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","І багатьох синів Ізраїлю він наверне до Господа Бога свого. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Він ітиме перед Ним у дусі й силі Іллі, наверне серця батьків до дітей та непокірних до мудрості праведних, щоб підготувати народ до приходу Господа. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Захарія відповів ангелу: ―Як я дізнаюся про це? Я вже старий, і дружина моя в похилих літах. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ангел у відповідь сказав йому: ―Я Гавриїл, що стою перед Богом, і мене послано сказати тобі цю добру звістку, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","але тепер ти будеш мовчати й не зможеш говорити до дня, коли все це станеться, бо ти не повірив моїм словам, котрі здійсняться свого часу! ");
INSERT INTO ukronpu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Народ же чекав на Захарію та дивувався, чому він затримується в Храмі. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Коли ж він вийшов, то вже не міг говорити, і всі зрозуміли, що в Храмі він бачив видіння. Захарія звертався до них знаками та залишався німим. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Після закінчення днів його служіння, він повернувся додому. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Невдовзі після цього Єлизавета, його дружина, завагітніла й п’ять місяців ховалася, кажучи: ");
INSERT INTO ukronpu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Ось що для мене зробив Господь у ці дні, коли зглянувся, щоб зняти ганьбу мою між людьми». ");
INSERT INTO ukronpu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Шостого місяця Бог надіслав ангела Гавриїла в галілейське місто, яке називалося Назарет, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","до діви, що була заручена з чоловіком, на ім’я Йосиф, з дому Давида. Ім’я діви було Марія. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Прийшовши до неї, ангел промовив: ―Радій, та, що отримала благодать! Господь із тобою! Благословенна ти між жінками. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ці слова здивували її, і вона почала роздумувати, що може означати це привітання. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ангел відповів їй: ―Не бійся, Маріє, бо ти знайшла благодать у Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ось завагітнієш та народиш Сина, і назвеш Його Ісус. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Він буде великий, і Його називатимуть Сином Всевишнього. Господь Бог дасть Йому престол Давида, батька Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Він царюватиме над домом Якова повіки, і Його Царству не буде кінця. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Марія відповіла ангелу: ―Як же це станеться, якщо я не була з чоловіком? ");
INSERT INTO ukronpu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","У відповідь ангел сказав: ―Дух Святий зійде на тебе, і сила Всевишнього обгорне тебе, тому Святий, Який народиться, назветься Сином Божим. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ось Єлизавета, твоя родичка, завагітніла у своїй старості й чекає на сина; і оце вже шостий місяць тій, що її звуть безплідною, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","бо у Бога ніяке слово не буває безсилим. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Марія відповіла: ―Ось я, раба Господня, нехай усе станеться за словом твоїм. І ангел відійшов від неї. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Тими днями Марія зібралася й пішла, поспішаючи, у гірську околицю, в одне з міст Юдиних. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Вона зайшла в дім Захарії і привітала Єлизавету. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Коли Єлизавета почула привітання Марії, то дитя в її лоні заворушилося від радості, а Єлизавета наповнилася Духом Святим. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Вона голосно промовила: ―Благословенна ти між жінками, і благословенна Дитина, Яку ти народиш! ");
INSERT INTO ukronpu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","І звідкіля мені це, що мати Господа мого прийшла до мене? ");
INSERT INTO ukronpu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Як тільки я почула голос твого привітання, дитина в моєму лоні заворушилася від радості. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Блаженна та, яка повірила, що здійсниться все сказане їй від Господа! ");
INSERT INTO ukronpu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","І сказала Марія: «Величає душа моя Господа, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","та радіє дух мій у Бозі, Спасителі моєму, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","бо зглянувся Він на покору раби Своєї. Ось чому віднині всі покоління називатимуть мене блаженною, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","бо велике вчинив мені Всемогутній. Святе ім’я Його! ");
INSERT INTO ukronpu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Милість Свою Він показує з роду в рід тим, хто боїться Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Він зробив велику справу Своєю рукою, розсіяв гордих у думках сердець їхніх. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Скинув сильних з престолу та підняв принижених. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Голодних нагодував благами, а заможних відіслав ні з чим. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Допоміг Ізраїлеві, слузі Своєму, згадавши милість, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","так, як обіцяв батькам нашим, Авраамові та нащадкам його повіки!» ");
INSERT INTO ukronpu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Марія залишилася з Єлизаветою три місяці, а потім повернулася до себе додому. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Коли настав час, Єлизавета народила сина. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","І почули сусіди та родичі, що Господь проявив Свою велику милість до неї, та раділи разом із нею. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Восьмого дня, коли прийшли обрізати немовля, хотіли назвати його ім’ям батька – Захарія. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Але мати його відповіла: ―Ні! Він буде називатися Іван. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","А вони сказали їй: ―У твоїй родині немає нікого, названого таким ім’ям. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Знаками запитали його батька, як він бажає його назвати. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Він попросив дощечку для запису та написав: «Його ім’я – Іван!» І всі дивувалися. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Тієї ж миті відкрилися його вуста: він почав говорити, благословляючи Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","І страх охопив усіх сусідів, і всюди в гірській частині Юдеї говорили про ці події. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Кожен, хто чув це, говорив у своєму серці: «Ким же стане це дитя?» Бо рука Господа була з ним. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Захарія, батько його, наповнився Духом Святим і почав пророкувати: ");
INSERT INTO ukronpu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Благословен Господь, Бог Ізраїлю, бо прийшов Він на допомогу та визволив народ Свій. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Він підняв нам ріг спасіння у домі Давида, слуги Свого, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","як заповів колись у давнину через вуста Своїх святих пророків, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","що визволить нас від ворогів наших та від усіх, хто ненавидить нас. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Він проявив милість до батьків наших, пам’ятаючи про Свій святий заповіт, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","обітницю, яку Він дав нашому батькові Аврааму, – ");
INSERT INTO ukronpu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","визволити нас від руки ворогів, щоб ми служили Йому без страху ");
INSERT INTO ukronpu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","у святості й праведності перед лицем Його в усі дні наші. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","І ти, дитино, назвешся пророком Всевишнього, бо йтимеш перед Господом, готуючи шляхи Йому, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","щоб дати пізнання спасіння народові Його, через прощення гріхів їхніх. ");
INSERT INTO ukronpu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Через велику милість Бога нашого, з якою прийде нам на допомогу, як Вранішня Зоря з висоти, ");
INSERT INTO ukronpu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","щоб засіяти над тими, що живуть у темряві й у тіні смерті, спрямовуючи наші кроки на шлях миру». ");
INSERT INTO ukronpu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Дитина ж росла та зміцнювалась духом і перебувала в пустелі до дня, коли з’явилася перед Ізраїлем. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","У ті дні вийшов наказ від Кесаря Августа зробити перепис усього населення. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Це був перший перепис за правління Квірінія Сирією. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","І всі пішли записатися, кожний до свого міста. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Пішов також і Йосиф із Галілеї, з міста Назарета, в Юдею, у місто Давида, що зветься Віфлеєм, бо він походив із дому та роду Давида. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Він пішов записатися разом із Марією, своєю нареченою, що була вагітна. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","І сталося так, що коли вони були там, настав їй час народити. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","І народила вона Сина, свого Первістка, і сповила Його, і поклала в ясла, бо не було для них місця в гостьовій кімнаті. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Були ж у тій місцевості пастухи, які стояли в полі й охороняли вночі свою отару. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Аж ось ангел Господа з’явився біля них, і слава Господня засіяла навколо, і великий страх охопив їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","І промовив до них ангел: «Не бійтеся! Я приніс вам добру звістку, яка буде великою радістю для всього народу! ");
INSERT INTO ukronpu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Сьогодні в місті Давида народився вам Спаситель – Христос Господь! ");
INSERT INTO ukronpu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","І ось вам знак: знайдете сповите Немовля, Яке лежатиме в яслах». ");
INSERT INTO ukronpu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","І раптом разом з ангелом з’явилося численне небесне військо, яке прославляло Бога, кажучи: ");
INSERT INTO ukronpu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Слава Богу на небесах, а на землі мир людям, в яких перебуває Його добра воля!» ");
INSERT INTO ukronpu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Коли ангели повернулися на небо, пастухи почали говорити один одному: «Ходімо до Віфлеєма й побачимо, що там сталося, про що Господь сповістив нас». ");
INSERT INTO ukronpu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","І пішли вони швидко до Віфлеєма й знайшли Марію, Йосифа й Немовля, покладене в ясла. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Побачивши їх, вони розповіли все, що їм було сказано про Цю Дитину. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Усі, хто чув, дивувалися тому, що розповідали пастухи про Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Марія ж зберігала всі ці слова у своєму серці та роздумувала над ними. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","І повернулись пастухи, прославляючи та вихваляючи Бога за все те, що почули й побачили, і за те, що все було так, як їм було сказано. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Восьмого дня, коли настав час обрізати Дитя, назвали Його Ісус – саме так, як оголосив ангел ще до Його зачаття в утробі. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","І коли, за Законом Мойсея, закінчилися дні очищення, принесли Його до Єрусалима, щоб представити перед Господом, ");
INSERT INTO ukronpu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","як написано в Законі Господа: «Кожен первісток чоловічої статі має бути посвячений Господу». ");
INSERT INTO ukronpu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","За Законом Господа вони мали також принести жертву: «Дві горлиці або двох молодих голубів». ");
INSERT INTO ukronpu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Був тоді в Єрусалимі чоловік, на ім’я Симеон. Він був чоловіком праведним та благочестивим, чекав на утіху Ізраїлю, і Дух Святий був на ньому. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","І було відкрито йому Духом Святим, що він не бачитиме смерті, поки не побачить Христа Господнього. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Керований Духом, він прийшов у Храм, і коли батьки принесли Дитину Ісуса, щоб зробити з Ним за звичаєм Закону, ");
INSERT INTO ukronpu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","він узяв Його на руки, благословив Бога та промовив: ");
INSERT INTO ukronpu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«А зараз, Владико, відпусти раба Твого з миром, за словом Твоїм, ");
INSERT INTO ukronpu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","бо побачили очі мої спасіння Твоє, ");
INSERT INTO ukronpu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","яке Ти приготував перед обличчям усіх народів, ");
INSERT INTO ukronpu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","світло одкровення для язичників і славу народу Твого Ізраїлю». ");
INSERT INTO ukronpu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Батько та мати Ісуса дивувалися сказаному про Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Симеон же благословив їх та сказав Марії, матері Його: «Ось Цей призначений для падіння й піднесення багатьох в Ізраїлі, Він буде знаком протиріччя, ");
INSERT INTO ukronpu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","так що думки багатьох сердець розкриються. І навіть душу твою пройме меч». ");
INSERT INTO ukronpu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Була там і пророчиця Анна, дочка Фануїла, з роду Ашера; вона дожила до глибокої старості. Зі своїм чоловіком вона прожила сім років від одруження, ");
INSERT INTO ukronpu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","а потім стала вдовою, їй було вісімдесят чотири роки. Вона не відходила від Храму, постом та молитвою служила вдень і вночі. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Прийшовши в той час, вона прославляла Бога і всім, хто чекав на визволення Єрусалима, говорила про Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","І коли виконали все згідно із Законом Господа, повернулися до Галілеї, до свого міста Назарета. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Дитина ж росла та зміцнювалась, сповнюючись мудрістю, і благодать Божа була на Ній. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Кожного року батьки Ісуса ходили до Єрусалима на свято Пасхи. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Коли виповнилося Йому дванадцять років, Він, за звичаєм, пішов разом із ними. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Коли ж закінчилися дні свята і всі поверталися додому, Хлопчик Ісус залишився в Єрусалимі, а батьки Його не знали про це. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Вони думали, що Він іде разом з іншими. Пройшовши день дороги, вони почали шукати Його серед родичів та знайомих. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","І, не знайшовши, повернулися до Єрусалима шукати Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Через три дні знайшли Його в Храмі, де Він сидів серед учителів, слухав їх та розпитував. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Усі, хто Його чув, дивувалися Його розуму та відповідям. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Побачивши Його, вони здивувались, і мати промовила до Нього: ―Дитино, чому Ти так вчинив із нами? Ось Твій батько і я з хвилюванням шукали Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Але Він відповів їм: ―Чому ви шукали Мене? Хіба ви не знали, що Мені треба бути в тому, що належить Моєму Отцю? ");
INSERT INTO ukronpu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Але вони не зрозуміли слів, які Він їм сказав. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Після цього вони повернулися до Назарета, і Він слухався їх. Мати Його зберігала всі ці слова у своєму серці. ");
INSERT INTO ukronpu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ісус же зростав мудрістю, ростом і благодаттю у Бога та людей. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","П’ятнадцятого року царювання Кесаря Тиберія, коли Понтій Пилат правив Юдеєю, Ірод був тетрархом Галілеї, його брат, Филип, був тетрархом земель Трахонії та Ітуреї, а Лісаній був тетрархом Авілінії, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","коли первосвященниками були Анна та Каяфа, було Слово Боже до Івана, сина Захарії, у пустелі. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Іван пройшов усю околицю Йордану й проповідував хрещення покаяння для прощення гріхів, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","як написано в книзі слів пророка Ісаї: «Голос кличе в пустелі: „Приготуйте дорогу Господеві, вирівняйте шляхи для Нього! ");
INSERT INTO ukronpu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Нехай кожен яр наповниться і всяка гора та пагорб знизяться. Криві дороги нехай стануть прямими, а нерівні – рівними, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","і всі люди побачать спасіння Боже“». ");
INSERT INTO ukronpu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Іван казав так народові, що приходив хреститися в нього: ―Роде гадючий! Хто порадив вам тікати від гніву, що наближається? ");
INSERT INTO ukronpu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Чиніть же плоди, достойні покаяння, і не думайте говорити в собі: «Наш батько – Авраам!» Бо кажу вам: Бог може з цього каміння створити дітей для Авраама! ");
INSERT INTO ukronpu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Уже й сокира лежить біля коріння дерев! Кожне дерево, яке не приносить доброго плоду, зрубають та вкидають у вогонь. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Люди питали його: ―Що ж нам робити? ");
INSERT INTO ukronpu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","У відповідь він казав: ―Хто має дві сорочки, нехай віддасть одну тому, хто не має жодної, і хто має їжу, хай зробить так само. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Прийшли й митники хреститися та спитали його: ―Учителю, а нам що робити? ");
INSERT INTO ukronpu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Він відповів: ―Не беріть більше від того, що вам призначено. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Воїни теж спитали його: ―А що нам робити? Він відповів: ―Нічого не беріть силою, не обвинувачуйте нікого неправдиво, задовольняйтеся своєю платнею. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Народ був в очікуванні, усі розмірковували у своїх серцях про Івана, чи не він Христос. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Іван, відповідаючи всім, сказав: ―Я хрещу вас водою, але йде Сильніший за мене, Якому я не достойний розв’язати ремінці Його сандалій. Він буде хрестити вас Духом Святим та вогнем. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","У Його руці лопата, Він ретельно очистить Свій тік, збиратиме Свою пшеницю до житниці, а полову спалить у невгасимому вогні. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","І багато іншого казав він, звіщаючи Добру Звістку народу. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Але коли він почав осуджувати тетрарха Ірода за Іродіаду, дружину його брата, а також за все зло, що він зробив, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","то Ірод до всього додав ще й те, що замкнув Івана до в’язниці. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","І сталося, коли хрестився весь народ, і Ісус, охрестившись, молився, розкрилися небеса. ");
INSERT INTO ukronpu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","І Дух Святий зійшов на Нього в тілесному вигляді, як голуб, і голос із неба пролунав: «Ти Син Мій улюблений, Тебе Я вподобав!» ");
INSERT INTO ukronpu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ісус, починаючи служіння, був років тридцяти, і всі вважали Його сином Йосифа, сина Іллі, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","сина Матата, сина Левія, сина Мелхія, сина Янная, сина Йосифа, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","сина Мататії, сина Амоса, сина Наума, сина Еслі, сина Наггея, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","сина Маата, сина Мататія, сина Семена, сина Іосиха, сина Йоди, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","сина Іоана, сина Риса, сина Зоровавеля, сина Салатиїла, сина Нерія, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","сина Мелхія, сина Аддія, сина Косама, сина Елмадама, сина Іра, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","сина Ісуса, сина Еліезера, сина Іоріма, сина Матати, сина Левія, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","сина Симеона, сина Юди, сина Йосифа, сина Йонама, сина Еліакима, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","сина Мелея, сина Менна, сина Матати, сина Натама, сина Давида, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","сина Єссея, сина Овіда, сина Воаза, сина Сала, сина Наасона, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","сина Аммінадава, сина Адміна, сина Арні, сина Есрома, сина Фареса, сина Юди, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","сина Якова, сина Ісаака, сина Авраама, сина Тара, сина Нахора, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","сина Серуха, сина Рагава, сина Фалека, сина Евера, сина Селаха, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","сина Каїнама, сина Арфахада, сина Сима, сина Ноя, сина Ламеха, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","сина Метусали, сина Еноха, сина Ярета, сина Малелеїла, сина Каїнама, ");
INSERT INTO ukronpu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","сина Еноса, сина Сета, сина Адама, сина Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ісус, сповнений Духа Святого, повернувся від Йордану, і Дух повів Його в пустелю. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Сорок днів спокушав Його диявол, і увесь цей час Ісус нічого не їв. Коли ж ці дні закінчилися, Він зголоднів. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Тоді диявол промовив до Нього: ―Якщо Ти Син Божий, скажи ось цьому каменю, щоб став хлібом! ");
INSERT INTO ukronpu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ісус відповів йому: ―Написано: «Не одним тільки хлібом буде жити людина, але кожним словом Божим». ");
INSERT INTO ukronpu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Тоді, вивівши Його на високу гору, диявол в одну мить показав Йому всі царства світу ");
INSERT INTO ukronpu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","й сказав Йому: ―Тобі віддам усі ці царства, всю владу й славу, бо вони передані мені, і кому я хочу, тому й віддаю їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Якщо Ти тільки поклонишся переді мною, усе буде Твоїм! ");
INSERT INTO ukronpu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ісус відповів: ―Написано: «Господу Богу твоєму поклоняйся і Йому єдиному служи». ");
INSERT INTO ukronpu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Тоді диявол повів Його до Єрусалима й, поставивши на покрівлю Храму, сказав Йому: ―Якщо Ти Син Божий, кинься вниз із цього місця, ");
INSERT INTO ukronpu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","бо написано: «Ангелам Своїм Він віддасть наказ про Тебе, щоб охороняли Тебе». ");
INSERT INTO ukronpu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","А також: «На своїх долонях вони понесуть Тебе, щоб не спіткнулася нога Твоя об камінь». ");
INSERT INTO ukronpu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ісус сказав у відповідь: ―Сказано: «Не спокушай Господа Бога твого!» ");
INSERT INTO ukronpu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Закінчивши всі ці спокушання, диявол залишив Його до певного часу. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ісус повернувся в силі Духа до Галілеї, і чутка про Нього розійшлася по всій околиці. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Він навчав у їхніх синагогах, і всі Його прославляли. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ісус прийшов до Назарета, у місто, де Він виріс. У день Суботній, за Своїм звичаєм, увійшов у синагогу й встав, щоб читати. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Йому дали книгу пророка Ісаї, і Він, розгорнувши її, знайшов місце, де було написано: ");
INSERT INTO ukronpu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Дух Господній на Мені, тому що Він помазав Мене, щоб звіщати Добру Звістку бідним, послав Мене проголосити свободу полоненим і сліпим прозріння, визволити зневолених, ");
INSERT INTO ukronpu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","проповідувати рік Господнього милосердя». ");
INSERT INTO ukronpu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","І, згорнувши книгу, віддав її служителю та сів. Очі всіх у синагозі були звернені на Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Тоді Він почав говорити до них: ―Сьогодні здійснилося Писання, яке ви чули. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Усі присутні говорили добре про Нього й дивувалися словам благодаті, які Він казав. Вони запитували: ―Хіба це не син Йосифа? ");
INSERT INTO ukronpu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Він сказав їм: ―Ви, безперечно, скажете Мені це прислів’я: «Лікарю, спочатку зцілися Сам! Зроби тут, на своїй батьківщині, те, що, ми чули, було в Капернаумі». ");
INSERT INTO ukronpu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","І продовжив: ―Істинно кажу вам: ніякого пророка не приймають на своїй батьківщині. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Та істинно кажу вам: багато вдів було за днів Іллі в Ізраїлі, коли небо замкнулося на три роки й шість місяців і коли настав великий голод на всій землі, ");
INSERT INTO ukronpu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","але до жодної з них не був посланий Ілля, а тільки до вдови в Сарепту Сидонську. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","І багато прокажених було в Ізраїлі за часів пророка Єлисея, але жоден із них не очистився, окрім Неємана-сирійця. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Почувши це, усі в синагозі наповнилися гнівом. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Вони піднялися, вивели Його з міста та повели до краю гори, на якій було збудоване їхнє місто, щоби скинути Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Але Ісус, пройшовши крізь натовп, віддалився. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","І прийшов Він до галілейського міста Капернаума та навчав людей у Суботу. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Усі дивувалися Його вченню, бо слова Його мали владу. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","У синагозі був чоловік, котрий мав демона, нечистого духа, і він голосно закричав: ");
INSERT INTO ukronpu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Облиш! Що Тобі до нас, Ісусе з Назарета? Ти прийшов знищити нас? Я знаю, Хто Ти – Святий Божий! ");
INSERT INTO ukronpu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Але Ісус наказав йому: ―Замовкни та вийди з нього! І демон, кинувши його на середину, вийшов із нього, не заподіявши йому жодної шкоди. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Усіх охопило здивування, і казали одне до одного: «Що це за вчення таке, що владою та силою наказує нечистим духам, і вони виходять?» ");
INSERT INTO ukronpu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","І розійшлася чутка про Ісуса по всіх навколишніх місцях. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Вийшовши з синагоги, Ісус пішов у дім Симона. А теща Симона була в сильній гарячці; і попросили Його за неї. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Підійшовши до неї, Він наказав гарячці відійти, і хвороба залишила її. Жінка негайно встала та почала прислуговувати їм. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Коли заходило сонце, усі, хто мав хворих на різні недуги, приводили їх до Ісуса, і, покладаючи руки на кожного, Він зцілив їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","З багатьох вигнав демонів, але вони викрикували: «Ти – Син Божий!» Він же не дозволяв демонам говорити, бо вони знали, що Він – Христос. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","На світанку Він вийшов та пішов у пустинне місце. Люди шукали Його й, коли знайшли, намагалися затримати, щоб Він не йшов від них. ");
INSERT INTO ukronpu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Але Він казав їм: «І в інших містах Я повинен звіщати Добру Звістку про Царство Боже, адже для цього Я посланий». ");
INSERT INTO ukronpu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","І продовжував проповідувати в синагогах Юдеї. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Одного разу, коли Ісус знаходився біля озера Генезарет і натовп людей тиснувся до Нього, аби слухати Слово Боже, ");
INSERT INTO ukronpu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Він побачив два човни, що стояли біля берега. А рибалки, вийшовши з них, чистили сіті. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ісус увійшов до одного з човнів, який належав Симонові, попросив його відплисти трохи від берега й, присівши, навчав людей із човна. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Коли ж закінчив говорити, сказав Симонові: ―Відпливи на глибину, та закиньте сіті для лову. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Симон сказав у відповідь: ―Наставнику, ми цілу ніч працювали та нічого не впіймали, але за Твоїм словом я закину сіті. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Зробивши це, піймали так багато риби, що сіті почали рватись. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Вони покликали й своїх товаришів з іншого човна, щоб прийшли допомогти їм. Ті прийшли й наповнили рибою обидва човни так, що вони стали потопати. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Побачивши це, Симон Петро припав до колін Ісуса та промовив: ―Господи, відійди від мене, бо я людина грішна! ");
INSERT INTO ukronpu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Адже страх охопив його й усіх, хто був із ним, від такої кількості спійманої риби, ");
INSERT INTO ukronpu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","а також Якова та Івана, синів Зеведеєвих, котрі були спільниками Симона. І промовив Ісус до Симона: ―Не бійся, віднині будеш ловити людей. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Витягнувши човни на берег, вони залишили все та пішли за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Коли Ісус перебував в одному місті, прийшов до нього чоловік, що був увесь покритий проказою. Побачивши Ісуса, він впав долілиць та просив Його, кажучи: ―Господи, якщо хочеш, Ти можеш мене очистити. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ісус простягнув руку, доторкнувся до нього й промовив: ―Хочу, будь чистим! І вмить проказа залишила його. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ісус наказав йому: ―Нікому не кажи про це, але йди, покажи себе священникові та принеси жертву за своє очищення, як наказав Мойсей, їм на свідчення. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Однак звістка про Ісуса розходилася ще більше, і багато людей приходило до Нього послухати та отримати зцілення від своїх хвороб. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Він же відходив у пустелю та молився там. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Одного дня, коли Ісус навчав людей, були там фарисеї та вчителі Закону, що прийшли з усіх сіл Галілеї та Юдеї, а також з Єрусалима; і сила Господня була з Ним, щоби зцілювати, ");
INSERT INTO ukronpu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","І ось декілька людей принесли на носилках паралізованого та хотіли внести його й поставити перед Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Не маючи можливості внести його через натовп, вони залізли на дах та спустили його разом із носилками через отвір у покрівлі на середину, прямо перед Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Побачивши їхню віру, Він промовив: «Друже, прощаються тобі гріхи твої!» ");
INSERT INTO ukronpu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Книжники та фарисеї почали розмірковувати кажучи: «Хто Він такий, що богохульствує? Хто може прощати гріхи, окрім Самого Бога?» ");
INSERT INTO ukronpu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Але Ісус, знаючи їхні думки, відповів: «Чому ви так роздумуєте у ваших серцях? ");
INSERT INTO ukronpu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Що легше сказати: „Прощаються тобі гріхи твої!“ чи „Встань і ходи!“? ");
INSERT INTO ukronpu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Але щоб ви знали: Син Людський має владу на землі прощати гріхи». І промовив до паралізованого: «Кажу тобі: встань, візьми свої носилки та йди додому!» ");
INSERT INTO ukronpu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Той відразу ж встав перед ними, узяв те, на чому лежав, і пішов додому, прославляючи Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Усіх охопив подив, і почали прославляти Бога. Сповнені страхом, вони говорили: «Дивовижні речі ми бачили сьогодні!» ");
INSERT INTO ukronpu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Після цього Ісус вийшов та побачив митника, на ім’я Левій, що сидів при збиранні мита, і сказав йому: «Іди за Мною!» ");
INSERT INTO ukronpu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Залишивши все, той піднявся й пішов за Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","І влаштував Йому Левій у своєму домі велику гостину; там було багато митників та інших, що сиділи з Ісусом за столом. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","А фарисеї та книжники нарікали, кажучи Його учням: ―Чому ви їсте та п’єте разом із митниками й грішниками? ");
INSERT INTO ukronpu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ісус же відповів їм: ―Не здорові потребують лікаря, а хворі. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Я прийшов покликати до покаяння не праведних, а грішників. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Тоді вони сказали Йому: ―Учні Івана часто постяться та моляться, так роблять і фарисеї, а Твої їдять і п’ють! ");
INSERT INTO ukronpu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ісус відповів: ―Чи можете друзів нареченого змусити постити, доки наречений з ними? ");
INSERT INTO ukronpu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Але настануть дні, коли наречений забереться від них, і тоді поститимуть у ті дні. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Він розповів їм притчу: ―Ніхто не розриває нової одежі, щоби з неї пришити латку до старої одежі, бо й нову розірве, і до старої не пасує латка з нової. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ніхто не вливає молодого вина в старі бурдюки, бо молоде вино розірве їх і виллється, а бурдюки пропадуть. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Але молоде вино треба вливати в нові бурдюки. ");
INSERT INTO ukronpu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","І ніхто, випивши старого вина, не захоче молодого, бо каже: «Старе краще!» ");
INSERT INTO ukronpu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Одного разу в Суботу Ісус зі своїми учнями проходив через засіяні поля пшениці. Вони збирали колосся та, розтираючи їх руками, їли зерна. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Тоді деякі з фарисеїв сказали: ―Чому ви робите те, чого не дозволено робити в Суботу? ");
INSERT INTO ukronpu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ісус у відповідь сказав їм: ―Ви не читали, що зробив Давид,коли зголоднів він, а також і ті, що були з ним? ");
INSERT INTO ukronpu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Як увійшов у Дім Божий, узяв та з’їв хліби покладання, і як дав і тим, хто був із ним, хоча їх не дозволено було їсти нікому, окрім священників? ");
INSERT INTO ukronpu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","І додав: ―Син Людський – Господь Суботи. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Довелося ж і в іншу Суботу увійти Йому в синагогу й навчати. Там був чоловік, у якого права рука всохла. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Книжники та фарисеї уважно стежили за Ісусом, чи буде Він зцілювати в Суботу, щоб знайти обвинувачення проти Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Але Він, знаючи їхні думки, сказав чоловікові, що мав всохлу руку: «Підведися й стань посередині!» Той піднявся й став. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ісус промовив до них: «Я питаю вас: що дозволено робити в Суботу – добро чи зло? Спасти життя чи згубити?» ");
INSERT INTO ukronpu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","І, поглянувши на них усіх, сказав чоловікові: «Простягни свою руку!» Той зробив це, і його рука була зцілена. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Вони ж розлютилися та почали радитись між собою, як вчинити з Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","У ті дні Ісус вийшов на гору, щоб молитись, і провів усю ніч у молитві до Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Коли настав день, Він покликав учнів і обрав дванадцятьох, яких назвав апостолами: ");
INSERT INTO ukronpu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Симона, якого назвав Петром, Андрія, його брата, Якова, Івана, Филипа, Варфоломія, ");
INSERT INTO ukronpu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Матвія, Фому, Якова, сина Алфеєвого, Симона, званого Зилотом, ");
INSERT INTO ukronpu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Юду, сина Якова, і Юду Іскаріота, котрий потім став зрадником. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ісус, зійшовши разом із ними з гори, зупинився на рівному місці. Великий натовп Його учнів і велика кількість народу зі всієї Юдеї, Єрусалима та приморського Тира й Сидона ");
INSERT INTO ukronpu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","прийшли послухати Його та отримати зцілення від хвороб. Ті, що страждали від нечистих духів, теж були зцілені. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Весь натовп хотів доторкнутися до Ісуса, бо від Нього виходила сила, яка зцілювала всіх. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ісус, звівши очі на Своїх учнів, почав говорити: «Блаженні бідні, бо ваше є Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Блаженні голодні нині, бо будете насичені. Блаженні, що плачете тепер, бо ви зрадієте. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Блаженні ви, коли люди зненавидять вас, коли проженуть вас, ображатимуть вас і відкидатимуть ваше ім’я як щось погане через Сина Людського. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Радійте того дня й веселіться, бо велика ваша нагорода на небі. Так само робили з пророками їхні батьки. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Але горе вам, багатії, бо ви вже отримали всю вашу втіху. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Горе вам, ситі нині, бо будете голодувати. Горе вам, що радієте нині, бо будете плакати й ридати. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Горе вам, коли про вас говоритимуть добре всі люди, бо так робили лжепророкам їхні батьки. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Але вам, хто слухає, Я кажу: любіть ворогів ваших, робіть добро тим, хто ненавидить вас; ");
INSERT INTO ukronpu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","благословляйте тих, хто проклинає вас; моліться за тих, хто кривдить вас. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Тому, хто вдарив тебе по щоці, підстав і другу, а тому, хто забирає твій верхній одяг, не забороняй взяти й сорочку. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Кожному, хто просить у тебе, дай, і від того, хто забере твоє, не проси назад. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Як бажаєте, щоб вам робили люди, так само й ви робіть їм. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Якщо ви любите тільки тих, хто любить вас, яка вам за це дяка? Адже й грішники люблять тих, хто любить їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","І якщо ви робите добро тільки тим, хто вам робить добро, яка вам за це дяка? Грішники так само роблять. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","І якщо позичаєте тільки тим, від кого сподіваєтесь отримати, яка вам за це дяка? Грішники так само позичають, щоб отримати стільки ж. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Але ви любіть ворогів ваших, робіть добро й позичайте, не очікуючи нічого. І буде вам велика нагорода, будете синами Всевишнього, бо Він добрий до невдячних та злих. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Будьте милосердні, як і Отець ваш милосердний. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Не судіть, і вас не судитимуть! Не засуджуйте, то й вас не засудять! Прощайте, то й вам проститься! ");
INSERT INTO ukronpu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Давайте, і вам дадуть; доброю мірою, притиснутою, струснутою і переповненою дадуть вам. Бо якою мірою міряєте ви, такою ж виміряють і вам». ");
INSERT INTO ukronpu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Він також розповів їм притчу: «Чи може сліпий водити сліпого? Чи не впадуть обидва в яму? ");
INSERT INTO ukronpu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Учень не вищий за свого вчителя, але, вдосконалившись, кожний стане, як його вчитель. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Чому ж ти дивишся на скалку в оці твого брата, а колоди у своєму оці не помічаєш? ");
INSERT INTO ukronpu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Як можеш сказати братові своєму: „Брате, дозволь вийняти скалку з твого ока“, якщо сам у твоєму оці колоди не бачиш? Лицеміре, витягни спочатку колоду зі свого ока, а тоді побачиш, як вийняти скалку з ока твого брата. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Немає доброго дерева, яке приносило б поганий плід, і немає поганого дерева, яке б приносило добрий плід. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Бо кожне дерево пізнається за його плодом: не збирають смокви з терну й винограду з ожини. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Добра людина з доброї скарбниці свого серця виносить добро, а погана людина з лихого скарбу свого серця виносить зло. Адже чим переповнене серце, те говорять її вуста. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Чому кличете Мене: „Господи! Господи!“, а не робите того, що Я кажу? ");
INSERT INTO ukronpu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Скажу вам, до кого подібний кожний, хто приходить до Мене, чує слова Мої та виконує їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Він подібний до чоловіка, що, будуючи свій дім, вкопав глибоко та поклав основу на камені. Коли прийшла злива, і потік вдарив у той дім, то не зміг його похитнути, бо він був добре збудований. ");
INSERT INTO ukronpu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","А той, хто слухає й не виконує, схожий на чоловіка, який збудував свій дім на землі, без основи. Коли вдарив потік, то він відразу впав, і руйнування того дому було велике». ");
INSERT INTO ukronpu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Коли Ісус закінчив говорити до народу, який слухав Його, то зайшов до Капернаума. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Раб одного сотника, яким він дорожив, тяжко захворів і був при смерті. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Почувши про Ісуса, сотник надіслав до Нього юдейських старійшин просити Його, щоб прийшов зцілити раба. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Прийшовши до Ісуса, вони щиро благали Його, кажучи: «Він достойний, щоб Ти зробив це для нього, ");
INSERT INTO ukronpu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","бо він любить наш народ і побудував нам синагогу». ");
INSERT INTO ukronpu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ісус пішов разом із ними. І коли Він був недалеко від дому, сотник надіслав своїх друзів сказати Йому: «Господи, не турбуйся, бо я не достойний, щоб Ти увійшов під мій дах. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Тому й себе я не вважав гідним, щоби прийти до Тебе, але скажи лише слово, і одужає мій слуга. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Бо і я людина підвладна й маю під своєю владою підлеглих воїнів. Кажу одному: „Іди!“ – і він іде, а іншому: „Прийди!“ – і він приходить, і рабу моєму: „Зроби це!“ – і він робить». ");
INSERT INTO ukronpu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Почувши це, Ісус здивувався, обернувся до народу, що йшов за Ним, та промовив: «Кажу вам: навіть в Ізраїлі Я не знайшов такої великої віри». ");
INSERT INTO ukronpu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Повернувшись додому, посланці знайшли раба здоровим. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Наступного дня Ісус пішов до міста, що зветься Наїн; разом із Ним ішли Його учні та великий натовп. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Коли ж Він наблизився до воріт міста, саме виносили померлого, єдиного сина в матері, котра була вдовою; разом із нею було чимало народу з міста. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Побачивши її, Господь змилосердився над нею й сказав: «Не плач!» ");
INSERT INTO ukronpu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","І, підійшовши, торкнувся труни, а ті, що її несли, зупинилися. Тоді Ісус промовив: «Юначе! Кажу тобі, встань!» ");
INSERT INTO ukronpu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Мертвий піднявся, сів та почав говорити. І Ісус віддав його матері. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Усіх охопив страх, і прославляли Бога, кажучи: «Великий пророк з’явився між нами!» і «Бог прийшов на допомогу своєму народові!» ");
INSERT INTO ukronpu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","І розійшлася ця звістка про Нього по всій Юдеї та по всій тій країні. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Учні Івана сповістили його про все це. І він, прикликавши двох своїх учнів, ");
INSERT INTO ukronpu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","надіслав їх до Господа спитати: ―Ти Той, Хто має прийти, чи нам чекати іншого? ");
INSERT INTO ukronpu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Прийшовши до Нього, чоловіки сказали: ―Іван Хреститель надіслав нас до Тебе спитати: «Ти Той, Хто має прийти, чи нам чекати іншого?» ");
INSERT INTO ukronpu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Саме тоді Він зцілив багатьох від хвороб, недуг та злих духів і багатьом сліпим дарував зір. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","У відповідь Він сказав: ―Ідіть і скажіть Іванові те, що ви бачили та чули: сліпі прозрівають, каліки ходять, прокажені очищаються, глухі чують, мертві оживають, а бідним проповідується Добра Звістка. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","І блаженний той, хто не спокуситься через Мене. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Коли посланці Івана відійшли, Ісус почав говорити народові про Івана: «На що ви ходили подивитися в пустелю? На тростину, розхитану вітром? ");
INSERT INTO ukronpu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","На кого ви виходили дивитись? На людину, одягнену в м’яку одежу? Але ж ті, що розкішно одягаються й живуть у розкоші, знаходяться в царських палацах. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","То на кого ви ходили дивитись? На пророка? Так, Я кажу вам, навіть більше, ніж на пророка! ");
INSERT INTO ukronpu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Він той, про кого написано: „Ось Я посилаю Мого посланця перед обличчям Твоїм, який приготує дорогу перед Тобою“. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Кажу вам: нема більшого за Івана серед народжених жінками, але найменший у Царстві Божому більший за нього». ");
INSERT INTO ukronpu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Весь народ, а також і митники, що слухали Його, визнавши справедливість Бога, хрестились хрещенням Івана. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","А фарисеї та законники відкинули волю Божу про себе й не хрестились у нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","«Із ким Мені порівняти людей з цього покоління, – сказав Ісус, – і на кого вони схожі? ");
INSERT INTO ukronpu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Схожі на дітей, котрі сидять на базарі та кличуть одне одного, кажучи: „Ми грали вам на сопілці, а ви не танцювали. Ми співали вам жалібні пісні, а ви не плакали“. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Прийшов Іван Хреститель, який не їсть хліба й не п’є вина, а ви кажете: „Має демона!“ ");
INSERT INTO ukronpu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Прийшов Син Людський, Який їсть і п’є, а ви кажете: „Ось чоловік – ненажера й п’яниця, приятель митників та грішників“. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Однак мудрість виправдана всіма її дітьми». ");
INSERT INTO ukronpu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Один із фарисеїв запросив Його поїсти з ним. Зайшовши в дім фарисея, Ісус сів за стіл. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","І ось одна жінка з того міста, яка була грішницею, дізналася, що Він сидить за столом у домі фарисея. Вона принесла алебастровий глечик із дуже дорогим миром ");
INSERT INTO ukronpu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","та, припавши до ніг Ісуса ззаду, плачучи, почала слізьми обмивати Його ноги й волоссям своєї голови витирати їх, цілувала Його ноги й мастила миром. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Побачивши це, фарисей, який запросив Ісуса, подумав собі: ―Якби Він був пророком, то знав би, що жінка, яка торкається до Нього, – грішниця. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Тоді Ісус звернувся до нього: ―Симоне, маю тобі щось сказати! Той відповів: ―Говори, Учителю! ");
INSERT INTO ukronpu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","У одного позикодавця було двоє боржників: один був винен п’ятсот динаріїв, а інший – п’ятдесят. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Та оскільки вони не мали, чим віддати, він простив обох. Отже, хто з них буде любити його більше? ");
INSERT INTO ukronpu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Симон відповів: ―Я думаю, що той, якому більше простив. Ісус відповів: ―Правильно ти розсудив. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","І, обернувшись до жінки, сказав Симонові: ―Бачиш цю жінку? Я зайшов у твій дім, а ти не дав Мені води для ніг, вона ж своїми слізьми обмила Мої ноги та волоссям обтерла їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ти не привітав Мене поцілунком, а вона, відколи Я зайшов, не перестає цілувати Мої ноги. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ти не намастив Моєї голови олією, а вона миром намастила Мої ноги. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Тому кажу тобі: прощаються її численні гріхи, бо вона багато полюбила, а кому мало прощається, той мало любить. ");
INSERT INTO ukronpu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Потім Ісус промовив до неї: ―Прощаються гріхи твої! ");
INSERT INTO ukronpu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","А всі, хто сидів із Ним за столом, почали думати про себе: «Хто Він такий, що й гріхи прощає?» ");
INSERT INTO ukronpu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Він же сказав жінці: ―Віра твоя спасла тебе, іди з миром. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Після цього Він проходив через міста та села, проповідуючи Добру Звістку Царства Божого. Разом із Ним були Його дванадцятеро учнів ");
INSERT INTO ukronpu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","і деякі жінки, котрі були зцілені від злих духів та хвороб: Марія, звана Магдалиною, з якої вийшло сім демонів, ");
INSERT INTO ukronpu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Іванна – дружина Хузи, наставника Ірода, Сусанна й багато інших, котрі служили Йому, чим мали. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Коли зібрався великий натовп і люди з кожного міста приходили до Нього, Він розповів цю притчу: ");
INSERT INTO ukronpu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Сіяч вийшов сіяти своє насіння. І коли він сіяв, деякі зерна впали біля дороги та були затоптані, а птахи небесні повидзьобували їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Інші впали на каміння та, зійшовши, висохли, бо не мали вологи. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ще інші впали поміж терни й росли разом із ними, але колючки заглушили їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","А інші впали в добру землю, вони виросли й принесли врожай стократний». Сказавши це, Він вигукнув: «Хто має вуха, щоб слухати, слухайте!» ");
INSERT INTO ukronpu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Учні запитали Ісуса, що означає ця притча. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Він відповів: «Вам дано пізнати таємниці Царства Божого, а іншим говорю притчами, щоб „дивлячись, не бачили і, слухаючи, не розуміли“. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ось що означає ця притча: насіння – це Слово Боже. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Те, що посіяне біля дороги, – це ті, що слухають, але потім приходить диявол і забирає Слово з їхнього серця, щоб не повірили та не спаслися. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Те, що впало на камінь, – це ті, що, почувши, з радістю приймають Слово, але не мають коріння й вірують до певного часу, а коли приходить випробування, то відпадають. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Те, що впало поміж терни, – це ті, що чують, але з часом турботи, багатство та життєві задоволення придушують їх, і плід їхній не дозріває. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Те, що впало в хорошу землю, – це ті, що, почувши Слово, зберігають його в доброму та щирому серці та в терпінні приносять врожай. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ніхто, запаливши світильник, не покриває його посудиною й не ставить під ліжко, але ставить на поставець, щоб усі, що входять, бачили світло. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Бо немає нічого прихованого, що не стало б явним, і нічого таємного, що не стало б відомим і не виявилося б. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Тому будьте уважні, як слухаєте, бо тому, хто має, додасться, і матиме надмірно, а від того, хто не має, і те, що має, забереться». ");
INSERT INTO ukronpu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Прийшли Його мати та брати й не могли підійти до Нього через натовп. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","І сказали Йому: ―Твоя мати й Твої брати стоять надворі та бажають бачити Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Він сказав їм у відповідь: ―Мати та брати Мої – це ті, що слухають Слово Боже й виконують його. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Одного дня Ісус та Його учні увійшли в човен, і Він сказав їм: «Переплиньмо на другий бік озера». І вони вирушили. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Коли вони пливли, Він заснув. Аж раптом на озері здійнялася велика буря. Вода почала заливати їх, і вони були в небезпеці. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Приступивши, учні розбудили Ісуса, кажучи: ―Наставнику, Наставнику, ми гинемо! Він прокинувся, наказав вітрові та хвилям зупинитися, і настала тиша. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Тоді сказав їм: ―Де ваша віра? Вони ж, налякані та здивовані, говорили один до одного: ―Хто Він такий, що наказує, а вітер і вода підкоряються Йому? ");
INSERT INTO ukronpu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","І припливли вони в землю Герасинську, що знаходиться навпроти Галілеї. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Коли Він зійшов на берег, зустрів Його один чоловік із міста, який упродовж багатьох років мав демонів. Багато часу він вже не носив одежі та мешкав не в домі, а у гробницях. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Побачивши Ісуса, він закричав, упав перед Ним та голосно промовив: ―Що Тобі до мене, Ісусе, Сину Бога Всевишнього? Благаю Тебе, не муч мене. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Бо Ісус наказав нечистому духові вийти з цього чоловіка. Багато разів демон хапав його, та, попри те, що зв’язували його ланцюгами та кайданами, оберігаючи його, він все одно розривав окови, і демон гнав його в пустелю. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ісус спитав його: ―Як тебе звати? ―Легіон, – відповів той, бо багато демонів увійшло в нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","І вони благали Ісуса, щоб Він не повелів їм іти в Безодню. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","А було там велике стадо свиней, що паслося на горі. Демони просили Ісуса, щоб дозволив їм увійти в них, і Він дозволив. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Демони, вийшовши з чоловіка, увійшли у свиней. Тоді все стадо кинулося з кручі в озеро та потонуло. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Побачивши, що сталося, свинопаси побігли та сповістили про це в місті та в селах. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Люди вийшли подивитися, що сталося, і коли підійшли до Ісуса, то знайшли чоловіка, з якого вийшли демони, він був одягнений, при здоровому глузді й сидів біля Ісусових ніг. Побачивши це, вони злякалися. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ті, хто бачив, розповідали, як було врятовано біснуватого. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Тоді всі люди з Герасинської околиці просили Ісуса, щоб Він залишив їх, адже були охоплені великим страхом. Він же увійшов у човен і повернувся. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Чоловік, з якого вийшли демони, просив Ісуса взяти його з собою, але Він відпустив його, сказавши: ");
INSERT INTO ukronpu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Повернися до себе додому та розкажи, як багато зробив для тебе Бог». Той пішов і по всьому місту проповідував, як багато зробив для нього Ісус. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Коли Ісус повернувся, Його зустрів великий натовп, бо всі чекали на Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","І ось прийшов чоловік, на ім’я Яір, який був керівником синагоги, і, впавши долілиць до ніг Ісуса, благав Його зайти до його дому, ");
INSERT INTO ukronpu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","бо його єдина донька, яка мала років дванадцять, захворіла й була при смерті. Коли Він пішов, то натовп звідусіль тиснув на Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","І була там одна жінка, яка вже дванадцять років страждала на кровотечу. Вона витратила все, що мала, на лікарів, але ніхто не зміг її зцілити. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Підійшовши ззаду, вона доторкнулася до краю Його одежі, і вмить зупинилася її кровотеча. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ісус запитав: ―Хто доторкнувся до Мене? Коли ж ніхто не зізнався, Петро сказав: ―Наставнику, натовп тісниться навколо Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ісус же відповів: ―Хтось доторкнувся до Мене, бо Я відчув, як сила вийшла від Мене. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Жінка, побачивши, що не зможе втаїтися, тремтячи, підійшла та, впавши перед Ним, зізналася перед усім народом, чому доторкнулася до Нього і як раптом зцілилася. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ісус же сказав їй: «Донько, віра твоя врятувала тебе. Іди з миром». ");
INSERT INTO ukronpu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Коли Він ще говорив, прийшов хтось із дому керівника синагоги та сказав: ―Твоя донька померла, не турбуй Учителя! ");
INSERT INTO ukronpu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ісус же, почувши це, сказав Яіру: ―Не бійся, тільки віруй, і вона буде спасенна! ");
INSERT INTO ukronpu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Прийшовши в дім, Він не дозволив нікому увійти з Ним, окрім Петра, Івана, Якова та батька й матері дитини. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Усі плакали та ридали над нею. Він же сказав їм: «Не плачте, бо вона не померла, а спить». ");
INSERT INTO ukronpu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Але вони почали глузувати з Нього, бо знали, що дівчина померла. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ісус же узяв її за руку й голосно промовив: «Дитино, встань!» ");
INSERT INTO ukronpu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Дух її повернувся до неї, і вмить вона піднялася. Він наказав дати їй їсти. ");
INSERT INTO ukronpu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Батьки дитини дуже здивувалися, але Він наказав нікому не казати про те, що сталося. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Скликавши дванадцятьох, Він дав їм силу та владу виганяти всіх демонів і зцілювати всі хвороби. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","І послав їх проповідувати Царство Боже та зцілювати хворих. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Він промовив до них: «Нічого не беріть у дорогу: ні палиці, ні торбини, ні хліба, ні грошей, ні двох сорочок не майте. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Коли ж увійдете в якийсь дім, там залишайтесь і звідти йдіть далі. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Якщо десь вас не приймуть, то, виходячи з того міста, обтрусіть пил зі своїх ніг на свідчення проти них!» ");
INSERT INTO ukronpu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Вони вийшли та ходили по селах, звіщаючи Добру Звістку й зцілюючи всюди. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Тетрарх Ірод почув про все, що сталося, і занепокоївся, бо дехто казав, що це Іван воскрес із мертвих; ");
INSERT INTO ukronpu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","інші казали, що це з’явився Ілля, а ще інші – що це один зі стародавніх пророків воскрес. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Тоді Ірод сказав: «Івана я стратив, тоді хто Цей, про Кого я таке чую?» І намагався зустрітися з Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Повернувшись, апостоли розповіли Ісусові про все, що зробили. Він узяв їх та відійшов у безлюдне місце біля міста, що зветься Віфсаїда. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Але люди, дізнавшись про це, пішли за Ним. Зустрівши їх, Він почав говорити про Царство Боже й зцілював тих, хто потребував зцілення. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Коли ж день схилявся до вечора, підійшли до Нього дванадцятеро й сказали: ―Відпусти людей, щоби пішли в навколишні села та хутори відпочити та знайти чогось їсти, бо ми тут у безлюдному місці. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Але Він сказав їм: ―Ви дайте їм їсти! Вони відповіли: ―Ми не маємо нічого, крім п’яти хлібів та двох рибин. Хіба що підемо й купимо їжу для всіх цих людей. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","А було там близько п’яти тисяч чоловіків. Ісус промовив до Своїх учнів: ―Розсадіть їх групами приблизно по п’ятдесят. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Вони так і зробили, і розсадили всіх людей. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Він же, узявши п’ять хлібів та дві рибини, подивився на небо, благословив їх і, розломивши, дав учням, щоб розділили між людьми. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Усі їли та наситилися, і назбирали дванадцять кошиків залишків. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Одного разу, коли Ісус молився на самоті й разом із Ним були лише учні, Він запитав їх: ―За кого вважають Мене люди? ");
INSERT INTO ukronpu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Вони відповіли: ―Одні – за Івана Хрестителя, інші – за Іллю, ще інші – за одного зі стародавніх пророків, що воскрес. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Він же запитав: ―А ви за кого Мене вважаєте? Петро відповів: ―Ти Христос Божий! ");
INSERT INTO ukronpu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Тоді Він наказав їм нікому не розповідати про це. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Далі додав: «Синові Людському належить багато страждати, бути відкинутим старійшинами, первосвященниками та книжниками, бути вбитим, але третього дня воскресне». ");
INSERT INTO ukronpu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Потім промовив до всіх: «Якщо хтось хоче йти за Мною, нехай зречеться самого себе, візьме свій хрест та щодня слідує за Мною. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Бо хто хоче спасти своє життя, той загубить його, а хто втратить життя своє заради Мене, той спасе його. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Яка користь людині, якщо здобуде весь світ, а саму себе занапастить або згубить? ");
INSERT INTO ukronpu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Хто посоромиться Мене та Моїх слів, того й Син Людський посоромиться, коли прийде в славі Своїй, і Отця, і святих ангелів. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Істинно кажу вам: деякі з присутніх тут не зазнають смерті, доки не побачать Царства Божого». ");
INSERT INTO ukronpu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","А приблизно через вісім днів після цих слів, Ісус узяв із Собою Петра, Івана та Якова й піднявся на гору, щоб молитися. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Під час молитви вигляд Його обличчя змінився, і одежа стала білою та блискучою. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","І ось двоє чоловіків розмовляли з Ним – це були Мойсей та Ілля. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Вони з’явились у славі та розмовляли з Ним про Його відхід, який Він мав завершити в Єрусалимі. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Петро й ті, що були з Ним, заснули, але, прокинувшись, побачили Його славу та цих двох чоловіків, які стояли з Ним. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Коли вони відійшли від Нього, Петро сказав Ісусові: «Наставнику, добре нам тут бути! Зробімо три намети: один для Тебе, один для Мойсея та один для Іллі». Він не знав, що говорить. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Коли він це казав, з’явилася хмара, яка накрила їх. Вони ж злякалися, коли увійшли в хмару. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","З хмари промовив голос: «Це Син Мій обраний, Його слухайте!» ");
INSERT INTO ukronpu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Коли ж пролунав голос, Ісус залишився Сам. Вони мовчали й нікому в ті дні не казали про те, що бачили. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Наступного дня, після того, як вони зійшли з гори, великий натовп зустрів Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","І ось один чоловік із натовпу вигукнув: ―Учителю, благаю, зглянься над моїм сином, бо він у мене єдиний. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Нечистий дух хапає його, і він зненацька кричить, і катує його дух аж до піни. Насилу відходить, залишаючи його безсилим. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Я просив Твоїх учнів вигнати духа, але вони не змогли. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ісус у відповідь сказав: ―О роде невірний та розбещений, доки буду з вами? Доки терпітиму вас? Приведи сюди твого сина! ");
INSERT INTO ukronpu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Коли хлопчик наближався, демон у припадку кинув його на землю, але Ісус наказав нечистому духові відійти, зцілив дитину та віддав її батькові. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Усі були вражені Божою величчю. Коли всі дивувалися всьому, що робив Ісус, Він промовив до своїх учнів: ");
INSERT INTO ukronpu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Вкладіть ці слова у ваші вуха: Син Людський буде виданий у руки людські». ");
INSERT INTO ukronpu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Однак учні не зрозуміли цих слів: вони були приховані від них, щоб не зрозуміли їх, а спитати Його про ці слова боялися. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Потім учні почали роздумувати між собою, хто з них найбільший. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Але Ісус, знаючи думки їхніх сердець, узяв дитину, поставив її біля Себе ");
INSERT INTO ukronpu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","та промовив до них: ―Той, хто прийме цю дитину в ім’я Моє, той Мене приймає, а хто Мене приймає, приймає Того, Хто надіслав Мене. Бо хто найменший поміж вас, той найбільший. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Іван відповів: ―Наставнику, ми бачили когось, хто Твоїм ім’ям виганяв демонів, та ми заборонили йому, бо він не ходить із нами. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ісус відповів: ―Не забороняйте, бо хто не проти вас, той за вас. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Коли наближався час Йому бути взятим на небо, Він рішуче пішов до Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","І надіслав перед Собою вісників. Вони зайшли до одного самарянського села, щоб приготувати все для Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Але мешканці Його не прийняли, бо Він ішов до Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Побачивши це, учні Його, Яків та Іван, сказали: ―Господи, хочеш, ми накажемо, щоб зійшов вогонь із неба та спалив їх, як це зробив Ілля? ");
INSERT INTO ukronpu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ісус, обернувшись до них, заборонив їм та сказав: ―Не знаєте, якого ви духа, ");
INSERT INTO ukronpu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","бо Син Людський прийшов не губити людські душі, а спасати їх! І пішли до іншого села. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Коли вони йшли дорогою, хтось сказав Ісусові: ―Я піду за Тобою, куди б Ти не пішов! ");
INSERT INTO ukronpu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ісус відповів йому: ―Лисиці мають нори, птахи небесні – гнізда, а Син Людський не має, де голову прихилити. ");
INSERT INTO ukronpu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","А іншому сказав: ―Іди за Мною! Але той відповів: ―Господи, дозволь мені спочатку піти поховати мого батька! ");
INSERT INTO ukronpu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Тоді Ісус сказав: ―Залиши мертвим ховати своїх мерців, а ти йди звіщати Царство Боже! ");
INSERT INTO ukronpu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Інший сказав: ―Господи, я піду за Тобою, але дозволь мені спочатку попрощатися з моїми домашніми! ");
INSERT INTO ukronpu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ісус сказав йому: ―Ніхто з тих, хто поклав руку на плуг та озирається назад, не придатний для Царства Божого! ");
INSERT INTO ukronpu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Після того Господь призначив інших сімдесятьохучнів і надіслав їх по двоє перед Собою в усі міста та місцевості, куди Він мав іти. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","І сказав їм: «Жнива насправді великі, а робітників мало, тож просіть Господа жнив, щоб послав робітників на жнива Свої. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ідіть! Ось Я посилаю вас, як ягнят між вовків. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Не беріть ні гаманця, ні торбини, ні взуття й нікого в дорозі не вітайте. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Коли ж увійдете в якийсь дім, то спочатку скажіть: „Мир цьому дому!“ ");
INSERT INTO ukronpu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","І якщо там є син миру, то спочине на ньому ваш мир, а коли ні, то повернеться до вас. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Залишайтеся в тому ж домі, їжте та пийте те, що дадуть вам, бо робітник достойний своєї платні. Не переходьте з дому в дім. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","А коли зайдете в якесь місто та приймуть вас, то їжте все, що покладуть перед вами. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Зціляйте в ньому хворих і кажіть їм: „Наблизилось до вас Царство Боже!“ ");
INSERT INTO ukronpu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","А коли зайдете в якесь місто і не приймуть вас, то, виходячи на вулиці його, кажіть: ");
INSERT INTO ukronpu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","„Навіть пил із вашого міста, який прилип до наших ніг, ми обтрушуємо на свідчення проти вас, але знайте, що наблизилось Царство Боже!“ ");
INSERT INTO ukronpu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Кажу вам: легше буде Содомові в той день суду, ніж тому місту. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Горе тобі, Хоразине! Горе тобі, Віфсаїдо! Бо якби в Тирі та Сидоні сталися ті чудеса, які були у вас, то вони давно би покаялися, сидячи в мішковині та попелі. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Проте Тиру та Сидону легше буде на суді, ніж вам. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","І ти, Капернауме, чи будеш піднесений до неба? Ні, ти до пекла зійдеш! ");
INSERT INTO ukronpu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Той, хто слухає вас, той Мене слухає, і хто відмовляється від вас, від Мене відмовляється. Хто ж відмовляється від Мене, той відмовляється від Того, Хто надіслав Мене». ");
INSERT INTO ukronpu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Сімдесят учнів повернулися й радісно сказали: ―Господи, навіть демони підкоряються нам в ім’я Твоє. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","А Він сказав їм: ―Я бачив сатану, котрий падав із неба, наче блискавка. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ось даю вам владу наступати на змій і скорпіонів, і на всяку силу ворожу, і ніщо вам не зашкодить. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Однак не радійте, що духи вам підкоряються, а радійте тому, що імена ваші записані на небесах. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","У той час Ісус зрадів Святим Духом та промовив: «Славлю Тебе, Отче, Господи неба і землі, за те, що Ти приховав це від мудрих та розумних і відкрив дітям. Так, Отче, бо такою була Твоя добра воля. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Усе Мені було доручено Моїм Отцем. Ніхто не знає, Хто є Син, окрім Отця, і Хто є Отець, окрім Сина й того, кому Син хоче відкрити». ");
INSERT INTO ukronpu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","І, повернувшись до учнів, промовив тільки до них: ―Блаженні очі, які бачать те, що ви бачите. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Бо кажу вам: багато пророків та царів бажали побачити те, що ви бачите, і не побачили, та почути те, що ви чуєте, і не почули. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","І ось один учитель Закону піднявся та, спокушаючи Його, сказав: ―Учителю, що мені робити, щоб успадкувати життя вічне? ");
INSERT INTO ukronpu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ісус відповів йому: ―Що в Законі написано? Як читаєш? ");
INSERT INTO ukronpu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Він відповів: ―«Люби Господа Бога свого всім серцем своїм, і всією своєю душею, і всією силою своєю, і всім розумом своїм» і «ближнього свого – як самого себе». ");
INSERT INTO ukronpu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ісус же сказав: ―Правильно ти відповів, роби так і будеш жити! ");
INSERT INTO ukronpu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Але той, бажаючи виправдати себе, сказав Ісусові: ―А хто мій ближній? ");
INSERT INTO ukronpu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ісус відповів: ―Один чоловік ішов з Єрусалима в Єрихон та потрапив до рук розбійників, котрі роздягли його, побили та пішли далі, залишивши його напівмертвим. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Випадково тією ж дорогою проходив священник і, побачивши його, пройшов повз нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Також і левіт, прийшовши на те місце, подивився й пішов далі. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Але один самарянин, який був у подорожі, підійшов і, побачивши його, зглянувся над ним. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Він підійшов, перев’язав йому рани, намастивши їх олією та вином, поклав його на свою худобину та привіз до заїжджого двору, де доглядав за ним. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Наступного дня, від’їжджаючи, дав два динарії господареві та сказав: «Подбай про нього, а якщо витратиш на нього більше, я поверну тобі, коли вертатимусь». ");
INSERT INTO ukronpu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Хто з цих трьох, на твою думку, був ближнім того, хто потрапив до рук розбійників? ");
INSERT INTO ukronpu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Він відповів: ―Той, хто зглянувся над ним. Ісус сказав: ―Іди та роби так само. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Коли вони подорожували далі, то зайшли до одного села, де жінка, на ім’я Марта, прийняла Його у свій дім. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","У неї була сестра, на ім’я Марія, яка сіла біля ніг Господа та слухала Його слова. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Марта була зайнята багатьма приготуваннями й, підійшовши, сказала: ―Господи, чи Тобі байдуже, що моя сестра залишила мене саму служити? Скажи їй, щоб допомогла мені. ");
INSERT INTO ukronpu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Господь відповів їй: ―Марто, Марто, ти турбуєшся та клопочешся багатьма речами, ");
INSERT INTO ukronpu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","але потрібне одне. Марія обрала кращу частку, яка не відбереться від неї. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Одного разу Ісус молився, і, коли Він закінчив, один з учнів промовив до Нього: ―Господи, навчи нас молитися, як і Іван навчив своїх учнів! ");
INSERT INTO ukronpu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Він промовив: ―Коли молитесь, то кажіть: «Отче наш, Що на небесах, нехай святиться ім’я Твоє! Нехай прийде Царство Твоє! Нехай буде воля Твоя, як на небі, так і на землі! ");
INSERT INTO ukronpu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Хліб наш щоденний дай нам кожного дня. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","І прости нам гріхи наші, бо і ми прощаємо всім боржникам нашим. І не введи нас у спокусу, але визволи нас від лукавого». ");
INSERT INTO ukronpu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","І сказав їм: ―Хто з вас, маючи друга, прийде до нього опівночі та скаже йому: «Друже, позич мені три хліби, ");
INSERT INTO ukronpu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","бо мій приятель прийшов до мене з дороги, і я не маю, що йому дати». ");
INSERT INTO ukronpu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","А той зсередини відповів би йому: «Не турбуй мене! Двері вже зачинені, і діти мої зі мною в ліжку. Не можу я піднятися й дати тобі». ");
INSERT INTO ukronpu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Кажу вам: якщо він не встане та не дасть йому заради дружби, то все одно через наполегливість його підведеться й дасть усе, чого той потребує. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Тому Я кажу вам: просіть – і буде дано вам; шукайте – і знайдете; стукайте – і відчинять вам! ");
INSERT INTO ukronpu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Бо кожен, хто просить, отримує, і хто шукає, знаходить, і тому, хто стукає, відчинять. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Котрий з вас, батьків, коли син просить хліба, замість хліба подасть йому камінь, і коли просить риби, замість риби подасть йому гадюку? ");
INSERT INTO ukronpu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Або чи дасть йому скорпіона, коли той просить яйце? ");
INSERT INTO ukronpu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Отже, якщо ви, будучи злими, вмієте давати добрі дари вашим дітям, то наскільки більше ваш Отець Небесний дасть Духа Святого тим, хто просить у Нього! ");
INSERT INTO ukronpu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Одного разу Ісус вигнав демона, який був німий. І коли демон вийшов, німий чоловік заговорив; і весь натовп дивувався цьому. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Та деякі з них говорили: ―Силою Вельзевула, володаря демонів, Він виганяє демонів. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Інші ж, випробовуючи Його, вимагали знамення з неба. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Але Він, знаючи їхні думки, відповів: ―Кожне царство, розділене в собі, буде спустошене, і дім, розділений в собі, впаде. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Якщо ж сатана розділився в собі самому, як встоїть його царство?Питаю це, бо кажете, що Вельзевулом Я виганяю демонів. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Якщо ж Я виганяю демонів Вельзевулом, то ким виганяють ваші сини? Тому вони будуть вашими суддями. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Але якщо Я пальцем Божим виганяю демонів, то прийшло до вас Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Коли сильний, озброївшись, стереже свій дім, тоді майно його в безпеці. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Коли ж нападає сильніший за нього й перемагає його, то забирає все його озброєння, на яке він покладався, і потім ділить здобич. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Хто не зі Мною, той проти Мене; і хто не збирає зі Мною, той розкидає. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Коли нечистий дух виходить із людини, то йде в місця безводні шукати відпочинку й, не знаходячи, каже: «Повернусь я у дім свій, звідки вийшов». ");
INSERT INTO ukronpu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","І, повернувшись, знаходить його заметеним та прибраним. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Тоді він іде й бере інших сімох духів, гірших за себе, і входять та живуть там. І для людини останнє стає гіршим за попереднє. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Коли Ісус це казав, одна жінка з натовпу голосно промовила: ―Блаженна мати, яка носила та годувала Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Він відповів: ―Справді блаженні ті, що слухають Слово Боже та виконують його. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Коли зібралося багато народу, Він почав говорити: ―Цей рід – рід лукавий! Він шукає знамення, та не дасться йому знамення, хіба що тільки знамення Йони. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Бо як Йона став для ніневійців знаменням, так буде й Син Людський для цього роду. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Цариця Півдня встане на суд із людьми цього роду й засудить їх, бо вона прийшла з далекого краю землі послухати Соломонову мудрість, а ось тут Хтось більший за Соломона. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Люди Ніневії встануть на суд із цим родом і засудять його, бо вони покаялись через проповідь Йони, а ось тут Хтось більший за Йону. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ніхто, запаливши світильник, не ставить його у потайне місце або під посудину, але ставить на поставець, щоб усі, що входять, бачили світло. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Світлом для тіла є око. Якщо твоє око буде здорове, то й все твоє тіло буде наповнене світлом, коли ж воно недуже, то й тіло твоє в темряві. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Отже, пильнуй, щоб світло, яке в тобі, не стало темрявою. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Якщо ж усе твоє тіло наповнене світлом і немає жодної темної частини, то все буде світле так, ніби світильник освітлює тебе сяйвом. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Коли Він закінчив говорити, один фарисей запросив Його до себе пообідати. Ісус зайшов та сів за стіл. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Фарисей же здивувався, побачивши, що перед обідом Він перш не обмився. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Тоді Господь промовив до нього: ―Ось ви, фарисеї, очищуєте чашу та посуд ззовні, а всередині ви повні здирництва та лукавства. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Нерозумні! Чи Той, Хто створив зовнішнє, не створив і внутрішнє? ");
INSERT INTO ukronpu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Тож дайте милостиню з того, що всередині, ось тоді все буде чисте для вас. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Але горе вам, фарисеї, що даєте десятину з м’яти, рути й з усякого зілля, але обминаєте справедливість та любов Божу. І це належить робити, і тим не нехтувати. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Горе вам, фарисеї, що любите почесні місця в синагогах та привітання на ринках. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Горе вам, бо ви – як невидимі гроби, поверх яких люди ходять і не знають цього. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Один з учителів Закону відповів Ісусові: ―Учителю, кажучи це, Ти й нас ображаєш! ");
INSERT INTO ukronpu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Але Він відповів: ―Горе й вам, учителям Закону, бо ви накладаєте на людей тягар, який важко нести, самі ж навіть пальцем не доторкнетеся до нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Горе вам, бо ви будуєте гробниці пророкам, яких убили ваші батьки. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Цим ви свідчите, що схвалюєте вчинки ваших батьків. Вони їх вбивали, а ви будуєте їм гробниці. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Тому Бог у своїй мудрості сказав: «Надішлю до них пророків та апостолів, і декого з них уб’ють, а декого будуть переслідувати». ");
INSERT INTO ukronpu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","І тому цей рід буде відповідати за пролиту кров усіх пророків, які були вбиті від початку всесвіту, ");
INSERT INTO ukronpu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","від крові Авеля до крові Захарії, убитого між Храмом та жертовником. Кажу вам: цей рід відповість за все. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Горе вам, учителі Закону, бо ви взяли ключі пізнання: самі не ввійшли й тим, хто бажає ввійти, заборонили. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Коли Ісус вийшов звідти, фарисеї та книжники почали критикувати Його та спокушати відносно багатьох речей. ");
INSERT INTO ukronpu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Вони спостерігали за Ним, аби упіймати Його на слові. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Тим часом зібралися тисячі людей, так що тиснули одне одного. Ісус почав говорити в першу чергу до учнів: ―Стережіться закваски фарисейської, якою є лицемірство. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Немає нічого прихованого, що не відкрилося б, і нічого таємного, що не стало б відомим. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Тому все, що ви казали в темряві, буде почуте при світлі, і все, що говорили на вухо в окремій кімнаті, буде проповідуватися з дахів. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Кажу вам, Моїм друзям: не бійтеся тих, хто, вбиваючи тіло, потім більш нічого заподіяти не може. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Я вкажу вам, Кого треба боятися: бійтеся Того, Хто, вбивши, має силу кинути до Геєни. Так, кажу вам: Цього треба боятися. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Чи не продаються п’ять горобців за два асарії? І все ж, жоден із них не забутий Богом. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","А на вашій голові навіть волосся пораховане. Не бійтеся: ви набагато цінніші за горобців. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Кажу вам: кожного, хто визнає Мене перед людьми, і Син Людський визнає перед ангелами Божими. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Але того, хто зречеться Мене перед людьми, зрікусь і Я перед ангелами Божими. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Кожному, хто скаже слово проти Сина Людського, проститься, але тому, хто богохульствує проти Святого Духа, не проститься. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Коли поведуть вас на суд у синагоги, до керівників та до влад, не турбуйтеся про те, як вам відповідати й що говорити, ");
INSERT INTO ukronpu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","бо в той час Дух Святий навчить, що треба говорити. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Хтось із натовпу сказав Йому: ―Учителю, скажи моєму братові, щоб розділив зі мною спадщину. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Він відповів: ―Чоловіче, хто поклав Мене суддею або посередником між вами? ");
INSERT INTO ukronpu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Далі промовив до них: ―Дивіться уважно та стережіться всякої жадібності, бо життя людини не залежить від багатства її маєтку. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ісус розповів їм притчу: ―В одного заможного чоловіка гарно вродила земля. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","І він почав міркувати, кажучи сам до себе: «Що мені робити? Немає куди зібрати мій врожай». ");
INSERT INTO ukronpu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","І сказав: «Ось що я зроблю: зруйную старі амбари та збудую більші, і в мене буде достатньо місця, щоби зібрати все зерно та все моє добро. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Тоді я скажу моїй душі: „Тепер у тебе багато добра на багато років! Відпочивай, їж, пий та веселися“». ");
INSERT INTO ukronpu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Але Бог відповів: «Безумцю! Цієї ж ночі заберуть у тебе душу твою. Кому дістанеться те, що ти приготував?» ");
INSERT INTO ukronpu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Так станеться з кожним, хто збирає для себе й не багатіє в Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Потім Він промовив до своїх учнів: ―Тому Я кажу вам: не турбуйтеся про життя – що будете їсти, ні про тіло – що будете вдягати. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Бо життя більше за їжу, а тіло – за одяг. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Погляньте на воронів: вони не сіють і не жнуть, не мають скарбниць та амбарів, і все ж Бог їх годує. Наскільки ж ви цінніші за цих птахів! ");
INSERT INTO ukronpu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","І хто з вас, турбуючись, може додати до свого зросту хоч лікоть? ");
INSERT INTO ukronpu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Якщо ви навіть і найменшого зробити не можете, чому турбуєтесь про інше? ");
INSERT INTO ukronpu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Подивіться, як ростуть лілії: вони не працюють і не прядуть. Та Я кажу вам: навіть Соломон у всій своїй величі не одягався так, як будь-яка з них. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Якщо ж Бог так одягає траву на полі, котра сьогодні є, а завтра буде кинута у вогонь, то наскільки краще Він одягне вас, маловіри? ");
INSERT INTO ukronpu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Не шукайте, що вам їсти та пити, і не турбуйтеся про це. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Бо все це язичники цього світу шукають, але ваш Отець знає, що потребуєте. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Краще шукайте Царства Його, а все це додасться вам. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Не бійся, мале стадо, бо Отець ваш із радістю дає вам Царство. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Продавайте майно ваше й давайте милостиню. Робіть собі гаманці, котрі не зношуються, – невичерпний скарб на небі, куди злодій не закрадається і де міль не точить. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Бо де скарб ваш, там буде й ваше серце. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Будьте завжди готові – одяг підперезаний та світильник запалений. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Будьте подібні до людей, що чекають на повернення свого господаря з весілля, щоб, коли він прийде й постукає, негайно відчинити йому. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Блаженні ті раби, господар яких, прийшовши, знайде, що вони пильнують. Істинно кажу вам: тоді він сам, підперезавшись, посадить їх за стіл та, підійшовши, буде служити їм. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","І якщо він прийде о другій або о третій сторожі, блаженні ті, кого він знайде так само. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Тож знайте, що якби господар дому знав, о якій сторожі приходить злодій, він не дозволив би вдертися до свого дому. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","І ви будьте готові, бо Син Людський прийде тієї години, про яку й не думаєте. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Тоді Петро сказав: ―Господи, Ти говориш цю притчу нам чи всім? ");
INSERT INTO ukronpu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Господь відповів: ―Хто вірний та розумний управитель, якого господар поставив над іншими своїми слугами, щоб давав їм їжу вчасно? ");
INSERT INTO ukronpu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Блаженний той раб, якого господар знайде, що він так робить. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Істинно кажу вам: він поставить його над усім своїм майном. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Але якщо той раб скаже у своєму серці: «Мій господар запізнюється!» – і почне бити слуг та служниць, їсти, пити та напиватись, ");
INSERT INTO ukronpu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","господар того раба прийде того дня, коли він не сподівається, і о тій годині, якої не знає. Він розітне його та призначить йому місце разом із невірними. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Той раб, котрий знав волю господаря свого й не підготувався, ані не зробив того, чого господар бажав, буде сильно побитий. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","А той, хто, не знаючи, зробив щось достойне покарання, буде побитий менше. Від усякого, кому багато дано, багато вимагатимуть, і кому багато повірено, з того більше й спитають. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Я прийшов кинути вогонь на землю, і як Я прагну, щоб він вже розгорівся! ");
INSERT INTO ukronpu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Я маю хреститися хрещенням, і як Мені важко, поки це не здійсниться. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ви вважаєте, що Я прийшов принести мир на землю? Ні, кажу вам, а розділення! ");
INSERT INTO ukronpu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Бо віднині п’ятеро в одному домі розділяться: троє проти двох, і двоє проти трьох. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Будуть розділені: батько проти сина й син проти батька; мати проти доньки й донька проти матері; свекруха проти невістки й невістка проти свекрухи. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Він промовив до народу: ―Коли ви бачите хмару, яка здіймається на заході, то відразу кажете: «Буде дощ», і так стається. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","А коли південний вітер віє, кажете: «Буде спека», і так стається. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Лицеміри! Вигляд землі та неба вмієте розпізнавати, так чому ж цей час не розпізнаєте? ");
INSERT INTO ukronpu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Чому ви самі не розсудите, що є справедливе? ");
INSERT INTO ukronpu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Коли ти йдеш зі своїм супротивником до правителя, то доклади зусиль для того, щоб ще в дорозі примиритися з ним, аби він не повів тебе до суду, а суддя не віддав тебе до рук стражника, і стражник не кинув тебе до в’язниці. ");
INSERT INTO ukronpu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Кажу тобі: не вийдеш звідти, поки не заплатиш усе до останньої лепти. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","У той час підійшли деякі та розказали Ісусові про галілеян, кров яких Пилат змішав з їхніми жертвами. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ісус відповів: «Чи ви думаєте, що ці галілеяни так постраждали, тому що були грішніші за інших галілеян? ");
INSERT INTO ukronpu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Кажу вам, що ні! Але якщо не покаєтесь, усі загинете так само. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Або думаєте, що ті вісімнадцять, на яких впала вежа в Силоамі та вбила їх, були більш грішні за всіх, що живуть в Єрусалимі? ");
INSERT INTO ukronpu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Кажу вам, що ні! Але якщо не покаєтесь, усі так само загинете». ");
INSERT INTO ukronpu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Тоді розповів їм таку притчу: «Один чоловік мав у своєму винограднику смоковницю й прийшов до неї шукати плоду, та не знайшов. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Тоді він промовив до садівника: „Ось я вже три роки приходжу шукати плоду на цій смоковниці й не знаходжу. Зрубай її! Навіщо вона займає землю?“ ");
INSERT INTO ukronpu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Але садівник відповів: „Господарю, залиши її ще на цей рік. Я обкопаю її довкола та обкладу її добривом. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Може, принесе плід, якщо ж ні, тоді її зрубаєш“». ");
INSERT INTO ukronpu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ісус навчав у синагозі в Суботу. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","І ось там була жінка, яка вісімнадцять років мала духа хвороби та не могла випрямитись. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Коли Ісус її побачив, то покликав і сказав: ―Жінко, ти звільнена від своєї хвороби. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Він поклав на неї руки, і вона відразу випрямилась та почала прославляти Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Тоді керівник синагоги, обурившись через те, що Ісус зцілив у Суботу, промовив до народу: ―Є шість днів, у які вам належить працювати, ось тоді й приходьте для зцілення, а не в Суботу! ");
INSERT INTO ukronpu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Але Господь відповів йому: ―Лицеміри! Чи кожен із вас не відв’язує вола чи осла свого від стійла в Суботу й не веде напоїти? ");
INSERT INTO ukronpu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Чи цю жінку, доньку Авраамову, яку сатана зв’язав ось уже вісімнадцять років, не належить визволити з цих пут у день Суботній? ");
INSERT INTO ukronpu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Коли Він це промовив, усім Його супротивникам стало соромно, а весь народ радів усім славним вчинкам, які Він робив. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Далі Ісус промовив: «До чого подібне Царство Боже? До чого б Мені його прирівняти? ");
INSERT INTO ukronpu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Воно подібне до гірчичного зерна, яке чоловік узяв та кинув у свій город. Зерно виросло та стало деревом, і птахи небесні зробили гнізда на його гілках». ");
INSERT INTO ukronpu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","І знову промовив: «До чого подібне Царство Боже? ");
INSERT INTO ukronpu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Воно подібне до закваски, яку жінка взяла та поклала до трьох мір борошна,доки все вкисло». ");
INSERT INTO ukronpu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ісус проходив через міста та села, навчаючи людей і прямуючи до Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Хтось Його спитав: ―Господи, чи мало буде тих, що спасуться? Ісус відповів: ");
INSERT INTO ukronpu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Намагайтесь увійти через вузькі ворота, адже багато тих, хто намагатиметься ввійти, але не зможуть. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Коли господар будинку підійметься та зачинить двері, ви, стоячи ззовні, будете стукати в двері та казати: «Господи, відчини нам!» Але Він у відповідь скаже: «Я не знаю вас, звідки ви!» ");
INSERT INTO ukronpu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Тоді ви скажете: «Ми їли та пили з Тобою, Ти навчав на наших вулицях». ");
INSERT INTO ukronpu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Але Він відповість: «Не знаю вас, звідки ви. Відійдіть від Мене всі, хто чинить зло». ");
INSERT INTO ukronpu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Там буде плач та скрегіт зубів, коли побачите Авраама, Ісаака, Якова й усіх пророків у Царстві Божому, а ви будете вигнані геть. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Прийдуть люди зі сходу та заходу, з півночі й півдня і сядуть за стіл у Царстві Божому. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","І ось останні будуть першими, а перші – останніми. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Тоді підійшли до Нього фарисеї та сказали: ―Тікай, залиши це місто, бо Ірод хоче вбити Тебе. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Він відповів: ―Ідіть та скажіть тій лисиці: «Ось Я виганяю демонів і зціляю сьогодні та завтра, а третього дня закінчу. ");
INSERT INTO ukronpu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Мені треба сьогодні, завтра та післязавтра продовжити Мій шлях, бо неможливо, щоб пророк загинув поза Єрусалимом». ");
INSERT INTO ukronpu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","О, Єрусалиме, Єрусалиме, що вбиваєш пророків і закидуєш камінням посланих до тебе! Скільки разів Я бажав зібрати твоїх дітей, як квочка збирає своїх курчат під крила, але ви не захотіли! ");
INSERT INTO ukronpu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ось ваш дім залишається порожнім. Кажу ж вам: не побачите Мене, доки не скажете: «Благословенний Той, Хто йде в ім’я Господа!» ");
INSERT INTO ukronpu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Одного разу в Суботу Він прийшов пообідати в дім одного з фарисейських старшин. Вони уважно слідкували за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","І ось перед Ним був чоловік, який хворів на водянку. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ісус запитав учителів Закону та фарисеїв: ―Чи дозволено зцілювати в Суботу? ");
INSERT INTO ukronpu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Але вони мовчали. Тоді Ісус, доторкнувшись до чоловіка, зцілив його та відпустив. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","До них же промовив: ―Якщо в когось із вас син або віл впаде в колодязь, хіба ви не витягнете його навіть у день Суботній? ");
INSERT INTO ukronpu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Вони не змогли Йому нічого на це відповісти. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Помітивши, як запрошені обирають собі перші місця, Ісус розповів їм притчу: ");
INSERT INTO ukronpu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Коли хтось запросить тебе на весілля, не сідай на почесне місце, щоб не сталося так, що серед запрошених буде хтось поважніший за тебе. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Тоді прийде той, хто запросив тебе, та скаже: „Поступися місцем іншому“. І тоді доведеться тобі із соромом зайняти останнє місце. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Натомість коли будеш запрошений, прийди та сідай на останнє місце, щоб той, хто запросив тебе, підійшовши, сказав: „Друже, пересядь на краще місце!“ Тоді буде тобі честь перед усіма запрошеними. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Бо кожний, хто себе підносить, буде принижений, а хто себе принижує, буде піднесений». ");
INSERT INTO ukronpu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Потім промовив до того, хто запросив Його: «Коли ти влаштовуєш обід або вечерю, не запрошуй своїх друзів, ні своїх братів, ні своїх родичів, ані багатих сусідів, щоби й вони не запросили тебе, і ти не одержав взаємної відплати. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Але коли влаштовуєш вечерю, запрошуй бідних, покалічених, кульгавих та сліпих. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","І блаженний будеш, бо вони не мають, чим відплатити тобі, а твоя винагорода буде при воскресінні праведних». ");
INSERT INTO ukronpu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Почувши це, один із тих, що обідав разом із Ним, промовив: ―Блаженний той, хто буде їсти хліб у Царстві Божому. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ісус у відповідь сказав: ―Один чоловік приготував велику вечерю й запросив багатьох. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Коли прийшов час, він надіслав свого раба сказати запрошеним: «Приходьте, бо все вже готове». ");
INSERT INTO ukronpu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Але всі, один за одним, почали відмовлятися. Перший сказав: «Я придбав поле, і мені треба піти й оглянути його. Прошу тебе, вибач мені!» ");
INSERT INTO ukronpu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Другий сказав: «Я придбав п’ять пар волів та йду випробувати їх. Прошу тебе, вибач мені!» ");
INSERT INTO ukronpu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Третій сказав: «Я щойно одружився й тому не можу прийти!» ");
INSERT INTO ukronpu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Раб повернувся й про все доповів господареві. Тоді розлютився господар і сказав своєму рабу: «Іди швидко на вулиці й провулки міста та приведи сюди бідних, покалічених, сліпих та кульгавих». ");
INSERT INTO ukronpu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","І відповів раб: «Господарю, зроблено, як ти велів, і ще є місця». ");
INSERT INTO ukronpu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Тоді господар сказав рабу: «Вийди на дороги й стежки та переконай усіх, кого зустрінеш, прийти, щоб дім мій наповнився. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Кажу вам: ніхто з тих, кого було запрошено, не їстиме на моїй вечері». ");
INSERT INTO ukronpu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Разом з Ісусом ішло багато людей, та Він, обернувшись, промовив до них: ");
INSERT INTO ukronpu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Якщо хтось приходить до Мене й не зненавидить свого батька та матері, дружини, дітей, братів та сестер, і навіть свого життя, не може бути Моїм учнем. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Хто не несе хреста свого й не йде слідом за Мною, той не може бути Моїм учнем. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Бо хто з вас, бажаючи збудувати вежу, спочатку не сяде та не порахує всіх витрат, чи має він чим закінчити. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Щоб, коли покладе основу та не зможе закінчити, усі, хто побачить, не почали сміятися з нього, ");
INSERT INTO ukronpu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","кажучи: „Цей чоловік почав будувати, але не зміг закінчити!“ ");
INSERT INTO ukronpu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Або який цар, збираючись на війну проти іншого царя, не сяде та не роздумає, чи зможе з десятьма тисячами встояти проти того, хто йде на нього з двадцятьма тисячами? ");
INSERT INTO ukronpu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Якщо ні, то поки той ще далеко, надішле послів до нього просити про мир. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Так і кожний з вас, хто не зречеться всього, що має, не може бути Моїм учнем. ");
INSERT INTO ukronpu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Сіль – добра річ, але якщо й сіль втратить солоність, то чим повернути її смак? ");
INSERT INTO ukronpu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Вона вже не придатна ні для землі, ні для добрива, її викидають геть. Хто має вуха, щоб слухати, слухайте!» ");
INSERT INTO ukronpu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Усі митники та грішники приходили до Ісуса, щоб послухати Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Але фарисеї та книжники нарікали кажучи: ―Він грішників приймає та їсть разом із ними. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Тоді Він розповів їм притчу: ");
INSERT INTO ukronpu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Який чоловік із вас, маючи сто овець та загубивши одну з них, не залишить дев’яносто дев’ять у пустелі та не піде шукати загублену, доки не знайде її? ");
INSERT INTO ukronpu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","І, знайшовши, з радістю покладе її на свої плечі. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Прийшовши додому, він покличе своїх друзів та сусідів, кажучи їм: «Радійте зі мною, бо я знайшов мою загублену вівцю». ");
INSERT INTO ukronpu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Кажу вам: на небі буде більше радості за одного грішника, що кається, ніж за дев’яноста дев’ятьох праведників, які не потребують покаяння. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Або яка жінка, маючи десять драхмта загубивши одну з них, не запалює світильника й не замітає в хаті, шукаючи уважно, доки не знайде? ");
INSERT INTO ukronpu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","А знайшовши, кличе приятельок та сусідок і каже: «Радійте зі мною, бо я знайшла загублену драхму». ");
INSERT INTO ukronpu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Такою, кажу вам, є радість ангелів Божих за одного грішника, який кається. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Він також сказав: ―Один чоловік мав двох синів. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Молодший із них сказав батькові: «Батьку, дай мені мою частину спадщини». І той поділив між ними майно. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Через декілька днів молодший син, зібравши все, відправився в далекий край і там розтратив усе своє майно, живучи розпусно. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Коли ж він усе витратив, настав великий голод у тім краю, і він почав бідувати. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","І пішов та пристав до одного з жителів того краю, а той послав його на свої поля пасти свиней. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Він бажав би наїстися хоча б стручками ріжкового дерева, які їли свині, але ніхто не давав йому. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Опам’ятавшись, він сказав: «Скільки наймитів мого батька мають хліба вдосталь, а я тут помираю з голоду! ");
INSERT INTO ukronpu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Встану, піду до свого батька та скажу йому: „Батьку, согрішив я проти Неба та проти тебе ");
INSERT INTO ukronpu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","і вже не достойний називатися твоїм сином. Прийми мене, як одного з твоїх наймитів!“» ");
INSERT INTO ukronpu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","І, вставши, пішов до свого батька. Коли він був ще далеко, батько побачив його, змилосердився над ним та побіг до нього, обійняв його та почав цілувати. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Син промовив до нього: «Батьку! Я согрішив проти Неба й проти тебе і вже недостойний називатися твоїм сином!» ");
INSERT INTO ukronpu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Батько ж промовив до своїх рабів: «Принесіть швидко найкращу одежу, одягніть його і дайте перстень йому на руку та взуття на ноги! ");
INSERT INTO ukronpu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Приведіть відгодоване теля та заколіть його! Будемо їсти та веселитись, ");
INSERT INTO ukronpu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","бо цей син мій був мертвий та ожив, пропав та знайшовся!» І почали веселитися. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","А старший його син був у полі; і коли, повертаючись із поля, наблизився до дому, почув музику й танці. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Покликавши одного зі слуг, запитав: «Що це таке?» ");
INSERT INTO ukronpu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","«Твій брат прийшов, – сказав той, – і твій батько заколов відгодоване теля, бо його син повернувся живий та здоровий». ");
INSERT INTO ukronpu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Він розлютився та не схотів увійти в дім. Батько ж його, вийшовши, став його просити. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Але він відповів своєму батькові: «Я стільки років служив тобі й ніколи не нехтував твоїм наказом, а ти жодного разу не дав мені й козенятка, щоб я повеселився з моїми друзями. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Але коли прийшов цей син твій, що розтратив твоє майно з блудницями, ти заколов для нього відгодоване теля». ");
INSERT INTO ukronpu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Батько відповів йому: «Дитино, ти завжди зі мною, і все, що в мене є, – твоє. ");
INSERT INTO ukronpu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Веселитися ж і радіти треба тому, що цей брат твій був мертвий та ожив, пропав та знайшовся». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Потім сказав учням: ―В одного багатого чоловіка був управитель, якого звинуватили в марнотратстві. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Він покликав його та сказав: «Що це я чую про тебе? Дай мені звіт про твоє управління, бо ти не можеш більше управляти». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Управитель подумав: «Що мені робити? Мій господар звільняє мене. Копати – не маю сил, просити – соромно. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Але я знаю, що робити, щоб, коли мене звільнять з управління, знайшлися люди, які приймуть мене до своїх домівок». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Почав він кликати кожного з боржників свого господаря. Першого він запитав: «Скільки ти винен моєму господареві?» ");
INSERT INTO ukronpu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Той відповів: «Сто мір оливкової олії». І сказав йому: «Візьми швидко свою розписку та запиши п’ятдесят». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Потім другому сказав: «А ти скільки винен?» Той відповів: «Сто мір пшениці». Він сказав йому: «Візьми свою розписку та пиши вісімдесят». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Господар похвалив нечесного управителя за його кмітливість, бо сини цього світу мудріші у справах зі своїм родом, ніж сини світла. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Я кажу вам: здобувайте собі приятелів за допомогою неправедного багатства, щоб коли воно мине, вас прийняли у вічні оселі. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Хто вірний у малому, той вірний і у великому, а невірний у малому, і у великому невірний. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Отже, якщо ви не були вірні в неправедних багатствах, хто вам довірить справжнє? ");
INSERT INTO ukronpu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Якщо в чужому не були вірні, хто вам дасть ваше? ");
INSERT INTO ukronpu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Жоден слуга не може служити двом господарям, бо одного ненавидітиме, а другого любитиме, або одним буде нехтувати, а іншому буде відданим. Не можете служити Богові та багатству. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Почули про це фарисеї, які любили гроші, та глузували з Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Але Ісус відповів їм: ―Ви вдаєте себе за праведних перед людьми, але Бог знає серця ваші, бо що високе в людей, те мерзенне в очах Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Закон та Пророки були до Івана. Відтоді проповідується Добра Звістка Царства Божого, і кожен із зусиллям входить у нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Але скоріше небо та земля зникнуть, ніж одна риска Закону пропаде. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Кожен, хто розлучається зі своєю дружиною та одружується з іншою, перелюбствує; і всякий, хто одружується з розлученою жінкою, чинить перелюб. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Був собі багатий чоловік, який одягався в дорогу та вишукану одежу. Щодня він розкішно бенкетував. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Біля його воріт лежав убогий, на ім’я Лазар, що весь був у виразках ");
INSERT INTO ukronpu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","і бажав насититися тим, що падало зі столу багатого. Собаки, підходячи, лизали його рани. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Надійшов час, убогий помер, і ангели віднесли його на лоно Авраама. Помер же і багач, і поховали його. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","А в пеклі, будучи в муках, він підняв свої очі та побачив здалека Авраама та Лазаря на його лоні. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","І, закричавши, сказав: «Отче Аврааме! Змилуйся наді мною та пішли Лазаря, нехай умочить кінець свого пальця у воду та прохолодить мій язик, бо я сильно страждаю в цьому полум’ї». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Авраам відповів: «Сину! Згадай, що ти за життя свого одержав свої блага, як і Лазар – своє лихо. Тепер же він тішиться, а ти страждаєш. ");
INSERT INTO ukronpu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","І крім того, між нами та вами встановлена велика прірва, щоб ті, які бажають перейти звідси до вас, не могли, і щоб звідти до нас не переходили». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Той відповів: «Тоді благаю тебе, отче, пошли Лазаря в дім мого батька, ");
INSERT INTO ukronpu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","бо в мене п’ятеро братів, нехай він засвідчить їм, щоб вони не прийшли в це місце страждання». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Авраам відповів: «Вони мають Мойсея та Пророків, нехай їх слухають». ");
INSERT INTO ukronpu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Але той відповів: «Ні, отче Аврааме, якщо хтось із мертвих піде до них, то вони покаються!» ");
INSERT INTO ukronpu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Тоді Авраам сказав йому: «Якщо Мойсея і Пророків не слухають, то навіть якщо хтось із мертвих воскресне, це їх не переконає». ");
INSERT INTO ukronpu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Потім Ісус промовив до своїх учнів: ―Неможливо, щоб спокуси не приходили, але горе тому, через кого приходить спокуса. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Для нього було б краще, якби йому повісили млинове жорно на шию й кинули в море, ніж щоб він спокусив одного з цих малих. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Зважайте на себе! Якщо твій брат согрішить проти тебе, докори йому; а коли він покається, прости його. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","І якщо він согрішить сім разів на день і сім разів прийде й скаже: «Я каюсь», – прости його. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Апостоли сказали Господеві: ―Додай нам віри! ");
INSERT INTO ukronpu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Господь відповів: ―Якби ви мали віру, як гірчичне зерно, то сказали б цій шовковиці: «Вирвись із корінням і пересадись у море!», – і вона послухала б вас. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Хто з вас, маючи раба, який оре або пасе овець, скаже йому, коли він повернеться з поля: «Іди мерщій та сідай до столу?» ");
INSERT INTO ukronpu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","А чи не скаже йому радше: «Приготуй мені вечерю та, підперезавшись, прислуговуй мені, поки я буду їсти та пити, а потім їж і пий сам?» ");
INSERT INTO ukronpu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Чи дякує хазяїн рабу за те, що той виконав наказ? ");
INSERT INTO ukronpu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Так само й ви, коли зробите все, що вам було доручено, кажіть: «Ми раби недостойні, котрі зробили тільки те, що повинні були зробити». ");
INSERT INTO ukronpu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ідучи до Єрусалима, Ісус проходив між Самарією та Галілеєю. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","І коли Він входив в одне село, зустріли Його десятеро прокажених. Вони зупинилися неподалік ");
INSERT INTO ukronpu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","та голосно прокричали: ―Ісусе, Наставнику, змилуйся над нами! ");
INSERT INTO ukronpu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Побачивши їх, Він сказав: ―Ідіть та покажіться священникам! І, коли вони йшли, очистилися. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Один із них, побачивши, що зцілився, повернувся, голосно прославляючи Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","І припав лицем до ніг Ісуса, дякуючи Йому. Він був самарянином. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ісус промовив: ―Хіба не десять очистилося? Де ж дев’ять? ");
INSERT INTO ukronpu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Невже жоден із них, окрім цього чужинця, не повернувся віддати славу Богові? ");
INSERT INTO ukronpu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Потім сказав йому: ―Встань та йди, твоя віра спасла тебе! ");
INSERT INTO ukronpu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Фарисеї запитали Його, коли прийде Царство Боже. Ісус відповів: ―Царство Боже прийде непомітно. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ніхто не зможе сказати: «Ось воно тут!» або: «Воно там!», бо Царство Боже серед вас. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Потім Він промовив до учнів: ―Прийдуть дні, коли забажаєте побачити бодай один день Сина Людського, але не побачите. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Скажуть вам: «Ось Він там!» або: «Ось Він тут!» – не ходіть і не біжіть за ними! ");
INSERT INTO ukronpu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Бо як блискавка, блиснувши, освітлює небо від одного краю до іншого, так буде й Син Людський у день Свій. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Але перше Йому треба багато страждати та бути відкинутим цим поколінням. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Як було за днів Ноя, так буде й за днів Сина Людського: ");
INSERT INTO ukronpu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","люди їли, пили, одружувались, виходили заміж аж до дня, коли Ной увійшов у ковчег, і прийшов потоп та знищив усіх. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Так само, як було й за днів Лота: люди їли, пили, продавали, купували, садили, будували; ");
INSERT INTO ukronpu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","але того дня, коли Лот вийшов із Содома, з неба випав дощ вогню й сірки та знищив їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Так буде й того дня, коли Син Людський з’явиться. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Того дня, хто буде на даху, а речі його в домі, нехай не сходить за ними; і хто буде в полі, також нехай не вертається назад. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Пам’ятайте про дружину Лота. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Хто намагатиметься спасти своє життя, той загубить його; а хто втратить життя, той його збереже. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Кажу вам, що тієї ночі будуть двоє на одному ліжку: одного буде взято, а другого залишено. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Дві жінки будуть молоти разом: одну буде взято, а другу залишено. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Двоє чоловіків будуть у полі: одного візьмуть, а другого залишать. ");
INSERT INTO ukronpu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Вони запитали: ―Де, Господи? Ісус відповів: ―Де буде тіло, там зберуться й орли. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Тоді Ісус розповів їм притчу про те, що їм треба завжди молитися та не занепадати духом. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Він сказав: ―В одному місті був суддя, який не боявся Бога та не соромився людей. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","У тому ж місті була вдова, котра приходила до нього й просила: «Захисти мене від мого кривдника!» ");
INSERT INTO ukronpu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Деякий час він відмовлявся, але потім промовив до себе: «Хоч я і Бога не боюся, і людей не соромлюся, ");
INSERT INTO ukronpu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","але через те, що ця вдова не дає мені спокою, захищу її, щоб вона не приходила безперестанку й не докучала мені». ");
INSERT INTO ukronpu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","І сказав Господь: ―Почуйте, що каже неправедний суддя! ");
INSERT INTO ukronpu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Так невже Бог не захистить Своїх обраних, котрі взивають до Нього день і ніч? Чи забариться Він? ");
INSERT INTO ukronpu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Кажу вам: Він негайно захистить їх. Але коли прийде Син Людський, чи знайде Він віру на землі? ");
INSERT INTO ukronpu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Тим, хто був упевнений в особистій праведності та принижував інших, Ісус розповів таку притчу: ");
INSERT INTO ukronpu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Двоє чоловіків прийшли в Храм помолитися. Один був фарисеєм, а інший – митником. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Фарисей стояв і так собі молився: «Боже, дякую Тобі за те, що я не такий, як інші люди, – грабіжники, неправедні, невірні або як цей митник. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Я пощу двічі на тиждень, даю десятину зі всякого прибутку!» ");
INSERT INTO ukronpu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","А митник стояв здалека й не смів навіть очей звести на небо, але бив себе в груди та казав: «Боже, змилуйся наді мною, грішним!» ");
INSERT INTO ukronpu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Кажу вам: цей чоловік повернувся додому виправданий, а не той; бо кожний, хто себе підносить, буде принижений, а хто себе принижує, буде піднесений. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Деякі люди приносили до Нього також і дітей, щоб Він доторкнувся до них та благословив, але учні, побачивши це, забороняли їм. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ісус покликав їх до себе й сказав: «Пустіть дітей приходити до Мене й не забороняйте їм, бо таким, як вони, належить Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Істинно кажу вам: хто не прийме Царства Божого, як дитя, той не ввійде до нього!» ");
INSERT INTO ukronpu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Один із керівників сказав: ―Учителю добрий, що мені робити, щоб успадкувати життя вічне. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ісус відповів йому: ―Чому ти називаєш Мене добрим? Ніхто не є Добрий, окрім Самого Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ти знаєш заповіді: «Не чини перелюбу», «Не вбивай», «Не вкради», «Не обманюй», «Шануй твого батька та матір». ");
INSERT INTO ukronpu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Він же сказав: ―Усе це я зберіг змалку. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Почувши це, Ісус сказав йому: ―Одного тобі ще бракує: продай усе, що маєш, та роздай бідним, і матимеш скарб на небесах; а тоді приходь та слідуй за Мною. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Почувши це, він глибоко засмутився, адже був дуже багатий. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ісус же, побачивши, що він засмутився, сказав: ―Як важко багатому ввійти в Царство Боже! ");
INSERT INTO ukronpu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Адже легше верблюдові пройти через вушко голки, ніж багатому ввійти в Царство Боже. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ті, що почули це, запитали: ―Хто ж тоді може бути спасенний? ");
INSERT INTO ukronpu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ісус відповів: ―Неможливе для людей – можливе для Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Тоді Петро сказав: ―Ось ми залишили, що в нас було, та пішли за Тобою. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Він відповів: ―Істинно кажу вам: немає нікого, хто б залишив дім, дружину, дітей, батьків і братів заради Царства Божого ");
INSERT INTO ukronpu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","й не отримав би значно більше в цей час, а в майбутньому віці – вічне життя. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ісус узяв дванадцятьох та сказав їм: «Ось ми йдемо до Єрусалима, і збудеться все, написане пророками про Сина Людського. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Він буде виданий язичникам, і насміхатимуться з Нього, і зневажатимуть Його, і плюватимуть на Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Будуть бичувати Його та вб’ють, але третього дня Він воскресне». ");
INSERT INTO ukronpu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Та вони нічого з цього не зрозуміли. Ці слова були приховані від них, і вони не розуміли сказаного. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Коли ж Він наближався до Єрихона, один сліпий сидів біля дороги та просив милостиню. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Почувши, що проходить натовп, він запитав, що відбувається. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Йому сказали, що Ісус із Назарета проходить. ");
INSERT INTO ukronpu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Тоді він закричав: ―Ісусе, Сину Давидів, змилуйся наді мною! ");
INSERT INTO ukronpu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ті, що йшли попереду, почали докоряти йому, щоб він мовчав, але він ще голосніше закричав: ―Сину Давидів, змилуйся наді мною! ");
INSERT INTO ukronpu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ісус зупинився та звелів привести сліпого до Себе. Коли той наблизився до Нього, Ісус спитав його: ");
INSERT INTO ukronpu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Що хочеш, щоб Я зробив для тебе? Той відповів: ―Господи, щоб я знову бачив! ");
INSERT INTO ukronpu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ісус сказав йому: ―Прозрій! Віра твоя спасла тебе! ");
INSERT INTO ukronpu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","І він умить прозрів та пішов за Ісусом, прославляючи Бога. І весь народ, побачивши це, теж славив Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ісус зайшов у Єрихон та проходив через місто. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","І ось один багатий чоловік, на ім’я Закхей, який був старший над митниками, ");
INSERT INTO ukronpu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","бажав бачити Ісуса, але через натовп не міг, оскільки був малого зросту. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Тоді побіг уперед та заліз на шовковицю, щоб побачити Ісуса, бо тією дорогою Він мав проходити. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Прийшовши на те місце, Ісус глянув угору та промовив до нього: ―Закхею, злізь скоріше, бо сьогодні Я повинен залишитись у твоєму домі. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Той поспішно зліз і радо прийняв Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Побачивши це, усі почали нарікати говорячи: ―Він зайшов у гостину до грішного чоловіка. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Закхей же встав та сказав Господеві: ―Господи! Половину свого майна я віддаю бідним і, якщо когось чимось обманув, повертаю вчетверо. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Тоді Ісус сказав йому: ―Сьогодні спасіння прийшло в цей дім, адже й він син Авраама. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Бо Син Людський прийшов знайти та спасти загублене. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Тим, хто це слухав, Ісус розповів притчу, бо Він був недалеко від Єрусалима, і вони думали, що Царство Боже має з’явитися негайно. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Отже, Він сказав: —Один знатний чоловік вирушив у далеку країну, щоб отримати царство та повернутися. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Покликавши десятьох рабів, він роздав їм десять міні сказав їм: «Вкладіть ці гроші в діло, доки я не повернуся!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Але жителі цієї країни ненавиділи його й надіслали посланців слідом за ним, щоб сказати: «Не бажаємо, щоб він царював над нами!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Отримавши царську владу, він повернувся та покликав до себе рабів, котрим роздав гроші, аби дізнатися, який вони отримали прибуток. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Перший прийшов і сказав: «Господарю, твоя міна принесла десять мін!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Господар сказав: «Добре, хороший та вірний рабе! За те, що ти був вірний у малому, отримай владу над десятьма містами!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Прийшов другий та сказав: «Господарю, твоя міна принесла п’ять мін!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Господар сказав: «І ти володій п’ятьма містами!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Прийшов третій і сказав: «Господарю, ось твоя міна, яку я зберігав, загорнувши в хустину. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Я боявся тебе, бо ти жорстока людина: ти береш те, чого не клав, і жнеш там, де не сіяв!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Господар відповів: «Зі слів твоїх тебе судитиму, лукавий рабе! Ти знав, що я чоловік жорстокий: беру те, чого не поклав, і жну там, де не сіяв? ");
INSERT INTO ukronpu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Чому ж ти не вклав мого срібла в банк, щоб я, повернувшись, отримав своє з прибутком?» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","І сказав присутнім: «Заберіть від нього міну й віддайте тому, хто має десять мін». ");
INSERT INTO ukronpu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Вони відповіли: «Господарю, він має десять мін!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Кажу вам, – сказав Він, – тому, хто має, додасться, і матиме надмірно, а від того, хто не має, і те, що має, забереться. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","А ворогів моїх, які не хотіли, щоб я царював над ними, приведіть сюди й убийте переді мною. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Сказавши це, Ісус пішов далі в Єрусалим. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Коли наблизився до Вітфагії та Віфанії, до гори, що зветься Оливною, Він надіслав двох учнів ");
INSERT INTO ukronpu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","та сказав: «Ідіть у село, яке перед вами, і як зайдете, то знайдете прив’язане осля, на яке ще ніхто з людей не сідав; відв’яжіть його й приведіть. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Якщо хтось спитає вас: „Чому ви відв’язуєте його?“, скажіть: „Господь потребує його“». ");
INSERT INTO ukronpu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Посланці пішли й знайшли все так, як Ісус сказав їм. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Коли вони відв’язували осля, господарі спитали їх: ―Чому відв’язуєте осля? ");
INSERT INTO ukronpu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Вони відповіли: ―Господь потребує його! ");
INSERT INTO ukronpu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","І привели осля до Ісуса та, накинувши на нього свій одяг, посадили Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Коли Він їхав, люди стелили свій одяг по дорозі. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","А коли Він наблизився до схилу Оливної гори, безліч учнів почали радісно та голосно прославляти Бога за всі чудеса, які вони бачили. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Вони викрикували: «Благословенний Цар, Який іде в ім’я Господа!» «Мир на небі й слава на висоті!» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Деякі фарисеї з натовпу казали Ісусові: ―Учителю, заборони Своїм учням! ");
INSERT INTO ukronpu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Але Він відповів: ―Кажу вам: якщо вони замовкнуть, кричатиме каміння! ");
INSERT INTO ukronpu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Коли вони наблизились до Єрусалима й побачили місто, Ісус заплакав над ним. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Він сказав: «Коли б зрозуміло ти сьогодні, що могло принести тобі мир! Але тепер це приховано від очей твоїх! ");
INSERT INTO ukronpu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Прийдуть дні, коли вороги твої оточать тебе валом, обляжуть та стиснуть тебе звідусюди! ");
INSERT INTO ukronpu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Вони знищать тебе та вб’ють твоїх дітей, не залишать каменя на камені в тобі, бо ти не впізнало часу твоїх відвідин». ");
INSERT INTO ukronpu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ісус увійшов у Храм та вигнав усіх тих, хто продавав і купував там. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Він казав їм: «Написано: „Дім Мій буде Домом Молитви“, а ви зробили з нього „притулок розбійників!“» ");
INSERT INTO ukronpu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ісус навчав у Храмі щодня. А первосвященники, книжники та старійшини народу шукали нагоди вбити Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Однак не знали, як це зробити, бо весь народ тримався біля Нього, слухаючи Його уважно. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Одного дня, коли Ісус навчав народ у Храмі, проповідуючи Добру Звістку, до Нього підійшли первосвященники, книжники та старійшини ");
INSERT INTO ukronpu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","й запитали Його: ―Скажи нам, якою владою Ти це робиш? Або хто дав Тобі таку владу? ");
INSERT INTO ukronpu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ісус сказав їм у відповідь: ―Запитаю і Я вас про одне. Скажіть Мені: ");
INSERT INTO ukronpu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Іванове хрещення було з Неба чи від людей? ");
INSERT INTO ukronpu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Вони ж стали говорити між собою: ―Якщо скажемо: «З неба», Він запитає: «Чому ж ви не повірили йому?» ");
INSERT INTO ukronpu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Якщо ж ми скажемо: «Від людей», то весь народ поб’є нас камінням, бо вони переконані, що Іван був пророком. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Тож вони відповіли, що не знають, звідки воно. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ісус сказав: ―Тоді і Я не скажу, якою владою це роблю. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","І почав Він розповідати людям таку притчу: ―Один чоловік посадив виноградник, здав його в оренду виноградарям та вирушив у подорож на довгий час. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Коли надійшов час, він надіслав одного раба до виноградарів, щоб вони віддали його частину врожаю. Однак виноградарі побили його й відіслали назад ні з чим. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Він надіслав іншого раба, але вони й того, побивши та зневаживши, відіслали ні з чим. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Він надіслав третього, але вони й цього поранили та викинули з виноградника. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Тоді господар виноградника подумав: «Що ж мені робити? Надішлю до них мого улюбленого сина, може, його поважатимуть!» ");
INSERT INTO ukronpu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Але виноградарі, побачивши його, сказали один одному: «Це спадкоємець, ходімо та вб’ємо його, щоб спадщина дісталася нам!» ");
INSERT INTO ukronpu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Вони його вивели з виноградника та вбили. Що ж зробить із ними господар виноградника? ");
INSERT INTO ukronpu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Він прийде та вб’є тих виноградарів, а виноградник віддасть іншим. Тоді ті, хто слухав, сказали: ―Нехай не станеться так! ");
INSERT INTO ukronpu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Але Ісус, подивившись на них, запитав: ―Тоді що означає написане: «Камінь, який відкинули будівничі, став наріжним каменем»? ");
INSERT INTO ukronpu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Кожен, хто впаде на цей камінь, буде розбитий, а той, на кого він впаде, буде розчавлений. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Книжники та первосвященники шукали нагоди схопити Ісуса, але боялися народу. Вони зрозуміли, що Він про них сказав цю притчу. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","І почали вони уважно слідкувати за Ним, надіслали людей, які вдавали із себе праведних, щоб спіймати Його на слові й видати владі намісника. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Вони запитали Його: ―Учителю, ми знаємо, що Ти правдиво говориш та навчаєш. Ти не зважаєш на людське обличчя, а правдиво навчаєш Божого шляху. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Чи годиться нам платити податок Кесареві, чи ні? ");
INSERT INTO ukronpu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Зрозумівши їхню хитрість, Ісус сказав їм: ");
INSERT INTO ukronpu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Покажіть Мені динарій! Чиє на ньому зображення та напис? Вони відповіли: ―Кесаря! ");
INSERT INTO ukronpu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Тоді Він сказав: ―Тож віддайте Кесареві Кесареве, а Богові – Боже! ");
INSERT INTO ukronpu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Вони не змогли впіймати Його на слові перед народом і, здивовані Його відповіддю, замовкли. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Тоді підійшли до Ісуса деякі садукеї, які кажуть, що немає воскресіння з мертвих, і запитали Його: ");
INSERT INTO ukronpu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Учителю, Мойсей написав нам: «Якщо чийсь брат помре та залишить дружину бездітною, то нехай його брат візьме дружину померлого та підніме нащадка своєму братові». ");
INSERT INTO ukronpu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Було семеро братів. Перший одружився та помер бездітним. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Потім другий ");
INSERT INTO ukronpu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","і третій одружувалися з вдовою, і так усі семеро. Вони померли, не залишивши дітей після себе. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Після всіх померла й жінка. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Отже, при воскресінні чиєю дружиною вона буде? Адже всі семеро мали її за дружину. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ісус відповів їм: ―Люди цього віку одружуються та виходять заміж. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Але ті, що будуть достойні того віку й воскресіння з мертвих, не будуть одружуватись і не виходитимуть заміж. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","І померти вже не зможуть, а будуть як ангели, бо вони є синами Божими та синами воскресіння. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","А те, що мертві воскресають, показав Мойсей при полум’ї вогню тернового куща, коли назвав Господа Богом Авраама, Богом Ісаака і Богом Якова. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Він є Богом не мертвих, а живих! Для Нього всі живі! ");
INSERT INTO ukronpu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Деякі з книжників сказали: ―Учителю, Ти добре сказав! ");
INSERT INTO ukronpu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","І більше ніхто не наважувався ставити Йому запитання. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Потім Ісус запитав їх: ―Чому вони кажуть, що Христос є сином Давида? ");
INSERT INTO ukronpu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Сам же Давид каже в книзі Псалмів: «Господь сказав Господеві моєму: „Сядь праворуч від Мене, ");
INSERT INTO ukronpu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","доки Я не покладу ворогів Твоїх, як підніжок для Твоїх ніг“». ");
INSERT INTO ukronpu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Давид називає Його Господом, як Він може бути його Сином? ");
INSERT INTO ukronpu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Коли весь народ слухав, Ісус промовив до учнів: ");
INSERT INTO ukronpu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Стережіться книжників: їм подобається одягатись у довгі одежі, вони люблять привітання на ринках, перші місця в синагогах та почесні місця на бенкетах. ");
INSERT INTO ukronpu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Вони з’їдають доми вдів, але прикриваються довгими молитвами. Вони отримають суворіше покарання». ");
INSERT INTO ukronpu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ісус дивився, як багатії клали свої дари в скарбницю Храму. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Побачив Він також і бідну вдову, яка поклала туди дві лепти. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","І промовив: «Істинно кажу вам: ця бідна вдова поклала більше, ніж усі інші, ");
INSERT INTO ukronpu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","бо всі клали зі свого достатку, а вона зі своєї бідності поклала все, що в неї було на прожиток». ");
INSERT INTO ukronpu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Коли присутні заговорили про Храм, що він прикрашений дорогоцінним камінням та дарами, Він сказав: ");
INSERT INTO ukronpu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Прийдуть дні, коли з того, що бачите, не залишиться каменя на камені, який не був би зруйнований. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","І запитали Його: ―Учителю, коли це станеться? І яка ознака того, що це має статися? ");
INSERT INTO ukronpu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Він відповів: ―Дивіться, щоб ніхто не ввів вас в оману, бо багато хто прийде в ім’я Моє й казатиме: «Це Я!» і «Час наблизився!» Не йдіть за ними! ");
INSERT INTO ukronpu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Коли почуєте про війни та повстання, не лякайтеся: спочатку все це має статися, але кінець буде не відразу. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Тоді сказав їм: ―Повстане народ проти народу й царство проти царства. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Будуть сильні землетруси в різних місцях, голод та чума. Будуть відбуватися страшні події та великі знамення на небі. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Але перед тим, як все це відбудеться, накладуть на вас руки та переслідуватимуть вас. Видаватимуть вас у синагоги та в’язниці, поведуть вас до царів та правителів через ім’я Моє. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","І це дасть вам можливість свідчити. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Отже, покладіть собі в серця не турбуватись завчасно, що говорити на свій захист, ");
INSERT INTO ukronpu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","бо Я дам вам слова й таку мудрість, якій не зможуть противитися й суперечити всі ваші противники. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Вас будуть зраджувати навіть ваші батьки, брати, родичі та друзі. Декого з вас вбиватимуть. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","І всі будуть ненавидіти вас через Моє ім’я. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Але жодна волосина з вашої голови не пропаде. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Терпінням вашим ви здобудете душі ваші. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Коли ж побачите Єрусалим, оточений військами, тоді знайте, що його спустошення наблизилось. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Тоді ті, що в Юдеї, нехай тікають у гори; ті, що в Єрусалимі, нехай виходять із нього; а ті, що будуть на полях, нехай до нього не входять. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Бо це буде час помсти, коли все написане здійсниться. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Горе вагітним і тим, що будуть годувати грудьми в ті дні, бо велике лихо буде на землі та гнів на цьому народі. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Люди будуть гинути від меча, їх заберуть у полон поміж усі народи. Єрусалим топтатимуть язичники, аж доки час язичників не закінчиться. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","І будуть знамення на сонці, місяці та зірках, а на землі буде жах між народами та розгубленість від ревіння морських хвиль. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Люди вмиратимуть від страху в очікуванні подій, що насуваються на людство, бо сили небесні захитаються. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","І тоді люди побачать Сина Людського, Який приходить на хмарі з великою силою та славою. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Коли ці речі почнуть збуватися, ви встаньте та підійміть ваші голови, бо наближається визволення ваше. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Потім сказав їм цю притчу: ―Дивіться на смоковницю та на всі дерева: ");
INSERT INTO ukronpu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","коли на них з’являється листя, знаєте, що літо вже близько. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Так і ви, коли побачите, що це збувається, знайте: Царство Боже вже близько. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Істинно кажу вам: не мине цей рід, поки все це не станеться. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Небо та земля проминуть, але слова Мої не проминуть. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Будьте уважні, щоб ваші серця не обтяжували ненажерство, п’янство та життєві турботи і щоб день той не застав вас зненацька, ");
INSERT INTO ukronpu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","як пастка. Бо він прийде несподівано для всіх, хто живе на землі. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Завжди пильнуйте та моліться, щоб мати змогу уникнути всього того, що має відбутися, і стати перед Сином Людським. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Кожен день Ісус навчав у Храмі, а вночі виходив та перебував на горі, що зветься Оливною. ");
INSERT INTO ukronpu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Увесь народ збирався зранку в Храмі, аби слухати Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Наближалося свято Опрісноків, що зветься Пасхою. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Первосвященники та книжники шукали, як убити Ісуса, але боялися народу. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Тоді увійшов сатана в Юду, званого Іскаріот, що був із числа дванадцяти. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Він пішов та зговорився з первосвященниками та начальниками храмової охорони, як видати їм Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Вони зраділи та обіцяли дати йому грошей. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Юда погодився та шукав слушної нагоди, щоб Його видати без народу. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Настав день свята Опрісноків, коли належало принести пасхальну жертву. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","І надіслав Ісус Петра та Івана, кажучи: ―Ідіть та приготуйте для нас Пасху, щоб ми спожили. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Вони спитали: ―Де Ти хочеш, щоб ми приготували? ");
INSERT INTO ukronpu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Він відповів їм: ―Коли ввійдете в місто, вас зустріне чоловік, який нестиме глечик із водою. Ідіть за ним до дому, куди він увійде, ");
INSERT INTO ukronpu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","та скажіть господареві дому: «Учитель питає тебе: „Де кімната, у якій Я буду споживати Пасху з Моїми учнями?“» ");
INSERT INTO ukronpu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Він покаже вам нагорі велику прибрану кімнату – там і приготуйте. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Вони пішли й знайшли все саме так, як казав їм Ісус, та приготували там Пасху. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Коли настав час, Ісус з апостолами сіли за стіл. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Він сказав їм: «Я дуже хотів їсти цю Пасху разом із вами перед Моїм стражданням. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Кажу вам: уже не їстиму її, доки вона не звершиться в Царстві Божому». ");
INSERT INTO ukronpu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","І, узявши чашу та подякувавши Богу, сказав: «Візьміть її та поділіть між вами. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Кажу вам: віднині не питиму більше з цього виноградного плоду, доки не прийде Царство Боже». ");
INSERT INTO ukronpu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Потім узяв хліб та, подякувавши, розламав і дав їм, кажучи: «Це є тіло Моє, що за вас віддається. Чиніть це на згадку про Мене». ");
INSERT INTO ukronpu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Так само після того, як поїли, узяв і чашу, кажучи: «Ця чаша – Новий Завіт у Моїй крові, що проливається за вас. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Однак рука того, хто зраджує Мене, зі Мною за столом. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Бо Син Людський іде, як і було призначено, але горе тому чоловікові, через якого зраджено Його». ");
INSERT INTO ukronpu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Вони почали питати один одного, хто з них міг би таке зробити. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Потім знялась між ними суперечка, хто з них найбільший. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ісус же сказав їм: ―Царі народів володіють ними, і тих, що керують ними, називають благодійниками. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Але ви не будьте такими! Навпаки: найбільший між вами нехай буде як найменший, і той, хто керує, нехай буде як слуга. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Бо хто більший: той, що сидить за столом, чи той, хто прислуговує? Чи не той, хто сидить за столом? Я ж серед вас як слуга. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ви ті, що залишилися зі Мною в Моїх випробуваннях. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","І Я заповідаю вам Царство, як Мені заповів Мій Отець, ");
INSERT INTO ukronpu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","щоб ви їли та пили за столом у Царстві Моєму. Ви сядете на престолах, судячи дванадцять племен Ізраїля. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Симоне, Симоне! Ось сатана просив просіяти вас, як пшеницю. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Але Я молився за тебе, щоб ти не загубив віри та після навернення зміцнив твоїх братів. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Петро сказав Йому: ―Господи, з Тобою я готовий іти у в’язницю й на смерть. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Але Ісус відповів: ―Кажу тобі, Петре, що півень ще не заспіває сьогодні, як ти тричі зречешся, що не знаєш Мене. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Потім промовив до них: ―Коли Я вас посилав без гаманця, без торби та взуття, чи бракувало вам чогось? Вони сказали: ―Нічого. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","―Але тепер хто має гаманець, нехай візьме його, так само й торбу; хто ж не має меча, хай продасть свій одяг та купить меч. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Кажу вам: на Мені має здійснитися те, що написано: «Його зараховано до злочинців».Бо все, що про Мене записано, збувається. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Вони сказали: ―Господи, дивись, у нас два мечі. Він відповів: ―Цього достатньо. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ісус, за своїм звичаєм, пішов на Оливну гору, і Його учні пішли за Ним. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Дійшовши до того місця, Він сказав їм: ―Моліться, щоб не впасти в спокусу! ");
INSERT INTO ukronpu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","А Сам відійшов від них на відстань кинутого каменя, став на коліна та молився ");
INSERT INTO ukronpu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","кажучи: «Отче, якщо бажаєш, нехай ця чаша обмине Мене. Однак нехай буде не Моя воля, а Твоя». ");
INSERT INTO ukronpu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Тоді з неба з’явився ангел та зміцнював Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","В агонії Він почав молитися ще старанніше. І піт Його став, мов краплі крові, що падали на землю. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Вставши від молитви, Він підійшов до учнів і знайшов, що вони заснули, виснажені смутком. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Він сказав їм: ―Чому ви спите? Прокиньтеся та моліться, щоб не впасти в спокусу! ");
INSERT INTO ukronpu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Коли Він ще говорив, ось підійшов натовп, і той, кого звали Юда, один із дванадцятьох, ішов перед ними. Він підійшов до Ісуса, щоб поцілувати Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ісус сказав йому: ―Юдо, ти поцілунком видаєш Сина Людського? ");
INSERT INTO ukronpu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Коли ті, що були з Ісусом, побачили, що має статися, сказали: ―Господи, чи не вдарити нам мечем? ");
INSERT INTO ukronpu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","І один із них мечем ударив раба первосвященника й відрубав йому праве вухо. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Але Ісус сказав: ―Облиште, досить! І, торкнувшись його вуха, зцілив його. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Потім Ісус звернувся до первосвященників, начальників храмової охорони та старійшин: «Ви вийшли проти Мене, як проти розбійника, з мечами та киями, щоб заарештувати. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Щодня Я був із вами в Храмі, і ви не підняли на Мене рук, але зараз ваш час і влада темряви». ");
INSERT INTO ukronpu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Тоді вони схопили Його та привели в дім первосвященника. Петро ж ішов за ними на відстані. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Коли вони розклали вогонь посеред двору та сіли навколо, Петро також сів між ними. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Одна зі служниць, побачивши, що він сидить біля вогню, придивилася до нього пильно та промовила: ―І цей був із Ним! ");
INSERT INTO ukronpu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Але Петро заперечив кажучи: ―Я не знаю Його, жінко! ");
INSERT INTO ukronpu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Трохи пізніше хтось інший побачив його й сказав: ―Ти теж один із них! Але Петро відповів: ―Ні, чоловіче! ");
INSERT INTO ukronpu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Близько години пізніше інший почав твердити кажучи: ―Справді, і цей був із Ним, бо він галілеянин. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Петро відповів: ―Чоловіче, я не знаю, про що ти говориш! І тієї ж миті, коли він ще говорив, заспівав півень. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Господь, обернувшись, глянув на Петра. Тоді Петро згадав слова Господа, які Він сказав: «Перед тим, як сьогодні заспіває півень, ти тричі зречешся Мене». ");
INSERT INTO ukronpu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","І, вийшовши геть, він гірко заплакав. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Люди, які охороняли Ісуса, почали насміхатися з Нього та бити Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Вони зав’язали Йому очі й питали кажучи: «Пророкуй! Хто Тебе вдарив?» ");
INSERT INTO ukronpu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","І багато інших богохульств казали проти Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","На світанку старійшини народу, первосвященники та книжники зібралися разом і повели Його на свій Синедріон. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Вони сказали: ―Якщо Ти – Христос, то скажи нам! Ісус відповів: ―Навіть якщо скажу, ви не повірите. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","І якщо Я спитаю вас, ви не відповісте. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Але віднині Син Людський сидітиме праворуч від Всемогутнього Бога. ");
INSERT INTO ukronpu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Тоді всі вони стали запитувати: ―То, значить, Ти – Син Божий? Ісус відповів: ―Ви самі кажете, що то Я! ");
INSERT INTO ukronpu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Тоді вони сказали: ―Навіщо нам потрібні свідчення? Ми чули це з Його вуст! ");
INSERT INTO ukronpu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Усе зібрання піднялося, і повели Його до Пилата. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Там почали звинувачувати Його: ―Ми встановили, що Він вводить народ в оману, забороняє сплачувати Кесареві податок і називає Себе Христом, Царем. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Пилат запитав Його: ―Ти Цар юдеїв? Ісус відповів: ―Ти кажеш це! ");
INSERT INTO ukronpu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Тоді Пилат сказав первосвященникам та натовпу: ―Я не знаходжу в Цій Людині жодної провини. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Але вони наполягали кажучи: ―Він підбурює народ, навчаючи всюди в Юдеї, почав із Галілеї, а тепер прийшов сюди. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Почувши це, Пилат запитав, чи Він галілеянин. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","І дізнавшись, що Ісус із території, яка підвладна Іродові, відіслав Його до Ірода, котрий був у ті дні в Єрусалимі. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Коли Ірод побачив Ісуса, то дуже зрадів, бо давно бажав побачити Його. Він багато чув про Ісуса та сподівався побачити від Нього якесь знамення. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","І ставив Йому багато запитань, але Ісус нічого не відповідав. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Первосвященники та книжники, які там стояли, наполегливо звинувачували Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Але Ірод зі своїми воїнами, познущавшись та насміявшись із Нього, одягнув Ісуса в яскраву одежу й відіслав назад до Пилата. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Того ж дня Ірод і Пилат стали друзями, хоч раніше вони ворогували один з одним. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Пилат скликав разом первосвященників, старійшин і народ ");
INSERT INTO ukronpu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","та сказав їм: ―Ви привели до мене Цього Чоловіка та сказали, що Він вводить народ в оману. І ось, дослідивши Його перед вами, я не знайшов на Цьому Чоловікові ніякої провини в тому, у чому ви Його звинувачуєте. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Навіть Ірод, не знайшовши в Ньому жодної провини, відіслав Його назад. Отже, Він не зробив нічого, вартого смерті. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Тож я Його покараю й відпущу. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","На свято йому треба було відпустити одного з в’язнів. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Але вони всі разом закричали кажучи: ―Візьми Його! Та відпусти нам Варавву! ");
INSERT INTO ukronpu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Варавва був ув’язнений за повстання, яке сталося в місті, та за вбивство. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Пилат, бажаючи відпустити Ісуса, знову заговорив. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Але вони продовжували кричати: ―Розіпни, розіпни Його! ");
INSERT INTO ukronpu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Пилат утретє звернувся до них: ―Яке ж зло Він скоїв? Ніякої провини, вартої смерті, я не знайшов у Ньому! Тож, покаравши Його, відпущу! ");
INSERT INTO ukronpu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Але вони продовжували кричати та наполягати, щоб Ісуса було розіп’ято. І своїми криками вони домоглися свого. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Пилат погодився виконати їхню вимогу. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Він відпустив того, хто за повстання та вбивство був у тюрмі, а Ісуса віддав на розп’яття, як вони вимагали. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Коли повели Ісуса, то, схопивши Симона з Кирени, що повертався з поля, поклали на нього хрест, щоб він ніс його за Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Серед великого натовпу людей, що йшли за Ним, були й жінки, які плакали та жаліли Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ісус повернувся до них та промовив: «Доньки Єрусалима, не плачте за Мною, а плачте за собою та за дітьми вашими. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Бо ось приходять дні, коли скажуть: „Блаженні неплідні, що не народжували й не годували грудьми!“ ");
INSERT INTO ukronpu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Тоді почнуть говорити горам: „Упадіть на нас!“ і пагорбам: „Покрийте нас!“ ");
INSERT INTO ukronpu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Бо коли так обходяться із зеленим деревом, то що ж буде із сухим?» ");
INSERT INTO ukronpu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Разом з Ісусом вели на страту двох злочинців. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Коли вони прийшли на місце, яке звалося «місце Черепа», там розіп’яли Його й злочинців: одного – праворуч, а іншого – ліворуч від Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ісус же казав: «Отче, прости їм, бо не знають, що чинять!» Коли ж ділили Його одяг між собою, то кидали жереб. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Народ стояв та дивився. Керівники ж насміхалися з Нього, кажучи: «Інших рятував, нехай врятує Себе, якщо Він Христос, Божий Обранець!» ");
INSERT INTO ukronpu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Глузували з Нього й воїни. Вони давали Йому кислого вина ");
INSERT INTO ukronpu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","й казали: «Якщо Ти Цар юдеїв, спаси Себе Самого!» ");
INSERT INTO ukronpu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Над Ним був напис: це цар юдеїв. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Один із розіп’ятих злочинців богохульствував проти Нього, кажучи: ―Хіба Ти не Христос? Спаси Себе й нас! ");
INSERT INTO ukronpu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","А другий відповів, докоряючи йому: ―Чи ти не боїшся Бога, коли й сам на те саме засуджений? ");
INSERT INTO ukronpu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ми покарані справедливо за те, що зробили, а Цей не зробив нічого поганого. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","І сказав: ―Ісусе, згадай мене, коли прийдеш у Царство Твоє! ");
INSERT INTO ukronpu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ісус відповів: ―Істинно кажу тобі: сьогодні будеш зі Мною в раю. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Було вже близько шостої години, і настала темрява по всій землі – аж до дев’ятої години. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Сонце затьмарилось, і завіса в Храмі розірвалася навпіл. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ісус, голосно скрикнувши, промовив: «Отче, у руки Твої Я ввіряю дух Мій!» Сказавши це, віддав дух. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Коли сотник побачив, що сталося, він прославив Бога й сказав: «Цей Чоловік справді був праведником!» ");
INSERT INTO ukronpu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Весь натовп, який зібрався подивитись на це видовище, побачивши, що сталося, повертався додому, б’ючи себе в груди. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Усі, хто знав Ісуса, і жінки, які йшли за Ним із Галілеї, стояли поодаль і дивилися на це. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","І був там один чоловік, на ім’я Йосиф, який був членом Синедріону, чоловік добрий та праведний. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Він не погодився з їхнім планом і рішенням. Йосиф походив з Ариматеї, юдейського міста, та очікував Царства Божого. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Він пішов до Пилата та попросив тіло Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","І знявши тіло, обгорнув його у льняну тканину й поклав до гробниці, яка була висічена в скелі, куди ще нікого не хоронили. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Це був день Приготування до Суботи, яка вже наступала. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Жінки, які прийшли разом з Ісусом із Галілеї, ідучи за Йосифом, бачили гробницю і як до неї було покладено тіло Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Повернувшись, приготували пахощі та миро. А в Суботу вони відпочили за заповіддю. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Першого дня тижня, рано-вранці, вони прийшли до гробниці та принесли пахощі, які приготували. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","І виявили, що камінь від гробниці був відвалений. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Увійшовши, не знайшли тіла Господа Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","І раптом перед розгубленими жінками з’явилися двоє чоловіків у яскравих одежах. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Налякані жінки схилили свої обличчя до землі. Але ті сказали їм: «Чому ви шукаєте Живого серед мертвих? ");
INSERT INTO ukronpu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Немає Його тут: Він воскрес! Згадайте, як Він говорив вам, коли ще був у Галілеї: ");
INSERT INTO ukronpu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","„Син Людський має бути виданий у руки грішників і розіп’ятий, а третього дня воскресне“». ");
INSERT INTO ukronpu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","І вони пригадали собі слова Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Повернувшись від гробниці, розповіли про все одинадцятьом і всім іншим. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","То були Марія Магдалина, Іванна, Марія – мати Якова, та інші жінки, які сказали про це апостолам. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Але ці слова їм здалися нісенітницями, і не повірили їм. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Однак Петро піднявся та побіг до гробниці. Нахилившись, він побачив тільки льняну тканину. І повернувся додому, здивований тим, що сталося. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Того ж дня двоє з них пішли в село, яке знаходилося на відстані шістдесяти стадіїв від Єрусалима й звалося Емаус. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Дорогою вони розмовляли між собою про все, що сталося. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","А коли вони говорили й дискутували, Сам Ісус наблизився та пішов разом із ними. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Але їхні очі були стримані, щоб не впізнали Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ісус спитав їх: ―Про що ви говорите між собою в дорозі? Вони зупинилися, повні смутку; ");
INSERT INTO ukronpu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","і один із них, на ім’я Клеопа, промовив: ―Ти, мабуть, єдиний з прибулих до Єрусалима, хто не знає про те, що сталося в ці дні. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Він спитав: ―Про що саме? Вони відповіли: ―Про те, що сталося з Ісусом із Назарета, Який був сильним пророком у дії та слові перед Богом та всіма людьми. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Як первосвященники та керівники наші видали Його для засудження на смерть і розіп’яли Його. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ми ж сподівалися, що Він Той, Хто має визволити Ізраїль. Але ось уже третій день, як все це сталося. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Крім того, деякі наші жінки здивували нас. Вони на світанку пішли до гробниці ");
INSERT INTO ukronpu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","та, не знайшовши Його тіла, прийшли й розказали, що бачили ангелів, які їм з’явилися й сказали, що Він живий. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Тоді деякі з нас пішли до гробниці й знайшли все так, як казали жінки, але Його не бачили. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Він сказав їм: ―О нерозумні та повільні серцем, щоб повірити в усе, що казали пророки! ");
INSERT INTO ukronpu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Хіба Христос не мав постраждати та увійти у славу Свою? ");
INSERT INTO ukronpu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","І, почавши від Мойсея та всіх пророків, пояснив їм, що написано в усіх Писаннях про Нього. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Коли наблизились до села, куди йшли, Він удав, що бажає йти далі. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Але вони просили Його, кажучи: ―Залишайся з нами, бо вже вечоріє і день закінчується. Він увійшов у дім та залишився з ними. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Коли сиділи за столом, Він узяв хліб, благословив його, розламав і дав їм. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Тоді їхні очі відкрилися, і вони впізнали Його, але Він став для них невидимий. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","І вони казали один до одного: «Чи не палали в нас серця, коли Він говорив із нами в дорозі та відкривав нам Писання?» ");
INSERT INTO ukronpu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","І тієї ж миті вони встали й повернулися в Єрусалим. Там вони знайшли зібраних разом одинадцятьох і тих, що були з ними, ");
INSERT INTO ukronpu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","які говорили, що Господь дійсно воскрес та з’явився Симонові. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Потім ці двоє розповіли, що сталося в дорозі і як вони впізнали Ісуса, коли Він розламав хліб. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Коли вони ще говорили, Сам Ісус з’явився посеред них та промовив: «Мир вам!» ");
INSERT INTO ukronpu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Вони завмерли та злякалися, бо подумали, що бачать духа. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Він же сказав їм: «Чому ви налякані й чому постають сумніви у ваших серцях? ");
INSERT INTO ukronpu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Погляньте на руки та на ноги Мої. Це ж Я Сам! Доторкніться до Мене й подивіться: дух не має тіла та кісток, а Я, як бачите, маю!» ");
INSERT INTO ukronpu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Кажучи це, показав їм Свої руки та ноги. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Коли ж вони від радості та здивування ще не вірили, Він сказав: «Чи маєте тут щось поїсти?» ");
INSERT INTO ukronpu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Вони дали Йому шматок запеченої риби та мед у сотах. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Він узяв та їв перед ними. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Потім сказав їм: «Це слова Мої, які Я говорив вам, коли ще був із вами: має здійснитися все, що написано про Мене в Законі Мойсея, у Пророків та в Псалмах». ");
INSERT INTO ukronpu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Тоді відкрив їм розум, щоб зрозуміли Писання. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Та промовив: «Так написано, що Христос має постраждати та третього дня воскреснути з мертвих. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","І в Його ім’я буде проповідуватися покаяння та прощення гріхів усім народам, почавши від Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ви свідки цьому. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","І ось Я надішлю вам обітницю Мого Отця. Ви ж залишайтесь у місті, доки не будете зодягнені силою з висоти!» ");
INSERT INTO ukronpu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Потім вивів їх із міста до Віфанії та, піднявши руки Свої, благословив їх. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Благословляючи їх, Він почав віддалятися від них та возноситися на небо. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Вони ж, вклонившись Йому, з великою радістю повернулися в Єрусалим. ");
INSERT INTO ukronpu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","І весь час перебували в Храмі, благословляючи Бога. Амінь.");
INSERT INTO ukronpu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","На початку було Слово, і Слово було з Богом, і Слово було Бог. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Воно на початку було з Богом. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Усе через Нього було створено, і нічого не було створено без Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","У Ньому було життя, і життя було світлом для людей. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Світло світить у темряві, і темрява не здолала його. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","З’явився чоловік, надісланий Богом; його ім’я – Іван. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Він прийшов як свідок, щоб свідчити про світло, щоб усі повірили через нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Не він був світлом, але він прийшов, щоб свідчити про світло. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","То було справжнє світло, яке освітлює кожну людину, приходячи у світ. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Воно було у світі, і світ через Нього був створений, але світ Його не впізнав. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Він прийшов до своїх, та свої не прийняли Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","А всім, хто прийняв Його й повірив у Його ім’я, Він дав право стати дітьми Божими, ");
INSERT INTO ukronpu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","народженими не від крові, не через тілесне бажання й не через бажання чоловіка, а народженими від Бога. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Слово стало людиною й оселилося серед нас. І ми бачили Його славу, славу як Єдинородного Сина від Отця, повного благодаті та істини. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Іван свідчив про Нього, проголошуючи: «Він Той, про Кого я казав: „Той, Хто йде після мене, величніший за мене, бо Він був переді мною“». ");
INSERT INTO ukronpu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Адже з Його повноти ми всі отримали благодать за благодаттю. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Бо Закон був даний через Мойсея, а благодать та істина прийшли через Ісуса Христа. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Бога ніхто не бачив, тільки Єдинородний Бог, Який у лоні Отця, – Він явив Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","І ось свідчення Івана, коли юдейські керівники з Єрусалима надіслали до нього священників та левітів запитати Його: ―Ти хто? ");
INSERT INTO ukronpu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Він визнав, не заперечив, а визнав: ―Я не Христос! ");
INSERT INTO ukronpu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Вони запитали його: ―Тоді хто ти? Ілля? Він відповів: ―Ні! ―То ти Пророк? Він відповів: ―Ні! ");
INSERT INTO ukronpu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Вони ж запитали: ―Тоді хто ж ти? Щоб ми дали відповідь тим, хто надіслав нас. Що ти кажеш про себе? ");
INSERT INTO ukronpu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Він відповів, як сказав пророк Ісая: ―Я – «голос, який кличе в пустелі: „Приготуйте дорогу Господеві“». ");
INSERT INTO ukronpu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Посланці ж були із фарисеїв. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Вони запитали його: ―Якщо ти не Христос, не Ілля й не Пророк, чому ж ти хрестиш? ");
INSERT INTO ukronpu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Іван відповів їм: ―Я хрещу водою, але серед вас стоїть Той, Кого ви не знаєте. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Він іде після мене, і я не достойний розв’язати ремінці Його сандалій. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Це сталося у Віфанії, біля Йордану, де Іван хрестив. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Наступного дня Іван побачив Ісуса, Який ішов до нього, і сказав: «Ось Агнець Божий, Який бере на Себе гріх світу. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Це Той, про Кого я казав: „Після мене йде Чоловік, величніший за мене, бо Він був переді мною“. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Я сам не знав Його, але я прийшов хрестити водою для того, щоб Він був об’явлений Ізраїлеві». ");
INSERT INTO ukronpu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Іван свідчив кажучи: «Я бачив Духа, Який сходив, як голуб, із неба й залишився на Ньому. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","І я б не впізнав Його, але Той, Хто надіслав мене хрестити водою, сказав мені: „Над ким побачиш Духа, Який сходить та залишається, – Він є Той, Хто хрестить Святим Духом“. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Я бачив це та засвідчую, що Він – Син Божий». ");
INSERT INTO ukronpu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Наступного дня Іван знову стояв із двома своїми учнями. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Побачивши Ісуса, Який ішов повз них, сказав: «Ось Агнець Божий!» ");
INSERT INTO ukronpu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Обидва його учні, почувши ці слова, пішли за Ісусом. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Обернувшись, Ісус побачив, що вони йдуть за Ним, і спитав їх: ―Чого ви шукаєте? Вони відповіли: ―Равві (що в перекладі означає «Учителю»), де Ти живеш? ");
INSERT INTO ukronpu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Він відповів: ―Ідіть та побачите. Вони пішли та побачили, де Він живе, і залишились у Нього того дня. Це було близько десятої години. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Одним із цих двох, що чули слова Івана та пішли за Ним, був Андрій, брат Симона Петра. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Він першим розшукав свого брата Симона й сказав йому: «Ми знайшли Месію» (що в перекладі означає «Христос»). ");
INSERT INTO ukronpu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Він привів його до Ісуса. Подивившись на Нього, Ісус сказав: «Ти Симон, син Йони, будеш називатися Кифа» (що в перекладі означає «Петро»). ");
INSERT INTO ukronpu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Наступного дня Ісус вирішив піти до Галілеї. Він знайшов Филипа та сказав йому: «Іди за Мною!» ");
INSERT INTO ukronpu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Филип був із Віфсаїди, з того ж міста, що й Андрій та Петро. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Филип знайшов Нафанаїла й сказав йому: ―Ми знайшли Того, про Кого писали Мойсей у Законі та Пророки. Це Ісус, син Йосифа з Назарета. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Нафанаїл сказав: ―Хіба з Назарета може бути щось добре? Филип відповів: ―Іди та подивись! ");
INSERT INTO ukronpu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Коли Ісус побачив Нафанаїла, що йшов до Нього, то сказав про нього: ―Ось істинний ізраїльтянин, у якому немає лукавства. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Нафанаїл запитав: ―Звідки Ти мене знаєш? Ісус відповів йому: ―Ще перед тим, як Филип покликав тебе, Я бачив тебе під смоковницею. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Нафанаїл відповів: ―Равві, Ти Син Божий, Ти Цар Ізраїлю! ");
INSERT INTO ukronpu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ісус сказав у відповідь: ―Ти повірив, тому що Я сказав, що бачив тебе під смоковницею? Ти більше від цього побачиш. ");
INSERT INTO ukronpu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Потім сказав: ―Істинно кажу вам: «ви побачите відкриті небеса й Божих ангелів, які підіймаються та опускаються»на Сина Людського. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Третього дня було весілля в Кані Галілейській, і мати Ісуса була там. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ісус зі Своїми учнями теж був покликаний на весілля. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Коли закінчилося вино, мати Ісуса сказала Йому: ―Вони не мають вина. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ісус відповів їй: ―Жінко, що Мені й тобі до цього? Ще не настав Мій час. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Його мати сказала слугам: «Робіть те, що Він вам скаже!» ");
INSERT INTO ukronpu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","За юдейським звичаєм очищення там стояло шість кам’яних посудин для води. Кожна з них містила дві або три міри. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ісус сказав їм: «Наповніть посудини водою!» І вони наповнили їх по вінця. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Потім сказав їм: «А тепер зачерпніть та віднесіть управителю свята!» Вони зробили це. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Коли управитель скуштував води, яка стала вином, – а він не знав, звідки воно, лише слуги, які зачерпнули воду, знали, – то покликав нареченого ");
INSERT INTO ukronpu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","й сказав йому: «Кожна людина спочатку подає хороше вино, а коли гості нап’ються, подає гірше. Ти ж тримав хороше вино дотепер». ");
INSERT INTO ukronpu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Так Ісус у Кані Галілейській поклав початок знаменням, через які показав Свою славу, і Його учні повірили в Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Після цього Ісус разом із матір’ю, братами та учнями пішов до Капернаума й залишився там декілька днів. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Наближалася юдейська Пасха, і Ісус піднявся до Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","У Храмі Він знайшов тих, хто продавав волів, овець та голубів. Біля столів стояли ті, хто міняв гроші. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Тоді, зробивши бича з мотузок, Він повиганяв із Храму їх усіх разом з їхніми вівцями та волами. Також Він розкидав гроші та перевернув столи міняльників. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","А тим, хто продавав голубів, сказав: «Заберіть це звідси! Не робіть із Дому Мого Отця дім торгівлі!» ");
INSERT INTO ukronpu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Його учні згадали, що записано в Писанні: «Ревність до Дому Твого поглине Мене». ");
INSERT INTO ukronpu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Тоді юдеї запитали Ісуса: ―Яке знамення Ти покажеш нам як доказ того, що маєш право це робити? ");
INSERT INTO ukronpu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ісус відповів: ―Зруйнуйте цей Храм, і за три дні Я відбудую його. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Юдеї сказали: ―Цей Храм будувався сорок шість років, а Ти за три дні відбудуєш його? ");
INSERT INTO ukronpu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Але Він казав це про Храм Свого тіла. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Після того, як Він воскрес із мертвих, Його учні згадали ці слова й повірили Писанню та словам Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Коли Він був у Єрусалимі на святі Пасхи, багато хто повірив у Його ім’я, побачивши знамення, які Він творив. ");
INSERT INTO ukronpu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Але Ісус не звірявся їм, бо Сам знав усе ");
INSERT INTO ukronpu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","й не мав потреби, щоб хтось свідчив про людину, адже Сам знав, що було в людині. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Серед фарисеїв був чоловік, на ім’я Никодим, один з юдейських керівників. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Він прийшов до Ісуса вночі та сказав: ―Равві, ми знаємо, що Ти Вчитель, Який прийшов від Бога, бо ніхто не може робити таких знамень, які Ти робиш, якщо Бог не з ним. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ісус відповів: ―Істинно кажу тобі: якщо хтось не народиться знову,не може побачити Царства Божого. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Никодим сказав Йому: ―Як може людина народитися знову, якщо вона вже стара? Адже не може вона знов увійти в утробу своєї матері та народитися? ");
INSERT INTO ukronpu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ісус відповів: ―Істинно кажу тобі: якщо хтось не народиться від води та Духа, не може увійти до Царства Божого. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Те, що народжене від плоті, є плоттю, а народжене від Духа є духом. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Не дивуйся, що Я сказав тобі: вам треба народитися знову. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Вітер віє, де хоче, ти чуєш його, але не бачиш, звідки він приходить і куди йде. Так само і з кожним, хто народжений від Духа. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Никодим у відповідь сказав: ―Як це може статися? ");
INSERT INTO ukronpu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ісус відповів: ―Ти – учитель Ізраїля й не знаєш цього? ");
INSERT INTO ukronpu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Істинно кажу тобі: ми говоримо про те, що знаємо, свідчимо про те, що бачили, але ви не приймаєте нашого свідчення. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Якщо Я сказав вам про земні речі, і ви не повірили, як же ви повірите, якщо Я скажу про небесне? ");
INSERT INTO ukronpu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ніхто не піднімався на небо, окрім Того, Хто зійшов із неба, – Сина Людського, Який є на небі. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","І як Мойсей підняв змія в пустелі,так має бути піднятий і Син Людський, ");
INSERT INTO ukronpu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","щоб кожний, хто повірить у Нього, мав життя вічне. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Бо так полюбив Бог світ, що віддав Свого Єдинородного Сина, щоб кожний, хто вірує в Нього, не загинув, але мав життя вічне. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Адже Бог послав Сина у світ не для того, щоб засудити світ, але для того, щоб спасти світ через Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Хто вірить у Нього, не буде засуджений, а хто не вірить, той уже засуджений, бо він не повірив в ім’я Єдинородного Сина Божого. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","У цьому полягає суд: світло прийшло у світ, але люди полюбили більше темряву, ніж світло, бо їхні вчинки були погані. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Адже кожний, хто чинить зло, ненавидить світло й не приходить до світла, щоб не викрились його вчинки. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","А хто живе в істині, той приходить до світла, щоб розкрилися його вчинки, бо були зроблені в Бозі. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Після цього Ісус разом зі Своїми учнями пішов до землі юдейської. Він перебував там деякий час та хрестив. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Іван також продовжував хрестити в Еноні, що біля Салима, бо там було багато води. Люди продовжували приходити до нього, і він хрестив їх. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","На той час Іван ще не був вкинутий до в’язниці. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Між деякими учнями Івана та одним юдеєм виникла суперечка щодо очищення. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Вони прийшли до Івана й сказали йому: ―Равві, ось Той, Хто був із тобою на тому боці Йордану й про Кого ти свідчив, зараз Сам хрестить, і всі йдуть до Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Іван сказав у відповідь: ―Не може людина прийняти нічого, якщо не дано їй з неба. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ви самі свідки того, що я казав: «Я не Христос, я посланий перед Ним». ");
INSERT INTO ukronpu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Хто має наречену, той є нареченим. Друг нареченого стоїть, слухає та радіє від голосу нареченого. Отже, у цьому й моя радість, і зараз вона сповнилась. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Йому належить зростати, а мені меншати. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Той, Хто приходить згори, величніший за всіх. Земний же належить до землі й говорить по-земному. Той, Хто приходить із неба, величніший за всіх. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Він свідчить про все, що бачив та чув, але ніхто не приймає Його свідчення. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Той, хто приймає Його свідчення, той засвідчив, що Бог істинний. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Адже Той, Кого надіслав Бог, говорить слова Божі, тому що Бог дає Йому Духа без міри. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Отець любить Сина й усе віддав у Його руки. ");
INSERT INTO ukronpu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Хто вірить у Сина, той має життя вічне, а хто не вірить у Сина, той не побачить життя, і гнів Божий залишається на ньому. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Коли Ісус дізнався, що фарисеї почули, начебто Він хрестить більше учнів, ніж Іван, – ");
INSERT INTO ukronpu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","хоча сам Ісус не хрестив, а хрестили Його учні, – ");
INSERT INTO ukronpu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","то залишив Юдею й знову пішов до Галілеї. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Йому треба було пройти через Самарію, ");
INSERT INTO ukronpu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","і Він прийшов у самарянське місто Сихар, неподалік від землі, яку Яків дав своєму синові Йосифові. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Там була криниця Якова, і Ісус, утомившись від дороги, сів відпочити біля криниці. Було десь близько шостої години. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Одна жінка з Самарії прийшла по воду. Ісус сказав їй: ―Дай Мені напитися! ");
INSERT INTO ukronpu_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Його учні пішли до міста купити їжі.) ");
INSERT INTO ukronpu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Жінка-самарянка сказала Йому: ―Як Ти, юдей, просиш пити в мене – жінки-самарянки? (Річ у тім, що юдеї не спілкуються з самарянами.) ");
INSERT INTO ukronpu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ісус відповів їй: ―Якби ти знала про дар Божий і Хто Той, Що каже тобі: «Дай Мені напитися!», ти б сама просила в Нього, і Він дав би тобі живої води. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Жінка сказала: ―Господи, Ти навіть відра не маєш, а криниця глибока, звідки ж у Тебе жива вода? ");
INSERT INTO ukronpu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Невже Ти більший від нашого батька Якова, який дав нам криницю і сам із неї пив, а також його сини та його стада? ");
INSERT INTO ukronpu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ісус відповів: ―Кожен, хто п’є цю воду, знову захоче пити. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Але той, хто п’є воду, яку Я йому дам, повік не відчуватиме спраги. Вода, яку Я йому дам, стане в ньому джерелом води, що тече в життя вічне. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Жінка сказала Йому: ―Господи, дай мені такої води, щоб я більше не хотіла пити й не приходила сюди черпати. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Він сказав їй: ―Іди, поклич свого чоловіка та приходь сюди. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Вона відповіла: ―У мене немає чоловіка. Ісус сказав: ―Ти добре відповіла, що не маєш чоловіка. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Адже в тебе було п’ять чоловіків, і той, з ким ти зараз живеш, тобі не чоловік. Тут ти сказала правду. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Жінка сказала Йому: ―Господи, я бачу, що Ти пророк. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Наші батьки поклонялися на цій горі, а ви, юдеї, кажете, що в Єрусалимі те місце, де потрібно Йому поклонятися. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ісус відповів: ―Повір Мені, жінко, прийде час, коли не будете поклонятися Отцеві ні на цій горі, ні в Єрусалимі. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ви, самаряни, поклоняєтесь тому, чого не знаєте, ми ж знаємо, Кому поклоняємося, бо спасіння – від юдеїв. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Але прийде час, і вже прийшов, коли справжні поклонники будуть поклонятися Отцеві в Дусі та істині, бо таких поклонників шукає Собі Отець. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Бог є Дух, і хто поклоняється Йому, той повинен поклонятися в Дусі та істині. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Жінка сказала Йому: ―Я знаю, що має прийти Месія, Якого називають Христос. Коли Він прийде, Він нам усе пояснить. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ісус сказав їй: ―Це Я, Той, Хто говорить із тобою. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","У той час повернулися Його учні й дивувалися, що Він говорить із жінкою. Однак ніхто не запитав: «Чого хочеш?» або: «Чому розмовляєш із нею?» ");
INSERT INTO ukronpu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Тоді жінка залишила своє відро, повернулася до міста та сказала людям: ");
INSERT INTO ukronpu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ходіть та побачите Чоловіка, Який сказав мені все, що я зробила! Чи Він часом не Христос?» ");
INSERT INTO ukronpu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Тоді люди вийшли з міста та прийшли до Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","У цей час Його учні просили Його: ―Равві, поїж! ");
INSERT INTO ukronpu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Але Він сказав їм: ―Я маю їсти іншу їжу, про яку ви не знаєте. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Тоді учні почали говорити один до одного: «Чи не приніс Йому хтось їсти?» ");
INSERT INTO ukronpu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ісус сказав їм: ―Моя їжа в тому, щоб чинити волю Того, Хто надіслав Мене, і звершити Його справу. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Хіба ви не говорите: «Ще чотири місяці, і будуть жнива?» Отже, Я кажу вам: підійміть ваші очі й подивіться на поля, бо вони вже білі, готові для жнив. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Жнець отримує свою винагороду. Він збирає врожай для вічного життя, щоб раділи разом – той, хто сіє, і той, хто жне. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","У цьому справджується слово: один сіє, а інший жне. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Я надіслав вас жати не те, над чим ви трудилися. Інші трудилися, а ви їхню працю пожинаєте. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Багато самарян із того міста увірувало в Ісуса через слова, засвідчені жінкою: «Він сказав мені все, що я зробила». ");
INSERT INTO ukronpu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Коли самаряни прийшли до Нього, то просили Його залишитися з ними, і Він залишався там два дні. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","І ще більше увірувало через Його Слово. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Вони казали жінці: «Ми вже віримо не через твої слова, а тому що ми самі чули й знаємо, що Він дійсно Спаситель світу». ");
INSERT INTO ukronpu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Через два дні Він вирушив звідти до Галілеї. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Адже Ісус Сам свідчив, що пророк на своїй батьківщині пошани не має. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Проте коли Він прибув до Галілеї, галілеяни прийняли Його гостинно, тому що вони були в Єрусалимі на святі Пасхи та бачили все, що Він там зробив. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ісус знов прийшов у Кану Галілейську, де перетворив воду у вино. На той час у Капернаумі син одного придворного був хворий. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Почувши, що Ісус прийшов з Юдеї до Галілеї, він прийшов до Нього й благав, щоб Він прийшов зцілити його сина, який був при смерті. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ісус сказав йому: ―Якщо ви не побачите ознак та чудес, ніколи не повірите! ");
INSERT INTO ukronpu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Придворний відповів Йому: ―Господи, прийди, доки мій син не помер. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ісус відповів йому: ―Іди, твій син буде жити. Чоловік повірив тому, що сказав Ісус, та пішов. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Коли він був іще в дорозі, раби зустріли його й сказали, що його син живий. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Він запитав, о котрій годині йому стало краще, і вони сказали: «Вчора о сьомій годині гарячка залишила його». ");
INSERT INTO ukronpu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Батько зрозумів, що це сталося тоді, коли Ісус сказав: «Твій син буде жити». І повірив він та увесь його дім. ");
INSERT INTO ukronpu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Це було друге знамення, яке зробив Ісус після того, як повернувся з Юдеї в Галілею. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Після цього було юдейське свято, і Ісус пішов до Єрусалима. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","В Єрусалимі, біля Овечих воріт, є купальня, яка єврейською називається Віфезда й має п’ять критих колонад. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Там лежало багато хворих, сліпих, кривих та паралізованих. Вони чекали, коли вода збуриться. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Іноді ангел Господній сходив та збурював воду, і хто перший заходив у воду, зцілювався, хоч би якою була його хвороба. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Був же там чоловік, який хворів уже тридцять вісім років. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ісус, побачивши, що він лежить, і знаючи, що той вже багато часу був хворий, сказав: ―Ти хочеш одужати? ");
INSERT INTO ukronpu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Хворий відповів: ―Господи, я не маю людини, котра б допомогла мені увійти до купальні, коли вода збуриться. Як тільки я дістаюся до води, хтось інший заходить раніше за мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ісус сказав йому: ―Підведися, візьми свою постіль та ходи! ");
INSERT INTO ukronpu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","І відразу чоловік став здоровим, узяв свою постіль та пішов. Тоді була Субота. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Тому юдеї сказали зціленому: ―Сьогодні Субота, і тобі не дозволено нести свою постіль. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Але він відповів їм: ―Той, Хто зцілив мене, сказав мені: «Візьми свою постіль та ходи». ");
INSERT INTO ukronpu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Вони запитали: ―Хто Той Чоловік, Який сказав тобі взяти постіль та йти? ");
INSERT INTO ukronpu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Але зцілений не знав, Хто Це був, адже Ісус зник у натовпі, що був у тому місці. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Згодом Ісус знайшов його в Храмі й сказав йому: ―Ось ти вже здоровий. Не гріши більше, щоб не сталося з тобою чогось гіршого. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Той чоловік пішов та сповістив юдеїв, що це Ісус зцілив його. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Через те, що Ісус зробив це в Суботу, юдеї переслідували Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ісус же сказав їм: «Мій Отець до цього часу працює, і Я теж працюю». ");
INSERT INTO ukronpu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Тоді юдеї ще більше шукали нагоди вбити Ісуса, бо Він не тільки порушував Суботу, але й називав Бога Своїм Отцем, роблячи Себе рівним Богові. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ісус відповів їм: ―Істинно кажу вам: Син нічого не може робити Сам від Себе, доки не побачить Отця, Який робить. Те, що робить Отець, робить і Син так само. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Адже Отець любить Сина й показує Йому все, що робить Сам, і Він покаже Йому справи ще більші за ці, щоб ви дивувалися. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Так само, як Отець воскрешає мертвих і дає їм життя, так і Син дає життя тим, кому хоче. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Навіть більше, Отець нікого не судить, Він увесь суд передав Синові, ");
INSERT INTO ukronpu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","щоб усі шанували Сина, як шанують Отця. Хто не шанує Сина, не шанує й Отця, Який послав Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Істинно кажу вам: хто чує Моє Слово і вірить Тому, Хто надіслав Мене, той має життя вічне й на суд не приходить, а перейшов від смерті до життя. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Істинно кажу вам: приходить час, і вже прийшов, коли мертві почують голос Сина Божого, і ті, хто почує, оживуть. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Адже як Отець має життя в Собі, так дав і Синові мати життя в Собі ");
INSERT INTO ukronpu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Він дав Йому владу судити, тому що Він – Син Людський. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Не дивуйтеся тому, що приходить час, коли всі, хто в могилах, почують Його голос ");
INSERT INTO ukronpu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","і вийдуть із них. Ті, хто робив добро, воскреснуть для життя, а ті, хто робив зло, воскреснуть на суд. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Я нічого не можу робити від Себе. Я суджу, як чую, і Мій суд справедливий, тому що Я прагну сповнити не Свою волю, а волю Того, Хто послав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Якби Я свідчив Сам про Себе, то Моє свідчення не було б правдиве, ");
INSERT INTO ukronpu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","але про Мене свідчить Інший, і Я знаю, що свідчення, яким Він свідчить про Мене, правдиве. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ви посилали до Івана, і він свідчив про істину. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Я ж не потребую свідчення від людини, але кажу вам про це, щоб ви були спасенні. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Іван був світильником, горів та світив, і ви хотіли деякий час радіти при його світлі. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Але є в Мене свідчення більше за свідчення Івана. Бо діла, які Отець доручив Мені звершити і які Я роблю, свідчать про Мене, що Отець послав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","І Отець, Який послав Мене, свідчить про Мене. Ви ніколи не чули Його голосу й не бачили Його обличчя. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ви не маєте Його Слова, яке б у вас перебувало, бо не вірите в Того, Кого Він послав. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ви старанно досліджуєте Писання, сподіваючись через них мати життя вічне, а вони свідчать про Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Однак ви не бажаєте прийти до Мене, щоб мати життя. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Я не приймаю слави від людей, ");
INSERT INTO ukronpu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","але Я знаю вас, що ви не маєте в собі любові до Бога. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Я прийшов в ім’я Мого Отця, і ви не приймаєте Мене. Якщо ж прийде інший у своє ім’я, того приймете. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Як ви можете повірити, коли ви приймаєте славу один від одного, але не шукаєте слави від єдиного Бога? ");
INSERT INTO ukronpu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Не думайте, що Я буду звинувачувати вас перед Отцем. Ваш обвинувач – Мойсей, на якого ви покладаєтесь. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Якби ви вірили Мойсею, то вірили б і Мені, адже він писав про Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Але якщо ви не вірите тому, що він написав, як же ви повірите Моїм словам? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Після цього Ісус відправився на другий бік Галілейського моря, яке зветься Тиверіадським. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","За Ним ішов великий натовп, оскільки бачили знамення, які Він робив, зцілюючи хворих. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ісус піднявся на гору й сів там зі Своїми учнями. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Наближалося юдейське свято Пасхи. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Коли Ісус підняв очі й побачив, що багато людей ішло до Нього, сказав Филипові: ―Де ми купимо хліба, щоб нагодувати цих людей? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Він спитав це, щоб випробувати Филипа, бо Сам вже знав, що буде робити. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Филип відповів: ―Навіть якщо купити хліба на двісті динаріїв, і того не буде достатньо, щоб кожний отримав хоч трохи. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Інший Його учень, Андрій, брат Симона Петра, сказав: ");
INSERT INTO ukronpu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Тут є хлопчик, який має п’ять хлібів з ячмінного борошна та дві рибини. Але що це для такої кількості? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ісус сказав: ―Звеліть людям сісти. У тому місці було багато трави, тож всі посідали на неї (було їх близько п’яти тисяч чоловіків). ");
INSERT INTO ukronpu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ісус узяв хліби та, подякувавши Богові, роздав їх тим, хто сидів. Так само зробив і з рибою. Кожний брав, скільки хотів. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Коли всі наїлися, Він сказав Своїм учням: ―Зберіть те, що залишилося, щоб нічого не пропало. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Вони зібрали та наповнили дванадцять кошиків із залишками з п’яти ячмінних хлібів, які залишилися після тих, що їли. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Коли люди побачили знамення, яке Він зробив, почали казати: «Він насправді Пророк, Який мав прийти у світ». ");
INSERT INTO ukronpu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ісус же, зрозумівши, що вони мають намір прийти і взяти Його силоміць, щоб зробити царем, знову пішов на гору один. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Коли настав вечір, учні Ісуса спустилися до моря ");
INSERT INTO ukronpu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","й, увійшовши в човен, попливли через море до Капернаума. Було вже темно, а Ісус усе ще не приходив до них. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Тим часом море розхвилювалося, бо подув сильний вітер. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Вони вже відпливли на двадцять п’ять або тридцять стадіїв, коли побачили Ісуса, Який ішов по воді та наближався до човна. Учні злякалися. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Але Він заговорив до них: «Це Я! Не бійтеся!» ");
INSERT INTO ukronpu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Вони хотіли взяти Його в човен; і човен відразу пристав до берега, до якого прямували. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Наступного дня люди, які стояли на іншому березі моря, побачили, що там не було іншого човна, окрім одного, і що Ісус не сідав разом зі Своїми учнями в човен, а Його учні відпливли самі. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Тим часом кілька човнів із Тиверіади припливло та пристало поблизу того міста, де вони їли хліб, після того, як Господь подякував Богові. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Коли люди побачили, що ні Ісуса, ні Його учнів немає в тому місці, вони сіли в човни та попливли до Капернаума шукати Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Коли знайшли Його на іншому березі, запитали: ―Равві, коли Ти сюди прийшов? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ісус відповів їм: ―Істинно кажу вам: ви шукаєте Мене не тому, що побачили знамення, а тому, що їли хліб та наїлися. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Працюйте не за їжу, що проходить, а за їжу, що залишається для життя вічного, яке дасть вам Син Людський. Бо Його засвідчив Бог Отець. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Вони запитали: ―Що нам робити, щоб чинити діла Божі? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ісус відповів їм: ―Діло Боже – це вірити в Того, Кого Він послав. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Вони запитали: ―Яке знамення Ти міг би зробити, щоб ми побачили та повірили в Тебе? Що Ти зробиш? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Наші батьки їли манну в пустелі, як написано: «Дав їм їсти хліб із неба». ");
INSERT INTO ukronpu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ісус сказав їм: ―Істинно кажу вам: це не Мойсей дав вам хліб із неба, а Отець Мій дає вам істинний хліб із неба. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Тому що хліб Божий – це Той, Хто зійшов із неба й дає життя світові. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Вони сказали: ―Господи, давай нам завжди цей хліб! ");
INSERT INTO ukronpu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ісус сказав: ―Я – хліб життя! Кожний, хто приходить до Мене, ніколи не зголодніє, і хто вірить у Мене, той ніколи не відчуватиме спраги. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Але як Я вам казав, ви бачили Мене й не вірите. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Усі, кого дав Мені Отець, прийдуть до Мене, і того, хто прийде до Мене, Я не вижену геть. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Бо Я прийшов із неба для того, щоб виконати не Мою волю, а волю Того, Хто надіслав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","А це воля Того, Хто надіслав Мене: щоб Я не втратив нікого з тих, кого Він Мені дав, але щоб воскресив їх останнього дня. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Воля Мого Отця полягає в тому, щоб кожний, хто бачить Сина та вірить у Нього, мав життя вічне, і Я воскрешу його останнього дня. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Тоді юдеї почали нарікати, бо Він сказав: «Я – хліб, який зійшов із неба». ");
INSERT INTO ukronpu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Вони казали: ―Хіба Він не Ісус, син Йосифа? Чи не знаємо ми Його батька й матері? Як же Він тепер каже: «Я прийшов із неба»? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ісус сказав їм: ―Не нарікайте між собою! ");
INSERT INTO ukronpu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ніхто не може прийти до Мене, якщо Отець, Який послав Мене, не притягне його, і Я воскрешу його останнього дня. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","У пророків написано: «Усі будуть навчені Богом».Кожен, хто почув Отця та навчився в Нього, приходить до Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Бо ніхто не бачив Отця, окрім Того, Хто від Бога, тільки Він бачив Отця. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Істинно кажу вам: хто вірить у Мене, той має життя вічне. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Я – хліб життя! ");
INSERT INTO ukronpu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ваші батьки їли манну в пустелі й померли. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Це ж хліб, який зійшов із неба, щоб той, хто їсть його, не помер. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Я – хліб життя, який зійшов із неба. Хто буде їсти цей хліб, той житиме вічно. Хліб, який Я дам, це Моє тіло, яке віддам заради життя світу. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Тоді юдеї почали сперечатися між собою, кажучи: ―Як Він може дати нам Своє тіло, щоб ми його їли? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ісус сказав їм: ―Істинно кажу вам: якщо не будете їсти тіла Сина Людського й не будете пити Його крові, не будете мати життя вічного в собі. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Хто їсть Моє тіло й п’є Мою кров, має життя вічне, і Я воскрешу його останнього дня. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Бо тіло Моє – істинна їжа і кров Моя – істинний напій. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Хто їсть Моє тіло й п’є Мою кров, перебуває в Мені, і Я перебуваю в ньому. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Як живий Отець послав Мене і як Я живу через Отця, так і той, хто їсть Мене, буде жити через Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Це є хліб, який зійшов із неба. Він не такий, як той, що їли ваші батьки та померли. Хто їсть цей хліб, той житиме вічно. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ісус сказав це, коли навчав у синагозі в Капернаумі. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Чимало Його учнів, почувши це, сказали: ―Ці слова важкі для сприйняття. Хто може їх слухати? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ісус, знаючи в Собі, що Його учні нарікають через це, сказав їм: ―Це вас ображає? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","А якщо побачите Сина Людського, Котрий возноситься туди, де був раніше? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Дух дає життя, людині це не під силу. Слова, які Я вам казав, – це Дух та життя. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Але між вами є деякі, що не вірять. (Ісус казав так, бо від початку знав, хто не вірить і хто зрадить Його.) ");
INSERT INTO ukronpu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Він продовжив: ―Тому Я кажу вам: ніхто не може прийти до Мене, якщо це не дано йому Отцем. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Відтоді чимало Його учнів залишили Його й більше не ходили з Ним. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Тоді Ісус запитав дванадцятьох: ―Ви не бажаєте піти? ");
INSERT INTO ukronpu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Симон Петро відповів: ―Господи, до кого нам піти? Ти маєш слова вічного життя. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ми віримо та знаємо, що Ти – Святий Божий! ");
INSERT INTO ukronpu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ісус сказав: ―Чи не Я обрав вас, дванадцятьох? І все ж один із вас – диявол. ");
INSERT INTO ukronpu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Він говорив так про Юду, сина Симона Іскаріота, який, хоч і був одним із дванадцятьох, однак мав зрадити Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Після цього Ісус ходив по Галілеї. В Юдею Він не йшов, адже юдеї хотіли вбити Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Коли наближалося юдейське свято Кущів, ");
INSERT INTO ukronpu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","брати Ісуса сказали Йому: ―Іди звідси в Юдею, щоб і Твої учні побачили діла, які Ти робиш. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Адже ніхто не робить своїх вчинків таємно, якщо шукає визнання. Якщо Ти робиш це, покажи Себе світові! ");
INSERT INTO ukronpu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Бо навіть Його брати не вірили в Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Тоді Ісус сказав їм: ―Мій час ще не настав, але для вас час завжди готовий. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Світ не може ненавидіти вас, Мене ж ненавидить, бо Я свідчу про те, що його діла лихі. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ви йдіть на свято; Я ж поки не піду на це свято, бо Мій час ще не настав. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Сказавши це, Ісус залишився в Галілеї. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Та коли Його брати пішли на свято, Він теж пішов, але не відкрито, а таємно. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","На святі юдеї шукали Його й казали: «Де Він?» ");
INSERT INTO ukronpu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","У народі було багато чуток про Ісуса. Деякі казали, що Він хороший, а інші – що Він обманює людей. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Однак відкрито ніхто про Нього не говорив через страх перед юдеями. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Перша частина свята вже пройшла, коли Ісус прийшов у Храм і почав навчати. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Юдеї дивувались та казали: ―Звідки Він стільки знає, адже ніколи не навчався? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ісус відповів їм: ―Те, чого Я навчаю, не від Мене, а від Того, Хто надіслав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Якщо хтось хоче чинити волю Божу, то дізнається: від Бога Моє вчення чи Я говорю від Себе. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Хто говорить від Себе, той шукає славу самому собі, а Хто шукає славу Тому, Хто послав Його, той правдивий, і немає в ньому неправди. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Хіба Мойсей не дав вам Закон? Однак ніхто з вас не дотримується Закону. Чому ви хочете вбити Мене? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Натовп відповів: ―Ти одержимий демоном! Хто хоче Тебе вбити? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ісус сказав їм у відповідь: ―Я вчинив одне чудо, і ви всі дивуєтеся. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Мойсей дав вам обрізання (хоча обрізання не від Мойсея, а від праотців), і ви обрізаєте дітей у Суботу. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Якщо чоловік може бути обрізаний у Суботу, щоб не був порушений Закон Мойсея, то чому ви гніваєтесь на Мене за те, що Я повністю зцілив чоловіка в Суботу? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Не судіть із вигляду, а судіть справедливим судом. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Тоді деякі мешканці Єрусалима почали запитувати: ―Чи це не Той, Кого вони хочуть вбити? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ось Він говорить прямо, і ніхто Йому нічого не каже. Можливо, керівники справді дізналися, що Він Христос? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Але ми знаємо, звідки Він, а коли прийде Христос, то ніхто не буде знати, звідки Він. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Тоді Ісус, навчаючи в Храмі, голосно сказав: ―Ви Мене знаєте? І навіть знаєте, звідки Я? Адже Я не прийшов від Себе. Той, Хто послав Мене, правдивий, але ви Його не знаєте. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Я Його знаю, бо Я від Нього, і Він Мене послав. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Вони намагалися схопити Ісуса, але ніхто не наклав на Нього рук, тому що Його час ще не настав. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Багато людей з натовпу увірували в Нього й казали: ―Хіба коли прийде Христос, то зробить ще більші знамення, ніж зробив Цей Чоловік? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Чутки про Нього дійшли до фарисеїв, тож вони та первосвященники послали слуг, щоб схопити Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ісус сказав їм: ―Ще трохи часу буду з вами та повернуся до Того, Хто послав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ви будете шукати Мене, але не знайдете. І туди, де Я буду, ви не зможете прийти. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Тоді юдеї казали між собою: ―Куди це Він збирається піти, що ми не знайдемо Його? Може, Він збирається піти до розсіяних серед греків і навчати греків? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Що то за слово, яке Він сказав: «Ви будете шукати Мене, але не знайдете» і «Туди, де Я буду, ви не зможете прийти»? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","В останній та головний день свята Ісус піднявся та голосно промовив: ―Якщо хтось хоче пити, нехай приходить до Мене і п’є! ");
INSERT INTO ukronpu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Хто вірить у Мене, як каже Писання, у того з серця потечуть ріки живої води. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Це Він казав про Духа, Якого мали прийняти ті, хто повірив у Нього. Адже Дух ще не був дарований, бо Ісус ще не був прославлений. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Декотрі люди з натовпу, почувши слова Ісуса, сказали: ―Він дійсно Пророк! ");
INSERT INTO ukronpu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Інші казали: ―Він – Христос! А ще інші казали: ―Хіба Христос прийде з Галілеї? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Чи Писання не каже, що Христос прийде з роду Давида, з Віфлеєма, із села, звідки був Давид? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Тож через Нього сталося в народі розділення. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Дехто з них хотів схопити Його, але ніхто не наклав на Нього рук. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Коли слуги повернулися до фарисеїв та первосвященників, ті запитали їх: ―Чому ви не привели Його? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Слуги відповіли: ―Ще ніхто не говорив так, як Цей Чоловік! ");
INSERT INTO ukronpu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Фарисеї запитали: ―Невже Він вас обманув? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Хіба хоч хтось із керівників або фарисеїв повірив у Нього? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","А народ, який не знає Закону, – проклятий! ");
INSERT INTO ukronpu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Никодим, який був одним із них і раніше приходив до Ісуса, сказав: ");
INSERT INTO ukronpu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Хіба наш Закон засуджує людину, не вислухавши її спочатку й не дізнавшись, що вона робить? ");
INSERT INTO ukronpu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Вони відповіли: ―Ти теж із Галілеї? Досліди Писання й побачиш, що Пророк не приходить із Галілеї. ");
INSERT INTO ukronpu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","І розійшлися кожен до свого дому. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ісус же пішов на Оливну гору. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Рано-вранці Він знову прийшов у Храм, і всі люди посходилися до Нього. Він сів і почав їх навчати. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Книжники та фарисеї привели жінку, яку спіймали під час перелюбу. Її поставили перед народом ");
INSERT INTO ukronpu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","і сказали Ісусові: ―Учителю, ця жінка була схоплена на перелюбі. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Мойсей у Законі звелів нам побивати таких камінням. А Ти що скажеш? ");
INSERT INTO ukronpu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Вони запитали це, щоб спіймати Його й мати підставу звинуватити Його. Але Ісус, схилившись додолу, писав пальцем по землі. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Оскільки вони продовжували Його запитувати, Він піднявся й сказав: ―Хто з вас без гріха, нехай перший кине в неї камінь! ");
INSERT INTO ukronpu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","І знов, схилившись, писав по землі. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Почувши це, вони почали по одному відходити, починаючи від старших і до останніх. Залишилися тільки Ісус та жінка, яка стояла посередині. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ісус, підвівшись і не побачивши нікого, лише саму жінку, сказав їй: ―Жінко, де ті, хто обвинувачував тебе? Ніхто тебе не осудив? ");
INSERT INTO ukronpu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Вона відповіла: ―Ніхто, Господи! Ісус сказав їй: ―І Я не осуджую тебе. Іди й більше не гріши! ");
INSERT INTO ukronpu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ісус знову заговорив із ними: ―Я – світло світу. Хто слідує за Мною, той не ходитиме в темряві, але матиме світло життя. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Фарисеї сказали Йому: ―Ти свідчиш Сам про Себе, тому Твоє свідчення неправдиве. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ісус відповів: ―Навіть якщо Я свідчу Сам про Себе, Моє свідчення правдиве, тому що Я знаю, звідки Я прийшов і куди Я йду. Ви ж не знаєте, звідки Я прийшов і куди йду. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ви судите за людськими мірками, Я ж нікого не суджу. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","А якщо Я й суджу, Мій суд правдивий, тому що Я не Один, зі Мною Отець, Який послав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","У вашому Законі написано, що свідчення двох людей – істинне. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Я Сам свідчу про Себе, і про Мене свідчить Отець, Який послав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Тоді вони запитали: ―Де ж Твій Отець? Ісус відповів: ―Ви не знаєте ні Мене, ні Мого Отця. Якби ви знали Мене, ви знали б і Мого Отця. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ці слова Він казав, коли навчав у Храмі, біля скарбниці. І ніхто не схопив Його, адже не настав ще Його час. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ісус сказав їм ще раз: ―Я відхожу, і ви будете шукати Мене, і помрете у своєму гріху. Куди Я йду, ви не зможете прийти. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Тоді юдеї почали говорити: ―Чи не вб’є Він Себе, бо каже: «Туди, куди Я йду, ви не можете прийти»? ");
INSERT INTO ukronpu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Він казав їм: ―Ви – знизу, а Я – згори. Ви з цього світу, а Я не з цього світу. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Тому Я сказав вам, що ви помрете у ваших гріхах. Якщо не повірите, що Я є,то помрете у ваших гріхах. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Вони запитали: ―Хто Ти? Ісус відповів їм: ―Той, про Кого від початку казав. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Я маю багато про вас сказати й судити, але Той, Хто послав Мене, правдивий, і те, що Я чув від Нього, Я говорю світові. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Вони не зрозуміли, що Він говорить їм про Отця. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Тоді Ісус сказав їм: ―Коли ви піднімете Сина Людського, то зрозумієте, що Я є і що Я нічого не роблю від Себе, а говорю, як Мене навчив Отець. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Той, Хто послав Мене, є зі Мною; Він не залишає Мене Самого, бо Я завжди роблю те, що Йому до вподоби. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Коли Він це казав, багато хто повірив у Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ісус сказав юдеям, які повірили в Нього: ―Якщо ви будете перебувати в Моєму Слові, ви дійсно Мої учні. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ви пізнаєте істину, і істина визволить вас. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Вони відповіли Йому: ―Ми нащадки Авраама й ніколи не були нічиїми рабами! Як Ти кажеш: «Звільнить вас»? ");
INSERT INTO ukronpu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ісус сказав: ―Істинно кажу вам: кожен, хто грішить, є рабом гріха. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Раб не залишається в домі навіки, а Син залишається навіки. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Тому якщо Син звільнить вас, справді будете вільними. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Я знаю, що ви нащадки Авраама, але шукаєте, як вбити Мене, бо не приймаєте Мого Слова. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Я кажу вам те, що бачив у Мого Отця, а ви робите те, що чули у вашого батька. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Вони відповіли: ―Наш батько – Авраам. Ісус сказав: ―Якби ви були дітьми Авраама, то чинили б діла Авраама. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","А тепер ви хочете вбити Мене, Чоловіка, Котрий сказав вам істину, яку Я почув від Бога. Авраам так не робив. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ви чините діла вашого батька. Вони сказали Йому: ―Ми не народилися від статевої розпусти, у нас один Отець – Бог. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ісус сказав їм: ―Якби Бог був вашим Отцем, ви б любили Мене, бо Я вийшов від Бога й прийшов сюди. Я прийшов не Сам від Себе, а Він послав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Чому ж ви не розумієте того, що Я кажу вам? Бо ви не можете слухати Моїх слів. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ваш батько – диявол, і ви прагнете виконувати його волю. Він від початку був убивцею і в істині не встояв, бо в ньому немає істини. Коли він каже неправду, то говорить від себе, бо він брехун і батько неправди. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Але Мені не вірите, тому що Я кажу вам істину. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Хто з вас може довести Мій гріх? А якщо Я кажу істину, чому ви не вірите Мені? ");
INSERT INTO ukronpu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Хто від Бога, той слухає слова Бога. Ви ж не слухаєте Мене тому, що ви не від Бога. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Юдеї відповіли Йому: ―Чи не правильно ми говоримо, що Ти самарянин і що Ти одержимий? ");
INSERT INTO ukronpu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ісус сказав: ―Я не одержимий, але Я шаную Мого Отця, а ви не шануєте Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Я не шукаю Своєї слави. Є Той, Хто шукає її для Мене. Він і судить. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Істинно кажу вам: хто підкоряється Моєму Слову, не побачить смерті повік. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Тоді юдеї сказали: ―Тепер ми точно знаємо, що Ти одержимий. Авраам помер, і пророки теж, а Ти кажеш: «Хто підкоряється Моєму Слову, не побачить смерті повік». ");
INSERT INTO ukronpu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Невже Ти більший від нашого батька Авраама, який помер? І пророки померли. Ким Ти Себе вважаєш? ");
INSERT INTO ukronpu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ісус відповів: ―Якщо Я буду славити Самого Себе, Моя слава нічого не значить. Мене славить Мій Отець, Якого ви називаєте своїм Богом, ");
INSERT INTO ukronpu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","хоча ви Його не знаєте. Але Я Його знаю, і якщо Я скажу, що не знаю Його, то буду таким же брехуном, як і ви. Але Я Його знаю та підкоряюся Його Слову. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ваш батько Авраам радів, що побачить Мій день. Він побачив і зрадів. ");
INSERT INTO ukronpu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Юдеї сказали Йому: ―Тобі немає й п’ятдесяти років, і Ти бачив Авраама? ");
INSERT INTO ukronpu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ісус відповів: ―Істинно кажу вам: перш ніж був Авраам, Я є! ");
INSERT INTO ukronpu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Тоді вони схопили каміння, щоб закидати Його. Але Ісус скрився й вийшов із Храму. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Одного разу, проходячи, Ісус побачив чоловіка, сліпого від народження. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Його учні запитали: ―Равві, хто згрішив, він чи його батьки, що він народився сліпий? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ісус відповів: ―Ні, це не через його гріх або гріх його батьків, але це сталося, щоб через нього були виявлені діла Божі. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Доки ще день, ми маємо виконувати діла Того, Хто послав Мене. Коли настане ніч, ніхто вже не зможе працювати. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Доки Я у світі, Я – світло світу. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Сказавши це, Ісус плюнув на землю, змішав грязь зі слини й землі та помазав очі сліпому. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Потім сказав йому: «Іди та вмийся в купальні Силоам» (що в перекладі означає: «Посланий»). Той пішов, умився й прийшов зрячий. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Сусіди й ті, хто бачив його раніше, як він просив, казали: ―Чи не він раніше сидів та просив? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Одні казали: ―Так, це він! Інші казали: ―Ні, він лише схожий на нього! Він же казав: ―Це я! ");
INSERT INTO ukronpu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Тоді запитали його: ―Як же ти прозрів? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Він відповів: ―Чоловік, Якого звуть Ісус, змішав грязь та помазав Мої очі, потім Він наказав піти в Силоам та вмитися. Я пішов, умився й прозрів. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Вони його запитали: ―Де Він? Він відповів: ―Я не знаю. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Чоловіка, який раніше був сліпий, привели до фарисеїв. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","А того дня, коли Ісус змішав грязь і відкрив йому очі, була Субота. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Фарисеї знову запитали його, як він прозрів. Той відповів: ―Він помазав мої очі гряззю, я вмився й бачу. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Деякі фарисеї почали казати: ―Цей чоловік не від Бога, тому що не дотримується Суботи. Інші ж казали: ―Як може грішна людина робити такі знамення? І між ними виникло розділення. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Тоді вони знов запитали сліпого: ―Що ти кажеш про Нього? Адже це Він відкрив тобі очі. Чоловік відповів: ―Він Пророк. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Юдеї не вірили, що він був сліпий і прозрів, доки не покликали його батьків. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Вони запитали: ―Це ваш син, про якого ви казали, що народився сліпий? Як же тепер він бачить? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Тоді батьки його відповіли: ―Ми знаємо, що він наш син і що він народився сліпий. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","А як він вже бачить, не знаємо. І хто відкрив йому очі, ми не знаємо. Запитайте його. Він дорослий і може сам відповісти за себе. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Його батьки казали так, адже боялися юдеїв, бо ті вже вирішили: хто визнає Ісуса Христом, буде відлучений від синагоги. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Тому його батьки й сказали: «Він вже дорослий, запитайте в нього!» ");
INSERT INTO ukronpu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Вони вдруге покликали чоловіка, який був сліпий, та сказали йому: ―Віддай славу Богові, ми знаємо, що той Чоловік – грішник. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Він відповів: ―Я не знаю, грішник Він чи ні. Я знаю лише одне: я був сліпий, а зараз бачу. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Тоді вони запитали: ―Що Він тобі зробив? Як Він відкрив твої очі? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Він відповів: ―Я вже казав вам, але ви не почули. Чому хочете почути ще раз? Чи не хочете й ви стати Його учнями? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Вони докорили йому та сказали: ―Це ти Його учень! Ми ж учні Мойсея! ");
INSERT INTO ukronpu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ми знаємо, що з Мойсеєм говорив Бог, а Цього ми не знаємо, звідки Він. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Чоловік сказав їм у відповідь: ―Дивно, що ви не знаєте, звідки Він, адже Він відкрив мені очі. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ми знаємо, що Бог не слухає грішників. Він слухає тільки тих, хто шанує Його й виконує Його волю. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Споконвіку ніхто не чув, щоб хтось відкрив очі тому, хто народився сліпий. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Якби Він не був від Бога, то не зміг би зробити нічого. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Вони відповіли: ―Ти увесь народився в гріхах, а нас повчаєш? І вигнали його геть. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ісус, почувши, що вони вигнали геть зціленого, знайшов його й запитав: ―Чи віриш ти в Сина Людського? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Зцілений відповів: ―Хто Він, Господи, щоб я повірив у Нього? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ісус сказав: ―Ти Його бачив, це Той, Хто говорить із тобою. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Тоді чоловік відповів: ―Вірю, Господи! – і вклонився Йому. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ісус сказав: ―Я прийшов у цей світ судити, щоб ті, хто не бачить, побачили, а ті, хто бачить, стали сліпими. ");
INSERT INTO ukronpu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Фарисеї, які були з Ним і почули це, сказали Йому: ―Невже й ми сліпі? ");
INSERT INTO ukronpu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ісус сказав: ―Якби ви були сліпі, то не мали б гріха. Але оскільки ви кажете, що бачите, гріх ваш залишається. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Істинно кажу вам: хто не входить в овечий двір через ворота, а перелазить в іншому місці, той злодій та розбійник. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","А хто входить через ворота, той пастир овець. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Сторож відкриває йому, і вівці чують його голос. Він кличе поіменно кожну вівцю й виводить їх. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Коли ж виведе всіх своїх, то йде попереду них, і вівці йдуть за ним, бо знають його голос. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","За чужинцем вони не підуть, а втечуть від нього, бо не знають його голосу». ");
INSERT INTO ukronpu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ісус сказав їм цю притчу, але вони не зрозуміли, про що Він говорив. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Тоді Ісус знову сказав: «Істинно кажу вам: Я – ворота для овець. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Усі, хто приходив до Мене, – злодії та розбійники; але вівці їх не слухалися. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Я – ворота, і якщо хтось входить через Мене, буде спасенний. Він увійде, вийде й знайде пасовисько. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Злодій приходить тільки для того, щоби вкрасти, вбити й зруйнувати. А Я прийшов, щоб люди мали життя й щоб мали його вдосталь. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Я – добрий пастир. Добрий пастир віддасть життя за овець. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Наймит не є пастирем, вівці не належать йому. Коли він бачить, що наближається вовк, то залишає овець і тікає. Вовк хапає овець, і вони розбігаються. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Наймит тікає, бо його найняли, і він не дбає про овець. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Я – добрий пастир. Я знаю Своїх, і вони знають Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Так само Отець знає Мене, і Я знаю Отця; Я віддаю Своє життя за овець. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","У Мене є й інші вівці, які не з цієї кошари, і їх Я маю привести сюди. Вони почують Мій голос, і буде одна отара й один пастир. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Отець любить Мене тому, що Я віддаю Своє життя, аби знову взяти його. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ніхто не може його забрати від Мене, Я Сам віддаю його. У Мене є влада віддати його й влада взяти його знов. Цю заповідь Я отримав від Мого Отця». ");
INSERT INTO ukronpu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Після цих слів між юдеями знов виник розкол. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Багато хто з них казав: ―Він одержимий і втратив розум. Навіщо Його слухати? ");
INSERT INTO ukronpu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","А інші казали: ―Це не слова біснуватого. Чи може демон відкрити очі сліпому? ");
INSERT INTO ukronpu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","В Єрусалимі було свято Відновлення Храму. Стояла зима. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ісус ходив у Храмі по колонаді Соломона. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Юдеї зібралися навколо Нього й сказали: ―Доки будеш тримати нас у непевності? Якщо Ти Христос, скажи нам прямо! ");
INSERT INTO ukronpu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ісус сказав: ―Я вже казав вам, але ви не вірите. Діла, які Я роблю в ім’я Мого Отця, свідчать про Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Але ви не вірите Мені, тому що ви не з Моїх овець. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Мої вівці чують Мій голос. Я знаю їх, і вони йдуть за Мною. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Я даю їм життя вічне, і вони ніколи не загинуть, і ніхто не забере їх з Моїх рук. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Мій Отець, Який дав їх Мені, величніший за всіх. І ніхто не зможе забрати їх з рук Мого Отця. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Я й Отець – одне! ");
INSERT INTO ukronpu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Тоді юдеї знов схопили каміння, щоб побити Його, ");
INSERT INTO ukronpu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","але Ісус сказав їм: ―Я показав вам багато добрих справ від Отця. За яку з цих справ ви хочете Мене побити камінням? ");
INSERT INTO ukronpu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Юдеї відповіли: ―Не за добрі вчинки ми хочемо побити Тебе, а за богохульство, бо Ти, будучи людиною, робиш себе Богом. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ісус сказав їм: ―Чи не написано у вашому Законі: «Я сказав: ви – боги?» ");
INSERT INTO ukronpu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Якщо богами названі ті, кому було дано Слово Боже, і Писання не може бути порушене, ");
INSERT INTO ukronpu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","то чому ж ви кажете про Того, Кого Отець освятив та послав у світ, що Він богохульствує, бо Я казав: «Я – Син Божий?» ");
INSERT INTO ukronpu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Якщо Я не роблю справ Мого Отця, не вірте Мені. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","А якщо роблю, то хоч не вірите Мені, повірте Моїм ділам і зрозумійте, що Отець у Мені і Я в Отці. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Вони знов намагалися схопити Його, але Він уникнув їхніх рук. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ісус знову пішов на інший бік Йордану, у місце, де Іван хрестив, і залишився там. ");
INSERT INTO ukronpu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","До Нього приходило багато людей, що казали: «Іван не зробив жодного знамення, але все, що він говорив про Нього, – правда». ");
INSERT INTO ukronpu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","І багато там увірувало в Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Був один хворий чоловік, на ім’я Лазар, з Віфанії, села, де жила Марія та її сестра Марта. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Марія була жінкою, яка помазала Господа миром і обтерла Йому ноги своїм волоссям. Хворий був її братом. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Сестри послали передати Ісусові: ―Господи, той, кого Ти любиш, захворів. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Почувши це, Ісус сказав: ―Ця хвороба не на смерть, а на славу Божу, щоб Син Божий був прославлений через неї. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ісус любив Марту, її сестру та Лазаря. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Однак коли Він почув, що Лазар хворий, то залишився там, де був, ще два дні. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Потім сказав Своїм учням: ―Підемо знову в Юдею. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Учні сказали Йому: ―Равві, ще недавно юдеї намагалися побити Тебе камінням, а Ти знову йдеш туди? ");
INSERT INTO ukronpu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ісус відповів: ―Чи не дванадцять годин має день? Якщо хтось ходить удень, не спотикається, бо бачить світло цього світу. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","А той, хто ходить уночі, спотикається, бо немає світла в ньому. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Сказавши це, Він додав: ―Наш друг Лазар заснув, але Я йду розбудити Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Його учні сказали: ―Господи, якщо спить, то одужає. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ісус казав про його смерть, а вони думали, що Він говорить про звичайний сон. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Тоді Ісус сказав їм прямо: ―Лазар помер. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Але Я радію за вас, що не був там, щоб ви повірили. А зараз підемо до нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Тоді Фома, якого називали Близнюк, сказав іншим учням: ―Ходімо й ми та помремо з Ним! ");
INSERT INTO ukronpu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Прийшовши туди, Ісус довідався, що Лазар уже чотири дні в гробі. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Віфанія була близько до Єрусалима, приблизно п’ятнадцять стадіїв. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Багато юдеїв прийшли до Марії та Марти, щоб втішити їх після смерті брата. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Коли Марта почула, що прийшов Ісус, вона вийшла зустріти Його, а Марія залишилася в домі. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Марта сказала Ісусові: ―Господи, якби Ти був тут, то мій брат не помер би. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Але й тепер знаю: Бог дасть Тобі, що лише попросиш у Бога. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ісус сказав їй: ―Твій брат воскресне. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Марта відповіла: ―Я знаю, що він воскресне при воскресінні останнього дня. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ісус сказав їй: ―Я – воскресіння й життя. Той, хто вірить у Мене, навіть якщо помре, буде жити. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","І кожен, хто живе й вірить у Мене, ніколи не помре. Ти віриш у це? ");
INSERT INTO ukronpu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Вона сказала: ―Так, Господи, я вірю, що Ти Христос, Син Божий, Який прийшов у світ. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Сказавши це, вона пішла, потай покликала свою сестру Марію й сказала їй: «Учитель тут, Він кличе тебе». ");
INSERT INTO ukronpu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Почувши це, Марія швидко встала й вийшла до Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ісус ще не увійшов до села, а був там, де Його зустріла Марта. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Юдеї, які були з нею в домі та втішали її, побачивши, що Марія швидко встала й вийшла, пішли за нею. Вони гадали, що вона пішла до гробу, щоб там плакати. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Коли Марія прийшла туди, де був Ісус, і побачила Його, то впала до Його ніг і сказала Йому: ―Господи, якби Ти був тут, то мій брат не помер би. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ісус, побачивши, що вона плаче, і юдеї, які прийшли з нею, теж плачуть, був глибоко зворушений в дусі та засмутився. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Він запитав: ―Куди ви його поклали? Йому відповіли: ―Господи, іди та подивись! ");
INSERT INTO ukronpu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ісус заплакав. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Тоді юдеї сказали: «Дивись, як Він любив його». ");
INSERT INTO ukronpu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Але деякі казали: «Невже Той, Хто відкрив очі сліпому, не міг зробити, щоб цей чоловік не помер?» ");
INSERT INTO ukronpu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ісус знов відчув зворушення в Собі й пішов до гробу. Це була печера, до якої був привалений камінь. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ісус звелів: ―Відваліть камінь. Марта, сестра померлого, сказала: ―Господи, вже чути неприємний запах, бо пройшло чотири дні. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ісус сказав: ―Хіба Я не казав тобі, що коли будеш вірити, побачиш славу Божу? ");
INSERT INTO ukronpu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Коли забрали камінь, Ісус подивився на небо й сказав: «Отче, дякую Тобі, що Ти почув Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Я знаю, що Ти завжди чуєш Мене, але Я сказав це заради людей, які стоять навколо, щоб вони повірили, що Ти послав Мене». ");
INSERT INTO ukronpu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","І, сказавши це, голосно промовив: «Лазарю, вийди сюди!» ");
INSERT INTO ukronpu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Померлий вийшов. Його руки та ноги були обмотані тканиною, а обличчя обв’язане хустиною. Ісус сказав: ―Розв’яжіть його, і нехай він іде. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Багато юдеїв, які прийшли до Марії та побачили, що Він зробив, повірили в Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Але деякі з них пішли до фарисеїв і розповіли, що зробив Ісус. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Тоді первосвященники та фарисеї скликали Синедріон і сказали: ―Що нам робити? Цей Чоловік робить багато знамень. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Якщо ми залишимо Його так, то всі повірять у Нього, і прийдуть римляни та знищать це місце й народ. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Тоді один із них, на ім’я Каяфа, який був первосвященником того року, сказав їм: ―Ви нічого не знаєте. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Хіба не розумієте, що краще для вас, щоб один Чоловік помер за народ, ніж щоб увесь народ загинув? ");
INSERT INTO ukronpu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Він сказав це не від себе, але, будучи того року первосвященником, він пророкував, що Ісус має померти за народ, ");
INSERT INTO ukronpu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","і не тільки за народ, але й щоб зібрати в одне розсіяних дітей Божих. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Отже, від цього дня вони змовилися вбити Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Тому Ісус не ходив відкрито серед юдеїв, а пішов звідти до околиць біля пустелі, у місто, яке називається Єфрем. Там перебував з учнями. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Наближалася юдейська Пасха, і багато людей з усього краю йшли до Єрусалима для очищення перед Пасхою. ");
INSERT INTO ukronpu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Вони шукали Ісуса й, стоячи в Храмі, казали одне до одного: «Як ви вважаєте, чи прийде Він на свято?» ");
INSERT INTO ukronpu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Але первосвященники та фарисеї дали наказ: якщо хтось дізнається, де Він перебуває, нехай повідомить їх, щоб вони схопили Його. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","За шість днів до Пасхи Ісус прийшов до Віфанії, де був Лазар, якого воскресив із мертвих. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Там Йому приготували вечерю. Марта слугувала, а Лазар був одним із тих, хто сидів із Ним за столом. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Тоді Марія взяла літру з дуже дорогим чистим нардовим миром, намастила ноги Ісуса й своїм волоссям обтерла Його ноги. І дім наповнився пахощами мира. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Але Юда Іскаріот, один з Його учнів, який мав Його зрадити, сказав: ");
INSERT INTO ukronpu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Чому б не продати це миро за триста динаріїв та не роздати бідним? ");
INSERT INTO ukronpu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Він казав так не тому, що піклувався про бідних, а тому, що був злодієм. Йому було доручено носити скриню з грошима, але він брав із неї гроші. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ісус сказав: ―Залиши її, вона зберігала це на день Мого похорону. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Бідних ви завжди маєте з собою, а Мене не завжди матимете. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Тим часом багато юдеїв дізналося, що Він там. Вони прийшли не тільки заради Ісуса, але й подивитись на Лазаря, якого Він воскресив із мертвих. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Тоді первосвященники змовилися вбити й Лазаря. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Адже багато юдеїв залишало їх і вірило в Ісуса. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Наступного дня багато людей, які прийшли на свято, почувши, що Ісус іде в Єрусалим, ");
INSERT INTO ukronpu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","взяли пальмові гілки, вийшли Йому назустріч та викрикували: «Осанна!» «Благословенний Той, Хто йде в ім’я Господа!» «Цар Ізраїля!» ");
INSERT INTO ukronpu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ісус, знайшовши осля, сів на нього, як написано: ");
INSERT INTO ukronpu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Не бійся, дочко Сіону: Ось Цар твій їде верхи на молодому ослі». ");
INSERT INTO ukronpu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Спочатку Його учні не розуміли цього. Але після того, як Ісус був прославлений, вони згадали, що це було написано про Нього й що це збулося з Ним. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Люди, які були з Ісусом, коли Він покликав Лазаря з гробу й воскресив його з мертвих, свідчили про це. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Тому багато людей вийшли Йому назустріч, бо чули, що Він здійснив це знамення. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Тоді фарисеї почали казати один одному: «Бачите, що нічого не допомагає? Ось увесь світ пішов за Ним!» ");
INSERT INTO ukronpu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Серед тих, хто прийшов поклонитися на свято, було декілька греків. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Вони підійшли до Филипа, який був із Віфсаїди, що в Галілеї, і просили його: «Пане, ми хочемо побачити Ісуса». ");
INSERT INTO ukronpu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Филип пішов і сказав Андрієві, і тоді Андрій та Филип розповіли про це Ісусові. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ісус відповів їм: ―Прийшов час прославитись Синові Людському. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Істинно кажу вам: якщо зерно пшениці, впавши в землю, не вмирає, то залишається одне. Але якщо вмирає, дає великий врожай. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Кожен, хто любить своє життя, втратить його, а хто ненавидить своє життя в цьому світі, збереже його для вічного життя. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Хто служить Мені, той повинен слідувати за Мною; і де Я є, там буде і Мій слуга. Якщо хтось буде служити Мені, Мій Отець шануватиме його. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Тепер Моя душа стривожена, і що Мені сказати? Отче, врятуй Мене від цієї години? Але саме заради цієї години Я і прийшов. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Отче, прослав Своє ім’я! Тоді почувся голос із неба: «Я прославив і знову прославлю!» ");
INSERT INTO ukronpu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Натовп, який був там, почувши це, сказав, що прогримів грім, а інші казали, що ангел говорив із Ним. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ісус відповів: ―Не для Мене пролунав цей голос, а для вас. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Зараз настав суд для цього світу. Тепер правителя цього світу буде вигнано геть. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Але коли Я буду піднятий від землі, Я всіх притягну до Себе. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Він сказав це, щоб показати, якою смертю має померти. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Тоді люди сказали Йому: ―Ми чули із Закону, що Христос житиме вічно. Як же Ти кажеш, що «Син Людський має бути піднятий?» Хто Цей Син Людський? ");
INSERT INTO ukronpu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Тоді Ісус сказав їм: ―Світло ще трохи часу буде з вами. Ходіть, доки маєте світло, щоб темрява не охопила вас. Хто ходить у темряві, той не знає, куди йде. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Повірте у світло, поки у вас є світло, щоб ви стали синами світла. Ісус закінчив говорити і, відійшовши, скрився від них. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Незважаючи на те, що Він зробив перед ними стільки знамень, вони не вірили в Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Так здійснилося слово пророка Ісаї, який сказав: «Господи, хто повірив почутому від нас і кому відкрилася рука Господня?» ");
INSERT INTO ukronpu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Не могли повірити ще й тому, що, як сказав Ісая: ");
INSERT INTO ukronpu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Він зробив сліпими їхні очі і закам’янілими їхні серця, щоб вони не бачили очима, і не розуміли серцем, і не навернулися, щоб Я зцілив їх». ");
INSERT INTO ukronpu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ісая сказав це, адже побачив Його славу й говорив про Нього. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Навіть серед керівників багато хто повірив у Ісуса. Але через фарисеїв вони не визнавали своєї віри, щоб їх не вигнали із синагоги. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Адже вони любили людську славу більше за Божу славу. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ісус голосно промовив: ―Хто вірить у Мене, той вірить не тільки в Мене, але й у Того, Хто послав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Той, хто бачить Мене, бачить і Того, Хто послав Мене. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Я – світло, яке прийшло у світ, щоб кожний, хто вірить у Мене, не залишався в темряві. ");
INSERT INTO ukronpu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Якщо хтось чує Мої слова, але не дотримується їх, Я не суджу його. А