﻿USE sofia;
DROP TABLE IF EXISTS sofia.ukr1871_vpl;
CREATE TABLE ukr1871_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ukr1871_vpl WRITE;
INSERT INTO ukr1871_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","У початку сотворив Бог небо та землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Земля ж була пуста і пустошня, і темрява лежала над безоднею; і дух Божий ширяв понад водами. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","І рече Бог: Настань, сьвіте! І настав сьвіт. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","І бачив Бог сьвіт, що воно добре; та й розлучив сьвіт із темрявою. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","І назве Бог сьвіт день, а темряву назве ніч. І був вечір, і був ранок; день первий. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","І рече Бог: Нехай проміж водами постане твердь, і розлучає води з водами! І сталось тако. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","І сотворив Бог твердь; і розлучив Бог воду, що була під твердею, із водою, що була понад твердею. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","І назве Бог твердь небо. І був вечір, і був ранок; день другий. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","І рече Бог: Зберись, водо, що попід небом, ув одно місце, і появися суходоле. І сталось тако. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","І назве Бог суходіл земля, а згромадженє вод назве море. І бачив Бог, що добре. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","І рече Бог: Нехай проростить земля биллє травне, зело з насїннями і дерево плодовите, плодюще по свойму родові, щоб його насїннє було в йому. І сталось тако. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","І вивела земля биллє травне, зело з насїннями і дерево плодовите, плодюще по свойму родові, що його насїння було в йому по свойму родові. І бачив Бог, що добре. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","І був вечір, і був ранок; день трейтїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","І рече Бог: Постаньте сьвітила, на твердї небесній розлучати день із ніччю, і бувайте знаменнями на ознаку впливочасу і днїв і років. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","І бувши сьвітилами на твердї небесній, сьвітїте по землї. І сталось тако. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","І сотворив Бог два сьвітила великі: сьвітило велике правити днем, і сьвітило менше правити ніччю, і зорі. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","І поставив їх Бог на твердї небесній сьвітити на землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","І правити днем і ніччю, і розлучати сьвіт із темрявою. І бачив Бог, що добре. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","І був вечір, і був ранок; день четвертий. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","І рече Бог: Заграйте, води, душами живими, і полинь, птаство, над землею попід небесною твердю. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","І сотворив Бог чудища великі і усяку душу живу повзючу, що заграла ними вода, по родові їх, і всяке птаство пернате. І бачив Бог, що добре. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","І благословив їх Бог, і глаголе: Плодїтеся і множтеся і сповняйте воду в морях, і птаство нехай множиться на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","І був вечір, і був ранок; день пятий. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","І рече Бог: Виведи, земле, душу живу по роду їх, четверонога і повзюче і дикого зьвіра, по родові їх. І сталось так. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","І сотворив Бог зьвірє земне по родові їх, і скотину по родові й усе повзюче по родові їх. І бачив Бог, що добре. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","І рече Бог: Сотворимо чоловіка в наш образ і в подобу, і нехай панує над рибою морською, і над птаством небесним, і над скотиною, і над усяким диким зьвірєм, і над усяким гадом, що лазить по землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","І сотворив Бог чоловіка в свій образ, ув образ Божий сотворив його, як чоловіка і жінку сотворив їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","І благословив їх Бог, і рече до них Бог: Плодїтеся і намножуйтесь, і сповнюйте землю і підневолюйте її, і пануйте над рибою морською і над птаством небесним і над усїм зьвірєм, що гасає по землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","І рече Бог: Оце ж дав я вам усяке зело з насїннями, яке нї росте на землї, та й усяке дерево, що має в собі плід родющий насїннє; се нехай вам на харч. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","І всякому зьвірові земному, і всякому птаству небесному, і всьому повзючому по землї, усякій душі живій, призначив я всяку траву й зело на харч. І сталось тако. ");
INSERT INTO ukr1871_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","І бачив Бог, що все, що сотворив, було вельми добре. І був вечір, і був ранок; день шестий. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Так докіньчено небеса й землю з усїм войнством їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","І докіньчив Бог шестого дня дїло своє, що сотворив; і почив на семий день від усього дїла, що сотворив. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","І благословив Бог день семий, і зъясував його сьвятим: того бо дня спочив од усїх дїл своїх, які вчинив і зробив. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Се початок настання небес і землї, як сотворено їх, того часу, як сотворив Господь землю і небо, ");
INSERT INTO ukr1871_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Не було ще на землї нїякої рослини на полях, і не росло ще нїяке зело на полях; бо Господь Бог не повелїв іще дощувати на землю, і не було ще там людей порати землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Виходила ж імла з землї і напувала всю верховину на суходолї. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","І создав Господь Бог чоловіка з землї польової, і вдихнув йому в ноздрі живе диханнє. І став чоловік душею живою. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","І насадив Бог сад у Едемі на востоцї, та й осадив там чоловіка, що создав. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","І зростив Господь Бог усяке дерево із землї, принадне на погляд і смашне плодом своїм, і дерево жизьняне посеред саду, і дерево познавання добра й зла. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","І ріка виходить із Едему на поливаннє саду, а потім розлучається чотирма течіями. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Імя первої Пизон; ся обтекає всю Гавила землю, де знаходять золото. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","А золото в тій землї предобре. Там знаходять і бедола-смолу і камінь оникс. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","А друга річка зветься Гигон; ся обтекає всю Куш землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","А трейтя зветься Гиддекель; се та річка, що йде на схід соньця від Ассура. А четверта річка, се Евфрат. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","І взяв Господь Бог чоловіка та й осадив його в Едемському саду порати його і доглядати. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","І заповідав Господь Бог чоловікові, глаголючи: З усякого древа в саду-раї можна тобі по вподобі їсти. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","З того ж дерева, що дає знаттє доброго й лихого, з того не важитимешся їсти, ато вмреш певно того ж дня, як скоштуєш із його. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","І рече Господь Бог: Не добре чоловікові бути самому; сотворимо йому таку поміч, щоб до пари була йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","І сотворив Господь Бог із землї всякого зьвіря польового і всяке птаство небесне, і привів їх до чоловіка побачити, як він зватиме їх, і як нї назвав би чоловік їх живі душі, так щоби мусїли вони зватись. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","І подавав чоловік назви всякій скотинї, і птаству небесному, і всякому польовому зьвірові, та про чоловіка не знайшлось такої помочі, щоб до пари була йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","І попустив Господь Бог твердому сну обняти чоловіка, і як заснув, узяв одно з його ребер, та й затулив його місце тїлом. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","І создав Господь Бог женщину з ребра, що взяв од чоловіка, та й привів її до чоловіка. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","І каже чоловік: Се ж кість од костей моїх і тїло від тїла мого. Мусить вона зватись людина; бо її взято з чоловіка. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Тим оставить чоловік отця свого й матїр свою та й прилїпиться до жони своєї, і будуть удвох тїлом одним. ");
INSERT INTO ukr1871_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","І були обоє нагі, чоловік і жона його, і не соромились. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Змій же був хитріщий над усякого польового зьвіра, що Господь Бог создав. І каже він жіньцї: Чи справдї Бог сказав: Не мусите їсти нї з якого дерева райського? І каже жінка змієві: З усякого дерева райського їсти мемо, ");
INSERT INTO ukr1871_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","З плоду ж дерева, що серед раю, рече Бог, не їжте з його, анї доторкати метесь до нього, ато помрете. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","І каже змій жіньцї: Нї бо, не помрете. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","А се Бог знає, що скоро попоїсте з нього, відкриються вам очі, і будете як боги, знающі добре й лукаве. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","І вбачала жінка, що добре дерево на їду, і принадне очима дивитись і надило тим, щоб усе знати; і взяла плоду з його та й скоштувала, і дала чоловікові свойму з собою, і скоштували. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","І відкрились їм обом очі, і схаменулись вони, що були нагі; і позшивали листя смоковне, та й поробили пояси. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","І почули глас Господа Бога ходячого в раї по прохолодї, і поховались чоловік і жінка його від лиця Господа Бога посеред райського дерева. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","І покликне Господь Бог до чоловіка, і рече йому: Де єси? ");
INSERT INTO ukr1871_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","І каже він: Голос почув я твій у саду та й злякавсь, тим що наг, та й сховавсь. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","І рече він: Хто зъясував тобі, що наг єси? Хиба скоштував з того древа, що заповідав я тобі з одного сього не їсти? ");
INSERT INTO ukr1871_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","І каже чоловік: Жінка, що дав єси бути зо мною, вона дала менї з дерева, я й попоїв. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","І рече Господь Бог жіньцї: Що ти вкоїла? І каже жінка: Змій спокусив мене, я й скоштувала. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","І рече Господь Бог змієві: За те, що вдїяв таке, проклят єси між усїма скотами, і між усїм зьвірєм польовим. Лазити меш поповза, човгати меш на грудях твоїх і на череві ходити меш, і їсти меш землю по всї днї життя твого. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","І положу ворогуваннє між тобою й жінкою і між насїннєм твоїм і насїннєм її, воно рощавлювати ме тобі голову, ти ж упивати мешся йому в пяту. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","А жінцї рече: Наготую тобі муки в вагонїннях твоїх; мучившись роджати меш дїти, а до мужа твого поривати ме тебе, він же панувати ме над тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","І чоловікові рече: Що послухав єси гласу жени твоєї та попоїв з того дерева, що заповідав я сього єдиного не їсти, проклята земля задля тебе; в печалї і тузї харчувати мешся з неї по всї днї живота твого. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Тернину да осет родитиме вона тобі, і їстимеш польове зело. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","У поту лиця твого їстимеш хлїб твій, аж покіль вернешся в землю, що з неї й узято тебе. Земля бо єси і землею візьмешся. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","І дав чоловік жіньцї своїй імя Ева: бо вона мати всїх живих. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","І поробив Господь Бог чоловікові й жіньцї його одежу із шкір та й зодїг їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","І рече Господь Бог: Оце і чоловік став як один ізміж нас, зрозумівши добре й лукаве, і тепер колиб не простїг руку свою, та не взяв із древа животового, да не попоїв, і не став жити во вік. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","І вислав його Господь Бог із саду Едену порати землю, що з неї й узятий. ");
INSERT INTO ukr1871_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","І вигнав чоловіка. І поставив на востоцї за садом Еденом херовимів з поломяними голими мечами обертасами стерегти дорогу до животового древа. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","І взнав чоловік Еву, жінку свою, і завагонївши вона, вродила Каїна і промовила: Придбала я людину з Божої ласки. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Потім уродила брата його, Абеля. І був Абель вівчар, Каїн же пахарь. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","І сталось по якомусь часї, що Каїн приносив Господеві жертву з польового вроджаю. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Абель же приносив принос од перваків овечих ситеньких. І споглянув Господь на Абеля і на дар його; ");
INSERT INTO ukr1871_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","На Каїна ж і на його жертву не споглянув. І взлився Каїн, і змарнїв. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","І рече Господь Каїнові: Чого ти злишся, і чого змарнїв? ");
INSERT INTO ukr1871_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Коли чиниш добре, дак і лице весело позирає; коли ж чиниш не добре, дак на тебе гріх чигає в порозї, щоб одолїти; ти ж мусиш панувати над ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Озветься ж Каїн до Абеля, брата свого: Ходїмо в поле. І як були вони в полї, напав Каїн на брата свого Абеля та й убив його. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","І рече Господь Каїнові: Де твій брат? А він каже: Не знаю. Хиба я сторож брата мого? ");
INSERT INTO ukr1871_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","І рече: Що вкоїв єси? Слухай, се голосить кров брата твого до мене з землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Оце ж проклят єси прогоном із землї, що роззявила уста свої пити кров брата твого з руки твоєї. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Як порати меш землю, не давати ме вже з сього часу вона тобі нїякої користї. Волоцюгою й утїкачем будеш на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","І відказав Каїн Господеві: Не перебути менї того, що наробив провиною моєю. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Женеш оце мене з землї, і від лиця твого ховати мусь, і буду волоцюгою й утїкачем на землї і, хто зустріне мене, той і вбє мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","І рече йому Бог: Тим же то, хто б убив Каїна, на того впаде помста всемеро. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","І положив Господь знак на Каїні, щоб не вбивав його, хто зустріне його. І зійшов Каїн од обличчя Господнього, і пробував у Нод-землї, на востоцї ʼд Едену. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","І взнав Каїн жінку свою, і завагонїла вона, і вродила Геноха. Він же збудував місто в імя сина свого Геноха. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Генохові же породивсь Ірад, а Ірад появив Мегуяеля, а Мегуяель появив Ламеха. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","І взяв собі Ламех дві жінки: одна на ймя була Ада, а друга на ймя була Зилла. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","І вродила Ада Ябаля. Сей був батько тих, що живуть шатрами і держять скотину. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","А брат його на імя був Юбаль. Сей був батько охочих до гусель та до сопілки. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Зилла ж і та вродила Тубаль-Каїна, праотця всїх тих, що кують мідь і залїзо. Сестра ж Тубаль-Каїнова Ноема. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","І каже Ламех жінкам своїм: Ой Зилло й Адо, кохані жінки Ламешихи! Слухайте, що я скажу вам, чуйте слово певне. Коли б за болючу рану вбив я чоловіка, коли б за синяк одвдячив парубкові смертю, — ");
INSERT INTO ukr1871_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Кара б сталась за Каїна в семеро хто вбив би, за Ламеха ж у сїмдесять і сїм раз би сталась. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","І взнав Адам жінку свою знов, і вродила вона сина і дала йому імя Сет: Воскресив бо каже, менї Бог потомство замість Абеля, що вбив Каїн. ");
INSERT INTO ukr1871_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","І Сетові те ж появлено сина і назве він імя йому Енос. Тодї почали призивати імя Господнє. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Се книга роду Адамового: У той день, як сотворив Бог чоловіка, в образ Божий сотворив його. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Мужа і жену сотворив їх, і благословив їх і нарече назву їм людина в той день, як сотворив їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Поживши ж Адам двісьтї і трийцять год, появив сина в свій вид і в свій образ і дав імя йому Сет. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Віку Адамового після того, як появив Сета, було вісїм сот год, і появив сини й дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","А всього віку Адамового було девять сот і трийцять год, і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Як було ж Сетові сто і пять год, появив Еноса. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Як родився ж Енос, жив іще Сет вісїм сот і сїм год, і появив сини і дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","А всього віку Сетового було девять сот і дванайцять год, і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Як було ж Еносові девятьдесять год, появив Кенана. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","І прожив Енос, появивши Кенана, вісїм сот і пятнайцять год, і появив сини і дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","А всього віку Еносового девятьсот і пять год, і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Як було ж Кенанові сїмдесять год, появив Магалалеля. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","І прожив Кенан появивши Магалалеля вісїм сот і сорок год, і появив сини і дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","А всього віку Кенанового було девятьсот і десять год, і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","І прожив Магалалель шісьдесять і пять год, і появив Яреда. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","І прожив Магалалель появивши Яреда вісїм сот і трийцять год, і появив сини і дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","А всього віку Магалалелевого було вісїм сот і девятьдесять і пять і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","І прожив Яред сто і шісьдесять і два годи, і появив Геноха. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","І прожив Яред, появивши Геноха, вісїм сот год, і появив сини і дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","А всього віку Яредового було девятьсот і шісьдесять і два годи, і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","І прожив Генох шісьдесять і пять год, і появив Метусалу. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","І ходив Генох з Богом, появивши Метусалу, три ста год, і появив сини і дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","А всього віку Генохового було триста і шісьдесять і пять год. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","І ходив Генох з Богом, і не стало його: бо взяв його Бог. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","І прожив Метусала сто і вісїм десять год, і появив Ламеха. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","І прожив Метусала появивши Ламеха сїм сот і вісїмдесять і два годи, і появив сини і дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","А всього віку Метусалового було девятьсот і шісьдесять і девять, і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","І прожив Ламех сто і вісїмдесять і два годи, і появив сина. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","І дав йому імя Нояг, каже бо: Сей розважати ме нас у працї нашій та в знемозї рук наших, як поратимем землю, що прокляв Господь Бог. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","І жив Ламех появивши Нояга пятьсот і девятьдесять і пять год, і появив сини і дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","А всього віку Ламехового було сїм сот і сїмдесять і сїм год, і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Як було ж Ноягові пятьсот год віку, появив Сема, Хама і Яфета. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Як почали ж люде намножуватись на землї та понароджувалось дочок у їх, ");
INSERT INTO ukr1871_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Тодї сини Божі, бачивши, що в синів чоловічих дочки хороші, брали їх за жінок, хто котору вподобав. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","І рече Господь: Не буде мій дух переважувати в людинї до віку, бо вона тїло; дак нехай віку людського буде сто і двайцять год. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Були тодї на землї велетьнї, та й навпосьлї, як сини Божі горнулись до дочок чоловічих, а вони їм роджали. Се ті потужники, що з давнїх давен бували високо вславлені. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Як же побачив Бог, що ледарство людське було велике на землї, а люде дбають повсячасно тільки про лихе, ");
INSERT INTO ukr1871_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Дак жалкував Господь, що сотворив чоловіка на землї, тай журився тяжко. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","І рече Бог: Вигублю чоловіка, що із землї, як чоловіка, так і скотину, і лазюче і летюче: бо взяла мене досада, що посоздавав їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Нояг же здобувся на ласку в Господа. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Оце ж Ноягова й постань. Нояг був праведний чоловяга, без гріха між сучасниками своїми. Нояг ходив з Богом. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","І появив Нояг три сини: Сема, Хама і Яфета. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Земля ж попсувалась перед Богом, і сповнилась насильством земля. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","І споглянув Бог на землю, аж вона зопсувалась: бо зопсувало всяке тїло свою путь на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","І рече Бог Ноягові: Конець усякому тїлу прийшов перед мене: бо землю сповнено насильством од них. Оце ж хочу їх викоренити з землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Зроби собі ковчег із соснового дерева; гнїзда поробиш у ковчезї та й посмолиш його з середини і надвору смолою. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","А зробиш ковчег тако: трох сот локот завдовжки ковчег, і пятьдесять локот завширшки, а трийцять локот заввишки. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Просьвіт зробиш у ковчезї і зведеш його в локіть угорі; двері ж у ковчезї зробиш із боку, а житла у два і у три поверхи робити меш. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Я ж оце наведу потоп, воду на землю, щоб вигубити всяке тїло, що є в її живий дух попід небесами, і все, що є на землї, повиздихає. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","І поставлю заповіт (умову) з тобою: Ввійдеш у ковчег ти і синове твої і жена твоя і жени синів твоїх з тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","І од усякого живого і од усякого тїла по двоє од усїх уведеш у ковчег, щоб живими остались з тобою: самець і самиця будуть. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Од усього птаства по роду, і од усякої скотини по роду, і од усього лазючого, що човгає по землї по роду їх; двоє од усякого ввійдуть у ковчег до тебе, щоб зостались живими. Ти ж возьми всякої харчі собі, щоб мали ви що їсти. ");
INSERT INTO ukr1871_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","І вчинив Нояг усе, що заповідав йому Господь, і притьма так учинив. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","І рече Бог до Нояга: Увійди сам і ввесь дом твій у ковчег; бо тебе вбачав я праведним передо мною в сьому родї. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Від усякої ж скотини чистої введи до себе по семеро, самця і самицю, від скотини ж нечистої по парі, самця і самицю, ");
INSERT INTO ukr1871_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","І від птаства небесного по семеро, самця і самицю, щоб насїннє живе переховати по всїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ще бо сїм день, і дощувати му на землю сорок день і сорок ночей, та й вигублю з лиця землї всяке живе, що сотворив. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","І вчинив Нояг усе, що заповідав йому Господь Бог. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ноягові ж було шістьсот год, як стався потоп водний на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","І ввійшов Нояг, і сини його, і жінка його, і жінки синів його з ними у ковчег задля води потопньої. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","І з чистої скотини і з скотини нечистої і з птаства і з усього лазючого поповза по землї, ");
INSERT INTO ukr1871_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","По парі ввійшло до Нояга в ковчег, самець і самиця, як заповідав Бог Ноягові. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","І сталось по семи днях, що вода потопня поняла землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","В шести сотьньому роцї Ноягового віку, другого місяця, на сїмнайцятий день місяця, того ж дня, порозверзались усї жерела великої безоднї, і хляби (вікна) небесні повідчинялись. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","І лило на землю сорок день і сорок ночей. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Того дня ввійшов Нояг, Сем, Хам і Яфет, сини Ноягові, і жінка Ноягова і троє жінок синів його з ним у ковчег; ");
INSERT INTO ukr1871_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Вони і усяка животина по свойму роду, і всяка скотина по кодлу, і усяке лазюче поповза, що човгає по землї по кодлу свойму, і всяке птаство пернате. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Поввіходили до Нояга у ковчег по парі усякого тїла, що в йому є живий дух. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","І входячі були самець і самиця од усякого тїла, як заповідав йому Бог. І зачинив Господь Бог ковчег ізнадвору. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","І затоплювало землю сорок день, і прибувало води, і підіймало ковчег у гору над землею. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","І впотужнювалась вода, і прибувала велико на землї, і носився ковчег по водї. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","І впотужнювалась вода на землї несказанно, і поняла всї високі гори, по під небесами. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Прибула понад ними вода на пятнайцять локот, і поняла всї високі гори. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","І повиздихало всяке тїло, що двигалось по землї, і з птаства і з скотини, і з зьвіра, і з усякого лазючого поповза по землї і всяка людина. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Усе, в чого було диханнє і все, що було на сусї, повиздихало. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","І погинуло все живе, що було на земному лицї, погинуло, і людина і скотина і лазюче поповза, і птаство небесне, і вигублено все те на землї, і зоставсь Нояг один да те, що було з ним у ковчезї. ");
INSERT INTO ukr1871_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","І впотужнювалась вода на землї сто і пятдесять день. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","І спогадав Бог Нояга і все живе і всяку скотину з ним у ковчезї, і навів Бог вітра на землю, і перестало дощувати. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","І позамикались жерела в безоднї і хляби небесні, і зупинився дощ із неба. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","І вертались води з землї без перестанї, і як уплило сто і пятдесять день, стала вода посякати. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","І зупинився ковчег у сьомому місяцї, на сїмнайцятий день місяця, на горі Арарацькій. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","І вбувало води більше та більше до десятого місяця, а в десятому місяцї на первий день місяця стало видко верхи по горах. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","І сталось по сорока днях, що відчинив Нояг вікно в ковчезї, що був зробив. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","І випустив крука, і лїтав той сюди й сюди, закіль посякла вода на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Опісля випустив голубицю від себе, щоб довідатись, чи вода спала з земного виду. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Та не знайшла голубиця відпочинку нозї своїй, та й вернулась до його в ковчег: бо вода поняла вид усїєї землї. І простїг він руку тай узяв її до себе в ковчег. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","І пождав ще других сїм день, та ізнов послав голубицю з ковчега. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","І прилетїла голубка надвечір до його, колиж се — оливний листок у неї в дзьобочку. І дознавсь Нояг, що вода уступила з виду земного. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","І зождав іще других сїм день, та й послав знов голубицю, і не вернулась уже до його тодї. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","І сталось у шістьсот первому роцї на первий день первого місяця, що посякла вода на землї. І зняв тодї Нояг кришу в ковчезї, і споглянув, аж се — вид земний уже сухий, ");
INSERT INTO ukr1871_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","А в другому місяцї на двайцять сьомий день місяця земля стужавіла. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","І рече Господь Бог Ноягові, глаголючи: ");
INSERT INTO ukr1871_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Вийди з ковчега сам і жона твоя і сини твої, і жени синів твоїх з тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","І всяку животину, що з тобою і всяке тїло від птаства і від скотини і з усякого лазючого поповза по землї повиводь із собою; і плодїтесь і намножуйтесь на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","І вийшов Нояг і сини його, і жінка його, і синів його жінки з ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Усяка животина, всяке лазюче поповза по кодлах своїх повиходило з ковчега. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","І спорудив Нояг жертівника Господеві, і взяв з усякої чистої животини і з усякої чистої птицї та й принїс у всепаленнє на жертівник. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","І понюхав Господь любих пахощів, і рече: Не проклинати му вже більше землї за чоловіка; бо надих людського серця злющий з молодощів його; і не вигублювати му вже більш усього живого, як учинив. ");
INSERT INTO ukr1871_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Покіль земля землею, сїйба й жнива, холоднеча й спека, лїто й весна, день і ніч не перестануть. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","І благословив Бог Нояга і сини його, і рече їм: Бувайте плодющі і намножуйтесь і залюднюйте землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","І страх і ляк перед вами нехай находить на всяку животину земну, і на всяке птаство небесне, і на все лазюче по землї, і на всяку рибу морську. На поталу вам подав я їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Усяке двигуще, що живе на землї, буде ваша їда; як зело травяне подаю вам усе. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Тілько мясива з його кровю, душею, щоб не їли. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Крові бо вашої, душ ваших, вимагатиму, на всякій животинї мститимусь за неї і допевнятимусь душі людської від руки чоловіка, від руки братя його. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Хто проллє кров людську, того кров теж проливати ме чоловік: бо в образ Божий сотворив Бог чоловіка. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ви ж росплоджуйтесь і намножуйтесь, буяйте по землї і множтесь по її. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","І рече Бог Ноягові та синам його з ним, глаголючи: ");
INSERT INTO ukr1871_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ось я поставляю заповіт мій з вами і з вашим потомством по вас. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","І з усякою душею живою, що з вами, з птаством і скотиною, і з усїм живим на землї, що з вами буде, з усїма, що повиходили з ковчега. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","І постановлю заповіт мій з вами: що нїяке тїло не вимре вже од потопньої води, і не буде вже потопу водного, щоб спустошити всю землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","І рече Господь Бог Ноягові: Ось вам знаменнє заповіту, що я дав між мною і вами і між усякою живою душею, яка єсть з вами в роди вічні: ");
INSERT INTO ukr1871_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Райдугу́ мою покладаю в хмарі, щоб вона була знаменом заповіту між мною і землею. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","І станеться, як наведу хмари понад землею, що зъявиться веселка моя в хмарі. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","І спогадаю заповіт мій, що постав між мною і вами, і між усякою живою душею в усякому тїлї: що не буде вже води потопньої на погибель усякому тїлу. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","А буде райдуга моя в хмарі, і дивитись му на її, щоб спогадати заповіт вічний між Богом і землею, і між усякою живою душею і всяким тїлом, яке єсть на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","І рече Бог Ноягові: Се знаменнє вмови, що постановив я проміж мною і усяким тїлом, яке єсть на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Сини ж Ноягові, що повиходили з ковчега, були: Сем, Хам і Яфет. Хам же був отець Канаанів. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Троє сих сини Ноягові, і від них порозсївались люде по всїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","І почав Нояг бути ратаєм на землї і насадив виноград. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","І пив вино, та й упився і лежав обнаживши ся у наметї свойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","І побачив Хам, отець Канаанів, наготу батька свого, і вийшовши геть оповідав обом братам своїм. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","І взявши Сем та Яфет гуню, накинули її на плечі собі та й ійшли дивлячись назад, і прикрили наготу батька свого, а лиця їх дивились назад, і наготи батькової не бачили вони. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Отверезився ж Нояг од хмелю свого, та й довідався, що вчинив йому підстарший син його, ");
INSERT INTO ukr1871_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","І рече: Ой щоб же ти долї не мав, Канаане! Рабом що найнисшим служити меш браттї. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Хвала Господеві! Се Бог мого Сема. А ти, Канаане, рабом у них будеш. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Розшируй Яфета і дай йому, Боже, седїти у Сема, у брата в наметї, а ти, Канаане, рабом у них будеш. ");
INSERT INTO ukr1871_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","І пожив Нояг по потопі триста і пятдесять год; ");
INSERT INTO ukr1871_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","І було всїх днїв Ноягових років деватьсот пятьдесять, і вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Се ж постань синів Ноягових, Сема, Хама та Яфета, і понароджувались їм сини по потопі. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Сини Яфетові: Гомер та Магог, та Мадай, та Яван да Тубал, та Месех, да Тирас. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","А сини Гомерові: Аскеназ та Рифат та Тогарма. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","А сини Яванові: Елиса, да Тарсис, Киттим та Доданим. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Від сих розселились люде в країнах невірних, по землях своїх, по мовах своїх, по родинах своїх, по племенах своїх. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","А сини Хамові: Куш та Мизраїм, да Фут, да Канаан. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","А сини Кушові: Себа та Гавила, да Сабта, да Рахма, да Сабтека; а сини Рахмові: Шеба та Дедан. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","І появив Куш Нимрода. Сей почав бути велетнем на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Сей був велетень ловець перед Господом; тим і мовляли: як Нимрод, велетень ловець перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Царюваннє ж його роспростерлось на Бабилон, і Ерех, і Аккад, і Калне у Синеяр землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Із тієї землї вийшов Ассур, та й збудовав Ниневу і Регобод-Ір, і Калаг, ");
INSERT INTO ukr1871_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","І Резен між Ниневою і Калагом; було то місто велике. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Від Мизраїма родились Людій, Анамій, Легавій і Нафтухій, ");
INSERT INTO ukr1871_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","І Патрусїй, Каслугій, від котрих пійшли Филистимцї, да Кафторій. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Від Канаана ж родились Зидон, його перворідень, та Хет, ");
INSERT INTO ukr1871_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Євусій, та Аморій, та Гергасїй, ");
INSERT INTO ukr1871_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Та Гевій, да Аркей, да Синей, ");
INSERT INTO ukr1871_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Та Арвадїй, та Земарій, да Гаматїй; а потім розродились родини Канаанські. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","А займище Кананеїв сягало від Сидону до Герару, до Гази, до Содому і Гоморри й Адами й Зевоіму аж до Лаши. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Се сини Хамові по їх родинах, і мовах, і землях, і племіннях. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","І Семові, праотцеві всїх дїтей Еберових, братові Яфетовому старшому, понароджувались сини. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Сини Семові: Елам, та Ассур, та Арфаксад, та Люд, та й Арам. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","А сини Арамові: Уз да Хул, да Гетер, да Маш. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Арфаксад же появив Салу, а Сала появив Ебера. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","А Еберові вроджено два сини; одного звали Фалек, бо за його життя земля була подїлена, а брата його на імя звали Йоктан. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","А Йоктан появив Алмодада та Шалефа, та Газармавета да Єраха, ");
INSERT INTO ukr1871_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Та Гадорама, та Узала, та Диклу, ");
INSERT INTO ukr1871_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Та Обаля, та Абимавеля, та Шеву, ");
INSERT INTO ukr1871_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Та Офира, та Гавилу, та Йовава. Всї ʼці сини Йоктанові. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","А поосїдали вони від Мешари до Сефари гори, що на схід сонця. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Се сини Семові по їх родинах, мовах, по їх займищах, по їх народовинах. ");
INSERT INTO ukr1871_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Се роди синів Ноягових по їх свояцтвах, по їх племіннях; і від них порозходились народи по землї після потопу. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","І була вся земля мова одна і слово одно. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","І сталось, як мандрували вони від схід сонця, що знайшли поділлє в Синеяр землї, та й осїлись там. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","І мовляли одно ʼдному: Нумо лишень робити цеглу та випалювати. І була в їх цегла за камінь а земляна смола за вапну. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","І мовляли: Нумо споруджувати місто із баштою, щоб її верх був до небес, і зробімо собі память, щоб не розпорошитись нам по всїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","І зійшов Господь побачити город і башту, що споруджували сини чоловїчі. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","І рече Господь: Оце ж рід один, мова одна в усїх, а се тількі почин їх заходу коло працї; і тепер нїщо їх не зупинить нї від чого, що задумали зробити. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Зійдемо ж униз та помішаємо їх мову, щоб не розуміли одно ʼдного. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","І розсїяв їх ізвідти Господь по лицю всієї землї; і покинули споруджувати город і башту. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Тим проложено йому імя Бабель: бо там помішав Господь мову всієї землї, і звідти розсїяв їх Господь по лицю всієї землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","А се постань Семова. Було Семові сто лїт, як появив Арфаксада, у другому роцї по потопі. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","І пожив Сем після того, як появив Арфаксада, пятсот год, і появив сини й дочки, та й умер. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","І пожив Арфаксад трийцять і пять год, і появив Селу. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","А пожив Арфаксад після того, як появив Селу, чотири ста і три роки, та й появив сини й дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","І пожив Села трийцять год, і появив Ебера. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","А пожив Села після того, як появив Ебера, чотири ста і три роки, і появив сини й дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","І пожив Ебер трийцять і чотири годи і появив Пелега. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","А пожив Ебер після того, як появив Пелега, чотири ста і трийцять год, і появив сини й дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","І пожив Пелег трийцять год, і появив Регува. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","А пожив Пелег після того, як появив Регува, двістї і девять год, і появив сини й дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","І пожив Регу трийцять і два роки, і появив Серуга. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","А пожив Регу після того, як появив Серуга, двістї і сїм год, і появив сини й дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","І пожив Серуг трийцять год, і появив Нагора. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","А пожив Серуг після того, як появив Нагора, двістї год, і появив сини й дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","І пожив Нагор двайцять і девять год, і появив Тару. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","А пожив Нагор після того, як появив Тару, сотню і девятнайцять год, і появив сини й дочки. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","І пожив Тара сїмдесять год, і появив Аврама, Нагора й Гарана. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","А се постань Тарина. Тара появив Аврама, Нагора і Гарана; Гаран же появив Лота. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","І вмер Гаран перш отця свого Тари в землї ріднїй своїй, в Урі Халдейському. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","І побрали собі Аврам і Нагор жінок. Імя Аврамовій жінцї було Сара; імя ж Нагоровій жінцї було Милка Гаранівна, дочка батька Милки й батька Іски. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Сара ж була неплідна, не мала дїтей. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","І взяв Тара Аврама да Лота, сина Гаранового, сина свого сина, да невістку свою Сару, сина свого Аврама жінку, та й вивів їх із Ура Халдейського, щоб ійти в землю Канаанську, і прийшли в Гаран та й осїлись там. ");
INSERT INTO ukr1871_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","А віку Тариного було двістї і пять год, і вмер Тара в Гаранї. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","І рече Господь Аврамові: Зійди з землї твоєї і від роду твого і з домівки отця твого у ту землю, що тобі покажу. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","І зроблю тебе народом великим, і благословлю тебе і звеличу імя твоє, і будеш благословен. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","І благословлю благословляючих тебе, а кленучих тебе проклену. І благословляться в тобі всї племіння землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","І пійшов Аврам, як глаголав йому Господь, і йшов із ним Лот. Аврамові ж було сїмдесять год, як ізійшов із Гарану. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","І взяв Аврам Сару, жінку свою, да Лота, сина брата свого, і все майно своє, яке нажили в Гаранї, і всякі душі, що здобули в Гаранї, та й зійшли геть, щоб ійти в землю Канаанську. І прийшли в Канаан землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","І пройшов Аврам землю до врочища Сихема, до дубрави Море́, Канаанеї ж тодї жили в тїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","І явивсь тодї Господь Аврамові, і рече йому: Потомкам твоїм надїлю землю сю. І спорудив там він жертівника Господеві, що явивсь йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","І двинув звідти в гори, на восток ід Бетелю, і напяв намет свій на захід сонця від Бетеля, а від Гая на востоцї, і спорудив там жертівника Господеві, і призвав імя Господнє. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","І подававсь Аврам усе далїй та далїй, простуючи на полуднє. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","І сталась голоднеча в тїй землї, і спустивсь Аврам у Египет на пробуваннє таменькі, бо тяжка була вона в тїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Сталося ж, як наближавсь до входу в Египет, рече він Сарі, жінцї своїй: Оце ж я знаю, що ти молодиця гарна. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","От, як Египтяне тебе побачять, дак і казати муть: Се жінка його, та й убють мене, тебе ж оставлять живою. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Кажи ж, що ти менї сестра, щоб добре менї було задля тебе. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","І сталось, як прийшов Аврам у Египет, от і вбачали Египтяне, що жінка його була молодиця гарна дуже. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","І як побачили її врядовики Фараонові, дак вихваляли перед Фараоном, і взято молодицю в палати Фараонові. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","І з Аврамом обійшовся він добре задля неї, і надїлено його вівцями й волами, ослами й рабами, рабинями й ослицями й верблюдами. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Та вдарив Господь Фараона й дом його тяжкими язвами задля Сари, жінки Аврамовоі. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","І прикликав Фараон Аврама та й каже: Що се вдїяв єси менї? Чом не сказав єси менї, що вона жінка тобі? ");
INSERT INTO ukr1871_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Про що певнив єси: Вона сестра менї? Я й узяв її собі за жінку. Тепер же ось тобі жінка твоя; возьми її та й ійди собі. ");
INSERT INTO ukr1871_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","І повелїв Фараон людям своїм, щоб випроводили його й жінку його і усе, що було його. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","І зійшов же Аврам геть із Египту з жінкою своєю й усїм, що мав, і Лот із ним, на полуднє. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","І був Аврам богатий вельми на скотину, на срібло й на золото. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","І ходив мандрівками своїми все далїй і далїй із полуденньої землї до Бетеля, аж до того місця, де був його намет перше між Бетелем та Гаєм, ");
INSERT INTO ukr1871_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","На те врочище, де спорудив жертівника вперве. І призвав там Аврам імя Господнє. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","І в Лота, що ходив з Аврамом, були й вівцї і товар і намети. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","І не вмішчала їх земля, щоб їм жити вкупі; бо майно їх було велике, так що не можна було жити вкупі. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","І була звяга між чабанами скоту Аврамового і між чабанами скоту Лотового. Канаанеї ж і Ферезії тодї жили на землї тїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Рече ж Аврам Лотові: Нехай не буде звяги між мною й тобою і між чабанами моїми та чабанами твоїми: бо ми брати. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Хиба ж не вся земля перед тобою? Відлучись від мене: коли ти налїво, я направо; коли ж ти направо, я налїво. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","І звівши Лот очі свої, побачив усю околицю Йорданську, що перше нїж зруйнував Господь Содому й Гоморру, вся до Сигора наповнена була водою, як сад Господень і як земля Египецька, ");
INSERT INTO ukr1871_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","І вибрав собі Лот усю околицю Йорданську, і відїйшов Лот ід востоку, і розлучився кожен із братом своїм. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Аврам осївся в землї Канаанській, а Лот осївся в городах околишнїх, і двинув з наметом своїм до Содому. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Люде ж Содомські та були злющі й грішні перед Господом вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Господь же рече Аврамові після того, як Лот розлучивсь із ним: Позирни очима твоїми, та поглянь од місця, де ти тепер, ід півночі, ід полудню, ід востоку, ід заходу. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Бо всю землю, що ти вбачаєш, тобі оддам, і потомкам твоїм навіки. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","І вчиню потомки твої, як пісок земляний; коли хто зможе злїчити пісок земляний, то й потомки твої злїчить. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Уставши, пройди землю в довжину і в ширину її; бо тобі оддам її. ");
INSERT INTO ukr1871_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","І відселившись Аврам, прийшов та й осївсь коло Мамрієвого дуба, що був у Гебронї, та й спорудив там жертівника Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Сталося ж за часів Амрафела царя Синеярського, і Арійоха, царя Еллазарського, Кедорлайомера, царя Еламського, і Тидала, царя Гоїмського, ");
INSERT INTO ukr1871_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Що вчинили вони рать із Берою, царем Содомським, і з Бирсою, царем Гоморським, і з Синабом, царем Адамським, і з Семебером, царем Зебоїмським, і з царем Белїйським, се єсть Сигорським. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Всї вони змовились ізійтись на Сиддим-долинї, се єсть теперенькі Море Солоне. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Дванайцять год були вони підневолені Кедорлайомерові, а в чотирнайцятому роцї відступили. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","І прийшли в чотирнайцятому роцї Кедорлайомер і царі, що були з ним, та й побили Рефаїмів ув Астарот Карнаїмі, а Сусїїв у Гамі, а Еміїв на Кириятаїм-долинї, ");
INSERT INTO ukr1871_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","А Горіїв на їх Сеїр-горах, до Ель-Парана, що лежить на захід соньця від пустині. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","І повернули звідти та й дойшли до Ен-Мишпата, се Кадес, і звоювали всю землю Амалекиїв та Аморіїв, що жили у Газазон-Тамарі. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Вийшов же царь Содомський, і царь Гоморський, і царь Адмейський, і царь Зебоїмський, і царь Белїйський чи Сигорський, та й постали проти них на Сиддим-долинї: ");
INSERT INTO ukr1871_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Проти Кедорлайомера, царя Еламського, та Тидала, царя Гоїмського, та Амрафела, царя Синеярського, та Арійоха, царя Еллазарського, чотири царі проти пятёх, ");
INSERT INTO ukr1871_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","На Сиддим же долинї та було багацько ям. І побігли царі Содомський та Гоморський та й попадали туди, а ті, що зістались, побігли в гори. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","І позабирали вони все добро Содомське й Гоморське й усї харчі їх та й пійшли звідти. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","І взяли Лота, сина брата Аврамового, що жив у Содомі, та й рушили звідти. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Аж ось прийшов один, що втїк, та й сказав Аврамові Євреєві, що жив коло дубів Мамрія Аморієнка, брата Єсколового та Анерового, сї ж були союзники Аврамові. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Чуючи ж Аврам, що його небожа зайнято в полонь, уворужив своїх сьвідомих кметїв, що породились у його в господї, три сотнї і восїмнайцятеро, та й двинув нагоньця до Дану. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","І роздїливсь, він і його кметї, на купи, та й напав на їх у ночі і побив їх, і вганяв за ними аж до Хоби, що лежить на півнїч од Дамаска. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","І вернув усе майно їх, і Лота, небожа свого, вернув і майно його, і жінок і кметї. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Вийшов же царь Содомський на зустріч йому, після того як вернувсь, подужавши Кедорлайомера й царів, що були з ним, на Саве-долину, се долина Царська. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","А Мелхизедек, царь Салемський, винїс хлїб і вино; був же він сьвященник Бога вишнього. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","І благословив його, і рече: Благословен ти, Авраме, від всевишнього Бога, Владики неба і землї! ");
INSERT INTO ukr1871_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","І благословен Бог всевишнїй, що подав тобі у руки ворогів твоїх запеклих! Аврам дав йому десятую часть із всього. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Каже ж і царь Содомський Аврамові: Оддай менї кметї, майно ж возьми собі. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Рече ж Аврам до царя Содомського: Здіймаю руку мою до Господа Бога вишнього, що сотворив небо й землю: ");
INSERT INTO ukr1871_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","І нитки й ременя обувнього не возьму з усього твого, щоб не сказав: Я збогатив Аврама. ");
INSERT INTO ukr1871_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Нїчогісїнько менї, опріч єдино, що поїли кметї мої та кромі частини мужів, що ходили зо мною: Анер, Єшколь і Мамрій нехай беруть свою частину. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Після того, як се сталось, було слово Господнє до Аврама у видїнню: Не бійсь, Авраме; я тобі щит, нагорода твоя велика буде вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Рече ж Аврам: Владико Господе, що менї даси? одпускаюсь я бездїтен, а наслїдник моєї худоби сей Дамашчанець Елиєзер. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","І рече Аврам: Не дав єси менї потомства, дак раб моєї господи наслїдник мій буде. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","І знов слово Господнє було до його і глаголе: Не буде він твоїм наслїдником, а той хто вийде з тебе, той буде наслїдник тобі. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","І вивів його з намета і рече: Позирни на небо та злїчи зорі, коли зможеш злїчити їх. І рече: Такі будуть потомки твої. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","І поняв Аврам віри Господеві, і він полїчив йому те за праведність. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Рече ж до його: Я Господь, що вивів тебе із Ура Халдейського, щоб оддати тобі землю сю в наслїддє, наслїдствовати. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","І рече: Владико Господе, почому знати му, що наслїдити му її? ");
INSERT INTO ukr1871_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Рече ж до його: Возьми менї телицю трилїтню, та козу трилїтню, та барана трохлїтка, та горлицю, та голубеня. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Узяв же він усе те та й порозтинав пополам, і положив їх противолично одну частину до другої, а птиць не розтинав. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Злетїлося ж птаство на труп розтятий; Аврам же зганяв його. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","А як заходило соньце твердий сон обняв Аврама, і страх у темряві великий напав на його. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","І речено було до Аврама: Знаючи знай, що переселятись буде потомство в землю не свою, і підневолять його, і тїснити муть його чотири ста лїт. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Народові ж тому, що йому будуть підневолені, дам присуд я, а потім ізийдуть геть із майном великим. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ти ж одідеш до отцїв твоїх з упокоєм, і поховають тебе в старощах добрих. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","У четвертому ж родї вернуться сюди; не сповнились бо гріхи Аморіїв і досї. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Як же було соньце на западї та згусла темрява тодї, наче піч задимувала, і поломя огняне пройшло між розтятими частинами. ");
INSERT INTO ukr1871_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","У той день завітував Господь з Аврамом завіт, глаголючи: Потомству твойму дам землю сю від ріки Египецької до ріки великої, ріки Евфрата: ");
INSERT INTO ukr1871_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Кеніїв, і Кенесіїв, і Кедмоніїв, ");
INSERT INTO ukr1871_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","І Хетіїв, і Ферезіїв, і Рефаїв, ");
INSERT INTO ukr1871_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","І Аморіїв, і Кананеїв, і Гергесіїв, і Ебусеїв ");
INSERT INTO ukr1871_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Сара ж Аврамова жінка да не роджала йому. Була ж у неї рабиня Египтянка на імя Агара. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","І рече Сара до Аврама: Се зачинив мене Господь, щоб не роджати; дак увійди до рабинї моєї, щоб у мене були дїти від неї. І послухав Аврам гласу Сариного. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","І взяла Сара, Аврамова жена, Агару, рабиню свою Египтянку, після того, як Аврам седїв осадою десять років у землї Канаанській, та й оддала її за жінку мужові свойму Аврамові. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","І ввійшов до Агари, і завагонїла. Як же почулась вона, що завагонїла, почала зневажати господиню свою. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","І рече Сара до Аврама: Зневага менї від тебе. Вона ж почуваючись вагітною, зневажає мене. Суди Бог між мною й тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Рече ж Аврам до Сари: Ось рабиня твоя в руках у тебе. Твори їй по твоїй вподобі. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Узялась тодї жорстко за неї Сара, і зійшла та з очей у неї. І знайшов її ангел Господень коло криницї в пустинї, по дорозї в Сур. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","І рече: Агаро, Сарина рабине, звідкіля прийшла єси і куди хочеш ійти? І каже: Зійшла з очей Сари, господинї моєї. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Рече ж їй ангел Господень: Вернись до господинї твоєї та покорися під руку її. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Рече ж їй ангел Господень: Намножу я потомство твоє безлїч. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","І рече їй ангел Господень: Оце ходиш важкою, і вродиш сина, і даси йому імя Ізмаель; бо Господь почув тїсноту твою. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Сей буде дикий чоловік. Рука його проти всякого чоловіка, і всякого чоловіка рука проти його, і седїти ме він у всїх родичів своїх на шиї. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","І дала вона імя Господеві, що глаголав до неї: Бог бачений. Бо казала: Я бачила того, хто явивсь менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Тим прозвано криницю ту: „Криницею Живого, що мене бачить.‟ Се між Кадесом і Баредом. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","І вродила Агара Аврамові сина, і дав Аврам імя синові, що вродила йому Агара, Ізмаель. ");
INSERT INTO ukr1871_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Аврамові ж було вісїмдесять і шість год віку, як Агара вродила Авраму Ізмаеля. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","А як було Аврамові девятьдесять і девять год віку, явивсь Господь Аврамові, і рече йому: Я Бог всемогущий. Ходи передо мною і бувай щирий і праведен. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","І вчиню заповіт мїй проміж мною й тобою, і намножу тобі потомків безлїч. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","І впав Аврам ниць на лице своє, і рече йому Бог і глаголе: ");
INSERT INTO ukr1871_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Се я, що вчинив заповіт мій з тобою, що будеш ти праотець купи народів. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","І не зватимуть уже тебе на імя Аврам, а буде імя твоє Авраам, бо я вчинив тебе отцем купи народів. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","І зрощу тебе вельми велико і вчиню тебе народами, і царі виходити муть із тебе. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","І поставлю мій заповіт між мною й тобою, і потомками твоїми по тобі в їх родах про віковічний заповіт, щоб менї бути Богом тобі і потомкам твоїм по тобі. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","І дам тобі і потомству твойму по тобі землю, що в нїй тепер чужениця єси, всю Канаан землю на віковічню державу, і буду їх Богом. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","І рече Бог Авраамові: Ти ж заповіт мій певнити меш, ти й потомки твої по тобі в їх роди. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ось заповіт, що ви певнити мете між мною й вами й потомством твоїм по тобі. Усяке хлопя між вами мусить бути обрізано. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Обрізувати метеся ж ви на тїлї вашої передньої шкірки, і се буде ознакою заповіту між мною й вами. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","І в вісїм день віку мусить бути кожне хлопя обрізане проміж вами з роду в рід, і той хто родивсь у господї, і той, кого куплено за гроші, що не з твого роду. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Хто родивсь у твоїй господї і кого куплено за гроші, повинен бути обрізаний; і сим робом заповіт мій буде на вашому тїлї про заповіт віковічний. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","А необрізаний музького полу, такий що тїло його передньої шкірки необрізане, такого викоренити з народу його; він поламав заповіт мій. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","І рече Бог Авраамові далїй: Жену твою Сару не мусиш уже звати на імя Сара, а Сарра буде імя її. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","І благословлю її, і дам тобі сина від неї, і буде вона народами, царі в народів із неї будуть. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","І впав Авраам ниць і осьміхнувсь; і рече в думцї своїй: Столітнёму б то появити сина? І як би то Сарра девятьдесятолїтна да вродила? ");
INSERT INTO ukr1871_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Рече ж Авраам до Бога: Нехай хоч Ізмаель живе перед тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Рече ж Бог до Авраама: Стеменно, Сарра жена твоя вродить сина тобі, і наречеш імя йому Ізаак, і поставлю завіт мій із ним про завіт вічнїй із потомством його по йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Тай про Ізмаеля вислухав я тебе, і ось благословлю його і вирошчу його і намножу його велико: дванайцять князів появить, і дам йому бути народом великим. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Завіт же мій поставлю з Ізааком, що тобі вродить Сарра о ʼцїй самій добі, в лїто друге. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Скіньчив же Бог слово до його, і знявся Бог од Авраама. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","І взяв Авраам Ізмаеля, сина свого, і всю доморослу челядь свою, і всїх купленних за гроші, і ввесь музький пол зміж людей господи Авраамової, тай пообрізував крайню плоть їх того самого дня, як промовив йому Бог. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Авраамові ж було девятьдесять і девять год, як обрізано крайню плоть йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","А Ізмаелеві, синові його, було тринайцять літ, як обрізано крайню плоть його. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Того ж самого дня обрізано Авраама й сина його Ізмаеля. ");
INSERT INTO ukr1871_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","І з ним обрізані були всї чоловіки в господї в його, і ті що понароджувались у домівцї в його, і понакуповувані за срібло в інороднїх народів. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Явився ж йому Бог коло дубравини Мамре, як седїв він перед дверима наметовими о полуднї. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Споглянувши ж очима своїми, бачить, стоїть перед ним троє чоловіків; побачивши їх метнеться зустріч їм од наметових дверей своїх, тай поклонився до землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","І рече: Господе! коли я знайшов ласку в очах твоїх, не мини раба твого. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Нехай принесуть води та помиють ноги вам, та прохолодїтесь під деревом. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Я ж принесу наїдку, щоб ви попоїли, а потїм і верстати мете свою путь, що звернули з неї до раба вашого. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","І метнеться Авраам у шатро до Сарри, тай каже їй: Заміси хутенько три сита пшенишного борошна та спечи коржів. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","І метнеться Авраам до корів, та й узяв телятко нїжне й добре, і оддав його слузї, а той скоренько впорав його. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","І взяв сиру й молока да телятко, що наготовив, та й поставив перед ними; сам же стояв під деревом, як вони їли. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","І промовили до його: Де Сарра, жена твоя? Ось у шатрі. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Рече ж один: Вернусь оце до тебе через год о сїй добі, і вродить сина Сарра, жена твоя. Сарра ж почула під наметовими дверми позад його. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Авраам же і Сарра були старі, повбивались у лїта, і перестало в Сарри звичайне жіноцьке. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Осьміхнулася ж Сарра сама собі, думаючи: Оце б то звянувши та здобутись на таку втїху? Пан же мій старенький. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","І рече Господь Авраамові: Чого всьміхнулась Сарра сама собі, говорючи: Чи справдї ж бо менї вродити? я же собі стара вже. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Хиба є що неможливе у Бога? О сїй добі вернусь до тебе через год, і буде в Сарри син. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Сарра ж і не призналась, говорючи: Я не сьміялась. Бо вона злякалась. І рече їй: Нї бо, сьміялась. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Піднявшися ж ізвідти чоловіки, повернули на Содом. Авраам же йшов із ними, проводючи їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Господь же рече: Чи втаю від Авраама, раба мого, що я творю? ");
INSERT INTO ukr1871_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Та ж Авраам буде народом великим, і потужним, і благословляться в йому всї народи земнії. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Знаю бо, що накаже синам своїм і господї своїй по собі, щоб хранили путї Господнї, творючи правду і суд, щоб справдив на Авраамові Господь усьо, що глаголав до його. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Рече ж Господь: Квилять велико до мене про Содом та Гоморру, і гріхи їх тяжкі вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Зійду ж та позирну, чи так воно дїється, як до мене голосять, чи нї, щоб знати. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","І повернулись ізвідти чоловіки до Содому, Авраам же ще стояв перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","І приступить Авраам ближче й рече: Дак оце ти хочеш погубити й безвинних із винуватими? ");
INSERT INTO ukr1871_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Може там знайдеться пятьдесять безвинних у городї. Чи то ж схочеш ти й їх погубити, і не помилуєш усього міста задля пятидесятьох, коли там будуть? ");
INSERT INTO ukr1871_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Нї бо, не чини по глаголу сему, щоб убити праведника з нечестивим, і щоб у тебе було праведнику так, як нечестивому. Нї бо нї! Судячи суд у сїй землї, як тобі не вчинити правди? ");
INSERT INTO ukr1871_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Рече ж Господь: Коли буде в Содомі пятьдесять праведників у городї, помилую ввесь город і все місто задля їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","І рече відказуючи Авраам: Оце завзявсь я промовляти до Господа мого, я ж земля і порох. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Коли ж поменьшає праведників до сорока й пяти, чи вже ж бо погубиш через пятьох увесь город? І рече: Не погублю, коли знайду тамо сорок і пять. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","І завзявсь іще промовляти до його та й каже: Коли ж знайдеться таменьки сорок? І рече: не погублю й ради сорока. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Що ж Господе, коли промовлю: А як знайдеться таменьки тільки трийцять? І рече: Не погублю й тридесятьох ради. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","І промовив: Оце ж наваживсь говорити до Господа: Коли ж знайдеться таменьки двайцятеро? І рече: Не погублю, коли знайдеться тамо двайцять. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","І каже: Що ж, Господе, коли промовлю ще раз: Коли ж знайдеться таменьки десятеро? І рече: Не погублю і десятьох ради. ");
INSERT INTO ukr1871_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Одійшов же Господь, переставши глаголати до Авраама. І вернувсь Авраам на місце своє. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Прийшли ж обидва ангели в Содом у вечорі. Лот же седїв коло царини Содомської. Побачивши ж Лот, устав на зустріч їм, тай поклонився лицем до землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","І рече: Оце ж, панове, завернїть у домівку раба вашого та спочиньте і ноги собі помийте, а як обутріє, верстати мете путь свою. Вони ж рекли: Нї ночуватимемо на улицї. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","І примусив їх, і ввійшли в господу його. І вчинив їм учту, і опрісноків напік їм, і попоїли. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Перед облягами ж обступили дом городяне Содомські, від молодика, тай до дїда, увесь народ укупі з усїх кутків. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","І гукали Лотові, і казали до його: Де люде, що ввійшли до тебе на ніч? Виведи їх до нас, розпізнаємо їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Вийшов же до них Лот на рундук, і зачинив двері за собою. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Каже ж до них: Нї, браттє! Не чинїте бо ледарства! ");
INSERT INTO ukr1871_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Є в мене дві дочцї, що не взнали мужа; виведу їх до вас, і робіть їм що любо вам, тільки людям сим не чинїте обиди; увійшли бо під стелю дому мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Вони ж кажуть йому: Геть із відсї! Прийшов сюди жити, та хочеш і суд судити. Ось ми ж навчимо тебе, ще лучче, нїж їх. І насильствовали чоловіка того, Лота, вельми, і підступили розбити двері. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Та простягли мужі руки й утягли Лота до себе в будівлю, а двері в будівлї засунули. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","На людей же, що були під дверима в будинку вдарили слїпотою, від мала тай до велика, і марно шукали вони дверей. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Промовили ж мужі до Лота: Чи єсть у тебе тута зятї або сини твої або дочки твої? Або коли хто инший єсть у тебе в городї, всїх виведи із міста сього! ");
INSERT INTO ukr1871_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Бо ми погубимо се місто; бо знявсь угору лемент про його перед Господом, і послав нас Господь вигубити його. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Вийшов же Лот і промовив до зятїв своїх, що побрали дочки його, і рече: Підіймайтесь та виходьте з міста сього; бо погубляє Господь город. Та здавалось, що жартує перед зятьми своїми. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Як же зачервонїв ранок, принукали ангели Лота, глаголючи: Уставай, бери жену твою й двох дочок твоїх, що при тобі, та одходь, щоб і тобі не погибнути з беззаконними городянами. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","І стуманїв він, і взяли ангели за руку його, і за руку жінку його, і за руки двох дочок його; бо пощадив їх Господь, тай вивели їх, і поставили за городом. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","І як повиводили їх геть, рече: Спасай твою душу. Не озирайсь, і не зупиняйся нїде в усїй околицї сїй. У гори втїкай, щоб і тобі не згинути. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Рече ж до них Лот: Благаю тебе, пане! ");
INSERT INTO ukr1871_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Що знайшов раб твій ласку в очах твоїх, і велика милость твоя, що показав до мене, що вирятував душу мою, я ж не здолїю рятуватись у горах, щоб не наздогнала мене лиха година, та не вмерти менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","А, споглянь городок сей близько, побіжу я туди; він маленький, дак і душа моя сохраниться. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","І рече йому: Оце ж я зглянусь на тебе і в сьому, що не погублю городка, що про його мовляв еси. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Хапайся ж рятуватись тамо; не можу бо чинити нїчого, докіль увійдеш туди. Тим і проложено містечку тому прізвище Сигор. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Сонце зійшло вже над землю, як Лот увійшов у Сигор. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","І бурхонув Господь на Содом та Гоморру сїркою та поломєм од Господа з небес, ");
INSERT INTO ukr1871_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","І перевертав городи сї і всю околицю, і всїх осадників городських, і все, що росло з землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","І озирнулась жінка його позад його, та й обернулась у стовна соляного. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Устав же Авраам у ранцї, пійшов на місце, де стояв перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","І позирнув на Содом і Гоморру, і на околицю, аж се здіймається дим од землї, як дим із печі. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","І було, як руйновав Бог в українї тій городи, спогадав Бог Авраама, і вислав Лота з руйновища, як руйновав городи, що жив у них Лот. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Зійшов же Лот із Сигори, та й осївсь на горі сам і дві дочки його; боявся бо жити в Сигорі, та й оселивсь у печері сам і дочки його з ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Озветься ж старша до меньшої: Панотець наш старий собі, і нема нїкого на землї, щоб увійшов до нас всьогосьвітнїм звичаєм. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ходи сюди лишень, упиймо вином панотця нашого, та переспимо з ним, та й переховаємо рід від панотця нашого. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Упоїли ж отця свого вином тієї ночі, і ввійшовши старша, переспала з отцем своїм тієї ночі. І не постеріг він, як вона переспала, і як устала. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Було ж у ранцї, що каже старша меньшій: Оце ж переспала я вчора з панотцем нашим. Упоїмо його вином і сієї ночі, а ти ввійшовши, переспи з ним, та й переховаймо від панотця нашого рід наш. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Упоїли ж і тієї ночі отця свого вином, і ввійшовши меньша, переспала з отцем своїм. І не постеріг він, як переспала, і як устала. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","І завагонїли обидві дочки Лотові тодї від отця свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","І вродила старша сина, і дала імя йому Моав. Се праотець Моавіїв по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Уродила ж і меньша сина, і дала імя йому: Бен-Аммій. Се праотець Аммоніїв по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","І відкочував Авраам ізвідти до землї полуденньої, та й оселивсь між Кадесом і Суром, і якийсь час пробував у Герарі. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Про жінку ж свою Сарру казав Авраам, що сестра вона менї. Абимелех же, царь Герарський, післав та й взяв Сарру. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","І прийшов Бог до Абимелеха в ночі вві снї, і рече йому: Оце ти вмреш за сю молодицю, що взяв єси; вона ж мужня жена. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Абимелех же не приторкнувсь до її, та й каже: Господе, чи то ж погубиш безвинний рід? ");
INSERT INTO ukr1871_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Хиба ж не сам він казав менї: Вона сестра менї? І вона менї казала: Він брат менї. У чистотї серця мого і в безвинностї рук моїх учинив я се. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Рече ж йому Бог у снї: І я знаю, що в чистотї серця твого і в безвинностї рук твоїх учинив єси се, тим і впинив тебе від гріха проти мене, і не попустив тебе коснутись її. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Тепер же оддай жену мужу, бо він пророк, і помолиться за тебе, і жити меш. Як же не віддаси, дак знай, що вмреш сам і все твоє. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","І встав рано вранцї Абимелех і призвав усї кметї свої, та й промовив усї словеса сїї в уші їх, і полякались усї люде вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","І призвав Абимелех Авраама, та й промовив до його: Що вдїяв єси менї? І чим провинив я тобі, що навів єси на мене й царство моє гріх великий? Дїло таке, що нїхто не чинив, укоїв єси менї: ");
INSERT INTO ukr1871_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","І промовив Абимелех до Авраама: Що в тебе було на думцї, як чинив єси таке? ");
INSERT INTO ukr1871_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Рече ж Авраам: Думав бо, що нема благочестя на місцї сьому, і вбють мене задля жени моєї. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Отже справдї вона сестра менї по панотцеві, а не по панїматцї, та стала менї женою. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","І було, як вивів мене Бог із отецької домівки моєї, кажу їй: Ось яку правду чинити меш менї: у всякому містї, куди прийдемо, там кажи про мене, що се брат мій. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Узав же Абимелех вівцї і бички, і раби й рабинї, та й дав Авраамові, і віддав йому Сарру. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","І промовив Абимелех Авраамові: Оце земля моя перед тобою; де б тобі нї було до вподоби, оселяйся. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","До Сарри ж промовив: Оце дав я братові твойму тисячу срібняків, се буде тобі чесна намітка до лиця твого, і про все, що було з тобою і з усїма твоїми, в усьому будеш оправдана. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Помолився ж Авраам Богу, і вигоїв Бог Абимелеха, і жену його, і рабинї його, і почали роджати. ");
INSERT INTO ukr1871_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Бо позамикав був Господь усяку утробу в домівцї в Абимелеха задля Сарри, жінки Авраамової. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","І одвідав Господь Сарру, так як рече, і сотворив Господь Саррі так, як глаголав. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","І завагонївши Сарра, вродила Авраамові сина в старощах того часу, як і глаголав йому Господь. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","І дав Авраам імя синові свойму, що вродивсь йому, що вродила йому Сарра, Ізаак. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Обрізав же Авраам Ізаака, сина свого, у восьмий день, так як заповідав йому Бог. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Авраамові ж було сто год віку, як родивсь йому син його Ізаак. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Рече ж Сарра: Сьміх менї сотворив Господь; хто бо почує, сьміятиметься з мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","І рече: Хто б то сповістив Авраамові, що молоком своїм годувати ме дитину Сарра? Бо в старостї його я родила сина. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","І росло хлопятко, і відлучено його. І зробив Авраам бенкет великий того дня, як одлучено Ізаака. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Як побачила Сарра, що син Агари, Египтянки, насьміхається з Ізаака, ");
INSERT INTO ukr1871_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Каже Авраамові: Прожени сю рабиню й сина її; не наслїдувати ме бо син рабинї сієї з моїм сином Ізааком. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Тяжко ж було чути слово се вельми Авраамові про сина його. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","І рече Бог Авраамові: Нехай не буде тяжке тобі слово про хлопця і про рабиню. У всёму, що рече тобі Сарра, слухай гласу її; бо в Ізаацї наречеться тобі потомство. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Сина ж рабинї сієї народом великим сотворю його; бо насїннє твоє він. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Устав же Авраам у ранцї, і взяв хлїба та бурдюк води та й оддав Агарі, і положив за плечима в неї хлопця, та й одпустив її. Вона ж одійшовши заблудила в Бейер-Себа пустинї. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Не стало ж води в бурдюцї, і покинь вона хлопця під ялиною. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Відойшовши ж сїла навпроти його віддалеки, як би дострелити з лука; каже бо: Нехай не бачу смерти дитини моєї. І седїла навпроти його, та й заголосила. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Почув же Бог плач хлопячий, і кликне ангел Божий Агару з небес, і рече: Що тобі, Агаро? Не турбуйся; почув бо Бог плач хлопячий з місця, де воно тепер. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Устань, та возьми хлопя і держи на руцї твоїй; народом бо великим сотворю його. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","І відкрив Бог очі їй, і побачила криницю з водою, і пійшла й налила бурдюк води, та й напоїла хлопя. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","І був Бог з хлопчиком, і виріс та й оселивсь у степу і був стрілець-лучник. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","І оселивсь у Фаран-степу, і взяла йому мати його жінку із землї Египецької. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Сталося ж того часу, що промовив Абимелех та Пихоль, гетьман війська його, до Авраама, говорючи: Бог з тобою в усьому, що дїєш. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Оце ж клянись менї Богом, що не зрадиш мене, нї дїтей моїх, нї внуків моїх, а по правдї, як прихилен був я до тебе, так і ти будеш до мене, і до землї, де пробуваєш. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","І рече Авраам: Кленусь. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","І докоряв Авраам Абимелеха, за колодязь водяний, що відняли раби Абимелехові. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","І каже йому Абимелех: Не знаю, хто вчинив тобі дїло таке, нї ти менї не оповідав єси, нї я чував, тільки сьогоднї. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","І вилучив Авраам сїм овечок, да товару, та й дав Абимелехові, і вчинили вони обидва умову. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","І поставив Авраам семеро ягниць овечих із отари окроме. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","І каже Абимелех Авраамові: Що се за семеро ягниць, що поставив єси окроме? ");
INSERT INTO ukr1871_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","І рече Авраам: Що семеро сих ягниць візьмеш у мене, нехай будуть менї сьвідоцтвом, що я викопав колодязь сей. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Того й проложено прізвище місцеві тому: Бейер-Себа, колодязь клятьби; бо там клялись обидва. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","І вчинили вони вмову коло колодязя клятьби. Піднявся ж Абимелех та Пихоль, гетьман війська його, та й вернулись у землю Филистимську. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","І посадив Авраам тамариску, і призвав там імя Господа Бога вічного. ");
INSERT INTO ukr1871_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Пробував же Авраам у землї Филистимській час довгий. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","І було по сих речах, що Бог спокушував Авраама, і рече йому: Аврааме, Аврааме! І каже: Ось я! ");
INSERT INTO ukr1871_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","І рече: Возьми сина твого, єдиного твого, що його возлюбив єси, Ізаака, та йди в Морія землю, та й принеси його там у всепаленнє-жертву на одній горі, що тобі речу. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","І встав Авраам рано вранцї та й осїдлав осла свого, та взяв два парубки з собою, та Ізаака сина свого, та наколов дров на всепаленнє, та й рушив до врочища, що про його рече йому Бог. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","На третїй же день позирнув Авраам очима своїми, та й побачив те врочище здалеку. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","І каже Авраам слугам своїм: Седїте тутеньки з ослом, я ж із сином пійдемо аж он туди, та поклонившись і вернемось до вас. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Узяв же Авраам дрова на всепаленнє, та й положив на Ізаака, сина свого; взяв же в руки й огонь і жертівного ножа, та й пійшли обидва вкупі. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Каже ж Ізаак до Авраама, батька свого: Панотче! Він же каже: Що тобі, синку? Каже ж: Ось огонь і дрова, а де ж овеча на всепаленнє? ");
INSERT INTO ukr1871_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Каже ж Авраам: Бог обмислить собі ягня на всепаленнє. І йшли собі обоє вкупі. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Прийшли на врочище, що рече йому Бог, і зробив там Авраам жертівника, і розложив дрова, і звязавши Ізаака, сина свого, положив його на жертівнику зверху на дровах. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","І простїг Авраам руку свою, щоб узяти ножа заколоти сина свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Аж озветься до його ангел Господень і рече: Аврааме, Аврааме! Він же каже: Ось я. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","І рече: Не возложи руки твоєї на хлопя, а нїчогісїнько не чини йому; тепер бо взнав я, що боїшся ти Бога, і не пощадив єси сина твого возлюбленого мене ради. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","І позирнувши Авраам очима своїми побачив, що баран із заду завяз рогами в гущинї. І пійшов Авраам і взяв барана і принїс його на всеспаленнє замість Ізаака сина свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","І приложив Авраам прізвище врочищу тому Єгова-Уре, Господь бачить, як і по сей день говорять: На горі Господа побачять. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","І озветься ангел Господень до Авраама вдруге з небес, ");
INSERT INTO ukr1871_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Глаголючи: Мною самим клявсь я — се Господнє слово — за те, що вчинив єси таку річ, і не пощадив єси сина свого возлюбленого мене ради. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Велико благословлю тебе, і намножу твій рід як зорі небесні, і як пісок узкрай моря, і внаслїдує потомство твоє царини ворогів своїх. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","І благословляться в потомстві твойму всї народи землї, тим що послухав єси голосу мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Вернувся ж Авраам до слуг своїх і рушили вони й пійшли вкупі до Бейер-Себи, і вселивсь Авраам коло колодязя клятьби. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Сталося ж по сїх речах, що зъясовано Абраамові словами: Ось і Милка і вона вродила сини братові твойму Нахорові, ");
INSERT INTO ukr1871_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Уза, перворідня його, та Буса, брата його, та Кемуїла, отця Арамова, ");
INSERT INTO ukr1871_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Та Хеседа, та Газа, та Пидаса, та Ідлафа, та Батуїла. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Батуїл же появив Ребеку. Сих восьмерох уродила Милка Нахорові, братові Авраамовому. ");
INSERT INTO ukr1871_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","І наложниця його, на імя Реюма, ся вродила Тебаха та Гахама та Тегаса та Маяха. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Було ж віку Сарриного сто і двайцять і сїм год. Се года живота Сарриного. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","І вмерла Сарра в Кирят-Арбі. Се Геброн в Канаан землї. Прийшов же Авраам плакати по Саррі да падкувати. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","І встав Авраам од мерця свого, і рече синам Хетовим: ");
INSERT INTO ukr1871_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Пересельник і чужениця я в вас! Дайте ж менї в наслїддє гробовище між вами, щоб менї поховати мерця мого від мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Відказали ж Авраамові сини Хетові говорючи: ");
INSERT INTO ukr1871_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Нї, добродію! Князь від Бога ти єси в нас; вибравши гробовище з наших, поховай мерця твого. Нїхто бо з нас не заборонить гробовища свого тобі, щоб тобі поховати мерця твого таменьки. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Устав же Авраам і вклонився землякам, синам Хетовим. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","І каже до них Авраам і промовив: Коли вам по душі, щоб менї поховати мертве моє від мене, послухайте мене, і мовляйте про мене Ефронові Зогаренкові. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","І нехай поступиться менї печерою Махпеловою, що конець поля його. За повну цїну нехай поступиться менї нею в наслїднє гробовище між вами. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ефрон же седїв посеред синів Хетових. Відказуючи ж Ефрон Хетїянин Авраамові каже так, що чули його сини Хетові і всї, що повиходили до міської царини. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Нї, добродїю! Вислухай мене. Те поле оддаю тобі й печеру, що на йому, перед очима синів народу мого оддаю тобі; поховай мерця твого. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","І поклонивсь Авраам перед земляками, ");
INSERT INTO ukr1871_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","І каже Ефронові в слухи перед усїма земляками: Вислухай ти мене! Гроші за ниву возьми в мене; і поховаю мертве моє таменьки. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Відказав же Ефрон Авраамові: ");
INSERT INTO ukr1871_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Нї, добродїю! Землї тут за чотирі ста секлїв срібла; та що воно між мною й тобою? Ти ж поховай мерця твого. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","І послухав Авраам Ефрона, та й одважив Авраам Ефронові срібло, скільки він казав в слухи перед синами Хетовими, чотирі ста секлїв срібла ходячого в купцїв. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","І стало поле Ефронове в Махпелщинї, що навпроти Мамрійщини, поле й печера на йому з усїма деревами на полї, що було в усїх межах своїх, забезпечене, ");
INSERT INTO ukr1871_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Авраамові в наслїдню державу перед синами Хетовими й перед усїма, що приходили до міської царини. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","І після того поховав Авраам Сарру, жінку свою, в печері Махпелевого поля, навпроти Мамрійщини. Се Геброн у Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Так дісталось Авраамові від синів Хетових поле й печера на йому в наслїдню державу на гробовище. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Авраам же був старий, у лїтах приклонних, і Господь благословив Авраама в усьому. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","І каже Авраам рабові свойму, найстаршому в господї в його, що правив усїм достатком його: Ось положи руку твою під стегно моє. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","І заклену тебе Господом, Богом небесним і Богом земним, що не візьмеш синові мойму жени з дочок Канаанських, що між ними живу. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","А тільки в землю мою, де я родивсь, пійдеш і до роду мого, та й візьмеш жену синові мойму Ізаакові відти. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Каже ж до його раб: Коли б то не схотїла йти молодиця слїдом за мною в землю сю, чи вернути сина твого в землю, що з неї вийшов єси? ");
INSERT INTO ukr1871_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Каже ж до його Авраам: Остерегайся вертати сина мого туди. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Господь, Бог неба й Бог землї, що вивів мене з господи панотця мого із землї, що в нїй родився, той що глаголав менї, і що клявся менї глаголючи: Тобі оддам землю сю й насїнню твойму, той пошле ангела свого перед тобою, дак і візьмеш жену синові мойму Ізаакові звідти. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Коли ж би не схотїла молодиця пійти за тобою, чист будеш од закляття мого; тільки сина мого не вертай туди. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","І положив раб руку свою під стегно Авраамові, панові свойму, та й клявсь йому про сю річ. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","І взяв раб десятеро верблюдів з між верблюд пана свого і з усякого добра в господаря свого, та й пійшов, бо всї добра господаря його були в його руцї, та знявсь і пійшов у Месопотамію, у Нахорів город. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","І поставив верблюди під городом навколїшки коло колодязя водяного надвечір, як виходять жінки брати воду. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","І каже: Господе, Боже пана мого Авраама, погоди менї сьогоднї і сотвори милость панові мойму Авраамові. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Оце я став коло колодязя водяного, дочки ж міських людей виходити муть брати воду. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","І нехай буде дївчина, що їй скажу: Нахили водоносного глека твого напитись менї, і промовить менї: Пий, я й верблюди твої понаповаю, нехай вона буде та, що наготовив рабові твойму Ізаакові, і по сьому відатиму, що сотворив єси милость панові мойму, Авраамові. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","І сталось, перш нїж він промовив, аж ось Ребека й виходить, що родилась Бетуїлові, Милчиному синові, жінки Нахорової, брата ж Авраамового, і держачи водоноса на плечі свойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Дївиця ж була дуже вродлива, дївувала ще, нїхто не взнав її. Війшовши ж до колодязя, сповнила водоноса свого та й ійде вгору. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Побіг же раб на вперейми, та й каже: Дай менї напитись з водоноса твого. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Вона ж каже: Пий, добродїю. І хутенько зняла водоноса на руку, та й дала йому напитись до схочу. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","І напоївши каже: І верблюдам твоїм наливати му докіль понапиваються. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","І хутенько спорожнила водоноса в пійло та й метнулась ізнов до колодязя черпнути води та й улила верблюдам усїм. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Чоловік же придивлявся до неї мовчки, щоб зрозуміти, чи погодив Бог у дорозї йому, чи нї. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Сталося ж, як перестали всї верблюди пити, узяв чоловік каблучку золоту, вагою в пів секля, та двї запинки на руки їй, у десять секлїв ваги. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","І поспитав її та й каже: Чия єси дочка? Скажи менї, чи єсть у панотця твого в господї місце про нас на ночлїги? ");
INSERT INTO ukr1871_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Вона ж каже йому: Дочка я Бетуїлова, сина Милчаного, що його вродила Нахорові. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","І каже йому: І соломи й харчі в нас доволї, і місце є про ночлїги. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","І дякуючи Господу чоловік поклонивсь, ");
INSERT INTO ukr1871_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","І каже: Благословен Господь, Бог пана мого Авраама, що не оставив без милостї своєї й правди пана мого, і менї погодив Господь прибути в домівку брата пана мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","І побігла дївиця і зʼясувала в господї матері своїй сї речі. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ребецї ж доводивсь братом на імя Лабан. І метнеться Лабан до чоловіка до колодязя. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","І сталось, як побачив каблучку й запинки на руках у сестри своєї, і як почув слова Ребечині, сестри своєї, що каже: Так мовляв менї чоловік, дак прийшов Лабан до чоловіка, аж він стоїть при верблюдах коло колодязя. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","І каже: Увійди, благословенний од Господа. Чого стоїш ізнадвору? Я ж наготовив господу й місце про верблюди. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","І ввійшов чоловік у господу, і порозсїдлував верблюди, і дав Лабан соломи й сїна верблюдам і води помити ноги йому і людям, що були з ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","І поставив перед ними наїдки. Він же каже: Не їсти му, поки не виповню мого посольства. І каже: Говори. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","І говорить він: Раб Авраамів я. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Господь же благословив пана мого велико, і зробивсь він великим; і дав йому товар і отари, і срібло й золото, і раби і рабинї, і верблюди й осли. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","І вродила Сарра, жона пана мого, сина панові мойму, як була стара, і оддав йому все, що мав. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","І закляв мене пан мій говорючи: Не візьмеш ти жени синові мойму зміж дочок Кананейських, що я седжу в їх землї, ");
INSERT INTO ukr1871_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","А в госпо́ду панотця мого пійдеш і до роду мого, і візьмеш мойму синові жону звідти. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Сказав же я панові мойму: А може не схоче молодиця зі мною йти. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Каже тодї менї: Господь, що перед ним ходжу, пошле ангела свого з тобою, і погодить у дорозї твоїй, і візьмеш ти жену синові мойму з мого роду, і з дому панотця мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Тодї будеш чист од заклинання мого; коли бо дійдеш до родини моєї, і не дадуть тобі, будеш чист од заклинання мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","І прийшовши сьогоднї до колодязя, казав я: Господе, Боже пана мого Авраама, коли погодив єси в дорозї моїй, що її оце верстаю, ");
INSERT INTO ukr1871_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ось я став коло колодязя водного, і дочки городянські виходять брати воду, і коли буде дївиця, що ій промовлю: Дай менї напитись із водоноса твого трохи води, ");
INSERT INTO ukr1871_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","І скаже менї: І ти пий, і верблюдам твоїм вільлю, нехай ся буде жена, що наготовив Господь мого пана синові. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","І перш, нїж я промовив у серцї мойму, вже Ребека йшла з водоносом на плечі, і спустилась вона до колодязя, і набрала води. І сказав я їй: Дай, будь ласко, напитись менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","І хутенько зняла вона водоноса свого із себе на руку, та й каже: Пий, і верблюди твої понаповаю. От я напивсь і верблюди мої понаповала. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","І поспитав її, і промовив: Чия дочка єси, повідай менї. Вона ж каже: Дочка я Бетуїла Нахоренка, що вродила йому Милка. І дав я їй каблучку і запинки на руки її. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","І дякуючи поклонивсь Господу, і благословив Господа Бога пана мого, Авраама, що погодив менї в дорозї праведній, узяти дочку в брата панового синові його. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Оце ж, коли ви сотворите милость і правду до пана мого, повідайте менї, щоб я повернувсь або праворуч, або лїворуч. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Відказуючи ж Лабан та Бетуїл сказали: Від Господа прийшло се дїло. Не зможемо тобі сказати проти нї лихого, нї доброго. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ось, Ребека перед тобою, возьми її та й піди, і нехай буде вона жоною синові пана твого, яко же глаголав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","І сталось, як почув раб Авраамів словеса сї, поклонився до землї Господу. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","І повносив раб сосуди золоті і срібляні, і сукнї, та оддав Ребецї, і подав гостинцї братові її й матері її. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","І їли й пили, і він і чоловіки, що були з ним, та опочили, і повставали в ранцї, і каже: Відпустїте мене до пана мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Промовили ж браттє її й мати її: Нехай пробуде дївиця з нами з десяток день, а потім і пійде. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Він же каже до них: Не держіте мене. Господь погодив у дорозї менї; мушу йти до пана мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Вони ж сказали: Прикличмо дївицю, та й спитаймо її з уст її. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","І прикликали Ребеку, і казали їй: Чи пійдеш з чоловіком сим? Вона ж каже: Пійду. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","І відпустили Ребеку, сестру свою, і мамку її, і раба Авраамового, і хто з ним були. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","І благословили Ребеку, і промовили до неї: Нехай же родяться від тебе, сестро наша, тисячі тисяч, і потомство твоє нехай підгортає під себе царини ворогів твоїх! ");
INSERT INTO ukr1871_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Уставши ж Ребека й рабинї її посїдали на верблюди, та й пішли з чоловіком. І взяв раб Ребеку, та й пішов. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ізаак же прийшов з Бейер-Лахай-Рої; жив бо він у землї полуденнїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Вийшов же над вечір Ізаак на поле, розігнати думки. І позирне очима своїми, та й бачить, ідуть верблюда. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","І позирнувши Ребека очима своїми, побачила Ізаака та й ізскочила з верблюда. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","І каже рабові: Хто сей чоловік, що йде по полю на зустріч нам? Каже ж раб: Се пан мій; вона узявши намітку, закуталась. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","І повідав раб Ізаакові все, що вчинив. ");
INSERT INTO ukr1871_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Увійшов же Ізаак у намет матері своєї, і взяв Ребеку, і стала йому жінкою, і влюбив її, і втїшивсь Ізаак по Саррі, матері своїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Узяв же Авраам ізнов жену, на імя Хеттура. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Вродила ж вона йому Зимрана, Йоксана, та Медана, та Мадияна, та Ішбака, та Шуаха. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Йоксан же появив Себу та Дедана. Сини ж Деданові були Ассурим, та Летусим, та Леюмим. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Сини ж Мадиянові були: Єфа, та Єфер, та Ганох, та Абида, та Єльдага. Всї цї були сини Хеттурині. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Оддав же Авраам усе, що мав Ізаакові. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Синам же наложниць своїх, що були в Авраама, дав Авраам подарунки, і відпустив їх од Ізаака, сина свого, ще за живота свого, на схід соньця, у землю восточню. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Се ж лїта віку Авраамового, що прожив: сто і сїмдесять і пять років. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","І ослабши вмер Авраам у старощах добрих, старим, повним лїт, і прилучився до людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","І поховали його Ізаак та Ізмаїль, два сини його, в печері Макпеловій, на полї Єфрона Зогаренка, Хетиянина, що проти Мамре, ");
INSERT INTO ukr1871_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","На полї тому, що купив Авраам у синів Хетових. Там поховали Авраама й Сарру, жену його. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Сталося ж по смертї Авраамовій, благословив Бог Ізаака, і вселивсь Ізаак при колодязї Бейер-Лахай-Рої. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Се ж постань Ізмаїля, сина Авраамового, що вродила Агара Египтянка, рабиня Саррина, Авраамові. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","І се ймення синів Ізмаїлевих по родоводам їх: первенець Ізмаїлів Набайот та Кедар, та Адбеєль, та Мивсам. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Та Мисма, та Дума, та Масса, ");
INSERT INTO ukr1871_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Та Хадад, та Тема, та Єтур, та Нафис, та Кедма. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Се сини Ізмаїлеві, а се ймення їх по шатрах їх, і селах їх: дванайцять князїв по колїнах їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","А се лїта живота Ізмаїлевого: сто і трийцять і сїм лїт. І ослабши вмер, і прилучивсь до роду свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Вселився ж від Гавили до Сура, що проти Египту, як ідеш до Ассуру. Перед лицем усїх братїв своїх вселився. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","А се постань Ізаака, сина Авраамового. Авраам появив Ізаака. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Було ж Ізаакові сорок лїт, як узяв Ребеку, дочку Бетуїла, Арамянина з Мезопотамиї, сестру Лабана, Арамянина, собі за жінку. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Молився Ізаак Господеві про жену свою, бо неплідна була. Послухав же його Бог, і завагонїла Ребека, жінка його. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Борикалися ж младенцї в їй, і каже: Коли так менї має бути, про що менї се? І пїйшла поспитати Господа, ");
INSERT INTO ukr1871_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","І рече їй Господь: Два народи в тебе в чреві; два народи будуть, як породиш, воюватись. Візьме гору старший, та підстаршому він буде послугом служити. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","І сповнилися днї родити їй, аж се були близнята в утробї її. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Вийшов же син первенець червоний, увесь наче кожа косматий; і дала імя йому Езав. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","А потім вийшов брат його; рука ж його держалась за пяту Езавову, і дала імя йому Яков. Ізаакові ж було шістьдесять лїт, як родила їх Ребека. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Повиростали ж молодоки, і був Езав чоловік умілий ловити, степовий. Яков же був чоловік тихий, що седїв у домівцї. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","І влюбив Ізаак Езава; бо ловитва його була по смаку йому. Ребека ж любила Якова. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Зварив же Яков кулешику, і прийшов Езав з поля знеможений. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","І каже Езав Якову: Нагодуй мене вареним сочивом сим червоним; бо я знемігся. Тим і дано прізвище йому Єдом. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","І каже Яков Езавові: Продай менї зараз первеньство своє. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Каже ж Езав: Ох! мушу вмерти; про що ж менї се первеньство? ");
INSERT INTO ukr1871_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","І каже Яков йому: Кляннись менї зараз і клявсь йому. І продав Езав Якову первеньство своє. ");
INSERT INTO ukr1871_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Яков же дав Езавові хлїба й вариво сочевицї. Попоїв же й напивсь, і вставши пійшов геть. І зневажив Езав первеньство своє. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Був же голод у тій землї, опріч голоду прежнього за часів Авраамових. Пійшов же Ізаак геть до Абимелеха, царя Филистимського, в Герар. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Явився ж йому Господь і рече: Не ходи в Египет, вселися у землї, що про неї тобі скажу. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","І пробувай у тїй землї, і буду з тобою, і благословлю тебе; тобі бо й насїнню твойму оддам усї цї землї, і поновлю клятву мою, що нею клявсь Авраамові, отцеві твойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","І намножу насїннє твоє, як зорі небесні, і оддам насїнню твойму всї оцї землї, і благословляться через насїннє твоє всї народи земнії: ");
INSERT INTO ukr1871_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","За те що послухав отець твій Авраам гласу мого, і держав заповідї мої, і повелїння мої, і встанови мої й закони мої. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Вселився ж Ізаак у Герарі. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","І питали люде займища того про жінку його, і каже: Сестра менї вона; боявся бо казати, що се жінка моя, щоб не вбили його чоловіки займища того, Ребеки ради; була бо вродлива. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Сталося ж, як він був довгий час там, що позирнув Абимелех царь Герарський у вікно, побачив, що Ізаак жартує з Ребекою, жінкою своєю. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Прикликав же Абимелех Ізаака та й каже: Чи справдї ж бо вона жінка твоя? Як же се ти казав: Вона сестра менї. Каже ж йому Ізаак: Затим казав, щоб не вмерти задля неї. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Каже ж Абимелех: Що се вдїяв єси нам? Мало що не побув хто з мого народу з жінкою твоєю, то й навів би єси на нас незнаний гріх. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Заповідав же Абимелех усїм людям своїм, говорючи: Усякого, хто прикоснеться до мужа сього, або до жони його, скарають смертю. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Сїяв же Ізаак у землї тій, і здобувсь того лїта на вроджай сторицею; благословив бо Господь його. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","І пійшов угору чоловік, і все більший був та більший, аж поки зробивсь великим вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Був бо в його статок отарний, і статок товарний, і велика купа рабів; позавидували ж йому Филистимцї. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","І всї колодязї, що повикопували раби батьківські, за живота Авраама, батька його, засипали землею. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Каже ж Абимелех Ізаакові: Іди від нас; бо потужнїщий зробивсь єси од нас вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","І зійшов звідти Ізаак, та й зупинивсь у Герар долинї, і вселився там. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","І повідкопував ізнов Ізаак водяні колодязї, що повикопували були раби Авраамові, батькові, і що позасипали були Филистимцї по смертї Авраамовій, та й попрозивав їх прізвищами, що попроложував був їм отець його. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","І копали раби Ізаакові, та й знайшли там колодязь води живої. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","І сварились пастухи Герарські з пастухами Ізааковими говорючи: Наша се вода. І прозвав колодязь той: Есек — сварка; сварились бо з ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Відойшовши ж звідти Ізаак, викопав колодязь другий, сварилися ж і за той, і проложив і йому прізвище: Ситна — ворожнета. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Відойшовши ж ізвідти, викопав ще колодязь, і не сварилися за сей; і проложив йому прізвище: Рехобот — просторонь, говорючи: Роспросторив Господь займище наше, щоб ми розмножились у сїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Піднявся ж ізвідти до Бейер-Себи, колодязя клятьби. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","І явивсь йому тієї ночі Господь, і рече: Я Бог Авраама, отця твого. Не бійся, бо я з тобою, і благословлю тебе, і намножу насїннє твоє задля Авраама, раба мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","І спорудив там жертівника, і призвав імя Господнє, і напяв там намета свого. Викопали ж там раби Ізаакові колодязь. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","І Абимелех прийшов до його з Герару, і Ахусат, порадник його, і Пихоль, гетьман війська його. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","І каже їм Ізаак: Чого прийшли до мене? Ви ж зненавидїли мене, і відослали мене від себе. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Вони ж промовили: Бачивши побачили ми, що Господь був з тобою, та й кажемо: Нехай же буде клятьба між нами й між тобою, і заповідаймо з тобою заповіт, ");
INSERT INTO ukr1871_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Щоб не робив нам лиха, як ми не чіпали тебе, і як ми робили тобі тільки добро, і відпустили тебе з миром; і тепер благословен ти від Господа. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","І справив їм пир, і їли вони й пили. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","І вставши вранцї, клявся один одному; і відпустив їх Ізаак, і пійшли від його з миром. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Сталося ж того дня, що прийшовши раби Ізаакові повідали йому про колодязь, що викопали, і казали йому: Знайшли воду. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","І прозвав його Себа, клятьба. Тим назва й міста того Бейер-Себа, колодязь клятьби, по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Було ж Ізаакові сорок лїт, і взяв він жінку собі Юдиту, дочку Бейерія Хетиянина, та Басмату, дочку Єлона Хетиянина. ");
INSERT INTO ukr1871_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","І були вони важкою печаллю Ізаакові й Ребецї. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","І сталося, що як був Ізаак старий, і притупились очі в його, та й недобачав, покликав Езава, сина свого старшого та й каже йому: Сину мій! І каже: Ось я! ");
INSERT INTO ukr1871_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","І говорить Ізаак: Оце я старий уже, і не знаю коли скінчусь. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Дак возьми знаряддє твоє, сагайдака твого й лука, та пійди в дике поле, та влови менї влову. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","І вготуй менї наїдку такого, як я люблю, та й принеси менї, щоб моя душа благословила тебе, покіль не вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ребека ж чула, як Ізаак говорив до Езава, сина свого. Пійшов же Езав у дике поле, вловити влову та принести. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Озветься ж Ребека до Якова, сина свого меньшого: Оце я чула, як отець твій озвавсь до Езава, брата твого, промовивши: ");
INSERT INTO ukr1871_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Принеси менї влову, та вготуй менї наїдку, щоб я попоїв, та благословив тебе перед Господом, покіль не вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Тим же то, синку, послухай голосу мого, що заповідаю тобі. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Пійди лишень в отару, та піймай менї звідти двойко мякеньких та добрих, і зроблю я смашний наїдок отцеві твойму, такий як він любить. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","І внесеш отцеві твойму, щоб він попоїв, і щоб тебе благословив, покіль не вмер. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Каже ж Яков Ребецї, матері своїй: Та ж Езав брат мій, чоловік волохатий, я ж половік гладенький. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Може, полапає мене панотець, і зроблюсь перед ним мантїєм, і наведу на себе клятьбу а не благословеннє. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Рече ж йому мати: На менї клятьба твоя, синку; тілько послухай голосу мого, та йди, і піймай менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Пійшов же, піймав, і принїс матері; і вготовила мати смашний наїдок, який любив отець його. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","І взявши Ребека одежу Езавову добру, сина свого старшого, що була у неї в схованцї, одягла нею Якова, сина свого меньшого. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","А смушками козлячими пообгортала руки і наге тїло на шиї в його. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","І дала смашний наїдок і хлїба, що вготовила, в руки Яковові, синові свойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","І внїс отцеві свойму, і каже: Панотче! Він же рече: Ось я! Хто єси ти, синку? ");
INSERT INTO ukr1871_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","І каже Яков отцеві: Я Езав, первенець твій. Зробив, як мовляв менї єси. Устань, сядь і попоїж мого влову, щоб мене благословила душа твоя. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Рече ж Ізаак синові свойму: Що воно? Як хутко споткав єси, синку! Він же каже: Се тим, що послав Господь, Бог мій, перед мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Рече ж Ізаак Яковові: Приступи до мене, облапаю тебе, синку, чи ти єси справдї син мій Езав, чи нї. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Приступив же Яков до Ізаака, отця свого, і він облапав його, і рече: Голос — голос Яковів, руки ж — руки Езавові. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","І не впізнав його; були бо руки його, як руки Езавові, брата його, волохаті; от і благословив його. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","І рече: Чи справдї бо ти єси син мій Езав? Він же каже: Я. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","І рече: Подай менї сюди. Попоїм улову твого, синку, щоб тебе благословила душа моя. І подав йому, і попоїв; і принїс йому вино, і випив. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","І рече йому Ізаак, отець його: Приступи ж, та поцїлуй мене, синку. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","І приступивши поцїлував його. І нюхав запах одежі його, і благословив його, і рече: Се запах сина мого, як запах ниви, що благословив її Господь. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Дай же тобі, Боже, буйну росу з неба, і дай тобі, Боже, землю благодатню! Роди тобі, Боже, зерно й виногрони! ");
INSERT INTO ukr1871_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Нехай тобі хмарі служать службу вірну, і перед тобою шию гнуть народи! Мусиш бути паном, і над братом рідним, над усїма дїтьми матері твоєї. Проклят буде той, хто тебе проклинає, і благословенний, хто благословляє! ");
INSERT INTO ukr1871_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","І сталось воно, скоро перестав Ізаак благословляти Якова, і ледві Яков вийшов од Ізаака, батька свого, аж Езав, брат його, прийшов до дому з ловитви. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Уготовив же й той наїдку, та й принїс отцеві свойму, і каже батькові: Нехай тато встане та попоїсть улову сина свого, щоб мене благословляла душа твоя. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","І рече йому Ізаак, отець його: Хто ж єси ти? Він же каже: Я син твій, первенець твій Езав. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Злякався ж Ізаак ляком великим вельми, і рече: Хто ж той, що вловив менї влову, і принїс менї, і попоїв я в сього перш, нїж прийшов ти, і благословив його? І буде благословен. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Почувши ж Езав отецькі слова, заголосив голосом великим, і гірким тяжко, та й каже: Благослови ж і мене, панотче! ");
INSERT INTO ukr1871_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Рече ж йому: Підійшов твій брат лестиво, та й узяв благословеннє твоє. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","І каже: По правдї дано йому імя Яков; бо підійшов під мене, се вже вдруге, і первеньство моє взяв у мене, і благословеннє моє тепер одняв. І каже Езав отцеві свойму: Чи то ж не приховав єси й менї благословення, панотче? ");
INSERT INTO ukr1871_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Відказав же Ізаак, і рече Езавові: Що ж? Паном зробив я його тобі, а все браттє його поробив рабами йому, хлїбом і вином забезпечив його. Тобі ж тепер що зробити, синку? ");
INSERT INTO ukr1871_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Озвався ж Езав до батька свого: Хиба ж одно благословеннє в тебе, панотче? Благослови ж і мене, панотченьку! Та й знов заплакав Езав. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Відказав же Ізаак, отець його, і рече йому: Знай же, що твою осаду тук земний вбезпечить, прохолодою ж твоєю з неба роси будуть. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Житимеш з меча важкого в послузї у брата. Станеться ж ізнов, ти будеш самовладьнїм паном, і ненавидну кормигу з гамалика скинеш. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","І зненавидїв Езав Якова за благословеннє, що ним благословив його батько його. Каже ж Езав у серцї свойму: Днї плачу по батькові надходять; тодї вбю Якова, брата мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Переказано ж Ребецї слова Езавові, сина її старшого, і пославши прикликала Якова, сина свого меньшого, та й каже йому: Ось Езав, твій брат, погрожує тобі вбити тебе. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Тепер же, синку, послухай голосу мого, і вставши біжи до Лабана, брата мого, в Гаран. ");
INSERT INTO ukr1871_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","І поживи з ним кілька днїв, докіль одвернеться ярость і гнїв у брата твого від тебе, ");
INSERT INTO ukr1871_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","І забуде він, що йому вдїяв єси. Тодї пославши возьму тебе звідти. Чого ж менї втеряти вас обох ув один день? ");
INSERT INTO ukr1871_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Рече ж Ребека до Ізаака: Тяжко менї жити на сьвітї через Хетіївен. Як візьме Яков за себе Хетіївну, таку, як вони в оцїй землї, дак про що менї й на сьвітї жити? ");
INSERT INTO ukr1871_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Прикликав же Ізаак Якова, та й благословив його, і заповідав йому, говорючи: Не мусиш узяти за себе жени з Канаанських дочок. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Устань, та й одбіжи в Мезопотамію, в Падан-Арам, в господу Бетуїлову, в батьківщину матері твоєї, та й возьми собі звідти жену з дочок Лабанових, брата матері твоєї. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Бог же мій нехай тебе благословить і намножить, щоб ти був купою народів. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","І нехай тобі дасть благословеннє Авраамове і насїнню твойму по тобі, щоб одержав у наслїддє землю, де пробуваєш, що оддав Бог Авраамові. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Послав же Ізаак Якова, і зійшов він у Падан-Арам, у Мезопотамію, до Лабана Бетуйленка, Араміянина, до брата Ребеки, матері Якова та Езава. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Бачивши ж Езав, що благословив Ізаак Якова і послав у Мезопотамію, в Падан-Арам, щоб узяти собі звідти жінку, і що благословляючи його заповідав йому говорючи: Не мусиш брати жени з дочок Канаанських, ");
INSERT INTO ukr1871_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","І що послухав Яков отця свого й матері своєї, та й пійшов у Падан-Арам, у Мезопотамію: ");
INSERT INTO ukr1871_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","І бачивши Езав, що не вподобав дочок Канаанських Ізаак, отець його, ");
INSERT INTO ukr1871_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Пійшов собі Езав до Ізмаїла, та й узяв Магалату, дочку Ізмаїла, сина Авраамового, сестру Небайотову, до жінок своїх. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","І зійшов геть Яков від Бейер-Себи, від колодязя клятьби, та й помандрував у Гаран. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","І приблудивсь до одного врочища, та й обночувавсь там, зайшло бо соньце. І взяв між каміннєм каменя на тому врочищі, та й положив його собі в голови, та лїг спати на місцї тому. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","І бачив сон, і се драбину поставлено на землї, верховина ж її сягає до небес, і ангели Божі возходять і низходять по нїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Господь же стоїть на їй і рече: Я Господь Бог Авраамів, отця твого, і Бог Ізааків. Земля, що на їй лежиш, тобі оддам її і насїнню твойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","І буде насїннє твоє, як пісок земний і розпросторишся на захід соньця, і на схід соньця, і на північ, і на полудьнє, і благословляться в тобі всї колїна землї, і у насїннї твойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","І се я з тобою й оберегати му тебе на всякій дорозї, що нею пійдеш, і верну тебе в ʼцю землю; бо не покину тебе, докіль сотворю все, що глаголав тобі. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","І прокинувсь Яков од сну свого, і каже: Певно єсть Господь на врочищі сьому, а я й не знав. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","І злякавсь, і каже: Яке страшне врочище се! Не що інше воно як дом Божий, а се ворота небесні. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","І встав Яков рано в ранцї, і взяв каменя, що положив там у голови собі, та й поставив його стовпа, та й злив олїй на верховину його. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","І прозвав Яков урочище то Бетель; прежне прізвище городу було Луз. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","І обрік Яков себе оброком, говорючи: Коли Бог буде зо мною, і сохранить мене в дорозї, що ʼце верстаю, і дасть менї хлїб на їду й одежу на одїг, ");
INSERT INTO ukr1871_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","І верне мене здорового в господу панотцеву, тодї буде Господь менї Богом. ");
INSERT INTO ukr1871_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","І камінь сей, що поставив стовпа, буде в мене дом Божий, і з усього, що менї даси, десятину давати му тобі. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","І вставши Яков на ноги, пійшов у землю восточню. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Дивиться, коли ж колодязь на степу, і було там три отарі овець, що полягали коло його. З того бо колодязя наповано стада. Над усьтєм же колодязьним лежав камінь великий. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","І скуплювались там усї стада, і одвалювано каменя від усьтя колодязного, і наповано вівцї, та й знов навалювано каменя на усьтє колодязне на місцї свойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Рече ж їм Яков: Браттє, звідки ви? Вони ж кажуть: Ми з Гарану. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Рече ж їм: Чи знаєте Лабана Нагоренка? Вони ж кажуть: Знаємо. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Рече ж їм: Чи жив, здоров? Вони ж кажуть: Жив і здоров. Ось і Рахеля, дочка його, йде з вівцями. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","І рече Яков: Ще дня багацько, не пора скуплювати докупи скотину. Понаповайте вівцї, та йдїть, пасїте. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Вони ж кажуть: Не зможемо, докіль усї отарі скупляться докупи, та одвалять каменя з колодязного усьтя; тодї й понаповаємо вівцї. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ще ж він говорив до них, аж ось Рахеля пригналась із отецькими вівцями; вона бо доглядала їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","І сталось, як зуздрів Яков Рахелю, дочку Лабанову, брата матері своєї, приступив Яков, одвалив каменя від усьтя колодязного, та й напоїв вівцї Лабанові, брата материного. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","І поцїлував Яков Рахелю, та й заплакав у голос. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","І повідав Рахелї, що він брат отця її, і що він син Ребечин. І побігши вона, повідала панотцеві свойму сї речі. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Сталось ж, як почув Лабан вістї про Якова, побіг зустріч йому, і обнявши його цїлував, і ввів його в господу свою, і повідав Лабанові всї речі сї. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","І каже йому Лабан: Справдї від костей моїх і від тїла мого єси ти. І пробув з ним днїв місяць. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Каже ж Лабан Яковові: Що брат менї доводишся, чи то ж мусиш робити на мене дармо? Скажи менї, яка тобі плата. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","У Лабана ж та було дві дочцї: старша на імя Лея, меньша ж Рахеля. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Лея недуговала очима, Рахеля ж була високого зросту, й принадна видом вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Уподобав же Яков Рахелю, і каже: Парубкувати му в тебе сїм год за Рахелю, дочку твою меньшу. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Каже ж йому Лабан: Лучче менї тобі оддати її, нїж мусїв би другому мужеві. Живи зо мною. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","І парубкував Яков за Рахелю сїм років, і здались вони йому, наче кілька днїв, тим що любив її. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Каже ж тодї Яков Лабанові: Дай менї жену мою; бо сповнивсь речінець мій, щоб увійти до неї. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Зібрав же Лабан усїх мужів громадських і зробив учту. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","І сталось у вечорі, що взяв він Лею, дочку свою, та й увів до Якова. І ввійшов до неї Яков. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Дав же Лабан Леї, дочцї своїй, Зелфу, рабиню свою за служебку. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Сталося ж у раньцї, дивиться, се була Лея. І каже Яков Лабанові: Що се ти вдїяв менї? Чи не задля Рахелї ж парубкував я в тебе? Про що ж так ошукав єси мене? ");
INSERT INTO ukr1871_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Відказав же Лабан: Неможна так чинити в нашій землї, видавати меньшу перше старшої. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Скіньчай же тиждень сей; я дам тобі й ту за роботу, що робити меш на мене ще сїм других лїт. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Учинив же Яков так, та й скіньчив тиждень з сією; і дав йому Лабан Рахелю, дочку свою, за жінку. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Дав же Лабан Рахелї дочцї своїй Баллу, рабиню свою, за служебку. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","І ввійшов до Рахелї, влюбив же Рахелю більш нїж Лею. І парубкував у його других сїм років. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Бачив же Господь, що ненавидна була Лея, відчинив утробу їй: Рахеля ж була неплідна. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","І завагонїла Лея, і вродила сина, і дала йому імя Рубен, говорючи: Певно зглянувся Господь на моє горе. Тепер же любити ме мене чоловік мій. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","І завагонїла знов, і вродила сина і каже: Що почув Господь, яка я ненавидна, тим дав менї й сього сина. І дала йому імя: Симеон. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","І завагонїла знов, і вродила сина і каже: Тепер же буде мій чоловік прихилен до мене; породила бо йому три сини. Тим дала йому імя: Левій. ");
INSERT INTO ukr1871_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","І завагонїла знов, і вродила сина, і каже: Теперь дякувати му Господеві. Задля того дала йому імя: Юда. Та й перестала роджати. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Вбачаючи ж Рахеля, що не вродила Яковові нїякої дитини, завидувала Рахеля сестрі своїй, та й каже Яковові: Дай менї дїток, ато вмру. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Загорівся ж Яков гнївом на Рахелю, і каже: Хиба я тобі замість Бога, що не дав тобі утробного плоду? ");
INSERT INTO ukr1871_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Каже ж вона: Ось раба моя Балла; увійди до неї та нехай уродить на колїна мої, щоб і в мене були дїтки від неї. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","І оддала йому Баллу, рабиню свою за жінку, і ввійшов до неї Яков. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","І завагонїла Балла, та й уродила Яковові сина. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","І рече Рахеля: Бог судив менї, і послухав голосу мого, і дав менї сина. Тим і дала йому імя: Дан. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","І завагонїла знов Балла, рабиня Рахелина, й уродила сина другого Яковові. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","І рече Рахеля: Великою боротьбою боролась я з сестрою моєю, та й перемогла. Тим і дала йому імя: Нафталїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Вбачала ж Лея, що перестала роджати, і взяла Зелфу, рабу свою, та й оддала її Яковові за жінку. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","І вродила Зелфа, рабиня Леїна, Яковові сина. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","І рече Лея: Пощастило менї! І дала йому імя: Гад. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","І вродила Зелфа, рабиня Леїна, Яковові сина другого. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","І каже Лея: Щасна я; бо дочки зватимуть мене блаженною. І дала йому імя: Ассер. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","І пійшов Рубен під пшеничні жнива, та й знайшов любовні яблука на полї, та й принїс їх до Леї, матері своєї. Каже ж Рахеля до Леї: Дай менї любовних яблук сина твого! ");
INSERT INTO ukr1871_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Рече ж вона їй: Хиба се мала річ, що взяла єси мужа мого? Чи й любовні яблука сина мого віднїмеш? Каже ж Рахеля: Дак нехай переночує з тобою сьогоднї за любовні яблука сина твого. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Прийшов же Яков з поля в вечорі, і вийшла Лея зустріч йому, і каже: Мусиш увійти до мене; найняла бо я справдї тебе за любовні яблука сина мого. І переночував він з нею тієї ночи. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","І послухав Бог Леї, і завагонїла вона, і вродила Яковові сина пятого. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","І каже Лея: Дав менї Бог плату мою; бо оддала рабиню мою мужеві мойму. І дала йому імя: Іссахар. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","І завагонїла знов Лея, і вродила сина шестого Яковові. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","І каже Лея: Подарував менї Бог гостиньца гарного, поважити ме мене муж мій; уродила бо йому шестьох синів. І дала імя йому: Себулон. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","А потім уродила дочку, і дала імя їй: Дина. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","І зглянувся Бог на Рахелю, і почув її Бог, і відчинив утробу їй. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","І завагонївши вродила сина, і каже: Одняв Бог докір мій. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","І дала імя йому: Йосиф, говорючи: Дай менї, Господе, й другого сина. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Сталося ж, як уродила Рахеля Йосифа, каже Яков Лабанові: Відпусти мене, нехай іду в домівку мою й на вкраїну мою. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Віддай жени й діти мої, що за них парубкував тобі; ти знаєш роботу, що робив тобі. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Каже йому Лабан: Коли б знайшов я ласку в тебе! Вбачаю бо, що благословив мене Господь задля тебе. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","І каже: Визнач плату свою в мене, я й дам тобі. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Каже йому: Ти знаєш, як я парубкував у тебе, і якою твоя скотина зробилась у мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Мало бо що було в тебе до мене, та й наросло багацько, і благословив тебе Господь з приходу мого. Тепер же коли менї дбати й про власну господу? ");
INSERT INTO ukr1871_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","І каже: Що мушу тобі дати? Каже ж Яков: Не давай менї нїчогісїнько, аби вчинив, що скажу, знов пасти му вівцї твої й доглядати му. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Пройду я через усю отару твою сьогоднї, а й вилучу все переполасе й крапасте, і все чорне між вівцями, й усе переполасе й крапасте між козами, і се буде моя плата. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Так моя правда говорити ме за мене завтрашнёго дня, як прийдеш давати плату мою. Усе непереполасе й не крапасте між козами і не чорне між вівцями, мусить уважатись у мене за вкрадене. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Каже ж йому Лабан: Добре, нехай буде по слову твойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","І повилучував того ж дня козли переполасі й крапасті, і усе, що мало біле в себе і все, що чорне між вівцями, та й пооддавав в руки синам своїм. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","І поставив три днї ходи між собою й Яковом. Яков же пас остальні вівцї Лабанові. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Узяв же Яков собі по цїпку зеленому тополевому, лїсковому й каштановому, та й помережив білими мережками, і луплячи повиявлював біле, що було на цїпках. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","І клав цїпки, що помережив, у напувальні корита та в водяні ринви, як приходили отарі до водопійла, щоб вагонїли на водопійлї. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","І вагонїли отарі перед цїпками, та й котились ягнятами й козенятами переполасими й крапастими. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ягнята ж вилучав Яков і ставляв отарі лицем до переполасого і чорного в отарі Лабановій, й держав свої отарі окроме, і не ставляв укупі з Лабановими. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","І сталося, як вагонїла лучча скотина, Яков клав цїпки перед очима в скоту в корита, щоб вагонїли між цїпками. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Як же гуляла скотина слабовита, не клав туди цїпків; тим робом слабовите було Лабанові, а лучче Яковові. ");
INSERT INTO ukr1871_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","І збогатився чоловік безлїч, і було в його скотини много, і раби, і рабинї, і верблюди, й осли. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Перечув же Яков слова синів Лабанових, що мовляли: Узяв Яков усе, що було в батька нашого, і з того, що було в батька нашого, вбивсь у всю славу його. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","І дививсь Яков на лице Лабанове, аж воно до його не таке, як перше. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Каже ж Господь Яковові: Вертайсь на батьківщину твою, і до роду твого, і буду з тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Послав же Яков, і покликав Лею й Рахелю на поле, де були стада. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","І каже їм: Бачу я лице батька вашого, що не таке до мене, як перше; Бог же панотця мого був зо мною. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","І самі знаєте, що всьою снагою моєю працював я батькові вашому. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Батько ж ваш ошукав мене, і переміняв плату мою десять раз; та не попустив йому Бог ушкодити менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Як скаже було так: Пестрі будуть плата твоя; тодї котяться вівцї всї пестрими; як же скаже: Крапасті будуть плата твоя, тодї котяться всї вівцї крапастими. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Так одняв Бог усю скотину в батька вашого й дав менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","І сталось того часу, як вівцї гуляли, зняв я очі мої й бачив уві снї: се, которі барани і козли спинались на вівцї й кози, були переполасі крапасті й рябі. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","І рече менї ангел Божий уві снї: Якове! Я ж кажу: Ось я! ");
INSERT INTO ukr1871_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","І рече: Споглянь лишень очима твоїми, та подивись: усї барани й козли, що спинаються на вівцї й кози, переполасі, пестрі й крапасті; вбачав бо я все, що Лабан тобі витворяє. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Я Бог з Бетеля, де намастив єси стовпа і обрікся єси менї словом. Тепер же встань, ізійди з сієї країни, та вертайсь на країну рідну. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","І відказуючи Рахеля й Лея, сказали йому: Хиба є тутеньки нам частина й наслїддє в госпо́дї, в батька нашого? ");
INSERT INTO ukr1871_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Хиба ж не за чужениць уважає нас він? Попродав бо нас і зажер срібло наше. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Бо все багатирство й слава, що відняв Бог у батька нашого, наше й дїток наших. Оце ж тепереньки все, що Бог рече, чини. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Зьнявся ж Яков, і посадив сини свої і жени на верблюди. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","І позабирав усю скотину свою й усї добутки, що здобув у Падам-Арамі в Мезопотамії, щоб вертатись до Ізаака, батька свого в Канаан землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Як же відлучився Лабан стригти вівцї свої, покрала Рахеля ідоли в батька свого; ");
INSERT INTO ukr1871_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","І викрався Яков несподївано Лабанові, Араміянинові, не сповістивши його про втеки. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","І втїк сам з усїм своїм, і перебрів через річку й простував у Галаад гори. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Переказано ж Лабанові на третїй день, що Яков утїк. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","І взявши сини й браттє своє з собою, здоганяв його семиденним погоном, та й наздогнав його на Галаад горах. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Прийшов же Бог до Лабана Араміянина ночною добою вві снї, і рече йому: Остерегайся звязуватись із Яковом. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","І наздогнав Лабан Якова. Яков же поставив намети свої на горі, і Лабан отаборив браттє своє на Галаад горах. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Каже ж Лабан Яковові: Що вкоїв єси? Про що викравсь єси потай мене, та позавозив дочки мої мов бранки? ");
INSERT INTO ukr1871_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Чого втїкав єси потай мене, та викравсь від мене, не сповістивши мене? Відпустив би тебе з покликами й пісьнями, з тимпанами й гуслями. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","І не дозволив єси менї цїлувати внуки мої й дочки мої. Се ж учинив єси по дурному, вдїявши таке. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Тепер би мав я силу покарати тебе, та Бог отця твого вчора вночі рече до мене, словами: Остерегайся звязуватись із Яковом. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Нехай би ти пійшов геть тому́, що тяжко зажуривсь по госпо́дї отця твого, про що ж украв єси боги мої? ");
INSERT INTO ukr1871_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Відказав же Яков і рече до Лабана: Бо злякався, думаючи, що поодіймаєш дочки твої в мене і усе моє, ");
INSERT INTO ukr1871_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","У кого ж ізнайдеш боги твої, той не жити ме на сьвітї. Перед нашою браттєю познавай, що твоє в мене, та й бери собі. Не знав же Яков, що Рахеля покрала боги. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Увійшовши ж Лабан у Яковів намет і в Леїну кущу, і в кущу двох рабинь, не знайшов. Увійшов же й у намет Рахелин. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Рахеля ж узяла ідоли, та й підложила під верблюдове сїдло, та й сїла на них. І обшарив Лабан усю кущу, та й не знайшов. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","І каже батькові свойму: Не гнївись, панотченьку, що не можу встати перед тобою; бо звичайне женське в мене. Шукав же він та й не знайшов ідолів. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Прогнївився ж Яков і звязавсь у сварку з Лабаном: Яка провина моя? Який гріх мій, що вганяв єси так гаряче за мною? ");
INSERT INTO ukr1871_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Переглянув єси всї речі домові в мене, що ж ізнайшов єси з усїх річей дому твого? Поклади тутеньки перед браттєю твоєю й браттєю моєю, щоб розсудили між обома нами. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Двайцять років оце вже я з тобою. Вівцї твої й кози твої не звергали, і баранїв із отари твоєї не їв я. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Зьвіроїдини не принїс до тебе; із мого нїс я втрату сю; з мого власного вимагав єси, чи вхоплено в день, чи в ночі. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","У день бо пекла мене спека, в ночі морозила холоднеча, і сон утїкав од очу в мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Так пробував я двайцять років у твоїй господї. Парубкував я чотирнайцять років задля двох дочок твоїх і шість років за вівцї твої, ти ж переміняв плату мою десять раз. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Коли б не Бог отця мого, Бог Авраамів, та не страх Ізааків був ізо мною, певно тепер в порожнї випустив би єси мене. Бідуваннє моє й працю рук моїх побачив Бог і докорив тебе вчора в ночі. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Відказав же Лабан, і каже до Якова: Дочки, мої дочки, і дїти, мої дїти, і скотина, моя скотина, і все, що видиш, то моє; що ж можу я заподїяти сим дочкам моїм або дїтям, що вони породили? ");
INSERT INTO ukr1871_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Оце ж нумо чинити умову, я й ти, і нехай він буде за сьвідка між мною й тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","І взявши Яков каменя, поставив його на спомин. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Каже ж Яков до браттї своєї: Назбирайте каміння. І назбирали каміння й зробили могилу і трапезували там на могилї. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","І прозвав його Лабан Егар-Сагадута; Яков же прозвав його Галлед. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Каже ж Лабан до Якова: Ся могила, се сьвідок між мною й тобою. Тим і прізвище дано могилї Галлед. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","І Мизпа від того, що Лабан сказав: Нехай вартує Господь між мною й тобою, як ми розійдемось різно одни з одним. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Коли зневажати меш дочок моїх або візьмеш над мої дочки жен, не чоловік буде між нами, нї! Бог сьвідок між мною й тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","І каже Лабан Яковові: Дивись на сю могилу і дивись на стовпа, що я поставив між мною й тобою. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ся могила сьвідок і сей стовп сьвідок, що не перейду за сю могилу до тебе, і ти не перейдеш за сю могилу і за сього стовпа до мене на шкоду. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Бог Авраамів і Бог Нахорів, Бог їх отця, суди між нами. І клявсь Яков страхом отця свого Ізаака. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","І принїс Яков жертву на горі, і покликав браттє своє до вживання хлїба солї, і вживали хлїб сїль, та й обночувались на горі. ");
INSERT INTO ukr1871_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Уставши ж Лабан рано в ранцї, цїлував сини й дочки свої і благословив їх, і рушив у дорогу, і вернувсь на займище своє. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","І Яков те ж верстав путь свою, і зустьріли його ангели Божі. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Каже ж тодї Яков, зуздрівши їх: Се Божий полк, урочище те Маганаїм. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Послав же Яков посли поперед собою до Езава, брата свого в Сеїр землю, в Едом поле; ");
INSERT INTO ukr1871_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","І наказав їм, говорючи: Такенькі мовляйте панові мойму Езавові: Так говорить раб твій Яков: У Лабана пробував я та й загаявсь там і досї. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","І придбав я воли й осли, і вівцї, і раби, й рабині, і посилаю тепер тобі панові мойму, звістку, щоб запобігти ласки твоєї в очах твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","І вернулись посли до Якова, говорючи: Ходили ми до брата твого Езава, і се він сам іде на зустріч тобі, і чотири ста чоловіка з ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Злякався ж Яков вельми, і був у турботї; і подїлив людей, що були з ним, і вівцї, й воли, й верблюди на два коші. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","І каже сам собі: Як наступить Езав на один кіш і побє його, тодї другий кіш пійде втеком. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Каже ж Яков: Боже отця мого Авраама й отця мого Ізаака, Господе, ти що заповідав менї: Вертайсь у рідну землю твою та до родини твоєї, і я таланити му тобі, ");
INSERT INTO ukr1871_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Не заробив я нїже всїх тих благ і всієї вірностї тієї, що виявив єси рабові твойму; з палицею бо сією перебрів я сю Йордань, а тепер виріс у два коші. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Визволь мене, благаю тебе, з рук брата мого, з рук Езава! Боюсь бо, щоб не прийшов та не вбив мене, матері із дїтками. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ти ж глаголав єси: Благо тобі сотворю, і вчиню імя твоє яко пісок морський, що не злїчити його задля многостї. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","І переночував там тієї ночі. І взяв із того, що прийшло йому в руки, гостиньця Езавові, братові свойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Кіз двістї, а козлів двайцятеро, овечок двістї, а баранів двайцятеро, ");
INSERT INTO ukr1871_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Берблюдиць дїйних двайцятеро з їх жеребятами, та корів сорок, та бугаїв десятеро, ослиць двайцятеро, і десяток ослів. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","І приручив їх рабам своїм, усяке стадо окроме, і звелїв рабам своїм: Гонїтесь бридьма через річку, та чинїте прогалину між стадом і стадом. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","І звелїв первому, говорючи: Як тебе зустьріне брат мій Езав, та спитає в тебе говорючи: Чий єси, і куди йдеш, і чиє се перед тобою? ");
INSERT INTO ukr1871_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Кажи: Раба твого Якова. Се подарунок панові мойму Езавові. Ось він і сам позад нас. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","І звелїв другому й третьому, й усїм, що гнались із стадами. Сими словами мовляйте Езавові, як зустьрінете його, ");
INSERT INTO ukr1871_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","І кажіть: Ось раб твій Яков і йде за нами. Бо каже сам собі: Вгамую його подарунками, що йдуть поперед мене, а потім побачу лице його. Може прийме мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Так ійшли дарунки поперед його. Сам же переночував ту ніч у коші. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Уставши ж тієї ночі, узяв обидві жени свої, і обидві рабинї, й одинайцятеро синїв своїх, і перейшов бридьма брід Ябок. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","І взяв їх, і перебрів річку, і перевів усе, що мав. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Остався ж Яков один, і боровсь із ним хтось, аж покіль обутьріло; ");
INSERT INTO ukr1871_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Вбачаючи ж, що не подужа його, ударив його по стегну, по суставу, і потерпів у Якова стегенний сустав, як боровсь із ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","І каже той: Пусти мене; бо вже день зоріє. Яков же каже: Не пущу; мусиш благословити мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Рече ж йому: Як на імя тебе? Він же каже: Яков. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","І рече йому: Від тепер буде тобі імя не Яков, а Ізраїль; ти бо з Богом боровсь і над людьми брати меш гору. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","І поспитав Яков його, і каже: Повідай менї, як на імя тебе звати? Про що питаєш, яке моє імя? І благословив його там. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","І приложив Яков тому врочищу прізвище: Пенуель, бачив бо я Бога лицем до лиця, тай вирятувалась душа моя. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Засяло ж йому соньце, як прийшов за Пенуель; він же кульгав на стегно. ");
INSERT INTO ukr1871_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Тим же то й тепер не їдять сини Ізраїлеві жили, що на составі бедра, тому, що боровшийся зрушив жилу на составі бедра Якова. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Споглянувши ж Яков очима своїми, постеріг, се ж Езав, брат його, йде, і чотири ста чоловіка з ним. І роздїлив дїток Леї, Рахелї і двох рабинь. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","І поставив обидві рабинї зпереду, Лею ж і дїти її позаду, а Рахелю з Йосифом, дальш усїх, на посьлїдку. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Сам же прийшов перше них, і вклонивсь до землї сїм раз, перше нїм приступив до брата свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","І прибіг Езав зустріч йому, і обняв його, та й припав йому на шию, і поцїлував його; і плакали обидва. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","І спогляне Езав, і побачив жени й дїти, й каже: Що ж сї в тебе? Він же каже: Дїти, що дарував Бог рабові твому. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","І приступили рабинї й дїти їх, і вклонились. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","І приступила Лея те ж із дїтьми своїми й уклонились; потім же приступив Йосиф і Рахеля й уклонились. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","І каже Езав: Про що ж у тебе всї цї полки, що я з ними зустрівся? Він же каже: Щоб ізнайшов раб твій милість ув очах в мого пана. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Каже ж Езав: У мене доволї, брате, держи своє про себе самого. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","І каже Яков: Коли знайшов я ласку в очах твоїх, прийми гостинцї з руки моєї тому, що побачив я лице твоє, як би хто побачив лице Боже, і що був єси прихилен до мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Прийми благословеннє моє, що я принїс тобі, бо мене Бог благословив, і всього доволї в мене. І присилував його, і взяв він. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","І каже: Рушаймо в дорогу. Я пійду по переду. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Каже ж йому: Пан мій знає, що дїтки в мене маленькі, а вівцї й корови кітні й тїльні; як же пожену їх один день, занапащу всю скотину. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Нехай пан мій іде попереду раба свого, я ж пійду повагом, дивлячись по сназї худоби, що йти ме передо мною, і як пійде дїтвора, поки прийду до пана мого в Сеїр. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","І каже Езав: Оставлю ж із тобою кілька людей моїх. Він же каже: Про що воно? Аби знайшов я ласку в очах пана мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Вернувся ж Езав того дня на свою путь у Сеїр. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","А Яков мандрував далїй у Суккот і побудовав собі домівку, а скотинї своїй поробив кущі. Тим і проложено прізвище врочищу тому Суккот. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","І дойшов щасливо Яков до городу Сихему, що в Канаан землї, вернувшись із Мезопотамїї, та й отаборився перед городом. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","І купив частину поля, де отаборивсь, у синів Геммора, отця Сихемового, за сто срібняків. ");
INSERT INTO ukr1871_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","І поставив там жертівника, та й призвав імя Господа Бога Ізраїлевого. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Вийшла ж Дина, дочка Леїна, що вродила Яковові, спізнатись із дочками тієї країни. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","І побачив її Сихем, син Геммора, Евеяненка, князя тієї країни, та й взяв її, і лїг із нею, і насилував. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","І прихилилась душа його до Дини, дочки Якова, і влюбив дївицю, й промовляв до неї прихильно. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Каже ж Сихем до Геммора, батька свого, говорючи. Возьми менї дївицю сю за жену. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Яков же чув, що збезчестив Гемморенко Дину дочку його, сини ж його та були з його скотиною в полї, і мовчав Яков аж покіль прийшли вони. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Вийшов же Геммор, отець Сихемів до Якова на поговорку з ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Сини ж Яковові поприходили з поля, і, почувши про се, досадували вони і були в великому жалю, що він зробив безум ув Ізраїлї, лїгши з дочкою Якововою, чого не годилось чинити аж надто. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","І розмовляв із ними Геммор говорючи: Сихемові, синові мойму, поривало душу до вашої дочки. Оддайте ж її за жену йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","І своячтесь із нами; дочок своїх давайте нам, а дочок наших беріте собі. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","І сїдайте осадами з нами, і наша країна буде перед вами. Сїдайте осадами й торгуйте і здобувайтесь на добро в їй. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Каже ж ото Сихем до батька й до братів її: Дайте менї знайти ласку в очах ваших, і що ви скажете менї, дам. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Вимагайте над звичай віно й подарунки; дам, скількі скажете менї, аби оддали дївицю заміж. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Відказали ж сини Яковові Сихемові та Гемморові, батькові його, зрадливо; а мовляли так тим, що він осоромив Дину, сестру їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","От і кажуть їм: Неможлива се річ оддати сестру нашу такому, що необрізаний; се ж бо докір нам був би; ");
INSERT INTO ukr1871_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Тілько тодї поєднаємось і осядемось із вами, коли будете такі, як ми, і обріжете ввесь музький пол. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","І оддавати мемо наші дочки вам, і брати мемо ваших дочок собі, і седіти мем осадами з вами, і зробимось одним народом. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Коли ж не послухаєте нас, тодї візьмемо дочку нашу та й пійдемо собі. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","І вподобав слова їх Геммор та Сихем Гемморенко. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","І не гаявсь молодик зробити се, закоханий бо був у Якововій дочцї, а поважали його над усю родину в отця його. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Прийшов же Геммор та Сихем Гемморенко до царини мїста їх, і розмовляли з мужами громадськими, говорючи: ");
INSERT INTO ukr1871_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Люде сї в ладу з нами, тим нехай сїдають осадами в нас на країнї, да й торгують у їй; бо наша країна простора геть про них. Берімо дочок їх собі і оддаваймо дочок наших їм. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Тілько тодї згоджуються з нами, щоб осїстись із нами і єдинитись із нами, коли все музьке між нами та буде обрізане, як вони обрізані. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","І стада їх, і майно їх, всяка скотина їх хиба не наші? Оце ж поєднаймось із ними, дак і осядуться з нами. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","І послухали Геммора та Сихема Гемморенка всї, що виходили за царину міську, і пообрізувалось усе музьке між ними. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Сталося ж на третїй день, як недугували вони, два сини Яковові, Симеон та Левій, брати Дининї, взяли кожен меча свого, та ввійшли в город, та й повбивали все музьке. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Геммора ж та Сихема Гемморенка постинали мечом, і взяли Дину з господи Сихемової, та й пійшли геть. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Сини ж Яковові ввійшли до побитих, та й розграбили город; бо в йому обезчещено Дину, сестру їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","І вівцї їх, і товарину їх, і осли й усе, що було в містї, і все, що було на полї, позабирали. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","А все майно їх, і всю малечу їх, і жінок їх позаймали в полонь, і пожакували все, що було в городї по господах. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Каже ж Яков до Симеона і Левія: Ненавидним зробили ви мене серед осадників сієї країни, серед Канаанїїв і Ферезіїв; я ж малий лїчбою, так вони скупляться до купи проти мене, та й убють мене, і я загину, і вся родина моя. ");
INSERT INTO ukr1871_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Вони ж кажуть: Хиба він за ледащицю вважав сестру нашу? ");
INSERT INTO ukr1871_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Рече ж Бог до Якова: Уставши, підіймайсь до Бетеля, та й осядься тамо, і сотвори там жертівника Богу, що явився тобі, як утїкав єси од Езава, брата твого. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Каже ж Яков домові свому й усїм, що були з ним. Повикидайте боги чужі, які є в кого з вас, та й очищайтесь і поперемінюйте одїж свою. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Та вставаймо й підіймаймось у Бетель, та поставимо там жертівника Богу, що послухав мене в день бідування мого, та й був зо мною в дорозї, що верстав я. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","І видали Яковові богів чужих, що були в руках їх, і сережки, що були в ушу їх, і сховав їх Яков під дубом, що під Сихемом. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","І помандрували вони, і був страх Божий на містах круг їх, і не вганяли за синами Якововими. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Прийшов же Яков у Луз, що в Канаан землї, се єсть Бетель, він і ввесь люд його, що були з ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","І поставив там жертівника; і проложив тому врочищу прізвище Ель-Бетель, там бо явивсь йому Бог, як утїкав од Езава, брата свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Умерла ж Дебора, мамка Ребечина, і поховали її під дубом і проложили йому прізвище Аллон-Бакут, дуб голосїння. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Явився ж Бог Яковові знов, як прийшов із Мезопотамиї, і благословив його. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","І рече йому Бог: Імя твоє не звати меться вже Яков, нї! Ізраїль буде імя твоє. І дав йому прізвище Ізраїль. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Рече ж йому Бог: Я Бог всемогущий. Бувай плодющий і намножуйся. Народи і купа народів будуть із тебе, і царі з чересел твоїх вийдуть. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","І землю, що дав Авраамові й Ізаакові, тобі віддам, і насїнню твойму по тобі дам землю сю. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Знявся ж Бог від його, від урочища, де розмовляв із ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","І поставив Яков стовпа на врочищі, де він розмовляв із ним, стовпа камяного та й злив на його ливною жертвою, і злив олії на його. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","І проложив Яков прізвище врочищу тому, де розмовляв із ним Бог, Бетель. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","І рушили вони з Бетеля, і було вже не далеко до Евфрата і настигла Рахелю родїльня мука, і мала вона породи важкі. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Сталося ж, як вона мала важкі породи, каже їй баба сповитуха: Крепись; бо й се буде в тебе син. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Сталося ж, як покидала її душа, умірала бо, дала йому імя Бенонї, болюча дитина, отець же дав йому імя Бенямин, щасна дитина. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Умерла ж Рахеля, і поховано її на шляху до Евфрата, се єсть Бетлегем. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","І поставив Яков стовпа над гробом її. Се стовп на Рахелиному гробу по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Помандрував же Ізраїль і напяв намета свого за Мигдаль-Єдером. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Сталося ж, як осївсь Ізраїль на тій країні, прийшов Рубен та й лїг із Билгою, батьковою наложницею. І дочувсь про се Ізраїль. Було ж синів у Якова дванайцятеро. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Синове Леїні: Рубен, первенець Яковів, та Симеон, та Левій, та Юда, та Іссахар, та Зебулон. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Синове Рахелині: Йосиф та Бенямин. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Синове Балли, рабинї Рахелиної: Дан та Нефталїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Синове Зелфи, рабинї Рахелиної: Гад і Ассер. Се синове Яковові, що понароджувались йому в Мезопотамії. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Прийшов же Яков до Ізаака, отця свого, в Мамрійщину, в Киріят-Арбу, се Геброн, де пробував Авраам та Ізаак. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Було ж Ізаакові сто і вісїмдесять год. ");
INSERT INTO ukr1871_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","І розлучивсь Ізаак із душею й умер, і прилучивсь до роду свого, старий, нажившись на сьвітї. І поховали його Езав та Яков, синове його. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Се ж родопись Езавова, він же Едом. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Езав побрав собі жени із дочок Канаанських, Аду дочку Єлона Хетяненка, та Оголибаму, дочку Ани, сина Зибеона Евеяненка. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Та Басмату Ізмайлову, сестру Небайотову. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ада ж уродила Езавові Єлифаса; Басмата вродила Регуїла. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Оголибама ж уродила Єгуса та Єглома та Корага. Се сини Езавові, що народились йому в Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","І позабирав Езав жени свої, та сини свої, та дочки свої, і всї раби в госпо́дї своїй, і скотину свою, й усе підуючне своє, і всї статки свої, що придбав у Канаан землї, та й помандрував Езав з Канаан землї, від брата свого Якова, у Сеїр землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Були бо майна іх більші над те, щоб кочувати вкупі, і країна, де пробували вони, не зносила їх задля скотини їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Осївся ж Езав на Сеїр горах; Езав, він же Едом. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Се ж родопись Езава, праотця Едомеїв на Сеїр горах. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ось іммення в синів Езавових: Єлифас, син Басмати, жінки Езавової. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","У Єлифаса ж були синове: Теман, Омар, Зефо, Гаєтам та Кенас. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Тимна ж була наложниця Єлифаса, Езавенка, і вродила Єлифасові Амалека. Се синове Ади, жони Езавової. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","І ось синове Рагуїла: Нахат і Серах, Шамма і Миза. Се синове Басмати, жони Езавової. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","А се були синове Оголибами, дочки Ани, сина Зибеона, жінки Езавової. Вродила вона Езавові Єгуса та Єглома та Корага. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Се були дуки в синів Езавових. Синове Єлифаса, первеньця Езавового: дука Теман, дука Омар, дука Зефа, дука Кенас, ");
INSERT INTO ukr1871_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Дука Кораг, дука Гатам, дука Гайфас, дука Амалек. Се дуки Єлифасові в Едом землї. Се сини Адині. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","А се сини Рагуїла Езавенка: дука Нахат, дука Серах, дука Шамма, дука Миза. Се дуки Рагуїлові в Едом землї. Се синове Басмати Езавихи. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Се ж синове Оголибами Езавихи: Дука Єгус, дука Єглом, дука Кораг. Се дуки Оголибами, дочки Ани, жінки Езавової. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Се сини Езава, і се дуки їх. Він Едом. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Се ж сини Сеїра Горієнка, що седїли осадами в тій країнї Лотан, та Собаль, та Зибеон, та Ана. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Та Дишон, та Єзер, та Дишан. Се дуки Горійські в синів Сеїрових в Едом землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","А синове Лотанові були: Горій та Гемам, а сестра Лотанова: Тимна. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","А се синове Собальові: Алван, Манагат, та Ебаль, Сефо та Онам. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","А се синове Зибеонові: Ая та Ана. Се той Ана, що знайшов гарячі жерела в степу, пасучи осли Зибеонові, батьківські. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","А се синове Анині: Дишон і Оголибама, дочка Анина. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Се ж синове Дишонові: Гемдан, та Єшдан, та Ітран, та Керан. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Се ж синове Єзерові: Билган, та Саван, та Акан. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Сеж синове Дишанові: Уз та Аран. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Се ж дуки в Горіїв: дука Лошан, дука Собаль, дука Зибеон, дука Ана; ");
INSERT INTO ukr1871_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Дука Дишон, дука Єзер, дука Дишан. Се дуки в Горіїв після дуків їх у Сеїр землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","А се царі, що царювали в Едом землї, перш нїж царював там який царь в Ізраїлї. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Царював у Едомі Бела Бейоренко; прозивався ж город його Динхаба. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Умер же Бела, і царював намість його Йобаб Серахенко із Бозри. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Умер же Йобаб, і царював намість його Гусам із Теман землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Умер же Гусам, і царював намість його Гадад Бедаденко, що побив Мидіяніїв на полї Моаб, а город його прозивавсь Авит. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Умер же Гадад, і царював намість його Самла із Мазреки. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Умер же Самла, і царював намість його Савул із Рехобота над рікою. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Умер же Савул, і царював намість його Бааль-Ганан Ахборенко. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Умер же Бааль-Ганан Ахборенко, і царював намість його Гадар; город же його прозивали Пакгу, а жінку його Мегетабееля, дочка Матреда, дочки Мезагаба. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","А се ймення дуків Езавових по родинах їх, по врочищах їх, по прізвищах їх: Дука Тимна, дука Алва, дука Єтет. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Дука Оголибама, дука Єла, дука Пинон. ");
INSERT INTO ukr1871_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Дука Кенас, дука Теман, дука Мибзар, ");
INSERT INTO ukr1871_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Дука Магдієль, дука Ірам. Се дуки в Едомі, по оселях їх, по врочищах їх. Се Езав, прайотець Едомів. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Осївся ж Яков на країнї, де пробував отець його Ізаак, у Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Се ж родопись Якова: Як було Йосифові сїмнайцять років, пас він вівцї з браттєм своїм, та був ще недолїтком між синами Балли та Зелфи, жен отця свого. І доводив Йосиф речі їх ледачі до панотця свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Яков же любив Йосифа над усї сини свої; бо родивсь у старощах його, і справив йому одїж квіччасту, рукавчату. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Вбачаючи ж браттє його, що любить його батько над усї сини свої, зненавидїли його, і тяжко їм було промовляти до його мирно. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Бачив же Йосиф сон і росказав браттї своїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","І каже їм: Послухайте лишень сна сього, що я бачив. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Здавалось бо, нїби вяжемо снопи серед поля; аж ось встав мій сніп, да й стоїть: ваші ж, бачся, снопи постали навкруги, та й уклонились мойму снопові. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Сказали йому браттє його: Чи то ж бо справдї царювати меш над нами. Та й зненавидїли його ще й надто за сни його і за слова його. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Побачив же сон другий, та й повідав його браттю свойму, і каже: Ось бачив ще сон, і здавалось, нїби соньце й місяць й одинайцятеро зір уклонились менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","І росказав отцеві свойму й браттю свойму. І докорив йому панотець його, каже йому: Що се за сон такий тобі приснивсь? Чи то ж бо се прийдемо, я й мати твоя й браттє твоє, вклонитись тобі до землї? ");
INSERT INTO ukr1871_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Позавидували ж йому браттє його, панотець же його завважив слово се. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","І погнались брати його з отецькими вівцями в Сихем. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","І каже Ізраїль до Йосифа: Чи не пасуть браттє твоє в Сихемі? Іди навідайся до них. Каже ж йому: Готов! ");
INSERT INTO ukr1871_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Каже ж йому: Іди, синку, та наглянь, чи все гаразд у браття твого, чи все гаразд між вівцями, і принеси вістку. Та й послав його з Геброн долини, і прийшов у Сихем. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","І стьрів його чоловік якийся, аж він блукає по полю. Питає ж його чоловік: Чого шукаєш? ");
INSERT INTO ukr1871_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Він же каже: Браття мого шукаю. Повідай, де пасуть. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Каже ж йому чоловік: Погнались ізвідсї; чув бо, як мовляли: Поженимось у Дотан. І пійшов Йосиф слїдом за браттєм своїм, і зустьрів їх у Дотанї. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Загледїли ж його оддалеки, перш нїж наближився до них, і змовились на його, щоб убити його. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Каже ж брат до брата: От сновидець той ійде. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Нумо вбємо його та вкиньмо в який колодязь, та й казати мемо: Зьвір лютий пожер його; от і побачимо, що станеться з тих снів його. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Чуючи ж се Рубен, одняв його з рук у їх, та й каже: Не губімо душі. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Каже ж Рубен: Не проливайте крові, а вкиньте в степовий колодязь, руки ж не кладїть на його; се, щоб визволити його з рук у них, та й оддати панотцеві. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","І сталось, як прийшов Йосиф до браття свого, стягли з Йосифа одїж його квіччасту рукавчату, що була на йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","І взяли його, та й укинули в колодязь; колодязь же сухий був, води не було. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","І сїли попоїсти, коли ж глянуть, ідуть подорожні Ізмайлитяне від Галааду з верблюдами своїми, везучи бурштин, бальзам та ладан в Египет. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Каже ж Юда до браття свого: Що за користь, як убємо брата нашого та й потаїмо кров його. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ходїмо, продаймо його Ізмайлитянам; руки ж наші не будуть на йому, бо він брат наш і тїло наше. І вдовольнились браттє його. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","І йшли мимо купцї Мидіянські; і витягли вони Йосифа з колодязя, і продали Йосифа Ізмайлитянам за двайцять срібняків; і поведено Йосифа в Египет. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Вернувся ж Рубен до колодязя, аж Йосифа нема в колодязї, і розірвав одїж свою. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","І прийшов до браттї своєї й каже: Хлопця нема, а я, куди менї теперенькі йти? ");
INSERT INTO ukr1871_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Узяли ж вони одежу Йосифову, і закололи кізлика, та й помазали одежу кровю; ");
INSERT INTO ukr1871_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","І послали одежину квіччасту рукавчату, і принесено її до батька, і казали: Се ми знайшли; познавай, чи се одежа сина твого, чи нї. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","І впізнав, і каже: Одежа сина мого! Зьвір лютий іззїв його, зьвір ухопив Йосифа. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","І розірвав Яков одїж свою, і нагорнув на чересла свої веретище, і плакав по синові свойму днї многі. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Посходилися ж усї його синове й дочки розважати його, та не слухав розважання говорючи: Пійду до сина мого сумуючи на той сьвіт у землю. Так убивався по йому батько його. ");
INSERT INTO ukr1871_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Мидіянії ж продали Йосифа в Египтї Потифарові, дворянину Фараоновому, гетьманові прибічників його. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","І сталось того часу, Юда відлучивсь од браття свого, та й присусїдивсь до одного Адуламця, на прізвище Гіра. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","І побачив там дочку одного Канаанця, його імя Шуа, і взяв і ввійшов до неї. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","І завагонївши вродила вона сина, і дала йому імя Гер. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","І завагонївши знов, уродила сина, і дала йому імя Онан. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","І завагонївши знов уродила ще сина, і дала йому імя Села. І був Юда у Кезїбі, як вона роджала. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","І взяв Юда жінку Герові, первенцеві свойму, на імя Тамара. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Був же Гер первенець Юдин, ледачий ув очу в Господа, і вбив його Господь. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Каже ж Юда Онанові: Увійди до братовоі жінки, та оженись із нею, яко дївер, і возстав сїмя братові твойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Знав же Онан, що не йому буде насїннє, і як увіходив до братової жінки, проливав сїмє на землю, щоб не дати насїння братові свойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ледарство ж погань було в очу в Бога, що він коїв; тим убив і сього. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Каже Юда Тамарі, невістцї своїй: Седи вдовою в отецькій господї, докіль великий буде Села, син мій. Каже бо сам собі: Колиб і сей не вмер, як брати його. І пійшла Тамара й седїла в отецькій госпо́дї. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Як уплило ж доволї часу, померла Шуанова дочка, жінка Юдина. Віджурившись після того Юда, пійшов до овечих стригачів своїх, сам і приятель його Гіра Адуламець, у Тімну. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","І сповістили невістку його Тамару говорючи: Он свекір твій ійде в Тімну стригти вівцї свої. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Вона ж, поскидавши вдовицьку одежу з себе, окрилась наміткою, та заквіччалась, і сїла в Енаїмській царинї, що при дорозї в Тімну, знавши, що вже дорослий Села, та її не дано йому за жінку. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","І побачивши Юда, подумав, що се блудниця; окрила бо лице собі, і не впізнав її. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Завернув же до неї з манівця, та й каже їй: Попусти менї ввійти до тебе. Не впізнав бо, що се невістка йому. Вона ж каже: Що менї даси, як увійдеш до мене? ");
INSERT INTO ukr1871_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Він же каже: Пошлю тобі кізлика з отари. Вона ж каже: А чи даси менї залог докіль пришлеш? ");
INSERT INTO ukr1871_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Він же каже: Який залог тобі дати? Вона каже: Перстень з печаткою твоєю, твій пояс, та палицю, що в руцї в тебе. І дав їй, та й увійшов до неї, і завагонїла від його. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","І встала та й пійшла, і скинула намітку з себе, і вдяглась ув одїж удовицьку. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Послав же Юда кізлика через руки приятеля свого Адуламця, узяти залог од молодицї, та не знайшов її. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Поспитав же в міських людей, та й каже: Де блудниця, що седїла під Енамом при дорозї? І мовляли вони: Не було тутеньки нїякої блудницї. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","І вернувся до Юди та й каже: Не знайшов, і люде міські кажуть: Не було тутеньки нїякої блудницї. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Каже ж Юда: Нехай візьме собі, аби не сьміялись із нас; бо я послав кізлика, ти ж не знайшов. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","І сталось через три місяцї, повідано Юдї: Зблудила Тамара, невістка твоя, і вже завагонїла від блуду. Каже ж Юда: Виведїт її, нехай спалять. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Вона ж, як її ведено, послала до свекра свого говорючи: Від того чоловіка, чиє оце, я завагонїла. І каже: Познавай, чий се перстень з печаткою, пояс і палиця. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Упізнав же Юда, та й каже: Оправдалась Тамара лучче мене; бо не оддав я її за Селу, сина мого. І не взнав її вже більше. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Сталося ж, як роджала, що були близнята в утробі її. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Сталося ж, як роджала, висунуло ручку, і взявши баба-сповитуха, перевязала ручку йому червоною ниткою, говорючи: Се вийшло перве. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","І сталось, як потягло назад ручку, дивись, вийшов брат його. Вона ж каже: Як се ти прорвавсь? І дала йому імя Перез. ");
INSERT INTO ukr1871_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","А потім вийшов брат його, і в його на ручцї була червона нитка. І дала імя йому Серах. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Йосифа ж приведено в Египет, і купив його Потифар, дворянин Фараонів, гетьман вартовиків його, Египтянин, із рук Ізмайлитян, що привели його туди. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","І був Господь із Йосифом, так що у всьому йому таланило, і жив у дому в свого пана, Египтянина. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Бачив же пан його, що Господь із ним, і що нї робить, Господь щастить руцї його. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","І знайшов Йосиф ласку в очах його, і вслуговував йому, і той поставив його над усїм домом своїм, і все, що мав, оддав у руки його. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","І сталось того часу, як поставив його над домом своїм і над усїм майном своїм, Господь благословив Египтянина задля Йосифа, і було благословеннє Господнє на всьому, що мав у господї і в полї. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","І передав усе, що мав, Йосифові, і не знав нїчогісїнько в свойму майнї, опріч хлїба, що їв. І був Йосиф гарний станом і вродливий видом вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","І сталось по сих речах, що жона пана його накинула оком Йосифа, та й каже: Лязь ізо мною. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Він же не схотїв, і каже свого пана жонї: Дивись, пан мій не знає за мною нїчогісїнько в дому свойму, і все, що має, віддав у руки мої. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","І нїкого нема над мене в дому сьому, і невдержано від мене нїчого, опріч тебе; бо ти жона йому єси. Як же вчиню ледарство велике се й гріх перед Богом? ");
INSERT INTO ukr1871_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","І сталось, як вона підмовляла Йосифа день у день, не послухав її, щоб лягти з нею й жити з нею. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","І сталось одного такого дня, що ввійшов Йосиф у будинок справляти справи свої, і не було нїкого з домовників у серединї. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","І вхопила його за одежу говорючи: Лягай зо мною. І покинув одежу свою в руках її, та й утїк геть. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","І сталось, як побачила, що покинув одїж свою в руках її, та втїк геть, ");
INSERT INTO ukr1871_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Гукнула на домовників, та й каже їм: Бачте, увів до нас Єврея, щоб насьміявсь із нас. Увійшов до мене, та й хотїв лягти зо мною, так я закричала голосно. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","І сталось, як почув, що я зняла крик та загукала, покинув одїж свою в мене, да метнувсь на втеки. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","І положила одїж його коло себе, докіль прийде пан його до дому. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","І повідала йому такими словами: Прийшов до мене парубок Єврей, що ввів єси до нас, посьміятись із мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","І сталось, як зняла голос, та закричала, він покинув одїж свою, та й побіг втеком. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","І сталось, як почув пан його слова жони своєї, що каже до його: От яким робом пійшов парубок твій, запалав гнївом, ");
INSERT INTO ukr1871_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","І взяв Йосифа пан, вкинув його в темницю, туди, де вязники цареві седїли в неволї, і пробував там у темницї. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Но Господь був з Йосифом і змилосердивсь до його, і дав йому ласку в очу доглядника темничнього. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","І віддав доглядник темничний в руки Йосифові всїх позакиданих у темницю, і все, що там роблять, роблено за його порядкуваннєм. ");
INSERT INTO ukr1871_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Доглядник же темничний не дозиравсь нї до чого під його руками; бо Господь був із ним, і що він чинив, у всьому Господь помагав йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Сталося ж по сих речах, провинив дука винарський в царя Египецького, і дука пекарський пановї свойму, цареві Египецькому. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","І розгнївився Фараон на обох дворян своїх, на дуку винарського й на дуку пекарського. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","І повкидав їх у темницю в домі гетьмана вартовиків, у те місце, куди вкинуто Йосифа. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","І приручив їх доглядник темничний Йосифові, і служив їм, і пробували вони довгий час у темницї. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","І бачили обидва сни ув одну ніч, і кожен угадував свій сон по свойому, дука винарський і дука пекарський царя Египецького, що седїли в темницї. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Увійде ж до них Йосиф уранцї і бачить, вони посуміли. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","І поспитав дуків Фараонових, що були з ним у темницї в пана свого: Чого ви дивитесь так сумовито сьогоднї? ");
INSERT INTO ukr1871_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Вони ж кажуть йому: Сон снився нам, а вгадника йому нема. Каже ж їм Йосиф: Чи не від Бога ж угадуваннє? Ось, роскажіте лишень менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","І повідав дука винарський сон свїй Йосифові, та й каже: У снї мойму, бачся, виноградний кущ передо мною, ");
INSERT INTO ukr1871_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","У виноградного ж куща три вітки, і неначе процьвів, і виросли сьпілі грони. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","А чаша Фараонова в руцї в мене. І взяв я грону, і видавив у чашу, та й подав чашу в руки Фараонові. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","І каже йому Йосиф: От проти чого се снилось. Три грони, се три днї. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Через три днї підійме Фараон голову твою, та й верне тебе на місце твоє; і подавати меш Фараонові чашу до рук його прежнїм звичаєм, як був єси його винарем. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Спогадай же на мене, як добре тобі буде і змилосердись до мене, та й нагадай про мене Фараонові, та й визволь мене з твердинї сієї. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Мене ж бо вкрадено з країни Єврейської; і тутеньки нїчого лихого не вкоїв я, щоб мене вкинути в темницю. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","І вбачав дука пекарь, що гаразд угадує, та й, каже Йосифові: А менї снилось, бачся, три кошики хлїба на голові в мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","І в верхньому кошику всякий хлїб до вподоби Фараонові, да птаство небесне росклювало все з кошика на голові в мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Відказав же Йосиф кажучи: От проти чого снилось. Три кошики, се три днї. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Через три днї підійме в гору від тебе Фараон голову твою, і повісить на дереві тебе, і поїсть птаство небесне тїло твоє з тебе. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Сталося ж на третїй день, припав день родження Фараонового, і він справив пир усїм дворянам своїм, і підняв угору голову дуцї винареві свойму і дуцї пекареві свойму, посеред своїх дворян. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","І поставив дуку винарського на місце його знов, щоб подавав той чашу до рук Фараонових, ");
INSERT INTO ukr1871_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Дуку ж пекаря велїв повісити на дереві; як віщував Йосиф їм. ");
INSERT INTO ukr1871_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Однак не спогадав дука винар царський Йосифа, байдуже про його. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Сталося ж у концї двох повних лїт, Фараон бачив сон. Бачся, стояв він при ріцї. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","І се, нїби з річки, вийшло семеро корів гарних і ситих, та й пасуться в лузї. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Аж ось і других семеро корів вийшло поганих на вид і худих, да й стоять коло тих корів на річному березї. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","І пожерли семеро корови погані сїмох корів гарних і ситих. І прокинувсь Фараон. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","І заснув, і снилось йому в друге: бачся семеро колосків жита виходило з одного стебла, товстих і повних. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","А ж ось других семеро колосків, тоненьких і висушених східним вітром, виросло за ними. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","І пожерли семеро колоски тоненькі і вітром спалені семеро колосків товстих та повних. Прокинеться ж Фараон, аж то сон. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","І сталось уранцї, стрівожився дух його, і пославши скликав усїх віщунів Египецьких і всїх мудрагелїв тамошнїх. І росказав їм Фараон сон свій, та й не було нїкого, щоб умів його витолкувати Фараонові. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Озветься ж дука винарський до Фараона: Мушу спогадати кривду мою. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Розгнївився Фараон на раби свої та й укинув нас у темницю в дому гетьмана вартовницького, мене та дуку пекарського. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","І бачили ми сон обидва тієї ночі, я й він, кожному проти иншого снилось. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Був же там із нами молодик Єврей, раб гетьманський вартовницький; і росказали ми йому, і виложив нам наші сни, кожному виложив сон його. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Сталося ж, як виложив нам, так і справдилось: мене вернено на моє дуківство, а того повішено. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Пославши ж Фараон, прикликав Йосифа. І виведено його негайно з хурдиги. І остригся він і перемінив одїж на собі, і прийшов до Фараона. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Каже ж Фараон Йосифові: Бачив я сон, а хто б витолкував, такого нема; я ж чув про тебе, кажуть, що, чувши сни, вмієш толкувати. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Відказуючи ж Фараонові Йосиф каже: Не я, нї! Бог дасть Фараонові відповідь упокійну. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Каже ж Фараон Йосифові: Снилось менї: бачся, стою на березї річному. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Аж се — із ріки вийшло семеро корів гарних і ситих, та й пасуться в лузї. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Аж се — других семеро вийшло слїдом за ними, сухі і дуже погані видом і худі тїлом такі, що й не бачив я по всїй землї Египецькій. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","І пожерли семеро корови погані сїмох корів ситих. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","І як вони пожерли їх, не знати було, що вони ввійшли в утробу їх, і вид їх був такий самий, як і перш. Прокинувся я та й знов заснув. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","І бачив я вві снї мойму, неначе семеро колосків виросло з одного стебла повних і добрих. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Другі ж семеро колосків тоненьких и спалених вітром виросли слїдом за ними. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","І пожерли семеро засохлі колоски і спалені вітром сїмох колосків добрих і повних. І росказав я віщунам, та не було нїкого, щоб менї те зʼясувати. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","І каже Йосиф Фараонові: Сон Фараонів один: що Бог творити ме, показав Фараонові. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Семеро коров гарних — сїм років, і семеро колосся доброго — сїм років; сон один. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","І семеро коров худих і поганих, що вийшло за ними, сїм років, і семеро порожних колосків, спалених східним вітром, се буде сїм років голодних. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Оце воно, що я сказав Фараонові: Що хоче Бог творити, він показав Фараонові. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Дивись, оце настануть сїм лїт великого врожаю по всїй Египецькій землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Прийде ж і сїм лїт голодних за ними; і забудуть про наддостаток в Египецькій землї, і погубить землю сю голоднеча. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","І не знати муть уроджаю в землї сїй від голоднечі тієї, що йде за ним; тяжка бо буде вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Приснився ж сон Фараонові двічі про те, що се постане від Бога, і незабаром приведе Бог се в дїло. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Тим нехай Фараон вигледить чоловіка мудрого й зугадного, та й поставить його над Египецькою землею. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Нехай се вчинить Фараон і поставить доглядника по землї, і нехай одбирає пятину в Египецькій землї у сїм роках уроджайних. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","І нехай громадять усяку харч за сїм добрих лїт, що настають, і нехай ссипають пшеницю під руку Фараонові, і нехай харчі приховують по городах. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","І буде харч прихована про запас землї на сїм років голодних, що настануть у землї Египецькій, щоб земля не погибла в голоднечу. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Угодно ж се було в очу Фараонові і в очу всїх дворян його. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","І каже Фараон дворянам своїм: Чи можна ж нам ізнайти чоловіка такого, щоб на йому та був дух Божий? ");
INSERT INTO ukr1871_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Каже ж Фараон Йосифові: Після того, як Бог показав тобі се все, нема нїкого такого зугадного й мудрого, як ти. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ти сам будеш над моїм домом, і слухати ме слова твого все царство моє; тілько престолом я більший над тебе буду. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Промовив же Фараон до Йосифа: Се поставляю тебе над усїєю землею Египецькою. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","І знявши Фараон перстеня з руки своєї, надїв його на руку Йосифові, і вдїг його в шати білі, і возложив ланьцух золотий йому на шию. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","І посадив його на колесницю свою другу, і вигукувано перед ним: Навколїшки! Сим робом поставив його над усїєю землею Египецькою. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Промовив же Фараон до Йосифа: Я Фараон, та без тебе не махне й рукою і не поступить ногою нїхто в землї Египецькій. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","І дав Фараон імя Йосифові Зафнат Панеях, і дав йому за жену Аснату, дочку Потифера, сьвященника Онського. І знявсь Йосиф над Египтом. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","І було Йосифові трийцять лїт, як він став перед Фараоном, царем Египецьким. І вийшов Йосиф од Фараона та й пройшов по всїй землї Египецькій. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Земля ж зародила сїм год урожаєм, наче жменями. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","І назбирав усякої харчі за сїм год, яка була на землї Египецькій, та й поприховував харч по городах. Харчі з поля, навкруги города, поприховував у тому ж городї. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","І назбирав Йосиф пшеницї, мов би піску морського, багато вельми, що погубив і лїки; було бо безлїч. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","В Йосифа ж родилось два сини до настання семи год голодних, що вродила йому Асната, дочка Потифара, сьвященника Онського. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Дав же Йосиф імя первому Манассїй: Менї бо, рече, дав Бог забути всю недолю мою й усе в господї панотцевій. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Імя ж другому нарік Ефрем; бо зробив мене плодющим Бог у землї бідування мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Минуло ж сїм років урожайних, що були в землї Египецькій. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","І почали голодних сїм год наставати по слову Йосифовому. І був голод по всїй землї; у всїй же землї Египецькій був хлїб. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Як же заголодала й земля Египецька, заквилили люде до Фараона про хлїб. Каже ж Фараон усїм Египтянам: Ідїте до Йосифа, і, що скаже вам, чинїте. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","А голоднеча придавила ввесь сьвіт. Поодчиняв же Йосиф усї житницї, та й продавав хлїб усїм Египтянам. ");
INSERT INTO ukr1871_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Кинулись тодї всї землї до Йосифа в Египет; бо всюди панував страшний голод. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Бачивши ж Яков, що є на продаж хлїб у Египтї, каже синам своїм: Чого позираєте один на одного? ");
INSERT INTO ukr1871_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Я ж чув, що є хлїб в Египтї. Рушайте туди, та купіте таменьки хлїба, щоб нам жити, не повмірати. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Рушило браттє Йосифове, десятеро братів, куповати хлїба, в Египет: ");
INSERT INTO ukr1871_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Бенямина ж, брата Йосифового, не відпустив Яков із браттєм його, каже бо: Коли б не сталась йому в дорозї пригода! ");
INSERT INTO ukr1871_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Поприходили ж синове Яковові куповати хлїба з приходнїми, була бо голоднеча в Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Йосиф же правив землею; він і продавав усїм землянам. Поприходивши ж брати Йосифові вклонились йому лицем до землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Побачивши Йосиф браттє своє впізнав, та почужив їх, і говорив до них жорстоко, і каже їм: Звідкіля прийшли? Вони ж кажуть: Із Канаан землї, купити хлїба. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Упізнав же Йосиф браттє своє, вони ж не впізнали його. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","І спогадав Йосиф сни свої, що снились про їх, і каже їм: Ви пронири! Прийшли вишпіонувати проходи в землї сій. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Вони ж кажуть: Нї, пане добродію! раби твої прибули купити харчі собі! ");
INSERT INTO ukr1871_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Всї ми синове одного чоловіка, вірняки. Раби твої, не підглядники. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Каже ж їм: Нї! Перевідати прийшли проходи в землю сю. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Вони ж кажуть: Дванайцятеро нас братів, рабів твоїх, у Канаан землї. Меньший тепереньки з отцем нашим, а одного немає. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Каже ж їм Йосиф: Се ж воно й є те, що я сказав вам: ви пронири. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ось чим оправдитесь: Бодай так був жив Фараон! Не вийдете звідсї, коли брат ваш меньший не прийде сюди. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Пошлїть одного зміж вас, і нехай приведе брата вашого; а вас держати муть у вязницї, докіль справдяться ваші слова: чи в вас є правда, чи нї. Як же нї, бодай так був жив Фараон, ви пронири. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","І віддав їх під варту на три днї. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Каже ж їм третього дня: От що вчинїте, так останетесь живі; бо я собі людина богобоязлива. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Коли ви певняки, нехай один з між братів седить у неволї, де вас вартують, а ви йдїть, вистачити хлїб вашій семї, в вашу господу. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","А брата вашого меньшого приведїте до мене, так і правдиві будуть ваші слова, і не загинете. І вчинили так. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","І каже одно одному: Ой справдї ми провинили братові нашому тим, що занедбали скорботу душі його, як благав нас, та й не послухали! Тим прийшла на нас така печаль. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Відказуючи ж Рубен, каже їм: Хиба ж я не казав вам: Не согрішайте на дитинї! Та не послухали. Оце кров його жадається від нас. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Вони ж не відали, що їх розуміє Йосиф; бо промовляв до них через товкмача. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Та й одвернувшись од них, сплакав Йосиф, і прийшовши знов до них розмовляв із ними та, взявши Симеона від них, звязав його перед віччу в них. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Повелїв же Йосиф понасипати торби їх пашнею, та й вернути кожному гроші в його торбину, та й обмислити їх живностю на дорогу. І сталось так. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","І навючивши пашню на осли свої, рушили звідти. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Розвязавши один торбину свою, щоб усипати оброку ослам своїм на попасї, побачив гроші свої; бо вони були зверху, в устї мішковому. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","І каже браттю свойму: вернено менї гроші; ось вони в торбі моїй. І охляло серце в їх, і поторопіли, говорючи одно одному: Що се вдїяв нам Бог? ");
INSERT INTO ukr1871_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","І прийшли до Якова, отця свого, в Канаан землю, і оповідали все, що сталось їм, і казали: ");
INSERT INTO ukr1871_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Промовляв до нас господар землї тієї жорстоко, і вважав нас за розглядників його землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ми ж йому казали: Певняки ми, не розглядники. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Дванайцятеро братів нас синів отецьких; одного нема, меньший же з панотцем нашим тепереньки в Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Каже ж нам господар землї тієї: От із чого я взнаю, що ви певняки. Брата одного покиньте в мене, і забирайте куплений хлїб, задля голоду в домівцї вашій, та й рушайте. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","І приведїте до мене брата вашого меньшого; тодї знати му, що не розглядники ви а вірняки. І брата вашого тодї оддам вам, і можете орудувати в нашій землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","І сталось, як спорожняли торби свої, диво, узлик із грошима в кожного в торбі його. І бачивши узлики грошей своїх, і самі і їх отець полякались. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Каже ж їм Яков, отець їх: Зробили ви мене бездїтним. Нема Йосифа, нема й Симеона; чи то ж і Бенямина візьмете? Це все на мене! ");
INSERT INTO ukr1871_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Каже ж Рубен отцеві свойму: Убий два сини мої, коли не приведу його до тебе. Приручи його менї; я приведу його до тебе. ");
INSERT INTO ukr1871_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Він же рече: Не пійде син мій з вами; бо його брат умер, а сей один остався. Як станеться йому пригода в дорозї, що верстаєте, дак зведете смутком моє сиве волосє в землю на той сьвіт. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Голоднеча ж налягла тяжко на землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","І сталось, як поїли хлїб, що привезли з Египту, каже їм отець їх: Знов ідїте й купіте нам хлїба трохи. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Каже ж йому Юда: Клятьбою клявся нам господар Египецький: Не побачите лиця мого, коли брат ваш меньший не прийде з вами. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Так як пошлеш брата нашого з нами, пійдемо й купимо тобі пашнї. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Коли ж не пошлеш брата нашого з нами, не пійдемо; муж бо громадський промовив до нас: Не бачити мете лиця мого, коли брата вашого не буде з вами. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Каже ж Ізраїль: Про що ви заподїяли зло менї, повідавши мужові, що в вас іще є брат? ");
INSERT INTO ukr1871_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Вони ж кажуть: Допитом допитувавсь у нас громадський муж і про нашу родину: Чи ще жив ваш панотець? Чи маєте ще брата? І ми оповідали йому по розуму слова сього. Чи то ж ми знали, що скаже нам: Приведїте брата вашого? ");
INSERT INTO ukr1871_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Каже ж Юда до Ізраїля, панотця свого: Відпусти хлопця зо мною, так знїмемось і пійдемо, щоб живими бути, не повмирати й самим і малечі нашій. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Я сам буду йому зарукою; з рук моїх вимагати меш його. Коли не приведу його до тебе, й не поставлю його перед тобою, нехай буду грішен перед тобою непрощено довіку. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Бо коли б ми не гаялись, певно б уже звернулись двічі. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Каже ж їм отець їх Ізраїль: Коли так воно є, чинїте по свойму. Понабирайте ж того, що родить у нас найлуччого в торби, та й везїте громадському мужеві тому гостиньця: трохи бальзаму та трохи виноградного меду, траганту та ладану, і писташок, оріхів і мигдалю. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","А грошей возьміть удвоє з собою; а ті гроші, що познаходили в торбах ваших, везїть назад з собою. Може, то недогляд. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","І брата свого возьміть, і знявшись ідїть ізнов до громадського мужа. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Бог же Всемогущий нехай дасть вам ласку в очу громадського мужа, щоб одпустив брата вашого Бенямина. А коли менї вже бути бездїтним, то буду бездїтним. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Узявши ж мужі гостиньця та грошей удвоє з собою та Бенямина, знялись, та й прийшли в Египет, і стали перед Йосифом. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Побачив же їх Йосиф і Бенямина, брата свого, і каже старшому над його господою: Уведи людей в будинок, та заколи що й уготуй; ізо мною бо трапезувати муть люде о полуднї. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Зробив же чоловік, як звелїв Йосиф, і ввів людей у будинок Йосифів. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","І полякались люде, що введено їх у будинок Йосифів, і мовляли: Задля грошей, що були у торбах наших, уводять нас, щоб знайти причину проти нас, і напасти на нас, та й позабирати в раби нас, і осли наші. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Приступивши ж до старшого над господою Йосифовою, розмовляли з ним у царинї будинковій ");
INSERT INTO ukr1871_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Так. Пане добродїю, благаємо тебе: поприходили ми спершу купити пашнї. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Сталося ж, як зупинились на попас, та порозвязували торби свої, аж се гроші кожного в торбинї його, в устї. Ті гроші вертаємо по вазї тепереньки руками нашими. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","А гроші другі привезли з собою купити харчі. Не відаємо, хто вложив гроші нам у торби. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Каже ж їм: Мир вам! Не лякайтесь. Бог ваш і Бог отця вашого дав вам скарб у ваші торби, а гроші ваші в мене. І привів до них Симеона. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","І принїс води їм пообмивати ноги, і дав паші ослам їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Наготовили ж вони гостиньця, докіль прийде Йосиф о полуднї; чули бо, що там обідати муть. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","І прийшов Йосиф до дому, і принесли йому гостиньця, що наготовили, та й уклонились йому лицем до долївки. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","І поспитав у них про їх здоровлє, і каже: Чи здужає панотець ваш старенький, що мовляли? Чи ще жив? ");
INSERT INTO ukr1871_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Вони ж кажуть: В доброму здоровї раб твій, отець наш; іще жив. І понахиляли голови, та й уклонились до долївки. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","І споглянув очима своїми, і побачив Бенямина, брата свого єдиноматернього, і спитав: Чи се брат ваш найменьший, що про його казали менї? І каже: Бог нехай милує тебе, дитино! ");
INSERT INTO ukr1871_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Замішався і з упинивсь Йосиф; поривало бо душу його до брата його, і шукав, де сплакнути; і увійшовши у ложницю, заплакав там. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","І вмивши лице, вийшов, перемігся й каже: Подавайте хлїб сїль! ");
INSERT INTO ukr1871_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","І подано йому окроме, а тим окроме, і Египтянам, що з ним обідали. Не можуть бо Египтяне їсти з Євреями; гидують бо тим Египтяне. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Посїли ж проти його, первенець по родовому праву свойму, а наймолодший по недолїцтву свойму; і дивувались вони один одному. ");
INSERT INTO ukr1871_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","І посилались їм частки сперед його; більша ж була частина Беняминова над усї частки впятеро. Пили вони й попивали із ним у веселостї. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","І повелїв Йосиф старшому над господою його говорючи: Посповнюй людям торби пашнею, скільки винесуть, і повкладай кожному гроші в усьтє торби його зверху. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","А чашу мою срібну вложи в торбу меньшому і гроші його за пашню. І зроблено по слову Йосифовому. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","День заднився, людей одпущено, самих і ослят їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Вийшовши вони з городу, не відойшли ще далеко, як повелїв Йосиф домозверхникові свойму: Гой! уставай, та вганяй слїдом за людьми; наздожени їх і скажи: Так се ви платите злом за добро? ");
INSERT INTO ukr1871_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Та ж се кубок, що пє з його пан мій; він же й ворожбу ворожить по йому. Зло вдїяли ви таке заподїявши. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Наздогнавши ж їх, каже по наказу сьому. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Вони ж йому: Про що говорить пан добродїй слова такі? Не таківські раби твої, не зроблять по слову сьому. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ми ж тобі ті гроші, що познаходили в торбах у себе, вернули з Канаан землї: Як же б украли з дому в пана твого срібло чи золото? ");
INSERT INTO ukr1871_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","У кого з рабів твоїх воно знайдеться, тому смерть, а ми будемо рабами панові нашому. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Він же каже: Нехай же й се, як мовляли, так буде. У кого воно знайдеться, нехай буде мій раб, ви ж чисті будете. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","І метнулись, і скинув кожен торбу свою на землю, і розвязав кожен торбу свою. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","І шукав, від старшого почавши, докіль дойшов до меньшого, та й знайшов чашу в торбі Беняминовій. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","І пороздирали одїж свою, і навючивши кожен осла свого, вернулись у город. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Увійшов же Юда й браттє його до Йосифа в будинок, він же був там, та й попадали перед ним на долївку. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Каже ж їм Йосиф: Що се за дїло ви вдїяли? Хиба не відаєте, що нема такого ворожбита, як я? ");
INSERT INTO ukr1871_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Каже ж Юда: Що відкажемо панові добродїєві мойму, що промовимо? Або чим оправдуватись нам? Бог ізнайшов кривду в рабів твоїх. Оце ж ми раби панові добродїєві нашому, і ми й він, у кого знайшлась чаша. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","І каже він: Таку річ не менї вчинити. Той, у кого знайшовся кубок, буде менї раб; ви ж ідїте до панотця вашого не зайняті в неволю. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Приступивши ж до його Юда, каже: Благаю й молю тебе, пане добродїю, дозволь рабові твойму промовити слова в уші пана добродїя свого, і не прогнївись на раба твого; ти ж бо єси з Фараоном рівен. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Пане добродїю! Питав єси в рабів твоїх словами: чи маєте отця або брата? ");
INSERT INTO ukr1871_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","І промовили ми панові добродїєві: Є в нас отець старенький і хлопя старощів його, а брат його вмер, він же один остався у матері своєї, і панотець улюбив його. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ти ж мовляв рабам твоїм: Приведїте до мене, щоб я споглянув на його. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","І відказали ми панові добродїєві: Неможлива річ хлопцеві покинути панотця свого; коли ж покинув би панотця свого, умер би. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ти ж промовив єси до рабів твоїх: Як не прийде брат меньший ваш, більш не бачити мете лиця мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Сталося ж, як прийшли ми до раба твого, панотця нашого, повідали ми йому слова пана добродїя нашого. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Каже ж нам панотець наш: Ідїть, ізнов та купіте трохи збіжа. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ми ж відказали: Не можлива річ ійти! Коли ж брат наш меньший пійде з нами, пійдемо; бо шкода вбачати нам у вічі мужа громадського того, як брат наш меньший та не буде з нами. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Каже ж раб твій, панотець наш, до нас: Ви знаєте, що двох уродила менї жена моя. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","І один пійшов од мене, і казав я: Певно розірвано його на шматтє, та й не бачив його й досї. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Коли ж оце візьмете й сього від мене, і станеться йому пригода, зведете старощі мої в смутку на той сьвіт. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Тим же то, як пійду я до раба твого, панотця мого, та хлопця не буде з нами? Душа ж бо його та звязана з душею малого, ");
INSERT INTO ukr1871_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Так станеться таке, що як побачить, що нема хлопця з нами, то певно й раби твої зведуть сиве волоссє раба твого, панотця нашого, смутком в землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Бо раб твій зробивсь порукою мойму панотцеві за хлопця, і ясив: Коли не приведу його до тебе, так нехай буду непрощений тобі до віку. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Тим же то буду тепереньки замість хлопця тобі рабом, а хлопець нехай іде з браттєм своїм. ");
INSERT INTO ukr1871_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Як бо менї йти до панотця, хлопця ж не буде зо мною? Не мушу вбачати лихої години, що побє панотця мого. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","І не здолїв більш перемогати себе перед усїма, що стояли навкруги, і закричав: Геть усї від мене! І не зісталось нїкого при Йосифі, як признававсь браттю свойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","І заплакав у голос, і почули Египтяне й уся господа Фараонова. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","І каже Йосиф браттю свойму: Я Йосиф! Чи жив іще панотець мій? І не здолїли брати відказати йому; стрівожились бо перед ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Каже ж Йосиф браттю свойму: Приступіте до мене. І приступили. І каже: Я Йосиф, брат ваш, що продали ви в Египет. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Тепер же не сумуйте, і не вдавайтесь у тугу, що продали мене сюди; про те бо, щоб ми були живі, послав мене Бог перед вами. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Се ж бо вже друге лїто голодує земля, а ще пять років осталось, що не буде нї оранки нї жнив. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","І послав мене Бог поперед вами переховати вам останок на землї, і ратувати ваші душі великим поратунком. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Оце ж не ви послали мене сюди, а Бог, і зробив мене отцем Фараонові, і паном усього його дому, і зверхником усієї землї Египецької. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ідїте ж хутко до панотця мого, і промовте йому. От що говорить син твій Йосиф: Бог зробив мене паном усього Египту; йди ж до мене, не гайся. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","І осядешся в Гозен землї, і будеш поблизу в мене, ти й дїти твої, і твоїх дїтей дїти, і вівцї твої, й воли твої, і все твоє. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","І харчувати му тебе; ще бо пять год буде голодних на землї, ато дійшов би до злиднїв і ти і дом твій і все твоє. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Оце ж очі ваші бачили й очі Беняминові, брата мого, що се уста мої промовляють до вас. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Возвістїте панотцеві мойму про всю славу мою в Египтї і про все, що ви бачили, та хутенько приведїте панотця мого сюди. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","І впавши на шию Беняминові, братові свойму, плакавсь над ним; і Бенямин плакавсь на шиї в його. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","І цїлуючи все браттє своє, плакавсь над ними, а потім промовляли до його брати його. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","І пронеслась чутка про се до господи Фараонової: Поприходили браттє Йосифове! І любо се було Фараонові й дворянам його. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Озветься ж Фараон до Йосифа: Скажи браттю твойму. От що вчинїте: Понавючуйте скотину свою та йдїть у Канаан землю, ");
INSERT INTO ukr1871_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","І, взявши батька вашого й родину вашу, прибувайте до мене; дам вам що найлучче в землї Египецькій, і живити метесь плодами землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ти ж повели їм узяти колесницї з Египецької землї про дїтей ваших, і жен ваших, і взявши батька вашого прибувайте; ");
INSERT INTO ukr1871_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","І не жалуйте домівок ваших; всї бо Египецькі блага вам будуть. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","І вчинили так дїти Ізрайлеві, і дав їм Йосиф колесницї по слову Фараоновому, і дав їм харчі на дорогу. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","І дав усїм їм на переміну одежі на дорогу, Беняминові ж дав триста секлїв срібла і пять одежин на переміну. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","А панотця свого він обіслав тим же робом і дав: десять ослів з уюками всїх благ Египецьких, і десять ослиць, вюкованих пашнею та хлїбом, і наїдками панотцеві свойму на дорогу. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Так відпустив своє браттє, і рушили; і каже їм: Гледїть, незаїдайтесь у дорозї. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","І вийшли з Египту, і прийшли в Канаан землю до Якова, батька свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","І оповідали йому говорючи: Ще жив Йосиф, і він господарує над усїєю землю Египецькою. І зомлїло серце Яковове, не звірявся бо їм. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Но переказували йому всї слова Йосифові, що промовляв до них, і як побачив колесницї, що послав Йосиф по його, тодї ожив дух Яковів, отця їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","І каже Ізраїль: Буде з мене! Йосиф, син мій, іще жив! Пійду, побачу його перш нїж умірати менї. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","І рушив Ізраїль з усїм своїм, і прийшов до Бейер-Саби, і принїс жертву Богові отця свого Ізаака. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","І рече Бог до Ізраїля в привиддях ночних, і рече: Якове! Якове! Він же озвавсь: Чую! ");
INSERT INTO ukr1871_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","І рече: Я Бог, Бог отцїв твоїх. Не опасуйся спуститись у Египет; народом бо великим сотворю тебе там. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Я сам із тобою спущусь у Египет, і я ж возведу тебе, і Йосиф положить руку свою на очі твої. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","І рушив Яков од Бейер-Саби, і повезли сини Ізраїлеві панотця свого і малечу свою, і жени свої на колесницях, що послав Фараон по його. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","І позабирали статки свої й усе майно, що надбали в Канаан землї, і прибули в Египет Яков і все насїннє його з ним. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Сини свої і сини синів своїх, дочки свої і дочки синів своїх, і все насїннє своє привів у Египет із собою. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Се ж імена синів Ізрайлевих, що поприходили в Египет: Яков та сини його; первенець Яковів: Рубен. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Синове ж Рубенові: Ганох та Паллуй, Хезрон та Кармїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Синове ж Симеонові: Ємуїл і Ямин та Огад та Яхин та Зогар та Савул, син Канаанки. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Синове ж Левієві: Герсон, Кагат та Мерарій. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Сини ж Юдові: Гер та Онан та Села та Перез та Серах; повмирали ж Гер та Онан у Канаан землї. А синове Перезові були: Гезрон та Гамуль. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Синове ж Іссахарові: Тоса та Пува та Йов та Симрон. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Синове ж Зебулонові: Серед та Елон та Яхлеїль. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Се Леїні синове, що вродила Яковові в Падан-Арамі, та Дину, дочку його. Усїх душ синів його і дочок його трийцять і три душі. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Синове ж Гадові: Зифйон та Гаггій, Сунїй та Єзбон, Єрій та Ародїй та Арелїй. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Синове ж Ассерові: Імна та Ішва та Ішвій та Берія, та Сераха, сестра їх. Синове ж Берієві: Гебер та Малкієль. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Се сини Зелфи, що дав Лабан Леї, дочцї своїй, що вродила їх Яковові шіснайцятеро душ. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Синове ж Рахелї, жони Яковової: Йосиф та Бенямин. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","І родились Йосифові в Египецькій землї: Манассїй та Ефраїм, що вродила йому Асната, дочка Потифара, сьвященника Онського. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Синове ж Беняминові: Бела та Бехер та Асбель, Гера та Нааман, Єхій та Рош, Муппим та Гуппим та Ард. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Се синове Рахелині, що вродила їх Яковові, всїх, душ чотирнайцятеро. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Синове ж Данові: Гусим. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Синове ж Нафталїєві: Яхзеєль та Гунїй та Єзер та Силлем. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Се синове Білжині, що дав її Лабан Рахелї, дочцї своїй, і вродила їх Яковові всього сїм душ сих. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Усїх же душ, що поприходили з Яковом в Египет, і що повиходили з чересел його, опріч жінок синів Яковових, всїх душ шістьдесять і шість. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Синове Йосифові, що понароджувались йому в Египтї, дві душі. А всїх душ дому Яковового, що прийшли з Яковом у Египет, душ сїмдесять. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Юду ж послав перед собою до Йосифа направляти лице його до Госену. Як прибули ж вони в Госен землю, ");
INSERT INTO ukr1871_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Запріг Йосиф колесницю свою, і поїхав назустріч Ізраїлеві, панотцеві свойму в Госен, і побачив його, і впав йому на шию, і плакався плачем великим. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","І каже Ізраїль до Йосифа: Тепер хоч і вмерти, бо побачив лице твоє; жив єси! ");
INSERT INTO ukr1871_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","І каже Йосиф свойму браттю та всему домові панотця свого: Поїду, сповіщу Фараона, і скажу йому: браттє моє, та дом панотця мого, що були в Канаан землї, прибули до мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Вони ж чабани собі; їх ремество було випасувати скотину, і поприганялись із вівцями й товариною і з усїм статком своїм. ");
INSERT INTO ukr1871_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Як же прикличе вас Фараон, і скаже вам: Яке ваше ремество? ");
INSERT INTO ukr1871_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Кажіте: Чабани єсьмо, раби твої, змалку та й по сей день, і ми й батьки наші, щоб вам осїстись у Госен землї. Чабанами ж бо гидують Египтяне. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","І прибув Йосиф і спосвістив Фараона й каже: Панотець мій і браттє моє, з вівцями й товариною й з усїм статком своїм, прибули із Канаан землї, і се вони в Госен землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Та й із браття свого взяв пятеро чоловіка, та й поставив їх перед Фараоном. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","І промовив Фараон до браття Йосифового: Яке ремество ваше? Вони ж відказали Фараонові: Чабани, раби твої, ми й батьки наші змалку та й по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Мовляли вони й надто Фараонові: Перебувати в землї поприганялись; нема бо пасовища вівцям у рабів твоїх; опанував бо голод Канаан землю. Тепереньки ж благаємо, дозволь оселитись у Госен землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","І промовив Фараон Йосифові: Отець твій і браттє твоє прибули до тебе. Се земля Египецька перед тобою. На щонайлуччій землї осели отця твого і браттє твоє. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Нехай селяться в Госен землї; і коли знаєш яких людей спосібних між ними, так настанови їх доглядниками над скотиною моєю. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","І привів Йосиф отця свого, та й поставив його перед Фараоном. І благословив Яков Фараона. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","І промовив Фараон до Якова: Скільки років життя твого? ");
INSERT INTO ukr1871_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","І каже Яков Фараонові: Життя мого на сьвітї сто і трийцять лїт. Малі й важкі були лїта життя мого, не досягли до лїт життя отцїв моїх на сьвітї. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","І благословивши Яков Фараона, вийшов зперед Фараона. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","І поселив Йосиф панотця свого й браттє своє, і дав їм державу в землї Египецькій, на луччій землї, в Раємзес землї, як повелїв Фараон. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","І надїляв Йосиф отця свого й браттє своє й усю родину хлїбом, по лїчбі дїтей. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Хлїба ж не стало по всїй землї, голод бо тяжкій був; омлївала й Египецька земля й Канаан земля з голоднечі. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","І позбирав Йосиф усї гроші, які знайшлись у землї Египецькій і в Канаан землї, за хлїб, що куповали люде; і повносив Йосиф усї гроші в палати Фараонові. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","І як повитрачувано всї гроші в землї Египецькій і в Канаан землї, поприходили тодї всї Египтяне до Йосифа говорючи: Дай нам хлїба! Чому бо вмірати нам перед віччу в тебе? Кінець бо вже нашим грошам. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","І каже їм Йосиф: Так пригоньте скотину вашу, я й давати му вам хлїба за скотину, коли кінець вашій грошві. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","І стали приганятись із скотом до Йосифа, і давав їм хлїба Йосиф за конї, й за вівцї, й за воли, і за осли; і прохарчував хлїбом їх за всю скотину їх у тому роцї. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","І минув той год, і поприходили до його на другий год і мовляли до його: Не таїти мемо від пана добродїя нашого, що наші гроші повитрачувались, а наша скотина в нашого пана добродїя. Не зісталось перед віччу в пана добродїя нашого вже нїчого, як тільки тїло наше та земля наша. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Чи то ж нам гинути перед очима в тебе, і нам, і нашій землї? Купуй нас і землю нашу за хлїб, і будемо самі й земля наша рабами Фараонові. Давай нам тільки насїння на засїв, та й живі будемо, не помремо, і земля не спустїє. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","І поскуплював Йосиф землю Египецьку Фараонові; попродали бо Египтяне землю свою Фараонові через те, що голод опанував їх. І земля стала Фараоновою. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","А людей попереселяв він у городи з одного кінця Египту та й до другого. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Тільки землї сьвященників не поскуплював, одержали бо сьвященники свій пай од Фараона і жили з того паю, що давав їм Фараон; тим і не попродали вони землї своєї. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","І каже Йосиф усїм Египтянам: Оце купив я вас і землю вашу Фараонові. От вам насїннє, возьміте і засївайте землю. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","А з урожаю давати мете пятину Фараонові, чотирі ж пятини будуть вам на засїв землї, та про малечу вашу. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","І казали: Вирятував єси нас од смертї; дай же нам ізнайти ласку в очу в тебе, пане добродїю, щоб нам бути рабами Фараонові. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","І поставив їм Йосиф устав аж по сей день, пятину з землї давати Фараонові. Тілько земля священників не зробилась Фараоновою. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","І пробував Ізраїль у землї Египецькій, у Госен землї, і мали вони в їй наслїдню державу, і були плодющі й намножувались велико. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","І пожив Яков у землї Египецькій сїмнайцять років, а було днїв Якового життя сто і сорок і сїм років. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","І прийшла година Ізраїлеві вмерти. І прикликав сина свого Йосифа і каже йому: Коли знайшов я ласку в очах твоїх, підложи руку твою під стегно моє, що сотвориш надо мною милость і правду. Не ховай мене в Египтї! ");
INSERT INTO ukr1871_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Нї! хочу лежати з отцями моїми, і винесеш мене з Египту, та й поховаєш мене в гробовищі їх. Він же каже: Сотворю по слову твойму. ");
INSERT INTO ukr1871_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","І каже: Кленись менї! І поклявсь йому: І приклонився Ізраїль на підголовку постелї своєї. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","І сталося після річей сих, що повідано Йосифові: Панотець твій знемагає. І взявши два сини свої, Манассїю та Ефраїма, вибрався в дорогу. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","І повідано Яковові: Син твій Йосиф іде до тебе. І вкрепившись Ізраїль сїв на постелї. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","І каже Яков до Йосифа: Бог мій явивсь менї в Лусї, в Канаан землї, і благословив мене. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","І рече менї: Се я вирощу тебе і намножу тебе, і сотворю тебе купою народів, і дам тобі землю сю і насїнню твойму по тобі у державу віковічню. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Тепер же два сини твої, що вродились тобі в землї Египецькій, перше мого прибуття до тебе в Египет, мої вони: Ефраїм та Манассїй; як Рубен і Симеон будуть мої. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Сини, що появиш по сих, будуть уже твої, і називати муться по прізвищам браття твого в наслїддї свойму жеребовому. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Я ж, як ійшов із Падан-Арама, умерла Рахеля, мати твоя, в Канаан землї в дорозї до Ефрата, се Бетлегем. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Побачивши ж Ізраїль сини Йосифові, каже: Хто се? ");
INSERT INTO ukr1871_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","І каже Йосиф панотцеві свойму: Се мої сини, що Бог дав менї тутеньки. І каже Яков: Приведи їх до мене, щоб їх благословити. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Очі ж Ізраїлеві тяжко бачили від старощів і не зміг розгледїти. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","І каже Ізраїль до Йосифа: Не думав я вбачати лице твоє, аж ось Бог показав менї і насїннє твоє. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","І вивів їх Йосиф із між колїн його, та й уклонивсь йому лицем до землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","І взявши Йосиф два сини свої, Ефраїма в правицю, проти лївиці Ізраїлевої, Манассїю ж у лївицю, проти правицї Ізраїлевої, наблизив їх до його. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","І простягнув Ізраїль правицю і положив на голову Ефраїмову, — був же він молодший — а лївицю на голову Манассїєву; положив руки на вхрест, був бо Манассїй первенець. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","І благословив Йосифа, і каже: Бог, що перед ним ходили отцї мої, Авраам та Ізаак, Бог, що годував мене змалечку та й до сього дня, ");
INSERT INTO ukr1871_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ангел, що вирятував мене з усякого лиха, нехай благословить хлопята сї, і прозветься в них прізвище моє і прізвище отцїв моїх, Авраама та Ізаака, і нехай виростуть у множество многе на землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","І побачив Йосиф, що положив панотець його руку правицю свою на голову Ефраїмову, і не гаразд йому здалось воно, і прийняв Йосиф руку панотцеву, щоб з голови Ефраїмової перенести на голову Манассїєву. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","І каже Йосиф панотцеві свойму: Не тако, панотченьку! Сей бо первенець; положи руку твою правицю на голову йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","І не схотїв отець його, і каже: Знаю, синку. І він буде народом, і він буде великий; но брат його молодший більший над його буде, і насїннє його буде купою народів. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","І благословив їх того ж дня, і каже: Тобою благословляти ме Ізраїль говорючи: Зроби тебе Боже рівнею Ефраїмові й Манассїєві! І поставив Ефраїма перше Манассїя. ");
INSERT INTO ukr1871_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","І каже Ізраїль Йосифові: Се я вміраю; но Бог буде з вами, і верне вас ізнов у землю отцїв ваших. Я ж тобі над брати надїлив країну, що одняв я в Аморія моїм мечом і моїм луком. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","І прикликав Яков сини свої і каже: ");
INSERT INTO ukr1871_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ой синове Якова! Скуптеся докупи, та послухайте, що скаже вам отець Ізраїль. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ти, мій первенче, Рубене, сило моя перва! Ти й поважен, ти й потужен, всїх ти переважив, ");
INSERT INTO ukr1871_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Та филюєшся водою, задню пасти будеш; лїг бо на отецьке ложе, ложе ти зневажив, і зневажив і споганив батькову постелю! ");
INSERT INTO ukr1871_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Симеоне й ти Левію! Браттє ви між браттєм, та сестра знаряддє в зрадї кривдї стала. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Не ввійду я в вашу раду, поки й тху тихого, і до змови не пристану серцем чистим, чесним. Бо вони людей в завзяттї мучили, вбивали, в безумі свойму терзали навіть і скотину. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Проклинаю їх нелюдське дике їх завзяттє; їх в Ізраїлї розсїю, звергну у Якові. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Юда! Тебе возхвалить рідне браттє ревно, і вклонятись тобі будуть батька твого дїти. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Юда левчук голодний; ситим будеш, синку, і хижацтвом пійдеш в гору; левом опочинеш: Мов той лев заляжеш спати, страшен, як левиця; хто зосьмілиться збудити, сон його стрівожить? ");
INSERT INTO ukr1871_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","В Юди не похитнеться берло між колїньми, докіль мир постане в людях, чаяннє в народах. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","В виноградї він привяже знїжене ослятко, у найкращому, ослицї мазану дитину. У винї одежу виправ, платтє у червонім. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Од вина потуманїли ясні очі в його, од молока побілїли в його ситі зуби. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Зебулон седить над морем, судна знай вітає; його слуги пробувати будуть і в Сидонї. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Іссахар — осел костлявий між двома хлївами. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Бачить, що в землї родющій люба річ спочити; і на паньщинї гне спину під тягар, працює. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан свій люд судити буде, рід свій в Якові. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Дан лежати на дорозї гадиною буде. Вкусить він коня за ногу, скине й їздеця він; навпаки впаде злякавшись, у сїдлї не всидить. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","На твою вповаю поміч, Господе, мій Боже! ");
INSERT INTO ukr1871_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Гад — напре на його військо, він побє потужне. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ассер у життї роскішнім їсти ме хлїб з туком, ласощі царські усїм він вистачати буде. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Нафталїй гіллє розкине пишним дубом. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Йосиф же, се вітка добра з дерева, що родить над криницею, да й стеле яблука по муру. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Нацїлялись в його з лука, стрелили, та лук свій ");
INSERT INTO ukr1871_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Він удержав у потузї. Руцї не послабли. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Всемогущий благодатно, синку, тебе кропить з неба гарними дощами, із землї годує. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ті ж бо всї благословення, що дознав отець твій, взяли гору над горами, вічними холмами. Ой нехай же на голову всї Йосифові зійдуть і на тїмє осяйного князя між братами! ");
INSERT INTO ukr1871_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Бенямин, се в нас вовцюга, наситу не знає; вранцї — він жере поживу, в вечір — здобич дїлить. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Усе це дванайцятеро поколїнь Ізрайлевих, і се промовив до них отець і благословив їх кожного, по благословенню його благословив їх. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","І заповідав їм, і каже їм: Я пригорнусь до народу мого. Поховайте мене з отцями моїми в печері, що на полї Ефроновому Гетієвому, ");
INSERT INTO ukr1871_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","В печері, що на полї Макпелевому, що перед Мамрійщиною в Канаан землї, що купив Авраам у Ефрона Гетія у державу на гробовище. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Там поховано Авраама й Сарру, жону його; там поховано Ізаака й Ребеку, жену його, і там поховав я Лею. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Куплене поле й печера на йому в синів Гетових. ");
INSERT INTO ukr1871_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","І переставши Яков чинити заповіт синам своїм, простягнув нозї свої на постелї і розлучивсь із душею, та й пригорнувсь до народу свого. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","І впав Йосиф на лице панотцеві свойму, плакав по йому і цїлував його. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","І повелїв Йосиф слугам-лїкарям своїм бальзамувати панотця свого, і набальзамували лїкарі Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","І сповнилось йому сорок день, бо стілько день лїчять про тих, що набальзамовали, і плакавсь по йому Египет сїмдесять день. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Як же минули плакальні днї, каже Йосиф домові Фараоновому і промовив: Коли знайшов я ласку в вас ув очу, прошу вас, промовте в слух Фараонові слово таке: ");
INSERT INTO ukr1871_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Панотець мій закляв мене говорючи: Се я вміраю. У гробовищі мойму, що купив я в Канаан землї, там поховай мене. Так оце благаю тебе, пусти мене ійти, та поховати панотця мого, і вернусь. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","І каже Фараон: Іди й поховай отця твого по слову клятьби твоєї: ");
INSERT INTO ukr1871_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","І пійшов Йосиф ховати батька свого, і піднялись із ним усї дворяне Фараонові, дуки господи його й усї дуки землї Египецької, ");
INSERT INTO ukr1871_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","І ввесь дом Йосифів і його батька дом, тільки малеча їх, та вівцї їх, да товарина їх, позоставались у Госен землї. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","І пїднялись із ними й колесницї й комонник, була громада велика вельми. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","І прийшли аж до току Атадового, що по тім боцї Йорданї, і ридали там риданнєм великим і тяжким вельми. І зробив там голосїннє панотцеві свойму семиденне. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","І бачили осадники Канаанські, похорон коло току Атадового й мовляли: Гіркі сї поминки Египтянів! Тим і проложено врочищу тому прізвище Авель-Мизраїм, по тім боцї Йорданї. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","І вчинили йому так синове його, як він заповідав. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Бо взяли його синове його в землю Канаанську, та й поховали його в печері на Макпелевому полї, що купив Авраам з полем у державу на гробовище у Ефрона Гетя проти Мамрїйщини. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","І вернувсь Йосиф у Египет сам і браттє його і всї що піднялись із ним ховати батька його. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Бачивши ж браттє Йосифове, що помер отець їх, мовляли: Може, зненавидить нас Йосиф, і віддячить нам за все зло, що заподїяли йому. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","І послали посли до Йосифа говорючи: Панотець заповідав перед смертю своєю так: ");
INSERT INTO ukr1871_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Ось як промовте до Йосифа: Прости братам твоїм переступ їх і гріх їх, що вони тобі заподїяли зло. Благаємо ж тебе, прости переступ рабам Бога батька твого. І плакавсь Йосиф, як промовляли вони до його. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","І прийшли до його самі брати його, і впавши перед його лицем, промовляли: Се — ми раби в тебе. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","І каже до них Йосиф: Не лякайтесь; хиба я замість Бога? ");
INSERT INTO ukr1871_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Хоч ви змовлялись проти мене, та Бог те обернув на добре, щоб так було, як тепер, і вирятувалось много людей у голоднечу. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Тим же то не лякайтесь тепер. Я годувати му й вас і малечу вашу. І втїшив їх і промовляв до них прихильно. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","І пробував Йосиф в Египтї сам і батька його дїти. І пожив Йосиф сто і десять років. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","І вбачав Йосиф Ефраїмові дїти до третього роду; сини ж Махирова, сина Манассїєвого, роджались на колїна Йосифові. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","І каже Йосиф браттю свойму говорючи: Я вміраю, Бог же навідається до вас і виведе вас із землї сієї в землю, що про неї клявся отцям нашим Авраамові, Ізаакові й Яковові. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","І закляв Йосиф сини Ізраїлеві, говорючи: Бог певно навідається до вас, а ви винесїть і костї мої звідсї з вами. ");
INSERT INTO ukr1871_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","І скіньчивсь Йосиф бувши лїт ста і десяти, і набальзамували вони його, та й положили його в трумну в Египтї.");
INSERT INTO ukr1871_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Се ймена в синів Ізраїлевих, що поприходили в Египет вкупі з Яковом. Кожен з усїм домом своїм прийшов. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Рубен, Симеон, Левій, Юда, ");
INSERT INTO ukr1871_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Іссахар, Зебулон та Бенямин, ");
INSERT INTO ukr1871_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Дан та Нефталїй, Гад та Ассер. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Було ж усїх душ, що повиходили з чересел Яковових, сїмдесять душ. Йосиф же був в Египтї. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","І вмер Йосиф, і всї брати його, і весь той рід. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ізрайлитяне ж та були плодющі, і розростались і намножувались, і впотужнювались переважливо, і сповнилась ними земля. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Устав же царь новий над Египтом, що не знав Йосифа. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","І каже народові свойму: Та се ж нарід Ізраїльський більший і потужнїщий над нас. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Нумо перехитрувати їх, ато намножаться і як випаде нам війна, так пристануть і вони до ворогів і бити муть на нас, та й вийдуть із нашої землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","І поставлено над ними приставникїв в роботї, щоб їх мучили паньщиною своєю; і збудували вони харчові городи Фараонові: Питом і Раємзес. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Но що більш мучили їх, то все більш намножувались вони і вбивались у силу. І стало потїсно Египтянам од Ізрайлитян. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","І приневолювали Египтяне Ізрайлитян аж надто до роботи. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","І гірко було їм жити в тяжкій неволї, на глинищах та цегельнях, та й у всякій польовій роботї, що приганяли їх до неї під пригоном. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","І каже царь Египецький бабам сповитухам Єврейським, одна була на імя Сифра, друга на імя Пуя, ");
INSERT INTO ukr1871_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","І каже: Як бабувати мете в Єврейських жінок, дак придивляйтесь: коли син, убивайте, а дочка, нехай жиє. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Та побоялись баби сповитухи Бога, і не чинили так, як повелїв їм царь Египецький, а лишали при життю хлопяток. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","І прикликав царь Египецький баби сповитухи, та й каже їм: Про що ви таке чините й лишаєте живих хлопяток? ");
INSERT INTO ukr1871_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","І кажуть баби сповитухи Фараонові: Бо Єврейки не такі, як Египтянки: молодицї вони моторні; нїм прийде баба, вони родять. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","І допомагав Бог бабам сповитухам, і намножувались люде й употужнювались велико. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","А за те, що боялись баби сповитухи Бога, погоджував їм Бог у домівках. ");
INSERT INTO ukr1871_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","І повелїв Фараон усьому народові свойму словами: Усякого сина, що народиться в Євреїв, кидайте в ріку, а всяку дочку доглядайте. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","І був чоловік із дому Левієвого, і взяв собі жінку Левіївну. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","І завагонїла й уродила сина; бачивши ж, яке воно гарне, таїлась із ним три місяцї. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","А як не в моготу було вже таїтись, зробила йому скринечку з рогожини, та обмазала її мазюкою, осмолила смолою, та й поставила між осет уз беріг ріки. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","І наглядала сестра віддалеки, щоб знати, що станеться йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","І спустилась дочка Фараонова купатись у ріцї, а її рабинї приходили уз ріку берегом. І вгледївши скриньку проміж осетом, послала рабиню й узяла її. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Відтуливши ж, бачить немовляточко в скриньцї, плачуще хлопятко. І змилосердилась дочка Фараонова, і каже: Се з Єврейняток. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Каже тодї сестра хлопчикова дочцї Фараоновій: Побіжу я, покличу тобі мамку з Єврейок, щоб згодувала тобі хлопятко! ");
INSERT INTO ukr1871_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","І каже їй дочка Фараонова: Біжи! І побігла дївчинка і кликнула хлопчикову матїр. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","І каже їй дочка Фараонова: Возьми немовлятко, та згодуй менї його; я ж дам тобі плату. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","І знялось на ноги хлопятко, і привела його до дочки Фараонової, і був у її за сина. І дала йому імя Мойсей; бо, каже, з води взяла його. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","І стало з того часу, як Мойсей був уже дорослий, що вийшов до браття свого, та й дививсь на їх тягарі, та й побачив, як Египтянин бє Єврея зміж братів його. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Озирнувшися ж сюди й туди, і не вбачаючи нїкого, убив Египтянина та й сховав його в піску. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","І вийшов другого дня, аж се двоє Євреїв бються; він і каже тому, хто скривдив: Про що нївечиш товариша? ");
INSERT INTO ukr1871_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Він же каже: Хто тебе настановив старшим і суддею над нами? Хиба задумав убити й мене тим робом, як убив Египтянина. І злякався Мойсей і каже сам собі: Чи не виявилась лишень справа? ");
INSERT INTO ukr1871_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","І дознався Фараон про сю справу, та й шукав приключки, щоб убити Мойсея. І втїк Мойсей од Фараона, та й оселивсь у Мидиян землї. От і седить раз біля колодязя. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","А в сьвященника Мидиянського та було семеро дочок. І поприходили вони та й черпали воду, та й сповняли пійла, щоб понаповати вівцї батькові. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Та посходились пастухи, та й попроганяли їх. І встав Мойсей та й допоміг їм, і понаповав їх вівцї. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","І прийшли вони до Регуїля, батька свого, він і каже дочкам своїм: Чого се прийшли ви так заранї сьогоднї? ");
INSERT INTO ukr1871_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","І кажуть вони: Якийся Египтянин визволив нас од пастухів, та ще начерпав доволї й води нам, і понаповав вівцї. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","І каже він дочкам своїм: А де ж він? Про що се ви покинули чоловіка? Кликнїте лишень його, щоб у нас попоїв хлїба солї. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","І вподобав Мойсей оселї у чоловіка сього, і він оддав Зипору, дочку свою Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","І вродила вона сина, і дав йому він імя Герсон, бо каже: Захожим я в чужій землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","І сталось у довгому протязї часу, що вмер царь Египецький. І застогнали Ізрайлитяне на паньщинї, і знялось голосїннє їх до Бога про паньщину. ");
INSERT INTO ukr1871_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","І почув Бог голосїннє, і спогадав Бог заповіт з Авраамом та з Ізааком та з Яковом, ");
INSERT INTO ukr1871_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","І зглянувсь Бог на Ізрайлитян, і дознавсь про се Бог. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Мойсей же пас вівцї в Єтра, тестя свого, сьвященника Мидиянського, та й погнавсь з вівцями за степ, і прийшов до Божої Гореб гори. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","І явивсь йому ангел Господень ув огнистому поломї ізсеред куща тернового. Побачив, що кущ горить огнем, горить і не згоряє. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","І каже сам собі Мойсей: Зайду лишень збоку та подивлюсь на сю велику появу, чом не згорить купина. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","І побачив Господь, що зайшов збоку дивитись, і кликне його зсеред колючого куща і рече: Мойсею, Мойсею! ");
INSERT INTO ukr1871_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","І каже він: Ось я! І рече: Не наближуйся сюди; іззуй обувє твоє з ніг твоїх, місце бо, що на йому стоїш, земля сьвята. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","І рече йому: Я Бог отця твого, Бог Авраамів, Бог Ізааків і Бог Яковів. І затулив Мойсей вид собі; не важився бо дивитись на Бога. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","І рече Господь: Бачив я бідуваннє людей моїх, що в Египтї, і почув голосїннє їх із причини приставників; знаю бо печаль їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","І зійшов я рятувати їх із потали Египецької та вивести їх із землї тієї, та ввести їх у землю добру й простору, в землю текучу молоком і медом, в займище Канаанське та Гетіївське, та Аморіївське та Ферезіївське та Євузіївське. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","І се голосїння синів Ізрайлевих дійшло до мене, та й бачив я тїсноту, що нею тїсьнять їх Египтяне. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ійди ж оце, пошлю тебе до Фараона, щоб ти вивів нарід мій, сини Ізрайлеві, з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","І каже Мойсей до Бога: Хто я такий, щоб менї та йти до Фараона, і щоб менї та вивести сини Ізрайлеві з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Рече ж Бог до Мойсея: Та ж я буду з тобою, і се тобі знамення, що сам я тебе послав. Як виведеш люде мої з Египту, помолитесь ви Богу під горою сією. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","І каже Мойсей до Бога: Ну, прийду оце до синів Ізрайлевих і промовлю до них: Бог батьків наших прислав мене до вас, а вони скажуть менї: Яке ж імя йому? Що казати му їм? ");
INSERT INTO ukr1871_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","І промовив Бог до Мойсея: Я той, хто єсть. І рече він: Так промовиш до синів Ізрайлевих: Сущий послав мене до вас. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","І каже Бог знов до Мойсея: Так промовиш до синів Ізрайлевих: Господь Бог отець ваших, Бог Авраамів, Бог Ізааків і Бог Яковів послав мене до вас. Се імя моє на віки, і се моя память від роду та й до роду. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ійди та поскуплюй до купи старші мужі громадські в синів Ізрайлевих і промов до них: Господь Бог Авраамів, Ізааків і Яковів явився менї глаголючи: Навідом навідавсь я до вас, що приключилось вам в Египтї, ");
INSERT INTO ukr1871_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","І рече: Виведу вас із бідування Египецького в землю Канааніїв і Гетіїв і Аморіїв і Ферезіїв і Гевіїв і Євузіїв, в землю текущу молоком і медом. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","І послухають голосу твого, і ввійдеш ти й старші громадські мужі Ізрайлеві до царя Египецького, та й промовиш до його: Господь, Бог Єврейський, зустьрів нас, і тепер дозволь нам пійти на три днї ходи в степ, принести жертву Господеві Богу нашому. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Я ж відаю, що не дозволить вам ійти царь Египецький, нї! Хиба тільки через потужну руку. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","І простягну руку мою, і вдарю на Египет усїма чудесами моїми, що сотворю між ними, а потім відпустить вас. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","І дам ласку людям сим в очу в Египтянів, і станеться, що, як вийдете, пійдете не в порожнї. ");
INSERT INTO ukr1871_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Нї! нехай усяка молодиця пожичить у сусїдки своєї і в такої, що пробуває в господї в неї, клейноти срібні і клейноти золоті і шати, та й понадїваєте на сини ваші й дочки ваші, і пограбуєте Египтянів. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","І відказав Мойсей і каже: А як же не звіряться менї, анї послухають голосу мого, та скажуть: Не являвсь тобі Господь? ");
INSERT INTO ukr1871_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","І промовив до його Господь: Що се в руцї у тебе? І каже він: Палиця. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","І глаголе: Кинь її на землю. І кинув її на землю, і стала змієм. І відбіг Мойсей від його. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","І каже Господь Мойсейові: Простягни руку, та возьми за хвоста. І просьтяг руку і узяв його за хвоста. І стала палиця в руцї в його: ");
INSERT INTO ukr1871_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Щоб упевнились, що явивсь тобі Господь, Бог батьків їх, Бог Авраамів, Бог Ізааків і Бог Яковів. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Каже йому Господь знов: Засунь руку твою за пазуху собі. І засунув руку за пазуху собі, і як вийняв її зза пазухи своєї, аж се рука його побілїла від прокази, як сьнїг. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","І каже знов йому: Засунь руку твою за пазуху собі. І засунув він знов руку за пазуху свою; і вийняв її зза пазухи своєї, і се стала вона як тїло його. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","І станеться коли не піймуть віри тобі, анї послухаються знамення первого, так піймуть віри тобі й послухаються знамення другого. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","І станеться, коли не впевняться й сими двома знаменнями, і не послухають голосу твого, так візьмеш води річної, та й виллєш на суходіл, і вода, що взяв єси з ріки, візьметься кровю на суходолї. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","І каже Мойсей Господеві: Ой Господе! Не проречистий я нї здавна, нї з того часу, як почав єси глаголати рабові твойму. Нї! покволий у мові й тугоязикий. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","І каже Господь Мойсейові: Хто дав уста чоловікові? Або хто сотворив нїмого, чи глухого, чи видющого, чи слїпуючого? Хиба не я, Господь? ");
INSERT INTO ukr1871_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Оце ж ійди, і я буду в устах твоїх, і навчати му тебе, що тобі промовляти. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","І рече Мойсей: Молю тебе, Господи, вибери луччого посла. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","І запалав гнїв Господень на Мойсея, і рече: Хиба не знаю, що твій брат Арон, Левієнко, уміє добре промовляти? І се він вийде на зустріч тобі і, побачивши тебе, звеселиться в серцї свойму. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","І промовляти меш до його, вкладувати меш слова мої в уста його, я ж буду в устах у тебе і в устах у його, і навчати му вас, що вам чинити. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","І він буде речником твоїм до людей, і він тобі буде устами, ти ж йому будеш Богом. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","І сю палицю візьмеш у руку твою, нею сотвориш знамення. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","І пійшов Мойсей, та й вернувсь до Єтра, тесьтя свого, і каже: Пійду й вернусь до браття мого, що в Египтї, та побачу, чи вони ще живі. І каже Єтро Мойсейові: Ійди собі здоровий з миром. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","І рече Господь Мойсейові в Мидіян землї: Ійди, вертайсь у Египет; повмірали бо всї, що шукали душі твоєї. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","І взяв Мойсей жену свою та хлопята свої, посадив їх на осла, та й вернувсь у Египет. І взяв Мойсей жезло Боже в руку свою. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","І рече Господь Мойсейові: Як прийдеш в Египет, гляди, усї ті чудеса, що вложив я в руку твою, щоб ти сотворив перед Фараоном. Я ж закаменю серце йому, і не відпустить людей. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ти ж промовляти меш до Фараона: Тако глаголе Господь: Мій син, мій первенець Ізраїль. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","І глаголю тобі: Відпусти сина мого, щоб він служив менї. Як же не схочеш відпустити, знай, я вбю сина твого, первенця твого. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","І сталось у дорозї, на попасї, що стьрів Господь його та й хотїв убити. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","І взяла Зипора гострого кременя, та й обрізала крайнє тїлце в синка свого, та й кинула до ніг йому, і каже: Крівавий жених ти менї. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","І відійшов геть від його. Казала тодї вона: Крівавий жених задля обрізання. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","І рече Господь Аронові: Вийди в степ на зустьріч Мойсейові. І пійшов і зустьрів його під горою Божою, та й поцїлував його. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","І повідав Мойсей Аронові всї слова Господнї, що послав його, й усї знамення, що заповідав йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","І пійшов Мойсей з Ароном і поскуплювали до купи всїх старших мужів громадських Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","І промовив Арон усї слова, що глаголав Бог до Мойсея, і сотворив знамення перед людьми. ");
INSERT INTO ukr1871_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","І вірували люде, і чувши, що Господь навідавсь до синів Ізрайлевих, і що зглянувсь на їх бідуваннє, похилились і поклонились до землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Після сього ввійшов Мойсей із Ароном до Фараона та й промовили йому: Так рече Господь, Бог Ізраїлїв: Відпусти люде мої, щоб сотворили сьвято менї в степу. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","І каже Фараон: Хто сей Господь, щоб я послухав голосу його, та відпустив сини Ізрайлеві. Не знаю Господа і не відпущу Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","І кажуть йому: Бог Єврейський зустьрів нас; так дозволь нам пійти за три днї ходи в степ і принести жертву Господеві, Богу нашому, щоб не вдарив на нас мором або мечем. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","І каже їм царь Египецький: Про що ти, Мойсею, й ти, Ароне, одвертаєте людей моїх од їх дїла? Ійдїте кожен до роботи своєї. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","І каже Фараон: Се намножилось тепер народу в цїй землї, а ви хочете відтягати його від роботи. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","І дав Фараон того дня наказ посїпакам та приставникам такими словами: ");
INSERT INTO ukr1871_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Не давайте вже людям соломи на цеглу, як досї: нехай самі ходять і збирають собі солому. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Стілько ж цегол, як перше вироблювали, вимагайте від них; не поменьшуйте, бо вони лїниві; тим і кричать: Одпусти нас принести жертву Богу нашому! ");
INSERT INTO ukr1871_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Нехай вагонить робота на сих людях важче, щоб вони пильнували, та не вважали на марні слова. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","І повиходили приставники людські та доглядачі, та й промовляли до людей: Ось як повелїв Фараон: Не давати вже вам соломи; ");
INSERT INTO ukr1871_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ходити мете самі збирати собі солому, де знайдете; однакже не буде вбавлено з роботи вашої нїже. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","І порозходились люде по всїй землї Египецькій збирати собі стерню замість соломи. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Приставники же принагляли їх і приказували: Вироблюйте роботу вашу кожного дня, як бувало даємо солому вам. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","І бито доглядачів із Ізраїлїв, що були поставленї над ними від приставників Фараонових, мовляючи: Чом не виробили стілько цегол вчора й сьогоднї, як перше? ");
INSERT INTO ukr1871_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","І приходили доглядачі з Ізраїлїв до Фараона, та й лебедїли плачучи: Про що знущаєшся так із рабів твоїх? ");
INSERT INTO ukr1871_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Не дають соломи рабам твоїм, а цеглу, кажуть, вистачайте нам цегли! І се раби твої мучені, а нарід твій вина тому. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Він же каже: Ви лїниві лежибоки! Тим і верзете: Ходїмо принести жертву Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ідїте ж та працюйте! Соломи не давати муть вам, а цеглу, скілько вимагають, вистачайте. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","І вбачали свою лиху годину доглядачі з Ізраїлїв, яким наказано: Не поменьшуйте виробу цегли, що дня призначеного. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","І зоткнулись вони з Мойсейом та з Ароном, як виходили вони саме од Фараона. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","І промовили до них: Нехай спогляне Господь на вас і судить; бо зробили ви смердючим дух наш перед Фараоном і перед його дворянами. Дали ви меча їм у руки повбивати нас. ");
INSERT INTO ukr1871_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","І вернувся Мойсей до Господа, і каже: Господи Боже мій! Про що напустив єси такий напуст на сих людей? І про що се послав єси мене? ");
INSERT INTO ukr1871_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","З того бо часу, як увійшов я промовляти твоїм імям, він почав заподїювати зло людям сим; визволити ж із неволї людей сих не визволив єси. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","І рече Господь Мойсейові: Се побачите, що сотворю Фараонові: кріпка бо рука змусить його відпустити їх і правиця висока повиганяти їх із землї своєї. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","І говорив Бог до Мойсея і рече йому: я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","І являвсь я Авраамові й Ізаакові і Яковові як Бог їх всемогущий, з імям же моїм Єгова я не обявивсь їм. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","І я ж поставив завіт мій із ними, що оддам їм Канаан землю, де пробували вони чуженицями. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","І почув я теж стогнаннє синів Ізрайлевих, що їх Египтяне держали в неволї, і спогадав завіт мій. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Тим же то йди, промов до синів Ізрайлевих: Я Господь-Єгова, і виведу вас із неволї Египецької, і вирятую вас ізпід паньщини рукою простягнутою і присудами великими. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","І прийму вас за нарід собі, і буду вам Богом, і зрозумієте, що я Господь, ваш Бог, що вас вивів із неволї Египецької. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","І введу вас у землю, що про неї клявсь оддати її Авраамові й Ізаакові й Яковові, і дам вам її в наслїддє. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","І промовляв так Мойсей синам Ізрайлевим, та не послухали Мойсея від легкодухостї й тяжкої неволї. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Увійди й кажи Фараонові, цареві Египецькому, щоб одпустив сини Ізрайлеві із землї своєї. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","І промовив Мойсей перед Господом і каже: Се не послухали мене сини Ізрайлеві; як же Фараон послухає мене? Та ж мої губи не обрізані, я не проречистий. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","І глаголав Господь Мойсейові та Аронові, і повелїв їм промовляти до синів Ізрайлевих і до Фараона, царя Египецького, щоб вивести Ізраїлїв з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Се голови батьківських домів їх: Сини Рубена, первеньця Ізрайлевого: Ганох та Паллуй, Гезрон та Хармій; се Рубенові сини. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Сини ж Симеонові: Ємуель та Ямін та Огад та Якін та Зохар, та Савул, син Канаанки: се семї Симеонові. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","А се ймена в синів Левієвих по родам їх: Герзон та Кегат та Мерарій; а років життя Левієвого було сто і трийцять і сїм лїт. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Сини ж Герзонові: Лібнїй та Симей з семями їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Сини ж Кегатові: Амрам та Їзгар, та Геброн та Узієль; віку ж Кегатового було сто і трийцять і три годи. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Сини ж Мерарієві: Махлїй та Мусїй; се семї Левієві по родах їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","І взяв Амрам Йохабеду, дочку брата батька свого, собі за жінку, и вродила йому Арона та Мойсея; віку ж Амрамового було сто і трийцять і сїм років. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Сини ж Їзгарові: Кораг та Нефег та Зихрій. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Сини ж Узієлові: Мішаель та Елзафан та Ситрій. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","І взяв Арон Елїсебу, дочку Аминадабову, сестру Нахсонову, собі за жінку; і вродила йому Надаба та Абігея, Елеазара та Ітамара. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Сини ж Корагові: Асир та Єлькана та Абиясаф; се семї Корагові. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Елеазар же Ароненко узяв собі одну з дочок Путієлових, і вродила йому Пинегаса. Се голови синів Левіїв по родах їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Се той Арон та Мойсей, що їм рече Бог: Виведїть менї сини Ізрайлеві з Египту по полках їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Се ті, що промовляли до Фараона, Египецького царя, щоб вивести сини Ізрайлеві з Египецької землї: се Мойсей та Арон. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","І сталось того дня, як Господь глаголав до Мойсея в Египецькій землї, ");
INSERT INTO ukr1871_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Що рече Господь Мойсейові: Я Господь. Промов до Фараона, Египецького царя, все, що я глаголав до тебе. ");
INSERT INTO ukr1871_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","І каже Мойсей перед Господом: Ось в мене губи не обрізані, як же Фараонові та послухати мене? ");
INSERT INTO ukr1871_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","І сказав Господь до Мойсея: Се дав я тебе замість Бога Фараонові, Арон же, твій брат, буде твоїм пророком. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ти промовляти меш усе йому, що тобі заповідую, Арон же, твій брат, промовляти ме до Фараона, щоб одпустив сини Ізрайлеві з землї своєї. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Я ж ізроблю запеклим серце Фараонове, і намножу знамення мої і дива мої в Египецькій землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","І не послухає вас Фараон, і наложу я руку мою на Египет, і виведу силою моєю полки мої, люде мої, сини Ізрайлеві з Египецької землї з судом великим. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","І відати муть Египтяне, що я Господь, як просьтягну руку мою на Египет і виведу сини Ізрайлеві спроміж їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","І сотворили Мойсей та Арон, як заповідав їм Господь; як заповідав, так і сотворили. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Мойсейові було вісїмдесять год віку, Аронові сїмдесять і три годи, як промовляли до Фараона. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","І рече Господь Мойсейові та Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Як скаже вам Фараон: Покажіте лишень за себе диво, промов тодї Аронові: Возьми жезло та й кинь перед Фараоном, так обернеться воно в гадюку. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","І прийшли Мойсей та Арон перед Фараона, і вчинили так, як заповідав Господь. І кинув Арон жезло перед Фараоном і перед його дворянами, і стало воно гадюкою. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Скликав же тодї й Фараон мудрецї Египецькі та чарівники; і вдїяли те ж саме чарівники своїми чарами. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","І кинув кожен ізміж їх своє жезло, і стали жезла гадюками; та пожерло жезло Аронове їх жезла. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","І зробив Господь серце Фараонове запеклим, і не послухав їх, як і казав їм Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","І рече Господь Мойсейові: Закаменїло серце Фараонове; не схотїв одпустити людей. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ійди до Фараона завтра вранцї. Се виходить він саме на води, і станеш на річному березї, навпроти входу його, і жезло, що сталось гадюкою, держи в руцї твоїй. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","І промовиш до його: Господь, Бог Єврейський, послав мене до тебе глаголючи: Відпусти люде мої, щоб менї послужили в степу! Та ось ти не послухав його і досї. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","От же що глаголе Господь: От з чого буде тобі розумно, що я Господь: Ось, вдарю жезлом, що в руцї в мене, по водї річаній, і візьметься кровю. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","І риба, що в ріцї, погине, і засмердиться ріка, і гидуватимуть Египтяне пити воду з ріки. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","І рече Господь Мойсейові: Промов Аронові: Возьми жезло твоє, і просьтягни руку твою на води Египецькі, на всї ріки їх, на канави їх і на стави їх і на всї водосплави їх, щоб узялися кровю; і буде кров по всїй землї Египецькій, і в усїх деревяних і камяних посудинах. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","І вчинили так Мойсей та Арон, як заповідав їм Господь; і взявши Арон жезло в руку свою, ударив по водї річаній перед Фараоном і перед його дворянами, і взялась уся вода річана кровю. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","І риба в ріцї вигинула, і засмердїлась ріка, і не змогли Египтяне пити води з ріки, і була кров по всїй землї Египецькій. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Зробили ж так і чарівники Египецькі своїми чарами. Та закаменїло серце Фараонове, і не послухав їх, як і глаголав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","І вернувсь Фараон, і ввійшов у палати свої, та й не покладав бай сього в умї. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","І копали всї Египтяне понад рікою копанки на воду; бо не змогли пити води з ріки. ");
INSERT INTO ukr1871_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","І сповнилося сїм день після того, як ударив Господь по ріцї. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","І рече Господь Мойсейові: Ійди до Фараона, та промов до його: Тако глаголе Господь: Одпусти люде мої послужити менї! ");
INSERT INTO ukr1871_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Коли ж затнешся відпустити, се я побиваю всї твої займища жабячою карою. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","І розплодить ріка жаби, і повилазять вони на береги, поналазять у палати твої, і в опочивальню твою, і на постелю твою, і в будинки дворян твоїх, і на люде твої, і в печі твої, і в дїжі твої. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","І на тебе самого, й на підневолених твоїх, й на дворян твоїх лїзти муть жаби. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","І рече Господь Мойсейові: Промов Аронові: Простягни руку твою з жезлом твоїм на ріки, на канави й на стави, і наведи жаби на Египецьку землю. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","І простяг Арон руку свою на води Египецькі, та й понаводив жаб, і порозлазились жаби і вкрили землю Египецьку. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Зробили ж і чарівники чаруваннєм своїм так само, і понаводили жаб на Египецьку землю. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","І прикликав Фараон Мойсея та Арона, та й промовив: Ублагайте Господа, щоб менї попрогоняти від себе жаби й від людей моїх, так відпущу люде принести жертву Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","І каже Мойсей до Фараона: Призначи менї, на коли менї молити за тебе і дворян твоїх і за люде твої, щоб зникли жаби від тебе і по будинках твоїх, щоб тільки в ріцї зостались. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","І каже той: Завтра. І каже: Буде по слову твойму, щоб ти знав, що нема иншого, опріч Господа Бога нашого. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","І позникають жаби від тебе й від будинків твоїх, і від дворян твоїх, і від народу твого, тільки в ріцї зістануться. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","І вийшов Мойсей та Арон од Фараона, і покликнув Мойсей до Господа про жаб, що понаводив на Фараона. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","І сотворив Господь по слову Мойсейовому, і повиздихали жаби по їх домах, по селах і по полях. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","І згребали їх купами й купами, і засмердїлась земля. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","І побачив Фараон, що є пільга, і закаменїло серце його, і не послухав їх, як і глаголав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","І рече Господь Мойсейові: Промов Аронові: Простягни жезло твоє, та вдар у порох землї, і зробиться він комарами по всїй Египецькій землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","І вчинили так, і простяг Арон руку свою з жезлом своїм і вдарив у порох землї, і напали комарі на людей і на скотину; увесь порох земляний узявся комарами по всїй Египецькій землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Силкувались і чарівники вивести комарі чарами своїми, та й не змогли. І насїли комарі на людей і на скотину. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","І промовили тодї чарівники: Се Божий палець! І закаменїло серце Фараонове, і не послухав їх, як і глаголав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","І рече Господь Мойсейові: Устань рано в раньцї, і стань перед Фараоном, саме вийде на воду, і промовиш йому: От що глаголе Господь: Одпусти люде мої послужити менї в степу. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Коли ж затнешся відпустити люде мої, се я посилаю на тебе, і на дворян твоїх, і на людей твоїх, і на домівки ваші песячі мухи, і сповняться доми Египецькі песячими мухами, і сама земля, що на їй живете. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","І відріжню того дня Гозен землю, що на їй осїлись люде мої тим, що не буде там песячих мух, щоб зрозумів ти, що я Господь серед землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","І положу розлуку між моїми людьми й твоїми людьми. Завтра ж буде знаменнє се. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","І сотворив так Господь. І полетїли страшенні рої песячих мух у палати Фараонові, і в будинки дворян його, і в усю Египецьку землю, і попсувалась уся земля від песячих мух. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","І покликав Фараон Мойсея та Арона та й промовив: Ідїте принесїте жертву Господу, Богу вашому, в землї сїй. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","І каже Мойсей: Не подоба сьому так статись, гидко бо Египтянам, коли б ми ту принесли жертву Господеві, Богу нашому. Нї! Коли б ми приносили жертву гидку Египтянам перед очима в їх, вони побили б нас каміннєм. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","А пійдемо в степ за три днї ходи, та й принесемо жертву Господеві, Богу нашому, як повелїв нам він. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","І промовив Фараон: Одпущу вас принести жертву Господеві, Богу вашому, в степу, тільки не далеко простуйте! Помолїтесь і за мене! ");
INSERT INTO ukr1871_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","І каже Мойсей: Се йду від тебе, й благати му Господа, щоб зникли песячі мухи від тебе, і від дворян твоїх, і від людей твоїх завтра. Та не ходи вже, Фараоне, робом омани, не відпускаючи людей принести жертву Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","І вийшов Мойсей од Фараона, та й помолився Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","І сотворив Господь по слову Мойсейовому, і відогнав песячі мухи від Фараона, і від дворян його, і від людей його, і не зосталось нї однієї. ");
INSERT INTO ukr1871_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Та запекле було серце в Фараона ще і того часу, і не схотів одпустити людей. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","І рече Господь Мойсейові: Увійди до Фараона, та промов до його: Тако глаголе Господь, Бог Єврейський: Відпусти люде мої послужити менї. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Коли ж не схочеш одпустити людей моїх, і все таки вдержувати меш їх, ");
INSERT INTO ukr1871_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Се рука Господня вдарить на твою скотину в полях, на конї, на осли, на верблюди, на воли і на вівцї повітрєм тяжким вельми. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","І сотворю я инше того часу між скотом Ізраїльським і скотом Египецьким, і не паде з усього скоту Ізраїльського нї одно. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","І призначив Господь речінець, глаголючи: Завтра вчинить Господь сю річ в країні. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","І вчинив Господь сю річ назавтра в раньцї, і полїг увесь Египецький скот; між скотом же в синів Ізрайлевих не пало нї одно. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","І послав Фараон, аж ось між усїм скотом у синів Ізрайлевих не пало нї одно. Та запекле було серце в Фараона, і не одпустив людей. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","І рече Господь Мойсейові й Аронові: Понабирайте ви повні жменї сажі з печі, і нехай нею сипне проти неба Мойсей перед віччу Фараона й дворян його. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","І постане вона по всїй землї Египецькій порохом і понариває на людях і на скотинї чираки, що від гною прорвуться по всїй землї Египецькій. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","І набравши сажі з печі стали перед Фараоном, і сипнув нею Мойсей проти неба; і понаривало чиряки струпи на людинї й на скотинї. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","І не здолїли чарівники стати перед Мойсейом через чиряки; обкинуло бо чиряками чарівників і всїх Египтян. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Та закаменив Господь серце в Фараона, і не послухав їх, як і глаголав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","І рече Господь Мойсейові: Устань рано в раньцї, та й стань перед Фараоном і промов до його: Так каже Господь, Бог Єврейський: Відпусти люде мої послужити менї. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Сего бо разу нашлю всї муки мої на серце твоє, і дворян твоїх, і людей твоїх, щоб ти знав, що нема нїкого як я на всїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Нинї бо простягти б тільки руку мою, щоб ударити й тебе й люде твої повітрєм, так і зник би єси з землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Та тільки про те щадив тебе, щоб на тобі показати потугу мою, і щоб імя моє проповідано по всїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Чи ще ж нести мешся високо проти людей моїх, що не відпустиш їх? ");
INSERT INTO ukr1871_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Се дощувати му сієї доби завтра страшенним грядом, що такого не було в Египтї з того дня, як сотворено його, та й по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Оце ж посилай, та позбирай увесь твій скот і все, що в тебе в полї. На всяку бо скотину й людину, що знайдеться в полї і не вернуться додому, вдарить гряд, і погинуть. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Хто злякався слова Господнього зміж дворян Фараонових, той звелїв своїм рабам втїкати з усїєю скотиною до домівок своїх. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","А хто не нахилив серця свого до слова Господнього, той покинув свої раби й скотину на полях. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","І рече Господь Мойсейові: Простягни руку твою до неба і вдарить гряд по всїй землї Египецькій і на людину, і на скотину, і на всяку траву на землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","І простяг Мойсей жезло своє до неба, і дав Господь громи та гряд, і пійшов огонь по землї, і дощував Господь грядом по всїй землї Египецькій. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","І вдарив гряд, і запалав огонь із грядом; гряд же був тяжко великий, що й не було такого в Египтї з того часу, як постали люде в йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","І побило грядом по всїй землї Египецькій усе, що було в полї, й людину й скотину, й всяку траву в полї побило грядом, і всї дерева на полях потрощив гряд. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Тільки в Гозен землї, де були сини Ізрайлеві, не було гряду. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","І послав Фараон по Мойсея та по Арона, та й промовив до них: Провинив тепер я. Господь праведен, я ж і люде мої ледачі. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ублагайте Господа, щоб не було страшенного гуркотання та гряду; я ж відпущу вас, і більше не гаяти метесь тутеньки. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","І каже йому Мойсей: Скоро вийду з городу, здійму руки мої до Господа, і громи втихнуть, і гряду з дощем не буде вже, щоб зрозумів єси, що земля Господня. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ти ж і дворяне твої, знаю, що не вбоялись іще Господа. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","А лен і ячмінь побиті, бо ячмінь колосився, а лен завязувався. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Пшениця ж і жито не побиті; бо ще не дорослї. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","І вийшов Мойсей із городу і простяг руки свої до Господа; і перестали громи і гряд, і дощ вже не лив на землю. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Як же побачив Фараон, що перестав дощ і гряд і громи, став согрішати ще, та й закаменив запекле серце своє він і дворяне його. ");
INSERT INTO ukr1871_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","І закаменїло запекле серце Фараонове, і не одпустив синів Ізрайлевих, як і глаголав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","І рече Господь Мойсейові: Увійди до Фараона; я ж бо закаменив запекле серце його і серце в дворян його, щоб менї показати сї знамення на них. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","І щоб тобі можна було повідати в уші синові твойму, як я насьміявсь з Египту, і які знамення сотворив я над ним, щоб ви взнали, що я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","І прийшов Мойсей та Арон до Фараона та й промовили йому: Так каже Господь, Бог Єврейський: Докіль ще ставити меш опір, не хотячи впокоритись передо мною? Відпусти люде мої послужити менї. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Коли ж не схочеш одпустити люде мої, се я наведу завтра сарану на займища твої. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","І вкриє лице землї, що й землї буде не знати, і поїсть увесь останок, що зістався вам од гряду, і жерти ме всяке дерево, що виростає вам у полї; ");
INSERT INTO ukr1871_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","І сповняться будинки твої, й будинки всїх дворян твоїх, й усї оселї Египецькі, що нїколи не бачили сього батьки твої, нї батьки батьків твоїх з того часу, як постали на сїй землї та й по сей день. І повернувся Мойсей та й вийшов од Фараона. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","І промовили слуги Фараонові до його: Докіль буде сей чоловік западнею нам? Відпусти людей послужити Господеві, Богу свойму. Хиба не знаєш і досї, що погублено Египет? ");
INSERT INTO ukr1871_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","І вернули Мойсея та Арона перед Фараона, і каже їм: Ідїте послужіте Господеві, Богу вашому! Хто ж усї ті, що хочуть вийти? ");
INSERT INTO ukr1871_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","І каже Мойсей: З молодиками нашими й з дїдами нашими пійдемо, з синами й дочками нашими, з отарами й чередами нашими пійдемо; бо сьвято Господа Бога в нас. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","І каже він: Нехай буде так. Господь із вами! Я готов відпустити вас, но чому з малечою вашою? Та гледїть, у вас бо на умі щось лихе! ");
INSERT INTO ukr1871_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Нї бо! Йдїте собі, що вже дорослі, та й послужіте Господеві; сього бо самі допевняєтесь. Та й вигнали їх зперед Фараона. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","І рече Господь Мойсейові: Просьтягни руку твою над Египецькою землею про сарану, і нехай налетить сарана на Египецьку землю, та й пожере всю траву земну, що лишив гряд. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","І простяг Мойсей жезло своє над Египецькою землею, Господь же наводив од схід сонця вітра на землю весь той день і всю ніч, а як обутріло, східний вітер нагнав сарану. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","І напала сарана на всю землю Египецьку, і посїла вона по всїх займищах Египецьких, тьма тьмою. Доти не було такої сарани, і потім не буде такої. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","І вкрила лице всієї землї, так що земля почорнїла, та й пожерла всю траву земную й усї плоди на деревах, що позоставались од гряду, і не зосталось нїчогісїнько зеленого на дереві або на траві в полях, по всїй землї Египецькій. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","І метнувся Фараон кликати Мойсея та Арона, та й каже: Провинив Господеві, Богу вашому, та й вам. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Простїте ж мою провину тілько сей раз, і вблагайте Господа, Бога вашого, щоб одвернув од мене сю тілько смерть. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","І вийшов Мойсей од Фараона і вблагав Господа. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","І дав Господь вітер потужний на захід соньця, і взяв той вітер сарану та й вкинув її в Червоне море. Не зісталось же сарани по всїх Египецьких займищах. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Та закаменив Господь запекле серце Фараонове, і не відпустив він синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","І рече Господь Мойсейові: Простягни руку твою до неба, і нехай постане темрява над Египецькою землею така, щоб ходили помацки. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","І простяг Мойсей руку свою до неба, і стояла густа темрява по всїй землї Египецький три днї. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","І не бачило одно ʼдного, і не встав нїхто з місця свого три днї, у всїх же синів Ізрайлевих був сьвіт по їх осадах. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","І кликне Фараон Мойсея та Арона, та й каже: Йдїте служити Господеві, тільки отарі та череди покиньте. Малеча ж ваша теж нехай йде з вами. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","І каже Мойсей: Нї! ти сам нам даси й жертви й усепалення, щоб ми принесли Господеві, Богу нашому. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Та й уся наша скотина пійде з нами; не покинемо позад себе й копита; з них бо брати мемо про службу Господеві, Богу нашому; ми же і самі не відаємо, чим служити мем Господеві, аж покіль прийдемо туди. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","І закаменив Господь серце Фараонове, і не схотїв він одпустити їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","І каже йому Фараон: Ійди геть собі від мене! Сховайся! Не побачиш уже лиця мого; бо того дня, як побачиш лице моє, тобі й смерть. ");
INSERT INTO ukr1871_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","І каже Мойсей: Правду промовив єси: вже не бачити му лиця твого. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","І рече Господь Мойсейові: Ще одну муку наведу на Фараона й на Египет, а потім одпустить він вас ізвідсї. Як мусить одпустити вас, тодї гонити ме вас ізвідсї прогоном. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Промовляйте ж в уші людям, і нехай кожне вижичить у сусїда свого, а молодиця в сусїдки своєї клейноти срібні й клейноти золотї. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Господь же дав людям своїм ласку в Египтян; а Мойсей сам був чоловік великий вельми в Египецькій землї в очу дворян Фараонових і в очу людей. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","І каже Мойсей: Тако глаголе Господь: О півночі я вийду серед Египту. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","І помре всякий первенець у землї Египецькій, від первеньця Фараонового, що седить на престолї свойму, та й до первеньця рабинї за жорнами, і всякий первак у скотини. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","І буде плач великий по всїй землї Египецькій, що й не було такого й не буде вже нїколи. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Нї на одного ізміж синів Ізрайлевих і пес не гавкне, нї проти людини, нї проти скотини, щоб знали ви, як Господь положив ріжницю між Египтянами й синами Ізрайлевими. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","І прийдуть усї твої дворяне до мене, та й уклоняться менї говорючи: Виходь ізвідсї сам і всї люде, що йдуть за тобою; тодї й вийду. Та й вийшов од Фараона палаючи гнївом. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","І рече Господь Мойсейові: Не послухає вас Фараон, щоб я велико намножив знамення мої й чудеса в Египецькій землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Мойсей же та Арон сотворили всї знамення й чудеса перед Фараоном, та закаменив Господь серце Фараонове, і не схотїв одпустити синів Ізрайлевих із землї своєї. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","І рече Господь Мойсейові та Аронові у землї Египецькій: ");
INSERT INTO ukr1871_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Місяць сей вам буде початок місяців, первий буде вам в місяцях року. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Промовте до всієї громади синів Ізрайлевих тако: У десятий день місяця сього брати ме кожен ягня на семю батька свого. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Коли ж семя буде помала на ягня, нехай прийме до себе сусїда, близького до його домівки, по лїку душ. Кожен по їдї своїй зложить лїк на ягня. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ягня нехай буде без пороку, самчик однолїток; брати мете його з овечат або з кіз. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","І держати мете його до чотирнайцятого дня того місяця, і заколе його вся громада Ізраїльська надвечір. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","І візьмуть крові та й побризкають нею оба одвірки й пороги в домах, де їсти муть його. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","І їсти муть мясиво тієї ночі; спечене на огнї їсти муть його з опрісноками, з гіркими зелами їсти муть його. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Не їжте сироватого, нї звареного в водї, а спечене на огнї, голову його з ногами й з утробиною. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","І не зоставляти мете нїчого до ранку, що ж зостанеться до ранку, спалити на огнї. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","І їсти мете його таким робом: боки ваші попідперезувані, обувє ваше на ногах ваших, і палицї ваші в руках у вас; і їсти мете його похапки. Пасха се Господня! ");
INSERT INTO ukr1871_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Пройду бо по землї Египецькій, тієї ночі, та й повбиваю всякого первеньця в землї Египецькій, і людину й скотину, і над усяким богом Египецьким сотворю суд, я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","І буде вам кров знаменнєм по хатах, де будете. Бачивши кров, мину вас, і не буде в вас погибелї, як карати му Египет. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","І буде вам день сей про спомин, і сьвяткувати мете сьвято Господеві; як установу вічну, сьвяткувати мете в родах ваших. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Сїм день опрісноки їсти мете. Первого вже дня виносити мете закваску з хат ваших; бо хто їсти ме квашений хлїб од первого дня та й до семого, викорениться та душа спроміж Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","І первого дня будуть сьвяті збори у вас, і семего дня будуть сьвяті збори у вас. Нїякого дїла не робити мете тодї, тїльки потрібне на їду всякій душі, те можна робити в вас. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","І переховувати мете заповідь сю опріснокову; того бо дня виведу потугу вашу з Египецької землї. Тим переховувати мете день сей в родах ваших: установа вічня. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Починаючи ж чотирнайцятого дня первого місяця ввечорі, їсти мете опрісноки до двайцятого й первого дня місяця; установа вічня. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Сїм день закваски щоб не було по хатах у вас: бо хто їсти ме квашене, викорениться душа та спроміж громади Ізрайлевої, чи воно чуже, чи землянин. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Нїчого квашеного не їжте; по всїх же хатах ваших їжте опрісноки. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","І поскликав Мойсей всїх старших між синами Ізрайлевими, і каже їм: Ідїть, поймайте собі ягня по родинах ваших, і заколїте на пасху. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","І возьміте по кущику гиссопу, та вмочіть у кров, що в мисцї, та й помажте поріг й оба одвірки кровю, що в мисцї, і нїхто з між вас не виходити ме за хатні двері свої до ранку. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","І йти ме мимо Господь побивати Египтян, і побачить кров на порозі й на одвірках, і мине ті двері, і не попустить губителеві ввійти до вас у хату побивати вас. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","І переховувати мете се установою собі і дїтям вашим на віки. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","І як прийдете в землю, що дасть вам Господь, як і глаголав, дак сохраняти мете служеннє се. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","І як поспитають у вас тодї дїти ваші: Що се за служеннє в вас? ");
INSERT INTO ukr1871_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ви казати мете: Жертва пасхова се Господеві, що проходив понад хатами в синів Ізрайлевих в Египтї, як побивав Египтян, доми ж наші ізбавив. І похилились люде й поприпадали до землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","І пійшли та й учинили сини Ізрайлеві; як повелїв Господь Мойсейові та Аронові, так і вчинили. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","І сталось о півночі, що Господь побив усї первеньцї в Египецькій землї, від первеньця Фараонового, що седїв на престолї свойму, та й до первеньця невольника в темницї, і всї перваки в скотини. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Схопиться ж Фараон у ночі, й усї дворяне його, й усї Египтяне, аж постав зойк по всїй землї Египецькій. Не було бо дому й хатини, де б не було мерця. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","І покликав Мойсея та Арона та й каже: Вставайте, виходьте спроміж людей моїх, і ви й синове Ізрайлеві, та й ійдїте собі, служіте Господеві, як мовляли! ");
INSERT INTO ukr1871_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","І вівцї ваші, й товар ваш забірайте, як мовляли, та й ідїть а мене благословіть! ");
INSERT INTO ukr1871_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","І понукали Египтяне людей, хапаючись проводити їх із землї; бо казали: Пропадемо всї! ");
INSERT INTO ukr1871_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","І позабирали люде тїста свої ще до закису, дїжї свої поввязували в одїж їх по заплїчу в їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","І чинили сини Ізрайлеві по слову Мойсейовому, і вижичали в Египтян клейноти срібні й клейноти золоті й шати. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","І дав Господь ласку людям в очу в Египтян, що вволяли волю їх, і спліндрували вони Египтян. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","І мандрували сини Ізрайлеві од Рамсесу до Сухоту до шесьтьох сот тисяч пішки чоловіка, опріч дїтви. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","І мішаного народу много знялось із ними, й вівцї, і товар, дуже багацько скотини. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","І понапекали палениць опрісноків із тїста, що позабірали з Египту; бо ще не закисло, а їх виганяли з Египту, і не можна було гаятись, а запасу собі не приготовили. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Пробуваннє синів Ізрайлевих у Египтї було чотирі ста і трийцять год. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","І сталось по чотирох стах і трийцять роках, остатнього дня, що вийшла вся потуга Господня з Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Сьвяткова се ніч Господеві за вивод їх із Египецької землї. Се ж то й єсть ніч сьвяткована Господеві про всї сини Ізрайлеві в роди і роди їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","І рече Господь Мойсейові та Аронові: От установа паскова: Нїякий чужениця щоб не їв паски. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Усякий же раб, куплений за гроші, як обріжеш його, їсти ме її. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Заволока ж і наймит нехай не їсть її. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ув одній хатї їсти меться; не виносити меш нїчогісїнько з мясива геть із хати анї кісточки не переломиш із його. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Уся громада Ізраїльська допильновувати ме сього. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","А як пробувати ме заволока з тобою та схоче сьвяткувати пасху Господеві, нехай обріжуть увесь його музький пол, і він буде такий, як землянин. Усякий же необрізаний не їсти ме її. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Закон один щоб у вас був, і землянинові, і захожому, що заволїкся до вас. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Так і вчинили сини Ізрайлеві, як заповідав Господь Мойсейові та Аронові; так і вчинили вони. ");
INSERT INTO ukr1871_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","І вивів Господь того самого дня сини Ізрайлеві з землї Египецької з потугою їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Посьвяти менї всї первеньцї, первородних з усякої утроби між синами Ізрайлевими, і в людини, і скотини: мої вони будуть. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","І промовив Мойсей до людей: Памятайте день сей, которого виходите з Египту, із невольницького дому, рукою бо потужною вивів Господь вас ізвідсї; не їжте заквашеного хлїба. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","В сей день вас виведено в місяцї Абиб. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","І станеться, як уведе тебе Господь у землю Канаанську, Гетійську, Аморійську, Гевійську, Ебусійську, що нею клявся батькам твоїм оддати тобі, в землю текучу молоком та медом, тодї служити меш службу сю в місяцї сьому. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Сїм день їсти меш опрісноки, а семого дня сьвято Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Опрісноки їсти меш сїм день, і не буде видко в тебе квашеного, і не буде видко в тебе заквасу по всїх займищах твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","І будеш оповідувати дїтям твоїм так: Се за те, що сотворив Господь менї, як вийшов я з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","І буде се в тебе знаменнєм на руцї твоїй і споминкою між очима в тебе, про те щоб закон Господень був ув устах твоїх: рукою бо міцною вивів тебе Господь із Египту. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","І допильновувати меш установи сієї знаного часу від року до року. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","І як приведе тебе Господь у Канаан землю, як він клявсь тобі й батькам твоїм, та й оддасть її тобі, ");
INSERT INTO ukr1871_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Вилучати меш тодї всякого первеньця з утроби Господеві, і всякого первачка в скотини, яка в тебе єсть. Первеньцї мусять бути про Господа. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Всяке ж осля первачка викуповувати меш ягням; коли ж не викупиш, дак мусиш зламати шию йому. Усякого ж первеньця людського викуповувати мусиш. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","І станеться, що як поспитає син твій кажучи: Що воно таке? казати меш йому: Рукою потужною вивів нас Господь з Египту, із дому невольницького. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","І як затявся Фараон одпустити нас, дак побив Господь усї первенцї в землї Египецькій, і первеньця в людини й первака в скотини; тим і я приношу на жертву Господеві всї первеньцї самчики, а всї первеньцї із моїх синів викуповую. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","І мусить воно бути знаменнєм на руцї в тебе і повяззю проміж очима твоїми; рукою бо міцною вивів нас Господь із Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","І сталось, як одпустив Фараон люде, що не повів їх Бог по дорозї до землї Филистимської, хоч вона й близька; бо рече Бог: ато жалкувати муть люде, побачивши войну, та й вернуться в Египет. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","І повів Бог люде по дорозї до степу Червономорського. І стали сини Ізрайлеві виходити полками із землї Египецької. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","І забрав Мойсей костї Йосифові з собою; бо клятьбою закляв той сини Ізрайлеві, такою: Навідом навідається до вас Бог, і винесете ви костї мої звідсї з собою. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","І помандрували вони від Суккотта та й отаборились ув Етамі, уз край степу. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Господь же йшов перед ними в день стовпом хмаряним, щоб вести їх по дорозї, а в ночі стовпом огняним, щоб можна було йти й у день і в ночі. ");
INSERT INTO ukr1871_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Не віднїмав у людей у день стовпа хмаряного, і в ночі стовпа огняного. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Промов до синів Ізрайлевих, щоб одвернули й отаборились перед Пі-Гахиротом, між Микдолом і морем; перед Бааль-Цефоном отаборитесь навпроти його, при морі. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Бо казати ме Фараон про сини Ізрайлеві: Заблудили в цїй землї та й зачинив їх у собі степ. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Я ж окаменю запекле серце Фараонове, щоб уганяв за ними, і прославлюсь на Фараоні й на всьому війську його, і зрозуміють Египтяне, що я Господь. І вчинили так. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","І сповіщено царя Египецького, що втекли люде, і повернулось у Фараона й у дворян його серце проти людей, і промовляли вони: Що се ми зробили, що відпустили Ізраїля з нашої неволї? ");
INSERT INTO ukr1871_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","І повелїв запрягти колесницю свою, і взяв із собою люде свої, ");
INSERT INTO ukr1871_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","І взяв шість сот бойових колесниць на вибір і всї колесницї Египецькі, і військових до кожної. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","І закаменив Господь серце в Фараона, царя Египецького, і погнався він за синами Ізрайлевими. Синове ж Ізрайлеві виходили під рукою високою. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","І вганяв Египтїй за ними та й наздогнав їх, як отаборились при морі, усї конї в колесницях у Фараона, комонник його і потуга його, при Пі-Гахиротї, по близу Бааль-Цефону. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","І як наблизився Фараон, зняли сини Ізрайлеві очі свої, аж се Фараон уганяє за ними, та й полякались вельми. І заквилили Ізрайлитяне до Господа, та й гукали Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Хиба тим, що нема в Египтї кладовищ, позабірав єси нас умірати в степу? Що се вкоїв єси з нами, що вивів нас із Египту? ");
INSERT INTO ukr1871_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Чи не те ж саме говорено тобі в Египтї: Відкажись од нас, щоб нам пробувати в неволї в Египтїя? Бо лучче нам бути в неволї, нїж помірати в степу. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","І рече Мойсей людові: Не лякайтесь і стійте, дак і побачите рятунок Господень, що сотворить нам Господь сьогоднї. Бо Египтїя, що сьогоднї бачите, не бачити мете во віки! ");
INSERT INTO ukr1871_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Господь бо воювати ме за нас, ви ж бувайте супокійні. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","І рече Господь Мойсейові: Чого квилиш до мене? Промов до синів Ізрайлевих, щоб рушали далїй. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ти ж возьми жезло твоє та просьтягни руку твою над морем, та й роздїли його, і ввійдуть синове Ізрайлеві в середину моря по сусї. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Я ж закаменю серце в Фараона й Египтїїв, і вони пійдуть слїдом; і прославлюсь на Фараонї й на потузї його, на колесницях його й на комінникові його. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","І знати муть Египтїї, що я Господь, як прославлюсь на Фараонові, на колесницях його й на комінникові його. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","І рушив тодї ангел Божий, що йшов поперед табору Ізрайлевого, та й став позад їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","І ввїйшов проміж табором Египтїєвим і проміж табором Ізрайлевим. І стала хмара темрявою про одного з них і сьвітлом про другого. І не наближувавсь один табір до другого, покіль було й ночі. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","І простїг Мойсей руку свою над морем, і одганяв Господь море геть потужним восточнім вітром у сю ніч, і зробив море сухим; і роздїлив води. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","І ввійшли синове Ізрайлеві в середину моря по сусї; води ж були їм греблею праворуч і лїворуч. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","І погнавсь Египтїй і поввіходили за ними всї конї Фараонові, і колесницї його й комонник його. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","І сталось у ранїшню сторожу, що споглянув Господь на табір із огняного й хмаряного стовпа, та й стрівожив табір Египтїйський. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","І поскидав колеса з колесниць у них, та й позагальмовував ходу в їх. І загукав Египтїй: Утекаймо од Ізраїля, бо Господь воює за них із Египтїєм! ");
INSERT INTO ukr1871_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","І рече Господь Мойсейові: Простягни руку твою понад морем, і вернуться води на Египтїя, й на колесницї його, й на комонника його. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","І просьтіг Мойсей руку свою понад морем, і почало вертатись море ранїшньою добою до своєї потуги. Египтїї ж метнулись навпроти його, і скидав Господь Египтїя в безодню морську. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","І вертались води, та й затопили колесницї, й комонника з усїєю потугою Фараоновою, що поввіходили за ними в море. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Синове ж Ізрайлеві йшли по сусї, посеред моря, і води були їм греблею праворуч і лїворуч. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","І вирятував Господь у той день Ізраїля зпід потали Египтїєвої, і вбачав Ізраїль Египтїя мертвим на березї морському. ");
INSERT INTO ukr1871_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","І вбачав Ізраїль диво велике, що сотворив Господь над Египтїєм; і стали люде страхатись Господа, та й увірували Господеві й слузї його Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Засьпівав тодї Мойсей й синове Ізрайлеві пісню Господеві, і сьпівали сими словами: Ой сьпіваймо ж Господеві, славно бо прославивсь, і коня і їздеця він поввергав у море. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Господь, сила моя й велич, був моїм рятунком. Він мій Бог, і я споруджу дом йому преславний. Вознесу його, прославлю Бог-отця благого. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Господь — муж боїв страшенний, на імя Господь він. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Колесницї в Фараона і полки-потуги Божа сила потопила, поввергала в море, і вибране отаманнє потонуло в морі; лицярі над лицарями згинули в Червонім, ");
INSERT INTO ukr1871_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Глибиня їх повкривала по всї вічні роки; мов каміннє потонули у морю глибокім. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Господе! твоя правиця вславилась в потузї; Господе! твоя десниця ворога згубила. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Величчю твоєю, Боже, стер єси противних, послав гнїв твій, і огнем він мов стебло пожер їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Духом яростї твоєї води роздїлив ти, і загусли муром филї, встали серед моря. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Рече ворог: Пожену їх, уженусь, настигну; попаюю здобич, буде міч мій царювати. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Но дмухнув єси вітрами, море їх укрило, мов те оливо втонули в морі, у безоднї. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Хто тобі подобен в бозїх, Господе, хто рівен, славен сьвятостю твоєю, страшен чудесами! ");
INSERT INTO ukr1871_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Простягнув єси правицю, — їх земля пожерла. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Вивів правдою твоєю люде сї з неволї, і провів потужно в землю, в займище спасенне. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Чути муть про се народи, острах їх обійме, печаль серце Филистимське туга гризти буде. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Стуманїють і Єдомцї, глави Моавійські, і тремтіти муть потужні дуки Канаанські. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ой нехай же страх і трепет злющих постигає, величчю руки твоєї в камінь обертає! Докіль, Господе, перейдуть вірні щирі люде, що з усїх людей собі ти вибрав у наслїддє. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Уведеш їх і насадиш на горі наслїднїй, там, о Господе, насадиш, де пречистї руцї уготовили сьвятиню про всї вічні роки. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ой царюй же, Боже правий, правдою во віки! ");
INSERT INTO ukr1871_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Бо ввійшов кінь Фараонів, колесницї його й комонник його в море, і вернув Господь на їх воду, а синове Ізрайлеві пройшли по сусї, серед вод. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","І взяла Мирияма, натхнена сестра Аронова, бубен у руку свою, і повиходило все жіноцтво за нею з бубнами й таньцями. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Відказувала Мирияма їм: Ой сьпіваймо Господеві, славно бо прославивсь, і коня і їздеця він повкидав у море! ");
INSERT INTO ukr1871_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","І повелїв Мойсей Ізрайлеві рушати від Червоного моря, і вийшли вони з Сур степу, і йшли три днї степом, та й не знаходили води. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","І прийшли в Меру, та не змогли пити води Мерської, бо гірка вона, тим і прозвали те врочище Мера. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","І нарекали люде на Мойсея, говорючи: Що нам пити? ");
INSERT INTO ukr1871_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","І заголосив Мойсей до Господа, і вказав йому дерево Господь, і вкинув його він у воду, і прісною стала вода. Там він дав їм установу й суд, і сим робом випробував їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","І рече: Коли щиро слухати мешся голосу Господа Бога твого, і чинити меш праведне в очу його, і нахиляти меш ухо до заповідей його, і допильновувати меш усїх установ його, нї одну болесть, що я наводив на Египтян, не наведу на тебе: я бо Господь, Бог твій, що виздоровлює тебе. ");
INSERT INTO ukr1871_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","І прийшли в Єлим, аж там двайцять водяних криниць і сїмдесять пальм. І отаборились там понад водою. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","І двинули від Єлиму, і прийшла вся громада синів Ізрайлевих у Син степ, що між Єлимом і Синайом, у пятнайцятий день місяця по виходї з Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","І нарекала вся громада Ізраїльська на Мойсея та Арона в степу. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","І мовляли їм синове Ізрайлеві: Лучче б нам було повмірати од руки Господньої в Египецькій землї, як седимо було круг казана з мясивом, як їмо було хлїба до схочу. Бо вивели ви нас у пустиню сю, щоб голодом поморити всю громаду. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","І рече Господь Мойсейові: Се сипати му дощем хлїб вам з небес, і виходити муть люде, і збирати муть щодня тільки деннїй пай, щоб менї випробувати їх, чи ходити муть у законї мойму, чи нї. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","А шостого дня, як заготують вони, що принесли, дак вийде удвоє проти того, що збирають повсяденно. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","І промовили Мойсей та Арон до всїх синів Ізрайлевих: Ось увечорі взнаєте, що се Господь вас вивів із Египецької землї; ");
INSERT INTO ukr1871_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","А враньцї побачите славу Господню; бо він чув нарекання ваше на Господа. Ми ж, що ми таке, що нарекаєте на нас? ");
INSERT INTO ukr1871_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","І рече Мойсей: По сьому пізнаєте, як давати ме вам Господь увечорі мясива їсти, а враньцї до схочу хлїба, бо чув Господь нареканнє ваше на його. Бо що ми таке? Не на нас нарекаєте а на Господа. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","І рече Мойсей Аронові: Промов до всїєї громади Ізрайлевої: Приступіте перед Господа; бо він почув нареканнє ваше. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","І сталось, як промовляв Арон до всієї громади Ізрайлевої, обернулись вони до степу, і се слава Господня явилась у хмарі. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","І глаголе Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Чув я нареканнє синів Ізрайлевих; тако промов до них і кажи: Між двома вечорами їсти мете мясиво, а враньцї насититеся хлїбом, та й зрозумієте, що я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","І знялись увечорі перепелицї, укрили табір, а враньцї була роса круг табору. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","І знялась роса, і се на степовому виду дрібні крупи, дрібні, як іней на землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","І вбачали синове Ізрайлеві і мовляли одно одному: Що се таке? Не знали бо, що воно єсть. І рече Мойсей їм: Се хлїб, що дав Господь вам на їду. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Се те, що велїв Господь глаголючи: Нехай кожне збирає, скілько на їду кому треба, гомер на кожного, беріть по лїчбі душ ваших, про кожного, хто в вас у наметї. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","І вчинили так сини Ізрайлеві, та й назбирали, хто багацько, хто мало. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","І як міряли гомером, дак не було лишнього в тих, що понабирали багацько, а в тих, що понабирали мало, не було недостачі; кожне по мірі їди своєї набрало. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","І рече Мойсей їм: Нехай нїхто не зоставляє сього до ранку. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Та не послухали вони Мойсея, і декоторі позоставляли до ранку. І завелись у тому черви і засмердїлось воно. І гнївився на їх Мойсей. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","І набирали вони його ранками, кожне по їдї своїй, зійде соньце, воно й розтане. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","І сталось дня шостого, понабирали собі удвоє хлїба, кожне по два гомери на людину; і прийшли всї громадські мужі князї та й повідали Мойсейові; ");
INSERT INTO ukr1871_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","І рече їм: Се те слово, що глаголе Господь: Завтра субота в нас, опочивок сьвятий Господеві; що хочете спекти, понапекайте, і що зварити, понаварюйте сьогоднї. Все ж лишнє ховайте до ранку. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","І позоставляли вони те до ранку, як повелїв Мойсей, і не засмердїлось воно, і не позаводились у йому черви. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","І рече Мойсей: Їжте сьогоднї, бо сьогоднї субота Господеві; сьогоднї не знайдете сього в полї. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Шість день збірайте; семого ж дня субота, не буде його. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","І сталося семого дня, що повиходили декоторі зміж людей збирати, та й не знайшли. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","І рече Господь Мойсейові: Докіль становити метесь опором проти заповідей моїх, щоб допильновувати заповідей моїх і закону мого? ");
INSERT INTO ukr1871_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Дивітесь: дав вам Господь суботу опочивок, тим і дає вам шостого дня на два днї хлїба. Зоставайся кожен на місцї свойму, нехай нїхто не виходить із місця свого в день сьомий. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","І народ відпочивав семого дня. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","І звав дом Ізрайлїв те манна; була вона схожа на корияндрове сїмя: біла, а смак її, як у медімниках. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","І рече Мойсей: От що заповідав Господь: Сповнїте нею гомер на переховуваннє в родах ваших, щоб убачати їм хлїб, що ним харчив я вас у степу, як вивів із Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","І рече Мойсей Аронові: Возьми посудину та й усип туди повний гомер манни, та й постав її перед Господом на переховуваннє із роду та й до роду. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Як заповідав Господь Мойсейові, так і поставив Арон перед сьвідоцтвом на переховуваннє. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Синове ж Ізрайлеві їли манну сорок год, до приходу в осаджену землю; їли вони манну, докіль прийшли в займища Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Гомер же, се девятина ефи. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","І мандрувала вся громада Ізраїльська із Син степу, переходами, по слову Господньому. І втаборились у Рефидимі; і не було води пити людям. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","І сварились люде з Мойсейом, і гукали: Дай нам пити! І рече Мойсей їм: Чого сваритесь зомною? Про що спокушуєте Господа? ");
INSERT INTO ukr1871_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","І були там люде жадні води, і нарекали на Мойсея кажучи: Про що се ти вивів нас із Египту, щоб уморити нас, і дїти наші, і скот наш жадою? ");
INSERT INTO ukr1871_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","І заголосив Мойсей до Господа кажучи: Що маю дїяти з людьми моїми? Ще трохи, та й побють мене каміннєм. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","І рече Господь Мойсейові: Пройди поперід людей, та возьми з собою старших мужів громадських Ізраїльських; і палицю твою, що нею вдарив єси по ріцї, візьми в руку твою, та й ійди. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Се я стану перед тобою там, на скелї в Горебі; і вдариш ти по скелї, і рине з її вода, щоб напились люде. І вчинив так Мойсей перед віччу в старших мужів громадських Ізраїльських. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","І проложив прізвище врочищу тому: Маса і Мерива задля сварки між синами Ізрайлевими і задля того, що спокушували Бога мовляючи: Чи Господь є між нами, чи нема? ");
INSERT INTO ukr1871_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","І прийшов Амалек, і бив на Ізраїля в Рефидимі. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","І рече Мойсей Йосуї: Навибірай нам людей та йди битись із Амалеком; завтра се я стану на шоломенї ховма і жезло Боже в руцї моїй. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","І вчинив Йосуа так, як повелїв йому Мойсей; почав битись із Амалеком. А Мойсей, Арон та Гур зійшли на шоломє ховма. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","І сталось, що як піднімав Мойсей руцї, дак брали гору Ізраілитяне, а як попускав Мойсей руцї свої, дак брав гору Амалек. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Та стали важкі руки Мойсея. Тодї взяли вони каменя, та й підложили під його, і седїв на йому; Арон же та Гур стали піддержувати руцї його, один з одного боку, другий з другого, і піддержувано руцї його до заходу соньця. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","І повалив Йосуа Амалека й людей його мечовим лезвом. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","І рече Господь Мойсейові: Впиши се на спомин у книзї, та передай се слухам Йосуєвим, що зотру до щаду й память Амалекову спід небес. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","І поставив Мойсей жертівника і дав йому імя Егова-Нїссі. ");
INSERT INTO ukr1871_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Каже бо: Рука на престолї Господа: війна у Господа проти Амалека з роду в рід. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","І перечув Єтро, сьвященник Мидиянський, тесть Мойсеїв, про все, що сотворив Бог Мойсейові і Ізрайлеві, і що вивів Господь Ізраїля з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","І взяв Єтро, тесть Мойсеїв, Зипору, жену Мойсейову, після того, як відослав її до дому. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","З обома її синами, з котрих на імя одному Герсон, рече бо: Гостем я був у чужій землї, ");
INSERT INTO ukr1871_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","А імя другому Єлиезер, Бог бо панотця мого поміч моя, вирятував мене спід меча Фараонового. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","І прийшов Єтро, тесть Мойсеїв, і синове його й жена його, до Мойсея в степ, де він стояв табором, під горою Божою. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","І каже Мойсейові: Я, тесть твій Єтро, прибув до тебе, і жена твоя й обидва сини твої з нею. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","І вийшов Мойсей на зустріч проти тестя свого, і вклонивсь до землї й поцїлував його, і спитали вони один одного про здоровля, та й увійшли в намет. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","І повідав Мойсей тестєві свойму про все, що сотворив Господь Фараонові й Египтові задля Ізраїля, і про всї турботи, які спіткали їх у степу, і як вирятовував їх Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","І веселився Єтро всїм добром, що сотворив Господь Ізрайлеві, що його визволив із потали в Египтїя. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","І каже Єтро: Благословен Господь, що вас визволив з неволї, в Египтїя й Фараона вирятував, спас вас! ");
INSERT INTO ukr1871_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Тепер знаю, що він більший, нїж усї богове, тим самим їх переважив чим вони пишались. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","І взяв Єтро, тесть Мойсеїв, всепаленнє й жертви Богу, і прийшов Арон і всї старші мужі громадські в Ізраїля трапезувати з тестєм Мойсейєвим перед Богом. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","І сталось вранцї, що сїв Мойсей судити люде; і стояли люде перед Мойсейом з ранку та й до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","І бачив тесть Мойсеїв усе, що він чинив з людьми, та й каже: Що се таке ти коїш із людьми? Про що седиш сам, а всї люде стоять коло тебе з ранку та й до вечора? ");
INSERT INTO ukr1871_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","І рече Мойсей тестьові свойму: Про те, що люде до мене ходять питати Бога. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Як зайде в їх яка справа, приходять вони до мене, і я розсуджую кожного, та й ясую установи Господні й закони його. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","І каже Мойсеїв тесть йому: Не гаразд робиш ти се. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Знеможешся й сам и сї люде, що з тобою, бо тяжке тобі се дїло тим, що не сила твоя справитись одному. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ось послухай лишень голосу мого; пораджу я тебе, дак і буде з тобою Бог. Бувай ти сам за людей перед Богом, та й доводити меш справи до Бога. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","І навчати меш їх установ й закону, і вказувати меш їм дорогу, що нею мусять ходити, і дїла, що мусять чинити. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","А сам ти вигледиш ізміж усїх людей зугадних, богобоязливих, людей щирих, що ненавидять здирство, та поставиш над їми тисяцькими, соцькими, полусоцькими й десяцькими. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","І нехай судять їх люде по всяк час, а всї великі справи доводити муть вони до тебе, усї ж малі справи судити муть самі. І лекше буде на тебе, і нести муть вони тягар укупі з тобою. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Як се ти впорядкуєш і повелить се тобі Бог, дак устоїш, і всї цї люде прийдуть у займища свої супокійно. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","І послухав Мойсей голосу тестєвого, та й упорядкував усе так, як пораяв йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","І повибірав Мойсей людей зугадних зміж усього Ізраїля, та постановив їх головами над людьми, тисяцькими, соцькими, полусоцькими й десяцькими. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","І стали вони судити люде по всяк час. Трудну справу доводили до Мойсея, а всяке дїло мале судили самі. ");
INSERT INTO ukr1871_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","І відпустив Мойсей тестя свого, й пійшов він собі в землю свою. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Місяця ж третього по ізходї синів Ізрайлевих із Египецької землї, того ж самого дня прийшли вони в Синайський степ. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","І двинули вони від Рефидиму, та й прийшли в Синайський степ, да й отаборились у пустинї. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","І став там кошем Ізраїль проти гори. І покликав Господь Мойсея, і рече: Так дому Якововому вкупі з Ізраїлем ти возглаголеш: ");
INSERT INTO ukr1871_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ви бачили, що сотворив я в Египтї лихим Египтянам. Як нїс вас орловими крильми і всїх поприводив до себе. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Оце ж, коли будете гласу мого послухати й хранити завіт мій із вами й умову, дак будете пай мій в народах, моя ж бо земля вся вселенна, ");
INSERT INTO ukr1871_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","І будете в мене ви царством сьвященним, народом вибраним. Се словеса, що мусиш возглаголати синам Ізрайлевим. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","І прийшов Мойсей і покликав старших мужів громадських, і росказав перед ними всї словеса, що завітував йому Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","І відказали всї люде одностійно і мовляли: Усе, про що глаголав Господь, сповняти мемо. І переказав Мойсей людські слова Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","І рече Господь Мойсейові: Се я прийду до тебе в густій хмарі, щоб чували люде, як розмовляти му з тобою, і щоб також няв тобі віри довіку. І повідав Мойсей слова людські Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","І рече Господь Мойсейові: Іди до людей, та й очищай їх, і сьогоднї й завтра, і нехай повипірають одїж свою, ");
INSERT INTO ukr1871_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","І будуть готові проти третього дня; бо на третїй день Господь зійде до долу, перед віччю в усїх людей, на Синай гору. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","І положиш границї людям з усїх боків, говорючи: Остерегайтеся сходити на гору і доторкуватись до країв. Хто доторкнеться до гори, тому смерть. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Нїчия рука нехай не доторкнеться до неї, бо побє його каміннє, або застрілить стріла. Чи скотина, чи людина, живе не буде. Як трубити ме веселим гуком, тодї можна зійти на гору. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","І спустився Мойсей з гори до людей, та й сьвятив люде, і повипирали вони одїж свою. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","І рече він людям: Бувайте готові проти третього дня; не пригортайтесь до жінок. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","І сталось третього дня, як обутьріло, загриміли громи, заблищали блискавки, і затрубило в роги страшенно; і затремтїли всї люде в таборі. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","І повиводив Мойсей людей до Бога з табору, і постали вони попід горою. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","І димувала вся Синай гора, тим що спустивсь на її Господь в поломнї. І підіймався дим із її як дим із горна, і тремтїла вся гора вельми. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","І гучав голос роговий голоснїш та голоснїш. Мойсей говорив, а Бог відказував йому гласом. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","І спустився Господь на Синай гору, на верх гори; і покликав Господь Мойсея на верх гори, і піднявся Мойсей. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","І рече Господь Мойсейові: Спустись, остережи людей; ато протовпляться до Господа, і богато зміж їх поляже. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","І сьвященники, що приступають до Господа, нехай осьвятяться, щоб не поразив їх Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","І рече Мойсей Господеві: Не приступати муть люде до Синай гори; сам бо остерегав і завітував єси нам, глаголючи: Положи гряницї кругом гори і осьвяти її. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","І рече йому Господь: Ійди, спустись, і піднімешся ти і Арон з тобою; сьвященники ж і люде нехай не важяться через границю товпитись до Господа; ато поразить їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","І спустився Мойсей до людей і повідав їм. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","І глаголав Господь всї словеса оцї, глаголючи: ");
INSERT INTO ukr1871_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Я Господь, Бог твій, що вивів тебе з Египту, із дому невольницького. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Нехай не буде в тебе богів инших перед моїм лицем. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Не робити меш собі ваяного кумира чи подобини того, що на небесах у горі, і того, що на землї внизу, і того, що в водах і попід землею. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Щоб не припадав ниць перед ними і не служив їм; бо я Господь, Бог твій, ревнивий Бог, що караю беззаконнє отецьке на дїтях у третьому, і четвертому родї тих, що ненавидять мене. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","І роблю добро тисячами родів тих, що люблять мене і допильновують заповідей моїх. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Не призивати меш імени Господа, Бога твого, марно. Бо не вважати ме Господь безвинним того, хто призиває імя його марно. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Памятай день субітнїй, щоб сьвятити його. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Шість день можна тобі працювати й робити всяке дїло твоє. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","День же семий субота Господеві, Богу твойму. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Бо шість день творив Господь небеса і землю, море й усе, що в їх, і перестав дня семого; тим благословив Господь субітнїй день і осьвятив його. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Шануй батька твого й матїр твою, щоб довголїтен був ти на землї, що Господь, Бог твій, дасть тобї. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Не вбивати меш. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Не прелюбкувати меш. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Не красти меш. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Не сьвідкувати меш льживо на близького твого. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Не поривати меш очей на хату близнього твого; не поривати меш очей на жену його, нї на раба його, нї на рабиню його, нї на скотину його, нї на осла його, нї на що, що є близьнього твого. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","І вбачали всї люде громуваннє й блискавицї, і гук роговий, і гору димуючу, і вбачаючи відступили назад і стояли оддалеки. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","І мовляли вони Мойсейові: Розмовляй сам із нам, дак ми слухати мемо, та нехай не розмовляє з нам Бог, ато повміраємо. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","І рече Мойсей людям: Не бійтесь; бо щоб випробувати вас, прийшов Бог, і щоб страх його був перед лицем вашим, щоб ви не согрішали. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","І постали люде оддалеки; а Мойсей приступив до темряви, де Бог. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","І рече Господь Мойсейові: Тако промовиш до синів Ізрайлевих: Бачили ви, що з небес я розмовляв із вами. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Не робити мете передо мною богів срібних, і богів золотих не робити мете собі. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Жертівника з землї спорудиш менї, і приносити меш всепалення твої, і мирні жертви твої, і дрібну скотину твою і воли твої; на всякому врочищі, де поставлю память іменї мого, приходити му до тебе й благословляти му тебе. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Коли ж із каменя споруджувати меш менї жертівника, не споруджуй із тесаного каменя; бо різцем твоїм ти махнеш над їм, та й опоганиш його. ");
INSERT INTO ukr1871_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Тако ж не сходити меш по сходах до жертівника мого, щоб не відкрилась над ним нагота твоя. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","А се суди, що обявиш перед ними: ");
INSERT INTO ukr1871_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Коли купиш раба Єврея, шість год нехай прослужить, а на семий вийде на волю, дармо. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Коли сам прийде до тебе, сам і на волю вийде, коли ж він мав жінку, і жінка його вийде з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Коли пан його дав йому жінку, та вродила вона йому сини й дочки, дак жінка і дїти її будуть панові, він же вийде сам один. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Коли ж казати ме раб: Люблю я пана, жінку мою і дїти мої, не хочу виходити сам на волю; ");
INSERT INTO ukr1871_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Тодї приведе його пан його до суддїв і поставить коло дверей або одвірка та й проколе пан його вухо йому шилом, і служити ме той йому до віку. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","А коли хто продасть дочку свою як рабиню, дак не виходити ме вона, як виходять раби. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","І коли не до вподоби вона панові свойму, що призначив її для себе, дак нехай дозволить її викупити: народові чужому не мати ме права продавати її, він бо ошукав її. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","А коли синові свойму призначив її, дак по праву дочки мусить чинить із нею. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Коли ж другу візьме йому, не мати ме права поменьшити харч її, платтє її, і мужне життє її. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","А коли б сї три речі не додержав, дак можна ій вийти дармо без окупу. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Хто вдарить чоловіка так, що той умре, скарати його смертю. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Коли ж він зробив се ненароком, а Бог підвів під його руку, дак я призначу тобі місто, куди втекти йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","А хто задумав на близьного свого душогубство зрадливим робом, і від жертівника мого мусиш узяти його, щоб скарати смертю. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","І хто вдарить батька свого, смертю скарати його. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","І хто вкраде людину та продасть, або знайдеться вона в руках його, того скарати смертю. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","І хто проклинати ме батька свого і матїр свою, того скарати смертю. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","І коли посваряться люде, та й вдарить одно одного каменюкою чи кулаком, і той не вмре, а лежати ме в недузї: ");
INSERT INTO ukr1871_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Коли встане і ходити ме з палицею своєю, дак шкодника вивязати з сієї справи; тільки має за втрату часу заплатити і вигоїти його зовсїм. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Коли хто вдарить раба чи рабиню свою палицею, і вмре під його рукою, притма треба відомстити за се. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Однакже, коли день або два проживе, дак не годиться мститись; бо він за його гроші. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","І коли сваряться чоловіки, та потурбують вагітну молодицю, і скине дитину вона, та не буде шкоди, наложити на виноватого пеню, яку наложить жінчин чоловік, і заплатить по присудї суддїв. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","А коли буде шкода, тодї мусить оддати душу за душу. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Око за око, зуба за зуба. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Опечину за опечину, рану за рану, синяка за синяка. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","І коли хто вдарить в око раба свого, чи в око рабиню свою, і зопсує, на волю мусить випустить його за око його. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","І коли вибє зуба рабові свойму, або рабинї своїй, на волю випустить його за зуба його. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","І коли вколе скотина мужчину чи женьщину й умре, каміннєм побити мусять скотину та й не їсти муть мясива її; чия ж скотина той неповинен. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","А коли віл бився перше і осьвідчено було господареві його, та не вберіг він його, і вмер мужчина чи женщина, вола мусять побити каміннєм, і господарь його мусить згинути. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Коли наложять викуп на його, мусить він дати за визвол душі своєї, щоб нї положено на його. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Чи сина заколе він, чи дочку заколе, по сьому присуду чинити з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Коли ж раба чи рабиню вбє скотина, мусить дати властитель срібла трийцять секлїв панові, а скотину вбити каміннєм. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","А коли розкриє хто яму, або викопає хто яму, та й не закриє, і впаде туди віл чи осел, ");
INSERT INTO ukr1871_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Властитель ями заплатить за се; вернути мусить він грошима господареві його, а мертве буде йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","А коли чия скотина поранить скотину другого, і та здохне, дак продадуть скотину живу, та й подїлять по полам гроші за її, та й здохлу пополам подїлять. ");
INSERT INTO ukr1871_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Коли ж було знаттє, що віл бився перше, і не вберіг його господарь його, дак мусить віддати вола за вола, мертвий же йому буде. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Коли хто вкраде вола, чи дрібну скотину та й убє її, чи продасть її, пять волів мусить віддати за вола і чотири скотин за одну штуку. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Коли захоплять злодїя, як вломився, і побють так, що вмре, то се не буде крівавою провиною. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Коли ж тодї вже соньце сьвітило, дак се буде крівава провина. Злодїй мусить заплатити; коли ж нїчого нема в його, мусять його, за кражу його продати. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Коли вкрадене, чи то буде віл, чи осел, чи мала скотина, живим у його знайдуть, мусить він за кожне ще другу животину дати. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Коли хто чуже поле чи виноградник випасувати ме, а скотину свою пускати ме пустопаш, і воно на чужому полї що поїсть, дак мусить він віддати за се найлучче з поля свого чи з виноградника свого. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Коли загориться багаттє й обійме тернину, а при тому погорять копи, чи на пни стояче колоссє, чи усе поле вигорить, дак мусить той, що через його сталась пожежа, за попалене заплатити. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Коли хто другому передасть у схованку гроші, чи дорогі речі, і те буде вкрадене в його, мусить злодїй, коли знайдеться, заплатити удвоє за окражу; ");
INSERT INTO ukr1871_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Коли ж злодїй не знайдеться, дак мусить власник дому того прийти перед суддїв та й заприсягти, що не загарбав чужої власностї. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","При кожному спроневіренню власностї, чи то буде віл, чи осел, чи малий скот, чи одежина, чи яка инша втрата, про котру хто скаже: „Ось воно‟, мусить прийти перед суддїв слово обох, і той, кого суддї узнають винним, мусить заплатити близьньому удвоє. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Коли хто передасть другому на перехованнє осла, чи вола, чи малого скота, чи всяку иншу животину, і воно здохне, чи буде пошкоджене, або украдене і нїхто не бачив, ");
INSERT INTO ukr1871_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Дак мусить присяга перед Господом розвязати справу, чи не посягнув він рукою на власність свого близьнього; коли власник се прийме, не мусить нїчого той платити. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Коли справдї вкрадено йому, дак мусить заплатити власникові. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Коли ж дикий зьвіряка роздер його, і він се явним доказом доведе, не треба йому нїчого за роздерте платити. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Коли хто вижичить у другого скотину, і вона буде пошкоджена, чи здохне, так що власника його не було при тому, мусить він тому заплатити. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Коли ж власник та був при тому, не треба йому платити нїчого. Коли дана була в найми, то нехай буде за умовлену цїну. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Коли хто зведе з ума дівицю, що не була ще заручена, та й лежати ме з нею, мусить дати ій віно і взяти собі її за жінку. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Коли ж отець її затнеться віддати йому за жінку, дак мусить він стільки срібла одважити, скільки дається як віно дївицї. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Не зоставляй відьми живою. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Кожного, що злїгсь із скотиною, смертю карати меш. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Хто замість Господа приносить жертву ідолам, мусить бути прогнаний. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Не тїснити меш чуженицї і не гнобити меш його; були бо ви чуженицями в Египецькій землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Удови нїяким робом не тїснити меш, анї сироти. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Бо коли їх тїснити меш, і вони заголосять до мене, дак я певно голос їх почую. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","І загориться гнїв мій і попущу побити вас мечем, так що жінки ваші будуть удовами, а дїти сиротами. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Коли даси грошей кому з людей моїх убогому, що при тобі живе, не мусиш ти бути йому пожичальником, не наложиш на його чиншу. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Коли візьмеш у заклад свиту в близнього твого, мусиш вернути йому її до заходу соньця; ");
INSERT INTO ukr1871_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Бо се одна, тільки й одежи його, свитка про шкіру його; у чому ж лягти йому? І як заголосить до мене, почую плач його; бо я милосерден. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Не лаяти меш суддїв, і не проклинати меш князя народу твого. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Від достатків збіжа твого і випливу точива твого не гаяти мешся приносити в жертву. Первенця з дїтей твоїх оддавати меш менї. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Так робити меш з волом і з малим скотом; сїм день буде воно при матері своїй, а восьмого дня даси його менї. ");
INSERT INTO ukr1871_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","І люде сьвяті будете ви менї, і мясива в полї роздертого не їсти мете; собацї кидати мете його. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Не розносити меш пустої чутки; не покладати меш руки своєї з беззаконником, щоб сьвідкувати насильство. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Не ходити меш слїдом за многими ради ледарства, і не відказувати меш на судї, намагаючись за купою відхилити правду. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","І вбогого не закрашувати меш у позиванню його. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Коли спіткаєш вола ворога твого, чи осла його, що блукає, мусиш його вернути йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Коли побачиш осла ненавидника твого, що лежить під своїм тягарем, остерегайсь покинути його з ним; розсїдлай його з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Не кривити меш правди убогому на судї його. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Удержуйся від льживого слова; нї безвинного, нї праведного не вбивай; я бо не оправдаю беззаконника. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","І дарунків не брати меш; дарунок бо заслїплює видющих і перевертає слова справедливих. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","І чуженицю не тїснити меш; ви самі знаєте, як на душі в чуженицї: були бо чуженицями в Египецькій землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","І засївати меш шість років землю твою, і збирати меш уроджай її; ");
INSERT INTO ukr1871_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","На семий же мусиш покинути її на толоку і даси полежати, щоб харчитись убогим ізміж людей твоїх, а що вони покинуть, нехай поїдає животина польова. Так само чинити меш і з виноградником твоїм, і з оливною деревиною твоєю. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Шість день робити меш дїло твоє, семого ж дня відпочинеш, щоб оддихав і віл твій і осел твій, і щоб оддихнули на волї син рабинї твоєї і чужинець. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","А в усьому, що я глаголав вам, бувайте обачні; ба й імям богів чужих не згадуйте, нехай не чути муть його з ваших уст. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Тричі сьвяткувати мете менї що року. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Допильновувати меш опрісношнього сьвята. Сїм день їсти меш прісний хлїб, як я заповідав тобі, в призначений час, у місяцї Абибі; бо в цьому місяцї вийшов єси з Египту. І нїхто не мусить показуватись перед лице моє з порожнїми руками. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","І сьвято жнивне, первоплоду працї твоєї, того, що сіяти меш в полї; і сьвято збору, під кінець року, як збираєш те, коло чого працював у полї. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Тричі що року мусить показуватись увесь музький пол твій перед Господа Бога твого. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Не приносити меш з квашеним хлїбом кров жертви моєї; і не зоставати меться жир сьвята мого до ранку. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Первоплід із землї твоєї мусиш приносити в дом Господа, Бога твого. Не варити меш козеняти в молоцї матері його. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Се я посилаю мого ангела перед тобою, щоб оберегав тебе в дорозї і привів тебе до того міста, що наготовив я про тебе. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Остерегайся лиця його й слухай голосу його, не становись опором проти його; не стерпить бо він ваших переступів; бо на йому імя моє. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Коли ж слухати меш голосу його й чинити меш усе, що я глаголю, тодї буду ворогом ворогам твоїм і сопротивлюся сопротивникам твоїм. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ійти ме бо ангел мій поперед тебе і приведе тебе до Аморіїв і Гетіїв і Фересіїв і Канааніїв і Гевіїв і Євусіїв; і повикорінюю їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Не бити меш поклони богам їх і не служити меш їм, і не ходити меш робом їх, нї; до на щаду руйнувати меш їх і розбивати меш стовпи їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","А служити мете ви Господеві, Богу вашому, і благословляти ме хлїб твій й воду твою, і видалю я недугу зміж вас; ");
INSERT INTO ukr1871_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Не скидати муть у вас і не буде безплодних в землї твоій; і лїчбу днїв твоїх виповню. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Страх мій пошлю поперед тебе, і залякаю всї народи, куди прийдеш, і поверну всї вороги твої потилицею до тебе. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","І пошлю рога поперед тебе, і повиганяють вони Гевіїв, Канааніїв, і Гетіїв зперед тебе. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Не за один рік їх повиганяю зперед тебе, щоб не спустїла земля та не намножилось у нїй животини польової. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Спокволя виганяти му їх зперед тебе, докіль осядешся ти да внаслїдуєш землю. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","І поставлю гряницї твої від Червоного моря та й до моря Филистимського, і від пустинї до Ефрату, бо віддам в руки твої людей землї, щоб прогнав їх зперед тебе. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Не чинити меш умови з ними й з богами їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Нехай не живуть вони в землї твоїй, щоб не доводили тебе до гріха; бо ти служив би богам їх, бо се було б для тебе сїткою. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","І рече Мойсейові: Зійди на гору до Господа, ти да Арон, Надаб та Абигуй, та сїмдесять старших мужів Ізраїльських, та поприпадайте ниць оддалеки. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","І тільки Мойсей приступить до Господа, а вони не приступлять, і люде нехай не сходять на гору з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","І прийшов Мойсей і повідав людям усї слова Господнї і всї суди: і відказав увесь люд в один голос: Усї слова, що глаголав Господь, певнити мемо. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","І написав Мойсей всї слова Господнї, і встав рано враньцї, і спорудив жертівника під горою, та дванайцять стовпів по дванайцяти колїнах Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","І послав молодики зміж синів Ізрайлевих, і вознесли вони всепалення і принесли телята як жертви подячні Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","І взяв Мойсей половину крові й улив її в миски, і вибризкав половину крові на жертівник. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","І взяв книгу завіту, та й прочитав на слух людям, і мовляли вони: Усе, що глаголав Господь, певнити мемо і слухати мемо. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","І взяв Мойсей кров та й побризкав на людей, і рече: Се кров завіту, що вчинив Господь із нами у всїх сих словах. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","І знявсь Мойсей та Арон, Надаб та Абигуй, і сїмдесять старших мужів в Ізраїлї; ");
INSERT INTO ukr1871_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","І побачили вони Бога Ізрайлевого; а під ногами в його наче поміст із сафирих плит, і мов небо само, такого сяєва. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Та на вибраних синів Ізрайлевих не простїг він руки своєї; і бачали вони Бога, та їли й пили. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","І рече Господь Мойсейові: Зійди до мене на гору і бувай тамо; і дам тобі таблицї камяні, і закон і заповідї, що написав я на науку їм. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","І встав Мойсей та Йозуа, слуга його, і пійшов Мойсей на гору до Бога. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","А старшим зміж громадян рече: Зоставайтесь тутеньки за нас, покіль вернемось до вас, і се Аарон і Гур із вами. Кому що треба, нехай до них приступить. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","І зійшов Мойсей на гору, і вкрила гору хмара. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","І почивала на Синай горі слава Господня, і вкривала її хмара шість день. І кликне до Мойсея в день семий із хмари. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","А ява слави Господньої була наче пожираюче поломя на верху гори в очу синів Ізрайлевих. І ввійшов Мойсей у середину хмари, і знявся на гору. ");
INSERT INTO ukr1871_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","І був Мойсей на горі сорок день і сорок ночей. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Промов до синів Ізрайлевих, щоб вони приносили менї приноси; від усякої людини, що прихиляється серцем своїм, брати мете приноси мої. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","І ось які приноси маєте приймати від них: золото й срібло й мідь, ");
INSERT INTO ukr1871_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","І блакит і порфиру і кармазин двоистий, і виссон і козину шерсть. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","І на червоно закрашені баранячі смушки, і шкіри барсучі і дерево-акацію; ");
INSERT INTO ukr1871_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Олїй на сьвітло, коріння для миропомазання і пахощі на кадило. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Каміннє ониксове, і каміннє вставне на поплїчник ефод і на нагрудник. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","І спорудять менї вони сьвятиню, щоб менї можна було витати серед них. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Усе, як сам я показую тобі, взір домівки і взір усього знаряддя їх, так і мусите поробити. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","І зроблять вони скриню із дерева акациї: два ліктї з половиною завдовжки, і локіть з половиню завширшки, і локіть з половиною заввишки. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","І виложиш її щирим золотом; з середини й знадвору виложиш її, і обведеш її кругом золотою лиштовкою. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","І виллєш чотири каблучки із золота та й поприроблюєш їх по чотирох углах її: дві каблучки з одного боку її, а дві каблучки з другого боку. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","І поробиш носила з дерева акациї та й пообкладуєш їх золотом. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","І повсовуєш носила в каблучки з боків скринї, щоб носити скриню на їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","В каблучках у скринї мусять бути носила, не треба їх виймати. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","І положиш у скриню сьвідоцтво, що я дам тобі. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","І зробиш віко з золота щирого, два ліктї з половиною завдовжки і локіть з половиною завширшки. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","І зробиш два херуби золоті, кованим дїлом зробиш їх, по обох кінцях віка на скринї. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","І зроби одного херуба з одного кінця, а другого херуба з другого кінця; одноцїльно з віком поробите ви херуби по обох кінцях його. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","І простягати муть херуби крила вгорі, покриваючи крильми своїми віко, а лиця їх одно до одного, над віком будуть похилені лиця херубимів. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","І поставиш віко на скринї зверху, а в скриню мусиш положити сьвідоцтво, що дам його тобі. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","І сходити мусь з тобою тамо, і глаголати му до тебе з віка і спроміж двох херубів, що над скринею сьвідчення, що треба заповідати тобі про Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","І зробиш стола з дерева акациєвого, два ліктї завдовжки, а локіть завширшки, а локіть з половиною заввишки. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","І виложиш його золотом щирим, і зробиш на його вінець золотий з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","І зробиш до його лиштву в долоню завширшки з усїх боків, і зробиш вінець золотий до лиштви з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","І зробиш до його чотири каблучки золоті, та й поприроблюєш каблучки по чотирох ріжках коло чотирох ніг його. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Коло лиштви мусять каблучки бути місцями до носил, щоб носити його. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","І поробиш носила з дерева акацієвого, та й пообкладуєш золотом, щоб носити на їх стола. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","І поробиш полумиски до його, і черпаки до його, і кінви до його, і кубки до його до возливання; із золота щирого поробиш їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","І покладати меш на столї показний хлїб перед моє лице повсячасно. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","І зробиш сьвітильника із золота щирого; кованої роботи зробиш сьвітильника, ніжки його і держало його; і чашечки його, і пуплянки його, й квітки його одноцїльні мусять бути. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","І виходити муть шість віток із боків його, і три вітки в сьвітильнику з одного боку, і три вітки в сьвітильнику з другого боку. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Три чашечки як цьвіт микдаловий: пуплянок і квітка на вітцї одній, і три чашечки як цьвіт микдаловий на вітцї другій; так же само й на шестьох вітках, що виходять із сьвітильника. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","А на сьвітильнику чотири чашечки, як цьвіт микдаловий, пуплянки їх і квітки їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","І пуплянок під двома вітками в його, і пуплянок під двома вітками в його, і знов пуплянок під двома вітками в його, про шість вітки, що виходять із сьвітильника. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Пуплянки в їх і вітки в їх мусять бути усї одної кованої роботи з золота щирого. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","І зробиш сїм його лямп; як розсьвітять на йому лямпи, дак щоб сьвітили на переднїй бік його. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","А щипцї до його й качапчики до його з золота щирого. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Із таланта золота щирого уробиш його з усїм знаряддєм його. ");
INSERT INTO ukr1871_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","І гледи, щоб зробити після взору, що показано тобі на горі. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Храмину зробиш із десятьох келїмів; з тонкої нитяної тканини, і з блакиту і пурпуру і кармазину, з херубами, майстерно тканими. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Завдовжки один келїм двайцять вісїм локот, а чотири ліктї завширшки; міра одна для всїх келїмів. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Будуть поспинані пять калїми один до одного, і знов пять келїми будуть поспинані один до одного. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","І поробиш петельки з блакиту по бережках одного келїма, де спинати муться їх бережки, і по бережках другого келїма, де спинати муться їх бережки. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Пятьдесять петельок мусиш зробити на одному келїмі і пятьдесять петельок зробиш на другому келїмі, де спинати муться їх бережки. Петельки будуть одна проти однієї. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","І зробиш пятьдесять запинок золотих, та й поспинаєш келїми одного з другим золотими запинками, і зробиться храмина суцїльна. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","І поробиш коври з козиної шерсти для намету, що буде в йому храмина, одинайцять коврів зробиш. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Один ковер завдовжки трийцять локот, а чотири ліктї завширшки. Міра одна для всїх одинайцяти коврів. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","І поспинаєш пять коврів окроме, і шість коврів окроме, і згорнеш удвоє ковра шестого спереду в наметї. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","І зробиш пятьдесять петельок по бережках ковра одного, де вони спинати муться і пятьдесять петельок по бережках ковра другого, де спинати муться. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","І зробиш запинок мідяних пятьдесять та й повсовуєш запинки в петельки, і поспинаєш намета так, що він буде суцїльний. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","А зайвину в коврах наметових, половина ковра, що зістанеться, нехай висить ззаду храмини. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","А локіть з того і локіть з другого боку зайвини в довжинї наметових опін висїти ме по боках в храминї з одного й другого боку, щоб окривати його. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","І поробиш покривала до намету з баранячих шкір викрашених червоно, а покривала з шкір барсучих зверху. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","І поробиш дошки для храмини з дерева акацієвого так, щоб просто стояли: ");
INSERT INTO ukr1871_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Десять локоть довжина однієї дошки, і локіть з половиною ширина однієї дошки. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Два чопи в однїй дошцї, один проти одного споїний; так само поробиш на всїх дошках храмини. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","І зробиш дощок до храмини: двайцять дощок на полуденному боцї, на полуднє; ");
INSERT INTO ukr1871_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","І сорок срібних ніжок зробиш під двайцять дощок: дві ніжки під одну дошку до обох чопів її, і дві ніжки під другу дошку до обох чопів її. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","І до другого боку храмини, на північньому боцї: двайцять дощок. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","І сорок ніжок срібних: дві ніжки під одну дошку, і дві ніжки під другу дошку. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","А на задньому боцї храмини, на захід соньця, зробиш пять дощок. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","І дві дошки зробиш на обидва кутки в храминї на задньому боцї; ");
INSERT INTO ukr1871_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","І будуть вони подвійні з низу до гори, і будуть вони в горі вкупі в однїй каблучцї; так мусять бути обі; на двох кутках будуть вони. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","А всїх дощок буде ззаду вісїм дощок, а ніжок срібних шіснайцять ніжок: дві ніжки під однією дошкою і дві ніжки під другою дошкою. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","І поробиш засуви з дерева акацїєвого: Пять засувів до дощок, на одному боцї в храминї, ");
INSERT INTO ukr1871_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","І пять засувів до дощок, на другому боцї в храминї, і пять засувів до дощок на задньому боцї в храминї до заходу соньця; ");
INSERT INTO ukr1871_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Середнїй же засув проходити ме посеред дощок від одного кіньця до другого. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","А дошки мусиш пообкладувати золотом; і каблучки в їх, до всовування засувів, поробиш золоті, і пообкладуєш засуви золотом. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","І вистроїш храмину по взірцю, що показано тобі на горі. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","І зробиш завісу із блавату і пурпуру і кармазину та й із нитяної тканини; майстерно ткану з херубимами щоб зроблено її. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","І повісиш її на чотирох стовпах із акації, пообкладуваних золотом, гаки їх із золота, і на чотирох підніжках срібних. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","І повісиш завісу під трома гаками; і внесеш туди, за завісу, скриню сьвідчення. І буде роздїляти завіса вам сьвятиню від пресьвятої сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","І положиш віко на скриню сьвідчення в пресьвятій сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","І поставиш стола з надвору завіси, а сьвітильника проти стола з того боку храмини, що на полуднє; а стола поставиш з того боку, що на північ. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","І зробиш опону над входом до намету із блавату і пурпуру і кармазину і нитяного полотна, мереженої роботи. ");
INSERT INTO ukr1871_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","І зробиш для опони пять стовпів із акацієвого дерева, і пообкладуєш їх золотом, і золлєш до них пять підставок мідяних. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","І построїш ти жертівника із дерева акацієвого, пять локоть завдовжки й пять локоть завширшки. Четверокутнїм мусить бути жертівник і три ліктї заввишки. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","І поробиш роги його по чотирох краях його; будуть одноцїльні з ним роги його, і пообкладуєш їх міддю. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","І поробиш казани, щоб вибирати попіл з його, і кочерги до його, і макітри його до бризкання, і гаки його, і курильницї до його; все знаряддє до його поробиш із мідї. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","І зробиш до його грати мідяні плетеної роботи, і поробиш до плетїнки чотири каблучки мідяні, по чотирох углах її. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","І положиш її під краї жертівника, в низу, і сягати ме плетїнка до половини жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","І поробиш носила до жертівника із дерева акацієвого, і пообкладуєш їх міддю, ");
INSERT INTO ukr1871_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","І повсовуються носила в каблучки, щоб були по двох боках жертівника, як нести муть його. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Зробиш його з дощок, в серединї порожнього; як показано тобі на горі, так нехай і зроблять його. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","І зробиш двір до храмини: на полуденньому боцї, на полуднє, опони до двора із тонкого полотна, сто локоть завдовжки на одному боцї. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","І двайцять стовпів його і двайцять піднижків із мідї, гаки на стовпах і ощепини із срібла. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Так само й на північньому боцї, вздовж: опони сто локоть; і стовпів його двайцять і піднижків їх двайцять із мідї, гаки на стовпах і ощепини до їх із срібла. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ширина ж двора на захід соньця: Опон пятьдесять локот, стовпів до них десять і підніжків до них десять. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","І ширина двора на східному боцї, на схід сонця, пятьдесять локот: ");
INSERT INTO ukr1871_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Пятнайцять локот опон на одному боцї, стовпів до них три і підніжків до них три. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","І на другому боцї пятнайцять локот опон, стовпів до них три і підніжків до них три. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","А до воріт двора закривало двайцять локот завдовжки з блавату і пурпуру і кармазину і нитяного полотна мережаної роботи та стовпів до них чотири і підніжків до них чотири. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Усї стовпи в дворі з ощепинами будуть срібні, гаки до них срібні, підніжки ж мідяні. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Довжина двору сто локот, а ширина пятьдесять проти пятьдесять, вижина ж пять локот, із нитяного полотна; а підніжки до них мідяні. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Вся посудина в храминї на всяку потріб, і все кіллє його, і все кіллє в дворі, мідяні. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","І повелиш синам Ізрайлевим принести тобі олїї оливної вибитої про сьвітло, щоб засьвічувано раз у раз лямпи. ");
INSERT INTO ukr1871_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","В наметї громадському, знадвору завіси, що перед сьвідченнєм, ставляти муть їх Арон і синове його, з вечора та й до ранку, перед Господом. Установа на віки з роду та й до роду в синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ти ж велиш приступити до себе Аронові, братові свому і синам його, зміж дїтей Ізрайля, щоб служив менї сьвященником: Арон, Надаб і Абигу, Єлеазар та Ітамар, сини Аронові. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","І посправляєш ти шати сьвященні Аронові, братові свойму, на славу і на окрасу. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","І мовляти меш усїм премудрим у серцї, кого я сповнив духом премудростї, щоб вони поробили шати Аронові, на осьвяту його, щоб служив менї службу сьвященну. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","І ось які шати нехай пороблять йому: нагрудник і наплїчник, і верхню шату і хитон мережаний, та кедар і пояс. І пороблять вони шати сьвященні Аронові, брату твойму, та синам його, щоб служив менї службу сьвященну. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","І нехай візьмуть золота й блавату і пурпуру й кармазину і тонкого нитяного полотна, ");
INSERT INTO ukr1871_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","І зроблять вони наплїчника із золота й блавату, пурпуру й кармазину і з нитяного полотна майстерним робом тканого. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","У його мають бути на обох кінцях його два нарамники до звязання, щоб так був звязаний. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","І пояс у наплїчника, що буде на йому, буде такої ж роботи, одної з ним тканї: із золота й блавату, і пурпуру й кармазину, і з тонкого нитяного полотна. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","І візьмеш два ониксових каменїв, та й повирізуєш на їх імена синів Ізрайлевих: ");
INSERT INTO ukr1871_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Шість імен їх на одному каменї, і шість других імен на другому каменї, по черзї народження їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Робом ріжчика, як вирізують печатку, повирізуєш на двох каменях імена синів Ізрайлевих; оправу золоту поробиш до них. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","І положиш два каменї на нарамники наплїчника як каміннє на спомин синам Ізрайлевим, і носити ме Арон імена їх перед Господом на обох раменах своїх про спомин. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","І зробиш дві оправи золоті; ");
INSERT INTO ukr1871_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","І два ланцюхи щиро золоті: Як шнурки поробиш їх сплївши, та й попричіплюєш плетені ланцюхи до оправи. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","І зробиш нагрудника судового робом майстерським, таким робом, як наплїчника зробиш його: із золота, блавату й пурпуру та кармазину, та тонкої нитяної тканини зробиш його. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Четверокутний він буде, двоїстий, пядь завдовжки і пядь завширшки. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","І понасаджуєш на йому оправлене каміння, чотири ряди каміння; один ряд: Сардїй, топаз і смарагд, ряд первий; ");
INSERT INTO ukr1871_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","А другий ряд: Гранат, сафір і диямант; ");
INSERT INTO ukr1871_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","А ряд третїй: Опаль, ахат і аметист; ");
INSERT INTO ukr1871_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","А четвертий ряд: Хризолїт і оникс і яспіс; оправлені в золото будуть вони в своїх кубельцях. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","І будуть каменї по іменам синів Ізрайлевих, дванайцять по іменам їх; вирізані як печатка, кожен з імям своїм буде, по дванайцяти колїнам. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","І поробиш на нагруднику ланьцюжки як шнурки плетені, із щирого золота. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","І зробиш на нагруднику дві каблучки золоті, і причіпиш дві каблучки до двох кінцїв нагрудника. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","І привяжеш два шнурки золоті до двох каблучок по кіньцях нагрудника. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Обидва ж другі кіньцї двох плетених шнурків привяжеш до двох оправок, і привяжеш їх до нарамників наплїчника, спереду його. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","І зробиш дві каблучки золоті та й причіпиш їх до двох кіньцїв нагрудника, до рубця його, що проти наплїчника, на виворітнїй сторонї. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","І зробиш дві каблучки золоті і причіпиш до обох нарамників наплїчника знизу, з лицьового боку його, де звязується над мережаним поясом наплїчника. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","І привязувати муть нагрудника каблучками його до каблучок наплїчника шнурками блаватовими, щоб він був над мережаним поясом наплїчника, і щоб не зсувався нагрудник з наплїчника. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","І носити ме Арон імена синів Ізрайлевих в судньому нагруднику на серцї свойму, як приходить у сьвятиню, на вічний спомин перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","У нагрудник же положиш урім і туммім, щоб вони були на серцї в Арона, як приходить він перед Господа, і носити ме Арон суд синів Ізрайлевих на серцї свойму перед Господом по всякий час. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","І зробиш верхню шату до наплїчника всю з блавату. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","І буде в неї отвір для голови посерединї; буде навкруги роспірки тої облямовано обшивкою тканої роботи; як отвір панцера буде в неї, щоб не рвалась. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","І поробиш по краях її гранатові яблучка з блавату і пурпуру й кармазину, навкруги краю її, і дзвінки золоті проміж ними з усїх боків: ");
INSERT INTO ukr1871_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Дзвоник золотий і граната, дзвоник золотий і граната, по рубцю в верхньої шати з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","І буде вона на Аронові, як треба йому службу служити, і чути буде дзвоненнє їх, як входити ме в сьвятиню перед Господа, і як виходити ме, щоб не вмерти йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","І зробиш бляху із щирого золота, і виріжеш на їй, як вирізують печатку: Сьвятиня Господеві! ");
INSERT INTO ukr1871_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","І привяжеш її до блаватового шнурка, щоб вона була привязана до кедара; спереду кедара нехай буде вона. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","І буде вона в Арона на чолї і носити ме Арон несправедливість сьвятих річей, що посьвячувати муть синове Ізрайлеві в усїх їх дарах сьвятих. По всякий час нехай вона буде на чолї в його, для благоволення їм перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","І зробиш хитон з білого полотна, і зробиш пояса із білого полотна. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","І синам Ароновим поробиш хитони і поробиш їм пояси, і клобуки поробиш їм про славу й окрасу. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","І вдягнеш Арона, брата твого, і сини його з ним, і помажеш їх, і приручиш їм усе, і осьвятиш їх, і служити муть вони менї сьвященниками. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","І поробиш їм льняні спідні шати, прикривати наготу тїла їх; від бедер до стеген сягати муть. ");
INSERT INTO ukr1871_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","І надївати муть їх Арон і синове його, як увіходити муть у громадянський намет, або як наближувати муться до жертівника, служачи в сьвятинї, щоб не провинили та й не померли: Віковічня установа про його й про насїннє його. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","І ось що мусиш чинити з ними, щоб їх посьвятити в сьвященники менї: Возьми бичка одного та два барани, без пороку. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Та опрісноків і незаквашених коржиків, змішаних з оливою, та ладок незаквашених, оливою помазаних: з питльованої муки пшеничної поробиш їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","І положиш їх у кошик, і принесеш у кошику, ведучи бика і два барани. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Арона ж і сини його приведеш до входу громадянського намету та й пообмиваєш їх водою. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","І візьмеш шати та й надїнеш на Арона хитон і верхню шату до наплїчника, і наплїчника, і нагрудника, та й привяжеш йому наплїчника мережаним поясом наплїчника. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","І возложиш йому на голову кедар, і надїнеш диядему сьвятинї на кедар. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","І возьмеш миро, та й золлєш на голову йому і помажеш його. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","І сини його приведеш, і понадїваєш на їх хитони. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","І попідперізуєш їх поясами, Арона й сини його, і понакладаєш клобуки на їх, і буде ім сьвященство установою вічною; і приручиш усе Аронові та синам його. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","І приведеш бичка на жертву перед громадянський намет, і возложить Арон і сини його руки свої на голову бичкові. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","І заколеш бичка перед Господом коло входу до громадянського намету. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","І возьмеш телячої крові та положиш на роги жертівника пучкою твоєю, а всю кров виллєш до підніжка жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","І возьмеш увесь жир, що вкриває тельбухи, та чепець над печінкою, та обидві нирки і жир, що кругом них, та й пустиш димом на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","А мясиво теляче і шкіру його і кал його спалиш на вогнї за табором: се за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","І барана одного теж возьмеш. І возложать Арон та сини його руки свої на голову баранові. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","І заколеш барана та й возьмеш крові його та й побризкаєш на жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","А барана розіймеш на частини, і виполощеш тельбухи його й ноги його, та й положиш до частин його й до голови його. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","І цїлого барана пустиш димом на жертівнику: Се всепаленнє Господеві, пахощі любі; огняна жертва Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","І возьмеш барана другого, і возложить Арон та сини його руки свої на голову баранові. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","І заколеш барана, і возьмеш крові його й положиш на край правого вуха Арона і на край правого вуха синів його, і на великий палець правих рук їх, і на великий палець на правих ногах їх, і побризкаєш кровю на жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","І возьмеш крові, що на жертівнику, та мира, та й побризкаєш на Арона й на одїж його, на синів його і на одїж синів його з ним; і буде він сьвятий і шати його, і сини його і шати синів його з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","І возьмеш од барана жир та курдюк, і жир, що вкриває тельбухи, та чепець від печінки й обидві нирки і жир, що кругом них, і праву литку — бо се баран посьвятний. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Та бохонець хлїба один, та мазану паленицю одну, і ладку одну із кошика прісного хлїба, що перед Господом; ");
INSERT INTO ukr1871_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","І положиш усе те на руки Аронові і на руки синів його, і принесеш жертву гойдану перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","І возьмеш те з рук їх, та й пустиш димом на жертівнику опріч всепалення, на любі пахощі перед Господом. Се огняна жертва Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","І возьмеш ти груди з барана, що про Арона, і принесеш як гойдану жертву перед Господом; і буде вона частиною тобі. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","І осьвятиш грудину гойданої жертви і литку піднесеної жертви від барана посьвятного, з того, що про Арона, і з того, що про синів його; ");
INSERT INTO ukr1871_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","І буде Аронові й дїтям його доходом від синів Ізрайлевих, бо се жертва підношення; а мусить бути жертва підношення від синів Ізрайлевих, від їх жертов примирення: їх жертва підношення Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","А сьвяті шати, що в Арона, будуть його дїтям по йому, щоб їх помазувано в їх, і висьвячувано їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Сїм день надївати ме їх син його, котрий буде послї його сьвященником, котрий увийде у громадський намет, щоб служити в сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","А барана сьвяченого возьмеш і звариш мясиво його в сьвятому місцї. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","І їсти муть Арон і сини його мясиво бараняче й хлїб, що в кошику, коло входу в громадський намет. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","І їсти муть вони те, чим покутовано гріхи, на прирученнє їм сьвященства, щоб їх висьвятити; чужий же не їсти ме; бо се сьвяте. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","І коли зостанеться що до ранку од мясива посьвятного й від хлїба, мусиш спалити останок огнем. Не їсти меш; бо се сьвяте. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","І поробиш Аронові й синам його все так, як я заповідав: сїм день висьвячувати меш їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","А теля на гріхову покуту приноситимеш щодня, і очистиш жертівника, зробивши покуту; та помажеш його, щоб посьвятити його. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Сїм день покутувати меш про жертівника і сьвятити меш його; і зробиться жертівник сьвятинею над сьвятинями: хто доторкнеться до жертівника, буде сьвятий. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","От що приносити меш на жертівнику: двоє ягнят перволїтків, день в день, повсячасно. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Перве ягня приносити меш у раньцї, а ягня друге приносити меш між двома вечорами. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Та десятину питльованої муки, змішаної з четвертиною гіна забиваної олїї, і ливну жертву четвертину гіна вина, до первого ягняти. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","А друге ягня приносити меш між двома вечорами; як дар ранїшний і як ливну жертву його, так жертвувати меш про любі пахощі, огняну жертву Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Се мусить бути жертва всепалення повсячасно в роди ваші, коло входу в громадський намет, перед Господом, де зустрічати мусь із вами, щоб розмовляти з тобою тамо. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","І сходити мусь тамо з синами Ізрайлевими, і сьвятити меться намет сьвятостю моєю. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","І осьвячу громадського намета й жертівника; Арона ж і синів його посьвячу, щоб служили менї сьвященниками. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","І витати му між синами Ізрайлевими і буду їм Богом. ");
INSERT INTO ukr1871_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","І зрозуміють вони, що я Господь, Бог їх, що вивів їх із Египецької землї, щоб витати менї проміж їх; я Господь, Бог їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","І построїш менї жертівника на куреннє кадильне; з дерева акацієвого зробиш його. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Локіть завдовжки він і локіть завширшки, четверокутний він буде, і два ліктї заввишки; і роги його одноцїльні з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","І обложиш його щирим золотом верх його, всї боки його і роги його. І зробиш до його вінець золотий навкруги. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","І дві каблучки золоті зробиш до його під вінцем його. По обох боках його поробиш їх, і будуть вони про жердки, щоб носити його ними. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","І поробиш носила з дерева акацієвого, та й пообкладуєш їх золотом. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","І постановиш його проти завіси, се єсть перед скринею сьвідчення і проти віка, що над сьвідченнєм, і де буду сходитись з тобою. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","І кадити ме Арон кадилом на йому з ранку до ранку; як понаготовляє лямпи, мусить кадити; ");
INSERT INTO ukr1871_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","І як запалює Арон лямпи між двома вечорами, мусить кадити; вічне кадило перед Господом в роди ваші. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Не приносити мете на його кадил чужих, нї всепалення, нї приносів; і поливальної жертви не лити мете на його. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","І покуту робити ме Арон на роги його, раз в рік, кровю жертви покути за гріх і примирення, буде що року раз покутувати за його в роди ваші: Сьвятиня над сьвятинями він Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","І рече Господь Мойсейові тако: ");
INSERT INTO ukr1871_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Як перелїчувати меш сини Ізрайлеві, так нехай кожен при перелїку дасть Господеві за душу свою викуп, і не буде в них лиха, як перелїчувати муть їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ось що мусять вони давати: всї що переходити муть до перелїчених, пів секеля, після секеля сьвятинї (двайцять гер один секель) пів секеля яко приніс Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Двайцятилїток і старше хто переходить до перелїчених, мусить давати приноса Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Багатий не більш, і вбогий не меньше пів секеля мусить давати, як приніс Господеві, на покуту душ їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","І брати меш срібло покутне від синів Ізрайлевих, та й давати меш його на службу в громадський намет; і буде воно синам Ізрайлевим поминаннєм перед Господом, на покуту душ ваших. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","І рече Господь Мойсейові тако: ");
INSERT INTO ukr1871_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Зробиш ти вмивальницю мідяну й підставку до неї мідяну, на обмиваннє, і поставиш її між наметом громадським і жертівником, і наллєш до неї води. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","І обмивати муть у йому Арон і сини його руки свої й ноги свої. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Як входять вони в громадський намет, мусять пообливатись водою, щоб не померти; або як приступають до жертівника на служеннє, щоб закурити огняну жертву Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Мусять пообмивати руки свої й ноги свої, щоб не померти; і буде се установою віковічньою йому й насїнню його в роди їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","І рече Господь Мойсейові так: ");
INSERT INTO ukr1871_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Возьми теж собі пахощів найдорожших: мирри чистої пятьсот секелїв, та цинамону пахущого половину того, двістї і пятьдесять, і кальмусу пахущого двістї і пятьдесять, ");
INSERT INTO ukr1871_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","І кассії пятьсот, по секелю сьвятинї, та олїї оливної один гін. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","І зробиш із того миро сьвятого помазання, мішане мастило пахуще, робом аптикарським; се буде олїя сьвятого помазання. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","І мусиш помазати ним громадський намет і скриню сьвідчення, ");
INSERT INTO ukr1871_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","І стіл і всю посудину його, і сьвітильника, і посудину його, і жертівника кадильного, ");
INSERT INTO ukr1871_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","І жертівника до всепалення, і вмивальницю і підставку її, ");
INSERT INTO ukr1871_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","І поосьвячуєш їх; і будуть вони пресьвятими: хто доторкнеться до них, буде сьвятий. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","І Арона й сини його намастиш і висьвятиш їх на сьвященників менї. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","До синів же Ізрайлевих мусиш промовити: Миром сьвятого помазання мусить се бути менї в роди ваші. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","На людське тїло не будете його зливати, і по складу його не робити мете такого собі. Сьвяте воно, і сьвятим мусить бути вам. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Хто зробив би таке мішаннє, та хто помаже ним чужого, викорениться той ізміж людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","І Господь рече до Мойсея: Возьми запашне коріння: Стакте та кадильну черепашину, та гальбан, запашне коріння і чистий яловець, з усього по рівній частинї, ");
INSERT INTO ukr1871_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","І зроби з того майстерно зложене кадило, робом аптикарським стерте, чисте, сьвяте. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","І розтовчи на порох, і положи із сього перед сьвідченнєм в наметї громадському, де сходити мусь з тобою; пресьвята сьвятина буде для вас. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","І кадило, що зробити маєш, по складу частей його нїхто не сьміє робити для себе; буде воно в тебе сьвяте для Господа. ");
INSERT INTO ukr1871_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Хто б таке зробив, щоб понюхати його, той викорениться зміж людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Дивись, покликав я Базалеїла, сина Урії Гурієнка, з колїна Юдиного, ");
INSERT INTO ukr1871_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","І сповнив я його духом Божим, мудростю й розуміннєм і знаттєм у всякому реместві; ");
INSERT INTO ukr1871_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Щоб видумував майстерне, як вироблювати із золота й срібла і мідї, ");
INSERT INTO ukr1871_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","І вирізувати на дорогому каменї і вирізувати з дерева, і робити у всякому реместві. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","І се прилучив я сам до його за помічника Оголїаба Ахісамашенка, з коліна Данового, і вложив я мудрість в серце кожного, в кого мудре серце, щоб уміли вони все зробити, що заповідав я тобі: ");
INSERT INTO ukr1871_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Громадський намет і скриню сьвідчення і віко, що на їй, і всю посудину в наметї; ");
INSERT INTO ukr1871_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","І стіл і всю посудину його, і сьвітильника чистого, і всю посудину його, і кадильного жертівника, ");
INSERT INTO ukr1871_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","І жертівника всепалення і всю посудину його. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","І вмивальницю, і підставку її, і шати службові, і шати сьвяті для Арона сьвященника, і шати для синів його, щоб служили службу сьвяту. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","І миро і запашні пахощі для сьвятинї: Усе, як заповідав я тобі, мають зробити вони. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Ти ж промов до синів Ізрайлевих і кажи: Суботу ж мою мусите держати; бо се знамя між мною й вами в роди ваші, щоб ви знали, що я, Господь, осьвячую вас. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","І допильновуйте суботи; вона бо вам сьвята: Хто опоганить її, того скарати смертю; бо кожна душа, що робити ме яку роботу в день суботнїй, буде вбита. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Шість день для роботи, але семий день субота на спочинок, сьвятий день Господеві; кожного, хто робити ме дїло в субітнїй день, скарати смертю. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","І допильновувати мусять синове Ізрайлеві суботи, щоб сьвяткувати суботу в родах їх: Заповідь на віки. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Між мною і синами Ізрайлевими знамя се віковічне. Бо шість день творив Господь небеса і землю, а семого дня спочив. ");
INSERT INTO ukr1871_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","І дав Мойсейові, переставши розмовляти з ним на Синай горі, дві таблицї сьвідчення, таблицї камяні, на котрих писав палець Божий. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","І вбачили люде, що загаявся Мойсей зійти з гори, і згромадились люде до Арона, і мовляли до його: Заходись лишень та пороби нам боги, щоб вони йшли поперед нас! Бо ми не знаємо, що сталось Мойсейові, чоловікові сьому, що вивів нас із Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","І рече їм Арон: Повиймайте ж сережки золоті, що в ушу жінок ваших, у ваших синів і дочок, та й принесїть до мене. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","І повиймали всї люде сережки золоті, що в ушу в їх, і поприносили до Арона. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","І позабирав їх із рук їх, і виробив форму, і зробив із них литого бичка. І казали люде: Ось бог твій, Ізраїлю, що вивів тебе з Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","І вбачаючи се Арон, вистроїв перед ним жертівника. І покликне Арон і каже: Завтра сьвято Господеві! ");
INSERT INTO ukr1871_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","І повставали вони рано враньцї, та й вознесли жертви огняні і жертви мирні. І посїдали люде їсти й пити з ним, і вставши позаводили іграшки. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","І рече Господь Мойсейові: Ійди боржій, спустись! Показились бо сї люде, що вивів єси з Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Хутко звернули з дороги, що я заповідав їм; зробили собі литого бичка та й поприпадали ниць перед ним, і принесли йому жертву, й мовляють: Ось, бог твій Ізраїлю, що вивів тебе з Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","І рече Господь Мойсейові: Бачив я людей сих; се люде затвердїлого серця. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Іди ж від мене, щоб запалав я гнївом на їх, і щоб менї вигубити їх; тебе ж я зроблю народом великим. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","І благав Мойсей Господа, Бога свого, і промовив: Про що, Господе, палати гнївом тобі на людей твоїх, що вивів єси з Египецької землї потугою великою й рукою міцною? ");
INSERT INTO ukr1871_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Чи то ж гаразд, як мовляти муть Египтїї: На лихо він вивів їх, аби повбивати в горах та повикорінювати з лиця земного? Одвернись від гнїва твого, да зжалься, що розлютувався на людей твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Спогадай Авраама, Ізаака й Ізраїля, слуг твоїх, що їм клявся єси собою самим, словами: Намножу насїння вашого, як зір небесних, і всю ʼцю землю, що про неї я глаголав, дам я насїнню вашому і наслїдувати мете її віковічно. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","І зжалївся Господь, що розлютувався та й хотїв заподїяти лихо людям своїм. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","І повернувся Мойсей, і спустивсь з гори, а таблицї сьвідчення в руцї його, таблицї пописані з обох боків; з одного й з другого боку пописані. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","А таблицї були дїло Боже і письмо — письмо Боже, вирізане на таблицях. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","І почув Йосуа голос люду, що вигукував, і каже Мойсейові: Військовий погук у коші. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Та нї! каже, не так гукають подужники, і не так гукають подужані; голос пересьпівів я чую. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","І сталось, що, наближившись до табору, побачив бичка і таньцї, і запалав Мойсей гнївом, та й кинув таблицї з рук, і розбив їх під горою. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","І взяв бичка, що вони зробили, та й спалив його на вогнї, і розтовк його на прах; та й висипав у воду, та й дав її пити синам Ізрайлевим. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","І рече Мойсей Аронові: Що тобі заподїяли сї люде? За що навів на їх великий гріх? ");
INSERT INTO ukr1871_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","І рече Арон: Не палай гнївом на мене, добродїю. Ти сам знаєш сей люд, який він ледачий. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Кажуть вони менї: Зроби нам бога, щоб ійшов поперед нас, бо не знаємо, що сталось Мойсейові, чоловікові сьому, що вивів нас з Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Я й кажу їм: У кого є золото, здіймайте з себе. І пооддавали менї, і вкинув я в огонь його, і вийшов сей бичок. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","І вбачав Мойсей, що розузданий се люд, а розуздав його Арон, на сором їх перед противниками їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","І став Мойсей у кошових воротях, і покликнув: Хто за Господа, до мене! І скупились до його всї сини Левієві. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","І каже їм: Так глаголе Господь, Бог Ізраїлїв: Підпережи кожен меча свого при бедрі, пройдїте сюди, і назад по табору од воріт і до воріт, і побивайте браттє ваше, і товариство ваше, і сусїд ваших. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","І вчинили синове Ізрайлеві по слову Мойсейовому; і полягло того дня з люду до трох тисяч чоловіка. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","І каже Мойсей: Присьвятїтеся Господеві сьогоднї проти синів своїх і проти братів своїх, щоб на вас послав сьогоднї благословеннє. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Другого ж дня промовив Мойсей до людей: Великим гріхом провинили ви! Оце ж підіймусь до Господа; може й спокутую ваші гріхи. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Вернувся Мойсей до Господа й рече: Ой, величезним гріхом провинили сї люде; зробили собі бога із золота. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Оце ж, коли б простив гріх їх! Коли ж нї, дак вичеркни мене з книги твоєї, що написав єси. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","І рече Мойсейові Господь: Хто провинив менї, вичеркну з книги моєї. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Нинї ж ійди, веди люди туди, куди я заповідав тобі. Ангел мій йти ме поперед тебе; як же прийде година кари моєї, тодї й карати му їх за провини їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","І послав Господь морову кару на людей за литого бичка, котрого виробив Арон. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","І рече Господь Мойсейові: Ійди, здіймайсь ізвідсї, ти й люде, що ведеш з Египецької землї в землю, що про неї я клявся Авраамові, Ізаакові і Яковові, глаголючи: Насїнню твойму оддам її. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","І пошлю перед тобою ангела та й повиганяю Канааніїв, Аморіїв, і Хетіїв, і Ферезіїв і Гевіїв і Євузіїв. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ійди в землю, де тече молоко і мід; сам бо не пійду серед вас, тим що ви запеклий народ, дак щоб не вигубити менї вас в дорозї. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","І почули люде се гірке слово, та й засуміли, і нїхто не надївав своїх окрас. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Рече бо Господь Мойсейові: Промов до синів Ізрайлевих: Ви народ запеклий; коли б ійшов я одну тілько минуту проміж вами, дак вигубив би вас. Оце ж поздіймайте свої окраси з себе, я ж знаю, що чинити му з вами. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","І позривали сини Ізрайлеві свої окраси з себе почавши від Гореб гори. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Мойсей же взяв намета й напяв його за кошем, оддалеки від коша, та й назвав його соборним наметом. І сталося, кожен, хто шукав Господа, виходив до намета, що був за кошем. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","І сталось, як виходив Мойсей з намету, вставали всї люде, і стояло кожне коло входу у свій намет і дививсь всьлід Мойсейові, аж покіль увійде він у намет. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","А як увіходив Мойсей у намет, дак спускався хмарний стовп, і зупинявсь коло входу в намет, і розмовляв Господь із Мойсейом. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","І вбачаючи весь люд стовпа хмарного, що стояв коло входу в намет, вставав увесь люд і падали ниць, кожне коло входу в свій намет. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","І розмовляв Господь із Мойсейом лицем до лиця, так як говорить чоловік з чоловіком; і вертався він до коша. Слуга ж його Йосуа Нуненко, молодик, не виходив із середини намету. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","І рече Мойсей Господеві: Дивись, глаголав єси менї: Веди люд сей, та не сповістив мене, кого посилаєш зо мною. Ти ж глаголав: Знаю тебе на імя, та ще й ласку знайшов єси в очах моїх. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Оце ж, коли знайшов я ласку в очах твоїх, дак дай менї взнати дороги твої, щоб пізнав тебе, та й знайшов ласку в очах твоїх, та зглянься й на те, що се люде твої! ");
INSERT INTO ukr1871_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","І рече: Лице моє йти ме з тобою, і я дбати му про упокій твій. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","І рече до його: Коли не йти ме лице твоє, так і не веди нас ізвідти. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Бо чим же впевняться, що знайшов я ласку в очах твоїх, я й люде твої? Чи не тим же, що пійдеш ти з нами, і відрізнимось ми, я й люде твої, від усякого народа, який є на земному лицї? ");
INSERT INTO ukr1871_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","І рече Господь Мойсейові: І те, що промовив єси, сотворю; бо знайшов єси ласку в очу в мене, і знаю я на імя тебе. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","І рече він: Покажи ж менї славу твою! ");
INSERT INTO ukr1871_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","І рече: Проведу всю милость мою перед лицем твоїм і проголошу імя Господа перед тобою; і милувати му, кого милувати, і милосердувати мусь, над ким милосердуватись. І рече: ");
INSERT INTO ukr1871_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Не можна тобі бачити лице моє: бо не жити ме вже людина, що бачила лице моє. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","І рече Господь: Ось місце коло мене, і будеш стояти на скелї: ");
INSERT INTO ukr1871_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","І як проходити ме слава моя, поставлю тебе в щелинї скелї, та й затулю долонею моєю лице тобі, поки не перейду. ");
INSERT INTO ukr1871_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","А як відтулю долоню мою, дак бачити меш мене ззаду, лиця ж мого не бачити меш. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","І рече Господь Мойсейові: Висїчи собі дві таблицї камяні взором первих, і напишу на таблицях слова, що були на таблицях первих, що розбив єси. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","І бувай готов у раньцї, і зійди в раньцї на Синай гору, та й станеш тамо передо мною на верху гори. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","І нїхто щоб не взійшов з тобою, та нїкого щоб не було видно по всїй горі; ба й отара й череда щоб не паслась під горою. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","І висїк дві таблицї камяні взором первих; і встав Мойсей рано враньцї, та й зійшов на Синай гору, як заповідав йому Господь, і взяв в руки обидві таблицї камяні. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","І зійшов Господь у хмарі і став з ним там, і промовив імя „Господь‟. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","І переходив Господь перед ним, і покликував: Господь! Господь! Бог, милосердний і ласкавий, нескорий на гнїв і щедрий на милость і правду, ");
INSERT INTO ukr1871_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Що держить ласку про тисячі, прощає несправедливість, переступ і гріх, хоч нїколи не вважає безвинним виноватого, карає несправедливість батьківську на дїтях і на дїтях дїтей, на третьому й на четвертому родї. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","І припав хутко Мойсей до землї і поклонився Богу, ");
INSERT INTO ukr1871_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","І рече: Коли тільки знайшов я ласку в очу в тебе, Господе, нехай же йде Господь серед нас; бо запеклі се люде, та прости несправедливість нашу і гріх наш, і возьми нас за наслїддє своє! ");
INSERT INTO ukr1871_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","І рече: Се я покладаю завіт: Перед усїма людьми твоїми сотворю чудеса, які не творились на всїй землї і у всїх народів, і вбачати ме ввесь люд, що проміж ним живеш, дїло Господнє: страшенне бо те, що сотворю з тобою. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Пильнуй же того, що я заповідав нинї тобі. Се повиганяю перед тобою Аморіїв, і Канааніїв, і Хетіїв, і Ферезіїв, і Гевіїв, і Євузіїв. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Остерегайсь чинити вмову з осадниками тієї країни, що в їх землю ввіходиш, щоб не зробились вони сїткою проміж вами. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Нї, мусите руйнувати жертівники їх, і будете ламати стовпи їх, і рубати сьвященні дуброви їх, ");
INSERT INTO ukr1871_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Бо не будеш покланятись иншому богу; бо Господь, на імя Ревнивий, він Бог ревнивий. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Не чинити меш умови з жителями тієї країни, ато будуть блудувати вони з богами своїми і приносити жертву богам своїм, та й покличуть тебе, і зачнеш їсти жертви їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","І будеш брати дочки їх за синів своїх, і будуть блудовати дочки їх за богами своїми, і приводити синів твоїх до блуду за богами своїми. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Виливаних богів не будеш робити. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Сьвята не заквашеного хлїба будеш допильновувати, сїм день їсти меш опрісноки, як заповідав я тобі, в певну годину, в місяцї Абиві; бо в місяцї Абиві вийшов єси з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Все, що родить мати, моє; і весь твій скот, первородні самцї бики й барани. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Первака ж осла мусиш викупити бараном, коли ж не викупиш, так переломи йому шию. Всякого первенця з синів мусиш викупити, і нехай нїхто не показується передо мною з порожнїми руками. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Шість день робити меш, семого ж дня перестанеш орати і жати. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","І сьвято тижневе держатя меш, те ж і сьвято первоплоду пшеничних вжинків, і сьвято збору при кінцї року. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Три рази що року мусить показуватись увесь муський пол ваш перед лицем Господа, Бога Ізраїлського: ");
INSERT INTO ukr1871_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Бо повиганяю народи сперед тебе і розпросторю границї твої, і нїхто не посягне на землю твою, як виходити меш, показатись перед Господом, Богом вашим, три рази що року. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Не приносити меш вкупі з заквашеним кров жертви моєї, і не зоставати меться до ранку жертва в паскове сьвято. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Первий первоплід землї твоєї приносити меш домові Господа, Бога твого. Не варити меш козеняти в молоцї матері його. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","І рече Господь Мойсейові: Позаписуй собі сі слова: бо згідно з сїми словами вчинив я з тобою і з Ізраїлем завіт. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","І був там він з Господом сорок день і сорок ночей, хлїба не їв і води не пив. І написав на таблицях слова завіту, десять слів. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","І сталось, як сходив Мойсей з Синай гори, а обидві таблицї сьвідчення були в руцї Мойсейовій, як сходив із гори, так не знав Мойсей, що стала сияти проміннєм кожа на лицї в його, бо розмовляв він з Господом. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","І побачив Арон і всї синове Ізрайлеві Мойсея, і се почала сияти проміннєм кожа на лицї в його, і побоялись приступити до його. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","І покликав їх Мойсей, і поприходили до його Арон і всї князї громадські, і розмовляв Мойсей із ними; ");
INSERT INTO ukr1871_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","А потім приступили й усї синове Ізрайлеві, і заповідав їм він усе, про що глаголав йому Господь на Синай горі. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","І як переставав Мойсей промовляти до них, так спускав на лице собі покривало. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Якже приходив Мойсей перед Господа розмовляти з ним, здіймав покривало, аж поки він відходив; і виходив він і промовляв синам Ізрайлевим, що заповідано йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","І вбачили синове Ізрайлеві лице Мойсейове, що сияла проміннєм кожа на лицї в Мойсея; і надївав ізнов Мойсей покривало на лице собі, поки не прийшов, щоб розмовляти з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","І зібрав Мойсей всю громаду синів Ізрайлевих і каже до них: ");
INSERT INTO ukr1871_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ось що заповідав Господь вам чинити: Шість день можна вам робити, семий же день мусить вам бути сьвятим днем, субота відпочинку Господеві. Хто робить у сей день, всякому смерть. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Не будете запалювати багаття в усїх ваших домівках в день субітнїй. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","І промовив Мойсей до всїєї громади синів Ізрайлевих так: От що заповідав Господь, глаголючи: ");
INSERT INTO ukr1871_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Принесїте від себе жертву підношення Господеві. Кожен охочий нехай принесе Господеві приніс: золото, срібло і мідь. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","І блават і пурпур та кармазин та тонке полотно і козину шерсть; ");
INSERT INTO ukr1871_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","І баранячі шкіри червоні, і шкури барсучі, і дерево акацію, ");
INSERT INTO ukr1871_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","І олїю на сьвітло, і пахощі на миро помазання і на запашне кадило. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Каміннє ониксове і каміннє до вставлювання на нагрудник і наплїчник. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","І кожен мудрий серцем ізміж вас прийде і робити ме все, що заповідав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Храмину його і покриттє її, і гаки її, і дошки її, і засуви її, і стовпи її, і підстави її, ");
INSERT INTO ukr1871_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Скриню і жердки її, і віко, і завісу, ");
INSERT INTO ukr1871_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Стола й носила його, й усю посудину його, і покладний хлїб; ");
INSERT INTO ukr1871_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Сьвітильник на сьвітло, і посудину його, і лямпи його, і олїю на сьвітло; ");
INSERT INTO ukr1871_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","І жертівника кадильного і носила його, і миро, і запашне кадило, і завісу коло входу до храмини; ");
INSERT INTO ukr1871_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Жертівника на всепаленнє і грати до його мідяні, жердки його і всю посудину його, умивальницю й підставу до неї; ");
INSERT INTO ukr1871_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Опони у дворі, і стовпи до них, і підставки їх, і мату до воріт у дворі; ");
INSERT INTO ukr1871_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Кіллє до храмини, і кіллє до двора, і посторонки до них; ");
INSERT INTO ukr1871_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Шати до служення в сьвятинї; шати сьвяті для Арона, сьвященника, і шати для синів його, щоб служити сьвященну службу. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","І відийшла вся громада синів Ізрайлевих од лиця Мойсейового, ");
INSERT INTO ukr1871_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","І поприходили всї, кого підіймало серце його, і всї, кого заохочував дух його, і подавали приноси Господнї на будову громадського намету і на всякі потребини його, і на шати сьвяті. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","І поприходили вони, чоловіки й жіноцтво, всї, скільки було їх охочого серця, і подали запинки й сережки, й каблучки, і золоті намиста, і всяку золоту посудину, ");
INSERT INTO ukr1871_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","І всякий, в кого знайшовся блават, і пурпур, і кармазин, і тонке полотно, і козина шерсть, і шкіри баранячі червоні, і шкіри барсучі, приносив. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Усякий, в кого була жертва срібна й мідяна, подавав жертву приношення Господеві; і всякий, в кого знайшлось дерево акація до всякої службової роботи, подавав. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","І все жіноцтво, в якого було мудре серце, почало прясти своїми руками, і подавали свою пряжу: на блават, і пурпур, і кармазин, й тонке полотно. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","І все розумне жіноцтво, кого серце підіймало на мудрощі, пряли козину шерсть. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","А князї подавали каміннє ониксове і каміннє до вставлювання для наплїчника і нагрудника. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","І пахощі й олїю на сьвітло і на миро, і на запашне кадило. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Дїти Ізрайлеві, всякий чоловік і всяка жінка, в котрої було охоче серце, подавати на всяку роботу, яку Господь заповідав через Мойсея, творити, подавали добровільні дари Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","І рече Мойсей синам Ізрайлевим: Дивітесь, покликав Господь Безалеїла, сина Урії Гурієнка, із колїна Юдиного. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","І сповнив його духом Божим на мудрощі, і розуміннє, і знаннє, і на всяке ремество, ");
INSERT INTO ukr1871_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Щоб майстерне видумувати та вироблювати із золота й срібла і мідї, ");
INSERT INTO ukr1871_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","І вирізувати каміннє до встявлювання, і вирізувати з дерева, робити всяку штучну роботу; ");
INSERT INTO ukr1871_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","І вложив йому в серце навчати, йому й Оголїябові Ахисамашенкові, з роду Данового. ");
INSERT INTO ukr1871_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Сповнив їх серце мудрощами до вироблювання всякої роботи різьбяра і майстерного ткача і гаптяря, по блавату і по пурпуру і по кармазину, і по тонкому полотну, і ткача: всїх тих, що всяку роботу вироблюють і штучні речі видумують. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","І робили, як заповідав Господь, Безалеїл та Оголїаб і всякий мудросердий чоловік, кому дав Господь мудрість і розуміннє, щоб знали, як робити всяку потрібну роботу в сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","І покликав Мойсей Безалеїла та Оголїаба і всякого чоловіка мудрого серця, що йому дав Господь мудрість у серце, всякого, кого підіймає серце, взятись за дїло, щоб довести його до ладу. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","І взяли вони сперед Мойсея всї приноси, що подали синове Ізрайлеві, на будівлю і роботу сьвятинї, щоб збудовати її; подавали ж вони ще добровольні приноси що ранку. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","І поприходили всї мудрі люде, що робили всяку роботу в сьвятинї, кожен по реместву свойму, що хто вмів робити, ");
INSERT INTO ukr1871_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","І промовили до Мойсея кажучи: Більш, як треба, подали люде на потребини дїла, що заповідав Господь поробити. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","І дав Мойсей наказ, і зʼясували по табору словами: Нехай нї чоловіки, нї жінки не дбають більш о приноси для сьвятинї! І так перестали люде приносити. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","І було запасу доволї на всяку роботу, щоб її довершити; ще й було надто. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","І всї робітники будівлї, у кого було мудре серце, зробили храмину з десятьох келїмів; з нитяного полотна та з блавату, і пупуру, і кармазину, с херувамами, роботи майстерної, поробили їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Завдовжки один келїм двайцять і вісїм локоть, а завширшки один келїм чотири ліктї; міра одна у всїх келїмів. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","І посчіплював пять келїмів, один з одним, і счіпив знов пять келїмів других один з одним. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","І поробив петельки з блакиту по краю одного келїма при кінцї його, де счіплюється; так само зробив по краю останнього келїма, де в друге счіплюється. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Пятьдесять петельок зробив на одному келїмі, і пятьдесять петельок у кінцї келїма, що счіплюється в друге, петельки одна проти другої. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","І зробив пятьдесять запинок золотих, і посчіплював келїми один з одним, і стала храмина цїла. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","І поробив коври з козиної шерстї до намету над храминою; одинайцять коврів таких зробив він. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Завдовжки один ковер трийцять локот, а чотири ліктї завширшки один ковер; одна міра в одинайцяти коврів. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","І счіпив до купи пять коврів окроме і шість коврів окроме. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","І зробив пятьдесять петельок на самому краю ковра останнього, де счіплюється, а пятьдесять петельок на краю ковра, де счіплюється з другим. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","І зробив запинок мідяних пятьдесять до счіплювання намету так, щоб став цїлим. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","І зробив покриттє до намету із баранячих шкір, викрашених на червоно, і покриттє з барсучих шкір зверху. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","І наробив дощок на храмину із дерева акацієвого, простостоячих. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Десять локоть завдовжки одна дошка, і локіть з половиною завширшки одна дошка. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Два чопи в одній дошцї, пригнані один проти одного; так само поробив на всїх дошках до храмини. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","І наробив дощок до храмини: двайцять дощок на полуденньому боцї її, до полудня; ");
INSERT INTO ukr1871_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","І сорок срібних підставок зробив під двайцять дощок: дві підставки під одну дошку, про обидва чопи її, і дві підставки під дошку другу, про обидва чопи її. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","І на другому боцї храмини, на північ, двайцять дощок зробив він. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","І сорок підставок їх срібних: дві підставки під одну дошку, і дві підставки під другу дошку. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","А на задньому боцї храмини проти заходу сонця зробив шість дощок; ");
INSERT INTO ukr1871_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","А дві дошки зробив до кутків храмини на задньому боку. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","І були вони подвійні знизу до гори, і були в горі одна при другій в одній каблучцї. Так поробив до обох їх на обох кутках. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","А всього було вісїм дощок, а підставки їх із срібла: шіснайцять підставок, під кожною дошкою по дві підставки. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","І поробив засуви із дерева акацієвого: пять до дощок на одному боцї храмини. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","І пять засувів на другому боцї храмини на полуденньому боцї. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","І зробив засува по серединї дощок від одного кіньця до другого. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","А дошки пообкладував золотом; а каблучки їх, кіньця про засуви, поробив із золота, і пообкладував засуви золотом. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","І зробив завісу з блавату, пурпуру й кармазину і з нитяного полотна; і роботою майстерною поробив на нїй херувимів. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","І зробив до неї чотири стовпи із дерева акації та й пообкладував золотом, а гаки їх золоті, і повиливав до них чотири підставки із срібла. ");
INSERT INTO ukr1871_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","І зробив опону до входу в намет із блавату, й пурпуру, й кармазину, і нитяного полотна, робом гаптярським; ");
INSERT INTO ukr1871_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","І пять стовпів із гаками їх; і пообкладував верхи їх і перекладини їх золотом; а пять підставки їх зробив із мідї. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","І зробив Безалеїл скриню з дерева акацієвого, два ліктї з половиною завдовжки, а локіть з половиною завширшки, і локіть з половиною заввишки. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","І виложив її щирим золотом з середини й зверха, і зробив на їй вінець золотий з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","І вилив до неї чотири каблучки золоті, до чотирох рогів її: дві каблучки її на одному боцї її, і дві каблучки на другому боцї її. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","І поробив носила з дерева акацієвого та й пообкладував їх золотом. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","І повсовував носила в каблучки по рогах у скринї. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","І зробив віко з щирого золота, два ліктї з половиною завдовжки і локіть з половиною завширшки. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","І зробив два херувими золоті; кованої роботи зробив їх по обох кіньцях віка: ");
INSERT INTO ukr1871_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Одного херувима при кіньцї одного боку, і одного херувима при кіньцї другого боку, одноцїльно з віком поробив херувимів по обох кіньцях його. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","І простягали херувими крила свої вгору, вкриваючи крилами своїми віко, а лиця їх були проти себе; лиця херувимів були на віко повернуті. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","І зробив стола з дерева акацієвого: два ліктї завдовжки, і локіть завширшки, і локіть з половиною заввишки. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","І виложив його золотом щирим, і зробив до його вінець золотий з усїх боків його. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","І зробив на йому лиштву, в долоню завширшки, і зробив золотий вінець до лиштви його з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","І вилив до його чотири каблучки золоті, та поприроблював каблучки до чотирох рогів його коло чотирох ніг у його. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Коло лиштви були каблучки як всовки для носил, щоб носити стола. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","І поробив носила з дерева акацієвого та й пообкладував їх золотом, щоб носити ними стола. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","І поробив посудину, що була на столї: полумиски до його і вмивальницї до його, і чаші до його, й коновки до виливання, із золота щирого. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","І зробив сьвітильника із золота щирого; кованим робом зробив сьвітильника, ногу його і держало його; чашечки його, і пупляшки його, і квітки його одноцїльні з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","І шість рамен виходило з боків його: три рамя сьвітильника з одного боку його, і три рамя сьвітильника з другого боку його. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Три чашечки, як цьвіт микдаловий на одному рамї, пупляшок і квітка; і три чашечки, як цьвіт мікдаловий, на рамї другому, пупляшок і квітка; так на шестьох рамях, що виходили із сьвітильника. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","А на сьвітильнику чотири чашечки, як цьвіт мікдаловий, пупляшки їх і квітки їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","І то пупляшок під двома рамями його, і знов пупляшок під двома рамями його, і знов пупляшок під двома рамями його, у шестьох рамях, що виходили з його. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Пупляшки їх і рамя їх були одноцїльні з ним; цїлий сьвітильник одна кована робота із золота щирого. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","І зробив сїм лямп до його, і щипцї до його, й гасильницї його із золота щирого. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","З одного таланта золота щирого зробив його з усїм посудом його. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","І зробив жертівника кадильного з дерева акацієвого: локіть завдовжки і локіть завширшки, четверокутний, і два ліктї заввишки, роги його одноцїльні з ним. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","І обложив його золотом щирим, верх його і стїнки його, з усїх боків, і роги його. І зробив на йому вінець золотий навкруги. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","І дві каблучки золоті зробив до його під віньцем його, на двох рогах його; з обох боків його зробив; і були вони місцями для жердок, щоб ними носити його. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","І поробив жердки з дерева акацієвого та пообкладував їх золотом. ");
INSERT INTO ukr1871_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","І зготовив миро сьвяте, і чисті запашні пахощі на кадило робом мастиєльників. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","І зробив жертівника на всепаленнє із дерева акацієвого, пять локоть завдовжки, і пять локоть завширшки, четверокутнього, а три ліктї заввишки; ");
INSERT INTO ukr1871_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","І поробив роги його на чотирох кутках його; одноцїльні з ним були роги його; і пообкладував їх міддю. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","І поробив усю посудину його: кітли до його, і кочерги до його, і макітри його до бризкання, і гаки до його, й кадильницї до його поробив із мідї. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","І зробив до жертівника грати мідяні, плетеної роботи, і положив їх нарівнї з краєм жертівника, знизу, до половини його. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","І вилив чотири мідяні каблучки до чотирох рогів на носила. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","І поробив до жертівника носила з дерева акацієвого та пообкладував міддю. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","І повстромлював носила в каблучки, і були носила по обох боках жертівника, щоб носити його; порожнього, з дощок, зробив його. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","І зробив умивальницю мідяну і підставку до неї мідяну, на котрій представлено жіноцький натовп, що товпився коло входу в намет соборний. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","І зробив двора: на полуденньому боцї, на полуднє, опони двора з тонкого нитяного полотна, сто локоть. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Двайцять стовпів до них і двайцять підніжків мідяних; гвіздє в стовпах і сволки в них із срібла. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","І так само на північньому боцї опон сто локоть; і стовпів до них двайцять і підніжків їх двайцять мідяних; гвіздє до стовпів і сволки до них із срібла. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","І на західньому боцї опон пятьдесять локоть, стовпів до них десять, і підніжків до них десять. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","А на східньому боцї, на схід соньця, пятьдесять локоть; ");
INSERT INTO ukr1871_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","І пятнайцять локоть опон на одному боцї, до них стовпів три і підніжків три; ");
INSERT INTO ukr1871_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","І на другому боцї, з того і другого боку коло воріт двора, опон пятнайцять локот, та стовпів до них три і підніжків три. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Усї опони в дворі з усїх боків із тонкого нитяного полотна. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","А підніжки в стовпів мідяні, а гаки на стовпах і сволки до них срібні, а їх оголівя пообкладувано сріблом, і всї стовпи в дворі счіплено сволками із срібла. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","А опона до воріт двора була роботи гаптярської із блавату й пурпуру й кармазину і з тонкого полотна, з пряжі; а то двайцять локоть завдовжки, а пять локоть заввишки, в ширину так само як опони у дворі; ");
INSERT INTO ukr1871_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","А стовпів до них чотири і підніжків до них чотири мідяних, гаки до них срібні; і пообкладовано їх оголівя і перекладини їх сріблом. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","А все гвіздє в храминї і в дворі всюди мідяні. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","А се полїчена цїна храмини, храмини сьвідчення, що злїчена по наказу Мойсейовому, через Левітів, під доглядом Ітамара, сина сьвященника Арона. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Безалеїл же, син Урії Гурієнка, з колїна Юдиного, поробив усе, що заповідав Господь Мойсейові, ");
INSERT INTO ukr1871_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","А з ним працював Оголїаб Ахісамашенко, з колїна Данового, різбяр і штукар-ткач і гаптяр по блавату й по пурпуру й по кармазину и по тонкому полотну. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Всього золота, що пійшло на всяку роботу цїлої будівлї сьвятинї, золота принесеного в жертву, було двайцять і девять талантів і сїмсот трийцять секлїв, по секлям сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","А срібла од перелїчених громадян сто талантів і одна тисяча сїм сот сїмдесять і пять секлїв, по секлям сьвятинї: ");
INSERT INTO ukr1871_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","А то по пів секля, по секлям сьвятинї, поголовщини з кожного, хто перейшов до перелїчених, від двайцятьох років і старше, від шістьсот трьох тисячей і пятьсот пятьдесять чоловіка. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","А сотня талантів пійшла на вилиті підніжки сьватині і на підніжки до завіси, сто підніжків із сотнї талантів, по таланту на один підніжок. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","А з тисяч сїмсот сїмдесять і пять секлїв поробив гаки до стовпів і пообкладав оголовки їх, і звязав їх сволками. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","А мідї дарованої було сїмдесять талантів і чотириста секлїв. ");
INSERT INTO ukr1871_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","І поробив стояла коло входу в соборний намет, і жертівника мідяного і грати мідяні до його і всю посудину до жертівника; ");
INSERT INTO ukr1871_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","І стояла в дворі і всї прикілки до храмини й усї прикілки в дворі навкруги. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","А з блавату й пурпуру й кармазину поробили мережані шати до служби в сьвятинї, і поробили сьвяті шати для Арона, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","І зробив наплїчника Аронові з золота, та з блавати та з пурпуру й кармазину й тонкого полотна з пряжі. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","І повибивали із золота пластинки, та й порозтинали їх на нитки, щоб гаптувати ними по блавату і по пурпуру й кармазину і по всякому полотну, робом майстерним. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Поробили на йому нарамники, що до купи спинались. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","А мережаний пояс, котрим привязувано його, що був поверх його, був з тої ж самої тканини, одної з ним роботи: із золота, блавату, пурпуру й кармазину й тонкого полотна з пряжі, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Та й оправили вони два каменї ониксові в оправу золоту, вирізавши печатньою різьбою імена синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","І повставляли їх у нарамника з боків, яко каменї на спомин синам Ізрайлевим: як повелїв Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","І зробив нагрудника роботою штучно ткарською, як робота наплїчника: із золота, блавату, пурпуру й кармазину й тонкого полотна з пряжі. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Був він четверокутний; двоїстим зробили нагрудника, пядь завдовжки і пядь завширшки, двоїстий був. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","І обложили його чотирма рядами каміння; один ряд: Сардїй, топаз і смарагд, ряд первий; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","А другий ряд: Гранат, сафір і диямант; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","А третїй ряд: Опаль, ахат і аметист; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","А четвертий ряд: Хризолїт, оникс і яспіс; оправлені в оправу золоту, кожний в гнїздочку свойму. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","А на каміннях були імена синів Ізрайлевих; дванайцять, по прізвищам їх; вирізані як на печатцї, кожен з імям своїм, про дванайцять колїн. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","І поробили на нагруднику ланьцюжки, плетені як шнурочки, з чистого золота. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Та й зробили дві оправки із золота і дві каблучки із золота по двох кіньцях і причіпили дві каблучки нагрудника. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","І привязали два плетені шнурки золоті до двох каблучок на двох кіньцях нагрудника. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","А обидва кіньцї двох плетених шнурків причіпили до двох оправок та й приставили їх до нарамників наплечника, з лицьового боку його. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","І зробили ще дві каблучки золоті та й причіпили на двох кіньцях нагрудника, з краю його, що сподом до наплїчника. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","І зробили знов дві каблучки золоті та й причіпили на двох нарамниках наплїчника внизу до лицьового боку його, саме там, де звязується до купи поясом наплїчника. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","І привязали вони нагрудника каблучками його до каблучок наплїчника шнурком блаватовим, щоб він був над поясом наплїчника та щоб не одставав нагрудник од наплїчника: так як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","І зробив верхню шату до наплїчника робом ткацьким, всю з блавату. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","І пазуха в верхньої шати була по серединї її як пазуха в панцері; облямовано кругом пазуху, щоб не дерилась. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","І поробили долиною у верхньої шати гранатові яблочка з блавати й пурпуру й кармазину пряденого. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","І поробили дзвоники з золота щирого та й попричіплювали дзвоники між гранатовими яблочками по рубцю верхньої шати з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Дзвоник і граната, дзвоник і граната по рубцю шати з усїх боків, щоб у їй правити службу: як Господь заповідав Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","І поробили хитони з бавовняної тканини Аронові й синам його; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","І кедар з білої тканини, і окрасу високих клобуків з білої тканини, і спідне платтє полотняне з пряденої бавовни. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","І пояси з пряденої бавовни, з блавату й пурпуру й кармазину, робом гаптярським, так як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","І зробили бляху, сьвяту диядему, з золота щирого, і написали на їй надпись різьбою печатньою: Сьвятиня Господеві! ");
INSERT INTO ukr1871_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","І привязали до неї шнурок блаватовий, щоб привязати ним на кедарі зверху, так як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","І скіньчили всю роботу храмини і намета соборного. І поробили синове Ізрайлеві все; як заповідав Господь Мойсейові, так і зробили вони. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","І принесли храмину до Мойсея: намет і всю посудину його, клямри його, дошки його, засуви його і стовпи його і підніжки його; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","І покриттє його з баранячих шкір крашених і покриттє з барсучих шкір, і завісу роздімаючу. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","І скриню сьвідчення, і носила до неї і віко; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Стола й усю посудину його і покладний хлїб; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Сьвітильника чистого і лямпи до його, лямпи вставлювання, і всю посудину його й олїю на сьвітло; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","І золотого жертівника і миро, і запашні кадила; і опону до входу в намет. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Жертівника мідяного, і грати його мідяні, жердки його і всю посудину до його; вмивальницю і стояло її; ");
INSERT INTO ukr1871_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Опони до двора, стовпи його і підніжки їх; опону до воріт в дворі, його посторонки і прикілки; і всю посудину до служення в храминї намета соборного. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Шату мережану до служби в сьвятинї й сьвяті шати для Арона сьвященника і шати для синів його, щоб служити службу сьвященну. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Усе, як заповідав Господь Мойсейові, так і поробили синове Ізрайлеві всяку роботу. ");
INSERT INTO ukr1871_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","І оглядав Мойсей всю роботу, і бачив, що зробили вони; як заповідав Господь, так і поробили вони; та й благословив їх Мойсей. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","В день первого місяця, в день первий, поставиш ти храмину громадського намету. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","І поставиш там скриню сьвідчення, і закриєш скриню завісою. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","І внесеш стола і пороставляєш те, що роставляти меться на йому; і принесеш сьвітильника, та й поставиш лямпи на йому. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","І поставиш ти жертівника золотого, щоб приносити кадило перед скринею сьвідчення. І повісиш опону коло входу в храмину. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","І поставиш жертівника для всепалення перед входом в храмину громадянського намету. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","І поставиш умивальницю між громадянським наметом і жертівником, і наллєш до неї води. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","І поставиш двора навкруги та й повісиш опону у воротах двора. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","І візьмеш мира та й помажеш храмину і все, що в їй, і осьвятиш її і всю посудину її; і буде вона сьвятинею. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","І помажеш жертівника на всепаленнє і ввесь посуд його, та й осьвятиш ти жертівника; і буде жертівник пресьвятим. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","І помажеш умивальницю і підніжок її, та й осьвятиш її. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","І приведеш Арона й сини його до входу в громадський намет та й пообливаєш їх водою. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","І вдягнеш Арона в шати сьвященні та й помажеш його і осьвятиш його, щоб він служив менї службу сьвященну. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","І сини його приведеш і повдягаєш їх у хитони. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","І помажеш їх, як помазав отця їх, щоб служили менї службу сьвященну. І буде їм помазаннє на вічне сьвященство в роди їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","І вчинив Мойсей усе; як заповідав йому Господь, так і вчинив він. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","І в первий місяць, другого року, в первий день місяця поставлено храмину. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","І поставив Мойсей храмину, і поукріплював підніжки її, і пороставляв дошки її, і позасовував засуви її, і поздвигав стовпи її; ");
INSERT INTO ukr1871_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","І напяв намета над храминою, і поклав накриттє наметове зверху в його, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","І взяв сьвідоцтво та й положив в скриню, і приправив носила до скринї, і поставив віко на скриню зверху. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","І внїс він скриню в храмину і спустив завісу, і закрив скриню; як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","І поставив стола в громадському наметї побіч скринї на північ, знадвору завіси; ");
INSERT INTO ukr1871_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","І положив на йому хлїби рядом перед Господом, як повелїв Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","І поставив сьвітильника в громадському наметї навпроти стола, на полуденньому боцї храмини. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","І пороставляв лямпи перед Господом, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","І поставив жертівника золотого в громадському наметї перед завісою, ");
INSERT INTO ukr1871_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","І закурив на йому запашне кадило, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","І повісив опону коло входу в храмину. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","А жертівника для всепалення поставив коло входу в храмину громадського намету, і принїс на йому всепаленнє, як повелїв Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","І поставив умивальницю між громадським наметом та жертівником, і налив до неї води на обмиваннє. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","І почали обмивати в їй Мойсей, Арон і сини його руки і ноги свої; ");
INSERT INTO ukr1871_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Як увіходили в громадський намет, і як приступали до жертівника, обмивались, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","І поставив двора навкруги храмини й жертівника, і повісив опону у воротях двора. І довершив так Мойсей дїло. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","І вкрила хмара громадський намет, і слава Господня сповнила храмину. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","І не зміг Мойсей увійти в громадський намет; на йому бо почивала хмара і слава Господня сповнила храмину. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","І як піднялась хмара над храминою, рушали далї сини Ізраїльські, покіль було мандруваннє їх. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Як же хмара не підіймалась, не рушали далїй, аж покіль вона знов піднялась. ");
INSERT INTO ukr1871_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Бо хмара Господня була в день над храминою, у ночі ж була вона поломяною перед очима усього дому Ізрайлевого, по ввесь час їх мандрування.");
INSERT INTO ukr1871_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","І покликав Господь Мойсея й рече до його з соборного намету: ");
INSERT INTO ukr1871_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Промов до синів Ізрайлевих і заповідай їм: Коли хто зміж вас приносити ме приніс Господеві від скоту, мусите приносити приніс ваш від товару й овечок та кіз. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Коли приніс його жертва всепалення з товару, мусить приносити самця без скази; до входу в громадянський намет приносити ме його, щоб знайти ласку в Господа. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","І положить руку свою на голову жертви всепалення, і знайде ласку в Господа, щоб спокутувати гріхи свої. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","І заколеш ти бичка перед Господом; і принесуть сини Аронові, сьвященники, кров, і покроплять кровю жертівника з усїх боків, той, що стоїть коло входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","І здійме шкіру з жертви всепалення і розійме її на частини. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","І запалять сини Арона, сьвященника, вогонь на жертівнику, і розложать на вогнї дрова; ");
INSERT INTO ukr1871_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","І покладуть сини Аронові, сьвященники, частини: голову й жир на дровах, над вогнем, що на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Тельбухи ж і ноги пополоще в водї, і пустить сьвященник се все димом: се всепаленнє, огняна жертва, любі Господеві пахощі. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","А коли приніс його з овечок та з кіз, на всепаленнє, самця без скази нехай приносить. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","І заколе його на північньому боцї жертівника перед Богом і набризкають сини Аронові, сьвященники, крові його на жертівника, з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","І роздійме його на частини, і покладе їх сьвященник вкупі з головою й жиром на жертівнику на дровах, се є на вогнї, що на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Тельбухи й ноги повиполїскує в водї, і принесе сьвященник усе це, та й пустить димом на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Коли ж жертва всепалення від птаства буде приніс його Господеві, мусить принести жертву свою з горлиць або з голубенят. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","І принесе її сьвященник до жертівника, і зверне головку їй, та й пустить із димом на жертівнику, а кров її нехай, вицїдить по стїнї в жертівника; ");
INSERT INTO ukr1871_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Волє ж її з калом віддїлить і кине коло жертівника на схід соньця до попелища. ");
INSERT INTO ukr1871_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","І надріже її на крилах, не віддїляючи їх, і пустить сьвященник її з димом на жертівнику на дровах, що на вогнї: всепаленнє се, огняна жертва, пахощі любі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","А коли хто приносити ме Господеві жертву хлїбову, нехай приносить муку пшеничну; і мусить злити на неї олїї, і положити на неї ладану. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","І подасть її синам Ароновим, сьвященникам; і вийме з неї повну жменю пшеничної муки з олїєю і з усїм ладаном, і закурить сьвященник сю частину на спомин на жертівнику: се огняна жертва, пахощі любі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Останки од приносу хлїбного Аронові й синам його: се велика сьвятиня із огняних жертв Господнїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","А коли приносиш як хлїбну жертву печево, то нехай будуть із пшеничної муки коржі прісні, замішані на олїї, та ладки прісні, помазані олїєю. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","А коли твій приніс на сковородї, то нехай буде мука пшенична замішана на олїї незаквашена; ");
INSERT INTO ukr1871_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Подїлиш його на куски і зіллєш олїї на його: се хлїбна жертва. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","А коли хлїбна жертва твоя в горшку, то нехай буде мука з олїєю. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","І принесеш жертву, зроблену з такого хлїба, Господеві; і подаси її сьвященникові, і він понесе її до жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","І візьме сьвященник із хлїбної жертви частину на спомин, та й воскурить на жертівнику: се огняна жертва, пахощі любі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Останки од приносу будуть Аронові й синам його: велика сьвятиня огняних жертв Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Який би нї був приніс ваш Господеві, не робити мете його заквашеним; бо нї заквашеного тїста нї меду не можна вам приносити як огняну жертву Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Що до жертви первоплодів, то повинні ви приносити їх Господеві; та не приносити мете їх на жертівнику про любі пахощі. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","І всякі приноси хлїбної жертви твоєї мусиш посолювати сіллю, та, щоб не бракувало солі завіту Бога твого при хлїбній жертві твоїй; з усяким приносом твоїм приносити мусиш і сіль. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","А як приносити меш жертву первоплоду Господеві з колосся, висушеного на вогнї, зерно обмелене принести мусиш на жертву з первоплодів твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","І наллєш олїї на його, і положиш на його ладан: се жертва хлїбна. ");
INSERT INTO ukr1871_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","І воскурить сьвященник частину його на спомин із зерна його й олїї його з усїм ладаном його: се жертва огняна Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","А коли приніс його жертва мирна: коли він приносить з товарини, самця чи самицю, без скази мусить принести Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","І положить руку свою на голову жертві своїй, та й заколе її коло входу в соборний намет, і набризкають крові на жертівника з усїх боків сини Аронові, сьвященники. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","І принесе він із жертви мирної на жертву огняну жир, що вкриває тельбухи, і ввесь жир, що на тельбухах, ");
INSERT INTO ukr1871_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","І обидві нирки й жир, що на їх, що по боках, і сальник над печінкою; з нирками віддїлити мусить він се. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","І воскурять се Аронові сини на жертівнику всепалення, на дровах, се є на вогнї: се огняна жертва, пахощі любі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Коли ж із отари приніс його в жертву Господеві, без скази барана чи ягницю мусить він принести. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Коли ягня приносить в жертву, так мусить принести його перед Господа; ");
INSERT INTO ukr1871_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","І положить він руку свою на голову жертви своєї та й заколе її перед соборним наметом; і набризкають сини Аронові крові його на жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","І мусить він принести з мирної жертви огняний приніс Господеві: жир її, ввесь курдюк до крижової костї оддїлить; і жир, що вкриває тельбухи. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","І ввесь жир, що на тельбухах, й обидві нирки, й жир, що на їх, та що по боках, і сальник на печінцї: з нирками він мусить оддїлити се. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","І воскурить сьвященник на жертівнику: се пожива огня, жертва Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","А коли приніс його буде коза, так мусить він привести її перед Господа; ");
INSERT INTO ukr1871_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","І положить він руку свою на голову її, та й заколе її перед соборним наметом; і набризкають сини Аронові крові на жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","І мусить він принести з сього приніс свій як огняну жертву Господеві: жир, що вкриває тельбухи й обидві нирки, й жир що на їх, ");
INSERT INTO ukr1871_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","І що по боках, і сальник над печінкою; з нирками мусить оддїлити се. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","І воскурить сьвященник на жертівнику: се пожива огняної жертви, на любі пахощі; ввесь жир Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Установа віковічня в роди ваші, по всїх осадах ваших: нї жиру, нї крові, щоб ви не їли. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","І рече Господь Мойсейові: Промов до синів Ізрайлевих так: ");
INSERT INTO ukr1871_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Коли яка душа согрішить ненароком проти которої заповідї Господньої, і зробить що небудь, чого не годиться робити, ");
INSERT INTO ukr1871_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Коли сьвященник помазаний согрішить і дасть привід людям, то за гріх свій, яким согрішив, нехай принесе бичка без скази як жертву за гріх Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","І приведе він бичка до входу в соборний намет, і положить руку свою на голову бичкові, та й заколе бичка перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","І возьме сьвященник помазаний бичкової крові, та й внесе до соборного намету; ");
INSERT INTO ukr1871_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","І вмочить сьвященник пучку свою в кров і бризне сїм раз перед Господом, перед завісою сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","І положить сьвященник крові на роги кадильного жертівника перед Господом, що в соборному наметї, а всю кров з бичка виллє до підніжка жертівника всепалення, що коло входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","А ввесь жир бичка жертви за гріх повиймає з його; ввесь жир, що вкриває тельбухи, і ввесь жир, що на тельбухах. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","І обидві нирки й жир, що на їх, що на стегнах, і сальник на печінцї; з нирками повіддїлає се, ");
INSERT INTO ukr1871_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Так, як виймається із товарини жертви мирної; і воскурить їх сьвященник на жертівнику всепалення. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","А шкіру з бичка й усе мясиво його з головою його, й ногами його, й з тельбухами його, і з калом його: ");
INSERT INTO ukr1871_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Всього бичка мусить винести геть з табору на чисте місце, де висипають попіл, та й спалить його на дровах огнем; де висипають попіл, спалять його. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Коли ж уся громада Ізраїля согрішить ненарочно, і втаєна буде справа від очей збору, а переступлять котру з усїх заповідей, зробивши, чого не повинні робити, і провинять, ");
INSERT INTO ukr1871_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","І гріх стане явний, котрим согрішили проти неї, тодї мусить громада принести бичка в жертву за гріх і приведе вона його перед соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","І положять громадські мужі руки свої на голову бичкові перед Господом, і буде заколений бичок перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","І принесе помазаний сьвященник, помазанець, крові з бичка в соборний намет, ");
INSERT INTO ukr1871_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","І вмочить сьвященник пучку свою в кров і бризне сїм раз перед Господом, перед завісю. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","І положить крові на роги жертівника всепалення, що коло входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","А ввесь жир оддїлить од його та й воскурить на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","І впорає бичка сього так, як порає бичка, що на жертву за гріх; так і мусить зробити з ним. І так зробить сьвященник покуту за них і проститься їм. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","І винесе бичка геть із табору та й спалить його, як спалив первого бичка. Се жертва за гріх громади. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Коли согрішить князь і переступить ненарочно одну з усїх заповідей Господа, Бога свого, зробивши чого не годиться робити, та й провинить, ");
INSERT INTO ukr1871_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","І виявиться йому гріх його, котрим согрішив, так мусить принести свою жертву, козла, самчика без скази. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","І положить він руку свою на голову козла, та й заколе його там, де заколюють жертву всепалення перед Господом: се жертва за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","І возьме сьвященник крові жертви за гріх пучкою своєю та й положить на роги жертівника всепалення, а кров його виллє до стояла жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","А ввесь жир його воскурить на жертівнику, як жир жертви мирної. І так зробить сьвященник покуту за гріх його і проститься йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Коли ж хто з простого люду согрішить ненарочно та й переступить одну з заповідей Господнїх, вдїявши чого не повинен чинити, та й провинить, ");
INSERT INTO ukr1871_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","І коли пізнає гріх свій, котрим согрішив, так нехай принесе жертву свою: козу без скази за гріх свій, що согришив ним. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","І положить руку свою на голову жертви за гріх, та й заколе жертву на місцї всепалення. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","І возьме сьвященник її крові пучкою своєю та й положить на роги в жертівника всепалення, а всю кров виллє до стояла в жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","І віддїлить увесь жир її, як оддїляють жир у жертви мирної, і воскурить сьвященник на жертівнику про любі Господеві пахощі. І таку покуту зробить сьвященник за його, і проститься йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","А коли принесе вівцю як приніс в жертву за гріх, нехай буде самиця без скази, що він приносить. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","І положить він руку свою на голову жертви за гріх та й заколе її як жертву за гріх на тому місцї, де заколюють жертву всепалення. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","І возьме сьвященник крові од жертви за гріх пучкою своєю та й положить на роги жертівника всепалення, а всю кров її виллє до стояла жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","А ввесь жир її оддїлить, як оддїляють жир у жертви мирної, і воскурить сьвященник його на жертівнику при палених жертвах Господеві; і так відправить сьвященник покуту за гріх його, що він согрішив, і проститься йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","А коли хто тим согрішить що чув голос клятьби і був сьвідком, чи то бачив се, чи знав се, коли не обявив того, так понесе на собі вину. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Або коли хто доторкнеться до чого нечистого, чи то стерва нечистого зьвіря, чи стерва скотини нечистої, чи стерва нечистої повзаючої животини, хоч не знав того, то зробивсь нечистим і провинив. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Або коли доторкнеться нечистоти людської, якої б нї було нечистоти, що від неї робляться нечистоти, хоч і не знав того, а потім довідається, то він провинив; ");
INSERT INTO ukr1871_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Або, коли покленеться хто, вимовляючи не роздумавши губами своїми, зробити що лихе чи добре, що б там не вимовила людина нерозумного в клятьбі своїй, та не знала того, а потім дознається, то він провинив у сьому. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","І має бути, коли він провинив чим небудь таким, так мусить признатись, чим согрішив він. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","І мусить принести Господеві за гріх свій, що согрішив, жертву довжну: самицю з отари, вівцю чи козу як жертву за гріх; а сьвященник відправить покуту за гріх його. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","А коли не спромога його на штуку дрібної скотини, так за провину свою, котрою провинився, мусить подати пару горлиць, або пару голубенят Господеві; одно на жертву за гріх а одно на жертвопаленнє. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","І подасть їх сьвященникові; а той принесе наперед те, що на жертву за гріх і скрутить головку йому над шиєю, та не віддїлить її. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","І побризкає кровю з жертви за гріх на боки жертівника, останок же крові виллє до стояла жертівника: се жертва за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","А друге принесе як жертвопаленнє по установі. І так відправить сьвященник покуту за гріх його, котрим согрішив, і проститься йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Коли ж і на пару горлиць або пару голубенят не стане його, так мусить подати на свій приніс, хто провинив, десятину ефи муки пшеничної на жертву за гріх; не класти ме на її олїї і не класти ме ладану, бо се жертва за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","І подасть її сьвященникові і возьме сьвященник із її жменю повну, як частку на спомин, та й воскурить на жертівнику при огняних жертвах Господеві: Се жертва за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","І відправить сьвященник покуту за гріх його, котрим провинив у де чому і проститься йому. Останок же буде сьвященникові, як хлїбова жертва. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Коли хто спроневіриться і ненароком согрішить проти сьвятощів Господнїх, такий мусить принести за свою провину як жертву Господеві барана без скази з отари, і по цїнуванню твойму срібла секелями, по секелю сьвятинї, на жертву за провину. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","А що согрішив проти сьвятого, те мусить віддати, та ще пятину додавши, і подати сьвященникові, і сьвященник відправить покуту за гріх його жертвуючи барана, і проститься йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","А коли хто согрішить і переступить котру заповідь Господню, вчинивши, чого не годиться чинити, хоч би не знав, то провинив, і гріх лежить на йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Такий нехай принесе барана без скази з отари, по цїнуванню твойму на жертву за провину; а сьвященник спокутує провину його, котрою провинився не знавши; і проститься йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Се жертва за провину; існо він провинив перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","Коли хто согрішить і спроневіриться проти Господа, і запирається перед ближнїм своїм в тому, що повірено йому на схованку яке добро, чи то пожичив він чи вкрав; або коли видусить що в ближнього свого, ");
INSERT INTO ukr1871_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","Або знайде загублене та й відпирається того; і кленеться льживо про що б нї було, що люди творять і грішать: ");
INSERT INTO ukr1871_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","Тоді мусить: коли чоловік согрішив і провинив бути так, щоб вернув пожаковане, що пожакував, чи видушене, що видусив, чи повірене, що повірено йому, чи то загублене, що він знайшов; ");
INSERT INTO ukr1871_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Чи щоб нї було воно, про що клявся льживо, ");
INSERT INTO ukr1871_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Нехай виплатить сповна, та ще й пятину додасть до того; оддавати ме тому, чиє воно, того дня, як приносити ме жертву за провину. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","І подасть жертву за провину свою Господеві, барана без скази з отари по цїнуванню твойму, на жертву сьвященникові. ");
INSERT INTO ukr1871_vpl VALUES ("LV5_27","004_5_27","LEV","5","27","27","І очистить сьвященник гріх його перед Господом, і проститься йому, що б нї було, в усьому, що вкоїв провинивши. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Повели Аронові й синам його: От вам закон жертвопалення: Жертва всепалення нехай зостанеться на жертівнику всю ніч до ранку; а вогонь на жертівнику мусить горіти на йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","І надїне сьвященник ризу льняну, і спідну одїж льняну надїне на тїло своє; і здійме попіл, що зіставсь од жертви, що пожер огонь, та й положить коло жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Потім скине шати свої, надїне иншу одїж, та й винесе попіл із табору, на чисте місце. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Огонь же на жертівнику мусить горіти, не згасати; і буде запалювати сьвященник на йому дрова що ранку, і покладати на йому жертву всепалення; і закурювати на йому куснї мирних жертв. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Вогонь мусить безустанно горіти на жертівнику не згасаючи. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","А се закон про жертви хлїбні: Приносити мусить їх один із синів Арона перед Господом, до жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","І мусить він взяти з приносу жменю муки й олїї й увесь ладан, що на приносї хлїбному, та й закурити на жертівнику: се пахощі любі, частина на спомин Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Останки ж жертви їсти муть Арон та сини його; прісне їсти муть у сьвятому місцї; в дворі соборного намету їсти муть. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Не годиться пекти його заквашеним; як частину їх даю їм від жертвопалення мого: Се велика сьвятиня, як жертва за гріх і як жертва за провину. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Увесь музький пол між синами Ароновими їсти ме її. Установа віковічня в роди ваші про жертвопаленнє Господнє. Все, що доторкнеться до них, осьвятиться. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Се приноси від Арона й синів його, що мусять вони приносити Господеві в день помазаня свого: десятину ефи муки пшеничної в жертву повсячасну, половину того рано, а поливину того в вечір. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","На сковородї в олїї щоб пряжено його, поливане олїєю принесеш його; спечені куски жертви хлїбної принесеш як любі пахощі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","І сьвященник із синів його помазаний намість його мусить се приносити; установа віковічня: Вся жертва буде спалена Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","І всяку хлїбну жертву сьвященника мусите до крихти палити; не можна їсти її. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Промов до Арона й синів його: Се закон про жертву за гріх: там де заколюють жертву всепалення, заколювати меться жертва за гріх перед Господом: се велика сьвятощ. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Сьвященник, що приносить жертву за гріх, їсти ме її; в сьвятому місцї мусять їсти її, в дворі коло соборного намету. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Усе, що доторкнеться до мясива її, осьвятиться; і коли бризне крові її на одежу, те, на що бризнуло, мусиш випрати на сьвятому місцї. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","І посудину глиняну, що в їй варено її, треба розбити, а коли в посудинї мідянїй варено її, так треба витерти й виполоскати водою. ");
INSERT INTO ukr1871_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Увесь музький пол у сьвященників їсти ме її: се велика сьвятощ. Нїякої ж жертви за гріх, що кров з неї вносять у соборний намет, щоб спокутувати гріх у сьвятинї, не годиться їсти. На огнї палити її. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","А се закон про жертву за провину; велика се сьвятощ. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","На тому місцї, де заколюють жертву всепалення, треба заколювати жертву за провину; і крові з неї треба набризкати на жертівник з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","І ввесь жир треба приносити від неї, курдюк і жир, що вкриває тельбухи. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","І обидві нирки, й жир, що на них, що на боках, і сальник, що на печінцї: з нирками треба віддїляти його. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","І воскурить їх сьвященник на жертівнику як огняну жертву Господеві: се жертва за провину. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Увесь музький пол у сьвященників їсти ме її; на сьвятому місцї треба їсти її: се велика сьвятощ. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Як про жертву за гріх, так і про жертву за провину закон один. Котрий сьвященник покутує нею гріх, тому вона буде. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","І котрий сьвященник приносити ме чию жертву всепалення, кожа з усепалення, що принесе він, буде йому, сьвященникові. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","І всякий хлїбний дар, що спечено в печі, й усе зготовлене в горшку і пряжене на сковородї: сьвященникові, що його приносить, йому воно буде. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","І всякий хлїбний дар, змішаний з олїєю або сухий, про всї сини Аронові буде, як про одного так і про другого. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","А се закон про жертву мирну, що приносять Господеві: ");
INSERT INTO ukr1871_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Коли як подяку приносить її хто, так треба принести з жертвою подячною коржі прісні, замішані на олїї, та ладки прісні, помащені олїєю, і муку пшеничну, замішану на олїї: балабушки политі олїєю. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Опріч коржів з квашеного хлїба приносити мусить свій дар, вкупі з своєю жертвою подячною мирною. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","І приносити мусить він одно з усього того дару як жертвоприношеннє Господеві; се буде сьвященникові, що бризкає кров мирної жертви, йому воно буде. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","І мясиво з жертви подячної, мирної, його треба їсти в день приносин; не зоставить нїчого до ранку з його. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","А коли приніс його буде обітниця чи добровільна жертва, так того ж дня треба їсти його, а останок треба завтрішнього дня поїсти; ");
INSERT INTO ukr1871_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Що ж останеться з мясива жертви на третїй день, треба спалити на огнї. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","А коли їсти муть мясиво з жертви мирної на третїй день, не прийметься вона і нї за що поставиться тому, хто принїс її: гидота буде; і душа, що їла її, візьме на себе гріх. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Мясива ж того, до котрого доторкнеться що нечистого, не треба їсти, на огнї нехай згорить воно. Що ж до чистого мясива, то кожен чистий може їсти його. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","А душа, що зʼїла мясива від жертви мирної, що буде Господеві, і бувши сама нечистою, викорениться душа та зміж людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","І коли душа доторкнеться до чого нечистого, до нечистоти людської, чи до нечистої скотини, чи до нечистої огиди, та й попоїсть мясива з жертви мирної, ся душа викорениться зміж людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Промов до синів Ізрайлевих і скажи: Нїякого туку товарини, чи з овечок і кіз, не їсти мете. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Тук із стерва і тук з того, що зьвір роздере, можна вам брати на потріб в усякій роботї, а їсти зовсїм вам не можна. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Всяка бо душа, що їсть тук із скотини, котру приносять в огняну жертву Господеві, викорениться зміж людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","І нїякої крові не їсти мете по всїх осадах ваших, чи з птаства чи із скотини. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Всяка душа, що попоїсть якої крові, тая душа викорениться зміж людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Промов до синів Ізрайлевих і скажи: Хто приносить жертву мирну свою, мусить подати Господеві свій дар від жертви мирної своєї. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Рука його подасть огняну жертву Господеві; тук з погруддєм мусить подати: погруддє, щоб принести його як жертву гойдану перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","І воскурить сьвященник тук на жертівнику, а погруддє буде Аронові й синам його. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","А лопатку праву вашої жертви мирної оддавати мете як дар гойданий сьвященникові. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Которий зміж синів Аронових приносить кров із мирної жертви і тук, тому буде лопатка права як пай. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Погруддє бо гойданої жертви і лопатку жертвоприношення взяв я у синів Ізрайлевих від мирних жертов їх, та й оддав їх Аронові сьвященникові і синам його як вічну пайку їх від синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Се пай мировання Аронові і пай мировання синам його від огняних жертов Господнїх, призначений їм з того дня, як допущено їх сьвященниками до служби Господеві, ");
INSERT INTO ukr1871_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Котрого заповідав Господь синам Ізрайлевим давати їм того дня, як помазано їх: Установа віковічня в роди ваші. ");
INSERT INTO ukr1871_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Се закон про жертву огняну, хлїбну і про жертву за гріх і про жертву за провину, і про жертву благальну і жертву мирну, ");
INSERT INTO ukr1871_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Що заповідав Господь Мойсейові на Синай горі того дня, як велїв синам Ізрайлевим приносити дари Господеві, в степу Синай. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Возьми Арона й синів його з ним і шати і миро і бичка на жертву за гріх і два барани і кошик опрісноків, ");
INSERT INTO ukr1871_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","І збери всю громаду до входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","І вчинив Мойсей, як заповідав йому Господь, і зібралась громада до входу соборного намету. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","І промовив Мойсей до громади: Ось що заповідав Господь учинити. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","І велїв Мойсей приближитись Аронові і синам його, та й пообливав їх водою. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","І надїв на його хитон, і підперезав його поясом, і окрив його верхньою ризою, і накинув на його оплїчника та й підперезав його мережаною крайкою наплїчника і підвязав на йому оплїчника; ");
INSERT INTO ukr1871_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","І повісив на його нагрудника і положив на нагруднику урім і тумім. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","І наложив кедар на голову йому, і причіпив до кедара, з переду його, золоту бляху, сьвяту диядему, так як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","І взяв Мойсей мира, і помазав храмину і все, що було в нїй, і осьвятив її. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","І бризнув на жертівника сїм раз і помазав жертівника і всю посудину його. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","І злив мира на голову Аронові, та й помазав його, щоб осьвятити його. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","І казав Мойсей приступити синам Ароновим, і повдягав їх у хитони, і попідперізував їх поясами, і понакладав на них клобуки: як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","І привів бичка, що на жертву за гріх; і положили Арон і сини його руки свої на голову бичка, жертви за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","І заколов його, і взяв Мойсей крові, і положив на роги жертівника з усїх боків пучкою своєю, і розгрішив жертівника; а кров вилив до стояла жертівника і осьвятив його, відправивши покуту за його. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","І взяв увесь жир, що на тельбухах, і сальник на печінцї, й обидві нирки, і жир їх, і воскурив все те Мойсей на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Бичка же і шкіру його і мясиво його і кал його попалив на вогнї за табором; як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","І привів ще барана на огняну жертву; і положили Арон і сини його руки свої на голову барана. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","І заколов його, і побризкав Мойсей крові на жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","А барана подїлив на частки, і воскурив Мойсей голову і частки й жир; а тельбухи і ноги виполоскав у водї. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","І пустив Мойсей димом усього барана на жертівнику: се було жертвопаленнє про любі пахощі, огняна жертва Господеві, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","І привів барана другого, барана посьвятного, і положили Арон і сини його руки на голову барана. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","І заколов його, і взяв Мойсей крові та й положив на пучку правого вуха Аронові, і на великий палець руки його правої, і на великий палець ноги його правої. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","І казав приступити синам Ароновим, і положив Мойсей крові на пучку в ушах їх правих, і на великий палець рук їх правих, і на великий палець ніг їх, і набризкав Мойсей крові на жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","І взяв жир і курдюк і ввесь жир, що на тельбухах і сальник на печінцї, й обидві нирки і жир їх, і лопатку праву. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","А з кошика опрісноків, що стояли перед Господом, узяв одного опріснока і одного коржа хлїба олїйного та й одну ладку, і положив на масні куснї і на праву лопатку; ");
INSERT INTO ukr1871_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","І передав усе разом на руки Аронові і на руки синам його, і принїс гойдану жертву перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","І взяв те Мойсей з рук їх та й пустив з димом на жертівнику всепалення: була се жертва посьвятна на любі пахощі, огняна жертва Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","І взяв Мойсей погруддє і принїс жертву гойдану перед Господом; була се частка Мойсейова від посьвятного барана, як повелїв Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","І взяв Мойсей оливи до помазання та крові, що була на жертівнику, і покропив Арона, одїж його і одїж синів його з ним, і осьвятив Арона і одїж його, і синів його і одїж синів його з ним. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","І рече Мойсей Аронові й синам його: Зваріть мясиво коло входу в соборний намет і зʼїжте його там із хлїбом, що в кошику для жертви посьвятної, як я велїв, казавши: Арон і сини його їсти муть. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Останок же з мясива і тук мусите спалити вогнем. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Від входу ж у соборний намет не відходити мете сїм день, аж поки не скінчаться днї жертви посьвятної: бо сїм день буде він висьвячувати вас. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Як чинив сьогодні, заповідав Господь чинити, щоб відбути покуту за вас. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","І жити мете коло входу в соборний намет і день і ніч сїм діб, і пильнувати мете заповідї Господнї, щоб не померти вам; так бо наказано менї. ");
INSERT INTO ukr1871_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","І вчинили Арон і сини його все, що заповідав Господь через Мойсейя. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","І сталось на восьмий день, покликав Мойсей Арона й сини його і мужі громадські Ізрайлеві, і каже Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Возьми про себе молоде теля на жертву за гріх та барана без скази на всепаленнє, та й принеси перед Господа. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","А до синів Ізрайлевих промовляти меш кажучи: Возьміть козла на жертву за гріх, а теля й ягня, однолітків, без скази на жертвопаленнє. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Та бугая та барана на мирну жертву, щоб жертвувати перед Господом; і жертву хлїбну, замішану на олїї; сьогоднї бо Господь явиться вам. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","І принесли те, що повелїв Мойсей, перед соборний намет, і приступила вся громада і стала перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","І рече Мойсей: Ось те, що заповідав Господь вам чинити; і явиться вам слава Господня. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","І рече Мойсей Аронові: Приступи до жертівника та принеси твою жертву за гріх і жертву всепалення, і зроби покуту за себе і за людей; і жертвуй приноси людські і зроби покуту за них, як заповідав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","І приступив Арон до жертівника, і заколов теля жертву за гріх, що було за його. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","І подали сини Аронові кров йому, і вмочив він пальця свого в кров і положив на роги жертівника, і вилив кров до стояла жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","А жир і нирки і сальник од печінки жертви за гріх пустив з димом на жертівнику, як заповідав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","А мясиво й шкіру спалив на вогнї за табором. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","І заколов всепаленнє; і подали сини Аронові кров йому, і покропив нею жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","І жертву всепалення подали йому, з частками її, і голову, і пустив з димом на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","І виполоскав тельбухи й ноги та й пустив з димом на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","І принїс жертву від людей, і взяв козла жертву за гріх, що був за людей, і заколов його, і принїс його жертву за гріх, так само як перву. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","І принїс жертву огняну і жертвував по установі. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","І принїс жертву хлїбну, і сповнив нею руки свої та й пустив з димом на жертівнику, опріч ранїшної огняної жертви. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","І заколов бугая, та барана, жертву мирну, що була за люде. І подали сини Аронові крові йому, і окропив нею він жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","І взяв тук із бугая та з барана, курдюк і те, що вкриває тельбухи і нирки і чепець з печінки; ");
INSERT INTO ukr1871_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","І положили тук на погруддє, і він пустив з димом на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","І куснї погруддя і праву лопатку принїс Арон як гойдану жертву перед Господом, так як велїв Мойсей. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Тодї зняв Арон руки до людей, і благословив їх; та й зійшов униз після того, як принїс жертву за гріх і жертву всепалення і жертву мирну. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","І ввійшли Мойсей та Арон у соборний намет; і вийшли та й благословили людей. І явилася слава Господня всьому людові. ");
INSERT INTO ukr1871_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","І вийшло поломя сперед Господа, і пожерло на жертівнику жертву всепалення й куснї жиру; і вбачали всї люде, і загукали з радощів та й попадали на лиця свої. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","І взяли сини Аронові, Надаб і Абігу кожен кадильницю свою та положили жару в них, і посипали на жар кадила та й почали приносити перед Господом огонь чужоземнїй, чого він їм не заповідав. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","І вийшло сперед Господа поломя та й пожерло їх, і померли вони перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","І рече Мойсей Аронові: Оце ж і сталось те, що глаголав Господь: В тих, що приближаються до мене, осьвячусь, і перед усїм народом прославлюсь. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","І мовчав Арон. І покликав Мойсей Мизаїла та Ельзафана, синів Узіїла, дядька Аронового, і сказав їм: Приступіть і винесїть братів ваших із сьвятинї за табір. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","І приступили вони, та й віднесли їх у хитонах їх за табір, як повелїв Мойсей. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","І рече Мойсей Аронові і Єлеазарові й Ітамарові, синам його: Клобуків з голов ваших не скидайте і одежі вашої не шарпайте, щоб не померти вам, і Господь не розлютився на всю громаду; а нехай ваше браттє, ввесь дом Ізрайлів плачуть за погорівшими огнем, що запалив Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Із входу в соборний намет не виходити мете, щоб не вмерти вам; бо миропомазаннє Господнє на вас. І вчинили вони по слову Мойсейовому. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","І рече Господь Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Вина й хмелевих напитків не пий, нї ти сам нї сини твої з тобою, як треба вам увійти в соборний намет, щоб не вмерти вам. Установа віковічна в роди ваші, ");
INSERT INTO ukr1871_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","І щоб розбирати вам між тим, що сьвяте, і тим, що не сьвяте, між тим, що чисте, і що не чисте, ");
INSERT INTO ukr1871_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","І навчати синів Ізрайлевих всїх установ, що дав їх Господь вам через Мойсея. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","І рече Мойсей Аронові й Єлеазарові й Ітамарові, синам його, що зостались: Возьміте приніс хлїбний, що зіставсь од огняної жертви Господньої та й їжте його прісним коло жертівника; се бо велика сьвятощ. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","І їсти мете його в сьвятому місцї: бо се пай твій і пай синів твоїх з огняних жертов Господеві; так бо заповідано менї. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Погруддє ж жертви гойданої і лопатку жертви підношеної мусите їсти на чистому місцї, ти й сини твої й дочки твої з тобою: се бо пай твій і пай синів твоїх, призначений із жертов мирних у синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Лопатку жертви підношеної і грудину жертви гойданої, пускаючи з димом жир, мусите приносити вкупі з огняними жертвами, щоб гойдати їх як жертву гойдану перед Господом, і буде се тобі і синам твоїм з тобою пай віковічнїй: так бо заповідав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","І Мойсей шукав пильно козла, що принесено як жертву за гріх, аж се його спалено. І розгнївався на Єлеазара та Ітамара, синів остальнїх Аронових і рече: ");
INSERT INTO ukr1871_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Чом не ззїли ви жертви за гріх на місцї сьвятому? се ж бо сьвятощ між сьвятощами, і він дав се вам, щоб узяли на себе гріхи громади та спокутували їх перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ось крові з неї не внесено в сьвятиню; доконьче треба було вам ззїсти її в сьвятинї, як повелївав я. ");
INSERT INTO ukr1871_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","І сказав Арон до Мойсея: Дивись, приносили вони сьогоднї жертву свою за гріх та всепаленнє своє перед Господом, і таке лучилось менї! А коли б я сьогоднї їв жертву за гріх, чи гаразд воно було би в очах Господа? ");
INSERT INTO ukr1871_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Вислухав се Мойсей, і було се добре в очах його. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","І рече Господь Мойсейові й Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Промовте до синів Ізрайлевих і скажіть їм: Оце така скотина, що можна вам їсти з усьої скотини, що є на землї: ");
INSERT INTO ukr1871_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Усяку скотину, що в неї ратицї розколені і між ратицями розколина глибока і вона ремигає, таку можна вам їсти. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ось яких тільки неможна вам їсти з тих, що ремигають, а ратицї в них роздїлені: верблюда, дарма що ремигає, та ратицї у його нероздїлені; нечистий він вам буде. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","І крілика, що хоч і ремигає, та немає копит роздїлених; нечистий він вам буде; ");
INSERT INTO ukr1871_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","І зайця, що ремигає, та немає ратиць роздїлених; нечисий він вам буде. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","І свиню, що хоч у неї ратицї розколені та й зовсїм розколені ратицї, але вона не ремигає; нечиста вона вам буде. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Мясива їх не їсти мете, падалї ж їх не торкати метесь; нечисті вони вам будуть. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","З усього ж, що в водах, можна вам їсти: все, що має сплавки і луску, що в водах, у морях і в ріках, можна вам їсти; ");
INSERT INTO ukr1871_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","А все, що немає сплавок і луски в морях і ріках, усе, що кишить у водах, і всяка животина, що в морю, вони будуть вам гидотою. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","І гидкі вони мусять бути вам: мясива їх не їжте і падаль їх уважайте за гидоту. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Усе, що без сплавок і луски в водї, буде гидотою вам. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Оце ж ті, що вважати мете гидкими з птаства; неможна їх їсти, вони гидь: орел, коршак, і морський орел, ");
INSERT INTO ukr1871_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","І пугач, і сокіл з породою його, ");
INSERT INTO ukr1871_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","І всякий ворон з породою його. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","І стровус, і чайка, і яструб з породою його. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","І сова, і рибалка та ібис, ");
INSERT INTO ukr1871_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","І лебедь, і пеликан, і сич, ");
INSERT INTO ukr1871_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","І бузьок і чапля з породою її, й вудвод, і нетопир. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Усе крилате, і ходюче на чотирох, гидота вам буде. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Тільки тих можна їсти зміж усьої крилатої животини, що ходить на чотирох ногах: що має литки над ногами, щоб скакати по землї. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ось яких ізміж їх можна вам їсти: сарану з породою її, коники всякі, і скакуни всякі з породою їх, та хрущі всякі з породою їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","А всяка инша крилата животина, що на чотирох ногах, буде гидотою вам. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","І від них нечистими робити метесь: хто торкнеться стерва їх, нечистим стане до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","І хто нести ме частку трупа їх, мусить випрати одїж свою, і буде нечистим до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Всяка скотина, що має ратицї та не зовсїм розколені ратицї і не ремигає: гидота вам; хто торкнеться об неї, буде нечистим. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","І все ходюче на лапах між усїм животним, що на чотирох ногах, нечисте вам буде; хто торкнеться об трупа їх, буде нечистий до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","А хто нїс їх трупа, мусить випрати одїж свою і буде нечистий аж до вечора; нечисті вони вам. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","І сї нечисті вам з животини лазючої по землї: кріт, і миш, і ящірка з породою своєю, ");
INSERT INTO ukr1871_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","І анака, і коах, і летах, і хомет, і хамелон, ");
INSERT INTO ukr1871_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Сї нечисті вам зміж усїх повзючих; хто торкнеться об них здохлих, кожен буде нечистий аж до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","І все, на що одно з них впаде, коли воно здохле, буде нечисть; усяка посудина деревяна, чи одїж, чи шкіра, чи торба, чи знаряддє яке, що ним що робиться, треба класти в воду і будуть нечисті до вечора, а потім чисті будуть. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","І всяка посудина черепяна, що до неї впаде которе з них: усе, що є в нїй, буде нечистим, а її треба розбити. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","І всяка їда, що їдять, коли хлюпне на неї вода з такої посудини, буде нечиста: і всякий напиток, що пють його, буде в такій посудинї нечистим. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","І все, на що впаде частина трупу їх, нечистим стане; піч і припічок мусять розібрати; нечисті вони, і нечисті мусять бути вам. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Тільки криниця та колодязь, та всякий водозбір, чисті будуть; хто ж торкнеться об їх трупа, буде нечистий. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","А коли впаде частка їх трупа на яке посїяне насїннє, що треба сїяти, чисте буде воно. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","А коли в водї намочено насїннє, та впаде частина трупа їх на його, нечистим буде воно вам. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","А коли здохне яка скотина, що можна вам їсти, хто торкнеться падла її, буде нечистий аж до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","І хто нїс падло її, мусить випрати одїж свою, і буде нечистий аж до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","І кожне з гаду повзаючого по землї, се гидь; неможна його їсти. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Все що повзає на череві, і все що ходить на чотирох, і все многоножне між всякою животиною, що повзає по землї, не їсти мете, вони бо гидота. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Не паскудьте себе жадною повзаючою животиною, і не робіть себе нечистими через них, щоб не опоганитись вам ними. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Я бо Господь, Бог ваш; тим то й осьвячуйте себе і будьте сьвятими, я бо сьвятий. І не опоганюйте себе животиною, що повзає по землї. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Я бо, Господь, вивів із Египецької землї вас, щоб вашим Богом бути, і мусите бути сьвятими: я бо сьвятий. ");
INSERT INTO ukr1871_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Се закон про скотину, і про птаство, і про всяку животину, пливаючу у водї і про животину повзаючу по землї, ");
INSERT INTO ukr1871_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Щоб робити ріжницю між нечистим і чистим, і між животиною їдомою і животиною, що не можна їсти. ");
INSERT INTO ukr1871_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","І рече Господь Мойсейові: Промов до синів Ізрайлевих і кажи: ");
INSERT INTO ukr1871_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Коли жінка буде при надїї і вродить хлопятко, так нечистою буде вона сїм день; як у днї нечистої недуги буде вона нечистою. ");
INSERT INTO ukr1871_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","А восьмого дня обріжуть крайню шкірочку в його. ");
INSERT INTO ukr1871_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","І трийцять три днї мусить вона пробувати в кровочищенню своїм, нї до чого сьвятого не доторкатись, і до сьвятинї не приходити, покіль минуться днї очищення її. ");
INSERT INTO ukr1871_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","А коли вродить дївчатко, нечистою буде два тижнї, як в днї нечистої недуги своєї, і шістьдесять шість день перебувати мусить дома в кровочищенню своїм. ");
INSERT INTO ukr1871_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Як же сповняться днї очищення її, за сина чи за доньку, мусить принести ягня річняка на всепаленнє та голубеня чи горлицю на жертву за гріх до входу в соборний намет сьвященникові. ");
INSERT INTO ukr1871_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","І принесе він се перед Господом і відправить покуту за гріх її та й очистить од кровотоку її. Се закон для роджаючих, чи буде хлопятко чи дївчинка. ");
INSERT INTO ukr1871_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","А коли не спромога її на дрібну скотину, дак мусить вона взяти пару горлиць або пару голубенят, одно про всепаленнє і одного про жертву за гріх. І відбуде сьвященник покуту за гріх її і очиститься. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","І рече Господь Мойсейові та Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Коли буде під шкірою на тїлї чоловіка напухлина, чи струп чи пляма, і буде на шкірі тїла його болячка, так мусять привести його до Арона, сьвященника, або до которого з синів його, сьвященників. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","І огляне сьвященник болячку під шкірою на тїлї, і як волоссє над болячкою побілїє і болячка буде глубше як шкіра тїла, то се проказа. І оглянувши його, обявить сьвященник нечистим його. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","А коли тільки пляма під кожою тїла його побілїє і не буде глибша вона як шкіра, і волоссє не побілїє, тодї зачинить сьвященник того, у кого є болячка, на сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Та й огляне його сьвященник семого дня, і побачить, що болячка не змінилась, не роскинулась по шкірі, так зачинить його сьвященник на сїм день удруге. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","А як огляне його сьвященник семого дня удруге, і поблїдла болячка і не розкинуло її по шкірі, то обявить його сьвященник чистим: се струп; і мусить випрати одїж свою, і буде чистий. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Коли ж буде розкидати струпи по кожі після того, як оглянув його сьвященник і обявив чистим, так нехай покажеться сьвященникові в друге; ");
INSERT INTO ukr1871_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Огляне ж його сьвященник, і побачить, що струп розкинувся по кожі, то нечистим обявить його сьвященник: се проказа. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Коли буде на людинї проказа, так нехай приведуть її до сьвященника. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","І огляне його сьвященник, і побачить, се пухлина біла на кожі і побілїв від неї волос на кожі, і дике мясиво на пухлинї, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","То се проказа застаріла на кожі тїла його, і нечистим обявить його сьвященник; і зачинить його, бо людина нечиста. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Коли ж обкине кожу проказа і вкриє проказа всю кожу недужого з голови до ніг, куди б і не глянули очі сьвященника; ");
INSERT INTO ukr1871_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","І сьвященник огляне його, і бачить, що проказа все тїло його вкрила, так обявить людину чистою; коли вся вона побілїла, то людина чиста. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Коли ж показується на їй дике мясиво, людина нечиста. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","І як побачить сьвященник дике мясо, то нечистою обявить людину; мясо дике нечисте: се проказа. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Коли ж зміниться мясиво дике й стане біле, так мусить людина показатися сьвященникові; ");
INSERT INTO ukr1871_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","І огляне її сьвященник, та й побачить що болячка білою стала: то чистим обявить сьвященник того, в кого болячка: він чистий. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Так само, коли буде боляк на тїлї, під шкірою його, та й загоїться, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","А на місцї боляка зробиться пухлина біла, чи біло-червонява пляма, то має показатись сьвященникові; ");
INSERT INTO ukr1871_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","І огляне його сьвященник, та й побачить, що воно глибше кожі і волос на йому взявся білим, так нечистим обявить його сьвященник: се недуга прокази, що показалась в болячцї. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","І огляне людину сьвященник, та й побачить, що нема на кожі волосу білого і пляма не нижше кожі, так зачинить людину сьвященник на сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","А коли розкинеться пляма по кожі, то нечистим обявить його сьвященник: се хороба. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Коли ж на свойму місцї останеться пляма, не розкинувшись, так се пруг чиряка; і чистою обявить людину сьвященник. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Або коли на кожі тїла буде опечина від огню, і зробиться з опечини пляма біло-червонява або біла, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","І огляне людину сьвященник, і побачить, се побілїв волос на плямі і на погляд вона глибше від кожі, то се проказа; вона взялась на опечинї, і нечистою обявить людину сьвященник: се болячка прокази, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","А як огляне її сьвященник, і побачить, що нема на плямі білого волосся, та не глибше кожі вона, та блїда, так зачинить людину сьвященник на сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","І огляне її сьвященник на семий день; коли роскинулось по кожі, так нечистою обявить людину сьвященник: се болячка прокази. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Коли ж на свойму місцї останеться пляма, і не розкинуло її по кожі і сама блїда, так се пухлина опеченого місця, і чистою обявить людину сьвященник; бо се пруги опеченого місця. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","І коли в чоловіка чи в жінки яка болячка на голові чи на бородї, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","І сьвященник огляне, та й побачить, що вона глибше від кожі і на їй волоссє жовтовате, тонке, то нечистою обявить людину сьвященник: се пархи, се проказа на голові, чи на бородї в людини. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","І як огляне сьвященник паршиву болячку, та й побачить, що вона не глибше кожі і нема на їй чорного волосу, так зачинить сьвященник паршивого на сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","І коли огляне сьвященник паршиву болячку семого дня, та й побачить, що не роскинуло пархи, і нема на них волосу жовтявого, і на погляд пархи не глибші від кожі, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","То нехай обстрижеться; але пархів нехай не стриже; і сьвященник зачинить на сїм день удруге. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","І огляне сьвященник пархи на семий день, та й побачить, що не розкинулись пархи по кожі, і на погляд не глибше вони кожі, так обявить людину чистою сьвященник; і випере вона одїж свою, та й буде чиста. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","А коли після того, як очиститься, стане розкидати пархи по кожі, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","І сьвященник огляне його, та й побачить, що пархи розкинулись по кожі, то не буде сьвященник шукати волосу жовтявого: нечиста се людина. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","А коли, на його погляд, пархи остались на місцї, і волос чорний поріс по них, то вигоїлась людина з пархів; чиста вона, і чистою обявить її сьвященник. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Так само коли в чоловіка чи в жінки появляться на кожі тїла їх плїші, біляві плями, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","І сьвященник огляне їх, та й побачить, що на кожі тїла їх бліді, біляві плями, то се лишай, що показався на кожі: се чиста людина. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","А коли в кого повилазить волоссє, то лисоголовий він: він чистий. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","І коли вилїзе волоссє спереду на голові, то він лисий: чист він. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Коли ж на лисинї переднїй або заднїй будуть біло-червонясті плїші, то се проказа на переднїй або заднїй лисинї в його. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","І огляне його сьвященник, і побачить, що напухлина недуги біло-червоняста на лисинї його переднїй або заднїй така, якою показується проказа на кожі тїла, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","То він чоловік прокажений: нечистий він, і сьвященник мусить обявити його зовсїм нечистим: язва його на голові його. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","І одїж прокаженого, в кого недуга, мусять порозбирати, і голова його мусить бути непокрита, і по бороду мусить він закутатись, і кричати ме він: нечистий, нечистий! ");
INSERT INTO ukr1871_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Докіль болїсть його, буде він нечистим; він нечистий: самотою жити мусить він; за табором оселя його. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Коли й на одежинї буде яка зараза, на вовняній, чи на одежинї льнаній; ");
INSERT INTO ukr1871_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Чи на основинї, чи на переплїтцї льняній чи вовняній, чи на смушах, чи на якій кожушинї, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","І чи буде зараза зеленява, чи червоняста на одежинї, на шкірі, чи на основинї, чи на переплїтцї, чи на якій роботї кожушній, се хороба прокази, і мусять показати сьвященникові. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","І огляне сьвященник заразу, та й зачинить те, на чому хороба, на сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","І коли побачить заразу семого дня, що вона розкинулась по одежинї, чи по основинї, чи по переплїтцї, чи по шкірі, та що нї було б зроблене із шкіри, се хороба та пожираюча проказа: се язва, нечисте воно. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","І мусить спалити одежину, чи основину, чи переплїтку, чи вовняне, чи льняне, чи яка б нї була робота шкіряна, що зараза на нїй: бо се проказа пожираюча: на вогнї мусять спалити. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","А як огляне сьвященник, і побачить, що проказа не розкидається по одежинї, чи по основі, чи по переплїтцї, чи по якій роботї шкіряній, ");
INSERT INTO ukr1871_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","То звелить сьвященник, щоб випрали те, на чому зараза, та й зачинить його на сїм день у друге. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","І огляне сьвященник, після того, як виперуть, і побачить, що незмінилась видом проказа, хоч і не розкинулась, то нечисте воно; в огнї спалити мусиш його: струпішіє воно, чи на лицевій чи на виворітній сторонї. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","А коли огляне сьвященник, і побачить, що зараза поблїдля після прання, так мусить віддерти її від одежини, чи від шкіри, чи від основини, чи від переплїтки. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Коли ж покажеться вона знов на одежинї, чи на основинї, чи на тканю, чи на якій роботї шкіряній, то се повстаюча зараза; на огнї мусиш те спалити, на чому зараза; ");
INSERT INTO ukr1871_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Одежину ж, чи основину, чи переплїтку, чи яку роботу шкіряну мусиш випрати. Коли зараза минеться, так випрати вдруге, і буде чисте. ");
INSERT INTO ukr1871_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Се закон про хороби прокази на вовняній одежинї, чи на льняній, чи на основинї, чи на втоцї, чи на якій роботї шкіряній, щоб обявити їх чистими або нечистими. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Се буде законом для прокажених в день очищення його, ");
INSERT INTO ukr1871_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Приведуть його до сьвященника, і вийде сьвященник геть із табору, і огляне сьвященник, і побачить, що вигоїлась проказа в прокаженого. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","І звелить сьвященник взяти для того, хто має очиститись, пару птиць живих і чистих і дерева кедрового та кармазину й гисопу. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","І звелить сьвященник заколоти одну птицю в черепяній посудинї над живою текучою водою. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Живу ж пташку візьме і дерево кедрове й кармазин і гисоп та й умочить все те і живу пташку в кров зарізаної пташки над живою водою. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","І бризне на того, хто очищається од прокази, сїм раз, та й обявить його чистим, і випустить живу пташку в поле. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","І повипирає той, хто очищається, одїж свою, і обстриже волоссє на собі, і сам викупається в водї; і він чистий. А тоді вже можна йому прийти в табір, та мусить прожити знадвору намету свого сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","І станеться на семий день, що обстриже він волоссє на собі і бороду свою й брови свої. Все волоссє на собі мусить пообстригати; і повипирає одїж свою, і викупає все тїло своє в водї, і стане чистий. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","А на восьмий день візьме двойко ягнят без скази й одно ягня, овечку однолітку без скази та три десятинї ефи муки на приніс, змішаної з олїєю, та один лог олїї. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","І поставить сьвященник, котрий очищає, людину що очищається, і се все перед Господом коло входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","І візьме сьвященник ягня одно та й принесе його як жертву за провину з логом олїї, і принесе їх як жертву гойдану перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","І заколе ягня в тому місцї, де заколюють жертву за гріх і жертву всепалення, в місцї сьвятому; бо як жертва за гріх, так буде і жертва за провину сьвященникові; велика сьвятощ. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","І візьме сьвященник крові з жертви за провину, та й положить на пучку правого вуха в того, що очищається і на великий палець на правій нозї його. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","І візьме сьвященник од лога олїї та й наллє собі на лїву долоню. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","І вмочить сьвященник палець свій правий в олїю, що в лївій долонї його, та й бризне олїї пальцем своїм сїм раз перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","З олїї ж, що зісталась в руцї його, дасть сьвященник на пучку правого вуха того, кого очищає, і на великий палець правої руки його і на великий палець правої ноги його, і на кров із жертви за провину. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Що ж зістанеться олїї, що в руцї сьвященника, виллє він на голову тому, кого очищає, і спокутує сьвященник гріхи його перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","І принесе сьвященник жертву за гріх і спокутує гріхи того, кого очищає од нечистї його; а потім заколе жертву всепалення. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","І принесе сьвященник жертву всепалення і жертву хлїбну на жертівнику. І так спокутує сьвященник гріхи його; і стане той чистий. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","А коли він убогий і не спроможеться, так візьме одно ягня на жертву за провину і жертву гойдану, щоб спокутувати гріх свій, та десятину муки, перемішану з олїєю, на хлїбну жертву, та лог олїї; ");
INSERT INTO ukr1871_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Та пару горлиць або пару голубенят, по спромозї своїй, і буде одно про жертву за гріх, а друге про всепаленнє. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","І принесе їх на восьмий день свого очищення сьвященникові до входу в соборний намет перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","І візьме сьвященник ягня, що на жертву за провину, та лог олїї, і принесе сьвященник жертву гойдану перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","І заколе ягнятко, що на жертву за провину, і візьме сьвященник крові від жертви за провину, і положить на пучку правого вуха в того, кого очищає і на великий палець на руцї його правій, і на великий палець на нозї його правій. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","І зіллє сьвященник олїї на лїву руку свою; ");
INSERT INTO ukr1871_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Та й бризне сьвященник правим пальцем своїм олїї, що на лївій долонї його, сїм раз перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","З олїї ж, що зісталась на долонї його, положить сьвященник на пучку правого вуха в того, кого очищає, та на великий палець на правій руцї його, та на великий палець на правій нозї його, на місце крові жертви за провину. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Що ж останеться олїї на долонї сьвященника, виллє він тому, кого очищає, на голову, і спокутує сьвященник за його перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","І принесе той одну з горлиць або з голубенят, на що спроможеться, ");
INSERT INTO ukr1871_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","По спромозї: одно як жертву за гріх, а друге на всепаленнє вкупі з хлїбною жертвою. І відбуде сьвященник покуту за того, кого очищає, перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Се закон про того, хто хорий від прокази, хто очищаючись не спроможеться на те, що приписано. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Як прийдете в Канаан землю, що сам я надїлю вам у державу, і як нашлю болячки заразливі в будинки землї тої, що буде ваша. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Мусить прийти той, чий будинок, й обявити сьвященникові так: щось таке, наче проказа, виявилось у мене в будинку. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","І звелить їм сьвященник очистити будинок, перш нїж увійде сьвященник оглядати болячку, щоб не стало нечистим усе в будинку, а потім увійде сьвященник, щоб оглянути будинок. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","І огляне він, та й побачить, що зараза на стїнах у будинку: западини зеленяві або рудяві, і на погляд вони глибше стїни, ");
INSERT INTO ukr1871_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","То вийде сьвященник із будинка до входу в будинок, і замкне будинок на сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","І вернеться сьвященник семого дня та й огляне, і се роскидується зараза по стїнах у будинку, ");
INSERT INTO ukr1871_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","То скаже сьвященник повиймати каміннє, що на йому зараза, та й викинути за городом, у місце нечисте. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","А будинок скаже обшкробати в серединї по всїх боках будинка, і висиплють обшкробану глину за городом, на місце нечисте. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","І наберуть иншого каміння та й принесуть замість викинутого каміння, і візьмуть иншої глини та й обкинуть будинок. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Коли ж ізнов покажеться зараза, та й стане розростатись в будинку послї того як виймуть каміння та обшкробають будинок та обкинуть його глиною, ");
INSERT INTO ukr1871_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Тодї ввійде сьвященник та й огляне; а коли побачить, що порозкидало заразу по будинку, то се вʼїдлива проказа на будинку: нечистий він. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","І велить зруйнувати будинок, каміннє його, дерево його і всю глину його, та й повиносити за город, у місце нечисте. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Хто ж приходив у будинок якого дня, як замкнено його, буде нечистий аж до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","А хто спав у будинку, мусить випрати одїж свою, і хто їв у будинку, мусить випрати одїж свою. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Коли ж прийде сьвященник та й огляне, і се не розкидає нечистї по будинку послі того, як обкинуто будинок глиною, так чистим обявить сьвященник будинок: вигоїлась бо зараза. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Та мусить він принести на очищеннє будинка дві птицї та дерева кедрини і кармазину й гисопу. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","І заріже одну птицю в посудинї черепяній над водою текучою; ");
INSERT INTO ukr1871_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","І візьме дерево кедрину і гисоп і кармазин і птицю живу, та й умочить їх у кров птицї зарізаної, та в текучу воду, та й покропить будинок сїм раз. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","І очистить будинок птичою кровю й водою текучою і птицею живою й деревом кедриною й гисопом і кармазином; ");
INSERT INTO ukr1871_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","І випустить він птицю живу за городом у поле. І так спокутує він будинок, і буде він чистий. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Се встанова про всякі болячки заразливі і про пархи. ");
INSERT INTO ukr1871_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","І про заразу на одїж і будинки, і про опухлину й про солуди й про плями, щоб навчати, в які днї будуть обявляти нечистим і в які обявляти чистим. Се встанова на проказу. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","І рече Господь Мойсейові та Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Промовте до синів Ізрайлевих і кажіть їм: Як буде в кого течи з тїла його, через течиво своє він стане нечистим. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","І се буде нечисть його в течиві його, чи то випускає тїло течиво своє, чи задержує тїло течиво своє, се нечисть. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Усяке ложе, що на його лягає течивний, буде нечисте, і всяка річ, що на неї сїдає він, буде нечиста. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","І хто торкнеться об ложе його, мусить випрати одїж свою та викупатись у водї, і буде нечистим до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","І хто сїв на знаряддє, що на йому седїв течивний, мусить випрати одїж свою та викупатись в водї, і буде нечистим до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","І хто торкнеться об тїло течивого, мусить випрати одїж свою та викупатись у водї, і буде нечистим до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","І коли плюне течивий на чистого, той мусить випрати одїж свою, та викупатись у водї, і буде нечистим до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","І всяке сїдало на возї, що їхав на йому течивий, буде нечисте. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","І кожне, що торкнеться об що б нї було спід його, нечисте буде до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","А хто таке піднїме, мусить випрати одїж свою, і буде нечистим до вечора. І до кого торкнеться течивий не обмивши рук, мусить випрати одїж свою, та викупатись у водї, і буде нечистий до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","І ту посудину черепяну, що до неї торкнеться течивий, мусять розбити, а всяку посудину деревяну мусять вимити в водї. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","І коли течивий очищається від течива свого, нехай одлїчить собі сїм день про своє очищеннє, і мусить випрати одїж свою, і викупати тїло своє в водї текучій, і стане чистий. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","А на восьмий день візьме він собі пару горлиць, або пару голубенят і принесе перед Господа до входу в соборний намет, і оддасть їх сьвященникові. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","І принесе їх сьвященник одно на жертву за гріх, а друге на всепаленнє, і спокутує сьвященник його перед Господом від течива його. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","А коли в кого буде стїкати сїмя, мусить він викупати в водї все тїло своє, і буде нечистим до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","І всяку одежину, і всяку шкіру, що капнуло на неї текуче сїмя, нехай виперуть у водї, і нечистими будуть ті речи до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","І коли з жінкою ляже чоловік течивий сімям, то вони мусять скупатись у водї, і будуть нечистими до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","І коли буде течиво в жінки, та буде кров течивом на тїлї в неї, сїм день мусить вона бути відлученою в нечистотї своїй; і кожне, хто торкнеться до неї, нечисте буде до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","І все, на що ляже вона в нечистотї своїй, нечистим буде, і все, на чому вона сяде, нечистим буде. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","І кожен, хто торкнеться об постель її, мусить повипирати одїж свою, і викупатись у водї, і нечистим буде до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","І кожне, що торкнулось об яку річ, що на нїй седїла вона, мусить випрати одїж свою та викупатись у водї, і нечистим буде до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","І коли б що небудь було на постелї чи на речі, що на нїй седїла вона, коли хто торкнеться об його, нечистим буде воно до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Коли ж хто ляже з нею, на йому буде нечисть її, і нечистим буде він до вечора, а всяке ложе, що на його ляже вона, буде нечистим. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Так само жінка, коли буде в неї кровотіч кілька днїв позачас нечистоти її, чи то коли буде в неї кровотїч, як минув час нечистоти її, тодї буде у всї днї нечистого течива свого відлучена як в днї нечистоти своєї; нечиста вона. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Всяке ложе, на котре лягає вона по всї днї течива свого, буде про неї як ложе чищення її; і всяка поставина, що на нїй сїдає вона, нечиста буде, як в час чищення її. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","І кожне, хто торкнеться їх, нечистим буде, і мусить випрати одїж свою та викупатись у водї, і нечистим буде до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","А коли одужає вона від кровотїчі своєї, нехай одлїчить собі сїм день, і потім чистою стане. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","І візьме собі на восьмий день пару горлиць або пару голубенят і принесе їх сьвященникові до входу в громадський намет. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","І принесе в жертву сьвященник одно на жертву за гріх, а друге на всепаленнє. І так спокутує сьвященник за неї перед Господом задля нечистого течива її. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Сим робом будете ви держати синів Ізрайлевих оддалеки від їх нечистоти, щоб не вмирати їм у нечистотї своїй, опоганюючи виталище моє, що посеред них. ");
INSERT INTO ukr1871_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Се закон про течивого, і про того, в кого сїмя стїкає, що робить його нечистим, ");
INSERT INTO ukr1871_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","І про ту, що нездужає від чищення свого, і про тих, у кого течиво, чоловік чи жінка, і про чоловіка, що лягати ме з нечистою. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","І рече Господь Мойсейові по смерти двох синів Аронових, як померли наближившись перед Господа. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","І рече Господь Мойсейові: Промов до Арона, брата твого, щоб не входив по всяк час у сьвятинї за завісу, перед віко, що на скринї, щоб не вмерти йому; в хмарі бо обявлятись буду над віком. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","От з чим входити мусить Арон у сьвятиню: з бичком про жертву за гріх та з бараном про всепаленнє. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Сьвященний хитон льняний надївати мусить і спідня одежа льняна мусять бути на тїлі його, і поясом льняним підперізуватись мусить, і завивало льняне мусить навивати: се одїж сьвята; і скупає у водї тїло своє і вдягнеться. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","А від громади синів Ізрайлевих візьме двох козлів на жертву за гріх, та одного барана на всепаленнє. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","І принесе Арон бичка як жертву за гріх, що буде за него, та й спокутує за себе і за дім свій. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","І візьме обох козлів і поставить їх перед Господом до входу в громадський намет. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","І кине Арон жереб про обох козлів: один жереб про Господа, а один жереб на відпущеннє. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","І приведе Арон козла, що на його випав жереб про Господа, і принесе його як жертву за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","А козла, що на його впаде жереб на відпущеннє, поставить живого перед Господом, щоб спокутувати на йому та пустити його в степ. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","І принесе Арон бичка, що на жертву за гріх, і що за него буде, і спокутує за себе і за дім свій, та й заколе бичка, що на жертву за гріх, і що буде за него. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","І візьме він кадильницю повну жару з жертівника перед Господом і набере повні руки пахущого кадила, на дрібно стовченого, та й понесе за завісу. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","І посипле кадило на жар перед Господом, щоб хмара з кадила вкрила віко, що на сьвідченню, щоб не вмерти йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","І візьме крові з бичка, та й бризне з пальця свого на віко, спереду, на схід сонця; а перед віком бризне сїм раз кровю з пальця свого. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","І заколе козла про жертву за гріх, що буде за людей, і внесе кров його за завісу, і чинити ме з кровю його так само, як чинив з кровю бичка, і бризне на віко нею і перед віком. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","І відправить покуту за сьвятиню задля нечистот у синів Ізрайлевих, і задля переступів їх по всїм гріхам їх; і те ж саме вчинить про соборний намет, що між ними, серед нечистот їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Тільки ж нїкого щоб не було в соборному наметї, коли він увійде покутувати в сьвятинї, аж коли вийде. І так відправить він покуту за себе і за дім свій і за всю громаду Ізрайлеву. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","І вийде до жертівника, що веред Господом, і відправить покуту за його; і візьме крові з бичка й крові з козла, та й положить її на роги жертівника з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","І бризне на його крові пальцем своїм сїм раз, і очистить його та осьвятить його від нечистот синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","А як скінчить покуту за сьвятиню, і за соборний намет, і за жертівник, так приведе козла живого. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","І положить Арон обидві руки свої на голову козла живого та й признає над ним всї беззаконня синів Ізрайлевих і всї переступи їх, по всїм гріхам їх; і положить їх козлові на голову, та й випустить його рукою певного чоловіка в степ. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","І понесе козел на собі все беззаконьство їх у землю безлюдну; і випустить він козла в степ. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","І ввійде Арон у соборний намет і поздіймає одїж льняну, що понадївав, як входив у сьвятиню, та й покладе її там. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","І викупає в водї тїло своє в місцї сьвятому, та й надїє одїж свою; і вийде він та й принесе всепаленнє своє і всепаленнє людське, і спокутує за себе і за людей. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","А тук жертви за гріх пустить з димом на жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","А той, хто вів козла на відпущеннє, мусить свою одїж випрати і тїло своє у водї скупати; потім можна йому ввійти в табір. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","А бичка, що на жертву за гріх, і козла, що на жертву за гріх, котрих кров внесено в сьвятиню на спокутованнє, винесуть геть із табору, та й спалять на вогнї шкіри їх, і мясиво їх і кал їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","А той, хто палити ме їх, нехай повипирає одїж свою та скупає в водї тїло своє; а потім можна йому ввійти до табору. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","І буде установою вам віковічньою: Семого місяця, на десятий день місяця, будете впокорювати душі ваші, і нїчого не робити, чи землянин, чи чужинець, що пробуває між вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","У той бо день покутувати ме сьвященник за вас, щоб очистити вас; будете чисті перед Господом од усїх провин ваших. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Субота на спочинок буде про вас, і мусите впокорювати душі свої: установа віковічня. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Буде ж покутувати такий сьвященник, що його помазано, і що сьвятять його, щоб служив сьвящену службу намість отця його; вдягати меться він в шати льняні, сьвященні шати; ");
INSERT INTO ukr1871_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","І покутувати ме за сьвятиню, і за соборний намет, і за жертівник відправить покуту, і за сьвященників і за ввесь люд громадський, зробить покуту. ");
INSERT INTO ukr1871_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","І буде се в вас установою віковічньою, щоб роблено покуту за синів Ізрайлевих, за всї провини їх раз в рік. І вчинив Мойсей так, як заповідав йому Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Промов до Арона та до синів його і скажи їм: Ось що заповідав Господь глаголючи: ");
INSERT INTO ukr1871_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Хто б то нї був із дому Ізрайлевого, що заколов би вола, чи ягня, чи вівцю, чи козу в таборі, або хто б заколов за табором, ");
INSERT INTO ukr1871_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Та не принїс його до входу громадського намета на жертву Господеві перед храминою Господньою, тому чоловікові буде полїчена кров за гріх: кров пролив він, і викорениться чоловік той зміж люду свого; ");
INSERT INTO ukr1871_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Се длятого, щоб сини Ізрайлеві приносили жертви свої, що заколюють їх у чистому полї, щоб вони подавали їх Господеві до входу в громадський намет сьвященникові, та заколювали їх як жертви мирні Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","І кропити ме сьвященник кровю на жертівник Господень коло входу в соборний намет і пускати ме з димом тук про любі пахощі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","І не приносити муть уже потім жерти ідолам, з котрими блудно ходять. Установою віковічною буде се їм у роди їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","І промовиш їм іще: Хто б то нї був, чи з дому Ізрайлевого, чи з приходнїв, що між вами, що приносити ме всепаленнє чи жертву, ");
INSERT INTO ukr1871_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","І не подасть до входу в громадський намет на приніс Господеві, викорениться чоловік той із між людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","І хто б то нї був із дому Ізрайлевого, чи з приходнїв, що пробувають між вами, хто їсти ме яку б то нї було кров, проти людини, що їсть кров, поверну лице моє і викореню її зміж людей. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Бо в крові душа тїла, і призначив я її для жертівника, щоб роблено покуту за душі ваші; кров бо се, що чинить покуту за душу. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Тим же то глаголав я Ізрайлевим синам: Нї одна душа зміж вас нехай не їсть крові; і приходень, що пробуває між вами, нехай не їсть крові. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","І хто б то нї був між синами Ізрайлевими, чи між приходнями, що між вами, що вловить животину чи птицю яку, що їдять, мусить вицїдити кров її, і засипати її землею. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Бо душа кожного тїла: кров його, се душа його; і сказав я Ізрайлевим синам: Крові з усякого тїла щоб ви не їли, бо душа кожного тїла се кров його; кожен, хто зʼїсть її, викорениться. ");
INSERT INTO ukr1871_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","І всякий хто їсти ме або трупа, або те що зьвір розідре, чи землянин, чи приходень, мусить випрати одїж свою та викупатись у водї, і нечистий буде він до вечора; тодї ж стане чистий. Коли ж не повипирає її і не скупається, так нести ме на душі гріх свій. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Промов до синів Ізрайлевих і скажи їм: Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Не будете ви ходити робом Египецької землї, де ви жили, і не будете ходити робом Канаан землї, куди приведу вас; і по установам тамешнім не будете жити. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Суди мої сповняйте і установ моїх пильнуйте, щоб ходити в них. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","І будете сповняти установи мої й суди мої, котрі сповняючи, чоловік жити буде. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Нїхто не буде наближуватись до родички, щоб відкрити наготу її. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Наготи батька і матері не відкривати меш; вона мати твоя, не відкриєш наготи її. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Наготи жінки батькової не відкривати меш; нагота се батька твого. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Наготи сестри твоєї, дочки батька твого, або дочки матері твоєї, що родилась дома, чи осторонь родилась, не відкривати меш наготи її. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Наготи дочки сина твого, чи дочки твоєї дочки не відкривати меш; бо се твоя нагота. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Наготи дочки в жінки батька твого, що родилась від батька твого, та що сестра тобі, наготи її не відкривати меш. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Наготи сестри батька твого не відкривати меш; вона родичка батька твого. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Наготи сестри матері твоєі не відкривати меш; бо вона родичка матері твоєї. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Наготи брата батька твого не відкривати меш: до жінки його не наближишся, вона тїтка тобі. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Наготи невістки твоєї не відкривати меш: вона жінка сина твого, не відкривати меш наготи її. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Наготи жінки брата твого не відкривати меш; се нагота брата твого. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Наготи молодицї і дочки її не відкривати меш; дочки в сина її і дочки в дочки її не брати меш, щоб відкрити наготу її: родичі вони: се дїло соромне. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","І жінки в купі з сестрою не брати меш, щоб ревнувала, як відкривати меш наготу її коло неї за життя її. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","І до молодицї в днї чищення її не наближувати мешся, щоб відкрити наготу її. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","А з жінкою ближнього твого не злягати мешся, щоб вийшло сїмя, та й опоганитись тобі із нею. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","І сїмя твого не оддаси провести через огонь ради Молеха, і не паскудити меш імени Бога твого. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","І з музьким полом не зляжешся, як злягаєш з жінкою; гидота бо се. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","І нї з якою скотиною не зляжешся, та й опоганишся нею; і молодиця нехай не становиться перед скотиною, щоб злучитись; се огидне паскудство. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Не поганьтесь нїчим сим: бо сим усїм опоганились народи, що їх виганяю поперед вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","І спаскуджено землю, і покарав я провину її, і земля викинула осадників своїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Тим же то допильновуйте установ моїх і присудів моїх, і не чинїте нї однієї з гидот сих, нї земляне, нї приходнї, що пробувають між вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Усї бо гидоти сї чинили осадники землї сієї, що були перед вами, і спаскуджено землю; ");
INSERT INTO ukr1871_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Щоб не викинула вас земля, як опаскудите її, так як викинула народа, що був перед вами: ");
INSERT INTO ukr1871_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Бо кожне, хто чинити ме що з тих гидот, — душі, що се зроблять, викореняться із між людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Оце ж допильновуйте заповідей моїх, щоб не витворяли огидних привичок, що витворялись перед вами, та й щоб не опаскудились ними. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Промов до дїтей Ізрайлевих і скажи їм: Сьвятими ви мусите бути; я бо сьвятий, Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Матері своєї й батька свого кожне мусить боятись; і суботи мої пильнуйте. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Не обертайтесь до ідолів, і литих богів собі не робіте. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","І як приносити мете жертву мирну Господеві, то приносїть її, щоб зʼєднати собі благословеннє. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","В день, як будете приносити жертву, і другого дня можна вам їсти її; а що зостанеться на третій день, те спалити треба на вогні. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Коли ж би ззїли на третій день, так се гидь, не буде вона до вподоби. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","І хто їв її, візьме на себе провину: бо сьвятиню Господню зневажив, і викорениться душа та зміж людей своїх. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","І коли справляєте жнива на землї вашій, то не дожинати меш до країв поля твого і не збирай колосся, що попадало. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Так само з виноградника твого не збирати меш грони до послїднього, а грони, що попадали, не збирати меш; для вбогого і приходня покинеш їх. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","І не будете красти, нї ошукувати, нї брехати одно на одного. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","І не божити метесь імям моїм льживо; бо зневажиш імя Бога твого. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Не тїснити меш ближнього твого, і не грабувати меш. Не зоставляти меш у себе на ніч до ранку наймитової плати. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Не лаяти меш глухого, а перед слїпим не класти меш нїчого, об що можна спотикнутись, а мусиш боятись Бога твого. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Не кривдити мете на судї, і не потурати мете вбогому, і не вважати меш на особу богатого. По правдї будеш судити ближнього твого. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Не будеш обмовляти між людьми твоїми, і не вставати меш на життя ближнього твого. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Не будеш ненавидїти брата твого в серцї твойму. Докори поважно ближнього твого, щоб не бути тобі винуватим за гріх його. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Не мстити мешся і не ворогувати меш проти синів люду твого, а мусиш любити ближнього твого, як себе самого. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Установ моїх мусите пильнувати. Не злучувати меш твоєї скотини двох пород. Не засївати меш ниви своєї двома насїннями, і не вдягати мешся в одежину із двоякого ткання. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","І коли хто зляжеться з жінкою, а вона заручена рабиня, та зовсїм не викуплена, анї випущена на волю, скарані будуть обоє; не смертю, бо вона не на волї. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","А він мусить принести жертву за провину до входу в соборний намет, барана як жертву за провину; ");
INSERT INTO ukr1871_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","І відправить сьвященник покуту за гріх його жертвуючи барана перед Господом; і проститься йому гріх його, що ним провинив. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Як же прийдете в країну та понасаджуєте дерева про харчуваннє, то вважайте перві плоди їх нечистими; три роки вони будуть про вас необрізаними, не їсти мете плоду з них; ");
INSERT INTO ukr1871_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","На четвертому ж роцї посьвятите все, що вродить на їх, на хвалу Господеві: Я Господь Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","А на пятій рік можна їсти, що вродить на них, і се буде ваша користь. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Не їсти мете нїчого з кровю. Не будете нї ворожити нї замовляти. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Не підстригати мете кругом потилицї вашої, і не псувати меш краю бороди твоєї. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","І не будете робити нарізок задля мерця на тїлї своїм, і не будете наколювати письма на собі. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Не погань дочки твоєї, допускаючи її до блудування; ато стане блудувати земля та й сповниться розворотом. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Субіт моїх пильнуйте і перед сьвятинею моєю благовійте. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Не вдавайтесь до закленателїв, і до ворожбитів; не шукайте їх, щоб не опаскудитись вам від них. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Перед сивим волосом уставати мусиш і шанувати лице старого, і бояти мешся Бога твого. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","І коли пробувати ме в тебе приходень у землї вашій, не тїснити меш його. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Як землянин мусить бути приходень ваш, що пробуває між вами, і любити мусиш його, як себе самого; приходнями бо ви були в землї Египецькій. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","І не кривдите мете в судї, в мірі, у вазі, і в насипу; ");
INSERT INTO ukr1871_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Вірна вага, вірне каміннє вагове, вірна єфа і гин вірний буде у вас. Я Господь, Бог ваш, що вивів вас із Египецької землї. ");
INSERT INTO ukr1871_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","І мусите пильнувати усїх установ моїх, і всїх присудів моїх, і сповняти їх. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Промов до синів Ізрайлевих: Хто б нї був зміж синів Ізрайлевих, чи з приходнїв, що пробуває в Ізраїля, такий, що оддавати ме насїннє своє Молехові, скарати його смертю; люде країни тієї мусять побити його каміннємъ. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","І сам я поверну лице моє проти чоловіка того, і викореню його зміж людей його; бо дїтей своїх він оддав Молехові, щоб опаскудити імя сьвятинї моєї. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Коли земляне заплющять очі свої на того чоловіка, як оддавати ме з дїтей своїх Молехові, та й не схоче стратити його, ");
INSERT INTO ukr1871_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Так поставлю моє лице проти чоловіка такого, і проти роду його, та й викореню його й усїх, що блудували слїдом за ним, щоб слїдом за Молехом блудувати; викореню їх зміж людей їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","І душа, що обернулась до закленателїв мертвих і до ворожбитів, щоб слїдом за ними блудувати, оберну лице моє проти душі тієї, та й викореню її спроміж люду її. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Осьвячуйте ж себе й бувайте сьвятими, бо я, Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","І пильнуйте установ моїх, і сповняйте їх. Я Господь, що осьвятив вас. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Бо кожний, хто лає батька свого й матїр свою, того мусять скарати смертю; батька свого й матїр свою лаяв, кров його на йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","І коли чоловік робить перелюб із заміжною жінкою, коли робить перелюб з жінкою ближнього свого, смертю мусять скарати перелюбника й перелюбницю. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","І такий, що лежати ме з батьковою жінкою; наготу батька свого відкрив він, обоє їх смертю карати муть; кров його на обох їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","І такий, що лежати ме з невісткою своєю, смертю скарати мусять їх; огидно опоганили себе; кров їх на них. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","І коли чоловік з чоловіком зляжеться, так як злягається з жінкою, гидоту вкоїли обоє; смертю мусять їх скарати; кров їх на них. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","А коли чоловік бере жінку собі й матїр її, се плюгаство; огнем нехай спалять і його і їх, щоб не було розвороття між вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","І як чоловік зляжеться із скотиною, смертю такого мусять скарати, а скотину мусите вбити. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","І жінка, що наближиться до якої скотини, щоб злучитись з нею, вбити мусиш їх, жінку й скотину; мусять вони згинути, бо кров їх на них. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","І коли чоловік возьме сестру свою, дочку батька або дочку матері своєї, та й побачить наготу її, а вона побачить наготу його; паскудний се вчинок, і викоренять їх обох перед очима всього люду їх; наготу сестри своєї відкрив; мусить понести кару за гріх свій. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","І як чоловік ляже з жінкою під час недуги її, та й одкриє наготу її, криничину її одкрив, і вона відкрила криничину крові своєї; обох їх викоренити зміж людей їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","І наготи в сестри матері твоєї і сестри батька твого не відкривати меш; бо хто се зробить, той відкриє родичку свою; нехай вони гріх свій несуть. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","І коли чоловік ляже з жінкою дядька свого, наготу дядька свого відкрив він; понесуть вони кару за гріх свій, бездїтними помруть. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","І коли возьме чоловік жінку брата свого, то се нечисть; наготу брата свого відкрив; бездїтними помруть. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Оце ж пильнуйте моїх установ, і всїх присудів моїх, і сповняйте їх, щоб не звергла земля вас, де приведу вас жити. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","І не ходїте в установах народів, що перед вами проганяти му; бо все те коїли вони, та й поробились гидкими менї. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","І казав я вам: Ви візьмете займище їх, і я оддам вам в державу землю текущу молоком та медом. Я Господь, Бог ваш, що вас повилучував із народів. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Оттим же то розбирайте між скотиною чистою й нечистою, і між птаством чистим і нечистим, і не робіте себе гидкими скотом і птаством і всїм, що метушиться на землї, що я вилучив вам як нечисте. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","І будете ви передо мною сьвятими, я бо сьвятий, я Господь, і я вилучив вас ізміж инших народів, щоб ви були моїми. ");
INSERT INTO ukr1871_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Оце ж коли чоловік або жінка будуть заклинати помершого або ворожити, то нехай скарають їх смертю; каміннєм нехай побють їх; кров їх на їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","І рече Господь Мойсейові: Промов до сьвященників, синів Аронових, і скажи їм: Нїхто з них нехай не опоганюєть себе, доторкаючись до помершого з людей своїх; ");
INSERT INTO ukr1871_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Тільки хиба що се родина його, серцем близька йому: мати його, та батько його, та син його, та дочка його, та брат його, ");
INSERT INTO ukr1871_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Та сестра його дївиця, що близька йому і що не було в неї чоловіка: задля них можна сьвященникові опоганитись, доторкнувшись. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Нехай не опоганює себе, як громадський муж між народом своїм, доторкаючись до помершого якого, щоб не стати нечистим. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Не робити муть сьвященники лисини на голові в себе і краю борід своїх не стригти муть, і на тїлї в себе нарізок не робити муть. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Сьвятими мусять бути перед Богом своїм, і не зневажать імени Бога свого, вони бо приносять огняну жертву Господню, хлїб Бога свого; тим і мусять бути сьвятими. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Блудницї або обезчещеної не брати собі муть за жінку і роздведеної з чоловіком своїм жінки не брати муть; сьвятий бо сьвященник перед Богом своїм. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","І вважай його за сьвятого, він бо хлїб Бога твого приносить. Сьвятим він буде про тебе: бо я сьвятий, Господь, що сьвятить вас. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","І коли дочка в которого сьвященника обезчестить себе, ставши блудницею, то обезчестила вона тим батька свого; огнем треба спалити її. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","А великий сьвященник між братами своїми, той, що на голову йому злито миро, і що осьвячено його, щоб надїти сьвяті шати, не буде відкривати голови своєї, і не дерти ме він одїжи своєї. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","І до жадного мерця не приступати ме; нї задля батька свого, нї задля матері своєї не буде опоганювати себе. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","І нехай не виходить із сьвятинї, і не зневажає сьвятинї Бога свого; бо посьвят помазання Божого на йому. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","І мусить він дїву за жінку собі брати. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Вдовицю й розвідку і збезчещену, і блудницю, сих не брати ме, а дїву з земляцтва свого мусить взяти за жінку. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","І не збезчестить він свого насїння в земляцтві свойму; я бо Господь, що сьвятить його. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Промов до Арона і скажи: Хто б нї був із насїння твого в родах їх, що в його хиба в тїлї, нехай не приступає, щоб приносити хлїб Бога свого; ");
INSERT INTO ukr1871_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Кожен бо, в кого є хиба яка, такому не можна приступити, чи слїпий чоловік буде, чи кульгавий, чи кирпатий, чи нечумазний, ");
INSERT INTO ukr1871_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Або такий, в кого переломлена нога, чи переломлена рука, ");
INSERT INTO ukr1871_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Чи горбатий, чи миршавий, чи з більмами на очах, чи коростявий, чи лишаюватий, чи з роздавленими яйцями. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Кожний з роду Арона, сьвященника, у кого на тїлї хиба яка, не може приступити, щоб приносити огняні жертви Господнї; сказа у його, не приступати ме, щоб приносити хлїб Бога свого. ");
INSERT INTO ukr1871_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Хлїб Бога свого в сьвятинї від великої сьвятощі і від сьвятощі можна йому їсти; ");
INSERT INTO ukr1871_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Тільки до завіси нехай не приступає, і до жертівника нехай не приступає, бо в його сказа на тїлї, так щоб не зневажив сьвятинї моєї: я бо, Господь, осьвячую її. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Промов до Арона й до синів його, щоб оглядно держали себе перед сьвятими приносами синів Ізрайлевих, що посьвячують для мене, та не зневажали імени сьвятинї моєї. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Скажи їм: Хто б то нї був у ваших родах, кожен з насїння вашого, що приступати ме до сьвятощів, що посьвячують сини Ізрайлеві Господеві, а нечисть його буде на йому, викорениться душа та від лиця мого. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","І кожний з насїння Аронового прокаженний, або течивий, не їсти ме сьвятих приносів, аж стане чистим. А хто торкнеться такого, що через трупа став нечистим, або такого в кого стїкає насїннє; ");
INSERT INTO ukr1871_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Або хто торкнеться об повзаючу животину, через котру стане нечистим, або об чоловіка, через котрого стане нечистим від якої нечистоти, що на йому: ");
INSERT INTO ukr1871_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Хто торкнеться об їх, нечистим стане до вечора; і неможна йому їсти сьвятого, але він мусить викупати тїло своє в водї. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","А зайде соньце, то чистим стане; і можна йому потім їсти сьвяте, бо се хлїб його. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Падла й що зьвір розідре, не їсти ме, щоб неопоганитись. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","І сповняти муть повелїння мої, щоб не взяти на себе гріха і не вмерти за те, що зневажять їх. Я Господь, що сьвятить їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","І нїякий приходень не їсти ме сьвятого; хто в комірни в сьвященника або наймит його, неможна йому їсти сьвятого. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","А коли сьвященник купить раба за срібло, можна йому їсти з того; і ті, що родились у домівцї його, можуть їсти. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","І коли дочка сьвященника буде за приходнем, то не їсти ме жертви, сьвятого приношення. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Коли ж дочка сьвященника повдовіє чи розведеться з чоловіком, і дїтей в неї нема, і вернулась вона в домівку батька свого, як замолоду, батьківський хлїб їй можна їсти. Нїякому ж приходневі не можна їсти його. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","І коли хто ненароком зʼість сьвятого, нехай до його надбавить пятину того тай оддасть сьвященникові вкупі з сьвятим. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","І нехай нїхто не зневажає нїчого сьвятого в синів Ізрайлевих, що приносять Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","І сим робом не беруть на душу гріха, що їдять сьвятощі їх. Я бо Господь, що осьвячую їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Промов до Арона й до синів його і до всїх синів Ізрайлевих, і скажи їм: Хто б то нї був із дому Ізрайлевого, чи з приходнїв в Ізраїлї, що приносити ме жертву свою, чи по якій обітницї своїй, чи по добрій волї приносять дари Господеві на всепаленнє, ");
INSERT INTO ukr1871_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","То, щоб залюбки було воно прийнято, треба приносити без скази, самця із скотини чи з овечок чи з кіз. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Нїчого, що має хибу, не приносити мете його; бо не буде на благоволеннє Боже про вас. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","І хто приносить жертву мирну Господеві, щоб сповнити обітницю, чи то приніс добровільний, із скоту або з овечок: без скази мусять бути про благоволеннє; не має бути жадної хиби в йому. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Слїпого або зраненого, або надвереженого, або таке, що болячки в його, або коростявого, або паршивого, такої животини не приносити мете Господеві і не подавати мете їх на огняну жертву на жертівник. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","А бика або барана, в якого один член або за довгий або за короткий, такого можна тобі принести як дар добровільний; але на обітницю не годиться таке. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","І животини, в якої яйцї роздавлені або розбиті, або вирвані або вирізані, не приносити мете Господеві, і в землї вашій не чинїте такого. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","І з рук чужениць не приносити мете хлїб Бога вашого зо всього того; бо на всьому тому надвереженнє і сказа їх; не будуть вони у благоволеннє Боже про вас. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","І рече Господь до Мойсея, кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Теля, чи ягня, чи козля, як вродиться, так нехай пробуде сїм день при матері своїй; а з восьмого дня і потім буде залюбки на жертву всепалення Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Чи то буде корова, чи вівця, не будете заколювати її одного дня разом з маленьким її. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","І як приносити мете жертву подячну Господеві, то приносїть її так, щоб була Богу залюбки про вас: ");
INSERT INTO ukr1871_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Того самого дня треба зʼїсти її; не зоставляйте нїчого до ранку. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","І пильнуйте заповідей моїх і сповняйте їх. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","І не зневажати мете імені сьвятого мого, щоб сьвятим бути менї серед синів Ізрайлевих. Я Господь, що сьвятить вас, ");
INSERT INTO ukr1871_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Що вивів вас із Египецької землї, щоб бути вам Богом. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Промов до синів Ізрайлевих та скажи до них: Се сьвята Господнї, що обявите їх зборами сьвятими; мої празники, такі: ");
INSERT INTO ukr1871_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Шість день можна вам робити дїло, а семого дня субота на спочинок, сьвятий збір. Нїякого дїла не робити мете. Спочинок се про Господа по всїх осадах ваших. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ось сьвята Господнї, сьвяті збори, що будете скликати їх призначеного часу: ");
INSERT INTO ukr1871_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Первого місяця, на чотирнайцятий день місяця, між двома вечорами, паска Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","А на пятнайцятий день того ж місяця сьвято опрісноків Господеві; сїм день опрісноки їсти мете. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","На первий день сьвяті збори будуть у вас. Нїякої роботи не робити мете. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Та приносити мете огняну жертву Господеві сїм день; на семий день сьвяті збори, нїякої роботи не робити мете. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","І рече Господь Мойсейові: Промов до синів Ізрайлевих і кажи до них: ");
INSERT INTO ukr1871_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Як прийдете в землю, що я оддаю вам, і жати мете жниво її, так мусите подавати снопа первоплоду жнива вашого сьвященникові; ");
INSERT INTO ukr1871_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","І принесе він снопа перед Господом, щоб залюбки прийнято від вас; на другий день після суботи принесе він його. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","І дня того, як будете приносити снопа, мусите жертвувати ягня без скази, однолїтка на всепаленнє Господеві, ");
INSERT INTO ukr1871_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","І хлїбну жертву його: дві десятинї ефи муки, змішаної з олїєю; огняна жертва Господеві, пахощі любі; і жертву ливну його: вина четвертину гина. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Нї хлїба, нї зерна піджареного, нї зерна сирого не їсти мете до того самого дня, поки не принесете жертівного дару Богу вашому: Устав се віковічний в родах ваших в усїх осадах ваших. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","І будете лїчити собі від другого дня послї суботи, від того дня, як принесли снопа в жертву гойдану, сїм повних тижнїв. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","До другого дня послї семої суботи відлїчите собі пятьдесять днїв; та й принесете нову хлїбну жертву Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Із осад ваших подасьте два хлїби на гойдану жертву; із двох десятин ефи муки пшеничної вони будуть, квашеними спечені будуть; як первоплід Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","І принесете з хлїбом семеро ягнят без скази однолїтків, та бичка одного, та два барани, на огняну жертву Господеві будуть вони, та жертву хлїбну і жертву ливну до них: огняна жертва, любі пахощі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","І принесете козла одного на жертву за гріх та двоє ягнят однолїтків на жертву мирну. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","І сьвященник принесе їх з первоплодом хлїбним та з двома ягнятами як жертву гойдану перед Господом; сьвяте вони будуть Господеві про сьвященника. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","І обявите того ж самого дня, сьвяті збори будуть в вас. Нїякої роботи не робити мете. Установа віковічня в усїх осадах ваших. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","І як збираєте жниво в своїй землї, так не дожинати меш країв поля твого, і колоссє, що попадає, не збирати меш. Убогому та захожому зоставиш їх. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Промов до синів Ізрайлевих і скажи: Місяця семого, на первий день місяця, мусить у вас бути відпочинок, споминки гуку рогового, сьвятий збір. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Нїякої роботи не будете робити, а приносити огняні жертви Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","А десятий день того семого місяця буде день премирення. Сьвяті збори будуть у вас, і будете впокорювати душі ваші й приносити огняні жертви Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","І нїякої роботи не робити мете в той самий день; бо се день премирення, щоб робити покуту за вас перед Господом, Богом вашим. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Тим же то всяка душа, що не впокорювати меться того дня, викорениться зміж люду свого. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","І всяка душа, що робити ме яке б то нї було дїло в той день, викореню ту душу зміж люду її. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Нїякого дїла не робити мете: установа віковічна в роди ваші по всїх осадах ваших. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Суботою на спочинок він буде в вас, і будете впокорювати душі ваші; з вечора девятого дня того місяця, від вечора до вечора, будете сьвяткувати соботу вашу. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Промов до синів Ізрайлевих і скажи: На пятнайцятий день сего місяця семого сьвято кучок, сїм день Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Первого дня сьвяті збори. Нїякої роботи не робити мете. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Сїм день приносити мете огняну жертву Господеві; восьмого дня будуть сьвяті збори, і принесете огняну жертву Господеві: се сьвяточні сходини, не робити мете жадної роботи. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Се празники Господнї, що звати мете сьвятими зборами, щоб приносити огняні жертви Господеві, жертву всепалення і жертву хлїбну, жертву заколену і ливну, кожне свого дня: ");
INSERT INTO ukr1871_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Опріч собіт Господнїх, і опріч приносів ваших, та й опріч усїх обітниць ваших, і опріч добровільних дарів ваших, що даєте Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","А на пятнайцятий день семого місяця, як позбираєте вроджай із землї, сьвяткувати мете сьвято Господнє сїм день; у первий день буде відпочинок і в восьмий день відпочинок. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","І поберете собі віття з гарного дерева, гілля пальмового, і гілля широколистого дерева, та вербового, що понад бурчаками, і веселити метесь перед Господом, Богом вашим, сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","І сьвяткувати мете се сьвято Господеві сїм день що року: установа віковічня в роди ваші; семого місяця сьвяткувати мете се. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","У кучках жити мете сїм день; кожен землянин Ізраїльський жити ме в кучках; ");
INSERT INTO ukr1871_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Про те, щоб знали роди ваші, що в кучках оселив я синів Ізрайлевих, як вивів їх з Египецької землї. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","І обявив Мойсей сьвята Господнї перед синами Ізрайлевими. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Скажи синам Ізрайлевим принести тобі олїї оливної, забиваної, чистої на сьвітло, щоб без перестанку горіли лямпи. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","З надвору завіси сьвідчення в соборному наметї ставляти ме їх Арон з вечора до ранку перед Господом повсячасно: установа віковічня в роди ваші. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","На сьвітильнику чистому ставляти ме лямпи перед Господом повсячасно. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","І візьмеш муки пшеничної та й спечеш із неї дванайцять коржів; по дві десятинї ефи нехай буде в одному коржі. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","І покладеш їх двома рядами, по шість до ряду, на чистому столї перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","І класти меш на кожен ряд їх ладан чистий, щоб на хлїбі він був часткою на спомин, на огняну жертву Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Що соботи приготовляти ме його перед Господом од синів Ізрайлевих на ознаку віковічнього завіту. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","І буде він Аронові й синам його, і їсти муть вони його в сьвятому місцї; бо се про них сьвята над сьвяту із огняних жертов Господнїх: установа віковічня. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","І вийшов син якоїсь Ізраїльки; се був син одного Египтїя посеред синів Ізрайлевих, і почав сваритись в таборі син Ізраїльки з одним чоловіком Ізраїльським. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","І хулив син Ізраїльської жінки імя Боже, та й кляв його. І приведено його до Мойсея. Імя матери його Селомита Дибріївна, з роду Данового. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","І віддано його під сторожу, щоб обявлено їм волю Господню. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Виведи поганьця геть з табору, і нехай усї хто чув, покладуть руки свої на голову йому, та й нехай вся громада вбє каміннєм його. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","До синів же Ізрайлевих промовиш і скажеш: Хто б то нї був, що клясти ме Бога свого, гріх свій він нести ме. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","А хто хулить імя Господнє, того зараз скарати смертю, уся громада мусить окаменувати його; чи приходень, чи землянин: як скаже хулу на імя Господнє, мусить вмерти. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","І хто вбє яку людину, і того скарати смертю. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","А хто вбив скотину, мусить вернути за неї: життя за життя. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","І хто вшкодить ближнього свого, що він учинив, те й йому нехай учинять. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Перелом за перелом, око за око, зуб за зуб: як він ушкодив людинї, так і йому нехай ушкодять. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Тим же то хто вбив скотину, мусить вернути за неї, а хто вбив людину, мусить бути вбитий. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Одно право буде в вас, як для приходня, так і для землянина; я бо Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","І промовив Мойсей синам Ізрайлевим, що мусять вони вивести поганця геть із табору та й закидати каміннєм; і вчинили сини Ізрайлеві так, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Промов до синів Ізрайлевих і скажи їм: Як прийдете в землю, що я оддаю вам, так мусить земля сьвяткувати соботу Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Шість лїт засївати меш поле твоє, і шість лїт обрізувати меш виноградник твій, і збирати меш уроджай землї. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Семий же рік буде субота на відпочинок землї, собота Господеві; поля твого не засївати меш і виноградника твого не обрізувати меш. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Що само собою послї жнив твоїх уродить, не жати меш, грон у винограднику твойму необрізаному не збирати меш; рік відпочинку буде про землю. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","І буде собота землї на харч про вас, тобі й слузї твойму, і рабинї твоїй, і наймитові твому, і комірникові твому, що в тебе пробуває; ");
INSERT INTO ukr1871_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","І скотинї твоїй, і зьвіринї, що на землї твоїй, буде ввесь уроджай її на харч. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","І лїчити меш собі сїм собітнїх років, сїм раз сїм лїт, так що час сїмох собітнїх років буде тобі сорок і девять років. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","І прикажеш трубити в трубу місяця семого на десятий день; в день премирення прикажеш трубити в труби по всїй землї вашій. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","І сьвяткувати мете пятидесятий рік, і оголосите волю по країнї всїм осадникам її. Гучний рік се буде в вас, і вертати ме кожний з вас в державу свою, і кожний до роду свого вертати мете. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Яко ювілейний рік буде в вас пятидесятий рік. Не будете сїяти, нї збирати того, що само вродиться, і не збирати мете з виноградника непідрізуваного; ");
INSERT INTO ukr1871_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Бо се ювілейний рік: сьвятим він мусить бути в вас; просто з поля їсти мете уроджай його. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","В ювілейний рік мусить кожний вертати до свого маєтку. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","А коли що продаєш ближньому твому, чи купуєш із руки в ближнього твого, не будете тиснути один в одного. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Вважаючи на лїчбу років послї ювілейного року, будеш куповати в ближнього твого, по лїчбі жнивних років продавати ме він тобі. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Чим більше років, тим більшу цїну поставиш йому, і чим меньше років, тим меньшу цїну поставиш йому; бо лїчбу жнив продає він тобі. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Тим же то не будете вимагати надто один в одного, а боятись Бога твого; Я бо Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","І будете сповняти встанови мої і пильнувати присудів моїх, і жити мете на землї з упокоєм. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","І давати ме земля плоди свої і їсти мете до наситу, і жити мете на їй з упокоєм. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","І коли казати мете: Що їсти мемо семого року? Ми ж не сїємо і не збираємо вроджаю нашого, ");
INSERT INTO ukr1871_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Я посилати му благословеннє моє на вас в роцї шестому, щоб зродило на три роки; ");
INSERT INTO ukr1871_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","І як посїєте на восьмий рік, то їсти мете ще з попереднього вроджаю; аж до девятого року, покіль прийде вроджай його, їсти мете з попереднього. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","А землї не продавати мете на віки, бо земля моя; приходнї бо і комірники ви в мене. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Тим же по всїй землї вашої власностї мусите дозволяти викуп землї. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Коли зʼубожіє твій брат і продасть свою власність, то нехай прийде купець, його близький родич, і викупить, що продав брат його. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","А коли нема в людини такого, щоб викупив, та руки його зароблять, і стане за що викупити, ");
INSERT INTO ukr1871_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Так мусить порахувати роки проданого й вернути лишнє чоловікові, якому продав, і вернеться так до власностї своєї. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Коли ж руки його не придбають, щоб стало чим заплатити йому, так нехай продане буде в руцї того, хто купив, до ювілейного року, і буде воно вільне в ювілейному роцї, і вернеть ся йому власність його. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","І коли хто продасть хату в утвердженому містї, так можна йому викупити її до кіньця року від часу продажі. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Цїлий рік можна йому викупити її. Коли ж не викуплять до кінця повного року, так буде хата, що в утвердженому містї, на завсіди власність того, хто купив її, в роди його; не буде вільною ювілейного року. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Хати по селах, що неутверджені навкруги, будуть нарівнї з полями землї; буде для них право викупу, і в ювілейному роцї виходити муть вільними. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Що ж до міст Левітів, та хат по містах їх, по всяк час можна викуплювати Левітам. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","А коли нїхто з Левітів не викупить, так у ювілейному роцї буде вільна продана хата в містї власностї його; хати бо в містах Левітів їх власність між синами Ізрайлевими. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","І оболоня кругом міст їх не можна продавати, бо се власність їх віковічня. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","І коли зубожіє брат твій і він опустить руки при тобі, мусиш допомогти йому; як приходень і комірник, жити ме при тобі. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Не брати меш із його чиншу і лихви, а будеш боятись Бога твого щоб можна жити братові твойму при тобі. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Грошей не позичати меш йому на чинш, і не давати меш йому поживи на лихву. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Я Господь, Бог твій, що тебе вивів із Египецької землї, щоб оддати вам Канаан землю, і бути в вас Богом. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","І коли зʼубожіє твій брат при тобі і продасться тобі, не поставиш його до невільничої роботи; ");
INSERT INTO ukr1871_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Як наємник, як комірник мусить він бути при тобі; до ювілейного року робити ме в тебе. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","І вийде на волю від тебе й дїти його, та й вернеться до родини своєї, і до батьківщини своєї вернеться. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Вони бо слуги мої, що вивів я із Египецької землї; неможна продавати їх, як продають невільників. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Не панувати меш над ними жорстоко, і мусиш боятись Бога твого. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Що ж до раба твого і до рабинї твоєї, що буде в тебе; нехай будуть із народів, що кругом вас; від них будете купувати рабів і рабинь. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Так само й з дїтей комірників, що пробувають у вас, можна вам купувати із їх родини, що при вас, котру породили вони в землї вашій; і будуть вони вам у власність, ");
INSERT INTO ukr1871_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","І зоставляти мете їх дїтям вашим після вас, щоб мали їх як власність. Ті служити муть на віки; над братами ж вашими, синами Ізрайлевими, не панувати мете жорстоко один над другим. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","І коли руки чуженицї або комірника твого придбають яке добро, а брат твій зʼубожіє при йому та й продасться чужому або комірникові твому, чи кому з родини чуженицї, ");
INSERT INTO ukr1871_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Так послї того, як він продався, мати ме право викупу свого; одному з братів його можна викупити його. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Або син дядька його викупить його, або хто з найблизшої родини його нехай викупить його; або коли руками що заробить, сам нехай викупиться. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","І полїчиться він з тим, хто купив його, від року продажі до року ювілейного, а цїна, за котру продався, буде відповідна лїчбі років; як наємник полїчить він йому днї свої. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Коли ще багацько років, то мусить вернути відповідний викуп свій із грошей, що за них куплено його; ");
INSERT INTO ukr1871_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Коли ж мало зостанеться років до року ювілейного, так нехай розлїчиться з ним: відповідно до років своїх верне викуп свій. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Як наємник буде він із року в рік при йому; не панувати ме він над ним жорстоко перед очима твоїми. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","І коли не викупиться таким робом, так вийде на волю в роцї ювілейному, сам і дїти його з ним. ");
INSERT INTO ukr1871_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Бо мої раби сини Ізрайлеві, вони мої раби, що я вивів їх із Египецької землї. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Не будете робити собі балванів, нї вирізувати образів, нї ставити стовпів, і каменїв з образами не ставляти мете в землї вашій, щоб перед ними бити поклони. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Собити мої мусите держати, і в сьвятинї благовіти. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Коли будете ходити в установах моїх і будете заповідї мої хоронити і сповняти, ");
INSERT INTO ukr1871_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","То давати му вам дощі у свій час, і родити ме земля жниво своє і дерево приносити ме плоди свої. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","І час молочення тревати ме в вас до збору виноградини, а збір виноградини тревати ме до сїйби; і їсти мете хлїб ваш до наситу і жити мете з упокоєм у землї вашій. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","І дам я мир в країнї, і лежати мете собі, і нїхто не буде непокоїти вас; і вигублю хижого зьвіра в країнї, і меч не проходити ме по землї вашій. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","І будете гонити ворогів ваших, і падати муть вони од меча перед вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","І пятеро вас гнати ме сотню, а сотеро вас гнати ме десять тисяч, і падати муть вороги ваші од меча перед вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","І обернусь до вас, і страшними зроблю вас, і намножу вас, і держати му завіт мій з вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","І будете їсти давнолїтні плоди, і прятати давнолїтне перед новим. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","І поставлю храмину мою посеред вас, і не гидувати ме вами душа моя; ");
INSERT INTO ukr1871_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","І ходити му проміж вами, і буду вашим Богом, а ви будете моїм людом. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Я Господь, Бог ваш, що вас вивів із Египецької землї, щоб ви не були підневолені їм; і розірвав я зазвори ярма вашого, і дав вам ходити випроставшись. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Коли ж не послухаєте мене і не будете сповняти всїх заповідей моїх, ");
INSERT INTO ukr1871_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","І коли зневажите установи мої, і гордувати ме душа ваша присудами моїми, так що не сповняти мете всї заповідї мої і зломите заповіт мій; ");
INSERT INTO ukr1871_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Так я зроблю те саме з вами: я допущу на вас страх, сухоти і пропасницю, від якої почорнїє в очах і душа зомлїє; і сїяти мете марно насїннє ваше, вороги бо ваші пожеруть його. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","І поставлю лице моє проти вас, і побють вас вороги ваші; і запанують над вами ненавидники ваші, і втікати мете, хоч нїхто не буде гонити за вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Коли ж і тодї не послухаєте мене, так усемеро побільшу кари ваші за гріхи ваші. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","І зломлю пиху потуги вашої, і зроблю небо над вами як залїзо, а землю вашу як мідь. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","І будете марнувати силу вашу, і не давати ме земля ваша жнива свого, а дерево на полї вашому не давати ме плоду свого. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","А коли ійти мете проти мене й не схочете слухати мене, так усемеро побільшу кари за гріхи ваші. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","І пущу зьвірину польову на вас, що вигубить дїтей ваших, і пожере скотину вашу, і вас поменьшить, та й опустїють шляхи ваші. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Коли ж і після сього не покаєтесь та ійти мете проти мене, ");
INSERT INTO ukr1871_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Так і сам я ійти му проти вас, і сам я побю вас усемеро за гріхи ваші. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","І допущу на вас меча, що помститься за завіт; а коли позабираєтесь у городи ваші, то пішлю морову кару серед вас, і віддам вас в руки ворогові. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Як зломлю підпору вашу, хлїб, тодї пекти муть хлїб ваш десятеро молодиць в однїй печі, і віддавати муть вам хлїб після ваги; і ви їстимете, та й не наїдати метесь. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Коли ж і після сього не послухаєте мене да ійти мете проти мене, ");
INSERT INTO ukr1871_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Так у палкому гнїву ійти му проти вас, і карати му вас усемеро за гріхи ваші. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","І їсти мете тїло синів ваших, і тїло дочок ваших їсти мете, ");
INSERT INTO ukr1871_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","І зруйную високостї ваші, і розібю стовпи ваші соняшні, та й кину трупа вашого на трупа ідольського, і гидувати ме душа моя вами. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","І зроблю городи ваші пустками, і спустошу сьвятощі ваші, і не прийму любих пахощів ваших. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","І спустошу країну вашу, так що й вороги ваші зʼжахнуться, що пробувають у їй. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","І самих вас розпорошу проміж народами, і з мечем пожену за вами; і опустїє земля ваша, а городи ваші обернуться в руїну. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Тодї буде собота на землї по всї днї опустїння її, а ви самі опинитесь у землї ворогів ваших; тодї лежати ме земля облогом, і втїшати меться своїми соботнїми часами. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","По всї днї опустїння свого спочивати ме вона, через те, що не віддихала в соботи ваші, як жили ви на їй. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","А хто останеться з вас, на того серце наведу страх в землї ворога його: і гнати ме його шелест летючого листу, і втїкати ме, як втїкають від меча, і падати ме, хоч нїхто не гнати меться за ним. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","І будуть падати одно через другого, наче перед мечем, хоч нїхто не гнати ме їх; і не буде в вас снаги, щоб остоятись перед ворогами вашими. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","І погибнете між народами, і пожере вас ворожа земля; ");
INSERT INTO ukr1871_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Хто ж останеться з вас, ті потануть в беззаконнях своїх по ворожих землях, і в беззаконнях батьків своїх вкупі з ними. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","І будуть тодї признаватись вони в беззаконнях своїх і в беззаконнях батьків своїх, котрими спроневірились менї, та що ійшли проти мене, ");
INSERT INTO ukr1871_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Та, що й я ійшов проти них, і загнав їх у землю ворогів їх. А коли тодї впокориться необрізане серце їх, і вони спокутують беззаконня свої, ");
INSERT INTO ukr1871_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","То я спогадаю завіт мій з Яковом, і також завіт мій з Ізааком, і завіт мій з Авраамом спогадаю, і землю спогадаю. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Бо опустїє після них земля, і втїшати меться соботнїми часами своїми в час опустїння свого без них; самі ж вони приймати муть кару за беззаконня свої, через те, так через те, що судами моїми погордували і душа їх установами моїми гидувала. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Тільки ж і тодї, як пробувати муть вони в землї ворогів своїх, не відкину їх від себе і не зогиджу їх собі так, щоб їх вигубити та зломити завіт мій з ними; я бо Господь, Бог їх. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ні! Спогадаю задля їх же самих завіт мій з предками їх, що вивів їх із Египецької землї перед очима народів, щоб їх Богом бути. Я Господь. ");
INSERT INTO ukr1871_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Се установи, й присуди, і закони, що постановив Господь проміж собою й синами Ізрайлевими на Синай горі, через Мойсея. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Промов до дїтей Ізрайлевих і скажи їм: Коли хто небудь робить обітницю, то по цїнуванню твому нехай будуть посьвячені душі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Цїнуваннє ж твоє нехай буде: Чоловіка од двайцятьох років і до шістьдесятьох цїна його пятьдесять секлів срібла, по секлям сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","А як жінка, то буде цїна твоя трийцять секлів; ");
INSERT INTO ukr1871_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","А як од пяти років до двайцяти років, так цїна твоя для музького полу буде двайцять секлів, а для женського у трийцять секлів; ");
INSERT INTO ukr1871_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","А як од одного місяця до пятьох років, так цїна твоя буде для хлопчика пять секлів, а цїна твоя для дївчатка три секлів срібла; ");
INSERT INTO ukr1871_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","А як же кому шістьдесять років або він старший, так цїна твоя, коли се чоловік, пятнайцять секлів, а як жінка, десять секлів. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Коли ж той, що робить обітницю, не спроможеться дати по твому цїнуванню, так поставити його перед сьвященником, і цїнувати ме його сьвященник; по мірі того, що може дати той, хто робить обітницю, нехай цїнує його сьвященник. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","А коли се скотина, з тих, що приносять в жертву Господеві, так усяке, що буде дане Господеві, сьвятим стане. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Нехай не переміняє її і не міняє ситу на захарчовану, чи захарчовану на ситу; а коли ж таки замінить скотину за скотину, так і ся й та стануть сьвятими. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","А коли буде яка нечиста скотина, що не приносять в жертву Господеві, так нехай поставить скотину перед сьвященником, ");
INSERT INTO ukr1871_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Та й оцїнить сьвященник, чи годиться вона, чи не годиться. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Як оцїнить її сьвященник, так і мусить бути. Коли ж би хто схотїв викупити її, так нехай додасть пятину до цїни твоєї. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","І коли хто присьвятить дім свій, як сьвятиню Господеві, оцїнить його сьвященник, чи годиться, чи нї. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Як сьвященник оцїнить, так воно й мусить бути. Коли ж той, хто присьвятив, та схоче викупити дім свій, так мусить додати ще пятину гроша по цїнуванню твому, і буде його. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","А коли частину поля свого присьвячує хто Господеві, так оцїниш по мірі висїву його. За один гомер висїву ячменю цїна пятьдесять секлів срібла. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Коли від ювілейного року присьвятить поле своє, зостанеться воно по цїнуванню твому. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","А коли по ювілейному роцї присьвятить поле своє, так сьвященник полїчить йому гроші, по мірі лїт, що остались до ювілейного року, і се буде убавлено від цїни твоєї. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Коли ж той, хто присьвятив, та схоче викупити поле, так наддати мусить пятину срібла по цїнуванню твому, і останеться воно за ним. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","А коли не викупить поля, або продасть поле другому чоловікові, так неможна буде знов викупити його; ");
INSERT INTO ukr1871_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","І буде поле, як вийде вільне в ювілейному роцї, сьвяте Господеві, як поле присьвячене; буде воно сьвященникові як власність його. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","А коли присьвятить Господеві поле куплене, що не належить до власного поля його, ");
INSERT INTO ukr1871_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Так нехай полїчить йому сьвященник, скільки по цїнуванню його виходить до ювілейного року; і віддасть він цїнуваннє твоє того дня, яко сьвяте Господнє. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","В ювілейному роцї вернеться поле знов до того, в кого він купив його, до того, чия земля властиво була. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","А всяка цїна твоя буде секлями сьвятинї; двайцять гер на одну секлю. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Тільки первака від скотини, що вже як первородний належиться Господеві, не присьвячувати ме нїхто. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Коли ж скотина нечиста, так мусить викупити її по цїнуванню твому, наддавши до неї пятину; як же не викупить, так продасться вона по цїнуванню твому. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Тільки все обречене, що хто присьвятив Господеві, усе, що його, чи людина, чи скотина, чи поле його власностї, неможна продавати нї викуплювати; все що обречене, пресьвяте Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Усе присьвячене, що буде присьвячене від людей, не можна викупити; заколене мусить бути. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","І всяка десятина на землї, від насїння землї, від плодів з дерева, буде Господеві; сьвяте Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Коли ж хто схоче викупити яку десятину свою, так пятину її мусить ще додати до неї. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","А всяка десятина з буйної і дрібної скотини, з усього, що проходить під палцею пастуха, десята скотина буде сьвятим Господеві; ");
INSERT INTO ukr1871_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Нехай не розбирають, чи годиться чи не годиться, і нехай не переміняють її; коли ж таки перемінять, так і вона сама й та, що нею замінено, стане сьвятим Господеві; не можна її викупити. ");
INSERT INTO ukr1871_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Се заповідї, що заповідав їх Господь Мойсейові про синів Ізрайлевих на Синай горі.");
INSERT INTO ukr1871_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","І рече Господь Мойсейові в Синайському степу, в соборному наметї, на первий день другого місяця, у другому роцї по виходї із Египецької землї, і каже: ");
INSERT INTO ukr1871_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Перелїчіть усю громаду синів Ізрайлевих, по поколїннях їх, по батьківських домах їх, по лїчбі імен їх, усїх музького полу по головах їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Од двайцяти років і старше, кожного, що зможе стояти в військовій лаві Ізраїля; перелїчуйте їх по полках їх, ти з Ароном, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","І буде в вас один чоловік для кожного поколїння, чоловік, що є головою в батьківському дому свойму. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","І се ймена тих, що стояти муть із вами: Від Рубена: Лейзор Шедеуренко. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Від Симеона: Селуміїль Зуришадайєнко. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Від Юди: Наазон Аминадабенко; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Від Іссахара: Нетанеїль Зуаренко; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Від Зебулона: Єлїаб Гелоненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Від синів Йосифови: від Ефраїма: Елїшама Амігуденко; від Манассе: Гамалеїль Педазуренко; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Від Бенямина: Абидан Гидеонїєнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Від Дана: Ахієзер Амішадаєнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Від Азера: Пагіїль Окраненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Від Гада: Елеасаф Дегуйленко; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Від Нафталїя: Агира Енаненко: ");
INSERT INTO ukr1871_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Се покликані до громади, князі родів батьківських; се були голови над тисячами в Ізраїлї. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","І взяли Мойсей та Арон людей сих, що їх назвав Господь на імя. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","І всю громаду скликали вони на первий день другого місяця. І списано родоводи їх, по родинах їх, по батьківських домах їх, по лїчбі імен, від двайцяти років і старше, по головах їх; ");
INSERT INTO ukr1871_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Як заповідав Господь Мойсейові. І так перелїчив їх у Синай пустинї. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","І було синів Рубена, первеньця Ізрайлевого: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, по головах їх, всього музького полу, від двайцяти років і старше, всїх, що ставали до війська, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Перелїчених з поколїння Рубенового, сорок шість тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Синів Симеонових: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу, від двайцяти років і старше, всїх що ставали до війська, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Перелїчених з поколїння Симеонового, пятьдесять девять тисяч і триста. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Синів Гадових: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу від двайцяти років і старше, що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Перелїчених з колїна Гадового, сорок шість тисяч шістьсот і пятьдесять. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Синів Юдиних: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу від двайцяти років і старше, всїх що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Перелїчених з поколїння Юдиного, сїмдесять чотири тисячі і шістьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Синів Іссахарових: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу від двайцяти років і старше, що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Перелїчених з поколїння Іссахарового, пятьдесять чотири тисячі і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Синів Зебулонових: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу, від двяйцяти років і старше, що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Перелїчено з поколїння Зебулонового, пятьдесять сїм тисяч і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Синів Йосифових: Синів Ефраїмових: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу від двайцяти років і старше, всїх що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Перелїчено з поколїння Єфраїмового, сорок тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Синів Манассеїних: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу від двайцяти років і старше, всїх що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Перелїчено з поколїння Манассеїнового, трийцять дві тисячі і двістї. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Синів Беняминових: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу від двайцяти років і старше, всїх що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Перелїчених з поколїння Беняминового, трийцять пять тисяч і чотири ста. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Синів Данових: Поколїння їх по родинам їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу від двайцяти років і старше, всїх що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Перелїчених з поколїння Данового, шістьдесять дві тисячі і сїмсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Синів Ассерових: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, всього музького полу від двайцяти років і старше, всїх що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Перелїчених з поколїння Ассерового, сорок одна тисяча і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Синів Нафталїєвих: Поколїння їх по родинах їх, по батьківських домах їх, по лїчбі імен їх, від двайцяти років і старше, всїх що до війська ставали, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Перелїчених з поколїння Нафталїєвого, пятьдесять три тисячі і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Се перелїчені, що їх поперелїчували Мойсей та Арон та князї Ізраїльські, що їх було дванайцять чоловіка: були вони кожний за батьківський дім свій. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Так перелїчено синів Ізрайлевих по батьківських домах їх від двайцяти років і старше, всїх що до війська Ізраїльського ставали. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","І було всїх перелїчених шістьсот три тисячі і пятьсот пятьдесять. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Левітів же по батьківському поколїнню не перелїчувано між ними. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Сказав бо Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Тілько Левієве поколїннє не подаси до переписї, і не лїчити меш їх між синами Ізрайлевими, ");
INSERT INTO ukr1871_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","А мусиш поставити Левітів над храминою сьвідчення і над усїм знаряддєм її і над усїм, що до неї належить. Носити муть вони храмину і все знаряддє її, і будуть вони на послугу при нїй, і отаборяться навкруги храмини. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","І як треба буде нести храмину, нехай підносять її Левіти; а як треба зупинитись храминї, становити муть її Левіти. Хто ж чужий наближиться до неї, тому буде смерть. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","І стануть табором сини Ізрайлеві, кожний у свому таборі, і кожний під своїм прапором, пополках своїх. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Левіти ж мусять отаборитись навкруги храмини сьвідчення, щоб не загорівся гнїв мій на громаду синів Ізрайлевих, і будуть Левіти на чатах при храминї сьвідчення. ");
INSERT INTO ukr1871_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","І вчинили сини Ізрайлеві все; як заповідав Господь Мойсейові, так вчинили вони. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","І рече Господь Мойсейові й Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Кожний із синів Ізрайлевих отабориться під прапором своїм, під знамям батьківського дому свого. Навпроти соборного намету, навкруги його стануть табором. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","На схід сонця стануть: Прапор табору Юдиного, по полках своїх, і князь синів Юдиних Нахзон Аминадабенко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","І полки його й перелїчені його сїмдесять чотири тисячі і шістьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","А коло його стане: Поколїннє Іссахарове, і князь синів Іссахарових Нетанеїль Зуаренко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","І полки його й перелїчені його пятьдесять чотири тисячі і чотири ста. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Поколїннє Зебулонове, і князь синів Зебулонових Єлїаб Гелоненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","І полки його і перелїчені його пятьдесять сїм тисяч і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Всїх перелїчених в таборі Юдиному сто вісїмдесять шість тисяч і чотириста пополках їх; перві рушати муть вони. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","На полуднї стануть: Прапор табору Рубенового, по полках своїх; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","І князь синів Рубенових Єлизур Шедеуренко, полки його і перелїчені його сорок шість тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","А поруч його стане поколїннє Симеонове; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","І князь синів Симеонових Селуміїль Зуришадаєнко; полки його і перелїчені його пятьдесять девять тисяч і триста. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Потім поколїннє Гадове; і князь синів Гадових Елїасаф Дегуйленко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","І полки його і перелїчені його, сорок пятьтисяч і шістьсот і пятьдесять. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Усїх перелїчених у таборї Рубена сто пятьдесять одна тисяча і чотириста і пятьдесять по полках їх. Другими вже наступати муть. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","А соборний намет рушати ме вкупі з табором Левітським, в серединї табору; як отаборились, так і рушати муть вони; кожне на місцї свому під прапорами своїми. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","На захід соньця стане прапор Ефраїмів по полках їх; і князь синів Ефраїмових Елїшама Амігуденко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","І полки його і перелїчені його сорок тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","А поруч його стане поколїннє Манассеїне, і князь синів Манассеїних Гамалеїль Педазуренко. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","І полки його і перелїчені його трийцять дві тисячі і двістї. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Потім поколїннє Беняминове, і князь синів Беняминових Абидан Гиденїєнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","І полки його і перелїчені його трийцять пять тисяч і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Усїх перелїчених в таборі Ефраїмовому сто вісїм тисяч і сто по полках їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","На півночі стане прапор табору Данового по полкам їх, і князь синів Данових Ахієзер Амішадаєнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","І полки його і перелїчені його шістьдесять дві тисячі і сїмсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","А поруч його стане: поколїннє Ассерове, і князь синів Ассерових Пагіїль Окраненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","І полки його й перелїчені його сорок і одна тисяча і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","І поколїннє Нефталїєве, і князь синів Нефталїєвих Агира Енаненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","І полки його й перелїчені його пятьдесять три тисячі і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Усїх перелїчених в Дановому таборі сто пятьдесять сїм тисяч і шістьсот по полках їх. Останніми вже рушати муть. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Се перелїчені сини Ізрайлеві по батьківських домах їх. Усїх перелїчених у таборах по полках їх було шістьсот три тисячі і пятьсот пятьдесять. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Левітів же не перелїчувано між синами Ізрайлевими, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","І чинили сини Ізрайлеві все, що заповідав Господь Мойсейові: так отаборувались по прапорах своїх, і так рушали у похід кожний по родинах своїх і по батьківських домах своїх. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","А се постань Аронова та Мойсейова, як розмовляв Господь із Мойсейом на Синай горі. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","І се ймена синів Аронових: Надаб, первенець, та Абигуй, Єлеазар та Ітамар. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Се ймена синів Аронових, помазаних сьвященників, висьвячених, щоб служили сьвященну службу. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","І померли Надаб та Абигуй перед Господом, як приносили чужий огонь перед Господом в Синайському степу, дїтей же в їх не було. І були сьвященниками Єлеазар та Ітамар перед лицем Арона, батька свого. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Нехай приступить поколїннє Левієве, та й поставиш їх перед Ароном сьвященником, щоб услуговували вони йому. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","І нехай вони дбають про все, що йому треба, йому й усїй громадї в соборному наметї, щоб служити службу в сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","І будуть доглядати знадібя в соборному наметї та стерегчи синів Ізраїля, щоб відправляли службу в храминї. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","І віддаси Левітів Аронові й синам його; зовсїм віддані йому будуть вони зміж синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Арона ж і синів його поставиш до сьвященичої служби; коли ж чужениця який приступить, передати його смертї. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Се я сам узяв Левітів зміж синів Ізрайлевих замість усїх первенцїв, що їх приводить мати між синами Ізрайлевими, і будуть Левіти моїми. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Мій бо всякий первенець: Того дня, як повбивав я усї первеньцї в Египецькій землї, присьвятив я собі всї первенцї в Ізраїлї, від людини до скотини; менї будуть вони, менї Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","І рече Господь Мойсейові в Синайському степу: ");
INSERT INTO ukr1871_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Перелїчи сини Левієві по батьківських домах їх, по родинах їх. Увесь музький пол їх мусиш перелїчити; від одномісячного немовлятка й старше перелїчиш їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","І перелїчив їх Мойсей по слову Господньому, як він заповідав. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","І були сї сини Левієві по йменах своїх: Герзон і Кегат і Мерарій. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","І се ймена синів Герсона по родинах їх: Лїбнїй і Семій. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","А сини Кегата по родинах їх: Амрам та Їзгар, Геброн та Узеїль. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","А сини Мерари по родинах їх: Махлїй та Мушій. Се родини Левієві, по батьківських домах їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Від Герсона: родина Лабнїїв і родина Семіїв; се родана Герсонїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Перелїчених їх по лїчбі всього музького полу, від одномісячного немовлятка і старше перелїчених їх, сїм тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Родини Гереонїїв отаборились за храминою, на захід соньця. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","А князь батьківського дому в Герсонїїв був Елясаф Лаеляненко. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","І мали доглядати Герсонїї в соборному наметї: храмину й намет і покриттє його і завісу коло входу в соборний намет, ");
INSERT INTO ukr1871_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","І завісу в дворі і завісу при входї до двора, що навкруги храмини й жертівника і посторонків його на всю потріб їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","А від Кегата родина Амраміїв і родина Їзгаріїв і родина Гебронїїв і родина Узіелїїв. Се родина Кегатіїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","По лїчбі всього музького полу, від одного місяця і старше, вісїм тисяч шістьсот, що були сторожі коло сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Родини синів Кегата отаборились з полуденного боку храмини. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","А князь батьківського дому в родин Кегатіїв був Елїзафал Узієленко. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","А доглядали вони: скриню й стола і сьвітильника і жертівників і посудини в сьвятинї, що були для служби, і завіси і всього, що треба робити. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","А князь над князями Левітів Елеазар, син Арона сьвященника; він був доглядачем над тими, що були на сторожі коло сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Від Мерарія: родина Махелїїв і родина Мушіїв; се родини Мераріїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","І перелїчених їх по лїчбі всього музького полу, від одного місяця і старше: шість тисяч і двістї. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","А князь батьківського дому в родинї Мераріїв був Зурієль Абихайлїєнко. Стояли вони табором на північньому боцї храмини. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","А мали доглядати сини Мерарія: Дощок храмини і засовів її і стовпів її і підніжків її, і всієї посудини і всякої служби при них; ");
INSERT INTO ukr1871_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","І стовпів навкруги двора і підніжків їх і приколків їх і мотузів їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","А ті, що спереду храмини, проти сходу, перед соборним наметом на схід сонця отаборились, були Мойсей та Арон та сини його, що були на сторожі коло сьвятинї замість синів Ізрайлевих. Коли ж посторонний чоловік наближеться, то буде йому смерть. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Усїх перелїчених Левітів, що перелїчив Мойсей з Ароном, як заповідав Господь, по родинах їх, всього музького полу, від одного місяця і старше, було двайцять і дві тисячі. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","І рече Господь Мойсейові: Перелїчи всї первенцї музького полу в синів Ізрайлевих, від одного місяця й старше, і позлїчуй імена їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","І мусиш узяти Левітів для мене, Господа, замість усїх первеньцїв із синів Ізрайлевих, і скотину в Левітів замість усїх перваків із скотини в синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","І перелїчив Мойсей, як заповідав Господь йому, все первородне у синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","І було всїх первеньцїв музького полу, по лїчбі імен, від одного місяця і старше, по перелїку їх, двайцять дві тисячі двістї сїмдесять і три. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Возьми Левітів замість усїх первеньцїв із синів Ізрайлевих, і будуть моїми Левіти; Господнїми. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","А тих двістї сїмдесять і трйох первеньцїв із синів Ізрайлевих, що їх більше над лїчбу Левітів, мусиш викупити; ");
INSERT INTO ukr1871_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","І взяти по пять секлїв за голову; по секлям сьвятинї возьмеш, двайцять гер за один секель. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","А срібло віддаси як викуп за тих, що над лїчбу їх більше, Аронові та синам його. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","І взяв Мойсей викупні гроші з тих, що були на лїчбу викуплених Левітами; ");
INSERT INTO ukr1871_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","За первеньцїв у синів Ізрайлевих узяв срібла тисячу триста шість десять і пять секлїв, по секлям сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","І віддав Мойсей викупні гроші Аронові та синам його, по слову Господньому, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","І рече Господь Мойсейові й Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Перелїчіть голови в синів Кегатових, між синами Левієвими, по родинах їх, по батьківських домах їх, ");
INSERT INTO ukr1871_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Від трийцять років і старше аж до пятьдесяти років, усїх спосібних до роботи, щоб робити дїло при соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Буде ж служба синів Кегатових коло соборного намету: носити сьвятиню сьвятинь. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","І увійдуть Арон та сини його, як треба рушати таборові, і знїмуть вони закриваючу завісу і вкриють нею скриню сьвідчення; ");
INSERT INTO ukr1871_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","І положять вони на ню покривало із барсучих шкір і накинуть на неї простирало з блавату та й повсовують носила її. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","І стіл для покладного хлїба застелють обрусом з блавату та й поставлять на йому полумиски і чаші і кадильницї і збанки для жертви ливної; і повсячасний хлїб буде на йому. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","І на все те накинуть покривало з кармазину і покриють покривалом із барсукових шкір; та й повсовують носила його; ");
INSERT INTO ukr1871_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","І возьмуть плахту з блавату та й накриють сьвітильника й лямпи його і щипцї його і гасїльницї його і всю посудину на олїю до його, що її уживають до його. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","І обгорнуть його й усю посудину його покривалом з барсучих шкір, та й положять на ноші. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","А на жертівника золотого накинуть плахту з блавату, та й укриють його покривалом із барсучих шкір і повсовують носила його. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","І возьмуть всю посудину службову, що на службу в сьвятинї, та й положять її в плахту блаватову та й накриють покривалом із барсучих шкір і положять на ноші. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","І виберуть попіл із жертівника та й накриють його обрусом з пурпуру, ");
INSERT INTO ukr1871_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","І положять на йому увесь посуд його, потрібний до служби на йому: кадильницї і вилка й кочерги і бризькала і все надібє до жертівника; і накриють все те покривалом з барсучих шкір, та й попросовують носила його. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","А як Арон і сини його скіньчать накривати сьвятиню і всю посудину сьвятинї, щоб рушити потім з табором, то прийдуть тодї синове Кегата, щоб нести, та щоб не торкнулись сьвятого та й не вмерли. Се те із соборного намету, що синове Кегата нести мають. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Елеазар же, син Арона сьвященника, мати ме догляд над олїєю для сьвітильника та над кадильними пахощами, та над повсячасною жертвою хлїбною, та над миром, та догляд над цїлою храминою і над усїм, що є в нїй, над сьвятинею як і над посудиною її. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","І рече Господь Мойсейові та Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Дбати мете ви, щоб поколїння родин Кегатіїв не викоренилось зміж Левітів; ");
INSERT INTO ukr1871_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","А от що чинити мете з ними, щоб жили та не померли, як приступлять до пресьвятого: Арон і сини його мусять увійти і поставити кожного з них до його служби і до тягару його; ");
INSERT INTO ukr1871_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Та неможна їм увійти та й озирати сьвяте хоч би тілько на хвилинку, ато помруть. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Перелїчи голови синів Герсонових по батьківських домах їх, по родинах їх; ");
INSERT INTO ukr1871_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Від трийцяти років і старше до пятьдесять років перелїчиш їх, усїх спосібних до роботи, щоб послугували в соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Буде ж робота родин Герсонових, що до служби і до тягарів, така: ");
INSERT INTO ukr1871_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Нести муть вони келїми храмини, і соборний намет, покривало його і покривало із барсучих шкір, що зверху на йому, та завісу коло входу в соборний намет, ");
INSERT INTO ukr1871_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","І опони з двора, і опону, що при входї воріт у дворі, що є кругом храмини і жертівника і мотузи до них і всяку посудину службову їх; і все, що треба зробити з ними, мусять зробити. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","По приказам Арона і синів його буде вся послуга синів Герзонїїв, чи нести муть тягарі чи робити муть яку роботу свою; і поручите їм берегти усе, що нести муть. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Така послуга родин синів Герсонїїв при соборному наметї; а дбати муть вони про службу під доглядом Ітамара, Ароненка, сьвященника. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Синів Мерарієвих перелїчиш по родинах їх, по батьківських домах їх; ");
INSERT INTO ukr1871_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Від трийцяти років і старше до пятьдесять років перелїчиш їх, усїх, що стануть до роботи, на послугу в соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","І се тягарі, що їх нести мають, по службі своїй в соборному наметї: дошки храмини і засуви її і стовпи її і стояла їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","І стовпи в дворі всї кругом і стояла їх і прикілки їх і верівки їх, з усїм знаряддєм їх і зо всїєю послугою їх; і розлїчіть по йменам речі, що мають їх нести. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Се послуга родин синів Мерарієвих, по всякій службі їх у соборному наметї, під надзором Ітамара Ароненка, сьвященника. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","І перелїчили Мойсей та Арон та князї громадські Кегатових синів по родинах їх і по батьківських домах їх; ");
INSERT INTO ukr1871_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Від трийцяти років і старше до пятьдесять років, усїх спосібних до роботи, на послугу в соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","І було перелїчених їх по родинах їх дві тисячі сїмсот і пятьдесять. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Се перелїчені з родин Кегатових, всї що були на послугу при соборному наметї, що їх перелїчив Мойсей та Арон, по слову Господньому через Мойсея. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Перелїчено і синів Герсонових по родинах їх, по батьківських домах їх, ");
INSERT INTO ukr1871_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Від трийцяти років і старше до пятьдесять років, всїх спосібних до роботи, на послугу в соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","І було перелїчених їх по родинах їх, по батьківських домах їх, дві тисячі шістьсот і трийцять. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Се перелїчені з родин Герсонових, всї що послугували при соборному наметї, що їх перелїчили Мойсей та Арон, по слову Господньому. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","І перелїчено родини в синів Мерарієвих по семях їх, по батьківських домах іх, ");
INSERT INTO ukr1871_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Від трийцяти років і старше до пятьдесять років, усїх спосібних до роботи, на послугу в соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","І було перелїчених їх по родинам їх, три тисячі й двістї. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Се перелїчені з родин синів Мерарієвих, що перелїчили Мойсей та Арон, по слову Господньому через Мойсея. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Усїх перелїчених Левітів, що перелїчив їх Мойсей з Ароном та з князями Ізрайлевими, по родинах їх, по батьківських домах їх, ");
INSERT INTO ukr1871_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Від трийцяти років і старших, до пятьдесять років, усїх, що ставали на службу при соборному наметї, щоб послугу робити і носити, ");
INSERT INTO ukr1871_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Було перелїчених їх, вісїм тисяч пятьсот і вісїмдесять. ");
INSERT INTO ukr1871_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Перелїчено їх по слову Господньому через Мойсея, кожного по послузї своій і по тягарах своїх, що їх нести мають. І перелїчено їх, як повелїв Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Повели синам Ізрайлевим висилати з табору всякого прокаженого й усякого з течивом і всякого, хто зробиться нечистим од мерця. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Як чоловіка, так жінку мусите висилати геть із табору, щоб не занечистили шатрів своїх, що серед їх я витаю. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","І вчинили так сини Ізрайлеві; і стали висилати їх із табору; як приказав Господь Мойсейові, так і стали чинити сини Ізрайлеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Промов до синів Ізрайлевих: Коли чоловік або жінка вчинять який гріх проти людини, та спроневіряться тим Господеві, і провиниться душа, ");
INSERT INTO ukr1871_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Так покаятись мусять у грісї свому, котрим согрішили; і хто зробив кривду, мусить в повнї вернути, та ще пятину того наддати, і тому віддати, кого скривдив. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","А коли в людини та нема родича, щоб вернути йому кривду, так нехай верне кривду Господеві, і буде вона сьвященникові, опріч барана жертви премирення, що буде на покуту за його. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","І буде йому всяка жертва підношення з усяких сьвятих приносів, що приносять їх сини Ізрайлеві сьвященникові. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","І все, що хто посьвятить, буде його; що хто дає сьвященникові, його буде. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Промов до синів Ізрайлевих і скажи їм: Коли зверне жінка чия на бік, і спроневіриться чоловікові свому, ");
INSERT INTO ukr1871_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","І зляжеться хто з нею, і буде воно втаєно від очей чоловіка її, і тайкома нечистою стала вона, та нема сьвідка проти неї, а самої не поймано на вчинку; ");
INSERT INTO ukr1871_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Та ревнивий дух схопить його, і буде він ревнувати на жінку, як вона опоганилась; або зійде на його дух ревнивий, і стане він ревнувати на жінку свою, а вона не опоганилась; ");
INSERT INTO ukr1871_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","То приведе чоловік той жінку до сьвященника, і принесе приніс її задля неї, десятину ефи ячмінної муки; не наливати ме олїї на неї і не класти ме ладану; бо се приніс за ревнуваннє, хлїбний приніс на спомин, що нагадує провину. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","І скаже їй приступити сьвященник, і поставить її перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","І возьме сьвященник води сьвятої в посудину глиняну; та возьме сьвященник пороху, що на долївцї в храминї, та й вкине його в воду. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","І поставить сьвященник жінку перед Господом, і відкриє голову жінцї, і положить на руки її хлїбний приніс поминальний; се приніс за ревнуваннє; а в руцї сьвященника буде гірка вода, що наводить прокляттє. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","І заклинати ме сьвященник її, і казати ме жінцї: Коли не лежав нїхто з тобою, і коли ти, бувши за чоловіком твоїм, не спроневірилась мужові нечистотою, то будь не пошкоджена від сієї води гіркої, що наводить прокляттє; ");
INSERT INTO ukr1871_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Коли ж ти, бувши за чоловіком твоїм, спроневірилась і опоганила себе, і лежав з тобою хто окрім чоловіка твого, ");
INSERT INTO ukr1871_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","І заклене жінку сьвященник клятьбою прокляття, і промовить сьвященник до жінки: І нехай зробить Господь проклятою і злорікою тебе серед люду твого, і нехай допустить, щоб опало лоно твоє і опух живіт твій. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","І ся вода, що наводить прокляттє, увійде в утробу твою, щоб твій живіт опух і щоб лоно твоє опало. І скаже жінка: Амінь, амінь! ");
INSERT INTO ukr1871_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","І запише прокляття сї сьвященник у книзї, та й змиє їх водою гіркою; ");
INSERT INTO ukr1871_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","І дасть він жінцї напитись гіркої води, що наводить прокляттє, щоб увійшла вода в неї для гіркостї. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","І возьме сьвященник із руки в жінки приніс за ревнуваннє, і похитувати ме сим даром перед Господом, і принесе його до жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","І возьме сьвященник жменю із приносу, як частку на спомин та й пустить з димом на жертівнику; а потім дасть жінцї води напитись. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","А як дасть їй води напитись, то станеться, коли опоганилась вона і спроневіралась чоловікові свому, так вода, що наводить прокляттє, увійде в неї для гіркостї, і опухне живіт в неї, та й опаде лоно в неї; і стане жінка проклятою між людом своїм. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","А коли жінка не опоганила себе, а чиста вона, так буде непошкоджена і зачне насїннє. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Се закон про ревнуваннє: Як жінка, бувши за мужом своїм, зверне на бік і опоганить себе, ");
INSERT INTO ukr1871_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Або коли обійме чоловіка ревнивий дух, і ревнує він на жінку свою, і ставляє жінку перед Господом, так сповнить над нею сьвященник увесь той закон. ");
INSERT INTO ukr1871_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","І проститься чоловікові провину його, а жінка нести ме на собі гріх свій. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Промов до синів Ізрайлевих і скажи їм: Коли чоловік чи жінка захоче присьвятити себе шлюбом назарейським, щоб відлучившись віддатись Господеві, ");
INSERT INTO ukr1871_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Од вина й трунку запиваючого мусить здержуватись: оцту винного й оцту трункового не пити ме; і жадного соку виноградного не пити ме, і не їсти ме нї сьвіжого нї сушеного винограду. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","По ввесь час назарейства свого не їсти ме нїчого, що зроблено з винограду, чи воно із зерен, чи з лушпиння. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","По ввесь час шлюбу його назарейського бритва нехай не торкається голови його; покіль не мине час той, що він відлучився для Господа, сьвятим буде він; нехай запустить волосся на голові своїй. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","По ввесь час, як відлучиться він для Господа, до жадного трупа не приступати ме. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Задля батька свого або матері своєї, задля брата свого або сестри своєї, коли помре хто з них, нехай не опоганює себе; бо посьвяченнє Бога його на голові його. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","По всї днї назарейства свого він присьвячений Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","І коли хто вмре, несподївано, при йому, і він опоганив посьвят голови своєї, так мусить остригти голову собі в день очищення свого; семого дня остриже її. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","А восьмого дня подасть дві горлицї чи двоє голубенят сьвященникові, коло входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","І принесе сьвященник одно як жертву за гріх, а друге на всепаленнє, і спокутує його за те, що опоганив себе коло мерця; і осьвятить голову йому того ж дня. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","І почне він знов днї свого відлучення назарейського Господеві, та й принесе ягня однолїтне в жертву за провину; попереднї ж днї пішли марно, бо опоганений посьвят його назарейський. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","І се закон про назарея: Того дня, як сповниться час відлучення його, приведуть його до входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","І принесе він жертву свою Господеві: однолїтне ягня без скази на всепаленнє, та однолїтню ягничку без скази на жертву за гріх; і барана одного без скази на жертву мирну, ");
INSERT INTO ukr1871_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","І кошик опрісноків: коржів із пшеничної муки, замішаної на олїї, та палениць незаквашених, помазаних олїєю; а вкупі з ними і хлїбну і ливну жертву свою. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","І приведе їх сьвященник перед Господа, і принесе його жертву за гріх і всепаленнє його. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","А барана принесе як жертву мирну Господеві вкупі з кошиком опрісноків, і принесе сьвященник хлїбну і ливну жертву його. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","І остриже назарей коло входу в соборний намет голову назарайства свого, і возьме волоссє з голови назарейства свого та й положить на вогонь, що під жертвою мирною. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","І возьме сьвященник лопатку варену з барана, і колача прісного одного з кошика, і паленицю прісну одну, та й положить на руки назареєві, послї, як остриже назарейство своє, ");
INSERT INTO ukr1871_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Та й принесе їх сьвященник в жертву гойдану перед Господом; се буде сьвяте сьвященникові з грудиною жертви гойданої і з лопаткою жертви підношеної. А після сього можна назареєві вино пити. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Се закон про назарея, що робить обітницю, і про приноси його Господеві за назарейство своє, опріч того, на що спромога його. По обітницї своїй, яку шлюбував, так чинити ме по закону назарейства свого. ");
INSERT INTO ukr1871_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Промов до Арона й до синів його й скажи: Так будете благословляти синів Ізрайлевих; мовлячи їм: ");
INSERT INTO ukr1871_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Господь благослови тебе, і хорони тебе! ");
INSERT INTO ukr1871_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Господь нехай сьвітить лицем своїм над тобою, та милує тебе! ");
INSERT INTO ukr1871_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Нехай оберне Господь лице своє на тебе і дасть тобі впокій! ");
INSERT INTO ukr1871_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","І так нехай взивають імя моє на Ізраїля, і я благословити му їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","І було се того дня як скіньчив Мойсей ставити храмину, і помазав її та й осьвятив її, і всю посудину її, і жертівника і всю посудину його, і як він помазав і осьвятив їх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","То прийшли князї Ізрайлеві, голови батьківських домів їх, що були князями поколїнїв, і начальниками перелїчених, ");
INSERT INTO ukr1871_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","І принесли приноси свої перед Господа: шість критих возів і дванайцять волів, один віз на два князї, та один віл за кожного з них, і привели їх перед храмину. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Возьми їх від них, і будуть вони на службу в соборному наметї, і передай їх Левітам, кожному, що годиться по службі його. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","І взяв Мойсей вози й волів та й оддав їх Левітам. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Два вози і чотири воли віддав синам Герсоновим, дивлючись по їх послузї, ");
INSERT INTO ukr1871_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","А чотири вози і вісїм волів оддав синам Мерарієвим, дивлючись по їх послузї під доглядом Ітамара, сина Арона, сьвященника. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Синам же Кегатовим не дав нїчого; вони бо робили послугу коло сьвятинї, — на плечах носили її. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","І приносили князї посьвятні дари жертівника того дня, як помазано його; і принесли князї дари свої перед жертівником. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","І рече Господь Мойсейові: Щодня приносити ме один князь приноси свої на осьвяченнє жертівника. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","І той, що принїс первого дня свій приніс, був Нахзон Аминадабенко, з поколїння Юдиного. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","А приніс його був: один полумисок срібний, сто трийцять секлїв вагою, кубок срібний в сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, як жертва хлїбна; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Одна чаша, десять секлїв золота вагою, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Один молодий бик, один баран, одно ягня однолїтне, на всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Один козел на жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","А на жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят однолїтків пятеро. Се був приніс Нахзона Аминадабенка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","На другий день приносив жертву князь синів Иссахарових, Нетанеїль Зуаренко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","А жертва його була: один полумисок срібний, сто і трийцять секлїв вагою, один кубок срібний, сїмдесять секлїв вагою, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, як хлїбна жертва; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Чаша одна, десять секлїв золота вагою, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Молодий бик один, баран один, ягня перволїтне одно на всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Козел один на жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","А на жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтнїх пятеро. Се був приніс Нетанеїла Зуаренка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","На третїй день князь синів Зебулонових, Елияб Голоненко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","А приніс його такий: один полумисок срібний вагою сто і трийцять секлїв, один срібний кубок вагою сїмдесять секлїв, по секлеві сьвятинї, обидви повні муки пшеничної, замішаної на олїї, на жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Чаша одна вагою десять секлїв золота, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Молодий бик один, баран один, ягня перволїтне одно на всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Козел один на жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","А на жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се був приніс Елияба Гелоненка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","На четвертий день князь синів Рубенових, Елизур Шедеуренко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","А приніс його був: один полумисок срібний, вагою сто трийцять секлїв, один кубок срібний, вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Чаша одна, вагою десять секлїв золота, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Бичок один, баран один, ягня перволїтне одно на всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Козел один на жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","А на жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се приніс Єлизура Шедеуренка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","На пятий день князь синів Симеонових, Селуміїль Зуришадаєнко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","А приніс його був такий: один полумисок срібний вагою сто трийцять секлїв, один кубок срібний вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Чаша одна вагою десять секлїв золота, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Бичок один, баран один, ягня однолїтне одно на всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Козел один на жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","А на жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се приніс Селуміїла Зуришадаєнка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","На шестий день князь у синів Гадових, Єлеасаф Дегуйленко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","А приніс його такий: полумисок срібний один вагою сто трийцять секлїв, кубок один срібний вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Чаша одна вагою десять секлїв золота, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Бичок один, баран один, ягня однолїтне одно на всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Козеня одно на гріхожертву; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","А на жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се приніс Єлеасафа Дегуйленка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","На семий день князь синів Ефраїмових, Елїшама Амігуденко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","А приніс його такий: полумисок срібний один вагою сто трийцять секлїв, кубок один срібний вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Чаша одна вагою десять секлїв золота, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Бичок один, баран один, ягня перволїтне одно на всепаленнє. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Козел один на жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","А про жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се приніс Єлїшама Амігуденка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","На восьмий день князь синів Манассеїних Гамалеїль Педазуренко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","А приніс його такий: полумисок срібний вагою сто трийцять секлїв, кубок один вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Чаша одна вагою десять секлїв золота повна ладину. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Бичок один, баран один, ягня перволїтне одно про всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Козел один про жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","А про жертву мирну волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро! Се приніс Гамалеїла Педазуренка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","На девятий день князь синів Беняминових, Абидан Гидеонїєнко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","А приніс його такий: полумисок срібний один вагою сто трийцять секлїв, кубок один срібний вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Чаша одна вагою десять секлїв золота, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Бичок один, баран один, ягня перволїтне одно на всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Козел один про жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","А про жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се приніс Абидана Гидеонїєнка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","На десятий день князь синів Данових, Ахієзер Амішадаєнко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","А приніс його був такий: полумисок срібний один вагою сто трийцять секлїв, кубок срібний один вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Чаша одна вагою десять секлїв золота, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Бичок один, баран один, ягня перволїтне одно про всепаленнє, ");
INSERT INTO ukr1871_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Козел один про жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","А про жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се приніс Ахієзера Амішадаєнка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","На одинайцятий день князь синів Ассерових Пагіїль Окраненко. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","А приніс його був такий: полумисок срібний один вагою сто трийцять секлїв; кубок один срібний вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Чаша одна вагою десять секлїв золота; повна кадила. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Бичок один, баран один, ягня перволїтне одно про всепаленнє; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Козел один про жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","А про жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се приніс Паліїла Окраненка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","На дванайцятий день князь синів Нафталїєвих Агири Єнаненка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","А приніс його був такий: полумисок срібний один вагою сто трийцять секлїв; кубок один срібний вагою сїмдесять секлїв, по секлеві сьвятинї, обидва повні муки пшеничної, замішаної на олїї, про жертву хлїбну; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Чаша одна вагою десять секлїв золота, повна кадила; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Бичок один, баран один, ягня перволїтне одно про всепаленнє. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Козел один про жертву за гріх; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","А про жертву мирну: волів пара, баранів пятеро, козлів пятеро, ягнят перволїтків пятеро. Се приношеннє Агири Енаненка. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Се дари на посьвят жертівника, в день його помазання від князїв Ізраїля: полумисків срібних дванайцять, кубків срібних дванайцять, чаш золотих дванайцять; ");
INSERT INTO ukr1871_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Вагою сто трийцять секлїв кожен полумисок срібний і сїмдесять секлїв кожен кубок. Увесь посуд срібний вагою дві тисячі й чотири ста секлїв, по секлеві сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Чаш золотих дванайцять, повних кадила, по десять секлїв кожна чаша, по секлеві сьвятинї; всього золота в чашах сто двайцять секлїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Усієї буйної скотини про всепаленнє було: дванайцять бичків; дванайцять баранів, дванайцять ягнят перволїтків, а до них хлїбні дари; дванайцять козлів про жертву за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","А всієї буйної скотини на жертву мирну було двайцять і чотири бичків; крім того шістьдесять баранів, шістьдесять козлів, і шістьдесять ягнят перволїтків. Се посьвятні дари жертівника в день помазання його. ");
INSERT INTO ukr1871_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","І як увійшов Мойсей у громадянський намет розмовляти з ним, так почув голос, що промовляв до його з віка, що на скринї сьвідчення, і спроміж обох херувимів: і промовляв до його. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Промов до Арона й скажи йому: Як засьвічуєш лямпи, так на передньому боцї сьвітильника мусять сьвітити сїм лямп. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","І чинив так Арон: на передньому боцї сьвітильника засьвічував лямпи, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","А сьвітильник був такої роботи: кована робота із золота; і держало його і квітки його, все було кованої роботи; по взорцеві, що Господь показав його Мойсейові, так і зроблено сьвітильника. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Возьми Левітів зміж синів Ізраїля та й очисти їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Та ось що мусиш вчинити з ними, щоб їх очистити: покропи їх водою очищаючою гріхи, і нехай обголять вони бритвою все тїло своє, і повипирають одїж свою та й очистяться. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","І нехай візьмуть вони бичка і хлїбні дари до його; муку пшеничну перемішану з олїєю; а бичка другого візьмеш про жертву за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","І приведеш Левітів перед соборний намет і скличеш усю громаду синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","І скажеш приступити Левітам перед Господа, і покладуть сини Ізрайлеві руки свої на Левітів. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Арон же посьвятить Левітів перед Господом від синів Ізрайлевих, щоб відправляли службу Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","А Левіти покладуть руки свої на голову бичкам; і принесеш одного в жертву за гріх, а другого на всепаленнє Господеві, щоб відправити покуту за Левітів. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","І поставиш Левітів перед Ароном і перед синами його, і посьвятиш їх Господеві; ");
INSERT INTO ukr1871_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","І повиличуєш Левітів зміж Ізраїля, щоб мої були Левіти. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Та й увійдуть після сього Левіти на служеннє в соборний намет. Так очистиш їх, і посьвятиш їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Бо оддано їх у власність менї з між синів Ізрайлевих; замість всього, що приведе мати, замість всїх первороднїх синів Ізрайлевих, взяв я їх собі. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Моє бо все первородне між синами Ізрайлевими, і людина і скотина. Того дня, як я повбивав усїх первеньців у землї Египецькій присьвятив я їх собі. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","І взяв я Левітів замість усїх первеньцїв між синами Ізрайлевими; ");
INSERT INTO ukr1871_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Та й оддав я Левітів Аронові й синам його як підданих із між синів Ізрайлевих, щоб вони послугували при службі синів Ізраїля в соборному наметї, та щоб відправляли покуту за синів Ізрайлевих, щоб на синів Ізрайлевих не постигла кара за те, як би приступили сини Ізрайлеві до сьвятинї. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","І Мойсей та Арон та громада синів Ізрайлевих вчинили так з Левітами; все, що заповідав Господь про Левітів, вчинили так з ними сини Ізрайлеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","І очистились Левіти, і повипирали одїж свою, і посьвятив їх Арон перед Господом, і відправив Арон покуту за них про очищеннє їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","І після того увійшли Левіти в соборний намет, щоб послугувати перед Ароном і перед синами його. Як заповідав Господь Мойсейові про Левітів, так і вчинили з ними. ");
INSERT INTO ukr1871_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Се закон про Левітів: від двайцять пять років і старше мусять вони ставати до служби в соборному наметї, ");
INSERT INTO ukr1871_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","А від пятьдесять лїт можна вертатись їм із служби, і можна їм не служити більш; може він помагати браттї своїй при соборному наметї, щоб доглядати всього; но служби не робити ме. Так мусиш чинити з Левітами, що до служби їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","І рече Господь Мойсейові в Синайському степу, в другому роцї по виходї із землї Египецької, у первому місяцї: ");
INSERT INTO ukr1871_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Нехай сьвяткують сини Ізрайлеві в призначений час паску. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","На чотирнайцятий день місяця сього, між двома вечорами, сьвяткувати муть вони; по всїм установам її і по всїм приписам її мусите сьвяткувати її. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","І промовив Мойсей до синів Ізрайлевих, щоб сьвяткували паску. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","І сьвяткували вони паску на чотирнайцятий день первого місяця, між двома вечорами, у Синайському степу; як заповідав Господь Мойсейові, так і чинили сини Ізрайлеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Та були такі люде, що опоганились від трупа людського, і не можна їм було сьвяткувати паски в той день; і приступили вони в той день перед Мойсея та перед Арона. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","І сказали сї люде до його: Ми нечисті від людського трупу; чому не вільно нам приносити дари Господеві серед синів Ізрайлевих у призначений час? ");
INSERT INTO ukr1871_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","І каже до них Мойсей: Пождїть, я послухаю, що повелить Господь задля вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","І розмовляв Господь з Мойсейом кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Промов до синів Ізрайлевих і скажи: Коли хто з вас буде нечистий від трупа, чи буде в далекій дорозї, так усе таки мусить сьвяткувати паску Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","У другому місяцї, на чотирнайцятий день, між двома вечорам, сьвяткувати муть її; з опрісноками й гіркими зіллями їсти муть її. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Нїчого не зоставляти муть із неї до ранку, і кісток не ломити муть у їй; по всїм установам паски сьвяткувати муть її. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Чоловік же чистий і що не в дорозї, а занедбав сьвяткувати паску, викорениться душа його зміж людей його; бо не принїс жертви Господеві у призначений час; чоловік той нести ме свій гріх. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","А коли пробуває в вас приходень і хоче сьвяткувати паску Господеві, то нехай сьвяткує по установам паски і по приписам її. Установа буде одна про вас, і про приходня, і про землянина. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Того ж дня, як поставлено храмину, вкривала хмара храмину намету сьвідчення; і звечора була вона над храминою наче поломя аж до ранку. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Так було щоразу: хмара вкривала її за дня, а наче поломя в ночі. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","І як піднялась хмара над наметом, рушали в дорогу сини Ізрайлеві; на тому ж місцї, де хмара спускалась, там отаборувались Ізрайлеві сини. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","По слову Господньому рушали в дорогу сини Ізрайлеві, і по слову Господньому отаборувались; по всї днї як зоставалась хмара над храминою, стояли вони табором. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","І як хмара стояла довгий час над храминою, тодї відправляли сини Ізрайлеві службу Господеві й не рушали в дорогу. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","І тодї ж стояла хмара тільки кілька день над храминою: — по слову Господньому ставали табором вони, і по слову Господньому рушали дальше. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","І бувало, що зоставалась хмара з вечора до ранку, а в раньцї піднялась хмара, тодї рушали вони в дорогу; або один день і одну ніч, і хмара піднялась, то рушали вони дальше; ");
INSERT INTO ukr1871_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Або два днї, або місяць, або й довше; як зоставалась хмара над храминою спочиваючи над нею, то стояли сини Ізрайлеві табором і не пускались в дорогу; а як піднялась вона, в гору, тодї йшли в дорогу. ");
INSERT INTO ukr1871_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","По слову Господньому становились вони станом, і по слову Господньому рушали дальше; пильнували вони служби Господньої по слову Господньому через Мойсея. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Зроби собі дві срібні труби; кованої роботи зробиш їх, і будуть вони тобі на те, щоб скликати громаду і щоб рушити табором. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","І як затрублять у них, то збереться до тебе вся громада коло входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Як же тілько в одну затрублять, так позбираються до тебе князї, тисяцькі Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","А затрубите на трівогу, так почнуть рушати табори, що стоять на схід соньця; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","А затрубите на трівогу вдруге, так рушати муть табори, що стоять на полуднї: як рушати муть вони, мусять трубити. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","А як треба зібрати громаду, трубити мете, тільки ж не на трівогу. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Трубити муть же в труби сини Арона, сьвященники. І буде се вам установою віковічньою в роди ваші. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","А як пійдете на війну в землї вашій проти ворога, що тїснить вас, так затрубите в труби на трівогу; і погадається про вас перед Господом, Богом вашим, і вирятуєтесь від ворогів ваших. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","І в день радощів ваших і в празники ваші, і в новонастанню місяця вашого, трубити мете в труби при всепаленнях ваших і при ваших жертвах мирних; і се буде нагадувати вас перед Богом вашим. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","І було на другий рік, другого місяця, на двайцятий день, що знялась у гору хмара з храмини сьвідчення. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","І сини Ізрайлеві рушили чергою у Синайському степу; і спустилась хмара в Паран-степу. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","І рушили табором по первий раз по слову Господньому через Мойсея. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","І йшов наперед прапор табору синів Юди, по полкам їх; а над військом його був Нахзон Аминадабенко. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","А над військом поколїння синів Іссахарових був Нетанеїль Зуаренко; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","А над військом поколїння синів Зебулонових був Єлїаб Гелоненко. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","І зложено храмину, і рушили сини Герсонові і сини Мерарієві, несучи храмину. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Рушив і прапор табору Рубена по полкам його, і над військом його був Лейзор Шедеуренко; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","А над військом поколїння синів Симеонових був Селуміїл Зуришадаєнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","А над військом синів поколїння Гадового був Єлеасаф Дегуйленко; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Рушили й Кегатїї, що несли сьвятиню; попереднї ж ставляли храмину перш нїм ті прийшли. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","І прапор табору синів Ефраїмових рушив по полках їх, і над військом їх був Елішама Амігуденко. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","А над військом поколїння синів Манассевих був Гамалеїль Педазуренко; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","А над військом поколїння синів Беняминових був Абидан Гидеоненко. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Рушив потім прапор табору синів Данових, що був задньою сторожею усїм таборам, по полках їх, і над військом його був Ахієзер Амішадаєнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","А над військом поколїння синів Азерових був Пагіїль Окраненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","А над військом поколїння синів Нафталїєвих був Агира Енаненко. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Такою чергою рушали сини Ізрайлеві по полках своїх; і рушили вони в дорогу. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","І каже Мойсей Гобабові, синові Регуїла, Мидіянїя, що був тестьом Мойсейові: Ми простуємо до того місця, що про його казав Господь: Оддам його вам. Ходи з нами, і добро зробимо тобі; бо Господь обіцяв добро Ізрайлеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","І каже він йому: Не пійду я з вами, а в землю мою і до родини моєї пійду; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","І каже він: Не покидай же нас: ти бо знаєш, де нам ставати табором в степу; і будеш ти нам очима. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","І станеться, як пійдеш із нами, і Господь вчинить нам добро, то й ми вчинимо добро тобі. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","І пустились вони в дорогу від гори Господньої, і відійшли на три днї ходи, і скриня завіту Господнього йшла три днї ходи перед ними, щоб знайти місця для їх відпочинку; ");
INSERT INTO ukr1871_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","А хмара Господня була над ними в день, як рушали вони табором. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","І як піднїмали з місця скриню, так промовляв Мойсей: Встань, Господе, і розсиплються вороги твої, і ненавидники твої розбіжуться від лиця твого. ");
INSERT INTO ukr1871_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","А як остановлялась вона, тодї промовляв: Вертайся, Господе, до незлїчених тисячей Ізраїля! ");
INSERT INTO ukr1871_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","І сталось що люде нарікали так, що опротивіло Господеві; і як почув Господь наріканнє, запалав гнїв його, і спихнув огонь між ними, і став пожирати конець табору. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","І заголосили люде до Мойсея, і благав Мойсей Господа, та й потахла пожежа. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","І назвали те врочище Табера, бо палало між ними поломя Господнє. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","І почав мішаний народ, що був між ними, придумувати забаганки, та й сини Ізрайля плакали: Хто знов, мовляли, годувати ме нас мясивом? ");
INSERT INTO ukr1871_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Памятаємо рибу, що за дармо їли в Египтї, огірки й динї, пір і цибулю й чесник; ");
INSERT INTO ukr1871_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","А тепер прагне душа наша; нема нїчогісїнько, сама тільки манна перед очима нашими. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","А манна була наче насїння корияндрове, а барва її як бделїон. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Блукали люде та й збирали її й мололи в жорнах, або товкли в ступах; і варили її в горшках, та й пекли з неї балабушки; а смаком була вона, як смак у макуха. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","І як падала роса на табір у ночі, то падала на його й манна. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","І як почув Мойсей людей, що плачуть по семях своїх, кожне коло входу до свого шатра, і вельми запалав гнїв Господень, то стало тяжко Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","І промовив Мойсей до Господа: Про що зробив єси горе слузї твому? І чом не знайшов я ласки перед лицем твоїм, що ваготу всього народу сего навалив єси на мене? ");
INSERT INTO ukr1871_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Хиба ж я почав увесь народ той, або породив його, що ти промовив до мене: Неси його на лонї твому, як нянька носить дитя; неси його в землю, що клятьбою обіцяв її батькам їх? ");
INSERT INTO ukr1871_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Звідки взяти менї мясива, щоб нагодувати ввесь оцей люд? бо з плачем приступають вони до мене, говорючи: Дай нам мясива їсти! ");
INSERT INTO ukr1871_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Не в моготу менї одному нести люд сей; бо за важко на мене. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","І коли так чиниш зо мною, так уже, коли знайшов я ласку перед лицем твоїм, лучче погуби мене, і нехай не бачу горя більше. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","І рече Господь Мойсейові: Склич менї сїмдесять чоловіка із старшини в Ізраїля, про котрих знаєш, що вони старші між народом і проводорі його, і приведи їх до соборного намету, щоб вони стояли там з тобою. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","І зійду я і поговоримо там з тобою, і возьму від духа, що на тобі, та й возложу на них, щоб несли з тобою тягар народу, та щоб не одному тобі нести його. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","А людям скажи: Осьвятїтесь назавтра, так і їсти мете мясиво; плакали бо ви в слухи Господеві, говорючи: Хто дасть нам їсти мясиво? Та ж нам добре було в Египтї; і дасть вам Господь мясива, і їсти мете. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Не один день їсти мете, і не два днї, і не пять день, і не десять день, і не двайцять день. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","А цїлий місяць, аж покіль вертати меться і опротивіє вам; ви бо гордували Господом, що посеред вас, і плакали перед ним, нарікаючи: Чого се вийшли ми з Египту? ");
INSERT INTO ukr1871_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","І сказав Мойсей: Народу, що між ним обертаюсь, шістьдесять тисяч піхоти, а ти промовив: Дам їм мясива, щоб їли цїлий місяць. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Хиба дрібну й буйну скотину повбивати, щоб стало для них? Або хиба забрати всю рибу, щоб стала для них? ");
INSERT INTO ukr1871_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","І рече Господь Мойсейові: Хиба ж за мала рука в Господа? Оце ж побачиш, чи справдиться слово моє, чи нї. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","І вийшов Мойсей, і промовив до люду слова Господнї, і зібрав сїмдесять чоловіка із старших народу і поставив їх навкруги намету. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","І зійшов Господь у хмарі, і промовив до його, і взяв від духа, що був на йому, і положив на сїмдесять чоловіків старших. І сталось, як дух спустився на них, так стали вони пророкували; та опісля перестали. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Два ж чоловіки остались в таборі: один на імя Ельдад, а другий на імя Медад. І спустивсь на них дух, були вони записані, та не виходили до намету, і стали вони пророкувати в таборі. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","І прибіг якийсь молодик, та й розказав Мойсейові кажучи: Ельдад і Медад пророкують у таборі. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","І відказав Йозуа Нуненко, що вслуговував Мойсейові з малку, і каже до Мойсея: Добродїю мій, заборони їм. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","І каже йому Мойсей: Чого ти ревнуєш за мене? Нехай би ввесь люд Господень зробивсь пророками, і щоб Господь послав на них духа свого. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","І вернувся Мойсей до табору, він і старші мужі Ізрайлеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","І повіяло вітром від Господа, і нанесло перепелиць від моря, і накидало їх у табір, на день ходи в один бік і на день ходи в другий, навкруги табору до двох локтів поверх землї. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","І вийшли люди, і збирали перепилицї увесь той день і всю ніч, і ввесь день другий; хто мало назбирав, у того було десять гомерів; і розложили їх собі про запас округи табору. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ще ж було мясиво між зубами їх, ще не зʼїли його, а гнїв Господень запалав на людей, і вдарив Господь їх тяжким помором. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","І назвали врочище те Киброт-Гаттаава; бо там поховано людей, що були ласі. ");
INSERT INTO ukr1871_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Од Киброт-Гаттаави рушив люд до Газероту; і зупинились вони в Газеротї. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Миряма ж та Арон нарікали на Мойсея за молодицю Кушицьку, що взяв її: бо Кушицьку молодицю взяв він для себе. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","І мовляли вони: Хиба ж тільки до Мойсея промовляв Господь? Хиба ж і не до нас так само промовляв він? І почув се Господь. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","А Мойсей та був собі вельми тихий чоловік понад усї люде, що були на землї. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","І промовив Господь нараз до Мойсея, до Арона, і до Мирями: Ідїть, ви троє, у соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","І зійшов Господь у хмарному стовпі, та й став коло входу в намет, і покликав Арона і Миряму; і вийшли вони обоє. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","І рече: Ось вислухайте слова мої: Коли єсть пророк між вами, так се я, Господь, у видїнню йому відкриваюсь, ві снї говорю з ним. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Не такий слуга мій Мойсей. Він вірний в цїлім домі моїм; ");
INSERT INTO ukr1871_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Устами до уст розмовляю з ним, не у видїнню, і не в загадках, а образ Господнїй бачить він. Як же не боялись ви говорити проти Мойсея, проти слуги мого? ");
INSERT INTO ukr1871_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","І запалав гнїв Господа проти них; і відійшов він. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","І відступила хмара від соборного намету; Миряма ж несподівано зробилась прокаженною, біла мов снїг. І обернувсь Арон до Мирями, аж бачить вона прокажена. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","І каже Арон до Мойсея: Ой лихо, добродїю мій! Не лїчи нам за гріх те, що по дурному вчинили ми, і за те, чим провинили. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Нехай вже не буде вона така, наче тая мертва дитина, що в неї тїло, як вийде з материної утроби, до половини зогнило! ");
INSERT INTO ukr1871_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","І кликав Мойсей до Господа, говорючи: Ой, Боже, молю тебе, приверни їй здоровля! ");
INSERT INTO ukr1871_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","І рече Господь Мойсейові: А коли б отець її та плюнув ій у вічі, хиба ж би вона не була осоромлена на сїм день? Нехай зачинять її на сїм день за табором, а потім можуть приняти її до себе. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","І зачинено її за табором на сїм день, і не рушав люд в дорогу, аж як прилучено Миряму. ");
INSERT INTO ukr1871_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Потім рушив люд од Газерота та й отаборивсь у Паран степу. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Пішли людей на розглядини в Канаан землю, що дам її синам Ізрайлевим; по одному чоловікові з батьківських поколїнь їх пошлете їх, кожного князя спроміж їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","І післав їх Мойсей із Паран степу, по слову Господньому, саміх таких людей що були голови в синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","А се ймення їх: Від поколїння Рубенового, Шамуа Сакуренко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Від поколїння Симеонового, Шафат Хоріенко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Від поколїння Юдиного, Калеб Ефуненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Від поколїння Іссахарового, Їгаль, син Йосифа; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Від поколїння Ефраїмового, Гозей Нуненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Від поколїння Беняминового, Пальтїй Рафуенко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Від поколїння Зебулонового, Гаддієль Содіенко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Від поколїння Йосифового, роду Манассеєвого, Гаддій Сузіенко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Від поколїння Данового, Аммієль Гемалїенко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Від поколїння Ассерового, Сефур Михайленко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Від поколїння Нефталїєвого, Нагбій Вафсіенко; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Від поколїння Гадового, Геуель Махізенко. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Се імення мужів громадських, що їх післав Мойсей розгледїти землю. Гозейю ж Нуненка назвав Мойсей Йозуа. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","І післав їх Мойсей розгледїти Канаан землю, кажучи їм: Ідїте сюди на полудне, та й зійдете на гору. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","І подивитесь на землю, яка вона; і люд, що живе в їй, чи міцний, чи слабовитий, малий, чи великий; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","І яка земля та, де вони живуть, добра, чи зла, і які міста, що в їх живуть вони, табори, чи утвержені міста? ");
INSERT INTO ukr1871_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","І яка земля: родюща вона, чи скуповата; чи є по їй дерево, чи нема? І бувайте сьміливі, та принесїть з плоду землї. А був тодї саме час, що дозрів виноград. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","І пійшли вони, розгледїли землю від Зин степу до Регобу, як ійти до Гамату. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","І повернули на полудне, і дійшли до Геброну, а там Ахіман, Сесай і Тальмай, дїти Енакові. Геброн же збудовано за сїм років перед Зоаном в Египтї. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","І дійшли до Есколь долини, і зрізали там вітку з однією гроною ягод, та й несли її два на жердцї, також і гранати і смокви. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Урочище те названо Єсколь долиною через виноград, що зрізали там сини Ізрайлеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","І вернулись вони після розглядин під конець сорока днїв; ");
INSERT INTO ukr1871_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","І йдучи прийшли до Мойсея та Арона, до всієї громади синів Ізрайлевих, у Паран степу, до Кадесу; і принесли вістку їм і всїй громадї і показали їм плоди землї. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","І оповідали йому кажучи: Прийшли ми в землю, де ти посилав нас, і справдї: тече вона молоком та медом, і се плоди її. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Тільки що потужен люд, що живе в тій землї, і утверджені міста вельми великі; та й Енакових дїтей бачили ми там. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Амалек живе в землї полуденнїй, а Гетії, і Євузії, і Аморії живуть по горах, а Канаанїї живуть над морем і здовж берегів Іорданських. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","І втихомирив Калеб людей, що противились Мойсейові, та й промовив: Пійдемо таки та й займем її, стане бо сили в нас впокорити її. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ті ж чоловіки, що з ним ходили у гори, мовляли: Не буде в нас сили увійти між сїх людей, вони бо сильнїйші, як ми. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","І рознесли вони між синами Ізрайлевими недобрі вісти про землю, що розглядували самі, мовляючи: Земля, що нею проходили ми, щоб розвідати, така земля, що жере осадників своїх, і ввесь люд, що ми бачили серед неї, се люде великого росту. ");
INSERT INTO ukr1871_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","І бачили ми там велетнїв, синів Енакових, з роду велетнїв; і самим нам здавалось, наче ми тая сараньча, і такими ж були в очах їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","І піднялась уся громада і зняла галас, і плакали люде всю ту ніч. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","І нарікали на Мойсея та на Арона всї сини Ізрайлеві, і мовляла до них вся громада: Ой, бодай би ми були померли в Египецькій землї, або коли б погибли в тій пустинї. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","І про що веде нас Господь у цю землю? Щоб полягти від меча, та щоб жінки наші і дїти наші зробилися здобичею? Хиба ж не лучче нам, вернути в Египет? ");
INSERT INTO ukr1871_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","І мовляли одно одному: Виберемо собі голову над нами, та й вернемось в Египет? ");
INSERT INTO ukr1871_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","І впали Мойсей та Арон на лиця свої ниць перед усією громадою синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","А Йозуа Нуненко та Калеб Єфуненко, вони із тих, що ходили на розглядини в ту країну, пороздирали на собі одїж, ");
INSERT INTO ukr1871_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","І промовили вони до всієї громади синів Ізрайлевих: Земля, що нею переходили ми, щоб розвідати, земля тая дуже, дуже добра. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Коли до нас милость Господня, так приведе нас він в цю землю, та й дасть нам її, земля ж ся тече молоком та медом. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Тільки проти Господа не бунтуйтесь; і не лякайтесь людей в тій українї; бо вони будуть хлїбом про нас. Защити в них не стало, а Господь із нами; не лякайтесь їх! ");
INSERT INTO ukr1871_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","І сказала вся громада, щоб каміннєм побити їх. Тодї обявилась слава Господня в соборному наметї перед усїма синами Ізрайлевими. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","І рече Господь Мойсейові. А докіль ще буде зневажати мене сей люд, і докіль ще не мати муть вони віри менї на всї знамена що я сотворив їх між ними? ");
INSERT INTO ukr1871_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Вдарю на них мором і вигублю їх; і зроблю тебе народом, більшим і потужніщим як вони. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","І промовив Мойсей до Господа: Почують се Египтяне; бо потугою твоєю випровадив єси люд сей зміж них; ");
INSERT INTO ukr1871_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","І скажуть осадникам сієї країни, вони ж чули, що ти, Господе, посеред люду свого, що тебе, Господе, око в око бачять вони, та що хмара твоя стоїть над ними, і в хмаряному стовпі ти сам ідеш поперед ними за дня, в стовпі поломяному в ночі. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","А вбєш ти люд сей, як одного чоловіка, тодї й говорити муть народи, що чували про славу твою, кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Тому повбивав Господь їх у степу, що не здолїв привести люд сей в ту землю, що про неї клявся їм. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Нехай же оце возвеличиться сила твоя, Господе, як обітував єси словами: ");
INSERT INTO ukr1871_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Господь повільний до гнїву і великий милостю, прощає провину й переступи, хоч не вважає безвинним винуватого, карає провину батьківську на синах у третьому й четвертому колїнї. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Прости ж провину люду сього по великому милосердю твому, так як простив єси людові сьому від Египту аж досї! ");
INSERT INTO ukr1871_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","І рече Господь: Прощаю по слову твому. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Но все таки, так існо, як я живий, сповниться вся земля славою Господньою; ");
INSERT INTO ukr1871_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Всї ж люде ті, що вбачали славу мою і знамення мої, що я сотворив їх у Египтї і в степу, і спокушували мене десять раз і не слухали голосу мого, ");
INSERT INTO ukr1871_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Вони не побачять землї, що про неї клявсь я батькам їх, всї, що зневажили мене, не бачити муть її. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Но слугу мого Калеба, в котрого дух инший, і котрий пійшов за мною, приведу в землю, до якої сам він ходив, і внаслїдує її насїннє його. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Амаликії ж та Канаанїї живуть у долинї; завтра обернїтесь і рушайте в степ по дорозї до Червоного моря. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","І рече Господь Мойсейові й Аронові: ");
INSERT INTO ukr1871_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Як довго терпіти менї сю ледачу громаду, що нарікає на мене? Чув я наріканнє синів Ізраїля, котрим дорікають менї. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Скажи їм: Як жив я, мовить Господь: як мовляли ви в слухи менї, так і зроблю з вами. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","В пустинї сїй поляжуть ваші трупи, всї перелїчені ваші по всїй вашій лїчбі, од двайцяти років і старше, що нарікали на мене. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Опріч Калеба Єфуненка та Йозуи Нуненка не увійдете ви в землю, котру оддати вам на оселю я, піднявши руку мою, клявся: приведу вас у неї. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Дїточок же ваших, про котрих ви мовляли, що здобичею вони будуть, їх приведу туди, нехай пізнають землю, котрою ви гордували. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ви ж поляжете трупом в сьому степу; ");
INSERT INTO ukr1871_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","А дїти ваші будуть попасати в пустинї сорок років і носити блудування ваші, покіль не поляжете всї трупом у степу. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","По лїчбі сорока днїв, що ходили ви в землю на розвідини, ви понесете кару за гріхи ваші сорок років, один рік за один день, щоб ви зрозуміли, що се значить, як я одвернусь від вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Сам я, Господь, говорю і зроблю так з ледачою сією громадою, що встала проти мене! У степу сьому вони погибнуть і помруть. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","І чоловіки, що посилав їх Мойсей на розвідини в ту землю, і що вернувшись, рознесли погану поголоску про сю землю, і довели цїлу громаду до нарікання на мене. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ті мужі, що рознесли погану поголоску про землю, померли від пошестї перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Но Йозуа Нуненко та Калеб Єфуненко зостались живими із тих чоловіків, що ходили на провідки землї. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","І як промовив Мойсей слова ті до всїх синів Ізрайлевих, то сумували люде вельми. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","І вставши вранцї, щоб зійти на верховини гір, казали: Ось ми ту і рушимо до того місця, про яке казав Господь; бо ми провинили. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","І каже Мойсей: Чого ви хочете переступити слово Господнє? Не вдасться бо вам! ");
INSERT INTO ukr1871_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Не рушайте в гори, бо нема Господа між вами; а то побють вас вороги ваші; ");
INSERT INTO ukr1871_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Бо там Амелекії та Канаанїї перед вами, і поляжете від меча їх. Ви одвернулись від Господа; тому не буде Господь з вами. ");
INSERT INTO ukr1871_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Та зʼосьмілились вони піднятись на гірські верховини; тільки скриня завіту Господнього і Мойсей не рушили із табору. І зійшли з гори Амалекії та Канаанїї, що жили на тих горах, та й побили їх, і загнали аж до Горми. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Промов до синів Ізраїля і скажи їм: Як прийдете у землю оселї вашої, що дам вам, ");
INSERT INTO ukr1871_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","І приносити мете огняну жертву Господеві, жертву всепалення чи то жертву заколення, щоб сповнити обітницю, чи добровільні дари у празники ваші, щоб закурити Господеві любі пахощі з буйної чи з дрібної скотини: ");
INSERT INTO ukr1871_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Так мусить той, хто приносить Господеві приношеннє своє, як хлїбну жертву принести: десятину ефи муки пшеничної, змішаної з четвертиною гіна олїї, ");
INSERT INTO ukr1871_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","А як ливну жертву принесеш до жертви всепалення чи то заколення, на кожну вівцю одного гіна вина. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Або при баранї принесеш три десятин ефи муки пшеничної, змішаної з третиною гіна олїї; ");
INSERT INTO ukr1871_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","А як ливну жертву подаси третину гіна вина; любі пахощі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","А як принесеш бичка на жертву всепалення, чи на жертву заколення, щоб сповнити обітницю, чи на жертву мирну Господеві, ");
INSERT INTO ukr1871_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Так нехай приносять до бичка як хлїбну жертву: три десятин ефи муки пшеничної, змішаної з половиною гіна олїї; ");
INSERT INTO ukr1871_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","А як жертву ливну принесеш половину гіна вина: пахощі любі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Так будуть робити при кожному приношенню вола чи барана чи із овець, чи з кіз; ");
INSERT INTO ukr1871_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Дивлючись по лїчбі, скілько жертвуєте, робити мете так, при кожному приношенню по лїчбі їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Всякий землянин мусить чинити се приносючи огняну жертву любих пахощів Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","А коли пробуває в вас чужоземець, чи хто б то нї був між вами, в родах ваших, і приносить огняну жертву любих пахощів Господеві, то нехай і він так робить, як ви робите. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Що до громади, то установа одна про вас і про приходня, що між вами пробуває; установа віковічня в роди ваші: як ви, так і приходень буде перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Закон один і одно право буде для вас і для приходня, що пробуває між вами. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","І рече Господь до Мойсея: ");
INSERT INTO ukr1871_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Промов до синів Ізрайлевих, і скажи їм: Як прийдете в землю, що в неї сам я приведу вас, ");
INSERT INTO ukr1871_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Так починаючи їсти хлїб з тієї землї, мусите принести жертву Господеві: ");
INSERT INTO ukr1871_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Як первоплід з тїста вашого принесете колача на жертву возношення; як жертву з току принесете його. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Від первого тїста вашого мусите давати Господеві жертву возношення в роди ваші. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","А коли незнавши согрішите, і не сповните всї заповідї сї, що промовив Господь до Мойсея, ");
INSERT INTO ukr1871_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","І не сповните все те, що вам повелїв Господь через Мойсея, з того часу, як дав Господь заповідї, і потім у родах ваших, ");
INSERT INTO ukr1871_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","То вчините ось що: Коли за очима в громади, через помилку станеться, тодї мусить уся громада привести бичка на всепаленнє про любі Господеві пахощі, з дарами його хлїбними і ливними, по установі, і одного козла на жертву за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","І відпокутує сьвященник за всю громаду синів Ізрайлевих, і проститься їм; бо через помилку стався гріх сей, а вони подали свій принос, огняну жертву Господеві, і принесли перед Господом свою жертву за гріх, за помилку свою. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","І проститься всїй громадї синів Ізрайлевих, і приходневі, що пробуває між ними; бо ввесь люд провинив помилкою. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","А коли одна яка душа согрішить помилкою, так мусить вона принести козу перволїтку на жертву за гріх. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","І відпокутує сьвященник за душу, що помилкою провинила, согрішивши ненарочно перед Господом, і буде вона спокутована і проститься їй. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Для землянина між синами Ізрайлевими і для приходня, що пробуває між ними, закон один мусить бути в вас про того, хто помилився. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Но та душа, що піднявши руку кому що заподїє, чи він землянин, чи з приходнїв, наругався він з Господа; і викоренити мусять сю душу із серед люду, ");
INSERT INTO ukr1871_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Бо зневажив він слово Господнє і зломив заповідь його; викорениться душа тая; гріх її на їй. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","І як були сини Ізрайлеві в пустинї, так знайшли чоловіка, що збирав дрова в субітнїй день. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","І взяли його ті, що знайшли, як він збирав дрова, та й привели до Мойсея і до Арона і до всієї громади. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Та й віддали його під сторожу; бо не знати було, що з ним чинити. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","І сказав Мойсей: Вмерти мусить чоловік сей; нехай закидає його каміннєм вся громада за табором. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","І вивела його вся громада за табір, та й закидала каміннєм, і погиб він, як повелїв Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","І рече Господь до Мойсея: ");
INSERT INTO ukr1871_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Промов до синів Ізрайлевих і скажи їм, щоб робили собі кутаси на кіньцях верхньої одежі своєї в родах їх, і щоб причіпили до кутасів одежі шнурок з блавату. ");
INSERT INTO ukr1871_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","І будуть вам кутаси на те, щоб ви, бачивши їх, згадували про всї заповідї Господнї, і сповняли їх, і щоб ви не подавались за серцем і очима вашими, що поривають вас до блудування; ");
INSERT INTO ukr1871_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Щоб ви памятали і сповняли всї заповідї мої й були сьвятими в Бога вашого. Я Господь, Бог ваш, що вивів вас із Египецької землї, щоб вам бути Богом. Я Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Уперся Кораг, син Їзгара, сина Кегаа, сина Левієвого, а з ним Датан та Абірам Елїабенки та Он Пелетієнко, сини Рубенові, ");
INSERT INTO ukr1871_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Та й встали вони проти Мойсея, і з ними двістї пятьдесять чоловіка із синів Ізраїля, князї громадські, покликані до ради громадської люде з намениті. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","І зібрались вони проти Мойсея та Арона, і промовили до них: Годї вам! Бо ж уся громада сьвята і Господь серед неї. Чого ж ви пнетесь високо над громадою Господньою? ");
INSERT INTO ukr1871_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Почувши те Мойсей упав на лице своє. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","І промовив він до Корага й усієї роти його, і каже: Завтра сповістить Господь, хто його і хто сьвятий, щоб допустити його до себе; кого він вибрав, того допустить до себе. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Так учинїть: Нехай возьме з собою кадильницї Кораг і вся громада його, ");
INSERT INTO ukr1871_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","І завтра положіть у їх жару, і положіть на йому кадило перед Господом; і нехай буде так: той чоловік, що вибере його Господь, нехай буде сьвятим. Буде з вас, Левієві сини! ");
INSERT INTO ukr1871_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","І промовив Мойсей до Корага: Слухайте ж, сини Левієві! ");
INSERT INTO ukr1871_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Хиба мало вам, що Бог Ізраїлїв вилучив вас із громади Ізраїля, щоб вам можна приближитись до його, щоб вам можна послугувати в храминї Господнїй та стояти перед громадою послугуючи їй, ");
INSERT INTO ukr1871_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Що удостоїв тебе і всїх братів твоїх, синів Левієвих з тобою, приближитись до його? А вам ще й сьвященьства захотїлось! ");
INSERT INTO ukr1871_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Тим і повстали ви, ти і вся рота твоя проти Господа; бо що таке Арон, що ви нарікаєте на його? ");
INSERT INTO ukr1871_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","І післав Мойсей, щоб покликати Датана та Абірама Елїабенків, та вони сказали: Не пійдемо на гору! ");
INSERT INTO ukr1871_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Хиба мало того, що ти вивів нас із землї текущої молоком та медом, щоб поморити нас в степу; ти хочеш іще й царювати над нами? ");
INSERT INTO ukr1871_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","І нї в землю, текущу молоком та медом не привів єси нас, нї дав нам у наслїддє поля й виноградники! Хочеш людям сим очі виколити? Не пійдемо! ");
INSERT INTO ukr1871_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","І розлютився вельми Мойсей, і сказав до Господа: Не повертайсь до приносів їх! Нї одного осла не взяв я від них і не заподїяв зла нї одному з них. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","І сказав Мойсей до Корага: Ти і вся твоя громада, станьте ви завтра перед Господом, ти сам і вони і Арон. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","І нехай кожен візьме кадильницю свою і накладе у її кадила, і нехай принесе кожен свою кадильницю перед Господом, двістї і пятьдесять кадильниць; і ти і Арон, кожен кадильницю свою. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","І взяли вони кожен кадильницю свою, і понакладали в них жару, і понасипували в них кадила; та й приступили до входу в соборний намет, і Мойсей та Арон. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","І скликав Кораг проти них усю громаду до входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","І показалась слава Господня перед всією громадою. І промовив Господь до Мойсея та Арона слова: ");
INSERT INTO ukr1871_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Вилучтесь із між громади сієї, і погублю їх в одну мить ока. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","І впали вони ниць на лиця свої і сказали: Боже, ти Боже духів усякого тїла! Один чоловік согрішив, а гнїв би твій мав бути на всю громаду? ");
INSERT INTO ukr1871_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Промов до громади і скажи: Відступіть геть навкруги від наметів Корага, Датана й Абірама. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","І встав Мойсей, і пійшов до Датана й Абірама, і пійшли за ним старші мужі Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","І промовив він до громади кажучи: Відступіте ж від наметів сих безбожних людей, і не торкайте нїчого їх, щоб не погибнути вам у всїх гріхах їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","І відступили вони геть навкруги від храмини Корага, Датана та Абірама. А Датан та Абірам, вийшовши стояли коло входу в намети свої з жінками своїми й дїтьми своїми і з немовлятами своїми. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","І сказав Мойсей: По тому зрозумієте ви, що Господь післав мене сотворити всї дїла сї, та що не по своїй волї вчинив я се: ");
INSERT INTO ukr1871_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Коли вони помруть, як всї люде вмирають, і постигне їх така кара як всїх людей, то не послав мене Господь; ");
INSERT INTO ukr1871_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Коли ж нечуване диво сотворить Господь, і роззявить земля уста свої та й проковтне їх і все, що їх, і пійдуть живими під землю, тодї пізнаєте, що сї люде споневірали Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","І сталося, що як він скіньчив промовляти сї слова, ");
INSERT INTO ukr1871_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Розступилась земля під ними, і роззявила земля уста свої та й проглинула їх самих і домівки їх і всїх людей, що були в Корага, і все майно. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","І провалились вони, і все що було їх, живими під землю, і покрила їх земля, і погинули вони спроміж громади. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","І ввесь Ізраїль, що був навкруги них, кинувсь навтеки, на зойк їх: казали бо вони: Коли б і нас не проглинула земля! ");
INSERT INTO ukr1871_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","І вийшов огонь від Господа, і пожер двістї чоловіка, що поприносили кадила. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Скажи Елеазарові Ароненкові, сьвященникові, щоб повигрібав кадильницї із пожарища; і нехай порозкидає жар, вони бо посьвячені. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Із кадильниць тих чоловіків, що согрішили, нехай пороблють із них тонкі бляхи, щоб ними покрити жертівника; бо принесли вони їх перед Господа, і тому стали вони посьвяченими; і будуть вони знаменнєм синам Ізрайлевим. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","І взяв Елеазар, сьвященник, кадильницї мідяні, що принесли погорівші, і поросплїскувано їх, щоб покрити жертівника, ");
INSERT INTO ukr1871_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","На спомин синам Ізрайлевим, щоб нїхто чужий, хто не з насїння Аронового, не приступав, кадити перед Господом, щоб із ним не сталось, як з Корагом і з його громадою, як сказав йому Господь через Мойсея. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Другого ж дня, стала нарікати вся громада Ізрайлева на Мойсея й Арона, мовляючи: Ви погубили люд Господень! ");
INSERT INTO ukr1871_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","І сталось, як зібралась була громада проти Мойсея і Арона, так обернулись вони до соборного намету, і се вкрила його хмара і явилась слава Господня. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","І приступили Мойсей та Арон перед соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","І промовив Господь до Мойсея кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Підіймітесь із серед громади сієї, так погублю їх в одну мить! І впали вони ниць на лиця свої. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","І каже Мойсей до Арона: Возьми кадильницю твою, та наклади в її жару із жертівника, і насип кадила, і йди скоріш у громаду, та спокутуй їх; бо спалахнув гнїв, від лиця Господнього й пійшов помір. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","І взяв Арон кадильницю, як казав Мойсей, та й метнувсь між громаду, аж се почалась морова кара між людьми. І насипав він кадила та й почав відправляти покуту за людей. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","І став він між мертвими і живими, і зупинилась морова кара. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","А було тих, що від морової пошестї погибли, чотирнайцять тисяч і сїмсот, окрім тих, що померли задля Корага. ");
INSERT INTO ukr1871_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","І вернувсь Арон до Мойсея, до входу в соборний намет, і зупинилась морова пошесть. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","І рече Господь до Мойсея: ");
INSERT INTO ukr1871_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Промов до синів Ізрайлевих, і візьми від них по прутові за кожний дім батьківський, від усїх князїв по домах батьківських їх, дванайцять прутів; імя кожного напиши на прутові його. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Імя ж Арона напишеш на прутові Левія; один бо прут буде про кожну голову батьківських домів їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","І покладеш їх у соборному наметї перед сьвідченнєм, де я бачусь із тобою. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","І процьвіте прут чоловіка того, котрого я виберу; і так втихомирю передо мною мирканнє синів Ізраїля, що нарікають на вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","І промовив Мойсей до синів Ізрайлевих, і подали йому всї їх князї по прутові за князя, по батьківських домах їх, дванайцять прутів; а прут Аронів був між їх прутами. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","І положив Мойсей прути перед Господом, в наметї сьвідчення. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","І сталось другого дня, як увійшов Мойсей у намет сьвідчення, і се, процьвів прут Аронів, з дому Левієвого: пустив він пупляшки, і зацьвів квітками, і зродив спілі микдали. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","І виніс Мойсей усї прути від лиця Господнього до всїх синів Ізрайлевих, і побачили вони, і взяли кожен прута свого. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","І рече Господь до Мойсея: Принеси назад прута Аронового перед сьвідченнє, щоб заховати його як знамя проти синів бунтовливих: і зробиш передо мною конець наріканню їх, та щоб не повмирали вони. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","І сповнив Мойсей усе; як заповідав йому Господь, так він вчинив. ");
INSERT INTO ukr1871_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","І промовили синове Ізрайлеві до Мойсея, кажучи: Дивись, ми пропадаємо, ми гинемо, всї ми згинемо! ");
INSERT INTO ukr1871_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Хто тільки приступить до храмини Господьної, вмирає; чи не всїм же нам прийдеться померти? ");
INSERT INTO ukr1871_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","І промовив Господь до Арона: Ти сам і сини твої й батьківський дім твій з тобою мусите нести провину сьвятинї; і ти сам і сини твої з тобою мусите нести провину вашого сьвященьства. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Теж і браттє твоє з поколїння Левієвого, з поколїння батька твого нехай приближується з тобою, щоб вони були при тобі і вслуговували тобі; ти ж і сини твої з тобою, ви служити мете перед наметом сьвідчення. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Нехай вони роблять службу коло тебе і коло всього намету; тільки до посуду сьвятинї і до жертівника нехай не приступають, щоб не померти їм, так їм як і вам. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","І будуть вони при тобі і доглядати муть соборного намету при всїх службах в наметї, чужий же не сьміє приближатись до вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","І будете пильнувати догляду сьвятинї і догляду жертівника, щоб не було вже гнїва на синів Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Се я сам взяв братів ваших Левітів зміж синів Ізрайлевих; вам подаровано їх про Господа, на послугу при соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ти ж і сини твої з тобою будете пильнувати сьвященьства вашого у всьому, що належить до жертівника і в серединї за завісою, і так робити мете службу; вам передаю як дар службу сьвященьства. Хто ж чужий приближиться, буде переданий смертї. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","І рече Господь Аронові: Се передав я тобі догляд моїх жертв підношення. Від усього, що присьвячують сини Ізрайлеві, оддав я тобі і синам твоїм, задля сьвященьства вашого, вічну твою частку. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ось що буде твоє від сьвятих посьвятів, що не прийдуть на вогонь: всї дари їх, як всї жертви хлїбні, всї жертви за гріх, і всї жертви за провину, що вони приносять їх менї, як великі сьвятощі тобі вони і синам твоїм. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","У сьвятому місцї їсти меш їх, ввесь музький пол їсти ме їх; сьвятим се мусить бути тобі. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","І се буде твоє: возношення дарів їх і всї жертви гойдані синів Ізрайлевих; тобі і синам твоїм і дочкам твоїм з того віддав я як вічну пайку; всякий чистий в дому твому може їх їсти. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Все найлучче з олїї і все найлучче з винограду і зерна, їх первоплоди, що приносять їх Господеві, тобі оддав я їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Первоплоди з усього, що родить земля їх, що вони подають їх Господеві, твої будуть; всякий чистий з дому твого може їх їсти. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Усе посьвячене в Ізраїлї твоє буде. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Все перворідне від усякого тїла, що приносять Господеві, людина чи із скотини, буде твоє; тільки первородне дитя мусить бути викуплене, і первак із скотини нечистої мусить бути викуплений. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","І ті, що треба їх викупити, від одного місяця будуть викупляти їх по твому цїнуванню по пять секлїв срібла, по секлеві сьвятинї, двайцять гер в йому. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Первородного ж бика, або первородного барана чи первородного козла не давати меш викуповувати; присьвячені вони. Кровю їх будеш кропити на жертівника і жир їх пускати димом в огнянїй жертві, про любі пахощі Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","І мясиво їх буде твоїм; як грудина жертви гойданої і як права лопатка, твоє буде воно. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Всї жертви посьвятів, що підносять їх сини Ізраїля Господеві, оддав я тобі і синам твоїм і дочкам твоїм з тобою, як віковічну частку; се завіт вічний про тебе й про насїннє твоє з тобою. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","І рече Господь Аронові: У землї їх не мати меш жадного наслїддя, і частки в тебе не буде між ними. Сам я частка твоя і наслїддє твоє серед синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","І се дав я синам Левієвим замість наслїддя всї десятини Ізраїля за службу, що вони служать при соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","І більш не приступати муть синове Ізрайлеві до соборного намету, щоб не взяти на душу гріха і не померти. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Нехай Левіти служать службу при соборному наметї, і самі несуть гріх їх. Установа віковічня в роди ваші. А серед синів Ізрайлевих не мати муть жадного наслїддя; ");
INSERT INTO ukr1871_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Бо десятину синів Ізрайлевих, що в жертву приносять Господеві, дав я Левітам як наслїддє; тим то сказав я їм, що між синами Ізрайлевими не буде в них наслїддя. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","І промовив Господь до Мойсея, кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","А до Левітів скажеш так: Коли берете ви від синів Ізрайлевих десятину, що дав я вам як наслїддє ваше, так мусите принести жертву возношення Господеві, десятину від десятини. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","І полїчиться вам жертва возношення вашого, як зерно з току і як достаток винограднього точила. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","От же й ви мусите приносити жертву Господеві від усїх десятин ваших, що берете їх від синів Ізраїля і давати мете від всього Аронові сьвященникові жертву возношення про Господа. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Від усього, що принесуть вам, будете давати всяку жертву возношення Господеві, посьвяти його з усього, що є найлучче. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","І казати меш їм: Коли принесете що найлучче з того, так полїчиться Левітам як дохід з току і як дохід з винограднього точила. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","І можна вам їсти його в усякому місцї, вам самим і домам вашим; бо се вам плата за вашу службу в соборному наметї. ");
INSERT INTO ukr1871_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","І не буде вам за те гріха, коли що найлучче з того принесете, і не зневажите посьвятів синів Ізраїля і не помрете. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","І рече Господь Мойсейові та Аронові: Се установа закону, що заповідав Господь словами: ");
INSERT INTO ukr1871_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Скажи синам Ізрайлевим, щоб привели до тебе ялівку руду, без скази, таку що нема хиби на нїй, що не було ярмо на нїй; ");
INSERT INTO ukr1871_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","І віддасьте її Елеазарові сьвященникові, і виведе він її геть перед табор, і заколють її перед ним. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","І візьме Елеазар сьвященник крові її пальцем своїм, і покропить кровю на переднїй бік соборного намету сїм раз. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","І спалють ялівку перед очима його: шкіру її і мясиво її і кров її з гнойом її треба спалити. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","І візьме сьвященник дерева кедрового та іссопу й кармазину та й кине в середину поломя, як палити муть ялівку. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","І випере сьвященник одїж свою і викупає тїло своє в водї, а потім можна йому ввійти до табору; тільки ж нечистий буде сьвященник до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","І хто палив її, мусить випрати одїж свою в водї, і викупати тїло своє в водї, і буде й він нечистим до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","І збере попіл із ялівки який чистий чоловік, і висипить його за табором на місцї чистому; і буде він для громади синів Ізраїля схований про воду очищення, що буде на очищеннє від гріха. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","І випрати мусить, хто збірав попіл з ялівки, одїж свою, і буде до вечора нечистим. І буде синам Ізраїля і приходню, що пробуває між ними, віковічною встановою. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Хто доторкнеться мерця, трупа якої людини, нечистий буде сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Мусить очиститись водою сією на третий день, і стане на семий день чистим; а як не очиститься на третїй день, так не буде на семий день чистим. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Всякий, хто доторкнеться мерця, трупа якої людини, що вмерла, і не очиститься, той опоганив храмину Господню; викоренитись мусить ся душа з Ізраїля. Водою очищення він не покроплений, тому він нечистий; нечистота його ще на йому. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Се закон про людину, що вмерла в наметї: кожний хто входив в намет, і кожний хто був у наметї, нечистим буде сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","І всяка одкрита посудина, на якій нема привязаної покришки, нечистою буде. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","І всякій хто в чистому полї торкнеться до вбитого мечем, чи до мерця, чи до костей чоловічих, чи до домовини, буде сїм день нечистим. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","І возьмуть, про нечистого, попелу із жертви спаленої на очищеннє, і наллють на його води текучої в посудину. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","І візьме чистий чоловік гіссопу та й умочить у воду, та й покропить на намет і на всю посудину і на всїх людей, що там будуть, і на того, що торкнувсь до костей, чи до вбитого, чи до мерця, чи до домовини. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","І кропити ме чистий на нечистого на третїй день і на семий день; і очистить його на семий день; і випере він одїж свою і викупає тїло своє в водї, і стане він чистим увечорі. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Коли ж людина ака стане нечиста і не очиститься, душу таку треба викоренити спроміж громади; бо сьвятиню Господню вона опоганила: водою очищення не покроплено її, нечиста вона. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","І буде се в вас установою вічньою. І хто кропить очищаючою водою, мусить випрати одїж свою, і хто приторкнеться до очищаючої води, нечистим буде до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","І все, до чого приторкнеться нечистий, стане нечистим, і хто приторкнувся його, нечистим буде до вечора. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","І прийшли сини Ізрайлеві цїлою громадою в степ Зин, первого місяця; і остановився народ в Кадесї; і вмерла там Миряма, і поховано її там. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","І не стало води для громади, і зібрались вони проти Мойсея і Арона. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","І сварились люде з Мойсейом і з Ароном, мовляючи: Лучче було б нам померти тодї, як померло браттє наше перед Господом! ");
INSERT INTO ukr1871_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Та на що привели ви громаду Господню в цей степ, щоб і нам тут погибнути і скотинї нашій? ");
INSERT INTO ukr1871_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","І нащо вивели ви нас із Египту, щоб завести нас у се ледаче врочище? Нема ту нї землї на сїйбу, нї смоківниць, нї винограду, нї гранат, і навіть води нїде напитись. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","І пійшов Мойсей з Ароном від громади до входу в соборний намет, і впали ниць на лиця свої; і явилась їм слава Господня. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","І промовив Господь до Мойсея: кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Возьми жезло та збери громаду, ти й твій брат Арон, і покличте до скелї перед очима їх; і дасть вона вам воду свою, і виведеш їм воду із скелї, і напоїш громаду й скотину їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","І взяв Мойсей жезло од лиця Господнього, як він повелїв йому. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","І зібрали Мойсей та Арон громаду перед скелею; і рече їм: Слухайте ж, ворохобники, чи добудемо з сієї скелї воду про вас? ");
INSERT INTO ukr1871_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","І підняв Мойсей руку та й вдарив скелю жезлом своїм двічі; і потекло багацько води, і напилась громада й скотина їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","І рече Господь Мойсейові й Аронові: За те, що не няли ви менї віри, щоб осьвятити мене в очу синів Ізраїля, за те не приведете ви громади сієї в землю, що я надїлив їм. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Се води Мериви, де сварились Ізрайлеві сини з Господом, і він явив їм сьвятість свою. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","І післав Мойсей посли з Кадесу до царя Едомського: Так каже твій брат Ізраїль: Ти знаєш усї ті пригоди, що стались нам: ");
INSERT INTO ukr1871_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Як батьки наші спустились в Египет і ми жили в Египтї довгий час, і що Египтяне заподїяли нам і батькам нашим. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Тодї позвали ми до Господа, і він почув наш голос, і післав ангела та й вивів нас із Египту; і се ми в Кадесї містї, що на краю займища твого. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Дозволь же нам пройти через твою землю! Не будемо йти полями й виноградниками, і не будемо пити води з колодязїв; по царській дорозї перейдемо, не будемо звертати нї на право, нї на ліво, докіль не перейдемо займища твого. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Та відказав йому Едом: Не переходити меш в мене; ато з мечем вийду проти тебе. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","І казали йому синове Ізрайлеві: Битим шляхом ми хочемо йти; а коли воду твою пити му я, чи скотина моя, так заплачу тобі за неї; тільки ногами моїми хочу перейти, більш нїчого. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","І каже: не можна щоб проходити! І вийшов Едом проти його з великим народом і з потужною рукою. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","І так не дав Едом Ізраїлеві перейти через займища свої, і звернув Ізраїль на бік від його. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","І рушили в дорогу від Кадесу, і прийшли сини Ізрайлеві, цїлою громадою, до Ор гори. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","І рече Господь Мойсейові та Аронові під Ор-горою, на границях землї Едомової: ");
INSERT INTO ukr1871_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Мусить прилучитись Арон до народу свого; бо не має він увійти в землю, що я віддав синам Ізрайлевим за те, що ви противились повелїнню мому при водах Мериви. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Возьми Арона та Елеазара, сина його, та й приведи їх на Ор-гору; ");
INSERT INTO ukr1871_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","І знїми з Арона одїж його та вдягни в неї Елеазара, сина його, і прилучиться Арон і вмре там. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","І вчинив Мойсей, як заповідав Господь. І зійшли вони на гору перед очима в усієї громади. ");
INSERT INTO ukr1871_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","І зняв Мойсей з Арона одїж його, та й одягнув у неї Елеазара, сина його. І вмер Арон на верховинї Ор-гори. І спустивсь із гори Мойсей та Елеазар. І побачила вся громада, що вмер Арон, і плакав увесь люд Ізраїльський трийцять день. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","І прочув Канаанїй, царь Арадський, котрого осада була на полуднї, що йде Ізраїль шляхом до Атарима, і став битись з Ізраїльом і позаймав деяких із між їх у полонь. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","І зробив обітницю Ізраїль перед Господом кажучи: Коли справдї віддаси люд сей в руки мої, так понищу городи їх до нащаду. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","І почув Господь голос Ізраїля, і віддав Канаанїїв в руки його; і він знищив їх і городи їх. І назвали врочище те Горма. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","І рушили дальше від Ор-гори шляхом до Червоного моря, щоб обминути Едом землю. І впав дух у людей в дорозї. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","І почали люде говорити проти Бога і проти Мойсея: Нащо вивели ви нас, щоб нам повмирати в степу? Бо нема хлїба і нема води, і опротивіла нам вже тая нїкчемна пожива. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","І наслав Господь на люд гадюки сарафи, і кусали вони людей; і много люду вимерло в Ізраїлї. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Тодї приступили люде до Мойсея та й промовили до його: Согрішили ми, бо говорили проти Господа і проти тебе; благай Господа, щоб відняв гадюк від нас. І благав Мойсей за люд, і рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Зроби собі сарафа гадюку і повісь її на тику; і станеться, що як укусить кого гадюка, і він погляне на неї, то зостанеться живим. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","І зробив Мойсей гадюку мідяну, та й повісив її на тику; і сталося, що як укусила гадюка людину, і вона позирнула на мідяну гадюку, то зісталась живою. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","І рушили сини Ізрайлеві в дорогу та й отаборились в Оботї. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","І рушили дальше від Обота і стали табором в Іє-Абаримі у степу, що розкинувся перед Моабом на схід соньця. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Звідтам рушили вони та й отаборились над потоком Серед. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","А звідтам рушили вони дальше та й отаборились по другім боцї Арнона, що в степу, а виходить із займаньщини Аморіїв. Бо Арнон границя Моабова, між Моабіями і Аморіями. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Тим то й сказано в книзї боїв Господнїх: ");
INSERT INTO ukr1871_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Вагеб у Суфі і потоки Арнона; і злив потоків, що сягає до головного міста Ар, і тече по границї Моаба. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","А звідти рушили до Бейеру, се той колодязь, про котрого казав Господь Мойсейові: Збери народ, і дам їм воду. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Засьпівав тодї Ізраїль оцю пісню: У гору вода з колодязя! Сьпівайте про його! Колодязь той самі князї копали, дуки з народу, і сам законодавець жезлом пробивали. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","А із степу добирались дальше до Маттана. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Із Маттана в Нахалієль, а з Нахалієля до Бамота; ");
INSERT INTO ukr1871_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","А з Бамота в долину, що на полях Моаба, до верховин гори Пізга, що стремить над дикою полониною. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","І післав Ізраїль посли до Сигона, царя Аморійського, кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Позволь перейти через твою землю! Не будемо звертати на поля і на виноградники, і не будемо пити води з колодязїв; шляхом царським ійти мемо, покіль перейдемо твої займища. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Та не дозволив Сигон Ізрайлеві перейти через займаньщину свою; і зібрав Сигон увесь люд свій, та й вийшов проти Ізраїля в степ, і прийшов у Ягаз та й почав бити на Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","І побив його Ізраїль гострим мечем та й заняв його землю, від Арнона до Ябока, до синів Аммонових, Аммонове бо займище було потужне. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","І взяв Ізраїль всї городи сї, і почав жити у всїх Аморійських городах, в Гесбонї та й у всїх приналежних містах. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Бо Гесбон був город Сигона, царя Аморійського; а він бивсь із прежнїм царем Моабським, і взяв усю землю його до Арнона. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Тим же то у пісьнї сьпівають: Ой рушаймо до Гесбона, цареві Сигону город пишний будувати, мурами твердити. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Загорілось у Гесбонї у царя Сигона, і пожер огонь високі замки над Арноном. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Горенько тобі, Моабе! Народе Камосів! Гинеш марно, і втїкають сини твої в ростїч; утїкають, забувають давню свою славу, дочки ж твої в Аморія у неволї гинуть. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Зруйновали ми осади Гесбон до Дибону, від Нофи огнем спалили села до Медеби. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","І осївсь Ізраїль у землї Аморійський. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","І післав Мойсей на провідки в город Язер, і взяли вони приналежні оселї його, і вигнав він Аморіїв, що там були. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","І повернули вони і пійшли шляхом до Базану. І вийшов Ог, царь Базанський, проти них з усїм людом своїм воювати з ними коло Едреї. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","І рече Господь до Мойсея: Не лякайся його; бо я віддав в руки твої його й увесь люд його; і чини із ними те, що вчинив із Сигоном, царем Аморійським, що жив у Гесбонї. ");
INSERT INTO ukr1871_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","І повбивали вони його і синів його і ввесь люд його, так що не зістався нї один живий із них, та й заняли землю його. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","І рушили сини Ізрайлеві та й отаборились на рівнинї Моабський, по другім боцї Йордана навпроти Єрихону. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","І побачив Балак Зипоренко усе, що заподїяв Ізраїль Аморіям. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","І боялись вельми Моабії того люду, бо багацько було його, і великий пострах пійшов між Моабіями перед синами Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","І казали Моабії мужам старшим Мидіянським: Тепер обїсть голота ся навкруги нас усе, як обїдає віл траву у полї. А Балак Зипоренко був тодї царем Моабським. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","І післав він посли до Білеама Беоренка в Петор, що над рікою Ефрат, в землї синів народа його, щоб покликати його, і велів сказати йому: Ось вийшов люд із Египецької землї; і укрив він лице землї, та й осївсь проти мене. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Оце ж прийди та проклени менї сей люд: надто бо він потужен проти мене. Може удасться менї, що подужаю його і вижену його з країни: Знаю бо, кого ти благословиш, той благословен буде, а кого ти прокленеш, той проклятим буде. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","І пійшли старші мужі Моабські і мужі Мидіянські, з дарунками в руках за закленаннє. І прийшли вони до Білеама, і промовили йому слова Балакові. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","І каже він їм: Переночуйте тут сю ніч, і дам я вам відповідь, так як Господь менї скаже. І зістались князї Моабські в Білеама. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","І прийшов Бог до Білеама і каже: Що се в тебе за люде? ");
INSERT INTO ukr1871_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","І каже Білеам Богу: Балак Зипоренко, царь Моабській послав сказати менї: ");
INSERT INTO ukr1871_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Се люд вийшов із Египту й укрив лице землї. Оце ж прийди, проклени його менї; може буде в мене снага битись із ним і вижену їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","І каже Бог Білеамові: Не треба тобі йти з ними, не треба тобі проклинати люду; бо він благословений. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","І встав Білеам уранцї і сказав князям Балаковим: Ідїте в землю вашу; бо не схотїв Господь менї дозволити ійти з вами. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","І встали князї Моабські, і прийшли до Балака і кажуть: Не схотїв Білеам ійти з нами. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Тодї післав Балак ще раз князїв, поважніщих, як ті, і було їх більше. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","І прийшли вони до Білеама і промовили до його: Так мовляє Балак Зипоренко: Нехай уже нїщо не зупиняє тебе йти до мене: ");
INSERT INTO ukr1871_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Бо шаною великою вшаную тебе і все, що скажеш менї, вчиню; прийди ж, та заклени менї народ той! ");
INSERT INTO ukr1871_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","І відказав Білеам, і сказав слугам Балаковим: Коли б давав менї Балак будинок свій повен срібла й золота, так все таки не зміг би я переступити слова Господа, Бога мого, щоб вчинити чи мале чи велике. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Тепер же зістаньтесь ту й ви на ніч, щоб довідатись менї, що скаже менї Господь. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","І прийшов Бог в ночі до Білеама і рече йому: Коли тебе звати прийшли люде, так заберись та йди з ними; та чинити меш тільки те, що скажу тобі. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","І встав Білеам вранцї, і осїдлав ослицю свою, та й рушив в дорогу із князями Моабськими. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","І запалав гнїв Божий за те, що він пійшов; і став ангел Господень на дорозї, щоб спинити його; а він їхав на ослицї своїй і двох молодиків його з ним. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","І побачила ослиця ангела Господнього, що стояв на дорозї, і голий міч його в руцї його. І звернула ослиця з дороги та й пійшла полем. І вдарив Білеам ослицю, щоб вернути її на дорогу. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Но ангел став у сутках між виноградниками: стїна з одного боку і стїна з другого боку. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","І як побачила ослиця ангела, примчала вона до стїни і притиснула ногу Білеамові до стїни; і ще раз ударив її. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","І пройшов дальш ангел Господень, та й став в узькому місцї, де не було дороги звернути, нї праворуч, нї лїворуч. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","І побачила ослиця ангела Господнього, та й лягла під Білеамом; і запалав Білеам гнївом, і вдарив він ослицю палицею. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","І відчинив Господь щелепи в ослицї, і каже вона до Білеама: Що я тобі зробила, що бив єси мене оце три рази? ");
INSERT INTO ukr1871_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","І сказав Білеам до ослицї: Бо ти робила сьміх з мене; коли б у мене та був міч у руцї, то вбив би я тебе тепер. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","І каже ослиця до Білеама: Чи я ж не ослиця твоя, що на їй ти їздиш з того часу, як почав жити на сьвітї та й до сього дня? Хиба ж ізвикла я чинити з тобою таке? А він каже: Нї! ");
INSERT INTO ukr1871_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Тодї розкрив Господь очі Білеамові, і побачив він ангела Господнього, що стоїть на дорозї, і голий міч у руцї в його. І вклонивсь він; і склонив він лице своє до землї; ");
INSERT INTO ukr1871_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","І промовив до його ангел Господень: Защо оце вдарив єси ослицю твою три рази? Се сам я вийшов перебивати тобі; бо погибельна стежка твоя передомною. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","І бачила мене ослиця та й звертала оце передомною три рази. Коли б не звертала вона передомною, так нинї вбив би я тебе; а зоставив би її живою. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","І каже Білеам до ангела Господнього: Согрішив я; бо не знав, що ти стояв проти мене на стежцї. Оце ж коли негаразд воно в очу в тебе, так вернусь. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","І каже ангел до Білеама: Ійди з людьми, но тільки мусиш те промовляти, що скажу тобі. І пійшов Білеам із князями Балаковими. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","І почув Балак, що прибув Білеам, і вийшов він на зустріч йому в Ір-Моаб, на побережю Арнона, що на самому краю займища. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","І каже Балак до Білеама: Хиба ж не посилав я нарочно до тебе кликати тебе? Чом не прибував єси до мене? Чи то ж я справдї не спромігся б ушанувати тебе? ");
INSERT INTO ukr1871_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","І каже Білеам до Балака: Се прибув я до тебе, та хиба моя воля промовляти що не будь? Слово, що кладе Бог в уста менї, те промовляти му. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","І рушили Білеам з Балаком, і прибули вони в Кірият-Ензот. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","І принїс Балак жертву з буйної й дрібної скотини, та й послав Білеамові та князям, що були з ним. ");
INSERT INTO ukr1871_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","І сталось воно вранцї, що взяв Балак Білеама та й привів його на верхи Бааля, щоб він побачив із відти народ, що стояв зпереду. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","І каже Білеам до Балака: Постав менї ту сїм жертівників, і наготов менї семеро бичків і семеро баранів. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","І вчинив Балак те, що сказав Білеам. І жертвували Балак і Білеам бичка й барана на кожному жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","І каже Білеам до Балака: Стань коло всепалення твого, а я пійду: може стріне Господь мене, і що покаже він менї, те перекажу тобі. І пійшов на безлїсний верх гори. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","І стрів Бог Білеама, і він каже до його: Сїм жертівників поставив я, і принїс бичка й барана на кожному жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","І вложив Господь слово в уста Білеамові і промовив: Вернись до Балака і говори так: ");
INSERT INTO ukr1871_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","І вернувсь він до його; і се стояв він коло всепалення свого, сам він і всї князї Моаба. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","І почав він річ свою і промовив: Закликав мене з Арану Балак у гостину, з гір восточнїх царь Моабський у свою країну: Прийди, будеш ту Якова клясти-проклинати; прийди, будеш в Ізраїля долю відіймати. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Як я, царю, того зважусь клясти-проклинати, кого Бог сподобив ласки, Господь благодати? ");
INSERT INTO ukr1871_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Я на його з гір високих пильно позираю, із верхів очима всюди його проводжаю. Се той люд, що від народів окрім пробуває, між народами нїкого рідного не має. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Хто Якова та злїчив би пісок під ногами? Мирияди Ізраїля хто порахував би? Коли б менї так праведно, як і їм вмирати, я не знаю, чого в світї кращого й бажати. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","І каже Балак Білеамові: Що ти вчинив ізо мною? Проклясти вороги мої взяв я тебе, і се ти навіть благословляєш їх! ");
INSERT INTO ukr1871_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","І відповів той, кажучи: Хиба того, що вложив Господь в уста менї, не годиться менї виявити? ");
INSERT INTO ukr1871_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","І каже йому Балак: Ходїмо зо мною на инше місце, звідкіля мож побачити їх; та тільки тих, що поперед, бачити меш їх, а всїх не побачиш. І проклени менї їх із відтам. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","І вивів його на поле сторожі, на верховину Пісги-гори, і поставив там сїм жертівників, і принїс бичка й барана на кожному жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","І каже він Балакові: Стань ту коло всепалення твого, а я піду там на зустріч. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","І зустрів Господь Білеама, і вложив слово йому в уста, і рече: Вернись до Балака і так промовляти меш. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","І прийшов він до його; і се стоїть він коло всепалення, і князї Моабські з ним. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","І каже йому Балак: Що промовив Господь? ");
INSERT INTO ukr1871_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","І почав він приповідь свою і промовив: Встань, Балаче, та послухай, зрозумій, Зипорів сину! ");
INSERT INTO ukr1871_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Бог, не чоловік той льживий, щоб туманити людину. Сказав би він, та й не вдїяв? Нї, по віки так не буде! Він сказав, та й не справдив би? Се ж не ми, химерні люде. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Звелїв він благословити, я благословив, не сумнився, щоб Яков по Божій волї нїчим в сьвітї не журився. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Господь, Бог його, по віки з ним пробуває, голубить, і труба його царськая голосно рокоче, трубить. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Вивів люд свій із Египту, визволив з ярма, з неволї, мов той ріг у однорога, сила його в дикім полї. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","На Якова в нас не буде, ворожби чи то проклону: про Ізраїля всї люде скажуть: Бог його воздвигнув. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Мов левиця устає він, і мов лев стрибає в гору; ляже, як пожер здобичу та напивсь крові з улову. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","І каже Балак Білеамові: Лучче вже й не проклинай їх, і не благословляй. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","І відповів Білеам, і каже Балакові: Хиба не казав я тобі, що все, що промовив Господь, мушу сповнити. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","І каже Балак Білеамові: Ось ходїмо, візьму тебе в друге місце. Може, Богу буде вгодно, щоб ти прокляв їх із відтам. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","І взяв Балак Білеама на верх Пеора, що стремить на рівнинї пустинї. І каже Білеам Балакові: ");
INSERT INTO ukr1871_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Вистав менї ту сїм жертівників, і приготов менї ту семеро бичків і семеро баранів. ");
INSERT INTO ukr1871_vpl VALUES ("NU23_31","005_23_31","NUM","23","31","31","І вчинив Балак, що сказав йому Білеам, і жертвував він бичка й барана на кожному жертівнику. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","І побачив Білеам, що добре в очу в Господа благословити Ізраїля, і не пійшов, як перші рази, на ворожбу, а став лицем до степу. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","І зняв Білеам очі, та й побачив Ізраїля, що таборивсь по поколїннях своїх, і зійшов на його дух Божий. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","І почав він приповідь свою і промовив: Білеам, син Беорія, до вас промовляє, той, кому, відкрились очі, рече і звіщає. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Той рече, хто чув од Бога сї слова пророчі; всемогущого він бачив, і чув серед ночі. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ой Якове! що за гарні намети у тебе! Ізраїлю! Що за шатра в тебе таборові! ");
INSERT INTO ukr1871_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Мов долини розпростерлись пишно та роскішно, мов дуброви над рікою, що Господь садив їх; мов кедри понад водою високо знялися, розростаючись по всяк час надять, ваблять око. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Лити меш ти воду з відер, щоб твоє насїннє виростало й процьвітало на впокійних водах. Царь його ще переважить і царя Агага; царство його візьме гору над всїма царствами. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Вивів Бог його з Египту, силу однорожу; ворогів всїх пожере він, побє всї народи; поборовши їх потрощить костї в дикім полї; стрілами він повбиває усїх їх запеклих. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ліг як лев він опочити, хто його розбудить? Благо, хто тобі радїє та благословляє; проклять, хто тебе не любить, клене, проклинає! ");
INSERT INTO ukr1871_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","І запалав гнївом Балак на Білеама, і сплесне він руками, і каже Балак Білеамові: Проклясти вороги мої покликав я тебе, і се навіть благословеннєм благословив єси їх оце вже три рази. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Утїкай же до своєї домівки! Хотїв я шаною вшанувати тебе; та се вдержав тебе Господь од пошановання. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","І каже Білеам Балакові: Хиба ж я й послам твоїм, що посилав їх єси до мене, не казав: ");
INSERT INTO ukr1871_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Коли б давав менї Балак будинок свій повен срібла та золота, не переступив би я слова Господнього, вчинити що доброго, чи лихого по своїй волї. Що промовить Господь, те й мушу мовляти. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Тепер ж оце йду до мого люду. Ходїмо, так виявлю тобі, що робити ме навпослї народ той з твоїм народом. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","І почавши приповідь свою промовив він: Білеам се Беоренко рече-промовляє, той кому відкрито очі, рече і звіщає. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Той, хто чув од Бога слово в ночі, в сновидїннї, очі ж мав тодї закриті, а все ж таки бачив. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Бачу його перед віччу, тільки не сьогоднї, бачу його, та не зблизька, чую в мому дусї: сходить зоря із Якова, здіймається берло з Ізраїля, та й поламле Моабіям роги. Сетовим синам потужно черепи потрощить, і виски їм неощадно всїм порозбиває. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Буде Едом із Сеїром у гіркій неволї, а Ізраїль добру славу дїлами здобуде. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Із Якова вийде той, хто царів з їх престолів поскидає, і пустками городи поробить. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Побачивши ж Амалика, почав ще одну приповідь: Первим Амалик зробився між всїма царствами, та до впадку похилився, і буде остатнїм. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","А як побачив Кенїїв, сказав приповідь: Сїв ти, Кенїю, на скелї нерухомій твердо; ");
INSERT INTO ukr1871_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Та Ассур тебе в тяжкую одведе неволю. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Тодї сказав ще приповідь: Горе, горе, хто на сьвітї буде пробувати, як Господь такий допустить допуст на потужних! ");
INSERT INTO ukr1871_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Припливуть з Киттиму судна аж у тую землю, та й Ассурове звоюють, підневолять царство. ");
INSERT INTO ukr1871_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","І встав Білеам та й пійшов і став жити в домівцї своїй; Балак теж пійшов своєю дорогою. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","І жив Ізраїль у Ситтимі, і став блудувати люд із дочками Моабовими; ");
INSERT INTO ukr1871_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","І стали вони кликати люд на жертви богам своїм. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","І їв люд і припадав ниць перед богами їх, і прихиливсь Ізраїль до Бааль-Пеора. І запалав Господь гнївом на Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","І рече Господь до Мойсея: возьми всї голови людські та й повісь їх Господеві проти соньця, щоб одвернувсь жар гнїва Господнього від Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","І рече Мойсей суддям Ізрайлевим: Нехай кожен із вас повбиває людей своїх, що прихилились до Бааль-Пеора. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","І се прийшов один ізміж синів Ізрайлевих, і привів до браттї своєї Мидіянїйку, перед очима Мойсея й перед очима всієї громади Ізрайлевої, як вони тодї плакали коло входу в соборний намет. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","І побачив Пінегас, син Елеазара, сина Арона сьвященника, і встав ізміж громади, та взяв спіса в руку. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","І пійшов він слїдом за чоловіком Ізраїльським у середину шатра, та й пробив їх обох, чоловіка Ізраїльського й молодицю крізь животи їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","І зупинено помір між синами Ізраїля, а було мерцїв від помору двайцять і чотири тисячі. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","І рече Господь до Мойсея: ");
INSERT INTO ukr1871_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Пінегас, син Елеазара, сина Арона сьвященника, одвернув ярость мою від синів Ізрайлевих, ревнуючи за мене проміж ними, щоб не я вигубив синів Ізрайлевих в ревностї моїй. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Тим же то промов: Се я даю йому завіт мого примиря. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","І буде він йому й насїнню його після його завітом сьвященства віковічнього за те, що ревнував він за Бога свого, та й спокутував синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Імя ж чоловіка Ізраїльського погибшого, що проколено його з Мидіянїйкою, Зимрій Салусенко, князь батьківського дому Симеоніїв; ");
INSERT INTO ukr1871_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","На імя ж проколена молодиця Козбія, дочка Зура, голови одного батьківського дому в Мидіянїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Ворогуйте з Мидіянїями та й побивайте їх: бо по ворожи поступили вони з вами підступом своїм, затуманюючи вас Пеором і Козбією, дочкою князя Мидіянського, що вбито її під час мору задля Пеора. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","І сталось послї мору, що рече Господь Мойсейові та Елеазарові, синові Арона сьвященника: ");
INSERT INTO ukr1871_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Злїчи менї всю громаду синів Ізрайлевих од двайцяти років і старше, по їх батьківських домах, усїх здатних до війська в Ізраїлї. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","І розмовляли із ними Мойсей та Елеазар сьвященник на подїллю Моаба, над Йорданом, проти Єрихону, і казали вони: ");
INSERT INTO ukr1871_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Злїчіть усїх од двайцяти років і старше, як заповідав Господь Мойсейові. І се синове Ізрайлеві, що вийшли з Египецької землї: ");
INSERT INTO ukr1871_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Рубен, первенець Ізраїлів. Сини Рубенові: Ганох, від його родина Ганохіїв; Паллу, від його родина Паллуїв; ");
INSERT INTO ukr1871_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Гезрон, від його родина Гезроніїв; Кармій, від його родина Карміїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Се родини Рубенїїв. І було перелїчених їх сорок і три тисячі сїмсот і трийцять. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","А сини Палуєві: Елїаб. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","А сини Елїабові: Немуїль і Датан і Абирам; се ті покликані в громаду, що ворохобились проти Мойсея і Арона в ротї Корага, як нарікали на Господа. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Но роззявила земля пельку свою та й проглинула їх з Корагом, як погибла рота ся, що пожерло поломя їх: двістї і пятьдесять чоловіка; і стали вони знамям. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Сини ж Корагові не погибли. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Синове Симеонові по родинах їх: ");
INSERT INTO ukr1871_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Немуїль, від його родина Немуйлїїв; Ямин, від його родина Яминїїв; Яхин, від його родина Яхиїїв; Зерах, від його родина Зерахіїв; Саул, від його родина Сауйліїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Се родини Симеонїїв: двайцять дві тисячі і двісті. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Сини Гадові по родинах їх: Зефон, від його родина Зефонїїв; Гаггій, від його родина Гаггіїв; Шунїй, від його родина Шунїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Оснїй, від його родина Оснїїв; Ерій, від його родина Еріїв, ");
INSERT INTO ukr1871_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Арод, від його родина Ародїїв; Аремій, від його родина Ареміїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Се родини Гадові по перелїчених їх: сорок тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Сини Юдині: Гер та Онан; та померли Гер і Онан в Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","І були Юдині сини по родинах їх: Шела, від його родина Шеланїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Перез, від його родина Перезіїв; Зерах, від його родина Зерахіїв. І були сини Перезові: Гезрон, від його родина Гезронїїв; Гамуль, від його родина Гамулїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Се родини Юди, по перелїчених їх: сїмдесять шість тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Синове Іссахарові по родинах їх: Тола, від його родина Толаїв; Пува, від його родина Пуваїв: ");
INSERT INTO ukr1871_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Яшуб, від його родина Яшубіїв; Симрон, від його родина Симроніїв; ");
INSERT INTO ukr1871_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Се родини Іссахарові, по перелїчених їх: шістьдесять чотири тисячі і триста. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Синове Зебулонові по родинах їх: Серед, від його родина Середїїв; Елон, від його родина Елонїїв; Яхлеїль, від його родина Яхлеілїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Се родини Зебулонїїв, по перелїчених їх: шістьдесять тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Синове Йосифові, по родинах їх: Манассїй і Ефраїм. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Синове Манасїєві: Макир, від його родина Макиріїв, а Макир появив Гілеада; Гілеад, від його родина Гілеадїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Се синове Гілеадові: Їезер, від його родина Їезріїв; Гелек, від його родина Гелекіїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Асриїль, від його родина Асрийлїїв, і Сихем, від його родина Сихеміїв; ");
INSERT INTO ukr1871_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Шемида, від його родина Шемидїїв; Гефер, від його родина Геферіїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","У Зелофада ж Геференка не було синів; а імена дочок Зелофадових: Махля і Ноя, Хогля, Милка і Тирза. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Се родини Манассїєві, а перелїчених їх було: пятьдесять дві тисячі і сїмсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Се синове Ефраїмові по родинах їх: Шутелах, від його родина Шутеляхіїв; Бекер, від його родина Бекеріїв; Тахана, від його родина Таханїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","А се сини Шутеляхові: Еран, від його родина Еранїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Се родини синів Ефраїмових по перелїчених їх: трийцять дві тисячі і пятьсот. Се сини Йосифові по родинах їх: ");
INSERT INTO ukr1871_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Синове Беняминові по родинах їх: Бела, від його родина Белаїв; Ашбель, від його родина Ашбелїїв; Ахирам, від його родина Ахираміїв; ");
INSERT INTO ukr1871_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Сефуфам, від його родина Сефуфаміїв; Гуфам, від його родина Гуфаміїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","А сини в Бели були Ард і Нааман. Від Арда родина Ардїїв; від Наамана родина Нааманїїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Се синове Беняминові по родинах їх, а перелїчених їх сорок пять тисяч і шістьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Се синове Данові по родинах їх: Шухам, від його родина Шухаміїв. Се родина Данова по родинах їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Усїх родин Шухаміїв по перелїчених їх: шістьдесять чотири тисячі і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Синове Ассерові по родинах їх: Їмна, від його родина Їмнїїв; Їтва, від його родина Їтвіїв; Берія, від його родина Беріїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Від синів Берії: Гебер, від його родина Гебріїв; Малкиїль, від його родина Малкиїлїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","А імя дочки Ассерової було Сераха. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Се родини синів Ассерових по перелїчених їх: пятьдесять три тисячі і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Синове Нефталїєві по родинах їх: Яхзеїль, від його родина Яхзеїлїв; Гунїй, від його родина Гуніїв; ");
INSERT INTO ukr1871_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Езер, від його родина Езеріїв, Шіллем, від його родина Шіллеміїв. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Се родини Нафталієві, і перелїчених їх було сорок пять тисяч і чотириста. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Се перелїчені сини Ізрайлеві: шістьсот одна тисяча сїмсот і трийцять. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Між тими подїлена мусить бути земля в наслїддє, по лїчбі імен. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","У кого богацько душ, побільшиш наслїддє його, а в кого мало душ, поменьшиш наслїддє його; кожному, дивлючись по перелїчених його, надїлиш наслїддє його. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Тілько ж по жеребу буде роздїлена земля; по батьківських іменах наслїдувати муть її. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Як випаде жереб, буде удїлене кожному наслїддє його, чи велике чи мале воно. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","А се перелїчені Левіти по родинах їх: Від Герзона родина Герзонїїв; від Кегата родина Кегатїїв; ");
INSERT INTO ukr1871_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Від Мерарія родина Мераріїв. Се родини Левітів: родина Либніїв, родина Геброніїв, родина Махлїїв, родина Мушлїїв, родина Коргіїв. А Кегат появив Амрама. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","А жінка Амрамова була на імя Йокебеда, дочка Левієва, що зродила Левієві в Египтї. І породила вона Амрамові Арона й Мойсея, та Миряму, сестру їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Аронові ж родились Надаб і Абигуй, Елеазар та Ітамар. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","І померли Надаб і Абигуй, як приносили чужий вогонь перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","І було їх перелїчених двайцять і три тисячі, ввесь музький пол від одномісячних і старше; не перелїчив же їх між синами Ізрайлевими, бо не дано їм наслїддя між синами Ізрайлевими. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Се ті, що перелїчили їх Мойсей та Елеазар при Йорданї, проти Єрихону. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Та між сими не було нї одного чоловіка з тих, що були перелїчені від Мойсея та Арона сьвященника, як перелїчували вони сини Ізраїля в Синайському степу. ");
INSERT INTO ukr1871_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Про них бо сказав Господь Мойсейові: Смертю помруть вони в степу, і не зістанеться з їх нї чоловіка, окрім Калеба Єфуненка та Йозея Нуненка. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","І приступили дочки Зелофхада, сина Гефера, сина Гілеада, сина Макіри, сина Манассії, із родини Манассії, сина Йосифа, і се імена дочок його: Махля, Ноя та Хогля, та Милка та Тирза. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","І стали вони перед Мойсейом та Єлеазаром сьвященником і перед князями й перед усією громадою, коло входу в соборний намет, і промовили: ");
INSERT INTO ukr1871_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Батько наш умер у степу, хоть і не було його між ротою, що зібралась проти Господа в ротї Кораговій, та за свій гріх вмер він; синів же у його не було. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Чому ж би мало пропасти імя панотця нашого з роду його за те, що нема сина в його? Дай нам власність між братами батька нашого! ");
INSERT INTO ukr1871_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","І принїс Мойсей справу їх перед Господа. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","І рече Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Праведно дочки Зелофхадові говорять; треба ж тобі надїлити їм наслїдню державу між братами батька їх і нехай перейде на них батьківщина їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","А синам Ізраїля казати меш: Коли вмер чоловік і нема в його сина, так мусите перевести наслїддє його на дочку його. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","А коли нема в його дочки, так оддасьте наслїддє його братові його. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","А коли нема в його братів, так оддасьте наслїддє його батьковим братам його. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","А коли нема братів у батька його, так оддасьте наслїддє родичові його, найближшому в родинї його, і держати ме його він. І буде се синам Ізрайлевим правосудня установа, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","І рече Господь Мойсейові: Ізійди на Абарім гору, і побачиш землю, що я надїлив синам Ізрайлевим. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","І як побачиш, так прилучишся до народу твого, як прилучивсь Арон, твій брат; ");
INSERT INTO ukr1871_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Бо збунтувались ви проти слова мого в Зин степу, в час сварки громадської, щоб явити сьвятость мою перед очима їх (се єсть при водах Мериви, у Кадесї, в Зин степу). ");
INSERT INTO ukr1871_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","І промовив Мойсей до Господа, кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Господе, Боже духів усякого тїла, постав над громадою чоловіка, ");
INSERT INTO ukr1871_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Щоб виходив і ввіходив перед ними, і щоб виводив їх і вводив їх, щоб не була громада Господня, як отара, що нема в неї пастуха. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","І рече Господь Мойсейові: Возьми собі Йозея Нуненка; чоловіка, в котрого дух, і положи на його руку твою; і постав його перед Єлеазаром сьвященником і перед усією громадою. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","І дай йому поволїння перед очима їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","І удїли йому достойньства свого, щоб корилась йому вся громада синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","І нехай стане він перед Єлеазаром сьвященником, а той питати ме за його про суд урім перед Господом. По слову його вони виходити муть і по слову його ввіходити муть, він сам і всї сини Ізрайлеві з ним, уся громада. ");
INSERT INTO ukr1871_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","І вчинив Мойсей, як заповідав йому Господь, і взяв Йозея і поставив його перед Єлеазаром сьвященником і перед усією громадою; і положив руки на його і передав йому повелїння, як заповідав Господь через Мойсея. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","І промовив Господь до Мойсея: ");
INSERT INTO ukr1871_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Повели синам Ізрайлевим і скажи їм: Приноси мої, хлїб мій, на огняні жертви мої, на любі пахощі мої мусите проносити менї у призначений час. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","І скажи їм: Ось які огняні жертви маєте приносити Господеві: двоє ягнят перволїтних без скази, щодня, як повсячасне всепаленнє. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Одно ягня принесеш уранцї, а друге ягня принесеш між двома вечорами; ");
INSERT INTO ukr1871_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","А як хлїбну жертву, одну десятину ефи муки пшеничної, перемішаної з четвертиною гіна олїї забиваної. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Повсячасне всепаленнє, що установлено його на Синай горі про любі пахощі, огняна жертва Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","А як жертву ливну четвертину гіна про одно ягня. У сьвятинї мусиш приносити Господеві жертву ливну з кріпкого напитку. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","А ягня друге принесеш між двома вечорами; хлїбну і ливну жертву як вранцї принесеш до того, огняну жертву любих Господеві пахощів. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","А в день субітний двоє ягнят без скази і дві десятини муки пшеничної, перемішаної з олїєю, та жертву ливну до того. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Се всепаленнє в день субітній, що суботи, опріч всепалення повсячасного і його жертви ливної. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","А як настає ваш місяць, приносити мете на всепаленнє Господеві: двоє бичків та одного барана, семеро ягнят перволїтків без скази; ");
INSERT INTO ukr1871_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","А до кожного бичка три десятини муки пшеничної, перемішаної з олїєю як хлїбну жертву; а до одного барана дві десятини муки пшеничної, перемішаної з олїєю, як жертву ливну; ");
INSERT INTO ukr1871_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","І до кожного ягнятї по десятинї муки пшеничної, перемішаної з олїєю, як хлїбну жертву. Се всепаленнє, любі пахощі, огняня жертва Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","А їх жертви ливні: пів гіна до одного бичка, і третина гіна до одного барана, а четвертина гіна до ягнятї. Се всепаленнє новомісячне, по всї місяцї року. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","І козла одного на жертву за гріх приносити муть Господеві, опріч всепалення повсячасного з возливаннєм його. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","А первого місяця, на чотирнайцятий день місяця паска Господеві; ");
INSERT INTO ukr1871_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","А на пятнайцятий день того місяця сьвято; сїм день опрісноки треба їсти, ");
INSERT INTO ukr1871_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","На первий день будуть сьвяті збори у вас, і нїякого дїла робочого не робити мете. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","А будете приносити жертву огняну, всепаленнє Господеві: двоє бичків, та одного барана, та семеро ягнят перволїтків; без скази мусять у вас бути; ");
INSERT INTO ukr1871_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","А як жертву хлїбну до них: муки пшеничної перемішаної з олїєю, три десятини ефи на одного бичка і дві десятини на барана; ");
INSERT INTO ukr1871_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","По десятинї принесете на кожне з сїмох ягнят. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","І козла одного про жертву за гріх на спокутуваннє за вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Опріч всепалення ранїшного, повсячасної жертви огняної, приносити мете се. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Се будете приносити через сїм день; як хлїб огняної жертви, пахощі любі Господеві; опріч всепалення повсячасного будете приносити се вкупі з жертвою ливною. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","А на семий день будуть сьвяті збори в вас: і жадної роботи не робити мете. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","І в день первеньцїв, як приносите нову хлїбну жертву Господеві, послї вашого сьвята однотижневого будуть сьвяті збори в вас; жадної роботи не робіть. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","І принесете всепаленнє на любі пахощі Господеві: двоє бичків, одного барана, семеро ягнят перволїтків; ");
INSERT INTO ukr1871_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","І жертву хлїбну до них: муки пшеничної перемішаної з олїєю три десятини ефи на одного бичка, дві десятини на одного барана, ");
INSERT INTO ukr1871_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","По десятинї на кожне з сїмох ягнят; ");
INSERT INTO ukr1871_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Одного козла на спокутованнє за вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Опріч всепалення повсячасного вкупі з хлїбною і ливною жертвою будете приносити їх, без скази будуть вони в вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","І в місяцї семому, на первий день місяця того, мусять сьвяті збори в вас бути. Нїякого дїла робочого не робіть; день гучних труб буде се в вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","І будете приносити всепаленнє на любі пахощі Господеві: одного бичка, одного барана, семеро ягнят перволїтків без скази, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","І хлїбну жертву до них: муки пшеничної перемішаної з олїєю три десятини на бичка, дві десятини на барана, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","І одну десятину на кожне із сїмох ягнят; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Та одного козла на жертву за гріх, на спокутованнє за вас, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Окрім всепалення місячного з хлїбним даром його та окрім всепалення повсячасного з хлїбним даром його, по установі, на любі пахощі, огняна жертва Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","А на девятий день, того семого місяця будуть сьвяті збори в вас, і будете впокорювати душі ваші; нїякої роботи не робіть. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","А принесїть всепаленнє Господеві, любі пахощі: одного бичка, одного барана, семеро ягнят перволїтків; без скази мусять вони бути в вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","А як хлїбний дар до них: муки пшеничної, перемішаної з олїєю три десятини ефи до бичка, дві десятини до барана одного, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","По десятинї до кожного ягняти з сїмох ягнят; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Одного козла на жертву за гріх; опріч жертви на спокутуваннє і повсячасного всепалення з хлїбними і ливними дарами їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","І на пятнайцятий день семого місяця мусять сьвяті збори в вас бути. Не будете робити нїякого дїла робочого, а мусите сьвяткувати сьвято Господеві сїм день. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","І принесете первого дня всепаленнє, огняну жертву любих пахощів Господеві: тринайцять бичків, двох баранів, ягнят перволїтків чотирнайцятеро; без скази мусять вони бути. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","А як хлїбний дар до них: муки пшеничної, перемішаної з олїєю три десятини ефи до кожного бичка, дві десятини до кожного з двох баранів, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","По десятинї до кожного із чотирнайцятеро ягнят; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","І козла одного як жертву за гріх, опріч всепалення повсячасного з хлїбним і ливним даром до його. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","І на другий день: дванайцятеро бичків, двох баранів, чотирнайцятеро ягнят перволїтків без скази, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","З дарами хлїбними і ливними до бичків, до баранів і до ягнят по лїчбі їх, по установі; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","І козла одного про жертву за гріх, опріч всепалення повсячасного з хлїбним і ливним даром до його. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","І на третїй день: бичків одинайцятеро, баранів двох, ягнят перволїтків без скази чотирнайцятеро, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","З хлїбним і ливним даром до бичків, до баранів і до ягнят по лїчбі їх, по установі; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Та козла одного на жертву за гріх, опріч всепалення з його даром хлїбним і ливним. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","На четвертий день: бичків десять, баранів двох, ягнят перволїтків без скази чотирнайцятеро, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","З їх даром хлїбним і ливним до бичків, до баранів і до ягнят, по лїчбі їх, по установі; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Та козла одного на жертву за гріх, опріч всепалення повсячасного з його даром хлїбним і ливним. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","На пятий день: бичків девятеро, баранів двох, ягнят перволїтків без скази чотирнайцятеро, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","З хлїбними і ливними дарами їх до бичків, до баранів і до ягнят, по лїчбі їх, по установі; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","І козла одного на жертву за гріх, опріч всепалення повсячасного з його даром хлїбним і ливним. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","В шестий день: бичків восьмеро, баранів двох, ягнят перволїтків без скази чотирнайцятеро, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","З їх дарами хлїбними і ливними до бичків, до баранів і до ягнят, по лїчбі їх, по установі; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","І козла одного на жертву за гріх, опріч всепалення повсячасного з хлїбним і ливним даром до його. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","І на семий день: бичків семеро, баранів двох, ягнят перволїтків без скази чотирнайцятеро, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","І хлїбні і ливні дари до них, до бичків, до баранів і до ягнят, по лїчбі їх, по установі; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Та козла одного на жертву за гріх, з даром до його хлїбним і ливним. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","На восьмий день сьвяточні збори мусять бути в вас. Нїякого дїла не будете робити. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Будете ж приносити на всепаленнє, огняну жертву про пахощі любі Господеві: бичка одного, барана одного, ягнят перволїтків без скази семеро, ");
INSERT INTO ukr1871_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","З даром хлїбним і ливним до них, до бичків, до баранів і до ягнят, по лїчбі їх, по установі; ");
INSERT INTO ukr1871_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Та козла одного на жертву за гріх, опріч повсячасного всепалення і дарів хлїбних і ливних до його. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Се будете приносити Господеві у сьвята ваші окрім обітниць ваших і окрім добровільних приносів ваших на всепаленнє і на жертву ливну і мирну. ");
INSERT INTO ukr1871_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","І повелїв Мойсей синам Ізрайлевим усе, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","І промовив Мойсей до голов поколїнь синів Ізрайлевих: ");
INSERT INTO ukr1871_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","От що заповідав Господь: Коли чоловік шлюбував обітницю Господеві, чи поклявся клятьбою, взяти обовязок на душу свою, то не можна йому ломити слова свого, а мусить чинити після того, що вийшло з уст його. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","А коли жінка шлюбує обитницю Господеві, і возьме обовязок в домі батька свого, дївуючи, ");
INSERT INTO ukr1871_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","І батько чує обітницю її, або обовязок її, що взяла його на душу свою, та й промовчить проти неї, так буде важна обітниця її, і важний обовязок її, який вона взяла на душу свою. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Коли ж заборонить їй отець її того ж дня, як почув, то всї обітницї її і всї обовязки її, які взяла на душу свою, не будуть важні; Господь простить їй, бо заборонив їй батько її. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Як же вона замужна і зробить обітницю, чи то скаже що небудь не роздумавши, і звяже душу свою, ");
INSERT INTO ukr1871_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","А чоловік її почує, та й не озветься проти того в той день, як почує се, так її обітницї будуть важні, і обовязки її, що взяла їх на душу свою, будуть важні. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Коли ж чоловік її заборонить їй того ж дня, як почує се, то знївечив він обітницю її, що на їй, і нерозважне слово усть її, що ним звязала вона душу свою; і Господь простить їй. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Як вдова вона або розвідка, то всяка обітниця, якою звязала вона душу свою, мусить бути важною для неї. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Як же вона у господї чоловіка свого зробила обітницю, або клятьбою взяла обовязок на душу свою, ");
INSERT INTO ukr1871_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","І як почув чоловік її, та й промовчав, не заборонив їй, так мусять бути важні всї обітницї її, і всякий обовязок, що взяла його вона на душу свою, буде важний. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Коли ж чоловік її знївечит їх того дня, як почув їх, то всї обітницї й обовязки душі її, що вийшли з уст її, не важні; чоловік її знївечив їх, і Господь простить їй. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Всяку обітницю і всякий обовязок клятьби для впокорювання душі може чоловік її удобрити, і може знївечити. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Коли ж мовчав чоловік її з дня на день, то він пристав на всї обітницї її або на всї зʼобовязання її, що на нїй; він одобрив їх, бо мовчав у той день, як почув їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Коли ж він знївечить їх після того, як, почувши їх, мовчав, так нести ме він гріх її. ");
INSERT INTO ukr1871_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Се встанови, що повелїв Господь Мойсейові про справи між чоловіком і жінкою, між батьком і дочкою за її дївування в батьковій господї. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","І промовив Господь до Мойсея кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Помстись на Мидіянїях за синів Ізрайлевих; тодї прилучиш ся до предків твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","І промовив Мойсей до люду словами: Оружіть людей зміж вас на війну, щоб ійти їм на Мидіянїя, сповнити помсту Господню на Мидіянїєві. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","По тисячі чоловіка з одного поколїння, від усїх поколїнь Ізрайлевих вишлете і поставите до війська. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","І вибрали зміж тисячей Ізраїля по тисячі чоловіка з кожного поколїння, дванайцять тисяч оружних на війну. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","І вислав їх Мойсей, по тисячі з кожного поколїння, на війну, їх і Пінегаса Єлеазаренка, сьвященника, на війну; а посуди сьвятинї і труби для трівоги були в його руках. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","І почали вони бити Мидіяна, як заповідав Господь Мойсейові, та й повбивали ввесь музький пол. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","І вбили вони опріч инших вбитих царів Мидіяна: Евія і опріч инших Рекема і Зура і Гура і Реба, пятьох царів Мидіянських; так само Білеама Бейоренка вбили мечем. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","І сини Ізраїля позаймали в полонь все жіноцтво Мидіянське і дїтвору їх, і забрали здобичу, скотину їх і всї отари їх, і всї достатки їх; ");
INSERT INTO ukr1871_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","А всї міста їх, по займаньщинах їх, і всї оселї їх пустили на пожар. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","І взяли всю здобич і все награбоване, людей і скотину, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Та й привели бранцїв і награблене і здобич до Мойсея і до Елеазара сьвященника, і до громади синів Ізраїля у табір, на поділлє Моабське, що на Йорданї, проти Єрихона. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","І вийшли Мойсей та Єлеазар сьвященник і всї князї громадські назустріч їм перед табором. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","І розгнївився Мойсей на воєводів та на тисячників і на сотників, що з війни вернулись; ");
INSERT INTO ukr1871_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","І каже до них Мойсей: Про що ви зоставили живими все жіноцтво? ");
INSERT INTO ukr1871_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Се ж вони були по радї Білеама принадою синам Ізрайлевим, щоб вони вчинили зраду проти Господа, задля Пейора, через що й був помір у громадї Господнїй. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Оце ж повбивайте всїх дїтей музького полу, і все жіноцтво, що пізнало мужчину, злїгшись, також повбивайте. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Всїх же дїтей жіночого полу, дївчат, що не пізнали ложа з чоловіком, позоставляйте живими для себе. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","А ви самі пробудете поза табором сїм день, кожен, хто вбив чоловіка і кожен, хто приторкнувсь до вбитого, всї ви очиститесь в третїй день і в семий день, ви і полоняни ваші, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Мусите ви очистити і всяку одїж і всяку посудину шкіряну, і всяку роботу з козиної шерстї і всяку посудину деревяну. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","І сказав Єлеазар сьвященник до всїх людей військових, що ходили на війну: Се установа закону, що заповідав Господь Мойсейові: ");
INSERT INTO ukr1871_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Тільки золото й срібло, мідь, зелїзо, цина й олово, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","Усе що держиться в огнї, мусите проводити через огонь, щоб стало чистим; а все таки мусите його водою очищення од гріха очистити; а все, що не видержить в огнї, проведете через воду. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","І повипираєте одїж свою в семий день, і станете чистими, а тодї ввійдете до табору. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","І промовив Господь до Мойсея словами: ");
INSERT INTO ukr1871_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Перелїчи здобичу, людей і скотину, ти і Єлеазар сьвященник і голови родин всієї громади; ");
INSERT INTO ukr1871_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Та й подїлїть здобичу по половинї між тими, що воювали, і всією громадою. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","І возьми данину для Господа від тих, що становились у військові лави: одну душу із пятьсот, з людей та з буйної скотини та з ослів та з дрібної скотини; ");
INSERT INTO ukr1871_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Із їх половини возьмеш се та й оддаси Єлеазарові сьвященникові як жертву возношення Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","А з половини, що дістанеться синам Ізрайлевим, возьмеш одну душу із пятьдесять, із людей, та з буйної скотини, та з ослів, та з дрібної скотини, з усякої скотини; і віддаси Левітам, що доглядають храмини Господньої. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","І вчинили Мойсей та Єлеазар сьвященник так, як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","І була добич, оставшаяся від захопленого, що захопив люд військовий, така: дрібної скотини шістьсот і сїмдесять і пять тисяч, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","А буйної скотини сїмдесять і дві тисячі, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","А ослів шістьдесять і одна тисяча; ");
INSERT INTO ukr1871_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Що ж до душ людських, то було дївчат, що не знали ложа мужнього, всїх, трийцять і дві тисячі душ. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","А друга половина, пай тих, що стояли у військових лавах, була по перелїченю така: дрібної скотини триста трийцять сїм тисяч і пятьсот. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","А данина для Господа з дрібної скотини була: шістьсот сїмдесять і пять штук; ");
INSERT INTO ukr1871_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","А буйної скотини було трийцять і шість тисяч, з того данина для Господа була: сїмдесять і дві штуки; ");
INSERT INTO ukr1871_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","А ослів було трийцять тисяч і пятьсот, а данина для Господа з них шістьдесять і одна штука; ");
INSERT INTO ukr1871_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Душ же людських було шіснайцять тисяч, а з них данина для Господа трийцять і дві душі. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","І віддав Мойсей Єлеазарові, сьвященникові, данину на жертву возношення Господеві, як повелїв Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","А з половини, що випала синам Ізрайлевим, що віддїлив Мойсей від другої половини, що була для людей військових, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Була ж половина, що випала для громади, така: триста трийцять сїм тисяч і пятьсот штук малої скотини, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Та буйної скотини: трийцять і шість тисяч, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Та ослів: трийцять тисяч і пятьсот, ");
INSERT INTO ukr1871_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Та й душ людьких: шіснайцять тисяч душ. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","А з половини, що випала синам Ізрайлевим, взяв Мойсей одну душу із пятьдесять, із людей та із скотини, та й віддав Левітам, що доглядали храмини Господньої; так як заповідав Господь Мойсейові. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","І приступили до Мойсея воєводи та тисячники та сотники, та й промовили до Мойсея: ");
INSERT INTO ukr1871_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Слуги твої перелїчили військових людей, що поручені нам, і не бракує з нас нї одного чоловіка: ");
INSERT INTO ukr1871_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","І оце ж приносимо ми приніс Господеві, що хто знайшов із золотих річей: обручки, ланьцюжки, перстенї, сережки й намиста, щоб відправити за душі наші покуту перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","І взяли в них Мойсей та Єлеазар сьвященник золото всїлякої штучної роботи. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","І було всього золота, принесеного в жертву возношення Господеві шістьдесять тисяч сїмсот і пятьдесять секлїв, від тисячників і від сотників. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Люде ж військові грабили кожен для себе. ");
INSERT INTO ukr1871_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","І взяли Мойсей та Єлеазар сьвященник золото у тисячників і сотників, і внесли його в соборний намет, як спомин від синів Ізраїля перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Було ж в синів Рубена і в синів Гада буйної скотини багато, велика тьма; і бачили вони, що Язер земля і Гілеад земля як раз годяться про скотину. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","І прийшли синове Гадові й синове Рубенові, та й промовили до Мойсея і Єлеазара сьвященника й до князїв громадських так: ");
INSERT INTO ukr1871_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Атарот та Дибон та Язер та Нимра та Гесбон та Єлале та Себам та Небо та Бейон, ");
INSERT INTO ukr1871_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Земля, що побив Господь перед громадою Ізрайлевою, се земля про скотину. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","І сказали вони: Коли знайшли ми ласку в очах твоїх, оддай сю землю слугам твоїм у державу, не переводь нас через Йордан. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","І каже Мойсей синам Гадовим та синам Рубеновим: Так браттє ваше пійде на війну, а ви ту зостанетесь? ");
INSERT INTO ukr1871_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Чого ж одхиляєте ви серце синів Ізрайлевих, щоб перейти в он тую землю, що надїлив їм Господь? ");
INSERT INTO ukr1871_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Так зробили батьки ваші, як я посилав їх у Кадес-Барнеа, розгледїти землю: ");
INSERT INTO ukr1871_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Вони добрались до долини Эсколя і розглянули землю; а потім відхилили вони серце синів Ізраїля, щоб вони не йшли в землю, що надїлив їм Господь. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","І запалав Господь гнївом того часу і поклявся словами: ");
INSERT INTO ukr1871_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Люде ті, що вийшли з Египту, від двайцяти років і старше, не побачять землї, що про неї я клявся Авраамові, та Ізаакові та Яковові, бо не зовсїм слухали вони мене. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Окрім Калеба, сина Ефуна Кенизїя та Йозея Нуненка; сї бо завсїди ійшли слїдом за Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","І запалав Господь гнївом проти Ізраїля, і допустив, щоб він блукав по степу сорок років, аж поки не вимерло все кодло, що коїло ледарство перед очима Господа. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","І се постали ви намість батьків ваших, одріддє грішників, щоб іще побільшити лютість гнїва Господнього на Ізраїля. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Коли ж ви одвернетесь від його, так держати ме сей нарід ще довше у степу, і погубите ви увесь нарід сей. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","І приступили вони до його та й промовляли: Побудуємо тут кошарі для стад наших і міста про дїтвору нашу; ");
INSERT INTO ukr1871_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","А самі чим швидче узброїмось та й рушимо поперед синів Ізрайлевих, аж приведемо їх на займища їх; а дїти наші остануться в утверджених містах задля осадників країни сієї. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Не вернемось до господи нашої, поки кожен із синів Ізраїлевих не дістане наслїддя свого. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Бо не хочемо дїлити з ними наслїддя по другім боцї Йорданї, тим що досталось нам наслїддє наше по сїм боцї Йорданї, на схід соньця. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","І каже їм Мойсей: Коли так зробите се дїло, коли узброїтесь на війну перед Господом, ");
INSERT INTO ukr1871_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","І всї між вами, що узброєні, пійдуть перед Господом за Йордань, покіль він не прожене ворогів своїх перед собою, ");
INSERT INTO ukr1871_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","І впокорена буде земля Господеві, а ви тодї вернетесь, то будете безвинні перед Господом і перед Ізраїльом; і буде земля ся власностю вашою перед Господом. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","А коли так не вчините, то согрішили ви проти Господа; і знайте, що гріх ваш знайде вас. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Будуйте собі міста про малечу вашу і кошарі про дрібну скотину вашу, та справдїте, що вийшло з уст ваших. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","І промовили сини Гадові і сини Рубенові до Мойсея так: Слуги твої вчинять, що добродїй наш повелїв нам. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Малеча наша, жени наші, стада наші й уся наша скотина будуть там, у городах Гілеада; ");
INSERT INTO ukr1871_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Твої ж слуги, усї на війну узброєні, пійдуть перед Господом на війну, як добродїй мій промовив. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","І повелїв про них Мойсей Єлеазарові, сьвященникові, та Йозейові Нуненкові, та головам батькових поколїнь Ізраїля; ");
INSERT INTO ukr1871_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","І каже до них Мойсей: Коли всї узброєні сини Гадові і сини Рубенові перейдуть з вами перед Господом через Йордань, і впокорена буде земля ся перед вами, так оддасьте їм у державу Гілеад землю; ");
INSERT INTO ukr1871_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Коли ж не узброєні перейдуть вони з вами, тодї нехай оселяться між вами в Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","І відповіли синове Гадові та синове Рубенові кажучи: Як казав Господь слугам твоїм, так зробимо. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Перейдемо узброєні перед Господом у Канаан землю, а наша наслїдня держава нехай по сїм боцї Йорданї буде. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","І надїлив їм Мойсей, синам Гадовим та синам Рубеновим та половинї поколїння Манассії, сина Йосифового, царство Сигона, царя Аморіїв, та царство Ога, царя Базанського, землю з городами її, у всїх границях її, міста по всїй країнї. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","І побудували сини Гадові: Дибон да Атарот та Ароер, ");
INSERT INTO ukr1871_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Та Атарот-Шофан, та Язер, та Йогбега, ");
INSERT INTO ukr1871_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Бет-Нимра і Бет-Гаран, утверджені міста і кошарі для дрібної скотини. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","А сини Рубенові побудували: Гезбон та Єлале та Кирятаїм, ");
INSERT INTO ukr1871_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Та Небо та Бааль-Меон, перемінивши їх імена, та Сибму; і подавали нові прізвища містам, що побудували. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Сини ж Макіра Манассеєнка двинули на Гілеад і заняли його; і прогнали Аморіїв, що жили там. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","І надїлив Мойсей Макірові Манассеєнкові Гілеад; і він осївся там. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Яір же Манассієнко пійшов і заняв села їх та й назвав їх Яїровими селами. ");
INSERT INTO ukr1871_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","А Нобах двинув і заняв Кенат і займища його та й назвав його своїм імям Нобах. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Се шляхи синів Ізрайлевих, що вийшли з Египецької землї з полками своїми, під приводом Мойсейовим та Ароновим. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","А Мойсей позаписував виходи їх по шляхах їх, як заповідав Господь. І се шляхи їх по виходах їх: ");
INSERT INTO ukr1871_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Рушили вони з Раємзесу в первому місяцї на пятнайцятий день первого місяця. На другий день після паски вийшли сини Ізраїля під сильною рукою, перед очима всїх Египтян. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","А Египтяне ховали первенцїв своїх, що побив Господь між ними; і звершив Господь суд над богами їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","І рушили сини Ізрайлеві від Раємзеса та й отаборились у Суккотї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","І рушили вони із Суккоту та й отаборились ув Етамі, що край степу. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","І рушили з Етаму та й повернули на Пі-Гахирот, що проти Бааль-Зефона, та й отаборились перед Микдолем. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","І рушили з Пі-Гахироту та й перебріли серединою моря в степ, та й ійшли три днї ходи у степу Етам, та й отаборились коло Мари. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","І рушили від Мари та й прийшли в Елїм; а в Елїмі знайшли дванайцять криниць і сїмдесять пальмових дерев; і отаборились там. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","І рушили з Елїма та й отаборились над Червоним морем. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","І рушили з над Червоного моря та й отаборились у Син степу. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","І рушили із Син степу та й отаборились у Дофцї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","І рушили з Дофки, та й отаборились в Алушу. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","І рушили з Алуша та й отаборились у Рефидимі; і не мали там люди води до пиття. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","І рушили з Рефидиму та й отаборились у Синай степу. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","І рушили із Синай степу та й отаборились коло Кіброт-Гаттаява. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","І рушили від Кіброт-Гаттаява та й отаборились у Газеротї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","І рушили з Газерота та й отаборились у Ритмі. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","І рушили з Ритми та й отаборились у Риммон-Перезї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","І рушили з Риммон-Переза та й отаборились у Либнї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","І рушили з Либни та отаборились у Риссї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","І рушили з Рисси та й отаборились у Кегелатї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","І рушили з Кегелата та й отаборились під Шефер горою. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","І рушили від Шефер гори та й отаборились у Гарадї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","І рушили з Гаради та й отаборились у Макелотї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","І рушили з Макелоти та й отаборились у Талатї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","І рушили з Талати та й отаборились у Таратї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","І руши ли з Тарати та й отаборились у Митцї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","І рушили з Митки та й отаборились у Гашмонї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","І рушили з Гашмона та й отаборились у Мозеротї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","І рушили з Мозерота та й отаборились у Бене-Яаканї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","І рушили з Бене-Яакана та й отаборолись у Гор-Гідгадї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","І рушили з Гор-Гідгада та й отаборились у Йотбатї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","І рушили з Йотбата та й отаборились ув Абронї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","І рушили з Аброна та й отаборились у Езйон-Гебер. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","І рушили з Езйон-Гебера та й отаборились у Зин степу, се Кадес. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","І рушили із Кадесу та й отаборились на Гор горі, на границї землї Едомської. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","І зійшов Арон сьвященник на Гор гору, по слову Господньому, та й умер там у сороковому роцї після виходу синів Ізрайлевих із Египту, у пятому місяцї, на первий день місяця. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Аронового ж віку було сто двайцять і три роки, як умер він на Гор горі. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","І почув царь Арадський, Кананїй, що жив на полуденнїй частинї в Канаан землї, перечув, що наступають синове Ізрайлеві. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","І рушили вони від Гор гори та й отаборились у Залмонї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","І рушили із Залмони та й отаборились у Пупонї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","І рушили із Пупона та й отаборились в Оботї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","І рушили з Обота та й отаборились у Ійм Абаримі, на границї Моаба. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","І рушили з Ійма та й отаборились у Дибон-Гадї. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","І рушили з Дибон-Гаду та й отаборились в Алмон Диблатаїмі. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","І рушили з Алмон-Диблатаїма та й отаборились під Абарим горами на проти Небо. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","І рушили від Абарим гір та й отаборились на степах Моабських, на Йорданї проти Єрихону. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","І отаборились на Йорданї, від Бет-Єзімотя до Абель-Ситтима на рівнинах Моаба. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","І промовив Господь на рівнинах Моабських, над Йорданом проти Єрихону кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Промов до синів Ізраїля і скажи їм: ");
INSERT INTO ukr1871_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","Як перейдете через Йордань в Канаан землю, так проганяйте всїх осадників тієї землї перед собою і руйнуйте всї тесані ідоли їх; і всї виливані балвани поруйнуйте, і всї жертівники високі спустоште, ");
INSERT INTO ukr1871_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","І запануєте над землею сією та й осядетесь там, бо вам оддав я землю сю як власність. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","І роздїлите землю по жеребу між родинами вашими; у кого душ більше, тому побільшите наслїддє, а в кого буде меньше, тому поменьшите наслїддє. Де кому випаде жереб, те буде наслїддє його. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Коли ж не повиганяєте осадників сієї землї перед собою, так останок їх буде колючками в очах у вас і терниною під боками в вас, і тїснити муть вас на землї, де живете ви. ");
INSERT INTO ukr1871_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","І станеться, що зроблю з вами те, що я задумав з ними зробити. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","І промовив Господь до Мойсея кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Повели синам Ізраїля і скажи їм: Як прийдете в Канаан землю, то се земля, що випала вам у наслїддє: Канаан земля, у гряницях своїх. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","І полудення країна буде вам від Зин степу, здовж Едома, а полудення гряниця буде вам від краю Соляного моря на схід соньця. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","І повернеться ваша гряниця на полуднє від узгіря Акробимського і перейде в Зин, а потягнеться на полуднє до Кадес-Барне, дійде до Газар Адару і перейде до Азмону; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","І повернеться гряниця ваша від Азмона до бурчака Египецького, і будуть кіньцї її проти моря. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","А західньою гряницею буде вам Велике море і побережє; се буде вам гряницею західньою. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","А се буде вам гряницею на північ: ");
INSERT INTO ukr1871_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Від Великого моря проведете її до Гор гори; від Гор гори проведете її як раз до Гамата, і буде гряничнїй виступ до Зедаду; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","І вийде гряниця до Сифрону, і виступ її буде коло Газар Енану. Се буде вам північня гряниця. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","І визначите собі всхідню гряницю від Газар Енану до Шефаму. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","І спуститься гряниця від Шефаму до Риблї на схід соньця від Аїну; і спуститься дальше гряниця та й торкнеться о беріг Кінерет озера од сходу; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","І спуститься гряниця до Йордану, і буде виступ її при морю Соляному. Така буде земля ваша у гряницях її з усїх боків. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","І повелїв Мойсей синам Ізрайлевим, кажучи: Се земля, що по жеребу достанеться вам в наслїддє, що заповідав Господь дати її десятьом поколїнням і половинї поколїння. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Бо вже дістали наслїддє своє: поколїннє синів Рубенових, по батьківських домах їх, і поколїннє синів Гадових, по батьківських домах їх, і половина поколїння Манассеієвого. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Два поколїння і половина поколїння дістали наслїддє своє на сїм боцї Йорданї, проти Єрихону, на схід соньця. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","І промовив Господь до Мойсея, кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Се ймена людей, що дїлити муть між вами землю наслїддя: Єлеазар сьвященник та Йозей Нуненко. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","І по одному князеві возьміть із кожного поколїння, щоб дїлити землю наслїддя. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","А се імена мужів: за поколїннє Юдине: Калеб Єфуненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","А за поколїннє синів Симеонових: Самуїль Аммігуденко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","А за поколїннє Беняминове: Єлїдад Кізлоненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","А за поколїннє синів Данових князь: Букій Йоглієнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Від синів Йосифових: за поколїннє синів Манассієвих князь: Ганниїль Єфоденко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","А за поколїннє синів Єфраїмових князь: Кемуїль Шифтаненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","А за поколїннє синів Зебулонових князь: Єлизафан Парнакієнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","А за поколїннє синів Іссахарових князь: Палтиїль Ассаненко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","А за поколїннє синів Ассерових князь: Ахигуд Шеломієнко; ");
INSERT INTO ukr1871_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","А за поколїннє синів Нефталїєвих князь: Педагель Аммігуденко. ");
INSERT INTO ukr1871_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Се ті, що їм Господь заповідав роздїлити наслїддє між синів Ізрайлевих в Канаан землї. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","І промовив Господь до Мойсея в рівнинах Моаба на Йорданї проти Єрихону, кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Повели синам Ізрайлевим, щоб із наслїдньої держави своєї дали міста Левітам, на оселю їм; і пасовиска кругом міст мусите ви дати Левітам. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","І будуть міста їм, щоб жити там, а пасовиска будуть про скотину їх і про майно їх, і про всю животину їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","А пасовиска кругом міст, що дасьте їх Левітам, будуть простиратись від валів міста дві тисячі локот на всї сторони. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","І відміряєте за містом на схід сонця дві тисячі локот, і на полудне дві тисячі локот, і на захід сонця дві тисячі локот, і на північ дві тисячі локот, а місто по серединї. Такими нехай будуть пасовиска кругом міст їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","А міста, що оддасьте Левітам, такі: шість міст охоронних, що їх дасьте їм, щоб можна було втїкати туди, коли хто заподїяв яке убійство; ");
INSERT INTO ukr1871_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","А крім тих дасьте їм ще сорок і два міста. Усїх міст, що оддасьте Левітам, сорок і вісїм міст з пасовисками їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Що ж до міст, котрих віддасьте Левітам із держави синів Ізрайлевих, то, в котрого поколїння багато буде, багато й візьмете, а в котрого мало буде, мало й возьмете; кожне поколїннє по тому, яке наслїддє його, давати ме міста свої Левітам. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","І рече Господь до Мойсея: ");
INSERT INTO ukr1871_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Промов до синів Ізрайлевих і скажи їм: ");
INSERT INTO ukr1871_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Як перейдете через Йордань у Канаан землю, так повибирайте собі міста: охоронними містами будуть вони вам, щоб можна було втїчи туди убийцеві, що ненароком убив людину. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","І будуть у вас міста сї прибіжещем від местника, щоб не погиб убийця перше, нїм стане на суд перед громадою. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Із тих міст, що дасьте, буде в вас шість міст охоронних. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Три міста будуть по сїм боцї Йорданї, і три міста в Канаан землї; міста охоронні будуть вони. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Про синів Ізрайлевих і про приходня, і про такого, що пробуває між вами, будуть шість міст сих прибіжищем, щоб можна втїкти туди кожному, хто ненароком забив людину. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Коли ж зелїзним знаряддєм вдарив його, так що той помер, то він душогубець; умерти мусить душогубець. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Або коли вдарив його каменюкою, котрою орудував, а від якої погибнути можна, так що той помер, то він душогубець, і мусить душогубець вмерти. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Або коли оруддєм деревяним, котрим він орудував, таким що можна кого вбити, ударив його, так що той помер, то він душогубець, і мусить душогубець вмерти. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Кровоместник сам нехай вбє душогубця; як тілько подістане його, убити мусить його. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","І коли з ненависті штовхне його, чи кине на його знарошна, так що той помре, ");
INSERT INTO ukr1871_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","Або ворогуючи вдарить його рукою, так що той помре, то мусить вмерти забияка; душогубець він; кровоместник убє душогубця, як тілько подістане його. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","А коли з ненарошна, не ворогуючи, штовхне його, або кине на його знаряддєм яким невмисне, ");
INSERT INTO ukr1871_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","Або необачки пустить на його якого каменя, від котрого можна вмерти, і коли той помре, він же не ворогував і не мислив йому зла, ");
INSERT INTO ukr1871_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Так нехай таким судом розсудить громада між тим, що вдарив, і між кровоместником; ");
INSERT INTO ukr1871_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","І вирятує громада виновника убійства з рук кровоместника, і верне громада його до міста охоронного, куди він втїк; і зістанеться він там аж до смерти великого сьвященника, що помазано його олїєю святою. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Коли ж виновник убийства та вийде за гряницю охоронного свого міста, ");
INSERT INTO ukr1871_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","І кровоместник запопаде його за границею охоронного міста його, і кровоместник вбє убийцю, то не буде на йому вини за кров. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Бо в охоронному містї свому він мусїв пробувати до смерті великого сьвященника; а по смерті великого сьвященника може убийця вернутись в землю батьківщини своєї. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","І буде се вам установою правосуддя в роди ваші по всїх оселях ваших. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Кожного, хто вбив людину: після переслуху сьвідків треба вбити душогубця; тілько один сьвідок не може доказати, щоб вбити його. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","І не приймете викупу за душу душогубця, що повинен вмерти, тілько він мусить вмерти. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","І не приймете викупу за такого, що втїк до охоронного міста, щоб можна було йому вернутись та й жити в землї перед смертю сьвященника. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","І не опоганюйте землї, що живете на їй, кров бо опоганює землю; нїчим не можна спокутувати землю за кров на їй пролиту, як тілько кровю того, хто пролив її. ");
INSERT INTO ukr1871_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Тим же то не опоганюйте землї, що на їй самі живете, та що серед неї сам я живу: я бо, Господь, живу посеред синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","І приступили батьки голови з поколїння синів Гілеада, сина Макіри, сина Манассії, з роду синів Йосифових; і промовили вони перед Мойсейом і перед князями батьківськими синів Ізрайлевих, ");
INSERT INTO ukr1871_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","І казали вони: Господь заповідав добродїєві мому пороздавати землю синам Ізраїля в наслїддє по жеребу; і заповідано від Господа добродїєві мому, передати наслїддє Зелофхада, брата нашого, дочкам його. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Коли ж пійдуть вони заміж за кого небудь із синів других поколїнь Ізраїля, так наслїддє їх віднїметься від наслїддя батьківського нашого і прилучиться до наслїддя того поколїння, що до його вони пристануть; сим робом віднїметься воно від наслїддя нашого паю. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Та й як настане ювілейний рік у синів Ізрайлевих, то знов прилучиться наслїддє їх до наслїддя того поколїння, до котрого вони пристали; сим робом віднїметься наслїддє їх від наслїддя поколїння батьків наших. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","І дав Мойсей повелїннє синам Ізрайлевим, по слову Господньому, таке: Правду каже поколїннє синів Йосифових. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Се слово, що заповідав Господь про дочок Зелофхадових словами: Нехай виходять вони замуж за того, хто їм до вподоби; но мусять вони вийти за одного з роду поколїння батька свого, ");
INSERT INTO ukr1871_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Щоб не переходило наслїддє синів Ізраїля від поколїння до поколїння; бо кожен із синів Ізраїля держатись мусить при наслїддї свого батьківського поколїння. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","І всяка дочка, в котрої єсть наслїддє з поколїння синів Ізраїля, мусить бути жінкою кому небудь із роду свого батьківського поколїння; щоб кожен зміж синів Ізраїля держав батьківське наслїддє своє, ");
INSERT INTO ukr1871_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Та щоб не переходило наслїддє від одного поколїння до другого. Бо кожне поколїннє синів Ізрайлевих мусить держатись свого наслїддя. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Як заповідав Господь Мойсейові, так і вчинили дочки Зелофхадові. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","І стали жінками синам дядків своїх Махля, Тирза, Хогля, Милка і Ноя, дочки Зелофхадові. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Повіддавались вони за чоловіків з родин синів Манассеії, сина Йосифового. І так зосталось наслїддє їх при поколїнї батьківського роду їх. ");
INSERT INTO ukr1871_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Се заповідї і присуди, що заповідав Господь, через Мойсея синам Ізраїля на Моабових рівнинах над Йорданом, проти Єрихону.");
INSERT INTO ukr1871_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Се слова, що промовляв Мойсей до всього Ізраїля по сїм боцї Йорданї, в степу, на поділлї, проти Червоного моря, між Параном і Тофельом і Лабаном і Газеротом і Ди-Сагабом. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Одинайцять день ходи від Гореба, по дорозї від Сеїр-гори до Кадес-Барнеї. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","І сталося в сороковому роцї, в одинайцятому місяцї, на первий день місяця, що промовляв Мойсей до синів Ізраїля усе, що Господь заповідав йому про них. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Після того, як він побив Сигона, царя Аморійського, та Ога, царя Базанського, що жив в Астаротї і в Єдреї. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","По тїм боцї Йорданї, в Моаб землї, почав Мойсей викладати закон сей, говорючи: ");
INSERT INTO ukr1871_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Господь, Бог наш, промовив до нас на Горебі так: ");
INSERT INTO ukr1871_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Доволї побули ви під сією горою: Обернїтесь і рушайте та й ідїть до гори Аморіїв і до всїх сусїдів їх на поділлї, по горах і по долинах і на полуднї і на березї моря, в Канаан землю і до Либану, аж до великої ріки, до ріки Евфрата. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Дивітесь, надїлив я вам сю землю; ідїть і займіть землю, що про неї клявсь Господь батькам вашим, Авраамові, Ізаакові і Яковові, що оддасть їм і насїнню їх по них. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","І того часу промовив я до вас так: Не здолїю один вести вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Господь, Бог ваш, намножив вас, і нинї ви лїчбою як зорі небесні стали. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Господь, Бог ваш, нехай прибавить до вас тисячу разів стілько, скілько вас тепер є, і нехай благословить вас, як говорив про вас! ");
INSERT INTO ukr1871_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Як би міг я один нести тягарі ваші і журбу вашу і сварки ваші? ");
INSERT INTO ukr1871_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Возьміть собі людей мудрих, і що знаєте їх, по ваших поколїннях, щоб я поставив їх головами над вами. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","І відказали ви менї кажучи: Добре так буде, як ти вчинити кажеш. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","І взяв я голови з поколїнь ваших, людей мудрих і знаточних, і поставив їх головами над вами, тисячниками і сотниками і пятьдесятниками і десятниками, і правителями поколїнь ваших. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","І заповідав я суддям вашим того часу так: Вислуховуйте змагання між братами вашими і судїте праведно між чоловіком і братом його, і між ним і приходнем, що в його. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Не вважати мете на лиця судячи; як малого, так і великого вислуховуйте, нї перед ким не бійтесь, бо суд Божий. А котра справа за важка для вас, передавайте до мене, щоб я вислухав її. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","І заповідав я вам того часу все, що чинити маєте. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","І рушили ми від Гореба та й пійшли, як заповідав нам Господь, Бог наш, усїм оцїм великим і страшним степом, що вбачали ви, та й прийшли в Кадес-Барне. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","І промовив я до вас: Дойшли ви до гір Аморіїв, що дав нам їх Господь, Бог наш. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Глань, Господь, Бог твій, надїлив тобі сю землю; ійди, займи її, як казав тобі Господь, Бог батьків твоїх; не бійсь і не падай духом! ");
INSERT INTO ukr1871_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Но всї ви приступили до мене і мовляли: Пошлемо поперед людей, щоб розгледїли нам сю землю та й дали знати, якою дорогою нам підійматись, і на які городи йти нам. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","І добре було по моїй думцї се дїло; і взяв я зміж вас дванайцять чоловіка, по чоловікові з поколїння. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","І рушили вони і знялись на гори, та й дійшли до Єколь-долини, та й розгледїли землю. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","І набравши плодів землї, спустились вони до нас. І принесли нам вістку кажучи: Добра земля, що дає нам Господь, Бог наш. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Та не хотїли ви ійти і противились слову Господа, Бога вашого. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","І стали ви бурмотїти по наметах ваших, мовляючи: Зненавидїв нас Господь і вивів нас із Египецької землї, щоб нас віддати в руки Аморіям та й вигубити нас. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Куди нам ійти? Браттє наше взяло нам одвагу сказавши: Люд більший і рослїйший від нас, міста великі і утверджені під небо, і навіть синів Енакових ми там бачили! ");
INSERT INTO ukr1871_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Тодї промовив я до вас: Не лякайтесь і не бійтесь їх! ");
INSERT INTO ukr1871_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Господь, Бог ваш, що йде поперед вами, він воювати ме за вас, як се вчинив в Египецькій землї перед очима вашими. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","І в степу, де бачив єси, що Господь, Бог твій, нїс тебе, як чоловік носить сина свого, по всїй дорозї, що нею йшли ви, поки дійшли до місця сього. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Та не вірували ви Господеві, Богу вашому, ");
INSERT INTO ukr1871_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Що йшов поперед вами в дорозї, щоб вишукати вам місце, де можна вам отаборитись; поночі в поломї, щоб бачити вам дорогу, що нею йшли ви, а за дня у хмарі. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","І почув Господь голос ваших розмов, і запалав гнївом, і поклявся словами: ");
INSERT INTO ukr1871_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Не бачити ме нїхто з сїх людей, із сього злого кодла тієї доброї землї, що я клявся дати батькам вашим, ");
INSERT INTO ukr1871_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Окрім Калеба Єфуненка! Він бачити ме її, і дам йому і синам його землю, по котрій ступав, він бо зовсїм йшов слїдом за Господом. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","І на мене теж розгнївивсь Господь кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","І ти не прийдеш туди! Йозей Нуненко, що стоїть перед тобою, він прийде туди; утверди його, він бо має віддати її в наслїддє Ізрайлеві. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","А дїточки ваші, що про них ви казали: на здобич будуть вони, і сини ваші, що тепер не розберуть ще добра від зла, вони прийдуть туди, і їм дам її, і вони запанують над нею. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Ви ж повернїтесь і рушайте в степ, в дорогу Червоного моря! ");
INSERT INTO ukr1871_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","І відказали ви й промовили до мене: Согрішили ми перед Господом; пійдемо в гори і бити мемось, як заповідав Господь, Бог наш. І підперезавши кожен з вас зброю свою, пустились ви в гори, не обдумавши. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","І рече менї Господь: Промов до них: Не йдїть і не бийтесь, бо не буде мене серед вас; щоб не побили вас вороги ваші! ");
INSERT INTO ukr1871_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","І промовив я до вас, та ви не послухали; і спротивились ви слову Господньому, і як очайдухи пустились в гори. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","І вийшли проти вас Аморії, що жили на горах тих, та й гнались за вами ройом, і розпорошили вас від Сеїру до Горми. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Вернувшись ви стали плакати перед Господом; та не слухав Господь голосу вашого і не вважав на вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","І пробували ви в Кадесї довго, лїчивши днї, скільки ви були там. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Потім повернули ми та й рушили дальше степом до Червоного моря, як велїв менї Господь, і довго ми обминали Сеїр-гори. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","І промовив до мене Господь: ");
INSERT INTO ukr1871_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Досить довго ви обходили сї гори, повернїте на північ. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","А людові повели, кажучи: Будете тепер переходити через займища братів ваших, синів Єзавових, що живуть на Сеїр-горах, і будуть вони боятись перед вами; тому стережіться. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Не зачинайти войни з ними: бо не дам вам нї ступня землї їх; бо Сеїр-гори віддав я Езавові в державу. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Харчі купуйте в них за гроші, щоб було що їсти вам, навіть і воду копувати мусите в них за гроші, щоб було що пити вам. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Бо Господь, Бог твій, благословив тебе в усякому дїлї руки твоєї. Знав він дороги твої по великому степу сьому: сї сорок років був Господь, Бог твій, з тобою; нічого не бракувало в тебе. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","І йшли ми дальше від братів наших, синів Езавових, що живуть на Сеїр-горах, від дороги на поділлю, від Елата і від Езйон-Гебер; і повернули ми та й пійшли дорогою у степи Моаба. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","І промовив до мене Господь: Не турбуй Моаба і не починай з ними війни, бо не дам тобі нїчого із землї його в державу; бо віддав я Ар синам Лотовим у державу. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Перше жили у сїй землї Еміми, люд великий по лїчбі і ростом високий як Енакими. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","За велетнїв вважали їх, як і Енакимів; а Моабії звуть їх Емимами. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","А на Сеїр-горах жили перше Горії, та упокорили їх сини Езавові і знищили їх перед собою, та й поселились на займищах їх, зробивши так, як зробив Ізраїль в землї держави своєї, що дав йому Господь. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Тепер вставайте і перебирайтесь через Серед-ріку. І перебріли ми Серед-ріку. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","А часу того, що йшли ми від Кадес-Барне, покіль перебріли Серед-ріку, минуло трийцять і вісїм років, аж поки ізник увесь рід боївників із табору, як поклявсь їм Господь. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Сама рука Господня була проти них, щоб вигубити їх із табору, аж їх не стало. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","І сталось, як всї спосібні до війни люде повимірали з між народу, ");
INSERT INTO ukr1871_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Тодї промовив Господь до мене так: ");
INSERT INTO ukr1871_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Перейдеш тепер через гряницї Моаба, мимо Ара. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","І приближишся проти синів Амона; не тїсни їх і не починай війни з ними, бо не дам тобі держави з землї синів Амонових; бо синам Лотовим я оддав її в державу. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Вважали ж і її землею велетнїв; перше жили там велетнї, і Амонії звали їх Самзумимами. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Люд той був великий лїчбою, і ростом високий як Енакії; і вигубив їх Господь перед ними, і прогнали вони їх, та осїлись на їх місцї, ");
INSERT INTO ukr1871_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Так як вчинив синам Езавовим, що жиють на Сеїр-горах, перед котрими він вигубив Горіїв; і прогнали вони їх і живуть на займищі їх й досї. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","А Авимів, що жили селами до Гази, вигубили Кафторими, що, вийшовши з Кафтора, осїлись на займищах їх. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Вставайте, рушайте в дорогу і переходьте Арнон-ріку. Глянь, оддав я тобі в руки Сигона, царя з Гезбона, Аморія, і землею його; починай, бери в державу, і бий на його! ");
INSERT INTO ukr1871_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","З того дня почну наводити ляк і пострах перед тобою на всї народи під небесами, що перечують поголоску про тебе і дрожати і тремтїти муть перед тобою. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","І послав я посли з Кадемот-степу до Сигона, царя Гезбонського, з мирними словами, кажучи: ");
INSERT INTO ukr1871_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Дозволь перейти менї через землю твою! Буду йти тілько по дорозї, не звертати му нї на право, нї на лїво. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Харчі за гроші давати меш менї, щоб було нам що їсти, і воду за гроші давати меш менї, щоб було нам що пити. Тілько ногами перейду, ");
INSERT INTO ukr1871_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Як се вчинили менї сини Езавові, що живуть на Сеїр-горах, і Моабії, що живуть в Арі, покіль перейду через Йордань у землю, що Господь, Бог наш, дає нам. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Та затявся Сигон, царь Гезбонський, і не дозволив нам перейти через землю свою; бо Господь, Бог твій, зробив духа його запеклим а серце його камінним, щоб віддати його в руки тобі, як се й сталось. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","І промовив Господь до мене: Дивись, я почав оддавати тобі Сигона і землю його; починай займати, щоб земля його була твоя. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","І виступив Сигон проти нас, сам він і ввесь люд його до бою, під Язазом. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Та опустив його перед нами Господь, Бог наш, і ми побили його й синів його і ввесь люд його. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","І того часу підневолили ми всї городи його, та й обрекли всїх людей: мужчин і жіноцтво і дїтей; не дали нїкому втїкти. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Взяли про себе тільки скотину як здобиччу і луп по городах, що їх попідневолювали. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Від Ароеру, що по берегах ріки Арнона, та від міста, що по долинї коло ріки розкинулось, аж до Гілеаду не було міста, щоб його не подужали; все передав нам Господь, Бог наш. ");
INSERT INTO ukr1871_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Тільки до землї синів Амонових ти не приступав, нї до всього побережжя Ябока, нї до городів у горах, нї до всього, що заповідав Господь, Бог наш, не чіпати. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","І повернули ми та й стали братись у гору по дорозї Базанській, і виступив проти нас Ог, царь Базанський, сам з усїм людом своїм до бою при Едреї. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","І промовив до мене Господь: Не лякайсь його! Бо я віддаю його в руки тобі і ввесь люд його й землю його; і вчиниш з ним те, що вчинив єси з Сигоном, царем Аморійським, що жив у Гезбонї. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","І віддав Господь, Бог наш, в руки наші так само й Ога, царя Базанського, і ввесь люд його, і побивали ми його, докіль нїхто з них не зістався. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","І того часу попідневолювали ми всї міста його; не було міста, щоб ми не заняли його; шістьдесять міст, вся полоса Аргоб, царство Огове в Базанї. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Всї міста сї були укріплені високими мурами, брамами й засувами; окрім того багацько міст неукріплених. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","І обрекли ми їх, як зробили з Сигоном, царем Гезбонським, обрікши по всїх містах мужчин і жіноцтво і малолїтків. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","А всю скотину і всю здобиччу по містах їх ми забрали про себе. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","І взяли ми того часу із рук обох царів Аморійських землю, що по сїм боцї Йорданї, від Арнон-ріки до Гермон-гори. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Зидонїї звуть Гермона Сирйон, Аморії ж звуть його Сенір. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Всї міста подільські й увесь Гілеад і ввесь Базан, до Салки та до Едреї, міста в царстві Ога в Базанї. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Бо тільки Ог, царь Базанський, зоставсь з останнїх велетнїв. Ось, ложе його, желїзне ложе, не воно хиба в Рабатї, у синів Амона? Девять локот воно завдовжки і чотирі ліктї завширшки, по ліктях людських. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","І землю сю заняли ми того ж часу. Від Ароеру, що над Арнон-рікою, і половину гір Гілеад і міста їх віддав я Рубенїям та Гадїям; ");
INSERT INTO ukr1871_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","А що осталось з Гілеаду і ввесь Базан, царство Огове, віддав я половинї поколїнню Манассії. Вся полоса Аргоб і ввесь Базан, се називається земля велетнїв. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Яір Манассієнко взяв усю полосу Аргоб до границї Гезуріїв і Маакатіїв, і назвав землю Базан, по свому прізвищу, села Яірові, по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","А Макірові дав я Гілеад. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","А Рубенїам та Гадїям дав я землю від Гілеаду до Арнон ріки; до половини ріки і помежної країни, і до Ябока ріки, гряницї синів Амона; ");
INSERT INTO ukr1871_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","І рівнину і Йордань і побережню країну, від Кінерета і до моря подільського, до моря Соляного, під узгірями Пізги гори од сходу соньця. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","І заповідав я вам того часу мовляючи: Господь, Бог ваш, дав вам сю землю в державу. Збройно й оружно мусите ви, всї удалї люде, ійти поперід браття вашого, синів Ізрайлевих. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Тільки жінки ваші і малеча ваша і скотина ваша — знаю я, що в вас багацько скотини — позостаються в городах ваших, що дав я вам, ");
INSERT INTO ukr1871_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Аж дасть Господь, Бог ваш, спокій браттю вашому, як вам, та й мати муть і вони землю, що дає їм Господь, Бог ваш, по другім боцї Йорданї; тодї можна вернутись кожному з вас у державу свою, що я вам дав. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","А Йозейові заповідав я того часу мовляючи: Очі твої бачили все, що Господь, Бог ваш, учинив з обома сими царями; так учинить Господь з усїма царствами, куди ви прийдете. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Не лякайтесь їх! Господь, Бог ваш, він воює за вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","І благав я того часу Господа, словами: ");
INSERT INTO ukr1871_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Господе, Боже! почав єси показувати слузї твому славу твою і твою руку потужну; бо де Бог, той на небесах і на землї, що здолїв би вчинити дїла, подобні твоїм творивам і подобні твоїй потузї? ");
INSERT INTO ukr1871_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Дозволь же менї перейти, та побачити сю гарну землю, що по другім боцї Йорданї, сї гарні узгіря Либанон гори. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Та досадував на мене Господь за вас, і не став слухати мене. І рече до мене Господь: Буде з тебе. Не кажи менї більш про се. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Ізійди на верх Пізги і знїми очі твої на захід і на північ і на полудне і на схід сонця, і подивись своїми очима, бо не перейдеш ти сієї Йорданї. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Но заповідай Йозейові і покріпи його і утверди його; бо він мусить перейти поперед люду сього, і він оддасть їм у наслїддє землю, що побачиш її. ");
INSERT INTO ukr1871_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","І пробували ми в долинї проти Бет-Пеора. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Послухай же тепер, Ізраїлю, про установи і суди, що навчаю вас сповняти їх, щоб ви жили й прийшовши одержали землю, що надїлив вам Господь, Бог батьків ваших. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Не прибавите ви до слова, що я заповідаю вам, і не вбавите нїчого, пильнуючи заповідей Господа, Бога вашого, що їх заповідаю вам. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Очі ваші бачили, що вдїяв Господь з Бааль Пеором; всї бо, хто ходив слїдом за Бааль-Пеором, вигубив їх Господь, Бог твій, з між вас; ");
INSERT INTO ukr1871_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Ви ж, которі держались Господа, Бога вашого, ви всї живі по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Гледи, навчив я вас установ і присудів, як заповідав менї Господь, Бог мій, щоб ви сповняли їх серед землї, що до неї прийдете, щоб заняти її. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Пильнуйте ж і сповняйте їх! Бо се мудрість і розум ваш перед очима народів, що чути муть всї встанови сї й казати муть: Сей великий нарід справдї мудрий і розумний нарід. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Де бо на сьвітї такий великий нарід, в котрого так близький Бог, як Господь, Бог наш, у всьому, про що тільки кличемо до його? ");
INSERT INTO ukr1871_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","І який се великий нарід, що в його установи і присуди такі справедливі, як увесь закон сей, що я поставив вам оце? ");
INSERT INTO ukr1871_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Тільки стережись і пильнуй душі своєї, щоб не забути дїла сї, що бачили очі твої, і щоб не відлучились вони від серця твого по всї днї життя твого! Нї! Переказуй про них синам твоїм і синам синів твоїх, ");
INSERT INTO ukr1871_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Про той день, як стояв єси перед Господом, Богом твоїм, під Горебом, як Господь промовляв до мене: Збери менї люд сей, щоб я дав їм почути слова мої, з котрих навчаться боятись мене по всї днї життя свого на землї, і навчать синів своїх. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","І приступили ви та й поставали попід горою; а гора палала поломєм аж під саме небо і стала темрява, хмари і тьма. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","І промовив до вас Господь із поломя; ви чули голос слів його, та нїякої постатї не бачили окрім голосу. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","І обявив він вам свій завіт, що велїв вам чинити, десять слів; і написав їх на двох камяних таблицях. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","А менї заповідав Господь того часу навчати вас установ і присудів, щоб ви сповняли їх на землї, що до неї прийдете, щоб дістати її в державу. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Пильнуйте ж добре душ ваших, бо не бачили ви нїякої постатї в день той, як із поломя промовляв до вас Господь на Гореб горі, ");
INSERT INTO ukr1871_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Щоб ви не зледащіли та не почали робити собі тесані постатї, подобу якої постатї, постать жіночу, або чоловічу, ");
INSERT INTO ukr1871_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","Постать якої скотини, що на землї гасає, образ якої крилатої птахи, що попід небесами лїтає, ");
INSERT INTO ukr1871_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","Образ якої небудь животини, що по землї лазить, образ якої риби, що у водї під землею; ");
INSERT INTO ukr1871_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Щоб, знявши очі до неба та бачивши соньце й місяця і зорі, все військо небесне, не скортїло тебе, припасти на колїна перед ними та служити їм, котрих Господь, Бог твій, призначив на послугу всїм народам під цїлим небом. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","А вас узяв Господь, і вивів із желїзного горнила, із Египту, щоб ви були людом його наслїддя, як і сталось. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Но Господь розгнївався на мене через вас, і поклявся, що не перейду через Йордань і що не прийду в землю гарну, що оддав тобі в наслїддє Господь, Бог твій; ");
INSERT INTO ukr1871_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","А вмру в ʼцїй землї, і не доведеться менї перейти через Йордань; а ви перейдете і одержите сю гарну землю. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Остерегайтесь, щоб не забути про завіт Господнїй, що його вчинив із вами, та щоб ви не робили собі витесану постать, подобу чого небудь, що заборонив Господь, Бог ваш. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Бо Господь, Бог ваш, се поломя жеруще, Бог ревнивий! ");
INSERT INTO ukr1871_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Як же появиш синів та внук і як поживете у сїй землї, і зледащієте та й зробите витесану постать, подобу чого небудь, і робити мете що ледаче перед очима Господа, Бога вашого, роздражнюючи його: ");
INSERT INTO ukr1871_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","То я кличу нинї небеса й землю за сьвідків проти вас, що ви певно і скоро пропадете із землї, куди ви йдете через Йордань, щоб заняти її; не довго поживете ви в нїй, а будете зовсїм знищені. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","І розсїє вас Господь між иншими народами і зостанетесь лїчбою малими між народами, між котрих приведе вас Господь; ");
INSERT INTO ukr1871_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","І служити мете там богам, твориву рук людських, дереву та каменю, що не бачать і не чують і не їдять і не нюхають. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Но ви шукати мете Господа, Бога вашого; і ти знайдеш його, як шукати меш його всїм серцем твоїм і всією душею твоєю. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","В тїснотї твоїй, і як все те постигне тебе при кіньцї днїв, ти навернешся до Господа, Бога твого, і послухаєш голосу його. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Бо Господь, Бог твій, милостивий Бог; він не покине тебе і не скарає тебе, і не забуде про завіт батьків твоїх, що про його клявся перед ними. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Бо поспитай тільки про давні часи, що були перше тебе, з того дня, як сотворив Бог чоловіка на землї, та й від одного краю небес та й до другого краю небес, чи коли сталось таке велике дїло, або чи хто чував що подібне? ");
INSERT INTO ukr1871_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Чи чував який нарід голос Божий, що промовляв з поломя, як ти чув, та й щоб він зістався живим? ");
INSERT INTO ukr1871_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Або чи пробував Бог, прийти, щоб взяти собі нарід зміж иншого народу, карами, ознаками і чудесами, війною і потужною рукою і просьтягнутою правицею, і великим страхом, так як вчинив для вас Господь, Бог ваш, перед очима вашими в Египтї? ");
INSERT INTO ukr1871_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Тобі воно було показане, щоб ти знав, що Господь, се Бог; нїхто ж більше крім його. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Із небес дав він тобі почути свій голос про науку тобі, і на землї дав видїти тобі своє велике поломя, а з поломя чув ти слова його. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","І за те, що він любив батьків твоїх і по них вибрав насїннє їх, вивів тебе він самолично, великою потугою своєю з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Щоб вигубити перед тобою народи, що більші й потужніщі за тебе, привести тебе і дати тобі землю їх у наслїддє, як і тепер сталось. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","То ж пізнай тепер і возьми собі до серця, що Господь Бог той на небесах у горі і на землї внизу, а другого нема. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","І пильнуй установ його й заповідїв його, що заповідую їх тобі сьогоднї, щоб добре було тобі й синам твоїм, щоб довгий був вік твій у сїй землї, що навіки віддав тобі Господь, Бог твій. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Тодї віддїлив Мойсей три міста по сїм боцї Йорданї, що на схід соньця, ");
INSERT INTO ukr1871_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Щоб втїкав туди убийця, що ненароком вбив ближнього свого а перше не ворогував на його; щоб він втїк в одно із сих міст та й живим зістався. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Безер у степу, на поділлї, для Рубенїїв, і Рамот у Гілеадї для Гадїїв, і Голян у Базанї для Манассіїв. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","А се закон, що поставив його Мойсей перед синами Ізраїля; ");
INSERT INTO ukr1871_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Се сьвідчення й установи і присуди, що промовляв Мойсей до синів Ізрайлевих по виходї їх з Египту, ");
INSERT INTO ukr1871_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","По сїм боцї Йорданї, в долинї, проти Бет-Пеору, в землї Сигона, царя Аморійського, що жив у Гезбонї, котрого побили Мойсей та сини Ізрайлеві, як вийшли з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","І заняли вони землю його і землю Ога, царя Базанського, двох царів Аморійських, що були по сїм боцї Йорданї, на схід соньця, ");
INSERT INTO ukr1871_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Від Ароеру, що над Арнон-рікою, до Сійон гори, се б то Гермон, ");
INSERT INTO ukr1871_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","І все поділлє по сїм боцї Йорданї на схід соньця, аж до подільського моря, під узгірями Пізги. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","І скликав Мойсей всього Ізраїля і промовив до них: Слухай, Ізраїлю, установи і присуди, що про них промовляю сьогоднї в слухи ваші; навчітесь їх і держіть і сповняйте їх. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Господь, Бог наш, зробив завіт з нами на Гореб горі. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Не з батьками нашими Господь зробив завіт, а з нами, з нами, що тепер тут ще живі остались. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Лицем до лиця промовляв Господь до вас на горі із середини поломя. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Я стояв того часу між Господом і вами, щоб обявити вам мову Господню; ви бо боялись поломя і не виходили на гору; і рече: ");
INSERT INTO ukr1871_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Я Господь, Бог твій, що вивів тебе з Египту, з дому неволї. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Нехай не буде в тебе инших богів перед лицем моїм. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Не робити меш собі тесаної постатї, якої подоби того, що на небесах у горі й на землї в низу, і що в водах нижче землї. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Не будеш бити поклони перед ними, і служити їм, я бо Господь, Бог твій, Бог ревнивий, що карає гріхи батьків на дїтях їх, ба на третьому і на четвертому родї тих, що ненавидять мене; ");
INSERT INTO ukr1871_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","І являє ласку тисячам тих, що люблять мене і заповідї мої сповняють. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Не будеш промовляв марно імя Господа Бога твого; бо не буде безвинен у Господа той, хто промовляє марно імя його. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Держи день соботу сьвято, як заповідав тобі Господь, Бог твій. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Шість день можна тобі робити і всяке дїло твоє творити, ");
INSERT INTO ukr1871_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","День же семий собота Господеві, Богу твому. Не робити меш нїякого дїла, ти сам, нї син твій, нї дочка твоя, нї раб твій, нї рабиня твоя, нї віл твій, нї осел твій, анї всяка скотина твоя, нї приходень твій, що у воротях в тебе; щоб можна спочити рабові твому і рабинї твоїй, так як тобі. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","І памятай, що ти був рабом в Египецькій землї, і що вивів тебе звіттіля Господь, Бог твій, рукою потужною і правицею просьтягнутою: тим Господь і заповідав тобі допильновувати день субітнїй. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Шануй батька твого й матїр твою, щоб довго тобі жити на землї, що дав тобі Господь, Бог твій. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Не вбивай. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Не чинь перелюбу. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Не кради. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","І не сьвідчи льживо проти ближнього твого. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","І не забагай жінки ближнього твого; і нехай не кортить тебе мати домівку ближнього твого, поле його і раба його й рабиню його, вола його й осла його і всього, що єсть у ближнього твого. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Сї слова промовив Господь до усієї громади вашої, із серед поломя, із хмари і темряви, сильним голосом, і нїчого не прибавив. І написав їх на двох камяних таблицях і дав їх менї. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","І як почули ви голос із темряви і побачили, що гора в поломї палає, то приступили до мене всї голови поколїнь ваших і мужі громадські ваші, та й промовили до мене: ");
INSERT INTO ukr1871_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Се показав нам Господь, Бог наш, велич і славу свою і дав нам почути свій голос із поломя. Нинї бачили ми, що Бог говорить до чоловіка, і що чоловік живим зостається. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Про що ж тепер вмирати нам? Та ж пожере нас оце величезне поломя. Коли нам довше доведеться слухати голос Господа, Бога нашого, так помремо. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Хто ж бо, мавши тїло, чув голос Божий, що говорить із поломя, як ми тепер чули, та й живим зістався? ");
INSERT INTO ukr1871_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Приступи ти і вислухай все, що Господь, Бог наш, казати буде; а ти перекажеш нам усе, що промовить до тебе Господь, Бог наш, і вислухаємо тебе й будемо сповняти. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","І почув Господь голос слів ваших, як ви промовляли до мене, і рече: Чув я голос слів народу сього, що промовляли до тебе: Усе добре, що вони казали. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Нехай би тільки було в їх таке серце, щоб вони боялись мене і держали заповідї мої по всї днї, щоб добре було їм і синам їх во віки. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Ійди промов до них: Вернїтесь у намети свої. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Сам же ти стій ту, коло мене, і казати му тобі про всї заповідї і встанови й присуди, що мусиш навчити їх, щоб вони сповняли їх на землї, що даю в державу їм. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Оце ж пильнуйте, щоб ви сповняли їх, як заповідав вам Господь, Бог ваш; не відступайте нї праворуч нї лїворуч. ");
INSERT INTO ukr1871_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Мусите ви ходити тією самою дорогою, що заповідав вам Господь, Бог ваш, щоб зістались між живими і щоб добре вам було на сьвітї, та щоб довго жили ви у землї, що будете мати її. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","І се заповідї, встанови й присуди, що Господь, Бог ваш, заповідав навчити вас, щоб ви сповняли їх у землї, куди йдете, щоб заняти її; ");
INSERT INTO ukr1871_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Щоб ти боявся Господа, Бога твого, по всї днї живота твого, додержував усї встанови й заповідї його, що заповідаю тобі, ти сам і сини твої і внуки твої, щоб довго жити вам на сьвітї. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Слухай же, Ізраїлю, і пильнуй, сповняючи їх, щоб добре тобі було на сьвітї, та щоб вельми ви розмножились у землї, що тече молоком та медом, як тобі заповідав Господь, Бог батьків твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Слухай, Ізраїлю: Господь, Бог наш, єдиний Господь! ");
INSERT INTO ukr1871_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","І мусиш любити Господа, Бога твого, всїм серцем твоїм і всією душею твоєю і всією силою твоєю. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","І слова сї, що я заповідаю тобі сьогоднї, мусять бути в серцї твому. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","І будеш ти наказувати про їх синам твоїм і промовляти до серця їх, седючи в домівцї твоїй, і йдучи в дорозї і лягаючи і встаючи. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","І привязувати меш їх на руку собі, і будуть вони начільником між очима в тебе; ");
INSERT INTO ukr1871_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","І написувати меш їх на одвірках домівки твоєї і на брамах твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","І як приведе тебе Господь, Бог твій, у землю, що про неї клявся батькам твоїм, Авраамові, Ізаакові й Яковові, що дасть тобі: великі й гарні міста, що ти не будував їх, ");
INSERT INTO ukr1871_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","І доми, повні всякого добра, що не ти ним сповняв їх, і повитїсувані з каменя колодязї, що ти не тесав їх, виноградники й сади, що ти не насаджував їх, і будеш ти до сита живитись: ");
INSERT INTO ukr1871_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","То остерегайся, щоб не забув про Господа, що вивів тебе з Египту, із дому неволї. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Господа, Бога твого, будеш боятись і йому служити, і його імям будеш клястись. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Не будете ви ходити за иншими богами, за богами народів, що навкруги вас; ");
INSERT INTO ukr1871_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Бо Господь, Бог ваш, серед вас, ревнивий Бог: щоб не запалав на тебе гнївом Господь, Бог твій, і не вигубив тебе з лиця землї сієї. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Не спокушуйте Господа, Бога вашого, як спокушували його коло Масси. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Мусите пильно сповняти заповідї Господа, Бога вашого, і сьвідчення його й установи його, що заповідав тобі, ");
INSERT INTO ukr1871_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","І будеш чинити по правдї перед очима в Господа, щоб було тобі добре на сьвітї, та щоб ти увійшов та й заняв плодовиту землю, що про неї клявся Господь батькам твоїм, ");
INSERT INTO ukr1871_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Проганяючи перед тобою всїх ворогів твоїх, так як промовив Господь. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Як же колись поспитає в тебе син твій: Що воно сї сьвідчення і встанови й присуди, що Господь, Бог ваш, заповідав вам? ");
INSERT INTO ukr1871_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","То казати меш синові твому: Невільниками були ми у Фараона в Египтї, та вивів нас Господь із Египту потужною рукою. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","І явив Господь великі й погибельні знаки й чудеса над Египтом і Фараоном і над усїм домом його перед очима нашими; ");
INSERT INTO ukr1871_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","А нас випровадив звідтам, щоб нас привести сюди, і дати нам у наслїддє землю, що про неї клявся батькам нашим. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","І заповів нам Господь сповняти всї цї встанови, щоб ми боялись Господа, Бога нашого, нам на добро по всякий час, щоб нас держав при життю, як воно й тепер єсть. ");
INSERT INTO ukr1871_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","І буде се праведність наша, як сповняти мемо всї цї заповідї перед Господом, Богом нашим, так як він заповідав. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Як приведе тебе Господь, Бог твій, у землю, що йдеш заняти її, так перед тебою виганяти ме Господь многі народи: Гетіїв і Гиргазіїв і Аморіїв і Канааніїв і Перезіїв і Геветіїв і Євузіїв, сїм народів лїчбою більших і потужніщих за тебе, ");
INSERT INTO ukr1871_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","І як віддасть їх тобі Господь, Бог твій, на поталу, так мусиш їх обречи; не чинити меш з ними умови і не мати меш милосердя над ними. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","І не будеш своячитись з ними: не даси дочку твою за сина його, а дочки його не брати меш за сина свого; ");
INSERT INTO ukr1871_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Бо вони відхилять синів твоїх від мене, щоб вони иншим богам служили; і запалав би гнїв Господень на вас, і швидко вигубив би він тебе. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Та ось що маєте чинити з ними: жертівники їх зруйнуєте, стовпи їх поломите, сьвяті гаї їх зрубаєте а тесані постатї їх огнем спалите. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Бо ти нарід сьвятий у Господа, Бога твого; тебе вибрав Господь, Бог твій, щоб ти був народом наслїддя зміж усїх народів, що на землї. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Не за те прихилився до вас Господь і вибрав вас, що була велика лїчба вас, бо ви були найменьшим із усїх народів, ");
INSERT INTO ukr1871_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","А через те вивів вас Господь рукою потужною й визволив вас із дому неволї, із рук Фараона, царя Египецького, що вас любив і справдив клятьбу, якою клявся батькам вашим. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Знай же, що Господь, Бог твій, єсть Бог, вірний Бог, що додержує по тисячні роди завіт і ласку для тих, що люблять його і додержують заповідї його, ");
INSERT INTO ukr1871_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","А тим, що ненавидять його, відплатить перед лицем їх на погибіль їм: не надумується він про ненавидника свого; перед лицем його відплатить йому. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Оце ж пильнуй заповідей і встанов і присудів, що заповідаю сьогоднї тобі, щоб сповняв їх. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","І станеться: коли будете слухати присуди сї і додержувати їх, додержить тобі Господь завіт і ласку, якою клявся батькам твоїм; ");
INSERT INTO ukr1871_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","І любити і благословити ме тебе, і намножить тебе: він благословити ме плід лона твого і плід землї твоєї, зерно твоє і вино твоє і олїю твою і те, що вродить корова твоя, і приріст овець твоїх, у землї, що дати її тобі клявся батькам твоїм. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Будеш благословен перед усїма народами; не буде неплідного чи неплідної нї в тебе, нї в скотини твоєї. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","І відхилить Господь усяку недугу від тебе; і не допустить він жадної лихої зарази Египецької, що знаєш їх, а нашле її на всїх ненавидників твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","І звоюєш усїх народів, що Господь, Бог твій, оддасть тобі. Очи твої нехай не милують їх, і не служити меш богам їх; бо се було б сїткою для тебе. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Коли ти скажеш в серцю своїм: Сї народи лїчбою більші за мене; як же менї вигубити їх? ");
INSERT INTO ukr1871_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Не бійся їх! Спогадай тільки, що зробив Господь, Бог твій, з Фараоном і з усїма Египтянами. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Великі спокушування, що бачили очі твої, ознаки і чудеса й потужну руку й простягнуту правицю, що ними Господь, Бог твій, тебе вивів. Те ж саме зробить Господь, Бог твій, з усїма народами, що їх боїшся; ");
INSERT INTO ukr1871_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Надто ж іще пішле Господь, Бог твій, і шершенів між них, поки не погинуть ті, що позоставались поховавшись перед тобою. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Не лякайся перед ними! Бо Господь, Бог ваш, між вами, великий і страшний Бог. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","І прожене Господь, Бог твій, народи сї, одного за другим перед тобою; не можна тобі знищити їх разом, а то намножилось би проти тебе польового звіра. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","І віддасть їх тобі Господь, Бог твій, і пустить на них великий пострах і замішаннє, аж поки не погинуть. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","І віддасть він в руки тобі царів їх, і знівечиш їх імена спід небес. Ніхто не устоїть проти тебе, поки не знищиш їх. ");
INSERT INTO ukr1871_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Тисячі постатї богів їх попалиш огнем; не поривати меш очей на срібло і золото в них і не брати меш собі, щоб не попасти тобі в сїтку; бо се гидота перед Господом, Богом твоїм; ");
INSERT INTO ukr1871_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","І не вносити меш гидоти в дім твій, щоб не статись як і воно проклятим; мерзитись мусиш ним і ненавидїти його, бо прокляте воно. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Всї заповідї, що заповідаю тобі сьогоднї, будете додержувати сповняючи їх, щоб були живі і множились і прийшли в землю, що про неї клявся Господь батькам вашим. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","І мусиш памятати всї дороги, що ними водив тебе Господь, Бог твій, усї сорок роки, по степу, щоб впокорити тебе, щоб випробовувати тебе, щоб довідатись, що в тебе в серцї, чи додержувати меш заповідї його, чи нї. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","І впокорював тебе, і морив тебе голодом; і годував тебе манною, що не знав її, і не знали батьки твої, щоб ти довідався, що не хлїбом тільки живе людина, а всїм, що промовляють уста Господнї, і тим живе людина. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Одїж твоя не розлетїлась на тобі і ноги твої не попухли за сорок років. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","І мусиш знати в серцї твому, що Господь, Бог твій, карав тебе, як чоловік карає сина свого. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Тим же то мусиш додержувати заповідї Господа, Бога твого, ходити дорогами його і боятись його. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Бо Господь, Бог твій, уводить тебе в гарну землю, у землю водяних потоків, криниць і озер, що пробиваються по долинах і по горах; ");
INSERT INTO ukr1871_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","У землю пшеницї і ячменю і винограду й смоківниць і гранатової деревини; в землю оливного дерева, багатого на оливу і в землю медом багату, ");
INSERT INTO ukr1871_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","В землю, де ти не в нуждї їсти меш хлїб і де нїчого не бракувати ме тобі; в землю, де каміннє желїзне, і де в горах можна тобі викопувати мідь. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Щоб попоївши ти до сита, прославляв ти Господа, Бога твого, за добру землю, що дав тобі. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Бережись, щоб не забувати тобі про Господа, Бога твого, як не додержувати меш заповідї його і присуди його і установи його, що їх заповідаю тобі сьогодня! ");
INSERT INTO ukr1871_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Щоб, як їсти меш і будеш ситий, і побудуєш гарні домівки і розгосподаруєшся в них, ");
INSERT INTO ukr1871_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","І намножиться буйна і дрібна скотина в тебе, і стане в тебе багацько срібла й золота, і буде множитись все, що є в тебе, ");
INSERT INTO ukr1871_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Щоб не неслось у гору серце твоє і ти не забув Господа, Бога твого, що вивів тебе з Египецької землї, з дому неволї; ");
INSERT INTO ukr1871_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Що водив тебе величезним і страшенним степом, де пекельні гадюки-сарафи і шкорпіони, і суш безводна, та що точив тобі води з кременистої скелі; ");
INSERT INTO ukr1871_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Годував тебе в степу манною, що її не знали батьки твої, про те, щоб упокорити тебе, і про те, щоб випробувати тебе, щоб добро чинити тобі в будуччинї твоїй, ");
INSERT INTO ukr1871_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","І щоб ти не казав в серцї свому: Сила моя й потуга руки моєї здобули менї сї маєтки! ");
INSERT INTO ukr1871_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","А мусиш памятати про Господа, Бога твого, що він дає тобі силу здобувати маєтки; щоб він додержав завіт свій, котрим він клявся батькам твоїм, як се нинї сталось. ");
INSERT INTO ukr1871_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","І станеться, коли ти забудеш про Господа, Бога твого, та пійдеш за иншими богами, і станеш служити їм і покланятись перед ними, то я сьвідчусь перед вами сьогоднї, що певно ви погибнете; ");
INSERT INTO ukr1871_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Так само, як ті народи, що губить їх Господь поперед вами, так і ви згинете за те, що не слухаєте голосу Господа, Бога вашого. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Слухай, Ізраїлю! Ти сьогоднї переходиш через Йордань, щоб увійти й запанувати над народами, що більші й потужніщі за тебе, і заняти міста великі й утверджені під саме небо, ");
INSERT INTO ukr1871_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Над народом великим і високорослим, над синами Енакіїв, що знаєш їх і чув про них: Хто встоїть проти синів Енака? ");
INSERT INTO ukr1871_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Знай же, що Господь, Бог твій, іде поперед тебе як огонь пожераючий; він сам їх вигубить і сам їх нахилить перед тобою; і ти проженеш їх і знищиш їх чим скорше, так як тобі казав Господь. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Як випре їх Господь Бог твїй, перед тобою, не мовляй: За праведність мою привів мене Господь, Бог мій, опанувати сю землю, і за беззаконство сих народів Господь вигубив їх передо мною. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Не за праведність твою і не за правоту серця твого ти увіходиш сюди, щоб зайняти землю їх, а за беззаконність сих народів Господь, Бог твій, проганяє їх перед тобою та щоб справдити слово, що ним клявся Господь батькам твоїм, Авраамові, Ізаакові і Яковові. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Так знай же, що Господь, Бог твій, дає тобі сю гарну землю на оселю не за твою праведність; бо запеклий ти народ. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Памятай, не забувай, як прогнївляв єси Господа, Бога твого, в степу! З того дня, як вийшов єси з Египту, аж до вашого приходу на се врочище, ви упираєтесь проти Господа. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","І під Горебом прогнївили ви Господа; і розлютився Господь на вас так, що хотїв був вигубити вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Як вийшов я на гору, щоб приняти камяні таблицї, таблицї завіту, що вчинив його Господь із вами, то пробував я на горі сорок день і сорок ночей, хлїба не їв я і води не пив, ");
INSERT INTO ukr1871_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","І дав менї Господь дві камяні таблицї, писані пальцем Божим; а на їх були написані всї ті слова, якими розмовляв з вами Господь на горі ізсеред поломя, в день соборний. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Тодї, як скіньчилось сорок днїв і сорок ночей, дав Господь менї дві камяні таблицї, таблицї завіту. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","І рече до мене Господь: Устань, спустись чим скорше звідсї! Бо нарід твій, що вивів єси з Египту, зледачів, швидко вони покинули дорогу, що я заповідав їм, зробили собі вилиту постать. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","І промовив до мене Господь: Бачив я нарід сей, та ось він упертий нарід. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Ійди від мене геть, я вигублю їх і зітру імя їх спід небес, і зроблю тебе людом більшим і потужніщим за них. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","І я повернувся та й спустивсь із гори, а гора палала поломєм, і на обох руках в мене дві камяні завітні таблицї. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","І глянув я, та й бачу, ви согрішили проти Господа, Бога вашого; ви зробили собі вилитого бичка; швидко ви звернули з дороги, що її заповідав вам Господь. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","І вхопив я обидві таблицї, та й кинув їх обома руками моїми і розбив їх перед очима вашими. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","І припав я до землї перед Господом сорок день і сорок ночей, як перше, хлїба не ївши й води не пивши, за всї гріхи ваші, якими ви согрішили, витворюючи ледаче перед очима Господа, чим ви дразнили його. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Бо лякався я гнїва і лютостї, якою закипів Господь на вас, так що хотїв погубити вас. Та послухав Господь мене й сим разом. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","І на Арона вельми гнївавса Господь, так що хотїв був згубити його, та благав я тодї й за Арона. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","А бичка, гріх ваш, що ви зробили, взяв я і спалив його огнем, і розбивши в грудки, розмолов їх аж порохом стали: і викинув я сей порох до потока, що із гори збігав. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Так само розгнївили ви Господа при Табері й при Массі і при Киброт-Гаттааві. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","І як вас послав Господь із Кадес-Барне кажучи: Ідїть в гори і займіть землю, що я дав вам, так встали ви проти слова Господа, Бога вашого, і не поняли віри йому і не послухали голосу його. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Противились ви Господеві з того дня, від коли я зазнав вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","І припав я ниць перед Господом, благав я сорок день і сорок ночей на колїнках; казав бо Господь, що хоче погубити вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","І моливсь я перед Господом словами: Добродїю мій, Господе! Не побивай люду твого й наслїддя твого, що визволив єси їх потугою твоєю, що вивів їх сильною рукою з Египту. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Спогадай слугів твоїх, Авраама, Ізаака й Якова; не вважай на закаменїле серце люду сього, на беззаконня його й на гріх його; ");
INSERT INTO ukr1871_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Щоб в землї, що з неї вивів єси нас, не сказали: Господь не здолїв провести їх у землю, що про неї казав їм; і зненавидїв тому й вивів їх, щоб погибли смертю у степу. ");
INSERT INTO ukr1871_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Все ж бо таки вони люди і наслїддє твоє, що ти вивів твоєю великою потугою і простягненою рукою. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Того самого часу промовив до мене Господь: Витеши собі дві камяні таблицї, такі як перші, і вийди на гору до мене, та зроби собі скриню із дерева. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","І я напишу на таблицях слова, що були на перших таблицях, що розбив єси, і положи їх у скриню. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","І зробив я скриню із дерева акацієвого, та й витесав дві камяні таблицї, такі як перші, і вийшов на гору з двома таблицями в руках. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","І написав він на таблицях слова такі як перші, десять слів, що промовив Господь на горі до вас із поломя в день соборний; і дав їх менї Господь. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","І повернувсь я та й спустивсь із гори. І поклав таблицї в скриню, що зробив; і лежать вони там, як заповідав менї Господь. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","І рушили сини Ізрайлеві від Беерот-Бне-Яакану до Мозери. Там умер Арон і там поховано його, і намість його став сьвященником Єлеазар, син його. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Звідтіля пійшли вони до Гудгода, а від Гудгода у Йотбату країну, де багацько водяних бурчаків. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Того самого часу оддїлив Господь поколїннє Левієве, щоб носили скриню Господнього завіту, щоб стояли перед Господом, йому служили і благословляли імям його, по сей день. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Через те в Левія нема нї паю, нї наслїддя між його браттєю; сам Господь його наслїддє, як сказав йому Господь, Бог твій. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","А я пробував на горі, як у перші днї, сорок день і сорок ночей, і послухав мене Господь і сим разом; Господь не схотїв тебе знївечити. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","І промовив до мене Господь: Устань, та йди, веди перед сього народу, щоб увійшли та заняли землю, що я клявся батькам їх дати їм. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Тепер же, Ізраїлю, чого вимагає в тебе Господь, Бог твій, як не того, щоб ти боявся Господа, Бога твого, ходив усїма дорогами його, і любив його і служив Господеві, Богу твому, всїм серцем твоїм і всією душею твоєю, ");
INSERT INTO ukr1871_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Додержуючи заповідї Господнї й установи його, що їх сьогоднї заповідаю вам, вам самим на добро? ");
INSERT INTO ukr1871_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Поглянь, небо й небеса небес, земля і все, що на нїй, все від Господа, Бога твого, і все його. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Та до батьків твоїх прихилився Господь, і полюбив їх, і вибрав вас, їх насїннє з усїх народів, як се й бачимо. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Обрізуйте ж крайне тїло ваших сердець та й нехай не буде більше задубенїла шия ваша! ");
INSERT INTO ukr1871_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Бо Господь, Бог ваш, се Бог над богами і пан над панами великий, потужний і страшний Бог, що не вважає на лице чоловіка і не бере дарунків; ");
INSERT INTO ukr1871_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Він дає сиротинї і вдовицї, і милує приходня даючи йому хлїб і одїж. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Любіть же й ви приходня; бо самі ви були приходнями в Египецькій землї. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Господа, Бога твого, мусиш боятись, йому служити меш і його держати мешся і його імям клясти мешся. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Він слава твоя, і Бог твій, що сотворив про тебе сї великі і страшні речі, що бачили їх очи твої. ");
INSERT INTO ukr1871_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Двайцятеро душ спустились батьки твої в Египет; а тепер Господь, Бог твій, намножив тебе, як зорі небесні. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Люби ж Господа, Бога твого, і сповняй повелїння його і встанови його і присуди його і заповідї його, по всї днї. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","І признайте сьогоднї, — бо розмовляю не з дїтьми вашими, що не знають і не бачили, — кари від Господа, Бога вашого, славу його, потужну руку його і простягнуту правицю, ");
INSERT INTO ukr1871_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","І знаки його і дїла його, що сотворив їх в Египтї над Фараоном, царем Египецьким, і над усією його землею; ");
INSERT INTO ukr1871_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","І що він сотворив над войськовою потугою Египецькою, над кіньми їх і над колесницями їх; як затопив їх водами Червоного моря, коли вони гнались за вами; і погубив їх Господь по сей день; ");
INSERT INTO ukr1871_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","І що він вчинив про вас у степу, аж покіль ви прийшли до сього врочища; ");
INSERT INTO ukr1871_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Та що він зробив з Датаном та з Абирамом, синами Єлїаба, Рубененка: як земля роззявила челюстї свої та й проковтнула їх посеред синів всього Ізраїля з їх домівками, з їх наметами і з усїм статком, який був вкупі з ними. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Очі бо ваші бачили всї великі дїла Господнї, що сотворив їх. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Сповняйте ж усї заповідї, що сьогоднї заповідаю вам, щоб ви бувши потужними прийшли та заняли землю, куди переходите, щоб заняти її; ");
INSERT INTO ukr1871_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","І щоб ви продовжили вік свій у землї, що Господь клявся батькам вашим, дати їм і насїнню їх, землю, що тече молоком та медом. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Земля бо, куди прийдеш, щоб заняти її, не така, як земля Египецька, з котрої ви вийшли, де ти сїяв пашню та й поливав її, як городину, ворочаючи черпала ногами. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Земля, що йдеш до неї заняти її, се земля з горами й долинами, напуває її вода дощів небесних: ");
INSERT INTO ukr1871_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Се земля, про котру дбає сам Господь, Бог твій; очі Господа, Бога твого, пильнують її від початку року та й до кінця року. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","І станеться, як слухати мете пильно повелїння мої, що вам сьогоднї заповідаю, любити Господа Бога вашого і служити йому всїм серцем вашим і всією душею вашою, ");
INSERT INTO ukr1871_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","Так давати му дощ землї вашій свого часу, ранїшні і пізні дощі; так щоб ти зібрав пашню твою і виноград твій і олїю твою; ");
INSERT INTO ukr1871_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","І дам я про скотину твою пашу на полях твоїх, і будеш живитись і будеш ситий. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Остерегайтесь, щоб не звело вас серце ваше, і щоб ви, звернувши з дороги, не служили иншим богам і не покланялись перед ними, ");
INSERT INTO ukr1871_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Та щоб не запалав на вас гнїв Господа і він не замкнув небеса; тодї бо не буде дощу і земля не дасть врожаю, і ви швидко щезли б із землї, що дає вам Господь. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Сї слова мої вложіть у серце ваше і в душу вашу, і привязуйте їх як знаки на руку вашу, і нехай будуть вони начільниками між очима вашими; ");
INSERT INTO ukr1871_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","І навчайте їх синів ваших, промовляючи їх, як седиш у домівцї твоїй, і коли йдеш дорогою твоєю, лягаючи, і встаючи; ");
INSERT INTO ukr1871_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","І написуй їх на одвірках у домівки твоєї і на брамах твоїх, ");
INSERT INTO ukr1871_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","Щоб у землї, що Господь клявся дати їм, множились днї ваші і днї дїтей ваших, як днї небесні над землею. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Бо, як будете пильно сповняти всї заповіди сї, що вам заповідаю чинити, як будете любити Господа, Бога вашого, ходити всїма дорогами його і прихилятись до його, ");
INSERT INTO ukr1871_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","То Господь прожене перед вами всї ті народи; і ви запануєте над народами, що більші й потужнїщі за вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Всяка країна, на яку ступить ваша стопа, буде ваша; від степу і від гір Либанських, від ріки, ріки Евфрату та аж до західнього моря, все те буде ваше займище. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Нїхто не встоїть перед вами; страх і жах перед вами нагшле Господь, Бог ваш, на всю землю, на яку ви поступите, як обіцяно вам. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Ось, я кладу сьогоднї перед вами благословеннє і прокляттє: ");
INSERT INTO ukr1871_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Благословеннє, як будете слухати заповідей Господа, Бога вашого, що заповідаю вам їх сьогоднї, ");
INSERT INTO ukr1871_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Прокляттє, як не будете слухати заповідей Господа, Бога вашого, та й позвертаєте з дороги, що вам сьогоднї заповідаю, та будете ходити за иншими богами, яких не знаєте. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","І як приведе тебе Господь, Бог твій, у землю, куди ти йдеш, щоб заняти її, тодї принеси благословеннє на Геризім горі а прокляттє на Ебаль горі. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Чи не вони ж стоять по онтім боцї Йорданї, за шляхом, що йде на захід соньця у землї Канаанїїв, що живуть на поділлї, проти Гілгаля, коло дубрави Море? ");
INSERT INTO ukr1871_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Бо вам треба перейти через Йордань, щоб увійти і заняти землю, що Господь, Бог ваш, дає вам; і ви займете її і осядетесь на їй. ");
INSERT INTO ukr1871_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Оце ж старайтесь сповняти всї встанови і закони, що викладаю перед вами сьогоднї. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Ось встанови і закони, що мусите пильнувати, щоб сповняти їх в землї, котру дав тобі Господь, Бог батьків твоїх, щоб вона була твоя по всї днї, як довго жити мете на сїй землї. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Мусите ви зовсїм знївечити всї місця ті, де народи, що проженете їх, богам своїм служили: по високих горах, на могилах і під всякою зеленою деревиною; ");
INSERT INTO ukr1871_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Поруйнуйте жертівники їх, і порозбивайте стовпи їх, і вогнем повипалюйте гаї їх, і порубайте тесані постатї богів їх; та й імена їх знївечіте із місць тих. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Не будете чинити такого Господу Богу вашому; ");
INSERT INTO ukr1871_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","А пійдете на те місце, що вибере Господь, Бог ваш, з усїх ваших поколїнь, щоб там поставити імя своє, і там пробувати; і будеш туди вчащати. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","І туди будете приносити всепалення ваші і заколювані жертви ваші і десятини ваші, і жертву приношення рук ваших, і обітницї ваші і добровільні жертви ваші, і перваки вашої скотини буйної й дрібної; ");
INSERT INTO ukr1871_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","І будете там їсти перед Господом, Богом вашим, і радїти усїм, що робити мете руками вашими, ви самі й доми ваші, чим Господь, Бог твій, поблагословить тебе. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Не годиться вам робити всього, як тепер ту робите, що кому здається правим перед очима його; ");
INSERT INTO ukr1871_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Бо ви ще не прийшли до впокою і до наслїддя, що дасть тобі Господь, Бог твій. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Коли ж перейдете ви за Йордань, та й осядетесь у землї, що дає вам в наслїддє Господь, Бог ваш, і як він дасть вам упокій від усїх ворогів ваших і станете безпечно жити, ");
INSERT INTO ukr1871_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Тодї ось як має бути: на те врочище, що вибере Господь, Бог ваш, щоб там сьвятилось імя його, туди приносити мете все, що заповідаю вам: ваші всепалення й ваші жертви заколювані, ваші десятини й жертви приношення рук ваших, і все вибране після обітниць ваших, що будете шлюбувати Господеві. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","І будете веселитись перед Господом, Богом вашим, самі ви й сини ваші й дочки ваші, й слуги ваші й служки ваші, і Левіт, що жиє в оселях ваших; нема бо в його з вами паю і наслїддя. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Стережись приносити всепаленнє твоє на всякому місцї, де яке побачиш; ");
INSERT INTO ukr1871_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Нї, на тому місцї, що вибрав собі Господь в одному із твоїх поколїнь, там годиться тобі приносити всепалення твої, і там чинити мусиш все, про що заповідаю тобі. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Однако ж, по всякому бажанню душі твоєї, можна тобі заколювати й їсти мясиво в усїх оселях твоїх по благословенню Господа, Бога твого, що дасть тобі: Нечистому й чистому можна їсти мясиво таке, як від сарнї і від оленя. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Тільки ж крові їх їсти не можна; на землю мусять її виливати, як воду. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Не можна тобі їсти в оселї твоїй десятин зерна твого, і вина твого, і олїї твоєї, і перваків з буйної і дрібної скотини твоєї, і жадних обітниць твоїх, що обіцюєш їх, нї добровільних дарів, нї жертви приношення рук твоїх; ");
INSERT INTO ukr1871_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Нї; перед Господом, Богом твоїм, на тому місцї, що вибере Господь, Бог твій, мусиш їсти їх, сам ти і син твій і дочка твоя, і наймит твій і наймичка твоя, і Левит, що в місцї оселї твоєї; і радїти меш перед Господом, Богом твоїм, всяким дїлом рук твоїх. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Остерегайсь покинути Левита, покіль життя твого на землї твоїй. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Коли Господь, Бог твій, розширить гряницї твої, як він промовляв до тебе, і ти скажеш: Хочу їсти мясива тому, що мясива тобі забажалось, можна буде тобі їсти мясиво. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Коли далеке від тебе те місце, що Господь, Бог твій, вибере, щоб там поставити імя своє, так можна тобі заколювати з буйної і дрібної скотини, що дав тобі Господь, як я заповідав тобі, і їсти меш в оселї твоїй, як душа твоя забажає. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Можна тобі їсти його, як їси сарню та оленя: і нечистому і чистому можна їсти його. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Тільки пильнуй, щоб не їсти крові, кров бо, се душа; то й не годиться тобі їсти душу з тїлом. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Не будеш їсти її; мусиш виливати її на землю, як воду. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Не їсти меш її, про те щоб добре було тобі і дїтям твоїм по тобі; бо чинити меш те, що добре перед очима в Господа. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Одначе ж присьвяти твої, які в тебе будуть й обітницї твої, возьмеш їх і прийдеш до того місця, що Господь вибере його; ");
INSERT INTO ukr1871_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","І принесеш всепалення твої, мясиво й кров, на жертівнику Господа, Бога твого; і кров заколених жертов твоїх буде вилита на жертівник Господа, Бога твого, а мясиво можна їсти тобі. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Пильнуй і сповняй всї слова мої, що тобі заповідаю, щоб по віки було добре тобі й дїтям твоїм по тобі за те, що чинити меш все, що добре і праве перед очима Господа, Бога твого. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Як Господь, Бог твій, прожене перед тобою ті народи, що до них ідеш, щоб їх прогнати, і ти проженеш їх і осядешся в землї їх, ");
INSERT INTO ukr1871_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","То бережись, щоб не запутався за ними, після того, як будуть вони знївечені, та щоб не почав ти шукати богів їх, питаючи: Як служили сї народи богам своїм? Чинити му і я так! ");
INSERT INTO ukr1871_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Не будеш чинити таке Господеві, Богу твому; бо все, що гидота перед Господом, ненавидна йому, те чинили вони перед богами своїми; бо навіть синів своїх і дочок своїх палили вони на огнї догоджуючи богам своїм. ");
INSERT INTO ukr1871_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Усе, що заповідаю вам старайтесь сповняти; нїчого не причиниш, і нїчого не уймеш. ");
INSERT INTO ukr1871_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Коли між вами зʼявиться пророк або сновидець, і покаже тобі ознаку або чудо, ");
INSERT INTO ukr1871_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","І справдиться ознака або чудо, про котре він казав тобі, говорючи: Ходїмо слїдом за иншими богами, що їх ти досї не знав, та будемо служити їм; ");
INSERT INTO ukr1871_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","То не будеш слухати того пророка або сновидця; бо Господь, Бог ваш, спокушує вас, щоб довідатись, чи справдї ви любите Господа, Бога вашого, всїм серцем вашим і всїєю душею вашою. ");
INSERT INTO ukr1871_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","За Господом, Богом вашим, будете слїдом ходити і його боятись; і будете ви додержувати заповідї його і слухати голосу його і служити йому і до його вірно прихилятись. ");
INSERT INTO ukr1871_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","І мусите вбити сього пророка або сновидця; бо він проповідував відступництво від Господа, Бога вашого, що вивів вас із Египецької землї, і визволив тебе із невольницького дому; хотїв він звести тебе з дороги, якою йти заповідав тобі Господь, Бог твій. Сим робом викорените зло зміж вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Коли брат твій, син матері твоєї, або син твій, чи дочка твоя, чи жона серця твого, чи приятель твій, любий як душа твоя, та буде підмовляти тебе тайкома, говорючи: Нумо, будем служити иншим богам, яких не знав ти, нї ти, нї батьки твої, ");
INSERT INTO ukr1871_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","Богам народів, що навкруги вас, близько до тебе, чи далеко від тебе, від одного кінця землї до другого кінця землї, ");
INSERT INTO ukr1871_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","То не приставай на волю його і не слухай його; і нехай не знайде він ласки в очах твоїх, і не змилосердься до його, і не сховаєш його; ");
INSERT INTO ukr1871_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Нї! ти повинен вбити його. Рука твоя буде перва на страту його, а потім рука всього люду, ");
INSERT INTO ukr1871_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","І побєш його каміннєм, щоб погиб. Він бо хотїв відвернути тебе від Господа, Бога твого, що вивів тебе з Египту, із дому неволї. ");
INSERT INTO ukr1871_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","І ввесь Ізраїль мусить слухати і боятись, щоб не було більше такого злочину серед вас. ");
INSERT INTO ukr1871_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Коли в якому містї, що дав тобі на оселю Господь, Бог твій, доведеться тобі почути таке: ");
INSERT INTO ukr1871_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","Появились люди, сини Беліяла, між вами і підмовили жителїв міста вашого, говорючи: Нумо, будем служити богам иншим, яких не знали ви, ");
INSERT INTO ukr1871_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","То мусиш докладно розвідати і дослїдити допитом; якже сьому правда, і річ зовсїм певна, що вчинено огидну гидоту серед вас, ");
INSERT INTO ukr1871_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","То побєш гострим мечем жителїв міста того, і обречеш його і все, що в йому, і скотину їх гострим мечем. ");
INSERT INTO ukr1871_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","І всю здобич позносите ви на оболоннє їх, і місто і всю здобич, усе до крихти, спалите вогнем перед Господом, Богом твоїм. І буде воно на віки руїною і вже більше не буде збудоване. ");
INSERT INTO ukr1871_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","І нїщо обречене не зістанеться в руцї твоїй, щоб Господь усмирив ярість гнїва свого, і явив тобі милосердє своє, і змилосердивсь над тобою і намножив тебе, як клявся батькам твоїм, ");
INSERT INTO ukr1871_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","Коли послухаєш голосу Господа, Бога твого, і сповняти меш всї заповідї його, що сьогоднї заповідаю тобі, щоб ти чинив усе, що праве перед очима Господа, Бога твого. ");
INSERT INTO ukr1871_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Ви дїти Господа, Бога вашого; за мерцем не робити мете нарізок і не будете стригти бров ваших: ");
INSERT INTO ukr1871_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Ти бо люд сьвятий у Господа, Бога твого; і вибрав він тебе, щоб ти був людом наслїддя із усїх народів, які на лицї земному. ");
INSERT INTO ukr1871_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Не їсти меш нїчого гидкого. ");
INSERT INTO ukr1871_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Ось яку скотину можна вам їсти: воли, вівцї й кози, ");
INSERT INTO ukr1871_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","Оленя й ланю і буйвола і сарню і зубра і дику козу і дику вівцю, ");
INSERT INTO ukr1871_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","І всяку скотину, що має ратицї, і то зовсїм розчіплені ратицї, і що ремигає між скотиною. ");
INSERT INTO ukr1871_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Тільки ось яких не можна вам їсти зміж ремигаючих і з таких, що мають розчіплені ратицї: верблюда й зайця і крілика; бо вони ремигають, та не мають роздїлених ратиць: будуть вони нечисті про вас; ");
INSERT INTO ukr1871_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","І без