﻿USE sofia;
DROP TABLE IF EXISTS sofia.uigpin_vpl;
CREATE TABLE uigpin_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uigpin_vpl WRITE;
INSERT INTO uigpin_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Muⱪǝddǝmdǝ Huda asmanlar bilǝn zeminni yaratti.    ");
INSERT INTO uigpin_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","U qaƣda yǝr bolsa xǝkilsiz wǝ ⱪupⱪuruⱪ ⱨalǝttǝ boldi; ⱪarangƣuluⱪ qongⱪur sularning yüzini ⱪaplidi; Hudaning Roⱨi qongⱪur sular üstidǝ lǝrzan pǝrwaz ⱪilatti. ");
INSERT INTO uigpin_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Huda: «Yoruⱪluⱪ bolsun!» dewidi, yoruⱪluⱪ pǝyda boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Huda yoruⱪluⱪning yahxi ikǝnlikini kɵrdi; Huda yoruⱪluⱪ bilǝn ⱪarangƣuluⱪni ayridi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Huda yoruⱪluⱪni «kündüz», ⱪarangƣuluⱪni «keqǝ» dǝp atidi. Xu tǝriⱪidǝ kǝq bilǝn sǝⱨǝr ɵtti, bu tunji kün boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Andin Huda: — Sularning ariliⱪida bir boxluⱪ bolsun wǝ sular yuⱪiri-tɵwǝn ikkigǝ ayrilip tursun, dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Xuning bilǝn Huda bir boxluⱪ ⱨasil ⱪilip, sularni boxluⱪning astiƣa wǝ boxluⱪning üstigǝ ayriwǝtti; ix ǝnǝ xundaⱪ boldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Huda bu boxluⱪni «asman» dǝp atidi. Xu tǝriⱪidǝ kǝq bilǝn sǝⱨǝr ɵtti, bu ikkinqi kün boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Andin Huda: «Asmanning astidiki sular bir yǝrgǝ yiƣilsun, ⱪuruⱪ tupraⱪ kɵrünsun!» dewidi, dǝl xundaⱪ boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Huda ⱪuruⱪ tupraⱪni «yǝr», yiƣilƣan sularni bolsa «dengizlar» dǝp atidi. Huda bularning yahxi bolƣanliⱪini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Andin Huda yǝnǝ: «Yǝr ⱨǝrhil ɵsümlüklǝrni, uruⱪluⱪ otyaxlarni, mewǝ beridiƣan dǝrǝhlǝrni türliri boyiqǝ ɵzidǝ ündürsun! Mewilǝrning iqidǝ uruⱪliri bolsun!» dewidi, dǝl xundaⱪ boldi; ");
INSERT INTO uigpin_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","yǝrdiki ɵsümlüklǝrni, yǝni uruⱪ qiⱪidiƣan otyaxlarni ɵz türliri boyiqǝ, mewǝ beridiƣan, yǝni mewilirining iqidǝ uruⱪliri bolƣan dǝrǝhlǝrni ɵz türliri boyiqǝ ündürdi. Huda bularning yahxi bolƣanliⱪini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Xu tǝriⱪidǝ kǝq bilǝn sǝⱨǝr ɵtti, bu üqinqi kün boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Huda yǝnǝ: «Kündüz bilǝn keqini ayrip berix üqün asmanlarda yoruⱪluⱪ jisimlar bolsun. Ular künlǝr, pǝsillar wǝ yillarni ayrip turuxⱪa bǝlgǝ bolsun; ");
INSERT INTO uigpin_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ular asmanlarda turup nur qiⱪarƣuqi bolup, yǝr yüzigǝ yoruⱪluⱪ bǝrsun!» dewidi, dǝl xundaⱪ boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Huda ikki qong nur qiⱪarƣuqi jisimni yaratti; qong nur qiⱪarƣuqini kündüzni baxⱪuridiƣan, kiqik nur qiⱪarƣuqni keqini baxⱪuridiƣan ⱪildi. Ⱨǝmdǝ yǝnǝ yultuzlarnimu yaratti. ");
INSERT INTO uigpin_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Huda bularni yǝrgǝ yoruⱪluⱪ berip, kündüz bilǝn keqini baxⱪurup, yoruⱪluⱪ bilǝn ⱪarangƣuluⱪni ayrisun dǝp asmanlarning gümbizigǝ orunlaxturdi. Huda buning yahxi bolƣanliⱪini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Xu tǝriⱪidǝ kǝq bilǝn sǝⱨǝr ɵtti, bu tɵtinqi kün boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Huda yǝnǝ: «Sularda miƣ-miƣ janiwarlar bolsun, uqar-ⱪanatlar yǝrning üstidǝ, asman boxluⱪida uqsun» dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Xundaⱪ ⱪilip Huda sudiki qong-qong mǝhluⱪlarni, xundaⱪla sularda miƣ-miƣ janiwarlarni ɵz türliri boyiqǝ wǝ ⱨǝrhil uqar-ⱪanatlarni ɵz türliri boyiqǝ yaratti. Huda buning yahxi bolƣanliⱪini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Huda bu janliⱪlarƣa bǝht-bǝrikǝt ata ⱪilip: «Nǝsillinip, kɵpiyip, dengiz sulirini toldurunglar, uqar-ⱪanatlarmu yǝr yüzidǝ awusun» dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Xu tǝriⱪidǝ kǝq bilǝn sǝⱨǝr ɵtti, bu bǝxinqi kün boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Huda yǝnǝ: «Yǝr janiwarlarni ɵz türliri boyiqǝ qiⱪarsun — mal-qarwilarni, ɵmiligüqi janiwarlarni wǝ yawayi ⱨaywanlarni ɵz türliri boyiqǝ apiridǝ ⱪilsun» — dewidi, dǝl xundaⱪ boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Xundaⱪ ⱪilip Huda yǝrdiki yawayi ⱨaywanlarni ɵz türliri boyiqǝ, mal-qarwilarni ɵz türliri boyiqǝ wǝ yǝr yüzidǝ ɵmiligüqi barliⱪ janiwarlarni ɵz türliri boyiqǝ yaratti. Huda buning yahxi bolƣanliⱪini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Andin Huda: «Ɵz sürǝt-obrazimizda, Bizgǝ ohxaydiƣan ⱪilip insanni yaritayli. Ular dengizdiki beliⱪlarƣa, asmandiki uqar-ⱪanatlarƣa, barliⱪ mal-qarwilarƣa, pütkül yǝr yüzigǝ wǝ yǝr yüzidiki barliⱪ ɵmiligüqi janiwarlarƣa igidarqiliⱪ ⱪilsun» dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Xundaⱪ ⱪilip, Huda insanni Ɵz sürǝt-obrazida yaratti; Uni Ɵzining süritidǝ yaratti; Ularni ǝrkǝk-qixi ⱪilip yaratti. ");
INSERT INTO uigpin_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Huda ularƣa bǝht-bǝrikǝt ata ⱪilip: «Silǝr nǝsillinip, kɵpiyip, yǝr yüzini toldurup boysundurunglar; dengizdiki beliⱪlar, asmandiki uqar-ⱪanatlarƣa, xuningdǝk yǝr yüzidǝ yüridiƣan ⱨǝrbir ⱨaywanlarƣa igidarqiliⱪ ⱪilinglar» dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Andin Huda yǝnǝ: «Mana, Mǝn pütkül yǝr yüzidiki uruⱪluⱪ otyaxlar bilǝn uruⱪluⱪ mewǝ beridiƣan ⱨǝrbir dǝrǝhlǝrni silǝrgǝ ozuⱪluⱪ bolsun dǝp bǝrdim; ");
INSERT INTO uigpin_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","xundaⱪla yǝrdiki barliⱪ janiwarlar bilǝn asmandiki barliⱪ uqar-ⱪanatlar wǝ yǝr yüzidǝ barliⱪ ɵmiligüqilǝrgǝ, yǝni barliⱪ jan-janiwarlarƣa ozuⱪluⱪ bolsun dǝp barliⱪ gül-giyaⱨlarni bǝrdim» dewidi, dǝl xundaⱪ boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Huda yaratⱪanlirining ⱨǝmmisigǝ sǝpselip ⱪaridi, wǝ mana bularning ⱨǝmmisi naⱨayiti yahxi bolƣanidi. Xu tǝriⱪidǝ kǝq bilǝn sǝⱨǝr ɵtti, bu altinqi kün boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Xundaⱪ ⱪilip asman bilǝn zemin, pütkül mǝwjudatliri bilǝn ⱪoxulup yaritilip boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Huda yǝttinqi künigiqǝ ⱪilidiƣan ixini tamamlidi. U yǝttinqi küni barliⱪ yaritix ixini tohtitip aram aldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Yǝttinqi küni Huda barliⱪ yaritix ixliridin aram alƣan kün bolƣanliⱪi üqün, xu künni bǝhtlik kün ⱪilip, uni «muⱪǝddǝs kün» dǝp bekitti. ");
INSERT INTO uigpin_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Pǝrwǝrdigar Huda zemin bilǝn asmanni yaratⱪan künidǝ, asman-zeminning yaritilix jǝryanining tarihliri mundaⱪ: — ");
INSERT INTO uigpin_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Zeminda tehi ⱨeq gül-giyaⱨ, yǝrdǝ ⱨeq otyax ünmigǝnidi; qünki Pǝrwǝrdigar Huda yǝr yüzigǝ ⱨɵl-yeƣin yaƣdurmiƣanidi, xundaⱪla yǝr teriydiƣan adǝmmu yoⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Lekin yǝrdin bulaⱪ süyi qiⱪip, tamam yǝr yüzini suƣardi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Andin Pǝrwǝrdigar Huda adǝmni yǝrning topisidin yasap, ⱨayatliⱪ nǝpisini uning burniƣa püwlidi; xuning bilǝn adǝm tirik bir jan boldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Andin keyin Pǝrwǝrdigar Huda mǝxriⱪ tǝrǝptǝ Erǝm degǝn jayda bir baƣ bina ⱪilip, yasiƣan adǝmni xu yǝrgǝ orunlaxturdi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Pǝrwǝrdigar Huda yǝrdin kɵzni ⱪamlaxturidiƣan qirayliⱪ, mewiliri yeyixlik ⱨǝrhil dǝrǝhni ündürdi; u yǝnǝ baƣning otturisida «ⱨayatliⱪ dǝrihi» wǝ «yahxi bilǝn yamanni bilgüzgüqi dǝrǝh»ni ündürdi.    ");
INSERT INTO uigpin_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Baƣni suƣirixⱪa Erǝmdin bir dǝrya eⱪip qiⱪti; andin bɵlünüp, tɵt eⱪin boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Birinqi eⱪinning nami Pixon bolup, altun qiⱪidiƣan pütkül Ⱨawilaⱨ zeminini aylinip ɵtidu. ");
INSERT INTO uigpin_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Bu yurtning altuni naⱨayiti esil idi; xu yǝrdǝ puraⱪliⱪ dewirⱪay bilǝn aⱪ ⱨeⱪiⱪmu qiⱪidu. ");
INSERT INTO uigpin_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ikkinqi dǝryaning nami Giⱨon bolup, pütkül Kux zeminini aylinip ɵtidu. ");
INSERT INTO uigpin_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Üqinqi dǝryaning nami Dijlǝ bolup, Axurning xǝrⱪidin eⱪip ɵtidu, tɵtinqi dǝryaning nami Əfrat idi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Pǝrwǝrdigar Huda adǝmni elip Erǝm beƣiƣa ixlǝp, pǝrwix ⱪilsun dǝp uni xu yǝrgǝ ⱪoyup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Pǝrwǝrdigar Huda adǝmgǝ ǝmr ⱪilip: baƣdiki ⱨǝrbir dǝrǝh mewiliridin haliƣiningqǝ yǝ; ");
INSERT INTO uigpin_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ǝmma «yahxi bilǝn yamanni bilgüzgüqi dǝrǝh»ning mewisidin yemigin; qünki uningdin yegǝn kününgdǝ jǝzmǝn ɵlisǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Andin Pǝrwǝrdigar Huda yǝnǝ sɵz ⱪilip: — Adǝmning yalƣuz turuxi yahxi ǝmǝs; Mǝn uningƣa mas kelidiƣan bir yardǝmqi ⱨǝmraⱨni yasap berǝy, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Pǝrwǝrdigar Huda tupraⱪtin daladiki barliⱪ janiwarlar bilǝn asmandiki ⱨǝmmǝ uqar-ⱪanatlarni yasiƣanidi; ularƣa adǝmning nemǝ dǝp at ⱪoyidiƣanliⱪini bilix üqün, U ularni adǝmning aldiƣa kǝltürdi. Adǝm ⱨǝrbir janiwarƣa nemǝ dǝp at ⱪoyƣan bolsa, uning eti xu bolup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Bu tǝriⱪidǝ adǝm ⱨǝmmǝ mal-qarwilarƣa, asmandiki uqar-ⱪanatlarƣa wǝ daladiki ⱨǝrbir janiwarlarƣa at ⱪoydi; wǝⱨalǝnki, adǝm ɵzigǝ mas kelidiƣan ⱨeqbir yardǝmqi ⱨǝmraⱨ uqratmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Xuning bilǝn Pǝrwǝrdigar Huda adǝmgǝ bir ⱪattiⱪ uyⱪu saldi; u uhlap ⱪaldi. U uhlawatⱪanda, U uning biⱪinidin bir az elip, andin uning ornini ǝt-gɵx bilǝn etip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Xuning bilǝn Pǝrwǝrdigar Huda adǝmning biⱪinidin alƣan xu ⱪisimdin bir ayalni yasap, uni adǝmning ⱪexiƣa ǝkǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adǝm’ata huxal bolup: — Mana bu sɵngǝklirimdiki sɵngǝk, etimdiki ǝt bolƣaq, «ayal» dǝp atalsun; qünki u ǝrdin elinƣandur, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Xuning üqün ǝr kixi ata-anisidin ayrilip, ɵz ayaliƣa baƣlinip bir bolup, ikkisi bir tǝn bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adǝm’ata bilǝn ayali ⱨǝr ikkisi yalingaq bolsimu, ⱨeq uyalmaytti.    ");
INSERT INTO uigpin_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yǝr yüzidǝ yilan Rǝb Pǝrwǝrdigar yaratⱪan daladiki ⱨaywanlarning ⱨǝmmisidin ⱨiyligǝr idi. U ayaldin: — Huda rasttinla baƣdiki dǝrǝhlǝrning ⱨeqⱪaysisining mewisidin yemǝnglar, dedimu? — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ayal yilanƣa jawab berip: — Baƣdiki dǝrǝhlǝrning mewilirini yesǝk bolidu. ");
INSERT INTO uigpin_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Əmma baƣning otturisidiki dǝrǝhning mewisi toƣrisida Huda: «Buningdin yemǝnglar, ⱪolmu tǝgküzmǝnglar, bolmisa ɵlisilǝr» degǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yilan ayalƣa: — Undaⱪ ǝmǝs! Ⱨǝrgiz ɵlmǝysilǝr! ");
INSERT INTO uigpin_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Bǝlki silǝr uni yegǝn kününglarda, Huda kɵzünglarning eqilip, Hudaƣa ohxax yahxi bilǝn yamanni bilidiƣan bolup ⱪalidiƣanliⱪinglarni bilidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ayal dǝrǝhning mewisining yemǝklik üqün yahxiliⱪini, uning kɵzni ⱪamlaxturidiƣanliⱪini kɵrüp, ⱨǝmdǝ dǝrǝhning adǝmni ǝⱪilliⱪ ⱪilidiƣan jǝlpkarliⱪini kɵrüp, mewidin yedi wǝ uningdin yenida turƣan erigimu bǝrdi; umu yedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yeyixi bilǝnla ⱨǝr ikkisining kɵzliri eqilip, ɵzlirining yalingaq ikǝnlikini bilip, ǝnjür yopurmaⱪlirini elip bir-birigǝ ulap tikip, ɵzlirigǝ yapⱪuq ⱪilip tartti. ");
INSERT INTO uigpin_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kün salⱪinliƣanda, ular Pǝrwǝrdigar Hudaning baƣda mangƣan xǝpisini anglap ⱪelip, adǝm ayali bilǝn Pǝrwǝrdigar Hudaning ⱨazir bolƣinidin ⱪeqip baƣdiki dǝrǝhlǝrning arisiƣa yoxurunuwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Lekin Pǝrwǝrdigar Huda towlap adǝmni qaⱪirip uningƣa: Sǝn nǝdǝ? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adǝm’ata jawab berip: — Mǝn baƣda xǝpǝngni anglap, yalingaq turƣinim üqün ⱪorⱪup ketip, yoxurunuwaldim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Huda uningƣa: — Yalingaq ikǝnlikingni sanga kim eytti? Mǝn sanga yemǝ, dǝp ǝmr ⱪilƣan dǝrǝhning mewisidin yedingmu-ya? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adǝm jawab berip: — Sǝn manga ⱨǝmraⱨ boluxⱪa bǝrgǝn ayal dǝrǝhning mewisidin manga bǝrgǝnidi, mǝn yedim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Pǝrwǝrdigar Huda ayalƣa: — Bu nemǝ ⱪilƣining? — dedi. Ayal jawab berip: — Yilan meni aldap azdursa, mǝn yǝp saptimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Pǝrwǝrdigar Huda yilanƣa mundaⱪ dedi: — «Bu ⱪilƣining üqün, Sǝn ⱨǝmmǝ mal-qarwilardin, Daladiki barliⱪ ⱨaywanatlardin bǝkrǝk lǝnǝtkǝ ⱪalisǝn; Ⱪorsiⱪing bilǝn beƣirlap mengip, Ɵmrüngning barliⱪ künliridǝ topa yǝysǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Wǝ mǝn sǝn bilǝn ayalning arisiƣa, Sening nǝsling bilǝn ayalning nǝslining arisiƣa ɵqmǝnlik salimǝn; U sening bexingni dǝssǝp zǝhimlǝndüridu, Sǝn ⱪopup uning tapinini qeⱪip zǝhimlǝndürisǝn».    ");
INSERT INTO uigpin_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Andin Huda ayalƣa: — «Sening ⱨamilidarliⱪingning japa-muxǝⱪⱪǝtlirini kɵpǝytimǝn; Sǝn ⱪattiⱪ tolƣaⱪ iqidǝ boxinisǝn; Sǝn eringdin üstün turuxⱪa ⱨǝwǝs ⱪilsangmu, U üstüngdin hojiliⱪ ⱪilidu» — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Andin U Adǝm’atiƣa: — «Sǝn ayalingning sɵzigǝ ⱪulaⱪ selip, Mǝn sanga yemǝ, dǝp ǝmr ⱪilƣan dǝrǝhtin yegining tüpǝylidin, Sening tüpǝylingdin yǝr-tupraⱪ lǝnitimgǝ uqraydu; Ɵmrüngning barliⱪ künliridǝ pǝⱪǝt japaliⱪ ixlǝpla, andin uningdin ozuⱪlinisǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Yǝr sanga tikǝn bilǝn ⱪamƣaⱪ ündüridu; Xundaⱪtimu sǝn yǝrdiki ziraǝt-otyaxlarni yǝysǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Taki sǝn tupraⱪⱪa ⱪaytⱪuqǝ yüz-kɵzüng tǝrgǝ qümgǝndǝ, andin nan yeyǝlǝysǝn; Qünki sǝn ǝsli tupraⱪtin elinƣansǝn; Sǝn ǝslidǝ topa bolƣaq, Yǝnǝ topiƣa ⱪaytisǝn» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Uning ayali barliⱪ jan igilirining anisi bolidiƣini üqün adǝm uningƣa «Ⱨawa» dǝp at ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Pǝrwǝrdigar Huda Adǝm’ata bilǝn uning ayaliƣa ⱨaywan teriliridin kiyim ⱪilip kiydürüp ⱪoydi.    ");
INSERT INTO uigpin_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Pǝrwǝrdigar Huda sɵz ⱪilip: — Mana, adǝm Bizlǝrdin birigǝ ohxap ⱪaldi, yahxi bilǝn yamanni bildi. Əmdi ⱪolini uzitip ⱨayatliⱪ dǝrihidin elip yǝwelip, ta ǝbǝdgiqǝ yaxawǝrmǝsliki üqün uni tosuximiz kerǝk, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Xuning bilǝn Pǝrwǝrdigar Huda uni Erǝm baƣdin ⱪoƣlap qiⱪiriwǝtti; xundaⱪ ⱪilip uni yǝrgǝ ixlǝydiƣan, yǝni ɵzi ǝsli apiridǝ ⱪilinƣan tupraⱪⱪa ixlǝydiƣan ⱪilip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Adǝmni ⱪoƣliwetip, ⱨayatliⱪ dǝrihigǝ baridiƣan yolni muⱨapizǝt ⱪilix üqün, u Erǝm beƣining mǝxriⱪ tǝripigǝ kerublarni wǝ tɵt tǝrǝpkǝ pirⱪiraydiƣan yalⱪunluⱪ bir xǝmxǝrni ⱪoyup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adǝm’ata ayali Ⱨawa bilǝn billǝ boldi; Ⱨawa ⱨamilidar bolup Ⱪabilni tuƣup: «Mǝn bir adǝmgǝ igǝ boldum — U Pǝrwǝrdigardur!» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Andin u yǝnǝ Ⱪabilning inisi Ⱨabilni tuƣdi. Ⱨabil padiqi boldi, Ⱪabil bolsa teriⱪqi boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bekitilgǝn xundaⱪ bir waⱪit-saǝttǝ xundaⱪ bir ix boldiki, Ⱪabil tupraⱪning ⱨosulidin Pǝrwǝrdigarƣa ⱨǝdiyǝ kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ⱨabilmu padisidin ⱪoylirining tunjiliridin, yǝni ularning yeƣidin ⱨǝdiyǝ sundi. Pǝrwǝrdigar Ⱨabilni wǝ uning sunƣan ⱨǝdiyǝsini ⱪobul ⱪildi.    ");
INSERT INTO uigpin_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Lekin Ⱪabil wǝ uning sunƣiniƣa ⱪarimidi. Xu wǝjidin Ⱪabilning tolimu aqqiⱪi kelip, qirayi tutuldi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Xuning bilǝn Pǝrwǝrdigar Ⱪabilƣa:  Nemixⱪa aqqiⱪlinisǝn? Nemǝ üqün qiraying tutulup ketidu? ");
INSERT INTO uigpin_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Əgǝr durus ix ⱪilsang, sǝn kɵtürülmǝmsǝn? Lekin durus ix ⱪilmisang, mana gunaⱨ ixik aldida seni paylap beƣirlap yatidu, u seni ɵz ilkigǝ almaⱪqi bolidu; lekin sǝn uningdin ƣalip kelixing kerǝk, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ⱪabil inisi Ⱨabilƣa: «Daliƣa qiⱪip kelǝyli!» dedi. Dalada xu wǝⱪǝ boldiki, Ⱪabil inisi Ⱨabilƣa ⱪol selip, uni ɵltürdi.    ");
INSERT INTO uigpin_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Pǝrwǝrdigar Ⱪabilƣa: Ining Ⱨabil nǝdǝ? — dǝp soridi. U jawab berip: Bilmǝymǝn, mǝn inimning baⱪⱪuqisimu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Huda uningƣa: — Sǝn nemǝ ⱪilding? Mana, iningning ⱪeni yǝrdin manga pǝryad kɵtürüwatidu! ");
INSERT INTO uigpin_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Əmdi iningning ⱪolungda tɵkülgǝn ⱪenini ⱪobul ⱪilixⱪa aƣzini aqⱪan yǝrdin ⱪoƣlinip, lǝnǝtkǝ uqraysǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sǝn yǝrgǝ ixlisǝngmu u buningdin keyin sanga ⱪuwwitini bǝrmǝydu; sǝn yǝr yüzidǝ sǝrsan bolup, sǝrgǝrdan bolisǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Buni anglap Ⱪabil Pǝrwǝrdigarƣa jawab ⱪilip: — Mening bu jazayimni adǝm kɵtürǝlmigüdǝk! ");
INSERT INTO uigpin_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mana, Sǝn bügün meni yǝr yüzidin ⱪoƣliding, mǝn ǝmdi Sening yüzüngdin yoxurunup yürimǝn; yǝr yüzidǝ sǝrsǝn bolup sǝrgǝrdanliⱪta yürimǝn; xundaⱪ boliduki, kimla meni tepiwalsa, ɵltürüwetidu!, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Lekin Pǝrwǝrdigar uningƣa jawab berip: — Xundaⱪ boliduki, kimki Ⱪabilni ɵltürsǝ, uningdin yǝttǝ ⱨǝssǝ intiⱪam elinidu, — dedi. Xularni dǝp Pǝrwǝrdigar Ⱪabilƣa uqriƣan birsi uni ɵltürüwǝtmisun dǝp uningƣa bir bǝlgǝ ⱪoyup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Xuning bilǝn Ⱪabil Pǝrwǝrdigarning ⱨuzuridin qiⱪip, Erǝmning mǝxriⱪ tǝripidiki Nod degǝn yurtta olturaⱪlixip ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ⱪabil ayali bilǝn billǝ bolup, ayali ⱨamilidar bolup Ⱨanohni tuƣdi. U waⱪitta Ⱪabil bir xǝⱨǝr bina ⱪiliwatatti; u xǝⱨǝrning namini oƣlining ismi bilǝn Ⱨanoh dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ⱨanohtin Irad tɵrǝldi, Iradtin Mǝⱨuyail tɵrǝldi, Mǝⱨuyaildin Mǝtuxail tɵrǝldi, Mǝtuxaildin Lǝmǝh tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lǝmǝh ɵzigǝ ikki hotun aldi. Birining ismi Adaⱨ, yǝnǝ birining ismi Zillaⱨ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adaⱨ Yabalni tuƣdi. U qedirda olturidiƣan kɵqmǝn malqilarning bowisi idi, ");
INSERT INTO uigpin_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","uning inisining ismi Yubal idi. Bu qiltar bilǝn nǝy qalƣuqilarning bowisi idi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillaⱨ yǝnǝ Tubal-ⱪayin degǝn bir oƣulni tuƣdi. U mis-tɵmür ǝswablarni soⱪⱪuqi idi. Tubal-Ⱪayinning Naamaⱨ isimlik bir singlisi bar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lǝmǝh bolsa ayalliriƣa sɵz ⱪilip: — «Əy Adaⱨ bilǝn Zillaⱨ, sɵzümni anglanglar! Əy Lǝmǝhning ayalliri, gepimgǝ ⱪulaⱪ selinglar! Meni zǝhimlǝndürgini üqün mǝn adǝm ɵltürdüm, Tenimni zedǝ ⱪilƣanliⱪi üqün bir yigitni ɵltürdüm. ");
INSERT INTO uigpin_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Əgǝr Ⱪabil üqün yǝttǝ ⱨǝssǝ intiⱪam elinsa, Lǝmǝh üqün yǝtmix yǝttǝ ⱨǝssǝ intiⱪam elinidu!» — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adǝm’ata yǝnǝ ayali bilǝn billǝ boldi. Ayali bir oƣul tuƣup, uningƣa Xet dǝp at ⱪoyup: Ⱪabil Ⱨabilni ɵltürüwǝtkini üqün Huda uning orniƣa manga baxⱪa bir ǝwlad tiklǝp bǝrdi, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Xettinmu bir oƣul tuƣuldi; u uningƣa Enox dǝp at ⱪoydi. Xu waⱪittin tartip adǝmlǝr Pǝrwǝrdigarning namiƣa nida ⱪilixⱪa baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Bu Adǝm’atining ǝwladlirining nǝsǝbnamisidur: — Huda insanni yaratⱪan künidǝ, uni Ɵzigǝ ohxax ⱪilip yaratti.    ");
INSERT INTO uigpin_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","U ularni ǝr jinis wǝ ayal jinis ⱪilip yaritip, ularƣa bǝht-bǝrikǝt ata ⱪilip, yaritilƣan künidǝ ularning namini «adǝm» dǝp atidi.    ");
INSERT INTO uigpin_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adǝm’ata bir yüz ottuz yaxⱪa kirgǝndǝ uningdin ɵzigǝ ohxaydiƣan, ɵz sürǝt-obrazidǝk bir oƣul tɵrǝldi; u uningƣa Xet dǝp at ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Xet tuƣulƣandin keyin Adǝm’ata sǝkkiz yüz yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adǝm’atimiz jǝmiy toⱪⱪuz yüz ottuz yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Xet bir yüz bǝx yaxⱪa kirgǝndǝ uningdin Enox tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enox tuƣulƣandin keyin Xet sǝkkiz yüz yǝttǝ yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Xet jǝmiy toⱪⱪuz yüz on ikki yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enox toⱪsan yaxⱪa kirgǝndǝ uningdin Kenan tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan tuƣulƣandin keyin, Enox sǝkkiz yür on bǝx yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enox jǝmiy toⱪⱪuz yüz bǝx yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan yǝtmix yaxⱪa kirgǝndǝ uningdin Maⱨalalel tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Maⱨalalel tuƣulƣandin keyin Kenan sǝkkiz yüz ⱪiriⱪ yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan jǝmiy toⱪⱪuz yüz on yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maⱨalalel atmix bǝx yaxⱪa kirgǝndǝ uningdin Yarǝd tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yarǝd tuƣulƣandin keyin Maⱨalalel sǝkkiz yüz ottuz yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maⱨalalel jǝmiy sǝkkiz yüz toⱪsan bǝx yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yarǝd bir yüz atmix ikki yaxⱪa kirgǝndǝ uningdin Ⱨanoh tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ⱨanoh tuƣulƣandin keyin Yarǝd sǝkkiz yüz yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yarǝd jǝmiy toⱪⱪuz yüz atmix ikki yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ⱨanoh atmix bǝx yaxⱪa kirgǝndǝ uningdin Mǝtuxǝlaⱨ tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mǝtuxǝlaⱨ tuƣulƣandin keyin Ⱨanoh üq yüz yilƣiqǝ Huda bilǝn bir yolda mengip, yǝnǝ oƣul-ⱪizlarni tapti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ⱨanohning yǝr yüzidǝ barliⱪ kɵrgǝn künliri üq yüz atmix bǝx yil boldi; ");
INSERT INTO uigpin_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","U Huda bilǝn bir yolda mengip yaxaytti; u tuyuⱪsiz kɵzdin ƣayib boldi; qünki Huda uni Ɵz yeniƣa elip kǝtkǝnidi.    ");
INSERT INTO uigpin_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mǝtuxǝlaⱨ bir yüz sǝksǝn yǝttǝ yaxⱪa kirgǝndǝ uningdin Lǝmǝh tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lǝmǝh tuƣulƣandin keyin Mǝtuxǝlaⱨ yǝttǝ yüz sǝksǝn ikki yil ɵmür kɵrüp, uningdin oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mǝtuxǝlaⱨ jǝmiy toⱪⱪuz yüz atmix toⱪⱪuz yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","29","Lǝmǝh bir yüz sǝksǝn ikki yaxⱪa kirgǝndǝ bir oƣul tepip, uning ismini Nuⱨ atap: — Pǝrwǝrdigar tupraⱪⱪa lǝnǝt ⱪildi; xunga biz yǝrgǝ ixliginimizdǝ ⱨǝmdǝ ⱪollirimizning japaliⱪ ǝmgikidǝ bu bala bizgǝ tǝsǝlli beridu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuⱨ tuƣulƣandin keyin Lǝmǝh bǝx yüz toⱪsan bǝx yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lǝmǝh jǝmiy yǝttǝ yüz yǝtmix yǝttǝ yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuⱨ bǝx yüz yaxⱪa kirgǝndin keyin, uningdin Xǝm, Ⱨam wǝ Yafǝt tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wǝ xundaⱪ boldiki, insanlar yǝr yüzidǝ kɵpiyixkǝ baxliƣanda, xundaⱪla ⱪizlarmu kɵplǝp tuƣulƣanda, ");
INSERT INTO uigpin_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Hudaning oƣulliri insanlarning ⱪizlirining qirayliⱪliⱪini kɵrüp, haliƣanqǝ tallap, ɵzlirigǝ hotun ⱪilixⱪa baxlidi.    ");
INSERT INTO uigpin_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","U waⱪitta Pǝrwǝrdigar sɵz ⱪilip: — — Mening Roⱨim insanlar bilǝn mǝnggü kürǝx ⱪiliwǝrmǝydu; qünki insan ǝttur, halas. Kǝlgüsidǝ ularning ɵmri pǝⱪǝt bir yüz yigirmǝ yaxtin axmisun! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Xu künlǝrdǝ (wǝ xundaⱪla keyinki künlǝrdimu), Hudaning oƣulliri insanlarning ⱪizlirining yeniƣa berip, ulardin balilarni tapⱪinida, gigantlar yǝr yüzidǝ pǝyda boldi. Bular bolsa ⱪǝdimki zamanlardiki dangliⱪ palwan-baturlar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Pǝrwǝrdigar insanning ɵtküzüwatⱪan rǝzilliki yǝr yüzidǝ kɵpiyip kǝtkǝnlikini, ularning kɵnglidiki niyǝtlirining ⱨǝrⱪaqan yaman boluwatⱪinini kɵrdi.    ");
INSERT INTO uigpin_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Xuning bilǝn Pǝrwǝrdigar yǝr yüzidǝ adǝmni apiridǝ ⱪilƣiniƣa puxayman ⱪilip, kɵnglidǝ azablandi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Buning bilǝn Pǝrwǝrdigar: — Ɵzüm yaratⱪan insanni yǝr yüzidin yoⱪitimǝn — insandin tartip mal-qarwilarƣiqǝ, ɵmiligüqi ⱨaywanlardin asmandiki ⱪuxlarƣiqǝ, ⱨǝmmisini yoⱪ ⱪilimǝn; qünki Mǝn ularni yaratⱪinimƣa puxaymǝn ⱪildim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Lekin Nuⱨ bolsa Pǝrwǝrdigarning nǝziridǝ xǝpⱪǝt tapⱪanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuⱨ wǝ uning ix-izliri tɵwǝndikiqǝ: — Nuⱨ ⱨǝⱪⱪaniy, ɵz dǝwridikilǝr arisida ǝyibsiz adǝm idi; Nuⱨ Huda bilǝn bir yolda mengip yaxaytti.    ");
INSERT INTO uigpin_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuⱨtin Xǝm, Ⱨam, Yafǝt degǝn üq oƣul tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Pütkül jaⱨan Hudaning aldida rǝzillixip, ⱨǝmmǝ yǝr zorawanliⱪⱪa tolup kǝtkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Huda yǝr yüzigǝ nǝzǝr seliwidi, mana, jaⱨan rǝzillǝxkǝnidi; qünki barliⱪ ǝt igilirining yǝr yüzidǝ ⱪiliwatⱪini yuzuⱪqiliⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Xuning bilǝn Huda Nuⱨⱪa: — Mana, aldimƣa barliⱪ ǝt igilirining zawalliⱪi yetip kǝldi; qünki pütkül yǝr-jaⱨanni ularning sǝwǝbidin zorawanliⱪ ⱪaplidi. Mana, Mǝn ularni yǝr bilǝn ⱪoxup ⱨalak ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Əmdi sǝn ɵzünggǝ gofǝr yaƣiqidin bir kemǝ yasap, kemining iqidǝ bɵlmǝ-hanilarni ⱪilip, iqi-texini ⱪarimay bilǝn suwa. ");
INSERT INTO uigpin_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Sǝn uni xundaⱪ yasiƣin: — Uzunluⱪi üq yüz gǝz, kǝngliki ǝllik gǝz wǝ egizliki ottuz gǝz bolsun. ");
INSERT INTO uigpin_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kemining pexaywini astiƣa bir oquⱪqiliⱪ yasa, uning egizliki bir gǝz bolsun; ixikini kemining yeniƣa orunlaxtur; kemini asti, ottura wǝ üsti ⱪilip üq ⱪǝwǝt yasa. ");
INSERT INTO uigpin_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Qünki mana, Mǝn Ɵzüm asmanning astidiki ⱨayatliⱪ tiniⱪi barliki ⱨǝrbir ǝt igisini ⱨalak ⱪilidiƣan su topanni yǝr yüzigǝ kǝltürimǝn; buning bilǝn yǝr yüzidiki barliⱪ mǝhluⱪlar tiniⱪidin tohtaydu. ");
INSERT INTO uigpin_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Lekin sǝn bilǝn ǝⱨdǝmni tüzimǝn. Sǝn ɵzüng, oƣulliring, ayaling wǝ kelinliringni elip birliktǝ kemigǝ kiringlar. ");
INSERT INTO uigpin_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ɵzüng bilǝn tǝng tirik saⱪlap ⱪelix üqün, barliⱪ jandarlardin ⱨǝrⱪaysisidin bir jüp, yǝni ǝrkikidin birini, qixidin birini kemigǝ elip kirgin; ");
INSERT INTO uigpin_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tirik ⱪelix üqün ⱪuxlarning ⱨǝrbir türliridin, mal-qarwilarning ⱨǝrbir türliridin wǝ yǝrdǝ ɵmiligüqi janiwarlarning ⱨǝrbir türliridin bir jüpi ⱪexingƣa kiridu. ");
INSERT INTO uigpin_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ɵzüng wǝ ularning ozuⱪluⱪi üqün ⱨǝrhil yemǝkliklǝrdin elip, yeningƣa ƣǝmligin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuⱨ xundaⱪ ⱪildi; Huda ɵzigǝ buyruƣan ⱨǝmmǝ ixni u bǝja kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Pǝrwǝrdigar Nuⱨⱪa mundaⱪ dedi: — «Sǝn pütün ɵydikiliring bilǝn kemigǝ kirgin; qünki bu dǝwrdǝ aldimda seni ⱨǝⱪⱪaniy dǝp kɵrdüm. ");
INSERT INTO uigpin_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Ⱨǝmmǝ ⱨalal ⱨaywanlarning ǝrkǝk-qixisidin yǝttǝ jüptin, ⱨaram ⱨaywanlarning ǝrkǝk-qixisidin bir jüptin elip, xuningdǝk asmandiki uqar-ⱪanatlarningmu ǝrkǝk-qixisidin yǝttǝ jüptin elip, ularning nǝslini pütkül yǝr yüzidǝ tirik saⱪlax üqün ɵzüng bilǝn billǝ ǝkir.    ");
INSERT INTO uigpin_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Qünki yǝttǝ kündin keyin uda ⱪiriⱪ keqǝ-kündüz yǝr yüzigǝ yamƣur yaƣdurimǝn; Ɵzüm yasiƣan ⱨǝmmǝ janiwarlarni yǝr yüzidin yoⱪitimǝn». ");
INSERT INTO uigpin_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Xuning bilǝn Nuⱨ Pǝrwǝrdigar uningƣa buyruƣinining ⱨǝmmisigǝ ǝmǝl ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yǝr yüzini topan basⱪanda Nuⱨ altǝ yüz yaxta idi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Topandin ⱪutulup ⱪelix üqün Nuⱨ bilǝn oƣulliri, ayali wǝ kelinliri billǝ kemigǝ kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ⱨalal ⱨaywanlar bolsun, ⱨaram ⱨaywanlar bolsun, ⱪuxlar bilǝn yǝrdǝ ɵmiligüqi janiwarlar bolsun, ⱨǝrbir türdin bir jüp-bir jüptin ǝrkǝk-qixi bolup, Huda Nuⱨⱪa buyruƣandǝk kemigǝ, Nuⱨning ⱪexiƣa kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Wǝ xundaⱪ boldiki, yǝttǝ kündin keyin, yǝr yüzini topan besixⱪa baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuⱨning ɵmrining altǝ yüzinqi yili, ikkinqi eyining on yǝttinqi künidǝ qongⱪur dengizlarning tǝgliridiki barliⱪ bulaⱪlar yerilip, asmanning pǝnjiriliri eqilip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yamƣur uda ⱪiriⱪ keqǝ-kündüz yǝr yüzigǝ tohtimay yaƣdi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Dǝl yamƣur baxlanƣan küni, Nuⱨ, Nuⱨning Xǝm, Ⱨam, Yafǝt degǝn oƣulliri, Nuⱨning ayali bilǝn üq kelini kemigǝ kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ular bilǝn billǝ ⱨǝrhil yawa ⱨaywanlar tür-türi boyiqǝ, ⱨǝrhil mal-qarwilar tür-türi boyiqǝ, yǝrdǝ ɵmiligüqi ⱨǝrhil janiwarlar tür-türi boyiqǝ wǝ ⱨǝrhil uqar-ⱪanatlar, yǝni ⱨǝrhil ⱪanatliⱪ janiwarlar tür-türi boyiqǝ kemigǝ kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ət igiliridin, yǝni barliⱪ ⱨayatliⱪ tiniⱪi bolƣan ⱨǝrhil jandarlardin, bir jüp-bir jüp bolup, kemigǝ nuⱨning ⱪexiƣa kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kirgǝnlǝr Hudaning Nuⱨⱪa buyruƣinidǝk ǝt igilirining ⱨǝrtürining ǝrkǝk-qixisi idi. Andin Pǝrwǝrdigar ixikni etiwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Topan yǝr yüzini uda ⱪiriⱪ kün besip, sular ulƣiyip kǝtti. Kemǝ yǝr üstidin kɵtürülüp lǝylǝp ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Su ulƣiyip, yǝr üstidǝ tehimu egizlǝp kǝtti; kemǝ su üstidǝ dawalƣup turatti. ");
INSERT INTO uigpin_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Sular yǝr yüzidǝ tolimu ulƣiyip, pütkül asmanning astidiki barliⱪ egiz taƣlarnimu besip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Sular taƣlardin yǝnǝ on bǝx gǝz ɵrlǝp, taƣ qoⱪⱪilirimu su astida ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Buning bilǝn yǝr yüzidǝ yürgüqi ⱨǝmmǝ ǝt igiliri, uqar-ⱪuxlar, mal-qarwilar, yawayi ⱨaywanlar, yǝrdǝ ɵmiligüqi ⱨǝmmǝ janiwarlar, jümlidin pütkül adǝmlǝr ⱨǝmmisi ɵldi; ");
INSERT INTO uigpin_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ⱪuruⱪluⱪta yaxiƣuqi, burnida ⱨayatliⱪ tiniⱪi bar bolƣanlarning ⱨǝmmisi ɵldi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yǝr yüzidiki jeni barlarning ⱨǝmmisi, insan bolsun, mal-qarwilar bolsun, ɵmiligüqi ⱨaywanlar bolsun, asmandiki ⱪuxlar bolsun, ⱨǝmmisi ⱨalak bolup yǝr yüzidin yoⱪ ⱪilindi; pǝⱪǝt Nuⱨ wǝ kemidǝ uning bilǝn billǝ turƣanlar ⱪutulup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Bir yüz ǝllik küngiqǝ yǝr yüzini su besip turdi.    ");
INSERT INTO uigpin_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Huda Nuⱨni, xundaⱪla kemidǝ uning bilǝn billǝ bolƣan barliⱪ yawayi ⱨaywanlar bilǝn barliⱪ mal-qarwilarni ǝslidi. Xuning bilǝn Huda bir xamal qiⱪirip yǝr yüzini yǝlpütti wǝ sular yenixⱪa baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Qongⱪur dengizlarning tǝgliridiki bulaⱪlar wǝ asmanning pǝnjiriliri etilip, asmandin tɵkülgǝn yamƣur tohtidi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Sular barƣanseri yǝr yüzidin yandi; bir yüz ǝllik kün ɵtkǝndin keyin heli azlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yǝttinqi ayning on yǝttinqi küni, kemǝ Ararat taƣ tizmiliridiki birining üstidǝ tohtap ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Sular oninqi ayƣiqǝ barƣanseri aziyip, oninqi ayning birinqi küni taƣ qoⱪⱪiliri kɵrünüxkǝ baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ⱪiriⱪ kündin keyin Nuⱨ kemigǝ ɵzi ornatⱪan dǝrizini eqip, ");
INSERT INTO uigpin_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","bir ⱪuzƣunni sirtⱪa qiⱪardi. U yǝr yüzidiki sular tartilip bolƣuqǝ uyan-buyan uqup yürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Uningdin keyin Nuⱨ sularning yǝr yüzidin tartilƣan-tartilmiƣanliⱪini bilix üqün, bir kǝptǝrni qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Lekin sular tehiqǝ pütkül yǝr yüzini ⱪaplap turƣaqⱪa, kǝptǝr putini ⱪoyƣudǝk jay tapalmay, Nuⱨning ⱪexiƣa kemigǝ yenip kǝldi. Xuning bilǝn Nuⱨ ⱪolini sunup uni tutup, kemigǝ ǝkiriwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","U yǝttǝ kün saⱪlap, bu kǝptǝrni kemidin yǝnǝ sirtⱪa qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kǝptǝr kǝqtǝ uning ⱪexiƣa yenip kǝldi; mana, uning tumxuⱪida yengi üzüwalƣan zǝytun yopurmiⱪi bar idi. Buni kɵrüp Nuⱨ sularning yǝr yüzidin tartilƣinini bildi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","U yǝnǝ yǝttǝ kün saⱪlap, kǝptǝrni yǝnǝ sirtⱪa qiⱪardi, ǝmma bu ⱪetim kǝptǝr uning yeniƣa ⱪaytip kǝlmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuⱨ altǝ yüz bir yaxⱪa kirgǝn yili, birinqi ayning birinqi künidǝ su yǝr yüzidin ⱪuruƣanidi. Nuⱨ kemining ⱪapⱪiⱪini eqip ⱪariwidi, yǝrning ⱪuruƣinini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ikkinqi ayning yigirmǝ yǝttinqi küni, yǝr yüzi pütünlǝy ⱪurup boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","U waⱪitta Huda Nuⱨⱪa sɵz ⱪilip: — Sǝn ɵzüng, ayaling, oƣulliring wǝ kelinliring kemidin qiⱪinglar. ");
INSERT INTO uigpin_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ɵzüng bilǝn billǝ bolƣan barliⱪ ǝt igiliridin ⱨǝrbir türdiki janiwarlarni, yǝni uqar-ⱪanatlarni ⱨǝm mal-qarwilarni, yǝrdǝ ɵmiligüqi ⱨaywanlarning ⱨǝmmisini ɵzüng bilǝn ⱪoxup kemidin elip qiⱪⱪin; xuning bilǝn ular yǝr yüzidǝ tarilip-tarⱪilip, nǝsillinip zeminda kɵpǝysun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Xuning bilǝn Nuⱨ, ayali, oƣulliri wǝ kelinliri bilǝn billǝ sirtⱪa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Janiwarlarning ⱨǝmmisi, barliⱪ ɵmiligüqi ⱨaywanlar, barliⱪ uqar-ⱪanatlar, yǝrdǝ midirlap yüridiƣanlarning ⱨǝrⱪaysisi ɵz türliri boyiqǝ kemidin qiⱪixti. ");
INSERT INTO uigpin_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Xu qaƣda Nuⱨ Pǝrwǝrdigarƣa atap bir ⱪurbangaⱨni yasidi; u ⱨalal janiwarlar bilǝn ⱨalal ⱪuxlarning ⱨǝr türidin elip kelip, ⱪurbangaⱨning üstidǝ «kɵydürmǝ ⱪurbanliⱪ» ɵtküzdi.    ");
INSERT INTO uigpin_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Xundaⱪ ⱪilip Pǝrwǝrdigar huxbuy purap mǝmnun boldi; Pǝrwǝrdigar kɵnglidǝ: — «Insanning kɵngül-niyiti yaxliⱪidin tartip rǝzil bolsimu, Mǝn insan tüpǝylidin yǝrgǝ yǝnǝ lǝnǝt oⱪumaymǝn wǝ ǝmdi bu ⱪetimⱪidǝk ⱨǝmmǝ jandarlarni urup yoⱪitiwǝtmǝymǝn.    ");
INSERT INTO uigpin_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Bundin keyin, yǝr mǝwjut künliridǝ, Terix bilǝn orma, Soƣuⱪ bilǝn issiⱪ, Yaz bilǝn ⱪix, Kündüz bilǝn keqǝ üzülmǝy aylinip turidu» — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Huda Nuⱨ bilǝn uning oƣulliriƣa bǝht-bǝrikǝt ata ⱪilip, ularƣa mundaⱪ dedi: — «Silǝr jüplixip kɵpiyip, yǝr yüzini toldurunglar. ");
INSERT INTO uigpin_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Yǝr yüzidiki barliⱪ janiwarlar, asmandiki barliⱪ ⱪuxlar, barliⱪ yǝr yüzidǝ midirlap yürgüqilǝr wǝ dengizdiki barliⱪ beliⱪlarning ⱨǝmmisi silǝrdin ⱪorⱪup wǝⱨimidǝ bolsun; bular ⱪolunglarƣa tapxurulƣandur. ");
INSERT INTO uigpin_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Midirlap yüridiƣan ⱨǝrⱪandaⱪ janiwarlar silǝrgǝ ozuⱪ bolidu; Mǝn silǝrgǝ kɵk otyaxlarni bǝrgǝndǝk, bularning ⱨǝmmisini ǝmdi silǝrgǝ bǝrdim. ");
INSERT INTO uigpin_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Lekin silǝr gɵxni iqidiki jeni, yǝni ⱪeni bilǝn ⱪoxup yemǝslikinglar kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ⱪeninglar, yǝni jeninglardiki ⱪan tɵkülsǝ, Mǝn bǝrⱨǝⱪ uning ⱨesabini alimǝn; ⱨǝrⱪandaⱪ ⱨaywanning ilkidǝ ⱪeninglar bar bolsa Mǝn uningƣa tɵlǝtküzimǝn; insanning ⱪolida bar bolsa, yǝni birsining ⱪolida ɵz ⱪerindixining ⱪeni bar bolsa, Mǝn uningƣa xu ⱪanni tɵlǝtküzimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kimki insanning ⱪenini tɵksǝ, Uning ⱪenimu insan tǝripidin tɵkülidu; Qünki Huda insanni Ɵz sürǝt-obrazida yaratⱪandur. ");
INSERT INTO uigpin_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Əmdi silǝr, jüplixip kɵpiyip, yǝr yüzidǝ tarilip-tarⱪilip kɵpiyinglar». ");
INSERT INTO uigpin_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","9","Andin Huda Nuⱨ bilǝn uning oƣulliriƣa sɵz ⱪilip mundaⱪ dedi: — «Mana Ɵzüm silǝr bilǝn wǝ silǝrdin keyin kelidiƣan ǝwladliringlar bilǝn, xundaⱪla silǝr bilǝn billǝ turƣan ⱨǝrbir jan igisi, uqarⱪanatlar, mal-qarwilar, silǝr bilǝn billǝ turƣan yǝr yüzidiki ⱨǝrbir yawayi ⱨaywanlar, kemidin qiⱪⱪanlarning ⱨǝmmisi bilǝn — yǝr yüzidiki ⱨeqbir ⱨaywanni ⱪaldurmay, ular bilǝn Ɵz ǝⱨdǝmni tüzimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mǝn silǝr bilǝn xundaⱪ ǝⱨdǝ tüzimǝnki, nǝ barliⱪ ǝt igiliri topan bilǝn yoⱪitilmas, nǝ yǝrni wǝyran ⱪilidiƣan ⱨeqbir topan yǝnǝ kǝlmǝs». ");
INSERT INTO uigpin_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Huda yǝnǝ: — «Mǝn Ɵzüm silǝr bilǝn wǝ ⱪexinglardiki ⱨǝmmǝ jan igiliri bilǝn mǝnggülük, yǝni pütkül ǝwladliringlarƣiqǝ bekitkǝn muxu ǝⱨdǝmning bǝlgisi xuki: — Mana, Mǝn Ɵzüm bilǝn yǝrning otturisida bolƣan ǝⱨdining bǝlgisi bolsun dǝp ⱨǝsǝn-ⱨüsinimni bulutlar iqigǝ ⱪoyimǝn; ");
INSERT INTO uigpin_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","wǝ xundaⱪ boliduki, Mǝn yǝrning üstigǝ bulutlarni qiⱪarƣinimda, xundaⱪla ⱨǝsǝn-ⱨüsǝn bulutlar iqidǝ ayan bolƣinida, Mǝn silǝr bilǝn ǝt igiliri bolƣan barliⱪ janiwarlar bilǝn tüzgǝn ǝⱨdǝmni yad etimǝn; buningdin keyin sular ⱨǝrgiz ⱨǝmmǝ jandarlarni ⱨalak ⱪilƣuqi topan bolmas. ");
INSERT INTO uigpin_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ⱨǝsǝn-ⱨüsǝn bulutlar arisida pǝyda bolidu; Mǝn uningƣa ⱪaraymǝn wǝ xuning bilǝn Mǝnki Huda yǝr yüzidiki ǝt igiliri bolƣan barliⱪ janiwarlar bilǝn otturimizda bekitkǝn ǝⱨdǝmni yad etimǝn», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Huda Nuⱨⱪa yǝnǝ: — «Mana bu Mǝn Ɵzüm bilǝn yǝr yüzidiki barliⱪ ǝt igiliri otturisida bekitkǝn ǝⱨdǝmning nixan-bǝlgisidur», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuⱨning kemidin qiⱪⱪan oƣulliri Xǝm, Ⱨam wǝ Yafǝt idi. Ⱨam Ⱪanaanning atisi boldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Bu üqi Nuⱨning oƣulliri bolup, pütkül yǝr yüzigǝ taralƣan aⱨalǝ xularning nǝsil-ǝwladliridur. ");
INSERT INTO uigpin_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuⱨ teriⱪqiliⱪ ⱪilixⱪa baxlap, bir üzümzarliⱪ bǝrpa ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","U uning xarabidin iqip, mǝst bolup ⱪelip, ɵz qediri iqidǝ kiyim-keqǝklirini seliwetip, yalingaq yetip ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ⱪanaanning atisi Ⱨam kelip, atisining ǝwritini kɵrüp, sirtⱪa qiⱪip ikki ⱪerindixiƣa eytti. ");
INSERT INTO uigpin_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Xǝm bilǝn Yafǝt ⱪopup yepinjini elip, mürisigǝ artip, kǝyniqǝ mengip kirip, atisining yalingaq bǝdinini yepip ⱪoydi. Ular yüzini aldi tǝrǝpkǝ ⱪilip, atisining yalingaq tenigǝ ⱪarimidi. ");
INSERT INTO uigpin_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuⱨ xarabning kǝypidin oyƣinip, kǝnji oƣlining ɵzigǝ nemǝ ⱪilƣinini bilip: — ");
INSERT INTO uigpin_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ⱪanaanƣa lǝnǝt bolƣay! U ⱪerindaxlirining ⱪulining ⱪuli bolsun, — dǝp ⱪarƣidi. ");
INSERT INTO uigpin_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","U yǝnǝ: — Xǝmning Hudasi bolƣan Pǝrwǝrdigarƣa tǝxǝkkür-mǝdⱨiyǝ kǝltürülgǝy! Ⱪanaan Xǝmning ⱪuli bolsun. ");
INSERT INTO uigpin_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Huda Yafǝtni awutⱪay! U Xǝmning qedirlirida turƣay, Ⱪanaan bolsa uning ⱪuli bolƣay! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nuⱨ topandin keyin üq yüz ǝllik yil ɵmür kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Bu tǝriⱪidǝ Nuⱨ jǝmiy toⱪⱪuz yüz ǝllik yil kün kɵrüp, alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Tɵwǝndikilǝr Nuⱨning oƣullirining ǝwladliridur: — uning oƣulliri Xǝm, Ⱨam wǝ Yafǝt bolup, topandin keyin ulardin oƣullar tɵrǝlgǝn: —      ");
INSERT INTO uigpin_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafǝtning oƣulliri bolsa, Gomǝr, Magog, Maday, Yawan, Tubal, Mǝxǝk wǝ Tiras idi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomǝrning ǝwladliri: Axkinaz, Rifat wǝ Togarmaⱨ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawanning ǝwladliri: Elixaⱨ, Tarxix, Kittiylar wǝ Dodaniylar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Bularning ǝwladliri dengiz boylirida wǝ arallarda ayrim-ayrim yaxiƣan hǝlⱪlǝr bolup, ⱨǝrⱪaysisi ɵz tili, ɵz ailǝ-ⱪǝbililiri boyiqǝ ɵz zeminlirida tarⱪilip olturaⱪlaxⱪan. ");
INSERT INTO uigpin_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ⱨamning oƣulliri Kux, Misir, Put wǝ Ⱪanaanlar idi.    ");
INSERT INTO uigpin_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuxning oƣulliri Seba, Ⱨawilaⱨ, Sabtaⱨ, Raamaⱨ wǝ Sabtika idi. Raamaⱨning oƣulliri Xeba wǝ Dedan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuxtin yǝnǝ Nimrod tɵrǝlgǝn; u yǝr yüzidǝ naⱨayiti küqtünggür adǝm bolup qiⱪti.    ");
INSERT INTO uigpin_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","U Pǝrwǝrdigarning aldida küqtünggür owqi boldi; xu sǝwǝbtin «palanqi bolsa Nimrodtǝk, Pǝrwǝrdigarning aldida küqtünggür owqi ikǝn» degǝn gǝp tarⱪalƣan. ");
INSERT INTO uigpin_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Uning padixaⱨliⱪi Xinar zeminidiki Babil, Ərǝk, Akkad wǝ Kalnǝⱨ degǝn xǝⱨǝrlǝrdǝ baxlanƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","U bu zemindin Axur zeminiƣa qiⱪip Ninǝwǝ, Rǝⱨobot-Ir, Kalaⱨ wǝ Ninǝwǝ bilǝn Kalaⱨning otturisidiki Rǝsǝn degǝn xǝⱨǝrlǝrnimu bina ⱪildi (bular ⱪoxulup «Katta Xǝⱨǝr» boldi). ");
INSERT INTO uigpin_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirning ǝwladliri Ludiylar, Anamiylar, Lǝⱨabiylar, Naftuⱨiylar, ");
INSERT INTO uigpin_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrosiylar, Kasluⱨiylar (Filistiylǝr Kasluⱨiylardin qiⱪⱪan) wǝ Kaftoriylar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ⱪanaandin tunji oƣul Zidon tɵrilip, keyin yǝnǝ Ⱨǝt tɵrǝlgǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","uning ǝwladliri bolsa Yǝbusiylar, Amoriylar, Girgaxiylar, ");
INSERT INTO uigpin_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ⱨiwiylar, Arⱪiylar, Siniylar, ");
INSERT INTO uigpin_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadiylar, Zǝmariylar wǝ Ⱨamatiylar idi. Xuningdin keyin, Ⱪanaaniylarning ⱪǝbililiri ⱨǝr tǝrǝpkǝ tarⱪilip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ⱪanaaniylarning yurt qegrisi bolsa Zidondin tartip, Gǝrar tǝripigǝ sozulup, Gazaƣa qiⱪip, andin Sodom, Gomorra, Admaⱨ bilǝn Zǝboim tǝripigǝ tutixip, Lexaƣiqǝ yetip baratti. ");
INSERT INTO uigpin_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Yuⱪiriⱪilar bolsa ⱨamning oƣulliri bolup, ɵz ⱪǝbilisi wǝ tilliri boyiqǝ ⱪowm bolup ɵz zeminlirida olturaⱪlaxⱪanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Xǝmmu oƣul pǝrzǝntlik boldi; Xǝm bolsa Yafǝtning akisi, Ebǝrlǝrning ata-bowisi boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Xǝmning oƣulliri Elam, Axur, Arfahxad, Lud, Aram; ");
INSERT INTO uigpin_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramning oƣulliri Uz, Ⱨul, Gǝtǝr, Max idi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfahxadtin Xelaⱨ tɵrǝldi, Xelaⱨtin Ebǝr tɵrǝldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebǝrdin ikki oƣul tɵrǝlgǝn bolup, birining ismi Pǝlǝg idi, qünki u yaxiƣan dǝwrdǝ yǝr yüzidǝ bɵlünüx boldi; Pǝlǝgning inisining ismi Yoⱪtan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoⱪtandin Almodad, Xǝlǝf, Hazarmawǝt, Yeraⱨ, ");
INSERT INTO uigpin_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Ⱨadoram, Uzal, Diklaⱨ, ");
INSERT INTO uigpin_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimaǝl, Xeba, ");
INSERT INTO uigpin_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Ⱨawilaⱨ wǝ Yobab tɵrǝldi. Bularning ⱨǝmmisi Yoⱪtanning oƣulliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ularning olturƣan jayliri bolsa Mexadin tartip, Sǝffar degǝn rayonning xǝrⱪ tǝripidiki taƣⱪiqǝ sozulatti. ");
INSERT INTO uigpin_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yuⱪiriⱪilar bolsa Xǝmning oƣulliri bolup, ɵz ⱪǝbilisi wǝ tilliri boyiqǝ ⱪowm bolup ɵz zeminlirida olturaⱪlaxⱪanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yuⱪiridikilǝr Nuⱨning ǝwladliri bolup, ular ɵz nǝsǝbliri wǝ ⱪowmliri boyiqǝ hatirilǝngǝn. Topandin keyinki yǝr yüzidiki barliⱪ ⱪowmlar ularning iqidin tarⱪalƣan.    ");
INSERT INTO uigpin_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","U zamanda pütkül yǝr yüzidiki til ⱨǝm sɵz birhil idi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lekin xundaⱪ boldiki, adǝmlǝr mǝxriⱪ tǝrǝpkǝ sǝpǝr ⱪilip, Xinar yurtida bir tüzlǝnglikni uqritip, xu yǝrdǝ olturaⱪlaxti. ");
INSERT INTO uigpin_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ular bir-birigǝ: — Kelinglar, biz hix ⱪuyup, otta pixurayli! — deyixti. Xundaⱪ ⱪilip, ular ⱪuruluxta taxning orniƣa hix, layning orniƣa ⱪarimay ixlǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ular yǝnǝ: — Kelinglar, ǝmdi ɵzimizgǝ bir xǝⱨǝr bina ⱪilip, xǝⱨǝrdǝ uqi asmanlarƣa taⱪaxⱪudǝk bir munar yasayli! Xundaⱪ ⱪilip ɵzimizgǝ bir nam tikliyǝlǝymiz. Bolmisa, pütkül yǝr yüzigǝ tarilip ketimiz, — deyixti.    ");
INSERT INTO uigpin_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","U waⱪitta Pǝrwǝrdigar adǝm baliliri bina ⱪiliwatⱪan xǝⱨǝr bilǝn munarni kɵrgili qüxti. ");
INSERT INTO uigpin_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Pǝrwǝrdigar: — «Mana, bularning ⱨǝmmisi bir ⱪowmdur, ularning ⱨǝmmisining tilimu birdur; bu ularning ixining baxlinixidur! Bundin keyin ularning niyǝt ⱪilƣan ⱨǝrⱪandaⱪ ixini ⱨeq tosuwalƣili bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Xunga Biz tɵwǝngǝ qüxüp ularning bir-birining gǝplirini uⱪalmasliⱪi üqün ularning tilini baxⱪa-baxⱪa ⱪilip ⱪalaymiⱪanlaxturuwetǝyli» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Xundaⱪ ⱪilip Pǝrwǝrdigar ularni u jaydin pütkül yǝr yüzigǝ taritiwǝtti. Xuning bilǝn ular xǝⱨǝrni yasaxtin tohtap ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Xunga bu xǝⱨǝrning nami «Babil» dǝp ataldi; qünki u yǝrdǝ Pǝrwǝrdigar pütkül yǝr yüzidikilǝrning tilini ⱪalaymiⱪanlaxturuwǝtti. Xundaⱪ ⱪilip Pǝrwǝrdigar ularni u jaydin pütkül yǝr yüzigǝ taritiwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Tɵwǝndikilǝr Xǝmning ǝwladliridur: — topan ɵtüp ikki yildin keyin, Xǝm yüz yexida, uningdin Arfakxad tɵrǝldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arfakxad tuƣulƣandin keyin Xǝm bǝx yüz yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfakxad ottuz bǝx yaxⱪa kirgǝndǝ uningdin Xelaⱨ tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Xelaⱨ tuƣulƣandin keyin Arfakxad tɵt yüz üq yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Xelaⱨ ottuz yaxⱪa kirgǝndǝ uningdin Ebǝr tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebǝr tuƣulƣandin keyin Xelaⱨ tɵt yüz üq yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebǝr ottuz tɵt yaxⱪa kirgǝndǝ uningdin Pǝlǝg tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pǝlǝg tuƣulƣandin keyin Ebǝr tɵt yüz ottuz yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pǝlǝg ottuz yaxⱪa kirgǝndǝ uningdin Rǝu tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Rǝu tuƣulƣandin keyin Pǝlǝg ikki yüz toⱪⱪuz yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rǝu ottuz ikki yaxⱪa kirgǝndǝ uningdin Serug tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug tuƣulƣandin keyin Rǝu ikki yüz yǝttǝ yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug ottuz yaxⱪa kirgǝndǝ uningdin Naⱨor tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naⱨor tuƣulƣandin keyin Serug ikki yüz yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naⱨor yigirmǝ toⱪⱪuz yaxⱪa kirgǝndǝ uningdin Tǝraⱨ tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tǝraⱨ tuƣulƣandin keyin Naⱨor bir yüz on toⱪⱪuz yil ɵmür kɵrüp, uningdin yǝnǝ oƣul-ⱪizlar tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tǝraⱨ yǝtmix yaxⱪa kirgǝndǝ uningdin Abram, Naⱨor wǝ Ⱨaran tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tǝraⱨning ǝwladliri tɵwǝndikiqǝ: — Tǝraⱨtin Abram, Naⱨor wǝ Ⱨaran tɵrǝldi; Ⱨarandin Lut tɵrǝldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Lekin Ⱨaran tuƣulƣan yurti bolƣan, kaldiylǝrning Ur xǝⱨiridǝ atisi Tǝraⱨning aldida, Tǝraⱨtin ilgiri ɵldi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram bilǝn Naⱨor ikkisi ɵylǝndi. Abramning ayalining ismi Saray, Naⱨorning ayalining ismi Milkaⱨ idi; Milkaⱨ Ⱨaranning ⱪizi idi; Ⱨaran bolsa Milkaⱨ wǝ Iskaⱨning atisi idi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Lekin Saray tuƣmas bolƣaqⱪa, uning balisi yoⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tǝraⱨ bolsa oƣli Abramni, nǝwrisi Lut (Ⱨaranning oƣli)ni wǝ kelini, yǝni Abramning ayali Sarayni elip, Ⱪanaan zeminiƣa berix üqün kaldiylǝrning Ur xǝⱨiridin yolƣa qiⱪti; biraⱪ ular Ⱨaran degǝn jayƣa yetip kǝlgǝndǝ, xu yǝrdǝ olturaⱪlixip ⱪaldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tǝraⱨning kɵrgǝn künliri ikki yüz bǝx yil bolup, Ⱨaranda alǝmdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Pǝrwǝrdigar ǝslidǝ Abramƣa mundaⱪ degǝnidi: — Sǝn ɵz yurtungdin, ɵz uruⱪ-tuƣⱪanliringdin wǝ ɵz ata jǝmǝtingdin ayrilip, Mǝn sanga kɵrsitidiƣan zeminƣa barƣin. ");
INSERT INTO uigpin_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Xundaⱪ ⱪilsang Mǝn seni uluƣ bir hǝlⱪ ⱪilip, sanga bǝht-bǝrikǝt ata ⱪilip, namingni uluƣ ⱪilimǝn; xuning bilǝn sǝn ɵzüng baxⱪilarƣa bǝht-bǝrikǝt bolƣin; ");
INSERT INTO uigpin_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","kimlǝr sanga bǝht-bǝrikǝt tilisǝ Mǝn ularni bǝrikǝtlǝymǝn, kimki seni horlisa, Mǝn qoⱪum uni lǝnǝtkǝ ⱪaldurimǝn; sǝn arⱪiliⱪ yǝr yüzidiki barliⱪ ailǝ-ⱪǝbililǝrgǝ bǝht-bǝrikǝt ata ⱪilinidu! — dedi.      ");
INSERT INTO uigpin_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram Pǝrwǝrdigar uningƣa eytⱪini boyiqǝ Ⱨarandin ayrildi; Lutmu uning bilǝn billǝ mangdi. Abram Ⱨarandin qiⱪⱪinida yǝtmix bǝx yaxta idi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram ayali Saray bilǝn inisining oƣli Lutni elip, ularning yiƣⱪan barliⱪ mal-mülükini ⱪoxup, Ⱨaranda igidarqiliⱪ ⱪilƣan adǝmlǝrni billǝ ⱪetip, Ⱪanaan zeminiƣa berix üqün yolƣa qiⱪti; xundaⱪ ⱪilip ular Ⱪanaan zeminiƣa yetip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram zeminni kezip, Xǝkǝm degǝn jaydiki «Morǝⱨning dub dǝrihi»ning yeniƣa kǝldi (u qaƣda u zeminda Ⱪanaaniylar turatti). ");
INSERT INTO uigpin_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Pǝrwǝrdigar Abramƣa kɵrünüp, uningƣa: — Mǝn bu zeminni sening nǝslinggǝ ata ⱪilimǝn, — dedi. Xuning bilǝn u xu yǝrdǝ ɵzigǝ kɵrüngǝn Pǝrwǝrdigarƣa atap bir ⱪurbangaⱨ saldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Andin u bu yǝrdin yɵtkilip, Bǝyt-Əlning xǝrⱪidiki taƣⱪa bardi; ƣǝrb tǝripidǝ Bǝyt-Əl, xǝrⱪ tǝripidǝ Ayi degǝn jay bar idi; u xu yǝrdǝ qedir tikti. U xu yǝrdǝ Pǝrwǝrdigarƣa atap bir ⱪurbangaⱨ yasap, Pǝrwǝrdigarning namini qaⱪirip ibadǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Andin keyin Abram tǝdrijiy kɵqüp, jǝnubidiki Nǝgǝw rayoniƣa ⱪarap yɵtkǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Zeminda aqarqiliⱪ bolƣanidi; Abram Misirƣa qüxti; u xu yǝrdǝ waⱪtinqǝ turmaⱪqi bolƣanidi, qünki zeminda aqarqiliⱪ bǝk eƣir idi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Əmma xundaⱪ boldiki, u Misirƣa yeⱪinlaxⱪanda, ayali Sarayƣa: — Mana, mǝn sening ⱨɵsün-jamalingning güzǝllikini bilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Xundaⱪ boliduki, misirliⱪlar seni kɵrsǝ, «Bu uning ayali ikǝn» dǝp, meni ɵltürüwetip, seni tirik ⱪalduridu. ");
INSERT INTO uigpin_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Xuning üqün sening: «Mǝn uning singlisi» deyixingni ɵtinimǝn. Xundaⱪ ⱪilsang, mǝn seningdin yahxiliⱪ tepip, sǝn arⱪiliⱪ tirik ⱪalimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram Misirƣa kirgǝndǝ xundaⱪ boldiki, misirliⱪlar dǝrwǝⱪǝ ayalning güzǝl ikǝnlikini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pirǝwnning ǝmirlirimu uni kɵrüp, Pirǝwngǝ uning tǝripini ⱪildi; xuning bilǝn ayal Pirǝwnning ordisiƣa elip kirildi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pirǝwn Sarayning sǝwǝbidin Abramƣa yahxi muamilǝ ⱪildi; xuning bilǝn u ⱪoy, kala, ⱨangga exǝklǝr, ⱪul-dedǝklǝr, mada exǝklǝr wǝ tɵgilǝrgǝ erixti. ");
INSERT INTO uigpin_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Əmma Pǝrwǝrdigar Pirǝwn wǝ ɵyidikilirini Abramning ayali Sarayning sǝwǝbidin tolimu eƣir wabalarƣa muptila ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Xuning üqün Pirǝwn Abramni qaⱪirip uningƣa: — «Bu zadi sening manga nemǝ ⱪilƣining? Nemixⱪa uning ɵz ayaling ikǝnlikini manga eytmiding? ");
INSERT INTO uigpin_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nemixⱪa uni «singlim» dǝp mening uni hotunluⱪⱪa eliximƣa sǝwǝbkar bolƣili tas ⱪalisǝn! Mana bu ayaling! Uni elip kǝtkin! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pirǝwn ɵz adǝmlirigǝ Abram toƣrisida ǝmr ⱪildi; ular uni, ayalini wǝ uning barliⱪini ⱪoxup yolƣa seliwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Xuning bilǝn Abram ayali wǝ uning barliⱪ nǝrsilirini ⱨǝmdǝ Lutni elip Misirdin qiⱪip, Ⱪanaanning jǝnubidiki Nǝgǝw yurtiƣa mangdi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","U qaƣda Abramning mal-waran wǝ altun-kümüxliri kɵp bolup, helila bay idi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","U kɵqüp yürüp, jǝnubtiki Nǝgǝwdin Bǝyt-Əlgǝ, yǝni Bǝyt-Əl bilǝn Ayining otturisidiki ǝslidǝ qedir tikkǝn jayƣa, ");
INSERT INTO uigpin_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ⱪurbangaⱨ yasiƣan jayƣa ⱪaytip kǝldi. Abram xu yǝrdǝ Pǝrwǝrdigarning namini qaⱪirip ibadǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abram bilǝn billǝ mangƣan Lutningmu ⱪoy-kala padiliri wǝ qedirliri bar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Əmdi ular billǝ tursa, zemin ularni ⱪamdiyalmaytti; ");
INSERT INTO uigpin_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","bu sǝwǝbtin Abramning padiqiliri bilǝn Lutning padiqilirining arisida jedǝl qiⱪti (u waⱪitta Ⱪanaaniylar bilǝn Pǝrizziylǝr xu zeminda turatti).    ");
INSERT INTO uigpin_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Xunga Abram Lutⱪa: — «Biz bolsaⱪ ⱪerindaxlarmiz, sǝn bilǝn mening aramda, mening padiqilirim bilǝn sening padiqiliring arisida talax-tartix pǝyda bolmisun. ");
INSERT INTO uigpin_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mana, aldingda pütkül zemin turmamdu? Əmdi sǝn mǝndin ayrilƣin; ǝgǝr sǝn sol tǝrǝpkǝ barsang, mǝn ong tǝrǝpkǝ baray; ǝgǝr sǝn ong tǝrǝpkǝ barsang, mǝn sol tǝrǝpkǝ baray», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","U waⱪitta Lut nǝzǝr selip kɵrdiki, Iordan wadisidiki barliⱪ tüzlǝnglikning Zoar xǝⱨirigiqǝ ⱨǝmmila yǝrning süyi intayin mol idi; Pǝrwǝrdigar Sodom bilǝn Gomorrani wǝyran ⱪilixtin ilgiri bu yǝr bǝǝyni Pǝrwǝrdigarning beƣi, Misir zeminidǝk idi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Xuning bilǝn Lut ɵzigǝ Iordan wadisidiki pütkül tüzlǝnglikni talliwaldi; andin Lut mǝxriⱪ tǝrǝpkǝ kɵqüp bardi. Xundaⱪ ⱪilip ikkiylǝn ayrildi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram Ⱪanaan zeminida olturaⱪlaxti; Lut bolsa tüzlǝngliktiki xǝⱨǝrlǝrning arisida turdi; u bara-bara qedirlirini Sodom xǝⱨiri tǝrǝpkǝ yɵtkidi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom hǝlⱪi rǝzil adǝmlǝr bolup, Pǝrwǝrdigarning nǝziridǝ tolimu eƣir gunaⱨkarlar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut Abramdin ayrilip kǝtkǝndin keyin, Pǝrwǝrdigar Abramƣa: — Sǝn ǝmdi bexingni kɵtürüp, ɵzüng turƣan jaydin ximal wǝ jǝnubⱪa, mǝxriⱪ wǝ mǝƣrib tǝrǝpkǝ ⱪariƣin; ");
INSERT INTO uigpin_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","qünki sǝn ⱨazir kɵrüwatⱪan bu barliⱪ zeminni sanga wǝ nǝslinggǝ mǝnggülük berimǝn.    ");
INSERT INTO uigpin_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Sening nǝslingni yǝrdiki topidǝk kɵp ⱪilimǝn; xundaⱪki, ǝgǝr birsi yǝrdiki topini sanap qiⱪalisa, sening nǝslingnimu sanap qiⱪalixi mumkin bolidu. ");
INSERT INTO uigpin_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ornungdin tur, bu zeminni uzunluⱪi wǝ kǝngliki boyiqǝ aylinip qiⱪⱪin; qünki Mǝn uni sanga ata ⱪilimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Xunga Abram qedirlirini yɵtkǝp, Ⱨebron xǝⱨirigǝ yeⱪin Mamrǝdiki dubzarliⱪning yeniƣa berip olturaⱪlaxti; u xu yǝrdǝ Pǝrwǝrdigarƣa atap bir ⱪurbangaⱨ yasidi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Xinarning padixaⱨi Amrafǝl, Əllasarning padixaⱨi Arioⱪ, Elamning padixaⱨi Kedorlayomǝr wǝ Goyimning padixaⱨi Tidalning künliridǝ xu wǝⱪǝ boldiki, ");
INSERT INTO uigpin_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ular birlixip Sodomning padixaⱨi Bera, Gomorraning padixaⱨi Birxa, Admaⱨning padixaⱨi Xinab, Zǝboimning padixaⱨi Xǝm’ebǝr wǝ Bela (yǝni Zoar)ning padixaⱨiƣa ⱪarxi ⱨujumƣa atlandi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bu bǝxining ⱨǝmmisi kelixip Siddim wadisiƣa, yǝni «Xor Dengizi» wadisiƣa yiƣildi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ular on ikki yil Kedorlayomǝrgǝ beⱪindi boldi, on üqinqi yilƣa kǝlgǝndǝ, Kedorlayomǝrgǝ ⱪarxi isyan kɵtürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","On tɵtinqi yili Kedorlayomǝr wǝ uningƣa ittipaⱪdax bolƣan padixaⱨlar ⱨǝmmisi yiƣilip, Axtarot-Karnaim degǝn yǝrdǝ Rǝfayiylarƣa, xundaⱪla Ⱨam degǝn yǝrdǝ Zuziylarƣa, Xawǝⱨ-Kiriatayimda Emiylarƣa ⱨujum ⱪilip ularni yǝngdi; ");
INSERT INTO uigpin_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","andin ular Ⱨoriylarni ularning Seir teƣida mǝƣlup ⱪilip, qɵlning yenidiki Əl-Paranƣiqǝ sürüp-toⱪay ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Arⱪidinla, ular Ən-Mixpatⱪa (yǝni Ⱪadǝxkǝ) yenip kelip, Amalǝklǝrning pütkül yurtini bulang-talang ⱪildi; Ⱨazazon-Tamarda olturuxluⱪ Amoriylarnimu ⱨujum ⱪilip mǝƣlup ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Xuning bilǝn Sodomning padixaⱨi, Gomorraning padixaⱨi, Admaⱨning padixaⱨi, Zǝboimning padixaⱨi wǝ Belaning (yǝni Zoarning) padixaⱨi qiⱪip, Siddim wadisida ularƣa ⱪarxi jǝng ⱪilixⱪa sǝp tizdi; ");
INSERT INTO uigpin_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","muxu bǝxǝylǝn Elamning padixaⱨi Kedorlayomǝr, Goyimning padixaⱨi Tidal, Xinarning padixaⱨi Amrafǝl, Əllasarning padixaⱨi Arioⱪ ⱪatarliⱪlar bilǝn soⱪuxti; yǝni tɵt padixaⱨ bilǝn bǝx padixaⱨ ɵzara soⱪuxti. ");
INSERT INTO uigpin_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddim wadisidiki ⱨǝmmila yǝrdǝ ⱪarimay orǝkliri bar idi. Sodom wǝ Gomorraning padixaⱨliri ⱪeqip, orǝklǝrgǝ qüxüp kǝtti. Əmma ⱪalƣanlar bolsa taƣⱪa ⱪeqip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ƣalib kǝlgǝn tɵt padixaⱨ bolsa Sodom bilǝn Gomorraning ⱨǝmmǝ mal-mülkini wǝ barliⱪ ozuⱪ-tülükini elip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ular yǝnǝ Abramning jiyǝni Lutnimu malliri bilǝn ⱪoxup elip kǝtti; qünki u Sodomda olturaⱪlaxⱪanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ⱨalbuki, ⱪutulup ⱪalƣan birsi berip bu ixlarni ibraniy Abramƣa eytti. Xu qaƣda u Amoriy Mamrǝning dubzarliⱪining yenida turatti. Mamrǝ bolsa Əxkol wǝ Anǝrning akisi idi; bu üqǝylǝn Abram bilǝn ittipaⱪdax idi.    ");
INSERT INTO uigpin_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram ⱪerindixining ǝsir bolup ⱪalƣanliⱪini anglap, ɵz ɵyidǝ tuƣulƣan, alaⱨidǝ tǝrbiyilǝngǝn üq yüz on sǝkkiz adǝmni baxlap qiⱪip, tɵt padixaⱨni ⱪoƣlap danƣiqǝ bardi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Keqisi u adǝmlirini guruppilarƣa bɵlüp, ular bilǝn birliktǝ ⱨujum ⱪilip ularni mǝƣlup ⱪilip, ularni Dǝmǝxⱪning ximal tǝripidiki Ⱨobaⱨ degǝn jayƣiqǝ ⱪoƣlap berip, ");
INSERT INTO uigpin_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","pütkül olja alƣan mal-mülükni ⱪayturuwaldi; ɵz ⱪerindixi Lutni, uning mal-mülki wǝ hotun-ⱪizlirini, xundaⱪla barliⱪ ⱪalƣan adǝmlǝrni yandurup kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram Kedorlayomǝr wǝ uning bilǝn ittipaⱪdax padixaⱨlarni mǝƣlup ⱪilip, ⱪaytip kǝlgǝndǝ, Sodomning padixaⱨi Xawǝⱨ wadisi (yǝni Han wadisi)ƣa uning aldiƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salemning padixaⱨi Mǝlkizǝdǝkmu nan bilǝn xarab elip aldiƣa qiⱪti. U zat bolsa, Ⱨǝmmidin Aliy Tǝngrining kaⱨini idi;    ");
INSERT INTO uigpin_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","u Abramni bǝht-bǝrikǝtlǝp: — «Abram asman bilǝn zeminning Igisi bolƣan Ⱨǝmmidin Aliy Tǝngri tǝripidin bǝrikǝtlǝnsun! ");
INSERT INTO uigpin_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Xundaⱪla düxmǝnliringni ɵz ⱪolungƣa tapxurƣan Ⱨǝmmidin Aliy Tǝngrigǝ Ⱨǝmdusana oⱪulƣay!» — dedi. Abram bolsa ƣǝniymǝt alƣan nǝrsilǝrning ondin birini uningƣa bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Andin Sodomning padixaⱨi Abramƣa: — Adǝmlǝrni manga bǝrgǝyla, ƣǝniymǝtlǝrni ɵzlirigǝ alƣayla, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Lekin Abram Sodomning padixaⱨiƣa jawab berip: — Mǝn bolsam asman bilǝn zeminning Igisi bolƣan Ⱨǝmmidin Aliy Tǝngri Pǝrwǝrdigarƣa ⱪol kɵtürüp ⱪǝsǝm ⱪilƣanmǝnki, ");
INSERT INTO uigpin_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mǝn sǝndin ⱨǝtta bir tal yip nǝ bir tal boƣⱪuqinimu nǝ sening baxⱪa ⱨǝrⱪandaⱪ nǝrsǝngni almaymǝn; bolmisa, sǝn keyin: «mǝn Abramni bay ⱪilip ⱪoydom» deyixing mumkin. ");
INSERT INTO uigpin_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Xunga yigitlirimning yegǝn-iqkini, xundaⱪla manga ⱨǝmraⱨ bolƣanlar, yǝni Anǝr, Əxkol wǝ Mamrǝlǝrgǝ tegixlik ülüxtin baxⱪa, mǝn ƣǝniymǝttin ⱨeqnǝrsǝ almaymǝn; xular ɵzlirigǝ tegixlik ülüxini alsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bu ixlardin keyin Pǝrwǝrdigarning sɵz-kalami Abramƣa alamǝt kɵrünüxtǝ kelip: «Əy Abram, ⱪorⱪmiƣin; Mǝn Ɵzüm ⱪalⱪining wǝ zor in’amingdurmǝn» — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Lekin Abram: — Əy Rǝb Pǝrwǝrdigar, manga nemǝ berisǝn? Mana, mǝn balisiz tursam, ɵy-bisatlirimƣa warisliⱪ ⱪilƣuqi muxu Dǝmǝxⱪlik Əliezǝrla bardur, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram yǝnǝ: Mana, Sǝn manga ⱨeq nǝsil bǝrmiding, mana ɵyümdǝ turuwatⱪanlardin biri manga waris bolidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Xu ⱨaman Pǝrwǝrdigarning sɵz-kalami uningƣa kelip: «Bu kixi sanga waris bolmaydu, bǝlki ɵz puxtungdin bolidiƣan kixi sanga waris bolidu», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Xuning bilǝn Pǝrwǝrdigar uni taxⱪiriƣa elip qiⱪip: — Əmdi asmanƣa ⱪarap yultuzlarni sana — Ⱪeni, ularni saniyalamsǝnkin?! — dedi. Andin uningƣa: — Sening nǝslingmu xundaⱪ bolidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram Pǝrwǝrdigarƣa ixǝndi; Pǝrwǝrdigar uningdiki bu ixǝnqni uning ⱨǝⱪⱪaniyliⱪi dǝp ⱨesablidi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yǝnǝ uningƣa: Mǝn bu zeminƣa igǝ ⱪilixⱪa seni Kaldiyǝdiki Ur xǝⱨiridin elip qiⱪⱪan Pǝrwǝrdigardurmǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Lekin Abram: — I Rǝb Pǝrwǝrdigar, mǝn uningƣa jǝzmǝn igǝ bolidiƣinimni ⱪandaⱪ bilimǝn? — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Pǝrwǝrdigar uningƣa: — Mǝn üqün üq yaxliⱪ bir inǝk, üq yaxliⱪ bir qixi ɵqkǝ, üq yaxliⱪ bir ⱪoqⱪar bilǝn bir kǝptǝr wǝ bir bajka elip kǝlgin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Xunga u bularning ⱨǝmmisini elip, ularning ⱨǝrbirsini yerimdin ikki parqǝ ⱪilip, yerimini yǝnǝ bir yerimiƣa udulmu’udul ⱪilip ⱪoyup ⱪoydi; ǝmma ⱪuxlarni parqilimidi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ⱪaƣa-ⱪuzƣunlar taplarning üstigǝ qüxkǝndǝ, Abram ularni ürkütüp ⱨǝydiwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Lekin kün patay degǝndǝ, Abramni eƣir bir uyⱪu basti wǝ mana, uning üstigǝ dǝⱨxǝtlik bir wǝⱨimǝ, tum ⱪarangƣuluⱪ qüxti. ");
INSERT INTO uigpin_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Andin Pǝrwǝrdigar Abramƣa: — Jǝzmǝn bilixing kerǝkki, sening nǝsling ɵzlirining bolmiƣan bir zeminda musapir bolup, xu yǝrdiki hǝlⱪning ⱪulluⱪida bolidu wǝ xundaⱪla, bu hǝlⱪ ularƣa tɵt yüz yilƣiqǝ jǝbir-zulum salidu.    ");
INSERT INTO uigpin_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Lekin Mǝn ularni ⱪulluⱪⱪa salƣuqi xu taipining üstidin ⱨɵküm qiⱪirimǝn. Keyin ular nurƣun bayliⱪlarni elip xu yǝrdin qiⱪidu. ");
INSERT INTO uigpin_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Əmma sǝn bolsang, aman-hatirjǝmlik iqidǝ ata-bowiliringƣa ⱪoxulisǝn; uzun ɵmür kɵrüp andin dǝpnǝ ⱪilinisǝn.    ");
INSERT INTO uigpin_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Lekin xu yǝrdǝ tɵt ǝwlad ɵtüp, nǝsling bu yǝrgǝ yenip kelidu; qünki Amoriylarning ⱪǝbiⱨlikining zihi tehi toxmidi, dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Xundaⱪ boldiki, kün petip ⱪarangƣu bolƣanda, mana, gɵxlǝrning otturisidin ɵtüp ketiwatⱪan, is-tütǝk qiⱪip turƣan bir otdan bilǝn yalⱪunluⱪ bir mǝx’ǝl kɵründi. ");
INSERT INTO uigpin_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","19","Dǝl xu küni Pǝrwǝrdigar Abram bilǝn ǝⱨdǝ tüzüp uningƣa: — «Mǝn sening nǝslinggǝ bu zeminni Misirning eⱪinidin tartip Uluƣ dǝrya, yǝni Əfrat dǝryasiƣiqǝ berimǝn; yǝni Keniylǝr, Kǝnizziylar, Kadmoniylar, ");
INSERT INTO uigpin_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Ⱨittiylar, Pǝrizziylǝr, Rǝfayiylar, ");
INSERT INTO uigpin_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoriylar, Ⱪanaaniylar, Girgaxiylar wǝ Yǝbusiylarning yurtini ularningki ⱪilimǝn» dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Əmma Abramning ayali Saray uningƣa ⱨeq bala tuƣup bǝrmidi; lekin uning Ⱨǝjǝr isimlik misirliⱪ bir dediki bar idi; ");
INSERT INTO uigpin_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saray Abramƣa: — Mana, Pǝrwǝrdigar meni tuƣuxtin tosti. Əmdi sǝn mening dedikimning ⱪexiƣa kirgin; bǝlkim u arⱪiliⱪ ana bolup tiklinixim mumkin, — dedi. Abram bolsa Sarayning sɵzini ⱪobul kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Xuning bilǝn Abramning ayali Saray dediki misirliⱪ Ⱨǝjǝrni ɵz eri Abramƣa toⱪalliⱪⱪa apirip bǝrdi (u waⱪitta Abram Ⱪanaan zeminida on yil olturƣanidi). ");
INSERT INTO uigpin_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram Ⱨǝjǝrning ⱪexiƣa kirdi wǝ u ⱨamilidar boldi. Əmma u ɵzining ⱨamilidar bolƣinini bilginidǝ, u ayal hojayinini kɵzgǝ ilmas bolup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saray Abramƣa ⱪeyidap: — Manga qüxkǝn bu horluⱪ sening bexingƣa qüxsun! Mǝn ɵz dedikimni ⱪuqiⱪingƣa selip bǝrdim; ǝmdi u ɵzining ⱨamilidar bolƣinini kɵrgǝndǝ mǝn uning nǝziridǝ kɵzgǝ ilinmidim. Hǝyr, Pǝrwǝrdigar sǝn bilǝn mening otturimizda ⱨɵküm qiⱪarsun! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram Sarayƣa: — Mana, dediking ɵz ⱪolungdidur; sanga nemǝ layiⱪ kɵrünsǝ uningƣa xuni ⱪilƣin, — dedi. Buning bilǝn Saray uningƣa ⱪattiⱪliⱪ ⱪilixⱪa baxlidi; buning bilǝn u uning aldidin ⱪeqip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Əmma Pǝrwǝrdigarning Pǝrixtisi uni qɵldiki bir bulaⱪning yenida, yǝni Xur yolining boyidiki bulaⱪning yenidin tepip, uningƣa: ");
INSERT INTO uigpin_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Əy Sarayning dediki Ⱨǝjǝr, nǝdin kǝlding, nǝgǝ barisǝn? — dǝp soridi. U jawab berip: — Mǝn hojayinim Sarayning aldidin ⱪeqip qiⱪtim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Pǝrwǝrdigarning Pǝrixtisi uningƣa: — Ayal hojayiningning ⱪexiƣa ⱪaytip berip, uning ⱪol astida bol, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Pǝrwǝrdigarning Pǝrixtisi uningƣa yǝnǝ: — Sening nǝslingni xundaⱪ awutimǝnki, kɵplükidin uni sanap bolƣili bolmaydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Andin Pǝrwǝrdigarning Pǝrixtisi uningƣa: Mana, sǝn ⱨamilidarsǝn; sǝn bir oƣul tuƣup, uningƣa Ismail dǝp at ⱪoyƣin; qünki Pǝrwǝrdigar sening jǝbir-japayingni anglidi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","U yawa exǝk kǝbi bir adǝm bolidu; uning ⱪoli ⱨǝr adǝmgǝ ⱪarxi uzitilidu, xuningdǝk ⱨǝr adǝmning ⱪoli uningƣa ⱪarxi uzitilidu; u ⱪerindaxlirining udulida ayrim turidu, dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ⱨǝjǝr ɵz-ɵzigǝ: «Mǝn muxu yǝrdǝ meni Kɵrgüqini arⱪisidin kɵrdüm» dǝp, ɵzigǝ sɵz ⱪilƣan Pǝrwǝrdigarni: «Sǝn meni kɵrgüqi Tǝngridursǝn» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Xuning bilǝn u ⱪuduⱪ: «Bǝǝr-laⱨay-roy» dǝp ataldi. U Ⱪadǝx bilǝn Bǝrǝd xǝⱨirining ariliⱪididur.    ");
INSERT INTO uigpin_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ⱨǝjǝr Abramƣa bir oƣul tuƣup bǝrdi. Abram Ⱨǝjǝr uningƣa tuƣup bǝrgǝn oƣliƣa Ismail dǝp at ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ⱨǝjǝr Abramƣa Ismailni tuƣup bǝrgǝndǝ Abram sǝksǝn altǝ yaxta idi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram toⱪsan toⱪⱪuz yaxⱪa kirgǝndǝ, Pǝrwǝrdigar Abramƣa kɵrünüp uningƣa: — Mǝn Ⱪadir Tǝngridurmǝn. Sǝn Mening aldimda mengip, kamil bolƣin.    ");
INSERT INTO uigpin_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mǝn Ɵzüm bilǝn sening arangda ǝⱨdǝmni bekitip, seni intayin zor kɵpǝytimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram ɵzini taxlap yüzini yǝrgǝ yeⱪip yatti; Huda uning bilǝn yǝnǝ sɵzlixip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ɵzümgǝ kǝlsǝm, mana, Mening ǝⱨdǝm sǝn bilǝn tüzülgǝndur: — Sǝn nurƣun ǝl-millǝtlǝrning atisi bolisǝn.    ");
INSERT INTO uigpin_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Xuning üqün sening isming buningdin keyin Abram atalmaydu, bǝlki isming Ibraⱨim bolidu; qünki Mǝn seni nurƣun ǝl-millǝtlǝrning atisi ⱪildim. ");
INSERT INTO uigpin_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mǝn seni intayin zor kɵpǝytimǝn; xuning bilǝn sǝndin kɵp ǝl-ⱪowmlarni pǝyda ⱪilimǝn, puxtungdin padixaⱨlar qiⱪidu. ");
INSERT INTO uigpin_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mǝn sǝn wǝ sǝndin keyinki nǝslingning Hudasi bolux üqün Ɵzüm sǝn wǝ sǝndin keyinki nǝslingning arisida ǝbǝdiy ǝⱨdǝ süpitidǝ bu ǝⱨdǝmni tiklǝymǝn; ");
INSERT INTO uigpin_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mǝn sanga wǝ sǝndin keyinki nǝslinggǝ sǝn ⱨazir musapir bolup turƣan bu zeminni, yǝni pütkül Ⱪanaan zeminini ǝbǝdiy bir mülük süpitidǝ ata ⱪilimǝn; wǝ Mǝn ularning Hudasi bolimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Andin Huda Ibraⱨimƣa yǝnǝ: — Sǝn ɵzüng Mening ǝⱨdǝmni tutⱪin, ɵzüng wǝ sǝndin keyinki nǝslingmu ǝwladtin-ǝwladⱪa buni tutuxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Mǝn sǝn bilǝn wǝ sǝndin keyinki nǝsling bilǝn tüzgǝn, silǝrning tutuxunglar kerǝk bolƣan ǝⱨdǝm xuki, aranglardiki ⱨǝrbir ǝrkǝk hǝtnǝ ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Xuning bilǝn silǝr hǝtnilikinglarni kesiwetixinglar kerǝk; bu Mǝn bilǝn silǝrning aranglardiki ǝⱨdining bǝlgisi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Barliⱪ ǝwladliringlar, nǝsildin-nǝsilgǝ aranglarda, mǝyli ɵydǝ tuƣulƣanlar bolsun, yaki ǝwladinglardin bolmay yatlardin pulƣa setiwelinƣanlar bolsun, ⱨǝmmǝ ǝrkǝk sǝkkiz künlük bolƣanda hǝtnǝ ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ɵyüngdǝ tuƣulƣanlar bilǝn pulungƣa setiwalƣanlarning ⱨǝmmisi hǝtnǝ ⱪilinixi kerǝk. Xundaⱪ ⱪilƣanda, Mening ǝⱨdǝm tǝnliringlarda ornap, ǝbǝdiy bir ǝⱨdǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Lekin hǝtniliki turup, tehi hǝtnǝ ⱪilinmiƣan ⱨǝrbir ǝrkǝk Mening ǝⱨdǝmni buzƣan ⱨesablinip, üzüp taxlinidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Huda Ibraⱨimƣa yǝnǝ sɵz ⱪilip: — Ayaling Sarayni ǝmdi Saray dǝp atimiƣin, bǝlki ismi Saraⱨ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mǝn uningƣa bǝht-bǝrikǝt berip, uningdinmu sanga bir oƣul berimǝn. Mǝn dǝrwǝⱪǝ uni bǝrikǝtlǝymǝn; xuning bilǝn u ǝl-millǝtlǝrning anisi bolidu; hǝlⱪlǝrning padixaⱨlirimu uningdin qiⱪidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibraⱨim yǝnǝ ɵzini yǝrgǝ etip düm yetip külüp kǝtti wǝ kɵnglidǝ: «Yüz yaxⱪa kirgǝn adǝmmu baliliⱪ bolalarmu? Toⱪsan yaxⱪa kirgǝn Saraⱨmu bala tuƣarmu?!», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ibraⱨim Hudaƣa: — Aⱨ, Ismail aldingda yaxisa idi! dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Huda uningƣa: — Yaⱪ, ayaling Saraⱨ jǝzmǝn sanga bir oƣul tuƣup beridu. Sǝn uningƣa «Isⱨaⱪ» dǝp at ⱪoyƣin. Mǝn uning bilǝn ɵz ǝⱨdǝmni tüzimǝn; bu uningdin keyin kelidiƣan nǝsli bilǝn baƣliƣan ǝbǝdiy bir ǝⱨdǝ süpitidǝ bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismailƣa kǝlsǝk, uning toƣrisidiki duayingni anglidim. Mana, Mǝn uni bǝrikǝtlǝp, nǝslini kɵpǝytip, intayin zor awutimǝn. Uning puxtidin on ikki ǝmir qiⱪidu; Mǝn uni uluƣ bir hǝlⱪ ⱪilimǝn.    ");
INSERT INTO uigpin_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Biraⱪ ǝⱨdǝmni bolsa Mǝn kelǝr yili dǝl muxu waⱪitta Saraⱨ sanga tuƣup beridiƣan oƣul — Isⱨaⱪ bilǝn tüzimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Huda Ibraⱨim bilǝn sɵzlixip bolup, uning yenidin yuⱪiriƣa qiⱪip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Xuning bilǝn xu künila Ibraⱨim ɵz oƣli Ismailni, ɵz ɵyidǝ tuƣulƣanlar wǝ pulƣa setiwalƣanlarning ⱨǝmmisini, yǝni uning ɵyidiki barliⱪ ǝrkǝklǝrni elip, Huda uningƣa eytⱪandǝk ularning hǝtnilikini kesip hǝtnǝ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibraⱨimning hǝtniliki kesilip, hǝtnǝ ⱪilinƣanda, toⱪsan toⱪⱪuz yaxⱪa kirgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Uning oƣli Ismailning hǝtniliki kesilip, hǝtnǝ ⱪilinƣanda, on üq yaxta idi. ");
INSERT INTO uigpin_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Ibraⱨim bilǝn uning oƣli Ismail dǝl xu künning ɵzidǝ hǝtnǝ ⱪilindi wǝ xundaⱪla uning ɵyidiki ⱨǝmmǝ ǝr kixilǝr, mǝyli ɵyidǝ tuƣulƣan bolsun yaki yattin pulƣa setiwelinƣanlar bolsun, ⱨǝmmisi uning bilǝn billǝ hǝtnǝ ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Pǝrwǝrdigar Mamrǝdiki dubzarliⱪning yenida Ibraⱨimƣa kɵründi; bu kün ǝng issiƣan waⱪit bolup, u ɵz qedirining ixikidǝ olturatti. ");
INSERT INTO uigpin_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","U bexini kɵtürüp nǝzǝr seliwidi, mana uning udulida üq kixi ɵrǝ turatti. Ularni kɵrüp u qedirining ixikidin ⱪopup, ularning aldiƣa yügürüp berip, yǝrgǝ tǝgküdǝk tǝzim ⱪilip: ");
INSERT INTO uigpin_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","— i Rǝbbim, ǝgǝr peⱪir nǝzǝrliridǝ iltipat tapⱪan bolsam, ɵtünimǝnki, ⱪullirining yenidin ɵtüp kǝtmigǝyla; ");
INSERT INTO uigpin_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","azƣina su kǝltürülsun, silǝr putliringlarni yuyup dǝrǝhning tegidǝ aram eliwelinglar. ");
INSERT INTO uigpin_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Silǝr ɵz ⱪulunglarning yenidin ɵtkǝnikǝnsilǝr, mǝn bir qixlǝm nan elip qiⱪay, silǝr ⱨarduⱪunglarni qiⱪirip, andin ɵtüp kǝtkǝysilǝr, dedi. Ular jawab berip: — Eytⱪiningdǝk ⱪilƣin, dewidi, ");
INSERT INTO uigpin_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibraⱨim qediriƣa Saraⱨning ⱪexiƣa yügürüp kirip, uningƣa: — Üq das esil undin tez hemir yuƣurup toⱪaq ǝtkin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Andin Ibraⱨim kala padisiƣa yügürüp berip, yumran obdan bir mozayni tallap, qakiriƣa tapxurdi; u buni tezla tǝyyar ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","9","Andin Ibraⱨim seriⱪ may, süt wǝ tǝyyarlatⱪan mozayni elip kelip, ularning aldiƣa tutup, ɵzi dǝrǝhning tegidǝ ularning aldida ɵrǝ turdi; ular ulardin yedi. Ular uningdin: ayaling Saraⱨ nǝdǝ, dǝp soriwidi, u jawab berip: — Mana, qedirda, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Birsi: — Mǝn kelǝr yili muxu waⱪitta ⱪexingƣa jǝzmǝn ⱪaytip kelimǝn, wǝ mana u waⱪitta ayaling Saraⱨning bir oƣli bolidu, — dedi. Saraⱨ bolsa uning kǝynidiki qedirning ixikidǝ turup, bularni anglawatatti.    ");
INSERT INTO uigpin_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibraⱨim bilǝn Saraⱨ ikkisi yaxinip, ⱪerip ⱪalƣanidi; Saraⱨta ayal kixilǝrdǝ bolidiƣan adǝt kɵrüx tohtap ⱪalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Xunga Saraⱨ ɵz iqidǝ külüp: — Mǝn xunqǝ ⱪerip kǝtkǝn tursam, rasttinla lǝzzǝt kɵrǝlǝrmǝnmu? Erimmu ⱪerip kǝtkǝn tursa? — dǝp hiyal ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Pǝrwǝrdigar Ibraⱨimƣa: — Saraⱨning: «Mǝn ⱪerip kǝtkǝn tursam, rasttinla bala tuƣarmǝnmu?» dǝp külgini nemisi? ");
INSERT INTO uigpin_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Pǝrwǝrdigarƣa mumkin bolmaydiƣan tilsimat ix barmu? Bekitkǝn waⱪitta, yǝni kelǝr yili dǝl bu qaƣda ⱪaytip kelimǝn wǝ u waⱪitta Saraⱨning bir oƣli bolidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Əmma Saraⱨ ⱪorⱪup ketip: — Külmidim, dǝp inkar ⱪildi. Lekin U: — Yaⱪ, sǝn küldüng, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Andin bu zatlar u yǝrdin ⱪopup, Sodom tǝrǝpkǝ nǝzirini aƣdurdi. Ibraⱨimmu ularni uzitip, ular bilǝn billǝ mangdi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Pǝrwǝrdigar: — Mǝn ⱪilidiƣan iximni Ibraⱨimdin yoxursam bolamdu? ");
INSERT INTO uigpin_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Qünki Ibraⱨimdin uluƣ wǝ küqlük bir ǝl qiⱪidu wǝ xuningdǝk yǝr yüzidiki barliⱪ ǝl-millǝtlǝr u arⱪiliⱪ bǝht-bǝrikǝtkǝ muyǝssǝr bolidiƣan tursa? ");
INSERT INTO uigpin_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Qünki Mǝn uni bilip talliƣanmǝn; u qoⱪum ɵz balilirini wǝ uning ɵyidikilǝrni ɵzigǝ ǝgǝxtürüp, ularƣa Pǝrwǝrdigarning yolini tutup, ⱨǝⱪⱪaniyliⱪni wǝ adalǝtni yürgüzüxni ɵgitidu. Buning bilǝn Mǝnki Pǝrwǝrdigar Ibraⱨim toƣruluⱪ ⱪilƣan wǝdǝmni ǝmǝlgǝ axurimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Andin Pǝrwǝrdigar mundaⱪ dedi: — «Sodom wǝ Gomorra toƣruluⱪ kɵtürülgǝn dad-pǝryad naⱨayiti küqlük, ularning gunaⱨi intayin eƣir bolƣini üqün, ");
INSERT INTO uigpin_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mǝn ⱨazirla qüximǝn, ⱪilmixliri rasttinla xu dad-pǝryadlardin Manga mǝlum bolƣandǝk xunqǝ rǝzilmu, bilip baⱪay; unqǝ rǝzil bolmiƣandimu, Mǝn uni bilixim kerǝk». ");
INSERT INTO uigpin_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Xuning bilǝn bu kixilǝr u yǝrdin ⱪozƣilip, Sodom tǝrǝpkǝ yol aldi. Lekin Ibraⱨim yǝnila Pǝrwǝrdigarning aldida ɵrǝ turatti. ");
INSERT INTO uigpin_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ibraⱨim yeⱪin berip: — Sǝn rasttinla ⱨǝⱪⱪaniylarni rǝzillǝr bilǝn ⱪoxup ⱨalak ⱪilamsǝn? ");
INSERT INTO uigpin_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Xǝⱨǝrdǝ ǝllik ⱨǝⱪⱪaniy kixi bar boluxi mumkin; Sǝn rasttinla xu jayni ⱨalak ⱪilamsǝn, ǝllik ⱨǝⱪⱪaniy kixi üqün u jayni kǝqürüm ⱪilmamsǝn? ");
INSERT INTO uigpin_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Yaⱪ, yaⱪ. Bu ix Sǝndin neri bolƣay! Ⱨǝⱪⱪaniylarni rǝzillǝrgǝ ⱪoxup ɵltürüp, ⱨǝⱪⱪaniylarƣa rǝzillǝrgǝ ohxax muamilǝ ⱪilix Sǝndin neri bolƣay! Pütkül jaⱨanning soraⱪqisi adalǝt yürgüzmǝmdu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Pǝrwǝrdigar jawab berip: — Əgǝr Mǝn Sodom xǝⱨiridǝ ǝllik ⱨǝⱪⱪaniyni tapsam, ular üqün pütkül jayni ayap ⱪalimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Andin Ibraⱨim jawab berip: — Mana mǝn pǝⱪǝt topa bilǝn küldin ibarǝt bolsammu, mǝn Igǝm bilǝn sɵzlǝxkili yǝnǝ petinalidim. ");
INSERT INTO uigpin_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mubada xu ǝllik ⱨǝⱪⱪaniydin bǝx kixi kǝm bolsa, Sǝn bu bǝx kixining kǝm bolƣini üqün pütkül xǝⱨǝrni yoⱪitamsǝn? — dedi. U: — Əgǝr Mǝn xu yǝrdǝ ⱪiriⱪ bǝxni tapsammu, uni yoⱪatmaymǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibraⱨim Uningƣa sɵzini dawam ⱪilip: — Xu yǝrdǝ ⱪiriⱪ kixila tepilixi mumkin, dewidi, Pǝrwǝrdigar: — Bu ⱪiriⱪi üqün uni yoⱪatmaymǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","U yǝnǝ sɵz ⱪilip: I Igǝm, hapa bolmiƣaysǝn, mǝn yǝnǝ sɵz ⱪilay. Xu yǝrdǝ ottuzi tepilixi mumkin? — dedi. U: — Əgǝr Mǝn u yǝrdǝ ottuzni tapsammu, yoⱪatmaymǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","U yǝnǝ sɵz ⱪilip: — Mana ǝmdi mǝn Igǝm bilǝn sɵzlǝxkili jür’ǝt ⱪildim; xu yǝrdǝ yigirmisi tepilixi mumkin, — dedi. Pǝrwǝrdigar sɵz ⱪilip: bu yigirmisi üqün u yǝrni yoⱪatmaymǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","U sɵzlǝp: — I Igǝm, hapa bolmiƣay, mǝn pǝⱪǝt muxu bir ⱪetimla sɵz ⱪilay! Xu yǝrdǝ oni tepilixi mumkin, dewidi, u jawab berip: — Mǝn oni üqün uni yoⱪatmaymǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Pǝrwǝrdigar Ibraⱨim bilǝn sɵzlixip bolƣandin keyin kǝtti; Ibraⱨimmu ɵz jayiƣa ⱪaytip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ikki pǝrixtǝ kǝqtǝ Sodomƣa yetip kǝldi; xu qaƣda Lut Sodomning dǝrwazisida olturatti. Lut ularni kɵrüpla ornidin turup, aldiƣa qiⱪip yüzi yǝrgǝ tǝgküdǝk tǝzim ⱪilip: ");
INSERT INTO uigpin_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","— Mana, ǝy hojilirim, kǝminilirining ɵyigǝ qüxüp putliringlarni yuyup ⱪonup ⱪalƣaysilǝr; andin ǝtǝ sǝⱨǝr ⱪopup yolƣa qiⱪsanglarmu bolidu, dewidi, bular jawabǝn: — Yaⱪ, biz xǝⱨǝr mǝydanida kǝqlǝymiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Əmma u ularni qing tutuwidi, ahir ular uning bilǝn berip ɵyigǝ kirdi. U ularƣa dastihan selip, petir toⱪaqlarni pixurup bǝrdi, ular ƣizalandi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ular tehi yatmiƣanidi, xǝⱨǝrdikilǝr, yǝni Sodomning ǝrkǝkliri, yax, ⱪeri ⱨǝmmisi ⱨǝrⱪaysi mǝⱨǝllilǝrdin kelip ɵyni ⱪorxiwaldi; ");
INSERT INTO uigpin_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ular Lutni qaⱪirip uningƣa: — Bügün kǝqtǝ seningkigǝ kirgǝn adǝmlǝr ⱪeni? Ularni bizgǝ qiⱪirip bǝr, biz ular bilǝn yeⱪinqiliⱪ ⱪilimiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lut dǝrwazining aldiƣa, ularning ⱪexiƣa qiⱪip, ixikni yepiwetip, ");
INSERT INTO uigpin_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ularƣa: — Əy buradǝrlirim, mundaⱪ rǝzillikni ⱪilmanglar! ");
INSERT INTO uigpin_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mana, tehi ⱨeq ǝr bilǝn billǝ bolmiƣan ikki ⱪizim bar; ularni silǝrgǝ qiⱪirip berǝy. Ular bilǝn haliƣininglarni ⱪilinglar. Əmma bu adǝmlǝr ɵgzǝmning sayisi astiƣa kirgǝnikǝn, silǝr ularni ⱨeqnemǝ ⱪilmanglar! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Lekin ular jawab berip: «Neri tur!» deginiqǝ, yǝnǝ: — Bu yǝrdǝ turuxⱪa kǝlgǝn bu musapir ⱨakim bolmaⱪqimikǝn? Əmdi sanga ularƣa ⱪilƣandinmu bǝttǝr yamanliⱪ ⱪilimiz! — dǝp Lutni ⱪistap, ixikni qeⱪixⱪa basturup kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Əmma u ikki kixi ⱪollirini uzitip Lutni ɵygǝ ɵz ⱪexiƣa tartip ǝkiriwelip, ixikni taⱪiwaldi ");
INSERT INTO uigpin_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","wǝ ɵyning dǝrwazisining aldidiki adǝmlǝrni kiqikidin tartip qongiƣiqǝ korluⱪⱪa muptila ⱪildi; xuning bilǝn ular dǝrwazini izdǝp, ⱨalidin kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Andin ikkǝylǝn Lutⱪa: — Muxu yǝrdǝ yǝnǝ birǝr kiming barmu? Küy’oƣul, oƣul yaki ⱪizliring wǝ yaki xǝⱨǝrdǝ baxⱪa adǝmliring bolsa ularni bu yǝrdin elip kǝtkin! ");
INSERT INTO uigpin_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Qünki biz bu yǝrni yoⱪitimiz; qünki ular toƣruluⱪ kɵtürülgǝn dad-pǝryad Pǝrwǝrdigarning aldida intayin küqlük bolƣaq, Pǝrwǝrdigar bizni uni yoⱪitixⱪa ǝwǝtti, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Xuning bilǝn Lut taxⱪiriƣa qiⱪip, ⱪizlirini alidiƣan bolƣusi küy’oƣullirining ⱪexiƣa berip: «Əmdi ⱪopup bu yǝrdin qiⱪip ketinglar; qünki Pǝrwǝrdigar xǝⱨǝrni yoⱪitidu» — dedi. Əmma u bolƣusi küy’oƣullirining nǝzirigǝ qaⱪqaⱪ ⱪilƣandǝk kɵründi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tang atⱪanda, pǝrixtilǝr Lutni aldiritip: — Əmdi ⱪopup ayaling bilǝn ⱪexingdiki ikki ⱪizingni alƣin; bolmisa xǝⱨǝrning ⱪǝbiⱨlikigǝ qetilip ⱪelip, ⱨalak bolisǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Əmma u tehiqǝ arisaldi bolup turƣanda, Pǝrwǝrdigar uningƣa rǝⱨim ⱪilƣanliⱪi üqün, u ikkiylǝn Lutning ⱪolini, ayalining ⱪolini wǝ ikki ⱪizining ⱪollirini tutup, ularni xǝⱨǝrning sirtiƣa ǝqiⱪip, orunlaxturup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ularni qiⱪarƣandin keyin xu ix boldiki, ulardin biri uningƣa: — Jeningni elip ⱪaq, ⱨalak bolmasliⱪing üqün kǝyninggǝ ⱪarimay, tüzlǝngliktiki ⱨeq yǝrdǝ tohtimay, taƣⱪa ⱪaqⱪin! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lekin Lut ularƣa: — Undaⱪ bolmiƣay, ǝy hojam, ɵtünüp ⱪalay! ");
INSERT INTO uigpin_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mana, kǝminǝng kɵzüngdǝ iltipat tapti, jenimni ⱪutⱪuzdung, manga zor mǝrⱨǝmǝt kɵrsǝtting; ǝmma mǝn taƣⱪa ⱪaqalmaymǝn; undaⱪ ⱪilsam, manga birǝr apǝt qüxüp, ɵlüp ketǝrmǝnmikin. ");
INSERT INTO uigpin_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ⱪara, awu xǝⱨǝrgǝ ⱪeqip barsa bolƣudǝk naⱨayiti yeⱪin ikǝn, xundaⱪla kiqik xǝⱨǝr ikǝn! Ɵtünüp ⱪalay, mening xu yǝrgǝ ⱪeqiximƣa yol ⱪoyƣaysǝn! U kiqik xǝⱨǝr ǝmǝsmu?! Jenim xu yǝrdǝ aman ⱪalidu! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Pǝrixtǝ uningƣa jawab berip: — Hǝyr, bu ixtimu sanga maⱪul bolay, sǝn eytⱪan xu xǝⱨǝrni wǝyran ⱪilmay. ");
INSERT INTO uigpin_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Əmdi u yǝrgǝ tezdin ⱪeqip barƣin; qünki sǝn xu yǝrgǝ yetip barmiƣuqǝ ⱨeq ix ⱪilalmasmǝn, — dedi. Xunga u xǝⱨǝrning ismi «Zoar» dǝp atalƣan. ");
INSERT INTO uigpin_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lut Zoarƣa yetip barƣanda kün nuri yǝr yüzigǝ qeqilƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Xu qaƣda Pǝrwǝrdigar Pǝrwǝrdigardin Sodom bilǝn Gomorraning üstigǝ ǝrxtin günggürt wǝ ot yaƣdurup,    ");
INSERT INTO uigpin_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","xu xǝⱨǝrlǝrni, pütkül tüzlǝnglikni ⱨǝmdǝ xǝⱨǝrlǝrdiki barliⱪ aⱨalilǝr wǝ yǝrdin üngǝnlǝrni ⱪoxup bǝrbat ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lekin Lutning arⱪisidin mangƣan ayali kǝynigǝ ⱪariwidi, tuz tüwrükkǝ aylinip ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ətisi tang sǝⱨǝrdǝ, Ibraⱨim ⱪopup ilgiri Pǝrwǝrdigarning aldida turƣan jayƣa qiⱪip, ");
INSERT INTO uigpin_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom bilǝn Gomorra tǝrǝpkǝ, xundaⱪla tüzlǝnglikning ⱨǝmmǝ yerigǝ nǝzǝr seliwidi, mana, yǝr yüzidin humdanning tütünidǝk tütün ɵrlǝwatⱪinini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Əmma xundaⱪ boldiki, Huda u tüzlǝngliktiki xǝⱨǝrlǝrni wǝyran ⱪilƣanda, U Ibraⱨimni esigǝ elip, Lut turƣan xǝⱨǝrlǝrni bǝrbat ⱪilƣanda uni balayi’apǝtning iqidin qiⱪirip ⱪutⱪuzdi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Əmma Lut Zoar xǝⱨiridǝ turuxtin ⱪorⱪⱪaqⱪa, Zoardin ketip, taƣⱪa qiⱪip, ikki ⱪizi bilǝn xu yǝrdǝ makanlaxti. U ikki ⱪizi bilǝn bir ɵngkürdǝ turdi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Əmdi qong ⱪiz kiqikigǝ: — Atimiz bolsa ⱪerip kǝtti; dunyaning ⱪaidǝ-yosuni boyiqǝ bu yurtta bizgǝ yeⱪinqiliⱪ ⱪilidiƣan ⱨeq ǝr kixi ⱪalmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ⱪeni, atimizni xarab bilǝn mǝst ⱪilip ⱪoyup, uning bilǝn billǝ yatayli; xundaⱪ ⱪilsaⱪ, biz pǝrzǝnt kɵrüp atimizning uruⱪini ⱪalduralaymiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Xuning bilǝn ular u keqisi atisiƣa xarab iqküzüp mǝst ⱪilip ⱪoyup, qong ⱪizi kirip atisi bilǝn yatti. Lekin Lut uning kirip yatⱪininimu, ⱪopup kǝtkininimu ⱨeq sǝzmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ətisi xundaⱪ boldiki, qongi kiqikigǝ: — Mana, mǝn ahxam atam bilǝn yattim; bügün kǝqtimu uningƣa yǝnǝ xarab iqküzǝyli; xuning bilǝn sǝn kirip uning bilǝn yatⱪin; xundaⱪ ⱪilip, ⱨǝr ikkimiz pǝrzǝnt kɵrüp atimizning nǝslini ⱪalduralaymiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Xuning bilǝn ular u keqisi atisiƣa xarab iqküzüp mǝst ⱪilip ⱪoyup, kiqik ⱪizi ornidin turup uning bilǝn billǝ yatti. Əmma Lut uning kirip yatⱪininimu, ⱪopup kǝtkininimu ⱨeq sǝzmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Xundaⱪ ⱪilip, Lutning ikkila ⱪizi ɵz atisidin ⱨamilidar bolup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Qongi bolsa oƣul tuƣup, uning etini Moab ⱪoydi; u bügünki Moabiylarning atisidur. ");
INSERT INTO uigpin_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kiqikimu oƣul tuƣup, uning etini Bǝn-Ammi ⱪoydi. U bügünki Ammoniylarning atisidur. ");
INSERT INTO uigpin_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ibraⱨim u yǝrdin qiⱪip, jǝnub tǝrǝptiki Nǝgǝwgǝ kɵqüp kelip, Ⱪadǝx bilǝn Xurning ariliⱪida turup ⱪaldi; bir mǝzgildin keyin Gǝrarda olturaⱪlaxti. ");
INSERT INTO uigpin_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Xu yǝrdǝ Ibraⱨim ayali Saraⱨ toƣrisida: «U mening singlimdur», degǝnidi. Xuning bilǝn Gǝrarning padixaⱨi Abimǝlǝk adǝm ǝwǝtip, Saraⱨni ɵzigǝ hotun boluxⱪa eliwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lekin bir küni keqisi qüxidǝ Huda Abimǝlǝkkǝ kelip uningƣa: — Mana, sǝn ɵzünggǝ eliwalƣan ayal sǝwǝbidin ǝmdi ɵlgǝn adǝmdursǝn; qünki u baxⱪa birsining ayalidur — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Əmma Abimǝlǝk uningƣa tehi yeⱪinqiliⱪ ⱪilmiƣanidi. U Hudaƣa: — I Rǝb, ⱨǝⱪⱪaniy bir hǝlⱪnimu ⱨalak ⱪilamsǝn? ");
INSERT INTO uigpin_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","U ɵzimu manga: «U mening singlim» dǝp eytmidimu? Yǝnǝ kelip, bu ayalmu «U mening akam», dǝp eytⱪanidi. Mǝn bolsam sap kɵnglüm wǝ durus niyitim bilǝn bu ixni ⱪildim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Huda qüxidǝ uningƣa yǝnǝ: — Bu ixni sap kɵngül bilǝn ⱪilƣiningni bilimǝn; xu sǝwǝbtin Mǝn seni aldimda gunaⱨ ⱪilixtin tosup, uningƣa tegixinggǝ ⱪoymidim. ");
INSERT INTO uigpin_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Əmdi u kixining ayalini ɵzigǝ ⱪayturup bǝr; qünki u Pǝyƣǝmbǝr, u sening ⱨǝⱪⱪingdǝ dua ⱪilidu wǝ sǝn tirik ⱪalisǝn. Əgǝr uni yandurup bǝrmisǝng xuni bilip ⱪoyƣinki, sǝn wǝ ⱨǝmmǝ adǝmliring ⱪoxulup jǝzmǝn ɵlisilǝr, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimǝlǝk ǝtigǝn tang sǝⱨǝrdǝ ⱪopup, ⱨǝmmǝ hizmǝtkarlirini qaⱪirip, bu sɵzlǝrning ⱨǝmmisini ularning ⱪulaⱪliriƣa saldi; bu adǝmlǝr naⱨayiti ⱪorⱪuxup kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Andin Abimǝlǝk Ibraⱨimni qaⱪirip uningƣa: — Bu bizgǝ nemǝ ⱪilƣining? Mǝn sanga zadi nemǝ gunaⱨ ⱪildim, sǝn mǝn wǝ padixaⱨliⱪimƣa eƣir bir gunaⱨni yüklǝp ⱪoydung? Manga ⱪilmaydiƣan ixlarni ⱪilding! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimǝlǝk Ibraⱨimƣa yǝnǝ: — Sǝn zadi bizning nemǝ iximizni kɵrgining üqün muxu ixni ⱪilding? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibraⱨim jawab berip: — «Bu yǝrdǝ xübⱨisizki ⱨeqkim Hudadin ⱪorⱪmaydikǝn, ular meni ayalim tüpǝylidin ɵltürüwetidu», dǝp oyliƣanidim. ");
INSERT INTO uigpin_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Əmǝliyǝttǝ, uning mening singlim ikǝnliki rast, lekin u mening ata bir, ana bɵlǝk singlim; keyin u mening ayalim boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lekin Huda meni atamning ɵyidin qiⱪirip sǝrgǝrdanliⱪⱪa yürgüzginidǝ, mǝn ayalimƣa: — Biz ⱪǝyǝrgila barsaⱪ, sǝn manga xundaⱪ xapaǝt kɵrsǝtkǝysǝnki, mening toƣramda: «Bu mening akam bolidu», degin, — dǝp eytⱪanidim — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Andin Abimǝlǝk ⱪoy-kalilar, ⱪullar wǝ dedǝklǝrni elip ularni Ibraⱨimƣa bǝrdi wǝ ayali Saraⱨnimu uningƣa ⱪayturup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimǝlǝk: — Mana mening zeminim bolsa aldingda turuptu; kɵzünggǝ ⱪaysi yǝr yaⱪsa xu yǝrdǝ turƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","U Saraⱨⱪa: «Mana, mǝn akangƣa ming kümüx tǝnggǝ bǝrdim; mana bular ɵz yeningdikilǝr, xundaⱪla ⱨǝmmǝ adǝmlǝrning kɵz aldida uyatni yapⱪuqi bolidu; xuning bilǝn sǝn ⱨǝrⱪandaⱪ daƣ-ǝyibtin halas bolisǝn». ");
INSERT INTO uigpin_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ibraⱨim Hudaƣa dua ⱪildi, Huda Abimǝlǝk, ayali wǝ kenizǝklirini saⱪaytti; andin ular yǝnǝ bala tuƣalaydiƣan boldi; qünki Pǝrwǝrdigar Ibraⱨimning ayali Saraⱨ tüpǝylidin Abimǝlǝkning ɵyidiki ⱨǝmmǝ hotunlarning baliyatⱪulirini etip ⱪoyƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Əmdi Pǝrwǝrdigar wǝdǝ ⱪilƣinidǝk Saraⱨni yoⱪlidi; Pǝrwǝrdigar Saraⱨⱪa deginidǝk ⱪildi.    ");
INSERT INTO uigpin_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saraⱨ ⱨamilidar bolup, Ibraⱨim ⱪeriƣanda Huda uningƣa bekitkǝn waⱪitta bir oƣul tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibraⱨim ɵzigǝ tɵrǝlgǝn oƣli, yǝni Saraⱨ uningƣa tuƣup bǝrgǝn oƣlining ismini Isⱨaⱪ ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Andin Ibraⱨim Huda uningƣa buyruƣinidǝk ɵz oƣli Isⱨaⱪ tuƣulup sǝkkizinqi küni hǝtnǝ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Oƣli Isⱨaⱪ tuƣulƣan qaƣda, Ibraⱨim yüz yaxta idi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saraⱨ: «Huda meni küldürüwǝtti; ⱨǝrkim bu ixni anglisa, mǝn bilǝn tǝng külüxidu», dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","U yǝnǝ: — Kimmu Ibraⱨimƣa: «Saraⱨ bala emitidiƣan bolidu!» dǝp eytalaytti? Qünki u ⱪeriƣanda uningƣa bir oƣul tuƣup bǝrdim! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Bala qong bolup, ǝmqǝktin ayrildi. Isⱨaⱪ ǝmqǝktin ayrilƣan küni Ibraⱨim qong ziyapǝt ɵtküzüp bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Əmma Saraⱨ misirliⱪ Ⱨǝjǝrning Ibraⱨimƣa tuƣup bǝrgǝn oƣulning Isⱨaⱪni mǝshirǝ ⱪiliwatⱪinini kɵrüp ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Xuning bilǝn u Ibraⱨimƣa: — Bu dedǝk bilǝn oƣlini ⱨǝydiwǝt! Qünki bu dedǝkning oƣli mening oƣlum Isⱨaⱪ bilǝn tǝng waris bolsa bolmaydu!, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Saraⱨning bu sɵzi Ibraⱨimƣa tolimu eƣir kǝldi; qünki Ismailmu uning oƣli-dǝ! ");
INSERT INTO uigpin_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Lekin Huda Ibraⱨimƣa: — Balang wǝ dediking wǝjidin bu sɵz sanga eƣir kǝlmisun, bǝlki Saraⱨning sanga degǝnlirining ⱨǝmmisigǝ ⱪulaⱪ salƣin; qünki Isⱨaⱪtin bolƣini sening nǝsling ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Lekin dedǝkning oƣlidinmu bir hǝlⱪ-millǝt pǝyda ⱪilimǝn, qünki umu sening nǝsling, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ətisi tang sǝⱨǝrdǝ Ibraⱨim ⱪopup, nan bilǝn bir tulum suni elip Ⱨǝjǝrgǝ berip, ɵxnisigǝ yüdküzüp, balini uningƣa tapxurup, ikkisini yolƣa selip ⱪoydi. Ⱨǝjǝr ketip, Bǝǝr-Xebaning qɵlidǝ kezip yürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Əmdi tulumdiki su tügǝp kǝtkǝnidi; Ⱨǝjǝr balini bir qatⱪalning tüwigǝ taxlap ⱪoyup, ɵz-ɵzigǝ: «Balining ɵlüp ketixigǝ ⱪarap qidimaymǝn» dǝp, bir oⱪ etimqǝ yiraⱪⱪa berip, udulida olturdi. U udulida olturup, pǝryad kɵtürüp yiƣlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Huda oƣulning yiƣa awazini anglidi; xuning bilǝn Hudaning Pǝrixtisi asmandin Ⱨǝjǝrni qaⱪirip uningƣa: — Əy Ⱨǝjǝr, sanga nemǝ boldi? Ⱪorⱪmiƣin; qünki Huda oƣulning yiƣa awazini yatⱪan yeridin anglidi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Əmdi ⱪopup, ⱪolung bilǝn balini yɵlǝp turƣuz; qünki Mǝn uni uluƣ bir ǝl-millǝt ⱪilimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Xuan Huda Ⱨǝjǝrning kɵzlirini aqti, u bir ⱪuduⱪni kɵrdi. U berip tulumƣa su toldurup, oƣulƣa iqküzdi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Huda u bala bilǝn billǝ boldi; u ɵsüp qong boldi. U qɵldǝ yaxap, mǝrgǝn bolup yetixti. ");
INSERT INTO uigpin_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","U Paran qɵlidǝ turdi; xu waⱪitlarda anisi uningƣa Misir zeminidin bir ⱪizni hotunluⱪⱪa elip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","U waⱪitlarda xundaⱪ boldiki, Abimǝlǝk wǝ uning lǝxkǝrbexi Fikol kelip Ibraⱨimƣa: — Ⱪilƣan ⱨǝmmǝ ixliringda, Huda sening bilǝn billidur. ");
INSERT INTO uigpin_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Əmdi sǝn dǝl muxu yǝrdǝ manga, oƣlumƣa wǝ nǝwrǝmgǝ hiyanǝt ⱪilmasliⱪⱪa Hudaning namida ⱪǝsǝm ⱪilip bǝrgǝysǝn; mǝn sanga kɵrsitip kǝlgǝn meⱨribanliⱪimdǝk, sǝnmu manga wǝ sǝn ⱨazir turuwatⱪan yurtⱪa meⱨribanliⱪ ⱪilƣaysǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibraⱨim: Ⱪǝsǝm ⱪilip berǝy, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Andin Ibraⱨim Abimǝlǝkning qakarliri tartiwalƣan bir ⱪuduⱪ toƣrisida Abimǝlǝkni ǝyiblidi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimǝlǝk: — Bu ixni ⱪilƣan kixini bilmǝymǝn; sǝn bu ixni mangimu eytmapsǝn; mǝn bu ixni pǝⱪǝt bügünla anglixim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ibraⱨim ⱪoy-kala elip Abimǝlǝkkǝ tǝⱪdim ⱪildi; andin ular ikkilisi ǝⱨdǝ ⱪilixti. ");
INSERT INTO uigpin_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibraⱨim yǝnǝ padidin yǝttǝ qixi ⱪozini bir tǝrǝpkǝ ayrip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimǝlǝk Ibraⱨimdin: — Sǝn bir tǝrǝpkǝ ayrip ⱪoyƣan bu yǝttǝ qixi ⱪozining nemǝ mǝnisi bar? — dǝp soriwidi, ");
INSERT INTO uigpin_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","u: — Mening bu ⱪuduⱪni koliƣinimni etirap ⱪilƣiningƣa guwaⱨliⱪ süpitidǝ bu yǝttǝ qixi ⱪozini ⱪolumdin ⱪobul ⱪilƣaysǝn, — dǝp jawab bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Bu ikkisi xu yǝrdǝ ⱪǝsǝm ⱪilixⱪanliⱪi üqün, u xu jayni «Bǝǝr-Xeba» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Xu tǝriⱪidǝ ular Bǝǝr-Xebada ǝⱨdǝ ⱪilixti. Andin Abimǝlǝk wǝ uning lǝxkǝrbexi Fikol ⱪozƣilip, Filistiylǝrning zeminiƣa yenip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibraⱨim Bǝǝr-Xebada bir tüp yulƣunni tikip, u yǝrdǝ Əbǝdiy Tǝngri bolƣan Pǝrwǝrdigarning namiƣa nida ⱪilip ibadǝt ⱪildi.    ");
INSERT INTO uigpin_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibraⱨim Filistiylǝrning zeminida uzun waⱪitⱪiqǝ turup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bu ixlardin keyin xundaⱪ boldiki, Huda Ibraⱨimni sinap uningƣa: — Əy Ibraⱨim! dedi. U: mana mǝn! — dǝp jawab bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","U: — Sǝn oƣlungni, yǝni sǝn sɵyidiƣan yalƣuz oƣlung Isⱨaⱪni elip, Moriya yurtiƣa berip, xu yǝrdǝ, Mǝn sanga eytidiƣan taƣlarning birining üstidǝ uni kɵydürmǝ ⱪurbanliⱪ süpitidǝ sunƣin, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ətisi Ibraⱨim sǝⱨǝr ⱪopup, exikini toⱪup, yigitliridin ikkiylǝn bilǝn Isⱨaⱪni billǝ elip, kɵydürmǝ ⱪurbanliⱪ üqün otun yerip, Huda uningƣa eytⱪan yǝrgǝ ⱪarap mangdi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Üqinqi küni Ibraⱨim bexini kɵtürüp ⱪarap, yiraⱪtin u yǝrni kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ibraⱨim yigitlirigǝ: — Silǝr exǝk bilǝn muxu yǝrdǝ turup turunglar. Mǝn balam bilǝn u yǝrgǝ berip, sǝjdǝ ⱪilip, andin ⱪexinglarƣa yenip kelimiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Xuning bilǝn Ibraⱨim kɵydürmǝ ⱪurbanliⱪⱪa kerǝklik otunni elip, oƣli Isⱨaⱪⱪa yüdküzüp, ɵzi ⱪoliƣa piqaⱪ bilǝn otni elip, ikkisi billǝ yürüp kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isⱨaⱪ atisi Ibraⱨimƣa: — Əy ata! dewidi, u uningƣa jawab berip: — Mana mǝn, oƣlum, dedi. U uningdin: — Mana ot bilǝn otunƣu bar, ǝmma kɵydürmǝ ⱪurbanliⱪ bolidiƣan ⱪoza ⱪeni? — dǝp soriwidi, ");
INSERT INTO uigpin_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibraⱨim jawab berip: — Əy oƣlum, Huda Ɵzi Ɵzigǝ kɵydürmǝ ⱪurbanliⱪ ⱪozini tǝminlǝydu, — dedi. Andin ikkisi birgǝ yolini dawamlaxturdi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ahirida ular Huda Ibraⱨimƣa eytⱪan jayƣa yetip kǝldi. Ibraⱨim u yǝrdǝ ⱪurbangaⱨ yasap, üstigǝ otunni tizip ⱪoydi. Andin u oƣli Isⱨaⱪni baƣlap, uni ⱪurbangaⱨdiki otunning üstidǝ yatⱪuzdi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Andin Ibraⱨim ⱪolini uzitip, oƣlini boƣuzliƣili piqaⱪni aldi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Xuan Pǝrwǝrdigarning Pǝrixtisi asmandin uni qaⱪirip uningƣa: — Ibraⱨim, Ibraⱨim! — dǝp warⱪiridi. U: — Mana mǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","U uningƣa: — Sǝn baliƣa ⱪolungni tǝgküzmigin, uni ⱨeqnemǝ ⱪilmiƣin; qünki Mǝn sening Hudadin ⱪorⱪⱪanliⱪingni bildim; qünki sening oƣlungni, yǝni yalƣuz oƣlungni Mǝndin ayimiding, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibraⱨim bexini kɵtürüp ⱪariwidi, mana, arⱪisida münggüzliri qatⱪalƣa qirmixip ⱪalƣan bir ⱪoqⱪarni kɵrdi. Ibraⱨim berip ⱪoqⱪarni elip, uni oƣlining ornida kɵydürmǝ ⱪurbanliⱪ ⱪilip sundi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Xuning bilǝn Ibraⱨim xu jayƣa «Yaⱨwǝⱨ-Yirǝⱨ» dǝp at ⱪoydi. Xunga kixilǝr: «Pǝrwǝrdigarning teƣida tǝminlinidu» degǝn bu sɵz bügüngǝ ⱪǝdǝr eytilip keliwatidu. ");
INSERT INTO uigpin_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Pǝrwǝrdigarning Pǝrixtisi asmandin Ibraⱨimni ikkinqi ⱪetim qaⱪirip uningƣa: — ");
INSERT INTO uigpin_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Sǝn ɵz oƣlungni, yǝni yalƣuz oƣlungni ayimay bu ixni ⱪilƣining üqün Mǝn Ɵzüm bilǝn ⱪǝsǝm ⱪilimǝnki, dǝydu Pǝrwǝrdigar, ");
INSERT INTO uigpin_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","— Mǝn seni zor bǝrikǝtlǝp, nǝslingni asmandiki yultuzlardǝk nurƣun kɵpǝytip, dengiz saⱨilidiki ⱪumdǝk ƣolditimǝn; nǝsling bolsa düxmǝnlirining dǝrwaziliriƣa igǝ bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Sǝn Mening awazimƣa ⱪulaⱪ salƣining üqün yǝr yüzidiki barliⱪ ǝl-yurtlar nǝslingning nami bilǝn ɵzliri üqün bǝht-bǝrikǝt tilǝydu, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Andin Ibraⱨim yigitlirining ⱪexiƣa yenip bardi. Ular ⱨǝmmisi ornidin turuxup Bǝǝr-Xebaƣa yol aldi. Ibraⱨim Bǝǝr-Xebada turup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bu ixlardin keyin Ibraⱨimƣa: «Mana Milkaⱨmu ining Naⱨorƣa birⱪanqǝ oƣul tuƣup beriptu», degǝn hǝwǝr yǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ular bolsa tunji oƣli uz, uning inisi Buz wǝ Aramning atisi bolƣan Kǝmuǝl, ");
INSERT INTO uigpin_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","andin Kǝsǝd, Hazo, Pildax, Yidlaf wǝ Betuǝl degǝn oƣullar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Betuǝldin Riwkaⱨ tɵrǝldi). Bu sǝkkizini Milkaⱨ Ibraⱨimning inisi Naⱨorƣa tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Xuningdǝk uning keniziki Rǝumaⱨmu Tebaⱨ, Gaⱨam, Tahax wǝ Maakaⱨ degǝnlǝrni tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saraⱨ bir yüz yigirmǝ yǝttǝ yaxⱪiqǝ ɵmür kɵrdi. Bu Saraⱨning ɵmrining yilliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Saraⱨ Ⱪanaan zeminidiki Kiriat-Arba, yǝni Ⱨebronda wapat boldi. Ibraⱨim berip Saraⱨ üqün matǝm tutup yiƣa-zar ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ibraⱨim ɵz mǝrⱨumǝsining yenidin ⱪopup, Ⱨittiylarƣa sɵz ⱪilip: ");
INSERT INTO uigpin_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","— Mǝn bolsam aranglarda musapir meⱨman, halas; silǝr ǝmdi aranglardin manga bir yǝrlik beringlar; xuning bilǝn mǝn bu mǝrⱨumǝmni aldimda kɵrünüp turmisun üqün elip berip dǝpnǝ ⱪilay, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Ⱨittiylar Ibraⱨimƣa jawab berip: — I hojam, bizgǝ ⱪulaⱪ salƣayla! Sili arimizda Hudaning bir xaⱨzadisi ⱨesablinila! Arimizdiki ǝng esil yǝrlikni tallap, xu yǝrdǝ mǝrⱨumǝlirini dǝpnǝ ⱪilƣayla! Mǝrⱨumǝlirini dǝpnǝ ⱪilixⱪa ⱨeqⱪaysimiz ɵz yǝrlikini silidin ayimaydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ibraⱨim ornidin turup, u zemindiki hǝlⱪⱪǝ, yǝni Ⱨittiylarƣa tǝzim ⱪilip, ");
INSERT INTO uigpin_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ularƣa: — Əgǝr mǝrⱨumǝmning kɵz aldimda turiwǝrmǝsliki üqün, uni elip berip, dǝpnǝ ⱪiliximni rawa kɵrsǝnglar, undaⱪta sɵzümni anglap mening üqün Zoⱨarning oƣli Əfronƣa sɵz ⱪilip, ");
INSERT INTO uigpin_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","uning etizining ayiƣida ɵziningki bolƣan Makpelaⱨning ƣarini manga berixini iltimas ⱪilinglar. U manga buni silǝrning aranglarda gɵristan boluxⱪa toluⱪ nǝrhidǝ bǝrsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Xu qaƣda Əfron Ⱨittiylar arisida olturatti. Xuning bilǝn ⱨittiyliⱪ Əfron Ⱨittiylarning aldida, yǝni xǝⱨirining dǝrwazisidin kirgüqilǝrning ⱨǝmmisining aldida Ibraⱨimƣa jawab berip: — ");
INSERT INTO uigpin_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Yoⱪsu, ǝy hojam, manga ⱪulaⱪ salƣayla. Bu etizliⱪni, xundaⱪla uningdiki ƣarni siligǝ berǝy; uni ɵz hǝlⱪim bolƣan adǝmlǝrning aldida siligǝ bǝrdim; ɵz meyitlirini dǝpnǝ ⱪilƣayla, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Andin Ibraⱨim yǝnǝ zemin hǝlⱪi aldida tǝzim ⱪilip, ");
INSERT INTO uigpin_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Xu zemindiki hǝlⱪning ⱪulaⱪliri aldida Əfronƣa: — Iltimasimƣa ⱪulaⱪ salƣayla; mǝn bu etizliⱪning nǝrhi boyiqǝ pul berǝy, uni mǝndin ⱪobul ⱪilƣayla, andin mǝn meyitimni xu yǝrdǝ dǝpnǝ ⱪilay, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Əfron Ibraⱨimƣa jawab berip uningƣa: ");
INSERT INTO uigpin_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Əy hojam, manga ⱪulaⱪ salƣayla; tɵt yüz xǝkǝl kümüxkǝ yaraydiƣan bir etizliⱪ, sili bilǝn mening aramda nemǝ idi? Sili meyitlirini dǝpnǝ ⱪilƣayla — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibraⱨim Əfronning sɵzigǝ ⱪoxuldi; andin Əfron Ⱨittiylar aldida eytⱪan baⱨani, yǝni xu qaƣdiki soda ɵlqimi boyiqǝ tɵt yüz xǝkǝl kümüxni tarazida tartip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Xundaⱪ ⱪilip Mamrǝning udulidiki Makpelaⱨⱪa jaylaxⱪan Əfronning etizliⱪi, yǝni etizliⱪning ɵzi, uningdiki ƣar, xundaⱪla etizliⱪning iqi wǝ ǝtrapidiki barliⱪ dǝrǝhlǝrning ⱨǝmmisi ");
INSERT INTO uigpin_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ⱨittiylarning kɵz aldida Ibraⱨimƣa tapxurulup, yǝni Əfronning xǝⱨirining dǝrwazisidin barliⱪ kirgüqilǝrning aldida uning mülki ⱪilip bekitildi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Xuningdin keyin Ibraⱨim ayali Saraⱨni Ⱪanaan zeminidiki Mamrǝ (yǝni, Ⱨebron)ning udulidiki Makpelaⱨning etizliⱪining ƣarida dǝpnǝ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Xu tǝriⱪidǝ u etizliⱪ wǝ uningdiki ƣar Ⱨittiylar tǝripidin Ibraⱨimƣa gɵristan boluxⱪa tayin ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibraⱨim ⱪerip, yexi bir yǝrgǝ berip ⱪalƣanidi; Pǝrwǝrdigar Ibraⱨimƣa ⱨǝr tǝrǝptǝ bǝht-bǝrikǝt ata ⱪilƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ibraⱨim ɵyidiki ǝng mɵtiwǝr hizmǝtkari, ɵzining pütün mal-mülkini baxⱪuridiƣan ƣojidarƣa: — Ⱪolungni yotamning astiƣa ⱪoyƣin;    ");
INSERT INTO uigpin_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Mǝn seni asmanlarning Hudasi xundaⱪla yǝrning Hudasi bolƣan Pǝrwǝrdigarning nami bilǝn ⱪǝsǝm ⱪildurimǝnki, sǝn mǝn ⱨazir turuwatⱪan bu Ⱪanaaniylarning arisidin oƣlumƣa ⱪiz elip bǝrmǝy, ");
INSERT INTO uigpin_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Bǝlki ɵz yurtumƣa, xundaⱪla ɵz uruⱪ-tuƣⱪanlirimning ⱪexiƣa berip, oƣlum Isⱨaⱪⱪa hotun elip bǝrgǝysǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Hizmǝtkari uningƣa: — Mubada u ⱪiz mǝn bilǝn bu yurtⱪa kǝlgili unimisa, undaⱪta ɵzliri qiⱪⱪan xu yurtⱪa oƣullirini yandurup apiramdimǝn? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibraⱨim uningƣa jawab berip: — Ⱨezi bol, oƣlumni ⱨǝrgiz xu yǝrgǝ yandurup barmiƣin! ");
INSERT INTO uigpin_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Meni atamning ɵyi bilǝn tuƣulƣan yurtumdin yetǝklǝp elip kǝlgüqi, yǝni manga sɵz ⱪilip: — «Sening nǝslinggǝ bu yurtni berimǝn», dǝp manga ⱪǝsǝm ⱪilƣan, asmanning Hudasi bolƣan Pǝrwǝrdigar Ɵz Pǝrixtisini aldingƣa ǝwǝtidu; xuning bilǝn sǝn u yǝrdin oƣlumƣa ⱪiz elip kelǝlǝysǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Xundaⱪtimu, ǝgǝr ⱪiz sǝn bilǝn bu yǝrgǝ kǝlgili unimisa, mǝn sanga ⱪilduridiƣan ⱪǝsǝmdin halas bolisǝn; ǝmma oƣlumni u yǝrgǝ ⱨǝrgiz yandurup barmiƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Xuning bilǝn hizmǝtkar ⱪolini hojisi Ibraⱨimning yotisining astiƣa ⱪoyup turup, bu toƣrida uningƣa ⱪǝsǝm ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Andin hizmǝtkar bu toƣrida hojisining tɵgiliridin onni, xundaⱪla hojisining ⱨǝrhil esil nǝrsilirini elip yolƣa qiⱪti; u Aram-Naⱨaraim rayoniƣa sǝpǝr ⱪilip, Naⱨorning xǝⱨirigǝ yetip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","U xǝⱨǝrning sirtidiki bir ⱪuduⱪning yenida tɵgilirini qɵkündurdi: bu kǝqⱪurun, ⱪiz-ayallarning su tartⱪili qiⱪidiƣan qeƣi idi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","U dua ⱪilip: — Əy hojam Ibraⱨimning Hudasi bolƣan Pǝrwǝrdigar, ɵtünimǝnki, bügün mening iximni ongƣa tartⱪaysǝn, hojam Ibraⱨimƣa xapaǝt kɵrsǝtkǝysǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mana mǝn bu yǝrdǝ ⱪuduⱪning bexida turuwatimǝn wǝ xǝⱨǝr hǝlⱪining ⱪizliri bu yǝrgǝ su tartⱪili keliwatidu. ");
INSERT INTO uigpin_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Əmdi xundaⱪ bolsunki, mǝn ⱪaysi ⱪizƣa: «Komzikingni qüxürsǝng, mǝn su iqiwalsam boptikǝn!» desǝm, u jawab berip: «Mana iqkin, mǝn tɵgiliringnimu suƣirip ⱪoyay», desǝ, u ⱪiz sǝn ⱪulung Isⱨaⱪⱪa bekitkiningning ɵzi bolsun. Buningdin sening hojam Ibraⱨimƣa xapaǝt ⱪilƣiningni bilǝlǝymǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","U tehi sɵzini tügǝtmǝyla, mana Riwkaⱨ kozini mürisidǝ kɵtürüp qiⱪip kǝldi; u bolsa Ibraⱨimning inisi Naⱨorning ayali Milkaⱨtin tuƣulƣan oƣli Betuǝlning ⱪizi idi; ");
INSERT INTO uigpin_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ⱪiz intayin qirayliⱪ bolup, ⱨeq ǝr kixi tǝgmigǝn pak ⱪiz idi. U ⱪuduⱪning boyiƣa qüxüp, komzikini toldurup andin qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Hizmǝtkar uning aldiƣa yügürüp berip: — Ɵtünüp ⱪalay, komzikingtin azƣinǝ su otliwalay, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","U jawab berip: — Iqkǝyla, ǝy hojam! dǝpla, komzǝkni dǝrⱨal ⱪoliƣa elip, uning su iqixi üqün sundi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","U süyidin uningƣa ⱪanƣuqǝ iqküzgǝndin keyin: — Tɵgilirigimu ⱪanƣuqǝ su iqküzüp ⱪoyay, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Xuning bilǝn u dǝrⱨal komzǝktiki suni olaⱪⱪa tɵküwetip, yǝnǝ ⱪuduⱪⱪa su tartⱪili yügürüp bardi; u uning ⱨǝmmǝ tɵgilirigǝ su tartip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","U kixi uningƣa kɵzini tikkiniqǝ jimjit turup, Pǝrwǝrdigarning yolini ong ⱪilƣan, ⱪilmiƣanliⱪini bilix üqün kütüwatatti. ");
INSERT INTO uigpin_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tɵgilǝr su iqip ⱪanƣanda, xundaⱪ boldiki, ⱨeliⱪi kixi yerim xǝkǝllik bir altun burun ⱨalⱪisi bilǝn ikki ⱪoliƣa on xǝkǝllik altun bilǝzükni qiⱪirip ⱪizƣa berip uningƣa: ");
INSERT INTO uigpin_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Sǝn kimning ⱪizi bolisǝn? Manga dǝp bǝrsǝng! Atangning ɵyidǝ bizgǝ ⱪonƣudǝk jay barmu? — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ⱪiz uningƣa: — Mǝn Milkaⱨning Naⱨorƣa tuƣup bǝrgǝn oƣli Betuǝlning ⱪizi bolimǝn, — dedi, ");
INSERT INTO uigpin_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","yǝnǝ uningƣa: — Bizningkidǝ saman bilǝn boƣuz kǝngri, silǝrgǝ ⱪonƣili jaymu bar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Xuan bu adǝm engixip Pǝrwǝrdigarning aldida sǝjdǝ ⱪilip: ");
INSERT INTO uigpin_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ɵz xapaiti bilǝn ⱨojamdin wapadarliⱪini ayimiƣan, hojam Ibraⱨimning Hudasi bolƣan Pǝrwǝrdigarƣa ⱨǝmdusana oⱪulƣay! Pǝrwǝrdigar bu sǝpirimdǝ meni hojamning ⱪerindaxliri turƣan ɵygǝ baxlap kǝldi! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ⱪiz yügürüp berip, bularning ⱨǝmmisini anisining ɵydikilǝrgǝ eytip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Əmdi Riwkaⱨning Laban degǝn bir akisi bar idi. Laban ⱪuduⱪning bexiƣa, u adǝmning ⱪexiƣa yügürüp qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Qünki u singlisining burun ⱨalⱪisini wǝ ⱪolliridiki bilǝzüklǝrni kɵrüp, ⱨǝmdǝ singlisining: u adǝm manga mundaⱪ-mundaⱪ dedi, deginini anglap, u adǝmning ⱪexiƣa bardi. Mana, u kixi ⱪuduⱪning yenida tɵgilǝrning ⱪexida turatti. ");
INSERT INTO uigpin_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban uningƣa: — Əy Pǝrwǝrdigarning bǝht-bǝrikiti ata ⱪilinƣuqi, kirgǝyla! Nemǝ üqün taxⱪirida turdila? Mǝn ɵyni tǝyyarlap ⱪoydum, tɵgilǝrgimu jay raslidim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","U adǝm ɵygǝ kirdi; Laban tɵgilǝrdin yükni qüxürüp, tɵgilǝrgǝ saman bilǝn boƣuz berip, u kixining ⱨǝm uning ⱨǝmraⱨlirining putlirini yuƣili su elip kǝldi; ");
INSERT INTO uigpin_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","andin u kixining aldiƣa taam ⱪoyuldi; lekin u: — Mǝn gepimni demǝy turup taam yemǝymǝn, — dedi. Laban jawab berip: — Eytⱪayla, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","U: — Mǝn bolsam Ibraⱨimning hizmǝtkarimǝn; ");
INSERT INTO uigpin_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Pǝrwǝrdigar hojamƣa kɵp bǝht-bǝrikǝt ata ⱪilƣaqⱪa, u uluƣ bir kixi boldi. U uningƣa ⱪoy bilǝn kala, kümüx bilǝn altun, ⱪul bilǝn dedǝklǝrni, tɵgǝ bilǝn exǝklǝrni bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Hojamning ayali Saraⱨ ⱪeriƣanda hojamƣa bir oƣul tuƣup bǝrgǝnidi. Hojam oƣliƣa ɵzining barliⱪini atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Hojam meni ⱪǝsǝm ⱪildurup: «Sǝn mǝn turuwatⱪan zemindiki Ⱪanaaniylarning ⱪizliridin oƣlumƣa hotun elip bǝrmǝ, ");
INSERT INTO uigpin_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","bǝlki jǝzmǝn atamning ɵyigǝ, ɵz tuƣⱪanlirimning ⱪexiƣa berip, oƣlumƣa hotun elip bǝrgǝysǝn», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","U waⱪitta mǝn hojamƣa: «U ⱪiz mǝn bilǝn kǝlgili unimisiqu?» — desǝm, ");
INSERT INTO uigpin_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","u manga jawab berip: «Tutⱪan yollirim uningƣa oquⱪ bolƣan Pǝrwǝrdigarim Ɵz Pǝrixtisini sening bilǝn ǝwǝtip, yolungni ong ⱪilidu. Bu tǝriⱪidǝ sǝn mening ailidikilirim arisidin, atamning jǝmǝti iqidin oƣlumƣa hotun elip berisǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Xundaⱪ ⱪilip ailǝmdikilǝrning ⱪexiƣa yetip barƣiningda, sǝn mǝn ⱪildurƣan ⱪǝsǝmdin halas bolisǝn; ular sanga ⱪizni bǝrmisimu ohxaxla ⱪǝsǝmdin halas bolisǝn», — degǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Xunga mǝn bügün bu ⱪuduⱪning ⱪexiƣa kelip: — Əy, hojam Ibraⱨimning Hudasi bolƣan Pǝrwǝrdigar, ǝgǝr sǝn bu sǝpirimni ong ⱪilsang: — ");
INSERT INTO uigpin_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","mana mǝn su ⱪuduⱪining yenida turuwatimǝn; wǝ xundaⱪ bolsunki, su tartⱪili kǝlgǝn ⱪizƣa: «Komzikingdin manga bir otlam su bǝrgǝn bolsang», desǝm, ");
INSERT INTO uigpin_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","u manga: «Sǝn iqkin, tɵgiliringgimu su tartip berǝy», dǝp jawab bǝrsǝ, undaⱪta bu ⱪiz dǝl Pǝrwǝrdigar Ɵzi hojamning oƣli üqün bekitkǝn ⱪiz bolsun, dǝp dua ⱪilƣanidim. ");
INSERT INTO uigpin_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Kɵnglümdǝ tehi sɵzüm tügimǝyla, mana, Riwkaⱨ komzǝkni mürisidǝ kɵtürüp qiⱪip, ⱪuduⱪning boyiƣa qüxüp su tartti; mǝn uningƣa: — Iltipat ⱪilip, manga su iqkili ⱪoysang, dewidim, ");
INSERT INTO uigpin_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","u dǝrⱨal komzikini mürisidin qüxürüp: «Iqkǝyla, tɵgilirinimu suƣirip ⱪoyay», dedi. Xuning bilǝn mǝn iqtim; u tɵgilirimnimu suƣirip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Andin mǝn uningdin: — Kimning ⱪizi bolisǝn, dǝp sorisam, u jawab berip: — Mǝn Naⱨorning Milkaⱨdin tuƣulƣan oƣli Betuǝlning ⱪizi bolimǝn, — dedi. Xu qaƣda mǝn uning burniƣa ⱨalⱪa, ⱪolliriƣa bilǝzüklǝrni selip ⱪoydum; ");
INSERT INTO uigpin_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","andin engixip Pǝrwǝrdigarƣa sǝjdǝ ⱪildim; hojamning ⱪerindixining ⱪizini uning oƣli üqün elip ketixkǝ mening yolumni ong ⱪilƣini üqün, hojamning Hudasi bolƣan Pǝrwǝrdigarƣa ⱨǝmdusana eyttim. ");
INSERT INTO uigpin_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Əmdi silǝr hojamƣa ihlas ⱪilip xapaǝt kɵrsitǝyli desǝnglar, buni manga dǝnglar. Əgǝr halimisanglar, unimu manga eytinglar, mǝn ong tǝrǝpkǝ yaki sol tǝrǝpkǝ barimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Əmdi Laban bilǝn Betuǝl jawab berip: — Bu ix Pǝrwǝrdigardin bolƣaq, siligǝ ya undaⱪ ya bundaⱪ deyǝlmǝymiz. ");
INSERT INTO uigpin_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mana, Riwkaⱨ aldilirida turidu; uni elip kǝtkǝyla. U Pǝrwǝrdigarning deginidǝk ɵz hojilirining oƣliƣa hotun bolsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ibraⱨimning hizmǝtkari ularning sɵzlirini anglap, yǝrgǝ engixip, Pǝrwǝrdigarƣa sǝjdǝ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Andin, hizmǝtkar kümüx buyumlarni, altun buyumlarni wǝ kiyim-keqǝklǝrni qiⱪirip, bularni Riwkaⱨⱪa bǝrdi; u yǝnǝ ⱪizning akisi wǝ anisiƣimu ⱪimmǝtlik ⱨǝdiyǝlǝrni sundi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Andin u wǝ ⱨǝmraⱨliri bilǝn billǝ yǝp-iqip, xu yǝrdǝ ⱪonup ⱪaldi. Ətisi sǝⱨǝrdǝ ⱪopup, u ularƣa: meni hojamning ⱪexiƣa yolƣa selip ⱪoyunglar, dewidi, ");
INSERT INTO uigpin_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ⱪizning akisi bilǝn anisi uningƣa: — Ⱪiz birⱪanqǝ kün yaki on kün yenimizda tursun; andin barsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Əmma u ularƣa: — Pǝrwǝrdigar mening sǝpirimni ong ⱪilƣanikǝn, meni tosmanglar; hojamning ⱪexiƣa berixim üqün meni yolƣa selip ⱪoyunglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ular uningƣa: — Ⱪizni qaⱪirip, uning aƣzidin anglap baⱪayli, dǝp ");
INSERT INTO uigpin_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Riwkaⱨni qaⱪirip uningdin: — Bu adǝm bilǝn baramsǝn? dǝp soriwidi, u: — Baray, dǝp jawab bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Xuning bilǝn ular singlisi Riwkaⱨni, uning inik’anisi, Ibraⱨimning hizmǝtkari wǝ adǝmliri bilǝn ⱪoxup yolƣa selip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","U waⱪitta ular Riwkaⱨⱪa bǝht tilǝp: — Əy singlimiz, mingliƣan on mingliƣan adǝmlǝrning anisi bolƣaysǝn! Nǝsling düxmǝnlirining dǝrwaziliriƣa igǝ bolƣay! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Xuning bilǝn Riwkaⱨ bilǝn uning dedǝkliri ornidin turup, tɵgilǝrgǝ minip, u kixigǝ ǝgixip mangdi. Xundaⱪ ⱪilip hizmǝtkar Riwkaⱨni elip yolƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isⱨaⱪ Bǝǝr-laⱨay-roy degǝn jaydin bayila ⱪaytip kǝlgǝnidi; qünki u jǝnubtiki Nǝgǝwdǝ turatti; ");
INSERT INTO uigpin_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isⱨaⱪ kǝqⱪurun istiⱪamǝtkǝ dalaƣa qiⱪⱪanidi; u bexini kɵtürüp ⱪarisa, mana tɵgilǝr keliwatatti. ");
INSERT INTO uigpin_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","65","Riwkaⱨ bexini kɵtürüp, Isⱨaⱪni kɵrdi; u dǝrⱨal tɵgidin qüxüp, hizmǝtkardin: — Sǝⱨrada bizning aldimizƣa qiⱪiwatⱪan bu kixi kim bolidu? — dǝp soridi. Hizmǝtkar: — Bu hojamdur! dedi. Riwkaⱨ dǝrⱨal qümbilini tartip yüzini yepiwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hizmǝtkar ǝmdi ⱪilƣan ⱨǝmmǝ ixlirini Isⱨaⱪⱪa eytip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isⱨaⱪ ⱪizni anisi Saraⱨning qediriƣa baxlap kirdi; u Riwkaⱨni ɵz ǝmrigǝ aldi; u uning hotuni boldi. U uni yahxi kɵrüp ⱪaldi; bu tǝriⱪidǝ Isⱨaⱪ anisining wapatidin keyin tǝsǝlli tapti. ");
INSERT INTO uigpin_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibraⱨim Kǝturaⱨ isimlik yǝnǝ bir ayalni alƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","U Ibraⱨimƣa Zimran, Yoⱪxan, Medan, Midiyan, Ixbak wǝ Xuaⱨni tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoⱪxandin Xeba bilǝn Dedan tɵrǝldi; Dedanning ǝwladliri Axuriylar, Letuxiylar wǝ Leummiylar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyanning oƣulliri Əfaⱨ, Efǝr, Ⱨanoh, Abida wǝ Əldaaⱨ idi. Bular ⱨǝmmisi Kǝturaⱨning ǝwladliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibraⱨim barliⱪini Isⱨaⱪⱪa atiwǝtkǝnidi; ");
INSERT INTO uigpin_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ibraⱨim tehi Ⱨayat waⱪtida kiqik hotunliridin bolƣan oƣulliriƣa ⱨǝdiyǝlǝrni berip, andin bularni oƣli Isⱨaⱪtin yiraⱪ tursun dǝp, kün qiⱪix tǝrǝpkǝ, xǝrⱪiy zeminƣa ǝwǝtiwǝtkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Ibraⱨimning ɵmrining künliri bir yüz yǝtmix bǝx yil boldi; u tolimu ⱪerip, künliri toxup, nǝpǝstin tohtap wapat boldi; u ɵz ⱪowmining ⱪexiƣa berip ⱪoxuldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Uning oƣulliri Isⱨaⱪ wǝ Ismail uni Mamrǝning uduliƣa jaylaxⱪan, Ⱨittiy Zoⱨarning oƣli Əfronning etizliⱪidiki Makpelaⱨning ƣarida dǝpnǝ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Bu etizliⱪni Ibraⱨim Ⱨittiylardin setiwalƣanidi; mana bu yǝrlikkǝ Ibraⱨim dǝpnǝ ⱪilindi, ayali Saraⱨmu muxu yǝrgǝ dǝpnǝ ⱪilinƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibraⱨim wapat bolƣandin keyin xundaⱪ boldiki, Pǝrwǝrdigar uning oƣli Isⱨaⱪni bǝrikǝtlidi. Isⱨaⱪ Bǝǝr-Laⱨay-Royning yenida turatti. ");
INSERT INTO uigpin_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Tɵwǝndikilǝr Saraⱨning misirliⱪ dediki Ⱨǝjǝrdin tuƣulƣan, Ibraⱨimning oƣli bolƣan Ismailning ǝwladliri: — ");
INSERT INTO uigpin_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismailning oƣullirining, ularning nǝsǝbnamiliri wǝ ⱪǝbililiri boyiqǝ ismi tɵwǝndikiqǝ: — Ismailning tunji oƣli Nebayot; andin Kedar, Adbǝǝl, Mibsam, ");
INSERT INTO uigpin_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mixma, Dumaⱨ, Massa, ");
INSERT INTO uigpin_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Ⱨadad bilǝn Tema, Yǝtur bilǝn Nafix wǝ Ⱪǝdǝmaⱨ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Bular bolsa Ismailning oƣulliri bolup, ularning kǝnt wǝ qedirgaⱨliri ularning nami bilǝn atalƣan bolup, ular on ikki ⱪǝbiligǝ ǝmir bolƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismailning ɵmrining yilliri bir yüz ottuz yǝttǝ yil boldi; u ahirⱪi nǝpsini tartip wapat bolup, ɵz ⱪowmining ⱪexiƣa berip ⱪoxuldi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Uning ǝwladliri Ⱨawilaⱨ rayonidin tartip xurƣiqǝ olturaⱪlaxti (Xur bolsa Misirning utturisida bolup, Axurƣa baridiƣan yolda idi). Ismail ɵzining barliⱪ ⱪerindaxlirining udulida olturaⱪlaxti. ");
INSERT INTO uigpin_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ibraⱨimning oƣli Isⱨaⱪning nǝslining bayani mundaⱪtur: — Ibraⱨimdin Isⱨaⱪ tɵrǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isⱨaⱪ Padan-Aramda olturuxluⱪ aramiy Betuǝlning ⱪizi, aramiy Labanning singlisi bolƣan Riwkaⱨni hotunluⱪⱪa alƣanda ⱪiriⱪ yaxⱪa kirgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Əmma Riwkaⱨ bolsa tuƣmas bolƣaqⱪa, Isⱨaⱪ hotuni üqün Pǝrwǝrdigarƣa dua-tilawǝt ⱪildi; Pǝrwǝrdigar uning duasini ijabǝt ⱪildi; xuning bilǝn ayali Riwkaⱨ ⱨamilidar boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Əmma uning ⱪorsiⱪidiki ikki bala bir-biri bilǝn soⱪuxⱪili turdi. Xuning bilǝn Riwkaⱨ: — Əgǝr bundaⱪliⱪini bilsǝm, ⱨamilidar bolup nemǝ ⱪilattim? — dǝp Pǝrwǝrdigardin sǝwǝbini soriƣili bardi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Pǝrwǝrdigar uningƣa: — «Sening ⱪorsiⱪingda ikki ǝl bardur, Iqingdin ikki hǝlⱪ qiⱪip bir-biridin ayrilidu, Bir hǝlⱪ yǝnǝ bir hǝlⱪtin ƣalib kelidu, Qongi kiqikining hizmitini ⱪilidu» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Uning ay-küni toxⱪanda, mana uning ⱪorsiⱪida dǝrwǝⱪǝ bir jüp ⱪoxkezǝk bar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Awwal tuƣulƣini ⱪizƣuq bolup, pütün bǝdini juwidǝk tüklük idi. Ular uning ismini Əsaw dǝp ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Andin inisi ⱪoli bilǝn Əsawning tapinini tutⱪan ⱨalda qiⱪti. Bu sǝwǝbtin uning ismi Yaⱪup dǝp ⱪoyuldi. Ular tuƣulƣanda Isⱨaⱪ atmix yaxta idi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Balilar ɵsüp qong boldi; Əsaw maⱨir owqi bolup, dala-janggalda yüridiƣan adǝm boldi. Yaⱪup bolsa durus adǝm bolup, qedirlarda turatti. ");
INSERT INTO uigpin_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isⱨaⱪ Əsawning owlap kǝlgǝn gɵxidin daim yǝp turƣaqⱪa, uningƣa amraⱪ idi. Lekin Riwkaⱨ Yaⱪupⱪa amraⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Bir küni Yaⱪup purqaⱪ xorpisi ⱪaynitiwatatti; Əsaw daladin ⱨerip-eqip ⱪaytip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Əsaw Yaⱪupⱪa: — Mǝn ⱨalimdin kǝttim! Ɵtünüp ⱪalay, awu ⱪizildin bǝrsǝng! — Awu ⱪizil nǝrsidin meni ozuⱪlandursangqu! Mǝn ⱨalimdin kǝttim, — dedi (xu sǝwǝbtin uning eti «Edom» dǝpmu ataldi). ");
INSERT INTO uigpin_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaⱪup uningƣa: — Undaⱪ bolsa, tunjiliⱪ ⱨoⱪuⱪungni manga setip bǝrgin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Əsaw: — Mǝn ɵlǝy dǝwatimǝn, bu tunjiliⱪ ⱨoⱪuⱪining manga nemǝ paydisi? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaⱪup: — Əmisǝ ⱨazir manga ⱪǝsǝm ⱪilƣin, dewidi, u uningƣa ⱪǝsǝm ⱪilip, tunjiliⱪ ⱨoⱪuⱪini Yaⱪupⱪa setip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Xuning bilǝn Yaⱪup Əsawƣa nan bilǝn ⱪizil purqaⱪ xorpisini bǝrdi. U yǝp-iqip ornidin turup kǝtti. Xundaⱪ ⱪilip Əsaw tunjiliⱪ ⱨoⱪuⱪiƣa xunqǝ etibarsiz ⱪariƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ⱪanaan zeminida Ibraⱨimning waⱪtidiki aqarqiliⱪtin baxⱪa yǝnǝ bir ⱪetimliⱪ aqarqiliⱪ yüz bǝrdi. Xuning bilǝn Isⱨaⱪ Gǝrar xǝⱨirigǝ, Filistiylǝrning padixaⱨi Abimǝlǝkning ⱪexiƣa bardi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Pǝrwǝrdigar uningƣa kɵrünüp mundaⱪ dedi: — Sǝn Misirƣa qüxmǝy, bǝlki Mǝn sanga kɵrsitip beridiƣan yurtta turƣin. ");
INSERT INTO uigpin_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Moxu zemindin qiⱪmay musapir bolup turƣin; xuning bilǝn Mǝn sǝn bilǝn billǝ bolup, sanga bǝht-bǝrikǝt ata ⱪilimǝn; qünki Mǝn sǝn wǝ nǝslinggǝ bu zeminlarning ⱨǝmmisini berip, atang Ibraⱨimƣa bǝrgǝn ⱪǝsimimni ada ⱪilimǝn; ");
INSERT INTO uigpin_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","nǝslingni asmandiki yultuzlardǝk awutimǝn wǝ nǝslinggǝ bu zeminlarning ⱨǝmmisini berimǝn; yǝr yüzidiki barliⱪ ǝl-yurtlar nǝslingning nami bilǝn ɵzlirigǝ bǝht-bǝrikǝt tilǝydu;    ");
INSERT INTO uigpin_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Qünki Ibraⱨim Mening awazimƣa ⱪulaⱪ selip, tapiliƣinim, ǝmrlirim, bǝlgilimilirim wǝ ⱪanunlirimni bǝja kǝltürdi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Xuning bilǝn Isⱨaⱪ Gǝrarda turup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Əmma u yǝrlik kixilǝr uning ayali toƣrisida sorisa u: — Bu mening singlim bolidu, — dedi; qünki Riwkaⱨ intayin qirayliⱪ bolƣaqⱪa, Isⱨaⱪ ɵz-ɵzigǝ: «Bu mening ayalim bolidu», desǝm, bu yǝrlik adǝmlǝr Riwkaⱨning sǝwǝbidin meni ɵltürüwetǝrmikin, — dǝp ⱪorⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Lekin u xu yǝrdǝ uzaⱪ waⱪit turƣandin keyin xundaⱪ boldiki, Filistiylǝrning padixaⱨi Abimǝlǝk dǝrizidin ⱪariwidi, mana Isⱨaⱪ wǝ ayali Riwkaⱨ bir-birigǝ ǝrkilixip turatti. ");
INSERT INTO uigpin_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Andin Abimǝlǝk Isⱨaⱪni qaⱪirip: — Mana, u jǝzmǝn sening ayaling ikǝn! Sǝn nemǝ dǝp: «U mening singlim», deding? — dewidi, Isⱨaⱪ uningƣa: — Qünki mǝn ǝslidǝ uning sǝwǝbidin birsi meni ɵltürüwetǝrmikin, dǝp ǝnsirigǝnidim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimǝlǝk uningƣa: Bu bizgǝ nemǝ ⱪilƣining? Tas ⱪaptu hǝlⱪ arisidin birǝrsi ayaling bilǝn birgǝ bolƣili?! Undaⱪ bolƣan bolsa sǝn bizni gunaⱨⱪa patⱪuzƣan bolatting! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Andin Abimǝlǝk ⱨǝmmǝ hǝlⱪⱪǝ buyrup: — Kimki bu kixigǝ wǝ yaki hotuniƣa ⱪol tǝgküzsǝ jǝzmǝn ɵltürülmǝy ⱪalmaydu, — dǝp yarliⱪ qüxürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isⱨaⱪ u zeminda teriⱪqiliⱪ ⱪildi: u xu yili yǝrdin yüz ⱨǝssǝ ⱨosul aldi; Pǝrwǝrdigar uni bǝrikǝtligǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Bu kixi bax kɵtürüp, barƣanseri rawaj tepip, tolimu katta kixilǝrdin bolup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Uning ⱪoy-kala padiliri wǝ ɵyidiki ⱪulliri intayin kɵpǝydi; Filistiylǝr uningƣa ⱨǝsǝt ⱪilƣili turdi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Bu sǝwǝbtin uning atisi Ibraⱨimning künliridǝ atisining ⱪulliri koliƣan ⱪuduⱪlarning ⱨǝmmisini Filistiylǝr etip, topa bilǝn tinduruwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimǝlǝk Isⱨaⱪⱪa: — Sǝn bizdin ziyadǝ küqiyip kǝtting, ǝmdi arimizdin qiⱪip kǝtkin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isⱨaⱪ u yǝrdin ketip, Gǝrar wadisiƣa qedir tikip, xu yǝrdǝ turup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ibraⱨim ⱨayat waⱪtida ⱪulliri birmunqǝ ⱪuduⱪlarni ⱪazƣanidi; biraⱪ Ibraⱨim ɵlgǝndin keyin, Filistiylǝr bularni topa bilǝn tinduruwǝtkǝnidi. Isⱨaⱪ bu ⱪuduⱪlarni ⱪaytidin kolitip, ularƣa atisi ilgiri ⱪoyƣan isimlarni yǝnǝ ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isⱨaⱪning ⱪulliri wadida ⱪuduⱪ kolawatⱪanda suliri urƣup qiⱪip aⱪidiƣan bir ⱪuduⱪni tepiwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lekin Gǝrardiki padiqilar Isⱨaⱪning padiqiliridin uni talixip: — Bu su bizningkidur, — dedi. Ular Isⱨaⱪ bilǝn jedǝllǝxkǝqkǝ, u bu ⱪuduⱪni «Esǝk» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ular yǝnǝ baxⱪa bir ⱪuduⱪni kolidi, ular yǝnǝ bu ⱪuduⱪ toƣrisida jedǝllǝxti. Xuning bilǝn Isⱨaⱪ buning ismini «Sitnaⱨ» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Andin u u yǝrdin ketip, baxⱪa yǝrgǝ berip, xu yǝrdimu yǝnǝ bir ⱪuduⱪ kolidi; ǝmdi Gǝrardikilǝr bu ⱪuduⱪni talaxmidi. Bu sǝwǝbtin u uning etini «Rǝⱨobot» ⱪoyup: «Əmdi Pǝrwǝrdigar biz üqün jay bǝrgǝnikǝn, bu zeminda mewilik bolimiz», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Andin u u yǝrdin qiⱪip Bǝǝr-Xebaƣa bardi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pǝrwǝrdigar xu keqisi uningƣa kɵrünüp: — Mǝn bolsam atang Ibraⱨimning Hudasidurmǝn; ⱪorⱪmiƣin, qünki Mǝn sǝn bilǝn billimǝn, seni bǝht-bǝrikǝtlǝp, nǝslingni ⱪulum Ibraⱨimning sǝwǝbidin awutimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","U xu yǝrdǝ bir ⱪurbangaⱨ yasap, Pǝrwǝrdigarning namiƣa nida ⱪilip ibadǝt ⱪildi. U xu yǝrdǝ qedirini tikti, Isⱨaⱪning ⱪulliri xu yǝrdǝ bir ⱪuduⱪ kolidi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Əmdi Abimǝlǝk, aƣinisi Aⱨuzzat bilǝn lǝxkǝrbexi Fikol birgǝ Gǝrardin qiⱪip, uning ⱪexiƣa bardi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isⱨaⱪ ularƣa: — Manga ɵqmǝnlik ⱪilip, meni aranglardin ⱪoƣliwǝtkǝndin keyin, nemǝ üqün mening ⱪeximƣa kǝldinglar? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Ular jawabǝn: — Biz Pǝrwǝrdigarning sǝn bilǝn billǝ bolƣinini roxǝn bayⱪiduⱪ, xuning bilǝn biz sening toƣrangda: «Otturimizda bir kelixim bolsun, yǝni bizlǝr bilǝn sǝn bir-birimizgǝ ⱪǝsǝm berip ǝⱨdǝ ⱪilixayli» deduⱪ; xu wǝjidin sǝn bizgǝ ⱨeqⱪandaⱪ ziyan-zǝhmǝt yǝtküzmigǝysǝn; biz sanga ⱨeq tǝgmiginimizdǝk, xundaⱪla sanga yahxiliⱪtin baxⱪa ⱨeqbir nemǝ ⱪilmiƣinimizdǝk (bǝlki seni aman-esǝnlik iqidǝ yolungƣa ǝwǝtkǝniduⱪ) sǝnmu xundaⱪ ⱪilƣaysǝn. Mana ⱨazir sǝn Pǝrwǝrdigar tǝripidin bǝht-bǝrikǝt kɵrüwatisǝn! — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Xuning bilǝn u ularƣa bir ziyapǝt ⱪilip bǝrdi. Ular bolsa yǝp-iqti. ");
INSERT INTO uigpin_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ətisi tang sǝⱨǝrdǝ ular ⱪopup bir-birigǝ ⱪǝsǝm ⱪilixti; andin Isⱨaⱪ ularni yolƣa selip ⱪoydi; ular uning ⱪexidin aman-esǝn kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","U küni xundaⱪ boldiki, Isⱨaⱪning ⱪulliri kelip, uningƣa ɵzi koliƣan ⱪuduⱪ toƣrisida hǝwǝr berip: «Biz su taptuⱪ!» dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","U uning namini «Xibaⱨ» ⱪoydi. Bu sǝwǝbtin bu xǝⱨǝrning ismi bügüngiqǝ «Bǝǝr-Xeba» dǝp atilip kǝlmǝktǝ. ");
INSERT INTO uigpin_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Əsaw ⱪiriⱪ yaxⱪa kirgǝndǝ, Ⱨittiylardin bolƣan Bǝǝrining ⱪizi Yǝⱨudit bilǝn Ⱨittiylardin bolƣan Elonning ⱪizi Basimatni hotunluⱪⱪa aldi. ");
INSERT INTO uigpin_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Əmma bular Isⱨaⱪ bilǝn Riwkaⱨning kɵngligǝ azab elip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isⱨaⱪ ⱪerip, kɵzliri torlixip, kɵzi ƣuwa kɵridiƣan bolup ⱪalƣanda xundaⱪ boldiki, u qong oƣli Əsawni qaⱪirip uningƣa: — Oƣlum! — dedi. U: — Mana mǝn! — dǝp jawab bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","U uningƣa: — Mana mǝn ǝmdi ⱪerip kǝttim, ⱪanqilik kün kɵridiƣinimnimu bilmǝymǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Xunga sǝndin ɵtünimǝn, ⱪoralliring, yǝni sadaⱪ wǝ oⱪyayingni elip janggalƣa qiⱪip, mǝn üqün bir ow owlap kǝl; ");
INSERT INTO uigpin_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","mǝn yahxi kɵridiƣan mǝzzilik tamaⱪtin birni etip, manga kǝltürgin. Mǝn uni yǝp, ɵlüxtin ilgiri kɵnglümdin sanga bǝht-bǝrikǝt tilǝp dua ⱪilay, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isⱨaⱪ oƣli Əsawƣa sɵz ⱪilƣanda Riwkaⱨmu anglidi. Əsaw ow owlap kǝlgili janggalƣa qiⱪip kǝtkǝndǝ, ");
INSERT INTO uigpin_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","7","Riwkaⱨ oƣli Yaⱪupⱪa: — Mana mǝn atangning akang Əsawƣa: «Sǝn ow owlap kelip, manga mǝzzilik bir taamni ǝtkin; mǝn uni yǝp ɵlüp ketixtin burun Pǝrwǝrdigar aldida sanga bǝht-bǝrikǝt tilǝp dua ⱪilay», — dǝp eytⱪinini anglap ⱪaldim. ");
INSERT INTO uigpin_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Əmdi, i oƣlum, sɵzümgǝ ⱪulaⱪ selip buyruƣinimni ⱪilƣin. ");
INSERT INTO uigpin_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Sǝn dǝrⱨal padiƣa berip, ɵqkilǝrning iqidin esil ikki oƣlaⱪni elip kǝlgin; mǝn ulardin atang üqün u yahxi kɵridiƣan mǝzzilik bir taam tǝyyar ⱪilay. ");
INSERT INTO uigpin_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Sǝn uni atangning aldiƣa elip kirgin. Xuning bilǝn u yǝp, ɵlüp ketixtin burun sanga bǝht-bǝrikǝt tilǝp dua ⱪilidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Lekin Yaⱪup anisi Riwkaⱨⱪa: — Mana akam Əsaw bolsa tüklük kixi, mǝn bolsam tüksiz siliⱪ tǝnlik adǝmmǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mubada atam meni silap ⱪalsa, undaⱪta mǝn uning nǝziridǝ uni mazaⱪ ⱪilƣuqi adǝm bolup ⱪelip, beximƣa bǝrikǝt ǝmǝs, bǝlki lǝnǝt taparmǝnmikin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Anisi uningƣa: — Əy oƣlum, sanga qüxidiƣan lǝnǝt manga qüxsun; ǝmma sǝn pǝⱪǝt sɵzümgǝ ⱪulaⱪ selip, berip oƣlaⱪlarni elip kǝl, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","U berip ularni elip kelip, anisiƣa bǝrdi. Anisi uning atisi yahxi kɵridiƣan mǝzzilik bir taamni tǝyyar ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Andin Riwkaⱨ tunji oƣli Əsawning ɵydǝ ɵz yenida saⱪlaⱪliⱪ ǝng esil keyimlirini elip kiqik oƣli Yaⱪupⱪa kiydürüp, ");
INSERT INTO uigpin_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","oƣlaⱪlarning terisini ikki ⱪoli bilǝn boynining tüksiz jayiƣa yɵgǝp, ");
INSERT INTO uigpin_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","andin ɵzi ǝtkǝn mǝzzilik taamlar bilǝn nanlarni oƣli Yaⱪupning ⱪoliƣa tutⱪuzdi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yaⱪup atisining ⱪexiƣa kirip: — Əy ata! — dedi. U: — Mana mǝn! Oƣlum, sǝn kim bolisǝn? — dewidi, ");
INSERT INTO uigpin_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaⱪup atisiƣa jawab berip: — Mǝn qong oƣulliri Əsawmǝn, manga eytⱪanliridǝk ⱪildim; ǝmdi orunliridin turup, olturup ⱪilƣan owumning gɵxigǝ eƣiz tegip, andin kɵngülliridin manga bǝht-bǝrikǝt tilǝp dua ⱪilƣayla, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isⱨaⱪ oƣliƣa: — Əy oƣlum, ⱪandaⱪmu uni xunqǝ tez tepip kǝlding? — dewidi, u jawab berip: — Qünki Pǝrwǝrdigar Hudaliri uni dǝl yolumƣa yoluⱪturdi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isⱨaⱪ Yaⱪupⱪa: — Əy oƣlum, yeⱪinraⱪ kǝl, sǝn rast oƣlum Əsawmu, ǝmǝsmu, silap baⱪay, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Xuning bilǝn Yaⱪup atisi Isⱨaⱪning ⱪexiƣa yeⱪin bardi; u uni silap turup: — Awaz Yaⱪupning awazi, lekin ⱪol bolsa Əsawning ⱪolidur, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Uning ⱪolliri bolsa akisi Əsawning ⱪolliridǝk tüklük bolƣini üqün uni tonuyalmay, uningƣa bǝht-bǝrikǝt tilǝp dua ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Andin u yǝnǝ: — Sǝn rast oƣlum Əsawmusǝn? dǝp soriwidi, u jawab berip: — Dǝl mǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isⱨaⱪ uningƣa: — Taamni elip kǝlgin, mǝn oƣlumning ow gɵxidin yǝp, kɵnglümdin sanga bǝht-bǝrikǝt tilǝp dua ⱪilay, — dedi. Yaⱪup uni uning aldiƣa ⱪoydi; u yedi. U xarab kǝltürüwidi, unimu iqti. ");
INSERT INTO uigpin_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Andin atisi Isⱨaⱪ uningƣa: — Əy oƣlum, ǝmdi yeⱪin kelip meni sɵygin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","U uning ⱪexiƣa berip uni sɵydi. Atisi uning kiyimining puriⱪini purap uningƣa bǝht-bǝrikǝt tilǝp dua ⱪilip: — «Mana, oƣlumning tenidiki puraⱪ Pǝrwǝrdigar bǝrikǝtligǝn kɵklǝmzarning hux puriⱪiƣa ohxaydikǝn! ");
INSERT INTO uigpin_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Huda sanga asmanning xǝbnimi, Yǝrning munbǝt küqini ata ⱪilip, Axliⱪ-tülük bilǝn xarabnimu kɵp bǝrgǝy. ");
INSERT INTO uigpin_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hǝlⱪlǝr sening ⱪulluⱪungda bolƣay, Əl-millǝtlǝr aldingda tizlanƣay; Ⱪerindaxliringƣa hoja bolƣaysǝn; Anangning oƣulliri sanga tizlanƣay; Sanga lǝnǝt ⱪilƣanlar lǝnǝtkǝ ⱪalƣay; Sanga bǝht tiligǝnlǝr bǝht tapⱪay!» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Xundaⱪ boldiki, Isⱨaⱪ Yaⱪupⱪa dua ⱪilip bolup, Yaⱪup atisi Isⱨaⱪning ⱪexidin qiⱪip boluxiƣa, akisi Əsaw owdin ⱪaytip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Umu mǝzzilik taamlarni etip, atisining ⱪexiƣa elip kirip, atisiƣa: — Ata ⱪopⱪayla, oƣullirining ow gɵxidin yǝp, kɵngülliridin manga bǝht-bǝrikǝt tilǝp dua ⱪilƣayla, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Atisi Isⱨaⱪ uningƣa: — Sǝn kimsǝn? — dedi. U jawab berip: — Mǝn oƣulliri, qong oƣulliri Əsawmǝn! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Buni anglap Isⱨaⱪ alaⱪzadilikkǝ qüxüp, pütün bǝdini jalaⱪlap titrǝp: — Undaⱪta bayatin ow owlap elip kǝlgini kim? Sǝn kelixtin burun uning ⱨǝmmǝ nǝrsisidin yǝp, uningƣa bǝht-bǝrikǝt tilǝp dua ⱪildim; wǝ bǝrⱨǝⱪ, u bǝht-bǝrikǝt kɵridu! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Əsaw atisining sɵzlirini anglapla intayin eqinarliⱪ ⱨalda ün selip aqqiⱪ pǝryad kɵtürüp atisiƣa: — Menimu, i ata, menimu bǝht-bǝrikǝtligǝyla! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","U jawab berip: — Sening ining ⱨiylǝ bilǝn kirip, sanga tegixlik bǝht-bǝrikǝtni elip ketiptu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Əsaw: — Rast uning eti Yaⱪup ǝmǝsmu?! Qünki u ikki ⱪetim meni putlap, ornumni tartiwaldi. Awwal tunjiliⱪ ⱨoⱪuⱪumni tartiwaldi wǝ mana ⱨazir u manga tegidiƣan bǝht-bǝrikǝtni elip kǝtti, — dedi, Andin yǝnǝ: — Mening üqün birǝr bǝht-bǝrikǝt ⱪaldurmidilimu? — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isⱨaⱪ Əsawƣa jawab berip: — Mana, mǝn uni üstünggǝ hoja ⱪildim; ⱨǝmmǝ ⱪerindaxlirini uning ⱪulluⱪida bolidiƣan ⱪildim; axliⱪ wǝ yengi xarab bilǝn uni ⱪuwwǝtlidim; ǝy oƣlum, ǝmdi sanga yǝnǝ nemimu ⱪilip berǝlǝymǝn? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Əsaw atisiƣa yǝnǝ: — Əy ata, silidǝ pǝⱪǝt xu birla bǝht-bǝrikǝt bar idimu? Manga, ǝy ata, mangimu bǝht-bǝrikǝt tilǝp dua ⱪilƣayla! dedi. Andin u ün selip yiƣlap kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Atisi Isⱨaⱪ uningƣa jawab berip: — «Mana, turalƣu jaying yǝrning munbǝt küqidin neri, Egiz asmanning xǝbnimidin yiraⱪ bolur; ");
INSERT INTO uigpin_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Sǝn ⱪiliqingƣa tayinip jan baⱪisǝn, Iningning hizmitidǝ bolisǝn; Lekin qegridin qiⱪip kǝzginingdǝ, Sǝn boynungdin uning boyunturuⱪini qiⱪirip sunduruwetisǝn» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Xunga Əsaw atisi uningƣa tiligǝn bǝht-bǝrikǝt sǝwǝbidin Yaⱪupⱪa ɵqmǝnlik saⱪlap yürdi. Əsaw kɵnglidǝ: — Atamning matǝm künliri yeⱪinlixip ⱪaldi; xu qaƣda inim Yaⱪupni ɵltürüwetimǝn, dǝp hiyal ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Lekin Riwkaⱨ qong oƣli Əsawning bu sɵzliridin hǝwǝr tapti. U kiqik oƣli Yaⱪupni qaⱪirip uningƣa: — Mana akang Əsaw seni ɵltürüwetimǝn dǝp ɵz-ɵzidin tǝsǝlli tepiwetiptu; ");
INSERT INTO uigpin_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ǝmdi ǝy oƣlum, sɵzümgǝ ⱪulaⱪ selip, ⱪopup Ⱨaranƣa, akam Labanning ⱪexiƣa ⱪeqip kǝtkin; ");
INSERT INTO uigpin_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","akangning ⱪǝⱨri yanƣuqǝ, uning ⱪexida birnǝqqǝ waⱪit turƣin. ");
INSERT INTO uigpin_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Akang aqqiⱪidin yenip, sening uningƣa ⱪilƣiningni untup kǝtküqǝ xu yǝrdǝ turup turƣin; andin mǝn adǝm ǝwǝtip, seni u yǝrdin aldurup kelimǝn. Nemǝ üqün bir kündila ⱨǝr ikkinglardin mǝⱨrum bolup ⱪalay? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Əmma Riwkaⱨ Isⱨaⱪⱪa: — Mǝn muxu Ⱨittiy ⱪizlar wǝjidin jenimdin jaⱪ toydum. Əgǝr Yaⱪupmu bu yurttiki ⱪizlardin, muxundaⱪ Ⱨittiy ⱪizni hotunluⱪⱪa alsa yaxiƣinimning manga nemǝ paydisi? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Xuning bilǝn Isⱨaⱪ Yaⱪupni qaⱪirip, uningƣa bǝht-bǝrikǝt tilǝp, uningƣa jekilǝp: — Sǝn Ⱪanaaniylarning ⱪizliridin hotun alma; ");
INSERT INTO uigpin_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","bǝlki ⱪopup, Padan-Aramƣa, anangning atisi Betuǝlning ɵyigǝ berip, u yǝrdin anangning akisi Labanning ⱪizliridin hotun alƣin. ");
INSERT INTO uigpin_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ⱨǝmmigǝ Ⱪadir Tǝngri seni bǝht-bǝrikǝtlǝp, awutup, sǝndin kɵp hǝlⱪlǝrni qiⱪirip kɵpǝytkǝy, ");
INSERT INTO uigpin_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Xundaⱪla Ibraⱨimning bǝht-bǝrikitini sanga wǝ sening bilǝn nǝslinggǝ bǝrgǝy; xundaⱪ ⱪilip sǝn ⱨazir Musapir bolup turuwatⱪan yǝrni, yǝni ǝslidǝ Huda Ibraⱨimƣa bǝrgǝn zeminni igilǝysǝn! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Xuning bilǝn Isⱨaⱪ Yaⱪupni yolƣa saldi. U Padan-Aramƣa, aramiy Betuǝlning oƣli, Yaⱪup bilǝn Əsawning anisi Riwkaⱨning akisi Labanning ⱪexiƣa ⱪarap mangdi. ");
INSERT INTO uigpin_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Əsaw Isⱨaⱪning Yaⱪupⱪa bǝht-bǝrikǝt tilǝp, uni Padan-Aramƣa xu yǝrdin hotun elixⱪa ǝwǝtkǝnlikini, xundaⱪla uningƣa bǝht-bǝrikǝt tilǝp, uninga jekilǝp: Sǝn Ⱪanaaniylarning ⱪizliridin hotun almiƣin, degǝnlirini uⱪup, Yaⱪupningmu ɵz ata-anisiƣa itaǝt ⱪilip, Padan-Aramƣa kǝtkinini kɵrginidǝ, ");
INSERT INTO uigpin_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Əsaw: — ⱪanaanylarning ⱪizliri atam Isⱨaⱪning nǝziridǝ yaman kɵrünidikǝn, dǝp bilip yǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","U Ismailning ⱪexiƣa berip, ⱨazirⱪi hotunlirining üstigǝ Ibraⱨimning oƣli Ismailning ⱪizi, Nebayotning singlisi Maⱨalatni hotunluⱪⱪa aldi. ");
INSERT INTO uigpin_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaⱪup bolsa Bǝǝr-Xebadin qiⱪip, Ⱨaran tǝrǝpkǝ mengip, ");
INSERT INTO uigpin_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","bir yǝrgǝ yetip kǝlgǝndǝ, kün olturup kǝtkǝqkǝ xu yǝrdǝ ⱪonmaⱪqi boldi. U xu yǝrdiki taxlardin birini elip, bexiƣa yastuⱪ ⱪilip ⱪoyup, uhliƣili yatti. ");
INSERT INTO uigpin_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","U bir qüx kɵrdi: — Mana, uqi asmanlarƣa taⱪixidiƣan bir pǝlǝmpǝy yǝrdǝ tiklǝklik turatti; Hudaning pǝrixtiliri uningda qiⱪip-qüxüp turuxatti. ");
INSERT INTO uigpin_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mana, Pǝrwǝrdigar uning üstidǝ turatti. U: — «Mǝn bolsam atang Ibraⱨimning Hudasi wǝ Isⱨaⱪning Hudasi bolƣan Pǝrwǝrdigardurmǝn; Mǝn sǝn yatⱪan bu zeminni sening bilǝn nǝslinggǝ berimǝn.    ");
INSERT INTO uigpin_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nǝsling bolsa yǝrning topisidǝk kɵp bolup, sǝn mǝƣrib bilǝn mǝxriⱪⱪǝ, ximal bilǝn jǝnubⱪa yeyilisǝn; sǝn wǝ nǝslingning wasitisi bilǝn yǝr yüzidiki barliⱪ ailǝ-ⱪǝbililǝr bǝht-bǝrikǝt tapidu. ");
INSERT INTO uigpin_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mana, Mǝn sǝn bilǝn billidurmǝn, ⱪǝyǝrgǝ barsang seni aman-esǝn saⱪlap, bu zeminƣa seni ⱪayturup kelimǝn; qünki sanga eytⱪan sɵzümni ada ⱪilmay turup, seni taxlimaymǝn» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Andin Yaⱪup oyƣinip: — Bǝrⱨǝⱪ, Pǝrwǝrdigar bu yǝrdidur, lekin mǝn uni bilmǝptimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","U ⱪorⱪup ketip: Bu jay alamǝt dǝⱨxǝtlik bir jay ikǝn! Bu Hudaning ɵyi bilǝn asmanning dǝrwazisidin baxⱪa ⱨeq jay ǝmǝstur, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yaⱪup ǝtisi sǝⱨǝr ⱪopup, bexining astiƣa ⱪoyƣan taxni elip, hatirǝ tüwrük süpitidǝ tiklǝp, üstigǝ zǝytun meyi ⱪuyup ⱪoydi.    ");
INSERT INTO uigpin_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","U jayning ismini Bǝyt-Əl dǝp atidi; ǝmma ilgiri u jayning eti Luz idi. ");
INSERT INTO uigpin_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Andin Yaⱪup ⱪǝsǝm bilǝn wǝdǝ ⱪilip: — Əgǝr Huda mening bilǝn billǝ bolup, bu sǝpirimdǝ meni saⱪlap, yegili nan, kiygili kiyim berip, ");
INSERT INTO uigpin_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Mǝn atamning ɵyigǝ aman-esǝn yenip barsam, undaⱪta Pǝrwǝrdigar mening Hudayim bolidu; ");
INSERT INTO uigpin_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Xuningdǝk mǝn hatirǝ tüwrük süpitidǝ tiklǝp ⱪoyƣan bu tax Hudaning ɵyi bolidu; ⱨǝm xundaⱪla sǝn manga beridiƣan barliⱪ nǝrsilǝrning ondin bir ülüxini sanga tǝⱪdim ⱪilmay ⱪalmaymǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Andin Yaⱪup sǝpirini dawamlaxturup, mǝxriⱪtiki ⱪowmlarning zeminiƣa yetip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","U ⱪariwidi, mana, yaylaⱪta bir ⱪuduⱪ turatti, uning yenida üq top ⱪoy padisi turatti; qünki hǝlⱪ bu ⱪuduⱪtin padilarni suƣiratti. Ⱪuduⱪning aƣziƣa yoƣan bir tax ⱪoyuⱪluⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ⱪaqaniki padilarning ⱨǝmmisi u yǝrgǝ yiƣilsa, padiqilar birliktǝ ⱪuduⱪning aƣzidiki taxni yumilitiwetip, ⱪoylarni suƣirip, andin taxni yǝnǝ ⱪuduⱪning aƣziƣa ɵz orniƣa ⱪoyup ⱪoyatti. ");
INSERT INTO uigpin_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaⱪup padiqilardin: Əy buradǝrlǝr, silǝr ⱪǝyǝrlik? — dǝp soridi. Ular: — Biz ⱨaranliⱪmiz, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","U ulardin: — Silǝr Naⱨorning oƣli Labanni tonumsilǝr? — dǝp soridi. Ular: — Tonuymiz, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","U ulardin: — U salamǝtmu, dǝp soriwidi, ular jawab berip: — U salamǝt turuwatidu. Mana ǝnǝ uning ⱪizi Raⱨilǝ ⱪoyliri bilǝn keliwatidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","U: — Mana, kün tehi egiz tursa, ⱨazir tehi malning yiƣilidiƣan waⱪti bolmidi; nemixⱪa ⱪoylarni suƣirip, andin yǝnǝ berip otlatmaysilǝr? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ular jawab berip: — Yaⱪ, mundaⱪ ⱪilalmaymiz. Awwal padilarning ⱨǝmmisi yiƣilip, padiqilar taxni ⱪuduⱪning aƣzidin yumilitiwǝtkǝndin keyin, andin ⱪoylarni suƣirimiz, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","U ular bilǝn gǝplixip turƣinida, Raⱨilǝ atisining ⱪoyliri bilǝn yetip kǝldi; qünki u ⱪoy baⱪⱪuqi idi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Xundaⱪ boldiki, Yaⱪup anisining akisi Labanning ⱪizi Raⱨilǝ bilǝn anisining akisi Labanning ⱪoylirini kɵrgǝndǝ, u ⱪopup berip, ⱪuduⱪning aƣzidin taxni yumilitiwetip, anisining akisi Labanning ⱪoylirini suƣardi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","Andin Yaⱪup Raⱨilǝni sɵyüp, yuⱪiri awaz bilǝn yiƣlap taxlidi wǝ Raⱨilǝgǝ: — Mǝn sening atangning tuƣⱪini, Riwkaⱨning oƣli bolimǝn, dewidi, u yügürüp berip atisiƣa hǝwǝr bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Xundaⱪ boldiki, Laban ɵz singlisining oƣli Yaⱪupning hǝwirini angliƣanda, uning aldiƣa yügürüp berip, uni ⱪuqaⱪlap sɵyüp, ɵyigǝ baxlap kǝldi. Andin Yaⱪup Labanƣa kǝqürmixlirining ⱨǝmmisini dǝp bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban uningƣa: — Sǝn dǝrwǝⱪǝ mening sɵngǝk bilǝn gɵxümdursǝn! — dedi. Buning bilǝn u uning ⱪexida bir ayqǝ turup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Andin Laban Yaⱪupⱪa: — Sǝn mening tuƣⱪinim bolƣaq, manga bikarƣa hizmǝt ⱪilamsǝn? Eytⱪina, ⱨǝⱪⱪinggǝ nemǝ alisǝn? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labanning ikki ⱪizi bar idi; qongining eti Leyaⱨ, kiqikining eti Raⱨilǝ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leyaⱨning kɵzliri yeⱪimliⱪ idi; ǝmma Raⱨilǝning bolsa tǝⱪi-turⱪi kelixkǝn, ⱨɵsni-jamali qirayliⱪ ⱪiz idi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaⱪupning kɵngli Raⱨilǝgǝ qüxkǝn bolup Labanƣa: — Mǝn sening kiqik ⱪizing Raⱨilǝ üqün sanga yǝttǝ yil hizmǝt ⱪilay, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban jawab berip: — Uni baxⱪa kixigǝ bǝrginimdin sanga bǝrginim yahxi. Əmdi meningkidǝ turƣin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yaⱪup Raⱨilǝni elix üqün yǝttǝ yil hizmǝt ⱪildi. Əmma u uni intayin yahxi kɵrgǝqkǝ, bu yillar uningƣa pǝⱪǝt birnǝqqǝ kündǝkla bilindi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Waⱪit toxⱪanda Yaⱪup Labanƣa: — Mana mening künlirim toxti. Əmdi ayalimni manga bǝrgin, mǝn uning ⱪexiƣa kirǝy, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban xu yǝrdiki ⱨǝmmǝ kixilǝrni yiƣip, ziyapǝt ⱪilip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Lekin xundaⱪ boldiki, kǝq kirgǝndǝ, u qong ⱪizi Leyaⱨni Yaⱪupning yeniƣa elip kǝldi; Yaⱪup uning ⱪexiƣa kirip billǝ boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban ɵz dediki Zilpaⱨni ⱪizi Leyaⱨⱪa dedǝk ⱪilip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ətisi xundaⱪ boldiki, mana aldida Leyaⱨ turatti! U Labanƣa: — Bu zadi manga nemǝ ⱪilƣining? Əjǝba, mǝn Raⱨilǝ üqün sanga hizmǝt ⱪilmidimmu? Meni nemixⱪa xundaⱪ aldiding?! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban: Bizning yurtimizda kiqikini qongidin ilgiri yatliⱪ ⱪilidiƣan rǝsim-ⱪaidǝ yoⱪ. ");
INSERT INTO uigpin_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Əmdi sǝn qongining yǝttǝ künlük toy murasimini ɵtküzüp bolƣin; andin yǝnǝ ikkinqisinimu sanga berǝyli; u sening manga yǝnǝ yǝttǝ yil ⱪilidiƣan hizmitingning ⱨǝⱪⱪi bolidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaⱪup maⱪul bolup, Leyaⱨning yǝttǝ künlük toy murasimini ɵtküzüp bolƣanda, Laban ⱪizi Raⱨilǝnimu uningƣa hotunluⱪⱪa bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban dediki Bilⱨaⱨni ⱪizi Raⱨilǝgǝ dedǝk ⱪilip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Bu tǝriⱪidǝ Yaⱪup Raⱨilǝningmu ⱪexiƣa kirdi; u Raⱨilǝni Leyaⱨdin ziyadǝ yahxi kɵrdi. Andin keyin u yǝnǝ yǝttǝ yil Labanƣa hizmǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Əmma Pǝrwǝrdigar Leyaⱨning ǝtiwarlanmiƣanliⱪini kɵrgǝndǝ, uningƣa tuƣuxni nesip ⱪildi. Lekin Raⱨilǝ tuƣmas idi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leyaⱨ ⱨamilidar bolup bir oƣul tuƣup: — «Pǝrwǝrdigar harlanƣinimni kɵrdi; ǝmdi erim meni yahxi kɵridu» dǝp uning ismini «Rubǝn» ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","U yǝnǝ ⱨamilidar bolup, bir oƣul tuƣup: — «Pǝrwǝrdigar ǝtiwarlanmiƣanliⱪini anglap, buni ⱨǝm manga bǝrdi» dǝp, uning ismini Ximeon ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","U yǝnǝ ⱨamilidar bolup, bir oƣul tuƣup: — «Əmdi bu ⱪetim erim manga baƣlinidu; qünki mǝn uningƣa üq oƣul tuƣup bǝrdim» dǝp uning ismini Lawiy ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","U yǝnǝ ⱨamilidar bolup, bir oƣul tuƣup: — «Əmdi bu ⱪetim mǝn Pǝrwǝrdigarƣa ⱨǝmdusana oⱪuy!» dǝp uning ismini Yǝⱨuda ⱪoydi. Andin u tuƣuttin tohtap ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Əmma Raⱨilǝ ɵzining Yaⱪupⱪa bala tuƣup berǝlmiginini kɵrgǝndǝ, aqisiƣa ⱨǝsǝt ⱪilip Yaⱪupⱪa: — Manga bala bǝrgin; bolmisa ɵlimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Xuning bilǝn Yaⱪupning Raⱨilǝgǝ ƣǝzipi kelip: — Mǝn baliyatⱪuning mewisini sǝndin ayiƣan Hudaning ornidimu?! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","— Mana, dedikim Bilⱨaⱨ bu yǝrdǝ turidu; sǝn uning ⱪexiƣa kirgin, u mening ⱪuqiⱪimƣa tuƣsun; mǝn u arⱪiliⱪ baliliⱪ bolay, — dedi Raⱨilǝ. ");
INSERT INTO uigpin_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Xuning bilǝn u dediki Bilⱨaⱨni uningƣa hotun ⱪilip bǝrdi; Yaⱪup uning ⱪexiƣa kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilⱨaⱨ ⱨamilidar bolup, Yaⱪupⱪa bir oƣul tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raⱨilǝ: — «Huda mǝn üqün adalǝt yürgüzüp pǝryadimni anglap, manga bir oƣul bǝrdi», dǝp uning ismini Dan ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Raⱨilǝning dediki Bilⱨaⱨ yǝnǝ ⱨamilidar bolup, Yaⱪupⱪa ikkinqi oƣlini tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raⱨilǝ: — «Mǝn aqam bilǝn bǝslixip ⱪattiⱪ tutuxup, yǝngdim» dǝp uning ismini Naftali ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leyaⱨ ɵzining tuƣuttin tohtap ⱪalƣanini kɵrüp, dediki Zilpaⱨni Yaⱪupⱪa hotun ⱪilip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Leyaⱨning dediki Zilpaⱨ Yaⱪupⱪa bir oƣul tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leyaⱨ: — «Nemidegǝn tǝlǝylik-ⱨǝ!» dǝp uning ismini Gad ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leyaⱨning dediki Zilpaⱨ Yaⱪupⱪa ikkinqi oƣlini tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leyaⱨ: «Mǝn bǝhtlikturmǝn! Qünki hotun-ⱪizlar meni bǝhtlik deyixidu!» dǝp uning ismini Axir ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Buƣday ormisi künliridǝ Rubǝn qiⱪip etizliⱪⱪa bardi wǝ etizdin birⱪanqǝ muⱨǝbbǝtgülini terip, bularni anisi Leyaⱨning ⱪexiƣa ǝkǝldi. Əmdi Raⱨilǝ Leyaⱨⱪa: — Ɵtünüp ⱪalay, oƣlungning muⱨǝbbǝtgülidin birnǝqqini manga bǝrgin! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leyaⱨ uningƣa jawabǝn: — Erimni tartiwalƣining yǝtmǝmdu? Əmdi oƣlumning muⱨǝbbǝtgülinimu tartiwalmaⱪqimusǝn? — dedi. Raⱨilǝ jawab berip: — Undaⱪ bolsa u oƣlungning muⱨǝbbǝtgülliri üqün bügün keqǝ sǝn bilǝn yatsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yaⱪup kǝqⱪurun etizdin ⱪaytip kǝlginidǝ, Leyaⱨ uning aldiƣa qiⱪip: — Mening ⱪeximƣa kirixing kerǝk; qünki mǝn oƣlumning muⱨǝbbǝtgülliri bilǝn seni ijarigǝ aldim, — dedi. Xundaⱪ dewidi, u bu keqǝ uning bilǝn yatti. ");
INSERT INTO uigpin_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Huda Leyaⱨning duasini anglidi; u ⱨamilidar bolup, Yaⱪupⱪa bǝxinqi oƣlini tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Xuning bilǝn Leyaⱨ: «Dedikimni erimgǝ bǝrginimgǝ Huda ǝmdi manga «ijarǝ ⱨǝⱪⱪim»ni ata ⱪildi» dǝp uning ismini Issakar ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leyaⱨ yǝnǝ ⱨamilidar bolup, Yaⱪupⱪa altinqi oƣlini tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leyaⱨ: — «Huda manga yahxi toyluⱪ ata ⱪildi; ǝmdi erim mening bilǝn billǝ turidiƣan boldi; qünki mǝn uningƣa altǝ oƣul tuƣup bǝrdim» dǝp uning ismini Zǝbulun ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Xuningdin keyin, u bir ⱪiz tuƣup, uning ismini Dinaⱨ ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Əmma Huda Raⱨilǝni yad ⱪilip, duasini anglap uni tuƣidiƣan ⱪildi, ");
INSERT INTO uigpin_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","U ⱨamilidar bolup, bir oƣul tuƣdi. U: — «Huda meni nomustin halas ⱪildi», dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","U: — «Pǝrwǝrdigar manga yǝnǝ bir bala bǝrsǝ» dǝp, uning ismini Yüsüp ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raⱨilǝ Yüsüpni tuƣⱪandin keyin Yaⱪup Labanƣa: — Meni ɵz yurtumƣa, ɵz wǝtinimgǝ kǝtkili ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mening sanga ixlǝp erixkǝn ix ⱨǝⱪⱪim bolƣan ayallirim bilǝn balilirimni manga bǝrgin; mǝn ketǝy; qünki mening sanga ixligǝn japaliⱪ hizmitim ɵzünggǝ ayan, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban uningƣa jawabǝn: Nǝziringdǝ iltipat tapⱪan bolsam, ɵtünüp ⱪalay, yenimdin kǝtmǝ. Qünki mǝn Pǝrwǝrdigarning sening sǝwǝbingdin manga bǝrikǝt bǝrginini tonup yǝttim, dewidi, Yaⱪup yǝnǝ: — ");
INSERT INTO uigpin_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Manga alidiƣan ⱨǝⱪⱪingni tohtatⱪin; mǝn sanga xuni berǝy, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaⱪup uningƣa jawab berip: — Mǝn sanga ⱪandaⱪ hizmǝt ⱪilip kǝlginim, mening ⱪolumda malliringning ⱪandaⱪ bolƣini ɵzünggǝ ayan. ");
INSERT INTO uigpin_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Qünki mǝn kǝlmǝstǝ meling az idi; ǝmdi naⱨayiti zor bir top boldi. Mening ⱪǝdimim ⱪǝyǝrgǝ yǝtsǝ, Pǝrwǝrdigar sanga bǝrikǝt ata ⱪildi. Əmdi mǝn ⱪaqan ɵz ailǝm üqün igilik tiklǝymǝn? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Xuning bilǝn Laban: — Mǝn sanga nemǝ berǝy, dewidi, Yaⱪup: — Sǝn manga ⱨeqnemǝ bǝrmigin; pǝⱪǝt mening xu iximƣa ⱪoxulsangla, mǝn yǝnǝ padangni beⱪip, ulardin hǝwǝr alimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Mǝn bügün pütkül padangni arilap, ala-qipar ⱪoylarni, ⱪara-ⱪongur pahlanlarni, xundaⱪla ɵqkilǝrning iqidinmu ala-qiparlirini ayrip qiⱪimǝn. Bular mening ix ⱨǝⱪⱪim bolsun. ");
INSERT INTO uigpin_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Keyin, mening ⱨǝⱪⱪimni tǝkxürüp kǝlgǝn waⱪtingda, ⱨǝⱪⱪaniy bolƣinim kɵz aldingda ispatlinidu; ɵqkilǝr arisida ala-qipar bolmiƣanlirining ⱨǝmmisi, pahlanlar arisida ⱪara-ⱪongur bolmiƣanlirining ⱨǝmmisi oƣrilap kelingǝn ⱨesablansun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","u waⱪitta Laban: — Maⱪul, deginingdǝk bolsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Xu küni Laban taƣil wǝ ala-qipar tekilǝrni, ala-qipar qixi ɵqkilǝrni, xundaⱪla az-paz aⱪ qikimi bolƣan barliⱪ ɵqkilǝrni, barliⱪ ⱪara-ⱪongur ⱪozilarni ayrip, ɵz oƣullirining ⱪoliƣa tapxurup, ");
INSERT INTO uigpin_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ɵzi bilǝn Yaⱪupning otturisida üq künlük ariliⱪni ⱪoydi. Yaⱪup bolsa Labanning padilirining ⱪalƣinini baⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Lekin Yaⱪup terǝk, badam wǝ qinar dǝrǝhliridin yumran qiwiⱪlarni elip, ⱪowziⱪini yolluⱪ ⱪilip xilip, aⱪ siziⱪlarni qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Andin mal küyligǝn waⱪitlirida su iqkili kǝlgǝndǝ, u muxu xilƣan qiwiⱪlarni padilar su iqidiƣan yǝrlǝrdiki ulaⱪlarƣa malning aldiƣa tiklǝp ⱪoyatti. Mal bu taƣil qiwiⱪlarning aldida jüplǝxkǝndin keyin ular taƣil wǝ ala-qipar ⱪozilarni tuƣdi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Andin Yaⱪup bu ⱪozilarni Labanning padisidin ayrip qiⱪardi; andin u Labanning padisining yüzlirini taƣil wǝ ⱪongur ⱪoyliriƣa ⱪaritip jüplǝxtürdi; xundaⱪ ⱪilip, u ɵz melini Labanning meliƣa ⱪoxmay bɵlǝk ⱪoyup, ɵzi üqün ayrim badilarni ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Saƣlam küqlük mal jüplǝxkinidǝ, Yaⱪup qiwiⱪlarni padining kɵz aldiƣa ulaⱪlarda ⱪoyatti; mallar xu qiwiⱪlarning yenida jüplixǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Lekin jüplixiwatⱪan mal ajiz bolsa, u qiwiⱪlarni ⱪoymaytti. Bu tǝriⱪidǝ ajizliri Labanƣa, küqlükliri Yaⱪupⱪa tǝwǝ boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Xundaⱪ ⱪilip, bu kixi naⱨayiti bay bolup, malliri, dedǝkliri, ⱪulliri, tɵgiliri wǝ exǝkliri heli kɵp boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Əmma Yaⱪup Labanning oƣullirining: — Yaⱪup atimizning pütün mal-mülkini elip kǝtti; uning erixkǝn bu dɵliti atimizning tǝǝlluⱪatidin kǝlgǝn, deginini anglap ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaⱪup Labanning qirayiƣa ⱪariwidi, mana, u ɵzigǝ burunⱪidǝk hux peil bolmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Bu qaƣda, Pǝrwǝrdigar Yaⱪupⱪa: — Sǝn ata-bowiliringning zeminiƣa, ɵz uruⱪ-tuƣⱪanliringning ⱪexiƣa ⱪaytip kǝtkin. Mǝn sening bilǝn billǝ bolimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Xuning üqün Yaⱪup adǝm ǝwǝtip, Raⱨilǝ wǝ Leyaⱨni ɵz padisi turƣan kɵklǝmgǝ qaⱪirip kelip ");
INSERT INTO uigpin_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ularƣa mundaⱪ dedi: — Mǝn atanglarning qirayiƣa ⱪarisam manga burunⱪidǝk hux peil bolmidi; ǝmma atamning Hudasi mǝn bilǝn billǝ bolup kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Küqümning yetixiqǝ atanglarƣa ixlǝp bǝrginim silǝrgǝ ayan; ");
INSERT INTO uigpin_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ⱨalbuki, atanglar meni ǝhmǝⱪ ⱪilip, ⱨǝⱪⱪimni on ⱪetim ɵzgǝrtti; lekin Huda uning manga ziyan yǝtküzüxigǝ yol ⱪoymidi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Əgǝr u: «Ala-qipar ⱪozilar ⱨǝⱪⱪing bolidu», desǝ, barliⱪ padilar ala-qipar ⱪoziliƣili turdi. U: «Taƣil ⱪozilar ⱨǝⱪⱪing bolsun», desǝ, barliⱪ padilar taƣil ⱪoziliƣili turdi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bu tǝriⱪidǝ Huda atanglarning mallirini tartiwelip, manga bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Padilar küyligǝn waⱪitta mǝn bir ⱪetim qüxümdǝ beximni kɵtürüp xuni kɵrdumki, mana, mallarning üstigǝ jüplixixkǝ etilƣan ⱪoqⱪar-tekilǝrning ⱨǝmmisi taƣil yaki ala-qipar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Andin Hudaning Pǝrixtisi qüxümdǝ manga: «Əy Yaⱪup», dewidi, mǝn jawab berip: «Mana mǝn», dedim. ");
INSERT INTO uigpin_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","U manga: — «Əmdi bexingni kɵtürüp ⱪariƣin; mana mallarning üstigǝ jüplixixkǝ etilƣan ⱪoqⱪar-tekilǝrning ⱨǝmmisi taƣil wǝ ala-qipardur; qünki Mǝn Labanning sanga ⱪilƣinining ⱨǝmmisini kɵrdüm. ");
INSERT INTO uigpin_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mǝn Bǝyt-Əldǝ sanga kɵrüngǝn Tǝngridurmǝn. Sǝn xu yǝrdǝ tüwrükni mǝsiⱨlǝp, Manga ⱪǝsǝm iqting. Əmdi sǝn orningdin turup, bu zemindin qiⱪip, uruⱪ-tuƣⱪanliringning zeminiƣa yanƣin» dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raⱨilǝ wǝ Leyaⱨ uningƣa jawab berip: — Atimizning ɵyidǝ bizgǝ tegixlik nesiwǝ yaki miras ⱪalmiƣanmu? ");
INSERT INTO uigpin_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Biz dǝrwǝⱪǝ uningƣa yat adǝm ⱨesablinip ⱪalƣanmu?! U bizni setiwǝtti, toyluⱪimiznimu pütünlǝy yǝp kǝtti! ");
INSERT INTO uigpin_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Xundaⱪ bolƣandin keyin, Huda Atimizdin sanga elip bǝrgǝn barliⱪ dɵlǝt biz bilǝn balilirimizningkidur. Əmdi Huda sanga nemǝ degǝn bolsa, xuni ⱪilƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Xuning bilǝn Yaⱪup ornidin turup, baliliri wǝ ayallirini tɵgilǝrgǝ mindurup, erixkǝn barliⱪ malliri wǝ barliⱪ tǝǝlluⱪatini, yǝni Padan-Aramda tapⱪan tǝǝlluⱪatlirini elip, atisi Isⱨaⱪning yeniƣa berixⱪa Ⱪanaan zeminiƣa ⱪarap yol aldi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban bolsa ⱪoylirini ⱪirⱪiƣili kǝtkǝnidi; Raⱨilǝ ɵz atisiƣa tǝwǝ «ɵy butliri»ni oƣrilap eliwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaⱪup aramiy Labanƣa ɵz ⱪexidin oƣriliⱪqǝ ⱪeqip ketidiƣanliⱪini uⱪturmay uni aldap ⱪoyƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","U bar-yoⱪini elip ⱪeqip kǝtti; u dǝryadin ɵtüp Gilead teƣi tǝrǝpkǝ ⱪarap yol aldi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Üqinqi küni, Labanƣa Yaⱪupning ⱪaqⱪini toƣrisida hǝwǝr yǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","U ɵz tuƣⱪanlirini elip, yǝttǝ künlük yolƣiqǝ kǝynidin ⱪoƣlap berip, Gilead teƣida uningƣa yetixti. ");
INSERT INTO uigpin_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Lekin keqisi Huda aramiy Labanning qüxigǝ kirip uningƣa: «Sǝn ⱨezi bol, Yaⱪupⱪa ya aⱪ ya kɵk demǝ!» dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban Yaⱪupⱪa yetixip barƣanda, Yaⱪup qedirini taƣning üstigǝ tikkǝnidi. Labanmu tuƣⱪanliri bilǝn Gilead teƣining üstidǝ qedir tikti. ");
INSERT INTO uigpin_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban Yaⱪupⱪa: — Bu nemǝ ⱪilƣining? Sǝn meni aldap, ⱪizlirimni uruxta alƣan oljidǝk elip kǝtting? ");
INSERT INTO uigpin_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nemixⱪa yoxurun ⱪaqisǝn, manga hǝwǝr bǝrmǝy mǝndin oƣriliⱪqǝ kǝtting? Manga degǝn bolsang mǝn huxal-huramliⱪ bilǝn ƣǝzǝl oⱪup, dap wǝ qang qelip, seni uzitip ⱪoymamtim? ");
INSERT INTO uigpin_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Xundaⱪ ⱪilip sǝn manga ɵz oƣullirim wǝ ⱪizlirimni sɵyüp uzitip ⱪoyux pursitinimu bǝrmiding. Bu ixta ǝhmǝⱪliⱪ ⱪilding. ");
INSERT INTO uigpin_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Silǝrgǝ ziyan-zǝhmǝt yǝtküzüx ⱪolumdin kelǝtti; lekin tünügün keqǝ atangning Hudasi manga sɵz ⱪilip: «Ⱨezi bol, Yaⱪupⱪa ya aⱪ ya kɵk demǝ» dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Hox, sǝn atangning ɵyini tolimu seƣinƣining üqün kǝtmǝy ⱪoymaysǝn; lekin nemixⱪa yǝnǝ mening butlirimni oƣriliding? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaⱪup Labanƣa jawab berip: — Mǝn ⱪorⱪup ⱪaqtim; qünki seni ⱪizlirini mǝndin mǝjburiy tartiwalamdikin, dedim. ");
INSERT INTO uigpin_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Əmdi butliringƣa kǝlsǝk, ular kimdin qiⱪsa xu tirik ⱪalmaydu! Ⱪerindaxlirimiz aldida mǝndin ⱪandaⱪla nemǝngni tonuwalsang, uni elip kǝt, — dedi. Ⱨalbuki, Yaⱪupning Raⱨilǝning butlarni oƣrilap kǝlginidin hǝwiri yoⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban aldi bilǝn Yaⱪupning qediriƣa kirip, andin Leyaⱨning qediri ⱨǝm ikki dedǝkning qedirliriƣa kirip ahturup ⱨeqnemǝ tapalmidi. Leyaⱨning qediridin qiⱪip, Raⱨilǝning qediriƣa kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raⱨilǝ bolsa ɵy butlirini elip, bularni tɵgining qomining iqigǝ tiⱪip ⱪoyup, üstidǝ olturuwalƣanidi. Laban pütkül qedirini ahturup, ⱨeqnemǝ tapalmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raⱨilǝ atisiƣa: — Əy hojam, aldingda turalmiƣinim üqün hapa bolmiƣin; qünki mǝn ⱨazir ayallarning adǝt mǝzgilidǝ turuwatimǝn, — dedi. Xundaⱪ ⱪilip, Laban ⱨǝmmǝ yǝrni ⱪoymay ahturupmu, ɵy butlirini tapalmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Xuning bilǝn Yaⱪup aqqiⱪlap Laban bilǝn jedǝllixip kǝtti. Yaⱪup Labanƣa: — Sǝn meni kǝynimdin munqǝ aldirap-tenǝp ⱪoƣlap kǝlgüdǝk mǝndǝ nemǝ sǝwǝnlik, nemǝ gunaⱨ bar? ");
INSERT INTO uigpin_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Sǝn ⱨǝmmǝ yük-taⱪlirimni ahturup qiⱪting, ɵyüngning nǝrsiliridin birǝr nemǝ tapalidingmu? Birnemǝ tapⱪan bolsang, mening ⱪerindaxlirim bilǝn sening ⱪerindaxliringning aldida uni ⱪoyƣin, ular biz ikkimizning arisida ⱨɵküm ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Mǝn muxu yigirmǝ yil ⱪexingda turdum; ⱨeqⱪaqan saƣliⱪing wǝ qixi ɵqkiliring bala taxliwǝtmidi; padiliringdin ⱪoqⱪarliringni yeginim yoⱪ. ");
INSERT INTO uigpin_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Boƣuwetilgǝnlirini ⱪexingƣa elip kǝlmǝy, bu ziyanni ɵzüm toldurdum; keqisi oƣrilanƣan yaki kündüzi oƣrilanƣan bolsun sǝn uni mǝndin tɵlitip alding. ");
INSERT INTO uigpin_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mening künlirim xundaⱪ ɵttiki, kündüzi issiⱪtin, keqisi soƣuⱪtin ⱪiynilip, uyⱪu kɵzümdin ⱪaqatti. ");
INSERT INTO uigpin_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Mening künlirim muxu yigirmǝ yilda ɵyüngdǝ turup xundaⱪ boldi; on tɵt yil ikki ⱪizing üqün sanga hizmǝt ⱪildim, altǝ yil padang üqün hizmǝt ⱪildim; uning üstigǝ sǝn ix ⱨǝⱪⱪimni on ⱪetim ɵzgǝrtting. ");
INSERT INTO uigpin_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Əgǝr atamning Hudasi, yǝni Ibraⱨimning Hudasi, yǝni Isⱨaⱪning Ⱪorⱪunqisi Bolƣanning Ɵzi mǝn bilǝn billǝ bolmisa idi, sǝn jǝzmǝn meni ⱪuruⱪ ⱪol ⱪilip ⱪayturuwetǝtting. Lekin Huda mening tartⱪan jǝbir-japalirimni, ⱪollirimning muxǝⱪⱪitini kɵrüp tünügün keqǝ sanga tǝnbiⱨ bǝrdi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban Yaⱪupⱪa jawab berip: — Bu ⱪizlar mening ⱪizlirim, bu oƣullar mening oƣullirim, bu pada bolsa mening padam bolidu; xundaⱪla kɵz aldingdiki ⱨǝmmǝ nǝrsǝ miningkidur; ǝmma mǝn bügün bu ⱪizlirimni wǝ ularning tuƣⱪan oƣullirini nemǝ ⱪilay? ");
INSERT INTO uigpin_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ⱪeni kǝl, sǝn bilǝn ikkimiz bir ǝⱨdǝ tüzüxǝyli, bu mǝn bilǝn sening otturimizda guwaⱨ bolsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Xuning bilǝn Yaⱪup bir taxni elip ɵrǝ tiklǝp tüwrük ⱪilip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Andin Yaⱪup ⱪerindaxliriƣa: — Tax yiƣinglar, — dewidi, taxlarni elip kelip dɵwilidi, xu yǝrdǝ tax dɵwisining yenida ƣizalinixti. ");
INSERT INTO uigpin_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban bu dɵwini «Yǝgar-Saⱨaduta» dǝp atidi, Yaⱪup uningƣa «Galeǝd» dǝp at ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban: — Bu dɵwǝ bügün sǝn bilǝn mening otturamda guwaⱨ bolsun, — dedi. Xunga bu sǝwǝbtin dɵwining nami «Galeǝd» ataldi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","U jay yǝnǝ «Mizpaⱨ», dǝpmu ataldi; qünki Laban yǝnǝ: — Ikkimiz bir-birimiz bilǝn kɵrüxmigǝn waⱪitlarda, Pǝrwǝrdigar sǝn bilǝn mening otturamda ⱪarawul bolup kɵzitip tursun. ");
INSERT INTO uigpin_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Əgǝr sǝn ⱪizlirimni bozǝk ⱪilsang, yaki ⱪizlirimning üstigǝ baxⱪa hotunlarni alsang, baxⱪa ⱨeq kixi ⱪeximizda ⱨazir bolmiƣan tǝⱪdirdimu, mana, Huda mǝn bilǝn sening arangda guwaⱨqidur! ");
INSERT INTO uigpin_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban Yaⱪupⱪa yǝnǝ: — Mana, bu dɵwigǝ ⱪara, mǝn bilǝn sǝn ikkimizning otturisida mǝn tiklǝp ⱪoyƣan bu tüwrükkimu ⱪara; ");
INSERT INTO uigpin_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","kǝlgüsidǝ bu dɵwǝ wǝ bu tüwrükmu mǝn yaman niyǝt bilǝn bu dɵwidin sening tǝripinggǝ ɵtmǝslikim üqün, seningmu niyitingni yaman ⱪilip bu dɵwǝ wǝ bu tüwrüktin ɵtüp mening tǝripimgǝ kǝlmǝsliking üqün guwaⱨqi bolsun. ");
INSERT INTO uigpin_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ibraⱨimning ilaⱨi, Naⱨorning ilaⱨi wǝ bu ikkisining atisining ilaⱨliri arimizda ⱨɵküm qiⱪarsun, — dedi. Yaⱪup bolsa atisi Isⱨaⱪning Ⱪorⱪunqisi Bolƣuqi bilǝn ⱪǝsǝm ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Andin Yaⱪup taƣ üstidǝ bir ⱪurbanliⱪ sunup, ⱪerindaxlirini ɵzi bilǝn tamaⱪlinixⱪa tǝklip ⱪildi. Ular ⱨǝmdastihan olturdi wǝ keqisi taƣda ⱪondi. ");
INSERT INTO uigpin_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ətisi tang sǝⱨǝrdǝ Laban ornidin turup, nǝwriliri bilǝn ⱪizlirini sɵyüp, ularƣa bǝht-bǝrikǝt tilǝp, ɵz ɵyigǝ rawan boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaⱪup ɵz yoliƣa ketip baratti; yolda Hudaning pǝrixtiliri uningƣa uqridi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaⱪup ularni kɵrüp: — Bu jay Hudaning bargaⱨi ikǝn! — dǝp, bu jayning namini «Maⱨanaim» dǝp ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Andin Yaⱪup Seir zeminidiki «Edom yayliⱪi»ƣa, akisi Əsawning ⱪexiƣa aldin hǝwǝrqilǝrni ǝwǝtip, ");
INSERT INTO uigpin_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ularƣa jekilǝp: — Silǝr hojamƣa, yǝni Əsawƣa: «Kǝminiliri Yaⱪup mundaⱪ dedi: — Mǝn Labanning ⱪexida musapir bolup, ta muxu waⱪitⱪiqǝ turdum. ");
INSERT INTO uigpin_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Əmdi mǝndǝ kala, exǝk wǝ ⱪoylar, ⱪul-dedǝklǝrmu bar; mǝn ɵzlirining nǝziridǝ iltipat taparmǝnmikin dǝp hojamƣa hǝwǝr yǝtküzüxni layiⱪ kɵrdüm», dǝnglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Hǝwǝrqilǝr Yaⱪupning yeniƣa yenip kelip: — Biz akiliri Əsawning ⱪexiƣa barduⱪ; u tɵt yüz kixini elip, silining aldiliriƣa keliwatidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaⱪup naⱨayiti ⱪorⱪup, ƣǝm-ƣussigǝ qüxüp adǝmlirini ⱪoy, kala wǝ tɵgilirigǝ ⱪoxup, ikki topⱪa ayridi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","U: — «Əgǝr Əsaw kelip bir topimizƣa ⱨujum ⱪilsa, yǝnǝ bir top ⱪeqip ⱪutulup ⱪalar» — dǝp oylidi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Andin Yaⱪup mundaⱪ dua ⱪildi: — I atam Ibraⱨimning Hudasi wǝ atam Isⱨaⱪning Hudasi! Manga: «Ɵz zemining wǝ uruⱪ-tuƣⱪanliringning ⱪexiƣa yenip kǝtkin, sanga yahxiliⱪ ⱪilimǝn» dǝp wǝdǝ ⱪilƣan Pǝrwǝrdigar! ");
INSERT INTO uigpin_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","— Mǝn Sening Ɵz ⱪulungƣa kɵrsǝtkǝn ɵzgǝrmǝs barliⱪ meⱨribanliⱪing wǝ barliⱪ wapadarliⱪing aldida ⱨeqnemǝ ǝmǝsmǝn; qünki mǝn bu Iordan dǝryasidin ɵtkinimdǝ yalƣuz bir ⱨasam bar idi. Əmdi mǝn ikki top adǝm bolup ⱪaytiwatimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ɵtünüp ⱪalay, meni akam Əsawning ⱪolidin ⱪutⱪuzƣaysǝn; qünki u kelip mǝn bilǝn hotun-balilirimni ɵltürüwetǝmdikin, dǝp ⱪorⱪimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Sǝn: «Mǝn jǝzmǝn sanga zor yahxiliⱪ ⱪilip, sening nǝslingni dengizdiki ⱪumdǝk ⱨǝddi-ⱨesabsiz kɵp ⱪilimǝn», degǝniding, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","U xu keqisi xu yǝrdǝ ⱪonup ⱪaldi; andin u ⱪol ilikidiki mallardin elip, akisi Əsawƣa ikki yüz ɵqkǝ, yigirmǝ tekǝ, ikki yüz saƣliⱪ, yigirmǝ ⱪoqⱪar, ottuz qixi tɵgini taylaⱪliri bilǝn, ⱪiriⱪ inǝk, on buⱪa, yigirmǝ mada exǝk, on ⱨangga exǝkni sowƣat ⱪilip tǝyyarlap, ");
INSERT INTO uigpin_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Bularni ayrim-ayrim top ⱪilip hizmǝtkarlirining ⱪoliƣa tapxurup, ularƣa jekilǝp: — Silǝr mǝndin burun mengip, ⱨǝr topning arisida ariliⱪ ⱪoyup ⱨǝydǝp menginglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","U ǝng aldidiki top bilǝn mangƣan kixikǝ ǝmr ⱪilip: — Akam Əsaw sanga uqriƣanda, ǝgǝr u sǝndin: «Kimning adimisǝn? Ⱪǝyǝrgǝ barisǝn? Aldingdiki janiwarlar kimning?» — dǝp sorisa, ");
INSERT INTO uigpin_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Undaⱪta sǝn jawab berip: «Bular kǝminiliri Yaⱪupning bolup, hojam Əsawƣa ǝwǝtkǝn sowƣattur. Mana, u ɵzimu kǝynimizdin keliwatidu» — degin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Xu tǝriⱪidǝ u ikkinqi, üqinqi wǝ ulardin keyinki padilarni ⱨǝydǝp mangƣuqi kixilǝrgimu ohxax ǝmr ⱪilip: — Əsaw sizlǝrgǝ uqriƣanda, silǝrmu uningƣa xundaⱪ dǝnglar, andin: — Mana, kǝminiliri Yaⱪup ɵzimu arⱪimizdin keliwatidu, — dǝnglar, dedi; qünki u: — Mǝn aldimda barƣan sowƣat bilǝn uni meni kǝqürüm ⱪildurup, andin yüzini kɵrsǝm, meni ⱪobul ⱪilarmikin, — dǝp oyliƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Xundaⱪ ⱪilip sowƣat aldin ǝwǝtildi; u xu keqisi bargaⱨta ⱪonup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","U xu keqidǝ ⱪopup, ikki ayali wǝ ikki dediki wǝ on bir oƣlini elip, Yabbok keqikidin ɵtüp kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","U ularni eⱪindin ɵtküzdi, xundaⱪla ⱨǝmmǝ tǝǝlluⱪinimu u ⱪarxi tǝrǝpkǝ ɵtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yaⱪup bolsa bu ⱪatta yalƣuz ⱪaldi; bir zat kelip xu yǝrdǝ uning bilǝn tang atⱪuqǝ qelixti. ");
INSERT INTO uigpin_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Lekin bu zat uni yengǝlmǝydiƣanliⱪini kɵrüp, uning yotisining yiriⱪiƣa ⱪolini tǝgküzüp ⱪoydi; xuning bilǝn ular qelixiwatⱪanda Yaⱪupning yotisi ⱪazandin qiⱪip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","U zat: — Meni ⱪoyup bǝrgin, qünki tang atay dǝp ⱪaldi, dedi. — Sǝn meni bǝrikǝtlimigüqǝ, seni ⱪoyup bǝrmǝymǝn, dedi Yaⱪup. ");
INSERT INTO uigpin_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","U uningdin: — Eting nemǝ? dǝp soridi. U: etim Yaⱪup, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","U uningƣa: — Sening eting buningdin keyin Yaⱪup bolmay, bǝlki Israil bolidu; qünki sǝn Huda bilǝnmu, insan bilǝnmu elixip ƣalib kǝlding, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Andin Yaⱪup uningdin: — Namingni manga dǝp bǝrgin, dewidi, u: — Nemixⱪa mening namimni soraysǝn? — dedi wǝ xu yǝrdǝ uningƣa bǝht-bǝrikǝt ata ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Xuning bilǝn Yaⱪup: — Hudani yüzmu-yüz kɵrüp, jenim ⱪutulup ⱪaldi, dǝp u jayning namini «Pǝniǝl» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","U Pǝniǝldin ɵtüp mangƣanda, kün uning üstibexini yorutti; ǝmma u yotisi tüpǝylidin aⱪsap mangatti . ");
INSERT INTO uigpin_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Bu sǝwǝbtin Israillar bügüngiqǝ yotining ügisidiki pǝyni yemǝydu; qünki xu Zat Yaⱪupning yotisining yiriⱪiƣa, yǝni uning peyigǝ ⱪolini tǝgküzüp ⱪoyƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaⱪup bexini kɵtürüp ⱪariwidi, mana Əsaw tɵt yüz kixi bilǝn keliwatatti. Xuning bilǝn u balilirini ayrip, Leyaⱨ, Raⱨilǝ wǝ ikki dedǝkkǝ tapxurdi; ");
INSERT INTO uigpin_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","u ikki dedǝk wǝ ularning balilirini ⱨǝmmining aldida mangdurdi, andin Leyaⱨ bilǝn uning balilirini, ǝng ahirida Raⱨilǝ bilǝn Yüsüpni mangdurdi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ɵzi bolsa ularning aldiƣa ɵtüp mangdi, u akisining aldiƣa yetip barƣuqǝ yǝttǝ ⱪetim yǝrgǝ bax urup tǝzim ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Əsaw uning aldiƣa yügürüp kelip, uni ⱪuqaⱪlap, boyniƣa girǝ selip, uni sɵydi; ⱨǝr ikkisi yiƣlixip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Andin Əsaw bexini kɵtürüp ⱪarap, ayallar wǝ balilarni kɵrüp: — Bu sǝn bilǝn billǝ kǝlgǝnlǝr kimlǝr? — dǝp soridi. Yaⱪup: — Bular Huda xapaǝt ⱪilip kǝminilirigǝ bǝrgǝn balilardur, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Andin ikki dedǝk wǝ ularning baliliri aldiƣa berip, uningƣa tǝzim ⱪildi; ");
INSERT INTO uigpin_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Andin Leyaⱨmu uning baliliri bilǝn aldiƣa berip, tǝzim ⱪildi, ahirida Yüsüp bilǝn Raⱨilǝ aldiƣa berip, tǝzim ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Əsaw: — Manga yolda uqriƣan axu topliringda nemǝ mǝⱪsiting bar? — dewidi, Yaⱪup jawab berip: — Bu hojamning aldida iltipat tepixim üqündur, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Lekin Əsaw: — Əy ⱪerindixim, mǝndǝ yetip axⱪudǝk bar. Sening ɵz nǝrsiliring ɵzünggǝ ⱪalsun, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Əmma Yaⱪup: — Undaⱪ ⱪilmiƣin; ǝgǝr mǝn nǝzǝrliridǝ iltipat tapⱪan bolsam, sowƣitimni ⱪolumdin ⱪobul ⱪilƣayla; qünki silining meni huxalliⱪ bilǝn ⱪobul ⱪilƣanlirini kɵrüp, didarlirini kɵrginimdǝ Hudaning didarini kɵrgǝndǝk boldum! ");
INSERT INTO uigpin_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Əmdi sanga kǝltürülgǝn, Hudadin kɵrgǝn bu bǝrikǝtlirimni ⱪobul ⱪilƣayla; qünki Huda manga xapaǝt kɵrsǝtti, ⱨǝmmǝ nǝrsilirim bar boldi, — dǝp uningdin ⱪayta-ⱪayta ɵtünüwidi, u ⱪobul ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Andin Əsaw: — Əmdi biz ⱪozƣilip sǝpirimizni dawamlaxturayli, mǝn sening aldingda mangay, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","U uningƣa jawabǝn: — Hojam kɵrdilǝ, balilar kiqik, ⱪeximda emidiƣan ⱪoza wǝ mozaylar bar; ǝgǝr mǝn bularni bir künla aldirtip ⱪoƣlap mangdursam, pütkül pada ɵlüp ketidu. ");
INSERT INTO uigpin_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Xunga ɵtünimǝnki, hojam kǝminiliridin aldida mangƣaq tursun; mǝn aldimdiki mal-qarwilarning mengixiƣa, xundaⱪla balilarning mengixiƣa ⱪarap asta mengip, hojamning ⱪexiƣa Seirƣa udul baray, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","U waⱪitta Əsaw: — Undaⱪ bolsa, mǝn ɵzüm bilǝn kǝlgǝn kixilǝrdin birnǝqqini ⱪexingda ⱪoyup ketǝy, dedi. Lekin u jawab berip: — Buning nemǝ ⱨajiti? Pǝⱪǝt hojamning nǝziridǝ iltipat tapsamla xu kupayǝ, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Əsaw u küni yolƣa qiⱪip Seirƣa yenip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaⱪup sǝpǝr ⱪilip, Sukkot degǝn jayƣa kǝlgǝndǝ, u yǝrgǝ bir ɵy selip, malliriƣa lapaslarni yasidi. Xunga bu yǝr «Sukkot» dǝp ataldi. ");
INSERT INTO uigpin_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Xu tǝriⱪidǝ Yaⱪup Padan-Aramdin ⱪaytip, Ⱪanaan zeminidiki Xǝkǝm xǝⱨirigǝ aman-esǝn kǝldi. U xǝⱨǝrning aldida qedir tikti. ");
INSERT INTO uigpin_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Andin u qedir tikkǝn yǝrning bir ⱪisimini Xǝkǝmning atisi bolƣan Ⱨamorning oƣulliridin bir yüz ⱪǝsitigǝ setiwelip, ");
INSERT INTO uigpin_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Xu yǝrdǝ bir ⱪurbangaⱨ selip, namini «Əl-Əloⱨǝ-Israil» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Bir küni, Leyaⱨning Yaⱪupⱪa tuƣup bǝrgǝn ⱪizi Dinaⱨ yurtning ⱪizliri bilǝn kɵrüxkili qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Xu yurtning ǝmiri ⱨiwiy Ⱨamorning oƣli Xǝkǝm uni kɵrüp ⱪelip, uni tutuwelip, zorlap nomusiƣa tǝgdi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Əmma uning kɵngli Yaⱪupning ⱪizi Dinaⱨⱪa qüxüp, uni yahxi kɵrüp ⱪaldi wǝ uningƣa muⱨǝbbiti bilǝn kɵngül soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Xuning bilǝn Xǝkǝm atisi Ⱨamordin: — Bu ⱪizni manga hotunluⱪⱪa elip bǝrgin, dǝp tǝlǝp ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaⱪup Xǝkǝmning ⱪizi Dinaⱨning ippitigǝ tǝgkǝnlikini anglap ⱪaldi. Uning oƣulliri malliri bilǝn dalalarda idi; xunga Yaⱪup ular kǝlgüqǝ jim turup turdi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Xǝkǝmning atisi Ⱨamor Yaⱪupning aldiƣa uning bilǝn sɵzlǝxkili qiⱪti; ");
INSERT INTO uigpin_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaⱪupning oƣulliri hǝwǝrni anglapla dalalardin ⱪaytip kǝlgǝnidi. Bular Xǝkǝmning ⱪilmaydiƣan ixni ⱪilip, Yaⱪupning ⱪizining nomusiƣa tegip Israil ⱪǝbilisidǝ xǝrmǝndilik ⱪilƣini üqün azablinip, intayin ⱪattiⱪ ƣǝzǝplǝndi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ⱨamor ularƣa sɵz ⱪilip: — Oƣlum Xǝkǝmning kɵngli ⱪizinglarƣa qüxüp ⱪaptu. Iltipat ⱪilip uni oƣlumƣa hotunluⱪⱪa bǝrsǝnglar! ");
INSERT INTO uigpin_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Biz bilǝn ⱪuda-baja bolup, ⱪizliringlarni bizgǝ beringlar, bizning ⱪizlirimiznimu silǝr elinglar; ");
INSERT INTO uigpin_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Biz bilǝn billǝ turunglar. Mana, yǝr aldinglarda turuptu; bu yǝrni makan ⱪilip, soda ⱪilip, ɵzünglar üqün ɵy-mülük elinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Xǝkǝm ⱪizning atisi bilǝn aka-ukiliriƣa: — Nǝziringlarda iltipat tapsam dǝymǝn; silǝr nemǝ desǝnglar, xuni berǝy. ");
INSERT INTO uigpin_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mǝndin ⱪanqilik toyluⱪ yaki sowƣat tǝlǝp ⱪilsanglar, manga eytⱪininglarqǝ berǝy; pǝⱪǝt bu ⱪizni manga hotunluⱪⱪa bǝrsǝnglarla bolidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yaⱪupning oƣulliri bolsa Xǝkǝm wǝ atisi Ⱨamorƣa ⱨiylǝ-mikir bilǝn jawab bǝrdi, qünki u singlisi Dinaⱨning ippitigǝ tǝgkǝnidi; ");
INSERT INTO uigpin_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ularƣa: — Biz bundaⱪ ⱪilalmaymiz, singlimizni hǝtnisiz birsigǝ berixkǝ maⱪul deyǝlmǝymiz; qünki bu bizgǝ nomus bolidu. ");
INSERT INTO uigpin_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Pǝⱪǝt bir xǝrtimizgǝ kɵnsǝnglarla silǝrgǝ maⱪul bolimiz; silǝrning barliⱪ ǝrkǝkliringlar hǝtnǝ ⱪilinip bizdǝk bolsa, ");
INSERT INTO uigpin_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ⱪizlirimizni silǝrgǝ berip, silǝrning ⱪizliringlarni biz elip aranglarda olturup, bir ⱪowm bolup ⱪalimiz. ");
INSERT INTO uigpin_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Əmma bizgǝ ⱪulaⱪ salmay hǝtnǝ ⱪilinixⱪa unimisanglar, undaⱪta biz ⱪizimizni elip ketimiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ularning sɵzliri Ⱨamor wǝ oƣli Xǝkǝmning nǝzirigǝ yaⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Yigit bu ixni kǝynigǝ sozmidi, qünki u Yaⱪupning ⱪiziƣa ejil bolup ⱪalƣanidi; u atisining ɵyidǝ ⱨǝmmidin ǝtiwarliⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Xuning bilǝn Ⱨamor oƣli Xǝkǝm bilǝn xǝⱨǝrning dǝrwazisiƣa berip, xǝⱨǝrning adǝmlirigǝ sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Bu adǝmlǝrning biz bilǝn inaⱪ ɵtküsi bar. Xunga ular muxu yurtta turup soda-setiⱪ ⱪilsun; mana, bu jayning ikki tǝripi ularƣa yǝtküdǝk kǝngridur. Biz ularning ⱪizlirini hotunluⱪⱪa elip, ɵz ⱪizlirimizni ularƣa berimiz. ");
INSERT INTO uigpin_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Lekin pǝⱪǝt arimizdiki ⱨǝmmǝ ǝrkǝk ular hǝtnǝ ⱪilinƣandǝk hǝtnǝ ⱪilinsa, u adǝmlǝr arimizda turup biz bilǝn bir hǝlⱪ boluxⱪa maⱪul dǝydu. ");
INSERT INTO uigpin_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Xu tǝriⱪidǝ ularning mal-tǝǝlluⱪati, ⱨǝmmǝ qarpayliri bizningki bolmamdu? Biz pǝⱪǝt ularƣa maⱪul desǝkla, ular arimizda turidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Xuning bilǝn xǝⱨǝrning dǝrwazisidin kirip-qiⱪidiƣanlarning ⱨǝmmisi Ⱨamor bilǝn oƣli Xǝkǝmning sɵzigǝ ⱪulaⱪ saldi. Xǝⱨǝrning dǝrwazisidin kirip-qiⱪadiƣanlarning ⱨǝmmisi hǝtnǝ ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Əmma üqinqi küni, ular tehiqǝ aƣriⱪ yatⱪinida xundaⱪ boldiki, Yaⱪupning ikki oƣli, yǝni Dinaⱨning akiliri Ximeon bilǝn Lawiy ⱨǝrⱪaysisi ɵz ⱪiliqini elip, xǝⱨǝr hatirjǝmlik iqidǝ turƣinida besip kirip, ⱨǝmmǝ ǝrkǝkni ɵltürüwǝtti;    ");
INSERT INTO uigpin_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ular Ⱨamor bilǝn oƣli Xǝkǝmnimu ⱪiliqlap, Dinaⱨni Xǝkǝmning ɵyidin elip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Andin Yaⱪupning barliⱪ oƣulliri: «Ular singlimizning nomusiƣa tǝgdi» dǝp, ɵltürülgǝnlǝrning jayiƣa kelip, xǝⱨǝrni bulap-talang ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ularning ⱪoy-kala, exǝklirini, xǝⱨǝrdiki ⱨǝmmini, etizliⱪlardiki ⱨǝmmini elip kǝtti, ");
INSERT INTO uigpin_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Xundaⱪla ularning barliⱪ mal-mülkini bulap-talap, barliⱪ hotun-balilarni ǝsir ⱪilip, ɵy iqidiki barliⱪ nǝrsilǝrnimu ⱪoxup elip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaⱪup Ximeon wǝ Lawiyni ǝyiblǝp: — Silǝr meni balaƣa tiⱪip, zemindikilǝr — Ⱪanaaniylar bilǝn Pǝrizziylǝrning aldida sesittinglar. Bizning adimimiz az bir hǝlⱪturmiz; ular manga ⱪarxi qiⱪip yiƣilip ⱨujum ⱪilidu; xuning bilǝn mǝn wǝ jǝmǝtim wǝyran bolimiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Əmma ular jawab berip: — Əjǝba, singlimizƣa bir paⱨixǝ ayalƣa ⱪilƣandǝk muamilǝ ⱪilsa bolamdu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Andin Huda Yaⱪupⱪa: — Sǝn ⱨazir Bǝyt-Əlgǝ qiⱪip, xu yǝrni makan ⱪil, ɵzüng akang Əsawdin ⱪeqip mangƣiningda sanga kɵrüngǝn Mǝn Tǝngrigǝ bir ⱪurbangaⱨ yasiƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Xuning bilǝn Yaⱪup ɵyidikilǝr wǝ ɵzi bilǝn billǝ bolƣanlarning ⱨǝmmisigǝ mundaⱪ dedi: — Aranglardiki yat ilaⱨ butlirini taxliwetip, ɵzünglarni paklap eginliringlarni yǝnggüxlǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Andin ⱪopup Bǝyt-Əlgǝ qiⱪimiz. Mǝn xu yǝrdǝ ⱪiyinqiliⱪta ⱪalƣanda duayimni ijabǝt ⱪilip, yürgǝn yolumda mening bilǝn billǝ bolup kǝlgǝn Tǝngrigǝ ⱪurbangaⱨ salay, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Xuning bilǝn ɵz ⱪolliridiki ⱨǝmmǝ yat ilaⱨ butlirini, xundaⱪla ⱪulaⱪliridiki zirilǝrni qiⱪirip Yaⱪupⱪa bǝrdi. Yaⱪup bularni Xǝkǝmdiki dub dǝrihining tüwigǝ kɵmüp ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Andin ular sǝpǝrgǝ atlandi; ǝmma ǝtrapidiki xǝⱨǝrlǝrni Hudadin bolƣan bir wǝⱨimǝ basⱪaqⱪa, ular Yaⱪupning oƣullirini ⱪoƣlimidi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Bu tǝriⱪidǝ Yaⱪup wǝ uning bilǝn billǝ bolƣanlarning ⱨǝmmisi Ⱪanaan zeminidiki Luz, yǝni Bǝyt-Əlgǝ yetip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","U xu yǝrdǝ bir ⱪurbangaⱨ yasidi; akisidin ⱪeqip mangƣinida xu yǝrdǝ Huda uningƣa kɵrüngini üqün bu jayning ismini «Əl-Bǝyt-Əl» dǝp atidi.    ");
INSERT INTO uigpin_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Riwkaⱨning inik’anisi Dǝboraⱨ bolsa xu yǝrdǝ alǝmdin ɵtti. U Bǝyt-Əlning ayiƣidiki dub dǝrihining tüwidǝ dǝpnǝ ⱪilindi. Bu sǝwǝbtin xu dǝrǝh «Yiƣa-Zarning dub dǝrihi» dǝp ataldi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yaⱪup xu yol bilǝn Padan-Aramdin yenip kǝlgǝndin keyin, Huda uningƣa yǝnǝ bir ⱪetim kɵrünüp, uningƣa bǝht-bǝrikǝt ata ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Andin Huda uningƣa: — Sening isming Yaⱪuptur; ǝmma mundin keyin sǝn Yaⱪup atalmay, bǝlki naming Israil bolidu, dǝp uning ismini Israil ⱪoyup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Andin Huda yǝnǝ uningƣa: — Mǝn Ɵzüm Ⱨǝmmigǝ Ⱪadir Tǝngridurmǝn; sǝn nǝsillinip, kɵpǝygin; bir ǝl, xundaⱪla bir türküm ǝllǝr sǝndin pǝyda bolidu; padixaⱨlarmu sening puxtungdin qiⱪidu.    ");
INSERT INTO uigpin_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mǝn Ibraⱨim wǝ Isⱨaⱪⱪa bǝrgǝn zeminni sanga berimǝn, xundaⱪla sǝndin keyinki nǝslinggimu xu zeminni berimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Andin Huda uning bilǝn sɵzlǝxkǝn jaydin, uning yenidin yuⱪiriƣa kɵtürüldi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaⱪup Huda ɵzi bilǝn sɵzlǝxkǝn jayda bir tax tüwrükni tiklǝp, üstigǝ bir xarab ⱨǝdiyǝsini tɵkti wǝ zǝytun meyi ⱪuyup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaⱪup Huda ɵzi bilǝn sɵzlǝxkǝn xu jayning namini «Bǝyt-Əl» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Andin ular Bǝyt-Əldin mengip, Əfratⱪa azƣina yol ⱪalƣanda, Raⱨilǝni tolƣaⱪ tutup ketip, ⱪattiⱪ tuƣut azabida ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Əmma tolƣiⱪi ⱪattiⱪ eƣirlaxⱪanda, tuƣut anisi uningƣa: — Ⱪorⱪmiƣin, bu ⱪetim yǝnǝ bir oƣlung bolidiƣan boldi — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Xundaⱪ boldiki, Raⱨilǝ jeni qiⱪix aldida, ahirⱪi nǝpisi bilǝn oƣliƣa «Bǝn-Oni» dǝp isim ⱪoydi; ǝmma uning atisi uni «Bǝn-Yamin» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raⱨilǝ wapat boldi wǝ Bǝyt-Lǝⱨǝm dǝp atilidiƣan Əfratning yolining boyiƣa dǝpnǝ ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaⱪup uning ⱪǝbrisining üstigǝ bir hatirǝ texi tiklǝp ⱪoydi. Bügüngǝ ⱪǝdǝr «Raⱨilǝning Ⱪǝbrǝ Texi» xu yǝrdǝ turmaⱪta. ");
INSERT INTO uigpin_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Andin Israil sǝpǝrni dawamlaxturup Migdal-Edirning u tǝripidǝ ɵz qedirini tikti. ");
INSERT INTO uigpin_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israil u zeminda turƣan waⱪtida, Rubǝn berip ɵz atisining keniziki Bilⱨaⱨ bilǝn bir orunda yatti; Israil buni anglap ⱪaldi. Yaⱪupning on ikki oƣli bar idi: — ");
INSERT INTO uigpin_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leyaⱨdin tuƣulƣan oƣulliri: — Yaⱪupning tunji oƣli Rubǝn wǝ Ximeon, Lawiy, Yǝⱨuda, Issakar ⱨǝm Zǝbulun idi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raⱨilǝdin tuƣulƣan oƣulliri: — Yüsüp wǝ Binyamin idi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raⱨilǝning dediki Bilⱨaⱨdin tuƣulƣan oƣulliri: — Dan wǝ Naftali idi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leyaⱨning dediki Zilpaⱨdin tuƣulƣan oƣulliri: — Gad bilǝn Axir idi. Bular bolsa Yaⱪupⱪa Padan-Aramda tuƣulƣan oƣulliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Əmdi Yaⱪup atisi Isⱨaⱪning ⱪexiƣa, Ibraⱨim wǝ Isⱨaⱪ musapir bolup turƣan Kiriat-Arba, yǝni Ⱨebronning yenidiki Mamrǝgǝ kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isⱨaⱪning kɵrgǝn künliri bir yüz sǝksǝn yil boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isⱨaⱪ tolimu ⱪerip, künliri toxup, nǝpǝstin tohtap wapat boldi wǝ ɵz ⱪowmining ⱪexiƣa berip ⱪoxuldi. Uning oƣulliri Əsaw bilǝn Yaⱪup uni dǝpnǝ ⱪildi.    ");
INSERT INTO uigpin_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Tɵwǝndikilǝr Əsawning ǝwladliridur (Əsaw yǝnǝ Edom dǝpmu atilidu): —    ");
INSERT INTO uigpin_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Əsaw ayallirini Ⱪanaaniylarning ⱪizliridin aldi, yǝni Ⱨittiylardin bolƣan Elonning ⱪizi Adaⱨ bilǝn ⱨiwiylardin bolƣan Zibeonning nǝwrisi, Anaⱨning ⱪizi Oⱨolibamaⱨni aldi; ");
INSERT INTO uigpin_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","uningdin baxⱪa Ismailning ⱪizi, Nebayotning singlisi Basimatnimu alƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adaⱨ Əsawƣa Elifazni tuƣup bǝrdi; Basimat bolsa Reuǝlni tuƣdi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oⱨolibamaⱨ Yǝux, Yaalam wǝ Koraⱨni tuƣdi; bular Ⱪanaan zeminida Əsawƣa tuƣulƣan oƣullar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Əsaw ayalliri, oƣul-ⱪizliri, ɵyidiki ⱨǝmmǝ kixilirini wǝ qarpaylirini, barliⱪ ulaƣlirini, xundaⱪla Ⱪanaan zeminida tapⱪan barliⱪ tǝǝlluⱪatlirini elip, inisi Yaⱪuptin ayrilip, baxⱪa bir yurtⱪa kɵqüp kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Qünki ⱨǝr ikkisining tǝǝlluⱪatliri intayin kɵp bolƣaqⱪa, bir yǝrdǝ billǝ turalmaytti; musapir bolup turƣan zemin ularning mal-qarwilirining kɵplükidin ularni baⱪalmaytti. ");
INSERT INTO uigpin_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Buning bilǝn Əsaw (Əsaw Edom dǝpmu atilidu) Seir teƣiƣa berip, olturaⱪlixip ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Tɵwǝndikilǝr taƣliⱪ rayon Seirdiki Edomiylarning ata-bowisi Əsawning ǝwladliridur: — ");
INSERT INTO uigpin_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Əsawning oƣulliri: — Əsawning ayali adaⱨning oƣli Elifaz; Əsawning ayali Basimatning oƣli Reuǝl. Elifazning oƣulliri: — Teman, Omar, Zǝfo, Gatam wǝ Kǝnaz idi. Əsawning oƣli Elifazning kiqik hotuni Timna idi; u Elifazƣa Amalǝkni tuƣup bǝrdi. Yuⱪirilar bolsa Əsawning ayali adaⱨning ǝwladliri idi. Reuǝlning oƣulliri: — Naⱨat, Zǝraⱨ, Xammaⱨ wǝ Mizzaⱨ idi; bular Əsawning ayali Basimatning ǝwladliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Əsawning ayali, yǝni Zibeonning qong ⱪizi, Anaⱨning ⱪizi bolƣan Oⱨolibamaⱨning oƣulliri: u Əsawƣa Yǝux, Yaalam wǝ Koraⱨni tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Əsawning ǝwladlirining iqidin tɵwǝndiki ǝmirlǝr qiⱪⱪan: — Əsawning tunji oƣli Elifazning oƣulliridin: — ǝmir Teman, ǝmir Omar, ǝmir Zǝfo, ǝmir Kenaz, ");
INSERT INTO uigpin_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ǝmir Koraⱨ, ǝmir Gatam wǝ ǝmir Amalǝk qiⱪⱪan. Bular Edom zeminida Elifazning nǝslidin qiⱪⱪan ǝmirlǝr bolup, Adaⱨning ǝwladliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Əsawning oƣli Reuǝlning oƣulliridin ǝmir Naⱨat, ǝmir Zǝraⱨ, ǝmir Xammaⱨ wǝ ǝmir Mizzaⱨlar qiⱪⱪan; bular Edom zeminida Reuǝlning nǝslidin qiⱪⱪan ǝmirlǝrdur; bularning ⱨǝmmisi Əsawning ayali Basimatning ǝwladliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Əsawning ayali Oⱨolibamaⱨning oƣulliridin ǝmir Yǝux, ǝmir Yaalam wǝ ǝmir Koraⱨlar qiⱪⱪan. Bular Anaⱨning ⱪizi, Əsawning ayali Oⱨolibamaⱨning nǝslidin qiⱪⱪan ǝmirlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bular Əsawning, yǝni Edomning ǝwladliri bolup, Еdomiylarning ǝmirliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ⱨoriylardin bolƣan Seirning Edom zeminida olturƣan ǝwladliri: — Lotan, Xobal, Zibeon, Anaⱨ, Dixon, Ezǝr wǝ Dixan idi. Bular Seirning ǝwladliri bolup, Edom zeminida Ⱨoriylarning ǝmirliri idi.    ");
INSERT INTO uigpin_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotanning oƣulliri Ⱨori bilǝn Ⱨemam idi; Lotanning singlisi Timna idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Xobalning oƣulliri: Alwan, Manaⱨat, Ebal, Xefo wǝ Onam idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeonning oƣulliri: — Ayaⱨ wǝ Anaⱨ idi. Bu Anaⱨ qɵldǝ atisi Zibeonning exǝklirini beⱪiwetip, arxanglarni tepiwalƣan Anaⱨning dǝl ɵzi xu idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anaⱨning pǝrzǝntliri: oƣli Dixon; Anaⱨning ⱪizi Oⱨolibamaⱨ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dixonning oƣulliri: Ⱨǝmdan, Əxban, Itran wǝ Keran idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezǝrning oƣulliri: Bilⱨan, Zaawan wǝ Akan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dixanning oƣulliri: Uz wǝ Aran idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ⱨoriylarning ɵzlirining ǝmirliri: ǝmir Lotan, ǝmir Xobal, ǝmir Zibeon, ǝmir Anaⱨ, ǝmir Dixon, ǝmir Ezǝr wǝ ǝmir Dixan idi. Bular bolsa Ⱨoriylarning Seir zeminida ɵz namliri boyiqǝ atalƣan ⱪǝbililǝrning ǝmirliri idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israillarning üstigǝ ⱨeq padixaⱨ tehi sǝltǝnǝt ⱪilmasta Edom zeminida sǝltǝnǝt ⱪilƣan padixaⱨlar tɵwǝndikidǝk: — ");
INSERT INTO uigpin_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beorning oƣli Bela Edomda sǝltǝnǝt ⱪildi; uning xǝⱨirining ismi Dinⱨabaⱨ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela ɵlgǝndin keyin, Bozraⱨliⱪ Zǝraⱨning oƣli Yobab uning ornida sǝltǝnǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab ɵlgǝndin keyin, temaniylarning zeminidin kǝlgǝn Ⱨuxam uning ornida sǝltǝnǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ⱨuxam ɵlgǝndin keyin, Bedadning oƣli Ⱨadad uning ornida sǝltǝnǝt ⱪildi. U Moabning yaylaⱪlirida midiyaniylarƣa ⱨujum ⱪilip yǝnggǝnidi. Uning xǝⱨirining ismi Awit idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ⱨadad ɵlgǝndin keyin, masrǝkaⱨliⱪ Samlaⱨ uning ornida sǝltǝnǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlaⱨ ɵlgǝndin keyin, «Dǝryaning boyidiki Rǝⱨobot»tin kǝlgǝn Saul uning ornida sǝltǝnǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul ɵlgǝndin keyin, Akborning oƣli Baal-ⱨanan uning ornida sǝltǝnǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akborning oƣli Baal-ⱨanan ɵlgǝndin keyin, Ⱨadar uning ornida sǝltǝnǝt ⱪildi. Uning xǝⱨirining ismi Pau idi. Uning ayalining ismi Mǝⱨetabǝl bolup, u Mǝy-Zaⱨabning ⱪizi bolƣan Matrǝdning ⱪizi idi. ");
INSERT INTO uigpin_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Əsawning nǝslidin bolƣan ǝmirlǝr ularning at-isimliri, jǝmǝtliri, nǝsǝbnamiliri wǝ turƣan jayliri boyiqǝ: ǝmir Timna, ǝmir Alwaⱨ, ǝmir Yǝⱨǝt, ǝmir Oⱨolibamaⱨ, ǝmir Elaⱨ, ǝmir Pinon, ǝmir Kenaz, ǝmir Teman wǝ ǝmir Mibzar, ǝmir Magdiyǝl wǝ ǝmir Iramlar idi. Bular Edomiylarning ǝmirliri bolup, ɵzliri igilǝp olturaⱪlaxⱪan jaylar ɵz namliri bilǝn atalƣanidi. Mana xu tǝriⱪidǝ Əsaw Edomiylarning ata-bowisi boldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaⱪup bolsa atisi musapir bolup turƣan yǝrdǝ, yǝni Ⱪanaan zeminida olturaⱪlaxti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Tɵwǝndikilǝr Yaⱪup ǝwladlirining ix-izliridur. Yüsüp yigit bolup on yǝttǝ yaxⱪa kirgǝn qaƣlirida, akiliri bilǝn billǝ ⱪoylarni baⱪatti; u atisining kiqik hotunliri Bilⱨaⱨ wǝ Zilpaⱨning oƣulliri bilǝn billǝ ixlǝytti. Yüsüp atisiƣa ularning naqar ⱪiliⱪlirini eytip ⱪoyatti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yüsüp Israilning ⱪeriƣan waⱪtida tapⱪan balisi bolƣaqⱪa, uni baxⱪa oƣulliridin bǝkrǝk yahxi kɵrǝtti. Xunga u Yüsüpkǝ uzun yǝnglik ton tiktürüp bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Əmma akiliri atisining uni ɵzliridin yahxi kɵridiƣinini kɵrüp, uningƣa ɵq bolup ⱪalƣanidi wǝ uningƣa qirayliⱪ gǝp ⱪilmatti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Uning üstigǝ Yüsüp bir qüx kɵrgǝn bolup, uni akiliriƣa dǝp beriwidi, ular uningƣa tehimu ɵq bolup kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yüsüp ularƣa mundaⱪ dedi: — Mening kɵrgǝn xu qüxümni anglap beⱪinglar. ");
INSERT INTO uigpin_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mana, biz ⱨǝmmimiz etizlarda axliⱪlarni baƣlawatⱪudǝkmiz. Ⱪarisam mening ɵnqǝm ɵrǝ turuptidǝk; silǝrning ɵnqǝnglar bolsa mening ɵnqǝmning qɵrisigǝ olixip tǝzim ⱪilip turƣudǝk! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Akiliri uningdin: — Əjǝba, sǝn bizgǝ padixaⱨ bolamsǝn? Üstimizgǝ ⱨɵkümranliⱪ ⱪilamsǝn? — dǝp soridi. Uning kɵrgǝn qüxliri wǝ gepidin akiliri uni tehimu yaman kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Keyin u yǝnǝ bir qüx kɵrdi wǝ qüxini akiliriƣa dǝp: — Mana, mǝn yǝnǝ bir qüx kɵrdüm. Ⱪarisam, ⱪuyax bilǝn ay wǝ on bir yultuz manga tǝzim ⱪilip turƣudǝk! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","U bu qüxni atisi wǝ akiliriƣa dǝp bǝrdi. Atisi uningƣa tǝnbiⱨ berip: — Bu kɵrgining zadi ⱪandaⱪ qüx? Əjǝba, mǝn, anang wǝ aka-ukiliring aldingƣa berip, sanga yǝrgǝ bax urup tǝzim ⱪilimizmu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Xuning bilǝn akiliri uningƣa ⱨǝsǝt ⱪilƣili turdi. Əmma atisi xu gǝpni kɵngligǝ püküp ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Əmdi Yüsüpning ⱪerindaxliri atisining ⱪoylirini baⱪⱪili Xǝkǝmgǝ kǝtkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israil Yüsüpkǝ: — Akiliring Xǝkǝmdǝ pada beⱪiwatidiƣu? Kǝl, mǝn seni ularning ⱪexiƣa ǝwǝtǝy, dewidi, Yüsüp: — Mana mǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","U uningƣa: — Əmdi berip akiliring aman-esǝnmu-ǝmǝsmu, ⱪoylar aman-esǝnmu-ǝmǝsmu, manga hǝwirini elip kǝlgin, dǝp uni Ⱨebron jilƣisidin yolƣa saldi; u Xǝkǝmgǝ bardi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Xu yǝrdǝ birsi uning dalada tenǝp yürginini kɵrüp uningdin: — Nemǝ izdǝwatisǝn, dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","U: — Mǝn akilirimni izdǝwatimǝn. Ularning padilirini ⱪǝyǝrdǝ beⱪiwatⱪanliⱪini eytip bǝrsingiz, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","U adǝm jawab berip: — Ular bu yǝrdin ketip ⱪaldi, qünki mǝn ularning: «Yürünglar, Dotanƣa barayli» deginini anglidim, dedi. Xuning bilǝn Yüsüp akilirining arⱪisidin berip, ularni Dotandin tapti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ular uni yiraⱪtin kɵrüp, u tehi ularning ⱪexiƣa kǝlmǝyla, uni ɵltürüwetixni mǝsliⱨǝtlǝxti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ular bir-birigǝ: — Mana ⱨeliⱪi qüx kɵrgüqi keliwatidu. ");
INSERT INTO uigpin_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kelinglar, uni ɵltürüp muxu yǝrdiki orǝklǝrdin birigǝ taxliwetǝyli, andin: — Wǝⱨxiy bir ⱨaywan uni yǝp ketiptu, dǝyli. Xunda, biz uning qüxlirining nemǝ bolidiƣinini kɵrimiz! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Əmma Rubǝn buni anglap uni ularning ⱪolliridin ⱪutⱪuzmaⱪqi bolup: — Uni ɵltürmǝyli, dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rubǝn ularƣa yǝnǝ: — Ⱪan tɵkmǝnglar! Bǝlki uni qɵldiki muxu orǝkkǝ taxliwetinglar; lekin uningƣa ⱪol tǝgküzmǝnglǝr, dedi (ǝmǝliyǝttǝ, u uni ularning ⱪolidin ⱪutⱪuzup, atisining ⱪexiƣa ⱪayturuwǝtmǝkqi idi). ");
INSERT INTO uigpin_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","Yüsüp akilirining ⱪexiƣa yetip kǝlgǝndǝ ular uni tutup, uning alaⱨidǝ tonini, yǝni kiyiklik uzun yǝnglik tonini salduruwelip, orǝkkǝ taxliwǝtti. Lekin orǝk ⱪuruⱪ bolup, iqidǝ su yoⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Andin ular tamaⱪ yegili olturdi. Ular bexini kɵtürüp ⱪariwidi, mana Ismaillarning bir karwini Gilead tǝrǝptin keliwatatti. Tɵgilirigǝ dora-dǝrmǝk, tutiya wǝ murmǝkkilǝr artilƣan bolup, Misir tǝrǝpkǝ ketiwatatti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yǝⱨuda ⱪerindaxliriƣa: — Bizning bir tuƣⱪan ⱪerindiximizni ɵltürüp, ⱪenini yoxurƣinimizning nemǝ paydisi bar? ");
INSERT INTO uigpin_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kelinglar, uni Ismaillarƣa setiwetǝyli; ⱪandaⱪla bolmisun u bizning inimiz, bir tuƣⱪan ⱪerindiximiz; xunga uningƣa ⱪol salmayli, dewidi, ⱪerindaxliri buningƣa ⱪulaⱪ saldi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Midiyanliⱪ sodigǝrlǝr xu yǝrdin ɵtüp ketiwatⱪanda, ular Yüsüpni orǝktin tartip qiⱪirip, ularƣa yigirmǝ kümüx tǝnggigǝ setiwǝtti. Bular bolsa Yüsüpni Misirƣa elip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubǝn orǝkning yeniƣa ⱪaytip kelip, Yüsüpning orǝktǝ yoⱪluⱪini kɵrüp, kiyimlirini yirtip, ");
INSERT INTO uigpin_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","inilirining ⱪexiƣa berip: — Bala yoⱪ turidu! Əmdi mǝn nǝgǝ baray?! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Əmma ular Yüsüpning tonini elip, bir tekini boƣuzlap tonni uning ⱪeniƣa milǝp, ");
INSERT INTO uigpin_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Andin uzun yǝnglik tonni atisining ⱪexiƣa ǝwǝtip, uningƣa: — Buni biz tepiwalduⱪ; bu oƣlungning tonimu-ǝmǝsmu, ɵzüng kɵrüp baⱪⱪin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","U uni tonup: — Bu dǝrwǝⱪǝ mening oƣlumning toni ikǝn; bir wǝⱨxiy ⱨaywan uni yǝp kǝtkǝn ohxaydu; xübⱨisizki, Yüsüp titma-titma ⱪiliwetiliptu! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Xuning bilǝn Yaⱪup kiyimlirini yirtip, beligǝ bɵz baƣlap, nurƣun künlǝrgiqǝ oƣli üqün matǝm tutti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Uning ⱨǝmmǝ oƣul-ⱪizliri yeniƣa kelip uningƣa tǝsǝlli bǝrsimu, u tǝsǝllini ⱪobul ⱪilmay: «Mǝn tǝⱨtisaraƣa qüxüp oƣlumning ⱪexiƣa barƣuqǝ xundaⱪ matǝm tutimǝn!» dedi. Yüsüpning atisi xu peti uningƣa aⱨ-zar kɵtürüp matǝm tutti. ");
INSERT INTO uigpin_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Əmdi midiyaniylar Yüsüpni Misirƣa elip berip, Pirǝwnning bir ƣojidari, pasiban bexi Potifarƣa satti.    ");
INSERT INTO uigpin_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","U waⱪitlarda xundaⱪ boldiki, Yǝⱨuda aka-ukilirining ⱪexidin ketip, Ⱨiraⱨ isimlik Adullamliⱪ bir kixiningkigǝ qüxti. ");
INSERT INTO uigpin_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Xu yǝrdǝ Yǝⱨuda Xua isimlik bir Ⱪanaaniyning ⱪizini kɵrdi; u uni hotunluⱪⱪa elip ⱪexiƣa kirip yatti.    ");
INSERT INTO uigpin_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","U ⱨamilidar bolup bir oƣul tuƣdi; Yǝⱨuda uningƣa «Ər» dǝp at ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","U yǝnǝ ⱨamilidar bolup, bir oƣul tuƣdi wǝ uningƣa Onan dǝp at ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Andin yǝnǝ ⱨamilidar bolup bir oƣul tuƣdi wǝ uningƣa Xǝlaⱨ dǝp at ⱪoydi. U tuƣulƣanda Yǝⱨuda Kezibda idi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yǝⱨuda tunji oƣli Ərgǝ Tamar isimlik bir ⱪizni elip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Lekin Yǝⱨudaning tunji oƣli Ər Pǝrwǝrdigarning nǝziridǝ rǝzil bolƣaqⱪa, Pǝrwǝrdigar uni ɵltürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Bu qaƣda Yǝⱨuda Onanƣa: — Akangning ayalining ⱪexiƣa kirip, uni hotunluⱪⱪa elip ⱪerindaxliⱪ burqini Ada ⱪilip, akang üqün nǝsil ⱪaldurƣin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Əmma Onan bu nǝsilning ɵzigǝ tǝwǝ bolmaydiƣanliⱪini bilip, akisiƣa nǝsil ⱪaldurmasliⱪ üqün ⱨǝr ⱪetim akisining ayali bilǝn billǝ bolƣanda mǝniysini yǝrgǝ aⱪturuwetǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Uning bu ⱪilmixi Pǝrwǝrdigarning nǝziridǝ rǝzil kɵrüngǝqkǝ, unimu ɵltürüwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yǝⱨuda ǝmdi kelini Tamarƣa: — Oƣlum Xǝlaⱨ qong bolƣuqǝ atangning ɵyidǝ tul olturup turƣin, dedi. Qünki u iqidǝ: — Bumu akiliriƣa ohxax ɵlüp ketǝrmikin, dǝp ⱪorⱪti. Xuning bilǝn Tamar berip atisining ɵyidǝ turup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Əmdi kɵp künlǝr ɵtüp, Xuaning ⱪizi, Yǝⱨudaƣa tǝgkǝn ayal ɵldi. Yǝⱨuda tǝsǝlli tapⱪandin keyin adullamliⱪ dosti Ⱨiraⱨ bilǝn billǝ ɵzining ⱪoy ⱪirⱪiƣuqilirining ǝⱨwalini bilixkǝ Timnaⱨⱪa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamarƣa: — Ⱪeynatang ⱪoylirini ⱪirⱪiƣili Timnaⱨⱪa yol aldi, degǝn hǝwǝr yǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Xuning bilǝn Tamar Xǝlaⱨ qong bolƣan bolsimu, mǝn uningƣa hotunluⱪⱪa elip berilmidim, dǝp ⱪarap, tulluⱪ kiyimini seliwetip, qümbǝl tartip bǝdinini orap, Timnaⱨ yolining üstidǝ Ənaimƣa kirix eƣiziƣa berip olturdi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Əmdi Yǝⱨuda uni yüzi yepiⱪliⱪ ⱨalda kɵrgǝndǝ: — Bu bir paⱨixǝ ayal ohxaydu, dǝp oylidi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","U yoldin burulup uning yeniƣa berip, ɵz kelini ikǝnlikini bilmǝy: — Kǝl, mǝn sǝn bilǝn billǝ bolay, dedi. U jawab berip: — Mǝn bilǝn billǝ bolsang, manga nemǝ berisǝn? dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","U uningƣa: — Padamning iqidin bir oƣlaⱪni sanga ǝwǝtip berǝy, dedi. Ayal: — Sǝn uni ǝkelip bǝrgüqǝ, manga rǝnigǝ birǝr nǝrsǝ berǝmsǝn? dǝp soriwidi, ");
INSERT INTO uigpin_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","U: — Sanga nemini rǝnigǝ berǝy? — dedi. U: — Ɵz mɵⱨürüng bilǝn uning xoynisini wǝ ⱪolungdiki ⱨasangni rǝnigǝ bǝrgin, dewidi, u bularni berip, uning bilǝn birgǝ boldi. Xuning bilǝn u uningdin ⱨamilidar bolup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Andin Tamar ornidin turup mangdi; u pǝrǝnjini seliwetip, tulluⱪ kiyimini kiyiwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yǝⱨuda: — U hotunning ⱪolidiki rǝnini yandurup kǝlsun dǝp adullamliⱪ dostining ⱪoli arⱪiliⱪ oƣlaⱪni ǝwǝtti, ǝmma u uni tapalmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","U xu jaydiki adǝmlǝrdin: — Ənaimdiki yolning boyida olturƣan butpǝrǝs paⱨixǝ ⱪeni, dǝp sorisa, ular: — Bu yǝrdǝ ⱨeqbir butpǝrǝs paⱨixǝ bolƣan ǝmǝs, dǝp jawab bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Buning bilǝn u Yǝⱨudaning ⱪexiƣa yenip berip: — Mǝn uni tapalmidim; üning üstigǝ u jaydiki adǝmlǝrmu: «Bu yǝrdǝ ⱨeqbir butpǝrǝs paⱨixǝ ayal bolƣan ǝmǝs» deyixti, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yǝⱨuda: — Boptu, u nǝrsilǝrni u elip kǝtsǝ kǝtsun; bolmisa, baxⱪilarning mǝshirisigǝ ⱪalimiz. Nemila bolmisun, mǝn uningƣa oƣlaⱪ ǝwǝttim, lekin sǝn u hotunni tapalmiding, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Üq ayqǝ ɵtkǝndin keyin birsi Yǝⱨudaƣa: — Sening kelining Tamar buzuⱪqiliⱪ ⱪildi, uning üstigǝ zinadin ⱨamilidar bolup ⱪaldi, degǝn hǝwǝrni yǝtküzdi. Yǝⱨuda jawabǝn: — Uni elip qiⱪinglar, kɵydürüwetilsun! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Lekin u elip qiⱪilƣanda ⱪeynatisiƣa hǝwǝr ǝwǝtip: — Bu nǝrsilǝrning igisi bolƣan adǝmdin ⱨamilidar boldum! Əmdi sǝn kɵrüp baⱪ, bu mɵⱨür, xoynisi wǝ ⱨasining kimning ikǝnlikini etirap ⱪilƣin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yǝⱨuda bu nǝrsilǝrni etirap ⱪilip: — U manga nisbǝtǝn ⱨǝⱪliⱪtur; dǝrwǝⱪǝ mǝn uni oƣlum Xǝlaⱨⱪa elip bǝrmidim, dedi. Bu ixtin keyin Yǝⱨuda uningƣa yǝnǝ yeⱪinqiliⱪ ⱪilmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Uning tuƣut waⱪti yeⱪinlaxti, mana ⱪorsiⱪida ⱪoxkezǝk bar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","U tuƣⱪan waⱪtida balilardin birsi ⱪolini qiⱪiriwidi, tuƣut anisi dǝrⱨal bir ⱪizil yipni elip: «Bu awwal qiⱪti» dǝp uning ⱪoliƣa qigip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Lekin u ⱪolini yǝnǝ iqigǝ tiⱪiwaldi, mana uning inisi qiⱪti. Xuning bilǝn tuƣut anisi: «Sǝn ⱪandaⱪ ⱪilip bɵsüp qiⱪting!» dedi; xuning bilǝn uningƣa «Pǝrǝz» degǝn at ⱪoyuldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Andin ⱪoliƣa ⱪizil yip qigilgǝn akisi tuƣuldi. Uning ismi Zǝraⱨ dǝp ataldi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yüsüp bolsa Misirƣa elip kelindi; uni Pirǝwnning ƣojidari, pasiban bexi Potifar xu yǝrgǝ elip kǝlgǝn Ismaillarning ⱪolidin setiwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Lekin Pǝrwǝrdigar Yüsüp bilǝn billǝ bolƣaqⱪa, uning ixliri ongƣa tartti; u misirliⱪ hojisining ɵyidǝ turup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Uning hojisi Pǝrwǝrdigarning uning bilǝn billǝ ikǝnlikini, xundaⱪla u nemǝ ix ⱪilsa, Pǝrwǝrdigarning uning ⱪolida ronaⱪ tapⱪuzƣanliⱪini bayⱪidi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Xuning bilǝn Yüsüp uning nǝziridǝ iltipat tepip, uning has hizmǝtqisi boldi. Hojisi uni ɵyini baxⱪuruxⱪa ⱪoydi wǝ barliⱪ tǝǝlluⱪatini uning ⱪoliƣa tapxurdi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Wǝ xundaⱪ boldiki, u uni ɵyi wǝ barliⱪ tǝǝlluⱪatini baxⱪuruxⱪa ⱪoyƣandin tartip, Pǝrwǝrdigar bu misirliⱪning ɵyini Yüsüpning sǝwǝbidin bǝrikǝtlidi; Pǝrwǝrdigarning bǝrikiti uning pütün ailisi wǝ barliⱪ teriⱪqiliⱪiƣa kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Xuning bilǝn Potifar barliⱪ ixlirini Yüsüpning ⱪoliƣa tapxurup, ɵz tamiⱪini yeyixtin baxⱪa ⱨeqⱪandaⱪ ix bilǝn kari bolmidi. Yüsüp bolsa ⱪamiti kelixkǝn, huxqiray yigit idi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Birnǝqqǝ waⱪit ɵtkǝndin keyin xundaⱪ boldiki, uning hojisining ayalining Yüsüpkǝ kɵzi qüxüp ⱪelip: — Mǝn bilǝn yatⱪin! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Əmma u unimay hojisining ayaliƣa mundaⱪ dedi: — Mana hojam ɵydiki ixlarni, xundaⱪla barliⱪ tǝǝlluⱪatini ⱪolumƣa tapxurdi, manga tolimu ixinip ixlirim bilǝn kari bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Bu ɵydǝ mǝndin qong adǝm yoⱪ. Sǝndin baxⱪa u ⱨeqbir nǝrsini mǝndin ayimidi — qünki sǝn uning ayalidursǝn! Xundaⱪ turuⱪluⱪ mǝn ⱪandaⱪmu bundaⱪ rǝzillikni ⱪilip Huda aldida gunaⱨkar bolay? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Gǝrqǝ ⱨǝr küni Yüsüpkǝ xundaⱪ desimu, xundaⱪla u uning bilǝn yetip uningƣa yeⱪinqiliⱪ ⱪilixni yaki uning bilǝn birgǝ turuxni rǝt ⱪilƣan bolsimu, ");
INSERT INTO uigpin_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","xundaⱪ bir wǝⱪǝ boldiki, bir küni u ɵz ixi bilǝn ɵy iqigǝ kirgǝnidi, ɵydikilǝrdin ⱨeqⱪaysisi ɵyning iqidǝ ǝmǝs idi; ");
INSERT INTO uigpin_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","bu ayal uning tonini tutuwelip: — Mǝn bilǝn yatⱪin! dedi. U tonini uning ⱪoliƣa taxlap ⱪoyup, yügürgǝn peti ⱪeqip taxⱪiriƣa qiⱪip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ayal Yüsüpning tonini ɵz ⱪoliƣa taxlap ⱪeqip qiⱪip kǝtkinini kɵrüp, ");
INSERT INTO uigpin_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ɵyidiki hizmǝtqilirini qaⱪirip ularƣa: — Ⱪaranglar, erim bizgǝ ⱨaⱪarǝt kǝltürsun dǝp bir ibraniy adǝmni elip kǝptu! Bu adǝm yenimƣa kirip: «Sǝn bilǝn yatay» dewidi, ⱪattiⱪ warⱪiridim! ");
INSERT INTO uigpin_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","U mening ⱪattiⱪ warⱪiriƣinimni anglap, tonini yenimƣa taxlap, taxⱪiriƣa ⱪeqip kǝtti, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Xuning bilǝn hojisi ɵyigǝ yenip kǝlgüqǝ u Yüsüpning tonini yenida saⱪlap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Andin u erigimu xu gǝpni ⱪilip: — Sǝn elip kǝlgǝn ⱨeliⱪi ibraniy ⱪul manga ⱨaⱪarǝt ⱪilixⱪa ⱪeximƣa kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Lekin mǝn ⱪattiⱪ warⱪirap-jarⱪirdim, u tonini ⱪeximda taxlap, taxⱪiriƣa ⱪeqip kǝtti, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Uning hojisi ayalining: — Sening ⱪulung meni undaⱪ-mundaⱪ ⱪildi, degǝn gǝplirini anglap ƣǝzipi ottǝk tutaxti. ");
INSERT INTO uigpin_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Xuning bilǝn Yüsüpning hojisi uni tutup orda munarliⱪ zindanƣa ⱪamap ⱪoydi. Xu yǝrgǝ pǝⱪǝt padixaⱨning mǝⱨbusliri solinatti. Buning bilǝn u xu yǝrdǝ solaⱪta yetip ⱪaldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Lekin Pǝrwǝrdigar Yüsüp bilǝn billǝ bolup, uningƣa xapaǝt kɵrsitip, uni zindan begining nǝziridǝ iltipat tapturdi. ");
INSERT INTO uigpin_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Xuning bilǝn zindan begi gundihanida yatⱪan ⱨǝmmǝ mǝⱨbuslarni Yüsüpning ⱪoliƣa tapxurdi. Xu yǝrdǝ ⱪilinidiƣan ⱨǝrⱪandaⱪ ix uning ⱪoli bilǝn bolatti. ");
INSERT INTO uigpin_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Zindan begi Yüsüpning ⱪolidiki ⱨeqⱪandaⱪ ixtin ƣǝm ⱪilmatti; qünki Pǝrwǝrdigar uning bilǝn billǝ bolup, u ⱨǝrnemǝ ⱪilsa Pǝrwǝrdigar uni onguxluⱪ ⱪilatti. ");
INSERT INTO uigpin_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bu ixlardin keyin Misir padixaⱨining saⱪiysi wǝ bax nawiyi Misir padixaⱨining zitiƣa tegip gunaⱨkar bolup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Xuning bilǝn Pirǝwn uning bu ikki mǝnsǝpdariƣa, yǝni bax saⱪiy wǝ bax nawayƣa ƣǝzǝplinip, ");
INSERT INTO uigpin_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ularni pasiban bexining sariyiƣa, Yüsüp solaⱪliⱪ munarliⱪ zindanƣa solap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Pasiban bexi Yüsüpni ularning hizmitidǝ bolup ularni kütüxkǝ tǝyinlidi. Ular solaⱪta birnǝqqǝ kün yetip ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ular ikkisi — Misir padixaⱨining saⱪiysi wǝ nawiyi gundihanida solaⱪliⱪ turƣan bir keqidǝ qüx kɵrdi. Ⱨǝrbirining qüxining ɵzigǝ has tǝbiri bar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ətisi ǝtigǝndǝ, Yüsüp ularning ⱪexiƣa kiriwidi, ularning ƣǝmkin olturƣinini kɵrdi; ");
INSERT INTO uigpin_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","xunga u ɵzi bilǝn billǝ hojisining sariyida solaⱪliⱪ yatⱪan Pirǝwnning bu ikki mǝnsǝpdaridin: — Nemixⱪa qirayinglar bügün xunqǝ solƣun? — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ular uningƣa jawab berip: — Ikkimiz bir qüx kɵrduⱪ; ǝmma qüximizning tǝbirini yexip beridiƣan kixi yoⱪ, dedi. Yüsüp ularƣa: — Qüxkǝ tǝbir berix Hudadin bolidu ǝmǝsmu? Qüxünglarni manga eytip beringlar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Buning bilǝn bax saⱪiy Yüsüpkǝ qüxini eytip: — Qüxümdǝ aldimda bir üzüm teli turƣudǝk; ");
INSERT INTO uigpin_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","bu üzüm telining üq xehi bar ikǝn. U bih urup qeqǝklǝp, saplirida uzum pixip ketiptudǝk; ");
INSERT INTO uigpin_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pirǝwnning ⱪǝdǝⱨi ⱪolumda ikǝn; mǝn üzümlǝrni elip Pirǝwnning ⱪǝdǝⱨigǝ siⱪip, ⱪǝdǝⱨni uning ⱪoliƣa sunuptimǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yüsüp uningƣa jawabǝn: Qüxning tǝbiri xudurki, bu üq xah üq künni kɵrsitidu. ");
INSERT INTO uigpin_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Üq kün iqidǝ Pirǝwn ⱪǝddingni ruslitip, seni mǝnsipinggǝ ⱪaytidin tǝyinlǝydu. Buning bilǝn sǝn burun uningƣa saⱪiy bolƣandǝk Pirǝwnning ⱪǝdǝⱨini uning ⱪoliƣa sunidiƣan bolisǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Lekin ixliring onguxluⱪ bolƣanda meni yadingƣa yǝtküzüp, manga xapaǝt kɵrsitip Pirǝwnning aldida mening toƣramda gǝp ⱪilip, meni bu ɵydin qiⱪartⱪaysǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Qünki mǝn ⱨǝⱪiⱪǝtǝn ibraniylarning zeminidin naⱨǝⱪ tutup elip kelindim; bu yǝrdimu meni zindanƣa salƣudǝk bir ix ⱪilmidim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Bax naway Yüsüpning xundaⱪ yahxi tǝbir bǝrginini kɵrüp uningƣa mundaⱪ dedi: — Mǝnmu ɵzümni qüxümdǝ kɵrdüm; mana, beximda aⱪ nan bar üq sewǝt bar ikǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Əng üstünki sewǝttǝ nawaylar Pirǝwngǝ pixurƣan ⱨǝrhil nazunemǝtlǝr bar ikǝn; lekin ⱪuxlar beximdiki u sewǝttiki nǝrsilǝrni yǝp ketiptudǝk, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yüsüp jawabǝn: — Qüxning tǝbiri xudurki: — Bu üq sewǝt üq künni kɵrsitidu. ");
INSERT INTO uigpin_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Üq kün iqidǝ Pirǝwn sening bexingni kesip, jǝsitingni dǝrǝhkǝ asidikǝn. Xuning bilǝn uqarⱪanatlar kelip gɵxüngni yǝydikǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Üqinqi küni xundaⱪ boldiki, Pirǝwnning tuƣulƣan küni bolƣaqⱪa, u ⱨǝmmǝ hizmǝtkarliri üqün bir ziyapǝt ⱪilip bǝrdi, xundaⱪla dǝrwǝⱪǝ hizmǝtkarlirining arisida bax saⱪiyning bexini kɵtürdi wǝ bax nawayning bexini aldi; ");
INSERT INTO uigpin_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","u bax saⱪiyni ⱪaytidin ɵz mǝnsipigǝ tǝyinlidi; xuning bilǝn u Pirǝwnning ⱪǝdǝⱨini uning ⱪoliƣa ⱪaytidin sunidiƣan boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Lekin bax nawayni bolsa Yüsüp ularƣa tǝbir bǝrgǝndǝk esiwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Əmma bax saⱪiy Yüsüpni ⱨeq ǝslimǝy, ǝksiqǝ uni untup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Toptoƣra ikki yil ɵtüp, Pirǝwn bir qüx kɵrdi. Qüxidǝ u Nil dǝryasining boyida turƣudǝk. ");
INSERT INTO uigpin_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ⱨǝm qirayliⱪ ⱨǝm semiz yǝttǝ tuyaⱪ inǝk dǝryadin qiⱪip, ⱪumuxluⱪta otlaptudǝk. ");
INSERT INTO uigpin_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Andin yǝnǝ yǝttǝ tuyaⱪ inǝk dǝryadin qiⱪiptu; ular sǝt ⱨǝm oruⱪ bolup, aldinⱪi inǝklǝrning yenida, dǝryaning boyida turuptu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bu sǝt ⱨǝm oruⱪ inǝklǝr u yǝttǝ qirayliⱪ ⱨǝm semiz inǝklǝrni yǝwetiptu. Xu waⱪitta Pirǝwn oyƣinip ketiptu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","U yǝnǝ uhlap, ikkinqi ⱪetim qüx kɵrdi: — Mana, bir tüp buƣday xehidin toⱪ wǝ qirayliⱪ yǝttǝ baxaⱪ qiⱪiptu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ulardin keyin yǝnǝ yǝttǝ baxaⱪ qiⱪiptu; ular ⱨǝm oruⱪ wǝ puqǝk bolup, xǝrⱪ xamilida solixip ⱪalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bu oruⱪ baxaⱪlar u yǝttǝ semiz, toⱪ baxaⱪni yutup ketiptu. Andin Pirǝwn oyƣinip ketiptu, bu uning qüxi ikǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ətisi uning kɵngli naⱨayiti biaram bolup, Misirdiki ⱨǝmmǝ palqi-jadugǝrlǝr bilǝn barliⱪ danixmǝnlǝrni qaⱪirtip kǝldi. Pirǝwn ɵz qüxini ularƣa eytip bǝrdi; lekin ⱨeqkim Pirǝwngǝ qüxlǝrning tǝbirini dǝp berǝlmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","U qaƣda bax saⱪiy Pirǝwngǝ: — Bügün mening ɵtküzgǝn hataliⱪlirim esimgǝ kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Burun Pirǝwn janabliri ⱪulliriƣa, yǝni peⱪir wǝ bax nawayƣa aqqiⱪlinip, bizni pasiban bexining sariyida solaⱪⱪa taxliƣanidila; ");
INSERT INTO uigpin_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Xu qaƣlarda ⱨǝrbirimiz bir keqidǝ birdin qüx kɵrduⱪ; ⱨǝr ⱪaysimiz kɵrgǝn qüxning tǝbiri baxⱪa-baxⱪa idi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Xu yǝrdǝ biz bilǝn billǝ pasiban bexining ⱪuli bolƣan bir ibraniy yigit bar idi. Uningƣa qüxlirimizni eytiwiduⱪ, u bizgǝ qüxlirimizning tǝbirini bayan ⱪildi; u ⱨǝrbirimizning kɵrgǝn qüxigǝ ⱪarap tǝbir bǝrgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Xundaⱪ boldiki, ixlar dǝl uning bǝrgǝn tǝbiridǝ deyilgǝndǝk yüz bǝrdi; janabliri peⱪirni ɵz mǝnsipimgǝ ⱪaytidin tǝyinlidilǝ, bax nawayni darƣa astila, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Xuning bilǝn Pirǝwn adǝm ǝwǝtip, Yüsüpni qaⱪirdi; ular dǝrⱨal uni zindandin qiⱪardi. Yüsüp burut-saⱪilini qüxürüp, kiyimlirini yǝnggüxlǝp, Pirǝwnning aldiƣa kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pirǝwn Yüsüpkǝ: — Mǝn bir qüx kɵrdüm, ǝmma uning tǝbirini eytip berǝlǝydiƣan ⱨeqkim qiⱪmidi. Anglisam, sǝn qüxkǝ tǝbir berǝlǝydikǝnsǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yüsüp Pirǝwngǝ jawab berip: — Tǝbir berix ɵzümdin ǝmǝs; lekin Huda Pirǝwngǝ hatirjǝmlik beridiƣan bir jawab beridu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pirǝwn Yüsüpkǝ: — Qüxümdǝ mǝn dǝryaning ⱪirƣiⱪida turuptimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ⱪarisam, dǝryadin ⱨǝm semiz ⱨǝm qirayliⱪ yǝttǝ tuyaⱪ inǝk qiⱪip ⱪumuxluⱪta otlaptu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Andin ulardin keyin ajiz, tolimu sǝt ⱨǝm oruⱪ yǝttǝ tuyaⱪ inǝk qiⱪiptu. Mǝn Misir zeminida xundaⱪ sǝt inǝklǝrni kɵrgǝn ǝmǝsmǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bu oruⱪ, ǝski inǝklǝr bolsa awwalⱪi yǝttǝ semiz inǝkni yǝwetiptu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ularni yǝwǝtkǝn bolsimu, ⱪorsiⱪiƣa bir nemining kirgǝnliki ⱨeq ayan bolmaptu, ularning kɵrünüxi bǝlki burunⱪidǝk sǝt imix. Andin mǝn oyƣinip kǝttim. ");
INSERT INTO uigpin_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Andin yǝnǝ bir qüx kɵrdum, mana bir xahtin yǝttǝ ⱨǝm toⱪ ⱨǝm qirayliⱪ baxaⱪ qiⱪiptu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Andin yǝnǝ yǝttǝ puqǝk, oruⱪ baxaⱪ qiⱪiptu; ular xǝrⱪ xamili bilǝn solixip ⱪurup ketiptu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Bu oruⱪ baxaⱪlar yǝttǝ qirayliⱪ baxaⱪni yǝp ketiptu. Mǝn bu ixni palqi-jadugǝrlǝrgǝ dǝp bǝrsǝm, manga tǝbirini eytip beridiƣan ⱨeq kixi qiⱪmidi, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yüsüp Pirǝwngǝ: — Janabliri Pirǝwnning qüxliri bir mǝnididur. Huda Ɵzi ⱪilmaⱪqi bolƣan ixlirini Pirǝwngǝ aldin bildürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bu yǝttǝ yahxi inǝk yǝttǝ yilni kɵrsitidu; yǝttǝ yahxi baxaⱪmu yǝttǝ yilni kɵrsitidu. Bu qüxlǝr ohxax bir qüxtur. ");
INSERT INTO uigpin_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ulardin keyin qiⱪⱪan yǝttǝ oruⱪ, yaman sǝt inǝk yǝttǝ yilni kɵrsitidu; xǝrⱪ xamili bilǝn solixip ⱪalƣan yǝttǝ ⱪuruⱪ baxaⱪmu xundaⱪ bolup, aqarqiliⱪ bolidiƣan yǝttǝ yildur. ");
INSERT INTO uigpin_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Mǝn Pirǝwngǝ dǝydiƣan sɵzüm xuki, Huda yeⱪinda ⱪilmaⱪqi bolƣan ixni Pirǝwngǝ ayan ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mana, pütkül Misir zeminida yǝttǝ yilƣiqǝ mǝmurqiliⱪ bolidu; ");
INSERT INTO uigpin_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","andin yǝttǝ yilƣiqǝ aqarqiliⱪ bolidu; xuning bilǝn Misir zeminida pütkül mǝmurqiliⱪni unutⱪuzidiƣan aqarqiliⱪ zeminni wǝyran ⱪilidu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kelidiƣan aqarqiliⱪning sǝwǝbidin zeminda bolƣan mǝmurqiliⱪ kixilǝrning esidin kɵtürülüp ketidu; qünki aqarqiliⱪ tolimu eƣir bolidu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Lekin qüxning yandurulup, Pirǝwngǝ ikki ⱪetim kɵrünginining ǝⱨmiyiti xuki, bu ix Huda tǝripidin bekitilgǝn bolup, Huda uni pat arida ǝmǝlgǝ axuridu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Əmdi Pirǝwn ɵzi üqün pǝm-parasǝtlik ⱨǝm dana bir kixini tepip, Misir zeminiƣa ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pirǝwn xundaⱪ ⱪilsunki, mǝmurqiliⱪ bolƣan yǝttǝ yilda Misir zeminidin qiⱪⱪan axliⱪning bǝxtin birini toplanglar dǝp zeminƣa nazarǝtqilǝrni tǝyinlisun. ");
INSERT INTO uigpin_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Bular xu kelidiƣan toⱪqiliⱪ yillirida barliⱪ axliⱪni toplap, xǝⱨǝr-xǝⱨǝrlǝrdǝ yemǝklik bolsun dǝp buƣday-ⱪonaⱪlarni Pirǝwnning ⱪol astiƣa jǝm ⱪilip saⱪlitip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yiƣilƣan xu axliⱪlar Misir zeminida bolidiƣan yǝttǝ yilliⱪ aqarqiliⱪⱪa taⱪabil turux üqün saⱪlansun; xu tǝriⱪidǝ zemin aqarqiliⱪtin ⱨalak bolmaydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Bu sɵz Pirǝwn wǝ uning hizmǝtkarlirining nǝzirigǝ taza yaⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Xuning bilǝn Pirǝwn hizmǝtkarliriƣa: — Bu kixidǝk, iqidǝ Hudaning roⱨi bar yǝnǝ birsini tapalamduⱪ?! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pirǝwn Yüsüpkǝ: — Huda sanga buning ⱨǝmmisini ayan ⱪilƣanikǝn, sǝndǝk pǝmlik ⱨǝm dana ⱨeqkim qiⱪmaydu. ");
INSERT INTO uigpin_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Sǝn ǝmdi mening ɵyümni baxⱪuruxⱪa bekitilding, barliⱪ hǝlⱪim sening aƣzingƣa ⱪarap ɵzlirini tǝrtipkǝ tizsun. Pǝⱪǝt tǝhttila mǝn sǝndin üstün turimǝn, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ahirida Pirǝwn Yüsüpkǝ: — Mana, mǝn seni pütkül Misir zeminining üstigǝ tǝyinlidim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Buning bilǝn, Pirǝwn ɵz ⱪolidin mɵⱨür üzükini qiⱪirip, Yüsüpning ⱪoliƣa saldi; uningƣa nǝpis kanap rǝhttin tikilgǝn libasni kiygüzüp, boyniƣa bir altun zǝnjir esip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Uni ɵzining ikkinqi xaⱨanǝ ⱨarwisiƣa olturƣuzup, uning aldida: «Tiz pükünglar!» — dǝp jar saldurdi. Xundaⱪ ⱪilip, Pirǝwn uni pütkül Misir zeminiƣa tiklǝp ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Andin Pirǝwn Yüsüpkǝ yǝnǝ: — Mǝn degǝn Pirǝwndurmǝn; pütkül Misir zeminida sǝnsiz ⱨeqkim ⱪol-putini midirlatmisun! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Pirǝwn Yüsüpkǝ Zafinat-Paaniyaⱨ degǝn namni bǝrdi wǝ on xǝⱨiridiki kaⱨin Potifiraⱨning ⱪizi Asinatni uningƣa hotunluⱪⱪa elip bǝrdi. Xundaⱪ ⱪilip Yüsüp pütkül Misir zeminini baxⱪurux üqün qɵrgilǝxkǝ qiⱪti. Yüsüp Misir padixaⱨi Pirǝwnning hizmitidǝ boluxⱪa bekitilgǝndǝ ottuz yaxta idi; u Pirǝwnning aldidin qiⱪip, Misir zeminining ⱨǝrⱪaysi jaylirini kɵzdin kǝqürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mǝmurqiliⱪ bolƣan yǝttǝ yil iqidǝ zeminning ⱨosuli dɵwǝ-dɵwǝ boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yǝttǝ yilda u Misir zeminidin qiⱪⱪan axliⱪni yiƣip, xǝⱨǝr-xǝⱨǝrgǝ toplidi; ⱨǝrⱪaysi xǝⱨǝrning ǝtrapidiki etizliⱪning axliⱪini u xu xǝⱨǝrning ɵzigǝ juƣlap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Xu tǝriⱪidǝ Yüsüp dengizdiki ⱪumdǝk naⱨayiti kɵp axliⱪ toplidi; axliⱪ ⱨǝddi-ⱨesabsiz bolƣaqⱪa, ular ⱨesablaxni tohtatti. ");
INSERT INTO uigpin_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Aqarqiliⱪ yilliri yetip kelixtin burun Yüsüpkǝ ikki oƣul tɵrǝldi. Bularni Ondiki kaⱨin Potifǝraⱨning ⱪizi Asinat uningƣa tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yüsüp: «Huda pütün japa-muxǝⱪⱪitim wǝ atamning pütün ailisini kɵnglümdin kɵtürüwǝtti» dǝp tunji oƣliƣa Manassǝⱨ dǝp at ⱪoydi; ");
INSERT INTO uigpin_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","andin: «Mǝn azab-oⱪubǝt qǝkkǝn yurtta Huda meni mewilik ⱪildi» dǝp ikkinqisigǝ Əfraim dǝp at ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Misir zeminida mǝmurqiliⱪ bolƣan yǝttǝ yil ayaƣlaxti. ");
INSERT INTO uigpin_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Andin Yüsüpning eytⱪinidǝk aqarqiliⱪning yǝttǝ yili baxlandi. U qaƣlarda baxⱪa barliⱪ yurtlardimu aqarqiliⱪ boldi; lekin Misir zeminidiki ⱨǝr yǝrlǝrdǝ nan bar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Aqarqiliⱪ pütkül Misir zeminni basⱪanda, hǝlⱪ axliⱪ sorap Pirǝwngǝ pǝryad ⱪildi. Pirǝwn misirliⱪlarning ⱨǝmmisigǝ: — Yüsüpning ⱪexiƣa berip, u silǝrgǝ nemǝ desǝ, xuni ⱪilinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Aqarqiliⱪ pütkül yǝr yüzini besip kǝtti. Yüsüp ⱨǝr yǝrdiki ambarlarni eqip, misirliⱪlarƣa axliⱪ satatti; aqarqiliⱪ Misir zeminida intayin eƣir bolƣili turdi. ");
INSERT INTO uigpin_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Aqarqiliⱪ pütkül yǝr yüzini basⱪan bolƣaqⱪa, barliⱪ yurtlardiki hǝlⱪmu axliⱪ alƣili Misirƣa Yüsüpning ⱪexiƣa kelǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Əmdi Yaⱪup Misirda axliⱪ barliⱪini bilginidǝ oƣulliriƣa: — Nemixⱪa bir-biringlarƣa ⱪarixip turisilǝr? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Andin yǝnǝ: — Manga ⱪaranglar, angliximqǝ Misirda axliⱪ bar ikǝn. U yǝrgǝ berip, andin xu yǝrdin bizgǝ axliⱪ elip kelinglar; buning bilǝn ɵlüp kǝtmǝy, tirik ⱪalimiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Buning bilǝn Yüsüpning on akisi axliⱪ setiwalƣili Misirƣa yolƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Lekin Yaⱪup Yüsüpning inisi Binyaminning birǝr yamanliⱪⱪa uqrap ⱪelixidin ⱪorⱪup uni akiliri bilǝn billǝ ǝwǝtmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Xuningdǝk aqarqiliⱪ Ⱪanaan zeminidimu yüz bǝrgǝqkǝ, Israilning oƣulliri axliⱪ alƣili kǝlgǝnlǝr arisida bar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yüsüp zeminning waliysi bolup, yurtning barliⱪ hǝlⱪigǝ axliⱪ setip bǝrgüqi xu idi. Yüsüpning akiliri kelip uning aldida yüzlirini yǝrgǝ tǝgküzüp tǝzim ⱪildi.    ");
INSERT INTO uigpin_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yüsüp akilirini kɵrüpla ularni tonudi; lekin u tonuxluⱪ bǝrmǝy, ularƣa ⱪopal tǝlǝppuzda gǝp ⱪilip: — Ⱪǝyǝrdin kǝldinglar, dǝp soridi. Ular jawabǝn: — Ⱪanaan zeminidin axliⱪ alƣili kǝlduⱪ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yüsüp akilirini tonuƣan bolsimu, lekin ular uni tonumidi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yüsüp ǝmdi ular toƣrisida kɵrgǝn qüxlirini esigǝ elip, ularƣa: — Silǝr jasus, bu ǝlning mudapiǝsiz jaylirini kɵzǝtkili kǝldinglar, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Əmma ular uningƣa jawab berip: — Əy hojam, undaⱪ ǝmǝs! Bǝlki kǝminiliri axliⱪ setiwalƣili kǝldi! ");
INSERT INTO uigpin_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Biz ⱨǝmmimiz bir adǝmning oƣulliri, sǝmimiy adǝmlǝrmiz. Kǝminiliri jasus ǝmǝs! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","U ularƣa yǝnǝ: — Undaⱪ ǝmǝs! Bǝlki zeminning mudapiǝsiz jaylirini kɵrgili kǝldinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ular jawab berip: — Kǝminiliri ǝslidǝ on ikki ⱪerindax iduⱪ; biz ⱨǝmmimiz Ⱪanaan zeminidiki bir adǝmning oƣulliridurmiz; lekin kǝnji inimiz atimizning ⱪexida ⱪelip ⱪaldi; yǝnǝ bir inimiz yoⱪap kǝtti, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Əmma Yüsüp ularƣa yǝnǝ: — Mana mǝn dǝl silǝrgǝ eytⱪinimdǝk, jasus ikǝnsilǝr! ");
INSERT INTO uigpin_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Pirǝwnning ⱨayati bilǝn ⱪǝsǝm ⱪilimǝnki, kiqik ininglar bu yǝrgǝ kǝlmigüqǝ silǝr bu yǝrdin qiⱪip ketǝlmǝysilǝr; silǝr xuning bilǝn sinilisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ininglarni elip kǝlgili biringlarni ǝwǝtinglar, ⱪalƣanliringlar bolsa solap ⱪoyulisilǝr. Buning bilǝn eytⱪininglarning rast-yalƣanliⱪi ispatlinidu; bolmisa, Pirǝwnning ⱨayati bilǝn ⱪǝsǝm ⱪilimǝnki, silǝr jǝzmǝn jasus! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Xuning bilǝn u ularni üq küngiqǝ solap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Üqinqi küni Yüsüp ularƣa mundaⱪ dedi: — Mǝn Hudadin ⱪorⱪidiƣan adǝmmǝn; tirik ⱪelixinglar üqün muxu ixni ⱪilinglar: — ");
INSERT INTO uigpin_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Əgǝr sǝmimiy adǝmlǝr bolsanglar, ⱪerindaxliringlardin biri silǝr solanƣan gundihanida solaⱪliⱪ turiwǝrsun, ⱪalƣininglar aqarqiliⱪta ⱪalƣan ailǝnglar üqün axliⱪ elip ketinglar; ");
INSERT INTO uigpin_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Andin kiqik ininglarni ⱪeximƣa elip kelinglar. Xuning bilǝn sɵzliringlar ispatlansa, ɵlmǝysilǝr!, — dedi. Ular xundaⱪ ⱪilidiƣan boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Andin ular ɵzara: — Bǝrⱨǝⱪ, biz inimizƣa ⱪilƣan iximiz bilǝn gunaⱨkar bolup ⱪalduⱪ; u bizgǝ yalwursimu uning azabini kɵrüp turup uningƣa ⱪulaⱪ salmiduⱪ. Xuning üqün bu azab-oⱪubǝt beximizƣa qüxti, — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubǝn ularƣa jawabǝn: — Mǝn silǝrgǝ: baliƣa zulum ⱪilmanglar, degǝn ǝmǝsmidim? Lekin unimidinglar. Mana ǝmdi uning ⱪan ⱪǝrzi bizdin soriliwatidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Əmma Yüsüp ular bilǝn tǝrjiman arⱪiliⱪ sɵzlǝxkǝqkǝ, ular Yüsüpning ɵz gǝplirini uⱪup turuwatⱪinini bilmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","U ulardin ɵzini qǝtkǝ elip, yiƣlap kǝtti. Andin ularning ⱪexiƣa yenip kelip, ularƣa yǝnǝ sɵz ⱪilip, ularning arisidin Ximeonni tutup, ularning kɵz aldida baƣlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Andin Yüsüp ǝmr qüxürüp, ularning taƣarliriƣa axliⱪ toldurup, ⱨǝr birsining pulini ⱪayturup taƣiriƣa selip ⱪoyup, sǝpǝr ⱨazirliⱪlirimu berilsun dǝp buyruwidi, ularƣa xundaⱪ ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Xuning bilǝn akiliri exǝklirigǝ axliⱪlirini artip, xu yǝrdin kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Əmma ɵtǝnggǝ kǝlgǝndǝ ulardin biri exikigǝ yǝm bǝrgili taƣirini eqiwidi, mana, ɵz puli taƣarning aƣzida turatti. ");
INSERT INTO uigpin_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","U ⱪerindaxliriƣa: — Mening pulumni ⱪayturuwetiptu. Mana u taƣirimda turidu, dedi. Buni anglap ularning yüriki su bolup, titrixip bir-birigǝ: — Bu Hudaning bizgǝ zadi nemǝ ⱪilƣinidu? — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ular Ⱪanaan zeminiƣa, atisi Yaⱪupning ⱪexiƣa kelip, bexidin ɵtkǝn ⱨǝmmǝ wǝⱪǝlǝrni uningƣa sɵzlǝp berip: ");
INSERT INTO uigpin_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— ⱨeliⱪi kixi, yǝni xu zeminning hojisi bizgǝ ⱪopal gǝp ⱪildi, bizgǝ zeminni payliƣuqi jasustǝk muamilǝ ⱪildi; ");
INSERT INTO uigpin_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ǝmdi biz uningƣa: «Biz bolsaⱪ sǝmimiy adǝmlǝrmiz, jasus ǝmǝsmiz. ");
INSERT INTO uigpin_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Biz bir atidin bolƣan oƣullar bolup, on ikki aka-uka iduⱪ; biri yoⱪap kǝtti, kiqik inimiz ⱨazir Ⱪanaan zeminida atimizning yenida ⱪaldi» desǝk, ");
INSERT INTO uigpin_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ⱨeliⱪi kixi, yǝni xu zeminning hojisi bizgǝ mundaⱪ dedi: «Mening silǝrning sǝmimiy ikǝnlikinglarni bilixim üqün, ⱪerindaxliringlarning birini mening yenimda ⱪaldurup ⱪoyup, aq ⱪalƣan ailǝnglar üqün axliⱪ elip ketinglar; ");
INSERT INTO uigpin_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","andin kiqik ininglarni ⱪeximƣa elip kelinglar; xundaⱪ ⱪilsanglar, silǝrning jasus ǝmǝs, bǝlki sǝmimiy adǝmlǝr ikǝnlikinglarni bilǝlǝymǝn. Andin ⱪerindixinglarni silǝrgǝ ⱪayturup berimǝn wǝ silǝr zeminda soda-setiⱪ ⱪilsanglar bolidu» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Əmma xundaⱪ boldiki, ular taƣarlirini tɵkkǝndǝ, mana ⱨǝrbirining puldini ɵz taƣarlirida turatti! Ular wǝ atisi ɵzlirining qigiklik pullirini kɵrgǝndǝ, ⱪorⱪup ⱪelixti. ");
INSERT INTO uigpin_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Atisi Yaⱪup ularƣa: — Meni oƣlumdin juda ⱪildinglar! Yüsüp yoⱪ boldi, Ximeonmu yoⱪ, ǝmdi Binyaminnimu elip kǝtmǝkqi boluwatisilǝr! Mana bu ixlarning ⱨǝmmisi mening beximƣila kǝldi! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubǝn atisiƣa: — Əgǝr mǝn Binyaminni ⱪexingƣa ⱪayturup elip kǝlmisǝm, mening ikki oƣlumni ɵltürüwǝtkin; uni mening ⱪolumƣa tapxurƣin; mǝn uni ⱪexingƣa yandurup elip kelimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Lekin Yaⱪup jawab berip: — Oƣlum silǝr bilǝn billǝ u yǝrgǝ qüxmǝydu; qünki uning akisi ɵlüp ketip, u ɵzi yalƣuz ⱪaldi. Mubada yolda ketiwatⱪanda uningƣa birǝr kelixmǝslik kǝlsǝ, silǝr mǝndǝk bir aⱪ qaqliⱪ adǝmni dǝrd-ǝlǝm bilǝn tǝⱨtisaraƣa qüxürüwetisilǝr, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Aqarqiliⱪ zeminni intayin eƣir basⱪanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Bu sǝwǝbtin ular Misirdin elip kǝlgǝn axliⱪni yǝp tügǝtkǝndǝ, atisi ularƣa: — Yǝnǝ berip bizgǝ azƣina axliⱪ elip kelinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Lekin Yǝⱨuda uningƣa jawabǝn: — Ⱨeliⱪi kixi bizni ⱪattiⱪ agaⱨlandurup: «Ininglar silǝr bilǝn billǝ kǝlmisǝ, yüzümni kɵrimǝn dǝp hiyal ⱪilmanglar» degǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Əgǝr inimizni biz bilǝn billǝ ǝwǝtsǝng, biz berip sanga axliⱪ elip kelimiz. ");
INSERT INTO uigpin_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Əmma ǝwǝtixkǝ unimisang, biz barmaymiz; qünki ⱨeliⱪi kixi bizgǝ: «Ininglar silǝr bilǝn billǝ kǝlmisǝ, yüzümni kɵrimǝn dǝp hiyal ⱪilmanglar» degǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israil ularƣa: — Silǝr nemixⱪa manga xunqǝ yamanliⱪ ⱪilip u kixigǝ: «Yǝnǝ bir inimizmu bar» dedinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ular jawabǝn: — U kixi bizning wǝ ailimizning ǝⱨwalini sürüxtürüp koqilap: «Atanglar tehi Ⱨayatmu? Yǝnǝ bir ininglar barmu?» — dǝp soridi. Biz uning xu soaliƣa yarixa jawab bǝrduⱪ. Uning bizgǝ: «Ininglarni elip kelinglar» dǝydiƣinini nǝdin bilǝyli? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yǝⱨuda atisi Israilƣa: — Balini mǝn bilǝn ǝwǝtkin; biz dǝrⱨal ⱪozƣilip yolƣa qiⱪayli; xundaⱪta biz wǝ sǝn, bizlǝr ⱨǝm balilirimiz ɵlmǝy, tirik ⱪalimiz. ");
INSERT INTO uigpin_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mǝn uningƣa kepil bolimǝn; sǝn uning üqün mening meningdin ⱨesab alisǝn; ǝgǝr mǝn uni sening ⱪexingƣa aman-esǝn yandurup kelip, yüzüngning aldida turƣuzmisam, pütkül ɵmrümdǝ aldingda gunaⱨkar bolay.    ");
INSERT INTO uigpin_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Qünki ⱨayal bolmiƣan bolsaⱪ, bu qaƣⱪiqǝ ikki ⱪetim berip kelǝttuⱪ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ularning atisi Israil ularƣa: — Undaⱪ bolsa, mundaⱪ ⱪilinglar: — U kixigǝ ⱪaqa-ⱪuqanglarƣa zemindiki ǝng esil mewilǝrdin sowƣat alƣaq beringlar: yǝnǝ azƣina tutiya, azraⱪ ⱨǝsǝl, dora-dǝrmanlar, murmǝkki, pistǝ wǝ badamlarni alƣaq beringlar. ");
INSERT INTO uigpin_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ⱪolunglarda ikki ⱨǝssǝ pul elip, taƣarliringlarning aƣzidiki ɵzünglarƣa yandurulƣan pulnimu alƣaq beringlar. Eⱨtimal, bu ixta sǝwǝnlik kɵrülgǝn boluxi mumkin. ");
INSERT INTO uigpin_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ininglarnimu billǝ elip, ⱪozƣilip u kixining yeniƣa yǝnǝ beringlar. ");
INSERT INTO uigpin_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ⱨǝmmigǝ Ⱪadir Tǝngri Ɵzi silǝrni u kixining aldida rǝⱨimgǝ erixtürgǝy. Buning bilǝn u silǝrning xu yǝrdiki ⱪerindixinglarni wǝ Binyaminni ⱪoyup berip, silǝrgǝ ⱪoxup ⱪoyarmikin; ɵzüm nawada balilirimdin juda bolsam bolay! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Xuning bilǝn bu adǝmlǝr xu sowƣatni elip, ⱪolliriƣa ikki ⱨǝssǝ pulni tutup, Binyaminni elip ⱪozƣilip, Misirƣa berip Yüsüpning aldida ⱨazir boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yüsüp Binyaminni ular bilǝn billǝ kɵrginidǝ, ɵz ɵyini baxⱪuridiƣan ƣojidariƣa buyrup: — Bu adǝmlǝrni ɵyümgǝ baxlap kirip, mal soyup taam tǝyyar ⱪilƣin; qünki bu kixilǝr qüxlük ƣizani mǝn bilǝn yǝydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","U kixi Yüsüpning buyruƣinidǝk ⱪilip, adǝmlǝrni Yüsüpning ɵyigǝ baxlap kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ular bolsa Yüsüpning ɵyigǝ baxlap kelinginidin ⱪorⱪuxup: — Aldinⱪi ⱪetim taƣarlirimizƣa yandurulƣan pulning sǝwǝbidin biz uning ɵyigǝ elip kelinduⱪ; uning mǝⱪsiti bizgǝ ⱨujum ⱪilip, üstimizdin besip ⱪul ⱪilip, exǝklirimizni tartiwelix ohxaydu, — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ular Yüsüpning ɵyini baxⱪuridiƣan ƣojidarning yeniƣa kelip, ɵyning ixikining tüwidǝ uningƣa: — ");
INSERT INTO uigpin_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Əy hojam, biz ⱨǝⱪiⱪǝtǝn ǝslidǝ muxu yǝrgǝ axliⱪ alƣili kǝlgǝniduⱪ; ");
INSERT INTO uigpin_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Xundaⱪ boldiki, biz ɵtǝnggǝ kelip ɵz taƣarlirimizni aqsaⱪ, mana ⱨǝrbirimizning puli, ǝyni eƣirliⱪi boyiqǝ taƣarlirimizning aƣzida turuptu; xunga biz buni yandurup ⱪolimizda alƣaq kǝlduⱪ. ");
INSERT INTO uigpin_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Axliⱪ alƣili ⱪolimizda baxⱪa pulmu elip kǝlduⱪ; ǝmma taƣarlirimizƣa pulni kimning selip ⱪoyƣanliⱪini bilmiduⱪ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","U ularƣa: — Hatirjǝm bolunglar, ⱪorⱪmanglar. Silǝrning Hudayinglar, atanglarning Hudasi taƣarliringlarda silǝrgǝ bayliⱪ ata ⱪilƣan ohxaydu; silǝrning pulunglarni alliⱪaqan tapxurup aldim, — dedi. Andin u Ximeonni ularning ⱪexiƣa elip qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","U kixi ularni Yüsüpning ɵyigǝ baxlap kirip, ularning putlirini yuyuxiƣa su ǝkirip berip, andin exǝklirigǝ yǝm bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ular Yüsüpning qüxtǝ kelixigǝ ülgürtüp sowƣatni tǝyyarlap ⱪoydi; qünki ular ɵzlirining xu yǝrdǝ ƣiza yǝydiƣinini angliƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yüsüp ɵygǝ kǝlgǝndǝ ular ⱪolliridiki sowƣatni ɵygǝ uning aldiƣa elip kirip, bexini yǝrgǝ tǝgküzüp uningƣa tǝzim ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","U ulardin ⱨal sorap, andin: — Silǝr gepini ⱪilƣan ⱪeri atanglar salamǝtmu? U ⱨayatmu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ular jawab berip: — Silining ⱪulliri bizning atimiz salamǝt turuwatidu, u tehi ⱨayattur, — dǝp uning aldida egilip tǝzim ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yüsüp bexini kɵtürüp, ɵz inisi Binyaminni kɵrüp: — Silǝr manga gepini ⱪilƣan kiqik ininglar xumu? — dǝp sorap: — Əy oƣlum, Huda sanga xapaǝt kɵrsǝtkǝy! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yüsüpning ɵz inisiƣa bolƣan seƣinix oti ⱪattiⱪ küqiyip, yiƣliwalƣudǝk haliy jay izdǝp, aldirap iqkiriki ɵygǝ kirip taza bir yiƣliwaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Andin yüzini yuyup qiⱪip, ɵzini besiwelip: — Taamlarni ⱪoyunglar, — dǝp buyrudi. ");
INSERT INTO uigpin_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Hizmǝtkarlar Yüsüpkǝ ayrim, ularƣa ayrim wǝ Yüsüp bilǝn billǝ tamaⱪⱪa kǝlgǝn misirliⱪlarƣimu ayrim tamaⱪ ⱪoydi; qünki misirliⱪlar ibraniylar bilǝn bir dastihanda tamaⱪ yeyixni yirginqlik dǝp ⱪarap, ular bilǝn billǝ tamaⱪ yemǝytti. ");
INSERT INTO uigpin_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yüsüpning ⱪerindaxliri uning udulida, ⱨǝrbiri qong-kiqik tǝrtipi boyiqǝ olturƣuzuldi; qongi qongluⱪiƣa yarixa, kiqiki kiqiklikigǝ yarixa olturƣuzuldi; ular bir-birigǝ ⱪarap ⱨǝyran ⱪelixti. ");
INSERT INTO uigpin_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yüsüp aldidiki dastihandiki tamaⱪlardin ularƣa bɵlüp bǝrdi. Əmma Binyaminƣa bǝrgini baxⱪilarningkigǝ ⱪariƣanda bǝx ⱨǝssǝ kɵp idi. Ular xarab iqip, uning bilǝn hux kǝyp ⱪilixti. ");
INSERT INTO uigpin_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Andin u ɵz ɵyini baxⱪuridiƣan ƣojidariƣa buyrup: — Bu kixilǝrning taƣarlirini elip kɵtürǝligüdǝk axliⱪ ⱪaqilap, ⱨǝrbirining pulini taƣirining aƣziƣa selip ⱪoyƣin; ");
INSERT INTO uigpin_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","andin mening jamimni, yǝni kümüx jamni axliⱪning puli bilǝn billǝ ǝng kiqikining taƣirining aƣziƣa selip ⱪoyƣin, — dedi. U adǝm Yüsüpning deginidǝk ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ətisi tang yoriƣanda, ular exǝkliri bilǝn billǝ yolƣa selip ⱪoyuldi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Lekin ular xǝⱨǝrdin qiⱪip anqǝ uzun mangmayla, Yüsüp ƣojidariƣa: — Ornungdin tur, bu adǝmlǝrning kǝynidin ⱪoƣliƣin; ularƣa yetixkiningdǝ ularƣa: «Nemixⱪa yahxiliⱪⱪa yamanliⱪ ⱪayturdunglar? ");
INSERT INTO uigpin_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hojam xu jamda xarab iqidu ⱨǝmdǝ uningda pal aqidu ǝmǝsmu?! Mundaⱪ ⱪilƣininglar rǝzillik ⱪilƣininglar bolmamdu!» degin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Bu adǝm ularning kǝynidin yetixip berip, ularƣa bu sɵzlǝrni ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ular uningƣa jawabǝn: — Hojimiz nemixⱪa mundaⱪ gǝp ⱪilidu? Mundaⱪ ixni ⱪilix kǝminiliridin neri bolsun! ");
INSERT INTO uigpin_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Biz ǝslidǝ taƣarlirimizning aƣzidin tapⱪan pulnimu Ⱪanaan zeminidin silining ⱪaxliriƣa ⱪayturup berixkǝ ǝkǝlgǝniduⱪ. Xundaⱪ turuⱪluⱪ ⱪandaⱪmu hojilirining ɵyidin altun-kümüxni oƣrilayli? ");
INSERT INTO uigpin_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kǝminiliringning arisida kimdin bu jam tepilsa, xu ɵlümgǝ mǝⱨkum bolsun, bizmu hojimizning ⱪulliri bolayli, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ƣojidar jawabǝn: — Eytⱪan sɵzliringlardǝk bolsun; jam kimning yenidin tepilsa, xu kixi ⱪulum bolup ⱪelip ⱪalsun, ⱪalƣanliringlar bigunaⱨ bolisilǝr, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Xuning bilǝn ular aldirap-tenǝp, taƣarlirini yǝrgǝ qüxürüp, ⱨǝrbiri ɵz taƣirini eqip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ƣojidar qonginingkidin baxlap kiqikiningkigiqǝ ahturdi, jam Binyaminning taƣiridin tepildi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Buni kɵrüp ular kiyimlirini yirtixip, ⱨǝrbiri exikigǝ ⱪaytidin yükni artip, xǝⱨǝrgǝ ⱪaytti. ");
INSERT INTO uigpin_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Xundaⱪ ⱪilip Yǝⱨuda wǝ ⱪerindaxliri Yüsüpning ɵyigǝ kǝldi; u tehi xu yǝrdǝ idi. Ular uning aldiƣa kelip ɵzlirini yǝrgǝ etixti. ");
INSERT INTO uigpin_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yüsüp ularƣa: — Bu silǝrning zadi nemǝ ⱪilƣininglar? Meningdǝk adǝmning qoⱪum pal aqalaydiƣanliⱪini bilmǝmtinglar? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yǝⱨuda jawabǝn: — Biz hojimizƣa nemimu deyǝlǝymiz? Nemǝ gǝp ⱪilalaymiz, ⱪandaⱪ ⱪilip ɵzimizni aⱪliyalaymiz? Huda kǝminlirining ⱪǝbiⱨlikini axkara ⱪildi. Mana, biz wǝ ⱪolidin jamliri tepilƣan kixi ⱨǝmmimiz hojimizƣa ⱪul bolidiƣan bolduⱪ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Lekin Yüsüp: — Mundaⱪ ⱪilix mǝndin neri bolsun! Bǝlki jam kimning ⱪolidin tepilƣan bolsa pǝⱪǝt xu kixi mening ⱪulum bolidu. Lekin ⱪalƣanliringlar aman-esǝn atanglarning ⱪexiƣa ketinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Andin Yǝⱨuda uningƣa yeⱪin berip mundaⱪ dedi: — Əy hojam, kǝminilirigǝ ⱪulaⱪ selip hojamning ⱪuliⱪiƣa bir eƣiz gǝp ⱪilixⱪa ijazǝt bǝrgǝyla. Ƣǝzǝpliri kǝminilirigǝ tutaxmiƣay; qünki ɵzliri Pirǝwngǝ ohxax ikǝnla. ");
INSERT INTO uigpin_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Əslidǝ hojam kǝminiliridin: «Atanglar ya ininglar barmu?» dǝp soriwidila, ");
INSERT INTO uigpin_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","biz hojimizƣa jawabǝn: «Bizning bir ⱪeri atimiz bar wǝ u ⱪeriƣanda tapⱪan, yax bir balisimu bar. Bu balining bir anisidin bolƣan akisi ɵlüp ketip, u ɵzi yalƣuz ⱪaldi; uning atisi uni intayin sɵyidu» desǝk, ");
INSERT INTO uigpin_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Sili kǝminilirigǝ: «Uning ɵzini ⱪeximƣa elip kelinglar, mǝn uni ɵz kɵzüm bilǝn kɵrǝy» dedilǝ. ");
INSERT INTO uigpin_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Biz hojimizƣa jawab berip: «Yigit atisidin ayrilalmaydu; ǝgǝr atisidin ayrilsa, atisi ɵlüp ketidu» desǝk, ");
INSERT INTO uigpin_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Sili yǝnila kǝminilirigǝ: «Əgǝr kiqik ininglar silǝr bilǝn billǝ kǝlmisǝ, yüzümni yǝnǝ kɵrimiz dǝp hiyal ⱪilmanglar» degǝnidila. ");
INSERT INTO uigpin_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Xuning bilǝn biz kǝminiliri atimizning ⱪexiƣa barƣanda hojamning sɵzlirini uningƣa eyttuⱪ; ");
INSERT INTO uigpin_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","andin atimiz yǝnǝ: «Yǝnǝ berip, bizgǝ azraⱪ axliⱪ elip kelinglar» dewidi, ");
INSERT INTO uigpin_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Biz jawabǝn: «Biz xu yǝrgǝ ⱪaytidin qüxǝlmǝymiz; ǝgǝr kiqik inimiz biz bilǝn billǝ bolsa, undaⱪta barimiz; qünki kiqik inimiz biz bilǝn billǝ bolmisa, u zatning yüzi aldida turalmaymiz», deduⱪ. ");
INSERT INTO uigpin_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Silining ⱪulliri bizning atimiz bizgǝ yǝnǝ: «Silǝrgǝ mǝlumki, ayalim manga ikki oƣul tuƣup bǝrgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Biri mening yenimdin qiⱪip, yoⱪ bolup kǝtti; mǝn: u jǝzmǝn titma-titma ⱪiliwetiliptu, dǝp oylidim, xundaⱪla uni bügüngiqǝ kɵrmidim. ");
INSERT INTO uigpin_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Əmdi silǝr bunimu mening ⱪeximdin elip ketip, uningƣa bir kelixmǝslik kelip ⱪalsa, silǝr mǝndǝk bir aⱪ qaqliⱪ adǝmni dǝrd-ǝlǝm bilǝn tǝⱨtisaraƣa qüxürüwetisilǝr», degǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Əmdi mǝn silining ⱪulliri mening atamning ⱪexiƣa barƣanda, xu bala biz bilǝn bolmisa uning jeni balining jeniƣa baƣlanƣan bolƣaqⱪa, ");
INSERT INTO uigpin_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","xundaⱪ boliduki, u balining yoⱪluⱪini kɵrsǝ, jǝzmǝn ɵlüp ketidu; xuning bilǝn silining ⱪulliri bizning atimiz bolƣan bu aⱪ qaqni dǝrd-ǝlǝm iqidǝ tǝⱨtisaraƣa qüxürüwǝtkǝn bolimiz. ");
INSERT INTO uigpin_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Qünki mǝnki kǝminiliri atamƣa bu yigit üqün kepil bolup: «Əgǝr mǝn uni ⱪexingƣa ⱪayturup kǝlmisǝm pütkül ɵmrümdǝ atamning aldida gunaⱨkar bolay» degǝnidim. ");
INSERT INTO uigpin_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Xunga ⱨazir ɵtünüp ⱪalay, mǝnki kǝminiliri u yigitning ornida hojamning ⱪexida ⱪul bolup tursam, u yigit ⱪerindaxliri bilǝn billǝ ⱪaytip kǝtsǝ! ");
INSERT INTO uigpin_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Qünki yigit mǝn bilǝn bolmisa, mǝn ⱪandaⱪmu atamning ⱪexiƣa baralaymǝn? Atamƣa xundaⱪ azab-oⱪubǝtning qüxüxini kɵzüm kɵrgüqi bolmisun! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","2","Yüsüp ɵz yenida turƣanlarning aldida ɵzini tutalmay: — Ⱨǝmmǝ adǝm aldimdin qiⱪiriwetilsun! dǝp warⱪiridi. Xuning bilǝn Yüsüp ɵzini ⱪerindaxliriƣa axkara ⱪilƣanda uning ⱪexida ⱨeqkim bolmidi. U ⱪattiⱪ yiƣlap kǝtti; misirliⱪlar uni anglidi, Pirǝwnning ordisikilǝrmu buningdin tezla hǝwǝr tapti. ");
INSERT INTO uigpin_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yüsüp ⱪerindaxliriƣa: — Mǝn Yüsüp bolimǝn! Atam ⱨazir ⱨayatmu?! — dǝp soridi. Əmma ⱪerindaxliri uningƣa ⱪarap ⱨoduⱪup ketip, ⱨeq jawab berǝlmǝy ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Lekin Yüsüp ularni: — Ⱪeni, manga yeⱪin kelinglar, dǝp qaⱪiridi. Ular yeⱪin kǝldi, u yǝnǝ: — Mǝn silǝrning ininglar, yǝni silǝr Misirƣa setiwǝtkǝn Yüsüp bolimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Əmdi meni muxu yǝrgǝ setiwǝtkininglar üqün azablanmanglar, ɵzünglarni ǝyibkǝ buyrumanglar; qünki Huda adǝmlǝrning ⱨayatini saⱪlap ⱪelix üqün meni silǝrdin burun bu yǝrgǝ ǝwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Qünki ⱨazir zemindiki aqarqiliⱪⱪa ikki yil boldi; lekin tehi yǝnǝ bǝx yilƣiqǝ ⱨeq terilƣumu bolmaydu, ormimu bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Xuning üqün silǝrgǝ dunyada bir ⱪaldini saⱪlap ⱪelix üqün, uluƣ bir nijatliⱪ kɵrsitip, silǝrning tirik ⱪutuluxunglar üqün Huda meni silǝrdin burun bu yǝrgǝ ǝwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Xundaⱪ bolƣanikǝn, meni muxu yǝrgǝ ǝwǝtküqi silǝr ǝmǝs, bǝlki Hudadur. U meni Pirǝwngǝ atining ornida ⱪilip, uning pütkül ɵyigǝ hoja ⱪilip tiklǝp, pütkül zeminƣa bax wǝzir ⱪilip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Əmdi tezdin atamning ⱪexiƣa berip, uningƣa: — Sening oƣlung Yüsüp: «Huda meni pütkül Misirƣa hoja ⱪilip ⱪoydi. Sǝn ⱨayal ⱪilmay, mening ⱪeximƣa kǝlgin; ");
INSERT INTO uigpin_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","sǝn Goxǝn yurtida turisǝn; xuning bilǝn sǝn ɵzüng, oƣulliring, nǝwriliring, ⱪoyliring, kaliliring wǝ ⱨǝmmǝ tǝǝlluⱪatliring bilǝn manga yeⱪin turisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ɵzüng, ailǝng wǝ ⱨǝmmǝ tǝǝlluⱪatingni namratliⱪ besiwalmisun dǝp mǝn seni xu yǝrdǝ baⱪimǝn; qünki yǝnǝ bǝx yil aqarqiliⱪ bardur», dedi, — dǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","— Mana silǝrning kɵzliringlar wǝ inim Binyaminning kɵzliri silǝrgǝ gǝp ⱪiliwatⱪan mening ɵz aƣzim ikǝnlikini kɵrüwatidu. ");
INSERT INTO uigpin_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Atamƣa mening Misirdiki bu barliⱪ xan-xǝripim ⱨǝmdǝ silǝrning barliⱪ kɵrgininglar toƣrisida eytip, atamni tezdin bu yǝrgǝ elip kelinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Xuning bilǝn u ɵzini Binyaminƣa etip uning boyniƣa girǝ selip yiƣlap kǝtti; Binyaminmu uning boyniƣa yɵlinip yiƣlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Andin Yüsüp barliⱪ ⱪerindxalirini sɵyüp, ularni bir-birlǝp ⱪuqaⱪlap yiƣlidi. Andin ⱪerindxaliri uning bilǝn paranglaxti. ");
INSERT INTO uigpin_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yüsüpning ⱪerindxaliri kǝldi, degǝn hǝwǝr Pirǝwnning ordisiƣa yǝtküzüldi; bu Pirǝwn wǝ hizmǝtkarlirining nǝziridǝ ⱪutluⱪ ix boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pirǝwn Yüsüpkǝ: — Ⱪerindaxliringƣa: — «Silǝr ǝmdi mundaⱪ ⱪilinglar; ulaƣliringlarƣa yük artip, Ⱪanaan zeminiƣa berip, ");
INSERT INTO uigpin_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","atanglar wǝ jǝmǝtinglarni elip mening ⱪeximƣa kelinglar; mǝn Misir zeminidin ǝng esil yǝrlǝrni silǝrgǝ berǝy; silǝr bu zemindin qiⱪⱪan nazu-nemǝtlǝrdin yǝysilǝr» — degin. ");
INSERT INTO uigpin_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Sanga bolƣan ǝmrim xuki, sǝn ularƣa: «Baliliringlar wǝ ayalliringlarni elix üqün Misir zeminidin ⱨarwilarni elip beringlar. Xuningdǝk atanglarnimu bu yǝrgǝ yǝtküzüp kelinglar. ");
INSERT INTO uigpin_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Pütkül Misir zeminidin ǝng esil jaylar silǝrningki bolƣaqⱪa, ɵz sǝrǝmjanliringlarƣa karinglar bolmisun» dǝp buyruƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Xuning bilǝn Israilning oƣulliri xundaⱪ ⱪildi; Yüsüp Pirǝwnning buyruⱪi boyiqǝ ularƣa ⱨarwilarni berip, yoli üqünmu ozuⱪ bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ularning ⱨǝrbirigǝ bir ⱪur kiyim bǝrdi; lekin Binyaminƣa bolsa u üq yüz kümüx tǝnggǝ, bǝx ⱪur kiyim bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","U atisiƣimu xu ⱨǝdiyǝlǝrni, yǝni Misirning esil mǝⱨsulatliri artilƣan on ⱨangga exǝk ⱨǝmdǝ axliⱪ, nan wǝ atisiƣa yol tǝyyarliⱪi artilƣan on mada exǝkni ǝwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Andin u ⱪerindaxlirini yolƣa selip, ularƣa: — Yolda jedǝllǝxmǝnglar, dǝp jekilidi. Ular yolƣa rawan boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ular Misirdin qiⱪip, Ⱪanaan zeminiƣa atisi Yaⱪupning ⱪexiƣa berip, ");
INSERT INTO uigpin_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","uningƣa Yüsüp ɵzlirigǝ eytⱪan gǝplǝrni yǝtküzüp: «Yüsüp tehi ⱨayat ikǝn! U pütkül Misir zeminiƣa bax wǝzir ikǝn!» dedi. Əmma u ularƣa ixǝnmǝy, yüriki ⱪetip ⱨoxidin ketǝy dǝp ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Lekin ular Yüsüpning ɵzlirigǝ eytⱪan barliⱪ sɵzlirini uningƣa degǝndǝ, xundaⱪla Yüsüpning ɵzini elip kelixkǝ ǝwǝtkǝn ⱨarwilarnimu kɵrgǝndǝ, ularning atisi Yaⱪupning roⱨiƣa jan kirdi. ");
INSERT INTO uigpin_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israil xuning bilǝn: — Əmdi arminim yoⱪ! Oƣlum Yüsüp tehi ⱨayattur! Mǝn ɵlmǝstǝ berip uni kɵrüwalay, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Xuning bilǝn Israil barliⱪ tǝǝlluⱪatini elip yolƣa qiⱪip, Bǝǝr-Xebaƣa kǝldi. U xu yǝrdǝ atisi Isⱨaⱪning Hudasiƣa ⱪurbanliⱪlarni sundi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Keqisi Huda alamǝt kɵrünüxlǝrdǝ Israilƣa: — Yaⱪup, Yaⱪup! dewidi, u jawab berip: — Mana mǝn! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","U: — Atangning Tǝngrisi bolƣan Huda Mǝndurmǝn. Sǝn Misirƣa berixtin ⱪorⱪmiƣin, qünki Mǝn seni xu yǝrdǝ uluƣ bir ⱪowm ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mǝn sening bilǝn Misirƣa billǝ barimǝn wǝ Mǝn Ɵzüm jǝzmǝn yǝnǝ seni xu yǝrdin yandurup kelimǝn. Yüsüp ɵz ⱪoli bilǝn sening kɵzüngni yumduridu, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Andin Yaⱪup Bǝǝr-Xebadin yolƣa qiⱪti; Israilning oƣulliri atisi Yaⱪup wǝ ularning bala-qaⱪilirini Pirǝwn uni epkelix üqün ǝwǝtkǝn ⱨarwilarƣa olturƣuzup, ");
INSERT INTO uigpin_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","qarpayliri bilǝn Ⱪanaan zeminida tapⱪan tǝǝlluⱪatlirini elip mangdi. Bu tǝriⱪidǝ Yaⱪup bilǝn barliⱪ ǝwladliri Misirƣa kǝldi; oƣullirini, oƣul nǝwrilirini, ⱪizlirini, ⱪiz nǝwrilirini yiƣip, nǝsillirining ⱨǝmmisini ɵzi bilǝn billǝ elip Misirƣa kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israilning oƣulliri, yǝni Yaⱪupning Misirƣa kǝlgǝn ǝwladliri tɵwǝndikiqǝ: — Yaⱪupning tunji oƣli Rubǝn; ");
INSERT INTO uigpin_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubǝnning oƣulliri Ⱨanoh, Pallu, Ⱨǝzron bilǝn Karmi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ximeonning oƣulliri: — Yǝmuǝl, Yamin, Oⱨad, Yaⱪin, Zoⱨar wǝ Ⱪanaaniy ayaldin bolƣan Saul.    ");
INSERT INTO uigpin_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lawiyning oƣulliri: — Gǝrxon, Koⱨat wǝ Mǝrari. ");
INSERT INTO uigpin_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yǝⱨudaning oƣulliri: — Ər, Onan, Xǝlaⱨ, Pǝrǝz wǝ Zǝraⱨ. Əmma Ər wǝ Onan Ⱪanaanning zeminida ɵlüp kǝtkǝnidi. Pǝrǝzning oƣulliri Ⱨǝzron bilǝn Ⱨamullar idi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issakarning oƣulliri: — Tola, Puaⱨ, Yob wǝ Ximron. ");
INSERT INTO uigpin_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zǝbulunning oƣulliri: — Sǝrǝd, Elon wǝ Jaⱨliyǝl. ");
INSERT INTO uigpin_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Bular Leyaⱨning Yaⱪupⱪa Padan-Aramda tuƣup bǝrgǝn oƣul-ǝwladliri idi; u yǝnǝ ⱪizi Dinaⱨni tuƣup bǝrdi. Buning bu oƣul-ⱪiz pǝrzǝntliri jǝmiy bolup ottuz üq jan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadning oƣulliri: — Zifion, Ⱨaggi, Xuni, Əzbon, Eri, Arodi wǝ Arǝli. ");
INSERT INTO uigpin_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Axirning oƣulliri: — Yimnaⱨ, Yixwaⱨ, Yixwi wǝ Beriyaⱨ. Ularning singlisi Seraⱨ idi; Beriyaⱨning oƣulliri Ⱨǝbǝr wǝ Malkiǝl idi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bular bolsa Laban ⱪizi Leyaⱨⱪa dedǝk boluxⱪa bǝrgǝn Zilpaⱨning Yaⱪupⱪa tuƣup bǝrgǝn oƣulliri bolup, jǝmiy on altǝ jan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaⱪupning ayali Raⱨilǝning oƣulliri Yüsüp wǝ Binyamin. ");
INSERT INTO uigpin_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yüsüpkǝ Misir zeminida tɵrǝlgǝn oƣulliri Manassǝⱨ wǝ Əfraim; bularni Ondiki kaⱨin Potifiraⱨning ⱪizi Asinat uningƣa tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Binyaminning oƣulliri: — Belaⱨ, Bǝkǝr, Axbǝl, Gera, Naaman, Eⱨi, Rox, Muppim, Ⱨuppim wǝ Ard.    ");
INSERT INTO uigpin_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bular Raⱨilǝning Yaⱪupⱪa tuƣup bǝrgǝn oƣul-ǝwladliri bolup, jǝmiy on tɵt jan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danning oƣli: — Ⱨuxim. ");
INSERT INTO uigpin_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftalining oƣulliri: — Yaⱨziǝl, Guni, Yǝzǝr wǝ Xillǝm. ");
INSERT INTO uigpin_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bular Laban ⱪizi Raⱨilǝgǝ dedǝk boluxⱪa bǝrgǝn Bilⱨaⱨning Yaⱪupⱪa tuƣup bǝrgǝn oƣul-ǝwladliri bolup, jǝmiy yǝttǝ jan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaⱪupning kelinliridin baxⱪa, Yaⱪupning puxtidin bolƣan, uning bilǝn birgǝ Misirƣa kǝlgǝnlǝr jǝmiy atmix altǝ jan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yüsüpning Misirda tuƣulƣan oƣulliri ikki idi. Yaⱪupning jǝmǝtidin bolup, Misirƣa kǝlgǝnlǝr jǝmiy yǝtmix jan idi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yaⱪup Yüsüptin kɵrsǝtmǝ elip, ɵzlirini Goxǝngǝ baxlap berixⱪa Yǝⱨudani Yüsüpning ⱪexiƣa ǝwǝtti. Xundaⱪ ⱪilip ular Goxǝn yurtiƣa kelip qüxti. ");
INSERT INTO uigpin_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yüsüp ɵzining wǝzirlik ⱨarwisini ⱪatⱪuzup, atisi Israilning aldiƣa Goxǝngǝ qiⱪti. U ɵzini uning aldiƣa ⱨazir ⱪilip atisiƣa ɵzini etip boyniƣa girǝ selip ⱪuqaⱪlap, uzundin uzun yiƣlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israil Yüsüpkǝ: Mǝn sening yüzüngni kɵrüp, tirik ikǝnlikingni bildim; ǝmdi ɵlsǝmmu arminim yoⱪ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Andin Yüsüp ⱪerindaxliri wǝ atisining ɵydikilirigǝ mundaⱪ dedi: — Mǝn ⱨazir qiⱪip Pirǝwngǝ hǝwǝr berip: «Ⱪanaan zeminida olturƣan ⱪerindaxlirim, xundaⱪla atamning ɵyidikilǝr ⱪeximƣa kǝldi; ");
INSERT INTO uigpin_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","bu adǝmlǝr padiqilar bolup, mal beⱪix bilǝn xuƣullinip kǝlgǝn, ⱪoy-kaliliri, xundaⱪla barliⱪ mal-mülüklirini elip kǝldi» dǝp eytay. ");
INSERT INTO uigpin_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Xundaⱪ boliduki, Pirǝwn silǝrni qaⱪiridu; xu qaƣda u silǝrdin: «Nemǝ oⱪitinglar bar?» dǝp sorisa, ");
INSERT INTO uigpin_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","silǝr jawab berip: — Kǝminiliri kiqikimizdin tartip ata-bowilirimizƣa ohxax pada beⱪip kǝlgǝnmiz, — dǝnglar. Xundaⱪ desǝnglar Goxǝn yurtida olturup ⱪalisilǝr; qünki padiqilarning ⱨǝmmisi misirliⱪlar arisida kɵzgǝ ilinmaydu.    ");
INSERT INTO uigpin_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yüsüp Pirǝwnning ⱪexiƣa kelip: — Atam bilǝn ⱪerindaxlirim ⱪoy-kaliliri, xundaⱪla ⱨǝmmǝ mal-mülüklirini billǝ elip Ⱪanaan zeminidin kǝldi. Mana, ular ⱨazir Goxǝn yurtiƣa qüxti, dǝp hǝwǝr berip, ");
INSERT INTO uigpin_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ⱪerindaxlirining iqidin bǝxǝylǝnni elip, Pirǝwnning aldiƣa ⱨazir ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pirǝwn uning ⱪerindaxliridin: — Nemǝ oⱪitinglar bar, dǝp soriwidi, ular Pirǝwngǝ jawab berip: — Kǝminiliri ata-bowilirimizƣa ohxax mal baⱪⱪuqilarmiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Andin ular Pirǝwngǝ iltimas ⱪilip: — Ⱪanaan zeminida ⱪattiⱪ ⱪǝⱨǝtqilik bolƣaqⱪa, kǝminilirining ⱪoylirimizni baⱪidiƣanƣa yaylaⱪmu yoⱪ; xunga bu zeminda musapir bolup turuxⱪa kǝlduⱪ; janabliridin tǝlǝp ⱪilimizki, kǝminilirining Goxǝn yurtida turuxiƣa ijazǝt bǝrgǝyla, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pirǝwn Yüsüpkǝ: — Atang wǝ ⱪerindaxliring ⱪexingƣa kǝldi; ");
INSERT INTO uigpin_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","mana Misir zemini sening aldingda turuptu; atang wǝ ⱪerindaxliringni zeminning ǝng esil yeridǝ olturƣuzƣin; ular Goxǝn yurtida makan ⱪilsun. Xuningdǝk, ǝgǝr sǝn ularning iqidiki ⱪabil kixilǝrni bilsǝng, bularni mening qarpaylirimƣa nazarǝtqi ⱪilƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Keyin, Yüsüp atisi Yaⱪupni elip, Pirǝwnning aldiƣa ⱨazir ⱪildi; Yaⱪup Pirǝwngǝ bǝht-bǝrikǝt tilidi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Andin Pirǝwn Yaⱪuptin: — Ɵmrüngning yil-künliri nǝqqigǝ yǝtti? — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaⱪup Pirǝwngǝ jawab berip: — Musapirliⱪ sǝpirimning künliri bir yüz ottuz yilƣa yǝtti; ɵmrümning künliri az ⱨǝm japa-muxǝⱪⱪǝtlik bolup, ata-bowilirimning musapirliⱪ ɵmür sǝpirining künlirigǝ tehi yǝtmidi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Xuning bilǝn Yaⱪup Pirǝwngǝ bǝht-bǝrikǝt tilǝp, aldidin qiⱪip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Xuning bilǝn Yüsüp atisi bilǝn ⱪerindaxlirini Misir zeminida olturaⱪlaxturup ⱪoydi; Pirǝwnning buyruƣinidǝk ularƣa zeminning ǝng esil yeridin, yǝni Ramsǝs degǝn yurttin tǝwǝlik bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yüsüp atisi, ⱪerindaxliri, xundaⱪla atisining ⱨǝmmǝ ɵydikilirini bala-qaⱪilirining sanliriƣa ⱪarap axliⱪ bilǝn tǝminlǝp baⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Əmma aqarqiliⱪ ⱪattiⱪ eƣir bolƣaqⱪa, zeminning ⱨeq yeridǝ ozuⱪ-tülük tepilmidi; Misir zemini bilǝn Ⱪanaan zemini aqarqiliⱪtin haraplixip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yüsüp axliⱪ setip Misir zemini bilǝn Ⱪanaan zeminidiki barliⱪ pulni yiƣiwaldi. Andin Yüsüp bu pulni Pirǝwnning ordisiƣa yǝtküzüp bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Əmma Misir zemini bilǝn Ⱪanaan zeminidiki Pul tügǝp kǝtkǝndǝ misirliⱪlarning ⱨǝmmisi Yüsüpning aldiƣa kelip: — Bizgǝ nan bǝrgǝyla! Pul tügǝp kǝtkini üqün silining aldilirida ɵlimizmu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yüsüp jawabǝn: — Pulunglar ⱪalmiƣan bolsa, qarpayliringlarni elip kelip bǝrsǝnglar, mǝn malliringlariƣa ozuⱪ-tülük tegixip berimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Buning bilǝn ular qarpaylirini Yüsüpning ⱪexiƣa elip kǝlgili turdi; Yüsüp ularning atliri, ⱪoy padiliri, kala padiliri wǝ exǝklirining orniƣa ozuⱪ-tülük bǝrdi; xu yili mallirining orniƣa ularƣa ozuⱪ-tülük berip baⱪti. ");
INSERT INTO uigpin_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","U yil ayaƣlixip, ular ikkinqi yili uning ⱪexiƣa kelip uningƣa: — Biz hojimizdin ⱨeqnemini yoxurmaymiz; pulimiz tügidi, qarpay mal padilirimiz bolsa hojimizning ilkidǝ, hojimizning aldida tǝnlirimiz bilǝn yerimizdin baxⱪa ⱨeqnǝrsǝ ⱪalmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nemixⱪa kɵz aldilirida biz ⱨǝm yerimizmu ɵlüp kǝtsun? Əmdi sili ɵzimiz wǝ yerimizni ozuⱪ-tülükkǝ tegixip eliwalƣayla; ɵzimiz wǝ yerimiz Pirǝwnning bolup, uningƣa ⱪul bolayli. Biz ɵlüp kǝtmǝy, tirik turuximiz, yerimizmu wǝyran bolmasliⱪi üqün bizgǝ uruⱪ-tülük bǝrgǝyla, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Bu tǝriⱪidǝ Yüsüp Misirning pütkül terilƣu yerini Pirǝwn üqün setiwaldi; qünki aqarqiliⱪ ⱪattiⱪ bolƣaqⱪa, misirliⱪlarning ⱨǝrbiri ɵz etizini setip bǝrdi. Xuning bilǝn yǝr-zemin Pirǝwnning bolup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yüsüp hǝlⱪni Misirning bu qetidin yǝnǝ bir qetigiqǝ ⱨǝrⱪaysi xǝⱨǝrlǝrgǝ kɵqürdi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Pǝⱪǝt kaⱨinlarning yerini u almidi; qünki kaⱨinlarƣa Pirǝwn tǝripidin alaⱨidǝ tǝminat berilgǝqkǝ, ular Pirǝwn tǝripidin tǝminlǝngǝn ülüxini yǝp, ɵz yǝrlirini satmiƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yüsüp hǝlⱪⱪǝ: — Mana, mǝn bügün ɵzünglar bilǝn yǝrliringlarni Pirǝwn üqün setiwaldim. Mana silǝrgǝ uruⱪ! Əmdi yǝr teringlar. ");
INSERT INTO uigpin_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Əmdi xundaⱪ ⱪilisilǝrki, qiⱪⱪan ⱨosuldin bǝxtin birini Pirǝwngǝ berip, ⱪalƣan tɵt ⱪismini ɵzünglarƣa elip ⱪelinglar; u uruⱪluⱪ ⱨǝmdǝ ɵzünglarƣa, jümlidin ɵyüngdikilǝrgǝ wǝ kiqik baliliringlarƣa ozuⱪ bolsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ular jawabǝn: — Sili jenimizni ⱪutⱪuzdila. Hojimizning nǝziridǝ iltipat tapⱪan bolsaⱪla, Pirǝwnning ⱪulliri bolup turayli, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Xuning bilǝn Yüsüp: — «Ⱨosulning bǝxtin biri Pirǝwngǝ berilsun» dǝp bu ixni bügüngǝ ⱪǝdǝr Misir zemini üqün ⱪanun-bǝlgilimǝ ⱪildi. Pǝⱪǝt kaⱨinlarning yerila buning sirtida bolup, Pirǝwngǝ tǝwǝ bolmidi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israillar Misir zeminida, Goxǝn ɵlkisidǝ olturaⱪlaxti; ular xu jayda yǝr-zeminlik bolup, awup, tolimu kɵpǝydi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaⱪup Misir zeminida on yǝttǝ yil ɵmür kɵrdi; buning bilǝn Yaⱪupning ɵmür künliri bir yüz ⱪiriⱪ yǝttǝ yilƣa yǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israilning künliri sǝkratⱪa yeⱪinlaxⱪanda, oƣli Yüsüpni qaⱪirtip, uningƣa: — Əgǝr nǝziringdǝ iltipat tapⱪan bolsam, ⱪolungni yotamning astiƣa ⱪoyup, manga xapaǝt wǝ sadaⱪǝtlikni kɵrsitip, meni Misirda dǝpnǝ ⱪilma; ");
INSERT INTO uigpin_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","bǝlki mǝn ata-bowilirim bilǝn yatidiƣan waⱪtimda meni Misirdin elip ketip, ularning gɵristaniƣa dǝpnǝ ⱪilƣin, dedi. U jawab berip: — Mǝn eytⱪiningdǝk ⱪilay, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yaⱪup uningƣa: — Manga ⱪǝsǝm ⱪilip bǝrgin, — dedi. U uningƣa ⱪǝsǝm ⱪilip bǝrdi; andin Israil karwatning bax tǝripidǝ sǝjdǝ ⱪildi.    ");
INSERT INTO uigpin_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bu ixlardin keyin birsi Yüsüpkǝ: — Mana atang kesǝl bolup ⱪaptu, dǝp hǝwǝr bǝrdi. U ikki oƣli Manassǝⱨ bilǝn Əfraimni billǝ elip bardi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Birsi Yaⱪupⱪa: — Mana oƣlung Yüsüp ⱪexingƣa keliwatidu, dǝp hǝwǝr beriwidi, Israil küqǝp ⱪopup kariwatta olturdi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaⱪup Yüsüpkǝ: — Ⱨǝmmigǝ Ⱪadir Tǝngri manga Ⱪanaan zeminidiki Luz degǝn jayda ayan bolup, meni bǝrikǝtlǝp ");
INSERT INTO uigpin_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","manga: Mana, Mǝn sening nǝslingni kɵpǝytip, seni intayin zor awutimǝn, sǝndin bir türküm hǝlⱪ qiⱪirimǝn; bu zeminni sǝndin keyinki nǝslinggǝ ǝbǝdiy miras ⱪilip berimǝn, dǝp eytⱪanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Əmdi mǝn Misirƣa kelixtin ilgiri sanga Misir zeminida tuƣulƣan ikki oƣlung mening ⱨesablinidu; Əfraim bilǝn Manassǝⱨ bolsa, huddi Rubǝn bilǝn Ximeonƣa ohxax, ⱨǝr ikkisi mening oƣullirim bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ulardin keyin tapⱪan baliliring ɵzüngning bolidu; ular kǝlgüsidǝ mirasⱪa erixkǝndǝ akilirining nami astida bolidu. ");
INSERT INTO uigpin_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Manga kǝlsǝk, Padandin keliwatⱪinimda Raⱨilǝ Ⱪanaan zeminida yol üstidǝ Əfratⱪa az ⱪalƣanda meni taxlap ɵlüp kǝtti. Mǝn uni xu yǝrdǝ, yǝni Əfratⱪa (yǝni Bǝyt-Lǝⱨǝmgǝ) baridiƣan yolda dǝpnǝ ⱪildim, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Andin Israil Yüsüpning oƣulliriƣa ⱪarap: — Bular kimdur, — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yüsüp atisiƣa jawabǝn: — Bular bolsa Huda manga bu yǝrdǝ bǝrgǝn oƣullirimdur, — dedi. U: — Ularni aldimƣa yeⱪin kǝltürgin, mǝn ularƣa bǝht-bǝrikǝt tilǝy, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Əmdi Israilning kɵzliri ⱪeriliⱪidin ƣuwalixip yahxi kɵrǝlmǝytti. Xunga Yüsüp ularni uning aldiƣa yeⱪinraⱪ kǝltürdi; u ularni sɵyüp ⱪuqaⱪlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Andin Israil Yüsüpkǝ: — Mǝn sening yüzüngni kɵrǝlǝymǝn dǝp ⱨeq oylimiƣanidim; lekin Huda meni sening baliliringnimu kɵrüxkǝ nesip ⱪildi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yüsüp balilarni Yaⱪupning tizlirining ariliⱪidin elip, yüzini yǝrgǝ tǝgküzüp tǝzim ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Andin Yüsüp bu ikkiylǝnni Israilning aldiƣa yeⱪin elip kelip, Əfraimni ong ⱪoli bilǝn tutup Israilning sol ⱪoliƣa udullap turƣuzdi; Manassǝⱨni sol ⱪoli bilǝn tutup Israilning ong ⱪoliƣa udullap turƣuzdi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Lekin Israil ong ⱪolini uzitip, kǝnji balisi Əfraimning bexiƣa ⱪoydi, sol ⱪolini Manassǝⱨning bexiƣa ⱪoydi. Manassǝⱨ tunjisi bolsimu, u ikki ⱪolini ⱪayqilap tutup xundaⱪ ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","U Yüsüpkǝ bǝht-bǝrikǝt tilǝp: — Atilirim Ibraⱨim bilǝn Isⱨaⱪ Huda dǝp bilip yüzi aldida mangƣan, meni pütkül ɵmrümdǝ bu küngiqǝ padiqidǝk yetǝklǝp beⱪip kǝlgǝn Huda, ");
INSERT INTO uigpin_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Manga ⱨǝmjǝmǝt bolup meni ⱨǝmmǝ bala-ⱪazadin ⱪutⱪuzƣan Pǝrixtǝ bu ikki oƣulni bǝrikǝtlisun; ular mening ismim wǝ atilirim bolƣan Ibraⱨim wǝ Isⱨaⱪning isimliri bilǝn atilip, yǝr yüzidǝ kɵp awuƣay! — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yüsüp atisining ong ⱪolini Əfraimning bexiƣa ⱪoyƣinini kɵrüp kɵnglidǝ hapa boldi; xunga u atisining ⱪolini tutup, Əfraimning bexidin elip Manassǝⱨning bexiƣa yɵtkimǝkqi bolup, ");
INSERT INTO uigpin_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","atisiƣa: — Əy ata, bundaⱪ ⱪilmiƣin; qünki mana, tunjisi budur; ong ⱪolungni uning bexiƣa ⱪoyƣin! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Lekin atisi rǝt ⱪilip: — Bilimǝn, i oƣlum, bilimǝn; uningdinmu bir ⱪowm qiⱪip, ɵzimu uluƣ bolidu, ǝmma dǝrⱨǝⱪiⱪǝt uning inisi uningdin tehimu uluƣ bolidu; uning nǝslidin naⱨayiti kɵp ⱪowmlar pǝyda bolidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Xuning bilǝn xu küni u bu ikkisini bǝrikǝtlǝp: — Kǝlgüsidǝ Israillar bǝht-bǝrikǝt tiligǝndǝ: «Huda seni Əfraim bilǝn Manassǝⱨdǝk uluƣ ⱪilsun!» dǝydiƣan bolidu, dedi. Bu tǝriⱪidǝ u Əfraimni Manassǝⱨtin üstün ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Andin Israil Yüsüpkǝ yǝnǝ: — Mana, mǝn ɵlimǝn; lekin Huda silǝr bilǝn billǝ bolup, silǝrni ata-bowiliringlarning zeminiƣa ⱪayturup baridu. ");
INSERT INTO uigpin_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mǝn sanga ⱪerindaxliringningkidin bir ülüx yǝrni artuⱪ bǝrdim; xu yǝrni ɵzüm ⱪiliq wǝ oⱪyayim bilǝn Amoriylarning ⱪolidin tartiwalƣanidim.    ");
INSERT INTO uigpin_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Andin Yaⱪup oƣullirini qaⱪirip ularƣa mundaⱪ dedi: — Ⱨǝmminglar jǝm bolunglar, mǝn silǝrgǝ keyinki künlǝrdǝ silǝr yoluⱪidiƣan ixlarni eytip berǝy: — ");
INSERT INTO uigpin_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yiƣilip kelip anglanglar, i Yaⱪupning oƣulliri; Atanglar Israilƣa ⱪulaⱪ selinglar. ");
INSERT INTO uigpin_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Əy Rubǝn, sǝn mening tunji oƣlumsǝn, Küq-ⱪudritimsǝn, Küqüm bar waⱪtimning tunji mewisidursǝn, Salapǝt wǝ ⱪudrǝttǝ aldi iding, ");
INSERT INTO uigpin_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Lekin ⱪaynap texip qüxkǝn sudǝk, Əmdi aldi bolalmassǝn; Qünki sǝn atangning kɵrpisigǝ qiⱪting, Xuning bilǝn sǝn uni bulƣiding! U mening kɵrpǝmning üstigǝ qiⱪti!    ");
INSERT INTO uigpin_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Ximeon bilǝn Lawiy ⱪerindaxlardur; Ularning ⱪiliqliri zorawanliⱪning ⱪoralliridur! ");
INSERT INTO uigpin_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Aⱨ jenim, ularning mǝsliⱨitigǝ kirmigin! I izzitim, ularning jamaiti bilǝn qetilip ⱪalmiƣay! Qünki ular aqqiⱪida adǝmlǝrni ɵltürüp, Ɵz beximqiliⱪ ⱪilip buⱪilarning peyini kǝsti. ");
INSERT INTO uigpin_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ularning aqqiⱪi ǝxǝddiy bolƣaqⱪa lǝnǝtkǝ ⱪalsun! Ƣǝzipimu rǝⱨimsiz bolƣaqⱪa lǝnǝtkǝ ⱪalsun! Mǝn ularni Yaⱪupning iqidǝ tarⱪitiwetimǝn, Israilning iqidǝ ularni qeqiwetimǝn.    ");
INSERT INTO uigpin_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Əy Yǝⱨuda! Seni bolsa ⱪerindaxliring tǝriplǝr, Ⱪolung düxmǝnliringning gǝjgisini basar. Atangning oƣulliri sanga bax urar, ");
INSERT INTO uigpin_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yǝⱨuda yax bir xirdur; Əy oƣlum, sǝn owni tutupla qiⱪting; U xirdǝk owning yenida qɵküp sozulup yatsa, Yaki qixi xirdǝk yetiwalsa, Kimmu uni ⱪozƣaxⱪa petinar?    ");
INSERT INTO uigpin_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Xaⱨanǝ ⱨasa Yǝⱨudadin ketip ⱪalmaydu, Yǝⱨudaning puxtidin ⱪanun qiⱪarƣuqi ɵksümǝydu, Taki xu ⱨoⱪuⱪ Igisi kǝlgüqǝ kütidu; Kǝlgǝndǝ, jaⱨan hǝlⱪliri uningƣa itaǝt ⱪilidu.    ");
INSERT INTO uigpin_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","U tǝhiyini üzüm teliƣa, Exǝk balisini sortluⱪ üzüm teliƣa baƣlap ⱪoyar. U libasini xarabta yuyup, Tonini üzüm xǝrbitidǝ yuyar. ");
INSERT INTO uigpin_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Uning kɵzliri xarabtin ⱪizirip ketǝr, Qixliri süt iqkinidin ap’aⱪ turar. ");
INSERT INTO uigpin_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zǝbulun dengiz boyini makan ⱪilar, Makani kemilǝrning panaⱨgaⱨi bolar, Yǝr-zemini Zidonƣiqǝ yetip barar. ");
INSERT INTO uigpin_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar bǝstlik bǝrdǝm bir exǝktur, U ikki ⱪotan arisida yatⱪandur; ");
INSERT INTO uigpin_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","U aramgaⱨning yahxi ikǝnlikigǝ ⱪarap, Zeminning esilliⱪini kɵrüp, Yük kɵtürüxkǝ mürisini egip, Alwanƣa ixlǝydiƣan ⱪul bolup ⱪalar. ");
INSERT INTO uigpin_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan Israil ⱪǝbililiridin biri bolar, Ɵz hǝlⱪigǝ ⱨɵküm qiⱪirar. ");
INSERT INTO uigpin_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan yol üstidiki yilan, Qiƣir yol üstidǝ turƣan zǝⱨǝrlik bir yilandur. U atning tuyiⱪini qeⱪip, At mingüqini arⱪiƣa mollaⱪ atⱪuzar. ");
INSERT INTO uigpin_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I Pǝrwǝrdigar, nijatingƣa tǝlmürüp kütüp kǝldim! ");
INSERT INTO uigpin_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadⱪa bolsa, ⱪaraⱪqilar ⱪoxuni ⱨujum ⱪilar; Lekin u tapinini besip zǝrbǝ berǝr. ");
INSERT INTO uigpin_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Axirning tamiⱪida zǝytun meyi mol bolar, U xaⱨlar üqün nazu-nemǝtlǝrni tǝminlǝr. ");
INSERT INTO uigpin_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftalidin qirayliⱪ gǝplǝr qiⱪar, U ǝrkin ⱪoyuwetilgǝn maraldur. ");
INSERT INTO uigpin_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yüsüp mewilik dǝrǝhning xehidur, Bulaⱪning yenidiki kɵp mewilik xahtǝktur; Uning xahqiliri tamdin ⱨalⱪip kǝtkǝndur.    ");
INSERT INTO uigpin_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ya atⱪuqilar uningƣa azar ⱪilip, Uningƣa oⱪ atti, uningƣa nǝprǝtlǝndi. ");
INSERT INTO uigpin_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ⱨalbuki, uning oⱪyayi mǝzmut turar, Ⱪol-bilǝkliri ǝplik turƣuzular, Xu küq Yaⱪuptiki ⱪudrǝt Igisining ⱪolliridindur — (Israilning Ⱪoram Texi, yǝni uning Padiqisi Uningdin qiⱪar!) ");
INSERT INTO uigpin_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Axu küq atangning Tǝngrisidindur — (U sanga mǝdǝt berǝr!) Yǝni Ⱨǝmmigǝ Ⱪadirdindur — U seni bǝrikǝtlǝr! Yuⱪirida asmanning bǝrikǝtliri bilǝn, Tɵwǝndǝ yatⱪan qongⱪur sularning bǝrikǝtliri bilǝn, Əmqǝk bilǝn baliyatⱪuning bǝrikiti bilǝn seni bǝrikǝtlǝr! ");
INSERT INTO uigpin_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Sening atangning tiligǝn bǝrikǝtliri ata-bowilirimning tiligǝn bǝrikǝtliridin ziyadǝ boldi, Ular mǝnggülük taƣ-edirlarning qǝtlirigiqǝ yetǝr, Ular Yüsüpning bexiƣa qüxǝr, Yǝni ɵz ⱪerindaxliridin ayrim turƣuqining qoⱪⱪisiƣa tegǝr.    ");
INSERT INTO uigpin_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Binyamin yirtⱪuq bɵridǝktur; Ətigǝndǝ u owni yǝr. Kǝqⱪurun u oljisini tǝⱪsim ⱪilar» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Bularning ⱨǝmmisi Israilning on ikki ⱪǝbilisi bolup, mǝzkur sɵzlǝr bolsa atisining ularƣa tiligǝn bǝht-bǝrikǝt sɵzliridur. U xuning bilǝn ularning ⱨǝrbirigǝ mas kelidiƣan bir bǝrikǝt bilǝn ularƣa bǝht-bǝrikǝt tilidi. ");
INSERT INTO uigpin_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Andin Yaⱪup ularƣa mundaⱪ tapilidi: — «Mǝn ǝmdi ɵz ⱪowmimning ⱪexiƣa ⱪoxulimǝn. Silǝr meni ata-bowilirimning yenida, Ⱨittiylardin bolƣan Əfronning etizliⱪidiki ƣarƣa dǝpnǝ ⱪilinglar; ");
INSERT INTO uigpin_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","u ƣar bolsa Ⱪanaan zeminida Mamrǝning udulida, Makpelaⱨning etizliⱪida. Ƣarni Ibraⱨim gɵristan bolsun dǝp xu etizliⱪ bilǝn ⱪoxup Ⱨittiy Əfrondin setiwalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Xu yǝrdǝ Ibraⱨim ayali Saraⱨ bilǝn dǝpnǝ ⱪilinƣan; xu yǝrdǝ Isⱨaⱪ ayali Riwkaⱨ bilǝnmu dǝpnǝ ⱪilinƣan; xu yǝrdǝ mǝnmu Leyaⱨni dǝpnǝ ⱪildim. ");
INSERT INTO uigpin_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Bu etizliⱪ ⱨǝm iqidiki ƣar Ⱨǝtning ǝwladliridin setiwelinƣanidi». ");
INSERT INTO uigpin_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaⱪup oƣulliriƣa bu wǝsiyǝtni tapilap bolup, putlirini kariwatta tüzlǝp, nǝpǝs tohtap ɵz ⱪowmiƣa ⱪoxuldi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yüsüp atisining yüzigǝ ɵzini etip, uning üstidǝ yiƣlap, uni sɵydi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Andin Yüsüp ɵz hizmitidǝ bolƣan tewiplarƣa atisini mumiya ⱪilixni buyrudi; xuning bilǝn tewiplar Israilni mumiya ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Buni ⱪilixⱪa ⱪiriⱪ kün kǝtti, qünki mumiya ⱪilixⱪa xunqilik kün ketǝtti. Misirliⱪlar uningƣa yǝtmix kün matǝm tutti. ");
INSERT INTO uigpin_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Uningƣa ⱨaza tutux künliri ɵtüp bolƣanda, Yüsüp Pirǝwnning ordisidikilǝrgǝ: — Mǝn nǝziringlarda iltipat tapⱪan bolsam, Pirǝwnning ⱪulaⱪliriƣa sɵz ⱪilinglarki: — Atam manga ⱪǝsǝm ⱪildurup: «Mana mǝn ɵlimǝn; sǝn meni mǝn Ⱪanaan zeminida ɵzüm üqün kolap ⱪoyƣan gɵrgǝ dǝpnǝ ⱪilƣin» degǝnidi. Əmdi Pirǝwn manga ijazǝt bǝrgǝy, mǝn berip atamni dǝpnǝ ⱪilip bolup yenip kǝlsǝm, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pirǝwn jawabǝn: — Sǝn berip ɵzünggǝ atang ⱪǝsǝm ⱪildurƣandǝk uni dǝpnǝ ⱪilƣin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Xuning bilǝn Yüsüp atisini dǝpnǝ ⱪilƣili mangdi. Pirǝwnning barliⱪ hizmǝtkarliri, ordining aⱪsaⱪalliri ⱨǝm Misir zeminidiki aⱪsaⱪallar uning bilǝn ⱨǝmraⱨ bolup mangdi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yüsüpning ɵyidiki ⱨǝmmisi, ⱪerindaxliri wǝ atisining ɵyidikilǝrmu billǝ bardi; ular pǝⱪǝt kiqik baliliri, ⱪoy-kala padilirini Goxǝn yurtida ⱪoyup kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Uning bilǝn yǝnǝ jǝng ⱨarwiliri wǝ atliⱪlarmu billǝ bardi; xuning bilǝn ular naⱨayiti qong bir ⱪoxun boldi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ular Iordan dǝryasining u tǝripidiki «Atadning hamini»ƣa yetip kǝlgǝndǝ, xu yǝrdǝ ⱪattiⱪ wǝ ⱨǝsrǝtlik yiƣa-zar ⱪilip matǝm tutup yiƣlaxti. Yüsüp atisi üqün yǝttǝ kün matǝm tutti. ");
INSERT INTO uigpin_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Xu yurtta olturuxluⱪ Ⱪanaaniylar Atadning haminida bolƣan bu matǝmni kɵrüp: — Bu misirliⱪlarning intayin ⱪattiⱪ tutⱪan ⱨazisi boldi, deyixti. Bu sǝwǝbtin u jayning nami «Abǝl-Mizraim» dǝp ataldi; u Iordan dǝryasining u tǝripididur. ");
INSERT INTO uigpin_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaⱪupning oƣulliri uning ɵzlirigǝ tapiliƣinidǝk ⱪildi; ");
INSERT INTO uigpin_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","uning oƣulliri uni Ⱪanaan zeminiƣa elip berip, Mamrǝning udulida, Makpelaⱨning etizliⱪining iqidiki ƣarda dǝpnǝ ⱪildi. Xu ƣarni Ibraⱨim ⱪǝbristanliⱪ ⱪilay dǝp Makpelaⱨning etizliⱪi bilǝn ⱪoxup Ⱨittiy Əfrondin setiwalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yüsüp atisini dǝpnǝ ⱪilƣandin keyin, ɵzi, ⱪerindaxliri, xundaⱪla atisini dǝpnǝ ⱪilixⱪa uningƣa ⱨǝmraⱨ bolup qiⱪⱪan ⱨǝmmǝ hǝlⱪlǝr Misirƣa yenip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Lekin Yüsüpning ⱪerindaxliri atisining ɵlüp kǝtkinini kɵrgǝndǝ: — Əmdi Yüsüp bizgǝ düxmǝn bolup bizning uningƣa ⱪilƣan barliⱪ yamanliⱪimizni üstimizgǝ yandurarmikin, deyixti. ");
INSERT INTO uigpin_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ular Yüsüpning ⱪexiƣa adǝm ǝwǝtip: — Atiliri ɵlüxtin ilgiri bizgǝ wǝsiyǝt ⱪilip tapilap: — ");
INSERT INTO uigpin_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Silǝr Yüsüpkǝ: — Akiliring sanga rǝzillik ⱪilƣanidi; ǝmdi ularning asiyliⱪi ⱨǝm gunaⱨini kǝqürgin! — dǝnglar» — degǝnidi. Ⱨazir silidin ɵtünümizki, atilirining Hudasining bǝndilirining asiyliⱪini kǝqürgǝyla! — dedi. Yüsüp bu gǝplǝrni anglap yiƣlidi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Andin akiliri kelip uning aldida ɵzlirini yǝrgǝ etip: — Mana, biz silining ⱪulliridurmiz! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Lekin Yüsüp ularƣa jawabǝn: — Ⱪorⱪmanglar! Mǝn Hudaning ornida turuwatamdim? ");
INSERT INTO uigpin_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Silǝr dǝrwǝⱪǝ manga xu ixni yaman niyǝt bilǝn ⱪildinglar; lekin Huda bügünki kündikidǝk nurƣunliƣan hǝlⱪning jenini tirik saⱪlap ⱪelix üqün xu ixni yahxiliⱪⱪa bekitkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Xunga ǝmdi ⱪorⱪmanglar; mǝn ⱨǝm silǝrni ⱨǝm bala-qaⱪiliringlarni baⱪimǝn, — dedi wǝ ularning kɵnglini hatirjǝm ⱪilip meⱨirlik gǝp ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yüsüp atisining jǝmǝti bilǝn billǝ Misirda turup ⱪaldi. Yüsüp bir yüz on yil ɵmür kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Bu tǝriⱪidǝ Yüsüp Əfraimning üqinqi ǝwladini kɵrdi; Manassǝⱨning oƣli Makirning balilirimu uning tizliri üstidǝ tuƣuldi.    ");
INSERT INTO uigpin_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yüsüp ⱪerindaxliriƣa: — Mǝn ɵlüp ketimǝn; lekin Huda qoⱪum silǝrni yoⱪlap silǝrni bu zemindin qiⱪirip, Ibraⱨim, Isⱨaⱪ wǝ Yaⱪupⱪa berixkǝ ⱪǝsǝm ⱪilip wǝdǝ ⱪilƣan zeminƣa yǝtküzidu, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Andin Yüsüp yǝnǝ ⱪerindaxliriƣa ⱪǝsǝm iqküzüp: «Huda silǝrni qoⱪum yoⱪlaydu; xu qaƣda silǝr mening sɵngǝklirimni elip, bu yǝrdin qiⱪip ketixinglar kerǝk», — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yüsüp bir yüz on yaxⱪa kirgǝndǝ wapat tapti. Ular uni mumiya ⱪilip, Misirda bir meyit sanduⱪiƣa selip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Wǝ tɵwǝndikilǝr Israil bilǝn billǝ Misirƣa barƣan oƣullirining isimliri (ular ⱨǝrⱪaysisi ɵz bala-qaⱪilirini elip, Yaⱪup bilǝn billǝ Misirƣa barƣanidi): —    ");
INSERT INTO uigpin_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubǝn, Ximeon, Lawiy, Yǝⱨuda, ");
INSERT INTO uigpin_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zǝbulun, Binyamin, ");
INSERT INTO uigpin_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad wǝ Axir. ");
INSERT INTO uigpin_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Əmdi Yaⱪupning puxtidin bolƣanlar jǝmiy bolup yǝtmix adǝm idi. Bu waⱪitta Yüsüp Misirda idi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Keyin Yüsüp, uning barliⱪ ⱪerindaxliri ⱨǝmdǝ barliⱪ zamandaxliri ɵlüp tügidi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Xundaⱪtimu, Israillar kɵp tuƣulup, tez awup, intayin küqǝydi; ular zeminƣa bir kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","U waⱪitlarda Yüsüpni bilmǝydiƣan yengi bir padixaⱨ Misirda tǝhtkǝ qiⱪti.    ");
INSERT INTO uigpin_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","U hǝlⱪigǝ: Mana, Israillarning hǝlⱪi bizdin ziyadǝ awup ⱨǝmdǝ bizdinmu küqlinip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Əmdi biz ularƣa nisbǝtǝn aⱪilanǝ ix tutayli; bolmisa, ular tehimu awup ketidu, mubada urux partlap ⱪalsa, xundaⱪ boliduki, ular düxmǝnlirimiz tǝrǝpkǝ ɵtüp, bizgǝ ⱨujum ⱪilip, yurttin qiⱪip ketixi mumkin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Xuning bilǝn ular ularni ⱪiliwatⱪan ǝmgǝklǝrdǝ harlax üqün ix baxlirini tǝyinlǝp nazarǝtqilikkǝ ⱪoydi. Xuning bilǝn Israillar Pirǝwn üqün Pitom bilǝn Raamsǝs degǝn maddiy ǝxya saⱪlaydiƣan xǝⱨǝrlǝrni yasap bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Lekin ularni ⱪanqǝ ǝzgǝnseri, bular xunqǝ kɵpiyip ⱨǝmmǝ yǝrni ⱪaplidi; buning bilǝn misirliⱪlar Israillarƣa ɵq bolup kǝtti.    ");
INSERT INTO uigpin_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Xuning bilǝn misirliⱪlar Israillarƣa zulum ⱪilip, ularni tehimu ⱪattiⱪ ixlitip eƣir ixlarƣa saldi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Misirliⱪlar ularni layqiliⱪ, hix-kesǝk ⱪuyux wǝ etizlarning ⱨǝrhil ǝmgǝklirigǝ selip, ixning ⱪattiⱪliⱪi bilǝn ularning turmuxiƣa ⱪattiⱪ eƣirqiliⱪ saldi; ularni nemǝ ǝmgǝkkǝ salmisun, intayin japaliⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misir padixaⱨi ikki ibraniy tuƣut anisiƣa sɵz ⱪilip (ularning birining ismi Xifraⱨ, yǝnǝ birining ismi Puaⱨ idi): ");
INSERT INTO uigpin_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","— silǝr ⱪaqanliki ibraniy hotunlarni tuƣdursanglar, tuƣⱪanda obdan ⱪaranglar; bowaⱪ oƣul bolsa, ɵltürüwetinglar; ⱪiz bolsa, tirik ⱪoyunglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lekin tuƣut aniliri Hudadin ⱪorⱪup, Misirning padixaⱨi ularƣa eytⱪandǝk ⱪilmay, bǝlki oƣul bowaⱪlarni tirik ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Xunga Misirning padixaⱨi tuƣut anilirini qaⱪirtip ulardin: — Bu nemǝ ⱪilƣininglar?! Oƣul balilarni nemixⱪa tirik ⱪoydunglar? — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tuƣut aniliri Pirǝwngǝ jawab berip: — Ibraniy ayallar misirliⱪ ayallarƣa ohximaydu. Ular küqlük, saƣlam-timǝn bolƣini üqün tuƣut aniliri ularning ⱪexiƣa yetip barƣuqǝ, ɵzliri tuƣup bolidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nǝtijidǝ, Huda tuƣut aniliriƣa iltipat kɵrsǝtti; Israil hǝlⱪi dawamliⱪ kɵpiyip, tehimu küqǝydi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Xundaⱪ boldiki, tuƣut aniliri Hudadin ⱪorⱪidiƣan ihlasmǝn bolƣanliⱪi üqün Huda ularni aililik boluxⱪa muyǝssǝr ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Buning bilǝn Pirǝwn barliⱪ puⱪraliriƣa: — Israillardin yengi tuƣulƣan oƣul balilarning ⱨǝmmisini dǝryaƣa taxlanglar, lekin ⱪiz balilarning ⱨǝmmisini tirik ⱪaldurunglar, dǝp ǝmr ⱪildi.      ");
INSERT INTO uigpin_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Lawiyning jǝmǝtidin bolƣan bir kixi berip, Lawiyning nǝslidin bolƣan bir ⱪizni hotunluⱪⱪa aldi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Bu ayal ⱨamilidar bolup, bir oƣul tuƣdi. Ana uning qirayliⱪ ikǝnlikini kɵrüp, uni üq ay yoxurup saⱪlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Uni yǝnǝ yoxuruxⱪa amalsiz ⱪalƣanda, ⱪomuxtin bir sewǝt yasap, uningƣa yaryelim wǝ mom suwap, balini iqigǝ selip, dǝryaning ⱪirƣiⱪidiki ⱪomuxluⱪ arisiƣa ⱪoyup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Andin balining ⱨǝdisi uningƣa nemǝ bolarkin dǝp yiraⱪtin ⱪarap turdi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","U waⱪitta Pirǝwnning ⱪizi suƣa qɵmülgili dǝrya tǝrǝpkǝ kǝldi; uning qɵriliri dǝrya boyida aylinip yürdi. Pirǝwnning ⱪizi ⱪomuxluⱪning arisida turƣan sewǝtni kɵrüp, has qɵrisini uni elip qiⱪixⱪa ǝwǝtti.    ");
INSERT INTO uigpin_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","U sewǝtni eqip ⱪariwidi, mana, bir oƣul balini kɵrdi wǝ u bala yiƣlap kǝtti. Mǝlikǝ uningƣa iq aƣritip: — Bu xübⱨisizki ibraniylarning baliliridin biri ikǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","U qaƣda balining ⱨǝdisi Pirǝwnning ⱪizidin: — Mǝn berip, sili üqün balini emitip baⱪidiƣan bir ibraniy inik ana tepip kelǝymu? — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Pirǝwnning ⱪizi uningƣa: — Barƣin, dedi. Ⱪiz berip bowaⱪning anisini qaⱪirip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pirǝwnning ⱪizi uningƣa: — Bu balini elip ketip mǝn üqün emitip beⱪip bǝr; ⱨǝⱪⱪingni berimǝn, dedi. Xuning bilǝn ayal balini elip ketip, uni emitip baⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Bala qong bolƣanda uni Pirǝwnning ⱪizining ⱪexiƣa elip bardi; u uningƣa oƣul boldi. U: «Mǝn uni sudin qiⱪiriwalƣan» dǝp uningƣa Musa degǝn isimni ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Musa qong bolƣandin keyinki künlǝrdǝ xundaⱪ boldiki, u ɵz ⱪerindaxlirining yeniƣa bardi wǝ ularning eƣir ǝmgǝkkǝ seliniwatⱪanliⱪini ɵz kɵzi bilǝn kɵrdi. Arida, bir misirliⱪning ibraniy ⱪerindaxliridin birini uruwatⱪanliⱪini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","U tɵt ǝtrapiƣa ⱪarap, adǝm yoⱪluⱪini kɵrüp, ⱨeliⱪi misirliⱪni urup ɵltürüp, ⱪumƣa kɵmüp yoxurup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ətisi u yǝnǝ qiⱪip ⱪariwidi, mana ikki ibraniy bir-biri bilǝn soⱪuxuwatatti; u yolsizliⱪ ⱪiliwatⱪan kixigǝ: — Ɵz ⱪerindixingni nemixⱪa urisǝn? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ⱨeliⱪi kixi jawab berip: — Kim seni bizgǝ ⱨakim wǝ soraⱪqi ⱪilip ⱪoydi? Ⱨeliⱪi misirliⱪni ɵltürginingdǝk menimu ɵltürmǝkqimusǝn? — dedi. Musa bu gǝpni anglap ⱪorⱪup ɵz iqidǝ: «Mǝn ⱪilƣan ix jǝzmǝn axkara bolup ⱪaptu!» dǝp oylidi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pirǝwn ⱨǝm bu ixtin hǝwǝr tepip, Musani ɵltürmǝkqi boldi; lekin Musa Pirǝwnning aldidin ⱪeqip, Midiyan zeminiƣa berip olturaⱪlaxti. Bir küni, u ⱪuduⱪning yeniƣa kelip olturdi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midiyanning kaⱨinining yǝttǝ ⱪizi bar idi; ular kelip, atisining ⱪoylirini suƣirixⱪa su tartip oⱪurlarƣa ⱪuyup tolduruxⱪa baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","U waⱪitta yǝrlik padiqilar kelip, ularni ⱨǝydidi, Musa ⱪopup ⱪizlarƣa yardǝm berip, ⱪoylirini suƣirixip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ular atisi Reuǝlning ⱪexiƣa yenip kǝlgǝndǝ, ulardin: — Nemixⱪa bügün xunqǝ tez yenip kǝldinglar? — dǝp soridi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ular jawab berip: — Bir misirliⱪ adǝm bizni padiqilarning ⱪolidin ⱪutⱪuzdi ⱨǝmdǝ biz üqün su tartip, ⱪoy padimizni suƣiripmu bǝrdi! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","U ⱪizliriƣa: — Undaⱪta u kixi ⱨazir nǝdǝ?! Uni nemixⱪa sirtta taxlap kǝldinglar? Uni tamaⱪⱪa qaⱪiringlar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa u kixi bilǝn billǝ turuxⱪa maⱪul boldi. U ⱪizi Zipporaⱨni uningƣa hotunluⱪⱪa bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","U ayal uningƣa bir oƣul tuƣup bǝrdi; Musa «Mǝn yaⱪa yurtta musapirdurmǝn» dǝp, uning ismini Gǝrxom dǝp ⱪoydi.    ");
INSERT INTO uigpin_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Nurƣun künlǝr ɵtüp, Misirning padixaⱨi ɵldi. Israillar ɵz ⱪulluⱪ ⱨaliti tüpǝylidin aⱨ-zar urup, nalǝ-pǝryad kɵtürdi; ⱪulluⱪtin bolƣan pǝryadi Hudaning ⱨuzuriƣa berip yǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Huda ularning aⱨ-zarlirini anglap, Ɵzining Ibraⱨim bilǝn, Isⱨaⱪ bilǝn wǝ Yaⱪup bilǝn tüzgǝn ǝⱨdisini esigǝ aldi. ");
INSERT INTO uigpin_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Xuning bilǝn Huda Israillarning ⱨal-ǝⱨwalini kɵrdi wǝ Huda ularƣa kɵngül bɵldi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa bolsa ⱪeynatisi Midiyanning kaⱨini Yǝtroning ⱪoy padisini baⱪatti. U ⱪoylarni baxlap qɵlning ǝng qetigǝ Hudaning teƣi, yǝni Ⱨorǝb teƣining baƣriƣa kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Xu yǝrdǝ bir azƣanliⱪtin ɵrlǝp qiⱪiwatⱪan ot yalⱪuni iqidin Pǝrwǝrdigarning Pǝrixtisi uningƣa kɵründi. Mana, azƣanliⱪ otta kɵyüwatⱪan bolsimu, lekin azƣan ɵzi kɵyüp kǝtmigǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa: — Mǝn berip, bu ajayip mǝnzirini kɵrüp baⱪay; azƣanliⱪ nemixⱪa kɵyüp kǝtmǝydiƣandu? — dǝp oylidi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Pǝrwǝrdigar uning buni kɵrgili yoldin qǝtnǝp azƣanliⱪⱪa kǝlginini kɵrdi; Huda azƣanliⱪ iqidin uni: — Musa! Musa! — dǝp qaⱪirdi. U: Mana mǝn! — dǝp jawab bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","U uningƣa: — Bu yǝrgǝ yeⱪin kǝlmǝ; putliringdin kǝxingni salƣin; qünki sǝn turƣan bu yǝr muⱪǝddǝs jaydur.    ");
INSERT INTO uigpin_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Mǝn atangning Hudasi, Ibraⱨimning Hudasi, Isⱨaⱪning Hudasi wǝ Yaⱪupning Hudasidurmǝn, — dedi. Buni anglap Musa Hudaƣa ⱪaraxtin ⱪorⱪup, yüzini etiwaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Pǝrwǝrdigar uningƣa mundaⱪ dedi: — Bǝrⱨǝⱪ, Mǝn Misirda turuwatⱪan ⱪowmimning tartiwatⱪan azab-oⱪubǝtlirini kɵrdum, nazarǝtqilǝrning ularni harlawatⱪanliⱪidin ⱪilƣan pǝryadini anglidim; qünki Mǝn ularning dǝrdlirini bilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Xunga Mǝn ularni misirliⱪlarning ⱪolidin ⱪutⱪuzup, xu zemindin qiⱪirip, yahxi ⱨǝm kǝng bir zeminƣa, süt bilǝn ⱨǝsǝl eⱪip turidiƣan bir zeminƣa, yǝni Ⱪanaaniy, Ⱨittiy, Amoriy, Pǝrizziy, Ⱨiwiylar wǝ Yǝbusiylarning yurtiƣa elip berixⱪa qüxtüm. ");
INSERT INTO uigpin_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Mana ǝmdi Israillarning nalǝ-pǝryadi Manga yǝtti, misirliⱪlarning ularƣa ⱪandaⱪ zulum ⱪilƣanliⱪinimu kɵrdüm. ");
INSERT INTO uigpin_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Əmdi sǝn kǝl, Mǝn seni hǝlⱪim Israillarni Misirdin elip qiⱪirix üqün Pirǝwnning aldiƣa ǝwǝtimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Lekin Musa Hudaƣa: — Mǝn kim idim, Pirǝwnning aldiƣa berip Israillarni Misirdin qiⱪiraliƣudǝk? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","U jawab berip: — Bǝrⱨǝⱪ, Mǝn sǝn bilǝn billǝ bolimǝn; sǝn ⱪowmni Misirdin elip qiⱪⱪandin keyin bu taƣda Hudaƣa ibadǝt ⱪilisilǝr; bu ix mana ɵzünggǝ Mening seni ǝwǝtkinimning ispat-bǝlgisi bolidu, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Xuning bilǝn Musa Hudaƣa: — Mǝn Israillarning ⱪexiƣa berip ularƣa: «Ata-bowiliringlarning Hudasi meni ⱪexinglarƣa ǝwǝtti» desǝm, ular mǝndin: «Uning nami nemǝ?» — dǝp sorisa, ularƣa nemǝ dǝp jawab berimǝn? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Huda Musaƣa: — Mǝn «Əzǝldin bar Bolƣuqi»durmǝn — dedi. Andin U: — Berip, Israillarƣa: ««Əzǝldin bar Bolƣuqi» meni ⱪexinglarƣa ǝwǝtti» dǝp eytⱪin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Huda Musaƣa yǝnǝ: — Israillarƣa: — «Ata-bowiliringlarning Hudasi, Ibraⱨimning Hudasi, Isⱨaⱪning Hudasi wǝ Yaⱪupning Hudasi bolƣan «Yaⱨwǝⱨ» meni ⱪexinglarƣa ǝwǝtti; U: Yaⱨwǝⱨ degǝn bu nam ǝbǝdgiqǝ Mening namim bolidu, dǝwrdin-dǝwrgiqǝ Mǝn xu nam bilǝn ǝskǝ elinimǝn, dǝydu» — degin. ");
INSERT INTO uigpin_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","— Berip, Israilning aⱪsaⱪallirini yiƣip ularƣa: — «Ata-bowiliringlarning Hudasi, yǝni Ibraⱨim, Isⱨaⱪ wǝ Yaⱪupning Hudasi bolƣan Pǝrwǝrdigar manga kɵrünüp: — Mǝn silǝrni yoⱪlap kǝldim, Misirda silǝrgǝ ⱪandaⱪ muamilǝ ⱪiliniwatⱪanliⱪini kɵrdüm; ");
INSERT INTO uigpin_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","xuning üqün sɵzüm xudurki, Mǝn silǝrni Misirning zulumidin qiⱪirip, Ⱪanaaniylar, Ⱨittiylar, Amoriylar, Pǝrizziylǝr, Ⱨiwiylar wǝ Yǝbusiylarning zemini, yǝni süt bilǝn ⱨǝsǝl eⱪip turidiƣan zeminƣa elip barimǝn, dedi, — degin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","— Xuning bilǝn ular sening sɵzünggǝ ⱪulaⱪ salidiƣan bolidu. U waⱪitta sǝn, ɵzüng wǝ Israilning aⱪsaⱪalliri bilǝn birgǝ Misir padixaⱨining aldiƣa berip, uningƣa: «Ibraniylarning Hudasi Pǝrwǝrdigar biz bilǝn kɵrüxti. Əmdi sizdin ɵtünimizki, bizgǝ üq künlük yolni besip, qɵlgǝ berip, Hudayimiz Pǝrwǝrdigarƣa ⱪurbanliⱪ ⱪilixⱪa ijazǝt bǝrgǝysiz» — dǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Lekin Misir padixaⱨining ⱨǝtta ⱪudrǝtlik bir ⱪolning astida turupmu, silǝrni yǝnila ⱪoyup bǝrmǝydiƣinini bilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Xunga ⱪolumni uzitip, misirliⱪlarni Mǝn ɵz zemini iqidǝ kɵrsǝtmǝkqi bolƣan ⱨǝrhil karamǝt-mɵjizilirim bilǝn urimǝn; andin Pirǝwn silǝrni ⱪoyup beridu. ");
INSERT INTO uigpin_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Bu ⱪowmni misirliⱪlarning aldida iltipat tapturimǝn wǝ xuning bilǝn xundaⱪ boliduki, silǝr xu yǝrdin qiⱪⱪininglarda, ⱪuruⱪ ⱪol qiⱪmaysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Bǝlki ⱨǝrbir ayal kixi ɵz ⱪoxnisidin wǝ ɵz ɵyidǝ olturuxluⱪ yat ayaldin kümüx zinnǝt buyumliri, altun zinnǝt buyumliri wǝ kiyim-keqǝklǝrni tǝlǝp ⱪilidu. Bu nǝrsilǝrni oƣul-ⱪizliringlarƣa taⱪaysilǝr, kiydürisilǝr; xu tǝriⱪidǝ misirliⱪlardin olja alƣan bolisilǝr, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa jawab berip: — Mana, ular manga ixǝnmǝy turup, sɵzümgǝ ⱪulaⱪ salmaydu, bǝlki: «Pǝrwǝrdigar sanga kɵrünmidi», deyixi mumkin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Pǝrwǝrdigar uningƣa: — Ⱪolungdiki bu nemǝ? — dǝp soridi. U: — Bu bir ⱨasa, dǝp jawab bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","U: — Uni yǝrgǝ taxla, dedi. Uni yǝrgǝ taxliwidi, u bir yilanƣa aylandi; Musa uning aldidin ⱪaqti. ");
INSERT INTO uigpin_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Andin Pǝrwǝrdigar Musaƣa: — Ⱪolungni uzitip, uni ⱪuyruⱪidin tut, dewidi, u ⱪolini uzitip, uni tutti. U yǝnǝ uning ⱪolida ⱨasiƣa aylandi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Pǝrwǝrdigar yǝnǝ: — Buning bilǝn ular ata-bowilirining Hudasi, yǝni Ibraⱨimning Hudasi, Isⱨaⱪning Hudasi wǝ Yaⱪupning Hudasi bolƣan Pǝrwǝrdigarning sanga kɵrünginigǝ ixinidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Pǝrwǝrdigar uningƣa yǝnǝ: — Ⱪolungni ⱪoynungƣa salƣin, dewidi, u ⱪolini ⱪoyniƣa selip qiⱪiriwidi, mana, ⱪoli pesǝ-mahaw kesiligǝ giriptar bolup ⱪardǝk aⱪirip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Andin uningƣa: — Ⱪolungni yǝnǝ ⱪoynungƣa salƣin, dewidi, ⱪolini ⱪoyniƣa saldi. Uni yǝnǝ ⱪoynidin qiⱪiriwidi, mana, ɵz ǝksigǝ kelip ǝtlirining baxⱪa yǝrliridǝk boldi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Pǝrwǝrdigar yǝnǝ: — Xundaⱪ boliduki, ǝgǝr ular sanga ixǝnmǝy, aldinⱪi mɵjizilik alamǝtkǝ kɵngülximisǝ, ular ikkinqi mɵjizilik alamǝtkǝ ixinidu. ");
INSERT INTO uigpin_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ⱨalbuki, ular bu ikki mɵjizigǝ yǝnila ixǝnmisǝ wǝ ya sɵzünggǝ ⱪulaⱪ salmisa, undaⱪta sǝn Nil dǝryasining süyidin elip, ⱪuruⱪ yǝrgǝ tɵkkin. Xuning bilǝn sǝn dǝryadin alƣan su ⱪuruⱪ yǝr üstidǝ ⱪanƣa aylinidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Andin Musa Pǝrwǝrdigarƣa: — Əy Igǝm, mǝn ǝslidinla gǝpkǝ usta ǝmǝstim, sǝn ⱪulungƣa sɵz ⱪilƣandin keyinmu yǝnila xundaⱪ; qünki mǝn aƣzim kalwa wǝ tilim eƣir adǝmmǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Pǝrwǝrdigar uningƣa: — Kim insanƣa eƣiz bǝrgǝn? Kim adǝmni gaqa yaki gas, kɵrgüqi yaki kor ⱪilƣan? Xundaⱪ ⱪilƣuqi Mǝn Pǝrwǝrdigar ǝmǝsmu? ");
INSERT INTO uigpin_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Əmdi sǝn barƣin, Mǝn Ɵzüm sening aƣzing bilǝn billǝ bolimǝn, nemǝ sɵzlǝydiƣiningni sanga ɵgitip turimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Lekin u: — Əy Igǝm! Sǝndin ɵtünüp ⱪalay, Sǝn bu ixⱪa haliƣan baxⱪa birsini ǝwǝtip, xuning ⱪoli bilǝn ⱪilƣin! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Buni anglap Pǝrwǝrdigarning ƣǝzipi Musaƣa tutixip: — Lawiylardin bolƣan akang Ⱨarun bar ǝmǝsmu? Uning gǝpni obdan ⱪilalaydiƣinini bilimǝn. Mana, u ǝmdi sening aldingƣa qiⱪixⱪa alliⱪaqan yolƣa qiⱪti; u seni kɵrsǝ, kɵngli tolimu hux bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Əmdi dǝydiƣan gǝplǝrni uningƣa eyt; Mǝn Ɵzüm sening aƣzing bilǝn billǝ wǝ uning aƣzi bilǝn billǝ bolimǝn, nemǝ ⱪilix kerǝklikinglarni silǝrgǝ ɵgitimǝn.    ");
INSERT INTO uigpin_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ⱨarun sening ornungda hǝlⱪⱪǝ sɵzlǝydu; xundaⱪ boliduki, u sanga eƣiz bolidu, sǝn uningƣa Hudadǝk bolisǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Bu ⱨasini ⱪolungƣa elip, uning bilǝn xu mɵjizilik alamǝtlǝrni kɵrsitisǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Xuning bilǝn Musa ⱪeynatisi Yǝtroning ⱪexiƣa yenip berip, uningƣa: — Manga ijazǝt bǝrgǝyla, Misirdiki ⱪerindaxlirimning ⱪexiƣa baray, ular ⱨayatmu, ǝmǝsmu kɵrüp kelǝy, dedi. Yǝtro Musaƣa: — Aman-esǝn berip kǝlgin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa tehi Midiyandiki waⱪtida, Pǝrwǝrdigar uningƣa yǝnǝ: — Misirƣa yenip barƣin! Qünki sening jeningni istigǝn kixilǝr ɵlüp kǝtti, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Xuning bilǝn Musa ayali wǝ oƣullirini elip, ularni bir exǝkkǝ mindürüp, Misir zeminiƣa berixⱪa yolƣa qiⱪti. Mangƣanda Musa Hudaning ⱨasisini alƣaq kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Pǝrwǝrdigar Musaƣa: — Misirƣa yenip barƣiningda sǝn agaⱨ bol, Mǝn ⱪolungƣa tapxurƣan barliⱪ karamǝtlǝrni Pirǝwnning aldida kɵrsǝtkin. Lekin Mǝn uning kɵnglini hǝlⱪni ⱪoyup bǝrmigüdǝk ⱪattiⱪ ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Sǝn Pirǝwngǝ: — «Pǝrwǝrdigar mundaⱪ dǝydu: — Israil Mening oƣlum, Mening tunji oƣlum bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Xuning üqün Mǝn sanga: Oƣlumni Ɵzümgǝ ibadǝt ⱪilixⱪa ⱪoyup bǝr, dedim. Uningƣa yol ⱪoyuxni rǝt ⱪilidiƣan bolsang, sening tunji oƣlungni ɵltürimǝn» — degin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Əmma Musa sǝpǝr ⱪilip bir ⱪonalƣuƣa kǝlgǝndǝ, Pǝrwǝrdigar uningƣa uqrap, uni ɵltürüwǝtmǝkqi boldi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Xuning bilǝn Zipporaⱨ bir qaⱪmaⱪ texini elip, oƣlining hǝtnilikini kesip, uni erining ayiƣiƣa taxlap: — Sǝn dǝrwǝⱪǝ aldimda ⱪan tɵkǝr ǝr ikǝnsǝn! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Xuning bilǝn Pǝrwǝrdigar uni ⱪoyup bǝrdi (bu qaƣda Zipporaⱨ uningƣa: «Sǝn dǝrwǝⱪǝ aldimda ⱪan tɵkǝr bir ǝr ikǝnsǝn!» — dedi. Bu sɵzini u hǝtnǝ tüpǝylidin eytti). ");
INSERT INTO uigpin_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Pǝrwǝrdigar Ⱨarunƣa: — Sǝn qɵl-bayawanƣa berip, Musa bilǝn kɵrüxkin, dewidi, u berip Hudaning teƣida uning bilǝn uqrixip, uni sɵydi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa ɵzini ǝwǝtkǝn Pǝrwǝrdigarning ⱨǝmmǝ sɵzliri bilǝn ⱪilixⱪa buyruƣan barliⱪ mɵjizilik alamǝtlǝrni Ⱨarunƣa dǝp bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Andin Musa bilǝn Ⱨarun berip, Israillarning barliⱪ aⱪsaⱪallirini yiƣdi. ");
INSERT INTO uigpin_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ⱨarun Pǝrwǝrdigarning Musaƣa eytⱪan ⱨǝmmǝ sɵzlirini bayan ⱪildi wǝ hǝlⱪning kɵz aldida xu mɵjizilik alamǝtlǝrni kɵrsǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Buni kɵrüp, hǝlⱪ ixǝndi; Pǝrwǝrdigarning Israillarni yoⱪlap, ular uqriƣan harliⱪlarni kɵrgǝnlikini angliƣan ⱨaman, baxlirini egip sǝjdǝ ⱪilixti. ");
INSERT INTO uigpin_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Andin Musa bilǝn Ⱨarun Pirǝwnning aldiƣa berip, uningƣa: — Israilning Hudasi Pǝrwǝrdigar sanga: — «Ularning berip qɵldǝ Manga ibadǝt ⱪilip, ⱨeyt ɵtküzüxigǝ ⱪowmimƣa yol ⱪoysun» dǝydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Lekin Pirǝwn jawab berip: — Uning sɵzigǝ ⱪulaⱪ selip, meni Israilƣa yol ⱪoyƣuzidiƣan ⱪandaⱪ Pǝrwǝrdigar ikǝn u? Mǝn u Pǝrwǝrdigarni tonumaymǝn ⱨǝm Israilƣimu yol ⱪoymaymǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ular sɵz ⱪilip: — Ibraniylarning Hudasi biz bilǝn kɵrüxti. Xunga ɵtünimizki, bizgǝ Pǝrwǝrdigar Hudayimizƣa ⱪurbanliⱪ sunux üqün bizgǝ qɵlgǝ berixⱪa üq künlük yolƣa ruhsǝt bǝrgǝysiz. Bolmisa, U bizni waba yaki ⱪiliq bilǝn uruxi mumkin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Lekin Misirning padixaⱨi ularƣa jawab berip: — Əy Musa wǝ Ⱨarun, nemixⱪa ikkinglar hǝlⱪni ixliridin tohtitip ⱪoymaⱪqi bolisilǝr? Berip ɵz ǝpkixinglarni kɵtürünglar! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pirǝwn yǝnǝ: — Mana, hǝlⱪ yurtta ziyadǝ awup kǝtti. Silǝr bolsanglar, ularni ǝpkǝxliridin halas ⱪilmaⱪqisilǝr, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Xu küni Pirǝwn nazarǝtqilǝrgǝ wǝ nazarǝtqilǝrning ⱪol astidiki ix baxliriƣa buyruⱪ qüxürüp: — ");
INSERT INTO uigpin_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ⱨazirdin baxlap hǝlⱪⱪǝ ilgirikidǝk kesǝk ⱪuyuxⱪa saman bǝrmǝnglar! Ular samanni ɵzliri yiƣsun. ");
INSERT INTO uigpin_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Lekin ilgiri ⱪanqilik kesǝk ⱪuyup kǝlgǝn bolsa, ⱨeliⱨǝm kǝm ⱪilmay xunqilik kesǝk ⱪuydurunglar; qünki ular ⱨurunlixip: «Hudayimizƣa ⱪurbanliⱪ ɵtküzüxkǝ bizni barƣili ⱪoy» dǝp ƣǝlwǝ ⱪilixiwatidu. ");
INSERT INTO uigpin_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Əmdi ularni ɵz ixiƣa toluⱪ bǝnd bolup, yalƣan-yawidaⱪ gǝplǝrgǝ ⱪulaⱪ salmasliⱪi üqün, bu adǝmlǝrning üstigǝ tehimu eƣir ǝmgǝklǝrni yüklǝnglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Xuning bilǝn hǝlⱪning üstidiki nazarǝtqilǝr bilǝn ix baxliri qiⱪip hǝlⱪⱪǝ: Pirǝwn xundaⱪ dediki, mǝn ǝmdi silǝrgǝ saman bǝrmǝydiƣan boldum. ");
INSERT INTO uigpin_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ɵzünglar beringlar, ɵzünglar üqün ⱪǝyǝrdin saman tapalisanglar, xu yǝrdin elip kelinglar; lekin ⱪilidiƣan ixliringlar bolsa ⱪilqilikmu kemǝytilmǝydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Buning bilǝn hǝlⱪ pütkül Misir zeminiƣa tarilip, samanning orniƣa pahal yiƣixⱪa baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Nazarǝtqilǝr bolsa ularni ⱪistap: Silǝrgǝ saman berilgǝn qaƣdikidǝk ⱨazirmu ⱨǝr künlük ixni xu küni ⱪilinglar, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Israillarning üstigǝ Pirǝwnning nazarǝtqiliri tǝripidin ⱪoyulƣan Israilliⱪ ix baxliri tayaⱪ yedi wǝ: — Tünügün wǝ bügün nemixⱪa kesǝk ⱪuyux wǝzipsini burunⱪidǝk toxⱪuzup orunlimidinglar?! — dǝp til ixitti. ");
INSERT INTO uigpin_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Andin Israilliⱪ ix baxliri Pirǝwnning aldiƣa berip: Nemixⱪa ɵz ⱪulliriƣa mundaⱪ muamilǝ ⱪilidila? ");
INSERT INTO uigpin_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ɵz ⱪulliriƣa ⱨeq saman berilmidi. Lekin nazarǝtqilǝr yǝnila «kesǝk ⱪuydurunglar» dǝp bizni buyruydu. Mana, ɵz ⱪulliri tayaⱪ yǝwatidu, ǝmma ǝyib bolsa ɵzlirining adǝmliridǝ, dǝp pǝryad ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Lekin u yǝnǝ: — Silǝr ⱨurun ikǝnsilǝr! Ⱨurun ikǝnsilǝr! Xunga silǝr: «Berip Pǝrwǝrdigarƣa ⱪurbanliⱪ ɵtküzüximizgǝ ijazǝt bǝr dǝwatisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ⱪaytip berip ixingni ⱪilix! Silǝrgǝ saman berilmǝydu, biraⱪ kesǝklǝrni bǝlgilǝngǝn san boyiqǝ awwalⱪidǝk toluⱪ tapxuruxisǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israilliⱪ ix baxliri Pirǝwnning: «Silǝr ⱨǝrkünlük wǝzipǝnglarni, yǝni tǝlǝp ⱪilƣan kesǝklǝrni bǝlgilǝngǝn sandin kemǝytsǝnglar ⱪǝt’iy bolmaydu» deginigǝ ⱪarap, bexiƣa bala-ⱪazaning qüxidiƣanliⱪini bilixti. ");
INSERT INTO uigpin_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ular Pirǝwnning aldidin qiⱪip keliwatⱪinida, ular bilǝn kɵrüxüxkǝ kelip xu yǝrdǝ saⱪlap turƣan Musa wǝ Ⱨarun bilǝn uqrixip ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ular Musa bilǝn Ⱨarunƣa: — Bizni Pirǝwnning nǝziridǝ wǝ uning ǝmǝldarlirining nǝziridǝ sesitip, bizni ɵltürüxkǝ ularning ⱪoliƣa ⱪiliq tutⱪuzƣininglar üqün, Pǝrwǝrdigar silǝrning üstünglarƣa ⱨɵküm ⱪilsun! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Xuning bilǝn Musa Pǝrwǝrdigarning aldiƣa yenip berip uningƣa: — Əy Igǝm, nemixⱪa bu hǝlⱪni balaƣa tiⱪting? Sǝn nemǝ üqün meni ǝwǝtting? ");
INSERT INTO uigpin_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Qünki mǝn Pirǝwnning aldiƣa kirip Sening naming bilǝn sɵz ⱪilƣinimdin tartip, u bu hǝlⱪning üstigǝ tehimu ziyadǝ azab ⱪilƣili turdi. Əmma Sǝn tehiqǝ ⱪowmingni ⱨeq ⱪutⱪuzmiding, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Lekin Pǝrwǝrdigar Musaƣa: — Əmdi sǝn Mening Pirǝwngǝ ⱪilidiƣanlirimni kɵrisǝn; qünki u ⱪudrǝtlik bir ⱪoldin mǝjburlinip, ularni ⱪoyup beridu, ⱪudrǝtlik bir ⱪolning sǝwǝbidin ɵzining zeminidin ularni ⱪoƣlap qiⱪiriwetidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Andin Huda Musaƣa yǝnǝ sɵz ⱪilip mundaⱪ dedi: — Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mǝn Ibraⱨimƣa, Isⱨaⱪⱪa wǝ Yaⱪupⱪa Ⱪadir-mutlǝⱪ Tǝngri süpitidǝ kɵründüm; lekin «Yaⱨwǝⱨ» degǝn namim bilǝn ularƣa axkara tonulmidim. ");
INSERT INTO uigpin_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mǝn ular bilǝn: — «Silǝr musapir bolup olturƣan zeminni, yǝni Ⱪanaan zeminini silǝrgǝ berimǝn» dǝp, ular bilǝn ǝⱨdǝ baƣlixip wǝdǝ ⱪilƣanmǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Əmdi Mǝn misirliⱪlar ⱪul ⱪilip zulum salƣan Israillarning aⱨ-zarlirini anglap, ⱪilƣan xu ǝⱨdǝmni esimgǝ aldim. ");
INSERT INTO uigpin_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Xunga Israillarƣa mundaⱪ degin: — «Mǝn Pǝrwǝrdigardurmǝn; Mǝn Ɵzüm silǝrni misirliⱪlarning eƣir yükliri astidin qiⱪirip, ularning ⱪulluⱪidin azad ⱪilip, ⱪolumni uzitip ularƣa qong balayi’apǝtlǝrni qüxürüp, silǝrgǝ ⱨǝmjǝmǝt bolup ⱨɵrlükkǝ erixtürimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Silǝrni Ɵz ⱪowmim boluxⱪa ⱪobul ⱪilimǝn wǝ Ɵzüm Hudayinglar bolimǝn; xuning bilǝn silǝr ɵzünglarni misirliⱪlarning yüklirining astidin ⱪutⱪuzup qiⱪarƣuqining Mǝn Hudayinglar Pǝrwǝrdigar ikǝnlikini bilisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mǝn xuning bilǝn silǝrni ⱪol kɵtürüp Ibraⱨimƣa, Isⱨaⱪⱪa wǝ Yaⱪupⱪa berixkǝ ⱪǝsǝm ⱪilƣan zeminƣa elip barimǝn; Mǝn u yǝrni silǝrgǝ miras ⱪilip zeminliⱪⱪa berimǝn; Mǝn Pǝrwǝrdigardurmǝn». ");
INSERT INTO uigpin_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Bularning ⱨǝmmisini Musa Israillarƣa dǝp bǝrdi; lekin ular eƣir ⱪulluⱪ azabidin piƣanƣa qüxkǝn bolup, uningƣa ⱪulaⱪ salmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Andin Pǝrwǝrdigar Musaƣa yǝnǝ: — ");
INSERT INTO uigpin_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Berip Misirning padixaⱨi Pirǝwngǝ: «Israillarning zeminingdin ketixigǝ yol ⱪoy», dǝp eytⱪin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Lekin Musa Pǝrwǝrdigarning aldida: Mana, Israillar manga ⱪulaⱪ salmiƣan yǝrdǝ, Pirǝwn ⱪandaⱪmu mǝndǝk kalpuki hǝtnǝ ⱪilinmiƣan bir adǝmgǝ ⱪulaⱪ salsun? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Əmma Pǝrwǝrdigar Musa wǝ Ⱨarunƣa sɵzlǝp, ularning Israillarƣa wǝ Misirning padixaⱨi Pirǝwngǝ Israillar toƣruluⱪ: — «Ular Misir zeminidin elip qiⱪirilsun» degǝn ǝmr yǝtküzüxini buyrudi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Tɵwǝndikilǝr jǝmǝt baxliⱪliri: — Israilning tunji oƣli bolƣan Rubǝnning oƣulliri Ⱨanuⱪ, Pallu, Ⱨǝzron wǝ Karmi. Bular bolsa Rubǝnning nǝsilliri idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ximeonning oƣulliri: — Yǝmuǝl, Yamin, Oⱨad, Yaⱪin, Zoⱨar wǝ ⱪanaanliⱪ ayaldin bolƣan Saullar idi; bular Ximeonning nǝsilliri idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lawiyning oƣullirining isimliri, nǝsǝbnamilirigǝ asasǝn: Gǝrxon, Koⱨat wǝ Mǝrari; Lawiyning ɵmrining yilliri bir yüz ottuz yǝttǝ yil boldi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gǝrxonning oƣulliri aililiri boyiqǝ: — Libni wǝ Ximǝy. ");
INSERT INTO uigpin_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Koⱨatning oƣulliri: — Amram, Yizⱨar, Ⱨebron bilǝn Uzziǝl. Koⱨat bir yüz ottuz üq yil ɵmür kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Mǝrarining oƣulliri: — Maⱨli wǝ Muxi. Bular nǝsǝbnamiliri boyiqǝ Lawiyning nǝsilliri idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram ɵz ⱨammisi Yokǝbǝdni hotunluⱪⱪa aldi, Yokǝbǝd uningƣa Ⱨarun wǝ Musani tuƣup bǝrdi. Amram bir yüz ottuz yǝttǝ yil ɵmür kɵrdi.    ");
INSERT INTO uigpin_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yizⱨarning oƣulliri: — Koraⱨ, Nǝfǝg wǝ Zikri idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziǝlning oƣulliri: — Mixaǝl, Əlzafan wǝ Sitri idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ⱨarun bolsa Naⱨxonning singlisini, yǝni Amminadabning ⱪizi Elixebani hotunluⱪⱪa aldi. U uningƣa Nadab bilǝn Abiⱨuni, wǝ Əliazar bilǝn Itamarni tuƣup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Koraⱨning oƣulliri: — Assir, Əlkanaⱨ wǝ Abi’asaf; bular Koraⱨlarning nǝsilliri idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ⱨarunning oƣli Əliazar Putiǝlning ⱪizlirining birini hotunluⱪⱪa aldi; u uningƣa Finiⱨasni tuƣup bǝrdi; bular bolsa ɵz nǝsǝbi boyiqǝ ⱨǝmmisi Lawiylarning jǝmǝt baxliⱪliri idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Pǝrwǝrdigarning: — Israillarni ⱪoxunlardǝk top-topi bilǝn Misir zeminidin elip qiⱪinglar, degǝn ǝmrini tapxuruwalƣuqilar dǝl muxu Ⱨarun bilǝn Musa idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Israillar Misirdin qiⱪirilsun, dǝp Misirning padixaⱨi Pirǝwngǝ sɵz ⱪilƣanlar dǝl bu kixilǝr, yǝni muxu Musa bilǝn Ⱨarun idi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Pǝrwǝrdigar Misirning zeminida Musaƣa sɵz ⱪilƣan waⱪtida ");
INSERT INTO uigpin_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Musaƣa: «Mǝn Pǝrwǝrdigardurmǝn. Sanga eytⱪinimning ⱨǝmmisini Misirning padixaⱨi Pirǝwngǝ degin», dǝp ǝmr ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Lekin Musa Pǝrwǝrdigarning aldida: — Mǝndǝk kalpuki hǝtnǝ ⱪilinmiƣan bir kixigǝ Pirǝwn ⱪandaⱪmu ⱪulaⱪ salsun?» — dǝp jawap bǝrgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Xuning bilǝn Pǝrwǝrdigar Musaƣa: — Mana, Mǝn Pirǝwnning aldida seni Hudaning ornida ⱪildim. Akang Ⱨarun bolsa sening pǝyƣǝmbiring bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mǝn sanga buyruƣinimning ⱨǝmmisini uningƣa dǝysǝn; andin akang Ⱨarun Pirǝwngǝ uning ɵz zeminidin Israillarni ⱪoyup berixi kerǝkliki toƣrisida sɵz ⱪilidu.    ");
INSERT INTO uigpin_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Lekin Mǝn Pirǝwnning kɵnglini ⱪattiⱪ ⱪilimǝn; buning bilǝn Mǝn Misir zeminida mɵjizilik alamǝtlǝr wǝ karamǝtlirimni kɵplǝp kɵrsitimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Xundaⱪtimu, Pirǝwn silǝrgǝ ⱪulaⱪ salmaydu. Əmma Mǝn Misirning üstigǝ ⱨɵküm qiⱪirip ⱪolumni uzitip, qong balayi’apǝtlǝrni qüxürüp, ⱪoxunlirim bolƣan Ɵz ⱪowmim Israillarni Misir zeminidin qiⱪirimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ɵz ⱪolumni Misirning üstigǝ sozƣinimda, Israillarni ularning arisidin qiⱪarƣinimda misirliⱪlar Mening Pǝrwǝrdigar ikǝnlikimni tonup yetidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa bilǝn Ⱨarun xundaⱪ ⱪildi; Pǝrwǝrdigar ularƣa ⱪandaⱪ tapiliƣan bolsa, ularmu xundaⱪ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ular Pirǝwngǝ sɵz ⱪilƣan waⱪitta Musa sǝksǝn yaxⱪa, Ⱨarun sǝksǝn üq yaxⱪa kirgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Əmdi Pirǝwn silǝrgǝ: — Ɵzünglarni tǝstiⱪlap bir mɵjizǝ kɵrsitinglar, desǝ, sǝn Ⱨarunƣa: — Ⱨasangni elip Pirǝwnning aldiƣa taxliƣin, dǝp eytⱪin. Xundaⱪ ⱪilixi bilǝnla ⱨasa yilanƣa aylinidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Xuning bilǝn, Musa bilǝn Ⱨarun Pirǝwnning aldiƣa berip, Pǝrwǝrdigarning buyruƣinidǝk ⱪildi; Ⱨarun ⱨasisini Pirǝwn bilǝn uning ǝmǝldarlirining aldiƣa taxliwidi, u yilanƣa aylandi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","U waⱪitta Pirǝwn danixmǝnliri wǝ seⱨirgǝrlirini qaⱪirtip kǝldi; Misirning jadugǝrlirimu ɵz jadusi bilǝn ohxax ixni ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ularning ⱨǝrbiri ɵz ⱨasisini taxlidi; ularmu yilanƣa aylandi. Lekin Ⱨarunning ⱨasisi ularning ⱨasilirini yutup kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Biraⱪ Pǝrwǝrdigar eytⱪandǝk Pirǝwnning kɵngli ⱪattiⱪliⱪ bilǝn Pǝrwǝrdigar eytⱪandǝk ularƣa ⱪulaⱪ salmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Andin Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — Pirǝwnning kɵngli ⱪattiⱪ; u ⱪowmni ⱪoyup berixni rǝt ⱪilidu. ");
INSERT INTO uigpin_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Əmdi sǝn ǝtǝ sǝⱨǝrdǝ Pirǝwnning ⱪexiƣa barƣin (xu waⱪitta u su boyiƣa qiⱪidu) — Sǝn uning bilǝn kɵrüxüxkǝ dǝryaning boyida saⱪlap turƣin; yilanƣa aylanƣan ⱨasini ⱪolungƣa eliwal. ");
INSERT INTO uigpin_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Sǝn uningƣa mundaⱪ degin: — «Ibraniylarning Hudasi Pǝrwǝrdigar meni aldingƣa: «Qɵldǝ Manga ibadǝt ⱪilixi üqün ⱪowmimni ⱪoyup bǝr» deyixkǝ ǝwǝtkǝnidi; lekin mana, bu waⱪitⱪiqǝ ⱨeq anglimiding. ");
INSERT INTO uigpin_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Xunga Pǝrwǝrdigar sanga: — «Sǝn xu alamǝt bilǝn Mening Pǝrwǝrdigar ikǝnlikimni bilisǝn», dǝydu — Mana, mǝn ⱪolumdiki ⱨasa bilǝn dǝryaning süyini ursam, su ⱪanƣa aylinidu, ");
INSERT INTO uigpin_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","dǝryaning beliⱪliri ɵlüp, dǝryaning süyi sesip ketidu; misirliⱪlar sudin sǝskinip, iqǝlmǝydiƣan bolup ⱪalidu». ");
INSERT INTO uigpin_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Pǝrwǝrdigar Musaƣa yǝnǝ: — Sǝn Ⱨarunƣa: — Ⱨasangni elip misirliⱪlarning suliri ⱪanƣa aylansun dǝp ularning üstigǝ, yǝni eⱪinliri, ɵstǝngliri, kɵlliri wǝ su ambarliri üstigǝ ⱪolungni uzatⱪin. Xuning bilǝn pütkül Misir zeminida, ⱨǝtta yaƣaq wǝ tax ⱪaqilardiki sularmu ⱪanƣa aylinidu, degin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa bilǝn Ⱨarun Pǝrwǝrdigarning buyruƣinidǝk ⱪildi; Ⱨarun Pirǝwn wǝ ǝmǝldarlirining kɵz aldida ⱨasini kɵtürüp, dǝryaning süyini uruwidi, pütün dǝryaning süyi ⱪanƣa aylinip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Dǝryadiki beliⱪlar ɵlüp, dǝryaning süyi sesip kǝtti. Misirliⱪlar dǝryaning süyini iqǝlmǝydiƣan bolup ⱪaldi, pütkül Misir zemini ⱪanƣa toldi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Lekin Misirning jadugǝrlirimu ɵz jaduliri bilǝn ⱨǝm xundaⱪ ⱪildi. Bu sǝwǝbtin Pǝrwǝrdigar eytⱪandǝk Pirǝwnning kɵngli ⱪattiⱪ bolup, ularƣa ⱪulaⱪ salmidi; ");
INSERT INTO uigpin_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ǝksiqǝ Pirǝwn ɵyigǝ ⱪaytip ketip, bu ixⱪa ⱨeq pisǝnt ⱪilmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Dǝryaning süyini iqǝlmigini üqün barliⱪ misirliⱪlar iqküdǝk su tepix üqün dǝryaning ǝtraplirini kolidi. ");
INSERT INTO uigpin_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pǝrwǝrdigar dǝryani urup, yǝnǝ yǝttǝ kün ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Andin Pǝrwǝrdigar Musaƣa: — Pirǝwnning aldiƣa berip uningƣa: — Pǝrwǝrdigar mundaⱪ dǝydu: — «Manga ibadǝt ⱪilixⱪa Ɵz ⱪowmimni ⱪoyup bǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Lekin ularni ⱪoyup berixni rǝt ⱪilsang, mana, Mǝn dɵlitingning ⱨǝmmǝ yerini paⱪilar bilǝn basturup urimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Dǝryada top-top paⱪilar pǝyda bolup, dǝryadin qiⱪip ordangƣa, ⱨujrangƣa, orun-kɵrpǝnggǝ, ǝmǝldarliringning ɵylirigǝ kiriwalidu, xuningdǝk hǝlⱪingning uqisiƣa, tonur wǝ tǝngniliringgǝ yamixip qiⱪiwalidu. ");
INSERT INTO uigpin_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Paⱪilar ɵzüngning üstibexiƣa, hǝlⱪingning üstibexiƣa wǝ ⱨǝmmǝ ǝmǝldarliringning üstibexiƣa yamixip qiⱪiwalidu» — degin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Pǝrwǝrdigar Musaƣa: — Sǝn Ⱨarunƣa: Paⱪilarning Misir zeminining üstigǝ qiⱪixi üqün ⱪolungni uzitip, ⱨasangni eⱪinlar, ɵstǝnglǝr wǝ kɵllǝrning üstigǝ xiltiƣin, degin — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Xuning bilǝn Ⱨarun ⱪolini Misirning suliri üstigǝ uzatti; xundaⱪ ⱪiliwidi, paⱪilar qiⱪip Misir zeminini ⱪaplidi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lekin jadugǝrlǝrmu ɵz jaduliri bilǝn ohxax ixni ⱪilip, Misir zemini üstigǝ paⱪilarni pǝyda ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pirǝwn Musa bilǝn Ⱨarunni qaⱪirtip: — Paⱪilarni mǝndin wǝ hǝlⱪimdin neri ⱪilix üqün Pǝrwǝrdigardin ɵtününglar. Xundaⱪ bolsa, mǝn hǝlⱪingni Pǝrwǝrdigarƣa ⱪurbanliⱪ ⱪilsun dǝp ⱪoyup berimǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa Pirǝwngǝ: — Boptu, mǝn izzitingni ⱪilay, pǝⱪǝt dǝryadiki paⱪilarla ⱪelip, baxⱪiliri ɵzüngdin wǝ ɵyliringdin ayrilsun dǝp, sǝn, ǝmǝldarliring wǝ hǝlⱪing üqün mening dua ⱪilidiƣan waⱪtimni bekitkin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","U jawab berip: — Ətǝ bolsun, dedi. Musa uningƣa: — Hudayimiz Pǝrwǝrdigarƣa ohxax ⱨeqbirining yoⱪluⱪini bilixing üqün sening deginingdǝk bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Paⱪilar sǝndin, ɵyliringdin, ǝmǝldarliring wǝ hǝlⱪingdin qiⱪip ketidu; pǝⱪǝt dǝryadila ⱪalidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Xuning bilǝn Musa wǝ Ⱨarun Pirǝwnning aldidin qiⱪip kǝtti. Andin Musa Pirǝwnning üstigǝ ǝwǝtilgǝn paⱪilar toƣrisida Pǝrwǝrdigarƣa nida ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Pǝrwǝrdigar Musaning tiliginidǝk ⱪildi. Buning bilǝn ɵylǝrdiki, ⱨoylilardiki wǝ etizlardiki paⱪilar ɵldi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Hǝlⱪ ularni yiƣip dɵwǝ-dɵwǝ ⱪildi, pütkül yurt-zemin sesiⱪqiliⱪⱪa toldi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Lekin Pirǝwn apǝttin halas bolƣinini kɵrgǝndǝ, kɵnglini ⱪattiⱪ ⱪilip, Pǝrwǝrdigar eytⱪinidǝk ularƣa ⱪulaⱪ salmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Andin Pǝrwǝrdigar Musaƣa: — Sǝn Ⱨarunƣa: — Ⱨasangni uzitip, yǝrning topisini urƣin. Buning bilǝn u paxiƣa aylinip, pütkül Misir zeminini ⱪaplaydu, degin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ular xundaⱪ ⱪildi; Ⱨarun ⱪolini uzitip ⱨasisi bilǝn yǝrning topisini uruwidi, adǝmlǝr wǝ ⱨaywanlarning üstibexini paxa basti; pütkül Misir zeminidiki topa-qanglar paxiƣa aylandi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Jadugǝrlǝrmu ɵz jaduliri bilǝn xundaⱪ ⱪilip paxa pǝyda ⱪilixⱪa urunƣan bolsimu, pǝyda ⱪilalmidi. Paxilar bolsa ⱨǝm adǝmlǝrning ⱨǝm ⱨaywanlarning üstibexini ⱪaplap kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Andin jadugǝrlǝr Pirǝwngǝ: — Bu ix Hudaning barmiⱪining ⱪilƣini! — deyixti. Lekin Pirǝwn kɵnglini ⱪattiⱪ ⱪilip, Pǝrwǝrdigar eytⱪinidǝk ularƣa ⱪulaⱪ salmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Pǝrwǝrdigar Musaƣa: — Ətǝ sǝⱨǝr ⱪopup Pirǝwnning aldiƣa berip turƣin — (xu waⱪitta u su boyiƣa qiⱪidu) uningƣa: «Pǝrwǝrdigar mundaⱪ dǝydu: — Manga ibadǝt ⱪilixi üqün Ɵz ⱪowmimni ⱪoyup bǝr! ");
INSERT INTO uigpin_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Qünki ǝgǝr ⱪowmimni ⱪoyup bǝrmisǝng, mana Mǝn sening wǝ ǝmǝldarliring, hǝlⱪing üstigǝ, ɵyliringgǝ kɵküyünlǝrni ǝwǝtimǝn; xuning bilǝn misirliⱪlarning ɵyliri wǝ ⱨǝtta ular turuwatⱪan tupraⱪmu kɵküyünlǝr bilǝn tolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Lekin xu künidǝ Ɵz ⱪowmim turuwatⱪan Goxǝn yurtini baxⱪiqǝ ⱪilimǝn; xundaⱪ boliduki, u yǝrdǝ kɵküyünlǝr tepilmaydu. Xuning bilǝn sǝn Mǝn Pǝrwǝrdigarning bu zeminda bolƣanliⱪimni bilisǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Xundaⱪ ⱪilip Mǝn Ɵz ⱪowmimni sening hǝlⱪingdin pǝrⱪlǝndürimǝn; bu mɵjizilik alamǝt ǝtǝ yüz beridu», dǝp eytⱪin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Pǝrwǝrdigar deginini ⱪildi. Pirǝwnning ɵylirigǝ, ǝmǝldarlirining ɵylirigǝ kɵküyünlǝr top-top bolup kirdi; pütkül Misir zeminining ⱨǝmmǝ yeri kɵküyünlǝr tǝripidin harab boluxⱪa baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pirǝwn Musa bilǝn Ⱨarunni qaⱪirtip kelip ularƣa: Berip muxu zeminda Hudayinglarƣa ⱪurbanliⱪ ɵtküzünglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Lekin Musa jawab berip: — Bundaⱪ ⱪilix bizgǝ taza muwapiⱪ bolmaydu; qünki biz Pǝrwǝrdigar Hudayimizƣa sunmaⱪqi bolƣan ⱪurbanliⱪ mal misirliⱪlarƣa nisbǝtǝn yirginqliktur. Əmdi ǝgǝr biz misirliⱪlarning kɵz aldida yaman kɵrüngǝn nǝrsini ⱪurbanliⱪ ⱪilsaⱪ ular bizni qalma-kesǝk ⱪiliwǝtmǝmdu?    ");
INSERT INTO uigpin_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Biz üq künlük yolni besip, qɵldǝ Pǝrwǝrdigar Hudayimiz bizgǝ buyruƣinidǝk uningƣa ⱪurbanliⱪ sunuximiz kerǝk, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pirǝwn: — Silǝrni Pǝrwǝrdigar Hudayinglarƣa qɵldǝ ⱪurbanliⱪ ɵtküzüxkǝ barƣili ⱪoyimǝn; pǝⱪǝt bǝk yiraⱪ ketip ⱪalmanglar, mening üqün dua ⱪilinglar, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa jawab berip: — Mana, mǝn sening aldingdin qiⱪip Pǝrwǝrdigarƣa iltija ⱪilimǝn wǝ kɵküyünlǝr sǝn Pirǝwndin, ǝmǝldarliringdin wǝ hǝlⱪingdin ǝtǝ qiⱪip ketidu; lekin Pirǝwn yǝnǝ ⱨiylǝ ixlitip, hǝlⱪni Pǝrwǝrdigarƣa ⱪurbanliⱪ ⱪilixⱪa berixtin tosⱪuqi bolmisun, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Musa Pirǝwnning aldidin qiⱪip, Pǝrwǝrdigarƣa xundaⱪ iltija ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Pǝrwǝrdigar Musa tiliginidǝk ⱪildi; u kɵküyünlǝrni Pirǝwn, ǝmǝldarliri wǝ hǝlⱪidin qiⱪiriwǝtti; ⱨǝtta bir tal kɵküyünmu ⱪalmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Lekin Pirǝwn bu ⱪetimmu kɵnglini ⱪattiⱪ ⱪilip, ⱪowmni ⱪoyup bǝrmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Andin Pǝrwǝrdigar Musaƣa: — Pirǝwnning aldiƣa berip uningƣa: — «Ibraniylarning Hudasi Pǝrwǝrdigar mundaⱪ dǝydu: — Manga ibadǝt ⱪilixiƣa Ɵz ⱪowmimni ⱪoyup bǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Əgǝr ularni ⱪoyup berixni rǝt ⱪilip, yǝnila tutup turuwalidiƣan bolsang, ");
INSERT INTO uigpin_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","mana, Pǝrwǝrdigarning ⱪoli etizliⱪtiki qarpayliringning üstigǝ, at-exǝklǝr, tɵgilǝr, wǝ ⱪoy-kaliliringning üstigǝ qüxüp intayin eƣir bir waba kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Lekin Pǝrwǝrdigar Israilning qarpaylirini misirliⱪlarning qarpayliridin pǝrⱪlǝndüridu. Nǝtijidǝ, Israilning qarpayliridin ⱨeqbiri ɵlmǝydu» — degin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Pǝrwǝrdigar waⱪitni bekitip: — Ətǝ Pǝrwǝrdigar zeminda bu ixni ⱪilidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ətisi Pǝrwǝrdigar xundaⱪ ⱪildi; misirliⱪlarning barliⱪ qarpayliri ɵldi; lekin Israillarning qarpayliridin birimu ɵlmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pirǝwn adǝm ǝwǝtip tǝkxüriwidi, mana, Israillarning qarpayliridin birimu ɵlmigǝnidi. Lekin Pirǝwnning kɵngli ⱪattiⱪ ⱪilinip, u ⱪowmni ⱪoyup bǝrmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Andin Pǝrwǝrdigar Musa wǝ Ⱨarunƣa: — Humdanning külidin qanggilinglarni toxⱪuzup elinglar, andin Musa uni Pirǝwnning kɵz aldida asmanƣa ⱪaritip qaqsun. ");
INSERT INTO uigpin_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Xundaⱪ ⱪilixi bilǝn kül pütkül Misir zeminini ⱪaplaydiƣan qang-tozan bolidu wǝ Misir zeminidiki ⱨǝmmǝ yǝrdǝ adǝmlǝr wǝ ⱨaywanlarning bǝdinigǝ qüxüxi bilǝn ⱨürrǝk-ⱨürrǝk qaⱪa qiⱪiridu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Xuning bilǝn ular humdandin kül elip, Pirǝwnning aldiƣa berip turdi wǝ Musa uni asmanƣa ⱪaritip qaqti; u adǝmlǝr wǝ ⱨaywanlarning bǝdinigǝ qüxüxi bilǝn ⱨürrǝk-ⱨürrǝk qaⱪa qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Jadugǝrlǝr qaⱪilar dǝstidin Musaning aldida turalmay ⱪaldi; qünki jadugǝrlǝrning bǝdininimu, baxⱪa barliⱪ misirliⱪlarnimu ohxax qaⱪa besip kǝtkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Lekin Pǝrwǝrdigar Pirǝwnning kɵnglini ⱪattiⱪ ⱪildi; xunga Pǝrwǝrdigar dǝl Musaƣa eytⱪinidǝk u ularƣa ⱪulaⱪ salmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Andin Pǝrwǝrdigar Musaƣa: — Ətǝ tang sǝⱨǝr ⱪopup, Pirǝwnning aldida turup uningƣa: «Ibraniylarning Hudasi Pǝrwǝrdigar mundaⱪ dǝydu: — Ⱪowmimni Manga ibadǝt ⱪilixⱪa ⱪoyup bǝr; ");
INSERT INTO uigpin_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","qünki Mǝn bu ⱪetim ⱨǝmmǝ balayi’apǝtlirimni yürikinggǝ, ǝmǝldarliring wǝ puⱪraliringning üstigǝ ǝwǝtimǝn. Buning bilǝn sǝn pütkül yǝr yüzidǝ Mǝndǝk baxⱪa birining yoⱪ ikǝnlikini bilisǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Qünki Mǝn ⱪolumni uzitip, ɵzüng wǝ ⱪowmingni waba bilǝn urƣan bolsam’idi, bu waⱪitⱪiqǝ sǝn yǝr yüzidin yoⱪilip ketǝtting. ");
INSERT INTO uigpin_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ⱨalbuki, Mening seni ornungƣa tikliximdiki mǝⱪsitim xu idiki, dǝl Ɵz ⱪudritimni sanga kɵrsitix, xundaⱪla namimning pütkül yǝr yüzidǝ jakarlinixi üqün idi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Sǝn yǝnǝ ⱪowmimƣa qongqiliⱪ ⱪilip, ularni ⱪoyup berixni rǝt ⱪiliwerǝmsǝn? ");
INSERT INTO uigpin_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mana, ǝtǝ muxu waⱪitlarda Misir dɵliti bina bolƣandin buyan ⱨeq kɵrülüp baⱪmiƣan ⱪattiⱪ mɵldürni yaƣdurimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Xuning üqün adǝm ǝwǝtip, ⱨaywan wǝ etizda bar-yoⱪungni yiƣip iqkiri soliƣin; qünki ɵygǝ ⱪayturulmay sirtta ⱪalƣan adǝm wǝ ⱨaywanlarning ⱨǝmmisi mɵldürning astida ⱪelip ɵlüp ketidu! — degin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Buni anglap Pirǝwnning ǝmǝldarlirining arisidin Pǝrwǝrdigarning sɵzidin ⱪorⱪⱪan ⱨǝrbir adǝm ɵz ⱪulliri wǝ qarpaylirini yügürtüp ɵylirigǝ elip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Lekin Pǝrwǝrdigarning sɵzini etibarƣa almiƣanlar ɵz ⱪul wǝ mallirini taxⱪirida ⱪaldurup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Pǝrwǝrdigar Musaƣa: — Misir zeminidiki ⱨǝr yǝrdǝ, adǝmlǝr üstigǝ, mallarning üstigǝ, xundaⱪla Misir zeminidiki dalalarning ⱨǝmmǝ ot-qɵplirining üstigǝ mɵldür yaƣsun dǝp, asmanƣa ⱪarap ⱪolungni kɵtürgin, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa xuning bilǝn ⱨasisini asmanƣa ⱪaritip kɵtürüwidi, Pǝrwǝrdigar güldürmamini güldürlitip, mɵldür yaƣdurdi, yǝr yüzidǝ qaⱪmaⱪ qeⱪindiliri qepip yürǝtti. Xundaⱪ ⱪilip Pǝrwǝrdigar Misir zemini üstigǝ mɵldür yaƣdurdi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mɵldür yeƣip, mɵldür bilǝn ot arilax qüxti; mɵldür xunqǝ eƣir boldiki, Misir dɵliti bina bolƣandin tartip undaⱪ ⱪattiⱪ mɵldür yeƣip baⱪmiƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mɵldür pütkül Misir zeminining ⱨǝr yeridǝ qüxüp, insan bolsun, ⱨaywan bolsun, ⱨǝmmisini urdi; mɵldür etizdiki ⱨǝmmǝ ot-qɵpni urup, yǝrdiki ⱨǝmmǝ dǝl-dǝrǝhlǝrnimu sunduruwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Pǝⱪǝt Israillar olturuxluⱪ Goxǝn zeminidila mɵldür yaƣmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pirǝwn adǝm ǝwǝtip Musa bilǝn Ⱨarunni qaⱪirtip ularƣa: — Mǝn bu ⱪetim gunaⱨ ⱪildim! Pǝrwǝrdigar ⱨǝⱪⱪaniydur; Sǝwǝnlik bolsa mǝn wǝ hǝlⱪimdin ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Yǝnǝ berip Pǝrwǝrdigardin ɵtünüp iltija ⱪilinglar! Hudadin qiⱪⱪan bu ⱪattiⱪ güldürmamilar wǝ mɵldür yetip axti! Silǝrni ⱪoyup berǝy; silǝr ǝmdi muxu yǝrdǝ turiwǝrsǝnglar bolmaydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa uningƣa jawab berip: — Mǝn xǝⱨǝrdin qiⱪⱪanda, Pǝrwǝrdigar tǝrǝpkǝ ⱪarap ⱪollirimni yeyip kɵtürimǝn; güldürmamilar xu ⱨaman besiⱪip mɵldür yǝnǝ yaƣmaydu. yǝr yüzi Pǝrwǝrdigarningkidur, dǝp bilixing üqün xundaⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Lekin sǝn wǝ sening ǝmǝldarliring, silǝrning Pǝrwǝrdigar Hudadin tehiqǝ ⱪorⱪmaywatⱪininglarni bilimǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Xu qaƣda arpa bax qiⱪirip, ziƣir ƣunqiliƣan bolƣaqⱪa, ziƣir wǝ arpa mɵldürdin wǝyran ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Lekin buƣday bilǝn ⱪara buƣday keyinrǝk bih qiⱪarƣaqⱪa, wǝyran ⱪilinmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa Pirǝwnning aldidin ketip, xǝⱨǝrdin qiⱪip Pǝrwǝrdigar tǝrǝpkǝ ⱪarap ⱪollirini yeyip kɵtürdi. Xuning bilǝn güldürmama wǝ mɵldür tohtap, yamƣur yǝrgǝ yǝnǝ tɵkülmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Əmma Pirǝwn yamƣur, mɵldür wǝ güldürmamilarning tohtiƣinini kɵrgǝndǝ, yǝnǝ gunaⱨ sadir ⱪildi; umu, ǝmǝldarlirimu kɵnglini ⱪattiⱪ ⱪilixti. ");
INSERT INTO uigpin_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Bu tǝriⱪidǝ Pirǝwnning kɵngli ⱪattiⱪ turuwerip, Pǝrwǝrdigar Musaning wasitisi bilǝn eytⱪandǝk, Israillarni ⱪoyup berixni rǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Andin Pǝrwǝrdigar Musaƣa: — Pirǝwnning aldiƣa barƣin; qünki ularning arisida bu mɵjizilik alamǝtlǝrni kɵrsitixim üqün Pirǝwnning kɵnglini wǝ ǝmǝldarlirining kɵnglini ⱪattiⱪ ⱪilip ⱪoydum. ");
INSERT INTO uigpin_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Bu ix bilǝn Mening misirliⱪlarni ⱪandaⱪ rǝswa ⱪilƣanliⱪim wǝ ularning arisida kɵrsǝtkǝn mɵjizilik alamǝtlirimni sǝn oƣlungning andin nǝwrǝngning ⱪuliⱪiƣa yǝtküzisǝn. Buning bilǝn Mening Pǝrwǝrdigar ikǝnlikimni bilisilǝr, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Xuning bilǝn Musa bilǝn Ⱨarun Pirǝwnning aldiƣa berip, uningƣa: — Ibraniylarning Hudasi Pǝrwǝrdigar mundaⱪ dǝydu: «Ɵzüngni aldimda tɵwǝn tutuxni ⱪaqanƣiqǝ rǝt ⱪilisǝn? Manga ibadǝt ⱪilix üqün ⱪowmimni ⱪoyup bǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Qünki ǝgǝr sǝn ⱪowmimni ⱪoyup berixni rǝt ⱪilsang, mana, Mǝn ǝtǝ sening yurtungƣa qekǝtkǝ ǝwǝtimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ular silǝr zemin yüzini kɵrmigüdǝk ⱪilip yepiwetidu, silǝrning mɵldürdin aman ⱪalƣan nǝrsiliringlarnimu, dalalarda ɵskǝn ⱨǝmmǝ dǝl-dǝrǝhliringlarnimu yǝp ketidu. ");
INSERT INTO uigpin_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ular orda-sarayliringƣa, ǝmǝldarliringning sarayliri, xundaⱪla barliⱪ misirliⱪlarning ɵylirigǝ tolup ketidu; bundaⱪ apǝtni ata-bowangliring wǝ ata-bowiliringning ata-bowilirimu yǝr yüzidǝ apiridǝ bolƣandin tartip kɵrüp baⱪmiƣan» — dedi-dǝ, burulup Pirǝwnning aldidin qiⱪip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pirǝwnning ǝmǝldarliri uningƣa: — Bu adǝm bizgǝ ⱪaqanƣiqǝ tuzaⱪ bolar? Ɵz Hudasi Pǝrwǝrdigarƣa ibadǝt ⱪilixⱪa bu adǝmlǝrni ⱪoyup bǝrgǝyla! Misirning harab bolƣinini tehiqǝ kɵrmǝywatamdila? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Xuning bilǝn Musa bilǝn Ⱨarun Pirǝwnning aldiƣa yǝnǝ qaⱪiritip kelindi. U ularƣa: — Pǝrwǝrdigarƣa ibadǝt ⱪilix üqün beringlar; lekin baridiƣanlar zadi kimlǝr? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa jawab berip: — Yaxlirimiz wǝ ⱪeri-qürilǝr bilǝn, oƣullirimiz wǝ ⱪizlirimiz bilǝn, ⱪoy wǝ kala padilirimizni elip ⱨǝmmimiz barimiz; qünki biz Pǝrwǝrdigar üqün ⱨeyt ɵtküzüximiz kerǝk, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","U ularƣa: — Silǝrni bala-qaⱪanglar bilǝn ⱪoxup ⱪoyup bǝrginimdǝ, Pǝrwǝrdigar silǝr bilǝn billǝ bolƣay! Mana, aldinglarda balayi’apǝt turuptu! ");
INSERT INTO uigpin_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Yoⱪsu, bundaⱪ ⱪilixinglarƣa bolmaydu! Pǝrwǝrdigarƣa ibadǝt ⱪilixⱪa pǝⱪǝt aranglardin ǝr kixilǝrla barsun! Qünki silǝrning tǝlipinglar dǝl xu ǝmǝsmidi! — dedi-dǝ, ular Pirǝwnning aldidin ⱪoƣlap qiⱪirildi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Andin Pǝrwǝrdigar Musaƣa: — Misir zeminining üstigǝ ⱪolungni uzatⱪin. Xundaⱪ ⱪilsang, qekǝtkilǝr Misir zeminini besip, zemindiki ⱨǝrhil otyaxlarni, yǝni mɵldürdin aman ⱪalƣanning ⱨǝmmisini yǝp ketidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa ⱨasisini Misir zeminining üstigǝ uzatti; Pǝrwǝrdigar xu küni wǝ keqisi zemin üstigǝ xǝrⱪ xamili qiⱪardi. Sǝⱨǝrdǝ, xǝrⱪ xamili qekǝtkilǝrni uqurup kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Qekǝtkilǝr Misirning pütkül zeminiƣa yeyilip, Misirning pütün qegrisinimu basti. Apǝt intayin eƣir boldi; ilgiri bundaⱪ qekǝtkǝ apiti bolup baⱪmiƣan, mundin keyinmu uningdǝk bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ular pütkül zeminning yüzini ⱪaplidi, yǝr ⱪarangƣulixip kǝtti; ular mɵldürdin aman ⱪalƣan zemindiki ⱨǝmmǝ otyaxlarni wǝ dǝl-dǝrǝhlǝrning barliⱪ mewilirini yǝp kǝtti. Xuning bilǝn pütkül Misir zemini tǝwǝsidiki dǝl-dǝrǝhlǝrdǝ yaki daladiki gül-giyaⱨlarda ⱨeq yexilliⱪ ⱪalmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Andin Pirǝwn aldirap-tenǝp Musa bilǝn Ⱨarunni qaⱪirtip ularƣa: — Mǝn ⱨǝm Hudayinglar Pǝrwǝrdigar aldida ⱨǝm silǝrning aldinglarda gunaⱨ ⱪildim. ");
INSERT INTO uigpin_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Əmdi muxu bir ⱪetim gunaⱨimdin ɵtüp Pǝrwǝrdigar Hudayinglardin bu ɵlümni mǝndin elip ketixini iltija ⱪilixinglarni ɵtünimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Xuning bilǝn Musa Pirǝwnning aldidin qiⱪip Pǝrwǝrdigarƣa iltija ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Xuning bilǝn Pǝrwǝrdigar xamalni burap ƣǝrb tǝrǝptin intayin küqlük boran qiⱪirip, qekǝtkilǝrni uqurup, Ⱪizil Dengizƣa ƣǝrⱪ ⱪildi; Misirning pütkül tǝwǝsidǝ bir talmu qekǝtkǝ ⱪalmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Lekin Pǝrwǝrdigar Pirǝwnning kɵnglini ⱪattiⱪ ⱪilip ⱪoyƣini üqün u Israillarni ⱪoyup bǝrmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Andin Pǝrwǝrdigar Musaƣa: — Ⱪolungni asmanƣa ⱪaritip uzatⱪin; xuning bilǝn ⱪattiⱪ bir ⱪarangƣuluⱪ bolidu, ⱨǝtta adǝm silisa ⱪoliƣa tuyulƣudǝk ⱪoyuⱪ ⱪarangƣuluⱪ Misir zeminini ⱪaplaydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Andin Musa ⱪolini asmanƣa ⱪaritip uzitiwidi, ⱪoyuⱪ bir ⱪarangƣuluⱪ Misir zeminini üq küngiqǝ ⱪaplap turdi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Üq küngiqǝ biri yǝnǝ birini kɵrǝlmǝs wǝ ya ⱨeqkim ɵz jayidin ⱪozƣilalmas boldi; lekin barliⱪ Israillar olturƣan jaylarda yoruⱪluⱪ bar idi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pirǝwn Musani qaⱪirtip uningƣa: — Berip, Pǝrwǝrdigarƣa ibadǝt ⱪilinglar. Pǝⱪǝt ⱪoy wǝ kala padiliringlar ⱪalsun; bala-qaⱪiliringlarnimu elip barsanglar bolidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa jawabǝn: — Undaⱪta Hudayimiz Pǝrwǝrdigarƣa ⱪurbanliⱪ ⱪilixⱪa inaⱪliⱪ ⱪurbanliⱪi wǝ kɵydürmǝ ⱪurbanliⱪiƣa lazimliⱪ qarpaylarni sǝn bizgǝ berǝmsǝn? ");
INSERT INTO uigpin_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ɵzimizning qarpaylirimiz biz bilǝn birgǝ ketixi kerǝk, bir tuyiⱪimu kǝynidǝ ⱪalsa bolmaydu; qünki Hudayimiz Pǝrwǝrdigarƣa ibadǝt ⱪilixⱪa ⱪurbanliⱪ ⱪilidiƣinimizni bulardin talliximiz lazim. U yǝrgǝ yetip barmiƣuqǝ, Pǝrwǝrdigarƣa ⱪaysi ⱪurbanliⱪlar bilǝn ibadǝt ⱪilidiƣinimizni bilmǝymiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Lekin Pǝrwǝrdigar Pirǝwnning kɵnglini ⱪattiⱪ ⱪildi; u ularni yǝnila ⱪoyup bǝrmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pirǝwn Musaƣa: — Aldimdin yoⱪal! Ⱨezi bol, ikkinqi manga kɵrüngüqi bolma! Qünki yüzümni yǝnǝ kɵrgǝn kününg jeningdin ayrilisǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa uningƣa: — Rast eytting! Mǝn sening yüzüngni ikkinqi kɵrgüqi bolmaymǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Xuning bilǝn Pǝrwǝrdigar Musaƣa: — Yǝnǝ bir apǝtni Pirǝwnning üstigǝ wǝ Misirning üstigǝ qüxürimǝn. Andin u silǝrni bu yǝrdin ketixkǝ yol ⱪoyidu wǝ u silǝrni ⱨǝmmǝ nǝrsiliringlar bilǝn ⱪoxup ⱪoyup berip, bu yǝrdin mutlǝⱪ ⱪoƣlap qiⱪiridu. ");
INSERT INTO uigpin_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Əmdi sǝn hǝlⱪⱪǝ tapilap: — Ⱨǝr biringlar, ǝr kixilǝrning ⱨǝrbiri ɵz ⱪoxnisidin, ayal kixilǝrning ⱨǝrbiri ɵz ⱪoxnisidin kümüx buyumlarni, altun buyumlarni sorap alsun, degin, — dedi    ");
INSERT INTO uigpin_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Pǝrwǝrdigar hǝlⱪini misirliⱪlarning aldida iltipat tapⱪuzdi. Xuningdǝk Musa degǝn bu adǝm Misir zeminida Pirǝwnning ǝmǝldarlirining nǝziridǝ bolsun, puⱪralarning nǝziridǝ bolsun, naⱨayiti uluƣ zat boldi). ");
INSERT INTO uigpin_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Andin Musa yǝnǝ: — Pǝrwǝrdigar mundaⱪ dǝydu: — «Mǝn yerim keqidǝ qiⱪip Misirni kezip qiⱪimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Xu waⱪitta tǝhttǝ olturuwatⱪan Pirǝwnning tunji oƣlidin tartip yarƣunqaⱪ tartidiƣan dedǝkning tunji oƣliƣiqǝ, xundaⱪla barliⱪ qarpaylarning tunjiliri, yǝni Misirdiki barliⱪ tunji jan igiliri ɵlidu. ");
INSERT INTO uigpin_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Bu sǝwǝbtin pütkül Misir zeminida ⱪattiⱪ bir pǝryad kɵtürülidu; uningdin ilgiri xundaⱪ pǝryad bolup baⱪmiƣanidi, mundin keyinmu bundaⱪ pǝryad anglanmaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Lekin Israillarƣa, mǝyli adǝmliri, mǝyli ⱨaywanatliriƣa bolsun, ⱨǝtta bir tal itmu ⱪawap ⱪoymaydu. Buningdin Pǝrwǝrdigarning misirliⱪlar bilǝn Israilni pǝrⱪlǝndüridiƣanliⱪini bilisilǝr». ");
INSERT INTO uigpin_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","— Xuning bilǝn bu ǝmǝldarliringning ⱨǝmmisi aldimƣa kelip, manga tǝzim ⱪilip: «Sili ɵzliri wǝ siligǝ ǝgǝxkǝn barliⱪ ⱪowmliri qiⱪip ketixkǝyla!» dǝp eytidu, andin qiⱪip ketimǝn» — dedi-dǝ, ⱪattiⱪ ƣǝzǝp bilǝn Pirǝwnning aldidin qiⱪip kǝtti.    ");
INSERT INTO uigpin_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Pǝrwǝrdigar Musaƣa: — Misir zeminida Mening karamǝt mɵjizilirimning kɵplǝp kɵrsitilixi üqün Pirǝwn silǝrgǝ ⱪulaⱪ salmaydu, — degǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa bilǝn Ⱨarun bu karamǝt mɵjizilǝrning ⱨǝmmisini Pirǝwnning aldida kɵrsitip boldi; lekin Pǝrwǝrdigar Pirǝwnning kɵnglini ⱪattiⱪ ⱪilip ⱪoyƣini üqün u Israillarni uning zeminidin kǝtkili ⱪoymidi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Pǝrwǝrdigar Misir yurtida Musa wǝ Ⱨarunƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Bu ay silǝrgǝ aylarning iqidǝ bexi, yilning tunji eyi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Silǝr pütün Israil jamaitigǝ sɵz ⱪilip: — Bu ayning oninqi küni ⱨǝmminglar atiliringlarning ailisi boyiqǝ bir ⱪozini elinglar; ⱨǝrbir ailigǝ birdin ⱪoza elinglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Əgǝr mǝlum bir ailǝ bir ⱪozini yǝp bolalmiƣudǝk bolsa, undaⱪta ɵy igisi yenidiki ⱪoxnisi bilǝn birlixip adǝm saniƣa ⱪarap bir ⱪoza elinglar; ⱨǝrbir kixining ixtiⱨasiƣa ⱪarap ⱨesablap muwapiⱪ bir ⱪoza ⱨazirlanglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ⱨǝrbiringlar tallaydiƣan ⱪozanglar bejirim, bir yaxliⱪ ǝrkǝk bolsun; ⱪoy yaki ɵqkǝ padiliridin tallansimu bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ⱪozini bu ayning on tɵtinqi künigiqǝ yeninglarda turƣuzunglar, — degin. — Xu küni Israilning pütkül jamaiti talliƣan melini gugumda soysun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Andin ular uning ⱪenidin elip gɵx yeyilgǝn ɵyning ixikning bax tǝripigǝ ⱨǝm ikki yan kexikigǝ sürkǝp ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ular xu keqisi gɵxini otta kawap ⱪilip yesun; uni petir nan wǝ aqqiⱪ-qüqük kɵktat bilǝn ⱪoxup yesun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ⱪǝt’iy ham yaki suda pixurup yemǝnglar, bǝlki uni bax, put wǝ iq-ⱪarinliri bilǝn otta kawap ⱪilip yǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Uning ⱨeqnemisini ǝtigǝ ⱪaldurmanglar. Əgǝr ǝtigǝ exip ⱪalƣanliri bolsa, uni otⱪa selip kɵydürüwetinglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Silǝr uni mundaⱪ ⱨalǝttǝ yǝnglar: — Uni yegǝndǝ bǝlliringlarni qing baƣlap, ayaƣliringlarƣa kǝx kiyip, ⱪolliringlarda ⱨasa tutⱪan ⱨalda tez yǝnglar. U bolsa Pǝrwǝrdigarning «ɵtüp ketix» ⱪozisidur. ");
INSERT INTO uigpin_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Qünki Mǝn u keqisi Misir zeminini kezip ɵtimǝn; Mǝn Misir zeminida mǝyli insan bolsun, mǝyli ⱨaywan bolsun ularning tunji tuƣulƣan ǝrkikining ⱨǝmmisini ɵltürimǝn; xuning bilǝn Mǝn Misirning barliⱪ but-ilaⱨlirining üstidin ⱨɵküm qiⱪirimǝn; Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Xu ⱪurbanliⱪning ⱪeni silǝr olturƣan ɵylǝrdǝ silǝrgǝ nijat bǝlgisi bolidu; bu ⱪanlarni kɵrginimdǝ silǝrgǝ ɵtüp turimǝn. Xuning bilǝn Misir zeminini urƣinimda ⱨalakǝt elip kelidiƣan waba-apǝt silǝrgǝ tǝgmǝydu. ");
INSERT INTO uigpin_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Bu kün silǝrgǝ hatirǝ kün bolsun; uni Pǝrwǝrdigarning ⱨeyti süpitidǝ ɵtküzüp tǝbriklǝnglar; ǝbǝdiy bǝlgilimǝ süpitidǝ nǝsildin-nǝsilgǝ mǝnggü ɵtküzünglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yǝttǝ kün petir nan yǝnglar; birinqi küni ɵyünglardin barliⱪ hemirturuqlarni yoⱪ ⱪilinglar; qünki kimki birinqi kündin tartip yǝttinqi küngiqǝ boldurulƣan nan yesǝ, xu kixi Israil ⱪataridin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Birinqi küni silǝr muⱪǝddǝs ibadǝt soruni tüzünglar; yǝttinqi künimu ⱨǝm xundaⱪ bir muⱪǝddǝs ibadǝt soruni ɵtküzülsun. Bu ikki kün iqidǝ ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilinmisun; pǝⱪǝt ⱨǝr kixining yǝydiƣinini tǝyyarlaxⱪa munasiwǝtlik ixlarnila ⱪilsanglar bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mǝn dǝl xu küni silǝrni ⱪoxun-ⱪoxun boyiqǝ Misir zeminidin qiⱪarƣinim üqün silǝr petir nan ⱨeytini ɵtküzünglar; xu künni nǝsildin-nǝsilgǝ ǝbǝdiy bǝlgilimǝ süpitidǝ ⱨeyt küni ⱪilip bekitinglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Birinqi ayning on tɵtinqi küni, kǝqⱪurundin tartip xu ayning yigirmǝ birinqi küni kǝqⱪurunƣiqǝ, petir nan yǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Yǝttǝ kün iqidǝ ɵyliringlarda ⱨeq hemirturuq bolmisun; qünki musapir bolsun, zeminda tuƣulƣan bolsun, kimki boldurulƣan nǝrsilǝrni yesǝ xu kixi Israil jamaitidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Silǝr ⱨeqⱪandaⱪ boldurulƣan nǝrsini yemǝy, ⱪǝyǝrdila tursanglar, petir nan yǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa Israilning barliⱪ aⱪsaⱪallirini qaⱪirip ularƣa: — Berip ⱨǝrbiringlarning ailisi boyiqǝ ɵzünglarƣa bir ⱪozini tartip qiⱪirip pasha ⱪozisini soyunglar.    ");
INSERT INTO uigpin_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Andin bir tutam zupa elip uni ⱪaqidiki ⱪanƣa qilap, ⱪaqidiki ⱪanni ixikning bexi wǝ ikki kexikigǝ sürkǝnglar. Silǝrdin ǝtigǝngiqǝ ⱨeqkim ɵyining ixikidin ⱪǝt’iy qiⱪmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Qünki Pǝrwǝrdigar misirliⱪlarni urup ⱨalak ⱪilix üqün, zeminni kezip ɵtidu; U ixikning bexi wǝ ikki kexikidiki ⱪanni kɵrgǝndǝ, Pǝrwǝrdigar ⱨalak ⱪilƣuqining ɵyliringlarƣa kirip silǝrni uruxidin tosux üqün muⱨapizǝt ⱪilip ixikning aldiƣa ɵtüp turidu.    ");
INSERT INTO uigpin_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Bu rǝsim-ⱪaidini ɵzünglar wǝ baliliringlar üqün ǝbǝdiy bir bǝlgilimǝ süpitidǝ tutunglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Silǝr Pǝrwǝrdigar Ɵz wǝdisi boyiqǝ silǝrgǝ beridiƣan zeminƣa kirgininglarda bu ⱨeytliⱪ ibadǝtni tutunglar. ");
INSERT INTO uigpin_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Baliliringlar silǝrdin: «bu ibaditinglarning mǝnisi nemǝ?» — dǝp sorisa, ");
INSERT INTO uigpin_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","silǝr: «Bu misirliⱪlarni urƣinida, Misirda Israillarning ɵylirining aldiƣa ɵtüp turup, bizning ɵydikilirimizni ⱪutⱪuzƣan Pǝrwǝrdigarƣa bolƣan «ɵtüp ketix» ⱪurbanliⱪi bolidu» — dǝnglar. Xuni angliƣanda, hǝlⱪ engixip Hudaƣa sǝjdǝ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Andin Israillar ⱪaytip berip, Pǝrwǝrdigar dǝl Musa bilǝn Ⱨarunƣa ǝmr ⱪilƣandǝk ix kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Wǝ xundaⱪ boldiki, yerim keqǝ bolƣanda, Pǝrwǝrdigar Pirǝwnning tǝhtidǝ olturuwatⱪan tunjisidin tartip zindanda yetiwatⱪan mǝⱨbusning tunjisiƣiqǝ, Misir zeminidiki tunji oƣullarning ⱨǝmmisini urup ɵltürdi, xundaⱪla u ⱨaywanatlarning tunji tuƣulƣanliriningmu ⱨǝmmisini ɵltürdi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Adǝm ɵlmigǝn birmu ɵy ⱪalmiƣaqⱪa, xu keqisi Pirǝwnning ɵzi, uning barliⱪ ǝmǝldarliri wǝ barliⱪ misirliⱪlar keqidǝ ornidin ⱪopti; Misir zeminida intayin ⱪattiⱪ pǝryad kɵtürüldi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pirǝwn keqidǝ Musa bilǝn Ⱨarunni qaⱪirtip: — Turunglar, silǝr wǝ Israillar bilǝn billǝ mening hǝlⱪimning arisidin qiⱪip ketinglar; eytⱪininglardǝk berip, Pǝrwǝrdigarƣa ibadǝt ⱪilinglar! ");
INSERT INTO uigpin_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Silǝrning degininglar boyiqǝ ⱪoy, ɵqkǝ, kala padilirinimu elip ketinglar; mǝn üqünmu bǝht-bǝrikǝt tilǝnglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misirliⱪ puⱪralarmu «ⱨǝmmimiz ɵlüp kǝtküdǝkmiz» deyixip, hǝlⱪni zemindin tez qiⱪiriwetix üqün ularni ketixkǝ aldiratti. ");
INSERT INTO uigpin_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hǝlⱪ tehi bolmiƣan hemirlirini elip, uni tǝngnilǝrgǝ selip, kiyim-keqǝkliri bilǝn yɵgǝp, mürilirigǝ elip kɵtürüp mengixti. ");
INSERT INTO uigpin_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israillar Musaning tapiliƣini boyiqǝ ⱪilip, misirliⱪlardin kümüx buyumlar, altun buyumlar wǝ kiyim-keqǝklǝrni sorap elixti. ");
INSERT INTO uigpin_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Pǝrwǝrdigar hǝlⱪni misirliⱪlarning kɵz aldida iltipat tapⱪuzƣini üqün misirliⱪlar ularning ɵzliridin soriƣanlirini bǝrdi; xundaⱪ ⱪilip Israillar misirliⱪlardin ƣǝniymǝtlǝrni elip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Xuning bilǝn Israillar balilarni ⱨesabⱪa almiƣanda altǝ yüz mingqǝ ǝrkǝk bolup, Ramsǝstin qiⱪip, Sukkot xǝⱨirigiqǝ piyadǝ mangdi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ular bilǝn billǝ qong bir top xalƣut hǝlⱪmu ularƣa ⱪoxulup mangdi, yǝnǝ nurƣun qarwilar, kɵpligǝn kala-ⱪoy padiliri bilǝn billǝ qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Misirdin alƣaq qiⱪⱪan hemirdin ular petir nan-toⱪaqlarni ǝtti; qünki ular Misirda birdǝm-yerim dǝm turƣuzulmay ⱨǝydǝlgini üqün hemir bolmiƣanidi; ular ɵzliri üqün yemǝklik tǝyyarliwelixⱪimu ülgürǝlmigǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israillarning Misirda musapir bolup turƣan waⱪti jǝmiy tɵt yüz ottuz yil boldi.    ");
INSERT INTO uigpin_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Xundaⱪ boldiki, xu tɵt yüz ottuz yil toxⱪanda, dǝl xu künidǝ Pǝrwǝrdigarning barliⱪ ⱪoxunliri Misir zeminidin qiⱪip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Xu küni keqidǝ ular Misir zeminidin qiⱪirilƣini üqün, xu keqini ular Pǝrwǝrdigarning keqisi dǝp tutuxi kerǝk; xu keqini barliⱪ Israillar ǝwladtin ǝwladⱪiqǝ Pǝrwǝrdigarƣa atap tutup, tünixi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa mundaⱪ degǝnidi: — Pasha ⱪozisi toƣrisidiki bǝlgilimǝ xu bolsunki: — Ⱨeqⱪandaⱪ yat ǝllik adǝm uningdin yemisun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Lekin ⱨǝrkimning pulƣa setiwalƣan ⱪuli bolsa, u hǝtnǝ ⱪilinsun, andin uningdin yesun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Əmma ɵyünglarda waⱪitliⱪ turuwatⱪan musapir yaki mǝdikar buningdin yesǝ bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Gɵxni baxⱪa bir ɵygǝ elip qiⱪmiƣin; birla ɵydǝ yeyilsun; ⱪozining ⱨeqbir sɵngiki sundurulmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Pütkül Israil jamaiti bu ⱨeytni ɵtküzsun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Əgǝr sening bilǝn birgǝ turƣan musapir bolsa, Pǝrwǝrdigarƣa atap pasha ⱨeytini ɵtküzmǝkqi bolsa, undaⱪta aldi bilǝn barliⱪ ǝrkǝkliri hǝtnǝ ⱪilinsun; andin kelip ⱨeyt ɵtküzsun. U zeminda tuƣulƣan kixidǝk sanalsun. Lekin ⱨeqbir hǝtnisiz adǝm uningdin yemisun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Zeminda tuƣulƣan kixi ⱨǝm aranglarda turƣan musapir üqün ohxax ⱪanun-bǝlgilimǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Xuning bilǝn Israillarning ⱨǝmmisi dǝl Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa buyruƣandǝk xu ixlarni ada ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Xu künning ɵzidǝ Pǝrwǝrdigar Israillarni ⱪoxun-ⱪoxun boyiqǝ Misir zeminidin qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Pǝrwǝrdigar Musaƣa: ");
INSERT INTO uigpin_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","— Israillar arisida baliyatⱪuning barliⱪ tunji ǝrkǝk mewisini, mǝyli u insanning yaki ⱨaywanning bolsun, Manga atap muⱪǝddǝs ⱪilƣin; u Manga mǝnsuptur, degǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa hǝlⱪkǝ mundaⱪ dedi: — Silǝr Misirdin ibarǝt «ⱪulluⱪ makani»din qiⱪⱪan bu künni yad etinglar; qünki Pǝrwǝrdigar silǝrni bu yǝrdin ⱪudrǝtlik ⱪoli bilǝn qiⱪardi. Buning üqün ⱨeq boldurulƣan nǝrsǝ yeyilmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Abib eyining bügünki küni yolƣa qiⱪⱪan kün.    ");
INSERT INTO uigpin_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Əmdi Pǝrwǝrdigar sanga berixkǝ ata-bowiliringƣa ⱪǝsǝm ⱪilƣan, süt bilǝn ⱨǝsǝl eⱪip turidiƣan zeminƣa, yǝni Ⱪanaaniy, Ⱨittiy, Amoriy, Ⱨiwiy wǝ Yǝbusiylarning zeminiƣa seni elip barƣinida muxu Abib eyida xu ibadǝtni tutⱪin. ");
INSERT INTO uigpin_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Yǝttǝ küngiqǝ petir nan yǝnglar; yǝttinqi künidǝ Pǝrwǝrdigarƣa alaⱨidǝ atiƣan ⱨeyt ɵtküzülsun. ");
INSERT INTO uigpin_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Yǝttǝ kün iqidǝ petir nan yeyilsun; silǝrning aranglarda ⱨeqⱪandaⱪ boldurulƣan nan tepilmisun wǝ ya qegriliring iqidǝ ⱨeq hemirturuqmu kɵrünmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Xu küni sǝn ɵz oƣlungƣa: «Misirdin qiⱪⱪinimda Pǝrwǝrdigarning manga kɵrsǝtkǝn iltipatini yad ⱪilip tǝxǝkkur bildürüx üqün, bu ⱨeytni ɵtküzimǝn», dǝp qüxǝndürgin. ");
INSERT INTO uigpin_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Pǝrwǝrdigarning ⱪanun-tǝlimining ⱨǝmixǝ aƣzingdin qüxmǝsliki üqün, bu bǝlgilimini ⱪolungƣa bǝlgǝ ⱪilip seliwal, pexanǝnggǝ ⱪaxⱪidǝk ǝslǝtmǝ ⱪilip ornitiwal; qünki Pǝrwǝrdigar seni ⱪudrǝtlik ⱪoli bilǝn Misirdin qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Əmdi bu bǝlgilimini yilmu-yil bekitilgǝn waⱪtida tutⱪin. ");
INSERT INTO uigpin_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Pǝrwǝrdigar sǝn bilǝn ata-bowiliringƣa ⱪilƣan ⱪǝsimi boyiqǝ seni Ⱪanaaniylarning zeminiƣa elip berip, uni sanga tǝⱪdim ⱪilƣandin keyin, xundaⱪ ⱪilixing kerǝk: — ");
INSERT INTO uigpin_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","barliⱪ baliyatⱪuning tunji mewisini Pǝrwǝrdigarƣa atap sunisǝn; xundaⱪla qarpay melingning ⱨǝmmǝ tunji ǝrkǝklirimu Pǝrwǝrdigarƣa mǝnsup bolsun.    ");
INSERT INTO uigpin_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Əmma exǝklǝrning ⱨǝmmǝ tunjilirining orniƣa birdin ⱪoza bǝrgin. Əgǝr uning orniƣa birnǝrsǝ bǝrmisǝng, uning boynini sunduruwǝtkin. Oƣulliringlar arisida barliⱪ tunjilirining orniƣa ⱨɵrlük bǝdili tɵlüxüng kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Keyinki künlǝrdǝ oƣlung sǝndin: «buning mǝnisi nemidur», dǝp sorisa, sǝn uningƣa jawab berip: «Pǝrwǝrdigar ⱪudrǝtlik ⱪoli bilǝn bizni Misirdin qiⱪirip, «ⱪulluⱪ makani»din azad ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Xundaⱪ boldiki, Pirǝwn boyni ⱪattiⱪliⱪ ⱪilip bizni ⱪoyup berixni rǝt ⱪilƣinida, Pǝrwǝrdigar Misir zeminidiki barliⱪ tunji tuƣulƣanlarni, insanning bolsun, malning bolsun, ⱨǝmmisini urup ɵltürdi; buning üqün mǝn malning baliyatⱪusining tunji mewisini, yǝni ⱨǝmmǝ tunji tuƣulƣan ǝrkǝklirini Pǝrwǝrdigarƣa atap ⱪurbanliⱪ ⱪilip sunimǝn wǝ oƣullirimning ⱨǝrbir tunjiliri üqün ⱨɵrlük bǝdili tɵlǝp berimǝn», dǝp eytⱪin. ");
INSERT INTO uigpin_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Bu bǝlgilimini ⱪolungƣa ǝslǝtmǝ-bǝlgǝ ⱪilip seliwal, pexanǝnggǝ ⱪaxⱪidǝk ǝslǝtmǝ ⱪilip ornitiwal, qünki Pǝrwǝrdigar ⱪudrǝtlik ⱪoli bilǝn bizni Misirdin qiⱪardi» — degin. ");
INSERT INTO uigpin_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Əmma Pirǝwn hǝlⱪni ketixkǝ ⱪoyƣandin keyin, Filistiylǝrning zeminidiki yol yeⱪin bolsimu, Huda ularni xu yol bilǝn baxlimidi; qünki u: «hǝlⱪim jǝnggǝ uqrap ⱪalsa, ⱪorⱪup puxayman ⱪilip, Misirƣa yenip ketixi mumkin» dǝp oyliƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Xu sǝwǝbtin Huda hǝlⱪni aylandurup, Ⱪizil Dengiz tǝrǝptiki qɵlning yoli bilǝn baxlap mangdi. Xundaⱪ ⱪilip Israillar Misirdin qiⱪⱪinida, ⱪorallinip jǝnggǝ tǝyyar bolup tǝrtip bilǝn mangdi. ");
INSERT INTO uigpin_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa Yüsüpning sɵngǝklirinimu billǝ eliwaldi; qünki Yüsüp ǝslidǝ Israilning oƣulliri bolƣan ⱪerindaxlirini: «Huda qoⱪum silǝrni yoⱪlap ⱨalinglardin hǝwǝr alidu; xu qaƣda silǝr mening sɵngǝklirimni muxu yǝrdin billǝ elip ketinglar» dǝp ⱪǝsǝm ⱪildurƣanidi.    ");
INSERT INTO uigpin_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Andin ular Sukkottin qiⱪip, qɵlning qetidiki Etam degǝn yǝrdǝ qedirlirini tikti. ");
INSERT INTO uigpin_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Əmdi Pǝrwǝrdigar ularƣa yol kɵrsitixkǝ kündüzi bir bulut tüwrükidǝ, keqisi yoruⱪluⱪ berixkǝ ot tüwrükidǝ bolup ularning aldida yürǝtti. Xuning bilǝn ular keqǝ-kündüz yol yürǝlǝytti. ");
INSERT INTO uigpin_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Bulut tüwrüki kündüzi, ot tüwrüki keqisi hǝlⱪtin ayrilmay, aldida yürǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Pǝrwǝrdigar Musaƣa: ");
INSERT INTO uigpin_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","— Sǝn Israillarƣa: «Silǝr burulup Migdol bilǝn dengizning ariliⱪidiki Pi-Ⱨaⱨirotning aldiƣa berip qedir tikinglar; Baal-Zefonning udulidiki dengizning boyida qedir tikinglar», degin.    ");
INSERT INTO uigpin_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Xuning bilǝn Pirǝwn: «Israillar zeminda ezip ⱪaldi, qɵlning iqidǝ ⱪamilip ⱪaldi» dǝp oylaydu; ");
INSERT INTO uigpin_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Israillarni ⱪoƣlisun dǝp Mǝn Pirǝwnning kɵnglini ⱪattiⱪ ⱪilimǝn; xundaⱪ ⱪilip, Mǝn Pirǝwn wǝ uning pütkül ⱪoxunliri arⱪiliⱪ Ɵz uluƣluⱪumni ayan ⱪilimǝn; wǝ misirliⱪlar Mening Pǝrwǝrdigar ikǝnlikimni bilidu, — dedi. Israillar Hudaning sɵzi boyiqǝ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","«U hǝlⱪ ⱪeqip kǝtti» dǝp Misirning padixaⱨiƣa hǝwǝr beriliwidi, Pirǝwn bilǝn ǝmǝldarliri hǝlⱪ toƣrisidiki ⱪararidin yenip: «Israillarni ⱪulluⱪtin ⱪoyuwǝtkinimiz, bu zadi nemǝ ⱪilƣinimiz?!» — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pirǝwn dǝrⱨal jǝng ⱨarwisini ⱪoxturup, ɵz hǝlⱪini baxlap yolƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","U yǝnǝ altǝ yüz hillanƣan jǝng ⱨarwisi, xundaⱪla Misirdiki barliⱪ jǝng ⱨarwilirini yiƣdurup, ularning ⱨǝrbirigǝ lǝxkǝr baxliⱪlirini olturƣuzup elip mangdi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Pǝrwǝrdigar Misirning padixaⱨi Pirǝwnning kɵnglini ⱪattiⱪ ⱪilƣini üqün, u Israillarni ⱪoƣlidi. Bu qaƣda Israillar ⱪollirini egiz kɵtürüxkǝn ⱨalda Misirdin qiⱪip bolƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misirliⱪlarning ⱨǝmmisi yǝni Pirǝwnning barliⱪ atliri bilǝn jǝng ⱨarwiliri, atliⱪ lǝxkǝrliri bilǝn pütkül ⱪoxuni ularni ⱪoƣlap, Israillar dengiz boyiƣa qedir tikkǝn jayda, yǝni Pi-Ⱨaⱨirotning yenida, Baal-Zefonning udulida ularƣa yetixti. ");
INSERT INTO uigpin_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Pirǝwn yeⱪinlaxⱪanda, Israillar bexini kɵtürüp ⱪariwidi, mana, misirliⱪlar ularning arⱪisidin yürüx ⱪilip ⱪoƣlap keliwatatti! Xuni kɵrgǝndǝ Israillar tolimu ⱪorⱪuxup, Pǝrwǝrdigarƣa nida-pǝryad kɵtürdi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ular Musaƣa: — Misirda gɵristan tepilmasmidi, sǝn bizni qɵldǝ ɵlsun dǝp muxu yǝrgǝ elip kǝldingƣu?! Bizni Misirdin elip qiⱪip, bizgǝ mundaⱪ ⱪilƣining nemisi?! ");
INSERT INTO uigpin_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Misirda turƣan waⱪtimizda biz sanga: «Bizni misirliⱪlarning ⱪulluⱪida boluximizƣa ⱪoyƣin, biz bilǝn karing bolmisun» dǝp eytmiƣanmiduⱪ? Misirliⱪlarning ⱪulluⱪida bolƣinimiz qɵlgǝ kelip ɵlginimizdin ǝwzǝl bolatti! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Buning bilǝn Musa hǝlⱪⱪǝ: — Ⱪorⱪmay, tik turunglar, Pǝrwǝrdigarning bügün silǝrgǝ yürgüzidiƣan nijatini kɵrisilǝr; qünki silǝr bügün kɵrgǝn misirliⱪlarni ikkinqi kɵrmǝysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Pǝrwǝrdigar silǝr üqün jǝng ⱪilidu, lekin silǝr bolsanglar jim tursanglarla boldi, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Andin Pǝrwǝrdigar Musaƣa: — Nemixⱪa sǝn Manga pǝryad kɵtürisǝn? Israillarƣa: «Aldiƣa menginglar» dǝp buyruƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Lekin sǝn ⱨasangni kɵtürüp ⱪolungni dengizƣa uzitip, uni ikkigǝ bɵlgin; xundaⱪta, Israillar dengizning otturisidin ⱪuruⱪ yǝr bilǝn ɵtüp ketidu. ");
INSERT INTO uigpin_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mana, Mǝn ularni ⱪoƣlisun dǝp misirliⱪlarning kɵngüllirini ⱪattiⱪ ⱪilimǝn, xuning bilǝn Mǝn Pirǝwn wǝ uning pütkül ⱪoxuni, jǝng ⱨarwiliri wǝ atliⱪliri arⱪiliⱪ Ɵz uluƣluⱪimni ayan ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Xundaⱪ ⱪilip, Mǝn Pirǝwn wǝ uning jǝng ⱨarwiliri wǝ atliⱪliri arⱪiliⱪ Ɵz uluƣluⱪimni ayan ⱪilƣinimda, misirliⱪlar Mening Pǝrwǝrdigar ikǝnlikimni bilidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Israilning ⱪoxunining aldida yürüwatⱪan Hudaning Pǝrixtisi ǝmdi ularning kǝynigǝ ɵtti; xuningdǝk ularning aldida mangƣan bulut tüwrükimu ularning kǝynigǝ yɵtkilip, ");
INSERT INTO uigpin_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","misirliⱪlarning qedirgaⱨi bilǝn Israilning qedirgaⱨining ariliⱪida tohtidi; bu bulut bir tǝrǝptǝ ⱪarangƣuluⱪ qüxürüp, yǝnǝ bir tǝrǝptǝ keqini yorutti. Buning bilǝn pütün bir keqǝ bir ⱪoxun yǝnǝ bir ⱪoxunƣa yeⱪin kelǝlmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa ⱪolini dengizning üstigǝ uzatti; Pǝrwǝrdigar pütün keqǝ xǝrⱪtin küqlük bir xamal qiⱪirip, dengizning süyini kǝynigǝ yandurdi; U suni yandurup dengizni ⱪuruⱪ yǝr ⱪildi, sular ikkigǝ bɵlündi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Xu tǝriⱪidǝ Israillar dengizning otturisidiki ⱪuruⱪ yǝrdin mengip, ɵtüp kǝtti; sular bolsa ularning ong wǝ sol yenida kɵtürülüp tamdǝk turatti.    ");
INSERT INTO uigpin_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Əmma misirliⱪlar ularni ⱪoƣlap keliwatatti — Pirǝwnning barliⱪ atliri, jǝng ⱨarwiliri wǝ atliⱪ lǝxkǝrliri ularning kǝynidin dengizning otturisiƣiqǝ kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Tang atⱪanda xundaⱪ boldiki, Pǝrwǝrdigar ot bilǝn bulut tüwrükidǝ turup misirliⱪlarning ⱪoxuniƣa ⱪaridi wǝ misirliⱪlarning ⱪoxuniƣa parakǝndiqilik qüxürdi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","U ularning ⱨarwilirining qaⱪlirini patⱪuzup, ⱨǝydǝp mengixini müxkül ⱪildi. Misirliⱪlar: — Yürünglar, Israilning aldidin ⱪaqayli, qünki Pǝrwǝrdigar ular üqün misirliⱪlarƣa ⱪarxi jǝng ⱪiliwatidu, — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Pǝrwǝrdigar Musaƣa: — Sular yenip misirliⱪlarning üstigǝ, ularning jǝng ⱨarwilirining üstigǝ wǝ atliⱪlirining üstigǝ eⱪip berip, ularni qɵktürüwǝtsun dǝp ⱪolungni dengizning üstigǝ uzatⱪin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa ⱪolini dengizning üstigǝ uzitiwidi, tang atⱪanda dengizning süyi yǝnǝ ǝsliy ⱨalitigǝ yenip kǝldi. Ⱪeqiwatⱪan misirliⱪlar eⱪinƣa ⱪarxi yügürüxti, Pǝrwǝrdigar ularni dengizning otturisida mollaⱪ atⱪuzdi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Su ǝsligǝ yenip kelip, jǝng ⱨarwiliri bilǝn atliⱪlarni, yǝni Israillarning arⱪidin ⱪoƣlap dengizƣa kirgǝn Pirǝwnning pütkül ⱪoxunini ƣǝrⱪ ⱪiliwǝtti; ulardin birimu saⱪ ⱪalmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Lekin Israillar dengizning otturisidiki ⱪuruⱪ yǝr bilǝn mengip ɵtüp kǝtti; sular ularning ong wǝ sol yenida kɵtürülüp tamdǝk turatti. ");
INSERT INTO uigpin_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Xu tǝriⱪidǝ Pǝrwǝrdigar u küni Israillarni misirliⱪlarning ⱪolidin ⱪutⱪuzdi; Israillar misirliⱪlarning dengizning boyida ɵlük yatⱪinini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israil hǝlⱪi Pǝrwǝrdigarning misirliⱪlarƣa ixlǝtkǝn zor ⱪudritini kɵrüp, Pǝrwǝrdigardin ⱪorⱪti; ular Pǝrwǝrdigarƣa wǝ uning ⱪuli Musaƣa ixǝndi. ");
INSERT INTO uigpin_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Xu qaƣda Musa bilǝn Israillar Pǝrwǝrdigarƣa mǝdⱨiyǝ oⱪup munu küyni eytti: — «Mǝn Pǝrwǝrdigarni mǝdⱨiyilǝp küy eytay, Qünki U karamǝt uluƣluⱪini kɵrsǝtti; U at wǝ mingüqini dengizƣa taxliwǝtti.    ");
INSERT INTO uigpin_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mening küqüm ⱨǝm mening küyüm Yaⱨ Ɵzidur; U manga nijat boldi; U mening Tǝngrimdur, mǝn Uni uluƣlaymǝn; U mening atamning Hudasidur, mǝn Uni aliy dǝp mǝdⱨiyilǝymǝn.    ");
INSERT INTO uigpin_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Pǝrwǝrdigar jǝngqidur, Yaⱨwǝⱨ Uning namidur. ");
INSERT INTO uigpin_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Pirǝwnning jǝng ⱨarwilirini ⱨǝm ⱪoxunlirini dengizƣa taxliwǝtti; Uning aliy lǝxkǝr baxliⱪliri Ⱪizil Dengizda ƣǝrⱪ ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Qongⱪur sular ularni kɵmüwǝtti, Ular huddi taxtǝk dengiz tegigǝ qɵküp kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Sening ong ⱪolung, ǝy Pǝrwǝrdigar, Ⱪudriti bilǝn xan-xǝrǝp tapti; Sening ong ⱪolung, ǝy Pǝrwǝrdigar, Düxmǝnni kukum-talⱪan ⱪiliwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ɵz uluƣluⱪungning ⱨǝywisi bilǝn Ɵzünggǝ ⱪarxi qiⱪⱪanlarni nabut ⱪilding, Sǝn otluⱪ ƣǝzipingni ǝwǝtting, U samanni kɵydürgǝn ottǝk ularni yutuwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Dimiƣingning nǝpisi bilǝn sular dɵng bolup ɵrlidi, Juxⱪunliƣan dolⱪunlar dɵng kǝbi tik turdi, Dengizning otturisidiki qongⱪur sular ⱪaturup ⱪoyuldi.    ");
INSERT INTO uigpin_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Düxmǝn dedi: «Mǝn ularni ⱪoƣlaymǝn, yetiximǝn, olja elip ülǝxtürimǝn, Ulardin dǝrdimni qiⱪirimǝn, Ⱪiliqimni suƣurup, ɵz ⱪolum bilǝn ularni nabut ⱪilimǝn». ");
INSERT INTO uigpin_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Lekin Sǝn nǝpising bilǝn püwliding, Dengiz ularni kɵmüwǝtti; Ular juxⱪunluⱪ sularda ⱪoƣuxundǝk qɵküp kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ilaⱨlarning arisida, ǝy Pǝrwǝrdigar, Kim Sening tǝngdixing bolsun? Pak-muⱪǝddǝslik iqidǝ Ɵz ⱨǝywitingni kɵrsitidiƣan, Ⱨǝmd-mǝdⱨiyilǝr arisida dǝⱨxǝtlik turidiƣan, Mɵjizǝ-karamǝt yaritidiƣan, Sǝndǝk kim bolsun? ");
INSERT INTO uigpin_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Sǝn ong ⱪolungni uzitixing bilǝn, Yǝr-zemin ularni yutuwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Lekin Ɵzünggǝ ⱨǝmjǝmǝt ⱪilip ⱪutⱪuzƣan ⱪowmni rǝⱨimdilliⱪing bilǝn baxlap qiⱪting; Sǝn ularni Ɵz muⱪǝddǝs makaningƣa ⱪudriting bilǝn ⱨidayǝt ⱪilip yetǝkliding. ");
INSERT INTO uigpin_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Yat hǝlⱪlǝr buni anglap, titrixip kǝtti; Filistiyǝdǝ turuwatⱪanlarni tolƣaⱪtǝk azab tutti. ");
INSERT INTO uigpin_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Andin Edomning ǝmirliri dǝkkǝ-dükkigǝ qüxti; Moabning palwanlirini bolsa, rasa titrǝk basti; Ⱪanaan zeminidikilǝrning yüriki su bolup aⱪti; ");
INSERT INTO uigpin_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ⱪorⱪunq wǝ dǝⱨxǝt ularni basti; Bilikingning ⱨǝywiti bilǝn ular huddi taxtǝk midirliyalmay ⱪaldi; Hǝlⱪing ɵtüp kǝtküqǝ, i Pǝrwǝrdigar, Ɵzüng rǝnǝ tɵlǝp ⱨɵr ⱪilƣan hǝlⱪing ɵtüp bolƣuqǝ.    ");
INSERT INTO uigpin_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ularni baxlap kirip, Ɵz mirasing bolƣan taƣda kɵqǝttǝk tikisǝn, Ɵz makaning ⱪilƣan jayƣa, i Pǝrwǝrdigar, Ɵz ⱪolliring tǝyyarliƣan muⱪǝddǝs jayƣa, i Rǝb, ularni elip barisǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Pǝrwǝrdigar ǝbǝdil’ǝbǝdgiqǝ padixaⱨ bolup ⱨɵküm süridu! ");
INSERT INTO uigpin_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Qünki Pirǝwnning atliri, Jǝng ⱨarwiliri atliⱪliri bilǝn billǝ dengizƣa kirip boldi; Pǝrwǝrdigar dengizning sulirini ularning üstigǝ yandurdi, Lekin Israillar bolsa dengizning otturisidin ⱪuruⱪ yǝrdin mengip ɵtüp kǝtti». ");
INSERT INTO uigpin_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Andin Ⱨarunning ⱨǝdisi pǝyƣǝmbǝr Mǝryǝm ⱪoliƣa dapni aldi, barliⱪ ⱪiz-ayallarmu ⱪoliƣa dap elip, ussul oynixip uningƣa ǝgǝxti. ");
INSERT INTO uigpin_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mǝryǝm ularƣa jawabǝn mundaⱪ küyni oⱪudi: — «Pǝrwǝrdigarni mǝdⱨiyilǝp küy eytinglar, Qünki U zor uluƣluⱪini kɵrsǝtti; U at wǝ mingüqini dengizƣa taxliwǝtti!». ");
INSERT INTO uigpin_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Andin Musa Israillarni Ⱪizil Dengizdin baxlap, Xur qɵligǝ elip bardi. Ular uda üq kün qɵldǝ yürüp, su tapalmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Andin ular Maraⱨⱪa yetip kǝldi; lekin u yǝrning süyi aqqiⱪ bolup, süyini iqkili bolmaytti; xunga u jayning nami «Maraⱨ» dǝp ⱪoyulƣan.    ");
INSERT INTO uigpin_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","U waⱪitta halayiⱪ: — Biz nemǝ iqimiz? — dǝp Musadin aƣrinip ƣotuldaxⱪili turdi. ");
INSERT INTO uigpin_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","U Pǝrwǝrdigarƣa pǝryad kɵtürdi; Pǝrwǝrdigar uningƣa bir dǝrǝhni kɵrsǝtti; u dǝrǝh yaƣiqini elip, suƣa taxliwidi, su tatliⱪ suƣa aylandi. U yǝrdǝ Pǝrwǝrdigar ularƣa ⱨɵküm-bǝlgilimǝ bekitip, ularni sinap, mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","«Əgǝr silǝr kɵngül ⱪoyup Hudayinglar Pǝrwǝrdigarning sɵzini anglap, Uning nǝziridǝ durus bolƣanni ⱪilip, ǝmrlirigǝ ⱪulaⱪ selip, barliⱪ ⱨɵkümlirini tutsanglar, undaⱪta, Mǝn misirliⱪlarning üstigǝ salƣan kesǝllǝrdin ⱨeqbirini üstünggǝ salmaymǝn; qünki Mǝnki silǝrgǝ xipaliⱪ bǝrgüqi Pǝrwǝrdigardurmǝn». ");
INSERT INTO uigpin_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Andin ular Elimƣa yetip kǝldi. Xu yǝrdǝ on ikki bulaⱪ bilǝn yǝtmix horma dǝrihi bar idi; ular xu yǝrdǝ sularning boyida qedir tikti. ");
INSERT INTO uigpin_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Andin Israillarning pütkül jamaiti Elimdin yolƣa atlandi; Misir zeminidin qiⱪip, ikkinqi eyining on bǝxinqi künidǝ Elim bilǝn Sinayning otturisidiki Sin qɵligǝ yetip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Əmma Israillarning pütkül jamaiti qɵldǝ Musa bilǝn Ⱨarunning yaman gepini ⱪilip ƣotuldaxⱪili turdi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israillar ularƣa: — Pǝrwǝrdigarning ⱪoli bizni Misir yurtidila ɵltürüwǝtkǝn bolsa bolmasmidi! Xu yǝrdǝ biz gɵx ⱪaynawatⱪan ⱪazanlarni qɵridǝp olturup, toyƣudǝk nan yemigǝnmiduⱪ? Lekin silǝr bu jamaǝtning ⱨǝmmisini aqliⱪ bilǝn ɵltürmǝkqi bolup bizni bu qɵlgǝ elip kǝldinglar! — deyixti.    ");
INSERT INTO uigpin_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Buning bilǝn Pǝrwǝrdigar Musaƣa: — Mana, Mǝn asmandin silǝrgǝ nan yaƣdurimǝn; xuning bilǝn hǝlⱪ ⱨǝr küni qiⱪip, bir künlük lazimliⱪini yiƣiwalsun. Bu tǝriⱪidǝ Mǝn ularning Mening ⱪanun-ǝmrlirimdǝ mangidiƣan-mangmaydiƣanliⱪini sinaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ⱨǝr ⱨǝptining altinqi küni xundaⱪ boliduki, ular yiƣiwalƣanlirini tǝyyarlisun; u baxⱪa künlǝrdǝ erixidiƣinidin bir ⱨǝssǝ kɵp bolidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Andin Musa bilǝn Ⱨarun barliⱪ Israillarƣa: — Bügün ahxam silǝrni Misir zeminidin elip qiⱪⱪuqining Pǝrwǝrdigar ikǝnlikini bilisilǝr wǝ ");
INSERT INTO uigpin_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ǝtǝ silǝr Pǝrwǝrdigarning xan-xǝripini kɵrisilǝr; qünki U silǝrning Uning yaman gepini ⱪilip ƣotuldaxⱪininglarni anglidi; bizgǝ kǝlsǝk, silǝr yaman gepimizni ⱪilip ƣotuldiƣudǝk biz kim iduⱪ? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa yǝnǝ: Pǝrwǝrdigar bügün ahxam silǝrgǝ yegili gɵx berip, ǝtǝ ǝtigǝndǝ toyƣudǝk nan bǝrgǝndǝ buni bilisilǝr; qünki Pǝrwǝrdigar silǝr Uning yaman gepini ⱪilip ƣotuldiƣininglarni anglidi. Əmdi biz nemǝ iduⱪ? Silǝrning ƣotuldaxⱪininglar bizlǝrgǝ ⱪaritilƣan ǝmǝs, bǝlki Pǝrwǝrdigarƣa ⱪaritilƣandur, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Andin Musa Ⱨarunƣa: — Sǝn Israillarning pütkül jamaitigǝ: «Pǝrwǝrdigarning aldiƣa kelinglar; qünki U yaman gǝp bilǝn ƣotuldaxⱪininglarni anglidi», dǝp eytⱪin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Xundaⱪ boldiki, Ⱨarun Israillarning pütkül jamaitigǝ sɵzlǝp turƣinida, ular qɵl tǝrǝpkǝ ⱪariwidi, mana, Pǝrwǝrdigarning julasi bulutta ayan boldi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Xuning bilǝn Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","— Mǝn Israillarning yaman gǝp ⱪilip ƣotuldaxⱪinini anglidim; ǝmdi ularƣa: «Gugumda silǝr gɵx yǝysilǝr wǝ ǝtigǝndǝ nandin toyunisilǝr, xuning bilǝn silǝr Mening Pǝrwǝrdigar Hudayinglar ikǝnlikimni bilip yetisilǝr» — dǝp eytⱪin, dedi.    ");
INSERT INTO uigpin_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kǝqⱪurunda xundaⱪ boldiki, bɵdünilǝr uqup kelip, qedirgaⱨni ⱪaplap kǝtti; ǝtisi ǝtigǝndǝ, qedirgaⱨning ǝtrapidiki yǝrlǝrgǝ xǝbnǝm qüxkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ətrapta yatⱪan xǝbnǝm kɵtürülüp kǝtkǝndin keyin, mana, qɵllükning yǝr yüzidǝ ⱪirawdǝk nepiz, kiqik-kiqik yumilaⱪ nǝrsilǝr turatti. ");
INSERT INTO uigpin_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israillar uni kɵrgǝndǝ, uning nemǝ ikǝnlikini bilmigini üqün: — Bu nemidu? — dǝp soraxti. Musa ularƣa jawabǝn: — Bu Pǝrwǝrdigar silǝrgǝ ata ⱪilƣan ozuⱪ-tülüktur. ");
INSERT INTO uigpin_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Pǝrwǝrdigar xu ixni ǝmr ⱪilip dediki, «Ⱨǝrbiringlar yǝydiƣininglarƣa ⱪarap uningdin yiƣiwelinglar; ⱨǝrbiringlar ailidiki adǝm saniƣa ⱪarap, ⱨǝrbir adǝmgǝ bir omǝr miⱪdarda yiƣinglar; ⱨǝr adǝm ɵz qediridiki kixilǝr üqün yiƣinglar» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israillar xundaⱪ ⱪilip, bǝzisi kɵprǝk, bǝzisi azraⱪ yiƣiwaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ular uni omǝr miⱪdari bilǝn ɵlqiwidi, kɵp yiƣⱪanlarningkidin exip kǝtmidi, az yiƣⱪanlarningmu kǝmlik ⱪilmidi; ⱨǝrbir kixi ɵz yǝydiƣiniƣa ⱪarap yiƣⱪanidi.    ");
INSERT INTO uigpin_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa ularƣa: — Ⱨeqⱪandaⱪ adǝm bulardin ⱨeqnemini ǝtigǝ ⱪaldurmisun, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Xundaⱪ bolsimu, ular Musaning sɵzigǝ ⱪulaⱪ salmidi; bǝzilǝr uningdin bir ⱪismini ǝtigǝ saⱪlap ⱪoydi. Əmma saⱪlap ⱪoyƣini ⱪurtlap sesip kǝtti. Bu ix üqün Musa ularƣa hapa bolup aqqiⱪlandi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Xu sǝwǝbtin ularning ⱨǝrbiri ⱨǝr ǝtigini qiⱪip ɵz yǝydiƣiniƣa ⱪarap yiƣiwalatti; ⱪalƣanliri bolsa aptap qiⱪⱪanda erip ketǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Lekin altinqi küni xundaⱪ boldiki, ular künlük ozuⱪning ikki ⱨǝssisini yiƣdi; demǝk, ⱨǝrbir kixi üqün ikki omǝr miⱪdarda yiƣiwaldi; andin jamaǝt ǝmirliri ⱨǝmmisi kelip buni Musaƣa eytti. ");
INSERT INTO uigpin_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa ularƣa: — Mana Pǝrwǝrdigarning degini: — Ətǝ aram küni, Pǝrwǝrdigarƣa atalƣan muⱪǝddǝs xabat küni bolidu; pixuridiƣininglarni pixurup, ⱪaynitidiƣininglarni ⱪayinitip, exip ⱪalƣanning ⱨǝmmisini ǝtigǝ saⱪlap ⱪoyunglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ular Musa buyruƣandǝk, exip ⱪalƣanni ǝtisigǝ saⱪlap ⱪoyuwidi, ular sesip ⱪalmidi, ⱪurutlapmu kǝtmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa ularƣa: — Buni bügün yǝnglar; qünki bügün Pǝrwǝrdigarƣa atalƣan xabat küni bolƣini üqün bügün daladin tapalmaysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Altǝ kün silǝr yiƣsanglar bolidu; lekin yǝttinqi küni xabat bolƣini üqün u künidǝ ⱨeqnemǝ tepilmaydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ⱨalbuki, yǝttinqi küni hǝlⱪtin birnǝqqisi ozuⱪ-tülük yiƣⱪili qiⱪiwidi, ⱨeqnemǝ tapalmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Pǝrwǝrdigar Musaƣa: «Silǝr ⱪaqanƣiqǝ Mening ǝmrlirim wǝ ⱪanun-bǝlgilimilirimni tutuxni rǝt ⱪilisilǝr? ");
INSERT INTO uigpin_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mana, Pǝrwǝrdigar silǝrgǝ xabat künini bekitip bǝrdi; xunga yǝttinqi küni ⱨǝrbiringlarni ɵz ornida turup, sirtlarƣa qiⱪmisun dǝp, altinqi küni ikki künlük ozuⱪ beridu», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Xuning bilǝn hǝlⱪ yǝttinqi küni aram aldi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israillar bu ozuⱪni «manna» dǝp atidi; uning xǝkli yumƣaⱪsüt uruⱪidǝk, rǝnggi aⱪ bolup, tǝmi ⱨǝsǝlgǝ milǝngǝn ⱪoturmaqⱪa ohxaytti.    ");
INSERT INTO uigpin_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa ularƣa: — Pǝrwǝrdigarning ǝmri xuki, — Keyinki ǝwladliringlarƣa Mǝn silǝrni Misirdin elip qiⱪⱪanda, Mǝn silǝrgǝ qɵldǝ yeyixkǝ ata ⱪilƣan nanni kɵrsitix üqün, uningdin komzǝkkǝ bir omǝr toxⱪuzup, ular üqün saⱪlap ⱪoyunglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa Ⱨarunƣa: — Kǝlgüsi ǝwladliringlarƣa kɵrsitixkǝ saⱪlax üqün bir komzǝkni elip, uningƣa bir omǝr miⱪdarda manna selip, Pǝrwǝrdigarning ⱨuzurida ⱪoyup ⱪoyƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Keyin, Ⱨarun Pǝrwǝrdigar Musaƣa buyruƣandǝk komzǝkni saⱪlax üqün uni ⱨɵküm-guwaⱨliⱪ sanduⱪining aldida ⱪoyup ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Xu tǝriⱪidǝ Israillar adǝm olturaⱪlaxⱪan bir zeminƣa yetip kǝlgüqǝ ⱪiriⱪ yil «manna» yedi; ular Ⱪanaan zeminining qegraliriƣa yǝtküqǝ manna yedi. ");
INSERT INTO uigpin_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Əyni qaƣda bir «omǝr» «ǝfaⱨ»ning ondin birigǝ barawǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Andin pütkül Israil jamaiti ⱪopup, Sin qɵlidin qiⱪip, Pǝrwǝrdigarning ǝmri boyiqǝ sǝpǝr ⱪilip, Rǝfidim degǝn yǝrgǝ kelip qedirlirini tikti. Əmma u yǝrdǝ hǝlⱪⱪǝ iqkili su yoⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Xuning bilǝn hǝlⱪ Musa bilǝn jedǝllixip: — Bizgǝ iqkili su bǝrgin! — dedi. Lekin Musa ularƣa: — Nemixⱪa mening bilǝn jedǝllixisilǝr? Nemixⱪa Pǝrwǝrdigarni sinaysilǝr? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Lekin hǝlⱪ qangⱪap, su tǝlǝp ⱪilip, Musadin aƣrinip ƣotuldixip: — Sǝn nemixⱪa bizni, balilirimizni wǝ melimizni ussuzluⱪ bilǝn ɵltürüxkǝ Misirdin elip kǝlding? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Xuning bilǝn Musa Pǝrwǝrdigarƣa pǝryad kɵtürüp: — Bu hǝlⱪni ⱪandaⱪ ⱪilsam bolar?! Ular ⱨelila meni qalma-kesǝk ⱪilixi mumkin! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Pǝrwǝrdigar Musaƣa jawabǝn: — Sǝn Israilning aⱪsaⱪalliridin birnǝqqisini ɵzüng bilǝn billǝ elip qiⱪip, Nil dǝryasining süyini urƣiningda ixlǝtkǝn ⱨasangni ⱪolungƣa elip hǝlⱪning aldiƣa barƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mana, Mǝn xu yǝrdǝ, Ⱨorǝb teƣidiki ⱪoram taxning üstidǝ sening aldingda turimǝn; sǝn ⱪoram taxni urƣin. Buning bilǝn uningdin hǝlⱪⱪǝ iqkili su qiⱪidu, — dedi. Musa Israilning aⱪsaⱪallirining kɵz aldida xundaⱪ ⱪildi.    ");
INSERT INTO uigpin_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa Israillarning jedǝllǝxkini wǝ ularning «Pǝrwǝrdigar zadi arimizda barmu-yoⱪmu?» deyixip Pǝrwǝrdigarni siniƣini üqün, u yǝrni «Massaⱨ» wǝ «Mǝribaⱨ» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Xu qaƣda Amalǝklǝr kelip Rǝfidimdǝ Israilƣa ⱨujum ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa Yǝxuaƣa: Sǝn ɵzimizdin Amalǝk bilǝn jǝng ⱪilixⱪa adǝm talliƣin. Mǝn ǝtǝ Hudaning ⱨasisini ⱪolumƣa elip dɵngning qoⱪⱪisida turup turimǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yǝxua Musa buyruƣinidǝk ⱪilip, Amalǝklǝr bilǝn jǝng ⱪildi. Musa, Ⱨarun wǝ Hur dɵngning qoⱪⱪisiƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Xundaⱪ boldiki, Musa ⱪolini kɵtürüp tursa, Israil ƣalib kelǝtti, lekin u ⱪollirini pǝskǝ qüxürüp tursa, Amalǝk ƣalib kelǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Musaning ⱪolliri eƣirlixip kǝtti; ular bir taxni elip kelip uning astiƣa ⱪoydi; u uning üstidǝ olturdi; andin Ⱨarun bilǝn Hur biri bir tǝripidǝ, biri yǝnǝ bir tǝripidǝ uning ⱪollirini yɵlǝp turdi; bu tǝriⱪidǝ uning ⱪolliri taki kün patⱪuqǝ mǝzmut turdi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Xundaⱪ ⱪilip, Yǝxua Amalǝk wǝ uning hǝlⱪini ⱪiliqlap nabut ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Pǝrwǝrdigar Musaƣa: — Bir ǝslimǝ bolsun dǝp bu ixlarni bir kitabⱪa yezip ⱪaldurƣin, xundaⱪla xularni Yǝxuaning ⱪulaⱪliriƣa oⱪup bǝr; qünki Mǝn Amalǝkning namini asmanlarning astidin, ⱨǝtta adǝmlǝrning esidinmu mutlǝⱪ ɵqürüwetimǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Andin Musa bir ⱪurbangaⱨni yasap, namini «Pǝrwǝrdigar tuƣumdur» dǝp atidi ");
INSERT INTO uigpin_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","wǝ Musa: — Yaⱨning tǝhti aldida bir ⱪol kɵtürülüp: — «Pǝrwǝrdigar ǝwladtin ǝwladⱪiqǝ Amalǝkkǝ ⱪarxi jǝng ⱪilidu» deyilgǝnidi, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Musaning ⱪeynatisi, yǝni Midiyanning kaⱨini Yǝtro Hudaning Musa üqün ⱨǝmdǝ Ɵz hǝlⱪi Israil üqün barliⱪ ⱪilƣanliri toƣruluⱪ anglidi, yǝni Pǝrwǝrdigarning Israilni Misirdin qiⱪarƣanliⱪidin hǝwǝr tapti. ");
INSERT INTO uigpin_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Xuning bilǝn Musaning ⱪeynatisi Yǝtro Musaning ǝslidǝ ɵz yeniƣa ǝwǝtiwǝtkǝn ayali Zipporaⱨ wǝ uning ikki oƣlini elip yolƣa qiⱪti (birinqi oƣlining ismi Gǝrxom dǝp ⱪoyulƣanidi; qünki Musa: «mǝn yaⱪa yurtta musapir bolup turuwatimǝn» degǝnidi.    ");
INSERT INTO uigpin_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Yǝnǝ birining ismi Əliezǝr dǝp ⱪoyulƣanidi; qünki Musa: «Atamning Hudasi manga yardǝmdǝ bolup, meni Pirǝwnning ⱪiliqidin ⱪutⱪuzdi», degǝnidi). ");
INSERT INTO uigpin_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Xundaⱪ ⱪilip Musaning ⱪeynatisi Yǝtro Musaning oƣulliri bilǝn ayalini elip, Musaning qɵldǝ, Hudaning teƣining yenida qedir tikkǝn yerigǝ yetip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","U ǝslidǝ Musaƣa: — «Mana, mǝnki ⱪeynatang Yǝtro sening ayalingni wǝ uning ikki oƣlini elip yeningƣa ketiwatimǝn» dǝp hǝwǝr ǝwǝtkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Xuning bilǝn Musa ɵz ⱪeynatisining aldiƣa qiⱪip, tǝzim ⱪilip, uni sɵydi. Ular bir-biridin ⱨal-ǝⱨwal sorixip qedirƣa kirdi; ");
INSERT INTO uigpin_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Andin Musa ⱪiynatisiƣa Israilning wǝjidin Pǝrwǝrdigarning Pirǝwn wǝ misirliⱪlarƣa ⱪilƣan ⱨǝmmǝ ǝmǝllirini sɵzlǝp, ularning yol boyi bexiƣa qüxkǝn jǝbir-japalarni bayan ⱪilip, Pǝrwǝrdigarning ⱪandaⱪ ⱪilip ularni ⱪutⱪuzƣinini eytip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Buni anglap Yǝtro Pǝrwǝrdigarning Israilƣa kɵrsǝtkǝn barliⱪ yahxiliⱪidin, ularni misirliⱪlarning ⱪolidin ⱪutⱪuzƣanliⱪidin xadlandi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yǝtro xadlinip: — Silǝrni misirliⱪlarning wǝ Pirǝwnning ⱪolidin ⱪutⱪuzƣan Pǝrwǝrdigarƣa tǝxǝkkurlǝr bolƣay! U bu ⱪowmni misirliⱪlarning ⱪolidin ⱪutⱪuzdi! ");
INSERT INTO uigpin_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Mǝn Pǝrwǝrdigarning barliⱪ ilaⱨlardin üstün turidiƣanliⱪini ǝmdi bildim; qünki U dǝl ular yoƣanqiliⱪ ⱪilƣan ixta Ɵzining ulardin üstün turidiƣanliⱪini namayan ⱪildi — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Andin Musaning ⱪeynatisi Yǝtro Hudaƣa atap bir kɵydürmǝ ⱪurbanliⱪ wǝ birnǝqqǝ tǝxǝkkur ⱪurbanliⱪlirini elip kǝldi; Ⱨarun bilǝn Israilning ⱨǝrbir aⱪsaⱪili Musaning ⱪeynatisi bilǝn billǝ Hudaning ⱨuzurida taam yeyixkǝ kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ətisi Musa hǝlⱪning ix-dǝwaliri üstidin ⱨɵküm qiⱪirixⱪa olturdi; hǝlⱪ ǝtigǝndin tartip kǝqkiqǝ Musaning qɵrisidǝ turuxti. ");
INSERT INTO uigpin_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Musaning ⱪeynatisi uning hǝlⱪi üqün ⱪilƣan ixlirini kɵrgǝndǝ uningdin: — Sening hǝlⱪⱪǝ ⱪiliwatⱪan bu ixing zadi nemǝ ix? Nemixⱪa sǝn bu ixta yalƣuz olturisǝn, barliⱪ hǝlⱪ nemǝ üqün ǝtigǝndin kǝqkiqǝ sening qɵrǝngdǝ turidu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa ⱪeynatisiƣa jawab berip: — Hǝlⱪ Hudadin yol izdǝxkǝ mening ⱪeximƣa kelidu. ");
INSERT INTO uigpin_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ⱪaqanki ularning bir ix-dǝwasi qiⱪsa ular yenimƣa kelidu; xuning bilǝn mǝn ularning otturisida ⱨɵküm qiⱪirimǝn wǝ xundaⱪla Hudaning ⱪanun-bǝlgilimilirini ularƣa bildürimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Musaning ⱪeynatisi uningƣa: — Bu ⱪilƣining yahxi bolmaptu. ");
INSERT INTO uigpin_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Sǝn jǝzmǝn ɵzüngni ⱨǝmdǝ qɵrǝngdǝ turƣan hǝlⱪnimu qarqitip ⱪoyisǝn; qünki bu ix sanga bǝk eƣir kelidu. Sǝn uni yalƣuz ⱪilip yetixǝlmǝysǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Əmdi mening sɵzümgǝ ⱪulaⱪ salƣin, mǝn sanga bir mǝsliⱨǝt berǝy wǝ xundaⱪ ⱪilsang, Huda sening bilǝn billǝ bolidu: — Sǝn ɵzüng Hudaning aldida hǝlⱪning wǝkili bolup, ularning ixlirini Hudaƣa mǝlum ⱪilƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","sǝn hǝlⱪⱪǝ ⱪanun-bǝlgilimilǝrni ɵgitip, mangidiƣan yolni kɵrsitip, ularning ⱪandaⱪ burqi barliⱪini uⱪturƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Xuning bilǝn bir waⱪitta sǝn pütkül hǝlⱪning arisidin Hudadin ⱪorⱪidiƣan, nǝpsaniyǝtqilikni yaman kɵridiƣan ⱨǝm ⱪabiliyǝtlik ⱨǝm diyanǝtlik adǝmlǝrni tepip, ularni hǝlⱪning üstigǝ bax ⱪilip, bǝzisini mingbexi, bǝzisini yüzbexi, bǝzisini ǝllikbexi, bǝzisini onbexi ⱪilip tǝyinligin. ");
INSERT INTO uigpin_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Xuning bilǝn bular ⱨǝrⱪandaⱪ waⱪitta hǝlⱪning ix-dǝwalirini soraydu. Əgǝr qong bir ix-dǝwa qiⱪip ⱪalsa, buni sanga tapxursun; lekin ⱨǝmmǝ kiqik ix-dǝwalarni ular ɵzliri bejirisun. Xundaⱪ ⱪilip, ular sening wǝzipǝngni yeniklitip, yüküngni kɵtürüxüp beridu. ");
INSERT INTO uigpin_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Əgǝr xundaⱪ ⱪilsang wǝ Huda sanga xundaⱪ buyrusa, ɵzüng wǝzipǝngdǝ put tirǝp turalaysǝn wǝ hǝlⱪingmu hatirjǝmlik bilǝn ɵz jayiƣa ⱪaytip ketidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa ⱪeynatisining sɵzigǝ ⱪulaⱪ selip deginining ⱨǝmmisini ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa pütkül Israil arisidin ⱪabiliyǝtlik adǝmlǝrni tallap, ularni hǝlⱪning üstigǝ bax ⱪilip, bǝzisini mingbexi, bǝzisini yüzbexi, bǝzisini ǝllikbexi, bǝzisini onbexi ⱪilip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Bular ⱨǝrⱪandaⱪ waⱪitta hǝlⱪning ix-dǝwalirini sorap turdi; tǝsrǝk ix-dǝwalarni bolsa, Musaƣa yollaytti, kiqik ix-dǝwalarni bolsa ɵzliri soraytti. ");
INSERT INTO uigpin_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Andin Musa ⱪeynatisini yolƣa selip ⱪoydi, u ɵz yurtiƣa ⱪaytip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israillar Misir zeminidin qiⱪip, dǝl üqinqi eyining baxlanƣan küni Sinay qɵligǝ yetip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ular Rǝfidimdin qiⱪip, Sinay qɵligǝ yetip kelip, qɵldǝ qedir tikti; Israil xu yǝrdǝ, taƣning udulida tohtap qedir tikti. ");
INSERT INTO uigpin_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa Hudaning aldiƣa qiⱪiwidi, Pǝrwǝrdigar taƣdin uningƣa hitab ⱪilip mundaⱪ dedi: — Sǝn Yaⱪupning jǝmǝtigǝ sɵz ⱪilip, Israillarƣa munu hǝwǝrni yǝtküzgin: — ");
INSERT INTO uigpin_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","«Mening misirliⱪlarƣa nemǝ ⱪilƣinimni, xundaⱪla Mǝn silǝrni huddi bürküt balilirini ⱪanatliriƣa mindürüp elip yürgǝndǝk, Ɵz ⱪeximƣa elip kǝlginimni ɵzünglar kɵrdünglar.    ");
INSERT INTO uigpin_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Əmdi silǝr dǝrⱨǝⱪiⱪǝt Mening sɵzümni anglap, ǝⱨdǝmni tutsanglar, undaⱪta barliⱪ ǝllǝrning arisida Manga has bir gɵⱨǝr bolisilǝr — qünki pütkül yǝr Meningkidur — ");
INSERT INTO uigpin_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","wǝ silǝr Manga kaⱨinlardin tǝrkib tapⱪan has bir padixaⱨliⱪ wǝ muⱪǝddǝs bir ⱪowm bolisilǝr». Mana bu sǝn Israillarƣa deyixing kerǝk bolƣan sɵzlǝrdur, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Xuning bilǝn Musa yenip kelip, hǝlⱪning aⱪsaⱪallirini qaⱪirtip, Pǝrwǝrdigar uningƣa buyruƣan xu sɵzlǝrning ⱨǝmmisini ularƣa yǝtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Hǝlⱪning ⱨǝmmisi bir eƣizdin: — Pǝrwǝrdigar buyruƣanning ⱨǝmmisigǝ qoⱪum ǝmǝl ⱪilimiz! — dǝp jawab bǝrdi. Andin Musa hǝlⱪning jawab sɵzlirini Pǝrwǝrdigarning ⱪexiƣa berip yǝtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Pǝrwǝrdigar Musaƣa: — Mana, Mǝn sanga sɵz ⱪilƣinimda hǝlⱪ awazimni anglisun, ⱨǝmixǝ sanga ixǝnsun dǝp, yeningƣa ⱪara bulutning ⱪarangƣuluⱪi iqidǝ kelimǝn, dǝp eytti. Musamu hǝlⱪning degǝnlirini Pǝrwǝrdigarƣa anglatti. ");
INSERT INTO uigpin_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Pǝrwǝrdigar Musaƣa yǝnǝ: — Sǝn hǝlⱪning ⱪexiƣa berip, bügün wǝ ǝtǝ ularni pak-muⱪǝddǝs ⱪilip, kiyim-keqǝklirini yudurƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ular üqinqi künigǝ tǝyyar tursun; qünki üqinqi küni barliⱪ hǝlⱪning kɵz aldida Pǝrwǝrdigar Sinay teƣiƣa qüxidu. ");
INSERT INTO uigpin_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Sǝn hǝlⱪ üqün taƣning ǝtrapiƣa bir pasil ⱪilip, ularƣa: «Silǝr eⱨtiyat ⱪilinglar, taƣⱪa qiⱪmanglar yaki uning etikigǝ tegip kǝtmǝnglar. Kimki taƣⱪa tǝgsǝ ɵltürülmǝy ⱪalmaydu;    ");
INSERT INTO uigpin_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Uningƣa ⱨǝtta birǝr ⱪoli tegip kǝtsimu, qalma-kesǝk ⱪilip ɵltürülsun yaki oⱪ etip ɵltürülsun. Mǝyli ⱨaywan yaki insan bolsun, xundaⱪ ⱪilsa, tirik ⱪaldurulmisun» — dǝp eytⱪin. Lekin Kanay uzun qelinsa, ular taƣning tüwigǝ qiⱪsun, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa taƣdin qüxüp hǝlⱪning ⱪexiƣa berip, hǝlⱪni Hudaƣa atap muⱪǝddǝs ⱪildi; ular kiyim-keqǝklirini yudi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Andin Musa hǝlⱪⱪǝ: — Üqinqi künigǝ tǝyyar turunglar; ⱨeqkim ayali bilǝn yeⱪinqiliⱪ ⱪilmisun, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Üqinqi küni bolƣanda, tang yoruxi bilǝn xundaⱪ boldiki, güldürmamilar güldürlǝp, qaⱪmaⱪ qeⱪip, taƣ üstidǝ ⱪoyuⱪ bir parqǝ bulut pǝyda boldi, zor ⱪattiⱪ qelinƣan kanayning awazi anglandi. Buni kɵrüp qedirgaⱨdiki pütkül hǝlⱪ ⱪorⱪunqidin titrǝp kǝtti.    ");
INSERT INTO uigpin_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa hǝlⱪni Hudaning aldida ⱨazir boluxⱪa qedirgaⱨdin elip qiⱪti. Ular kelip taƣning tüwidǝ ɵrǝ turdi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Pǝrwǝrdigar Sinay teƣiƣa otta qüxüp kǝlgini üqün is-tütǝk pütkül taƣni ⱪaplidi; is-tütǝk humdandin ɵrligǝn is-tütǝktǝk üstigǝ ɵrlǝp qiⱪti. Pütkül taƣ ⱪattiⱪ tǝwrinixkǝ baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kanay awazi barƣanseri küqiyip intayin ⱪattiⱪ qiⱪti. Musa sɵz ⱪiliwidi, Huda anglap ünlük awaz bilǝn jawab bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Pǝrwǝrdigar Ɵzi Sinay teƣiƣa, taƣning qoⱪⱪisiƣa qüxti; andin Pǝrwǝrdigar Musani taƣning qoⱪⱪisiƣa qaⱪiriwidi, Musa taƣⱪa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Pǝrwǝrdigar Musaƣa: — Sǝn qüxüp halayiⱪni agaⱨlandurup: Ular «Pǝrwǝrdigarni kɵrimiz» dǝp pasildin bɵsüp ɵtmisun; undaⱪ ⱪilsa, ulardin kɵp adǝm ⱨalak bolidu, dǝp eytⱪin. ");
INSERT INTO uigpin_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Pǝrwǝrdigarƣa yeⱪin kelǝlǝydiƣan kaⱨinlarmu ɵzlirini Manga atap muⱪǝddǝs ⱪilsun; bolmisa, Pǝrwǝrdigar sepilni bɵskǝndǝk ularƣa ⱨalakǝt yǝtküzidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa Pǝrwǝrdigarƣa: — Halayiⱪning Sinay teƣiƣa qiⱪixi mumkin ǝmǝs; qünki Sǝn Ɵzüng bizgǝ ⱪattiⱪ agaⱨlandurdung: taƣni «muⱪǝddǝs» dǝp ⱪarap, uning ǝtrapiƣa pasillarni bekitinglar, dǝp ǝmr ⱪilding, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Pǝrwǝrdigar Musaƣa: — Mang, sǝn qüxüp kǝtkin. Andin sǝn Ⱨarunni elip, billǝ qiⱪⱪin; lekin kaⱨinlar wǝ hǝlⱪ bolsa Pǝrwǝrdigarning ⱪexiƣa barayli dǝp pasildin bɵsüp ɵtmisun; bolmisa, Pǝrwǝrdigar sepilni bɵskǝndǝk ularning üstigǝ qüxidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Xuning bilǝn Musa hǝlⱪning ⱪexiƣa qüxüp, ularƣa bu sɵzni yǝtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Huda munu barliⱪ sɵzlǝrni bayan ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Mǝn seni «ⱪulluⱪ makani» bolƣan Misir zeminidin qiⱪirip kǝlgǝn Pǝrwǝrdigar Hudayingdurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Sening Mǝndin baxⱪa ⱨeqⱪandaⱪ ilaⱨing bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Sǝn ɵzüng üqün mǝyli yuⱪiridiki asmanda bolsun, mǝyli tɵwǝndiki zeminda bolsun, yaki yǝr astidiki sularda bolsun, ⱨǝrⱪandaⱪ nǝrsining ⱪiyapitidiki ⱨeqⱪandaⱪ oyma xǝkilni yasima.    ");
INSERT INTO uigpin_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Sǝn bundaⱪ nǝrsilǝrgǝ bax urma yaki ularning ⱪulluⱪiƣa kirmǝ. Qünki Mǝnki Pǝrwǝrdigar Hudaying wapasizliⱪⱪa ⱨǝsǝt ⱪilƣuqi Tǝngridurmǝn. Mǝndin nǝprǝtlǝngǝnlǝrning ⱪǝbiⱨliklirini ɵzlirigǝ, oƣulliriƣa, ⱨǝtta nǝwrǝ-qǝwrilirigiqǝ qüxürimǝn, ");
INSERT INTO uigpin_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Əmma Meni sɵyidiƣan wǝ ǝmrlirimni tutidiƣanlarƣa ming ǝwladiƣiqǝ ɵzgǝrmǝs meⱨribanliⱪ kɵrsitimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Pǝrwǝrdigar Hudayingning namini ⱪalaymiⱪan tilƣa alma; qünki kimdǝkim namini ⱪalaymiⱪan tilƣa alsa, Pǝrwǝrdigar uni gunaⱨkar ⱨesablimay ⱪalmaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Xabat künini muⱪǝddǝs dǝp bilip tutⱪili yadingda saⱪliƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Altǝ kün ixlǝp barliⱪ ixliringni tügǝtkin; ");
INSERT INTO uigpin_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","lekin yǝttinqi küni Pǝrwǝrdigar Hudayingƣa atalƣan xabat künidur; sǝn xu küni ⱨeqⱪandaⱪ ix ⱪilmaysǝn; mǝyli sǝn yaki oƣlung bolsun, mǝyli ⱪizing, mǝyli ⱪulung, mǝyli dediking, mǝyli buⱪang yaki sǝn bilǝn bir yǝrdǝ turuwatⱪan musapir bolsun, ⱨeqⱪandaⱪ ix ⱪilmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Qünki altǝ kün iqidǝ Pǝrwǝrdigar asman bilǝn zeminni, dengiz bilǝn uning iqidiki barini yaratti andin yǝttinqi künidǝ aram aldi. Buning üqün Pǝrwǝrdigar xabat künini bǝht-bǝrikǝtlik kün ⱪilip, uni muⱪǝddǝs kün dǝp bekitti. ");
INSERT INTO uigpin_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ata-anangni ⱨɵrmǝt ⱪil. Xundaⱪ ⱪilsang Pǝrwǝrdigar Hudaying sanga ata ⱪilmaⱪqi bolƣan zeminda uzun ɵmür kɵrisǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ⱪatilliⱪ ⱪilma. ");
INSERT INTO uigpin_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Zina ⱪilma. ");
INSERT INTO uigpin_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Oƣriliⱪ ⱪilma. ");
INSERT INTO uigpin_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ⱪoxnang toƣruluⱪ yalƣan guwaⱨliⱪ bǝrmǝ. ");
INSERT INTO uigpin_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Sǝn ⱪoxnangning ɵy-imaritigǝ kɵz ⱪiringni salma, nǝ ⱪoxnangning ayali, nǝ uning ⱪuliƣa, nǝ uning dediki, nǝ uning kalisi, nǝ uning ixiki yaki ⱪoxnangning ⱨǝrⱪandaⱪ baxⱪa nǝrsisigǝ kɵz ⱪiringni salma.    ");
INSERT INTO uigpin_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Pütkül hǝlⱪ güldürmamilarni, qeⱪin-yalⱪunlarni, kanayning awazi wǝ taƣdin ɵrlǝp qiⱪⱪan is-tütǝklǝrni kɵrdi wǝ anglidi; ular bularni kɵrüp, titrixip yiraⱪ turuxti ");
INSERT INTO uigpin_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","wǝ Musaƣa: — Bizgǝ sǝnla sɵz ⱪilƣaysǝn, biz anglaymiz; lekin Huda bizgǝ Ɵzi sɵz ⱪilmisun; qünki undaⱪ ⱪilsa ɵlüp ketimiz, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa halayiⱪⱪa jawabǝn: — Ⱪorⱪmanglar; qünki Hudaning bu yǝrgǝ kelixi silǝrni sinax üqün, yǝni silǝrning Uning dǝⱨxǝtlikini kɵz aldinglarƣa kǝltürüp, gunaⱨ ⱪilmasliⱪinglar üqündur, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Xuning bilǝn halayiⱪ nerida turdi; lekin Musa Huda iqidǝ turƣan ⱪoyuⱪ bulutning ⱪexiƣa yeⱪin bardi. ");
INSERT INTO uigpin_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Pǝrwǝrdigar Musaƣa: — Sǝn berip Israillarƣa munu sɵzlǝrni yǝtküzgin: «Silǝrgǝ ǝrxtin sɵz ⱪilƣinimni kɵrdünglar. ");
INSERT INTO uigpin_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Silǝr Mening ornumda ilaⱨ dǝp kümüxtin butlar yasimanglar, yaki ɵzünglar üqün altundin butlarni yasimanglar. ");
INSERT INTO uigpin_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","— Sǝn Mǝn üqün tupraⱪtin bir ⱪurbangaⱨ yasap, xu yǝrdǝ kɵydürmǝ ⱪurbanliⱪ wǝ inaⱪliⱪ ⱪurbanliⱪliringni, ⱪoy-ɵqkǝ bilǝn kaliliringni sunƣin. Omumǝn Mǝn hǝlⱪⱪǝ namimni ⱨɵrmǝt bilǝn ǝslitidiƣan barliⱪ jaylarda, yeningƣa kelip sanga bǝht-bǝrikǝt ata ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","— Əgǝr Manga atap taxlardin ⱪurbangaⱨ yasimaⱪqi bolsang, yonulƣan taxlardin yasimiƣin; qünki taxlarƣa ǝswabingni tǝgküzsǝng, ular napak bolup ⱪalidu.    ");
INSERT INTO uigpin_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ⱪurbangaⱨimƣa qiⱪidiƣan pǝlǝmpǝy bolmisun; undaⱪ bolƣanda, pǝlǝmpǝydin qiⱪⱪuqǝ ǝwriting kɵrünüp ⱪelixi mumkin», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","— Sǝn ularning aldiƣa ⱪoyidiƣan ⱨɵküm-bǝlgilimilǝr munulardur: — ");
INSERT INTO uigpin_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Əgǝr sǝn bir ibraniy ⱪulni setiwalƣan bolsang, u altǝ yilƣiqǝ hizmitingdǝ bolup, yǝttinqi yili tɵlǝmsiz ⱨɵr ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","U ⱪul ⱪilinixⱪa tǝnⱨa ⱨalǝttǝ elip kelingǝn bolsa, tǝnⱨa ⱨalǝttǝ kǝtsun. Ayali bilǝn birgǝ elip kelingǝn bolsa, ayalimu uning bilǝn billǝ kǝtsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Əgǝr hojisi uningƣa hotun elip bǝrgǝn bolsa, xundaⱪla ayali uningƣa oƣul-ⱪizlarni tuƣup bǝrgǝn bolsa, ayal baliliri bilǝn hojisiƣa ⱪelip, ǝr yalƣuz kǝtsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Lekin ǝgǝr ⱪul elan ⱪilip: «Mǝn hojam, ayalim wǝ balilirimƣa muⱨǝbbitim bolƣini üqün ⱨɵr bolup kǝtmǝymǝn» desǝ, ");
INSERT INTO uigpin_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","undaⱪta uning hojisi uni Hudaning ibadǝt sorunining aldiƣa elip berip, uni ixikning aldida yaki ixikning kexikining aldida turƣuzsun; andin hojisi bigiz bilǝn uning ⱪuliⱪini tǝxsun. Xundaⱪ ⱪilip, u mǝnggügǝ hojisining ⱪuli bolup ⱪalidu. ");
INSERT INTO uigpin_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Əgǝr birkim ⱪizini dedǝklikkǝ setiwǝtkǝn bolsa, u ǝr ⱪullar ⱨɵr ⱪilinƣandǝk ⱨɵr ⱪilinmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Əgǝr ɵzigǝ has setiwalƣan ⱪiz hojisiƣa yaⱪmisa, undaⱪta u ⱪiz tǝrǝpning ⱨǝⱪ tɵlǝp uni ⱨɵr ⱪilixiƣa yol ⱪoyuxi kerǝk. Lekin hojisining uni yat hǝlⱪⱪǝ setix ⱨoⱪuⱪi bolmaydu; qünki hojisi uningƣa wapasizliⱪ ⱪilƣandur. ");
INSERT INTO uigpin_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Əgǝr u ⱪizni oƣliƣa has bekitkǝn bolsa, undaⱪta u bǝlgilimilǝr boyiqǝ uningƣa ɵz ⱪizidǝk muamilǝ ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Əgǝr hojisi yǝnǝ hotun alsa, ǝslidǝ ǝmrigǝ alƣan dedikining yemǝk-iqmikini, kiyim-keqikini wǝ ǝr-hotunqiliⱪ burqini kemǝytmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Əgǝr u xu üq ixni ada ⱪilmisa, undaⱪta u bǝdǝl tɵlimǝy ⱨɵr bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kimki bir adǝmni urup ɵltürüp ⱪoysa, umu qoⱪum ɵltürülsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Lekin ǝgǝr u kixi ɵlgüqining jenini paylap turup ⱪǝstǝn ɵltürmigǝn, bǝlki mǝn Huda uning ⱪoli arⱪiliⱪ xu kixining ɵlüxigǝ yol ⱪoyƣan bolsam, undaⱪ ǝⱨwalda Mǝn uningƣa ⱪaqidiƣan bir jayni orunlaxturimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Lekin ǝgǝr birsi ɵz ⱪoxnisini ⱨiylǝ bilǝn ɵltürimǝn dǝp, uningƣa ⱪǝstǝn ⱨujum ⱪilsa, u gǝrqǝ panaⱨ izdǝp ⱪurbangaⱨimƣa ⱪeqip kǝlsimu, u xu yǝrdǝ tutulsun wǝ ɵlümgǝ mǝⱨkum ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Kimki ɵz atisi yaki anisiƣa ⱪol tǝgküzsǝ, qoⱪum ɵltürülsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Kimki bir adǝmni bulap satⱪan bolsa yaki uning ⱪolida barliⱪi mǝlum bolsa, jǝzmǝn ɵltürülüxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Kimki ɵz atisi yaki anisiƣa lǝnǝt ⱪilip ⱪarƣiƣan bolsa, jǝzmǝn ɵltürülüxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Əgǝr ikki kixi uruxup ⱪelip, biri yǝnǝ birini tax ya moxti bilǝn ursa, urulƣan kixi ɵlmǝy, orun tutup yetip ⱪalƣan bolsa, ");
INSERT INTO uigpin_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","u kixi ⱪopup ⱨasiƣa tayinip taxⱪiriƣa qiⱪⱪudǝk bolsa, undaⱪta uni urƣan kixi jazadin halas ⱪilinsun; pǝⱪǝt zǝhimlǝngüqining yetip ixtin ⱪalƣan waⱪti üqün tɵlǝm berip, uni dawalitip sǝllimaza saⱪaytsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Əgǝr birsi ⱪuli yaki dedikini tayaⱪta ursa, xundaⱪla ⱪul yaki dedǝk nǝⱪ mǝydanda ɵlüp kǝtsǝ, uning üqün igisi qoⱪum jazaƣa tartilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Lekin ǝgǝr tayaⱪ yegüqi bir-ikki kün tirik tursa, undaⱪta ⱪul hojayinining xǝhsi mal-mülki bolƣini üqün, ⱪulning jazasiƣa tartilmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Əgǝr kixilǝr bir-biri bilǝn uruxup ⱪelip, ⱨamilidar bir ayalni urup salsa, ⱨamilidar ayalda balisi baldur tuƣuluxidin baxⱪa zǝhimlinix bolmisa, ayalning erining tɵlǝm tǝlipi boyiqǝ ⱨakimlarning tǝstiⱪidin ɵtküzülüp jǝrimanǝ tɵlisun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Əgǝr ayal yaki bala ziyan-zǝhǝtkǝ uqriƣan bolsa, undaⱪta jeniƣa jan, ");
INSERT INTO uigpin_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","kɵzigǝ kɵz, qixiƣa qix, ⱪoliƣa ⱪol, putiƣa put, ");
INSERT INTO uigpin_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kɵyükkǝ kɵyük, zǝhimgǝ zǝhim, kɵkkǝ kɵk tɵlǝnsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Əgǝr birsi ɵz ⱪul ya dedikining kɵzini urup nakar ⱪilip ⱪoysa, kɵzi wǝjidin uni azad ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Xuningdǝk birsi ɵz ⱪuli ya dedikining qixini urup qiⱪiriwǝtkǝn bolsa, qixi wǝjidin uni azad ⱪilsun». ");
INSERT INTO uigpin_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Əgǝr bir kala bir ǝr yaki ayal kixini üsüp ɵltürüp ⱪoysa, xu kala qoⱪum qalma-kesǝk ⱪilinixi kerǝk, uning gɵxi yeyilmisun. Lekin kalining igisigǝ gunaⱨ kǝlmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Lekin bu uyning ilgiridin üsüx aditi bolup, igisigǝ bu ⱨǝⱪtǝ agaⱨ berilgǝn bolsa, lekin yǝnila uni baƣlimiƣini üqün ǝr-ayal kixilǝrni üsüp ɵltürüp ⱪoyƣan bolsa, undaⱪta kala qalma-kesǝk ⱪilinsun, igisimu ɵlümgǝ mǝⱨkum ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Lekin uningdin hun ⱨǝⱪⱪi tǝlǝp ⱪilinsa, ɵz jenining ornida uningƣa ⱪanqilik tɵlǝm ⱪoyulƣan bolsa xuni bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kalidin üsülgüqi oƣul yaki ⱪiz bala bolsa, kalining igisi ohxaxla yuⱪiriⱪi ⱨɵkümdikidǝk bir tǝrǝp ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kala ⱪul yaki dedǝkni üskǝn bolsa, kalining igisi üsülgüqining hojisiƣa ottuz xǝkǝl kümüx bǝrsun; andin kala qalma-kesǝk ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Əgǝr birsi bir orining aƣzini oquⱪ ⱪoyup yaki kolawatⱪan orining aƣzini yapmay, kala yaki exǝk uningƣa qüxüp kǝtsǝ, ");
INSERT INTO uigpin_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Undaⱪta orining igisi mal igisining ziyinini toluⱪ tɵlǝp bǝrsun; ɵlgǝn mal uningki bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Əgǝr birsining kalisi yǝnǝ birsining kalisini üsüp ɵltürüp ⱪoyƣan bolsa, undaⱪta ular tirik ⱪalƣan kalini setip, pulni barawǝr bɵlüxsun ⱨǝm ɵlük kalinimu xundaⱪ bɵlüxsun. ");
INSERT INTO uigpin_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Lekin kalining ilgiridin üsidiƣan aditi barliⱪi eniⱪ turup, igisi uni baƣlimay ⱪoyuwǝtkǝn bolsa, undaⱪta üsküqi kalining igisi kaliƣa kala tɵlǝp bǝrsun, ɵlük kala uning bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Əgǝr birsi bir kala yaki ⱪoyni oƣrilap, uni soysa ya setiwǝtsǝ, u bir kalining orniƣa bǝx kala, bir ⱪoyning orniƣa tɵt ⱪoy tɵlisun.    ");
INSERT INTO uigpin_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Oƣri tam tǝxkǝndǝ tutulup ⱪelip, tayaⱪ yǝp ɵlüp ⱪalsa, ɵltürgüqigǝ hun jazasi kǝlmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Lekin xu wǝⱪǝ bolƣan pǝyttǝ kün qiⱪip ⱪalƣan bolsa, undaⱪta ɵltürgüqi hun jazasiƣa tartilsun. Oƣri oƣriliƣinini tɵlǝp ziyanni toluⱪlap berixi kerǝk; uningda bir nemǝ bolmisa, ⱪulluⱪⱪa setilip, oƣriliƣan nǝrsini tɵlixi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Oƣri tutulƣanda oƣriliƣan nǝrsǝ, kala bolsun, exǝk bolsun, ⱪoy bolsun uning ⱪolida tirik ⱨalǝttǝ tepilsa, u ikki ⱨǝssǝ ⱪimmǝttǝ tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Əgǝr birsi ɵz mal-qarwilirini etizliⱪⱪa yaki üzümzarliⱪⱪa otlaxⱪa ⱪoyuwetip, baxⱪilarning baƣ-etizliⱪida otlaxⱪa yol ⱪoysa, undaⱪta u ɵzining ǝng esil mǝⱨsulatliridin yaki üzümzarliⱪining ǝng esil mewisidin ziyanni tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Əgǝr ot ketip, tikǝnlikkǝ tutixip ketip, andin ɵnqilǝrni, bax tartip pixⱪan ziraǝtni kɵydürüp, pütkül etizliⱪni kül ⱪiliwǝtsǝ, undaⱪta ot ⱪoyƣuqi barliⱪ ziyanni tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Əgǝr birsi ⱪoxnisiƣa pul yaki mal-dunyasini amanǝt ⱪilƣan bolsa, bular ɵyidin oƣrilinip kǝtsǝ, xundaⱪla oƣri keyin tutulsa, u oƣriliƣinini ikki ⱨǝssǝ ⱪimmǝttǝ tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Lekin oƣri tepilmisa, ɵy igisining ⱪoxnisining meliƣa ⱪol tǝgküzgǝn ya tǝgküzmigǝnliki mǝlum bolsun dǝp, ⱨakimlarning aldiƣa kǝltürülsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ⱨǝrhil hiyanǝt, u mǝyli kala, exǝk, ⱪoy, kiyim-keqǝk bolsun, yittürüp ⱪoyƣan nǝrsǝ bolsun, ular toƣruluⱪ bir ⱪoxnisi: «ǝmǝliyǝttǝ mundaⱪ idi» dǝp talaxⱪan bolsa, ⱨǝr ikkisining dǝwasi ⱨakimlarning aldiƣa kǝltürülsun; ⱨakimlar ⱪaysiƣa gunaⱨ bekitsǝ, xu ⱪoxnisiƣa ikki ⱨǝssǝ ⱪimmǝttǝ tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Əgǝr birsi ⱪoxnisiƣa exǝk, kala, ⱪoy yaki baxⱪa bir qarpayni amanǝt ⱪilsa, bu amanǝt meli kixi kɵrmǝy ɵlüp kǝtsǝ, yaki zǝhimlǝnsǝ, yaki ⱨǝydǝp ǝkitilsǝ, ");
INSERT INTO uigpin_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","undaⱪta ⱪoxnisining meliƣa ⱪol tǝgküzgǝn ya tǝgküzmigǝnliki mǝlum bolsun dǝp, Pǝrwǝrdigarning aldida ularning otturisida bir ⱪǝsǝm iqürülsun. Mal igisi bu ⱪǝsǝmni ⱪobul ⱪilsun; ⱪoxnisi uningƣa tɵlǝm tɵlǝp bǝrmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Lekin mal oƣrilanƣan bolsa, u igisigǝ tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Əgǝr uni wǝⱨxiy ⱨaywan boƣup ⱪoyƣan bolsa, u malning ⱪalduⱪini guwaⱨliⱪ üqün kɵrsitip, uni tɵlǝp bǝrmisimu bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Əgǝr birsi ⱪoxnisidin bir ulaƣni ɵtnǝ elip, ulaƣ igisi yoⱪ yǝrdǝ zǝhimlǝnsǝ yaki ɵlüp ⱪalsa, ɵtnǝ alƣuqi toluⱪ tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Lekin igisi nǝⱪ mǝydanda bolsa, ɵtnǝ alƣuqi tɵlǝp bǝrmisun; ulaƣ ijarigǝ elinƣan bolsa, alƣuqi tɵlǝm tɵlimisun; qünki uni ijarǝ tɵlǝp ǝkǝlgǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Əgǝr bir adǝm tehi yatliⱪ bolmiƣan bir ⱪizni azdurup, uning bilǝn billǝ yatsa, undaⱪta u uning toyluⱪini berixi kerǝk, andin uni hotunluⱪⱪa alsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Lekin ⱪizning atisi uni uningƣa bǝrgili unimisa, zina ⱪilƣuqi pak ⱪizlarning toyluⱪiƣa barawǝr kelidiƣan kümüx pulni tarazida ɵlqǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Jadugǝr hotunni tirik ⱪoymiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ⱨaywan bilǝn jinsiy munasiwǝt ɵtküzgǝn ⱨǝrbiri jǝzmǝn ɵlümgǝ mǝⱨkum ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Kimdǝkim birdinbir Pǝrwǝrdigardin baxⱪa ⱨǝrⱪandaⱪ ilaⱨⱪa ⱪurbanliⱪ sunsa, ⱨaram dǝp mutlǝⱪ ⱨalakǝtkǝ mǝⱨkum ⱪilinsun.    ");
INSERT INTO uigpin_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Silǝrmu Misirda musapir bolup turƣanikǝnsilǝr, musapir bolƣan kixini ⱨeq harlimanglar wǝ yaki uningƣa ⱨeq zulum ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ⱨǝrⱪandaⱪ tul hotun yaki yetim balini horlimanglar. ");
INSERT INTO uigpin_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Sǝn ularni ⱨǝrⱪandaⱪ tǝrǝptǝ horlisang, ular manga pǝryad kɵtürsǝ, Mǝn ularning awazini qoⱪum anglaymǝn; ");
INSERT INTO uigpin_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","xuning bilǝn ƣǝzipim tutixip, silǝrni ⱪiliqlap ɵltürimǝn, silǝrning hotunliringlar tul ⱪilinip, baliliringlar yetim bolup ⱪalidu. ");
INSERT INTO uigpin_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Əgǝr sǝn Mening hǝlⱪimning iqidin sanga ⱪoxna bolƣan kǝmbǝƣǝlgǝ ⱪǝrz bǝrgǝn bolsang, uningƣa jazanihorlardǝk muamilǝ ⱪilmiƣin; uningdin ɵsüm almanglar. ");
INSERT INTO uigpin_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Əgǝr sǝn ⱪoxnangning qapinini gɵrügǝ alƣan bolsang, kün olturmasta uningƣa yandurup bǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Qünki qapini uning birdinbir yepinqisi bolup, bǝdinini yapidiƣan kiyim xudur. U bolmisa, u nemini yepinip yatidu? Bu sǝwǝbtin Manga pǝryad ⱪilsa, pǝryadini anglaymǝn; qünki Mǝn xǝpⱪǝtlikturmǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ⱨakimlarƣa kupurluⱪ ⱪilma, wǝ hǝlⱪingning ǝmirlirinimu ⱪarƣap tillima.    ");
INSERT INTO uigpin_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Haminingning ⱨosulining axⱪinidin wǝ xarab-zǝytun meyi kɵlqikingdin taxⱪinidin Manga ⱨǝdiyǝ sunuxni ⱨayal ⱪilmiƣin. Sǝn oƣulliringning tunjisini Manga atiƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Kala bilǝn ⱪoyliringning tunji balilirinimu ⱨǝm xundaⱪ atiƣin; tunji bala yǝttǝ küngiqǝ anisi bilǝn billǝ tursun; ǝmma sǝkkizinqi küni uni Manga atap sunƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Silǝr Manga atalƣan muⱪǝddǝs kixilǝr bolisilǝr; xunga dalada yirtⱪuq ⱨaywan tǝripidin boƣulƣan ⱨaywanning gɵxini yemǝnglar, bǝlki uni itlarƣa taxlap beringlar. ");
INSERT INTO uigpin_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Yalƣan gǝpni yaymiƣin wǝ ya yalƣan guwaⱨliⱪ berip rǝzil adǝmgǝ yan basmiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Topⱪa ǝgixip rǝzil ixta bolma yaki dǝwa-dǝsturlarda guwaⱨliⱪ bǝrgǝndǝ topⱪa ǝgixip ⱨǝⱪiⱪǝtni burmilima. ");
INSERT INTO uigpin_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kǝmbǝƣǝl dǝwa ⱪilsa, uningƣa yan basma. ");
INSERT INTO uigpin_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Düxminingning kala ya exiki ezip ketip, sanga uqrap ⱪalsa, uni elip kelip, igisigǝ qoⱪum tapxurup bǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Əgǝr sanga ɵq bolƣanning exiki yükni kɵtürǝlmǝy yükning astida yatⱪinini kɵrsǝng, uni yardǝmsiz taxlimay, bǝlki uningƣa yardǝmlixip exikini ⱪopuruxup berixing zɵrür. ");
INSERT INTO uigpin_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Arangdiki kǝmbǝƣǝlning dǝwasida adalǝtni burmilima. ");
INSERT INTO uigpin_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ⱨǝrⱪandaⱪ sahta ixtin ɵzüngni neri tart; bigunaⱨ adǝm bilǝn ⱨǝⱪⱪaniy adǝmni ɵltürmigin; qünki Mǝn rǝzil adǝmni ⱨǝrgiz adil dǝp aⱪlimaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Xuningdǝk ⱨeqⱪandaⱪ para yemǝ; qünki para kɵzi oquⱪlarni kor ⱪilip, ⱨǝⱪⱪaniylarning sɵzlirini burmilaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Musapir kixilǝrgǝ zulum ⱪilma; qünki ɵzünglar Misir zeminida musapir bolup turƣan bolƣaqⱪa, musapirning roⱨiy ⱨalini bilisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Altǝ yil ɵz yeringni terip, ⱨosullirini al. ");
INSERT INTO uigpin_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Lekin yǝttinqi yili yǝrgǝ aram berip uni box ⱪoy; hǝlⱪingning namratliri uningdin yiƣip yesun, ulardin axⱪinini janggaldiki ⱨaywanlar yesun; xundaⱪla üzümzarliⱪing bilǝn zǝytunzarliⱪingnimu xundaⱪ ⱪilƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Altǝ kün iqidǝ ɵz ixingni ada ⱪilip, yǝttinqi küni aram elixing zɵrür. Buning bilǝn kala-exǝkliring aram tapidu, dedikingning oƣli bilǝn musapir kiximu ⱨarduⱪini qiⱪiridu. ");
INSERT INTO uigpin_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Mǝn sanga eytⱪinimning ⱨǝmmisini kɵngül bɵlüp ada ⱪil; baxⱪa ilaⱨlarning namini tilingƣa alma; bular ⱨǝtta aƣzingƣimu qiⱪmisun.    ");
INSERT INTO uigpin_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ⱨǝr yilda üq ⱪetim mening üqün ⱨeyt ɵtküzgin. ");
INSERT INTO uigpin_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Aldi bilǝn «petir nan ⱨeyti»ni ɵtküz; sanga ǝmr ⱪilƣinimdǝk Abib eyidiki bekitilgǝn künlǝrdǝ yǝttǝ kün petir nan yegin; qünki xu ayda sǝn Misirdin qiⱪⱪaniding. Xu ⱨeytta ⱨeqkixi aldimƣa ⱪuruⱪ ⱪol kǝlmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Sǝn ǝjir ⱪilip teriƣan etizdiki ziraitingning tunji ⱨosulini orƣanda «orma ⱨeyti»ni ɵtküz; xundaⱪla sǝn ǝjir singdürüp yǝrdin ahirⱪi ⱨosul-mǝⱨsulatliringni yil ahirida yiƣⱪanda «ⱨosul yiƣix ⱨeyti»ni ɵtküz. ");
INSERT INTO uigpin_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Yilda üq ⱪetim ǝrkǝkliringning ⱨǝmmisi Rǝb Pǝrwǝrdigarning ⱨuzuriƣa ⱨazir bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Sǝn manga atalƣan ⱪurbanliⱪning ⱪenini hemirturuq selinƣan nan bilǝn sunmiƣin; ⱨeyt ⱪurbanliⱪining yeƣini bolsa keqiqǝ ⱪondurup ǝtigiqigǝ saⱪlima. ");
INSERT INTO uigpin_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Zeminingdiki dǝslǝpki ⱨosulning ǝng yahxsini Pǝrwǝrdigar Hudayingning ɵyigǝ elip kǝl. Oƣlaⱪni anisining sütidǝ ⱪaynitip pixurma.    ");
INSERT INTO uigpin_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Mana, Mǝn bir Pǝrixtini yolda seni ⱪoƣdap, Mǝn sanga tǝyyarliƣan yǝrgǝ elip barsun dǝp, aldingda yürüxkǝ ǝwǝtimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Sǝn uning aldida ɵzünggǝ agaⱨ bol, uning awaziƣa ⱪulaⱪ sal. Uning zitiƣa tǝgmǝ; bolmisa, u itaǝtsizlikliringni kǝqürmǝydu; qünki Mening namim uningdidur. ");
INSERT INTO uigpin_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Lekin ǝgǝr sǝn uning awaziƣa ⱪulaⱪ selip, Mening barliⱪ buyruƣanlirimƣa ǝmǝl ⱪilsang, Mǝn düxmǝnliringgǝ düxmǝn, küxǝndiliringgǝ küxǝndǝ bolimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Qünki Mening Pǝrixtǝm aldingda yürüp, seni Amoriy, Ⱨittiy, Pǝrizziy, Ⱪanaaniy, Ⱨiwiy wǝ Yǝbusiylarning zeminiƣa baxlap kiridu; Mǝn ularni yoⱪitimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Sǝn ularning ilaⱨliriƣa bax urup ibadǝt ⱪilma wǝ yaki ular ⱪilƣandǝk ⱪilma; bǝlki ularning butlirini üzül-kesil qeⱪiwǝt, but tüwrüklirini üzül-kesil kukum-talƣan ⱪiliwǝt; ");
INSERT INTO uigpin_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Lekin Hudayinglar Pǝrwǝrdigarning ibaditidǝ bolunglar. Xundaⱪ ⱪilsanglar U nan bilǝn süyünglarni bǝrikǝtlǝydu; Mǝn barliⱪ kesǝllikni aranglardin qiⱪirip taxlaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Buning bilǝn zeminingda boyidin ajrap ketidiƣan yaki tuƣmas ⱨeqbir ayal yaki qarpay bolmaydu; ɵmrüngning künlirini toluⱪ ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Mǝn sening aldingda wǝⱨimimni ǝwǝtimǝn, ⱪaysi taipigǝ yeⱪinlaxsang xularni parakǝndǝ ⱪilimǝn; xuning bilǝn ⱨǝmmǝ düxmǝnliringni kǝynigǝ yandurup ⱪaqurimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ⱨiwiylar, Ⱪanaaniylar wǝ Ⱨittiylarni aldingdin ⱪoƣlap qiⱪiriwetixkǝ seriⱪ ⱨǝrilǝrni aldingda yürüxkǝ ǝwǝtimǝn.    ");
INSERT INTO uigpin_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Əmma zeminning Harabilixip, dalada wǝⱨxiy ⱨaywanlar awup sanga hǝwp bolup ⱪalmasliⱪi üqün, xu ǝllǝrni aldingdin bir yilƣiqǝ ⱨǝydiwǝtmǝymǝn, ");
INSERT INTO uigpin_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Bǝlki sǝn awup, zeminni pütünlǝy miras ⱪilip bolƣuqǝ, az-azdin ⱨǝydǝp turimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Sening zeminingning qegrilirini Ⱪizil Dengizdin tartip Filistiylǝrning dengiziƣiqǝ, xuningdǝk qɵldin tartip Əfrat dǝryasiƣiqǝ bekitimǝn; qünki zeminda turuwatⱪanlarni ⱨǝydiwetip yerini igilixing üqün, ularni ⱪolungƣa tapxurimǝn.    ");
INSERT INTO uigpin_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Sǝn ular bilǝn wǝ yaki ilaⱨliri bilǝn ⱨeqⱪandaⱪ bir ǝⱨdǝ tüzmǝ. ");
INSERT INTO uigpin_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ularning seni aldimda gunaⱨⱪa patⱪuzmasliⱪi üqün ularni zeminingda ⱪǝt’iy turƣuzma. Qünki mubada sǝn ularning ilaⱨlirining ibaditidǝ bolsang, bu ix sanga tuzaⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","U Musaƣa yǝnǝ: — «Sǝn berip, ɵzüng bilǝn billǝ Ⱨarun, Nadab, Abiⱨuni wǝ Israillarning aⱪsaⱪalliri arisidin yǝtmix adǝmni elip, Pǝrwǝrdigarning ⱨuzuriƣa qiⱪip, yiraⱪta turup sǝjdǝ ⱪilinglar. ");
INSERT INTO uigpin_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Pǝⱪǝt Musala Pǝrwǝrdigarning aldiƣa yeⱪin kǝlsun; baxⱪilar yeⱪin kǝlmisun, hǝlⱪ uning bilǝn billǝ üstigǝ qiⱪmisun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa kelip Pǝrwǝrdigarning barliⱪ sɵzliri bilǝn ⱨɵkümlirini halayiⱪⱪa dǝp bǝrdi; pütkül halayiⱪ bir awazda: — Pǝrwǝrdigarning eytⱪan sɵzlirining ⱨǝmmisigǝ ǝmǝl ⱪilimiz! — dǝp jawab berixti. ");
INSERT INTO uigpin_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Andin Musa Pǝrwǝrdigarning ⱨǝmmǝ sɵzini hatiriliwelip, ǝtisi sǝⱨǝr ⱪopup taƣning tüwidǝ bir ⱪurbangaⱨni yasap, xu yǝrdǝ Israilning on ikki ⱪǝbilisining sani boyiqǝ on ikki tax tüwrükni tiklidi. ");
INSERT INTO uigpin_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Yǝnǝ Israillarning birnǝqqǝ yigitlirini ǝwǝtti, ular berip Pǝrwǝrdigarƣa kɵydürmǝ ⱪurbanliⱪlar sundi, inaⱪliⱪ ⱪurbanliⱪi süpitidǝ birnǝqqǝ torpaⱪnimu soyup sundi. ");
INSERT INTO uigpin_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Andin Musa ⱪanning yerimini ⱪaqilarƣa ⱪaqilidi, yǝnǝ yerimini ⱪurbangaⱨ üstigǝ qaqti. ");
INSERT INTO uigpin_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Andin u ǝⱨdinamini ⱪoliƣa elip, hǝlⱪⱪǝ oⱪup bǝrdi. Ular jawabǝn: — Pǝrwǝrdigarning eytⱪinining ⱨǝmmisigǝ ⱪulaⱪ selip, itaǝt ⱪilimiz! — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Xuning bilǝn Musa ⱪaqilardiki ⱪanni elip, hǝlⱪⱪǝ sepip: — Mana, bu Pǝrwǝrdigar muxu sɵzlǝrning ⱨǝmmisigǝ asasǝn silǝr bilǝn baƣliƣan ǝⱨdining ⱪenidur, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Andin keyin Musa wǝ Ⱨarun, Nadab wǝ Abiⱨu Israillarning aⱪsaⱪalliridin yǝtmix adǝm bilǝn billǝ taƣ üstigǝ qiⱪixti. ");
INSERT INTO uigpin_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ular xu yǝrdǝ Israilning Hudasini kɵrdi; uning ayiƣining astida huddi kɵk yaⱪuttin yasalƣan nǝpis payandazdǝk, asman gümbizidǝk süpsüzük bir jisim bar idi.    ");
INSERT INTO uigpin_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Lekin u Israillarning mɵtiwǝrlirigǝ ⱪol tǝgküzmidi; ular Hudani kɵrüp turdi ⱨǝmdǝ yǝp-iqixti. ");
INSERT INTO uigpin_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Pǝrwǝrdigar Musaƣa: — Taƣ üstigǝ, ⱪeximƣa qiⱪip xu yǝrdǝ turƣin. Sanga ularƣa ɵgitixkǝ tax tahtaylarni, yǝni Mǝn yezip ⱪoyƣan ⱪanun-ǝmrni berimǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Xuning bilǝn Musa ⱪopup, Yardǝmqisi Yǝxuani elip mangdi. Musa Hudaning teƣiƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","U awwal aⱪsaⱪallarƣa: Biz yenip kǝlgüqǝ muxu yǝrdǝ bizni saⱪlap turunglar. Mana, Ⱨarun bilǝn hur silǝrning yeninglarda ⱪalidu; ǝgǝr birsining ix-dǝwasi qiⱪsa, ularning aldiƣa barsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Xuning bilǝn Musa taƣning üstigǝ qiⱪti wǝ taƣni bulut ⱪaplidi. ");
INSERT INTO uigpin_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Pǝrwǝrdigarning julasi Sinay teƣining üstidǝ tohtidi; bulut uni altǝ küngiqǝ ⱪaplap turdi; yǝttinqi küni, Pǝrwǝrdigar bulut iqidin Musani qaⱪirdi; ");
INSERT INTO uigpin_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Pǝrwǝrdigarning julasining ⱪiyapiti Israillarning kɵz aldida taƣning qoⱪⱪisida ⱨǝmmini yutⱪuqi ottǝk kɵründi. ");
INSERT INTO uigpin_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa bulutning iqigǝ kirip, taƣning üstigǝ qiⱪip kǝtti. Musa ⱪiriⱪ keqǝ-kündüz taƣda turdi. ");
INSERT INTO uigpin_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Sǝn Israillarƣa eytⱪin, ular Manga bir «kɵtürmǝ ⱨǝdiyǝ»ni kǝltürsun; kimning kɵngli ⱨǝdiyǝ sunuxⱪa hux bolsa, uningdin Manga sunulidiƣan «kɵtürmǝ ⱨǝdiyǝ»ni tapxuruwelinglar.    ");
INSERT INTO uigpin_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Silǝr ulardin tapxuruwalidiƣan kɵtürmǝ ⱨǝdiyǝ: — Altun, kümüx, mis, ");
INSERT INTO uigpin_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kɵk, sɵsün wǝ ⱪizil rǝnglik yip, kanap rǝht, tiwit, ");
INSERT INTO uigpin_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ⱪizil boyalƣan ⱪoqⱪarning teriliri, delfinning teriliri, akatsiyǝ yaƣiqi, ");
INSERT INTO uigpin_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","qiraƣ üqün zǝytun meyi, «mǝsiⱨlǝx meyi» wǝ huxbuy üqün huxbuy dora-dǝrmǝklǝr, ");
INSERT INTO uigpin_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ǝfod bilǝn «ⱪoxen»ƣa ornitilidiƣan aⱪ ⱨeⱪiⱪ wǝ baxⱪa esil taxlar bolsun.    ");
INSERT INTO uigpin_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Mening ɵzliri arisida makan ⱪilixim üqün xulardin Manga bir muⱪǝddǝs turalƣuni yasisun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Uni Mǝn sanga barliⱪ kɵrsǝtmǝkqi bolƣinimƣa asasǝn, yǝni ibadǝt qedirining nushisi wǝ barliⱪ ǝswab-saymanlirining nushisiƣa op’ohxax ⱪilip yasanglar. ");
INSERT INTO uigpin_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ular akatsiyǝ yaƣiqidin bir sanduⱪ yasisun. Uning uzunluⱪi ikki yerim gǝz, kǝngliki bir yerim gǝz, egizliki bir yerim gǝz bolsun.    ");
INSERT INTO uigpin_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Sǝn uni sap altun bilǝn ⱪapliƣin; iqi wǝ sirtini altun bilǝn ⱪaplap, uning üstünki ⱪismining qɵrisigǝ altundin girwǝk qiⱪar. ");
INSERT INTO uigpin_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Uningƣa altundin tɵt ⱨalⱪa ⱪuydurup, tɵt qetiⱪiƣa bekitkin. Bir tǝripigǝ ikki ⱨalⱪa, yǝnǝ bir tǝripigǝ ikki ⱨalⱪa bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Sǝn ⱨǝm akatsiyǝ yaƣiqidin ikki baldaⱪ yasap, ⱨǝr ikkisini altun bilǝn ⱪapliƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","andin sanduⱪ ular arⱪiliⱪ kɵtürülsun dǝp, baldaⱪlarni sanduⱪning ikki yenidiki ⱨalⱪiliridin ɵtküzüp ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Baldaⱪlar ⱨǝmixǝ sanduⱪtiki ⱨalⱪida tursun; ular uningdin qiⱪirilmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mǝn sanga beridiƣan ⱨɵküm-guwaⱨliⱪni sanduⱪⱪa ⱪoyƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Sanduⱪning yapⱪuqi süpitidǝ sǝn altundin uzunluⱪi ikki yerim gǝz, kǝngliki bir yerim gǝz bolƣan bir «kǝfarǝt tǝhti» yasiƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ikki kerubni altundin soⱪup yasiƣin. Ularni kǝfarǝt tǝhtining ikki tǝripigǝ ornatⱪin.    ");
INSERT INTO uigpin_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Bir kerubni bir tǝripigǝ, yǝnǝ bir kerubni yǝnǝ bir tǝripigǝ ornitix üqün yasiƣin. Ikki tǝripidiki kerublarni kǝfarǝt tǝhti bilǝn bir gǝwdǝ ⱪilinglar. ");
INSERT INTO uigpin_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kerublar bir-birigǝ yüzlǝnsun, ⱪanatlirini kǝfarǝt tǝhtining üstigǝ kerip, ⱪanatliri bilǝn uni yapsun; kerublarning yüzi kǝfarǝt tǝhtigǝ ⱪaritilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Sǝn kǝfarǝt tǝhtini sanduⱪning üstigǝ ⱪoyup, Mǝn sanga beridiƣan ⱨɵküm-guwaⱨliⱪni sanduⱪning iqigǝ ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Mǝn xu yǝrdǝ sǝn bilǝn kɵrüximǝn; kǝfarǝt tǝhti üstidǝ, yǝni ⱨɵküm-guwaⱨliⱪ sanduⱪining üstidiki ikki kerubning otturisida turup sanga Israillarƣa yǝtküzüxkǝ tapxuridiƣan barliⱪ ǝmrlirim toƣrisida sɵz ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ⱨǝm akatsiyǝ yaƣiqidin uzunluⱪi ikki gǝz, kǝngliki bir gǝz, egizliki bir yerim gǝz bolƣan bir xirǝ yasiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Uni sap altun bilǝn ⱪaplap, uning üstünki ⱪismining qɵrisigǝ altundin girwǝk qiⱪar. ");
INSERT INTO uigpin_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Sǝn xirǝning qɵrisigǝ tɵt ilik egizliktǝ bir lǝw yasiƣin; bu lǝwning qɵrisigimu altundin bir girwǝk qiⱪar. ");
INSERT INTO uigpin_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Sǝn u xirǝgǝ altundin tɵt ⱨalⱪa yasap, bu ⱨalⱪilarni xirǝning tɵt burjikidiki qetiⱪⱪa ornatⱪin. ");
INSERT INTO uigpin_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Xirǝni kɵtürüxkǝ baldaⱪlar ɵtküzülsun dǝp, ⱨalⱪilar xirǝ lewigǝ yeⱪin bekitilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Baldaⱪlarni akatsiyǝ yaƣiqidin yasap, altun bilǝn ⱪapliƣin; xirǝ ular arⱪiliⱪ kɵtürilidu. ");
INSERT INTO uigpin_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Xirǝgǝ yandap legǝn, ⱪaqa-tǝhsǝ, piyalǝ wǝ xarab ⱨǝdiyǝlirini qaqidiƣan ⱪǝdǝⱨlǝrni yasiƣin; ularni sap altundin yasiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Mening ⱨuzurumda turuxⱪa sǝn xirǝgǝ ⱨǝmixǝ «tǝⱪdim nan»ni ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Sǝn ⱨǝm sap altundin bir qiraƣdan yasiƣin. U qiraƣdan soⱪup yasalsun; qiraƣdanning puti, ƣoli, ⱪǝdǝⱨliri, ƣunqǝ wǝ qeqǝkliri pütün bir altundin soⱪulsun.    ");
INSERT INTO uigpin_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Qiraƣdanning ƣolining ikki yenidin altǝ xahqǝ qiⱪirilsun — qiraƣdanning bir yenidin üq xahqǝ, qiraƣdanning yǝnǝ bir yenidin üq xahqǝ qiⱪirilsun; ");
INSERT INTO uigpin_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","bir yenidiki ⱨǝrbir xahqidǝ badam güli xǝklidǝ ƣunqisi wǝ qeqiki bolƣan üq ⱪǝdǝⱨ qiⱪirilsun, yǝnǝ bir yenidiki ⱨǝrbir xahqidǝ badam güli xǝklidǝ ƣunqisi wǝ qeqiki bolƣan üq ⱪǝdǝⱨ qiⱪirilsun. Qiraƣdanƣa qiⱪirilƣan altǝ xahqining ⱨǝmmisi xundaⱪ yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Qiraƣdanning ƣolidin badam güli xǝklidǝ ƣunqisi wǝ qeqiki bolƣan tɵt ⱪǝdǝⱨ qiⱪirilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Bulardin baxⱪa birinqi ikki xahqining astida bir ƣunqǝ, ikkinqi ikki xahqining astida bir ƣunqǝ, üqinqi ikki xahqining astida bir ƣunqǝ bolsun; qiraƣdanƣa qiⱪirilƣan altǝ xahqining asti ⱨǝmmisi xundaⱪ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Uning xu ƣunqiliri ⱨǝm xahqiliri qiraƣdan bilǝn bir gǝwdǝ ⱪilinsun — bir pütün sap altundin soⱪup yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Sǝn qiraƣdanning yǝttǝ qiriƣini yasiƣin; qiraƣlar udulƣa yoruⱪ qüxürǝlixi üqün üsti tǝrǝpkǝ ornitilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Uning pilik ⱪayqiliri bilǝn küldanliri sap altundin yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Qiraƣdan wǝ uning barliⱪ ǝswabliri bir talant sap altundin yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Sanga taƣda ayan ⱪilinƣan nusha boyiqǝ bularni eⱨtiyat bilǝn yasiƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Muⱪǝddǝs qedirni on parqǝ yopuⱪtin yasatⱪin; yopuⱪlar nepiz toⱪulƣan aⱪ kanap rǝhtkǝ kɵk, sɵsün wǝ ⱪizil yiplar arilaxturulup ixlǝnsun; uningƣa kerublarning süritini qewǝr ⱪollarƣa nǝpis ⱪilip kǝxtilǝp qiⱪarƣuzƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ⱨǝrbir yopuⱪning uzunluⱪi yigirmǝ sǝkkiz gǝz, kǝngliki tɵt gǝz bolup, ⱨǝrbir yopuⱪ ohxax qong-kiqikliktǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Yopuⱪlarning bǝxi bir-birigǝ ulansun, ⱪalƣan bǝx yopuⱪmu ⱨǝm bir-birigǝ ulansun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Sǝn ulap qiⱪilƣan birinqi qong parqining ǝng qetidiki ⱪismiƣa bir tǝripigǝ rǝnggi kɵk izmǝ ⱪadiƣin, xuningdǝk ulap qiⱪilƣan ikkinqi qong parqining ǝng qetidikisining bir tǝripigimu ⱨǝm xundaⱪ ⱪilƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Birinqi qong parqining ǝng qetidiki ⱪismiƣa ǝllik izmǝ ⱪadiƣin, ikkinqi qong parqining ǝng qetidikisigimu ǝllik izmǝ ⱪadiƣin. Izmilǝr bir-birigǝ udulmuudul bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Muⱪǝddǝs qedir bir pütün bolsun üqün altundin ǝllik ilƣu yasap, ikki qong parqǝ yopuⱪni xu ilƣular bilǝn bir-birigǝ tutaxturƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Muⱪǝddǝs qedirni yepix üqün ɵqkǝ tiwitidin yopuⱪlarni yasiƣin; yopuⱪtin on bir parqǝ yasiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Yopuⱪlarning ⱨǝrbirining uzunluⱪi ottuz gǝz, kǝngliki tɵt gǝz bolup, on bir yopuⱪning ⱨǝmmisi ohxax qong-kiqikliktǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Yopuⱪlarning bǝxini ulap bir ⱪilip, ⱪalƣan altǝ yopuⱪnimu ulap bir ⱪilip, altinqi yopuⱪni ikki ⱪat ⱪilip, qedirning aldi tǝripigǝ sanggilitip ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Sǝn birinqi ulap qiⱪilƣan qong parqining ǝng qetidiki ⱪismiƣa ǝllik izmǝ, ikkinqi ulap qiⱪilƣan qong parqining ǝng qetidiki ⱪismiƣa ǝllik izmǝ ⱪadiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Sǝn ⱨǝm mistin ǝllik ilƣu yasap, qedir bir pütün bolsun üqün ularni izmilǝrgǝ ɵtküzüp ikki qong parqini ulap ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Lekin yopuⱪning qedirning kǝynidin exip ⱪalƣan ⱪismi, yǝni exip ⱪalƣan yerim parqisi qedirning kǝyni tǝripidǝ sanggilap tursun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Qedir yopuⱪlirining qedirning boyidin artuⱪ ⱪismi, yǝni u tǝripidin bir gǝz, bu tǝripidin bir gǝz, qedirning ikki tǝripidin sanggilap, uni toluⱪ yapsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Buningdin baxⱪa, qedirƣa ⱪizil boyalƣan ⱪoqⱪar terisidin yopuⱪ yasap yapⱪin, andin uning üstidinmu delfin terisidin yasalƣan yǝnǝ bir yopuⱪni ⱪapliƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Muⱪǝddǝs qedirning tik tahtaylirini akatsiyǝ yaƣiqidin yasap tikligin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ⱨǝrbir tahtayning uzunluⱪi on gǝz, kǝngliki bir yerim gǝz bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ⱨǝrbir tahtayning ikkidin turumi bolsun, ⱨǝr ikki tahtay xular bilǝn bir-birigǝ qetilsun; qedirning barliⱪ tahtaylirini xundaⱪ yasiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Qedirning tahtaylirini xundaⱪ yasiƣin; yigirmisini jǝnub tǝrǝpkǝ tikligin; ");
INSERT INTO uigpin_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","bu yigirmǝ tahtayning tegigǝ kümüxtin ⱪiriⱪ tǝglik yasiƣin; bir tahtayning astidiki ikki turumi üqün ikkidin tǝglik, yǝnǝ bir tahtayning ikki turumi üqün ikkidin tǝglik yasiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Xuningdǝk qedirning udul tǝripidǝ, yǝni ximal tǝripidǝ yigirmǝ tahtay bolsun; ");
INSERT INTO uigpin_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","bularning ⱪiriⱪ tǝgliki kümüxtin bolsun; bir tahtayning tegigǝ ikkidin tǝglik, yǝnǝ bir tahtayning tegigǝ ikkidin tǝglik orunlaxturulsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Qedirning kǝyni tǝripigǝ, yǝni ƣǝrb tǝrǝpkǝ altǝ tahtay yasap tikligin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Qedirning kǝyni tǝripidiki ikki bulungƣa ikki tahtay yasap ornatⱪin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Bu bulung tahtayliri astidin üstigiqǝ ikki ⱪat ⱪilinip tahtaylarni ɵzara qetixtursun, üsti bir ⱨalⱪiƣa bekitilsun. Ⱨǝr ikkisi xundaⱪ ⱪilinip, ikki bulungƣa tiklǝnsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Arⱪa tǝrǝptǝ sǝkkiz tahtay bolidu, ularning kümüxtin yasalƣan on altǝ tǝgliki bolidu; bir tahtayning tegidǝ ikki tǝglik, yǝnǝ bir tahtayning tegidǝ ikki tǝglik bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Buningdin baxⱪa sǝn akatsiyǝ yaƣiqidin baldaⱪ yasiƣin; qedirning bu tǝripidiki tahtaylarƣa bǝx baldaⱪni, ");
INSERT INTO uigpin_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","qedirning u tǝripidiki tahtaylarƣa bǝx baldaⱪni, qedirning arⱪa tǝripidiki tahtaylarƣa, yǝni ƣǝrb tǝripidiki tahtaylarƣa bǝx baldaⱪni yasiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Tahtaylarning otturisidiki ottura baldaⱪ bu tǝrǝptin u tǝrǝpkǝ yetidiƣan bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tahtaylarni altun bilǝn ⱪaplap, baldaⱪlar ɵtküzülidiƣan ⱨalⱪilarni altundin yasap, baldaⱪlarni altun bilǝn ⱪapliƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Qedirni sanga taƣda ayan ⱪilinƣan nusha boyiqǝ yasap tikligin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Sǝn nepiz toⱪulƣan aⱪ kanap rǝhtkǝ kɵk, sɵsün wǝ ⱪizil yiplar arilaxturulup ixlǝngǝn bir pǝrdǝ yasiƣin; uni qewǝr ⱪollar kerublarning süritini nǝpis ⱪilip qüxürüp kǝxtilǝp qiⱪsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Uni akatsiyǝ yaƣiqidin yasalƣan tɵt hadiƣa esip ⱪoyƣin. Bu hadilar altun bilǝn ⱪaplansun, ⱨǝrbirining altun ilmiki bolsun; hadilar kümüxtin yasalƣan tɵt tǝglikkǝ ornitilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Pǝrdǝ qedir yopuⱪidiki ilmǝklǝrgǝ esilip sanggilitip ⱪoyulsun; andin ⱨɵküm-guwaⱨliⱪ sanduⱪini xu yǝrgǝ kǝltürüp, pǝrdining iqigǝ elip kirgin. Xuning bilǝn pǝrdǝ silǝr üqün muⱪǝddǝs jay bilǝn ǝng muⱪǝddǝs jayning otturisidiki bir ayrima pǝrdǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Andin sǝn «kǝfarǝt tǝhti»ni ǝng muⱪǝddǝs jaydiki ⱨɵküm-guwaⱨliⱪ sanduⱪining üstigǝ ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Xirǝ bolsa pǝrdining texiƣa orunlaxturulsun; qiraƣdanni xirǝning uduliƣa, qedirning jǝnub tǝripigǝ ⱪoyƣin; xirǝni ximal tǝripigǝ ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Buningdin baxⱪa sǝn qedirning kirix eƣiziƣa nepiz toⱪulƣan aⱪ kanap rǝhtkǝ kɵk, sɵsün wǝ ⱪizil yiplar arilaxturulup ixlǝngǝn bir pǝrdǝ yasiƣin; u kǝxtiqi tǝripidin kǝxtilǝnsun. ");
INSERT INTO uigpin_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Bu pǝrdǝ üqün akatsiyǝ yaƣiqidin bǝx hada yasap, ularni altun bilǝn ⱪapliƣin; ⱨǝrbirining altun ilmiki bolsun; ularning tegigǝ bǝx danǝ tǝglikni mistin ⱪuyup tǝyyarlatⱪin. ");
INSERT INTO uigpin_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Sǝn ⱪurbangaⱨni akatsiyǝ yaƣiqidin yasiƣin. Ⱪurbangaⱨ tɵt qasa bolsun; uzunluⱪi bǝx gǝz, kǝngliki bǝx gǝz, egizliki üq gǝz ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Uning tɵt burjikigǝ ⱪoyulidiƣan münggüzlirini yasiƣin; münggüzliri ⱪurbangaⱨ bilǝn bir gǝwdǝ ⱪilinsun. Ⱪurbangaⱨni mis bilǝn ⱪapliƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ⱪurbangaⱨning yaƣ wǝ külini elixⱪa daslarni yasiƣin; uningƣa has bolƣan gürjǝklǝrni, korilarni, lahxigirlarni wǝ otdanlarnimu yasiƣin; uning barliⱪ ǝswablirini yasaxⱪa mis ixlǝtkin. ");
INSERT INTO uigpin_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ⱪurbangaⱨ üqün mistin bir xala yasiƣin; xalaning tɵt burjikigǝ tɵt mis ⱨalⱪa yasap bekitip ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Xalani ⱪurbangaⱨning ⱪap belining astidiki girwǝktin tɵwǝnrǝk turidiƣan ⱪilƣin, xundaⱪta xala ⱪurbangaⱨning dǝl otturisida bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ⱪurbangaⱨⱪa ikki baldaⱪ yasiƣin; ular akatsiyǝ yaƣiqidin bolsun, ularni mis bilǝn ⱪapliƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ⱪurbangaⱨni kɵtürgǝndǝ, baldaⱪlar uning ikki yenida boluxi üqün, ularni ⱨalⱪilarƣa ɵtküzüp ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ⱪurbangaⱨni tahtaylardin yasiƣin, iqi box bolsun; u taƣda sanga ayan ⱪilinƣan nusha boyiqǝ ⱨünǝrwǝnlǝr tǝyyar ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Muⱪǝddǝs qedirning ⱨoylisinimu yasiƣin. Ⱨoylining jǝnubiƣa, yǝni jǝnubⱪa yüzlǝngǝn tǝripigǝ nepiz toⱪulƣan aⱪ kanap rǝhttin pǝrdilǝrni toⱪuƣin; xu tǝripining uzunluⱪi yüz gǝz bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Pǝrdilǝrni esixⱪa yigirmǝ hada yasalsun; ularning tegigǝ ⱪoyuxⱪa yigirmǝ mis tǝglik yasalsun; hadilarning ilmiki bilǝn baldaⱪlar bolsa kümüxtin yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Xuningƣa ohxax ximal tǝripidimu uzunluⱪi yüz gǝz kelidiƣan pǝrdǝ bolsun. Pǝrdilǝrni esixⱪa yigirmǝ hada yasalsun; ularning tegigǝ ⱪoyuxⱪa yigirmǝ mis tǝglik yasalsun; hadilarning ilmiki bilǝn baldaⱪlar bolsa kümüxtin yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ⱨoylining ƣǝrb tǝripidǝ uzunluⱪi ǝllik gǝz kelidiƣan pǝrdǝ bolsun; uning on hadisi wǝ on tǝgliki bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ⱨoylining xǝrⱪ tǝripi, yǝni kün qiⱪixⱪa yüzlǝngǝn tǝripining kǝngliki ǝllik gǝz bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Bir tǝripidǝ on bǝx gǝz kelidiƣan pǝrdǝ bolsun; uning üq hadisi bilǝn üq tǝgliki bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Yǝnǝ bir tǝripidǝ on bǝx gǝz kelidiƣan pǝrdǝ bolsun; uning üq hadisi bilǝn üq tǝgliki bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ⱨoylining kirix eƣiziƣa yigirmǝ gǝz kelidiƣan bir pǝrdǝ ⱪoyulsun; pǝrdǝ nepiz toⱪulƣan aⱪ kanap rǝhtkǝ kɵk, sɵsün wǝ ⱪizil yiplar arilaxturulup, kǝxtiqi tǝripidin kǝxtilǝnsun. Uning tɵt hadisi bilǝn tɵt tǝgliki bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ⱨoylining qɵrisidiki ⱨǝmmǝ hadilar kümüxtin yasalƣan baldaⱪlar bilǝn bir-birigǝ qetilsun; ularning ilmǝkliri kümüxtin, tǝglikliri mistin yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ⱨoylining uzunluⱪi yüz gǝz, kǝngliki ⱨǝr ikki tǝripi ǝllik gǝz bolsun; nepiz toⱪulƣan aⱪ kanap rǝhttin ixlǝngǝn pǝrdining egizliki bǝx gǝz ⱪilinsun; hadilarning tǝglikliri mistin yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Muⱪǝddǝs qedirning ix-hizmitidǝ ixlitilidiƣan barliⱪ ǝswab-saymanliri ⱨǝmdǝ barliⱪ miⱪ-ⱪozuⱪliri, xundaⱪla ⱨoylining barliⱪ miⱪ-ⱪozuⱪliri mistin bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","— Qiraƣning ⱨǝmixǝ yeniⱪ turuxi üqün, qiraƣⱪa ixlitixkǝ zǝytundin soⱪup qiⱪirilƣan sap mayni ⱪexingƣa kǝltürüxkǝ Israillarni buyruƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Jamaǝt qedirining iqidǝ, ⱨɵküm-guwaⱨliⱪ sanduⱪining udulidiki pǝrdining taxⱪirida Ⱨarun wǝ oƣulliri ⱨǝr keqisi ǝtigǝngiqǝ Pǝrwǝrdigarning aldida qiraƣlarning yeniⱪ turƣuzux ixida bolsun. Bu ix dǝwrdin-dǝwrgiqǝ Israillarƣa ǝbǝdiy bir ⱪanun-bǝlgilimǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Sǝn Israillarning iqidin akang Ⱨarun wǝ uning oƣullirini ɵz ⱪexingƣa kǝltürgin; ularni, yǝni Ⱨarun wǝ oƣulliri Nadab, Abiⱨu, Əliazar wǝ Itamarlarning Mening kaⱨinliⱪ hizmitimdǝ boluxi üqün yeningƣa kǝltürgin. ");
INSERT INTO uigpin_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Akang Ⱨarunƣa ⱨǝm xǝrǝp ⱨǝm güzǝllik üqün muⱪǝddǝs kiyimlǝrni tǝyyarliƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ⱨarunning Manga muⱪǝddǝs ⱪilinip, Mening kaⱨinliⱪ hizmitimdǝ boluxi üqün, Mǝn ǝⱪil-parasǝtning roⱨi bilǝn ⱪǝlblirini toldurƣan qewǝr kixilǝrning ⱨǝrbirigǝ sɵz ⱪilip, ularni alaⱨidǝ kiyimlǝrni tikixkǝ buyruƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ular tikidiƣan kiyimlǝr munulardin ibarǝt: — bir ⱪoxen, bir ǝfod, bir ton, kǝxtilǝngǝn bir halta kɵnglǝk, bir sǝllǝ wǝ bir bǝlwaƣ. Mening kaⱨinliⱪ hizmitimdǝ boluxi üqün, ular akang Ⱨarunƣa wǝ oƣulliriƣa muⱪǝddǝs kiyimlǝrni tiksun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Uningƣa altun wǝ kɵk, sɵsün, ⱪizil yiplar bilǝn nepiz toⱪulƣan aⱪ kanap rǝht ixlitilsun; ");
INSERT INTO uigpin_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ǝfodni ular altun wǝ kɵk, sɵsün, ⱪizil yiplar bilǝn nepiz toⱪulƣan aⱪ kanap rǝhtlǝrni tǝyyarlap, qewǝr ⱪollarƣa nǝpis ⱪilip kǝxtilitip ixlǝtsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Əfodning ikki bexini bir-birgǝ tutaxturux üqün ikki dolisida mürilik tasma bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Əfodning üstidin baƣlaydiƣan, kǝxtilǝngǝn bǝlwaƣ ǝfod bilǝn bir pütün ⱪilinsun wǝ uningƣa ohxax sipta ixlinip, altun wǝ kɵk, sɵsün, ⱪizil yiplar wǝ nepiz toⱪulƣan aⱪ kanap rǝhttin yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ikki aⱪ ⱨeⱪiⱪni tepip, ularning üstigǝ Israilning oƣullirining namlirini oydurƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ularning namlirining altisi bir yaⱪutⱪa oyulsun, ⱪalƣan altisi bolsa yǝnǝ bir yaⱪutⱪa oyulsun, ⱨǝmmisi tuƣulux tǝrtipi boyiqǝ pütülsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Huddi yaⱪut nǝⱪixqiliri ixligǝndǝk, mɵⱨür oyulƣandǝk Israilning oƣullirining namlirini ikki yaⱪutⱪa oydurƣin; ular altundin yasalƣan kɵzlükkǝ bekitilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Israilning oƣulliriƣa ǝslǝtmǝ tax bolsun üqün, ikki yaⱪutni ǝfodning ikki mürilik tasmisiƣa ⱪadiƣuzƣin; xundaⱪ bolƣanda, Ⱨarun Pǝrwǝrdigarning aldida ularning namlirini ǝslǝtmǝ süpitidǝ müriliridǝ kɵtürüp yüridu. ");
INSERT INTO uigpin_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Buningdin baxⱪa, sǝn altundin yǝnǝ ikki kɵzlük wǝ sap altundin xoynidǝk exip etilgǝn ikki zǝnjir yasatⱪin; andin exilmǝ zǝnjirlǝr kɵzlüklǝrgǝ bekitilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Ⱨɵküm ⱪoxeni»ni qewǝr ⱪollarƣa nǝpis ⱪilip kǝxtilitip yasatⱪin; uni ⱨǝm ǝfodni ixligǝn usulda yasiƣan, altun wǝ kɵk, sɵsün, ⱪizil yiplar bilǝn nepiz toⱪulƣan aⱪ kanap rǝhttin yasiƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","U ikki ⱪat, tɵt qasa ⱪilinsun; uzunluⱪi bir ƣeriq, kǝnglikimu bir ƣeriq bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Uning üstigǝ tɵt ⱪatar ⱪilip gɵⱨǝrlǝrni ornatⱪin: — birinqi ⱪatarƣa ⱪizil yaⱪut, seriⱪ gɵⱨǝr wǝ zumrǝt ornitilsun; ");
INSERT INTO uigpin_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ikkinqi ⱪatarƣa kɵk ⱪaxtexi, kɵk yaⱪut wǝ almas ornitilsun; ");
INSERT INTO uigpin_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","üqinqi ⱪatarƣa sɵsün yaⱪut, piroza wǝ sɵsün kwarts ornitilsun; ");
INSERT INTO uigpin_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","tɵtinqi ⱪatarƣa beril yaⱪut, aⱪ ⱨeⱪiⱪ wǝ anartax ornitilsun; bularning ⱨǝmmisi altun kɵzlük iqigǝ ornitilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Bu gɵⱨǝrlǝr Israilning oƣullirining namliriƣa wǝkil ⱪilinip, ularning sanidǝk on ikki bolup, mɵⱨür oyƣandǝk ⱨǝrbir gɵⱨǝrgǝ on ikki ⱪǝbilining nami birdin-birdin pütülsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ⱪoxenƣa xoynidǝk exilgǝn sap altundin ikki exilmǝ zǝnjir yasiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ⱪoxenƣa altundin ikki ⱨalⱪa etip, ikki ⱨalⱪini ⱪoxenning yuⱪiriⱪi ikki burjikigǝ bekitkin; ");
INSERT INTO uigpin_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","andin altundin exilip yasalƣan ikki zǝnjirni ⱪoxenning yuⱪiriⱪi ikki burjikidiki ⱨalⱪidin ɵtküzüp, ");
INSERT INTO uigpin_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","exilgǝn xu zǝnjirlǝrning ikki uqini ikki kɵzlükkǝ bekitip, kɵzlüklǝrni ǝfodning ikki mürilik tasmisining aldi ⱪismiƣa ornatⱪin. ");
INSERT INTO uigpin_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Buningdin baxⱪa sǝn altundin ikki ⱨalⱪa yasap, ularni ⱪoxenning asti tǝripidiki ikki burjikigǝ bekitkin; ular ǝfodⱪa tegixip turidiƣan ⱪilinip iqigǝ ⱪadalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Mundin baxⱪa sǝn altundin yǝnǝ ikki ⱨalⱪa yasap, ularni ǝfodning ikki mürilik tasmisining aldi tɵwǝnki ⱪismiƣa, yǝni ǝfodⱪa ulinidiƣan jayƣa yeⱪin ⱪilip, kǝxitilǝngǝn bǝlwaƣdin egizrǝk ⱪilip bekitkin. ");
INSERT INTO uigpin_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ⱪoxenning ǝfodning kǝxitilǝngǝn bǝlweƣidin yuⱪiriraⱪ turuxi, ⱪoxenning ǝfodtin ajrap kǝtmǝsliki üqün ⱪoxenning ⱨalⱪisini kɵk xoyna bilǝn ǝfodning ⱨalⱪisiƣa qetip ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Xundaⱪ ⱪilƣanda, Ⱨarun muⱪǝddǝs jayƣa kirgǝndǝ, ⱨɵküm ⱪoxenini taⱪiƣaqⱪa, Israilning oƣullirining namlirini ǝslǝtmǝ süpitidǝ yürikining üstidǝ Pǝrwǝrdigarning aldida daim kɵtürüp yürgǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ⱨarun Pǝrwǝrdigarning aldiƣa kirgǝndǝ, urim bilǝn tummim uning yüriki üstidǝ boluxi üqün, bularni ⱨɵküm ⱪoxenining iqigǝ alƣin; muxundaⱪ ⱪilƣanda, Ⱨarun Israillarƣa baƣliⱪ ⱨɵkümlǝrni ⱨǝmixǝ Pǝrwǝrdigarning ⱨuzurida ɵz yüriki üstidǝ kɵtürüp yürgǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Əfodning iqidiki tonni pütünlǝy kɵk rǝnglik ⱪilƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Tonning baxⱪa kiyilidiƣan tɵxüki dǝl otturisida bolsun; uning yirtilip kǝtmǝsliki üqün huddi bapkar toⱪuƣandǝk, sawutning yaⱪisiƣa ohxax qɵrisigǝ pǝwaz qiⱪirilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Uning etikining qɵrisigǝ kɵk, sɵsün wǝ ⱪizil yiptin anarlarni toⱪup asⱪin ⱨǝmdǝ altun ⱪongƣuraⱪlarni yasap, qɵrisidiki anarlarning ariliⱪiƣa birdin esip ⱪoyƣin; tonning etikining pütkül qɵrisigǝ bir altun ⱪongƣuraⱪ, bir anar, yǝnǝ bir altun ⱪongƣuraⱪ, bir anar... bekitilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ⱨarun hizmǝt ⱪilƣan waⱪtida xu tonni kiysun; buning bilǝn Ⱨarun Pǝrwǝrdigarning aldiƣa barƣanda, yǝni muⱪǝddǝs jayƣa, Pǝrwǝrdigarning aldiƣa kirip-qiⱪⱪanda uning awazi anglinip turidu-dǝ, u ɵlümdin aman ⱪalidu. ");
INSERT INTO uigpin_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Andin keyin sǝn sap altundin nǝpis bir otuƣatni yasap, uning üstigǝ mɵⱨürgǝ nǝⱪixlǝngǝndǝk: «Pǝrwǝrdigarƣa muⱪǝddǝs ⱪilindi» dǝp oyƣin;    ");
INSERT INTO uigpin_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","uni kɵk rǝnglik yip bilǝn sǝllisigǝ qigkin; u sǝllining aldi tǝripigǝ taⱪalsun; ");
INSERT INTO uigpin_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","u Ⱨarunning pexanisidǝ tursun. Buning bilǝn Ⱨarun Israillarning muⱪǝddǝs ⱪilip kǝltürgǝn barliⱪ muⱪǝddǝs ⱨǝdiyǝlirigǝ qaplaxⱪan gunaⱨlarni ɵz üstigǝ elip kɵtüridu; ⱨǝdiyǝlǝrning Pǝrwǝrdigarning aldida ⱪobul ⱪilinixi üqün otuƣat ⱨǝmixǝ uning pexanisigǝ taⱪaⱪliⱪ tursun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Buningdin baxⱪa aⱪ kanap rǝhttin bir kɵnglǝk toⱪuƣin, xuningdǝk kanap rǝhttin toⱪulƣan bir sǝllǝ tǝyyarliƣin; kǝxtilǝngǝn bir bǝlwaƣ yasiƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ⱨarunning oƣulliriƣa halta kɵnglǝklǝrni tikkin; ularƣimu bǝlwaƣlarni tǝyyarla, ularƣa egiz bɵklǝrnimu tikkin; bular ularƣa ⱨǝm xǝrǝp ⱨǝm güzǝllik bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Bularning ⱨǝmmisini sǝn akang Ⱨarun wǝ uning oƣulliriƣa kiydürgin; andin ularning Mening aldimda kaⱨinliⱪ hizmitimdǝ boluxi üqün ularni mǝsiⱨlǝp, Manga muⱪǝddǝs ⱪilip ayriƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ularning ǝwrǝtlirining yepiⱪ turuxi üqün ularƣa kanap rǝhttin tambal ǝttürgin; u belidin yotisiƣiqǝ yepip tursun. ");
INSERT INTO uigpin_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ⱨarun wǝ oƣulliri jamaǝt qediriƣa kirgǝndǝ yaki muⱪǝddǝs jayda hizmǝttǝ bolux üqün ⱪurbangaⱨⱪa yeⱪinlaxⱪanda, ular gunaⱨkar bolup ɵlüp kǝtmǝsliki üqün tambalni kiyiwalsun. Bu uningƣa wǝ uningdin keyinki nǝsilliri üqün ǝbǝdiy bir bǝlgilimǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ularning Manga muⱪǝddǝs ⱪilinip, kaⱨinliⱪ hizmitimdǝ boluxi üqün mundaⱪ ixni ada ⱪilixing kerǝk: — sǝn bir yax ǝrkǝk torpaⱪ bilǝn ikki ⱪoqⱪarni talla (ⱨǝmmisi bejirim bolsun) ");
INSERT INTO uigpin_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ⱨǝmdǝ petir nan, zǝytun meyi ilǝxtürülgǝn petir toⱪaq wǝ zǝytun meyi sürülüp mǝsiⱨlǝngǝn petir ⱨǝmǝk nanlarni tǝyyarla, bularning ⱨǝmmisini buƣday unidin ⱪilƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","nanlarning ⱨǝmmisini bir sewǝtkǝ selip, sewǝtni, torpaⱪni wǝ ikki ⱪoqⱪarni billǝ ⱨǝdiyǝ ⱪilip kǝltürgin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Sǝn Ⱨarun wǝ uning oƣullirini jamaǝt qedirining kirix eƣiziƣa yeⱪin elip kelip, ularni su bilǝn yuƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","andin kiyimlirini elip kelip, Ⱨarunƣa halta kɵnglǝk, ǝfod toni wǝ ǝfodni kiydürgin, ⱪoxenni taⱪiƣin; andin beligǝ ǝfodning kǝxtilǝngǝn bǝlweƣini baƣliƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Bexiƣa sǝllini yɵgǝp, sǝlligǝ muⱪǝddǝs otuƣatni taⱪap ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Andin mǝsiⱨlǝx meyini elip, bexiƣa ⱪuyup uni mǝsiⱨligin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Andin sǝn uning oƣullirini elip kelip, ularƣa halta kɵnglǝklǝrni kiydürgin; ");
INSERT INTO uigpin_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ularƣa, yǝni Ⱨarun wǝ uning oƣulliriƣa bǝlwaƣlarni baƣlap, egiz bɵklǝrni kiydürgin. Xuning bilǝn ǝbǝdiy bǝlgilimǝ boyiqǝ, kaⱨinliⱪ hizmiti ularningki bolidu; xundaⱪ ⱪilip, sǝn Ⱨarun bilǝn uning oƣullirini Hudaƣa muⱪǝddǝs ⱪilip ayrip tǝyinligin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","— Sǝn torpaⱪni jamaǝt qedirining aldiƣa elip kǝlgin; elip kǝlginingdǝ Ⱨarun bilǝn uning oƣulliri ⱪollirini torpaⱪning bexiƣa ⱪoysun.    ");
INSERT INTO uigpin_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Andin sǝn bu torpaⱪni Pǝrwǝrdigarning aldida, jamaǝt qedirining kirix eƣizining yenida boƣuzliƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","torpaⱪning ⱪenidin elip barmiⱪing bilǝn uni ⱪurbangaⱨning münggüzlirigǝ sürüp, ⱪalƣan ⱪanning ⱨǝmmisini ⱪurbangaⱨning tüwigǝ tɵküp ⱪuyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Iq ⱪarnini yɵgǝp turƣan barliⱪ mayni, xundaⱪla jigǝrning üstidiki qawa may, ikki bɵrǝk wǝ ularning üstidiki mayni ajritip bularni ⱪurbangaⱨta kɵydürgin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Torpaⱪning gɵxi, terisi wǝ tezikini bolsa qedirgaⱨning sirtiƣa elip qiⱪip, otta kɵydürüwǝtkin; bu gunaⱨ ⱪurbanliⱪi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Andin sǝn ⱪoqⱪarlarning birini elip kǝlgin; Ⱨarun bilǝn uning oƣulliri ⱪollirini ⱪoqⱪarning bexiƣa ⱪoysun; ");
INSERT INTO uigpin_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","andin sǝn bu ⱪoqⱪarni boƣuzlap, uning ⱪenidin ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpkin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ⱪoqⱪarni parqilap, uning iq ⱪarni bilǝn paqaⱪlirini yuyup, ularni gɵx parqiliri wǝ baxning üstigǝ ⱪoyup, ");
INSERT INTO uigpin_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","pütün ⱪoqⱪarni ⱪurbangaⱨta kɵydürgin. Bu Pǝrwǝrdigarƣa atalƣan kɵydürmǝ ⱪurbanliⱪ — ot arⱪiliⱪ sunulidiƣan, Pǝrwǝrdigarƣa huxbuy yǝtküzidiƣan ⱨǝdiyǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Keyin sǝn ikkinqi ⱪoqⱪarni elip kǝlgin; Ⱨarun wǝ uning oƣulliri ⱪollirini ⱪoqⱪarning bexiƣa ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Andin bu ⱪoqⱪarni boƣuzlap ⱪenidin elip, Ⱨarunning ong ⱪuliⱪining yumxiⱪiƣa, uning oƣullirining ong ⱪuliⱪining yumxiⱪiƣa, ularning ong ⱪollirining qong barmiⱪi bilǝn ong putlirining qong barmiⱪiƣa sürkǝp ⱪoyƣin, ⱪalƣan ⱪanni ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpkin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Andin ⱪurbangaⱨ üstidiki ⱪandin wǝ mǝsiⱨlǝx meyidin elip, Ⱨarunning üstigǝ, uning kiyimlirigǝ, xuningdǝk uning oƣullirining üstigǝ wǝ ularning kiyimlirigimu sǝpkin. Xundaⱪ ⱪilip u wǝ uning kiyimliri, uning oƣulliri wǝ ularning kiyimlirimu uning bilǝn tǝng Hudaƣa atap muⱪǝddǝs ⱪilinƣan bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Andin sǝn ⱪoqⱪarning meyi, ⱪuyruⱪ meyi, iq ⱪarnini yɵgǝp turƣan barliⱪ may, jigǝrning üstidiki qawa may, ikki bɵrǝk wǝ ularning üstidiki mayni qiⱪar ⱨǝmdǝ ong arⱪa putini alƣin — (qünki bu ⱪoqⱪar kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪiƣa atalƣan ⱪoqⱪardur) — ");
INSERT INTO uigpin_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","— buningdin baxⱪa sǝn Pǝrwǝrdigarning aldida ⱪoyulƣan petir nan sewitidin bir girdini, zǝytun meyi ilǝxtürülgǝn petir toⱪaqtin birni wǝ petir ⱨǝmǝk nandin birni elip, ");
INSERT INTO uigpin_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","bularning ⱨǝmmisini Ⱨarunning ⱪolliriƣa wǝ uning oƣullirining ⱪolliriƣa ⱪoyup, ularni «pulanglatma ⱨǝdiyǝ» süpitidǝ Pǝrwǝrdigarning aldida pulanglatⱪuzƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Andin sǝn bularni ularning ⱪolliridin tapxurup elip, Pǝrwǝrdigarning aldida huxbuy qiⱪarsun dǝp, ⱪurbangaⱨtiki kɵydürmǝ ⱪurbanliⱪning üstidǝ ⱪoyup kɵydürgin. Bu ot arⱪiliⱪ Pǝrwǝrdigarƣa sunulƣan ⱨǝdiyǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Sǝn Ⱨarunni kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪiƣa atalƣan ⱪoqⱪarning tɵxini elip «pulanglatma ⱨǝdiyǝ» süpitidǝ Pǝrwǝrdigarning ⱨuzurida pulanglatⱪin; bu sening ülüxüng bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Xuningdǝk, sǝn kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪiƣa atalƣan ⱪoqⱪarning «pulanglatma ⱨǝdiyǝ» süpitidǝ pulanglitilƣan tɵxi bilǝn «kɵtürmǝ ⱨǝdiyǝ» süpitidǝ egiz kɵtürüp pulanglitilƣan arⱪa putini, yǝni Ⱨarun wǝ uning oƣulliriƣa beƣixlanƣan xu ülüxlǝrni «muⱪǝddǝs» dǝp ayrip bekitkin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Xuning bilǝn bu nǝrsilǝr ǝbǝdiy bǝlgilimǝ boyiqǝ Israillar tǝripidin Ⱨarun wǝ oƣulliriƣa beƣixlanƣan nesiwǝ bolidu; qünki u kɵtürmǝ ⱨǝdiyǝdur. Bular Israillar tǝripidin sunulidiƣan inaⱪliⱪ ⱪurbanliⱪliridin ayrip qiⱪilip, ularning Pǝrwǝrdigarƣa atap «egiz kɵtürgǝn ⱨǝdiyǝ»si ⱨesablinip, «kɵtürmǝ ⱨǝdiyǝ» bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Ⱨarunning muⱪǝddǝs kiyimlirigǝ keyin oƣulliri warisliⱪ ⱪilidu. Ular mǝsiⱨlinip, kaⱨinliⱪⱪa tǝyinlǝngǝndǝ xu kiyimlǝrni kiysun. ");
INSERT INTO uigpin_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Oƣullirining ⱪaysisi uning ornini besip kaⱨin bolsa, jamaǝt qediriƣa kirip muⱪǝddǝs jayning iqidǝ hizmǝtkǝ kirixkǝndǝ, bu kiyimlǝrni uda yǝttǝ kün kiyip yürsun. ");
INSERT INTO uigpin_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Sǝn kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪiƣa atalƣan ⱪoqⱪarni elip, uning gɵxini muⱪǝddǝs jayda pixurƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","andin Ⱨarun wǝ oƣulliri ⱪoqⱪarning gɵxi bilǝn sewǝttiki nanlarni jamaǝt qedirining kirix eƣizida yesun; ");
INSERT INTO uigpin_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ular ɵzlirining kaⱨinliⱪⱪa tǝyinlinixidǝ Hudaƣa atap muⱪǝddǝs ⱪilinƣanda kǝfarǝtkǝ ixlitilgǝn nǝrsilǝrni yesun, lekin bular muⱪǝddǝs bolƣaqⱪa, yat kixi buningdin ⱨeqnemini yemisun.    ");
INSERT INTO uigpin_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Əgǝr kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪ gɵxidin yaki nandin ǝtigǝ azraⱪ exip ⱪalsa, exip ⱪalƣanni otta kɵydürüwǝt; bular muⱪǝddǝs bolƣaqⱪa, ⱨeqkim uningdin yesǝ bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Sǝn xu tǝriⱪidǝ Ⱨarun wǝ uning oƣulliri toƣrisida buyruƣinimning ⱨǝmmisini bǝja kǝltürüp, uda yǝttǝ küngiqǝ ularni kaⱨinliⱪⱪa tiklǝx wǝzipisini ada ⱪilƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ⱨǝr küni kǝfarǝt ⱪilinixⱪa gunaⱨ ⱪurbanliⱪi süpitidǝ bir torpaⱪni sunƣin. Ⱪurbangaⱨning ɵzini gunaⱨtin pak ⱪilixⱪa uning üqünmu kǝfarǝt kǝltürgin, muⱪǝddǝs ⱪilinsun dǝp, uni zǝytun meyi bilǝn mǝsiⱨligin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Yǝttǝ küngiqǝ sǝn ⱪurbangaⱨ üqün kǝfarǝt kǝltürüp, uni muⱪǝddǝs ⱪilƣin. Buning bilǝn u «ǝng muⱪǝddǝs nǝrsilǝrning biri» ⱨesablinidu; uningƣa tǝgkǝn ⱨǝmmǝ nǝrsǝ muⱪǝddǝs ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Mana, ⱪurbangaⱨta ⱨǝmixǝ sunidiƣanliring munular: — ⱨǝr küni bir yaxliⱪ ikki ⱪoza ⱪurbanliⱪ ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Birini ǝtigǝndǝ, yǝnǝ birini gugumda ⱪurbanliⱪ ⱪilip sunƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Birinqi ⱪoza bilǝn birgǝ zǝytun meyidin bir ⱨinning tɵttin biri ilǝxtürülgǝn buƣday unidin ǝfaⱨning ondin biri wǝ yǝnǝ xarab ⱨǝdiyǝsi süpitidǝ tɵttin bir ⱨin xarab ⱪoxup sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ikkinqi ⱪozini gugumda sunƣin; uni ǝtigǝnlik ⱪurbanliⱪningkidǝk, huxbuy boluxi üqün ot arⱪiliⱪ Pǝrwǝrdigarƣa atalƣan ⱪurbanliⱪ süpitidǝ axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi bilǝn ⱪoxup sunƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Xu tǝriⱪidǝ bu kɵydürmǝ ⱪurbanliⱪ nǝsildin-nǝsilgǝ jamaǝt qedirining kirix eƣizida Pǝrwǝrdigarning ⱨuzurida ɵtküzülüp daimliⱪ ⱪurbanliⱪ bolsun; Mǝn Pǝrwǝrdigar xu yǝrdǝ silǝr bilǝn kɵrüxüp, sǝn bilǝn sɵzliximǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Xuningdǝk Mǝn xu yǝrdǝ Israillar bilǝn uqriximǝn, xuning bilǝn u jay Mening xan-xǝripim bilǝn muⱪǝddǝs ⱪilinidu. ");
INSERT INTO uigpin_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Mǝn jamaǝt qediri bilǝn ⱪurbangaⱨni Ɵzümgǝ atap muⱪǝddǝs ⱪilimǝn; Ⱨarun wǝ uning oƣullirinimu Ɵzümgǝ kaⱨinliⱪ hizmǝttǝ boluxⱪa ayrip muⱪǝddǝs ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Xundaⱪ ⱪilip Mǝn Israillarning arisida makan ⱪilip, ularning Hudasi bolimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","U waⱪitta ular Mening ularning arisida makan ⱪilixim üqün ularni Misir zeminidin qiⱪirip kǝlgǝn Hudasi Pǝrwǝrdigar ikǝnlikimni bilidu; Mǝn ularning Hudasi Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Sǝn yǝnǝ huxbuy yandurux üqün bir huxbuygaⱨni yasatⱪin; uni akatsiyǝ yaƣiqidin tǝyyarliƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","U tɵt qasa, uzunluⱪi bir gǝz, kǝngliki bir gǝz, egizliki ikki gǝz bolsun. Uning tɵt burjikidiki münggüzlǝr uning bilǝn bir pütün ⱪilip yasalsun. ");
INSERT INTO uigpin_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Sǝn uni, yǝni uning üstini, tɵt ǝtrapini ⱨǝm münggüzlirini sap altun bilǝn ⱪaplatⱪin; uning üsti ⱪismining qɵrisigǝ altundin girwǝk qiⱪarƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Uningƣa altundin ikki ⱨalⱪa yasap, uning girwikining astiƣa bekitkin; ularni ikki yeniƣa udulmu’udul bekitkin. Huxbuygaⱨni kɵtüridiƣan ikki baldaⱪni selix üqün bularni huxbuygaⱨning ikki tǝripigǝ orunlaxturƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Baldaⱪlirini akatsiyǝ yaƣiqidin yasap, altun bilǝn ⱪapliƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Huxbuygaⱨni ⱨɵküm-guwaⱨliⱪ sanduⱪining udulidiki pǝrdining sirtiƣa, yǝni Mǝn sǝn bilǝn kɵrixidiƣan jay bolƣan ⱨɵküm-guwaⱨliⱪ sanduⱪining üstidiki kǝfarǝt tǝhtining uduliƣa ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ⱨarun xuning üstidǝ esil huxbuy ǝtirni yandursun; ⱨǝr küni ǝtigǝnliki qiraƣlarni pǝrligili kǝlgǝndǝ, huxbuylarni yandursun. ");
INSERT INTO uigpin_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Xuningdǝk Ⱨarun gugumda qiraƣlarni tizip yaⱪⱪanda, huxbuy yandursun. Xundaⱪ ⱪilip Pǝrwǝrdigarning aldida nǝsildin-nǝsilgǝ huxbuy ⱨǝmixǝ ɵqürülmǝy yeniⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Silǝr uning üstidǝ nǝ ⱨeqⱪandaⱪ ƣǝyriy huxbuy yandurmanglar, nǝ kɵydürmǝ ⱪurbanliⱪ nǝ axliⱪ ⱨǝdiyǝsi sunmanglar, xundaⱪla uning üstigǝ ⱨeqⱪandaⱪ xarab ⱨǝdiyǝsini tɵkmǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ⱨǝr yilda Ⱨarun bir ⱪetim huxbuygaⱨning münggüzlirigǝ kǝfarǝt kǝltürsun; ⱨǝr ⱪetim kǝfarǝt kǝltüridiƣan gunaⱨ ⱪurbanliⱪining ⱪeni bilǝn uning üqün kǝfarǝt kǝltürsun. Nǝsildin-nǝsilgǝ xundaⱪ ⱪilinglar; bu huxbuygaⱨ Pǝrwǝrdigarƣa «ǝng muⱪǝddǝs» ⱨesablinidiƣan nǝrsilǝrning ⱪataridindur. ");
INSERT INTO uigpin_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Sǝn Israillarning sanini eniⱪlax üqün ularni saniƣiningda, ularning sanilixi wǝjidin arisiƣa balayi’apǝt kǝlmǝsliki üqün, ularni saniƣiningda ⱨǝrbir adǝm ɵz jeni üqün Pǝrwǝrdigarƣa kǝfarǝt puli tapxursun.    ");
INSERT INTO uigpin_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Royhǝtkǝ elinip, sanaⱪtin ɵtkǝnlǝrning ⱨǝmmisi berixi kerǝk bolƣini xuki, ⱨǝrbiri muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ yerim xǝkǝl bǝrsun (bir xǝkǝl yigirmǝ gǝraⱨⱪa barawǝr kelidu). Bu yerim xǝkǝl Pǝrwǝrdigarƣa «kɵtürmǝ ⱨǝdiyǝ» bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Royhǝtkǝ elinip, sanaⱪtin ɵtkǝnlǝr, yǝni yigirmǝ yax yaki uningdin qonglarning ⱨǝrbiri Pǝrwǝrdigarƣa xu «kɵtürmǝ ⱨǝdiyǝ»ni bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ɵz jeninglarƣa kǝfarǝt kǝltürüx üqün Pǝrwǝrdigarƣa kɵtürmǝ ⱨǝdiyǝ bǝrgininglarda bay kixi yerim xǝkǝldin artuⱪ bǝrmisun, kǝmbǝƣǝl kiximu yerim xǝkǝldin kǝm bǝrmisun. ");
INSERT INTO uigpin_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Sǝn Israillardin xu kǝfarǝt pulini tapxurup elip, jamaǝt qedirining hizmitigǝ beƣixlap ixlǝtkin; u pul Israillarƣa Pǝrwǝrdigarning ⱨuzurida ǝslǝtmǝ süpitidǝ jeninglarƣa kǝfarǝt kǝltüridiƣan bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Sǝn yuyunuxⱪa ixlitixkǝ mistin yoƣan bir das wǝ uningƣa mistin bir tǝglik yasatⱪin; uni jamaǝt qediri bilǝn ⱪurbangaⱨning otturisiƣa orunlaxturup, iqigǝ su toxturup ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ⱨarun bilǝn uning oƣulliri uningdiki su bilǝn put-ⱪollirini yusun. ");
INSERT INTO uigpin_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ular jamaǝt qediriƣa kirgǝndǝ ɵlmǝsliki üqün su bilǝn ɵzini yuyuxi kerǝk; ular hizmǝt ⱪilix üqün, ⱪurbangaⱨⱪa yeⱪin berip Pǝrwǝrdigarƣa ot arⱪiliⱪ atilidiƣan ⱪurbanliⱪ sunmaⱪqi bolƣinidimu, xundaⱪ ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ular ɵlmǝsliki üqün put-ⱪollirini yusun; bu ix ularƣa, yǝni ɵzi wǝ uning nǝsilliri üqün ǝwladtin ǝwladⱪiqǝ ǝbǝdiy bir bǝlgilimǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Sǝn ⱨǝmmidin esil huxbuy dora-dǝrmǝklǝrdin tǝyyarla, yǝni murmǝkki suyuⱪluⱪidin bǝx yüz xǝkǝl, darqindin ikki yüz ǝllik xǝkǝl, egirdin ikki yüz ǝllik xǝkǝl, ");
INSERT INTO uigpin_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ⱪowzaⱪdarqindin bǝx yüz xǝkǝl elip (bu ɵlqǝmlǝr muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ bolsun) wǝ zǝytun meyidinmu bir ⱨin tǝyyarla; ");
INSERT INTO uigpin_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","bu dora-dǝrmǝklǝr bilǝn mǝsiⱨ ⱪilix üqün bir muⱪǝddǝs may — ǝtirqi qiⱪarƣandǝk bir huxbuy may qiⱪarƣuzƣin. Bu «muⱪǝddǝs mǝsiⱨlǝx meyi» bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Sǝn uning bilǝn jamaǝt qedirini, ⱨɵküm-guwaⱨliⱪ sanduⱪini, ");
INSERT INTO uigpin_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","xirǝ wǝ uning barliⱪ ⱪaqa-ⱪuqilirini, qiraƣdan wǝ uning ǝswablirini, huxbuygaⱨni, ");
INSERT INTO uigpin_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨi wǝ uning ǝswablirini, yuyunux desi wǝ uning tǝglikini mǝsiⱨligin; ");
INSERT INTO uigpin_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","sǝn xu tǝrzdǝ ularni «ǝng muⱪǝddǝs nǝrsilǝr» ⱪatarida muⱪǝddǝs ⱪilƣin. Ularƣa tǝgkǝn ⱨǝrⱪandaⱪ nǝrsimu «muⱪǝddǝs» ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ⱨarun bilǝn uning oƣullirini bolsa Manga kaⱨinliⱪ hizmǝttǝ boluxi üqün mǝsiⱨlǝp muⱪǝddǝs ⱪilƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israillarƣa sɵz ⱪilip mundaⱪ eytⱪin: — Bu may ǝwladtin ǝwladⱪiqǝ Manga atalƣan muⱪǝddǝs mǝsiⱨlǝx meyi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Uni adǝmning bǝdinigǝ ⱪuysa bolmaydu; xuningdǝk uningƣa ohxaydiƣan yaki tǝrkibi ohxixidiƣan ⱨeqⱪandaⱪ maylarni yasimanglar. U muⱪǝddǝs bolƣini üqün silǝrgimu muⱪǝddǝs boluxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kimki tǝrkibi xuningƣa ohxaydiƣan may tǝngxisǝ, yaki uni elip yat birsigǝ sürsǝ, u ɵz hǝlⱪi arisidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — Sǝn huxbuy dora-dǝrmǝklǝr, yǝni huxbuy yelim, dengiz ⱪululisi meyi, aⱪ dewirⱪay wǝ sap mǝstiki tǝyyarliƣin. Bularning ⱨǝmmisi ohxax miⱪdarda bolsun; ");
INSERT INTO uigpin_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Huddi ǝtirqi may qiⱪarƣanƣa ohxax, ularni tǝngxǝp huxbuy yasiƣin; u tuzlanƣan, sap wǝ muⱪǝddǝs puraⱪliⱪ ǝtir bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Sǝn uningdin azraⱪ elip, talⱪandǝk obdan ezip, jamaǝt qediridiki ⱨɵküm-guwaⱨliⱪ sanduⱪining uduliƣa, yǝni  Mǝn silǝr bilǝn kɵrüxidiƣan jayning aldiƣa ⱪoyƣin. Bu silǝrgǝ Pǝrwǝrdigarƣa atalƣan «ǝng muⱪǝddǝs nǝrsilǝr» ⱪatarida ⱨesablansun. ");
INSERT INTO uigpin_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Silǝr yasiƣan bu huxbuyning retsepi bilǝn ɵzünglarƣimu ohxax bir huxbuyni yasiwalsanglar bolmaydu. U sanga nisbǝtǝn eytⱪanda Pǝrwǝrdigarƣa has ⱪilinƣan muⱪǝddǝs bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kimki uning puriⱪini purap ⱨuzurlinix üqün uningƣa ohxap ketidiƣan ⱨǝrⱪandaⱪ bir huxbuyni yasisa, u ɵz hǝlⱪi arisidin üzüp taxlansun. ");
INSERT INTO uigpin_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Pǝrwǝrdigar Huda Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Mana, Mǝn Ɵzüm Yǝⱨuda ⱪǝbilisidin bolƣan Hurning nǝwrisi, urining oƣli Bǝzalǝlni ismini atap qaⱪirdim;    ");
INSERT INTO uigpin_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","uni Hudaning Roⱨi bilǝn toldurup, uningƣa danaliⱪ, ǝⱪil-parasǝt, ilim-ⱨekmǝt igilitip, uni ⱨǝrtürlük ixni ⱪilixⱪa ⱪabiliyǝtlik ⱪilip, ");
INSERT INTO uigpin_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","türlük-türlük ⱨünǝrlǝrni ⱪilalaydiƣan, yǝni altun, kümüx wǝ mis ixlirini ⱪilalaydiƣan, ");
INSERT INTO uigpin_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","yaⱪutlarni kesip-oyalaydiƣan, ularni zinnǝt buyumliriƣa ornitalaydiƣan, yaƣaqlarƣa nǝⱪix qiⱪiralaydiƣan, ⱨǝrhil ⱨünǝr ixlirini ⱪamlaxturalaydiƣan ⱪildim. ");
INSERT INTO uigpin_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Xuningdǝk mana, Mǝn yǝnǝ Dan ⱪǝbilisidin Aⱨisamaⱪning oƣli Oⱨoliyabni uningƣa yardǝmqilikkǝ tǝyinlidim, xundaⱪla Mǝn sanga buyruƣan ⱨǝmmǝ nǝrsilǝrni yasisun dǝp, barliⱪ pǝm-parasǝtlik kixikǝrning kɵngligǝ tehimu ǝⱪil-parasǝt ata ⱪildim; ");
INSERT INTO uigpin_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","xuning bilǝn ular jamaǝt qedirini, ⱨɵküm-guwaⱨliⱪ sanduⱪini, uning üstidiki kǝfarǝt tǝhtini, qedirining ⱨǝmmǝ ǝswablirini, ");
INSERT INTO uigpin_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","xirǝ bilǝn uning ⱪaqa-ⱪuqilirini, sap altundin yasilidiƣan qiraƣdan bilǝn uning barliⱪ ǝswablirini, huxbuygaⱨni, ");
INSERT INTO uigpin_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨi bilǝn uning barliⱪ ǝswablirini, yuyux desi bilǝn uning tǝglikini yasiyalaydiƣan, ");
INSERT INTO uigpin_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","hizmǝt kiyimliri, yǝni kaⱨinliⱪ hizmitidǝ kiyilidiƣan, Ⱨarun kaⱨinning muⱪǝddǝs kiyimliri wǝ uning oƣullirining kaⱨinliⱪ kiyimlirini toⱪuyalaydiƣan, ");
INSERT INTO uigpin_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mǝsiⱨlǝx meyi wǝ muⱪǝddǝs jayƣa tǝyyarlinidiƣan esil dora-dǝrmǝklǝrdin huxbuyni yasiyalaydiƣan boldi. Mǝn sanga ǝmr ⱪilƣinim boyiqǝ ular barliⱪ ixni bǝja kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Pǝrwǝrdigar Musaƣa ǝmr ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Sǝn Israillarƣa ǝmr ⱪilip ularƣa: — «Silǝr Mening xabat künlirimni qoⱪum tutunglar; qünki bular silǝrning ɵzünglarni pak-muⱪǝddǝs ⱪilƣuqining Mǝn Pǝrwǝrdigar ikǝnlikini bilixinglar üqün Mǝn bilǝn silǝrning otturanglardiki bir nixanǝ-bǝlgǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Xabat küni silǝrgǝ muⱪǝddǝs ⱪilip bekitilgini üqün, uni tutunglar; kimki uni buzsa, ɵlüm jazasiƣa tartilmisa bolmaydu; bǝrⱨǝⱪ, kimki u künidǝ ⱨǝrⱪandaⱪ ixni ⱪilsa, ɵz hǝlⱪi arisidin üzüp taxlansun. ");
INSERT INTO uigpin_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Altǝ kün iqidǝ ix ⱪilinsun; lekin yǝttinqi küni Pǝrwǝrdigarƣa atalƣan muⱪǝddǝs kün bolup, aram alidiƣan xabat küni bolidu; kimki xabat künidǝ birǝr ix ⱪilsa, ɵlüm jazasiƣa tartilmisa bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israillar xabat künini tutuxi kerǝk; ular ǝbǝdiy ǝⱨdǝ süpitidǝ uni ǝwladtin ǝwladⱪiqǝ tutsun. ");
INSERT INTO uigpin_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Bu Mǝn bilǝn Israillarning otturisida ǝbǝdiy bir nixanǝ-bǝlgǝ bolidu; qünki Pǝrwǝrdigar altǝ kün iqidǝ asman bilǝn zeminni yaritip, yǝttinqi künidǝ aram elip raⱨǝt tapⱪanidi», — degin. ");
INSERT INTO uigpin_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Huda Sinay teƣida Musaƣa bu sɵzlǝrni ⱪilip bolƣandin keyin, ikki ⱨɵküm-guwaⱨliⱪ tahtiyini uningƣa tapxurdi. Tahtaylar taxtin bolup, sɵzlǝr Hudaning barmiⱪi bilǝn ularƣa pütülgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Hǝlⱪ Musaning taƣdin qüxmǝy ⱨayal bolup ⱪalƣinini kɵrüp, Ⱨarunning ⱪexiƣa yiƣilip uningƣa: — Sǝn ⱪopup, bizgǝ aldimizda yol baxlap mangidiƣan bir ilaⱨ yasap bǝrgin! Qünki bizni Misir zeminidin qiⱪirip kǝlgǝn Musa degǝn ⱨeliⱪi kixigǝ nemǝ bolup kǝtkǝnlikini bilmǝymiz, — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ⱨarun ularƣa: — Hotunliringlar bilǝn oƣul-ⱪizliringlarning ⱪulaⱪliridiki altun zirǝ ⱨalⱪilarni qiⱪirip, mening ⱪeximƣa elip kelinglar, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Xuning bilǝn pütkül hǝlⱪ ɵz ⱪulaⱪliridiki altun zirǝ ⱨalⱪilarni qiⱪirip Ⱨarunning ⱪexiƣa elip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","U bularni ularning ⱪolidin elip, iskinǝ bilǝn ⱪuyma bir mozayni yasatⱪuzdi. Xuning bilǝn ular: — Əy Israil, seni Misir zeminidin qiⱪirip kǝlgǝn Hudayinglar mana budur! — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ⱨarun uni kɵrüp uning aldida bir ⱪurbangaⱨni yasitip andin: «Ətǝ Pǝrwǝrdigar üqün bir ⱨeyt ɵtküzülidu», dǝp elan ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ətisi ular sǝⱨǝr ⱪopup, kɵydürmǝ ⱪurbanliⱪlarni sunup, inaⱪliⱪ ⱪurbanliⱪlirinimu kǝltürdi; andin halayiⱪ olturup yǝp-iqixti, ⱪopup ǝyx-ixrǝt ⱪilixti.    ");
INSERT INTO uigpin_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Xu qaƣda Pǝrwǝrdigar Musaƣa: — Ornungdin tur, tezdin pǝskǝ qüxkin! Qünki sǝn Misir zeminidin qiⱪirip kǝlgǝn hǝlⱪing buzuⱪqiliⱪⱪa berilip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Mǝn ularƣa buyruƣan yoldin xunqǝ tezla qǝtnǝp, ɵzliri üqün bir ⱪuyma mozayni yasap, uningƣa qoⱪunup ⱪurbanliⱪ kǝltürüxti ⱨǝmdǝ: «Əy Israil, seni Misir zeminidin qiⱪirip kǝlgǝn Hudaying mana xudur!», deyixti, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Andin Pǝrwǝrdigar Musaƣa: — Mana, bu hǝlⱪni kɵrüp ⱪoydum; mana, ular dǝrwǝⱪǝ boyni ⱪattiⱪ bir hǝlⱪtur. ");
INSERT INTO uigpin_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Əmdi Meni tosma, Mǝn ƣǝzǝp otumni ularning üstigǝ qüxürüp, ularni yutuwetimǝn; andin seni uluƣ bir ǝl ⱪilimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Lekin Musa Hudasi Pǝrwǝrdigardin ɵtünüp iltija ⱪilip mundaⱪ dedi: — Əy Pǝrwǝrdigar, nemixⱪa sǝn ƣǝzǝp otungni Ɵzüng zor ⱪudrǝt wǝ küqlük ⱪol bilǝn Misir zeminidin qiⱪirip kǝlgǝn hǝlⱪingning üstigǝ qüxürisǝn? ");
INSERT INTO uigpin_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Misirliⱪlar mazaⱪ ⱪilip: — Ularning bexiƣa bala qüxürüx üqün, ularni taƣlarning üstidǝ ɵltürüp yǝr yüzidin yoⱪitix üqün, ularning Hudasi ularni elip kǝtti, — deyixsunmu? Ɵz otluⱪ ƣǝzipingdin yenip, Ɵz hǝlⱪinggǝ balayi’apǝt kǝltürüx niyitingdin yanƣaysǝn! ");
INSERT INTO uigpin_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ɵz ⱪulliring Ibraⱨim, Isⱨaⱪ wǝ Israilni yad ⱪilƣin; Sǝn ularƣa ⱪǝsǝm bilǝn wǝdǝ ⱪilip: «Nǝslinglarni asmandiki yultuzlardǝk awutimǝn, Ɵzüm uning toƣrisida sɵzligǝn muxu zeminning ⱨǝmmisini nǝslinglarƣa berimǝn, ular uningƣa mǝnggü igidarqiliⱪ ⱪilidiƣan bolidu» degǝnidingƣu, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Xuning bilǝn Pǝrwǝrdigar Ɵz hǝlⱪining üstigǝ: «Balayi’apǝt qüxürimǝn» degǝn niyitidin yandi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa kǝynigǝ burulup, ikki ⱨɵküm-guwaⱨliⱪ tahtiyini ⱪoliƣa elip taƣdin qüxti. Tahtaylarning ikki tǝripigǝ sɵzlǝr pütülgǝnidi; u yüzigimu, bu yüzigimu pütüklük idi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Bu tahtaylar bolsa Hudaning Ɵzining yasiƣini, pütülgǝnliri bolsa Hudaning Ɵzining pütkini idi, u tahtaylarƣa oyulƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yǝxua hǝlⱪning kɵtürgǝn quⱪan-sürǝnlirini, warⱪiraxlirini anglap Musaƣa: — Qedirgaⱨdin jǝngning hitabi qiⱪiwatidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Lekin u jawab berip: — Angliniwatⱪan awaz nǝ nusrǝt tǝntǝnisi ǝmǝs, nǝ mǝƣlubiyǝtning pǝryadi ǝmǝs, bǝlki nahxa-küy sadasi! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa qedirgaⱨƣa yeⱪin kelip, mozayni wǝ jamaǝtning ussulƣa qüxüp kǝtkǝnlikini kɵrüp xundaⱪ dǝrƣǝzǝp boldiki, tahtaylarni ⱪolidin taxlap taƣning tüwidǝ qeⱪiwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Andin ular yasiƣan mozayni otⱪa selip kɵydürüp, uni yanjip kukum-talⱪan ⱪilip, su üstigǝ qeqip Israillarni iqixkǝ mǝjburlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Andin Musa Ⱨarunƣa: Sǝn ularni xunqǝ eƣir gunaⱨⱪa patⱪuzƣudǝk, muxu hǝlⱪ sanga nemǝ ⱪildi? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ⱨarun jawab berip: — Hojamning ƣǝzǝp-aqqiⱪi tutaxmiƣay! Bu hǝlⱪning ⱪandaⱪ ikǝnlikini, ularning zǝzillikkǝ mayil ikǝnlikini obdan bilisǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ular manga: — «Bizgǝ aldimizda yol baxlap mangidiƣan bir ilaⱨni yasap bǝrgin; qünki bizni Misir zeminidin qiⱪirip kǝlgǝn Musa degǝn xu adǝmgǝ nemǝ bolƣinini bilmǝymiz», dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Mǝn ularƣa: «Kimdǝ altun bolsa xuni qiⱪirip bǝrsun» desǝm, ular manga tapxurup bǝrdi; mǝn uni otⱪa taxliwidim, mana, bu mozay qiⱪti, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa hǝlⱪning ⱪandaⱪsigǝ tizginsiz bolup kǝtkǝnlikini kɵrdi; qünki Ⱨarun ularni düxmǝnlirining aldida mǝshirǝ obyekti boluxⱪa ɵz mǝyligǝ ⱪoyuwǝtkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa qedirgaⱨning kirix eƣiziƣa berip, xu yǝrdǝ turup: — Kimki Pǝrwǝrdigarning tǝripidǝ bolsa mening yenimƣa kǝlsun! — dedi. Xuni dewidi, Lawiylarning ⱨǝmmisi uning ⱪexiƣa yiƣildi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","U ularƣa: — Israilning Hudasi Pǝrwǝrdigar mundaⱪ dǝydu: — «Ⱨǝrbir kixi ɵz ⱪiliqini yanpixiƣa esip, qedirgaⱨning iqigǝ kirip, bu qetidin u qetigiqǝ kezip yürüp, ⱨǝrbiri ɵz ⱪerindixini, ɵz dost-buradirini, ɵz ⱪoxnisini ɵltürsun!» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Xuning bilǝn Lawiylar Musaning buyruƣini boyiqǝ ix kɵrdi; xu küni hǝlⱪning iqidin üq ming kixi ɵltürüldi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Andin Musa: — Ⱨǝrbiringlar bügün ɵzünglarni Pǝrwǝrdigarƣa has boluxⱪa atidinglar; qünki ⱨǝrbiringlar ⱨǝtta ɵz oƣlunglar ⱨǝm ⱪerindixinglarnimu ayimidinglar; xuning bilǝn bügün bǝht-bǝrikǝtni üstünglarƣa qüxürdunglar, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ətisi Musa hǝlⱪⱪǝ sɵz ⱪilip: — Silǝr dǝrwǝⱪǝ naⱨayiti eƣir bir gunaⱨ sadir ⱪildinglar. Əmdi mana, mǝn Pǝrwǝrdigarning aldiƣa qiⱪimǝn; gunaⱨinglar üqün kǝfarǝt kǝltürǝlǝymǝnmikin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Xuning bilǝn Musa Pǝrwǝrdigarning aldiƣa yenip berip: — Ⱨǝy...! Bu hǝlⱪ dǝrwǝⱪǝ eƣir bir gunaⱨ sadir ⱪilip, ɵzlirigǝ altundin ilaⱨlarni yasaptu! ");
INSERT INTO uigpin_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Lekin ǝmdi Sǝn ularning gunaⱨini ǝpu ⱪilixⱪa uniƣaysǝn..., unimisang, ismimni Ɵzüng yazƣan dǝptiringdin ɵqürüwǝtkin! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Pǝrwǝrdigar Musaƣa jawab berip: — Kimki Mening aldimda gunaⱨ ⱪilƣan bolsa, uning etini Ɵz dǝptirimdin ɵqürüwetimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Əmdi sǝn berip, Mǝn sanga eytⱪan jayƣa hǝlⱪni baxlap barƣin. Mana, Mening Pǝrixtǝm aldingda mangidu. Lekin ularƣa jaza beridiƣan künüm kǝlgǝndǝ, ularƣa gunaⱨi üqün jaza berimǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Bu sɵzdin keyin Pǝrwǝrdigar hǝlⱪning Ⱨarunning ⱪoli bilǝn mozayni ⱪuydurup yasatⱪini üqün ularni waba bilǝn jazalidi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — Sǝn ornungdin turup, ɵzüng Misir zeminidin elip kǝlgǝn hǝlⱪ bilǝn billǝ muxu yǝrdin ketip: «Mǝn sening nǝslinggǝ uni berimǝn» dǝp ⱪǝsǝm ⱪilip Ibraⱨimƣa, Isⱨaⱪⱪa wǝ Yaⱪupⱪa wǝdǝ ⱪilƣan zeminƣa barƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Xuning bilǝn sening aldingda bir Pǝrixtǝ ǝwǝtip, Ⱪanaaniy, Amoriy, Ⱨittiy, Pǝrizziylǝrni, Ⱨiwiy bilǝn Yǝbusiylarni ⱨǝydǝp qiⱪirip, ");
INSERT INTO uigpin_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","seni süt bilǝn ⱨǝsǝl eⱪip turidiƣan zeminƣa kǝltürimǝn. Qünki silǝr boyni ⱪattiⱪ bir hǝlⱪ bolƣaqⱪa, yolda silǝrni ⱨalak ⱪiliwǝtmǝslikim üqün, Ɵzüm silǝrning aranglarda bolup, xu zeminƣa billǝ qiⱪmaymǝn, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Halayiⱪ bu ⱪattiⱪ sɵzni anglap, ⱪayƣuƣa qɵmüp ⱨeqⱪaysisi ɵz zibu-zinnǝtlirini taⱪimidi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Qünki Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — Sǝn berip Israillarƣa: «Pǝrwǝrdigar: — Silǝr boyni ⱪattiⱪ bir hǝlⱪ ikǝnsilǝr; ǝgǝr Mǝn Pǝrwǝrdigar aranglarƣa qiⱪip bir dǝⱪiⱪila tursam, silǝrni yoⱪitiwǝtkǝn bolattim. Əmdi silǝr ɵzünglardiki zibu-zinnǝtlǝrni eliwetinglar; xu qaƣda Mǝn silǝrgǝ nemǝ ⱪilidiƣinimni bilimǝn, dedi», dǝp eytⱪin, — degǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Xunga Israillar Ⱨorǝb teƣidin ayrilipla zibu-zinnǝtlirini ɵzliridin eliwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Xuning bilǝn Musa ɵz qedirini elip, uni qedirgaⱨning sirtida, qedirgaⱨdin neriraⱪ bir jayƣa tikip, uni «kɵrüxüx qediri» dǝp atidi. Kimki Pǝrwǝrdigarni izdǝp, yol sorimaⱪqi bolsa qedirgaⱨning sirtidiki «kɵrüxüx qediri»ƣa baratti. ");
INSERT INTO uigpin_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Xundaⱪ bolattiki, ⱨǝr ⱪetim Musa qedirƣa qiⱪsa, pütkül halayiⱪ ⱪopup, ⱨǝrbiri ɵz qedirining ixikidǝ ɵrǝ turup, Musa qedirƣa kirip bolƣuqǝ uning kǝynidin ⱪarixip turatti. ");
INSERT INTO uigpin_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Andin Musa ⱨǝr ⱪetim qedirƣa kirip kǝtsǝ xundaⱪ bolattiki, bulut tüwrüki qüxüp, qedirning kirix eƣizida tohtaytti; xuning bilǝn Pǝrwǝrdigar Musa bilǝn sɵzlixǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Pütkül halayiⱪ bulut tüwrükining jamaǝt qedirining kirix eƣizida tohtiƣinini kɵrǝtti; uni kɵrginidǝ hǝlⱪning ⱨǝmmisi ⱪopup, ⱨǝrbiri ɵz qedirining ixikidǝ turup sǝjdǝ ⱪilixatti. ");
INSERT INTO uigpin_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Xu qaƣlarda Pǝrwǝrdigar Musa bilǝn kixilǝr ɵz dost-buradiri bilǝn sɵzlǝxkǝndǝk, yüzmuyüz sɵzlixǝtti. Andin Musa qedirgaⱨƣa yenip kelǝtti; lekin uning hizmǝtkari bolƣan Nunning oƣli Yǝxua degǝn yax yigit qedirning iqidin qiⱪmaytti. ");
INSERT INTO uigpin_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa Pǝrwǝrdigarƣa mundaⱪ dedi: — Mana, Sǝn daim manga: «Bu hǝlⱪni elip qiⱪⱪin» dǝp kǝlding; lekin Ɵzüng manga: «Mǝn seni ismingni bilip tonuymǝn», wǝ xuningdǝk «Nǝzirim aldida iltipat tapting» degǝn bolsangmu, Sǝn mening bilǝn birgǝ kimni ǝwǝtidiƣiningni manga ayan ⱪilmiding. ");
INSERT INTO uigpin_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Əgǝr mǝn rasttinla nǝziringdǝ iltipat tapⱪan bolsam, ɵzümning Seni tonuxum üqün, nǝziringdǝ iltipat tepiwerixim üqün manga Ɵz yolungni ayan ⱪilƣaysǝn; mana, bu hǝlⱪning Ɵz hǝlⱪing bolƣinini nǝziringdǝ tutⱪaysǝn! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","U jawab berip: Mǝn Ɵzüm sǝn billǝ billǝ berip, sanga aram ata ⱪilimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa uningƣa jawabǝn: — Əgǝr Sǝn Ɵzüng biz bilǝn billǝ mangmisang, bizni bu yǝrdin qiⱪarmiƣaysǝn; ");
INSERT INTO uigpin_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","qünki, mǝn wǝ hǝlⱪing nǝziringdǝ iltipat tapⱪinimiz nemidin bilinidu? Əjǝba, Ɵzüngning biz bilǝn billǝ mangƣiningdin bilinmǝmdu? Xu sǝwǝbtin mǝn wǝ hǝlⱪing yǝr yüzidiki ⱨǝrbir taipilǝrdin alaⱨidǝ pǝrⱪlǝnmǝmduⱪ?! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Pǝrwǝrdigar Musaƣa: — Muxu iltijayingnimu ijabǝt ⱪilimǝn; qünki sǝn nǝzirimdǝ iltipat tapting wǝ Mǝn seni ismingni bilip tonuymǝn, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Xuning bilǝn Musa: — Ɵz xan-xǝrpingni manga kɵrsǝtkǝysǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Pǝrwǝrdigar: — Ɵzümning pütkül meⱨribanliⱪimni sening kɵz aldingdin ɵtküzimǝn wǝ aldingda «Yaⱨwǝⱨ» degǝn namni jakarlaymǝn. Kimgǝ xapaǝt ⱪilmaⱪqi bolsam xuningƣa xapaǝt kɵrsitimǝn, kimgǝ rǝⱨim-xǝpⱪǝt kɵrsǝtmǝkqi bolsam, xuningƣa rǝⱨim-xǝpⱪǝt kɵrsitimǝn, dedi.    ");
INSERT INTO uigpin_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pǝrwǝrdigar uningƣa: — Sǝn yüzümni kɵrǝlmǝysǝn; qünki ⱨeq adǝmzat Meni kɵrsǝ tirik ⱪalmaydu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Andin Pǝrwǝrdigar: — Mana, yenimda bir jay bardur; sǝn xu yǝrdiki ⱪoram taxning üstidǝ turƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Mening xan-xǝripim ɵtidiƣan waⱪitta, xundaⱪ boliduki, Mǝn seni xu ⱪoram taxning yeriⱪida turƣuzup, Mǝn ɵtüp bolƣuqǝ seni ⱪolum bilǝn yepip turimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Andin ⱪolumni tartiwalimǝn; xuning bilǝn sǝn Mening arⱪa tǝripimni kɵrisǝn, lekin yüzüm kɵrünmǝydu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Pǝrwǝrdigar Musaƣa: — Sǝn awwalⱪiƣa ohxax ɵzüng üqün taxtin ikki tahtayni yonup kǝl; Mǝn bu tahtaylarƣa sǝn ilgiri qeⱪiwǝtkǝn tahtaylardiki sɵzlǝrni yezip ⱪoyimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sǝn ǝtǝ ǝtigǝngiqǝ tǝyyar bolup, sǝⱨǝrdǝ Sinay teƣiƣa qiⱪip, xu yǝrdǝ taƣning qoⱪⱪisida Mening aldimda ⱨazir bolƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Lekin ⱨeq kixi sǝn bilǝn billǝ qiⱪmisun wǝ yaki taƣning ⱨeq yeridǝ baxⱪa adǝm kɵrünmisun, ⱪoy-kalilarmu taƣning tüwidǝ otlimisun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa awwalⱪiƣa ohxax taxtin ikki tahtayni yonup, ǝtisi tang sǝⱨǝr ⱪopup, bu ikki tax tahtayni ⱪolida elip, Pǝrwǝrdigarning buyruƣini boyiqǝ Sinay teƣiƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Xuning bilǝn Pǝrwǝrdigar bulutta qüxüp, xu yǝrdǝ Musaning ⱪexida turup, «Yaⱨwǝⱨ» degǝn namini jakarlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Pǝrwǝrdigar uning kɵz aldidin ɵtüp: — «Pǝrwǝrdigar, Pǝrwǝrdigar, rǝⱨimdil wǝ meⱨir-xǝpⱪǝtliktur, asan ƣǝzǝplǝnmǝydiƣan, xapaǝt bilǝn wapasi kǝng Tǝngridur,    ");
INSERT INTO uigpin_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","mingliƣan-on mingliƣanlarƣa rǝⱨim-xapaǝt kɵrsitip, ⱪǝbiⱨlik, asiyliⱪ wǝ gunaⱨni kǝqürgüqidur; lekin u gunaⱨkarlarni ⱨǝrgiz gunaⱨsiz dǝp ⱪarimaydiƣan, bǝlki atilarning ⱪǝbiⱨlikining jazasini baliliri wǝ nǝwrlirigiqǝ, xundaⱪla üqinqi wǝ tɵtinqi ǝwladiƣiqǝ yüklǝydiƣan Tǝngridur» — dǝp jakarlidi.    ");
INSERT INTO uigpin_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Xuning bilǝn Musa dǝrⱨal yǝrgǝ bax ⱪoyup sǝjdǝ ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","— Əy Rǝb, ǝgǝr mǝn rasttinla nǝziringdǝ iltipat tapⱪan bolsam, undaⱪta i Rǝb, arimizda biz bilǝn mangƣaysǝn; qünki bu hǝlⱪ dǝrwǝⱪǝ boyni ⱪattiⱪ bir hǝlⱪtur; bizning ⱪǝbiⱨlikimizni wǝ gunaⱨimizni kǝqürgǝysǝn, bizni Ɵz mirasing boluxⱪa ⱪobul ⱪilƣaysǝn! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Xuning bilǝn u Musaƣa: — Mana, Mǝn bir ǝⱨdǝ tüzimǝn; sening barliⱪ hǝlⱪing aldida pütkül yǝr yüzining ⱨeqbir jayida yaki ⱨeqbir ǝl arisida ⱪilinip baⱪmiƣan mɵjizilǝrni yaritimǝn. Xuning bilǝn sǝn arisida bolƣan hǝlⱪingning ⱨǝmmisi Pǝrwǝrdigarning karamǝt ǝmǝlini kɵridu; qünki Mening silǝrgǝ ⱪilidiƣan ǝmǝlim dǝrwǝⱪǝ dǝⱨxǝtlik ix bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mǝn bügün sanga tapilaydiƣan ǝmrlirimni tutⱪin; mana, Mǝn silǝrning aldinglardin Amoriy, Ⱪanaaniy, Ⱨittiy, Pǝrizziy, Ⱨiwiy wǝ Yǝbusiylarni ⱨǝydǝp qiⱪirimǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Əmdi ⱨezi bolƣinki, sǝn baridiƣan zeminda turuwatⱪanlar bilǝn ⱨeq ǝⱨdǝ baƣlaxmiƣin; bolmisa, bu ix silǝrgǝ tuzaⱪ bolidu; ");
INSERT INTO uigpin_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","bǝlki silǝr ularning ⱪurbangaⱨlirini quwup, but tüwrüklirini sundurup, «axǝraⱨ» butlirini kesip taxlanglar. ");
INSERT INTO uigpin_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Qünki sǝn ⱨeqⱪandaⱪ baxⱪa ilaⱨⱪa ibadǝt ⱪilmasliⱪing kerǝk — qünki Mǝnki Pǝrwǝrdigarning nami «Wapasizliⱪⱪa Ⱨǝsǝt Ⱪilƣuqi» bolup, ⱨǝsǝt ⱪilƣuqi bir ilaⱨdurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Bolmisa, xu zeminda turuwatⱪanlar bilǝn ǝⱨdǝ tüzüxüng mumkin; andin ular ilaⱨlirining kǝynidin yürüp buzuⱪqiliⱪ ⱪilip, ilaⱨliriƣa ⱪurbanliⱪlar ɵtküzginidǝ, silǝrni qaⱪirsa ularning ⱪurbanliⱪliridin yǝp ketixinglar mumkin; ");
INSERT INTO uigpin_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","sǝn xundaⱪla yǝnǝ ularning ⱪizlirini oƣulliringƣa hotunluⱪⱪa elip berixing mumkin; u ⱪizlar ɵz ilaⱨlirining kǝynidin yürüp buzuⱪqiliⱪ ⱪilƣinida, ular oƣulliringnimu ɵz ilaⱨlirining arⱪisidin mangƣuzup, buzuⱪqiliⱪ ⱪilduruxi mumkin. ");
INSERT INTO uigpin_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ɵzüng üqün ⱨeqⱪandaⱪ ⱪuyma butlarni yasatmiƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Petir nan ⱨeytini tutunglar; Mening ǝmr ⱪilƣinimdǝk Abib eyida, bekitilgǝn waⱪitta yǝttǝ kün petir nan yǝnglar. Qünki silǝr Abib eyida Misirdin qiⱪⱪansilǝr. ");
INSERT INTO uigpin_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Baliyatⱪuning tunji mewisi Meningki bolidu; qarpay malliringning iqidin dǝslǝp tuƣulƣan ǝrkǝklǝr, kala bolsun, ⱪoy bolsun ularning tunjilirining ⱨǝmmisi Meningki bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Lekin exǝklǝrning tunji tǝhǝylirining orniƣa ⱪoza bilǝn bǝdǝl tɵlixing lazim bolidu. Əgǝr orniƣa ⱪoza bǝrmisǝng, tǝhǝyning boynini sunduruwǝtkin. Tunji oƣulliringni bolsa, ularƣa bǝdǝl tɵlǝp ⱪayturuwal. Ⱨeqkim Mening ⱨuzurumƣa ⱪuruⱪ ⱪol kǝlmisun.    ");
INSERT INTO uigpin_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sǝn altǝ kün iqidǝ ix-ǝmǝlingni ⱪilip, yǝttinqi küni aram elixing zɵrür; yǝr ⱨǝydǝx waⱪti bolsun, orma waⱪti bolsun, aram elixing zɵrür. ");
INSERT INTO uigpin_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Yengi buƣdayning tunji ⱨosulini tǝbriklǝydiƣan «ⱨǝptilǝr ⱨeyti»ni ɵtküzünglar; yilning ahirida «ⱨosul yiƣix ⱨeyti»ni ɵtküzünglar.    ");
INSERT INTO uigpin_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Sening ⱨǝrbir ǝrkǝk kixiliring yilda üq ⱪetim Israilning Hudasi bolƣan Rǝb Pǝrwǝrdigarning aldiƣa ⱨazir bolsun. ");
INSERT INTO uigpin_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Qünki Mǝn taipilǝrni aldingdin ⱨǝydiwetip, qegraliringni kengǝytimǝn; xuningdǝk sǝn yilda üq ⱪetim Pǝrwǝrdigar Hudayingning aldiƣa ⱨazir boluxⱪa qiⱪip barsang, ⱨeqkim yeringgǝ kɵz ⱪirini salmaydu. ");
INSERT INTO uigpin_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Manga sunulidiƣan ⱪurbanliⱪning ⱪenini boldurulƣan nan bilǝn billǝ sunmiƣin; yaki ɵtüp ketix ⱨeytining ⱪurbanliⱪining gɵxini ǝtigǝ ⱪaldurma.    ");
INSERT INTO uigpin_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Zeminingning dǝslǝpki ⱨosulidin tunji mǝⱨsulatlarni Pǝrwǝrdigar Hudayingning ɵyigǝ kǝltürüp ata. Oƣlaⱪni anisining sütidǝ ⱪaynitip pixurma.    ");
INSERT INTO uigpin_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Pǝrwǝrdigar Musaƣa: — Bu sɵzlǝrni ɵzüng üqün yeziwalƣin; qünki Mǝn muxu sɵzlǝrni asas ⱪilip sǝn bilǝn wǝ Israil bilǝn ǝⱨdǝ baƣlidim, dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","U waⱪitta Musa xu yǝrdǝ Pǝrwǝrdigarning ⱨuzurida ⱪiriⱪ keqǝ-kündüz turdi; u ⱨeqnǝrsǝ yemidi, ⱨeq su iqmidi. U yǝrdǝ Pǝrwǝrdigar tahtaylarƣa ǝⱨdining sɵzliri bolƣan on ǝmrni pütti.    ");
INSERT INTO uigpin_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa Sinay teƣidin qüxkǝndǝ xundaⱪ boldiki (u taƣdin qüxkǝndǝ ikki ⱨɵküm-guwaⱨliⱪ tahtiyi uning ⱪolida idi), ɵzining Pǝrwǝrdigar bilǝn sɵzlǝxkini üqün yüzining parⱪirap kǝtkinini bilmǝytti. ");
INSERT INTO uigpin_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Əmdi Ⱨarun wǝ barliⱪ Israillar Musani kɵrdi, mana, uning yüz terisi parⱪirap turatti; ular uningƣa yeⱪin berixtin ⱪorⱪuxti. ");
INSERT INTO uigpin_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Lekin Musa ularni qaⱪiriwidi, Ⱨarun wǝ jamaǝtning barliⱪ baxliri yenip, uning ⱪexiƣa kǝldi; Musa ular bilǝn sɵzlǝxti. ");
INSERT INTO uigpin_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Xuningdin keyin, barliⱪ Israillar uning yeniƣa kǝldi; u waⱪitta Musa Pǝrwǝrdigar ɵzigǝ Sinay teƣida sɵz ⱪilƣinida tapxurƣan barliⱪ ǝmrlǝrni ularƣa tapilidi. ");
INSERT INTO uigpin_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa ularƣa dǝydiƣinini dǝp tügǝtti. U sɵzligǝndǝ yüzigǝ bir qümpǝrdǝ tartiwalƣanidi;    ");
INSERT INTO uigpin_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ⱪaqanki Musa Pǝrwǝrdigar bilǝn sɵzlixixkǝ uning ⱨuzuriƣa kirsǝ, qümpǝrdini eliwetǝtti, taki u yenip qiⱪⱪuqǝ xundaⱪ bolatti; yenip qiⱪⱪanda ɵzigǝ nemǝ tapilanƣan bolsa, xuni Israillarƣa eytip berǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Israillar Musaning yüz terisining parⱪirap turƣinini kɵrǝtti; xunga Musa yǝnǝ taki Pǝrwǝrdigar bilǝn sɵzlǝxkili uning ⱨuzuriƣa kirgüqǝ yüzigǝ qümpǝrdǝ tartiwalatti. ");
INSERT INTO uigpin_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa Israillarning pütkül jamaitini yiƣip ularƣa: — Pǝrwǝrdigar silǝrgǝ ⱪilixⱪa buyruƣan ǝmrlǝr munulardur: — ");
INSERT INTO uigpin_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Altǝ kün ix-ǝmgǝk küni bolsun; lekin yǝttinqi küni silǝrgǝ nisbǝtǝn muⱪǝddǝs bir kün bolup, Pǝrwǝrdigarƣa atalƣan aram alidiƣan xabat küni bolsun. Ⱨǝrkim xu künidǝ ix-ǝmgǝk ⱪilsa ɵlümgǝ mǝⱨkum ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Xabat künidǝ barliⱪ turalƣuliringlarda ⱨǝrgiz ot ⱪalimanglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa Israillarning pütkül jamaitigǝ sɵz ⱪilip mundaⱪ dedi: — «Pǝrwǝrdigar buyruƣan ǝmr mana xuki: — ");
INSERT INTO uigpin_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Ɵzünglarning aranglardin Pǝrwǝrdigarƣa bir «kɵtürmǝ ⱨǝdiyǝ» kǝltürünglar; kɵngli haliƣanlarning ⱨǝrbiri Pǝrwǝrdigarƣa bir «kɵtürmǝ ⱨǝdiyǝ»sini kǝltürsun: yǝni altun, kümüx, mis, ");
INSERT INTO uigpin_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kɵk, sɵsün wǝ ⱪizil yip, aⱪ kanap rǝht, ɵqkǝ tiwiti, ");
INSERT INTO uigpin_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ⱪizil boyalƣan ⱪoqⱪar terisi, delfin terisi, akatsiyǝ yaƣiqi, ");
INSERT INTO uigpin_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","qiraƣdan üqün zǝytun meyi, «mǝsiⱨlǝx meyi» bilǝn huxbuy üqün ixlitilidiƣan esil dora-dǝrmǝklǝr, ");
INSERT INTO uigpin_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ǝfodⱪa ⱨǝm ⱪoxenƣa ornitilidiƣan ⱨeⱪiⱪ wǝ baxⱪa yaⱪutlarni kǝltürünglar». ");
INSERT INTO uigpin_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","— «Aranglardiki barliⱪ maⱨir ustilar kelip Pǝrwǝrdigar buyruƣanning ⱨǝmmisini yasap bǝrsun: ");
INSERT INTO uigpin_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","— muⱪǝddǝs qedir bilǝn uning iqki wǝ taxⱪi yopuⱪlirini, ilƣulirini, tahtaylirini, baldaⱪlirini, hadilirini wǝ bularning tǝgliklirini, ");
INSERT INTO uigpin_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ǝⱨdǝ sanduⱪi wǝ uning baldaⱪlirini, «kǝfarǝt tǝhti»ni, «ayrima pǝrdǝ-yopuⱪ»ni, ");
INSERT INTO uigpin_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","xirǝ wǝ uning baldaⱪlirini, uning barliⱪ ⱪaqa-ⱪuqilirini wǝ «tǝⱪdim nanliri»ni, ");
INSERT INTO uigpin_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","yoruⱪluⱪ üqün yasalƣan qiraƣdan wǝ uning ǝswablirini, uning qiraƣliri wǝ qiraƣ meyini, ");
INSERT INTO uigpin_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","huxbuygaⱨ wǝ uning baldaⱪlirini, «Mǝsiⱨlǝx meyi»ni, dora-dǝrmǝklǝrdin ixlǝngǝn huxbuyni, muⱪǝddǝs qedirining kirix eƣizidiki «ixik pǝrdisi»ni, ");
INSERT INTO uigpin_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨi wǝ uning mis xalasini, baldaⱪlirini wǝ barliⱪ ǝswablirini, yuyunux desi wǝ uning tǝglikini, ");
INSERT INTO uigpin_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ⱨoylining pǝrdilirini, uning hadiliri wǝ ularning tǝgliklirini, ⱨoylining kirix eƣizidiki pǝrdini, ");
INSERT INTO uigpin_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","qedirning mih-ⱪozuⱪlirini, ⱨoylining mih-ⱪozuⱪlirini, xundaⱪla barliⱪ tanilirini, ");
INSERT INTO uigpin_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","toⱪulidiƣan kiyimlǝr, yǝni muⱪǝddǝs jayning hizmitigǝ kaⱨinliⱪ hizmitidǝ kiyilidiƣan, Ⱨarun kaⱨinning muⱪǝddǝs kiyimlirini ⱨǝm uning oƣullirining kiyimlirini tǝyyar ⱪilsun».    ");
INSERT INTO uigpin_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Xuning bilǝn pütkül Israil jamaiti Musaning yenidin qiⱪip ketixti. ");
INSERT INTO uigpin_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Andin kɵngli tartⱪanlarning ⱨǝrbiri, roⱨi ɵzlirigǝ türtkǝ bolƣanlarning ⱨǝrbiri kelip, jamaǝt qedirini yasaxⱪa, xundaⱪla qedirning hizmitidǝ ixlitilidiƣan barliⱪ sǝrǝmjanlarni yasaxⱪa wǝ muⱪǝddǝs kiyimlǝrni tikixkǝ Pǝrwǝrdigarƣa atalƣan «pulanglatma ⱨǝdiyǝ»ni kǝltürgili turdi. ");
INSERT INTO uigpin_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ular ǝrlǝrmu, ayallarmu kelip, sunuxⱪa kɵngli hux bolƣanlarning ⱨǝrbiri ⱨǝdiyǝ kǝltürüp, bulapka, zirǝ-ⱨalⱪa, üzük, zunnar-bilǝzük ⱪatarliⱪ ⱨǝrhil altun buyumlarni elip kǝldi; altunni «kɵtürmǝ ⱨǝdiyǝ» ⱪilip berǝy degǝnlǝrning ⱨǝrbiri uni Pǝrwǝrdigarƣa sundi. ");
INSERT INTO uigpin_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kimdǝ kɵk, sɵsün, ⱪizil yip bilǝn aⱪ kanap rǝht, ɵqkǝ tiwiti, ⱪizil boyalƣan ⱪoqⱪar terisi wǝ delfin terisi bolsa, xularni elip kelixti. ");
INSERT INTO uigpin_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Kümüx ya mistin kɵtürmǝ ⱨǝdiyǝ kǝltürǝy degǝnlǝrning ⱨǝrbiri xuni Pǝrwǝrdigarƣa ⱨǝdiyǝ ⱪilip sundi. Kimdǝ qedirning hizmitidǝ ixlitilidiƣan ⱨǝrhil sǝrǝmjanlarƣa yariƣudǝk akatsiyǝ yaƣiqi bolsa, uni elip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ⱪoli qewǝr ayallarning ⱨǝrbiri ɵz ⱪolliri bilǝn egirip, xu egirgǝn yip wǝ rǝhtlǝrni, yǝni kɵk, sɵsün wǝ ⱪizil yip bilǝn aⱪ kanap rǝhtlǝrni kǝltürdi,    ");
INSERT INTO uigpin_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Xuningdǝk kɵngli ⱪozƣalƣan ayallarning ⱨǝmmisi ⱨünirini ixlitip ɵqkǝ tiwitidin yip egirixti. ");
INSERT INTO uigpin_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Əmirlǝr ǝfod wǝ ⱪoxenƣa ornitilidiƣan ⱨeⱪiⱪlar wǝ yaⱪutlarni, ");
INSERT INTO uigpin_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","dora-dǝrmǝklǝrni, qiraƣⱪa wǝ mǝsiⱨlǝx meyiƣa ixlitilidiƣan zǝytun meyini, huxbuyƣa ixlitilidiƣan esil dora-dǝrmǝklǝrni kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Xu tǝriⱪidǝ Israillar Pǝrwǝrdigar Musaning wasitisi bilǝn buyruƣan ixlarning ⱨǝrⱪaysiƣa bir nǝrsǝ berixkǝ kɵngli tartⱪan bolsa, ǝr bolsun ayal bolsun ⱨǝrbiri xuni elip kelip, Pǝrwǝrdigarƣa atap ihtiyariy ⱨǝdiyǝ bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Andin Musa Israillarƣa mundaⱪ dedi: — «Mana, Pǝrwǝrdigar Yǝⱨuda ⱪǝbilisidin hurning nǝwrisi, Urining oƣli Bǝzalǝlni ismini atap qaⱪirip,    ");
INSERT INTO uigpin_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","uni Hudaning Roⱨi bilǝn toldurup, uningƣa danaliⱪ, ǝⱪil-parasǝt, ilim-ⱨekmǝt igilitip, uni ⱨǝrtürlük ixni ⱪilixⱪa ⱪabiliyǝtlik ⱪilip, ");
INSERT INTO uigpin_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","uni türlük-türlük ⱨünǝrlǝrni ⱪilalaydiƣan — altun, kümüx wǝ mis ixlirini ⱪilalaydiƣan, ");
INSERT INTO uigpin_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","yaⱪutlarni kesip-oyalaydiƣan, zinnǝt buyumliriƣa ornitalaydiƣan, yaƣaqlarƣa nǝⱪix qiⱪiralaydiƣan, ⱨǝrhil ⱨünǝr ixlirini ⱪamlaxturalaydiƣan ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","U yǝnǝ uning kɵngligǝ, xuningdǝk ⱨǝm Dan ⱪǝbilisidin bolƣan Aⱨisamaⱪning oƣli Oⱨoliyabning kɵngligǝ baxⱪilarƣa ⱨünǝr ɵgitix niyǝt-istikini selip, ");
INSERT INTO uigpin_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ularning kɵngüllirini danaliⱪ-ⱨekmǝt bilǝn toldurup, ularni ⱨǝrhil nǝⱪⱪaxliⱪ-oymiqiliⱪ ixliriƣa maⱨir ⱪilip, kɵk, sɵsün wǝ ⱪizil yip bilǝn aⱪ kanap rǝht bilǝn kǝxtiqilik ⱪilixⱪa ⱨǝmdǝ bapkarliⱪⱪa iⱪtidarliⱪ ⱪildi. Xuning bilǝn ular ⱨǝrhil ⱨünǝr ixlirining wǝ ⱨǝrhil layiⱨilǝx ixlirining ⱨɵddisidin qiⱪalaydiƣan boldi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Xuning bilǝn Bǝzalǝl wǝ Oⱨoliyablar, xuningdǝk Pǝrwǝrdigar muⱪǝddǝs qedir yasaxning ⱨǝrhil ixliriƣa kerǝk bolƣan danaliⱪ-ⱨekmǝt wǝ ǝⱪil-parasǝtni ata ⱪilƣan maⱨir ustilarning ⱨǝrbiri ularƣa ⱪoxulup, xu ixni uning ǝmr ⱪilƣini boyiqǝ ǝmǝlgǝ axuridu». ");
INSERT INTO uigpin_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Xu waⱪitta Musa Bǝzalǝl wǝ Oⱨoliyabni, xundaⱪla Pǝrwǝrdigar danaliⱪ-ⱨekmǝt bilǝn kɵngüllirini toldurƣan, kɵngli ɵzini xu ixni ⱪilixⱪa ⱪatnixixⱪa dalalǝt ⱪilƣan barliⱪ ⱨünǝrwǝn-kasiplarni qaⱪirip yiƣdi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ular kelip muⱪǝddǝs qedirni yasaxⱪa, xundaⱪla uning ix-hizmǝtlirigǝ kerǝklik sǝrǝmjanlarni yasaxⱪa Israillar elip kǝltürgǝn barliⱪ «kɵtürmǝ ⱨǝdiyǝ»lǝrni Musadin tapxuruwaldi. Israil hǝlⱪi yǝnila ɵz mǝyli bilǝn ⱨǝr küni ǝtigini Musaƣa ihtiyariy ⱨǝdiyǝ kǝltürüp turatti. ");
INSERT INTO uigpin_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Andin muⱪǝddǝs qedirning ixlirini ⱪiliwatⱪan ustilarning ⱨǝmmisi ⱪolidiki ixini ⱪoyup ⱪoyup kelip, ");
INSERT INTO uigpin_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Musaƣa: — Hǝlⱪning elip kǝlgini Pǝrwǝrdigar bizgǝ ⱪilixⱪa buyruƣan ixni pütküzüxkǝ eⱨtiyaj bolƣinidin kɵp exip kǝtti! — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Andin Musa ǝmr ⱪilip, pütkül qedirgaⱨ boyiqǝ: «Mana, ǝr bolsun, ayal bolsun, ⱨeqkim muⱪǝddǝs qedirni yasax üqün «kɵtürmǝ ⱨǝdiyǝ» süpitidǝ yǝnǝ ⱨeqⱪandaⱪ nǝrsǝ tǝyyarlap kǝlmisun!» dǝp jakarlatti. Buning bilǝn kɵpqilik ⱨǝdiyǝlǝr kǝltürüxtin tohtitildi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Qünki ular tǝyyarliƣan materiyallar pütkül ⱪurulux ixiƣa yetǝtti, ⱨǝtta exip ⱪalatti. ");
INSERT INTO uigpin_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Muⱪǝddǝs qedirning ⱪurulux ixini ⱪiliwatⱪan ustilarning ⱨǝrbiri nepiz toⱪulƣan aⱪ kanap rǝhtkǝ kɵk, sɵsün wǝ ⱪizil yiplar arilaxturulup ixlǝngǝn on parqǝ yopuⱪ yasap, kerublarning süritini yopuⱪlarƣa qewǝrlik bilǝn layiⱨilǝp nǝpis ⱪilip kǝxtilǝp qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ⱨǝrbir yopuⱪning uzunluⱪi yigirmǝ sǝkkiz gǝz, kǝngliki tɵt gǝz bolup, ⱨǝrbir yopuⱪ ohxax qong-kiqikliktǝ ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bǝzalǝl yopuⱪlarning bǝxini bir-birigǝ ulidi, ⱪalƣan bǝx yopuⱪnimu ⱨǝm bir-birigǝ ulidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","U ulap qiⱪilƣan birinqi qong parqining ǝng qetidiki ⱪismining bir tǝripigǝ rǝnggi kɵk izmilǝrni ⱪadidi, xuningdǝk ulap qiⱪilƣan ikkinqi qong parqining ǝng qetidikisining bir tǝripigimu xundaⱪ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Birinqi qong parqining ǝng qetidiki ⱪismiƣa ǝllik izmǝ ⱪadidi, ikkinqi qong parqining ǝng qetidikisigimu ǝllik izmǝ ⱪadidi. Izmilǝr bir-birigǝ udulmuudul ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Muⱪǝddǝs qedir bir pütün bolsun üqün u altundin ǝllik ilƣu yasap, ikki parqǝ yopuⱪni xu ilƣular bilǝn bir-birigǝ tutaxturdi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","U muⱪǝddǝs qedirni yepix üqün ɵqkǝ tiwitidin yopuⱪlarni yasidi; yopuⱪtin on bir parqǝ yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Yopuⱪlarning ⱨǝrbirining uzunluⱪi ottuz gǝz, kǝngliki tɵt gǝz bolup, on bir yopuⱪning ⱨǝmmisi ohxax qong-kiqikliktǝ ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Yopuⱪlarning bǝxini u ulap bir ⱪilip, ⱪalƣan altǝ yopuⱪnimu ulap bir ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","U birinqi ulap qiⱪilƣan qong parqining ǝng qetidiki ⱪismiƣa ǝllik izmǝ, ikkinqi ulap qiⱪilƣan qong parqining ǝng qetidiki ⱪismiƣa ǝllik izmǝ ⱪadidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","U qedir bir pütün bolsun üqün ⱨǝm mistin ǝllik ilƣu yasap, ikki qong parqini ulap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","U buningdin baxⱪa qedirƣa ⱪizil boyalƣan ⱪoqⱪar terisidin yopuⱪ yasap yapti, andin uning üstidinmu delfin terisidin yasalƣan yǝnǝ bir yopuⱪni ⱪaplidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","U muⱪǝddǝs qedirning tik tahtaylirini akatsiyǝ yaƣiqidin yasap tiklidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ⱨǝrbir tahtayning uzunluⱪi on gǝz, kǝngliki bir yerim gǝz ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ⱨǝrbir tahtayning ikkidin turumi bar idi, ⱨǝr ikki tahtay xular bilǝn bir-birigǝ qetildi; u qedirning barliⱪ tahtaylirini xundaⱪ yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","U qedirning tahtaylirini xundaⱪ yasidi; yigirmisi jǝnub tǝrǝpkǝ ornitildi; ");
INSERT INTO uigpin_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","u bu yigirmǝ tahtayning tegigǝ kümüxtin ⱪiriⱪ tǝglik yasidi; bir tahtayning astidiki ikki turumi üqün ikkidin tǝglik, yǝnǝ bir tahtayning ikki turumi üqün ikkidin tǝglikni yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Xuningdǝk u qedirning udul tǝripigǝ, yǝni ximal tǝripigǝ yigirmǝ tahtay yasidi, ");
INSERT INTO uigpin_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","xundaⱪla bularning ⱪiriⱪ tǝglikini kümüxtin yasidi; bir tahtayning tegigǝ ikkidin tǝglik, yǝnǝ bir tahtayning tegigǝ ikkidin tǝglik orunlaxturuldi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Qedirning kǝyni tǝripigǝ, yǝni ƣǝrb tǝrǝpkǝ altǝ tahtayni yasap ornatti. ");
INSERT INTO uigpin_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","U qedirning kǝyni tǝripidiki ikki bulungƣa ikki tahtayni yasap ornatti. ");
INSERT INTO uigpin_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Bu bulung tahtayliri astidin üstigiqǝ ikki ⱪat ⱪilip tahtaylarni ɵzara qetixturdi, üsti bir ⱨalⱪiƣa bekitildi. U ⱨǝr ikkisini xundaⱪ yasap, ikki bulungƣa ornatti. ");
INSERT INTO uigpin_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Xunglaxⱪimu u tǝripidǝ sǝkkiz tahtay boldi, ularning kümüxtin yasalƣan on altǝ tǝgliki bar idi; bir tahtayning tegidǝ ikki tǝglik, yǝnǝ bir tahtayning tegidǝ ikki tǝglik bar idi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Buningdin baxⱪa u akatsiyǝ yaƣiqidin baldaⱪ yasidi; qedirning bu tǝripidiki tahtaylarƣa bǝx baldaⱪni, ");
INSERT INTO uigpin_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","qedirning u tǝripidiki tahtaylarƣa bǝx baldaⱪni, qedirning arⱪa tǝripidiki tahtaylarƣa, yǝni ƣǝrb tǝripidiki tahtaylarƣimu bǝx baldaⱪni yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","U tahtaylarning otturidiki ottura baldaⱪni bu tǝrǝptin u tǝrǝpkǝ yǝtküzüp yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","U tahtaylarni altun bilǝn ⱪaplap, baldaⱪlar ɵtküzülidiƣan ⱨalⱪilarni altundin yasap, baldaⱪlarni altun bilǝn ⱪaplidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","U nepiz toⱪulƣan aⱪ kanap rǝhtkǝ kɵk, sɵsün wǝ ⱪizil yiplar arilaxturulup ixlǝngǝn bir pǝrdǝ yasidi; uni kerublarning süritini qewǝrlik bilǝn layiⱨilǝp nǝpis ⱪilip qüxürüp, kǝxtilǝp qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Uni esixⱪa u akatsiyǝ yaƣiqidin tɵt hada yasap, altun bilǝn ⱪaplidi. Ularning ilmǝkliri altundin yasaldi; hadilarƣa u kümüxtin tɵt tǝglikni ⱪuyup yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","U qedirning kirix eƣiziƣa nǝpis toⱪulƣan aⱪ kanap rǝhtkǝ kɵk, sɵsün wǝ ⱪizil yiplar arilaxturulup ixlǝngǝn bir pǝrdǝ yasidi, uni kǝxtiqigǝ kǝxtilǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","U yǝnǝ bu pǝrdining bǝx hadisini ilmǝkliri bilǝn ⱪoxup yasidi; ularning baxlirini wǝ baldaⱪlirini altun bilǝn ⱪaplidi; ularning bǝx tǝgliki mistin yasaldi.    ");
INSERT INTO uigpin_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Andin Bǝzalǝl ǝⱨdǝ sanduⱪini akatsiyǝ yaƣiqidin yasidi; uning uzunluⱪi ikki yerim gǝz, egizliki bir yerim gǝz, kǝngliki bir yerim gǝz idi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","U uning iqi wǝ sirtini sap altun bilǝn ⱪaplidi, uning üstünki ⱪismining qɵrisigǝ altundin girwǝk qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","U uning üqün altundin tɵt ⱨalⱪa ⱪuyup, ularni uning tɵt qetiⱪiƣa bekitti; bir tǝripigǝ ikki ⱨalⱪa, yǝnǝ bir tǝripigǝ ikki ⱨalⱪa bekitti. ");
INSERT INTO uigpin_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","U ⱨǝm akatsiyǝ yaƣiqidin ikki baldaⱪ yasap, ⱨǝr ikkisini altun bilǝn ⱪaplidi; ");
INSERT INTO uigpin_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","andin sanduⱪ ular arⱪiliⱪ kɵtürülsun dǝp, baldaⱪlarni sanduⱪning ikki yenidiki ⱨalⱪiliridin ɵtküzüp ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","U sanduⱪning yapⱪuqi süpitidǝ altundin uzunluⱪi ikki yerim gǝz, kǝngliki bir yerim gǝz bolƣan bir «kǝfarǝt tǝhti» yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","U ikki kerubni altundin soⱪup yasidi; ularni kǝfarǝt tǝhtining ikki tǝripigǝ ornatti; ");
INSERT INTO uigpin_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","bir kerubni bir tǝripigǝ, yǝnǝ bir kerubni yǝnǝ bir tǝripigǝ ornatti. U ikki tǝripidiki kerublarni kǝfarǝt tǝhti bilǝn bir gǝwdǝ ⱪildi.    ");
INSERT INTO uigpin_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kerublar bir-birigǝ yüzlinip, ⱪanatlirini kǝfarǝt tǝhtining üstigǝ kerip, ⱪanatliri bilǝn uni yepip turatti; kerublarning yüzi kǝfarǝt tǝhtigǝ ⱪaritildi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","U ⱨǝm xirǝni akatsiyǝ yaƣiqidin yasidi; uning uzunluⱪi ikki gǝz, kǝngliki bir gǝz, egizliki bir yerim gǝz idi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","U uni sap altun bilǝn ⱪaplap, uning üstünki ⱪismining qɵrisigǝ altundin girwǝk qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","U xirǝning qɵrisigǝ tɵt ilik egizliktǝ bir lǝw yasidi; bu lǝwning qɵrisigimu altundin bir girwǝk qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","U xirǝgǝ altundin tɵt ⱨalⱪa yasap, bu ⱨalⱪilarni xirǝning tɵt burjikidiki qetiⱪⱪa ornatti. ");
INSERT INTO uigpin_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Xirǝni kɵtürüxkǝ baldaⱪlar ɵtküzülsun dǝp, ⱨalⱪilar xirǝ lewigǝ yeⱪin bekitildi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Xirǝ üqün u baldaⱪlarni akatsiyǝ yaƣiqidin yasap, altun bilǝn ⱪaplidi; xirǝ ular bilǝn kɵtürülǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","U xirǝning üstigǝ ⱪoyulidiƣan barliⱪ buyumlarni, yǝni legǝnlirini, ⱪaqa-ⱪuqa tǝhsilirini, xarab ⱨǝdiyǝlirini ⱪuyidiƣan ⱪǝdǝⱨ wǝ piyalilǝrning ⱨǝmmisini sap altundin yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","U ⱨǝm qiraƣdanni sap altundin yasidi; qiraƣdanni soⱪup yasidi; qiraƣdanning puti, ƣoli, ⱪǝdǝⱨliri, ƣunqiliri wǝ gülliri bir pütün altundin soⱪuldi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Qiraƣdanning ƣolining ikki yenidin altǝ xahqǝ qiⱪirildi — qiraƣdanning bir yenidin üq xahqǝ, uning yǝnǝ bir yenidin üq xahqǝ qiⱪirildi; ");
INSERT INTO uigpin_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","bir yenidiki ⱨǝrbir xahqidǝ badam güli xǝklidǝ ƣunqisi wǝ qeqiki bolƣan üq ⱪǝdǝⱨ qiⱪirildi, yǝnǝ bir yenidiki ⱨǝrbir xahqidǝ badam güli xǝklidǝ ƣunqisi wǝ qeqiki bolƣan üq ⱪǝdǝⱨ qiⱪirildi. Qiraƣdanƣa qiⱪirilƣan altǝ xahqining ⱨǝmmisi xundaⱪ yasaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Qiraƣdanning ƣolidin badam güli xǝklidǝ ƣunqisi wǝ qeqiki bolƣan tɵt ⱪǝdǝⱨ qiⱪirildi.    ");
INSERT INTO uigpin_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Bulardin baxⱪa birinqi ikki xahqining astida bir ƣunqǝ, ikkinqi ikki xahqining astida bir ƣunqǝ, üqinqi ikki xahqining astida bir ƣunqǝ yasalƣanidi; qiraƣdanƣa qiⱪirilƣan altǝ xahqining astining ⱨǝmmisi xundaⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Uning xu ƣunqiliri ⱨǝm xahqiliri qiraƣdan bilǝn bir gǝwdǝ ⱪilindi — bir pütün sap altundin soⱪup yasaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","U qiraƣdanning yǝttǝ qiriƣini, xundaⱪla uning pilik ⱪayqiliri bilǝn küldanlirini sap altundin yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","U qiraƣdan wǝ uning barliⱪ ǝswablirini bir talant sap altundin yasidi.    ");
INSERT INTO uigpin_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","U yǝnǝ huxbuygaⱨni akatsiyǝ yaƣiqidin yasidi. Uning uzunluⱪi bir gǝz, kǝngliki bir gǝz, egizliki ikki gǝz bolup, tɵt qasa ⱪilip yasaldi; tɵt burjikidiki münggüzlǝr uning bilǝn bir pütün ⱪilip yasaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","U uni, yǝni uning üstini, tɵt ǝtrapini ⱨǝm münggüzlirini sap altun bilǝn ⱪaplidi; uning üsti ⱪismining qɵrisigǝ altundin girwǝk qiⱪardi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Uningƣa altundin ikki ⱨalⱪa yasap, uning girwikining astiƣa bekitti; ularni ikki yeniƣa udulmu’udul bekitti. Huxbuygaⱨni kɵtüridiƣan ikki baldaⱪni selix üqün bularni huxbuygaⱨning ikki tǝripigǝ orunlaxturdi.    ");
INSERT INTO uigpin_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","U baldaⱪlarni akatsiyǝ yaƣiqidin yasap, altun bilǝn ⱪaplidi. ");
INSERT INTO uigpin_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","U ⱨǝm muⱪǝddǝs Mǝsiⱨlǝx meyini yasidi, andin ǝtirqi qiⱪarƣandǝk dora-dǝrmǝklǝrni tǝngxǝp sap huxbuyni yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","U kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨini akatsiyǝ yaƣiqidin yasidi. Ⱪurbangaⱨ tɵt qasa bolup, uzunluⱪi bǝx gǝz, kǝngliki bǝx gǝz, egizliki üq gǝz ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","U uning tɵt burjikigǝ ⱪoyulidiƣan münggüzlirini yasidi; münggüzliri ⱪurbangaⱨ bilǝn bir gǝwdǝ ⱪilindi. Ⱪurbangaⱨni mis bilǝn ⱪaplidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","U ⱪurbangaⱨning barliⱪ ǝswablirini — uningƣa has bolƣan daslarni, gürjǝklǝrni, korilarni, lahxigirlarni wǝ otdanlarnimu yasidi; uning barliⱪ ǝswablirini mistin yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ⱪurbangaⱨ üqün mistin bir xala yasidi; xalani ⱪurbangaⱨning ⱪap belining astidiki girwǝktin tɵwǝnrǝk turidiƣan ⱪildi; xala ⱪurbangaⱨning dǝl otturisida idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","U xalaning tɵt burjikigǝ baldaⱪlar ɵtküzülidiƣan tɵt mis ⱨalⱪini ⱪuyup yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","U baldaⱪlarni akatsiyǝ yaƣiqidin yasap, ularni mis bilǝn ⱪaplidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Andin u ⱪurbangaⱨni kɵtürüx üqün baldaⱪlarni ⱪurbangaⱨning ikki yenidiki ⱨalⱪilarƣa ɵtküzüp ⱪoydi. U ⱪurbangaⱨni tahtaylardin, iqini box ⱪilip yasidi.    ");
INSERT INTO uigpin_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","U yǝnǝ yuyunux desini mistin, uning tǝglikinimu mistin yasidi; u bularni «kɵrüxüx qediri»ning kirix eƣizining aldida hizmǝttǝ bolƣan ayallarning mis ǝynǝkliridin yasidi.    ");
INSERT INTO uigpin_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Andin u qedirning ⱨoylisinimu yasidi. Ⱨoylining jǝnubiƣa, yǝni jǝnubⱪa yüzlǝngǝn tǝripigǝ nepiz toⱪulƣan aⱪ kanap rǝhttin pǝrdilǝrni yasidi; uning uzunluⱪi yüz gǝz idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Pǝrdilǝrni esixⱪa yigirmǝ hada wǝ hadilarning yigirmǝ tǝglikini u mistin yasidi. Hadilarning ilmǝkliri wǝ baldaⱪliri kümüxtin yasalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Xuningƣa ohxax ximal tǝripidimu uzunluⱪi yüz gǝz kelidiƣan pǝrdǝ bar idi. Pǝrdilǝrni esixⱪa yigirmǝ hada wǝ hadilarning yigirmǝ tǝglikini u mistin yasidi. Hadilarning ilmǝkliri wǝ baldaⱪliri kümüxtin yasalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Xuningƣa ohxax ƣǝrb tǝripidǝ uzunluⱪi ǝllik gǝz kelidiƣan pǝrdǝ bar idi; pǝrdilǝrni esixⱪa on hada wǝ hadilarning on tǝglikini u mistin yasidi. Hadilarning ilmǝkliri wǝ baldaⱪliri kümüxtin yasaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ⱨoylining xǝrⱪ tǝripi, yǝni kün qiⱪixⱪa yüzlǝngǝn tǝripining kǝngliki ǝllik gǝz idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Bir tǝripidǝ on bǝx gǝz kelidiƣan pǝrdǝ bolup, uning üq hadisi bilǝn üq tǝgliki bar idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Yǝnǝ bir tǝripidimu on bǝx gǝz kelidiƣan pǝrdǝ bolup, uning üq hadisi bilǝn üq tǝgliki bar idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ⱨoylining qɵrisidiki pǝrdilǝrning ⱨǝmmisi nepiz toⱪulƣan aⱪ kanap rǝhttin tikilgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ⱨoylining qɵrisidiki ⱨǝmmǝ hadilarning tǝgliki mistin, ularning ilmǝkliri wǝ baldaⱪliri kümüxtin yasaldi; hadilarning baxlirimu kümüxtin ⱪaplanƣanidi. Ⱨoylining qɵrisidiki ⱨǝmmǝ hadilar kümüxtin yasalƣan baldaⱪlar bilǝn bir-birigǝ qetildi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ⱨoylining kirix eƣizidiki pǝrdǝ nepiz toⱪulƣan aⱪ kanap rǝhtkǝ kɵk, sɵsün wǝ ⱪizil yiplar arilaxturulup, kǝxtiqilǝr tǝripidin kǝxtilǝndi; uning uzunluⱪi yigirmǝ gǝz, egizliki ⱨoylidiki pǝrdilǝrning egizlikigǝ ohxax bolup bǝx gǝz idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Uning tɵt hadisi bilǝn mistin yasalƣan tɵt tǝgliki bar idi; hadilarning ilmǝkliri kümüxtin yasaldi, ularning baxliri kümüx bilǝn ⱪaplandi wǝ baldaⱪliri kümüxtin yasaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Muⱪǝddǝs qedirning ⱨǝm qɵrisidiki ⱨoylining barliⱪ miⱪ-ⱪozuⱪliri mistin yasaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Muⱪǝddǝs qedir, yǝni «ⱨɵküm-guwaⱨliⱪi qediri» üqün atalƣan materiyallarning sani tɵwǝndǝ hatirilǝngǝn (ular Musaning buyruⱪi bilǝn, kaⱨin Ⱨarunning oƣli Itamarning ⱪol astidiki Lawiylar mǝs’ul bolup sanaⱪtin ɵtküzülüp, Hudaƣa atalƣanidi): — ");
INSERT INTO uigpin_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Yǝⱨuda ⱪǝbilisidin bolƣan Hurning nǝwrisi, Urining oƣli Bǝzalǝl Pǝrwǝrdigar Musaƣa buyruƣanning ⱨǝmmisini ada ⱪildi; ");
INSERT INTO uigpin_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Dan ⱪǝbilisidin bolƣan Aⱨisamaⱪning oƣli Oⱨoliyab uning yardǝmqisi idi; u bolsa nǝⱪⱪaxliⱪ-oymiqiliⱪ ustisi, layiⱨiligüqi ⱨǝmdǝ kɵk, sɵsün, ⱪizil yiptin aⱪ kanap rǝhtkǝ kǝxtǝ tikǝlǝydiƣan usta idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Muⱪǝddǝs qedirni yasaxⱪa ixlitilgǝn altun, yǝni «pulanglatma ⱨǝdiyǝ» süpitidǝ kǝltürülgǝn altunning ⱨǝmmisi muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ yigirmǝ toⱪⱪuz talant yǝttǝ yüz ottuz xǝkǝl idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Jamaǝt arisidin sanaⱪtin ɵtküzülgǝn adǝmlǝr tǝripidin kǝltürülgǝn kümüx bolsa muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ bir yüz talant bir ming yǝttǝ yüz yǝtmix bǝx xǝkǝl idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Bu kümüx nopusi royhǝtkǝ elinƣan kixilǝrdin elinƣanidi — demǝk, kimki yigirmǝ yax ya uningdin qong, sanaⱪtin ɵtküzülgǝnlǝrning ⱨǝrbiri bir beka, yǝni muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ yerim xǝkǝl kümüx bǝrdi. Sanaⱪtin ɵtkǝn kixi altǝ yüz üq ming bǝx yüz ǝllik kixi idi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Muⱪǝddǝs jayning tǝgliklirini ⱨǝm otturisidiki pǝrdining tǝgliklirini ⱪuyuxⱪa yüz talant kümüx kǝtti; yüz talant kümüxtin yüz tǝglik yasilip, ⱨǝrbir tǝglik üqün bir talant ixlitildi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","U ⱪalƣan bir ming yǝttǝ yüz yǝtmix bǝx xǝkǝl kümüxtin hadilarning ilmǝklirini yasidi, ularning baxlirini ⱪaplidi, xuningdǝk ularni bir-birigǝ qatidiƣan baldaⱪlarni yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","«Pulanglatma ⱨǝdiyǝ» süpitidǝ kǝltürülgǝn mis bolsa yǝtmix talant, ikki ming tɵt yüz xǝkǝl qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Buningdin u jamaǝt qedirining kirix eƣizining tǝgliklirini, mis ⱪurbangaⱨni, uning mis xalasi wǝ ⱪurbangaⱨning barliⱪ ǝswablirini, ");
INSERT INTO uigpin_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ⱨoylining qɵrisidiki hada tǝgliklirini, ⱨoylining kirix eƣizidiki tǝgliklǝrni, qedirning barliⱪ ⱪozuⱪlirini wǝ ⱨoylining qɵrisidiki ⱪozuⱪlarning ⱨǝmmisini yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Pǝrwǝrdigar Musaƣa buyruƣinidǝk kɵk, sɵsün wǝ ⱪizil yiplar ixlitilip, muⱪǝddǝs qedirning hizmitidǝ kiyilidiƣan kaⱨinliⱪ kiyimlǝr, xundaⱪla Ⱨarunning muⱪǝddǝs kiyimliri tǝyyar ⱪilindi.    ");
INSERT INTO uigpin_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bǝzalǝl altun wǝ kɵk, sɵsün, ⱪizil yiplar bilǝn nepiz toⱪulƣan aⱪ kanap rǝhtlǝrdin ǝfodni yasap tǝyyarlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ular altunni soⱪup nepiz ⱪilip, uni kesip yip ⱪildi, andin bularni maⱨirliⱪ bilǝn kɵk yiplar, sɵsün yiplar wǝ ⱪizil yiplardin aⱪ kanap rǝhtkǝ laⱨayilǝngǝn nushilar üstigǝ toⱪudi.    ");
INSERT INTO uigpin_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ular ǝfodning aldi wǝ kǝyni ⱪismini bir-birgǝ tutaxturup turidiƣan ikki mürilik tasma yasidi; ǝfodning ikki tǝripi bir-birigǝ tutaxturuldi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Əfodning üstigǝ baƣlaydiƣan bǝlwaƣ ǝfod bilǝn bir pütün ⱪilinƣan bolup, uningƣa ohxax sipta ixlinip, altun wǝ kɵk, sɵsün, ⱪizil yiplar wǝ nepiz toⱪulƣan aⱪ kanap rǝhttin yasaldi; ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ular ikki aⱪ ⱨeⱪiⱪni ikki altun kɵzlükkǝ ornitip, ularning üstigǝ huddi mɵⱨür oyƣandǝk Israilning oƣullirining namlirini oyup yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Israilning oƣulliriƣa ǝslǝtmǝ tax bolsun üqün, Pǝrwǝrdigar Musaƣa buyruƣandǝk ikki yaⱪutni ǝfodning ikki mürilik tasmisiƣa bekitip ⱪoydi.    ");
INSERT INTO uigpin_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","U ⱪoxenni qewǝr ⱪollarƣa nǝpis ⱪilip kǝxtilitip yasidi; uni ǝfodni ixligǝn usulda altun wǝ kɵk, sɵsün, ⱪizil yiplar bilǝn nepiz toⱪulƣan aⱪ kanap rǝhttin yasidi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ular ⱪoxenni ikki ⱪat, tɵt qasa ⱪilip yasidi; ikki ⱪat ⱪilinƣanda uzunluⱪi bir ƣeriq, kǝnglikimu bir ƣeriq kelǝtti. ");
INSERT INTO uigpin_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Uning üstigǝ tɵt ⱪatar ⱪilip gɵⱨǝrlǝrni ornatti: — bir ⱪatardikisi ⱪizil yaⱪut, seriⱪ gɵⱨǝr wǝ zumrǝtlǝr idi; bu birinqi ⱪatar idi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ikkinqi ⱪatarƣa kɵk ⱪaxtexi, kɵk yaⱪut wǝ almas, ");
INSERT INTO uigpin_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","üqinqi ⱪatarƣa sɵsün yaⱪut, piroza wǝ sɵsün kwarts, ");
INSERT INTO uigpin_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","tɵtinqi ⱪatarƣa beril yaⱪut, aⱪ ⱨeⱪiⱪ wǝ anartax ornitildi; bularning ⱨǝmmisi altun kɵzlükkǝ bekitildi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Bu gɵⱨǝrlǝr Israilning oƣullirining namliriƣa wǝkil ⱪilinip, ularning sanidǝk on ikki bolup, mɵⱨür oyƣandǝk ⱨǝrbir gɵⱨǝrgǝ on ikki ⱪǝbilining nami birdin-birdin pütüldi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ular ⱪoxenƣa xoynidǝk exilgǝn sap altundin ikki exilmǝ zǝnjir yasidi; ");
INSERT INTO uigpin_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ular ⱪoxenƣa altundin ikki kɵzlük wǝ ikki ⱨalⱪa etip, ikki ⱨalⱪini ⱪoxenning yuⱪiriⱪi ikki burjikigǝ bekitti; ");
INSERT INTO uigpin_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","andin xu altundin exilip yasalƣan ikki zǝnjirni ⱪoxenning yuⱪiriⱪi ikki burjikidiki ⱨalⱪidin ɵtküzüp, ");
INSERT INTO uigpin_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","exilgǝn xu zǝnjirlǝrning ikki uqini ikki kɵzlükkǝ bekitip, kɵzlüklǝrni ǝfodning ikki mürilik tasmisining aldi ⱪismiƣa ornatti. ");
INSERT INTO uigpin_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Buningdin baxⱪa ular altundin ikki ⱨalⱪa yasap, ularni ⱪoxenning asti tǝripidiki ikki burjikigǝ bekitti; ular ǝfodⱪa tegixip turidiƣan ⱪilinip iqigǝ ⱪadaldi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Mundin baxⱪa ular altundin yǝnǝ ikki ⱨalⱪa yasap, ularni ǝfodning ikki mürilik tasmisining aldi tɵwǝnki ⱪismiƣa, ǝfodⱪa ulinidiƣan jayƣa yeⱪin, kǝxitilǝngǝn bǝlwaƣdin egizrǝk ⱪilip bekitti. ");
INSERT INTO uigpin_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ular ⱪoxenning ǝfodning bǝlweƣidin yuⱪiriraⱪ turuxi, ⱪoxenning ǝfodtin ajrap kǝtmǝsliki üqün kɵk xoyna bilǝn ⱪoxenning ⱨalⱪisini ǝfodning ⱨalⱪisiƣa qetip ⱪoydi. Bularning ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bǝzalǝl ǝfodning iqidiki tonni pütünlǝy kɵk rǝnglik ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Tonning baxⱪa kiyilidiƣan tɵxüki dǝl otturisida, huddi sawutning yaⱪisidǝk ixlǝngǝnidi; yirtilip kǝtmǝsliki üqün uning qɵrisigǝ pǝwaz ixlǝndi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ular tonning etikining qɵrisigǝ kɵk, sɵsün wǝ ⱪizil yiptin anarlarni toⱪup esip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ular ⱨǝmdǝ altun ⱪongƣuraⱪlarni yasap, ⱪongƣuraⱪlarni tonning etikining qɵrisigǝ, anarlarning ariliⱪiƣa birdin esip ⱪoydi; ⱨǝr ikki anarning otturisiƣa bir ⱪongƣuraⱪ esip ⱪoyuldi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ⱪaⱨinliⱪ hizmitigǝ ait ⱪongƣuraⱪlar tonning etikining qɵrisigǝ bekitildi; bir altun ⱪongƣuraⱪ, bir anar, bir altun ⱪongƣuraⱪ, bir anar ⱪilip bekitildi; ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ular Ⱨarun bilǝn uning oƣulliriƣa nepiz toⱪulƣan aⱪ kanap rǝhttin halta kɵnglǝklǝrni tikti; ");
INSERT INTO uigpin_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","sǝllini aⱪ kanap rǝhttǝ yasidi, xundaⱪla qirayliⱪ egiz bɵklǝrni aⱪ kanap rǝhttǝ, tamballarni nepiz toⱪulƣan aⱪ kanap rǝhttǝ tǝyyarlidi; ");
INSERT INTO uigpin_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","buningdin baxⱪa ular bǝlwaƣnimu kɵk, sɵsün wǝ ⱪizil yip arilaxturulup kǝxtilǝngǝn, nepiz toⱪulƣan aⱪ kanap rǝhttǝ tǝyyarlidi; bularning ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ular yǝnǝ nǝpis tahtayni, yǝni muⱪǝddǝs otuƣatni sap altundin yasap, uning üstigǝ mɵⱨür oyƣandǝk: «Pǝrwǝrdigarƣa muⱪǝddǝs ⱪilindi» dǝp oyup pütti; ");
INSERT INTO uigpin_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ular otuƣatⱪa kɵk rǝnglik yipni baƣlap, uning bilǝn otuƣatni sǝlligǝ taⱪidi, bular Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Xu tǝriⱪidǝ jamaǝtning ibadǝt qedirining ⱨǝmmǝ ⱪuruluxi pütküzüldi; Israillar Pǝrwǝrdigarning Musaƣa buyruƣinining ⱨǝmmisini xu boyiqǝ ⱪildi; xu tǝriⱪidǝ ⱨǝmmisini püttürdi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ular qedirni Musaning yeniƣa elip kǝldi — qedir yopuⱪlirini, uning barliⱪ ǝswablirini, ilmǝklirini, tahtaylirini, baldaⱪlirini, hadiliri bilǝn tǝgliklirini, ");
INSERT INTO uigpin_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","xuningdǝk ⱪizil boyalƣan ⱪoqⱪar terisidin yasalƣan yopuⱪ bilǝn delfin terisidin yasalƣan yopuⱪni, «ayrima pǝrdǝ»ni, ");
INSERT INTO uigpin_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ǝⱨdǝ sanduⱪi wǝ uning baldaⱪlirini, «kǝfarǝt tǝhti»ni, ");
INSERT INTO uigpin_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","xirǝ wǝ uning barliⱪ ǝswablirini, xundaⱪla «tǝⱪdim nanlar»ni, ");
INSERT INTO uigpin_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","sap altundin yasalƣan qiraƣdan bilǝn uning qiraƣlirini, yǝni üstigǝ tizilƣan qiraƣlarni, uning barliⱪ ǝswabliri ⱨǝm qiraƣ meyini, ");
INSERT INTO uigpin_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","altun huxbuygaⱨ, mǝsiⱨlǝx meyi, dora-dǝrmǝklǝrdin yasalƣan huxbuyni, qedirning kirix eƣizining pǝrdisini, ");
INSERT INTO uigpin_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","mis ⱪurbangaⱨ bilǝn uning mis xalasini, uning baldaⱪliri bilǝn ⱨǝmmǝ ǝswablirini, yuyux desi bilǝn uning tǝglikini, ");
INSERT INTO uigpin_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ⱨoylining qɵrisidiki pǝrdilǝrni, uning hadiliri wǝ ularning tǝgliklirini, ⱨoylining kirix eƣizining pǝrdisi bilǝn ⱨoylining taniliri wǝ ⱪozuⱪlirini, muⱪǝddǝs qedirning, yǝni jamaǝt qediriƣa ait hizmǝtkǝ ixlitilidiƣan barliⱪ ǝswablarni, ");
INSERT INTO uigpin_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","muⱪǝddǝs jayƣa ait hizmǝt üqün tikilgǝn kaⱨinliⱪ kiyimini, yǝni Ⱨarun kaⱨinning muⱪǝddǝs kiyimliri bilǝn uning oƣullirining kaⱨinliⱪ kiyimlirini bolsa, ⱨǝmmisini elip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Bu ixlarning ⱨǝmmisini Israillar Pǝrwǝrdigarning Musaƣa barliⱪ buyruƣanliri boyiqǝ ǝnǝ xundaⱪ ada ⱪilƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa ixlarning ⱨǝmmisigǝ tǝpsiliy ⱪaridi, mana, ular Pǝrwǝrdigarning buyruƣini boyiqǝ bu ixlarni pütküzgǝnidi; buyrulƣandǝk, dǝl xundaⱪ ⱪilƣanidi; Musa bularni kɵrüp, ularƣa bǝht-bǝrikǝt tilǝp dua ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Andin Pǝrwǝrdigar Musaƣa mundaⱪ ǝmr ⱪildi: — ");
INSERT INTO uigpin_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Birinqi ayning bexi, ayning birinqi küni sǝn jamaǝt qedirining muⱪǝddǝshanisini tikligin. ");
INSERT INTO uigpin_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ⱨɵküm-guwaⱨliⱪ sanduⱪini uning iqigǝ ⱪoyup, iqki pǝrdǝ arⱪiliⱪ ǝⱨdǝ sanduⱪini tosup ⱪoyƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","xirǝni qedirning iqigǝ ǝkirip, üstigǝ tizilidiƣan nǝrsilǝrni tizƣin; andin qiraƣdanni ǝkirip, üstigǝ qiraƣlarni orunlaxturƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Altun bilǝn ⱪaplanƣan huxbuy kɵydürgüqi ⱪurbangaⱨni ⱨɵküm-guwaⱨliⱪ sanduⱪining uduliƣa tiklǝp ⱪoyƣin; qedirning kirix eƣizining pǝrdisini esip ⱪoyƣin.    ");
INSERT INTO uigpin_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨini muⱪǝddǝshanining, yǝni jamaǝt qedirining kirix eƣizining aldiƣa ⱪoyƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","andin yuyux desini jamaǝt qediri bilǝn ⱪurbangaⱨning otturisiƣa orunlaxturup, su toxturup ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ⱨoylining qɵrisigǝ pǝrdilǝrni bekitip, ⱨoylining kirix eƣizining pǝrdisini asⱪin; ");
INSERT INTO uigpin_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","andin «mǝsiⱨlǝx meyi»ni elip, ibadǝt qediri wǝ uning iqidiki barliⱪ nǝrsilǝrni mǝsiⱨlǝp, uni wǝ barliⱪ ⱨǝmmǝ ǝswablirini Hudaƣa atap muⱪǝddǝs ⱪilƣin. Xundaⱪ ⱪilip pütkül qedir muⱪǝddǝs bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Sǝn kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨini, xundaⱪla uning barliⱪ ǝswablirini mǝsiⱨlǝp, uni Hudaƣa atap muⱪǝddǝs ⱪilƣin; buning bilǝn ⱪurbangaⱨ «ǝng muⱪǝddǝs nǝrsilǝr» ⱪatarida bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Sǝn yǝnǝ yuyunux desi wǝ uning tǝglikini mǝsiⱨlǝp muⱪǝddǝs ⱪilƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Andin Ⱨarun bilǝn uning oƣullirini jamaǝt qedirining kirix eƣiziƣa yeⱪin ǝkilip, ularni su bilǝn yuƣin; ");
INSERT INTO uigpin_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ⱨarunƣa muⱪǝddǝs kiyimlǝrni kiydürüp, Manga kaⱨinliⱪ hizmǝttǝ boluxi üqün uni mǝsiⱨlǝp, Manga ayrip muⱪǝddǝs ⱪilƣin. ");
INSERT INTO uigpin_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Andin uning oƣullirini elip kirip, ularƣa halta kɵnglǝklǝrni kiydürüp, ");
INSERT INTO uigpin_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ularning atisini mǝsiⱨliginingdǝk Manga kaⱨinliⱪ hizmitidǝ boluxi üqün ularnimu mǝsiⱨligin. Xuning bilǝn ularning bu mǝsiⱨlinixi ular üqün ǝwladtin ǝwladⱪiqǝ ǝbǝdiy kaⱨinliⱪning bǝlgisi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa xundaⱪ ⱪildi; Pǝrwǝrdigar uningƣa nemǝ buyruƣan bolsa, u xundaⱪ bǝja kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Xundaⱪ boldiki, ikkinqi yilning birinqi eyida, ayning birinqi künidǝ ibadǝt qediri tiklǝndi.    ");
INSERT INTO uigpin_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa qedirni tikip, tǝgliklirini orunlaxturup, tahtaylirini tizip, ularning baldaⱪlirini bekitip, hadilirini tiklidi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Muⱪǝddǝs qedirning üstigǝ iqki yopuⱪni yapti, andin uning üstigǝ taxⱪi yopuⱪni yepip ⱪoydi; bularning ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Andin u ⱨɵküm-guwaⱨliⱪni elip, uni sanduⱪ iqigǝ ⱪoydi; baldaⱪlarni ǝⱨdǝ sanduⱪining ⱨalⱪiliridin ɵtküzüp, «kǝfarǝt tǝhti»ni sanduⱪning üstigǝ orunlaxturdi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Əⱨdǝ sanduⱪini muⱪǝddǝs qedir iqigǝ elip kirip, otturiƣa «ayrima pǝrdǝ»ni tartti; xundaⱪ ⱪilip u ⱨɵküm-guwaⱨliⱪ sanduⱪini pǝrdǝ arⱪiliⱪ tosup ⱪoydi. Ⱨǝmmǝ ix Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","U xirǝni jamaǝt qediriƣa elip kirip, muⱪǝddǝs jayning ximal tǝripigǝ, «ǝng muⱪǝddǝs jay»diki pǝrdining sirtiƣa ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","«Tǝⱪdim nanlar»ni xirǝning üstigǝ, Pǝrwǝrdigarning aldiƣa tizip ⱪoydi; bularning ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Andin u qiraƣdanni jamaǝt qediriƣa elip kirip, uni muⱪǝddǝs jayning jǝnub tǝripigǝ, xirǝning uduliƣa ⱪoydi, ");
INSERT INTO uigpin_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","qiraƣlarni Pǝrwǝrdigarning aldiƣa orunlaxturdi; bularning ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Andin u huxbuyni kɵydürgüqi altun ⱪurbangaⱨni iqidiki pǝrdining aldiƣa tiklidi; ");
INSERT INTO uigpin_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Uning üstidǝ esil huxbuyni kɵydürdi; bularning ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","U ibadǝt qedirining kirix eƣiziƣa pǝrdǝ tartti. ");
INSERT INTO uigpin_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Andin kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨini jamaǝt qediridiki muⱪǝddǝs jayning kirix eƣiziƣa yeⱪin ⱪoydi; uning üstidǝ kɵydürmǝ ⱪurbanliⱪ wǝ ⱪoxumqǝ axliⱪ ⱨǝdiyǝsini ɵtküzdi; bularning ⱨǝmmisi Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Yuyunux desini jamaǝt qediri bilǝn ⱪurbangaⱨning otturisiƣa ⱪoyup, yuyuxⱪa ixlitilidiƣan suni dasⱪa toxⱪuzup ⱪuydi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","Musa wǝ Ⱨarun bilǝn uning oƣulliri ⱪaqanla jamaǝt qediriƣa kirsǝ yaki ⱪurbangaⱨⱪa yeⱪin barsa, Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪollirini xu suda yuyatti. Bular Pǝrwǝrdigarning Musaƣa buyruƣinidǝk ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Andin u qedir ⱨǝm ⱪurbangaⱨning ǝtrapiƣa ⱨoyla pǝrdisini tiklǝp, ⱨoylining kirix eƣizining pǝrdisini tartti. Xu tǝriⱪidǝ Musa pütkül ixni tamamlidi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Xuning bilǝn bulut jamaǝt qedirini ⱪaplap, Pǝrwǝrdigarning julasi ibadǝt qedirini toldurdi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Bulut sayǝ qüxürüp, Pǝrwǝrdigarning julasi qedirni toldurƣini üqün, Musa jamaǝt qediriƣa kirǝlmidi. ");
INSERT INTO uigpin_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ⱪaqanki bulut jamaǝt qediridin kɵtürülsǝ, Israillar sǝpǝrgǝ atlinatti. Ⱨǝrbir ⱪetim sǝpǝrdǝ xundaⱪ bolatti. ");
INSERT INTO uigpin_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Bulut kɵtürülmisǝ ular ⱪozƣalmay, taki kɵtürülidiƣan küngiqǝ sǝpǝrgǝ qiⱪmaytti. ");
INSERT INTO uigpin_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Qünki kündüzi Pǝrwǝrdigarning buluti muⱪǝddǝs qedir üstidǝ turatti, keqisi uning üstidǝ ot kɵrünǝtti; pütkül Israil jǝmǝtining kɵz aldida ularning barliⱪ ⱪilƣan sǝpǝrliridǝ xular kɵrünǝtti. ");
INSERT INTO uigpin_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Wǝ Pǝrwǝrdigar Musani qaⱪirip jamaǝt qediridin uningƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Sǝn Israillarƣa sɵz ⱪilip ularƣa mundaⱪ degin: — Əgǝr silǝrdin biringlar Pǝrwǝrdigarning aldiƣa bir ⱪurbanliⱪni sunmaⱪqi bolsanglar, ⱪurbanliⱪinglarni qarpaylardin, yǝni kala yaki uxxaⱪ mallardin sunuxunglar kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Əgǝr uning sunidiƣini kalilardin kɵydürmǝ ⱪurbanliⱪ bolsa, undaⱪta u bejirim ǝrkǝk ⱨaywanni kǝltürsun; uning Pǝrwǝrdigarning aldida ⱪobul boluxi üqün uni jamaǝt qedirining kirix aƣzining aldida sunsun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","U ⱪolini kɵydürmǝ ⱪurbanliⱪning bexiƣa ⱪoysun; xuning bilǝn ⱪurbanliⱪ uning orniƣa kǝfarǝt boluxⱪa ⱪobul ⱪilinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Andin u Pǝrwǝrdigarning ⱨuzurida buⱪini boƣuzlisun; kaⱨinlar bolƣan Ⱨarunning oƣulliri ⱪenini kǝltürüp, jamaǝt qedirining kirix aƣzidiki ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Andin ⱪurbanliⱪ ⱪilƣuqi kɵydürmǝ ⱪurbanliⱪ ⱪilinƣan ⱨaywanning terisini soyup, tenini parqilisun ");
INSERT INTO uigpin_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","wǝ Ⱨarun kaⱨinning oƣulliri ⱪurbangaⱨta ot ⱪalap otning üstigǝ otunlarni tizsun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Andin kaⱨinlar bolƣan Ⱨarunning oƣulliri gɵx parqilirini, bexi wǝ meyi bilǝn ⱪoxup, ⱪurbangaⱨdiki otning üstidiki otunning üstigǝ tǝrtip bilǝn tizip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Lekin uning iq-ⱪarni bilǝn paqaⱪlirini ⱪurbanliⱪ sunƣuqi suda yusun; andin kaⱨin ⱨǝmmisini elip kelip ⱪurbangaⱨning üstidǝ kɵydürsun. Bu ot arⱪiliⱪ sunulidiƣan ⱪurbanliⱪ ⱨesabida, Pǝrwǝrdigarƣa huxbuy qiⱪirilidiƣan kɵydürmǝ ⱪurbanliⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Əgǝr u kɵydürmǝ ⱪurbanliⱪ ⱪilix üqün uxxaⱪ mallardin ⱪoy ya ɵqkǝ ⱪurbanliⱪ ⱪilay desǝ, undaⱪta u bejirim bolƣan bir ǝrkikini kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","U uni ⱪurbangaⱨning ximal tǝripidǝ Pǝrwǝrdigarning ⱨuzurida boƣuzlisun. Andin kaⱨinlar bolƣan Ⱨarunning oƣulliri ⱪenini elip, ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ⱪurbanliⱪ ⱪilƣuqi bolsa gɵxni parqilap, bexi bilǝn meyini kesip ayrisun. Andin kaⱨin bularni elip ⱪurbangaⱨtiki otning üstidiki otunning üstidǝ tǝrtip boyiqǝ tizip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Lekin uning iq-ⱪarni bilǝn paqaⱪlarni ⱪurbanliⱪ sunƣuqi suda yusun; andin kaⱨin ⱨǝmmisini elip kelip ⱪurbangaⱨning üstidǝ kɵydürsun. Bu ot arⱪiliⱪ sunulidiƣan ⱪurbanliⱪ ⱨesabida, Pǝrwǝrdigarƣa huxbuy qiⱪirilidiƣan kɵydürmǝ ⱪurbanliⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Əgǝr ⱪurbanliⱪ ⱪilƣuqi Pǝrwǝrdigarƣa atap uqar-ⱪanatlardin kɵydürmǝ ⱪurbanliⱪ ⱪilay desǝ, undaⱪta u pahtǝklǝrdin yaki kǝptǝr baqkiliridin ⱪurbanliⱪ kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kaⱨin uni ⱪurbangaⱨning yeniƣa elip kelip, bexini tolƣap üzüp uni ⱪurbangaⱨning üstidǝ kɵydürsun; uning ⱪeni siⱪilip ⱪurbangaⱨning temiƣa sürtülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Lekin taxliⱪini pǝyliri bilǝn ⱪoxup ⱪurbangaⱨning xǝrⱪ tǝripidiki küllükkǝ taxliwǝtsun; ");
INSERT INTO uigpin_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","u ⱪurbanliⱪni ikki ⱪanitining otturisidin yarsun, biraⱪ uni ikki parqǝ ⱪiliwǝtmisun. Andin kaⱨin buni elip ⱪurbangaⱨdiki otning üstidiki otunning üstigǝ ⱪoyup kɵydürsun; bu ot arⱪiliⱪ sunulidiƣan ⱪurbanliⱪ ⱨesabida, Pǝrwǝrdigarƣa huxbuy qiⱪirilidiƣan kɵydürmǝ ⱪurbanliⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Əgǝr birkim Pǝrwǝrdigarning ⱨuzuriƣa axliⱪ ⱨǝdiyǝsi sunmaⱪqi bolsa ⱨǝdiyǝsi esil undin boluxi kerǝk; u uningƣa zǝytun meyi ⱪuyup andin üstigǝ mǝstiki salsun.    ");
INSERT INTO uigpin_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","U uni elip kaⱨinlar bolƣan Ⱨarunning oƣullirining aldiƣa kǝltürsun; andin kaⱨin ⱨǝdiyǝ sunƣuqining yadlinixi üqün zǝytun meyi ilǝxtürülgǝn undin bir qanggal elip, ⱨǝmmǝ mǝstiki bilǝn ⱪoxup, bu ⱨǝdiyǝni ⱪurbangaⱨta kɵydürsun; bu ot arⱪiliⱪ sunulidiƣan, Pǝrwǝrdigarƣa huxbuy qiⱪirilidiƣan ⱨǝdiyǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Əmma axliⱪ ⱨǝdiyǝsidin ⱪalƣini bolsa, Ⱨarun bilǝn uning oƣulliriƣa tǝwǝ bolsun. Bu Pǝrwǝrdigarƣa ot arⱪiliⱪ sunulƣanlarning iqidǝ «ǝng muⱪǝddǝslǝrning biri» ⱨesablinidu.    ");
INSERT INTO uigpin_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Əgǝr sǝn tonurda pixurulƣan nǝrsilǝrdin axliⱪ ⱨǝdiyǝsi sunay desǝng, ular zǝytun meyi ilǝxtürülgǝn esil undin pixurulƣan toⱪaqlar yaki zǝytun meyi sürülüp mǝsiⱨlǝngǝn petir ⱨǝmǝk nanlardin bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Əgǝr sening kǝltüridiƣan ⱨǝdiyǝng tawida pixurulƣan axliⱪ ⱨǝdiyǝsi bolsa u zǝytun meyi ixlǝxtürülüp esil undin petir ⱨalda etilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Sǝn uni oxtup üstigǝ zǝytun meyi ⱪuyƣin; u axliⱪ ⱨǝdiyǝsi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Sening kǝltüridiƣan ⱨǝdiyǝng ⱪazanda pixurulƣan axliⱪ ⱨǝdiyǝsi bolsa undaⱪta u esil un bilǝn zǝytun meyida etilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Xu yollarda tǝyyarlanƣan axliⱪ ⱨǝdiyǝlirini Pǝrwǝrdigarning ⱨuzuriƣa kǝltürgin; uni kaⱨinƣa bǝrgin, u uni ⱪurbangaⱨⱪa elip baridu. ");
INSERT INTO uigpin_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kaⱨin bolsa axliⱪ ⱨǝdiyǝsidin «yadlinix ülüxi»ni elip ⱪurbangaⱨning üstidǝ kɵydürsun. Bu ot arⱪiliⱪ sunulidiƣan, Pǝrwǝrdigarƣa huxbuy qiⱪirilidiƣan ⱨǝdiyǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Əmma axliⱪ ⱨǝdiyǝsidin ⱪalƣini bolsa, Ⱨarun bilǝn uning oƣulliriƣa tǝwǝ bolsun. Bu Pǝrwǝrdigarƣa ot arⱪiliⱪ sunulƣanlarning iqidǝ «ǝng muⱪǝddǝslǝrning biri» ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Silǝr Pǝrwǝrdigarning ⱨuzuriƣa sunidiƣan ⱨǝrⱪandaⱪ axliⱪ ⱨǝdiyǝliri eqitⱪu bilǝn tǝyyarlanmisun. Qünki silǝrning Pǝrwǝrdigarƣa otta sunulidiƣan ⱨǝdiyǝnglarning ⱨeqⱪaysisida eqitⱪu yaki ⱨǝsǝlni kɵydürüxkǝ bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Bularni Pǝrwǝrdigarning aldiƣa «dǝslǝpki ⱨosul» süpitidǝ sunsanglar bolidu, lekin ular huxbuy süpitidǝ ⱪurbangaⱨning üstidǝ kɵydürülüp sunulmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Sening ⱨǝrbir axliⱪ ⱨǝdiyǝng tuz bilǝn tuzlinixi kerǝk; ⱨǝdiyǝngni Hudayingning ǝⱨdǝ tuzidin mǝⱨrum ⱪilmay, ⱨǝmmǝ axliⱪ ⱨǝdiyǝliringni tuz bilǝn tuzliƣin. ");
INSERT INTO uigpin_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Əgǝr sǝn Pǝrwǝrdigarƣa «dǝslǝpki ⱨosul»din axliⱪ ⱨǝdiyǝsi sunay desǝng, undaⱪta ziraǝtning yengi pixⱪan kɵk bexini elip, danlarni otta ⱪorup, ezip talⱪan süpitidǝ sunƣin; bu «dǝslǝpki ⱨosul» ⱨǝdiyǝsi bolidu; ");
INSERT INTO uigpin_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","sǝn uningƣa zǝytun meyi ⱪuyup üstigǝ mǝstiki salƣin; bu axliⱪ ⱨǝdiyǝsi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kaⱨin bolsa uningdin, yǝni ⱪorup ezilgǝn danlar bilǝn zǝytun meyidin bir ⱪismini elip ⱨǝmmǝ mǝstiki bilǝn ⱪoxup, bolarni «yadlinix ülüxi» süpitidǝ kɵydürsun. Bu ot arⱪiliⱪ Pǝrwǝrdigarƣa sunulƣan ⱨǝdiyǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Birsining sunidiƣini inaⱪliⱪ ⱪurbanliⱪi bolsa, xundaⱪla kalilardin sunsa, u Pǝrwǝrdigarning ⱨuzuriƣa bejirim bir ǝrkikini yaki qixisini kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","U sunidiƣan bu ⱨaywanning bexiƣa ⱪolini ⱪoyup, andin uni jamaǝt qedirining kirix eƣizi aldida boƣuzlisun. Andin kaⱨinlar bolƣan Ⱨarunning oƣulliri ⱪenini ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Sunƣuqi kixi bu inaⱪliⱪ ⱪurbanliⱪidin Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱨǝdiyǝ süpitidǝ bir ⱪismini elip beƣixlisun, yǝni iq ⱪarnini yɵgǝp turƣan mayni, xundaⱪla barliⱪ iq meyini elip ");
INSERT INTO uigpin_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ikki bɵrǝkni wǝ ularning üstidiki ⱨǝmdǝ ikki yanpixidiki mayni ajritip, jigǝrning bɵrǝkkiqǝ bolƣan qawa meyini kesip, elip kǝlsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ⱨarunning oƣulliri bolsa bularni ⱪurbangaⱨning üstigǝ kǝltürüp ot üstigǝ ⱪoyulƣan otunning üstidiki kɵydürmǝ ⱪurbanliⱪⱪa ⱪoxup kɵydürsun. Bu ot arⱪiliⱪ sunulidiƣan, Pǝrwǝrdigarƣa huxbuy qiⱪirilidiƣan ⱪurbanliⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Birsining Pǝrwǝrdigarƣa ⱪilidiƣan inaⱪliⱪ ⱪurbanliⱪi üqün sunidiƣini uxxaⱪ maldin bolsa, undaⱪta u bejirim bir ǝrkikini yaki qixisini kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Əgǝr uning ⱪurbanliⱪi ⱪoy bolsa uni Pǝrwǝrdigarning aldiƣa kǝltürüp, ");
INSERT INTO uigpin_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ⱪurbanliⱪ ⱪilidiƣan bu ⱨaywanning bexiƣa ⱪolini ⱪoyup, andin uni jamaǝt qedirining kirix aƣzining aldida boƣuzlisun. Andin Ⱨarunning oƣulliri ⱪenini elip ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Sunƣuqi kixi bu inaⱪliⱪ ⱪurbanliⱪidin Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱨǝdiyǝ süpitidǝ bir ⱪismini, yǝni uning meyini elip beƣixlisun, — pütün mayliⱪ ⱪuyruⱪini uning omurtⱪisiƣa yeⱪin yǝrdin ajritip elip, iq ⱪarnini yɵgǝp turƣan mayni, xundaⱪla barliⱪ iq meyini elip, ");
INSERT INTO uigpin_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ikki bɵrǝkni wǝ ularning üstidiki ⱨǝmdǝ ikki yanpixidiki mayni ajritip, jigǝrning bɵrǝkkiqǝ bolƣan qawa meyini kesip, elip kǝlsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kaⱨin bularni ⱪurbangaⱨning üstidǝ kɵydürsun; bu otta sunulidiƣan, Pǝrwǝrdigarƣa atalƣan taam ⱨǝdiyǝsi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Uning sunidiƣini ɵqkǝ bolsa, buni Pǝrwǝrdigarning ⱨuzuriƣa kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","U ⱪolini uning bexiƣa ⱪoyup, andin uni jamaǝt qedirining aldida boƣuzlisun. Andin Ⱨarunning oƣulliri ⱪenini elip ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Andin sunƣuqi kixi bu ⱪurbanliⱪtin Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱨǝdiyǝ süpitidǝ bir ⱪismini elip beƣixlisun, yǝni iq ⱪarnini yɵgǝp turƣan mayni, xundaⱪla barliⱪ iq meyini elip, ");
INSERT INTO uigpin_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ikki bɵrǝkni wǝ ularning üstidiki ⱨǝmdǝ ikki yanpixidiki mayni ajritip, jigǝrning bɵrǝkkiqǝ bolƣan qawa meyini kesip, elip kǝlsun. ");
INSERT INTO uigpin_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kaⱨin bularni ⱪurbangaⱨning üstidǝ kɵydürsun; bu otta sunulidiƣan, huxbuy qiⱪiridiƣan taam ⱨǝdiyǝsi bolidu. Mayning ⱨǝmmisi Pǝrwǝrdigarƣa tǝwǝdur. ");
INSERT INTO uigpin_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Bu ⱨǝrⱪandaⱪ turar jayinglarda silǝrgǝ ǝbǝdiy bǝlgilimǝ bolidu; silǝr ⱨeqⱪandaⱪ may yaki ⱪan yemǝslikinglar kerǝk.    ");
INSERT INTO uigpin_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Israillarƣa sɵz ⱪilip mundaⱪ degin: — «Birsi bilmǝy ezip, Pǝrwǝrdigar «ⱪilma» dǝp buyruƣan ⱨǝrⱪandaⱪ ǝmrlǝrdin birigǝ hilapliⱪ ⱪilip selip, gunaⱨ ⱪilsa, tɵwǝndikidǝk ⱪilsun: — ");
INSERT INTO uigpin_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","— ǝgǝr mǝsiⱨlǝngǝn kaⱨin hǝlⱪni gunaⱨⱪa putlaxturidiƣan bir gunaⱨni ⱪilsa, undaⱪta u bu ⱪilƣan gunaⱨi üqün bir bejirim yax torpaⱪni elip kelip, Pǝrwǝrdigarƣa gunaⱨ ⱪurbanliⱪi süpitidǝ sunsun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","U torpaⱪni jamaǝt qedirining kirix aƣzining yeniƣa, Pǝrwǝrdigarning aldiƣa kǝltürüp, ⱪolini uning bexiƣa ⱪoyup, andin torpaⱪni Pǝrwǝrdigarning ⱨuzurida boƣuzlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Andin mǝsiⱨlǝngǝn kaⱨin torpaⱪning ⱪenidin azƣina elip, jamaǝt qediri iqigǝ kɵtürüp aparsun; ");
INSERT INTO uigpin_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","kaⱨin xu yǝrdǝ barmiⱪini ⱪanƣa qilap, ⱪanni ǝng muⱪǝddǝs jayning pǝrdisining aldida, Pǝrwǝrdigarning ⱨuzurida yǝttǝ mǝrtiwǝ sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Xundaⱪla kaⱨin ⱪandin elip, jamaǝt qediri iqidǝ Pǝrwǝrdigarning aldida turƣan huxbuygaⱨning münggüzlirigǝ sürsun. Torpaⱪning ⱪalƣan ⱨǝmmǝ ⱪenini bolsa, jamaǝt qedirining kirix aƣzining aldidiki kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨining tüwigǝ tɵküp ⱪoysun; ");
INSERT INTO uigpin_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","andin u gunaⱨ ⱪurbanliⱪi bolƣan torpaⱪning iqidin ⱨǝmmǝ meyini ajritip qiⱪarsun — yǝni iq ⱪarnini yɵgǝp turƣan may bilǝn ⱪalƣan iq meyi, ");
INSERT INTO uigpin_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ikki bɵrǝkni wǝ ularning üstidiki ⱨǝmdǝ ikki yanpixidiki mayni ajritip, jigǝrning bɵrǝkkiqǝ bolƣan qawa meyini ajratsun ");
INSERT INTO uigpin_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(huddi inaⱪliⱪ ⱪurbanliⱪi bolƣan kalining iqidiki may ajritilƣandǝk); andin kaⱨin bularni kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨining üstidǝ kɵydürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Lekin torpaⱪning terisi bilǝn ⱨǝmmǝ gɵxi, bax bilǝn paqaⱪliri, iq ⱪarni bilǝn ȥinini, ");
INSERT INTO uigpin_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","yǝni pütkül torpaⱪning ⱪalƣan ⱪisimlirini qedirgaⱨning sirtiƣa elip qiⱪip, pak bir yǝrgǝ, yǝni küllǝr tɵkülidiƣan jayƣa elip qiⱪip, otunning üstidǝ otta kɵydürsun. Bular küllǝr tɵkülidiƣan jayda kɵydürüwetilsun.    ");
INSERT INTO uigpin_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Əgǝr pütkül Israil jamaiti ɵzi bilmigǝn ⱨalda ezip gunaⱨ ⱪilƣan bolsa, Pǝrwǝrdigarning «ⱪilma» dǝp buyruƣan ⱨǝrⱪandaⱪ ǝmrlirigǝ hilapliⱪ ixlarning birini ⱪilip selip, gunaⱨⱪa qüxüp ⱪalsa,    ");
INSERT INTO uigpin_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","xundaⱪla ularning sadir ⱪilƣan gunaⱨi aydinglaxⱪan bolsa, undaⱪta jamaǝt gunaⱨ ⱪurbanliⱪi süpitidǝ bir yax torpaⱪni sunup jamaǝt qedirining aldiƣa kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Jamaǝtning aⱪsaⱪalliri Pǝrwǝrdigarning aldida ⱪollirini torpaⱪning bexiƣa ⱪoyup, andin torpaⱪni Pǝrwǝrdigarning aldida boƣuzlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Mǝsiⱨlǝngǝn kaⱨin torpaⱪning ⱪenidin azƣina elip jamaǝt qediri iqigǝ elip kirsun; ");
INSERT INTO uigpin_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","xu yǝrdǝ barmiⱪini ⱪanƣa qilap, ⱪanni ǝng muⱪǝddǝs jayning pǝrdisining aldida, Pǝrwǝrdigarning ⱨuzurida yǝttǝ mǝrtiwǝ sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Xundaⱪla kaⱨin ⱪandin elip jamaǝt qediri iqidǝ Pǝrwǝrdigarning aldida turƣan huxbuygaⱨning münggüzlirigǝ sürsun. Torpaⱪning ⱪalƣan ⱨǝmmǝ ⱪenini bolsa, jamaǝt qedirining kirix aƣzining aldidiki kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨining tüwigǝ tɵküp ⱪoysun; ");
INSERT INTO uigpin_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","kaⱨin torpaⱪning iqidin barliⱪ meyini ajritip elip, ⱪurbangaⱨning üstidǝ kɵydürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","U gunaⱨ ⱪurbanliⱪi bolƣan ilgiriki torpaⱪni ⱪilƣiniƣa ohxax bu torpaⱪnimu xundaⱪ ⱪilsun; wǝ dǝl xundaⱪ ⱪilixi kerǝk; xu yol bilǝn kaⱨin ular üqün kǝfarǝt kǝltüridu; xu gunaⱨ ulardin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Andin u torpaⱪni qedirgaⱨning taxⱪiriƣa elip qiⱪip, ilgiriki torpaⱪni kɵydürgǝndǝk bu torpaⱪnimu kɵydürsun. Bu jamaǝt üqün gunaⱨ ⱪurbanliⱪi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Əgǝr bir ǝmir bilmǝy uning Hudasi Pǝrwǝrdigarning «ⱪilma» degǝn ⱨǝrⱪandaⱪ ǝmrlirining birigǝ hilapliⱪ ⱪilip selip, gunaⱨⱪa qüxüp ⱪalsa, ");
INSERT INTO uigpin_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","wǝ ⱪilƣan gunaⱨi ɵzigǝ mǝlum ⱪilinƣan bolsa, undaⱪta u ɵzi ⱪurbanliⱪ üqün bejirim bir tekini sunsun; ");
INSERT INTO uigpin_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","u ⱪolini tekining bexiƣa ⱪoyup, andin uni kɵydürmǝ ⱪurbanliⱪ ⱪilinidiƣan ⱨaywanlarni boƣuzlaydiƣan jayƣa elip berip Pǝrwǝrdigarning aldida boƣuzlisun. Bu bir gunaⱨ ⱪurbanliⱪi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kaⱨin gunaⱨ ⱪurbanliⱪining ⱪenidin barmiⱪiƣa azƣina elip, uni kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨining münggüzlirigǝ sürüp ⱪoysun; andin ⱪalƣan ⱪenini kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨining tüwigǝ tɵküp ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","U inaⱪliⱪ ⱪurbanliⱪi ⱪilinƣan ⱨaywanning meyini kɵydürgǝndǝk, uning barliⱪ meyini ⱪurbangaⱨta kɵydürsun. Bu yol bilǝn kaⱨin uni gunaⱨidin paklandurux üqün kǝfarǝt kǝltüridu wǝ xu gunaⱨi uningdin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Əgǝr puⱪralardin biri bilmǝy uning Hudasi Pǝrwǝrdigarning «ⱪilma» degǝn ⱨǝrⱪandaⱪ ǝmrlirining birigǝ hilapliⱪ ⱪilip selip, gunaⱨⱪa qüxüp ⱪalsa, ");
INSERT INTO uigpin_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","wǝ ⱪilƣan gunaⱨi ɵzigǝ mǝlum ⱪilinƣan bolsa, undaⱪta u ɵzining, yǝni u sadir ⱪilƣan gunaⱨi üqün ⱪurbanliⱪ ⱪilixⱪa bejirim bir qixi ɵqkini sunsun; ");
INSERT INTO uigpin_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","u ⱪolini gunaⱨ ⱪurbanliⱪining bexiƣa ⱪoyup, andin uni kɵydürmǝ ⱪurbanliⱪlarni boƣuzlaydiƣan jayƣa elip berip boƣuzlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Andin kaⱨin uning ⱪenidin barmiⱪiƣa azƣina elip uni kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨining münggüzlirigǝ sürüp ⱪoysun; ⱪalƣan barliⱪ ⱪenini ⱪurbangaⱨning tüwigǝ tɵküp ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Inaⱪliⱪ ⱪurbanliⱪi ⱪilinƣan ⱨaywanning meyi iqidin ajritilƣandǝk uningmu ⱨǝmmǝ meyini ajritip qiⱪarsun; kaⱨin uni Pǝrwǝrdigarning aldida huxbuy kǝltürsun dǝp ⱪurbangaⱨning üstidǝ kɵydürsun. Xu yol bilǝn kaⱨin uning üqün kǝfarǝt kǝltüridu; xu gunaⱨ uningdin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Əgǝr u kixi gunaⱨ ⱪurbanliⱪi üqün ⱪoza kǝltürüxni halisa, bejirim bir qixi ⱪozini sunsun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","U ⱪolini gunaⱨ ⱪurbanliⱪi ⱪozisining bexiƣa ⱪoyup, kɵydürmǝ ⱪurbanliⱪlar boƣuzlinidiƣan jayƣa elip berip, uni gunaⱨ ⱪurbanliⱪi süpitidǝ boƣuzlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Andin kaⱨin gunaⱨ ⱪurbanliⱪining ⱪenidin barmiⱪiƣa azƣina elip uni kɵydürmǝ ⱪurbanliⱪ ⱪurbangaⱨining münggüzlirigǝ sürüp ⱪoysun; uning ⱪalƣan barliⱪ ⱪenini u ⱪurbangaⱨning tüwigǝ tɵküp ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Inaⱪliⱪ ⱪurbanliⱪi ⱪilinƣan ⱪozining meyi iqidin ajritilƣandǝk, uningmu ⱨǝmmǝ meyini ajritip qiⱪarsun; kaⱨin bularni Pǝrwǝrdigarƣa atap otta sunulidiƣan barliⱪ ⱪurbanliⱪlarƣa ⱪoxup, ⱪurbangaⱨning üstidǝ kɵydürsun. Xu yol bilǝn kaⱨin uning sadir ⱪilƣan gunaⱨi üqün kǝfarǝt kǝltüridu; xu gunaⱨ uningdin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Əgǝr birsi mǝlum ixⱪa guwaⱨqi bolup, xundaⱪla uningƣa ⱪǝsǝm buyrulƣinida kɵrgini yaki bilginidin mǝlumat bǝrmisǝ, undaⱪta u ⱪǝbiⱨlikining jazasiƣa tartilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Əgǝr birsi ɵzi bilmǝy napak bir nǝrsigǝ tegip kǝtsǝ — mǝyli u napak bir ⱨaywanning jǝsiti bolsun, mǝyli napak bir qarpayning jǝsiti bolsun, yaki napak bir ɵmiligüqi ⱨaywanning jǝsiti bolsun, muxundaⱪ nǝrsigǝ tegip kǝtsǝ umu napak sanilip gunaⱨkar ⱨesablinidu; ");
INSERT INTO uigpin_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ǝgǝr xuningdǝk birsi ɵzi tuymay mǝlum kixining adǝmni napak ⱪilidiƣan ⱨǝrⱪandaⱪ nijasitigǝ tegip kǝtsǝ, xundaⱪla u buni bilip yǝtsǝ, undaⱪta u gunaⱨkar ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Əgǝr birsi angsiz rǝwixtǝ yaman yaki yahxi bir ixni ⱪilay dǝp ⱪǝsǝm ⱪilip salsa (kixilǝr ⱨǝrtürlük ix toƣrisida angsiz rǝwixtǝ ⱪǝsǝm ⱪilixi mumkin), xundaⱪla u buni tonup yǝtsǝ, u bu ixlar tüpǝylidin gunaⱨkar ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Birsi yuⱪiriⱪi ⱨǝrⱪaysi ixlarda mǝn gunaⱨkar boldum dǝp bilsǝ, u ɵz gunaⱨini «mǝn mundaⱪ gunaⱨ ⱪildim» dǝp iⱪrar ⱪilsun; ");
INSERT INTO uigpin_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","andin ɵzi sadir ⱪilƣan gunaⱨining kafariti üqün Pǝrwǝrdigarning aldiƣa «itaǝtsizlikni tiligüqi ⱪurbanliⱪ» süpitidǝ uxxaⱪ maldin saƣliⱪ wǝ ya bir qixi ɵqkini gunaⱨ ⱪurbanliⱪi ⱪilip kǝltürsun; andin kaⱨin uni gunaⱨidin paklanduruxⱪa uning üqün kǝfarǝt kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Əgǝr u ⱪoylardin ⱪurbanliⱪ ⱪilixⱪa ⱪurbi yǝtmisǝ, u ⱪilƣan itaǝtsizliki üqün ikki pahtǝk yaki ikki baqkini elip kelip, birini gunaⱨ ⱪurbanliⱪi üqün, yǝnǝ birini kɵydürmǝ ⱪurbanliⱪ üqün Pǝrwǝrdigarning aldiƣa sunsun. ");
INSERT INTO uigpin_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","U bularni kaⱨinning ⱪexiƣa kǝltürgǝndǝ, kaⱨin awwal gunaⱨ ⱪurbanliⱪiƣa tǝyyarlanƣanni ⱪurbanliⱪ ⱪilip boynini üzmǝy, bexiƣa yeⱪin jayidin tolƣisun, lekin bexini boynidin üzüwǝtmisun;    ");
INSERT INTO uigpin_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","andin gunaⱨ ⱪurbanliⱪining ⱪenidin azƣina elip ⱪurbangaⱨning temiƣa qaqsun; ⱪalƣan ⱪeni bolsa ⱪurbangaⱨning tüwigǝ siⱪip qiⱪirilsun. Buning ɵzi gunaⱨ ⱪurbanliⱪi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Əmma ikkinqisini bolsa bekitilgǝn bǝlgilimǝ boyiqǝ kɵydürmǝ ⱪurbanliⱪ ⱪilip sunsun. Bu yol bilǝn kaⱨin uning ⱪilƣan gunaⱨi üqün kǝfarǝt kǝltüridu wǝ xu gunaⱨ uningdin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Əgǝr ikki pahtǝk yaki ikki baqkini kǝltürüxkǝ ⱪurbi yǝtmisǝ, undaⱪta gunaⱨ ⱪilƣan kixi gunaⱨ ⱪurbanliⱪi üqün esil undin bir ǝfaⱨning ondin birini kǝltürsun; bu gunaⱨ ⱪurbanliⱪi bolƣaqⱪa u uning üstigǝ zǝytun meyi ⱪuymisun yaki üstigǝ ⱨeqⱪandaⱪ mǝstiki salmisun; qünki u gunaⱨ ⱪurbanliⱪi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","U uni kaⱨinning ⱪexiƣa kǝltürsun wǝ kaⱨin buningdin sunƣuqining «yadlinix ülüxi» süpitidǝ bir qanggal elip, xuni Pǝrwǝrdigarƣa atap otta sunulƣan ⱪurbanliⱪlarƣa ⱪoxup, ⱪurbangaⱨning üstidǝ kɵydürsun. Buning ɵzi gunaⱨ ⱪurbanliⱪi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Bu yol bilǝn u xu gunaⱨlardin ⱪaysisini ⱪilƣan bolsa, kaⱨin uning üqün kǝfarǝt kǝltüridu. Axliⱪ ⱨǝdiyǝliridikigǝ ohxax ⱪalƣan ⱪismi kaⱨinƣa tǝwǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Andin Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Birsi bilmǝy Pǝrwǝrdigarƣa atalƣan muⱪǝddǝs nǝrsilǝrgǝ nisbǝtǝn itaǝtsizlik ⱪilip gunaⱨ ɵtküzsǝ, undaⱪta u Pǝrwǝrdigarning aldiƣa uxxaⱪ maldin bejirim bir ⱪoqⱪarni itaǝtsizlik ⱪurbanliⱪi ⱪilip kǝltürsun; xu itaǝtsizlik ⱪurbanliⱪi bolƣan ⱪoqⱪarning baⱨasini sǝn muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ kümüx xǝkǝlgǝ tohtatⱪin.    ");
INSERT INTO uigpin_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Andin xu kixi muⱪǝddǝs nǝrsilǝrgǝ nisbǝtǝn ɵtküzgǝn hataliⱪidin bolƣan ziyanni toldursun, xundaⱪla ziyanning bǝxtin biri boyiqǝ ⱪoxup kaⱨinƣa tɵlǝm tɵlisun. Bu yol bilǝn kaⱨin itaǝtsizlik ⱪurbanliⱪi bolƣan ⱪoqⱪarning wasitisi bilǝn uning üqün kǝfarǝt kǝltüridu; xu gunaⱨ uningdin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Əgǝr birsi bilmǝy Pǝrwǝrdigarning «ⱪilma» degǝn ⱨǝrⱪandaⱪ ǝmrlirining birǝrisigǝ hilapliⱪ ⱪilip, gunaⱨkar bolƣan bolsa u ⱪǝbiⱨlikining jazasiƣa tartilidu; ");
INSERT INTO uigpin_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","xundaⱪ bolsa, u uxxaⱪ maldin sǝn tohtatⱪan ⱪimmǝttǝ bejirim bir ⱪoqⱪarni itaǝtsizlik ⱪurbanliⱪi ⱪilip sunsun. Bu yol bilǝn kaⱨin uning bilmǝy ɵtküzgǝn itaǝtsizliki üqün kǝfarǝt kǝltüridu wǝ xu itaǝtsizlik gunaⱨi uningdin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Bu itaǝtsizlik ⱪurbanliⱪi bolidu; qünki u dǝrⱨǝⱪiⱪǝt Pǝrwǝrdigarning aldida itaǝtsizlik ⱪilƣan. ");
INSERT INTO uigpin_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Andin Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Əgǝr birsi gunaⱨ ⱪilip Pǝrwǝrdigarning aldida wapasizliⱪ ⱪilip, ⱪoxnisi ɵzigǝ amanǝt yaki kapalǝtkǝ bǝrgǝn bir nǝrsǝ yaki ⱪoxnisidin zorawanliⱪ bilǝn buliwalƣan mǝlum bir nǝrsǝ toƣrisida yalƣan gǝp ⱪilƣan bolsa yaki ⱪoxnisidin naⱨǝⱪliⱪ bilǝn mǝlum nǝrsini tartiwalƣan bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","yaki yitip kǝtkǝn bir nǝrsini tepiwelip uningdin tansa yaki kixilǝrning gunaⱨ sadir ⱪilƣan ⱨǝrⱪandaⱪ bir Ixi toƣrisida yalƣan ⱪǝsǝm iqsǝ, ");
INSERT INTO uigpin_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","U gunaⱨ ⱪilƣan ixta ɵzini gunaⱨkar dǝp tonup yǝtsǝ, undaⱪta u buliwalƣan yaki naⱨǝⱪ tartiwalƣan nǝrsǝ yaki uningƣa amanǝtkǝ berilgǝn nǝrsǝ bolsun, yaki yitip ketip tepiwalƣan nǝrsǝ bolsun, ");
INSERT INTO uigpin_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","yaki u ⱨǝrⱪandaⱪ nǝrsǝ toƣrisida yalƣan ⱪǝsǝm iqkǝn bolsun, uning ⱨǝmmisini toluⱪ baⱨasi boyiqǝ tɵlisun, xundaⱪla xu baⱨaning bǝxtin bir ⱪismi boyiqǝ ⱪoxup tɵlisun; u itaǝtsizlik ⱪurbanliⱪini ⱪilƣan künidǝ tɵlǝmni igisigǝ tapxurup bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Andin u Pǝrwǝrdigarning aldiƣa itaǝtsizlik ⱪurbanliⱪi süpitidǝ uxxaⱪ maldin sǝn tohtatⱪan ⱪimmǝt boyiqǝ bejirim bir ⱪoqⱪarni itaǝtsizlik ⱪurbanliⱪi ⱪilip kaⱨinning ⱪexiƣa elip kǝlsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kaⱨin bu yol bilǝn uning üqün Pǝrwǝrdigarning aldida kǝfarǝt kǝltüridu wǝ u ⱨǝrⱪaysi ixta itaǝtsizlik ⱪilƣan bolsimu u uningdin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Sǝn Ⱨarun bilǝn oƣulliriƣa kɵydürmǝ ⱪurbanliⱪ toƣrisida ǝmr ⱪilip mundaⱪ degin: — Kɵydürmǝ ⱪurbanliⱪ toƣrisidiki ⱪaidǝ-nizam mundaⱪ bolidu: — Kɵydürmǝ ⱪurbanliⱪ pütün keqǝ tang atⱪuqǝ ⱪurbangaⱨtiki oqaⱪning üstidǝ kɵyüp tursun; wǝ ⱪurbangaⱨning otini ɵqürmǝy yeniⱪ turƣuzunglar. ");
INSERT INTO uigpin_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Kaⱨin kanap tonini kiyip, yalingaqliⱪini yepip, saƣrisiƣiqǝ kanap iq tambal kiyip tursun; ⱪurbangaⱨning üstidiki ot bilǝn kɵydürülgǝn kɵydürmǝ ⱪurbanliⱪning külini elip, ⱪurbangaⱨning bir tǝripidǝ ⱪoysun; ");
INSERT INTO uigpin_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","andin kiyimlirini seliwetip baxⱪa kiyimlǝrni kiyip, külini qedirgaⱨning sirtiƣa elip qiⱪip pakiz bir jayda ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ⱪurbangaⱨning oti bolsa ⱨǝmixǝ yenip tursun; uni ⱨeq waⱪit ɵqürüxkǝ bolmaydu, kaⱨin ɵzi ⱨǝr küni ǝtigǝndǝ uningƣa otun selip, üstigǝ kɵydürmǝ ⱪurbanliⱪni tizsun wǝ uning üstigǝ inaⱪliⱪ ⱪurbanliⱪlirining meyini ⱪoyup kɵydürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Üzülmǝs bir ot ⱪurbangaⱨning üstidǝ ⱨǝmixǝ kɵyüp tursun; u ⱨǝrgiz ɵqürülmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","axliⱪ ⱨǝdiyǝsi toƣrisidiki ⱪaidǝ-nizam mundaⱪ: — Ⱨarunning oƣulliridin biri uni Pǝrwǝrdigarning aldiƣa, ⱪurbangaⱨning aldiƣa kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","U axliⱪ ⱨǝdiyǝsi bolƣan esil unƣa ⱪolini selip uningdin xundaⱪla uningdiki zǝytun meyidin bir qanggal elip wǝ ⱨǝdiyǝning üstidiki barliⱪ mǝstikini ⱪoxup, bularni ⱪurbangaⱨ üstidǝ kɵydürsun; bu ⱨǝdiyǝning «yadlinix ülüxi» bolup, Pǝrwǝrdigarning aldida huxbuy kǝltürüx üqün ⱪilinƣan bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Exip ⱪalƣanlirini bolsa Ⱨarun bilǝn oƣulliri yesun; u eqitⱪu selinmay pixurulup muⱪǝddǝs bir jayda yeyilsun; ular uni jamaǝt qedirining ⱨoylisida yesun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","U mutlǝⱪ eqitⱪusiz pixurulsun. Mǝn otta Manga sunulidiƣan ⱪurbanliⱪ-ⱨǝdiyǝlǝr iqidin xuni ularning ɵz ülüxi bolsun dǝp ularƣa ⱨǝⱪ ⱪilip bǝrdim; u gunaⱨ wǝ itaǝtsizlikni tiligüqi ⱪurbanliⱪlarƣa ohxax «ǝng muⱪǝddǝslǝrning biri» ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ⱨarunning ǝwladidin bolƣan ǝrkǝklǝrning ⱨǝmmisi buningdin yesun; bu dǝwrdin-dǝwrgǝ aranglarda ǝbǝdiy bir bǝlgilimǝ bolidu; Pǝrwǝrdigarƣa atap otta sunulƣanliridin bular ularning ülüxi bolsun. Uningƣa ⱪol tǝgküzgüqi jǝzmǝn muⱪǝddǝs boluxi kerǝk.    ");
INSERT INTO uigpin_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Ⱨarun mǝsiⱨlinidiƣan künidǝ u wǝ oƣullirining Pǝrwǝrdigarning aldiƣa sunidiƣini mundaⱪ boluxi kerǝk: — Ular üzülmǝs axliⱪ ⱨǝdiyǝsi süpitidǝ esil undin bir ǝfaⱨning ondin birini sunuxi kerǝk; ǝtigini yerimini, ahximi yǝnǝ yerimini sunsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","U tawida zǝytun meyi bilǝn etilsun; u zǝytun meyiƣa qilap pixurulƣandin keyin sǝn uni elip kir; axliⱪ ⱨǝdiyǝsining pixurulƣan parqilirini huxbuy süpitidǝ Pǝrwǝrdigarƣa atap sunƣin. ");
INSERT INTO uigpin_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ⱨarunning oƣullirining ⱪaysisi uning ornida turuxⱪa mǝsiⱨlǝngǝn bolsa umu ⱨǝdiyǝni xundaⱪ tǝyyarlap sunsun; bu ǝbǝdiy mutlǝⱪ bir bǝlgilimǝ bolidu. Bu ⱨǝdiyǝ Pǝrwǝrdigarƣa atap toluⱪ kɵydürülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kaⱨinning ⱨǝrbir axliⱪ ⱨǝdiyǝsi bolsa pütünlǝy kɵydürülsun; u ⱨǝrgiz yeyilmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Ⱨarun bilǝn oƣulliriƣa mundaⱪ degin: — Gunaⱨ ⱪurbanliⱪi toƣrisidiki ⱪaidǝ-nizam mundaⱪ: — Gunaⱨ ⱪurbanliⱪimu kɵydürmǝ ⱪurbanliⱪ boƣuzlinidiƣan jayda, Pǝrwǝrdigarning aldida boƣuzlansun; bu hil ⱪurbanliⱪ «ǝng muⱪǝddǝslǝrning biri» ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Gunaⱨ ⱪurbanliⱪini ɵtküzgüqi kaⱨin ɵzi uni yesun; ⱪurbanliⱪ muⱪǝddǝs bir yǝrdǝ, jamaǝt qedirining ⱨoylisida yeyilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Uning gɵxigǝ ⱪol tǝgküzgüqi ⱨǝrkim muⱪǝddǝs bolmisa bolmaydu, xuningdǝk ǝgǝr uning ⱪeni birsining kiyimigǝ qaqrap kǝtsǝ, undaⱪta ⱪan qeqilƣan jay muⱪǝddǝs bir yǝrdǝ yuyulsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ⱪaysi sapal ⱪazanda ⱪurbanliⱪ ⱪaynitilip pixurulƣan bolsa, u sundurulsun. Əgǝr u mis ⱪazanda ⱪaynitip pixurulƣan bolsa, u ⱪirip sürülsun ⱨǝm su bilǝn yuyulsun. ");
INSERT INTO uigpin_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kaⱨinlardin bolƣan barliⱪ ǝr kixilǝr uningdin yesǝ bolidu. Bu «ǝng muⱪǝddǝslǝrning biri» ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ⱨalbuki, muⱪǝddǝs jayda kǝfarǝt kǝltürüx üqün ⱪeni jamaǝt qediriƣa kirgüzülgǝn ⱨǝrⱪandaⱪ gunaⱨ ⱪurbanliⱪi bolsa, ⱨǝrgiz yeyilmisun, bǝlki pütünlǝy kɵydürülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Itaǝtsizlik ⱪurbanliⱪi toƣrisidiki ⱪaidǝ-nizam mana mundaⱪ: — Bu ⱪurbanliⱪ «ǝng muⱪǝddǝslǝrning biri» ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Kɵydürmǝ ⱪurbanliⱪ boƣuzlinidiƣan jayda itaǝtsizlikni tilǝx ⱪurbanliⱪimu boƣuzlinidu; kaⱨin ⱪenini ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ⱪurbanliⱪ ⱪilƣuqi kixi barliⱪ meyini sunsun; yǝni mayliⱪ ⱪuyruⱪi bilǝn iq ⱪarnini yɵgǝp turƣan mayni, ");
INSERT INTO uigpin_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ikki bɵrǝkni wǝ ularning üstidiki ⱨǝmdǝ ikki yanpixidiki mayni ajritip, jigǝrning bɵrǝkkiqǝ bolƣan qawa meyini ajritip sunsun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kaⱨin bularni Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱪurbanliⱪ süpitidǝ ⱪurbangaⱨta kɵydürsun. Bu itaǝtsizlik ⱪurbanliⱪi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kaⱨinlardin bolƣan ǝr kixilǝrning ⱨǝmmisi buni yesun; u muⱪǝddǝs yǝrdǝ yeyilsun; u «ǝng muⱪǝddǝslǝrning biri» ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Gunaⱨ ⱪurbanliⱪi ⱪandaⱪ bolsa itaǝtsizlik ⱪurbanliⱪimu xundaⱪ bolidu; ular ikkisi toƣrisidiki ⱪaidǝ-nizam ohxax; bu ⱪurbanliⱪ kǝfarǝt kǝltürüxkǝ ⱪurbanliⱪ ɵtküzgüqi kaⱨinning ɵzigǝ tǝwǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kaⱨin birsining sunƣan kɵydürmǝ ⱪurbanliⱪini ɵtküzgǝn bolsa, kɵydürmǝ ⱪurbanliⱪning terisi xu kaⱨinning bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Tonurda pixurulƣan ⱨǝrbir axliⱪ ⱨǝdiyǝsi, xundaⱪla ⱪazanda yaki tawida etilgǝn ⱨǝrbir axliⱪ ⱨǝdiyǝsi bolsa uni ɵtküzgǝn kaⱨinning bolidu, yǝni kaⱨinning ɵzigǝ tǝwǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ⱨǝrbir axliⱪ ⱨǝdiyǝsi, mǝyli zǝytun meyi arilaxturulƣan bolsun, yaki ⱪuruⱪ kǝltürülgǝn bolsun, bular Ⱨarunning oƣullirining ⱨǝrbirigǝ barawǝr bɵlüp berilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Pǝrwǝrdigarƣa atap kǝltürülgǝn inaⱪliⱪ ⱪurbanliⱪi toƣrisidiki ⱪaidǝ-nizam mundaⱪ: — ");
INSERT INTO uigpin_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Sunmaⱪqi bolƣan kixi uni tǝxǝkkür eytix üqün sunsa, undaⱪta u «tǝxǝkkür ⱪurbanliⱪi» bilǝn billǝ zǝytun meyi ilǝxtürülgǝn petir toⱪaqlar, zǝytun meyi sürülüp mǝsiⱨlǝngǝn petir ⱨǝmǝk nanlar wǝ esil undin zǝytun meyiƣa qilap pixurulƣan toⱪaqlarnimu kǝltürsun.    ");
INSERT INTO uigpin_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Xu toⱪaqlardin baxⱪa, yǝnǝ tǝxǝkkür eytidiƣan inaⱪliⱪ ⱪurbanliⱪi bilǝn billǝ eqitⱪu selinƣan nanlarnimu sunsun; ");
INSERT INTO uigpin_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","u xu sunƣanlirining ⱨǝrbir türidin birni elip Pǝrwǝrdigar üqün ⱪox ⱪollap sunidiƣan «kɵtürmǝ ⱨǝdiyǝ» ⱪilip kǝltürsun; bu inaⱪliⱪ ⱪurbanliⱪining ⱪenini ⱪurbangaⱨning üstigǝ sǝpkǝn kaⱨinning ɵzigǝ tǝgsun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Tǝxǝkkür bildüridiƣan inaⱪliⱪ ⱪurbanliⱪining gɵxi bolsa ⱪurbanliⱪ ⱪilinƣan xu küni yeyilixi kerǝk; ⱪurbanliⱪni sunƣuqi kixi tang atⱪuqǝ uning ⱨeq nemisini ⱪaldurmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Əgǝr uning sunƣan ⱪurbanliⱪi ⱪǝsimigǝ has ⱪurbanliⱪ yaki ihtiyariy kǝltürgǝn ⱪurbanliⱪ bolsa, undaⱪta ⱨaywanning gɵxi ⱪurbanliⱪ ⱪilinƣan kündǝ yeyilsun; uningdin exip ⱪalƣinini bolsa, ǝtisimu yeyixkǝ bolidu; ");
INSERT INTO uigpin_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","lekin ⱪurbanliⱪning gɵxidin üqinqi künigiqǝ exip ⱪalsa, u otta kɵydürülüxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Inaⱪliⱪ ⱪurbanliⱪining gɵxidin üqinqi künidǝ yeyilsǝ, undaⱪta ⱪurbanliⱪ ⱪobul bolmaydu, ⱪurbanliⱪ sunƣuqining ⱨesabiƣimu ⱨesablanmaydu, bǝlki mǝkruⱨ bolidu; kimdǝkim uningdin yesǝ ɵz ⱪǝbiⱨlikining jazasiƣa tartilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Xundaⱪla napak nǝrsigǝ tegip ⱪalƣan gɵxmu yeyilmǝsliki kerǝk, bǝlki otta kɵydürülüxi kerǝk. Ⱨǝrⱪandaⱪ pak adǝm napak nǝrsigǝ tǝgmigǝn ⱪurbanliⱪning gɵxini yesǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Lekin kimki napak ⱨalǝttǝ turup Pǝrwǝrdigarƣa atalƣan inaⱪliⱪ ⱪurbanliⱪidin yesǝ, undaⱪta u ɵz hǝlⱪidin üzüp taxlinidu.    ");
INSERT INTO uigpin_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kimki napak bir nǝrsigǝ tegip kǝtsǝ (mǝyli napak ⱨalǝttiki adǝm bolsun, napak bir ⱨaywan bolsun yaki ⱨǝrⱪandaⱪ napak yirginqlik nǝrsǝ bolsun) wǝ xundaⱪla Pǝrwǝrdigarƣa has atalƣan inaⱪliⱪ ⱪurbanliⱪining gɵxidin yesǝ, undaⱪta u ɵz hǝlⱪidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Israillarƣa mundaⱪ degin: — Silǝr kala, ⱪoy wǝ ɵqkilǝrning meyini ⱨǝrgiz yemǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ɵzlükidin ɵlgǝn yaki yirtⱪuqlar boƣup ⱪoyƣan ⱨaywanning jǝsitining meyini ⱨǝrⱪandaⱪ ixⱪa ixlǝtkili bolidu, lekin ⱨǝrgiz uningdin yemǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Qünki kimki Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱨǝrⱪandaⱪ ⱨaywanning meyini yesǝ, xuni yegǝn kixi ɵz hǝlⱪliridin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Silǝr ⱨǝrⱪandaⱪ turar jayinglarda ⱨeqⱪandaⱪ ⱪanni, yǝni uqar-ⱪanatlarning bolsun yaki qarpaylarning bolsun ⱪenini ⱨǝrgiz estimal ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kimdǝkim ⱨǝrⱪandaⱪ ⱪanni estimal ⱪilsa, xu kixi ɵz hǝlⱪliridin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Israillarƣa mundaⱪ degin: — Kimki Pǝrwǝrdigarƣa atap bir inaⱪliⱪ ⱪurbanliⱪi sunsa, undaⱪta u Pǝrwǝrdigarƣa has bolƣan ⱨǝdiyǝni xu inaⱪliⱪ ⱪurbanliⱪtin ayrip kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ɵz ⱪoli bilǝn Pǝrwǝrdigarƣa atiƣan, otta sunulidiƣan ⱨǝdiyǝlǝrni, yǝni may bilǝn tɵxni ⱪoxup elip kelip, tɵxni «pulanglatma ⱨǝdiyǝ» süpitidǝ Pǝrwǝrdigarning aldida pulanglatsun.    ");
INSERT INTO uigpin_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kaⱨin meyini ⱪurbangaⱨ üstidǝ kɵydürüwǝtsun. Tɵx bolsa Ⱨarun bilǝn uning oƣulliriƣa has bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Inaⱪliⱪ ⱪurbanliⱪliringlarning ong arⱪa putini silǝr «kɵtürmǝ ⱨǝdiyǝ» süpitidǝ kaⱨinƣa beringlar. ");
INSERT INTO uigpin_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ⱨarunning oƣulliridin ⱪaysisi inaⱪliⱪ ⱪurbanliⱪining ⱪeni bilǝn meyini sunƣan bolsa ɵz ülüxi üqün ong arⱪa putini ɵzi alsun. ");
INSERT INTO uigpin_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Qünki Mǝn Israillarning inaⱪliⱪ ⱪurbanliⱪliridin «pulanglatma ⱨǝdiyǝ» bolƣan tɵx bilǝn «kɵtürmǝ ⱨǝdiyǝ» bolƣan arⱪa putini ǝbǝdiy bir bǝlgilimǝ bilǝn Israillardin elip, kaⱨin Ⱨarun wǝ uning oƣullirining ⱨǝⱪⱪi bolsun dǝp ularƣa tǝⱪdim ⱪildim.    ");
INSERT INTO uigpin_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Musa Ⱨarun bilǝn oƣullirini Pǝrwǝrdigarning ⱪulluⱪida kaⱨin boluxⱪa uning aldiƣa kǝltürgǝn künidǝ, ularƣa Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱪurbanliⱪlardin tǝⱪdim ⱪilinidiƣan kaⱨinliⱪ ülüxi mana xudur. ");
INSERT INTO uigpin_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Musa ularni mǝsiⱨligǝn künidǝ, Pǝrwǝrdigar bu ülüxni Israillardin elip ularƣa berilsun dǝp ǝmr ⱪilƣan. Bu Israillarƣa dǝwrdin dǝwrgiqǝ ǝbǝdiy bir bǝlgilimǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Kɵydürmǝ ⱪurbanliⱪ bilǝn axliⱪ ⱨǝdiyǝsi, gunaⱨ ⱪurbanliⱪi bilǝn itaǝtsizlik ⱪurbanliⱪi, kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪi bilǝn inaⱪliⱪ ⱪurbanliⱪi toƣrisidiki ⱪaidǝ-nizam mana xudur. ");
INSERT INTO uigpin_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Pǝrwǝrdigar Israillarƣa: «Silǝr bu Sinay bayawanida Pǝrwǝrdigarning aldiƣa ⱪurbanliⱪliringlarni sununglar» dǝp buyruƣan künidǝ, u bularning ⱨǝmmisini Sinay teƣida Musaƣa tapxurƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Ⱨarunni oƣulliri bilǝn billǝ, wǝ ularning mǝhsus kiyimlirini, «mǝsiⱨlǝx meyi»ni, gunaⱨ ⱪurbanliⱪi bolidiƣan torpaⱪ bilǝn ikki ⱪoqⱪarni, petir nan selinƣan sewǝtni elip kelip,    ");
INSERT INTO uigpin_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Israilning pütün jamaitini jamaǝt qedirining kirix aƣzining aldiƣa jǝm ⱪilƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa Pǝrwǝrdigar uningƣa buyruƣinidǝk ⱪildi, jamaǝt jamaǝt qedirining kirix aƣzining aldiƣa yiƣildi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Andin Musa jamaǝtkǝ: — Pǝrwǝrdigar buyruƣan ix mana mundaⱪ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Xuning bilǝn Musa Ⱨarun bilǝn uning oƣullirini aldiƣa kǝltürüp ularni su bilǝn yuyup, ");
INSERT INTO uigpin_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ⱨarunƣa kɵnglǝk kiydürüp, bǝlwaƣ baƣlap, tonni kiydürdi wǝ üstigǝ ǝfodni yapti; u ǝfodning bǝlweƣini baƣlap, ǝfodni uningƣa taⱪap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Andin Musa uningƣa «ⱪoxen»ni taⱪap, ⱪoxenning iqigǝ «urim bilǝn tummim»ni selip,    ");
INSERT INTO uigpin_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Bexiƣa sǝllǝ yɵgǝp Pǝrwǝrdigar uningƣa buyruƣinidǝk sǝllining aldi tǝripigǝ «altun tahtiliⱪ muⱪǝddǝs otuƣat»ni bekitip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Andin Musa mǝsiⱨlǝx meyini elip ibadǝt qediri bilǝn iqidiki barliⱪ nǝrsilǝrning ⱨǝmmisini mǝsiⱨlǝp muⱪǝddǝs ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","U maydin elip ⱪurbangaⱨⱪa yǝttǝ mǝrtiwǝ qeqip, ⱪurbangaⱨ bilǝn uning barqǝ ⱪaqa-ⱪuqilirini, yuyunux desi wǝ tǝglikini Hudaƣa atap muⱪǝddǝs ⱪilixⱪa mǝsiⱨlidi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","U yǝnǝ mǝsiⱨlǝx meyidin azraⱪ elip Ⱨarunning bexiƣa ⱪuyup uni Hudaƣa atap muⱪǝddǝs ⱪilixⱪa mǝsiⱨlidi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Andin Musa Ⱨarunning oƣullirini aldiƣa kǝltürüp, Pǝrwǝrdigar uningƣa buyruƣinidǝk ularƣa kɵnglǝk kiydürüp, bǝllirigǝ bǝlwaƣ baƣlap, ularƣa egiz bɵklǝrnimu taⱪap ⱪoydi.    ");
INSERT INTO uigpin_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Andin u gunaⱨ ⱪurbanliⱪi ⱪilinidiƣan torpaⱪni yetilǝp kǝldi; Ⱨarun bilǝn uning oƣulliri gunaⱨ ⱪurbanliⱪi ⱪilinidiƣan torpaⱪning bexiƣa ⱪollirini ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","U uni boƣuzlidi, andin Musa ⱪenidin elip, ɵz barmiⱪi bilǝn ⱪurbangaⱨning münggüzlirigǝ, qɵrisigǝ sürüp ⱪurbangaⱨni gunaⱨtin paklidi; ⱪalƣan ⱪanni bolsa u ⱪurbangaⱨning tüwigǝ tɵküp, muⱪǝddǝs boluxⱪa kǝfarǝt kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Andin u iq ⱪarnini yɵgǝp turƣan mayning ⱨǝmmisini, jigǝrning üstidiki qawa mayni, ikki bɵrǝk wǝ üstidiki maylirini ⱪoxup aldi; andin Musa bularni ⱪurbangaⱨning üstidǝ kɵydürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Biraⱪ Musa torpaⱪning terisi bilǝn gɵxi wǝ tezikini bolsa Pǝrwǝrdigar ɵzigǝ buyruƣinidǝk qedirgaⱨning taxⱪirida otta kɵydürüwǝtti.    ");
INSERT INTO uigpin_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Andin u kɵydürmǝ ⱪurbanliⱪ ⱪilinidiƣan ⱪoqⱪarni kǝltürdi; Ⱨarun bilǝn uning oƣulliri ⱪollirini ⱪoqⱪarning bexiƣa ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ⱨarun ⱪoqⱪarni boƣuzlidi; andin Musa ⱪenini elip ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpti; ");
INSERT INTO uigpin_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ⱨarun ⱪoqⱪarni parqǝ-parqǝ ⱪilip parqilidi; andin Musa bexini, parqilanƣan gɵxlirini barliⱪ meyi bilǝn ⱪoxup kɵydürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Üqǝy-ⱪerinliri bilǝn paqaⱪlirini suda yudi. Andin Musa ⱪoqⱪarni pütün peti ⱪurbangaⱨ üstidǝ kɵydürdi. Bu Pǝrwǝrdigar Musaƣa buyruƣan, «Pǝrwǝrdigarƣa atap otta sunulidiƣan huxbuy qiⱪidiƣan ⱪurbanliⱪ» idi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Andin u kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪi ⱪilinidiƣan ⱪoqⱪarni, ikkinqi ⱪoqⱪarni kǝltürdi; Ⱨarun bilǝn uning oƣulliri ⱪollirini ⱪoqⱪarning bexiƣa ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","U uni boƣuzlidi; wǝ Musa uning ⱪenidin elip Ⱨarunning ong ⱪuliⱪining yumxiⱪi bilǝn ong ⱪolining bax barmiⱪiƣa sürüp wǝ ong putining qong barmiⱪiƣimu suwap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Andin Musa Ⱨarunning oƣullirini aldiƣa kǝltürüp, ⱪandin elip ularning ong ⱪulaⱪlirining yumxiⱪi bilǝn ong ⱪollirining bax barmaⱪliriƣa sürdi, ularning ong putlirining qong barmaⱪliriƣimu suwap ⱪoydi, ⱪalƣan ⱪanni Musa ⱪurbangaⱨning qɵrisigǝ sǝpti. ");
INSERT INTO uigpin_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Xundaⱪ ⱪilip, u meyi bilǝn mayliⱪ ⱪuyruⱪini, iq ⱪarnini yɵgǝp turƣan barliⱪ may bilǝn jigǝrning üstidiki qawa meyini, ikki bɵrǝk wǝ üstidiki maylirini ⱪoxup elip ong arⱪa putinimu kesip elip, ");
INSERT INTO uigpin_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Pǝrwǝrdigarning aldidiki petir nan selinƣan sewǝttin bir petir toⱪaq bilǝn bir zǝytun may toⱪiqi wǝ bir danǝ ⱨǝmǝk nanni elip bularni may bilǝn ong arⱪa putning üstidǝ ⱪoydi; ");
INSERT INTO uigpin_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","andin bularning ⱨǝmmisini Ⱨarun bilǝn uning oƣullirining ⱪolliriƣa tutⱪuzup, pulanglatma ⱨǝdiyǝ bolsun dǝp Pǝrwǝrdigarning aldida pulanglatti. ");
INSERT INTO uigpin_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Andin Musa bularni ularning ⱪolliridin elip ⱪurbangaⱨtiki kɵydürmǝ ⱪurbanliⱪning üstidǝ ⱪoyup kɵydürdi. Bu «kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪi» bolup, Pǝrwǝrdigarƣa atap otta sunulidiƣan, huxbuy qiⱪidiƣan ⱪurbanliⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Andin Musa tɵxni elip pulanglatma ⱨǝdiyǝ süpitidǝ Pǝrwǝrdigarning aldida pulanglatti; Pǝrwǝrdigarning uningƣa buyruƣini boyiqǝ, «kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪi» bolƣan ⱪoqⱪarning bu ⱪismi Musaning ülüxi idi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Andin Musa mǝsiⱨlǝx meyidin wǝ ⱪurbangaⱨning üstidiki ⱪandin bir’az elip, Ⱨarun bilǝn uning kiyimlirigǝ wǝ oƣulliri bilǝn ularning kiyimlirigǝ sǝpti. Xundaⱪ ⱪilip, u Ⱨarun wǝ kiyimlirini, oƣulliri bilǝn ularning kiyimlirini muⱪǝddǝs ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa Ⱨarun bilǝn uning oƣulliriƣa mundaⱪ buyrudi: — «Bu gɵxni jamaǝt qedirining kirix aƣzida ⱪaynitip pixurup xu yǝrdǝ olturup «kaⱨinliⱪⱪa tiklǝx ⱪurbanliⱪi»ƣa tǝwǝ bolƣan sewǝttiki nan bilǝn ⱪoxup yǝnglar; bularni Ⱨarun bilǝn oƣulliri yesun, dǝp buyruƣinimdǝk uni yǝnglar; ");
INSERT INTO uigpin_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","lekin gɵx bilǝn nandin exip ⱪalƣanlirining ⱨǝmmisini otta kɵydürüwetinglar. ");
INSERT INTO uigpin_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Silǝr yǝttǝ küngiqǝ jamaǝt qedirining kirix aƣzidin qiⱪmay, Hudaƣa atap kaⱨinliⱪⱪa tiklǝx künliringlar toxⱪuqǝ xu yǝrdǝ turunglar; qünki silǝrni Hudaƣa atap kaⱨinliⱪⱪa tiklǝx üqün yǝttǝ kün ketidu. ");
INSERT INTO uigpin_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Bügün ⱪilinƣan ixlar Pǝrwǝrdigarning buyruƣini boyiqǝ silǝr üqün kǝfarǝt kǝltürülsun dǝp ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Silǝr ɵlmǝslikinglar üqün Pǝrwǝrdigarning ǝmrini tutup jamaǝt qedirining kirix aƣzining aldida keqǝ-kündüz yǝttǝ kün turuxunglar kerǝk; qünki manga xundaⱪ buyruldi». ");
INSERT INTO uigpin_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ⱨarun bilǝn oƣulliri Pǝrwǝrdigarning Musaning wasitisi bilǝn buyruƣinining ⱨǝmmisini bǝja kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sǝkkizinqi küni Musa Ⱨarun bilǝn uning oƣulliri wǝ Israilning aⱪsaⱪallirini qaⱪirip, ");
INSERT INTO uigpin_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ⱨarunƣa mundaⱪ dedi: — «Sǝn gunaⱨ ⱪurbanliⱪiƣa bejirim bir mozayni, kɵydürmǝ ⱪurbanliⱪⱪa bejirim bir ⱪoqⱪarni ɵzüng üqün elip, Pǝrwǝrdigarning aldiƣa kǝltürgin, ");
INSERT INTO uigpin_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","andin Israillarƣa sɵz ⱪilip: — Silǝr gunaⱨ ⱪurbanliⱪi üqün bir tekǝ elip kelinglar, kɵydürmǝ ⱪurbanliⱪ üqün bir mozay wǝ bir ⱪoza elip kelinglar, ⱨǝr ikkisi bejirim, bir yaxⱪa kirgǝn bolsun; ");
INSERT INTO uigpin_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Pǝrwǝrdigarning aldida sunuxⱪa inaⱪliⱪ ⱪurbanliⱪi süpitidǝ bir torpaⱪ bilǝn bir ⱪoqⱪarni elip, zǝytun meyi ilǝxtürülgǝn axliⱪ ⱨǝdiyǝsi bilǝn billǝ kǝltürünglar; qünki bügün Pǝrwǝrdigar Ɵzini silǝrgǝ ayan ⱪilidu, degin». ");
INSERT INTO uigpin_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ular Musa buyruƣan nǝrsilǝrni jamaǝt qedirining aldiƣa elip kǝldi; pütkül jamaǝt yeⱪin kelip, Pǝrwǝrdigarning aldida ⱨazir bolup turdi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa: — Mana, bu Pǝrwǝrdigar buyruƣan ixtur; buni ⱪilsanglar Pǝrwǝrdigarning xan-xǝripi silǝrgǝ ayan bolidu, dedi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Xuning bilǝn Musa Ⱨarunƣa: — Sǝn ⱪurbangaⱨⱪa yeⱪin berip gunaⱨ ⱪurbanliⱪing bilǝn kɵydürmǝ ⱪurbanliⱪingni sunup ɵzüng wǝ hǝlⱪ üqün kǝfarǝt kǝltürgin; andin hǝlⱪning ⱪurbanliⱪinimu sunup, Pǝrwǝrdigar ǝmr ⱪilƣandǝk ular ⱨǝⱪⱪidǝ kǝfarǝt kǝltürgin» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Xuni dewidi, Ⱨarun ⱪurbangaⱨⱪa yeⱪin berip ɵzi üqün gunaⱨ ⱪurbanliⱪi bolidiƣan mozayni boƣuzlidi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ⱨarunning oƣulliri ⱪanni uningƣa sunup bǝrdi; u barmiⱪini ⱪanƣa tǝgküzüp, ⱪurbangaⱨning münggüzlirigǝ sürdi, ⱪalƣan ⱪanni ⱪurbangaⱨning tüwigǝ ⱪuydi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Gunaⱨ ⱪurbanliⱪining meyi bilǝn ikki bɵrǝk wǝ jigǝrning üstidiki qawa mayni elip, Pǝrwǝrdigar Musaƣa buyruƣinidǝk ularni ⱪurbangaⱨ üstidǝ kɵydürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Gɵx bilǝn terisini bolsa qedirgaⱨning taxⱪiriƣa elip qiⱪip otta kɵydürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Andin u kɵydürmǝ ⱪurbanliⱪ ⱪilidiƣan ⱪoqⱪarni boƣozlidi; Ⱨarunning oƣulliri uningƣa ⱪanni sunup bǝrdi; u buni ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpti. ");
INSERT INTO uigpin_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Andin ular parqǝ-parqǝ ⱪilinƣan kɵydürmǝ ⱪurbanliⱪni bexi bilǝn billǝ uningƣa sunup bǝrdi; u bularni ⱪurbangaⱨta kɵydürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","U iq ⱪarni bilǝn paqaⱪlirini yuyup, bularnimu ⱪurbangaⱨning üstidǝ, kɵydürmǝ ⱪurbanliⱪning üstigǝ ⱪoyup kɵydürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Andin u hǝlⱪning ⱪurbanliⱪini kǝltürdi; hǝlⱪning gunaⱨ ⱪurbanliⱪi bolƣan tekini boƣuzlap, ilgiri ⱨaywanni sunƣandǝk unimu gunaⱨ ⱪurbanliⱪi ⱪilip sundi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","U kɵydürmǝ ⱪurbanliⱪ ⱪilidiƣan malni kǝltürüp bunimu bǝlgilimǝ boyiqǝ sundi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Andin u axliⱪ ⱨǝdiyǝsini kǝltürüp uningdin bir qanggal elip ǝtigǝnlik kɵydürmǝ ⱪurbanliⱪⱪa ⱪoxup ⱪurbangaⱨ üstidǝ kɵydürdi.    ");
INSERT INTO uigpin_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Andin hǝlⱪⱪǝ bolidiƣan inaⱪliⱪ ⱪurbanliⱪi bolidiƣan torpaⱪ bilǝn ⱪoqⱪarni boƣuzlidi. Ⱨarunning oƣulliri ⱪenini uningƣa sunup bǝrdi; u buni ⱪurbangaⱨning üsti ⱪismining ǝtrapiƣa sǝpti. ");
INSERT INTO uigpin_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ular torpaⱪ bilǝn ⱪoqⱪarning may ⱪismini, yǝni mayliⱪ ⱪuyruⱪi, iq ⱪarnini yɵgǝp turƣan maylirini, ikki bɵrǝk wǝ jigǝrning qawa meyini elip, ");
INSERT INTO uigpin_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Bu may parqilirini ikki tɵxning üstidǝ ⱪoydi, Ⱨarun bularni ⱪurbangaⱨning üstidǝ kɵydürdi. ");
INSERT INTO uigpin_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Ahirida Ⱨarun ikki tɵx bilǝn ong arⱪa putini pulanglatma ⱨǝdiyǝ süpitidǝ Musaning buyruƣinidǝk Pǝrwǝrdigarning aldida pulanglatti. ");
INSERT INTO uigpin_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Andin Ⱨarun ⱪollirini hǝlⱪⱪǝ ⱪaritip kɵtürüp, ularƣa bǝht tilidi; u gunaⱨ ⱪurbanliⱪi, kɵydürmǝ ⱪurbanliⱪ wǝ inaⱪliⱪ ⱪurbanliⱪini sunup, ⱪurbangaⱨtin qüxti. ");
INSERT INTO uigpin_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa bilǝn Ⱨarun jamaǝt qediriƣa kirip, yǝnǝ yenip qiⱪip hǝlⱪⱪǝ bǝht tilidi; xuning bilǝn Pǝrwǝrdigarning xan-xǝripi pütkül hǝlⱪⱪǝ ayan boldi; ");
INSERT INTO uigpin_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Pǝrwǝrdigarning aldidin ot qiⱪip, ⱪurbangaⱨ üstidiki kɵydürmǝ ⱪurbanliⱪ bilǝn maylarni yutup kǝtti. Pütkül hǝlⱪ buni kɵrüp, towlixip, düm yiⱪilixti. ");
INSERT INTO uigpin_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ⱨarunning oƣulliri Nadab bilǝn Abiⱨu ikkisi ɵz huxbuydanini elip uningƣa ot yeⱪip üstigǝ huxbuyni selip, Pǝrwǝrdigar ularƣa buyrup baⱪmiƣan ƣǝyriy bir otni Pǝrwǝrdigarƣa sundi; ");
INSERT INTO uigpin_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","xuning bilǝn Pǝrwǝrdigarning aldidin ot qiⱪip ularni yǝwǝtti; xuan ular Pǝrwǝrdigarning aldida ɵldi. ");
INSERT INTO uigpin_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa Ⱨarunƣa: — Mana, bu Pǝrwǝrdigarning: «Mǝn Manga yeⱪin kǝlgǝn adǝmlǝrdǝ Ɵzümning muⱪǝddǝs ikǝnlikimni kɵrsitimǝn wǝ barliⱪ hǝlⱪning aldida uluƣlinimǝn» degǝn sɵzining ɵzidur, dedi. Xuni dewidi, Ⱨarun jim turup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa Ⱨarunning taƣisi Uzziǝlning oƣulliri bolƣan Mixaǝl bilǝn Əlzafanni qaⱪirip ularƣa: — Silǝr yeⱪin kelip ɵz ⱪerindaxliringlarni muⱪǝddǝs jayning aldidin kɵtürüp, qedirgaⱨning taxⱪiriƣa elip qiⱪinglar» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Xuning bilǝn ular yeⱪin kelip, ularni kiyiklik kɵnglǝkliri bilǝn kɵtürüp Musaning buyruƣinidǝk qedirgaⱨning taxⱪiriƣa elip qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa Ⱨarun wǝ oƣulliri Əliazar bilǝn Itamarƣa: — Silǝr baxliringlarni oquⱪ ⱪoymanglar, kiyimliringlarni yirtmanglar; bolmisa ɵzünglar ɵlüp, pütkül jamaǝtkǝ ƣǝzǝp kǝltürisilǝr; lekin ⱪerindaxliringlar bolƣan pütkül Israil jǝmǝti Pǝrwǝrdigar yaⱪⱪan ot tüpǝylidin matǝm tutup yiƣlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Əmma silǝr bolsanglar Pǝrwǝrdigarning mǝsiⱨlǝx meyi üstünglarƣa sürülgǝn bolƣaqⱪa, jamaǝt qedirining taxⱪiriƣa qiⱪmanglar; bolmisa ɵlisilǝr, dedi. Xuni dewidi, ular Musaning buyruƣinidǝk ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Pǝrwǝrdigar Ⱨarunƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Sǝn ɵzüng wǝ oƣulliring xarab wǝ ya baxⱪa küqlük ⱨaraⱪlarni iqip, jamaǝt qediriƣa ⱨǝrgiz kirmǝnglar; bolmisa, ɵlüp ketisilǝr. Bu silǝr üqün dǝwrdin-dǝwrgǝ ǝbǝdiy bir bǝlgilimǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Xundaⱪ ⱪilsanglar, muⱪǝddǝs bilǝn adǝttikini, pak bilǝn napakni pǝrⱪ etip ajritalaydiƣan bolisilǝr; ");
INSERT INTO uigpin_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","xundaⱪla Pǝrwǝrdigar Musaning wasitisi bilǝn Israillarƣa tapxurƣan ⱨǝmmǝ bǝlgilimilǝrni ularƣa ɵgitǝlǝysilǝr». ");
INSERT INTO uigpin_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa Ⱨarun wǝ uning tirik ⱪalƣan oƣulliri Əliazar bilǝn Itamarƣa mundaⱪ dedi: — «Silǝr Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱪurbanliⱪ-ⱨǝdiyǝlǝrdin exip ⱪalƣan axliⱪ ⱨǝdiyǝsini elip uni ⱪurbangaⱨning yenida eqitⱪu arilaxturmiƣan ⱨalda yǝnglar; qünki u «ǝng muⱪǝddǝslǝrning biri» ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Bu Pǝrwǝrdigarƣa atap otta sunulidiƣan nǝrsilǝrdin sening nesiwǝng wǝ oƣulliringning nesiwisi bolƣaqⱪa, uni muⱪǝddǝs jayda yeyixinglar kerǝk; qünki manga xundaⱪ buyrulƣandur. ");
INSERT INTO uigpin_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Uningdin baxⱪa pulanglatma ⱨǝdiyǝ ⱪilinƣan tɵx bilǝn kɵtürmǝ ⱨǝdiyǝ ⱪilinƣan arⱪa putni sǝn wǝ oƣul-ⱪizliring billǝ pak bir jayda yǝnglar; qünki bular sening nesiwǝng bilǝn oƣulliringning nesiwisi bolsun dǝp, Israillarning inaⱪliⱪ ⱪurbanliⱪliridin silǝrgǝ berilgǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ular kɵtürmǝ ⱨǝdiyǝ ⱪilinƣan arⱪa put bilǝn pulanglatma ⱨǝdiyǝ ⱪilinƣan tɵxni otta sunulidiƣan mayliri bilǝn ⱪoxup, Pǝrwǝrdigarning aldida pulanglatma ⱨǝdiyǝ süpitidǝ pulanglitix üqün kǝltürsun; Pǝrwǝrdigarning buyruƣini boyiqǝ bular sening wǝ oƣulliringning nesiwisi bolidu; bu ǝbǝdiy bir bǝlgilimǝ bolidu». ");
INSERT INTO uigpin_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Andin Musa gunaⱨ ⱪurbanliⱪi ⱪilidiƣan tekini izdiwidi, mana u alliⱪaqan kɵydürülüp bolƣanidi. Bu sǝwǝbtin u Ⱨarunning tirik ⱪalƣan ikki oƣli Əliazar bilǝn Itamarƣa aqqiⱪlinip: ");
INSERT INTO uigpin_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","— Nemixⱪa silǝr gunaⱨ ⱪurbanliⱪining gɵxini muⱪǝddǝs jayda yemidinglar? Qünki u «ǝng muⱪǝddǝslǝrning biri» ⱨesablinatti, Pǝrwǝrdigar silǝrni jamaǝtning gunaⱨini kɵtürüp ular üqün uning aldida kǝfarǝt kǝltürsun dǝp, xuni silǝrgǝ tǝⱪsim ⱪilƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Mana, uning ⱪeni muⱪǝddǝs jayning iqigǝ kǝltürülmidi; silǝr ǝslidǝ mǝn buyruƣandǝk uni muⱪǝddǝs jayda yeyixinglar kerǝk idi, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Lekin Ⱨarun Musaƣa: — Mana, bular bügün toƣra ix ⱪilip ɵzlirining gunaⱨ ⱪurbanliⱪi bilǝn kɵydürmǝ ⱪurbanliⱪini Pǝrwǝrdigarning aldida sundi; mening beximƣa xu ixlar kǝldi; ǝgǝr mǝn bügün gunaⱨ ⱪurbanliⱪining gɵxini yegǝn bolsam, Pǝrwǝrdigarning nǝziridǝ obdan bolattimu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa buni anglap jawabidin razi boldi. ");
INSERT INTO uigpin_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Israillarƣa mundaⱪ degin: — Yǝr yüzidiki barliⱪ ⱨaywanlarning iqidin silǝrgǝ yeyixkǝ bolidiƣan janiwarlar xuki: — ");
INSERT INTO uigpin_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Ⱨaywanlar iqidǝ ⱨǝm tuyaⱪliri pütün aqimaⱪ (tuyaⱪliri pütünlǝy yeriⱪ) ⱨǝm kɵxigüqi ⱨaywanlarning ⱨǝrbirini yesǝnglar bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Lekin kɵxigüqi yaki aqimaⱪ tuyaⱪliⱪ ⱨaywanlardin tɵwǝndikilǝrni yemǝslikinglar kerǝk: — Tɵgǝ: qünki u kɵxigini bilǝn tuyiⱪi aqimaⱪ ǝmǝs. Xunga u silǝrgǝ ⱨaram bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Suƣur bolsa kɵxigini bilǝn tuyiⱪi aqimaⱪ ǝmǝs — u silǝrgǝ ⱨaram bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Toxⱪan bolsa bumu kɵxigini bilǝn tuyiⱪi aqimaⱪ ǝmǝs — u silǝrgǝ ⱨaram bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Qoxⱪa bolsa tuyaⱪliri aqimaⱪ (tuyaⱪliri pütünlǝy yeriⱪ) bolƣini bilǝn kɵximigini üqün silǝrgǝ ⱨaram bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Silǝr xu ⱨaywanlarning gɵxidin yemǝslikinglar kerǝk wǝ ularning ɵlükigimu tǝgmǝnglar. Ular bolsa silǝrgǝ ⱨaram bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Suda yaxaydiƣan janiwarlardin tɵwǝndikilǝrni yeyixkǝ bolidu: — sudiki, yǝni dǝrya-dengizlardiki janiwarlardin ⱪaniti wǝ ⱪasiraⱪliri bolƣanlarni yeyixkǝ bolidu; ");
INSERT INTO uigpin_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","lekin dǝrya-dengizlarda yaxaydiƣan, yǝni sularda top-top üzidiƣan barliⱪ janiwarlardin, ⱪasiraⱪliri yaki ⱪaniti bolmiƣanlirini yemǝslikinglar kerǝk; ular silǝrgǝ yirginqlik sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Mǝzkur janiwarlar dǝrwǝⱪǝ silǝrgǝ yirginqlik sanalsun; silǝr ularning gɵxidin yemǝslikinglar kerǝk; ularning ɵlükini yirginqlik dǝp ⱪaranglar. ");
INSERT INTO uigpin_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Sudiki janiwarlarning iqidin ⱪaniti bilǝn ⱪasiriⱪi bolmiƣan janiwarlarning ⱨǝmmisi silǝrgǝ yirginqlik sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Uqar-ⱪanatlardin tɵwǝndikilǝr silǝrgǝ yirginqliktur; ular yeyilmǝsliki kerǝk wǝ silǝrgǝ yirginqlik bolsun: — yǝni bürküt, ⱪorultaz-tapⱪuxlar, dengiz bürküti, ");
INSERT INTO uigpin_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ⱪarliƣaq ⱪuyruⱪluⱪ sar, laqin wǝ ularning hilliri, ");
INSERT INTO uigpin_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ⱨǝmmǝ ⱪaƣa-ⱪozƣunlar wǝ ularning hilliri, ");
INSERT INTO uigpin_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","müxükyapilaⱪ, tɵgiⱪux, qayka, sar wǝ ularning hilliri, ");
INSERT INTO uigpin_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ⱨuwⱪux, ⱪarna, ibis, ");
INSERT INTO uigpin_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","aⱪⱪu, saⱪiyⱪux, beliⱪ’alƣuq, ");
INSERT INTO uigpin_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","lǝylǝk, turna wǝ uning hilliri, ⱨɵpüp wǝ xǝpǝrǝng ⱪatarliⱪlar silǝrgǝ ⱨaram sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Buningdin baxⱪa tɵt putlap mangidiƣan, uqidiƣan uxxaⱪ janiwarlarning ⱨǝmmisi silǝrgǝ yirginqlik bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ⱨalbuki, tɵt putlap mangidiƣan, uqidiƣan uxxaⱪ janiwarlardin tɵwǝndikilǝrni yesǝnglar bolidu: — puti bilǝn ügilik paqiⱪi bolup, yǝr yüzidǝ sǝkriyǝlǝydiƣanlarni yesǝnglar bolidu; ");
INSERT INTO uigpin_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","bularning iqidin silǝrgǝ yeyixkǝ bolidiƣanliri: — qekǝtkǝ wǝ uning hilliri, ⱪara qekǝtkǝ wǝ uning hilliri, tomuzƣa wǝ uning hilliri, qaⱪqiⱪiz wǝ uning hilliri. ");
INSERT INTO uigpin_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Lekin tɵt putluⱪ bolƣan ɵmiligüqi ⱨǝm uqidiƣan ⱨǝmmǝ baxⱪa janiwarlar silǝrgǝ yirginqlik sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Bu janiwarlardinmu mundaⱪ yol bilǝn napak bolisilǝr; birkim ularning ɵlük tenigǝ tǝgsǝ kǝq kirgüqǝ napak ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Kimdǝkim bularning ɵlükining bir ⱪismini kɵtürsǝ ɵz kiyimlirini yuyuxi kerǝk, u kixi kǝq kirgüqǝ napak ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Tuyaⱪliri aqimaⱪ, biraⱪ pütünlǝy bɵlünmigǝn yaki kɵximǝydiƣan ⱨaywanlarning ⱨǝmmisi silǝrgǝ ⱨaramdur; ⱨǝrkim ularning ɵlükigǝ tǝgsǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Tɵt puti bilǝn mangidiƣan ⱨaywanlarning iqidin tapini bilǝn mangidiƣanlarning ⱨǝmmisi silǝrgǝ napak bolup, ⱨǝrkim ularning ɵlük tǝnlirigǝ tǝgsǝ kǝq kirgüqǝ napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Kimki ularning ɵlükini kɵtürsǝ ɵz kiyimlirini yuyuxi kerǝk, u kixi kǝq kirgüqǝ napak turidu. Bu ⱨaywanlar bolsa silǝrgǝ ⱨaram bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Yǝr yüzidǝ ɵmiligüqi uxxaⱪ janiwarlarning iqidin silǝrgǝ ⱨaram bolƣanlar munular: — ⱪariƣu zokor, qaxⱪan, kǝslǝnqük wǝ ularning türliri, ");
INSERT INTO uigpin_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","salma, ⱪizil kǝslǝnqük, tam kǝslǝnqüki, tügürük kǝslǝnqük wǝ hameleon ⱪatarliⱪlar ⱨaram bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Bularning ⱨǝmmisi yǝr yüzidǝ ɵmiligüqi ⱨǝmmǝ uxxaⱪ janiwarlarning iqidǝ silǝrgǝ ⱨaram bolidu; ularning ɵlükigǝ tǝgsǝ, kǝq kirgüqǝ napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Bu janiwarlarning ɵlüki ⱨǝrⱪandaⱪ nemigǝ qüxüp ⱪalsa xu nemǝ napak ⱨesablinidu — ⱨǝrⱪandaⱪ yaƣaq ⱪaqa-ⱪuqa bolsun, kiyim bolsun, terǝ bolsun, taƣar bolsun, ⱨǝrⱪandaⱪ ixⱪa ixlitilidiƣan ǝswab bolsun, suƣa qilinixi kerǝk; ular kǝq kirgüqǝ napak sanilip, keyin pak bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Bularning biri sapaldin yasalƣan ⱨǝrⱪandaⱪ ⱪaqa iqigǝ qüxüp ⱪalsa, xu ⱪaqa iqidiki ⱨǝmmǝ nǝrsǝ napak sanalsun wǝ ⱪaqa ɵzi sundurulsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Əgǝr ⱪaqidiki sudin ax-taam üstigǝ qaqrap kǝtsǝ, ax-taam napak sanalsun wǝ xundaⱪla ⱪaqidiki ⱨǝrⱪandaⱪ iqimlikmu napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ⱨǝrnemigǝ undaⱪ ɵlükning birǝr ⱪismi qüxüp ⱪalsimu, napak sanalsun. Əgǝr tonur wǝ oqaⱪ bolsa, napak boldi dǝp qeⱪiwetilsun; ular silǝrgǝ ⱨaram bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Lekin xundaⱪ ǝⱨwalda bulaⱪ yaki su yiƣilidiƣan kɵlqǝk yǝnila pak sanilidu; ǝmma birkim ularning ɵlük tenigǝ tǝgsǝ napak bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Əgǝr undaⱪ ɵlükning birǝr ⱪismi terixⱪa tǝyyarlanƣan danlarƣa qüxüp ⱪalsa, bumu yǝnila pak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Lekin ǝgǝr danning üstigǝ su ⱪuyulƣandin keyin xundaⱪ bir ɵlükning birǝr ⱪismi qüxüp ⱪalsa, undaⱪta bu danlar silǝrgǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Əgǝr silǝrgǝ yeyixkǝ bolidiƣan ⱨaywanlardin biri ɵlüp ⱪalsa, uning ɵlükigǝ tǝgkǝn kixi kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Kimki undaⱪ ɵlükning gɵxidin yesǝ, ɵz kiyimlirini yuyuxi kerǝk wǝ kǝq kirgüqǝ napak sanalsun; xundaⱪla undaⱪ bir ɵlükni kɵtürgǝn kiximu kiyimlirini yuyuxi kerǝk wǝ u kixi kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Yǝr yüzidǝ ɵmiligüqi ⱨǝmmǝ uxxaⱪ janiwarlar yirginqlik sanilip, ⱨǝrgiz yeyilmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ⱪorsiⱪi bilǝn beƣirlap mangidiƣan janiwar bolsun, yǝr yüzidǝ yürüp tɵt puti bilǝn yaki kɵp putliri bilǝn mangidiƣan ɵmiligüqi janiwarlarning ⱨǝrtürlükini bolsa, ularni ⱨǝrgiz yemǝnglar; qünki ular yirginqliktur. ");
INSERT INTO uigpin_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Silǝr bolsanglar mundaⱪ ɵmiligüqi janiwarning sǝwǝbidin ɵzünglarni yirginqlik ⱪilmasliⱪinglar kerǝk. Ɵzünglarni ular tüpǝylidin napak ⱪilmanglar, bolmisa ularning sǝwǝbidin bulƣinip ⱪalisilǝr; ");
INSERT INTO uigpin_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","qünki Mǝn Hudayinglardurmǝn. Silǝr ɵzünglarni Ɵzümgǝ atap muⱪǝddǝs ⱪilixinglar kerǝk; Mǝn Ɵzüm muⱪǝddǝs bolƣaq silǝrmu ɵzünglarni muⱪǝddǝs tutuxunglar kerǝk. Silǝr ɵzünglarni yǝr yüzidǝ ɵmiligüqi uxxaⱪ ⱨǝrⱪandaⱪ janiwarlarning sǝwǝbidin napak ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Qünki Mǝn ɵz Hudayinglar boluxⱪa silǝrni Misir zeminidin qiⱪirip kǝlgǝn Pǝrwǝrdigardurmǝn; silǝr muⱪǝddǝs bolunglar, qünki Mǝn muⱪǝddǝsturmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Xular bolsa qarpay bilǝn uqar-ⱪanatlar, suda yüridiƣan ⱨǝrbir janiwar bilǝn yǝr yüzidǝ ɵmiligüqi ⱨǝrbir uxxaⱪ janiwarlar toƣrisidiki ⱪanun-bǝlgilimidur. ");
INSERT INTO uigpin_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Bular bilǝn ⱨaram-ⱨalalni uⱪup, yeyixkǝ bolidiƣan ⱨaywan bilǝn yeyixkǝ bolmaydiƣan ⱨaywanlarni pǝrⱪ etǝlǝysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Israillarƣa sɵz ⱪilip mundaⱪ degin: — «Ayal kixi ⱨamilidar bolup oƣul tuƣsa, adǝt kɵrüp aƣriⱪ bolƣan künliridikidǝk yǝttǝ küngiqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sǝkkizinqi küni oƣli bolsa hǝtnǝ ⱪilinsun.    ");
INSERT INTO uigpin_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ayal bolsa xuningdin keyin ottuz üq küngiqǝ «ⱪan paklinix»ta tursun; paklinix künliri tamam bolmiƣuqǝ ⱨeqbir muⱪǝddǝs nǝrsigǝ tǝgmisun, muⱪǝddǝs jayƣimu kirmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Əgǝr u ⱪiz tuƣsa undaⱪta adǝt künliridikidǝk ikki ⱨǝptigiqǝ napak turup, andin atmix altǝ küngiqǝ «ⱪan paklinix»ta tursun. ");
INSERT INTO uigpin_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Mǝyli oƣul yaki ⱪiz tuƣsun, ⱪan paklinix künliri tamam bolƣandin keyin u ayal kɵydürmǝ ⱪurbanliⱪ üqün bir yaxⱪa kirgǝn ⱪozini, gunaⱨ ⱪurbanliⱪi üqün bir baqka yaki pahtǝkni elip jamaǝt qedirining kirix aƣziƣa, kaⱨinning ⱪexiƣa kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kaⱨin uni Pǝrwǝrdigarning aldida sunup, xu ayal üqün kǝfarǝt kǝltüridu; xuning bilǝn u hunidin pak bolidu. Oƣul yaki ⱪiz tuƣⱪan ayal toƣrisidiki ⱪanun-bǝlgilimǝ mana xudur. ");
INSERT INTO uigpin_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Əgǝr uning ⱪoziƣa ⱪurbi yǝtmisǝ, u ikki pahtǝk yaki ikki baqka kǝltürsun; ularning biri kɵydürmǝ ⱪurbanliⱪ üqün, yǝnǝ biri gunaⱨ ⱪurbanliⱪi üqün bolidu; xu yol bilǝn kaⱨin uning üqün kǝfarǝt kǝltüridu; u ayal pak bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Birsining bǝdinining terisidǝ bir qiⱪan, yaki tǝmrǝtkǝ yaki parⱪiraⱪ taxma qiⱪip, uningdin bǝdinining terisidǝ pesǝ-mahaw kesilining jaraⱨiti pǝyda bolƣan bolsa, u kixi Ⱨarun kaⱨinning yaki uning kaⱨin oƣulliridin birining ⱪexiƣa kǝltürülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kaⱨin uning bǝdinining jaraⱨitigǝ ⱪaraydu; jaraⱨǝt bolƣan jayning tüki aⱪirip kǝtkǝn ⱨǝmdǝ jaraⱨǝtmu ǝtrapidiki teridin ⱪeniⱪraⱪ kɵrünsǝ, bu pesǝ-mahaw kesǝllikidur. Xunga kaⱨin uni kɵrgǝndin keyin xu kixini «napak» dǝp jakarlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Lekin ǝgǝr uning bǝdinining terisidiki pǝyda bolƣan axu yaltiraⱪ qiⱪan aⱪ bolup, ǝtrapidiki teridin ⱪeniⱪraⱪ kɵrünmisǝ wǝ tükimu aⱪirip kǝtmigǝn bolsa, kaⱨin bu jaraⱨǝt bar kixini yǝttǝ küngiqǝ ayrim solap ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Yǝttinqi küni kaⱨin uningƣa ⱪarisun wǝ ǝgǝr jaraⱨǝt ohxax turup, terisidǝ kengiyip kǝtmigǝn bolsa, kaⱨin uni yǝnǝ yǝttǝ küngiqǝ ayrim solap ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Yǝttinqi küni kaⱨin uningƣa yǝnǝ ⱪarisun wǝ jaraⱨǝtning rǝnggi suslaxⱪan wǝ kengiyip kǝtmigǝn bolsa, undaⱪta kaⱨin uni «pak» dǝp jakarlisun; jaraⱨǝtning pǝⱪǝt bir qaⱪa ikǝnliki bekitilip, kesǝl kixi ɵz kiyimlirini yuyup pak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Lekin ǝgǝr u kaⱨinƣa kɵrünüp «pak» dǝp jakarlanƣandin keyin xu qaⱪa terisidǝ kengiyip kǝtsǝ, undaⱪta u yǝnǝ bir ⱪetim kaⱨinƣa kɵrünsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kaⱨin uningƣa yǝnǝ ⱪarisun wǝ ǝgǝr qaⱪa uning terisidǝ kengiyip kǝtkǝn bolsa, kaⱨin uni «napak» dǝp jakarlisun; u jaraⱨǝt pesǝ-mahawdur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Əgǝr birkimdǝ pesǝ-mahaw jaraⱨiti pǝyda bolup ⱪalsa kaⱨinning ⱪexiƣa kǝltürülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kaⱨin uning jaraⱨitigǝ sǝpselip ⱪarisun; wǝ ǝgǝr terisidǝ aⱪ bir qiⱪan pǝyda bolƣan, tüki aⱪirip kǝtkǝn bolsa wǝ qiⱪan qiⱪⱪan jayda ǝt-gɵxi kɵrünüp ⱪalƣan bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","bu uning bǝdinining terisigǝ qüxkǝn kona pesǝ-mahaw jaraⱨitining ⱪaytidin ⱪozƣilixi bolup, kaⱨin uni «napak» dǝp jakarlisun. U napak bolƣini üqün uni solaxning ⱨajiti yoⱪ. ");
INSERT INTO uigpin_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Lekin ǝgǝr pesǝ-mahaw ⱪozƣilip, jaraⱨiti bar kixining terisigǝ yeyilip kǝtkǝn bolsa, kaⱨin nǝgila ⱪarisa xu yǝrdǝ xu «pesǝ-mahaw» bolsa, terisini bexidin putiƣiqǝ ⱪaplap kǝtkǝn bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","undaⱪta kaⱨin uningƣa sǝpselip ⱪarisun; mana, xu pesǝ-mahaw jaraⱨiti pütün bǝdinini ⱪaplap kǝtkǝn bolsa, u jaraⱨiti bar kixini «pak» dǝp jakarlisun; qünki uning pütün bǝdini aⱪirip kǝtkǝn bolup, u «pak» dǝp sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Lekin ⱪaqaniki uningda ǝt-gɵxi kɵrünüp ⱪalsa, u kixi napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kaⱨin mundaⱪ kɵrüngǝn ǝt-gɵxigǝ ⱪarap, u kixini «napak» dǝp jakarlisun; qünki xu ǝt-gɵx napak bolup, u pesǝ-mahaw kesilidur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ⱨalbuki, ǝgǝr ǝt-gɵxi ⱪaytidin ɵzgirip, aⱪarsa u kixi yǝnǝ kaⱨinning ⱪexiƣa kǝlsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kaⱨin uningƣa sǝpselip ⱪarisun; jaraⱨǝt aⱪarƣan bolsa, kaⱨin jaraⱨiti bar kixini «pak» dǝp jakarlisun; u pak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Əgǝr birkimning bǝdinining terisigǝ ⱨürrǝk qiⱪip saⱪiyip, ");
INSERT INTO uigpin_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ⱨürrǝkning ornida aⱪ qiⱪan yaki ⱪizƣuq daƣ pǝyda bolƣan bolsa, kaⱨinƣa kɵrsitilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kaⱨin uningƣa sǝpselip ⱪarisun; ǝgǝr daƣ ǝtrapidiki teridin ⱪeniⱪraⱪ kɵrünsǝ, xundaⱪla uningdiki tüklǝr aⱪirip ⱪalƣan bolsa, undaⱪta kaⱨin uni «napak» dǝp jakarlisun; qünki bu ⱨürrǝktin ⱪozƣilip pǝyda bolƣan pesǝ-mahaw kesili jaraⱨitidur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Lekin kaⱨin uningƣa sǝpselip ⱪariƣanda, daƣ qiⱪⱪan jayda aⱪirip ⱪalƣan tüklǝr bolmisa, wǝ daƣmu ǝtrapidiki teridin ⱪeniⱪraⱪ bolmisa, rǝnggi sǝl susraⱪ bolƣan bolsa, undaⱪta kaⱨin uni yǝttǝ küngiqǝ ayrim solap ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Əgǝr daƣ dǝrwǝⱪǝ terisigǝ yeyilip kǝtkǝn bolsa, kaⱨin uni «napak» dǝp jakarlisun; qünki bu pesǝ-mahaw jaraⱨitidur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Əmma ǝgǝr daƣ ɵz jayida tohtap yeyilmiƣan bolsa, bu pǝⱪǝt ⱨürrǝkning zǝhmi, halas; kaⱨin uni «pak» dǝp jakarlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Əgǝr birsining bǝdinining terisining mǝlum jayi kɵyüp ⱪelip, kɵygǝn jay aⱪ-ⱪizƣuq yaki pütünlǝy aⱪ daƣ bolup ⱪalsa, ");
INSERT INTO uigpin_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kaⱨin uningƣa sǝpselip ⱪarisun; ǝgǝr xu daƣdiki tüklǝr aⱪirip kǝtkǝn, daƣmu ǝtrapidiki teridin ⱪeniⱪraⱪ bolup ⱪalƣan bolsa, undaⱪta bu kɵyük yarisidin pǝyda bolƣan pesǝ-mahaw kesilidur; kaⱨin uni «napak» dǝp jakarlisun; qünki u pesǝ-mahaw jaraⱨitidur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Lekin ǝgǝr kaⱨin sǝpselip ⱪariƣanda, daƣning ornida ⱨeqⱪandaⱪ aⱪirip kǝtkǝn tük bolmisa, xundaⱪla daƣmu ǝtrapidiki teridin ⱪeniⱪ bolmisa, bǝlki rǝnggi sus bolsa, undaⱪta kaⱨin uni yǝttǝ küngiqǝ ayrim solap ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Yǝttinqi küni kaⱨin uningƣa yǝnǝ ⱪarisun; daƣ terisidǝ kengiyip kǝtkǝn bolsa, kaⱨin uni «napak» dǝp jakarlisun; qünki u pesǝ-mahaw jaraⱨitidur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Əmma ǝgǝr daƣ jayida tohtap, yeyilmiƣan bolsa, xundaⱪla rǝnggi sus bolsa, bu pǝⱪǝt kɵyüktin bolƣan qawartⱪu, halas; kaⱨin uni «pak» dǝp jakarlisun; qünki u kɵyükning tatuⱪi, halas. ");
INSERT INTO uigpin_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Əgǝr bir ǝr yaki ayal kixining bexida yaki saⱪilida jaraⱨǝt pǝyda bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kaⱨin jaraⱨǝtkǝ sǝpselip ⱪarisun; ǝgǝr jaraⱨǝt ǝtrapidiki teridin ⱪeniⱪraⱪ kɵrünsǝ, üstidǝ xalang seriⱪ tük bolsa, undaⱪta kaⱨin uni «napak» dǝp jakarlisun; qünki bu jaraⱨǝt ⱪaⱪaq bolup, bax yaki saⱪaldiki pesǝ-mahawning alamitidur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Əgǝr kaⱨin ⱪaⱪaq jayƣa sǝpselip ⱪariƣanda, u ǝtrapidiki teridin ⱪeniⱪ kɵrünmisǝ, xundaⱪla uning iqidǝ ⱨeqⱪandaⱪ ⱪara tükmu bolmisa, undaⱪta kaⱨin ⱪaⱪiqi bar kixini yǝttǝ küngiqǝ ayrim solap ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Kaⱨin yǝttinqi küni ⱪaⱪaqⱪa yǝnǝ sǝpselip ⱪarisun; ⱪaⱪaq kengiyip kǝtmǝy, üstidimu ⱨeqⱪandaⱪ seriⱪ tük bolmisa, xundaⱪla ⱪaⱪaq ǝtrapidiki teridin ⱪeniⱪ kɵrünmisǝ, ");
INSERT INTO uigpin_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","jaraⱨiti bar kixi barliⱪ qaq-saⱪilini qüxürüwǝtsun; ⱪaⱪaqning ɵzini ƣirdimisun. Kaⱨin ⱪaⱪiqi bar kixini yǝnǝ yǝttǝ küngiqǝ ayrim solap ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Yǝttinqi küni kaⱨin ⱪaⱪaqⱪa sǝpselip ⱪarisun; ǝgǝr ⱪaⱪaq teridǝ kengiyip kǝtmigǝn bolsa, xundaⱪla ǝtrapidiki teridin ⱪeniⱪ kɵrünmisǝ, kaⱨin uni «pak» dǝp jakarlisun. Andin u kiyimlirini yusun; xuning bilǝn u pak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Lekin ǝgǝr u «pak» dǝp jakarlanƣandin keyin ⱪaⱪaq teridǝ kengiyip kǝtsǝ, ");
INSERT INTO uigpin_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kaⱨin uningƣa yǝnǝ sǝpselip ⱪarisun; ǝgǝr ⱪaⱪaq teridǝ kengiyip kǝtkǝn bolsa, seriⱪ tükning bar-yoⱪluⱪini tǝkxürüxning ⱨajiti yoⱪ; qünki bu kixi napaktur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Əgǝr ⱪaⱪaq jayida xu peti ⱪelip, üstidin ⱪara tük ünüp qiⱪⱪan bolsa, ⱪaⱪaq saⱪayƣan bolidu; xu kixi pak bolƣaqⱪa, kaⱨin uni «pak» dǝp jakarlixi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Əgǝr ǝr yaki ayal kixining bǝdinining terisidǝ daƣ pǝyda bolup, bu daƣlar parⱪiraⱪ ⱨǝm aⱪ bolsa ");
INSERT INTO uigpin_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kaⱨin sǝpselip ⱪarisun; ǝgǝr bǝdǝnning terisidiki xu daƣlar suslixip boz rǝnggǝ yüzlǝngǝn bolsa, bu teridin qiⱪⱪan bir taxma, halas; bu kixi pak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Əgǝr birkimning bexining tükliri qüxüp kǝtkǝn bolsa, u pǝⱪǝt bir taⱪir bax, halas; u pak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Əgǝr uning bexining tüki pexanǝ tǝripidin qüxkǝn bolsa, u pǝⱪǝt paynǝkbax, halas; u yǝnila pak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Lekin ǝgǝr uning taⱪir bexi yaki paynǝk bexida ⱪizƣuq aⱪ daƣ kɵrünsǝ, undaⱪta xu jaraⱨǝt uning taⱪir bexi yaki paynǝk bexidiki pesǝ-mahaw kesilining bir alamitidur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kaⱨin jaraⱨitigǝ sǝpselip ⱪarisun; ǝgǝr uning taⱪir bexida yaki paynǝk bexida ixxiⱪ jaraⱨǝt bolsa ⱨǝmdǝ pesǝ-mahaw kesilining alamitidǝk ⱪizƣuq aⱪ kɵrünsǝ, ");
INSERT INTO uigpin_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","undaⱪta u pesǝ-mahaw kesiligǝ giriptar bolƣan adǝm bolup, napak ⱨesablinidu. Uning bexiƣa xundaⱪ jaraⱨǝt qüxkǝn bolƣaq, kaⱨin uni mutlǝⱪ «napak» dǝp jakarlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Xundaⱪ jaraⱨiti bar pesǝ-mahaw kesili bolƣan kixi kiyimliri yirtiⱪ, qaqliri quwuⱪ, burut-saⱪili yepiⱪliⱪ ⱨalda: «Napak, napak!» dǝp towlap yürüxi kerǝk.    ");
INSERT INTO uigpin_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Xu jaraⱨiti bolƣan barliⱪ künlǝrdǝ u «napak» sanilidu; u napak bolƣaqⱪa, ayrim turuxi kerǝk; uning turalƣusi qedirgaⱨning sirtida bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Əgǝr bir kiyimdǝ, mǝyli yungdin yaki kanaptin tikilgǝn bolsun uningda pesǝ-mahaw iz-deƣi pǝyda bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","yǝni kanap yaki yungdin toⱪulƣan rǝhttǝ, ɵrüx yipida yaki arⱪaⱪ yiplirida bolsun, terǝ-hurumda yaki teridin etilgǝn ⱨǝrⱪandaⱪ nǝrsilǝrdǝ pesǝ-mahaw iz-deƣi bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","xundaⱪla kiyim-keqǝk yaki terǝ-hurumda, ɵrüx yip yaki arⱪaⱪ yiplirida, ya terǝ-hurumdin etilgǝn nǝrsilǝrdǝ pǝyda bolƣan iz-daƣ yexilraⱪ yaki ⱪizƣuq bolsa bu iz-daƣ «pesǝ-mahaw iz-deƣi» dǝp ⱪarilip kaⱨinƣa kɵrsitilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kaⱨin daƣⱪa sǝpselip ⱪarisun, andin iz-daƣ pǝyda bolƣan nǝrsini yǝttǝ küngiqǝ ayrim saⱪlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","U yǝttinqi küni iz-daƣⱪa ⱪarap baⱪsun; iz-daƣ qüxkǝn kiyim-keqǝk, mǝyli arⱪaⱪ yipta yaki ɵrüx yipta bolsun, yaki terǝ-hurumda yaki terǝ-hurumdin etilgǝn nǝrsidǝ bolsun, u kengiyip kǝtkǝn bolsa, bu iz-daƣ qiritküq pesǝ-mahaw kesili dǝp ⱨesablinip, ular napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Xuningdǝk kaⱨin ɵrüx yip yaki arⱪaⱪ yipida iz-daƣ bolsa kiyim-keqǝk yaki terǝ-hurumdin etilgǝn nǝrsidǝ xundaⱪ iz-daƣ bolsa ularnimu kɵydürüwǝtsun; qünki bu qiritküq pesǝ-mahaw kesilidur. Mundaⱪ nǝrsilǝrning ⱨǝmmisini otta kɵydürüx kerǝktur. ");
INSERT INTO uigpin_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Lekin kaⱨin uningƣa sǝpselip ⱪariƣanda, iz-daƣ kiyim-keqǝktiki ɵrüx yipta bolsun, arⱪaⱪ yipta bolsun, yaki terǝ-hurumdin etilgǝn nǝrsidǝ bolsun, iz-daƣ kengǝymigǝn bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","undaⱪta kaⱨin deƣi bar nǝrsini yuyulsun dǝp buyrup, ikkinqi ⱪetim uni yǝttǝ küngiqǝ saⱪlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Bu nǝrsǝ yuyulƣandin keyin kaⱨin yǝnǝ daƣⱪa sǝpselip ⱪarisun; ǝgǝr uning rǝnggi ɵzgǝrmigǝn bolsa (gǝrqǝ kengiyip kǝtmigǝn bolsimu), u yǝnila napaktur; sǝn uni otta kɵydürgin. Qünki mǝyli uning iz-deƣi iq yüzidǝ bolsun yaki tax yüzidǝ bolsun u qiritküq iz-daƣ ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Lekin ǝgǝr kaⱨin sǝpselip ⱪariƣanda, mana, daƣning rǝnggi yuyulƣandin keyin suslixip kǝtkǝn bolsa, u xu ⱪismini kiyim-keqǝktin, ɵrüx yiptin yaki arⱪaⱪ yiptin bolsun, yaki terǝ-hurumdin bolsun uni yirtip elip, taxliwǝtsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Əgǝr bu iz-daƣ kiyim-keqǝktǝ, mǝyli arⱪaⱪ yipta yaki ɵrüx yipta bolsun, ya terǝ-hurumdin etilgǝn nǝrsidǝ kɵrünsun, bu kengiydiƣan birhil pesǝ-mahaw iz-deƣi dǝp sanalsun; sǝn u qaplaxⱪan kiyim-keqǝkni kɵydürüwǝtkin. ");
INSERT INTO uigpin_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Lekin ǝgǝr iz-daƣ kiyim-keqǝktǝ bolsun (ɵrüx yipida yaki arⱪaⱪ yipida bolsun) yaki terǝ-hurumdin etilgǝn nǝrsidǝ bolsun, yuyulux bilǝn qiⱪip kǝtsǝ, undaⱪta bu egin ikkinqi ⱪetim yuyulsun, andin pak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Pesǝ-mahaw kesiliningkidǝk iz-daƣ pǝyda bolƣan yung yaki kanap rǝhttin toⱪulƣan kiyim-keqǝk (iz-daƣ ɵrüx yipta yaki arⱪaⱪ yipta bolsun) yaki terǝ-hurumdin etilgǝn nǝrsilǝr toƣrisidiki ⱪanun-bǝlgilimǝ mana xudur; buning bilǝn ularni pak yaki napak jakarlaxⱪa bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Pesǝ-mahaw bolƣan kixi pak ⱪilinidiƣan künidǝ bǝja ⱪilix kerǝk bolƣan ⱪanun-bǝlgilimǝ mana tɵwǝndikidǝktur: — U kaⱨinning aldiƣa kǝltürülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kaⱨin qedirgaⱨning taxⱪiriƣa qiⱪip, pesǝ-mahaw bolƣan kixigǝ sǝpselip ⱪarisun; ǝgǝr pesǝ-mahaw bolƣan kixi kesilidin saⱪayƣan bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Undaⱪta kaⱨin pak ⱪilinidiƣan kixigǝ pak, tirik ⱪuxtin ikkini uningƣa ⱪoxup kedir yaƣiqi, ⱪizil rǝht wǝ zofa kǝltürüxkǝ buyrusun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Andin kaⱨin ⱪuxlarning birini eⱪin su ⱪaqilanƣan sapal kozining üstidǝ boƣuzlanglar dǝp buyrusun; ");
INSERT INTO uigpin_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","andin tirik ⱪuxni bolsa, kaⱨin uni kedir yaƣiqi, ⱪizil rǝht wǝ zofa bilǝn elip kelip, bu nǝrsilǝrning ⱨǝmmisini tirik ⱪux bilǝn birgǝ eⱪin suning üstidǝ boƣuzlanƣan ⱪuxning ⱪeniƣa qilisun, ");
INSERT INTO uigpin_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","andin pesǝ-mahawdin pak ⱪilinidiƣan kixigǝ yǝttǝ ⱪetim sepixi bilǝn uni pak dǝp jakarlisun; wǝ tirik ⱪuxni dalaƣa ⱪoyup bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Pesǝ-mahawdin pak ⱪilinidiƣan kixi kiyimlirini yuyup, bǝdinidiki barliⱪ tüklǝrni qüxürüp, suda yuyunƣandin keyin pak ⱨesablinidu. Andin uningƣa qedirgaⱨⱪa kirixkǝ ijazǝt bolidu; pǝⱪǝt u yǝttǝ küngiqǝ ɵz qedirining texida turuxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Yǝttinqi küni u bǝdinidiki ⱨǝmmǝ tüklǝrni qüxürsun; baxning qaq-saⱪalliri wǝ ⱪexini, yǝni barliⱪ tüklirini qüxürsun; u kiyimlirini yuyup ɵz bǝdinini suda yusun, andin pak bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sǝkkizinqi küni u ikki bejirim ǝrkǝk ⱪoza bilǝn bir yaxⱪa kirgǝn bejirim qixi ⱪozidin birni, xuningdǝk bir ǝfaⱨning ondin üqigǝ barawǝr zǝytun meyi ilǝxtürülgǝn esil un «axliⱪ ⱨǝdiyǝsi»ni, bir log zǝytun meyini kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Uni «pak» dǝp jakarlaydiƣan bu rǝsim-ⱪaidini ɵtküzidiƣan kaⱨin pak ⱪilinidiƣan kixini wǝ u nǝrsilǝrni jamaǝt qedirining kirix aƣzida, Pǝrwǝrdigarning aldida ⱨazir ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Andin kaⱨin ǝrkǝk ⱪozilarning birini elip itaǝtsizlik ⱪurbanliⱪi ⱪilip sunup, uning bilǝn billǝ xu bir log zǝytun meyinimu kǝltürüp, pulanglatma ⱨǝdiyǝ süpitidǝ Pǝrwǝrdigarning aldida pulanglatsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ⱪoza bolsa muⱪǝddǝs bir jayning iqidǝ gunaⱨ ⱪurbanliⱪi bilǝn kɵydürmǝ ⱪurbanliⱪlar boƣuzlinidiƣan jayda boƣuzlansun; qünki itaǝtsizlik ⱪurbanliⱪi bolsa gunaⱨ ⱪurbanliⱪiƣa ohxax, kaⱨinƣa tǝwǝ bolup «ǝng muⱪǝddǝslǝrning biri» sanilidu.    ");
INSERT INTO uigpin_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kaⱨin itaǝtsizlik ⱪurbanliⱪining ⱪenidin elip pak ⱪilinidiƣan kixining ong ⱪuliⱪining yumxiⱪiƣa wǝ ong ⱪolining qong barmiⱪi bilǝn ong putining qong barmiⱪiƣimu sürüp ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Andin kaⱨin xu bir log zǝytun meyidin elip, ɵzining sol ⱪolining aliⱪiniƣa azƣina ⱪuysun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Kaⱨin ong barmiⱪini sol ⱪolidiki zǝytun meyiƣa qilap, Pǝrwǝrdigarning aldida yǝttǝ ⱪetim barmiⱪi bilǝn sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Andin kaⱨin ⱪolidiki ⱪalƣan maydin elip, pak ⱪilinidiƣan kixining ong ⱪuliⱪining yumxiⱪiƣa, ong ⱪolining bax barmiⱪiƣa wǝ ong putining bax barmiⱪiƣa sürülgǝn itaǝtsizlik ⱪurbanliⱪining ⱪenining üstigǝ sürüp ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Sürüp bolup, kaⱨin ⱪolidiki exip ⱪalƣan mayni pak ⱪilinidiƣan kixining bexiƣa ⱪuysun. Bu yol bilǝn kaⱨin uning üqün Pǝrwǝrdigarning aldida kǝfarǝt kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Andin kaⱨin gunaⱨ ⱪurbanliⱪini sunup, pak ⱪilinidiƣan kixini napakliⱪidin pak ⱪilixⱪa kǝfarǝt kǝltüridu; ahirida u kɵydürmǝ ⱪurbanliⱪni boƣuzlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kaⱨin kɵydürmǝ ⱪurbanliⱪ bilǝn axliⱪ ⱨǝdiyǝsini ⱪurbangaⱨta sunsun. Bu yol bilǝn kaⱨin uning üqün kǝfarǝt kǝltürüp, u kixi pak bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Lekin u kǝmbǝƣǝlliktin xundaⱪ ⱪilixⱪa ⱪurbi yǝtmisǝ, ɵzigǝ kǝfarǝt kǝltürüx üqün «pulanglatma ⱨǝdiyǝ» süpitidǝ yalƣuz bir ǝrkǝk ⱪozini itaǝtsizlik ⱪurbanliⱪi ⱪilip kǝltürsun, xuningdǝk axliⱪ ⱨǝdiyǝsi üqün bir ǝfaⱨning ondin birigǝ barawǝr zǝytun meyi ilǝxtürülgǝn esil un bilǝn bir log zǝytun meyini kǝltürsun ");
INSERT INTO uigpin_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","wǝ ɵz ǝⱨwaliƣa yarixa ikki pahtǝk yaki ikki baqka elip kǝlsun; biri gunaⱨ ⱪurbanliⱪi üqün, yǝnǝ biri kɵydürmǝ ⱪurbanliⱪ üqün bolsun; ");
INSERT INTO uigpin_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","sǝkkizinqi küni bularni ɵzining pak ⱪilinixi üqün jamaǝt qedirining kirix aƣziƣa elip kelip, Pǝrwǝrdigarning aldida kaⱨinning ⱪexiƣa kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kaⱨin itaǝtsizlik ⱪurbanliⱪi bolidiƣan ǝrkǝk ⱪoza bilǝn xu bir log mayni elip, bularni pulanglatma ⱨǝdiyǝ süpitidǝ Pǝrwǝrdigarning aldida pulanglatsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Itaǝtsizlik ⱪurbanliⱪi ⱪilinƣan ǝrkǝk ⱪozini bolsa ɵzi boƣuzlisun; andin kaⱨin itaǝtsizlik ⱪurbanliⱪining ⱪenidin azƣina elip, pak ⱪilinidiƣan kixining ong ⱪuliⱪining yumxiⱪiƣa, ong ⱪolining bax barmiⱪiƣa wǝ ong putining bax barmiⱪiƣa sürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Andin kaⱨin maydin elip, sol ⱪolining aliⱪiniƣa azƣina ⱪuysun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Xundaⱪ ⱪilip, kaⱨin ong barmiⱪi bilǝn sol ⱪolidiki maydin Pǝrwǝrdigarning aldida yǝttǝ ⱪetim sǝpsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Andin kaⱨin ɵzi ⱪolidiki maydin elip, pak ⱪilinidiƣan kixining ong ⱪuliⱪining yumxiⱪiƣa wǝ ong ⱪolining bax barmiⱪi bilǝn ong putining bax barmiⱪiƣa itaǝtsizlik ⱪurbanliⱪining ⱪenining üstigǝ sürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Xuning bilǝn Pǝrwǝrdigarning aldida uningƣa kǝfarǝt kǝltürüxkǝ kaⱨin ⱪolidiki mayning ⱪalƣinini pak ⱪilinidiƣan kixining bexiƣa ⱪuysun; ");
INSERT INTO uigpin_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","andin xu kixi ɵz ⱪurbiƣa ⱪarap pahtǝktin birni yaki baqkidin birni sunsun; ");
INSERT INTO uigpin_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ɵz ⱪurbiƣa ⱪarap, birini gunaⱨ ⱪurbanliⱪi, yǝnǝ birini kɵydürmǝ ⱪurbanliⱪ ⱪilip axliⱪ ⱨǝdiyǝsi bilǝn billǝ sunsun. Bu yolda kaⱨin Pǝrwǝrdigarning aldida pak ⱪilinidiƣan kixi üqün kǝfarǝt kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ɵzidǝ pesǝ-mahaw bolƣan, pak ⱪilinixi üqün wajip bolidiƣan nǝrsilǝrni kǝltürüxkǝ ⱪurbi yǝtmǝydiƣan kixilǝr toƣrisidiki ⱪanun-bǝlgilimǝ mana xulardur. ");
INSERT INTO uigpin_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","— Silǝr Mǝn ɵzünglarƣa miras ⱪilip beridiƣan Ⱪanaan zeminiƣa kirgǝndin keyin, Mǝn silǝr igǝ bolidiƣan xu zemindiki bir ɵygǝ birhil pesǝ-mahaw yarisini ǝwǝtsǝm, ");
INSERT INTO uigpin_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ɵyning igisi kaⱨinning ⱪexiƣa berip, uningƣa buni mǝlum ⱪilip: «Mening ɵyümgǝ waba yuⱪⱪandǝk kɵrünidu», dǝp mǝlum ⱪilixi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kaⱨin bolsa: — Ɵydiki ⱨǝmmǝ nǝrsilǝr napak bolmisun üqün mǝn berip bu wabaƣa sǝpselip ⱪaraxtin burun ɵyni bikarlanglar, dǝp buyrusun. Andin kaⱨin kirip ɵygǝ sǝpselip ⱪarisun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","U xu wabaƣa sǝpselip ⱪariƣinida, mana ɵyning tamliriƣa waba daƣliri yuⱪⱪan jaylar kawak bolsa, ⱨǝm yexilƣa mayil yaki ⱪizƣuq bolup, tamning yüzidin ⱪeniⱪraⱪ bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","kaⱨin ɵyning ixikining aldiƣa qiⱪip, ixikni yǝttǝ küngiqǝ taⱪap ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Andin kaⱨin yǝttinqi küni yenip kelip, sǝpselip ⱪariƣinida, ɵyning tamliridiki iz-daƣ kengiyip kǝtkǝn bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","kaⱨin: — Waba yuⱪⱪan taxlarni qiⱪirip xǝⱨǝrning sirtidiki napak bir jayƣa taxliwetinglar, dǝp buyrusun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Xuning bilǝn birgǝ u ɵyning iqining tɵt ǝtrapini ⱪirdursun wǝ ular ⱪirƣan suwaⱪni bolsa xǝⱨǝrning texidiki napak bir jayƣa tɵküwǝtsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Andin ular baxⱪa taxlarni elip, ilgiriki taxlarning ornida ⱪoysun wǝ baxⱪa ⱨak lay etip, uning bilǝn ɵyni ⱪaytidin suwisun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Əgǝr u taxlarni qiⱪirip, ɵyni ⱪirdurup ⱪaytidin suwatⱪandin keyin, ɵydǝ waba deƣi yǝnǝ pǝyda bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","undaⱪta kaⱨin yǝnǝ kirip buningƣa sǝpselip ⱪarisun. Sǝpselip ⱪariƣinida, mana iz-daƣ ɵydǝ kengiyip kǝtkǝn bolsa, bu ɵygǝ yuⱪⱪini qiritküq waba bolidu; ɵy napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Bu wǝjidin ular ɵyni, yǝni yaƣaq-tax wǝ barliⱪ suwiⱪi bilǝn billǝ qüxürüp, ⱨǝmmisini kɵtürüp xǝⱨǝrning sirtidiki napak bir jayƣa taxliwǝtsun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Kimdǝkim ɵy taⱪalƣan mǝzgildǝ uningƣa kirsǝ, u kǝq kirgüqǝ napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Əgǝr birkim ɵy iqidǝ yatⱪan bolsa, kiyimlirini yusun; wǝ ǝgǝr birsi ɵydǝ ƣizalanƣan bolsa, umu ɵz kiyimlirini yusun. ");
INSERT INTO uigpin_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Lekin kaⱨin kirip, ɵygǝ sǝpselip ⱪariƣinida ɵy suwalƣandin keyin waba uningda kengiyip kǝtmigǝn bolsa, undaⱪta kaⱨin ɵyni «pak» dǝp jakarlisun; qünki uningdiki waba saⱪayƣan bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Andin u ɵyning pak ⱪilinixi üqün ikki ⱪux, kedir yaƣiqi, ⱪizil rǝht bilǝn zofa elip kelip, ");
INSERT INTO uigpin_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ⱪuxlarning birini eⱪin su ⱪaqilanƣan sapal kozining üstidǝ boƣuzlisun; ");
INSERT INTO uigpin_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","andin u kedir yaƣiqi, zofa, ⱪizil rǝht wǝ tirik ⱪuxni billǝ elip kelip, bu nǝrsilǝrning ⱨǝmmisini boƣuzlanƣan ⱪuxning ⱪeniƣa, xundaⱪla eⱪin suƣa qilap, ɵygǝ yǝttǝ mǝrtiwǝ sǝpsun; ");
INSERT INTO uigpin_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","bu yol bilǝn u ɵyni ⱪuxning ⱪeni, eⱪin su, tirik ⱪux, kedir yaƣiqi, zofa wǝ ⱪizil rǝht arⱪiliⱪ napakliⱪtin paklaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Andin u tirik ⱪuxni xǝⱨǝrning sirtida, dalada ⱪoyup bǝrsun. U xundaⱪ ⱪilip, ɵy üqün kǝfarǝt kǝltüridu; u ɵy pak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Bular bolsa ⱨǝrhil pesǝ-mahaw jaraⱨiti, ⱪaⱪaq, ");
INSERT INTO uigpin_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","kiyim-keqǝk wǝ ɵygǝ yuⱪⱪan pesǝ-mahaw wabasi, ");
INSERT INTO uigpin_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","teridiki qiⱪanlar, tǝmrǝtkǝ wǝ parⱪiraⱪ aⱪ iz-daƣlar toƣrisidiki ⱪanun-bǝlgilimidur. ");
INSERT INTO uigpin_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Xu bǝlgilimilǝr bilǝn bir nǝrsining ⱪaysi ǝⱨwalda napak, ⱪaysi ǝⱨwalda pak bolidiƣanliⱪini pǝrⱪ etixkǝ kɵrsǝtmǝ berixkǝ bolidu; mana bu pesǝ-mahaw toƣrisidiki ⱪanun-bǝlgilimidur. ");
INSERT INTO uigpin_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Israillarƣa mundaⱪ dǝnglar: — Ⱨǝrⱪandaⱪ ǝrkǝkning ɵz tenidin aⱪma qiⱪsa xu kixi xu aⱪma sǝwǝbidin napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Aⱪma qiⱪixtin bolƣan napakliⱪ toƣrisidiki ⱨɵküm xuki, aⱪmisi mǝyli tenidin eⱪip tursun yaki eⱪixtin tohtitilƣan bolsun, xu kixi yǝnila napak sanalsun; ");
INSERT INTO uigpin_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","mundaⱪ aⱪma bolƣan kixi yatⱪan ⱨǝrbir orun-kɵrpǝ napak sanilidu wǝ u ⱪaysi nǝrsining üstidǝ oltursa xu nǝrsimu napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Kimki u yatⱪan orun-kɵrpigǝ tǝgsǝ, ɵz kiyimlirini yuyup, suda yuyunsun, andin kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Xuningdǝk kimki mundaⱪ aⱪma bolƣan kixi olturƣan nǝrsidǝ oltursa ɵz kiyimlirini yuyup, suda yuyunsun wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Kimki aⱪma bolƣan kixining tenigǝ tǝgsǝ, ɵz kiyimlirini yuyup, suda yuyunsun, wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Əgǝr aⱪma bolƣan kixi pak birsigǝ tükürsǝ, xu kixi ɵz kiyimlirini yuyup, suda yuyunsun, kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ⱪaysibir egǝr-toⱪumning üstigǝ aⱪma bolƣan kixi minsǝ, xu nǝrsǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Kimki uning tegidǝ ⱪoyulƣan nǝrsilǝrgǝ tǝgsǝ kǝq kirgüqǝ napak sanilidu; wǝ kimki xu nǝrsilǝrni kɵtürsǝ, ɵz kiyimlirini yuyup, suda yuyunsun, wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Aⱪma bolƣan kixi ⱪolini yumastin birkimgǝ tǝgküzsǝ, xu kixi ɵz kiyimlirini yuyup, suda yuyunsun wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Aⱪma bolƣan kixi sapal ⱪaqini tutup salsa, xu ⱪaqa qeⱪiwetilsun; yaƣaq ⱪaqa bolsa suda yuyulsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ⱪaqaniki aⱪma bar kixi aⱪma ⱨalitidin ⱪutulsa, ɵzining pak ⱪilinixi üqün yǝttǝ künni ⱨesablap ɵtküzüp, andin kiyimlirini yuyup, eⱪin suda yuyunsun; andin pak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Sǝkkizinqi küni ikki pahtǝk yaki ikki baqkini elip, jamaǝt qedirining kirix aƣziƣa, Pǝrwǝrdigarning aldiƣa kǝltürüp, kaⱨinƣa tapxursun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kaⱨin ulardin birini gunaⱨ ⱪurbanliⱪi üqün, yǝnǝ birini kɵydürmǝ ⱪurbanliⱪ üqün sunsun. Bu yol bilǝn kaⱨin Pǝrwǝrdigarning aldida uning aⱪma bolƣanliⱪiƣa kǝfarǝt kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Əgǝr bir ǝrkǝkning mǝniysi ɵzlükidin qiⱪip kǝtkǝn bolsa, u pütün bǝdinini suda yusun, u kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Xuningdǝk adǝmning mǝniysi ⱪaysi kiyimigǝ yaki terisigǝ yuⱪup ⱪalsa, suda yuyulsun wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ər wǝ ayal kixi bir-birigǝ yeⱪinlixixi bilǝn mǝniy qiⱪsa, ikkisi yuyunsun wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Əgǝr ayal kixilǝr aⱪma kelix ⱨalitidǝ tursa wǝ aⱪmisi hun bolsa, u yǝttǝ küngiqǝ «ayrim» tursun; kimki uningƣa tǝgsǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","«Ayrim» turux mǝzgilidǝ, ⱪaysi nǝrsining üstidǝ yatsa, xu nǝrsǝ napak sanilidu, xundaⱪla ⱪaysi nǝrsining üstidǝ olturƣan bolsa, xu nǝrsimu napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ⱨǝrkim uning orun-kɵrpisigǝ tǝgsǝ ɵz kiyimlirini yuyup, suda yuyunsun wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ⱨǝrkim u olturƣan nǝrsigǝ tǝgsǝ, ɵz kiyimlirini yuyup, suda yuyunsun wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Wǝ ǝgǝr birkim u yatⱪan yaki olturƣan jayda ⱪoyulƣan birǝr nǝrsigǝ tǝgsǝ, kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Əgǝr bir ǝr kixi xu ⱨalǝttiki ayal bilǝn birgǝ yatsa, xundaⱪla uning hun napakliⱪi xu ǝrgǝ yuⱪup ⱪalsa, u yǝttǝ küngiqǝ napak sanalsun; u yatⱪan ⱨǝrbir orun-kɵrpimu napak sanalsun.    ");
INSERT INTO uigpin_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Əgǝr ayal kixining adǝt waⱪtining sirtidimu birnǝqqǝ küngiqǝ huni kelip tursa, yaki hun aⱪmisi adǝt waⱪtidin exip kǝtkǝn bolsa, undaⱪta bu napak ⱪan eⱪip turƣan künlirining ⱨǝmmisidǝ, u adǝt künliridǝ turƣandǝk sanalsun, yǝnǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ⱪan kǝlgǝn ⱨǝrbir kündǝ u ⱪaysi orun-kɵrpǝ üstidǝ yatsa, bular u adǝt künliridǝ yatⱪan orun-kɵrpilǝrdǝk ⱨesablinidu; u ⱪaysi nǝrsining üstidǝ olturƣan bolsa, xu nǝrsǝ adǝt künlirining napakliⱪidǝk napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ⱨǝrkim bu nǝrsilǝrgǝ tǝgsǝ napak bolidu; xu kixi kiyimlirini yuyup, suda yuyunsun wǝ kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ayal kixi ⱪaqan hun kelixtin saⱪaysa, u yǝttǝ künni ⱨesablap, ɵtküzüp bolƣanda pak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Sǝkkizinqi küni u ikki pahtǝk yaki ikki baqkini elip jamaǝt qedirining kirix aƣziƣa, kaⱨinning ⱪexiƣa kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kaⱨin bularning birini gunaⱨ ⱪurbanliⱪi üqün, yǝnǝ birini kɵydürmǝ ⱪurbanliⱪ üqün ɵtküzsun; bu yol bilǝn kaⱨin uning napak aⱪma ⱪenidin pak boluxiƣa uning üqün Pǝrwǝrdigarning aldida kǝfarǝt kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Silǝr muxu yol bilǝn Israillarni napakliⱪidin üzünglar; bolmisa, ular napakliⱪida turuwerip, ularning arisida turƣan mening turalƣu qedirimni bulƣixi tüpǝylidin napak ⱨalitidǝ ɵlüp ketidu. ");
INSERT INTO uigpin_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Aⱪma kelix ⱨalitidǝ bolƣan kixi wǝ mǝniy ketix bilǝn napak bolƣan kixi toƣrisida, ");
INSERT INTO uigpin_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Xuningdǝk hun kelix künliridiki aƣriⱪ ayal kixi toƣruluⱪ, aⱪma ⱨalǝttǝ bolƣan ǝr wǝ ayal toƣruluⱪ, napak ⱨalǝttiki ayal billǝ yatⱪan ǝr toƣruluⱪ kǝlgǝn ⱪanun-bǝlgilimǝ mana xulardur. ");
INSERT INTO uigpin_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ⱨarunning ikki oƣli Pǝrwǝrdigarning aldiƣa yeⱪinlixixi bilǝn ɵlüp kǝtti. Ular ɵlüp kǝtkǝndin keyin, Pǝrwǝrdigar Musaƣa sɵz ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — «Sǝn ɵz ⱪerindixing Ⱨarunƣa: «Sǝn ɵlüp kǝtmǝsliking üqün pǝrdining iqidiki muⱪǝddǝs jayƣa ⱪoyulƣan ǝⱨdǝ sanduⱪining üstidiki «kǝfarǝt tǝhti»ning aldiƣa ⱨǝr waⱪit kǝlmǝ», degin. Qünki Mǝn «kǝfarǝt tǝhti»ning üstidiki bulutta ayan bolimǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ⱨarun ǝng muⱪǝddǝs jayƣa munu yol bilǝn kirsun: — Gunaⱨ ⱪurbanliⱪi üqün bir yax torpaⱪ, kɵydürmǝ ⱪurbanliⱪ üqün bir ⱪoqⱪarni kǝltürsun; ");
INSERT INTO uigpin_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ɵzi muⱪǝddǝs kanap halta kɵnglǝkni kiyip, ǝtlirini yapidiƣan kanap ixtannimu kiyip, beligǝ bir kanap bǝlwaƣni baƣlap, bexiƣa kanap sǝllini yɵgǝp kǝlsun. Bular muⱪǝddǝs kiyimlǝr bolƣaqⱪa, kiyixtin ilgiri bǝdinini suda yusun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","U Israillarning jamaitidin gunaⱨ ⱪurbanliⱪi üqün ikki tekǝ, kɵydürmǝ ⱪurbanliⱪ üqün bir ⱪoqⱪarni tapxuruwalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Xuning bilǝn Ⱨarun awwal gunaⱨ ⱪurbanliⱪi bolidiƣan torpaⱪni sunup, ɵzi wǝ ɵz ɵyidikilǝr üqün kǝfarǝt kǝltürüxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Andin u ikki tekini elip, ularni jamaǝt qedirining kirix aƣzining aldiƣa kǝltürüp, Pǝrwǝrdigarning aldida turƣuzsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Andin Ⱨarun bu ikki tekǝ toƣrisida qǝk taxlisun; qǝkning birini «Pǝrwǝrdigar üqün», yǝnǝ birini «azazǝl üqün» taxlisun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ⱨarun Pǝrwǝrdigarƣa qǝk qüxkǝn tekini kǝltürüp, gunaⱨ ⱪurbanliⱪi süpitidǝ sunsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Lekin «azazǝl»gǝ qǝk qüxkǝn tekini bolsa, kǝfarǝt kǝltürüxi üqün qɵlgǝ ⱨǝydilixkǝ, xundaⱪla «azazǝl»gǝ ǝwǝtilixkǝ Pǝrwǝrdigarning aldida tirik ⱪaldurulsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Andin Ⱨarun gunaⱨ ⱪurbanliⱪini, yǝni ɵzi üqün bolƣan torpaⱪni kǝltürüp, ɵzi wǝ ɵz ɵyidikilǝr üqün kǝfarǝt kǝltürüxkǝ ɵzigǝ gunaⱨ ⱪurbanliⱪi bolidiƣan bu torpaⱪni boƣuzlisun; ");
INSERT INTO uigpin_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Andin u Pǝrwǝrdigarning aldidiki ⱪurbangaⱨtin elinƣan qoƣ bilǝn tolƣan bir huxbuydanni elip, ikki ⱪollap yumxaⱪ ezilgǝn esil huxbuy ǝtir bilǝn toldurup, buni pǝrdining iqigǝ elip barsun; ");
INSERT INTO uigpin_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","andin huxbuy is-tütiki ⱨɵküm-guwaⱨ sanduⱪining üstidiki kǝfarǝt tǝhtini ⱪaplisun dǝp, huxbuyni Pǝrwǝrdigarning ⱨuzuridiki otning üstigǝ ⱪoysun; xuning bilǝn u ɵlmǝydu. ");
INSERT INTO uigpin_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","U torpaⱪning ⱪenidin elip ɵz barmiⱪi bilǝn kǝfarǝt tǝhtining xǝrⱪ tǝripigǝ qeqip, kǝfarǝt tǝhtining aldiƣimu ɵz barmiⱪi bilǝn ⱪandin elip, yǝttǝ ⱪetim sǝpsun.    ");
INSERT INTO uigpin_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Andin u hǝlⱪ üqün gunaⱨ ⱪurbanliⱪi ⱪilinidiƣan tekini boƣuzlisun; ⱪenini pǝrdining iqigǝ kǝltürüp, torpaⱪning ⱪenini ⱪilƣandǝk ⱪilsun, yǝni uning ⱪenidin elip kǝfarǝt tǝhtigǝ wǝ kǝfarǝt tǝhtining aldiƣa qaqsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","U bu yol bilǝn muⱪǝddǝs jay üqün kǝfarǝt kǝltürüp, uni Israillarning napakliⱪidin, ⱨǝmmǝ itaǝtsizliklirini elip baridiƣan gunaⱨliridin paklaydu wǝ xuningdǝk ularning napakliⱪi arisida turuwatⱪan jamaǝt qediri üqünmu xundaⱪ kǝfarǝt ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","U kǝfarǝt kǝltürüx üqün ǝng muⱪǝddǝs jayƣa kirgǝndin tartip uningdin qiⱪⱪuqǝ ⱨeqbir adǝm jamaǝt qediri iqidǝ bolmisun; bu yol bilǝn u ɵzi, ɵyidikilǝr wǝ Israilning pütkül jamaiti üqün kǝfarǝt kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Andin u Pǝrwǝrdigarning aldidiki ⱪurbangaⱨⱪa qiⱪip, uning üqünmu kǝfarǝt kǝltüridu; xuningdǝk torpaⱪning ⱪeni bilǝn tekining ⱪenidin elip ⱪurbangaⱨning qɵrisidiki münggüzlǝrgǝ sürsun; ");
INSERT INTO uigpin_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","u barmiⱪi bilǝn ⱪandin elip ⱪurbangaⱨning üstigǝ yǝttǝ ⱪetim sǝpsun; xuning bilǝn u uni Israillarning napakliⱪliridin paklap Hudaƣa atap muⱪǝddǝs ⱪilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","— Muⱪǝddǝs jay, jamaǝt qediri wǝ ⱪurbangaⱨ üqün kǝfarǝt kǝltürüp bolƣandin keyin, u tirik tekini kǝltürsun; ");
INSERT INTO uigpin_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","andin Ⱨarun ikki ⱪolini tirik tekining bexiƣa ⱪoyup turup, uning üstidǝ turup, Israillarning barliⱪ ⱪǝbiⱨlikliri wǝ itaǝtsizliklirini elip baridiƣan gunaⱨlirini iⱪrar ⱪilip, ularni tekining bexiƣa artsun; andin uni yenida tǝyyar turidiƣan bir adǝmning ⱪoli bilǝn qɵlgǝ ǝwǝtiwǝtsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Bu yol bilǝn tekǝ ularning ⱨǝmmǝ ⱪǝbiⱨliklirini ɵz üstigǝ elip, adǝmzatsiz qɵlgǝ ketidu. Xunga u tekini qɵlgǝ ⱪoyuwǝtsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","— Andin Ⱨarun jamaǝt qediriƣa kirip muⱪǝddǝs jayƣa kirgǝn waⱪitta kiygǝn kanap kiyimlirini selip xu yǝrdǝ ularni ⱪoyup ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","U muⱪǝddǝs yǝrdǝ ɵz bǝdinini suda yuyup, ɵz kiyimlirini kiyip taxⱪiriƣa qiⱪip, ɵzining kɵydürmǝ ⱪurbanliⱪi bilǝn hǝlⱪning kɵydürmǝ ⱪurbanliⱪini sunup, xu yol bilǝn ɵzi wǝ hǝlⱪ üqün kǝfarǝt kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Xundaⱪla u gunaⱨ ⱪurbanliⱪining meyini ⱪurbangaⱨta kɵydürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Azazǝl»gǝ bekitilgǝn tekini elip berip ⱪoyuwǝtkǝn kixi ɵz kiyimlirini yuyup, bǝdinini suda yuyup, andin qedirgaⱨⱪa kirixkǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kǝfarǝt kǝltürüx üqün ⱪeni ǝng muⱪǝddǝs jayƣa elip kirilip, gunaⱨ ⱪurbanliⱪi ⱪilinƣan torpaⱪ bilǝn gunaⱨ ⱪurbanliⱪi ⱪilinƣan tekini birsi qedirgaⱨning taxⱪiriƣa elip qiⱪip, ularning terisi, gɵxi wǝ tezǝklirini otta kɵydürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ularni kɵydürgǝn kixi ɵz kiyimlirini yuyup, bǝdinini suda yuyup, andin qedirgaⱨⱪa kirixkǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","— Mana bu silǝrgǝ bir ǝbǝdiy ⱪanun-bǝlgilimǝ bolsun: — Ⱨǝr yǝttinqi ayning oninqi künidǝ silǝr ɵz nǝpsinglarni tartip ɵzünglarni tɵwǝn tutunglar wǝ ⱨeqⱪandaⱪ ix ⱪilmanglar; mǝyli yǝrliklǝr bolsun yaki aranglarda turuwatⱪan Yaⱪ. yurtluⱪlar bolsun xundaⱪ ⱪilixinglar kerǝk.    ");
INSERT INTO uigpin_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Qünki xu künidǝ silǝrni paklaxⱪa silǝr üqün kǝfarǝt kǝltürülidu; Pǝrwǝrdigarning aldida silǝr ⱨǝmmǝ gunaⱨliringlardin pak bolisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Bu kün silǝrgǝ pütünlǝy aram alidiƣan xabat küni bolup, nǝpsinglarni tartip ɵzünglarni tɵwǝn tutisilǝr; bu ǝbǝdiy bir bǝlgilimidur. ");
INSERT INTO uigpin_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Kimki atisining ornida kaⱨinliⱪ yürgüzüx üqün mǝsiⱨ ⱪilinip, Hudaƣa atap tiklǝngǝn kaⱨin bolsa xu yol bilǝn kǝfarǝt kǝltüridu. U kanaptin etilgǝn muⱪǝddǝs kiyimni kiyip turup, ");
INSERT INTO uigpin_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Əng muⱪǝddǝs jay üqün kǝfarǝt kǝltüridu; jamaǝt qediri bilǝn ⱪurbangaⱨ üqünmu kǝfarǝt kǝltüridu; ⱪalƣan kaⱨinlar bilǝn barliⱪ hǝlⱪning jamaiti üqün ⱨǝm kǝfarǝt kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Bu bolsa silǝr üqün ǝbǝdiy bir bǝlgilimǝ bolidu; xuning bilǝn Israillarni barliⱪ gunaⱨliridin paklax üqün yilda bir ⱪetim kǝfarǝt kǝltürüp berisilǝr». Xuning bilǝn Ⱨarun Pǝrwǝrdigar Musaƣa buyruƣinidǝk ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Ⱨarun bilǝn oƣulliri wǝ barliⱪ Israillarƣa mundaⱪ degin: — Pǝrwǝrdigar silǝrgǝ buyruƣan ⱨɵküm xuki: — ");
INSERT INTO uigpin_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Israilning jǝmǝtliridin bolƣan ⱨǝrⱪandaⱪ kixi ⱪurbanliⱪ ⱪilmaⱪqi bolup, kala yaki ⱪoy yaki ɵqkini jamaǝt qedirining kirix aƣzida, Pǝrwǝrdigarning turalƣu qedirining aldiƣa, Pǝrwǝrdigarƣa atalƣan ⱪurbanliⱪ süpitidǝ yetilǝp ǝpkǝlmǝy, bǝlki qedirgaⱨning iqidǝ yaki taxⱪirida boƣuzlisa, uningdin aⱪⱪan ⱪan xu kixining gǝdinigǝ artilidu; bu adǝm «ⱪan tɵkkǝn» dǝp, ɵz hǝlⱪidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Bu ⱨɵkümning mǝⱪsiti Israillarning ⱨazirⱪidǝk dalada mal soyup ⱪurbanliⱪ ⱪilixning orniƣa, ⱪurbanliⱪlirini jamaǝt qedirining kirix aƣzida Pǝrwǝrdigarning aldiƣa kǝltürüp, kaⱨinƣa tapxurup Pǝrwǝrdigarƣa inaⱪliⱪ ⱪurbanliⱪliri süpitidǝ sunup boƣuzlixi üqündur. ");
INSERT INTO uigpin_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kaⱨin ⱪanni elip jamaǝt qedirining kirix aƣzining yenidiki Pǝrwǝrdigarning ⱪurbangaⱨining üstigǝ sepip, Pǝrwǝrdigarƣa huxbuy kǝltürüx üqün mayni kɵydürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Xuning bilǝn ular ǝmdi burunⱪidǝk buzuⱪluⱪ ⱪilip tekǝ-jinlarning kǝynidǝ yürüp, ularƣa ɵz ⱪurbanliⱪlirini ɵtküzüp yürmisun. Mana bu ular üqün dǝwrdin-dǝwrgiqǝ ǝbǝdiy bir bǝlgilimǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Sǝn ularƣa: — Israilning jǝmǝtidin yaki ularning arisida turuwatⱪan yaⱪa yurtluⱪlardin biri kɵydürmǝ ⱪurbanliⱪ yaki baxⱪa ⱪurbanliⱪ ɵtküzmǝkqi bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","uni Pǝrwǝrdigarƣa atap sunux üqün jamaǝt qediriƣa kirix aƣzining aldiƣa kǝltürmisǝ, u kixi ɵz hǝlⱪliridin üzüp taxlansun» — degin. ");
INSERT INTO uigpin_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Əgǝr Israilning jǝmǝtidin bolƣan ⱨǝrⱪandaⱪ adǝm yaki ularning arisida turuwatⱪan yaⱪa yurtluⱪlar ⱪan yesǝ, Mǝn yüzümni ⱪanni yegǝn xu kixigǝ ⱪarxi ⱪilimǝn, uni ɵz hǝlⱪidin üzüp taxlaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Qünki ⱨǝrbir janiwarning jeni bolsa uning ⱪenididur; Mǝn uni jeninglar üqün ⱪurbangaⱨ üstigǝ kǝfarǝt kǝltürüxkǝ bǝrgǝnmǝn. Qünki ⱪan ɵzidiki janning wasitisi bilǝn kǝfarǝt kǝltüridu. ");
INSERT INTO uigpin_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Xunga bu sǝwǝbtin Mǝn Israillarƣa: — «Silǝrning ⱨeqbiringlar ⱪan yemǝslikinglar kerǝk, aranglarda turuwatⱪan yaⱪa yurtluⱪlarmu ⱪan yemǝsliki kerǝk» — degǝnidim. ");
INSERT INTO uigpin_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Əgǝr Israillardin biri yaki ularning arisida turuwatⱪan yaⱪa yurtluⱪlarning biri yeyixkǝ bolidiƣan bir qarpay ⱨaywan yaki ⱪuxni owlap, ⱪenini tɵksǝ, uni topa bilǝn yepip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Qünki ⱨǝrbir janiwarning jeni bolsa, uning ⱪenidin ibarǝttur. Uning jeni ⱪenida bolƣaq mǝn Israillarƣa: «Silǝr ⱨeqⱪandaⱪ janiwarning ⱪenini yemǝnglar, qünki ⱨǝrbir janiwarning jeni uning ⱪenididur; kimki uni yesǝ üzüp taxlinidu» — dedim. ");
INSERT INTO uigpin_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Kimdǝkim ɵlüp ⱪalƣan yaki yirtⱪuqlar boƣup titma-titma ⱪiliwǝtkǝn bir ⱨaywanni yesǝ, mǝyli u yǝrlik yaki yaⱪa yurtluⱪ bolsun ɵz kiyimlirini yuyup, suda yuyunsun wǝ kǝq kirgüqǝ napak sanalsun; andin u pak bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Lekin u yaki kiyimlirini yumisa, yaki suda bǝdinini yumisa, xu kixi ɵz ⱪǝbiⱨlikining jazasini tartidu. ");
INSERT INTO uigpin_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Sǝn Israillarƣa mundaⱪ degin: — «Mǝn bolsam Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Silǝr ilgiri turƣan Misir zeminidikidǝk ixlarni ⱪilmanglar wǝ yaki Mǝn silǝrni elip baridiƣan Ⱪanaan zeminidikidǝk ixlarni ⱪilmanglar; ularning rǝsim-adǝtliridǝ yürmǝnglar, ");
INSERT INTO uigpin_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","bǝlki Mening ⱨɵkümlirimgǝ ǝmǝl ⱪilip, ⱪanun bǝlgilimilirimni tutup xu boyiqǝ menginglar. Mǝn Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Silǝr qoⱪum Mening bǝlgilimilirim bilǝn ⱨɵkümlirimni tutuxunglar kerǝk; insan ularƣa ǝmǝl ⱪilidiƣan bolsa ularning sǝwǝbidin ⱨayatta bolidu. Mǝn Pǝrwǝrdigardurmǝn.    ");
INSERT INTO uigpin_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","— Ⱨeqkim ɵzigǝ yeⱪin tuƣⱪan bolƣan ayalƣa yeⱪinliⱪ ⱪilip ǝwritini aqmisun. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Anangning ǝwritigǝ tǝgmǝ, bu atangning ǝwritigǝ tǝgkining bolidu; u sening anang bolƣaqⱪa uning ǝwritigǝ tǝgsǝng bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Atangning ayalining ǝwritigimu tǝgmǝ, qünki xundaⱪ ⱪilsang atangning ǝwritigǝ tǝgkǝndǝk bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Sǝn aqa-singlingning, bir atidin bolƣan yaki bir anidin bolƣan, yaki xu ɵydǝ tuƣulƣan yaki baxⱪa yǝrdǝ tuƣulƣan bolsun, uning ǝwritigǝ tǝgmǝ. ");
INSERT INTO uigpin_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Sǝn ɵz oƣlungning ⱪizi wǝ yaki ⱪizingning ⱪizining ǝwritigǝ tǝgmǝ; qünki ularning ǝwriti sǝn ɵzüngning ǝwritidur. ");
INSERT INTO uigpin_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Sǝn atangning ayalining ⱪizining ǝwritigǝ tǝgmǝ; u atangdin tuƣulƣan, sening aqa-singling, xunga uning ǝwritigǝ tǝgmǝ.    ");
INSERT INTO uigpin_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Sǝn atangning aqa-singlisining ǝwritigimu tǝgmǝ, qünki u atangning birtuƣⱪinidur. ");
INSERT INTO uigpin_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Sǝn anangning aqa-singillirining ǝwritigimu tǝgmǝ, qünki u anangning birtuƣⱪinidur. ");
INSERT INTO uigpin_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Atangning aka-inilirining ayalining ǝwritigǝ tǝgmǝ; ularning ayalliriƣa yeⱪinliⱪ ⱪilma; qünki ular sening ⱨammangdur. ");
INSERT INTO uigpin_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Sǝn keliningning ǝwritigǝ tǝgmǝ; u sening oƣlungning ayali bolƣaqⱪa, uning ǝwritigǝ tǝgsǝng bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Sǝn aka-iniliringning ayalining ǝwritigǝ tǝgmǝ; qünki bu ɵz aka-iniliringning ǝwritigǝ tǝgkǝndǝk bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Sǝn bir ayalƣa wǝ xuning bilǝn birgǝ uning ⱪizining ǝwritigǝ tǝgmǝ; xundaⱪla uning oƣlining ⱪizi wǝ ⱪizining ⱪizinimu hotunluⱪⱪa elip ǝwritigǝ tǝgmǝ. Ular bir-birigǝ yeⱪin tuƣⱪan bolƣaqⱪa, mundaⱪ ix pǝsǝndiliktur. ");
INSERT INTO uigpin_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Sǝn ayaling ⱨayat waⱪtida, uning aqa-singlisini hotunluⱪⱪa elip ǝwritigǝ tǝgmǝ. Undaⱪ ⱪilsang hotunungƣa kündǝxlik azabini kǝltürisǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Sǝn bir ayalning adǝt kɵrüp napak turƣan waⱪtida yeⱪinliⱪ ⱪilip ǝwritigǝ tǝgmǝ.    ");
INSERT INTO uigpin_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Sǝn ɵz ⱪoxnangning ayali bilǝn zina ⱪilip ɵzüngni uning bilǝn napak ⱪilma. ");
INSERT INTO uigpin_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Sǝn ɵz nǝslingdin ⱨeqbirini Molǝk mǝbudiƣa atap ottin ɵtküzsǝng ⱪǝt’iy bolmaydu. Əgǝr xundaⱪ ⱪilsang Hudayingning namini napak ⱪilƣan bolisǝn. Mǝn Ɵzüm Pǝrwǝrdigardurmǝn.    ");
INSERT INTO uigpin_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Sǝn ayallar bilǝn birgǝ bolƣandǝk ǝr kixi bilǝn birgǝ bolma. Bu ix yirginqliktur. ");
INSERT INTO uigpin_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Sǝn ⱨeq ⱨaywan bilǝn munasiwǝt ⱪilip ɵzüngni napak ⱪilma; xuningdǝk ayal kiximu munasiwǝt ⱪildurux üqün bir ⱨaywanning aldiƣa barmisun. Bu ix nijisliⱪtur. ");
INSERT INTO uigpin_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Silǝr bu ixlarni ⱪilip ɵzünglarni napak ⱪilmanglar, qünki mǝn silǝrning aldinglardin qiⱪiriwatⱪan taipilǝr bolsa xundaⱪ ixlarni ⱪilip ɵzlirini napak ⱪilƣan ");
INSERT INTO uigpin_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","wǝ zeminimu napak bolƣandur. Buning üqün Mǝn u zeminning ⱪǝbiⱨlikini ɵz bexiƣa qüxürimǝn, xuningdǝk u zeminmu ɵzidǝ turuwatⱪanlarni ⱪusup qiⱪiriwetidu. ");
INSERT INTO uigpin_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Lekin silǝr bolsanglar Mening bǝlgilimilirim bilǝn ⱨɵkümlirimni tutunglar; silǝrdin ⱨeqkim, mǝyli yǝrlik yaki aranglarda turuwatⱪan yaⱪa yurtluⱪ bolsun bu yirginqlik ixlardin ⱨeqbirini ⱪilmisun ");
INSERT INTO uigpin_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(qünki bu barliⱪ yirginqlik ixlarni silǝrdin ilgiri xu zeminda turƣan hǝlⱪ ⱪilip kǝlgǝqkǝ, zeminning ɵzi napak bolup ⱪaldi). ");
INSERT INTO uigpin_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Xundaⱪ ⱪilip zeminni napak ⱪilsanglar, zemin ɵzi silǝrdin ilgiri ɵzidǝ turƣan ǝllǝrni ⱪusup qiⱪarƣandǝk, silǝrnimu ⱪusup qiⱪiriwetidu. ");
INSERT INTO uigpin_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Qünki bu yirginqlik ixlarning ⱨǝrⱪandiⱪini ⱪilƣuqi, — mundaⱪ ⱪilmixlarni ⱪilƣan ⱨǝrⱪandaⱪ kixi ɵz hǝlⱪi arisidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Silǝr Mǝn silǝrgǝ tapiliƣinimƣa ǝmǝl ⱪilixinglar zɵrürdur; — demǝk, silǝr ɵzünglardin ilgiri ɵtkǝnlǝr tutⱪan xu yirginqlik rǝsim-ⱪaidilǝrni tutup, ɵzünglarni napak ⱪilmasliⱪinglar kerǝk. Mǝn Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Sǝn Israillarning pütkül jamaitigǝ sɵz ⱪilip ularƣa mundaⱪ degin: — «Mǝn Hudayinglar Pǝrwǝrdigar muⱪǝddǝs bolƣaqⱪa, silǝrmu muⱪǝddǝs boluxunglar kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Silǝr ⱨǝrbiringlar ananglar bilǝn atanglarni izzǝtlǝnglar; Mening xabat künlirimni bolsa, ularni tutuxunglar kerǝk. Mǝn ɵzüm Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Silǝr ǝrzimǝs butlarƣa tayanmanglar, ɵzünglar üqün ⱪuyma butlarni yasimanglar. Mǝn ɵzüm Hudayinglar Pǝrwǝrdigardurmǝn.    ");
INSERT INTO uigpin_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Silǝr Pǝrwǝrdigarƣa inaⱪliⱪ ⱪurbanliⱪini kǝltürüxni halisanglar, ⱪobul ⱪilinƣudǝk yol bilǝn uni sununglar. ");
INSERT INTO uigpin_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Silǝr uni sunƣan küni wǝ ǝtisi u yeyilsun; üqinqi künigǝ ⱪalƣini bolsa otta kɵydürülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Əgǝr uningdin bir ⱪismi üqinqi küni yeyilsǝ ⱪurbanliⱪ ⱨaram ⱨesablinip ⱪobul ⱪilinmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Kimki uningdin yesǝ ɵz gunaⱨini ɵz üstigǝ alidu, qünki u Pǝrwǝrdigarƣa atap muⱪǝddǝs ⱪilinƣan nǝrsini napak ⱪildi; undaⱪ kixi ɵz hǝlⱪidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Silǝr zemininglardiki ⱨosulni yiƣsanglar, sǝn etizingning bulung-puxⱪaⱪliriƣiqǝ tamam yiƣiwalma wǝ ⱨosulungdin ⱪalƣan wasangni teriwalmiƣin. ");
INSERT INTO uigpin_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Üzüm talliringni pasangdiwatma wǝ üzüm talliridin qüxkǝn üzümlǝrnimu teriwalma, bǝlki bularni kǝmbǝƣǝllǝr bilǝn musapirlarƣa ⱪoyƣin. Mǝn Ɵzüm Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Silǝr oƣriliⱪ ⱪilmanglar, aldamqiliⱪ ⱪilmanglar, bir-biringlarƣa yalƣan sɵzlimǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Mening namim bilǝn yalƣan ⱪǝsǝm iqmǝnglar, undaⱪ ⱪilsang Hudayingning namini bulƣaysǝn. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ɵz ⱪoxnangƣa zulum ⱪilma, uningkini ɵzüngning ⱪiliwalma. Mǝdikarning ⱨǝⱪⱪini keqiqǝ yeningda ⱪondurup ⱪalma. ");
INSERT INTO uigpin_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Gas kixini tillima, kor kixining aldida putlixangƣu nǝrsini ⱪoyma; bǝlki ɵz Hudayingdin ⱪorⱪⱪin. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ⱨɵküm ⱪilƣininglarda ⱨeq naⱨǝⱪliⱪ ⱪilmanglar; namratⱪimu yan basmay, bayƣimu yüz-hatirǝ ⱪilmay, bǝlki adilliⱪ bilǝn ɵz ⱪoxnang üstidin toƣra ⱨɵküm ⱪilƣin. ");
INSERT INTO uigpin_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ɵz hǝlⱪingning arisida gǝp toxuƣuqi bolup yürmǝ; ⱪoxnangning jeniƣa ⱨeqⱪandaⱪ ziyan-zǝhmǝt yǝtküzmǝ. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Sǝn kɵnglüngdǝ ɵz ⱪerindixingdin nǝprǝtlǝnmigin; ⱪoxnangda gunaⱨ bolsa sǝn uning sǝwǝbidin bexingƣa gunaⱨ kelip ⱪalmasliⱪi üqün uningƣa tǝnbiⱨ-nǝsiⱨǝt bǝrgin. ");
INSERT INTO uigpin_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Sǝn intiⱪam almiƣin wǝ ɵz hǝlⱪingning nǝsligǝ ⱨeq adawǝtmu saⱪlimiƣin, bǝlki ⱪoxnangni ɵzüngni sɵygǝndǝk sɵygin. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Silǝr Mening ⱪanun-bǝlgilimilirimni tutunglar. Sǝn ɵz qarpayliringni baxⱪa nǝsillǝr bilǝn qepixturma, etizingƣa ikki hil uruⱪ salmiƣin, ikki hil yiptin toⱪulƣan kiyimni kiymǝ. ");
INSERT INTO uigpin_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Əgǝr bir ǝr kixi ⱪiz-qokan bilǝn yetip munasiwǝt ɵtküzsǝ, wǝ u baxⱪa biri bilǝn wǝdilǝxkǝn dedǝk bolsa, bu dedǝkning ⱨɵrlük puli tapxurulmiƣan bolsa, yaki uningƣa ⱨɵrlük berilmigǝn bolsa, muwapiⱪ jaza berilsun. Lekin ⱪiz-qokan ⱨɵr ⱪilinmiƣaqⱪa, ⱨǝr ikkisi ɵltürülmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ər kixi bolsa ɵzining itaǝtsizlik ⱪurbanliⱪini jamaǝt qedirining kirix aƣzining aldiƣa, Pǝrwǝrdigarning aldiƣa kǝltürsun; itaǝtsizlik ⱪurbanliⱪi bir ⱪoqⱪar bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kaⱨin u itaǝtsizlik ⱪurbanliⱪi üqün kǝltürgǝn ⱪoqⱪarni elip uning sadir ⱪilƣan gunaⱨi üqün Pǝrwǝrdigarning aldida kǝfarǝt kǝltüridu; uning ⱪilƣan gunaⱨi uningdin kǝqürülidu. ");
INSERT INTO uigpin_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Silǝr zeminƣa kirip ⱨǝrhil yǝydiƣan mewilik dǝrǝhlǝrni tikkǝn bolsanglar, mewilirini «hǝtnisiz» dǝp ⱪaranglar; üq yilƣiqǝ buni «hǝtnisiz» dǝp ⱪarap uningdin yemǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Tɵtinqi yili ularning ⱨǝmmǝ mewiliri Pǝrwǝrdigarƣa mǝdⱨiyǝ süpitidǝ muⱪǝddǝs ⱪilip beƣixlansun. ");
INSERT INTO uigpin_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Andin bǝxinqi yildin tartip silǝr ularning mewiliridin yeyixkǝ baxlanglar. Xundaⱪ ⱪilsanglar zemin mǝⱨsulatlirini silǝrgǝ ziyadǝ ⱪilidu. Mǝn Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Silǝr ⱪan qiⱪmiƣan nǝrsini yemǝnglar. Nǝ palqiliⱪ nǝ jadugǝrlik ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Silǝr bexinglarning qekǝ-qɵrisidiki qaqni qüxürüp dügilǝk ⱪiliwalmanglar, saⱪalning uq-yanlirini buzmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Silǝr ɵlgǝnlǝr üqün bǝdininglarni zǝhim yǝtküzüp tilmanglar, ɵzünglarƣa ⱨeqⱪandaⱪ gül-sürǝt qǝkmǝnglar. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Sǝn ⱪizingni buzuⱪluⱪ-paⱨixilikkǝ selip napak ⱪilmiƣin. Bolmisa, zemindikilǝr buzuⱪluⱪ-paⱨixilikkǝ berilip, pütkül zeminni ǝyx-ixrǝt ⱪaplap ketidu. ");
INSERT INTO uigpin_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Silǝr Mening xabat künlirimni tutunglar, Mening muⱪǝddǝs jayimni ⱨɵrmǝtlǝnglar. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Jinkǝxlǝr bilǝn seⱨirgǝrlǝrgǝ tayanmanglar, ularning kǝynidin yürüp ɵzünglarni napak ⱪilmanglar. Mǝn ɵzüm Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Aⱪ bax kixining aldida ornungdin tur, ⱪerilarni ⱨɵrmǝt ⱪilƣin; Hudayingdin ⱪorⱪⱪin. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Bir musapir zeminda aranglarda turuwatⱪan bolsa silǝr uningƣa zulum ⱪilmanglar, ");
INSERT INTO uigpin_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","bǝlki aranglarda turuwatⱪan musapir silǝrgǝ yǝrlik kixidǝk bolsun; uni ɵzüngni sɵygǝndǝk sɵygin; qünki silǝrmu Misir zeminida musapir bolƣansilǝr. Mǝn Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Silǝrning ⱨɵküm qiⱪirixinglarda, uzunluⱪ, eƣirliⱪ wǝ ⱨǝjim ɵlqǝxtǝ ⱨeqⱪandaⱪ naⱨǝⱪlik bolmisun; ");
INSERT INTO uigpin_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","silǝrdǝ adil taraza, adil taraza taxliri, adil ǝfaⱨ kǝmqini bilǝn adil ⱨin kǝmqini bolsun. Mǝn silǝrni Misir zeminidin qiⱪirip kǝlgǝn Hudayinglar Pǝrwǝrdigardurmǝn.    ");
INSERT INTO uigpin_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Silǝr Mening barliⱪ ⱪanun-bǝlgilimilirim wǝ barliⱪ ⱨɵkümlirimni tutup, ularƣa ǝmǝl ⱪilinglar; mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Sǝn Israillarƣa sɵz ⱪilip mundaⱪ degin: — Əgǝr Israillarning biri wǝ yaki Israil zeminida turuwatⱪan musapirlarning biri Molǝk butiƣa nǝslining birini beƣixlisa, uningƣa ɵlüm jazasi berilixi kerǝk; zemindikilǝr uni qalma-kesǝk ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Wǝ Mǝn Ɵz yüzümni bu kixigǝ ⱪarxi ⱪilimǝn, qünki ɵzi ɵz ǝwladlirining birini Molǝk butiƣa beƣixlap muⱪǝddǝs jayimni paskina ⱪilip, Mening namimni bulƣiƣini üqün uni ɵz hǝlⱪidin üzüp taxlaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Əgǝr zeminda turuwatⱪanlar ɵz nǝslidin birini Molǝkkǝ beƣixliƣanda xu kixigǝ kɵzlirini yumup, uning bilǝn kari bolmisa, xundaⱪla uni ɵltürmisǝ, ");
INSERT INTO uigpin_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Mǝn Ɵzüm yüzümni u kixi bilǝn uning ailisigǝ ⱪarxi ⱪilimǝn, uni wǝ uningƣa ǝgixip buzuⱪqiliⱪ ⱪilƣuqilar, yǝni Molǝkning kǝynidin yürüp buzuⱪqiliⱪ ⱪilƣuqilarning ⱨǝmmisini ɵz hǝlⱪidin üzüp taxlaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Jinkǝxlǝr bilǝn seⱨirgǝrlǝrgǝ tayinip, ularning kǝynigǝ kirip buzuⱪqiliⱪ ⱪilip yürgüqilǝr bolsa, Mǝn yüzümni xu kixilǝrgǝ ⱪarxi ⱪilip, uni ɵz hǝlⱪidin üzüp taxlaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Xunga ɵzünglarni pak ⱪilip muⱪǝddǝs bolunglar, qünki Mǝn Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ⱪanun-bǝlgilimilirimni tutup, ularƣa ǝmǝl ⱪilinglar; Mǝn bolsam silǝrni muⱪǝddǝs ⱪilƣuqi Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Əgǝr birkim ɵz atisi yaki anisini ⱪarƣisa, ularƣa ɵlüm jazasi berilmisǝ bolmaydu; qünki u ɵz ata-anisini ⱪarƣiƣini üqün ɵz ⱪeni ɵz bexiƣa qüxkǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Əgǝr birkim baxⱪisining ayali bilǝn zina ⱪilsa, yǝni ɵz ⱪoxnisining ayali bilǝn zina ⱪilsa, zina ⱪilƣan ǝr bilǝn ayal ikkisi ɵlüm jazasini tartmisa bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Əgǝr birsi atisining ayali bilǝn yatsa, ɵz atisining ǝwritigǝ tǝgkǝn bolidu; ular ikkisi ɵlüm jazasini tartmisa bolmaydu; ularning ⱪeni ɵz bexiƣa qüxkǝn bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Birsi ɵz kelini bilǝn yatsa, ikkisi nijisliⱪ ⱪilƣini üqün ɵlüm jazasini tartmisa bolmaydu; ularning ⱪeni ɵz bexiƣa qüxkǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Birsi ayal kixi bilǝn yatⱪandǝk ǝr kixi bilǝn yatsa ikkisi yirginqlik ix ⱪilƣan bolidu; ularƣa ɵlüm jazasi berilmisǝ bolmaydu. Ɵz ⱪeni ɵz bexiƣa qüxkǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Əgǝr birsi ⱪizi bilǝn anisini ⱪoxup hotunluⱪⱪa alsa pǝsǝndilik ⱪilƣan bolidu. Ər bilǝn ikki ayal otta kɵydürülsun. Xuning bilǝn aranglarda ⱨeq pǝsǝndilik ix bolmaydu.    ");
INSERT INTO uigpin_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Birsi bir ⱨaywan bilǝn munasiwǝt ɵtküzsǝ, u ɵlüm jazasini tartsun, ⱨaywannimu ɵlturünglar. ");
INSERT INTO uigpin_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Əgǝr ayal kixi bir ⱨaywanning ⱪexiƣa berip munasiwǝt ⱪildursa, ayal bilǝn ⱨaywanning ikkisini ɵltürünglar; ɵz ⱪeni ɵz bexiƣa qüxkǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Birsi aqa-singlisini, yǝni atisidin yaki anisidin bolƣan ⱪizni elip, ǝwritigǝ tǝgsǝ wǝ bu ⱪizmu uning ǝwritigǝ tǝgsǝ uyatliⱪ ix bolidu; xuning üqün ǝr-ayal ikkisi ɵz hǝlⱪining kɵz aldidin üzüp taxlansun; u ɵz aqa yaki singlisining ǝwritigǝ tǝgkǝqkǝ, ɵz ⱪǝbiⱨliki ɵz bexiƣa qüxkǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Birsi adǝt kɵrgǝn aƣriⱪ waⱪtida bir ayal bilǝn birgǝ yetip, uning ǝwritigǝ tǝgsǝ, undaⱪta u uning ⱪan mǝnbǝsigǝ tǝgkǝn, ayalmu ⱪan mǝnbǝsini eqip bǝrgǝn bolup, ikkisi ɵz hǝlⱪidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Sǝn ɵz anangning aqa-singlisi wǝ atangning aqa-singlisining ǝwritigǝ tǝgmǝ; qünki kimki xundaⱪ ⱪilsa yeⱪin tuƣⱪinining ǝwritigǝ tǝgkǝn bolidu; ular ikkilisining ɵz ⱪǝbiⱨliki ɵz bexiƣa qüxkǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Birsi taƣisining ayali bilǝn yatsa taƣisining ǝwritigǝ tǝgkǝn bolidu; ikkilisi ɵz gunaⱨini ɵz bexiƣa alidu; ular pǝrzǝntsiz ɵlidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Birsi aka-inisining ayalini alsa paskina bir ix bolidu. U ɵz birtuƣⱪan aka-inisining ǝwritigǝ tǝgkǝn bolidu; ular ikkilisi pǝrzǝntsiz ⱪalidu.    ");
INSERT INTO uigpin_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Silǝr Mening barliⱪ ⱪanun bǝlgilimilirim bilǝn barliⱪ ⱨɵkümlirimni tutup, buningƣa muwapiⱪ ǝmǝl ⱪilinglar; bolmisa, Mǝn silǝrni elip berip turƣuzidiƣan zemin silǝrni ⱪusup qiⱪiriwetidu. ");
INSERT INTO uigpin_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Silǝr Mǝn aldinglardin ⱨǝydiwetidiƣan ǝllǝrning rǝsim-ⱪaidiliri boyiqǝ mangsanglar bolmaydu; qünki ular bu yirginqlik ixlarning ⱨǝmmisini ⱪilip kǝldi, wǝ xuning üqün ular Manga yirginqlik boldi. ");
INSERT INTO uigpin_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Xuning üqün Mǝn silǝrgǝ: «Silǝr ularning zeminini miras ⱪilip alisilǝr; Mǝn xu süt bilǝn ⱨǝsǝl aⱪidiƣan zeminni silǝrgǝ berimǝn», dǝp eytⱪanidim; silǝrni baxⱪa hǝlⱪlǝrdin ayrim ⱪilƣan Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Xunga silǝr pak wǝ napak qarpaylarni pǝrⱪ etip, pak wǝ napak uqar-ⱪanatlarni tonup, Mǝn silǝr üqün ayrip, napak ⱪilip bekitip bǝrgǝn janiwarlarning iqidin ⱨǝrⱪandiⱪi, qarpay yaki uqar-ⱪanat bolsun yaki yǝrdǝ ɵmiligüqi janiwar bolsun, ularning ⱨeqbiri bilǝn ɵzünglarni napak ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Silǝr Manga has pak-muⱪǝddǝs boluxunglar kerǝk; qünki Mǝn Pǝrwǝrdigar pak-muⱪǝddǝsturmǝn, silǝrni Manga has bolsun dǝp barliⱪ ǝllǝrdin ayrim ⱪilƣanmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Jinkǝx yaki seⱨirgǝr bolƣan ⱨǝrⱪandaⱪ ǝr yaki hotun kixigǝ ɵlüm jazasi berilmisǝ bolmaydu; hǝlⱪ ularni qalma-kesǝk ⱪilsun; ularning ⱪeni ɵz bexiƣa qüxkǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — Sǝn kaⱨinlar bolƣan Ⱨarunning oƣulliriƣa mundaⱪ degin: — bir kaⱨin ɵz hǝlⱪining arisidiki ɵlgǝnlǝr wǝjidin ɵzini napak ⱪilmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Pǝⱪǝt ɵzining yeⱪin tuƣⱪanliri üqün — anisi bilǝn atisi, oƣli bilǝn ⱪizi wǝ aka-inisining ɵlüki tüpǝylidin ɵzini napak ⱪilsa bolidu; ");
INSERT INTO uigpin_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","xuningdǝk ǝgǝr aqa-singlisi ǝrgǝ tǝgmǝy pak ⱪiz ⱨalǝttǝ ɵzi bilǝn billǝ turuwatⱪan bolsa, uning ɵlüki tüpǝylidin ɵzini napak ⱪilsa bolidu; ");
INSERT INTO uigpin_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","qünki kaⱨin ɵz hǝlⱪining arisida mɵtiwǝr bolƣaqⱪa, ɵzini napak ⱪilip bulƣimasliⱪi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Kaⱨinlar bexini yerim-yata ⱪilip qüxürmǝsliki, saⱪilining uq-yanlirini ⱨǝm qüxürmǝsliki, bǝdinigimu zǝhim yǝtküzüp tilmasliⱪi kerǝk, ");
INSERT INTO uigpin_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","bǝlki ular ɵz Hudasiƣa muⱪǝddǝs turup, Hudasining namini bulƣimasliⱪi kerǝk; qünki ular Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱪurbanliⱪlarni, ɵz Hudasining nenini sunidu; xunga ular muⱪǝddǝs boluxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ular bir ayalni ɵz ǝmrigǝ alƣanda paⱨixǝ ayalnimu, buzuⱪ ayalnimu almasliⱪi kerǝk wǝ eri ⱪoyuwǝtkǝn ayalnimu almisun. Qünki kaⱨin bolsa ɵz Hudasiƣa has muⱪǝddǝs ⱪilinƣan. ");
INSERT INTO uigpin_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","U Hudayingning nenini sunƣini üqün u sanga nisbǝtǝn muⱪǝddǝs dǝp sanilixi kerǝk; qünki silǝrni muⱪǝddǝs ⱪilƣuqi Pǝrwǝrdigar Ɵzüm muⱪǝddǝsturmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Əgǝr bir kaⱨinning ⱪizi paⱨixilik ⱪilip ɵzini bulƣiƣan ⱪilsa, ɵz atisini bulƣiƣan bolidu; u otta kɵydürülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Bexiƣa mǝsiⱨlǝx zǝytun meyi tɵkülgǝn, kaⱨinliⱪ kiyimlǝrni kiyixkǝ tiklǝngǝn, ɵz ⱪerindaxlirining arisida bax kaⱨin ⱪilinƣan kixi yalangbax bolmisun, kiyimlirinimu yirtmisun; ");
INSERT INTO uigpin_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","U yǝnǝ ⱨeq ɵlükkǝ yeⱪinlaxmasliⱪi kerǝk, ⱨǝtta atisi wǝ yaki anisining ɵlüklirining wǝjidin ɵzini napak ⱪilmasliⱪi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","U wǝzipisidǝ turuwatⱪanda muⱪǝddǝs jaydin ⱨǝrgiz ayrilmisun wǝ xuningdǝk Hudasining muⱪǝddǝs jayini bulƣimasliⱪi kerǝk; qünki uning Hudasining uni Ɵzigǝ has ⱪilƣan «mǝsiⱨlǝx meyi» uning bexida turidu. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","U hotun alsa pak ⱪizni elixi kerǝk; ");
INSERT INTO uigpin_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","tul wǝ yaki ǝrdin ⱪoyuwetilgǝn ayal wǝ yaki buzuⱪ wǝ yaki paⱨixǝ ayal bolsa bularni almasliⱪi, bǝlki ɵz hǝlⱪidin bolƣan pak ⱪizni hotunluⱪⱪa elixi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Bolmisa u ɵz hǝlⱪining arisida ɵz uruⱪini napak ⱪilidu; qünki uni muⱪǝddǝs ⱪilƣuqi Pǝrwǝrdigar Mǝndurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Sǝn Ⱨarunƣa mundaⱪ degin: — «Əwladtin-ǝwladⱪiqǝ sening nǝslingdin bolƣan birsi meyip bolsa, Hudaning nenini sunux üqün yeⱪin kǝlmisun; ");
INSERT INTO uigpin_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","meyip bolƣan ⱨǝrⱪandaⱪ kixi ⱨǝrgiz yeⱪin kǝlmisun — yaki kor bolsun, tokur bolsun, panaⱪ bolsun yaki bir ǝzasi yǝnǝ bir jüpidin uzun bolƣan adǝm bolsun, ");
INSERT INTO uigpin_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","puti yaki ⱪoli sunuⱪ bolsun, ");
INSERT INTO uigpin_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","dok bolsun, parpa bolsun, kɵzidǝ aⱪ bolsun, ⱪiqixⱪaⱪ bolƣan bolsun, tǝmrǝtkǝ basⱪan bolsun yaki uruⱪdeni ezilgǝn ⱨǝrkim bolsun, ");
INSERT INTO uigpin_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ⱨarun kaⱨinning nǝslidin bolƣan undaⱪ meyip kixilǝrning ⱨeqbiri Pǝrwǝrdigarƣa atap otta sunulidiƣan nǝrsilǝrni kǝltürüxkǝ yeⱪin barmisun; undaⱪ kixi meyiptur; u ɵz Hudasining nenini sunuxⱪa yeⱪin kǝlmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ⱨalbuki, u ɵz Hudasining nenini, yǝni «ǝng muⱪǝddǝs» wǝ «muⱪǝddǝs» ⱨesablanƣan nǝrsilǝrning ⱨǝr ikkisidin yesun. ");
INSERT INTO uigpin_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Pǝⱪǝt u pǝrdidin ɵtüp iqkirisigǝ kirmǝsliki yaki ⱪurbangaⱨⱪimu yeⱪin barmasliⱪi kerǝk; qünki u meyiptur; bolmisa, u Mening muⱪǝddǝs jaylirimni bulƣiƣan bolidu; qünki ularni muⱪǝddǝs ⱪilƣuqi Pǝrwǝrdigar Ɵzümdurmǝn». ");
INSERT INTO uigpin_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Bu sɵzlǝrning ⱨǝmmisini Musa Ⱨarun bilǝn uning oƣulliri wǝ Israillarning ⱨǝmmisigǝ eytip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Sǝn Ⱨarun bilǝn uning oƣulliriƣa mundaⱪ degin: — «Silǝr Israillarning Manga atiƣan muⱪǝddǝs ⱨǝdiyǝlǝrni eⱨtiyatqanliⱪ bilǝn bir tǝrǝp ⱪilinglar, bolmisa ular namimni bulƣixi mumkin. Mǝn Pǝrwǝrdigardurmǝn». ");
INSERT INTO uigpin_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ularƣa mundaⱪ degin: — «Silǝr ⱨǝrbir dǝwrlǝrdǝ, barliⱪ nǝsillinglardin ⱨǝrⱪaysisi Israillar Pǝrwǝrdigarƣa atiƣan pak nǝrsilǝrgǝ napak ⱨalǝttǝ yeⱪinlaxsa, undaⱪ kixi Mening aldimdin üzüp taxlinidu. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ⱨarunning nǝslidin biri pesǝ-mahaw yaki aⱪma kesili bolƣan bolsa, pak bolmiƣuqǝ muⱪǝddǝs nǝrsilǝrdin yemisun. Birkim ɵlükning sǝwǝbidin napak bolƣan birkimgǝ wǝ yaki mǝniysi eⱪip kǝtkǝn kixigǝ tegip kǝtsǝ, ");
INSERT INTO uigpin_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","yaki adǝmni napak ⱪilidiƣan ɵmiligüqi janiwarƣa tǝgsǝ yaki ⱨǝrⱪandaⱪ yuⱪup ⱪalidiƣan napakliⱪi bar bir adǝmgǝ tegip kǝtsǝ, (napakliⱪi nemidin boluxidin ⱪǝt’iynǝzǝr) ");
INSERT INTO uigpin_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","mundaⱪ nǝrsilǝrgǝ tǝgkǝn kixi kǝq kirgüqǝ napak bolup, muⱪǝddǝs nǝrsilǝrdin yemisun. U bǝdinini suda yusun ");
INSERT INTO uigpin_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","andin kün olturƣanda pak sanilip, muⱪǝddǝs nǝrsilǝrdin yeyixkǝ bolidu; qünki bular uning ozuⱪidur. ");
INSERT INTO uigpin_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","U ɵzlükidin ɵlgǝn wǝ yaki yirtⱪuqlar boƣup ⱪoyƣan ⱨaywanni yeyix bilǝn ɵzini napak ⱪilmisun. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ular Mening bu tapiliƣanlirimni tutuxi kerǝk; bolmisa, buningƣa ihlassizliⱪ ⱪilsa, xu ɵlük tüpǝylidin gunaⱨkar bolup ɵlidu; ularni muⱪǝddǝs ⱪilƣuqi Pǝrwǝrdigar Ɵzümdurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kaⱨinlarƣa yat bolƣan ⱨeqⱪandaⱪ kixi muⱪǝddǝs nǝrsilǝrdin yemisun. Kaⱨinning yenidiki musapir-meⱨman wǝ yaki mǝdikari bolsun ularmu muⱪǝddǝs nǝrsilǝrdin yemisun. ");
INSERT INTO uigpin_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ⱨalbuki, kaⱨin ɵzi pul qiⱪirip setiwalƣan ⱪul uningdin yeyixkǝ bolidu; xuningdǝk uning ɵyidǝ tuƣulƣan kiximu uningdin yesǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kaⱨinning ⱪizi yat kixigǝ tǝgkǝn bolsa umu «kɵtürmǝ ⱨǝdiyǝ» süpitidǝ atalƣan muⱪǝddǝs nǝrsilǝrdin yemisun. ");
INSERT INTO uigpin_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Lekin ǝgǝr kaⱨinning ⱪizi tul bolup ⱪelip, yaki ⱪoyup berilip pǝrzǝntsiz ⱨalǝttǝ atisining ɵyigǝ yenip kelip, yax waⱪtidikidǝk olturƣan bolsa, undaⱪta atisining taamidin yeyǝlǝydu; lekin ⱨeqbir yat kixi uningdin yemǝsliki kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Əgǝr birkim bilmǝy, muⱪǝddǝs nǝrsilǝrdin yǝp salsa, undaⱪta u uningƣa xuning bǝxtin birini ⱪoxup, muⱪǝddǝs nǝrsining ɵzi bilǝn kaⱨinƣa ⱪayturup bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kaⱨinlar Israillarning Pǝrwǝrdigarƣa atiƣan nǝrsilirini bulƣimasliⱪi kerǝk; ");
INSERT INTO uigpin_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","bolmisa, hǝlⱪ muⱪǝddǝs ⱨǝdiyilǝrdin yeyixi bilǝn, kaⱨinlar hǝlⱪning gǝdinigǝ itaǝtsizlik gunaⱨini yüklǝp ⱪoyƣan bolidu; qünki ularni muⱪǝddǝs ⱪilƣuqi Pǝrwǝrdigar Ɵzümdurmǝn». ");
INSERT INTO uigpin_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Sǝn Ⱨarun bilǝn uning oƣulliri wǝ Israillarning ⱨǝmmisigǝ mundaⱪ degin: — Əgǝr Israil jǝmǝtidin biri wǝ yaki Israil zeminida turuwatⱪan musapirlarning biri ɵz ⱪǝsǝmlirigǝ baƣliⱪ ⱪurbanliⱪ yaki ihtiyariy ⱪurbanliⱪni sunup, Pǝrwǝrdigarƣa atap kɵydürmǝ ⱪurbanliⱪ ⱪilmaⱪqi bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","undaⱪta u ⱪobul ⱪilinixi üqün bejirim ǝrkǝk kala, ⱪoy yaki ɵqkilǝrdin kǝltürünglar. ");
INSERT INTO uigpin_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Əyibi bolmiƣan bir janiwarni sunuxunglar kerǝk; qünki xundaⱪ bolƣini silǝr üqün ⱪobul ⱪilinmas. ");
INSERT INTO uigpin_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Birsi kalilardin yaki uxxaⱪ maldin ɵz ⱪǝsǝmlirigǝ baƣliⱪ ⱪurbanliⱪ yaki ihtiyariy ⱪurbanliⱪni sunup, Pǝrwǝrdigarƣa atap inaⱪliⱪ ⱪurbanliⱪi ⱪilmaⱪqi bolsa, sunulƣan ⱨaywan ⱪobul ⱪilinixi üqün bejirim boluxi kerǝk; uning ⱨeqⱪandaⱪ ǝyibi bolmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kor yaki aⱪsaⱪ-qolaⱪ, qonaⱪ yaki yarisi yiringdap kǝtkǝn, tǝmrǝtkǝ basⱪan yaki ⱪotur-qaⱪa besip ⱪalƣan ⱨaywanlar bolsa — bularni Pǝrwǝrdigarƣa atap sunsanglar yaki bularni Pǝrwǝrdigarƣa atap ⱪurbanliⱪ süpitidǝ ⱪurbangaⱨta otta kɵydürsǝnglar bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Torpaⱪ yaki ⱪoyning mǝlum jüp ǝzasidin biri uzunraⱪ ya ⱪisⱪa bolsa, mundaⱪlarni ihtiyariy ⱪurbanliⱪ süpitidǝ ɵtküzsǝng bolidu, lekin ⱪǝsǝmgǝ baƣliⱪ bolsa ⱪurbanliⱪ üqün ⱪobul ⱪilinmas. ");
INSERT INTO uigpin_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Uruⱪdini zǝhimlǝngǝn, ezilip kǝtkǝn, yerilƣan yaki piqilƣan ⱨaywanni Pǝrwǝrdigarƣa atap ⱪurbanliⱪ ⱪilmanglar. Mundaⱪ ixni ɵz zemininglardimu ⱨǝrgiz ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Hudayinglarning neni süpitidǝ yaⱪa yurtluⱪ kixining ⱪolidin xundaⱪ ⱨaywanlardin ⱨeqⱪaysisini elip sunmanglar; qünki ular meyip bolƣaqⱪa, silǝr üqün ⱪobul ⱪilinmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Bir mozay, ⱪoza yaki oƣlaⱪ tuƣulsa yǝttǝ küngiqǝ anisini ǝmsun; sǝkkizinqi künidin baxlap Pǝrwǝrdigarƣa atap otta sunidiƣan ⱪurbanliⱪ süpitidǝ ⱪobul boluxⱪa yaraydu. ");
INSERT INTO uigpin_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Mǝyli kala bolsun, ⱪoy bolsun, silǝr anisi bilǝn balisini bir kündǝ boƣuzlimanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Silǝr Pǝrwǝrdigarƣa atap bir tǝxǝkkür ⱪurbanliⱪi sunmaⱪqi bolsanglar, ⱪobul ⱪilinixⱪa layiⱪ bolƣan yol bilǝn sununglar. ");
INSERT INTO uigpin_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","U sunulƣan künidǝ yeyilixi kerǝk; uningdin ⱨeqnemini ǝtisigǝ ⱪaldurmasliⱪinglar kerǝk. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Silǝr Mening ǝmrlirimni qing tutup, ularƣa ǝmǝl ⱪilinglar. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mening muⱪǝddǝs namimni bulƣimanglar, Mǝn ǝmdi Israillarning arisida muⱪǝddǝs dǝp bilinimǝn. Mǝn silǝrni muⱪǝddǝs ⱪilƣuqi Pǝrwǝrdigar bolup, ");
INSERT INTO uigpin_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Hudayinglar boluxⱪa silǝrni Misir zeminidin qiⱪirip kǝldim. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Sǝn Israillarƣa mundaⱪ degin: — Pǝrwǝrdigar bekitkǝn ⱨeytlar, silǝr muⱪǝddǝs sorunlar bolsun dǝp qaⱪirip jakarlaydiƣan ⱨeytlirim mana munulardur: — ");
INSERT INTO uigpin_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","(altǝ kün ix-ǝmgǝk ⱪilinsun; lekin yǝttinqi küni «has xabat küni», muⱪǝddǝs sorunlar küni bolidu; u küni ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar. Ⱪǝyǝrdila tursanglar bu kün Pǝrwǝrdigarƣa atalƣan xabat küni bolidu).    ");
INSERT INTO uigpin_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Silǝr bekitilgǝn künliri muⱪǝddǝs sorunlar bolsun dǝp qaⱪirip jakarlaydiƣan, Pǝrwǝrdigarning ⱨeytliri mana munulardur: — ");
INSERT INTO uigpin_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Birinqi ayning on tɵtinqi küni gugumda Pǝrwǝrdigarƣa atalƣan «ɵtüp ketix ⱨeyti» bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Xu ayning on bǝxinqi küni Pǝrwǝrdigarƣa atalƣan «petir nan» ⱨeyti bolidu; silǝr yǝttǝ küngiqǝ petir nan yǝysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Birinqi künidǝ silǝr muⱪǝddǝs yiƣilix ⱪilip, ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Silǝr yǝttǝ küngiqǝ Pǝrwǝrdigarƣa atap otta sunidiƣan ⱪurbanliⱪlarni sunup turunglar. Yǝttinqi künidǝ muⱪǝddǝs yiƣilix bolidu; ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Sǝn Israillarƣa mundaⱪ degin: — Silǝr Mǝn ɵzünglarƣa tǝⱪdim ⱪilidiƣan zeminƣa kirip, uningdin ⱨosul yiƣⱪininglarda, ⱨosulunglarning dǝslǝpki pixⱪinidin bir baƣlamni kaⱨinning ⱪexiƣa elip beringlar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kaⱨin silǝr üqün ⱪobul boluxⱪa uni Pǝrwǝrdigarning aldida pulanglatsun; uni pulanglatⱪan waⱪit bolsa xabatning ǝtisi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Silǝr uni pulanglatⱪan kündǝ silǝr bir yaxⱪa kirgǝn bejirim bir ⱪozini Pǝrwǝrdigarƣa atap kɵydürmǝ ⱪurbanliⱪ süpitidǝ sununglar; ");
INSERT INTO uigpin_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","xuningƣa ⱪoxup axliⱪ ⱨǝdiyǝsi süpitidǝ zǝytun meyi ilǝxtürülgǝn esil undin bir ǝfaⱨning ondin birini Pǝrwǝrdigarƣa huxbuy kǝltürsun dǝp otta sununglar; buningƣa ⱪoxup xarab ⱨǝdiyǝsi süpitidǝ xarabtin bir ⱨinning tɵttin birini sununglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Silǝr Hudayinglarƣa has bolƣan bu ⱨǝdiyǝni sunidiƣan kündin ilgiri yengi ⱨosuldin ⱨeqnemini, nǝ nan nǝ ⱪomaq nǝ kɵk bax bolsun yemǝnglar. Bu dǝwrdin-dǝwrgiqǝ silǝr üqün ⱪǝyǝrdǝ tursanglar ǝbǝdiy bir bǝlgilimǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Andin silǝr xu xabat künning ǝtisidin, yǝni xu bir baƣlamni pulanglatma ⱨǝdiyǝ süpitidǝ sunƣan künning ǝtisidin tartip, yǝttǝ ⱨǝptǝ sananglar (ular toluⱪ ⱨǝptǝ boluxi kerǝk); ");
INSERT INTO uigpin_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","yǝttinqi xabatning ikkinqi künigiqǝ ǝllik künni sananglar; andin Pǝrwǝrdigarƣa atap yengi ⱨosuldin bir axliⱪ ⱨǝdiyǝsi sununglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ɵzünglar turuwatⱪan jaylardin pulanglatma ⱨǝdiyǝ süpitidǝ esil undin bir ǝfaⱨning ondin ikkisidǝ etilgǝn ikki nanni elip kǝltürünglar; ular eqitⱪu selip etilgǝn bolsun; bular Pǝrwǝrdigarƣa atalƣan dǝslǝpki ⱨosul ⱨǝdiyǝsi dǝp ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Nandin baxⱪa yǝnǝ bir yaxliⱪ yǝttǝ bejirim ⱪoza, yax bir torpaⱪ wǝ ikki ⱪoqⱪarni kɵydürmǝ ⱪurbanliⱪ süpitidǝ Pǝrwǝrdigarƣa atap sununglar; ularƣa has axliⱪ ⱨǝdiyǝliri wǝ xarab ⱨǝdiyǝlirini ⱪoxup, ⱨǝmmisi Pǝrwǝrdigarƣa huxbuy kǝltürüxkǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Buningdin baxⱪa silǝr gunaⱨ ⱪurbanliⱪi üqün bir tekini, inaⱪliⱪ ⱪurbanliⱪi üqün bir yaxliⱪ ikki ⱪozini kǝltürünglar; ");
INSERT INTO uigpin_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","kaⱨin bularni, yǝni xu ikki ⱪozini dǝslǝpki ⱨosul nanliriƣa ⱪoxup pulanglatma ⱨǝdiyǝ süpitidǝ Pǝrwǝrdigar aldida pulanglatsun. Bular bolsa Pǝrwǝrdigarƣa atalƣan muⱪǝddǝs sanilip, kaⱨinƣa tǝgsun. ");
INSERT INTO uigpin_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Xu küni silǝr «bügün bizlǝrgǝ muⱪǝddǝs yiƣilix bolidu» dǝp jakarlanglar; xu küni ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar. Bu silǝr üqün ⱪǝyǝrdila tursanglar ǝbǝdiy bir bǝlgilimǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Etizingning bulung-puqⱪaⱪliriƣiqǝ tamam yiƣiwalmanglar, wǝ ⱨosulungdin ⱪalƣan wasangni teriwalmiƣin, bǝlki bularni kǝmbǝƣǝllǝr bilǝn musapirlarƣa ⱪoyƣin. Mǝn Ɵzüm Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Sǝn Israillarƣa mundaⱪ degin: — Silǝr yǝttinqi ayning birinqi küni toluⱪ aram elip, kanaylar qelinix bilǝn ǝslǝtmǝ yosunda ⱨeyt ⱪilip, muⱪǝddǝs sorunlarni tüzünglar.    ");
INSERT INTO uigpin_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","U kündǝ ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar; Pǝrwǝrdigarƣa atap otta sunulidiƣan bir ⱪurbanliⱪ sununglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Yǝttinqi ayning oninqi küni bolsa kǝfarǝt küni bolidu; u kün silǝr üqün muⱪǝddǝs yiƣilix küni bolidu; xu küni nǝpsinglarni tartip ɵzünglarni tɵwǝn tutup, Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱪurbanliⱪni sununglar;    ");
INSERT INTO uigpin_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","U kündǝ ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar; qünki u bir kǝfarǝt küni bolup, xu kün ɵzünglar üqün Hudayinglar Pǝrwǝrdigar aldida kǝfarǝt ⱪilinixⱪa bekitilgǝndur. ");
INSERT INTO uigpin_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ⱨǝrkim xu küni nǝpsini tartmay ɵzini tɵwǝn tutmisa ɵz hǝlⱪidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Kimdǝkim xu kündimu ⱨǝrⱪandaⱪ bir ix ⱪilsa, Mǝn xu adǝmni ɵz hǝlⱪidin üzüp taxlaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Xu küni ⱨeqⱪandaⱪ ix ⱪilmanglar; bu dǝwrdin-dǝwrgiqǝ silǝr üqün ⱪǝyǝrdǝ tursanglar bir ǝbǝdiy bǝlgilimǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","U kün silǝr üqün toluⱪ aram alidiƣan xabat küni bolidu; nǝpsinglarni tartip ɵzünglarni tɵwǝn tutunglar. Xu ayning toⱪⱪuzinqi küni gugumdin tartip ǝtisi gugumƣiqǝ xabat künigǝ riayǝ ⱪilip aram elinglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Sǝn Israillarƣa mundaⱪ degin: — Yǝttinqi ayning on bǝxinqi künidin baxlap, yǝttǝ küngiqǝ Pǝrwǝrdigarning «kǝpilǝr ⱨeyti» bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Birinqi kündǝ muⱪǝddǝs yiƣilix bolidu; ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Yǝttǝ küngiqǝ Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱪurbanliⱪ sununglar; sǝkkizinqi kündǝ silǝrgǝ muⱪǝddǝs yiƣilix bolidu; Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱪurbanliⱪ sununglar. Bu ɵzi tǝntǝnilik yiƣilix bolƣaq, u küni ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Silǝr «muⱪǝddǝs sorunlar bolsun» dǝp jakarlaydiƣan, yǝni Pǝrwǝrdigar bekitkǝn ⱨeytlar mana xulardur. Xu sorunlarda silǝr ⱨǝrⱪaysi küngǝ bekitilgini boyiqǝ, Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱨǝdiyǝ-ⱪurbanliⱪ, yǝni kɵydürmǝ ⱪurbanliⱪ, axliⱪ ⱨǝdiyǝsi, baxⱪa ⱨǝrhil ⱪurbanliⱪlar wǝ xarab ⱨǝdiyǝlirini sunisilǝr; ");
INSERT INTO uigpin_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","bulardin baxⱪa, Pǝrwǝrdigarning xabat künlirini tutisilǝr wǝ Pǝrwǝrdigarƣa atap ⱪalƣan ⱨǝdiyǝliringlarni berip, ⱪǝsǝm ⱪurbanliⱪliringlarning ⱨǝmmisini ada ⱪilip, ihtiyariy ⱪurbanliⱪliringlarning ⱨǝmmisini sunisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Silǝr ǝmdi zemindin ⱨosul-mǝⱨsulatlirini yiƣip bolup, yǝttinqi ayning on bǝxinqi künidin baxlap yǝttǝ kün Pǝrwǝrdigarning ⱨeytini ɵtküzünglar. Birinqi küni toluⱪ aram elix bolidu, sǝkkizinqi konidimu toluⱪ aram elix bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Birinqi küni silǝr esil dǝrǝhlǝrdin xah-putaⱪlarni qatap, yǝni horma dǝrǝhliri bilǝn ⱪoyuⱪ yopurmaⱪliⱪ dǝrǝhlǝrning xahlirini kesip, eriⱪ boyidiki sɵgǝt qiwiⱪlirini ⱪirⱪip Hudayinglar Pǝrwǝrdigar aldida yǝttǝ künni xundaⱪ xad-huram ɵtküzisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Silǝr ⱨǝr yili bu yǝttǝ künni Pǝrwǝrdigarƣa atiƣan bir ⱨeyt süpitidǝ ɵtküzünglar; dǝwrdin-dǝwrgiqǝ bu silǝr üqün ǝbǝdiy bir bǝlgilimǝ bolidu. Silǝr ⱨeytni yǝttinqi ayda ɵtküzünglar. ");
INSERT INTO uigpin_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Yǝttǝ küngiqǝ kǝpilǝrdǝ turunglar. Israilda tuƣulƣanlarning ⱨǝmmisi kǝpidǝ tursun. ");
INSERT INTO uigpin_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Buning bilǝn Mǝn Israillarni Misir zeminidin qiⱪarƣinimda, ularni kǝpilǝrdǝ turƣuzƣinimni ǝwladliringlar bilidu. Ɵzüm Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Xundaⱪ ⱪilip Musa Pǝrwǝrdigarning bekitkǝn xu ⱨeytlirini Israillarƣa bayan ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Israillarƣa qiraƣ ⱨǝmixǝ yeniⱪ turuxi üqün zǝytundin soⱪup qiⱪirilƣan sap mayni sanga elip kelixkǝ buyruƣin. ");
INSERT INTO uigpin_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ⱨarun jamaǝt qedirining iqidǝ, ⱨɵküm-guwaⱨliⱪ sanduⱪining udulidiki pǝrdining sirtida ⱨǝr keqisi ǝtigǝngiqǝ Pǝrwǝrdigarning aldida qiraƣlarni xundaⱪ pǝrlǝp tursun. Bu dǝwrdin-dǝwrgiqǝ silǝr üqün ǝbǝdiy bir bǝlgilimǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ⱨarun ⱨǝmixǝ Pǝrwǝrdigarning aldida bu qiraƣlarni pak qiraƣdanning üstigǝ tizip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Sǝn yǝnǝ esil buƣday unidin on ikki toⱪaqni ǝtkin. Ⱨǝrbir toⱪaq bir ǝfaⱨning ondin ikkisigǝ barawǝr bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Andin sǝn Pǝrwǝrdigarning aldidiki pak xirǝning üstigǝ altidin ikki ⱪatar ⱪilip tizƣin. ");
INSERT INTO uigpin_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ⱨǝrbir ⱪatarning üstigǝ sap mǝstiki ⱪoyƣin; xuning bilǝn ular Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱨǝdiyǝ, ǝslǝtmǝ nan bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Bularni u Israillarƣa wakalitǝn ⱨǝrbir xabat küni Pǝrwǝrdigarning aldida tizsun; bu ǝbǝdiy bir ǝⱨdidur. ");
INSERT INTO uigpin_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Nanlar Ⱨarun bilǝn uning oƣulliriƣa tǝwǝ bolidu; ular ularni muⱪǝddǝs jayda yesun; qünki bu nǝrsilǝr Pǝrwǝrdigarƣa atap otta sunulƣan nǝrsilǝr iqidǝ «ǝng muⱪǝddǝslǝrning biri» dǝp sanilip, Ⱨarunƣa tǝwǝ bolidu; bu ǝbǝdiy bir bǝlgilimidur. ");
INSERT INTO uigpin_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Anisi Israiliy, atisi Misirliⱪ bir oƣul bar idi. U Israillarning arisiƣa bardi; u qedirgaⱨta bir Israiliy bilǝn uruxup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ular soⱪuxⱪanda Israiliy ayalning oƣli kupurluⱪ ⱪilip, Pǝrwǝrdigarning namini bulƣap ⱪarƣidi. Hǝlⱪ uni Musaning aldiƣa elip bardi. U kixining anisining ismi Xelomit bolup, u Dan ⱪǝbilisidin bolƣan Dibrining ⱪizi idi. ");
INSERT INTO uigpin_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Xuning bilǝn ular Pǝrwǝrdigarning ⱨɵküm buyruⱪi qiⱪⱪuqǝ u kixini solap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Andin Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Ⱪarƣiƣuqini qedirgaⱨning taxⱪiriƣa elip qiⱪinglar. Uning eytⱪinini angliƣanlarning ⱨǝmmisi ⱪollirini uning bexiƣa ⱪoysun, andin pütkül jamaǝt bir bolup uni qalma-kesǝk ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ⱨǝmdǝ sǝn Israillarƣa mundaⱪ degin: — Əgǝr birkim ɵz Hudasini ⱨaⱪarǝtlǝp ⱪarƣisa ɵz gunaⱨini tartidu. ");
INSERT INTO uigpin_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Pǝrwǝrdigarning namiƣa kupurluⱪ ⱪilƣan ⱨǝrⱪandaⱪ kixi ɵlümgǝ mǝⱨkum ⱪilinsun; pütkül jamaǝt qoⱪum bir bolup uni qalma-kesǝk ⱪilsun; mǝyli u musapir bolsun yaki yǝrlik bolsun, muⱪǝddǝs namƣa kupurluⱪ ⱪilsa ɵltürülsun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Əgǝr birsi baxⱪa birsini urup ɵltürsǝ, u ɵlümgǝ mǝⱨkum ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Birsi bir qarpayni ɵltürsǝ, uning üqün ⱨaywanni tɵlǝp, janƣa-jan tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Birkim ɵz ⱪoxnisini meyip ⱪilsa, u ɵzgigǝ ⱪandaⱪ ⱪilƣan bolsa, uning ɵzigimu xundaⱪ ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Birǝr ǝzasi sunduruwetilgǝn bolsa, uningmu sundurulsun; kɵzigǝ-kɵz, qixiƣa-qix nakar ⱪilinsun; baxⱪa kixini ⱪandaⱪ zǝhimlǝndürgǝn bolsa umu ⱨǝm xundaⱪ ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kimdǝkim bir qarpayni ɵltürsǝ, qarpay tɵlǝp bǝrsun; adǝmni urup ɵltürgǝn kixi bolsa, ɵlüm jazasiƣa mǝⱨkum ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Silǝrdǝ birla ⱪanun bolsun. musapir yaki yǝrlik bolsun, barawǝr muamilǝ ⱪilinsun; qünki Mǝn Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Musa Israillarƣa xularni dedi; xuning bilǝn ular xu ⱪarƣiƣuqini qedirgaⱨning taxⱪiriƣa elip qiⱪip, qalma-kesǝk ⱪildi. Xundaⱪ ⱪilip, Israillar Pǝrwǝrdigarning Musaƣa ǝmr ⱪilƣinidǝk ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Pǝrwǝrdigar Sinay teƣida Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Sǝn Israillarƣa mundaⱪ degin: — Mǝn silǝrgǝ beridiƣan zeminƣa kirgininglarda u zeminning ɵzimu Pǝrwǝrdigarƣa atap bir xabat aramini alsun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sǝn altǝ yil etizingni terip, altǝ yil talliⱪ beƣingni qatap, ulardin ⱨosullarni yiƣⱪin; ");
INSERT INTO uigpin_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ǝmma yǝttinqi yili zeminning ɵzi üqün bir «xabatliⱪ aram» bolsun; u Pǝrwǝrdigarƣa atalƣan bir «xabat» ⱨesablinidu. Xu yili sǝn etizingni terimaysǝn wǝ talliⱪingni qatimaysǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ɵzlükidin ünüp qiⱪⱪan ⱨosulni ormaysǝn; wǝ qatalmiƣan talliringning üzümlirini üzmǝysǝn; qünki xu yil zemin aram alidiƣan yildur. ");
INSERT INTO uigpin_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ⱨalbuki, zemin xabat yilida qiⱪarƣan ⱨosul ⱨǝmminglarƣa ozuⱪ bolidu, yǝni ɵzüng üqün, ⱪul-dediking üqün, mǝdikaring üqün wǝ seningkidǝ turuwatⱪan musapir üqün, xuningdǝk mal-waranliring üqün ");
INSERT INTO uigpin_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Wǝ zeminingdiki yawayi ⱨaywanlar üqünmu ozuⱪ bolidu; zeminning ⱨǝmmǝ ⱨosuli ozuⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Xuningdǝk sǝn yǝttǝ ⱪetimliⱪ xabat yilini, yǝni yǝttǝ ⱨǝssǝ yǝttǝ yilni saniƣin; yǝttǝ xabat yil künliri ⱪiriⱪ toⱪⱪuz yil bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Xunqilik waⱪit ɵtüp, yǝttinqi ayda, ayning oninqi küni, kǝfarǝt künidǝ burƣa qelip sadasini yuⱪiri qiⱪirisilǝr; kǝfarǝt künining ɵzidǝ silǝr pütkül zemininglarda burƣining sadasini anglitisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Xu ǝllikinqi yilini silǝr muⱪǝddǝs dǝp bilip, pütkül zeminda uningda barliⱪ turuwatⱪanlarning ⱨǝmmisigǝ azadliⱪni jakarlixinglar kerǝk. Xu yil silǝrgǝ «azadliⱪ yili» bolidu, ⱨǝrbiringlar ɵz yǝr-mülükliringlarƣa ⱪaytisilǝr, ⱨǝrbiringlar ɵz ailǝ-jǝmǝtinglarƣa ⱪaytip barisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Bu ǝllikinqi yili silǝrgǝ bir azadliⱪ yili bolsun; u yili ⱨeq nemǝ terimaysilǝr, ɵzlükidin ünüp qiⱪⱪan ⱨosulnimu ormaysilǝr wǝ qatalmiƣan talliringlarning üzümlirinimu yiƣmaysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Qünki bu azadliⱪ yili bolup, silǝrgǝ muⱪǝddǝs ⱨesablansun; uning ⱨosulini bolsa, etiz-dalilardin tepip ⱨǝmminglar yǝysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Azadliⱪ yili aranglardiki ⱨǝrbir adǝm ɵz yǝr-mülkigǝ ⱪaytsun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Silǝr ⱪoxnanglarƣa birnemǝ setip bǝrsǝnglar, yaki ⱪoxnanglardin birnemǝ setiwalsanglar, bir-biringlarni bozǝk ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ⱪoxnangdin yǝrni setiwalsang, undaⱪta «azadliⱪ yili»din keyin ɵtkǝn yillarning sanini ⱨesablap uningdin setiwelixing kerǝk; umu ⱪalƣan yillarning saniƣa ⱪarap, yǝrning keyinki ⱨosulliriƣa asasǝn sanga setip bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","«Azadliⱪ yili»ƣiqǝ bolƣan yillar kɵprǝk bolsa, baⱨasini xuningƣa muwapiⱪ yuⱪiri kɵtürisǝn; ⱪalƣan yillar azraⱪ bolsa, baⱨasini xuningƣa muwapiⱪ kemǝytsun. Qünki ⱪalƣan yillarning ⱨosulliri ⱪanqǝ bolsa, u xu boyiqǝ sanga setip beridu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Silǝr bir-biringlarni bozǝk ⱪilmanglar, bǝlki Hudayinglardin ⱪorⱪunglar; qünki Mǝn bolsam Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Silǝr Mening bǝlgilimilirimni tutup, ⱨɵkümlirimdǝ turup, xularƣa ǝmǝl ⱪilinglar; silǝr xundaⱪ ⱪilsanglar, zemininglarda tinq-aman turisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Xuning bilǝn zemin silǝrgǝ ɵz mewisini beridu, silǝr toyƣudǝk yǝp, uningda tinq-aman turisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Əgǝr silǝr: — Mana, bizgǝ terip ⱨosulni yiƣixⱪa ijazǝt berilmisǝ, yǝttinqi yili nemǝ yǝymiz, dǝp sorisanglar, ");
INSERT INTO uigpin_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","silǝrgǝ mǝlum bolsunki, altinqi yilida üq yilning ⱨosulini bǝrsun dǝp, Mǝn üstünglarƣa bǝrikitimni «qüx» dǝp buyruymǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Wǝ xundaⱪ boliduki, silǝr sǝkkizinqi yili teriysilǝr, ǝmma toⱪⱪuzinqi yiliƣiqǝ exip ⱪalƣan kona ⱨosuldin tehiqǝ yǝysilǝr; xu toⱪⱪuzinqi yiliƣiqǝ silǝr kona axliⱪtin yǝysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Yǝr-zemin setilsa, mǝnggülük setilmisun, qünki zeminning ɵzi Meningkidur, silǝr bolsanglar Mening yenimdiki musapir wǝ meⱨman, halas. ");
INSERT INTO uigpin_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Silǝr igǝ bolidiƣan pütkül zeminda yǝr-zeminning igilirigǝ uni «ⱪayturuwelix ⱨoⱪuⱪi»ni yaritip berixinglar kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Əgǝr ⱪerindaxliringlardin biri kǝmbǝƣǝllixip, ɵz miras yerini setiwǝtkǝn bolsa, uning yeⱪin tuƣⱪini, yǝni «ⱨǝmjǝmǝt xapaǝtqi»si kelip ɵz ⱪerindixi satⱪan yǝrni ⱪayturup setiwalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Əgǝr uning ⱨeq xapaǝtqi tuƣⱪini bolmisa, lekin u yanduruwelixⱪa kerǝklik pulni tapalisa, ");
INSERT INTO uigpin_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Undaⱪta satⱪiniƣa ⱪanqǝ yil bolƣanliⱪini ⱨesablap, azadliⱪ yiliƣiqǝ ⱪalƣan yillar üqün setiwalƣan kixigǝ muwapiⱪ pul berip, ɵz yerigǝ ⱪaytsun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Lekin ǝgǝr u yanduruwelixⱪa kerǝklik pulni tapalmisa, ɵzi setip bǝrgǝn yǝr azadliⱪ yiliƣiqǝ alƣuqining ⱪolida tursun; azadliⱪ yili kǝlgǝndǝ yǝr yǝr setiwalƣuqining ⱪolidin qiⱪsun, ɵz igisi ɵz yǝr-mülkigǝ ⱪaytsun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Əgǝr birsi sepilliⱪ xǝⱨǝrning iqidiki bir turalƣu ɵyni satⱪan bolsa, setip bir yil iqidǝ uni yanduruwelix ⱨoⱪuⱪi bardur. Toluⱪ bir yil tügǝp bolƣuqǝ, yanduruwelix ⱨoⱪuⱪi bardur. ");
INSERT INTO uigpin_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Lekin pütün yil iqidǝ yanduruwelinmisa, sepilliⱪ xǝⱨǝrning iqidiki bu ɵy nǝsildin-nǝsilgǝ alƣan kixining ⱪolida bolup, azadliⱪ yili kǝlsimu yandurulmas. ");
INSERT INTO uigpin_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Lekin sepilsiz kǝntlǝrning ɵyliri bolsa zeminning etizliridǝk ⱨesablinidu; ularni yandurup setiwalƣili bolidu; azadliⱪ yili kǝlgǝndǝ ǝsli igisining ⱪoliƣa yandurulidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Lekin Lawiy xǝⱨǝrliridǝ bolsa, Lawiylar ɵz mirasi bolƣan xǝⱨǝrlǝrdiki ɵylirini halisa ⱨǝrⱪaqan ⱪayturuwelix ⱨoⱪuⱪi bardur. ");
INSERT INTO uigpin_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Lawiylardin biri ɵylirini, yǝni ɵz mirasi bolƣan xǝⱨǝrdiki bir ɵyni ⱪayturuwelix ⱨoⱪuⱪi bar bolsimu, lekin ⱪayturup almiƣan bolsa, undaⱪ ǝⱨwalda u azadliⱪ yili kǝlgǝndǝ yandurulidu; qünki Lawiy xǝⱨǝrlirining ɵyliri bolsa Lawiylarning Israillarning arisidiki mirasi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Xundaⱪ ⱨǝm bularning xǝⱨǝrlirining qɵrisidiki etiz-yǝrliri bolsa, ularning ǝbǝdiy mirasi bolƣaqⱪa, setilsa bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Sanga ⱪoxna bolƣan, ⱪerindaxliringlardin biri kǝmbǝƣǝllixip, ɵz jenini baⱪalmay ⱪalsa, sǝn uni musapir yaki yaⱪa yurtluⱪ meⱨmandǝk yeningda turƣuzup, uningdin hǝwǝr alƣin. ");
INSERT INTO uigpin_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Sǝn uningdin ɵsüm wǝ yaki payda almiƣin; sǝn Hudayingdin ⱪorⱪup, ⱪerindixingni ⱪexingda turuxⱪa ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Pulungni uningƣa ɵsümgǝ bǝrmǝ, axliⱪingnimu payda elix mǝⱪsitidǝ uningƣa ɵtnǝ bǝrmigin. ");
INSERT INTO uigpin_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Hudayinglar boluxⱪa, Ⱪanaan zeminini silǝrgǝ berixkǝ silǝrni Misir zeminidin qiⱪirip kǝlgǝn Hudayinglar Pǝrwǝrdigar Ɵzümdurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Əgǝr sanga ⱪoxna bolƣan ⱪerindixing kǝmbǝƣǝllixip, ɵzini sanga satsa, uni ⱪuldǝk ⱪulluⱪ hizmitigǝ salmiƣin; ");
INSERT INTO uigpin_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","bǝlki u ⱪexingda mǝdikar yaki musapirdǝk tursun; azadliⱪ yiliƣiqǝ sening hizmitingdǝ bolsun; ");
INSERT INTO uigpin_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","andin azad bolup ɵzi bilǝn baliliri ⱪexingdin qiⱪip, ɵz jǝmǝtigǝ yenip berip, ata-bowilirining yǝr-mülkigǝ ⱪaytsun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Qünki ular Mǝn Ɵzüm Misir zeminidin qiⱪirip elip kǝlgǝn ⱪul-bǝndilirim bolƣaqⱪa, ularni ⱪuldǝk setixⱪa yol ⱪoymanglar. ");
INSERT INTO uigpin_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Sǝn ularƣa ⱪattiⱪ ⱪolluⱪ bilǝn hojiliⱪ ⱪilmaysǝn, bǝlki Hudayingdin ⱪorⱪⱪin. ");
INSERT INTO uigpin_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Lekin ɵzünggǝ ⱪul yaki dedǝk almaⱪqi bolsang, ularni ǝtraptiki yat ǝllǝrdin xundaⱪ ⱪul ya dedǝk setiwalsang bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Bulardin baxⱪa, aranglarda olturaⱪlaxⱪan musapirlarning pǝrzǝntlirini wǝ xularning jǝmǝtidin, yǝni silǝr bilǝn billǝ turuwatⱪan, zemininglarda tuƣulƣanlardin ⱪullar setiwalsanglar bolidu; xuning bilǝn ular silǝrning mülkünglar bolup ⱪalidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Silǝr muxularni ɵzünglardin keyinki baliliringlarƣa miras ⱪilip, ularƣa mülük boluxⱪa ⱪaldursanglar bolidu; muxularni ǝbǝdgiqǝ ⱪul ⱪilsanglar bolidu; lekin ɵz ⱪerindaxliringlar bolƣan Israillar arisida bolsa, bir-biringlarƣa ⱪattiⱪ ⱪolluⱪ bilǝn hojiliⱪ ⱪilmasliⱪinglar kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Əgǝr aranglarda olturuxluⱪ bir musapir yaki yaⱪa yurtluⱪ beyiƣan wǝ uningƣa ⱪoxna ⱪerindixing kǝmbǝƣǝllixip, ɵzini xu ⱪoxna musapirƣa wǝ yaki xu musapirning mǝlum bir ǝwladiƣa satsa, ");
INSERT INTO uigpin_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","u setilƣandin keyin uningda pul tɵlǝp ⱨɵrlükkǝ qiⱪix ⱨoⱪuⱪi ⱪalidu; uning aka-ukilirining ⱨǝrⱪaysisi uni ⱨɵrlükkǝ setiwalsa bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Xuningdǝk uning taƣisi yaki taƣisining oƣli wǝ yaki jǝmǝtidin bolƣan ⱨǝrⱪaysi yeⱪin tuƣⱪini uni ⱨɵrlükkǝ setiwalsa bolidu; yaki ɵzining ⱪurbi yǝtsǝ, pul berip ɵz-ɵzini ⱨɵrlükkǝ setiwalsa bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Uni setiwalidiƣan kixi uning hojisi bilǝn gǝplixip setilƣan yildin tartip azadliⱪ yiliƣiqǝ ⱪanqilik bolƣanliⱪini ⱨesablap, setiwelix baⱨasini yillarning saniƣa ⱪarap ⱨesablisun; ⱨɵrlük puli ⱨesablaxta ⱪulning hojisiƣa ixlǝxkǝ kerǝk bolƣan ⱪalƣan künlirining ⱨǝⱪⱪi «mǝdikarning ixligǝn künliri»dǝk ⱨesablansun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Azadliⱪ yiliƣa yǝnǝ heli yillar bolsa, xuni ⱨesablap, setilƣan pulning nisbiti boyiqǝ ⱨɵrlük pulini ⱨesablap bǝrsun; ");
INSERT INTO uigpin_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ǝgǝr azadliⱪ yiliƣa az yillar ⱪalƣan bolsa, uni ⱨesab ⱪilip, ⱪalƣan ⱪulluⱪ yilliriƣa muwapiⱪ pulni yandurup bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Bolmisa, ⱪul xu hojisining yenida yilliⱪ mǝdikardǝk turuxi kerǝk; uning hojisi sening kɵz aldingda uningƣa ⱪattiⱪ ⱪolluⱪ bilǝn hojiliⱪ ⱪilmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Əgǝr ⱪul yuⱪiriⱪi yollar bilǝn ⱨɵrlükkǝ qiⱪalmisa, azadliⱪ yili kǝlgǝndǝ ⱪoyup berilsun — u baliliri bilǝn ⱪoxulup azad bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Qünki Israillarning ɵzi Manga ⱪul-bǝndilǝrdur; ular Mǝn Ɵzüm Misir zeminidin qiⱪirip kǝlgǝn ⱪul-bǝndilirimdur. Hudayinglar Pǝrwǝrdigar Ɵzümdurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Silǝr ɵzünglar üqün ⱨeqⱪandaⱪ but yasimanglar yaki ɵzünglarƣa ⱨeq oyma mǝbud yaki ⱨǝykǝl-tüwrükni turƣuzmanglar yaki ularƣa bax uruxⱪa oyulƣan nǝⱪixlik taxlarni zemininglarda ⱨǝrgiz tiklimǝnglar; qünki Ɵzüm Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mening xabat künlirimni tutup, muⱪǝddǝs jayimƣa ihlasmǝn bolunglar. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Əgǝr silǝr mening bǝlgilimilirimdǝ mengip, ǝmrlirimni tutup ularƣa ǝmǝl ⱪilsanglar, ");
INSERT INTO uigpin_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Mǝn yeringlarning ɵz ⱨosulini berip turuxiƣa, daladiki dǝrǝhlǝrning mewisini qiⱪirixiƣa waⱪtida yamƣurliringlarni yaƣdurup turimǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Xuning bilǝn haman tepix waⱪti üzüm yiƣix pǝsligiqǝ bolidu, üzüm yiƣix waⱪti terilƣu waⱪtiƣiqǝ bolidu; silǝr neninglarni toyunƣuqǝ yǝp, ɵz zemininglarda tinq-aman turisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Mǝn zeminƣa aram-tinqliⱪ ata ⱪilimǝn, xuning bilǝn ⱨeqkim silǝrni ⱪorⱪutalmaydu, aramhuda yetip uhlaysilǝr; wǝⱨxiy ⱨaywanlarni zemindin yoⱪitimǝn, ⱪiliqmu zemininglardin ɵtmǝydu; ");
INSERT INTO uigpin_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","silǝr düxmǝnliringlarni ⱪoƣlaysilǝr, ular aldinglarda ⱪiliqlinip yiⱪilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Silǝrdin bǝx kixi yüz kixini ⱪoƣlaydu, yüz kixi on mingni ⱪaquridu; düxmǝnliringlar bolsa aldinglarda ⱪiliqlinip yiⱪilidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Mǝn silǝrgǝ yüzümni ⱪaritip, silǝrni pǝrzǝnt kɵrgüzüp kɵpǝytimǝn, silǝr bilǝn baƣliƣan ǝⱨdǝmni mǝzmut turƣuzimǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Silǝr tehiqǝ uzun saⱪlanƣan kona axliⱪni yǝwatⱪininglarda, yengi axliⱪ qiⱪidu; yengisi wǝjidin konisini qiⱪiriwetisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Mǝn Ɵz makanimni aranglarda turƣuzimǝn wǝ ⱪǝlbim silǝrdin nǝprǝtlǝnmǝydu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mǝn aranglarda mengip silǝrning Hudayinglar bolimǝn wǝ silǝr Mening hǝlⱪim bolisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mǝn silǝrni Misirda ularning ⱪulliri boluxtin ⱨɵr ⱪilixⱪa xu zeminidin qiⱪarƣan Hudayinglar Pǝrwǝrdigardurmǝn; Mǝn boyunturuⱪunglarning asarǝtlirini sundurup, ⱪǝddinglarni tik ⱪilip mangƣuzdum. ");
INSERT INTO uigpin_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ⱨalbuki, ǝgǝr silǝr Manga ⱪulaⱪ salmay, bu ǝmrlǝrning ⱨǝmmisigǝ ǝmǝl ⱪilmay, ");
INSERT INTO uigpin_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","bǝlgilimilirimni taxlap, ⱪǝlbinglardin ⱨɵkümlirimni yaman kɵrüp, barliⱪ ǝmrlirimni tutmay, ǝⱨdǝmni buzsanglar, ");
INSERT INTO uigpin_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Mǝnmu bexinglarƣa xu ixlarni qüxürimǝnki, — Mǝn silǝrgǝ wǝⱨimǝ selip, kɵzünglarni kor ⱪilidiƣan, jeninglarni zǝiplǝxtüridiƣan sil-waba kesili, kezik kesilini bexinglarƣa qüxürimǝn. Silǝr uruⱪunglarni bikar qeqip-teriysilǝr, qünki düxmǝnliringlar uni yǝp ketidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mǝn yüzümni silǝrgǝ ⱪarxi ⱪilimǝn, xuning bilǝn silǝr düxmǝnliringlardin urulup ⱪaqidiƣan bolisilǝr; silǝrni ɵq kɵrgüqilǝr üstünglardin ⱨɵkümranliⱪ ⱪilidu; ⱨeqkim silǝrni ⱪoƣlimisimu, ⱪaqisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Bulardin ⱨeq ibrǝt almay, bǝlki Manga yǝnǝ ⱪulaⱪ salmisanglar, Mǝn gunaⱨliringlar tüpǝylidin silǝrgǝ bolƣan jazani yǝttǝ ⱨǝssǝ eƣirlitimǝn, ");
INSERT INTO uigpin_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","küq-ⱨǝywǝnglardin bolƣan ⱨakawurluⱪinglarni sundurimǝn; asmininglarni tɵmürdǝk ⱪilip, yeringlarni mistǝk ⱪiliwetimǝn; ");
INSERT INTO uigpin_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ǝjir-japayinglar bikarƣa ketidu, yeringlar ⱨosul bǝrmǝydu, daladiki dǝrǝhlǝrgǝ mewǝ qüxmǝydu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Əgǝr yǝnila Mǝn bilǝn ⱪarxi mangsanglar, xundaⱪla Manga ⱪulaⱪ salmisanglar, Mǝn gunaⱨliringlarƣa layiⱪ bexinglarƣa qüxidiƣan waba-külpǝtlǝrni yǝnǝ yǝttǝ ⱨǝssǝ eƣirlitimǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Aranglarƣa silǝrni baliliringlardin juda ⱪilidiƣan, qarpayliringlarni yoⱪitidiƣan, silǝrni azlitidiƣan yawayi ⱨaywanlarni ǝwǝtimǝn; yol-koqiliringlar adǝmzatsiz qɵldǝk bolup ⱪalidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Silǝr bu ixlar arⱪiliⱪ ibrǝt-tǝrbiyǝ almay, bǝlki yǝnila Manga ⱪarxi mangsanglar, ");
INSERT INTO uigpin_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Mǝnmu silǝrgǝ ⱪarxi mengip, gunaⱨinglar tüpǝylidin bolƣan jazani yǝnǝ yǝttǝ ⱨǝssǝ eƣirlitip, Mǝn Ɵzüm silǝrni urimǝn; ");
INSERT INTO uigpin_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","üstünglarƣa ǝⱨdǝmni buzƣanliⱪning intiⱪamini alidiƣan ⱪiliq qüxürimǝn; xuning bilǝn silǝr xǝⱨǝrlǝrgǝ yiƣiliwalisilǝr, Mǝn aranglarƣa waba qüxürimǝn; xuning bilǝn silǝr düxmǝnlǝrning ⱪoliƣa qüxisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Silǝrgǝ yɵlǝnqük bolƣan axliⱪni ⱪurutuwetimǝn; on ayal bir bolup bir tonurda nan yeⱪip, nanlarni silǝrgǝ tarazida tartip beridu, ǝmma buni yegininglar bilǝn toymaysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Əgǝr bulardin ⱨeq ibrǝt almay, manga ⱪulaⱪ salmisanglar, bǝlki manga ⱪarxi mangsanglar, ");
INSERT INTO uigpin_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Mǝnmu ⱪǝⱨr bilǝn silǝrgǝ ⱪarxi mangimǝn; Mǝn, yǝni Mǝn Ɵzüm gunaⱨliringlar tüpǝylidin jaza-tǝrbiyini yǝnǝ yǝttǝ ⱨǝssǝ eƣirlitip qüxürimǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Xuning bilǝn silǝr oƣulliringlarning gɵxi wǝ ⱪizliringlarning gɵxini yǝysilǝr; ");
INSERT INTO uigpin_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","xundaⱪla Mǝn ⱪurbanliⱪ «yuⱪiri jay»liringlani wǝyran ⱪilip, «kün tüwrük»liringlarni sundurup, ɵlükliringlarni sunuⱪ butliringlarning üstigǝ taxliwetimǝn; Mening ⱪǝlbim silǝrdin nǝprǝtlinidu.    ");
INSERT INTO uigpin_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mǝn xǝⱨǝrliringlarni wǝyran ⱪilip, muⱪǝddǝs jayliringlarni harab ⱪilip, ⱪurbanliⱪinglarning huxbuylirini yǝnǝ purimaymǝn; ");
INSERT INTO uigpin_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","zeminni ⱨalakǝtkǝ elip barimǝn; uningda olturaⱪlaxⱪan düxmǝnliringlar bu ǝⱨwalƣa ⱨǝyranuⱨǝs ⱪalidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Silǝrni ǝllǝrning arisiƣa taritip, kǝyninglardin ⱪiliqni suƣurup ⱪoƣlaymǝn; xuning bilǝn zemininglar wǝyran bolup xǝⱨǝrliringlar harab ⱪilinidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","U waⱪitta, silǝr düxmǝnliringlarning zeminida turuwatⱪininglarda, zemin wǝyranǝ bolƣan barliⱪ künlǝrdǝ, zemin ɵz xabat künliridin sɵyünidu; u zamanda zemin dǝrwǝⱪǝ aram elip ɵz xabatliridin sɵyünidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ɵzi wǝyranǝ bolup turƣan barliⱪ künliridǝ u aram alidu, yǝni silǝr uningda turuwatⱪan waⱪittiki xabat künliringlarda ⱨeq almiƣan aramni ǝmdi alidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Aranglardin ⱪutulup ⱪalƣanlar bolsa, ular düxmǝnlǝrning zeminlirida turƣinida kɵngüllirigǝ yürǝkzadilik salimǝn, xuning bilǝn ular qüxkǝn bir yopurmaⱪning xǝpisini anglisa ⱪiliqtin ⱪaqⱪandǝk ⱪaqidu; ⱨeqkim ⱪoƣlimisimu yiⱪilip qüxidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Gǝrqǝ ⱨeqkim ularni ⱪoƣlimisimu, dǝrwǝⱪǝ ⱪiliqtin yiⱪitilƣandǝk ular bir-birining üstigǝ putlixip yiⱪilidu; silǝrdǝ düxmǝnliringlarƣa ⱪarxi turƣudǝk küq ⱪalmaydu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Əllǝrning arisida ⱨalak bolisilǝr, düxmǝnliringlarning zemini silǝrni yǝp ketidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Aranglardin ⱪutulup ⱪalƣanliri bolsa ɵz rǝzilliki tüpǝylidin düxmǝnliringlarning zeminida zǝiplixidu; wǝ ata-bowilirining rǝzillikidimu yürüp, xular zǝiplǝxkǝndǝk ularmu zǝiplixidu. ");
INSERT INTO uigpin_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ⱨalbuki, ular ɵzi ⱪilƣan rǝzilliki bilǝn ata-bowilirining sadir ⱪilƣan rǝzillikini, Manga yüz ɵrüp asiyliⱪ ⱪilƣinini, xundaⱪla ularning Manga ⱪarxi turup mangƣinini boyniƣa alidu, ");
INSERT INTO uigpin_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","xuningdǝk Mening ularƣa ⱪarxi mangƣinimƣa, xuningdǝk ularni düxmǝnlirining ⱪoliƣa tapxurƣinimƣa iⱪrar bolidu. Xunga ǝgǝr u waⱪitta ularning hǝtnisiz kɵngli tɵwǝn ⱪilinip, ɵz ⱪǝbiⱨlikining jazasini ⱪobul ⱪilsa, ");
INSERT INTO uigpin_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","undaⱪta Mǝn Yaⱪup bilǝn baƣliƣan ǝⱨdǝmni yad ⱪilip, Isⱨaⱪ bilǝn baƣliƣan ǝⱨdǝmnimu wǝ Ibraⱨim bilǝn baƣliƣan ǝⱨdǝmnimu esimgǝ kǝltürimǝn, zeminnimu yad ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Qünki zemin ulardin taxlinip, ularsiz bolup harabǝ turƣan waⱪitta, xabat künliridin sɵyünidu; ular bolsa ɵz ⱪǝbiⱨlikining jazasini ⱪobul ⱪilidu; sǝwǝbi dǝl xuki, ular Mening ⱨɵkümlirimni taxlidi, bǝlgilimilirimni ⱪǝlbidin yaman kɵrgǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ⱨalbuki, xundaⱪ bolsimu, ular ɵz düxmǝnlirining zeminida turƣinida Mǝn ularni taxlimaymǝn yaki ularƣa ɵqlük ⱪilmaymǝn, xuningdǝk ular bilǝn baƣliƣan ǝⱨdǝmni buzmaymǝn, ularni yoⱪatmaymǝn; qünki Mǝn Ɵzüm ularning Hudasi Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mǝn bǝlki ularni dǝp, ularning Hudasi boluxⱪa ǝllǝrning kɵzi aldida Misir zeminidin qiⱪirip kǝlgǝn ata-bowiliri bilǝn baƣlaxⱪan ǝⱨdǝmni esimdǝ tutimǝn. Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Pǝrwǝrdigar Musani wasitǝ ⱪilip, Sinay teƣida ɵzi bilǝn Israillarning otturisida bekitkǝn ⱨɵkümlǝr, bǝlgilimilǝr wǝ ⱪanunlar mana xular idi. ");
INSERT INTO uigpin_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Sǝn Israillarƣa mundaⱪ degin: — Əgǝr birsi pǝwⱪul’addǝ bir ⱪǝsǝm ⱪilip mǝlum kixining jenini Pǝrwǝrdigarƣa atiƣan bolsa, undaⱪta xu kixigǝ sǝn bekitkǝn jenining ⱪimmitining nǝrhi tɵwǝndikidǝk bolidu; ");
INSERT INTO uigpin_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Yexi yigirmǝ bilǝn atmixning ariliⱪida bolƣan ǝr kixi bolsa, sǝn tohtitidiƣan ⱪimmiti muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ bolsun; uning ⱪimmiti ǝllik xǝkǝl kümüxkǝ tohtitilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ayal kixi bolsa, aranglarda tohtitilƣan ⱪimmiti ottuz xǝkǝl bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Əgǝr yexi bǝx bilǝn yigirmining ariliⱪida bolsa, ǝrkǝk üqün tohtitilidiƣan ⱪimmiti yigirmǝ xǝkǝl bolup, ayal kixi üqün on xǝkǝl bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Əgǝr yexi bir ay bilǝn bǝx yaxning ariliⱪida bolsa, tohtitilidiƣan ⱪimmiti oƣul bala üqün bǝx xǝkǝl, ⱪiz bala üqün üq xǝkǝl kümüx bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Əgǝr atmix ya uningdin qongraⱪ yaxtiki kixi bolsa, tohtitilidiƣan ⱪimmiti ǝr kixi üqün on bǝx xǝkǝl, hotun kixi üqün on xǝkǝl bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Əgǝr birsi tohtitilƣan ⱪimmitini tɵlǝxkǝ ⱪurbi yǝtmisǝ, u ɵzini kaⱨinning aldida tǝⱪ ⱪilsun; kaⱨin uning ⱪimmitini bekitsun. Kaⱨin ⱪǝsǝm ⱪilƣuqining ǝⱨwaliƣa ⱪarap uning ⱪimmitini tohtitip bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Əgǝr birsi ⱪǝsǝm ⱪilip Pǝrwǝrdigarƣa ⱪurbanliⱪ boluxⱪa layiⱪ bolidiƣan bir ⱨaywanni uningƣa atiƣan bolsa, undaⱪta xundaⱪ ⱨaywanlar Pǝrwǝrdigarƣa atap mutlǝⱪ muⱪǝddǝs sanalsun; ");
INSERT INTO uigpin_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ⱨaywan naqar bolsa uning orniƣa yahxini yaki yahxining orniƣa naqirini tegixixkǝ yaki orniƣa baxⱪisini almaxturuxⱪa ⱨǝrgiz bolmaydu. Mubada atiƣuqi u ⱨaywanning orniƣa yǝnǝ bir ⱨaywanni yǝnggüxlimǝkqi bolsa, Awwalⱪisi bilǝn orniƣa ǝkǝlginining ⱨǝr ikkisi muⱪǝddǝs sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Əgǝr ⱨaywan Pǝrwǝrdigarƣa atalƣan ⱪurbanliⱪⱪa layiⱪ bolmaydiƣan bir «napak» ⱨaywan bolsa, undaⱪta u ⱨaywanni kaⱨinning aldiƣa elip kǝlsun; ");
INSERT INTO uigpin_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","andin kaⱨin ɵzi uning yahxi-yamanliⱪiƣa ⱪarap ⱪimmitini tohtatsun; kaⱨin ⱪimmitini ⱪanqǝ tohtatⱪan bolsa xundaⱪ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Əgǝr igisi pul tɵlǝp ⱨaywanni ⱪayturuwulmaⱪqi bolsa, tohtitilƣan ⱪimmitigǝ yǝnǝ uning bǝxtin birini ⱪoxup bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Əgǝr birsi Pǝrwǝrdigarƣa muⱪǝddǝs bolsun dǝp ɵyini uningƣa atap muⱪǝddǝs ⱪilsa, kaⱨin uning yahxi-yamanliⱪiƣa ⱪarap ⱪimmitini tohtatsun; kaⱨin uning ⱪimmitini ⱪanqǝ tohtatⱪan bolsa, xu ⱪimmiti inawǝtlik bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Keyin ǝgǝr ɵyni atiƣuqi kixi uni ⱪayturuwalmaⱪqi bolsa, u tohtitilƣan ⱪimmitigǝ uning bǝxtin birini ⱪoxup bǝrsun; andin ɵy yǝnǝ uning bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Əgǝr birsi ɵz mal-mülki bolƣan etizliⱪning bir ⱪismini Pǝrwǝrdigarƣa atap muⱪǝddǝs ⱪilsa, ⱪimmiti uningƣa ⱪanqilik uruⱪ terilidiƣanliⱪiƣa ⱪarap tohtitilsun; bir homir arpa uruⱪi ketidiƣan yǝr bolsa, ⱪimmiti ǝllik xǝkǝl kümüxkǝ tohtitilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Əgǝr birsi «azadliⱪ yili»din tartip ɵz etizliⱪini muⱪǝddǝs ⱪilsa, sǝn ⱪanqǝ tohtatsang xu bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Lekin ǝgǝr birsi «azadliⱪ yili»din keyin ɵz etizliⱪini muⱪǝddǝs ⱪilƣan bolsa, kaⱨin kelidiƣan azadliⱪ yiliƣiqǝ ⱪanqilik yillar ⱪalƣanliⱪini ⱨesablap ⱪimmitini tohtatsun. Ɵtüp kǝtkǝn yillarƣa ⱪarap toluⱪ baⱨadin muwapiⱪ pul kemǝytilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Əgǝr birsi ɵz etizliⱪini muⱪǝddǝs ⱪilƣandin keyin pul tɵlǝp uni ⱪayturuwalmaⱪqi bolsa, u sǝn tohtatⱪan ⱪimmitigǝ yǝnǝ uning bǝxtin birini ⱪoxup bǝrsun; xuning bilǝn etizliⱪ uning ɵz ⱪoliƣa ⱪaytidu. ");
INSERT INTO uigpin_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Əgǝr u pul berip etizliⱪni ⱪayturuwalmiƣan bolsa yaki baxⱪa birsigǝ setip bǝrgǝn bolsa, keyin xu etizliⱪni ⱪayturuwelixⱪa bolmaydu, ");
INSERT INTO uigpin_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Bǝlki azadliⱪ yili kǝlgǝndǝ etizliⱪ «igisigǝ ⱪayturulidiƣanda» u mutlǝⱪ beƣixlanƣan yǝrgǝ ohxax, Pǝrwǝrdigarƣa atap muⱪǝddǝs ⱪilinip, miras ⱨoⱪuⱪi kaⱨinƣa ɵtidu. ");
INSERT INTO uigpin_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Əgǝr birsi setiwalƣan ǝmma ɵz mirasi bolmiƣan bir parqǝ yǝr-etizni Pǝrwǝrdigarƣa atap muⱪǝddǝs ⱪilƣan bolsa, ");
INSERT INTO uigpin_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kaⱨin azadliⱪ yiliƣiqǝ ⱪalƣan yilni ⱨesablap, ⱪimmitini tohtatsun. Andin u küni xu kixi tohtitilƣan ⱪimmitini Pǝrwǝrdigarƣa muⱪǝddǝs ⱪilƣan nǝrsǝ süpitidǝ kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Lekin azadliⱪ yili kǝlgǝndǝ, etizliⱪ kimdin elinƣan bolsa, xu kixigǝ, yǝni ǝslidiki igisigǝ ⱪayturup berilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Sǝn tohtitidiƣan barliⱪ ⱪimmǝtlǝr bolsa ⱨǝmixǝ muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ⱨesablansun; bir xǝkǝl yigirmǝ gǝraⱨⱪa barawǝr bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Lekin qarpayning tunji balisi tunji bala bolƣanliⱪi sǝwǝbidin ǝslidinla Pǝrwǝrdigarƣa atilidiƣan bolƣaqⱪa, kala bolsun, ⱪoy-ɵqkǝ bolsun ⱨeqkim uni «Hudaƣa atap» muⱪǝddǝs ⱪilmisun; qünki u ǝslidǝ Pǝrwǝrdigarning idi. ");
INSERT INTO uigpin_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Əgǝr u napak bir ⱨaywandin tuƣulƣan bolsa, igisi sǝn tohtatⱪan ⱪimmǝtkǝ yǝnǝ uning bǝxtin birini ⱪoxup berip, andin ɵzigǝ ⱪayturuwalsun; lekin ǝgǝr igisi uni ɵzigǝ ⱪayturuwalmaymǝn desǝ, bu ⱨaywan sǝn tohtatⱪan ⱪimmǝtkǝ setilsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Əgǝr birsi Pǝrwǝrdigarƣa ɵz melidin, adǝm bolsun, ⱨaywan bolsun yaki miras yeri bolsun, Pǝrwǝrdigarƣa mutlǝⱪ atiƣan bolsa, undaⱪ nǝrsǝ ⱨǝrgiz setilmisun yaki bǝdǝl tɵlǝx bilǝnmu ⱪayturulmisun. Pǝrwǝrdigarƣa mutlǝⱪ atalƣan ⱨǝrnǝrsǝ bolsa «ǝng muⱪǝddǝslǝrning biri» ⱨesablinip, uningƣa has bolidu. ");
INSERT INTO uigpin_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Əgǝr bir adǝm Hudaƣa mutlǝⱪ has atalƣan bolsa, undaⱪta uning üqün bǝdǝl berilip, ⱪayturuwelinixⱪa ⱨǝrgiz bolmaydu; u qoⱪum ɵltürülüxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Yǝr-zemindin qiⱪⱪan ⱨǝmmǝ ⱨosulning ondin biri bolƣan ɵxrǝ bolsa, yǝrning danliⱪ ziraǝtliri bolsun yaki dǝrǝhlǝrning mewisi bolsun, Pǝrwǝrdigarningki bolidu; u Pǝrwǝrdigarƣa muⱪǝddǝs ⱪilinƣandur. ");
INSERT INTO uigpin_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Birsi ɵz ɵxriliridin mǝlum birnǝrsini bǝdǝl berip ⱪayturuwalmaⱪqi bolsa, u xuningƣa yǝnǝ uning ⱪimmitining bǝxtin birini ⱪoxup berip, ⱪayturuwalsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kala yaki ⱪoy-ɵqkǝ padisidin elinidiƣan ɵxrǝ bolsa padiqining tayiⱪi astidin ɵtküzülgǝn ⱨaywanlardin ⱨǝr oninqisi bolsun; Pǝrwǝrdigarƣa atilip muⱪǝddǝs ⱪilinƣini xu bolsun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ⱨeqkim uning yahxi-yamanliⱪiƣa ⱪarimisun wǝ yaki uni almaxturmisun; ǝgǝr uni almaxturimǝn desǝ, Awwalⱪisi bilǝn orniƣa almaxturulƣan ⱨǝr ikkisi muⱪǝddǝs sanalsun; u ⱨǝrgiz bǝdǝl tɵlüp ⱪayturuwelinmisun. ");
INSERT INTO uigpin_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Pǝrwǝrdigar Sinay teƣida Musaƣa tapilƣan, Israillarƣa tapxurux kerǝk bolƣan ǝmrlǝr mana xular idi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Wǝ Israillar Misirdin qiⱪⱪandin keyin ikkinqi yili ikkinqi ayning birinqi küni Pǝrwǝrdigar Sinay qɵlidǝ, jamaǝt qedirida turup Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Silǝr pütkül Israil jamaitini ⱪǝbilisi, ata jǝmǝti boyiqǝ sanini elip qiⱪinglar; adǝmlǝrning ismi asas ⱪilinip, barliⱪ ǝrkǝklǝr tizimlansun. ");
INSERT INTO uigpin_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Israillar iqidǝ omumǝn yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarni Ⱨarun bilǝn ikkinglar ularning ⱪoxun-ⱪismiliri boyiqǝ sanaⱪtin ɵtküzünglar. ");
INSERT INTO uigpin_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ⱨǝrbir ⱪǝbilidin silǝrgǝ yardǝmlixidiƣan birdin kixi bolsun; ularning ⱨǝrbiri ularning ata jǝmǝtining bexi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Tɵwǝndikilǝr silǝrgǝ yardǝmlixidiƣanlarning isimliki: — Rubǝn ⱪǝbilisidin Xidɵrning oƣli Əlizur; ");
INSERT INTO uigpin_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Ximeon ⱪǝbilisidin Zuri-xaddayning oƣli Xelumiyǝl; ");
INSERT INTO uigpin_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yǝⱨuda ⱪǝbilisidin Amminadabning oƣli Naⱨxon; ");
INSERT INTO uigpin_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Issakar ⱪǝbilisidin Zuarning oƣli Nǝtanǝl; ");
INSERT INTO uigpin_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zǝbulun ⱪǝbilisidin Ⱨelonning oƣli Eliab; ");
INSERT INTO uigpin_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yüsüp ǝwladliri iqidǝ Əfraim ⱪǝbilisidin Ammiⱨudning oƣli Əlixama; Manassǝⱨ ⱪǝbilisidin Pidaⱨzurning oƣli Gamaliyǝl; ");
INSERT INTO uigpin_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Binyamin ⱪǝbilisidin Gideonining oƣli Abidan; ");
INSERT INTO uigpin_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan ⱪǝbilisidin Ammixaddayning oƣli Aⱨiezǝr; ");
INSERT INTO uigpin_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Axir ⱪǝbilisidin Okranning oƣli Pagiyǝl; ");
INSERT INTO uigpin_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad ⱪǝbilisidin Deuǝlning oƣli Əliasaf; ");
INSERT INTO uigpin_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naftali ⱪǝbilisidin Enanning oƣli Aⱨira». ");
INSERT INTO uigpin_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Bular jamaǝt iqidin qaⱪirilƣanlar, yǝni ata jǝmǝt-ⱪǝbililirining baxliⱪliri, mingliƣan Israillarning bax sǝrdarliri idi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Xuning bilǝn Musa bilǝn Ⱨarun ismi atalƣan bu kixilǝrni baxlap, ");
INSERT INTO uigpin_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ikkinqi ayning birinqi küni pütkül jamaǝtni yiƣdi; ular hǝlⱪning ⱨǝrbirining ⱪǝbilǝ-nǝsǝbi, ata jǝmǝti boyiqǝ ismini asas ⱪilip, yigirmǝ yaxtin yuⱪirilarning ⱨǝmmisini bir-birlǝp tizimlidi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Pǝrwǝrdigar Musaƣa ⱪandaⱪ buyruƣan bolsa, Musa Sinay qɵlidǝ ularni xundaⱪ sanaⱪtin ɵtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Israilning tunji oƣli Rubǝnning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣan ǝrkǝklǝrning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Rubǝn ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ⱪiriⱪ altǝ ming bǝx yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ximeonning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣan ǝrkǝklǝrning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ximeon ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ǝllik toⱪⱪuz ming üq yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gadning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gad ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ⱪiriⱪ bǝx ming altǝ yüz ǝllik kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Yǝⱨudaning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Yǝⱨuda ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy yǝtmix tɵt ming altǝ yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Issakarning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Issakar ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ǝllik tɵt ming tɵt yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zǝbulunning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zǝbulun ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ǝllik yǝttǝ ming tɵt yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Yüsüpning ǝwladliri: — uning oƣli Əfraimning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Əfraim ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ⱪiriⱪ ming bǝx yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Yüsüpning ikkinqi oƣli Manassǝⱨning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manassǝⱨ ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ottuz ikki ming ikki yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Binyaminning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Binyamin ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ottuz bǝx ming tɵt yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Danning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy atmix ikki ming yǝttǝ yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Axirning ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Axir ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ⱪiriⱪ bir ming bǝx yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naftalining ǝwladliri ata jǝmǝti, ailisi boyiqǝ, ismi asas ⱪilinip, yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi bir-birlǝp tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Naftali ⱪǝbilisidin sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ǝllik üq ming tɵt yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Yuⱪiriⱪilar bolsa sanaⱪtin ɵtküzülgǝnlǝr bolup, Musa bilǝn Ⱨarun ⱨǝm Israillarning on ikki ǝmiri (ⱨǝrbiri ɵz ata jǝmǝtigǝ wǝkil boldi) ularni sanaⱪtin ɵtkǝzgǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Xundaⱪ ⱪilip, Israillarning ⱨǝmmisi, yǝni Israilda yigirmǝ yaxtin axⱪanlardin, jǝnggǝ qiⱪalaydiƣanlarning ⱨǝmmisi ata jǝmǝtliri boyiqǝ tizimlandi; ");
INSERT INTO uigpin_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Sanaⱪtin ɵtküzülgǝnlǝr jǝmiy altǝ yüz üq ming bǝx yüz ǝllik kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Biraⱪ Lawiylar ata jǝmǝt-ⱪǝbilisi boyiqǝ sanaⱪning iqigǝ kirgüzülmidi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Qünki Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Sǝn pǝⱪǝt Lawiy ⱪǝbilisinila xu ⱨesabⱪa kirgüzmigin, ularning omumiy saninimu Israillarning ⱪatariƣa kirgüzmigin. ");
INSERT INTO uigpin_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Lekin sǝn Lawiylarni Hudaning ⱨɵküm-guwaⱨliⱪi saⱪlaⱪliⱪ qedir wǝ uning iqidiki barliⱪ ⱪaqa-ⱪuqa ǝswablarni ⱨǝm uningƣa dair barliⱪ nǝrsilǝrni baxⱪuruxⱪa tǝyinligin; ular ibadǝt qedirini wǝ uning iqidiki barliⱪ ⱪaqa-ⱪuqa ǝswablarni kɵtüridu; ibadǝt qedirining hizmitini ⱪilƣuqilar xular bolsun, ular qedirning tɵt ǝtrapida ɵz qedirlirini tiksun. ");
INSERT INTO uigpin_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Qedirni kɵqüridiƣan qaƣda uni Lawiylar sɵksun; qedirni tikidiƣan qaƣda uni Lawiylar tiksun; Lawiylarƣa yat bolƣan ⱨǝrⱪandaⱪ adǝm uningƣa yeⱪinlaxsa ɵlümgǝ mǝⱨkum ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israillar bargaⱨ ⱪurƣanda ⱨǝr adǝm ɵz ⱪismida, ɵzigǝ has tuƣ astiƣa qedir tiksun. ");
INSERT INTO uigpin_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Biraⱪ Hudaning ƣǝzipi Israil jamaitining üstigǝ qüxmǝsliki üqün, Lawiylar Hudaning ⱨɵküm-guwaⱨliⱪi saⱪlaⱪliⱪ qedirning tɵt ǝtrapiƣa bargaⱨ ⱪursun; Lawiylar Hudaning ⱨɵküm-guwaⱨliⱪi saⱪlaⱪliⱪ qedirni muⱨapizǝt ⱪilixⱪa mǝs’ul bolidu» — degǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israillar ǝnǝ xundaⱪ ⱪildi; Pǝrwǝrdigar Musaƣa ⱪandaⱪ buyruƣan bolsa, ular xundaⱪ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Israillar ⱨǝrbiri ɵzlirining tuƣi astiƣa, ɵzlirining ata jǝmǝtining bayriⱪi astida qedir tiksun; jamaǝt qedirining tɵt ǝtrapidin sǝl yiraⱪraⱪ bargaⱨ ⱪursun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Kün qiⱪix tǝrǝpkǝ, xǝrⱪ tǝrǝpkǝ ⱪaritip ɵz tuƣi astida ⱪoxun-ⱪismi boyiqǝ bargaⱨ ⱪuridiƣini Yǝⱨuda bolsun; Yǝⱨudalarning ǝmiri Amminadabning oƣli Naⱨxon bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy yǝtmix tɵt ming altǝ yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Uning yenida bargaⱨ ⱪuridiƣini Issakar ⱪǝbilisi bolsun; Issakarlarning ǝmiri Zuarning oƣli Nǝtanǝl bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ǝllik tɵt ming tɵt yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ularning yenida yǝnǝ Zǝbulun ⱪǝbilisi bolsun; Zǝbulunlarning ǝmiri Ⱨelonning oƣli Eliab bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ǝllik yǝttǝ ming tɵt yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Omumǝn Yǝⱨuda bargaⱨiƣa ⱪaraydiƣanlarning ⱨǝmmisi, yǝni ⱪoxun-ⱪisimliri boyiqǝ sanaⱪtin ɵtküzülgǝnlǝr jǝmiy bir yüz sǝksǝn altǝ ming tɵt yüz kixi; ular aldi bilǝn yolƣa qiⱪsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","— Jǝnub tǝrǝptǝ, tuƣ tiklǝp, ⱪoxun tǝrtipi bilǝn bargaⱨ ⱪuridiƣini Rubǝn ⱪǝbilisi bolsun; Rubǝnlarning ǝmiri Xidɵrning oƣli Əlizur bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ⱪiriⱪ altǝ ming bǝx yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Uning yenida bargaⱨ ⱪuridiƣini Ximeon ⱪǝbilisi bolsun; Ximeonlarning ǝmiri Zuri-xaddayning oƣli Xelumiyǝl bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ǝllik toⱪⱪuz ming üq yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ularning yenida Gad ⱪǝbilisi bolsun; Gadlarning ǝmiri Deuǝlning oƣli Əliasaf bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ⱪiriⱪ bǝx ming altǝ yüz ǝllik kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Rubǝn bargaⱨiƣa ⱪaraydiƣanlarning ⱨǝmmisi, yǝni ⱪoxuni boyiqǝ sanaⱪtin ɵtküzülgǝnlǝr jǝmiy bir yüz ǝllik bir ming tɵt yüz ǝllik kixi; ular ikkinqi sǝp bolup yolƣa qiⱪsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Andin jamaǝt qediri bilǝn Lawiylarning bargaⱨi baxⱪa bargaⱨlarning otturisida mangsun; ular ⱪandaⱪ bargaⱨ ⱪurƣan bolsa, xundaⱪ yolƣa qiⱪsun; ⱨǝr ⱪaysisi ɵz ornida ɵz tuƣi astida bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","— Kün petix tǝrǝptǝ, tuƣ tiklǝp, ⱪoxun tǝrtipi bilǝn bargaⱨ ⱪuridiƣini Əfraim ⱪǝbilisi bolsun; Əfraimlarning ǝmiri Ammiⱨudning oƣli Əlixama bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ⱪiriⱪ ming bǝx yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Uning yenida bargaⱨ ⱪuridiƣini Manassǝⱨ ⱪǝbilisi bolsun; Manassǝⱨlǝrning ǝmiri Pidaⱨzurning oƣli Gamaliyǝl bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ottuz ikki ming ikki yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ularning yenida Binyamin ⱪǝbilisi bolsun; Binyaminlarning ǝmiri Gideonining oƣli Abidan bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ottuz bǝx ming tɵt yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Omumǝn Əfraim bargaⱨiƣa ⱪaraydiƣanlarning ⱨǝmmisi, yǝni ⱪoxun ⱪisimliri boyiqǝ sanaⱪtin ɵtküzülgǝnlǝr jǝmiy bir yüz sǝkkiz ming bir yüz kixi; ular üqinqi sǝp bolup yolƣa qiⱪsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","— Ximal tǝrǝptǝ, tuƣ tiklǝp, ⱪoxun tǝrtipi bilǝn bargaⱨ ⱪuridiƣini Dan ⱪǝbilisi bolsun. Danlarning ǝmiri Ammixaddayning oƣli Aⱨiezǝr bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy atmix ikki ming yǝttǝ yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Uning yenida bargaⱨ ⱪuridiƣini Axir ⱪǝbilisi bolsun; Axirlarning ǝmiri Okranning oƣli Pagiyǝl bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ⱪiriⱪ bir ming bǝx yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ularning yenida Naftali ⱪǝbilisi bolsun; Naftalilarning ǝmiri Enanning oƣli Aⱨira bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Uning ⱪoxuni, yǝni sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ǝllik üq ming tɵt yüz kixi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan bargaⱨiƣa ⱪaraydiƣanlarning ⱨǝmmisi, yǝni ⱪoxun-ⱪisimliri boyiqǝ sanaⱪtin ɵtküzülgǝnlǝr jǝmiy bir yüz ǝllik yǝttǝ ming altǝ yüz kixi; ular ɵz tuƣliri astida ⱨǝmmining kǝynidǝ yolƣa qiⱪsun. ");
INSERT INTO uigpin_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Yuⱪiridikilǝr ɵz ata jǝmǝti boyiqǝ sanaⱪtin ɵtküzülgǝn Israillardur; ⱪoxun-ⱪisimliri boyiqǝ bargaⱨlarda sanaⱪtin ɵtküzülgǝnlǝr jǝmiy altǝ yüz üq ming bǝx yüz ǝllik kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Biraⱪ Lawiylarla, Pǝrwǝrdigarning Musaƣa ⱪilƣan ǝmri boyiqǝ, Israillar ⱪatarida sanaⱪtin ɵtküzülmidi. ");
INSERT INTO uigpin_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israillar Pǝrwǝrdigarning Musaƣa ⱪilƣan barliⱪ ǝmri boyiqǝ ix tutup, ɵzlirining tuƣi boyiqǝ bargaⱨ ⱪuratti; ular ɵz ⱪǝbilisi wǝ ata jǝmǝti tǝrtipi boyiqǝ yolƣa qiⱪatti. ");
INSERT INTO uigpin_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Pǝrwǝrdigar Sinay teƣida Musa bilǝn sɵzlǝxkǝn künlǝrdǝ, Ⱨarun bilǝn Musaning ǝwladliri tɵwǝndikilǝrdin ibarǝt idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ⱨarunning oƣullirining ismi mundaⱪ: tunji oƣlining ismi Nadab idi, uning yǝnǝ Abiⱨu, Əliazar, Itamar degǝn oƣulliri bar idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ⱨarunning oƣullirining ismi ǝnǝ xundaⱪ idi, ular mǝsiⱨlǝngǝn kaⱨinlar idi; Musa ularni kaⱨinliⱪ wǝzipisini ɵtǝxkǝ Hudaƣa atap ayriƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Lekin Nadab bilǝn Abiⱨu Sinay qɵlidǝ ƣǝyriy bir otni Pǝrwǝrdigarning aldiƣa sunƣini tüpǝylidin Pǝrwǝrdigar aldida ɵldi wǝ ularning ⱨeq nǝsli ⱪaldurulmidi; Əliazar bilǝn Itamar ɵz atisi Ⱨarun aldida kaⱨinliⱪ wǝzipisini ɵtidi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Sǝn Lawiy ⱪǝbilisini aldingƣa kǝltürüp, ularni kaⱨin Ⱨarunning hizmitidǝ boluxⱪa uning aldiƣa ⱨazir ⱪil. ");
INSERT INTO uigpin_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ular Ⱨarunning ⱨajiti wǝ pütkül jamaǝtning ⱨajitidin qiⱪip jamaǝt qedirining aldida wǝzipǝ ɵtǝp, ibadǝt qedirining hizmitini bejirsun. ");
INSERT INTO uigpin_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ular yǝnǝ jamaǝt qediridiki barliⱪ ⱪaqa-ⱪuqa ǝswablarni baxⱪurux bilǝn Israillarning hizmitidǝ bolup wǝzipǝ ɵtǝp, ibadǝt qedirining ixlirini bejirsun. ");
INSERT INTO uigpin_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Sǝn Lawiylarni Ⱨarun bilǝn uning oƣulliriƣa tǝⱪsimlǝp bǝrgin; ular Israillar iqidin mǝhsus uningƣa tallap berilgǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ⱨarun bilǝn oƣullirini bolsa sǝn ɵzining kaⱨinliⱪ wǝzipisini ɵtǝxkǝ bekitkin; ⱨǝrⱪandaⱪ yat kixi yeⱪinlaxsa ɵltürülsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Andin Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","— Ⱪara, Mǝn Israillar iqidin Lawiylarni tallidim, ularni Israil iqidǝ baliyatⱪuning barliⱪ tunji mewisining orniƣa, yǝni qong oƣullirining orniƣa ⱪoyimǝn, xunga Lawiylar Mening bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Qünki tunji oƣullarning ⱨǝmmisi Meningkidur; Mǝn Misir zeminida tunji tuƣulƣanlarning ⱨǝmmisini ⱪǝtl ⱪilƣan künidǝ Israillarning iqidiki tunjilarning ⱨǝmmisini, mǝyli adǝm bolsun yaki ⱨaywan bolsun, muⱪǝddǝs ⱨesablap Meningki ⱪilƣanidim. Ular Meningkidur; Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Andin Pǝrwǝrdigar Sinay qɵl-bayawanida Musaƣa: — ");
INSERT INTO uigpin_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","— Sǝn Lawiylarni ata jǝmǝti, ailisi boyiqǝ sanaⱪtin ɵtküz; barliⱪ ǝrkǝklǝrni, yǝni bir ayliⱪtin axⱪanlarning ⱨǝmmisini sanaⱪtin ɵtküz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Xuning bilǝn Musa Pǝrwǝrdigarning ǝmri boyiqǝ, ɵzigǝ deyilgǝndǝk Lawiylarni sanaⱪtin ɵtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lawiyning oƣullirining ismi mundaⱪ: — Gǝrxon, Koⱨat, Mǝrari. ");
INSERT INTO uigpin_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gǝrxonning oƣullirining ismi aililiri boyiqǝ Libni wǝ Ximǝy idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Koⱨatning oƣulliri aililiri boyiqǝ Amram, Izⱨar, Ⱨebron wǝ Uzziǝl idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Mǝrarining oƣulliri aililiri boyiqǝ Maⱨli wǝ Muxi idi. Bularning ⱨǝmmisi ata jǝmǝti boyiqǝ Lawiylarning jǝmǝti boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gǝrxondin Libnilarning jǝmǝti bilǝn Ximǝylǝrning jǝmǝti wujudⱪa kǝldi; bular Gǝrxonlarning jǝmǝtliri idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Barliⱪ ǝrlǝrning saniƣa asasǝn, bir ayliⱪtin axⱪanlirining sanaⱪtin ɵtküzülgǝnliri jǝmiy yǝttǝ ming bǝx yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gǝrxonning jǝmǝti ibadǝt qedirining arⱪa tǝripidǝ, yǝni ƣǝrb tǝrǝptǝ bargaⱨ ⱪurdi; ");
INSERT INTO uigpin_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gǝrxon jǝmǝtining ǝmiri Laǝlning oƣli Əliasaf idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gǝrxonlarning jamaǝt qediridiki wǝzipisi ibadǝt qedirining ɵzidiki astinⱪi ikki yapⱪuq-pǝrdǝ, uning üstidiki yopuⱪ wǝ jamaǝt qedirining ixik pǝrdisigǝ, ");
INSERT INTO uigpin_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","xundaⱪla ⱨoyla ǝtrapidiki pǝrdilǝr, ⱨoyla dǝrwazisining pǝrdisi (ⱨoyla pǝrdiliri ibadǝt qediri bilǝn ⱪurbangaⱨni qɵridǝp turatti) wǝ ⱨoylida ixlitilidiƣan munasiwǝtlik barliⱪ tanilarƣa ⱪarax idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Koⱨattin Amramlarning jǝmǝti, Izⱨarlarning jǝmǝti, Ⱨebronlarning jǝmǝti wǝ Uzziǝllǝrning jǝmǝti wujudⱪa kǝldi; bu Koⱨatlarning jǝmǝtliri idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Barliⱪ ǝrkǝklǝrning sani boyiqǝ, bir ayliⱪtin axⱪanlar jǝmiy sǝkkiz ming altǝ yüz adǝm bolup qiⱪti; ular muⱪǝddǝs jayƣa ⱪarax wǝzipisini ɵtǝydiƣan boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Koⱨat ǝwladlirining jǝmǝtliri jamaǝt qedirining jǝnub tǝripidǝ bargaⱨ tikti. ");
INSERT INTO uigpin_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Koⱨat jǝmǝtining ǝmiri Uzziǝlning oƣli Əlizafan idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ularning wǝzipisi ǝⱨdǝ sanduⱪi, xirǝ, qiraƣdan, ikki ⱪurbangaⱨ, xuningdǝk muⱪǝddǝs jayning iqidǝ ixlitidiƣan ⱪaqa-ⱪuqa, pǝrdǝ wǝ ibadǝt qedirining iqidǝ ixlitidiƣan barliⱪ nǝrsilǝrgǝ ⱪarax idi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Lawiylarning ǝmirlirining ǝmiri bolsa kaⱨin Ⱨarunning oƣli Əliazar idi; u muⱪǝddǝshaniƣa ⱪarax wǝzipisini ɵtǝydiƣanlar üstidin nazarǝt ⱪilidiƣan boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mǝraridin Maⱨli jǝmǝti bilǝn Muxi jǝmǝti wujudⱪa kǝldi; bular Mǝrarining jǝmǝtliri boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Barliⱪ ǝrkǝklǝrning saniƣa asasǝn, bir ayliⱪtin yuⱪiri bolƣanlar sanaⱪtin ɵtküzülgǝndǝ jǝmiy altǝ ming ikki yüz kixi qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mǝrarining jǝmǝtining ǝmiri Abiⱨayilning oƣli Zuriyǝl boldi; ular ibadǝt qedirining ximal tǝripigǝ bargaⱨ ⱪurdi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Mǝrari ǝwladlirining wǝzipisi ibadǝt qedirining tahtayliri, baldaⱪliri, hadiliriƣa, tǝglikliri barliⱪ ǝswab-jabduⱪliriƣa ⱪarax, xuningdǝk bularƣa munasiwǝtlik ixlitilidiƣan barliⱪ nǝrsilǝrgǝ, ");
INSERT INTO uigpin_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","xundaⱪla ⱨoylining tɵt ǝtrapidiki hadilarƣa wǝ ularning tǝglikliri, ⱪozuⱪ wǝ tanilarƣa mǝs’ul boluxⱪa bǝlgilǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ibadǝt qedirining aldiƣa, xǝrⱪ tǝripigǝ, yǝni jamaǝt qedirining künqiⱪix tǝripigǝ bargaⱨ ⱪurƣanlar Musa, Ⱨarun wǝ Ⱨarunning oƣulliri idi; ular Israillarning hizmitidǝ bolux wǝzipisini ɵtǝp, muⱪǝddǝs jayƣa ⱪaraydiƣan boldi; ularƣa yat bolƣan ⱨǝrⱪandaⱪ adǝm muⱪǝddǝs jayƣa yeⱪinlaxsa, ɵltürülǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Musa bilǝn Ⱨarun Pǝrwǝrdigarning ǝmri boyiqǝ, sanaⱪtin ɵtküzgǝn barliⱪ Lawiylar, jǝmǝtliri boyiqǝ, yǝni bir ayliⱪtin yuⱪiri sanaⱪtin ɵtküzülgǝn ǝrkǝklǝr jǝmiy yigirmǝ ikki ming qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Pǝrwǝrdigar Musaƣa: — Sǝn Israillar iqidǝ bir ayliⱪtin axⱪan tunji oƣullarni sanaⱪtin ɵtküzüp, isim-familisi boyiqǝ tizimlap qiⱪ. ");
INSERT INTO uigpin_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Sǝn Lawiylarni Israillarning barliⱪ tunjilirining ornida Manga has ⱪil (Mǝn Pǝrwǝrdigardurmǝn); Lawiylarning mal-qarwilirinimu Israillarning barliⱪ tunji mal-qarwilirining ornida Manga has ⱪil, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Musa Pǝrwǝrdigarning ǝmri boyiqǝ, Israillarning tunjilirini ⱪoymay sanaⱪtin ɵtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Bir ayliⱪtin yuⱪiri tunji oƣul balilirini isim-familisi bilǝn sanaⱪtin ɵtküzgǝndǝ, ular jǝmiy yigirmǝ ikki ming ikki yüz yǝtmix üq kixi qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Sǝn Lawiylarni Israillarning tunjilirining ornida Manga talla, xundaⱪla Lawiylarning mal-qarwilirinimu Israillarning mal-qarwilirining ornida Manga talla; xuning bilǝn Lawiylar Meningki bolidu; Mǝn Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Wǝ Lawiylarning sanidin artuⱪ qiⱪⱪan Israillarning tunjiliri, yǝni xu ikki yüz yǝtmix üqi üqün ⱨɵrlük ⱨǝⱪⱪini ⱪobul ⱪilƣin; ");
INSERT INTO uigpin_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","xularning ⱨǝrbiri üqün bǝx xǝkǝl kümüx al, kixi saniƣa ⱪarap bolsun; muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ulardin alƣin (bir xǝkǝl yigirmǝ gǝraⱨdur).    ");
INSERT INTO uigpin_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Artuⱪ qiⱪⱪan adǝmlǝrning, yǝni ⱨɵrlük ⱨǝⱪⱪini tɵlixi kerǝk bolƣanlarning kümüxini Ⱨarun bilǝn uning oƣulliriƣa bǝr. ");
INSERT INTO uigpin_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Əmdi Lawiylar tǝripidin «ⱨɵrlükkǝ qiⱪirilƣan» dǝp ⱨesablanƣan tunji oƣullardin artuⱪ qiⱪⱪanlardin bolsa, Musa ulardin xu ⱨɵrlük ⱨǝⱪⱪini aldi; ");
INSERT INTO uigpin_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","u Israillarning tunjiliridin xu kümüxni, yǝni muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ jǝmiy bir ming üq yüz atmix bǝx xǝkǝl aldi. ");
INSERT INTO uigpin_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa Pǝrwǝrdigarning ǝmri boyiqǝ «ⱨɵrlükkǝ qiⱪirilƣan»larning kümüxini dǝl Pǝrwǝrdigar buyruƣinidǝk, Ⱨarun bilǝn uning oƣulliriƣa bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Andin Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Sǝn Lawiylar iqidin ata jǝmǝti boyiqǝ Koⱨat ǝwladlirining omumiy sanini tizimliƣin, ");
INSERT INTO uigpin_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ottuz yaxtin ǝllik yaxⱪiqǝ bolƣan, jamaǝt qedirida ix-hizmǝt ⱪilixⱪa kelǝlǝydiƣanlarning ⱨǝmmisini tizimlap qiⱪ. ");
INSERT INTO uigpin_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Koⱨat ǝwladlirining jamaǝt qediri iqidiki wǝzipisi ǝng muⱪǝddǝs buyumlarni baxⱪurux bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Bargaⱨ kɵqürülidiƣan qaƣda, Ⱨarun bilǝn uning oƣulliri kirip «ǝng muⱪǝddǝs jay»diki «ayrima pǝrdǝ-yopuⱪ»ni qüxürüp, uning bilǝn ⱨɵküm-guwaⱨliⱪ sanduⱪini yɵgisun; ");
INSERT INTO uigpin_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","andin uning üstini delfinning terisidin etilgǝn yopuⱪ bilǝn orap, üstigǝ kɵk bir rǝhtni yepip, andin kɵtüridiƣan baldaⱪlarni ɵtküzsun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Tǝⱪdim nan tizilƣan xirǝgǝ kɵk bir rǝht selinip, üstigǝ legǝn, tǝhsǝ, piyalǝ wǝ xarab ⱨǝdiyǝlirini qaqidiƣan ⱪǝdǝⱨlǝr tizip ⱪoyulsun; xirǝdimu «daimiy nan» tizilip turiwǝrsun;    ");
INSERT INTO uigpin_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","bu nǝrsilǝrning üsti ⱪizil rǝht bilǝn, uning üsti yǝnǝ delfin terisidǝ etilgǝn bir yopuⱪ bilǝn yepilip, andin kɵtiridiƣan baldaⱪlar ɵtküzüp ⱪoyulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ular kɵk rǝht elip, uning bilǝn qiraƣdan bilǝn üstidiki qiraƣlarni, pilik ⱪisⱪuqlarni, küldanlarni wǝ qiraƣdanƣa ixlitidiƣan, barliⱪ may ⱪaqilaydiƣan ⱪaqilarni yepip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ular yǝnǝ qiraƣdan bilǝn qiraƣdanƣa ixlitidiƣan ⱨǝmmǝ ⱪaqa-ⱪuqa ǝswablarni delfin terisidin etilgǝn yopuⱪ bilǝn yɵgǝp, andin ǝpkǝxkǝ selip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Altun huxbuygaⱨⱪa kɵk bir rǝht selip, yǝnǝ delfin terisidǝ etilgǝn yopuⱪ bilǝn yepip, andin kɵtürgüqkǝ ⱪox baldaⱪlarni ɵtküzüp ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Muⱪǝddǝs jayning iqidǝ ixlitidiƣan barliⱪ ⱪaqa-ⱪuqilarni kɵk bir rǝht bilǝn yɵgǝp, andin üstigǝ delfin terisidǝ etilgǝn yopuⱪni yepip, andin bir ǝpkǝxkǝ selip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ular ⱪurbangaⱨni külidin tazilap, üstigǝ sɵsün rǝnglik bir rǝhtni yeyip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Andin yǝnǝ ⱪurbangaⱨta ixlitilidiƣan ǝswablar — küldan, ilmǝk, bǝlgürjǝk, qinilǝr, xundaⱪla barliⱪ ǝswablarni ⱪurbangaⱨ üstigǝ tizip, andin delfin terisidǝ etilgǝn bir yopuⱪ bilǝn yepip, andin kɵtüridiƣan baldaⱪlarni ɵtküzüp ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Pütün bargaⱨtikilǝr yolƣa qiⱪidiƣan qaƣda, Ⱨarun bilǝn uning oƣulliri muⱪǝddǝs jay wǝ muⱪǝddǝs jaydiki barliⱪ ⱪaqa-ⱪuqa ǝswablarni yepip bolƣandin keyin, Koⱨatning ǝwladliri kelip kɵtürsun; lekin ɵlüp kǝtmǝslik üqün muⱪǝddǝs buyumlarƣa ⱪol tǝgküzmisun. Jamaǝt qediri iqidiki nǝrsilǝrdin xularni Koⱨatning ǝwladliri kɵtürüxi kerǝk. ");
INSERT INTO uigpin_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ⱨarunning oƣli Əliazarning wǝzipisi qiraƣ meyi, huxbuy ǝtir, daimiy tǝⱪdim ⱪilinidiƣan axliⱪ ⱨǝdiyǝsi bilǝn mǝsiⱨlǝx meyiƣa ⱪarax, xundaⱪla pütkül ibadǝt qediri bilǝn uning iqidiki barliⱪ nǝrsilǝr, muⱪǝddǝs jay ⱨǝm muⱪǝddǝs jaydiki ⱪaqa-ⱪuqa ǝswablarƣa ⱪaraxtin ibarǝt. ");
INSERT INTO uigpin_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Andin Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Silǝr Koⱨat jǝmǝtidikilǝrni Lawiylar arisidin ⱪǝt’iy yoⱪitip ⱪoymanglar; ");
INSERT INTO uigpin_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","bǝlki ularning ɵlmǝy, ⱨayat ⱪelixi üqün ular «ǝng muⱪǝddǝs» buyumlarƣa yeⱪinlaxⱪan qaƣda, Ⱨarun bilǝn uning oƣulliri kirip ularning ⱨǝrbirigǝ ⱪilidiƣan wǝ kɵtüridiƣan ixlarni kɵrsitip ⱪoysun; ");
INSERT INTO uigpin_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ular pǝⱪǝt muⱪǝddǝs jayƣa kirgǝndǝ muⱪǝddǝs buyumlarƣa bir dǝⱪiⱪimu ⱪarimisun, undaⱪ ⱪilip ⱪoysa ɵlüp ketidu. ");
INSERT INTO uigpin_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","23","Gǝrxon ǝwladliri iqidǝ ata jǝmǝti wǝ aililiri boyiqǝ, ottuz yaxtin ǝllik yaxⱪiqǝ bolƣan, jamaǝt qediri iqidǝ hizmǝt ⱪilix sepigǝ kirǝlǝydiƣan ⱨǝmmisini sanaⱪtin ɵtküzüp omumiy sanini al. ");
INSERT INTO uigpin_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gǝrxon aililirining ⱪilidiƣan hizmiti wǝ ular kɵtüridiƣan nǝrsilǝr tɵwǝndikiqǝ: ");
INSERT INTO uigpin_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","— ular jamaǝt qedirining ɵzini, yǝni astidiki iqki pǝrdiliri wǝ sirtⱪi pǝrdilirini, uning yapⱪuqini, xundaⱪla üstigǝ yapⱪan delfin terisidǝ etilgǝn yopuⱪni wǝ jamaǝt qedirining kirix ixikining pǝrdisini, ");
INSERT INTO uigpin_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ibadǝt qediri bilǝn ⱪurbangaⱨni qɵridǝp tartilƣan ⱨoylidiki pǝrdilǝr bilǝn kirix dǝrwazisining pǝrdisini, xularƣa has tanilirini wǝ ixlitidiƣan barliⱪ ⱪaqa-ⱪuqa ǝswablarni kɵtürsun; bu ǝswab-üskünilǝrgǝ munasiwǝtlik kerǝk bolƣan ixlarni ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gǝrxon ǝwladlirining pütün wǝzipisi, yǝni ular kɵtüridiƣan wǝ bejiridiƣan barliⱪ ixlar Ⱨarun wǝ uning oƣullirining kɵrsǝtmiliri boyiqǝ bolsun; ularning nemǝ kɵtüridiƣanliⱪini silǝr bǝlgilǝp beringlar. ");
INSERT INTO uigpin_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gǝrxon ǝwladlirining jǝmǝtlirining jamaǝt qedirining iqidǝ ⱪilidiƣan hizmiti xular; ular kaⱨin Ⱨarunning oƣli Itamarning ⱪol astida turup ixlisun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Mǝrarining ǝwladlirinimu, ularni ata jǝmǝti, aililiri boyiqǝ, sanaⱪtin ɵtküz; ");
INSERT INTO uigpin_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ottuz yaxtin ǝllik yaxⱪiqǝ bolƣan, jamaǝt qediri iqidǝ hizmǝt ⱪilix sepigǝ kirǝlǝydiƣan ⱨǝmmisini sanaⱪtin ɵtküzüp omumiy sanini al. ");
INSERT INTO uigpin_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ularning jamaǝt qediri iqidiki barliⱪ hizmiti, yǝni kɵtürüx wǝzipisi mundaⱪ: — Ular jamaǝt qedirining tahtayliri, baldaⱪliri, hadiliri wǝ ularning tǝglikliri, ");
INSERT INTO uigpin_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ⱨoylining tɵt ǝtrapidiki hadilar, ularning tǝglikliri, ⱪozuⱪliri, tanaliri, barliⱪ ǝswab-üskünǝ ⱨǝm xularƣa kerǝklik bolƣan barliⱪ nǝrsilǝrni kɵtürüx bolsun; ular kɵtüridiƣan ǝswab-üskünilǝrni namini atap bir-birlǝp ⱨǝr adǝmgǝ kɵrsitip beringlar. ");
INSERT INTO uigpin_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Mǝrari jǝmǝt-aililirining jamaǝt qediri iqidǝ ⱪilidiƣan barliⱪ ixliri ǝnǝ xular; ular kaⱨin Ⱨarunning oƣli Itamarning ⱪol astida turup ixlisun. ");
INSERT INTO uigpin_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","35","Musa bilǝn Ⱨarun wǝ jamaǝtning ǝmirliri Koⱨatning ǝwladlirining ottuz yaxtin ǝllik yaxⱪiqǝ bolƣan, jamaǝt qedirida hizmǝt ⱪilix sepigǝ kirǝlǝydiƣanlarning ⱨǝmmisini ata jǝmǝti, aililiri boyiqǝ sanaⱪtin ɵtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Ulardin jǝmǝti boyiqǝ sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ikki ming yǝttǝ yüz ǝllik kixi bolup qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Muxular Koⱨat jǝmǝtidin sanaⱪtin ɵtküzülgǝnlǝr bolup, jamaǝt qedirida ix ⱪilidiƣan ⱨǝrbiri, yǝni Pǝrwǝrdigarning Musaning wastisi bilǝn ⱪilƣan ǝmri boyiqǝ Musa bilǝn Ⱨarun sanaⱪtin ɵtküzgǝnlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","39","Gǝrxonlarning ata jǝmǝti, aililiri boyiqǝ, ottuz yaxtin ǝllik yaxⱪiqǝ bolƣan, jamaǝt qedirida hizmǝt ⱪilix sepigǝ kirǝlǝydiƣan ⱨǝmmisi sanaⱪtin ɵtküzüldi; ");
INSERT INTO uigpin_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ata jǝmǝti, aililiri boyiqǝ sanaⱪtin ɵtküzülgǝnlǝr jǝmiy ikki ming altǝ yüz ottuz kixi bolup qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Muxular Gǝrxon jǝmǝtidin sanaⱪtin ɵtküzülgǝnlǝr bolup, jamaǝt qedirida ix ⱪilidiƣan ⱨǝrbiri, yǝni Pǝrwǝrdigarning Musaning wastisi bilǝn ⱪilƣan ǝmri boyiqǝ Musa bilǝn Ⱨarun sanaⱪtin ɵtküzgǝnlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","43","Mǝrarilarning ata jǝmǝti, aililiri boyiqǝ, ottuz yaxtin ǝllik yaxⱪiqǝ bolƣan, jamaǝt qedirida hizmǝt ⱪilix sepigǝ kirǝlǝydiƣan ⱨǝmmisi sanaⱪtin ɵtküzüldi; ");
INSERT INTO uigpin_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ata jǝmǝti, aililiri boyiqǝ sanaⱪtin ɵtküzülgǝnlǝr jǝmiy üq ming ikki yüz kixi bolup qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Muxular Mǝrari jǝmǝtidin sanaⱪtin ɵtküzülgǝnlǝr bolup, jamaǝt qedirida ix ⱪilidiƣan ⱨǝrbiri, yǝni Pǝrwǝrdigarning Musaning wastisi bilǝn ⱪilƣan ǝmri boyiqǝ Musa bilǝn Ⱨarun sanaⱪtin ɵtküzgǝnlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","47","Sanaⱪtin ɵtküzülgǝn Lawiylar mana xular idi; Musa bilǝn Ⱨarun ⱨǝm Israillarning ǝmirliri ulardin ata jǝmǝti, aililiri boyiqǝ, ottuz yaxtin ǝllik yaxⱪiqǝ bolƣan, jamaǝt qedirida hizmǝt ⱪilix wǝ yük kütürüx wǝzipisigǝ kirǝlǝydiƣanlarni sanaⱪtin ɵtküzgǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Ularning sani jǝmiy sǝkkiz ming bǝx yüz sǝksǝn adǝm bolup qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Pǝrwǝrdigarning ǝmri boyiqǝ, ular Musa tǝripidin sanaⱪtin ɵtküzüldi; ⱨǝrkim ɵzi ⱪilidiƣan Ixi wǝ kɵtüridiƣan yükigǝ asasǝn sanaⱪtin ɵtküzüldi. Bularning ⱨǝmmisi Pǝrwǝrdigarning Musaƣa ǝmr ⱪilƣinidǝk boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","3","Sǝn Israillarƣa ǝmr ⱪilip: «Silǝr pisǝ-mahaw kesili bilǝn aⱪma kesiligǝ giriptar bolƣanlarni, xundaⱪla ɵlükkǝ tegixi bilǝn napak bolup ⱪalƣan ⱨǝmmisini ǝr-ayal demǝy bargaⱨtin qiⱪiriwetinglar. Bargaⱨlarni bulƣiwǝtmǝsliki üqün ularni bargaⱨtin qiⱪiriwetinglar; qünki Mǝn bargaⱨ otturisida makan ⱪildim» — degin, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Israillar xundaⱪ ⱪilip ularni bargaⱨtin qiⱪiriwǝtti; Pǝrwǝrdigar Musaƣa ⱪandaⱪ ǝmr ⱪilƣan bolsa, Israillar xundaⱪ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Sǝn Israillarƣa eytⱪin: — Mǝyli ǝr yaki ayal bolsun, ǝgǝr u insanlarning Pǝrwǝrdigarƣa wapasizliⱪ ⱪilidiƣan ⱨǝrⱪandaⱪ gunaⱨliridin birini sadir ⱪilip, xuning bilǝn gunaⱨkar dǝp bekitilsǝ, ");
INSERT INTO uigpin_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","undaⱪta u ɵzi ɵtküzgǝn gunaⱨiƣa iⱪrar ⱪilip, itaǝtsizliki kǝltürüp qiⱪarƣan, ziyanlanƣuqining ziyinini toluⱪ tɵlǝp berixi kerǝk wǝ uning sirtida u kixigǝ yǝnǝ bǝxtin bir ülüxni ⱪoxup tɵlǝp bǝrsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ziyanlanƣuqining mubada itaǝtsizlik kǝltürüp qiⱪarƣan ziyanƣa berilgǝn tɵlǝm pulini alƣudǝk tuƣⱪini bolmisa, tɵlǝm puli gunaⱨkar bolƣan kixining kafaritigǝ sunulidiƣan ⱪoxⱪarƣa ⱪoxulup, Pǝrwǝrdigarƣa atilip, kaⱨinƣa berilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Xuningdǝk Israillarning Hudaƣa atiƣan barliⱪ muⱪǝddǝs ⱨǝdiyǝliri, yǝni kaⱨinƣa kǝltürgǝn nǝrsilǝrdin barliⱪ «kɵtürmǝ ⱪurbanliⱪ-ⱨǝdiyǝ»lǝr kaⱨinƣa ⱨesab bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ⱨǝrkim Hudaƣa atiƣan ⱨǝdiyǝlǝr muⱪǝddǝs dǝp ⱨesablansun, xundaⱪla kaⱨinning bolsun; kixilǝr kaⱨinƣa nemǝ ⱨǝdiyǝ ⱪilsa, uning ⱨǝmmisi kaⱨinning bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Sǝn Israillarƣa sɵz ⱪilip mundaⱪ degin: — Əgǝr birsining hotuni ɵz eridin yüz ɵrügǝn, sadaⱪǝtsizlik ⱪilƣan bolsa, ");
INSERT INTO uigpin_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","— demǝk, baxⱪa birsi bilǝn yeⱪinlaxⱪan, xundaⱪla uning bulƣanƣanliⱪi erining kɵzliridin yoxurun bolƣan bolsa, ⱨeq guwaⱨqi bolmiƣan ⱨǝm gunaⱨ ⱪilƣan qeƣida tutulupmu ⱪalmiƣan bolsa, ");
INSERT INTO uigpin_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","xundaⱪ ǝⱨwalda, eri ɵz hotunidin guman ⱪilip künlisǝ, hotuni rastla zina ⱪilip bulƣanƣan bolsa (yaki ɵz hotuniƣa guman ⱪilip künlisimu, hotuni zina ⱪilmiƣan wǝ bulƣanmiƣan bolsa) ");
INSERT INTO uigpin_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ǝⱨwalini ispatlax üqün bu adǝm hotunini kaⱨinning yeniƣa ǝkǝlsun ⱨǝm hotuni üqün zɵrür axliⱪ ⱨǝdiyǝsi, yǝni arpa undin ondin bir ǝfaⱨni alƣaq kǝlsun; xu ⱨǝdiyǝning üstigǝ u ⱨeq zǝytun meyi ⱪuymisun yaki ⱨeq mǝstiki ⱪoxup ⱪoymisun; qünki bu kündaxliⱪ ⱨǝdiyǝsi, ǝslǝtmǝ axliⱪ ⱨǝdiyǝsi bolup, ularning ⱪǝbiⱨlikigǝ bolƣan ǝslǝtmidur. ");
INSERT INTO uigpin_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Kaⱨin u hotunni aldiƣa kǝltürüp, Pǝrwǝrdigarning ⱨuzurida turƣuzsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kaⱨin komzǝkkǝ muⱪǝddǝs sudin ⱪuyup, ibadǝt qedirining yǝr topisidin bir qimdim elip suƣa qeqip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kaⱨin u hotunni Pǝrwǝrdigarning ⱨuzurida turƣuzup, bexini eqip, ǝslǝtmǝ axliⱪ ⱨǝdiyǝsi, yǝni kündaxliⱪ ⱨǝdiyǝsini uning ⱪoliƣa tutⱪuzsun, andin kaⱨin ⱪoliƣa ⱪarƣix kǝltürgüqi ǝlǝm süyini alsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kaⱨin u hotunƣa ⱪǝsǝm iqküzüp, uningƣa «Dǝrwǝⱪǝ sǝn ⱨeqⱪandaⱪ adǝm bilǝn billǝ yatmiƣan, eringning ornida baxⱪa birsi bilǝn billǝ boluxⱪa ezip buzuⱪluⱪ ⱪilmiƣan bolsang, undaⱪta sǝn bu ⱪarƣix kǝltürgüqi ǝlǝm süyidin halas bolƣaysǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Lekin sǝn eringning ornida baxⱪa birsigǝ yeⱪinlixip ɵzüngni bulƣiƣan bolsang, eringdin baxⱪa bir ǝr sǝn bilǝn billǝ yatⱪan bolsa, —» desun; ");
INSERT INTO uigpin_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","22","andin kaⱨin u hotunƣa ⱪarƣix ⱪǝsimini iqküzgǝndin keyin, yǝnǝ uningƣa: «— Pǝrwǝrdigar yotangni yiglitip, ⱪorsiⱪingni ixxitiwǝtsun, xuningdǝk Pǝrwǝrdigar seni ɵz hǝlⱪing iqidǝ ⱪarƣix wǝ ⱪǝsǝm iqix dǝstikigǝ aylandursun; bu ⱪarƣix süyi iq-ⱪarningƣa kirip, ⱪorsiⱪingni ixxitiwǝtsun, yotangni yiglitiwǝtsun» degǝndǝ, u hotun: «Amin, amin» desun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Xuningdǝk kaⱨin bu ⱪarƣix sɵzlirini dǝptǝrgǝ pütüp ⱪoysun, xundaⱪla yazƣan sɵzlǝrni ǝlǝm süyigǝ qilisun, ");
INSERT INTO uigpin_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","andin u hotunƣa bu ⱪarƣix kǝltürgüqi ǝlǝm süyini iqküzsun, bu ⱪarƣix kǝltürgüqi su uning iqigǝ kirixi bilǝnla uningƣa azab-ǝlǝm bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kaⱨin u hotunning ⱪolidin kündaxliⱪ axliⱪ ⱨǝdiyǝsini elip, uni Pǝrwǝrdigarning ⱨuzurida pulanglitip bolƣandin keyin, ⱪurbangaⱨⱪa elip kǝlsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kaⱨin ⱨǝdiyǝdin bir siⱪim un elip, hatirǝ ⱨesabida ⱪurbangaⱨⱪa ⱪoyup kɵydürsun; andin u hotunƣa bu suni iqküzsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kaⱨin ǝmdi u hotunƣa suni iqküzgǝndin keyin, ǝgǝr u ⱨǝⱪiⱪiy bulƣanƣan bolup, ɵz erigǝ sadaⱪǝtsizlik ⱪilƣan bolsa, qoⱪum xundaⱪ boliduki, bu ⱪarƣix süyi uning iqigǝ kirgǝndin keyin uningƣa azab-ǝlǝm kǝltüridu; uning ⱪorsiⱪi ixxip, yotisi yigilǝp ketidu; xuning bilǝn u hotun ɵz hǝlⱪi iqidǝ ⱪarƣixⱪa ketidu. ");
INSERT INTO uigpin_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Lekin ǝgǝr u hotun bulƣanmiƣan pak bolsa, xu ixtin halas bolidu wǝ ǝksiqǝ ⱨamilidar bolup pǝrzǝntlik bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Mana bu kündaxliⱪ toƣrisidiki ⱪanundur; hotun ɵz erining ornida baxⱪa birsi bilǝn billǝ boluxi bilǝn ezip bulƣanƣan bolsa ");
INSERT INTO uigpin_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","wǝ yaki birsi hotunidin guman ⱪilip künlisǝ, undaⱪta u hotunini Pǝrwǝrdigarning aldida turƣuzsun, kaⱨin uningƣa xu ⱪanun boyiqǝ ⱨǝmmini ijra ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ənǝ xundaⱪ ⱪilƣanda, ǝr gunaⱨtin halas bolup, hotun ɵz gunaⱨini kɵtiridu. ");
INSERT INTO uigpin_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Sǝn Israillarƣa eytⱪin: «Mǝyli ǝr yaki ayal bolsun, «Ɵzümni Pǝrwǝrdigarƣa atap, nazariylardin bolimǝn» degǝn alaⱨidǝ bir ⱪǝsǝmni iqkǝn bolsa, ");
INSERT INTO uigpin_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","undaⱪta u ɵzini ⱨaraⱪ-xarabtin ayrip pǝrⱨiz tutsun; ⱨaraⱪ-xarab bilǝn ixlǝngǝn sirkinimu iqmisun yaki ⱨǝrⱪandaⱪ üzüm xǝrbitini iqmisun wǝ ⱨɵl-ⱪuruⱪ üzümlǝrnimu yemisun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ɵzini Pǝrwǝrdigarƣa atiƣan barliⱪ künlǝrdǝ, üzüm telidin qiⱪⱪan ⱨǝrⱪandaⱪ nǝrsini, mǝyli üzüm uruⱪi bolsun, posti bolsun, ularni yeyixkǝ bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ɵzümni Pǝrwǝrdigarƣa atidim dǝp ⱪǝsǝm ⱪilƣan künliridǝ, ularning bexiƣa ustira tǝgküzüxkǝ bolmaydu; ɵzini Pǝrwǝrdigarƣa atiƣan künlǝr ɵtüp bolmiƣuqǝ, u muⱪǝddǝs boluxi kerǝk; ular qaqlirini uzun ⱪoyuxi kerǝk.    ");
INSERT INTO uigpin_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","U ⱪǝsǝm iqkǝn barliⱪ künliridǝ ⱨeqⱪandaⱪ ɵlüklǝrgǝ yeⱪinlixixⱪa bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Uning ɵz atisi, anisi, ⱪerindixi yaki ⱨǝdǝ-singilliri ɵlüp ⱪalƣan bolsa, ularni dǝp ɵzini napak ⱪilmasliⱪi kerǝk; qünki bexida Pǝrwǝrdigarƣila has bolimǝn dǝp bǝrgǝn wǝdisining bǝlgisi bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ɵzini Hudaƣa atiwǝtkǝn barliⱪ künlǝrdǝ u Pǝrwǝrdigar aldida muⱪǝddǝs bolup tursun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Mubada bir kixi uning yenida tuyuⱪsiz ɵlüp ⱪelip, ɵzini Pǝrwǝrdigarƣa atiƣanliⱪning bǝlgisi bolƣan bexi bulƣanƣan bolsa, u ɵzini paklax küni wǝ keyinki yǝttinqi künimu qeqini aldursun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Sǝkkizinqi küni u ikki pahtǝkni yaki ikki baqkini elip jamaǝt qedirining dǝrwazisi aldida kaⱨinƣa tapxursun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kaⱨin birini gunaⱨ ⱪurbanliⱪi, yǝnǝ birini kɵydürmǝ ⱪurbanliⱪ süpitidǝ sunup, ɵlük sǝwǝbidin napak bolup ⱪalƣan gunaⱨini tilǝp kǝfarǝt ⱪilsun; nazariy xu künning ɵzidǝ ɵz bexini ⱪaytidin muⱪǝddǝs-pak ⱪilsun, ");
INSERT INTO uigpin_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","u ɵzini Pǝrwǝrdigarƣa atiƣan künlirini yengiwaxtin baxlisun, xuning bilǝn bir yaxliⱪ bir ǝrkǝk ⱪozini itaǝtsizlik ⱪurbanliⱪi ⱪilip sunsun; ilgiriki künliri bolsa inawǝtsiz ⱨesablansun; qünki uning ɵzini Pǝrwǝrdigarƣa atiƣan ⱨaliti bulƣanƣan. ");
INSERT INTO uigpin_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Nazariylardin biri ɵzini Pǝrwǝrdigarƣila atiƣan künlǝr toxⱪan künidǝ u toƣruluⱪ ⱪanun-bǝlgilimǝ mundaⱪ: — Kixilǝr uni jamaǝt qedirining dǝrwazisi aldiƣa ǝkǝlsun; ");
INSERT INTO uigpin_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","u ɵzi Pǝrwǝrdigarƣa sunulidiƣan kɵydürmǝ ⱪurbanliⱪ üqün bir yaxliⱪ bejirim ǝrkǝk ⱪozini, gunaⱨ ⱪurbanliⱪi üqün bir yaxliⱪ qixi bejirim bir ⱪozini, inaⱪliⱪ ⱪurbanliⱪi üqün bejirim bir ⱪoxⱪarni kǝltürsun, ");
INSERT INTO uigpin_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","xundaⱪla bir sewǝt petir nan, zǝytun meyi ilǝxtürülgǝn esil undin pixurulƣan toⱪaqlar ⱨǝmdǝ zǝytun meyi sürülüp mǝsiⱨlǝngǝn petir ⱨǝmǝk nanlar wǝ xu ⱪurbanliⱪlarning ⱪoxumqǝ axliⱪ ⱨǝdiyǝliri wǝ xarab ⱨǝdiyǝlirini kǝltürsun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kaⱨin bularni Pǝrwǝrdigarning ⱨuzuriƣa kǝltürüp, Nazariyning xu gunaⱨ ⱪurbanliⱪi bilǝn kɵydürmǝ ⱪurbanliⱪini sunsun; ");
INSERT INTO uigpin_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","u Pǝrwǝrdigarƣa atalƣan inaⱪliⱪ ⱪurbanliⱪi süpitidǝ ⱪoxⱪarni sunsun, uningƣa ⱪoxup bir sewǝt petir nanni sunsun; kaⱨin xular bilǝn tǝng Nazariy ⱪoxup tǝⱪdim ⱪilƣan axliⱪ ⱨǝdiyǝsi bilǝn xarab ⱨǝdiyǝsini kǝltürüp sunsun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Nazariy jamaǝt qedirining dǝrwazisi aldida ɵzini Pǝrwǝrdigarƣa atiƣanliⱪiƣa bǝlgǝ ⱪilip ⱪoyuwǝtkǝn qeqini qüxürüp, qeqini elip inaⱪliⱪ ⱪurbanliⱪi astidiki otⱪa ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nazariy xu tǝriⱪidǝ ɵzini Pǝrwǝrdigarƣila atiƣanliⱪ qeqini qüxürüp bolƣandin keyin, kaⱨin ⱪaynap pixirilƣan ⱪoxⱪarning bir aldi ⱪolini ⱨǝm sewǝttin bir petir nan bilǝn bir petir ⱨǝmǝk nanni elip kelip Nazariyning ⱪoliƣa tutⱪuzsun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Kaⱨin bularni Pǝrwǝrdigarning aldida pulanglatma ⱪurbanliⱪ süpitidǝ ɵrüsun; bular pulanglatma ⱪurbanliⱪ süpitidǝ sunƣan tɵx bilǝn kɵtürmǝ ⱨǝdiyǝ ⱪilinƣan aldi ⱪol bilǝn ⱪoxulup, muⱪǝddǝs dǝp ⱨesablinip kaⱨinƣa berilsun; andin keyin Nazariy xarab iqsǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Xular bolsa ⱪǝsǝm iqkǝn Nazariy toƣrisida, ɵzini Pǝrwǝrdigarƣa ataxta sunux zɵrür bolƣan ⱪurbanliⱪ-ⱨǝdiyǝlǝr toƣrisida bekitilgǝn ⱪanun-bǝlgilimidur; xuningdǝk uning ⱪoli nemigǝ yǝtsǝ xuni sunsimu bolidu; u iqkǝn ⱪǝsimi boyiqǝ, yǝni ɵzini Hudaƣa atax wǝdisi toƣruluⱪ xu nizam-bǝlgilimǝ boyiqǝ ⱨǝmmǝ ixni ada ⱪilsun; wǝdisigǝ ǝmǝl ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Sǝn Ⱨarun bilǝn uning oƣulliriƣa sɵz ⱪilip mundaⱪ degin: — Silǝr Israillarƣa mundaⱪ bǝht-bǝrikǝt tilǝnglar: — ");
INSERT INTO uigpin_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«Pǝrwǝrdigar silǝrgǝ bǝht-bǝrikǝt ata ⱪilƣay, silǝrni Ɵz panaⱨida saⱪliƣay; ");
INSERT INTO uigpin_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Pǝrwǝrdigar yüzini silǝrning üstünglarda yorutup, silǝrgǝ xapaǝt ⱪilƣay; ");
INSERT INTO uigpin_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Pǝrwǝrdigar yüzini üstünglarƣa ⱪaritip kɵtürüp, silǝrgǝ hatirjǝmlik bǝrgǝy!» — dǝp tilǝnglar. ");
INSERT INTO uigpin_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ular xundaⱪ ⱪilip namimni Israillarning üstigǝ ⱪonduridu wǝ Mǝn ularƣa bǝht-bǝrikǝt ata ⱪilimǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","2","Musa ibadǝt qedirini tikligǝn küni, u qedirni mǝsiⱨ ⱪilip maylap muⱪǝddǝs ⱪildi, xundaⱪla uning iqidiki barliⱪ ǝswab-jabduⱪlar, ⱪurbangaⱨ wǝ uning barliⱪ ⱪaqa-ⱪuqa ǝswablirini mǝsiⱨ ⱪilip maylap muⱪǝddǝs ⱪildi; xü küni xundaⱪ boldiki, Israilning ǝmirliri, yǝni ularning ata jǝmǝtining baxliⱪliri bolƣan, ⱪǝbilǝ ǝmirliri kelip ⱨǝdiyǝlǝrni sundi; xu ⱪǝbililǝrning ǝmirliri sanaⱪtin ɵtküzüx ixiƣa nazarǝt ⱪilƣuqilar idi.    ");
INSERT INTO uigpin_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ular ɵzlirining ⱨǝdiyǝlirini Pǝrwǝrdigarning ⱨuzuriƣa ⱨazir ⱪilixti, kǝltürülgǝn bu ⱨǝdiyǝlǝr jǝmiy bolup altǝ ⱨarwa, on ikki ɵküzdin ibarǝt idi; ⱨǝr ikki ǝmir birlixip birdin sayiwǝnlik ⱨarwa, ⱨǝrbir ǝmir birdin ɵküz elip kǝldi; ular bu ⱨǝdiyǝlǝrni qedirining aldiƣa ǝkilixti. ");
INSERT INTO uigpin_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Jamaǝt qedirining ixliriƣa ixlitix üqün sǝn bu nǝrsilǝrni ⱪobul ⱪilip, Lawiylarning ⱨǝrbirining bejiridiƣan ixliri boyiqǝ ularning ixlitixigǝ bǝrgin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Xuning bilǝn Musa ⱨarwa bilǝn ɵküzlǝrni ⱪobul ⱪilip Lawiylarƣa tapxurup bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","U Gǝrxon ǝwladlirining ⱪilidiƣan ixliriƣa asasǝn, ularƣa ikki ⱨarwa bilǝn tɵt ɵküz bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Mǝrari ǝwladlirining ⱪilidiƣan ixliriƣa asasǝn, ularƣa tɵt ⱨarwa bilǝn sǝkkiz ɵküz bǝrdi; ularning ⱨǝmmisi kaⱨin Ⱨarunning oƣli Itamarƣa ⱪaraytti; ");
INSERT INTO uigpin_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","lekin u Koⱨatning ǝwladliriƣa ⱨeqnemǝ bǝrmidi; qünki ular muⱪǝddǝs nǝrsilǝrni kɵtürüxkǝ mǝs’ul idi; demǝk, ular mǝs’ul bolƣan nǝrsilǝrni ɵz mürisidǝ kɵtürǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ⱪurbangaⱨ maylinip mǝsiⱨlǝngǝn küni, uni Hudaƣa beƣixlax yolida ǝmirlǝr sunidiƣan ⱨǝdiyǝlirini elip kelip, ⱪurbangaⱨ aldiƣa ⱪoyuxti. ");
INSERT INTO uigpin_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Pǝrwǝrdigar Musaƣa: — Ular ⱪurbangaⱨni beƣixlax yolida ⱨǝdiyǝlirini sunsun; ⱨǝrbir ǝmir ɵz künidǝ sunsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Birinqi küni ⱨǝdiyǝ sunƣuqi Yǝⱨuda ⱪǝbilisidin Amminadabning oƣli Naⱨxon boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","kɵydürmǝ ⱪurbanliⱪ üqün bir ǝrkǝk torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Amminadabning oƣli Naⱨxon sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ikkinqi küni ⱨǝdiyǝ sunƣuqi Issakarning ǝmiri Zuarning oƣli Nǝtanǝl boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Zuarning oƣli Nǝtanǝl sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Üqinqi küni ⱨǝdiyǝ sunƣuqi Zǝbulun ǝwladlirining ǝmiri Ⱨelonning oƣli Eliab boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Ⱨelonning oƣli Eliab sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Tɵtinqi küni ⱨǝdiyǝ sunƣuqi Rubǝn ǝwladlirining ǝmiri Xidɵrning oƣli Əlizur boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Xidɵrning oƣli Əlizur sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Bǝxinqi küni ⱨǝdiyǝ sunƣuqi Ximeon ǝwladlirining ǝmiri Zuri-xaddayning oƣli Xelumiyǝl boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Zuri-xaddayning oƣli Xelumiyǝl sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Altinqi küni ⱨǝdiyǝ sunƣuqi Gad ǝwladlirining ǝmiri Deuǝlning oƣli Əliasaf boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Deuǝlning oƣli Əliasaf sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Yǝttinqi küni ⱨǝdiyǝ sunƣuqi Əfraim ǝwladlirining ǝmiri Ammiⱨudning oƣli Əlixama boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Ammiⱨudning oƣli Əlixama sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Sǝkkizinqi küni ⱨǝdiyǝ sunƣuqi Manassǝⱨ ǝwladlirining ǝmiri Pidaⱨzurning oƣli Gamaliyǝl boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Pidaⱨzurning oƣli Gamaliyǝl sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Toⱪⱪuzinqi küni ⱨǝdiyǝ sunƣuqi Benyamin ǝwladlirining ǝmiri Gideonining oƣli Abidan boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Gideonining oƣli Abidan sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Oninqi küni ⱨǝdiyǝ sunƣuqi Dan ǝwladlirining ǝmiri Ammixaddayning oƣli Aⱨiezǝr boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝ bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Ammixaddayning oƣli Aⱨiezǝr sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On birinqi küni ⱨǝdiyǝ sunƣuqi Axir ǝwladlirining ǝmiri Okranning oƣli Pagiyǝl boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Okranning oƣli Pagiyǝl sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On ikkinqi küni ⱨǝdiyǝ sunƣuqi Naftali ǝwladlirining ǝmiri Enanning oƣli Aⱨira boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","U sunƣan ⱨǝdiyǝ eƣirliⱪi bir yüz ottuz xǝkǝl kelidiƣan bir kümüx legǝn, eƣirliⱪi yǝtmix xǝkǝl kelidiƣan bir kümüx das bolup, bular muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝndi; axliⱪ ⱨǝdiyǝsi bolsun dǝp ikkisigǝ zǝytun meyi arilaxturulƣan esil un toldurulƣanidi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","on xǝkǝl eƣirliⱪta, huxbuy toldurulƣan bir altun piyalǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","kɵydürmǝ ⱪurbanliⱪ üqün bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bir ǝrkǝk ⱪoza; ");
INSERT INTO uigpin_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","gunaⱨ ⱪurbanliⱪi üqün bir tekǝ; ");
INSERT INTO uigpin_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","inaⱪliⱪ ⱪurbanliⱪi üqün ikki buⱪa, bǝx ⱪoqⱪar, bǝx tekǝ, bir yaxliⱪ bǝx ǝrkǝk ⱪoza; bular Enanning oƣli Aⱨira sunƣan ⱨǝdiyǝlǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ⱪurbangaⱨ maylinip mǝsiⱨlǝngǝn künidǝ, Israil ǝmirliri ⱪurbangaⱨⱪa sunƣan ⱨǝdiyǝlǝr: — jǝmiy on ikki kümüx legǝn, on ikki kümüx das, on ikki altun piyalǝ boldi, ");
INSERT INTO uigpin_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ⱨǝrbir kümüx legǝnning eƣirliⱪi bir yüz ottuz xǝkǝl, ⱨǝrbir kümüx dasning eƣirliⱪi yǝtmix xǝkǝl idi; muxu ⱪaqa-ⱪuqiƣa kǝtkǝn kümüx muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝngǝndǝ, jǝmiy ikki ming tɵt yüz xǝkǝl qiⱪti; ");
INSERT INTO uigpin_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","huxbuy bilǝn toldurulƣan altun piyalǝ on ikki bolup, muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ ɵlqǝngǝndǝ, ⱨǝrbir altun piyalining eƣirliⱪi on xǝkǝl qiⱪti; bu altun piyalilǝrning altuni jǝmiy bir yüz yigirmǝ xǝkǝl qiⱪti; ");
INSERT INTO uigpin_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","kɵydürmǝ ⱪurbanliⱪlar üqün bolƣan mallar: — jǝmiy on ikki torpaⱪ, on ikki ⱪoqⱪar, on ikki bir yaxliⱪ ǝrkǝk ⱪoza idi, ⱨǝrbiri tegixlik axliⱪ ⱨǝdiyǝliri bilǝn billǝ sunuldi; on ikki tekǝ gunaⱨ ⱪurbanliⱪi üqün sunuldi; ");
INSERT INTO uigpin_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","inaⱪliⱪ ⱪurbanliⱪliri üqün sunulƣini jǝmiy yigirmǝ tɵt buⱪa, atmix ⱪoqⱪar, atmix tekǝ, bir yaxliⱪ atmix ǝrkǝk ⱪoza idi. Ⱪurbangaⱨ maylinip mǝsiⱨlinip, uni Hudaƣa beƣixlax yolida sunulƣan ⱨǝdiyǝlǝr mana muxular. ");
INSERT INTO uigpin_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa Pǝrwǝrdigar bilǝn sɵzlǝxkili jamaǝt qediriƣa kirgǝn qeƣida, u «ⱨɵküm-guwaⱨliⱪ sanduⱪi»ning üstidiki «kǝfarǝt tǝhti»ning ikki tǝripidiki kerubning otturisidin uning ɵzigǝ gǝp ⱪilƣan awazini anglap turdi; Pǝrwǝrdigar xu yolda uningƣa sɵz ⱪilatti. ");
INSERT INTO uigpin_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Sǝn Ⱨarunƣa: «Sǝn qiraƣlar yaⱪidiƣan qaƣda yǝttǝ qiraƣning ⱨǝmmisi qiraƣdanning aldini yorutidiƣan bolsun» dǝp eytip ⱪoy, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ⱨarun xundaⱪ ⱪildi; u qiraƣdan üstidiki qiraƣlarning ⱨǝmmisini yandurup, huddi Pǝrwǝrdigarning Musaƣa eytⱪinidǝk, qiraƣ nurini qiraƣdanning aldini yorutidiƣan ⱪilip ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Qiraƣdanning yasilixi mundaⱪ: u altundin bolⱪa bilǝn soⱪup yasalƣan, putidin güllirigiqǝ bolⱪa bilǝn soⱪup qiⱪirilƣan. Pǝrwǝrdigar Musaƣa kɵrsǝtkǝn nushidǝk, u qiraƣdanni xundaⱪ yasatti. ");
INSERT INTO uigpin_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Sǝn Israillarning iqidin Lawiylarni tallap qiⱪip pakliƣin. ");
INSERT INTO uigpin_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ularni paklax üqün ularƣa mundaⱪ ⱪil: «kǝfarǝt süyi»ni ularning bǝdinigǝ qaqⱪin; andin ular ɵzliri pütün bǝdinini ustura bilǝn qüxürsun, kiyimlirini yuyup ɵzini pak ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Andin keyin ular bir torpaⱪ bilǝn xuningƣa ⱪoxup axliⱪ ⱨǝdiyǝsini, yǝni zǝytun meyi ilǝxtürülgǝn esil unni kǝltürsun; sǝn gunaⱨ ⱪurbanliⱪi üqün yǝnǝ bir torpaⱪni kǝltür. ");
INSERT INTO uigpin_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Sǝn Lawiylarni jamaǝt qedirining aldiƣa kǝltür wǝ pütün Israil jamaitini yiƣip kǝl; ");
INSERT INTO uigpin_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Lawiylarni Pǝrwǝrdigarning ⱨuzuriƣa ⱨazir ⱪilƣin; andin Israillar kelip ⱪollirini ularning üstigǝ ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ⱨarun Lawiylarni Israillarning «pulanglatma ⱪurbanliⱪ»i süpitidǝ Pǝrwǝrdigarning hizmitini ⱪilsun dǝp, Pǝrwǝrdigarƣa ⱨǝdiyǝ ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Lawiylar ⱪollirini ⱨeliⱪi ikki torpaⱪning bexiƣa ⱪoysun; sǝn birini gunaⱨ ⱪurbanliⱪi bolsun, birini kɵydürmǝ ⱪurbanliⱪ bolsun, Lawiylar üqün kǝfarǝt kǝltürsun dǝp Pǝrwǝrdigarƣa sunƣin. ");
INSERT INTO uigpin_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Sǝn andin Lawiylarni Ⱨarun bilǝn uning oƣullirining aldida turƣuzup, ularni pulanglatma ⱪurbanliⱪ süpitidǝ Pǝrwǝrdigarƣa ⱨǝdiyǝ ⱪil. ");
INSERT INTO uigpin_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Lawiylar Meningki bolsun dǝp, sǝn Lawiylarni ǝnǝ xu tǝriⱪidǝ Israillardin ayrip qiⱪ. ");
INSERT INTO uigpin_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Andin Lawiylar kirip jamaǝt qedirining ixlirini ⱪilsa bolidu; sǝn ularni paklandur, ularni pulanglatma ⱪurbanliⱪ süpitidǝ ⱨǝdiyǝ ⱪil. ");
INSERT INTO uigpin_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Qünki ular Israillar iqidǝ pütünlǝy Manga atalƣan; Mening ularni Meningki bolsun dǝp tallixim ularni Israillarning arisida baliyatⱪuning tunji mewisi ornida ⱪoyƣanliⱪimdur. ");
INSERT INTO uigpin_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Qünki Israillarning tunjisi, mǝyli u insan yaki ⱨaywan bolsun, pütünlǝy Manga tǝwǝdur; Mǝn Misir zeminida barliⱪ tunjilarni ɵltürgǝn küni ularni Ɵzümgǝ muⱪǝddǝs ⱪilip eliwalƣanidim. ");
INSERT INTO uigpin_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mening Lawiylarni u yol bilǝn tallixim ularni Israillarning iqidiki tunjilirining ornida ⱪoyuxum üqündur. ");
INSERT INTO uigpin_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Wǝ jamaǝt qedirida Israillarning hizmitidǝ bolsun wǝ Israillarning gunaⱨini tilǝp kǝfarǝt kǝltürsun, xuningdǝk Israillar muⱪǝddǝs jayƣa yeⱪinlaxⱪanda ular arisida bala-ⱪaza qiⱪmisun dǝp, Mǝn Israillar iqidin Lawiylarni Ⱨarun bilǝn uning oƣulliriƣa bǝrdim». ");
INSERT INTO uigpin_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, Ⱨarun wǝ pütkül Israil jamaiti Lawiylarni xundaⱪ ⱪildi; Pǝrwǝrdigarning Lawiylar toƣruluⱪ Musaƣa buyruƣinidǝk Israillar ⱨǝmmisini bǝja kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lawiylar xundaⱪ ⱪilip ɵzlirini gunaⱨtin paklap, kiyim-keqǝklirini yuyup pakizlidi; Ⱨarun ularni pulanglatma ⱪurbanliⱪ süpitidǝ Pǝrwǝrdigarƣa ⱨǝdiyǝ ⱪildi; Ⱨarun yǝnǝ ularni paklaxⱪa gunaⱨini tilǝp kǝfarǝt ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Andin keyin Lawiylar kirip Ⱨarunning aldida, xundaⱪla uning oƣullirining aldida, jamaǝt qediri iqidiki ixlarni ⱪilixⱪa kirixti; Pǝrwǝrdigar Lawiylar toƣruluⱪ Musaƣa ⱪandaⱪ buyruƣan bolsa, Israillar uni xu boyiqǝ bǝja kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Lawiylarning wǝzipisi mundaⱪ bolsun: — Yigirmǝ bǝx yaxtin yuⱪiriliri kirip jamaǝt qediri iqidiki ixlarni ⱪilixⱪa sǝpkǝ kirsun; ");
INSERT INTO uigpin_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ǝllik yaxⱪa yǝtkǝndin keyin sǝptin qekinip xu hizmǝtni ⱪilmisun; ");
INSERT INTO uigpin_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","lekin ular jamaǝt qediri iqidǝ ⱪerindaxliriƣa yardǝmlixip, ularning ⱨajǝtliridin qiⱪixⱪa bolidu, ǝmma qedirdiki rǝsmiy wǝzipidǝ bolmisun. Lawiylarning wǝzipiliri ⱨǝⱪⱪidǝ ularƣa ǝnǝ xundaⱪ ⱪil». ");
INSERT INTO uigpin_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Misir zeminidin qiⱪⱪandin keyinki ikkinqi yili birinqi ayda, Pǝrwǝrdigar Sinay qɵlidǝ Musaƣa buyrup: — ");
INSERT INTO uigpin_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Israillar bekitilgǝn waⱪitta ɵtüp ketix ⱨeytini ɵtküzsun; ");
INSERT INTO uigpin_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","yǝni muxu ayning on tɵtinqi küni gugumda, bekitilgǝn waⱪitta, barliⱪ bǝlgilimǝ wǝ ⱪaidǝ-tǝrtip boyiqǝ ⱨeytni ɵtküzünglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Xuning bilǝn Musa Israillarƣa sɵz ⱪilip ɵtüp ketix ⱨeytini ɵtküzüxni buyrudi. ");
INSERT INTO uigpin_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ular birinqi ayning on tɵtinqi küni gugumda, Sinay qɵlidǝ ɵtüp ketix ⱨeytini ɵtküzdi; Pǝrwǝrdigar Musaƣa ⱪandaⱪ buyruƣan bolsa, Israillar xundaⱪ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Bir nǝqqǝylǝn bir ɵlükkǝ tegip ketip napak bolup ⱪalƣanliⱪi üqün, ular xu küni ɵtüp ketix ⱨeytini ɵtküzǝlmidi-dǝ, ular xu küni Musa bilǝn Ⱨarunning aldiƣa kelip Musaƣa: — ");
INSERT INTO uigpin_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Biz ɵlüp ⱪalƣan adǝmgǝ tegip ketip napak bolup ⱪalƣan bolsaⱪmu, lekin nemixⱪa Israillarning ⱪatarida, bekitilgǝn waⱪitta Pǝrwǝrdigarƣa sunuxⱪa kerǝk bolƣinini elip kelixtin rǝt ⱪilinimiz? — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","— Tohtap turunglar, mǝn berip Pǝrwǝrdigar silǝr toƣranglarda nemǝ buyruydikin, anglap baⱪay, — dedi Musa ularƣa. ");
INSERT INTO uigpin_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Sǝn Israillarƣa mundaⱪ degin: «Silǝr wǝ silǝrning ǝwladliringlar iqidǝ bǝzilǝr ɵlüklǝrgǝ tegip ketip napak bolup ⱪalƣan bolsa yaki uzaⱪ sǝpǝr üstidǝ bolsa, ular yǝnila Pǝrwǝrdigar üqün ɵtüp ketix ⱨeytini ɵtküzüxkǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Undaⱪ kixilǝr ikkinqi ayning on tɵtinqi küni gugumda ⱨeytni ɵtküzsun; ⱨeyt taamini petir nan wǝ aqqiⱪ kɵktatlar bilǝn billǝ yesun; ");
INSERT INTO uigpin_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ulardin ǝtigǝ azraⱪmu ⱪaldurmisun wǝ ⱪozisining ustihanliridin birǝrsinimu sundurƣuqi bolmisun; ular ⱨeytni ɵtüp ketix ⱨeytining barliⱪ bǝlgilimiliri boyiqǝ ɵtküzsun.    ");
INSERT INTO uigpin_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ⱨalbuki, pak bolƣan, sǝpǝr üstidimu bolmiƣan ǝmma ɵtüp ketix ⱨeytini ɵtküzüxkǝ etibar bǝrmigǝn kixi bolsa ɵz hǝlⱪidin üzüp taxlinidu; qünki bekitilgǝn waⱪitta Pǝrwǝrdigarƣa sunux kerǝk bolƣinini sunmiƣanliⱪi üqün, u ɵz gunaⱨini ɵz üstigǝ alidu. ");
INSERT INTO uigpin_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Əgǝr aranglarda turuwatⱪan yat ǝllik bir musapir Pǝrwǝrdigar üqün ɵtüp ketix ⱨeytini ɵtküzüxni halisa, u ɵtüp ketix ⱨeyti toƣrisidiki bǝlgilimǝ wǝ ⱪaidǝ-tǝrtip boyiqǝ ɵtküzsun; yat ǝllik musapirlar üqün wǝ zeminda tuƣulƣanlar üqünmu aranglarda xu birla nizam bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ibadǝt qediri tiklǝngǝn küni, bulut ibadǝt qedirini, yǝni ⱨɵküm-guwaⱨliⱪ qedirini ⱪaplap turdi; kǝqtin taki ǝtigǝngiqǝ, bulut huddi ottǝk ibadǝt qedirining üstidǝ turdi.    ");
INSERT INTO uigpin_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Daim xundaⱪ bolatti; kündüzi bulut ibadǝt qedirini ⱪaplap turatti, keqisi u otⱪa ohxaytti. ");
INSERT INTO uigpin_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ⱪaqaniki bulut jamaǝt qedirining üstidin kɵtürülsǝ, Israillar yolƣa qiⱪatti; bulut ⱪǝyǝrdǝ tohtisa, Israillar xu yǝrdǝ bargaⱨ tikǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israillar Pǝrwǝrdigarning buyruⱪi boyiqǝ mangatti, Pǝrwǝrdigarning buyruⱪi boyiqǝ bargaⱨ tikǝtti; bulut ibadǝt qedirining üstidǝ ⱪanqǝ uzaⱪ tohtisa, ular bargaⱨta xunqǝ uzaⱪ turatti. ");
INSERT INTO uigpin_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Bulut ibadǝt qedirining üstidǝ heli künlǝrgiqǝ tohtap tursa, Israillarmu Pǝrwǝrdigarning kɵrsitmisini tutup sǝpǝrgǝ qiⱪmaytti; ");
INSERT INTO uigpin_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","mubada bulut ibadǝt qedirining üstidǝ pǝⱪǝt birnǝqqǝ künla tohtisa, ular Pǝrwǝrdigarning buyruⱪi boyiqǝ xu waⱪitta bargaⱨ ⱪurup yatatti, andin yǝnǝ Pǝrwǝrdigarning buyruⱪi boyiqǝ sǝpǝrgǝ atlinatti. ");
INSERT INTO uigpin_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Wǝ mubada bulut pǝⱪǝtla kǝqtin ǝtigǝngiqǝ tohtap, ǝttigǝndǝ bulut yǝnǝ kɵtürülsǝ, ular yǝnǝ yolƣa qiⱪatti; mǝyli kündüzi yaki keqisi bulut kɵtürülsila, ular sǝpǝrgǝ qiⱪatti. ");
INSERT INTO uigpin_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Bulut ibadǝt qedirining üstidǝ uzunraⱪ tursa, mǝyli ikki kün, bir ay, bir yil tursimu, Israillar yolƣa qiⱪmay bargaⱨta turuwerǝtti; lekin bulut kɵtürülüp mangsila ular sǝpirini dawamlaxturatti. ");
INSERT INTO uigpin_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Pǝrwǝrdigarning buyruⱪi bilǝn ular bargaⱨ ⱪuratti, Pǝrwǝrdigarning buyruⱪi bilǝn ular sǝpǝrni dawamlaxturatti; ular Pǝrwǝrdigarning Musaning wastisi bilǝn bǝrgǝn ǝmri boyiqǝ, Pǝrwǝrdigarning kɵrsitmisini tutatti. ");
INSERT INTO uigpin_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Sǝn ɵzünggǝ ikki kanay yasatⱪin; ularni kümüxtin soⱪtur. Ular jamaǝtni yiƣixⱪa, xundaⱪla jamaǝtni bargaⱨlirini yiƣixturup yolƣa qiⱪixⱪa qaⱪirix üqün ixlitilidu. ");
INSERT INTO uigpin_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ikki kanay qelinƣanda pütkül jamaǝt sening yeningƣa jamaǝt qediri dǝrwazisining aldiƣa yiƣilidiƣan bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Əgǝr yalƣuz biri qelinsa, ǝmirliri, yǝni mingliƣan Israillarning mingbexiliri sening yeningƣa kelip yiƣilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Silǝr ⱪattiⱪ yuⱪiri awaz bilǝn qalƣanda kün qiⱪix tǝrǝptiki bargaⱨlar yolƣa qiⱪsun. ");
INSERT INTO uigpin_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Andin silǝr ikkinqi ⱪetim ⱪattiⱪ, yuⱪiri awaz bilǝn qalƣanda jǝnub tǝrǝptiki bargaⱨlar yolƣa qiⱪsun; ular yolƣa qiⱪⱪan qaƣda kanay ⱪattiⱪ, yuⱪiri awaz bilǝn qelinixi kerǝktur. ");
INSERT INTO uigpin_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Jamaǝtni yiƣilixⱪa qaⱪiridiƣan qaƣda, kanay qelinglar, ǝmma ⱪattiⱪ, yuⱪiri awaz bilǝn qalmanglar; ");
INSERT INTO uigpin_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ⱨarunning ǝwladliri, kaⱨin bolƣanlar kanaylarni qalsun; bular silǝrgǝ ǝwladmu-ǝwlad bir ǝbǝdiy bǝlgilimǝ bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Əgǝr silǝr ɵz zemininglarda silǝrgǝ zulum salƣan düxmininglar bilǝn jǝng ⱪilixⱪa qiⱪsanglar, ⱪattiⱪ, yuⱪiri awaz bilǝn qelinglar. Xuning bilǝn ɵzünglarning Hudasi bolƣan Pǝrwǝrdigarning aldida yad etilip, düxmininglardin ⱪutulisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Buningdin baxⱪa, huxal künliringlarda, bekitilgǝn ⱨeytliringlarda wǝ ayning birinqi künliridǝ, silǝr kɵydürmǝ ⱪurbanliⱪ wǝ inaⱪliⱪ ⱪurbanliⱪlirini sunƣininglarda, ⱪurbanliⱪlarning aldida turup kanay qelinglar; xuning bilǝn kanaylar silǝrni Hudayinglarƣa ǝslǝtküqi bolidu; Mǝn Hudayinglar Pǝrwǝrdigardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ikkinqi yili, ikkinqi ayning yigirminqi küni bulut ⱨɵküm-guwaⱨliⱪ qedirining üstidin kɵtürüldi; ");
INSERT INTO uigpin_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","xuning bilǝn Israillar Sinay qɵlidin qiⱪip, yol elip sǝpǝrlirini baxlidi; bulut Paran qɵlidǝ tohtidi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Bu ularning birinqi ⱪetim Pǝrwǝrdigarning Musaning wastisi bilǝn ⱪilƣan ǝmri boyiqǝ yolƣa qiⱪixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yǝⱨuda bargaⱨi ɵzining tuƣi astida ⱪoxun-ⱪoxun bolup aldi bilǝn yolƣa qiⱪti; ⱪoxunning baxliⱪi Amminadabning oƣli Naⱨxon idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Issakar ⱪǝbilisi ⱪoxunining baxliⱪi Zuarning oƣli Nǝtanǝl idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zǝbulun ⱪǝbilisi ⱪoxunining baxliⱪi Ⱨelonning oƣli Eliab idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Andin ibadǝt qediri quwulup, Gǝrxonning ǝwladliri bilǝn Mǝrarining ǝwladliri uni kɵtürüp yolƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Rubǝn bargaⱨi ɵzining tuƣi astida ⱪoxun-ⱪoxun bolup yolƣa qiⱪti; ⱪoxunning baxliⱪi Xidɵrning oƣli Əlizur idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ximeon ⱪǝbilisi ⱪoxunining baxliⱪi Zuri-xaddayning oƣli Xelumiyǝl idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad ⱪǝbilisi ⱪoxunining baxliⱪi Deuǝlning oƣli Əliasaf idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Andin Koⱨatlar muⱪǝddǝs buyumlarni kɵtürüp yolƣa qiⱪti; ular yetip kelixtin burun ibadǝt qedirini kɵtürgüqilǝr kelip uni tiklǝp ⱪoyuxⱪanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Əfraim bargaⱨi ɵzining tuƣi astida ⱪoxun-ⱪoxun bolup yolƣa qiⱪti; ⱪoxunning baxliⱪi Ammiⱨudning oƣli Əlixama idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manassǝⱨ ⱪǝbilisi ⱪoxunining baxliⱪi Pidaⱨzurning oƣli Gamaliyǝl idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Binyamin ⱪǝbilisi ⱪoxunining baxliⱪi Gideonining oƣli Abidan idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Dan bargaⱨi ⱨǝmmǝ bargaⱨlarning arⱪa muⱨapizǝtqisi bolup, ɵzining tuƣi astida ⱪoxun-ⱪoxun bolup yolƣa qiⱪti; ⱪoxunning baxliⱪi Ammixaddayning oƣli Aⱨiezǝr idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Axir ⱪǝbilisi ⱪoxunining baxliⱪi Okranning oƣli Pagiyǝl idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Naftali ⱪǝbilisi ⱪoxunining baxliⱪi Enanning oƣli Aⱨira idi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Bular Israillar yolƣa qiⱪⱪanda ⱪoxun-ⱪoxun bolup mengix tǝrtipi idi; ular xu tǝriⱪidǝ yolƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa ɵzining ⱪeynatisi, Midiyanliⱪ Reuǝlning oƣli Ⱨobabⱪa: — Biz Pǝrwǝrdigar wǝdǝ ⱪilƣan yǝrgǝ ⱪarap sǝpǝr ⱪiliwatimiz, U: «Mǝn u yǝrni silǝrgǝ miras ⱪilip berimǝn» degǝn; ɵzlirining biz bilǝn billǝ mengixlirini ɵtünimǝn, biz siligǝ yahxi ⱪaraymiz, qünki Pǝrwǝrdigar Israil toƣruluⱪ bǝht-saadǝt ata ⱪilimǝn dǝp wǝdǝ bǝrgǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Lekin Ⱨobab Musaƣa: — Yaⱪ, mǝn ɵz yurtum, ɵz uruⱪ-tuƣⱪanlirimƣa ketimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa uningƣa: Bizdin ayrilip kǝtmisilǝ; qünki sili qɵldǝ ⱪandaⱪ bargaⱨ ⱪuruximiz kerǝklikini bilila, sili bizgǝ kɵz bolup bǝrsilǝ. ");
INSERT INTO uigpin_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Xundaⱪ boliduki, biz bilǝn billǝ barsila, kǝlgüsidǝ Pǝrwǝrdigar bizgǝ ⱪandaⱪ yahxiliⱪ ⱪilsa, bizmu siligǝ xundaⱪ ⱪilimiz! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Israillar Pǝrwǝrdigar teƣidin yolƣa qiⱪip üq kün yol mangdi; Pǝrwǝrdigarning ǝⱨdǝ sanduⱪi ularƣa aram alidiƣan yǝr izdǝp ularning aldida üq kün yol baxlap mangdi. ");
INSERT INTO uigpin_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ular qedirlirini yiƣixturup yolƣa qiⱪidiƣan qaƣlarda, Pǝrwǝrdigarning buluti ⱨaman ularning üstidǝ bolatti. ");
INSERT INTO uigpin_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Əⱨdǝ sanduⱪi yolƣa qiⱪidiƣan qaƣda Musa: «Ornungdin turƣaysǝn, i Pǝrwǝrdigar; düxmǝnliring tiripirǝn bolsun; Sanga ɵqlǝr yüzüngning aldidin ⱪaqsun!» — dǝytti. ");
INSERT INTO uigpin_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Əⱨdǝ sanduⱪi tohtiƣan qaƣda u: «Ⱪaytip kǝlgǝysǝn, i Pǝrwǝrdigar, mingliƣan-tümǝnligǝn Israil hǝlⱪi arisiƣa ⱪaytip kǝlgǝysǝn!» — dǝytti. ");
INSERT INTO uigpin_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Wǝ xundaⱪ boldiki, hǝlⱪ ƣotuldixatti, ularning ƣotuldaxliri Pǝrwǝrdigarning ⱪuliⱪiƣa yetip intayin rǝzil anglandi; U bu sɵzlǝrni anglidi wǝ Uning ƣǝzipi ⱪozƣaldi; Pǝrwǝrdigarning ot-yalⱪuni ularning arisida tutixip, bargaⱨning qetidiki bǝzilǝrni kɵydürüxkǝ baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Hǝlⱪ bu qaƣda Musaƣa yalwuriwidi, Musa Pǝrwǝrdigardin tilidi; xuning bilǝn ot pǝsiyip ɵqti. ");
INSERT INTO uigpin_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Pǝrwǝrdigarning oti ularning otturisida tutaxⱪanliⱪi üqün u u yǝrgǝ «Tabǝraⱨ» dǝp at ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ularning arisidiki xalƣut kixilǝrning nǝpsi taⱪildap kǝtti, Israillarmu yǝnǝ yiƣlaxⱪa baxlidi: «Əmdi bizgǝ kim gɵx beridu?    ");
INSERT INTO uigpin_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ⱨelimu esimizdiki, biz Misirdiki qaƣlarda pul hǝjlimǝy turupmu beliⱪ yeyǝlǝyttuⱪ, yǝnǝ tǝrhǝmǝk, tawuz, piyaz wǝ küdǝ piyaz bilǝn samsaⱪmu bar idi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mana bu yǝrdǝ ⱨazir kɵz aldimizda mannadin baxⱪa ⱨeqnemǝ yoⱪ, ǝmdi bizning jenimizmu ⱪurup ketiwatidu» deyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna goya yumƣaⱪsüt uruⱪiƣa, kɵrünüxi goya kǝⱨriwaƣa ohxaytti. ");
INSERT INTO uigpin_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Kixilǝr uyan-buyan qepip uni yiƣip, bǝzidǝ yarƣunqaⱪta ezip, bǝzidǝ ⱨawanqida soⱪup, ya bǝzidǝ ⱪazanda pixurup nan ⱪilip yǝytti; tǝmi zǝytun mayliⱪ toⱪaqlarƣa ohxaytti. ");
INSERT INTO uigpin_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Keqidǝ bargaⱨⱪa xǝbnǝm qüxkǝndǝ, mannamu xuning üstigǝ qüxǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa hǝlⱪning ailimu-ailǝ ⱨǝrbiri ɵz qedirining ixiki aldida yiƣa-zar ⱪilixiwatⱪinini anglidi; buningƣa Pǝrwǝrdigarning ƣǝzipi ⱪattiⱪ ⱪozƣaldi, bu ix Musaning nǝziridimu yaman kɵründi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa Pǝrwǝrdigarƣa: — Sǝn bu barliⱪ hǝlⱪning eƣir yükini manga artip ⱪoyup, mǝn ⱪulungni nemixⱪa bundaⱪ ⱪiynaysǝn; nemixⱪa mǝn Sening aldingda iltipat tapmaymǝn? ");
INSERT INTO uigpin_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ya mǝn bu pütün hǝlⱪⱪǝ ⱨamilidar bolup, ularni tuƣdummu? Sǝn tehi manga: «Sǝn ularni Mǝn ⱪǝsǝm iqip ularning ata-bowiliriƣa miras ⱪilƣan xu yǝrgǝ yǝtküzgüqǝ, huddi baⱪⱪan atisi ǝmqǝktiki bowaⱪni baƣriƣa alƣandǝk baƣringƣa elip kɵtürüp mang» dǝwatisǝn? ");
INSERT INTO uigpin_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Mǝn bu hǝlⱪⱪǝ nǝdin gɵx tepip berǝlǝymǝn? Qünki ular manga yiƣlap: «Sǝn bizgǝ yegüdǝk gɵx tepip bǝr!» deyixmǝktǝ. ");
INSERT INTO uigpin_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mǝn bu hǝlⱪni kɵtürüxni yalƣuz üstümgǝ elip ketǝlmǝydikǝnmǝn, bu ix manga bǝk eƣir keliwatidu. ");
INSERT INTO uigpin_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Əgǝr Sǝn manga muxundaⱪ muamilǝ ⱪilmaⱪqi bolsang, mǝn ɵtünüp ⱪalay, bu harab ⱨalitimni manga kɵrsǝtmǝy, iltipat ⱪilip meni ɵltürüwǝt! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — Israil aⱪsaⱪalliri iqidin, sǝn yenimƣa tonuydiƣan hǝlⱪ aⱪsaⱪalliri wǝ bǝglǝrdin yǝtmixni tallap yiƣⱪin, ularni jamaǝt qedirining aldiƣa ǝkǝl. Ular sening bilǝn billǝ xu yǝrdǝ tursun. ");
INSERT INTO uigpin_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mǝn xu yǝrgǝ qüxüp sening bilǝn sɵzliximǝn; wǝ sening üstüngdǝ turuwatⱪan Roⱨni elip ularning üstigimu bɵlüp ⱪoyimǝn. Xuning bilǝn ular sǝn bilǝn billǝ hǝlⱪni kɵtürüx mǝs’uliyitini üstigǝ alidu, andin sǝn uni ɵzüng yalƣuz kɵtürmǝydiƣan bolisǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Sǝn hǝlⱪⱪǝ mundaⱪ degin: «Ətǝ gɵx yiyixkǝ tǝyyarlinip ɵzǝnglǝrni Hudaƣa atap paklanglar; qünki silǝr Pǝrwǝrdigarning ⱪuliⱪini aƣritip yiƣlap: «Əmdi kim bizgǝ gɵx beridu? Aⱨ, Misirdiki ⱨalimiz bǝk yahxi idi!» degǝnidinglar ǝmǝsmu? Pǝrwǝrdigar dǝrwǝⱪǝ silǝrgǝ gɵx beridu, silǝr uningdin yǝysilǝr. ");
INSERT INTO uigpin_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Silǝr bir kün, ikki kün ǝmǝs, bǝx kün, on kün ǝmǝs, yigirmǝ künmu ǝmǝs, ");
INSERT INTO uigpin_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","bǝlki pütün bir ay yǝysilǝr, taki burninglardin etilip qiⱪip ⱨɵ bolƣuqǝ yǝysilǝr; qünki silǝr aranglarda turuwatⱪan Pǝrwǝrdigarni mǝnsitmǝy, uning aldida yiƣlap turup: «Biz nemǝ üqün Misirdin qiⱪtuⱪ?» — dedinglar». ");
INSERT INTO uigpin_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa: — Mǝn ularning arisida turuwatⱪan bu hǝlⱪtin yolƣa qiⱪalaydiƣan ǝrkǝklǝr altǝ yüz ming tursa, Sǝn tehi: «Mǝn ularni gɵx yǝydiƣan, ⱨǝtta pütün bir ay gɵx yǝydiƣan ⱪilimǝn» dǝysǝn; ");
INSERT INTO uigpin_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ǝmisǝ ⱪoy, kala padilirining ⱨǝmmisi soyulsa ularƣa yetǝmdu? Yaki dengizdiki ⱨǝmmǝ beliⱪ ularƣa tutup berilsǝ, ularning yiyixigǝ yitǝrmu? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Xuning bilǝn Pǝrwǝrdigar Musaƣa: — Pǝrwǝrdigarning ⱪoli ⱪisⱪa bolup ⱪaptimu? Əmdi kɵrüp baⱪⱪinǝ, Mening sanga degǝn sɵzüm ǝmǝlgǝ axurulamdu-yoⱪ? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Xuning bilǝn Musa qiⱪip Pǝrwǝrdigarning sɵzini hǝlⱪⱪǝ yǝtküzdi wǝ hǝlⱪ iqidiki aⱪsaⱪallardin yǝtmix adǝmni tallap yiƣip ularni jamaǝt qedirining ǝtrapida turƣuzdi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Andin Pǝrwǝrdigar bulut iqidin qüxüp, Musa bilǝn sɵzlixip, uningdiki Roⱨtin elip yǝtmix aⱪsaⱪalƣa ⱪoydi; Roⱨ ularning üstigǝ ⱪonuxi bilǝn ular bexarǝt berixkǝ kirixti. Lekin xu waⱪittin keyin ular undaⱪ ⱪilmidi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Lekin u qaƣda ulardin ikki adǝm bargaⱨta ⱪaldi; birsining ismi Əldad, ikkinqisi Medad idi (ular ǝslidǝ aⱪsaⱪallarning arisida tizimlanƣanidi, lekin ibadǝt qediriƣa qiⱪmay ⱪalƣanidi). Roⱨ ularning üstidimu ⱪondi wǝ ular bargaⱨ iqidǝ bexarǝt berixkǝ baxlidi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Yax bir yigit yügürüp kelip Musaƣa: — Əldad bilǝn Medad bargaⱨta bexarǝt beriwatidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Musaning hizmǝtkari, Musa talliƣan sǝrhil yigitliridin biri, Nunning oƣli Yǝxua ⱪopup: — I hojam Musa, ularni tosuƣayla, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Lekin Musa uningƣa: — Sǝn mening sǝwǝbimdin ⱨǝsǝt ⱪiliwatamsǝn? Pǝrwǝrdigarning pütün hǝlⱪi pǝyƣǝmbǝr bolup kǝtsǝ idi, Pǝrwǝrdigar Ɵzining Roⱨini ularning üstigǝ ⱪoysa idi! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Xuning bilǝn Musa bilǝn Israil aⱪsaⱪallirining ⱨǝmmisi bargaⱨⱪa ⱪaytip ketixti. ");
INSERT INTO uigpin_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Əmdi Pǝrwǝrdigar aldidin bir xamal qiⱪip, u dengiz tǝrǝptin bɵdünilǝrni uqurtup kelip, bargaⱨning ǝtrapiƣa yeyiwǝtti; bɵdünilǝr bargaⱨning u tǝripidimu bir künlük yol, bu tǝripidimu bir künlük yol kǝlgüdǝk yǝr yüzini ikki gǝz egizliktǝ kǝlgüdǝk ⱪaplidi.    ");
INSERT INTO uigpin_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Hǝlⱪ ornidin turup pütkül xu küni, xu keqisi wǝ ǝtisi pütün kün bɵdünǝ tutup yiƣdi, ǝng az degǝnlirimu alaⱨazǝl ikki homir yiƣdi; ular bularni bargaⱨning tɵt ǝtrapiƣa ɵzliri üqün yeyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ular gɵxni qaynap ezip bolmay, gɵx tehi qixliri arisida turƣanda, Pǝrwǝrdigarning ƣǝzipi ularƣa ⱪozƣilip, hǝlⱪni intayin eƣir bir waba bilǝn urdi.    ");
INSERT INTO uigpin_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Xunga kixilǝr xu yǝrni «Ⱪibrot-Ⱨattawaⱨ» dǝp atidi; qünki ular xu yǝrdǝ nǝpsi taⱪildiƣan kixilǝrni yǝrlikkǝ ⱪoyƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Keyin hǝlⱪ Ⱪibrot-Ⱨattawaⱨtin yolƣa qiⱪip Ⱨazirotⱪa kelip, Ⱨazirotta tohtidi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mǝriyǝm bilǝn Ⱨarun Musaning ⱨǝbǝxlik ⱪizni hotunluⱪⱪa alƣini üqün uningƣa ⱪarxi sɵz ⱪildi (qünki u ⱨǝbǝxlik bir ⱪizni alƣanidi). ");
INSERT INTO uigpin_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ular: — Pǝrwǝrdigar pǝⱪǝt Musa bilǝnla sɵzlixip, biz bilǝn sɵzlǝxmǝptimu? — deyixti. Bu gǝpni Pǝrwǝrdigar anglidi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa degǝn bu adǝm intayin kǝmtǝr-mɵmin adǝm bolup, bu tǝrǝptǝ yǝr yüzidikilǝr arisida uning aldiƣa ɵtidiƣini yoⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Pǝrwǝrdigar Musa, Ⱨarun wǝ Mǝriyǝmgǝ tuyuⱪsiz: — Silǝr üqünglar jamaǝt qediriƣa kelinglar, — dedi. Üqilisi qiⱪip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Andin Pǝrwǝrdigar ǝrxtin bulut tüwrüki iqidǝ qüxüp, jamaǝt qedirining aldida tohtap, Ⱨarun bilǝn Mǝryǝmni ⱪiqⱪiriwidi, ular aldiƣa kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","U ularƣa: — Əmdi silǝr gepimni anglanglar, ǝgǝr silǝrning aranglarda pǝyƣǝmbǝr bolsa, Mǝn Pǝrwǝrdigar alamǝt kɵrünüxtǝ uningƣa Ɵzümni ayan ⱪilimǝn, qüxidǝ uning bilǝn sɵzliximǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Lekin ⱪulum Musaƣa nisbǝtǝn undaⱪ ǝmǝs; u barliⱪ ailǝm iqidǝ tolimu sadiⱪtur; ");
INSERT INTO uigpin_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mǝn uning bilǝn tepixmaⱪ eytip olturmay, yüzmu yüz turup biwasitǝ sɵzliximǝn; u Mǝn Pǝrwǝrdigarning ⱪiyapitini kɵrǝlǝydu. Əmdi silǝr nemixⱪa ⱪulum Musa toƣruluⱪ yaman gǝp ⱪilixtin ⱪorⱪmidinglar? — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Pǝrwǝrdigarning otluⱪ ƣǝzipi ularƣa ⱪozƣaldi wǝ u ketip ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Xuning bilǝn bulut jamaǝt qediri üstidin kǝtti, wǝ mana, Mǝryǝm huddi ap’aⱪ ⱪardǝk pesǝ-mahaw bolup kǝtti; Ⱨarun burulup Mǝryǝmgǝ ⱪariwidi, mana, u pesǝ-mahaw bolup ⱪalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Ⱨarun Musaƣa: — Way hojam! Nadanliⱪ ⱪilip gunaⱨ ɵtküzüp ⱪoyƣanliⱪimiz sǝwǝbidin bu gunaⱨni bizning üstimizgǝ artmiƣaysǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","U huddi anisining ⱪorsiⱪidin qiⱪⱪandila bǝdini yerim qirik, ɵlük tuƣulƣan balidǝk bolup ⱪalmiƣay! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Xuning bilǝn Musa Pǝrwǝrdigarƣa: — I Tǝngri, uning kesilini saⱪaytiwǝtkǝn bolsang, — dǝp nida ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Pǝrwǝrdigar Musaƣa: — Əgǝr atisi uning yüzigǝ tükürgǝn bolsa, u yǝttǝ kün hijilqiliⱪ iqidǝ turƣan bolatti ǝmǝsmu? Əmdi u bargaⱨning sirtiƣa yǝttǝ kün ⱪamap ⱪoyulsun, andin u ⱪaytip kǝlsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Xuning bilǝn Mǝryǝm bargaⱨ sirtiƣa yǝttǝ kün ⱪamap ⱪoyuldi, taki Mǝryǝm ⱪaytip kǝlgüqǝ hǝlⱪ yolƣa qiⱪmay turup turdi. ");
INSERT INTO uigpin_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Andin keyin hǝlⱪ Ⱨazirottin yolƣa qiⱪip, Paran qɵlidǝ bargaⱨ ⱪurdi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Mǝn Israillarƣa miras ⱪilip bǝrgǝn Ⱪanaan zeminini qarlap kelixkǝ adǝmlǝrni ǝwǝtkin; ⱨǝrbir ata jǝmǝtkǝ tǝwǝ ⱪǝbilidin birdin adǝm qiⱪirilsun, ular ɵz ⱪǝbilisidiki ǝmir bolsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa Pǝrwǝrdigarning ǝmri boyiqǝ, ularni Paran qɵlidin yolƣa saldi; ularning ⱨǝmmisi Israillarning baxliri idi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Tɵwǝndikilǝr ularning isimliri: — Rubǝn ⱪǝbilisidin Zakkurning oƣli Xammuya, ");
INSERT INTO uigpin_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Ximeon ⱪǝbilisidin Horining oƣli Xafat, ");
INSERT INTO uigpin_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yǝⱨuda ⱪǝbilisidin Yǝfunnǝⱨning oƣli Kalǝb, ");
INSERT INTO uigpin_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Issakar ⱪǝbilisidin Yüsüpning oƣli Igal, ");
INSERT INTO uigpin_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Əfraim ⱪǝbilisidin Nunning oƣli Ⱨoxiya, ");
INSERT INTO uigpin_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Binyamin ⱪǝbilisidin Rafuning oƣli Palti, ");
INSERT INTO uigpin_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zǝbulun ⱪǝbilisidin Sodining oƣli Gaddiyǝl, ");
INSERT INTO uigpin_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yüsüp ⱪǝbilisidin, yǝni Manassǝⱨ ⱪǝbilisidin Susining oƣli Gaddi, ");
INSERT INTO uigpin_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan ⱪǝbilisidin Gimallining oƣli Ammiyǝl, ");
INSERT INTO uigpin_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Axir ⱪǝbilisidin Mikailning oƣli Sǝtur, ");
INSERT INTO uigpin_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naftali ⱪǝbilisidin Wofsining oƣli Naⱨbi, ");
INSERT INTO uigpin_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad ⱪǝbilisidin Makining oƣli Geuǝl. ");
INSERT INTO uigpin_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Mana bular Musa qarlap kelinglar dǝp Ⱪanaan zeminiƣa ǝwǝtkǝn adǝmlǝrning ismi. Musa Nunning oƣli Ⱨoxiyani Yǝⱨoxuya dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa ularni qarlap kelixkǝ Ⱪanaanƣa sǝpǝrwǝr ⱪilip: — Silǝr muxu yǝrdin Nǝgǝw qɵli tǝrǝpkǝ ⱪarap menginglar, andin taƣliⱪ rayonƣa qiⱪinglar. ");
INSERT INTO uigpin_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","U yǝrning ⱪandaⱪ ikǝnlikini, u yǝrdikilǝrning küqlük-ajizliⱪini, az yaki kɵplükini kɵrüp beⱪinglar; ");
INSERT INTO uigpin_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ular turuwatⱪan yǝrning ⱪandaⱪ ikǝnlikini, yahxi-yamanliⱪini kɵrünglar; ular turuwatⱪan xǝⱨǝrlǝrning ⱪandaⱪ ikǝnlikini, bargaⱨliⱪ xǝⱨǝr yaki sepil-ⱪǝlǝlik xǝⱨǝr ikǝnlikini; ");
INSERT INTO uigpin_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","u yǝrning munbǝt yaki munbǝtsiz ikǝnlikini, dǝl-dǝrǝhlirining bar-yoⱪluⱪini kɵrüp kelinglar. Yürǝklikrǝk bolup, mewǝ-qiwiliridin alƣaq kelinglar, — dedi. Bu qaƣ dǝl üzüm pixip ⱪalƣan waⱪit idi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ular xu tǝrǝplǝrgǝ qiⱪip, zeminni Zin qɵlidin tartip taki Ⱨamat eƣizining yenidiki Rǝⱨobⱪiqǝ berip qarlaxti. ");
INSERT INTO uigpin_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ular jǝnub tǝrǝptǝ Ⱨebronƣa bardi, u yǝrlǝrdǝ Anaⱪiylarning ǝwladliridin Aⱨiman, Xixay, Talmay degǝnlǝr olturuxluⱪ idi. Əslidǝ Ⱨebron xǝⱨiri Misirdiki Zoan xǝⱨiridin yǝttǝ yil ilgiri yasalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ular «Əxkol jilƣisi»ƣa kǝldi, u yǝrdǝ bir sap üzümi bar bir üzüm xehini kesip, bir baldaⱪⱪa esip ikki adǝmgǝ kɵtürgüzüp mangdi; ular azraⱪ anar bilǝn ǝnjürmu elip ⱪaytip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israillar xu yǝrdǝ kesiwalƣan ǝxu üzüm sǝwǝbidin u yǝr «Əxkol jilƣisi» («üzüm sapiⱪi jilƣisi») dǝp ataldi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ular ⱪiriⱪ kündin keyin u yǝrlǝrni qarlap tügitip, ⱪaytip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ular kelip, Paran qɵllükidiki Ⱪadǝxtǝ Musa, Ⱨarun wǝ pütün Israil jamaiti bilǝn kɵrüxti. Ular ikkiylǝngǝ ⱨǝm pütkül Israil jamaitigǝ mǝlumat bǝrdi ⱨǝm zeminning mewilirini ularƣa kɵrsǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ular Musaƣa mǝlumat berip: — Biz ɵzliri beringlar degǝn yǝrlǝrgǝ barduⱪ, rasttinla süt bilǝn ⱨǝsǝl eⱪip turidiƣan yǝr ikǝn, mana bular xu yǝrning mewiliri. ");
INSERT INTO uigpin_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Biraⱪ u yǝrdikilǝr bǝk küqtünggür ikǝn, xǝⱨǝrlǝr sepilliⱪ bolup ⱨǝm puhta-ⱨǝywǝtlik ikǝn. Uning üstigǝ, biz u yǝrdǝ Anaⱪiylarning ǝwladlirinimu kɵrduⱪ. ");
INSERT INTO uigpin_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalǝklǝr jǝnub tǝrǝptǝ turidikǝn; Ⱨittiylar, Yǝbusiylar, Amoriylar taƣlarda turidikǝn; Ⱪanaaniylar dengiz boylirida wǝ Iordan dǝryasi boylirida turidikǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalǝb Musaning aldida kɵpqilikni tinqitip: — Biz dǝrⱨal atlinip berip u yǝrni igilǝyli! Qünki biz qoⱪum ƣalip kelimiz — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Lekin uning bilǝn billǝ qiⱪⱪan baxⱪilar bolsa: — Ular bizdin küqlük ikǝn, xunga ularƣa ⱨujum ⱪilsaⱪ bolmaydu, — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Andin qarliƣuqilar ɵzliri qarlap kǝlgǝn zeminning ǝⱨwalidin Israillarƣa yaman mǝlumat berip: — Biz kirip qarlap ɵtkǝn zemin bolsa ɵz aⱨalisini yǝydiƣan zemin ikǝn; biz u yǝrdǝ kɵrgǝnlǝrning ⱨǝmmisi yoƣan adǝmlǝr ikǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Biz u yǝrlǝrdǝ «Nǝfiliylǝr» degǝn gigant adǝmlǝrni kɵrduⱪ (dǝrwǝⱪǝ Anaⱪiylarning ǝwladliri Nǝfiliylǝrdin qiⱪⱪandur); biz ɵzimizgǝ ⱪarisaⱪ qekǝtkidǝk turidikǝnmiz, biz ularƣimu xundaⱪ kɵrinidikǝnmiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Xuning bilǝn barliⱪ jamaǝt dad-pǝryad kɵtürüp yiƣlidi; ular keqiqǝ yiƣa-zar ⱪilixip qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israillar Musa bilǝn Ⱨarunƣa tapa-tǝnǝ ⱪilip: — Biz baldurla Misirda ɵlüp kǝtsǝk boptikǝn! Muxu qɵl-jǝziridǝ ɵlüp kǝtsǝk boptikǝn! ");
INSERT INTO uigpin_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Pǝrwǝrdigar nemixⱪa bizni ⱪiliq astida ɵlsun, hotun bala-qaⱪilirimiz bulinip, düxmǝnning oljisi bolsun dǝp bizni bu yǝrgǝ baxlap kǝlgǝndu? Uningdin kɵrǝ, Misirƣa ⱪaytip kǝtkinimiz yahxi ǝmǝsmu? — dǝp ƣotuldaxti. ");
INSERT INTO uigpin_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Xuning bilǝn ular bir-birigǝ: — Baxⱪidin bir baxliⱪ tiklǝp Misirƣa ⱪaytip ketǝyli, — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa bilǝn Ⱨarun pütün Israil jamaiti aldida yiⱪilip düm yatti. ");
INSERT INTO uigpin_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Xu yǝrni qarlap kǝlgǝnlǝr iqidiki Nunning oƣli Yǝxua bilǝn Yǝfunnǝⱨning oƣli Kalǝb kiyimlirini yirtip, ");
INSERT INTO uigpin_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","pütün Israil jamaǝtqilikigǝ: — Biz qarlap kelixkǝ ɵtüp barƣan zemin intayin bǝk yahxi zemin ikǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Əgǝr Pǝrwǝrdigar bizdin sɵyünsǝ, bizni xu zeminƣa, yǝni ⱨǝsǝl bilǝn süt eⱪip turidiƣan xu zeminƣa baxlap berip, uni bizgǝ beridu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Silǝr pǝⱪǝt Pǝrwǝrdigarƣa asiyliⱪ ⱪilmanglar! U zeminidikilǝrdin ⱪorⱪmanglar, qünki ular bizgǝ nisbǝtǝn bir ƣizadur; ularning panaⱨdarliri ulardin kǝtti, Pǝrwǝrdigar bolsa biz bilǝn billǝ; ulardin ⱪorⱪmanglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ⱨalbuki, pütkül jamaǝt tǝrǝp-tǝrǝptin: — U ikkisini qalma-kesǝk ⱪilip ɵltürüwetǝyli, deyixti. Lekin Pǝrwǝrdigarning julasi jamaǝt qedirida Israillarƣa ayan boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Pǝrwǝrdigar Musaƣa: — Bu hǝlⱪ Meni ⱪaqanƣiqǝ mǝnsitmǝydu? Gǝrqǝ ularning otturisida xunqǝ mɵjizilik alamǝtlǝrni yaratⱪan bolsammu, lekin ular Manga ⱪaqanƣiqǝ ixinixmǝydikǝn? ");
INSERT INTO uigpin_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mǝn ularni waba bilǝn urup yoⱪitimǝn, xuning bilǝn seni ulardin tehimu qong wǝ ⱪudrǝtlik bir ǝl ⱪilimǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa bolsa Pǝrwǝrdigarƣa mundaⱪ dedi: — «Bundaⱪ bolidiƣan bolsa bu ixni misirliⱪlar anglap ⱪalidu, qünki Sǝn uluƣ ⱪudriting bilǝn bu hǝlⱪni ularning arisidin elip qiⱪⱪaniding; ");
INSERT INTO uigpin_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","wǝ Misirliⱪlar bu ixni xu zemindiki hǝlⱪlǝrgimu eytidu. U zemindiki aⱨalimu Sǝn Pǝrwǝrdigarning bu hǝlⱪning arisida ikǝnlikingni, Sǝn Pǝrwǝrdigarning ularning aldida yüzmuyüz kɵrüngǝnlikingni, Sening buluting daim ularƣa sayǝ qüxürüp kǝlgǝnlikini, xundaⱪla Sening kündüzi bulut tüwrükidǝ, keqisi ot tüwrükidǝ ularning aldida mangƣanliⱪingni angliƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Əmdi Sǝn bu hǝlⱪni huddi bir adǝmni ɵltürgǝndǝk ɵltürüwǝtsǝng, Sening nam-xɵⱨritingni angliƣan ǝllǝrning ⱨǝmmisi: ");
INSERT INTO uigpin_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","«Pǝrwǝrdigar bu hǝlⱪni Ɵzi ularƣa berixkǝ ⱪǝsǝm ⱪilƣan zeminƣa baxlap baralmaydiƣanliⱪi üqün, xunga ularni ǝxu qɵl-jǝziridǝ ɵltürüwetiptu» dǝp ⱪalidu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Əmdi ɵtünimǝnki, Rǝbbim ⱪudritingni jari ⱪildurƣaysǝn, Ɵzüngning: ");
INSERT INTO uigpin_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","«Pǝrwǝrdigar asanliⱪqǝ aqqiⱪlanmaydu, Uning meⱨir-muⱨǝbbiti texip turidu; U gunaⱨ wǝ itaǝtsizlikni kǝqüridu, lekin gunaⱨkarlarni ⱨǝrgiz gunaⱨsiz dǝp ⱪarimaydu, atilarning ⱪǝbiⱨlikini atisidin balisiƣiqǝ, ⱨǝtta nǝwrǝ-qǝwrilirigiqǝ ularning üstigǝ yüklǝydu» deginingdǝk ⱪilƣaysǝn.    ");
INSERT INTO uigpin_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Meⱨir-xǝpⱪitingning kǝngriliki boyiqǝ, Misirdiki qaƣdin taki ⱨazirƣiqǝ daim kǝqürüp kǝlginingdǝk, bu hǝlⱪning ⱪǝbiⱨlikini kǝqürgǝysǝn!». ");
INSERT INTO uigpin_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Pǝrwǝrdigar: — «Boptu, sǝn degǝndǝk ularni kǝqürdüm. ");
INSERT INTO uigpin_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Lekin Ɵz ⱨayatim bilǝn ⱪǝsǝm ⱪilimǝnki, pütkül yǝr yüzi Mǝn Pǝrwǝrdigarning xan-xǝripi bilǝn tolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Ⱨalbuki, Mening julayimni, Misirda wǝ qɵl-jǝziridǝ kɵrsǝtkǝn mɵjizilik alamǝtlirimni kɵrüp turupmu Meni muxundaⱪ on ⱪetimlap sinap yǝnǝ awazimƣa ⱪulaⱪ salmiƣanlar, ");
INSERT INTO uigpin_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Mǝn ⱪǝsǝm iqip ularning ata-bowiliriƣa miras ⱪilip berimǝn degǝn u zeminni ⱨǝrgiz kɵrǝlmǝydu; Meni mǝnsitmigǝnlǝrdin birimu u yurtni kɵrǝlmǝydu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Lekin ɵzidǝ baxⱪiqǝ bir roⱨning bolƣini, pütün ⱪǝlbi bilǝn Manga ǝgǝxkini üqün ⱪulum Kalǝbni u kirgǝn yǝrgǝ baxlap kirimǝn; uning ǝwladlirimu u yǝrgǝ mirashor bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(xu qaƣda Amalǝklǝr bilǝn Ⱪanaaniylar taƣliⱪ jilƣilarda turuwatatti) — Ətǝ silǝr yolunglardin burulup, Ⱪizil Dengizƣa baridiƣan yol bilǝn mengip qɵlgǝ sǝpǝr ⱪilinglar» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa sɵz ⱪilip mundaⱪ dedi: ");
INSERT INTO uigpin_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","— Mǝn Mening yaman gepimni ⱪilip ƣotuldixidiƣan bu rǝzil jamaǝtkǝ ⱪaqanƣiqǝ qidixim kerǝk? Israillarning Mening yaman gepimni ⱪilƣanliri, xu tohtawsiz ƣotuldaxlirining ⱨǝmmisini anglidim. ");
INSERT INTO uigpin_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sǝn ularƣa: — Pǝrwǝrdigar mundaⱪ dǝydu: «Mǝn ⱨayatim bilǝn ⱪǝsǝm ⱪilimǝnki, hǝp, Mǝn silǝrgǝ ⱪuliⱪimƣa kirgǝn sɵzliringlar boyiqǝ muamilǝ ⱪilmaydiƣan bolsam! ");
INSERT INTO uigpin_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Silǝrning ɵlükünglar muxu qɵldǝ yatidu; silǝrning iqinglarda sanaⱪtin ɵtküzülgǝnlǝr, yǝni yexi yigirmidin axⱪan, Mening yaman gepimni ⱪilip ƣotuldiƣanlarning ⱨǝmmisi pütün sani boyiqǝ ");
INSERT INTO uigpin_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Silǝrgǝ ⱪol kɵtürüp ⱪǝsǝm ⱪilip, turalƣunglar ⱪilip berimǝn degǝn zeminƣa ⱨeq kirǝlmǝydu; pǝⱪǝt Yǝfunnǝⱨning oƣli Kalǝb bilǝn Nunning oƣli Yǝxuala kiridu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Silǝrning kiqik baliliringlar, yǝni «Bulinip, düxmǝnning oljisi bolup ⱪalidu» deyilgǝnlǝrni Mǝn baxlap kirimǝn, ular silǝr kǝmsitkǝn u zemindin bǝⱨrimǝn bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Biraⱪ silǝr bolsanglar, silǝr yiⱪilip, ɵlükünglar bu qɵldǝ ⱪalidu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Silǝrning baliliringlar buzuⱪluⱪ-wapasizliⱪinglarning ǝlimini tartip, ɵlükünglar qɵldǝ yoⱪalƣuqǝ, bu qɵldǝ ⱪiriⱪ yil sǝrgǝrdan bolup yüridu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Silǝrning xu zeminni qarliƣan künliringlarning sani boyiqǝ, ⱪiriⱪ künning ⱨǝrbir künini bir yil ⱨesablap, ⱪǝbiⱨlikliringlarni ⱪiriⱪ yil ɵz üstünglarƣa elip yürisilǝr; xu qaƣda Mening ɵzünglardin yatlaxⱪinimning nemǝ ikǝnlikini bilip yetisilǝr» — degin. ");
INSERT INTO uigpin_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mǝn Pǝrwǝrdigar xundaⱪ degǝnikǝnmǝn, yiƣilip Manga ⱪarxi qiⱪⱪan bu rǝzil hǝlⱪ jamaitigǝ Mǝn qoⱪum xundaⱪ ⱪilimǝn; ular muxu qɵl-jǝziridǝ yǝwetilidu, xu yǝrdǝ ɵlidu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Musa u zeminni qarlap kelixkǝ ǝwǝtkǝnlǝr ⱪaytip kǝlgǝndǝ, u zemin toƣruluⱪ yaman hǝwǝr elip kelix bilǝn pütün jamaǝtni ƣotulditip, Musaning yaman gepini ⱪilƣuzƣanlar, ");
INSERT INTO uigpin_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","yǝni u zemin toƣruluⱪ yaman hǝwǝr ǝkǝlgǝn bu kixilǝrning ⱨǝmmisi waba kesili tegip Pǝrwǝrdigarning aldida ɵldi. ");
INSERT INTO uigpin_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Zeminni qarlap kelixkǝ barƣan adǝmlǝr iqidin pǝⱪǝt Nunning oƣli Yǝxua bilǝn Yǝfunnǝⱨning oƣli Kalǝbla ⱨayat ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa bu gǝplǝrni pütkül Israil jamaitigǝ eytiwidi, ⱨǝmmisi bǝk ⱨǝsrǝt qǝkti. ");
INSERT INTO uigpin_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ular ǝtigǝn tang atⱪanda turup taƣⱪa qiⱪip: — Mana biz kǝlduⱪ! Pǝrwǝrdigar eytⱪan yurtⱪa qiⱪip ⱨujum ⱪilayli; qünki biz gunaⱨ ⱪilduⱪ, — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","— Silǝr yǝnǝ nemixⱪa Pǝrwǝrdigarning ǝmrigǝ hilapliⱪ ⱪilisilǝr? — dedi Musa, — Bu ix ƣǝlibilik bolmaydu! ");
INSERT INTO uigpin_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Pǝrwǝrdigar aranglarda bolmiƣaqⱪa, düxmǝnning ⱪiliqi astida ɵlüp, mǝƣlup bolmasliⱪinglar üqün ⱨujumƣa qiⱪmanglar. ");
INSERT INTO uigpin_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Qünki Amalǝklǝr bilǝn Ⱪanaaniylar u yurtta, silǝrning aldinglarda turidu; silǝr ⱪiliq astida ɵlüp ketisilǝr; qünki silǝr Pǝrwǝrdigardin tenip kǝttinglar, Pǝrwǝrdigar silǝr bilǝn billǝ bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Lekin, gǝrqǝ Pǝrwǝrdigarning ǝⱨdǝ sanduⱪi wǝ Musa bargaⱨtin ⱪozƣalmiƣan bolsimu, ular yǝnila ɵz mǝyliqǝ taƣⱪa qiⱪip ⱨujumƣa ɵtti. ");
INSERT INTO uigpin_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Xuning bilǝn Amalǝklǝr bilǝn xu taƣda turuxluⱪ Ⱪanaaniylar qüxüp ularni taki Hormaⱨƣiqǝ ⱪoƣlap, bitqit ⱪilip ⱪirƣin ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Sǝn Israillarƣa mundaⱪ degin: — Silǝr makanlixixinglar üqün silǝrgǝ tǝⱪdim ⱪilip beridiƣan zeminƣa kirgǝn qeƣinglarda, ");
INSERT INTO uigpin_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ǝgǝr Pǝrwǝrdigarƣa atap otta sunulidiƣan, uningƣa huxbuy bolsun dǝp birǝr ⱨǝdiyǝ-ⱪurbanliⱪ ⱪilmaⱪqi bolsanglar, ⱪurbanliⱪ kala yaki ⱪoy-ɵqkǝ padisidin bolsun. U kɵydürmǝ ⱪurbanliⱪ bolsun, ⱪǝsǝmni ada ⱪilix ⱪurbanliⱪi bolsun, ihtiyariy ⱪurbanliⱪ yaki silǝrgǝ bekitilgǝn ⱨeytlardiki zɵrür ⱪurbanliⱪ bolsun, ");
INSERT INTO uigpin_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","ⱪurbanliⱪ sunƣuqi kixi Pǝrwǝrdigarƣa atiƣiniƣa bir axliⱪ ⱨǝdiyǝsini ⱪoxup kǝltürsun. Kɵydürmǝ ⱪurbanliⱪ yaki baxⱪa ⱪurbanliⱪ ⱪoza bolsa, undaⱪta axliⱪ ⱨǝdiyǝsi zǝytun meyidin bir ⱨinning tɵttin biri ilǝxtürülgǝn esil undin ǝfaⱨning ondin biri bolsun; uningƣa yǝnǝ xarab ⱨǝdiyǝsi süpitidǝ tɵttin bir ⱨin xarabni ⱪoxup sunsun.    ");
INSERT INTO uigpin_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ⱪurbanliⱪing ⱪoqⱪar bolsa, sǝn uningƣa axliⱪ ⱨǝdiyǝsi süpitidǝ üqtin bir ⱨin zǝytun meyi ilǝxtürülgǝn esil undin ǝfaⱨning ondin ikkisi bolsun ");
INSERT INTO uigpin_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","wǝ xarab ⱨǝdiyǝsi süpitidǝ üqtin bir ⱨin xarabni ⱪoxup sunsun; bular Pǝrwǝrdigarƣa huxbuy qiⱪarsun dǝp sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Əgǝr sǝn Pǝrwǝrdigarƣa kɵydürmǝ ⱪurbanliⱪ, yaki ⱪǝsǝm ada ⱪilix ⱪurbanliⱪi yaki inaⱪliⱪ ⱪurbanliⱪi süpitidǝ torpaⱪ atiƣan bolsang, ");
INSERT INTO uigpin_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","undaⱪta torpaⱪⱪa axliⱪ ⱨǝdiyǝsi süpitidǝ yerim ⱨin zǝytun meyi ilǝxtürülgǝn esil undin ǝfaⱨning ondin üqini, ");
INSERT INTO uigpin_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","xarab ⱨǝdiyǝsi süpitidǝ yerim ⱨin xarabni ⱪoxup sunƣin; bular Pǝrwǝrdigarƣa atilip otta sunulup, huxbuy qiⱪarsun dǝp kǝltürülsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ⱨǝrbir sunulƣan torpaⱪ, ⱪoqⱪar, ⱪoza yaki oƣlaⱪⱪa nisbǝtǝn muxundaⱪ ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Silǝr sunidiƣininglarning sani boyiqǝ, ⱨǝrhil ⱪurbanliⱪning saniƣa ⱪarap xundaⱪ ⱪilisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Xu zeminda tuƣulƣanlarning ⱨǝmmisi Pǝrwǝrdigarƣa huxbuy qiⱪarsun dǝp, otta sunulidiƣan ⱪurbanliⱪ ⱪilmaⱪqi bolsa ǝnǝ xundaⱪ ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Xuningdǝk silǝr bilǝn billǝ turuwatⱪan musapir yaki ǝwladmu-ǝwlad silǝr bilǝn billǝ turuwatⱪanlar bolsa, huxbuy qiⱪarsun dǝp otta sunulidiƣan ⱪurbanliⱪ ⱪilmaⱪqi bolsa, silǝr ⱪandaⱪ ⱪilƣan bolsanglar, ularmu xundaⱪ ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Pütkül jamaǝtkǝ, mǝyli silǝr bolunglar yaki silǝr bilǝn billǝ turuwatⱪan musapir bolsun, ⱨǝmminglar üqün ohxax bir bǝlgilimǝ bolidu; silǝr üqün dǝwrmu-dǝwr ǝbǝdiy bir bǝlgilimǝ bolidu; Pǝrwǝrdigar aldida silǝr ⱪandaⱪ bolsanglar, musapirlarmu xundaⱪtur. ");
INSERT INTO uigpin_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Silǝrgimu, aranglarda turuwatⱪan musapirlarƣimu ohxax bir ⱪanun-bǝlgilimǝ, ohxax bir ⱨɵküm bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Sǝn Israillarƣa sɵz ⱪilip ularƣa mundaⱪ degin: — «Silǝr Mǝn silǝrni ǝkiridiƣan zeminƣa yetip barƣanda, ");
INSERT INTO uigpin_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","xu yǝrdin qiⱪⱪan axliⱪni yǝydiƣan qeƣinglarda, Pǝrwǝrdigarƣa bir «kɵtürmǝ ⱨǝdiyǝ» tǝⱪdim ⱪilinglar. ");
INSERT INTO uigpin_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Silǝr ⱨǝrbir yengi hemirdin pixⱪan nanlardin birini «kɵtürmǝ ⱨǝdiyǝ» ⱪilip tǝⱪdim ⱪilinglar; silǝr uni tǝⱪdim ⱪilƣanda huddi hamanning «kɵtürmǝ ⱨǝdiyǝ»sigǝ ohxax bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dǝwrdin-dǝwrgǝ silǝr dǝslǝpki ⱨosuldin qiⱪⱪan hemirdin bir nanni «kɵtürmǝ ⱨǝdiyǝ» süpitidǝ Pǝrwǝrdigarƣa sununglar. ");
INSERT INTO uigpin_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Əgǝr silǝr ɵzünglar bilmǝy ezip gunaⱨ ⱪilip, Pǝrwǝrdigarning Musaƣa buyruƣan bu barliⱪ ǝmirlirigǝ ǝmǝl ⱪilmiƣan bolsanglar, ");
INSERT INTO uigpin_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","yǝni Pǝrwǝrdigar buyruƣan kündin etibarǝn barliⱪ ǝwladliringlarƣiqǝ Pǝrwǝrdigarning Musaning wastisi bilǝn silǝrgǝ buyruƣan barliⱪ ixliriƣa ǝmǝl ⱪilmiƣan bolsanglar, ");
INSERT INTO uigpin_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","jamaǝt xundaⱪ birǝr gunaⱨning bilmǝy ɵtküzülgǝnlikidin hǝwǝrsiz bolsa, undaⱪta pütkül jamaǝt Pǝrwǝrdigarƣa huxbuy qiⱪarsun dǝp yax bir torpaⱪni kɵydürmǝ ⱪurbanliⱪ süpitidǝ sunsun ⱨǝmdǝ ⱪaidǝ-nizam boyiqǝ uningƣa munasiwǝtlik axliⱪ ⱨǝdiyǝsi bilǝn xarab ⱨǝdiyǝsini ⱪoxup sunsun, wǝ uning üstigǝ bir tekini gunaⱨ ⱪurbanliⱪi süpitidǝ sunsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Xu yol bilǝn kaⱨin pütkül Israil jamaiti üqün kǝfarǝt kǝltürüp, bu gunaⱨ ulardin kǝqürüm ⱪilinidu; qünki bu bilmǝy ɵtküzüp ⱪoyƣan gunaⱨ wǝ ular ɵzlirining bilmǝy ɵtküzüp ⱪoyƣan gunaⱨi üqün ⱪurbanliⱪ, yǝni Pǝrwǝrdigarƣa atap otta sunulidiƣan ⱪurbanliⱪ wǝ gunaⱨ ⱪurbanliⱪini birliktǝ Pǝrwǝrdigar aldiƣa sunƣan. ");
INSERT INTO uigpin_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Bu gunaⱨ pütkül Israil jamaiti bilǝn ularning arisida turuwatⱪan musapirlarning ⱨǝmmisidin kǝqürüm ⱪilinidu, qünki bu pütkül hǝlⱪ bilmǝy turup ɵtküzüp ⱪoyƣan gunaⱨtur. ");
INSERT INTO uigpin_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Əgǝr bir kixi bilmǝstin gunaⱨ ⱪilip ⱪoyƣan bolsa, u bir yaxliⱪ bir qixi oƣlaⱪni gunaⱨ ⱪurbanliⱪi süpitidǝ sunsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Kaⱨin xu yol bilǝn bilmǝy gunaⱨ ⱪilip ⱪoyƣan adǝm üqün kǝfarǝt kǝltüridu; uning üqün kǝfarǝt kǝltürsǝ uning Pǝrwǝrdigar aldida bilmǝy ɵtküzgǝn gunaⱨi uningdin kǝqürüm ⱪilinidu. ");
INSERT INTO uigpin_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Bilmǝy birǝr sǝwǝnlik ɵtküzüp ⱪoyƣan barliⱪ kixilǝrgǝ, mǝyli xu zeminda tuƣulƣan Israillar bolsun yaki ularning arisida turuwatⱪan musapirlarƣa bolsun, — silǝrning ⱨǝmminglarƣa ohxax bir ⱪanun-bǝlgilimǝ tǝtbiⱪlinidu. ");
INSERT INTO uigpin_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Lekin yürikini ⱪaptǝk ⱪilip ix kɵrgǝn kixi, mǝyli u zeminda tuƣulƣan bolsun yaki musapir bolsun, Pǝrwǝrdigarƣa ⱨaⱪarǝt kǝltürgǝn bolidu; u ⱨaman ɵz hǝlⱪidin üzüp taxlinidu. ");
INSERT INTO uigpin_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","U Pǝrwǝrdigarning sɵzini mǝnsitmigǝnikǝn, Pǝrwǝrdigarning ǝmrigǝ hilapliⱪ ⱪilƣanikǝn; xuning üqün u qoⱪum üzüp taxlinidu; gunaⱨi ɵzining bexiƣa qüxidu. ");
INSERT INTO uigpin_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israillar qɵl-jǝziridiki waⱪitlirida, bir kixining xabat künidǝ otun tǝrgǝnliki bayⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Otun teriwatⱪanliⱪini bayⱪap ⱪalƣanlar uni Musa, Ⱨarun wǝ pütkül jamaǝtning aldiƣa elip kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Uni ⱪandaⱪ bir tǝrǝp ⱪilix kerǝkliki tehi kɵrsitilmigǝqkǝ, ular uni ⱪamap ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Pǝrwǝrdigar Musaƣa: — U adǝm ɵltürülmisǝ bolmaydu; pütün jamaǝt uni bargaⱨning texiƣa ǝpqiⱪip qalma-kesǝk ⱪilip ɵltürsun, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Andin pütün jamaǝt u adǝmni bargaⱨ sirtiƣa ǝpqiⱪip, huddi Pǝrwǝrdigar Musaƣa buyruƣandǝk, qalma-kesǝk ⱪilip ɵltürdi. ");
INSERT INTO uigpin_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Sǝn Israillarƣa mundaⱪ degin, ular ǝwladmu-ǝwlad kiyim-keqǝklirining qɵrisigǝ quqilarni tutsun ⱨǝm burjikidiki quqilirining ⱨǝrbirigǝ kɵk xoyna tikip ⱪoysun; ");
INSERT INTO uigpin_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","bu hil quqilar silǝrning uni tikip turuxunglar üqün bolidu; uni kɵrgǝndǝ Pǝrwǝrdigarning barliⱪ ǝmrlirini esinglarda tutup, ularƣa ǝmǝl ⱪilixinglar üqün bu silǝrgǝ bir ǝslǝtmǝ bolidu; xuningdǝk silǝrning ⱨazirⱪidǝk ɵzünglarning kɵnglünglar wǝ kɵzünglarning kǝynigǝ kirip, ⱪatirap buzuⱪluⱪ ⱪilip kǝtmǝslikinglar, ");
INSERT INTO uigpin_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Mening barliⱪ ǝmrlirimni ǝstǝ tutuxunglar ⱨǝm uningƣa ǝmǝl ⱪilip, Hudayinglarƣa atap pak-muⱪǝddǝs boluxunglar üqün bolsun. ");
INSERT INTO uigpin_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mǝn Hudayinglar bolux üqün silǝrni Misir zeminidin elip qiⱪⱪan Pǝrwǝrdigardurmǝn; Mǝn Pǝrwǝrdigar Hudayinglardurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Lawiyning ǝwrisi, Koⱨatning nǝwrisi, Izⱨarning oƣli Koraⱨ wǝ Rubǝnning ǝwladliridin Eliabning oƣulliri Datan bilǝn Abiram wǝ Pǝlǝtning oƣli On ");
INSERT INTO uigpin_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Israillar iqidiki jamaǝt ǝmirliri bolƣan, jamaǝt iqidin saylap qiⱪilƣan mɵtiwǝrlǝrdin ikki yüz ǝllik kixini baxlap kelip Musaƣa ⱪarxi qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ular yiƣilip Musaƣa ⱪarxi ⱨǝm Ⱨarunƣa ⱪarxi qiⱪip: — Silǝr ⱨǝddinglardin bǝk axtinglar, pütkül jamaǝtning ⱨǝmmisi pak-muⱪǝddǝs, Pǝrwǝrdigarmu ularning arisida, xundaⱪ turuƣluⱪ silǝr nemǝ dǝp ɵzünglǝrni Pǝrwǝrdigarning jamaitidin üstün ⱪoyusilǝr? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","5","Musa ularning gepini anglap düm yiⱪilip, Koraⱨ bilǝn uning guruⱨidikilǝrgǝ sɵz ⱪilip: — Ətǝ ǝtigǝndǝ Pǝrwǝrdigar kimlǝrning Ɵzigǝ mǝnsup ikǝnlikini, kimlǝrning pak-muⱪǝddǝs ikǝnlikini ayan ⱪilidu; xu kixini Ɵzigǝ yeⱪinlaxturidu; kimni talliƣan bolsa, uni Ɵzigǝ yeⱪinlaxturidu. ");
INSERT INTO uigpin_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Silǝr mundaⱪ ⱪilinglar: — Sǝn Koraⱨ wǝ sening guruⱨingdikilǝr ⱨǝmmisi huxbuydanlarni ǝpkelinglar; ");
INSERT INTO uigpin_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ǝtǝ Pǝrwǝrdigarning aldida huxbuydanlarƣa ot yeⱪip, huxbuyni uning üstigǝ ⱪoyunglar; Pǝrwǝrdigar kimni tallisa, xu muⱪǝddǝs-pak bolƣan bolsun! Əy silǝr Lawiylar, ⱨǝddinglardin bǝk axtinglar! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa yǝnǝ Koraⱨⱪa: — I Lawiylar, gepimgǝ ⱪulaⱪ selinglar. ");
INSERT INTO uigpin_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","10","Israilning Hudasi Pǝrwǝrdigar silǝrni Ɵzining qedirining ixlirini ⱪilsun dǝp ⱨǝmdǝ jamaǝtning aldida ularning hizmitidǝ bolsun dǝp Ɵzigǝ yeⱪinlaxturux üqün silǝrni Israil jamaitidin ayrip qiⱪⱪan — yǝni Pǝrwǝrdigar seni wǝ sening ⱨǝmmǝ ⱪerindaxliring bolƣan Lawiyning ǝwladlirini birdǝk Ɵzigǝ yeⱪinlaxturƣanliⱪi silǝrqǝ kiqik ixmu? Silǝr yǝnǝ tehi kaⱨinliⱪ wǝzipisini tama ⱪiliwatamsilǝr? ");
INSERT INTO uigpin_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Xu wǝjidin sǝn wǝ sening guruⱨingdikilǝr ⱨǝmmisi yiƣilip Pǝrwǝrdigarƣa ⱪarxi qiⱪiwetipsilǝr-dǝ; Ⱨarun nemidi, silǝr uning üstidin xunqilik aƣrinip ƣotuldixip kǝtküdǝk? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Musa Eliabning oƣli Datan bilǝn Abiramni ⱪiqⱪirip kelixkǝ adǝm ǝwǝtiwidi, ular: — Barmaymiz! ");
INSERT INTO uigpin_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Sening bizni süt bilǝn ⱨǝsǝl aⱪidiƣan zemindin baxlap qiⱪip bu qɵl-jǝziridǝ ɵltǝrmǝkqi bolƣanliⱪingning ɵzi kiqik ixmu? Sǝn tehi ɵzüngni padixaⱨ ⱨesablap bizning üstimizdin ⱨɵkümranliⱪ ⱪilmaⱪqimu? ");
INSERT INTO uigpin_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ⱨalbuki, sǝn bizni süt bilǝn ⱨǝsǝl aⱪidiƣan yurtⱪa baxlap kǝlmiding, etiz wǝ üzümzarliⱪlarnimu bizgǝ miras ⱪilip bǝrmiding. Sǝn bu hǝⱪning kɵzinimu oyuwalmaⱪqimu? Biz barmaymiz! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Buni anglap Musa ⱪattiⱪ ƣǝzǝplinip Pǝrwǝrdigarƣa: — Ularning sowƣat-ⱨǝdiyǝsigǝ etibar ⱪilmiƣaysǝn; mǝn ularning ⱨǝtta birǝr exikinimu tartiwalmidim, birǝr adimigimu ⱨeq ziyan-zǝhmǝt yǝtküzmidim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa Koraⱨⱪa: — Ətǝ sǝn wǝ sening guruⱨingdikilǝr — sǝn, ular wǝ Ⱨarun Pǝrwǝrdigarning aldiƣa kelinglar. ");
INSERT INTO uigpin_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ⱨǝrbiringlar ɵzünglarning huxbuydanliringlarni ǝkilip uning üstigǝ huxbuyni selinglar; ⱨǝrbiringlar ɵzünglarning huxbuydanliringlarni, yǝni jǝmiy ikki yüz ǝllik huxbuydanni elip uni Pǝrwǝrdigarning ⱨuzurida tutup turunglar; sǝnmu, Ⱨarunmu ⱨǝrbiringlar ɵz huxbuydanliringlarni elip kelinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Xuning bilǝn ⱨǝrbir adǝm ɵzining huxbuydanini elip, otni yeⱪip, huxbuy selip, Musa wǝ Ⱨarun bilǝn birliktǝ jamaǝt qedirining dǝrwazisi aldida turuxti. ");
INSERT INTO uigpin_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Koraⱨ Musa bilǝn Ⱨarunƣa ⱨujum ⱪilƣili pütün jamaǝtni yiƣip jamaǝt qedirining dǝrwazisi aldiƣa keliwidi, Pǝrwǝrdigarning julasi pütkül jamaǝtkǝ ayan boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Silǝr bu hǝlⱪning arisidin neri turunglar, mǝn kɵz yumup aqⱪuqǝ ularni yutuwetimǝn, — dewidi, ");
INSERT INTO uigpin_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Musa bilǝn Ⱨarun düm yiⱪilip: — I Tǝngrim, barliⱪ ǝt igilirining roⱨlirining Hudasi, bir adǝm gunaⱨ ⱪilsa, ƣǝzipingni pütün jamaǝtkǝ qaqamsǝn? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Sǝn jamaǝtkǝ: «Silǝr Koraⱨ, Datan wǝ Abiramning turar jayliridin ayrilip ulardin neri ketinglar» — dǝp buyruⱪ bǝr, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Xuning bilǝn Musa ornidin turup Datan bilǝn Abiram tǝrǝpkǝ ⱪarap mangdi; Israil aⱪsaⱪallirimu uningƣa ǝgixip mangdi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Musa jamaǝtkǝ: — Silǝrdin ɵtünimǝn, bu rǝzil adǝmlǝrning qedirliridin yiraⱪ ketinglar, ularning barliⱪ gunaⱨliri sǝwǝbidin ular bilǝn billǝ wǝyran bolmasliⱪinglar üqün ularning ⱨeqnǝrsisigǝ ⱪol tǝgküzmǝnglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Xuning bilǝn jamaǝt Koraⱨ, Datan, Abiramning qedirlirining tɵt ǝtrapidin neri kǝtti; Datan bilǝn Abiram bolsa ɵz ayallirini, oƣul-ⱪizlirini wǝ bowaⱪlirini elip qiⱪip ɵz qedirining ixiki aldida turdi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa: — Buningdin silǝr xuni bilisilǝrki, bu ixlarning ⱨǝmmisi mening kɵnglümdin qiⱪⱪan ǝmǝs, bǝlki Pǝrwǝrdigar meni ularni ada ⱪilixⱪa ǝwǝtkǝn: ");
INSERT INTO uigpin_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","— ǝgǝr bu adǝmlǝrning ɵlümi adǝttiki adǝmlǝrning ɵlümigǝ ohxax bolidiƣan yaki ularning bexiƣa qüxidiƣan ⱪismǝtlǝr adǝttiki adǝmlǝr duqar bolidiƣan ⱪismǝtlǝrgǝ ohxax bolidiƣan bolsa, Pǝrwǝrdigar meni ǝwǝtmigǝn bolatti. ");
INSERT INTO uigpin_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Əgǝr Pǝrwǝrdigar yengi bir ixni ⱪilip, yǝr aƣzini eqip ularni wǝ ularning pütün nǝrsisini yutup ketixi bilǝn, ular tirikla tǝⱨtisaraƣa qüxüp kǝtsǝ, u qaƣda silǝr bu adǝmlǝrning Pǝrwǝrdigarni mǝnsitmigǝnlikini bilip ⱪalisilǝr, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musaning bu gepi ahirlixixi bilǝnla ularning puti astidiki yǝr yerildi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Yǝr aƣzini eqip ularni barliⱪ ailisidikilǝr bilǝn, xuningdǝk Koraⱨⱪa tǝwǝ ⱨǝmmǝ adǝmlǝrni ⱪoymay tǝǝlluⱪatliri bilǝn ⱪoxup yutup kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Xundaⱪ ⱪilip, ular wǝ ularning tǝwǝsidikilǝrning ⱨǝmmisi tirikla tǝⱨtisaraƣa qüxüp kǝtti, yǝr ularning üstidǝ yepildi. Ular xu yol bilǝn jamaǝtning arisidin yoⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ularning ǝtrapida turƣan Israillarning ⱨǝmmisi ularning nalisini anglap: «Yǝr biznimu yutup ketǝrmikin!» deyixip ⱪeqixti. ");
INSERT INTO uigpin_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Andin Pǝrwǝrdigarning aldidin bir ot qiⱪip, huxbuy sunuwatⱪan ⱨeliⱪi ikki yüz ǝllik adǝmnimu yutup kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Sǝn kaⱨin Ⱨarunning oƣli Əliazarƣa buyruƣin, u huxbuydanlarni ot arisidin teriwelip, qoƣlirini yiraⱪlarƣa qeqiwǝtsun, qünki u huxbuydanlar Hudaƣa atalƣandur; ");
INSERT INTO uigpin_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","xunga ɵzining jeniƣa ɵzi zamin bolƣan gunaⱨkarlarning huxbuydanlirini teriwalƣin; ular ⱪurbangaⱨni ⱪaplax üqün soⱪup nepiz tünikǝ ⱪilinsun, qünki bu huxbuydanlar ǝslidǝ Pǝrwǝrdigarning ⱨuzuriƣa sunulup uningƣa atalip muⱪǝddǝs ⱪilinƣan. Xundaⱪ ⱪilip ular keyin Israillarƣa ibrǝt bolidiƣan ixarǝt-bǝlgǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Xuning bilǝn kaⱨin Əliazar otta kɵydürüwetilgǝnlǝr sunƣan mis huxbuydanlarni teriwaldi; ular ⱪurbangaⱨni ⱪaplitixⱪa nepiz tünikǝ ⱪilip soⱪuldi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Xuning bilǝn ⱪurbangaⱨning bu ⱪaplimisi Ⱨarunning ǝwladliriƣa yat adǝmlǝrning huddi Koraⱨ bilǝn uning guruⱨidikilǝrgǝ ohxax ⱪismǝtkǝ ⱪalmasliⱪi üqün, Pǝrwǝrdigarning ⱨuzurida huxbuy kɵydürüxkǝ yeⱪinlaxmasliⱪiƣa Israillar üqün bir ǝslǝtmǝ boldi. Bu Pǝrwǝrdigarning Musaning wastisi bilǝn Əliazarƣa buyruƣanliridur. ");
INSERT INTO uigpin_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ətisi pütkül Israil jamaiti Musa bilǝn Ⱨarunning yaman gepini ⱪilip: — Silǝr Pǝrwǝrdigarning hǝlⱪini ɵltürdünglar, — dǝp ƣotuldaxti. ");
INSERT INTO uigpin_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Wǝ xundaⱪ boldiki, jamaǝt Musa bilǝn Ⱨarunƣa ⱨujum ⱪilixⱪa yiƣiliwatⱪanda, jamaǝt burulup jamaǝt qediriƣa ⱪariwidi, wǝ mana, bulut qedirni ⱪapliwaldi ⱨǝm Pǝrwǝrdigarning julasi ayan boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Xuning bilǝn Musa bilǝn Ⱨarun jamaǝt qedirining aldiƣa berip turdi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Pǝrwǝrdigar Musaƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Mǝn kɵzni yumup aqⱪuqǝ ularni yoⱪitip taxlixim üqün ikkinglar bu jamaǝttin qiⱪip neri ketinglar, — dǝp buyruwidi, ikkiylǝn yiⱪilip yǝrdǝ düm yatti. ");
INSERT INTO uigpin_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa Ⱨarunƣa: — Sǝn huxbuydanni elip uningƣa ⱪurbangaⱨtiki ottin sal, uningƣa huxbuy ⱪoyup, ular üqün kǝfarǝt kǝltürüxkǝ tezliktǝ jamaǝtning arisiƣa apar; qünki ⱪǝⱨr-ƣǝzǝp Pǝrwǝrdigarning aldidin qiⱪti, waba basⱪili turdi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ⱨarun Musaning deginidǝk ⱪilip, huxbuydanni elip jamaǝtning arisiƣa yügürüp kirdi; wǝ mana, waba kixilǝrning arisida baxlanƣanidi; u huxbuyni huxbuydanƣa selip, hǝlⱪ üqün kǝfarǝt kǝltürdi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","U ɵlüklǝr bilǝn tiriklǝr otturisida turuwidi, waba tohtidi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Koraⱨning wǝⱪǝsi munasiwiti bilǝn ɵlgǝnlǝrdin baxⱪa, waba sǝwǝbidin ɵlgǝnlǝr on tɵt ming yǝttǝ yüz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ⱨarun jamaǝt qedirining dǝrwazisi yenida turƣan Musaning yeniƣa yenip kǝldi; waba tohtidi. ");
INSERT INTO uigpin_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Sǝn Israillarƣa sɵz ⱪilip, ulardin ata jǝmǝti boyiqǝ, ⱨǝr ⱪǝbilining ǝmiridin birdin on ikki ⱨasa alƣin; sǝn ularning ⱨǝrbirining ismini ɵzining ⱨasisiƣa yezip ⱪoyƣin. ");
INSERT INTO uigpin_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Lawiy ⱪǝbilisining ⱨasisiƣa Ⱨarunning ismini yazƣin, qünki ⱨǝrbir ata jǝmǝt ⱪǝbilǝ baxliⱪi üqün bir ⱨasa wǝkil bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Sǝn bu ⱨasilarni jamaǝt qediridiki ⱨɵküm-guwaⱨliⱪ sanduⱪining aldiƣa, yǝni Mǝn sening bilǝn kɵrüxidiƣan yǝrgǝ ⱪoyƣin.    ");
INSERT INTO uigpin_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Wǝ xundaⱪ boliduki, Mǝn talliƣan kixining bolsa, uning ⱨasisi bih süridu; xundaⱪ ⱪilip Israillarning silǝrgǝ ƣuduraxⱪan gǝplirini tohtitip Manga anglanmaydiƣan ⱪiliwetimǝn». ");
INSERT INTO uigpin_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Xuning bilǝn Musa Israillarƣa xundaⱪ sɵz ⱪildi; ularning ⱨǝmmǝ ǝmirliri uningƣa birdin ⱨasini, jǝmiy bolup on ikki ⱨasini bǝrdi; ⱨǝrbir ata jǝmǝtkǝ bir ⱨasa wǝkil boldi, Ⱨarunning ⱨasisimu xularning iqidǝ idi. ");
INSERT INTO uigpin_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa ⱨasilarni ⱨɵküm-guwaⱨliⱪ qediriƣa ǝkirip Pǝrwǝrdigarning ⱨuzuriƣa ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Wǝ xundaⱪ boldiki, Musa ǝtisi ⱨɵküm-guwaⱨliⱪ qediriƣa kiriwidi, mana, Lawiy jǝmǝtigǝ wǝkil bolƣan Ⱨarunning ⱨasisi bih sürüp, ƣunqilap, qeqǝklǝp, badam qüxkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musa ⱨasilarning ⱨǝmmisini Pǝrwǝrdigarning aldidin elip qiⱪip, Israil hǝlⱪigǝ kɵrsǝtti; ular kɵrgǝndin keyin ⱨǝrkim ɵz ⱨasilirini elip ketixti. ");
INSERT INTO uigpin_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Pǝrwǝrdigar Musaƣa: — Xu asiyliⱪ ⱪilƣuqi balilarƣa bir agaⱨ bǝlgisi bolsun dǝp Ⱨarunning ⱨasisini ⱨɵküm-guwaⱨning aldiƣa ǝkirip ⱪoyƣin. Xundaⱪ ⱪilsang sǝn ularning ƣuduraxⱪan gǝplirini tohtitip, Manga anglanmaydiƣan ⱪilisǝn; ularmu xuning bilǝn ɵlüp kǝtmǝydu, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa xundaⱪ ⱪildi; Pǝrwǝrdigar ɵzigǝ ⱪandaⱪ buyruƣan bolsa u xundaⱪ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israillar Musaƣa sɵz ⱪilip: — Biz nǝpǝstin ⱪalay dǝwatimiz, biz tügǝxtuⱪ, biz ⱨǝmmimiz tügǝxtuⱪ! ");
INSERT INTO uigpin_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Pǝrwǝrdigarning ibadǝt qediriƣa yeⱪinlaxⱪanlar ɵlmǝy ⱪalmaydu, xundaⱪ ikǝn, biz ⱨǝmmimiz mutlǝⱪ nǝpǝstin ⱪeliximiz kerǝkmu? — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Pǝrwǝrdigar Ⱨarunƣa mundaⱪ dedi: — Sǝn, oƣulliring wǝ ata jǝmǝtingdikilǝr sening bilǝn birliktǝ muⱪǝddǝs jayƣa munasiwǝtlik bolƣan gunaⱨni, xuningdǝk sǝn wǝ oƣulliring birliktǝ kaⱨinliⱪ wǝzipisigǝ munasiwǝtlik bolƣan gunaⱨni üstünglarƣa alisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Sǝn ⱪerindaxliring bolƣan Lawiy ⱪǝbilisidikilǝrni, yǝni ata-bowiliringning ⱪǝbilisidikilǝrni ɵzüng bilǝn birlǝxtür ⱨǝm ularni hizmitingni ⱪilixi üqün baxlap elip kǝl; biraⱪ sǝn bilǝn oƣulliring sening bilǝn birliktǝ ⱨɵküm-guwaⱨliⱪ qediri aldida hizmǝtlǝrni ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ular sening buyruⱪliringƣa tǝyyar turup, xundaⱪla qedirdiki barliⱪ hizmǝt-wǝzipisini ɵtǝydu; pǝⱪǝt muⱪǝddǝs jaydiki ⱪaqa-ⱪuqa ǝswablarƣa wǝ ⱪurbangaⱨⱪa yeⱪinlaxmisun; undaⱪ ⱪilsa, ularmu, silǝrmu ɵlüp ketisilǝr. ");
INSERT INTO uigpin_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ular sening bilǝn birlixip, jamaǝt qediridiki wǝzipini ɵtǝp, ⱪilidiƣan ⱨǝrbir ixini ⱪilsun; pǝⱪǝtla ⱨeq yat kixilǝr silǝrgǝ yeⱪinlaxmisun. ");
INSERT INTO uigpin_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ⱪǝⱨr-ƣǝzǝp yǝnǝ Israillarning bexiƣa qüxmisun üqün, silǝr muⱪǝddǝs jaydiki wǝzipǝ bilǝn ⱪurbangaⱨdiki wǝzipini ɵtǝxkǝ mǝs’ul bolunglar. ");
INSERT INTO uigpin_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mana, Mǝn Ɵzüm silǝrning ⱪerindaxliringlar bolƣan Lawiylarni Israillar iqidin tallap qiⱪtim; ular jamaǝt qedirining ixlirini ⱪilixⱪa Pǝrwǝrdigarƣa tǝⱪdim ⱪilinƣan bolup, silǝrgǝ sowƣa süpitidǝ ata ⱪilinƣan. ");
INSERT INTO uigpin_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Lekin sǝn wǝ oƣulliring sening bilǝn birliktǝ kaⱨinliⱪ wǝzipǝnglǝrdǝ turup, ⱪurbangaⱨtiki barliⱪ ixlarni ⱨǝm pǝrdǝ iqidiki ixlarni bejiringlar; silǝrning wǝzipǝnglǝr xundaⱪ bolsun. Kaⱨinliⱪ wǝzipisini, hizmitimdǝ boluxunglar üqün silǝrgǝ sowƣa ⱪilip bǝrdim; yat adǝmlǝr yeⱪinlaxsa, ɵltürüwetilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Pǝrwǝrdigar Ⱨarunƣa mundaⱪ dedi: — Mǝn Manga sunulƣan kɵtürmǝ ⱨǝdiyǝlǝrni, yǝni Israillar Manga muⱪǝddǝs dǝp atiƣan barliⱪ nǝrsilǝrni ülüxünglar bolsun dǝp, mana mǝnggülük bǝlgilimǝ bilǝn sanga wǝ sening ǝwladliringƣa tǝⱪdim ⱪildim. ");
INSERT INTO uigpin_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Israillar otta sunidiƣan, «ǝng muⱪǝddǝs» nǝrsilǝrdin silǝrgǝ munular ⱪaldurup berilidu: — ularning Manga atap sunƣan barliⱪ nǝrsiliri, yǝni barliⱪ axliⱪ ⱨǝdiyǝliridin, barliⱪ gunaⱨ ⱪurbanliⱪliridin, barliⱪ itaǝtsizlik ⱪurbanliⱪliridin «ǝng muⱪǝddǝs» ⱨesablanƣanliri, sanga wǝ ǝwladliringƣa ata ⱪilinidu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Sǝn xu ülüxüngni «ǝng muⱪǝddǝs» süpitidǝ yegin, silǝrdin bolƣan ⱨǝrbir ǝr kixi uni yesun; u sanga «ǝng muⱪǝddǝs» dǝp bilinsun. ");
INSERT INTO uigpin_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Munularmu sening bolidu: — Israillarning sowƣatliri iqidin kɵtürmǝ ⱨǝdiyǝlǝr, barliⱪ pulanglatma ⱨǝdiyǝlǝr sening; Mǝn ularni sanga, xundaⱪla oƣulliring bilǝn ⱪizliringƣa mǝnggülük bǝlgilimǝ bilǝn tǝⱪdim ⱪildim; sening ɵyüngdiki ⱨǝrbir pak adǝm uningdin yesǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Zǝytun meyidin ǝng esilini, yengi xarabtin ǝng esilini, xundaⱪla axliⱪtin ǝng esilini, yǝni Israillar Pǝrwǝrdigarƣa atap sunƣan dǝslǝpki pixⱪan mǝⱨsulatlarning ⱨǝmmisini Mǝn sanga tǝⱪdim ⱪilip bǝrdim. ");
INSERT INTO uigpin_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ular yǝrdin elip Pǝrwǝrdigarƣa atap ǝkǝlgǝn dǝslǝpki pixⱪan nǝrsilǝrning ⱨǝmmisi sening bolsun; ɵyüngdiki ⱨǝrbir pak adǝm uningdin yesǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Israilda Hudaƣa mutlǝⱪ atilidiƣan ⱨǝrbir nǝrsǝ sening bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ular Pǝrwǝrdigarƣa atap kǝltüridiƣan barliⱪ janiwarlarning tunjiliri, mǝyli insan yaki ulaƣ-qarpay bolsun sening bolidu; ⱨalbuki, insanlarning tunjilirini bolsa ularni tɵlǝm tɵlǝp yanduruwalsun wǝ napak ⱨaywanlarning tunjilirini tɵlǝm tɵlǝp yanduruwalsun.    ");
INSERT INTO uigpin_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Tɵlǝm tɵlǝx kerǝk bolƣanlar üqün yexi bir ayliⱪtin axⱪanda tɵlǝm puli tɵlǝnsun; ularƣa sǝn tohtatⱪan baⱨa boyiqǝ, yǝni muⱪǝddǝs jaydiki xǝkǝlning ɵlqǝm birliki boyiqǝ (bir xǝkǝl yigirmǝ gǝraⱨdur) baⱨa ⱪoyup, bǝx kümüx xǝkǝl al. ");
INSERT INTO uigpin_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Pǝⱪǝt tunji kala, tunji ⱪoy yaki tunji oƣlaⱪⱪa tɵlǝm alsang bolmaydu; ularning ⱨǝmmisi muⱪǝddǝstur. Sǝn ularning ⱪenini ⱪurbangaⱨⱪa qeqip, meyini Pǝrwǝrdigarƣa atap otta sunulidiƣan, Uningƣa huxbuy kǝltüridiƣan ⱪurbanliⱪ süpitidǝ kɵydürgin. ");
INSERT INTO uigpin_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ularning gɵxi sening bolidu; huddi «kɵtürmǝ ⱨǝdiyǝ» ⱪilinƣan tɵx wǝ ong arⱪa putiƣa ohxax, sanga tǝwǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Israillar Pǝrwǝrdigarƣa atap sunƣan muⱪǝddǝs nǝrsilǝr iqidiki kɵtürmǝ ⱨǝdiyǝ-ⱪurbanliⱪning ⱨǝmmisini Mǝn sanga wǝ sening bilǝn billǝ turuwatⱪan oƣul-ⱪizliringƣa mǝnggülük bǝlgilimǝ bilǝn tǝⱪdim ⱪildim. Bu Pǝrwǝrdigar aldida sǝn wǝ sening bilǝn billǝ turuwatⱪan ǝwladliring üqün mǝnggülük tuzluⱪ ǝⱨdǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Pǝrwǝrdigar Ⱨarunƣa mundaⱪ dedi: — Israil zeminida sening ⱨeqⱪandaⱪ mirasing bolmaydu, ularning arisidimu ⱨeqⱪandaⱪ nesiwǝng bolmaydu; Israillar arisida mana Mǝn Ɵzüm sening nesiwǝng, sening mirasingdurmǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Lawiylarƣa bolsa, ularning ɵtǝydiƣan hizmǝtliri, yǝni jamaǝt qediridiki hizmiti üqün, mana Mǝn Israilda tǝⱪdim ⱪilinƣan barliⱪ «ondin bir ülüx»ning ⱨǝmmisini ularƣa miras ⱪilip bǝrgǝnmǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Buningdin keyin, gunaⱨkar bolup ɵlüp kǝtmǝsliki üqün, Israillar jamaǝt qediriƣa yeⱪinlaxmisun. ");
INSERT INTO uigpin_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Jamaǝt qediridiki hizmǝtni bolsa, uni ɵtigüqilǝr pǝⱪǝt Lawiylarla bolidu wǝ xu ixta bolƣan gunaⱨini ɵzliri üstigǝ alidu, bu silǝr üqün ǝwladmu-ǝwlad mǝnggülük bir bǝlgilimǝ bolidu; ularning Israillarning iqidǝ ⱨeqⱪandaⱪ mirasi bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Qünki Israillarning Pǝrwǝrdigarƣa atap kɵtürmǝ ⱨǝdiyǝ süpitidǝ sunƣan «ondin bir ülüxi»ni Lawiylarƣa miras ⱪilip tǝⱪdim ⱪilidiƣan boldum; xunga Mǝn ular toƣruluⱪ: Israillar iqidǝ ⱨeqⱪandaⱪ mirasi bolsa bolmaydu, — dedim. ");
INSERT INTO uigpin_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Sǝn Lawiylarƣa eytⱪin: «Silǝr Israillarning ⱪolidin Mǝn silǝrgǝ miras bolsun dǝp tǝⱪdim ⱪilƣan «ondin bir ülüx»ni alƣan ikǝnsilǝr, silǝr xu ondin bir ülüxning yǝnǝ ondin bir ülüxini ayrip, uni Pǝrwǝrdigarƣa atap kɵtürmǝ ⱨǝdiyǝ süpitidǝ sununglar. ");
INSERT INTO uigpin_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Bu yol bilǝn silǝrning xu «kɵtürmǝ ⱨǝdiyǝ»nglar silǝrgǝ «hamandiki axliⱪinglar»din ⱨǝm «xarab kɵlqikidiki tolup taxⱪan xarabinglar»din atalƣanlar ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Bundaⱪ bolƣanda, silǝr Israillarning ⱪolidin alƣan ondin bir ülüxning ⱨǝmmisidin Pǝrwǝrdigarƣa atap kɵtürmǝ ⱨǝdiyǝ sunisilǝr; silǝr Pǝrwǝrdigarƣa atiƣan xu «kɵtürmǝ ⱨǝdiyǝ»ni kaⱨin Ⱨarunƣa beringlar. ");
INSERT INTO uigpin_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Silǝrgǝ tǝⱪdim ⱪilinƣan barliⱪ nǝrsilǝrdin ǝng esilini elip xularni muⱪǝddǝs ⱨesablap «Pǝrwǝrdigarƣa atalƣan toluⱪ kɵtürmǝ ⱨǝdiyǝ» süpitidǝ sununglar». ");
INSERT INTO uigpin_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Xunga sǝn Lawiylarƣa eytⱪinki, «Silǝr xulardin ǝng esilini kɵtürüp sunsanglar, bu silǝr Lawiylarning hamandiki axliⱪinglar wǝ xarab kɵlqikidiki xarabinglarƣa ohxax ⱨesablinidu. ");
INSERT INTO uigpin_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Xundaⱪ ⱪilƣandin keyin silǝr wǝ ɵydikiliringlar xu «ondin bir ülüx»lǝrni haliƣan yǝrdǝ yesǝnglar bolidu, qünki bu silǝrning jamaǝt qediridiki hizmitinglarning in’ami bolidu; ");
INSERT INTO uigpin_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Silǝr xu ülüxlǝrdin ǝng esilini kɵtürüp sunsanglar, muxu ixinglar sǝwǝbidin gunaⱨkar bolmaysilǝr. Undaⱪ ⱪilsanglar silǝr Israillar atiƣan muⱪǝddǝs nǝrsilǝrni bulƣimaysilǝr, xuning bilǝn ɵlmǝysilǝr». ");
INSERT INTO uigpin_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Mǝn Pǝrwǝrdigar ǝmr ⱪilƣan ⱪanun-bǝlgilimǝ xuki: — Sǝn Israillarƣa buyruƣin, ular bejirim, nuⱪsansiz, boyunturuⱪ selinmiƣan ⱪizil yax siyirdin birni sening yeningƣa ǝkǝlsun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Sǝn siyirni kaⱨin Əliazarƣa tapxur, u uni qedirgaⱨning sirtiƣa ǝpqiⱪsun, andin birsi siyirni uning aldida boƣuzlisun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kaⱨin Əliazar barmiⱪini ⱪanƣa milǝp, jamaǝt qedirining aldiƣa ⱪaritip yǝttǝ mǝrtǝm qaqsun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Andin birsi Əliazarning kɵz aldida pütkül siyirni kɵydürsun, yǝni uning terisi, gɵxi, ⱪeni wǝ tezǝklirini kɵydürsun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kaⱨin kedir yaƣiqi, zofa ɵsümlüki wǝ ⱪizil rǝhtni siyir kɵydürülidiƣan otⱪa taxlisun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Andin kaⱨin ɵz kiyimini yusun wǝ bǝdinini suda yusun, andin keyin bargaⱨⱪa kirixkǝ bolidu; lekin kaⱨin kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Siyirni kɵydürgǝn kiximu kiyimlirini su bilǝn yuyup, ɵz bǝdinini suda yusun, andin u kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Pak bir adǝm siyirning külini yiƣip bargaⱨning sirtidiki pak bir yǝrgǝ ⱪoysun; u Israil jamaiti üqün «napakliⱪni qiⱪarƣuqi su»ni yasaxⱪa xu yǝrdǝ saⱪlansun, u bir «gunaⱨni pakliƣuqi»dur. ");
INSERT INTO uigpin_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Siyirning külini yiƣixturƣan adǝm ɵzining kiyimlirini yusun wǝ kǝq kirgüqǝ napak sanalsun. Bu Israillarƣa wǝ ularning arisida turuwatⱪan musapirlarƣa mǝnggülük ⱪanun-bǝlgilimǝ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","— Ɵlükkǝ, yǝni ⱨǝrⱪandaⱪ ɵlgǝn kixining jǝsitigǝ tegip kǝtkǝn ⱨǝrbir kixi yǝttǝ kün napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","U adǝm üqinqi küni axu su bilǝn ɵzini paklisun, ⱨǝmdǝ yǝttinqi künimu paklisun, andin u pak sanilidu; ǝgǝr u üqinqi küni ⱨǝmdǝ yǝttinqi küni ɵzini paklimisa, pak sanalmaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ⱨǝrⱪandaⱪ adǝm ɵlükkǝ, yǝni ⱨǝrⱪandaⱪ ɵlgǝn kixining jǝsitigǝ tegip kǝtsǝ, ⱨǝmdǝ ɵzini paklimisa, Pǝrwǝrdigarning qedirini bulƣiƣan bolidu; xu kixi Israil arisidin üzüp taxlinidu; qünki «napakliⱪni qiⱪarƣuqi su» uningƣa sepilmigǝqkǝ, u napak sanilidu; uning napakliⱪi tehiqǝ üstidǝ turidu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Əgǝr birǝr kixi bir qedir iqidǝ ɵlüp ⱪalƣan bolsa, u toƣruluⱪ ⱪanun-bǝlgilimǝ mundaⱪ bolidu: — xu qedirƣa kirgǝn ⱨǝrbirsi wǝ qedirda turup ⱪalƣanlarning ⱨǝrbiri yǝttǝ kün napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ⱨǝrbir oquⱪ turƣan, aƣzi yepilmiƣan ⱪaqa-ⱪuqilarning ⱨǝmmisi napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Xuningdǝk dalada ⱪiliq-xǝmxǝr bilǝn ɵltürülgǝnlǝrgǝ, yaki ɵzi ɵlüp ⱪalƣanning ɵlükigǝ, yaki adǝmning ustihininiƣa yaki ⱪǝbrisigǝ tǝgkǝn ⱨǝrbir kixi yǝttǝ küngiqǝ napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Kixilǝr bu napak kixi üqün «paklandurƣuqi ⱪurbanliⱪ»ning külidin azraⱪ elip komzǝkkǝ selip, ularning üstigǝ eⱪin su ⱪuysun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Andin pak bir kixi zofa ɵsümlükini elip xu suƣa tǝgküzüp uni qedirƣa wǝ iqidiki barliⱪ ⱪaqa-ⱪuqilarƣa ⱨǝm xu yǝrdǝ turƣan barliⱪ kixilǝrning üstigǝ sepip ⱪoysun, wǝ yǝnǝ uni ustihanƣa, ɵltürülgüqigǝ yaki ⱪǝbrigǝ tǝgkǝn kixining üstigǝ sepip ⱪoysun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Üqinqi küni wǝ yǝttinqi küni ⱨeliⱪi pak adǝm pak bolmiƣan adǝmlǝrning üstigǝ xu suni sepip ⱪoysun; xundaⱪ ⱪilƣanda, yǝttinqi künigǝ kǝlgǝndǝ u kixi paklanƣan bolidu; andin u kixi kiyimlirini yuyup, bǝdinini suda yusun, kǝq kirgǝndǝ u pak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Lekin napak bolup ⱪelip, ɵzini paklimiƣan kixi Pǝrwǝrdigarning muⱪǝddǝs jayini bulƣiƣini üqün, jamaǝt arisidin üzüp taxlinidu; «napakliⱪni qiⱪarƣuqi su» uning üstigǝ sepilmigǝn, xunga u napak sanilidu. ");
INSERT INTO uigpin_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Bu Israillarƣa mǝnggülük bǝlgilimǝ bolidu, «napakliⱪni qiⱪarƣuqi su»ni sǝpkǝn kixi bolsa ɵzining kiyimlirini yusun wǝ «napakliⱪni qiⱪarƣuqi su»ƣa tǝgkǝn kixi kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Napak kixi tǝgkǝn ⱨǝrⱪandaⱪ nǝrsimu napak sanilidu; bu nǝrsilǝrgǝ tǝgkǝn kixilǝrmu kǝq kirgüqǝ napak sanalsun. ");
INSERT INTO uigpin_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Birinqi ayning iqidǝ Israillar, yǝni pütkül Israil jamaiti Zin qɵligǝ yetip kelip, Ⱪadǝxtǝ turup ⱪaldi; Mǝryǝm xu yǝrdǝ wapat boldi wǝ xu yǝrgǝ dǝpnǝ ⱪilindi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Jamaǝtkǝ iqidiƣanƣa su yoⱪ idi, ular yiƣilip Musa bilǝn Ⱨarunƣa ⱨujum ⱪilƣili turdi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Hǝlⱪ Musa bilǝn tǝgixip: — Ⱪerindaxlirimiz Pǝrwǝrdigarning aldida ɵlgǝn qaƣda bizmu billǝ ɵlsǝk boptikǝn! ");
INSERT INTO uigpin_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Silǝr nemǝ üqün biz wǝ qarpaylirimizni bu yǝrdǝ ɵlüp kǝtsun dǝp, Pǝrwǝrdigarning jamaitini bu qɵl-jǝzirigǝ baxlap kǝldinglar? ");
INSERT INTO uigpin_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Silǝr nemǝ üqün bizni Misirdin elip qiⱪip bundaⱪ dǝⱨxǝtlik yǝrgǝ ǝkǝldinglar? Bu yǝrdǝ ya teriⱪqiliⱪ ⱪilƣili yǝr bolmisa, ya ǝnjür, üzüm, anar bolmisa, iqidiƣanƣa sumu bolmisa, — deyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Xuning bilǝn Musa bilǝn Ⱨarun jamaǝttin ayrilip jamaǝt qedirining dǝrwazisi aldiƣa kelip düm yiⱪiliwidi, Pǝrwǝrdigarning julasi u ikkisigǝ ayan boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Ⱨasini ⱪolungƣa al, andin sǝn akang Ⱨarun bilǝn birliktǝ jamaǝtni yiƣip, ularning kɵz aldidila ⱪoram taxⱪa buyruⱪ ⱪil; xundaⱪ ⱪilsang ⱪoram tax ɵz süyini qiⱪiridu; xu yol bilǝn sǝn ularƣa su qiⱪirip, jamaǝt wǝ qarpayliri iqidiƣanƣa su berisǝn.    ");
INSERT INTO uigpin_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Xuning bilǝn Musa Pǝrwǝrdigarning ǝmri boyiqǝ Pǝrwǝrdigarning ⱨuzuridin ⱨasini aldi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa bilǝn Ⱨarun ikkisi jamaǝtni ⱪoram taxning aldiƣa yiƣdi wǝ Musa ularƣa: — Gepimgǝ ⱪulaⱪ selinglar, i asiylar! Biz silǝrgǝ bu ⱪoram taxtin su qiⱪirip berǝylimu?! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Andin Musa ⱨasisi bilǝn ⱪoram taxni ikki ⱪetim uruwidi, naⱨayiti kɵp su eⱪip qiⱪti, sudin jamaǝtmu, qarpaylarmu iqixti. ");
INSERT INTO uigpin_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Pǝrwǝrdigar Musa bilǝn Ⱨarunƣa: — Silǝr Manga ixǝnmǝy, Israillar aldida Meni muⱪǝddǝs dǝp ⱨɵrmǝtlimigininglar üqün, ikkinglarning bu jamaǝtni Mǝn ularƣa tǝⱪdim ⱪilip bǝrgǝn zeminƣa baxlap kirixinglarƣa yol ⱪoymaymǝn, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Su qiⱪirilƣan jay «Mǝribaⱨ suliri» dǝp atalƣan; Israillar xu yǝrdǝ Pǝrwǝrdigar bilǝn takallaxⱪanliⱪi üqün, U ularning otturisida Ɵzining muⱪǝddǝs ikǝnlikini kɵrsǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa Ⱪadǝxtin Edom padixaⱨi bilǝn kɵrüxüxkǝ ǝlqi ǝwǝtip uningƣa: «Ⱪerindaxliri Israil mundaⱪ dǝydu: — Biz tartiwatⱪan jǝbr-japalarning ⱪandaⱪliⱪi ɵzlirigǝ mǝlum, ");
INSERT INTO uigpin_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","bizning ata-bowilirimiz Misirƣa qüxkǝn bolup, biz Misirda uzaⱪ zaman turup kǝttuⱪ; misirliⱪlar bizgimu, bizning ata-bowilirimizƣimu yaman muamilǝ ⱪildi; ");
INSERT INTO uigpin_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","biz Pǝrwǝrdigarƣa yeliniweduⱪ, U bizning zarimizƣa ⱪulaⱪ selip, Pǝrixtǝ ǝwǝtip bizni Misirdin elip qiⱪti. Ⱨazir mana, biz ɵzlirining qegrisiƣa jaylaxⱪan Ⱪadǝx degǝn bir xǝⱨǝrdǝ turuwatimiz.    ");
INSERT INTO uigpin_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Əmdi bizning zeminliridin ɵtüximizgǝ ruhsǝt ⱪilƣan bolsila, biz etiz-eriⱪ wǝ üzümzarliⱪlardin ɵtmǝymiz, ⱪuduⱪliringladin sumu iqmǝymiz; «Han yoli» bilǝn mengip qegriliridin ɵtüp kǝtküqǝ ong-solƣa burulmaymiz» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Lekin Edomlar uningƣa: «Silǝrning bizning zeminimizdin ɵtüxünglǝrgǝ bolmaydu, ɵtimǝn desǝnglar ⱪiliq kɵtürüp silǝrgǝ jǝnggǝ qiⱪimiz» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israillar uningƣa: «Biz «kɵtürülgǝn yol» bilǝn mangimiz, ɵzimiz wǝ mallirimiz süyünglarni iqsǝk, nǝrhi boyiqǝ ⱨǝⱪⱪini berimiz; biz pǝⱪǝt piyadǝ ɵtüp ketimiz, baxⱪa ⱨeq tǝlipimiz yoⱪ» dewidi, ");
INSERT INTO uigpin_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Edom padixaⱨi: «Yaⱪ. Ɵtmǝysilǝr!» dedi. Edom padixaⱨi naⱨayiti kɵp adimini baxlap qiⱪip Israillarƣa zor ⱨǝywǝ kɵrsǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Xundaⱪ ⱪilip Edomlar Israillarning ularning tǝwǝlikidin ɵtüxigǝ ǝnǝ xu yosunda yol ⱪoymidi; xuning bilǝn Israillar Edomlarning aldidin burulup kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ular Ⱪadǝxtin yolƣa qiⱪti; pütkül Israil hǝlⱪi Ⱨor teƣiƣa kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Pǝrwǝrdigar Edomning qegrisidiki Ⱨor teƣida Musa bilǝn Ⱨarunƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Ⱨarun ɵz hǝlⱪlirigǝ ⱪoxulup ketidu; ikkinglar Mǝribaⱨ suliri degǝn jayda Mening ǝmrimgǝ hilapliⱪ ⱪilƣininglar üqün, uning Mǝn Israillarƣa tǝⱪdim ⱪilip bǝrgǝn zeminƣa kirixigǝ bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Sǝn Ⱨarun bilǝn oƣli Əliazarni elip Ⱨor teƣiƣa qiⱪⱪin; ");
INSERT INTO uigpin_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ⱨarunning kiyimlirini saldurup, oƣli Əliazarƣa kiydürüp ⱪoy; Ⱨarun xu yǝrdǝ ɵlüp, ɵz hǝlⱪlirigǝ ⱪoxulidu. ");
INSERT INTO uigpin_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa Pǝrwǝrdigarning deginidǝk ⱪildi, üqǝylǝn pütkül jamaǝtning kɵz aldida Ⱨor teƣiƣa qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa Ⱨarunning kiyimlirini saldurup uning oƣli Əliazarƣa kiydürüp ⱪoydi; Ⱨarun taƣning qoⱪⱪisida ɵldi. Andin Musa bilǝn Əliazar taƣdin qüxüp kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Pütkül jamaǝt Ⱨarunning ɵlgǝnlikini bildi; xuning bilǝn pütün Israil jǝmǝti Ⱨarun üqün ottuz kün matǝm tutti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Jǝnubta turuxluⱪ Arad mǝmlikitining Ⱪanaaniylardin bolƣan padixaⱨi Israillarning Atarim yoli bilǝn keliwatⱪanliⱪini anglap, qiⱪip ular bilǝn soⱪuxup, nǝqqǝylǝnni tutⱪun ⱪilip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Andin Israillar Pǝrwǝrdigarƣa ⱪǝsǝm iqip: «Əgǝr bu hǝlⱪni bizning ⱪolimizƣa pütünlǝy tapxuridiƣan bolsang, ularning xǝⱨǝrlirini wǝyran ⱪilip taxlaymiz» — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Pǝrwǝrdigar Israillarning pǝryadini anglap, Ⱪanaanliylarni ularning ⱪoliƣa tapxurdi, xuning bilǝn ular Ⱪanaaniylarni ularning xǝⱨǝrliri bilǝn ⱪoxup wǝyran ⱪildi; xu sǝwǝbtin ular xu yǝrni «Hormaⱨ» dǝp atidi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ular Ⱨor teƣidin yolƣa qiⱪip, Edom zeminini aylinip ɵtüx üqün, Ⱪizil Dengiz boyidiki yolni boylap mangdi; hǝlⱪ muxu yol sǝwǝbidin kɵnglidǝ tolimu taⱪǝtsiz bolup, ");
INSERT INTO uigpin_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Hudaƣa wǝ Musaƣa ⱪarxi qiⱪip: — Silǝr nemǝ üqün bizni qɵl-jǝziridǝ ɵlsun dǝp Misir zeminidin baxlap qiⱪⱪansilǝr? Bu yǝrdǝ ya axliⱪ, ya su yoⱪ, kɵnglimiz bu ǝrzimǝs nanlardin bizar boldi, deyixti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Xu sǝwǝbtin Pǝrwǝrdigar ularning arisiƣa zǝⱨǝrlik yilanlarni ǝwǝtti; yilanlar ularni qaⱪti, xu sǝwǝbtin Israillardin nurƣun adǝm ɵlüp kǝtti.    ");
INSERT INTO uigpin_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Hǝlⱪ Musaning aldiƣa kelip uningƣa: — Biz aƣzimizni buzup, Pǝrwǝrdigarƣa ⱨǝm sanga ⱨujum ⱪilip, yaman gǝp ⱪilip gunaⱨ ⱪilduⱪ; Pǝrwǝrdigarƣa tilawǝt ⱪilsang, u bu yilanlarni arimizdin elip kǝtkǝy, — dewidi, Musa hǝlⱪ üqün dua ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Pǝrwǝrdigar Musaƣa: — Sǝn bir zǝⱨǝrlik yilanning xǝklini yasap hadiƣa esip ⱪoyƣin; yilan qeⱪiwalƣan ⱨǝrbiri uningƣa ⱪarisila ⱪayta ⱨayatⱪa erixidu, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Musa mistin bir yilan yasitip hadiƣa esip ⱪoydi; wǝ xundaⱪ boldiki, yilan birkimni qeⱪiwalƣan bolsa, u bu mis yilanƣa ⱪarisila, ular ⱨayat ⱪaldi.    ");
INSERT INTO uigpin_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israillar yǝnǝ yolƣa qiⱪip Obotⱪa kelip qedir tikti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Yǝnǝ Obottin yolƣa qiⱪip, Moab zeminining udulida kün qiⱪix tǝrǝptiki Iyǝ-Ibarimƣa kelip qedir tikti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ular yǝnǝ u yǝrdin yolƣa qiⱪip Zǝrǝd jilƣisida qedir tikti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Yǝnǝ u yǝrdin mengip Amoriylarning zeminining qetidin qiⱪip qɵl-bayawandin ɵtüp, eⱪip turƣan Arnon dǝryasining u ⱪetida qedir tikti (qünki Arnon dǝryasi Moabiylarning qegrisi bolup, Moabiylar bilǝn Amoriylarning otturisida idi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","15","Xunga «Pǝrwǝrdigarning jǝngnamisi» degǝn kitabta: — «Sufaⱨdiki Waⱨǝb wǝ dǝrya-wadiliri, Arnon dǝryasi wǝ jilƣilirining yanbaƣirliri, Arning turalƣusiƣiqǝ yetip, Moabning qegrisiƣa qüxidu» dǝp pütülgǝnidi). ");
INSERT INTO uigpin_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Israillar yǝnǝ u yǝrdin mengip Bǝǝrgǝ kǝldi; «Bǝǝr» ⱪuduⱪ degǝn mǝnidǝ bolup, ilgiri Pǝrwǝrdigar Musaƣa: «Sǝn hǝlⱪni yiƣ, Mǝn ularƣa iqidiƣan su berǝy» degǝndǝ xu ⱪuduⱪni kɵzdǝ tutⱪan. ");
INSERT INTO uigpin_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Xu qaƣda Israillar munu nahxini eytixⱪan: — «Aⱨ ⱪuduⱪ, qiⱪsun süyüng bulduⱪlap, Nahxa eytinglar, ⱪuduⱪⱪa beƣixlap: ");
INSERT INTO uigpin_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Bu ⱪuduⱪni ǝmirlǝr, Hǝlⱪning kattiliri ⱪazƣan, Ⱪanun qiⱪarƣuqining sɵzi bilǝn, Ⱨasiliri bilǝn ⱪazƣan». Israillar qɵl-bayawandin yǝnǝ Mattanaⱨⱪa, ");
INSERT INTO uigpin_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mattanaⱨtin Naⱨaliyǝlgǝ, Naⱨaliyǝldin Bamotⱪa, ");
INSERT INTO uigpin_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamottin Moab dalasidiki jilƣiƣa, yǝnǝ qɵl-bayawan tǝrǝpkǝ ⱪarap turƣan Pisgaⱨ teƣining qoⱪⱪisiƣa yetip bardi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israillar Amoriylarning padixaⱨi Siⱨonning aldiƣa ǝlqilǝrni ǝwǝtip:    ");
INSERT INTO uigpin_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","— Bizning ɵz zeminliridin ɵtüweliximizgǝ ijazǝt bǝrgǝyla; biz silining etizliⱪliriƣa wǝ üzümzarliⱪliriƣa kirmǝymiz, ⱪuduⱪliridin sumu iqmǝymiz; tǝwǝliridin ɵtüp kǝtküqǝ «Han yoli»din qiⱪmaymiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Siⱨon Israillarni ɵz qegrisidin ɵtkili ⱪoymayla ⱪalmastin, ǝksiqǝ u Israillar bilǝn soⱪuximǝn dǝp, ɵzining barliⱪ hǝlⱪini yiƣip qɵlgǝ ⱪarap atlandi. U Yaⱨazƣa kelip Israilƣa ⱨujum ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israillar uni ⱪiliq bilǝn qepip ɵltürüp, uning yurtini Arnon dǝryasidin Yabbok dǝryasiƣiqǝ, yǝni Ammoniylarning qegrisiƣiqǝ igilidi; Ammoniylarning qegrisi bolsa bǝk mustǝⱨkǝm idi.    ");
INSERT INTO uigpin_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israillar bu yǝrdiki ⱨǝmmǝ xǝⱨǝrni igilidi ⱨǝm Amoriylarning xǝⱨǝrlirigǝ, yǝni Ⱨǝxbonƣa wǝ uningƣa tǝwǝ barliⱪ yeza-ⱪixlaⱪlarƣimu kirip orunlaxti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Qünki Ⱨǝxbon ǝslidǝ Amoriylarning padixaⱨi Siⱨonning mǝrkiziy xǝⱨiri idi; Siⱨon ǝslidǝ Moabning ilgiriki padixaⱨi bilǝn soⱪuxⱪan, uning Arnon dǝryasiƣiqǝ bolƣan ⱨǝmmǝ zeminini tartiwalƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Xu sǝwǝbtin xairlar: — «Ⱨǝxbonƣa kelinglar! Mana Siⱨonning xǝⱨiri yengiwaxtin ⱪurulsun, Siⱨonning xǝⱨiri mǝⱨkǝm ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Qünki Ⱨǝxbonning ɵzidin qiⱪti bir ot, Siⱨonning xǝⱨiridin bir yalⱪun yalⱪunlap, Yutuwǝtti Moabtiki Ar xǝⱨirini, Arnondiki egiz jaylarning ǝmirlirini. ");
INSERT INTO uigpin_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Way sanga ǝy Moab! Ⱨǝy Kemoxning ümmiti, tügǝxtinglar! Qünki Kemox ɵz oƣullirini ⱪaqⱪunƣa aylandurdi, Ⱪizlirini ǝsirlikkǝ berip, Amoriylarning padixaⱨi Siⱨonƣa tutup bǝrdi!    ");
INSERT INTO uigpin_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Biz ularni yiⱪitiwǝttuⱪ, Ⱨǝxbon taki Dibonƣiqǝ ⱨalak boldi; Biz ⱨǝtta Nofaⱨⱪiqǝ (Nofaⱨtin Mǝdǝbaƣa yetidu) ularning yurtini wǝyran ⱪiliwǝttuⱪ!» — dǝp xeir yezixⱪanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Xuning bilǝn Israillar ǝnǝ xu tǝriⱪidǝ Amoriylarning yurtiƣa orunlaxti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa Yaazǝrni qarlap kelixkǝ qarliƣuqilarni ǝwǝtti; andin Israillar Yaazǝrning yeza-ⱪixlaⱪlirini ixƣal ⱪilip, u yǝrlǝrdiki Amoriylarni yeridin ⱪoƣliwǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Xuningdin keyin Israillar burulup, Baxanning yolini boylap mangdi; Baxanning padixaⱨi Og wǝ uning barliⱪ hǝlⱪi qiⱪip Ədrǝydǝ Israillar bilǝn jǝng ⱪilixⱪa sǝp tüzdi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Pǝrwǝrdigar Musaƣa: — Ⱪorⱪma, Mǝn uni, uning barliⱪ hǝlⱪi ⱨǝm zeminini ⱪolungƣa tapxurimǝn; sǝn uni ilgiri Ⱨǝxbonda turuxluⱪ Amoriylarning padixaⱨi Siⱨonni ⱪilƣandǝk ⱪilisǝn, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Xuning bilǝn ular Og bilǝn uning oƣullirini ⱨǝm barliⱪ hǝlⱪining birini ⱪoymay ⱪirip taxlidi wǝ uning zeminini igilidi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Israillar yǝnǝ yolƣa qiⱪip Moab tüzlǝnglikliridǝ, yǝni Iordan dǝryasining xǝrⱪ tǝripidǝ, Yerihoning udulida qedir tikti. ");
INSERT INTO uigpin_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Israillarning Amoriylarƣa ⱪilƣan ixlirining ⱨǝmmisini Zipporning oƣli Balaⱪ kɵrüp turƣanidi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moabiylar hǝlⱪtin intayin ⱪorⱪuxti, qünki ular bǝk kɵp idi; Moabiylar Israillarning sǝwǝbidin bǝk alaⱪzadǝ bolup ketixti. ");
INSERT INTO uigpin_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moabiylar Midiyan aⱪsaⱪalliriƣa: «Bu bir top adǝm ǝtrapimizdiki ⱨǝmmǝ nǝrsini, huddi kala etizdiki otni yalmiƣandǝk yalmap yǝp ketidiƣan boldi» — deyixti. U qaƣda Zipporning oƣli Balaⱪ Moabning padixaⱨi idi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","U ǝlqilǝrni Beorning oƣli Balaamning aldiƣa, Balaamning ana yurtidiki uluƣ dǝrya boyidiki Petor xǝⱨirigǝ berip, Balaamni qaⱪirip kelixkǝ ǝwǝtip: padixaⱨimiz: — «Ⱪarisila, bir hǝlⱪ Misirdin qiⱪⱪanidi; mana, ular pütün zeminƣa yamrap kǝtti, mana ular bizning udulimizƣa kelip qüxti.    ");
INSERT INTO uigpin_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ular meningdin küqlük bolƣaqⱪa, ǝmdi ɵzliri kelip bu hǝlⱪni mǝn üqün bir ⱪarƣap bǝrgǝn bolsila; bǝlkim mǝn ularni yengip, bu zemindin ⱪoƣlap qiⱪirixim mumkin; qünki ɵzliri kimgǝ bǝht tilisilǝ xuning bǝht ⱪuqidiƣanliⱪini, kimni ⱪarƣisila, xuning ⱪarƣixⱪa ⱪalidiƣanliⱪini bilimǝn» dǝydu, dǝnglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moabning aⱪsaⱪalliri bilǝn Midiyanning aⱪsaⱪalliri ⱪollirida pal selix in’amlirini elip mangdi; ular Balaamning aldiƣa kelip Balaⱪning gǝplirini yǝtküzdi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam ularƣa: — Bügün ahxam muxu yǝrdǝ ⱪonup ⱪelinglar, mǝn Pǝrwǝrdigarning manga ⱪilƣan sɵzi boyiqǝ silǝrgǝ jawap yǝtküzimǝn, — dedi. Xuning bilǝn Moabning xu ǝmirliri Balaamningkidǝ ⱪonup ⱪaldi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Huda Balaamningkigǝ kelip: — Sening bilǝn billǝ turƣan bu adǝmlǝr kim? — dewidi, ");
INSERT INTO uigpin_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam Hudaƣa: — Moab padixaⱨi Zipporning oƣli Balaⱪ ǝlqilǝrni ǝwǝtip manga: ");
INSERT INTO uigpin_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","«Ⱪarisila, Misirdin bir hǝlⱪ qiⱪⱪanidi, ular pütün zeminƣa yamrap kǝtti; bu yǝrgǝ kelip mening üqün ularni ⱪarƣap bǝrsilǝ, xundaⱪ ⱪilsila bǝlkim ularni yengip, bu yǝrdin ⱪoƣliwetǝlixim mumkin» — dedi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Huda Balaamƣa: Sǝn ular bilǝn billǝ barsang bolmaydu, u hǝlⱪni ⱪarƣisangmu bolmaydu, qünki ularƣa bǝht-bǝrikǝt ata ⱪilinƣan, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam ǝtigǝn turup Balaⱪning ǝmǝldarliriƣa: — Silǝr ɵz yurtunglarƣa ⱪaytip ketinglar, qünki Pǝrwǝrdigar mening silǝr bilǝn billǝ beriximƣa ruhsǝt ⱪilmidi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moabning ǝmǝldarliri ⱪopup Balaⱪning yeniƣa kelip uningƣa: — Balaam biz bilǝn billǝ kelixkǝ unimidi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Xuning bilǝn Balaⱪ tehimu kɵp wǝ tehimu mɵtiwǝr ǝmǝldarlarni ǝwǝtti, ");
INSERT INTO uigpin_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ular Balaamning aldiƣa kelip uningƣa: — Zipporning oƣli Balaⱪ mundaⱪ dǝydu: — «Ⱨeqnemǝ silining yenimƣa kelixlirini tosmiƣay; ");
INSERT INTO uigpin_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","qünki mǝn ɵzlirini zor xan-xɵⱨrǝtkǝ igǝ ⱪilimǝn; nemǝ desilǝ maⱪul dǝymǝn; xunga manga ǝxu hǝlⱪni ⱪarƣap bǝrsilila bolidu», — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam Balaⱪning hizmǝtkarliriƣa jawabǝn: — Balaⱪ manga ɵzining altun-kümüxkǝ liⱪ tolƣan ɵz ɵyini bǝrsimu, mǝyli qong yaki kiqik ix ⱪilay, Hudayim Pǝrwǝrdigarning manga buyruƣanliridin ⱨalⱪip ketǝlmǝymǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Silǝrmu bügün ahxam muxu yǝrdǝ ⱪonup ⱪelinglar, Pǝrwǝrdigar yǝnǝ xu ixlar toƣrisida manga nemǝ dǝydikin, xuni bilǝy, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Xu keqisi Huda Balaamningkigǝ kelip uningƣa: — U kixilǝr seni tǝklip ⱪilip kǝlgǝn bolsa, ular bilǝn billǝ barƣin, lekin sǝn Mening sanga eytidiƣanlirim boyiqǝ ix ⱪilixing kerǝk, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam ǝtigǝn turup exikini toⱪup Moabning ǝmirliri bilǝn billǝ mangdi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Huda Balaamning mangƣanliⱪidin ƣǝzǝplǝndi; Pǝrwǝrdigarning Pǝrixtisi uni tosuxⱪa yolda turatti. U xu qaƣda exikigǝ minip ikki ƣulami bilǝn billǝ ketiwatatti. ");
INSERT INTO uigpin_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Mada exǝk Pǝrwǝrdigarning Pǝrixtisining ⱪoliƣa ⱪiliq alƣan ⱨalda yolda turƣanliⱪini kɵrüp, yoldin qiⱪip etizliⱪ bilǝn mengiwidi, Balaam exǝkni yolƣa qiⱪip mengixⱪa dumbalap urdi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Pǝrwǝrdigarning Pǝrixtisi ikki tǝripi tosma tam bilǝn tosulƣan üzümzarliⱪtiki tar bir yolda turuwaldi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Exǝk Pǝrwǝrdigarning Pǝrixtisini kɵrüp, tamƣa ⱪistilip mengip, Balaamning putini tamƣa ⱪistap yarilandurup ⱪoydi; Balaam exǝkni yǝnǝ dumbalidi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Pǝrwǝrdigarning Pǝrixtisi bolsa yǝnǝ aldiƣiraⱪ berip, ong ya solƣa buruluxⱪa bolmaydiƣan tehimu tar bir yǝrdǝ kütüp turdi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Exǝk Pǝrwǝrdigarning Pǝrixtisini kɵrüp mangmay, Balaamning astida yetiwaldi; Balaam ⱪattiⱪ hapa bolup, exǝkni ⱨasisi bilǝn ⱪattiⱪ dumbalap kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Bu qaƣda Pǝrwǝrdigar exǝkkǝ zuwan kirgüzüwidi, exǝk Balaamƣa: — Meni üq ⱪetim dumbalaydiƣanƣa sanga nemǝ yamanliⱪ ⱪiptimǝn? — dewidi, ");
INSERT INTO uigpin_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam exǝkkǝ: — Sǝn meni sǝtlǝxtürdüng, ⱪolumda ⱪiliq bolƣan bolsa idi, seni qepip ɵltürüwetǝttim! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Exǝk Balaamƣa: — Mǝn seningki bolƣinimdin tartip minip kǝlgǝn exiking mǝn ǝmǝsmu? Ilgiri mǝn sanga muxundaⱪ ⱪilix aditim bolup baⱪⱪanmu? — dewidi, — Yaⱪ, — dedi Balaam. ");
INSERT INTO uigpin_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ənǝ xu qaƣda Pǝrwǝrdigar Balaamning kɵzlirini aqti, Balaam Pǝrwǝrdigarning Pǝrixtisining ⱪiliqini ƣilipidin qiⱪirip, yolda turƣanliⱪini kɵrdi; u yǝrgǝ bexini ⱪoyup sǝjdǝ ⱪildi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Pǝrwǝrdigarning Pǝrixtisi uningƣa: — Sǝn exikingni nemǝ üqün üq ⱪetim dumbalaysǝn? Ⱪariƣina, mangƣan yolung Mening nǝzirimdǝ tǝtür bolƣaqⱪa, seni tosuxⱪa qiⱪⱪuqi Mǝn Ɵzüm idim. ");
INSERT INTO uigpin_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Exǝk Meni kɵrüp üq ⱪetim Mening aldimdin burulup kǝtti; ǝgǝr exǝk Mening aldimdin burulup kǝtmigǝn bolsa, Mǝn alliⱪaqan seni ɵltürüp exǝkni tirik ⱪaldurƣan bolattim, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam Pǝrwǝrdigarning Pǝrixtisigǝ: — Mǝn gunaⱨkarmǝn, Ɵzlirining yolda meni tosup turƣanliⱪlirini kɵrmǝptimǝn; mubada ǝmdi mening berixim nǝzǝrliridǝ rǝzil kɵrünsǝ, mǝn ⱪaytip ketǝy, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Pǝrwǝrdigarning Pǝrixtisi Balaamƣa yǝnǝ: — Boptu, bu kixilǝr bilǝn billǝ barƣin, biraⱪ pǝⱪǝt Mǝn sanga degǝn sɵznila degin, — dedi. Xuning bilǝn Balaam Balaⱪning ǝmǝldarliri bilǝn billǝ mangdi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaⱪ Balaamni keliwetiptu dǝp anglap, ⱪarxi elix üqün Moabning Arnon dǝryasining boyidiki, qegrining ǝng bexidiki xǝⱨirigǝ kǝldi: ");
INSERT INTO uigpin_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","— Mǝn silini qaⱪirixⱪa xunqǝ jiddiy ǝlqi ǝwǝtkǝnidim, nemǝ üqün kelixkǝ unimidila? Mǝn silini xan-xɵⱨrǝtkǝ igǝ ⱪilalmayttimmu? — dedi Balaⱪ Balaamƣa. ");
INSERT INTO uigpin_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","— Ⱪarisila, mana kǝldimƣu, ǝmdi mǝn ɵz aldimƣa birnemǝ deyǝlǝyttimmu? — dedi Balaam, — Huda aƣzimƣa nemǝ gǝpni salsa, mǝn xunila dǝymǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam Balaⱪ bilǝn billǝ yolƣa qiⱪip Kiriat-Huzotⱪa kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaⱪ kala, ⱪoylarni soyup ⱪurbanliⱪ ⱪilip, ularning gɵxidin Balaam wǝ uning bilǝn billǝ bolƣan ǝmirlǝrgǝ ǝwǝtip bǝrdi. ");
INSERT INTO uigpin_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Andin Balaⱪ ǝtisi sǝⱨǝrdǝ Balaamni Baalning egiz jayliriƣa elip qiⱪti; u xu yǝrdin Israil hǝlⱪining ǝng qǝttiki bir ⱪismini kɵrdi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam Balaⱪⱪa: — Sili muxu yǝrgǝ manga yǝttǝ ⱪurbangaⱨ yasitip bǝrsilǝ, muxu yǝrgǝ yǝnǝ yǝttǝ buⱪa bilǝn yǝttǝ ⱪoxⱪarmu ⱨazirlap bǝrsilǝ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaⱪ Balaamning deginidǝk ⱪilip bǝrdi; Balaⱪ bilǝn Balaam ikkisi ⱨǝrbir ⱪurbangaⱨⱪa ⱪurbanliⱪ ⱪilixⱪa birdin buⱪa bilǝn birdin ⱪoxⱪar sundi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam Balaⱪⱪa: — Sili ɵz kɵydürmǝ ⱪurbanliⱪlirining yenida tursila, mǝn aldiƣa barimǝn, Pǝrwǝrdigar mening bilǝn kɵrüxüxkǝ kelǝmdikin? U manga nemǝ dǝp kɵrsǝtmǝ bǝrsǝ, mǝn ɵzlirigǝ xuni dǝp berimǝn, — dedi wǝ bir dɵnggǝ qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Huda Balaam bilǝn kɵrüxti; Balaam Hudaƣa: — Mǝn yǝttǝ ⱪurbangaⱨ ⱨazirlattim, ⱨǝrbir ⱪurbangaⱨⱪa ⱪurbanliⱪ süpitidǝ birdin buⱪa bilǝn birdin ⱪoxⱪar sundum, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Pǝrwǝrdigar Balaamning aƣziƣa bir sɵzni selip: — Balaⱪning yeniƣa ⱪaytip berip uningƣa mundaⱪ, mundaⱪ degin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Xuning bilǝn u Balaⱪning yeniƣa ⱪaytip bardi. Mana, u wǝ Moabning barliⱪ ǝmirliri uning kɵydürmǝ ⱪurbanliⱪining yenida turatti. ");
INSERT INTO uigpin_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaam kalam sɵzini aƣziƣa elip mundaⱪ dedi: — Balaⱪ meni Aram degǝn yurttin, Moab xaⱨi Balaⱪ meni mǝxriⱪ taƣliridin elip kelip, Mundaⱪ dedi: — Kǝl, mening üqün Yaⱪupni ⱪarƣiƣin. Kǝl, Israilni rasa bir sɵküp ǝyibligin. ");
INSERT INTO uigpin_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Tǝngri Ɵzi ⱪarƣimiƣan birawni mǝn ⱪandaⱪ ⱪarƣay? Pǝrwǝrdigar Ɵzi sɵküp ǝyiblimigǝn birawni mǝn ⱪandaⱪ sɵküp ǝyiblǝy? ");
INSERT INTO uigpin_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Mǝn ⱪoram taxlarning qoⱪⱪilirida turup uni kɵrmǝktimǝn, Dɵnglǝrdǝ turup uningƣa nǝzǝr salmaⱪtimǝn; Mana, ular yǝkkǝ yaxaydiƣan bir ⱪowm, Ular baxⱪa ⱪowmlarning ⱪatarida sanalmaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yaⱪupning topilirini kim ⱨesablap qiⱪalaydu? Ⱨǝtta Israilning tɵttin birinimu kim sanap qiⱪalaydu? Mening jenim ⱨǝⱪⱪaniyning ɵlümidǝk ɵlsun, Mening ahirim uningkidǝk bolƣay! ");
INSERT INTO uigpin_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaⱪ Balaamƣa ⱪarap: — Sǝn manga nemǝ ⱪiliwatisǝn?! Mǝn seni düxmǝnlirimni ⱪarƣap berixkǝ qaⱪiritⱪan tursam, mana sǝn ǝksiqǝ pütünlǝy ularƣa amǝt tiliding! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","— Pǝrwǝrdigarning aƣzimƣa salƣinini yǝtküzüxkǝ kɵngül ⱪoymisam bolamti? — dǝp jawap bǝrdi Balaam. ");
INSERT INTO uigpin_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaⱪ Balaamƣa: — Mening bilǝn billǝ baxⱪa bir yǝrgǝ barsila, ularni xu yǝrdin kɵrǝlǝyla; biraⱪ ularning ⱨǝmmisini ǝmǝs, ularning qegridiki bir ⱪisminila kɵrǝlǝyla; sili xu yǝrdǝ turup ularni mǝn üqün ⱪarƣap bǝrsilǝ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Xuning bilǝn Balaⱪ Balaamni «Zofimning dalasi»ƣa, Pisgaⱨ teƣining qoⱪⱪisiƣa baxlap berip, xu yǝrdǝ yǝttǝ ⱪurbangaⱨ saldurup, ⱨǝrbir ⱪurbangaⱨⱪa ⱪurbanliⱪ süpitidǝ birdin buⱪa, birdin ⱪoxⱪar sundi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam Balaⱪⱪa: — Sili muxu yǝrdǝ ɵzlirining kɵydürmǝ ⱪurbanliⱪlirining yenida turup tursila, mǝn awu yaⱪⱪa berip kɵrüxüp kelǝy, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Pǝrwǝrdigar Balaam bilǝn kɵrüxüp, uning aƣziƣa bir sɵzni selip: — Sǝn Balaⱪning yeniƣa ⱪaytip uningƣa mundaⱪ, mundaⱪ degin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaam Balaⱪning yeniƣa ⱪaytip kǝlgǝndǝ, mana, u wǝ Moabning barliⱪ ǝmirliri uning kɵydürmǝ ⱪurbanliⱪining yenida turatti. — Pǝrwǝrdigar nemǝ dedi? — dǝp soridi Balaⱪ. ");
INSERT INTO uigpin_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaam kalam sɵzini aƣziƣa elip mundaⱪ dedi: — «Ⱨǝy Balaⱪ, sǝn ⱪopup angliƣin, Aⱨ , Zipporning oƣli, manga ⱪulaⱪ salƣin. ");
INSERT INTO uigpin_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Tǝngri insan ǝmǝstur, U yalƣan eytmaydu, Yaki adǝm balisimu ǝmǝstur, U puxayman ⱪilmaydu. U degǝnikǝn, ixⱪa axurmay ⱪalamdu? U sɵz ⱪilƣanikǝn, wujudⱪa qiⱪarmay ⱪalamdu? ");
INSERT INTO uigpin_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Mana, manga «bǝrikǝtlǝ» dǝp tapxuruldi, U bǝrikǝtligǝnikǝn, buni mǝn yanduralmaymǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","U Yaⱪupta ⱨeq gunaⱨ kɵrmigǝn, Israilda naⱨǝⱪliⱪni uqratmiƣan. Hudasi Pǝrwǝrdigar uning bilǝn billǝ, Padixaⱨning tǝntǝnǝ awazi uning arisididur.    ");
INSERT INTO uigpin_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Tǝngri uni Misirdin elip qiⱪⱪan; Uningda yawa kaliningkidǝk küq bardur.    ");
INSERT INTO uigpin_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Qünki Yaⱪuplarƣa ǝpsun karƣa kǝlmǝydu, Israillarƣimu pal karƣa kǝlmǝydu. Waⱪti-saiti kǝlgǝndǝ, Yaⱪup bilǝn Israil toƣrisida: — «Tǝngri nǝⱪǝdǝr karamǝt ix ⱪilip bǝrgǝn-ⱨǝ!» Dǝp jakarlanmay ⱪalmaydu! ");
INSERT INTO uigpin_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Mana, bu ⱪowm qixi xirdǝk ⱪopidu, Ərkǝk xirdǝk ⱪǝddini ruslaydu; Ɵzi owliƣan owni yemigüqǝ, Ɵltürgǝnlǝrning ⱪenini iqmigüqǝ, Ⱨǝrgiz yatmaydu!». ");
INSERT INTO uigpin_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaⱪ Balaamƣa: — Boldi, sili ularni azraⱪmu ⱪarƣimisila, ularƣa amǝtmu tilimisilǝ! — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam Balaⱪⱪa jawab ⱪilip: — Mǝn siligǝ: — «Pǝrwǝrdigarning manga eytⱪanlirining ⱨǝmmisigǝ ǝmǝl ⱪilmisam bolmaydu» degǝn ǝmǝsmidim? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaⱪ Balaamƣa: — Kǝlsilǝ, mǝn silini baxⱪa bir yǝrgǝ apiray, Hudaning nǝziridǝ sili xu yǝrdǝ turup ularni ⱪarƣaxliri muwapiⱪ tepilarmikin? — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Xuning bilǝn Balaⱪ Balaamni baxlap, qɵl-bayawanƣa ⱪaraydiƣan Peor teƣining qoⱪⱪisiƣa kǝldi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam Balaⱪⱪa: — Sili bu yǝrdǝ manga yǝttǝ ⱪurbangaⱨ saldurup bǝrsilǝ, yǝttǝ buⱪa bilǝn yǝttǝ ⱪoxⱪarmu tǝyyarlap bǝrsilǝ, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaⱪ Balaamning deginidǝk ⱪildi, ⱨǝrbir ⱪurbangaⱨⱪa birdin buⱪa bilǝn birdin ⱪoqⱪar sundi. ");
INSERT INTO uigpin_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaam Pǝrwǝrdigarning Israillarƣa bǝht-bǝrikǝt ata ⱪilixni muwapiⱪ kɵrgǝnlikini kɵrüp yetip, aldinⱪi ikki ⱪetimⱪidikidǝk seⱨir ixlitixkǝ barmidi, bǝlki yüzini qɵl-bayawan tǝrǝpkǝ ⱪaratti. ");
INSERT INTO uigpin_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam bexini kɵtürüp Israillarning ⱪǝbilǝ boyiqǝ qedirlarda olturaⱪlaxⱪanliⱪini kɵrdi, Hudaning Roⱨi uning üstigǝ qüxti. ");
INSERT INTO uigpin_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Xuning bilǝn u aƣziƣa kalam sɵzini elip mundaⱪ dedi: — «Beorning oƣli Balaam yǝtküzidiƣan kalam sɵzi, Kɵzi eqilmiƣan adǝmning eytidiƣan kalam sɵzi, ");
INSERT INTO uigpin_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Yǝni Tǝngrining sɵzlirini angliƣuqi, Ⱨǝmmigǝ Ⱪadirning alamǝt kɵrünüxini kɵrgüqi, Mana ǝmdi kɵzi eqilip düm yiⱪilƣan kixi yǝtküzgǝn kalam sɵzi: — ");
INSERT INTO uigpin_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Aⱨ Yaⱪup, qedirliring nǝⱪǝdǝr güzǝl, Turalƣuliring nǝⱪǝdǝr güzǝl, aⱨ Israil! ");
INSERT INTO uigpin_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Goya kengǝygǝn dǝrya wadiliridǝk, Huddi dǝrya boyidiki baƣlardǝk, Goya Pǝrwǝrdigar tikip ɵstürgǝn ud dǝrǝhliridǝk, Dǝrya boyidiki kedir dǝrǝhliridǝk; ");
INSERT INTO uigpin_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Sular uning soƣiliridin eⱪip qiⱪidu, Əwladliri süyi mol jaylarda bolidu; Padixaⱨi Gogdin exip ketidu, Uning padixaⱨliⱪi üstün ⱪilinip güllinidu.    ");
INSERT INTO uigpin_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Tǝngri uni Misirdin elip qiⱪⱪan, Uningda yawa buⱪining küqi bardur; Düxmǝn ǝllǝrni u yǝp ketidu, Ustihanlirini ezip taxlaydu, Oⱪya etip ularni texip taxlaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","U baƣirlap yatsa, ǝrkǝk xirdǝk, Yatsa ⱨǝm qixi xirdǝk, Kim uni ⱪozƣitixⱪa petinar? Kim sanga bǝht-bǝrikǝt tilisǝ, bǝht-bǝrikǝt tapidu. Kim seni ⱪarƣisa, ⱪarƣixⱪa ketidu». ");
INSERT INTO uigpin_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaⱪ Balaamƣa aqqiⱪlinip, ⱪolini ⱪoliƣa urup kǝtti; Balaⱪ Balaamƣa: — Mǝn silini düxminimni ⱪarƣap berixkǝ ⱪiqⱪirtⱪanidim wǝ mana, sili üq ⱪetim pütünlǝy ularƣa amǝt tilidilǝ! ");
INSERT INTO uigpin_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Əmdi tezdin yurtliriƣa ⱪeqip kǝtsilǝ; mǝn ǝslidǝ silining izzǝt-ⱨɵrmǝtlirini katta ⱪilay degǝnidim, mana Pǝrwǝrdigar silini bu katta izzǝt-ⱨɵrmǝtkǝ nail boluxtin tosup ⱪoydi, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam Balaⱪⱪa: — Mǝn ǝslidǝ ɵzlirining ǝlqilirigǝ: ");
INSERT INTO uigpin_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","«Balaⱪ manga ɵzining altun-kümüxkǝ liⱪ tolƣan ɵz ɵyini bǝrsimu, Pǝrwǝrdigarning buyruƣinidin ⱨalⱪip, ɵz mǝylimqǝ yahxi-yaman ix ⱪilalmaymǝn; Pǝrwǝrdigar manga nemǝ desǝ, mǝn xuni dǝymǝn» degǝn ǝmǝsmidim? ");
INSERT INTO uigpin_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Əmdi mǝn ɵz hǝlⱪimgǝ ⱪaytimǝn; kǝlsilǝ, mǝn ɵzlirigǝ bu hǝlⱪning künlǝrning ahirida silining hǝlⱪlirigǝ ⱪandaⱪ muamilǝ ⱪilidiƣanliⱪini eytip berǝy, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","U kalam sɵzini aƣziƣa elip mundaⱪ dedi: — Beorning oƣli Balaam yǝtküzidiƣan kalam sɵzi, Kɵzliri eqilmiƣan kixi eytⱪan kalam sɵzi, ");
INSERT INTO uigpin_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Tǝngrining sɵzlirini angliƣuqi, Ⱨǝmmidin Aliyning wǝⱨiylirini bilgüqi, Ⱨǝmmigǝ Ⱪadirning alamǝt kɵrünüxini kɵrgüqi, Mana ǝmdi kɵzi eqilƣan düm yiⱪiliƣan kixi yǝtküzidiƣan kalam sɵzi: — ");
INSERT INTO uigpin_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Mǝn Uni kɵrimǝn, lekin ⱨazir ǝmǝs; Mǝn Uningƣa ⱪaraymǝn, lekin yeⱪin yǝrdin ǝmǝs; Yaⱪuptin qiⱪar bir yultuz, Kɵtürülǝr Israildin bir xaⱨanǝ ⱨasa; Qeⱪiwetǝr u Moabning qekisini, Barliⱪ Xetlǝrning bexini yanjiydu.    ");
INSERT INTO uigpin_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom uningƣa tǝwǝ bolidu, Yǝnǝ tehi düxmini Seirlar uningƣa tǝwǝ bolidu; Israil bolsa baturluⱪ ⱪilidu. ");
INSERT INTO uigpin_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yaⱪuptin qiⱪⱪan biri sǝltǝnǝt süridu, Xǝⱨǝrdǝ ⱪalƣan ⱨǝmmǝylǝnni yoⱪitidu».    ");
INSERT INTO uigpin_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Andin Balaam Amalǝkni kɵrüp, mundaⱪ kalam sɵzini eytti: — «Amalǝk idi ǝsli ǝllǝr arisida bax, Əmdi ⱨalakǝttur tǝⱪdir-ⱪismiti». ");
INSERT INTO uigpin_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Andin Balaam Keniylǝrni kɵrüp mundaⱪ kalam sɵzini eytti: — «Sening makaning mustǝⱨkǝm bolup, Qanggang ⱪoram tax iqidǝ bolsimu, ");
INSERT INTO uigpin_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Lekin silǝr Keniylǝr ⱨalak ⱪilinip turisilǝr; Taki Axur silǝrni tutⱪun ⱪilip kǝtküqǝ». ");
INSERT INTO uigpin_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaam yǝnǝ kalam sɵzini dawam ⱪilip mundaⱪ dedi: — «Aⱨ , Tǝngri bu ixlarni ⱪilƣan qeƣida, Kim tirik ⱪelixⱪa ⱪadir bolar? ");
INSERT INTO uigpin_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kittim tǝrǝpliridin kemilǝr kelip, Zulum-zǝhmǝt salidu Axurƣa, Zulum-zǝhmǝt salidu Ebǝrgǝ; Lekin Kittimdin kǝlgüqi ɵzimu ⱨalakǝtkǝ yüzlinǝr». ");
INSERT INTO uigpin_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Xuning bilǝn Balaam ornidin ⱪopup ɵz yurtiƣa ⱪaytti; Balaⱪmu ɵz yoliƣa mangdi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israillar Xittimda turƣan mǝzgildǝ, hǝlⱪ Moab ⱪizliri bilǝn buzuⱪluⱪ ⱪilixⱪa berilip kǝtti. ");
INSERT INTO uigpin_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","U ⱪizlar Israillarni ɵz ilaⱨliriƣa atalƣan ⱪurbanliⱪlarƣa ⱪatnixixⱪa qaⱪirdi; Israillarmu ⱪurbanliⱪlardin yǝydiƣan, ularning ilaⱨliriƣa birliktǝ qoⱪunidiƣan boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israillar Baal-Peor bilǝn ǝnǝ xu tǝriⱪidǝ baƣlinip kǝtkǝnliki üqün, Pǝrwǝrdigarning Israillarƣa aqqiⱪi ⱪozƣaldi.    ");
INSERT INTO uigpin_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Pǝrwǝrdigar Musaƣa: — Pǝrwǝrdigarning ⱪattiⱪ ƣǝzipi Israillarƣa qüxmisun üqün, hǝlⱪning ǝmirlirining ⱨǝmmisini tutup, ularni Mening aldimda aptapta esip ⱪoyƣin, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Xuning bilǝn Musa Israilning soraⱪqiliriƣa: — Silǝr berip ⱨǝrbiringlar ɵzünglarning Baal-Peor bilǝn baƣlinip kǝtkǝn adǝmlirini ɵltürüwetinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Wǝ Musa pütkül Israil jamaiti bilǝn jamaǝt qedirining dǝrwazisi aldida yiƣa-zar ⱪilip turuwatⱪanda, mana Israillardin birǝylǝn kelip ularning kɵz aldidila Midiyaniy bir ⱪizni ɵz ⱪerindaxlirining yeniƣa elip mangdi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kaⱨin Ⱨarunning nǝwrisi, Əliazarning oƣli Finiⱨas buni kɵrüp, jamaǝt iqidin ⱪopti-dǝ, ⱪoliƣa nǝyzǝ elip, ");
INSERT INTO uigpin_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ⱨeliⱪi Israil adǝmning arⱪisidin qedirning iqkirigǝ kirip, ⱪiz bilǝn ikkisining ⱪarniƣa nǝyzǝ tiⱪiwǝtti. Israillar arisida tarⱪalƣan waba ǝnǝ xu qaƣdila tohtidi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Xu qaƣda waba tegip ɵlgǝnlǝr jǝmiy yigirmǝ tɵt ming adǝmgǝ yǝtkǝnidi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Andin Pǝrwǝrdigar Musaƣa mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","— «Kaⱨin Ⱨarunning nǝwrisi, Əliazarning oƣli Finiⱨas Meni dǝp wapasizliⱪⱪa bolƣan ⱨǝsitimni ɵz ⱨǝsiti bilip, Mening Israillarƣa bolƣan ƣǝzipimni yandurdi. Xunga gǝrqǝ Mǝn wapasizliⱪⱪa bolƣan ⱨǝsitimdin ƣǝzǝplǝngǝn bolsammu, Israillarni yoⱪitiwǝtmidim. ");
INSERT INTO uigpin_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Xunga sǝn: — «Mana, Mǝn uningƣa ɵz aman-hatirjǝmlik ǝⱨdǝmni tǝⱪdim ⱪilimǝn! ");
INSERT INTO uigpin_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Bu ǝⱨdǝ uningƣa wǝ uning ǝwladliriƣa tǝwǝ bolidiƣan mǝnggülük kaⱨinliⱪ ǝⱨdisi bolidu, qünki u ɵz Hudasini dǝp wapasizliⱪⱪa ⱨǝsǝt ⱪilip, Israillar üqün kǝfarǝt kǝltürdi» — dǝp jakarliƣin». ");
INSERT INTO uigpin_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ɵltürülgǝn yǝni ⱨeliⱪi Midiyaniy ⱪiz bilǝn billǝ ɵltürülgǝn Israil adǝmning ismi Zimri bolup, Saluning oƣli, Ximeon ⱪǝbilisidiki bir jǝmǝtning ǝmiri idi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ɵltürülgǝn Midiyaniy ⱪizning ismi Kozbi bolup, Zurning ⱪizi idi; Zur bolsa Midiyaniy bir ⱪǝbilining baxliⱪi idi. ");
INSERT INTO uigpin_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Pǝrwǝrdigar Musaƣa: — ");
INSERT INTO uigpin_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Sǝn Midiyaniylarƣa aram bǝrmǝy zǝrbǝ bǝrgin; ");
INSERT INTO uigpin_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","19","Qünki ular ⱨiylǝ-mikir ixlitip silǝrgǝ aram bǝrmigǝn; Peordiki ixta, xundaⱪla ularning singlisi bolƣan Midiyanning bir ǝmirining ⱪizi Kozbining ixidimu ⱨiylǝ-mikir ixlitip silǝrni azdurƣan, — dedi. Kozbi waba tarⱪalƣan künidǝ Peordiki ix sǝwǝbidin ɵltürüldi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Wabadin keyin Pǝrwǝrdigar Musa bilǝn Ⱨarunning oƣli Əliazarƣa sɵz ⱪilip: — ");
INSERT INTO uigpin_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Silǝr pütkül Israillarning jamaiti iqidǝ yigirmǝ yaxtin axⱪan, jǝnggǝ qiⱪalaydiƣanlarni ata jǝmǝti boyiqǝ ⱨesablap sanaⱪtin ɵtküzünglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Xuning bilǝn Musa bilǝn kaⱨin Əliazar Moab tüzlǝnglikliridǝ, yǝni Yerihoning yenidiki Iordan dǝryasining boyida Israillar bilǝn sɵzlixip ularƣa: ");
INSERT INTO uigpin_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Pǝrwǝrdigarning Musa wǝ Misirdin qiⱪⱪan Israillarƣa buyruƣini boyiqǝ, silǝrdin yigirmǝ yaxtin axⱪanlarning ⱨǝmmisi tizimlinip sanaⱪtin ɵtküzülüxi kerǝk» dǝp uⱪturdi. Tizimlitilƣan sanlar mundaⱪ boldi: —    ");
INSERT INTO uigpin_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Israilning tunji oƣli Rubǝn idi. Rubǝnning ǝwladliri, yǝni Ⱨanuⱪning nǝslidin bolƣan Ⱨanuⱪ jǝmǝti; Palluning nǝslidin bolƣan Pallu jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Ⱨǝzron nǝslidin bolƣan Ⱨǝzron jǝmǝti; Karmi nǝslidin bolƣan Karmi jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Bular Rubǝnning jǝmǝtliri bolup, ulardin sanaⱪtin ɵtküzülgini jǝmiy ⱪiriⱪ üq ming yǝttǝ yüz ottuz kixi boldi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palluning oƣli Eliab; ");
INSERT INTO uigpin_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliabning oƣulliri Nimuǝl, Datan, Abiram idi. Datan bilǝn Abiram ǝslidǝ jamaǝt iqidin qaⱪirilƣan mɵtiwǝrlǝr bolsimu, Koraⱨ guruⱨidikilǝr Pǝrwǝrdigar bilǝn takallaxⱪanda, ular bilǝn birlixip Musa wǝ Ⱨarun bilǝn takallaxⱪanidi.    ");
INSERT INTO uigpin_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Yǝr aƣzini eqip ularni Koraⱨ bilǝn birgǝ yutup kǝtkǝn; xu qaƣda Koraⱨ guruⱨidikilǝrning ⱨǝmmisi ɵlgǝn; baxⱪilarƣa ibrǝt bolsun dǝp, ot uning ikki yüz ǝllik adimini yutup kǝtkǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Lekin Koraⱨning ǝwladliri ɵlüp kǝtmigǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ximeonning ǝwladliri, jǝmǝt boyiqǝ, Nǝmuǝlning nǝslidin bolƣan Nǝmuǝl jǝmǝti; Yamin nǝslidin bolƣan Yamin jǝmǝti; Yaⱪin nǝslidin bolƣan Yaⱪin jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zǝraⱨ nǝslidin bolƣan Zǝraⱨ jǝmǝti; Saul nǝslidin bolƣan Saul jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Bular Ximeonning jǝmǝtliri bolup, jǝmiy yigirmǝ ikki ming ikki yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad ⱪǝbilisidin, jǝmǝt boyiqǝ, Zǝfon nǝslidin bolƣan Zǝfon jǝmǝti; Ⱨaggi nǝslidin bolƣan Ⱨaggi jǝmǝti; xuni nǝslidin bolƣan xuni jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni nǝslidin bolƣan Ozni jǝmǝti; eri nǝslidin bolƣan eri jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod nǝslidin bolƣan Arod jǝmǝti; Arǝli nǝslidin bolƣan Arǝli jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Bular Gad ǝwladlirining jǝmǝtliri bolup, ular jǝmǝtliri boyiqǝ sanaⱪtin ɵtküzülgǝndǝ jǝmiy ⱪiriⱪ ming bǝx yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yǝⱨudaning oƣulliri Er bilǝn Onan idi; bu ikkisi Ⱪanaan zeminida ɵlüp kǝtkǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yǝⱨudaning ǝwladliri, jǝmǝti boyiqǝ, Xilaⱨning nǝslidin bolƣan Xilaⱨ jǝmǝti; Pǝrǝzning nǝslidin bolƣan Pǝrǝz jǝmǝti; Zǝraⱨning nǝslidin bolƣan Zǝraⱨ jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Pǝrǝzning ǝwladliri Ⱨǝzronning nǝslidin bolƣan Ⱨǝzron jǝmǝti; Ⱨamulning nǝslidin bolƣan Ⱨamul jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Bular Yǝⱨudaning jǝmǝtliri bolup, ular jǝmǝt boyiqǝ sanaⱪtin ɵtküzülgǝndǝ jǝmiy yǝtmix altǝ ming bǝx yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Issakarning ǝwladliri, jǝmǝt boyiqǝ, Tolaning nǝslidin bolƣan Tola jǝmǝti; Puaⱨning nǝslidin bolƣan Puaⱨ jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yaxubning nǝslidin bolƣan Yaxub jǝmǝti; Ximronning nǝslidin bolƣan Ximron jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Bular Issakarning jǝmǝtliri bolup, ular jǝmǝt boyiqǝ sanaⱪtin ɵtküzülgǝndǝ jǝmiy atmix tɵt ming üq yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zǝbulunning ǝwladliri, jǝmǝti boyiqǝ, Sǝrǝdning nǝslidin bolƣan Sǝrǝd jǝmǝti; Elon nǝslidin bolƣan Elon jǝmǝti; Jaⱨliyǝlning nǝslidin bolƣan Jaⱨliyǝl jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Bular Zǝbulunning jǝmǝtliri bolup, ular jǝmǝt boyiqǝ sanaⱪtin ɵtküzülgǝndǝ jǝmiy atmix ming bǝx yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yüsüpning oƣulliri: — jǝmǝt boyiqǝ, Manassǝⱨ bilǝn Əfraim idi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manassǝⱨning ǝwladliri: — Makirning nǝslidin bolƣan Makir jǝmǝti (Makirdin Gilead tɵrǝlgǝn), Gileadning nǝslidin bolƣan Gilead jǝmǝti idi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Tɵwǝndikilǝr Gileadning ǝwladliri: — Yǝǝzǝrning nǝslidin bolƣan Yǝǝzǝr jǝmǝti; Ⱨǝlǝkning nǝslidin bolƣan Ⱨǝlǝk jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriyǝlning nǝslidin bolƣan Asriyǝl jǝmǝti; Xǝkǝmning nǝslidin bolƣan Xǝkǝm jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Xǝmidaning nǝslidin bolƣan Xǝmida jǝmǝti; Ⱨǝfǝrning nǝslidin bolƣan Ⱨǝfǝr jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Ⱨǝfǝrning oƣli Zǝlofiⱨad oƣul pǝrzǝnt kɵrmǝy ⱪiz pǝrzǝnt kɵrgǝn; Zǝlofiⱨadning ⱪizlirining ismi Maⱨlaⱨ, Noaⱨ, Ⱨoglaⱨ, Milkaⱨ, Tirzaⱨ idi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Bular Manassǝⱨning jǝmǝtliri bolup, sanaⱪtin ɵtküzülgǝndǝ jǝmiy ǝllik ikki ming yǝttǝ yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Tɵwǝndikilǝr Əfraimning ǝwladliri, jǝmǝti boyiqǝ: — Xutilaⱨning nǝslidin bolƣan Xutilaⱨ jǝmǝti; Bǝkǝrning nǝslidin bolƣan Bǝkǝr jǝmǝti; Taⱨanning nǝslidin bolƣan Taⱨan jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Xutilaning ǝwladliri Eranning nǝslidin bolƣan Eran jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Mana bular Əfraim ǝwladlirining jǝmǝtliri bolup, ⱨǝrⱪaysi jǝmǝtlǝr boyiqǝ sanaⱪtin ɵtküzülgǝndǝ jǝmiy ottuz ikki ming bǝx yüz adǝm qiⱪti. Jǝmǝtliri boyiqǝ, ularning ⱨǝmmisi Yüsüpning ǝwladliri idi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Binyaminning ǝwladliri, jǝmǝti boyiqǝ, Belaning nǝslidin bolƣan Bela jǝmǝti; Axbǝlning nǝslidin bolƣan Axbǝl jǝmǝti; Aⱨiramning nǝslidin bolƣan Aⱨiram jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Xǝfufamning nǝslidin bolƣan Xufam jǝmǝti; Ⱨufamning nǝslidin bolƣan Ⱨufam jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ard bilǝn Naaman Belaning oƣulliri idi; Ardning nǝslidin bolƣan Ard jǝmǝti; Naamanning nǝslidin bolƣan Naaman jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Bular Binyaminning ǝwladliri bolup, jǝmǝt boyiqǝ sanaⱪtin ɵtküzülgǝndǝ jǝmiy ⱪiriⱪ bǝx ming altǝ yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Tɵwǝndikilǝr Danning ǝwladliri bolup, jǝmǝt boyiqǝ, Xuⱨamning nǝslidin bolƣan Xuⱨam jǝmǝti; jǝmǝt boyiqǝ bular Danning jǝmǝtliri idi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Xuⱨamning ⱨǝmmǝ jǝmǝti sanaⱪtin ɵtküzülgǝndǝ jǝmiy atmix tɵt ming tɵt yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Axirning ǝwladliri, jǝmǝt boyiqǝ, Yimnaⱨning nǝslidin bolƣan Yimnaⱨ jǝmǝti; Yixwining nǝslidin bolƣan Yixwi jǝmǝti; Beriyaⱨning nǝslidin bolƣan Beriyaⱨ jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriyaⱨning ǝwladliri, jǝmǝt boyiqǝ, Ⱨǝbǝrning nǝslidin bolƣan Ⱨǝbǝr jǝmǝti; Malkiǝlning nǝslidin bolƣan Malkiǝl jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Axirning ⱪizining ismi Seraⱨ idi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Bular Axir ǝwladlirining jǝmǝtliri bolup, ular jǝmǝt boyiqǝ sanaⱪtin ɵtküzülgǝndǝ jǝmiy ǝllik üq ming tɵt yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naftalining ǝwladliri, jǝmǝt boyiqǝ, Yaⱨziǝlning nǝslidin bolƣan Yaⱨziǝl jǝmǝti; Gunining nǝslidin bolƣan Guni jǝmǝti; ");
INSERT INTO uigpin_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yǝzǝrning nǝslidin bolƣan Yǝzǝr jǝmǝti; Xillǝmning nǝslidin bolƣan Xillǝm jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Bular Naftalining jǝmǝtliri bolup, jǝmǝt boyiqǝ sanaⱪtin ɵtküzülgǝndǝ jǝmiy ⱪiriⱪ bǝx ming tɵt yüz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Yuⱪiriⱪilar Israillardin sanaⱪtin ɵtküzülgǝnlǝr bolup, jǝmiy altǝ yüz bir ming yǝttǝ yüz ottuz adǝm qiⱪti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Zemin muxularƣa royhǝtkǝ elinƣan san boyiqǝ miras ⱪilip tǝⱪsim ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Mirasni adǝm sani kɵp ⱪǝbililǝrgǝ kɵprǝk, adǝm sani az ⱪǝbililǝrgǝ azraⱪ bɵl; miras royhǝttin ɵtküzülgǝn adǝm saniƣa ⱪarap ⱨǝrbir adǝmgǝ bɵlüp berilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ⱨalbuki, zemin qǝk taxlinix yoli bilǝn bɵlünsun; ular mirasⱪa ɵzlirining ata jǝmǝt-ⱪǝbilisining nami boyiqǝ warisliⱪ ⱪilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Miras ularƣa qǝk taxlax yoli bilǝn adǝm sanining az-kɵplükigǝ ⱪarap ⱨǝrbir ailǝ-jǝmǝtkǝ bɵlüp berilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Tɵwǝndikilǝr ata jǝmǝt boyiqǝ sanaⱪtin ɵtküzülgǝn Lawiylar: — Gǝrxonning nǝslidin bolƣan Gǝrxon jǝmǝti; Koⱨatning nǝslidin bolƣan Koⱨat jǝmǝti; Mǝrarining nǝslidin bolƣan Mǝrari jǝmǝti. ");
INSERT INTO uigpin_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Bular Lawiylarning jǝmǝtliri: — Libni jǝmǝti, Ⱨebron jǝmǝti, Maⱨli jǝmǝti, Muxi jǝmǝti, Koraⱨ jǝmǝti. Koⱨattin Amram tɵrǝlgǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amramning ayalining ismi Yokǝbǝd bolup, Lawiyning Misirda tuƣulƣan ⱪizi idi; u Amramƣa Ⱨarun, Musa wǝ ularning aqisi Mǝryǝmni tuƣup bǝrgǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Ⱨarundin Nadab, Abiⱨu, Əliazar, Itamar tɵrǝlgǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Lekin Nadab bilǝn Abiⱨu Pǝrwǝrdigarning aldiƣa ƣǝyriy bir otni sunƣanda ɵlüp kǝtkǝn.    ");
INSERT INTO uigpin_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Lawiylar iqidǝ bir ayliⱪtin axⱪan barliⱪ ǝrkǝklǝr sanaⱪtin ɵtküzülgǝndǝ jǝmiy yigirmǝ üq ming adǝm qiⱪti. Ular Israillar iqidǝ sanaⱪtin ɵtküzülmigǝn, qünki ularƣa Israillar iqidǝ ⱨeqⱪandaⱪ miras zemin bɵlüp berilmigǝn. ");
INSERT INTO uigpin_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Yuⱪirida eytilƣan adǝmlǝr Moab tüzlǝnglikliridǝ, Yerihoning udulidiki Iordan dǝryasi boyida Musa bilǝn kaⱨin Əliazar tǝripidin sanaⱪtin ɵtküzülgǝn Israillardur. ");
INSERT INTO uigpin_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Biraⱪ bu adǝmlǝr iqidǝ Musa bilǝn kaⱨin Ⱨarun ilgiri Sinay qɵlidǝ sanaⱪtin ɵtküzgǝndǝ sanaⱪtin ɵtküzülgǝn birmu adǝm yoⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Qünki Pǝrwǝrdigar ular toƣrisida: «Ular qɵldǝ ɵlmǝy ⱪalmaydu» dǝp eytⱪanidi. Xunga, Yǝfunnǝⱨning oƣli Kalǝb bilǝn Nunning oƣli Yǝxuadin baxⱪa birimu ⱪalmiƣan. ");
INSERT INTO uigpin_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Yüsüpning oƣli Manassǝⱨning nǝslidin bolƣan jǝmǝtlǝr iqidǝ Manassǝⱨning qǝwrisi, Makirning ǝwrisi, Gileadning nǝwrisi, Ⱨǝfǝrning oƣli Zǝlofiⱨadning ⱪizliri bolup, ularning ismi Maⱨlaⱨ, Noaⱨ, Ⱨoglaⱨ, Milkaⱨ, wǝ Tirzaⱨ idi. ");
INSERT INTO uigpin_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ular jamaǝt qedirining dǝrwazisi aldiƣa kelip, Musa bilǝn kaⱨin Əliazar wǝ ǝmirlǝr bilǝn pütkül jamaǝtning aldida turup: ");
INSERT INTO uigpin_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","— Bizning atimiz qɵldǝ ɵlüp kǝtkǝn; u u yǝrdǝ Pǝrwǝrdigarƣa ⱨujum ⱪilƣili yiƣilƣanlardin ǝmǝs, yǝni Koraⱨ guruⱨidikilǝrdin ǝmǝs; u bǝlki ɵz gunaⱨi iqidǝ ɵlgǝn, wǝ uning oƣul pǝrzǝnti yoⱪ idi. ");
INSERT INTO uigpin_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Nemǝ üqün atimizning oƣli yoⱪluⱪi sǝwǝblik uning nami uning jǝmǝtidin ɵqürüwetilidu? Ɵzlirining bizgǝ atimizning ⱪerindaxliri ⱪatarida miras bɵlüp berixlirini ɵtünimiz, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa ularning bu ixini Pǝrwǝrdigarning aldiƣa ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Zǝlofiⱨadning ⱪizlirining eytⱪini durus, sǝn qoⱪum ularƣa atisining ⱪerindaxliri ⱪatarida miras bǝr; ularning atisining mirasini ularƣa ɵtküzüp bǝrgin. ");
INSERT INTO uigpin_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Sǝn Israillarƣa eytⱪin: «Bir adǝm ɵlüp kǝtkǝn qaƣda uning oƣli bolmisa, undaⱪta silǝr uning mirasini ⱪiziƣa ɵtküzüp beringlar. ");
INSERT INTO uigpin_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ⱪizi bolmisa, mirasini ⱪerindaxliriƣa beringlar. ");
INSERT INTO uigpin_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ⱪerindaxliri bolmisa, mirasini ata jǝmǝt taƣiliriƣa beringlar. ");
INSERT INTO uigpin_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Əgǝr uning atisining ⱪerindaxliri bolmisa, undaⱪta uning mirasini uning jǝmǝtidiki ǝng yeⱪin bir tuƣⱪiniƣa beringlar; u adǝm uning mirasiƣa igǝ bolsun. Bu Pǝrwǝrdigar Musaƣa buyruƣandǝk, Israillarƣa qüxürülgǝn ⱨɵküm, ⱪanun-bǝlgilimǝ bolup ⱪalsun». ");
INSERT INTO uigpin_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Pǝrwǝrdigar Musaƣa: — Sǝn mawu Abarim teƣiƣa qiⱪip, Mǝn Israillarƣa tǝⱪdim ⱪilƣan zeminƣa ⱪarap baⱪ.    ");
INSERT INTO uigpin_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Kɵrüp bolƣandin keyin sǝnmu akang Ⱨarunƣa ohxax ɵz hǝlⱪliringgǝ ⱪoxulisǝn.    ");
INSERT INTO uigpin_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Qünki Zin qɵlidǝ, jamaǝt jedǝl qiⱪarƣan qaƣda, ikkinglar Mening buyruⱪimƣa asiyliⱪ ⱪilip, suning ixida (Zin qɵlidǝ, Ⱪadǝxtiki «Mǝribaⱨ suliri» degǝn jayda) Meni jamaǝtning aldida muⱪǝddǝs dǝp ⱨɵrmǝtlimidinglar, — dedi. ");
INSERT INTO uigpin_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa Pǝrwǝrdigarƣa sɵz ⱪilip: ");
INSERT INTO uigpin_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","— I Pǝrwǝrdigar, barliⱪ ǝt igilirining roⱨlirining Hudasi, Ɵz jamaitining padiqisiz padidǝk bolup ⱪelixining aldini elix üqün jamaǝtni idarǝ ⱪilidiƣan, ularning aldiƣa kirip qiⱪalaydiƣan, ularni baxlap mangalaydiƣan bir adǝmni tiklǝp berixingni tilǝymǝn, — dedi.    ");
INSERT INTO uigpin_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Sǝn Nunning oƣli Yǝxuani talliƣin, — dedi Pǝrwǝrdigar Musaƣa, — Uningda Roⱨim bar, sǝn ⱪolungni uning bexiƣa ⱪoy,    ");
INSERT INTO uigpin_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","uni kaⱨin Əliazar wǝ barliⱪ jamaǝtning aldida turƣuzup wǝzipigǝ ⱪoy. ");
INSERT INTO uigpin_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Sǝn pütkül Israil jamaiti uning gepigǝ kirixi üqün ɵzüngning izzǝt-xɵⱨritingdin bir ⱪismini uningƣa bǝrgin. ");
INSERT INTO uigpin_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","U kaⱨin Əliazarning aldida tursun, Əliazar urimning ⱨɵkümini wasitǝ ⱪilip turup, Pǝrwǝrdigarning ⱨuzurida uning üqün yol sorisun; Israil hǝlⱪi, yǝni pütkül jamaǝt uning buyruⱪi bilǝn qiⱪidu, uning buyruⱪi bilǝn kirixi kerǝk.    ");
INSERT INTO uigpin_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Xuning bilǝn Musa Pǝrwǝrdigarning buyruⱪi boyiqǝ ix kɵrüp, Yǝxuani baxlap kelip, kaⱨin Əliazarning wǝ barliⱪ jamaǝtning aldida turƣuzdi; ");
INSERT INTO uigpin_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Əliazar ⱪolini uning bexiƣa ⱪoyup, uni Pǝrwǝrdigarning Musaning wasitisi bilǝn buyruƣinidǝk wǝzipigǝ ⱪoydi. ");
INSERT INTO uigpin_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Pǝrwǝrdigar Musaƣa sɵz ⱪilip mundaⱪ dedi: — ");
INSERT INTO uigpin_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Sǝn Israillarƣa buyrup: — «Manga sunulƣan ⱨǝdiyǝ-ⱪurbanliⱪlarni, yǝni Manga ozuⱪ bolidiƣan, huxbuy kǝltüridiƣan otta sunulidiƣan ⱨǝdiyǝ-ⱪurbanliⱪlarni bolsa, silǝr ⱨǝrbirini bekitilgǝn ⱪǝrǝlidǝ sunuxⱪa kɵngül ⱪoyunglar» — degin. ");
INSERT INTO uigpin_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Sǝn ularƣa yǝnǝ: «Silǝrning Pǝrwǝrdigarƣa atap otta sunidiƣan kɵydürmǝ ⱪurbanliⱪinglar mundaⱪ bolidu: — ⱨǝr küni bejirim bir yaxliⱪ ǝrkǝk ⱪozidin ikkini daimiy kɵydürmǝ ⱪurbanliⱪ ⱪilinglar. ");
INSERT INTO uigpin_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ətigini birni, gugumda birni sununglar; ");
INSERT INTO uigpin_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","yǝnǝ tɵttin bir ⱨindin soⱪup qiⱪirilƣan zǝytun meyi ilǝxtürülgǝn esil undin ondin bir ǝfaⱨni axliⱪ ⱨǝdiyǝsi süpitidǝ sununglar.    ");
INSERT INTO uigpin_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Sinay teƣida bǝlgilǝngǝn, Pǝrwǝrdigarƣa atap huxbuy qiⱪarsun dǝp, otta sunulidiƣan daimiy kɵydürmǝ ⱪurbanliⱪ mana xudur. ");
INSERT INTO uigpin_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ⱨǝrbir ⱪoza üqün uningƣa ⱪoxulidiƣan xarab ⱨǝdiyǝsi tɵttin bir ⱨin xarab bolidu; eqitma iqimlik bolƣan xarab ⱨǝdiyǝsi muⱪǝddǝs jayda Pǝrwǝrdigarƣa sunup tɵkülsun. ");
INSERT INTO uigpin_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Sǝn ikkinqi bir ⱪozini gugumda sunƣin; uni ǝtigǝnkidǝk axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi bilǝn ⱪoxup sunƣin; u huxbuy kǝltürüx üqün Pǝrwǝrdigarƣa atap otta sunulidiƣan kɵydürmǝ ⱪurbanliⱪ bolidu. ");
INSERT INTO uigpin_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","— Xabat küni bejirim bir yaxliⱪ ikki ǝrkǝk ⱪoza sunulsun; uningƣa ⱪoxup zǝytun meyi ilǝxtürülgǝn esil undin ǝfaⱨning ondin ikkisi axliⱪ ⱨǝdiyǝsi süpitidǝ sunulsun wǝ xarab ⱨǝdiyǝsi sunulsun; ");
INSERT INTO uigpin_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","bu ⱨǝrbir xabat künidǝ sunulidiƣan xabat künidiki ⱪurbanliⱪtur; uning bilǝn daimiy kɵydürmǝ ⱪurbanliⱪ wǝ ⱪoxumqǝ sunulidiƣan xarab ⱨǝdiyǝsi billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","— Ⱨǝr ayning birinqi küni Pǝrwǝrdigarƣa atilidiƣan kɵydürmǝ ⱪurbanliⱪ sununglar; yǝni ikki yax torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ bejirim yǝttǝ ǝrkǝk ⱪozini sununglar. ");
INSERT INTO uigpin_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Ⱨǝr torpaⱪ bexiƣa zǝytun meyi ilǝxtürülgǝn esil undin ǝfaⱨning ondin üqi axliⱪ ⱨǝdiyǝsi süpitidǝ, ⱪoxⱪarƣa zǝytun meyi ilǝxtürülgǝn esil undin ǝfaⱨning ondin ikkisi axliⱪ ⱨǝdiyǝsi süpitidǝ, ");
INSERT INTO uigpin_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ⱨǝrbir ⱪoza bexiƣa zǝytun meyi ilǝxtürülgǝn esil undin ǝfaⱨning ondin biri axliⱪ ⱨǝdiyǝsi süpitidǝ sunulsun; bu Pǝrwǝrdigarƣa otta sunulidiƣan, huxbuy qiⱪiridiƣan bir kɵydürmǝ ⱪurbanliⱪtur. ");
INSERT INTO uigpin_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ularning xarab ⱨǝdiyǝliri bolsa: — ⱨǝrbir torpaⱪ bexiƣa xarabtin yerim ⱨin, ⱪoxⱪar bexiƣa ⱨinning üqtin biri, ⱨǝrbir ⱪoza bexiƣa ⱨinning tɵttin biri sunulsun. Bu ⱨǝr ayda sunulidiƣan ayliⱪ kɵydürmǝ ⱪurbanliⱪ bolup, yilning ⱨǝr eyida xundaⱪ ⱪilinsun. ");
INSERT INTO uigpin_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Bularning üstigǝ Pǝrwǝrdigarƣa atilidiƣan gunaⱨ ⱪurbanliⱪ süpitidǝ bir tekǝ sunulsun; xularning ⱨǝmmisi daimiy kɵydürmǝ ⱪurbanliⱪ wǝ ⱪoxumqǝ xarab ⱨǝdiyǝsi bilǝn billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Birinqi ayning on tɵtinqi küni Pǝrwǝrdigarƣa atalƣan «ɵtüp ketix» ⱪozisi sunulsun.    ");
INSERT INTO uigpin_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Xu ayning on bǝxinqi küni ⱨeyt baxlinidu; yǝttǝ kün petir nan yeyilsun. ");
INSERT INTO uigpin_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Birinqi küni muⱪǝddǝs yiƣilix ɵtküzülsun, ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmasliⱪinglar kerǝk, ");
INSERT INTO uigpin_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","xu küni otta sunulidiƣan, Pǝrwǝrdigarƣa atalƣan kɵydürmǝ ⱪurbanliⱪ süpitidǝ yax torpaⱪtin ikkini, bir ⱪoqⱪar wǝ yǝttǝ bir yaxliⱪ ǝrkǝk ⱪoza sununglar; ular aldinglarda bejirim kɵrünsun; ");
INSERT INTO uigpin_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","xularƣa ⱪoxulidiƣan axliⱪ ⱨǝdiyǝliri zǝytun meyi ilǝxtürülgǝn esil un bolup, ⱨǝrbir torpaⱪ bexiƣa ǝfaⱨning ondin üqi, ⱪoqⱪar bexiƣa ǝfaⱨning ondin ikkisi, ");
INSERT INTO uigpin_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","xu yǝttǝ ⱪoza bexiƣa ǝfaⱨning ondin biri sunulsun; ");
INSERT INTO uigpin_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","xuningdǝk gunaⱨinglar üqün kǝfarǝt kǝltürüxkǝ gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Bularning ⱨǝmmisini ǝtigǝnlik kɵydürmǝ ⱪurbanliⱪ, yǝni daimiy kɵydürmǝ ⱪurbanliⱪtin ayrim sununglar. ");
INSERT INTO uigpin_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Silǝr bu tǝriⱪidǝ uda yǝttǝ kün Pǝrwǝrdigarƣa atap otta sunulidiƣan, huxbuy kǝltüridiƣan axundaⱪ ⱨǝdiyǝ-ⱪurbanliⱪlarni sununglar; xularning ⱨǝmmisi daimiy kɵydürmǝ ⱪurbanliⱪ wǝ ⱪoxup sunulidiƣan xarab ⱨǝdiyǝsining sirtida sunulidu. ");
INSERT INTO uigpin_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Yǝttinqi küni muⱪǝddǝs yiƣilix ɵtküzünglar, xu küni ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilixⱪa bolmaydu. ");
INSERT INTO uigpin_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«Dǝslǝpki orma» küni, yǝni «ⱨǝptilǝr ⱨeyti»nglarda silǝr yengi axliⱪ ⱨǝdiyǝsini Pǝrwǝrdigarƣa sunƣan qaƣda muⱪǝddǝs yiƣilix ɵtküzünglar; ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Silǝr Pǝrwǝrdigarƣa atalƣan, huxbuy kǝltüridiƣan kɵydürmǝ ⱪurbanliⱪ süpitidǝ yax torpaⱪtin ikkini, ⱪoqⱪardin birni, bir yaxliⱪ ǝrkǝk ⱪozidin yǝttini sununglar. ");
INSERT INTO uigpin_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Xularƣa ⱪoxup sunulidiƣan axliⱪ ⱨǝdiyǝsi zǝytun meyi ilǝxtürülgǝn esil undin bolup, ⱨǝrbir torpaⱪ bexiƣa ǝfaⱨning ondin üqi, ⱪoqⱪar bexiƣa ǝfaⱨning ondin ikkisi, ");
INSERT INTO uigpin_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","xu yǝttǝ ⱪoza bexiƣa ǝfaⱨning ondin biri sunulsun; ");
INSERT INTO uigpin_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","xuningdǝk silǝrning gunaⱨinglar üqün kǝfarǝt kǝltürüxkǝ gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Xularning ⱨǝmmisi daimiy kɵydürmǝ ⱪurbanliⱪ wǝ uning axliⱪ ⱨǝdiyǝsigǝ ⱪoxup (bularning ⱨǝmmisi aldinglarda bejirim kɵrünsun), xarab ⱨǝdiyǝliri bilǝn billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Yǝttinqi ayning birinqi küni silǝr muⱪǝddǝs yiƣilix ɵtküzünglar; u küni ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmasliⱪinglar kerǝk. Bu silǝr üqün kanaylar qelinidiƣan küni bolidu.    ");
INSERT INTO uigpin_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Silǝr Pǝrwǝrdigarƣa atalƣan, huxbuy kǝltüridiƣan kɵydürmǝ ⱪurbanliⱪ süpitidǝ yax bir torpaⱪ, bir ⱪoqⱪar, yǝttǝ bir yaxliⱪ bejirim ǝrkǝk ⱪozini sununglar. ");
INSERT INTO uigpin_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Xularƣa ⱪoxup sunulidiƣan axliⱪ ⱨǝdiyǝsi zǝytun meyi ilǝxtürülgǝn esil undin bolup, ⱨǝrbir torpaⱪ bexiƣa ǝfaⱨning ondin üqi, ⱪoqⱪar bexiƣa ǝfaⱨning ondin ikkisi, ");
INSERT INTO uigpin_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","xu yǝttǝ ⱪoza bexiƣa ǝfaⱨning ondin biri sunulsun; ");
INSERT INTO uigpin_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","xuningdǝk silǝrning gunaⱨinglar üqün kǝfarǝt kǝltürüxkǝ gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Xularni ayning birinqi künidiki kɵydürmǝ ⱪurbanliⱪ wǝ uningƣa ⱪoxumqǝ bolƣan axliⱪ ⱨǝdiyǝsi, daimiy kɵydürmǝ ⱪurbanliⱪ, uningƣa ⱪoxumqǝ bolƣan axliⱪ ⱨǝdiyǝsi wǝ bularƣa ⱪoxulidiƣan xarab ⱨǝdiyǝlirining sirtida sununglar; bularning ⱨǝmmisi ⱨǝrbiri bǝlgilimǝ boyiqǝ Pǝrwǝrdigarƣa atap otta huxbuy kǝltürsun dǝp sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Yǝttinqi ayning oninqi küni silǝr muⱪǝddǝs yiƣilix ɵtküzünglar; nǝpsinglarni tartip ɵzünglarni tɵwǝn tutunglar. U küni ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilixⱪa bolmaydu.    ");
INSERT INTO uigpin_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Silǝr Pǝrwǝrdigarƣa atalƣan, huxbuy kǝltüridiƣan kɵydürmǝ ⱪurbanliⱪ süpitidǝ yax bir torpaⱪ, bir ⱪoqⱪar, bir yaxliⱪ ǝrkǝk ⱪozidin yǝttini sununglar (bularning ⱨǝmmisi aldinglarda bejirim kɵrünsun). ");
INSERT INTO uigpin_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Xularƣa ⱪoxup sunulidiƣan axliⱪ ⱨǝdiyǝsi zǝytun meyi ilǝxtürülgǝn esil undin bolup, ⱨǝrbir torpaⱪ bexiƣa ǝfaⱨning ondin üqi, ⱪoqⱪar bexiƣa ǝfaⱨning ondin ikkisi, ");
INSERT INTO uigpin_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","xu yǝttǝ ⱪoza bexiƣa ǝfaⱨning ondin birini, ");
INSERT INTO uigpin_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sununglar; ularning ⱨǝmmisi kǝfarǝt künidiki gunaⱨ ⱪurbanliⱪi, daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ bularning xarab ⱨǝdiyǝliri billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Yǝttinqi ayning on bǝxinqi küni muⱪǝddǝs yiƣilix ɵtküzünglar; u küni ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilixⱪa bolmaydu. Pǝrwǝrdigarƣa atap yǝttǝ kün ⱨeyt ⱪilinglar; ");
INSERT INTO uigpin_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","silǝr Pǝrwǝrdigarƣa atap, huxbuy kǝltürsun dǝp otta sunulidiƣan kɵydürmǝ ⱪurbanliⱪ süpitidǝ yax torpaⱪtin on üqni, ikki ⱪoqⱪar, bir yaxliⱪ ǝrkǝk ⱪozidin on tɵtni sununglar (xular ⱨǝmmisi bejirim bolsun). ");
INSERT INTO uigpin_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Xularƣa ⱪoxup sunulidiƣan axliⱪ ⱨǝdiyǝsi zǝytun meyi ilǝxtürülgǝn esil undin bolup, on üq torpaⱪ bexiƣa ǝfaⱨning ondin üqi, ikki ⱪoqⱪar bexiƣa ǝfaⱨning ondin ikkisi, ");
INSERT INTO uigpin_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","on tɵt ⱪoza bexiƣa ǝfaⱨning ondin birini, ");
INSERT INTO uigpin_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sununglar; xularning üstigǝ daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Ikkinqi küni yax torpaⱪtin on ikkini, ikki ⱪoqⱪar, bir yaxliⱪ ǝrkǝk ⱪozidin on tɵtni sununglar (xular ⱨǝmmisi bejirim bolsun) ");
INSERT INTO uigpin_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","wǝ xundaⱪla torpaⱪlar, ⱪoqⱪarlar wǝ ǝrkǝk ⱪozilarning saniƣa ⱪarap bǝlgilimǝ boyiqǝ ⱪoxumqǝ sunulidiƣan axliⱪ ⱨǝdiyǝliri bilǝn xarab ⱨǝdiyǝlirini sununglar. ");
INSERT INTO uigpin_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sununglar; xularning üstigǝ daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ xularning xarab ⱨǝdiyǝliri billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Üqinqi küni bir yax torpaⱪtin on birni, ikki ⱪoqⱪar, bir yaxliⱪ ǝrkǝk ⱪozidin on tɵtni sununglar (xular ⱨǝmmisi bejirim bolsun) ");
INSERT INTO uigpin_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","wǝ xundaⱪla torpaⱪlar, ⱪoqⱪarlar wǝ ǝrkǝk ⱪozilarning saniƣa ⱪarap bǝlgilimǝ boyiqǝ ⱪoxumqǝ sunulidiƣan axliⱪ ⱨǝdiyǝliri bilǝn xarab ⱨǝdiyǝlirini sununglar; ");
INSERT INTO uigpin_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sununglar; xularning üstigǝ daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Tɵtinqi küni yax torpaⱪtin onni, ikki ⱪoqⱪar, bir yaxliⱪ ǝrkǝk ⱪozidin on tɵtni sununglar (xular ⱨǝmmisi bejirim bolsun) ");
INSERT INTO uigpin_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","wǝ xundaⱪla torpaⱪlar, ⱪoqⱪarlar wǝ ǝrkǝk ⱪozilarning saniƣa ⱪarap bǝlgilimǝ boyiqǝ ⱪoxumqǝ sunulidiƣan axliⱪ ⱨǝdiyǝliri bilǝn xarab ⱨǝdiyǝlirini sununglar; ");
INSERT INTO uigpin_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sununglar; xularning üstigǝ daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Bǝxinqi küni yax torpaⱪtin toⱪⱪuzni, ikki ⱪoqⱪar, bir yaxliⱪ ǝrkǝk ⱪozidin on tɵtni sununglar (xular ⱨǝmmisi bejirim bolsun) ");
INSERT INTO uigpin_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","wǝ xundaⱪla torpaⱪlar, ⱪoqⱪarlar wǝ ǝrkǝk ⱪozilarning saniƣa ⱪarap bǝlgilimǝ boyiqǝ ⱪoxumqǝ sunulidiƣan axliⱪ ⱨǝdiyǝliri bilǝn xarab ⱨǝdiyǝlirini sununglar; ");
INSERT INTO uigpin_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sununglar; xularning üstigǝ daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Altinqi küni yax torpaⱪtin sǝkkizni, ikki ⱪoqⱪar, bir yaxliⱪ ǝrkǝk ⱪozidin on tɵtni sununglar (xular ⱨǝmmisi bejirim bolsun) ");
INSERT INTO uigpin_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","wǝ xundaⱪla torpaⱪlar, ⱪoqⱪarlar wǝ ǝrkǝk ⱪozilarning saniƣa ⱪarap bǝlgilimǝ boyiqǝ ⱪoxumqǝ sunulidiƣan axliⱪ ⱨǝdiyǝliri bilǝn xarab ⱨǝdiyǝlirini sununglar; ");
INSERT INTO uigpin_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sununglar; xularning üstigǝ daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Yǝttinqi küni yax torpaⱪtin yǝttini, ikki ⱪoqⱪar, bir yaxliⱪ ǝrkǝk ⱪozidin on tɵtni sununglar (xular ⱨǝmmisi bejirim bolsun) ");
INSERT INTO uigpin_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","wǝ xundaⱪla torpaⱪlar, ⱪoqⱪarlar wǝ ǝrkǝk ⱪozilarning saniƣa ⱪarap bǝlgilimǝ boyiqǝ ⱪoxumqǝ sunulidiƣan axliⱪ ⱨǝdiyǝliri bilǝn xarab ⱨǝdiyǝlirini sununglar; ");
INSERT INTO uigpin_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidǝ bir tekǝ sununglar; xularning üstigǝ daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Sǝkkizinqi küni silǝr muⱪǝddǝs yiƣilix ɵtküzünglar; u küni ⱨeqⱪandaⱪ ix-ǝmgǝk ⱪilmanglar. ");
INSERT INTO uigpin_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Silǝr Pǝrwǝrdigarƣa atap, huxbuy kǝltürsun dǝp otta sunulidiƣan kɵydürmǝ ⱪurbanliⱪ süpitidǝ bir torpaⱪ, bir ⱪoqⱪar wǝ bir yaxliⱪ ǝrkǝk ⱪozidin on tɵtni (xular ⱨǝmmisi bejirim bolsun) ");
INSERT INTO uigpin_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ⱨǝmdǝ torpaⱪ, ⱪoqⱪar wǝ ǝrkǝk ⱪozilarning saniƣa ⱪarap, bǝlgilimǝ boyiqǝ ⱪoxumqǝ sunulidiƣan axliⱪ ⱨǝdiyǝliri bilǝn xarab ⱨǝdiyǝlirini sununglar; ");
INSERT INTO uigpin_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","xuningdǝk gunaⱨ ⱪurbanliⱪi süpitidimu bir tekǝ sununglar; xularning üstigǝ daimiy kɵydürmǝ ⱪurbanliⱪ, uning ⱪoxumqǝ axliⱪ ⱨǝdiyǝsi wǝ xarab ⱨǝdiyǝsi billǝ sunulsun. ");
INSERT INTO uigpin_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Bǝlgilǝngǝn ⱨeytliringlarda Pǝrwǝrdigarƣa atap sunulidiƣan ⱪurbanliⱪ-ⱨǝdiyǝlǝr ǝnǝ xulardur; silǝrning ⱪǝsǝmgǝ baƣliⱪ yaki ihtiyarǝn sunidiƣanliringlar, kɵydürmǝ ⱪurbanliⱪliringlar, axliⱪ ⱨǝdiyǝliringlar, xarab ⱨǝdiyǝliringlar wǝ inaⱪliⱪ ⱪurbanliⱪliringlar bolsa, ularning sirtididur. ");
INSERT INTO uigpin_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Xundaⱪ ⱪilip, Musa Pǝrwǝrdigarning ɵzigǝ buyruƣanlirining ⱨǝmmisini ⱪaldurmay Israillarƣa uⱪturdi. ");
INSERT INTO uigpin_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa Israillarning ⱪǝbilǝ baxliⱪliriƣa sɵz ⱪilip mundaⱪ dedi: — Pǝrwǝrdigarning buyruƣanliri mundaⱪ: — ");
INSERT INTO uigpin_vpl VALUES ("NU30_2","005_30_