﻿USE sofia;
DROP TABLE IF EXISTS sofia.uiglat_vpl;
CREATE TABLE uiglat_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uiglat_vpl WRITE;
INSERT INTO uiglat_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Muqeddemde Xuda asmanlar bilen zéminni yaratti.    ");
INSERT INTO uiglat_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","U chaghda yer bolsa shekilsiz we qupquruq halette boldi; qarangghuluq chongqur sularning yüzini qaplidi; Xudaning Rohi chongqur sular üstide lerzan perwaz qilatti. ");
INSERT INTO uiglat_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Xuda: «Yoruqluq bolsun!» déwidi, yoruqluq peyda boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Xuda yoruqluqning yaxshi ikenlikini kördi; Xuda yoruqluq bilen qarangghuluqni ayridi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Xuda yoruqluqni «kündüz», qarangghuluqni «kéche» dep atidi. Shu teriqide kech bilen seher ötti, bu tunji kün boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Andin Xuda: — Sularning ariliqida bir boshluq bolsun we sular yuqiri-töwen ikkige ayrilip tursun, dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Shuning bilen Xuda bir boshluq hasil qilip, sularni boshluqning astigha we boshluqning üstige ayriwetti; ish ene shundaq boldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Xuda bu boshluqni «asman» dep atidi. Shu teriqide kech bilen seher ötti, bu ikkinchi kün boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Andin Xuda: «Asmanning astidiki sular bir yerge yighilsun, quruq tupraq körünsun!» déwidi, del shundaq boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Xuda quruq tupraqni «yer», yighilghan sularni bolsa «déngizlar» dep atidi. Xuda bularning yaxshi bolghanliqini kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Andin Xuda yene: «Yer herxil ösümlüklerni, uruqluq otyashlarni, méwe béridighan derexlerni türliri boyiche özide ündürsun! Méwilerning ichide uruqliri bolsun!» déwidi, del shundaq boldi; ");
INSERT INTO uiglat_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","yerdiki ösümlüklerni, yeni uruq chiqidighan otyashlarni öz türliri boyiche, méwe béridighan, yeni méwilirining ichide uruqliri bolghan derexlerni öz türliri boyiche ündürdi. Xuda bularning yaxshi bolghanliqini kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Shu teriqide kech bilen seher ötti, bu üchinchi kün boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Xuda yene: «Kündüz bilen kéchini ayrip bérish üchün asmanlarda yoruqluq jisimlar bolsun. Ular künler, pesillar we yillarni ayrip turushqa belge bolsun; ");
INSERT INTO uiglat_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ular asmanlarda turup nur chiqarghuchi bolup, yer yüzige yoruqluq bersun!» déwidi, del shundaq boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Xuda ikki chong nur chiqarghuchi jisimni yaratti; chong nur chiqarghuchini kündüzni bashquridighan, kichik nur chiqarghuchni kéchini bashquridighan qildi. Hemde yene yultuzlarnimu yaratti. ");
INSERT INTO uiglat_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Xuda bularni yerge yoruqluq bérip, kündüz bilen kéchini bashqurup, yoruqluq bilen qarangghuluqni ayrisun dep asmanlarning gümbizige orunlashturdi. Xuda buning yaxshi bolghanliqini kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Shu teriqide kech bilen seher ötti, bu tötinchi kün boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Xuda yene: «Sularda migh-migh janiwarlar bolsun, uchar-qanatlar yerning üstide, asman boshluqida uchsun» dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Shundaq qilip Xuda sudiki chong-chong mexluqlarni, shundaqla sularda migh-migh janiwarlarni öz türliri boyiche we herxil uchar-qanatlarni öz türliri boyiche yaratti. Xuda buning yaxshi bolghanliqini kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Xuda bu janliqlargha bext-beriket ata qilip: «Nesillinip, köpiyip, déngiz sulirini toldurunglar, uchar-qanatlarmu yer yüzide awusun» dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Shu teriqide kech bilen seher ötti, bu beshinchi kün boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Xuda yene: «Yer janiwarlarni öz türliri boyiche chiqarsun — mal-charwilarni, ömiligüchi janiwarlarni we yawayi haywanlarni öz türliri boyiche apiride qilsun» — déwidi, del shundaq boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Shundaq qilip Xuda yerdiki yawayi haywanlarni öz türliri boyiche, mal-charwilarni öz türliri boyiche we yer yüzide ömiligüchi barliq janiwarlarni öz türliri boyiche yaratti. Xuda buning yaxshi bolghanliqini kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Andin Xuda: «Öz süret-obrazimizda, Bizge oxshaydighan qilip insanni yaritayli. Ular déngizdiki béliqlargha, asmandiki uchar-qanatlargha, barliq mal-charwilargha, pütkül yer yüzige we yer yüzidiki barliq ömiligüchi janiwarlargha igidarchiliq qilsun» dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Shundaq qilip, Xuda insanni Öz süret-obrazida yaratti; Uni Özining süritide yaratti; Ularni erkek-chishi qilip yaratti. ");
INSERT INTO uiglat_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Xuda ulargha bext-beriket ata qilip: «Siler nesillinip, köpiyip, yer yüzini toldurup boysundurunglar; déngizdiki béliqlar, asmandiki uchar-qanatlargha, shuningdek yer yüzide yüridighan herbir haywanlargha igidarchiliq qilinglar» dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Andin Xuda yene: «Mana, Men pütkül yer yüzidiki uruqluq otyashlar bilen uruqluq méwe béridighan herbir derexlerni silerge ozuqluq bolsun dep berdim; ");
INSERT INTO uiglat_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","shundaqla yerdiki barliq janiwarlar bilen asmandiki barliq uchar-qanatlar we yer yüzide barliq ömiligüchilerge, yeni barliq jan-janiwarlargha ozuqluq bolsun dep barliq gül-giyahlarni berdim» déwidi, del shundaq boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Xuda yaratqanlirining hemmisige sepsélip qaridi, we mana bularning hemmisi nahayiti yaxshi bolghanidi. Shu teriqide kech bilen seher ötti, bu altinchi kün boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Shundaq qilip asman bilen zémin, pütkül mewjudatliri bilen qoshulup yaritilip boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Xuda yettinchi künigiche qilidighan ishini tamamlidi. U yettinchi küni barliq yaritish ishini toxtitip aram aldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Yettinchi küni Xuda barliq yaritish ishliridin aram alghan kün bolghanliqi üchün, shu künni bextlik kün qilip, uni «muqeddes kün» dep békitti. ");
INSERT INTO uiglat_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Perwerdigar Xuda zémin bilen asmanni yaratqan künide, asman-zéminning yaritilish jeryanining tarixliri mundaq: — ");
INSERT INTO uiglat_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Zéminda téxi héch gül-giyah, yerde héch otyash ünmigenidi; chünki Perwerdigar Xuda yer yüzige höl-yéghin yaghdurmighanidi, shundaqla yer tériydighan ademmu yoq idi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Lékin yerdin bulaq süyi chiqip, tamam yer yüzini sughardi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Andin Perwerdigar Xuda ademni yerning topisidin yasap, hayatliq nepesini uning burnigha püwlidi; shuning bilen adem tirik bir jan boldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Andin kéyin Perwerdigar Xuda meshriq terepte Érem dégen jayda bir bagh bina qilip, yasighan ademni shu yerge orunlashturdi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Perwerdigar Xuda yerdin közni qamlashturidighan chirayliq, méwiliri yéyishlik herxil derexni ündürdi; u yene baghning otturisida «hayatliq derixi» we «yaxshi bilen yamanni bilgüzgüchi derex»ni ündürdi.    ");
INSERT INTO uiglat_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Baghni sughirishqa Éremdin bir derya éqip chiqti; andin bölünüp, töt éqin boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Birinchi éqinning nami Pishon bolup, altun chiqidighan pütkül Hawilah zéminini aylinip ötidu. ");
INSERT INTO uiglat_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Bu yurtning altuni nahayiti ésil idi; shu yerde puraqliq déwirqay bilen aq héqiqmu chiqidu. ");
INSERT INTO uiglat_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ikkinchi deryaning nami Gihon bolup, pütkül Kush zéminini aylinip ötidu. ");
INSERT INTO uiglat_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Üchinchi deryaning nami Dijle bolup, Ashurning sherqidin éqip ötidu, tötinchi deryaning nami Efrat idi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Perwerdigar Xuda ademni élip Érem béghigha ishlep, perwish qilsun dep uni shu yerge qoyup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Perwerdigar Xuda ademge emr qilip: baghdiki herbir derex méwiliridin xalighiningche ye; ");
INSERT INTO uiglat_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","emma «yaxshi bilen yamanni bilgüzgüchi derex»ning méwisidin yémigin; chünki uningdin yégen kününgde jezmen ölisen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Andin Perwerdigar Xuda yene söz qilip: — Ademning yalghuz turushi yaxshi emes; Men uninggha mas kélidighan bir yardemchi hemrahni yasap bérey, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Perwerdigar Xuda tupraqtin daladiki barliq janiwarlar bilen asmandiki hemme uchar-qanatlarni yasighanidi; ulargha ademning néme dep at qoyidighanliqini bilish üchün, U ularni ademning aldigha keltürdi. Adem herbir janiwargha néme dep at qoyghan bolsa, uning éti shu bolup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Bu teriqide adem hemme mal-charwilargha, asmandiki uchar-qanatlargha we daladiki herbir janiwarlargha at qoydi; wehalenki, adem özige mas kélidighan héchbir yardemchi hemrah uchratmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Shuning bilen Perwerdigar Xuda ademge bir qattiq uyqu saldi; u uxlap qaldi. U uxlawatqanda, U uning biqinidin bir az élip, andin uning ornini et-gösh bilen étip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Shuning bilen Perwerdigar Xuda ademning biqinidin alghan shu qisimdin bir ayalni yasap, uni ademning qéshigha ekeldi. ");
INSERT INTO uiglat_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adem’ata xushal bolup: — Mana bu söngeklirimdiki söngek, étimdiki et bolghach, «ayal» dep atalsun; chünki u erdin élin’ghandur, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Shuning üchün er kishi ata-anisidin ayrilip, öz ayaligha baghlinip bir bolup, ikkisi bir ten bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adem’ata bilen ayali her ikkisi yalingach bolsimu, héch uyalmaytti.    ");
INSERT INTO uiglat_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yer yüzide yilan Reb Perwerdigar yaratqan daladiki haywanlarning hemmisidin hiyliger idi. U ayaldin: — Xuda rasttinla baghdiki derexlerning héchqaysisining méwisidin yémenglar, dédimu? — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ayal yilan’gha jawab bérip: — Baghdiki derexlerning méwilirini yések bolidu. ");
INSERT INTO uiglat_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Emma baghning otturisidiki derexning méwisi toghrisida Xuda: «Buningdin yémenglar, qolmu tegküzmenglar, bolmisa ölisiler» dégen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yilan ayalgha: — Undaq emes! Hergiz ölmeysiler! ");
INSERT INTO uiglat_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Belki siler uni yégen kününglarda, Xuda közünglarning échilip, Xudagha oxshash yaxshi bilen yamanni bilidighan bolup qalidighanliqinglarni bilidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ayal derexning méwisining yémeklik üchün yaxshiliqini, uning közni qamlashturidighanliqini körüp, hemde derexning ademni eqilliq qilidighan jelpkarliqini körüp, méwidin yédi we uningdin yénida turghan érigimu berdi; umu yédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yéyishi bilenla her ikkisining közliri échilip, özlirining yalingach ikenlikini bilip, enjür yopurmaqlirini élip bir-birige ulap tikip, özlirige yapquch qilip tartti. ");
INSERT INTO uiglat_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kün salqinlighanda, ular Perwerdigar Xudaning baghda mangghan shepisini anglap qélip, adem ayali bilen Perwerdigar Xudaning hazir bolghinidin qéchip baghdiki derexlerning arisigha yoshurunuwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Lékin Perwerdigar Xuda towlap ademni chaqirip uninggha: Sen nede? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adem’ata jawab bérip: — Men baghda shepengni anglap, yalingach turghinim üchün qorqup kétip, yoshurunuwaldim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Xuda uninggha: — Yalingach ikenlikingni sanga kim éytti? Men sanga yéme, dep emr qilghan derexning méwisidin yédingmu-ya? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adem jawab bérip: — Sen manga hemrah bolushqa bergen ayal derexning méwisidin manga bergenidi, men yédim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Perwerdigar Xuda ayalgha: — Bu néme qilghining? — dédi. Ayal jawab bérip: — Yilan méni aldap azdursa, men yep saptimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Perwerdigar Xuda yilan’gha mundaq dédi: — «Bu qilghining üchün, Sen hemme mal-charwilardin, Daladiki barliq haywanatlardin bekrek lenetke qalisen; Qorsiqing bilen béghirlap méngip, Ömrüngning barliq künliride topa yeysen. ");
INSERT INTO uiglat_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","We men sen bilen ayalning arisigha, Séning nesling bilen ayalning neslining arisigha öchmenlik salimen; U séning béshingni dessep zeximlendüridu, Sen qopup uning tapinini chéqip zeximlendürisen».    ");
INSERT INTO uiglat_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Andin Xuda ayalgha: — «Séning hamilidarliqingning japa-musheqqetlirini köpeytimen; Sen qattiq tolghaq ichide boshinisen; Sen éringdin üstün turushqa hewes qilsangmu, U üstüngdin xojiliq qilidu» — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Andin U Adem atigha: — «Sen ayalingning sözige qulaq sélip, Men sanga yéme, dep emr qilghan derextin yégining tüpeylidin, Séning tüpeylingdin yer-tupraq lenitimge uchraydu; Ömrüngning barliq künliride peqet japaliq ishlepla, andin uningdin ozuqlinisen. ");
INSERT INTO uiglat_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Yer sanga tiken bilen qamghaq ündüridu; Shundaqtimu sen yerdiki ziraet-otyashlarni yeysen. ");
INSERT INTO uiglat_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Taki sen tupraqqa qaytquche yüz-közüng terge chümgende, andin nan yéyeleysen; Chünki sen esli tupraqtin élin’ghansen; Sen eslide topa bolghach, Yene topigha qaytisen» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Uning ayali barliq jan igilirining anisi bolidighini üchün adem uninggha «Hawa» dep at qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Perwerdigar Xuda Adem’ata bilen uning ayaligha haywan tériliridin kiyim qilip kiydürüp qoydi.    ");
INSERT INTO uiglat_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Perwerdigar Xuda söz qilip: — Mana, adem Bizlerdin birige oxshap qaldi, yaxshi bilen yamanni bildi. Emdi qolini uzitip hayatliq derixidin élip yewélip, ta ebedgiche yashawermesliki üchün uni tosushimiz kérek, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Shuning bilen Perwerdigar Xuda uni Érem baghdin qoghlap chiqiriwetti; shundaq qilip uni yerge ishleydighan, yeni özi esli apiride qilin’ghan tupraqqa ishleydighan qilip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ademni qoghliwétip, hayatliq derixige baridighan yolni muhapizet qilish üchün, u Érem béghining meshriq teripige kérublarni we töt terepke pirqiraydighan yalqunluq bir shemsherni qoyup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adem’ata ayali Hawa bilen bille boldi; Hawa hamilidar bolup Qabilni tughup: «Men bir ademge ige boldum — U Perwerdigardur!» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Andin u yene Qabilning inisi Habilni tughdi. Habil padichi boldi, Qabil bolsa tériqchi boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Békitilgen shundaq bir waqit-saette shundaq bir ish boldiki, Qabil tupraqning hosulidin Perwerdigargha hediye keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habilmu padisidin qoylirining tunjiliridin, yeni ularning yéghidin hediye sundi. Perwerdigar Habilni we uning sun’ghan hediyesini qobul qildi.    ");
INSERT INTO uiglat_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Lékin Qabil we uning sun’ghinigha qarimidi. Shu wejidin Qabilning tolimu achchiqi kélip, chirayi tutuldi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Shuning bilen Perwerdigar Qabilgha: Némishqa achchiqlinisen? Néme üchün chiraying tutulup kétidu? ");
INSERT INTO uiglat_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Eger durus ish qilsang, sen kötürülmemsen? Lékin durus ish qilmisang, mana gunah ishik aldida séni paylap béghirlap yatidu, u séni öz ilkige almaqchi bolidu; lékin sen uningdin ghalip kélishing kérek, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Qabil inisi Habilgha: «Daligha chiqip kéleyli!» dédi. Dalada shu weqe boldiki, Qabil inisi Habilgha qol sélip, uni öltürdi.    ");
INSERT INTO uiglat_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Perwerdigar Qabilgha: Ining Habil nede? — dep soridi. U jawab bérip: Bilmeymen, men inimning baqquchisimu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Xuda uninggha: — Sen néme qilding? Mana, iningning qéni yerdin manga peryad kötürüwatidu! ");
INSERT INTO uiglat_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Emdi iningning qolungda tökülgen qénini qobul qilishqa aghzini achqan yerdin qoghlinip, lenetke uchraysen. ");
INSERT INTO uiglat_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sen yerge ishlisengmu u buningdin kéyin sanga quwwitini bermeydu; sen yer yüzide sersan bolup, sergerdan bolisen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Buni anglap Qabil Perwerdigargha jawab qilip: — Méning bu jazayimni adem kötürelmigüdek! ");
INSERT INTO uiglat_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mana, Sen bügün méni yer yüzidin qoghliding, men emdi Séning yüzüngdin yoshurunup yürimen; yer yüzide sersen bolup sergerdanliqta yürimen; shundaq boliduki, kimla méni tépiwalsa, öltürüwétidu!, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Lékin Perwerdigar uninggha jawab bérip: — Shundaq boliduki, kimki Qabilni öltürse, uningdin yette hesse intiqam élinidu, — dédi. Shularni dep Perwerdigar Qabilgha uchrighan birsi uni öltürüwetmisun dep uninggha bir belge qoyup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Shuning bilen Qabil Perwerdigarning huzuridin chiqip, Éremning meshriq teripidiki Nod dégen yurtta olturaqliship qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qabil ayali bilen bille bolup, ayali hamilidar bolup Hanoxni tughdi. U waqitta Qabil bir sheher bina qiliwatatti; u sheherning namini oghlining ismi bilen Hanox dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hanoxtin Irad töreldi, Iradtin Mehuyail töreldi, Mehuyaildin Metushail töreldi, Metushaildin Lemex töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemex özige ikki xotun aldi. Birining ismi Adah, yene birining ismi Zillah idi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah Yabalni tughdi. U chédirda olturidighan köchmen malchilarning bowisi idi, ");
INSERT INTO uiglat_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","uning inisining ismi Yubal idi. Bu chiltar bilen ney chalghuchilarning bowisi idi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah yene Tubal-qayin dégen bir oghulni tughdi. U mis-tömür eswablarni soqquchi idi. Tubal-Qayinning Naamah isimlik bir singlisi bar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemex bolsa ayallirigha söz qilip: — «Ey Adah bilen Zillah, sözümni anglanglar! Ey Lemexning ayalliri, gépimge qulaq sélinglar! Méni zeximlendürgini üchün men adem öltürdüm, Ténimni zéde qilghanliqi üchün bir yigitni öltürdüm. ");
INSERT INTO uiglat_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Eger Qabil üchün yette hesse intiqam élinsa, Lemex üchün yetmish yette hesse intiqam élinidu!» — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adem’ata yene ayali bilen bille boldi. Ayali bir oghul tughup, uninggha Shét dep at qoyup: Qabil Habilni öltürüwetkini üchün Xuda uning ornigha manga bashqa bir ewlad tiklep berdi, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Shéttinmu bir oghul tughuldi; u uninggha Énosh dep at qoydi. Shu waqittin tartip ademler Perwerdigarning namigha nida qilishqa bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Bu Adem’atining ewladlirining nesebnamisidur: — Xuda insanni yaratqan künide, uni Özige oxshash qilip yaratti.    ");
INSERT INTO uiglat_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","U ularni er jinis we ayal jinis qilip yaritip, ulargha bext-beriket ata qilip, yaritilghan künide ularning namini «adem» dep atidi.    ");
INSERT INTO uiglat_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adem’ata bir yüz ottuz yashqa kirgende uningdin özige oxshaydighan, öz süret-obrazidek bir oghul töreldi; u uninggha Shét dep at qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Shét tughulghandin kéyin Adem’ata sekkiz yüz yil ömür körüp, uningdin yene oghul-qizlar töreldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adem’atimiz jemiy toqquz yüz ottuz yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Shét bir yüz besh yashqa kirgende uningdin Énosh töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Énosh tughulghandin kéyin Shét sekkiz yüz yette yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Shét jemiy toqquz yüz on ikki yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Énosh toqsan yashqa kirgende uningdin Kénan töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kénan tughulghandin kéyin, Énosh sekkiz yür on besh yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Énosh jemiy toqquz yüz besh yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kénan yetmish yashqa kirgende uningdin Mahalalél töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalél tughulghandin kéyin Kénan sekkiz yüz qiriq yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kénan jemiy toqquz yüz on yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalél atmish besh yashqa kirgende uningdin Yared töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yared tughulghandin kéyin Mahalalél sekkiz yüz ottuz yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalél jemiy sekkiz yüz toqsan besh yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared bir yüz atmish ikki yashqa kirgende uningdin Hanox töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Hanox tughulghandin kéyin Yared sekkiz yüz yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yared jemiy toqquz yüz atmish ikki yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hanox atmish besh yashqa kirgende uningdin Metushelah töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metushelah tughulghandin kéyin Hanox üch yüz yilghiche Xuda bilen bir yolda méngip, yene oghul-qizlarni tapti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hanoxning yer yüzide barliq körgen künliri üch yüz atmish besh yil boldi; ");
INSERT INTO uiglat_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","U Xuda bilen bir yolda méngip yashaytti; u tuyuqsiz közdin ghayib boldi; chünki Xuda uni Öz yénigha élip ketkenidi.    ");
INSERT INTO uiglat_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metushelah bir yüz seksen yette yashqa kirgende uningdin Lemex töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemex tughulghandin kéyin Metushelah yette yüz seksen ikki yil ömür körüp, uningdin oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metushelah jemiy toqquz yüz atmish toqquz yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","29","Lemex bir yüz seksen ikki yashqa kirgende bir oghul tépip, uning ismini Nuh atap: — Perwerdigar tupraqqa lenet qildi; shunga biz yerge ishliginimizde hemde qollirimizning japaliq emgikide bu bala bizge teselli béridu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuh tughulghandin kéyin Lemex besh yüz toqsan besh yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemex jemiy yette yüz yetmish yette yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuh besh yüz yashqa kirgendin kéyin, uningdin Shem, Ham we Yafet töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","We shundaq boldiki, insanlar yer yüzide köpiyishke bashlighanda, shundaqla qizlarmu köplep tughulghanda, ");
INSERT INTO uiglat_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Xudaning oghulliri insanlarning qizlirining chirayliqliqini körüp, xalighanche tallap, özlirige xotun qilishqa bashlidi.    ");
INSERT INTO uiglat_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","U waqitta Perwerdigar söz qilip: — — Méning Rohim insanlar bilen menggü küresh qiliwermeydu; chünki insan ettur, xalas. Kelgüside ularning ömri peqet bir yüz yigirme yashtin ashmisun! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Shu künlerde (we shundaqla kéyinki künlerdimu), Xudaning oghulliri insanlarning qizlirining yénigha bérip, ulardin balilarni tapqinida, gigantlar yer yüzide peyda boldi. Bular bolsa qedimki zamanlardiki dangliq palwan-baturlar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Perwerdigar insanning ötküzüwatqan rezilliki yer yüzide köpiyip ketkenlikini, ularning könglidiki niyetlirining herqachan yaman boluwatqinini kördi.    ");
INSERT INTO uiglat_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Shuning bilen Perwerdigar yer yüzide ademni apiride qilghinigha pushayman qilip, könglide azablandi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Buning bilen Perwerdigar: — Özüm yaratqan insanni yer yüzidin yoqitimen — insandin tartip mal-charwilarghiche, ömiligüchi haywanlardin asmandiki qushlarghiche, hemmisini yoq qilimen; chünki Men ularni yaratqinimgha pushaymen qildim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Lékin Nuh bolsa Perwerdigarning neziride shepqet tapqanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuh we uning ish-izliri töwendikiche: — Nuh heqqaniy, öz dewridikiler arisida eyibsiz adem idi; Nuh Xuda bilen bir yolda méngip yashaytti.    ");
INSERT INTO uiglat_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhtin Shem, Ham, Yafet dégen üch oghul töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Pütkül jahan Xudaning aldida rezilliship, hemme yer zorawanliqqa tolup ketkenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Xuda yer yüzige nezer séliwidi, mana, jahan rezilleshkenidi; chünki barliq et igilirining yer yüzide qiliwatqini yuzuqchiliq idi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Shuning bilen Xuda Nuhqa: — Mana, aldimgha barliq et igilirining zawalliqi yétip keldi; chünki pütkül yer-jahanni ularning sewebidin zorawanliq qaplidi. Mana, Men ularni yer bilen qoshup halak qilimen. ");
INSERT INTO uiglat_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Emdi sen özüngge gofer yaghichidin bir kéme yasap, kémining ichide bölme-xanilarni qilip, ichi-téshini qarimay bilen suwa. ");
INSERT INTO uiglat_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Sen uni shundaq yasighin: — Uzunluqi üch yüz gez, kengliki ellik gez we égizliki ottuz gez bolsun. ");
INSERT INTO uiglat_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kémining péshaywini astigha bir ochuqchiliq yasa, uning égizliki bir gez bolsun; ishikini kémining yénigha orunlashtur; kémini asti, ottura we üsti qilip üch qewet yasa. ");
INSERT INTO uiglat_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Chünki mana, Men Özüm asmanning astidiki hayatliq tiniqi barliki herbir et igisini halak qilidighan su topanni yer yüzige keltürimen; buning bilen yer yüzidiki barliq mexluqlar tiniqidin toxtaydu. ");
INSERT INTO uiglat_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Lékin sen bilen ehdemni tüzimen. Sen özüng, oghulliring, ayaling we kélinliringni élip birlikte kémige kiringlar. ");
INSERT INTO uiglat_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Özüng bilen teng tirik saqlap qélish üchün, barliq jandarlardin herqaysisidin bir jüp, yeni erkikidin birini, chishidin birini kémige élip kirgin; ");
INSERT INTO uiglat_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tirik qélish üchün qushlarning herbir türliridin, mal-charwilarning herbir türliridin we yerde ömiligüchi janiwarlarning herbir türliridin bir jüpi qéshinggha kiridu. ");
INSERT INTO uiglat_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Özüng we ularning ozuqluqi üchün herxil yémekliklerdin élip, yéninggha ghemligin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuh shundaq qildi; Xuda özige buyrughan hemme ishni u beja keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Perwerdigar Nuhqa mundaq dédi: — «Sen pütün öydikiliring bilen kémige kirgin; chünki bu dewrde aldimda séni heqqaniy dep kördüm. ");
INSERT INTO uiglat_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Hemme halal haywanlarning erkek-chishisidin yette jüptin, haram haywanlarning erkek-chishisidin bir jüptin élip, shuningdek asmandiki uchar-qanatlarningmu erkek-chishisidin yette jüptin élip, ularning neslini pütkül yer yüzide tirik saqlash üchün özüng bilen bille ekir.    ");
INSERT INTO uiglat_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Chünki yette kündin kéyin uda qiriq kéche-kündüz yer yüzige yamghur yaghdurimen; Özüm yasighan hemme janiwarlarni yer yüzidin yoqitimen». ");
INSERT INTO uiglat_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Shuning bilen Nuh Perwerdigar uninggha buyrughinining hemmisige emel qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yer yüzini topan basqanda Nuh alte yüz yashta idi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Topandin qutulup qélish üchün Nuh bilen oghulliri, ayali we kélinliri bille kémige kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Halal haywanlar bolsun, haram haywanlar bolsun, qushlar bilen yerde ömiligüchi janiwarlar bolsun, herbir türdin bir jüp-bir jüptin erkek-chishi bolup, Xuda Nuhqa buyrughandek kémige, Nuhning qéshigha kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","We shundaq boldiki, yette kündin kéyin, yer yüzini topan bésishqa bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhning ömrining alte yüzinchi yili, ikkinchi éyining on yettinchi künide chongqur déngizlarning tegliridiki barliq bulaqlar yérilip, asmanning penjiriliri échilip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yamghur uda qiriq kéche-kündüz yer yüzige toxtimay yaghdi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Del yamghur bashlan’ghan küni, Nuh, Nuhning Shem, Ham, Yafet dégen oghulliri, Nuhning ayali bilen üch kélini kémige kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ular bilen bille herxil yawa haywanlar tür-türi boyiche, herxil mal-charwilar tür-türi boyiche, yerde ömiligüchi herxil janiwarlar tür-türi boyiche we herxil uchar-qanatlar, yeni herxil qanatliq janiwarlar tür-türi boyiche kémige kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Et igiliridin, yeni barliq hayatliq tiniqi bolghan herxil jandarlardin, bir jüp-bir jüp bolup, kémige nuhning qéshigha kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kirgenler Xudaning Nuhqa buyrughinidek et igilirining hertürining erkek-chishisi idi. Andin Perwerdigar ishikni étiwetti. ");
INSERT INTO uiglat_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Topan yer yüzini uda qiriq kün bésip, sular ulghiyip ketti. Kéme yer üstidin kötürülüp leylep qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Su ulghiyip, yer üstide téximu égizlep ketti; kéme su üstide dawalghup turatti. ");
INSERT INTO uiglat_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Sular yer yüzide tolimu ulghiyip, pütkül asmanning astidiki barliq égiz taghlarnimu bésip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Sular taghlardin yene on besh gez örlep, tagh choqqilirimu su astida qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Buning bilen yer yüzide yürgüchi hemme et igiliri, uchar-qushlar, mal-charwilar, yawayi haywanlar, yerde ömiligüchi hemme janiwarlar, jümlidin pütkül ademler hemmisi öldi; ");
INSERT INTO uiglat_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","quruqluqta yashighuchi, burnida hayatliq tiniqi bar bolghanlarning hemmisi öldi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yer yüzidiki jéni barlarning hemmisi, insan bolsun, mal-charwilar bolsun, ömiligüchi haywanlar bolsun, asmandiki qushlar bolsun, hemmisi halak bolup yer yüzidin yoq qilindi; peqet Nuh we kémide uning bilen bille turghanlar qutulup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Bir yüz ellik kün’giche yer yüzini su bésip turdi.    ");
INSERT INTO uiglat_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Xuda Nuhni, shundaqla kémide uning bilen bille bolghan barliq yawayi haywanlar bilen barliq mal-charwilarni eslidi. Shuning bilen Xuda bir shamal chiqirip yer yüzini yelpütti we sular yénishqa bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Chongqur déngizlarning tegliridiki bulaqlar we asmanning penjiriliri étilip, asmandin tökülgen yamghur toxtidi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Sular barghanséri yer yüzidin yandi; bir yüz ellik kün ötkendin kéyin xéli azlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yettinchi ayning on yettinchi küni, kéme Ararat tagh tizmiliridiki birining üstide toxtap qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Sular oninchi ayghiche barghanséri aziyip, oninchi ayning birinchi küni tagh choqqiliri körünüshke bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Qiriq kündin kéyin Nuh kémige özi ornatqan derizini échip, ");
INSERT INTO uiglat_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","bir quzghunni sirtqa chiqardi. U yer yüzidiki sular tartilip bolghuche uyan-buyan uchup yürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Uningdin kéyin Nuh sularning yer yüzidin tartilghan-tartilmighanliqini bilish üchün, bir kepterni chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Lékin sular téxiche pütkül yer yüzini qaplap turghachqa, kepter putini qoyghudek jay tapalmay, Nuhning qéshigha kémige yénip keldi. Shuning bilen Nuh qolini sunup uni tutup, kémige ekiriwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","U yette kün saqlap, bu kepterni kémidin yene sirtqa chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kepter kechte uning qéshigha yénip keldi; mana, uning tumshuqida yéngi üzüwalghan zeytun yopurmiqi bar idi. Buni körüp Nuh sularning yer yüzidin tartilghinini bildi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","U yene yette kün saqlap, kepterni yene sirtqa chiqardi, emma bu qétim kepter uning yénigha qaytip kelmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuh alte yüz bir yashqa kirgen yili, birinchi ayning birinchi künide su yer yüzidin qurughanidi. Nuh kémining qapqiqini échip qariwidi, yerning qurughinini kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ikkinchi ayning yigirme yettinchi küni, yer yüzi pütünley qurup boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","U waqitta Xuda Nuhqa söz qilip: — Sen özüng, ayaling, oghulliring we kélinliring kémidin chiqinglar. ");
INSERT INTO uiglat_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Özüng bilen bille bolghan barliq et igiliridin herbir türdiki janiwarlarni, yeni uchar-qanatlarni hem mal-charwilarni, yerde ömiligüchi haywanlarning hemmisini özüng bilen qoshup kémidin élip chiqqin; shuning bilen ular yer yüzide tarilip-tarqilip, nesillinip zéminda köpeysun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Shuning bilen Nuh, ayali, oghulliri we kélinliri bilen bille sirtqa chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Janiwarlarning hemmisi, barliq ömiligüchi haywanlar, barliq uchar-qanatlar, yerde midirlap yüridighanlarning herqaysisi öz türliri boyiche kémidin chiqishti. ");
INSERT INTO uiglat_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Shu chaghda Nuh Perwerdigargha atap bir qurban’gahni yasidi; u halal janiwarlar bilen halal qushlarning her türidin élip kélip, qurban’gahning üstide «köydürme qurbanliq» ötküzdi.    ");
INSERT INTO uiglat_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Shundaq qilip Perwerdigar xushbuy purap memnun boldi; Perwerdigar könglide: — «Insanning köngül-niyiti yashliqidin tartip rezil bolsimu, Men insan tüpeylidin yerge yene lenet oqumaymen we emdi bu qétimqidek hemme jandarlarni urup yoqitiwetmeymen.    ");
INSERT INTO uiglat_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Bundin kéyin, yer mewjut künliride, Térish bilen orma, Soghuq bilen issiq, Yaz bilen qish, Kündüz bilen kéche üzülmey aylinip turidu» — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Xuda Nuh bilen uning oghullirigha bext-beriket ata qilip, ulargha mundaq dédi: — «Siler jüpliship köpiyip, yer yüzini toldurunglar. ");
INSERT INTO uiglat_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Yer yüzidiki barliq janiwarlar, asmandiki barliq qushlar, barliq yer yüzide midirlap yürgüchiler we déngizdiki barliq béliqlarning hemmisi silerdin qorqup wehimide bolsun; bular qolunglargha tapshurulghandur. ");
INSERT INTO uiglat_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Midirlap yüridighan herqandaq janiwarlar silerge ozuq bolidu; Men silerge kök otyashlarni bergendek, bularning hemmisini emdi silerge berdim. ");
INSERT INTO uiglat_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Lékin siler göshni ichidiki jéni, yeni qéni bilen qoshup yémeslikinglar kérek. ");
INSERT INTO uiglat_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Qéninglar, yeni jéninglardiki qan tökülse, Men berheq uning hésabini alimen; herqandaq haywanning ilkide qéninglar bar bolsa Men uninggha töletküzimen; insanning qolida bar bolsa, yeni birsining qolida öz qérindishining qéni bar bolsa, Men uninggha shu qanni töletküzimen. ");
INSERT INTO uiglat_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kimki insanning qénini tökse, Uning qénimu insan teripidin tökülidu; Chünki Xuda insanni Öz süret-obrazida yaratqandur. ");
INSERT INTO uiglat_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Emdi siler, jüpliship köpiyip, yer yüzide tarilip-tarqilip köpiyinglar». ");
INSERT INTO uiglat_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","9","Andin Xuda Nuh bilen uning oghullirigha söz qilip mundaq dédi: — «Mana Özüm siler bilen we silerdin kéyin kélidighan ewladliringlar bilen, shundaqla siler bilen bille turghan herbir jan igisi, ucharqanatlar, mal-charwilar, siler bilen bille turghan yer yüzidiki herbir yawayi haywanlar, kémidin chiqqanlarning hemmisi bilen — yer yüzidiki héchbir haywanni qaldurmay, ular bilen Öz ehdemni tüzimen. ");
INSERT INTO uiglat_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Men siler bilen shundaq ehde tüzimenki, ne barliq et igiliri topan bilen yoqitilmas, ne yerni weyran qilidighan héchbir topan yene kelmes». ");
INSERT INTO uiglat_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Xuda yene: — «Men Özüm siler bilen we qéshinglardiki hemme jan igiliri bilen menggülük, yeni pütkül ewladliringlarghiche békitken mushu ehdemning belgisi shuki: — Mana, Men Özüm bilen yerning otturisida bolghan ehdining belgisi bolsun dep hesen-hüsinimni bulutlar ichige qoyimen; ");
INSERT INTO uiglat_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","we shundaq boliduki, Men yerning üstige bulutlarni chiqarghinimda, shundaqla hesen-hüsen bulutlar ichide ayan bolghinida, Men siler bilen et igiliri bolghan barliq janiwarlar bilen tüzgen ehdemni yad étimen; buningdin kéyin sular hergiz hemme jandarlarni halak qilghuchi topan bolmas. ");
INSERT INTO uiglat_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Hesen-hüsen bulutlar arisida peyda bolidu; Men uninggha qaraymen we shuning bilen Menki Xuda yer yüzidiki et igiliri bolghan barliq janiwarlar bilen otturimizda békitken ehdemni yad étimen», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Xuda Nuhqa yene: — «Mana bu Men Özüm bilen yer yüzidiki barliq et igiliri otturisida békitken ehdemning nishan-belgisidur», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuhning kémidin chiqqan oghulliri Shem, Ham we Yafet idi. Ham Qanaanning atisi boldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Bu üchi Nuhning oghulliri bolup, pütkül yer yüzige taralghan ahale shularning nesil-ewladliridur. ");
INSERT INTO uiglat_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh tériqchiliq qilishqa bashlap, bir üzümzarliq berpa qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","U uning sharabidin ichip, mest bolup qélip, öz chédiri ichide kiyim-kécheklirini séliwétip, yalingach yétip qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Qanaanning atisi Ham kélip, atisining ewritini körüp, sirtqa chiqip ikki qérindishigha éytti. ");
INSERT INTO uiglat_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shem bilen Yafet qopup yépinjini élip, mürisige artip, keyniche méngip kirip, atisining yalingach bedinini yépip qoydi. Ular yüzini aldi terepke qilip, atisining yalingach ténige qarimidi. ");
INSERT INTO uiglat_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuh sharabning keypidin oyghinip, kenji oghlining özige néme qilghinini bilip: — ");
INSERT INTO uiglat_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Qanaan’gha lenet bolghay! U qérindashlirining qulining quli bolsun, — dep qarghidi. ");
INSERT INTO uiglat_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","U yene: — Shemning Xudasi bolghan Perwerdigargha teshekkür-medhiye keltürülgey! Qanaan Shemning quli bolsun. ");
INSERT INTO uiglat_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Xuda Yafetni awutqay! U Shemning chédirlirida turghay, Qanaan bolsa uning quli bolghay! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nuh topandin kéyin üch yüz ellik yil ömür kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Bu teriqide Nuh jemiy toqquz yüz ellik yil kün körüp, alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Töwendikiler Nuhning oghullirining ewladliridur: — uning oghulliri Shem, Ham we Yafet bolup, topandin kéyin ulardin oghullar törelgen: —      ");
INSERT INTO uiglat_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafetning oghulliri bolsa, Gomer, Magog, Maday, Yawan, Tubal, Meshek we Tiras idi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomerning ewladliri: Ashkinaz, Rifat we Togarmah idi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawanning ewladliri: Élishah, Tarshish, Kittiylar we Dodaniylar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Bularning ewladliri déngiz boylirida we arallarda ayrim-ayrim yashighan xelqler bolup, herqaysisi öz tili, öz aile-qebililiri boyiche öz zéminlirida tarqilip olturaqlashqan. ");
INSERT INTO uiglat_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamning oghulliri Kush, Misir, Put we Qanaanlar idi.    ");
INSERT INTO uiglat_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kushning oghulliri Séba, Hawilah, Sabtah, Raamah we Sabtika idi. Raamahning oghulliri Shéba we Dédan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushtin yene Nimrod törelgen; u yer yüzide nahayiti küchtünggür adem bolup chiqti.    ");
INSERT INTO uiglat_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","U Perwerdigarning aldida küchtünggür owchi boldi; shu sewebtin «palanchi bolsa Nimrodtek, Perwerdigarning aldida küchtünggür owchi iken» dégen gep tarqalghan. ");
INSERT INTO uiglat_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Uning padishahliqi Shinar zéminidiki Babil, Erek, Akkad we Kalneh dégen sheherlerde bashlan’ghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","U bu zémindin Ashur zéminigha chiqip Ninewe, Rehobot-Ir, Kalah we Ninewe bilen Kalahning otturisidiki Resen dégen sheherlernimu bina qildi (bular qoshulup «Katta Sheher» boldi). ");
INSERT INTO uiglat_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirning ewladliri Ludiylar, Anamiylar, Lehabiylar, Naftuhiylar, ");
INSERT INTO uiglat_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrosiylar, Kasluhiylar (Filistiyler Kasluhiylardin chiqqan) we Kaftoriylar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Qanaandin tunji oghul Zidon törilip, kéyin yene Het törelgen. ");
INSERT INTO uiglat_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","uning ewladliri bolsa Yebusiylar, Amoriylar, Girgashiylar, ");
INSERT INTO uiglat_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwiylar, Arqiylar, Siniylar, ");
INSERT INTO uiglat_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadiylar, Zemariylar we Hamatiylar idi. Shuningdin kéyin, Qanaaniylarning qebililiri her terepke tarqilip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Qanaaniylarning yurt chégrisi bolsa Zidondin tartip, Gerar teripige sozulup, Gazagha chiqip, andin Sodom, Gomorra, Admah bilen Zeboim teripige tutiship, Léshaghiche yétip baratti. ");
INSERT INTO uiglat_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Yuqiriqilar bolsa hamning oghulliri bolup, öz qebilisi we tilliri boyiche qowm bolup öz zéminlirida olturaqlashqanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemmu oghul perzentlik boldi; Shem bolsa Yafetning akisi, Éberlerning ata-bowisi boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shemning oghulliri Élam, Ashur, Arfaxshad, Lud, Aram; ");
INSERT INTO uiglat_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramning oghulliri Uz, Hul, Geter, Mash idi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxshadtin Shélah töreldi, Shélahtin Éber töreldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Éberdin ikki oghul törelgen bolup, birining ismi Peleg idi, chünki u yashighan dewrde yer yüzide bölünüsh boldi; Pelegning inisining ismi Yoqtan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoqtandin Almodad, Shelef, Xazarmawet, Yérah, ");
INSERT INTO uiglat_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO uiglat_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Shéba, ");
INSERT INTO uiglat_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawilah we Yobab töreldi. Bularning hemmisi Yoqtanning oghulliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ularning olturghan jayliri bolsa Méshadin tartip, Seffar dégen rayonning sherq teripidiki taghqiche sozulatti. ");
INSERT INTO uiglat_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yuqiriqilar bolsa Shemning oghulliri bolup, öz qebilisi we tilliri boyiche qowm bolup öz zéminlirida olturaqlashqanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yuqiridikiler Nuhning ewladliri bolup, ular öz nesebliri we qowmliri boyiche xatirilen’gen. Topandin kéyinki yer yüzidiki barliq qowmlar ularning ichidin tarqalghan.    ");
INSERT INTO uiglat_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","U zamanda pütkül yer yüzidiki til hem söz birxil idi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lékin shundaq boldiki, ademler meshriq terepke seper qilip, Shinar yurtida bir tüzlenglikni uchritip, shu yerde olturaqlashti. ");
INSERT INTO uiglat_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ular bir-birige: — Kélinglar, biz xish quyup, otta pishurayli! — déyishti. Shundaq qilip, ular qurulushta tashning ornigha xish, layning ornigha qarimay ishletti. ");
INSERT INTO uiglat_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ular yene: — Kélinglar, emdi özimizge bir sheher bina qilip, sheherde uchi asmanlargha taqashqudek bir munar yasayli! Shundaq qilip özimizge bir nam tikliyeleymiz. Bolmisa, pütkül yer yüzige tarilip kétimiz, — déyishti.    ");
INSERT INTO uiglat_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","U waqitta Perwerdigar adem baliliri bina qiliwatqan sheher bilen munarni körgili chüshti. ");
INSERT INTO uiglat_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Perwerdigar: — «Mana, bularning hemmisi bir qowmdur, ularning hemmisining tilimu birdur; bu ularning ishining bashlinishidur! Bundin kéyin ularning niyet qilghan herqandaq ishini héch tosuwalghili bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Shunga Biz töwen’ge chüshüp ularning bir-birining geplirini uqalmasliqi üchün ularning tilini bashqa-bashqa qilip qalaymiqanlashturuwéteyli» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Shundaq qilip Perwerdigar ularni u jaydin pütkül yer yüzige taritiwetti. Shuning bilen ular sheherni yasashtin toxtap qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Shunga bu sheherning nami «Babil» dep ataldi; chünki u yerde Perwerdigar pütkül yer yüzidikilerning tilini qalaymiqanlashturuwetti. Shundaq qilip Perwerdigar ularni u jaydin pütkül yer yüzige taritiwetti. ");
INSERT INTO uiglat_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Töwendikiler Shemning ewladliridur: — topan ötüp ikki yildin kéyin, Shem yüz yéshida, uningdin Arfakshad töreldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arfakshad tughulghandin kéyin Shem besh yüz yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfakshad ottuz besh yashqa kirgende uningdin Shélah töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shélah tughulghandin kéyin Arfakshad töt yüz üch yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shélah ottuz yashqa kirgende uningdin Éber töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Éber tughulghandin kéyin Shélah töt yüz üch yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Éber ottuz töt yashqa kirgende uningdin Peleg töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg tughulghandin kéyin Éber töt yüz ottuz yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg ottuz yashqa kirgende uningdin Reu töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu tughulghandin kéyin Peleg ikki yüz toqquz yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu ottuz ikki yashqa kirgende uningdin Sérug töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Sérug tughulghandin kéyin Reu ikki yüz yette yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sérug ottuz yashqa kirgende uningdin Nahor töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahor tughulghandin kéyin Sérug ikki yüz yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor yigirme toqquz yashqa kirgende uningdin Terah töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terah tughulghandin kéyin Nahor bir yüz on toqquz yil ömür körüp, uningdin yene oghul-qizlar töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah yetmish yashqa kirgende uningdin Abram, Nahor we Haran töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terahning ewladliri töwendikiche: — Terahtin Abram, Nahor we Haran töreldi; Harandin Lut töreldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Lékin Haran tughulghan yurti bolghan, kaldiylerning Ur shehiride atisi Terahning aldida, Terahtin ilgiri öldi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram bilen Nahor ikkisi öylendi. Abramning ayalining ismi Saray, Nahorning ayalining ismi Milkah idi; Milkah Haranning qizi idi; Haran bolsa Milkah we Iskahning atisi idi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Lékin Saray tughmas bolghachqa, uning balisi yoq idi. ");
INSERT INTO uiglat_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah bolsa oghli Abramni, newrisi Lut (Haranning oghli)ni we kélini, yeni Abramning ayali Sarayni élip, Qanaan zéminigha bérish üchün kaldiylerning Ur shehiridin yolgha chiqti; biraq ular Haran dégen jaygha yétip kelgende, shu yerde olturaqliship qaldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terahning körgen künliri ikki yüz besh yil bolup, Haranda alemdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Perwerdigar eslide Abramgha mundaq dégenidi: — Sen öz yurtungdin, öz uruq-tughqanliringdin we öz ata jemetingdin ayrilip, Men sanga körsitidighan zémin’gha barghin. ");
INSERT INTO uiglat_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Shundaq qilsang Men séni ulugh bir xelq qilip, sanga bext-beriket ata qilip, namingni ulugh qilimen; shuning bilen sen özüng bashqilargha bext-beriket bolghin; ");
INSERT INTO uiglat_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","kimler sanga bext-beriket tilise Men ularni beriketleymen, kimki séni xorlisa, Men choqum uni lenetke qaldurimen; sen arqiliq yer yüzidiki barliq aile-qebililerge bext-beriket ata qilinidu! — dédi.      ");
INSERT INTO uiglat_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram Perwerdigar uninggha éytqini boyiche Harandin ayrildi; Lutmu uning bilen bille mangdi. Abram Harandin chiqqinida yetmish besh yashta idi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram ayali Saray bilen inisining oghli Lutni élip, ularning yighqan barliq mal-mülükini qoshup, Haranda igidarchiliq qilghan ademlerni bille qétip, Qanaan zéminigha bérish üchün yolgha chiqti; shundaq qilip ular Qanaan zéminigha yétip keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram zéminni kézip, Shekem dégen jaydiki «Morehning dub derixi»ning yénigha keldi (u chaghda u zéminda Qanaaniylar turatti). ");
INSERT INTO uiglat_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Perwerdigar Abramgha körünüp, uninggha: — Men bu zéminni séning neslingge ata qilimen, — dédi. Shuning bilen u shu yerde özige körün’gen Perwerdigargha atap bir qurban’gah saldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Andin u bu yerdin yötkilip, Beyt-Elning sherqidiki taghqa bardi; gherb teripide Beyt-El, sherq teripide Ayi dégen jay bar idi; u shu yerde chédir tikti. U shu yerde Perwerdigargha atap bir qurban’gah yasap, Perwerdigarning namini chaqirip ibadet qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Andin kéyin Abram tedrijiy köchüp, jenubidiki Negew rayonigha qarap yötkeldi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Zéminda acharchiliq bolghanidi; Abram Misirgha chüshti; u shu yerde waqtinche turmaqchi bolghanidi, chünki zéminda acharchiliq bek éghir idi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Emma shundaq boldiki, u Misirgha yéqinlashqanda, ayali Saraygha: — Mana, men séning hösün-jamalingning güzellikini bilimen. ");
INSERT INTO uiglat_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Shundaq boliduki, misirliqlar séni körse, «Bu uning ayali iken» dep, méni öltürüwétip, séni tirik qalduridu. ");
INSERT INTO uiglat_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Shuning üchün séning: «Men uning singlisi» déyishingni ötinimen. Shundaq qilsang, men séningdin yaxshiliq tépip, sen arqiliq tirik qalimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram Misirgha kirgende shundaq boldiki, misirliqlar derweqe ayalning güzel ikenlikini kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pirewnning emirlirimu uni körüp, Pirewn’ge uning teripini qildi; shuning bilen ayal Pirewnning ordisigha élip kirildi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pirewn Sarayning sewebidin Abramgha yaxshi muamile qildi; shuning bilen u qoy, kala, hangga éshekler, qul-dédekler, mada éshekler we tögilerge érishti. ");
INSERT INTO uiglat_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Emma Perwerdigar Pirewn we öyidikilirini Abramning ayali Sarayning sewebidin tolimu éghir wabalargha muptila qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Shuning üchün Pirewn Abramni chaqirip uninggha: — «Bu zadi séning manga néme qilghining? Némishqa uning öz ayaling ikenlikini manga éytmiding? ");
INSERT INTO uiglat_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Némishqa uni «singlim» dep méning uni xotunluqqa élishimgha sewebkar bolghili tas qalisen! Mana bu ayaling! Uni élip ketkin! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pirewn öz ademlirige Abram toghrisida emr qildi; ular uni, ayalini we uning barliqini qoshup yolgha séliwetti. ");
INSERT INTO uiglat_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Shuning bilen Abram ayali we uning barliq nersilirini hemde Lutni élip Misirdin chiqip, Qanaanning jenubidiki Negew yurtigha mangdi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","U chaghda Abramning mal-waran we altun-kümüshliri köp bolup, xélila bay idi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","U köchüp yürüp, jenubtiki Negewdin Beyt-Elge, yeni Beyt-El bilen Ayining otturisidiki eslide chédir tikken jaygha, ");
INSERT INTO uiglat_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","qurban’gah yasighan jaygha qaytip keldi. Abram shu yerde Perwerdigarning namini chaqirip ibadet qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abram bilen bille mangghan Lutningmu qoy-kala padiliri we chédirliri bar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Emdi ular bille tursa, zémin ularni qamdiyalmaytti; ");
INSERT INTO uiglat_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","bu sewebtin Abramning padichiliri bilen Lutning padichilirining arisida jédel chiqti (u waqitta Qanaaniylar bilen Perizziyler shu zéminda turatti).    ");
INSERT INTO uiglat_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Shunga Abram Lutqa: — «Biz bolsaq qérindashlarmiz, sen bilen méning aramda, méning padichilirim bilen séning padichiliring arisida talash-tartish peyda bolmisun. ");
INSERT INTO uiglat_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mana, aldingda pütkül zémin turmamdu? Emdi sen mendin ayrilghin; eger sen sol terepke barsang, men ong terepke baray; eger sen ong terepke barsang, men sol terepke baray», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","U waqitta Lut nezer sélip kördiki, Iordan wadisidiki barliq tüzlenglikning Zoar shehirigiche hemmila yerning süyi intayin mol idi; Perwerdigar Sodom bilen Gomorrani weyran qilishtin ilgiri bu yer beeyni Perwerdigarning béghi, Misir zéminidek idi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Shuning bilen Lut özige Iordan wadisidiki pütkül tüzlenglikni talliwaldi; andin Lut meshriq terepke köchüp bardi. Shundaq qilip ikkiylen ayrildi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram Qanaan zéminida olturaqlashti; Lut bolsa tüzlengliktiki sheherlerning arisida turdi; u bara-bara chédirlirini Sodom shehiri terepke yötkidi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom xelqi rezil ademler bolup, Perwerdigarning neziride tolimu éghir gunahkarlar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut Abramdin ayrilip ketkendin kéyin, Perwerdigar Abramgha: — Sen emdi béshingni kötürüp, özüng turghan jaydin shimal we jenubqa, meshriq we meghrib terepke qarighin; ");
INSERT INTO uiglat_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","chünki sen hazir körüwatqan bu barliq zéminni sanga we neslingge menggülük bérimen.    ");
INSERT INTO uiglat_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Séning neslingni yerdiki topidek köp qilimen; shundaqki, eger birsi yerdiki topini sanap chiqalisa, séning neslingnimu sanap chiqalishi mumkin bolidu. ");
INSERT INTO uiglat_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ornungdin tur, bu zéminni uzunluqi we kengliki boyiche aylinip chiqqin; chünki Men uni sanga ata qilimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Shunga Abram chédirlirini yötkep, Hébron shehirige yéqin Mamrediki dubzarliqning yénigha bérip olturaqlashti; u shu yerde Perwerdigargha atap bir qurban’gah yasidi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Shinarning padishahi Amrafel, Ellasarning padishahi Arioq, Élamning padishahi Kédorlayomer we Goyimning padishahi Tidalning künliride shu weqe boldiki, ");
INSERT INTO uiglat_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ular birliship Sodomning padishahi Béra, Gomorraning padishahi Birsha, Admahning padishahi Shinab, Zeboimning padishahi Shem’éber we Béla (yeni Zoar)ning padishahigha qarshi hujumgha atlandi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bu beshining hemmisi kéliship Siddim wadisigha, yeni «Shor Déngizi» wadisigha yighildi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ular on ikki yil Kédorlayomerge béqindi boldi, on üchinchi yilgha kelgende, Kédorlayomerge qarshi isyan kötürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","On tötinchi yili Kédorlayomer we uninggha ittipaqdash bolghan padishahlar hemmisi yighilip, Ashtarot-Karnaim dégen yerde Refayiylargha, shundaqla Ham dégen yerde Zuziylargha, Shaweh-Kiriatayimda Émiylargha hujum qilip ularni yengdi; ");
INSERT INTO uiglat_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","andin ular Horiylarni ularning Séir téghida meghlup qilip, chölning yénidiki El-Paran’ghiche sürüp-toqay qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Arqidinla, ular En-Mishpatqa (yeni Qadeshke) yénip kélip, Amaleklerning pütkül yurtini bulang-talang qildi; Hazazon-Tamarda olturushluq Amoriylarnimu hujum qilip meghlup qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Shuning bilen Sodomning padishahi, Gomorraning padishahi, Admahning padishahi, Zeboimning padishahi we Bélaning (yeni Zoarning) padishahi chiqip, Siddim wadisida ulargha qarshi jeng qilishqa sep tizdi; ");
INSERT INTO uiglat_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mushu besheylen Élamning padishahi Kédorlayomer, Goyimning padishahi Tidal, Shinarning padishahi Amrafel, Ellasarning padishahi Arioq qatarliqlar bilen soqushti; yeni töt padishah bilen besh padishah özara soqushti. ");
INSERT INTO uiglat_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddim wadisidiki hemmila yerde qarimay orekliri bar idi. Sodom we Gomorraning padishahliri qéchip, oreklerge chüshüp ketti. Emma qalghanlar bolsa taghqa qéchip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ghalib kelgen töt padishah bolsa Sodom bilen Gomorraning hemme mal-mülkini we barliq ozuq-tülükini élip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ular yene Abramning jiyeni Lutnimu malliri bilen qoshup élip ketti; chünki u Sodomda olturaqlashqanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Halbuki, qutulup qalghan birsi bérip bu ishlarni ibraniy Abramgha éytti. Shu chaghda u Amoriy Mamrening dubzarliqining yénida turatti. Mamre bolsa Eshkol we Anerning akisi idi; bu ücheylen Abram bilen ittipaqdash idi.    ");
INSERT INTO uiglat_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram qérindishining esir bolup qalghanliqini anglap, öz öyide tughulghan, alahide terbiyilen’gen üch yüz on sekkiz ademni bashlap chiqip, töt padishahni qoghlap dan’ghiche bardi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kéchisi u ademlirini guruppilargha bölüp, ular bilen birlikte hujum qilip ularni meghlup qilip, ularni Demeshqning shimal teripidiki Hobah dégen jayghiche qoghlap bérip, ");
INSERT INTO uiglat_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","pütkül olja alghan mal-mülükni qayturuwaldi; öz qérindishi Lutni, uning mal-mülki we xotun-qizlirini, shundaqla barliq qalghan ademlerni yandurup keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram Kédorlayomer we uning bilen ittipaqdash padishahlarni meghlup qilip, qaytip kelgende, Sodomning padishahi Shaweh wadisi (yeni Xan wadisi)gha uning aldigha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salémning padishahi Melkizedekmu nan bilen sharab élip aldigha chiqti. U zat bolsa, Hemmidin Aliy Tengrining kahini idi;    ");
INSERT INTO uiglat_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","u Abramni bext-beriketlep: — «Abram asman bilen zéminning Igisi bolghan Hemmidin Aliy Tengri teripidin beriketlensun! ");
INSERT INTO uiglat_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Shundaqla düshmenliringni öz qolunggha tapshurghan Hemmidin Aliy Tengrige Hemdusana oqulghay!» — dédi. Abram bolsa gheniymet alghan nersilerning ondin birini uninggha berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Andin Sodomning padishahi Abramgha: — Ademlerni manga bergeyla, gheniymetlerni özlirige alghayla, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Lékin Abram Sodomning padishahigha jawab bérip: — Men bolsam asman bilen zéminning Igisi bolghan Hemmidin Aliy Tengri Perwerdigargha qol kötürüp qesem qilghanmenki, ");
INSERT INTO uiglat_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","men sendin hetta bir tal yip ne bir tal boghquchinimu ne séning bashqa herqandaq nersengni almaymen; bolmisa, sen kéyin: «men Abramni bay qilip qoydom» déyishing mumkin. ");
INSERT INTO uiglat_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Shunga yigitlirimning yégen-ichkini, shundaqla manga hemrah bolghanlar, yeni Aner, Eshkol we Mamrelerge tégishlik ülüshtin bashqa, men gheniymettin héchnerse almaymen; shular özlirige tégishlik ülüshini alsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bu ishlardin kéyin Perwerdigarning söz-kalami Abramgha alamet körünüshte kélip: «Ey Abram, qorqmighin; Men Özüm qalqining we zor in’amingdurmen» — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Lékin Abram: — Ey Reb Perwerdigar, manga néme bérisen? Mana, men balisiz tursam, öy-bisatlirimgha warisliq qilghuchi mushu Demeshqlik Eliézerla bardur, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram yene: Mana, Sen manga héch nesil bermiding, mana öyümde turuwatqanlardin biri manga waris bolidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Shu haman Perwerdigarning söz-kalami uninggha kélip: «Bu kishi sanga waris bolmaydu, belki öz pushtungdin bolidighan kishi sanga waris bolidu», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Shuning bilen Perwerdigar uni tashqirigha élip chiqip: — Emdi asman’gha qarap yultuzlarni sana — Qéni, ularni saniyalamsenkin?! — dédi. Andin uninggha: — Séning neslingmu shundaq bolidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram Perwerdigargha ishendi; Perwerdigar uningdiki bu ishenchni uning heqqaniyliqi dep hésablidi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yene uninggha: Men bu zémin’gha ige qilishqa séni Kaldiyediki Ur shehiridin élip chiqqan Perwerdigardurmen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Lékin Abram: — I Reb Perwerdigar, men uninggha jezmen ige bolidighinimni qandaq bilimen? — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Perwerdigar uninggha: — Men üchün üch yashliq bir inek, üch yashliq bir chishi öchke, üch yashliq bir qochqar bilen bir kepter we bir bachka élip kelgin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Shunga u bularning hemmisini élip, ularning herbirsini yérimdin ikki parche qilip, yérimini yene bir yérimigha udulmu’udul qilip qoyup qoydi; emma qushlarni parchilimidi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Qagha-quzghunlar taplarning üstige chüshkende, Abram ularni ürkütüp heydiwetti. ");
INSERT INTO uiglat_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Lékin kün patay dégende, Abramni éghir bir uyqu basti we mana, uning üstige dehshetlik bir wehime, tum qarangghuluq chüshti. ");
INSERT INTO uiglat_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Andin Perwerdigar Abramgha: — Jezmen bilishing kérekki, séning nesling özlirining bolmighan bir zéminda musapir bolup, shu yerdiki xelqning qulluqida bolidu we shundaqla, bu xelq ulargha töt yüz yilghiche jebir-zulum salidu.    ");
INSERT INTO uiglat_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Lékin Men ularni qulluqqa salghuchi shu taipining üstidin höküm chiqirimen. Kéyin ular nurghun bayliqlarni élip shu yerdin chiqidu. ");
INSERT INTO uiglat_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Emma sen bolsang, aman-xatirjemlik ichide ata-bowiliringgha qoshulisen; uzun ömür körüp andin depne qilinisen.    ");
INSERT INTO uiglat_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Lékin shu yerde töt ewlad ötüp, nesling bu yerge yénip kélidu; chünki Amoriylarning qebihlikining zixi téxi toshmidi, dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Shundaq boldiki, kün pétip qarangghu bolghanda, mana, göshlerning otturisidin ötüp kétiwatqan, is-tütek chiqip turghan bir otdan bilen yalqunluq bir mesh’el köründi. ");
INSERT INTO uiglat_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","19","Del shu küni Perwerdigar Abram bilen ehde tüzüp uninggha: — «Men séning neslingge bu zéminni Misirning éqinidin tartip Ulugh derya, yeni Efrat deryasighiche bérimen; yeni Kéniyler, Kenizziylar, Kadmoniylar, ");
INSERT INTO uiglat_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hittiylar, Perizziyler, Refayiylar, ");
INSERT INTO uiglat_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoriylar, Qanaaniylar, Girgashiylar we Yebusiylarning yurtini ularningki qilimen» dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Emma Abramning ayali Saray uninggha héch bala tughup bermidi; lékin uning Hejer isimlik misirliq bir dédiki bar idi; ");
INSERT INTO uiglat_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saray Abramgha: — Mana, Perwerdigar méni tughushtin tosti. Emdi sen méning dédikimning qéshigha kirgin; belkim u arqiliq ana bolup tiklinishim mumkin, — dédi. Abram bolsa Sarayning sözini qobul kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Shuning bilen Abramning ayali Saray dédiki misirliq Hejerni öz éri Abramgha toqalliqqa apirip berdi (u waqitta Abram Qanaan zéminida on yil olturghanidi). ");
INSERT INTO uiglat_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram Hejerning qéshigha kirdi we u hamilidar boldi. Emma u özining hamilidar bolghinini bilginide, u ayal xojayinini közge ilmas bolup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saray Abramgha qéyidap: — Manga chüshken bu xorluq séning béshinggha chüshsun! Men öz dédikimni quchiqinggha sélip berdim; emdi u özining hamilidar bolghinini körgende men uning neziride közge ilinmidim. Xeyr, Perwerdigar sen bilen méning otturimizda höküm chiqarsun! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram Saraygha: — Mana, dédiking öz qolungdidur; sanga néme layiq körünse uninggha shuni qilghin, — dédi. Buning bilen Saray uninggha qattiqliq qilishqa bashlidi; buning bilen u uning aldidin qéchip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Emma Perwerdigarning Perishtisi uni chöldiki bir bulaqning yénida, yeni Shur yolining boyidiki bulaqning yénidin tépip, uninggha: ");
INSERT INTO uiglat_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ey Sarayning dédiki Hejer, nedin kelding, nege barisen? — dep soridi. U jawab bérip: — Men xojayinim Sarayning aldidin qéchip chiqtim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Perwerdigarning Perishtisi uninggha: — Ayal xojayiningning qéshigha qaytip bérip, uning qol astida bol, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Perwerdigarning Perishtisi uninggha yene: — Séning neslingni shundaq awutimenki, köplükidin uni sanap bolghili bolmaydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Andin Perwerdigarning Perishtisi uninggha: Mana, sen hamilidarsen; sen bir oghul tughup, uninggha Ismail dep at qoyghin; chünki Perwerdigar séning jebir-japayingni anglidi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","U yawa éshek kebi bir adem bolidu; uning qoli her ademge qarshi uzitilidu, shuningdek her ademning qoli uninggha qarshi uzitilidu; u qérindashlirining udulida ayrim turidu, dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hejer öz-özige: «Men mushu yerde méni Körgüchini arqisidin kördüm» dep, özige söz qilghan Perwerdigarni: «Sen méni körgüchi Tengridursen» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Shuning bilen u quduq: «Beer-lahay-roy» dep ataldi. U Qadesh bilen Bered shehirining ariliqididur.    ");
INSERT INTO uiglat_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hejer Abramgha bir oghul tughup berdi. Abram Hejer uninggha tughup bergen oghligha Ismail dep at qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hejer Abramgha Ismailni tughup bergende Abram seksen alte yashta idi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram toqsan toqquz yashqa kirgende, Perwerdigar Abramgha körünüp uninggha: — Men Qadir Tengridurmen. Sen Méning aldimda méngip, kamil bolghin.    ");
INSERT INTO uiglat_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Men Özüm bilen séning arangda ehdemni békitip, séni intayin zor köpeytimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram özini tashlap yüzini yerge yéqip yatti; Xuda uning bilen yene sözliship mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Özümge kelsem, mana, Méning ehdem sen bilen tüzülgendur: — Sen nurghun el-milletlerning atisi bolisen.    ");
INSERT INTO uiglat_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Shuning üchün séning isming buningdin kéyin Abram atalmaydu, belki isming Ibrahim bolidu; chünki Men séni nurghun el-milletlerning atisi qildim. ");
INSERT INTO uiglat_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Men séni intayin zor köpeytimen; shuning bilen sendin köp el-qowmlarni peyda qilimen, pushtungdin padishahlar chiqidu. ");
INSERT INTO uiglat_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Men sen we sendin kéyinki neslingning Xudasi bolush üchün Özüm sen we sendin kéyinki neslingning arisida ebediy ehde süpitide bu ehdemni tikleymen; ");
INSERT INTO uiglat_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Men sanga we sendin kéyinki neslingge sen hazir musapir bolup turghan bu zéminni, yeni pütkül Qanaan zéminini ebediy bir mülük süpitide ata qilimen; we Men ularning Xudasi bolimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Andin Xuda Ibrahimgha yene: — Sen özüng Méning ehdemni tutqin, özüng we sendin kéyinki neslingmu ewladtin-ewladqa buni tutushi kérek. ");
INSERT INTO uiglat_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Men sen bilen we sendin kéyinki nesling bilen tüzgen, silerning tutushunglar kérek bolghan ehdem shuki, aranglardiki herbir erkek xetne qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Shuning bilen siler xetnilikinglarni késiwétishinglar kérek; bu Men bilen silerning aranglardiki ehdining belgisi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Barliq ewladliringlar, nesildin-nesilge aranglarda, meyli öyde tughulghanlar bolsun, yaki ewladinglardin bolmay yatlardin pulgha sétiwélin’ghanlar bolsun, hemme erkek sekkiz künlük bolghanda xetne qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Öyüngde tughulghanlar bilen pulunggha sétiwalghanlarning hemmisi xetne qilinishi kérek. Shundaq qilghanda, Méning ehdem tenliringlarda ornap, ebediy bir ehde bolidu. ");
INSERT INTO uiglat_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Lékin xetniliki turup, téxi xetne qilinmighan herbir erkek Méning ehdemni buzghan hésablinip, üzüp tashlinidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Xuda Ibrahimgha yene söz qilip: — Ayaling Sarayni emdi Saray dep atimighin, belki ismi Sarah bolsun. ");
INSERT INTO uiglat_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Men uninggha bext-beriket bérip, uningdinmu sanga bir oghul bérimen. Men derweqe uni beriketleymen; shuning bilen u el-milletlerning anisi bolidu; xelqlerning padishahlirimu uningdin chiqidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrahim yene özini yerge étip düm yétip külüp ketti we könglide: «Yüz yashqa kirgen ademmu baliliq bolalarmu? Toqsan yashqa kirgen Sarahmu bala tugharmu?!», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ibrahim Xudagha: — Ah, Ismail aldingda yashisa idi! dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Xuda uninggha: — Yaq, ayaling Sarah jezmen sanga bir oghul tughup béridu. Sen uninggha «Ishaq» dep at qoyghin. Men uning bilen öz ehdemni tüzimen; bu uningdin kéyin kélidighan nesli bilen baghlighan ebediy bir ehde süpitide bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismailgha kelsek, uning toghrisidiki duayingni anglidim. Mana, Men uni beriketlep, neslini köpeytip, intayin zor awutimen. Uning pushtidin on ikki emir chiqidu; Men uni ulugh bir xelq qilimen.    ");
INSERT INTO uiglat_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Biraq ehdemni bolsa Men kéler yili del mushu waqitta Sarah sanga tughup béridighan oghul — Ishaq bilen tüzimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Xuda Ibrahim bilen sözliship bolup, uning yénidin yuqirigha chiqip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Shuning bilen shu künila Ibrahim öz oghli Ismailni, öz öyide tughulghanlar we pulgha sétiwalghanlarning hemmisini, yeni uning öyidiki barliq erkeklerni élip, Xuda uninggha éytqandek ularning xetnilikini késip xetne qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahimning xetniliki késilip, xetne qilin’ghanda, toqsan toqquz yashqa kirgenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Uning oghli Ismailning xetniliki késilip, xetne qilin’ghanda, on üch yashta idi. ");
INSERT INTO uiglat_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Ibrahim bilen uning oghli Ismail del shu künning özide xetne qilindi we shundaqla uning öyidiki hemme er kishiler, meyli öyide tughulghan bolsun yaki yattin pulgha sétiwélin’ghanlar bolsun, hemmisi uning bilen bille xetne qilindi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Perwerdigar Mamrediki dubzarliqning yénida Ibrahimgha köründi; bu kün eng issighan waqit bolup, u öz chédirining ishikide olturatti. ");
INSERT INTO uiglat_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","U béshini kötürüp nezer séliwidi, mana uning udulida üch kishi öre turatti. Ularni körüp u chédirining ishikidin qopup, ularning aldigha yügürüp bérip, yerge tegküdek tezim qilip: ");
INSERT INTO uiglat_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","— i Rebbim, eger péqir nezerliride iltipat tapqan bolsam, ötünimenki, qullirining yénidin ötüp ketmigeyla; ");
INSERT INTO uiglat_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","azghina su keltürülsun, siler putliringlarni yuyup derexning tégide aram éliwélinglar. ");
INSERT INTO uiglat_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Siler öz qulunglarning yénidin ötkenikensiler, men bir chishlem nan élip chiqay, siler harduqunglarni chiqirip, andin ötüp ketkeysiler, dédi. Ular jawab bérip: — Éytqiningdek qilghin, déwidi, ");
INSERT INTO uiglat_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibrahim chédirigha Sarahning qéshigha yügürüp kirip, uninggha: — Üch das ésil undin téz xémir yughurup toqach etkin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Andin Ibrahim kala padisigha yügürüp bérip, yumran obdan bir mozayni tallap, chakirigha tapshurdi; u buni tézla teyyar qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","9","Andin Ibrahim sériq may, süt we teyyarlatqan mozayni élip kélip, ularning aldigha tutup, özi derexning tégide ularning aldida öre turdi; ular ulardin yédi. Ular uningdin: ayaling Sarah nede, dep soriwidi, u jawab bérip: — Mana, chédirda, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Birsi: — Men kéler yili mushu waqitta qéshinggha jezmen qaytip kélimen, we mana u waqitta ayaling Sarahning bir oghli bolidu, — dédi. Sarah bolsa uning keynidiki chédirning ishikide turup, bularni anglawatatti.    ");
INSERT INTO uiglat_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibrahim bilen Sarah ikkisi yashinip, qérip qalghanidi; Sarahta ayal kishilerde bolidighan adet körüsh toxtap qalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Shunga Sarah öz ichide külüp: — Men shunche qérip ketken tursam, rasttinla lezzet körelermenmu? Érimmu qérip ketken tursa? — dep xiyal qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Perwerdigar Ibrahimgha: — Sarahning: «Men qérip ketken tursam, rasttinla bala tugharmenmu?» dep külgini némisi? ");
INSERT INTO uiglat_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Perwerdigargha mumkin bolmaydighan tilsimat ish barmu? Békitken waqitta, yeni kéler yili del bu chaghda qaytip kélimen we u waqitta Sarahning bir oghli bolidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Emma Sarah qorqup kétip: — Külmidim, dep inkar qildi. Lékin U: — Yaq, sen küldüng, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Andin bu zatlar u yerdin qopup, Sodom terepke nezirini aghdurdi. Ibrahimmu ularni uzitip, ular bilen bille mangdi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Perwerdigar: — Men qilidighan ishimni Ibrahimdin yoshursam bolamdu? ");
INSERT INTO uiglat_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Chünki Ibrahimdin ulugh we küchlük bir el chiqidu we shuningdek yer yüzidiki barliq el-milletler u arqiliq bext-beriketke muyesser bolidighan tursa? ");
INSERT INTO uiglat_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Chünki Men uni bilip tallighanmen; u choqum öz balilirini we uning öyidikilerni özige egeshtürüp, ulargha Perwerdigarning yolini tutup, heqqaniyliqni we adaletni yürgüzüshni ögitidu. Buning bilen Menki Perwerdigar Ibrahim toghruluq qilghan wedemni emelge ashurimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Andin Perwerdigar mundaq dédi: — «Sodom we Gomorra toghruluq kötürülgen dad-peryad nahayiti küchlük, ularning gunahi intayin éghir bolghini üchün, ");
INSERT INTO uiglat_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Men hazirla chüshimen, qilmishliri rasttinla shu dad-peryadlardin Manga melum bolghandek shunche rezilmu, bilip baqay; unche rezil bolmighandimu, Men uni bilishim kérek». ");
INSERT INTO uiglat_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Shuning bilen bu kishiler u yerdin qozghilip, Sodom terepke yol aldi. Lékin Ibrahim yenila Perwerdigarning aldida öre turatti. ");
INSERT INTO uiglat_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ibrahim yéqin bérip: — Sen rasttinla heqqaniylarni reziller bilen qoshup halak qilamsen? ");
INSERT INTO uiglat_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Sheherde ellik heqqaniy kishi bar bolushi mumkin; Sen rasttinla shu jayni halak qilamsen, ellik heqqaniy kishi üchün u jayni kechürüm qilmamsen? ");
INSERT INTO uiglat_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Yaq, yaq. Bu ish Sendin néri bolghay! Heqqaniylarni rezillerge qoshup öltürüp, heqqaniylargha rezillerge oxshash muamile qilish Sendin néri bolghay! Pütkül jahanning soraqchisi adalet yürgüzmemdu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Perwerdigar jawab bérip: — Eger Men Sodom shehiride ellik heqqaniyni tapsam, ular üchün pütkül jayni ayap qalimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Andin Ibrahim jawab bérip: — Mana men peqet topa bilen küldin ibaret bolsammu, men Igem bilen sözleshkili yene pétinalidim. ");
INSERT INTO uiglat_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mubada shu ellik heqqaniydin besh kishi kem bolsa, Sen bu besh kishining kem bolghini üchün pütkül sheherni yoqitamsen? — dédi. U: — Eger Men shu yerde qiriq beshni tapsammu, uni yoqatmaymen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrahim Uninggha sözini dawam qilip: — Shu yerde qiriq kishila tépilishi mumkin, déwidi, Perwerdigar: — Bu qiriqi üchün uni yoqatmaymen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","U yene söz qilip: I Igem, xapa bolmighaysen, men yene söz qilay. Shu yerde ottuzi tépilishi mumkin? — dédi. U: — Eger Men u yerde ottuzni tapsammu, yoqatmaymen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","U yene söz qilip: — Mana emdi men Igem bilen sözleshkili jür’et qildim; shu yerde yigirmisi tépilishi mumkin, — dédi. Perwerdigar söz qilip: bu yigirmisi üchün u yerni yoqatmaymen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","U sözlep: — I Igem, xapa bolmighay, men peqet mushu bir qétimla söz qilay! Shu yerde oni tépilishi mumkin, déwidi, u jawab bérip: — Men oni üchün uni yoqatmaymen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Perwerdigar Ibrahim bilen sözliship bolghandin kéyin ketti; Ibrahimmu öz jayigha qaytip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ikki perishte kechte Sodomgha yétip keldi; shu chaghda Lut Sodomning derwazisida olturatti. Lut ularni körüpla ornidin turup, aldigha chiqip yüzi yerge tegküdek tezim qilip: ");
INSERT INTO uiglat_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","— Mana, ey xojilirim, keminilirining öyige chüshüp putliringlarni yuyup qonup qalghaysiler; andin ete seher qopup yolgha chiqsanglarmu bolidu, déwidi, bular jawaben: — Yaq, biz sheher meydanida kechleymiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Emma u ularni ching tutuwidi, axir ular uning bilen bérip öyige kirdi. U ulargha dastixan sélip, pétir toqachlarni pishurup berdi, ular ghizalandi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ular téxi yatmighanidi, sheherdikiler, yeni Sodomning erkekliri, yash, qéri hemmisi herqaysi mehellilerdin kélip öyni qorshiwaldi; ");
INSERT INTO uiglat_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ular Lutni chaqirip uninggha: — Bügün kechte séningkige kirgen ademler qéni? Ularni bizge chiqirip ber, biz ular bilen yéqinchiliq qilimiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lut derwazining aldigha, ularning qéshigha chiqip, ishikni yépiwétip, ");
INSERT INTO uiglat_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ulargha: — Ey buraderlirim, mundaq rezillikni qilmanglar! ");
INSERT INTO uiglat_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mana, téxi héch er bilen bille bolmighan ikki qizim bar; ularni silerge chiqirip bérey. Ular bilen xalighininglarni qilinglar. Emma bu ademler ögzemning sayisi astigha kirgeniken, siler ularni héchnéme qilmanglar! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Lékin ular jawab bérip: «Néri tur!» déginiche, yene: — Bu yerde turushqa kelgen bu musapir hakim bolmaqchimiken? Emdi sanga ulargha qilghandinmu better yamanliq qilimiz! — dep Lutni qistap, ishikni chéqishqa basturup keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Emma u ikki kishi qollirini uzitip Lutni öyge öz qéshigha tartip ekiriwélip, ishikni taqiwaldi ");
INSERT INTO uiglat_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","we öyning derwazisining aldidiki ademlerni kichikidin tartip chongighiche korluqqa muptila qildi; shuning bilen ular derwazini izdep, halidin ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Andin ikkeylen Lutqa: — Mushu yerde yene birer kiming barmu? Küy’oghul, oghul yaki qizliring we yaki sheherde bashqa ademliring bolsa ularni bu yerdin élip ketkin! ");
INSERT INTO uiglat_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Chünki biz bu yerni yoqitimiz; chünki ular toghruluq kötürülgen dad-peryad Perwerdigarning aldida intayin küchlük bolghach, Perwerdigar bizni uni yoqitishqa ewetti, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Shuning bilen Lut tashqirigha chiqip, qizlirini alidighan bolghusi küy’oghullirining qéshigha bérip: «Emdi qopup bu yerdin chiqip kétinglar; chünki Perwerdigar sheherni yoqitidu» — dédi. Emma u bolghusi küy’oghullirining nezirige chaqchaq qilghandek köründi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tang atqanda, perishtiler Lutni aldiritip: — Emdi qopup ayaling bilen qéshingdiki ikki qizingni alghin; bolmisa sheherning qebihlikige chétilip qélip, halak bolisen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Emma u téxiche arisaldi bolup turghanda, Perwerdigar uninggha rehim qilghanliqi üchün, u ikkiylen Lutning qolini, ayalining qolini we ikki qizining qollirini tutup, ularni sheherning sirtigha echiqip, orunlashturup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ularni chiqarghandin kéyin shu ish boldiki, ulardin biri uninggha: — Jéningni élip qach, halak bolmasliqing üchün keyningge qarimay, tüzlengliktiki héch yerde toxtimay, taghqa qachqin! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lékin Lut ulargha: — Undaq bolmighay, ey xojam, ötünüp qalay! ");
INSERT INTO uiglat_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mana, kemineng közüngde iltipat tapti, jénimni qutquzdung, manga zor merhemet körsetting; emma men taghqa qachalmaymen; undaq qilsam, manga birer apet chüshüp, ölüp kétermenmikin. ");
INSERT INTO uiglat_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Qara, awu sheherge qéchip barsa bolghudek nahayiti yéqin iken, shundaqla kichik sheher iken! Ötünüp qalay, méning shu yerge qéchishimgha yol qoyghaysen! U kichik sheher emesmu?! Jénim shu yerde aman qalidu! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Perishte uninggha jawab bérip: — Xeyr, bu ishtimu sanga maqul bolay, sen éytqan shu sheherni weyran qilmay. ");
INSERT INTO uiglat_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Emdi u yerge tézdin qéchip barghin; chünki sen shu yerge yétip barmighuche héch ish qilalmasmen, — dédi. Shunga u sheherning ismi «Zoar» dep atalghan. ");
INSERT INTO uiglat_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lut Zoargha yétip barghanda kün nuri yer yüzige chéchilghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Shu chaghda Perwerdigar Perwerdigardin Sodom bilen Gomorraning üstige ershtin günggürt we ot yaghdurup,    ");
INSERT INTO uiglat_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","shu sheherlerni, pütkül tüzlenglikni hemde sheherlerdiki barliq ahaliler we yerdin ün’genlerni qoshup berbat qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lékin Lutning arqisidin mangghan ayali keynige qariwidi, tuz tüwrükke aylinip qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Etisi tang seherde, Ibrahim qopup ilgiri Perwerdigarning aldida turghan jaygha chiqip, ");
INSERT INTO uiglat_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom bilen Gomorra terepke, shundaqla tüzlenglikning hemme yérige nezer séliwidi, mana, yer yüzidin xumdanning tütünidek tütün örlewatqinini kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Emma shundaq boldiki, Xuda u tüzlengliktiki sheherlerni weyran qilghanda, U Ibrahimni ésige élip, Lut turghan sheherlerni berbat qilghanda uni balayi’apetning ichidin chiqirip qutquzdi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Emma Lut Zoar shehiride turushtin qorqqachqa, Zoardin kétip, taghqa chiqip, ikki qizi bilen shu yerde makanlashti. U ikki qizi bilen bir öngkürde turdi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Emdi chong qiz kichikige: — Atimiz bolsa qérip ketti; dunyaning qaide-yosuni boyiche bu yurtta bizge yéqinchiliq qilidighan héch er kishi qalmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Qéni, atimizni sharab bilen mest qilip qoyup, uning bilen bille yatayli; shundaq qilsaq, biz perzent körüp atimizning uruqini qalduralaymiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Shuning bilen ular u kéchisi atisigha sharab ichküzüp mest qilip qoyup, chong qizi kirip atisi bilen yatti. Lékin Lut uning kirip yatqininimu, qopup ketkininimu héch sezmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Etisi shundaq boldiki, chongi kichikige: — Mana, men axsham atam bilen yattim; bügün kechtimu uninggha yene sharab ichküzeyli; shuning bilen sen kirip uning bilen yatqin; shundaq qilip, her ikkimiz perzent körüp atimizning neslini qalduralaymiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Shuning bilen ular u kéchisi atisigha sharab ichküzüp mest qilip qoyup, kichik qizi ornidin turup uning bilen bille yatti. Emma Lut uning kirip yatqininimu, qopup ketkininimu héch sezmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Shundaq qilip, Lutning ikkila qizi öz atisidin hamilidar bolup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Chongi bolsa oghul tughup, uning étini Moab qoydi; u bügünki Мoabiylarning atisidur. ");
INSERT INTO uiglat_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kichikimu oghul tughup, uning étini Ben-Ammi qoydi. U bügünki Ammoniylarning atisidur. ");
INSERT INTO uiglat_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ibrahim u yerdin chiqip, jenub tereptiki Negewge köchüp kélip, Qadesh bilen Shurning ariliqida turup qaldi; bir mezgildin kéyin Gerarda olturaqlashti. ");
INSERT INTO uiglat_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Shu yerde Ibrahim ayali Sarah toghrisida: «U méning singlimdur», dégenidi. Shuning bilen Gerarning padishahi Abimelek adem ewetip, Sarahni özige xotun bolushqa éliwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lékin bir küni kéchisi chüshide Xuda Abimelekke kélip uninggha: — Mana, sen özüngge éliwalghan ayal sewebidin emdi ölgen ademdursen; chünki u bashqa birsining ayalidur — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Emma Abimelek uninggha téxi yéqinchiliq qilmighanidi. U Xudagha: — I Reb, heqqaniy bir xelqnimu halak qilamsen? ");
INSERT INTO uiglat_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","U özimu manga: «U méning singlim» dep éytmidimu? Yene kélip, bu ayalmu «U méning akam», dep éytqanidi. Men bolsam sap könglüm we durus niyitim bilen bu ishni qildim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Xuda chüshide uninggha yene: — Bu ishni sap köngül bilen qilghiningni bilimen; shu sewebtin Men séni aldimda gunah qilishtin tosup, uninggha tégishingge qoymidim. ");
INSERT INTO uiglat_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Emdi u kishining ayalini özige qayturup ber; chünki u Peyghember, u séning heqqingde dua qilidu we sen tirik qalisen. Eger uni yandurup bermiseng shuni bilip qoyghinki, sen we hemme ademliring qoshulup jezmen ölisiler, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelek etigen tang seherde qopup, hemme xizmetkarlirini chaqirip, bu sözlerning hemmisini ularning qulaqlirigha saldi; bu ademler nahayiti qorqushup ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Andin Abimelek Ibrahimni chaqirip uninggha: — Bu bizge néme qilghining? Men sanga zadi néme gunah qildim, sen men we padishahliqimgha éghir bir gunahni yüklep qoydung? Manga qilmaydighan ishlarni qilding! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek Ibrahimgha yene: — Sen zadi bizning néme ishimizni körgining üchün mushu ishni qilding? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahim jawab bérip: — «Bu yerde shübhisizki héchkim Xudadin qorqmaydiken, ular méni ayalim tüpeylidin öltürüwétidu», dep oylighanidim. ");
INSERT INTO uiglat_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Emeliyette, uning méning singlim ikenliki rast, lékin u méning ata bir, ana bölek singlim; kéyin u méning ayalim boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lékin Xuda méni atamning öyidin chiqirip sergerdanliqqa yürgüzginide, men ayalimgha: — Biz qeyergila barsaq, sen manga shundaq shapaet körsetkeysenki, méning toghramda: «Bu méning akam bolidu», dégin, — dep éytqanidim — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Andin Abimelek qoy-kalilar, qullar we dédeklerni élip ularni Ibrahimgha berdi we ayali Sarahnimu uninggha qayturup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek: — Mana méning zéminim bolsa aldingda turuptu; közüngge qaysi yer yaqsa shu yerde turghin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","U Sarahqa: «Mana, men akanggha ming kümüsh tengge berdim; mana bular öz yéningdikiler, shundaqla hemme ademlerning köz aldida uyatni yapquchi bolidu; shuning bilen sen herqandaq dagh-eyibtin xalas bolisen». ");
INSERT INTO uiglat_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ibrahim Xudagha dua qildi, Xuda Abimelek, ayali we kénizeklirini saqaytti; andin ular yene bala tughalaydighan boldi; chünki Perwerdigar Ibrahimning ayali Sarah tüpeylidin Abimelekning öyidiki hemme xotunlarning baliyatqulirini étip qoyghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Emdi Perwerdigar wede qilghinidek Sarahni yoqlidi; Perwerdigar Sarahqa déginidek qildi.    ");
INSERT INTO uiglat_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarah hamilidar bolup, Ibrahim qérighanda Xuda uninggha békitken waqitta bir oghul tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahim özige törelgen oghli, yeni Sarah uninggha tughup bergen oghlining ismini Ishaq qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Andin Ibrahim Xuda uninggha buyrughinidek öz oghli Ishaq tughulup sekkizinchi küni xetne qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Oghli Ishaq tughulghan chaghda, Ibrahim yüz yashta idi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah: «Xuda méni küldürüwetti; herkim bu ishni anglisa, men bilen teng külüshidu», dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","U yene: — Kimmu Ibrahimgha: «Sarah bala émitidighan bolidu!» dep éytalaytti? Chünki u qérighanda uninggha bir oghul tughup berdim! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Bala chong bolup, emchektin ayrildi. Ishaq emchektin ayrilghan küni Ibrahim chong ziyapet ötküzüp berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Emma Sarah misirliq Hejerning Ibrahimgha tughup bergen oghulning Ishaqni mesxire qiliwatqinini körüp qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Shuning bilen u Ibrahimgha: — Bu dédek bilen oghlini heydiwet! Chünki bu dédekning oghli méning oghlum Ishaq bilen teng waris bolsa bolmaydu!, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Sarahning bu sözi Ibrahimgha tolimu éghir keldi; chünki Ismailmu uning oghli-de! ");
INSERT INTO uiglat_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Lékin Xuda Ibrahimgha: — Balang we dédiking wejidin bu söz sanga éghir kelmisun, belki Sarahning sanga dégenlirining hemmisige qulaq salghin; chünki Ishaqtin bolghini séning nesling hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Lékin dédekning oghlidinmu bir xelq-millet peyda qilimen, chünki umu séning nesling, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Etisi tang seherde Ibrahim qopup, nan bilen bir tulum suni élip Hejerge bérip, öshnisige yüdküzüp, balini uninggha tapshurup, ikkisini yolgha sélip qoydi. Hejer kétip, Beer-Shébaning chölide kézip yürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Emdi tulumdiki su tügep ketkenidi; Hejer balini bir chatqalning tüwige tashlap qoyup, öz-özige: «Balining ölüp kétishige qarap chidimaymen» dep, bir oq étimche yiraqqa bérip, udulida olturdi. U udulida olturup, peryad kötürüp yighlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Xuda oghulning yigha awazini anglidi; shuning bilen Xudaning Perishtisi asmandin Hejerni chaqirip uninggha: — Ey Hejer, sanga néme boldi? Qorqmighin; chünki Xuda oghulning yigha awazini yatqan yéridin anglidi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Emdi qopup, qolung bilen balini yölep turghuz; chünki Men uni ulugh bir el-millet qilimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Shuan Xuda Hejerning közlirini achti, u bir quduqni kördi. U bérip tulumgha su toldurup, oghulgha ichküzdi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Xuda u bala bilen bille boldi; u ösüp chong boldi. U chölde yashap, mergen bolup yétishti. ");
INSERT INTO uiglat_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","U Paran chölide turdi; shu waqitlarda anisi uninggha Misir zéminidin bir qizni xotunluqqa élip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","U waqitlarda shundaq boldiki, Abimelek we uning leshkerbéshi Fikol kélip Ibrahimgha: — Qilghan hemme ishliringda, Xuda séning bilen billidur. ");
INSERT INTO uiglat_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Emdi sen del mushu yerde manga, oghlumgha we newremge xiyanet qilmasliqqa Xudaning namida qesem qilip bergeysen; men sanga körsitip kelgen méhribanliqimdek, senmu manga we sen hazir turuwatqan yurtqa méhribanliq qilghaysen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrahim: Qesem qilip bérey, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Andin Ibrahim Abimelekning chakarliri tartiwalghan bir quduq toghrisida Abimelekni eyiblidi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek: — Bu ishni qilghan kishini bilmeymen; sen bu ishni mangimu éytmapsen; men bu ishni peqet bügünla anglishim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ibrahim qoy-kala élip Abimelekke teqdim qildi; andin ular ikkilisi ehde qilishti. ");
INSERT INTO uiglat_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibrahim yene padidin yette chishi qozini bir terepke ayrip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek Ibrahimdin: — Sen bir terepke ayrip qoyghan bu yette chishi qozining néme menisi bar? — dep soriwidi, ");
INSERT INTO uiglat_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","u: — Méning bu quduqni kolighinimni étirap qilghininggha guwahliq süpitide bu yette chishi qozini qolumdin qobul qilghaysen, — dep jawab berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Bu ikkisi shu yerde qesem qilishqanliqi üchün, u shu jayni «Beer-Shéba» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Shu teriqide ular Beer-Shébada ehde qilishti. Andin Abimelek we uning leshkerbéshi Fikol qozghilip, Filistiylerning zéminigha yénip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibrahim Beer-Shébada bir tüp yulghunni tikip, u yerde Ebediy Tengri bolghan Perwerdigarning namigha nida qilip ibadet qildi.    ");
INSERT INTO uiglat_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibrahim Filistiylerning zéminida uzun waqitqiche turup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bu ishlardin kéyin shundaq boldiki, Xuda Ibrahimni sinap uninggha: — Ey Ibrahim! dédi. U: mana men! — dep jawab berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","U: — Sen oghlungni, yeni sen söyidighan yalghuz oghlung Ishaqni élip, Moriya yurtigha bérip, shu yerde, Men sanga éytidighan taghlarning birining üstide uni köydürme qurbanliq süpitide sun’ghin, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Etisi Ibrahim seher qopup, éshikini toqup, yigitliridin ikkiylen bilen Ishaqni bille élip, köydürme qurbanliq üchün otun yérip, Xuda uninggha éytqan yerge qarap mangdi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Üchinchi küni Ibrahim béshini kötürüp qarap, yiraqtin u yerni kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ibrahim yigitlirige: — Siler éshek bilen mushu yerde turup turunglar. Men balam bilen u yerge bérip, sejde qilip, andin qéshinglargha yénip kélimiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Shuning bilen Ibrahim köydürme qurbanliqqa kéreklik otunni élip, oghli Ishaqqa yüdküzüp, özi qoligha pichaq bilen otni élip, ikkisi bille yürüp ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ishaq atisi Ibrahimgha: — Ey ata! déwidi, u uninggha jawab bérip: — Mana men, oghlum, dédi. U uningdin: — Mana ot bilen otun’ghu bar, emma köydürme qurbanliq bolidighan qoza qéni? — dep soriwidi, ");
INSERT INTO uiglat_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibrahim jawab bérip: — Ey oghlum, Xuda Özi Özige köydürme qurbanliq qozini teminleydu, — dédi. Andin ikkisi birge yolini dawamlashturdi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Axirida ular Xuda Ibrahimgha éytqan jaygha yétip keldi. Ibrahim u yerde qurban’gah yasap, üstige otunni tizip qoydi. Andin u oghli Ishaqni baghlap, uni qurban’gahdiki otunning üstide yatquzdi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Andin Ibrahim qolini uzitip, oghlini boghuzlighili pichaqni aldi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Shuan Perwerdigarning Perishtisi asmandin uni chaqirip uninggha: — Ibrahim, Ibrahim! — dep warqiridi. U: — Mana men, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","U uninggha: — Sen baligha qolungni tegküzmigin, uni héchnéme qilmighin; chünki Men séning Xudadin qorqqanliqingni bildim; chünki séning oghlungni, yeni yalghuz oghlungni Mendin ayimiding, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahim béshini kötürüp qariwidi, mana, arqisida münggüzliri chatqalgha chirmiship qalghan bir qochqarni kördi. Ibrahim bérip qochqarni élip, uni oghlining ornida köydürme qurbanliq qilip sundi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Shuning bilen Ibrahim shu jaygha «Yahweh-Yireh» dep at qoydi. Shunga kishiler: «Perwerdigarning téghida teminlinidu» dégen bu söz bügün’ge qeder éytilip kéliwatidu. ");
INSERT INTO uiglat_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Perwerdigarning Perishtisi asmandin Ibrahimni ikkinchi qétim chaqirip uninggha: — ");
INSERT INTO uiglat_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Sen öz oghlungni, yeni yalghuz oghlungni ayimay bu ishni qilghining üchün Men Özüm bilen qesem qilimenki, deydu Perwerdigar, ");
INSERT INTO uiglat_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","— Men séni zor beriketlep, neslingni asmandiki yultuzlardek nurghun köpeytip, déngiz sahilidiki qumdek gholditimen; nesling bolsa düshmenlirining derwazilirigha ige bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Sen Méning awazimgha qulaq salghining üchün yer yüzidiki barliq el-yurtlar neslingning nami bilen özliri üchün bext-beriket tileydu, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Andin Ibrahim yigitlirining qéshigha yénip bardi. Ular hemmisi ornidin turushup Beer-Shébagha yol aldi. Ibrahim Beer-Shébada turup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bu ishlardin kéyin Ibrahimgha: «Mana Milkahmu ining Nahorgha birqanche oghul tughup bériptu», dégen xewer yetti. ");
INSERT INTO uiglat_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ular bolsa tunji oghli uz, uning inisi Buz we Aramning atisi bolghan Kemuel, ");
INSERT INTO uiglat_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","andin Kesed, Xazo, Pildash, Yidlaf we Bétuel dégen oghullar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Bétueldin Riwkah töreldi). Bu sekkizini Milkah Ibrahimning inisi Nahorgha tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Shuningdek uning kéniziki Reumahmu Tébah, Gaham, Taxash we Maakah dégenlerni tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah bir yüz yigirme yette yashqiche ömür kördi. Bu Sarahning ömrining yilliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah Qanaan zéminidiki Kiriat-Arba, yeni Hébronda wapat boldi. Ibrahim bérip Sarah üchün matem tutup yigha-zar qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ibrahim öz merhumesining yénidin qopup, Hittiylargha söz qilip: ");
INSERT INTO uiglat_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","— Men bolsam aranglarda musapir méhman, xalas; siler emdi aranglardin manga bir yerlik béringlar; shuning bilen men bu merhumemni aldimda körünüp turmisun üchün élip bérip depne qilay, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Hittiylar Ibrahimgha jawab bérip: — I xojam, bizge qulaq salghayla! Sili arimizda Xudaning bir shahzadisi hésablinila! Arimizdiki eng ésil yerlikni tallap, shu yerde merhumelirini depne qilghayla! Merhumelirini depne qilishqa héchqaysimiz öz yerlikini silidin ayimaydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ibrahim ornidin turup, u zémindiki xelqqe, yeni hittiylargha tezim qilip, ");
INSERT INTO uiglat_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ulargha: — Eger merhumemning köz aldimda turiwermesliki üchün, uni élip bérip, depne qilishimni rawa körsenglar, undaqta sözümni anglap méning üchün Zoharning oghli Efron’gha söz qilip, ");
INSERT INTO uiglat_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","uning étizining ayighida öziningki bolghan Makpélahning gharini manga bérishini iltimas qilinglar. U manga buni silerning aranglarda göristan bolushqa toluq nerxide bersun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Shu chaghda Efron Hittiylar arisida olturatti. Shuning bilen hittiyliq Efron hittiylarning aldida, yeni shehirining derwazisidin kirgüchilerning hemmisining aldida Ibrahimgha jawab bérip: — ");
INSERT INTO uiglat_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Yoqsu, ey xojam, manga qulaq salghayla. Bu étizliqni, shundaqla uningdiki gharni silige bérey; uni öz xelqim bolghan ademlerning aldida silige berdim; öz méyitlirini depne qilghayla, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Andin Ibrahim yene zémin xelqi aldida tezim qilip, ");
INSERT INTO uiglat_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Shu zémindiki xelqning qulaqliri aldida Efron’gha: — Iltimasimgha qulaq salghayla; men bu étizliqning nerxi boyiche pul bérey, uni mendin qobul qilghayla, andin men méyitimni shu yerde depne qilay, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron Ibrahimgha jawab bérip uninggha: ");
INSERT INTO uiglat_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Ey xojam, manga qulaq salghayla; töt yüz shekel kümüshke yaraydighan bir étizliq, sili bilen méning aramda néme idi? Sili méyitlirini depne qilghayla — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahim Efronning sözige qoshuldi; andin Efron Hittiylar aldida éytqan bahani, yeni shu chaghdiki soda ölchimi boyiche töt yüz shekel kümüshni tarazida tartip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Shundaq qilip Mamrening udulidiki Makpélahqa jaylashqan Efronning étizliqi, yeni étizliqning özi, uningdiki ghar, shundaqla étizliqning ichi we etrapidiki barliq derexlerning hemmisi ");
INSERT INTO uiglat_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hittiylarning köz aldida Ibrahimgha tapshurulup, yeni Efronning shehirining derwazisidin barliq kirgüchilerning aldida uning mülki qilip békitildi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Shuningdin kéyin Ibrahim ayali Sarahni Qanaan zéminidiki Mamre (yeni, Hébron)ning udulidiki Makpélahning étizliqining gharida depne qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Shu teriqide u étizliq we uningdiki ghar hittiylar teripidin Ibrahimgha göristan bolushqa tayin qilindi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahim qérip, yéshi bir yerge bérip qalghanidi; Perwerdigar Ibrahimgha her terepte bext-beriket ata qilghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ibrahim öyidiki eng mötiwer xizmetkari, özining pütün mal-mülkini bashquridighan ghojidargha: — Qolungni yotamning astigha qoyghin;    ");
INSERT INTO uiglat_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Men séni asmanlarning Xudasi shundaqla yerning Xudasi bolghan Perwerdigarning nami bilen qesem qildurimenki, sen men hazir turuwatqan bu Qanaaniylarning arisidin oghlumgha qiz élip bermey, ");
INSERT INTO uiglat_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Belki öz yurtumgha, shundaqla öz uruq-tughqanlirimning qéshigha bérip, oghlum Ishaqqa xotun élip bergeysen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Xizmetkari uninggha: — Mubada u qiz men bilen bu yurtqa kelgili unimisa, undaqta özliri chiqqan shu yurtqa oghullirini yandurup apiramdimen? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahim uninggha jawab bérip: — Hézi bol, oghlumni hergiz shu yerge yandurup barmighin! ");
INSERT INTO uiglat_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Méni atamning öyi bilen tughulghan yurtumdin yéteklep élip kelgüchi, yeni manga söz qilip: — «Séning neslingge bu yurtni bérimen», dep manga qesem qilghan, asmanning Xudasi bolghan Perwerdigar Öz Perishtisini aldinggha ewetidu; shuning bilen sen u yerdin oghlumgha qiz élip kéleleysen. ");
INSERT INTO uiglat_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Shundaqtimu, eger qiz sen bilen bu yerge kelgili unimisa, men sanga qilduridighan qesemdin xalas bolisen; emma oghlumni u yerge hergiz yandurup barmighin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Shuning bilen xizmetkar qolini xojisi Ibrahimning yotisining astigha qoyup turup, bu toghrida uninggha qesem qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Andin xizmetkar bu toghrida xojisining tögiliridin onni, shundaqla xojisining herxil ésil nersilirini élip yolgha chiqti; u Aram-Naharaim rayonigha seper qilip, Nahorning shehirige yétip keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","U sheherning sirtidiki bir quduqning yénida tögilirini chökündurdi: bu kechqurun, qiz-ayallarning su tartqili chiqidighan chéghi idi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","U dua qilip: — Ey xojam Ibrahimning Xudasi bolghan Perwerdigar, ötünimenki, bügün méning ishimni onggha tartqaysen, xojam Ibrahimgha shapaet körsetkeysen. ");
INSERT INTO uiglat_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mana men bu yerde quduqning béshida turuwatimen we sheher xelqining qizliri bu yerge su tartqili kéliwatidu. ");
INSERT INTO uiglat_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Emdi shundaq bolsunki, men qaysi qizgha: «Komzikingni chüshürseng, men su ichiwalsam boptiken!» désem, u jawab bérip: «Mana ichkin, men tögiliringnimu sughirip qoyay», dése, u qiz sen qulung Ishaqqa békitkiningning özi bolsun. Buningdin séning xojam Ibrahimgha shapaet qilghiningni bileleymen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","U téxi sözini tügetmeyla, mana Riwkah kozini müriside kötürüp chiqip keldi; u bolsa Ibrahimning inisi Nahorning ayali Milkahtin tughulghan oghli Bétuelning qizi idi; ");
INSERT INTO uiglat_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Qiz intayin chirayliq bolup, héch er kishi tegmigen pak qiz idi. U quduqning boyigha chüshüp, komzikini toldurup andin chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Xizmetkar uning aldigha yügürüp bérip: — Ötünüp qalay, komzikingtin azghine su otliwalay, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","U jawab bérip: — Ichkeyla, ey xojam! depla, komzekni derhal qoligha élip, uning su ichishi üchün sundi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","U süyidin uninggha qan’ghuche ichküzgendin kéyin: — Tögilirigimu qan’ghuche su ichküzüp qoyay, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Shuning bilen u derhal komzektiki suni olaqqa töküwétip, yene quduqqa su tartqili yügürüp bardi; u uning hemme tögilirige su tartip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","U kishi uninggha közini tikkiniche jimjit turup, Perwerdigarning yolini ong qilghan, qilmighanliqini bilish üchün kütüwatatti. ");
INSERT INTO uiglat_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tögiler su ichip qan’ghanda, shundaq boldiki, héliqi kishi yérim shekellik bir altun burun halqisi bilen ikki qoligha on shekellik altun bilezükni chiqirip qizgha bérip uninggha: ");
INSERT INTO uiglat_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Sen kimning qizi bolisen? Manga dep berseng! Atangning öyide bizge qon’ghudek jay barmu? — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Qiz uninggha: — Men Milkahning Nahorgha tughup bergen oghli Bétuelning qizi bolimen, — dédi, ");
INSERT INTO uiglat_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","yene uninggha: — Bizningkide saman bilen boghuz kengri, silerge qon’ghili jaymu bar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Shuan bu adem éngiship Perwerdigarning aldida sejde qilip: ");
INSERT INTO uiglat_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Öz shapaiti bilen hojamdin wapadarliqini ayimighan, xojam Ibrahimning Xudasi bolghan Perwerdigargha hemdusana oqulghay! Perwerdigar bu sepirimde méni xojamning qérindashliri turghan öyge bashlap keldi! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Qiz yügürüp bérip, bularning hemmisini anisining öydikilerge éytip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Emdi Riwkahning Laban dégen bir akisi bar idi. Laban quduqning béshigha, u ademning qéshigha yügürüp chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Chünki u singlisining burun halqisini we qolliridiki bilezüklerni körüp, hemde singlisining: u adem manga mundaq-mundaq dédi, déginini anglap, u ademning qéshigha bardi. Mana, u kishi quduqning yénida tögilerning qéshida turatti. ");
INSERT INTO uiglat_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban uninggha: — Ey Perwerdigarning bext-berikiti ata qilin’ghuchi, kirgeyla! Néme üchün tashqirida turdila? Men öyni teyyarlap qoydum, tögilergimu jay raslidim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","U adem öyge kirdi; Laban tögilerdin yükni chüshürüp, tögilerge saman bilen boghuz bérip, u kishining hem uning hemrahlirining putlirini yughili su élip keldi; ");
INSERT INTO uiglat_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","andin u kishining aldigha taam qoyuldi; lékin u: — Men gépimni démey turup taam yémeymen, — dédi. Laban jawab bérip: — Éytqayla, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","U: — Men bolsam Ibrahimning xizmetkarimen; ");
INSERT INTO uiglat_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Perwerdigar xojamgha köp bext-beriket ata qilghachqa, u ulugh bir kishi boldi. U uninggha qoy bilen kala, kümüsh bilen altun, qul bilen dédeklerni, töge bilen ésheklerni berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Xojamning ayali Sarah qérighanda xojamgha bir oghul tughup bergenidi. Xojam oghligha özining barliqini atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Xojam méni qesem qildurup: «Sen men turuwatqan zémindiki Qanaaniylarning qizliridin oghlumgha xotun élip berme, ");
INSERT INTO uiglat_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","belki jezmen atamning öyige, öz tughqanlirimning qéshigha bérip, oghlumgha xotun élip bergeysen», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","U waqitta men xojamgha: «U qiz men bilen kelgili unimisichu?» — désem, ");
INSERT INTO uiglat_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","u manga jawab bérip: «Tutqan yollirim uninggha ochuq bolghan Perwerdigarim Öz Perishtisini séning bilen ewetip, yolungni ong qilidu. Bu teriqide sen méning ailidikilirim arisidin, atamning jemeti ichidin oghlumgha xotun élip bérisen. ");
INSERT INTO uiglat_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Shundaq qilip ailemdikilerning qéshigha yétip barghiningda, sen men qildurghan qesemdin xalas bolisen; ular sanga qizni bermisimu oxshashla qesemdin xalas bolisen», — dégenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Shunga men bügün bu quduqning qéshigha kélip: — Ey, xojam Ibrahimning Xudasi bolghan Perwerdigar, eger sen bu sepirimni ong qilsang: — ");
INSERT INTO uiglat_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","mana men su quduqining yénida turuwatimen; we shundaq bolsunki, su tartqili kelgen qizgha: «Komzikingdin manga bir otlam su bergen bolsang», désem, ");
INSERT INTO uiglat_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","u manga: «Sen ichkin, tögiliringgimu su tartip bérey», dep jawab berse, undaqta bu qiz del Perwerdigar Özi xojamning oghli üchün békitken qiz bolsun, dep dua qilghanidim. ");
INSERT INTO uiglat_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Könglümde téxi sözüm tügimeyla, mana, Riwkah komzekni müriside kötürüp chiqip, quduqning boyigha chüshüp su tartti; men uninggha: — Iltipat qilip, manga su ichkili qoysang, déwidim, ");
INSERT INTO uiglat_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","u derhal komzikini mürisidin chüshürüp: «Ichkeyla, tögilirinimu sughirip qoyay», dédi. Shuning bilen men ichtim; u tögilirimnimu sughirip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Andin men uningdin: — Kimning qizi bolisen, dep sorisam, u jawab bérip: — Men Nahorning Milkahdin tughulghan oghli Bétuelning qizi bolimen, — dédi. Shu chaghda men uning burnigha halqa, qollirigha bilezüklerni sélip qoydum; ");
INSERT INTO uiglat_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","andin éngiship Perwerdigargha sejde qildim; xojamning qérindishining qizini uning oghli üchün élip kétishke méning yolumni ong qilghini üchün, xojamning Xudasi bolghan Perwerdigargha hemdusana éyttim. ");
INSERT INTO uiglat_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Emdi siler xojamgha ixlas qilip shapaet körsiteyli désenglar, buni manga denglar. Eger xalimisanglar, unimu manga éytinglar, men ong terepke yaki sol terepke barimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Emdi Laban bilen Bétuel jawab bérip: — Bu ish Perwerdigardin bolghach, silige ya undaq ya bundaq déyelmeymiz. ");
INSERT INTO uiglat_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mana, Riwkah aldilirida turidu; uni élip ketkeyla. U Perwerdigarning déginidek öz xojilirining oghligha xotun bolsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ibrahimning xizmetkari ularning sözlirini anglap, yerge éngiship, Perwerdigargha sejde qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Andin, xizmetkar kümüsh buyumlarni, altun buyumlarni we kiyim-kécheklerni chiqirip, bularni Riwkahqa berdi; u yene qizning akisi we anisighimu qimmetlik hediyelerni sundi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Andin u we hemrahliri bilen bille yep-ichip, shu yerde qonup qaldi. Etisi seherde qopup, u ulargha: méni xojamning qéshigha yolgha sélip qoyunglar, déwidi, ");
INSERT INTO uiglat_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Qizning akisi bilen anisi uninggha: — Qiz birqanche kün yaki on kün yénimizda tursun; andin barsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Emma u ulargha: — Perwerdigar méning sepirimni ong qilghaniken, méni tosmanglar; xojamning qéshigha bérishim üchün méni yolgha sélip qoyunglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ular uninggha: — Qizni chaqirip, uning aghzidin anglap baqayli, dep ");
INSERT INTO uiglat_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Riwkahni chaqirip uningdin: — Bu adem bilen baramsen? dep soriwidi, u: — Baray, dep jawab berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Shuning bilen ular singlisi Riwkahni, uning inik’anisi, Ibrahimning xizmetkari we ademliri bilen qoshup yolgha sélip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","U waqitta ular Riwkahqa bext tilep: — Ey singlimiz, minglighan on minglighan ademlerning anisi bolghaysen! Nesling düshmenlirining derwazilirigha ige bolghay! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Shuning bilen Riwkah bilen uning dédekliri ornidin turup, tögilerge minip, u kishige egiship mangdi. Shundaq qilip xizmetkar Riwkahni élip yolgha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ishaq Beer-lahay-roy dégen jaydin bayila qaytip kelgenidi; chünki u jenubtiki Negewde turatti; ");
INSERT INTO uiglat_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ishaq kechqurun istiqametke dalagha chiqqanidi; u béshini kötürüp qarisa, mana tögiler kéliwatatti. ");
INSERT INTO uiglat_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","65","Riwkah béshini kötürüp, Ishaqni kördi; u derhal tögidin chüshüp, xizmetkardin: — Sehrada bizning aldimizgha chiqiwatqan bu kishi kim bolidu? — dep soridi. Xizmetkar: — Bu xojamdur! dédi. Riwkah derhal chümbilini tartip yüzini yépiwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Xizmetkar emdi qilghan hemme ishlirini Ishaqqa éytip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ishaq qizni anisi Sarahning chédirigha bashlap kirdi; u Riwkahni öz emrige aldi; u uning xotuni boldi. U uni yaxshi körüp qaldi; bu teriqide Ishaq anisining wapatidin kéyin teselli tapti. ");
INSERT INTO uiglat_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahim Keturah isimlik yene bir ayalni alghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","U Ibrahimgha Zimran, Yoqshan, Médan, Midiyan, Ishbak we Shuahni tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoqshandin Shéba bilen Dédan töreldi; Dédanning ewladliri Ashuriylar, Létushiylar we Léummiylar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyanning oghulliri Efah, Éfer, Hanox, Abida we Eldaah idi. Bular hemmisi Keturahning ewladliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahim barliqini Ishaqqa atiwetkenidi; ");
INSERT INTO uiglat_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ibrahim téxi Hayat waqtida kichik xotunliridin bolghan oghullirigha hediyelerni bérip, andin bularni oghli Ishaqtin yiraq tursun dep, kün chiqish terepke, sherqiy zémin’gha ewetiwetkenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Ibrahimning ömrining künliri bir yüz yetmish besh yil boldi; u tolimu qérip, künliri toshup, nepestin toxtap wapat boldi; u öz qowmining qéshigha bérip qoshuldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Uning oghulliri Ishaq we Ismail uni Mamrening uduligha jaylashqan, hittiy Zoharning oghli Efronning étizliqidiki Makpélahning gharida depne qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Bu étizliqni Ibrahim hittiylardin sétiwalghanidi; mana bu yerlikke Ibrahim depne qilindi, ayali Sarahmu mushu yerge depne qilin’ghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibrahim wapat bolghandin kéyin shundaq boldiki, Perwerdigar uning oghli Ishaqni beriketlidi. Ishaq Beer-Lahay-Royning yénida turatti. ");
INSERT INTO uiglat_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Töwendikiler Sarahning misirliq dédiki Hejerdin tughulghan, Ibrahimning oghli bolghan Ismailning ewladliri: — ");
INSERT INTO uiglat_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismailning oghullirining, ularning nesebnamiliri we qebililiri boyiche ismi töwendikiche: — Ismailning tunji oghli Nébayot; andin Kédar, Adbeel, Mibsam, ");
INSERT INTO uiglat_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO uiglat_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad bilen Téma, Yetur bilen Nafish we Qedemah idi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Bular bolsa Ismailning oghulliri bolup, ularning kent we chédirgahliri ularning nami bilen atalghan bolup, ular on ikki qebilige emir bolghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismailning ömrining yilliri bir yüz ottuz yette yil boldi; u axirqi nepsini tartip wapat bolup, öz qowmining qéshigha bérip qoshuldi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Uning ewladliri Hawilah rayonidin tartip shurghiche olturaqlashti (Shur bolsa Misirning utturisida bolup, Ashurgha baridighan yolda idi). Ismail özining barliq qérindashlirining udulida olturaqlashti. ");
INSERT INTO uiglat_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ibrahimning oghli Ishaqning neslining bayani mundaqtur: — Ibrahimdin Ishaq töreldi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ishaq Padan-Aramda olturushluq aramiy Bétuelning qizi, aramiy Labanning singlisi bolghan Riwkahni xotunluqqa alghanda qiriq yashqa kirgenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Emma Riwkah bolsa tughmas bolghachqa, Ishaq xotuni üchün Perwerdigargha dua-tilawet qildi; Perwerdigar uning duasini ijabet qildi; shuning bilen ayali Riwkah hamilidar boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Emma uning qorsiqidiki ikki bala bir-biri bilen soqushqili turdi. Shuning bilen Riwkah: — Eger bundaqliqini bilsem, hamilidar bolup néme qilattim? — dep Perwerdigardin sewebini sorighili bardi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Perwerdigar uninggha: — «Séning qorsiqingda ikki el bardur, Ichingdin ikki xelq chiqip bir-biridin ayrilidu, Bir xelq yene bir xelqtin ghalib kélidu, Chongi kichikining xizmitini qilidu» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Uning ay-küni toshqanda, mana uning qorsiqida derweqe bir jüp qoshkézek bar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Awwal tughulghini qizghuch bolup, pütün bedini juwidek tüklük idi. Ular uning ismini Esaw dep qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Andin inisi qoli bilen Esawning tapinini tutqan halda chiqti. Bu sewebtin uning ismi Yaqup dep qoyuldi. Ular tughulghanda Ishaq atmish yashta idi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Balilar ösüp chong boldi; Esaw mahir owchi bolup, dala-janggalda yüridighan adem boldi. Yaqup bolsa durus adem bolup, chédirlarda turatti. ");
INSERT INTO uiglat_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishaq Esawning owlap kelgen göshidin daim yep turghachqa, uninggha amraq idi. Lékin Riwkah Yaqupqa amraq idi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Bir küni Yaqup purchaq shorpisi qaynitiwatatti; Esaw daladin hérip-échip qaytip keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esaw Yaqupqa: — Men halimdin kettim! Ötünüp qalay, awu qizildin berseng! — Awu qizil nersidin méni ozuqlandursangchu! Men halimdin kettim, — dédi (shu sewebtin uning éti «Édom» depmu ataldi). ");
INSERT INTO uiglat_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaqup uninggha: — Undaq bolsa, tunjiliq hoququngni manga sétip bergin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaw: — Men öley dewatimen, bu tunjiliq hoquqining manga néme paydisi? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaqup: — Emise hazir manga qesem qilghin, déwidi, u uninggha qesem qilip, tunjiliq hoquqini Yaqupqa sétip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Shuning bilen Yaqup Esawgha nan bilen qizil purchaq shorpisini berdi. U yep-ichip ornidin turup ketti. Shundaq qilip Esaw tunjiliq hoquqigha shunche étibarsiz qarighanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Qanaan zéminida Ibrahimning waqtidiki acharchiliqtin bashqa yene bir qétimliq acharchiliq yüz berdi. Shuning bilen Ishaq Gerar shehirige, Filistiylerning padishahi Abimelekning qéshigha bardi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Perwerdigar uninggha körünüp mundaq dédi: — Sen Misirgha chüshmey, belki Men sanga körsitip béridighan yurtta turghin. ");
INSERT INTO uiglat_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Moshu zémindin chiqmay musapir bolup turghin; shuning bilen Men sen bilen bille bolup, sanga bext-beriket ata qilimen; chünki Men sen we neslingge bu zéminlarning hemmisini bérip, atang Ibrahimgha bergen qesimimni ada qilimen; ");
INSERT INTO uiglat_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","neslingni asmandiki yultuzlardek awutimen we neslingge bu zéminlarning hemmisini bérimen; yer yüzidiki barliq el-yurtlar neslingning nami bilen özlirige bext-beriket tileydu;    ");
INSERT INTO uiglat_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Chünki Ibrahim Méning awazimgha qulaq sélip, tapilighinim, emrlirim, belgilimilirim we qanunlirimni beja keltürdi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Shuning bilen Ishaq Gerarda turup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Emma u yerlik kishiler uning ayali toghrisida sorisa u: — Bu méning singlim bolidu, — dédi; chünki Riwkah intayin chirayliq bolghachqa, Ishaq öz-özige: «Bu méning ayalim bolidu», désem, bu yerlik ademler Riwkahning sewebidin méni öltürüwétermikin, — dep qorqti. ");
INSERT INTO uiglat_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Lékin u shu yerde uzaq waqit turghandin kéyin shundaq boldiki, Filistiylerning padishahi Abimelek derizidin qariwidi, mana Ishaq we ayali Riwkah bir-birige erkiliship turatti. ");
INSERT INTO uiglat_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Andin Abimelek Ishaqni chaqirip: — Mana, u jezmen séning ayaling iken! Sen néme dep: «U méning singlim», déding? — déwidi, Ishaq uninggha: — Chünki men eslide uning sewebidin birsi méni öltürüwétermikin, dep ensirigenidim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek uninggha: Bu bizge néme qilghining? Tas qaptu xelq arisidin birersi ayaling bilen birge bolghili?! Undaq bolghan bolsa sen bizni gunahqa patquzghan bolatting! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Andin Abimelek hemme xelqqe buyrup: — Kimki bu kishige we yaki xotunigha qol tegküzse jezmen öltürülmey qalmaydu, — dep yarliq chüshürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ishaq u zéminda tériqchiliq qildi: u shu yili yerdin yüz hesse hosul aldi; Perwerdigar uni beriketligenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Bu kishi bash kötürüp, barghanséri rawaj tépip, tolimu katta kishilerdin bolup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Uning qoy-kala padiliri we öyidiki qulliri intayin köpeydi; Filistiyler uninggha heset qilghili turdi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Bu sewebtin uning atisi Ibrahimning künliride atisining qulliri kolighan quduqlarning hemmisini Filistiyler étip, topa bilen tinduruwetti. ");
INSERT INTO uiglat_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek Ishaqqa: — Sen bizdin ziyade küchiyip ketting, emdi arimizdin chiqip ketkin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ishaq u yerdin kétip, Gerar wadisigha chédir tikip, shu yerde turup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ibrahim hayat waqtida qulliri birmunche quduqlarni qazghanidi; biraq Ibrahim ölgendin kéyin, Filistiyler bularni topa bilen tinduruwetkenidi. Ishaq bu quduqlarni qaytidin kolitip, ulargha atisi ilgiri qoyghan isimlarni yene qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ishaqning qulliri wadida quduq kolawatqanda suliri urghup chiqip aqidighan bir quduqni tépiwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lékin Gerardiki padichilar Ishaqning padichiliridin uni taliship: — Bu su bizningkidur, — dédi. Ular Ishaq bilen jédelleshkechke, u bu quduqni «Ések» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ular yene bashqa bir quduqni kolidi, ular yene bu quduq toghrisida jédelleshti. Shuning bilen Ishaq buning ismini «Sitnah» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Andin u u yerdin kétip, bashqa yerge bérip, shu yerdimu yene bir quduq kolidi; emdi Gerardikiler bu quduqni talashmidi. Bu sewebtin u uning étini «Rehobot» qoyup: «Emdi Perwerdigar biz üchün jay bergeniken, bu zéminda méwilik bolimiz», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Andin u u yerdin chiqip Beer-Shébagha bardi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Perwerdigar shu kéchisi uninggha körünüp: — Men bolsam atang Ibrahimning Xudasidurmen; qorqmighin, chünki Men sen bilen billimen, séni bext-beriketlep, neslingni qulum Ibrahimning sewebidin awutimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","U shu yerde bir qurban’gah yasap, Perwerdigarning namigha nida qilip ibadet qildi. U shu yerde chédirini tikti, Ishaqning qulliri shu yerde bir quduq kolidi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Emdi Abimelek, aghinisi Ahuzzat bilen leshkerbéshi Fikol birge Gerardin chiqip, uning qéshigha bardi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ishaq ulargha: — Manga öchmenlik qilip, méni aranglardin qoghliwetkendin kéyin, néme üchün méning qéshimgha keldinglar? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Ular jawaben: — Biz Perwerdigarning sen bilen bille bolghinini roshen bayqiduq, shuning bilen biz séning toghrangda: «Otturimizda bir kélishim bolsun, yeni bizler bilen sen bir-birimizge qesem bérip ehde qilishayli» déduq; shu wejidin sen bizge héchqandaq ziyan-zexmet yetküzmigeysen; biz sanga héch tegmiginimizdek, shundaqla sanga yaxshiliqtin bashqa héchbir néme qilmighinimizdek (belki séni aman-ésenlik ichide yolunggha ewetkeniduq) senmu shundaq qilghaysen. Mana hazir sen Perwerdigar teripidin bext-beriket körüwatisen! — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Shuning bilen u ulargha bir ziyapet qilip berdi. Ular bolsa yep-ichti. ");
INSERT INTO uiglat_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Etisi tang seherde ular qopup bir-birige qesem qilishti; andin Ishaq ularni yolgha sélip qoydi; ular uning qéshidin aman-ésen ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","U küni shundaq boldiki, Ishaqning qulliri kélip, uninggha özi kolighan quduq toghrisida xewer bérip: «Biz su taptuq!» dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","U uning namini «Shibah» qoydi. Bu sewebtin bu sheherning ismi bügün’giche «Beer-Shéba» dep atilip kelmekte. ");
INSERT INTO uiglat_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaw qiriq yashqa kirgende, hittiylardin bolghan Beerining qizi Yehudit bilen hittiylardin bolghan Élonning qizi Basimatni xotunluqqa aldi. ");
INSERT INTO uiglat_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Emma bular Ishaq bilen Riwkahning könglige azab élip keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ishaq qérip, közliri torliship, közi ghuwa köridighan bolup qalghanda shundaq boldiki, u chong oghli Esawni chaqirip uninggha: — Oghlum! — dédi. U: — Mana men! — dep jawab berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","U uninggha: — Mana men emdi qérip kettim, qanchilik kün köridighinimnimu bilmeymen. ");
INSERT INTO uiglat_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Shunga sendin ötünimen, qoralliring, yeni sadaq we oqyayingni élip janggalgha chiqip, men üchün bir ow owlap kel; ");
INSERT INTO uiglat_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","men yaxshi köridighan mezzilik tamaqtin birni étip, manga keltürgin. Men uni yep, ölüshtin ilgiri könglümdin sanga bext-beriket tilep dua qilay, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ishaq oghli Esawgha söz qilghanda Riwkahmu anglidi. Esaw ow owlap kelgili janggalgha chiqip ketkende, ");
INSERT INTO uiglat_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","7","Riwkah oghli Yaqupqa: — Mana men atangning akang Esawgha: «Sen ow owlap kélip, manga mezzilik bir taamni etkin; men uni yep ölüp kétishtin burun Perwerdigar aldida sanga bext-beriket tilep dua qilay», — dep éytqinini anglap qaldim. ");
INSERT INTO uiglat_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Emdi, i oghlum, sözümge qulaq sélip buyrughinimni qilghin. ");
INSERT INTO uiglat_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Sen derhal padigha bérip, öchkilerning ichidin ésil ikki oghlaqni élip kelgin; men ulardin atang üchün u yaxshi köridighan mezzilik bir taam teyyar qilay. ");
INSERT INTO uiglat_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Sen uni atangning aldigha élip kirgin. Shuning bilen u yep, ölüp kétishtin burun sanga bext-beriket tilep dua qilidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Lékin Yaqup anisi Riwkahgha: — Mana akam Esaw bolsa tüklük kishi, men bolsam tüksiz siliq tenlik ademmen. ");
INSERT INTO uiglat_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mubada atam méni silap qalsa, undaqta men uning neziride uni mazaq qilghuchi adem bolup qélip, béshimgha beriket emes, belki lenet taparmenmikin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Anisi uninggha: — Ey oghlum, sanga chüshidighan lenet manga chüshsun; emma sen peqet sözümge qulaq sélip, bérip oghlaqlarni élip kel, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","U bérip ularni élip kélip, anisigha berdi. Anisi uning atisi yaxshi köridighan mezzilik bir taamni teyyar qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Andin Riwkah tunji oghli Esawning öyde öz yénida saqlaqliq eng ésil kéyimlirini élip kichik oghli Yaqupqa kiydürüp, ");
INSERT INTO uiglat_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","oghlaqlarning térisini ikki qoli bilen boynining tüksiz jayigha yögep, ");
INSERT INTO uiglat_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","andin özi etken mezzilik taamlar bilen nanlarni oghli Yaqupning qoligha tutquzdi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yaqup atisining qéshigha kirip: — Ey ata! — dédi. U: — Mana men! Oghlum, sen kim bolisen? — déwidi, ");
INSERT INTO uiglat_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaqup atisigha jawab bérip: — Men chong oghulliri Esawmen, manga éytqanliridek qildim; emdi orunliridin turup, olturup qilghan owumning göshige éghiz tégip, andin köngülliridin manga bext-beriket tilep dua qilghayla, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ishaq oghligha: — Ey oghlum, qandaqmu uni shunche téz tépip kelding? — déwidi, u jawab bérip: — Chünki Perwerdigar Xudaliri uni del yolumgha yoluqturdi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ishaq Yaqupqa: — Ey oghlum, yéqinraq kel, sen rast oghlum Esawmu, emesmu, silap baqay, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Shuning bilen Yaqup atisi Ishaqning qéshigha yéqin bardi; u uni silap turup: — Awaz Yaqupning awazi, lékin qol bolsa Esawning qolidur, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Uning qolliri bolsa akisi Esawning qolliridek tüklük bolghini üchün uni tonuyalmay, uninggha bext-beriket tilep dua qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Andin u yene: — Sen rast oghlum Esawmusen? dep soriwidi, u jawab bérip: — Del men, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ishaq uninggha: — Taamni élip kelgin, men oghlumning ow göshidin yep, könglümdin sanga bext-beriket tilep dua qilay, — dédi. Yaqup uni uning aldigha qoydi; u yédi. U sharab keltürüwidi, unimu ichti. ");
INSERT INTO uiglat_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Andin atisi Ishaq uninggha: — Ey oghlum, emdi yéqin kélip méni söygin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","U uning qéshigha bérip uni söydi. Atisi uning kiyimining puriqini purap uninggha bext-beriket tilep dua qilip: — «Mana, oghlumning ténidiki puraq Perwerdigar beriketligen köklemzarning xush puriqigha oxshaydiken! ");
INSERT INTO uiglat_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Xuda sanga asmanning shebnimi, Yerning munbet küchini ata qilip, Ashliq-tülük bilen sharabnimu köp bergey. ");
INSERT INTO uiglat_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Xelqler séning qulluqungda bolghay, El-milletler aldingda tizlan’ghay; Qérindashliringgha xoja bolghaysen; Anangning oghulliri sanga tizlan’ghay; Sanga lenet qilghanlar lenetke qalghay; Sanga bext tiligenler bext tapqay!» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Shundaq boldiki, Ishaq Yaqupqa dua qilip bolup, Yaqup atisi Ishaqning qéshidin chiqip bolushigha, akisi Esaw owdin qaytip keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Umu mezzilik taamlarni étip, atisining qéshigha élip kirip, atisigha: — Ata qopqayla, oghullirining ow göshidin yep, köngülliridin manga bext-beriket tilep dua qilghayla, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Atisi Ishaq uninggha: — Sen kimsen? — dédi. U jawab bérip: — Men oghulliri, chong oghulliri Esawmen! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Buni anglap Ishaq alaqzadilikke chüshüp, pütün bedini jalaqlap titrep: — Undaqta bayatin ow owlap élip kelgini kim? Sen kélishtin burun uning hemme nersisidin yep, uninggha bext-beriket tilep dua qildim; we berheq, u bext-beriket köridu! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esaw atisining sözlirini anglapla intayin échinarliq halda ün sélip achchiq peryad kötürüp atisigha: — Ménimu, i ata, ménimu bext-beriketligeyla! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","U jawab bérip: — Séning ining hiyle bilen kirip, sanga tégishlik bext-beriketni élip kétiptu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaw: — Rast uning éti Yaqup emesmu?! Chünki u ikki qétim méni putlap, ornumni tartiwaldi. Awwal tunjiliq hoququmni tartiwaldi we mana hazir u manga tégidighan bext-beriketni élip ketti, — dédi, Andin yene: — Méning üchün birer bext-beriket qaldurmidilimu? — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ishaq Esawgha jawab bérip: — Mana, men uni üstüngge xoja qildim; hemme qérindashlirini uning qulluqida bolidighan qildim; ashliq we yéngi sharab bilen uni quwwetlidim; ey oghlum, emdi sanga yene némimu qilip béreleymen? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaw atisigha yene: — Ey ata, silide peqet shu birla bext-beriket bar idimu? Manga, ey ata, mangimu bext-beriket tilep dua qilghayla! dédi. Andin u ün sélip yighlap ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Atisi Ishaq uninggha jawab bérip: — «Mana, turalghu jaying yerning munbet küchidin néri, Égiz asmanning shebnimidin yiraq bolur; ");
INSERT INTO uiglat_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Sen qilichinggha tayinip jan baqisen, Iningning xizmitide bolisen; Lékin chégridin chiqip kezginingde, Sen boynungdin uning boyunturuqini chiqirip sunduruwétisen» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Shunga Esaw atisi uninggha tiligen bext-beriket sewebidin Yaqupqa öchmenlik saqlap yürdi. Esaw könglide: — Atamning matem künliri yéqinliship qaldi; shu chaghda inim Yaqupni öltürüwétimen, dep xiyal qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Lékin Riwkah chong oghli Esawning bu sözliridin xewer tapti. U kichik oghli Yaqupni chaqirip uninggha: — Mana akang Esaw séni öltürüwétimen dep öz-özidin teselli tépiwétiptu; ");
INSERT INTO uiglat_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","emdi ey oghlum, sözümge qulaq sélip, qopup Haran’gha, akam Labanning qéshigha qéchip ketkin; ");
INSERT INTO uiglat_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","akangning qehri yan’ghuche, uning qéshida birnechche waqit turghin. ");
INSERT INTO uiglat_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Akang achchiqidin yénip, séning uninggha qilghiningni untup ketküche shu yerde turup turghin; andin men adem ewetip, séni u yerdin aldurup kélimen. Néme üchün bir kündila her ikkinglardin mehrum bolup qalay? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Emma Riwkah Ishaqqa: — Men mushu hittiy qizlar wejidin jénimdin jaq toydum. Eger Yaqupmu bu yurttiki qizlardin, mushundaq hittiy qizni xotunluqqa alsa yashighinimning manga néme paydisi? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Shuning bilen Ishaq Yaqupni chaqirip, uninggha bext-beriket tilep, uninggha jékilep: — Sen Qanaaniylarning qizliridin xotun alma; ");
INSERT INTO uiglat_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","belki qopup, Padan-Aramgha, anangning atisi Bétuelning öyige bérip, u yerdin anangning akisi Labanning qizliridin xotun alghin. ");
INSERT INTO uiglat_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Hemmige Qadir Tengri séni bext-beriketlep, awutup, sendin köp xelqlerni chiqirip köpeytkey, ");
INSERT INTO uiglat_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Shundaqla Ibrahimning bext-berikitini sanga we séning bilen neslingge bergey; shundaq qilip sen hazir Musapir bolup turuwatqan yerni, yeni eslide Xuda Ibrahimgha bergen zéminni igileysen! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Shuning bilen Ishaq Yaqupni yolgha saldi. U Padan-Aramgha, aramiy Bétuelning oghli, Yaqup bilen Esawning anisi Riwkahning akisi Labanning qéshigha qarap mangdi. ");
INSERT INTO uiglat_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Esaw Ishaqning Yaqupqa bext-beriket tilep, uni Padan-Aramgha shu yerdin xotun élishqa ewetkenlikini, shundaqla uninggha bext-beriket tilep, uninga jékilep: Sen Qanaaniylarning qizliridin xotun almighin, dégenlirini uqup, Yaqupningmu öz ata-anisigha itaet qilip, Padan-Aramgha ketkinini körginide, ");
INSERT INTO uiglat_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esaw: — qanaanylarning qizliri atam Ishaqning neziride yaman körünidiken, dep bilip yetti. ");
INSERT INTO uiglat_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","U Ismailning qéshigha bérip, hazirqi xotunlirining üstige Ibrahimning oghli Ismailning qizi, Nébayotning singlisi Mahalatni xotunluqqa aldi. ");
INSERT INTO uiglat_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaqup bolsa Beer-Shébadin chiqip, Haran terepke méngip, ");
INSERT INTO uiglat_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","bir yerge yétip kelgende, kün olturup ketkechke shu yerde qonmaqchi boldi. U shu yerdiki tashlardin birini élip, béshigha yastuq qilip qoyup, uxlighili yatti. ");
INSERT INTO uiglat_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","U bir chüsh kördi: — Mana, uchi asmanlargha taqishidighan bir pelempey yerde tikleklik turatti; Xudaning perishtiliri uningda chiqip-chüshüp turushatti. ");
INSERT INTO uiglat_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mana, Perwerdigar uning üstide turatti. U: — «Men bolsam atang Ibrahimning Xudasi we Ishaqning Xudasi bolghan Perwerdigardurmen; Men sen yatqan bu zéminni séning bilen neslingge bérimen.    ");
INSERT INTO uiglat_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nesling bolsa yerning topisidek köp bolup, sen meghrib bilen meshriqqe, shimal bilen jenubqa yéyilisen; sen we neslingning wasitisi bilen yer yüzidiki barliq aile-qebililer bext-beriket tapidu. ");
INSERT INTO uiglat_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mana, Men sen bilen billidurmen, qeyerge barsang séni aman-ésen saqlap, bu zémin’gha séni qayturup kélimen; chünki sanga éytqan sözümni ada qilmay turup, séni tashlimaymen» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Andin Yaqup oyghinip: — Berheq, Perwerdigar bu yerdidur, lékin men uni bilmeptimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","U qorqup kétip: Bu jay alamet dehshetlik bir jay iken! Bu Xudaning öyi bilen asmanning derwazisidin bashqa héch jay emestur, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yaqup etisi seher qopup, béshining astigha qoyghan tashni élip, xatire tüwrük süpitide tiklep, üstige zeytun méyi quyup qoydi.    ");
INSERT INTO uiglat_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","U jayning ismini Beyt-El dep atidi; emma ilgiri u jayning éti Luz idi. ");
INSERT INTO uiglat_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Andin Yaqup qesem bilen wede qilip: — Eger Xuda méning bilen bille bolup, bu sepirimde méni saqlap, yégili nan, kiygili kiyim bérip, ");
INSERT INTO uiglat_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Men atamning öyige aman-ésen yénip barsam, undaqta Perwerdigar méning Xudayim bolidu; ");
INSERT INTO uiglat_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Shuningdek men xatire tüwrük süpitide tiklep qoyghan bu tash Xudaning öyi bolidu; hem shundaqla sen manga béridighan barliq nersilerning ondin bir ülüshini sanga teqdim qilmay qalmaymen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Andin Yaqup sepirini dawamlashturup, meshriqtiki qowmlarning zéminigha yétip keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","U qariwidi, mana, yaylaqta bir quduq turatti, uning yénida üch top qoy padisi turatti; chünki xelq bu quduqtin padilarni sughiratti. Quduqning aghzigha yoghan bir tash qoyuqluq idi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Qachaniki padilarning hemmisi u yerge yighilsa, padichilar birlikte quduqning aghzidiki tashni yumilitiwétip, qoylarni sughirip, andin tashni yene quduqning aghzigha öz ornigha qoyup qoyatti. ");
INSERT INTO uiglat_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaqup padichilardin: Ey buraderler, siler qeyerlik? — dep soridi. Ular: — Biz haranliqmiz, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","U ulardin: — Siler Nahorning oghli Labanni tonumsiler? — dep soridi. Ular: — Tonuymiz, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","U ulardin: — U salametmu, dep soriwidi, ular jawab bérip: — U salamet turuwatidu. Mana ene uning qizi Rahile qoyliri bilen kéliwatidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","U: — Mana, kün téxi égiz tursa, hazir téxi malning yighilidighan waqti bolmidi; némishqa qoylarni sughirip, andin yene bérip otlatmaysiler? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ular jawab bérip: — Yaq, mundaq qilalmaymiz. Awwal padilarning hemmisi yighilip, padichilar tashni quduqning aghzidin yumilitiwetkendin kéyin, andin qoylarni sughirimiz, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","U ular bilen gepliship turghinida, Rahile atisining qoyliri bilen yétip keldi; chünki u qoy baqquchi idi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Shundaq boldiki, Yaqup anisining akisi Labanning qizi Rahile bilen anisining akisi Labanning qoylirini körgende, u qopup bérip, quduqning aghzidin tashni yumilitiwétip, anisining akisi Labanning qoylirini sughardi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","Andin Yaqup Rahileni söyüp, yuqiri awaz bilen yighlap tashlidi we Rahilege: — Men séning atangning tughqini, Riwkahning oghli bolimen, déwidi, u yügürüp bérip atisigha xewer berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Shundaq boldiki, Laban öz singlisining oghli Yaqupning xewirini anglighanda, uning aldigha yügürüp bérip, uni quchaqlap söyüp, öyige bashlap keldi. Andin Yaqup Laban’gha kechürmishlirining hemmisini dep berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban uninggha: — Sen derweqe méning söngek bilen göshümdursen! — dédi. Buning bilen u uning qéshida bir ayche turup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Andin Laban Yaqupqa: — Sen méning tughqinim bolghach, manga bikargha xizmet qilamsen? Éytqina, heqqingge néme alisen? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labanning ikki qizi bar idi; chongining éti Léyah, kichikining éti Rahile idi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Léyahning közliri yéqimliq idi; emma Rahilening bolsa teqi-turqi kélishken, hösni-jamali chirayliq qiz idi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaqupning köngli Rahilege chüshken bolup Laban’gha: — Men séning kichik qizing Rahile üchün sanga yette yil xizmet qilay, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban jawab bérip: — Uni bashqa kishige berginimdin sanga berginim yaxshi. Emdi méningkide turghin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yaqup Rahileni élish üchün yette yil xizmet qildi. Emma u uni intayin yaxshi körgechke, bu yillar uninggha peqet birnechche kündekla bilindi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Waqit toshqanda Yaqup Laban’gha: — Mana méning künlirim toshti. Emdi ayalimni manga bergin, men uning qéshigha kirey, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban shu yerdiki hemme kishilerni yighip, ziyapet qilip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Lékin shundaq boldiki, kech kirgende, u chong qizi Léyahni Yaqupning yénigha élip keldi; Yaqup uning qéshigha kirip bille boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban öz dédiki Zilpahni qizi Léyahqa dédek qilip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Etisi shundaq boldiki, mana aldida Léyah turatti! U Laban’gha: — Bu zadi manga néme qilghining? Ejeba, men Rahile üchün sanga xizmet qilmidimmu? Méni némishqa shundaq aldiding?! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban: Bizning yurtimizda kichikini chongidin ilgiri yatliq qilidighan resim-qaide yoq. ");
INSERT INTO uiglat_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Emdi sen chongining yette künlük toy murasimini ötküzüp bolghin; andin yene ikkinchisinimu sanga béreyli; u séning manga yene yette yil qilidighan xizmitingning heqqi bolidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaqup maqul bolup, Léyahning yette künlük toy murasimini ötküzüp bolghanda, Laban qizi Rahilenimu uninggha xotunluqqa berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban dédiki Bilhahni qizi Rahilege dédek qilip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Bu teriqide Yaqup Rahileningmu qéshigha kirdi; u Rahileni Léyahdin ziyade yaxshi kördi. Andin kéyin u yene yette yil Laban’gha xizmet qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Emma Perwerdigar Léyahning etiwarlanmighanliqini körgende, uninggha tughushni nésip qildi. Lékin Rahile tughmas idi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Léyah hamilidar bolup bir oghul tughup: — «Perwerdigar xarlan’ghinimni kördi; emdi érim méni yaxshi köridu» dep uning ismini «Ruben» qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","U yene hamilidar bolup, bir oghul tughup: — «Perwerdigar etiwarlanmighanliqini anglap, buni hem manga berdi» dep, uning ismini Shiméon qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","U yene hamilidar bolup, bir oghul tughup: — «Emdi bu qétim érim manga baghlinidu; chünki men uninggha üch oghul tughup berdim» dep uning ismini Lawiy qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","U yene hamilidar bolup, bir oghul tughup: — «Emdi bu qétim men Perwerdigargha hemdusana oquy!» dep uning ismini Yehuda qoydi. Andin u tughuttin toxtap qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Emma Rahile özining Yaqupqa bala tughup bérelmiginini körgende, achisigha heset qilip Yaqupqa: — Manga bala bergin; bolmisa ölimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Shuning bilen Yaqupning Rahilege ghezipi kélip: — Men baliyatquning méwisini sendin ayighan Xudaning ornidimu?! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","— Mana, dédikim Bilhah bu yerde turidu; sen uning qéshigha kirgin, u méning quchiqimgha tughsun; men u arqiliq baliliq bolay, — dédi Rahile. ");
INSERT INTO uiglat_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Shuning bilen u dédiki Bilhahni uninggha xotun qilip berdi; Yaqup uning qéshigha kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah hamilidar bolup, Yaqupqa bir oghul tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahile: — «Xuda men üchün adalet yürgüzüp peryadimni anglap, manga bir oghul berdi», dep uning ismini Dan qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahilening dédiki Bilhah yene hamilidar bolup, Yaqupqa ikkinchi oghlini tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahile: — «Men acham bilen besliship qattiq tutushup, yengdim» dep uning ismini Naftali qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Léyah özining tughuttin toxtap qalghanini körüp, dédiki Zilpahni Yaqupqa xotun qilip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Léyahning dédiki Zilpah Yaqupqa bir oghul tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Léyah: — «Némidégen teleylik-he!» dep uning ismini Gad qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Léyahning dédiki Zilpah Yaqupqa ikkinchi oghlini tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Léyah: «Men bextlikturmen! Chünki xotun-qizlar méni bextlik déyishidu!» dep uning ismini Ashir qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Bughday ormisi künliride Ruben chiqip étizliqqa bardi we étizdin birqanche muhebbetgülini térip, bularni anisi Léyahning qéshigha ekeldi. Emdi Rahile Léyahqa: — Ötünüp qalay, oghlungning muhebbetgülidin birnechchini manga bergin! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Léyah uninggha jawaben: — Érimni tartiwalghining yetmemdu? Emdi oghlumning muhebbetgülinimu tartiwalmaqchimusen? — dédi. Rahile jawab bérip: — Undaq bolsa u oghlungning muhebbetgülliri üchün bügün kéche sen bilen yatsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yaqup kechqurun étizdin qaytip kelginide, Léyah uning aldigha chiqip: — Méning qéshimgha kirishing kérek; chünki men oghlumning muhebbetgülliri bilen séni ijarige aldim, — dédi. Shundaq déwidi, u bu kéche uning bilen yatti. ");
INSERT INTO uiglat_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Xuda Léyahning duasini anglidi; u hamilidar bolup, Yaqupqa beshinchi oghlini tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Shuning bilen Léyah: «Dédikimni érimge berginimge Xuda emdi manga «ijare heqqim»ni ata qildi» dep uning ismini Issakar qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Léyah yene hamilidar bolup, Yaqupqa altinchi oghlini tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Léyah: — «Xuda manga yaxshi toyluq ata qildi; emdi érim méning bilen bille turidighan boldi; chünki men uninggha alte oghul tughup berdim» dep uning ismini Zebulun qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Shuningdin kéyin, u bir qiz tughup, uning ismini Dinah qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Emma Xuda Rahileni yad qilip, duasini anglap uni tughidighan qildi, ");
INSERT INTO uiglat_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","U hamilidar bolup, bir oghul tughdi. U: — «Xuda méni nomustin xalas qildi», dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","U: — «Perwerdigar manga yene bir bala berse» dep, uning ismini Yüsüp qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahile Yüsüpni tughqandin kéyin Yaqup Laban’gha: — Méni öz yurtumgha, öz wetinimge ketkili qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Méning sanga ishlep érishken ish heqqim bolghan ayallirim bilen balilirimni manga bergin; men kétey; chünki méning sanga ishligen japaliq xizmitim özüngge ayan, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban uninggha jawaben: Neziringde iltipat tapqan bolsam, ötünüp qalay, yénimdin ketme. Chünki men Perwerdigarning séning sewebingdin manga beriket berginini tonup yettim, déwidi, Yaqup yene: — ");
INSERT INTO uiglat_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Manga alidighan heqqingni toxtatqin; men sanga shuni bérey, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaqup uninggha jawab bérip: — Men sanga qandaq xizmet qilip kelginim, méning qolumda malliringning qandaq bolghini özüngge ayan. ");
INSERT INTO uiglat_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Chünki men kelmeste méling az idi; emdi nahayiti zor bir top boldi. Méning qedimim qeyerge yetse, Perwerdigar sanga beriket ata qildi. Emdi men qachan öz ailem üchün igilik tikleymen? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Shuning bilen Laban: — Men sanga néme bérey, déwidi, Yaqup: — Sen manga héchnéme bermigin; peqet méning shu ishimgha qoshulsangla, men yene padangni béqip, ulardin xewer alimen. ");
INSERT INTO uiglat_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Men bügün pütkül padangni arilap, ala-chipar qoylarni, qara-qongur paxlanlarni, shundaqla öchkilerning ichidinmu ala-chiparlirini ayrip chiqimen. Bular méning ish heqqim bolsun. ");
INSERT INTO uiglat_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kéyin, méning heqqimni tekshürüp kelgen waqtingda, heqqaniy bolghinim köz aldingda ispatlinidu; öchkiler arisida ala-chipar bolmighanlirining hemmisi, paxlanlar arisida qara-qongur bolmighanlirining hemmisi oghrilap kélin’gen hésablansun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","u waqitta Laban: — Maqul, déginingdek bolsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Shu küni Laban taghil we ala-chipar tékilerni, ala-chipar chishi öchkilerni, shundaqla az-paz aq chikimi bolghan barliq öchkilerni, barliq qara-qongur qozilarni ayrip, öz oghullirining qoligha tapshurup, ");
INSERT INTO uiglat_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","özi bilen Yaqupning otturisida üch künlük ariliqni qoydi. Yaqup bolsa Labanning padilirining qalghinini baqti. ");
INSERT INTO uiglat_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Lékin Yaqup térek, badam we chinar derexliridin yumran chiwiqlarni élip, qowziqini yolluq qilip shilip, aq siziqlarni chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Andin mal küyligen waqitlirida su ichkili kelgende, u mushu shilghan chiwiqlarni padilar su ichidighan yerlerdiki ulaqlargha malning aldigha tiklep qoyatti. Mal bu taghil chiwiqlarning aldida jüpleshkendin kéyin ular taghil we ala-chipar qozilarni tughdi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Andin Yaqup bu qozilarni Labanning padisidin ayrip chiqardi; andin u Labanning padisining yüzlirini taghil we qongur qoylirigha qaritip jüpleshtürdi; shundaq qilip, u öz mélini Labanning méligha qoshmay bölek qoyup, özi üchün ayrim badilarni qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Saghlam küchlük mal jüpleshkinide, Yaqup chiwiqlarni padining köz aldigha ulaqlarda qoyatti; mallar shu chiwiqlarning yénida jüplishetti. ");
INSERT INTO uiglat_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Lékin jüplishiwatqan mal ajiz bolsa, u chiwiqlarni qoymaytti. Bu teriqide ajizliri Laban’gha, küchlükliri Yaqupqa tewe boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Shundaq qilip, bu kishi nahayiti bay bolup, malliri, dédekliri, qulliri, tögiliri we éshekliri xéli köp boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Emma Yaqup Labanning oghullirining: — Yaqup atimizning pütün mal-mülkini élip ketti; uning érishken bu döliti atimizning teelluqatidin kelgen, déginini anglap qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaqup Labanning chirayigha qariwidi, mana, u özige burunqidek xush péil bolmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Bu chaghda, Perwerdigar Yaqupqa: — Sen ata-bowiliringning zéminigha, öz uruq-tughqanliringning qéshigha qaytip ketkin. Men séning bilen bille bolimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Shuning üchün Yaqup adem ewetip, Rahile we Léyahni öz padisi turghan köklemge chaqirip kélip ");
INSERT INTO uiglat_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ulargha mundaq dédi: — Men atanglarning chirayigha qarisam manga burunqidek xush péil bolmidi; emma atamning Xudasi men bilen bille bolup keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Küchümning yétishiche atanglargha ishlep berginim silerge ayan; ");
INSERT INTO uiglat_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","halbuki, atanglar méni exmeq qilip, heqqimni on qétim özgertti; lékin Xuda uning manga ziyan yetküzüshige yol qoymidi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Eger u: «Ala-chipar qozilar heqqing bolidu», dése, barliq padilar ala-chipar qozilighili turdi. U: «Taghil qozilar heqqing bolsun», dése, barliq padilar taghil qozilighili turdi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bu teriqide Xuda atanglarning mallirini tartiwélip, manga berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Padilar küyligen waqitta men bir qétim chüshümde béshimni kötürüp shuni kördumki, mana, mallarning üstige jüplishishke étilghan qochqar-tékilerning hemmisi taghil yaki ala-chipar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Andin Xudaning Perishtisi chüshümde manga: «Ey Yaqup», déwidi, men jawab bérip: «Mana men», dédim. ");
INSERT INTO uiglat_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","U manga: — «Emdi béshingni kötürüp qarighin; mana mallarning üstige jüplishishke étilghan qochqar-tékilerning hemmisi taghil we ala-chipardur; chünki Men Labanning sanga qilghinining hemmisini kördüm. ");
INSERT INTO uiglat_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Men Beyt-Elde sanga körün’gen Tengridurmen. Sen shu yerde tüwrükni mesihlep, Manga qesem ichting. Emdi sen orningdin turup, bu zémindin chiqip, uruq-tughqanliringning zéminigha yan’ghin» dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahile we Léyah uninggha jawab bérip: — Atimizning öyide bizge tégishlik nésiwe yaki miras qalmighanmu? ");
INSERT INTO uiglat_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Biz derweqe uninggha yat adem hésablinip qalghanmu?! U bizni sétiwetti, toyluqimiznimu pütünley yep ketti! ");
INSERT INTO uiglat_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Shundaq bolghandin kéyin, Xuda Atimizdin sanga élip bergen barliq dölet biz bilen balilirimizningkidur. Emdi Xuda sanga néme dégen bolsa, shuni qilghin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Shuning bilen Yaqup ornidin turup, baliliri we ayallirini tögilerge mindurup, érishken barliq malliri we barliq teelluqatini, yeni Padan-Aramda tapqan teelluqatlirini élip, atisi Ishaqning yénigha bérishqa Qanaan zéminigha qarap yol aldi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban bolsa qoylirini qirqighili ketkenidi; Rahile öz atisigha tewe «öy butliri»ni oghrilap éliwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaqup aramiy Laban’gha öz qéshidin oghriliqche qéchip kétidighanliqini uqturmay uni aldap qoyghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","U bar-yoqini élip qéchip ketti; u deryadin ötüp Giléad téghi terepke qarap yol aldi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Üchinchi küni, Laban’gha Yaqupning qachqini toghrisida xewer yetti. ");
INSERT INTO uiglat_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","U öz tughqanlirini élip, yette künlük yolghiche keynidin qoghlap bérip, Giléad téghida uninggha yétishti. ");
INSERT INTO uiglat_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Lékin kéchisi Xuda aramiy Labanning chüshige kirip uninggha: «Sen hézi bol, Yaqupqa ya aq ya kök déme!» dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban Yaqupqa yétiship barghanda, Yaqup chédirini taghning üstige tikkenidi. Labanmu tughqanliri bilen Giléad téghining üstide chédir tikti. ");
INSERT INTO uiglat_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban Yaqupqa: — Bu néme qilghining? Sen méni aldap, qizlirimni urushta alghan oljidek élip ketting? ");
INSERT INTO uiglat_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Némishqa yoshurun qachisen, manga xewer bermey mendin oghriliqche ketting? Manga dégen bolsang men xushal-xuramliq bilen ghezel oqup, dap we chang chélip, séni uzitip qoymamtim? ");
INSERT INTO uiglat_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Shundaq qilip sen manga öz oghullirim we qizlirimni söyüp uzitip qoyush pursitinimu bermiding. Bu ishta exmeqliq qilding. ");
INSERT INTO uiglat_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Silerge ziyan-zexmet yetküzüsh qolumdin kéletti; lékin tünügün kéche atangning Xudasi manga söz qilip: «Hézi bol, Yaqupqa ya aq ya kök déme» dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Xosh, sen atangning öyini tolimu séghin’ghining üchün ketmey qoymaysen; lékin némishqa yene méning butlirimni oghriliding? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaqup Laban’gha jawab bérip: — Men qorqup qachtim; chünki séni qizlirini mendin mejburiy tartiwalamdikin, dédim. ");
INSERT INTO uiglat_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Emdi butliringgha kelsek, ular kimdin chiqsa shu tirik qalmaydu! Qérindashlirimiz aldida mendin qandaqla némengni tonuwalsang, uni élip ket, — dédi. Halbuki, Yaqupning Rahilening butlarni oghrilap kelginidin xewiri yoq idi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban aldi bilen Yaqupning chédirigha kirip, andin Léyahning chédiri hem ikki dédekning chédirlirigha kirip axturup héchnéme tapalmidi. Léyahning chédiridin chiqip, Rahilening chédirigha kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahile bolsa öy butlirini élip, bularni tögining chomining ichige tiqip qoyup, üstide olturuwalghanidi. Laban pütkül chédirini axturup, héchnéme tapalmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahile atisigha: — Ey xojam, aldingda turalmighinim üchün xapa bolmighin; chünki men hazir ayallarning adet mezgilide turuwatimen, — dédi. Shundaq qilip, Laban hemme yerni qoymay axturupmu, öy butlirini tapalmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Shuning bilen Yaqup achchiqlap Laban bilen jédelliship ketti. Yaqup Laban’gha: — Sen méni keynimdin munche aldirap-ténep qoghlap kelgüdek mende néme sewenlik, néme gunah bar? ");
INSERT INTO uiglat_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Sen hemme yük-taqlirimni axturup chiqting, öyüngning nersiliridin birer néme tapalidingmu? Birnéme tapqan bolsang, méning qérindashlirim bilen séning qérindashliringning aldida uni qoyghin, ular biz ikkimizning arisida höküm qilsun. ");
INSERT INTO uiglat_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Men mushu yigirme yil qéshingda turdum; héchqachan saghliqing we chishi öchkiliring bala tashliwetmidi; padiliringdin qochqarliringni yéginim yoq. ");
INSERT INTO uiglat_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Boghuwétilgenlirini qéshinggha élip kelmey, bu ziyanni özüm toldurdum; kéchisi oghrilan’ghan yaki kündüzi oghrilan’ghan bolsun sen uni mendin tölitip alding. ");
INSERT INTO uiglat_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Méning künlirim shundaq öttiki, kündüzi issiqtin, kéchisi soghuqtin qiynilip, uyqu közümdin qachatti. ");
INSERT INTO uiglat_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Méning künlirim mushu yigirme yilda öyüngde turup shundaq boldi; on töt yil ikki qizing üchün sanga xizmet qildim, alte yil padang üchün xizmet qildim; uning üstige sen ish heqqimni on qétim özgertting. ");
INSERT INTO uiglat_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Eger atamning Xudasi, yeni Ibrahimning Xudasi, yeni Ishaqning Qorqunchisi Bolghanning Özi men bilen bille bolmisa idi, sen jezmen méni quruq qol qilip qayturuwétetting. Lékin Xuda méning tartqan jebir-japalirimni, qollirimning musheqqitini körüp tünügün kéche sanga tenbih berdi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban Yaqupqa jawab bérip: — Bu qizlar méning qizlirim, bu oghullar méning oghullirim, bu pada bolsa méning padam bolidu; shundaqla köz aldingdiki hemme nerse miningkidur; emma men bügün bu qizlirimni we ularning tughqan oghullirini néme qilay? ");
INSERT INTO uiglat_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Qéni kel, sen bilen ikkimiz bir ehde tüzüsheyli, bu men bilen séning otturimizda guwah bolsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Shuning bilen Yaqup bir tashni élip öre tiklep tüwrük qilip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Andin Yaqup qérindashlirigha: — Tash yighinglar, — déwidi, tashlarni élip kélip döwilidi, shu yerde tash döwisining yénida ghizalinishti. ");
INSERT INTO uiglat_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban bu döwini «Yegar-Sahaduta» dep atidi, Yaqup uninggha «Galéed» dep at qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban: — Bu döwe bügün sen bilen méning otturamda guwah bolsun, — dédi. Shunga bu sewebtin döwining nami «Galéed» ataldi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","U jay yene «Mizpah», depmu ataldi; chünki Laban yene: — Ikkimiz bir-birimiz bilen körüshmigen waqitlarda, Perwerdigar sen bilen méning otturamda qarawul bolup közitip tursun. ");
INSERT INTO uiglat_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Eger sen qizlirimni bozek qilsang, yaki qizlirimning üstige bashqa xotunlarni alsang, bashqa héch kishi qéshimizda hazir bolmighan teqdirdimu, mana, Xuda men bilen séning arangda guwahchidur! ");
INSERT INTO uiglat_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban Yaqupqa yene: — Mana, bu döwige qara, men bilen sen ikkimizning otturisida men tiklep qoyghan bu tüwrükkimu qara; ");
INSERT INTO uiglat_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","kelgüside bu döwe we bu tüwrükmu men yaman niyet bilen bu döwidin séning teripingge ötmeslikim üchün, séningmu niyitingni yaman qilip bu döwe we bu tüwrüktin ötüp méning teripimge kelmesliking üchün guwahchi bolsun. ");
INSERT INTO uiglat_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ibrahimning ilahi, Nahorning ilahi we bu ikkisining atisining ilahliri arimizda höküm chiqarsun, — dédi. Yaqup bolsa atisi Ishaqning Qorqunchisi Bolghuchi bilen qesem qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Andin Yaqup tagh üstide bir qurbanliq sunup, qérindashlirini özi bilen tamaqlinishqa teklip qildi. Ular hemdastixan olturdi we kéchisi taghda qondi. ");
INSERT INTO uiglat_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Etisi tang seherde Laban ornidin turup, newriliri bilen qizlirini söyüp, ulargha bext-beriket tilep, öz öyige rawan boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaqup öz yoligha kétip baratti; yolda Xudaning perishtiliri uninggha uchridi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaqup ularni körüp: — Bu jay Xudaning bargahi iken! — dep, bu jayning namini «Mahanaim» dep qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Andin Yaqup Séir zéminidiki «Édom yayliqi»gha, akisi Esawning qéshigha aldin xewerchilerni ewetip, ");
INSERT INTO uiglat_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ulargha jékilep: — Siler xojamgha, yeni Esawgha: «Keminiliri Yaqup mundaq dédi: — Men Labanning qéshida musapir bolup, ta mushu waqitqiche turdum. ");
INSERT INTO uiglat_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Emdi mende kala, éshek we qoylar, qul-dédeklermu bar; men özlirining neziride iltipat taparmenmikin dep xojamgha xewer yetküzüshni layiq kördüm», denglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Xewerchiler Yaqupning yénigha yénip kélip: — Biz akiliri Esawning qéshigha barduq; u töt yüz kishini élip, silining aldilirigha kéliwatidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaqup nahayiti qorqup, ghem-ghussige chüshüp ademlirini qoy, kala we tögilirige qoshup, ikki topqa ayridi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","U: — «Eger Esaw kélip bir topimizgha hujum qilsa, yene bir top qéchip qutulup qalar» — dep oylidi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Andin Yaqup mundaq dua qildi: — I atam Ibrahimning Xudasi we atam Ishaqning Xudasi! Manga: «Öz zémining we uruq-tughqanliringning qéshigha yénip ketkin, sanga yaxshiliq qilimen» dep wede qilghan Perwerdigar! ");
INSERT INTO uiglat_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","— Men Séning Öz qulunggha körsetken özgermes barliq méhribanliqing we barliq wapadarliqing aldida héchnéme emesmen; chünki men bu Iordan deryasidin ötkinimde yalghuz bir hasam bar idi. Emdi men ikki top adem bolup qaytiwatimen. ");
INSERT INTO uiglat_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ötünüp qalay, méni akam Esawning qolidin qutquzghaysen; chünki u kélip men bilen xotun-balilirimni öltürüwétemdikin, dep qorqimen. ");
INSERT INTO uiglat_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Sen: «Men jezmen sanga zor yaxshiliq qilip, séning neslingni déngizdiki qumdek heddi-hésabsiz köp qilimen», dégeniding, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","U shu kéchisi shu yerde qonup qaldi; andin u qol ilikidiki mallardin élip, akisi Esawgha ikki yüz öchke, yigirme téke, ikki yüz saghliq, yigirme qochqar, ottuz chishi tögini taylaqliri bilen, qiriq inek, on buqa, yigirme mada éshek, on hangga éshekni sowghat qilip teyyarlap, ");
INSERT INTO uiglat_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Bularni ayrim-ayrim top qilip xizmetkarlirining qoligha tapshurup, ulargha jékilep: — Siler mendin burun méngip, her topning arisida ariliq qoyup heydep ménginglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","U eng aldidiki top bilen mangghan kishike emr qilip: — Akam Esaw sanga uchrighanda, eger u sendin: «Kimning adimisen? Qeyerge barisen? Aldingdiki janiwarlar kimning?» — dep sorisa, ");
INSERT INTO uiglat_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Undaqta sen jawab bérip: «Bular keminiliri Yaqupning bolup, xojam Esawgha ewetken sowghattur. Mana, u özimu keynimizdin kéliwatidu» — dégin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Shu teriqide u ikkinchi, üchinchi we ulardin kéyinki padilarni heydep mangghuchi kishilergimu oxshash emr qilip: — Esaw sizlerge uchrighanda, silermu uninggha shundaq denglar, andin: — Mana, keminiliri Yaqup özimu arqimizdin kéliwatidu, — denglar, dédi; chünki u: — Men aldimda barghan sowghat bilen uni méni kechürüm qildurup, andin yüzini körsem, méni qobul qilarmikin, — dep oylighanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Shundaq qilip sowghat aldin ewetildi; u shu kéchisi bargahta qonup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","U shu kéchide qopup, ikki ayali we ikki dédiki we on bir oghlini élip, Yabbok kéchikidin ötüp ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","U ularni éqindin ötküzdi, shundaqla hemme teelluqinimu u qarshi terepke ötküzdi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yaqup bolsa bu qatta yalghuz qaldi; bir zat kélip shu yerde uning bilen tang atquche chélishti. ");
INSERT INTO uiglat_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Lékin bu zat uni yéngelmeydighanliqini körüp, uning yotisining yiriqigha qolini tegküzüp qoydi; shuning bilen ular chélishiwatqanda Yaqupning yotisi qazandin chiqip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","U zat: — Méni qoyup bergin, chünki tang atay dep qaldi, dédi. — Sen méni beriketlimigüche, séni qoyup bermeymen, dédi Yaqup. ");
INSERT INTO uiglat_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","U uningdin: — Éting néme? dep soridi. U: étim Yaqup, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","U uninggha: — Séning éting buningdin kéyin Yaqup bolmay, belki Israil bolidu; chünki sen Xuda bilenmu, insan bilenmu éliship ghalib kelding, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Andin Yaqup uningdin: — Namingni manga dep bergin, déwidi, u: — Némishqa méning namimni soraysen? — dédi we shu yerde uninggha bext-beriket ata qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Shuning bilen Yaqup: — Xudani yüzmu-yüz körüp, jénim qutulup qaldi, dep u jayning namini «Peniel» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","U Penieldin ötüp mangghanda, kün uning üstibéshini yorutti; emma u yotisi tüpeylidin aqsap mangatti . ");
INSERT INTO uiglat_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Bu sewebtin Israillar bügün’giche yotining ügisidiki peyni yémeydu; chünki shu Zat Yaqupning yotisining yiriqigha, yeni uning péyige qolini tegküzüp qoyghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaqup béshini kötürüp qariwidi, mana Esaw töt yüz kishi bilen kéliwatatti. Shuning bilen u balilirini ayrip, Léyah, Rahile we ikki dédekke tapshurdi; ");
INSERT INTO uiglat_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","u ikki dédek we ularning balilirini hemmining aldida mangdurdi, andin Léyah bilen uning balilirini, eng axirida Rahile bilen Yüsüpni mangdurdi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Özi bolsa ularning aldigha ötüp mangdi, u akisining aldigha yétip barghuche yette qétim yerge bash urup tezim qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaw uning aldigha yügürüp kélip, uni quchaqlap, boynigha gire sélip, uni söydi; her ikkisi yighliship ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Andin Esaw béshini kötürüp qarap, ayallar we balilarni körüp: — Bu sen bilen bille kelgenler kimler? — dep soridi. Yaqup: — Bular Xuda shapaet qilip keminilirige bergen balilardur, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Andin ikki dédek we ularning baliliri aldigha bérip, uninggha tezim qildi; ");
INSERT INTO uiglat_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Andin Léyahmu uning baliliri bilen aldigha bérip, tezim qildi, axirida Yüsüp bilen Rahile aldigha bérip, tezim qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaw: — Manga yolda uchrighan ashu topliringda néme meqsiting bar? — déwidi, Yaqup jawab bérip: — Bu xojamning aldida iltipat tépishim üchündur, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Lékin Esaw: — Ey qérindishim, mende yétip ashqudek bar. Séning öz nersiliring özüngge qalsun, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Emma Yaqup: — Undaq qilmighin; eger men nezerliride iltipat tapqan bolsam, sowghitimni qolumdin qobul qilghayla; chünki silining méni xushalliq bilen qobul qilghanlirini körüp, didarlirini körginimde Xudaning didarini körgendek boldum! ");
INSERT INTO uiglat_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Emdi sanga keltürülgen, Xudadin körgen bu beriketlirimni qobul qilghayla; chünki Xuda manga shapaet körsetti, hemme nersilirim bar boldi, — dep uningdin qayta-qayta ötünüwidi, u qobul qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Andin Esaw: — Emdi biz qozghilip sepirimizni dawamlashturayli, men séning aldingda mangay, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","U uninggha jawaben: — Xojam kördile, balilar kichik, qéshimda émidighan qoza we mozaylar bar; eger men bularni bir künla aldirtip qoghlap mangdursam, pütkül pada ölüp kétidu. ");
INSERT INTO uiglat_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Shunga ötünimenki, xojam keminiliridin aldida mangghach tursun; men aldimdiki mal-charwilarning méngishigha, shundaqla balilarning méngishigha qarap asta méngip, xojamning qéshigha Séirgha udul baray, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","U waqitta Esaw: — Undaq bolsa, men özüm bilen kelgen kishilerdin birnechchini qéshingda qoyup kétey, dédi. Lékin u jawab bérip: — Buning néme hajiti? Peqet xojamning neziride iltipat tapsamla shu kupaye, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esaw u küni yolgha chiqip Séirgha yénip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaqup seper qilip, Sukkot dégen jaygha kelgende, u yerge bir öy sélip, mallirigha lapaslarni yasidi. Shunga bu yer «Sukkot» dep ataldi. ");
INSERT INTO uiglat_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Shu teriqide Yaqup Padan-Aramdin qaytip, Qanaan zéminidiki Shekem shehirige aman-ésen keldi. U sheherning aldida chédir tikti. ");
INSERT INTO uiglat_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Andin u chédir tikken yerning bir qisimini Shekemning atisi bolghan Hamorning oghulliridin bir yüz qesitige sétiwélip, ");
INSERT INTO uiglat_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Shu yerde bir qurban’gah sélip, namini «El-Elohe-Israil» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Bir küni, Léyahning Yaqupqa tughup bergen qizi Dinah yurtning qizliri bilen körüshkili chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shu yurtning emiri hiwiy Hamorning oghli Shekem uni körüp qélip, uni tutuwélip, zorlap nomusigha tegdi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Emma uning köngli Yaqupning qizi Dinahqa chüshüp, uni yaxshi körüp qaldi we uninggha muhebbiti bilen köngül soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shuning bilen Shekem atisi Hamordin: — Bu qizni manga xotunluqqa élip bergin, dep telep qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaqup Shekemning qizi Dinahning ippitige tegkenlikini anglap qaldi. Uning oghulliri malliri bilen dalalarda idi; shunga Yaqup ular kelgüche jim turup turdi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Shekemning atisi Hamor Yaqupning aldigha uning bilen sözleshkili chiqti; ");
INSERT INTO uiglat_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaqupning oghulliri xewerni anglapla dalalardin qaytip kelgenidi. Bular Shekemning qilmaydighan ishni qilip, Yaqupning qizining nomusigha tégip Israil qebiliside shermendilik qilghini üchün azablinip, intayin qattiq ghezeplendi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor ulargha söz qilip: — Oghlum Shekemning köngli qizinglargha chüshüp qaptu. Iltipat qilip uni oghlumgha xotunluqqa bersenglar! ");
INSERT INTO uiglat_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Biz bilen quda-baja bolup, qizliringlarni bizge béringlar, bizning qizlirimiznimu siler élinglar; ");
INSERT INTO uiglat_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Biz bilen bille turunglar. Mana, yer aldinglarda turuptu; bu yerni makan qilip, soda qilip, özünglar üchün öy-mülük élinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shekem qizning atisi bilen aka-ukilirigha: — Neziringlarda iltipat tapsam deymen; siler néme désenglar, shuni bérey. ");
INSERT INTO uiglat_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mendin qanchilik toyluq yaki sowghat telep qilsanglar, manga éytqininglarche bérey; peqet bu qizni manga xotunluqqa bersenglarla bolidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yaqupning oghulliri bolsa Shekem we atisi Hamorgha hiyle-mikir bilen jawab berdi, chünki u singlisi Dinahning ippitige tegkenidi; ");
INSERT INTO uiglat_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ulargha: — Biz bundaq qilalmaymiz, singlimizni xetnisiz birsige bérishke maqul déyelmeymiz; chünki bu bizge nomus bolidu. ");
INSERT INTO uiglat_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Peqet bir shertimizge könsenglarla silerge maqul bolimiz; silerning barliq erkekliringlar xetne qilinip bizdek bolsa, ");
INSERT INTO uiglat_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Qizlirimizni silerge bérip, silerning qizliringlarni biz élip aranglarda olturup, bir qowm bolup qalimiz. ");
INSERT INTO uiglat_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Emma bizge qulaq salmay xetne qilinishqa unimisanglar, undaqta biz qizimizni élip kétimiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ularning sözliri Hamor we oghli Shekemning nezirige yaqti. ");
INSERT INTO uiglat_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Yigit bu ishni keynige sozmidi, chünki u Yaqupning qizigha éjil bolup qalghanidi; u atisining öyide hemmidin etiwarliq idi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Shuning bilen Hamor oghli Shekem bilen sheherning derwazisigha bérip, sheherning ademlirige söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Bu ademlerning biz bilen inaq ötküsi bar. Shunga ular mushu yurtta turup soda-sétiq qilsun; mana, bu jayning ikki teripi ulargha yetküdek kengridur. Biz ularning qizlirini xotunluqqa élip, öz qizlirimizni ulargha bérimiz. ");
INSERT INTO uiglat_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Lékin peqet arimizdiki hemme erkek ular xetne qilin’ghandek xetne qilinsa, u ademler arimizda turup biz bilen bir xelq bolushqa maqul deydu. ");
INSERT INTO uiglat_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Shu teriqide ularning mal-teelluqati, hemme charpayliri bizningki bolmamdu? Biz peqet ulargha maqul désekla, ular arimizda turidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Shuning bilen sheherning derwazisidin kirip-chiqidighanlarning hemmisi Hamor bilen oghli Shekemning sözige qulaq saldi. Sheherning derwazisidin kirip-chiqadighanlarning hemmisi xetne qilindi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Emma üchinchi küni, ular téxiche aghriq yatqinida shundaq boldiki, Yaqupning ikki oghli, yeni Dinahning akiliri Shiméon bilen Lawiy herqaysisi öz qilichini élip, sheher xatirjemlik ichide turghinida bésip kirip, hemme erkekni öltürüwetti;    ");
INSERT INTO uiglat_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ular Hamor bilen oghli Shekemnimu qilichlap, Dinahni Shekemning öyidin élip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Andin Yaqupning barliq oghulliri: «Ular singlimizning nomusigha tegdi» dep, öltürülgenlerning jayigha kélip, sheherni bulap-talang qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ularning qoy-kala, ésheklirini, sheherdiki hemmini, étizliqlardiki hemmini élip ketti, ");
INSERT INTO uiglat_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Shundaqla ularning barliq mal-mülkini bulap-talap, barliq xotun-balilarni esir qilip, öy ichidiki barliq nersilernimu qoshup élip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaqup Shiméon we Lawiyni eyiblep: — Siler méni balagha tiqip, zémindikiler — Qanaaniylar bilen Perizziylerning aldida sésittinglar. Bizning adimimiz az bir xelqturmiz; ular manga qarshi chiqip yighilip hujum qilidu; shuning bilen men we jemetim weyran bolimiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Emma ular jawab bérip: — Ejeba, singlimizgha bir pahishe ayalgha qilghandek muamile qilsa bolamdu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Andin Xuda Yaqupqa: — Sen hazir Beyt-Elge chiqip, shu yerni makan qil, özüng akang Esawdin qéchip mangghiningda sanga körün’gen Men Tengrige bir qurban’gah yasighin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Shuning bilen Yaqup öyidikiler we özi bilen bille bolghanlarning hemmisige mundaq dédi: — Aranglardiki yat ilah butlirini tashliwétip, özünglarni paklap éginliringlarni yenggüshlenglar. ");
INSERT INTO uiglat_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Andin qopup Beyt-Elge chiqimiz. Men shu yerde qiyinchiliqta qalghanda duayimni ijabet qilip, yürgen yolumda méning bilen bille bolup kelgen Tengrige qurban’gah salay, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Shuning bilen öz qolliridiki hemme yat ilah butlirini, shundaqla qulaqliridiki zirilerni chiqirip Yaqupqa berdi. Yaqup bularni Shekemdiki dub derixining tüwige kömüp qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Andin ular seperge atlandi; emma etrapidiki sheherlerni Xudadin bolghan bir wehime basqachqa, ular Yaqupning oghullirini qoghlimidi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Bu teriqide Yaqup we uning bilen bille bolghanlarning hemmisi Qanaan zéminidiki Luz, yeni Beyt-Elge yétip keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","U shu yerde bir qurban’gah yasidi; akisidin qéchip mangghinida shu yerde Xuda uninggha körün’gini üchün bu jayning ismini «El-Beyt-El» dep atidi.    ");
INSERT INTO uiglat_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Riwkahning inik’anisi Deborah bolsa shu yerde alemdin ötti. U Beyt-Elning ayighidiki dub derixining tüwide depne qilindi. Bu sewebtin shu derex «Yigha-Zarning dub derixi» dep ataldi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yaqup shu yol bilen Padan-Aramdin yénip kelgendin kéyin, Xuda uninggha yene bir qétim körünüp, uninggha bext-beriket ata qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Andin Xuda uninggha: — Séning isming Yaquptur; emma mundin kéyin sen Yaqup atalmay, belki naming Israil bolidu, dep uning ismini Israil qoyup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Andin Xuda yene uninggha: — Men Özüm Hemmige Qadir Tengridurmen; sen nesillinip, köpeygin; bir el, shundaqla bir türküm eller sendin peyda bolidu; padishahlarmu séning pushtungdin chiqidu.    ");
INSERT INTO uiglat_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Men Ibrahim we Ishaqqa bergen zéminni sanga bérimen, shundaqla sendin kéyinki neslinggimu shu zéminni bérimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Andin Xuda uning bilen sözleshken jaydin, uning yénidin yuqirigha kötürüldi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaqup Xuda özi bilen sözleshken jayda bir tash tüwrükni tiklep, üstige bir sharab hediyesini tökti we zeytun méyi quyup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaqup Xuda özi bilen sözleshken shu jayning namini «Beyt-El» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Andin ular Beyt-Eldin méngip, Efratqa azghina yol qalghanda, Rahileni tolghaq tutup kétip, qattiq tughut azabida qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Emma tolghiqi qattiq éghirlashqanda, tughut anisi uninggha: — Qorqmighin, bu qétim yene bir oghlung bolidighan boldi — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Shundaq boldiki, Rahile jéni chiqish aldida, axirqi nepisi bilen oghligha «Ben-Oni» dep isim qoydi; emma uning atisi uni «Ben-Yamin» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahile wapat boldi we Beyt-Lehem dep atilidighan Efratning yolining boyigha depne qilindi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaqup uning qebrisining üstige bir xatire téshi tiklep qoydi. Bügün’ge qeder «Rahilening Qebre Téshi» shu yerde turmaqta. ");
INSERT INTO uiglat_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Andin Israil seperni dawamlashturup Migdal-Édirning u teripide öz chédirini tikti. ");
INSERT INTO uiglat_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israil u zéminda turghan waqtida, Ruben bérip öz atisining kéniziki Bilhah bilen bir orunda yatti; Israil buni anglap qaldi. Yaqupning on ikki oghli bar idi: — ");
INSERT INTO uiglat_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Léyahdin tughulghan oghulliri: — Yaqupning tunji oghli Ruben we Shiméon, Lawiy, Yehuda, Issakar hem Zebulun idi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahiledin tughulghan oghulliri: — Yüsüp we Binyamin idi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahilening dédiki Bilhahdin tughulghan oghulliri: — Dan we Naftali idi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Léyahning dédiki Zilpahdin tughulghan oghulliri: — Gad bilen Ashir idi. Bular bolsa Yaqupqa Padan-Aramda tughulghan oghulliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Emdi Yaqup atisi Ishaqning qéshigha, Ibrahim we Ishaq musapir bolup turghan Kiriat-Arba, yeni Hébronning yénidiki Mamrege keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ishaqning körgen künliri bir yüz seksen yil boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ishaq tolimu qérip, künliri toshup, nepestin toxtap wapat boldi we öz qowmining qéshigha bérip qoshuldi. Uning oghulliri Esaw bilen Yaqup uni depne qildi.    ");
INSERT INTO uiglat_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Töwendikiler Esawning ewladliridur (Esaw yene Édom depmu atilidu): —    ");
INSERT INTO uiglat_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaw ayallirini Qanaaniylarning qizliridin aldi, yeni hittiylardin bolghan Élonning qizi Adah bilen hiwiylardin bolghan Zibéonning newrisi, Anahning qizi Oholibamahni aldi; ");
INSERT INTO uiglat_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","uningdin bashqa Ismailning qizi, Nébayotning singlisi Basimatnimu alghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah Esawgha Élifazni tughup berdi; Basimat bolsa Réuelni tughdi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah Yeush, Yaalam we Korahni tughdi; bular Qanaan zéminida Esawgha tughulghan oghullar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaw ayalliri, oghul-qizliri, öyidiki hemme kishilirini we charpaylirini, barliq ulaghlirini, shundaqla Qanaan zéminida tapqan barliq teelluqatlirini élip, inisi Yaquptin ayrilip, bashqa bir yurtqa köchüp ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Chünki her ikkisining teelluqatliri intayin köp bolghachqa, bir yerde bille turalmaytti; musapir bolup turghan zémin ularning mal-charwilirining köplükidin ularni baqalmaytti. ");
INSERT INTO uiglat_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Buning bilen Esaw (Esaw Édom depmu atilidu) Séir téghigha bérip, olturaqliship qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Töwendikiler taghliq rayon Séirdiki Édomiylarning ata-bowisi Esawning ewladliridur: — ");
INSERT INTO uiglat_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esawning oghulliri: — Esawning ayali adahning oghli Élifaz; Esawning ayali Basimatning oghli Réuel. Élifazning oghulliri: — Téman, Omar, Zefo, Gatam we Kenaz idi. Esawning oghli Élifazning kichik xotuni Timna idi; u Élifazgha Amalekni tughup berdi. Yuqirilar bolsa Esawning ayali adahning ewladliri idi. Réuelning oghulliri: — Nahat, Zerah, Shammah we Mizzah idi; bular Esawning ayali Basimatning ewladliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esawning ayali, yeni Zibéonning chong qizi, Anahning qizi bolghan Oholibamahning oghulliri: u Esawgha Yeush, Yaalam we Korahni tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esawning ewladlirining ichidin töwendiki emirler chiqqan: — Esawning tunji oghli Élifazning oghulliridin: — emir Téman, emir Omar, emir Zefo, emir Kénaz, ");
INSERT INTO uiglat_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","emir Korah, emir Gatam we emir Amalek chiqqan. Bular Édom zéminida Élifazning neslidin chiqqan emirler bolup, Adahning ewladliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esawning oghli Réuelning oghulliridin emir Nahat, emir Zerah, emir Shammah we emir Mizzahlar chiqqan; bular Édom zéminida Réuelning neslidin chiqqan emirlerdur; bularning hemmisi Esawning ayali Basimatning ewladliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esawning ayali Oholibamahning oghulliridin emir Yeush, emir Yaalam we emir Korahlar chiqqan. Bular Anahning qizi, Esawning ayali Oholibamahning neslidin chiqqan emirler idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bular Esawning, yeni Édomning ewladliri bolup, édomiylarning emirliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Horiylardin bolghan Séirning Édom zéminida olturghan ewladliri: — Lotan, Shobal, Zibéon, Anah, Dishon, Ézer we Dishan idi. Bular Séirning ewladliri bolup, Édom zéminida Horiylarning emirliri idi.    ");
INSERT INTO uiglat_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotanning oghulliri Hori bilen Hémam idi; Lotanning singlisi Timna idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobalning oghulliri: Alwan, Manahat, Ébal, Shéfo we Onam idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibéonning oghulliri: — Ayah we Anah idi. Bu Anah chölde atisi Zibéonning ésheklirini béqiwétip, arshanglarni tépiwalghan Anahning del özi shu idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anahning perzentliri: oghli Dishon; Anahning qizi Oholibamah idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishonning oghulliri: Hemdan, Eshban, Itran we Kéran idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ézerning oghulliri: Bilhan, Zaawan we Akan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishanning oghulliri: Uz we Aran idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Horiylarning özlirining emirliri: emir Lotan, emir Shobal, emir Zibéon, emir Anah, emir Dishon, emir Ézer we emir Dishan idi. Bular bolsa Horiylarning Séir zéminida öz namliri boyiche atalghan qebililerning emirliri idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israillarning üstige héch padishah téxi seltenet qilmasta Édom zéminida seltenet qilghan padishahlar töwendikidek: — ");
INSERT INTO uiglat_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béorning oghli Béla Édomda seltenet qildi; uning shehirining ismi Dinhabah idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Béla ölgendin kéyin, Bozrahliq Zerahning oghli Yobab uning ornida seltenet qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab ölgendin kéyin, témaniylarning zéminidin kelgen Husham uning ornida seltenet qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham ölgendin kéyin, Bédadning oghli Hadad uning ornida seltenet qildi. U Moabning yaylaqlirida midiyaniylargha hujum qilip yenggenidi. Uning shehirining ismi Awit idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad ölgendin kéyin, masrekahliq Samlah uning ornida seltenet qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah ölgendin kéyin, «Deryaning boyidiki Rehobot»tin kelgen Saul uning ornida seltenet qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul ölgendin kéyin, Akborning oghli Baal-hanan uning ornida seltenet qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akborning oghli Baal-hanan ölgendin kéyin, Hadar uning ornida seltenet qildi. Uning shehirining ismi Pau idi. Uning ayalining ismi Mehétabel bolup, u Mey-Zahabning qizi bolghan Matredning qizi idi. ");
INSERT INTO uiglat_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esawning neslidin bolghan emirler ularning at-isimliri, jemetliri, nesebnamiliri we turghan jayliri boyiche: emir Timna, emir Alwah, emir Yehet, emir Oholibamah, emir Élah, emir Pinon, emir Kénaz, emir Téman we emir Mibzar, emir Magdiyel we emir Iramlar idi. Bular Édomiylarning emirliri bolup, özliri igilep olturaqlashqan jaylar öz namliri bilen atalghanidi. Mana shu teriqide Esaw Édomiylarning ata-bowisi boldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaqup bolsa atisi musapir bolup turghan yerde, yeni Qanaan zéminida olturaqlashti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Töwendikiler Yaqup ewladlirining ish-izliridur. Yüsüp yigit bolup on yette yashqa kirgen chaghlirida, akiliri bilen bille qoylarni baqatti; u atisining kichik xotunliri Bilhah we Zilpahning oghulliri bilen bille ishleytti. Yüsüp atisigha ularning nachar qiliqlirini éytip qoyatti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yüsüp Israilning qérighan waqtida tapqan balisi bolghachqa, uni bashqa oghulliridin bekrek yaxshi köretti. Shunga u Yüsüpke uzun yenglik ton tiktürüp berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Emma akiliri atisining uni özliridin yaxshi köridighinini körüp, uninggha öch bolup qalghanidi we uninggha chirayliq gep qilmatti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Uning üstige Yüsüp bir chüsh körgen bolup, uni akilirigha dep bériwidi, ular uninggha téximu öch bolup ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yüsüp ulargha mundaq dédi: — Méning körgen shu chüshümni anglap béqinglar. ");
INSERT INTO uiglat_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mana, biz hemmimiz étizlarda ashliqlarni baghlawatqudekmiz. Qarisam méning önchem öre turuptidek; silerning önchenglar bolsa méning önchemning chörisige oliship tezim qilip turghudek! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Akiliri uningdin: — Ejeba, sen bizge padishah bolamsen? Üstimizge hökümranliq qilamsen? — dep soridi. Uning körgen chüshliri we gépidin akiliri uni téximu yaman kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kéyin u yene bir chüsh kördi we chüshini akilirigha dep: — Mana, men yene bir chüsh kördüm. Qarisam, quyash bilen ay we on bir yultuz manga tezim qilip turghudek! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","U bu chüshni atisi we akilirigha dep berdi. Atisi uninggha tenbih bérip: — Bu körgining zadi qandaq chüsh? Ejeba, men, anang we aka-ukiliring aldinggha bérip, sanga yerge bash urup tezim qilimizmu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Shuning bilen akiliri uninggha heset qilghili turdi. Emma atisi shu gepni könglige püküp qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Emdi Yüsüpning qérindashliri atisining qoylirini baqqili Shekemge ketkenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israil Yüsüpke: — Akiliring Shekemde pada béqiwatidighu? Kel, men séni ularning qéshigha ewetey, déwidi, Yüsüp: — Mana men, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","U uninggha: — Emdi bérip akiliring aman-ésenmu-emesmu, qoylar aman-ésenmu-emesmu, manga xewirini élip kelgin, dep uni Hébron jilghisidin yolgha saldi; u Shekemge bardi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Shu yerde birsi uning dalada ténep yürginini körüp uningdin: — Néme izdewatisen, dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","U: — Men akilirimni izdewatimen. Ularning padilirini qeyerde béqiwatqanliqini éytip bersingiz, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","U adem jawab bérip: — Ular bu yerdin kétip qaldi, chünki men ularning: «Yürünglar, Dotan’gha barayli» déginini anglidim, dédi. Shuning bilen Yüsüp akilirining arqisidin bérip, ularni Dotandin tapti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ular uni yiraqtin körüp, u téxi ularning qéshigha kelmeyla, uni öltürüwétishni meslihetleshti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ular bir-birige: — Mana héliqi chüsh körgüchi kéliwatidu. ");
INSERT INTO uiglat_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kélinglar, uni öltürüp mushu yerdiki oreklerdin birige tashliwéteyli, andin: — Wehshiy bir haywan uni yep kétiptu, deyli. Shunda, biz uning chüshlirining néme bolidighinini körimiz! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Emma Ruben buni anglap uni ularning qolliridin qutquzmaqchi bolup: — Uni öltürmeyli, dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben ulargha yene: — Qan tökmenglar! Belki uni chöldiki mushu orekke tashliwétinglar; lékin uninggha qol tegküzmengler, dédi (emeliyette, u uni ularning qolidin qutquzup, atisining qéshigha qayturuwetmekchi idi). ");
INSERT INTO uiglat_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","Yüsüp akilirining qéshigha yétip kelgende ular uni tutup, uning alahide tonini, yeni kiyiklik uzun yenglik tonini salduruwélip, orekke tashliwetti. Lékin orek quruq bolup, ichide su yoq idi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Andin ular tamaq yégili olturdi. Ular béshini kötürüp qariwidi, mana Ismaillarning bir karwini Giléad tereptin kéliwatatti. Tögilirige dora-dermek, tutiya we murmekkiler artilghan bolup, Misir terepke kétiwatatti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yehuda qérindashlirigha: — Bizning bir tughqan qérindishimizni öltürüp, qénini yoshurghinimizning néme paydisi bar? ");
INSERT INTO uiglat_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kélinglar, uni Ismaillargha sétiwéteyli; qandaqla bolmisun u bizning inimiz, bir tughqan qérindishimiz; shunga uninggha qol salmayli, déwidi, qérindashliri buninggha qulaq saldi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Midiyanliq sodigerler shu yerdin ötüp kétiwatqanda, ular Yüsüpni orektin tartip chiqirip, ulargha yigirme kümüsh tenggige sétiwetti. Bular bolsa Yüsüpni Misirgha élip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben orekning yénigha qaytip kélip, Yüsüpning orekte yoqluqini körüp, kiyimlirini yirtip, ");
INSERT INTO uiglat_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","inilirining qéshigha bérip: — Bala yoq turidu! Emdi men nege baray?! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Emma ular Yüsüpning tonini élip, bir tékini boghuzlap tonni uning qénigha milep, ");
INSERT INTO uiglat_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Andin uzun yenglik tonni atisining qéshigha ewetip, uninggha: — Buni biz tépiwalduq; bu oghlungning tonimu-emesmu, özüng körüp baqqin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","U uni tonup: — Bu derweqe méning oghlumning toni iken; bir wehshiy haywan uni yep ketken oxshaydu; shübhisizki, Yüsüp titma-titma qiliwétiliptu! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Shuning bilen Yaqup kiyimlirini yirtip, bélige böz baghlap, nurghun künlergiche oghli üchün matem tutti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Uning hemme oghul-qizliri yénigha kélip uninggha teselli bersimu, u tesellini qobul qilmay: «Men tehtisaragha chüshüp oghlumning qéshigha barghuche shundaq matem tutimen!» dédi. Yüsüpning atisi shu péti uninggha ah-zar kötürüp matem tutti. ");
INSERT INTO uiglat_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Emdi midiyaniylar Yüsüpni Misirgha élip bérip, Pirewnning bir ghojidari, pasiban béshi Potifargha satti.    ");
INSERT INTO uiglat_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","U waqitlarda shundaq boldiki, Yehuda aka-ukilirining qéshidin kétip, Hirah isimlik Adullamliq bir kishiningkige chüshti. ");
INSERT INTO uiglat_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Shu yerde Yehuda Shua isimlik bir Qanaaniyning qizini kördi; u uni xotunluqqa élip qéshigha kirip yatti.    ");
INSERT INTO uiglat_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","U hamilidar bolup bir oghul tughdi; Yehuda uninggha «Er» dep at qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","U yene hamilidar bolup, bir oghul tughdi we uninggha Onan dep at qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Andin yene hamilidar bolup bir oghul tughdi we uninggha Shelah dep at qoydi. U tughulghanda Yehuda Kézibda idi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yehuda tunji oghli Erge Tamar isimlik bir qizni élip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Lékin Yehudaning tunji oghli Er Perwerdigarning neziride rezil bolghachqa, Perwerdigar uni öltürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Bu chaghda Yehuda Onan’gha: — Akangning ayalining qéshigha kirip, uni xotunluqqa élip qérindashliq burchini Ada qilip, akang üchün nesil qaldurghin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Emma Onan bu nesilning özige tewe bolmaydighanliqini bilip, akisigha nesil qaldurmasliq üchün her qétim akisining ayali bilen bille bolghanda meniysini yerge aqturuwétetti. ");
INSERT INTO uiglat_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Uning bu qilmishi Perwerdigarning neziride rezil körün’gechke, unimu öltürüwetti. ");
INSERT INTO uiglat_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yehuda emdi kélini Tamargha: — Oghlum Shelah chong bolghuche atangning öyide tul olturup turghin, dédi. Chünki u ichide: — Bumu akilirigha oxshash ölüp kétermikin, dep qorqti. Shuning bilen Tamar bérip atisining öyide turup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Emdi köp künler ötüp, Shuaning qizi, Yehudagha tegken ayal öldi. Yehuda teselli tapqandin kéyin adullamliq dosti Hirah bilen bille özining qoy qirqighuchilirining ehwalini bilishke Timnahqa chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamargha: — Qéynatang qoylirini qirqighili Timnahqa yol aldi, dégen xewer yetti. ");
INSERT INTO uiglat_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Shuning bilen Tamar Shelah chong bolghan bolsimu, men uninggha xotunluqqa élip bérilmidim, dep qarap, tulluq kiyimini séliwétip, chümbel tartip bedinini orap, Timnah yolining üstide Enaimgha kirish éghizigha bérip olturdi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Emdi Yehuda uni yüzi yépiqliq halda körgende: — Bu bir pahishe ayal oxshaydu, dep oylidi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","U yoldin burulup uning yénigha bérip, öz kélini ikenlikini bilmey: — Kel, men sen bilen bille bolay, dédi. U jawab bérip: — Men bilen bille bolsang, manga néme bérisen? dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","U uninggha: — Padamning ichidin bir oghlaqni sanga ewetip bérey, dédi. Ayal: — Sen uni ekélip bergüche, manga renige birer nerse béremsen? dep soriwidi, ");
INSERT INTO uiglat_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","U: — Sanga némini renige bérey? — dédi. U: — Öz möhürüng bilen uning shoynisini we qolungdiki hasangni renige bergin, déwidi, u bularni bérip, uning bilen birge boldi. Shuning bilen u uningdin hamilidar bolup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Andin Tamar ornidin turup mangdi; u perenjini séliwétip, tulluq kiyimini kiyiwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yehuda: — U xotunning qolidiki renini yandurup kelsun dep adullamliq dostining qoli arqiliq oghlaqni ewetti, emma u uni tapalmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","U shu jaydiki ademlerdin: — Enaimdiki yolning boyida olturghan butperes pahishe qéni, dep sorisa, ular: — Bu yerde héchbir butperes pahishe bolghan emes, dep jawab berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Buning bilen u Yehudaning qéshigha yénip bérip: — Men uni tapalmidim; üning üstige u jaydiki ademlermu: «Bu yerde héchbir butperes pahishe ayal bolghan emes» déyishti, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yehuda: — Boptu, u nersilerni u élip ketse ketsun; bolmisa, bashqilarning mesxirisige qalimiz. Némila bolmisun, men uninggha oghlaq ewettim, lékin sen u xotunni tapalmiding, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Üch ayche ötkendin kéyin birsi Yehudagha: — Séning kélining Tamar buzuqchiliq qildi, uning üstige zinadin hamilidar bolup qaldi, dégen xewerni yetküzdi. Yehuda jawaben: — Uni élip chiqinglar, köydürüwétilsun! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Lékin u élip chiqilghanda qéynatisigha xewer ewetip: — Bu nersilerning igisi bolghan ademdin hamilidar boldum! Emdi sen körüp baq, bu möhür, shoynisi we hasining kimning ikenlikini étirap qilghin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yehuda bu nersilerni étirap qilip: — U manga nisbeten heqliqtur; derweqe men uni oghlum Shelahqa élip bermidim, dédi. Bu ishtin kéyin Yehuda uninggha yene yéqinchiliq qilmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Uning tughut waqti yéqinlashti, mana qorsiqida qoshkézek bar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","U tughqan waqtida balilardin birsi qolini chiqiriwidi, tughut anisi derhal bir qizil yipni élip: «Bu awwal chiqti» dep uning qoligha chigip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Lékin u qolini yene ichige tiqiwaldi, mana uning inisi chiqti. Shuning bilen tughut anisi: «Sen qandaq qilip bösüp chiqting!» dédi; shuning bilen uninggha «Perez» dégen at qoyuldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Andin qoligha qizil yip chigilgen akisi tughuldi. Uning ismi Zerah dep ataldi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yüsüp bolsa Misirgha élip kélindi; uni Pirewnning ghojidari, pasiban béshi Potifar shu yerge élip kelgen Ismaillarning qolidin sétiwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Lékin Perwerdigar Yüsüp bilen bille bolghachqa, uning ishliri onggha tartti; u misirliq xojisining öyide turup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Uning xojisi Perwerdigarning uning bilen bille ikenlikini, shundaqla u néme ish qilsa, Perwerdigarning uning qolida ronaq tapquzghanliqini bayqidi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Shuning bilen Yüsüp uning neziride iltipat tépip, uning xas xizmetchisi boldi. Xojisi uni öyini bashqurushqa qoydi we barliq teelluqatini uning qoligha tapshurdi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","We shundaq boldiki, u uni öyi we barliq teelluqatini bashqurushqa qoyghandin tartip, Perwerdigar bu misirliqning öyini Yüsüpning sewebidin beriketlidi; Perwerdigarning berikiti uning pütün ailisi we barliq tériqchiliqigha keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Shuning bilen Potifar barliq ishlirini Yüsüpning qoligha tapshurup, öz tamiqini yéyishtin bashqa héchqandaq ish bilen kari bolmidi. Yüsüp bolsa qamiti kélishken, xushchiray yigit idi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Birnechche waqit ötkendin kéyin shundaq boldiki, uning xojisining ayalining Yüsüpke közi chüshüp qélip: — Men bilen yatqin! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Emma u unimay xojisining ayaligha mundaq dédi: — Mana xojam öydiki ishlarni, shundaqla barliq teelluqatini qolumgha tapshurdi, manga tolimu ishinip ishlirim bilen kari bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Bu öyde mendin chong adem yoq. Sendin bashqa u héchbir nersini mendin ayimidi — chünki sen uning ayalidursen! Shundaq turuqluq men qandaqmu bundaq rezillikni qilip Xuda aldida gunahkar bolay? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Gerche her küni Yüsüpke shundaq désimu, shundaqla u uning bilen yétip uninggha yéqinchiliq qilishni yaki uning bilen birge turushni ret qilghan bolsimu, ");
INSERT INTO uiglat_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","shundaq bir weqe boldiki, bir küni u öz ishi bilen öy ichige kirgenidi, öydikilerdin héchqaysisi öyning ichide emes idi; ");
INSERT INTO uiglat_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","bu ayal uning tonini tutuwélip: — Men bilen yatqin! dédi. U tonini uning qoligha tashlap qoyup, yügürgen péti qéchip tashqirigha chiqip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ayal Yüsüpning tonini öz qoligha tashlap qéchip chiqip ketkinini körüp, ");
INSERT INTO uiglat_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","öyidiki xizmetchilirini chaqirip ulargha: — Qaranglar, érim bizge haqaret keltürsun dep bir ibraniy ademni élip keptu! Bu adem yénimgha kirip: «Sen bilen yatay» déwidi, qattiq warqiridim! ");
INSERT INTO uiglat_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","U méning qattiq warqirighinimni anglap, tonini yénimgha tashlap, tashqirigha qéchip ketti, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Shuning bilen xojisi öyige yénip kelgüche u Yüsüpning tonini yénida saqlap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Andin u érigimu shu gepni qilip: — Sen élip kelgen héliqi ibraniy qul manga haqaret qilishqa qéshimgha kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Lékin men qattiq warqirap-jarqirdim, u tonini qéshimda tashlap, tashqirigha qéchip ketti, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Uning xojisi ayalining: — Séning qulung méni undaq-mundaq qildi, dégen geplirini anglap ghezipi ottek tutashti. ");
INSERT INTO uiglat_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Shuning bilen Yüsüpning xojisi uni tutup orda munarliq zindan’gha qamap qoydi. Shu yerge peqet padishahning mehbusliri solinatti. Buning bilen u shu yerde solaqta yétip qaldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Lékin Perwerdigar Yüsüp bilen bille bolup, uninggha shapaet körsitip, uni zindan bégining neziride iltipat tapturdi. ");
INSERT INTO uiglat_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Shuning bilen zindan bégi gundixanida yatqan hemme mehbuslarni Yüsüpning qoligha tapshurdi. Shu yerde qilinidighan herqandaq ish uning qoli bilen bolatti. ");
INSERT INTO uiglat_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Zindan bégi Yüsüpning qolidiki héchqandaq ishtin ghem qilmatti; chünki Perwerdigar uning bilen bille bolup, u hernéme qilsa Perwerdigar uni ongushluq qilatti. ");
INSERT INTO uiglat_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bu ishlardin kéyin Misir padishahining saqiysi we bash nawiyi Misir padishahining zitigha tégip gunahkar bolup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Shuning bilen Pirewn uning bu ikki mensepdarigha, yeni bash saqiy we bash nawaygha ghezeplinip, ");
INSERT INTO uiglat_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ularni pasiban béshining sariyigha, Yüsüp solaqliq munarliq zindan’gha solap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Pasiban béshi Yüsüpni ularning xizmitide bolup ularni kütüshke teyinlidi. Ular solaqta birnechche kün yétip qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ular ikkisi — Misir padishahining saqiysi we nawiyi gundixanida solaqliq turghan bir kéchide chüsh kördi. Herbirining chüshining özige xas tebiri bar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Etisi etigende, Yüsüp ularning qéshigha kiriwidi, ularning ghemkin olturghinini kördi; ");
INSERT INTO uiglat_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","shunga u özi bilen bille xojisining sariyida solaqliq yatqan Pirewnning bu ikki mensepdaridin: — Némishqa chirayinglar bügün shunche solghun? — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ular uninggha jawab bérip: — Ikkimiz bir chüsh körduq; emma chüshimizning tebirini yéship béridighan kishi yoq, dédi. Yüsüp ulargha: — Chüshke tebir bérish Xudadin bolidu emesmu? Chüshünglarni manga éytip béringlar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Buning bilen bash saqiy Yüsüpke chüshini éytip: — Chüshümde aldimda bir üzüm téli turghudek; ");
INSERT INTO uiglat_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","bu üzüm télining üch shéxi bar iken. U bix urup chécheklep, saplirida uzum piship kétiptudek; ");
INSERT INTO uiglat_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pirewnning qedehi qolumda iken; men üzümlerni élip Pirewnning qedehige siqip, qedehni uning qoligha sunuptimen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yüsüp uninggha jawaben: Chüshning tebiri shudurki, bu üch shax üch künni körsitidu. ");
INSERT INTO uiglat_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Üch kün ichide Pirewn qeddingni ruslitip, séni mensipingge qaytidin teyinleydu. Buning bilen sen burun uninggha saqiy bolghandek Pirewnning qedehini uning qoligha sunidighan bolisen. ");
INSERT INTO uiglat_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Lékin ishliring ongushluq bolghanda méni yadinggha yetküzüp, manga shapaet körsitip Pirewnning aldida méning toghramda gep qilip, méni bu öydin chiqartqaysen. ");
INSERT INTO uiglat_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Chünki men heqiqeten ibraniylarning zéminidin naheq tutup élip kélindim; bu yerdimu méni zindan’gha salghudek bir ish qilmidim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Bash naway Yüsüpning shundaq yaxshi tebir berginini körüp uninggha mundaq dédi: — Menmu özümni chüshümde kördüm; mana, béshimda aq nan bar üch séwet bar iken. ");
INSERT INTO uiglat_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Eng üstünki séwette nawaylar Pirewn’ge pishurghan herxil nazunémetler bar iken; lékin qushlar béshimdiki u séwettiki nersilerni yep kétiptudek, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yüsüp jawaben: — Chüshning tebiri shudurki: — Bu üch séwet üch künni körsitidu. ");
INSERT INTO uiglat_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Üch kün ichide Pirewn séning béshingni késip, jesitingni derexke asidiken. Shuning bilen ucharqanatlar kélip göshüngni yeydiken, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Üchinchi küni shundaq boldiki, Pirewnning tughulghan küni bolghachqa, u hemme xizmetkarliri üchün bir ziyapet qilip berdi, shundaqla derweqe xizmetkarlirining arisida bash saqiyning béshini kötürdi we bash nawayning béshini aldi; ");
INSERT INTO uiglat_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","u bash saqiyni qaytidin öz mensipige teyinlidi; shuning bilen u Pirewnning qedehini uning qoligha qaytidin sunidighan boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Lékin bash nawayni bolsa Yüsüp ulargha tebir bergendek ésiwetti. ");
INSERT INTO uiglat_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Emma bash saqiy Yüsüpni héch eslimey, eksiche uni untup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Toptoghra ikki yil ötüp, Pirewn bir chüsh kördi. Chüshide u Nil deryasining boyida turghudek. ");
INSERT INTO uiglat_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Hem chirayliq hem sémiz yette tuyaq inek deryadin chiqip, qumushluqta otlaptudek. ");
INSERT INTO uiglat_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Andin yene yette tuyaq inek deryadin chiqiptu; ular set hem oruq bolup, aldinqi ineklerning yénida, deryaning boyida turuptu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bu set hem oruq inekler u yette chirayliq hem sémiz ineklerni yewétiptu. Shu waqitta Pirewn oyghinip kétiptu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","U yene uxlap, ikkinchi qétim chüsh kördi: — Mana, bir tüp bughday shéxidin toq we chirayliq yette bashaq chiqiptu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ulardin kéyin yene yette bashaq chiqiptu; ular hem oruq we puchek bolup, sherq shamilida soliship qalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bu oruq bashaqlar u yette sémiz, toq bashaqni yutup kétiptu. Andin Pirewn oyghinip kétiptu, bu uning chüshi iken. ");
INSERT INTO uiglat_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Etisi uning köngli nahayiti biaram bolup, Misirdiki hemme palchi-jadugerler bilen barliq danishmenlerni chaqirtip keldi. Pirewn öz chüshini ulargha éytip berdi; lékin héchkim Pirewn’ge chüshlerning tebirini dep bérelmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","U chaghda bash saqiy Pirewn’ge: — Bügün méning ötküzgen xataliqlirim ésimge keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Burun Pirewn janabliri qullirigha, yeni péqir we bash nawaygha achchiqlinip, bizni pasiban béshining sariyida solaqqa tashlighanidila; ");
INSERT INTO uiglat_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Shu chaghlarda herbirimiz bir kéchide birdin chüsh körduq; her qaysimiz körgen chüshning tebiri bashqa-bashqa idi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Shu yerde biz bilen bille pasiban béshining quli bolghan bir ibraniy yigit bar idi. Uninggha chüshlirimizni éytiwiduq, u bizge chüshlirimizning tebirini bayan qildi; u herbirimizning körgen chüshige qarap tebir bergenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Shundaq boldiki, ishlar del uning bergen tebiride déyilgendek yüz berdi; janabliri péqirni öz mensipimge qaytidin teyinlidile, bash nawayni dargha astila, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Shuning bilen Pirewn adem ewetip, Yüsüpni chaqirdi; ular derhal uni zindandin chiqardi. Yüsüp burut-saqilini chüshürüp, kiyimlirini yenggüshlep, Pirewnning aldigha kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pirewn Yüsüpke: — Men bir chüsh kördüm, emma uning tebirini éytip béreleydighan héchkim chiqmidi. Anglisam, sen chüshke tebir béreleydikensen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yüsüp Pirewn’ge jawab bérip: — Tebir bérish özümdin emes; lékin Xuda Pirewn’ge xatirjemlik béridighan bir jawab béridu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pirewn Yüsüpke: — Chüshümde men deryaning qirghiqida turuptimen. ");
INSERT INTO uiglat_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Qarisam, deryadin hem sémiz hem chirayliq yette tuyaq inek chiqip qumushluqta otlaptu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Andin ulardin kéyin ajiz, tolimu set hem oruq yette tuyaq inek chiqiptu. Men Misir zéminida shundaq set ineklerni körgen emesmen. ");
INSERT INTO uiglat_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bu oruq, eski inekler bolsa awwalqi yette sémiz inekni yewétiptu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ularni yewetken bolsimu, qorsiqigha bir némining kirgenliki héch ayan bolmaptu, ularning körünüshi belki burunqidek set imish. Andin men oyghinip kettim. ");
INSERT INTO uiglat_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Andin yene bir chüsh kördum, mana bir shaxtin yette hem toq hem chirayliq bashaq chiqiptu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Andin yene yette puchek, oruq bashaq chiqiptu; ular sherq shamili bilen soliship qurup kétiptu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Bu oruq bashaqlar yette chirayliq bashaqni yep kétiptu. Men bu ishni palchi-jadugerlerge dep bersem, manga tebirini éytip béridighan héch kishi chiqmidi, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yüsüp Pirewn’ge: — Janabliri Pirewnning chüshliri bir menididur. Xuda Özi qilmaqchi bolghan ishlirini Pirewn’ge aldin bildürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bu yette yaxshi inek yette yilni körsitidu; yette yaxshi bashaqmu yette yilni körsitidu. Bu chüshler oxshash bir chüshtur. ");
INSERT INTO uiglat_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ulardin kéyin chiqqan yette oruq, yaman set inek yette yilni körsitidu; sherq shamili bilen soliship qalghan yette quruq bashaqmu shundaq bolup, acharchiliq bolidighan yette yildur. ");
INSERT INTO uiglat_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Men Pirewn’ge deydighan sözüm shuki, Xuda yéqinda qilmaqchi bolghan ishni Pirewn’ge ayan qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mana, pütkül Misir zéminida yette yilghiche memurchiliq bolidu; ");
INSERT INTO uiglat_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","andin yette yilghiche acharchiliq bolidu; shuning bilen Misir zéminida pütkül memurchiliqni unutquzidighan acharchiliq zéminni weyran qilidu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kélidighan acharchiliqning sewebidin zéminda bolghan memurchiliq kishilerning ésidin kötürülüp kétidu; chünki acharchiliq tolimu éghir bolidu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Lékin chüshning yandurulup, Pirewn’ge ikki qétim körün’ginining ehmiyiti shuki, bu ish Xuda teripidin békitilgen bolup, Xuda uni pat arida emelge ashuridu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Emdi Pirewn özi üchün pem-parasetlik hem dana bir kishini tépip, Misir zéminigha qoysun. ");
INSERT INTO uiglat_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pirewn shundaq qilsunki, memurchiliq bolghan yette yilda Misir zéminidin chiqqan ashliqning beshtin birini toplanglar dep zémin’gha nazaretchilerni teyinlisun. ");
INSERT INTO uiglat_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Bular shu kélidighan toqchiliq yillirida barliq ashliqni toplap, sheher-sheherlerde yémeklik bolsun dep bughday-qonaqlarni Pirewnning qol astigha jem qilip saqlitip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yighilghan shu ashliqlar Misir zéminida bolidighan yette yilliq acharchiliqqa taqabil turush üchün saqlansun; shu teriqide zémin acharchiliqtin halak bolmaydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Bu söz Pirewn we uning xizmetkarlirining nezirige taza yaqti. ");
INSERT INTO uiglat_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Shuning bilen Pirewn xizmetkarlirigha: — Bu kishidek, ichide Xudaning rohi bar yene birsini tapalamduq?! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pirewn Yüsüpke: — Xuda sanga buning hemmisini ayan qilghaniken, sendek pemlik hem dana héchkim chiqmaydu. ");
INSERT INTO uiglat_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Sen emdi méning öyümni bashqurushqa békitilding, barliq xelqim séning aghzinggha qarap özlirini tertipke tizsun. Peqet texttila men sendin üstün turimen, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Axirida Pirewn Yüsüpke: — Mana, men séni pütkül Misir zéminining üstige teyinlidim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Buning bilen, Pirewn öz qolidin möhür üzükini chiqirip, Yüsüpning qoligha saldi; uninggha nepis kanap rexttin tikilgen libasni kiygüzüp, boynigha bir altun zenjir ésip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Uni özining ikkinchi shahane harwisigha olturghuzup, uning aldida: «Tiz pükünglar!» — dep jar saldurdi. Shundaq qilip, Pirewn uni pütkül Misir zéminigha tiklep qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Andin Pirewn Yüsüpke yene: — Men dégen Pirewndurmen; pütkül Misir zéminida sensiz héchkim qol-putini midirlatmisun! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Pirewn Yüsüpke Zafinat-Paaniyah dégen namni berdi we on shehiridiki kahin Potifirahning qizi Asinatni uninggha xotunluqqa élip berdi. Shundaq qilip Yüsüp pütkül Misir zéminini bashqurush üchün chörgileshke chiqti. Yüsüp Misir padishahi Pirewnning xizmitide bolushqa békitilgende ottuz yashta idi; u Pirewnning aldidin chiqip, Misir zéminining herqaysi jaylirini közdin kechürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Memurchiliq bolghan yette yil ichide zéminning hosuli döwe-döwe boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yette yilda u Misir zéminidin chiqqan ashliqni yighip, sheher-sheherge toplidi; herqaysi sheherning etrapidiki étizliqning ashliqini u shu sheherning özige jughlap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Shu teriqide Yüsüp déngizdiki qumdek nahayiti köp ashliq toplidi; ashliq heddi-hésabsiz bolghachqa, ular hésablashni toxtatti. ");
INSERT INTO uiglat_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Acharchiliq yilliri yétip kélishtin burun Yüsüpke ikki oghul töreldi. Bularni Ondiki kahin Potiferahning qizi Asinat uninggha tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yüsüp: «Xuda pütün japa-musheqqitim we atamning pütün ailisini könglümdin kötürüwetti» dep tunji oghligha Manasseh dep at qoydi; ");
INSERT INTO uiglat_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","andin: «Men azab-oqubet chekken yurtta Xuda méni méwilik qildi» dep ikkinchisige Efraim dep at qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Misir zéminida memurchiliq bolghan yette yil ayaghlashti. ");
INSERT INTO uiglat_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Andin Yüsüpning éytqinidek acharchiliqning yette yili bashlandi. U chaghlarda bashqa barliq yurtlardimu acharchiliq boldi; lékin Misir zéminidiki her yerlerde nan bar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Acharchiliq pütkül Misir zéminni basqanda, xelq ashliq sorap Pirewn’ge peryad qildi. Pirewn misirliqlarning hemmisige: — Yüsüpning qéshigha bérip, u silerge néme dése, shuni qilinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Acharchiliq pütkül yer yüzini bésip ketti. Yüsüp her yerdiki ambarlarni échip, misirliqlargha ashliq satatti; acharchiliq Misir zéminida intayin éghir bolghili turdi. ");
INSERT INTO uiglat_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Acharchiliq pütkül yer yüzini basqan bolghachqa, barliq yurtlardiki xelqmu ashliq alghili Misirgha Yüsüpning qéshigha kéletti. ");
INSERT INTO uiglat_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Emdi Yaqup Misirda ashliq barliqini bilginide oghullirigha: — Némishqa bir-biringlargha qariship turisiler? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Andin yene: — Manga qaranglar, anglishimche Misirda ashliq bar iken. U yerge bérip, andin shu yerdin bizge ashliq élip kélinglar; buning bilen ölüp ketmey, tirik qalimiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Buning bilen Yüsüpning on akisi ashliq sétiwalghili Misirgha yolgha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Lékin Yaqup Yüsüpning inisi Binyaminning birer yamanliqqa uchrap qélishidin qorqup uni akiliri bilen bille ewetmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Shuningdek acharchiliq Qanaan zéminidimu yüz bergechke, Israilning oghulliri ashliq alghili kelgenler arisida bar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yüsüp zéminning waliysi bolup, yurtning barliq xelqige ashliq sétip bergüchi shu idi. Yüsüpning akiliri kélip uning aldida yüzlirini yerge tegküzüp tezim qildi.    ");
INSERT INTO uiglat_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yüsüp akilirini körüpla ularni tonudi; lékin u tonushluq bermey, ulargha qopal teleppuzda gep qilip: — Qeyerdin keldinglar, dep soridi. Ular jawaben: — Qanaan zéminidin ashliq alghili kelduq, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yüsüp akilirini tonughan bolsimu, lékin ular uni tonumidi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yüsüp emdi ular toghrisida körgen chüshlirini ésige élip, ulargha: — Siler jasus, bu elning mudapiesiz jaylirini közetkili keldinglar, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Emma ular uninggha jawab bérip: — Ey xojam, undaq emes! Belki keminiliri ashliq sétiwalghili keldi! ");
INSERT INTO uiglat_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Biz hemmimiz bir ademning oghulliri, semimiy ademlermiz. Keminiliri jasus emes! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","U ulargha yene: — Undaq emes! Belki zéminning mudapiesiz jaylirini körgili keldinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ular jawab bérip: — Keminiliri eslide on ikki qérindash iduq; biz hemmimiz Qanaan zéminidiki bir ademning oghulliridurmiz; lékin kenji inimiz atimizning qéshida qélip qaldi; yene bir inimiz yoqap ketti, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Emma Yüsüp ulargha yene: — Mana men del silerge éytqinimdek, jasus ikensiler! ");
INSERT INTO uiglat_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Pirewnning hayati bilen qesem qilimenki, kichik ininglar bu yerge kelmigüche siler bu yerdin chiqip kételmeysiler; siler shuning bilen sinilisiler. ");
INSERT INTO uiglat_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ininglarni élip kelgili biringlarni ewetinglar, qalghanliringlar bolsa solap qoyulisiler. Buning bilen éytqininglarning rast-yalghanliqi ispatlinidu; bolmisa, Pirewnning hayati bilen qesem qilimenki, siler jezmen jasus! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Shuning bilen u ularni üch kün’giche solap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Üchinchi küni Yüsüp ulargha mundaq dédi: — Men Xudadin qorqidighan ademmen; tirik qélishinglar üchün mushu ishni qilinglar: — ");
INSERT INTO uiglat_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Eger semimiy ademler bolsanglar, qérindashliringlardin biri siler solan’ghan gundixanida solaqliq turiwersun, qalghininglar acharchiliqta qalghan ailenglar üchün ashliq élip kétinglar; ");
INSERT INTO uiglat_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Andin kichik ininglarni qéshimgha élip kélinglar. Shuning bilen sözliringlar ispatlansa, ölmeysiler!, — dédi. Ular shundaq qilidighan boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Andin ular özara: — Berheq, biz inimizgha qilghan ishimiz bilen gunahkar bolup qalduq; u bizge yalwursimu uning azabini körüp turup uninggha qulaq salmiduq. Shuning üchün bu azab-oqubet béshimizgha chüshti, — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben ulargha jawaben: — Men silerge: baligha zulum qilmanglar, dégen emesmidim? Lékin unimidinglar. Mana emdi uning qan qerzi bizdin soriliwatidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Emma Yüsüp ular bilen terjiman arqiliq sözleshkechke, ular Yüsüpning öz geplirini uqup turuwatqinini bilmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","U ulardin özini chetke élip, yighlap ketti. Andin ularning qéshigha yénip kélip, ulargha yene söz qilip, ularning arisidin Shiméonni tutup, ularning köz aldida baghlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Andin Yüsüp emr chüshürüp, ularning tagharlirigha ashliq toldurup, her birsining pulini qayturup taghirigha sélip qoyup, seper hazirliqlirimu bérilsun dep buyruwidi, ulargha shundaq qilindi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Shuning bilen akiliri ésheklirige ashliqlirini artip, shu yerdin ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Emma ötengge kelgende ulardin biri éshikige yem bergili taghirini échiwidi, mana, öz puli tagharning aghzida turatti. ");
INSERT INTO uiglat_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","U qérindashlirigha: — Méning pulumni qayturuwétiptu. Mana u taghirimda turidu, dédi. Buni anglap ularning yüriki su bolup, titriship bir-birige: — Bu Xudaning bizge zadi néme qilghinidu? — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ular Qanaan zéminigha, atisi Yaqupning qéshigha kélip, béshidin ötken hemme weqelerni uninggha sözlep bérip: ");
INSERT INTO uiglat_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— héliqi kishi, yeni shu zéminning xojisi bizge qopal gep qildi, bizge zéminni paylighuchi jasustek muamile qildi; ");
INSERT INTO uiglat_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","emdi biz uninggha: «Biz bolsaq semimiy ademlermiz, jasus emesmiz. ");
INSERT INTO uiglat_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Biz bir atidin bolghan oghullar bolup, on ikki aka-uka iduq; biri yoqap ketti, kichik inimiz hazir Qanaan zéminida atimizning yénida qaldi» dések, ");
INSERT INTO uiglat_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Héliqi kishi, yeni shu zéminning xojisi bizge mundaq dédi: «Méning silerning semimiy ikenlikinglarni bilishim üchün, qérindashliringlarning birini méning yénimda qaldurup qoyup, ach qalghan ailenglar üchün ashliq élip kétinglar; ");
INSERT INTO uiglat_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","andin kichik ininglarni qéshimgha élip kélinglar; shundaq qilsanglar, silerning jasus emes, belki semimiy ademler ikenlikinglarni bileleymen. Andin qérindishinglarni silerge qayturup bérimen we siler zéminda soda-sétiq qilsanglar bolidu» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Emma shundaq boldiki, ular tagharlirini tökkende, mana herbirining puldini öz tagharlirida turatti! Ular we atisi özlirining chigiklik pullirini körgende, qorqup qélishti. ");
INSERT INTO uiglat_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Atisi Yaqup ulargha: — Méni oghlumdin juda qildinglar! Yüsüp yoq boldi, Shiméonmu yoq, emdi Binyaminnimu élip ketmekchi boluwatisiler! Mana bu ishlarning hemmisi méning béshimghila keldi! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben atisigha: — Eger men Binyaminni qéshinggha qayturup élip kelmisem, méning ikki oghlumni öltürüwetkin; uni méning qolumgha tapshurghin; men uni qéshinggha yandurup élip kélimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Lékin Yaqup jawab bérip: — Oghlum siler bilen bille u yerge chüshmeydu; chünki uning akisi ölüp kétip, u özi yalghuz qaldi. Mubada yolda kétiwatqanda uninggha birer kélishmeslik kelse, siler mendek bir aq chachliq ademni derd-elem bilen tehtisaragha chüshürüwétisiler, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Acharchiliq zéminni intayin éghir basqanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Bu sewebtin ular Misirdin élip kelgen ashliqni yep tügetkende, atisi ulargha: — Yene bérip bizge azghina ashliq élip kélinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Lékin Yehuda uninggha jawaben: — Héliqi kishi bizni qattiq agahlandurup: «Ininglar siler bilen bille kelmise, yüzümni körimen dep xiyal qilmanglar» dégen. ");
INSERT INTO uiglat_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Eger inimizni biz bilen bille ewetseng, biz bérip sanga ashliq élip kélimiz. ");
INSERT INTO uiglat_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Emma ewetishke unimisang, biz barmaymiz; chünki héliqi kishi bizge: «Ininglar siler bilen bille kelmise, yüzümni körimen dep xiyal qilmanglar» dégen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israil ulargha: — Siler némishqa manga shunche yamanliq qilip u kishige: «Yene bir inimizmu bar» dédinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ular jawaben: — U kishi bizning we ailimizning ehwalini sürüshtürüp kochilap: «Atanglar téxi Hayatmu? Yene bir ininglar barmu?» — dep soridi. Biz uning shu soaligha yarisha jawab berduq. Uning bizge: «Ininglarni élip kélinglar» deydighinini nedin bileyli? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yehuda atisi Israilgha: — Balini men bilen ewetkin; biz derhal qozghilip yolgha chiqayli; shundaqta biz we sen, bizler hem balilirimiz ölmey, tirik qalimiz. ");
INSERT INTO uiglat_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Men uninggha képil bolimen; sen uning üchün méning méningdin hésab alisen; eger men uni séning qéshinggha aman-ésen yandurup kélip, yüzüngning aldida turghuzmisam, pütkül ömrümde aldingda gunahkar bolay.    ");
INSERT INTO uiglat_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Chünki hayal bolmighan bolsaq, bu chaghqiche ikki qétim bérip kélettuq, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ularning atisi Israil ulargha: — Undaq bolsa, mundaq qilinglar: — U kishige qacha-quchanglargha zémindiki eng ésil méwilerdin sowghat alghach béringlar: yene azghina tutiya, azraq hesel, dora-dermanlar, murmekki, piste we badamlarni alghach béringlar. ");
INSERT INTO uiglat_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Qolunglarda ikki hesse pul élip, tagharliringlarning aghzidiki özünglargha yandurulghan pulnimu alghach béringlar. Éhtimal, bu ishta sewenlik körülgen bolushi mumkin. ");
INSERT INTO uiglat_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ininglarnimu bille élip, qozghilip u kishining yénigha yene béringlar. ");
INSERT INTO uiglat_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Hemmige Qadir Tengri Özi silerni u kishining aldida rehimge érishtürgey. Buning bilen u silerning shu yerdiki qérindishinglarni we Binyaminni qoyup bérip, silerge qoshup qoyarmikin; özüm nawada balilirimdin juda bolsam bolay! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Shuning bilen bu ademler shu sowghatni élip, qollirigha ikki hesse pulni tutup, Binyaminni élip qozghilip, Misirgha bérip Yüsüpning aldida hazir boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yüsüp Binyaminni ular bilen bille körginide, öz öyini bashquridighan ghojidarigha buyrup: — Bu ademlerni öyümge bashlap kirip, mal soyup taam teyyar qilghin; chünki bu kishiler chüshlük ghizani men bilen yeydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","U kishi Yüsüpning buyrughinidek qilip, ademlerni Yüsüpning öyige bashlap kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ular bolsa Yüsüpning öyige bashlap kélin’ginidin qorqushup: — Aldinqi qétim tagharlirimizgha yandurulghan pulning sewebidin biz uning öyige élip kélinduq; uning meqsiti bizge hujum qilip, üstimizdin bésip qul qilip, ésheklirimizni tartiwélish oxshaydu, — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ular Yüsüpning öyini bashquridighan ghojidarning yénigha kélip, öyning ishikining tüwide uninggha: — ");
INSERT INTO uiglat_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ey xojam, biz heqiqeten eslide mushu yerge ashliq alghili kelgeniduq; ");
INSERT INTO uiglat_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Shundaq boldiki, biz ötengge kélip öz tagharlirimizni achsaq, mana herbirimizning puli, eyni éghirliqi boyiche tagharlirimizning aghzida turuptu; shunga biz buni yandurup qolimizda alghach kelduq. ");
INSERT INTO uiglat_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ashliq alghili qolimizda bashqa pulmu élip kelduq; emma tagharlirimizgha pulni kimning sélip qoyghanliqini bilmiduq, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","U ulargha: — Xatirjem bolunglar, qorqmanglar. Silerning Xudayinglar, atanglarning Xudasi tagharliringlarda silerge bayliq ata qilghan oxshaydu; silerning pulunglarni alliqachan tapshurup aldim, — dédi. Andin u Shiméonni ularning qéshigha élip chiqti. ");
INSERT INTO uiglat_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","U kishi ularni Yüsüpning öyige bashlap kirip, ularning putlirini yuyushigha su ekirip bérip, andin ésheklirige yem berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ular Yüsüpning chüshte kélishige ülgürtüp sowghatni teyyarlap qoydi; chünki ular özlirining shu yerde ghiza yeydighinini anglighanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yüsüp öyge kelgende ular qolliridiki sowghatni öyge uning aldigha élip kirip, béshini yerge tegküzüp uninggha tezim qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","U ulardin hal sorap, andin: — Siler gépini qilghan qéri atanglar salametmu? U hayatmu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ular jawab bérip: — Silining qulliri bizning atimiz salamet turuwatidu, u téxi hayattur, — dep uning aldida égilip tezim qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yüsüp béshini kötürüp, öz inisi Binyaminni körüp: — Siler manga gépini qilghan kichik ininglar shumu? — dep sorap: — Ey oghlum, Xuda sanga shapaet körsetkey! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yüsüpning öz inisigha bolghan séghinish oti qattiq küchiyip, yighliwalghudek xaliy jay izdep, aldirap ichkiriki öyge kirip taza bir yighliwaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Andin yüzini yuyup chiqip, özini bésiwélip: — Taamlarni qoyunglar, — dep buyrudi. ");
INSERT INTO uiglat_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Xizmetkarlar Yüsüpke ayrim, ulargha ayrim we Yüsüp bilen bille tamaqqa kelgen misirliqlarghimu ayrim tamaq qoydi; chünki misirliqlar ibraniylar bilen bir dastixanda tamaq yéyishni yirginchlik dep qarap, ular bilen bille tamaq yémeytti. ");
INSERT INTO uiglat_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yüsüpning qérindashliri uning udulida, herbiri chong-kichik tertipi boyiche olturghuzuldi; chongi chongluqigha yarisha, kichiki kichiklikige yarisha olturghuzuldi; ular bir-birige qarap heyran qélishti. ");
INSERT INTO uiglat_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yüsüp aldidiki dastixandiki tamaqlardin ulargha bölüp berdi. Emma Binyamin’gha bergini bashqilarningkige qarighanda besh hesse köp idi. Ular sharab ichip, uning bilen xush keyp qilishti. ");
INSERT INTO uiglat_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Andin u öz öyini bashquridighan ghojidarigha buyrup: — Bu kishilerning tagharlirini élip kötüreligüdek ashliq qachilap, herbirining pulini taghirining aghzigha sélip qoyghin; ");
INSERT INTO uiglat_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","andin méning jamimni, yeni kümüsh jamni ashliqning puli bilen bille eng kichikining taghirining aghzigha sélip qoyghin, — dédi. U adem Yüsüpning déginidek qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Etisi tang yorighanda, ular éshekliri bilen bille yolgha sélip qoyuldi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Lékin ular sheherdin chiqip anche uzun mangmayla, Yüsüp ghojidarigha: — Ornungdin tur, bu ademlerning keynidin qoghlighin; ulargha yétishkiningde ulargha: «Némishqa yaxshiliqqa yamanliq qayturdunglar? ");
INSERT INTO uiglat_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Xojam shu jamda sharab ichidu hemde uningda pal achidu emesmu?! Mundaq qilghininglar rezillik qilghininglar bolmamdu!» dégin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Bu adem ularning keynidin yétiship bérip, ulargha bu sözlerni qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ular uninggha jawaben: — Xojimiz némishqa mundaq gep qilidu? Mundaq ishni qilish keminiliridin néri bolsun! ");
INSERT INTO uiglat_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Biz eslide tagharlirimizning aghzidin tapqan pulnimu Qanaan zéminidin silining qashlirigha qayturup bérishke ekelgeniduq. Shundaq turuqluq qandaqmu xojilirining öyidin altun-kümüshni oghrilayli? ");
INSERT INTO uiglat_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Keminiliringning arisida kimdin bu jam tépilsa, shu ölümge mehkum bolsun, bizmu xojimizning qulliri bolayli, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ghojidar jawaben: — Éytqan sözliringlardek bolsun; jam kimning yénidin tépilsa, shu kishi qulum bolup qélip qalsun, qalghanliringlar bigunah bolisiler, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Shuning bilen ular aldirap-ténep, tagharlirini yerge chüshürüp, herbiri öz taghirini échip berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ghojidar chonginingkidin bashlap kichikiningkigiche axturdi, jam Binyaminning taghiridin tépildi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Buni körüp ular kiyimlirini yirtiship, herbiri éshikige qaytidin yükni artip, sheherge qaytti. ");
INSERT INTO uiglat_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Shundaq qilip Yehuda we qérindashliri Yüsüpning öyige keldi; u téxi shu yerde idi. Ular uning aldigha kélip özlirini yerge étishti. ");
INSERT INTO uiglat_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yüsüp ulargha: — Bu silerning zadi néme qilghininglar? Méningdek ademning choqum pal achalaydighanliqini bilmemtinglar? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yehuda jawaben: — Biz xojimizgha némimu déyeleymiz? Néme gep qilalaymiz, qandaq qilip özimizni aqliyalaymiz? Xuda keminlirining qebihlikini ashkara qildi. Mana, biz we qolidin jamliri tépilghan kishi hemmimiz xojimizgha qul bolidighan bolduq, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Lékin Yüsüp: — Mundaq qilish mendin néri bolsun! Belki jam kimning qolidin tépilghan bolsa peqet shu kishi méning qulum bolidu. Lékin qalghanliringlar aman-ésen atanglarning qéshigha kétinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Andin Yehuda uninggha yéqin bérip mundaq dédi: — Ey xojam, keminilirige qulaq sélip xojamning quliqigha bir éghiz gep qilishqa ijazet bergeyla. Ghezepliri keminilirige tutashmighay; chünki özliri Pirewn’ge oxshash ikenla. ");
INSERT INTO uiglat_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Eslide xojam keminiliridin: «Atanglar ya ininglar barmu?» dep soriwidila, ");
INSERT INTO uiglat_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","biz xojimizgha jawaben: «Bizning bir qéri atimiz bar we u qérighanda tapqan, yash bir balisimu bar. Bu balining bir anisidin bolghan akisi ölüp kétip, u özi yalghuz qaldi; uning atisi uni intayin söyidu» dések, ");
INSERT INTO uiglat_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Sili keminilirige: «Uning özini qéshimgha élip kélinglar, men uni öz közüm bilen körey» dédile. ");
INSERT INTO uiglat_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Biz xojimizgha jawab bérip: «Yigit atisidin ayrilalmaydu; eger atisidin ayrilsa, atisi ölüp kétidu» dések, ");
INSERT INTO uiglat_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Sili yenila keminilirige: «Eger kichik ininglar siler bilen bille kelmise, yüzümni yene körimiz dep xiyal qilmanglar» dégenidila. ");
INSERT INTO uiglat_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Shuning bilen biz keminiliri atimizning qéshigha barghanda xojamning sözlirini uninggha éyttuq; ");
INSERT INTO uiglat_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","andin atimiz yene: «Yene bérip, bizge azraq ashliq élip kélinglar» déwidi, ");
INSERT INTO uiglat_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Biz jawaben: «Biz shu yerge qaytidin chüshelmeymiz; eger kichik inimiz biz bilen bille bolsa, undaqta barimiz; chünki kichik inimiz biz bilen bille bolmisa, u zatning yüzi aldida turalmaymiz», déduq. ");
INSERT INTO uiglat_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Silining qulliri bizning atimiz bizge yene: «Silerge melumki, ayalim manga ikki oghul tughup bergenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Biri méning yénimdin chiqip, yoq bolup ketti; men: u jezmen titma-titma qiliwétiliptu, dep oylidim, shundaqla uni bügün’giche körmidim. ");
INSERT INTO uiglat_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Emdi siler bunimu méning qéshimdin élip kétip, uninggha bir kélishmeslik kélip qalsa, siler mendek bir aq chachliq ademni derd-elem bilen tehtisaragha chüshürüwétisiler», dégenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Emdi men silining qulliri méning atamning qéshigha barghanda, shu bala biz bilen bolmisa uning jéni balining jénigha baghlan’ghan bolghachqa, ");
INSERT INTO uiglat_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","shundaq boliduki, u balining yoqluqini körse, jezmen ölüp kétidu; shuning bilen silining qulliri bizning atimiz bolghan bu aq chachni derd-elem ichide tehtisaragha chüshürüwetken bolimiz. ");
INSERT INTO uiglat_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Chünki menki keminiliri atamgha bu yigit üchün képil bolup: «Eger men uni qéshinggha qayturup kelmisem pütkül ömrümde atamning aldida gunahkar bolay» dégenidim. ");
INSERT INTO uiglat_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Shunga hazir ötünüp qalay, menki keminiliri u yigitning ornida xojamning qéshida qul bolup tursam, u yigit qérindashliri bilen bille qaytip ketse! ");
INSERT INTO uiglat_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Chünki yigit men bilen bolmisa, men qandaqmu atamning qéshigha baralaymen? Atamgha shundaq azab-oqubetning chüshüshini közüm körgüchi bolmisun! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","2","Yüsüp öz yénida turghanlarning aldida özini tutalmay: — Hemme adem aldimdin chiqiriwétilsun! dep warqiridi. Shuning bilen Yüsüp özini qérindashlirigha ashkara qilghanda uning qéshida héchkim bolmidi. U qattiq yighlap ketti; misirliqlar uni anglidi, Pirewnning ordisikilermu buningdin tézla xewer tapti. ");
INSERT INTO uiglat_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yüsüp qérindashlirigha: — Men Yüsüp bolimen! Atam hazir hayatmu?! — dep soridi. Emma qérindashliri uninggha qarap hoduqup kétip, héch jawab bérelmey qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Lékin Yüsüp ularni: — Qéni, manga yéqin kélinglar, dep chaqiridi. Ular yéqin keldi, u yene: — Men silerning ininglar, yeni siler Misirgha sétiwetken Yüsüp bolimen. ");
INSERT INTO uiglat_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Emdi méni mushu yerge sétiwetkininglar üchün azablanmanglar, özünglarni eyibke buyrumanglar; chünki Xuda ademlerning hayatini saqlap qélish üchün méni silerdin burun bu yerge ewetti. ");
INSERT INTO uiglat_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Chünki hazir zémindiki acharchiliqqa ikki yil boldi; lékin téxi yene besh yilghiche héch térilghumu bolmaydu, ormimu bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Shuning üchün silerge dunyada bir qaldini saqlap qélish üchün, ulugh bir nijatliq körsitip, silerning tirik qutulushunglar üchün Xuda méni silerdin burun bu yerge ewetti. ");
INSERT INTO uiglat_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Shundaq bolghaniken, méni mushu yerge ewetküchi siler emes, belki Xudadur. U méni Pirewn’ge atining ornida qilip, uning pütkül öyige xoja qilip tiklep, pütkül zémin’gha bash wezir qilip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Emdi tézdin atamning qéshigha bérip, uninggha: — Séning oghlung Yüsüp: «Xuda méni pütkül Misirgha xoja qilip qoydi. Sen hayal qilmay, méning qéshimgha kelgin; ");
INSERT INTO uiglat_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","sen Goshen yurtida turisen; shuning bilen sen özüng, oghulliring, newriliring, qoyliring, kaliliring we hemme teelluqatliring bilen manga yéqin turisiler. ");
INSERT INTO uiglat_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Özüng, aileng we hemme teelluqatingni namratliq bésiwalmisun dep men séni shu yerde baqimen; chünki yene besh yil acharchiliq bardur», dédi, — denglar. ");
INSERT INTO uiglat_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","— Mana silerning közliringlar we inim Binyaminning közliri silerge gep qiliwatqan méning öz aghzim ikenlikini körüwatidu. ");
INSERT INTO uiglat_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Atamgha méning Misirdiki bu barliq shan-sheripim hemde silerning barliq körgininglar toghrisida éytip, atamni tézdin bu yerge élip kélinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Shuning bilen u özini Binyamin’gha étip uning boynigha gire sélip yighlap ketti; Binyaminmu uning boynigha yölinip yighlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Andin Yüsüp barliq qérindshalirini söyüp, ularni bir-birlep quchaqlap yighlidi. Andin qérindshaliri uning bilen paranglashti. ");
INSERT INTO uiglat_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yüsüpning qérindshaliri keldi, dégen xewer Pirewnning ordisigha yetküzüldi; bu Pirewn we xizmetkarlirining neziride qutluq ish boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pirewn Yüsüpke: — Qérindashliringgha: — «Siler emdi mundaq qilinglar; ulaghliringlargha yük artip, Qanaan zéminigha bérip, ");
INSERT INTO uiglat_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","atanglar we jemetinglarni élip méning qéshimgha kélinglar; men Misir zéminidin eng ésil yerlerni silerge bérey; siler bu zémindin chiqqan nazu-németlerdin yeysiler» — dégin. ");
INSERT INTO uiglat_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Sanga bolghan emrim shuki, sen ulargha: «Baliliringlar we ayalliringlarni élish üchün Misir zéminidin harwilarni élip béringlar. Shuningdek atanglarnimu bu yerge yetküzüp kélinglar. ");
INSERT INTO uiglat_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Pütkül Misir zéminidin eng ésil jaylar silerningki bolghachqa, öz seremjanliringlargha karinglar bolmisun» dep buyrughin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Shuning bilen Israilning oghulliri shundaq qildi; Yüsüp Pirewnning buyruqi boyiche ulargha harwilarni bérip, yoli üchünmu ozuq berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ularning herbirige bir qur kiyim berdi; lékin Binyamin’gha bolsa u üch yüz kümüsh tengge, besh qur kiyim berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","U atisighimu shu hediyelerni, yeni Misirning ésil mehsulatliri artilghan on hangga éshek hemde ashliq, nan we atisigha yol teyyarliqi artilghan on mada éshekni ewetti. ");
INSERT INTO uiglat_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Andin u qérindashlirini yolgha sélip, ulargha: — Yolda jédelleshmenglar, dep jékilidi. Ular yolgha rawan boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ular Misirdin chiqip, Qanaan zéminigha atisi Yaqupning qéshigha bérip, ");
INSERT INTO uiglat_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","uninggha Yüsüp özlirige éytqan geplerni yetküzüp: «Yüsüp téxi hayat iken! U pütkül Misir zéminigha bash wezir iken!» dédi. Emma u ulargha ishenmey, yüriki qétip hoshidin kétey dep qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Lékin ular Yüsüpning özlirige éytqan barliq sözlirini uninggha dégende, shundaqla Yüsüpning özini élip kélishke ewetken harwilarnimu körgende, ularning atisi Yaqupning rohigha jan kirdi. ");
INSERT INTO uiglat_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israil shuning bilen: — Emdi arminim yoq! Oghlum Yüsüp téxi hayattur! Men ölmeste bérip uni körüwalay, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Shuning bilen Israil barliq teelluqatini élip yolgha chiqip, Beer-Shébagha keldi. U shu yerde atisi Ishaqning Xudasigha qurbanliqlarni sundi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kéchisi Xuda alamet körünüshlerde Israilgha: — Yaqup, Yaqup! déwidi, u jawab bérip: — Mana men! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","U: — Atangning Tengrisi bolghan Xuda Mendurmen. Sen Misirgha bérishtin qorqmighin, chünki Men séni shu yerde ulugh bir qowm qilimen. ");
INSERT INTO uiglat_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Men séning bilen Misirgha bille barimen we Men Özüm jezmen yene séni shu yerdin yandurup kélimen. Yüsüp öz qoli bilen séning közüngni yumduridu, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Andin Yaqup Beer-Shébadin yolgha chiqti; Israilning oghulliri atisi Yaqup we ularning bala-chaqilirini Pirewn uni épkélish üchün ewetken harwilargha olturghuzup, ");
INSERT INTO uiglat_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","charpayliri bilen Qanaan zéminida tapqan teelluqatlirini élip mangdi. Bu teriqide Yaqup bilen barliq ewladliri Misirgha keldi; oghullirini, oghul newrilirini, qizlirini, qiz newrilirini yighip, nesillirining hemmisini özi bilen bille élip Misirgha keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israilning oghulliri, yeni Yaqupning Misirgha kelgen ewladliri töwendikiche: — Yaqupning tunji oghli Ruben; ");
INSERT INTO uiglat_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubenning oghulliri Hanox, Pallu, Hezron bilen Karmi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Shiméonning oghulliri: — Yemuel, Yamin, Ohad, Yaqin, Zohar we Qanaaniy ayaldin bolghan Saul.    ");
INSERT INTO uiglat_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lawiyning oghulliri: — Gershon, Kohat we Merari. ");
INSERT INTO uiglat_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yehudaning oghulliri: — Er, Onan, Shelah, Perez we Zerah. Emma Er we Onan Qanaanning zéminida ölüp ketkenidi. Perezning oghulliri Hezron bilen Hamullar idi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issakarning oghulliri: — Tola, Puah, Yob we Shimron. ");
INSERT INTO uiglat_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulunning oghulliri: — Sered, Élon we Jahliyel. ");
INSERT INTO uiglat_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Bular Léyahning Yaqupqa Padan-Aramda tughup bergen oghul-ewladliri idi; u yene qizi Dinahni tughup berdi. Buning bu oghul-qiz perzentliri jemiy bolup ottuz üch jan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadning oghulliri: — Zifion, Haggi, Shuni, Ezbon, Éri, Arodi we Areli. ");
INSERT INTO uiglat_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ashirning oghulliri: — Yimnah, Yishwah, Yishwi we Bériyah. Ularning singlisi Sérah idi; Bériyahning oghulliri Heber we Malkiel idi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bular bolsa Laban qizi Léyahqa dédek bolushqa bergen Zilpahning Yaqupqa tughup bergen oghulliri bolup, jemiy on alte jan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaqupning ayali Rahilening oghulliri Yüsüp we Binyamin. ");
INSERT INTO uiglat_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yüsüpke Misir zéminida törelgen oghulliri Manasseh we Efraim; bularni Ondiki kahin Potifirahning qizi Asinat uninggha tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Binyaminning oghulliri: — Bélah, Beker, Ashbel, Géra, Naaman, Éhi, Rosh, Muppim, Huppim we Ard.    ");
INSERT INTO uiglat_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bular Rahilening Yaqupqa tughup bergen oghul-ewladliri bolup, jemiy on töt jan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danning oghli: — Hushim. ");
INSERT INTO uiglat_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftalining oghulliri: — Yahziel, Guni, Yezer we Shillem. ");
INSERT INTO uiglat_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bular Laban qizi Rahilege dédek bolushqa bergen Bilhahning Yaqupqa tughup bergen oghul-ewladliri bolup, jemiy yette jan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaqupning kélinliridin bashqa, Yaqupning pushtidin bolghan, uning bilen birge Misirgha kelgenler jemiy atmish alte jan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yüsüpning Misirda tughulghan oghulliri ikki idi. Yaqupning jemetidin bolup, Misirgha kelgenler jemiy yetmish jan idi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yaqup Yüsüptin körsetme élip, özlirini Goshen’ge bashlap bérishqa Yehudani Yüsüpning qéshigha ewetti. Shundaq qilip ular Goshen yurtigha kélip chüshti. ");
INSERT INTO uiglat_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yüsüp özining wezirlik harwisini qatquzup, atisi Israilning aldigha Goshen’ge chiqti. U özini uning aldigha hazir qilip atisigha özini étip boynigha gire sélip quchaqlap, uzundin uzun yighlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israil Yüsüpke: Men séning yüzüngni körüp, tirik ikenlikingni bildim; emdi ölsemmu arminim yoq, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Andin Yüsüp qérindashliri we atisining öydikilirige mundaq dédi: — Men hazir chiqip Pirewn’ge xewer bérip: «Qanaan zéminida olturghan qérindashlirim, shundaqla atamning öyidikiler qéshimgha keldi; ");
INSERT INTO uiglat_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","bu ademler padichilar bolup, mal béqish bilen shughullinip kelgen, qoy-kaliliri, shundaqla barliq mal-mülüklirini élip keldi» dep éytay. ");
INSERT INTO uiglat_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Shundaq boliduki, Pirewn silerni chaqiridu; shu chaghda u silerdin: «Néme oqitinglar bar?» dep sorisa, ");
INSERT INTO uiglat_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","siler jawab bérip: — Keminiliri kichikimizdin tartip ata-bowilirimizgha oxshash pada béqip kelgenmiz, — denglar. Shundaq désenglar Goshen yurtida olturup qalisiler; chünki padichilarning hemmisi misirliqlar arisida közge ilinmaydu.    ");
INSERT INTO uiglat_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yüsüp Pirewnning qéshigha kélip: — Atam bilen qérindashlirim qoy-kaliliri, shundaqla hemme mal-mülüklirini bille élip Qanaan zéminidin keldi. Mana, ular hazir Goshen yurtigha chüshti, dep xewer bérip, ");
INSERT INTO uiglat_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","qérindashlirining ichidin besheylenni élip, Pirewnning aldigha hazir qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pirewn uning qérindashliridin: — Néme oqitinglar bar, dep soriwidi, ular Pirewn’ge jawab bérip: — Keminiliri ata-bowilirimizgha oxshash mal baqquchilarmiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Andin ular Pirewn’ge iltimas qilip: — Qanaan zéminida qattiq qehetchilik bolghachqa, keminilirining qoylirimizni baqidighan’gha yaylaqmu yoq; shunga bu zéminda musapir bolup turushqa kelduq; janabliridin telep qilimizki, keminilirining Goshen yurtida turushigha ijazet bergeyla, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pirewn Yüsüpke: — Atang we qérindashliring qéshinggha keldi; ");
INSERT INTO uiglat_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","mana Misir zémini séning aldingda turuptu; atang we qérindashliringni zéminning eng ésil yéride olturghuzghin; ular Goshen yurtida makan qilsun. Shuningdek, eger sen ularning ichidiki qabil kishilerni bilseng, bularni méning charpaylirimgha nazaretchi qilghin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kéyin, Yüsüp atisi Yaqupni élip, Pirewnning aldigha hazir qildi; Yaqup Pirewn’ge bext-beriket tilidi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Andin Pirewn Yaquptin: — Ömrüngning yil-künliri nechchige yetti? — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaqup Pirewn’ge jawab bérip: — Musapirliq sepirimning künliri bir yüz ottuz yilgha yetti; ömrümning künliri az hem japa-musheqqetlik bolup, ata-bowilirimning musapirliq ömür sepirining künlirige téxi yetmidi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Shuning bilen Yaqup Pirewn’ge bext-beriket tilep, aldidin chiqip ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Shuning bilen Yüsüp atisi bilen qérindashlirini Misir zéminida olturaqlashturup qoydi; Pirewnning buyrughinidek ulargha zéminning eng ésil yéridin, yeni Ramses dégen yurttin tewelik berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yüsüp atisi, qérindashliri, shundaqla atisining hemme öydikilirini bala-chaqilirining sanlirigha qarap ashliq bilen teminlep baqti. ");
INSERT INTO uiglat_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Emma acharchiliq qattiq éghir bolghachqa, zéminning héch yéride ozuq-tülük tépilmidi; Misir zémini bilen Qanaan zémini acharchiliqtin xarapliship ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yüsüp ashliq sétip Misir zémini bilen Qanaan zéminidiki barliq pulni yighiwaldi. Andin Yüsüp bu pulni Pirewnning ordisigha yetküzüp berdi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Emma Misir zémini bilen Qanaan zéminidiki Pul tügep ketkende misirliqlarning hemmisi Yüsüpning aldigha kélip: — Bizge nan bergeyla! Pul tügep ketkini üchün silining aldilirida ölimizmu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yüsüp jawaben: — Pulunglar qalmighan bolsa, charpayliringlarni élip kélip bersenglar, men malliringlarigha ozuq-tülük tégiship bérimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Buning bilen ular charpaylirini Yüsüpning qéshigha élip kelgili turdi; Yüsüp ularning atliri, qoy padiliri, kala padiliri we ésheklirining ornigha ozuq-tülük berdi; shu yili mallirining ornigha ulargha ozuq-tülük bérip baqti. ");
INSERT INTO uiglat_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","U yil ayaghliship, ular ikkinchi yili uning qéshigha kélip uninggha: — Biz xojimizdin héchnémini yoshurmaymiz; pulimiz tügidi, charpay mal padilirimiz bolsa xojimizning ilkide, xojimizning aldida tenlirimiz bilen yérimizdin bashqa héchnerse qalmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Némishqa köz aldilirida biz hem yérimizmu ölüp ketsun? Emdi sili özimiz we yérimizni ozuq-tülükke tégiship éliwalghayla; özimiz we yérimiz Pirewnning bolup, uninggha qul bolayli. Biz ölüp ketmey, tirik turushimiz, yérimizmu weyran bolmasliqi üchün bizge uruq-tülük bergeyla, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Bu teriqide Yüsüp Misirning pütkül térilghu yérini Pirewn üchün sétiwaldi; chünki acharchiliq qattiq bolghachqa, misirliqlarning herbiri öz étizini sétip berdi. Shuning bilen yer-zémin Pirewnning bolup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yüsüp xelqni Misirning bu chétidin yene bir chétigiche herqaysi sheherlerge köchürdi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Peqet kahinlarning yérini u almidi; chünki kahinlargha Pirewn teripidin alahide teminat bérilgechke, ular Pirewn teripidin teminlen’gen ülüshini yep, öz yerlirini satmighanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yüsüp xelqqe: — Mana, men bügün özünglar bilen yerliringlarni Pirewn üchün sétiwaldim. Mana silerge uruq! Emdi yer téringlar. ");
INSERT INTO uiglat_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Emdi shundaq qilisilerki, chiqqan hosuldin beshtin birini Pirewn’ge bérip, qalghan töt qismini özünglargha élip qélinglar; u uruqluq hemde özünglargha, jümlidin öyüngdikilerge we kichik baliliringlargha ozuq bolsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ular jawaben: — Sili jénimizni qutquzdila. Xojimizning neziride iltipat tapqan bolsaqla, Pirewnning qulliri bolup turayli, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Shuning bilen Yüsüp: — «Hosulning beshtin biri Pirewn’ge bérilsun» dep bu ishni bügün’ge qeder Misir zémini üchün qanun-belgilime qildi. Peqet kahinlarning yérila buning sirtida bolup, Pirewn’ge tewe bolmidi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israillar Misir zéminida, Goshen ölkiside olturaqlashti; ular shu jayda yer-zéminlik bolup, awup, tolimu köpeydi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaqup Misir zéminida on yette yil ömür kördi; buning bilen Yaqupning ömür künliri bir yüz qiriq yette yilgha yetti. ");
INSERT INTO uiglat_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israilning künliri sekratqa yéqinlashqanda, oghli Yüsüpni chaqirtip, uninggha: — Eger neziringde iltipat tapqan bolsam, qolungni yotamning astigha qoyup, manga shapaet we sadaqetlikni körsitip, méni Misirda depne qilma; ");
INSERT INTO uiglat_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","belki men ata-bowilirim bilen yatidighan waqtimda méni Misirdin élip kétip, ularning göristanigha depne qilghin, dédi. U jawab bérip: — Men éytqiningdek qilay, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yaqup uninggha: — Manga qesem qilip bergin, — dédi. U uninggha qesem qilip berdi; andin Israil karwatning bash teripide sejde qildi.    ");
INSERT INTO uiglat_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bu ishlardin kéyin birsi Yüsüpke: — Mana atang késel bolup qaptu, dep xewer berdi. U ikki oghli Manasseh bilen Efraimni bille élip bardi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Birsi Yaqupqa: — Mana oghlung Yüsüp qéshinggha kéliwatidu, dep xewer bériwidi, Israil küchep qopup kariwatta olturdi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaqup Yüsüpke: — Hemmige Qadir Tengri manga Qanaan zéminidiki Luz dégen jayda ayan bolup, méni beriketlep ");
INSERT INTO uiglat_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","manga: Mana, Men séning neslingni köpeytip, séni intayin zor awutimen, sendin bir türküm xelq chiqirimen; bu zéminni sendin kéyinki neslingge ebediy miras qilip bérimen, dep éytqanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Emdi men Misirgha kélishtin ilgiri sanga Misir zéminida tughulghan ikki oghlung méning hésablinidu; Efraim bilen Manasseh bolsa, xuddi Ruben bilen Shiméon’gha oxshash, her ikkisi méning oghullirim bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ulardin kéyin tapqan baliliring özüngning bolidu; ular kelgüside mirasqa érishkende akilirining nami astida bolidu. ");
INSERT INTO uiglat_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Manga kelsek, Padandin kéliwatqinimda Rahile Qanaan zéminida yol üstide Efratqa az qalghanda méni tashlap ölüp ketti. Men uni shu yerde, yeni Efratqa (yeni Beyt-Lehemge) baridighan yolda depne qildim, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Andin Israil Yüsüpning oghullirigha qarap: — Bular kimdur, — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yüsüp atisigha jawaben: — Bular bolsa Xuda manga bu yerde bergen oghullirimdur, — dédi. U: — Ularni aldimgha yéqin keltürgin, men ulargha bext-beriket tiley, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Emdi Israilning közliri qériliqidin ghuwaliship yaxshi körelmeytti. Shunga Yüsüp ularni uning aldigha yéqinraq keltürdi; u ularni söyüp quchaqlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Andin Israil Yüsüpke: — Men séning yüzüngni köreleymen dep héch oylimighanidim; lékin Xuda méni séning baliliringnimu körüshke nésip qildi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yüsüp balilarni Yaqupning tizlirining ariliqidin élip, yüzini yerge tegküzüp tezim qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Andin Yüsüp bu ikkiylenni Israilning aldigha yéqin élip kélip, Efraimni ong qoli bilen tutup Israilning sol qoligha udullap turghuzdi; Manassehni sol qoli bilen tutup Israilning ong qoligha udullap turghuzdi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Lékin Israil ong qolini uzitip, kenji balisi Efraimning béshigha qoydi, sol qolini Manassehning béshigha qoydi. Manasseh tunjisi bolsimu, u ikki qolini qaychilap tutup shundaq qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","U Yüsüpke bext-beriket tilep: — Atilirim Ibrahim bilen Ishaq Xuda dep bilip yüzi aldida mangghan, méni pütkül ömrümde bu kün’giche padichidek yéteklep béqip kelgen Xuda, ");
INSERT INTO uiglat_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Manga hemjemet bolup méni hemme bala-qazadin qutquzghan Perishte bu ikki oghulni beriketlisun; ular méning ismim we atilirim bolghan Ibrahim we Ishaqning isimliri bilen atilip, yer yüzide köp awughay! — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yüsüp atisining ong qolini Efraimning béshigha qoyghinini körüp könglide xapa boldi; shunga u atisining qolini tutup, Efraimning béshidin élip Manassehning béshigha yötkimekchi bolup, ");
INSERT INTO uiglat_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","atisigha: — Ey ata, bundaq qilmighin; chünki mana, tunjisi budur; ong qolungni uning béshigha qoyghin! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Lékin atisi ret qilip: — Bilimen, i oghlum, bilimen; uningdinmu bir qowm chiqip, özimu ulugh bolidu, emma derheqiqet uning inisi uningdin téximu ulugh bolidu; uning neslidin nahayiti köp qowmlar peyda bolidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Shuning bilen shu küni u bu ikkisini beriketlep: — Kelgüside Israillar bext-beriket tiligende: «Xuda séni Efraim bilen Manassehdek ulugh qilsun!» deydighan bolidu, dédi. Bu teriqide u Efraimni Manassehtin üstün qoydi. ");
INSERT INTO uiglat_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Andin Israil Yüsüpke yene: — Mana, men ölimen; lékin Xuda siler bilen bille bolup, silerni ata-bowiliringlarning zéminigha qayturup baridu. ");
INSERT INTO uiglat_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Men sanga qérindashliringningkidin bir ülüsh yerni artuq berdim; shu yerni özüm qilich we oqyayim bilen Amoriyning qolidin tartiwalghanidim.    ");
INSERT INTO uiglat_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Andin Yaqup oghullirini chaqirip ulargha mundaq dédi: — Hemminglar jem bolunglar, men silerge kéyinki künlerde siler yoluqidighan ishlarni éytip bérey: — ");
INSERT INTO uiglat_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yighilip kélip anglanglar, i Yaqupning oghulliri; Atanglar Israilgha qulaq sélinglar. ");
INSERT INTO uiglat_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ey Ruben, sen méning tunji oghlumsen, Küch-qudritimsen, Küchüm bar waqtimning tunji méwisidursen, Salapet we qudrette aldi iding, ");
INSERT INTO uiglat_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Lékin qaynap téship chüshken sudek, Emdi aldi bolalmassen; Chünki sen atangning körpisige chiqting, Shuning bilen sen uni bulghiding! U méning körpemning üstige chiqti!    ");
INSERT INTO uiglat_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Shiméon bilen Lawiy qérindashlardur; Ularning qilichliri zorawanliqning qoralliridur! ");
INSERT INTO uiglat_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ah jénim, ularning meslihitige kirmigin! I izzitim, ularning jamaiti bilen chétilip qalmighay! Chünki ular achchiqida ademlerni öltürüp, Öz béshimchiliq qilip buqilarning péyini kesti. ");
INSERT INTO uiglat_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ularning achchiqi esheddiy bolghachqa lenetke qalsun! Ghezipimu rehimsiz bolghachqa lenetke qalsun! Men ularni Yaqupning ichide tarqitiwétimen, Israilning ichide ularni chéchiwétimen.    ");
INSERT INTO uiglat_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ey Yehuda! Séni bolsa qérindashliring teripler, Qolung düshmenliringning gejgisini basar. Atangning oghulliri sanga bash urar, ");
INSERT INTO uiglat_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yehuda yash bir shirdur; Ey oghlum, sen owni tutupla chiqting; U shirdek owning yénida chöküp sozulup yatsa, Yaki chishi shirdek yétiwalsa, Kimmu uni qozghashqa pétinar?    ");
INSERT INTO uiglat_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Shahane hasa Yehudadin kétip qalmaydu, Yehudaning pushtidin qanun chiqarghuchi öksümeydu, Taki shu hoquq Igisi kelgüche kütidu; Kelgende, jahan xelqliri uninggha itaet qilidu.    ");
INSERT INTO uiglat_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","U texiyini üzüm téligha, Éshek balisini sortluq üzüm téligha baghlap qoyar. U libasini sharabta yuyup, Tonini üzüm sherbitide yuyar. ");
INSERT INTO uiglat_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Uning közliri sharabtin qizirip kéter, Chishliri süt ichkinidin ap’aq turar. ");
INSERT INTO uiglat_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun déngiz boyini makan qilar, Makani kémilerning panahgahi bolar, Yer-zémini Zidon’ghiche yétip barar. ");
INSERT INTO uiglat_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar bestlik berdem bir éshektur, U ikki qotan arisida yatqandur; ");
INSERT INTO uiglat_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","U aramgahning yaxshi ikenlikige qarap, Zéminning ésilliqini körüp, Yük kötürüshke mürisini égip, Alwan’gha ishleydighan qul bolup qalar. ");
INSERT INTO uiglat_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan Israil qebililiridin biri bolar, Öz xelqige höküm chiqirar. ");
INSERT INTO uiglat_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan yol üstidiki yilan, Chighir yol üstide turghan zeherlik bir yilandur. U atning tuyiqini chéqip, At min’güchini arqigha mollaq atquzar. ");
INSERT INTO uiglat_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I Perwerdigar, nijatinggha telmürüp kütüp keldim! ");
INSERT INTO uiglat_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadqa bolsa, qaraqchilar qoshuni hujum qilar; Lékin u tapinini bésip zerbe bérer. ");
INSERT INTO uiglat_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ashirning tamiqida zeytun méyi mol bolar, U shahlar üchün nazu-németlerni teminler. ");
INSERT INTO uiglat_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftalidin chirayliq gepler chiqar, U erkin qoyuwétilgen maraldur. ");
INSERT INTO uiglat_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yüsüp méwilik derexning shéxidur, Bulaqning yénidiki köp méwilik shaxtektur; Uning shaxchiliri tamdin halqip ketkendur.    ");
INSERT INTO uiglat_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ya atquchilar uninggha azar qilip, Uninggha oq atti, uninggha nepretlendi. ");
INSERT INTO uiglat_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Halbuki, uning oqyayi mezmut turar, Qol-bilekliri eplik turghuzular, Shu küch Yaquptiki qudret Igisining qolliridindur — (Israilning Qoram Téshi, yeni uning Padichisi Uningdin chiqar!) ");
INSERT INTO uiglat_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ashu küch atangning Tengrisidindur — (U sanga medet bérer!) Yeni Hemmige Qadirdindur — U séni beriketler! Yuqirida asmanning beriketliri bilen, Töwende yatqan chongqur sularning beriketliri bilen, Emchek bilen baliyatquning berikiti bilen séni beriketler! ");
INSERT INTO uiglat_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Séning atangning tiligen beriketliri ata-bowilirimning tiligen beriketliridin ziyade boldi, Ular menggülük tagh-édirlarning chetlirigiche yéter, Ular Yüsüpning béshigha chüsher, Yeni öz qérindashliridin ayrim turghuchining choqqisigha téger.    ");
INSERT INTO uiglat_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Binyamin yirtquch böridektur; Etigende u owni yer. Kechqurun u oljisini teqsim qilar» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Bularning hemmisi Israilning on ikki qebilisi bolup, mezkur sözler bolsa atisining ulargha tiligen bext-beriket sözliridur. U shuning bilen ularning herbirige mas kélidighan bir beriket bilen ulargha bext-beriket tilidi. ");
INSERT INTO uiglat_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Andin Yaqup ulargha mundaq tapilidi: — «Men emdi öz qowmimning qéshigha qoshulimen. Siler méni ata-bowilirimning yénida, hittiylardin bolghan Efronning étizliqidiki ghargha depne qilinglar; ");
INSERT INTO uiglat_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","u ghar bolsa Qanaan zéminida Mamrening udulida, Makpélahning étizliqida. Gharni Ibrahim göristan bolsun dep shu étizliq bilen qoshup hittiy Efrondin sétiwalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Shu yerde Ibrahim ayali Sarah bilen depne qilin’ghan; shu yerde Ishaq ayali Riwkah bilenmu depne qilin’ghan; shu yerde menmu Léyahni depne qildim. ");
INSERT INTO uiglat_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Bu étizliq hem ichidiki ghar Hetning ewladliridin sétiwélin’ghanidi». ");
INSERT INTO uiglat_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaqup oghullirigha bu wesiyetni tapilap bolup, putlirini kariwatta tüzlep, nepes toxtap öz qowmigha qoshuldi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yüsüp atisining yüzige özini étip, uning üstide yighlap, uni söydi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Andin Yüsüp öz xizmitide bolghan téwiplargha atisini mumiya qilishni buyrudi; shuning bilen téwiplar Israilni mumiya qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Buni qilishqa qiriq kün ketti, chünki mumiya qilishqa shunchilik kün kétetti. Misirliqlar uninggha yetmish kün matem tutti. ");
INSERT INTO uiglat_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Uninggha haza tutush künliri ötüp bolghanda, Yüsüp Pirewnning ordisidikilerge: — Men neziringlarda iltipat tapqan bolsam, Pirewnning qulaqlirigha söz qilinglarki: — Atam manga qesem qildurup: «Mana men ölimen; sen méni men Qanaan zéminida özüm üchün kolap qoyghan görge depne qilghin» dégenidi. Emdi Pirewn manga ijazet bergey, men bérip atamni depne qilip bolup yénip kelsem, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pirewn jawaben: — Sen bérip özüngge atang qesem qildurghandek uni depne qilghin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Shuning bilen Yüsüp atisini depne qilghili mangdi. Pirewnning barliq xizmetkarliri, ordining aqsaqalliri hem Misir zéminidiki aqsaqallar uning bilen hemrah bolup mangdi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yüsüpning öyidiki hemmisi, qérindashliri we atisining öyidikilermu bille bardi; ular peqet kichik baliliri, qoy-kala padilirini Goshen yurtida qoyup ketti. ");
INSERT INTO uiglat_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Uning bilen yene jeng harwiliri we atliqlarmu bille bardi; shuning bilen ular nahayiti chong bir qoshun boldi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ular Iordan deryasining u teripidiki «Atadning xamini»gha yétip kelgende, shu yerde qattiq we hesretlik yigha-zar qilip matem tutup yighlashti. Yüsüp atisi üchün yette kün matem tutti. ");
INSERT INTO uiglat_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Shu yurtta olturushluq Qanaaniylar Atadning xaminida bolghan bu matemni körüp: — Bu misirliqlarning intayin qattiq tutqan hazisi boldi, déyishti. Bu sewebtin u jayning nami «Abel-Mizraim» dep ataldi; u Iordan deryasining u teripididur. ");
INSERT INTO uiglat_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaqupning oghulliri uning özlirige tapilighinidek qildi; ");
INSERT INTO uiglat_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","uning oghulliri uni Qanaan zéminigha élip bérip, Mamrening udulida, Makpélahning étizliqining ichidiki gharda depne qildi. Shu gharni Ibrahim qebristanliq qilay dep Makpélahning étizliqi bilen qoshup hittiy Efrondin sétiwalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yüsüp atisini depne qilghandin kéyin, özi, qérindashliri, shundaqla atisini depne qilishqa uninggha hemrah bolup chiqqan hemme xelqler Misirgha yénip keldi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Lékin Yüsüpning qérindashliri atisining ölüp ketkinini körgende: — Emdi Yüsüp bizge düshmen bolup bizning uninggha qilghan barliq yamanliqimizni üstimizge yandurarmikin, déyishti. ");
INSERT INTO uiglat_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ular Yüsüpning qéshigha adem ewetip: — Atiliri ölüshtin ilgiri bizge wesiyet qilip tapilap: — ");
INSERT INTO uiglat_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Siler Yüsüpke: — Akiliring sanga rezillik qilghanidi; emdi ularning asiyliqi hem gunahini kechürgin! — denglar» — dégenidi. Hazir silidin ötünümizki, atilirining Xudasining bendilirining asiyliqini kechürgeyla! — dédi. Yüsüp bu geplerni anglap yighlidi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Andin akiliri kélip uning aldida özlirini yerge étip: — Mana, biz silining qulliridurmiz! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Lékin Yüsüp ulargha jawaben: — Qorqmanglar! Men Xudaning ornida turuwatamdim? ");
INSERT INTO uiglat_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Siler derweqe manga shu ishni yaman niyet bilen qildinglar; lékin Xuda bügünki kündikidek nurghunlighan xelqning jénini tirik saqlap qélish üchün shu ishni yaxshiliqqa békitkenidi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Shunga emdi qorqmanglar; men hem silerni hem bala-chaqiliringlarni baqimen, — dédi we ularning könglini xatirjem qilip méhirlik gep qildi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yüsüp atisining jemeti bilen bille Misirda turup qaldi. Yüsüp bir yüz on yil ömür kördi. ");
INSERT INTO uiglat_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Bu teriqide Yüsüp Efraimning üchinchi ewladini kördi; Manassehning oghli Makirning balilirimu uning tizliri üstide tughuldi.    ");
INSERT INTO uiglat_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yüsüp qérindashlirigha: — Men ölüp kétimen; lékin Xuda choqum silerni yoqlap silerni bu zémindin chiqirip, Ibrahim, Ishaq we Yaqupqa bérishke qesem qilip wede qilghan zémin’gha yetküzidu, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Andin Yüsüp yene qérindashlirigha qesem ichküzüp: «Xuda silerni choqum yoqlaydu; shu chaghda siler méning söngeklirimni élip, bu yerdin chiqip kétishinglar kérek», — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yüsüp bir yüz on yashqa kirgende wapat tapti. Ular uni mumiya qilip, Misirda bir méyit sanduqigha sélip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","We töwendikiler Israil bilen bille Misirgha barghan oghullirining isimliri (ular herqaysisi öz bala-chaqilirini élip, Yaqup bilen bille Misirgha barghanidi): —    ");
INSERT INTO uiglat_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Shiméon, Lawiy, Yehuda, ");
INSERT INTO uiglat_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zebulun, Binyamin, ");
INSERT INTO uiglat_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad we Ashir. ");
INSERT INTO uiglat_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Emdi Yaqupning pushtidin bolghanlar jemiy bolup yetmish adem idi. Bu waqitta Yüsüp Misirda idi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kéyin Yüsüp, uning barliq qérindashliri hemde barliq zamandashliri ölüp tügidi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Shundaqtimu, Israillar köp tughulup, téz awup, intayin kücheydi; ular zémin’gha bir keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","U waqitlarda Yüsüpni bilmeydighan yéngi bir padishah Misirda textke chiqti.    ");
INSERT INTO uiglat_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","U xelqige: Mana, Israillarning xelqi bizdin ziyade awup hemde bizdinmu küchlinip ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Emdi biz ulargha nisbeten aqilane ish tutayli; bolmisa, ular téximu awup kétidu, mubada urush partlap qalsa, shundaq boliduki, ular düshmenlirimiz terepke ötüp, bizge hujum qilip, yurttin chiqip kétishi mumkin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Shuning bilen ular ularni qiliqatqan emgeklerde xarlash üchün ish bashlirini teyinlep nazaretchilikke qoydi. Shuning bilen Israillar Pirewn üchün Pitom bilen Raamses dégen maddiy eshya saqlaydighan sheherlerni yasap berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Lékin ularni qanche ezgenséri, bular shunche köpiyip hemme yerni qaplidi; buning bilen misirliqlar Israillargha öch bolup ketti.    ");
INSERT INTO uiglat_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Shuning bilen misirliqlar Israillargha zulum qilip, ularni téximu qattiq ishlitip éghir ishlargha saldi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Misirliqlar ularni laychiliq, xish-kések quyush we étizlarning herxil emgeklirige sélip, ishning qattiqliqi bilen ularning turmushigha qattiq éghirchiliq saldi; ularni néme emgekke salmisun, intayin japaliq idi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misir padishahi ikki ibraniy tughut anisigha söz qilip (ularning birining ismi Shifrah, yene birining ismi Puah idi): ");
INSERT INTO uiglat_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","— siler qachanliki ibraniy xotunlarni tughdursanglar, tughqanda obdan qaranglar; bowaq oghul bolsa, öltürüwétinglar; qiz bolsa, tirik qoyunglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lékin tughut aniliri Xudadin qorqup, Misirning padishahi ulargha éytqandek qilmay, belki oghul bowaqlarni tirik qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Shunga Misirning padishahi tughut anilirini chaqirtip ulardin: — Bu néme qilghininglar?! Oghul balilarni némishqa tirik qoydunglar? — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tughut aniliri Pirewn’ge jawab bérip: — Ibraniy ayallar misirliq ayallargha oxshimaydu. Ular küchlük, saghlam-timen bolghini üchün tughut aniliri ularning qéshigha yétip barghuche, özliri tughup bolidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Netijide, Xuda tughut anilirigha iltipat körsetti; Israil xelqi dawamliq köpiyip, téximu kücheydi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Shundaq boldiki, tughut aniliri Xudadin qorqidighan ixlasmen bolghanliqi üchün Xuda ularni aililik bolushqa muyesser qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Buning bilen Pirewn barliq puqralirigha: — Israillardin yéngi tughulghan oghul balilarning hemmisini deryagha tashlanglar, lékin qiz balilarning hemmisini tirik qaldurunglar, dep emr qildi.      ");
INSERT INTO uiglat_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Lawiyning jemetidin bolghan bir kishi bérip, Lawiyning neslidin bolghan bir qizni xotunluqqa aldi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Bu ayal hamilidar bolup, bir oghul tughdi. Ana uning chirayliq ikenlikini körüp, uni üch ay yoshurup saqlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Uni yene yoshurushqa amalsiz qalghanda, qomushtin bir séwet yasap, uninggha yaryélim we mom suwap, balini ichige sélip, deryaning qirghiqidiki qomushluq arisigha qoyup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Andin balining hedisi uninggha néme bolarkin dep yiraqtin qarap turdi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","U waqitta Pirewnning qizi sugha chömülgili derya terepke keldi; uning chöriliri derya boyida aylinip yürdi. Pirewnning qizi qomushluqning arisida turghan séwetni körüp, xas chörisini uni élip chiqishqa ewetti.    ");
INSERT INTO uiglat_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","U séwetni échip qariwidi, mana, bir oghul balini kördi we u bala yighlap ketti. Melike uninggha ich aghritip: — Bu shübhisizki ibraniylarning baliliridin biri iken, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","U chaghda balining hedisi Pirewnning qizidin: — Men bérip, sili üchün balini émitip baqidighan bir ibraniy inik ana tépip kéleymu? — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Pirewnning qizi uninggha: — Barghin, dédi. Qiz bérip bowaqning anisini chaqirip keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pirewnning qizi uninggha: — Bu balini élip kétip men üchün émitip béqip ber; heqqingni bérimen, dédi. Shuning bilen ayal balini élip kétip, uni émitip baqti. ");
INSERT INTO uiglat_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Bala chong bolghanda uni Pirewnning qizining qéshigha élip bardi; u uninggha oghul boldi. U: «Men uni sudin chiqiriwalghan» dep uninggha Musa dégen isimni qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Musa chong bolghandin kéyinki künlerde shundaq boldiki, u öz qérindashlirining yénigha bardi we ularning éghir emgekke séliniwatqanliqini öz közi bilen kördi. Arida, bir misirliqning ibraniy qérindashliridin birini uruwatqanliqini kördi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","U töt etrapigha qarap, adem yoqluqini körüp, héliqi misirliqni urup öltürüp, qumgha kömüp yoshurup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Etisi u yene chiqip qariwidi, mana ikki ibraniy bir-biri bilen soqushuwatatti; u yolsizliq qiliwatqan kishige: — Öz qérindishingni némishqa urisen? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Héliqi kishi jawab bérip: — Kim séni bizge hakim we soraqchi qilip qoydi? Héliqi misirliqni öltürginingdek ménimu öltürmekchimusen? — dédi. Musa bu gepni anglap qorqup öz ichide: «Men qilghan ish jezmen ashkara bolup qaptu!» dep oylidi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pirewn hem bu ishtin xewer tépip, Musani öltürmekchi boldi; lékin Musa Pirewnning aldidin qéchip, Midiyan zéminigha bérip olturaqlashti. Bir küni, u quduqning yénigha kélip olturdi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midiyanning kahinining yette qizi bar idi; ular kélip, atisining qoylirini sughirishqa su tartip oqurlargha quyup toldurushqa bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","U waqitta yerlik padichilar kélip, ularni heydidi, Musa qopup qizlargha yardem bérip, qoylirini sughiriship berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ular atisi Réuelning qéshigha yénip kelgende, ulardin: — Némishqa bügün shunche téz yénip keldinglar? — dep soridi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ular jawab bérip: — Bir misirliq adem bizni padichilarning qolidin qutquzdi hemde biz üchün su tartip, qoy padimizni sughiripmu berdi! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","U qizlirigha: — Undaqta u kishi hazir nede?! Uni némishqa sirtta tashlap keldinglar? Uni tamaqqa chaqiringlar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa u kishi bilen bille turushqa maqul boldi. U qizi Zipporahni uninggha xotunluqqa berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","U ayal uninggha bir oghul tughup berdi; Musa «Men yaqa yurtta musapirdurmen» dep, uning ismini Gershom dep qoydi.    ");
INSERT INTO uiglat_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Nurghun künler ötüp, Misirning padishahi öldi. Israillar öz qulluq haliti tüpeylidin ah-zar urup, nale-peryad kötürdi; qulluqtin bolghan peryadi Xudaning huzurigha bérip yetti. ");
INSERT INTO uiglat_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Xuda ularning ah-zarlirini anglap, Özining Ibrahim bilen, Ishaq bilen we Yaqup bilen tüzgen ehdisini ésige aldi. ");
INSERT INTO uiglat_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Shuning bilen Xuda Israillarning hal-ehwalini kördi we Xuda ulargha köngül böldi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa bolsa qéynatisi Midiyanning kahini Yetroning qoy padisini baqatti. U qoylarni bashlap chölning eng chétige Xudaning téghi, yeni Horeb téghining baghrigha keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Shu yerde bir azghanliqtin örlep chiqiwatqan ot yalquni ichidin Perwerdigarning Perishtisi uninggha köründi. Mana, azghanliq otta köyüwatqan bolsimu, lékin azghan özi köyüp ketmigenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa: — Men bérip, bu ajayip menzirini körüp baqay; azghanliq némishqa köyüp ketmeydighandu? — dep oylidi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Perwerdigar uning buni körgili yoldin chetnep azghanliqqa kelginini kördi; Xuda azghanliq ichidin uni: — Musa! Musa! — dep chaqirdi. U: Mana men! — dep jawab berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","U uninggha: — Bu yerge yéqin kelme; putliringdin keshingni salghin; chünki sen turghan bu yer muqeddes jaydur.    ");
INSERT INTO uiglat_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Men atangning Xudasi, Ibrahimning Xudasi, Ishaqning Xudasi we Yaqupning Xudasidurmen, — dédi. Buni anglap Musa Xudagha qarashtin qorqup, yüzini étiwaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Perwerdigar uninggha mundaq dédi: — Berheq, Men Misirda turuwatqan qowmimning tartiwatqan azab-oqubetlirini kördum, nazaretchilerning ularni xarlawatqanliqidin qilghan peryadini anglidim; chünki Men ularning derdlirini bilimen. ");
INSERT INTO uiglat_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Shunga Men ularni misirliqlarning qolidin qutquzup, shu zémindin chiqirip, yaxshi hem keng bir zémin’gha, süt bilen hesel éqip turidighan bir zémin’gha, yeni Qanaaniy, Hittiy, Amoriy, Perizziy, Hiwiy we Yebusiylarning yurtigha élip bérishqa chüshtüm. ");
INSERT INTO uiglat_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Mana emdi Israillarning nale-peryadi Manga yetti, misirliqlarning ulargha qandaq zulum qilghanliqinimu kördüm. ");
INSERT INTO uiglat_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Emdi sen kel, Men séni xelqim Israillarni Misirdin élip chiqirish üchün Pirewnning aldigha ewetimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Lékin Musa Xudagha: — Men kim idim, Pirewnning aldigha bérip Israillarni Misirdin chiqiralighudek? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","U jawab bérip: — Berheq, Men sen bilen bille bolimen; sen qowmni Misirdin élip chiqqandin kéyin bu taghda Xudagha ibadet qilisiler; bu ish mana özüngge Méning séni ewetkinimning ispat-belgisi bolidu, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Shuning bilen Musa Xudagha: — Men Israillarning qéshigha bérip ulargha: «Ata-bowiliringlarning Xudasi méni qéshinglargha ewetti» désem, ular mendin: «Uning nami néme?» — dep sorisa, ulargha néme dep jawab bérimen? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Xuda Musagha: — Men «Ezeldin bar Bolghuchi»durmen — dédi. Andin U: — Bérip, Israillargha: ««Ezeldin bar Bolghuchi» méni qéshinglargha ewetti» dep éytqin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Xuda Musagha yene: — Israillargha: — «Ata-bowiliringlarning Xudasi, Ibrahimning Xudasi, Ishaqning Xudasi we Yaqupning Xudasi bolghan «Yahweh» méni qéshinglargha ewetti; U: Yahweh dégen bu nam ebedgiche Méning namim bolidu, dewrdin-dewrgiche Men shu nam bilen eske élinimen, deydu» — dégin. ");
INSERT INTO uiglat_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","— Bérip, Israilning aqsaqallirini yighip ulargha: — «Ata-bowiliringlarning Xudasi, yeni Ibrahim, Ishaq we Yaqupning Xudasi bolghan Perwerdigar manga körünüp: — Men silerni yoqlap keldim, Misirda silerge qandaq muamile qiliniwatqanliqini kördüm; ");
INSERT INTO uiglat_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","shuning üchün sözüm shudurki, Men silerni Misirning zulumidin chiqirip, Qanaaniylar, Hittiylar, Amoriylar, Perizziyler, Hiwiylar we Yebusiylarning zémini, yeni süt bilen hesel éqip turidighan zémin’gha élip barimen, dédi, — dégin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","— Shuning bilen ular séning sözüngge qulaq salidighan bolidu. U waqitta sen, özüng we Israilning aqsaqalliri bilen birge Misir padishahining aldigha bérip, uninggha: «Ibraniylarning Xudasi Perwerdigar biz bilen körüshti. Emdi sizdin ötünimizki, bizge üch künlük yolni bésip, chölge bérip, Xudayimiz Perwerdigargha qurbanliq qilishqa ijazet bergeysiz» — denglar. ");
INSERT INTO uiglat_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Lékin Misir padishahining hetta qudretlik bir qolning astida turupmu, silerni yenila qoyup bermeydighinini bilimen. ");
INSERT INTO uiglat_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Shunga qolumni uzitip, misirliqlarni Men öz zémini ichide körsetmekchi bolghan herxil karamet-möjizilirim bilen urimen; andin Pirewn silerni qoyup béridu. ");
INSERT INTO uiglat_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Bu qowmni misirliqlarning aldida iltipat tapturimen we shuning bilen shundaq boliduki, siler shu yerdin chiqqininglarda, quruq qol chiqmaysiler. ");
INSERT INTO uiglat_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Belki herbir ayal kishi öz qoshnisidin we öz öyide olturushluq yat ayaldin kümüsh zinnet buyumliri, altun zinnet buyumliri we kiyim-kécheklerni telep qilidu. Bu nersilerni oghul-qizliringlargha taqaysiler, kiydürisiler; shu teriqide misirliqlardin olja alghan bolisiler, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa jawab bérip: — Mana, ular manga ishenmey turup, sözümge qulaq salmaydu, belki: «Perwerdigar sanga körünmidi», déyishi mumkin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Perwerdigar uninggha: — Qolungdiki bu néme? — dep soridi. U: — Bu bir hasa, dep jawab berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","U: — Uni yerge tashla, dédi. Uni yerge tashliwidi, u bir yilan’gha aylandi; Musa uning aldidin qachti. ");
INSERT INTO uiglat_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Andin Perwerdigar Musagha: — Qolungni uzitip, uni quyruqidin tut, déwidi, u qolini uzitip, uni tutti. U yene uning qolida hasigha aylandi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Perwerdigar yene: — Buning bilen ular ata-bowilirining Xudasi, yeni Ibrahimning Xudasi, Ishaqning Xudasi we Yaqupning Xudasi bolghan Perwerdigarning sanga körün’ginige ishinidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Perwerdigar uninggha yene: — Qolungni qoynunggha salghin, déwidi, u qolini qoynigha sélip chiqiriwidi, mana, qoli pése-maxaw késilige giriptar bolup qardek aqirip ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Andin uninggha: — Qolungni yene qoynunggha salghin, déwidi, qolini qoynigha saldi. Uni yene qoynidin chiqiriwidi, mana, öz eksige kélip etlirining bashqa yerliridek boldi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Perwerdigar yene: — Shundaq boliduki, eger ular sanga ishenmey, aldinqi möjizilik alametke köngülshimise, ular ikkinchi möjizilik alametke ishinidu. ");
INSERT INTO uiglat_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Halbuki, ular bu ikki möjizige yenila ishenmise we ya sözüngge qulaq salmisa, undaqta sen Nil deryasining süyidin élip, quruq yerge tökkin. Shuning bilen sen deryadin alghan su quruq yer üstide qan’gha aylinidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Andin Musa Perwerdigargha: — Ey Igem, men eslidinla gepke usta emestim, sen qulunggha söz qilghandin kéyinmu yenila shundaq; chünki men aghzim kalwa we tilim éghir ademmen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Perwerdigar uninggha: — Kim insan’gha éghiz bergen? Kim ademni gacha yaki gas, körgüchi yaki kor qilghan? Shundaq qilghuchi Men Perwerdigar emesmu? ");
INSERT INTO uiglat_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Emdi sen barghin, Men Özüm séning aghzing bilen bille bolimen, néme sözleydighiningni sanga ögitip turimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Lékin u: — Ey Igem! Sendin ötünüp qalay, Sen bu ishqa xalighan bashqa birsini ewetip, shuning qoli bilen qilghin! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Buni anglap Perwerdigarning ghezipi Musagha tutiship: — Lawiylardin bolghan akang Harun bar emesmu? Uning gepni obdan qilalaydighinini bilimen. Mana, u emdi séning aldinggha chiqishqa alliqachan yolgha chiqti; u séni körse, köngli tolimu xush bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Emdi deydighan geplerni uninggha éyt; Men Özüm séning aghzing bilen bille we uning aghzi bilen bille bolimen, néme qilish kéreklikinglarni silerge ögitimen.    ");
INSERT INTO uiglat_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Harun séning ornungda xelqqe sözleydu; shundaq boliduki, u sanga éghiz bolidu, sen uninggha Xudadek bolisen. ");
INSERT INTO uiglat_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Bu hasini qolunggha élip, uning bilen shu möjizilik alametlerni körsitisen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Shuning bilen Musa qéynatisi Yetroning qéshigha yénip bérip, uninggha: — Manga ijazet bergeyla, Misirdiki qérindashlirimning qéshigha baray, ular hayatmu, emesmu körüp kéley, dédi. Yetro Musagha: — Aman-ésen bérip kelgin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa téxi Midiyandiki waqtida, Perwerdigar uninggha yene: — Misirgha yénip barghin! Chünki séning jéningni istigen kishiler ölüp ketti, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Shuning bilen Musa ayali we oghullirini élip, ularni bir éshekke mindürüp, Misir zéminigha bérishqa yolgha chiqti. Mangghanda Musa Xudaning hasisini alghach ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Perwerdigar Musagha: — Misirgha yénip barghiningda sen agah bol, Men qolunggha tapshurghan barliq karametlerni Pirewnning aldida körsetkin. Lékin Men uning könglini xelqni qoyup bermigüdek qattiq qilimen. ");
INSERT INTO uiglat_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Sen Pirewn’ge: — «Perwerdigar mundaq deydu: — Israil Méning oghlum, Méning tunji oghlum bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Shuning üchün Men sanga: Oghlumni Özümge ibadet qilishqa qoyup ber, dédim. Uninggha yol qoyushni ret qilidighan bolsang, séning tunji oghlungni öltürimen» — dégin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Emma Musa seper qilip bir qonalghugha kelgende, Perwerdigar uninggha uchrap, uni öltürüwetmekchi boldi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Shuning bilen Zipporah bir chaqmaq téshini élip, oghlining xetnilikini késip, uni érining ayighigha tashlap: — Sen derweqe aldimda qan töker er ikensen! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Shuning bilen Perwerdigar uni qoyup berdi (bu chaghda Zipporah uninggha: «Sen derweqe aldimda qan töker bir er ikensen!» — dédi. Bu sözini u xetne tüpeylidin éytti). ");
INSERT INTO uiglat_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Perwerdigar Harun’gha: — Sen chöl-bayawan’gha bérip, Musa bilen körüshkin, déwidi, u bérip Xudaning téghida uning bilen uchriship, uni söydi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa özini ewetken Perwerdigarning hemme sözliri bilen qilishqa buyrughan barliq möjizilik alametlerni Harun’gha dep berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Andin Musa bilen Harun bérip, Israillarning barliq aqsaqallirini yighdi. ");
INSERT INTO uiglat_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Harun Perwerdigarning Musagha éytqan hemme sözlirini bayan qildi we xelqning köz aldida shu möjizilik alametlerni körsetti. ");
INSERT INTO uiglat_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Buni körüp, xelq ishendi; Perwerdigarning Israillarni yoqlap, ular uchrighan xarliqlarni körgenlikini anglighan haman, bashlirini égip sejde qilishti. ");
INSERT INTO uiglat_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Andin Musa bilen Harun Pirewnning aldigha bérip, uninggha: — Israilning Xudasi Perwerdigar sanga: — «Ularning bérip chölde Manga ibadet qilip, héyt ötküzüshige qowmimgha yol qoysun» deydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Lékin Pirewn jawab bérip: — Uning sözige qulaq sélip, méni Israilgha yol qoyghuzidighan qandaq Perwerdigar iken u? Men u Perwerdigarni tonumaymen hem Israilghimu yol qoymaymen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ular söz qilip: — Ibraniylarning Xudasi biz bilen körüshti. Shunga ötünimizki, bizge Perwerdigar Xudayimizgha qurbanliq sunush üchün bizge chölge bérishqa üch künlük yolgha ruxset bergeysiz. Bolmisa, U bizni waba yaki qilich bilen urushi mumkin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Lékin Misirning padishahi ulargha jawab bérip: — Ey Musa we Harun, némishqa ikkinglar xelqni ishliridin toxtitip qoymaqchi bolisiler? Bérip öz epkishinglarni kötürünglar! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pirewn yene: — Mana, xelq yurtta ziyade awup ketti. Siler bolsanglar, ularni epkeshliridin xalas qilmaqchisiler, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Shu küni Pirewn nazaretchilerge we nazaretchilerning qol astidiki ish bashlirigha buyruq chüshürüp: — ");
INSERT INTO uiglat_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Hazirdin bashlap xelqqe ilgirikidek kések quyushqa saman bermenglar! Ular samanni özliri yighsun. ");
INSERT INTO uiglat_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Lékin ilgiri qanchilik kések quyup kelgen bolsa, hélihem kem qilmay shunchilik kések quydurunglar; chünki ular hurunliship: «Xudayimizgha qurbanliq ötküzüshke bizni barghili qoy» dep ghelwe qilishiwatidu. ");
INSERT INTO uiglat_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Emdi ularni öz ishigha toluq bend bolup, yalghan-yawidaq geplerge qulaq salmasliqi üchün, bu ademlerning üstige téximu éghir emgeklerni yüklenglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Shuning bilen xelqning üstidiki nazaretchiler bilen ish bashliri chiqip xelqqe: Pirewn shundaq dédiki, men emdi silerge saman bermeydighan boldum. ");
INSERT INTO uiglat_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Özünglar béringlar, özünglar üchün qeyerdin saman tapalisanglar, shu yerdin élip kélinglar; lékin qilidighan ishliringlar bolsa qilchilikmu kémeytilmeydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Buning bilen xelq pütkül Misir zéminigha tarilip, samanning ornigha paxal yighishqa bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Nazaretchiler bolsa ularni qistap: Silerge saman bérilgen chaghdikidek hazirmu her künlük ishni shu küni qilinglar, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Israillarning üstige Pirewnning nazaretchiliri teripidin qoyulghan Israilliq ish bashliri tayaq yédi we: — Tünügün we bügün némishqa kések quyush wezipsini burunqidek toshquzup orunlimidinglar?! — dep til ishitti. ");
INSERT INTO uiglat_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Andin Israilliq ish bashliri Pirewnning aldigha bérip: Némishqa öz qullirigha mundaq muamile qilidila? ");
INSERT INTO uiglat_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Öz qullirigha héch saman bérilmidi. Lékin nazaretchiler yenila «kések quydurunglar» dep bizni buyruydu. Mana, öz qulliri tayaq yewatidu, emma eyib bolsa özlirining ademliride, dep peryad qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Lékin u yene: — Siler hurun ikensiler! Hurun ikensiler! Shunga siler: «Bérip Perwerdigargha qurbanliq ötküzüshimizge ijazet ber dewatisiler. ");
INSERT INTO uiglat_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Qaytip bérip ishingni qilish! Silerge saman bérilmeydu, biraq késeklerni belgilen’gen san boyiche awwalqidek toluq tapshurushisen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israilliq ish bashliri Pirewnning: «Siler herkünlük wezipenglarni, yeni telep qilghan késeklerni belgilen’gen sandin kémeytsenglar qet’iy bolmaydu» déginige qarap, béshigha bala-qazaning chüshidighanliqini bilishti. ");
INSERT INTO uiglat_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ular Pirewnning aldidin chiqip kéliwatqinida, ular bilen körüshüshke kélip shu yerde saqlap turghan Musa we Harun bilen uchriship qaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ular Musa bilen Harun’gha: — Bizni Pirewnning neziride we uning emeldarlirining neziride sésitip, bizni öltürüshke ularning qoligha qilich tutquzghininglar üchün, Perwerdigar silerning üstünglargha höküm qilsun! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Shuning bilen Musa Perwerdigarning aldigha yénip bérip uninggha: — Ey Igem, némishqa bu xelqni balagha tiqting? Sen néme üchün méni ewetting? ");
INSERT INTO uiglat_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Chünki men Pirewnning aldigha kirip Séning naming bilen söz qilghinimdin tartip, u bu xelqning üstige téximu ziyade azab qilghili turdi. Emma Sen téxiche qowmingni héch qutquzmiding, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Lékin Perwerdigar Musagha: — Emdi sen Méning Pirewn’ge qilidighanlirimni körisen; chünki u qudretlik bir qoldin mejburlinip, ularni qoyup béridu, qudretlik bir qolning sewebidin özining zéminidin ularni qoghlap chiqiriwétidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Andin Xuda Musagha yene söz qilip mundaq dédi: — Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Men Ibrahimgha, Ishaqqa we Yaqupqa Qadir-mutleq Tengri süpitide köründüm; lékin «Yahweh» dégen namim bilen ulargha ashkara tonulmidim. ");
INSERT INTO uiglat_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Men ular bilen: — «Siler musapir bolup olturghan zéminni, yeni Qanaan zéminini silerge bérimen» dep, ular bilen ehde baghliship wede qilghanmen. ");
INSERT INTO uiglat_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Emdi Men misirliqlar qul qilip zulum salghan Israillarning ah-zarlirini anglap, qilghan shu ehdemni ésimge aldim. ");
INSERT INTO uiglat_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Shunga Israillargha mundaq dégin: — «Men Perwerdigardurmen; Men Özüm silerni misirliqlarning éghir yükliri astidin chiqirip, ularning qulluqidin azad qilip, qolumni uzitip ulargha chong balayi’apetlerni chüshürüp, silerge hemjemet bolup hörlükke érishtürimen. ");
INSERT INTO uiglat_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Silerni Öz qowmim bolushqa qobul qilimen we Özüm Xudayinglar bolimen; shuning bilen siler özünglarni misirliqlarning yüklirining astidin qutquzup chiqarghuchining Men Xudayinglar Perwerdigar ikenlikini bilisiler. ");
INSERT INTO uiglat_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Men shuning bilen silerni qol kötürüp Ibrahimgha, Ishaqqa we Yaqupqa bérishke qesem qilghan zémin’gha élip barimen; Men u yerni silerge miras qilip zéminliqqa bérimen; Men Perwerdigardurmen». ");
INSERT INTO uiglat_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Bularning hemmisini Musa Israillargha dep berdi; lékin ular éghir qulluq azabidin pighan’gha chüshken bolup, uninggha qulaq salmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Andin Perwerdigar Musagha yene: — ");
INSERT INTO uiglat_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Bérip Misirning padishahi Pirewn’ge: «Israillarning zéminingdin kétishige yol qoy», dep éytqin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Lékin Musa Perwerdigarning aldida: Mana, Israillar manga qulaq salmighan yerde, Pirewn qandaqmu mendek kalpuki xetne qilinmighan bir ademge qulaq salsun? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Emma Perwerdigar Musa we Harun’gha sözlep, ularning Israillargha we Misirning padishahi Pirewn’ge Israillar toghruluq: — «Ular Misir zéminidin élip chiqirilsun» dégen emr yetküzüshini buyrudi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Töwendikiler jemet bashliqliri: — Israilning tunji oghli bolghan Rubenning oghulliri Hanuq, Pallu, Hezron we Karmi. Bular bolsa Rubenning nesilliri idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Shiméonning oghulliri: — Yemuel, Yamin, Ohad, Yaqin, Zohar we qanaanliq ayaldin bolghan Saullar idi; bular Shiméonning nesilliri idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lawiyning oghullirining isimliri, nesebnamilirige asasen: Gershon, Kohat we Merari; Lawiyning ömrining yilliri bir yüz ottuz yette yil boldi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershonning oghulliri aililiri boyiche: — Libni we Shimey. ");
INSERT INTO uiglat_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohatning oghulliri: — Amram, Yizhar, Hébron bilen Uzziel. Kohat bir yüz ottuz üch yil ömür kördi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merarining oghulliri: — Mahli we Mushi. Bular nesebnamiliri boyiche Lawiyning nesilliri idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram öz hammisi Yokebedni xotunluqqa aldi, Yokebed uninggha Harun we Musani tughup berdi. Amram bir yüz ottuz yette yil ömür kördi.    ");
INSERT INTO uiglat_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yizharning oghulliri: — Korah, Nefeg we Zikri idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzzielning oghulliri: — Mishael, Elzafan we Sitri idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Harun bolsa Nahshonning singlisini, yeni Amminadabning qizi Élishébani xotunluqqa aldi. U uninggha Nadab bilen Abihuni, we Eliazar bilen Itamarni tughup berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korahning oghulliri: — Assir, Elkanah we Abi’asaf; bular Korahlarning nesilliri idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Harunning oghli Eliazar Putielning qizlirining birini xotunluqqa aldi; u uninggha Finihasni tughup berdi; bular bolsa öz nesebi boyiche hemmisi Lawiylarning jemet bashliqliri idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Perwerdigarning: — Israillarni qoshunlardek top-topi bilen Misir zéminidin élip chiqinglar, dégen emrini tapshuruwalghuchilar del mushu Harun bilen Musa idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Israillar Misirdin chiqirilsun, dep Misirning padishahi Pirewn’ge söz qilghanlar del bu kishiler, yeni mushu Musa bilen Harun idi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Perwerdigar Misirning zéminida Musagha söz qilghan waqtida ");
INSERT INTO uiglat_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Musagha: «Men Perwerdigardurmen. Sanga éytqinimning hemmisini Misirning padishahi Pirewn’ge dégin», dep emr qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Lékin Musa Perwerdigarning aldida: — Mendek kalpuki xetne qilinmighan bir kishige Pirewn qandaqmu qulaq salsun?» — dep jawap bergenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Shuning bilen Perwerdigar Musagha: — Mana, Men Pirewnning aldida séni Xudaning ornida qildim. Akang Harun bolsa séning peyghembiring bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Men sanga buyrughinimning hemmisini uninggha deysen; andin akang Harun Pirewn’ge uning öz zéminidin Israillarni qoyup bérishi kérekliki toghrisida söz qilidu.    ");
INSERT INTO uiglat_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Lékin Men Pirewnning könglini qattiq qilimen; buning bilen Men Misir zéminida möjizilik alametler we karametlirimni köplep körsitimen. ");
INSERT INTO uiglat_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Shundaqtimu, Pirewn silerge qulaq salmaydu. Emma Men Misirning üstige höküm chiqirip qolumni uzitip, chong balayi’apetlerni chüshürüp, qoshunlirim bolghan Öz qowmim Israillarni Misir zéminidin chiqirimen. ");
INSERT INTO uiglat_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Öz qolumni Misirning üstige sozghinimda, Israillarni ularning arisidin chiqarghinimda misirliqlar Méning Perwerdigar ikenlikimni tonup yétidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa bilen Harun shundaq qildi; Perwerdigar ulargha qandaq tapilighan bolsa, ularmu shundaq qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ular Pirewn’ge söz qilghan waqitta Musa seksen yashqa, Harun seksen üch yashqa kirgenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Perwerdigar Musa bilen Harun’gha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Emdi Pirewn silerge: — Özünglarni testiqlap bir möjize körsitinglar, dése, sen Harun’gha: — Hasangni élip Pirewnning aldigha tashlighin, dep éytqin. Shundaq qilishi bilenla hasa yilan’gha aylinidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Shuning bilen, Musa bilen Harun Pirewnning aldigha bérip, Perwerdigarning buyrughinidek qildi; Harun hasisini Pirewn bilen uning emeldarlirining aldigha tashliwidi, u yilan’gha aylandi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","U waqitta Pirewn danishmenliri we séhirgerlirini chaqirtip keldi; Misirning jadugerlirimu öz jadusi bilen oxshash ishni qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ularning herbiri öz hasisini tashlidi; ularmu yilan’gha aylandi. Lékin Harunning hasisi ularning hasilirini yutup ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Biraq Perwerdigar éytqandek Pirewnning köngli qattiqliq bilen Perwerdigar éytqandek ulargha qulaq salmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Andin Perwerdigar Musagha mundaq dédi: — Pirewnning köngli qattiq; u qowmni qoyup bérishni ret qilidu. ");
INSERT INTO uiglat_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Emdi sen ete seherde Pirewnning qéshigha barghin (shu waqitta u su boyigha chiqidu) — Sen uning bilen körüshüshke deryaning boyida saqlap turghin; yilan’gha aylan’ghan hasini qolunggha éliwal. ");
INSERT INTO uiglat_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Sen uninggha mundaq dégin: — «Ibraniylarning Xudasi Perwerdigar méni aldinggha: «Chölde Manga ibadet qilishi üchün qowmimni qoyup ber» déyishke ewetkenidi; lékin mana, bu waqitqiche héch anglimiding. ");
INSERT INTO uiglat_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Shunga Perwerdigar sanga: — «Sen shu alamet bilen Méning Perwerdigar ikenlikimni bilisen», deydu — Mana, men qolumdiki hasa bilen deryaning süyini ursam, su qan’gha aylinidu, ");
INSERT INTO uiglat_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","deryaning béliqliri ölüp, deryaning süyi sésip kétidu; misirliqlar sudin seskinip, ichelmeydighan bolup qalidu». ");
INSERT INTO uiglat_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Perwerdigar Musagha yene: — Sen Harun’gha: — Hasangni élip misirliqlarning suliri qan’gha aylansun dep ularning üstige, yeni éqinliri, östengliri, kölliri we su ambarliri üstige qolungni uzatqin. Shuning bilen pütkül Misir zéminida, hetta yaghach we tash qachilardiki sularmu qan’gha aylinidu, dégin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa bilen Harun Perwerdigarning buyrughinidek qildi; Harun Pirewn we emeldarlirining köz aldida hasini kötürüp, deryaning süyini uruwidi, pütün deryaning süyi qan’gha aylinip ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Deryadiki béliqlar ölüp, deryaning süyi sésip ketti. Misirliqlar deryaning süyini ichelmeydighan bolup qaldi, pütkül Misir zémini qan’gha toldi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Lékin Misirning jadugerlirimu öz jaduliri bilen hem shundaq qildi. Bu sewebtin Perwerdigar éytqandek Pirewnning köngli qattiq bolup, ulargha qulaq salmidi; ");
INSERT INTO uiglat_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","eksiche Pirewn öyige qaytip kétip, bu ishqa héch pisent qilmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Deryaning süyini ichelmigini üchün barliq misirliqlar ichküdek su tépish üchün deryaning etraplirini kolidi. ");
INSERT INTO uiglat_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Perwerdigar deryani urup, yene yette kün ötti. ");
INSERT INTO uiglat_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Andin Perwerdigar Musagha: — Pirewnning aldigha bérip uninggha: — Perwerdigar mundaq deydu: — «Manga ibadet qilishqa Öz qowmimni qoyup ber. ");
INSERT INTO uiglat_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Lékin ularni qoyup bérishni ret qilsang, mana, Men dölitingning hemme yérini paqilar bilen basturup urimen. ");
INSERT INTO uiglat_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Deryada top-top paqilar peyda bolup, deryadin chiqip ordanggha, hujranggha, orun-körpengge, emeldarliringning öylirige kiriwalidu, shuningdek xelqingning uchisigha, tonur we tengniliringge yamiship chiqiwalidu. ");
INSERT INTO uiglat_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Paqilar özüngning üstibéshigha, xelqingning üstibéshigha we hemme emeldarliringning üstibéshigha yamiship chiqiwalidu» — dégin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Perwerdigar Musagha: — Sen Harun’gha: Paqilarning Misir zéminining üstige chiqishi üchün qolungni uzitip, hasangni éqinlar, östengler we köllerning üstige shiltighin, dégin — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Shuning bilen Harun qolini Misirning suliri üstige uzatti; shundaq qiliwidi, paqilar chiqip Misir zéminini qaplidi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lékin jadugerlermu öz jaduliri bilen oxshash ishni qilip, Misir zémini üstige paqilarni peyda qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pirewn Musa bilen Harunni chaqirtip: — Paqilarni mendin we xelqimdin néri qilish üchün Perwerdigardin ötününglar. Shundaq bolsa, men xelqingni Perwerdigargha qurbanliq qilsun dep qoyup bérimen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa Pirewn’ge: — Boptu, men izzitingni qilay, peqet deryadiki paqilarla qélip, bashqiliri özüngdin we öyliringdin ayrilsun dep, sen, emeldarliring we xelqing üchün méning dua qilidighan waqtimni békitkin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","U jawab bérip: — Ete bolsun, dédi. Musa uninggha: — Xudayimiz Perwerdigargha oxshash héchbirining yoqluqini bilishing üchün séning déginingdek bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Paqilar sendin, öyliringdin, emeldarliring we xelqingdin chiqip kétidu; peqet deryadila qalidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Shuning bilen Musa we Harun Pirewnning aldidin chiqip ketti. Andin Musa Pirewnning üstige ewetilgen paqilar toghrisida Perwerdigargha nida qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Perwerdigar Musaning tiliginidek qildi. Buning bilen öylerdiki, hoylilardiki we étizlardiki paqilar öldi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Xelq ularni yighip döwe-döwe qildi, pütkül yurt-zémin sésiqchiliqqa toldi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Lékin Pirewn apettin xalas bolghinini körgende, könglini qattiq qilip, Perwerdigar éytqinidek ulargha qulaq salmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Andin Perwerdigar Musagha: — Sen Harun’gha: — Hasangni uzitip, yerning topisini urghin. Buning bilen u pashigha aylinip, pütkül Misir zéminini qaplaydu, dégin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ular shundaq qildi; Harun qolini uzitip hasisi bilen yerning topisini uruwidi, ademler we haywanlarning üstibéshini pasha basti; pütkül Misir zéminidiki topa-changlar pashigha aylandi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Jadugerlermu öz jaduliri bilen shundaq qilip pasha peyda qilishqa urun’ghan bolsimu, peyda qilalmidi. Pashilar bolsa hem ademlerning hem haywanlarning üstibéshini qaplap ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Andin jadugerler Pirewn’ge: — Bu ish Xudaning barmiqining qilghini! — déyishti. Lékin Pirewn könglini qattiq qilip, Perwerdigar éytqinidek ulargha qulaq salmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Perwerdigar Musagha: — Ete seher qopup Pirewnning aldigha bérip turghin — (shu waqitta u su boyigha chiqidu) uninggha: «Perwerdigar mundaq deydu: — Manga ibadet qilishi üchün Öz qowmimni qoyup ber! ");
INSERT INTO uiglat_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Chünki eger qowmimni qoyup bermiseng, mana Men séning we emeldarliring, xelqing üstige, öyliringge köküyünlerni ewetimen; shuning bilen misirliqlarning öyliri we hetta ular turuwatqan tupraqmu köküyünler bilen tolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Lékin shu künide Öz qowmim turuwatqan Goshen yurtini bashqiche qilimen; shundaq boliduki, u yerde köküyünler tépilmaydu. Shuning bilen sen Men Perwerdigarning bu zéminda bolghanliqimni bilisen. ");
INSERT INTO uiglat_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Shundaq qilip Men Öz qowmimni séning xelqingdin perqlendürimen; bu möjizilik alamet ete yüz béridu», dep éytqin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Perwerdigar déginini qildi. Pirewnning öylirige, emeldarlirining öylirige köküyünler top-top bolup kirdi; pütkül Misir zéminining hemme yéri köküyünler teripidin xarab bolushqa bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pirewn Musa bilen Harunni chaqirtip kélip ulargha: Bérip mushu zéminda Xudayinglargha qurbanliq ötküzünglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Lékin Musa jawab bérip: — Bundaq qilish bizge taza muwapiq bolmaydu; chünki biz Perwerdigar Xudayimizgha sunmaqchi bolghan qurbanliq mal misirliqlargha nisbeten yirginchliktur. Emdi eger biz misirliqlarning köz aldida yaman körün’gen nersini qurbanliq qilsaq ular bizni chalma-kések qiliwetmemdu?    ");
INSERT INTO uiglat_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Biz üch künlük yolni bésip, chölde Perwerdigar Xudayimiz bizge buyrughinidek uninggha qurbanliq sunushimiz kérek, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pirewn: — Silerni Perwerdigar Xudayinglargha chölde qurbanliq ötküzüshke barghili qoyimen; peqet bek yiraq kétip qalmanglar, méning üchün dua qilinglar, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa jawab bérip: — Mana, men séning aldingdin chiqip Perwerdigargha iltija qilimen we köküyünler sen Pirewndin, emeldarliringdin we xelqingdin ete chiqip kétidu; lékin Pirewn yene hiyle ishlitip, xelqni Perwerdigargha qurbanliq qilishqa bérishtin tosquchi bolmisun, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Musa Pirewnning aldidin chiqip, Perwerdigargha shundaq iltija qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Perwerdigar Musa tiliginidek qildi; u köküyünlerni Pirewn, emeldarliri we xelqidin chiqiriwetti; hetta bir tal köküyünmu qalmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Lékin Pirewn bu qétimmu könglini qattiq qilip, qowmni qoyup bermidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Andin Perwerdigar Musagha: — Pirewnning aldigha bérip uninggha: — «Ibraniylarning Xudasi Perwerdigar mundaq deydu: — Manga ibadet qilishigha Öz qowmimni qoyup ber. ");
INSERT INTO uiglat_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Eger ularni qoyup bérishni ret qilip, yenila tutup turuwalidighan bolsang, ");
INSERT INTO uiglat_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","mana, Perwerdigarning qoli étizliqtiki charpayliringning üstige, at-éshekler, tögiler, we qoy-kaliliringning üstige chüshüp intayin éghir bir waba keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Lékin Perwerdigar Israilning charpaylirini misirliqlarning charpayliridin perqlendüridu. Netijide, Israilning charpayliridin héchbiri ölmeydu» — dégin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Perwerdigar waqitni békitip: — Ete Perwerdigar zéminda bu ishni qilidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Etisi Perwerdigar shundaq qildi; misirliqlarning barliq charpayliri öldi; lékin Israillarning charpayliridin birimu ölmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pirewn adem ewetip tekshüriwidi, mana, Israillarning charpayliridin birimu ölmigenidi. Lékin Pirewnning köngli qattiq qilinip, u qowmni qoyup bermidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Andin Perwerdigar Musa we Harun’gha: — Xumdanning külidin changgilinglarni toshquzup élinglar, andin Musa uni Pirewnning köz aldida asman’gha qaritip chachsun. ");
INSERT INTO uiglat_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Shundaq qilishi bilen kül pütkül Misir zéminini qaplaydighan chang-tozan bolidu we Misir zéminidiki hemme yerde ademler we haywanlarning bedinige chüshüshi bilen hürrek-hürrek chaqa chiqiridu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Shuning bilen ular xumdandin kül élip, Pirewnning aldigha bérip turdi we Musa uni asman’gha qaritip chachti; u ademler we haywanlarning bedinige chüshüshi bilen hürrek-hürrek chaqa chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Jadugerler chaqilar destidin Musaning aldida turalmay qaldi; chünki jadugerlerning bedininimu, bashqa barliq misirliqlarnimu oxshash chaqa bésip ketkenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Lékin Perwerdigar Pirewnning könglini qattiq qildi; shunga Perwerdigar del Musagha éytqinidek u ulargha qulaq salmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Andin Perwerdigar Musagha: — Ete tang seher qopup, Pirewnning aldida turup uninggha: «Ibraniylarning Xudasi Perwerdigar mundaq deydu: — Qowmimni Manga ibadet qilishqa qoyup ber; ");
INSERT INTO uiglat_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","chünki Men bu qétim hemme balayi’apetlirimni yürikingge, emeldarliring we puqraliringning üstige ewetimen. Buning bilen sen pütkül yer yüzide Mendek bashqa birining yoq ikenlikini bilisen. ");
INSERT INTO uiglat_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Chünki Men qolumni uzitip, özüng we qowmingni waba bilen urghan bolsam’idi, bu waqitqiche sen yer yüzidin yoqilip kétetting. ");
INSERT INTO uiglat_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Halbuki, Méning séni ornunggha tiklishimdiki meqsitim shu idiki, del Öz qudritimni sanga körsitish, shundaqla namimning pütkül yer yüzide jakarlinishi üchün idi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Sen yene qowmimgha chongchiliq qilip, ularni qoyup bérishni ret qiliwéremsen? ");
INSERT INTO uiglat_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mana, ete mushu waqitlarda Misir döliti bina bolghandin buyan héch körülüp baqmighan qattiq möldürni yaghdurimen. ");
INSERT INTO uiglat_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Shuning üchün adem ewetip, haywan we étizda bar-yoqungni yighip ichkiri solighin; chünki öyge qayturulmay sirtta qalghan adem we haywanlarning hemmisi möldürning astida qélip ölüp kétidu! — dégin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Buni anglap Pirewnning emeldarlirining arisidin Perwerdigarning sözidin qorqqan herbir adem öz qulliri we charpaylirini yügürtüp öylirige élip keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Lékin Perwerdigarning sözini étibargha almighanlar öz qul we mallirini tashqirida qaldurup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Perwerdigar Musagha: — Misir zéminidiki her yerde, ademler üstige, mallarning üstige, shundaqla Misir zéminidiki dalalarning hemme ot-chöplirining üstige möldür yaghsun dep, asman’gha qarap qolungni kötürgin, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa shuning bilen hasisini asman’gha qaritip kötürüwidi, Perwerdigar güldürmamini güldürlitip, möldür yaghdurdi, yer yüzide chaqmaq chéqindiliri chépip yüretti. Shundaq qilip Perwerdigar Misir zémini üstige möldür yaghdurdi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Möldür yéghip, möldür bilen ot arilash chüshti; möldür shunche éghir boldiki, Misir döliti bina bolghandin tartip undaq qattiq möldür yéghip baqmighanidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Möldür pütkül Misir zéminining her yéride chüshüp, insan bolsun, haywan bolsun, hemmisini urdi; möldür étizdiki hemme ot-chöpni urup, yerdiki hemme del-derexlernimu sunduruwetti. ");
INSERT INTO uiglat_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Peqet Israillar olturushluq Goshen zéminidila möldür yaghmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pirewn adem ewetip Musa bilen Harunni chaqirtip ulargha: — Men bu qétim gunah qildim! Perwerdigar heqqaniydur; Sewenlik bolsa men we xelqimdin ötti. ");
INSERT INTO uiglat_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Yene bérip Perwerdigardin ötünüp iltija qilinglar! Xudadin chiqqan bu qattiq güldürmamilar we möldür yétip ashti! Silerni qoyup bérey; siler emdi mushu yerde turiwersenglar bolmaydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa uninggha jawab bérip: — Men sheherdin chiqqanda, Perwerdigar terepke qarap qollirimni yéyip kötürimen; güldürmamilar shu haman bésiqip möldür yene yaghmaydu. Yer yüzi Perwerdigarningkidur, dep bilishing üchün shundaq bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Lékin sen we séning emeldarliring, silerning Perwerdigar Xudadin téxiche qorqmaywatqininglarni bilimen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Shu chaghda arpa bash chiqirip, zighir ghunchilighan bolghachqa, zighir we arpa möldürdin weyran qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Lékin bughday bilen qara bughday kéyinrek bix chiqarghachqa, weyran qilinmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa Pirewnning aldidin kétip, sheherdin chiqip Perwerdigar terepke qarap qollirini yéyip kötürdi. Shuning bilen güldürmama we möldür toxtap, yamghur yerge yene tökülmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Emma Pirewn yamghur, möldür we güldürmamilarning toxtighinini körgende, yene gunah sadir qildi; umu, emeldarlirimu könglini qattiq qilishti. ");
INSERT INTO uiglat_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Bu teriqide Pirewnning köngli qattiq turuwérip, Perwerdigar Musaning wasitisi bilen éytqandek, Israillarni qoyup bérishni ret qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Andin Perwerdigar Musagha: — Pirewnning aldigha barghin; chünki ularning arisida bu möjizilik alametlerni körsitishim üchün Pirewnning könglini we emeldarlirining könglini qattiq qilip qoydum. ");
INSERT INTO uiglat_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Bu ish bilen Méning misirliqlarni qandaq reswa qilghanliqim we ularning arisida körsetken möjizilik alametlirimni sen oghlungning andin newrengning quliqigha yetküzisen. Buning bilen Méning Perwerdigar ikenlikimni bilisiler, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Shuning bilen Musa bilen Harun Pirewnning aldigha bérip, uninggha: — Ibraniylarning Xudasi Perwerdigar mundaq deydu: «Özüngni aldimda töwen tutushni qachan’ghiche ret qilisen? Manga ibadet qilish üchün qowmimni qoyup ber. ");
INSERT INTO uiglat_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Chünki eger sen qowmimni qoyup bérishni ret qilsang, mana, Men ete séning yurtunggha chéketke ewetimen. ");
INSERT INTO uiglat_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ular siler zémin yüzini körmigüdek qilip yépiwétidu, silerning möldürdin aman qalghan nersiliringlarnimu, dalalarda ösken hemme del-derexliringlarnimu yep kétidu. ");
INSERT INTO uiglat_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ular orda-sarayliringgha, emeldarliringning sarayliri, shundaqla barliq misirliqlarning öylirige tolup kétidu; bundaq apetni ata-bowangliring we ata-bowiliringning ata-bowilirimu yer yüzide apiride bolghandin tartip körüp baqmighan» — dédi-de, burulup Pirewnning aldidin chiqip ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pirewnning emeldarliri uninggha: — Bu adem bizge qachan’ghiche tuzaq bolar? Öz Xudasi Perwerdigargha ibadet qilishqa bu ademlerni qoyup bergeyla! Misirning xarab bolghinini téxiche körmeywatamdila? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Shuning bilen Musa bilen Harun Pirewnning aldigha yene chaqiritip kélindi. U ulargha: — Perwerdigargha ibadet qilish üchün béringlar; lékin baridighanlar zadi kimler? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa jawab bérip: — Yashlirimiz we qéri-chüriler bilen, oghullirimiz we qizlirimiz bilen, qoy we kala padilirimizni élip hemmimiz barimiz; chünki biz Perwerdigar üchün héyt ötküzüshimiz kérek, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","U ulargha: — Silerni bala-chaqanglar bilen qoshup qoyup berginimde, Perwerdigar siler bilen bille bolghay! Mana, aldinglarda balayi’apet turuptu! ");
INSERT INTO uiglat_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Yoqsu, bundaq qilishinglargha bolmaydu! Perwerdigargha ibadet qilishqa peqet aranglardin er kishilerla barsun! Chünki silerning telipinglar del shu emesmidi! — dédi-de, ular Pirewnning aldidin qoghlap chiqirildi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Andin Perwerdigar Musagha: — Misir zéminining üstige qolungni uzatqin. Shundaq qilsang, chéketkiler Misir zéminini bésip, zémindiki herxil otyashlarni, yeni möldürdin aman qalghanning hemmisini yep kétidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa hasisini Misir zéminining üstige uzatti; Perwerdigar shu küni we kéchisi zémin üstige sherq shamili chiqardi. Seherde, sherq shamili chéketkilerni uchurup keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Chéketkiler Misirning pütkül zéminigha yéyilip, Misirning pütün chégrisinimu basti. Apet intayin éghir boldi; ilgiri bundaq chéketke apiti bolup baqmighan, mundin kéyinmu uningdek bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ular pütkül zéminning yüzini qaplidi, yer qarangghuliship ketti; ular möldürdin aman qalghan zémindiki hemme otyashlarni we del-derexlerning barliq méwilirini yep ketti. Shuning bilen pütkül Misir zémini tewesidiki del-derexlerde yaki daladiki gül-giyahlarda héch yéshilliq qalmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Andin Pirewn aldirap-ténep Musa bilen Harunni chaqirtip ulargha: — Men hem Xudayinglar Perwerdigar aldida hem silerning aldinglarda gunah qildim. ");
INSERT INTO uiglat_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Emdi mushu bir qétim gunahimdin ötüp Perwerdigar Xudayinglardin bu ölümni mendin élip kétishini iltija qilishinglarni ötünimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Shuning bilen Musa Pirewnning aldidin chiqip Perwerdigargha iltija qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Shuning bilen Perwerdigar shamalni burap gherb tereptin intayin küchlük boran chiqirip, chéketkilerni uchurup, Qizil Déngizgha gherq qildi; Misirning pütkül teweside bir talmu chéketke qalmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Lékin Perwerdigar Pirewnning könglini qattiq qilip qoyghini üchün u Israillarni qoyup bermidi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Andin Perwerdigar Musagha: — Qolungni asman’gha qaritip uzatqin; shuning bilen qattiq bir qarangghuluq bolidu, hetta adem silisa qoligha tuyulghudek qoyuq qarangghuluq Misir zéminini qaplaydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Andin Musa qolini asman’gha qaritip uzitiwidi, qoyuq bir qarangghuluq Misir zéminini üch kün’giche qaplap turdi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Üch kün’giche biri yene birini körelmes we ya héchkim öz jayidin qozghilalmas boldi; lékin barliq Israillar olturghan jaylarda yoruqluq bar idi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pirewn Musani chaqirtip uninggha: — Bérip, Perwerdigargha ibadet qilinglar. Peqet qoy we kala padiliringlar qalsun; bala-chaqiliringlarnimu élip barsanglar bolidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa jawaben: — Undaqta Xudayimiz Perwerdigargha qurbanliq qilishqa inaqliq qurbanliqi we köydürme qurbanliqigha lazimliq charpaylarni sen bizge béremsen? ");
INSERT INTO uiglat_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Özimizning charpaylirimiz biz bilen birge kétishi kérek, bir tuyiqimu keynide qalsa bolmaydu; chünki Xudayimiz Perwerdigargha ibadet qilishqa qurbanliq qilidighinimizni bulardin tallishimiz lazim. U yerge yétip barmighuche, Perwerdigargha qaysi qurbanliqlar bilen ibadet qilidighinimizni bilmeymiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Lékin Perwerdigar Pirewnning könglini qattiq qildi; u ularni yenila qoyup bermidi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pirewn Musagha: — Aldimdin yoqal! Hézi bol, ikkinchi manga körün’güchi bolma! Chünki yüzümni yene körgen kününg jéningdin ayrilisen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa uninggha: — Rast éytting! Men séning yüzüngni ikkinchi körgüchi bolmaymen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Shuning bilen Perwerdigar Musagha: — Yene bir apetni Pirewnning üstige we Misirning üstige chüshürimen. Andin u silerni bu yerdin kétishke yol qoyidu we u silerni hemme nersiliringlar bilen qoshup qoyup bérip, bu yerdin mutleq qoghlap chiqiridu. ");
INSERT INTO uiglat_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Emdi sen xelqqe tapilap: — Her biringlar, er kishilerning herbiri öz qoshnisidin, ayal kishilerning herbiri öz qoshnisidin kümüsh buyumlarni, altun buyumlarni sorap alsun, dégin, — dédi    ");
INSERT INTO uiglat_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Perwerdigar xelqini misirliqlarning aldida iltipat tapquzdi. Shuningdek Musa dégen bu adem Misir zéminida Pirewnning emeldarlirining neziride bolsun, puqralarning neziride bolsun, nahayiti ulugh zat boldi). ");
INSERT INTO uiglat_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Andin Musa yene: — Perwerdigar mundaq deydu: — «Men yérim kéchide chiqip Misirni kézip chiqimen. ");
INSERT INTO uiglat_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Shu waqitta textte olturuwatqan Pirewnning tunji oghlidin tartip yarghunchaq tartidighan dédekning tunji oghlighiche, shundaqla barliq charpaylarning tunjiliri, yeni Misirdiki barliq tunji jan igiliri ölidu. ");
INSERT INTO uiglat_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Bu sewebtin pütkül Misir zéminida qattiq bir peryad kötürülidu; uningdin ilgiri shundaq peryad bolup baqmighanidi, mundin kéyinmu bundaq peryad anglanmaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Lékin Israillargha, meyli ademliri, meyli haywanatlirigha bolsun, hetta bir tal itmu qawap qoymaydu. Buningdin Perwerdigarning misirliqlar bilen Israilni perqlendüridighanliqini bilisiler». ");
INSERT INTO uiglat_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","— Shuning bilen bu emeldarliringning hemmisi aldimgha kélip, manga tezim qilip: «Sili özliri we silige egeshken barliq qowmliri chiqip kétishkeyla!» dep éytidu, andin chiqip kétimen» — dédi-de, qattiq ghezep bilen Pirewnning aldidin chiqip ketti.    ");
INSERT INTO uiglat_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Perwerdigar Musagha: — Misir zéminida Méning karamet möjizilirimning köplep körsitilishi üchün Pirewn silerge qulaq salmaydu, — dégenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa bilen Harun bu karamet möjizilerning hemmisini Pirewnning aldida körsitip boldi; lékin Perwerdigar Pirewnning könglini qattiq qilip qoyghini üchün u Israillarni uning zéminidin ketkili qoymidi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Perwerdigar Misir yurtida Musa we Harun’gha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Bu ay silerge aylarning ichide béshi, yilning tunji éyi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Siler pütün Israil jamaitige söz qilip: — Bu ayning oninchi küni hemminglar atiliringlarning ailisi boyiche bir qozini élinglar; herbir ailige birdin qoza élinglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Eger melum bir aile bir qozini yep bolalmighudek bolsa, undaqta öy igisi yénidiki qoshnisi bilen birliship adem sanigha qarap bir qoza élinglar; herbir kishining ishtihasigha qarap hésablap muwapiq bir qoza hazirlanglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Herbiringlar tallaydighan qozanglar béjirim, bir yashliq erkek bolsun; qoy yaki öchke padiliridin tallansimu bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Qozini bu ayning on tötinchi künigiche yéninglarda turghuzunglar, — dégin. — Shu küni Israilning pütkül jamaiti tallighan mélini gugumda soysun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Andin ular uning qénidin élip gösh yéyilgen öyning ishikning bash teripige hem ikki yan késhikige sürkep qoysun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ular shu kéchisi göshini otta kawap qilip yésun; uni pétir nan we achchiq-chüchük köktat bilen qoshup yésun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","qet’iy xam yaki suda pishurup yémenglar, belki uni bash, put we ich-qarinliri bilen otta kawap qilip yenglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Uning héchnémisini etige qaldurmanglar. Eger etige éship qalghanliri bolsa, uni otqa sélip köydürüwétinglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Siler uni mundaq halette yenglar: — Uni yégende belliringlarni ching baghlap, ayaghliringlargha kesh kiyip, qolliringlarda hasa tutqan halda téz yenglar. U bolsa Perwerdigarning «ötüp kétish» qozisidur. ");
INSERT INTO uiglat_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Chünki Men u kéchisi Misir zéminini kézip ötimen; Men Misir zéminida meyli insan bolsun, meyli haywan bolsun ularning tunji tughulghan erkikining hemmisini öltürimen; shuning bilen Men Misirning barliq but-ilahlirining üstidin höküm chiqirimen; Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Shu qurbanliqning qéni siler olturghan öylerde silerge nijat belgisi bolidu; bu qanlarni körginimde silerge ötüp turimen. Shuning bilen Misir zéminini urghinimda halaket élip kélidighan waba-apet silerge tegmeydu. ");
INSERT INTO uiglat_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Bu kün silerge xatire kün bolsun; uni Perwerdigarning héyti süpitide ötküzüp tebriklenglar; ebediy belgilime süpitide nesildin-nesilge menggü ötküzünglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yette kün pétir nan yenglar; birinchi küni öyünglardin barliq xémirturuchlarni yoq qilinglar; chünki kimki birinchi kündin tartip yettinchi kün’giche boldurulghan nan yése, shu kishi Israil qataridin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Birinchi küni siler muqeddes ibadet soruni tüzünglar; yettinchi künimu hem shundaq bir muqeddes ibadet soruni ötküzülsun. Bu ikki kün ichide héchqandaq ish-emgek qilinmisun; peqet her kishining yeydighinini teyyarlashqa munasiwetlik ishlarnila qilsanglar bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Men del shu küni silerni qoshun-qoshun boyiche Misir zéminidin chiqarghinim üchün siler pétir nan héytini ötküzünglar; shu künni nesildin-nesilge ebediy belgilime süpitide héyt küni qilip békitinglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Birinchi ayning on tötinchi küni, kechqurundin tartip shu ayning yigirme birinchi küni kechqurun’ghiche, pétir nan yenglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Yette kün ichide öyliringlarda héch xémirturuch bolmisun; chünki musapir bolsun, zéminda tughulghan bolsun, kimki boldurulghan nersilerni yése shu kishi Israil jamaitidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Siler héchqandaq boldurulghan nersini yémey, qeyerdila tursanglar, pétir nan yenglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa Israilning barliq aqsaqallirini chaqirip ulargha: — Bérip herbiringlarning ailisi boyiche özünglargha bir qozini tartip chiqirip pasxa qozisini soyunglar.    ");
INSERT INTO uiglat_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Andin bir tutam zupa élip uni qachidiki qan’gha chilap, qachidiki qanni ishikning béshi we ikki késhikige sürkenglar. Silerdin etigen’giche héchkim öyining ishikidin qet’iy chiqmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Chünki Perwerdigar misirliqlarni urup halak qilish üchün, zéminni kézip ötidu; U ishikning béshi we ikki késhikidiki qanni körgende, Perwerdigar halak qilghuchining öyliringlargha kirip silerni urushidin tosush üchün muhapizet qilip ishikning aldigha ötüp turidu.    ");
INSERT INTO uiglat_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Bu resim-qaidini özünglar we baliliringlar üchün ebediy bir belgilime süpitide tutunglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Siler Perwerdigar Öz wedisi boyiche silerge béridighan zémin’gha kirgininglarda bu héytliq ibadetni tutunglar. ");
INSERT INTO uiglat_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Baliliringlar silerdin: «bu ibaditinglarning menisi néme?» — dep sorisa, ");
INSERT INTO uiglat_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","siler: «Bu misirliqlarni urghinida, Misirda Israillarning öylirining aldigha ötüp turup, bizning öydikilirimizni qutquzghan Perwerdigargha bolghan «ötüp kétish» qurbanliqi bolidu» — denglar. Shuni anglighanda, xelq éngiship Xudagha sejde qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Andin Israillar qaytip bérip, Perwerdigar del Musa bilen Harun’gha emr qilghandek ish kördi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","We shundaq boldiki, yérim kéche bolghanda, Perwerdigar Pirewnning textide olturuwatqan tunjisidin tartip zindanda yétiwatqan mehbusning tunjisighiche, Misir zéminidiki tunji oghullarning hemmisini urup öltürdi, shundaqla u haywanatlarning tunji tughulghanliriningmu hemmisini öltürdi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Adem ölmigen birmu öy qalmighachqa, shu kéchisi Pirewnning özi, uning barliq emeldarliri we barliq misirliqlar kéchide ornidin qopti; Misir zéminida intayin qattiq peryad kötürüldi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pirewn kéchide Musa bilen Harunni chaqirtip: — Turunglar, siler we Israillar bilen bille méning xelqimning arisidin chiqip kétinglar; éytqininglardek bérip, Perwerdigargha ibadet qilinglar! ");
INSERT INTO uiglat_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Silerning dégininglar boyiche qoy, öchke, kala padilirinimu élip kétinglar; men üchünmu bext-beriket tilenglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misirliq puqralarmu «hemmimiz ölüp ketküdekmiz» déyiship, xelqni zémindin téz chiqiriwétish üchün ularni kétishke aldiratti. ");
INSERT INTO uiglat_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Xelq téxi bolmighan xémirlirini élip, uni tengnilerge sélip, kiyim-kéchekliri bilen yögep, mürilirige élip kötürüp méngishti. ");
INSERT INTO uiglat_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israillar Musaning tapilighini boyiche qilip, misirliqlardin kümüsh buyumlar, altun buyumlar we kiyim-kécheklerni sorap élishti. ");
INSERT INTO uiglat_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Perwerdigar xelqni misirliqlarning köz aldida iltipat tapquzghini üchün misirliqlar ularning özliridin sorighanlirini berdi; shundaq qilip Israillar misirliqlardin gheniymetlerni élip ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Shuning bilen Israillar balilarni hésabqa almighanda alte yüz mingche erkek bolup, Ramsestin chiqip, Sukkot shehirigiche piyade mangdi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ular bilen bille chong bir top shalghut xelqmu ulargha qoshulup mangdi, yene nurghun charwilar, köpligen kala-qoy padiliri bilen bille chiqti. ");
INSERT INTO uiglat_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Misirdin alghach chiqqan xémirdin ular pétir nan-toqachlarni etti; chünki ular Misirda birdem-yérim dem turghuzulmay heydelgini üchün xémir bolmighanidi; ular özliri üchün yémeklik teyyarliwélishqimu ülgürelmigenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israillarning Misirda musapir bolup turghan waqti jemiy töt yüz ottuz yil boldi.    ");
INSERT INTO uiglat_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Shundaq boldiki, shu töt yüz ottuz yil toshqanda, del shu künide Perwerdigarning barliq qoshunliri Misir zéminidin chiqip ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Shu küni kéchide ular Misir zéminidin chiqirilghini üchün, shu kéchini ular Perwerdigarning kéchisi dep tutushi kérek; shu kéchini barliq Israillar ewladtin ewladqiche Perwerdigargha atap tutup, tünishi kérek. ");
INSERT INTO uiglat_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Perwerdigar Musa bilen Harun’gha mundaq dégenidi: — Pasxa qozisi toghrisidiki belgilime shu bolsunki: — Héchqandaq yat ellik adem uningdin yémisun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Lékin herkimning pulgha sétiwalghan quli bolsa, u xetne qilinsun, andin uningdin yésun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Emma öyünglarda waqitliq turuwatqan musapir yaki medikar buningdin yése bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Göshni bashqa bir öyge élip chiqmighin; birla öyde yéyilsun; qozining héchbir söngiki sundurulmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Pütkül Israil jamaiti bu héytni ötküzsun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Eger séning bilen birge turghan musapir bolsa, Perwerdigargha atap pasxa héytini ötküzmekchi bolsa, undaqta aldi bilen barliq erkekliri xetne qilinsun; andin kélip héyt ötküzsun. U zéminda tughulghan kishidek sanalsun. Lékin héchbir xetnisiz adem uningdin yémisun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Zéminda tughulghan kishi hem aranglarda turghan musapir üchün oxshash qanun-belgilime bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Shuning bilen Israillarning hemmisi del Perwerdigar Musa bilen Harun’gha buyrughandek shu ishlarni ada qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Shu künning özide Perwerdigar Israillarni qoshun-qoshun boyiche Misir zéminidin chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Perwerdigar Musagha: ");
INSERT INTO uiglat_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","— Israillar arisida baliyatquning barliq tunji erkek méwisini, meyli u insanning yaki haywanning bolsun, Manga atap muqeddes qilghin; u Manga mensuptur, dégenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa xelqke mundaq dédi: — Siler Misirdin ibaret «qulluq makani»din chiqqan bu künni yad étinglar; chünki Perwerdigar silerni bu yerdin qudretlik qoli bilen chiqardi. Buning üchün héch boldurulghan nerse yéyilmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Abib éyining bügünki küni yolgha chiqqan kün.    ");
INSERT INTO uiglat_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Emdi Perwerdigar sanga bérishke ata-bowiliringgha qesem qilghan, süt bilen hesel éqip turidighan zémin’gha, yeni Qanaaniy, Hittiy, Amoriy, Hiwiy we Yebusiylarning zéminigha séni élip barghinida mushu Abib éyida shu ibadetni tutqin. ");
INSERT INTO uiglat_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Yette kün’giche pétir nan yenglar; yettinchi künide Perwerdigargha alahide atighan héyt ötküzülsun. ");
INSERT INTO uiglat_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Yette kün ichide pétir nan yéyilsun; silerning aranglarda héchqandaq boldurulghan nan tépilmisun we ya chégriliring ichide héch xémirturuchmu körünmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Shu küni sen öz oghlunggha: «Misirdin chiqqinimda Perwerdigarning manga körsetken iltipatini yad qilip teshekkur bildürüsh üchün, bu héytni ötküzimen», dep chüshendürgin. ");
INSERT INTO uiglat_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Perwerdigarning qanun-telimining hemishe aghzingdin chüshmesliki üchün, bu belgilimini qolunggha belge qilip séliwal, péshanengge qashqidek esletme qilip ornitiwal; chünki Perwerdigar séni qudretlik qoli bilen Misirdin chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Emdi bu belgilimini yilmu-yil békitilgen waqtida tutqin. ");
INSERT INTO uiglat_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Perwerdigar sen bilen ata-bowiliringgha qilghan qesimi boyiche séni Qanaaniylarning zéminigha élip bérip, uni sanga teqdim qilghandin kéyin, shundaq qilishing kérek: — ");
INSERT INTO uiglat_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","barliq baliyatquning tunji méwisini Perwerdigargha atap sunisen; shundaqla charpay mélingning hemme tunji erkeklirimu Perwerdigargha mensup bolsun.    ");
INSERT INTO uiglat_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Emma ésheklerning hemme tunjilirining ornigha birdin qoza bergin. Eger uning ornigha birnerse bermiseng, uning boynini sunduruwetkin. Oghulliringlar arisida barliq tunjilirining ornigha hörlük bedili tölüshüng kérek. ");
INSERT INTO uiglat_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Kéyinki künlerde oghlung sendin: «buning menisi némidur», dep sorisa, sen uninggha jawab bérip: «Perwerdigar qudretlik qoli bilen bizni Misirdin chiqirip, «qulluq makani»din azad qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Shundaq boldiki, Pirewn boyni qattiqliq qilip bizni qoyup bérishni ret qilghinida, Perwerdigar Misir zéminidiki barliq tunji tughulghanlarni, insanning bolsun, malning bolsun, hemmisini urup öltürdi; buning üchün men malning baliyatqusining tunji méwisini, yeni hemme tunji tughulghan erkeklirini Perwerdigargha atap qurbanliq qilip sunimen we oghullirimning herbir tunjiliri üchün hörlük bedili tölep bérimen», dep éytqin. ");
INSERT INTO uiglat_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Bu belgilimini qolunggha esletme-belge qilip séliwal, péshanengge qashqidek esletme qilip ornitiwal, chünki Perwerdigar qudretlik qoli bilen bizni Misirdin chiqardi» — dégin. ");
INSERT INTO uiglat_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Emma Pirewn xelqni kétishke qoyghandin kéyin, Filistiylerning zéminidiki yol yéqin bolsimu, Xuda ularni shu yol bilen bashlimidi; chünki u: «xelqim jengge uchrap qalsa, qorqup pushayman qilip, Misirgha yénip kétishi mumkin» dep oylighanidi. ");
INSERT INTO uiglat_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Shu sewebtin Xuda xelqni aylandurup, Qizil Déngiz tereptiki chölning yoli bilen bashlap mangdi. Shundaq qilip Israillar Misirdin chiqqinida, qorallinip jengge teyyar bolup tertip bilen mangdi. ");
INSERT INTO uiglat_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa Yüsüpning söngeklirinimu bille éliwaldi; chünki Yüsüp eslide Israilning oghulliri bolghan qérindashlirini: «Xuda choqum silerni yoqlap halinglardin xewer alidu; shu chaghda siler méning söngeklirimni mushu yerdin bille élip kétinglar» dep qesem qildurghanidi.    ");
INSERT INTO uiglat_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Andin ular Sukkottin chiqip, chölning chétidiki Étam dégen yerde chédirlirini tikti. ");
INSERT INTO uiglat_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Emdi Perwerdigar ulargha yol körsitishke kündüzi bir bulut tüwrükide, kéchisi yoruqluq bérishke ot tüwrükide bolup ularning aldida yüretti. Shuning bilen ular kéche-kündüz yol yüreleytti. ");
INSERT INTO uiglat_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Bulut tüwrüki kündüzi, ot tüwrüki kéchisi xelqtin ayrilmay, aldida yüretti. ");
INSERT INTO uiglat_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Perwerdigar Musagha: ");
INSERT INTO uiglat_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","— Sen Israillargha: «Siler burulup Migdol bilen déngizning ariliqidiki Pi-Hahirotning aldigha bérip chédir tikinglar; Baal-Zéfonning udulidiki déngizning boyida chédir tikinglar», dégin.    ");
INSERT INTO uiglat_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Shuning bilen Pirewn: «Israillar zéminda ézip qaldi, chölning ichide qamilip qaldi» dep oylaydu; ");
INSERT INTO uiglat_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Israillarni qoghlisun dep Men Pirewnning könglini qattiq qilimen; shundaq qilip, Men Pirewn we uning pütkül qoshunliri arqiliq Öz ulughluqumni ayan qilimen; we misirliqlar Méning Perwerdigar ikenlikimni bilidu, — dédi. Israillar Xudaning sözi boyiche qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","«U xelq qéchip ketti» dep Misirning padishahigha xewer bériliwidi, Pirewn bilen emeldarliri xelq toghrisidiki qararidin yénip: «Israillarni qulluqtin qoyuwetkinimiz, bu zadi néme qilghinimiz?!» — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pirewn derhal jeng harwisini qoshturup, öz xelqini bashlap yolgha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","U yene alte yüz xillan’ghan jeng harwisi, shundaqla Misirdiki barliq jeng harwilirini yighdurup, ularning herbirige leshker bashliqlirini olturghuzup élip mangdi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Perwerdigar Misirning padishahi Pirewnning könglini qattiq qilghini üchün, u Israillarni qoghlidi. Bu chaghda Israillar qollirini égiz kötürüshken halda Misirdin chiqip bolghanidi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misirliqlarning hemmisi yeni Pirewnning barliq atliri bilen jeng harwiliri, atliq leshkerliri bilen pütkül qoshuni ularni qoghlap, Israillar déngiz boyigha chédir tikken jayda, yeni Pi-Hahirotning yénida, Baal-Zéfonning udulida ulargha yétishti. ");
INSERT INTO uiglat_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Pirewn yéqinlashqanda, Israillar béshini kötürüp qariwidi, mana, misirliqlar ularning arqisidin yürüsh qilip qoghlap kéliwatatti! Shuni körgende Israillar tolimu qorqushup, Perwerdigargha nida-peryad kötürdi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ular Musagha: — Misirda göristan tépilmasmidi, sen bizni chölde ölsun dep mushu yerge élip keldingghu?! Bizni Misirdin élip chiqip, bizge mundaq qilghining némisi?! ");
INSERT INTO uiglat_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Misirda turghan waqtimizda biz sanga: «Bizni misirliqlarning qulluqida bolushimizgha qoyghin, biz bilen karing bolmisun» dep éytmighanmiduq? Misirliqlarning qulluqida bolghinimiz chölge kélip ölginimizdin ewzel bolatti! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Buning bilen Musa xelqqe: — Qorqmay, tik turunglar, Perwerdigarning bügün silerge yürgüzidighan nijatini körisiler; chünki siler bügün körgen misirliqlarni ikkinchi körmeysiler. ");
INSERT INTO uiglat_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Perwerdigar siler üchün jeng qilidu, lékin siler bolsanglar jim tursanglarla boldi, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Andin Perwerdigar Musagha: — Némishqa sen Manga peryad kötürisen? Israillargha: «Aldigha ménginglar» dep buyrughin. ");
INSERT INTO uiglat_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Lékin sen hasangni kötürüp qolungni déngizgha uzitip, uni ikkige bölgin; shundaqta, Israillar déngizning otturisidin quruq yer bilen ötüp kétidu. ");
INSERT INTO uiglat_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mana, Men ularni qoghlisun dep misirliqlarning köngüllirini qattiq qilimen, shuning bilen Men Pirewn we uning pütkül qoshuni, jeng harwiliri we atliqliri arqiliq Öz ulughluqimni ayan qilimen. ");
INSERT INTO uiglat_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Shundaq qilip, Men Pirewn we uning jeng harwiliri we atliqliri arqiliq Öz ulughluqimni ayan qilghinimda, misirliqlar Méning Perwerdigar ikenlikimni bilidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Israilning qoshunining aldida yürüwatqan Xudaning Perishtisi emdi ularning keynige ötti; shuningdek ularning aldida mangghan bulut tüwrükimu ularning keynige yötkilip, ");
INSERT INTO uiglat_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","misirliqlarning chédirgahi bilen Israilning chédirgahining ariliqida toxtidi; bu bulut bir terepte qarangghuluq chüshürüp, yene bir terepte kéchini yorutti. Buning bilen pütün bir kéche bir qoshun yene bir qoshun’gha yéqin kélelmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa qolini déngizning üstige uzatti; Perwerdigar pütün kéche sherqtin küchlük bir shamal chiqirip, déngizning süyini keynige yandurdi; U suni yandurup déngizni quruq yer qildi, sular ikkige bölündi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Shu teriqide Israillar déngizning otturisidiki quruq yerdin méngip, ötüp ketti; sular bolsa ularning ong we sol yénida kötürülüp tamdek turatti.    ");
INSERT INTO uiglat_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Emma misirliqlar ularni qoghlap kéliwatatti — Pirewnning barliq atliri, jeng harwiliri we atliq leshkerliri ularning keynidin déngizning otturisighiche keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Tang atqanda shundaq boldiki, Perwerdigar ot bilen bulut tüwrükide turup misirliqlarning qoshunigha qaridi we misirliqlarning qoshunigha parakendichilik chüshürdi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","U ularning harwilirining chaqlirini patquzup, heydep méngishini müshkül qildi. Misirliqlar: — Yürünglar, Israilning aldidin qachayli, chünki Perwerdigar ular üchün misirliqlargha qarshi jeng qiliwatidu, — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Perwerdigar Musagha: — Sular yénip misirliqlarning üstige, ularning jeng harwilirining üstige we atliqlirining üstige éqip bérip, ularni chöktürüwetsun dep qolungni déngizning üstige uzatqin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa qolini déngizning üstige uzitiwidi, tang atqanda déngizning süyi yene esliy halitige yénip keldi. Qéchiwatqan misirliqlar éqin’gha qarshi yügürüshti, Perwerdigar ularni déngizning otturisida mollaq atquzdi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Su eslige yénip kélip, jeng harwiliri bilen atliqlarni, yeni Israillarning arqidin qoghlap déngizgha kirgen Pirewnning pütkül qoshunini gherq qiliwetti; ulardin birimu saq qalmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Lékin Israillar déngizning otturisidiki quruq yer bilen méngip ötüp ketti; sular ularning ong we sol yénida kötürülüp tamdek turatti. ");
INSERT INTO uiglat_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Shu teriqide Perwerdigar u küni Israillarni misirliqlarning qolidin qutquzdi; Israillar misirliqlarning déngizning boyida ölük yatqinini kördi. ");
INSERT INTO uiglat_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israil xelqi Perwerdigarning misirliqlargha ishletken zor qudritini körüp, Perwerdigardin qorqti; ular Perwerdigargha we uning quli Musagha ishendi. ");
INSERT INTO uiglat_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Shu chaghda Musa bilen Israillar Perwerdigargha medhiye oqup munu küyni éytti: — «Men Perwerdigarni medhiyilep küy éytay, Chünki U karamet ulughluqini körsetti; U at we min’güchini déngizgha tashliwetti.    ");
INSERT INTO uiglat_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Méning küchüm hem méning küyüm Yah Özidur; U manga nijat boldi; U méning Tengrimdur, men Uni ulughlaymen; U méning atamning Xudasidur, men Uni aliy dep medhiyileymen.    ");
INSERT INTO uiglat_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Perwerdigar jengchidur, Yahweh Uning namidur. ");
INSERT INTO uiglat_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Pirewnning jeng harwilirini hem qoshunlirini déngizgha tashliwetti; Uning aliy leshker bashliqliri Qizil Déngizda gherq qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Chongqur sular ularni kömüwetti, Ular xuddi tashtek déngiz tégige chöküp ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Séning ong qolung, ey Perwerdigar, Qudriti bilen shan-sherep tapti; Séning ong qolung, ey Perwerdigar, Düshmenni kukum-talqan qiliwetti. ");
INSERT INTO uiglat_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Öz ulughluqungning heywisi bilen Özüngge qarshi chiqqanlarni nabut qilding, Sen otluq ghezipingni ewetting, U samanni köydürgen ottek ularni yutuwetti. ");
INSERT INTO uiglat_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Dimighingning nepisi bilen sular döng bolup örlidi, Jushqunlighan dolqunlar döng kebi tik turdi, Déngizning otturisidiki chongqur sular qaturup qoyuldi.    ");
INSERT INTO uiglat_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Düshmen dédi: «Men ularni qoghlaymen, yétishimen, olja élip üleshtürimen, Ulardin derdimni chiqirimen, Qilichimni sughurup, öz qolum bilen ularni nabut qilimen». ");
INSERT INTO uiglat_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Lékin Sen nepising bilen püwliding, Déngiz ularni kömüwetti; Ular jushqunluq sularda qoghushundek chöküp ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ilahlarning arisida, ey Perwerdigar, Kim Séning tengdishing bolsun? Pak-muqeddeslik ichide Öz heywitingni körsitidighan, Hemd-medhiyiler arisida dehshetlik turidighan, Möjize-karamet yaritidighan, Sendek kim bolsun? ");
INSERT INTO uiglat_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Sen ong qolungni uzitishing bilen, Yer-zémin ularni yutuwetti. ");
INSERT INTO uiglat_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Lékin Özüngge hemjemet qilip qutquzghan qowmni rehimdilliqing bilen bashlap chiqting; Sen ularni Öz muqeddes makaninggha qudriting bilen hidayet qilip yétekliding. ");
INSERT INTO uiglat_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Yat xelqler buni anglap, titriship ketti; Filistiyede turuwatqanlarni tolghaqtek azab tutti. ");
INSERT INTO uiglat_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Andin Édomning emirliri dekke-dükkige chüshti; Moabning palwanlirini bolsa, rasa titrek basti; Qanaan zéminidikilerning yüriki su bolup aqti; ");
INSERT INTO uiglat_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Qorqunch we dehshet ularni basti; Bilikingning heywiti bilen ular xuddi tashtek midirliyalmay qaldi; Xelqing ötüp ketküche, i Perwerdigar, Özüng rene tölep hör qilghan xelqing ötüp bolghuche.    ");
INSERT INTO uiglat_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ularni bashlap kirip, Öz mirasing bolghan taghda köchettek tikisen, Öz makaning qilghan jaygha, i Perwerdigar, Öz qolliring teyyarlighan muqeddes jaygha, i Reb, ularni élip barisen. ");
INSERT INTO uiglat_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Perwerdigar ebedil’ebedgiche padishah bolup höküm süridu! ");
INSERT INTO uiglat_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Chünki Pirewnning atliri, Jeng harwiliri atliqliri bilen bille déngizgha kirip boldi; Perwerdigar déngizning sulirini ularning üstige yandurdi, Lékin Israillar bolsa déngizning otturisidin quruq yerdin méngip ötüp ketti». ");
INSERT INTO uiglat_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Andin Harunning hedisi peyghember Meryem qoligha dapni aldi, barliq qiz-ayallarmu qoligha dap élip, ussul oyniship uninggha egeshti. ");
INSERT INTO uiglat_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Meryem ulargha jawaben mundaq küyni oqudi: — «Perwerdigarni medhiyilep küy éytinglar, Chünki U zor ulughluqini körsetti; U at we min’güchini déngizgha tashliwetti!». ");
INSERT INTO uiglat_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Andin Musa Israillarni Qizil Déngizdin bashlap, Shur chölige élip bardi. Ular uda üch kün chölde yürüp, su tapalmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Andin ular Marahqa yétip keldi; lékin u yerning süyi achchiq bolup, süyini ichkili bolmaytti; shunga u jayning nami «Marah» dep qoyulghan.    ");
INSERT INTO uiglat_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","U waqitta xalayiq: — Biz néme ichimiz? — dep Musadin aghrinip ghotuldashqili turdi. ");
INSERT INTO uiglat_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","U Perwerdigargha peryad kötürdi; Perwerdigar uninggha bir derexni körsetti; u derex yaghichini élip, sugha tashliwidi, su tatliq sugha aylandi. U yerde Perwerdigar ulargha höküm-belgilime békitip, ularni sinap, mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","«Eger siler köngül qoyup Xudayinglar Perwerdigarning sözini anglap, Uning neziride durus bolghanni qilip, emrlirige qulaq sélip, barliq hökümlirini tutsanglar, undaqta, Men misirliqlarning üstige salghan késellerdin héchbirini üstüngge salmaymen; chünki Menki silerge shipaliq bergüchi Perwerdigardurmen». ");
INSERT INTO uiglat_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Andin ular Élimgha yétip keldi. Shu yerde on ikki bulaq bilen yetmish xorma derixi bar idi; ular shu yerde sularning boyida chédir tikti. ");
INSERT INTO uiglat_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Andin Israillarning pütkül jamaiti Élimdin yolgha atlandi; Misir zéminidin chiqip, ikkinchi éyining on beshinchi künide Élim bilen Sinayning otturisidiki Sin chölige yétip keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Emma Israillarning pütkül jamaiti chölde Musa bilen Harunning yaman gépini qilip ghotuldashqili turdi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israillar ulargha: — Perwerdigarning qoli bizni Misir yurtidila öltürüwetken bolsa bolmasmidi! Shu yerde biz gösh qaynawatqan qazanlarni chöridep olturup, toyghudek nan yémigenmiduq? Lékin siler bu jamaetning hemmisini achliq bilen öltürmekchi bolup bizni bu chölge élip keldinglar! — déyishti.    ");
INSERT INTO uiglat_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Buning bilen Perwerdigar Musagha: — Mana, Men asmandin silerge nan yaghdurimen; shuning bilen xelq her küni chiqip, bir künlük lazimliqini yighiwalsun. Bu teriqide Men ularning Méning qanun-emrlirimde mangidighan-mangmaydighanliqini sinaymen. ");
INSERT INTO uiglat_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Her heptining altinchi küni shundaq boliduki, ular yighiwalghanlirini teyyarlisun; u bashqa künlerde érishidighinidin bir hesse köp bolidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Andin Musa bilen Harun barliq Israillargha: — Bügün axsham silerni Misir zéminidin élip chiqquchining Perwerdigar ikenlikini bilisiler we ");
INSERT INTO uiglat_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ete siler Perwerdigarning shan-sheripini körisiler; chünki U silerning Uning yaman gépini qilip ghotuldashqininglarni anglidi; bizge kelsek, siler yaman gépimizni qilip ghotuldighudek biz kim iduq? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa yene: Perwerdigar bügün axsham silerge yégili gösh bérip, ete etigende toyghudek nan bergende buni bilisiler; chünki Perwerdigar siler Uning yaman gépini qilip ghotuldighininglarni anglidi. Emdi biz néme iduq? Silerning ghotuldashqininglar bizlerge qaritilghan emes, belki Perwerdigargha qaritilghandur, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Andin Musa Harun’gha: — Sen Israillarning pütkül jamaitige: «Perwerdigarning aldigha kélinglar; chünki U yaman gep bilen ghotuldashqininglarni anglidi», dep éytqin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Shundaq boldiki, Harun Israillarning pütkül jamaitige sözlep turghinida, ular chöl terepke qariwidi, mana, Perwerdigarning julasi bulutta ayan boldi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Shuning bilen Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","— Men Israillarning yaman gep qilip ghotuldashqinini anglidim; emdi ulargha: «Gugumda siler gösh yeysiler we etigende nandin toyunisiler, shuning bilen siler Méning Perwerdigar Xudayinglar ikenlikimni bilip yétisiler» — dep éytqin, dédi.    ");
INSERT INTO uiglat_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kechqurunda shundaq boldiki, bödüniler uchup kélip, chédirgahni qaplap ketti; etisi etigende, chédirgahning etrapidiki yerlerge shebnem chüshkenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Etrapta yatqan shebnem kötürülüp ketkendin kéyin, mana, chöllükning yer yüzide qirawdek népiz, kichik-kichik yumilaq nersiler turatti. ");
INSERT INTO uiglat_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israillar uni körgende, uning néme ikenlikini bilmigini üchün: — Bu némidu? — dep sorashti. Musa ulargha jawaben: — Bu Perwerdigar silerge ata qilghan ozuq-tülüktur. ");
INSERT INTO uiglat_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Perwerdigar shu ishni emr qilip dédiki, «Herbiringlar yeydighininglargha qarap uningdin yighiwélinglar; herbiringlar ailidiki adem sanigha qarap, herbir ademge bir omer miqdarda yighinglar; her adem öz chédiridiki kishiler üchün yighinglar» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israillar shundaq qilip, bezisi köprek, bezisi azraq yighiwaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ular uni omer miqdari bilen ölchiwidi, köp yighqanlarningkidin éship ketmidi, az yighqanlarningmu kemlik qilmidi; herbir kishi öz yeydighinigha qarap yighqanidi.    ");
INSERT INTO uiglat_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa ulargha: — Héchqandaq adem bulardin héchnémini etige qaldurmisun, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Shundaq bolsimu, ular Musaning sözige qulaq salmidi; beziler uningdin bir qismini etige saqlap qoydi. Emma saqlap qoyghini qurtlap sésip ketti. Bu ish üchün Musa ulargha xapa bolup achchiqlandi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Shu sewebtin ularning herbiri her etigini chiqip öz yeydighinigha qarap yighiwalatti; qalghanliri bolsa aptap chiqqanda érip kétetti. ");
INSERT INTO uiglat_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Lékin altinchi küni shundaq boldiki, ular künlük ozuqning ikki hessisini yighdi; démek, herbir kishi üchün ikki omer miqdarda yighiwaldi; andin jamaet emirliri hemmisi kélip buni Musagha éytti. ");
INSERT INTO uiglat_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa ulargha: — Mana Perwerdigarning dégini: — Ete aram küni, Perwerdigargha atalghan muqeddes shabat küni bolidu; pishuridighininglarni pishurup, qaynitidighininglarni qayinitip, éship qalghanning hemmisini etige saqlap qoyunglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ular Musa buyrughandek, éship qalghanni etisige saqlap qoyuwidi, ular sésip qalmidi, qurutlapmu ketmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa ulargha: — Buni bügün yenglar; chünki bügün Perwerdigargha atalghan shabat küni bolghini üchün bügün daladin tapalmaysiler. ");
INSERT INTO uiglat_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Alte kün siler yighsanglar bolidu; lékin yettinchi küni shabat bolghini üchün u künide héchnéme tépilmaydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Halbuki, yettinchi küni xelqtin birnechchisi ozuq-tülük yighqili chiqiwidi, héchnéme tapalmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Perwerdigar Musagha: «Siler qachan’ghiche Méning emrlirim we qanun-belgilimilirimni tutushni ret qilisiler? ");
INSERT INTO uiglat_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mana, Perwerdigar silerge shabat künini békitip berdi; shunga yettinchi küni herbiringlarni öz ornida turup, sirtlargha chiqmisun dep, altinchi küni ikki künlük ozuq béridu», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Shuning bilen xelq yettinchi küni aram aldi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israillar bu ozuqni «manna» dep atidi; uning shekli yumghaqsüt uruqidek, renggi aq bolup, temi heselge milen’gen qoturmachqa oxshaytti.    ");
INSERT INTO uiglat_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa ulargha: — Perwerdigarning emri shuki, — Kéyinki ewladliringlargha Men silerni Misirdin élip chiqqanda, Men silerge chölde yéyishke ata qilghan nanni körsitish üchün, uningdin komzekke bir omer toshquzup, ular üchün saqlap qoyunglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa Harun’gha: — Kelgüsi ewladliringlargha körsitishke saqlash üchün bir komzekni élip, uninggha bir omer miqdarda manna sélip, Perwerdigarning huzurida qoyup qoyghin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kéyin, Harun Perwerdigar Musagha buyrughandek komzekni saqlash üchün uni höküm-guwahliq sanduqining aldida qoyup qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Shu teriqide Israillar adem olturaqlashqan bir zémin’gha yétip kelgüche qiriq yil «manna» yédi; ular Qanaan zéminining chégralirigha yetküche manna yédi. ");
INSERT INTO uiglat_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Eyni chaghda bir «omer» «efah»ning ondin birige barawer idi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Andin pütkül Israil jamaiti qopup, Sin chölidin chiqip, Perwerdigarning emri boyiche seper qilip, Refidim dégen yerge kélip chédirlirini tikti. Emma u yerde xelqqe ichkili su yoq idi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Shuning bilen xelq Musa bilen jédelliship: — Bizge ichkili su bergin! — dédi. Lékin Musa ulargha: — Némishqa méning bilen jédellishisiler? Némishqa Perwerdigarni sinaysiler? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Lékin xelq changqap, su telep qilip, Musadin aghrinip ghotuldiship: — Sen némishqa bizni, balilirimizni we mélimizni ussuzluq bilen öltürüshke Misirdin élip kelding? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Shuning bilen Musa Perwerdigargha peryad kötürüp: — Bu xelqni qandaq qilsam bolar?! Ular hélila méni chalma-kések qilishi mumkin! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Perwerdigar Musagha jawaben: — Sen Israilning aqsaqalliridin birnechchisini özüng bilen bille élip chiqip, Nil deryasining süyini urghiningda ishletken hasangni qolunggha élip xelqning aldigha barghin; ");
INSERT INTO uiglat_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mana, Men shu yerde, Horeb téghidiki qoram tashning üstide séning aldingda turimen; sen qoram tashni urghin. Buning bilen uningdin xelqqe ichkili su chiqidu, — dédi. Musa Israilning aqsaqallirining köz aldida shundaq qildi.    ");
INSERT INTO uiglat_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa Israillarning jédelleshkini we ularning «Perwerdigar zadi arimizda barmu-yoqmu?» déyiship Perwerdigarni sinighini üchün, u yerni «Massah» we «Meribah» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Shu chaghda Amalekler kélip Refidimde Israilgha hujum qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa Yeshuagha: Sen özimizdin Amalek bilen jeng qilishqa adem tallighin. Men ete Xudaning hasisini qolumgha élip döngning choqqisida turup turimen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yeshua Musa buyrughinidek qilip, Amalekler bilen jeng qildi. Musa, Harun we Xur döngning choqqisigha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Shundaq boldiki, Musa qolini kötürüp tursa, Israil ghalib kéletti, lékin u qollirini peske chüshürüp tursa, Amalek ghalib kéletti. ");
INSERT INTO uiglat_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Musaning qolliri éghirliship ketti; ular bir tashni élip kélip uning astigha qoydi; u uning üstide olturdi; andin Harun bilen Xur biri bir teripide, biri yene bir teripide uning qollirini yölep turdi; bu teriqide uning qolliri taki kün patquche mezmut turdi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Shundaq qilip, Yeshua Amalek we uning xelqini qilichlap nabut qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Perwerdigar Musagha: — Bir eslime bolsun dep bu ishlarni bir kitabqa yézip qaldurghin, shundaqla shularni Yeshuaning qulaqlirigha oqup ber; chünki Men Amalekning namini asmanlarning astidin, hetta ademlerning ésidinmu mutleq öchürüwétimen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Andin Musa bir qurban’gahni yasap, namini «Perwerdigar tughumdur» dep atidi ");
INSERT INTO uiglat_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","we Musa: — Yahning texti aldida bir qol kötürülüp: — «Perwerdigar ewladtin ewladqiche Amalekke qarshi jeng qilidu» déyilgenidi, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Musaning qéynatisi, yeni Midiyanning kahini Yetro Xudaning Musa üchün hemde Öz xelqi Israil üchün barliq qilghanliri toghruluq anglidi, yeni Perwerdigarning Israilni Misirdin chiqarghanliqidin xewer tapti. ");
INSERT INTO uiglat_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Shuning bilen Musaning qéynatisi Yetro Musaning eslide öz yénigha ewetiwetken ayali Zipporah we uning ikki oghlini élip yolgha chiqti (birinchi oghlining ismi Gershom dep qoyulghanidi; chünki Musa: «men yaqa yurtta musapir bolup turuwatimen» dégenidi.    ");
INSERT INTO uiglat_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Yene birining ismi Eliézer dep qoyulghanidi; chünki Musa: «Atamning Xudasi manga yardemde bolup, méni Pirewnning qilichidin qutquzdi», dégenidi). ");
INSERT INTO uiglat_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Shundaq qilip Musaning qéynatisi Yetro Musaning oghulliri bilen ayalini élip, Musaning chölde, Xudaning téghining yénida chédir tikken yérige yétip keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","U eslide Musagha: — «Mana, menki qéynatang Yetro séning ayalingni we uning ikki oghlini élip yéninggha kétiwatimen» dep xewer ewetkenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Shuning bilen Musa öz qéynatisining aldigha chiqip, tezim qilip, uni söydi. Ular bir-biridin hal-ehwal soriship chédirgha kirdi; ");
INSERT INTO uiglat_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Andin Musa qiynatisigha Israilning wejidin Perwerdigarning Pirewn we misirliqlargha qilghan hemme emellirini sözlep, ularning yol boyi béshigha chüshken jebir-japalarni bayan qilip, Perwerdigarning qandaq qilip ularni qutquzghinini éytip berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Buni anglap Yetro Perwerdigarning Israilgha körsetken barliq yaxshiliqidin, ularni misirliqlarning qolidin qutquzghanliqidin shadlandi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetro shadlinip: — Silerni misirliqlarning we Pirewnning qolidin qutquzghan Perwerdigargha teshekkurler bolghay! U bu qowmni misirliqlarning qolidin qutquzdi! ");
INSERT INTO uiglat_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Men Perwerdigarning barliq ilahlardin üstün turidighanliqini emdi bildim; chünki U del ular yoghanchiliq qilghan ishta Özining ulardin üstün turidighanliqini namayan qildi — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Andin Musaning qéynatisi Yetro Xudagha atap bir köydürme qurbanliq we birnechche teshekkur qurbanliqlirini élip keldi; Harun bilen Israilning herbir aqsaqili Musaning qéynatisi bilen bille Xudaning huzurida taam yéyishke keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Etisi Musa xelqning ish-dewaliri üstidin höküm chiqirishqa olturdi; xelq etigendin tartip kechkiche Musaning chöriside turushti. ");
INSERT INTO uiglat_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Musaning qéynatisi uning xelqi üchün qilghan ishlirini körgende uningdin: — Séning xelqqe qiliwatqan bu ishing zadi néme ish? Némishqa sen bu ishta yalghuz olturisen, barliq xelq néme üchün etigendin kechkiche séning chörengde turidu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa qéynatisigha jawab bérip: — Xelq Xudadin yol izdeshke méning qéshimgha kélidu. ");
INSERT INTO uiglat_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Qachanki ularning bir ish-dewasi chiqsa ular yénimgha kélidu; shuning bilen men ularning otturisida höküm chiqirimen we shundaqla Xudaning qanun-belgilimilirini ulargha bildürimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Musaning qéynatisi uninggha: — Bu qilghining yaxshi bolmaptu. ");
INSERT INTO uiglat_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Sen jezmen özüngni hemde chörengde turghan xelqnimu charchitip qoyisen; chünki bu ish sanga bek éghir kélidu. Sen uni yalghuz qilip yétishelmeysen. ");
INSERT INTO uiglat_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Emdi méning sözümge qulaq salghin, men sanga bir meslihet bérey we shundaq qilsang, Xuda séning bilen bille bolidu: — Sen özüng Xudaning aldida xelqning wekili bolup, ularning ishlirini Xudagha melum qilghin; ");
INSERT INTO uiglat_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","sen xelqqe qanun-belgilimilerni ögitip, mangidighan yolni körsitip, ularning qandaq burchi barliqini uqturghin. ");
INSERT INTO uiglat_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Shuning bilen bir waqitta sen pütkül xelqning arisidin Xudadin qorqidighan, nepsaniyetchilikni yaman köridighan hem qabiliyetlik hem diyanetlik ademlerni tépip, ularni xelqning üstige bash qilip, bezisini mingbéshi, bezisini yüzbéshi, bezisini ellikbéshi, bezisini onbéshi qilip teyinligin. ");
INSERT INTO uiglat_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Shuning bilen bular herqandaq waqitta xelqning ish-dewalirini soraydu. Eger chong bir ish-dewa chiqip qalsa, buni sanga tapshursun; lékin hemme kichik ish-dewalarni ular özliri béjirisun. Shundaq qilip, ular séning wezipengni yéniklitip, yüküngni kötürüshüp béridu. ");
INSERT INTO uiglat_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Eger shundaq qilsang we Xuda sanga shundaq buyrusa, özüng wezipengde put tirep turalaysen we xelqingmu xatirjemlik bilen öz jayigha qaytip kétidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa qéynatisining sözige qulaq sélip déginining hemmisini qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa pütkül Israil arisidin qabiliyetlik ademlerni tallap, ularni xelqning üstige bash qilip, bezisini mingbéshi, bezisini yüzbéshi, bezisini ellikbéshi, bezisini onbéshi qilip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Bular herqandaq waqitta xelqning ish-dewalirini sorap turdi; tesrek ish-dewalarni bolsa, Musagha yollaytti, kichik ish-dewalarni bolsa özliri soraytti. ");
INSERT INTO uiglat_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Andin Musa qéynatisini yolgha sélip qoydi, u öz yurtigha qaytip ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israillar Misir zéminidin chiqip, del üchinchi éyining bashlan’ghan küni Sinay chölige yétip keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ular Refidimdin chiqip, Sinay chölige yétip kélip, chölde chédir tikti; Israil shu yerde, taghning udulida toxtap chédir tikti. ");
INSERT INTO uiglat_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa Xudaning aldigha chiqiwidi, Perwerdigar taghdin uninggha xitab qilip mundaq dédi: — Sen Yaqupning jemetige söz qilip, Israillargha munu xewerni yetküzgin: — ");
INSERT INTO uiglat_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","«Méning misirliqlargha néme qilghinimni, shundaqla Men silerni xuddi bürküt balilirini qanatlirigha mindürüp élip yürgendek, Öz qéshimgha élip kelginimni özünglar kördünglar.    ");
INSERT INTO uiglat_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Emdi siler derheqiqet Méning sözümni anglap, ehdemni tutsanglar, undaqta barliq ellerning arisida Manga xas bir göher bolisiler — chünki pütkül yer Méningkidur — ");
INSERT INTO uiglat_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","we siler Manga kahinlardin terkib tapqan xas bir padishahliq we muqeddes bir qowm bolisiler». Mana bu sen Israillargha déyishing kérek bolghan sözlerdur, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Shuning bilen Musa yénip kélip, xelqning aqsaqallirini chaqirtip, Perwerdigar uninggha buyrughan shu sözlerning hemmisini ulargha yetküzdi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Xelqning hemmisi bir éghizdin: — Perwerdigar buyrughanning hemmisige choqum emel qilimiz! — dep jawab berdi. Andin Musa xelqning jawab sözlirini Perwerdigarning qéshigha bérip yetküzdi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Perwerdigar Musagha: — Mana, Men sanga söz qilghinimda xelq awazimni anglisun, hemishe sanga ishensun dep, yéninggha qara bulutning qarangghuluqi ichide kélimen, dep éytti. Musamu xelqning dégenlirini Perwerdigargha anglatti. ");
INSERT INTO uiglat_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Perwerdigar Musagha yene: — Sen xelqning qéshigha bérip, bügün we ete ularni pak-muqeddes qilip, kiyim-kécheklirini yudurghin. ");
INSERT INTO uiglat_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ular üchinchi künige teyyar tursun; chünki üchinchi küni barliq xelqning köz aldida Perwerdigar Sinay téghigha chüshidu. ");
INSERT INTO uiglat_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Sen xelq üchün taghning etrapigha bir pasil qilip, ulargha: «Siler éhtiyat qilinglar, taghqa chiqmanglar yaki uning étikige tégip ketmenglar. Kimki taghqa tegse öltürülmey qalmaydu;    ");
INSERT INTO uiglat_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Uninggha hetta birer qoli tégip ketsimu, chalma-kések qilip öltürülsun yaki oq étip öltürülsun. Meyli haywan yaki insan bolsun, shundaq qilsa, tirik qaldurulmisun» — dep éytqin. Lékin Kanay uzun chélinsa, ular taghning tüwige chiqsun, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa taghdin chüshüp xelqning qéshigha bérip, xelqni Xudagha atap muqeddes qildi; ular kiyim-kécheklirini yudi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Andin Musa xelqqe: — Üchinchi künige teyyar turunglar; héchkim ayali bilen yéqinchiliq qilmisun, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Üchinchi küni bolghanda, tang yorushi bilen shundaq boldiki, güldürmamilar güldürlep, chaqmaq chéqip, tagh üstide qoyuq bir parche bulut peyda boldi, zor qattiq chélin’ghan kanayning awazi anglandi. Buni körüp chédirgahdiki pütkül xelq qorqunchidin titrep ketti.    ");
INSERT INTO uiglat_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa xelqni Xudaning aldida hazir bolushqa chédirgahdin élip chiqti. Ular kélip taghning tüwide öre turdi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Perwerdigar Sinay téghigha otta chüshüp kelgini üchün is-tütek pütkül taghni qaplidi; is-tütek xumdandin örligen is-tütektek üstige örlep chiqti. Pütkül tagh qattiq tewrinishke bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kanay awazi barghanséri küchiyip intayin qattiq chiqti. Musa söz qiliwidi, Xuda anglap ünlük awaz bilen jawab berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Perwerdigar Özi Sinay téghigha, taghning choqqisigha chüshti; andin Perwerdigar Musani taghning choqqisigha chaqiriwidi, Musa taghqa chiqti. ");
INSERT INTO uiglat_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Perwerdigar Musagha: — Sen chüshüp xalayiqni agahlandurup: Ular «Perwerdigarni körimiz» dep pasildin bösüp ötmisun; undaq qilsa, ulardin köp adem halak bolidu, dep éytqin. ");
INSERT INTO uiglat_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Perwerdigargha yéqin kéleleydighan kahinlarmu özlirini Manga atap muqeddes qilsun; bolmisa, Perwerdigar sépilni böskendek ulargha halaket yetküzidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa Perwerdigargha: — Xalayiqning Sinay téghigha chiqishi mumkin emes; chünki Sen Özüng bizge qattiq agahlandurdung: taghni «muqeddes» dep qarap, uning etrapigha pasillarni békitinglar, dep emr qilding, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Perwerdigar Musagha: — Mang, sen chüshüp ketkin. Andin sen Harunni élip, bille chiqqin; lékin kahinlar we xelq bolsa Perwerdigarning qéshigha barayli dep pasildin bösüp ötmisun; bolmisa, Perwerdigar sépilni böskendek ularning üstige chüshidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Shuning bilen Musa xelqning qéshigha chüshüp, ulargha bu sözni yetküzdi. ");
INSERT INTO uiglat_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Xuda munu barliq sözlerni bayan qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Men séni «qulluq makani» bolghan Misir zéminidin chiqirip kelgen Perwerdigar Xudayingdurmen. ");
INSERT INTO uiglat_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Séning Mendin bashqa héchqandaq ilahing bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Sen özüng üchün meyli yuqiridiki asmanda bolsun, meyli töwendiki zéminda bolsun, yaki yer astidiki sularda bolsun, herqandaq nersining qiyapitidiki héchqandaq oyma shekilni yasima.    ");
INSERT INTO uiglat_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Sen bundaq nersilerge bash urma yaki ularning qulluqigha kirme. Chünki Menki Perwerdigar Xudaying wapasizliqqa heset qilghuchi Tengridurmen. Mendin nepretlen’genlerning qebihliklirini özlirige, oghullirigha, hetta newre-chewrilirigiche chüshürimen, ");
INSERT INTO uiglat_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Emma Méni söyidighan we emrlirimni tutidighanlargha ming ewladighiche özgermes méhribanliq körsitimen. ");
INSERT INTO uiglat_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Perwerdigar Xudayingning namini qalaymiqan tilgha alma; chünki kimdekim namini qalaymiqan tilgha alsa, Perwerdigar uni gunahkar hésablimay qalmaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Shabat künini muqeddes dep bilip tutqili yadingda saqlighin. ");
INSERT INTO uiglat_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Alte kün ishlep barliq ishliringni tügetkin; ");
INSERT INTO uiglat_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","lékin yettinchi küni Perwerdigar Xudayinggha atalghan shabat künidur; sen shu küni héchqandaq ish qilmaysen; meyli sen yaki oghlung bolsun, meyli qizing, meyli qulung, meyli dédiking, meyli buqang yaki sen bilen bir yerde turuwatqan musapir bolsun, héchqandaq ish qilmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Chünki alte kün ichide Perwerdigar asman bilen zéminni, déngiz bilen uning ichidiki barini yaratti andin yettinchi künide aram aldi. Buning üchün Perwerdigar shabat künini bext-beriketlik kün qilip, uni muqeddes kün dep békitti. ");
INSERT INTO uiglat_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ata-anangni hörmet qil. Shundaq qilsang Perwerdigar Xudaying sanga ata qilmaqchi bolghan zéminda uzun ömür körisen. ");
INSERT INTO uiglat_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Qatilliq qilma. ");
INSERT INTO uiglat_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Zina qilma. ");
INSERT INTO uiglat_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Oghriliq qilma. ");
INSERT INTO uiglat_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Qoshnang toghruluq yalghan guwahliq berme. ");
INSERT INTO uiglat_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Sen qoshnangning öy-imaritige köz qiringni salma, ne qoshnangning ayali, ne uning quligha, ne uning dédiki, ne uning kalisi, ne uning ishiki yaki qoshnangning herqandaq bashqa nersisige köz qiringni salma.    ");
INSERT INTO uiglat_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Pütkül xelq güldürmamilarni, chéqin-yalqunlarni, kanayning awazi we taghdin örlep chiqqan is-tüteklerni kördi we anglidi; ular bularni körüp, titriship yiraq turushti ");
INSERT INTO uiglat_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","we Musagha: — Bizge senla söz qilghaysen, biz anglaymiz; lékin Xuda bizge Özi söz qilmisun; chünki undaq qilsa ölüp kétimiz, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa xalayiqqa jawaben: — Qorqmanglar; chünki Xudaning bu yerge kélishi silerni sinash üchün, yeni silerning Uning dehshetlikini köz aldinglargha keltürüp, gunah qilmasliqinglar üchündur, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Shuning bilen xalayiq nérida turdi; lékin Musa Xuda ichide turghan qoyuq bulutning qéshigha yéqin bardi. ");
INSERT INTO uiglat_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Perwerdigar Musagha: — Sen bérip Israillargha munu sözlerni yetküzgin: «Silerge ershtin söz qilghinimni kördünglar. ");
INSERT INTO uiglat_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Siler Méning ornumda ilah dep kümüshtin butlar yasimanglar, yaki özünglar üchün altundin butlarni yasimanglar. ");
INSERT INTO uiglat_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","— Sen Men üchün tupraqtin bir qurban’gah yasap, shu yerde köydürme qurbanliq we inaqliq qurbanliqliringni, qoy-öchke bilen kaliliringni sun’ghin. Omumen Men xelqqe namimni hörmet bilen eslitidighan barliq jaylarda, yéninggha kélip sanga bext-beriket ata qilimen. ");
INSERT INTO uiglat_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","— Eger Manga atap tashlardin qurban’gah yasimaqchi bolsang, yonulghan tashlardin yasimighin; chünki tashlargha eswabingni tegküzseng, ular napak bolup qalidu.    ");
INSERT INTO uiglat_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Qurban’gahimgha chiqidighan pelempey bolmisun; undaq bolghanda, pelempeydin chiqquche ewriting körünüp qélishi mumkin», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","— Sen ularning aldigha qoyidighan höküm-belgilimiler munulardur: — ");
INSERT INTO uiglat_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Eger sen bir ibraniy qulni sétiwalghan bolsang, u alte yilghiche xizmitingde bolup, yettinchi yili tölemsiz hör qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","U qul qilinishqa tenha halette élip kélin’gen bolsa, tenha halette ketsun. Ayali bilen birge élip kélin’gen bolsa, ayalimu uning bilen bille ketsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Eger xojisi uninggha xotun élip bergen bolsa, shundaqla ayali uninggha oghul-qizlarni tughup bergen bolsa, ayal baliliri bilen xojisigha qélip, er yalghuz ketsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Lékin eger qul élan qilip: «Men xojam, ayalim we balilirimgha muhebbitim bolghini üchün hör bolup ketmeymen» dése, ");
INSERT INTO uiglat_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","undaqta uning xojisi uni Xudaning ibadet sorunining aldigha élip bérip, uni ishikning aldida yaki ishikning késhikining aldida turghuzsun; andin xojisi bigiz bilen uning quliqini teshsun. Shundaq qilip, u menggüge xojisining quli bolup qalidu. ");
INSERT INTO uiglat_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Eger birkim qizini dédeklikke sétiwetken bolsa, u er qullar hör qilin’ghandek hör qilinmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Eger özige xas sétiwalghan qiz xojisigha yaqmisa, undaqta u qiz terepning heq tölep uni hör qilishigha yol qoyushi kérek. Lékin xojisining uni yat xelqqe sétish hoquqi bolmaydu; chünki xojisi uninggha wapasizliq qilghandur. ");
INSERT INTO uiglat_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Eger u qizni oghligha xas békitken bolsa, undaqta u belgilimiler boyiche uninggha öz qizidek muamile qilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Eger xojisi yene xotun alsa, eslide emrige alghan dédikining yémek-ichmikini, kiyim-kéchikini we er-xotunchiliq burchini kémeytmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Eger u shu üch ishni ada qilmisa, undaqta u bedel tölimey hör bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kimki bir ademni urup öltürüp qoysa, umu choqum öltürülsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Lékin eger u kishi ölgüchining jénini paylap turup qesten öltürmigen, belki men Xuda uning qoli arqiliq shu kishining ölüshige yol qoyghan bolsam, undaq ehwalda Men uninggha qachidighan bir jayni orunlashturimen. ");
INSERT INTO uiglat_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Lékin eger birsi öz qoshnisini hiyle bilen öltürimen dep, uninggha qesten hujum qilsa, u gerche panah izdep qurban’gahimgha qéchip kelsimu, u shu yerde tutulsun we ölümge mehkum qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Kimki öz atisi yaki anisigha qol tegküzse, choqum öltürülsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Kimki bir ademni bulap satqan bolsa yaki uning qolida barliqi melum bolsa, jezmen öltürülüshi kérek. ");
INSERT INTO uiglat_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Kimki öz atisi yaki anisigha lenet qilip qarghighan bolsa, jezmen öltürülüshi kérek. ");
INSERT INTO uiglat_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Eger ikki kishi urushup qélip, biri yene birini tash ya moshti bilen ursa, urulghan kishi ölmey, orun tutup yétip qalghan bolsa, ");
INSERT INTO uiglat_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","u kishi qopup hasigha tayinip tashqirigha chiqqudek bolsa, undaqta uni urghan kishi jazadin xalas qilinsun; peqet zeximlen’güchining yétip ishtin qalghan waqti üchün tölem bérip, uni dawalitip sellimaza saqaytsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Eger birsi quli yaki dédikini tayaqta ursa, shundaqla qul yaki dédek neq meydanda ölüp ketse, uning üchün igisi choqum jazagha tartilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Lékin eger tayaq yégüchi bir-ikki kün tirik tursa, undaqta qul xojayinining shexsi mal-mülki bolghini üchün, qulning jazasigha tartilmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Eger kishiler bir-biri bilen urushup qélip, hamilidar bir ayalni urup salsa, hamilidar ayalda balisi baldur tughulushidin bashqa zeximlinish bolmisa, ayalning érining tölem telipi boyiche hakimlarning testiqidin ötküzülüp jerimane tölisun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Eger ayal yaki bala ziyan-zexetke uchrighan bolsa, undaqta jénigha jan, ");
INSERT INTO uiglat_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","közige köz, chishigha chish, qoligha qol, putigha put, ");
INSERT INTO uiglat_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","köyükke köyük, zeximge zexim, kökke kök tölensun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Eger birsi öz qul ya dédikining közini urup nakar qilip qoysa, közi wejidin uni azad qilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Shuningdek birsi öz quli ya dédikining chishini urup chiqiriwetken bolsa, chishi wejidin uni azad qilsun». ");
INSERT INTO uiglat_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Eger bir kala bir er yaki ayal kishini üsüp öltürüp qoysa, shu kala choqum chalma-kések qilinishi kérek, uning göshi yéyilmisun. Lékin kalining igisige gunah kelmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Lékin bu uyning ilgiridin üsüsh aditi bolup, igisige bu heqte agah bérilgen bolsa, lékin yenila uni baghlimighini üchün er-ayal kishilerni üsüp öltürüp qoyghan bolsa, undaqta kala chalma-kések qilinsun, igisimu ölümge mehkum qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Lékin uningdin xun heqqi telep qilinsa, öz jénining ornida uninggha qanchilik tölem qoyulghan bolsa shuni bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kalidin üsülgüchi oghul yaki qiz bala bolsa, kalining igisi oxshashla yuqiriqi hökümdikidek bir terep qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kala qul yaki dédekni üsken bolsa, kalining igisi üsülgüchining xojisigha ottuz shekel kümüsh bersun; andin kala chalma-kések qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Eger birsi bir orining aghzini ochuq qoyup yaki kolawatqan orining aghzini yapmay, kala yaki éshek uninggha chüshüp ketse, ");
INSERT INTO uiglat_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Undaqta orining igisi mal igisining ziyinini toluq tölep bersun; ölgen mal uningki bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Eger birsining kalisi yene birsining kalisini üsüp öltürüp qoyghan bolsa, undaqta ular tirik qalghan kalini sétip, pulni barawer bölüshsun hem ölük kalinimu shundaq bölüshsun. ");
INSERT INTO uiglat_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Lékin kalining ilgiridin üsidighan aditi barliqi éniq turup, igisi uni baghlimay qoyuwetken bolsa, undaqta üsküchi kalining igisi kaligha kala tölep bersun, ölük kala uning bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Eger birsi bir kala yaki qoyni oghrilap, uni soysa ya sétiwetse, u bir kalining ornigha besh kala, bir qoyning ornigha töt qoy tölisun.    ");
INSERT INTO uiglat_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Oghri tam teshkende tutulup qélip, tayaq yep ölüp qalsa, öltürgüchige xun jazasi kelmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Lékin shu weqe bolghan peytte kün chiqip qalghan bolsa, undaqta öltürgüchi xun jazasigha tartilsun. Oghri oghrilighinini tölep ziyanni toluqlap bérishi kérek; uningda bir néme bolmisa, qulluqqa sétilip, oghrilighan nersini tölishi kérek. ");
INSERT INTO uiglat_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Oghri tutulghanda oghrilighan nerse, kala bolsun, éshek bolsun, qoy bolsun uning qolida tirik halette tépilsa, u ikki hesse qimmette tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Eger birsi öz mal-charwilirini étizliqqa yaki üzümzarliqqa otlashqa qoyuwétip, bashqilarning bagh-étizliqida otlashqa yol qoysa, undaqta u özining eng ésil mehsulatliridin yaki üzümzarliqining eng ésil méwisidin ziyanni tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Eger ot kétip, tikenlikke tutiship kétip, andin önchilerni, bash tartip pishqan ziraetni köydürüp, pütkül étizliqni kül qiliwetse, undaqta ot qoyghuchi barliq ziyanni tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Eger birsi qoshnisigha pul yaki mal-dunyasini amanet qilghan bolsa, bular öyidin oghrilinip ketse, shundaqla oghri kéyin tutulsa, u oghrilighinini ikki hesse qimmette tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Lékin oghri tépilmisa, öy igisining qoshnisining méligha qol tegküzgen ya tegküzmigenliki melum bolsun dep, hakimlarning aldigha keltürülsun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Herxil xiyanet, u meyli kala, éshek, qoy, kiyim-kéchek bolsun, yittürüp qoyghan nerse bolsun, ular toghruluq bir qoshnisi: «emeliyette mundaq idi» dep talashqan bolsa, her ikkisining dewasi hakimlarning aldigha keltürülsun; hakimlar qaysigha gunah békitse, shu qoshnisigha ikki hesse qimmette tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Eger birsi qoshnisigha éshek, kala, qoy yaki bashqa bir charpayni amanet qilsa, bu amanet méli kishi körmey ölüp ketse, yaki zeximlense, yaki heydep ekitilse, ");
INSERT INTO uiglat_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","undaqta qoshnisining méligha qol tegküzgen ya tegküzmigenliki melum bolsun dep, Perwerdigarning aldida ularning otturisida bir qesem ichürülsun. Mal igisi bu qesemni qobul qilsun; qoshnisi uninggha tölem tölep bermisun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Lékin mal oghrilan’ghan bolsa, u igisige tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Eger uni wehshiy haywan boghup qoyghan bolsa, u malning qalduqini guwahliq üchün körsitip, uni tölep bermisimu bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Eger birsi qoshnisidin bir ulaghni ötne élip, ulagh igisi yoq yerde zeximlense yaki ölüp qalsa, ötne alghuchi toluq tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Lékin igisi neq meydanda bolsa, ötne alghuchi tölep bermisun; ulagh ijarige élin’ghan bolsa, alghuchi tölem tölimisun; chünki uni ijare tölep ekelgen. ");
INSERT INTO uiglat_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Eger bir adem téxi yatliq bolmighan bir qizni azdurup, uning bilen bille yatsa, undaqta u uning toyluqini bérishi kérek, andin uni xotunluqqa alsun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Lékin qizning atisi uni uninggha bergili unimisa, zina qilghuchi pak qizlarning toyluqigha barawer kélidighan kümüsh pulni tarazida ölchep bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Jaduger xotunni tirik qoymighin. ");
INSERT INTO uiglat_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Haywan bilen jinsiy munasiwet ötküzgen herbiri jezmen ölümge mehkum qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Kimdekim birdinbir Perwerdigardin bashqa herqandaq ilahqa qurbanliq sunsa, haram dep mutleq halaketke mehkum qilinsun.    ");
INSERT INTO uiglat_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Silermu Misirda musapir bolup turghanikensiler, musapir bolghan kishini héch xarlimanglar we yaki uninggha héch zulum qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Herqandaq tul xotun yaki yétim balini xorlimanglar. ");
INSERT INTO uiglat_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Sen ularni herqandaq terepte xorlisang, ular manga peryad kötürse, Men ularning awazini choqum anglaymen; ");
INSERT INTO uiglat_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","shuning bilen ghezipim tutiship, silerni qilichlap öltürimen, silerning xotunliringlar tul qilinip, baliliringlar yétim bolup qalidu. ");
INSERT INTO uiglat_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Eger sen Méning xelqimning ichidin sanga qoshna bolghan kembeghelge qerz bergen bolsang, uninggha jazanixorlardek muamile qilmighin; uningdin ösüm almanglar. ");
INSERT INTO uiglat_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Eger sen qoshnangning chapinini görüge alghan bolsang, kün olturmasta uninggha yandurup ber. ");
INSERT INTO uiglat_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Chünki chapini uning birdinbir yépinchisi bolup, bedinini yapidighan kiyim shudur. U bolmisa, u némini yépinip yatidu? Bu sewebtin Manga peryad qilsa, peryadini anglaymen; chünki Men shepqetlikturmen. ");
INSERT INTO uiglat_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Hakimlargha kupurluq qilma, we xelqingning emirlirinimu qarghap tillima.    ");
INSERT INTO uiglat_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Xaminingning hosulining ashqinidin we sharab-zeytun méyi kölchikingdin tashqinidin Manga hediye sunushni hayal qilmighin. Sen oghulliringning tunjisini Manga atighin.    ");
INSERT INTO uiglat_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Kala bilen qoyliringning tunji balilirinimu hem shundaq atighin; tunji bala yette kün’giche anisi bilen bille tursun; emma sekkizinchi küni uni Manga atap sun’ghin. ");
INSERT INTO uiglat_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Siler Manga atalghan muqeddes kishiler bolisiler; shunga dalada yirtquch haywan teripidin boghulghan haywanning göshini yémenglar, belki uni itlargha tashlap béringlar. ");
INSERT INTO uiglat_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Yalghan gepni yaymighin we ya yalghan guwahliq bérip rezil ademge yan basmighin. ");
INSERT INTO uiglat_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Topqa egiship rezil ishta bolma yaki dewa-desturlarda guwahliq bergende topqa egiship heqiqetni burmilima. ");
INSERT INTO uiglat_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kembeghel dewa qilsa, uninggha yan basma. ");
INSERT INTO uiglat_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Düshminingning kala ya éshiki ézip kétip, sanga uchrap qalsa, uni élip kélip, igisige choqum tapshurup ber. ");
INSERT INTO uiglat_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Eger sanga öch bolghanning éshiki yükni kötürelmey yükning astida yatqinini körseng, uni yardemsiz tashlimay, belki uninggha yardemliship éshikini qopurushup bérishing zörür. ");
INSERT INTO uiglat_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Arangdiki kembeghelning dewasida adaletni burmilima. ");
INSERT INTO uiglat_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Herqandaq saxta ishtin özüngni néri tart; bigunah adem bilen heqqaniy ademni öltürmigin; chünki Men rezil ademni hergiz adil dep aqlimaymen. ");
INSERT INTO uiglat_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Shuningdek héchqandaq para yéme; chünki para közi ochuqlarni kor qilip, heqqaniylarning sözlirini burmilaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Musapir kishilerge zulum qilma; chünki özünglar Misir zéminida musapir bolup turghan bolghachqa, musapirning rohiy halini bilisiler. ");
INSERT INTO uiglat_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Alte yil öz yéringni térip, hosullirini al. ");
INSERT INTO uiglat_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Lékin yettinchi yili yerge aram bérip uni bosh qoy; xelqingning namratliri uningdin yighip yésun, ulardin ashqinini janggaldiki haywanlar yésun; shundaqla üzümzarliqing bilen zeytunzarliqingnimu shundaq qilghin.    ");
INSERT INTO uiglat_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Alte kün ichide öz ishingni ada qilip, yettinchi küni aram élishing zörür. Buning bilen kala-éshekliring aram tapidu, dédikingning oghli bilen musapir kishimu harduqini chiqiridu. ");
INSERT INTO uiglat_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Men sanga éytqinimning hemmisini köngül bölüp ada qil; bashqa ilahlarning namini tilinggha alma; bular hetta aghzingghimu chiqmisun.    ");
INSERT INTO uiglat_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Her yilda üch qétim méning üchün héyt ötküzgin. ");
INSERT INTO uiglat_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Aldi bilen «pétir nan héyti»ni ötküz; sanga emr qilghinimdek Abib éyidiki békitilgen künlerde yette kün pétir nan yégin; chünki shu ayda sen Misirdin chiqqaniding. Shu héytta héchkishi aldimgha quruq qol kelmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Sen ejir qilip térighan étizdiki ziraitingning tunji hosulini orghanda «orma héyti»ni ötküz; shundaqla sen ejir singdürüp yerdin axirqi hosul-mehsulatliringni yil axirida yighqanda «hosul yighish héyti»ni ötküz. ");
INSERT INTO uiglat_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Yilda üch qétim erkekliringning hemmisi Reb Perwerdigarning huzurigha hazir bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Sen manga atalghan qurbanliqning qénini xémirturuch sélin’ghan nan bilen sunmighin; héyt qurbanliqining yéghini bolsa kéchiche qondurup etigichige saqlima. ");
INSERT INTO uiglat_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Zéminingdiki deslepki hosulning eng yaxshsini Perwerdigar Xudayingning öyige élip kel. Oghlaqni anisining sütide qaynitip pishurma.    ");
INSERT INTO uiglat_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Mana, Men bir Perishtini yolda séni qoghdap, Men sanga teyyarlighan yerge élip barsun dep, aldingda yürüshke ewetimen. ");
INSERT INTO uiglat_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Sen uning aldida özüngge agah bol, uning awazigha qulaq sal. Uning zitigha tegme; bolmisa, u itaetsizlikliringni kechürmeydu; chünki Méning namim uningdidur. ");
INSERT INTO uiglat_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Lékin eger sen uning awazigha qulaq sélip, Méning barliq buyrughanlirimgha emel qilsang, Men düshmenliringge düshmen, küshendiliringge küshende bolimen. ");
INSERT INTO uiglat_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Chünki Méning Perishtem aldingda yürüp, séni Amoriy, Hittiy, Perizziy, Qanaaniy, Hiwiy we Yebusiylarning zéminigha bashlap kiridu; Men ularni yoqitimen. ");
INSERT INTO uiglat_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Sen ularning ilahlirigha bash urup ibadet qilma we yaki ular qilghandek qilma; belki ularning butlirini üzül-késil chéqiwet, but tüwrüklirini üzül-késil kukum-talghan qiliwet; ");
INSERT INTO uiglat_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Lékin Xudayinglar Perwerdigarning ibaditide bolunglar. Shundaq qilsanglar U nan bilen süyünglarni beriketleydu; Men barliq késellikni aranglardin chiqirip tashlaymen. ");
INSERT INTO uiglat_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Buning bilen zéminingda boyidin ajrap kétidighan yaki tughmas héchbir ayal yaki charpay bolmaydu; ömrüngning künlirini toluq qilimen. ");
INSERT INTO uiglat_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Men séning aldingda wehimimni ewetimen, qaysi taipige yéqinlashsang shularni parakende qilimen; shuning bilen hemme düshmenliringni keynige yandurup qachurimen. ");
INSERT INTO uiglat_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Hiwiylar, Qanaaniylar we hittiylarni aldingdin qoghlap chiqiriwétishke sériq herilerni aldingda yürüshke ewetimen.    ");
INSERT INTO uiglat_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Emma zéminning Xarabiliship, dalada wehshiy haywanlar awup sanga xewp bolup qalmasliqi üchün, shu ellerni aldingdin bir yilghiche heydiwetmeymen, ");
INSERT INTO uiglat_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Belki sen awup, zéminni pütünley miras qilip bolghuche, az-azdin heydep turimen. ");
INSERT INTO uiglat_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Séning zéminingning chégrilirini Qizil Déngizdin tartip Filistiylerning déngizighiche, shuningdek chöldin tartip Efrat deryasighiche békitimen; chünki zéminda turuwatqanlarni heydiwétip yérini igilishing üchün, ularni qolunggha tapshurimen.    ");
INSERT INTO uiglat_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Sen ular bilen we yaki ilahliri bilen héchqandaq bir ehde tüzme. ");
INSERT INTO uiglat_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ularning séni aldimda gunahqa patquzmasliqi üchün ularni zéminingda qet’iy turghuzma. Chünki mubada sen ularning ilahlirining ibaditide bolsang, bu ish sanga tuzaq bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","U Musagha yene: — «Sen bérip, özüng bilen bille Harun, Nadab, Abihuni we Israillarning aqsaqalliri arisidin yetmish ademni élip, Perwerdigarning huzurigha chiqip, yiraqta turup sejde qilinglar. ");
INSERT INTO uiglat_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Peqet Musala Perwerdigarning aldigha yéqin kelsun; bashqilar yéqin kelmisun, xelq uning bilen bille üstige chiqmisun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa kélip Perwerdigarning barliq sözliri bilen hökümlirini xalayiqqa dep berdi; pütkül xalayiq bir awazda: — Perwerdigarning éytqan sözlirining hemmisige emel qilimiz! — dep jawab bérishti. ");
INSERT INTO uiglat_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Andin Musa Perwerdigarning hemme sözini xatiriliwélip, etisi seher qopup taghning tüwide bir qurban’gahni yasap, shu yerde Israilning on ikki qebilisining sani boyiche on ikki tash tüwrükni tiklidi. ");
INSERT INTO uiglat_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Yene Israillarning birnechche yigitlirini ewetti, ular bérip Perwerdigargha köydürme qurbanliqlar sundi, inaqliq qurbanliqi süpitide birnechche torpaqnimu soyup sundi. ");
INSERT INTO uiglat_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Andin Musa qanning yérimini qachilargha qachilidi, yene yérimini qurban’gah üstige chachti. ");
INSERT INTO uiglat_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Andin u ehdinamini qoligha élip, xelqqe oqup berdi. Ular jawaben: — Perwerdigarning éytqinining hemmisige qulaq sélip, itaet qilimiz! — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Shuning bilen Musa qachilardiki qanni élip, xelqqe sépip: — Mana, bu Perwerdigar mushu sözlerning hemmisige asasen siler bilen baghlighan ehdining qénidur, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Andin kéyin Musa we Harun, Nadab we Abihu Israillarning aqsaqalliridin yetmish adem bilen bille tagh üstige chiqishti. ");
INSERT INTO uiglat_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ular shu yerde Israilning Xudasini kördi; uning ayighining astida xuddi kök yaquttin yasalghan nepis payandazdek, asman gümbizidek süpsüzük bir jisim bar idi.    ");
INSERT INTO uiglat_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Lékin u Israillarning mötiwerlirige qol tegküzmidi; ular Xudani körüp turdi hemde yep-ichishti. ");
INSERT INTO uiglat_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Perwerdigar Musagha: — Tagh üstige, qéshimgha chiqip shu yerde turghin. Sanga ulargha ögitishke tash taxtaylarni, yeni Men yézip qoyghan qanun-emrni bérimen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Shuning bilen Musa qopup, Yardemchisi Yeshuani élip mangdi. Musa Xudaning téghigha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","U awwal aqsaqallargha: Biz yénip kelgüche mushu yerde bizni saqlap turunglar. Mana, Harun bilen xur silerning yéninglarda qalidu; eger birsining ish-dewasi chiqsa, ularning aldigha barsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Shuning bilen Musa taghning üstige chiqti we taghni bulut qaplidi. ");
INSERT INTO uiglat_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Perwerdigarning julasi Sinay téghining üstide toxtidi; bulut uni alte kün’giche qaplap turdi; yettinchi küni, Perwerdigar bulut ichidin Musani chaqirdi; ");
INSERT INTO uiglat_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Perwerdigarning julasining qiyapiti Israillarning köz aldida taghning choqqisida hemmini yutquchi ottek köründi. ");
INSERT INTO uiglat_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa bulutning ichige kirip, taghning üstige chiqip ketti. Musa qiriq kéche-kündüz taghda turdi. ");
INSERT INTO uiglat_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Sen Israillargha éytqin, ular Manga bir «kötürme hediye»ni keltürsun; kimning köngli hediye sunushqa xush bolsa, uningdin Manga sunulidighan «kötürme hediye»ni tapshuruwélinglar.    ");
INSERT INTO uiglat_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Siler ulardin tapshuruwalidighan kötürme hediye: — Altun, kümüsh, mis, ");
INSERT INTO uiglat_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kök, sösün we qizil renglik yip, kanap rext, tiwit, ");
INSERT INTO uiglat_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","qizil boyalghan qochqarning tériliri, délfinning tériliri, akatsiye yaghichi, ");
INSERT INTO uiglat_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","chiragh üchün zeytun méyi, «mesihlesh méyi» we xushbuy üchün xushbuy dora-dermekler, ");
INSERT INTO uiglat_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","efod bilen «qoshén»gha ornitilidighan aq héqiq we bashqa ésil tashlar bolsun.    ");
INSERT INTO uiglat_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Méning özliri arisida makan qilishim üchün shulardin Manga bir muqeddes turalghuni yasisun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Uni Men sanga barliq körsetmekchi bolghinimgha asasen, yeni ibadet chédirining nusxisi we barliq eswab-saymanlirining nusxisigha op’oxshash qilip yasanglar. ");
INSERT INTO uiglat_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ular akatsiye yaghichidin bir sanduq yasisun. Uning uzunluqi ikki yérim gez, kengliki bir yérim gez, égizliki bir yérim gez bolsun.    ");
INSERT INTO uiglat_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Sen uni sap altun bilen qaplighin; ichi we sirtini altun bilen qaplap, uning üstünki qismining chörisige altundin girwek chiqar. ");
INSERT INTO uiglat_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Uninggha altundin töt halqa quydurup, töt chétiqigha békitkin. Bir teripige ikki halqa, yene bir teripige ikki halqa bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Sen hem akatsiye yaghichidin ikki baldaq yasap, her ikkisini altun bilen qaplighin; ");
INSERT INTO uiglat_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","andin sanduq ular arqiliq kötürülsun dep, baldaqlarni sanduqning ikki yénidiki halqiliridin ötküzüp qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Baldaqlar hemishe sanduqtiki halqida tursun; ular uningdin chiqirilmisun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Men sanga béridighan höküm-guwahliqni sanduqqa qoyghin.    ");
INSERT INTO uiglat_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Sanduqning yapquchi süpitide sen altundin uzunluqi ikki yérim gez, kengliki bir yérim gez bolghan bir «kefarǝt texti» yasighin.    ");
INSERT INTO uiglat_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ikki kérubni altundin soqup yasighin. Ularni kefarǝt textining ikki teripige ornatqin.    ");
INSERT INTO uiglat_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Bir kérubni bir teripige, yene bir kérubni yene bir teripige ornitish üchün yasighin. Ikki teripidiki kérublarni kefarǝt texti bilen bir gewde qilinglar. ");
INSERT INTO uiglat_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kérublar bir-birige yüzlensun, qanatlirini kefarǝt textining üstige kérip, qanatliri bilen uni yapsun; kérublarning yüzi kefarǝt textige qaritilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Sen kefarǝt textini sanduqning üstige qoyup, Men sanga béridighan höküm-guwahliqni sanduqning ichige qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Men shu yerde sen bilen körüshimen; kefarǝt texti üstide, yeni höküm-guwahliq sanduqining üstidiki ikki kérubning otturisida turup sanga Israillargha yetküzüshke tapshuridighan barliq emrlirim toghrisida söz qilimen. ");
INSERT INTO uiglat_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Hem akatsiye yaghichidin uzunluqi ikki gez, kengliki bir gez, égizliki bir yérim gez bolghan bir shire yasighin. ");
INSERT INTO uiglat_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Uni sap altun bilen qaplap, uning üstünki qismining chörisige altundin girwek chiqar. ");
INSERT INTO uiglat_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Sen shirening chörisige töt ilik égizlikte bir lew yasighin; bu lewning chörisigimu altundin bir girwek chiqar. ");
INSERT INTO uiglat_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Sen u shirege altundin töt halqa yasap, bu halqilarni shirening töt burjikidiki chétiqqa ornatqin. ");
INSERT INTO uiglat_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Shireni kötürüshke baldaqlar ötküzülsun dep, halqilar shire léwige yéqin békitilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Baldaqlarni akatsiye yaghichidin yasap, altun bilen qaplighin; shire ular arqiliq kötürilidu. ");
INSERT INTO uiglat_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Shirege yandap légen, qacha-texse, piyale we sharab hediyelirini chachidighan qedehlerni yasighin; ularni sap altundin yasighin. ");
INSERT INTO uiglat_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Méning huzurumda turushqa sen shirege hemishe «teqdim nan»ni qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Sen hem sap altundin bir chiraghdan yasighin. U chiraghdan soqup yasalsun; chiraghdanning puti, gholi, qedehliri, ghunche we chéchekliri pütün bir altundin soqulsun.    ");
INSERT INTO uiglat_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Chiraghdanning gholining ikki yénidin alte shaxche chiqirilsun — chiraghdanning bir yénidin üch shaxche, chiraghdanning yene bir yénidin üch shaxche chiqirilsun; ");
INSERT INTO uiglat_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","bir yénidiki herbir shaxchide badam güli sheklide ghunchisi we chéchiki bolghan üch qedeh chiqirilsun, yene bir yénidiki herbir shaxchide badam güli sheklide ghunchisi we chéchiki bolghan üch qedeh chiqirilsun. Chiraghdan’gha chiqirilghan alte shaxchining hemmisi shundaq yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Chiraghdanning gholidin badam güli sheklide ghunchisi we chéchiki bolghan töt qedeh chiqirilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Bulardin bashqa birinchi ikki shaxchining astida bir ghunche, ikkinchi ikki shaxchining astida bir ghunche, üchinchi ikki shaxchining astida bir ghunche bolsun; chiraghdan’gha chiqirilghan alte shaxchining asti hemmisi shundaq bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Uning shu ghunchiliri hem shaxchiliri chiraghdan bilen bir gewde qilinsun — bir pütün sap altundin soqup yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Sen chiraghdanning yette chirighini yasighin; chiraghlar udulgha yoruq chüshürelishi üchün üsti terepke ornitilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Uning pilik qaychiliri bilen küldanliri sap altundin yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Chiraghdan we uning barliq eswabliri bir talant sap altundin yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Sanga taghda ayan qilin’ghan nusxa boyiche bularni éhtiyat bilen yasighin.    ");
INSERT INTO uiglat_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Muqeddes chédirni on parche yopuqtin yasatqin; yopuqlar népiz toqulghan aq kanap rextke kök, sösün we qizil yiplar arilashturulup ishlensun; uninggha kérublarning süritini chéwer qollargha nepis qilip keshtilep chiqarghuzghin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Herbir yopuqning uzunluqi yigirme sekkiz gez, kengliki töt gez bolup, herbir yopuq oxshash chong-kichiklikte bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Yopuqlarning beshi bir-birige ulansun, qalghan besh yopuqmu hem bir-birige ulansun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Sen ulap chiqilghan birinchi chong parchining eng chétidiki qismigha bir teripige renggi kök izme qadighin, shuningdek ulap chiqilghan ikkinchi chong parchining eng chétidikisining bir teripigimu hem shundaq qilghin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Birinchi chong parchining eng chétidiki qismigha ellik izme qadighin, ikkinchi chong parchining eng chétidikisigimu ellik izme qadighin. Izmiler bir-birige udulmuudul bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Muqeddes chédir bir pütün bolsun üchün altundin ellik ilghu yasap, ikki chong parche yopuqni shu ilghular bilen bir-birige tutashturghin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Muqeddes chédirni yépish üchün öchke tiwitidin yopuqlarni yasighin; yopuqtin on bir parche yasighin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Yopuqlarning herbirining uzunluqi ottuz gez, kengliki töt gez bolup, on bir yopuqning hemmisi oxshash chong-kichiklikte bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Yopuqlarning beshini ulap bir qilip, qalghan alte yopuqnimu ulap bir qilip, altinchi yopuqni ikki qat qilip, chédirning aldi teripige sanggilitip qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Sen birinchi ulap chiqilghan chong parchining eng chétidiki qismigha ellik izme, ikkinchi ulap chiqilghan chong parchining eng chétidiki qismigha ellik izme qadighin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Sen hem mistin ellik ilghu yasap, chédir bir pütün bolsun üchün ularni izmilerge ötküzüp ikki chong parchini ulap qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Lékin yopuqning chédirning keynidin éship qalghan qismi, yeni éship qalghan yérim parchisi chédirning keyni teripide sanggilap tursun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Chédir yopuqlirining chédirning boyidin artuq qismi, yeni u teripidin bir gez, bu teripidin bir gez, chédirning ikki teripidin sanggilap, uni toluq yapsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Buningdin bashqa, chédirgha qizil boyalghan qochqar térisidin yopuq yasap yapqin, andin uning üstidinmu délfin térisidin yasalghan yene bir yopuqni qaplighin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Muqeddes chédirning tik taxtaylirini akatsiye yaghichidin yasap tikligin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Herbir taxtayning uzunluqi on gez, kengliki bir yérim gez bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Herbir taxtayning ikkidin turumi bolsun, her ikki taxtay shular bilen bir-birige chétilsun; chédirning barliq taxtaylirini shundaq yasighin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Chédirning taxtaylirini shundaq yasighin; yigirmisini jenub terepke tikligin; ");
INSERT INTO uiglat_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","bu yigirme taxtayning tégige kümüshtin qiriq teglik yasighin; bir taxtayning astidiki ikki turumi üchün ikkidin teglik, yene bir taxtayning ikki turumi üchün ikkidin teglik yasighin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Shuningdek chédirning udul teripide, yeni shimal teripide yigirme taxtay bolsun; ");
INSERT INTO uiglat_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","bularning qiriq tegliki kümüshtin bolsun; bir taxtayning tégige ikkidin teglik, yene bir taxtayning tégige ikkidin teglik orunlashturulsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Chédirning keyni teripige, yeni gherb terepke alte taxtay yasap tikligin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Chédirning keyni teripidiki ikki bulunggha ikki taxtay yasap ornatqin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Bu bulung taxtayliri astidin üstigiche ikki qat qilinip taxtaylarni özara chétishtursun, üsti bir halqigha békitilsun. Her ikkisi shundaq qilinip, ikki bulunggha tiklensun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Arqa terepte sekkiz taxtay bolidu, ularning kümüshtin yasalghan on alte tegliki bolidu; bir taxtayning tégide ikki teglik, yene bir taxtayning tégide ikki teglik bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Buningdin bashqa sen akatsiye yaghichidin baldaq yasighin; chédirning bu teripidiki taxtaylargha besh baldaqni, ");
INSERT INTO uiglat_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","chédirning u teripidiki taxtaylargha besh baldaqni, chédirning arqa teripidiki taxtaylargha, yeni gherb teripidiki taxtaylargha besh baldaqni yasighin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Taxtaylarning otturisidiki ottura baldaq bu tereptin u terepke yétidighan bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Taxtaylarni altun bilen qaplap, baldaqlar ötküzülidighan halqilarni altundin yasap, baldaqlarni altun bilen qaplighin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Chédirni sanga taghda ayan qilin’ghan nusxa boyiche yasap tikligin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Sen népiz toqulghan aq kanap rextke kök, sösün we qizil yiplar arilashturulup ishlen’gen bir perde yasighin; uni chéwer qollar kérublarning süritini nepis qilip chüshürüp keshtilep chiqsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Uni akatsiye yaghichidin yasalghan töt xadigha ésip qoyghin. Bu xadilar altun bilen qaplansun, herbirining altun ilmiki bolsun; xadilar kümüshtin yasalghan töt teglikke ornitilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Perde chédir yopuqidiki ilmeklerge ésilip sanggilitip qoyulsun; andin höküm-guwahliq sanduqini shu yerge keltürüp, perdining ichige élip kirgin. Shuning bilen perde siler üchün muqeddes jay bilen eng muqeddes jayning otturisidiki bir ayrima perde bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Andin sen «kefarǝt texti»ni eng muqeddes jaydiki höküm-guwahliq sanduqining üstige qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Shire bolsa perdining téshigha orunlashturulsun; chiraghdanni shirening uduligha, chédirning jenub teripige qoyghin; shireni shimal teripige qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Buningdin bashqa sen chédirning kirish éghizigha népiz toqulghan aq kanap rextke kök, sösün we qizil yiplar arilashturulup ishlen’gen bir perde yasighin; u keshtichi teripidin keshtilensun. ");
INSERT INTO uiglat_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Bu perde üchün akatsiye yaghichidin besh xada yasap, ularni altun bilen qaplighin; herbirining altun ilmiki bolsun; ularning tégige besh dane teglikni mistin quyup teyyarlatqin. ");
INSERT INTO uiglat_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Sen qurban’gahni akatsiye yaghichidin yasighin. Qurban’gah töt chasa bolsun; uzunluqi besh gez, kengliki besh gez, égizliki üch gez qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Uning töt burjikige qoyulidighan münggüzlirini yasighin; münggüzliri qurban’gah bilen bir gewde qilinsun. Qurban’gahni mis bilen qaplighin. ");
INSERT INTO uiglat_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Qurban’gahning yagh we külini élishqa daslarni yasighin; uninggha xas bolghan gürjeklerni, korilarni, laxshigirlarni we otdanlarnimu yasighin; uning barliq eswablirini yasashqa mis ishletkin. ");
INSERT INTO uiglat_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Qurban’gah üchün mistin bir shala yasighin; shalaning töt burjikige töt mis halqa yasap békitip qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Shalani qurban’gahning qap bélining astidiki girwektin töwenrek turidighan qilghin, shundaqta shala qurban’gahning del otturisida bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Qurban’gahqa ikki baldaq yasighin; ular akatsiye yaghichidin bolsun, ularni mis bilen qaplighin. ");
INSERT INTO uiglat_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Qurban’gahni kötürgende, baldaqlar uning ikki yénida bolushi üchün, ularni halqilargha ötküzüp qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Qurban’gahni taxtaylardin yasighin, ichi bosh bolsun; u taghda sanga ayan qilin’ghan nusxa boyiche hünerwenler teyyar qilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Muqeddes chédirning hoylisinimu yasighin. Hoylining jenubigha, yeni jenubqa yüzlen’gen teripige népiz toqulghan aq kanap rexttin perdilerni toqughin; shu teripining uzunluqi yüz gez bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Perdilerni ésishqa yigirme xada yasalsun; ularning tégige qoyushqa yigirme mis teglik yasalsun; xadilarning ilmiki bilen baldaqlar bolsa kümüshtin yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Shuninggha oxshash shimal teripidimu uzunluqi yüz gez kélidighan perde bolsun. Perdilerni ésishqa yigirme xada yasalsun; ularning tégige qoyushqa yigirme mis teglik yasalsun; xadilarning ilmiki bilen baldaqlar bolsa kümüshtin yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Hoylining gherb teripide uzunluqi ellik gez kélidighan perde bolsun; uning on xadisi we on tegliki bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Hoylining sherq teripi, yeni kün chiqishqa yüzlen’gen teripining kengliki ellik gez bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Bir teripide on besh gez kélidighan perde bolsun; uning üch xadisi bilen üch tegliki bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Yene bir teripide on besh gez kélidighan perde bolsun; uning üch xadisi bilen üch tegliki bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Hoylining kirish éghizigha yigirme gez kélidighan bir perde qoyulsun; perde népiz toqulghan aq kanap rextke kök, sösün we qizil yiplar arilashturulup, keshtichi teripidin keshtilensun. Uning töt xadisi bilen töt tegliki bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Hoylining chörisidiki hemme xadilar kümüshtin yasalghan baldaqlar bilen bir-birige chétilsun; ularning ilmekliri kümüshtin, teglikliri mistin yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Hoylining uzunluqi yüz gez, kengliki her ikki teripi ellik gez bolsun; népiz toqulghan aq kanap rexttin ishlen’gen perdining égizliki besh gez qilinsun; xadilarning teglikliri mistin yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Muqeddes chédirning ish-xizmitide ishlitilidighan barliq eswab-saymanliri hemde barliq miq-qozuqliri, shundaqla hoylining barliq miq-qozuqliri mistin bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","— Chiraghning hemishe yéniq turushi üchün, chiraghqa ishlitishke zeytundin soqup chiqirilghan sap mayni qéshinggha keltürüshke Israillarni buyrughin. ");
INSERT INTO uiglat_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Jamaet chédirining ichide, höküm-guwahliq sanduqining udulidiki perdining tashqirida Harun we oghulliri her kéchisi etigen’giche Perwerdigarning aldida chiraghlarning yéniq turghuzush ishida bolsun. Bu ish dewrdin-dewrgiche Israillargha ebediy bir qanun-belgilime bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Sen Israillarning ichidin akang Harun we uning oghullirini öz qéshinggha keltürgin; ularni, yeni Harun we oghulliri Nadab, Abihu, Eliazar we Itamarlarning Méning kahinliq xizmitimde bolushi üchün yéninggha keltürgin. ");
INSERT INTO uiglat_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Akang Harun’gha hem sherep hem güzellik üchün muqeddes kiyimlerni teyyarlighin. ");
INSERT INTO uiglat_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Harunning Manga muqeddes qilinip, Méning kahinliq xizmitimde bolushi üchün, Men eqil-parasetning rohi bilen qelblirini toldurghan chéwer kishilerning herbirige söz qilip, ularni alahide kiyimlerni tikishke buyrughin. ");
INSERT INTO uiglat_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ular tikidighan kiyimler munulardin ibaret: — bir qoshén, bir efod, bir ton, keshtilen’gen bir xalta könglek, bir selle we bir belwagh. Méning kahinliq xizmitimde bolushi üchün, ular akang Harun’gha we oghullirigha muqeddes kiyimlerni tiksun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Uninggha altun we kök, sösün, qizil yiplar bilen népiz toqulghan aq kanap rext ishlitilsun; ");
INSERT INTO uiglat_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","efodni ular altun we kök, sösün, qizil yiplar bilen népiz toqulghan aq kanap rextlerni teyyarlap, chéwer qollargha nepis qilip keshtilitip ishletsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Efodning ikki béshini bir-birge tutashturush üchün ikki dolisida mürilik tasma bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Efodning üstidin baghlaydighan, keshtilen’gen belwagh efod bilen bir pütün qilinsun we uninggha oxshash sipta ishlinip, altun we kök, sösün, qizil yiplar we népiz toqulghan aq kanap rexttin yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ikki aq héqiqni tépip, ularning üstige Israilning oghullirining namlirini oydurghin; ");
INSERT INTO uiglat_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ularning namlirining altisi bir yaqutqa oyulsun, qalghan altisi bolsa yene bir yaqutqa oyulsun, hemmisi tughulush tertipi boyiche pütülsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Xuddi yaqut neqishchiliri ishligendek, möhür oyulghandek Israilning oghullirining namlirini ikki yaqutqa oydurghin; ular altundin yasalghan közlükke békitilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Israilning oghullirigha esletme tash bolsun üchün, ikki yaqutni efodning ikki mürilik tasmisigha qadighuzghin; shundaq bolghanda, Harun Perwerdigarning aldida ularning namlirini esletme süpitide müriliride kötürüp yüridu. ");
INSERT INTO uiglat_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Buningdin bashqa, sen altundin yene ikki közlük we sap altundin shoynidek éship étilgen ikki zenjir yasatqin; andin éshilme zenjirler közlüklerge békitilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Höküm qoshéni»ni chéwer qollargha nepis qilip keshtilitip yasatqin; uni hem efodni ishligen usulda yasighan, altun we kök, sösün, qizil yiplar bilen népiz toqulghan aq kanap rexttin yasighin.    ");
INSERT INTO uiglat_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","U ikki qat, töt chasa qilinsun; uzunluqi bir ghérich, kenglikimu bir ghérich bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Uning üstige töt qatar qilip göherlerni ornatqin: — birinchi qatargha qizil yaqut, sériq göher we zumret ornitilsun; ");
INSERT INTO uiglat_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ikkinchi qatargha kök qashtéshi, kök yaqut we almas ornitilsun; ");
INSERT INTO uiglat_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","üchinchi qatargha sösün yaqut, piroza we sösün kwarts ornitilsun; ");
INSERT INTO uiglat_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","tötinchi qatargha béril yaqut, aq héqiq we anartash ornitilsun; bularning hemmisi altun közlük ichige ornitilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Bu göherler Israilning oghullirining namlirigha wekil qilinip, ularning sanidek on ikki bolup, möhür oyghandek herbir göherge on ikki qebilining nami birdin-birdin pütülsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Qoshén’gha shoynidek éshilgen sap altundin ikki éshilme zenjir yasighin. ");
INSERT INTO uiglat_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Qoshén’gha altundin ikki halqa étip, ikki halqini qoshénning yuqiriqi ikki burjikige békitkin; ");
INSERT INTO uiglat_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","andin altundin éshilip yasalghan ikki zenjirni qoshénning yuqiriqi ikki burjikidiki halqidin ötküzüp, ");
INSERT INTO uiglat_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","éshilgen shu zenjirlerning ikki uchini ikki közlükke békitip, közlüklerni efodning ikki mürilik tasmisining aldi qismigha ornatqin. ");
INSERT INTO uiglat_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Buningdin bashqa sen altundin ikki halqa yasap, ularni qoshénning asti teripidiki ikki burjikige békitkin; ular efodqa tégiship turidighan qilinip ichige qadalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Mundin bashqa sen altundin yene ikki halqa yasap, ularni efodning ikki mürilik tasmisining aldi töwenki qismigha, yeni efodqa ulinidighan jaygha yéqin qilip, keshitilen’gen belwaghdin égizrek qilip békitkin. ");
INSERT INTO uiglat_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Qoshénning efodning keshitilen’gen belwéghidin yuqiriraq turushi, qoshénning efodtin ajrap ketmesliki üchün qoshénning halqisini kök shoyna bilen efodning halqisigha chétip qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Shundaq qilghanda, Harun muqeddes jaygha kirgende, höküm qoshénini taqighachqa, Israilning oghullirining namlirini esletme süpitide yürikining üstide Perwerdigarning aldida daim kötürüp yürgen bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Harun Perwerdigarning aldigha kirgende, urim bilen tummim uning yüriki üstide bolushi üchün, bularni höküm qoshénining ichige alghin; mushundaq qilghanda, Harun Israillargha baghliq hökümlerni hemishe Perwerdigarning huzurida öz yüriki üstide kötürüp yürgen bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Efodning ichidiki tonni pütünley kök renglik qilghin.    ");
INSERT INTO uiglat_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Tonning bashqa kiyilidighan töshüki del otturisida bolsun; uning yirtilip ketmesliki üchün xuddi bapkar toqughandek, sawutning yaqisigha oxshash chörisige pewaz chiqirilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Uning étikining chörisige kök, sösün we qizil yiptin anarlarni toqup asqin hemde altun qongghuraqlarni yasap, chörisidiki anarlarning ariliqigha birdin ésip qoyghin; tonning étikining pütkül chörisige bir altun qongghuraq, bir anar, yene bir altun qongghuraq, bir anar... békitilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Harun xizmet qilghan waqtida shu tonni kiysun; buning bilen Harun Perwerdigarning aldigha barghanda, yeni muqeddes jaygha, Perwerdigarning aldigha kirip-chiqqanda uning awazi anglinip turidu-de, u ölümdin aman qalidu. ");
INSERT INTO uiglat_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Andin kéyin sen sap altundin nepis bir otughatni yasap, uning üstige möhürge neqishlen’gendek: «Perwerdigargha muqeddes qilindi» dep oyghin;    ");
INSERT INTO uiglat_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","uni kök renglik yip bilen sellisige chigkin; u sellining aldi teripige taqalsun; ");
INSERT INTO uiglat_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","u Harunning péshaniside tursun. Buning bilen Harun Israillarning muqeddes qilip keltürgen barliq muqeddes hediyelirige chaplashqan gunahlarni öz üstige élip kötüridu; hediyelerning Perwerdigarning aldida qobul qilinishi üchün otughat hemishe uning péshanisige taqaqliq tursun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Buningdin bashqa aq kanap rexttin bir könglek toqughin, shuningdek kanap rexttin toqulghan bir selle teyyarlighin; keshtilen’gen bir belwagh yasighin.    ");
INSERT INTO uiglat_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Harunning oghullirigha xalta köngleklerni tikkin; ularghimu belwaghlarni teyyarla, ulargha égiz böklernimu tikkin; bular ulargha hem sherep hem güzellik bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Bularning hemmisini sen akang Harun we uning oghullirigha kiydürgin; andin ularning Méning aldimda kahinliq xizmitimde bolushi üchün ularni mesihlep, Manga muqeddes qilip ayrighin. ");
INSERT INTO uiglat_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ularning ewretlirining yépiq turushi üchün ulargha kanap rexttin tambal ettürgin; u bélidin yotisighiche yépip tursun. ");
INSERT INTO uiglat_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Harun we oghulliri jamaet chédirigha kirgende yaki muqeddes jayda xizmette bolush üchün qurban’gahqa yéqinlashqanda, ular gunahkar bolup ölüp ketmesliki üchün tambalni kiyiwalsun. Bu uninggha we uningdin kéyinki nesilliri üchün ebediy bir belgilime bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ularning Manga muqeddes qilinip, kahinliq xizmitimde bolushi üchün mundaq ishni ada qilishing kérek: — sen bir yash erkek torpaq bilen ikki qochqarni talla (hemmisi béjirim bolsun) ");
INSERT INTO uiglat_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","hemde pétir nan, zeytun méyi ileshtürülgen pétir toqach we zeytun méyi sürülüp mesihlen’gen pétir hemek nanlarni teyyarla, bularning hemmisini bughday unidin qilghin; ");
INSERT INTO uiglat_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","nanlarning hemmisini bir séwetke sélip, séwetni, torpaqni we ikki qochqarni bille hediye qilip keltürgin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Sen Harun we uning oghullirini jamaet chédirining kirish éghizigha yéqin élip kélip, ularni su bilen yughin; ");
INSERT INTO uiglat_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","andin kiyimlirini élip kélip, Harun’gha xalta könglek, efod toni we efodni kiydürgin, qoshénni taqighin; andin bélige efodning keshtilen’gen belwéghini baghlighin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Béshigha sellini yögep, sellige muqeddes otughatni taqap qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Andin mesihlesh méyini élip, béshigha quyup uni mesihligin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Andin sen uning oghullirini élip kélip, ulargha xalta köngleklerni kiydürgin; ");
INSERT INTO uiglat_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ulargha, yeni Harun we uning oghullirigha belwaghlarni baghlap, égiz böklerni kiydürgin. Shuning bilen ebediy belgilime boyiche, kahinliq xizmiti ularningki bolidu; shundaq qilip, sen Harun bilen uning oghullirini Xudagha muqeddes qilip ayrip teyinligin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","— Sen torpaqni jamaet chédirining aldigha élip kelgin; élip kelginingde Harun bilen uning oghulliri qollirini torpaqning béshigha qoysun.    ");
INSERT INTO uiglat_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Andin sen bu torpaqni Perwerdigarning aldida, jamaet chédirining kirish éghizining yénida boghuzlighin; ");
INSERT INTO uiglat_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","torpaqning qénidin élip barmiqing bilen uni qurban’gahning münggüzlirige sürüp, qalghan qanning hemmisini qurban’gahning tüwige töküp quyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ich qarnini yögep turghan barliq mayni, shundaqla jigerning üstidiki chawa may, ikki börek we ularning üstidiki mayni ajritip bularni qurban’gahta köydürgin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Torpaqning göshi, térisi we tézikini bolsa chédirgahning sirtigha élip chiqip, otta köydürüwetkin; bu gunah qurbanliqi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Andin sen qochqarlarning birini élip kelgin; Harun bilen uning oghulliri qollirini qochqarning béshigha qoysun; ");
INSERT INTO uiglat_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","andin sen bu qochqarni boghuzlap, uning qénidin qurban’gahning üsti qismining etrapigha sepkin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Qochqarni parchilap, uning ich qarni bilen pachaqlirini yuyup, ularni gösh parchiliri we bashning üstige qoyup, ");
INSERT INTO uiglat_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","pütün qochqarni qurban’gahta köydürgin. Bu Perwerdigargha atalghan köydürme qurbanliq — ot arqiliq sunulidighan, Perwerdigargha xushbuy yetküzidighan hediye bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kéyin sen ikkinchi qochqarni élip kelgin; Harun we uning oghulliri qollirini qochqarning béshigha qoysun. ");
INSERT INTO uiglat_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Andin bu qochqarni boghuzlap qénidin élip, Harunning ong quliqining yumshiqigha, uning oghullirining ong quliqining yumshiqigha, ularning ong qollirining chong barmiqi bilen ong putlirining chong barmiqigha sürkep qoyghin, qalghan qanni qurban’gahning üsti qismining etrapigha sepkin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Andin qurban’gah üstidiki qandin we mesihlesh méyidin élip, Harunning üstige, uning kiyimlirige, shuningdek uning oghullirining üstige we ularning kiyimlirigimu sepkin. Shundaq qilip u we uning kiyimliri, uning oghulliri we ularning kiyimlirimu uning bilen teng Xudagha atap muqeddes qilin’ghan bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Andin sen qochqarning méyi, quyruq méyi, ich qarnini yögep turghan barliq may, jigerning üstidiki chawa may, ikki börek we ularning üstidiki mayni chiqar hemde ong arqa putini alghin — (chünki bu qochqar kahinliqqa tiklesh qurbanliqigha atalghan qochqardur) — ");
INSERT INTO uiglat_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","— buningdin bashqa sen Perwerdigarning aldida qoyulghan pétir nan séwitidin bir girdini, zeytun méyi ileshtürülgen pétir toqachtin birni we pétir hemek nandin birni élip, ");
INSERT INTO uiglat_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","bularning hemmisini Harunning qollirigha we uning oghullirining qollirigha qoyup, ularni «pulanglatma hediye» süpitide Perwerdigarning aldida pulanglatquzghin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Andin sen bularni ularning qolliridin tapshurup élip, Perwerdigarning aldida xushbuy chiqarsun dep, qurban’gahtiki köydürme qurbanliqning üstide qoyup köydürgin. Bu ot arqiliq Perwerdigargha sunulghan hediye bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Sen Harunni kahinliqqa tiklesh qurbanliqigha atalghan qochqarning töshini élip «pulanglatma hediye» süpitide Perwerdigarning huzurida pulanglatqin; bu séning ülüshüng bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Shuningdek, sen kahinliqqa tiklesh qurbanliqigha atalghan qochqarning «pulanglatma hediye» süpitide pulanglitilghan töshi bilen «kötürme hediye» süpitide égiz kötürüp pulanglitilghan arqa putini, yeni Harun we uning oghullirigha béghishlan’ghan shu ülüshlerni «muqeddes» dep ayrip békitkin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Shuning bilen bu nersiler ebediy belgilime boyiche Israillar teripidin Harun we oghullirigha béghishlan’ghan nésiwe bolidu; chünki u kötürme hediyedur. Bular Israillar teripidin sunulidighan inaqliq qurbanliqliridin ayrip chiqilip, ularning Perwerdigargha atap «égiz kötürgen hediye»si hésablinip, «kötürme hediye» bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Harunning muqeddes kiyimlirige kéyin oghulliri warisliq qilidu. Ular mesihlinip, kahinliqqa teyinlen’gende shu kiyimlerni kiysun. ");
INSERT INTO uiglat_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Oghullirining qaysisi uning ornini bésip kahin bolsa, jamaet chédirigha kirip muqeddes jayning ichide xizmetke kirishkende, bu kiyimlerni uda yette kün kiyip yürsun. ");
INSERT INTO uiglat_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Sen kahinliqqa tiklesh qurbanliqigha atalghan qochqarni élip, uning göshini muqeddes jayda pishurghin; ");
INSERT INTO uiglat_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","andin Harun we oghulliri qochqarning göshi bilen séwettiki nanlarni jamaet chédirining kirish éghizida yésun; ");
INSERT INTO uiglat_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ular özlirining kahinliqqa teyinlinishide Xudagha atap muqeddes qilin’ghanda kefarǝtke ishlitilgen nersilerni yésun, lékin bular muqeddes bolghachqa, yat kishi buningdin héchnémini yémisun.    ");
INSERT INTO uiglat_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Eger kahinliqqa tiklesh qurbanliq göshidin yaki nandin etige azraq éship qalsa, éship qalghanni otta köydürüwet; bular muqeddes bolghachqa, héchkim uningdin yése bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Sen shu teriqide Harun we uning oghulliri toghrisida buyrughinimning hemmisini beja keltürüp, uda yette kün’giche ularni kahinliqqa tiklesh wezipisini ada qilghin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Her küni kefarǝt qilinishqa gunah qurbanliqi süpitide bir torpaqni sun’ghin. Qurban’gahning özini gunahtin pak qilishqa uning üchünmu kefarǝt keltürgin, muqeddes qilinsun dep, uni zeytun méyi bilen mesihligin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Yette kün’giche sen qurban’gah üchün kefarǝt keltürüp, uni muqeddes qilghin. Buning bilen u «eng muqeddes nersilerning biri» hésablinidu; uninggha tegken hemme nerse muqeddes hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Mana, qurban’gahta hemishe sunidighanliring munular: — her küni bir yashliq ikki qoza qurbanliq qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Birini etigende, yene birini gugumda qurbanliq qilip sun’ghin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Birinchi qoza bilen birge zeytun méyidin bir hinning töttin biri ileshtürülgen bughday unidin efahning ondin biri we yene sharab hediyesi süpitide töttin bir hin sharab qoshup sunulsun. ");
INSERT INTO uiglat_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ikkinchi qozini gugumda sun’ghin; uni etigenlik qurbanliqningkidek, xushbuy bolushi üchün ot arqiliq Perwerdigargha atalghan qurbanliq süpitide ashliq hediyesi we sharab hediyesi bilen qoshup sun’ghin. ");
INSERT INTO uiglat_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Shu teriqide bu köydürme qurbanliq nesildin-nesilge jamaet chédirining kirish éghizida Perwerdigarning huzurida ötküzülüp daimliq qurbanliq bolsun; Men Perwerdigar shu yerde siler bilen körüshüp, sen bilen sözlishimen. ");
INSERT INTO uiglat_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Shuningdek Men shu yerde Israillar bilen uchrishimen, shuning bilen u jay Méning shan-sheripim bilen muqeddes qilinidu. ");
INSERT INTO uiglat_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Men jamaet chédiri bilen qurban’gahni Özümge atap muqeddes qilimen; Harun we uning oghullirinimu Özümge kahinliq xizmette bolushqa ayrip muqeddes qilimen. ");
INSERT INTO uiglat_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Shundaq qilip Men Israillarning arisida makan qilip, ularning Xudasi bolimen. ");
INSERT INTO uiglat_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","U waqitta ular Méning ularning arisida makan qilishim üchün ularni Misir zéminidin chiqirip kelgen Xudasi Perwerdigar ikenlikimni bilidu; Men ularning Xudasi Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Sen yene xushbuy yandurush üchün bir xushbuygahni yasatqin; uni akatsiye yaghichidin teyyarlighin.    ");
INSERT INTO uiglat_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","U töt chasa, uzunluqi bir gez, kengliki bir gez, égizliki ikki gez bolsun. Uning töt burjikidiki münggüzler uning bilen bir pütün qilip yasalsun. ");
INSERT INTO uiglat_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Sen uni, yeni uning üstini, töt etrapini hem münggüzlirini sap altun bilen qaplatqin; uning üsti qismining chörisige altundin girwek chiqarghin. ");
INSERT INTO uiglat_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Uninggha altundin ikki halqa yasap, uning girwikining astigha békitkin; ularni ikki yénigha udulmu’udul békitkin. Xushbuygahni kötüridighan ikki baldaqni sélish üchün bularni xushbuygahning ikki teripige orunlashturghin. ");
INSERT INTO uiglat_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Baldaqlirini akatsiye yaghichidin yasap, altun bilen qaplighin. ");
INSERT INTO uiglat_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Xushbuygahni höküm-guwahliq sanduqining udulidiki perdining sirtigha, yeni Men sen bilen körishidighan jay bolghan höküm-guwahliq sanduqining üstidiki kefarǝt textining uduligha qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Harun shuning üstide ésil xushbuy etirni yandursun; her küni etigenliki chiraghlarni perligili kelgende, xushbuylarni yandursun. ");
INSERT INTO uiglat_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Shuningdek Harun gugumda chiraghlarni tizip yaqqanda, xushbuy yandursun. Shundaq qilip Perwerdigarning aldida nesildin-nesilge xushbuy hemishe öchürülmey yéniq bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Siler uning üstide ne héchqandaq gheyriy xushbuy yandurmanglar, ne köydürme qurbanliq ne ashliq hediyesi sunmanglar, shundaqla uning üstige héchqandaq sharab hediyesini tökmenglar. ");
INSERT INTO uiglat_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Her yilda Harun bir qétim xushbuygahning münggüzlirige kefarǝt keltürsun; her qétim kefarǝt keltüridighan gunah qurbanliqining qéni bilen uning üchün kefarǝt keltürsun. Nesildin-nesilge shundaq qilinglar; bu xushbuygah Perwerdigargha «eng muqeddes» hésablinidighan nersilerning qataridindur. ");
INSERT INTO uiglat_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Sen Israillarning sanini éniqlash üchün ularni sanighiningda, ularning sanilishi wejidin arisigha balayi’apet kelmesliki üchün, ularni sanighiningda herbir adem öz jéni üchün Perwerdigargha kefarǝt puli tapshursun.    ");
INSERT INTO uiglat_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Royxetke élinip, sanaqtin ötkenlerning hemmisi bérishi kérek bolghini shuki, herbiri muqeddes jaydiki shekelning ölchem birliki boyiche yérim shekel bersun (bir shekel yigirme gerahqa barawer kélidu). Bu yérim shekel Perwerdigargha «kötürme hediye» bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Royxetke élinip, sanaqtin ötkenler, yeni yigirme yash yaki uningdin chonglarning herbiri Perwerdigargha shu «kötürme hediye»ni bersun. ");
INSERT INTO uiglat_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Öz jéninglargha kefarǝt keltürüsh üchün Perwerdigargha kötürme hediye bergininglarda bay kishi yérim shekeldin artuq bermisun, kembeghel kishimu yérim shekeldin kem bermisun. ");
INSERT INTO uiglat_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Sen Israillardin shu kefarǝt pulini tapshurup élip, jamaet chédirining xizmitige béghishlap ishletkin; u pul Israillargha Perwerdigarning huzurida esletme süpitide jéninglargha kefarǝt keltüridighan bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Sen yuyunushqa ishlitishke mistin yoghan bir das we uninggha mistin bir teglik yasatqin; uni jamaet chédiri bilen qurban’gahning otturisigha orunlashturup, ichige su toshturup qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Harun bilen uning oghulliri uningdiki su bilen put-qollirini yusun. ");
INSERT INTO uiglat_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ular jamaet chédirigha kirgende ölmesliki üchün su bilen özini yuyushi kérek; ular xizmet qilish üchün, qurban’gahqa yéqin bérip Perwerdigargha ot arqiliq atilidighan qurbanliq sunmaqchi bolghinidimu, shundaq qilsun. ");
INSERT INTO uiglat_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ular ölmesliki üchün put-qollirini yusun; bu ish ulargha, yeni özi we uning nesilliri üchün ewladtin ewladqiche ebediy bir belgilime bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Sen hemmidin ésil xushbuy dora-dermeklerdin teyyarla, yeni murmekki suyuqluqidin besh yüz shekel, darchindin ikki yüz ellik shekel, égirdin ikki yüz ellik shekel, ");
INSERT INTO uiglat_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","qowzaqdarchindin besh yüz shekel élip (bu ölchemler muqeddes jaydiki shekelning ölchem birliki boyiche bolsun) we zeytun méyidinmu bir hin teyyarla; ");
INSERT INTO uiglat_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","bu dora-dermekler bilen mesih qilish üchün bir muqeddes may — etirchi chiqarghandek bir xushbuy may chiqarghuzghin. Bu «muqeddes mesihlesh méyi» bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Sen uning bilen jamaet chédirini, höküm-guwahliq sanduqini, ");
INSERT INTO uiglat_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","shire we uning barliq qacha-quchilirini, chiraghdan we uning eswablirini, xushbuygahni, ");
INSERT INTO uiglat_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","köydürme qurbanliq qurban’gahi we uning eswablirini, yuyunush dési we uning teglikini mesihligin; ");
INSERT INTO uiglat_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","sen shu terzde ularni «eng muqeddes nersiler» qatarida muqeddes qilghin. Ulargha tegken herqandaq nersimu «muqeddes» hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Harun bilen uning oghullirini bolsa Manga kahinliq xizmette bolushi üchün mesihlep muqeddes qilghin. ");
INSERT INTO uiglat_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israillargha söz qilip mundaq éytqin: — Bu may ewladtin ewladqiche Manga atalghan muqeddes mesihlesh méyi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Uni ademning bedinige quysa bolmaydu; shuningdek uninggha oxshaydighan yaki terkibi oxshishidighan héchqandaq maylarni yasimanglar. U muqeddes bolghini üchün silergimu muqeddes bolushi kérek. ");
INSERT INTO uiglat_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kimki terkibi shuninggha oxshaydighan may tengshise, yaki uni élip yat birsige sürse, u öz xelqi arisidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Perwerdigar Musagha mundaq dédi: — Sen xushbuy dora-dermekler, yeni xushbuy yélim, déngiz qululisi méyi, aq déwirqay we sap mestiki teyyarlighin. Bularning hemmisi oxshash miqdarda bolsun; ");
INSERT INTO uiglat_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Xuddi etirchi may chiqarghan’gha oxshash, ularni tengshep xushbuy yasighin; u tuzlan’ghan, sap we muqeddes puraqliq etir bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Sen uningdin azraq élip, talqandek obdan ézip, jamaet chédiridiki höküm-guwahliq sanduqining uduligha, yeni  Men siler bilen körüshidighan jayning aldigha qoyghin. Bu silerge Perwerdigargha atalghan «eng muqeddes nersiler» qatarida hésablansun. ");
INSERT INTO uiglat_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Siler yasighan bu xushbuyning rétsépi bilen özünglarghimu oxshash bir xushbuyni yasiwalsanglar bolmaydu. U sanga nisbeten éytqanda Perwerdigargha xas qilin’ghan muqeddes bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kimki uning puriqini purap huzurlinish üchün uninggha oxshap kétidighan herqandaq bir xushbuyni yasisa, u öz xelqi arisidin üzüp tashlansun. ");
INSERT INTO uiglat_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Perwerdigar Xuda Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Mana, Men Özüm Yehuda qebilisidin bolghan Xurning newrisi, urining oghli Bezalelni ismini atap chaqirdim;    ");
INSERT INTO uiglat_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","uni Xudaning Rohi bilen toldurup, uninggha danaliq, eqil-paraset, ilim-hékmet igilitip, uni hertürlük ishni qilishqa qabiliyetlik qilip, ");
INSERT INTO uiglat_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","türlük-türlük hünerlerni qilalaydighan, yeni altun, kümüsh we mis ishlirini qilalaydighan, ");
INSERT INTO uiglat_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","yaqutlarni késip-oyalaydighan, ularni zinnet buyumlirigha ornitalaydighan, yaghachlargha neqish chiqiralaydighan, herxil hüner ishlirini qamlashturalaydighan qildim. ");
INSERT INTO uiglat_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Shuningdek mana, Men yene Dan qebilisidin Ahisamaqning oghli Oholiyabni uninggha yardemchilikke teyinlidim, shundaqla Men sanga buyrughan hemme nersilerni yasisun dep, barliq pem-parasetlik kishikerning könglige téximu eqil-paraset ata qildim; ");
INSERT INTO uiglat_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","shuning bilen ular jamaet chédirini, höküm-guwahliq sanduqini, uning üstidiki kefarǝt textini, chédirining hemme eswablirini, ");
INSERT INTO uiglat_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","shire bilen uning qacha-quchilirini, sap altundin yasilidighan chiraghdan bilen uning barliq eswablirini, xushbuygahni, ");
INSERT INTO uiglat_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","köydürme qurbanliq qurban’gahi bilen uning barliq eswablirini, yuyush dési bilen uning teglikini yasiyalaydighan, ");
INSERT INTO uiglat_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","xizmet kiyimliri, yeni kahinliq xizmitide kiyilidighan, Harun kahinning muqeddes kiyimliri we uning oghullirining kahinliq kiyimlirini toquyalaydighan, ");
INSERT INTO uiglat_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mesihlesh méyi we muqeddes jaygha teyyarlinidighan ésil dora-dermeklerdin xushbuyni yasiyalaydighan boldi. Men sanga emr qilghinim boyiche ular barliq ishni beja keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Perwerdigar Musagha emr qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Sen Israillargha emr qilip ulargha: — «Siler Méning shabat künlirimni choqum tutunglar; chünki bular silerning özünglarni pak-muqeddes qilghuchining Men Perwerdigar ikenlikini bilishinglar üchün Men bilen silerning otturanglardiki bir nishane-belge bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Shabat küni silerge muqeddes qilip békitilgini üchün, uni tutunglar; kimki uni buzsa, ölüm jazasigha tartilmisa bolmaydu; berheq, kimki u künide herqandaq ishni qilsa, öz xelqi arisidin üzüp tashlansun. ");
INSERT INTO uiglat_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Alte kün ichide ish qilinsun; lékin yettinchi küni Perwerdigargha atalghan muqeddes kün bolup, aram alidighan shabat küni bolidu; kimki shabat künide birer ish qilsa, ölüm jazasigha tartilmisa bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israillar shabat künini tutushi kérek; ular ebediy ehde süpitide uni ewladtin ewladqiche tutsun. ");
INSERT INTO uiglat_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Bu Men bilen Israillarning otturisida ebediy bir nishane-belge bolidu; chünki Perwerdigar alte kün ichide asman bilen zéminni yaritip, yettinchi künide aram élip rahet tapqanidi», — dégin. ");
INSERT INTO uiglat_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Xuda Sinay téghida Musagha bu sözlerni qilip bolghandin kéyin, ikki höküm-guwahliq taxtiyini uninggha tapshurdi. Taxtaylar tashtin bolup, sözler Xudaning barmiqi bilen ulargha pütülgenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Xelq Musaning taghdin chüshmey hayal bolup qalghinini körüp, Harunning qéshigha yighilip uninggha: — Sen qopup, bizge aldimizda yol bashlap mangidighan bir ilah yasap bergin! Chünki bizni Misir zéminidin chiqirip kelgen Musa dégen héliqi kishige néme bolup ketkenlikini bilmeymiz, — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Harun ulargha: — Xotunliringlar bilen oghul-qizliringlarning qulaqliridiki altun zire halqilarni chiqirip, méning qéshimgha élip kélinglar, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Shuning bilen pütkül xelq öz qulaqliridiki altun zire halqilarni chiqirip Harunning qéshigha élip keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","U bularni ularning qolidin élip, iskine bilen quyma bir mozayni yasatquzdi. Shuning bilen ular: — Ey Israil, séni Misir zéminidin chiqirip kelgen Xudayinglar mana budur! — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Harun uni körüp uning aldida bir qurban’gahni yasitip andin: «Ete Perwerdigar üchün bir héyt ötküzülidu», dep élan qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Etisi ular seher qopup, köydürme qurbanliqlarni sunup, inaqliq qurbanliqlirinimu keltürdi; andin xalayiq olturup yep-ichishti, qopup eysh-ishret qilishti.    ");
INSERT INTO uiglat_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Shu chaghda Perwerdigar Musagha: — Ornungdin tur, tézdin peske chüshkin! Chünki sen Misir zéminidin chiqirip kelgen xelqing buzuqchiliqqa bérilip ketti. ");
INSERT INTO uiglat_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Men ulargha buyrughan yoldin shunche tézla chetnep, özliri üchün bir quyma mozayni yasap, uninggha choqunup qurbanliq keltürüshti hemde: «Ey Israil, séni Misir zéminidin chiqirip kelgen Xudaying mana shudur!», déyishti, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Andin Perwerdigar Musagha: — Mana, bu xelqni körüp qoydum; mana, ular derweqe boyni qattiq bir xelqtur. ");
INSERT INTO uiglat_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Emdi Méni tosma, Men ghezep otumni ularning üstige chüshürüp, ularni yutuwétimen; andin séni ulugh bir el qilimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Lékin Musa Xudasi Perwerdigardin ötünüp iltija qilip mundaq dédi: — Ey Perwerdigar, némishqa sen ghezep otungni Özüng zor qudret we küchlük qol bilen Misir zéminidin chiqirip kelgen xelqingning üstige chüshürisen? ");
INSERT INTO uiglat_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Misirliqlar mazaq qilip: — Ularning béshigha bala chüshürüsh üchün, ularni taghlarning üstide öltürüp yer yüzidin yoqitish üchün, ularning Xudasi ularni élip ketti, — déyishsunmu? Öz otluq ghezipingdin yénip, Öz xelqingge balayi’apet keltürüsh niyitingdin yan’ghaysen! ");
INSERT INTO uiglat_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Öz qulliring Ibrahim, Ishaq we Israilni yad qilghin; Sen ulargha qesem bilen wede qilip: «Neslinglarni asmandiki yultuzlardek awutimen, Özüm uning toghrisida sözligen mushu zéminning hemmisini neslinglargha bérimen, ular uninggha menggü igidarchiliq qilidighan bolidu» dégenidingghu, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Shuning bilen Perwerdigar Öz xelqining üstige: «Balayi’apet chüshürimen» dégen niyitidin yandi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa keynige burulup, ikki höküm-guwahliq taxtiyini qoligha élip taghdin chüshti. Taxtaylarning ikki teripige sözler pütülgenidi; u yüzigimu, bu yüzigimu pütüklük idi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Bu taxtaylar bolsa Xudaning Özining yasighini, pütülgenliri bolsa Xudaning Özining pütkini idi, u taxtaylargha oyulghanidi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yeshua xelqning kötürgen chuqan-sürenlirini, warqirashlirini anglap Musagha: — Chédirgahdin jengning xitabi chiqiwatidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Lékin u jawab bérip: — Angliniwatqan awaz ne nusret tentenisi emes, ne meghlubiyetning peryadi emes, belki naxsha-küy sadasi! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa chédirgahgha yéqin kélip, mozayni we jamaetning ussulgha chüshüp ketkenlikini körüp shundaq derghezep boldiki, taxtaylarni qolidin tashlap taghning tüwide chéqiwetti. ");
INSERT INTO uiglat_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Andin ular yasighan mozayni otqa sélip köydürüp, uni yanjip kukum-talqan qilip, su üstige chéchip Israillarni ichishke mejburlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Andin Musa Harun’gha: Sen ularni shunche éghir gunahqa patquzghudek, mushu xelq sanga néme qildi? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harun jawab bérip: — Xojamning ghezep-achchiqi tutashmighay! Bu xelqning qandaq ikenlikini, ularning zezillikke mayil ikenlikini obdan bilisen. ");
INSERT INTO uiglat_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ular manga: — «Bizge aldimizda yol bashlap mangidighan bir ilahni yasap bergin; chünki bizni Misir zéminidin chiqirip kelgen Musa dégen shu ademge néme bolghinini bilmeymiz», dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Men ulargha: «Kimde altun bolsa shuni chiqirip bersun» désem, ular manga tapshurup berdi; men uni otqa tashliwidim, mana, bu mozay chiqti, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa xelqning qandaqsige tizginsiz bolup ketkenlikini kördi; chünki Harun ularni düshmenlirining aldida mesxire obyékti bolushqa öz meylige qoyuwetkenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa chédirgahning kirish éghizigha bérip, shu yerde turup: — Kimki Perwerdigarning teripide bolsa méning yénimgha kelsun! — dédi. Shuni déwidi, Lawiylarning hemmisi uning qéshigha yighildi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","U ulargha: — Israilning Xudasi Perwerdigar mundaq deydu: — «Herbir kishi öz qilichini yanpishigha ésip, chédirgahning ichige kirip, bu chétidin u chétigiche kézip yürüp, herbiri öz qérindishini, öz dost-buradirini, öz qoshnisini öltürsun!» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Shuning bilen Lawiylar Musaning buyrughini boyiche ish kördi; shu küni xelqning ichidin üch ming kishi öltürüldi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Andin Musa: — Herbiringlar bügün özünglarni Perwerdigargha xas bolushqa atidinglar; chünki herbiringlar hetta öz oghlunglar hem qérindishinglarnimu ayimidinglar; shuning bilen bügün bext-beriketni üstünglargha chüshürdunglar, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Etisi Musa xelqqe söz qilip: — Siler derweqe nahayiti éghir bir gunah sadir qildinglar. Emdi mana, men Perwerdigarning aldigha chiqimen; gunahinglar üchün kefarǝt keltüreleymenmikin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Shuning bilen Musa Perwerdigarning aldigha yénip bérip: — Hey...! Bu xelq derweqe éghir bir gunah sadir qilip, özlirige altundin ilahlarni yasaptu! ");
INSERT INTO uiglat_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Lékin emdi Sen ularning gunahini epu qilishqa unighaysen..., unimisang, ismimni Özüng yazghan deptiringdin öchürüwetkin! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Perwerdigar Musagha jawab bérip: — Kimki Méning aldimda gunah qilghan bolsa, uning étini Öz deptirimdin öchürüwétimen. ");
INSERT INTO uiglat_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Emdi sen bérip, Men sanga éytqan jaygha xelqni bashlap barghin. Mana, Méning Perishtem aldingda mangidu. Lékin ulargha jaza béridighan künüm kelgende, ulargha gunahi üchün jaza bérimen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Bu sözdin kéyin Perwerdigar xelqning Harunning qoli bilen mozayni quydurup yasatqini üchün ularni waba bilen jazalidi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Perwerdigar Musagha mundaq dédi: — Sen ornungdin turup, özüng Misir zéminidin élip kelgen xelq bilen bille mushu yerdin kétip: «Men séning neslingge uni bérimen» dep qesem qilip Ibrahimgha, Ishaqqa we Yaqupqa wede qilghan zémin’gha barghin. ");
INSERT INTO uiglat_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Shuning bilen séning aldingda bir Perishte ewetip, Qanaaniy, Amoriy, Hittiy, Perizziylerni, Hiwiy bilen Yebusiylarni heydep chiqirip, ");
INSERT INTO uiglat_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","séni süt bilen hesel éqip turidighan zémin’gha keltürimen. Chünki siler boyni qattiq bir xelq bolghachqa, yolda silerni halak qiliwetmeslikim üchün, Özüm silerning aranglarda bolup, shu zémin’gha bille chiqmaymen, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Xalayiq bu qattiq sözni anglap, qayghugha chömüp héchqaysisi öz zibu-zinnetlirini taqimidi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Chünki Perwerdigar Musagha söz qilip: — Sen bérip Israillargha: «Perwerdigar: — Siler boyni qattiq bir xelq ikensiler; eger Men Perwerdigar aranglargha chiqip bir deqiqila tursam, silerni yoqitiwetken bolattim. Emdi siler özünglardiki zibu-zinnetlerni éliwétinglar; shu chaghda Men silerge néme qilidighinimni bilimen, dédi», dep éytqin, — dégenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Shunga Israillar Horeb téghidin ayrilipla zibu-zinnetlirini özliridin éliwetti. ");
INSERT INTO uiglat_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Shuning bilen Musa öz chédirini élip, uni chédirgahning sirtida, chédirgahdin nériraq bir jaygha tikip, uni «körüshüsh chédiri» dep atidi. Kimki Perwerdigarni izdep, yol sorimaqchi bolsa chédirgahning sirtidiki «körüshüsh chédiri»gha baratti. ");
INSERT INTO uiglat_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Shundaq bolattiki, her qétim Musa chédirgha chiqsa, pütkül xalayiq qopup, herbiri öz chédirining ishikide öre turup, Musa chédirgha kirip bolghuche uning keynidin qariship turatti. ");
INSERT INTO uiglat_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Andin Musa her qétim chédirgha kirip ketse shundaq bolattiki, bulut tüwrüki chüshüp, chédirning kirish éghizida toxtaytti; shuning bilen Perwerdigar Musa bilen sözlishetti. ");
INSERT INTO uiglat_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Pütkül xalayiq bulut tüwrükining jamaet chédirining kirish éghizida toxtighinini köretti; uni körginide xelqning hemmisi qopup, herbiri öz chédirining ishikide turup sejde qilishatti. ");
INSERT INTO uiglat_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Shu chaghlarda Perwerdigar Musa bilen kishiler öz dost-buradiri bilen sözleshkendek, yüzmuyüz sözlishetti. Andin Musa chédirgahgha yénip kéletti; lékin uning xizmetkari bolghan Nunning oghli Yeshua dégen yash yigit chédirning ichidin chiqmaytti. ");
INSERT INTO uiglat_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa Perwerdigargha mundaq dédi: — Mana, Sen daim manga: «Bu xelqni élip chiqqin» dep kelding; lékin Özüng manga: «Men séni ismingni bilip tonuymen», we shuningdek «Nezirim aldida iltipat tapting» dégen bolsangmu, Sen méning bilen birge kimni ewetidighiningni manga ayan qilmiding. ");
INSERT INTO uiglat_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Eger men rasttinla neziringde iltipat tapqan bolsam, özümning Séni tonushum üchün, neziringde iltipat tépiwérishim üchün manga Öz yolungni ayan qilghaysen; mana, bu xelqning Öz xelqing bolghinini neziringde tutqaysen! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","U jawab bérip: Men Özüm sen bille bille bérip, sanga aram ata qilimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa uninggha jawaben: — Eger Sen Özüng biz bilen bille mangmisang, bizni bu yerdin chiqarmighaysen; ");
INSERT INTO uiglat_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","chünki, men we xelqing neziringde iltipat tapqinimiz némidin bilinidu? Ejeba, Özüngning biz bilen bille mangghiningdin bilinmemdu? Shu sewebtin men we xelqing yer yüzidiki herbir taipilerdin alahide perqlenmemduq?! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Perwerdigar Musagha: — Mushu iltijayingnimu ijabet qilimen; chünki sen nezirimde iltipat tapting we Men séni ismingni bilip tonuymen, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Shuning bilen Musa: — Öz shan-sherpingni manga körsetkeysen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Perwerdigar: — Özümning pütkül méhribanliqimni séning köz aldingdin ötküzimen we aldingda «Yahweh» dégen namni jakarlaymen. Kimge shapaet qilmaqchi bolsam shuninggha shapaet körsitimen, kimge rehim-shepqet körsetmekchi bolsam, shuninggha rehim-shepqet körsitimen, dédi.    ");
INSERT INTO uiglat_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Perwerdigar uninggha: — Sen yüzümni körelmeysen; chünki héch ademzat Méni körse tirik qalmaydu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Andin Perwerdigar: — Mana, yénimda bir jay bardur; sen shu yerdiki qoram tashning üstide turghin. ");
INSERT INTO uiglat_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Méning shan-sheripim ötidighan waqitta, shundaq boliduki, Men séni shu qoram tashning yériqida turghuzup, Men ötüp bolghuche séni qolum bilen yépip turimen. ");
INSERT INTO uiglat_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Andin qolumni tartiwalimen; shuning bilen sen Méning arqa teripimni körisen, lékin yüzüm körünmeydu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Perwerdigar Musagha: — Sen awwalqigha oxshash özüng üchün tashtin ikki taxtayni yonup kel; Men bu taxtaylargha sen ilgiri chéqiwetken taxtaylardiki sözlerni yézip qoyimen. ");
INSERT INTO uiglat_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sen ete etigen’giche teyyar bolup, seherde Sinay téghigha chiqip, shu yerde taghning choqqisida Méning aldimda hazir bolghin. ");
INSERT INTO uiglat_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Lékin héch kishi sen bilen bille chiqmisun we yaki taghning héch yéride bashqa adem körünmisun, qoy-kalilarmu taghning tüwide otlimisun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa awwalqigha oxshash tashtin ikki taxtayni yonup, etisi tang seher qopup, bu ikki tash taxtayni qolida élip, Perwerdigarning buyrughini boyiche Sinay téghigha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Shuning bilen Perwerdigar bulutta chüshüp, shu yerde Musaning qéshida turup, «Yahweh» dégen namini jakarlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Perwerdigar uning köz aldidin ötüp: — «Perwerdigar, Perwerdigar, rehimdil we méhir-shepqetliktur, asan ghezeplenmeydighan, shapaet bilen wapasi keng Tengridur,    ");
INSERT INTO uiglat_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","minglighan-on minglighanlargha rehim-shapaet körsitip, qebihlik, asiyliq we gunahni kechürgüchidur; lékin u gunahkarlarni hergiz gunahsiz dep qarimaydighan, belki atilarning qebihlikining jazasini baliliri we newrlirigiche, shundaqla üchinchi we tötinchi ewladighiche yükleydighan Tengridur» — dep jakarlidi.    ");
INSERT INTO uiglat_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Shuning bilen Musa derhal yerge bash qoyup sejde qilip: — ");
INSERT INTO uiglat_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","— Ey Reb, eger men rasttinla neziringde iltipat tapqan bolsam, undaqta i Reb, arimizda biz bilen mangghaysen; chünki bu xelq derweqe boyni qattiq bir xelqtur; bizning qebihlikimizni we gunahimizni kechürgeysen, bizni Öz mirasing bolushqa qobul qilghaysen! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Shuning bilen u Musagha: — Mana, Men bir ehde tüzimen; séning barliq xelqing aldida pütkül yer yüzining héchbir jayida yaki héchbir el arisida qilinip baqmighan möjizilerni yaritimen. Shuning bilen sen arisida bolghan xelqingning hemmisi Perwerdigarning karamet emelini köridu; chünki Méning silerge qilidighan emelim derweqe dehshetlik ish bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Men bügün sanga tapilaydighan emrlirimni tutqin; mana, Men silerning aldinglardin Amoriy, Qanaaniy, Hittiy, Perizziy, Hiwiy we Yebusiylarni heydep chiqirimen. ");
INSERT INTO uiglat_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Emdi hézi bolghinki, sen baridighan zéminda turuwatqanlar bilen héch ehde baghlashmighin; bolmisa, bu ish silerge tuzaq bolidu; ");
INSERT INTO uiglat_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","belki siler ularning qurban’gahlirini chuwup, but tüwrüklirini sundurup, «asherah» butlirini késip tashlanglar. ");
INSERT INTO uiglat_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Chünki sen héchqandaq bashqa ilahqa ibadet qilmasliqing kérek — chünki Menki Perwerdigarning nami «Wapasizliqqa Heset Qilghuchi» bolup, heset qilghuchi bir ilahdurmen. ");
INSERT INTO uiglat_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Bolmisa, shu zéminda turuwatqanlar bilen ehde tüzüshüng mumkin; andin ular ilahlirining keynidin yürüp buzuqchiliq qilip, ilahlirigha qurbanliqlar ötküzginide, silerni chaqirsa ularning qurbanliqliridin yep kétishinglar mumkin; ");
INSERT INTO uiglat_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","sen shundaqla yene ularning qizlirini oghulliringgha xotunluqqa élip bérishing mumkin; u qizlar öz ilahlirining keynidin yürüp buzuqchiliq qilghinida, ular oghulliringnimu öz ilahlirining arqisidin mangghuzup, buzuqchiliq qildurushi mumkin. ");
INSERT INTO uiglat_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Özüng üchün héchqandaq quyma butlarni yasatmighin. ");
INSERT INTO uiglat_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Pétir nan héytini tutunglar; Méning emr qilghinimdek Abib éyida, békitilgen waqitta yette kün pétir nan yenglar. Chünki siler Abib éyida Misirdin chiqqansiler. ");
INSERT INTO uiglat_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Baliyatquning tunji méwisi Méningki bolidu; charpay malliringning ichidin deslep tughulghan erkekler, kala bolsun, qoy bolsun ularning tunjilirining hemmisi Méningki bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Lékin ésheklerning tunji texeylirining ornigha qoza bilen bedel tölishing lazim bolidu. Eger ornigha qoza bermiseng, texeyning boynini sunduruwetkin. Tunji oghulliringni bolsa, ulargha bedel tölep qayturuwal. Héchkim Méning huzurumgha quruq qol kelmisun.    ");
INSERT INTO uiglat_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sen alte kün ichide ish-emelingni qilip, yettinchi küni aram élishing zörür; yer heydesh waqti bolsun, orma waqti bolsun, aram élishing zörür. ");
INSERT INTO uiglat_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Yéngi bughdayning tunji hosulini tebrikleydighan «heptiler héyti»ni ötküzünglar; yilning axirida «hosul yighish héyti»ni ötküzünglar.    ");
INSERT INTO uiglat_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Séning herbir erkek kishiliring yilda üch qétim Israilning Xudasi bolghan Reb Perwerdigarning aldigha hazir bolsun. ");
INSERT INTO uiglat_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Chünki Men taipilerni aldingdin heydiwétip, chégraliringni kéngeytimen; shuningdek sen yilda üch qétim Perwerdigar Xudayingning aldigha hazir bolushqa chiqip barsang, héchkim yéringge köz qirini salmaydu. ");
INSERT INTO uiglat_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Manga sunulidighan qurbanliqning qénini boldurulghan nan bilen bille sunmighin; yaki ötüp kétish héytining qurbanliqining göshini etige qaldurma.    ");
INSERT INTO uiglat_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Zéminingning deslepki hosulidin tunji mehsulatlarni Perwerdigar Xudayingning öyige keltürüp ata. Oghlaqni anisining sütide qaynitip pishurma.    ");
INSERT INTO uiglat_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Perwerdigar Musagha: — Bu sözlerni özüng üchün yéziwalghin; chünki Men mushu sözlerni asas qilip sen bilen we Israil bilen ehde baghlidim, dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","U waqitta Musa shu yerde Perwerdigarning huzurida qiriq kéche-kündüz turdi; u héchnerse yémidi, héch su ichmidi. U yerde Perwerdigar taxtaylargha ehdining sözliri bolghan on emrni pütti.    ");
INSERT INTO uiglat_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa Sinay téghidin chüshkende shundaq boldiki (u taghdin chüshkende ikki höküm-guwahliq taxtiyi uning qolida idi), özining Perwerdigar bilen sözleshkini üchün yüzining parqirap ketkinini bilmeytti. ");
INSERT INTO uiglat_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Emdi Harun we barliq Israillar Musani kördi, mana, uning yüz térisi parqirap turatti; ular uninggha yéqin bérishtin qorqushti. ");
INSERT INTO uiglat_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Lékin Musa ularni chaqiriwidi, Harun we jamaetning barliq bashliri yénip, uning qéshigha keldi; Musa ular bilen sözleshti. ");
INSERT INTO uiglat_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Shuningdin kéyin, barliq Israillar uning yénigha keldi; u waqitta Musa Perwerdigar özige Sinay téghida söz qilghinida tapshurghan barliq emrlerni ulargha tapilidi. ");
INSERT INTO uiglat_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa ulargha deydighinini dep tügetti. U sözligende yüzige bir chümperde tartiwalghanidi;    ");
INSERT INTO uiglat_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Qachanki Musa Perwerdigar bilen sözlishishke uning huzurigha kirse, chümperdini éliwétetti, taki u yénip chiqquche shundaq bolatti; yénip chiqqanda özige néme tapilan’ghan bolsa, shuni Israillargha éytip béretti. ");
INSERT INTO uiglat_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Israillar Musaning yüz térisining parqirap turghinini köretti; shunga Musa yene taki Perwerdigar bilen sözleshkili uning huzurigha kirgüche yüzige chümperde tartiwalatti. ");
INSERT INTO uiglat_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa Israillarning pütkül jamaitini yighip ulargha: — Perwerdigar silerge qilishqa buyrughan emrler munulardur: — ");
INSERT INTO uiglat_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Alte kün ish-emgek küni bolsun; lékin yettinchi küni silerge nisbeten muqeddes bir kün bolup, Perwerdigargha atalghan aram alidighan shabat küni bolsun. Herkim shu künide ish-emgek qilsa ölümge mehkum qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Shabat künide barliq turalghuliringlarda hergiz ot qalimanglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa Israillarning pütkül jamaitige söz qilip mundaq dédi: — «Perwerdigar buyrughan emr mana shuki: — ");
INSERT INTO uiglat_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Özünglarning aranglardin Perwerdigargha bir «kötürme hediye» keltürünglar; köngli xalighanlarning herbiri Perwerdigargha bir «kötürme hediye»sini keltürsun: yeni altun, kümüsh, mis, ");
INSERT INTO uiglat_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kök, sösün we qizil yip, aq kanap rext, öchke tiwiti, ");
INSERT INTO uiglat_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","qizil boyalghan qochqar térisi, délfin térisi, akatsiye yaghichi, ");
INSERT INTO uiglat_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","chiraghdan üchün zeytun méyi, «mesihlesh méyi» bilen xushbuy üchün ishlitilidighan ésil dora-dermekler, ");
INSERT INTO uiglat_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","efodqa hem qoshén’gha ornitilidighan héqiq we bashqa yaqutlarni keltürünglar». ");
INSERT INTO uiglat_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","— «Aranglardiki barliq mahir ustilar kélip Perwerdigar buyrughanning hemmisini yasap bersun: ");
INSERT INTO uiglat_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","— muqeddes chédir bilen uning ichki we tashqi yopuqlirini, ilghulirini, taxtaylirini, baldaqlirini, xadilirini we bularning tegliklirini, ");
INSERT INTO uiglat_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ehde sanduqi we uning baldaqlirini, «kefarǝt texti»ni, «ayrima perde-yopuq»ni, ");
INSERT INTO uiglat_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","shire we uning baldaqlirini, uning barliq qacha-quchilirini we «teqdim nanliri»ni, ");
INSERT INTO uiglat_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","yoruqluq üchün yasalghan chiraghdan we uning eswablirini, uning chiraghliri we chiragh méyini, ");
INSERT INTO uiglat_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","xushbuygah we uning baldaqlirini, «Mesihlesh méyi»ni, dora-dermeklerdin ishlen’gen xushbuyni, muqeddes chédirining kirish éghizidiki «ishik perdisi»ni, ");
INSERT INTO uiglat_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","köydürme qurbanliq qurban’gahi we uning mis shalasini, baldaqlirini we barliq eswablirini, yuyunush dési we uning teglikini, ");
INSERT INTO uiglat_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","hoylining perdilirini, uning xadiliri we ularning tegliklirini, hoylining kirish éghizidiki perdini, ");
INSERT INTO uiglat_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","chédirning mix-qozuqlirini, hoylining mix-qozuqlirini, shundaqla barliq tanilirini, ");
INSERT INTO uiglat_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","toqulidighan kiyimler, yeni muqeddes jayning xizmitige kahinliq xizmitide kiyilidighan, Harun kahinning muqeddes kiyimlirini hem uning oghullirining kiyimlirini teyyar qilsun».    ");
INSERT INTO uiglat_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Shuning bilen pütkül Israil jamaiti Musaning yénidin chiqip kétishti. ");
INSERT INTO uiglat_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Andin köngli tartqanlarning herbiri, rohi özlirige türtke bolghanlarning herbiri kélip, jamaet chédirini yasashqa, shundaqla chédirning xizmitide ishlitilidighan barliq seremjanlarni yasashqa we muqeddes kiyimlerni tikishke Perwerdigargha atalghan «pulanglatma hediye»ni keltürgili turdi. ");
INSERT INTO uiglat_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ular erlermu, ayallarmu kélip, sunushqa köngli xush bolghanlarning herbiri hediye keltürüp, bulapka, zire-halqa, üzük, zunnar-bilezük qatarliq herxil altun buyumlarni élip keldi; altunni «kötürme hediye» qilip bérey dégenlerning herbiri uni Perwerdigargha sundi. ");
INSERT INTO uiglat_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kimde kök, sösün, qizil yip bilen aq kanap rext, öchke tiwiti, qizil boyalghan qochqar térisi we délfin térisi bolsa, shularni élip kélishti. ");
INSERT INTO uiglat_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Kümüsh ya mistin kötürme hediye keltürey dégenlerning herbiri shuni Perwerdigargha hediye qilip sundi. Kimde chédirning xizmitide ishlitilidighan herxil seremjanlargha yarighudek akatsiye yaghichi bolsa, uni élip keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Qoli chéwer ayallarning herbiri öz qolliri bilen égirip, shu égirgen yip we rextlerni, yeni kök, sösün we qizil yip bilen aq kanap rextlerni keltürdi,    ");
INSERT INTO uiglat_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Shuningdek köngli qozghalghan ayallarning hemmisi hünirini ishlitip öchke tiwitidin yip égirishti. ");
INSERT INTO uiglat_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Emirler efod we qoshén’gha ornitilidighan héqiqlar we yaqutlarni, ");
INSERT INTO uiglat_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","dora-dermeklerni, chiraghqa we mesihlesh méyigha ishlitilidighan zeytun méyini, xushbuygha ishlitilidighan ésil dora-dermeklerni keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Shu teriqide Israillar Perwerdigar Musaning wasitisi bilen buyrughan ishlarning herqaysigha bir nerse bérishke köngli tartqan bolsa, er bolsun ayal bolsun herbiri shuni élip kélip, Perwerdigargha atap ixtiyariy hediye berdi. ");
INSERT INTO uiglat_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Andin Musa Israillargha mundaq dédi: — «Mana, Perwerdigar Yehuda qebilisidin xurning newrisi, Urining oghli Bezalelni ismini atap chaqirip,    ");
INSERT INTO uiglat_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","uni Xudaning Rohi bilen toldurup, uninggha danaliq, eqil-paraset, ilim-hékmet igilitip, uni hertürlük ishni qilishqa qabiliyetlik qilip, ");
INSERT INTO uiglat_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","uni türlük-türlük hünerlerni qilalaydighan — altun, kümüsh we mis ishlirini qilalaydighan, ");
INSERT INTO uiglat_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","yaqutlarni késip-oyalaydighan, zinnet buyumlirigha ornitalaydighan, yaghachlargha neqish chiqiralaydighan, herxil hüner ishlirini qamlashturalaydighan qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","U yene uning könglige, shuningdek hem Dan qebilisidin bolghan Ahisamaqning oghli Oholiyabning könglige bashqilargha hüner ögitish niyet-istikini sélip, ");
INSERT INTO uiglat_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ularning köngüllirini danaliq-hékmet bilen toldurup, ularni herxil neqqashliq-oymichiliq ishlirigha mahir qilip, kök, sösün we qizil yip bilen aq kanap rext bilen keshtichilik qilishqa hemde bapkarliqqa iqtidarliq qildi. Shuning bilen ular herxil hüner ishlirining we herxil layihilesh ishlirining höddisidin chiqalaydighan boldi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Shuning bilen Bezalel we Oholiyablar, shuningdek Perwerdigar muqeddes chédir yasashning herxil ishlirigha kérek bolghan danaliq-hékmet we eqil-parasetni ata qilghan mahir ustilarning herbiri ulargha qoshulup, shu ishni uning emr qilghini boyiche emelge ashuridu». ");
INSERT INTO uiglat_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Shu waqitta Musa Bezalel we Oholiyabni, shundaqla Perwerdigar danaliq-hékmet bilen köngüllirini toldurghan, köngli özini shu ishni qilishqa qatnishishqa dalalet qilghan barliq hünerwen-kasiplarni chaqirip yighdi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ular kélip muqeddes chédirni yasashqa, shundaqla uning ish-xizmetlirige kéreklik seremjanlarni yasashqa Israillar élip keltürgen barliq «kötürme hediye»lerni Musadin tapshuruwaldi. Israil xelqi yenila öz meyli bilen her küni etigini Musagha ixtiyariy hediye keltürüp turatti. ");
INSERT INTO uiglat_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Andin muqeddes chédirning ishlirini qiliwatqan ustilarning hemmisi qolidiki ishini qoyup qoyup kélip, ");
INSERT INTO uiglat_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Musagha: — Xelqning élip kelgini Perwerdigar bizge qilishqa buyrughan ishni pütküzüshke éhtiyaj bolghinidin köp éship ketti! — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Andin Musa emr qilip, pütkül chédirgah boyiche: «Mana, er bolsun, ayal bolsun, héchkim muqeddes chédirni yasash üchün «kötürme hediye» süpitide yene héchqandaq nerse teyyarlap kelmisun!» dep jakarlatti. Buning bilen köpchilik hediyeler keltürüshtin toxtitildi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Chünki ular teyyarlighan matériyallar pütkül qurulush ishigha yétetti, hetta éship qalatti. ");
INSERT INTO uiglat_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Muqeddes chédirning qurulush ishini qiliwatqan ustilarning herbiri népiz toqulghan aq kanap rextke kök, sösün we qizil yiplar arilashturulup ishlen’gen on parche yopuq yasap, kérublarning süritini yopuqlargha chéwerlik bilen layihilep nepis qilip keshtilep chiqti. ");
INSERT INTO uiglat_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Herbir yopuqning uzunluqi yigirme sekkiz gez, kengliki töt gez bolup, herbir yopuq oxshash chong-kichiklikte qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bezalel yopuqlarning beshini bir-birige ulidi, qalghan besh yopuqnimu hem bir-birige ulidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","U ulap chiqilghan birinchi chong parchining eng chétidiki qismining bir teripige renggi kök izmilerni qadidi, shuningdek ulap chiqilghan ikkinchi chong parchining eng chétidikisining bir teripigimu shundaq qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Birinchi chong parchining eng chétidiki qismigha ellik izme qadidi, ikkinchi chong parchining eng chétidikisigimu ellik izme qadidi. Izmiler bir-birige udulmuudul qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Muqeddes chédir bir pütün bolsun üchün u altundin ellik ilghu yasap, ikki parche yopuqni shu ilghular bilen bir-birige tutashturdi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","U muqeddes chédirni yépish üchün öchke tiwitidin yopuqlarni yasidi; yopuqtin on bir parche yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Yopuqlarning herbirining uzunluqi ottuz gez, kengliki töt gez bolup, on bir yopuqning hemmisi oxshash chong-kichiklikte qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Yopuqlarning beshini u ulap bir qilip, qalghan alte yopuqnimu ulap bir qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","U birinchi ulap chiqilghan chong parchining eng chétidiki qismigha ellik izme, ikkinchi ulap chiqilghan chong parchining eng chétidiki qismigha ellik izme qadidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","U chédir bir pütün bolsun üchün hem mistin ellik ilghu yasap, ikki chong parchini ulap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","U buningdin bashqa chédirgha qizil boyalghan qochqar térisidin yopuq yasap yapti, andin uning üstidinmu délfin térisidin yasalghan yene bir yopuqni qaplidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","U muqeddes chédirning tik taxtaylirini akatsiye yaghichidin yasap tiklidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Herbir taxtayning uzunluqi on gez, kengliki bir yérim gez qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Herbir taxtayning ikkidin turumi bar idi, her ikki taxtay shular bilen bir-birige chétildi; u chédirning barliq taxtaylirini shundaq yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","U chédirning taxtaylirini shundaq yasidi; yigirmisi jenub terepke ornitildi; ");
INSERT INTO uiglat_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","u bu yigirme taxtayning tégige kümüshtin qiriq teglik yasidi; bir taxtayning astidiki ikki turumi üchün ikkidin teglik, yene bir taxtayning ikki turumi üchün ikkidin teglikni yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Shuningdek u chédirning udul teripige, yeni shimal teripige yigirme taxtay yasidi, ");
INSERT INTO uiglat_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","shundaqla bularning qiriq teglikini kümüshtin yasidi; bir taxtayning tégige ikkidin teglik, yene bir taxtayning tégige ikkidin teglik orunlashturuldi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Chédirning keyni teripige, yeni gherb terepke alte taxtayni yasap ornatti. ");
INSERT INTO uiglat_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","U chédirning keyni teripidiki ikki bulunggha ikki taxtayni yasap ornatti. ");
INSERT INTO uiglat_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Bu bulung taxtayliri astidin üstigiche ikki qat qilip taxtaylarni özara chétishturdi, üsti bir halqigha békitildi. U her ikkisini shundaq yasap, ikki bulunggha ornatti. ");
INSERT INTO uiglat_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Shunglashqimu u teripide sekkiz taxtay boldi, ularning kümüshtin yasalghan on alte tegliki bar idi; bir taxtayning tégide ikki teglik, yene bir taxtayning tégide ikki teglik bar idi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Buningdin bashqa u akatsiye yaghichidin baldaq yasidi; chédirning bu teripidiki taxtaylargha besh baldaqni, ");
INSERT INTO uiglat_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","chédirning u teripidiki taxtaylargha besh baldaqni, chédirning arqa teripidiki taxtaylargha, yeni gherb teripidiki taxtaylarghimu besh baldaqni yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","U taxtaylarning otturidiki ottura baldaqni bu tereptin u terepke yetküzüp yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","U taxtaylarni altun bilen qaplap, baldaqlar ötküzülidighan halqilarni altundin yasap, baldaqlarni altun bilen qaplidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","U népiz toqulghan aq kanap rextke kök, sösün we qizil yiplar arilashturulup ishlen’gen bir perde yasidi; uni kérublarning süritini chéwerlik bilen layihilep nepis qilip chüshürüp, keshtilep chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Uni ésishqa u akatsiye yaghichidin töt xada yasap, altun bilen qaplidi. Ularning ilmekliri altundin yasaldi; xadilargha u kümüshtin töt teglikni quyup yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","U chédirning kirish éghizigha nepis toqulghan aq kanap rextke kök, sösün we qizil yiplar arilashturulup ishlen’gen bir perde yasidi, uni keshtichige keshtiletti. ");
INSERT INTO uiglat_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","U yene bu perdining besh xadisini ilmekliri bilen qoshup yasidi; ularning bashlirini we baldaqlirini altun bilen qaplidi; ularning besh tegliki mistin yasaldi.    ");
INSERT INTO uiglat_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Andin Bezalel ehde sanduqini akatsiye yaghichidin yasidi; uning uzunluqi ikki yérim gez, égizliki bir yérim gez, kengliki bir yérim gez idi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","U uning ichi we sirtini sap altun bilen qaplidi, uning üstünki qismining chörisige altundin girwek chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","U uning üchün altundin töt halqa quyup, ularni uning töt chétiqigha békitti; bir teripige ikki halqa, yene bir teripige ikki halqa békitti. ");
INSERT INTO uiglat_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","U hem akatsiye yaghichidin ikki baldaq yasap, her ikkisini altun bilen qaplidi; ");
INSERT INTO uiglat_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","andin sanduq ular arqiliq kötürülsun dep, baldaqlarni sanduqning ikki yénidiki halqiliridin ötküzüp qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","U sanduqning yapquchi süpitide altundin uzunluqi ikki yérim gez, kengliki bir yérim gez bolghan bir «kefarǝt texti» yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","U ikki kérubni altundin soqup yasidi; ularni kefarǝt textining ikki teripige ornatti; ");
INSERT INTO uiglat_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","bir kérubni bir teripige, yene bir kérubni yene bir teripige ornatti. U ikki teripidiki kérublarni kefarǝt texti bilen bir gewde qildi.    ");
INSERT INTO uiglat_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kérublar bir-birige yüzlinip, qanatlirini kefarǝt textining üstige kérip, qanatliri bilen uni yépip turatti; kérublarning yüzi kefarǝt textige qaritildi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","U hem shireni akatsiye yaghichidin yasidi; uning uzunluqi ikki gez, kengliki bir gez, égizliki bir yérim gez idi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","U uni sap altun bilen qaplap, uning üstünki qismining chörisige altundin girwek chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","U shirening chörisige töt ilik égizlikte bir lew yasidi; bu lewning chörisigimu altundin bir girwek chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","U shirege altundin töt halqa yasap, bu halqilarni shirening töt burjikidiki chétiqqa ornatti. ");
INSERT INTO uiglat_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Shireni kötürüshke baldaqlar ötküzülsun dep, halqilar shire léwige yéqin békitildi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Shire üchün u baldaqlarni akatsiye yaghichidin yasap, altun bilen qaplidi; shire ular bilen kötürületti. ");
INSERT INTO uiglat_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","U shirening üstige qoyulidighan barliq buyumlarni, yeni légenlirini, qacha-qucha texsilirini, sharab hediyelirini quyidighan qedeh we piyalilerning hemmisini sap altundin yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","U hem chiraghdanni sap altundin yasidi; chiraghdanni soqup yasidi; chiraghdanning puti, gholi, qedehliri, ghunchiliri we gülliri bir pütün altundin soquldi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Chiraghdanning gholining ikki yénidin alte shaxche chiqirildi — chiraghdanning bir yénidin üch shaxche, uning yene bir yénidin üch shaxche chiqirildi; ");
INSERT INTO uiglat_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","bir yénidiki herbir shaxchide badam güli sheklide ghunchisi we chéchiki bolghan üch qedeh chiqirildi, yene bir yénidiki herbir shaxchide badam güli sheklide ghunchisi we chéchiki bolghan üch qedeh chiqirildi. Chiraghdan’gha chiqirilghan alte shaxchining hemmisi shundaq yasaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Chiraghdanning gholidin badam güli sheklide ghunchisi we chéchiki bolghan töt qedeh chiqirildi.    ");
INSERT INTO uiglat_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Bulardin bashqa birinchi ikki shaxchining astida bir ghunche, ikkinchi ikki shaxchining astida bir ghunche, üchinchi ikki shaxchining astida bir ghunche yasalghanidi; chiraghdan’gha chiqirilghan alte shaxchining astining hemmisi shundaq idi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Uning shu ghunchiliri hem shaxchiliri chiraghdan bilen bir gewde qilindi — bir pütün sap altundin soqup yasaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","U chiraghdanning yette chirighini, shundaqla uning pilik qaychiliri bilen küldanlirini sap altundin yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","U chiraghdan we uning barliq eswablirini bir talant sap altundin yasidi.    ");
INSERT INTO uiglat_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","U yene xushbuygahni akatsiye yaghichidin yasidi. Uning uzunluqi bir gez, kengliki bir gez, égizliki ikki gez bolup, töt chasa qilip yasaldi; töt burjikidiki münggüzler uning bilen bir pütün qilip yasaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","U uni, yeni uning üstini, töt etrapini hem münggüzlirini sap altun bilen qaplidi; uning üsti qismining chörisige altundin girwek chiqardi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Uninggha altundin ikki halqa yasap, uning girwikining astigha békitti; ularni ikki yénigha udulmu’udul békitti. Xushbuygahni kötüridighan ikki baldaqni sélish üchün bularni xushbuygahning ikki teripige orunlashturdi.    ");
INSERT INTO uiglat_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","U baldaqlarni akatsiye yaghichidin yasap, altun bilen qaplidi. ");
INSERT INTO uiglat_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","U hem muqeddes Mesihlesh méyini yasidi, andin etirchi chiqarghandek dora-dermeklerni tengshep sap xushbuyni yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","U köydürme qurbanliq qurban’gahini akatsiye yaghichidin yasidi. Qurban’gah töt chasa bolup, uzunluqi besh gez, kengliki besh gez, égizliki üch gez qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","U uning töt burjikige qoyulidighan münggüzlirini yasidi; münggüzliri qurban’gah bilen bir gewde qilindi. Qurban’gahni mis bilen qaplidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","U qurban’gahning barliq eswablirini — uninggha xas bolghan daslarni, gürjeklerni, korilarni, laxshigirlarni we otdanlarnimu yasidi; uning barliq eswablirini mistin yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Qurban’gah üchün mistin bir shala yasidi; shalani qurban’gahning qap bélining astidiki girwektin töwenrek turidighan qildi; shala qurban’gahning del otturisida idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","U shalaning töt burjikige baldaqlar ötküzülidighan töt mis halqini quyup yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","U baldaqlarni akatsiye yaghichidin yasap, ularni mis bilen qaplidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Andin u qurban’gahni kötürüsh üchün baldaqlarni qurban’gahning ikki yénidiki halqilargha ötküzüp qoydi. U qurban’gahni taxtaylardin, ichini bosh qilip yasidi.    ");
INSERT INTO uiglat_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","U yene yuyunush désini mistin, uning teglikinimu mistin yasidi; u bularni «körüshüsh chédiri»ning kirish éghizining aldida xizmette bolghan ayallarning mis eynekliridin yasidi.    ");
INSERT INTO uiglat_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Andin u chédirning hoylisinimu yasidi. Hoylining jenubigha, yeni jenubqa yüzlen’gen teripige népiz toqulghan aq kanap rexttin perdilerni yasidi; uning uzunluqi yüz gez idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Perdilerni ésishqa yigirme xada we xadilarning yigirme teglikini u mistin yasidi. Xadilarning ilmekliri we baldaqliri kümüshtin yasalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Shuninggha oxshash shimal teripidimu uzunluqi yüz gez kélidighan perde bar idi. Perdilerni ésishqa yigirme xada we xadilarning yigirme teglikini u mistin yasidi. Xadilarning ilmekliri we baldaqliri kümüshtin yasalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Shuninggha oxshash gherb teripide uzunluqi ellik gez kélidighan perde bar idi; perdilerni ésishqa on xada we xadilarning on teglikini u mistin yasidi. Xadilarning ilmekliri we baldaqliri kümüshtin yasaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Hoylining sherq teripi, yeni kün chiqishqa yüzlen’gen teripining kengliki ellik gez idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Bir teripide on besh gez kélidighan perde bolup, uning üch xadisi bilen üch tegliki bar idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Yene bir teripidimu on besh gez kélidighan perde bolup, uning üch xadisi bilen üch tegliki bar idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Hoylining chörisidiki perdilerning hemmisi népiz toqulghan aq kanap rexttin tikilgenidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Hoylining chörisidiki hemme xadilarning tegliki mistin, ularning ilmekliri we baldaqliri kümüshtin yasaldi; xadilarning bashlirimu kümüshtin qaplan’ghanidi. Hoylining chörisidiki hemme xadilar kümüshtin yasalghan baldaqlar bilen bir-birige chétildi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Hoylining kirish éghizidiki perde népiz toqulghan aq kanap rextke kök, sösün we qizil yiplar arilashturulup, keshtichiler teripidin keshtilendi; uning uzunluqi yigirme gez, égizliki hoylidiki perdilerning égizlikige oxshash bolup besh gez idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Uning töt xadisi bilen mistin yasalghan töt tegliki bar idi; xadilarning ilmekliri kümüshtin yasaldi, ularning bashliri kümüsh bilen qaplandi we baldaqliri kümüshtin yasaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Muqeddes chédirning hem chörisidiki hoylining barliq miq-qozuqliri mistin yasaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Muqeddes chédir, yeni «höküm-guwahliqi chédiri» üchün atalghan matériyallarning sani töwende xatirilen’gen (ular Musaning buyruqi bilen, kahin Harunning oghli Itamarning qol astidiki Lawiylar mes’ul bolup sanaqtin ötküzülüp, Xudagha atalghanidi): — ");
INSERT INTO uiglat_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Yehuda qebilisidin bolghan Xurning newrisi, Urining oghli Bezalel Perwerdigar Musagha buyrughanning hemmisini ada qildi; ");
INSERT INTO uiglat_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Dan qebilisidin bolghan Ahisamaqning oghli Oholiyab uning yardemchisi idi; u bolsa neqqashliq-oymichiliq ustisi, layihiligüchi hemde kök, sösün, qizil yiptin aq kanap rextke keshte tikeleydighan usta idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Muqeddes chédirni yasashqa ishlitilgen altun, yeni «pulanglatma hediye» süpitide keltürülgen altunning hemmisi muqeddes jaydiki shekelning ölchem birliki boyiche yigirme toqquz talant yette yüz ottuz shekel idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Jamaet arisidin sanaqtin ötküzülgen ademler teripidin keltürülgen kümüsh bolsa muqeddes jaydiki shekelning ölchem birliki boyiche bir yüz talant bir ming yette yüz yetmish besh shekel idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Bu kümüsh nopusi royxetke élin’ghan kishilerdin élin’ghanidi — démek, kimki yigirme yash ya uningdin chong, sanaqtin ötküzülgenlerning herbiri bir béka, yeni muqeddes jaydiki shekelning ölchem birliki boyiche yérim shekel kümüsh berdi. Sanaqtin ötken kishi alte yüz üch ming besh yüz ellik kishi idi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Muqeddes jayning tegliklirini hem otturisidiki perdining tegliklirini quyushqa yüz talant kümüsh ketti; yüz talant kümüshtin yüz teglik yasilip, herbir teglik üchün bir talant ishlitildi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","U qalghan bir ming yette yüz yetmish besh shekel kümüshtin xadilarning ilmeklirini yasidi, ularning bashlirini qaplidi, shuningdek ularni bir-birige chatidighan baldaqlarni yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","«Pulanglatma hediye» süpitide keltürülgen mis bolsa yetmish talant, ikki ming töt yüz shekel chiqti. ");
INSERT INTO uiglat_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Buningdin u jamaet chédirining kirish éghizining tegliklirini, mis qurban’gahni, uning mis shalasi we qurban’gahning barliq eswablirini, ");
INSERT INTO uiglat_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","hoylining chörisidiki xada tegliklirini, hoylining kirish éghizidiki tegliklerni, chédirning barliq qozuqlirini we hoylining chörisidiki qozuqlarning hemmisini yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Perwerdigar Musagha buyrughinidek kök, sösün we qizil yiplar ishlitilip, muqeddes chédirning xizmitide kiyilidighan kahinliq kiyimler, shundaqla Harunning muqeddes kiyimliri teyyar qilindi.    ");
INSERT INTO uiglat_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bezalel altun we kök, sösün, qizil yiplar bilen népiz toqulghan aq kanap rextlerdin efodni yasap teyyarlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ular altunni soqup népiz qilip, uni késip yip qildi, andin bularni mahirliq bilen kök yiplar, sösün yiplar we qizil yiplardin aq kanap rextke lahayilen’gen nusxilar üstige toqudi.    ");
INSERT INTO uiglat_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ular efodning aldi we keyni qismini bir-birge tutashturup turidighan ikki mürilik tasma yasidi; efodning ikki teripi bir-birige tutashturuldi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Efodning üstige baghlaydighan belwagh efod bilen bir pütün qilin’ghan bolup, uninggha oxshash sipta ishlinip, altun we kök, sösün, qizil yiplar we népiz toqulghan aq kanap rexttin yasaldi; hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ular ikki aq héqiqni ikki altun közlükke ornitip, ularning üstige xuddi möhür oyghandek Israilning oghullirining namlirini oyup yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Israilning oghullirigha esletme tash bolsun üchün, Perwerdigar Musagha buyrughandek ikki yaqutni efodning ikki mürilik tasmisigha békitip qoydi.    ");
INSERT INTO uiglat_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","U qoshénni chéwer qollargha nepis qilip keshtilitip yasidi; uni efodni ishligen usulda altun we kök, sösün, qizil yiplar bilen népiz toqulghan aq kanap rexttin yasidi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ular qoshénni ikki qat, töt chasa qilip yasidi; ikki qat qilin’ghanda uzunluqi bir ghérich, kenglikimu bir ghérich kéletti. ");
INSERT INTO uiglat_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Uning üstige töt qatar qilip göherlerni ornatti: — bir qatardikisi qizil yaqut, sériq göher we zumretler idi; bu birinchi qatar idi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ikkinchi qatargha kök qashtéshi, kök yaqut we almas, ");
INSERT INTO uiglat_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","üchinchi qatargha sösün yaqut, piroza we sösün kwarts, ");
INSERT INTO uiglat_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","tötinchi qatargha béril yaqut, aq héqiq we anartash ornitildi; bularning hemmisi altun közlükke békitildi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Bu göherler Israilning oghullirining namlirigha wekil qilinip, ularning sanidek on ikki bolup, möhür oyghandek herbir göherge on ikki qebilining nami birdin-birdin pütüldi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ular qoshén’gha shoynidek éshilgen sap altundin ikki éshilme zenjir yasidi; ");
INSERT INTO uiglat_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ular qoshén’gha altundin ikki közlük we ikki halqa étip, ikki halqini qoshénning yuqiriqi ikki burjikige békitti; ");
INSERT INTO uiglat_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","andin shu altundin éshilip yasalghan ikki zenjirni qoshénning yuqiriqi ikki burjikidiki halqidin ötküzüp, ");
INSERT INTO uiglat_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","éshilgen shu zenjirlerning ikki uchini ikki közlükke békitip, közlüklerni efodning ikki mürilik tasmisining aldi qismigha ornatti. ");
INSERT INTO uiglat_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Buningdin bashqa ular altundin ikki halqa yasap, ularni qoshénning asti teripidiki ikki burjikige békitti; ular efodqa tégiship turidighan qilinip ichige qadaldi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Mundin bashqa ular altundin yene ikki halqa yasap, ularni efodning ikki mürilik tasmisining aldi töwenki qismigha, efodqa ulinidighan jaygha yéqin, keshitilen’gen belwaghdin égizrek qilip békitti. ");
INSERT INTO uiglat_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ular qoshénning efodning belwéghidin yuqiriraq turushi, qoshénning efodtin ajrap ketmesliki üchün kök shoyna bilen qoshénning halqisini efodning halqisigha chétip qoydi. Bularning hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bezalel efodning ichidiki tonni pütünley kök renglik qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Tonning bashqa kiyilidighan töshüki del otturisida, xuddi sawutning yaqisidek ishlen’genidi; yirtilip ketmesliki üchün uning chörisige pewaz ishlendi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ular tonning étikining chörisige kök, sösün we qizil yiptin anarlarni toqup ésip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ular hemde altun qongghuraqlarni yasap, qongghuraqlarni tonning étikining chörisige, anarlarning ariliqigha birdin ésip qoydi; her ikki anarning otturisigha bir qongghuraq ésip qoyuldi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Qahinliq xizmitige ait qongghuraqlar tonning étikining chörisige békitildi; bir altun qongghuraq, bir anar, bir altun qongghuraq, bir anar qilip békitildi; hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ular Harun bilen uning oghullirigha népiz toqulghan aq kanap rexttin xalta köngleklerni tikti; ");
INSERT INTO uiglat_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","sellini aq kanap rextte yasidi, shundaqla chirayliq égiz böklerni aq kanap rextte, tamballarni népiz toqulghan aq kanap rextte teyyarlidi; ");
INSERT INTO uiglat_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","buningdin bashqa ular belwaghnimu kök, sösün we qizil yip arilashturulup keshtilen’gen, népiz toqulghan aq kanap rextte teyyarlidi; bularning hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ular yene nepis taxtayni, yeni muqeddes otughatni sap altundin yasap, uning üstige möhür oyghandek: «Perwerdigargha muqeddes qilindi» dep oyup pütti; ");
INSERT INTO uiglat_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ular otughatqa kök renglik yipni baghlap, uning bilen otughatni sellige taqidi, bular Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Shu teriqide jamaetning ibadet chédirining hemme qurulushi pütküzüldi; Israillar Perwerdigarning Musagha buyrughinining hemmisini shu boyiche qildi; shu teriqide hemmisini püttürdi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ular chédirni Musaning yénigha élip keldi — chédir yopuqlirini, uning barliq eswablirini, ilmeklirini, taxtaylirini, baldaqlirini, xadiliri bilen tegliklirini, ");
INSERT INTO uiglat_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","shuningdek qizil boyalghan qochqar térisidin yasalghan yopuq bilen délfin térisidin yasalghan yopuqni, «ayrima perde»ni, ");
INSERT INTO uiglat_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ehde sanduqi we uning baldaqlirini, «kefarǝt texti»ni, ");
INSERT INTO uiglat_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","shire we uning barliq eswablirini, shundaqla «teqdim nanlar»ni, ");
INSERT INTO uiglat_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","sap altundin yasalghan chiraghdan bilen uning chiraghlirini, yeni üstige tizilghan chiraghlarni, uning barliq eswabliri hem chiragh méyini, ");
INSERT INTO uiglat_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","altun xushbuygah, mesihlesh méyi, dora-dermeklerdin yasalghan xushbuyni, chédirning kirish éghizining perdisini, ");
INSERT INTO uiglat_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","mis qurban’gah bilen uning mis shalasini, uning baldaqliri bilen hemme eswablirini, yuyush dési bilen uning teglikini, ");
INSERT INTO uiglat_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","hoylining chörisidiki perdilerni, uning xadiliri we ularning tegliklirini, hoylining kirish éghizining perdisi bilen hoylining taniliri we qozuqlirini, muqeddes chédirning, yeni jamaet chédirigha ait xizmetke ishlitilidighan barliq eswablarni, ");
INSERT INTO uiglat_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","muqeddes jaygha ait xizmet üchün tikilgen kahinliq kiyimini, yeni Harun kahinning muqeddes kiyimliri bilen uning oghullirining kahinliq kiyimlirini bolsa, hemmisini élip keldi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Bu ishlarning hemmisini Israillar Perwerdigarning Musagha barliq buyrughanliri boyiche ene shundaq ada qilghanidi. ");
INSERT INTO uiglat_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa ishlarning hemmisige tepsiliy qaridi, mana, ular Perwerdigarning buyrughini boyiche bu ishlarni pütküzgenidi; buyrulghandek, del shundaq qilghanidi; Musa bularni körüp, ulargha bext-beriket tilep dua qildi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Andin Perwerdigar Musagha mundaq emr qildi: — ");
INSERT INTO uiglat_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Birinchi ayning béshi, ayning birinchi küni sen jamaet chédirining muqeddesxanisini tikligin. ");
INSERT INTO uiglat_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Höküm-guwahliq sanduqini uning ichige qoyup, ichki perde arqiliq ehde sanduqini tosup qoyghin; ");
INSERT INTO uiglat_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","shireni chédirning ichige ekirip, üstige tizilidighan nersilerni tizghin; andin chiraghdanni ekirip, üstige chiraghlarni orunlashturghin.    ");
INSERT INTO uiglat_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Altun bilen qaplan’ghan xushbuy köydürgüchi qurban’gahni höküm-guwahliq sanduqining uduligha tiklep qoyghin; chédirning kirish éghizining perdisini ésip qoyghin.    ");
INSERT INTO uiglat_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Köydürme qurbanliq qurban’gahini muqeddesxanining, yeni jamaet chédirining kirish éghizining aldigha qoyghin; ");
INSERT INTO uiglat_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","andin yuyush désini jamaet chédiri bilen qurban’gahning otturisigha orunlashturup, su toshturup qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Hoylining chörisige perdilerni békitip, hoylining kirish éghizining perdisini asqin; ");
INSERT INTO uiglat_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","andin «mesihlesh méyi»ni élip, ibadet chédiri we uning ichidiki barliq nersilerni mesihlep, uni we barliq hemme eswablirini Xudagha atap muqeddes qilghin. Shundaq qilip pütkül chédir muqeddes bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Sen köydürme qurbanliq qurban’gahini, shundaqla uning barliq eswablirini mesihlep, uni Xudagha atap muqeddes qilghin; buning bilen qurban’gah «eng muqeddes nersiler» qatarida bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Sen yene yuyunush dési we uning teglikini mesihlep muqeddes qilghin. ");
INSERT INTO uiglat_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Andin Harun bilen uning oghullirini jamaet chédirining kirish éghizigha yéqin ekilip, ularni su bilen yughin; ");
INSERT INTO uiglat_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Harun’gha muqeddes kiyimlerni kiydürüp, Manga kahinliq xizmette bolushi üchün uni mesihlep, Manga ayrip muqeddes qilghin. ");
INSERT INTO uiglat_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Andin uning oghullirini élip kirip, ulargha xalta köngleklerni kiydürüp, ");
INSERT INTO uiglat_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ularning atisini mesihliginingdek Manga kahinliq xizmitide bolushi üchün ularnimu mesihligin. Shuning bilen ularning bu mesihlinishi ular üchün ewladtin ewladqiche ebediy kahinliqning belgisi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa shundaq qildi; Perwerdigar uninggha néme buyrughan bolsa, u shundaq beja keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Shundaq boldiki, ikkinchi yilning birinchi éyida, ayning birinchi künide ibadet chédiri tiklendi.    ");
INSERT INTO uiglat_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa chédirni tikip, tegliklirini orunlashturup, taxtaylirini tizip, ularning baldaqlirini békitip, xadilirini tiklidi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Muqeddes chédirning üstige ichki yopuqni yapti, andin uning üstige tashqi yopuqni yépip qoydi; bularning hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Andin u höküm-guwahliqni élip, uni sanduq ichige qoydi; baldaqlarni ehde sanduqining halqiliridin ötküzüp, «kefarǝt texti»ni sanduqning üstige orunlashturdi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ehde sanduqini muqeddes chédir ichige élip kirip, otturigha «ayrima perde»ni tartti; shundaq qilip u höküm-guwahliq sanduqini perde arqiliq tosup qoydi. Hemme ish Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","U shireni jamaet chédirigha élip kirip, muqeddes jayning shimal teripige, «eng muqeddes jay»diki perdining sirtigha qoydi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","«Teqdim nanlar»ni shirening üstige, Perwerdigarning aldigha tizip qoydi; bularning hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Andin u chiraghdanni jamaet chédirigha élip kirip, uni muqeddes jayning jenub teripige, shirening uduligha qoydi, ");
INSERT INTO uiglat_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","chiraghlarni Perwerdigarning aldigha orunlashturdi; bularning hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Andin u xushbuyni köydürgüchi altun qurban’gahni ichidiki perdining aldigha tiklidi; ");
INSERT INTO uiglat_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Uning üstide ésil xushbuyni köydürdi; bularning hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","U ibadet chédirining kirish éghizigha perde tartti. ");
INSERT INTO uiglat_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Andin köydürme qurbanliq qurban’gahini jamaet chédiridiki muqeddes jayning kirish éghizigha yéqin qoydi; uning üstide köydürme qurbanliq we qoshumche ashliq hediyesini ötküzdi; bularning hemmisi Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Yuyunush désini jamaet chédiri bilen qurban’gahning otturisigha qoyup, yuyushqa ishlitilidighan suni dasqa toshquzup quydi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","Musa we Harun bilen uning oghulliri qachanla jamaet chédirigha kirse yaki qurban’gahqa yéqin barsa, Perwerdigarning Musagha buyrughinidek qollirini shu suda yuyatti. Bular Perwerdigarning Musagha buyrughinidek qilindi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Andin u chédir hem qurban’gahning etrapigha hoyla perdisini tiklep, hoylining kirish éghizining perdisini tartti. Shu teriqide Musa pütkül ishni tamamlidi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Shuning bilen bulut jamaet chédirini qaplap, Perwerdigarning julasi ibadet chédirini toldurdi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Bulut saye chüshürüp, Perwerdigarning julasi chédirni toldurghini üchün, Musa jamaet chédirigha kirelmidi. ");
INSERT INTO uiglat_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Qachanki bulut jamaet chédiridin kötürülse, Israillar seperge atlinatti. Herbir qétim seperde shundaq bolatti. ");
INSERT INTO uiglat_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Bulut kötürülmise ular qozghalmay, taki kötürülidighan kün’giche seperge chiqmaytti. ");
INSERT INTO uiglat_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Chünki kündüzi Perwerdigarning buluti muqeddes chédir üstide turatti, kéchisi uning üstide ot körünetti; pütkül Israil jemetining köz aldida ularning barliq qilghan seperliride shular körünetti. ");
INSERT INTO uiglat_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","We Perwerdigar Musani chaqirip jamaet chédiridin uninggha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Sen Israillargha söz qilip ulargha mundaq dégin: — Eger silerdin biringlar Perwerdigarning aldigha bir qurbanliqni sunmaqchi bolsanglar, qurbanliqinglarni charpaylardin, yeni kala yaki ushshaq mallardin sunushunglar kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Eger uning sunidighini kalilardin köydürme qurbanliq bolsa, undaqta u béjirim erkek haywanni keltürsun; uning Perwerdigarning aldida qobul bolushi üchün uni jamaet chédirining kirish aghzining aldida sunsun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","U qolini köydürme qurbanliqning béshigha qoysun; shuning bilen qurbanliq uning ornigha kefarǝt bolushqa qobul qilinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Andin u Perwerdigarning huzurida buqini boghuzlisun; kahinlar bolghan Harunning oghulliri qénini keltürüp, jamaet chédirining kirish aghzidiki qurban’gahning üsti qismining etrapigha sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Andin qurbanliq qilghuchi köydürme qurbanliq qilin’ghan haywanning térisini soyup, ténini parchilisun ");
INSERT INTO uiglat_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","we Harun kahinning oghulliri qurban’gahta ot qalap otning üstige otunlarni tizsun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Andin kahinlar bolghan Harunning oghulliri gösh parchilirini, béshi we méyi bilen qoshup, qurban’gahdiki otning üstidiki otunning üstige tertip bilen tizip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Lékin uning ich-qarni bilen pachaqlirini qurbanliq sun’ghuchi suda yusun; andin kahin hemmisini élip kélip qurban’gahning üstide köydürsun. Bu ot arqiliq sunulidighan qurbanliq hésabida, Perwerdigargha xushbuy chiqirilidighan köydürme qurbanliq bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Eger u köydürme qurbanliq qilish üchün ushshaq mallardin qoy ya öchke qurbanliq qilay dése, undaqta u béjirim bolghan bir erkikini keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","U uni qurban’gahning shimal teripide Perwerdigarning huzurida boghuzlisun. Andin kahinlar bolghan Harunning oghulliri qénini élip, qurban’gahning üsti qismining etrapigha sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","qurbanliq qilghuchi bolsa göshni parchilap, béshi bilen méyini késip ayrisun. Andin kahin bularni élip qurban’gahtiki otning üstidiki otunning üstide tertip boyiche tizip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Lékin uning ich-qarni bilen pachaqlarni qurbanliq sun’ghuchi suda yusun; andin kahin hemmisini élip kélip qurban’gahning üstide köydürsun. Bu ot arqiliq sunulidighan qurbanliq hésabida, Perwerdigargha xushbuy chiqirilidighan köydürme qurbanliq bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Eger qurbanliq qilghuchi Perwerdigargha atap uchar-qanatlardin köydürme qurbanliq qilay dése, undaqta u paxteklerdin yaki kepter bachkiliridin qurbanliq keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kahin uni qurban’gahning yénigha élip kélip, béshini tolghap üzüp uni qurban’gahning üstide köydürsun; uning qéni siqilip qurban’gahning témigha sürtülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Lékin tashliqini peyliri bilen qoshup qurban’gahning sherq teripidiki küllükke tashliwetsun; ");
INSERT INTO uiglat_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","u qurbanliqni ikki qanitining otturisidin yarsun, biraq uni ikki parche qiliwetmisun. Andin kahin buni élip qurban’gahdiki otning üstidiki otunning üstige qoyup köydürsun; bu ot arqiliq sunulidighan qurbanliq hésabida, Perwerdigargha xushbuy chiqirilidighan köydürme qurbanliq bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Eger birkim Perwerdigarning huzurigha ashliq hediyesi sunmaqchi bolsa hediyesi ésil undin bolushi kérek; u uninggha zeytun méyi quyup andin üstige mestiki salsun.    ");
INSERT INTO uiglat_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","U uni élip kahinlar bolghan Harunning oghullirining aldigha keltürsun; andin kahin hediye sun’ghuchining yadlinishi üchün zeytun méyi ileshtürülgen undin bir changgal élip, hemme mestiki bilen qoshup, bu hediyeni qurban’gahta köydürsun; bu ot arqiliq sunulidighan, Perwerdigargha xushbuy chiqirilidighan hediye bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Emma ashliq hediyesidin qalghini bolsa, Harun bilen uning oghullirigha tewe bolsun. Bu Perwerdigargha ot arqiliq sunulghanlarning ichide «eng muqeddeslerning biri» hésablinidu.    ");
INSERT INTO uiglat_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Eger sen tonurda pishurulghan nersilerdin ashliq hediyesi sunay déseng, ular zeytun méyi ileshtürülgen ésil undin pishurulghan toqachlar yaki zeytun méyi sürülüp mesihlen’gen pétir hemek nanlardin bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Eger séning keltüridighan hediyeng tawida pishurulghan ashliq hediyesi bolsa u zeytun méyi ishleshtürülüp ésil undin pétir halda étilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Sen uni oshtup üstige zeytun méyi quyghin; u ashliq hediyesi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Séning keltüridighan hediyeng qazanda pishurulghan ashliq hediyesi bolsa undaqta u ésil un bilen zeytun méyida étilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Shu yollarda teyyarlan’ghan ashliq hediyelirini Perwerdigarning huzurigha keltürgin; uni kahin’gha bergin, u uni qurban’gahqa élip baridu. ");
INSERT INTO uiglat_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kahin bolsa ashliq hediyesidin «yadlinish ülüshi»ni élip qurban’gahning üstide köydürsun. Bu ot arqiliq sunulidighan, Perwerdigargha xushbuy chiqirilidighan hediye bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Emma ashliq hediyesidin qalghini bolsa, Harun bilen uning oghullirigha tewe bolsun. Bu Perwerdigargha ot arqiliq sunulghanlarning ichide «eng muqeddeslerning biri» hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Siler Perwerdigarning huzurigha sunidighan herqandaq ashliq hediyeliri échitqu bilen teyyarlanmisun. Chünki silerning Perwerdigargha otta sunulidighan hediyenglarning héchqaysisida échitqu yaki heselni köydürüshke bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Bularni Perwerdigarning aldigha «deslepki hosul» süpitide sunsanglar bolidu, lékin ular xushbuy süpitide qurban’gahning üstide köydürülüp sunulmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Séning herbir ashliq hediyeng tuz bilen tuzlinishi kérek; hediyengni Xudayingning ehde tuzidin mehrum qilmay, hemme ashliq hediyeliringni tuz bilen tuzlighin. ");
INSERT INTO uiglat_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Eger sen Perwerdigargha «deslepki hosul»din ashliq hediyesi sunay déseng, undaqta ziraetning yéngi pishqan kök béshini élip, danlarni otta qorup, ézip talqan süpitide sun’ghin; bu «deslepki hosul» hediyesi bolidu; ");
INSERT INTO uiglat_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","sen uninggha zeytun méyi quyup üstige mestiki salghin; bu ashliq hediyesi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kahin bolsa uningdin, yeni qorup ézilgen danlar bilen zeytun méyidin bir qismini élip hemme mestiki bilen qoshup, bolarni «yadlinish ülüshi» süpitide köydürsun. Bu ot arqiliq Perwerdigargha sunulghan hediye bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Birsining sunidighini inaqliq qurbanliqi bolsa, shundaqla kalilardin sunsa, u Perwerdigarning huzurigha béjirim bir erkikini yaki chishisini keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","U sunidighan bu haywanning béshigha qolini qoyup, andin uni jamaet chédirining kirish éghizi aldida boghuzlisun. Andin kahinlar bolghan Harunning oghulliri qénini qurban’gahning üsti qismining etrapigha sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Sun’ghuchi kishi bu inaqliq qurbanliqidin Perwerdigargha atap otta sunulidighan hediye süpitide bir qismini élip béghishlisun, yeni ich qarnini yögep turghan mayni, shundaqla barliq ich méyini élip ");
INSERT INTO uiglat_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ikki börekni we ularning üstidiki hemde ikki yanpishidiki mayni ajritip, jigerning börekkiche bolghan chawa méyini késip, élip kelsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Harunning oghulliri bolsa bularni qurban’gahning üstige keltürüp ot üstige qoyulghan otunning üstidiki köydürme qurbanliqqa qoshup köydürsun. Bu ot arqiliq sunulidighan, Perwerdigargha xushbuy chiqirilidighan qurbanliq bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Birsining Perwerdigargha qilidighan inaqliq qurbanliqi üchün sunidighini ushshaq maldin bolsa, undaqta u béjirim bir erkikini yaki chishisini keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Eger uning qurbanliqi qoy bolsa uni Perwerdigarning aldigha keltürüp, ");
INSERT INTO uiglat_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","qurbanliq qilidighan bu haywanning béshigha qolini qoyup, andin uni jamaet chédirining kirish aghzining aldida boghuzlisun. Andin Harunning oghulliri qénini élip qurban’gahning üsti qismining etrapigha sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Sun’ghuchi kishi bu inaqliq qurbanliqidin Perwerdigargha atap otta sunulidighan hediye süpitide bir qismini, yeni uning méyini élip béghishlisun, — pütün mayliq quyruqini uning omurtqisigha yéqin yerdin ajritip élip, ich qarnini yögep turghan mayni, shundaqla barliq ich méyini élip, ");
INSERT INTO uiglat_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ikki börekni we ularning üstidiki hemde ikki yanpishidiki mayni ajritip, jigerning börekkiche bolghan chawa méyini késip, élip kelsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kahin bularni qurban’gahning üstide köydürsun; bu otta sunulidighan, Perwerdigargha atalghan taam hediyesi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Uning sunidighini öchke bolsa, buni Perwerdigarning huzurigha keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","U qolini uning béshigha qoyup, andin uni jamaet chédirining aldida boghuzlisun. Andin Harunning oghulliri qénini élip qurban’gahning üsti qismining etrapigha sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Andin sun’ghuchi kishi bu qurbanliqtin Perwerdigargha atap otta sunulidighan hediye süpitide bir qismini élip béghishlisun, yeni ich qarnini yögep turghan mayni, shundaqla barliq ich méyini élip, ");
INSERT INTO uiglat_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ikki börekni we ularning üstidiki hemde ikki yanpishidiki mayni ajritip, jigerning börekkiche bolghan chawa méyini késip, élip kelsun. ");
INSERT INTO uiglat_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kahin bularni qurban’gahning üstide köydürsun; bu otta sunulidighan, xushbuy chiqiridighan taam hediyesi bolidu. Mayning hemmisi Perwerdigargha tewedur. ");
INSERT INTO uiglat_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Bu herqandaq turar jayinglarda silerge ebediy belgilime bolidu; siler héchqandaq may yaki qan yémeslikinglar kérek.    ");
INSERT INTO uiglat_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Israillargha söz qilip mundaq dégin: — «Birsi bilmey ézip, Perwerdigar «qilma» dep buyrughan herqandaq emrlerdin birige xilapliq qilip sélip, gunah qilsa, töwendikidek qilsun: — ");
INSERT INTO uiglat_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","— eger mesihlen’gen kahin xelqni gunahqa putlashturidighan bir gunahni qilsa, undaqta u bu qilghan gunahi üchün bir béjirim yash torpaqni élip kélip, Perwerdigargha gunah qurbanliqi süpitide sunsun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","U torpaqni jamaet chédirining kirish aghzining yénigha, Perwerdigarning aldigha keltürüp, qolini uning béshigha qoyup, andin torpaqni Perwerdigarning huzurida boghuzlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Andin mesihlen’gen kahin torpaqning qénidin azghina élip, jamaet chédiri ichige kötürüp aparsun; ");
INSERT INTO uiglat_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","kahin shu yerde barmiqini qan’gha chilap, qanni eng muqeddes jayning perdisining aldida, Perwerdigarning huzurida yette mertiwe sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Shundaqla kahin qandin élip, jamaet chédiri ichide Perwerdigarning aldida turghan xushbuygahning münggüzlirige sürsun. Torpaqning qalghan hemme qénini bolsa, jamaet chédirining kirish aghzining aldidiki köydürme qurbanliq qurban’gahining tüwige töküp qoysun; ");
INSERT INTO uiglat_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","andin u gunah qurbanliqi bolghan torpaqning ichidin hemme méyini ajritip chiqarsun — yeni ich qarnini yögep turghan may bilen qalghan ich méyi, ");
INSERT INTO uiglat_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ikki börekni we ularning üstidiki hemde ikki yanpishidiki mayni ajritip, jigerning börekkiche bolghan chawa méyini ajratsun ");
INSERT INTO uiglat_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(xuddi inaqliq qurbanliqi bolghan kalining ichidiki may ajritilghandek); andin kahin bularni köydürme qurbanliq qurban’gahining üstide köydürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Lékin torpaqning térisi bilen hemme göshi, bash bilen pachaqliri, ich qarni bilen zhinini, ");
INSERT INTO uiglat_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","yeni pütkül torpaqning qalghan qisimlirini chédirgahning sirtigha élip chiqip, pak bir yerge, yeni küller tökülidighan jaygha élip chiqip, otunning üstide otta köydürsun. Bular küller tökülidighan jayda köydürüwétilsun.    ");
INSERT INTO uiglat_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Eger pütkül Israil jamaiti özi bilmigen halda ézip gunah qilghan bolsa, Perwerdigarning «qilma» dep buyrughan herqandaq emrlirige xilapliq ishlarning birini qilip sélip, gunahqa chüshüp qalsa,    ");
INSERT INTO uiglat_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","shundaqla ularning sadir qilghan gunahi aydinglashqan bolsa, undaqta jamaet gunah qurbanliqi süpitide bir yash torpaqni sunup jamaet chédirining aldigha keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Jamaetning aqsaqalliri Perwerdigarning aldida qollirini torpaqning béshigha qoyup, andin torpaqni Perwerdigarning aldida boghuzlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Mesihlen’gen kahin torpaqning qénidin azghina élip jamaet chédiri ichige élip kirsun; ");
INSERT INTO uiglat_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","shu yerde barmiqini qan’gha chilap, qanni eng muqeddes jayning perdisining aldida, Perwerdigarning huzurida yette mertiwe sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Shundaqla kahin qandin élip jamaet chédiri ichide Perwerdigarning aldida turghan xushbuygahning münggüzlirige sürsun. Torpaqning qalghan hemme qénini bolsa, jamaet chédirining kirish aghzining aldidiki köydürme qurbanliq qurban’gahining tüwige töküp qoysun; ");
INSERT INTO uiglat_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","kahin torpaqning ichidin barliq méyini ajritip élip, qurban’gahning üstide köydürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","U gunah qurbanliqi bolghan ilgiriki torpaqni qilghinigha oxshash bu torpaqnimu shundaq qilsun; we del shundaq qilishi kérek; shu yol bilen kahin ular üchün kefarǝt keltüridu; shu gunah ulardin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Andin u torpaqni chédirgahning tashqirigha élip chiqip, ilgiriki torpaqni köydürgendek bu torpaqnimu köydürsun. Bu jamaet üchün gunah qurbanliqi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Eger bir emir bilmey uning Xudasi Perwerdigarning «qilma» dégen herqandaq emrlirining birige xilapliq qilip sélip, gunahqa chüshüp qalsa, ");
INSERT INTO uiglat_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","we qilghan gunahi özige melum qilin’ghan bolsa, undaqta u özi qurbanliq üchün béjirim bir tékini sunsun; ");
INSERT INTO uiglat_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","u qolini tékining béshigha qoyup, andin uni köydürme qurbanliq qilinidighan haywanlarni boghuzlaydighan jaygha élip bérip Perwerdigarning aldida boghuzlisun. Bu bir gunah qurbanliqi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kahin gunah qurbanliqining qénidin barmiqigha azghina élip, uni köydürme qurbanliq qurban’gahining münggüzlirige sürüp qoysun; andin qalghan qénini köydürme qurbanliq qurban’gahining tüwige töküp qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","U inaqliq qurbanliqi qilin’ghan haywanning méyini köydürgendek, uning barliq méyini qurban’gahta köydürsun. Bu yol bilen kahin uni gunahidin paklandurush üchün kefarǝt keltüridu we shu gunahi uningdin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Eger puqralardin biri bilmey uning Xudasi Perwerdigarning «qilma» dégen herqandaq emrlirining birige xilapliq qilip sélip, gunahqa chüshüp qalsa, ");
INSERT INTO uiglat_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","we qilghan gunahi özige melum qilin’ghan bolsa, undaqta u özining, yeni u sadir qilghan gunahi üchün qurbanliq qilishqa béjirim bir chishi öchkini sunsun; ");
INSERT INTO uiglat_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","u qolini gunah qurbanliqining béshigha qoyup, andin uni köydürme qurbanliqlarni boghuzlaydighan jaygha élip bérip boghuzlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Andin kahin uning qénidin barmiqigha azghina élip uni köydürme qurbanliq qurban’gahining münggüzlirige sürüp qoysun; qalghan barliq qénini qurban’gahning tüwige töküp qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Inaqliq qurbanliqi qilin’ghan haywanning méyi ichidin ajritilghandek uningmu hemme méyini ajritip chiqarsun; kahin uni Perwerdigarning aldida xushbuy keltürsun dep qurban’gahning üstide köydürsun. Shu yol bilen kahin uning üchün kefarǝt keltüridu; shu gunah uningdin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Eger u kishi gunah qurbanliqi üchün qoza keltürüshni xalisa, béjirim bir chishi qozini sunsun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","U qolini gunah qurbanliqi qozisining béshigha qoyup, köydürme qurbanliqlar boghuzlinidighan jaygha élip bérip, uni gunah qurbanliqi süpitide boghuzlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Andin kahin gunah qurbanliqining qénidin barmiqigha azghina élip uni köydürme qurbanliq qurban’gahining münggüzlirige sürüp qoysun; uning qalghan barliq qénini u qurban’gahning tüwige töküp qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Inaqliq qurbanliqi qilin’ghan qozining méyi ichidin ajritilghandek, uningmu hemme méyini ajritip chiqarsun; kahin bularni Perwerdigargha atap otta sunulidighan barliq qurbanliqlargha qoshup, qurban’gahning üstide köydürsun. Shu yol bilen kahin uning sadir qilghan gunahi üchün kefarǝt keltüridu; shu gunah uningdin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Eger birsi melum ishqa guwahchi bolup, shundaqla uninggha qesem buyrulghinida körgini yaki bilginidin melumat bermise, undaqta u qebihlikining jazasigha tartilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Eger birsi özi bilmey napak bir nersige tégip ketse — meyli u napak bir haywanning jesiti bolsun, meyli napak bir charpayning jesiti bolsun, yaki napak bir ömiligüchi haywanning jesiti bolsun, mushundaq nersige tégip ketse umu napak sanilip gunahkar hésablinidu; ");
INSERT INTO uiglat_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","eger shuningdek birsi özi tuymay melum kishining ademni napak qilidighan herqandaq nijasitige tégip ketse, shundaqla u buni bilip yetse, undaqta u gunahkar hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Eger birsi angsiz rewishte yaman yaki yaxshi bir ishni qilay dep qesem qilip salsa (kishiler hertürlük ish toghrisida angsiz rewishte qesem qilishi mumkin), shundaqla u buni tonup yetse, u bu ishlar tüpeylidin gunahkar hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Birsi yuqiriqi herqaysi ishlarda men gunahkar boldum dep bilse, u öz gunahini «men mundaq gunah qildim» dep iqrar qilsun; ");
INSERT INTO uiglat_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","andin özi sadir qilghan gunahining kafariti üchün Perwerdigarning aldigha «itaetsizlikni tiligüchi qurbanliq» süpitide ushshaq maldin saghliq we ya bir chishi öchkini gunah qurbanliqi qilip keltürsun; andin kahin uni gunahidin paklandurushqa uning üchün kefarǝt keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Eger u qoylardin qurbanliq qilishqa qurbi yetmise, u qilghan itaetsizliki üchün ikki paxtek yaki ikki bachkini élip kélip, birini gunah qurbanliqi üchün, yene birini köydürme qurbanliq üchün Perwerdigarning aldigha sunsun. ");
INSERT INTO uiglat_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","U bularni kahinning qéshigha keltürgende, kahin awwal gunah qurbanliqigha teyyarlan’ghanni qurbanliq qilip boynini üzmey, béshigha yéqin jayidin tolghisun, lékin béshini boynidin üzüwetmisun;    ");
INSERT INTO uiglat_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","andin gunah qurbanliqining qénidin azghina élip qurban’gahning témigha chachsun; qalghan qéni bolsa qurban’gahning tüwige siqip chiqirilsun. Buning özi gunah qurbanliqi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Emma ikkinchisini bolsa békitilgen belgilime boyiche köydürme qurbanliq qilip sunsun. Bu yol bilen kahin uning qilghan gunahi üchün kefarǝt keltüridu we shu gunah uningdin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Eger ikki paxtek yaki ikki bachkini keltürüshke qurbi yetmise, undaqta gunah qilghan kishi gunah qurbanliqi üchün ésil undin bir efahning ondin birini keltürsun; bu gunah qurbanliqi bolghachqa u uning üstige zeytun méyi quymisun yaki üstige héchqandaq mestiki salmisun; chünki u gunah qurbanliqi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","U uni kahinning qéshigha keltürsun we kahin buningdin sun’ghuchining «yadlinish ülüshi» süpitide bir changgal élip, shuni Perwerdigargha atap otta sunulghan qurbanliqlargha qoshup, qurban’gahning üstide köydürsun. Buning özi gunah qurbanliqi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Bu yol bilen u shu gunahlardin qaysisini qilghan bolsa, kahin uning üchün kefarǝt keltüridu. Ashliq hediyeliridikige oxshash qalghan qismi kahin’gha tewe bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Andin Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Birsi bilmey Perwerdigargha atalghan muqeddes nersilerge nisbeten itaetsizlik qilip gunah ötküzse, undaqta u Perwerdigarning aldigha ushshaq maldin béjirim bir qochqarni itaetsizlik qurbanliqi qilip keltürsun; shu itaetsizlik qurbanliqi bolghan qochqarning bahasini sen muqeddes jaydiki shekelning ölchem birliki boyiche kümüsh shekelge toxtatqin.    ");
INSERT INTO uiglat_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Andin shu kishi muqeddes nersilerge nisbeten ötküzgen xataliqidin bolghan ziyanni toldursun, shundaqla ziyanning beshtin biri boyiche qoshup kahin’gha tölem tölisun. Bu yol bilen kahin itaetsizlik qurbanliqi bolghan qochqarning wasitisi bilen uning üchün kefarǝt keltüridu; shu gunah uningdin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Eger birsi bilmey Perwerdigarning «qilma» dégen herqandaq emrlirining birerisige xilapliq qilip, gunahkar bolghan bolsa u qebihlikining jazasigha tartilidu; ");
INSERT INTO uiglat_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","shundaq bolsa, u ushshaq maldin sen toxtatqan qimmette béjirim bir qochqarni itaetsizlik qurbanliqi qilip sunsun. Bu yol bilen kahin uning bilmey ötküzgen itaetsizliki üchün kefarǝt keltüridu we shu itaetsizlik gunahi uningdin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Bu itaetsizlik qurbanliqi bolidu; chünki u derheqiqet Perwerdigarning aldida itaetsizlik qilghan. ");
INSERT INTO uiglat_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Andin Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Eger birsi gunah qilip Perwerdigarning aldida wapasizliq qilip, qoshnisi özige amanet yaki kapaletke bergen bir nerse yaki qoshnisidin zorawanliq bilen buliwalghan melum bir nerse toghrisida yalghan gep qilghan bolsa yaki qoshnisidin naheqliq bilen melum nersini tartiwalghan bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","yaki yitip ketken bir nersini tépiwélip uningdin tansa yaki kishilerning gunah sadir qilghan herqandaq bir Ishi toghrisida yalghan qesem ichse, ");
INSERT INTO uiglat_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","U gunah qilghan ishta özini gunahkar dep tonup yetse, undaqta u buliwalghan yaki naheq tartiwalghan nerse yaki uninggha amanetke bérilgen nerse bolsun, yaki yitip kétip tépiwalghan nerse bolsun, ");
INSERT INTO uiglat_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","yaki u herqandaq nerse toghrisida yalghan qesem ichken bolsun, uning hemmisini toluq bahasi boyiche tölisun, shundaqla shu bahaning beshtin bir qismi boyiche qoshup tölisun; u itaetsizlik qurbanliqini qilghan künide tölemni igisige tapshurup bersun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Andin u Perwerdigarning aldigha itaetsizlik qurbanliqi süpitide ushshaq maldin sen toxtatqan qimmet boyiche béjirim bir qochqarni itaetsizlik qurbanliqi qilip kahinning qéshigha élip kelsun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kahin bu yol bilen uning üchün Perwerdigarning aldida kefarǝt keltüridu we u herqaysi ishta itaetsizlik qilghan bolsimu u uningdin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Sen Harun bilen oghullirigha köydürme qurbanliq toghrisida emr qilip mundaq dégin: — Köydürme qurbanliq toghrisidiki qaide-nizam mundaq bolidu: — Köydürme qurbanliq pütün kéche tang atquche qurban’gahtiki ochaqning üstide köyüp tursun; we qurban’gahning otini öchürmey yéniq turghuzunglar. ");
INSERT INTO uiglat_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Kahin kanap tonini kiyip, yalingachliqini yépip, saghrisighiche kanap ich tambal kiyip tursun; qurban’gahning üstidiki ot bilen köydürülgen köydürme qurbanliqning külini élip, qurban’gahning bir teripide qoysun; ");
INSERT INTO uiglat_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","andin kiyimlirini séliwétip bashqa kiyimlerni kiyip, külini chédirgahning sirtigha élip chiqip pakiz bir jayda qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Qurban’gahning oti bolsa hemishe yénip tursun; uni héch waqit öchürüshke bolmaydu, kahin özi her küni etigende uninggha otun sélip, üstige köydürme qurbanliqni tizsun we uning üstige inaqliq qurbanliqlirining méyini qoyup köydürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Üzülmes bir ot qurban’gahning üstide hemishe köyüp tursun; u hergiz öchürülmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ashliq hediyesi toghrisidiki qaide-nizam mundaq: — Harunning oghulliridin biri uni Perwerdigarning aldigha, qurban’gahning aldigha keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","U ashliq hediyesi bolghan ésil un’gha qolini sélip uningdin shundaqla uningdiki zeytun méyidin bir changgal élip we hediyening üstidiki barliq mestikini qoshup, bularni qurban’gah üstide köydürsun; bu hediyening «yadlinish ülüshi» bolup, Perwerdigarning aldida xushbuy keltürüsh üchün qilin’ghan bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Éship qalghanlirini bolsa Harun bilen oghulliri yésun; u échitqu sélinmay pishurulup muqeddes bir jayda yéyilsun; ular uni jamaet chédirining hoylisida yésun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","U mutleq échitqusiz pishurulsun. Men otta Manga sunulidighan qurbanliq-hediyeler ichidin shuni ularning öz ülüshi bolsun dep ulargha heq qilip berdim; u gunah we itaetsizlikni tiligüchi qurbanliqlargha oxshash «eng muqeddeslerning biri» hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Harunning ewladidin bolghan erkeklerning hemmisi buningdin yésun; bu dewrdin-dewrge aranglarda ebediy bir belgilime bolidu; Perwerdigargha atap otta sunulghanliridin bular ularning ülüshi bolsun. Uninggha qol tegküzgüchi jezmen muqeddes bolushi kérek.    ");
INSERT INTO uiglat_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Harun mesihlinidighan künide u we oghullirining Perwerdigarning aldigha sunidighini mundaq bolushi kérek: — Ular üzülmes ashliq hediyesi süpitide ésil undin bir efahning ondin birini sunushi kérek; etigini yérimini, axshimi yene yérimini sunsun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","U tawida zeytun méyi bilen étilsun; u zeytun méyigha chilap pishurulghandin kéyin sen uni élip kir; ashliq hediyesining pishurulghan parchilirini xushbuy süpitide Perwerdigargha atap sun’ghin. ");
INSERT INTO uiglat_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Harunning oghullirining qaysisi uning ornida turushqa mesihlen’gen bolsa umu hediyeni shundaq teyyarlap sunsun; bu ebediy mutleq bir belgilime bolidu. Bu hediye Perwerdigargha atap toluq köydürülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kahinning herbir ashliq hediyesi bolsa pütünley köydürülsun; u hergiz yéyilmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Harun bilen oghullirigha mundaq dégin: — Gunah qurbanliqi toghrisidiki qaide-nizam mundaq: — Gunah qurbanliqimu köydürme qurbanliq boghuzlinidighan jayda, Perwerdigarning aldida boghuzlansun; bu xil qurbanliq «eng muqeddeslerning biri» hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Gunah qurbanliqini ötküzgüchi kahin özi uni yésun; qurbanliq muqeddes bir yerde, jamaet chédirining hoylisida yéyilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Uning göshige qol tegküzgüchi herkim muqeddes bolmisa bolmaydu, shuningdek eger uning qéni birsining kiyimige chachrap ketse, undaqta qan chéchilghan jay muqeddes bir yerde yuyulsun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Qaysi sapal qazanda qurbanliq qaynitilip pishurulghan bolsa, u sundurulsun. Eger u mis qazanda qaynitip pishurulghan bolsa, u qirip sürülsun hem su bilen yuyulsun. ");
INSERT INTO uiglat_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kahinlardin bolghan barliq er kishiler uningdin yése bolidu. Bu «eng muqeddeslerning biri» hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Halbuki, muqeddes jayda kefarǝt keltürüsh üchün qéni jamaet chédirigha kirgüzülgen herqandaq gunah qurbanliqi bolsa, hergiz yéyilmisun, belki pütünley köydürülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Itaetsizlik qurbanliqi toghrisidiki qaide-nizam mana mundaq: — Bu qurbanliq «eng muqeddeslerning biri» hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Köydürme qurbanliq boghuzlinidighan jayda itaetsizlikni tilesh qurbanliqimu boghuzlinidu; kahin qénini qurban’gahning üsti qismining etrapigha sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Qurbanliq qilghuchi kishi barliq méyini sunsun; yeni mayliq quyruqi bilen ich qarnini yögep turghan mayni, ");
INSERT INTO uiglat_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ikki börekni we ularning üstidiki hemde ikki yanpishidiki mayni ajritip, jigerning börekkiche bolghan chawa méyini ajritip sunsun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kahin bularni Perwerdigargha atap otta sunulidighan qurbanliq süpitide qurban’gahta köydürsun. Bu itaetsizlik qurbanliqi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kahinlardin bolghan er kishilerning hemmisi buni yésun; u muqeddes yerde yéyilsun; u «eng muqeddeslerning biri» hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Gunah qurbanliqi qandaq bolsa itaetsizlik qurbanliqimu shundaq bolidu; ular ikkisi toghrisidiki qaide-nizam oxshash; bu qurbanliq kefarǝt keltürüshke qurbanliq ötküzgüchi kahinning özige tewe bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kahin birsining sun’ghan köydürme qurbanliqini ötküzgen bolsa, köydürme qurbanliqning térisi shu kahinning bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Tonurda pishurulghan herbir ashliq hediyesi, shundaqla qazanda yaki tawida étilgen herbir ashliq hediyesi bolsa uni ötküzgen kahinning bolidu, yeni kahinning özige tewe bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Herbir ashliq hediyesi, meyli zeytun méyi arilashturulghan bolsun, yaki quruq keltürülgen bolsun, bular Harunning oghullirining herbirige barawer bölüp bérilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Perwerdigargha atap keltürülgen inaqliq qurbanliqi toghrisidiki qaide-nizam mundaq: — ");
INSERT INTO uiglat_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Sunmaqchi bolghan kishi uni teshekkür éytish üchün sunsa, undaqta u «teshekkür qurbanliqi» bilen bille zeytun méyi ileshtürülgen pétir toqachlar, zeytun méyi sürülüp mesihlen’gen pétir hemek nanlar we ésil undin zeytun méyigha chilap pishurulghan toqachlarnimu keltürsun.    ");
INSERT INTO uiglat_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Shu toqachlardin bashqa, yene teshekkür éytidighan inaqliq qurbanliqi bilen bille échitqu sélin’ghan nanlarnimu sunsun; ");
INSERT INTO uiglat_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","u shu sun’ghanlirining herbir türidin birni élip Perwerdigar üchün qosh qollap sunidighan «kötürme hediye» qilip keltürsun; bu inaqliq qurbanliqining qénini qurban’gahning üstige sepken kahinning özige tegsun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Teshekkür bildüridighan inaqliq qurbanliqining göshi bolsa qurbanliq qilin’ghan shu küni yéyilishi kérek; qurbanliqni sun’ghuchi kishi tang atquche uning héch némisini qaldurmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Eger uning sun’ghan qurbanliqi qesimige xas qurbanliq yaki ixtiyariy keltürgen qurbanliq bolsa, undaqta haywanning göshi qurbanliq qilin’ghan künde yéyilsun; uningdin éship qalghinini bolsa, etisimu yéyishke bolidu; ");
INSERT INTO uiglat_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","lékin qurbanliqning göshidin üchinchi künigiche éship qalsa, u otta köydürülüshi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Inaqliq qurbanliqining göshidin üchinchi künide yéyilse, undaqta qurbanliq qobul bolmaydu, qurbanliq sun’ghuchining hésabighimu hésablanmaydu, belki mekruh bolidu; kimdekim uningdin yése öz qebihlikining jazasigha tartilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Shundaqla napak nersige tégip qalghan göshmu yéyilmesliki kérek, belki otta köydürülüshi kérek. Herqandaq pak adem napak nersige tegmigen qurbanliqning göshini yése bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Lékin kimki napak halette turup Perwerdigargha atalghan inaqliq qurbanliqidin yése, undaqta u öz xelqidin üzüp tashlinidu.    ");
INSERT INTO uiglat_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kimki napak bir nersige tégip ketse (meyli napak halettiki adem bolsun, napak bir haywan bolsun yaki herqandaq napak yirginchlik nerse bolsun) we shundaqla Perwerdigargha xas atalghan inaqliq qurbanliqining göshidin yése, undaqta u öz xelqidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Israillargha mundaq dégin: — Siler kala, qoy we öchkilerning méyini hergiz yémenglar. ");
INSERT INTO uiglat_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Özlükidin ölgen yaki yirtquchlar boghup qoyghan haywanning jesitining méyini herqandaq ishqa ishletkili bolidu, lékin hergiz uningdin yémenglar. ");
INSERT INTO uiglat_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Chünki kimki Perwerdigargha atap otta sunulidighan herqandaq haywanning méyini yése, shuni yégen kishi öz xelqliridin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Siler herqandaq turar jayinglarda héchqandaq qanni, yeni uchar-qanatlarning bolsun yaki charpaylarning bolsun qénini hergiz éstimal qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kimdekim herqandaq qanni éstimal qilsa, shu kishi öz xelqliridin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Israillargha mundaq dégin: — Kimki Perwerdigargha atap bir inaqliq qurbanliqi sunsa, undaqta u Perwerdigargha xas bolghan hediyeni shu inaqliq qurbanliqtin ayrip keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Öz qoli bilen Perwerdigargha atighan, otta sunulidighan hediyelerni, yeni may bilen töshni qoshup élip kélip, töshni «pulanglatma hediye» süpitide Perwerdigarning aldida pulanglatsun.    ");
INSERT INTO uiglat_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kahin méyini qurban’gah üstide köydürüwetsun. Tösh bolsa Harun bilen uning oghullirigha xas bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Inaqliq qurbanliqliringlarning ong arqa putini siler «kötürme hediye» süpitide kahin’gha béringlar. ");
INSERT INTO uiglat_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Harunning oghulliridin qaysisi inaqliq qurbanliqining qéni bilen méyini sun’ghan bolsa öz ülüshi üchün ong arqa putini özi alsun. ");
INSERT INTO uiglat_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Chünki Men Israillarning inaqliq qurbanliqliridin «pulanglatma hediye» bolghan tösh bilen «kötürme hediye» bolghan arqa putini ebediy bir belgilime bilen Israillardin élip, kahin Harun we uning oghullirining heqqi bolsun dep ulargha teqdim qildim.    ");
INSERT INTO uiglat_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Musa Harun bilen oghullirini Perwerdigarning qulluqida kahin bolushqa uning aldigha keltürgen künide, ulargha Perwerdigargha atap otta sunulidighan qurbanliqlardin teqdim qilinidighan kahinliq ülüshi mana shudur. ");
INSERT INTO uiglat_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Musa ularni mesihligen künide, Perwerdigar bu ülüshni Israillardin élip ulargha bérilsun dep emr qilghan. Bu Israillargha dewrdin dewrgiche ebediy bir belgilime bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Köydürme qurbanliq bilen ashliq hediyesi, gunah qurbanliqi bilen itaetsizlik qurbanliqi, kahinliqqa tiklesh qurbanliqi bilen inaqliq qurbanliqi toghrisidiki qaide-nizam mana shudur. ");
INSERT INTO uiglat_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Perwerdigar Israillargha: «Siler bu Sinay bayawanida Perwerdigarning aldigha qurbanliqliringlarni sununglar» dep buyrughan künide, u bularning hemmisini Sinay téghida Musagha tapshurghanidi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Harunni oghulliri bilen bille, we ularning mexsus kiyimlirini, «mesihlesh méyi»ni, gunah qurbanliqi bolidighan torpaq bilen ikki qochqarni, pétir nan sélin’ghan séwetni élip kélip,    ");
INSERT INTO uiglat_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Israilning pütün jamaitini jamaet chédirining kirish aghzining aldigha jem qilghin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa Perwerdigar uninggha buyrughinidek qildi, jamaet jamaet chédirining kirish aghzining aldigha yighildi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Andin Musa jamaetke: — Perwerdigar buyrughan ish mana mundaq, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Shuning bilen Musa Harun bilen uning oghullirini aldigha keltürüp ularni su bilen yuyup, ");
INSERT INTO uiglat_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Harun’gha könglek kiydürüp, belwagh baghlap, tonni kiydürdi we üstige efodni yapti; u efodning belwéghini baghlap, efodni uninggha taqap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Andin Musa uninggha «qoshén»ni taqap, qoshénning ichige «urim bilen tummim»ni sélip,    ");
INSERT INTO uiglat_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Béshigha selle yögep Perwerdigar uninggha buyrughinidek sellining aldi teripige «altun taxtiliq muqeddes otughat»ni békitip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Andin Musa mesihlesh méyini élip ibadet chédiri bilen ichidiki barliq nersilerning hemmisini mesihlep muqeddes qildi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","U maydin élip qurban’gahqa yette mertiwe chéchip, qurban’gah bilen uning barche qacha-quchilirini, yuyunush dési we teglikini Xudagha atap muqeddes qilishqa mesihlidi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","U yene mesihlesh méyidin azraq élip Harunning béshigha quyup uni Xudagha atap muqeddes qilishqa mesihlidi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Andin Musa Harunning oghullirini aldigha keltürüp, Perwerdigar uninggha buyrughinidek ulargha könglek kiydürüp, bellirige belwagh baghlap, ulargha égiz böklernimu taqap qoydi.    ");
INSERT INTO uiglat_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Andin u gunah qurbanliqi qilinidighan torpaqni yétilep keldi; Harun bilen uning oghulliri gunah qurbanliqi qilinidighan torpaqning béshigha qollirini qoydi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","U uni boghuzlidi, andin Musa qénidin élip, öz barmiqi bilen qurban’gahning münggüzlirige, chörisige sürüp qurban’gahni gunahtin paklidi; qalghan qanni bolsa u qurban’gahning tüwige töküp, muqeddes bolushqa kefarǝt keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Andin u ich qarnini yögep turghan mayning hemmisini, jigerning üstidiki chawa mayni, ikki börek we üstidiki maylirini qoshup aldi; andin Musa bularni qurban’gahning üstide köydürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Biraq Musa torpaqning térisi bilen göshi we tézikini bolsa Perwerdigar özige buyrughinidek chédirgahning tashqirida otta köydürüwetti.    ");
INSERT INTO uiglat_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Andin u köydürme qurbanliq qilinidighan qochqarni keltürdi; Harun bilen uning oghulliri qollirini qochqarning béshigha qoydi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Harun qochqarni boghuzlidi; andin Musa qénini élip qurban’gahning üsti qismining etrapigha septi; ");
INSERT INTO uiglat_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Harun qochqarni parche-parche qilip parchilidi; andin Musa béshini, parchilan’ghan göshlirini barliq méyi bilen qoshup köydürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Üchey-qérinliri bilen pachaqlirini suda yudi. Andin Musa qochqarni pütün péti qurban’gah üstide köydürdi. Bu Perwerdigar Musagha buyrughan, «Perwerdigargha atap otta sunulidighan xushbuy chiqidighan qurbanliq» idi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Andin u kahinliqqa tiklesh qurbanliqi qilinidighan qochqarni, ikkinchi qochqarni keltürdi; Harun bilen uning oghulliri qollirini qochqarning béshigha qoydi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","U uni boghuzlidi; we Musa uning qénidin élip Harunning ong quliqining yumshiqi bilen ong qolining bash barmiqigha sürüp we ong putining chong barmiqighimu suwap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Andin Musa Harunning oghullirini aldigha keltürüp, qandin élip ularning ong qulaqlirining yumshiqi bilen ong qollirining bash barmaqlirigha sürdi, ularning ong putlirining chong barmaqlirighimu suwap qoydi, qalghan qanni Musa qurban’gahning chörisige septi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Shundaq qilip, u méyi bilen mayliq quyruqini, ich qarnini yögep turghan barliq may bilen jigerning üstidiki chawa méyini, ikki börek we üstidiki maylirini qoshup élip ong arqa putinimu késip élip, ");
INSERT INTO uiglat_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Perwerdigarning aldidiki pétir nan sélin’ghan séwettin bir pétir toqach bilen bir zeytun may toqichi we bir dane hemek nanni élip bularni may bilen ong arqa putning üstide qoydi; ");
INSERT INTO uiglat_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","andin bularning hemmisini Harun bilen uning oghullirining qollirigha tutquzup, pulanglatma hediye bolsun dep Perwerdigarning aldida pulanglatti. ");
INSERT INTO uiglat_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Andin Musa bularni ularning qolliridin élip qurban’gahtiki köydürme qurbanliqning üstide qoyup köydürdi. Bu «kahinliqqa tiklesh qurbanliqi» bolup, Perwerdigargha atap otta sunulidighan, xushbuy chiqidighan qurbanliq idi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Andin Musa töshni élip pulanglatma hediye süpitide Perwerdigarning aldida pulanglatti; Perwerdigarning uninggha buyrughini boyiche, «kahinliqqa tiklesh qurbanliqi» bolghan qochqarning bu qismi Musaning ülüshi idi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Andin Musa mesihlesh méyidin we qurban’gahning üstidiki qandin bir’az élip, Harun bilen uning kiyimlirige we oghulliri bilen ularning kiyimlirige septi. Shundaq qilip, u Harun we kiyimlirini, oghulliri bilen ularning kiyimlirini muqeddes qildi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa Harun bilen uning oghullirigha mundaq buyrudi: — «Bu göshni jamaet chédirining kirish aghzida qaynitip pishurup shu yerde olturup «kahinliqqa tiklesh qurbanliqi»gha tewe bolghan séwettiki nan bilen qoshup yenglar; bularni Harun bilen oghulliri yésun, dep buyrughinimdek uni yenglar; ");
INSERT INTO uiglat_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","lékin gösh bilen nandin éship qalghanlirining hemmisini otta köydürüwétinglar. ");
INSERT INTO uiglat_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Siler yette kün’giche jamaet chédirining kirish aghzidin chiqmay, Xudagha atap kahinliqqa tiklesh künliringlar toshquche shu yerde turunglar; chünki silerni Xudagha atap kahinliqqa tiklesh üchün yette kün kétidu. ");
INSERT INTO uiglat_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Bügün qilin’ghan ishlar Perwerdigarning buyrughini boyiche siler üchün kefarǝt keltürülsun dep qilindi. ");
INSERT INTO uiglat_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Siler ölmeslikinglar üchün Perwerdigarning emrini tutup jamaet chédirining kirish aghzining aldida kéche-kündüz yette kün turushunglar kérek; chünki manga shundaq buyruldi». ");
INSERT INTO uiglat_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Harun bilen oghulliri Perwerdigarning Musaning wasitisi bilen buyrughinining hemmisini beja keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sekkizinchi küni Musa Harun bilen uning oghulliri we Israilning aqsaqallirini chaqirip, ");
INSERT INTO uiglat_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Harun’gha mundaq dédi: — «Sen gunah qurbanliqigha béjirim bir mozayni, köydürme qurbanliqqa béjirim bir qochqarni özüng üchün élip, Perwerdigarning aldigha keltürgin, ");
INSERT INTO uiglat_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","andin Israillargha söz qilip: — Siler gunah qurbanliqi üchün bir téke élip kélinglar, köydürme qurbanliq üchün bir mozay we bir qoza élip kélinglar, her ikkisi béjirim, bir yashqa kirgen bolsun; ");
INSERT INTO uiglat_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Perwerdigarning aldida sunushqa inaqliq qurbanliqi süpitide bir torpaq bilen bir qochqarni élip, zeytun méyi ileshtürülgen ashliq hediyesi bilen bille keltürünglar; chünki bügün Perwerdigar Özini silerge ayan qilidu, dégin». ");
INSERT INTO uiglat_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ular Musa buyrughan nersilerni jamaet chédirining aldigha élip keldi; pütkül jamaet yéqin kélip, Perwerdigarning aldida hazir bolup turdi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa: — Mana, bu Perwerdigar buyrughan ishtur; buni qilsanglar Perwerdigarning shan-sheripi silerge ayan bolidu, dédi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Shuning bilen Musa Harun’gha: — Sen qurban’gahqa yéqin bérip gunah qurbanliqing bilen köydürme qurbanliqingni sunup özüng we xelq üchün kefarǝt keltürgin; andin xelqning qurbanliqinimu sunup, Perwerdigar emr qilghandek ular heqqide kefarǝt keltürgin» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Shuni déwidi, Harun qurban’gahqa yéqin bérip özi üchün gunah qurbanliqi bolidighan mozayni boghuzlidi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Harunning oghulliri qanni uninggha sunup berdi; u barmiqini qan’gha tegküzüp, qurban’gahning münggüzlirige sürdi, qalghan qanni qurban’gahning tüwige quydi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Gunah qurbanliqining méyi bilen ikki börek we jigerning üstidiki chawa mayni élip, Perwerdigar Musagha buyrughinidek ularni qurban’gah üstide köydürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Gösh bilen térisini bolsa chédirgahning tashqirigha élip chiqip otta köydürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Andin u köydürme qurbanliq qilidighan qochqarni boghozlidi; Harunning oghulliri uninggha qanni sunup berdi; u buni qurban’gahning üsti qismining etrapigha septi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Andin ular parche-parche qilin’ghan köydürme qurbanliqni béshi bilen bille uninggha sunup berdi; u bularni qurban’gahta köydürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","U ich qarni bilen pachaqlirini yuyup, bularnimu qurban’gahning üstide, köydürme qurbanliqning üstige qoyup köydürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Andin u xelqning qurbanliqini keltürdi; xelqning gunah qurbanliqi bolghan tékini boghuzlap, ilgiri haywanni sun’ghandek unimu gunah qurbanliqi qilip sundi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","U köydürme qurbanliq qilidighan malni keltürüp bunimu belgilime boyiche sundi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Andin u ashliq hediyesini keltürüp uningdin bir changgal élip etigenlik köydürme qurbanliqqa qoshup qurban’gah üstide köydürdi.    ");
INSERT INTO uiglat_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Andin xelqqe bolidighan inaqliq qurbanliqi bolidighan torpaq bilen qochqarni boghuzlidi. Harunning oghulliri qénini uninggha sunup berdi; u buni qurban’gahning üsti qismining etrapigha septi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ular torpaq bilen qochqarning may qismini, yeni mayliq quyruqi, ich qarnini yögep turghan maylirini, ikki börek we jigerning chawa méyini élip, ");
INSERT INTO uiglat_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Bu may parchilirini ikki töshning üstide qoydi, Harun bularni qurban’gahning üstide köydürdi. ");
INSERT INTO uiglat_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Axirida Harun ikki tösh bilen ong arqa putini pulanglatma hediye süpitide Musaning buyrughinidek Perwerdigarning aldida pulanglatti. ");
INSERT INTO uiglat_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Andin Harun qollirini xelqqe qaritip kötürüp, ulargha bext tilidi; u gunah qurbanliqi, köydürme qurbanliq we inaqliq qurbanliqini sunup, qurban’gahtin chüshti. ");
INSERT INTO uiglat_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa bilen Harun jamaet chédirigha kirip, yene yénip chiqip xelqqe bext tilidi; shuning bilen Perwerdigarning shan-sheripi pütkül xelqqe ayan boldi; ");
INSERT INTO uiglat_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Perwerdigarning aldidin ot chiqip, qurban’gah üstidiki köydürme qurbanliq bilen maylarni yutup ketti. Pütkül xelq buni körüp, towliship, düm yiqilishti. ");
INSERT INTO uiglat_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Harunning oghulliri Nadab bilen Abihu ikkisi öz xushbuydanini élip uninggha ot yéqip üstige xushbuyni sélip, Perwerdigar ulargha buyrup baqmighan gheyriy bir otni Perwerdigargha sundi; ");
INSERT INTO uiglat_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","shuning bilen Perwerdigarning aldidin ot chiqip ularni yewetti; shuan ular Perwerdigarning aldida öldi. ");
INSERT INTO uiglat_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa Harun’gha: — Mana, bu Perwerdigarning: «Men Manga yéqin kelgen ademlerde Özümning muqeddes ikenlikimni körsitimen we barliq xelqning aldida ulughlinimen» dégen sözining özidur, dédi. Shuni déwidi, Harun jim turup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa Harunning taghisi Uzzielning oghulliri bolghan Mishael bilen Elzafanni chaqirip ulargha: — Siler yéqin kélip öz qérindashliringlarni muqeddes jayning aldidin kötürüp, chédirgahning tashqirigha élip chiqinglar» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Shuning bilen ular yéqin kélip, ularni kiyiklik könglekliri bilen kötürüp Musaning buyrughinidek chédirgahning tashqirigha élip chiqti. ");
INSERT INTO uiglat_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa Harun we oghulliri Eliazar bilen Itamargha: — Siler bashliringlarni ochuq qoymanglar, kiyimliringlarni yirtmanglar; bolmisa özünglar ölüp, pütkül jamaetke ghezep keltürisiler; lékin qérindashliringlar bolghan pütkül Israil jemeti Perwerdigar yaqqan ot tüpeylidin matem tutup yighlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Emma siler bolsanglar Perwerdigarning mesihlesh méyi üstünglargha sürülgen bolghachqa, jamaet chédirining tashqirigha chiqmanglar; bolmisa ölisiler, dédi. Shuni déwidi, ular Musaning buyrughinidek qildi. ");
INSERT INTO uiglat_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Perwerdigar Harun’gha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Sen özüng we oghulliring sharab we ya bashqa küchlük haraqlarni ichip, jamaet chédirigha hergiz kirmenglar; bolmisa, ölüp kétisiler. Bu siler üchün dewrdin-dewrge ebediy bir belgilime bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Shundaq qilsanglar, muqeddes bilen adettikini, pak bilen napakni perq étip ajritalaydighan bolisiler; ");
INSERT INTO uiglat_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","shundaqla Perwerdigar Musaning wasitisi bilen Israillargha tapshurghan hemme belgilimilerni ulargha ögiteleysiler». ");
INSERT INTO uiglat_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa Harun we uning tirik qalghan oghulliri Eliazar bilen Itamargha mundaq dédi: — «Siler Perwerdigargha atap otta sunulidighan qurbanliq-hediyelerdin éship qalghan ashliq hediyesini élip uni qurban’gahning yénida échitqu arilashturmighan halda yenglar; chünki u «eng muqeddeslerning biri» hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Bu Perwerdigargha atap otta sunulidighan nersilerdin séning nésiweng we oghulliringning nésiwisi bolghachqa, uni muqeddes jayda yéyishinglar kérek; chünki manga shundaq buyrulghandur. ");
INSERT INTO uiglat_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Uningdin bashqa pulanglatma hediye qilin’ghan tösh bilen kötürme hediye qilin’ghan arqa putni sen we oghul-qizliring bille pak bir jayda yenglar; chünki bular séning nésiweng bilen oghulliringning nésiwisi bolsun dep, Israillarning inaqliq qurbanliqliridin silerge bérilgen. ");
INSERT INTO uiglat_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ular kötürme hediye qilin’ghan arqa put bilen pulanglatma hediye qilin’ghan töshni otta sunulidighan mayliri bilen qoshup, Perwerdigarning aldida pulanglatma hediye süpitide pulanglitish üchün keltürsun; Perwerdigarning buyrughini boyiche bular séning we oghulliringning nésiwisi bolidu; bu ebediy bir belgilime bolidu». ");
INSERT INTO uiglat_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Andin Musa gunah qurbanliqi qilidighan tékini izdiwidi, mana u alliqachan köydürülüp bolghanidi. Bu sewebtin u Harunning tirik qalghan ikki oghli Eliazar bilen Itamargha achchiqlinip: ");
INSERT INTO uiglat_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","— Némishqa siler gunah qurbanliqining göshini muqeddes jayda yémidinglar? Chünki u «eng muqeddeslerning biri» hésablinatti, Perwerdigar silerni jamaetning gunahini kötürüp ular üchün uning aldida kefarǝt keltürsun dep, shuni silerge teqsim qilghanidi. ");
INSERT INTO uiglat_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Mana, uning qéni muqeddes jayning ichige keltürülmidi; siler eslide men buyrughandek uni muqeddes jayda yéyishinglar kérek idi, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Lékin Harun Musagha: — Mana, bular bügün toghra ish qilip özlirining gunah qurbanliqi bilen köydürme qurbanliqini Perwerdigarning aldida sundi; méning béshimgha shu ishlar keldi; eger men bügün gunah qurbanliqining göshini yégen bolsam, Perwerdigarning neziride obdan bolattimu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa buni anglap jawabidin razi boldi. ");
INSERT INTO uiglat_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Perwerdigar Musa bilen Harun’gha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Israillargha mundaq dégin: — Yer yüzidiki barliq haywanlarning ichidin silerge yéyishke bolidighan janiwarlar shuki: — ");
INSERT INTO uiglat_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Haywanlar ichide hem tuyaqliri pütün achimaq (tuyaqliri pütünley yériq) hem köshigüchi haywanlarning herbirini yésenglar bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Lékin köshigüchi yaki achimaq tuyaqliq haywanlardin töwendikilerni yémeslikinglar kérek: — Töge: chünki u köshigini bilen tuyiqi achimaq emes. Shunga u silerge haram bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Sughur bolsa köshigini bilen tuyiqi achimaq emes — u silerge haram bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Toshqan bolsa bumu köshigini bilen tuyiqi achimaq emes — u silerge haram bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Choshqa bolsa tuyaqliri achimaq (tuyaqliri pütünley yériq) bolghini bilen köshimigini üchün silerge haram bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Siler shu haywanlarning göshidin yémeslikinglar kérek we ularning ölükigimu tegmenglar. Ular bolsa silerge haram bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Suda yashaydighan janiwarlardin töwendikilerni yéyishke bolidu: — sudiki, yeni derya-déngizlardiki janiwarlardin qaniti we qasiraqliri bolghanlarni yéyishke bolidu; ");
INSERT INTO uiglat_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","lékin derya-déngizlarda yashaydighan, yeni sularda top-top üzidighan barliq janiwarlardin, qasiraqliri yaki qaniti bolmighanlirini yémeslikinglar kérek; ular silerge yirginchlik sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Mezkur janiwarlar derweqe silerge yirginchlik sanalsun; siler ularning göshidin yémeslikinglar kérek; ularning ölükini yirginchlik dep qaranglar. ");
INSERT INTO uiglat_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Sudiki janiwarlarning ichidin qaniti bilen qasiriqi bolmighan janiwarlarning hemmisi silerge yirginchlik sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Uchar-qanatlardin töwendikiler silerge yirginchliktur; ular yéyilmesliki kérek we silerge yirginchlik bolsun: — yeni bürküt, qorultaz-tapqushlar, déngiz bürküti, ");
INSERT INTO uiglat_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","qarlighach quyruqluq sar, lachin we ularning xilliri, ");
INSERT INTO uiglat_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","hemme qagha-qozghunlar we ularning xilliri, ");
INSERT INTO uiglat_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","müshükyapilaq, tögiqush, chayka, sar we ularning xilliri, ");
INSERT INTO uiglat_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","huwqush, qarna, ibis, ");
INSERT INTO uiglat_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","aqqu, saqiyqush, béliq’alghuch, ");
INSERT INTO uiglat_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","leylek, turna we uning xilliri, höpüp we shepereng qatarliqlar silerge haram sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Buningdin bashqa töt putlap mangidighan, uchidighan ushshaq janiwarlarning hemmisi silerge yirginchlik bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Halbuki, töt putlap mangidighan, uchidighan ushshaq janiwarlardin töwendikilerni yésenglar bolidu: — puti bilen ügilik pachiqi bolup, yer yüzide sekriyeleydighanlarni yésenglar bolidu; ");
INSERT INTO uiglat_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","bularning ichidin silerge yéyishke bolidighanliri: — chéketke we uning xilliri, qara chéketke we uning xilliri, tomuzgha we uning xilliri, chaqchiqiz we uning xilliri. ");
INSERT INTO uiglat_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Lékin töt putluq bolghan ömiligüchi hem uchidighan hemme bashqa janiwarlar silerge yirginchlik sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Bu janiwarlardinmu mundaq yol bilen napak bolisiler; birkim ularning ölük ténige tegse kech kirgüche napak hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Kimdekim bularning ölükining bir qismini kötürse öz kiyimlirini yuyushi kérek, u kishi kech kirgüche napak hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Tuyaqliri achimaq, biraq pütünley bölünmigen yaki köshimeydighan haywanlarning hemmisi silerge haramdur; herkim ularning ölükige tegse napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Töt puti bilen mangidighan haywanlarning ichidin tapini bilen mangidighanlarning hemmisi silerge napak bolup, herkim ularning ölük tenlirige tegse kech kirgüche napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Kimki ularning ölükini kötürse öz kiyimlirini yuyushi kérek, u kishi kech kirgüche napak turidu. Bu haywanlar bolsa silerge haram bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Yer yüzide ömiligüchi ushshaq janiwarlarning ichidin silerge haram bolghanlar munular: — qarighu zokor, chashqan, keslenchük we ularning türliri, ");
INSERT INTO uiglat_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","salma, qizil keslenchük, tam keslenchüki, tügürük keslenchük we xaméléon qatarliqlar haram bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Bularning hemmisi yer yüzide ömiligüchi hemme ushshaq janiwarlarning ichide silerge haram bolidu; ularning ölükige tegse, kech kirgüche napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Bu janiwarlarning ölüki herqandaq némige chüshüp qalsa shu néme napak hésablinidu — herqandaq yaghach qacha-qucha bolsun, kiyim bolsun, tére bolsun, taghar bolsun, herqandaq ishqa ishlitilidighan eswab bolsun, sugha chilinishi kérek; ular kech kirgüche napak sanilip, kéyin pak bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Bularning biri sapaldin yasalghan herqandaq qacha ichige chüshüp qalsa, shu qacha ichidiki hemme nerse napak sanalsun we qacha özi sundurulsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Eger qachidiki sudin ash-taam üstige chachrap ketse, ash-taam napak sanalsun we shundaqla qachidiki herqandaq ichimlikmu napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Hernémige undaq ölükning birer qismi chüshüp qalsimu, napak sanalsun. Eger tonur we ochaq bolsa, napak boldi dep chéqiwétilsun; ular silerge haram bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Lékin shundaq ehwalda bulaq yaki su yighilidighan kölchek yenila pak sanilidu; emma birkim ularning ölük ténige tegse napak bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Eger undaq ölükning birer qismi térishqa teyyarlan’ghan danlargha chüshüp qalsa, bumu yenila pak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Lékin eger danning üstige su quyulghandin kéyin shundaq bir ölükning birer qismi chüshüp qalsa, undaqta bu danlar silerge napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Eger silerge yéyishke bolidighan haywanlardin biri ölüp qalsa, uning ölükige tegken kishi kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Kimki undaq ölükning göshidin yése, öz kiyimlirini yuyushi kérek we kech kirgüche napak sanalsun; shundaqla undaq bir ölükni kötürgen kishimu kiyimlirini yuyushi kérek we u kishi kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Yer yüzide ömiligüchi hemme ushshaq janiwarlar yirginchlik sanilip, hergiz yéyilmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Qorsiqi bilen béghirlap mangidighan janiwar bolsun, yer yüzide yürüp töt puti bilen yaki köp putliri bilen mangidighan ömiligüchi janiwarlarning hertürlükini bolsa, ularni hergiz yémenglar; chünki ular yirginchliktur. ");
INSERT INTO uiglat_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Siler bolsanglar mundaq ömiligüchi janiwarning sewebidin özünglarni yirginchlik qilmasliqinglar kérek. Özünglarni ular tüpeylidin napak qilmanglar, bolmisa ularning sewebidin bulghinip qalisiler; ");
INSERT INTO uiglat_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","chünki Men Xudayinglardurmen. Siler özünglarni Özümge atap muqeddes qilishinglar kérek; Men Özüm muqeddes bolghach silermu özünglarni muqeddes tutushunglar kérek. Siler özünglarni yer yüzide ömiligüchi ushshaq herqandaq janiwarlarning sewebidin napak qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Chünki Men öz Xudayinglar bolushqa silerni Misir zéminidin chiqirip kelgen Perwerdigardurmen; siler muqeddes bolunglar, chünki Men muqeddesturmen. ");
INSERT INTO uiglat_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Shular bolsa charpay bilen uchar-qanatlar, suda yüridighan herbir janiwar bilen yer yüzide ömiligüchi herbir ushshaq janiwarlar toghrisidiki qanun-belgilimidur. ");
INSERT INTO uiglat_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Bular bilen haram-halalni uqup, yéyishke bolidighan haywan bilen yéyishke bolmaydighan haywanlarni perq ételeysiler. ");
INSERT INTO uiglat_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Israillargha söz qilip mundaq dégin: — «Ayal kishi hamilidar bolup oghul tughsa, adet körüp aghriq bolghan künliridikidek yette kün’giche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sekkizinchi küni oghli bolsa xetne qilinsun.    ");
INSERT INTO uiglat_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ayal bolsa shuningdin kéyin ottuz üch kün’giche «qan paklinish»ta tursun; paklinish künliri tamam bolmighuche héchbir muqeddes nersige tegmisun, muqeddes jayghimu kirmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Eger u qiz tughsa undaqta adet künliridikidek ikki heptigiche napak turup, andin atmish alte kün’giche «qan paklinish»ta tursun. ");
INSERT INTO uiglat_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Meyli oghul yaki qiz tughsun, qan paklinish künliri tamam bolghandin kéyin u ayal köydürme qurbanliq üchün bir yashqa kirgen qozini, gunah qurbanliqi üchün bir bachka yaki paxtekni élip jamaet chédirining kirish aghzigha, kahinning qéshigha keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kahin uni Perwerdigarning aldida sunup, shu ayal üchün kefarǝt keltüridu; shuning bilen u xunidin pak bolidu. Oghul yaki qiz tughqan ayal toghrisidiki qanun-belgilime mana shudur. ");
INSERT INTO uiglat_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Eger uning qozigha qurbi yetmise, u ikki paxtek yaki ikki bachka keltürsun; ularning biri köydürme qurbanliq üchün, yene biri gunah qurbanliqi üchün bolidu; shu yol bilen kahin uning üchün kefarǝt keltüridu; u ayal pak bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Perwerdigar Musa bilen Harun’gha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Birsining bedinining tériside bir chiqan, yaki temretke yaki parqiraq tashma chiqip, uningdin bedinining tériside pése-maxaw késilining jarahiti peyda bolghan bolsa, u kishi Harun kahinning yaki uning kahin oghulliridin birining qéshigha keltürülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kahin uning bedinining jarahitige qaraydu; jarahet bolghan jayning tüki aqirip ketken hemde jarahetmu etrapidiki téridin qéniqraq körünse, bu pése-maxaw késellikidur. Shunga kahin uni körgendin kéyin shu kishini «napak» dep jakarlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Lékin eger uning bedinining térisidiki peyda bolghan ashu yaltiraq chiqan aq bolup, etrapidiki téridin qéniqraq körünmise we tükimu aqirip ketmigen bolsa, kahin bu jarahet bar kishini yette kün’giche ayrim solap qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Yettinchi küni kahin uninggha qarisun we eger jarahet oxshash turup, tériside kéngiyip ketmigen bolsa, kahin uni yene yette kün’giche ayrim solap qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Yettinchi küni kahin uninggha yene qarisun we jarahetning renggi suslashqan we kéngiyip ketmigen bolsa, undaqta kahin uni «pak» dep jakarlisun; jarahetning peqet bir chaqa ikenliki békitilip, késel kishi öz kiyimlirini yuyup pak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Lékin eger u kahin’gha körünüp «pak» dep jakarlan’ghandin kéyin shu chaqa tériside kéngiyip ketse, undaqta u yene bir qétim kahin’gha körünsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kahin uninggha yene qarisun we eger chaqa uning tériside kéngiyip ketken bolsa, kahin uni «napak» dep jakarlisun; u jarahet pése-maxawdur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Eger birkimde pése-maxaw jarahiti peyda bolup qalsa kahinning qéshigha keltürülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kahin uning jarahitige sepsélip qarisun; we eger tériside aq bir chiqan peyda bolghan, tüki aqirip ketken bolsa we chiqan chiqqan jayda et-göshi körünüp qalghan bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","bu uning bedinining térisige chüshken kona pése-maxaw jarahitining qaytidin qozghilishi bolup, kahin uni «napak» dep jakarlisun. U napak bolghini üchün uni solashning hajiti yoq. ");
INSERT INTO uiglat_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Lékin eger pése-maxaw qozghilip, jarahiti bar kishining térisige yéyilip ketken bolsa, kahin negila qarisa shu yerde shu «pése-maxaw» bolsa, térisini béshidin putighiche qaplap ketken bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","undaqta kahin uninggha sepsélip qarisun; mana, shu pése-maxaw jarahiti pütün bedinini qaplap ketken bolsa, u jarahiti bar kishini «pak» dep jakarlisun; chünki uning pütün bedini aqirip ketken bolup, u «pak» dep sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Lékin qachaniki uningda et-göshi körünüp qalsa, u kishi napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kahin mundaq körün’gen et-göshige qarap, u kishini «napak» dep jakarlisun; chünki shu et-gösh napak bolup, u pése-maxaw késilidur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Halbuki, eger et-göshi qaytidin özgirip, aqarsa u kishi yene kahinning qéshigha kelsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kahin uninggha sepsélip qarisun; jarahet aqarghan bolsa, kahin jarahiti bar kishini «pak» dep jakarlisun; u pak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Eger birkimning bedinining térisige hürrek chiqip saqiyip, ");
INSERT INTO uiglat_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","hürrekning ornida aq chiqan yaki qizghuch dagh peyda bolghan bolsa, kahin’gha körsitilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kahin uninggha sepsélip qarisun; eger dagh etrapidiki téridin qéniqraq körünse, shundaqla uningdiki tükler aqirip qalghan bolsa, undaqta kahin uni «napak» dep jakarlisun; chünki bu hürrektin qozghilip peyda bolghan pése-maxaw késili jarahitidur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Lékin kahin uninggha sepsélip qarighanda, dagh chiqqan jayda aqirip qalghan tükler bolmisa, we daghmu etrapidiki téridin qéniqraq bolmisa, renggi sel susraq bolghan bolsa, undaqta kahin uni yette kün’giche ayrim solap qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Eger dagh derweqe térisige yéyilip ketken bolsa, kahin uni «napak» dep jakarlisun; chünki bu pése-maxaw jarahitidur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Emma eger dagh öz jayida toxtap yéyilmighan bolsa, bu peqet hürrekning zexmi, xalas; kahin uni «pak» dep jakarlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Eger birsining bedinining térisining melum jayi köyüp qélip, köygen jay aq-qizghuch yaki pütünley aq dagh bolup qalsa, ");
INSERT INTO uiglat_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kahin uninggha sepsélip qarisun; eger shu daghdiki tükler aqirip ketken, daghmu etrapidiki téridin qéniqraq bolup qalghan bolsa, undaqta bu köyük yarisidin peyda bolghan pése-maxaw késilidur; kahin uni «napak» dep jakarlisun; chünki u pése-maxaw jarahitidur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Lékin eger kahin sepsélip qarighanda, daghning ornida héchqandaq aqirip ketken tük bolmisa, shundaqla daghmu etrapidiki téridin qéniq bolmisa, belki renggi sus bolsa, undaqta kahin uni yette kün’giche ayrim solap qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Yettinchi küni kahin uninggha yene qarisun; dagh tériside kéngiyip ketken bolsa, kahin uni «napak» dep jakarlisun; chünki u pése-maxaw jarahitidur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Emma eger dagh jayida toxtap, yéyilmighan bolsa, shundaqla renggi sus bolsa, bu peqet köyüktin bolghan chawartqu, xalas; kahin uni «pak» dep jakarlisun; chünki u köyükning tatuqi, xalas. ");
INSERT INTO uiglat_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Eger bir er yaki ayal kishining béshida yaki saqilida jarahet peyda bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kahin jarahetke sepsélip qarisun; eger jarahet etrapidiki téridin qéniqraq körünse, üstide shalang sériq tük bolsa, undaqta kahin uni «napak» dep jakarlisun; chünki bu jarahet qaqach bolup, bash yaki saqaldiki pése-maxawning alamitidur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Eger kahin qaqach jaygha sepsélip qarighanda, u etrapidiki téridin qéniq körünmise, shundaqla uning ichide héchqandaq qara tükmu bolmisa, undaqta kahin qaqichi bar kishini yette kün’giche ayrim solap qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Kahin yettinchi küni qaqachqa yene sepsélip qarisun; qaqach kéngiyip ketmey, üstidimu héchqandaq sériq tük bolmisa, shundaqla qaqach etrapidiki téridin qéniq körünmise, ");
INSERT INTO uiglat_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","jarahiti bar kishi barliq chach-saqilini chüshürüwetsun; qaqachning özini ghirdimisun. Kahin qaqichi bar kishini yene yette kün’giche ayrim solap qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Yettinchi küni kahin qaqachqa sepsélip qarisun; eger qaqach téride kéngiyip ketmigen bolsa, shundaqla etrapidiki téridin qéniq körünmise, kahin uni «pak» dep jakarlisun. Andin u kiyimlirini yusun; shuning bilen u pak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Lékin eger u «pak» dep jakarlan’ghandin kéyin qaqach téride kéngiyip ketse, ");
INSERT INTO uiglat_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kahin uninggha yene sepsélip qarisun; eger qaqach téride kéngiyip ketken bolsa, sériq tükning bar-yoqluqini tekshürüshning hajiti yoq; chünki bu kishi napaktur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Eger qaqach jayida shu péti qélip, üstidin qara tük ünüp chiqqan bolsa, qaqach saqayghan bolidu; shu kishi pak bolghachqa, kahin uni «pak» dep jakarlishi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Eger er yaki ayal kishining bedinining tériside dagh peyda bolup, bu daghlar parqiraq hem aq bolsa ");
INSERT INTO uiglat_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kahin sepsélip qarisun; eger bedenning térisidiki shu daghlar susliship boz rengge yüzlen’gen bolsa, bu téridin chiqqan bir tashma, xalas; bu kishi pak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Eger birkimning béshining tükliri chüshüp ketken bolsa, u peqet bir taqir bash, xalas; u pak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Eger uning béshining tüki péshane teripidin chüshken bolsa, u peqet paynekbash, xalas; u yenila pak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Lékin eger uning taqir béshi yaki paynek béshida qizghuch aq dagh körünse, undaqta shu jarahet uning taqir béshi yaki paynek béshidiki pése-maxaw késilining bir alamitidur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kahin jarahitige sepsélip qarisun; eger uning taqir béshida yaki paynek béshida ishshiq jarahet bolsa hemde pése-maxaw késilining alamitidek qizghuch aq körünse, ");
INSERT INTO uiglat_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","undaqta u pése-maxaw késilige giriptar bolghan adem bolup, napak hésablinidu. Uning béshigha shundaq jarahet chüshken bolghach, kahin uni mutleq «napak» dep jakarlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Shundaq jarahiti bar pése-maxaw késili bolghan kishi kiyimliri yirtiq, chachliri chuwuq, burut-saqili yépiqliq halda: «Napak, napak!» dep towlap yürüshi kérek.    ");
INSERT INTO uiglat_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Shu jarahiti bolghan barliq künlerde u «napak» sanilidu; u napak bolghachqa, ayrim turushi kérek; uning turalghusi chédirgahning sirtida bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Eger bir kiyimde, meyli yungdin yaki kanaptin tikilgen bolsun uningda pése-maxaw iz-déghi peyda bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","yeni kanap yaki yungdin toqulghan rextte, örüsh yipida yaki arqaq yiplirida bolsun, tére-xurumda yaki téridin étilgen herqandaq nersilerde pése-maxaw iz-déghi bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","shundaqla kiyim-kéchek yaki tére-xurumda, örüsh yip yaki arqaq yiplirida, ya tére-xurumdin étilgen nersilerde peyda bolghan iz-dagh yéshilraq yaki qizghuch bolsa bu iz-dagh «pése-maxaw iz-déghi» dep qarilip kahin’gha körsitilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kahin daghqa sepsélip qarisun, andin iz-dagh peyda bolghan nersini yette kün’giche ayrim saqlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","U yettinchi küni iz-daghqa qarap baqsun; iz-dagh chüshken kiyim-kéchek, meyli arqaq yipta yaki örüsh yipta bolsun, yaki tére-xurumda yaki tére-xurumdin étilgen nerside bolsun, u kéngiyip ketken bolsa, bu iz-dagh chiritküch pése-maxaw késili dep hésablinip, ular napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Shuningdek kahin örüsh yip yaki arqaq yipida iz-dagh bolsa kiyim-kéchek yaki tére-xurumdin étilgen nerside shundaq iz-dagh bolsa ularnimu köydürüwetsun; chünki bu chiritküch pése-maxaw késilidur. Mundaq nersilerning hemmisini otta köydürüsh kérektur. ");
INSERT INTO uiglat_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Lékin kahin uninggha sepsélip qarighanda, iz-dagh kiyim-kéchektiki örüsh yipta bolsun, arqaq yipta bolsun, yaki tére-xurumdin étilgen nerside bolsun, iz-dagh kéngeymigen bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","undaqta kahin déghi bar nersini yuyulsun dep buyrup, ikkinchi qétim uni yette kün’giche saqlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Bu nerse yuyulghandin kéyin kahin yene daghqa sepsélip qarisun; eger uning renggi özgermigen bolsa (gerche kéngiyip ketmigen bolsimu), u yenila napaktur; sen uni otta köydürgin. Chünki meyli uning iz-déghi ich yüzide bolsun yaki tash yüzide bolsun u chiritküch iz-dagh hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Lékin eger kahin sepsélip qarighanda, mana, daghning renggi yuyulghandin kéyin susliship ketken bolsa, u shu qismini kiyim-kéchektin, örüsh yiptin yaki arqaq yiptin bolsun, yaki tére-xurumdin bolsun uni yirtip élip, tashliwetsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Eger bu iz-dagh kiyim-kéchekte, meyli arqaq yipta yaki örüsh yipta bolsun, ya tére-xurumdin étilgen nerside körünsun, bu kéngiydighan birxil pése-maxaw iz-déghi dep sanalsun; sen u chaplashqan kiyim-kéchekni köydürüwetkin. ");
INSERT INTO uiglat_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Lékin eger iz-dagh kiyim-kéchekte bolsun (örüsh yipida yaki arqaq yipida bolsun) yaki tére-xurumdin étilgen nerside bolsun, yuyulush bilen chiqip ketse, undaqta bu égin ikkinchi qétim yuyulsun, andin pak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Pése-maxaw késiliningkidek iz-dagh peyda bolghan yung yaki kanap rexttin toqulghan kiyim-kéchek (iz-dagh örüsh yipta yaki arqaq yipta bolsun) yaki tére-xurumdin étilgen nersiler toghrisidiki qanun-belgilime mana shudur; buning bilen ularni pak yaki napak jakarlashqa bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Pése-maxaw bolghan kishi pak qilinidighan künide beja qilish kérek bolghan qanun-belgilime mana töwendikidektur: — U kahinning aldigha keltürülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kahin chédirgahning tashqirigha chiqip, pése-maxaw bolghan kishige sepsélip qarisun; eger pése-maxaw bolghan kishi késilidin saqayghan bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Undaqta kahin pak qilinidighan kishige pak, tirik qushtin ikkini uninggha qoshup kédir yaghichi, qizil rext we zofa keltürüshke buyrusun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Andin kahin qushlarning birini éqin su qachilan’ghan sapal kozining üstide boghuzlanglar dep buyrusun; ");
INSERT INTO uiglat_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","andin tirik qushni bolsa, kahin uni kédir yaghichi, qizil rext we zofa bilen élip kélip, bu nersilerning hemmisini tirik qush bilen birge éqin suning üstide boghuzlan’ghan qushning qénigha chilisun, ");
INSERT INTO uiglat_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","andin pése-maxawdin pak qilinidighan kishige yette qétim sépishi bilen uni pak dep jakarlisun; we tirik qushni dalagha qoyup bersun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Pése-maxawdin pak qilinidighan kishi kiyimlirini yuyup, bedinidiki barliq tüklerni chüshürüp, suda yuyun’ghandin kéyin pak hésablinidu. Andin uninggha chédirgahqa kirishke ijazet bolidu; peqet u yette kün’giche öz chédirining téshida turushi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Yettinchi küni u bedinidiki hemme tüklerni chüshürsun; bashning chach-saqalliri we qéshini, yeni barliq tüklirini chüshürsun; u kiyimlirini yuyup öz bedinini suda yusun, andin pak bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sekkizinchi küni u ikki béjirim erkek qoza bilen bir yashqa kirgen béjirim chishi qozidin birni, shuningdek bir efahning ondin üchige barawer zeytun méyi ileshtürülgen ésil un «ashliq hediyesi»ni, bir log zeytun méyini keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Uni «pak» dep jakarlaydighan bu resim-qaidini ötküzidighan kahin pak qilinidighan kishini we u nersilerni jamaet chédirining kirish aghzida, Perwerdigarning aldida hazir qilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Andin kahin erkek qozilarning birini élip itaetsizlik qurbanliqi qilip sunup, uning bilen bille shu bir log zeytun méyinimu keltürüp, pulanglatma hediye süpitide Perwerdigarning aldida pulanglatsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Qoza bolsa muqeddes bir jayning ichide gunah qurbanliqi bilen köydürme qurbanliqlar boghuzlinidighan jayda boghuzlansun; chünki itaetsizlik qurbanliqi bolsa gunah qurbanliqigha oxshash, kahin’gha tewe bolup «eng muqeddeslerning biri» sanilidu.    ");
INSERT INTO uiglat_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kahin itaetsizlik qurbanliqining qénidin élip pak qilinidighan kishining ong quliqining yumshiqigha we ong qolining chong barmiqi bilen ong putining chong barmiqighimu sürüp qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Andin kahin shu bir log zeytun méyidin élip, özining sol qolining aliqinigha azghina quysun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Kahin ong barmiqini sol qolidiki zeytun méyigha chilap, Perwerdigarning aldida yette qétim barmiqi bilen sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Andin kahin qolidiki qalghan maydin élip, pak qilinidighan kishining ong quliqining yumshiqigha, ong qolining bash barmiqigha we ong putining bash barmiqigha sürülgen itaetsizlik qurbanliqining qénining üstige sürüp qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Sürüp bolup, kahin qolidiki éship qalghan mayni pak qilinidighan kishining béshigha quysun. Bu yol bilen kahin uning üchün Perwerdigarning aldida kefarǝt keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Andin kahin gunah qurbanliqini sunup, pak qilinidighan kishini napakliqidin pak qilishqa kefarǝt keltüridu; axirida u köydürme qurbanliqni boghuzlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kahin köydürme qurbanliq bilen ashliq hediyesini qurban’gahta sunsun. Bu yol bilen kahin uning üchün kefarǝt keltürüp, u kishi pak bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Lékin u kembeghelliktin shundaq qilishqa qurbi yetmise, özige kefarǝt keltürüsh üchün «pulanglatma hediye» süpitide yalghuz bir erkek qozini itaetsizlik qurbanliqi qilip keltürsun, shuningdek ashliq hediyesi üchün bir efahning ondin birige barawer zeytun méyi ileshtürülgen ésil un bilen bir log zeytun méyini keltürsun ");
INSERT INTO uiglat_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","we öz ehwaligha yarisha ikki paxtek yaki ikki bachka élip kelsun; biri gunah qurbanliqi üchün, yene biri köydürme qurbanliq üchün bolsun; ");
INSERT INTO uiglat_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","sekkizinchi küni bularni özining pak qilinishi üchün jamaet chédirining kirish aghzigha élip kélip, Perwerdigarning aldida kahinning qéshigha keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kahin itaetsizlik qurbanliqi bolidighan erkek qoza bilen shu bir log mayni élip, bularni pulanglatma hediye süpitide Perwerdigarning aldida pulanglatsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Itaetsizlik qurbanliqi qilin’ghan erkek qozini bolsa özi boghuzlisun; andin kahin itaetsizlik qurbanliqining qénidin azghina élip, pak qilinidighan kishining ong quliqining yumshiqigha, ong qolining bash barmiqigha we ong putining bash barmiqigha sürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Andin kahin maydin élip, sol qolining aliqinigha azghina quysun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Shundaq qilip, kahin ong barmiqi bilen sol qolidiki maydin Perwerdigarning aldida yette qétim sepsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Andin kahin özi qolidiki maydin élip, pak qilinidighan kishining ong quliqining yumshiqigha we ong qolining bash barmiqi bilen ong putining bash barmiqigha itaetsizlik qurbanliqining qénining üstige sürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Shuning bilen Perwerdigarning aldida uninggha kefarǝt keltürüshke kahin qolidiki mayning qalghinini pak qilinidighan kishining béshigha quysun; ");
INSERT INTO uiglat_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","andin shu kishi öz qurbigha qarap paxtektin birni yaki bachkidin birni sunsun; ");
INSERT INTO uiglat_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","öz qurbigha qarap, birini gunah qurbanliqi, yene birini köydürme qurbanliq qilip ashliq hediyesi bilen bille sunsun. Bu yolda kahin Perwerdigarning aldida pak qilinidighan kishi üchün kefarǝt keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Özide pése-maxaw bolghan, pak qilinishi üchün wajip bolidighan nersilerni keltürüshke qurbi yetmeydighan kishiler toghrisidiki qanun-belgilime mana shulardur. ");
INSERT INTO uiglat_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Perwerdigar Musa bilen Harun’gha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","— Siler Men özünglargha miras qilip béridighan Qanaan zéminigha kirgendin kéyin, Men siler ige bolidighan shu zémindiki bir öyge birxil pése-maxaw yarisini ewetsem, ");
INSERT INTO uiglat_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","öyning igisi kahinning qéshigha bérip, uninggha buni melum qilip: «Méning öyümge waba yuqqandek körünidu», dep melum qilishi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kahin bolsa: — Öydiki hemme nersiler napak bolmisun üchün men bérip bu wabagha sepsélip qarashtin burun öyni bikarlanglar, dep buyrusun. Andin kahin kirip öyge sepsélip qarisun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","U shu wabagha sepsélip qarighinida, mana öyning tamlirigha waba daghliri yuqqan jaylar kawak bolsa, hem yéshilgha mayil yaki qizghuch bolup, tamning yüzidin qéniqraq bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","kahin öyning ishikining aldigha chiqip, ishikni yette kün’giche taqap qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Andin kahin yettinchi küni yénip kélip, sepsélip qarighinida, öyning tamliridiki iz-dagh kéngiyip ketken bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","kahin: — Waba yuqqan tashlarni chiqirip sheherning sirtidiki napak bir jaygha tashliwétinglar, dep buyrusun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Shuning bilen birge u öyning ichining töt etrapini qirdursun we ular qirghan suwaqni bolsa sheherning téshidiki napak bir jaygha töküwetsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Andin ular bashqa tashlarni élip, ilgiriki tashlarning ornida qoysun we bashqa hak lay étip, uning bilen öyni qaytidin suwisun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Eger u tashlarni chiqirip, öyni qirdurup qaytidin suwatqandin kéyin, öyde waba déghi yene peyda bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","undaqta kahin yene kirip buninggha sepsélip qarisun. Sepsélip qarighinida, mana iz-dagh öyde kéngiyip ketken bolsa, bu öyge yuqqini chiritküch waba bolidu; öy napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Bu wejidin ular öyni, yeni yaghach-tash we barliq suwiqi bilen bille chüshürüp, hemmisini kötürüp sheherning sirtidiki napak bir jaygha tashliwetsun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Kimdekim öy taqalghan mezgilde uninggha kirse, u kech kirgüche napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Eger birkim öy ichide yatqan bolsa, kiyimlirini yusun; we eger birsi öyde ghizalan’ghan bolsa, umu öz kiyimlirini yusun. ");
INSERT INTO uiglat_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Lékin kahin kirip, öyge sepsélip qarighinida öy suwalghandin kéyin waba uningda kéngiyip ketmigen bolsa, undaqta kahin öyni «pak» dep jakarlisun; chünki uningdiki waba saqayghan bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Andin u öyning pak qilinishi üchün ikki qush, kédir yaghichi, qizil rext bilen zofa élip kélip, ");
INSERT INTO uiglat_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","qushlarning birini éqin su qachilan’ghan sapal kozining üstide boghuzlisun; ");
INSERT INTO uiglat_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","andin u kédir yaghichi, zofa, qizil rext we tirik qushni bille élip kélip, bu nersilerning hemmisini boghuzlan’ghan qushning qénigha, shundaqla éqin sugha chilap, öyge yette mertiwe sepsun; ");
INSERT INTO uiglat_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","bu yol bilen u öyni qushning qéni, éqin su, tirik qush, kédir yaghichi, zofa we qizil rext arqiliq napakliqtin paklaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Andin u tirik qushni sheherning sirtida, dalada qoyup bersun. U shundaq qilip, öy üchün kefarǝt keltüridu; u öy pak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Bular bolsa herxil pése-maxaw jarahiti, qaqach, ");
INSERT INTO uiglat_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","kiyim-kéchek we öyge yuqqan pése-maxaw wabasi, ");
INSERT INTO uiglat_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","téridiki chiqanlar, temretke we parqiraq aq iz-daghlar toghrisidiki qanun-belgilimidur. ");
INSERT INTO uiglat_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Shu belgilimiler bilen bir nersining qaysi ehwalda napak, qaysi ehwalda pak bolidighanliqini perq étishke körsetme bérishke bolidu; mana bu pése-maxaw toghrisidiki qanun-belgilimidur. ");
INSERT INTO uiglat_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Perwerdigar Musa bilen Harun’gha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Israillargha mundaq denglar: — Herqandaq erkekning öz ténidin aqma chiqsa shu kishi shu aqma sewebidin napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Aqma chiqishtin bolghan napakliq toghrisidiki höküm shuki, aqmisi meyli ténidin éqip tursun yaki éqishtin toxtitilghan bolsun, shu kishi yenila napak sanalsun; ");
INSERT INTO uiglat_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","mundaq aqma bolghan kishi yatqan herbir orun-körpe napak sanilidu we u qaysi nersining üstide oltursa shu nersimu napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Kimki u yatqan orun-körpige tegse, öz kiyimlirini yuyup, suda yuyunsun, andin kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Shuningdek kimki mundaq aqma bolghan kishi olturghan nerside oltursa öz kiyimlirini yuyup, suda yuyunsun we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Kimki aqma bolghan kishining ténige tegse, öz kiyimlirini yuyup, suda yuyunsun, we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Eger aqma bolghan kishi pak birsige tükürse, shu kishi öz kiyimlirini yuyup, suda yuyunsun, kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Qaysibir éger-toqumning üstige aqma bolghan kishi minse, shu nerse napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Kimki uning tégide qoyulghan nersilerge tegse kech kirgüche napak sanilidu; we kimki shu nersilerni kötürse, öz kiyimlirini yuyup, suda yuyunsun, we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Aqma bolghan kishi qolini yumastin birkimge tegküzse, shu kishi öz kiyimlirini yuyup, suda yuyunsun we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Aqma bolghan kishi sapal qachini tutup salsa, shu qacha chéqiwétilsun; yaghach qacha bolsa suda yuyulsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Qachaniki aqma bar kishi aqma halitidin qutulsa, özining pak qilinishi üchün yette künni hésablap ötküzüp, andin kiyimlirini yuyup, éqin suda yuyunsun; andin pak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Sekkizinchi küni ikki paxtek yaki ikki bachkini élip, jamaet chédirining kirish aghzigha, Perwerdigarning aldigha keltürüp, kahin’gha tapshursun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kahin ulardin birini gunah qurbanliqi üchün, yene birini köydürme qurbanliq üchün sunsun. Bu yol bilen kahin Perwerdigarning aldida uning aqma bolghanliqigha kefarǝt keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Eger bir erkekning meniysi özlükidin chiqip ketken bolsa, u pütün bedinini suda yusun, u kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Shuningdek ademning meniysi qaysi kiyimige yaki térisige yuqup qalsa, suda yuyulsun we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Er we ayal kishi bir-birige yéqinlishishi bilen meniy chiqsa, ikkisi yuyunsun we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Eger ayal kishiler aqma kélish halitide tursa we aqmisi xun bolsa, u yette kün’giche «ayrim» tursun; kimki uninggha tegse kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","«Ayrim» turush mezgilide, qaysi nersining üstide yatsa, shu nerse napak sanilidu, shundaqla qaysi nersining üstide olturghan bolsa, shu nersimu napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Herkim uning orun-körpisige tegse öz kiyimlirini yuyup, suda yuyunsun we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Herkim u olturghan nersige tegse, öz kiyimlirini yuyup, suda yuyunsun we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","We eger birkim u yatqan yaki olturghan jayda qoyulghan birer nersige tegse, kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Eger bir er kishi shu halettiki ayal bilen birge yatsa, shundaqla uning xun napakliqi shu erge yuqup qalsa, u yette kün’giche napak sanalsun; u yatqan herbir orun-körpimu napak sanalsun.    ");
INSERT INTO uiglat_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Eger ayal kishining adet waqtining sirtidimu birnechche kün’giche xuni kélip tursa, yaki xun aqmisi adet waqtidin éship ketken bolsa, undaqta bu napak qan éqip turghan künlirining hemmiside, u adet künliride turghandek sanalsun, yene napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Qan kelgen herbir künde u qaysi orun-körpe üstide yatsa, bular u adet künliride yatqan orun-körpilerdek hésablinidu; u qaysi nersining üstide olturghan bolsa, shu nerse adet künlirining napakliqidek napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Herkim bu nersilerge tegse napak bolidu; shu kishi kiyimlirini yuyup, suda yuyunsun we kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ayal kishi qachan xun kélishtin saqaysa, u yette künni hésablap, ötküzüp bolghanda pak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Sekkizinchi küni u ikki paxtek yaki ikki bachkini élip jamaet chédirining kirish aghzigha, kahinning qéshigha keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kahin bularning birini gunah qurbanliqi üchün, yene birini köydürme qurbanliq üchün ötküzsun; bu yol bilen kahin uning napak aqma qénidin pak bolushigha uning üchün Perwerdigarning aldida kefarǝt keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Siler mushu yol bilen Israillarni napakliqidin üzünglar; bolmisa, ular napakliqida turuwérip, ularning arisida turghan méning turalghu chédirimni bulghishi tüpeylidin napak halitide ölüp kétidu. ");
INSERT INTO uiglat_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Aqma kélish halitide bolghan kishi we meniy kétish bilen napak bolghan kishi toghrisida, ");
INSERT INTO uiglat_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Shuningdek xun kélish künliridiki aghriq ayal kishi toghruluq, aqma halette bolghan er we ayal toghruluq, napak halettiki ayal bille yatqan er toghruluq kelgen qanun-belgilime mana shulardur. ");
INSERT INTO uiglat_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Harunning ikki oghli Perwerdigarning aldigha yéqinlishishi bilen ölüp ketti. Ular ölüp ketkendin kéyin, Perwerdigar Musagha söz qildi. ");
INSERT INTO uiglat_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Perwerdigar Musagha mundaq dédi: — «Sen öz qérindishing Harun’gha: «Sen ölüp ketmesliking üchün perdining ichidiki muqeddes jaygha qoyulghan ehde sanduqining üstidiki «kefarǝt texti»ning aldigha her waqit kelme», dégin. Chünki Men «kefarǝt texti»ning üstidiki bulutta ayan bolimen. ");
INSERT INTO uiglat_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Harun eng muqeddes jaygha munu yol bilen kirsun: — Gunah qurbanliqi üchün bir yash torpaq, köydürme qurbanliq üchün bir qochqarni keltürsun; ");
INSERT INTO uiglat_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","özi muqeddes kanap xalta könglekni kiyip, etlirini yapidighan kanap ishtannimu kiyip, bélige bir kanap belwaghni baghlap, béshigha kanap sellini yögep kelsun. Bular muqeddes kiyimler bolghachqa, kiyishtin ilgiri bedinini suda yusun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","U Israillarning jamaitidin gunah qurbanliqi üchün ikki téke, köydürme qurbanliq üchün bir qochqarni tapshuruwalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Shuning bilen Harun awwal gunah qurbanliqi bolidighan torpaqni sunup, özi we öz öyidikiler üchün kefarǝt keltürüshi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Andin u ikki tékini élip, ularni jamaet chédirining kirish aghzining aldigha keltürüp, Perwerdigarning aldida turghuzsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Andin Harun bu ikki téke toghrisida chek tashlisun; chekning birini «Perwerdigar üchün», yene birini «azazel üchün» tashlisun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Harun Perwerdigargha chek chüshken tékini keltürüp, gunah qurbanliqi süpitide sunsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Lékin «azazel»ge chek chüshken tékini bolsa, kefarǝt keltürüshi üchün chölge heydilishke, shundaqla «azazel»ge ewetilishke Perwerdigarning aldida tirik qaldurulsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Andin Harun gunah qurbanliqini, yeni özi üchün bolghan torpaqni keltürüp, özi we öz öyidikiler üchün kefarǝt keltürüshke özige gunah qurbanliqi bolidighan bu torpaqni boghuzlisun; ");
INSERT INTO uiglat_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Andin u Perwerdigarning aldidiki qurban’gahtin élin’ghan chogh bilen tolghan bir xushbuydanni élip, ikki qollap yumshaq ézilgen ésil xushbuy etir bilen toldurup, buni perdining ichige élip barsun; ");
INSERT INTO uiglat_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","andin xushbuy is-tütiki höküm-guwah sanduqining üstidiki kefarǝt textini qaplisun dep, xushbuyni Perwerdigarning huzuridiki otning üstige qoysun; shuning bilen u ölmeydu. ");
INSERT INTO uiglat_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","U torpaqning qénidin élip öz barmiqi bilen kefarǝt textining sherq teripige chéchip, kefarǝt textining aldighimu öz barmiqi bilen qandin élip, yette qétim sepsun.    ");
INSERT INTO uiglat_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Andin u xelq üchün gunah qurbanliqi qilinidighan tékini boghuzlisun; qénini perdining ichige keltürüp, torpaqning qénini qilghandek qilsun, yeni uning qénidin élip kefarǝt textige we kefarǝt textining aldigha chachsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","U bu yol bilen muqeddes jay üchün kefarǝt keltürüp, uni Israillarning napakliqidin, hemme itaetsizliklirini élip baridighan gunahliridin paklaydu we shuningdek ularning napakliqi arisida turuwatqan jamaet chédiri üchünmu shundaq kefarǝt qilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","U kefarǝt keltürüsh üchün eng muqeddes jaygha kirgendin tartip uningdin chiqquche héchbir adem jamaet chédiri ichide bolmisun; bu yol bilen u özi, öyidikiler we Israilning pütkül jamaiti üchün kefarǝt keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Andin u Perwerdigarning aldidiki qurban’gahqa chiqip, uning üchünmu kefarǝt keltüridu; shuningdek torpaqning qéni bilen tékining qénidin élip qurban’gahning chörisidiki münggüzlerge sürsun; ");
INSERT INTO uiglat_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","u barmiqi bilen qandin élip qurban’gahning üstige yette qétim sepsun; shuning bilen u uni Israillarning napakliqliridin paklap Xudagha atap muqeddes qilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","— Muqeddes jay, jamaet chédiri we qurban’gah üchün kefarǝt keltürüp bolghandin kéyin, u tirik tékini keltürsun; ");
INSERT INTO uiglat_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","andin Harun ikki qolini tirik tékining béshigha qoyup turup, uning üstide turup, Israillarning barliq qebihlikliri we itaetsizliklirini élip baridighan gunahlirini iqrar qilip, ularni tékining béshigha artsun; andin uni yénida teyyar turidighan bir ademning qoli bilen chölge ewetiwetsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Bu yol bilen téke ularning hemme qebihliklirini öz üstige élip, ademzatsiz chölge kétidu. Shunga u tékini chölge qoyuwetsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","— Andin Harun jamaet chédirigha kirip muqeddes jaygha kirgen waqitta kiygen kanap kiyimlirini sélip shu yerde ularni qoyup qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","U muqeddes yerde öz bedinini suda yuyup, öz kiyimlirini kiyip tashqirigha chiqip, özining köydürme qurbanliqi bilen xelqning köydürme qurbanliqini sunup, shu yol bilen özi we xelq üchün kefarǝt keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Shundaqla u gunah qurbanliqining méyini qurban’gahta köydürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Azazel»ge békitilgen tékini élip bérip qoyuwetken kishi öz kiyimlirini yuyup, bedinini suda yuyup, andin chédirgahqa kirishke bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kefarǝt keltürüsh üchün qéni eng muqeddes jaygha élip kirilip, gunah qurbanliqi qilin’ghan torpaq bilen gunah qurbanliqi qilin’ghan tékini birsi chédirgahning tashqirigha élip chiqip, ularning térisi, göshi we tézeklirini otta köydürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ularni köydürgen kishi öz kiyimlirini yuyup, bedinini suda yuyup, andin chédirgahqa kirishke bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","— Mana bu silerge bir ebediy qanun-belgilime bolsun: — Her yettinchi ayning oninchi künide siler öz nepsinglarni tartip özünglarni töwen tutunglar we héchqandaq ish qilmanglar; meyli yerlikler bolsun yaki aranglarda turuwatqan Yaq. yurtluqlar bolsun shundaq qilishinglar kérek.    ");
INSERT INTO uiglat_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Chünki shu künide silerni paklashqa siler üchün kefarǝt keltürülidu; Perwerdigarning aldida siler hemme gunahliringlardin pak bolisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Bu kün silerge pütünley aram alidighan shabat küni bolup, nepsinglarni tartip özünglarni töwen tutisiler; bu ebediy bir belgilimidur. ");
INSERT INTO uiglat_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Kimki atisining ornida kahinliq yürgüzüsh üchün mesih qilinip, Xudagha atap tiklen’gen kahin bolsa shu yol bilen kefarǝt keltüridu. U kanaptin étilgen muqeddes kiyimni kiyip turup, ");
INSERT INTO uiglat_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Eng muqeddes jay üchün kefarǝt keltüridu; jamaet chédiri bilen qurban’gah üchünmu kefarǝt keltüridu; qalghan kahinlar bilen barliq xelqning jamaiti üchün hem kefarǝt keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Bu bolsa siler üchün ebediy bir belgilime bolidu; shuning bilen Israillarni barliq gunahliridin paklash üchün yilda bir qétim kefarǝt keltürüp bérisiler». Shuning bilen Harun Perwerdigar Musagha buyrughinidek qildi. ");
INSERT INTO uiglat_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Harun bilen oghulliri we barliq Israillargha mundaq dégin: — Perwerdigar silerge buyrughan höküm shuki: — ");
INSERT INTO uiglat_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Israilning jemetliridin bolghan herqandaq kishi qurbanliq qilmaqchi bolup, kala yaki qoy yaki öchkini jamaet chédirining kirish aghzida, Perwerdigarning turalghu chédirining aldigha, Perwerdigargha atalghan qurbanliq süpitide yétilep epkelmey, belki chédirgahning ichide yaki tashqirida boghuzlisa, uningdin aqqan qan shu kishining gedinige artilidu; bu adem «qan tökken» dep, öz xelqidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Bu hökümning meqsiti Israillarning hazirqidek dalada mal soyup qurbanliq qilishning ornigha, qurbanliqlirini jamaet chédirining kirish aghzida Perwerdigarning aldigha keltürüp, kahin’gha tapshurup Perwerdigargha inaqliq qurbanliqliri süpitide sunup boghuzlishi üchündur. ");
INSERT INTO uiglat_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kahin qanni élip jamaet chédirining kirish aghzining yénidiki Perwerdigarning qurban’gahining üstige sépip, Perwerdigargha xushbuy keltürüsh üchün mayni köydürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Shuning bilen ular emdi burunqidek buzuqluq qilip téke-jinlarning keynide yürüp, ulargha öz qurbanliqlirini ötküzüp yürmisun. Mana bu ular üchün dewrdin-dewrgiche ebediy bir belgilime bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Sen ulargha: — Israilning jemetidin yaki ularning arisida turuwatqan yaqa yurtluqlardin biri köydürme qurbanliq yaki bashqa qurbanliq ötküzmekchi bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","uni Perwerdigargha atap sunush üchün jamaet chédirigha kirish aghzining aldigha keltürmise, u kishi öz xelqliridin üzüp tashlansun» — dégin. ");
INSERT INTO uiglat_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Eger Israilning jemetidin bolghan herqandaq adem yaki ularning arisida turuwatqan yaqa yurtluqlar qan yése, Men yüzümni qanni yégen shu kishige qarshi qilimen, uni öz xelqidin üzüp tashlaymen. ");
INSERT INTO uiglat_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Chünki herbir janiwarning jéni bolsa uning qénididur; Men uni jéninglar üchün qurban’gah üstige kefarǝt keltürüshke bergenmen. Chünki qan özidiki janning wasitisi bilen kefarǝt keltüridu. ");
INSERT INTO uiglat_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Shunga bu sewebtin Men Israillargha: — «Silerning héchbiringlar qan yémeslikinglar kérek, aranglarda turuwatqan yaqa yurtluqlarmu qan yémesliki kérek» — dégenidim. ");
INSERT INTO uiglat_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Eger Israillardin biri yaki ularning arisida turuwatqan yaqa yurtluqlarning biri yéyishke bolidighan bir charpay haywan yaki qushni owlap, qénini tökse, uni topa bilen yépip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Chünki herbir janiwarning jéni bolsa, uning qénidin ibarettur. Uning jéni qénida bolghach men Israillargha: «Siler héchqandaq janiwarning qénini yémenglar, chünki herbir janiwarning jéni uning qénididur; kimki uni yése üzüp tashlinidu» — dédim. ");
INSERT INTO uiglat_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Kimdekim ölüp qalghan yaki yirtquchlar boghup titma-titma qiliwetken bir haywanni yése, meyli u yerlik yaki yaqa yurtluq bolsun öz kiyimlirini yuyup, suda yuyunsun we kech kirgüche napak sanalsun; andin u pak bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Lékin u yaki kiyimlirini yumisa, yaki suda bedinini yumisa, shu kishi öz qebihlikining jazasini tartidu. ");
INSERT INTO uiglat_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Sen Israillargha mundaq dégin: — «Men bolsam Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Siler ilgiri turghan Misir zéminidikidek ishlarni qilmanglar we yaki Men silerni élip baridighan Qanaan zéminidikidek ishlarni qilmanglar; ularning resim-adetliride yürmenglar, ");
INSERT INTO uiglat_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","belki Méning hökümlirimge emel qilip, qanun belgilimilirimni tutup shu boyiche ménginglar. Men Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Siler choqum Méning belgilimilirim bilen hökümlirimni tutushunglar kérek; insan ulargha emel qilidighan bolsa ularning sewebidin hayatta bolidu. Men Perwerdigardurmen.    ");
INSERT INTO uiglat_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","— Héchkim özige yéqin tughqan bolghan ayalgha yéqinliq qilip ewritini achmisun. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Anangning ewritige tegme, bu atangning ewritige tegkining bolidu; u séning anang bolghachqa uning ewritige tegseng bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Atangning ayalining ewritigimu tegme, chünki shundaq qilsang atangning ewritige tegkendek bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Sen acha-singlingning, bir atidin bolghan yaki bir anidin bolghan, yaki shu öyde tughulghan yaki bashqa yerde tughulghan bolsun, uning ewritige tegme. ");
INSERT INTO uiglat_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Sen öz oghlungning qizi we yaki qizingning qizining ewritige tegme; chünki ularning ewriti sen özüngning ewritidur. ");
INSERT INTO uiglat_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Sen atangning ayalining qizining ewritige tegme; u atangdin tughulghan, séning acha-singling, shunga uning ewritige tegme.    ");
INSERT INTO uiglat_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Sen atangning acha-singlisining ewritigimu tegme, chünki u atangning birtughqinidur. ");
INSERT INTO uiglat_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Sen anangning acha-singillirining ewritigimu tegme, chünki u anangning birtughqinidur. ");
INSERT INTO uiglat_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Atangning aka-inilirining ayalining ewritige tegme; ularning ayallirigha yéqinliq qilma; chünki ular séning hammangdur. ");
INSERT INTO uiglat_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Sen kéliningning ewritige tegme; u séning oghlungning ayali bolghachqa, uning ewritige tegseng bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Sen aka-iniliringning ayalining ewritige tegme; chünki bu öz aka-iniliringning ewritige tegkendek bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Sen bir ayalgha we shuning bilen birge uning qizining ewritige tegme; shundaqla uning oghlining qizi we qizining qizinimu xotunluqqa élip ewritige tegme. Ular bir-birige yéqin tughqan bolghachqa, mundaq ish pesendiliktur. ");
INSERT INTO uiglat_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Sen ayaling hayat waqtida, uning acha-singlisini xotunluqqa élip ewritige tegme. Undaq qilsang xotununggha kündeshlik azabini keltürisen. ");
INSERT INTO uiglat_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Sen bir ayalning adet körüp napak turghan waqtida yéqinliq qilip ewritige tegme.    ");
INSERT INTO uiglat_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Sen öz qoshnangning ayali bilen zina qilip özüngni uning bilen napak qilma. ");
INSERT INTO uiglat_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Sen öz neslingdin héchbirini Molek mebudigha atap ottin ötküzseng qet’iy bolmaydu. Eger shundaq qilsang Xudayingning namini napak qilghan bolisen. Men Özüm Perwerdigardurmen.    ");
INSERT INTO uiglat_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Sen ayallar bilen birge bolghandek er kishi bilen birge bolma. Bu ish yirginchliktur. ");
INSERT INTO uiglat_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Sen héch haywan bilen munasiwet qilip özüngni napak qilma; shuningdek ayal kishimu munasiwet qildurush üchün bir haywanning aldigha barmisun. Bu ish nijisliqtur. ");
INSERT INTO uiglat_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Siler bu ishlarni qilip özünglarni napak qilmanglar, chünki men silerning aldinglardin chiqiriwatqan taipiler bolsa shundaq ishlarni qilip özlirini napak qilghan ");
INSERT INTO uiglat_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","we zéminimu napak bolghandur. Buning üchün Men u zéminning qebihlikini öz béshigha chüshürimen, shuningdek u zéminmu özide turuwatqanlarni qusup chiqiriwétidu. ");
INSERT INTO uiglat_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Lékin siler bolsanglar Méning belgilimilirim bilen hökümlirimni tutunglar; silerdin héchkim, meyli yerlik yaki aranglarda turuwatqan yaqa yurtluq bolsun bu yirginchlik ishlardin héchbirini qilmisun ");
INSERT INTO uiglat_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(chünki bu barliq yirginchlik ishlarni silerdin ilgiri shu zéminda turghan xelq qilip kelgechke, zéminning özi napak bolup qaldi). ");
INSERT INTO uiglat_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Shundaq qilip zéminni napak qilsanglar, zémin özi silerdin ilgiri özide turghan ellerni qusup chiqarghandek, silernimu qusup chiqiriwétidu. ");
INSERT INTO uiglat_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Chünki bu yirginchlik ishlarning herqandiqini qilghuchi, — mundaq qilmishlarni qilghan herqandaq kishi öz xelqi arisidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Siler Men silerge tapilighinimgha emel qilishinglar zörürdur; — démek, siler özünglardin ilgiri ötkenler tutqan shu yirginchlik resim-qaidilerni tutup, özünglarni napak qilmasliqinglar kérek. Men Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Sen Israillarning pütkül jamaitige söz qilip ulargha mundaq dégin: — «Men Xudayinglar Perwerdigar muqeddes bolghachqa, silermu muqeddes bolushunglar kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Siler herbiringlar ananglar bilen atanglarni izzetlenglar; Méning shabat künlirimni bolsa, ularni tutushunglar kérek. Men özüm Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Siler erzimes butlargha tayanmanglar, özünglar üchün quyma butlarni yasimanglar. Men özüm Xudayinglar Perwerdigardurmen.    ");
INSERT INTO uiglat_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Siler Perwerdigargha inaqliq qurbanliqini keltürüshni xalisanglar, qobul qilin’ghudek yol bilen uni sununglar. ");
INSERT INTO uiglat_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Siler uni sun’ghan küni we etisi u yéyilsun; üchinchi künige qalghini bolsa otta köydürülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Eger uningdin bir qismi üchinchi küni yéyilse qurbanliq haram hésablinip qobul qilinmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Kimki uningdin yése öz gunahini öz üstige alidu, chünki u Perwerdigargha atap muqeddes qilin’ghan nersini napak qildi; undaq kishi öz xelqidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Siler zémininglardiki hosulni yighsanglar, sen étizingning bulung-pushqaqlirighiche tamam yighiwalma we hosulungdin qalghan wasangni tériwalmighin. ");
INSERT INTO uiglat_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Üzüm talliringni pasangdiwatma we üzüm talliridin chüshken üzümlernimu tériwalma, belki bularni kembegheller bilen musapirlargha qoyghin. Men Özüm Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Siler oghriliq qilmanglar, aldamchiliq qilmanglar, bir-biringlargha yalghan sözlimenglar. ");
INSERT INTO uiglat_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Méning namim bilen yalghan qesem ichmenglar, undaq qilsang Xudayingning namini bulghaysen. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Öz qoshnanggha zulum qilma, uningkini özüngning qiliwalma. Medikarning heqqini kéchiche yéningda qondurup qalma. ");
INSERT INTO uiglat_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Gas kishini tillima, kor kishining aldida putlishangghu nersini qoyma; belki öz Xudayingdin qorqqin. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Höküm qilghininglarda héch naheqliq qilmanglar; namratqimu yan basmay, bayghimu yüz-xatire qilmay, belki adilliq bilen öz qoshnang üstidin toghra höküm qilghin. ");
INSERT INTO uiglat_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Öz xelqingning arisida gep toshughuchi bolup yürme; qoshnangning jénigha héchqandaq ziyan-zexmet yetküzme. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Sen könglüngde öz qérindishingdin nepretlenmigin; qoshnangda gunah bolsa sen uning sewebidin béshinggha gunah kélip qalmasliqi üchün uninggha tenbih-nesihet bergin. ");
INSERT INTO uiglat_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Sen intiqam almighin we öz xelqingning neslige héch adawetmu saqlimighin, belki qoshnangni özüngni söygendek söygin. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Siler Méning qanun-belgilimilirimni tutunglar. Sen öz charpayliringni bashqa nesiller bilen chépishturma, étizinggha ikki xil uruq salmighin, ikki xil yiptin toqulghan kiyimni kiyme. ");
INSERT INTO uiglat_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Eger bir er kishi qiz-chokan bilen yétip munasiwet ötküzse, we u bashqa biri bilen wedileshken dédek bolsa, bu dédekning hörlük puli tapshurulmighan bolsa, yaki uninggha hörlük bérilmigen bolsa, muwapiq jaza bérilsun. Lékin qiz-chokan hör qilinmighachqa, her ikkisi öltürülmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Er kishi bolsa özining itaetsizlik qurbanliqini jamaet chédirining kirish aghzining aldigha, Perwerdigarning aldigha keltürsun; itaetsizlik qurbanliqi bir qochqar bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kahin u itaetsizlik qurbanliqi üchün keltürgen qochqarni élip uning sadir qilghan gunahi üchün Perwerdigarning aldida kefarǝt keltüridu; uning qilghan gunahi uningdin kechürülidu. ");
INSERT INTO uiglat_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Siler zémin’gha kirip herxil yeydighan méwilik derexlerni tikken bolsanglar, méwilirini «xetnisiz» dep qaranglar; üch yilghiche buni «xetnisiz» dep qarap uningdin yémenglar. ");
INSERT INTO uiglat_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Tötinchi yili ularning hemme méwiliri Perwerdigargha medhiye süpitide muqeddes qilip béghishlansun. ");
INSERT INTO uiglat_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Andin beshinchi yildin tartip siler ularning méwiliridin yéyishke bashlanglar. Shundaq qilsanglar zémin mehsulatlirini silerge ziyade qilidu. Men Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Siler qan chiqmighan nersini yémenglar. Ne palchiliq ne jadugerlik qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Siler béshinglarning chéke-chörisidiki chachni chüshürüp dügilek qiliwalmanglar, saqalning uch-yanlirini buzmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Siler ölgenler üchün bedininglarni zexim yetküzüp tilmanglar, özünglargha héchqandaq gül-süret chekmenglar. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Sen qizingni buzuqluq-pahishilikke sélip napak qilmighin. Bolmisa, zémindikiler buzuqluq-pahishilikke bérilip, pütkül zéminni eysh-ishret qaplap kétidu. ");
INSERT INTO uiglat_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Siler Méning shabat künlirimni tutunglar, Méning muqeddes jayimni hörmetlenglar. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Jinkeshler bilen séhirgerlerge tayanmanglar, ularning keynidin yürüp özünglarni napak qilmanglar. Men özüm Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Aq bash kishining aldida ornungdin tur, qérilarni hörmet qilghin; Xudayingdin qorqqin. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Bir musapir zéminda aranglarda turuwatqan bolsa siler uninggha zulum qilmanglar, ");
INSERT INTO uiglat_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","belki aranglarda turuwatqan musapir silerge yerlik kishidek bolsun; uni özüngni söygendek söygin; chünki silermu Misir zéminida musapir bolghansiler. Men Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Silerning höküm chiqirishinglarda, uzunluq, éghirliq we hejim ölcheshte héchqandaq naheqlik bolmisun; ");
INSERT INTO uiglat_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","silerde adil taraza, adil taraza tashliri, adil efah kemchini bilen adil hin kemchini bolsun. Men silerni Misir zéminidin chiqirip kelgen Xudayinglar Perwerdigardurmen.    ");
INSERT INTO uiglat_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Siler Méning barliq qanun-belgilimilirim we barliq hökümlirimni tutup, ulargha emel qilinglar; men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Sen Israillargha söz qilip mundaq dégin: — Eger Israillarning biri we yaki Israil zéminida turuwatqan musapirlarning biri Molek butigha neslining birini béghishlisa, uninggha ölüm jazasi bérilishi kérek; zémindikiler uni chalma-kések qilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","We Men Öz yüzümni bu kishige qarshi qilimen, chünki özi öz ewladlirining birini Molek butigha béghishlap muqeddes jayimni paskina qilip, Méning namimni bulghighini üchün uni öz xelqidin üzüp tashlaymen. ");
INSERT INTO uiglat_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Eger zéminda turuwatqanlar öz neslidin birini Molekke béghishlighanda shu kishige közlirini yumup, uning bilen kari bolmisa, shundaqla uni öltürmise, ");
INSERT INTO uiglat_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Men Özüm yüzümni u kishi bilen uning ailisige qarshi qilimen, uni we uninggha egiship buzuqchiliq qilghuchilar, yeni Molekning keynidin yürüp buzuqchiliq qilghuchilarning hemmisini öz xelqidin üzüp tashlaymen. ");
INSERT INTO uiglat_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Jinkeshler bilen séhirgerlerge tayinip, ularning keynige kirip buzuqchiliq qilip yürgüchiler bolsa, Men yüzümni shu kishilerge qarshi qilip, uni öz xelqidin üzüp tashlaymen. ");
INSERT INTO uiglat_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Shunga özünglarni pak qilip muqeddes bolunglar, chünki Men Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Qanun-belgilimilirimni tutup, ulargha emel qilinglar; Men bolsam silerni muqeddes qilghuchi Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Eger birkim öz atisi yaki anisini qarghisa, ulargha ölüm jazasi bérilmise bolmaydu; chünki u öz ata-anisini qarghighini üchün öz qéni öz béshigha chüshken bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Eger birkim bashqisining ayali bilen zina qilsa, yeni öz qoshnisining ayali bilen zina qilsa, zina qilghan er bilen ayal ikkisi ölüm jazasini tartmisa bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Eger birsi atisining ayali bilen yatsa, öz atisining ewritige tegken bolidu; ular ikkisi ölüm jazasini tartmisa bolmaydu; ularning qéni öz béshigha chüshken bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Birsi öz kélini bilen yatsa, ikkisi nijisliq qilghini üchün ölüm jazasini tartmisa bolmaydu; ularning qéni öz béshigha chüshken bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Birsi ayal kishi bilen yatqandek er kishi bilen yatsa ikkisi yirginchlik ish qilghan bolidu; ulargha ölüm jazasi bérilmise bolmaydu. Öz qéni öz béshigha chüshken bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Eger birsi qizi bilen anisini qoshup xotunluqqa alsa pesendilik qilghan bolidu. Er bilen ikki ayal otta köydürülsun. Shuning bilen aranglarda héch pesendilik ish bolmaydu.    ");
INSERT INTO uiglat_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Birsi bir haywan bilen munasiwet ötküzse, u ölüm jazasini tartsun, haywannimu ölturünglar. ");
INSERT INTO uiglat_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Eger ayal kishi bir haywanning qéshigha bérip munasiwet qildursa, ayal bilen haywanning ikkisini öltürünglar; öz qéni öz béshigha chüshken bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Birsi acha-singlisini, yeni atisidin yaki anisidin bolghan qizni élip, ewritige tegse we bu qizmu uning ewritige tegse uyatliq ish bolidu; shuning üchün er-ayal ikkisi öz xelqining köz aldidin üzüp tashlansun; u öz acha yaki singlisining ewritige tegkechke, öz qebihliki öz béshigha chüshken bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Birsi adet körgen aghriq waqtida bir ayal bilen birge yétip, uning ewritige tegse, undaqta u uning qan menbesige tegken, ayalmu qan menbesini échip bergen bolup, ikkisi öz xelqidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Sen öz anangning acha-singlisi we atangning acha-singlisining ewritige tegme; chünki kimki shundaq qilsa yéqin tughqinining ewritige tegken bolidu; ular ikkilisining öz qebihliki öz béshigha chüshken bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Birsi taghisining ayali bilen yatsa taghisining ewritige tegken bolidu; ikkilisi öz gunahini öz béshigha alidu; ular perzentsiz ölidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Birsi aka-inisining ayalini alsa paskina bir ish bolidu. U öz birtughqan aka-inisining ewritige tegken bolidu; ular ikkilisi perzentsiz qalidu.    ");
INSERT INTO uiglat_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Siler Méning barliq qanun belgilimilirim bilen barliq hökümlirimni tutup, buninggha muwapiq emel qilinglar; bolmisa, Men silerni élip bérip turghuzidighan zémin silerni qusup chiqiriwétidu. ");
INSERT INTO uiglat_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Siler Men aldinglardin heydiwétidighan ellerning resim-qaidiliri boyiche mangsanglar bolmaydu; chünki ular bu yirginchlik ishlarning hemmisini qilip keldi, we shuning üchün ular Manga yirginchlik boldi. ");
INSERT INTO uiglat_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Shuning üchün Men silerge: «Siler ularning zéminini miras qilip alisiler; Men shu süt bilen hesel aqidighan zéminni silerge bérimen», dep éytqanidim; silerni bashqa xelqlerdin ayrim qilghan Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Shunga siler pak we napak charpaylarni perq étip, pak we napak uchar-qanatlarni tonup, Men siler üchün ayrip, napak qilip békitip bergen janiwarlarning ichidin herqandiqi, charpay yaki uchar-qanat bolsun yaki yerde ömiligüchi janiwar bolsun, ularning héchbiri bilen özünglarni napak qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Siler Manga xas pak-muqeddes bolushunglar kérek; chünki Men Perwerdigar pak-muqeddesturmen, silerni Manga xas bolsun dep barliq ellerdin ayrim qilghanmen. ");
INSERT INTO uiglat_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Jinkesh yaki séhirger bolghan herqandaq er yaki xotun kishige ölüm jazasi bérilmise bolmaydu; xelq ularni chalma-kések qilsun; ularning qéni öz béshigha chüshken bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — Sen kahinlar bolghan Harunning oghullirigha mundaq dégin: — bir kahin öz xelqining arisidiki ölgenler wejidin özini napak qilmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Peqet özining yéqin tughqanliri üchün — anisi bilen atisi, oghli bilen qizi we aka-inisining ölüki tüpeylidin özini napak qilsa bolidu; ");
INSERT INTO uiglat_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","shuningdek eger acha-singlisi erge tegmey pak qiz halette özi bilen bille turuwatqan bolsa, uning ölüki tüpeylidin özini napak qilsa bolidu; ");
INSERT INTO uiglat_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","chünki kahin öz xelqining arisida mötiwer bolghachqa, özini napak qilip bulghimasliqi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Kahinlar béshini yérim-yata qilip chüshürmesliki, saqilining uch-yanlirini hem chüshürmesliki, bedinigimu zexim yetküzüp tilmasliqi kérek, ");
INSERT INTO uiglat_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","belki ular öz Xudasigha muqeddes turup, Xudasining namini bulghimasliqi kérek; chünki ular Perwerdigargha atap otta sunulidighan qurbanliqlarni, öz Xudasining nénini sunidu; shunga ular muqeddes bolushi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ular bir ayalni öz emrige alghanda pahishe ayalnimu, buzuq ayalnimu almasliqi kérek we éri qoyuwetken ayalnimu almisun. Chünki kahin bolsa öz Xudasigha xas muqeddes qilin’ghan. ");
INSERT INTO uiglat_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","U Xudayingning nénini sun’ghini üchün u sanga nisbeten muqeddes dep sanilishi kérek; chünki silerni muqeddes qilghuchi Perwerdigar Özüm muqeddesturmen. ");
INSERT INTO uiglat_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Eger bir kahinning qizi pahishilik qilip özini bulghighan qilsa, öz atisini bulghighan bolidu; u otta köydürülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Béshigha mesihlesh zeytun méyi tökülgen, kahinliq kiyimlerni kiyishke tiklen’gen, öz qérindashlirining arisida bash kahin qilin’ghan kishi yalangbash bolmisun, kiyimlirinimu yirtmisun; ");
INSERT INTO uiglat_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","U yene héch ölükke yéqinlashmasliqi kérek, hetta atisi we yaki anisining ölüklirining wejidin özini napak qilmasliqi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","U wezipiside turuwatqanda muqeddes jaydin hergiz ayrilmisun we shuningdek Xudasining muqeddes jayini bulghimasliqi kérek; chünki uning Xudasining uni Özige xas qilghan «mesihlesh méyi» uning béshida turidu. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","U xotun alsa pak qizni élishi kérek; ");
INSERT INTO uiglat_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","tul we yaki erdin qoyuwétilgen ayal we yaki buzuq we yaki pahishe ayal bolsa bularni almasliqi, belki öz xelqidin bolghan pak qizni xotunluqqa élishi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Bolmisa u öz xelqining arisida öz uruqini napak qilidu; chünki uni muqeddes qilghuchi Perwerdigar Mendurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Sen Harun’gha mundaq dégin: — «Ewladtin-ewladqiche séning neslingdin bolghan birsi méyip bolsa, Xudaning nénini sunush üchün yéqin kelmisun; ");
INSERT INTO uiglat_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","méyip bolghan herqandaq kishi hergiz yéqin kelmisun — yaki kor bolsun, tokur bolsun, panaq bolsun yaki bir ezasi yene bir jüpidin uzun bolghan adem bolsun, ");
INSERT INTO uiglat_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","puti yaki qoli sunuq bolsun, ");
INSERT INTO uiglat_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","dok bolsun, parpa bolsun, közide aq bolsun, qichishqaq bolghan bolsun, temretke basqan bolsun yaki uruqdéni ézilgen herkim bolsun, ");
INSERT INTO uiglat_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Harun kahinning neslidin bolghan undaq méyip kishilerning héchbiri Perwerdigargha atap otta sunulidighan nersilerni keltürüshke yéqin barmisun; undaq kishi méyiptur; u öz Xudasining nénini sunushqa yéqin kelmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Halbuki, u öz Xudasining nénini, yeni «eng muqeddes» we «muqeddes» hésablan’ghan nersilerning her ikkisidin yésun. ");
INSERT INTO uiglat_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Peqet u perdidin ötüp ichkirisige kirmesliki yaki qurban’gahqimu yéqin barmasliqi kérek; chünki u méyiptur; bolmisa, u Méning muqeddes jaylirimni bulghighan bolidu; chünki ularni muqeddes qilghuchi Perwerdigar Özümdurmen». ");
INSERT INTO uiglat_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Bu sözlerning hemmisini Musa Harun bilen uning oghulliri we Israillarning hemmisige éytip berdi. ");
INSERT INTO uiglat_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Sen Harun bilen uning oghullirigha mundaq dégin: — «Siler Israillarning Manga atighan muqeddes hediyelerni éhtiyatchanliq bilen bir terep qilinglar, bolmisa ular namimni bulghishi mumkin. Men Perwerdigardurmen». ");
INSERT INTO uiglat_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ulargha mundaq dégin: — «Siler herbir dewrlerde, barliq nesillinglardin herqaysisi Israillar Perwerdigargha atighan pak nersilerge napak halette yéqinlashsa, undaq kishi Méning aldimdin üzüp tashlinidu. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Harunning neslidin biri pése-maxaw yaki aqma késili bolghan bolsa, pak bolmighuche muqeddes nersilerdin yémisun. Birkim ölükning sewebidin napak bolghan birkimge we yaki meniysi éqip ketken kishige tégip ketse, ");
INSERT INTO uiglat_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","yaki ademni napak qilidighan ömiligüchi janiwargha tegse yaki herqandaq yuqup qalidighan napakliqi bar bir ademge tégip ketse, (napakliqi némidin bolushidin qet’iynezer) ");
INSERT INTO uiglat_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","mundaq nersilerge tegken kishi kech kirgüche napak bolup, muqeddes nersilerdin yémisun. U bedinini suda yusun ");
INSERT INTO uiglat_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","andin kün olturghanda pak sanilip, muqeddes nersilerdin yéyishke bolidu; chünki bular uning ozuqidur. ");
INSERT INTO uiglat_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","U özlükidin ölgen we yaki yirtquchlar boghup qoyghan haywanni yéyish bilen özini napak qilmisun. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ular Méning bu tapilighanlirimni tutushi kérek; bolmisa, buninggha ixlassizliq qilsa, shu ölük tüpeylidin gunahkar bolup ölidu; ularni muqeddes qilghuchi Perwerdigar Özümdurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kahinlargha yat bolghan héchqandaq kishi muqeddes nersilerdin yémisun. Kahinning yénidiki musapir-méhman we yaki medikari bolsun ularmu muqeddes nersilerdin yémisun. ");
INSERT INTO uiglat_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Halbuki, kahin özi pul chiqirip sétiwalghan qul uningdin yéyishke bolidu; shuningdek uning öyide tughulghan kishimu uningdin yése bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kahinning qizi yat kishige tegken bolsa umu «kötürme hediye» süpitide atalghan muqeddes nersilerdin yémisun. ");
INSERT INTO uiglat_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Lékin eger kahinning qizi tul bolup qélip, yaki qoyup bérilip perzentsiz halette atisining öyige yénip kélip, yash waqtidikidek olturghan bolsa, undaqta atisining taamidin yéyeleydu; lékin héchbir yat kishi uningdin yémesliki kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Eger birkim bilmey, muqeddes nersilerdin yep salsa, undaqta u uninggha shuning beshtin birini qoshup, muqeddes nersining özi bilen kahin’gha qayturup bersun. ");
INSERT INTO uiglat_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Kahinlar Israillarning Perwerdigargha atighan nersilirini bulghimasliqi kérek; ");
INSERT INTO uiglat_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","bolmisa, xelq muqeddes hediyilerdin yéyishi bilen, kahinlar xelqning gedinige itaetsizlik gunahini yüklep qoyghan bolidu; chünki ularni muqeddes qilghuchi Perwerdigar Özümdurmen». ");
INSERT INTO uiglat_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Sen Harun bilen uning oghulliri we Israillarning hemmisige mundaq dégin: — Eger Israil jemetidin biri we yaki Israil zéminida turuwatqan musapirlarning biri öz qesemlirige baghliq qurbanliq yaki ixtiyariy qurbanliqni sunup, Perwerdigargha atap köydürme qurbanliq qilmaqchi bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","undaqta u qobul qilinishi üchün béjirim erkek kala, qoy yaki öchkilerdin keltürünglar. ");
INSERT INTO uiglat_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Eyibi bolmighan bir janiwarni sunushunglar kérek; chünki shundaq bolghini siler üchün qobul qilinmas. ");
INSERT INTO uiglat_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Birsi kalilardin yaki ushshaq maldin öz qesemlirige baghliq qurbanliq yaki ixtiyariy qurbanliqni sunup, Perwerdigargha atap inaqliq qurbanliqi qilmaqchi bolsa, sunulghan haywan qobul qilinishi üchün béjirim bolushi kérek; uning héchqandaq eyibi bolmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kor yaki aqsaq-cholaq, chonaq yaki yarisi yiringdap ketken, temretke basqan yaki qotur-chaqa bésip qalghan haywanlar bolsa — bularni Perwerdigargha atap sunsanglar yaki bularni Perwerdigargha atap qurbanliq süpitide qurban’gahta otta köydürsenglar bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Torpaq yaki qoyning melum jüp ezasidin biri uzunraq ya qisqa bolsa, mundaqlarni ixtiyariy qurbanliq süpitide ötküzseng bolidu, lékin qesemge baghliq bolsa qurbanliq üchün qobul qilinmas. ");
INSERT INTO uiglat_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Uruqdini zeximlen’gen, ézilip ketken, yérilghan yaki pichilghan haywanni Perwerdigargha atap qurbanliq qilmanglar. Mundaq ishni öz zémininglardimu hergiz qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Xudayinglarning néni süpitide yaqa yurtluq kishining qolidin shundaq haywanlardin héchqaysisini élip sunmanglar; chünki ular méyip bolghachqa, siler üchün qobul qilinmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Bir mozay, qoza yaki oghlaq tughulsa yette kün’giche anisini emsun; sekkizinchi künidin bashlap Perwerdigargha atap otta sunidighan qurbanliq süpitide qobul bolushqa yaraydu. ");
INSERT INTO uiglat_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Meyli kala bolsun, qoy bolsun, siler anisi bilen balisini bir künde boghuzlimanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Siler Perwerdigargha atap bir teshekkür qurbanliqi sunmaqchi bolsanglar, qobul qilinishqa layiq bolghan yol bilen sununglar. ");
INSERT INTO uiglat_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","U sunulghan künide yéyilishi kérek; uningdin héchnémini etisige qaldurmasliqinglar kérek. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Siler Méning emrlirimni ching tutup, ulargha emel qilinglar. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Méning muqeddes namimni bulghimanglar, Men emdi Israillarning arisida muqeddes dep bilinimen. Men silerni muqeddes qilghuchi Perwerdigar bolup, ");
INSERT INTO uiglat_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Xudayinglar bolushqa silerni Misir zéminidin chiqirip keldim. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Sen Israillargha mundaq dégin: — Perwerdigar békitken héytlar, siler muqeddes sorunlar bolsun dep chaqirip jakarlaydighan héytlirim mana munulardur: — ");
INSERT INTO uiglat_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","(alte kün ish-emgek qilinsun; lékin yettinchi küni «xas shabat küni», muqeddes sorunlar küni bolidu; u küni héchqandaq ish-emgek qilmanglar. Qeyerdila tursanglar bu kün Perwerdigargha atalghan shabat küni bolidu).    ");
INSERT INTO uiglat_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Siler békitilgen künliri muqeddes sorunlar bolsun dep chaqirip jakarlaydighan, Perwerdigarning héytliri mana munulardur: — ");
INSERT INTO uiglat_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Birinchi ayning on tötinchi küni gugumda Perwerdigargha atalghan «ötüp kétish héyti» bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Shu ayning on beshinchi küni Perwerdigargha atalghan «pétir nan» héyti bolidu; siler yette kün’giche pétir nan yeysiler. ");
INSERT INTO uiglat_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Birinchi künide siler muqeddes yighilish qilip, héchqandaq ish-emgek qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Siler yette kün’giche Perwerdigargha atap otta sunidighan qurbanliqlarni sunup turunglar. Yettinchi künide muqeddes yighilish bolidu; héchqandaq ish-emgek qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Sen Israillargha mundaq dégin: — Siler Men özünglargha teqdim qilidighan zémin’gha kirip, uningdin hosul yighqininglarda, hosulunglarning deslepki pishqinidin bir baghlamni kahinning qéshigha élip béringlar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kahin siler üchün qobul bolushqa uni Perwerdigarning aldida pulanglatsun; uni pulanglatqan waqit bolsa shabatning etisi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Siler uni pulanglatqan künde siler bir yashqa kirgen béjirim bir qozini Perwerdigargha atap köydürme qurbanliq süpitide sununglar; ");
INSERT INTO uiglat_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","shuninggha qoshup ashliq hediyesi süpitide zeytun méyi ileshtürülgen ésil undin bir efahning ondin birini Perwerdigargha xushbuy keltürsun dep otta sununglar; buninggha qoshup sharab hediyesi süpitide sharabtin bir hinning töttin birini sununglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Siler Xudayinglargha xas bolghan bu hediyeni sunidighan kündin ilgiri yéngi hosuldin héchnémini, ne nan ne qomach ne kök bash bolsun yémenglar. Bu dewrdin-dewrgiche siler üchün qeyerde tursanglar ebediy bir belgilime bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Andin siler shu shabat künning etisidin, yeni shu bir baghlamni pulanglatma hediye süpitide sun’ghan künning etisidin tartip, yette hepte sananglar (ular toluq hepte bolushi kérek); ");
INSERT INTO uiglat_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","yettinchi shabatning ikkinchi künigiche ellik künni sananglar; andin Perwerdigargha atap yéngi hosuldin bir ashliq hediyesi sununglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Özünglar turuwatqan jaylardin pulanglatma hediye süpitide ésil undin bir efahning ondin ikkiside étilgen ikki nanni élip keltürünglar; ular échitqu sélip étilgen bolsun; bular Perwerdigargha atalghan deslepki hosul hediyesi dep hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Nandin bashqa yene bir yashliq yette béjirim qoza, yash bir torpaq we ikki qochqarni köydürme qurbanliq süpitide Perwerdigargha atap sununglar; ulargha xas ashliq hediyeliri we sharab hediyelirini qoshup, hemmisi Perwerdigargha xushbuy keltürüshke sunulsun. ");
INSERT INTO uiglat_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Buningdin bashqa siler gunah qurbanliqi üchün bir tékini, inaqliq qurbanliqi üchün bir yashliq ikki qozini keltürünglar; ");
INSERT INTO uiglat_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","kahin bularni, yeni shu ikki qozini deslepki hosul nanlirigha qoshup pulanglatma hediye süpitide Perwerdigar aldida pulanglatsun. Bular bolsa Perwerdigargha atalghan muqeddes sanilip, kahin’gha tegsun. ");
INSERT INTO uiglat_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Shu küni siler «bügün bizlerge muqeddes yighilish bolidu» dep jakarlanglar; shu küni héchqandaq ish-emgek qilmanglar. Bu siler üchün qeyerdila tursanglar ebediy bir belgilime bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Étizingning bulung-puchqaqlirighiche tamam yighiwalmanglar, we hosulungdin qalghan wasangni tériwalmighin, belki bularni kembegheller bilen musapirlargha qoyghin. Men Özüm Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Sen Israillargha mundaq dégin: — Siler yettinchi ayning birinchi küni toluq aram élip, kanaylar chélinish bilen esletme yosunda héyt qilip, muqeddes sorunlarni tüzünglar.    ");
INSERT INTO uiglat_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","U künde héchqandaq ish-emgek qilmanglar; Perwerdigargha atap otta sunulidighan bir qurbanliq sununglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Yettinchi ayning oninchi küni bolsa kefarǝt küni bolidu; u kün siler üchün muqeddes yighilish küni bolidu; shu küni nepsinglarni tartip özünglarni töwen tutup, Perwerdigargha atap otta sunulidighan qurbanliqni sununglar;    ");
INSERT INTO uiglat_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","U künde héchqandaq ish-emgek qilmanglar; chünki u bir kefarǝt küni bolup, shu kün özünglar üchün Xudayinglar Perwerdigar aldida kefarǝt qilinishqa békitilgendur. ");
INSERT INTO uiglat_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Herkim shu küni nepsini tartmay özini töwen tutmisa öz xelqidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Kimdekim shu kündimu herqandaq bir ish qilsa, Men shu ademni öz xelqidin üzüp tashlaymen. ");
INSERT INTO uiglat_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Shu küni héchqandaq ish qilmanglar; bu dewrdin-dewrgiche siler üchün qeyerde tursanglar bir ebediy belgilime bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","U kün siler üchün toluq aram alidighan shabat küni bolidu; nepsinglarni tartip özünglarni töwen tutunglar. Shu ayning toqquzinchi küni gugumdin tartip etisi gugumghiche shabat künige riaye qilip aram élinglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Sen Israillargha mundaq dégin: — Yettinchi ayning on beshinchi künidin bashlap, yette kün’giche Perwerdigarning «kepiler héyti» bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Birinchi künde muqeddes yighilish bolidu; héchqandaq ish-emgek qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Yette kün’giche Perwerdigargha atap otta sunulidighan qurbanliq sununglar; sekkizinchi künde silerge muqeddes yighilish bolidu; Perwerdigargha atap otta sunulidighan qurbanliq sununglar. Bu özi tentenilik yighilish bolghach, u küni héchqandaq ish-emgek qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Siler «muqeddes sorunlar bolsun» dep jakarlaydighan, yeni Perwerdigar békitken héytlar mana shulardur. Shu sorunlarda siler herqaysi kün’ge békitilgini boyiche, Perwerdigargha atap otta sunulidighan hediye-qurbanliq, yeni köydürme qurbanliq, ashliq hediyesi, bashqa herxil qurbanliqlar we sharab hediyelerni sunisiler; ");
INSERT INTO uiglat_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","bulardin bashqa, Perwerdigarning shabat künlirini tutisiler we Perwerdigargha atap qalghan hediyeliringlarni bérip, qesem qurbanliqliringlarning hemmisini ada qilip, ixtiyariy qurbanliqliringlarning hemmisini sunisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Siler emdi zémindin hosul-mehsulatlirini yighip bolup, yettinchi ayning on beshinchi künidin bashlap yette kün Perwerdigarning héytini ötküzünglar. Birinchi küni toluq aram élish bolidu, sekkizinchi konidimu toluq aram élish bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Birinchi küni siler ésil derexlerdin shax-putaqlarni chatap, yeni xorma derexliri bilen qoyuq yopurmaqliq derexlerning shaxlirini késip, ériq boyidiki söget chiwiqlirini qirqip Xudayinglar Perwerdigar aldida yette künni shundaq shad-xuram ötküzisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Siler her yili bu yette künni Perwerdigargha atighan bir héyt süpitide ötküzünglar; dewrdin-dewrgiche bu siler üchün ebediy bir belgilime bolidu. Siler héytni yettinchi ayda ötküzünglar. ");
INSERT INTO uiglat_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Yette kün’giche kepilerde turunglar. Israilda tughulghanlarning hemmisi kepide tursun. ");
INSERT INTO uiglat_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Buning bilen Men Israillarni Misir zéminidin chiqarghinimda, ularni kepilerde turghuzghinimni ewladliringlar bilidu. Özüm Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Shundaq qilip Musa Perwerdigarning békitken shu héytlirini Israillargha bayan qildi. ");
INSERT INTO uiglat_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Israillargha chiragh hemishe yéniq turushi üchün zeytundin soqup chiqirilghan sap mayni sanga élip kélishke buyrughin. ");
INSERT INTO uiglat_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Harun jamaet chédirining ichide, höküm-guwahliq sanduqining udulidiki perdining sirtida her kéchisi etigen’giche Perwerdigarning aldida chiraghlarni shundaq perlep tursun. Bu dewrdin-dewrgiche siler üchün ebediy bir belgilime bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Harun hemishe Perwerdigarning aldida bu chiraghlarni pak chiraghdanning üstige tizip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Sen yene ésil bughday unidin on ikki toqachni etkin. Herbir toqach bir efahning ondin ikkisige barawer bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Andin sen Perwerdigarning aldidiki pak shirening üstige altidin ikki qatar qilip tizghin. ");
INSERT INTO uiglat_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Herbir qatarning üstige sap mestiki qoyghin; shuning bilen ular Perwerdigargha atap otta sunulidighan hediye, esletme nan bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Bularni u Israillargha wakaliten herbir shabat küni Perwerdigarning aldida tizsun; bu ebediy bir ehdidur. ");
INSERT INTO uiglat_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Nanlar Harun bilen uning oghullirigha tewe bolidu; ular ularni muqeddes jayda yésun; chünki bu nersiler Perwerdigargha atap otta sunulghan nersiler ichide «eng muqeddeslerning biri» dep sanilip, Harun’gha tewe bolidu; bu ebediy bir belgilimidur. ");
INSERT INTO uiglat_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Anisi Israiliy, atisi Misirliq bir oghul bar idi. U Israillarning arisigha bardi; u chédirgahta bir Israiliy bilen urushup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ular soqushqanda Israiliy ayalning oghli kupurluq qilip, Perwerdigarning namini bulghap qarghidi. Xelq uni Musaning aldigha élip bardi. U kishining anisining ismi Shélomit bolup, u Dan qebilisidin bolghan Dibrining qizi idi. ");
INSERT INTO uiglat_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Shuning bilen ular Perwerdigarning höküm buyruqi chiqquche u kishini solap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Andin Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Qarghighuchini chédirgahning tashqirigha élip chiqinglar. Uning éytqinini anglighanlarning hemmisi qollirini uning béshigha qoysun, andin pütkül jamaet bir bolup uni chalma-kések qilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Hemde sen Israillargha mundaq dégin: — Eger birkim öz Xudasini haqaretlep qarghisa öz gunahini tartidu. ");
INSERT INTO uiglat_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Perwerdigarning namigha kupurluq qilghan herqandaq kishi ölümge mehkum qilinsun; pütkül jamaet choqum bir bolup uni chalma-kések qilsun; meyli u musapir bolsun yaki yerlik bolsun, muqeddes namgha kupurluq qilsa öltürülsun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Eger birsi bashqa birsini urup öltürse, u ölümge mehkum qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Birsi bir charpayni öltürse, uning üchün haywanni tölep, jan’gha-jan tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Birkim öz qoshnisini méyip qilsa, u özgige qandaq qilghan bolsa, uning özigimu shundaq qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Birer ezasi sunduruwétilgen bolsa, uningmu sundurulsun; közige-köz, chishigha-chish nakar qilinsun; bashqa kishini qandaq zeximlendürgen bolsa umu hem shundaq qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kimdekim bir charpayni öltürse, charpay tölep bersun; ademni urup öltürgen kishi bolsa, ölüm jazasigha mehkum qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Silerde birla qanun bolsun. musapir yaki yerlik bolsun, barawer muamile qilinsun; chünki Men Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Musa Israillargha shularni dédi; shuning bilen ular shu qarghighuchini chédirgahning tashqirigha élip chiqip, chalma-kések qildi. Shundaq qilip, Israillar Perwerdigarning Musagha emr qilghinidek qildi. ");
INSERT INTO uiglat_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Perwerdigar Sinay téghida Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Sen Israillargha mundaq dégin: — Men silerge béridighan zémin’gha kirgininglarda u zéminning özimu Perwerdigargha atap bir shabat aramini alsun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sen alte yil étizingni térip, alte yil talliq béghingni chatap, ulardin hosullarni yighqin; ");
INSERT INTO uiglat_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","emma yettinchi yili zéminning özi üchün bir «shabatliq aram» bolsun; u Perwerdigargha atalghan bir «shabat» hésablinidu. Shu yili sen étizingni térimaysen we talliqingni chatimaysen. ");
INSERT INTO uiglat_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Özlükidin ünüp chiqqan hosulni ormaysen; we chatalmighan talliringning üzümlirini üzmeysen; chünki shu yil zémin aram alidighan yildur. ");
INSERT INTO uiglat_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Halbuki, zémin shabat yilida chiqarghan hosul hemminglargha ozuq bolidu, yeni özüng üchün, qul-dédiking üchün, medikaring üchün we séningkide turuwatqan musapir üchün, shuningdek mal-waranliring üchün ");
INSERT INTO uiglat_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","We zéminingdiki yawayi haywanlar üchünmu ozuq bolidu; zéminning hemme hosuli ozuq bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Shuningdek sen yette qétimliq shabat yilini, yeni yette hesse yette yilni sanighin; yette shabat yil künliri qiriq toqquz yil bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Shunchilik waqit ötüp, yettinchi ayda, ayning oninchi küni, kefarǝt künide burgha chélip sadasini yuqiri chiqirisiler; kefarǝt künining özide siler pütkül zémininglarda burghining sadasini anglitisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Shu ellikinchi yilini siler muqeddes dep bilip, pütkül zéminda uningda barliq turuwatqanlarning hemmisige azadliqni jakarlishinglar kérek. Shu yil silerge «azadliq yili» bolidu, herbiringlar öz yer-mülükliringlargha qaytisiler, herbiringlar öz aile-jemetinglargha qaytip barisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Bu ellikinchi yili silerge bir azadliq yili bolsun; u yili héch néme térimaysiler, özlükidin ünüp chiqqan hosulnimu ormaysiler we chatalmighan talliringlarning üzümlirinimu yighmaysiler. ");
INSERT INTO uiglat_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Chünki bu azadliq yili bolup, silerge muqeddes hésablansun; uning hosulini bolsa, étiz-dalilardin tépip hemminglar yeysiler. ");
INSERT INTO uiglat_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Azadliq yili aranglardiki herbir adem öz yer-mülkige qaytsun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Siler qoshnanglargha birnéme sétip bersenglar, yaki qoshnanglardin birnéme sétiwalsanglar, bir-biringlarni bozek qilmanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Qoshnangdin yerni sétiwalsang, undaqta «azadliq yili»din kéyin ötken yillarning sanini hésablap uningdin sétiwélishing kérek; umu qalghan yillarning sanigha qarap, yerning kéyinki hosullirigha asasen sanga sétip bersun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","«Azadliq yili»ghiche bolghan yillar köprek bolsa, bahasini shuninggha muwapiq yuqiri kötürisen; qalghan yillar azraq bolsa, bahasini shuninggha muwapiq kémeytsun. Chünki qalghan yillarning hosulliri qanche bolsa, u shu boyiche sanga sétip béridu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Siler bir-biringlarni bozek qilmanglar, belki Xudayinglardin qorqunglar; chünki Men bolsam Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Siler Méning belgilimilirimni tutup, hökümlirimde turup, shulargha emel qilinglar; siler shundaq qilsanglar, zémininglarda tinch-aman turisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Shuning bilen zémin silerge öz méwisini béridu, siler toyghudek yep, uningda tinch-aman turisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Eger siler: — Mana, bizge térip hosulni yighishqa ijazet bérilmise, yettinchi yili néme yeymiz, dep sorisanglar, ");
INSERT INTO uiglat_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","silerge melum bolsunki, altinchi yilida üch yilning hosulini bersun dep, Men üstünglargha berikitimni «chüsh» dep buyruymen. ");
INSERT INTO uiglat_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","We shundaq boliduki, siler sekkizinchi yili tériysiler, emma toqquzinchi yilighiche éship qalghan kona hosuldin téxiche yeysiler; shu toqquzinchi yilighiche siler kona ashliqtin yeysiler. ");
INSERT INTO uiglat_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Yer-zémin sétilsa, menggülük sétilmisun, chünki zéminning özi Méningkidur, siler bolsanglar Méning yénimdiki musapir we méhman, xalas. ");
INSERT INTO uiglat_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Siler ige bolidighan pütkül zéminda yer-zéminning igilirige uni «qayturuwélish hoquqi»ni yaritip bérishinglar kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Eger qérindashliringlardin biri kembeghelliship, öz miras yérini sétiwetken bolsa, uning yéqin tughqini, yeni «hemjemet shapaetchi»si kélip öz qérindishi satqan yerni qayturup sétiwalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Eger uning héch shapaetchi tughqini bolmisa, lékin u yanduruwélishqa kéreklik pulni tapalisa, ");
INSERT INTO uiglat_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Undaqta satqinigha qanche yil bolghanliqini hésablap, azadliq yilighiche qalghan yillar üchün sétiwalghan kishige muwapiq pul bérip, öz yérige qaytsun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Lékin eger u yanduruwélishqa kéreklik pulni tapalmisa, özi sétip bergen yer azadliq yilighiche alghuchining qolida tursun; azadliq yili kelgende yer yer sétiwalghuchining qolidin chiqsun, öz igisi öz yer-mülkige qaytsun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Eger birsi sépilliq sheherning ichidiki bir turalghu öyni satqan bolsa, sétip bir yil ichide uni yanduruwélish hoquqi bardur. Toluq bir yil tügep bolghuche, yanduruwélish hoquqi bardur. ");
INSERT INTO uiglat_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Lékin pütün yil ichide yanduruwélinmisa, sépilliq sheherning ichidiki bu öy nesildin-nesilge alghan kishining qolida bolup, azadliq yili kelsimu yandurulmas. ");
INSERT INTO uiglat_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Lékin sépilsiz kentlerning öyliri bolsa zéminning étizliridek hésablinidu; ularni yandurup sétiwalghili bolidu; azadliq yili kelgende esli igisining qoligha yandurulidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Lékin Lawiy sheherliride bolsa, Lawiylar öz mirasi bolghan sheherlerdiki öylirini xalisa herqachan qayturuwélish hoquqi bardur. ");
INSERT INTO uiglat_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Lawiylardin biri öylirini, yeni öz mirasi bolghan sheherdiki bir öyni qayturuwélish hoquqi bar bolsimu, lékin qayturup almighan bolsa, undaq ehwalda u azadliq yili kelgende yandurulidu; chünki Lawiy sheherlirining öyliri bolsa Lawiylarning Israillarning arisidiki mirasi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Shundaq hem bularning sheherlirining chörisidiki étiz-yerliri bolsa, ularning ebediy mirasi bolghachqa, sétilsa bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Sanga qoshna bolghan, qérindashliringlardin biri kembeghelliship, öz jénini baqalmay qalsa, sen uni musapir yaki yaqa yurtluq méhmandek yéningda turghuzup, uningdin xewer alghin. ");
INSERT INTO uiglat_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Sen uningdin ösüm we yaki payda almighin; sen Xudayingdin qorqup, qérindishingni qéshingda turushqa qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Pulungni uninggha ösümge berme, ashliqingnimu payda élish meqsitide uninggha ötne bermigin. ");
INSERT INTO uiglat_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Xudayinglar bolushqa, Qanaan zéminini silerge bérishke silerni Misir zéminidin chiqirip kelgen Xudayinglar Perwerdigar Özümdurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Eger sanga qoshna bolghan qérindishing kembeghelliship, özini sanga satsa, uni quldek qulluq xizmitige salmighin; ");
INSERT INTO uiglat_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","belki u qéshingda medikar yaki musapirdek tursun; azadliq yilighiche séning xizmitingde bolsun; ");
INSERT INTO uiglat_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","andin azad bolup özi bilen baliliri qéshingdin chiqip, öz jemetige yénip bérip, ata-bowilirining yer-mülkige qaytsun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Chünki ular Men Özüm Misir zéminidin chiqirip élip kelgen qul-bendilirim bolghachqa, ularni quldek sétishqa yol qoymanglar. ");
INSERT INTO uiglat_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Sen ulargha qattiq qolluq bilen xojiliq qilmaysen, belki Xudayingdin qorqqin. ");
INSERT INTO uiglat_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Lékin özüngge qul yaki dédek almaqchi bolsang, ularni etraptiki yat ellerdin shundaq qul ya dédek sétiwalsang bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Bulardin bashqa, aranglarda olturaqlashqan musapirlarning perzentlirini we shularning jemetidin, yeni siler bilen bille turuwatqan, zémininglarda tughulghanlardin qullar sétiwalsanglar bolidu; shuning bilen ular silerning mülkünglar bolup qalidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Siler mushularni özünglardin kéyinki baliliringlargha miras qilip, ulargha mülük bolushqa qaldursanglar bolidu; mushularni ebedgiche qul qilsanglar bolidu; lékin öz qérindashliringlar bolghan Israillar arisida bolsa, bir-biringlargha qattiq qolluq bilen xojiliq qilmasliqinglar kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Eger aranglarda olturushluq bir musapir yaki yaqa yurtluq béyighan we uninggha qoshna qérindishing kembeghelliship, özini shu qoshna musapirgha we yaki shu musapirning melum bir ewladigha satsa, ");
INSERT INTO uiglat_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","u sétilghandin kéyin uningda pul tölep hörlükke chiqish hoquqi qalidu; uning aka-ukilirining herqaysisi uni hörlükke sétiwalsa bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Shuningdek uning taghisi yaki taghisining oghli we yaki jemetidin bolghan herqaysi yéqin tughqini uni hörlükke sétiwalsa bolidu; yaki özining qurbi yetse, pul bérip öz-özini hörlükke sétiwalsa bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Uni sétiwalidighan kishi uning xojisi bilen gepliship sétilghan yildin tartip azadliq yilighiche qanchilik bolghanliqini hésablap, sétiwélish bahasini yillarning sanigha qarap hésablisun; hörlük puli hésablashta qulning xojisigha ishleshke kérek bolghan qalghan künlirining heqqi «medikarning ishligen künliri»dek hésablansun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Azadliq yiligha yene xéli yillar bolsa, shuni hésablap, sétilghan pulning nisbiti boyiche hörlük pulini hésablap bersun; ");
INSERT INTO uiglat_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","eger azadliq yiligha az yillar qalghan bolsa, uni hésab qilip, qalghan qulluq yillirigha muwapiq pulni yandurup bersun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Bolmisa, qul shu xojisining yénida yilliq medikardek turushi kérek; uning xojisi séning köz aldingda uninggha qattiq qolluq bilen xojiliq qilmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Eger qul yuqiriqi yollar bilen hörlükke chiqalmisa, azadliq yili kelgende qoyup bérilsun — u baliliri bilen qoshulup azad bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Chünki Israillarning özi Manga qul-bendilerdur; ular Men Özüm Misir zéminidin chiqirip kelgen qul-bendilirimdur. Xudayinglar Perwerdigar Özümdurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Siler özünglar üchün héchqandaq but yasimanglar yaki özünglargha héch oyma mebud yaki heykel-tüwrükni turghuzmanglar yaki ulargha bash urushqa oyulghan neqishlik tashlarni zémininglarda hergiz tiklimenglar; chünki Özüm Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Méning shabat künlirimni tutup, muqeddes jayimgha ixlasmen bolunglar. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Eger siler méning belgilimilirimde méngip, emrlirimni tutup ulargha emel qilsanglar, ");
INSERT INTO uiglat_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Men yéringlarning öz hosulini bérip turushigha, daladiki derexlerning méwisini chiqirishigha waqtida yamghurliringlarni yaghdurup turimen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Shuning bilen xaman tépish waqti üzüm yighish pesligiche bolidu, üzüm yighish waqti térilghu waqtighiche bolidu; siler néninglarni toyun’ghuche yep, öz zémininglarda tinch-aman turisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Men zémin’gha aram-tinchliq ata qilimen, shuning bilen héchkim silerni qorqutalmaydu, aramxuda yétip uxlaysiler; wehshiy haywanlarni zémindin yoqitimen, qilichmu zémininglardin ötmeydu; ");
INSERT INTO uiglat_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","siler düshmenliringlarni qoghlaysiler, ular aldinglarda qilichlinip yiqilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Silerdin besh kishi yüz kishini qoghlaydu, yüz kishi on mingni qachuridu; düshmenliringlar bolsa aldinglarda qilichlinip yiqilidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Men silerge yüzümni qaritip, silerni perzent körgüzüp köpeytimen, siler bilen baghlighan ehdemni mezmut turghuzimen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Siler téxiche uzun saqlan’ghan kona ashliqni yewatqininglarda, yéngi ashliq chiqidu; yéngisi wejidin konisini chiqiriwétisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Men Öz makanimni aranglarda turghuzimen we qelbim silerdin nepretlenmeydu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Men aranglarda méngip silerning Xudayinglar bolimen we siler Méning xelqim bolisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Men silerni Misirda ularning qulliri bolushtin hör qilishqa shu zéminidin chiqarghan Xudayinglar Perwerdigardurmen; Men boyunturuqunglarning asaretlirini sundurup, qeddinglarni tik qilip mangghuzdum. ");
INSERT INTO uiglat_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Halbuki, eger siler Manga qulaq salmay, bu emrlerning hemmisige emel qilmay, ");
INSERT INTO uiglat_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","belgilimilirimni tashlap, qelbinglardin hökümlirimni yaman körüp, barliq emrlirimni tutmay, ehdemni buzsanglar, ");
INSERT INTO uiglat_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Menmu béshinglargha shu ishlarni chüshürimenki, — Men silerge wehime sélip, közünglarni kor qilidighan, jéninglarni zeipleshtüridighan sil-waba késili, kézik késilini béshinglargha chüshürimen. Siler uruqunglarni bikar chéchip-tériysiler, chünki düshmenliringlar uni yep kétidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Men yüzümni silerge qarshi qilimen, shuning bilen siler düshmenliringlardin urulup qachidighan bolisiler; silerni öch körgüchiler üstünglardin hökümranliq qilidu; héchkim silerni qoghlimisimu, qachisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Bulardin héch ibret almay, belki Manga yene qulaq salmisanglar, Men gunahliringlar tüpeylidin silerge bolghan jazani yette hesse éghirlitimen, ");
INSERT INTO uiglat_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","küch-heywenglardin bolghan hakawurluqinglarni sundurimen; asmininglarni tömürdek qilip, yéringlarni mistek qiliwétimen; ");
INSERT INTO uiglat_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ejir-japayinglar bikargha kétidu, yéringlar hosul bermeydu, daladiki derexlerge méwe chüshmeydu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Eger yenila Men bilen qarshi mangsanglar, shundaqla Manga qulaq salmisanglar, Men gunahliringlargha layiq béshinglargha chüshidighan waba-külpetlerni yene yette hesse éghirlitimen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Aranglargha silerni baliliringlardin juda qilidighan, charpayliringlarni yoqitidighan, silerni azlitidighan yawayi haywanlarni ewetimen; yol-kochiliringlar ademzatsiz chöldek bolup qalidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Siler bu ishlar arqiliq ibret-terbiye almay, belki yenila Manga qarshi mangsanglar, ");
INSERT INTO uiglat_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Menmu silerge qarshi méngip, gunahinglar tüpeylidin bolghan jazani yene yette hesse éghirlitip, Men Özüm silerni urimen; ");
INSERT INTO uiglat_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","üstünglargha ehdemni buzghanliqning intiqamini alidighan qilich chüshürimen; shuning bilen siler sheherlerge yighiliwalisiler, Men aranglargha waba chüshürimen; shuning bilen siler düshmenlerning qoligha chüshisiler. ");
INSERT INTO uiglat_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Silerge yölenchük bolghan ashliqni qurutuwétimen; on ayal bir bolup bir tonurda nan yéqip, nanlarni silerge tarazida tartip béridu, emma buni yégininglar bilen toymaysiler. ");
INSERT INTO uiglat_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Eger bulardin héch ibret almay, manga qulaq salmisanglar, belki manga qarshi mangsanglar, ");
INSERT INTO uiglat_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Menmu qehr bilen silerge qarshi mangimen; Men, yeni Men Özüm gunahliringlar tüpeylidin jaza-terbiyini yene yette hesse éghirlitip chüshürimen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Shuning bilen siler oghulliringlarning göshi we qizliringlarning göshini yeysiler; ");
INSERT INTO uiglat_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","shundaqla Men qurbanliq «yuqiri jay»liringlani weyran qilip, «kün tüwrük»liringlarni sundurup, ölükliringlarni sunuq butliringlarning üstige tashliwétimen; Méning qelbim silerdin nepretlinidu.    ");
INSERT INTO uiglat_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Men sheherliringlarni weyran qilip, muqeddes jayliringlarni xarab qilip, qurbanliqinglarning xushbuylirini yene purimaymen; ");
INSERT INTO uiglat_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","zéminni halaketke élip barimen; uningda olturaqlashqan düshmenliringlar bu ehwalgha heyranuhes qalidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Silerni ellerning arisigha taritip, keyninglardin qilichni sughurup qoghlaymen; shuning bilen zémininglar weyran bolup sheherliringlar xarab qilinidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","U waqitta, siler düshmenliringlarning zéminida turuwatqininglarda, zémin weyrane bolghan barliq künlerde, zémin öz shabat künliridin söyünidu; u zamanda zémin derweqe aram élip öz shabatliridin söyünidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Özi weyrane bolup turghan barliq künliride u aram alidu, yeni siler uningda turuwatqan waqittiki shabat künliringlarda héch almighan aramni emdi alidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Aranglardin qutulup qalghanlar bolsa, ular düshmenlerning zéminlirida turghinida köngüllirige yürekzadilik salimen, shuning bilen ular chüshken bir yopurmaqning shepisini anglisa qilichtin qachqandek qachidu; héchkim qoghlimisimu yiqilip chüshidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Gerche héchkim ularni qoghlimisimu, derweqe qilichtin yiqitilghandek ular bir-birining üstige putliship yiqilidu; silerde düshmenliringlargha qarshi turghudek küch qalmaydu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ellerning arisida halak bolisiler, düshmenliringlarning zémini silerni yep kétidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Aranglardin qutulup qalghanliri bolsa öz rezilliki tüpeylidin düshmenliringlarning zéminida zeiplishidu; we ata-bowilirining rezillikidimu yürüp, shular zeipleshkendek ularmu zeiplishidu. ");
INSERT INTO uiglat_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Halbuki, ular özi qilghan rezilliki bilen ata-bowilirining sadir qilghan rezillikini, Manga yüz örüp asiyliq qilghinini, shundaqla ularning Manga qarshi turup mangghinini boynigha alidu, ");
INSERT INTO uiglat_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","shuningdek Méning ulargha qarshi mangghinimgha, shuningdek ularni düshmenlirining qoligha tapshurghinimgha iqrar bolidu. Shunga eger u waqitta ularning xetnisiz köngli töwen qilinip, öz qebihlikining jazasini qobul qilsa, ");
INSERT INTO uiglat_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","undaqta Men Yaqup bilen baghlighan ehdemni yad qilip, Ishaq bilen baghlighan ehdemnimu we Ibrahim bilen baghlighan ehdemnimu ésimge keltürimen, zéminnimu yad qilimen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Chünki zémin ulardin tashlinip, ularsiz bolup xarabe turghan waqitta, shabat künliridin söyünidu; ular bolsa öz qebihlikining jazasini qobul qilidu; sewebi del shuki, ular Méning hökümlirimni tashlidi, belgilimilirimni qelbidin yaman körgenidi. ");
INSERT INTO uiglat_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Halbuki, shundaq bolsimu, ular öz düshmenlirining zéminida turghinida Men ularni tashlimaymen yaki ulargha öchlük qilmaymen, shuningdek ular bilen baghlighan ehdemni buzmaymen, ularni yoqatmaymen; chünki Men Özüm ularning Xudasi Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Men belki ularni dep, ularning Xudasi bolushqa ellerning közi aldida Misir zéminidin chiqirip kelgen ata-bowiliri bilen baghlashqan ehdemni ésimde tutimen. Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Perwerdigar Musani wasite qilip, Sinay téghida özi bilen Israillarning otturisida békitken hökümler, belgilimiler we qanunlar mana shular idi. ");
INSERT INTO uiglat_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Sen Israillargha mundaq dégin: — Eger birsi pewqul’adde bir qesem qilip melum kishining jénini Perwerdigargha atighan bolsa, undaqta shu kishige sen békitken jénining qimmitining nerxi töwendikidek bolidu; ");
INSERT INTO uiglat_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Yéshi yigirme bilen atmishning ariliqida bolghan er kishi bolsa, sen toxtitidighan qimmiti muqeddes jaydiki shekelning ölchem birliki boyiche bolsun; uning qimmiti ellik shekel kümüshke toxtitilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ayal kishi bolsa, aranglarda toxtitilghan qimmiti ottuz shekel bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Eger yéshi besh bilen yigirmining ariliqida bolsa, erkek üchün toxtitilidighan qimmiti yigirme shekel bolup, ayal kishi üchün on shekel bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Eger yéshi bir ay bilen besh yashning ariliqida bolsa, toxtitilidighan qimmiti oghul bala üchün besh shekel, qiz bala üchün üch shekel kümüsh bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Eger atmish ya uningdin chongraq yashtiki kishi bolsa, toxtitilidighan qimmiti er kishi üchün on besh shekel, xotun kishi üchün on shekel bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Eger birsi toxtitilghan qimmitini töleshke qurbi yetmise, u özini kahinning aldida teq qilsun; kahin uning qimmitini békitsun. Kahin qesem qilghuchining ehwaligha qarap uning qimmitini toxtitip bersun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Eger birsi qesem qilip Perwerdigargha qurbanliq bolushqa layiq bolidighan bir haywanni uninggha atighan bolsa, undaqta shundaq haywanlar Perwerdigargha atap mutleq muqeddes sanalsun; ");
INSERT INTO uiglat_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","haywan nachar bolsa uning ornigha yaxshini yaki yaxshining ornigha nachirini tégishishke yaki ornigha bashqisini almashturushqa hergiz bolmaydu. Mubada atighuchi u haywanning ornigha yene bir haywanni yenggüshlimekchi bolsa, Awwalqisi bilen ornigha ekelginining her ikkisi muqeddes sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Eger haywan Perwerdigargha atalghan qurbanliqqa layiq bolmaydighan bir «napak» haywan bolsa, undaqta u haywanni kahinning aldigha élip kelsun; ");
INSERT INTO uiglat_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","andin kahin özi uning yaxshi-yamanliqigha qarap qimmitini toxtatsun; kahin qimmitini qanche toxtatqan bolsa shundaq bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Eger igisi pul tölep haywanni qayturuwulmaqchi bolsa, toxtitilghan qimmitige yene uning beshtin birini qoshup bersun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Eger birsi Perwerdigargha muqeddes bolsun dep öyini uninggha atap muqeddes qilsa, kahin uning yaxshi-yamanliqigha qarap qimmitini toxtatsun; kahin uning qimmitini qanche toxtatqan bolsa, shu qimmiti inawetlik bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kéyin eger öyni atighuchi kishi uni qayturuwalmaqchi bolsa, u toxtitilghan qimmitige uning beshtin birini qoshup bersun; andin öy yene uning bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Eger birsi öz mal-mülki bolghan étizliqning bir qismini Perwerdigargha atap muqeddes qilsa, qimmiti uninggha qanchilik uruq térilidighanliqigha qarap toxtitilsun; bir xomir arpa uruqi kétidighan yer bolsa, qimmiti ellik shekel kömüshke toxtitilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Eger birsi «azadliq yili»din tartip öz étizliqini muqeddes qilsa, sen qanche toxtatsang shu bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Lékin eger birsi «azadliq yili»din kéyin öz étizliqini muqeddes qilghan bolsa, kahin kélidighan azadliq yilighiche qanchilik yillar qalghanliqini hésablap qimmitini toxtatsun. Ötüp ketken yillargha qarap toluq bahadin muwapiq pul kémeytilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Eger birsi öz étizliqini muqeddes qilghandin kéyin pul tölep uni qayturuwalmaqchi bolsa, u sen toxtatqan qimmitige yene uning beshtin birini qoshup bersun; shuning bilen étizliq uning öz qoligha qaytidu. ");
INSERT INTO uiglat_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Eger u pul bérip étizliqni qayturuwalmighan bolsa yaki bashqa birsige sétip bergen bolsa, kéyin shu étizliqni qayturuwélishqa bolmaydu, ");
INSERT INTO uiglat_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Belki azadliq yili kelgende étizliq «igisige qayturulidighanda» u mutleq béghishlan’ghan yerge oxshash, Perwerdigargha atap muqeddes qilinip, miras hoquqi kahin’gha ötidu. ");
INSERT INTO uiglat_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Eger birsi sétiwalghan emma öz mirasi bolmighan bir parche yer-étizni Perwerdigargha atap muqeddes qilghan bolsa, ");
INSERT INTO uiglat_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kahin azadliq yilighiche qalghan yilni hésablap, qimmitini toxtatsun. Andin u küni shu kishi toxtitilghan qimmitini Perwerdigargha muqeddes qilghan nerse süpitide keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Lékin azadliq yili kelgende, étizliq kimdin élin’ghan bolsa, shu kishige, yeni eslidiki igisige qayturup bérilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Sen toxtitidighan barliq qimmetler bolsa hemishe muqeddes jaydiki shekelning ölchem birliki boyiche hésablansun; bir shekel yigirme gerahqa barawer bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Lékin charpayning tunji balisi tunji bala bolghanliqi sewebidin eslidinla Perwerdigargha atilidighan bolghachqa, kala bolsun, qoy-öchke bolsun héchkim uni «Xudagha atap» muqeddes qilmisun; chünki u eslide Perwerdigarning idi. ");
INSERT INTO uiglat_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Eger u napak bir haywandin tughulghan bolsa, igisi sen toxtatqan qimmetke yene uning beshtin birini qoshup bérip, andin özige qayturuwalsun; lékin eger igisi uni özige qayturuwalmaymen dése, bu haywan sen toxtatqan qimmetke sétilsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Eger birsi Perwerdigargha öz mélidin, adem bolsun, haywan bolsun yaki miras yéri bolsun, Perwerdigargha mutleq atighan bolsa, undaq nerse hergiz sétilmisun yaki bedel tölesh bilenmu qayturulmisun. Perwerdigargha mutleq atalghan hernerse bolsa «eng muqeddeslerning biri» hésablinip, uninggha xas bolidu. ");
INSERT INTO uiglat_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Eger bir adem Xudagha mutleq xas atalghan bolsa, undaqta uning üchün bedel bérilip, qayturuwélinishqa hergiz bolmaydu; u choqum öltürülüshi kérek. ");
INSERT INTO uiglat_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Yer-zémindin chiqqan hemme hosulning ondin biri bolghan öshre bolsa, yerning danliq ziraetliri bolsun yaki derexlerning méwisi bolsun, Perwerdigarningki bolidu; u Perwerdigargha muqeddes qilin’ghandur. ");
INSERT INTO uiglat_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Birsi öz öshriliridin melum birnersini bedel bérip qayturuwalmaqchi bolsa, u shuninggha yene uning qimmitining beshtin birini qoshup bérip, qayturuwalsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kala yaki qoy-öchke padisidin élinidighan öshre bolsa padichining tayiqi astidin ötküzülgen haywanlardin her oninchisi bolsun; Perwerdigargha atilip muqeddes qilin’ghini shu bolsun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Héchkim uning yaxshi-yamanliqigha qarimisun we yaki uni almashturmisun; eger uni almashturimen dése, Awwalqisi bilen ornigha almashturulghan her ikkisi muqeddes sanalsun; u hergiz bedel tölüp qayturuwélinmisun. ");
INSERT INTO uiglat_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Perwerdigar Sinay téghida Musagha tapilghan, Israillargha tapshurush kérek bolghan emrler mana shular idi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","We Israillar Misirdin chiqqandin kéyin ikkinchi yili ikkinchi ayning birinchi küni Perwerdigar Sinay chölide, jamaet chédirida turup Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Siler pütkül Israil jamaitini qebilisi, ata jemeti boyiche sanini élip chiqinglar; ademlerning ismi asas qilinip, barliq erkekler tizimlansun. ");
INSERT INTO uiglat_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Israillar ichide omumen yigirme yashtin ashqan, jengge chiqalaydighanlarni Harun bilen ikkinglar ularning qoshun-qismiliri boyiche sanaqtin ötküzünglar. ");
INSERT INTO uiglat_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Herbir qebilidin silerge yardemlishidighan birdin kishi bolsun; ularning herbiri ularning ata jemetining béshi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Töwendikiler silerge yardemlishidighanlarning isimliki: — Ruben qebilisidin Shidörning oghli Elizur; ");
INSERT INTO uiglat_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Shiméon qebilisidin Zuri-shaddayning oghli Shélumiyel; ");
INSERT INTO uiglat_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yehuda qebilisidin Amminadabning oghli Nahshon; ");
INSERT INTO uiglat_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Issakar qebilisidin Zuarning oghli Netanel; ");
INSERT INTO uiglat_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zebulun qebilisidin Hélonning oghli Éliab; ");
INSERT INTO uiglat_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yüsüp ewladliri ichide Efraim qebilisidin Ammihudning oghli Elishama; Manasseh qebilisidin Pidahzurning oghli Gamaliyel; ");
INSERT INTO uiglat_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Binyamin qebilisidin Gidéonining oghli Abidan; ");
INSERT INTO uiglat_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan qebilisidin Ammishaddayning oghli Ahiézer; ");
INSERT INTO uiglat_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Ashir qebilisidin Okranning oghli Pagiyel; ");
INSERT INTO uiglat_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad qebilisidin Déuelning oghli Eliasaf; ");
INSERT INTO uiglat_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naftali qebilisidin Énanning oghli Ahira». ");
INSERT INTO uiglat_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Bular jamaet ichidin chaqirilghanlar, yeni ata jemet-qebililirining bashliqliri, minglighan Israillarning bash serdarliri idi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Shuning bilen Musa bilen Harun ismi atalghan bu kishilerni bashlap, ");
INSERT INTO uiglat_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ikkinchi ayning birinchi küni pütkül jamaetni yighdi; ular xelqning herbirining qebile-nesebi, ata jemeti boyiche ismini asas qilip, yigirme yashtin yuqirilarning hemmisini bir-birlep tizimlidi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Perwerdigar Musagha qandaq buyrughan bolsa, Musa Sinay chölide ularni shundaq sanaqtin ötküzdi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Israilning tunji oghli Rubenning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighan erkeklerning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ruben qebilisidin sanaqtin ötküzülgenler jemiy qiriq alte ming besh yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Shiméonning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighan erkeklerning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Shiméon qebilisidin sanaqtin ötküzülgenler jemiy ellik toqquz ming üch yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gadning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gad qebilisidin sanaqtin ötküzülgenler jemiy qiriq besh ming alte yüz ellik kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Yehudaning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Yehuda qebilisidin sanaqtin ötküzülgenler jemiy yetmish töt ming alte yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Issakarning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Issakar qebilisidin sanaqtin ötküzülgenler jemiy ellik töt ming töt yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zebulunning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zebulun qebilisidin sanaqtin ötküzülgenler jemiy ellik yette ming töt yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Yüsüpning ewladliri: — uning oghli Efraimning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Efraim qebilisidin sanaqtin ötküzülgenler jemiy qiriq ming besh yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Yüsüpning ikkinchi oghli Manassehning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manasseh qebilisidin sanaqtin ötküzülgenler jemiy ottuz ikki ming ikki yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Binyaminning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Binyamin qebilisidin sanaqtin ötküzülgenler jemiy ottuz besh ming töt yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Danning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan qebilisidin sanaqtin ötküzülgenler jemiy atmish ikki ming yette yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ashirning ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ashir qebilisidin sanaqtin ötküzülgenler jemiy qiriq bir ming besh yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naftalining ewladliri ata jemeti, ailisi boyiche, ismi asas qilinip, yigirme yashtin ashqan, jengge chiqalaydighanlarning hemmisi bir-birlep tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Naftali qebilisidin sanaqtin ötküzülgenler jemiy ellik üch ming töt yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Yuqiriqilar bolsa sanaqtin ötküzülgenler bolup, Musa bilen Harun hem Israillarning on ikki emiri (herbiri öz ata jemetige wekil boldi) ularni sanaqtin ötkezgen. ");
INSERT INTO uiglat_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Shundaq qilip, Israillarning hemmisi, yeni Israilda yigirme yashtin ashqanlardin, jengge chiqalaydighanlarning hemmisi ata jemetliri boyiche tizimlandi; ");
INSERT INTO uiglat_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Sanaqtin ötküzülgenler jemiy alte yüz üch ming besh yüz ellik kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Biraq Lawiylar ata jemet-qebilisi boyiche sanaqning ichige kirgüzülmidi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Chünki Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Sen peqet Lawiy qebilisinila shu hésabqa kirgüzmigin, ularning omumiy saninimu Israillarning qatarigha kirgüzmigin. ");
INSERT INTO uiglat_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Lékin sen Lawiylarni Xudaning höküm-guwahliqi saqlaqliq chédir we uning ichidiki barliq qacha-qucha eswaplarni hem uninggha dair barliq nersilerni bashqurushqa teyinligin; ular ibadet chédirini we uning ichidiki barliq qacha-qucha eswaplarni kötüridu; ibadet chédirining xizmitini qilghuchilar shular bolsun, ular chédirning töt etrapida öz chédirlirini tiksun. ");
INSERT INTO uiglat_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Chédirni köchüridighan chaghda uni Lawiylar söksun; chédirni tikidighan chaghda uni Lawiylar tiksun; Lawiylargha yat bolghan herqandaq adem uninggha yéqinlashsa ölümge mehkum qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israillar bargah qurghanda her adem öz qismida, özige xas tugh astigha chédir tiksun. ");
INSERT INTO uiglat_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Biraq Xudaning ghezipi Israil jamaitining üstige chüshmesliki üchün, Lawiylar Xudaning höküm-guwahliqi saqlaqliq chédirning töt etrapigha bargah qursun; Lawiylar Xudaning höküm-guwahliqi saqlaqliq chédirni muhapizet qilishqa mes’ul bolidu» — dégenidi. ");
INSERT INTO uiglat_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israillar ene shundaq qildi; Perwerdigar Musagha qandaq buyrughan bolsa, ular shundaq qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Perwerdigar Musa bilen Harun’gha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Israillar herbiri özlirining tughi astigha, özlirining ata jemetining bayriqi astida chédir tiksun; jamaet chédirining töt etrapidin sel yiraqraq bargah qursun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Kün chiqish terepke, sherq terepke qaritip öz tughi astida qoshun-qismi boyiche bargah quridighini Yehuda bolsun; Yehudalarning emiri Amminadabning oghli Nahshon bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy yetmish töt ming alte yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Uning yénida bargah quridighini Issakar qebilisi bolsun; Issakarlarning emiri Zuarning oghli Netanel bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy ellik töt ming töt yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ularning yénida yene Zebulun qebilisi bolsun; Zebulunlarning emiri Hélonning oghli Éliab bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy ellik yette ming töt yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Omumen Yehuda bargahigha qaraydighanlarning hemmisi, yeni qoshun-qisimliri boyiche sanaqtin ötküzülgenler jemiy bir yüz seksen alte ming töt yüz kishi; ular aldi bilen yolgha chiqsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","— Jenub terepte, tugh tiklep, qoshun tertipi bilen bargah quridighini Ruben qebilisi bolsun; Rubenlarning emiri Shidörning oghli Elizur bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy qiriq alte ming besh yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Uning yénida bargah quridighini Shiméon qebilisi bolsun; Shiméonlarning emiri Zuri-shaddayning oghli Shélumiyel bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy ellik toqquz ming üch yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ularning yénida Gad qebilisi bolsun; Gadlarning emiri Déuelning oghli Eliasaf bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy qiriq besh ming alte yüz ellik kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ruben bargahigha qaraydighanlarning hemmisi, yeni qoshuni boyiche sanaqtin ötküzülgenler jemiy bir yüz ellik bir ming töt yüz ellik kishi; ular ikkinchi sep bolup yolgha chiqsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Andin jamaet chédiri bilen Lawiylarning bargahi bashqa bargahlarning otturisida mangsun; ular qandaq bargah qurghan bolsa, shundaq yolgha chiqsun; her qaysisi öz ornida öz tughi astida bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","— Kün pétish terepte, tugh tiklep, qoshun tertipi bilen bargah quridighini Efraim qebilisi bolsun; Efraimlarning emiri Ammihudning oghli Elishama bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy qiriq ming besh yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Uning yénida bargah quridighini Manasseh qebilisi bolsun; Manassehlerning emiri Pidahzurning oghli Gamaliyel bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy ottuz ikki ming ikki yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ularning yénida Binyamin qebilisi bolsun; Binyaminlarning emiri Gidéonining oghli Abidan bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy ottuz besh ming töt yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Omumen Efraim bargahigha qaraydighanlarning hemmisi, yeni qoshun qisimliri boyiche sanaqtin ötküzülgenler jemiy bir yüz sekkiz ming bir yüz kishi; ular üchinchi sep bolup yolgha chiqsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","— Shimal terepte, tugh tiklep, qoshun tertipi bilen bargah quridighini Dan qebilisi bolsun. Danlarning emiri Ammishaddayning oghli Ahiézer bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy atmish ikki ming yette yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Uning yénida bargah quridighini Ashir qebilisi bolsun; Ashirlarning emiri Okranning oghli Pagiyel bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy qiriq bir ming besh yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ularning yénida Naftali qebilisi bolsun; Naftalilarning emiri Énanning oghli Ahira bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Uning qoshuni, yeni sanaqtin ötküzülgenler jemiy ellik üch ming töt yüz kishi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan bargahigha qaraydighanlarning hemmisi, yeni qoshun-qisimliri boyiche sanaqtin ötküzülgenler jemiy bir yüz ellik yette ming alte yüz kishi; ular öz tughliri astida hemmining keynide yolgha chiqsun. ");
INSERT INTO uiglat_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Yuqiridikiler öz ata jemeti boyiche sanaqtin ötküzülgen Israillardur; qoshun-qisimliri boyiche bargahlarda sanaqtin ötküzülgenler jemiy alte yüz üch ming besh yüz ellik kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Biraq Lawiylarla, Perwerdigarning Musagha qilghan emri boyiche, Israillar qatarida sanaqtin ötküzülmidi. ");
INSERT INTO uiglat_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israillar Perwerdigarning Musagha qilghan barliq emri boyiche ish tutup, özlirining tughi boyiche bargah quratti; ular öz qebilisi we ata jemeti tertipi boyiche yolgha chiqatti. ");
INSERT INTO uiglat_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Perwerdigar Sinay téghida Musa bilen sözleshken künlerde, Harun bilen Musaning ewladliri töwendikilerdin ibaret idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Harunning oghullirining ismi mundaq: tunji oghlining ismi Nadab idi, uning yene Abihu, Eliazar, Itamar dégen oghulliri bar idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Harunning oghullirining ismi ene shundaq idi, ular mesihlen’gen kahinlar idi; Musa ularni kahinliq wezipisini öteshke Xudagha atap ayrighanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Lékin Nadab bilen Abihu Sinay chölide gheyriy bir otni Perwerdigarning aldigha sun’ghini tüpeylidin Perwerdigar aldida öldi we ularning héch nesli qaldurulmidi; Eliazar bilen Itamar öz atisi Harun aldida kahinliq wezipisini ötidi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Sen Lawiy qebilisini aldinggha keltürüp, ularni kahin Harunning xizmitide bolushqa uning aldigha hazir qil. ");
INSERT INTO uiglat_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ular Harunning hajiti we pütkül jamaetning hajitidin chiqip jamaet chédirining aldida wezipe ötep, ibadet chédirining xizmitini béjirsun. ");
INSERT INTO uiglat_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ular yene jamaet chédiridiki barliq qacha-qucha eswablarni bashqurush bilen Israillarning xizmitide bolup wezipe ötep, ibadet chédirining ishlirini béjirsun. ");
INSERT INTO uiglat_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Sen Lawiylarni Harun bilen uning oghullirigha teqsimlep bergin; ular Israillar ichidin mexsus uninggha tallap bérilgen. ");
INSERT INTO uiglat_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Harun bilen oghullirini bolsa sen özining kahinliq wezipisini öteshke békitkin; herqandaq yat kishi yéqinlashsa öltürülsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Andin Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","— Qara, Men Israillar ichidin Lawiylarni tallidim, ularni Israil ichide baliyatquning barliq tunji méwisining ornigha, yeni chong oghullirining ornigha qoyimen, shunga Lawiylar Méning bolidu.    ");
INSERT INTO uiglat_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Chünki tunji oghullarning hemmisi Méningkidur; Men Misir zéminida tunji tughulghanlarning hemmisini qetl qilghan künide Israillarning ichidiki tunjilarning hemmisini, meyli adem bolsun yaki haywan bolsun, muqeddes hésablap Méningki qilghanidim. Ular Méningkidur; Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Andin Perwerdigar Sinay chöl-bayawanida Musagha: — ");
INSERT INTO uiglat_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","— Sen Lawiylarni ata jemeti, ailisi boyiche sanaqtin ötküz; barliq erkeklerni, yeni bir ayliqtin ashqanlarning hemmisini sanaqtin ötküz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Shuning bilen Musa Perwerdigarning emri boyiche, özige déyilgendek Lawiylarni sanaqtin ötküzdi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lawiyning oghullirining ismi mundaq: — Gershon, Kohat, Merari. ");
INSERT INTO uiglat_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershonning oghullirining ismi aililiri boyiche Libni we Shimey idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohatning oghulliri aililiri boyiche Amram, Izhar, Hébron we Uzziel idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merarining oghulliri aililiri boyiche Mahli we Mushi idi. Bularning hemmisi ata jemeti boyiche Lawiylarning jemeti boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gershondin Libnilarning jemeti bilen Shimeylerning jemeti wujudqa keldi; bular Gershonlarning jemetliri idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Barliq erlerning sanigha asasen, bir ayliqtin ashqanlirining sanaqtin ötküzülgenliri jemiy yette ming besh yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gershonning jemeti ibadet chédirining arqa teripide, yeni gherb terepte bargah qurdi; ");
INSERT INTO uiglat_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gershon jemetining emiri Laelning oghli Eliasaf idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gershonlarning jamaet chédiridiki wezipisi ibadet chédirining özidiki astinqi ikki yapquch-perde, uning üstidiki yopuq we jamaet chédirining ishik perdisige, ");
INSERT INTO uiglat_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","shundaqla hoyla etrapidiki perdiler, hoyla derwazisining perdisi (hoyla perdiliri ibadet chédiri bilen qurban’gahni chöridep turatti) we hoylida ishlitilidighan munasiwetlik barliq tanilargha qarash idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohattin Amramlarning jemeti, Izharlarning jemeti, Hébronlarning jemeti we Uzziellerning jemeti wujudqa keldi; bu Kohatlarning jemetliri idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Barliq erkeklerning sani boyiche, bir ayliqtin ashqanlar jemiy sekkiz ming alte yüz adem bolup chiqti; ular muqeddes jaygha qarash wezipisini öteydighan boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohat ewladlirining jemetliri jamaet chédirining jenub teripide bargah tikti. ");
INSERT INTO uiglat_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kohat jemetining emiri Uzzielning oghli Elizafan idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ularning wezipisi ehde sanduqi, shire, chiraghdan, ikki qurban’gah, shuningdek muqeddes jayning ichide ishlitidighan qacha-qucha, perde we ibadet chédirining ichide ishlitidighan barliq nersilerge qarash idi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Lawiylarning emirlirining emiri bolsa kahin Harunning oghli Eliazar idi; u muqeddesxanigha qarash wezipisini öteydighanlar üstidin nazaret qilidighan boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Meraridin Mahli jemeti bilen Mushi jemeti wujudqa keldi; bular Merarining jemetliri boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Barliq erkeklerning sanigha asasen, bir ayliqtin yuqiri bolghanlar sanaqtin ötküzülgende jemiy alte ming ikki yüz kishi chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merarining jemetining emiri Abihayilning oghli Zuriyel boldi; ular ibadet chédirining shimal teripige bargah qurdi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merari ewladlirining wezipisi ibadet chédirining taxtayliri, baldaqliri, xadilirigha, teglikliri barliq eswab-jabduqlirigha qarash, shuningdek bulargha munasiwetlik ishlitilidighan barliq nersilerge, ");
INSERT INTO uiglat_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","shundaqla hoylining töt etrapidiki xadilargha we ularning teglikliri, qozuq we tanilargha mes’ul bolushqa belgilenidi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ibadet chédirining aldigha, sherq teripige, yeni jamaet chédirining künchiqish teripige bargah qurghanlar Musa, Harun we Harunning oghulliri idi; ular Israillarning xizmitide bolush wezipisini ötep, muqeddes jaygha qaraydighan boldi; ulargha yat bolghan herqandaq adem muqeddes jaygha yéqinlashsa, öltürületti. ");
INSERT INTO uiglat_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Musa bilen Harun Perwerdigarning emri boyiche, sanaqtin ötküzgen barliq Lawiylar, jemetliri boyiche, yeni bir ayliqtin yuqiri sanaqtin ötküzülgen erkekler jemiy yigirme ikki ming chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Perwerdigar Musagha: — Sen Israillar ichide bir ayliqtin ashqan tunji oghullarni sanaqtin ötküzüp, isim-familisi boyiche tizimlap chiq. ");
INSERT INTO uiglat_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Sen Lawiylarni Israillarning barliq tunjilirining ornida Manga xas qil (Men Perwerdigardurmen); Lawiylarning mal-charwilirinimu Israillarning barliq tunji mal-charwilirining ornida Manga xas qil, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Musa Perwerdigarning emri boyiche, Israillarning tunjilirini qoymay sanaqtin ötküzdi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Bir ayliqtin yuqiri tunji oghul balilirini isim-familisi bilen sanaqtin ötküzgende, ular jemiy yigirme ikki ming ikki yüz yetmish üch kishi chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Sen Lawiylarni Israillarning tunjilirining ornida Manga talla, shundaqla Lawiylarning mal-charwilirinimu Israillarning mal-charwilirining ornida Manga talla; shuning bilen Lawiylar Méningki bolidu; Men Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","We Lawiylarning sanidin artuq chiqqan Israillarning tunjiliri, yeni shu ikki yüz yetmish üchi üchün hörlük heqqini qobul qilghin; ");
INSERT INTO uiglat_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","shularning herbiri üchün besh shekel kümüsh al, kishi sanigha qarap bolsun; muqeddes jaydiki shekelning ölchem birliki boyiche ulardin alghin (bir shekel yigirme gerahdur).    ");
INSERT INTO uiglat_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Artuq chiqqan ademlerning, yeni hörlük heqqini tölishi kérek bolghanlarning kümüshini Harun bilen uning oghullirigha ber. ");
INSERT INTO uiglat_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Emdi Lawiylar teripidin «hörlükke chiqirilghan» dep hésablan’ghan tunji oghullardin artuq chiqqanlardin bolsa, Musa ulardin shu hörlük heqqini aldi; ");
INSERT INTO uiglat_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","u Israillarning tunjiliridin shu kümüshni, yeni muqeddes jaydiki shekelning ölchem birliki boyiche jemiy bir ming üch yüz atmish besh shekel aldi. ");
INSERT INTO uiglat_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa Perwerdigarning emri boyiche «hörlükke chiqirilghan»larning kümüshini del Perwerdigar buyrughinidek, Harun bilen uning oghullirigha berdi. ");
INSERT INTO uiglat_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Andin Perwerdigar Musa bilen Harun’gha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Sen Lawiylar ichidin ata jemeti boyiche Kohat ewladlirining omumiy sanini tizimlighin, ");
INSERT INTO uiglat_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ottuz yashtin ellik yashqiche bolghan, jamaet chédirida ish-xizmet qilishqa kéleleydighanlarning hemmisini tizimlap chiq. ");
INSERT INTO uiglat_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kohat ewladlirining jamaet chédiri ichidiki wezipisi eng muqeddes buyumlarni bashqurush bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Bargah köchürülidighan chaghda, Harun bilen uning oghulliri kirip «eng muqeddes jay»diki «ayrima perde-yopuq»ni chüshürüp, uning bilen höküm-guwahliq sanduqini yögisun; ");
INSERT INTO uiglat_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","andin uning üstini délfinning térisidin étilgen yopuq bilen orap, üstige kök bir rextni yépip, andin kötüridighan baldaqlarni ötküzsun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Teqdim nan tizilghan shirege kök bir rext sélinip, üstige légen, texse, piyale we sharab hediyelirini chachidighan qedehler tizip qoyulsun; shiredimu «daimiy nan» tizilip turiwersun;    ");
INSERT INTO uiglat_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","bu nersilerning üsti qizil rext bilen, uning üsti yene délfin tériside étilgen bir yopuq bilen yépilip, andin kötiridighan baldaqlar ötküzüp qoyulsun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ular kök rext élip, uning bilen chiraghdan bilen üstidiki chiraghlarni, pilik qisquchlarni, küldanlarni we chiraghdan’gha ishlitidighan, barliq may qachilaydighan qachilarni yépip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ular yene chiraghdan bilen chiraghdan’gha ishlitidighan hemme qacha-qucha eswablarni délfin térisidin étilgen yopuq bilen yögep, andin epkeshke sélip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Altun xushbuygahqa kök bir rext sélip, yene délfin tériside étilgen yopuq bilen yépip, andin kötürgüchke qosh baldaqlarni ötküzüp qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Muqeddes jayning ichide ishlitidighan barliq qacha-quchilarni kök bir rext bilen yögep, andin üstige délfin tériside étilgen yopuqni yépip, andin bir epkeshke sélip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ular qurban’gahni külidin tazilap, üstige sösün renglik bir rextni yéyip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Andin yene qurban’gahta ishlitilidighan eswablar — küldan, ilmek, belgürjek, chiniler, shundaqla barliq eswablarni qurban’gah üstige tizip, andin délfin tériside étilgen bir yopuq bilen yépip, andin kötüridighan baldaqlarni ötküzüp qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Pütün bargahtikiler yolgha chiqidighan chaghda, Harun bilen uning oghulliri muqeddes jay we muqeddes jaydiki barliq qacha-qucha eswablarni yépip bolghandin kéyin, Kohatning ewladliri kélip kötürsun; lékin ölüp ketmeslik üchün muqeddes buyumlargha qol tegküzmisun. Jamaet chédiri ichidiki nersilerdin shularni Kohatning ewladliri kötürüshi kérek. ");
INSERT INTO uiglat_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Harunning oghli Eliazarning wezipisi chiragh méyi, xushbuy etir, daimiy teqdim qilinidighan ashliq hediyesi bilen mesihlesh méyigha qarash, shundaqla pütkül ibadet chédiri bilen uning ichidiki barliq nersiler, muqeddes jay hem muqeddes jaydiki qacha-qucha eswablargha qarashtin ibaret. ");
INSERT INTO uiglat_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Andin Perwerdigar Musa bilen Harun’gha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Siler Kohat jemetidikilerni Lawiylar arisidin qet’iy yoqitip qoymanglar; ");
INSERT INTO uiglat_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","belki ularning ölmey, hayat qélishi üchün ular «eng muqeddes» buyumlargha yéqinlashqan chaghda, Harun bilen uning oghulliri kirip ularning herbirige qilidighan we kötüridighan ishlarni körsitip qoysun; ");
INSERT INTO uiglat_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ular peqet muqeddes jaygha kirgende muqeddes buyumlargha bir deqiqimu qarimisun, undaq qilip qoysa ölüp kétidu. ");
INSERT INTO uiglat_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","23","Gershon ewladliri ichide ata jemeti we aililiri boyiche, ottuz yashtin ellik yashqiche bolghan, jamaet chédiri ichide xizmet qilish sépige kireleydighan hemmisini sanaqtin ötküzüp omumiy sanini al. ");
INSERT INTO uiglat_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gershon aililirining qilidighan xizmiti we ular kötüridighan nersiler töwendikiche: ");
INSERT INTO uiglat_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","— ular jamaet chédirining özini, yeni astidiki ichki perdiliri we sirtqi perdilirini, uning yapquchini, shundaqla üstige yapqan délfin tériside étilgen yopuqni we jamaet chédirining kirish ishikining perdisini, ");
INSERT INTO uiglat_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ibadet chédiri bilen qurban’gahni chöridep tartilghan hoylidiki perdiler bilen kirish derwazisining perdisini, shulargha xas tanilirini we ishlitidighan barliq qacha-qucha eswablarni kötürsun; bu eswab-üskünilerge munasiwetlik kérek bolghan ishlarni qilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gershon ewladlirining pütün wezipisi, yeni ular kötüridighan we béjiridighan barliq ishlar Harun we uning oghullirining körsetmiliri boyiche bolsun; ularning néme kötüridighanliqini siler belgilep béringlar. ");
INSERT INTO uiglat_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gershon ewladlirining jemetlirining jamaet chédirining ichide qilidighan xizmiti shular; ular kahin Harunning oghli Itamarning qol astida turup ishlisun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Merarining ewladlirinimu, ularni ata jemeti, aililiri boyiche, sanaqtin ötküz; ");
INSERT INTO uiglat_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ottuz yashtin ellik yashqiche bolghan, jamaet chédiri ichide xizmet qilish sépige kireleydighan hemmisini sanaqtin ötküzüp omumiy sanini al. ");
INSERT INTO uiglat_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ularning jamaet chédiri ichidiki barliq xizmiti, yeni kötürüsh wezipisi mundaq: — Ular jamaet chédirining taxtayliri, baldaqliri, xadiliri we ularning teglikliri, ");
INSERT INTO uiglat_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","hoylining töt etrapidiki xadilar, ularning teglikliri, qozuqliri, tanaliri, barliq eswab-üsküne hem shulargha kéreklik bolghan barliq nersilerni kötürüsh bolsun; ular kötüridighan eswab-üskünilerni namini atap bir-birlep her ademge körsitip béringlar. ");
INSERT INTO uiglat_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari jemet-aililirining jamaet chédiri ichide qilidighan barliq ishliri ene shular; ular kahin Harunning oghli Itamarning qol astida turup ishlisun. ");
INSERT INTO uiglat_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","35","Musa bilen Harun we jamaetning emirliri Kohatning ewladlirining ottuz yashtin ellik yashqiche bolghan, jamaet chédirida xizmet qilish sépige kireleydighanlarning hemmisini ata jemeti, aililiri boyiche sanaqtin ötküzdi. ");
INSERT INTO uiglat_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Ulardin jemeti boyiche sanaqtin ötküzülgenler jemiy ikki ming yette yüz ellik kishi bolup chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Mushular Kohat jemetidin sanaqtin ötküzülgenler bolup, jamaet chédirida ish qilidighan herbiri, yeni Perwerdigarning Musaning wastisi bilen qilghan emri boyiche Musa bilen Harun sanaqtin ötküzgenler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","39","Gershonlarning ata jemeti, aililiri boyiche, ottuz yashtin ellik yashqiche bolghan, jamaet chédirida xizmet qilish sépige kireleydighan hemmisi sanaqtin ötküzüldi; ");
INSERT INTO uiglat_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ata jemeti, aililiri boyiche sanaqtin ötküzülgenler jemiy ikki ming alte yüz ottuz kishi bolup chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Mushular Gershon jemetidin sanaqtin ötküzülgenler bolup, jamaet chédirida ish qilidighan herbiri, yeni Perwerdigarning Musaning wastisi bilen qilghan emri boyiche Musa bilen Harun sanaqtin ötküzgenler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","43","Merarilarning ata jemeti, aililiri boyiche, ottuz yashtin ellik yashqiche bolghan, jamaet chédirida xizmet qilish sépige kireleydighan hemmisi sanaqtin ötküzüldi; ");
INSERT INTO uiglat_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ata jemeti, aililiri boyiche sanaqtin ötküzülgenler jemiy üch ming ikki yüz kishi bolup chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Mushular Merari jemetidin sanaqtin ötküzülgenler bolup, jamaet chédirida ish qilidighan herbiri, yeni Perwerdigarning Musaning wastisi bilen qilghan emri boyiche Musa bilen Harun sanaqtin ötküzgenler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","47","Sanaqtin ötküzülgen Lawiylar mana shular idi; Musa bilen Harun hem Israillarning emirliri ulardin ata jemeti, aililiri boyiche, ottuz yashtin ellik yashqiche bolghan, jamaet chédirida xizmet qilish we yük kütürüsh wezipisige kireleydighanlarni sanaqtin ötküzgen. ");
INSERT INTO uiglat_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Ularning sani jemiy sekkiz ming besh yüz seksen adem bolup chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Perwerdigarning emri boyiche, ular Musa teripidin sanaqtin ötküzüldi; herkim özi qilidighan Ishi we kötüridighan yükige asasen sanaqtin ötküzüldi. Bularning hemmisi Perwerdigarning Musagha emr qilghinidek boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","3","Sen Israillargha emr qilip: «Siler pise-maxaw késili bilen aqma késilige giriptar bolghanlarni, shundaqla ölükke tégishi bilen napak bolup qalghan hemmisini er-ayal démey bargahtin chiqiriwétinglar. Bargahlarni bulghiwetmesliki üchün ularni bargahtin chiqiriwétinglar; chünki Men bargah otturisida makan qildim» — dégin, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Israillar shundaq qilip ularni bargahtin chiqiriwetti; Perwerdigar Musagha qandaq emr qilghan bolsa, Israillar shundaq qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Sen Israillargha éytqin: — Meyli er yaki ayal bolsun, eger u insanlarning Perwerdigargha wapasizliq qilidighan herqandaq gunahliridin birini sadir qilip, shuning bilen gunahkar dep békitilse, ");
INSERT INTO uiglat_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","undaqta u özi ötküzgen gunahigha iqrar qilip, itaetsizliki keltürüp chiqarghan, ziyanlan’ghuchining ziyinini toluq tölep bérishi kérek we uning sirtida u kishige yene beshtin bir ülüshni qoshup tölep bersun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ziyanlan’ghuchining mubada itaetsizlik keltürüp chiqarghan ziyan’gha bérilgen tölem pulini alghudek tughqini bolmisa, tölem puli gunahkar bolghan kishining kafaritige sunulidighan qoshqargha qoshulup, Perwerdigargha atilip, kahin’gha bérilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Shuningdek Israillarning Xudagha atighan barliq muqeddes hediyeliri, yeni kahin’gha keltürgen nersilerdin barliq «kötürme qurbanliq-hediye»ler kahin’gha hésab bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Herkim Xudagha atighan hediyeler muqeddes dep hésablansun, shundaqla kahinning bolsun; kishiler kahin’gha néme hediye qilsa, uning hemmisi kahinning bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Sen Israillargha söz qilip mundaq dégin: — Eger birsining xotuni öz éridin yüz örügen, sadaqetsizlik qilghan bolsa, ");
INSERT INTO uiglat_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","— démek, bashqa birsi bilen yéqinlashqan, shundaqla uning bulghan’ghanliqi érining közliridin yoshurun bolghan bolsa, héch guwahchi bolmighan hem gunah qilghan chéghida tutulupmu qalmighan bolsa, ");
INSERT INTO uiglat_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","shundaq ehwalda, éri öz xotunidin guman qilip künlise, xotuni rastla zina qilip bulghan’ghan bolsa (yaki öz xotunigha guman qilip künlisimu, xotuni zina qilmighan we bulghanmighan bolsa) ");
INSERT INTO uiglat_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ehwalini ispatlash üchün bu adem xotunini kahinning yénigha ekelsun hem xotuni üchün zörür ashliq hediyesi, yeni arpa undin ondin bir efahni alghach kelsun; shu hediyening üstige u héch zeytun méyi quymisun yaki héch mestiki qoshup qoymisun; chünki bu kündashliq hediyesi, esletme ashliq hediyesi bolup, ularning qebihlikige bolghan esletmidur. ");
INSERT INTO uiglat_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Kahin u xotunni aldigha keltürüp, Perwerdigarning huzurida turghuzsun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kahin komzekke muqeddes sudin quyup, ibadet chédirining yer topisidin bir chimdim élip sugha chéchip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kahin u xotunni Perwerdigarning huzurida turghuzup, béshini échip, esletme ashliq hediyesi, yeni kündashliq hediyesini uning qoligha tutquzsun, andin kahin qoligha qarghish keltürgüchi elem süyini alsun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kahin u xotun’gha qesem ichküzüp, uninggha «Derweqe sen héchqandaq adem bilen bille yatmighan, éringning ornida bashqa birsi bilen bille bolushqa ézip buzuqluq qilmighan bolsang, undaqta sen bu qarghish keltürgüchi elem süyidin xalas bolghaysen. ");
INSERT INTO uiglat_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Lékin sen éringning ornida bashqa birsige yéqinliship özüngni bulghighan bolsang, éringdin bashqa bir er sen bilen bille yatqan bolsa, —» désun; ");
INSERT INTO uiglat_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","22","andin kahin u xotun’gha qarghish qesimini ichküzgendin kéyin, yene uninggha: «— Perwerdigar yotangni yiglitip, qorsiqingni ishshitiwetsun, shuningdek Perwerdigar séni öz xelqing ichide qarghish we qesem ichish destikige aylandursun; bu qarghish süyi ich-qarninggha kirip, qorsiqingni ishshitiwetsun, yotangni yiglitiwetsun» dégende, u xotun: «Amin, amin» désun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Shuningdek kahin bu qarghish sözlirini depterge pütüp qoysun, shundaqla yazghan sözlerni elem süyige chilisun, ");
INSERT INTO uiglat_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","andin u xotun’gha bu qarghish keltürgüchi elem süyini ichküzsun, bu qarghish keltürgüchi su uning ichige kirishi bilenla uninggha azab-elem bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kahin u xotunning qolidin kündashliq ashliq hediyesini élip, uni Perwerdigarning huzurida pulanglitip bolghandin kéyin, qurban’gahqa élip kelsun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kahin hediyedin bir siqim un élip, xatire hésabida qurban’gahqa qoyup köydürsun; andin u xotun’gha bu suni ichküzsun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kahin emdi u xotun’gha suni ichküzgendin kéyin, eger u heqiqiy bulghan’ghan bolup, öz érige sadaqetsizlik qilghan bolsa, choqum shundaq boliduki, bu qarghish süyi uning ichige kirgendin kéyin uninggha azab-elem keltüridu; uning qorsiqi ishship, yotisi yigilep kétidu; shuning bilen u xotun öz xelqi ichide qarghishqa kétidu. ");
INSERT INTO uiglat_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Lékin eger u xotun bulghanmighan pak bolsa, shu ishtin xalas bolidu we eksiche hamilidar bolup perzentlik bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Mana bu kündashliq toghrisidiki qanundur; xotun öz érining ornida bashqa birsi bilen bille bolushi bilen ézip bulghan’ghan bolsa ");
INSERT INTO uiglat_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","we yaki birsi xotunidin guman qilip künlise, undaqta u xotunini Perwerdigarning aldida turghuzsun, kahin uninggha shu qanun boyiche hemmini ijra qilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ene shundaq qilghanda, er gunahtin xalas bolup, xotun öz gunahini kötiridu. ");
INSERT INTO uiglat_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Sen Israillargha éytqin: «Meyli er yaki ayal bolsun, «Özümni Perwerdigargha atap, nazariylardin bolimen» dégen alahide bir qesemni ichken bolsa, ");
INSERT INTO uiglat_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","undaqta u özini haraq-sharabtin ayrip perhiz tutsun; haraq-sharab bilen ishlen’gen sirkinimu ichmisun yaki herqandaq üzüm sherbitini ichmisun we höl-quruq üzümlernimu yémisun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Özini Perwerdigargha atighan barliq künlerde, üzüm télidin chiqqan herqandaq nersini, meyli üzüm uruqi bolsun, posti bolsun, ularni yéyishke bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Özümni Perwerdigargha atidim dep qesem qilghan künliride, ularning béshigha ustira tegküzüshke bolmaydu; özini Perwerdigargha atighan künler ötüp bolmighuche, u muqeddes bolushi kérek; ular chachlirini uzun qoyushi kérek.    ");
INSERT INTO uiglat_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","U qesem ichken barliq künliride héchqandaq ölüklerge yéqinlishishqa bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Uning öz atisi, anisi, qérindishi yaki hede-singilliri ölüp qalghan bolsa, ularni dep özini napak qilmasliqi kérek; chünki béshida Perwerdigarghila xas bolimen dep bergen wedisining belgisi bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Özini Xudagha atiwetken barliq künlerde u Perwerdigar aldida muqeddes bolup tursun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Mubada bir kishi uning yénida tuyuqsiz ölüp qélip, özini Perwerdigargha atighanliqning belgisi bolghan béshi bulghan’ghan bolsa, u özini paklash küni we kéyinki yettinchi künimu chéchini aldursun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Sekkizinchi küni u ikki paxtekni yaki ikki bachkini élip jamaet chédirining derwazisi aldida kahin’gha tapshursun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kahin birini gunah qurbanliqi, yene birini köydürme qurbanliq süpitide sunup, ölük sewebidin napak bolup qalghan gunahini tilep kefarǝt qilsun; nazariy shu künning özide öz béshini qaytidin muqeddes-pak qilsun, ");
INSERT INTO uiglat_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","u özini Perwerdigargha atighan künlirini yéngiwashtin bashlisun, shuning bilen bir yashliq bir erkek qozini itaetsizlik qurbanliqi qilip sunsun; ilgiriki künliri bolsa inawetsiz hésablansun; chünki uning özini Perwerdigargha atighan haliti bulghan’ghan. ");
INSERT INTO uiglat_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Nazariylardin biri özini Perwerdigarghila atighan künler toshqan künide u toghruluq qanun-belgilime mundaq: — Kishiler uni jamaet chédirining derwazisi aldigha ekelsun; ");
INSERT INTO uiglat_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","u özi Perwerdigargha sunulidighan köydürme qurbanliq üchün bir yashliq béjirim erkek qozini, gunah qurbanliqi üchün bir yashliq chishi béjirim bir qozini, inaqliq qurbanliqi üchün béjirim bir qoshqarni keltürsun, ");
INSERT INTO uiglat_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","shundaqla bir séwet pétir nan, zeytun méyi ileshtürülgen ésil undin pishurulghan toqachlar hemde zeytun méyi sürülüp mesihlen’gen pétir hemek nanlar we shu qurbanliqlarning qoshumche ashliq hediyeliri we sharab hediyelirini keltürsun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kahin bularni Perwerdigarning huzurigha keltürüp, Nazariyning shu gunah qurbanliqi bilen köydürme qurbanliqini sunsun; ");
INSERT INTO uiglat_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","u Perwerdigargha atalghan inaqliq qurbanliqi süpitide qoshqarni sunsun, uninggha qoshup bir séwet pétir nanni sunsun; kahin shular bilen teng Nazariy qoshup teqdim qilghan ashliq hediyesi bilen sharab hediyesini keltürüp sunsun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Nazariy jamaet chédirining derwazisi aldida özini Perwerdigargha atighanliqigha belge qilip qoyuwetken chéchini chüshürüp, chéchini élip inaqliq qurbanliqi astidiki otqa qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nazariy shu teriqide özini Perwerdigarghila atighanliq chéchini chüshürüp bolghandin kéyin, kahin qaynap pishirilghan qoshqarning bir aldi qolini hem séwettin bir pétir nan bilen bir pétir hemek nanni élip kélip Nazariyning qoligha tutquzsun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Kahin bularni Perwerdigarning aldida pulanglatma qurbanliq süpitide örüsun; bular pulanglatma qurbanliq süpitide sun’ghan tösh bilen kötürme hediye qilin’ghan aldi qol bilen qoshulup, muqeddes dep hésablinip kahin’gha bérilsun; andin kéyin Nazariy sharab ichse bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Shular bolsa qesem ichken Nazariy toghrisida, özini Perwerdigargha atashta sunush zörür bolghan qurbanliq-hediyeler toghrisida békitilgen qanun-belgilimidur; shuningdek uning qoli némige yetse shuni sunsimu bolidu; u ichken qesimi boyiche, yeni özini Xudagha atash wedisi toghruluq shu nizam-belgilime boyiche hemme ishni ada qilsun; wedisige emel qilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Sen Harun bilen uning oghullirigha söz qilip mundaq dégin: — Siler Israillargha mundaq bext-beriket tilenglar: — ");
INSERT INTO uiglat_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«Perwerdigar silerge bext-beriket ata qilghay, silerni Öz panahida saqlighay; ");
INSERT INTO uiglat_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Perwerdigar yüzini silerning üstünglarda yorutup, silerge shapaet qilghay; ");
INSERT INTO uiglat_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Perwerdigar yüzini üstünglargha qaritip kötürüp, silerge xatirjemlik bergey!» — dep tilenglar. ");
INSERT INTO uiglat_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ular shundaq qilip namimni Israillarning üstige qonduridu we Men ulargha bext-beriket ata qilimen. ");
INSERT INTO uiglat_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","2","Musa ibadet chédirini tikligen küni, u chédirni mesih qilip maylap muqeddes qildi, shundaqla uning ichidiki barliq eswab-jabduqlar, qurban’gah we uning barliq qacha-qucha eswablirini mesih qilip maylap muqeddes qildi; shü küni shundaq boldiki, Israilning emirliri, yeni ularning ata jemetining bashliqliri bolghan, qebile emirliri kélip hediyelerni sundi; shu qebililerning emirliri sanaqtin ötküzüsh ishigha nazaret qilghuchilar idi.    ");
INSERT INTO uiglat_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ular özlirining hediyelirini Perwerdigarning huzurigha hazir qilishti, keltürülgen bu hediyeler jemiy bolup alte harwa, on ikki öküzdin ibaret idi; her ikki emir birliship birdin sayiwenlik harwa, herbir emir birdin öküz élip keldi; ular bu hediyelerni chédirining aldigha ekilishti. ");
INSERT INTO uiglat_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Jamaet chédirining ishlirigha ishlitish üchün sen bu nersilerni qobul qilip, Lawiylarning herbirining béjiridighan ishliri boyiche ularning ishlitishige bergin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Shuning bilen Musa harwa bilen öküzlerni qobul qilip Lawiylargha tapshurup berdi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","U Gershon ewladlirining qilidighan ishlirigha asasen, ulargha ikki harwa bilen töt öküz berdi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Merari ewladlirining qilidighan ishlirigha asasen, ulargha töt harwa bilen sekkiz öküz berdi; ularning hemmisi kahin Harunning oghli Itamargha qaraytti; ");
INSERT INTO uiglat_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","lékin u Kohatning ewladlirigha héchnéme bermidi; chünki ular muqeddes nersilerni kötürüshke mes’ul idi; démek, ular mes’ul bolghan nersilerni öz müriside kötüretti. ");
INSERT INTO uiglat_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Qurban’gah maylinip mesihlen’gen küni, uni Xudagha béghishlash yolida emirler sunidighan hediyelirini élip kélip, qurban’gah aldigha qoyushti. ");
INSERT INTO uiglat_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Perwerdigar Musagha: — Ular qurban’gahni béghishlash yolida hediyelirini sunsun; herbir emir öz künide sunsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Birinchi küni hediye sun’ghuchi Yehuda qebilisidin Amminadabning oghli Nahshon boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","köydürme qurbanliq üchün bir erkek torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Amminadabning oghli Nahshon sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ikkinchi küni hediye sun’ghuchi Issakarning emiri Zuarning oghli Netanel boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Zuarning oghli Netanel sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Üchinchi küni hediye sun’ghuchi Zebulun ewladlirining emiri Hélonning oghli Éliab boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Hélonning oghli Éliab sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Tötinchi küni hediye sun’ghuchi Ruben ewladlirining emiri Shidörning oghli Elizur boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Shidörning oghli Elizur sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Beshinchi küni hediye sun’ghuchi Shiméon ewladlirining emiri Zuri-shaddayning oghli Shélumiyel boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Zuri-shaddayning oghli Shélumiyel sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Altinchi küni hediye sun’ghuchi Gad ewladlirining emiri Déuelning oghli Eliasaf boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Déuelning oghli Eliasaf sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Yettinchi küni hediye sun’ghuchi Efraim ewladlirining emiri Ammihudning oghli Elishama boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Ammihudning oghli Elishama sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Sekkizinchi küni hediye sun’ghuchi Manasseh ewladlirining emiri Pidahzurning oghli Gamaliyel boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Pidahzurning oghli Gamaliyel sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Toqquzinchi küni hediye sun’ghuchi Bényamin ewladlirining emiri Gidéonining oghli Abidan boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Gidéonining oghli Abidan sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Oninchi küni hediye sun’ghuchi Dan ewladlirining emiri Ammishaddayning oghli Ahiézer boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Ammishaddayning oghli Ahiézer sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On birinchi küni hediye sun’ghuchi Ashir ewladlirining emiri Okranning oghli Pagiyel boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Okranning oghli Pagiyel sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On ikkinchi küni hediye sun’ghuchi Naftali ewladlirining emiri Énanning oghli Ahira boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","U sun’ghan hediye éghirliqi bir yüz ottuz shekel kélidighan bir kümüsh légen, éghirliqi yetmish shekel kélidighan bir kümüsh das bolup, bular muqeddes jaydiki shekelning ölchem birliki boyiche ölchendi; ashliq hediyesi bolsun dep ikkisige zeytun méyi arilashturulghan ésil un toldurulghanidi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","on shekel éghirliqta, xushbuy toldurulghan bir altun piyale; ");
INSERT INTO uiglat_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","köydürme qurbanliq üchün bir torpaq, bir qochqar, bir yashliq bir erkek qoza; ");
INSERT INTO uiglat_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","gunah qurbanliqi üchün bir téke; ");
INSERT INTO uiglat_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","inaqliq qurbanliqi üchün ikki buqa, besh qochqar, besh téke, bir yashliq besh erkek qoza; bular Énanning oghli Ahira sun’ghan hediyeler idi. ");
INSERT INTO uiglat_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Qurban’gah maylinip mesihlen’gen künide, Israil emirliri qurban’gahqa sun’ghan hediyeler: — jemiy on ikki kümüsh légen, on ikki kümüsh das, on ikki altun piyale boldi, ");
INSERT INTO uiglat_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","herbir kümüsh légenning éghirliqi bir yüz ottuz shekel, herbir kümüsh dasning éghirliqi yetmish shekel idi; mushu qacha-quchigha ketken kümüsh muqeddes jaydiki shekelning ölchem birliki boyiche ölchen’gende, jemiy ikki ming töt yüz shekel chiqti; ");
INSERT INTO uiglat_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","xushbuy bilen toldurulghan altun piyale on ikki bolup, muqeddes jaydiki shekelning ölchem birliki boyiche ölchen’gende, herbir altun piyalining éghirliqi on shekel chiqti; bu altun piyalilerning altuni jemiy bir yüz yigirme shekel chiqti; ");
INSERT INTO uiglat_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","köydürme qurbanliqlar üchün bolghan mallar: — jemiy on ikki torpaq, on ikki qochqar, on ikki bir yashliq erkek qoza idi, herbiri tégishlik ashliq hediyeliri bilen bille sunuldi; on ikki téke gunah qurbanliqi üchün sunuldi; ");
INSERT INTO uiglat_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","inaqliq qurbanliqliri üchün sunulghini jemiy yigirme töt buqa, atmish qochqar, atmish téke, bir yashliq atmish erkek qoza idi. Qurban’gah maylinip mesihlinip, uni Xudagha béghishlash yolida sunulghan hediyeler mana mushular. ");
INSERT INTO uiglat_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa Perwerdigar bilen sözleshkili jamaet chédirigha kirgen chéghida, u «höküm-guwahliq sanduqi»ning üstidiki «kefarǝt texti»ning ikki teripidiki kérubning otturisidin uning özige gep qilghan awazini anglap turdi; Perwerdigar shu yolda uninggha söz qilatti. ");
INSERT INTO uiglat_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Sen Harun’gha: «Sen chiraghlar yaqidighan chaghda yette chiraghning hemmisi chiraghdanning aldini yorutidighan bolsun» dep éytip qoy, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Harun shundaq qildi; u chiraghdan üstidiki chiraghlarning hemmisini yandurup, xuddi Perwerdigarning Musagha éytqinidek, chiragh nurini chiraghdanning aldini yorutidighan qilip qoydi. ");
INSERT INTO uiglat_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Chiraghdanning yasilishi mundaq: u altundin bolqa bilen soqup yasalghan, putidin güllirigiche bolqa bilen soqup chiqirilghan. Perwerdigar Musagha körsetken nusxidek, u chiraghdanni shundaq yasatti. ");
INSERT INTO uiglat_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Sen Israillarning ichidin Lawiylarni tallap chiqip paklighin. ");
INSERT INTO uiglat_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ularni paklash üchün ulargha mundaq qil: «kefarǝt süyi»ni ularning bedinige chachqin; andin ular özliri pütün bedinini ustura bilen chüshürsun, kiyimlirini yuyup özini pak qilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Andin kéyin ular bir torpaq bilen shuninggha qoshup ashliq hediyesini, yeni zeytun méyi ileshtürülgen ésil unni keltürsun; sen gunah qurbanliqi üchün yene bir torpaqni keltür. ");
INSERT INTO uiglat_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Sen Lawiylarni jamaet chédirining aldigha keltür we pütün Israil jamaitini yighip kel; ");
INSERT INTO uiglat_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Lawiylarni Perwerdigarning huzurigha hazir qilghin; andin Israillar kélip qollirini ularning üstige qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Harun Lawiylarni Israillarning «pulanglatma qurbanliq»i süpitide Perwerdigarning xizmitini qilsun dep, Perwerdigargha hediye qilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Lawiylar qollirini héliqi ikki torpaqning béshigha qoysun; sen birini gunah qurbanliqi bolsun, birini köydürme qurbanliq bolsun, Lawiylar üchün kefarǝt keltürsun dep Perwerdigargha sun’ghin. ");
INSERT INTO uiglat_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Sen andin Lawiylarni Harun bilen uning oghullirining aldida turghuzup, ularni pulanglatma qurbanliq süpitide Perwerdigargha hediye qil. ");
INSERT INTO uiglat_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Lawiylar Méningki bolsun dep, sen Lawiylarni ene shu teriqide Israillardin ayrip chiq. ");
INSERT INTO uiglat_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Andin Lawiylar kirip jamaet chédirining ishlirini qilsa bolidu; sen ularni paklandur, ularni pulanglatma qurbanliq süpitide hediye qil. ");
INSERT INTO uiglat_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Chünki ular Israillar ichide pütünley Manga atalghan; Méning ularni Méningki bolsun dep tallishim ularni Israillarning arisida baliyatquning tunji méwisi ornida qoyghanliqimdur. ");
INSERT INTO uiglat_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Chünki Israillarning tunjisi, meyli u insan yaki haywan bolsun, pütünley Manga tewedur; Men Misir zéminida barliq tunjilarni öltürgen küni ularni Özümge muqeddes qilip éliwalghanidim. ");
INSERT INTO uiglat_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Méning Lawiylarni u yol bilen tallishim ularni Israillarning ichidiki tunjilirining ornida qoyushum üchündur. ");
INSERT INTO uiglat_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","We jamaet chédirida Israillarning xizmitide bolsun we Israillarning gunahini tilep kefarǝt keltürsun, shuningdek Israillar muqeddes jaygha yéqinlashqanda ular arisida bala-qaza chiqmisun dep, Men Israillar ichidin Lawiylarni Harun bilen uning oghullirigha berdim». ");
INSERT INTO uiglat_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, Harun we pütkül Israil jamaiti Lawiylarni shundaq qildi; Perwerdigarning Lawiylar toghruluq Musagha buyrughinidek Israillar hemmisini beja keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lawiylar shundaq qilip özlirini gunahtin paklap, kiyim-kécheklirini yuyup pakizlidi; Harun ularni pulanglatma qurbanliq süpitide Perwerdigargha hediye qildi; Harun yene ularni paklashqa gunahini tilep kefarǝt qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Andin kéyin Lawiylar kirip Harunning aldida, shundaqla uning oghullirining aldida, jamaet chédiri ichidiki ishlarni qilishqa kirishti; Perwerdigar Lawiylar toghruluq Musagha qandaq buyrughan bolsa, Israillar uni shu boyiche beja keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Lawiylarning wezipisi mundaq bolsun: — Yigirme besh yashtin yuqiriliri kirip jamaet chédiri ichidiki ishlarni qilishqa sepke kirsun; ");
INSERT INTO uiglat_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ellik yashqa yetkendin kéyin septin chékinip shu xizmetni qilmisun; ");
INSERT INTO uiglat_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","lékin ular jamaet chédiri ichide qérindashlirigha yardemliship, ularning hajetliridin chiqishqa bolidu, emma chédirdiki resmiy wezipide bolmisun. Lawiylarning wezipiliri heqqide ulargha ene shundaq qil». ");
INSERT INTO uiglat_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Misir zéminidin chiqqandin kéyinki ikkinchi yili birinchi ayda, Perwerdigar Sinay chölide Musagha buyrup: — ");
INSERT INTO uiglat_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Israillar békitilgen waqitta ötüp kétish héytini ötküzsun; ");
INSERT INTO uiglat_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","yeni mushu ayning on tötinchi küni gugumda, békitilgen waqitta, barliq belgilime we qaide-tertip boyiche héytni ötküzünglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Shuning bilen Musa Israillargha söz qilip ötüp kétish héytini ötküzüshni buyrudi. ");
INSERT INTO uiglat_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ular birinchi ayning on tötinchi küni gugumda, Sinay chölide ötüp kétish héytini ötküzdi; Perwerdigar Musagha qandaq buyrughan bolsa, Israillar shundaq qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Bir nechcheylen bir ölükke tégip kétip napak bolup qalghanliqi üchün, ular shu küni ötüp kétish héytini ötküzelmidi-de, ular shu küni Musa bilen Harunning aldigha kélip Musagha: — ");
INSERT INTO uiglat_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Biz ölüp qalghan ademge tégip kétip napak bolup qalghan bolsaqmu, lékin némishqa Israillarning qatarida, békitilgen waqitta Perwerdigargha sunushqa kérek bolghinini élip kélishtin ret qilinimiz? — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","— Toxtap turunglar, men bérip Perwerdigar siler toghranglarda néme buyruydikin, anglap baqay, — dédi Musa ulargha. ");
INSERT INTO uiglat_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Sen Israillargha mundaq dégin: «Siler we silerning ewladliringlar ichide beziler ölüklerge tégip kétip napak bolup qalghan bolsa yaki uzaq seper üstide bolsa, ular yenila Perwerdigar üchün ötüp kétish héytini ötküzüshke bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Undaq kishiler ikkinchi ayning on tötinchi küni gugumda héytni ötküzsun; héyt taamini pétir nan we achchiq köktatlar bilen bille yésun; ");
INSERT INTO uiglat_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ulardin etige azraqmu qaldurmisun we qozisining ustixanliridin birersinimu sundurghuchi bolmisun; ular héytni ötüp kétish héytining barliq belgilimiliri boyiche ötküzsun.    ");
INSERT INTO uiglat_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Halbuki, pak bolghan, seper üstidimu bolmighan emma ötüp kétish héytini ötküzüshke étibar bermigen kishi bolsa öz xelqidin üzüp tashlinidu; chünki békitilgen waqitta Perwerdigargha sunush kérek bolghinini sunmighanliqi üchün, u öz gunahini öz üstige alidu. ");
INSERT INTO uiglat_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Eger aranglarda turuwatqan yat ellik bir musapir Perwerdigar üchün ötüp kétish héytini ötküzüshni xalisa, u ötüp kétish héyti toghrisidiki belgilime we qaide-tertip boyiche ötküzsun; yat ellik musapirlar üchün we zéminda tughulghanlar üchünmu aranglarda shu birla nizam bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ibadet chédiri tiklen’gen küni, bulut ibadet chédirini, yeni höküm-guwahliq chédirini qaplap turdi; kechtin taki etigen’giche, bulut xuddi ottek ibadet chédirining üstide turdi.    ");
INSERT INTO uiglat_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Daim shundaq bolatti; kündüzi bulut ibadet chédirini qaplap turatti, kéchisi u otqa oxshaytti. ");
INSERT INTO uiglat_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Qachaniki bulut jamaet chédirining üstidin kötürülse, Israillar yolgha chiqatti; bulut qeyerde toxtisa, Israillar shu yerde bargah tiketti. ");
INSERT INTO uiglat_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israillar Perwerdigarning buyruqi boyiche mangatti, Perwerdigarning buyruqi boyiche bargah tiketti; bulut ibadet chédirining üstide qanche uzaq toxtisa, ular bargahta shunche uzaq turatti. ");
INSERT INTO uiglat_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Bulut ibadet chédirining üstide xéli künlergiche toxtap tursa, Israillarmu Perwerdigarning körsitmisini tutup seperge chiqmaytti; ");
INSERT INTO uiglat_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","mubada bulut ibadet chédirining üstide peqet birnechche künla toxtisa, ular Perwerdigarning buyruqi boyiche shu waqitta bargah qurup yatatti, andin yene Perwerdigarning buyruqi boyiche seperge atlinatti. ");
INSERT INTO uiglat_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","We mubada bulut peqetla kechtin etigen’giche toxtap, ettigende bulut yene kötürülse, ular yene yolgha chiqatti; meyli kündüzi yaki kéchisi bulut kötürülsila, ular seperge chiqatti. ");
INSERT INTO uiglat_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Bulut ibadet chédirining üstide uzunraq tursa, meyli ikki kün, bir ay, bir yil tursimu, Israillar yolgha chiqmay bargahta turuwéretti; lékin bulut kötürülüp mangsila ular sepirini dawamlashturatti. ");
INSERT INTO uiglat_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Perwerdigarning buyruqi bilen ular bargah quratti, Perwerdigarning buyruqi bilen ular seperni dawamlashturatti; ular Perwerdigarning Musaning wastisi bilen bergen emri boyiche, Perwerdigarning körsitmisini tutatti. ");
INSERT INTO uiglat_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Sen özüngge ikki kanay yasatqin; ularni kümüshtin soqtur. Ular jamaetni yighishqa, shundaqla jamaetni bargahlirini yighishturup yolgha chiqishqa chaqirish üchün ishlitilidu. ");
INSERT INTO uiglat_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ikki kanay chélin’ghanda pütkül jamaet séning yéninggha jamaet chédiri derwazisining aldigha yighilidighan bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Eger yalghuz biri chélinsa, emirliri, yeni minglighan Israillarning mingbéshiliri séning yéninggha kélip yighilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Siler qattiq yuqiri awaz bilen chalghanda kün chiqish tereptiki bargahlar yolgha chiqsun. ");
INSERT INTO uiglat_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Andin siler ikkinchi qétim qattiq, yuqiri awaz bilen chalghanda jenub tereptiki bargahlar yolgha chiqsun; ular yolgha chiqqan chaghda kanay qattiq, yuqiri awaz bilen chélinishi kérektur. ");
INSERT INTO uiglat_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Jamaetni yighilishqa chaqiridighan chaghda, kanay chélinglar, emma qattiq, yuqiri awaz bilen chalmanglar; ");
INSERT INTO uiglat_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Harunning ewladliri, kahin bolghanlar kanaylarni chalsun; bular silerge ewladmu-ewlad bir ebediy belgilime bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Eger siler öz zémininglarda silerge zulum salghan düshmininglar bilen jeng qilishqa chiqsanglar, qattiq, yuqiri awaz bilen chélinglar. Shuning bilen özünglarning Xudasi bolghan Perwerdigarning aldida yad étilip, düshmininglardin qutulisiler. ");
INSERT INTO uiglat_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Buningdin bashqa, xushal künliringlarda, békitilgen héytliringlarda we ayning birinchi künliride, siler köydürme qurbanliq we inaqliq qurbanliqlirini sun’ghininglarda, qurbanliqlarning aldida turup kanay chélinglar; shuning bilen kanaylar silerni Xudayinglargha esletküchi bolidu; Men Xudayinglar Perwerdigardurmen. ");
INSERT INTO uiglat_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ikkinchi yili, ikkinchi ayning yigirminchi küni bulut höküm-guwahliq chédirining üstidin kötürüldi; ");
INSERT INTO uiglat_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","shuning bilen Israillar Sinay chölidin chiqip, yol élip seperlirini bashlidi; bulut Paran chölide toxtidi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Bu ularning birinchi qétim Perwerdigarning Musaning wastisi bilen qilghan emri boyiche yolgha chiqishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yehuda bargahi özining tughi astida qoshun-qoshun bolup aldi bilen yolgha chiqti; qoshunning bashliqi Amminadabning oghli Nahshon idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Issakar qebilisi qoshunining bashliqi Zuarning oghli Netanel idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zebulun qebilisi qoshunining bashliqi Hélonning oghli Éliab idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Andin ibadet chédiri chuwulup, Gershonning ewladliri bilen Merarining ewladliri uni kötürüp yolgha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ruben bargahi özining tughi astida qoshun-qoshun bolup yolgha chiqti; qoshunning bashliqi Shidörning oghli Elizur idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shiméon qebilisi qoshunining bashliqi Zuri-shaddayning oghli Shélumiyel idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad qebilisi qoshunining bashliqi Déuelning oghli Eliasaf idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Andin Kohatlar muqeddes buyumlarni kötürüp yolgha chiqti; ular yétip kélishtin burun ibadet chédirini kötürgüchiler kélip uni tiklep qoyushqanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Efraim bargahi özining tughi astida qoshun-qoshun bolup yolgha chiqti; qoshunning bashliqi Ammihudning oghli Elishama idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manasseh qebilisi qoshunining bashliqi Pidahzurning oghli Gamaliyel idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Binyamin qebilisi qoshunining bashliqi Gidéonining oghli Abidan idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Dan bargahi hemme bargahlarning arqa muhapizetchisi bolup, özining tughi astida qoshun-qoshun bolup yolgha chiqti; qoshunning bashliqi Ammishaddayning oghli Ahiézer idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ashir qebilisi qoshunining bashliqi Okranning oghli Pagiyel idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Naftali qebilisi qoshunining bashliqi Énanning oghli Ahira idi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Bular Israillar yolgha chiqqanda qoshun-qoshun bolup méngish tertipi idi; ular shu teriqide yolgha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa özining qéynatisi, Midiyanliq Réuelning oghli Hobabqa: — Biz Perwerdigar wede qilghan yerge qarap seper qiliwatimiz, U: «Men u yerni silerge miras qilip bérimen» dégen; özlirining biz bilen bille méngishlirini ötünimen, biz silige yaxshi qaraymiz, chünki Perwerdigar Israil toghruluq bext-saadet ata qilimen dep wede bergen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Lékin Hobab Musagha: — Yaq, men öz yurtum, öz uruq-tughqanlirimgha kétimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa uninggha: Bizdin ayrilip ketmisile; chünki sili chölde qandaq bargah qurushimiz kéreklikini bilila, sili bizge köz bolup bersile. ");
INSERT INTO uiglat_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Shundaq boliduki, biz bilen bille barsila, kelgüside Perwerdigar bizge qandaq yaxshiliq qilsa, bizmu silige shundaq qilimiz! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Israillar Perwerdigar téghidin yolgha chiqip üch kün yol mangdi; Perwerdigarning ehde sanduqi ulargha aram alidighan yer izdep ularning aldida üch kün yol bashlap mangdi. ");
INSERT INTO uiglat_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ular chédirlirini yighishturup yolgha chiqidighan chaghlarda, Perwerdigarning buluti haman ularning üstide bolatti. ");
INSERT INTO uiglat_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ehde sanduqi yolgha chiqidighan chaghda Musa: «Ornungdin turghaysen, i Perwerdigar; düshmenliring tiripiren bolsun; Sanga öchler yüzüngning aldidin qachsun!» — deytti. ");
INSERT INTO uiglat_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ehde sanduqi toxtighan chaghda u: «Qaytip kelgeysen, i Perwerdigar, minglighan-tümenligen Israil xelqi arisigha qaytip kelgeysen!» — deytti. ");
INSERT INTO uiglat_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","We shundaq boldiki, xelq ghotuldishatti, ularning ghotuldashliri Perwerdigarning quliqigha yétip intayin rezil anglandi; U bu sözlerni anglidi we Uning ghezipi qozghaldi; Perwerdigarning ot-yalquni ularning arisida tutiship, bargahning chétidiki bezilerni köydürüshke bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Xelq bu chaghda Musagha yalwuriwidi, Musa Perwerdigardin tilidi; shuning bilen ot pesiyip öchti. ");
INSERT INTO uiglat_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Perwerdigarning oti ularning otturisida tutashqanliqi üchün u u yerge «Taberah» dep at qoydi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ularning arisidiki shalghut kishilerning nepsi taqildap ketti, Israillarmu yene yighlashqa bashlidi: «Emdi bizge kim gösh béridu?    ");
INSERT INTO uiglat_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Hélimu ésimizdiki, biz Misirdiki chaghlarda pul xejlimey turupmu béliq yéyeleyttuq, yene terxemek, tawuz, piyaz we küde piyaz bilen samsaqmu bar idi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mana bu yerde hazir köz aldimizda mannadin bashqa héchnéme yoq, emdi bizning jénimizmu qurup kétiwatidu» déyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna goya yumghaqsüt uruqigha, körünüshi goya kehriwagha oxshaytti. ");
INSERT INTO uiglat_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Kishiler uyan-buyan chépip uni yighip, bezide yarghunchaqta ézip, bezide hawanchida soqup, ya bezide qazanda pishurup nan qilip yeytti; temi zeytun mayliq toqachlargha oxshaytti. ");
INSERT INTO uiglat_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kéchide bargahqa shebnem chüshkende, mannamu shuning üstige chüshetti. ");
INSERT INTO uiglat_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa xelqning ailimu-aile herbiri öz chédirining ishiki aldida yigha-zar qilishiwatqinini anglidi; buninggha Perwerdigarning ghezipi qattiq qozghaldi, bu ish Musaning neziridimu yaman köründi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa Perwerdigargha: — Sen bu barliq xelqning éghir yükini manga artip qoyup, men qulungni némishqa bundaq qiynaysen; némishqa men Séning aldingda iltipat tapmaymen? ");
INSERT INTO uiglat_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ya men bu pütün xelqqe hamilidar bolup, ularni tughdummu? Sen téxi manga: «Sen ularni Men qesem ichip ularning ata-bowilirigha miras qilghan shu yerge yetküzgüche, xuddi baqqan atisi emchektiki bowaqni baghrigha alghandek baghringgha élip kötürüp mang» dewatisen? ");
INSERT INTO uiglat_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Men bu xelqqe nedin gösh tépip béreleymen? Chünki ular manga yighlap: «Sen bizge yégüdek gösh tépip ber!» déyishmekte. ");
INSERT INTO uiglat_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Men bu xelqni kötürüshni yalghuz üstümge élip kételmeydikenmen, bu ish manga bek éghir kéliwatidu. ");
INSERT INTO uiglat_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Eger Sen manga mushundaq muamile qilmaqchi bolsang, men ötünüp qalay, bu xarab halitimni manga körsetmey, iltipat qilip méni öltürüwet! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Perwerdigar Musagha mundaq dédi: — Israil aqsaqalliri ichidin, sen yénimgha tonuydighan xelq aqsaqalliri we beglerdin yetmishni tallap yighqin, ularni jamaet chédirining aldigha ekel. Ular séning bilen bille shu yerde tursun. ");
INSERT INTO uiglat_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Men shu yerge chüshüp séning bilen sözlishimen; we séning üstüngde turuwatqan Rohni élip ularning üstigimu bölüp qoyimen. Shuning bilen ular sen bilen bille xelqni kötürüsh mes’uliyitini üstige alidu, andin sen uni özüng yalghuz kötürmeydighan bolisen. ");
INSERT INTO uiglat_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Sen xelqqe mundaq dégin: «Ete gösh yiyishke teyyarlinip özenglerni Xudagha atap paklanglar; chünki siler Perwerdigarning quliqini aghritip yighlap: «Emdi kim bizge gösh béridu? Ah, Misirdiki halimiz bek yaxshi idi!» dégenidinglar emesmu? Perwerdigar derweqe silerge gösh béridu, siler uningdin yeysiler. ");
INSERT INTO uiglat_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Siler bir kün, ikki kün emes, besh kün, on kün emes, yigirme künmu emes, ");
INSERT INTO uiglat_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","belki pütün bir ay yeysiler, taki burninglardin étilip chiqip hö bolghuche yeysiler; chünki siler aranglarda turuwatqan Perwerdigarni mensitmey, uning aldida yighlap turup: «Biz néme üchün Misirdin chiqtuq?» — dédinglar». ");
INSERT INTO uiglat_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa: — Men ularning arisida turuwatqan bu xelqtin yolgha chiqalaydighan erkekler alte yüz ming tursa, Sen téxi: «Men ularni gösh yeydighan, hetta pütün bir ay gösh yeydighan qilimen» deysen; ");
INSERT INTO uiglat_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","emise qoy, kala padilirining hemmisi soyulsa ulargha yétemdu? Yaki déngizdiki hemme béliq ulargha tutup bérilse, ularning yiyishige yitermu? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Shuning bilen Perwerdigar Musagha: — Perwerdigarning qoli qisqa bolup qaptimu? Emdi körüp baqqine, Méning sanga dégen sözüm emelge ashurulamdu-yoq? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Shuning bilen Musa chiqip Perwerdigarning sözini xelqqe yetküzdi we xelq ichidiki aqsaqallardin yetmish ademni tallap yighip ularni jamaet chédirining etrapida turghuzdi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Andin Perwerdigar bulut ichidin chüshüp, Musa bilen sözliship, uningdiki Rohtin élip yetmish aqsaqalgha qoydi; Roh ularning üstige qonushi bilen ular bésharet bérishke kirishti. Lékin shu waqittin kéyin ular undaq qilmidi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Lékin u chaghda ulardin ikki adem bargahta qaldi; birsining ismi Eldad, ikkinchisi Médad idi (ular eslide aqsaqallarning arisida tizimlan’ghanidi, lékin ibadet chédirigha chiqmay qalghanidi). Roh ularning üstidimu qondi we ular bargah ichide bésharet bérishke bashlidi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Yash bir yigit yügürüp kélip Musagha: — Eldad bilen Médad bargahta bésharet bériwatidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Musaning xizmetkari, Musa tallighan serxil yigitliridin biri, Nunning oghli Yeshua qopup: — I xojam Musa, ularni tosughayla, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Lékin Musa uninggha: — Sen méning sewebimdin heset qiliwatamsen? Perwerdigarning pütün xelqi peyghember bolup ketse idi, Perwerdigar Özining Rohini ularning üstige qoysa idi! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Shuning bilen Musa bilen Israil aqsaqallirining hemmisi bargahqa qaytip kétishti. ");
INSERT INTO uiglat_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Emdi Perwerdigar aldidin bir shamal chiqip, u déngiz tereptin bödünilerni uchurtup kélip, bargahning etrapigha yéyiwetti; bödüniler bargahning u teripidimu bir künlük yol, bu teripidimu bir künlük yol kelgüdek yer yüzini ikki gez égizlikte kelgüdek qaplidi.    ");
INSERT INTO uiglat_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Xelq ornidin turup pütkül shu küni, shu kéchisi we etisi pütün kün bödüne tutup yighdi, eng az dégenlirimu alahazel ikki xomir yighdi; ular bularni bargahning töt etrapigha özliri üchün yéyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ular göshni chaynap ézip bolmay, gösh téxi chishliri arisida turghanda, Perwerdigarning ghezipi ulargha qozghilip, xelqni intayin éghir bir waba bilen urdi.    ");
INSERT INTO uiglat_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Shunga kishiler shu yerni «Qibrot-Hattawah» dep atidi; chünki ular shu yerde nepsi taqildighan kishilerni yerlikke qoyghanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kéyin xelq Qibrot-Hattawahtin yolgha chiqip Hazirotqa kélip, Hazirotta toxtidi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Meriyem bilen Harun Musaning hebeshlik qizni xotunluqqa alghini üchün uninggha qarshi söz qildi (chünki u hebeshlik bir qizni alghanidi). ");
INSERT INTO uiglat_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ular: — Perwerdigar peqet Musa bilenla sözliship, biz bilen sözleshmeptimu? — déyishti. Bu gepni Perwerdigar anglidi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa dégen bu adem intayin kemter-mömin adem bolup, bu terepte yer yüzidikiler arisida uning aldigha ötidighini yoq idi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Perwerdigar Musa, Harun we Meriyemge tuyuqsiz: — Siler üchünglar jamaet chédirigha kélinglar, — dédi. Üchilisi chiqip keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Andin Perwerdigar ershtin bulut tüwrüki ichide chüshüp, jamaet chédirining aldida toxtap, Harun bilen Meryemni qichqiriwidi, ular aldigha keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","U ulargha: — Emdi siler gépimni anglanglar, eger silerning aranglarda peyghember bolsa, Men Perwerdigar alamet körünüshte uninggha Özümni ayan qilimen, chüshide uning bilen sözlishimen. ");
INSERT INTO uiglat_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Lékin qulum Musagha nisbeten undaq emes; u barliq ailem ichide tolimu sadiqtur; ");
INSERT INTO uiglat_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Men uning bilen tépishmaq éytip olturmay, yüzmu yüz turup biwasite sözlishimen; u Men Perwerdigarning qiyapitini köreleydu. Emdi siler némishqa qulum Musa toghruluq yaman gep qilishtin qorqmidinglar? — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Perwerdigarning otluq ghezipi ulargha qozghaldi we u kétip qaldi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Shuning bilen bulut jamaet chédiri üstidin ketti, we mana, Meryem xuddi ap’aq qardek pése-maxaw bolup ketti; Harun burulup Meryemge qariwidi, mana, u pése-maxaw bolup qalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Harun Musagha: — Way xojam! Nadanliq qilip gunah ötküzüp qoyghanliqimiz sewebidin bu gunahni bizning üstimizge artmighaysen. ");
INSERT INTO uiglat_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","U xuddi anisining qorsiqidin chiqqandila bedini yérim chirik, ölük tughulghan balidek bolup qalmighay! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Shuning bilen Musa Perwerdigargha: — I Tengri, uning késilini saqaytiwetken bolsang, — dep nida qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Perwerdigar Musagha: — Eger atisi uning yüzige tükürgen bolsa, u yette kün xijilchiliq ichide turghan bolatti emesmu? Emdi u bargahning sirtigha yette kün qamap qoyulsun, andin u qaytip kelsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Shuning bilen Meryem bargah sirtigha yette kün qamap qoyuldi, taki Meryem qaytip kelgüche xelq yolgha chiqmay turup turdi. ");
INSERT INTO uiglat_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Andin kéyin xelq Hazirottin yolgha chiqip, Paran chölide bargah qurdi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Men Israillargha miras qilip bergen Qanaan zéminini charlap kélishke ademlerni ewetkin; herbir ata jemetke tewe qebilidin birdin adem chiqirilsun, ular öz qebilisidiki emir bolsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa Perwerdigarning emri boyiche, ularni Paran chölidin yolgha saldi; ularning hemmisi Israillarning bashliri idi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Töwendikiler ularning isimliri: — Ruben qebilisidin Zakkurning oghli Shammuya, ");
INSERT INTO uiglat_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shiméon qebilisidin Xorining oghli Shafat, ");
INSERT INTO uiglat_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yehuda qebilisidin Yefunnehning oghli Kaleb, ");
INSERT INTO uiglat_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Issakar qebilisidin Yüsüpning oghli Igal, ");
INSERT INTO uiglat_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efraim qebilisidin Nunning oghli Hoshiya, ");
INSERT INTO uiglat_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Binyamin qebilisidin Rafuning oghli Palti, ");
INSERT INTO uiglat_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zebulun qebilisidin Sodining oghli Gaddiyel, ");
INSERT INTO uiglat_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yüsüp qebilisidin, yeni Manasseh qebilisidin Susining oghli Gaddi, ");
INSERT INTO uiglat_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan qebilisidin Gimallining oghli Ammiyel, ");
INSERT INTO uiglat_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Ashir qebilisidin Mikailning oghli Setur, ");
INSERT INTO uiglat_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naftali qebilisidin Wofsining oghli Nahbi, ");
INSERT INTO uiglat_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad qebilisidin Makining oghli Géuel. ");
INSERT INTO uiglat_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Mana bular Musa charlap kélinglar dep Qanaan zéminigha ewetken ademlerning ismi. Musa Nunning oghli Hoshiyani Yehoshuya dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa ularni charlap kélishke Qanaan’gha seperwer qilip: — Siler mushu yerdin Negew chöli terepke qarap ménginglar, andin taghliq rayon’gha chiqinglar. ");
INSERT INTO uiglat_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","U yerning qandaq ikenlikini, u yerdikilerning küchlük-ajizliqini, az yaki köplükini körüp béqinglar; ");
INSERT INTO uiglat_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ular turuwatqan yerning qandaq ikenlikini, yaxshi-yamanliqini körünglar; ular turuwatqan sheherlerning qandaq ikenlikini, bargahliq sheher yaki sépil-qelelik sheher ikenlikini; ");
INSERT INTO uiglat_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","u yerning munbet yaki munbetsiz ikenlikini, del-derexlirining bar-yoqluqini körüp kélinglar. Yüreklikrek bolup, méwe-chiwiliridin alghach kélinglar, — dédi. Bu chagh del üzüm piship qalghan waqit idi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ular shu tereplerge chiqip, zéminni Zin chölidin tartip taki Hamat éghizining yénidiki Rehobqiche bérip charlashti. ");
INSERT INTO uiglat_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ular jenub terepte Hébron’gha bardi, u yerlerde Anaqiylarning ewladliridin Ahiman, Shishay, Talmay dégenler olturushluq idi. Eslide Hébron shehiri Misirdiki Zoan shehiridin yette yil ilgiri yasalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ular «Eshkol jilghisi»gha keldi, u yerde bir sap üzümi bar bir üzüm shéxini késip, bir baldaqqa ésip ikki ademge kötürgüzüp mangdi; ular azraq anar bilen enjürmu élip qaytip keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israillar shu yerde késiwalghan eshu üzüm sewebidin u yer «Eshkol jilghisi» («üzüm sapiqi jilghisi») dep ataldi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ular qiriq kündin kéyin u yerlerni charlap tügitip, qaytip keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ular kélip, Paran chöllükidiki Qadeshte Musa, Harun we pütün Israil jamaiti bilen körüshti. Ular ikkiylen’ge hem pütkül Israil jamaitige melumat berdi hem zéminning méwilirini ulargha körsetti. ");
INSERT INTO uiglat_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ular Musagha melumat bérip: — Biz özliri béringlar dégen yerlerge barduq, rasttinla süt bilen hesel éqip turidighan yer iken, mana bular shu yerning méwiliri. ");
INSERT INTO uiglat_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Biraq u yerdikiler bek küchtünggür iken, sheherler sépilliq bolup hem puxta-heywetlik iken. Uning üstige, biz u yerde Anaqiylarning ewladlirinimu körduq. ");
INSERT INTO uiglat_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalekler jenub terepte turidiken; Hittiylar, Yebusiylar, Amoriylar taghlarda turidiken; Qanaaniylar déngiz boylirida we Iordan deryasi boylirida turidiken, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb Musaning aldida köpchilikni tinchitip: — Biz derhal atlinip bérip u yerni igileyli! Chünki biz choqum ghalip kélimiz — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Lékin uning bilen bille chiqqan bashqilar bolsa: — Ular bizdin küchlük iken, shunga ulargha hujum qilsaq bolmaydu, — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Andin charlighuchilar özliri charlap kelgen zéminning ehwalidin Israillargha yaman melumat bérip: — Biz kirip charlap ötken zémin bolsa öz ahalisini yeydighan zémin iken; biz u yerde körgenlerning hemmisi yoghan ademler iken. ");
INSERT INTO uiglat_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Biz u yerlerde «Nefiliyler» dégen gigant ademlerni körduq (derweqe Anaqiylarning ewladliri Nefiliylerdin chiqqandur); biz özimizge qarisaq chéketkidek turidikenmiz, biz ularghimu shundaq körinidikenmiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Shuning bilen barliq jamaet dad-peryad kötürüp yighlidi; ular kéchiche yigha-zar qiliship chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israillar Musa bilen Harun’gha tapa-tene qilip: — Biz baldurla Misirda ölüp ketsek boptiken! Mushu chöl-jeziride ölüp ketsek boptiken! ");
INSERT INTO uiglat_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Perwerdigar némishqa bizni qilich astida ölsun, xotun bala-chaqilirimiz bulinip, düshmenning oljisi bolsun dep bizni bu yerge bashlap kelgendu? Uningdin köre, Misirgha qaytip ketkinimiz yaxshi emesmu? — dep ghotuldashti. ");
INSERT INTO uiglat_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Shuning bilen ular bir-birige: — Bashqidin bir bashliq tiklep Misirgha qaytip kéteyli, — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa bilen Harun pütün Israil jamaiti aldida yiqilip düm yatti. ");
INSERT INTO uiglat_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Shu yerni charlap kelgenler ichidiki Nunning oghli Yeshua bilen Yefunnehning oghli Kaleb kiyimlirini yirtip, ");
INSERT INTO uiglat_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","pütün Israil jamaetchilikige: — Biz charlap kélishke ötüp barghan zémin intayin bek yaxshi zémin iken. ");
INSERT INTO uiglat_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Eger Perwerdigar bizdin söyünse, bizni shu zémin’gha, yeni hesel bilen süt éqip turidighan shu zémin’gha bashlap bérip, uni bizge béridu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Siler peqet Perwerdigargha asiyliq qilmanglar! U zéminidikilerdin qorqmanglar, chünki ular bizge nisbeten bir ghizadur; ularning panahdarliri ulardin ketti, Perwerdigar bolsa biz bilen bille; ulardin qorqmanglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Halbuki, pütkül jamaet terep-tereptin: — U ikkisini chalma-kések qilip öltürüwéteyli, déyishti. Lékin Perwerdigarning julasi jamaet chédirida Israillargha ayan boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Perwerdigar Musagha: — Bu xelq Méni qachan’ghiche mensitmeydu? Gerche ularning otturisida shunche möjizilik alametlerni yaratqan bolsammu, lékin ular Manga qachan’ghiche ishinishmeydiken? ");
INSERT INTO uiglat_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Men ularni waba bilen urup yoqitimen, shuning bilen séni ulardin téximu chong we qudretlik bir el qilimen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa bolsa Perwerdigargha mundaq dédi: — «Bundaq bolidighan bolsa bu ishni misirliqlar anglap qalidu, chünki Sen ulugh qudriting bilen bu xelqni ularning arisidin élip chiqqaniding; ");
INSERT INTO uiglat_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","we Misirliqlar bu ishni shu zémindiki xelqlergimu éytidu. U zémindiki ahalimu Sen Perwerdigarning bu xelqning arisida ikenlikingni, Sen Perwerdigarning ularning aldida yüzmuyüz körün’genlikingni, Séning buluting daim ulargha saye chüshürüp kelgenlikini, shundaqla Séning kündüzi bulut tüwrükide, kéchisi ot tüwrükide ularning aldida mangghanliqingni anglighanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Emdi Sen bu xelqni xuddi bir ademni öltürgendek öltürüwetseng, Séning nam-shöhritingni anglighan ellerning hemmisi: ");
INSERT INTO uiglat_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","«Perwerdigar bu xelqni Özi ulargha bérishke qesem qilghan zémin’gha bashlap baralmaydighanliqi üchün, shunga ularni eshu chöl-jeziride öltürüwétiptu» dep qalidu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Emdi ötünimenki, Rebbim qudritingni jari qildurghaysen, Özüngning: ");
INSERT INTO uiglat_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","«Perwerdigar asanliqche achchiqlanmaydu, Uning méhir-muhebbiti téship turidu; U gunah we itaetsizlikni kechüridu, lékin gunahkarlarni hergiz gunahsiz dep qarimaydu, atilarning qebihlikini atisidin balisighiche, hetta newre-chewrilirigiche ularning üstige yükleydu» déginingdek qilghaysen.    ");
INSERT INTO uiglat_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Méhir-shepqitingning kengriliki boyiche, Misirdiki chaghdin taki hazirghiche daim kechürüp kelginingdek, bu xelqning qebihlikini kechürgeysen!». ");
INSERT INTO uiglat_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Perwerdigar: — «Boptu, sen dégendek ularni kechürdüm. ");
INSERT INTO uiglat_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Lékin Öz hayatim bilen qesem qilimenki, pütkül yer yüzi Men Perwerdigarning shan-sheripi bilen tolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Halbuki, Méning julayimni, Misirda we chöl-jeziride körsetken möjizilik alametlirimni körüp turupmu Méni mushundaq on qétimlap sinap yene awazimgha qulaq salmighanlar, ");
INSERT INTO uiglat_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Men qesem ichip ularning ata-bowilirigha miras qilip bérimen dégen u zéminni hergiz körelmeydu; Méni mensitmigenlerdin birimu u yurtni körelmeydu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Lékin özide bashqiche bir rohning bolghini, pütün qelbi bilen Manga egeshkini üchün qulum Kalebni u kirgen yerge bashlap kirimen; uning ewladlirimu u yerge mirasxor bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(shu chaghda Amalekler bilen Qanaaniylar taghliq jilghilarda turuwatatti) — Ete siler yolunglardin burulup, Qizil Déngizgha baridighan yol bilen méngip chölge seper qilinglar» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Perwerdigar Musa bilen Harun’gha söz qilip mundaq dédi: ");
INSERT INTO uiglat_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","— Men Méning yaman gépimni qilip ghotuldishidighan bu rezil jamaetke qachan’ghiche chidishim kérek? Israillarning Méning yaman gépimni qilghanliri, shu toxtawsiz ghotuldashlirining hemmisini anglidim. ");
INSERT INTO uiglat_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sen ulargha: — Perwerdigar mundaq deydu: «Men hayatim bilen qesem qilimenki, xep, Men silerge quliqimgha kirgen sözliringlar boyiche muamile qilmaydighan bolsam! ");
INSERT INTO uiglat_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Silerning ölükünglar mushu chölde yatidu; silerning ichinglarda sanaqtin ötküzülgenler, yeni yéshi yigirmidin ashqan, Méning yaman gépimni qilip ghotuldighanlarning hemmisi pütün sani boyiche ");
INSERT INTO uiglat_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Silerge qol kötürüp qesem qilip, turalghunglar qilip bérimen dégen zémin’gha héch kirelmeydu; peqet Yefunnehning oghli Kaleb bilen Nunning oghli Yeshuala kiridu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Silerning kichik baliliringlar, yeni «Bulinip, düshmenning oljisi bolup qalidu» déyilgenlerni Men bashlap kirimen, ular siler kemsitken u zémindin behrimen bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Biraq siler bolsanglar, siler yiqilip, ölükünglar bu chölde qalidu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Silerning baliliringlar buzuqluq-wapasizliqinglarning elimini tartip, ölükünglar chölde yoqalghuche, bu chölde qiriq yil sergerdan bolup yüridu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Silerning shu zéminni charlighan künliringlarning sani boyiche, qiriq künning herbir künini bir yil hésablap, qebihlikliringlarni qiriq yil öz üstünglargha élip yürisiler; shu chaghda Méning özünglardin yatlashqinimning néme ikenlikini bilip yétisiler» — dégin. ");
INSERT INTO uiglat_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Men Perwerdigar shundaq dégenikenmen, yighilip Manga qarshi chiqqan bu rezil xelq jamaitige Men choqum shundaq qilimen; ular mushu chöl-jeziride yewétilidu, shu yerde ölidu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Musa u zéminni charlap kélishke ewetkenler qaytip kelgende, u zémin toghruluq yaman xewer élip kélish bilen pütün jamaetni ghotulditip, Musaning yaman gépini qilghuzghanlar, ");
INSERT INTO uiglat_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","yeni u zémin toghruluq yaman xewer ekelgen bu kishilerning hemmisi waba késili tégip Perwerdigarning aldida öldi. ");
INSERT INTO uiglat_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Zéminni charlap kélishke barghan ademler ichidin peqet Nunning oghli Yeshua bilen Yefunnehning oghli Kalebla hayat qaldi. ");
INSERT INTO uiglat_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa bu geplerni pütkül Israil jamaitige éytiwidi, hemmisi bek hesret chekti. ");
INSERT INTO uiglat_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ular etigen tang atqanda turup taghqa chiqip: — Mana biz kelduq! Perwerdigar éytqan yurtqa chiqip hujum qilayli; chünki biz gunah qilduq, — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","— Siler yene némishqa Perwerdigarning emrige xilapliq qilisiler? — dédi Musa, — Bu ish ghelibilik bolmaydu! ");
INSERT INTO uiglat_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Perwerdigar aranglarda bolmighachqa, düshmenning qilichi astida ölüp, meghlup bolmasliqinglar üchün hujumgha chiqmanglar. ");
INSERT INTO uiglat_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Chünki Amalekler bilen Qanaaniylar u yurtta, silerning aldinglarda turidu; siler qilich astida ölüp kétisiler; chünki siler Perwerdigardin ténip kettinglar, Perwerdigar siler bilen bille bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Lékin, gerche Perwerdigarning ehde sanduqi we Musa bargahtin qozghalmighan bolsimu, ular yenila öz meyliche taghqa chiqip hujumgha ötti. ");
INSERT INTO uiglat_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Shuning bilen Amalekler bilen shu taghda turushluq Qanaaniylar chüshüp ularni taki Xormahghiche qoghlap, bitchit qilip qirghin qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Sen Israillargha mundaq dégin: — Siler makanlishishinglar üchün silerge teqdim qilip béridighan zémin’gha kirgen chéghinglarda, ");
INSERT INTO uiglat_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","eger Perwerdigargha atap otta sunulidighan, uninggha xushbuy bolsun dep birer hediye-qurbanliq qilmaqchi bolsanglar, qurbanliq kala yaki qoy-öchke padisidin bolsun. U köydürme qurbanliq bolsun, qesemni ada qilish qurbanliqi bolsun, ixtiyariy qurbanliq yaki silerge békitilgen héytlardiki zörür qurbanliq bolsun, ");
INSERT INTO uiglat_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","qurbanliq sun’ghuchi kishi Perwerdigargha atighinigha bir ashliq hediyesini qoshup keltürsun. Köydürme qurbanliq yaki bashqa qurbanliq qoza bolsa, undaqta ashliq hediyesi zeytun méyidin bir hinning töttin biri ileshtürülgen ésil undin efahning ondin biri bolsun; uninggha yene sharab hediyesi süpitide töttin bir hin sharabni qoshup sunsun.    ");
INSERT INTO uiglat_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Qurbanliqing qochqar bolsa, sen uninggha ashliq hediyesi süpitide üchtin bir hin zeytun méyi ileshtürülgen ésil undin efahning ondin ikkisi bolsun ");
INSERT INTO uiglat_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","we sharab hediyesi süpitide üchtin bir hin sharabni qoshup sunsun; bular Perwerdigargha xushbuy chiqarsun dep sunulsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Eger sen Perwerdigargha köydürme qurbanliq, yaki qesem ada qilish qurbanliqi yaki inaqliq qurbanliqi süpitide torpaq atighan bolsang, ");
INSERT INTO uiglat_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","undaqta torpaqqa ashliq hediyesi süpitide yérim hin zeytun méyi ileshtürülgen ésil undin efahning ondin üchini, ");
INSERT INTO uiglat_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","sharab hediyesi süpitide yérim hin sharabni qoshup sun’ghin; bular Perwerdigargha atilip otta sunulup, xushbuy chiqarsun dep keltürülsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Herbir sunulghan torpaq, qochqar, qoza yaki oghlaqqa nisbeten mushundaq qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Siler sunidighininglarning sani boyiche, herxil qurbanliqning sanigha qarap shundaq qilisiler. ");
INSERT INTO uiglat_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Shu zéminda tughulghanlarning hemmisi Perwerdigargha xushbuy chiqarsun dep, otta sunulidighan qurbanliq qilmaqchi bolsa ene shundaq qilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Shuningdek siler bilen bille turuwatqan musapir yaki ewladmu-ewlad siler bilen bille turuwatqanlar bolsa, xushbuy chiqarsun dep otta sunulidighan qurbanliq qilmaqchi bolsa, siler qandaq qilghan bolsanglar, ularmu shundaq qilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Pütkül jamaetke, meyli siler bolunglar yaki siler bilen bille turuwatqan musapir bolsun, hemminglar üchün oxshash bir belgilime bolidu; siler üchün dewrmu-dewr ebediy bir belgilime bolidu; Perwerdigar aldida siler qandaq bolsanglar, musapirlarmu shundaqtur. ");
INSERT INTO uiglat_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Silergimu, aranglarda turuwatqan musapirlarghimu oxshash bir qanun-belgilime, oxshash bir höküm bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Sen Israillargha söz qilip ulargha mundaq dégin: — «Siler Men silerni ekiridighan zémin’gha yétip barghanda, ");
INSERT INTO uiglat_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","shu yerdin chiqqan ashliqni yeydighan chéghinglarda, Perwerdigargha bir «kötürme hediye» teqdim qilinglar. ");
INSERT INTO uiglat_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Siler herbir yéngi xémirdin pishqan nanlardin birini «kötürme hediye» qilip teqdim qilinglar; siler uni teqdim qilghanda xuddi xamanning «kötürme hediye»sige oxshash bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dewrdin-dewrge siler deslepki hosuldin chiqqan xémirdin bir nanni «kötürme hediye» süpitide Perwerdigargha sununglar. ");
INSERT INTO uiglat_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Eger siler özünglar bilmey ézip gunah qilip, Perwerdigarning Musagha buyrughan bu barliq emirlirige emel qilmighan bolsanglar, ");
INSERT INTO uiglat_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","yeni Perwerdigar buyrughan kündin étibaren barliq ewladliringlarghiche Perwerdigarning Musaning wastisi bilen silerge buyrughan barliq ishlirigha emel qilmighan bolsanglar, ");
INSERT INTO uiglat_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","jamaet shundaq birer gunahning bilmey ötküzülgenlikidin xewersiz bolsa, undaqta pütkül jamaet Perwerdigargha xushbuy chiqarsun dep yash bir torpaqni köydürme qurbanliq süpitide sunsun hemde qaide-nizam boyiche uninggha munasiwetlik ashliq hediyesi bilen sharab hediyesini qoshup sunsun, we uning üstige bir tékini gunah qurbanliqi süpitide sunsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Shu yol bilen kahin pütkül Israil jamaiti üchün kefarǝt keltürüp, bu gunah ulardin kechürüm qilinidu; chünki bu bilmey ötküzüp qoyghan gunah we ular özlirining bilmey ötküzüp qoyghan gunahi üchün qurbanliq, yeni Perwerdigargha atap otta sunulidighan qurbanliq we gunah qurbanliqini birlikte Perwerdigar aldigha sun’ghan. ");
INSERT INTO uiglat_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Bu gunah pütkül Israil jamaiti bilen ularning arisida turuwatqan musapirlarning hemmisidin kechürüm qilinidu, chünki bu pütkül xelq bilmey turup ötküzüp qoyghan gunahtur. ");
INSERT INTO uiglat_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Eger bir kishi bilmestin gunah qilip qoyghan bolsa, u bir yashliq bir chishi oghlaqni gunah qurbanliqi süpitide sunsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Kahin shu yol bilen bilmey gunah qilip qoyghan adem üchün kefarǝt keltüridu; uning üchün kefarǝt keltürse uning Perwerdigar aldida bilmey ötküzgen gunahi uningdin kechürüm qilinidu. ");
INSERT INTO uiglat_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Bilmey birer sewenlik ötküzüp qoyghan barliq kishilerge, meyli shu zéminda tughulghan Israillar bolsun yaki ularning arisida turuwatqan musapirlargha bolsun, — silerning hemminglargha oxshash bir qanun-belgilime tetbiqlinidu. ");
INSERT INTO uiglat_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Lékin yürikini qaptek qilip ish körgen kishi, meyli u zéminda tughulghan bolsun yaki musapir bolsun, Perwerdigargha haqaret keltürgen bolidu; u haman öz xelqidin üzüp tashlinidu. ");
INSERT INTO uiglat_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","U Perwerdigarning sözini mensitmigeniken, Perwerdigarning emrige xilapliq qilghaniken; shuning üchün u choqum üzüp tashlinidu; gunahi özining béshigha chüshidu. ");
INSERT INTO uiglat_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israillar chöl-jeziridiki waqitlirida, bir kishining shabat künide otun tergenliki bayqaldi. ");
INSERT INTO uiglat_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Otun tériwatqanliqini bayqap qalghanlar uni Musa, Harun we pütkül jamaetning aldigha élip keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Uni qandaq bir terep qilish kérekliki téxi körsitilmigechke, ular uni qamap qoydi. ");
INSERT INTO uiglat_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Perwerdigar Musagha: — U adem öltürülmise bolmaydu; pütün jamaet uni bargahning téshigha epchiqip chalma-kések qilip öltürsun, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Andin pütün jamaet u ademni bargah sirtigha epchiqip, xuddi Perwerdigar Musagha buyrughandek, chalma-kések qilip öltürdi. ");
INSERT INTO uiglat_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Sen Israillargha mundaq dégin, ular ewladmu-ewlad kiyim-kécheklirining chörisige chuchilarni tutsun hem burjikidiki chuchilirining herbirige kök shoyna tikip qoysun; ");
INSERT INTO uiglat_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","bu xil chuchilar silerning uni tikip turushunglar üchün bolidu; uni körgende Perwerdigarning barliq emrlirini ésinglarda tutup, ulargha emel qilishinglar üchün bu silerge bir esletme bolidu; shuningdek silerning hazirqidek özünglarning könglünglar we közünglarning keynige kirip, qatirap buzuqluq qilip ketmeslikinglar, ");
INSERT INTO uiglat_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Méning barliq emrlirimni este tutushunglar hem uninggha emel qilip, Xudayinglargha atap pak-muqeddes bolushunglar üchün bolsun. ");
INSERT INTO uiglat_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Men Xudayinglar bolush üchün silerni Misir zéminidin élip chiqqan Perwerdigardurmen; Men Perwerdigar Xudayinglardurmen. ");
INSERT INTO uiglat_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Lawiyning ewrisi, Kohatning newrisi, Izharning oghli Korah we Rubenning ewladliridin Éliabning oghulliri Datan bilen Abiram we Peletning oghli On ");
INSERT INTO uiglat_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Israillar ichidiki jamaet emirliri bolghan, jamaet ichidin saylap chiqilghan mötiwerlerdin ikki yüz ellik kishini bashlap kélip Musagha qarshi chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ular yighilip Musagha qarshi hem Harun’gha qarshi chiqip: — Siler heddinglardin bek ashtinglar, pütkül jamaetning hemmisi pak-muqeddes, Perwerdigarmu ularning arisida, shundaq turughluq siler néme dep özünglerni Perwerdigarning jamaitidin üstün qoyusiler? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","5","Musa ularning gépini anglap düm yiqilip, Korah bilen uning guruhidikilerge söz qilip: — Ete etigende Perwerdigar kimlerning Özige mensup ikenlikini, kimlerning pak-muqeddes ikenlikini ayan qilidu; shu kishini Özige yéqinlashturidu; kimni tallighan bolsa, uni Özige yéqinlashturidu. ");
INSERT INTO uiglat_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Siler mundaq qilinglar: — Sen Korah we séning guruhingdikiler hemmisi xushbuydanlarni epkélinglar; ");
INSERT INTO uiglat_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ete Perwerdigarning aldida xushbuydanlargha ot yéqip, xushbuyni uning üstige qoyunglar; Perwerdigar kimni tallisa, shu muqeddes-pak bolghan bolsun! Ey siler Lawiylar, heddinglardin bek ashtinglar! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa yene Korahqa: — I Lawiylar, gépimge qulaq sélinglar. ");
INSERT INTO uiglat_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","10","Israilning Xudasi Perwerdigar silerni Özining chédirining ishlirini qilsun dep hemde jamaetning aldida ularning xizmitide bolsun dep Özige yéqinlashturush üchün silerni Israil jamaitidin ayrip chiqqan — yeni Perwerdigar séni we séning hemme qérindashliring bolghan Lawiyning ewladlirini birdek Özige yéqinlashturghanliqi silerche kichik ishmu? Siler yene téxi kahinliq wezipisini tama qiliwatamsiler? ");
INSERT INTO uiglat_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Shu wejidin sen we séning guruhingdikiler hemmisi yighilip Perwerdigargha qarshi chiqiwétipsiler-de; Harun némidi, siler uning üstidin shunchilik aghrinip ghotuldiship ketküdek? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Musa Éliabning oghli Datan bilen Abiramni qichqirip kélishke adem ewetiwidi, ular: — Barmaymiz! ");
INSERT INTO uiglat_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Séning bizni süt bilen hesel aqidighan zémindin bashlap chiqip bu chöl-jeziride öltermekchi bolghanliqingning özi kichik ishmu? Sen téxi özüngni padishah hésablap bizning üstimizdin hökümranliq qilmaqchimu? ");
INSERT INTO uiglat_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Halbuki, sen bizni süt bilen hesel aqidighan yurtqa bashlap kelmiding, étiz we üzümzarliqlarnimu bizge miras qilip bermiding. Sen bu xeqning közinimu oyuwalmaqchimu? Biz barmaymiz! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Buni anglap Musa qattiq ghezeplinip Perwerdigargha: — Ularning sowghat-hediyesige étibar qilmighaysen; men ularning hetta birer éshikinimu tartiwalmidim, birer adimigimu héch ziyan-zexmet yetküzmidim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa Korahqa: — Ete sen we séning guruhingdikiler — sen, ular we Harun Perwerdigarning aldigha kélinglar. ");
INSERT INTO uiglat_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Herbiringlar özünglarning xushbuydanliringlarni ekilip uning üstige xushbuyni sélinglar; herbiringlar özünglarning xushbuydanliringlarni, yeni jemiy ikki yüz ellik xushbuydanni élip uni Perwerdigarning huzurida tutup turunglar; senmu, Harunmu herbiringlar öz xushbuydanliringlarni élip kélinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Shuning bilen herbir adem özining xushbuydanini élip, otni yéqip, xushbuy sélip, Musa we Harun bilen birlikte jamaet chédirining derwazisi aldida turushti. ");
INSERT INTO uiglat_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah Musa bilen Harun’gha hujum qilghili pütün jamaetni yighip jamaet chédirining derwazisi aldigha kéliwidi, Perwerdigarning julasi pütkül jamaetke ayan boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Perwerdigar Musa bilen Harun’gha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Siler bu xelqning arisidin néri turunglar, men köz yumup achquche ularni yutuwétimen, — déwidi, ");
INSERT INTO uiglat_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Musa bilen Harun düm yiqilip: — I Tengrim, barliq et igilirining rohlirining Xudasi, bir adem gunah qilsa, ghezipingni pütün jamaetke chachamsen? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Sen jamaetke: «Siler Korah, Datan we Abiramning turar jayliridin ayrilip ulardin néri kétinglar» — dep buyruq ber, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Shuning bilen Musa ornidin turup Datan bilen Abiram terepke qarap mangdi; Israil aqsaqallirimu uninggha egiship mangdi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Musa jamaetke: — Silerdin ötünimen, bu rezil ademlerning chédirliridin yiraq kétinglar, ularning barliq gunahliri sewebidin ular bilen bille weyran bolmasliqinglar üchün ularning héchnersisige qol tegküzmenglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Shuning bilen jamaet Korah, Datan, Abiramning chédirlirining töt etrapidin néri ketti; Datan bilen Abiram bolsa öz ayallirini, oghul-qizlirini we bowaqlirini élip chiqip öz chédirining ishiki aldida turdi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa: — Buningdin siler shuni bilisilerki, bu ishlarning hemmisi méning könglümdin chiqqan emes, belki Perwerdigar méni ularni ada qilishqa ewetken: ");
INSERT INTO uiglat_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","— eger bu ademlerning ölümi adettiki ademlerning ölümige oxshash bolidighan yaki ularning béshigha chüshidighan qismetler adettiki ademler duchar bolidighan qismetlerge oxshash bolidighan bolsa, Perwerdigar méni ewetmigen bolatti. ");
INSERT INTO uiglat_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Eger Perwerdigar yéngi bir ishni qilip, yer aghzini échip ularni we ularning pütün nersisini yutup kétishi bilen, ular tirikla tehtisaragha chüshüp ketse, u chaghda siler bu ademlerning Perwerdigarni mensitmigenlikini bilip qalisiler, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musaning bu gépi axirlishishi bilenla ularning puti astidiki yer yérildi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Yer aghzini échip ularni barliq ailisidikiler bilen, shuningdek Korahqa tewe hemme ademlerni qoymay teelluqatliri bilen qoshup yutup ketti. ");
INSERT INTO uiglat_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Shundaq qilip, ular we ularning tewesidikilerning hemmisi tirikla tehtisaragha chüshüp ketti, yer ularning üstide yépildi. Ular shu yol bilen jamaetning arisidin yoqaldi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ularning etrapida turghan Israillarning hemmisi ularning nalisini anglap: «Yer biznimu yutup kétermikin!» déyiship qéchishti. ");
INSERT INTO uiglat_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Andin Perwerdigarning aldidin bir ot chiqip, xushbuy sunuwatqan héliqi ikki yüz ellik ademnimu yutup ketti. ");
INSERT INTO uiglat_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Sen kahin Harunning oghli Eliazargha buyrughin, u xushbuydanlarni ot arisidin tériwélip, choghlirini yiraqlargha chéchiwetsun, chünki u xushbuydanlar Xudagha atalghandur; ");
INSERT INTO uiglat_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","shunga özining jénigha özi zamin bolghan gunahkarlarning xushbuydanlirini tériwalghin; ular qurban’gahni qaplash üchün soqup népiz tünike qilinsun, chünki bu xushbuydanlar eslide Perwerdigarning huzurigha sunulup uninggha atalip muqeddes qilin’ghan. Shundaq qilip ular kéyin Israillargha ibret bolidighan isharet-belge bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Shuning bilen kahin Eliazar otta köydürüwétilgenler sun’ghan mis xushbuydanlarni tériwaldi; ular qurban’gahni qaplitishqa népiz tünike qilip soquldi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Shuning bilen qurban’gahning bu qaplimisi Harunning ewladlirigha yat ademlerning xuddi Korah bilen uning guruhidikilerge oxshash qismetke qalmasliqi üchün, Perwerdigarning huzurida xushbuy köydürüshke yéqinlashmasliqigha Israillar üchün bir esletme boldi. Bu Perwerdigarning Musaning wastisi bilen Eliazargha buyrughanliridur. ");
INSERT INTO uiglat_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Etisi pütkül Israil jamaiti Musa bilen Harunning yaman gépini qilip: — Siler Perwerdigarning xelqini öltürdünglar, — dep ghotuldashti. ");
INSERT INTO uiglat_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","We shundaq boldiki, jamaet Musa bilen Harun’gha hujum qilishqa yighiliwatqanda, jamaet burulup jamaet chédirigha qariwidi, we mana, bulut chédirni qapliwaldi hem Perwerdigarning julasi ayan boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Shuning bilen Musa bilen Harun jamaet chédirining aldigha bérip turdi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Perwerdigar Musagha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Men közni yumup achquche ularni yoqitip tashlishim üchün ikkinglar bu jamaettin chiqip néri kétinglar, — dep buyruwidi, ikkiylen yiqilip yerde düm yatti. ");
INSERT INTO uiglat_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa Harun’gha: — Sen xushbuydanni élip uninggha qurban’gahtiki ottin sal, uninggha xushbuy qoyup, ular üchün kefarǝt keltürüshke tézlikte jamaetning arisigha apar; chünki qehr-ghezep Perwerdigarning aldidin chiqti, waba basqili turdi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Harun Musaning déginidek qilip, xushbuydanni élip jamaetning arisigha yügürüp kirdi; we mana, waba kishilerning arisida bashlan’ghanidi; u xushbuyni xushbuydan’gha sélip, xelq üchün kefarǝt keltürdi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","U ölükler bilen tirikler otturisida turuwidi, waba toxtidi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Korahning weqesi munasiwiti bilen ölgenlerdin bashqa, waba sewebidin ölgenler on töt ming yette yüz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Harun jamaet chédirining derwazisi yénida turghan Musaning yénigha yénip keldi; waba toxtidi. ");
INSERT INTO uiglat_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Sen Israillargha söz qilip, ulardin ata jemeti boyiche, her qebilining emiridin birdin on ikki hasa alghin; sen ularning herbirining ismini özining hasisigha yézip qoyghin. ");
INSERT INTO uiglat_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Lawiy qebilisining hasisigha Harunning ismini yazghin, chünki herbir ata jemet qebile bashliqi üchün bir hasa wekil bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Sen bu hasilarni jamaet chédiridiki höküm-guwahliq sanduqining aldigha, yeni Men séning bilen körüshidighan yerge qoyghin.    ");
INSERT INTO uiglat_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","We shundaq boliduki, Men tallighan kishining bolsa, uning hasisi bix süridu; shundaq qilip Israillarning silerge ghudurashqan geplirini toxtitip Manga anglanmaydighan qiliwétimen». ");
INSERT INTO uiglat_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Shuning bilen Musa Israillargha shundaq söz qildi; ularning hemme emirliri uninggha birdin hasini, jemiy bolup on ikki hasini berdi; herbir ata jemetke bir hasa wekil boldi, Harunning hasisimu shularning ichide idi. ");
INSERT INTO uiglat_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa hasilarni höküm-guwahliq chédirigha ekirip Perwerdigarning huzurigha qoydi. ");
INSERT INTO uiglat_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","We shundaq boldiki, Musa etisi höküm-guwahliq chédirigha kiriwidi, mana, Lawiy jemetige wekil bolghan Harunning hasisi bix sürüp, ghunchilap, chécheklep, badam chüshkenidi. ");
INSERT INTO uiglat_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musa hasilarning hemmisini Perwerdigarning aldidin élip chiqip, Israil xelqige körsetti; ular körgendin kéyin herkim öz hasilirini élip kétishti. ");
INSERT INTO uiglat_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Perwerdigar Musagha: — Shu asiyliq qilghuchi balilargha bir agah belgisi bolsun dep Harunning hasisini höküm-guwahning aldigha ekirip qoyghin. Shundaq qilsang sen ularning ghudurashqan geplirini toxtitip, Manga anglanmaydighan qilisen; ularmu shuning bilen ölüp ketmeydu, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa shundaq qildi; Perwerdigar özige qandaq buyrughan bolsa u shundaq qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israillar Musagha söz qilip: — Biz nepestin qalay dewatimiz, biz tügeshtuq, biz hemmimiz tügeshtuq! ");
INSERT INTO uiglat_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Perwerdigarning ibadet chédirigha yéqinlashqanlar ölmey qalmaydu, shundaq iken, biz hemmimiz mutleq nepestin qélishimiz kérekmu? — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Perwerdigar Harun’gha mundaq dédi: — Sen, oghulliring we ata jemetingdikiler séning bilen birlikte muqeddes jaygha munasiwetlik bolghan gunahni, shuningdek sen we oghulliring birlikte kahinliq wezipisige munasiwetlik bolghan gunahni üstünglargha alisiler. ");
INSERT INTO uiglat_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Sen qérindashliring bolghan Lawiy qebilisidikilerni, yeni ata-bowiliringning qebilisidikilerni özüng bilen birleshtür hem ularni xizmitingni qilishi üchün bashlap élip kel; biraq sen bilen oghulliring séning bilen birlikte höküm-guwahliq chédiri aldida xizmetlerni qilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ular séning buyruqliringgha teyyar turup, shundaqla chédirdiki barliq xizmet-wezipisini öteydu; peqet muqeddes jaydiki qacha-qucha eswablargha we qurban’gahqa yéqinlashmisun; undaq qilsa, ularmu, silermu ölüp kétisiler. ");
INSERT INTO uiglat_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ular séning bilen birliship, jamaet chédiridiki wezipini ötep, qilidighan herbir ishini qilsun; peqetla héch yat kishiler silerge yéqinlashmisun. ");
INSERT INTO uiglat_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Qehr-ghezep yene Israillarning béshigha chüshmisun üchün, siler muqeddes jaydiki wezipe bilen qurban’gahdiki wezipini öteshke mes’ul bolunglar. ");
INSERT INTO uiglat_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mana, Men Özüm silerning qérindashliringlar bolghan Lawiylarni Israillar ichidin tallap chiqtim; ular jamaet chédirining ishlirini qilishqa Perwerdigargha teqdim qilin’ghan bolup, silerge sowgha süpitide ata qilin’ghan. ");
INSERT INTO uiglat_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Lékin sen we oghulliring séning bilen birlikte kahinliq wezipenglerde turup, qurban’gahtiki barliq ishlarni hem perde ichidiki ishlarni béjiringlar; silerning wezipengler shundaq bolsun. Kahinliq wezipisini, xizmitimde bolushunglar üchün silerge sowgha qilip berdim; yat ademler yéqinlashsa, öltürüwétilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Perwerdigar Harun’gha mundaq dédi: — Men Manga sunulghan kötürme hediyelerni, yeni Israillar Manga muqeddes dep atighan barliq nersilerni ülüshünglar bolsun dep, mana menggülük belgilime bilen sanga we séning ewladliringgha teqdim qildim. ");
INSERT INTO uiglat_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Israillar otta sunidighan, «eng muqeddes» nersilerdin silerge munular qaldurup bérilidu: — ularning Manga atap sun’ghan barliq nersiliri, yeni barliq ashliq hediyeliridin, barliq gunah qurbanliqliridin, barliq itaetsizlik qurbanliqliridin «eng muqeddes» hésablan’ghanliri, sanga we ewladliringgha ata qilinidu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Sen shu ülüshüngni «eng muqeddes» süpitide yégin, silerdin bolghan herbir er kishi uni yésun; u sanga «eng muqeddes» dep bilinsun. ");
INSERT INTO uiglat_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Munularmu séning bolidu: — Israillarning sowghatliri ichidin kötürme hediyeler, barliq pulanglatma hediyeler séning; Men ularni sanga, shundaqla oghulliring bilen qizliringgha menggülük belgilime bilen teqdim qildim; séning öyüngdiki herbir pak adem uningdin yése bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Zeytun méyidin eng ésilini, yéngi sharabtin eng ésilini, shundaqla ashliqtin eng ésilini, yeni Israillar Perwerdigargha atap sun’ghan deslepki pishqan mehsulatlarning hemmisini Men sanga teqdim qilip berdim. ");
INSERT INTO uiglat_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ular yerdin élip Perwerdigargha atap ekelgen deslepki pishqan nersilerning hemmisi séning bolsun; öyüngdiki herbir pak adem uningdin yése bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Israilda Xudagha mutleq atilidighan herbir nerse séning bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ular Perwerdigargha atap keltüridighan barliq janiwarlarning tunjiliri, meyli insan yaki ulagh-charpay bolsun séning bolidu; halbuki, insanlarning tunjilirini bolsa ularni tölem tölep yanduruwalsun we napak haywanlarning tunjilirini tölem tölep yanduruwalsun.    ");
INSERT INTO uiglat_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Tölem tölesh kérek bolghanlar üchün yéshi bir ayliqtin ashqanda tölem puli tölensun; ulargha sen toxtatqan baha boyiche, yeni muqeddes jaydiki shekelning ölchem birliki boyiche (bir shekel yigirme gerahdur) baha qoyup, besh kümüsh shekel al. ");
INSERT INTO uiglat_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Peqet tunji kala, tunji qoy yaki tunji oghlaqqa tölem alsang bolmaydu; ularning hemmisi muqeddestur. Sen ularning qénini qurban’gahqa chéchip, méyini Perwerdigargha atap otta sunulidighan, Uninggha xushbuy keltüridighan qurbanliq süpitide köydürgin. ");
INSERT INTO uiglat_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ularning göshi séning bolidu; xuddi «kötürme hediye» qilin’ghan tösh we ong arqa putigha oxshash, sanga tewe bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Israillar Perwerdigargha atap sun’ghan muqeddes nersiler ichidiki kötürme hediye-qurbanliqning hemmisini Men sanga we séning bilen bille turuwatqan oghul-qizliringgha menggülük belgilime bilen teqdim qildim. Bu Perwerdigar aldida sen we séning bilen bille turuwatqan ewladliring üchün menggülük tuzluq ehde bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Perwerdigar Harun’gha mundaq dédi: — Israil zéminida séning héchqandaq mirasing bolmaydu, ularning arisidimu héchqandaq nésiweng bolmaydu; Israillar arisida mana Men Özüm séning nésiweng, séning mirasingdurmen. ");
INSERT INTO uiglat_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Lawiylargha bolsa, ularning öteydighan xizmetliri, yeni jamaet chédiridiki xizmiti üchün, mana Men Israilda teqdim qilin’ghan barliq «ondin bir ülüsh»ning hemmisini ulargha miras qilip bergenmen. ");
INSERT INTO uiglat_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Buningdin kéyin, gunahkar bolup ölüp ketmesliki üchün, Israillar jamaet chédirigha yéqinlashmisun. ");
INSERT INTO uiglat_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Jamaet chédiridiki xizmetni bolsa, uni ötigüchiler peqet Lawiylarla bolidu we shu ishta bolghan gunahini özliri üstige alidu, bu siler üchün ewladmu-ewlad menggülük bir belgilime bolidu; ularning Israillarning ichide héchqandaq mirasi bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Chünki Israillarning Perwerdigargha atap kötürme hediye süpitide sun’ghan «ondin bir ülüshi»ni Lawiylargha miras qilip teqdim qilidighan boldum; shunga Men ular toghruluq: Israillar ichide héchqandaq mirasi bolsa bolmaydu, — dédim. ");
INSERT INTO uiglat_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Sen Lawiylargha éytqin: «Siler Israillarning qolidin Men silerge miras bolsun dep teqdim qilghan «ondin bir ülüsh»ni alghan ikensiler, siler shu ondin bir ülüshning yene ondin bir ülüshini ayrip, uni Perwerdigargha atap kötürme hediye süpitide sununglar. ");
INSERT INTO uiglat_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Bu yol bilen silerning shu «kötürme hediye»nglar silerge «xamandiki ashliqinglar»din hem «sharab kölchikidiki tolup tashqan sharabinglar»din atalghanlar hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Bundaq bolghanda, siler Israillarning qolidin alghan ondin bir ülüshning hemmisidin Perwerdigargha atap kötürme hediye sunisiler; siler Perwerdigargha atighan shu «kötürme hediye»ni kahin Harun’gha béringlar. ");
INSERT INTO uiglat_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Silerge teqdim qilin’ghan barliq nersilerdin eng ésilini élip shularni muqeddes hésablap «Perwerdigargha atalghan toluq kötürme hediye» süpitide sununglar». ");
INSERT INTO uiglat_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Shunga sen Lawiylargha éytqinki, «Siler shulardin eng ésilini kötürüp sunsanglar, bu siler Lawiylarning xamandiki ashliqinglar we sharab kölchikidiki sharabinglargha oxshash hésablinidu. ");
INSERT INTO uiglat_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Shundaq qilghandin kéyin siler we öydikiliringlar shu «ondin bir ülüsh»lerni xalighan yerde yésenglar bolidu, chünki bu silerning jamaet chédiridiki xizmitinglarning in’ami bolidu; ");
INSERT INTO uiglat_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Siler shu ülüshlerdin eng ésilini kötürüp sunsanglar, mushu ishinglar sewebidin gunahkar bolmaysiler. Undaq qilsanglar siler Israillar atighan muqeddes nersilerni bulghimaysiler, shuning bilen ölmeysiler». ");
INSERT INTO uiglat_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Perwerdigar Musa bilen Harun’gha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Men Perwerdigar emr qilghan qanun-belgilime shuki: — Sen Israillargha buyrughin, ular béjirim, nuqsansiz, boyunturuq sélinmighan qizil yash siyirdin birni séning yéninggha ekelsun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Sen siyirni kahin Eliazargha tapshur, u uni chédirgahning sirtigha epchiqsun, andin birsi siyirni uning aldida boghuzlisun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kahin Eliazar barmiqini qan’gha milep, jamaet chédirining aldigha qaritip yette mertem chachsun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Andin birsi Eliazarning köz aldida pütkül siyirni köydürsun, yeni uning térisi, göshi, qéni we tézeklirini köydürsun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kahin kédir yaghichi, zofa ösümlüki we qizil rextni siyir köydürülidighan otqa tashlisun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Andin kahin öz kiyimini yusun we bedinini suda yusun, andin kéyin bargahqa kirishke bolidu; lékin kahin kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Siyirni köydürgen kishimu kiyimlirini su bilen yuyup, öz bedinini suda yusun, andin u kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Pak bir adem siyirning külini yighip bargahning sirtidiki pak bir yerge qoysun; u Israil jamaiti üchün «napakliqni chiqarghuchi su»ni yasashqa shu yerde saqlansun, u bir «gunahni paklighuchi»dur. ");
INSERT INTO uiglat_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Siyirning külini yighishturghan adem özining kiyimlirini yusun we kech kirgüche napak sanalsun. Bu Israillargha we ularning arisida turuwatqan musapirlargha menggülük qanun-belgilime bolidu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","— Ölükke, yeni herqandaq ölgen kishining jesitige tégip ketken herbir kishi yette kün napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","U adem üchinchi küni ashu su bilen özini paklisun, hemde yettinchi künimu paklisun, andin u pak sanilidu; eger u üchinchi küni hemde yettinchi küni özini paklimisa, pak sanalmaydu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Herqandaq adem ölükke, yeni herqandaq ölgen kishining jesitige tégip ketse, hemde özini paklimisa, Perwerdigarning chédirini bulghighan bolidu; shu kishi Israil arisidin üzüp tashlinidu; chünki «napakliqni chiqarghuchi su» uninggha sépilmigechke, u napak sanilidu; uning napakliqi téxiche üstide turidu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Eger birer kishi bir chédir ichide ölüp qalghan bolsa, u toghruluq qanun-belgilime mundaq bolidu: — shu chédirgha kirgen herbirsi we chédirda turup qalghanlarning herbiri yette kün napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Herbir ochuq turghan, aghzi yépilmighan qacha-quchilarning hemmisi napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Shuningdek dalada qilich-shemsher bilen öltürülgenlerge, yaki özi ölüp qalghanning ölükige, yaki ademning ustixininigha yaki qebrisige tegken herbir kishi yette kün’giche napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Kishiler bu napak kishi üchün «paklandurghuchi qurbanliq»ning külidin azraq élip komzekke sélip, ularning üstige éqin su quysun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Andin pak bir kishi zofa ösümlükini élip shu sugha tegküzüp uni chédirgha we ichidiki barliq qacha-quchilargha hem shu yerde turghan barliq kishilerning üstige sépip qoysun, we yene uni ustixan’gha, öltürülgüchige yaki qebrige tegken kishining üstige sépip qoysun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Üchinchi küni we yettinchi küni héliqi pak adem pak bolmighan ademlerning üstige shu suni sépip qoysun; shundaq qilghanda, yettinchi künige kelgende u kishi paklan’ghan bolidu; andin u kishi kiyimlirini yuyup, bedinini suda yusun, kech kirgende u pak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Lékin napak bolup qélip, özini paklimighan kishi Perwerdigarning muqeddes jayini bulghighini üchün, jamaet arisidin üzüp tashlinidu; «napakliqni chiqarghuchi su» uning üstige sépilmigen, shunga u napak sanilidu. ");
INSERT INTO uiglat_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Bu Israillargha menggülük belgilime bolidu, «napakliqni chiqarghuchi su»ni sepken kishi bolsa özining kiyimlirini yusun we «napakliqni chiqarghuchi su»gha tegken kishi kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Napak kishi tegken herqandaq nersimu napak sanilidu; bu nersilerge tegken kishilermu kech kirgüche napak sanalsun. ");
INSERT INTO uiglat_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Birinchi ayning ichide Israillar, yeni pütkül Israil jamaiti Zin chölige yétip kélip, Qadeshte turup qaldi; Meryem shu yerde wapat boldi we shu yerge depne qilindi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Jamaetke ichidighan’gha su yoq idi, ular yighilip Musa bilen Harun’gha hujum qilghili turdi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Xelq Musa bilen tegiship: — Qérindashlirimiz Perwerdigarning aldida ölgen chaghda bizmu bille ölsek boptiken! ");
INSERT INTO uiglat_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Siler néme üchün biz we charpaylirimizni bu yerde ölüp ketsun dep, Perwerdigarning jamaitini bu chöl-jezirige bashlap keldinglar? ");
INSERT INTO uiglat_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Siler néme üchün bizni Misirdin élip chiqip bundaq dehshetlik yerge ekeldinglar? Bu yerde ya tériqchiliq qilghili yer bolmisa, ya enjür, üzüm, anar bolmisa, ichidighan’gha sumu bolmisa, — déyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Shuning bilen Musa bilen Harun jamaettin ayrilip jamaet chédirining derwazisi aldigha kélip düm yiqiliwidi, Perwerdigarning julasi u ikkisige ayan boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Hasini qolunggha al, andin sen akang Harun bilen birlikte jamaetni yighip, ularning köz aldidila qoram tashqa buyruq qil; shundaq qilsang qoram tash öz süyini chiqiridu; shu yol bilen sen ulargha su chiqirip, jamaet we charpayliri ichidighan’gha su bérisen.    ");
INSERT INTO uiglat_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Shuning bilen Musa Perwerdigarning emri boyiche Perwerdigarning huzuridin hasini aldi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa bilen Harun ikkisi jamaetni qoram tashning aldigha yighdi we Musa ulargha: — Gépimge qulaq sélinglar, i asiylar! Biz silerge bu qoram tashtin su chiqirip béreylimu?! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Andin Musa hasisi bilen qoram tashni ikki qétim uruwidi, nahayiti köp su éqip chiqti, sudin jamaetmu, charpaylarmu ichishti. ");
INSERT INTO uiglat_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Perwerdigar Musa bilen Harun’gha: — Siler Manga ishenmey, Israillar aldida Méni muqeddes dep hörmetlimigininglar üchün, ikkinglarning bu jamaetni Men ulargha teqdim qilip bergen zémin’gha bashlap kirishinglargha yol qoymaymen, — dédi.    ");
INSERT INTO uiglat_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Su chiqirilghan jay «Meribah suliri» dep atalghan; Israillar shu yerde Perwerdigar bilen takallashqanliqi üchün, U ularning otturisida Özining muqeddes ikenlikini körsetti. ");
INSERT INTO uiglat_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa Qadeshtin Édom padishahi bilen körüshüshke elchi ewetip uninggha: «Qérindashliri Israil mundaq deydu: — Biz tartiwatqan jebr-japalarning qandaqliqi özlirige melum, ");
INSERT INTO uiglat_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","bizning ata-bowilirimiz Misirgha chüshken bolup, biz Misirda uzaq zaman turup kettuq; misirliqlar bizgimu, bizning ata-bowilirimizghimu yaman muamile qildi; ");
INSERT INTO uiglat_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","biz Perwerdigargha yéliniwéduq, U bizning zarimizgha qulaq sélip, Perishte ewetip bizni Misirdin élip chiqti. Hazir mana, biz özlirining chégrisigha jaylashqan Qadesh dégen bir sheherde turuwatimiz.    ");
INSERT INTO uiglat_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Emdi bizning zéminliridin ötüshimizge ruxset qilghan bolsila, biz étiz-ériq we üzümzarliqlardin ötmeymiz, quduqliringladin sumu ichmeymiz; «Xan yoli» bilen méngip chégriliridin ötüp ketküche ong-solgha burulmaymiz» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Lékin Édomlar uninggha: «Silerning bizning zéminimizdin ötüshünglerge bolmaydu, ötimen désenglar qilich kötürüp silerge jengge chiqimiz» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israillar uninggha: «Biz «kötürülgen yol» bilen mangimiz, özimiz we mallirimiz süyünglarni ichsek, nerxi boyiche heqqini bérimiz; biz peqet piyade ötüp kétimiz, bashqa héch telipimiz yoq» déwidi, ");
INSERT INTO uiglat_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Édom padishahi: «Yaq. Ötmeysiler!» dédi. Édom padishahi nahayiti köp adimini bashlap chiqip Israillargha zor heywe körsetti. ");
INSERT INTO uiglat_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Shundaq qilip Édomlar Israillarning ularning tewelikidin ötüshige ene shu yosunda yol qoymidi; shuning bilen Israillar Édomlarning aldidin burulup ketti. ");
INSERT INTO uiglat_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ular Qadeshtin yolgha chiqti; pütkül Israil xelqi Hor téghigha keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Perwerdigar Édomning chégrisidiki Hor téghida Musa bilen Harun’gha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Harun öz xelqlirige qoshulup kétidu; ikkinglar Meribah suliri dégen jayda Méning emrimge xilapliq qilghininglar üchün, uning Men Israillargha teqdim qilip bergen zémin’gha kirishige bolmaydu. ");
INSERT INTO uiglat_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Sen Harun bilen oghli Eliazarni élip Hor téghigha chiqqin; ");
INSERT INTO uiglat_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Harunning kiyimlirini saldurup, oghli Eliazargha kiydürüp qoy; Harun shu yerde ölüp, öz xelqlirige qoshulidu. ");
INSERT INTO uiglat_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa Perwerdigarning déginidek qildi, ücheylen pütkül jamaetning köz aldida Hor téghigha chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa Harunning kiyimlirini saldurup uning oghli Eliazargha kiydürüp qoydi; Harun taghning choqqisida öldi. Andin Musa bilen Eliazar taghdin chüshüp keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Pütkül jamaet Harunning ölgenlikini bildi; shuning bilen pütün Israil jemeti Harun üchün ottuz kün matem tutti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Jenubta turushluq Arad memlikitining Qanaaniylardin bolghan padishahi Israillarning Atarim yoli bilen kéliwatqanliqini anglap, chiqip ular bilen soqushup, nechcheylenni tutqun qilip ketti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Andin Israillar Perwerdigargha qesem ichip: «Eger bu xelqni bizning qolimizgha pütünley tapshuridighan bolsang, ularning sheherlirini weyran qilip tashlaymiz» — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Perwerdigar Israillarning peryadini anglap, Qanaanliylarni ularning qoligha tapshurdi, shuning bilen ular Qanaaniylarni ularning sheherliri bilen qoshup weyran qildi; shu sewebtin ular shu yerni «Xormah» dep atidi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ular Hor téghidin yolgha chiqip, Édom zéminini aylinip ötüsh üchün, Qizil Déngiz boyidiki yolni boylap mangdi; xelq mushu yol sewebidin könglide tolimu taqetsiz bolup, ");
INSERT INTO uiglat_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Xudagha we Musagha qarshi chiqip: — Siler néme üchün bizni chöl-jeziride ölsun dep Misir zéminidin bashlap chiqqansiler? Bu yerde ya ashliq, ya su yoq, könglimiz bu erzimes nanlardin bizar boldi, déyishti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Shu sewebtin Perwerdigar ularning arisigha zeherlik yilanlarni ewetti; yilanlar ularni chaqti, shu sewebtin Israillardin nurghun adem ölüp ketti.    ");
INSERT INTO uiglat_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Xelq Musaning aldigha kélip uninggha: — Biz aghzimizni buzup, Perwerdigargha hem sanga hujum qilip, yaman gep qilip gunah qilduq; Perwerdigargha tilawet qilsang, u bu yilanlarni arimizdin élip ketkey, — déwidi, Musa xelq üchün dua qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Perwerdigar Musagha: — Sen bir zeherlik yilanning sheklini yasap xadigha ésip qoyghin; yilan chéqiwalghan herbiri uninggha qarisila qayta hayatqa érishidu, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Musa mistin bir yilan yasitip xadigha ésip qoydi; we shundaq boldiki, yilan birkimni chéqiwalghan bolsa, u bu mis yilan’gha qarisila, ular hayat qaldi.    ");
INSERT INTO uiglat_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israillar yene yolgha chiqip Obotqa kélip chédir tikti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Yene Obottin yolgha chiqip, Moab zéminining udulida kün chiqish tereptiki Iye-Ibarimgha kélip chédir tikti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ular yene u yerdin yolgha chiqip Zered jilghisida chédir tikti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Yene u yerdin méngip Amoriylarning zéminining chétidin chiqip chöl-bayawandin ötüp, éqip turghan Arnon deryasining u qétida chédir tikti (chünki Arnon deryasi Moabiylarning chégrisi bolup, Moabiylar bilen Amoriylarning otturisida idi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","15","Shunga «Perwerdigarning jengnamisi» dégen kitabta: — «Sufahdiki Waheb we derya-wadiliri, Arnon deryasi we jilghilirining yanbaghirliri, Arning turalghusighiche yétip, Moabning chégrisigha chüshidu» dep pütülgenidi). ");
INSERT INTO uiglat_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Israillar yene u yerdin méngip Beerge keldi; «Beer» quduq dégen menide bolup, ilgiri Perwerdigar Musagha: «Sen xelqni yigh, Men ulargha ichidighan su bérey» dégende shu quduqni közde tutqan. ");
INSERT INTO uiglat_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Shu chaghda Israillar munu naxshini éytishqan: — «Ah quduq, chiqsun süyüng bulduqlap, Naxsha éytinglar, quduqqa béghishlap: ");
INSERT INTO uiglat_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Bu quduqni emirler, Xelqning kattiliri qazghan, Qanun chiqarghuchining sözi bilen, Hasiliri bilen qazghan». Israillar chöl-bayawandin yene Mattanahqa, ");
INSERT INTO uiglat_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mattanahtin Nahaliyelge, Nahaliyeldin Bamotqa, ");
INSERT INTO uiglat_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamottin Moab dalasidiki jilghigha, yene chöl-bayawan terepke qarap turghan Pisgah téghining choqqisigha yétip bardi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israillar Amoriylarning padishahi Sihonning aldigha elchilerni ewetip:    ");
INSERT INTO uiglat_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","— Bizning öz zéminliridin ötüwélishimizge ijazet bergeyla; biz silining étizliqlirigha we üzümzarliqlirigha kirmeymiz, quduqliridin sumu ichmeymiz; teweliridin ötüp ketküche «Xan yoli»din chiqmaymiz, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihon Israillarni öz chégrisidin ötkili qoymayla qalmastin, eksiche u Israillar bilen soqushimen dep, özining barliq xelqini yighip chölge qarap atlandi. U Yahazgha kélip Israilgha hujum qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israillar uni qilich bilen chépip öltürüp, uning yurtini Arnon deryasidin Yabbok deryasighiche, yeni Ammoniylarning chégrisighiche igilidi; Ammoniylarning chégrisi bolsa bek mustehkem idi.    ");
INSERT INTO uiglat_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israillar bu yerdiki hemme sheherni igilidi hem Amoriylarning sheherlirige, yeni Heshbon’gha we uninggha tewe barliq yéza-qishlaqlarghimu kirip orunlashti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Chünki Heshbon eslide Amoriylarning padishahi Sihonning merkiziy shehiri idi; Sihon eslide Moabning ilgiriki padishahi bilen soqushqan, uning Arnon deryasighiche bolghan hemme zéminini tartiwalghanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Shu sewebtin shairlar: — «Heshbon’gha kélinglar! Mana Sihonning shehiri yéngiwashtin qurulsun, Sihonning shehiri mehkem qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Chünki Heshbonning özidin chiqti bir ot, Sihonning shehiridin bir yalqun yalqunlap, Yutuwetti Moabtiki Ar shehirini, Arnondiki égiz jaylarning emirlirini. ");
INSERT INTO uiglat_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Way sanga ey Moab! Hey Kémoshning ümmiti, tügeshtinglar! Chünki Kémosh öz oghullirini qachqun’gha aylandurdi, Qizlirini esirlikke bérip, Amoriylarning padishahi Sihon’gha tutup berdi!    ");
INSERT INTO uiglat_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Biz ularni yiqitiwettuq, Heshbon taki Dibon’ghiche halak boldi; Biz hetta Nofahqiche (Nofahtin Medebagha yétidu) ularning yurtini weyran qiliwettuq!» — dep shéir yézishqanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Shuning bilen Israillar ene shu teriqide Amoriylarning yurtigha orunlashti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa Yaazerni charlap kélishke charlighuchilarni ewetti; andin Israillar Yaazerning yéza-qishlaqlirini ishghal qilip, u yerlerdiki Amoriylarni yéridin qoghliwetti. ");
INSERT INTO uiglat_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Shuningdin kéyin Israillar burulup, Bashanning yolini boylap mangdi; Bashanning padishahi Og we uning barliq xelqi chiqip Edreyde Israillar bilen jeng qilishqa sep tüzdi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Perwerdigar Musagha: — Qorqma, Men uni, uning barliq xelqi hem zéminini qolunggha tapshurimen; sen uni ilgiri Heshbonda turushluq Amoriylarning padishahi Sihonni qilghandek qilisen, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Shuning bilen ular Og bilen uning oghullirini hem barliq xelqining birini qoymay qirip tashlidi we uning zéminini igilidi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Israillar yene yolgha chiqip Moab tüzlenglikliride, yeni Iordan deryasining sherq teripide, Yérixoning udulida chédir tikti. ");
INSERT INTO uiglat_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Israillarning Amoriylargha qilghan ishlirining hemmisini Zipporning oghli Balaq körüp turghanidi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moabiylar xelqtin intayin qorqushti, chünki ular bek köp idi; Moabiylar Israillarning sewebidin bek alaqzade bolup kétishti. ");
INSERT INTO uiglat_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moabiylar Midiyan aqsaqallirigha: «Bu bir top adem etrapimizdiki hemme nersini, xuddi kala étizdiki otni yalmighandek yalmap yep kétidighan boldi» — déyishti. U chaghda Zipporning oghli Balaq Moabning padishahi idi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","U elchilerni Béorning oghli Balaamning aldigha, Balaamning ana yurtidiki ulugh derya boyidiki Pétor shehirige bérip, Balaamni chaqirip kélishke ewetip: padishahimiz: — «Qarisila, bir xelq Misirdin chiqqanidi; mana, ular pütün zémin’gha yamrap ketti, mana ular bizning udulimizgha kélip chüshti.    ");
INSERT INTO uiglat_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ular méningdin küchlük bolghachqa, emdi özliri kélip bu xelqni men üchün bir qarghap bergen bolsila; belkim men ularni yéngip, bu zémindin qoghlap chiqirishim mumkin; chünki özliri kimge bext tilisile shuning bext quchidighanliqini, kimni qarghisila, shuning qarghishqa qalidighanliqini bilimen» deydu, denglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moabning aqsaqalliri bilen Midiyanning aqsaqalliri qollirida pal sélish in’amlirini élip mangdi; ular Balaamning aldigha kélip Balaqning geplirini yetküzdi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam ulargha: — Bügün axsham mushu yerde qonup qélinglar, men Perwerdigarning manga qilghan sözi boyiche silerge jawap yetküzimen, — dédi. Shuning bilen Moabning shu emirliri Balaamningkide qonup qaldi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Xuda Balaamningkige kélip: — Séning bilen bille turghan bu ademler kim? — déwidi, ");
INSERT INTO uiglat_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam Xudagha: — Moab padishahi Zipporning oghli Balaq elchilerni ewetip manga: ");
INSERT INTO uiglat_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","«Qarisila, Misirdin bir xelq chiqqanidi, ular pütün zémin’gha yamrap ketti; bu yerge kélip méning üchün ularni qarghap bersile, shundaq qilsila belkim ularni yéngip, bu yerdin qoghliwételishim mumkin» — dédi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Xuda Balaamgha: Sen ular bilen bille barsang bolmaydu, u xelqni qarghisangmu bolmaydu, chünki ulargha bext-beriket ata qilin’ghan, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam etigen turup Balaqning emeldarlirigha: — Siler öz yurtunglargha qaytip kétinglar, chünki Perwerdigar méning siler bilen bille bérishimgha ruxset qilmidi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moabning emeldarliri qopup Balaqning yénigha kélip uninggha: — Balaam biz bilen bille kélishke unimidi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Shuning bilen Balaq téximu köp we téximu mötiwer emeldarlarni ewetti, ");
INSERT INTO uiglat_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ular Balaamning aldigha kélip uninggha: — Zipporning oghli Balaq mundaq deydu: — «Héchnéme silining yénimgha kélishlirini tosmighay; ");
INSERT INTO uiglat_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","chünki men özlirini zor shan-shöhretke ige qilimen; néme désile maqul deymen; shunga manga eshu xelqni qarghap bersilila bolidu», — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam Balaqning xizmetkarlirigha jawaben: — Balaq manga özining altun-kümüshke liq tolghan öz öyini bersimu, meyli chong yaki kichik ish qilay, Xudayim Perwerdigarning manga buyrughanliridin halqip kételmeymen. ");
INSERT INTO uiglat_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Silermu bügün axsham mushu yerde qonup qélinglar, Perwerdigar yene shu ishlar toghrisida manga néme deydikin, shuni biley, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Shu kéchisi Xuda Balaamningkige kélip uninggha: — U kishiler séni teklip qilip kelgen bolsa, ular bilen bille barghin, lékin sen Méning sanga éytidighanlirim boyiche ish qilishing kérek, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam etigen turup éshikini toqup Moabning emirliri bilen bille mangdi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Xuda Balaamning mangghanliqidin ghezeplendi; Perwerdigarning Perishtisi uni tosushqa yolda turatti. U shu chaghda éshikige minip ikki ghulami bilen bille kétiwatatti. ");
INSERT INTO uiglat_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Mada éshek Perwerdigarning Perishtisining qoligha qilich alghan halda yolda turghanliqini körüp, yoldin chiqip étizliq bilen méngiwidi, Balaam éshekni yolgha chiqip méngishqa dumbalap urdi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Perwerdigarning Perishtisi ikki teripi tosma tam bilen tosulghan üzümzarliqtiki tar bir yolda turuwaldi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Éshek Perwerdigarning Perishtisini körüp, tamgha qistilip méngip, Balaamning putini tamgha qistap yarilandurup qoydi; Balaam éshekni yene dumbalidi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Perwerdigarning Perishtisi bolsa yene aldighiraq bérip, ong ya solgha burulushqa bolmaydighan téximu tar bir yerde kütüp turdi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Éshek Perwerdigarning Perishtisini körüp mangmay, Balaamning astida yétiwaldi; Balaam qattiq xapa bolup, éshekni hasisi bilen qattiq dumbalap ketti. ");
INSERT INTO uiglat_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Bu chaghda Perwerdigar éshekke zuwan kirgüzüwidi, éshek Balaamgha: — Méni üch qétim dumbalaydighan’gha sanga néme yamanliq qiptimen? — déwidi, ");
INSERT INTO uiglat_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam éshekke: — Sen méni setleshtürdüng, qolumda qilich bolghan bolsa idi, séni chépip öltürüwétettim! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Éshek Balaamgha: — Men séningki bolghinimdin tartip minip kelgen éshiking men emesmu? Ilgiri men sanga mushundaq qilish aditim bolup baqqanmu? — déwidi, — Yaq, — dédi Balaam. ");
INSERT INTO uiglat_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ene shu chaghda Perwerdigar Balaamning közlirini achti, Balaam Perwerdigarning Perishtisining qilichini ghilipidin chiqirip, yolda turghanliqini kördi; u yerge béshini qoyup sejde qildi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Perwerdigarning Perishtisi uninggha: — Sen éshikingni néme üchün üch qétim dumbalaysen? Qarighina, mangghan yolung Méning nezirimde tetür bolghachqa, séni tosushqa chiqquchi Men Özüm idim. ");
INSERT INTO uiglat_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Éshek Méni körüp üch qétim Méning aldimdin burulup ketti; eger éshek Méning aldimdin burulup ketmigen bolsa, Men alliqachan séni öltürüp éshekni tirik qaldurghan bolattim, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam Perwerdigarning Perishtisige: — Men gunahkarmen, Özlirining yolda méni tosup turghanliqlirini körmeptimen; mubada emdi méning bérishim nezerliride rezil körünse, men qaytip kétey, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Perwerdigarning Perishtisi Balaamgha yene: — Boptu, bu kishiler bilen bille barghin, biraq peqet Men sanga dégen söznila dégin, — dédi. Shuning bilen Balaam Balaqning emeldarliri bilen bille mangdi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaq Balaamni kéliwétiptu dep anglap, qarshi élish üchün Moabning Arnon deryasining boyidiki, chégrining eng béshidiki shehirige keldi: ");
INSERT INTO uiglat_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","— Men silini chaqirishqa shunche jiddiy elchi ewetkenidim, néme üchün kélishke unimidila? Men silini shan-shöhretke ige qilalmayttimmu? — dédi Balaq Balaamgha. ");
INSERT INTO uiglat_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","— Qarisila, mana keldimghu, emdi men öz aldimgha birnéme déyeleyttimmu? — dédi Balaam, — Xuda aghzimgha néme gepni salsa, men shunila deymen. ");
INSERT INTO uiglat_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam Balaq bilen bille yolgha chiqip Kiriat-Xuzotqa keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaq kala, qoylarni soyup qurbanliq qilip, ularning göshidin Balaam we uning bilen bille bolghan emirlerge ewetip berdi. ");
INSERT INTO uiglat_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Andin Balaq etisi seherde Balaamni Baalning égiz jaylirigha élip chiqti; u shu yerdin Israil xelqining eng chettiki bir qismini kördi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam Balaqqa: — Sili mushu yerge manga yette qurban’gah yasitip bersile, mushu yerge yene yette buqa bilen yette qoshqarmu hazirlap bersile, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaq Balaamning déginidek qilip berdi; Balaq bilen Balaam ikkisi herbir qurban’gahqa qurbanliq qilishqa birdin buqa bilen birdin qoshqar sundi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam Balaqqa: — Sili öz köydürme qurbanliqlirining yénida tursila, men aldigha barimen, Perwerdigar méning bilen körüshüshke kélemdikin? U manga néme dep körsetme berse, men özlirige shuni dep bérimen, — dédi we bir döngge chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Xuda Balaam bilen körüshti; Balaam Xudagha: — Men yette qurban’gah hazirlattim, herbir qurban’gahqa qurbanliq süpitide birdin buqa bilen birdin qoshqar sundum, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Perwerdigar Balaamning aghzigha bir sözni sélip: — Balaqning yénigha qaytip bérip uninggha mundaq, mundaq dégin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Shuning bilen u Balaqning yénigha qaytip bardi. Mana, u we Moabning barliq emirliri uning köydürme qurbanliqining yénida turatti. ");
INSERT INTO uiglat_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaam kalam sözini aghzigha élip mundaq dédi: — Balaq méni Aram dégen yurttin, Moab shahi Balaq méni meshriq taghliridin élip kélip, Mundaq dédi: — Kel, méning üchün Yaqupni qarghighin. Kel, Israilni rasa bir söküp eyibligin. ");
INSERT INTO uiglat_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Tengri Özi qarghimighan birawni men qandaq qarghay? Perwerdigar Özi söküp eyiblimigen birawni men qandaq söküp eyibley? ");
INSERT INTO uiglat_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Men qoram tashlarning choqqilirida turup uni körmektimen, Dönglerde turup uninggha nezer salmaqtimen; Mana, ular yekke yashaydighan bir qowm, Ular bashqa qowmlarning qatarida sanalmaydu. ");
INSERT INTO uiglat_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yaqupning topilirini kim hésablap chiqalaydu? Hetta Israilning töttin birinimu kim sanap chiqalaydu? Méning jénim heqqaniyning ölümidek ölsun, Méning axirim uningkidek bolghay! ");
INSERT INTO uiglat_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaq Balaamgha qarap: — Sen manga néme qiliwatisen?! Men séni düshmenlirimni qarghap bérishke chaqiritqan tursam, mana sen eksiche pütünley ulargha amet tiliding! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","— Perwerdigarning aghzimgha salghinini yetküzüshke köngül qoymisam bolamti? — dep jawap berdi Balaam. ");
INSERT INTO uiglat_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaq Balaamgha: — Méning bilen bille bashqa bir yerge barsila, ularni shu yerdin köreleyla; biraq ularning hemmisini emes, ularning chégridiki bir qisminila köreleyla; sili shu yerde turup ularni men üchün qarghap bersile, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Shuning bilen Balaq Balaamni «Zofimning dalasi»gha, Pisgah téghining choqqisigha bashlap bérip, shu yerde yette qurban’gah saldurup, herbir qurban’gahqa qurbanliq süpitide birdin buqa, birdin qoshqar sundi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam Balaqqa: — Sili mushu yerde özlirining köydürme qurbanliqlirining yénida turup tursila, men awu yaqqa bérip körüshüp kéley, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Perwerdigar Balaam bilen körüshüp, uning aghzigha bir sözni sélip: — Sen Balaqning yénigha qaytip uninggha mundaq, mundaq dégin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaam Balaqning yénigha qaytip kelgende, mana, u we Moabning barliq emirliri uning köydürme qurbanliqining yénida turatti. — Perwerdigar néme dédi? — dep soridi Balaq. ");
INSERT INTO uiglat_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaam kalam sözini aghzigha élip mundaq dédi: — «Hey Balaq, sen qopup anglighin, Ah , Zipporning oghli, manga qulaq salghin. ");
INSERT INTO uiglat_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Tengri insan emestur, U yalghan éytmaydu, Yaki adem balisimu emestur, U pushayman qilmaydu. U dégeniken, ishqa ashurmay qalamdu? U söz qilghaniken, wujudqa chiqarmay qalamdu? ");
INSERT INTO uiglat_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Mana, manga «beriketle» dep tapshuruldi, U beriketligeniken, buni men yanduralmaymen. ");
INSERT INTO uiglat_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","U Yaqupta héch gunah körmigen, Israilda naheqliqni uchratmighan. Xudasi Perwerdigar uning bilen bille, Padishahning tentene awazi uning arisididur.    ");
INSERT INTO uiglat_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Tengri uni Misirdin élip chiqqan; Uningda yawa kaliningkidek küch bardur.    ");
INSERT INTO uiglat_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Chünki Yaquplargha epsun kargha kelmeydu, Israillarghimu pal kargha kelmeydu. Waqti-saiti kelgende, Yaqup bilen Israil toghrisida: — «Tengri neqeder karamet ish qilip bergen-he!» Dep jakarlanmay qalmaydu! ");
INSERT INTO uiglat_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Mana, bu qowm chishi shirdek qopidu, Erkek shirdek qeddini ruslaydu; Özi owlighan owni yémigüche, Öltürgenlerning qénini ichmigüche, Hergiz yatmaydu!». ");
INSERT INTO uiglat_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaq Balaamgha: — Boldi, sili ularni azraqmu qarghimisila, ulargha ametmu tilimisile! — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam Balaqqa jawab qilip: — Men silige: — «Perwerdigarning manga éytqanlirining hemmisige emel qilmisam bolmaydu» dégen emesmidim? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaq Balaamgha: — Kelsile, men silini bashqa bir yerge apiray, Xudaning neziride sili shu yerde turup ularni qarghashliri muwapiq tépilarmikin? — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Shuning bilen Balaq Balaamni bashlap, chöl-bayawan’gha qaraydighan Péor téghining choqqisigha keldi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam Balaqqa: — Sili bu yerde manga yette qurban’gah saldurup bersile, yette buqa bilen yette qoshqarmu teyyarlap bersile, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaq Balaamning déginidek qildi, herbir qurban’gahqa birdin buqa bilen birdin qochqar sundi. ");
INSERT INTO uiglat_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaam Perwerdigarning Israillargha bext-beriket ata qilishni muwapiq körgenlikini körüp yétip, aldinqi ikki qétimqidikidek séhir ishlitishke barmidi, belki yüzini chöl-bayawan terepke qaratti. ");
INSERT INTO uiglat_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam béshini kötürüp Israillarning qebile boyiche chédirlarda olturaqlashqanliqini kördi, Xudaning Rohi uning üstige chüshti. ");
INSERT INTO uiglat_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Shuning bilen u aghzigha kalam sözini élip mundaq dédi: — «Béorning oghli Balaam yetküzidighan kalam sözi, Közi échilmighan ademning éytidighan kalam sözi, ");
INSERT INTO uiglat_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Yeni Tengrining sözlirini anglighuchi, Hemmige Qadirning alamet körünüshini körgüchi, Mana emdi közi échilip düm yiqilghan kishi yetküzgen kalam sözi: — ");
INSERT INTO uiglat_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ah Yaqup, chédirliring neqeder güzel, Turalghuliring neqeder güzel, ah Israil! ");
INSERT INTO uiglat_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Goya kéngeygen derya wadiliridek, Xuddi derya boyidiki baghlardek, Goya Perwerdigar tikip östürgen ud derexliridek, Derya boyidiki kédir derexliridek; ");
INSERT INTO uiglat_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Sular uning soghiliridin éqip chiqidu, Ewladliri süyi mol jaylarda bolidu; Padishahi Gogdin éship kétidu, Uning padishahliqi üstün qilinip güllinidu.    ");
INSERT INTO uiglat_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Tengri uni Misirdin élip chiqqan, Uningda yawa buqining küchi bardur; Düshmen ellerni u yep kétidu, Ustixanlirini ézip tashlaydu, Oqya étip ularni téship tashlaydu. ");
INSERT INTO uiglat_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","U baghirlap yatsa, erkek shirdek, Yatsa hem chishi shirdek, Kim uni qozghitishqa pétinar? Kim sanga bext-beriket tilise, bext-beriket tapidu. Kim séni qarghisa, qarghishqa kétidu». ");
INSERT INTO uiglat_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaq Balaamgha achchiqlinip, qolini qoligha urup ketti; Balaq Balaamgha: — Men silini düshminimni qarghap bérishke qichqirtqanidim we mana, sili üch qétim pütünley ulargha amet tilidile! ");
INSERT INTO uiglat_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Emdi tézdin yurtlirigha qéchip ketsile; men eslide silining izzet-hörmetlirini katta qilay dégenidim, mana Perwerdigar silini bu katta izzet-hörmetke nail bolushtin tosup qoydi, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam Balaqqa: — Men eslide özlirining elchilirige: ");
INSERT INTO uiglat_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","«Balaq manga özining altun-kümüshke liq tolghan öz öyini bersimu, Perwerdigarning buyrughinidin halqip, öz meylimche yaxshi-yaman ish qilalmaymen; Perwerdigar manga néme dése, men shuni deymen» dégen emesmidim? ");
INSERT INTO uiglat_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Emdi men öz xelqimge qaytimen; kelsile, men özlirige bu xelqning künlerning axirida silining xelqlirige qandaq muamile qilidighanliqini éytip bérey, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","U kalam sözini aghzigha élip mundaq dédi: — Béorning oghli Balaam yetküzidighan kalam sözi, Közliri échilmighan kishi éytqan kalam sözi, ");
INSERT INTO uiglat_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Tengrining sözlirini anglighuchi, Hemmidin Aliyning wehiylirini bilgüchi, Hemmige Qadirning alamet körünüshini körgüchi, Mana emdi közi échilghan düm yiqilighan kishi yetküzidighan kalam sözi: — ");
INSERT INTO uiglat_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Men Uni körimen, lékin hazir emes; Men Uninggha qaraymen, lékin yéqin yerdin emes; Yaquptin chiqar bir yultuz, Kötürüler Israildin bir shahane hasa; Chéqiwéter u Moabning chékisini, Barliq Shétlerning béshini yanjiydu.    ");
INSERT INTO uiglat_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Édom uninggha tewe bolidu, Yene téxi düshmini Séirlar uninggha tewe bolidu; Israil bolsa baturluq qilidu. ");
INSERT INTO uiglat_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yaquptin chiqqan biri seltenet süridu, Sheherde qalghan hemmeylenni yoqitidu».    ");
INSERT INTO uiglat_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Andin Balaam Amalekni körüp, mundaq kalam sözini éytti: — «Amalek idi esli eller arisida bash, Emdi halakettur teqdir-qismiti». ");
INSERT INTO uiglat_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Andin Balaam Kéniylerni körüp mundaq kalam sözini éytti: — «Séning makaning mustehkem bolup, Changgang qoram tash ichide bolsimu, ");
INSERT INTO uiglat_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Lékin siler Kéniyler halak qilinip turisiler; Taki Ashur silerni tutqun qilip ketküche». ");
INSERT INTO uiglat_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaam yene kalam sözini dawam qilip mundaq dédi: — «Ah , Tengri bu ishlarni qilghan chéghida, Kim tirik qélishqa qadir bolar? ");
INSERT INTO uiglat_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kittim terepliridin kémiler kélip, Zulum-zexmet salidu Ashurgha, Zulum-zexmet salidu Éberge; Lékin Kittimdin kelgüchi özimu halaketke yüzliner». ");
INSERT INTO uiglat_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Shuning bilen Balaam ornidin qopup öz yurtigha qaytti; Balaqmu öz yoligha mangdi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israillar Shittimda turghan mezgilde, xelq Moab qizliri bilen buzuqluq qilishqa bérilip ketti. ");
INSERT INTO uiglat_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","U qizlar Israillarni öz ilahlirigha atalghan qurbanliqlargha qatnishishqa chaqirdi; Israillarmu qurbanliqlardin yeydighan, ularning ilahlirigha birlikte choqunidighan boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israillar Baal-Péor bilen ene shu teriqide baghlinip ketkenliki üchün, Perwerdigarning Israillargha achchiqi qozghaldi.    ");
INSERT INTO uiglat_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Perwerdigar Musagha: — Perwerdigarning qattiq ghezipi Israillargha chüshmisun üchün, xelqning emirlirining hemmisini tutup, ularni Méning aldimda aptapta ésip qoyghin, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Shuning bilen Musa Israilning soraqchilirigha: — Siler bérip herbiringlar özünglarning Baal-Péor bilen baghlinip ketken ademlirini öltürüwétinglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","We Musa pütkül Israil jamaiti bilen jamaet chédirining derwazisi aldida yigha-zar qilip turuwatqanda, mana Israillardin bireylen kélip ularning köz aldidila Midiyaniy bir qizni öz qérindashlirining yénigha élip mangdi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kahin Harunning newrisi, Eliazarning oghli Finihas buni körüp, jamaet ichidin qopti-de, qoligha neyze élip, ");
INSERT INTO uiglat_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","héliqi Israil ademning arqisidin chédirning ichkirige kirip, qiz bilen ikkisining qarnigha neyze tiqiwetti. Israillar arisida tarqalghan waba ene shu chaghdila toxtidi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Shu chaghda waba tégip ölgenler jemiy yigirme töt ming ademge yetkenidi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Andin Perwerdigar Musagha mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","— «Kahin Harunning newrisi, Eliazarning oghli Finihas Méni dep wapasizliqqa bolghan hesitimni öz hesiti bilip, Méning Israillargha bolghan ghezipimni yandurdi. Shunga gerche Men wapasizliqqa bolghan hesitimdin ghezeplen’gen bolsammu, Israillarni yoqitiwetmidim. ");
INSERT INTO uiglat_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Shunga sen: — «Mana, Men uninggha öz aman-xatirjemlik ehdemni teqdim qilimen! ");
INSERT INTO uiglat_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Bu ehde uninggha we uning ewladlirigha tewe bolidighan menggülük kahinliq ehdisi bolidu, chünki u öz Xudasini dep wapasizliqqa heset qilip, Israillar üchün kefarǝt keltürdi» — dep jakarlighin». ");
INSERT INTO uiglat_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Öltürülgen yeni héliqi Midiyaniy qiz bilen bille öltürülgen Israil ademning ismi Zimri bolup, Saluning oghli, Shiméon qebilisidiki bir jemetning emiri idi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Öltürülgen Midiyaniy qizning ismi Kozbi bolup, Zurning qizi idi; Zur bolsa Midiyaniy bir qebilining bashliqi idi. ");
INSERT INTO uiglat_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Perwerdigar Musagha: — ");
INSERT INTO uiglat_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Sen Midiyaniylargha aram bermey zerbe bergin; ");
INSERT INTO uiglat_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","19","Chünki ular hiyle-mikir ishlitip silerge aram bermigen; Péordiki ishta, shundaqla ularning singlisi bolghan Midiyanning bir emirining qizi Kozbining ishidimu hiyle-mikir ishlitip silerni azdurghan, — dédi. Kozbi waba tarqalghan künide Péordiki ish sewebidin öltürüldi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Wabadin kéyin Perwerdigar Musa bilen Harunning oghli Eliazargha söz qilip: — ");
INSERT INTO uiglat_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Siler pütkül Israillarning jamaiti ichide yigirme yashtin ashqan, jengge chiqalaydighanlarni ata jemeti boyiche hésablap sanaqtin ötküzünglar, — dédi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Shuning bilen Musa bilen kahin Eliazar Moab tüzlenglikliride, yeni Yérixoning yénidiki Iordan deryasining boyida Israillar bilen sözliship ulargha: ");
INSERT INTO uiglat_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Perwerdigarning Musa we Misirdin chiqqan Israillargha buyrughini boyiche, silerdin yigirme yashtin ashqanlarning hemmisi tizimlinip sanaqtin ötküzülüshi kérek» dep uqturdi. Tizimlitilghan sanlar mundaq boldi: —    ");
INSERT INTO uiglat_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Israilning tunji oghli Ruben idi. Rubenning ewladliri, yeni Hanuqning neslidin bolghan Hanuq jemeti; Palluning neslidin bolghan Pallu jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron neslidin bolghan Hezron jemeti; Karmi neslidin bolghan Karmi jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Bular Rubenning jemetliri bolup, ulardin sanaqtin ötküzülgini jemiy qiriq üch ming yette yüz ottuz kishi boldi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palluning oghli Éliab; ");
INSERT INTO uiglat_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Éliabning oghulliri Nimuel, Datan, Abiram idi. Datan bilen Abiram eslide jamaet ichidin chaqirilghan mötiwerler bolsimu, Korah guruhidikiler Perwerdigar bilen takallashqanda, ular bilen birliship Musa we Harun bilen takallashqanidi.    ");
INSERT INTO uiglat_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Yer aghzini échip ularni Korah bilen birge yutup ketken; shu chaghda Korah guruhidikilerning hemmisi ölgen; bashqilargha ibret bolsun dep, ot uning ikki yüz ellik adimini yutup ketken. ");
INSERT INTO uiglat_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Lékin Korahning ewladliri ölüp ketmigen. ");
INSERT INTO uiglat_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Shiméonning ewladliri, jemet boyiche, Nemuelning neslidin bolghan Nemuel jemeti; Yamin neslidin bolghan Yamin jemeti; Yaqin neslidin bolghan Yaqin jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerah neslidin bolghan Zerah jemeti; Saul neslidin bolghan Saul jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Bular Shiméonning jemetliri bolup, jemiy yigirme ikki ming ikki yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad qebilisidin, jemet boyiche, Zefon neslidin bolghan Zefon jemeti; Haggi neslidin bolghan Haggi jemeti; shuni neslidin bolghan shuni jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni neslidin bolghan Ozni jemeti; éri neslidin bolghan éri jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod neslidin bolghan Arod jemeti; Areli neslidin bolghan Areli jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Bular Gad ewladlirining jemetliri bolup, ular jemetliri boyiche sanaqtin ötküzülgende jemiy qiriq ming besh yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yehudaning oghulliri Ér bilen Onan idi; bu ikkisi Qanaan zéminida ölüp ketken. ");
INSERT INTO uiglat_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yehudaning ewladliri, jemeti boyiche, Shilahning neslidin bolghan Shilah jemeti; Perezning neslidin bolghan Perez jemeti; Zerahning neslidin bolghan Zerah jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Perezning ewladliri Hezronning neslidin bolghan Hezron jemeti; Hamulning neslidin bolghan Hamul jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Bular Yehudaning jemetliri bolup, ular jemet boyiche sanaqtin ötküzülgende jemiy yetmish alte ming besh yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Issakarning ewladliri, jemet boyiche, Tolaning neslidin bolghan Tola jemeti; Puahning neslidin bolghan Puah jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yashubning neslidin bolghan Yashub jemeti; Shimronning neslidin bolghan Shimron jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Bular Issakarning jemetliri bolup, ular jemet boyiche sanaqtin ötküzülgende jemiy atmish töt ming üch yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zebulunning ewladliri, jemeti boyiche, Seredning neslidin bolghan Sered jemeti; Élon neslidin bolghan Élon jemeti; Jahliyelning neslidin bolghan Jahliyel jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Bular Zebulunning jemetliri bolup, ular jemet boyiche sanaqtin ötküzülgende jemiy atmish ming besh yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yüsüpning oghulliri: — jemet boyiche, Manasseh bilen Efraim idi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manassehning ewladliri: — Makirning neslidin bolghan Makir jemeti (Makirdin Giléad törelgen), Giléadning neslidin bolghan Giléad jemeti idi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Töwendikiler Giléadning ewladliri: — Yeezerning neslidin bolghan Yeezer jemeti; Helekning neslidin bolghan Helek jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriyelning neslidin bolghan Asriyel jemeti; Shekemning neslidin bolghan Shekem jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemidaning neslidin bolghan Shemida jemeti; Heferning neslidin bolghan Hefer jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Heferning oghli Zelofihad oghul perzent körmey qiz perzent körgen; Zelofihadning qizlirining ismi Mahlah, Noah, Hoglah, Milkah, Tirzah idi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Bular Manassehning jemetliri bolup, sanaqtin ötküzülgende jemiy ellik ikki ming yette yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Töwendikiler Efraimning ewladliri, jemeti boyiche: — Shutilahning neslidin bolghan Shutilah jemeti; Bekerning neslidin bolghan Beker jemeti; Tahanning neslidin bolghan Tahan jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shutilaning ewladliri Éranning neslidin bolghan Éran jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Mana bular Efraim ewladlirining jemetliri bolup, herqaysi jemetler boyiche sanaqtin ötküzülgende jemiy ottuz ikki ming besh yüz adem chiqti. Jemetliri boyiche, ularning hemmisi Yüsüpning ewladliri idi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Binyaminning ewladliri, jemeti boyiche, Bélaning neslidin bolghan Béla jemeti; Ashbelning neslidin bolghan Ashbel jemeti; Ahiramning neslidin bolghan Ahiram jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shefufamning neslidin bolghan Shufam jemeti; Hufamning neslidin bolghan Hufam jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ard bilen Naaman Bélaning oghulliri idi; Ardning neslidin bolghan Ard jemeti; Naamanning neslidin bolghan Naaman jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Bular Binyaminning ewladliri bolup, jemet boyiche sanaqtin ötküzülgende jemiy qiriq besh ming alte yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Töwendikiler Danning ewladliri bolup, jemet boyiche, Shuhamning neslidin bolghan Shuham jemeti; jemet boyiche bular Danning jemetliri idi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Shuhamning hemme jemeti sanaqtin ötküzülgende jemiy atmish töt ming töt yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ashirning ewladliri, jemet boyiche, Yimnahning neslidin bolghan Yimnah jemeti; Yishwining neslidin bolghan Yishwi jemeti; Bériyahning neslidin bolghan Bériyah jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Bériyahning ewladliri, jemet boyiche, Heberning neslidin bolghan Heber jemeti; Malkielning neslidin bolghan Malkiel jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ashirning qizining ismi Sérah idi. ");
INSERT INTO uiglat_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Bular Ashir ewladlirining jemetliri bolup, ular jemet boyiche sanaqtin ötküzülgende jemiy ellik üch ming töt yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naftalining ewladliri, jemet boyiche, Yahzielning neslidin bolghan Yahziel jemeti; Gunining neslidin bolghan Guni jemeti; ");
INSERT INTO uiglat_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yezerning neslidin bolghan Yezer jemeti; Shillemning neslidin bolghan Shillem jemeti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Bular Naftalining jemetliri bolup, jemet boyiche sanaqtin ötküzülgende jemiy qiriq besh ming töt yüz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Yuqiriqilar Israillardin sanaqtin ötküzülgenler bolup, jemiy alte yüz bir ming yette yüz ottuz adem chiqti. ");
INSERT INTO uiglat_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Perwerdigar Musagha söz qilip mundaq dédi: — ");
INSERT INTO uiglat_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Zémin mushulargha royxetke élin’ghan san boyiche miras qilip teqsim qilinsun. ");
INSERT INTO uiglat_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Mirasni adem sani köp qebililerge köprek, adem sani az qebililerge azraq böl; miras royxettin ötküzülgen adem sanigha qarap herbir ademge bölüp bérilsun. ");
INSERT INTO uiglat_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Halbuki, zémin chek tashlinish yoli bilen bölünsun; ular mirasqa özlirining ata jemet-qebilisining nami boyiche warisliq qilsun. ");
INSERT INTO uiglat_vpl 