﻿USE sofia;
DROP TABLE IF EXISTS sofia.uigcyr_vpl;
CREATE TABLE uigcyr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uigcyr_vpl WRITE;
INSERT INTO uigcyr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Муқәддәмдә Худа асманлар билән зиминни яратти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","У чағда йәр болса шәкилсиз вә қупқуруқ һаләттә болди; қараңғулуқ чоңқур суларниң йүзини қаплиди; Худаниң Роһи чоңқур сулар үстидә ләрзан пәрваз қилатти. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Худа: «Йоруқлуқ болсун!» девиди, йоруқлуқ пәйда болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Худа йоруқлуқниң яхши екәнлигини көрди; Худа йоруқлуқ билән қараңғулуқни айриди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Худа йоруқлуқни «күндүз», қараңғулуқни «кечә» дәп атиди. Шу тәриқидә кәч билән сәһәр өтти, бу тунҗа күн болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Андин Худа: — Суларниң арилиғида бир бошлуқ болсун вә сулар жуқури-төвән иккигә айрилип турсун, деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Шуниң билән Худа бир бошлуқ һасил қилип, суларни бошлуқниң астиға вә бошлуқниң үстигә айривәтти; иш әнә шундақ болди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Худа бу бошлуқни «асман» дәп атиди. Шу тәриқидә кәч билән сәһәр өтти, бу иккинчи күн болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Андин Худа: «Асманниң астидики сулар бир йәргә жиғилсун, қуруқ тупрақ көрүнсун!» девиди, дәл шундақ болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Худа қуруқ тупрақни «йәр», жиғилған суларни болса «деңизлар» дәп атиди. Худа буларниң яхши болғанлиғини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Андин Худа йәнә: «Йәр һәр хил өсүмлүкләрни, уруқлуқ отяшларни, мевә беридиған дәрәқләрни түрлири бойичә өзидә үндүрсун! Мевиләрниң ичидә уруқлири болсун!» девиди, дәл шундақ болди; ");
INSERT INTO uigcyr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","йәрдики өсүмлүкләрни, йәни уруқ чиқидиған отяшларни өз түрлири бойичә, мевә беридиған, йәни мевилириниң ичидә уруқлири болған дәрәқләрни өз түрлири бойичә үндүрди. Худа буларниң яхши болғанлиғини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Шу тәриқидә кәч билән сәһәр өтти, бу үчинчи күн болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Худа йәнә: «Күндүз билән кечини айрип бериш үчүн асманларда йоруқлуқ җисимлар болсун. Улар күнләр, пәсиллар вә жилларни айрип турушқа бәлгү болсун; ");
INSERT INTO uigcyr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","улар асманларда туруп нур чиқарғучи болуп, йәр йүзигә йоруқлуқ бәрсун!» девиди, дәл шундақ болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Худа икки чоң нур чиқарғучи җисимни яратти; чоң нур чиқарғучини күндүзни башқуридиған, кичик нур чиқарғучни кечини башқуридиған қилди. Һәмдә йәнә юлтузларниму яратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Худа буларни йәргә йоруқлуқ берип, күндүз билән кечини башқуруп, йоруқлуқ билән қараңғулуқни айрисун дәп асманларниң гүмбизигә орунлаштурди. Худа буниң яхши болғанлиғини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Шу тәриқидә кәч билән сәһәр өтти, бу төртинчи күн болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Худа йәнә: «Суларда миғ-миғ җаниварлар болсун, учар-қанатлар йәрниң үстидә, асман бошлуғида учсун» деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Шундақ қилип Худа судики чоң-чоң мәхлуқларни, шундақла суларда миғ-миғ җаниварларни өз түрлири бойичә вә һәр хил учар-қанатларни өз түрлири бойичә яратти. Худа буниң яхши болғанлиғини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Худа бу җанлиқларға бәхит-бәрикәт ата қилип: «Нәсиллинип, көпийип, деңиз сулирини толдуруңлар, учар-қанатларму йәр йүзидә көпәйсун» деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Шу тәриқидә кәч билән сәһәр өтти, бу бәшинчи күн болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Худа йәнә: «Йәр җаниварларни өз түрлири бойичә чиқарсун — мал-чарвиларни, өмилигүчи җаниварларни вә явайи һайванларни өз түрлири бойичә апиридә қилсун» — девиди, дәл шундақ болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Шундақ қилип Худа йәрдики явайи һайванларни өз түрлири бойичә, мал-чарвиларни өз түрлири бойичә вә йәр йүзидә өмилигүчи барлиқ җаниварларни өз түрлири бойичә яратти. Худа буниң яхши болғанлиғини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Андин Худа: «Өз сүрәт-образимизда, Бизгә охшайдиған қилип инсанни яритайли. Улар деңиздики белиқларға, асмандики учар-қанатларға, барлиқ мал-чарвиларға, пүткүл йәр йүзигә вә йәр йүзидики барлиқ өмилигүчи җаниварларға егидарчилиқ қилсун» деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Шундақ қилип, Худа инсанни Өз сүрәт-образида яратти; Уни Өзиниң сүритидә яратти; Уларни әркәк-чиши қилип яратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Худа уларға бәхит-бәрикәт ата қилип: «Силәр нәсиллинип, көпийип, йәр йүзини толдуруп бойсундуруңлар; деңиздики белиқлар, асмандики учар-қанатларға, шуниңдәк йәр йүзидә жүридиған һәр бир һайванларға егидарчилиқ қилиңлар» деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Андин Худа йәнә: «Мана, Мән пүткүл йәр йүзидики уруқлуқ отяшлар билән уруқлуқ мевә беридиған һәр бир дәрәқләрни силәргә озуқлуқ болсун дәп бәрдим; ");
INSERT INTO uigcyr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","шундақла йәрдики барлиқ җаниварлар билән асмандики барлиқ учар-қанатлар вә йәр йүзидә барлиқ өмилигүчиләргә, йәни барлиқ җан-җаниварларға озуқлуқ болсун дәп барлиқ гүл-гияларни бәрдим» девиди, дәл шундақ болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Худа яратқанлириниң һәммисигә сәпселип қариди, вә мана буларниң һәммиси наһайити яхши болған еди. Шу тәриқидә кәч билән сәһәр өтти, бу алтинчи күн болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Шундақ қилип асман билән зимин, пүткүл мәвҗудатлири билән қошулуп яритилип болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Худа йәттинчи күнигичә қилидиған ишини тамамлиди. У йәттинчи күни барлиқ яритиш ишини тохтитип арам алди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Йәттинчи күни Худа барлиқ яритиш ишлиридин арам алған күн болғанлиғи үчүн, шу күнни бәхитлик күн қилип, уни «муқәддәс күн» дәп бекитти. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Пәрвәрдигар Худа зимин билән асманни яратқан күнидә, асман-зиминниң яритилиш җәряниниң тарихлири мундақ: — ");
INSERT INTO uigcyr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Зиминда техи һеч гүл-гия, йәрдә һеч отяш үнмигән еди; чүнки Пәрвәрдигар Худа йәр йүзигә һөл-йеғин яғдурмиған еди, шундақла йәр терийдиған адәмму йоқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Лекин йәрдин булақ сүйи чиқип, тамам йәр йүзини суғарди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Андин Пәрвәрдигар Худа адәмни йәрниң тописидин ясап, һаятлиқ нәпәсини униң бурниға пүвлиди; шуниң билән адәм тирик бир җан болди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Андин кейин Пәрвәрдигар Худа мәшриқ тәрәптә Ерәм дегән җайда бир бағ бена қилип, ясиған адәмни шу йәргә орунлаштурди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Пәрвәрдигар Худа йәрдин көзни қамлаштуридиған чирайлиқ, мевилири йейишлик һәр хил дәрәқни үндүрди; у йәнә бағниң оттурисида «һаятлиқ дәриғи» вә «яхши билән яманни билгүзгүчи дәрәқ»ни үндүрди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Бағни суғиришқа Ерәмдин бир дәрия еқип чиқти; андин бөлүнүп, төрт еқин болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Биринчи еқинниң нами Пишон болуп, алтун чиқидиған пүткүл Һавилаһ зиминини айлинип өтиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Бу жутниң алтуни наһайити есил еди; шу йәрдә пурақлиқ девирқай билән ақ һеқиқму чиқиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Иккинчи дәрияниң нами Гиһон болуп, пүткүл Куш зиминини айлинип өтиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Үчинчи дәрияниң нами Диҗлә болуп, Ашурниң шәрқидин еқип өтиду, төртинчи дәрияниң нами Әфрат еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Пәрвәрдигар Худа адәмни елип Ерәм беғиға ишләп, пәрвиш қилсун дәп уни шу йәргә қоюп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Пәрвәрдигар Худа адәмгә әмир қилип: бағдики һәр бир дәрәқ мевилиридин халиқиниңчә йә; ");
INSERT INTO uigcyr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","амма «яхши билән яманни билгүзгүчи дәрәқ»ниң мевисидин йемигин; чүнки униңдин йегән күнүңдә җәзмән өлисән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Андин Пәрвәрдигар Худа йәнә сөз қилип: — Адәмниң ялғуз туруши яхши әмәс; Мән униңға мас келидиған бир ярдәмчи һәмраһни ясап берәй, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Пәрвәрдигар Худа тупрақтин даладики барлиқ җаниварлар билән асмандики һәммә учар-қанатларни ясиған еди; уларға адәмниң немә дәп ат қойидиғанлиғини билиш үчүн, У уларни адәмниң алдиға кәлтүрди. Адәм һәр бир җаниварға немә дәп ат қойған болса, униң ети шу болуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Бу тәриқидә адәм һәммә мал-чарвиларға, асмандики учар-қанатларға вә даладики һәр бир җаниварларға ат қойди; вәһаләнки, адәм өзигә мас келидиған һеч бир ярдәмчи һәмраһ учратмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Шуниң билән Пәрвәрдигар Худа адәмгә бир қаттиқ уйқа салди; у ухлап қалди. У ухлаватқанда, У униң биқинидин бир аз елип, андин униң орнини әт-гөш билән етип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Шуниң билән Пәрвәрдигар Худа адәмниң биқинидин алған шу қисимдин бир аялни ясап, уни адәмниң қешиға әкәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Адәм ата хошал болуп: — Мана бу сүйәклиримдики сүйәк, етимдики әт болғач, «аял» дәп аталсун; чүнки у әрдин елинғандур, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Шуниң үчүн әр киши ата-анисидин айрилип, өз аялиға бағлинип бир болуп, иккиси бир тән болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Адәм ата билән аяли һәр иккиси ялаңач болсиму, һеч уялмайтти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Йәр йүзидә илан Рәб Пәрвәрдигар яратқан даладики һайванларниң һәммисидин һейлигәр еди. У аялдин: — Худа растинла бағдики дәрәқләрниң һеч қайсисиниң мевисидин йемәңлар, дедиму? — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Аял иланға җавап берип: — Бағдики дәрәқләрниң мевилирини йесәк болиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Амма бағниң оттурисидики дәрәқниң мевиси тоғрисида Худа: «Буниңдин йемәңлар, қолму тәккүзмәңлар, болмиса өлисиләр» дегән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Илан аялға: — Ундақ әмәс! Һәргиз өлмәйсиләр! ");
INSERT INTO uigcyr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Бәлки силәр уни йегән күнүңларда, Худа көзүңларниң ечилип, Худаға охшаш яхши билән яманни билидиған болуп қалидиғанлиғиңларни билиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Аял дәрәқниң мевисиниң йемәклик үчүн яхшилиғини, униң көзни қамлаштуридиғанлиғини көрүп, һәмдә дәрәқниң адәмни әқиллиқ қилидиған җәлипкарлиғини көрүп, мевидин йеди вә униңдин йенида турған еригиму бәрди; уму йеди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Йейиши биләнла һәр иккисиниң көзлири ечилип, өзлириниң ялаңач екәнлигини билип, әнҗир йопурмақлирини елип бир-биригә улап тикип, өзлиригә япқуч қилип тартти. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Күн салқинлиғанда, улар Пәрвәрдигар Худаниң бағда маңған шәписини аңлап қелип, адәм аяли билән Пәрвәрдигар Худаниң һазир болғинидин қечип бағдики дәрәқләрниң арисиға йошурунувалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Лекин Пәрвәрдигар Худа товлап адәмни чақирип униңға: Сән нәдә? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Адәм ата җавап берип: — Мән бағда шәпәңни аңлап, ялаңач турғиним үчүн қорқуп кетип, йошурунувалдим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Худа униңға: — Ялаңач екәнлигиңни саңа ким ейтти? Мән саңа йемә, дәп әмир қилған дәрәқниң мевисидин йедиңму-я? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Адәм җавап берип: — Сән маңа һәмраһ болушқа бәргән аял дәрәқниң мевисидин маңа бәргән еди, мән йедим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Пәрвәрдигар Худа аялға: — Бу немә қилғиниң? — деди. Аял җавап берип: — Илан мени алдап аздурса, мән йәп саптимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Пәрвәрдигар Худа иланға мундақ деди: — «Бу қилғиниң үчүн, Сән һәммә мал-чарвилардин, Даладики барлиқ һайванатлардин бәкрәк ләнәткә қалисән; Қосиғиң билән беғирлап меңип, Өмрүңниң барлиқ күнлиридә топа йәйсән. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Вә мән сән билән аялниң арисиға, Сениң нәслиң билән аялниң нәслиниң арисиға өчмәнлик салимән; У сениң бешиңни дәссәп зәхимләндүриду, Сән қопуп униң тапинини чеқип зәхимләндүрисән».    ");
INSERT INTO uigcyr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Андин Худа аялға: — «Сениң һамилдарлиғиңниң җапа-мушәққәтлирини көпәйтимән; Сән қаттиқ толғақ ичидә бошинисән; Сән ериңдин үстүн турушқа һәвәс қилсаңму, У үстүңдин ғоҗилиқ қилиду» — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Андин У Адәм атиға: — «Сән аялиңниң сөзигә қулақ селип, Мән саңа йемә, дәп әмир қилған дәрәқтин йегиниң түпәйлидин, Сениң түпәйлиңдин йәр-тупрақ ләнитимгә учрайду; Өмрүңниң барлиқ күнлиридә пәқәт җапалиқ ишләпла, андин униңдин озуқлинисән. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Йәр саңа тикән билән қамғақ үндүриду; Шундақтиму сән йәрдики зираәт-отяшларни йәйсән. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Таки сән тупраққа қайтқичә йүз-көзүң тәргә чүмгәндә, андин нан йейәләйсән; Чүнки сән әсли тупрақтин елинғансән; Сән әслидә топа болғач, Йәнә топиға қайтисән» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Униң аяли барлиқ җан егилириниң аниси болидиғини үчүн адәм униңға «Һава» дәп ат қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Пәрвәрдигар Худа Адәм ата билән униң аялиға һайван терилиридин кийим қилип кийдүрүп қойди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Пәрвәрдигар Худа сөз қилип: — Мана, адәм Бизләрдин биригә охшап қалди, яхши билән яманни билди. Әнди қолини узитип һаятлиқ дәриғидин елип йәвелип, та әбәткичә яшавәрмәслиги үчүн уни тосушимиз керәк, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Шуниң билән Пәрвәрдигар Худа уни Ерәм бағдин қоғлап чиқиривәтти; шундақ қилип уни йәргә ишләйдиған, йәни өзи әсли апиридә қилинған тупраққа ишләйдиған қилип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Адәмни қоғливетип, һаятлиқ дәриғигә баридиған йолни муһапизәт қилиш үчүн, у Ерәм беғиниң мәшриқ тәрипигә керубларни вә төрт тәрәпкә пирқирайдиған ялқунлуқ бир шәмшәрни қоюп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Адәм ата аяли Һава билән биллә болди; Һава һамилдар болуп Қабилни туғуп: «Мән бир адәмгә егә болдум — У Пәрвәрдигардур!» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Андин у йәнә Қабилниң иниси Һабилни туғди. Һабил падичи болди, Қабил болса териқчи болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Бекитилгән шундақ бир вақит-сааттә шундақ бир иш болдики, Қабил тупрақниң һосулидин Пәрвәрдигарға һәдийә кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Һабилму падисидин қойлириниң тунҗилиридин, йәни уларниң йеғидин һәдийә сунди. Пәрвәрдигар Һабилни вә униң сунған һәдийәсини қобул қилди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Лекин Қабил вә униң сунғиниға қаримиди. Шу вәҗидин Қабилниң толиму аччиғи келип, чирайи тутулди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Шуниң билән Пәрвәрдигар Қабилға: Немишкә аччиқлинисән? Немә үчүн чирайиң тутулуп кетиду? ");
INSERT INTO uigcyr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Әгәр дурус иш қилсаң, сән көтирилмәмсән? Лекин дурус иш қилмисаң, мана гуна ишик алдида сени пайлап беғирлап ятиду, у сени өз илкигә алмақчи болиду; лекин сән униңдин ғалип келишиң керәк, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Қабил иниси Һабилға: «Далиға чиқип келәйли!» деди. Далада шу вақиә болдики, Қабил иниси Һабилға қол селип, уни өлтүрди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Пәрвәрдигар Қабилға: Иниң Һабил нәдә? — дәп сориди. У җавап берип: Билмәймән, мән инимниң баққучисиму? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Худа униңға: — Сән немә қилдиң? Мана, иниңниң қени йәрдин маңа пәряд көтириватиду! ");
INSERT INTO uigcyr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Әнди иниңниң қолуңда төкүлгән қенини қобул қилишқа ағзини ачқан йәрдин қоғлинип, ләнәткә учрайсән. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Сән йәргә ишлисәңму у буниңдин кейин саңа қуввитини бәрмәйду; сән йәр йүзидә сәрсан болуп, сәргәрдан болисән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Буни аңлап Қабил Пәрвәрдигарға җавап қилип: — Мениң бу җазайимни адәм көтирәлмигидәк! ");
INSERT INTO uigcyr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Мана, Сән бүгүн мени йәр йүзидин қоғлидиң, мән әнди Сениң йүзүңдин йошурунуп жүримән; йәр йүзидә сәрсән болуп сәргәрданлиқта жүримән; шундақ болидуки, кимла мени тепивалса, өлтүрүветиду!, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Лекин Пәрвәрдигар униңға җавап берип: — Шундақ болидуки, кимки Қабилни өлтүрсә, униңдин йәттә һәссә интиқам елиниду, — деди. Шуларни дәп Пәрвәрдигар Қабилға учриған бириси уни өлтүрүвәтмисун дәп униңға бир бәлгү қоюп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Шуниң билән Қабил Пәрвәрдигарниң һозуридин чиқип, Ерәмниң мәшриқ тәрипидики Нод дегән жутта олтирақлишип қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Қабил аяли билән биллә болуп, аяли һамилдар болуп Һанохни туғди. У вақитта Қабил бир шәһәр бена қиливататти; у шәһәрниң намини оғлиниң исми билән Һанох дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Һанохтин Ирад төрәлди, Ирадтин Мәһуяил төрәлди, Мәһуяилдин Мәтушаил төрәлди, Мәтушаилдин Ләмәх төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ләмәх өзигә икки хотун алди. Бириниң исми Адаһ, йәнә бириниң исми Зиллаһ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Адаһ Ябални туғди. У чедирда олтиридиған көчмән малчиларниң бовиси еди, ");
INSERT INTO uigcyr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","униң инисиниң исми Юбал еди. Бу чилтар билән нәй чалғучиларниң бовиси еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Зиллаһ йәнә Тубал-қайин дегән бир оғулни туғди. У мис-төмүр әсвапларни соққучи еди. Тубал-Қайинниң Наамаһ исимлиқ бир сиңлиси бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ләмәх болса аяллириға сөз қилип: — «Әй Адаһ билән Зиллаһ, сөзүмни аңлаңлар! Әй Ләмәхниң аяллири, гепимгә қулақ селиңлар! Мени зәхимләндүргини үчүн мән адәм өлтүрдүм, Тенимни зедә қилғанлиғи үчүн бир жигитни өлтүрдүм. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Әгәр Қабил үчүн йәттә һәссә интиқам елинса, Ләмәх үчүн йәтмиш йәттә һәссә интиқам елиниду!» — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Адәм ата йәнә аяли билән биллә болди. Аяли бир оғул туғуп, униңға Шет дәп ат қоюп: Қабил Һабилни өлтүрүвәткини үчүн Худа униң орниға маңа башқа бир әвлат тикләп бәрди, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Шеттинму бир оғул туғулди; у униңға Енош дәп ат қойди. Шу вақиттин тартип адәмләр Пәрвәрдигарниң намиға нида қилишқа башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Бу Адәм атиниң әвлатлириниң нәсәбнамисидур: — Худа инсанни яратқан күнидә, уни Өзигә охшаш қилип яратти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","У уларни әр җинис вә аял җинис қилип яритип, уларға бәхит-бәрикәт ата қилип, яритилған күнидә уларниң намини «адәм» дәп атиди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Адәм ата бир йүз оттуз яшқа киргәндә униңдин өзигә охшайдиған, өз сүрәт-образидәк бир оғул төрәлди; у униңға Шет дәп ат қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Шет туғулғандин кейин Адәм ата сәккиз йүз жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Адәм атимиз җәмий тоққуз йүз оттуз жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Шет бир йүз бәш яшқа киргәндә униңдин Енош төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Енош туғулғандин кейин Шет сәккиз йүз йәттә жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Шет җәмий тоққуз йүз он икки жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Енош тохсән яшқа киргәндә униңдин Кенан төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Кенан туғулғандин кейин, Енош сәккиз жүр он бәш жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Енош җәмий тоққуз йүз бәш жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Кенан йәтмиш яшқа киргәндә униңдин Маһалалел төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Маһалалел туғулғандин кейин Кенан сәккиз йүз қириқ жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Кенан җәмий тоққуз йүз он жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Маһалалел атмиш бәш яшқа киргәндә униңдин Ярәд төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ярәд туғулғандин кейин Маһалалел сәккиз йүз оттуз жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Маһалалел җәмий сәккиз йүз тохсән бәш жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ярәд бир йүз атмиш икки яшқа киргәндә униңдин Һанох төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Һанох туғулғандин кейин Ярәд сәккиз йүз жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ярәд җәмий тоққуз йүз атмиш икки жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Һанох атмиш бәш яшқа киргәндә униңдин Мәтушәлаһ төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Мәтушәлаһ туғулғандин кейин Һанох үч йүз жилғичә Худа билән бир йолда меңип, йәнә оғул-қизларни тапти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Һанохниң йәр йүзидә барлиқ көргән күнлири үч йүз атмиш бәш жил болди; ");
INSERT INTO uigcyr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","У Худа билән бир йолда меңип яшайтти; у туюқсиз көздин ғайип болди; чүнки Худа уни Өз йениға елип кәткән еди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Мәтушәлаһ бир йүз сәксән йәттә яшқа киргәндә униңдин Ләмәх төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ләмәх туғулғандин кейин Мәтушәлаһ йәттә йүз сәксән икки жил өмүр көрүп, униңдин оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Мәтушәлаһ җәмий тоққуз йүз атмиш тоққуз жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","29","Ләмәх бир йүз сәксән икки яшқа киргәндә бир оғул тепип, униң исмини Нуһ атап: — Пәрвәрдигар тупраққа ләнәт қилди; шуңа биз йәргә ишлигинимиздә һәмдә қоллиримизниң җапалиқ әмгигидә бу бала бизгә тәсәлли бериду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Нуһ туғулғандин кейин Ләмәх бәш йүз тохсән бәш жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ләмәх җәмий йәттә йүз йәтмиш йәттә жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Нуһ бәш йүз яшқа киргәндин кейин, униңдин Шәм, Һам вә Яфәт төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Вә шундақ болдики, инсанлар йәр йүзидә көпийишкә башлиғанда, шундақла қизларму көпләп туғулғанда, ");
INSERT INTO uigcyr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Худаниң оғуллири инсанларниң қизлириниң чирайлиқлиғини көрүп, халиғанчә таллап, өзлиригә хотун қилишқа башлиди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","У вақитта Пәрвәрдигар сөз қилип: — — Мениң Роһум инсанлар билән мәңгү күрәш қиливәрмәйду; чүнки инсан әттур, халас. Кәлгүсидә уларниң өмри пәқәт бир йүз жигирмә яштин ашмисун! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Шу күнләрдә (вә шундақла кейинки күнләрдиму), Худаниң оғуллири инсанларниң қизлириниң йениға берип, улардин балиларни тапқинида, гигантлар йәр йүзидә пәйда болди. Булар болса қедимки заманлардики даңлиқ палван-батурлар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Пәрвәрдигар инсанниң өткүзүватқан рәзиллиги йәр йүзидә көпийип кәткәнлигини, уларниң көңлидики нийәтлириниң һәр қачан яман болуватқинини көрди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Шуниң билән Пәрвәрдигар йәр йүзидә адәмни апиридә қилғиниға пушайман қилип, көңлидә азапланди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Буниң билән Пәрвәрдигар: — Өзүм яратқан инсанни йәр йүзидин йоқитимән — инсандин тартип мал-чарвиларғичә, өмилигүчи һайванлардин асмандики қушларғичә, һәммисини йоқ қилимән; чүнки Мән уларни яратқинимға пушаймән қилдим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Лекин Нуһ болса Пәрвәрдигарниң нәзиридә шәпқәт тапқан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Нуһ вә униң иш-излири төвәндикичә: — Нуһ һәққаний, өз дәвридикиләр арисида әйипсиз адәм еди; Нуһ Худа билән бир йолда меңип яшайтти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Нуһтин Шәм, Һам, Яфәт дегән үч оғул төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Пүткүл җаһан Худаниң алдида рәзиллишип, һәммә йәр зораванлиққа толуп кәткән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Худа йәр йүзигә нәзәр селивиди, мана, җаһан рәзилләшкән еди; чүнки барлиқ әт егилириниң йәр йүзидә қиливатқини юзуқчилиқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Шуниң билән Худа Нуһқа: — Мана, алдимға барлиқ әт егилириниң заваллиғи йетип кәлди; чүнки пүткүл йәр-җаһанни уларниң сәвәвидин зораванлиқ қаплиди. Мана, Мән уларни йәр билән қошуп һалак қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Әнди сән өзүңгә гофәр яғичидин бир кемә ясап, кеминиң ичидә бөлмә-ханиларни қилип, ичи-тешини қаримай билән суга. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Сән уни шундақ ясиғин: — Узунлуғи үч йүз гәз, кәңлиги әллик гәз вә егизлиги оттуз гәз болсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Кеминиң пешайвини астиға бир очуқчилиқ яса, униң егизлиги бир гәз болсун; ишигини кеминиң йениға орунлаштур; кемини асти, оттура вә үсти қилип үч қәвәт яса. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Чүнки мана, Мән Өзүм асманниң астидики һаятлиқ тиниқи барлиги һәр бир әт егисини һалак қилидиған су топанни йәр йүзигә кәлтүримән; буниң билән йәр йүзидики барлиқ мәхлуқлар тиниқидин тохтайду. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Лекин сән билән әһдәмни түзимән. Сән өзүң, оғуллириң, аялиң вә келинлириңни елип бирликтә кемигә кириңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Өзүң билән тәң тирик сақлап қелиш үчүн, барлиқ җандарлардин һәр қайсисидин бир җүп, йәни әркикидин бирини, чишидин бирини кемигә елип киргин; ");
INSERT INTO uigcyr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Тирик қелиш үчүн қушларниң һәр бир түрлиридин, мал-чарвиларниң һәр бир түрлиридин вә йәрдә өмилигүчи җаниварларниң һәр бир түрлиридин бир җүпи қешиңға кириду. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Өзүң вә уларниң озуқлуғи үчүн һәр хил йемәкликләрдин елип, йениңға ғәмлигин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Нуһ шундақ қилди; Худа өзигә буйруған һәммә ишни у беҗа кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Пәрвәрдигар Нуһқа мундақ деди: — «Сән пүтүн өйдикилириң билән кемигә киргин; чүнки бу дәвирдә алдимда сени һәққаний дәп көрдүм. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Һәммә һалал һайванларниң әркәк-чишисидин йәттә җүптин, һарам һайванларниң әркәк-чишисидин бир җүптин елип, шуниңдәк асмандики учар-қанатларниңму әркәк-чишисидин йәттә җүптин елип, уларниң нәслини пүткүл йәр йүзидә тирик сақлаш үчүн өзүң билән биллә әкир.    ");
INSERT INTO uigcyr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Чүнки йәттә күндин кейин уда қириқ кечә-күндүз йәр йүзигә ямғур яғдуримән; Өзүм ясиған һәммә җаниварларни йәр йүзидин йоқитимән». ");
INSERT INTO uigcyr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Шуниң билән Нуһ Пәрвәрдигар униңға буйруғининиң һәммисигә әмәл қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Йәр йүзини топан басқанда Нуһ алтә йүз яшта еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Топандин қутулуп қелиш үчүн Нуһ билән оғуллири, аяли вә келинлири биллә кемигә кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Һалал һайванлар болсун, һарам һайванлар болсун, қушлар билән йәрдә өмилигүчи җаниварлар болсун, һәр бир түрдин бир җүп-бир җүптин әркәк-чиши болуп, Худа Нуһқа буйруғандәк кемигә, Нуһниң қешиға кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Вә шундақ болдики, йәттә күндин кейин, йәр йүзини топан бесишқа башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Нуһниң өмриниң алтә йүзинчи жили, иккинчи ейиниң он йәттинчи күнидә чоңқур деңизларниң тәглиридики барлиқ булақлар йерилип, асманниң пәнҗирилири ечилип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ямғур уда қириқ кечә-күндүз йәр йүзигә тохтимай яғди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Дәл ямғур башланған күни, Нуһ, Нуһниң Шәм, Һам, Яфәт дегән оғуллири, Нуһниң аяли билән үч келини кемигә кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Улар билән биллә һәр хил явайи һайванлар түр-түри бойичә, һәр хил мал-чарвилар түр-түри бойичә, йәрдә өмилигүчи һәр хил җаниварлар түр-түри бойичә вә һәр хил учар-қанатлар, йәни һәр хил қанатлиқ җаниварлар түр-түри бойичә кемигә кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Әт егилиридин, йәни барлиқ һаятлиқ тиниқи болған һәр хил җандарлардин, бир җүп-бир җүп болуп, кемигә нуһниң қешиға кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Киргәнләр Худаниң Нуһқа буйруғинидәк әт егилириниң һәртүриниң әркәк-чишиси еди. Андин Пәрвәрдигар ишикни етивәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Топан йәр йүзини уда қириқ күн бесип, сулар улғийип кәтти. Кемә йәр үстидин көтирилип ләйләп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Су улғийип, йәр үстидә техиму егизләп кәтти; кемә су үстидә давалғуп туратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Сулар йәр йүзидә толиму улғийип, пүткүл асманниң астидики барлиқ егиз тағларниму бесип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Сулар тағлардин йәнә он бәш гәз өрләп, тағ чоққилириму су астида қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Буниң билән йәр йүзидә жүргүчи һәммә әт егилири, учар-қушлар, мал-чарвилар, явайи һайванлар, йәрдә өмилигүчи һәммә җаниварлар, җүмлидин пүткүл адәмләр һәммиси өлди; ");
INSERT INTO uigcyr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","қуруқлуқта яшиғучи, бурнида һаятлиқ тиниқи бар болғанларниң һәммиси өлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Йәр йүзидики җени барларниң һәммиси, инсан болсун, мал-чарвилар болсун, өмилигүчи һайванлар болсун, асмандики қушлар болсун, һәммиси һалак болуп йәр йүзидин йоқ қилинди; пәқәт Нуһ вә кемидә униң билән биллә турғанлар қутулуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Бир йүз әллик күнгичә йәр йүзини су бесип турди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Худа Нуһни, шундақла кемидә униң билән биллә болған барлиқ явайи һайванлар билән барлиқ мал-чарвиларни әслиди. Шуниң билән Худа бир шамал чиқирип йәр йүзини йәлпүтти вә сулар йенишқа башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Чоңқур деңизларниң тәглиридики булақлар вә асманниң пәнҗирилири етилип, асмандин төкүлгән ямғур тохтиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Сулар барғансери йәр йүзидин янди; бир йүз әллик күн өткәндин кейин хелә азлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Йәттинчи айниң он йәттинчи күни, кемә Арарат тағ тизмилиридики бириниң үстидә тохтап қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Сулар онинчи айғичә барғансери азийип, онинчи айниң биринчи күни тағ чоққилири көрүнүшкә башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Қириқ күндин кейин Нуһ кемигә өзи орнатқан дәризини ечип, ");
INSERT INTO uigcyr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","бир қузғунни сиртқа чиқарди. У йәр йүзидики сулар тартилип болғичә уян-буян учуп жүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Униңдин кейин Нуһ суларниң йәр йүзидин тартилған-тартилмиғанлиғини билиш үчүн, бир кәптәрни чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Лекин сулар техичә пүткүл йәр йүзини қаплап турғачқа, кәптәр путини қойғидәк җай тапалмай, Нуһниң қешиға кемигә йенип кәлди. Шуниң билән Нуһ қолини сунуп уни тутуп, кемигә әкиривалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","У йәттә күн сақлап, бу кәптәрни кемидин йәнә сиртқа чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Кәптәр кәчтә униң қешиға йенип кәлди; мана, униң тумшуғида йеңи үзүвалған зәйтун йопурмиғи бар еди. Буни көрүп Нуһ суларниң йәр йүзидин тартилғинини билди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","У йәнә йәттә күн сақлап, кәптәрни йәнә сиртқа чиқарди, амма бу қетим кәптәр униң йениға қайтип кәлмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Нуһ алтә йүз бир яшқа киргән жили, биринчи айниң биринчи күнидә су йәр йүзидин қуруған еди. Нуһ кеминиң қапқиқини ечип қаривиди, йәрниң қуруғинини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Иккинчи айниң жигирмә йәттинчи күни, йәр йүзи пүтүнләй қуруп болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","У вақитта Худа Нуһқа сөз қилип: — Сән өзүң, аялиң, оғуллириң вә келинлириң кемидин чиқиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Өзүң билән биллә болған барлиқ әт егилиридин һәр бир түрдики җаниварларни, йәни учар-қанатларни һәм мал-чарвиларни, йәрдә өмилигүчи һайванларниң һәммисини өзүң билән қошуп кемидин елип чиққин; шуниң билән улар йәр йүзидә тарилип-тарқилип, нәсиллинип зиминда көпәйсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Шуниң билән Нуһ, аяли, оғуллири вә келинлири билән биллә сиртқа чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Җаниварларниң һәммиси, барлиқ өмилигүчи һайванлар, барлиқ учар-қанатлар, йәрдә мидирлап жүридиғанларниң һәр қайсиси өз түрлири бойичә кемидин чиқишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Шу чағда Нуһ Пәрвәрдигарға атап бир қурбангаһни ясиди; у һалал җаниварлар билән һалал қушларниң һәр түридин елип келип, қурбангаһниң үстидә «көйдүрмә қурбанлиқ» өткүзди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Шундақ қилип Пәрвәрдигар хушбуй пурап мәмнун болди; Пәрвәрдигар көңлидә: — «Инсанниң көңүл-нийити яшлиғидин тартип рәзил болсиму, Мән инсан түпәйлидин йәргә йәнә ләнәт оқумаймән вә әнди бу қетимқидәк һәммә җандарларни уруп йоқитивәтмәймән.    ");
INSERT INTO uigcyr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Бундин кейин, йәр мәвҗут күнлиридә, Териш билән орма, Соғ билән иссиқ, Яз билән қиш, Күндүз билән кечә үзүлмәй айлинип туриду» — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Худа Нуһ билән униң оғуллириға бәхит-бәрикәт ата қилип, уларға мундақ деди: — «Силәр җүплишип көпийип, йәр йүзини толдуруңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Йәр йүзидики барлиқ җаниварлар, асмандики барлиқ қушлар, барлиқ йәр йүзидә мидирлап жүргүчиләр вә деңиздики барлиқ белиқларниң һәммиси силәрдин қорқуп вәһимидә болсун; булар қолуңларға тапшурулғандур. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Мидирлап жүридиған һәр қандақ җаниварлар силәргә озуқ болиду; Мән силәргә көк отяшларни бәргәндәк, буларниң һәммисини әнди силәргә бәрдим. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Лекин силәр гөшни ичидики җени, йәни қени билән қошуп йемәслигиңлар керәк. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Қениңлар, йәни җениңлардики қан төкүлсә, Мән бәрһәқ униң һесавини алимән; һәр қандақ һайванниң илкидә қениңлар бар болса Мән униңға төләткүзимән; инсанниң қолида бар болса, йәни бирисиниң қолида өз қериндишиниң қени бар болса, Мән униңға шу қанни төләткүзимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Кимки инсанниң қенини төксә, Униң қениму инсан тәрипидин төкүлиду; Чүнки Худа инсанни Өз сүрәт-образида яратқандур. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Әнди силәр, җүплишип көпийип, йәр йүзидә тарилип-тарқилип көпийиңлар». ");
INSERT INTO uigcyr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","9","Андин Худа Нуһ билән униң оғуллириға сөз қилип мундақ деди: — «Мана Өзүм силәр билән вә силәрдин кейин келидиған әвлатлириңлар билән, шундақла силәр билән биллә турған һәр бир җан егиси, учарқанатлар, мал-чарвилар, силәр билән биллә турған йәр йүзидики һәр бир явайи һайванлар, кемидин чиққанларниң һәммиси билән — йәр йүзидики һеч бир һайванни қалдурмай, улар билән Өз әһдәмни түзимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Мән силәр билән шундақ әһдә түзимәнки, нә барлиқ әт егилири топан билән йоқитилмас, нә йәрни вәйран қилидиған һеч бир топан йәнә кәлмәс». ");
INSERT INTO uigcyr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Худа йәнә: — «Мән Өзүм силәр билән вә қешиңлардики һәммә җан егилири билән мәңгүлүк, йәни пүткүл әвлатлириңларғичә бекиткән мошу әһдәмниң бәлгүси шуки: — Мана, Мән Өзүм билән йәрниң оттурисида болған әһдиниң бәлгүси болсун дәп һәсән-һүсинимни булутлар ичигә қойимән; ");
INSERT INTO uigcyr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","вә шундақ болидуки, Мән йәрниң үстигә булутларни чиқарғинимда, шундақла һәсән-һүсән булутлар ичидә аян болғинида, Мән силәр билән әт егилири болған барлиқ җаниварлар билән түзгән әһдәмни яд етимән; буниңдин кейин сулар һәргиз һәммә җандарларни һалак қилғучи топан болмас. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Һәсән-һүсән булутлар арисида пәйда болиду; Мән униңға қараймән вә шуниң билән Мәнки Худа йәр йүзидики әт егилири болған барлиқ җаниварлар билән оттуримизда бекиткән әһдәмни яд етимән», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Худа Нуһқа йәнә: — «Мана бу Мән Өзүм билән йәр йүзидики барлиқ әт егилири оттурисида бекиткән әһдәмниң нишан-бәлгүсидур», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Нуһниң кемидин чиққан оғуллири Шәм, Һам вә Яфәт еди. Һам Қанаанниң атиси болди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Бу үчи Нуһниң оғуллири болуп, пүткүл йәр йүзигә таралған аһалә шуларниң нәсил-әвлатлиридур. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Нуһ териқчилиқ қилишқа башлап, бир үзүмзарлиқ бәрпа қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","У униң шарабидин ичип, мәс болуп қелип, өз чедири ичидә кийим-кечәклирини селиветип, ялаңач йетип қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Қанаанниң атиси Һам келип, атисиниң әвритини көрүп, сиртқа чиқип икки қериндишиға ейтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Шәм билән Яфәт қопуп йепинҗини елип, мүрисигә артип, кәйничә меңип кирип, атисиниң ялаңач бәдинини йепип қойди. Улар йүзини алди тәрәпкә қилип, атисиниң ялаңач тенигә қаримиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Нуһ шарапниң кәйпидин ойғинип, кәнҗи оғлиниң өзигә немә қилғинини билип: — ");
INSERT INTO uigcyr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Қанаанға ләнәт болғай! У қериндашлириниң қулиниң қули болсун, — дәп қарғиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","У йәнә: — Шәмниң Худаси болған Пәрвәрдигарға тәшәккүр-мәдһийә кәлтүрүлгәй! Қанаан Шәмниң қули болсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Худа Яфәтни авутқай! У Шәмниң чедирлирида турғай, Қанаан болса униң қули болғай! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Нуһ топандин кейин үч йүз әллик жил өмүр көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Бу тәриқидә Нуһ җәмий тоққуз йүз әллик жил күн көрүп, аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Төвәндикиләр Нуһниң оғуллириниң әвлатлиридур: — униң оғуллири Шәм, Һам вә Яфәт болуп, топандин кейин улардин оғуллар төрәлгән: —      ");
INSERT INTO uigcyr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Яфәтниң оғуллири болса, Гомәр, Магог, Мадай, Яван, Тубал, Мәшәк вә Тирас еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Гомәрниң әвлатлири: Ашкиназ, Рифат вә Тогармаһ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Яванниң әвлатлири: Елишаһ, Таршиш, Киттийлар вә Доданийлар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Буларниң әвлатлири деңиз бойлирида вә аралларда айрим-айрим яшиған хәлиқләр болуп, һәр қайсиси өз тили, өз аилә-қәбилилири бойичә өз зиминлирида тарқилип олтирақлашқан. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Һамниң оғуллири Куш, Мисир, Пут вә Қанаанлар еди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Кушниң оғуллири Себа, Һавилаһ, Сабтаһ, Раамаһ вә Сабтика еди. Раамаһниң оғуллири Шеба вә Дедан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Куштин йәнә Нимрод төрәлгән; у йәр йүзидә наһайити күчтүңгүр адәм болуп чиқти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","У Пәрвәрдигарниң алдида күчтүңгүр овчи болди; шу сәвәптин «паланчи болса Нимродтәк, Пәрвәрдигарниң алдида күчтүңгүр овчи екән» дегән гәп тарқалған. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Униң падишалиғи Шинар зиминидики Бабил, Әрәк, Аккад вә Калнәһ дегән шәһәрләрдә башланған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","У бу зиминдин Ашур зиминиға чиқип Нинәвә, Рәһобот-Ир, Калаһ вә Нинәвә билән Калаһниң оттурисидики Рәсән дегән шәһәрләрниму бена қилди (булар қошулуп «Катта Шәһәр» болди). ");
INSERT INTO uigcyr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Мисирниң әвлатлири Лудийлар, Анамийлар, Ләһабийлар, Нафтуһийлар, ");
INSERT INTO uigcyr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Патросийлар, Каслуһийлар (Филистийләр Каслуһийлардин чиққан) вә Кафторийлар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Қанаандин тунҗа оғул Зидон төрилип, кейин йәнә Һәт төрәлгән. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","униң әвлатлири болса Йәбусийлар, Аморийлар, Гиргашийлар, ");
INSERT INTO uigcyr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Һивийлар, Арқийлар, Синийлар, ");
INSERT INTO uigcyr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Арвадийлар, Зәмарийлар вә Һаматийлар еди. Шуниңдин кейин, Ⱪананийларниң қәбилилири һәр тәрәпкә тарқилип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ⱪананийларниң жут чегариси болса Зидондин тартип, Гәрар тәрипигә созулуп, Газаға чиқип, андин Содом, Гоморра, Адмаһ билән Зәбоим тәрипигә тутишип, Лешағичә йетип баратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Жуқириқилар болса һамниң оғуллири болуп, өз қәбилиси вә тиллири бойичә қовм болуп өз зиминлирида олтирақлашқан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Шәмму оғул пәрзәнтлик болди; Шәм болса Яфәтниң акиси, Ебәрләрниң ата-бовиси болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Шәмниң оғуллири Елам, Ашур, Арфахшад, Луд, Арам; ");
INSERT INTO uigcyr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Арамниң оғуллири Уз, Һул, Гәтәр, Маш еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Арфахшадтин Шелаһ төрәлди, Шелаһтин Ебәр төрәлди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ебәрдин икки оғул төрәлгән болуп, бириниң исми Пәләг еди, чүнки у яшиған дәвирдә йәр йүзидә бөлүнүш болди; Пәләгниң инисиниң исми Йоқтан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Йоқтандин Алмодад, Шәләф, Хазармавәт, Йераһ, ");
INSERT INTO uigcyr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Һадорам, Узал, Диклаһ, ");
INSERT INTO uigcyr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Обал, Абимаәл, Шеба, ");
INSERT INTO uigcyr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Офир, Һавилаһ вә Йобаб төрәлди. Буларниң һәммиси Йоқтанниң оғуллири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Уларниң олтарған җайлири болса Мешадин тартип, Сәффар дегән районниң шәриқ тәрипидики таққичә созулатти. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Жуқириқилар болса Шәмниң оғуллири болуп, өз қәбилиси вә тиллири бойичә қовм болуп өз зиминлирида олтирақлашқан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Жуқиридикиләр Нуһниң әвлатлири болуп, улар өз нәсәблири вә қовмлири бойичә хатириләнгән. Топандин кейинки йәр йүзидики барлиқ қовмлар уларниң ичидин тарқалған.    ");
INSERT INTO uigcyr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","У заманда пүткүл йәр йүзидики тил һәм сөз бир хил еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Лекин шундақ болдики, адәмләр мәшриқ тәрәпкә сәпәр қилип, Шинар жутида бир түзләңликни учритип, шу йәрдә олтирақлашти. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Улар бир-биригә: — Келиңлар, биз хиш қуюп, отта пиширайли! — дейишти. Шундақ қилип, улар қурулушта ташниң орниға хиш, лайниң орниға қаримай ишләтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Улар йәнә: — Келиңлар, әнди өзимизгә бир шәһәр бена қилип, шәһәрдә учи асманларға тақашқидәк бир мунар ясайли! Шундақ қилип өзимизгә бир нам тикләләймиз. Болмиса, пүткүл йәр йүзигә тарилип кетимиз, — дейишти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","У вақитта Пәрвәрдигар адәм балилири бена қиливатқан шәһәр билән мунарни көргили чүшти. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Пәрвәрдигар: — «Мана, буларниң һәммиси бир қовмдур, уларниң һәммисиниң тилиму бирдур; бу уларниң ишиниң башлинишидур! Бундин кейин уларниң нийәт қилған һәр қандақ ишини һеч тосувалғили болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Шуңа Биз төвәнгә чүшүп уларниң бир-бириниң гәплирини уқалмаслиғи үчүн уларниң тилини башқа-башқа қилип қалаймиқанлаштуруветәйли» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Шундақ қилип Пәрвәрдигар уларни у җайдин пүткүл йәр йүзигә таритивәтти. Шуниң билән улар шәһәрни ясаштин тохтап қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Шуңа бу шәһәрниң нами «Бабил» дәп аталди; чүнки у йәрдә Пәрвәрдигар пүткүл йәр йүзидикиләрниң тилини қалаймиқанлаштурувәтти. Шундақ қилип Пәрвәрдигар уларни у җайдин пүткүл йәр йүзигә таритивәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Төвәндикиләр Шәмниң әвлатлиридур: — топан өтүп икки жилдин кейин, Шәм йүз йешида, униңдин Арфакшад төрәлди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Арфакшад туғулғандин кейин Шәм бәш йүз жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Арфакшад оттуз бәш яшқа киргәндә униңдин Шелаһ төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Шелаһ туғулғандин кейин Арфакшад төрт йүз үч жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Шелаһ оттуз яшқа киргәндә униңдин Ебәр төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ебәр туғулғандин кейин Шелаһ төрт йүз үч жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ебәр оттуз төрт яшқа киргәндә униңдин Пәләг төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Пәләг туғулғандин кейин Ебәр төрт йүз оттуз жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Пәләг оттуз яшқа киргәндә униңдин Рәу төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Рәу туғулғандин кейин Пәләг икки йүз тоққуз жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Рәу оттуз икки яшқа киргәндә униңдин Серуг төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Серуг туғулғандин кейин Рәу икки йүз йәттә жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Серуг оттуз яшқа киргәндә униңдин Наһор төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Наһор туғулғандин кейин Серуг икки йүз жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Наһор жигирмә тоққуз яшқа киргәндә униңдин Тәраһ төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Тәраһ туғулғандин кейин Наһор бир йүз он тоққуз жил өмүр көрүп, униңдин йәнә оғул-қизлар төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Тәраһ йәтмиш яшқа киргәндә униңдин Абрам, Наһор вә Һаран төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Тәраһниң әвлатлири төвәндикичә: — Тәраһтин Абрам, Наһор вә Һаран төрәлди; Һарандин Лут төрәлди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Лекин Һаран туғулған жути болған, калдийләрниң Ур шәһиридә атиси Тәраһниң алдида, Тәраһтин илгири өлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Абрам билән Наһор иккиси өйләнди. Абрамниң аялиниң исми Сарай, Наһорниң аялиниң исми Милкаһ еди; Милкаһ Һаранниң қизи еди; Һаран болса Милкаһ вә Искаһниң атиси еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Лекин Сарай туғмас болғачқа, униң балиси йоқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Тәраһ болса оғли Абрамни, нәвриси Лут (Һаранниң оғли)ни вә келини, йәни Абрамниң аяли Сарайни елип, Қанаан зиминиға бериш үчүн калдийләрниң Ур шәһиридин йолға чиқти; бирақ улар Һаран дегән җайға йетип кәлгәндә, шу йәрдә олтирақлишип қалди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Тәраһниң көргән күнлири икки йүз бәш жил болуп, Һаранда аләмдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Пәрвәрдигар әслидә Абрамға мундақ дегән еди: — Сән өз жутуңдин, өз уруқ-туққанлириңдин вә өз ата җәмәтиңдин айрилип, Мән саңа көрситидиған зиминға барғин. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Шундақ қилсаң Мән сени улуқ бир хәлиқ қилип, саңа бәхит-бәрикәт ата қилип, намиңни улуқ қилимән; шуниң билән сән өзүң башқиларға бәхит-бәрикәт болғин; ");
INSERT INTO uigcyr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","кимләр саңа бәхит-бәрикәт тилисә Мән уларни бәрикәтләймән, кимки сени хорлиса, Мән чоқум уни ләнәткә қалдуримән; сән арқилиқ йәр йүзидики барлиқ аилә-қәбилиләргә бәхит-бәрикәт ата қилиниду! — деди.      ");
INSERT INTO uigcyr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Абрам Пәрвәрдигар униңға ейтқини бойичә Һарандин айрилди; Лутму униң билән биллә маңди. Абрам Һарандин чиққинида йәтмиш бәш яшта еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Абрам аяли Сарай билән инисиниң оғли Лутни елип, уларниң жиққан барлиқ мал-мүлүгини қошуп, Һаранда егидарчилиқ қилған адәмләрни биллә қетип, Қанаан зиминиға бериш үчүн йолға чиқти; шундақ қилип улар Қанаан зиминиға йетип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Абрам зиминни кезип, Шәкәм дегән җайдики «Морәһниң дуб дәриғи»ниң йениға кәлди (у чағда у зиминда Ⱪананийлар туратти). ");
INSERT INTO uigcyr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Пәрвәрдигар Абрамға көрүнүп, униңға: — Мән бу зиминни сениң нәслиңгә ата қилимән, — деди. Шуниң билән у шу йәрдә өзигә көрүнгән Пәрвәрдигарға атап бир қурбангаһ салди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Андин у бу йәрдин йөткилип, Бәйт-Әлниң шәрқидики таққа барди; ғәрип тәрипидә Бәйт-Әл, шәриқ тәрипидә Айи дегән җай бар еди; у шу йәрдә чедир тикти. У шу йәрдә Пәрвәрдигарға атап бир қурбангаһ ясап, Пәрвәрдигарниң намини чақирип ибадәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Андин кейин Абрам тәдриҗий көчүп, җәнубидики Нәгәв райониға қарап йөткәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Зиминда ачарчилиқ болған еди; Абрам Мисирға чүшти; у шу йәрдә вақтинчә турмақчи болған еди, чүнки зиминда ачарчилиқ бәк еғир еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Амма шундақ болдики, у Мисирға йеқинлашқанда, аяли Сарайға: — Мана, мән сениң һөсүн-җамалиңниң гөзәллигини билимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Шундақ болидуки, мисирлиқлар сени көрсә, «Бу униң аяли екән» дәп, мени өлтүрүветип, сени тирик қалдуриду. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Шуниң үчүн сениң: «Мән униң сиңлиси» дейишиңни өтинимән. Шундақ қилсаң, мән сениңдин яхшилиқ тепип, сән арқилиқ тирик қалимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Абрам Мисирға киргәндә шундақ болдики, мисирлиқлар дәрвәқә аялниң гөзәл екәнлигини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Пирәвнниң әмирлириму уни көрүп, Пирәвнгә униң тәрипини қилди; шуниң билән аял Пирәвнниң ордисиға елип кирилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Пирәвн Сарайниң сәвәвидин Абрамға яхши муамилә қилди; шуниң билән у қой, кала, һаңга ешәкләр, қул-дедәкләр, мада ешәкләр вә төгиләргә еришти. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Амма Пәрвәрдигар Пирәвн вә өйидикилирини Абрамниң аяли Сарайниң сәвәвидин толиму еғир вабаларға муптила қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Шуниң үчүн Пирәвн Абрамни чақирип униңға: — «Бу зади сениң маңа немә қилғиниң? Немишкә униң өз аялиң екәнлигини маңа ейтмидиң? ");
INSERT INTO uigcyr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Немишкә уни «сиңлим» дәп мениң уни хотунлуққа елишимға сәвәпкар болғили тас қалисән! Мана бу аялиң! Уни елип кәткин! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Пирәвн өз адәмлиригә Абрам тоғрисида әмир қилди; улар уни, аялини вә униң барлиғини қошуп йолға селивәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Шуниң билән Абрам аяли вә униң барлиқ нәрсилирини һәмдә Лутни елип Мисирдин чиқип, Қанаанниң җәнубидики Нәгәв жутиға маңди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","У чағда Абрамниң мал-варан вә алтун-күмүчлири көп болуп, хеләла бай еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","У көчүп жүрүп, җәнуптики Нәгәвдин Бәйт-Әлгә, йәни Бәйт-Әл билән Айиниң оттурисидики әслидә чедир тиккән җайға, ");
INSERT INTO uigcyr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","қурбангаһ ясиған җайға қайтип кәлди. Абрам шу йәрдә Пәрвәрдигарниң намини чақирип ибадәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Абрам билән биллә маңған Лутниңму қой-кала падилири вә чедирлири бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Әнди улар биллә турса, зимин уларни қамдалмайтти; ");
INSERT INTO uigcyr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","бу сәвәптин Абрамниң падичилири билән Лутниң падичилириниң арисида җедәл чиқти (у вақитта Ⱪананийлар билән Пәриззийләр шу зиминда туратти).    ");
INSERT INTO uigcyr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Шуңа Абрам Лутқа: — «Биз болсақ қериндашлармиз, сән билән мениң арамда, мениң падичилирим билән сениң падичилириң арисида талаш-тартиш пәйда болмисун. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Мана, алдиңда пүткүл зимин турмамду? Әнди сән мәндин айрилғин; әгәр сән сол тәрәпкә барсаң, мән оң тәрәпкә барай; әгәр сән оң тәрәпкә барсаң, мән сол тәрәпкә барай», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","У вақитта Лут нәзәр селип көрдики, Иордан вадисидики барлиқ түзләңликниң Зоар шәһиригичә һәммила йәрниң сүйи интайин мол еди; Пәрвәрдигар Содом билән Гоморрани вәйран қилиштин илгири бу йәр бәәйни Пәрвәрдигарниң беғи, Мисир зиминидәк еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Шуниң билән Лут өзигә Иордан вадисидики пүткүл түзләңликни талливалди; андин Лут мәшриқ тәрәпкә көчүп барди. Шундақ қилип иккилән айрилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Абрам Қанаан зиминида олтирақлашти; Лут болса түзләңликтики шәһәрләрниң арисида турди; у бара-бара чедирлирини Содом шәһири тәрәпкә йөткиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Содом хәлқи рәзил адәмләр болуп, Пәрвәрдигарниң нәзиридә толиму еғир гунакарлар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Лут Абрамдин айрилип кәткәндин кейин, Пәрвәрдигар Абрамға: — Сән әнди бешиңни көтирип, өзүң турған җайдин шимал вә җәнупқа, мәшриқ вә мәғрип тәрәпкә қариғин; ");
INSERT INTO uigcyr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","чүнки сән һазир көрүватқан бу барлиқ зиминни саңа вә нәслиңгә мәңгүлүк беримән.    ");
INSERT INTO uigcyr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Сениң нәслиңни йәрдики топидәк көп қилимән; шундақки, әгәр бириси йәрдики топини санап чиқалиса, сениң нәслиңниму санап чиқалиши мүмкин болиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Орнуңдин тур, бу зиминни узунлуғи вә кәңлиги бойичә айлинип чиққин; чүнки Мән уни саңа ата қилимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Шуңа Абрам чедирлирини йөткәп, Һеброн шәһиригә йеқин Мамрәдики дубзарлиқниң йениға берип олтирақлашти; у шу йәрдә Пәрвәрдигарға атап бир қурбангаһ ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Шинарниң падишаси Амрафәл, Әлласарниң падишаси Ариоқ, Еламниң падишаси Кедорлайомәр вә Гойимниң падишаси Тидалниң күнлиридә шу вақиә болдики, ");
INSERT INTO uigcyr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","улар бирлишип Содомниң падишаси Бера, Гоморраниң падишаси Бирша, Адмаһниң падишаси Шинаб, Зәбоимниң падишаси Шәмъебәр вә Бела (йәни Зоар)ниң падишасиға қарши һуҗумға атланди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Бу бәшиниң һәммиси келишип Сиддим вадисиға, йәни «Шор Деңизи» вадисиға жиғилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Улар он икки жил Кедорлайомәргә беқинди болди, он үчинчи жилға кәлгәндә, Кедорлайомәргә қарши исян көтәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Он төртинчи жили Кедорлайомәр вә униңға иттипақдаш болған падишалар һәммиси жиғилип, Аштарот-Карнаим дегән йәрдә рәфайийларға, шундақла Һам дегән йәрдә зузийларға, Шавәһ-Кириатайимда Емийларға һуҗум қилип уларни йәңди; ");
INSERT INTO uigcyr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","андин улар Һорийларни уларниң Сеир теғида мәғлуп қилип, чөлниң йенидики Әл-Паранғичә сүрүп-тоқай қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Арқидинла, улар Ән-Мишпатқа (йәни Қадәшкә) йенип келип, Амаләкләрниң пүткүл жутини булаң-талаң қилди; Һазазон-Тамарда олтиришлиқ Аморийларниму һуҗум қилип мәғлуп қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Шуниң билән Содомниң падишаси, Гоморраниң падишаси, Адмаһниң падишаси, Зәбоимниң падишаси вә Беланиң (йәни Зоарниң) падишаси чиқип, Сиддим вадисида уларға қарши җәң қилишқа сәп тизди; ");
INSERT INTO uigcyr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","мошу бәшәйлән Еламниң падишаси Кедорлайомәр, Гойимниң падишаси Тидал, Шинарниң падишаси Амрафәл, Әлласарниң падишаси Ариоқ қатарлиқлар билән соқушти; йәни төрт падиша билән бәш падиша өз ара соқушти. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Сиддим вадисидики һәммила йәрдә қаримай орәклири бар еди. Содом вә Гоморраниң падишалири қечип, орәкләргә чүшүп кәтти. Амма қалғанлар болса таққа қечип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ғалип кәлгән төрт падиша болса Содом билән Гоморраниң һәммә мал-мүлкини вә барлиқ озуқ-түлүгини елип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Улар йәнә Абрамниң җийәни Лутниму маллири билән қошуп елип кәтти; чүнки у Содомда олтирақлашқан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Һалбуки, қутулуп қалған бириси берип бу ишларни ибраний Абрамға ейтти. Шу чағда у Аморий Мамрәниң дубзарлиғиниң йенида туратти. Мамрә болса Әшкол вә Анәрниң акиси еди; бу үчәйлән Абрам билән иттипақдаш еди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Абрам қериндишиниң әсир болуп қалғанлиғини аңлап, өз өйидә туғулған, алаһидә тәрбийиләнгән үч йүз он сәккиз адәмни башлап чиқип, төрт падишани қоғлап данғичә барди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Кечиси у адәмлирини гуруппиларға бөлүп, улар билән бирликтә һуҗум қилип уларни мәғлуп қилип, уларни Дәмәшқниң шимал тәрипидики Һобаһ дегән җайғичә қоғлап берип, ");
INSERT INTO uigcyr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","пүткүл олҗа алған мал-мүлүкни қайтурувалди; өз қериндиши Лутни, униң мал-мүлки вә хотун-қизлирини, шундақла барлиқ қалған адәмләрни яндуруп кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Абрам Кедорлайомәр вә униң билән иттипақдаш падишаларни мәғлуп қилип, қайтип кәлгәндә, Содомниң падишаси Шавәһ вадиси (йәни Хан вадиси)ға униң алдиға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Салемниң падишаси Мәлкизәдәкму нан билән шарап елип алдиға чиқти. У зат болса, Һәммидин Алий Тәңриниң каһини еди;    ");
INSERT INTO uigcyr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","у Абрамни бәхит-бәрикәтләп: — «Абрам асман билән зиминниң Егиси болған Һәммидин Алий Тәңри тәрипидин бәрикәтләнсун! ");
INSERT INTO uigcyr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Шундақла дүшмәнлириңни өз қолуңға тапшурған Һәммидин Алий Тәңригә Һәмдусана оқулғай!» — деди. Абрам болса ғәниймәт алған нәрсиләрниң ондин бирини униңға бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Андин Содомниң падишаси Абрамға: — Адәмләрни маңа бәргәйла, ғәниймәтләрни өзлиригә алғайла, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Лекин Абрам Содомниң падишасиға җавап берип: — Мән болсам асман билән зиминниң Егиси болған Һәммидин Алий Тәңри Пәрвәрдигарға қол көтирип қәсәм қилғанмәнки, ");
INSERT INTO uigcyr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","мән сәндин һәтта бир тал жип нә бир тал боқучиниму нә сениң башқа һәр қандақ нәрсәңни алмаймән; болмиса, сән кейин: «мән Абрамни бай қилип қойдом» дейишиң мүмкин. ");
INSERT INTO uigcyr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Шуңа жигитлиримниң йегән-ичкини, шундақла маңа һәмраһ болғанлар, йәни Анәр, Әшкол вә Мамрәләргә тегишлик үлүштин башқа, мән ғәниймәттин һеч нәрсә алмаймән; шулар өзлиригә тегишлик үлүшини алсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Бу ишлардин кейин Пәрвәрдигарниң сөз-калами Абрамға аламәт көрүнүштә келип: «Әй Абрам, қорқмиғин; Мән Өзүм қалқиниң вә зор инъамиңдурмән» — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Лекин Абрам: — Әй Рәб Пәрвәрдигар, маңа немә берисән? Мана, мән балисиз турсам, өй-бисатлиримға варислиқ қилғучи мошу Дәмәшқлик Әлиезәрла бардур, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Абрам йәнә: Мана, Сән маңа һеч нәсил бәрмидиң, мана өйүмдә туруватқанлардин бири маңа варис болиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Шу һаман Пәрвәрдигарниң сөз-калами униңға келип: «Бу киши саңа варис болмайду, бәлки өз пуштуңдин болидиған киши саңа варис болиду», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Шуниң билән Пәрвәрдигар уни ташқириға елип чиқип: — Әнди асманға қарап юлтузларни сана — Қени, уларни саналамсәнкин?! — деди. Андин униңға: — Сениң нәслиңму шундақ болиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Абрам Пәрвәрдигарға ишәнди; Пәрвәрдигар униңдики бу ишәшни униң һәққанийлиғи дәп һесаплиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Йәнә униңға: Мән бу зиминға егә қилишқа сени Калдийәдики Ур шәһиридин елип чиққан Пәрвәрдигардурмән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Лекин Абрам: — И Рәб Пәрвәрдигар, мән униңға җәзмән егә болидиғинимни қандақ билимән? — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Пәрвәрдигар униңға: — Мән үчүн үч яшлиқ бир инәк, үч яшлиқ бир чиши өчкә, үч яшлиқ бир қочқар билән бир кәптәр вә бир бачка елип кәлгин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Шуңа у буларниң һәммисини елип, уларниң һәр бирсини йеримдин икки парчә қилип, йеримини йәнә бир йеримиға удулму удул қилип қоюп қойди; амма қушларни парчилимиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Қарға-қузғунлар тапларниң үстигә чүшкәндә, Абрам уларни үркүтүп һайдивәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Лекин күн патай дегәндә, Абрамни еғир бир уйқа басти вә мана, униң үстигә дәһшәтлик бир вәһимә, тум қараңғулуқ чүшти. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Андин Пәрвәрдигар Абрамға: — Җәзмән билишиң керәкки, сениң нәслиң өзлириниң болмиған бир зиминда мусапир болуп, шу йәрдики хәлиқниң қуллуғида болиду вә шундақла, бу хәлиқ уларға төрт йүз жилғичә җәбир-зулум салиду.    ");
INSERT INTO uigcyr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Лекин Мән уларни қуллуққа салғучи шу таипиниң үстидин һөкүм чиқиримән. Кейин улар нурғун байлиқларни елип шу йәрдин чиқиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Амма сән болсаң, аман-хатирҗәмлик ичидә ата-бовилириңға қошулисән; узун өмүр көрүп андин дәпнә қилинисән.    ");
INSERT INTO uigcyr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Лекин шу йәрдә төрт әвлат өтүп, нәслиң бу йәргә йенип келиду; чүнки Аморийларниң қәбиһлигиниң зихи техи тошмиди, деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Шундақ болдики, күн петип қараңғу болғанда, мана, гөшләрниң оттурисидин өтүп кетиватқан, ис-түтәк чиқип турған бир отдан билән ялқунлуқ бир мәшъәл көрүнди. ");
INSERT INTO uigcyr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","19","Дәл шу күни Пәрвәрдигар Абрам билән әһдә түзүп униңға: — «Мән сениң нәслиңгә бу зиминни Мисирниң еқинидин тартип Улуқ дәрия, йәни Әфрат дәриясиғичә беримән; йәни Кенийләр, Кәниззийлар, Кадмонийлар, ");
INSERT INTO uigcyr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Һиттийлар, Пәриззийләр, Рәфайийлар, ");
INSERT INTO uigcyr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Аморийлар, Ⱪананийлар, Гиргашийлар вә Йәбусийларниң жутини уларниңки қилимән» деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Амма Абрамниң аяли Сарай униңға һеч бала туғуп бәрмиди; лекин униң Һәҗәр исимлиқ мисирлиқ бир дедиги бар еди; ");
INSERT INTO uigcyr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Сарай Абрамға: — Мана, Пәрвәрдигар мени туғуштин тости. Әнди сән мениң дедигимниң қешиға киргин; бәлким у арқилиқ ана болуп тиклинишим мүмкин, — деди. Абрам болса Сарайниң сөзини қобул көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Шуниң билән Абрамниң аяли Сарай дедиги мисирлиқ Һәҗәрни өз ери Абрамға тоқаллиққа апирип бәрди (у вақитта Абрам Қанаан зиминида он жил олтарған еди). ");
INSERT INTO uigcyr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Абрам Һәҗәрниң қешиға кирди вә у һамилдар болди. Амма у өзиниң һамилдар болғинини билгинидә, у аял ғоҗайинини көзгә илмас болуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Сарай Абрамға қейидап: — Маңа чүшкән бу хорлуқ сениң бешиңға чүшсун! Мән өз дедигимни қучиғиңға селип бәрдим; әнди у өзиниң һамилдар болғинини көргәндә мән униң нәзиридә көзгә илинмидим. Хәйр, Пәрвәрдигар сән билән мениң оттуримизда һөкүм чиқарсун! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Абрам Сарайға: — Мана, дедигиң өз қолуңдидур; саңа немә лайиқ көрүнсә униңға шуни қилғин, — деди. Буниң билән Сарай униңға қаттиқлиқ қилишқа башлиди; буниң билән у униң алдидин қечип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Амма Пәрвәрдигарниң Пәриштиси уни чөлдики бир булақниң йенида, йәни Шур йолиниң бойидики булақниң йенидин тепип, униңға: ");
INSERT INTO uigcyr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Әй Сарайниң дедиги Һәҗәр, нәдин кәлдиң, нәгә барисән? — дәп сориди. У җавап берип: — Мән ғоҗайиним Сарайниң алдидин қечип чиқтим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Пәрвәрдигарниң Пәриштиси униңға: — Аял ғоҗайиниңниң қешиға қайтип берип, униң қол астида бол, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Пәрвәрдигарниң Пәриштиси униңға йәнә: — Сениң нәслиңни шундақ көпәйтимәнки, көплүгидин уни санап болғили болмайду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Андин Пәрвәрдигарниң Пәриштиси униңға: Мана, сән һамилдарсән; сән бир оғул туғуп, униңға Исмаил дәп ат қойғин; чүнки Пәрвәрдигар сениң җәбир-җапайиңни аңлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","У явайи ешәк кәби бир адәм болиду; униң қоли һәр адәмгә қарши узитилиду, шуниңдәк һәр адәмниң қоли униңға қарши узитилиду; у қериндашлириниң удулида айрим туриду, деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Һәҗәр өз-өзигә: «Мән мошу йәрдә мени Көргүчини арқисидин көрдүм» дәп, өзигә сөз қилған Пәрвәрдигарни: «Сән мени көргүчи Тәңридурсән» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Шуниң билән у қудуқ: «Бәәр-лаһай-рой» дәп аталди. У Қадәш билән Бәрәд шәһириниң арилиғидидур.    ");
INSERT INTO uigcyr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Һәҗәр Абрамға бир оғул туғуп бәрди. Абрам Һәҗәр униңға туғуп бәргән оғлиға Исмаил дәп ат қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Һәҗәр Абрамға Исмаилни туғуп бәргәндә Абрам сәксән алтә яшта еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Абрам тохсән тоққуз яшқа киргәндә, Пәрвәрдигар Абрамға көрүнүп униңға: — Мән Қадир Тәңридурмән. Сән Мениң алдимда меңип, камил болғин.    ");
INSERT INTO uigcyr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Мән Өзүм билән сениң араңда әһдәмни бекитип, сени интайин зор көпәйтимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Абрам өзини ташлап йүзини йәргә йеқип ятти; Худа униң билән йәнә сөзлишип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Өзүмгә кәлсәм, мана, Мениң әһдәм сән билән түзүлгәндур: — Сән нурғун әл-милләтләрниң атиси болисән.    ");
INSERT INTO uigcyr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Шуниң үчүн сениң исмиң буниңдин кейин Абрам аталмайду, бәлки исмиң Ибраһим болиду; чүнки Мән сени нурғун әл-милләтләрниң атиси қилдим. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Мән сени интайин зор көпәйтимән; шуниң билән сәндин көп әл-қовмларни пәйда қилимән, пуштуңдин падишалар чиқиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Мән сән вә сәндин кейинки нәслиңниң Худаси болуш үчүн Өзүм сән вә сәндин кейинки нәслиңниң арисида әбәдий әһдә сүпитидә бу әһдәмни тикләймән; ");
INSERT INTO uigcyr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Мән саңа вә сәндин кейинки нәслиңгә сән һазир мусапир болуп турған бу зиминни, йәни пүткүл Қанаан зиминини әбәдий бир мүлүк сүпитидә ата қилимән; вә Мән уларниң Худаси болимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Андин Худа Ибраһимға йәнә: — Сән өзүң Мениң әһдәмни тутқин, өзүң вә сәндин кейинки нәслиңму әвлаттин-әвлатқа буни тутуши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Мән сән билән вә сәндин кейинки нәслиң билән түзгән, силәрниң тутушуңлар керәк болған әһдәм шуки, араңлардики һәр бир әркәк хәтнә қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Шуниң билән силәр хәтнилигиңларни кесиветишиңлар керәк; бу Мән билән силәрниң араңлардики әһдиниң бәлгүси болиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Барлиқ әвлатлириңлар, нәсилдин-нәсилгә араңларда, мәйли өйдә туғулғанлар болсун, яки әвладиңлардин болмай ятлардин пулға сетивелинғанлар болсун, һәммә әркәк сәккиз күнлүк болғанда хәтнә қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Өйүңдә туғулғанлар билән пулуңға сетивалғанларниң һәммиси хәтнә қилиниши керәк. Шундақ қилғанда, Мениң әһдәм тәнлириңларда орнап, әбәдий бир әһдә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Лекин хәтнилиги туруп, техи хәтнә қилинмиған һәр бир әркәк Мениң әһдәмни бузған һесаплинип, үзүп ташлиниду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Худа Ибраһимға йәнә сөз қилип: — Аялиң Сарайни әнди Сарай дәп атимиғин, бәлки исми Сараһ болсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Мән униңға бәхит-бәрикәт берип, униңдинму саңа бир оғул беримән. Мән дәрвәқә уни бәрикәтләймән; шуниң билән у әл-милләтләрниң аниси болиду; хәлиқләрниң падишалириму униңдин чиқиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ибраһим йәнә өзини йәргә етип дүм йетип күлүп кәтти вә көңлидә: «Йүз яшқа киргән адәмму балилиқ болаларму? Тохсән яшқа киргән Сараһму бала туғарму?!», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ибраһим Худаға: — Аһ, Исмаил алдиңда яшиса еди! деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Худа униңға: — Яқ, аялиң Сараһ җәзмән саңа бир оғул туғуп бериду. Сән униңға «Исһақ» дәп ат қойғин. Мән униң билән өз әһдәмни түзимән; бу униңдин кейин келидиған нәсли билән бағлиған әбәдий бир әһдә сүпитидә болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Исмаилға кәлсәк, униң тоғрисидики дуайиңни аңлидим. Мана, Мән уни бәрикәтләп, нәслини көпәйтип, интайин зор көпәйтимән. Униң пуштидин он икки әмир чиқиду; Мән уни улуқ бир хәлиқ қилимән.    ");
INSERT INTO uigcyr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Бирақ әһдәмни болса Мән келәр жили дәл мошу вақитта Сараһ саңа туғуп беридиған оғул — Исһақ билән түзимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Худа Ибраһим билән сөзлишип болуп, униң йенидин жуқуриға чиқип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Шуниң билән шу күнила Ибраһим өз оғли Исмаилни, өз өйидә туғулғанлар вә пулға сетивалғанларниң һәммисини, йәни униң өйидики барлиқ әркәкләрни елип, Худа униңға ейтқандәк уларниң хәтнилигини кесип хәтнә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ибраһимниң хәтнилиги кесилип, хәтнә қилинғанда, тохсән тоққуз яшқа киргән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Униң оғли Исмаилниң хәтнилиги кесилип, хәтнә қилинғанда, он үч яшта еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Ибраһим билән униң оғли Исмаил дәл шу күнниң өзидә хәтнә қилинди вә шундақла униң өйидики һәммә әр кишиләр, мәйли өйидә туғулған болсун яки яттин пулға сетивелинғанлар болсун, һәммиси униң билән биллә хәтнә қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Пәрвәрдигар Мамрәдики дубзарлиқниң йенида Ибраһимға көрүнди; бу күн әң иссиған вақит болуп, у өз чедириниң ишигидә олтиратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","У бешини көтирип нәзәр селивиди, мана униң удулида үч киши өрә туратти. Уларни көрүп у чедириниң ишигидин қопуп, уларниң алдиға жүгүрүп берип, йәргә тәккидәк тазим қилип: ");
INSERT INTO uigcyr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","— и Рәббим, әгәр пеқир нәзәрлиридә илтипат тапқан болсам, өтүнимәнки, қуллириниң йенидин өтүп кәтмигәйла; ");
INSERT INTO uigcyr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","азғина су кәлтүрүлсун, силәр путлириңларни жуюп дәрәқниң тегидә арам еливелиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Силәр өз қулуңларниң йенидин өткән екәнсиләр, мән бир чишләм нан елип чиқай, силәр һардуқуңларни чиқирип, андин өтүп кәткәйсиләр, деди. Улар җавап берип: — Ейтқиниңдәк қилғин, девиди, ");
INSERT INTO uigcyr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ибраһим чедириға Сараһниң қешиға жүгүрүп кирип, униңға: — Үч дас есил ундин тез хемир жуғуруп тоғач әткин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Андин Ибраһим кала падисиға жүгүрүп берип, юмран убдан бир мозайни таллап, чакириға тапшурди; у буни тезла тәйяр қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","9","Андин Ибраһим сериқ май, сүт вә тәйярлатқан мозайни елип келип, уларниң алдиға тутуп, өзи дәрәқниң тегидә уларниң алдида өрә турди; улар улардин йеди. Улар униңдин: аялиң Сараһ нәдә, дәп соривиди, у җавап берип: — Мана, чедирда, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Бириси: — Мән келәр жили мошу вақитта қешиңға җәзмән қайтип келимән, вә мана у вақитта аялиң Сараһниң бир оғли болиду, — деди. Сараһ болса униң кәйнидики чедирниң ишигидә туруп, буларни аңлавататти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ибраһим билән Сараһ иккиси яшинип, қерип қалған еди; Сараһта аял кишиләрдә болидиған адәт көрүш тохтап қалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Шуңа Сараһ өз ичидә күлүп: — Мән шунчә қерип кәткән турсам, растинла ләззәт көрәләрмәнму? Еримму қерип кәткән турса? — дәп хиял қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Пәрвәрдигар Ибраһимға: — Сараһниң: «Мән қерип кәткән турсам, растинла бала туғармәнму?» дәп күлгини немиси? ");
INSERT INTO uigcyr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Пәрвәрдигарға мүмкин болмайдиған тилсимат иш барму? Бекиткән вақитта, йәни келәр жили дәл бу чағда қайтип келимән вә у вақитта Сараһниң бир оғли болиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Амма Сараһ қорқуп кетип: — Күлмидим, дәп инкар қилди. Лекин У: — Яқ, сән күлдүң, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Андин бу затлар у йәрдин қопуп, Содом тәрәпкә нәзирини ағдурди. Ибраһимму уларни узитип, улар билән биллә маңди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Пәрвәрдигар: — Мән қилидиған ишимни Ибраһимдин йошурсам боламду? ");
INSERT INTO uigcyr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Чүнки Ибраһимдин улуқ вә күчлүк бир әл чиқиду вә шуниңдәк йәр йүзидики барлиқ әл-милләтләр у арқилиқ бәхит-бәрикәткә муйәссәр болидиған турса? ");
INSERT INTO uigcyr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Чүнки Мән уни билип таллиғанмән; у чоқум өз балилирини вә униң өйидикиләрни өзигә әгәштүрүп, уларға Пәрвәрдигарниң йолини тутуп, һәққанийлиқни вә адаләтни жүргүзүшни үгитиду. Буниң билән Мәнки Пәрвәрдигар Ибраһим тоғрилиқ қилған вәдәмни әмәлгә ашуримән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Андин Пәрвәрдигар мундақ деди: — «Содом вә Гоморра тоғрилиқ көтирилгән дад-пәряд наһайити күчлүк, уларниң гунайи интайин еғир болғини үчүн, ");
INSERT INTO uigcyr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Мән һазирла чүшимән, қилмишлири растинла шу дад-пәрядлардин Маңа мәлум болғандәк шунчә рәзилму, билип бақай; унчә рәзил болмиғандиму, Мән уни билишим керәк». ");
INSERT INTO uigcyr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Шуниң билән бу кишиләр у йәрдин қозғилип, Содом тәрәпкә йол алди. Лекин Ибраһим йәнила Пәрвәрдигарниң алдида өрә туратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ибраһим йеқин берип: — Сән растинла һәққанийларни рәзилләр билән қошуп һалак қиламсән? ");
INSERT INTO uigcyr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Шәһәрдә әллик һәққаний киши бар болуши мүмкин; Сән растинла шу җайни һалак қиламсән, әллик һәққаний киши үчүн у җайни кәчүрүм қилмамсән? ");
INSERT INTO uigcyr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Яқ, яқ. Бу иш Сәндин нери болғай! Һәққанийларни рәзилләргә қошуп өлтүрүп, һәққанийларға рәзилләргә охшаш муамилә қилиш Сәндин нери болғай! Пүткүл җаһанниң сорақчиси адаләт жүргүзмәмду? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Пәрвәрдигар җавап берип: — Әгәр Мән Содом шәһиридә әллик һәққанийни тапсам, улар үчүн пүткүл җайни аяп қалимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Андин Ибраһим җавап берип: — Мана мән пәқәт топа билән күлдин ибарәт болсамму, мән Егәм билән сөзләшкили йәнә петиналидим. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Мабада шу әллик һәққанийдин бәш киши кам болса, Сән бу бәш кишиниң кам болғини үчүн пүткүл шәһәрни йоқитамсән? — деди. У: — Әгәр Мән шу йәрдә қириқ бәшни тапсамму, уни йоқатмаймән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ибраһим Униңға сөзини давам қилип: — Шу йәрдә қириқ кишила тепилиши мүмкин, девиди, Пәрвәрдигар: — Бу қириқи үчүн уни йоқатмаймән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","У йәнә сөз қилип: И Егәм, хапа болмиғайсән, мән йәнә сөз қилай. Шу йәрдә оттузи тепилиши мүмкин? — деди. У: — Әгәр Мән у йәрдә оттузни тапсамму, йоқатмаймән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","У йәнә сөз қилип: — Мана әнди мән Егәм билән сөзләшкили җүръәт қилдим; шу йәрдә жигирмиси тепилиши мүмкин, — деди. Пәрвәрдигар сөз қилип: бу жигирмиси үчүн у йәрни йоқатмаймән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","У сөзләп: — И Егәм, хапа болмиғай, мән пәқәт мошу бир қетимла сөз қилай! Шу йәрдә они тепилиши мүмкин, девиди, у җавап берип: — Мән они үчүн уни йоқатмаймән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Пәрвәрдигар Ибраһим билән сөзлишип болғандин кейин кәтти; Ибраһимму өз җайиға қайтип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Икки пәриштә кәчтә Содомға йетип кәлди; шу чағда Лут Содомниң дәрвазисида олтиратти. Лут уларни көрүпла орнидин туруп, алдиға чиқип йүзи йәргә тәккидәк тазим қилип: ");
INSERT INTO uigcyr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","— Мана, әй ғоҗилирим, кәминилириниң өйигә чүшүп путлириңларни жуюп қонуп қалғайсиләр; андин әтә сәһәр қопуп йолға чиқсаңларму болиду, девиди, булар җававән: — Яқ, биз шәһәр мәйданида кәчләймиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Амма у уларни чиң тутувиди, ахир улар униң билән берип өйигә кирди. У уларға дәстихан селип, петир тоғачларни пиширип бәрди, улар ғизаланди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Улар техи ятмиған еди, шәһәрдикиләр, йәни Содомниң әркәклири, яш, қери һәммиси һәр қайси мәһәллиләрдин келип өйни қоршивалди; ");
INSERT INTO uigcyr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","улар Лутни чақирип униңға: — Бүгүн кәчтә сениңкигә киргән адәмләр қени? Уларни бизгә чиқирип бәр, биз улар билән йеқинчилиқ қилимиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Лут дәрвазиниң алдиға, уларниң қешиға чиқип, ишикни йепиветип, ");
INSERT INTO uigcyr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","уларға: — Әй бурадәрлирим, мундақ рәзилликни қилмаңлар! ");
INSERT INTO uigcyr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Мана, техи һеч әр билән биллә болмиған икки қизим бар; уларни силәргә чиқирип берәй. Улар билән халиқиниңларни қилиңлар. Амма бу адәмләр өгүзмниң сайиси астиға киргән екән, силәр уларни һеч немә қилмаңлар! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Лекин улар җавап берип: «Нери тур!» дегиничә, йәнә: — Бу йәрдә турушқа кәлгән бу мусапир һаким болмақчимикән? Әнди саңа уларға қилғандинму бәттәр яманлиқ қилимиз! — дәп Лутни қистап, ишикни чеқишқа бастуруп кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Амма у икки киши қоллирини узитип Лутни өйгә өз қешиға тартип әкиривелип, ишикни тақивалди ");
INSERT INTO uigcyr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","вә өйниң дәрвазисиниң алдидики адәмләрни кичигидин тартип чоңиғичә корлуққа муптила қилди; шуниң билән улар дәрвазини издәп, һалидин кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Андин иккәйлән Лутқа: — Мошу йәрдә йәнә бирәр кимиң барму? Күйоғул, оғул яки қизлириң вә яки шәһәрдә башқа адәмлириң болса уларни бу йәрдин елип кәткин! ");
INSERT INTO uigcyr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Чүнки биз бу йәрни йоқитимиз; чүнки улар тоғрилиқ көтирилгән дад-пәряд Пәрвәрдигарниң алдида интайин күчлүк болғач, Пәрвәрдигар бизни уни йоқитишқа әвәтти, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Шуниң билән Лут ташқириға чиқип, қизлирини алидиған болғуси күйоғуллириниң қешиға берип: «Әнди қопуп бу йәрдин чиқип кетиңлар; чүнки Пәрвәрдигар шәһәрни йоқитиду» — деди. Амма у болғуси күйоғуллириниң нәзиригә чақчақ қилғандәк көрүнди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Таң атқанда, пәриштиләр Лутни алдиритип: — Әнди қопуп аялиң билән қешиңдики икки қизиңни алғин; болмиса шәһәрниң қәбиһлигигә четилип қелип, һалак болисән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Амма у техичә арисалди болуп турғанда, Пәрвәрдигар униңға рәһим қилғанлиғи үчүн, у иккилән Лутниң қолини, аялиниң қолини вә икки қизиниң қоллирини тутуп, уларни шәһәрниң сиртиға әчиқип, орунлаштуруп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Уларни чиқарғандин кейин шу иш болдики, улардин бири униңға: — Җениңни елип қач, һалак болмаслиғиң үчүн кәйниңгә қаримай, түзләңликтики һеч йәрдә тохтимай, таққа қачқин! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Лекин Лут уларға: — Ундақ болмиғай, әй ғоҗам, өтүнүп қалай! ");
INSERT INTO uigcyr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Мана, кәминәң көзүңдә илтипат тапти, җенимни қутқуздуң, маңа зор мәрһәмәт көрсәттиң; амма мән таққа қачалмаймән; ундақ қилсам, маңа бирәр апәт чүшүп, өлүп кетәрмәнмекин. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Қара, аву шәһәргә қечип барса болғидәк наһайити йеқин екән, шундақла кичик шәһәр екән! Өтүнүп қалай, мениң шу йәргә қечишимға йол қойғайсән! У кичик шәһәр әмәсму?! Җеним шу йәрдә аман қалиду! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Пәриштә униңға җавап берип: — Хәйр, бу иштиму саңа мақул болай, сән ейтқан шу шәһәрни вәйран қилмай. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Әнди у йәргә тездин қечип барғин; чүнки сән шу йәргә йетип бармиғичә һеч иш қилалмасмән, — деди. Шуңа у шәһәрниң исми «Зоар» дәп аталған. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Лут Зоарға йетип барғанда күн нури йәр йүзигә чечилған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Шу чағда Пәрвәрдигар Пәрвәрдигардин Содом билән Гоморраниң үстигә әрштин гуңгут вә от яғдуруп,    ");
INSERT INTO uigcyr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","шу шәһәрләрни, пүткүл түзләңликни һәмдә шәһәрләрдики барлиқ аһалиләр вә йәрдин үнгәнләрни қошуп бәрбат қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Лекин Лутниң арқисидин маңған аяли кәйнигә қаривиди, туз түврүккә айлинип қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Әтиси таң сәһәрдә, Ибраһим қопуп илгири Пәрвәрдигарниң алдида турған җайға чиқип, ");
INSERT INTO uigcyr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Содом билән Гоморра тәрәпкә, шундақла түзләңликниң һәммә йеригә нәзәр селивиди, мана, йәр йүзидин хумданниң түтүнидәк түтүн өрләватқинини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Амма шундақ болдики, Худа у түзләңликтики шәһәрләрни вәйран қилғанда, У Ибраһимни есигә елип, Лут турған шәһәрләрни бәрбат қилғанда уни балаю-апәтниң ичидин чиқирип қутқузди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Амма Лут Зоар шәһиридә туруштин қорққачқа, Зоардин кетип, таққа чиқип, икки қизи билән шу йәрдә маканлашти. У икки қизи билән бир өңкүрдә турди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Әнди чоң қиз кичигигә: — Атимиз болса қерип кәтти; дунияниң қаидә-йосуни бойичә бу жутта бизгә йеқинчилиқ қилидиған һеч әр киши қалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Қени, атимизни шарап билән мәс қилип қоюп, униң билән биллә ятайли; шундақ қилсақ, биз пәрзәнт көрүп атимизниң уруғини қалдуралаймиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Шуниң билән улар у кечиси атисиға шарап ичкүзүп мәст қилип қоюп, чоң қизи кирип атиси билән ятти. Лекин Лут униң кирип ятқининиму, қопуп кәткининиму һеч сәзмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Әтиси шундақ болдики, чоңи кичигигә: — Мана, мән ахшам атам билән яттим; бүгүн кәчтиму униңға йәнә шарап ичкүзәйли; шуниң билән сән кирип униң билән ятқин; шундақ қилип, һәр иккимиз пәрзәнт көрүп атимизниң нәслини қалдуралаймиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Шуниң билән улар у кечиси атисиға шарап ичкүзүп мәст қилип қоюп, кичик қизи орнидин туруп униң билән биллә ятти. Амма Лут униң кирип ятқининиму, қопуп кәткининиму һеч сәзмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Шундақ қилип, Лутниң иккила қизи өз атисидин һамилдар болуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Чоңи болса оғул туғуп, униң етини Моаб қойди; у бүгүнки Моабийларниң атисидур. ");
INSERT INTO uigcyr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Кичигиму оғул туғуп, униң етини Бән-Амми қойди. У бүгүнки Аммонийларниң атисидур. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ибраһим у йәрдин чиқип, җәнуп тәрәптики Нәгәвгә көчүп келип, Қадәш билән Шурниң арилиғида туруп қалди; бир мәзгилдин кейин Гәрарда олтирақлашти. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Шу йәрдә Ибраһим аяли Сараһ тоғрисида: «У мениң сиңлимдур», дегән еди. Шуниң билән Гәрарниң падишаси Абимәләк адәм әвәтип, Сараһни өзигә хотун болушқа еливалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Лекин бир күни кечиси чүшидә Худа Абимәләккә келип униңға: — Мана, сән өзүңгә еливалған аял сәвәвидин әнди өлгән адәмдурсән; чүнки у башқа бирисиниң аялидур — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Амма Абимәләк униңға техи йеқинчилиқ қилмиған еди. У Худаға: — И Рәб, һәққаний бир хәлиқниму һалак қиламсән? ");
INSERT INTO uigcyr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","У өзиму маңа: «У мениң сиңлим» дәп ейтмидиму? Йәнә келип, бу аялму «У мениң акам», дәп ейтқан еди. Мән болсам сап көңлүм вә дурус нийитим билән бу ишни қилдим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Худа чүшидә униңға йәнә: — Бу ишни сап көңүл билән қилғиниңни билимән; шу сәвәптин Мән сени алдимда гуна қилиштин тосуп, униңға тегишиңгә қоймидим. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Әнди у кишиниң аялини өзигә қайтуруп бәр; чүнки у Пәйғәмбәр, у сениң һәққиңдә дуа қилиду вә сән тирик қалисән. Әгәр уни яндуруп бәрмисәң шуни билип қойғинки, сән вә һәммә адәмлириң қошулуп җәзмән өлисиләр, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Абимәләк әтигән таң сәһәрдә қопуп, һәммә хизмәткарлирини чақирип, бу сөзләрниң һәммисини уларниң қулақлириға салди; бу адәмләр наһайити қорқушуп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Андин Абимәләк Ибраһимни чақирип униңға: — Бу бизгә немә қилғиниң? Мән саңа зади немә гуна қилдим, сән мән вә падишалиғимға еғир бир гунани жүкләп қойдуң? Маңа қилмайдиған ишларни қилдиң! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Абимәләк Ибраһимға йәнә: — Сән зади бизниң немә ишимизни көргиниң үчүн мошу ишни қилдиң? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ибраһим җавап берип: — «Бу йәрдә шүбһисизки һеч ким Худадин қорқмайдикән, улар мени аялим түпәйлидин өлтүрүветиду», дәп ойлиған едим. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Әмәлийәттә, униң мениң сиңлим екәнлиги раст, лекин у мениң ата бир, ана бөләк сиңлим; кейин у мениң аялим болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Лекин Худа мени атамниң өйидин чиқирип сәргәрданлиққа жүргүзгинидә, мән аялимға: — Биз қәйәргила барсақ, сән маңа шундақ шапаәт көрсәткәйсәнки, мениң тоғрамда: «Бу мениң акам болиду», дегин, — дәп ейтқан едим — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Андин Абимәләк қой-калилар, қуллар вә дедәкләрни елип уларни Ибраһимға бәрди вә аяли Сараһниму униңға қайтуруп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Абимәләк: — Мана мениң зиминим болса алдиңда турупту; көзүңгә қайси йәр яқса шу йәрдә турғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","У Сараһқа: «Мана, мән акаңға миң күмүч тәңгә бәрдим; мана булар өз йениңдикиләр, шундақла һәммә адәмләрниң көз алдида уятни япқучи болиду; шуниң билән сән һәр қандақ дағ-әйиптин халас болисән». ");
INSERT INTO uigcyr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ибраһим Худаға дуа қилди, Худа Абимәләк, аяли вә кенизәклирини сақайтти; андин улар йәнә бала туғалайдиған болди; чүнки Пәрвәрдигар Ибраһимниң аяли Сараһ түпәйлидин Абимәләкниң өйидики һәммә хотунларниң балиятқулирини етип қойған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Әнди Пәрвәрдигар вәдә қилғинидәк Сараһни йоқлиди; Пәрвәрдигар Сараһқа дегинидәк қилди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Сараһ һамилдар болуп, Ибраһим қериғанда Худа униңға бекиткән вақитта бир оғул туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ибраһим өзигә төрәлгән оғли, йәни Сараһ униңға туғуп бәргән оғлиниң исмини Исһақ қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Андин Ибраһим Худа униңға буйруғинидәк өз оғли Исһақ туғулуп сәккизинчи күни хәтнә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Оғли Исһақ туғулған чағда, Ибраһим йүз яшта еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Сараһ: «Худа мени күлдүрүвәтти; һәр ким бу ишни аңлиса, мән билән тәң күлүшиду», деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","У йәнә: — Кимму Ибраһимға: «Сараһ бала емитидиған болиду!» дәп ейталайтти? Чүнки у қериғанда униңға бир оғул туғуп бәрдим! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Бала чоң болуп, әмчәктин айрилди. Исһақ әмчәктин айрилған күни Ибраһим чоң зияпәт өткүзүп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Амма Сараһ мисирлиқ Һәҗәрниң Ибраһимға туғуп бәргән оғулниң Исһақни мәсқирә қиливатқинини көрүп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Шуниң билән у Ибраһимға: — Бу дедәк билән оғлини һайдивәт! Чүнки бу дедәкниң оғли мениң оғлум Исһақ билән тәң варис болса болмайду!, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Сараһниң бу сөзи Ибраһимға толиму еғир кәлди; чүнки Исмаилму униң оғли-дә! ");
INSERT INTO uigcyr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Лекин Худа Ибраһимға: — Балаң вә дедигиң вәҗидин бу сөз саңа еғир кәлмисун, бәлки Сараһниң саңа дегәнлириниң һәммисигә қулақ салғин; чүнки Исһақтин болғини сениң нәслиң һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Лекин дедәкниң оғлидинму бир хәлиқ-милләт пәйда қилимән, чүнки уму сениң нәслиң, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Әтиси таң сәһәрдә Ибраһим қопуп, нан билән бир тулум суни елип Һәҗәргә берип, өшнисигә йүдкүзүп, балини униңға тапшуруп, иккисини йолға селип қойди. Һәҗәр кетип, Бәәр-Шебаниң чөлидә кезип жүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Әнди тулумдики су түгәп кәткән еди; Һәҗәр балини бир чатқалниң түвигә ташлап қоюп, өз-өзигә: «Балиниң өлүп кетишигә қарап чидимаймән» дәп, бир оқ етимчә жираққа берип, удулида олтарди. У удулида олтирип, пәряд көтирип жиғлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Худа оғулниң жиға авазини аңлиди; шуниң билән Худаниң Пәриштиси асмандин Һәҗәрни чақирип униңға: — Әй Һәҗәр, саңа немә болди? Қорқмиғин; чүнки Худа оғулниң йиға авазини ятқан йеридин аңлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Әнди қопуп, қолуң билән балини йөләп турғуз; чүнки Мән уни улуқ бир әл-милләт қилимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Шуан Худа Һәҗәрниң көзлирини ачти, у бир қудуқни көрди. У берип тулумға су толдуруп, оғулға ичкүзди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Худа у бала билән биллә болди; у өсүп чоң болди. У чөлдә яшап, мәргән болуп йетишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","У Паран чөлидә турди; шу вақитларда аниси униңға Мисир зиминидин бир қизни хотунлуққа елип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","У вақитларда шундақ болдики, Абимәләк вә униң ләшкәр беши Фикол келип Ибраһимға: — Қилған һәммә ишлириңда, Худа сениң билән биллидур. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Әнди сән дәл мошу йәрдә маңа, оғлумға вә нәврәмгә хиянәт қилмаслиққа Худаниң намида қәсәм қилип бәргәйсән; мән саңа көрситип кәлгән меһриванлиғимдәк, сәнму маңа вә сән һазир туруватқан жутқа меһриванлиқ қилғайсән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ибраһим: Қәсәм қилип берәй, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Андин Ибраһим Абимәләкниң чакарлири тартивалған бир қудуқ тоғрисида Абимәләкни әйиплиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Абимәләк: — Бу ишни қилған кишини билмәймән; сән бу ишни маңиму ейтмапсән; мән бу ишни пәқәт бүгүнла аңлишим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ибраһим қой-кала елип Абимәләккә тәқдим қилди; андин улар иккилиси әһдә қилишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ибраһим йәнә падидин йәттә чиши қозини бир тәрәпкә айрип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Абимәләк Ибраһимдин: — Сән бир тәрәпкә айрип қойған бу йәттә чиши қозиниң немә мәнаси бар? — дәп соривиди, ");
INSERT INTO uigcyr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","у: — Мениң бу қудуқни колиғинимни етирап қилғиниңға гувалиқ сүпитидә бу йәттә чиши қозини қолумдин қобул қилғайсән, — дәп җавап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Бу иккиси шу йәрдә қәсәм қилишқанлиғи үчүн, у шу җайни «Бәәр-Шеба» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Шу тәриқидә улар Бәәр-Шебада әһдә қилишти. Андин Абимәләк вә униң ләшкәр беши Фикол қозғилип, Филистийләрниң зиминиға йенип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ибраһим Бәәр-Шебада бир түп жулғунни тикип, у йәрдә Әбәдий Тәңри болған Пәрвәрдигарниң намиға нида қилип ибадәт қилди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ибраһим Филистийләрниң зиминида узун вақитқичә туруп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Бу ишлардин кейин шундақ болдики, Худа Ибраһимни синап униңға: — Әй Ибраһим! деди. У: мана мән! — дәп җавап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","У: — Сән оғлуңни, йәни сән сөйидиған ялғуз оғлуң Исһақни елип, Мория жутиға берип, шу йәрдә, Мән саңа ейтидиған тағларниң бириниң үстидә уни көйдүрмә қурбанлиқ сүпитидә сунғин, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Әтиси Ибраһим сәһәр қопуп, ешигини тоқуп, жигитлиридин иккилән билән Исһақни биллә елип, көйдүрмә қурбанлиқ үчүн отун йерип, Худа униңға ейтқан йәргә қарап маңди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Үчинчи күни Ибраһим бешини көтирип қарап, жирақтин у йәрни көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ибраһим жигитлиригә: — Силәр ешәк билән мошу йәрдә туруп туруңлар. Мән балам билән у йәргә берип, сәҗдә қилип, андин қешиңларға йенип келимиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Шуниң билән Ибраһим көйдүрмә қурбанлиққа керәклик отунни елип, оғли Исһаққа йүдкүзүп, өзи қолиға пичақ билән отни елип, иккиси биллә жүрүп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Исһақ атиси Ибраһимға: — Әй ата! девиди, у униңға җавап берип: — Мана мән, оғлум, деди. У униңдин: — Мана от билән отунғу бар, амма көйдүрмә қурбанлиқ болидиған қоза қени? — дәп соривиди, ");
INSERT INTO uigcyr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ибраһим җавап берип: — Әй оғлум, Худа Өзи Өзигә көйдүрмә қурбанлиқ қозини тәминләйду, — деди. Андин иккиси биргә йолини давамлаштурди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ахирида улар Худа Ибраһимға ейтқан җайға йетип кәлди. Ибраһим у йәрдә қурбангаһ ясап, үстигә отунни тизип қойди. Андин у оғли Исһақни бағлап, уни қурбангаһдики отунниң үстидә ятқузди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Андин Ибраһим қолини узитип, оғлини боғузлиғили пичақни алди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Шуан Пәрвәрдигарниң Пәриштиси асмандин уни чақирип униңға: — Ибраһим, Ибраһим! — дәп вақириди. У: — Мана мән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","У униңға: — Сән балиға қолуңни тәккүзмигин, уни һеч немә қилмиғин; чүнки Мән сениң Худадин қорққанлиғиңни билдим; чүнки сениң оғлуңни, йәни ялғуз оғлуңни Мәндин айимидиң, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ибраһим бешини көтирип қаривиди, мана, арқисида мүңгүзлири чатқалға чирмишип қалған бир қочқарни көрди. Ибраһим берип қочқарни елип, уни оғлиниң орнида көйдүрмә қурбанлиқ қилип сунди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Шуниң билән Ибраһим шу җайға «Яһвәһ-Йирәһ» дәп ат қойди. Шуңа кишиләр: «Пәрвәрдигарниң теғида тәминлиниду» дегән бу сөз бүгүнгә қәдәр ейтилип келиватиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Пәрвәрдигарниң Пәриштиси асмандин Ибраһимни иккинчи қетим чақирип униңға: — ");
INSERT INTO uigcyr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Сән өз оғлуңни, йәни ялғуз оғлуңни айимай бу ишни қилғиниң үчүн Мән Өзүм билән қәсәм қилимәнки, дәйду Пәрвәрдигар, ");
INSERT INTO uigcyr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","— Мән сени зор бәрикәтләп, нәслиңни асмандики юлтузлардәк нурғун көпәйтип, деңиз саһилидики қумдәк ғолдитимән; нәслиң болса дүшмәнлириниң дәрвазилириға егә болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Сән Мениң авазимға қулақ салғиниң үчүн йәр йүзидики барлиқ әл-жутлар нәслиңниң нами билән өзлири үчүн бәхит-бәрикәт тиләйду, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Андин Ибраһим жигитлириниң қешиға йенип барди. Улар һәммиси орнидин турушуп Бәәр-Шебаға йол алди. Ибраһим Бәәр-Шебада туруп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Бу ишлардин кейин Ибраһимға: «Мана Милкаһму иниң Наһорға бир қанчә оғул туғуп берипту», дегән хәвәр йәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Улар болса тунҗа оғли уз, униң иниси Буз вә Арамниң атиси болған Кәмуәл, ");
INSERT INTO uigcyr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","андин Кәсәд, Хазо, Пилдаш, Йидлаф вә Бетуәл дегән оғуллар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Бетуәлдин Ривкаһ төрәлди). Бу сәккизини Милкаһ Ибраһимниң иниси Наһорға туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Шуниңдәк униң кенизиги Рәумаһму Тебаһ, Гаһам, Тахаш вә Маакаһ дегәнләрни туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Сараһ бир йүз жигирмә йәттә яшқичә өмүр көрди. Бу Сараһниң өмриниң жиллири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Сараһ Қанаан зиминидики Кириат-Арба, йәни Һебронда вапат болди. Ибраһим берип Сараһ үчүн матәм тутуп жиға-зерә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ибраһим өз мәрһумәсиниң йенидин қопуп, Һиттийларға сөз қилип: ");
INSERT INTO uigcyr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","— Мән болсам араңларда мусапир меһман, халас; силәр әнди араңлардин маңа бир йәрлик бериңлар; шуниң билән мән бу мәрһумәмни алдимда көрүнүп турмисун үчүн елип берип дәпнә қилай, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Һиттийлар Ибраһимға җавап берип: — И ғоҗам, бизгә қулақ салғайла! Сили аримизда Худаниң бир шаһзадиси һесаплинила! Аримиздики әң есил йәрликни таллап, шу йәрдә мәрһумәлирини дәпнә қилғайла! Мәрһумәлирини дәпнә қилишқа һеч қайсимиз өз йәрлигини силидин айимайду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ибраһим орнидин туруп, у зиминдики хәлиққә, йәни Һиттийларға тазим қилип, ");
INSERT INTO uigcyr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","уларға: — Әгәр мәрһумәмниң көз алдимда туривәрмәслиги үчүн, уни елип берип, дәпнә қилишимни рава көрсәңлар, ундақта сөзүмни аңлап мениң үчүн Зоһарниң оғли Әфронға сөз қилип, ");
INSERT INTO uigcyr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","униң етизиниң айиғида өзиниңки болған Макпелаһниң ғарини маңа беришини илтимас қилиңлар. У маңа буни силәрниң араңларда гөристан болушқа толуқ нәрхидә бәрсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Шу чағда Әфрон Һиттийлар арисида олтиратти. Шуниң билән һиттийлиқ Әфрон Һиттийларниң алдида, йәни шәһириниң дәрвазисидин киргүчиләрниң һәммисиниң алдида Ибраһимға җавап берип: — ");
INSERT INTO uigcyr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Йоқсу, әй ғоҗам, маңа қулақ салғайла. Бу етизлиқни, шундақла униңдики ғарни силигә берәй; уни өз хәлқим болған адәмләрниң алдида силигә бәрдим; өз мейитлирини дәпнә қилғайла, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Андин Ибраһим йәнә зимин хәлқи алдида тазим қилип, ");
INSERT INTO uigcyr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Шу зиминдики хәлиқниң қулақлири алдида Әфронға: — Илтимасимға қулақ салғайла; мән бу етизлиқниң нәрхи бойичә пул берәй, уни мәндин қобул қилғайла, андин мән мейитимни шу йәрдә дәпнә қилай, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Әфрон Ибраһимға җавап берип униңға: ");
INSERT INTO uigcyr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Әй ғоҗам, маңа қулақ салғайла; төрт йүз шәкәл күмүчкә ярайдиған бир етизлиқ, сили билән мениң арамда немә еди? Сили мейитлирини дәпнә қилғайла — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ибраһим Әфронниң сөзигә қошулди; андин Әфрон Һиттийлар алдида ейтқан бани, йәни шу чағдики сода өлчими бойичә төрт йүз шәкәл күмүчни таразида тартип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Шундақ қилип Мамрәниң удулидики Макпелаһқа җайлашқан Әфронниң етизлиғи, йәни етизлиқниң өзи, униңдики ғар, шундақла етизлиқниң ичи вә әтрапидики барлиқ дәрәқләрниң һәммиси ");
INSERT INTO uigcyr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Һиттийларниң көз алдида Ибраһимға тапшурулуп, йәни Әфронниң шәһириниң дәрвазисидин барлиқ киргүчиләрниң алдида униң мүлки қилип бекитилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Шуниңдин кейин Ибраһим аяли Сараһни Қанаан зиминидики Мамрә (йәни, Һеброн)ниң удулидики Макпелаһниң етизлиғиниң ғарида дәпнә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Шу тәриқидә у етизлиқ вә униңдики ғар Һиттийлар тәрипидин Ибраһимға гөристан болушқа тайин қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ибраһим қерип, йеши бир йәргә берип қалған еди; Пәрвәрдигар Ибраһимға һәр тәрәптә бәхит-бәрикәт ата қилған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ибраһим өйидики әң мөтивәр хизмәткари, өзиниң пүтүн мал-мүлкини башқуридиған ғоҗидарға: — Қолуңни янпашмниң астиға қойғин;    ");
INSERT INTO uigcyr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Мән сени асманларниң Худаси шундақла йәрниң Худаси болған Пәрвәрдигарниң нами билән қәсәм қилдуримәнки, сән мән һазир туруватқан бу Ⱪананийларниң арисидин оғлумға қиз елип бәрмәй, ");
INSERT INTO uigcyr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Бәлки өз жутумға, шундақла өз уруқ-туққанлиримниң қешиға берип, оғлум Исһаққа хотун елип бәргәйсән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Хизмәткари униңға: — Мабада у қиз мән билән бу жутқа кәлгили унимиса, ундақта өзлири чиққан шу жутқа оғуллирини яндуруп апирамдимән? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ибраһим униңға җавап берип: — Һези бол, оғлумни һәргиз шу йәргә яндуруп бармиғин! ");
INSERT INTO uigcyr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Мени атамниң өйи билән туғулған жутумдин йетәкләп елип кәлгүчи, йәни маңа сөз қилип: — «Сениң нәслиңгә бу жутни беримән», дәп маңа қәсәм қилған, асманниң Худаси болған Пәрвәрдигар Өз Пәриштисини алдиңға әвәтиду; шуниң билән сән у йәрдин оғлумға қиз елип келәләйсән. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Шундақтиму, әгәр қиз сән билән бу йәргә кәлгили унимиса, мән саңа қилдуридиған қәсәмдин халас болисән; амма оғлумни у йәргә һәргиз яндуруп бармиғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Шуниң билән хизмәткар қолини ғоҗиси Ибраһимниң янпишиниң астиға қоюп туруп, бу тоғрида униңға қәсәм қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Андин хизмәткар бу тоғрида ғоҗисиниң төгилиридин онни, шундақла ғоҗисиниң һәр хил есил нәрсилирини елип йолға чиқти; у Арам-Наһараим райониға сәпәр қилип, Наһорниң шәһиригә йетип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","У шәһәрниң сиртидики бир қудуқниң йенида төгилирини чөкүндурди: бу кәчқурун, қиз-аялларниң су тартқили чиқидиған чеғи еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","У дуа қилип: — Әй ғоҗам Ибраһимниң Худаси болған Пәрвәрдигар, өтүнимәнки, бүгүн мениң ишимни оңға тартқайсән, ғоҗам Ибраһимға шапаәт көрсәткәйсән. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Мана мән бу йәрдә қудуқниң бешида туруватимән вә шәһәр хәлқиниң қизлири бу йәргә су тартқили келиватиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Әнди шундақ болсунки, мән қайси қизға: «Комзикиңни чүшүрсәң, мән су ичивалсам боптикән!» десәм, у җавап берип: «Мана ичкин, мән төгилириңниму суғирип қояй», десә, у қиз сән қулуң Исһаққа бекиткиниңниң өзи болсун. Буниңдин сениң ғоҗам Ибраһимға шапаәт қилғиниңни биләләймән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","У техи сөзини түгәтмәйла, мана Ривкаһ козини мүрисидә көтирип чиқип кәлди; у болса Ибраһимниң иниси Наһорниң аяли Милкаһтин туғулған оғли Бетуәлниң қизи еди; ");
INSERT INTO uigcyr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Қиз интайин чирайлиқ болуп, һеч әр киши тәгмигән пак қиз еди. У қудуқниң бойиға чүшүп, комзикини толдуруп андин чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Хизмәткар униң алдиға жүгүрүп берип: — Өтүнүп қалай, комзикиңтин азғинә су отливалай, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","У җавап берип: — Ичкәйла, әй ғоҗам! дәпла, комзәкни дәрһал қолиға елип, униң су ичиши үчүн сунди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","У сүйидин униңға қанғичә ичкүзгәндин кейин: — Төгилиригиму қанғичә су ичкүзүп қояй, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Шуниң билән у дәрһал комзәктики суни олаққа төкүветип, йәнә қудуққа су тартқили жүгүрүп барди; у униң һәммә төгилиригә су тартип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","У киши униңға көзини тиккиничә җим-җит туруп, Пәрвәрдигарниң йолини оң қилған, қилмиғанлиғини билиш үчүн күтүвататти. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Төгиләр су ичип қанғанда, шундақ болдики, һелиқи киши йерим шәкәллик бир алтун бурун һалқиси билән икки қолиға он шәкәллик алтун биләйүзүкни чиқирип қизға берип униңға: ");
INSERT INTO uigcyr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Сән кимниң қизи болисән? Маңа дәп бәрсәң! Атаңниң өйидә бизгә қонғидәк җай барму? — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Қиз униңға: — Мән Милкаһниң Наһорға туғуп бәргән оғли Бетуәлниң қизи болимән, — деди, ");
INSERT INTO uigcyr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","йәнә униңға: — Бизниңкидә саман билән боғуз кәңри, силәргә қонғили җайму бар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Шуан бу адәм еңишип Пәрвәрдигарниң алдида сәҗдә қилип: ");
INSERT INTO uigcyr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Өз шапаити билән һоҗамдин вападарлиғини айимиған, ғоҗам Ибраһимниң Худаси болған Пәрвәрдигарға һәмдусана оқулғай! Пәрвәрдигар бу сәпиримдә мени ғоҗамниң қериндашлири турған өйгә башлап кәлди! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Қиз жүгүрүп берип, буларниң һәммисини анисиниң өйдикиләргә ейтип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Әнди Ривкаһниң Лабан дегән бир акиси бар еди. Лабан қудуқниң бешиға, у адәмниң қешиға жүгүрүп чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Чүнки у сиңлисиниң бурун һалқисини вә қоллиридики биләйүзүкләрни көрүп, һәмдә сиңлисиниң: у адәм маңа мундақ-мундақ деди, дегинини аңлап, у адәмниң қешиға барди. Мана, у киши қудуқниң йенида төгиләрниң қешида туратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Лабан униңға: — Әй Пәрвәрдигарниң бәхит-бәрикити ата қилинғучи, киргәйла! Немә үчүн ташқирида турдила? Мән өйни тәйярлап қойдум, төгиләргиму җай раслидим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","У адәм өйгә кирди; Лабан төгиләрдин жүкни чүшүрүп, төгиләргә саман билән боғуз берип, у кишиниң һәм униң һәмраһлириниң путлирини жуйғили су елип кәлди; ");
INSERT INTO uigcyr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","андин у кишиниң алдиға таам қоюлди; лекин у: — Мән гепимни демәй туруп таам йемәймән, — деди. Лабан җавап берип: — Ейтқайла, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","У: — Мән болсам Ибраһимниң хизмәткаримән; ");
INSERT INTO uigcyr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Пәрвәрдигар ғоҗамға көп бәхит-бәрикәт ата қилғачқа, у улуқ бир киши болди. У униңға қой билән кала, күмүч билән алтун, қул билән дедәкләрни, төгә билән ешәкләрни бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ғоҗамниң аяли Сараһ қериғанда ғоҗамға бир оғул туғуп бәргән еди. Ғоҗам оғлиға өзиниң барлиғини атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ғоҗам мени қәсәм қилдуруп: «Сән мән туруватқан зиминдики Ⱪананийларниң қизлиридин оғлумға хотун елип бәрмә, ");
INSERT INTO uigcyr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","бәлки җәзмән атамниң өйигә, өз туққанлиримниң қешиға берип, оғлумға хотун елип бәргәйсән», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","У вақитта мән ғоҗамға: «У қиз мән билән кәлгили унимисичу?» — десәм, ");
INSERT INTO uigcyr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","у маңа җавап берип: «Тутқан йоллирим униңға очуқ болған Пәрвәрдигарим Өз Пәриштисини сениң билән әвәтип, йолуңни оң қилиду. Бу тәриқидә сән мениң аилидикилирим арисидин, атамниң җәмәти ичидин оғлумға хотун елип берисән. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Шундақ қилип аиләмдикиләрниң қешиға йетип барғиниңда, сән мән қилдурған қәсәмдин халас болисән; улар саңа қизни бәрмисиму охшашла қәсәмдин халас болисән», — дегән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Шуңа мән бүгүн бу қудуқниң қешиға келип: — Әй, ғоҗам Ибраһимниң Худаси болған Пәрвәрдигар, әгәр сән бу сәпиримни оң қилсаң: — ");
INSERT INTO uigcyr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","мана мән су қудуғиниң йенида туруватимән; вә шундақ болсунки, су тартқили кәлгән қизға: «Комзикиңдин маңа бир отлам су бәргән болсаң», десәм, ");
INSERT INTO uigcyr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","у маңа: «Сән ичкин, төгилириңгиму су тартип берәй», дәп җавап бәрсә, ундақта бу қиз дәл Пәрвәрдигар Өзи ғоҗамниң оғли үчүн бекиткән қиз болсун, дәп дуа қилған едим. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Көңлүмдә техи сөзүм түгимәйла, мана, Ривкаһ комзәкни мүрисидә көтирип чиқип, қудуқниң бойиға чүшүп су тартти; мән униңға: — Илтипат қилип, маңа су ичкили қойсаң, девидим, ");
INSERT INTO uigcyr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","у дәрһал комзикини мүрисидин чүшүрүп: «Ичкәйла, төгилириниму суғирип қояй», деди. Шуниң билән мән ичтим; у төгилиримниму суғирип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Андин мән униңдин: — Кимниң қизи болисән, дәп сорисам, у җавап берип: — Мән Наһорниң Милкаһдин туғулған оғли Бетуәлниң қизи болимән, — деди. Шу чағда мән униң бурниға һалқа, қоллириға биләйүзүкләрни селип қойдум; ");
INSERT INTO uigcyr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","андин еңишип Пәрвәрдигарға сәҗдә қилдим; ғоҗамниң қериндишиниң қизини униң оғли үчүн елип кетишкә мениң йолумни оң қилғини үчүн, ғоҗамниң Худаси болған Пәрвәрдигарға һәмдусана ейттим. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Әнди силәр ғоҗамға ихлас қилип шапаәт көрситәйли десәңлар, буни маңа дәңлар. Әгәр халимисаңлар, униму маңа ейтиңлар, мән оң тәрәпкә яки сол тәрәпкә баримән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Әнди Лабан билән Бетуәл җавап берип: — Бу иш Пәрвәрдигардин болғач, силигә я ундақ я бундақ дейәлмәймиз. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Мана, Ривкаһ алдилирида туриду; уни елип кәткәйла. У Пәрвәрдигарниң дегинидәк өз ғоҗилириниң оғлиға хотун болсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ибраһимниң хизмәткари уларниң сөзлирини аңлап, йәргә еңишип, Пәрвәрдигарға сәҗдә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Андин, хизмәткар күмүч буюмларни, алтун буюмларни вә кийим-кечәкләрни чиқирип, буларни Ривкаһқа бәрди; у йәнә қизниң акиси вә анисиғиму қиммәтлик һәдийәләрни сунди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Андин у вә һәмраһлири билән биллә йәп-ичип, шу йәрдә қонуп қалди. Әтиси сәһәрдә қопуп, у уларға: мени ғоҗамниң қешиға йолға селип қоюңлар, девиди, ");
INSERT INTO uigcyr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Қизниң акиси билән аниси униңға: — Қиз бир қанчә күн яки он күн йенимизда турсун; андин барсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Амма у уларға: — Пәрвәрдигар мениң сәпиримни оң қилған екән, мени тосмаңлар; ғоҗамниң қешиға беришим үчүн мени йолға селип қоюңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Улар униңға: — Қизни чақирип, униң ағзидин аңлап бақайли, дәп ");
INSERT INTO uigcyr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ривкаһни чақирип униңдин: — Бу адәм билән барамсән? дәп соривиди, у: — Барай, дәп җавап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Шуниң билән улар сиңлиси Ривкаһни, униң баққан аниси, Ибраһимниң хизмәткари вә адәмлири билән қошуп йолға селип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","У вақитта улар Ривкаһқа бәхит тиләп: — Әй сиңлимиз, миңлиған он миңлиған адәмләрниң аниси болғайсән! Нәслиң дүшмәнлириниң дәрвазилириға егә болғай! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Шуниң билән Ривкаһ билән униң дедәклири орнидин туруп, төгиләргә минип, у кишигә әгишип маңди. Шундақ қилип хизмәткар Ривкаһни елип йолға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Исһақ Бәәр-лаһай-рой дегән җайдин байила қайтип кәлгән еди; чүнки у җәнуптики Нәгәвдә туратти; ");
INSERT INTO uigcyr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Исһақ кәчқурун истиқамәткә далаға чиққан еди; у бешини көтирип қариса, мана төгиләр келивататти. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","65","Ривкаһ бешини көтирип, Исһақни көрди; у дәрһал төгидин чүшүп, хизмәткардин: — Сәһрада бизниң алдимизға чиқиватқан бу киши ким болиду? — дәп сориди. Хизмәткар: — Бу ғоҗамдур! деди. Ривкаһ дәрһал чүмбилини тартип йүзини йепивалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Хизмәткар әнди қилған һәммә ишлирини Исһаққа ейтип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Исһақ қизни аниси Сараһниң чедириға башлап кирди; у Ривкаһни өз әмригә алди; у униң хотуни болди. У уни яхши көрүп қалди; бу тәриқидә Исһақ анисиниң вапатидин кейин тәсәлли тапти. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ибраһим Кәтураһ исимлиқ йәнә бир аялни алған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","У Ибраһимға Зимран, Йоқшан, Медан, Мидиян, Ишбак вә Шуаһни туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Йоқшандин Шеба билән Дедан төрәлди; Деданниң әвлатлири Ашурийлар, Летушийлар вә Леуммийлар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Мидиянниң оғуллири Әфаһ, Ефәр, Һанох, Абида вә Әлдааһ еди. Булар һәммиси Кәтураһниң әвлатлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ибраһим барлиғини Исһаққа ативәткән еди; ");
INSERT INTO uigcyr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ибраһим техи Һаят вақтида кичик хотунлиридин болған оғуллириға һәдийәләрни берип, андин буларни оғли Исһақтин жирақ турсун дәп, күн чиқиш тәрәпкә, шәрқий зиминға әвәтивәткән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Ибраһимниң өмриниң күнлири бир йүз йәтмиш бәш жил болди; у толиму қерип, күнлири тошуп, нәпәстин тохтап вапат болди; у өз қовминиң қешиға берип қошулди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Униң оғуллири Исһақ вә Исмаил уни Мамрәниң удулиға җайлашқан, Һиттий Зоһарниң оғли Әфронниң етизлиғидики Макпелаһниң ғарида дәпнә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Бу етизлиқни Ибраһим Һиттийлардин сетивалған еди; мана бу йәрликкә Ибраһим дәпнә қилинди, аяли Сараһму мошу йәргә дәпнә қилинған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ибраһим вапат болғандин кейин шундақ болдики, Пәрвәрдигар униң оғли Исһақни бәрикәтлиди. Исһақ Бәәр-Лаһай-Ройниң йенида туратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Төвәндикиләр Сараһниң мисирлиқ дедиги Һәҗәрдин туғулған, Ибраһимниң оғли болған Исмаилниң әвлатлири: — ");
INSERT INTO uigcyr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Исмаилниң оғуллириниң, уларниң нәсәбнамилири вә қәбилилири бойичә исми төвәндикичә: — Исмаилниң тунҗа оғли Небайот; андин Кедар, Адбәәл, Мибсам, ");
INSERT INTO uigcyr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Мишма, Думаһ, Масса, ");
INSERT INTO uigcyr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Һадад билән Тема, Йәтур билән Нафиш вә Қәдәмаһ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Булар болса Исмаилниң оғуллири болуп, уларниң кәнт вә чедиргаһлири уларниң нами билән аталған болуп, улар он икки қәбилигә әмир болған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Исмаилниң өмриниң жиллири бир йүз оттуз йәттә жил болди; у ахирқи нәпсини тартип вапат болуп, өз қовминиң қешиға берип қошулди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Униң әвлатлири Һавилаһ районидин тартип шурғичә олтирақлашти (Шур болса Мисирниң уттурисида болуп, Ашурға баридиған йолда еди). Исмаил өзиниң барлиқ қериндашлириниң удулида олтирақлашти. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ибраһимниң оғли Исһақниң нәслиниң баяни мундақтур: — Ибраһимдин Исһақ төрәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Исһақ Падан-Арамда олтиришлиқ арамий Бетуәлниң қизи, арамий Лабанниң сиңлиси болған Ривкаһни хотунлуққа алғанда қириқ яшқа киргән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Амма Ривкаһ болса туғмас болғачқа, Исһақ хотуни үчүн Пәрвәрдигарға дуа-тилавәт қилди; Пәрвәрдигар униң дуасини иҗабәт қилди; шуниң билән аяли Ривкаһ һамилдар болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Амма униң қосиғидики икки бала бир-бири билән соқушқили турди. Шуниң билән Ривкаһ: — Әгәр бундақлиғини билсәм, һамилдар болуп немә қилаттим? — дәп Пәрвәрдигардин сәвәвини сориғили барди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Пәрвәрдигар униңға: — «Сениң қосиғиңда икки әл бардур, Ичиңдин икки хәлиқ чиқип бир-биридин айрилиду, Бир хәлиқ йәнә бир хәлиқтин ғалип келиду, Чоңи кичигиниң хизмитини қилиду» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Униң ай-күни тошқанда, мана униң қосиғида дәрвәқә бир җүп кош гезәк бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Авал туғулғини қизғуч болуп, пүтүн бәдини җувидәк түклүк еди. Улар униң исмини Әсав дәп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Андин иниси қоли билән Әсавниң тапинини тутқан һалда чиқти. Бу сәвәптин униң исми Яқуп дәп қоюлди. Улар туғулғанда Исһақ атмиш яшта еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Балилар өсүп чоң болди; Әсав маһир овчи болуп, дала-җаңгалда жүридиған адәм болди. Яқуп болса дурус адәм болуп, чедирларда туратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Исһақ Әсавниң овлап кәлгән гөшидин дайим йәп турғачқа, униңға амрақ еди. Лекин Ривкаһ Яқупқа амрақ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Бир күни Яқуп почақ шорписи қайнитивататти; Әсав даладин һерип-ечип қайтип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Әсав Яқупқа: — Мән һалимдин кәттим! Өтүнүп қалай, аву қизилдин бәрсәң! — Аву қизил нәрсидин мени озуқландурсаңчу! Мән һалимдин кәттим, — деди (шу сәвәптин униң ети «Едом» дәпму аталди). ");
INSERT INTO uigcyr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Яқуп униңға: — Ундақ болса, тунҗилиқ һоқуқуңни маңа сетип бәргин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Әсав: — Мән өләй дәватимән, бу тунҗилиқ һоқуқиниң маңа немә пайдиси? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Яқуп: — Әмисә һазир маңа қәсәм қилғин, девиди, у униңға қәсәм қилип, тунҗилиқ һоқуқини Яқупқа сетип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Шуниң билән Яқуп Әсавға нан билән қизил почақ шорписини бәрди. У йәп-ичип орнидин туруп кәтти. Шундақ қилип Әсав тунҗилиқ һоқуқиға шунчә етиварсиз қариған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Қанаан зиминида Ибраһимниң вақтидики ачарчилиқтин башқа йәнә бир қетимлиқ ачарчилиқ йүз бәрди. Шуниң билән Исһақ Гәрар шәһиригә, Филистийләрниң падишаси Абимәләкниң қешиға барди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Пәрвәрдигар униңға көрүнүп мундақ деди: — Сән Мисирға чүшмәй, бәлки Мән саңа көрситип беридиған жутта турғин. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Мошу зиминдин чиқмай мусапир болуп турғин; шуниң билән Мән сән билән биллә болуп, саңа бәхит-бәрикәт ата қилимән; чүнки Мән сән вә нәслиңгә бу зиминларниң һәммисини берип, атаң Ибраһимға бәргән қәсимимни ада қилимән; ");
INSERT INTO uigcyr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","нәслиңни асмандики юлтузлардәк көпәйтимән вә нәслиңгә бу зиминларниң һәммисини беримән; йәр йүзидики барлиқ әл-жутлар нәслиңниң нами билән өзлиригә бәхит-бәрикәт тиләйду;    ");
INSERT INTO uigcyr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Чүнки Ибраһим Мениң авазимға қулақ селип, тапилиғиним, әмирлирим, бәлгүлимилирим вә қанунлиримни беҗа кәлтүрди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Шуниң билән Исһақ Гәрарда туруп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Амма у йәрлик кишиләр униң аяли тоғрисида сориса у: — Бу мениң сиңлим болиду, — деди; чүнки Ривкаһ интайин чирайлиқ болғачқа, Исһақ өз-өзигә: «Бу мениң аялим болиду», десәм, бу йәрлик адәмләр Ривкаһниң сәвәвидин мени өлтүрүветәрмекин, — дәп қорқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Лекин у шу йәрдә узақ вақит турғандин кейин шундақ болдики, Филистийләрниң падишаси Абимәләк дәризидин қаривиди, мана Исһақ вә аяли Ривкаһ бир-биригә әркилишип туратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Андин Абимәләк Исһақни чақирип: — Мана, у җәзмән сениң аялиң екән! Сән немә дәп: «У мениң сиңлим», дедиң? — девиди, Исһақ униңға: — Чүнки мән әслидә униң сәвәвидин бириси мени өлтүрүветәрмекин, дәп әнсиригән едим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Абимәләк униңға: Бу бизгә немә қилғиниң? Тас қапту хәлиқ арисидин бирәрси аялиң билән биргә болғили?! Ундақ болған болса сән бизни гунаға патқузған болаттиң! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Андин Абимәләк һәммә хәлиққә буйруп: — Кимки бу кишигә вә яки хотуниға қол тәккүзсә җәзмән өлтүрүлмәй қалмайду, — дәп ярлиқ чүшүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Исһақ у зиминда териқчилиқ қилди: у шу жили йәрдин йүз һәссә һосул алди; Пәрвәрдигар уни бәрикәтлигән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Бу киши баш көтирип, барғансери раваҗ тепип, толиму катта кишиләрдин болуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Униң қой-кала падилири вә өйидики қуллири интайин көпәйди; Филистийләр униңға һәсәт қилғили турди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Бу сәвәптин униң атиси Ибраһимниң күнлиридә атисиниң қуллири колиған қудуқларниң һәммисини Филистийләр етип, топа билән тиндурувәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Абимәләк Исһаққа: — Сән биздин зиядә күчийип кәттиң, әнди аримиздин чиқип кәткин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Исһақ у йәрдин кетип, Гәрар вадисиға чедир тикип, шу йәрдә туруп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ибраһим һаят вақтида қуллири бир мунчә қудуқларни қазған еди; бирақ Ибраһим өлгәндин кейин, Филистийләр буларни топа билән тиндурувәткән еди. Исһақ бу қудуқларни қайтидин колитип, уларға атиси илгири қойған исимларни йәнә қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Исһақниң қуллири вадида қудуқ колаватқанда сулири урғуп чиқип ақидиған бир қудуқни тепивалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Лекин Гәрардики падичилар Исһақниң падичилиридин уни талишип: — Бу су бизниңкидур, — деди. Улар Исһақ билән җедәлләшкәчкә, у бу қудуқни «Есәк» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Улар йәнә башқа бир қудуқни колиди, улар йәнә бу қудуқ тоғрисида җедәлләшти. Шуниң билән Исһақ буниң исмини «Ситнаһ» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Андин у у йәрдин кетип, башқа йәргә берип, шу йәрдиму йәнә бир қудуқ колиди; әнди Гәрардикиләр бу қудуқни талашмиди. Бу сәвәптин у униң етини «Рәһобот» қоюп: «Әнди Пәрвәрдигар биз үчүн җай бәргән екән, бу зиминда мевилик болимиз», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Андин у у йәрдин чиқип Бәәр-Шебаға барди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Пәрвәрдигар шу кечиси униңға көрүнүп: — Мән болсам атаң Ибраһимниң Худасидурмән; қорқмиғин, чүнки Мән сән билән биллимән, сени бәхит-бәрикәтләп, нәслиңни қулум Ибраһимниң сәвәвидин көпәйтимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","У шу йәрдә бир қурбангаһ ясап, Пәрвәрдигарниң намиға нида қилип ибадәт қилди. У шу йәрдә чедирини тикти, Исһақниң қуллири шу йәрдә бир қудуқ колиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Әнди Абимәләк, ағиниси Аһуззат билән ләшкәр беши Фикол биргә Гәрардин чиқип, униң қешиға барди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Исһақ уларға: — Маңа өчмәнлик қилип, мени араңлардин қоғливәткәндин кейин, немә үчүн мениң қешимға кәлдиңлар? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Улар җававән: — Биз Пәрвәрдигарниң сән билән биллә болғинини рошән байқидуқ, шуниң билән биз сениң тоғраңда: «Оттуримизда бир келишим болсун, йәни бизләр билән сән бир-биримизгә қәсәм берип әһдә қилишайли» дедуқ; шу вәҗидин сән бизгә һеч қандақ зиян-зәхмәт йәткүзмигәйсән; биз саңа һеч тәгмигинимиздәк, шундақла саңа яхшилиқтин башқа һеч бир немә қилмиғинимиздәк (бәлки сени аман-есәнлик ичидә йолуңға әвәткән едуқ) сәнму шундақ қилғайсән. Мана һазир сән Пәрвәрдигар тәрипидин бәхит-бәрикәт көрүватисән! — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Шуниң билән у уларға бир зияпәт қилип бәрди. Улар болса йәп-ичти. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Әтиси таң сәһәрдә улар қопуп бир-биригә қәсәм қилишти; андин Исһақ уларни йолға селип қойди; улар униң қешидин аман-есән кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","У күни шундақ болдики, Исһақниң қуллири келип, униңға өзи колиған қудуқ тоғрисида хәвәр берип: «Биз су таптуқ!» деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","У униң намини «Шибаһ» қойди. Бу сәвәптин бу шәһәрниң исми бүгүнгичә «Бәәр-Шеба» дәп атилип кәлмәктә. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Әсав қириқ яшқа киргәндә, Һиттийлардин болған Бәәриниң қизи Йәһудит билән Һиттийлардин болған Елонниң қизи Басиматни хотунлуққа алди. ");
INSERT INTO uigcyr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Амма булар Исһақ билән Ривкаһниң көңлигә азап елип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Исһақ қерип, көзлири торлишип, көзи ғува көридиған болуп қалғанда шундақ болдики, у чоң оғли Әсавни чақирип униңға: — Оғлум! — деди. У: — Мана мән! — дәп җавап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","У униңға: — Мана мән әнди қерип кәттим, қанчилик күн көридиғинимниму билмәймән. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Шуңа сәндин өтүнимән, қураллириң, йәни садақ вә оқяйиңни елип җаңгалға чиқип, мән үчүн бир ов овлап кәл; ");
INSERT INTO uigcyr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","мән яхши көридиған ләззәтлик тамақтин бирни етип, маңа кәлтүргин. Мән уни йәп, өлүштин илгири көңлүмдин саңа бәхит-бәрикәт тиләп дуа қилай, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Исһақ оғли Әсавға сөз қилғанда Ривкаһму аңлиди. Әсав ов овлап кәлгили җаңгалға чиқип кәткәндә, ");
INSERT INTO uigcyr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","7","Ривкаһ оғли Яқупқа: — Мана мән атаңниң акаң Әсавға: «Сән ов овлап келип, маңа ләззәтлик бир таамни әткин; мән уни йәп өлүп кетиштин бурун Пәрвәрдигар алдида саңа бәхит-бәрикәт тиләп дуа қилай», — дәп ейтқинини аңлап қалдим. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Әнди, и оғлум, сөзүмгә қулақ селип буйруғинимни қилғин. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Сән дәрһал падиға берип, өшкиләрниң ичидин есил икки оғлақни елип кәлгин; мән улардин атаң үчүн у яхши көридиған ләззәтлик бир таам тәйяр қилай. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Сән уни атаңниң алдиға елип киргин. Шуниң билән у йәп, өлүп кетиштин бурун саңа бәхит-бәрикәт тиләп дуа қилиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Лекин Яқуп аниси Ривкаһға: — Мана акам Әсав болса түклүк киши, мән болсам түксиз силиқ тәнлик адәммән. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Мабада атам мени силап қалса, ундақта мән униң нәзиридә уни мазақ қилғучи адәм болуп қелип, бешимға бәрикәт әмәс, бәлки ләнәт тапармәнмекин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Аниси униңға: — Әй оғлум, саңа чүшидиған ләнәт маңа чүшсун; амма сән пәқәт сөзүмгә қулақ селип, берип оғлақларни елип кәл, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","У берип уларни елип келип, анисиға бәрди. Аниси униң атиси яхши көридиған ләззәтлик бир таамни тәйяр қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Андин Ривкаһ тунҗа оғли Әсавниң өйдә өз йенида сақлақлиқ әң есил кейимлирини елип кичик оғли Яқупқа кийдүрүп, ");
INSERT INTO uigcyr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","оғлақларниң терисини икки қоли билән бойниниң түксиз җайиға йөгәп, ");
INSERT INTO uigcyr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","андин өзи әткән ләззәтлик таамлар билән нанларни оғли Яқупниң қолиға тутқузди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Яқуп атисиниң қешиға кирип: — Әй ата! — деди. У: — Мана мән! Оғлум, сән ким болисән? — девиди, ");
INSERT INTO uigcyr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Яқуп атисиға җавап берип: — Мән чоң оғуллири Әсавмән, маңа ейтқанлиридәк қилдим; әнди орунлиридин туруп, олтирип қилған овумниң гөшигә еғиз тегип, андин көңүллиридин маңа бәхит-бәрикәт тиләп дуа қилғайла, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Исһақ оғлиға: — Әй оғлум, қандақму уни шунчә тез тепип кәлдиң? — девиди, у җавап берип: — Чүнки Пәрвәрдигар Худалири уни дәл йолумға йолуқтурди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Исһақ Яқупқа: — Әй оғлум, йеқинрақ кәл, сән раст оғлум Әсавму, әмәсму, силап бақай, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Шуниң билән Яқуп атиси Исһақниң қешиға йеқин барди; у уни силап туруп: — Аваз Яқупниң авази, лекин қол болса Әсавниң қолидур, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Униң қоллири болса акиси Әсавниң қоллиридәк түклүк болғини үчүн уни тоналмай, униңға бәхит-бәрикәт тиләп дуа қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Андин у йәнә: — Сән раст оғлум Әсавмусән? дәп соривиди, у җавап берип: — Дәл мән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Исһақ униңға: — Таамни елип кәлгин, мән оғлумниң ов гөшидин йәп, көңлүмдин саңа бәхит-бәрикәт тиләп дуа қилай, — деди. Яқуп уни униң алдиға қойди; у йеди. У шарап кәлтүрүвиди, униму ичти. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Андин атиси Исһақ униңға: — Әй оғлум, әнди йеқин келип мени сөйгин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","У униң қешиға берип уни сөйди. Атиси униң кийиминиң пуриғини пурап униңға бәхит-бәрикәт тиләп дуа қилип: — «Мана, оғлумниң тенидики пурақ Пәрвәрдигар бәрикәтлигән көкләмзарниң хуш пуриғиға охшайдикән! ");
INSERT INTO uigcyr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Худа саңа асманниң шәбними, Йәрниң мунбәт күчини ата қилип, Ашлиқ-түлүк билән шарапниму көп бәргәй. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Хәлиқләр сениң қуллуғуңда болғай, Әл-милләтләр алдиңда тизланғай; Қериндашлириңға ғоҗа болғайсән; Анаңниң оғуллири саңа тизланғай; Саңа ләнәт қилғанлар ләнәткә қалғай; Саңа бәхит тилигәнләр бәхит тапқай!» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Шундақ болдики, Исһақ Яқупқа дуа қилип болуп, Яқуп атиси Исһақниң қешидин чиқип болушиға, акиси Әсав овдин қайтип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Уму ләззәтлик таамларни етип, атисиниң қешиға елип кирип, атисиға: — Ата қопқайла, оғуллириниң ов гөшидин йәп, көңүллиридин маңа бәхит-бәрикәт тиләп дуа қилғайла, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Атиси Исһақ униңға: — Сән кимсән? — деди. У җавап берип: — Мән оғуллири, чоң оғуллири Әсавмән! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Буни аңлап Исһақ алақзадиликкә чүшүп, пүтүн бәдини җалақлап титрәп: — Ундақта баятин ов овлап елип кәлгини ким? Сән келиштин бурун униң һәммә нәрсисидин йәп, униңға бәхит-бәрикәт тиләп дуа қилдим; вә бәрһәқ, у бәхит-бәрикәт көриду! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Әсав атисиниң сөзлирини аңлапла интайин ечинарлиқ һалда үн селип аччиқ пәряд көтирип атисиға: — Мениму, и ата, мениму бәхит-бәрикәтлигәйла! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","У җавап берип: — Сениң иниң һейлә билән кирип, саңа тегишлик бәхит-бәрикәтни елип кетипту, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Әсав: — Раст униң ети Яқуп әмәсму?! Чүнки у икки қетим мени путлап, орнумни тартивалди. Авал тунҗилиқ һоқуқумни тартивалди вә мана һазир у маңа тегидиған бәхит-бәрикәтни елип кәтти, — деди, Андин йәнә: — Мениң үчүн бирәр бәхит-бәрикәт қалдурмидилиму? — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Исһақ Әсавға җавап берип: — Мана, мән уни үстүңгә ғоҗа қилдим; һәммә қериндашлирини униң қуллуғида болидиған қилдим; ашлиқ вә йеңи шарап билән уни қувәтлидим; әй оғлум, әнди саңа йәнә немиму қилип берәләймән? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Әсав атисиға йәнә: — Әй ата, силидә пәқәт шу бирла бәхит-бәрикәт бар едиму? Маңа, әй ата, маңиму бәхит-бәрикәт тиләп дуа қилғайла! деди. Андин у үн селип жиғлап кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Атиси Исһақ униңға җавап берип: — «Мана, туралғу җайиң йәрниң мунбәт күчидин нери, Егиз асманниң шәбнимидин жирақ болур; ");
INSERT INTO uigcyr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Сән қиличиңға тайинип җан бақисән, Иниңниң хизмитидә болисән; Лекин чегаридин чиқип кәзгиниңдә, Сән бойнуңдин униң боюнтуруғини чиқирип сундуруветисән» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Шуңа Әсав атиси униңға тилигән бәхит-бәрикәт сәвәвидин Яқупқа өчмәнлик сақлап жүрди. Әсав көңлидә: — Атамниң матәм күнлири йеқинлишип қалди; шу чағда иним Яқупни өлтүрүветимән, дәп хиял қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Лекин Ривкаһ чоң оғли Әсавниң бу сөзлиридин хәвәр тапти. У кичик оғли Яқупни чақирип униңға: — Мана акаң Әсав сени өлтүрүветимән дәп өз-өзидин тәсәлли тепиветипту; ");
INSERT INTO uigcyr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","әнди әй оғлум, сөзүмгә қулақ селип, қопуп Һаранға, акам Лабанниң қешиға қечип кәткин; ");
INSERT INTO uigcyr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","акаңниң қәһри янғичә, униң қешида бир нәччә вақит турғин. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Акаң аччиғидин йенип, сениң униңға қилғиниңни унтуп кәткичә шу йәрдә туруп турғин; андин мән адәм әвәтип, сени у йәрдин алдуруп келимән. Немә үчүн бир күндила һәр иккиңлардин мәһрум болуп қалай? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Амма Ривкаһ Исһаққа: — Мән мошу Һиттий қизлар вәҗидин җенимдин җақ тойдум. Әгәр Яқупму бу жуттики қизлардин, мошундақ Һиттий қизни хотунлуққа алса яшиғинимниң маңа немә пайдиси? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Шуниң билән Исһақ Яқупни чақирип, униңға бәхит-бәрикәт тиләп, униңға җекиләп: — Сән Ⱪананийларниң қизлиридин хотун алма; ");
INSERT INTO uigcyr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","бәлки қопуп, Падан-Арамға, анаңниң атиси Бетуәлниң өйигә берип, у йәрдин анаңниң акиси Лабанниң қизлиридин хотун алғин. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Һәммигә Қадир Тәңри сени бәхит-бәрикәтләп, көпәйтип, сәндин көп хәлиқләрни чиқирип көпәйткәй, ");
INSERT INTO uigcyr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Шундақла Ибраһимниң бәхит-бәрикитини саңа вә сениң билән нәслиңгә бәргәй; шундақ қилип сән һазир Мусапир болуп туруватқан йәрни, йәни әслидә Худа Ибраһимға бәргән зиминни егиләйсән! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Шуниң билән Исһақ Яқупни йолға салди. У Падан-Арамға, арамий Бетуәлниң оғли, Яқуп билән Әсавниң аниси Ривкаһниң акиси Лабанниң қешиға қарап маңди. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Әсав Исһақниң Яқупқа бәхит-бәрикәт тиләп, уни Падан-Арамға шу йәрдин хотун елишқа әвәткәнлигини, шундақла униңға бәхит-бәрикәт тиләп, униңа җекиләп: Сән Ⱪананийларниң қизлиридин хотун алмиғин, дегәнлирини уқуп, Яқупниңму өз ата-анисиға итаәт қилип, Падан-Арамға кәткинини көргинидә, ");
INSERT INTO uigcyr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Әсав: — қанаанйларниң қизлири атам Исһақниң нәзиридә яман көрүнидикән, дәп билип йәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","У Исмаилниң қешиға берип, һазирқи хотунлириниң үстигә Ибраһимниң оғли Исмаилниң қизи, Небайотниң сиңлиси Маһалатни хотунлуққа алди. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Яқуп болса Бәәр-Шебадин чиқип, Һаран тәрәпкә меңип, ");
INSERT INTO uigcyr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","бир йәргә йетип кәлгәндә, күн олтирип кәткәчкә шу йәрдә қонмақчи болди. У шу йәрдики ташлардин бирини елип, бешиға ястуқ қилип қоюп, ухлиғили ятти. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","У бир чүш көрди: — Мана, учи асманларға тақишидиған бир пәләмпәй йәрдә тикләклик туратти; Худаниң пәриштилири униңда чиқип-чүшүп турушатти. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Мана, Пәрвәрдигар униң үстидә туратти. У: — «Мән болсам атаң Ибраһимниң Худаси вә Исһақниң Худаси болған Пәрвәрдигардурмән; Мән сән ятқан бу зиминни сениң билән нәслиңгә беримән.    ");
INSERT INTO uigcyr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Нәслиң болса йәрниң тописидәк көп болуп, сән мәғрип билән мәшриққә, шимал билән җәнупқа йейилисән; сән вә нәслиңниң вастиси билән йәр йүзидики барлиқ аилә-қәбилиләр бәхит-бәрикәт тапиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Мана, Мән сән билән биллидурмән, қәйәргә барсаң сени аман-есән сақлап, бу зиминға сени қайтуруп келимән; чүнки саңа ейтқан сөзүмни ада қилмай туруп, сени ташлимаймән» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Андин Яқуп ойғинип: — Бәрһәқ, Пәрвәрдигар бу йәрдидур, лекин мән уни билмәптимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","У қорқуп кетип: Бу җай аламәт дәһшәтлик бир җай екән! Бу Худаниң өйи билән асманниң дәрвазисидин башқа һеч җай әмәстур, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Яқуп әтиси сәһәр қопуп, бешиниң астиға қойған ташни елип, хатирә түврүк сүпитидә тикләп, үстигә зәйтун мейи қуюп қойди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","У җайниң исмини Бәйт-Әл дәп атиди; амма илгири у җайниң ети Луз еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Андин Яқуп қәсәм билән вәдә қилип: — Әгәр Худа мениң билән биллә болуп, бу сәпиримдә мени сақлап, йегили нан, кийгили кийим берип, ");
INSERT INTO uigcyr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Мән атамниң өйигә аман-есән йенип барсам, ундақта Пәрвәрдигар мениң Худайим болиду; ");
INSERT INTO uigcyr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Шуниңдәк мән хатирә түврүк сүпитидә тикләп қойған бу таш Худаниң өйи болиду; һәм шундақла сән маңа беридиған барлиқ нәрсиләрниң ондин бир үлүшини саңа тәқдим қилмай қалмаймән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Андин Яқуп сәпирини давамлаштуруп, мәшриқтики қовмларниң зиминиға йетип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","У қаривиди, мана, яйлақта бир қудуқ туратти, униң йенида үч топ қой падиси туратти; чүнки хәлиқ бу қудуқтин падиларни суғиратти. Қудуқниң ағзиға йоған бир таш қоюқлуқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Қачаники падиларниң һәммиси у йәргә жиғилса, падичилар бирликтә қудуқниң ағзидики ташни жумилитиветип, қойларни суғирип, андин ташни йәнә қудуқниң ағзиға өз орниға қоюп қоятти. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Яқуп падичилардин: Әй бурадәрләр, силәр қәйәрлик? — дәп сориди. Улар: — Биз һаранлиқмиз, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","У улардин: — Силәр Наһорниң оғли Лабанни тонумсиләр? — дәп сориди. Улар: — Тонуймиз, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","У улардин: — У саламәтму, дәп соривиди, улар җавап берип: — У саламәт туруватиду. Мана әнә униң қизи Раһилә қойлири билән келиватиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","У: — Мана, күн техи егиз турса, һазир техи малниң жиғилидиған вақти болмиди; немишкә қойларни суғирип, андин йәнә берип отлатмайсиләр? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Улар җавап берип: — Яқ, мундақ қилалмаймиз. Авал падиларниң һәммиси жиғилип, падичилар ташни қудуқниң ағзидин жумилитивәткәндин кейин, андин қойларни суғиримиз, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","У улар билән гәплишип турғинида, Раһилә атисиниң қойлири билән йетип кәлди; чүнки у қой баққучи еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Шундақ болдики, Яқуп анисиниң акиси Лабанниң қизи Раһилә билән анисиниң акиси Лабанниң қойлирини көргәндә, у қопуп берип, қудуқниң ағзидин ташни жумилитиветип, анисиниң акиси Лабанниң қойлирини суғарди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","Андин Яқуп Раһиләни сөйүп, жуқури аваз билән жиғлап ташлиди вә Раһиләгә: — Мән сениң атаңниң туққини, Ривкаһниң оғли болимән, девиди, у жүгүрүп берип атисиға хәвәр бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Шундақ болдики, Лабан өз сиңлисиниң оғли Яқупниң хәвирини аңлиғанда, униң алдиға жүгүрүп берип, уни қучағлап сөйүп, өйигә башлап кәлди. Андин Яқуп Лабанға кәчүрмишлириниң һәммисини дәп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Лабан униңға: — Сән дәрвәқә мениң сүйәк билән гөшүмдурсән! — деди. Буниң билән у униң қешида бир айчә туруп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Андин Лабан Яқупқа: — Сән мениң туққиним болғач, маңа бекарға хизмәт қиламсән? Ейтқина, һәққиңгә немә алисән? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Лабанниң икки қизи бар еди; чоңиниң ети Леяһ, кичигиниң ети Раһилә еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Леяһниң көзлири йеқимлиқ еди; амма Раһиләниң болса тәқи-турқи келишкән, һөсни-җамали чирайлиқ қиз еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Яқупниң көңли Раһиләгә чүшкән болуп Лабанға: — Мән сениң кичик қизиң Раһилә үчүн саңа йәттә жил хизмәт қилай, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Лабан җавап берип: — Уни башқа кишигә бәргинимдин саңа бәргиним яхши. Әнди мениңкидә турғин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Яқуп Раһиләни елиш үчүн йәттә жил хизмәт қилди. Амма у уни интайин яхши көргәчкә, бу жиллар униңға пәқәт бир нәччә күндәкла билинди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Вақит тошқанда Яқуп Лабанға: — Мана мениң күнлирим тошти. Әнди аялимни маңа бәргин, мән униң қешиға кирәй, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Лабан шу йәрдики һәммә кишиләрни жиғип, зияпәт қилип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Лекин шундақ болдики, кәч киргәндә, у чоң қизи Леяһни Яқупниң йениға елип кәлди; Яқуп униң қешиға кирип биллә болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Лабан өз дедиги Зилпаһни қизи Леяһға дедәк қилип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Әтиси шундақ болдики, мана алдида Леяһ туратти! У Лабанға: — Бу зади маңа немә қилғиниң? Әҗәба, мән Раһилә үчүн саңа хизмәт қилмидимму? Мени немишкә шундақ алдидиң?! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Лабан: Бизниң жутимизда кичигини чоңидин илгири ятлиқ қилидиған рәсим-қаидә йоқ. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Әнди сән чоңиниң йәттә күнлүк той мурасимини өткүзүп болғин; андин йәнә иккинчисиниму саңа берәйли; у сениң маңа йәнә йәттә жил қилидиған хизмитиңниң һәққи болиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Яқуп мақул болуп, Леяһниң йәттә күнлүк той мурасимини өткүзүп болғанда, Лабан қизи Раһиләниму униңға хотунлуққа бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Лабан дедиги Билһаһни қизи Раһиләгә дедәк қилип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Бу тәриқидә Яқуп Раһиләниңму қешиға кирди; у Раһиләни Леяһдин зиядә яхши көрди. Андин кейин у йәнә йәттә жил Лабанға хизмәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Амма Пәрвәрдигар Леяһниң әтиварланмиғанлиғини көргәндә, униңға туғушни несип қилди. Лекин Раһилә туғмас еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Леяһ һамилдар болуп бир оғул туғуп: — «Пәрвәрдигар харланғинимни көрди; әнди ерим мени яхши көриду» дәп униң исмини «Рубән» қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","У йәнә һамилдар болуп, бир оғул туғуп: — «Пәрвәрдигар әтиварланмиғанлиғини аңлап, буни һәм маңа бәрди» дәп, униң исмини Шимеон қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","У йәнә һамилдар болуп, бир оғул туғуп: — «Әнди бу қетим ерим маңа бағлиниду; чүнки мән униңға үч оғул туғуп бәрдим» дәп униң исмини Лавий қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","У йәнә һамилдар болуп, бир оғул туғуп: — «Әнди бу қетим мән Пәрвәрдигарға һәмдусана оқуй!» дәп униң исмини Йәһуда қойди. Андин у туғуттин тохтап қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Амма Раһилә өзиниң Яқупқа бала туғуп берәлмигинини көргәндә, һәдисиға һәсәт қилип Яқупқа: — Маңа бала бәргин; болмиса өлимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Шуниң билән Яқупниң Раһиләгә ғәзиви келип: — Мән балиятқуниң мевисини сәндин айиған Худаниң орнидиму?! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","— Мана, дедигим Билһаһ бу йәрдә туриду; сән униң қешиға киргин, у мениң қучиғимға туғсун; мән у арқилиқ балилиқ болай, — деди Раһилә. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Шуниң билән у дедиги Билһаһни униңға хотун қилип бәрди; Яқуп униң қешиға кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Билһаһ һамилдар болуп, Яқупқа бир оғул туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Раһилә: — «Худа мән үчүн адаләт жүргүзүп пәрядимни аңлап, маңа бир оғул бәрди», дәп униң исмини Дан қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Раһиләниң дедиги Билһаһ йәнә һамилдар болуп, Яқупқа иккинчи оғлини туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Раһилә: — «Мән һәдәм билән бәслишип қаттиқ тутушуп, йәңдим» дәп униң исмини Нафтали қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Леяһ өзиниң туғуттин тохтап қалғанини көрүп, дедиги Зилпаһни Яқупқа хотун қилип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Леяһниң дедиги Зилпаһ Яқупқа бир оғул туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Леяһ: — «Немидегән тәләйлик-һә!» дәп униң исмини Гад қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Леяһниң дедиги Зилпаһ Яқупқа иккинчи оғлини туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Леяһ: «Мән бәхитликтурмән! Чүнки хотун-қизлар мени бәхитлик дейишиду!» дәп униң исмини Ашир қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Буғдай ормиси күнлиридә Рубән чиқип етизлиққа барди вә етиздин бир қанчә муһәббәтгүлини терип, буларни аниси Леяһниң қешиға әкәлди. Әнди Раһилә Леяһқа: — Өтүнүп қалай, оғлуңниң муһәббәтгүлидин бир нәччини маңа бәргин! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Леяһ униңға җававән: — Еримни тартивалғиниң йәтмәмду? Әнди оғлумниң муһәббәтгүлиниму тартивалмақчимусән? — деди. Раһилә җавап берип: — Ундақ болса у оғлуңниң муһәббәтгүллири үчүн бүгүн кечә сән билән ятсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Яқуп кәчқурун етиздин қайтип кәлгинидә, Леяһ униң алдиға чиқип: — Мениң қешимға киришиң керәк; чүнки мән оғлумниң муһәббәтгүллири билән сени иҗаригә алдим, — деди. Шундақ девиди, у бу кечә униң билән ятти. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Худа Леяһниң дуасини аңлиди; у һамилдар болуп, Яқупқа бәшинчи оғлини туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Шуниң билән Леяһ: «Дедигимни еримгә бәргинимгә Худа әнди маңа «иҗарә һәққим»ни ата қилди» дәп униң исмини Иссакар қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Леяһ йәнә һамилдар болуп, Яқупқа алтинчи оғлини туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Леяһ: — «Худа маңа яхши тойлуқ ата қилди; әнди ерим мениң билән биллә туридиған болди; чүнки мән униңға алтә оғул туғуп бәрдим» дәп униң исмини Зәбулун қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Шуниңдин кейин, у бир қиз туғуп, униң исмини Динаһ қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Амма Худа Раһиләни яд қилип, дуасини аңлап уни туғидиған қилди, ");
INSERT INTO uigcyr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","У һамилдар болуп, бир оғул туғди. У: — «Худа мени номустин халас қилди», деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","У: — «Пәрвәрдигар маңа йәнә бир бала бәрсә» дәп, униң исмини Йүсүп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Раһилә Йүсүпни туққандин кейин Яқуп Лабанға: — Мени өз жутумға, өз вәтинимгә кәткили қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Мениң саңа ишләп еришкән иш һәққим болған аяллирим билән балилиримни маңа бәргин; мән кетәй; чүнки мениң саңа ишлигән җапалиқ хизмитим өзүңгә аян, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Лабан униңға җававән: Нәзириңдә илтипат тапқан болсам, өтүнүп қалай, йенимдин кәтмә. Чүнки мән Пәрвәрдигарниң сениң сәвәвиңдин маңа бәрикәт бәргинини тонуп йәттим, девиди, Яқуп йәнә: — ");
INSERT INTO uigcyr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Маңа алидиған һәққиңни тохтатқин; мән саңа шуни берәй, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Яқуп униңға җавап берип: — Мән саңа қандақ хизмәт қилип кәлгиним, мениң қолумда маллириңниң қандақ болғини өзүңгә аян. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Чүнки мән кәлмәстә мелиң аз еди; әнди наһайити зор бир топ болди. Мениң қедимим қәйәргә йәтсә, Пәрвәрдигар саңа бәрикәт ата қилди. Әнди мән қачан өз аиләм үчүн егилик тикләймән? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Шуниң билән Лабан: — Мән саңа немә берәй, девиди, Яқуп: — Сән маңа һеч немә бәрмигин; пәқәт мениң шу ишимға қошулсаңла, мән йәнә падаңни беқип, улардин хәвәр алимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Мән бүгүн пүткүл падаңни арилап, ала-чипар қойларни, қара-қоңур пахланларни, шундақла өшкиләрниң ичидинму ала-чипарлирини айрип чиқимән. Булар мениң иш һәққим болсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Кейин, мениң һәққимни тәкшүрүп кәлгән вақтиңда, һәққаний болғиним көз алдиңда испатлиниду; өшкиләр арисида ала-чипар болмиғанлириниң һәммиси, пахланлар арисида қара-қоңур болмиғанлириниң һәммиси оғрилап келингән һесаплансун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","у вақитта Лабан: — Мақул, дегиниңдәк болсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Шу күни Лабан тағил вә ала-чипар текиләрни, ала-чипар чиши өшкиләрни, шундақла аз-паз ақ чикими болған барлиқ өшкиләрни, барлиқ қара-қоңур қозиларни айрип, өз оғуллириниң қолиға тапшуруп, ");
INSERT INTO uigcyr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","өзи билән Яқупниң оттурисида үч күнлүк арилиқни қойди. Яқуп болса Лабанниң падилириниң қалғинини бақти. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Лекин Яқуп терәк, бадам вә чинар дәрәқлиридин юмран чивиқларни елип, қовзиқини йоллуқ қилип шилип, ақ сизиқларни чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Андин мал күйлигән вақитлирида су ичкили кәлгәндә, у мошу шилған чивиқларни падилар су ичидиған йәрләрдики улақларға малниң алдиға тикләп қоятти. Мал бу тағил чивиқларниң алдида җүпләшкәндин кейин улар тағил вә ала-чипар қозиларни туғди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Андин Яқуп бу қозиларни Лабанниң падисидин айрип чиқарди; андин у Лабанниң падисиниң йүзлирини тағил вә қоңур қойлириға қаритип җүпләштүрди; шундақ қилип, у өз мелини Лабанниң мелиға қошмай бөләк қоюп, өзи үчүн айрим бадиларни қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Сағлам күчлүк мал җүпләшкинидә, Яқуп чивиқларни падиниң көз алдиға улақларда қоятти; маллар шу чивиқларниң йенида җүплишәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Лекин җүплишиватқан мал аҗиз болса, у чивиқларни қоймайтти. Бу тәриқидә аҗизлири Лабанға, күчлүклири Яқупқа тәвә болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Шундақ қилип, бу киши наһайити бай болуп, маллири, дедәклири, қуллири, төгилири вә ешәклири хелә көп болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Амма Яқуп Лабанниң оғуллириниң: — Яқуп атимизниң пүтүн мал-мүлкини елип кәтти; униң еришкән бу дөлити атимизниң тәәллуқатидин кәлгән, дегинини аңлап қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Яқуп Лабанниң чирайиға қаривиди, мана, у өзигә бурунқидәк хуш пеил болмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Бу чағда, Пәрвәрдигар Яқупқа: — Сән ата-бовилириңниң зиминиға, өз уруқ-туққанлириңниң қешиға қайтип кәткин. Мән сениң билән биллә болимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Шуниң үчүн Яқуп адәм әвәтип, Раһилә вә Леяһни өз падиси турған көкләмгә чақирип келип ");
INSERT INTO uigcyr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","уларға мундақ деди: — Мән атаңларниң чирайиға қарисам маңа бурунқидәк хуш пеил болмиди; амма атамниң Худаси мән билән биллә болуп кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Күчүмниң йетишичә атаңларға ишләп бәргиним силәргә аян; ");
INSERT INTO uigcyr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","һалбуки, атаңлар мени ахмақ қилип, һәққимни он қетим өзгәртти; лекин Худа униң маңа зиян йәткүзүшигә йол қоймиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Әгәр у: «Ала-чипар қозилар һәққиң болиду», десә, барлиқ падилар ала-чипар қозилиғили турди. У: «Тағил қозилар һәққиң болсун», десә, барлиқ падилар тағил қозилиғили турди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Бу тәриқидә Худа атаңларниң маллирини тартивелип, маңа бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Падилар күйлигән вақитта мән бир қетим чүшүмдә бешимни көтирип шуни көрдумки, мана, малларниң үстигә җүплишишкә етилған қочқар-текиләрниң һәммиси тағил яки ала-чипар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Андин Худаниң Пәриштиси чүшүмдә маңа: «Әй Яқуп», девиди, мән җавап берип: «Мана мән», дедим. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","У маңа: — «Әнди бешиңни көтирип қариғин; мана малларниң үстигә җүплишишкә етилған қочқар-текиләрниң һәммиси тағил вә ала-чипардур; чүнки Мән Лабанниң саңа қилғининиң һәммисини көрдүм. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Мән Бәйт-Әлдә саңа көрүнгән Тәңридурмән. Сән шу йәрдә түврүкни мәсиһләп, Маңа қәсәм ичтиң. Әнди сән орниңдин туруп, бу зиминдин чиқип, уруқ-туққанлириңниң зиминиға янғин» деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Раһилә вә Леяһ униңға җавап берип: — Атимизниң өйидә бизгә тегишлик несивә яки мирас қалмиғанму? ");
INSERT INTO uigcyr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Биз дәрвәқә униңға ят адәм һесаплинип қалғанму?! У бизни сетивәтти, тойлуғимизниму пүтүнләй йәп кәтти! ");
INSERT INTO uigcyr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Шундақ болғандин кейин, Худа Атимиздин саңа елип бәргән барлиқ дөләт биз билән балилиримизниңкидур. Әнди Худа саңа немә дегән болса, шуни қилғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Шуниң билән Яқуп орнидин туруп, балилири вә аяллирини төгиләргә миндуруп, еришкән барлиқ маллири вә барлиқ тәәллуқатини, йәни Падан-Арамда тапқан тәәллуқатлирини елип, атиси Исһақниң йениға беришқа Қанаан зиминиға қарап йол алди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Лабан болса қойлирини қирқиғили кәткән еди; Раһилә өз атисиға тәвә «өй бутлири»ни оғрилап еливалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Яқуп арамий Лабанға өз қешидин оғрилиқчә қечип кетидиғанлиғини уқтурмай уни алдап қойған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","У бар-йоқини елип қечип кәтти; у дәриядин өтүп Гилеад теғи тәрәпкә қарап йол алди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Үчинчи күни, Лабанға Яқупниң қачқини тоғрисида хәвәр йәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","У өз туққанлирини елип, йәттә күнлүк йолғичә кәйнидин қоғлап берип, Гилеад теғида униңға йетишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Лекин кечиси Худа арамий Лабанниң чүшигә кирип униңға: «Сән һези бол, Яқупқа я ақ я көк демә!» деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Лабан Яқупқа йетишип барғанда, Яқуп чедирини тағниң үстигә тиккән еди. Лабанму туққанлири билән Гилеад теғиниң үстидә чедир тикти. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Лабан Яқупқа: — Бу немә қилғиниң? Сән мени алдап, қизлиримни урушта алған олҗидәк елип кәттиң? ");
INSERT INTO uigcyr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Немишкә йошурун қачисән, маңа хәвәр бәрмәй мәндин оғрилиқчә кәттиң? Маңа дегән болсаң мән хошал-хурамлиқ билән ғәзәл оқуп, дап вә чаң челип, сени узитип қоймамтим? ");
INSERT INTO uigcyr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Шундақ қилип сән маңа өз оғуллирим вә қизлиримни сөйүп узитип қоюш пурситиниму бәрмидиң. Бу ишта ахмақлиқ қилдиң. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Силәргә зиян-зәхмәт йәткүзүш қолумдин келәтти; лекин түнүгүн кечә атаңниң Худаси маңа сөз қилип: «Һези бол, Яқупқа я ақ я көк демә» деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Хош, сән атаңниң өйини толиму сеғинғиниң үчүн кәтмәй қоймайсән; лекин немишкә йәнә мениң бутлиримни оғрилидиң? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Яқуп Лабанға җавап берип: — Мән қорқуп қачтим; чүнки сени қизлирини мәндин мәҗбурий тартиваламдикин, дедим. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Әнди бутлириңға кәлсәк, улар кимдин чиқса шу тирик қалмайду! Қериндашлиримиз алдида мәндин қандақла немәңни тонувалсаң, уни елип кәт, — деди. Һалбуки, Яқупниң Раһиләниң бутларни оғрилап кәлгинидин хәвири йоқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Лабан алди билән Яқупниң чедириға кирип, андин Леяһниң чедири һәм икки дедәкниң чедирлириға кирип ахтуруп һеч немә тапалмиди. Леяһниң чедиридин чиқип, Раһиләниң чедириға кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Раһилә болса өй бутлирини елип, буларни төгиниң чоминиң ичигә тиқип қоюп, үстидә олтиривалған еди. Лабан пүткүл чедирини ахтуруп, һеч немә тапалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Раһилә атисиға: — Әй ғоҗам, алдиңда туралмиғиним үчүн хапа болмиғин; чүнки мән һазир аялларниң адәт мәзгилидә туруватимән, — деди. Шундақ қилип, Лабан һәммә йәрни қоймай ахтурупму, өй бутлирини тапалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Шуниң билән Яқуп аччиқлап Лабан билән җедәллишип кәтти. Яқуп Лабанға: — Сән мени кәйнимдин мунчә алдирап-тенәп қоғлап кәлгидәк мәндә немә сәһвәнлик, немә гуна бар? ");
INSERT INTO uigcyr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Сән һәммә жүк-тақлиримни ахтуруп чиқтиң, өйүңниң нәрсилиридин бирәр немә тапалидиңму? Бир немә тапқан болсаң, мениң қериндашлирим билән сениң қериндашлириңниң алдида уни қойғин, улар биз иккимизниң арисида һөкүм қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Мән мошу жигирмә жил қешиңда турдум; һеч қачан сағлиғиң вә чиши өшкилириң бала ташливәтмиди; падилириңдин қочқарлириңни йегиним йоқ. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Боғуветилгәнлирини қешиңға елип кәлмәй, бу зиянни өзүм толдурдум; кечиси оғриланған яки күндүзи оғриланған болсун сән уни мәндин төлитип алдиң. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Мениң күнлирим шундақ өттики, күндүзи иссиқтин, кечиси соғтин қийнилип, уйқа көзүмдин қачатти. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Мениң күнлирим мошу жигирмә жилда өйүңдә туруп шундақ болди; он төрт жил икки қизиң үчүн саңа хизмәт қилдим, алтә жил падаң үчүн хизмәт қилдим; униң үстигә сән иш һәққимни он қетим өзгәрттиң. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Әгәр атамниң Худаси, йәни Ибраһимниң Худаси, йәни Исһақниң Қорқунучиси Болғанниң Өзи мән билән биллә болмиса еди, сән җәзмән мени қуруқ қол қилип қайтуруветәттиң. Лекин Худа мениң тартқан җәбир-җапалиримни, қоллиримниң мушәққитини көрүп түнүгүн кечә саңа тәнбиһ бәрди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Лабан Яқупқа җавап берип: — Бу қизлар мениң қизлирим, бу оғуллар мениң оғуллирим, бу пада болса мениң падам болиду; шундақла көз алдиңдики һәммә нәрсә миниңкидур; амма мән бүгүн бу қизлиримни вә уларниң туққан оғуллирини немә қилай? ");
INSERT INTO uigcyr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Қени кәл, сән билән иккимиз бир әһдә түзүшәйли, бу мән билән сениң оттуримизда гува болсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Шуниң билән Яқуп бир ташни елип өрә тикләп түврүк қилип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Андин Яқуп қериндашлириға: — Таш жиғиңлар, — девиди, ташларни елип келип догилиди, шу йәрдә таш догисиниң йенида ғизалиништи. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Лабан бу догини «Йәгар-Саһадута» дәп атиди, Яқуп униңға «Галеәд» дәп ат қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Лабан: — Бу дога бүгүн сән билән мениң оттурамда гува болсун, — деди. Шуңа бу сәвәптин догиниң нами «Галеәд» аталди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","У җай йәнә «Мизпаһ», дәпму аталди; чүнки Лабан йәнә: — Иккимиз бир-биримиз билән көрүшмигән вақитларда, Пәрвәрдигар сән билән мениң оттурамда қаравул болуп күзитип турсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Әгәр сән қизлиримни бозәк қилсаң, яки қизлиримниң үстигә башқа хотунларни алсаң, башқа һеч киши қешимизда һазир болмиған тәғдирдиму, мана, Худа мән билән сениң араңда гувачидур! ");
INSERT INTO uigcyr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Лабан Яқупқа йәнә: — Мана, бу догиға қара, мән билән сән иккимизниң оттурисида мән тикләп қойған бу түврүккиму қара; ");
INSERT INTO uigcyr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","кәлгүсидә бу дога вә бу түврүкму мән яман нийәт билән бу догидин сениң тәрипиңгә өтмәслигим үчүн, сениңму нийитиңни яман қилип бу дога вә бу түврүктин өтүп мениң тәрипимгә кәлмәслигиң үчүн гувачи болсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ибраһимниң илаһи, Наһорниң илаһи вә бу иккисиниң атисиниң илаһлири аримизда һөкүм чиқарсун, — деди. Яқуп болса атиси Исһақниң Қорқунучиси Болғучи билән қәсәм қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Андин Яқуп тағ үстидә бир қурбанлиқ сунуп, қериндашлирини өзи билән тамақлинишқа тәклип қилди. Улар һәмдәстихан олтарди вә кечиси тағда қонди. ");
INSERT INTO uigcyr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Әтиси таң сәһәрдә Лабан орнидин туруп, нәврилири билән қизлирини сөйүп, уларға бәхит-бәрикәт тиләп, өз өйигә раван болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Яқуп өз йолиға кетип баратти; йолда Худаниң пәриштилири униңға учриди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Яқуп уларни көрүп: — Бу җай Худаниң баргаһи екән! — дәп, бу җайниң намини «Маһанаим» дәп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Андин Яқуп Сеир зиминидики «Едом яйлиғи»ға, акиси Әсавниң қешиға алдин хәвәрчиләрни әвәтип, ");
INSERT INTO uigcyr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","уларға җекиләп: — Силәр ғоҗамға, йәни Әсавға: «Кәминилири Яқуп мундақ деди: — Мән Лабанниң қешида мусапир болуп, та мошу вақитқичә турдум. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Әнди мәндә кала, ешәк вә қойлар, қул-дедәкләрму бар; мән өзлириниң нәзиридә илтипат тапармәнмекин дәп ғоҗамға хәвәр йәткүзүшни лайиқ көрдүм», дәңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Хәвәрчиләр Яқупниң йениға йенип келип: — Биз акилири Әсавниң қешиға бардуқ; у төрт йүз кишини елип, силиниң алдилириға келиватиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Яқуп наһайити қорқуп, ғәм-ғуссигә чүшүп адәмлирини қой, кала вә төгилиригә қошуп, икки топқа айриди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","У: — «Әгәр Әсав келип бир топимизға һуҗум қилса, йәнә бир топ қечип қутулуп қалар» — дәп ойлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Андин Яқуп мундақ дуа қилди: — И атам Ибраһимниң Худаси вә атам Исһақниң Худаси! Маңа: «Өз зиминиң вә уруқ-туққанлириңниң қешиға йенип кәткин, саңа яхшилиқ қилимән» дәп вәдә қилған Пәрвәрдигар! ");
INSERT INTO uigcyr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","— Мән Сениң Өз қулуңға көрсәткән өзгәрмәс барлиқ меһриванлиғиң вә барлиқ вападарлиғиң алдида һеч немә әмәсмән; чүнки мән бу Иордан дәриясидин өткинимдә ялғуз бир һасам бар еди. Әнди мән икки топ адәм болуп қайтиватимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Өтүнүп қалай, мени акам Әсавниң қолидин қутқузғайсән; чүнки у келип мән билән хотун-балилиримни өлтүрүветәмдикин, дәп қорқимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Сән: «Мән җәзмән саңа зор яхшилиқ қилип, сениң нәслиңни деңиздики қумдәк һәдди-һесапсиз көп қилимән», дегән едиң, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","У шу кечиси шу йәрдә қонуп қалди; андин у қол илигидики маллардин елип, акиси Әсавға икки йүз өчкә, жигирмә текә, икки йүз сағлиқ, жигирмә қочқар, оттуз чиши төгини тайлақлири билән, қириқ инәк, он буқа, жигирмә мада ешәк, он һаңга ешәкни соғат қилип тәйярлап, ");
INSERT INTO uigcyr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Буларни айрим-айрим топ қилип хизмәткарлириниң қолиға тапшуруп, уларға җекиләп: — Силәр мәндин бурун меңип, һәр топниң арисида арилиқ қоюп һайдап меңиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","У әң алдидики топ билән маңған кишикә әмир қилип: — Акам Әсав саңа учриғанда, әгәр у сәндин: «Кимниң адимисән? Қәйәргә барисән? Алдиңдики җаниварлар кимниң?» — дәп сориса, ");
INSERT INTO uigcyr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ундақта сән җавап берип: «Булар кәминилири Яқупниң болуп, ғоҗам Әсавға әвәткән соғаттур. Мана, у өзиму кәйнимиздин келиватиду» — дегин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Шу тәриқидә у иккинчи, үчинчи вә улардин кейинки падиларни һайдап маңғучи кишиләргиму охшаш әмир қилип: — Әсав сизләргә учриғанда, силәрму униңға шундақ дәңлар, андин: — Мана, кәминилири Яқуп өзиму арқимиздин келиватиду, — дәңлар, деди; чүнки у: — Мән алдимда барған соғат билән уни мени кәчүрүм қилдуруп, андин йүзини көрсәм, мени қобул қилармекин, — дәп ойлиған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Шундақ қилип соғат алдин әвәтилди; у шу кечиси баргаһта қонуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","У шу кечидә қопуп, икки аяли вә икки дедиги вә он бир оғлини елип, Яббок кечигидин өтүп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","У уларни еқиндин өткүзди, шундақла һәммә тәәллуғиниму у қарши тәрәпкә өткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Яқуп болса бу қатта ялғуз қалди; бир зат келип шу йәрдә униң билән таң атқичә челишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Лекин бу зат уни йеңәлмәйдиғанлиғини көрүп, униң янпишиниң йириқиға қолини тәккүзүп қойди; шуниң билән улар челишиватқанда Яқупниң янпиши қазандин чиқип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","У зат: — Мени қоюп бәргин, чүнки таң атай дәп қалди, деди. — Сән мени бәрикәтлимигичә, сени қоюп бәрмәймән, деди Яқуп. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","У униңдин: — Етиң немә? дәп сориди. У: етим Яқуп, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","У униңға: — Сениң етиң буниңдин кейин Яқуп болмай, бәлки Исраил болиду; чүнки сән Худа биләнму, инсан биләнму елишип ғалип кәлдиң, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Андин Яқуп униңдин: — Намиңни маңа дәп бәргин, девиди, у: — Немишкә мениң намимни сорайсән? — деди вә шу йәрдә униңға бәхит-бәрикәт ата қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Шуниң билән Яқуп: — Худани йүзму-йүз көрүп, җеним қутулуп қалди, дәп у җайниң намини «Пәниәл» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","У Пәниәлдин өтүп маңғанда, күн униң үстибешини йорутти; амма у янпиши түпәйлидин ақсап маңатти . ");
INSERT INTO uigcyr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Бу сәвәптин Исраиллар бүгүнгичә йотиниң үгисидики пәйни йемәйду; чүнки шу Зат Яқупниң янпишиниң йириқиға, йәни униң пейигә қолини тәккүзүп қойған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Яқуп бешини көтирип қаривиди, мана Әсав төрт йүз киши билән келивататти. Шуниң билән у балилирини айрип, Леяһ, Раһилә вә икки дедәккә тапшурди; ");
INSERT INTO uigcyr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","у икки дедәк вә уларниң балилирини һәмминиң алдида маңдурди, андин Леяһ билән униң балилирини, әң ахирида Раһилә билән Йүсүпни маңдурди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Өзи болса уларниң алдиға өтүп маңди, у акисиниң алдиға йетип барғичә йәттә қетим йәргә баш уруп тазим қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Әсав униң алдиға жүгүрүп келип, уни қучағлап, бойниға бешини қоюп, уни сөйди; һәр иккиси жиғлишип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Андин Әсав бешини көтирип қарап, аяллар вә балиларни көрүп: — Бу сән билән биллә кәлгәнләр кимләр? — дәп сориди. Яқуп: — Булар Худа шапаәт қилип кәминилиригә бәргән балилардур, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Андин икки дедәк вә уларниң балилири алдиға берип, униңға тазим қилди; ");
INSERT INTO uigcyr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Андин Леяһму униң балилири билән алдиға берип, тазим қилди, ахирида Йүсүп билән Раһилә алдиға берип, тазим қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Әсав: — Маңа йолда учриған әшу топлириңда немә мәхситиң бар? — девиди, Яқуп җавап берип: — Бу ғоҗамниң алдида илтипат тепишим үчүндур, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Лекин Әсав: — Әй қериндишим, мәндә йетип ашқидәк бар. Сениң өз нәрсилириң өзүңгә қалсун, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Амма Яқуп: — Ундақ қилмиғин; әгәр мән нәзәрлиридә илтипат тапқан болсам, соғитимни қолумдин қобул қилғайла; чүнки силиниң мени хошаллиқ билән қобул қилғанлирини көрүп, дидарлирини көргинимдә Худаниң дидарини көргәндәк болдум! ");
INSERT INTO uigcyr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Әнди саңа кәлтүрүлгән, Худадин көргән бу бәрикәтлиримни қобул қилғайла; чүнки Худа маңа шапаәт көрсәтти, һәммә нәрсилирим бар болди, — дәп униңдин қайта-қайта өтүнүвиди, у қобул қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Андин Әсав: — Әнди биз қозғилип сәпиримизни давамлаштурайли, мән сениң алдиңда маңай, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","У униңға җававән: — Ғоҗам көрдилә, балилар кичик, қешимда емидиған қоза вә мозайлар бар; әгәр мән буларни бир күнла алдиртип қоғлап маңдурсам, пүткүл пада өлүп кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Шуңа өтүнимәнки, ғоҗам кәминилиридин алдида маңғач турсун; мән алдимдики мал-чарвиларниң меңишиға, шундақла балиларниң меңишиға қарап аста меңип, ғоҗамниң қешиға Сеирға удул барай, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","У вақитта Әсав: — Ундақ болса, мән өзүм билән кәлгән кишиләрдин бир нәччини қешиңда қоюп кетәй, деди. Лекин у җавап берип: — Буниң немә һаҗити? Пәқәт ғоҗамниң нәзиридә илтипат тапсамла шу купайә, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Әсав у күни йолға чиқип Сеирға йенип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Яқуп сәпәр қилип, Суккот дегән җайға кәлгәндә, у йәргә бир өй селип, маллириға лапасларни ясиди. Шуңа бу йәр «Суккот» дәп аталди. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Шу тәриқидә Яқуп Падан-Арамдин қайтип, Қанаан зиминидики Шәкәм шәһиригә аман-есән кәлди. У шәһәрниң алдида чедир тикти. ");
INSERT INTO uigcyr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Андин у чедир тиккән йәрниң бир қисимини Шәкәмниң атиси болған Һаморниң оғуллиридин бир йүз қәситигә сетивелип, ");
INSERT INTO uigcyr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Шу йәрдә бир қурбангаһ селип, намини «Әл-Әлоһә-Исраил» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Бир күни, Леяһниң Яқупқа туғуп бәргән қизи Динаһ жутниң қизлири билән көрүшкили чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Шу жутниң әмри һивий Һаморниң оғли Шәкәм уни көрүп қелип, уни тутувелип, зорлап номусиға тәгди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Амма униң көңли Яқупниң қизи Динаһқа чүшүп, уни яхши көрүп қалди вә униңға муһәббити билән көңүл сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Шуниң билән Шәкәм атиси Һамордин: — Бу қизни маңа хотунлуққа елип бәргин, дәп тәләп қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Яқуп Шәкәмниң қизи Динаһниң иппитигә тәккәнлигини аңлап қалди. Униң оғуллири маллири билән далаларда еди; шуңа Яқуп улар кәлгичә җим туруп турди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Шәкәмниң атиси Һамор Яқупниң алдиға униң билән сөзләшкили чиқти; ");
INSERT INTO uigcyr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Яқупниң оғуллири хәвәрни аңлапла далалардин қайтип кәлгән еди. Булар Шәкәмниң қилмайдиған ишни қилип, Яқупниң қизиниң номусиға тегип Исраил қәбилисидә шәрмәндилик қилғини үчүн азаплинип, интайин қаттиқ ғәзәпләнди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Һамор уларға сөз қилип: — Оғлум Шәкәмниң көңли қизиңларға чүшүп қапту. Илтипат қилип уни оғлумға хотунлуққа бәрсәңлар! ");
INSERT INTO uigcyr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Биз билән қуда-баҗа болуп, қизлириңларни бизгә бериңлар, бизниң қизлиримизниму силәр елиңлар; ");
INSERT INTO uigcyr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Биз билән биллә туруңлар. Мана, йәр алдиңларда турупту; бу йәрни макан қилип, сода қилип, өзүңлар үчүн өй-мүлүк елиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Шәкәм қизниң атиси билән ака-укилириға: — Нәзириңларда илтипат тапсам дәймән; силәр немә десәңлар, шуни берәй. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Мәндин қанчилик тойлуқ яки соғат тәләп қилсаңлар, маңа ейтқиниңларчә берәй; пәқәт бу қизни маңа хотунлуққа бәрсәңларла болиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Яқупниң оғуллири болса Шәкәм вә атиси Һаморға һейлә-микир билән җавап бәрди, чүнки у сиңлиси Динаһниң иппитигә тәккән еди; ");
INSERT INTO uigcyr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","уларға: — Биз бундақ қилалмаймиз, сиңлимизни хәтнисиз бирисигә беришкә мақул дейәлмәймиз; чүнки бу бизгә номус болиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Пәқәт бир шәртимизгә көнсәңларла силәргә мақул болимиз; силәрниң барлиқ әркәклириңлар хәтнә қилинип биздәк болса, ");
INSERT INTO uigcyr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Қизлиримизни силәргә берип, силәрниң қизлириңларни биз елип араңларда олтирип, бир қовм болуп қалимиз. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Амма бизгә қулақ салмай хәтнә қилинишқа унимисаңлар, ундақта биз қизимизни елип кетимиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Уларниң сөзлири Һамор вә оғли Шәкәмниң нәзиригә яқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Жигит бу ишни кәйнигә созмиди, чүнки у Яқупниң қизиға еҗил болуп қалған еди; у атисиниң өйидә һәммидин әтиварлиқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Шуниң билән Һамор оғли Шәкәм билән шәһәрниң дәрвазисиға берип, шәһәрниң адәмлиригә сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Бу адәмләрниң биз билән енақ өткүси бар. Шуңа улар мошу жутта туруп сода-сетиқ қилсун; мана, бу җайниң икки тәрипи уларға йәткидәк кәңридур. Биз уларниң қизлирини хотунлуққа елип, өз қизлиримизни уларға беримиз. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Лекин пәқәт аримиздики һәммә әркәк улар хәтнә қилинғандәк хәтнә қилинса, у адәмләр аримизда туруп биз билән бир хәлиқ болушқа мақул дәйду. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Шу тәриқидә уларниң мал-тәәллуқати, һәммә чарпайлири бизниңки болмамду? Биз пәқәт уларға мақул десәкла, улар аримизда туриду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Шуниң билән шәһәрниң дәрвазисидин кирип-чиқидиғанларниң һәммиси Һамор билән оғли Шәкәмниң сөзигә қулақ салди. Шәһәрниң дәрвазисидин кирип-чиқадиғанларниң һәммиси хәтнә қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Амма үчинчи күни, улар техичә ағриқ ятқинида шундақ болдики, Яқупниң икки оғли, йәни Динаһниң акилири Шимеон билән Лавий һәр қайсиси өз қиличини елип, шәһәр хатирҗәмлик ичидә турғинида бесип кирип, һәммә әркәкни өлтүрүвәтти;    ");
INSERT INTO uigcyr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Улар Һамор билән оғли Шәкәмниму қиличлап, Динаһни Шәкәмниң өйидин елип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Андин Яқупниң барлиқ оғуллири: «Улар сиңлимизниң номусиға тәгди» дәп, өлтүрүлгәнләрниң җайиға келип, шәһәрни булап-талаң қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Уларниң қой-кала, ешәклирини, шәһәрдики һәммини, етизлиқлардики һәммини елип кәтти, ");
INSERT INTO uigcyr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Шундақла уларниң барлиқ мал-мүлкини булап-талап, барлиқ хотун-балиларни әсир қилип, өй ичидики барлиқ нәрсиләрниму қошуп елип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Яқуп Шимеон вә Лавийни әйипләп: — Силәр мени балаға тиқип, зиминдикиләр — Ⱪананийлар билән Пәриззийләрниң алдида сеситтиңлар. Бизниң адимимиз аз бир хәлиқтурмиз; улар маңа қарши чиқип жиғилип һуҗум қилиду; шуниң билән мән вә җәмәтим вәйран болимиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Амма улар җавап берип: — Әҗәба, сиңлимизға бир паһишә аялға қилғандәк муамилә қилса боламду? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Андин Худа Яқупқа: — Сән һазир Бәйт-Әлгә чиқип, шу йәрни макан қил, өзүң акаң Әсавдин қечип маңғиниңда саңа көрүнгән Мән Тәңригә бир қурбангаһ ясиғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Шуниң билән Яқуп өйидикиләр вә өзи билән биллә болғанларниң һәммисигә мундақ деди: — Араңлардики ят илаһ бутлирини ташливетип, өзүңларни паклап егинлириңларни йәңгүшләңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Андин қопуп Бәйт-Әлгә чиқимиз. Мән шу йәрдә қийинчилиқта қалғанда дуайимни иҗабәт қилип, жүргән йолумда мениң билән биллә болуп кәлгән Тәңригә қурбангаһ салай, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Шуниң билән өз қоллиридики һәммә ят илаһ бутлирини, шундақла қулақлиридики зириләрни чиқирип Яқупқа бәрди. Яқуп буларни Шәкәмдики дуб дәриғиниң түвигә көмүп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Андин улар сәпәргә атланди; амма әтрапидики шәһәрләрни Худадин болған бир вәһимә басқачқа, улар Яқупниң оғуллирини қоғлимиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Бу тәриқидә Яқуп вә униң билән биллә болғанларниң һәммиси Қанаан зиминидики Луз, йәни Бәйт-Әлгә йетип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","У шу йәрдә бир қурбангаһ ясиди; акисидин қечип маңғинида шу йәрдә Худа униңға көрүнгини үчүн бу җайниң исмини «Әл-Бәйт-Әл» дәп атиди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ривкаһниң баққан аниси Дәбораһ болса шу йәрдә аләмдин өтти. У Бәйт-Әлниң айиғидики дуб дәриғиниң түвидә дәпнә қилинди. Бу сәвәптин шу дәрәқ «Жиға-Зарниң дуб дәриғи» дәп аталди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Яқуп шу йол билән Падан-Арамдин йенип кәлгәндин кейин, Худа униңға йәнә бир қетим көрүнүп, униңға бәхит-бәрикәт ата қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Андин Худа униңға: — Сениң исмиң Яқуптур; амма мундин кейин сән Яқуп аталмай, бәлки намиң Исраил болиду, дәп униң исмини Исраил қоюп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Андин Худа йәнә униңға: — Мән Өзүм Һәммигә Қадир Тәңридурмән; сән нәсиллинип, көпәйгин; бир әл, шундақла бир түркүм әлләр сәндин пәйда болиду; падишаларму сениң пуштуңдин чиқиду.    ");
INSERT INTO uigcyr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Мән Ибраһим вә Исһаққа бәргән зиминни саңа беримән, шундақла сәндин кейинки нәслиңгиму шу зиминни беримән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Андин Худа униң билән сөзләшкән җайдин, униң йенидин жуқуриға көтирилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Яқуп Худа өзи билән сөзләшкән җайда бир таш түврүкни тикләп, үстигә бир шарап һәдийәсини төкти вә зәйтун мейи қуюп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Яқуп Худа өзи билән сөзләшкән шу җайниң намини «Бәйт-Әл» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Андин улар Бәйт-Әлдин меңип, Әфратқа азғина йол қалғанда, Раһиләни толғақ тутуп кетип, қаттиқ туғут азавида қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Амма толғиғи қаттиқ еғирлашқанда, туғут аниси униңға: — Қорқмиғин, бу қетим йәнә бир оғлуң болидиған болди — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Шундақ болдики, Раһилә җени чиқиш алдида, ахирқи нәпәси билән оғлиға «Бән-Они» дәп исим қойди; амма униң атиси уни «Бән-Ямин» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Раһилә вапат болди вә Бәйт-Ләһәм дәп атилидиған Әфратниң йолиниң бойиға дәпнә қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Яқуп униң қәбриниң үстигә бир хатирә теши тикләп қойди. Бүгүнгә қәдәр «Раһиләниң Қәбир Теши» шу йәрдә турмақта. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Андин Исраил сәпәрни давамлаштуруп Мигдал-Едирниң у тәрипидә өз чедирини тикти. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Исраил у зиминда турған вақтида, Рубән берип өз атисиниң кенизиги Билһаһ билән бир орунда ятти; Исраил буни аңлап қалди. Яқупниң он икки оғли бар еди: — ");
INSERT INTO uigcyr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Леяһдин туғулған оғуллири: — Яқупниң тунҗа оғли Рубән вә Шимеон, Лавий, Йәһуда, Иссакар һәм Зәбулун еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Раһиләдин туғулған оғуллири: — Йүсүп вә Бинямин еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Раһиләниң дедиги Билһаһдин туғулған оғуллири: — Дан вә Нафтали еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Леяһниң дедиги Зилпаһдин туғулған оғуллири: — Гад билән Ашир еди. Булар болса Яқупқа Падан-Арамда туғулған оғуллири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Әнди Яқуп атиси Исһақниң қешиға, Ибраһим вә Исһақ мусапир болуп турған Кириат-Арба, йәни Һебронниң йенидики Мамрәгә кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Исһақниң көргән күнлири бир йүз сәксән жил болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Исһақ толиму қерип, күнлири тошуп, нәпәстин тохтап вапат болди вә өз қовминиң қешиға берип қошулди. Униң оғуллири Әсав билән Яқуп уни дәпнә қилди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Төвәндикиләр Әсавниң әвлатлиридур (Әсав йәнә Едом дәпму атилиду): —    ");
INSERT INTO uigcyr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Әсав аяллирини Ⱪананийларниң қизлиридин алди, йәни Һиттийлардин болған Елонниң қизи Адаһ билән һивийлардин болған Зибеонниң нәвриси, Анаһниң қизи Оһолибамаһни алди; ");
INSERT INTO uigcyr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","униңдин башқа Исмаилниң қизи, Небайотниң сиңлиси Басиматниму алған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Адаһ Әсавға Елифазни туғуп бәрди; Басимат болса Реуәлни туғди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Оһолибамаһ Йәуш, Яалам вә Кораһни туғди; булар Қанаан зиминида Әсавға туғулған оғуллар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Әсав аяллири, оғул-қизлири, өйидики һәммә кишилирини вә чарпайлирини, барлиқ улақлирини, шундақла Қанаан зиминида тапқан барлиқ тәәллуқатлирини елип, иниси Яқуптин айрилип, башқа бир жутқа көчүп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Чүнки һәр иккисиниң тәәллуқатлири интайин көп болғачқа, бир йәрдә биллә туралмайтти; мусапир болуп турған зимин уларниң мал-чарвилириниң көплүгидин уларни бақалмайтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Буниң билән Әсав (Әсав Едом дәпму атилиду) Сеир теғиға берип, олтирақлишип қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Төвәндикиләр тағлиқ район Сеирдики Едомийларниң ата-бовиси Әсавниң әвлатлиридур: — ");
INSERT INTO uigcyr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Әсавниң оғуллири: — Әсавниң аяли адаһниң оғли Елифаз; Әсавниң аяли Басиматниң оғли Реуәл. Елифазниң оғуллири: — Теман, Омар, Зәфо, Гатам вә Кәназ еди. Әсавниң оғли Елифазниң кичик хотуни Тимна еди; у Елифазға Амаләкни туғуп бәрди. Жуқирилар болса Әсавниң аяли адаһниң әвлатлири еди. Реуәлниң оғуллири: — Наһат, Зәраһ, Шаммаһ вә Миззаһ еди; булар Әсавниң аяли Басиматниң әвлатлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Әсавниң аяли, йәни Зибеонниң чоң қизи, Анаһниң қизи болған Оһолибамаһниң оғуллири: у Әсавға Йәуш, Яалам вә Кораһни туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Әсавниң әвлатлириниң ичидин төвәндики әмирләр чиққан: — Әсавниң тунҗа оғли Елифазниң оғуллиридин: — әмир Теман, әмир Омар, әмир Зәфо, әмир Кеназ, ");
INSERT INTO uigcyr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","әмир Кораһ, әмир Гатам вә әмир Амаләк чиққан. Булар Едом зиминида Елифазниң нәслидин чиққан әмирләр болуп, Адаһниң әвлатлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Әсавниң оғли Реуәлниң оғуллиридин әмир Наһат, әмир Зәраһ, әмир Шаммаһ вә әмир Миззаһлар чиққан; булар Едом зиминида Реуәлниң нәслидин чиққан әмирләрдур; буларниң һәммиси Әсавниң аяли Басиматниң әвлатлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Әсавниң аяли Оһолибамаһниң оғуллиридин әмир Йәуш, әмир Яалам вә әмир Кораһлар чиққан. Булар Анаһниң қизи, Әсавниң аяли Оһолибамаһниң нәслидин чиққан әмирләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Булар Әсавниң, йәни Едомниң әвлатлири болуп, едомийларниң әмирлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Һорийлардин болған Сеирниң Едом зиминида олтарған әвлатлири: — Лотан, Шобал, Зибеон, Анаһ, Дишон, Езәр вә Дишан еди. Булар Сеирниң әвлатлири болуп, Едом зиминида Һорийларниң әмирлири еди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Лотанниң оғуллири Һори билән Һемам еди; Лотанниң сиңлиси Тимна еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Шобалниң оғуллири: Алван, Манаһат, Ебал, Шефо вә Онам еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Зибеонниң оғуллири: — Аяһ вә Анаһ еди. Бу Анаһ чөлдә атиси Зибеонниң ешәклирини беқиветип, аршаңларни тепивалған Анаһниң дәл өзи шу еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Анаһниң пәрзәнтлири: оғли Дишон; Анаһниң қизи Оһолибамаһ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Дишонниң оғуллири: Һәмдан, Әшбан, Итран вә Керан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Езәрниң оғуллири: Билһан, Зааван вә Акан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Дишанниң оғуллири: Уз вә Аран еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Һорийларниң өзлириниң әмирлири: әмир Лотан, әмир Шобал, әмир Зибеон, әмир Анаһ, әмир Дишон, әмир Езәр вә әмир Дишан еди. Булар болса Һорийларниң Сеир зиминида өз намлири бойичә аталған қәбилиләрниң әмирлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Исраилларниң үстигә һеч падиша техи сәлтәнәт қилмаста Едом зиминида сәлтәнәт қилған падишалар төвәндикидәк: — ");
INSERT INTO uigcyr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Беорниң оғли Бела Едомда сәлтәнәт қилди; униң шәһириниң исми Динһабаһ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Бела өлгәндин кейин, Бозраһлиқ Зәраһниң оғли Йобаб униң орнида сәлтәнәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Йобаб өлгәндин кейин, теманийларниң зиминидин кәлгән Һушам униң орнида сәлтәнәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Һушам өлгәндин кейин, Бедадниң оғли Һадад униң орнида сәлтәнәт қилди. У Моабниң яйлақлирида мидиянийларға һуҗум қилип йәңгән еди. Униң шәһириниң исми Авит еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Һадад өлгәндин кейин, масрәкаһлиқ Самлаһ униң орнида сәлтәнәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Самлаһ өлгәндин кейин, «Дәрияниң бойидики Рәһобот»тин кәлгән Саул униң орнида сәлтәнәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Саул өлгәндин кейин, Акборниң оғли Баал-һанан униң орнида сәлтәнәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Акборниң оғли Баал-һанан өлгәндин кейин, Һадар униң орнида сәлтәнәт қилди. Униң шәһириниң исми Пау еди. Униң аялиниң исми Мәһетабәл болуп, у Мәй-Заһабниң қизи болған Матрәдниң қизи еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Әсавниң нәслидин болған әмирләр уларниң ат-исимлири, җәмәтлири, нәсәбнамилири вә турған җайлири бойичә: әмир Тимна, әмир Алваһ, әмир Йәһәт, әмир Оһолибамаһ, әмир Елаһ, әмир Пинон, әмир Кеназ, әмир Теман вә әмир Мибзар, әмир Магдийәл вә әмир Ирамлар еди. Булар Едомийларниң әмирлири болуп, өзлири егиләп олтирақлашқан җайлар өз намлири билән аталған еди. Мана шу тәриқидә Әсав Едомийларниң ата-бовиси болди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Яқуп болса атиси мусапир болуп турған йәрдә, йәни Қанаан зиминида олтирақлашти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Төвәндикиләр Яқуп әвлатлириниң иш-излиридур. Йүсүп жигит болуп он йәттә яшқа киргән чағлирида, акилири билән биллә қойларни бақатти; у атисиниң кичик хотунлири Билһаһ вә Зилпаһниң оғуллири билән биллә ишләйтти. Йүсүп атисиға уларниң начар қилиқлирини ейтип қоятти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Йүсүп Исраилниң қериған вақтида тапқан балиси болғачқа, уни башқа оғуллиридин бәкрәк яхши көрәтти. Шуңа у Йүсүпкә узун йәңлик тон тиктүрүп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Амма акилири атисиниң уни өзлиридин яхши көридиғинини көрүп, униңға өч болуп қалған еди вә униңға чирайлиқ гәп қилматти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Униң үстигә Йүсүп бир чүш көргән болуп, уни акилириға дәп беривиди, улар униңға техиму өч болуп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Йүсүп уларға мундақ деди: — Мениң көргән шу чүшүмни аңлап беқиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Мана, биз һәммимиз етизларда ашлиқларни бағлаватқидәкмиз. Қарисам мениң өнчәм өрә туруптидәк; силәрниң өнчәңлар болса мениң өнчәмниң чөрисигә олишип тазим қилип турғидәк! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Акилири униңдин: — Әҗәба, сән бизгә падиша боламсән? Үстимизгә һөкүмранлиқ қиламсән? — дәп сориди. Униң көргән чүшлири вә гепидин акилири уни техиму яман көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Кейин у йәнә бир чүш көрди вә чүшини акилириға дәп: — Мана, мән йәнә бир чүш көрдүм. Қарисам, қуяш билән ай вә он бир юлтуз маңа тазим қилип турғидәк! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","У бу чүшни атиси вә акилириға дәп бәрди. Атиси униңға тәнбиһ берип: — Бу көргиниң зади қандақ чүш? Әҗәба, мән, анаң вә ака-укилириң алдиңға берип, саңа йәргә баш уруп тазим қилимизму? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Шуниң билән акилири униңға һәсәт қилғили турди. Амма атиси шу гәпни көңлигә пүкүп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Әнди Йүсүпниң қериндашлири атисиниң қойлирини баққили Шәкәмгә кәткән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Исраил Йүсүпкә: — Акилириң Шәкәмдә пада беқиватидиғу? Кәл, мән сени уларниң қешиға әвәтәй, девиди, Йүсүп: — Мана мән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","У униңға: — Әнди берип акилириң аман-есәнму-әмәсму, қойлар аман-есәнму-әмәсму, маңа хәвирини елип кәлгин, дәп уни Һеброн җилғисидин йолға салди; у Шәкәмгә барди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Шу йәрдә бириси униң далада тенәп жүргинини көрүп униңдин: — Немә издәватисән, дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","У: — Мән акилиримни издәватимән. Уларниң падилирини қәйәрдә беқиватқанлиғини ейтип бәрсиңиз, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","У адәм җавап берип: — Улар бу йәрдин кетип қалди, чүнки мән уларниң: «Жүрүңлар, Дотанға барайли» дегинини аңлидим, деди. Шуниң билән Йүсүп акилириниң арқисидин берип, уларни Дотандин тапти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Улар уни жирақтин көрүп, у техи уларниң қешиға кәлмәйла, уни өлтүрүветишни мәслиһәтләшти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Улар бир-биригә: — Мана һелиқи чүш көргүчи келиватиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Келиңлар, уни өлтүрүп мошу йәрдики орәкләрдин биригә ташливетәйли, андин: — Вәһший бир һайван уни йәп кетипту, дәйли. Шунда, биз униң чүшлириниң немә болидиғинини көримиз! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Амма Рубән буни аңлап уни уларниң қоллиридин қутқузмақчи болуп: — Уни өлтүрмәйли, деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Рубән уларға йәнә: — Қан төкмәңлар! Бәлки уни чөлдики мошу орәккә ташливетиңлар; лекин униңға қол тәккүзмәңләр, деди (әмәлийәттә, у уни уларниң қолидин қутқузуп, атисиниң қешиға қайтурувәтмәкчи еди). ");
INSERT INTO uigcyr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","Йүсүп акилириниң қешиға йетип кәлгәндә улар уни тутуп, униң алаһидә тонини, йәни кийиклик узун йәңлик тонини салдурувелип, орәккә ташливәтти. Лекин орәк қуруқ болуп, ичидә су йоқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Андин улар тамақ йегили олтарди. Улар бешини көтирип қаривиди, мана Исмаилларниң бир карвини Гилеад тәрәптин келивататти. Төгилиригә дора-дәрмәк, тутия вә мурмәккиләр артилған болуп, Мисир тәрәпкә кетивататти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Йәһуда қериндашлириға: — Бизниң бир туққан қериндишимизни өлтүрүп, қенини йошурғинимизниң немә пайдиси бар? ");
INSERT INTO uigcyr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Келиңлар, уни Исмаилларға сетиветәйли; қандақла болмисун у бизниң инимиз, бир туққан қериндишимиз; шуңа униңға қол салмайли, девиди, қериндашлири буниңға қулақ салди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Мидиянлиқ содигәрләр шу йәрдин өтүп кетиватқанда, улар Йүсүпни орәктин тартип чиқирип, уларға жигирмә күмүч тәңгигә сетивәтти. Булар болса Йүсүпни Мисирға елип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Рубән орәкниң йениға қайтип келип, Йүсүпниң орәктә йоқлуғини көрүп, кийимлирини житип, ");
INSERT INTO uigcyr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","инилириниң қешиға берип: — Бала йоқ туриду! Әнди мән нәгә барай?! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Амма улар Йүсүпниң тонини елип, бир текини боғузлап тонни униң қениға миләп, ");
INSERT INTO uigcyr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Андин узун йәңлик тонни атисиниң қешиға әвәтип, униңға: — Буни биз тепивалдуқ; бу оғлуңниң тониму-әмәсму, өзүң көрүп баққин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","У уни тонуп: — Бу дәрвәқә мениң оғлумниң тони екән; бир вәһший һайван уни йәп кәткән охшайду; шүбһисизки, Йүсүп титма-титма қиливетилипту! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Шуниң билән Яқуп кийимлирини житип, белигә бөз бағлап, нурғун күнләргичә оғли үчүн матәм тутти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Униң һәммә оғул-қизлири йениға келип униңға тәсәлли бәрсиму, у тәсәллини қобул қилмай: «Мән тәһтисараға чүшүп оғлумниң қешиға барғичә шундақ матәм тутимән!» деди. Йүсүпниң атиси шу пети униңға аһ-зар көтирип матәм тутти. ");
INSERT INTO uigcyr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Әнди мидиянийлар Йүсүпни Мисирға елип берип, Пирәвнниң бир ғоҗидари, пасибан беши Потифарға сатти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","У вақитларда шундақ болдики, Йәһуда ака-укилириниң қешидин кетип, Һираһ исимлиқ Адулламлиқ бир кишиниңкигә чүшти. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Шу йәрдә Йәһуда Шуа исимлиқ бир Ⱪананийниң қизини көрди; у уни хотунлуққа елип қешиға кирип ятти.    ");
INSERT INTO uigcyr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","У һамилдар болуп бир оғул туғди; Йәһуда униңға «Әр» дәп ат қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","У йәнә һамилдар болуп, бир оғул туғди вә униңға Онан дәп ат қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Андин йәнә һамилдар болуп бир оғул туғди вә униңға Шәлаһ дәп ат қойди. У туғулғанда Йәһуда Кезибда еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Йәһуда тунҗа оғли Әргә Тамар исимлиқ бир қизни елип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Лекин Йәһуданиң тунҗа оғли Әр Пәрвәрдигарниң нәзиридә рәзил болғачқа, Пәрвәрдигар уни өлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Бу чағда Йәһуда Онанға: — Акаңниң аялиниң қешиға кирип, уни хотунлуққа елип қериндашлиқ бурчини Ада қилип, акаң үчүн нәсил қалдурғин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Амма Онан бу нәсилниң өзигә тәвә болмайдиғанлиғини билип, акисиға нәсил қалдурмаслиқ үчүн һәр қетим акисиниң аяли билән биллә болғанда мәнисини йәргә ақтуруветәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Униң бу қилмиши Пәрвәрдигарниң нәзиридә рәзил көрүнгәчкә, униму өлтүрүвәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Йәһуда әнди келини Тамарға: — Оғлум Шәлаһ чоң болғичә атаңниң өйидә тул олтирип турғин, деди. Чүнки у ичидә: — Буму акилириға охшаш өлүп кетәрмекин, дәп қорқти. Шуниң билән Тамар берип атисиниң өйидә туруп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Әнди көп күнләр өтүп, Шуаниң қизи, Йәһудаға тәккән аял өлди. Йәһуда тәсәлли тапқандин кейин адулламлиқ дости Һираһ билән биллә өзиниң қой қирқиғучилириниң әһвалини билишкә Тимнаһқа чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Тамарға: — Қейинатаң қойлирини қирқиғили Тимнаһқа йол алди, дегән хәвәр йәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Шуниң билән Тамар Шәлаһ чоң болған болсиму, мән униңға хотунлуққа елип берилмидим, дәп қарап, туллуқ кийимини селиветип, чүмбәл тартип бәдинини орап, Тимнаһ йолиниң үстидә Әнаимға кириш еғизиға берип олтарди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Әнди Йәһуда уни йүзи йепиқлиқ һалда көргәндә: — Бу бир паһишә аял охшайду, дәп ойлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","У йолдин бурулуп униң йениға берип, өз келини екәнлигини билмәй: — Кәл, мән сән билән биллә болай, деди. У җавап берип: — Мән билән биллә болсаң, маңа немә берисән? дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","У униңға: — Падамниң ичидин бир оғлақни саңа әвәтип берәй, деди. Аял: — Сән уни әкелип бәргичә, маңа рәнигә бирәр нәрсә берәмсән? дәп соривиди, ");
INSERT INTO uigcyr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","У: — Саңа немини рәнигә берәй? — деди. У: — Өз мөһүрүң билән униң шойнисини вә қолуңдики һасаңни рәнигә бәргин, девиди, у буларни берип, униң билән биргә болди. Шуниң билән у униңдин һамилдар болуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Андин Тамар орнидин туруп маңди; у пәрәнҗини селиветип, туллуқ кийимини кийивалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Йәһуда: — У хотунниң қолидики рәнини яндуруп кәлсун дәп адулламлиқ достиниң қоли арқилиқ оғлақни әвәтти, амма у уни тапалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","У шу җайдики адәмләрдин: — Әнаимдики йолниң бойида олтарған бутпәрәс паһишә қени, дәп сориса, улар: — Бу йәрдә һеч бир бутпәрәс паһишә болған әмәс, дәп җавап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Буниң билән у Йәһуданиң қешиға йенип берип: — Мән уни тапалмидим; үниң үстигә у җайдики адәмләрму: «Бу йәрдә һеч бир бутпәрәс паһишә аял болған әмәс» дейишти, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Йәһуда: — Бопту, у нәрсиләрни у елип кәтсә кәтсун; болмиса, башқиларниң мәсқирисигә қалимиз. Немила болмисун, мән униңға оғлақ әвәттим, лекин сән у хотунни тапалмидиң, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Үч айчә өткәндин кейин бириси Йәһудаға: — Сениң келиниң Тамар бузуқчилиқ қилди, униң үстигә зинадин һамилдар болуп қалди, дегән хәвәрни йәткүзди. Йәһуда җававән: — Уни елип чиқиңлар, көйдүрүветилсун! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Лекин у елип чиқилғанда қейинатисиға хәвәр әвәтип: — Бу нәрсиләрниң егиси болған адәмдин һамилдар болдум! Әнди сән көрүп бақ, бу мөһүр, шойниси вә һасиниң кимниң екәнлигини етирап қилғин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Йәһуда бу нәрсиләрни етирап қилип: — У маңа нисбәтән һәқлиқтур; дәрвәқә мән уни оғлум Шәлаһқа елип бәрмидим, деди. Бу иштин кейин Йәһуда униңға йәнә йеқинчилиқ қилмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Униң туғут вақти йеқинлашти, мана қосиғида кош гезәк бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","У туққан вақтида балилардин бириси қолини чиқиривиди, туғут аниси дәрһал бир қизил жипни елип: «Бу авал чиқти» дәп униң қолиға чигип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Лекин у қолини йәнә ичигә тиқивалди, мана униң иниси чиқти. Шуниң билән туғут аниси: «Сән қандақ қилип бөсүп чиқтиң!» деди; шуниң билән униңға «Пәрәз» дегән ат қоюлди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Андин қолиға қизил жип чигилгән акиси туғулди. Униң исми Зәраһ дәп аталди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Йүсүп болса Мисирға елип келинди; уни Пирәвнниң ғоҗидари, пасибан беши Потифар шу йәргә елип кәлгән Исмаилларниң қолидин сетивалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Лекин Пәрвәрдигар Йүсүп билән биллә болғачқа, униң ишлири оңға тартти; у мисирлиқ ғоҗисиниң өйидә туруп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Униң ғоҗиси Пәрвәрдигарниң униң билән биллә екәнлигини, шундақла у немә иш қилса, Пәрвәрдигарниң униң қолида ронақ тапқузғанлиғини байқиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Шуниң билән Йүсүп униң нәзиридә илтипат тепип, униң хас хизмәтчиси болди. Ғоҗиси уни өйини башқурушқа қойди вә барлиқ тәәллуқатини униң қолиға тапшурди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Вә шундақ болдики, у уни өйи вә барлиқ тәәллуқатини башқурушқа қойғандин тартип, Пәрвәрдигар бу мисирлиқниң өйини Йүсүпниң сәвәвидин бәрикәтлиди; Пәрвәрдигарниң бәрикити униң пүтүн аилиси вә барлиқ териқчилиғиға кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Шуниң билән Потифар барлиқ ишлирини Йүсүпниң қолиға тапшуруп, өз тамиғини йейиштин башқа һеч қандақ иш билән кари болмиди. Йүсүп болса қамити келишкән, хушчирай жигит еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Бир нәччә вақит өткәндин кейин шундақ болдики, униң ғоҗисиниң аялиниң Йүсүпкә көзи чүшүп қелип: — Мән билән ятқин! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Амма у унимай ғоҗисиниң аялиға мундақ деди: — Мана ғоҗам өйдики ишларни, шундақла барлиқ тәәллуқатини қолумға тапшурди, маңа толиму ишинип ишлирим билән кари болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Бу өйдә мәндин чоң адәм йоқ. Сәндин башқа у һеч бир нәрсини мәндин айимиди — чүнки сән униң аялидурсән! Шундақ туруқлуқ мән қандақму бундақ рәзилликни қилип Худа алдида гунакар болай? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Гәрчә һәр күни Йүсүпкә шундақ десиму, шундақла у униң билән йетип униңға йеқинчилиқ қилишни яки униң билән биргә турушни рәт қилған болсиму, ");
INSERT INTO uigcyr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","шундақ бир вақиә болдики, бир күни у өз иши билән өй ичигә киргән еди, өйдикиләрдин һеч қайсиси өйниң ичидә әмәс еди; ");
INSERT INTO uigcyr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","бу аял униң тонини тутувелип: — Мән билән ятқин! деди. У тонини униң қолиға ташлап қоюп, жүгүргән пети қечип ташқириға чиқип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Аял Йүсүпниң тонини өз қолиға ташлап қечип чиқип кәткинини көрүп, ");
INSERT INTO uigcyr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","өйидики хизмәтчилирини чақирип уларға: — Қараңлар, ерим бизгә һақарәт кәлтүрсун дәп бир ибраний адәмни елип кәпту! Бу адәм йенимға кирип: «Сән билән ятай» девиди, қаттиқ вақиридим! ");
INSERT INTO uigcyr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","У мениң қаттиқ вақириғинимни аңлап, тонини йенимға ташлап, ташқириға қечип кәтти, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Шуниң билән ғоҗиси өйигә йенип кәлгичә у Йүсүпниң тонини йенида сақлап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Андин у еригиму шу гәпни қилип: — Сән елип кәлгән һелиқи ибраний қул маңа һақарәт қилишқа қешимға кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Лекин мән қаттиқ вақирап-җарқирдим, у тонини қешимда ташлап, ташқириға қечип кәтти, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Униң ғоҗиси аялиниң: — Сениң қулуң мени ундақ-мундақ қилди, дегән гәплирини аңлап ғәзиви оттәк туташти. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Шуниң билән Йүсүпниң ғоҗиси уни тутуп орда мунарлиқ зинданға қамап қойди. Шу йәргә пәқәт падишаниң мәһбуслири солинатти. Буниң билән у шу йәрдә солақта йетип қалди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Лекин Пәрвәрдигар Йүсүп билән биллә болуп, униңға шапаәт көрситип, уни зиндан бегиниң нәзиридә илтипат таптурди. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Шуниң билән зиндан беги гундиханида ятқан һәммә мәһбусларни Йүсүпниң қолиға тапшурди. Шу йәрдә қилинидиған һәр қандақ иш униң қоли билән болатти. ");
INSERT INTO uigcyr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Зиндан беги Йүсүпниң қолидики һеч қандақ иштин ғәм қилматти; чүнки Пәрвәрдигар униң билән биллә болуп, у һәр немә қилса Пәрвәрдигар уни оңушлуқ қилатти. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Бу ишлардин кейин Мисир падишасиниң сақийси вә баш навийи Мисир падишасиниң зитиға тегип гунакар болуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Шуниң билән Пирәвн униң бу икки мәнсәпдариға, йәни баш сақий вә баш навайға ғәзәплинип, ");
INSERT INTO uigcyr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","уларни пасибан бешиниң сарийиға, Йүсүп солақлиқ мунарлиқ зинданға солап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Пасибан беши Йүсүпни уларниң хизмитидә болуп уларни күтүшкә тайинлиди. Улар солақта бир нәччә күн йетип қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Улар иккиси — Мисир падишасиниң сақийси вә навийи гундиханида солақлиқ турған бир кечидә чүш көрди. Һәр бириниң чүшиниң өзигә хас тәбири бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Әтиси әтигәндә, Йүсүп уларниң қешиға киривиди, уларниң ғәмкин олтарғинини көрди; ");
INSERT INTO uigcyr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","шуңа у өзи билән биллә ғоҗисиниң сарийида солақлиқ ятқан Пирәвнниң бу икки мәнсәпдаридин: — Немишкә чирайиңлар бүгүн шунчә солғун? — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Улар униңға җавап берип: — Иккимиз бир чүш көрдуқ; амма чүшимизниң тәбирини йешип беридиған киши йоқ, деди. Йүсүп уларға: — Чүшкә тәбир бериш Худадин болиду әмәсму? Чүшүңларни маңа ейтип бериңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Буниң билән баш сақий Йүсүпкә чүшини ейтип: — Чүшүмдә алдимда бир үзүм тели турғидәк; ");
INSERT INTO uigcyr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","бу үзүм телиниң үч шехи бар екән. У бих уруп чечәкләп, саплирида узум пишип кетиптудәк; ");
INSERT INTO uigcyr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Пирәвнниң қәдәһи қолумда екән; мән үзүмләрни елип Пирәвнниң қәдәһигә сиқип, қәдәһни униң қолиға сунуптимән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Йүсүп униңға җававән: Чүшниң тәбири шудурки, бу үч шах үч күнни көрситиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Үч күн ичидә Пирәвн қәддиңни руслитип, сени мәнсивиңгә қайтидин тайинлайду. Буниң билән сән бурун униңға сақий болғандәк Пирәвнниң қәдәһини униң қолиға сунидиған болисән. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Лекин ишлириң оңушлуқ болғанда мени ядиңға йәткүзүп, маңа шапаәт көрситип Пирәвнниң алдида мениң тоғрамда гәп қилип, мени бу өйдин чиқартқайсән. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Чүнки мән һәқиқәтән ибранийларниң зиминидин наһәқ тутуп елип келиндим; бу йәрдиму мени зинданға салғидәк бир иш қилмидим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Баш навай Йүсүпниң шундақ яхши тәбир бәргинини көрүп униңға мундақ деди: — Мәнму өзүмни чүшүмдә көрдүм; мана, бешимда ақ нан бар үч севәт бар екән. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Әң үстүнки севәттә навайлар Пирәвнгә пишарған һәр хил назу-немәтләр бар екән; лекин қушлар бешимдики у севәттики нәрсиләрни йәп кетиптудәк, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Йүсүп җававән: — Чүшниң тәбири шудурки: — Бу үч севәт үч күнни көрситиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Үч күн ичидә Пирәвн сениң бешиңни кесип, җәситиңни дәрәққә асидикән. Шуниң билән учарқанатлар келип гөшүңни йәйдикән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Үчинчи күни шундақ болдики, Пирәвнниң туғулған күни болғачқа, у һәммә хизмәткарлири үчүн бир зияпәт қилип бәрди, шундақла дәрвәқә хизмәткарлириниң арисида баш сақийниң бешини көтәрди вә баш навайниң бешини алди; ");
INSERT INTO uigcyr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","у баш сақийни қайтидин өз мәнсивигә тайинлиди; шуниң билән у Пирәвнниң қәдәһини униң қолиға қайтидин сунидиған болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Лекин баш навайни болса Йүсүп уларға тәбир бәргәндәк есивәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Амма баш сақий Йүсүпни һеч әслимәй, әксичә уни унтуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Топтоғра икки жил өтүп, Пирәвн бир чүш көрди. Чүшидә у Нил дәриясиниң бойида турғидәк. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Һәм чирайлиқ һәм семиз йәттә туяқ инәк дәриядин чиқип, қумушлуқта отлаптудәк. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Андин йәнә йәттә туяқ инәк дәриядин чиқипту; улар сәт һәм оруқ болуп, алдинқи инәкләрниң йенида, дәрияниң бойида турупту. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Бу сәт һәм оруқ инәкләр у йәттә чирайлиқ һәм семиз инәкләрни йәветипту. Шу вақитта Пирәвн ойғинип кетипту. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","У йәнә ухлап, иккинчи қетим чүш көрди: — Мана, бир түп буғдай шехидин тоқ вә чирайлиқ йәттә башақ чиқипту. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Улардин кейин йәнә йәттә башақ чиқипту; улар һәм оруқ вә пучәк болуп, шәриқ шамилида солишип қалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Бу оруқ башақлар у йәттә семиз, тоқ башақни жутуп кетипту. Андин Пирәвн ойғинип кетипту, бу униң чүши екән. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Әтиси униң көңли наһайити беарам болуп, Мисирдики һәммә палчи-җадугәрләр билән барлиқ данишмәнләрни чақиртип кәлди. Пирәвн өз чүшини уларға ейтип бәрди; лекин һеч ким Пирәвнгә чүшләрниң тәбирини дәп берәлмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","У чағда баш сақий Пирәвнгә: — Бүгүн мениң өткүзгән хаталиқлирим есимгә кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Бурун Пирәвн җанаблири қуллириға, йәни пеқир вә баш навайға аччиқлинип, бизни пасибан бешиниң сарийида солаққа ташлиған едила; ");
INSERT INTO uigcyr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Шу чағларда һәр биримиз бир кечидә бирдин чүш көрдуқ; һәр қайсимиз көргән чүшниң тәбири башқа-башқа еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Шу йәрдә биз билән биллә пасибан бешиниң қули болған бир ибраний жигит бар еди. Униңға чүшлиримизни ейтивидуқ, у бизгә чүшлиримизниң тәбирини баян қилди; у һәр биримизниң көргән чүшигә қарап тәбир бәргән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Шундақ болдики, ишлар дәл униң бәргән тәбиридә дейилгәндәк йүз бәрди; җанаблири пеқирни өз мәнсивимгә қайтидин тайинлидилә, баш навайни дарға астила, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Шуниң билән Пирәвн адәм әвәтип, Йүсүпни чақирди; улар дәрһал уни зиндандин чиқарди. Йүсүп бурут-сақилини чүшүрүп, кийимлирини йәңгүшләп, Пирәвнниң алдиға кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Пирәвн Йүсүпкә: — Мән бир чүш көрдүм, амма униң тәбирини ейтип берәләйдиған һеч ким чиқмиди. Аңлисам, сән чүшкә тәбир берәләйдикәнсән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Йүсүп Пирәвнгә җавап берип: — Тәбир бериш өзүмдин әмәс; лекин Худа Пирәвнгә хатирҗәмлик беридиған бир җавап бериду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Пирәвн Йүсүпкә: — Чүшүмдә мән дәрияниң қирғиқида туруптимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Қарисам, дәриядин һәм семиз һәм чирайлиқ йәттә туяқ инәк чиқип қумушлуқта отлапту. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Андин улардин кейин аҗиз, толиму сәт һәм оруқ йәттә туяқ инәк чиқипту. Мән Мисир зиминида шундақ сәт инәкләрни көргән әмәсмән. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Бу оруқ, әски инәкләр болса авалқи йәттә семиз инәкни йәветипту. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Уларни йәвәткән болсиму, қосиғиға бир неминиң киргәнлиги һеч аян болмапту, уларниң көрүнүши бәлки бурунқидәк сәт имиш. Андин мән ойғинип кәттим. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Андин йәнә бир чүш көрдум, мана бир шахтин йәттә һәм тоқ һәм чирайлиқ башақ чиқипту. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Андин йәнә йәттә пучәк, оруқ башақ чиқипту; улар шәриқ шамили билән солишип қуруп кетипту. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Бу оруқ башақлар йәттә чирайлиқ башақни йәп кетипту. Мән бу ишни палчи-җадугәрләргә дәп бәрсәм, маңа тәбирини ейтип беридиған һеч киши чиқмиди, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Йүсүп Пирәвнгә: — Җанаблири Пирәвнниң чүшлири бир мәнадидур. Худа Өзи қилмақчи болған ишлирини Пирәвнгә алдин билдүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Бу йәттә яхши инәк йәттә жилни көрситиду; йәттә яхши башақму йәттә жилни көрситиду. Бу чүшләр охшаш бир чүштур. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Улардин кейин чиққан йәттә оруқ, яман сәт инәк йәттә жилни көрситиду; шәриқ шамили билән солишип қалған йәттә қуруқ башақму шундақ болуп, ачарчилиқ болидиған йәттә жилдур. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Мән Пирәвнгә дәйдиған сөзүм шуки, Худа йеқинда қилмақчи болған ишни Пирәвнгә аян қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Мана, пүткүл Мисир зиминида йәттә жилғичә мәмурчилиқ болиду; ");
INSERT INTO uigcyr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","андин йәттә жилғичә ачарчилиқ болиду; шуниң билән Мисир зиминида пүткүл мәмурчилиқни унутқузидиған ачарчилиқ зиминни вәйран қилиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Келидиған ачарчилиқниң сәвәвидин зиминда болған мәмурчилиқ кишиләрниң есидин көтирилип кетиду; чүнки ачарчилиқ толиму еғир болиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Лекин чүшниң яндурулуп, Пирәвнгә икки қетим көрүнгининиң әһмийити шуки, бу иш Худа тәрипидин бекитилгән болуп, Худа уни пат арида әмәлгә ашуриду. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Әнди Пирәвн өзи үчүн пәм-парасәтлик һәм дана бир кишини тепип, Мисир зиминиға қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Пирәвн шундақ қилсунки, мәмурчилиқ болған йәттә жилда Мисир зиминидин чиққан ашлиқниң бәштин бирини топлаңлар дәп зиминға назарәтчиләрни тайинлисун. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Булар шу келидиған тоқчилиқ жиллирида барлиқ ашлиқни топлап, шәһәр-шәһәрләрдә йемәклик болсун дәп буғдай-қонақларни Пирәвнниң қол астиға җәм қилип сақлитип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Жиғилған шу ашлиқлар Мисир зиминида болидиған йәттә жиллиқ ачарчилиққа тақабил туруш үчүн сақлансун; шу тәриқидә зимин ачарчилиқтин һалак болмайду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Бу сөз Пирәвн вә униң хизмәткарлириниң нәзиригә таза яқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Шуниң билән Пирәвн хизмәткарлириға: — Бу кишидәк, ичидә Худаниң роһи бар йәнә бирисини тапаламдуқ?! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Пирәвн Йүсүпкә: — Худа саңа буниң һәммисини аян қилған екән, сәндәк пәмлик һәм дана һеч ким чиқмайду. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Сән әнди мениң өйүмни башқурушқа бекитилдиң, барлиқ хәлқим сениң ағзиңға қарап өзлирини тәртипкә тизсун. Пәқәт тәхттила мән сәндин үстүн туримән, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ахирида Пирәвн Йүсүпкә: — Мана, мән сени пүткүл Мисир зимининиң үстигә тайинлидим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Буниң билән, Пирәвн өз қолидин мөһүр үзүгини чиқирип, Йүсүпниң қолиға салди; униңға нәпис канап рәхттин тикилгән либасни кийгүзүп, бойниға бир алтун зәнҗир есип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Уни өзиниң иккинчи шаһанә һарвусиға олтарғузуп, униң алдида: «Тиз пүкүңлар!» — дәп җар салдурди. Шундақ қилип, Пирәвн уни пүткүл Мисир зиминиға тикләп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Андин Пирәвн Йүсүпкә йәнә: — Мән дегән Пирәвндурмән; пүткүл Мисир зиминида сәнсиз һеч ким қол-путини мидирлатмисун! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Пирәвн Йүсүпкә Зафинат-Паанияһ дегән намни бәрди вә он шәһиридики каһин Потифираһниң қизи Асинатни униңға хотунлуққа елип бәрди. Шундақ қилип Йүсүп пүткүл Мисир зиминини башқуруш үчүн чөргиләшкә чиқти. Йүсүп Мисир падишаси Пирәвнниң хизмитидә болушқа бекитилгәндә оттуз яшта еди; у Пирәвнниң алдидин чиқип, Мисир зимининиң һәр қайси җайлирини көздин кәчүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Мәмурчилиқ болған йәттә жил ичидә зиминниң һосули дога-дога болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Йәттә жилда у Мисир зиминидин чиққан ашлиқни жиғип, шәһәр-шәһәргә топлиди; һәр қайси шәһәрниң әтрапидики етизлиқниң ашлиғини у шу шәһәрниң өзигә җуғлап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Шу тәриқидә Йүсүп деңиздики қумдәк наһайити көп ашлиқ топлиди; ашлиқ һәдди-һесапсиз болғачқа, улар һесаплашни тохтатти. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ачарчилиқ жиллири йетип келиштин бурун Йүсүпкә икки оғул төрәлди. Буларни Ондики каһин Потифәраһниң қизи Асинат униңға туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Йүсүп: «Худа пүтүн җапа-мушәққитим вә атамниң пүтүн аилисини көңлүмдин көтиривәтти» дәп тунҗа оғлиға Манассәһ дәп ат қойди; ");
INSERT INTO uigcyr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","андин: «Мән азап-оқубәт чәккән жутта Худа мени мевилик қилди» дәп иккинчисигә Әфраим дәп ат қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Мисир зиминида мәмурчилиқ болған йәттә жил аяқлашти. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Андин Йүсүпниң ейтқинидәк ачарчилиқниң йәттә жили башланди. У чағларда башқа барлиқ жутлардиму ачарчилиқ болди; лекин Мисир зиминидики һәр йәрләрдә нан бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ачарчилиқ пүткүл Мисир зиминни басқанда, хәлиқ ашлиқ сорап Пирәвнгә пәряд қилди. Пирәвн мисирлиқларниң һәммисигә: — Йүсүпниң қешиға берип, у силәргә немә десә, шуни қилиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ачарчилиқ пүткүл йәр йүзини бесип кәтти. Йүсүп һәр йәрдики амбарларни ечип, мисирлиқларға ашлиқ сататти; ачарчилиқ Мисир зиминида интайин еғир болғили турди. ");
INSERT INTO uigcyr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ачарчилиқ пүткүл йәр йүзини басқан болғачқа, барлиқ жутлардики хәлиқму ашлиқ алғили Мисирға Йүсүпниң қешиға келәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Әнди Яқуп Мисирда ашлиқ барлиғини билгинидә оғуллириға: — Немишкә бир-бириңларға қаришип турисиләр? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Андин йәнә: — Маңа қараңлар, аңлишимчә Мисирда ашлиқ бар екән. У йәргә берип, андин шу йәрдин бизгә ашлиқ елип келиңлар; буниң билән өлүп кәтмәй, тирик қалимиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Буниң билән Йүсүпниң он акиси ашлиқ сетивалғили Мисирға йолға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Лекин Яқуп Йүсүпниң иниси Биняминниң бирәр яманлиққа учрап қелишидин қорқуп уни акилири билән биллә әвәтмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Шуниңдәк ачарчилиқ Қанаан зиминидиму йүз бәргәчкә, Исраилниң оғуллири ашлиқ алғили кәлгәнләр арисида бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Йүсүп зиминниң валийси болуп, жутниң барлиқ хәлқигә ашлиқ сетип бәргүчи шу еди. Йүсүпниң акилири келип униң алдида йүзлирини йәргә тәккүзүп тазим қилди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Йүсүп акилирини көрүпла уларни тонуди; лекин у тонушлуқ бәрмәй, уларға қопал тәләппузда гәп қилип: — Қәйәрдин кәлдиңлар, дәп сориди. Улар җававән: — Қанаан зиминидин ашлиқ алғили кәлдуқ, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Йүсүп акилирини тонуған болсиму, лекин улар уни тонумиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Йүсүп әнди улар тоғрисида көргән чүшлирини есигә елип, уларға: — Силәр җасус, бу әлниң мудапиәсиз җайлирини күзәткили кәлдиңлар, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Амма улар униңға җавап берип: — Әй ғоҗам, ундақ әмәс! Бәлки кәминилири ашлиқ сетивалғили кәлди! ");
INSERT INTO uigcyr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Биз һәммимиз бир адәмниң оғуллири, сәмимий адәмләрмиз. Кәминилири җасус әмәс! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","У уларға йәнә: — Ундақ әмәс! Бәлки зиминниң мудапиәсиз җайлирини көргили кәлдиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Улар җавап берип: — Кәминилири әслидә он икки қериндаш едуқ; биз һәммимиз Қанаан зиминидики бир адәмниң оғуллиридурмиз; лекин кәнҗи инимиз атимизниң қешида қелип қалди; йәнә бир инимиз йоқап кәтти, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Амма Йүсүп уларға йәнә: — Мана мән дәл силәргә ейтқинимдәк, җасус екәнсиләр! ");
INSERT INTO uigcyr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Пирәвнниң һаяти билән қәсәм қилимәнки, кичик иниңлар бу йәргә кәлмигичә силәр бу йәрдин чиқип кетәлмәйсиләр; силәр шуниң билән синилисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Иниңларни елип кәлгили бириңларни әвәтиңлар, қалғанлириңлар болса солап қоюлисиләр. Буниң билән ейтқиниңларниң раст-ялғанлиғи испатлиниду; болмиса, Пирәвнниң һаяти билән қәсәм қилимәнки, силәр җәзмән җасус! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Шуниң билән у уларни үч күнгичә солап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Үчинчи күни Йүсүп уларға мундақ деди: — Мән Худадин қорқидиған адәммән; тирик қелишиңлар үчүн мошу ишни қилиңлар: — ");
INSERT INTO uigcyr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Әгәр сәмимий адәмләр болсаңлар, қериндашлириңлардин бири силәр соланған гундиханида солақлиқ туривәрсун, қалғиниңлар ачарчилиқта қалған аиләңлар үчүн ашлиқ елип кетиңлар; ");
INSERT INTO uigcyr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Андин кичик иниңларни қешимға елип келиңлар. Шуниң билән сөзлириңлар испатланса, өлмәйсиләр!, — деди. Улар шундақ қилидиған болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Андин улар өз ара: — Бәрһәқ, биз инимизға қилған ишимиз билән гунакар болуп қалдуқ; у бизгә ялвурсиму униң азавини көрүп туруп униңға қулақ салмидуқ. Шуниң үчүн бу азап-оқубәт бешимизға чүшти, — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Рубән уларға җававән: — Мән силәргә: балиға зулум қилмаңлар, дегән әмәсмидим? Лекин унимидиңлар. Мана әнди униң қан қәрзи биздин сориливатиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Амма Йүсүп улар билән тәрҗиман арқилиқ сөзләшкәчкә, улар Йүсүпниң өз гәплирини уқуп туруватқинини билмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","У улардин өзини чәткә елип, жиғлап кәтти. Андин уларниң қешиға йенип келип, уларға йәнә сөз қилип, уларниң арисидин Шимеонни тутуп, уларниң көз алдида бағлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Андин Йүсүп әмир чүшүрүп, уларниң тағарлириға ашлиқ толдуруп, һәр бирисиниң пулини қайтуруп тағириға селип қоюп, сәпәр һазирлиқлириму берилсун дәп буйрувиди, уларға шундақ қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Шуниң билән акилири ешәклиригә ашлиқлирини артип, шу йәрдин кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Амма өтәңгә кәлгәндә улардин бири ешигигә йәм бәргили тағирини ечивиди, мана, өз пули тағарниң ағзида туратти. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","У қериндашлириға: — Мениң пулумни қайтуруветипту. Мана у тағиримда туриду, деди. Буни аңлап уларниң жүриги су болуп, титришип бир-биригә: — Бу Худаниң бизгә зади немә қилғиниду? — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Улар Қанаан зиминиға, атиси Яқупниң қешиға келип, бешидин өткән һәммә вақиәләрни униңға сөзләп берип: ");
INSERT INTO uigcyr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— һелиқи киши, йәни шу зиминниң ғоҗиси бизгә қопал гәп қилди, бизгә зиминни пайлиғучи җасустәк муамилә қилди; ");
INSERT INTO uigcyr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","әнди биз униңға: «Биз болсақ сәмимий адәмләрмиз, җасус әмәсмиз. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Биз бир атидин болған оғуллар болуп, он икки ака-ука едуқ; бири йоқап кәтти, кичик инимиз һазир Қанаан зиминида атимизниң йенида қалди» десәк, ");
INSERT INTO uigcyr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Һелиқи киши, йәни шу зиминниң ғоҗиси бизгә мундақ деди: «Мениң силәрниң сәмимий екәнлигиңларни билишим үчүн, қериндашлириңларниң бирини мениң йенимда қалдуруп қоюп, ач қалған аиләңлар үчүн ашлиқ елип кетиңлар; ");
INSERT INTO uigcyr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","андин кичик иниңларни қешимға елип келиңлар; шундақ қилсаңлар, силәрниң җасус әмәс, бәлки сәмимий адәмләр екәнлигиңларни биләләймән. Андин қериндишиңларни силәргә қайтуруп беримән вә силәр зиминда сода-сетиқ қилсаңлар болиду» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Амма шундақ болдики, улар тағарлирини төккәндә, мана һәр бириниң пулдини өз тағарлирида туратти! Улар вә атиси өзлириниң чигиклик пуллирини көргәндә, қорқуп қелишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Атиси Яқуп уларға: — Мени оғлумдин җуда қилдиңлар! Йүсүп йоқ болди, Шимеонму йоқ, әнди Биняминниму елип кәтмәкчи болуватисиләр! Мана бу ишларниң һәммиси мениң бешимғила кәлди! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Рубән атисиға: — Әгәр мән Биняминни қешиңға қайтуруп елип кәлмисәм, мениң икки оғлумни өлтүрүвәткин; уни мениң қолумға тапшурғин; мән уни қешиңға яндуруп елип келимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Лекин Яқуп җавап берип: — Оғлум силәр билән биллә у йәргә чүшмәйду; чүнки униң акиси өлүп кетип, у өзи ялғуз қалди. Мабада йолда кетиватқанда униңға бирәр келишмәслик кәлсә, силәр мәндәк бир ақ чачлиқ адәмни дәрд-әләм билән тәһтисараға чүшүрүветисиләр, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ачарчилиқ зиминни интайин еғир басқан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Бу сәвәптин улар Мисирдин елип кәлгән ашлиқни йәп түгәткәндә, атиси уларға: — Йәнә берип бизгә азғина ашлиқ елип келиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Лекин Йәһуда униңға җававән: — Һелиқи киши бизни қаттиқ агаһландуруп: «Иниңлар силәр билән биллә кәлмисә, йүзүмни көримән дәп хиял қилмаңлар» дегән. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Әгәр инимизни биз билән биллә әвәтсәң, биз берип саңа ашлиқ елип келимиз. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Амма әвәтишкә унимисаң, биз бармаймиз; чүнки һелиқи киши бизгә: «Иниңлар силәр билән биллә кәлмисә, йүзүмни көримән дәп хиял қилмаңлар» дегән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Исраил уларға: — Силәр немишкә маңа шунчә яманлиқ қилип у кишигә: «Йәнә бир инимизму бар» дедиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Улар җававән: — У киши бизниң вә аилимизниң әһвалини сүрүштүрүп кочилап: «Атаңлар техи Һаятму? Йәнә бир иниңлар барму?» — дәп сориди. Биз униң шу соалиға яриша җавап бәрдуқ. Униң бизгә: «Иниңларни елип келиңлар» дәйдиғинини нәдин биләйли? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Йәһуда атиси Исраилға: — Балини мән билән әвәткин; биз дәрһал қозғилип йолға чиқайли; шундақта биз вә сән, бизләр һәм балилиримиз өлмәй, тирик қалимиз. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Мән униңға кепил болимән; сән униң үчүн мениң мениңдин һесап алисән; әгәр мән уни сениң қешиңға аман-есән яндуруп келип, йүзүңниң алдида турғузмисам, пүткүл өмрүмдә алдиңда гунакар болай.    ");
INSERT INTO uigcyr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Чүнки кечикмигән болсақ, бу чаққичә икки қетим берип келәттуқ, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Уларниң атиси Исраил уларға: — Ундақ болса, мундақ қилиңлар: — У кишигә қача-қучаңларға зиминдики әң есил мевиләрдин соғат алғач бериңлар: йәнә азғина тутия, азрақ һәсәл, дора-дәрманлар, мурмәкки, пистә вә бадамларни алғач бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Қолуңларда икки һәссә пул елип, тағарлириңларниң ағзидики өзүңларға яндурулған пулниму алғач бериңлар. Еһтимал, бу ишта сәһвәнлик көрүлгән болуши мүмкин. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Иниңларниму биллә елип, қозғилип у кишиниң йениға йәнә бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Һәммигә Қадир Тәңри Өзи силәрни у кишиниң алдида рәһимгә ериштүргәй. Буниң билән у силәрниң шу йәрдики қериндишиңларни вә Биняминни қоюп берип, силәргә қошуп қоярмекин; өзүм навада балилиримдин җуда болсам болай! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Шуниң билән бу адәмләр шу соғатни елип, қоллириға икки һәссә пулни тутуп, Биняминни елип қозғилип, Мисирға берип Йүсүпниң алдида һазир болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Йүсүп Биняминни улар билән биллә көргинидә, өз өйини башқуридиған ғоҗидариға буйруп: — Бу адәмләрни өйүмгә башлап кирип, мал союп таам тәйяр қилғин; чүнки бу кишиләр чүшлүк ғизани мән билән йәйду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","У киши Йүсүпниң буйруғинидәк қилип, адәмләрни Йүсүпниң өйигә башлап кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Улар болса Йүсүпниң өйигә башлап келингинидин қорқушуп: — Алдинқи қетим тағарлиримизға яндурулған пулниң сәвәвидин биз униң өйигә елип келиндуқ; униң мәхсити бизгә һуҗум қилип, үстимиздин бесип қул қилип, ешәклиримизни тартивелиш охшайду, — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Улар Йүсүпниң өйини башқуридиған ғоҗидарниң йениға келип, өйниң ишигиниң түвидә униңға: — ");
INSERT INTO uigcyr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Әй ғоҗам, биз һәқиқәтән әслидә мошу йәргә ашлиқ алғили кәлгән едуқ; ");
INSERT INTO uigcyr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Шундақ болдики, биз өтәңгә келип өз тағарлиримизни ачсақ, мана һәр биримизниң пули, әйни еғирлиғи бойичә тағарлиримизниң ағзида турупту; шуңа биз буни яндуруп қолимизда алғач кәлдуқ. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ашлиқ алғили қолимизда башқа пулму елип кәлдуқ; амма тағарлиримизға пулни кимниң селип қойғанлиғини билмидуқ, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","У уларға: — Хатирҗәм болуңлар, қорқмаңлар. Силәрниң Худайиңлар, атаңларниң Худаси тағарлириңларда силәргә байлиқ ата қилған охшайду; силәрниң пулуңларни аллиқачан тапшуруп алдим, — деди. Андин у Шимеонни уларниң қешиға елип чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","У киши уларни Йүсүпниң өйигә башлап кирип, уларниң путлирини жуюшиға су әкирип берип, андин ешәклиригә йәм бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Улар Йүсүпниң чүштә келишигә үлгүртүп соғатни тәйярлап қойди; чүнки улар өзлириниң шу йәрдә ғиза йәйдиғинини аңлиған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Йүсүп өйгә кәлгәндә улар қоллиридики соғатни өйгә униң алдиға елип кирип, бешини йәргә тәккүзүп униңға тазим қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","У улардин һал сорап, андин: — Силәр гепини қилған қери атаңлар саламәтму? У һаятму? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Улар җавап берип: — Силиниң қуллири бизниң атимиз саламәт туруватиду, у техи һаяттур, — дәп униң алдида егилип тазим қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Йүсүп бешини көтирип, өз иниси Биняминни көрүп: — Силәр маңа гепини қилған кичик иниңлар шуму? — дәп сорап: — Әй оғлум, Худа саңа шапаәт көрсәткәй! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Йүсүпниң өз инисиға болған сеғиниш оти қаттиқ күчийип, жиғливалғидәк халий җай издәп, алдирап ичкирики өйгә кирип таза бир жиғливалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Андин йүзини жуюп чиқип, өзини бесивелип: — Таамларни қоюңлар, — дәп буйруди. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Хизмәткарлар Йүсүпкә айрим, уларға айрим вә Йүсүп билән биллә тамаққа кәлгән мисирлиқларғиму айрим тамақ қойди; чүнки мисирлиқлар ибранийлар билән бир дәстиханда тамақ йейишни жиркиничлик дәп қарап, улар билән биллә тамақ йемәйтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Йүсүпниң қериндашлири униң удулида, һәр бири чоң-кичик тәртиви бойичә олтарғузулди; чоңи чоңлуғиға яриша, кичиги кичиклигигә яриша олтарғузулди; улар бир-биригә қарап һәйран қелишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Йүсүп алдидики дәстихандики тамақлардин уларға бөлүп бәрди. Амма Биняминға бәргини башқиларниңкигә қариғанда бәш һәссә көп еди. Улар шарап ичип, униң билән хуш кәйп қилишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Андин у өз өйини башқуридиған ғоҗидариға буйруп: — Бу кишиләрниң тағарлирини елип көтирәлигидәк ашлиқ қачилап, һәр бириниң пулини тағириниң ағзиға селип қойғин; ");
INSERT INTO uigcyr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","андин мениң җамимни, йәни күмүч җамни ашлиқниң пули билән биллә әң кичигиниң тағириниң ағзиға селип қойғин, — деди. У адәм Йүсүпниң дегинидәк қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Әтиси таң йориғанда, улар ешәклири билән биллә йолға селип қоюлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Лекин улар шәһәрдин чиқип анчә узун маңмайла, Йүсүп ғоҗидариға: — Орнуңдин тур, бу адәмләрниң кәйнидин қоғлиғин; уларға йетишкиниңдә уларға: «Немишкә яхшилиққа яманлиқ қайтурдуңлар? ");
INSERT INTO uigcyr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ғоҗам шу җамда шарап ичиду һәмдә униңда пал ачиду әмәсму?! Мундақ қилғиниңлар рәзиллик қилғиниңлар болмамду!» дегин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Бу адәм уларниң кәйнидин йетишип берип, уларға бу сөзләрни қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Улар униңға җававән: — Ғоҗимиз немишкә мундақ гәп қилиду? Мундақ ишни қилиш кәминилиридин нери болсун! ");
INSERT INTO uigcyr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Биз әслидә тағарлиримизниң ағзидин тапқан пулниму Қанаан зиминидин силиниң қашлириға қайтуруп беришкә әкәлгән едуқ. Шундақ туруқлуқ қандақму ғоҗилириниң өйидин алтун-күмүчни оғрилайли? ");
INSERT INTO uigcyr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Кәминилириңниң арисида кимдин бу җам тепилса, шу өлүмгә мәһкүм болсун, бизму ғоҗимизниң қуллири болайли, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ғоҗидар җававән: — Ейтқан сөзлириңлардәк болсун; җам кимниң йенидин тепилса, шу киши қулум болуп қелип қалсун, қалғанлириңлар бегуна болисиләр, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Шуниң билән улар алдирап-тенәп, тағарлирини йәргә чүшүрүп, һәр бири өз тағирини ечип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ғоҗидар чоңиниңкидин башлап кичигиниңкигичә ахтурди, җам Биняминниң тағиридин тепилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Буни көрүп улар кийимлирини житишип, һәр бири ешигигә қайтидин жүкни артип, шәһәргә қайтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Шундақ қилип Йәһуда вә қериндашлири Йүсүпниң өйигә кәлди; у техи шу йәрдә еди. Улар униң алдиға келип өзлирини йәргә етишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Йүсүп уларға: — Бу силәрниң зади немә қилғиниңлар? Мениңдәк адәмниң чоқум пал ачалайдиғанлиғини билмәмтиңлар? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Йәһуда җававән: — Биз ғоҗимизға немиму дейәләймиз? Немә гәп қилалаймиз, қандақ қилип өзимизни ақлалаймиз? Худа кәминлириниң қәбиһлигини ашкарә қилди. Мана, биз вә қолидин җамлири тепилған киши һәммимиз ғоҗимизға қул болидиған болдуқ, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Лекин Йүсүп: — Мундақ қилиш мәндин нери болсун! Бәлки җам кимниң қолидин тепилған болса пәқәт шу киши мениң қулум болиду. Лекин қалғанлириңлар аман-есән атаңларниң қешиға кетиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Андин Йәһуда униңға йеқин берип мундақ деди: — Әй ғоҗам, кәминилиригә қулақ селип ғоҗамниң қулиқиға бир еғиз гәп қилишқа иҗазәт бәргәйла. Ғәзәплири кәминилиригә туташмиғай; чүнки өзлири Пирәвнгә охшаш екәнла. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Әслидә ғоҗам кәминилиридин: «Атаңлар я иниңлар барму?» дәп соривидила, ");
INSERT INTO uigcyr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","биз ғоҗимизға җававән: «Бизниң бир қери атимиз бар вә у қериғанда тапқан, яш бир балисиму бар. Бу балиниң бир анисидин болған акиси өлүп кетип, у өзи ялғуз қалди; униң атиси уни интайин сөйиду» десәк, ");
INSERT INTO uigcyr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Сили кәминилиригә: «Униң өзини қешимға елип келиңлар, мән уни өз көзүм билән көрәй» дедилә. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Биз ғоҗимизға җавап берип: «Жигит атисидин айрилалмайду; әгәр атисидин айрилса, атиси өлүп кетиду» десәк, ");
INSERT INTO uigcyr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Сили йәнила кәминилиригә: «Әгәр кичик иниңлар силәр билән биллә кәлмисә, йүзүмни йәнә көримиз дәп хиял қилмаңлар» дегән едила. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Шуниң билән биз кәминилири атимизниң қешиға барғанда ғоҗамниң сөзлирини униңға ейттуқ; ");
INSERT INTO uigcyr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","андин атимиз йәнә: «Йәнә берип, бизгә азрақ ашлиқ елип келиңлар» девиди, ");
INSERT INTO uigcyr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Биз җававән: «Биз шу йәргә қайтидин чүшәлмәймиз; әгәр кичик инимиз биз билән биллә болса, ундақта баримиз; чүнки кичик инимиз биз билән биллә болмиса, у затниң йүзи алдида туралмаймиз», дедуқ. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Силиниң қуллири бизниң атимиз бизгә йәнә: «Силәргә мәлумки, аялим маңа икки оғул туғуп бәргән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Бири мениң йенимдин чиқип, йоқ болуп кәтти; мән: у җәзмән титма-титма қиливетилипту, дәп ойлидим, шундақла уни бүгүнгичә көрмидим. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Әнди силәр буниму мениң қешимдин елип кетип, униңға бир келишмәслик келип қалса, силәр мәндәк бир ақ чачлиқ адәмни дәрд-әләм билән тәһтисараға чүшүрүветисиләр», дегән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Әнди мән силиниң қуллири мениң атамниң қешиға барғанда, шу бала биз билән болмиса униң җени балиниң җениға бағланған болғачқа, ");
INSERT INTO uigcyr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","шундақ болидуки, у балиниң йоқлуғини көрсә, җәзмән өлүп кетиду; шуниң билән силиниң қуллири бизниң атимиз болған бу ақ чачни дәрд-әләм ичидә тәһтисараға чүшүрүвәткән болимиз. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Чүнки мәнки кәминилири атамға бу жигит үчүн кепил болуп: «Әгәр мән уни қешиңға қайтуруп кәлмисәм пүткүл өмрүмдә атамниң алдида гунакар болай» дегән едим. ");
INSERT INTO uigcyr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Шуңа һазир өтүнүп қалай, мәнки кәминилири у жигитниң орнида ғоҗамниң қешида қул болуп турсам, у жигит қериндашлири билән биллә қайтип кәтсә! ");
INSERT INTO uigcyr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Чүнки жигит мән билән болмиса, мән қандақму атамниң қешиға баралаймән? Атамға шундақ азап-оқубәтниң чүшүшини көзүм көргүчи болмисун! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","2","Йүсүп өз йенида турғанларниң алдида өзини туталмай: — Һәммә адәм алдимдин чиқириветилсун! дәп вақириди. Шуниң билән Йүсүп өзини қериндашлириға ашкарә қилғанда униң қешида һеч ким болмиди. У қаттиқ жиғлап кәтти; мисирлиқлар уни аңлиди, Пирәвнниң ордисикиләрму буниңдин тезла хәвәр тапти. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Йүсүп қериндашлириға: — Мән Йүсүп болимән! Атам һазир һаятму?! — дәп сориди. Амма қериндашлири униңға қарап һодуқуп кетип, һеч җавап берәлмәй қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Лекин Йүсүп уларни: — Қени, маңа йеқин келиңлар, дәп чақириди. Улар йеқин кәлди, у йәнә: — Мән силәрниң иниңлар, йәни силәр Мисирға сетивәткән Йүсүп болимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Әнди мени мошу йәргә сетивәткиниңлар үчүн азапланмаңлар, өзүңларни әйипкә буйрумаңлар; чүнки Худа адәмләрниң һаятини сақлап қелиш үчүн мени силәрдин бурун бу йәргә әвәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Чүнки һазир зиминдики ачарчилиққа икки жил болди; лекин техи йәнә бәш жилғичә һеч терилғуму болмайду, ормиму болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Шуниң үчүн силәргә дунияда бир қалдини сақлап қелиш үчүн, улуқ бир ниҗатлиқ көрситип, силәрниң тирик қутулушуңлар үчүн Худа мени силәрдин бурун бу йәргә әвәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Шундақ болған екән, мени мошу йәргә әвәткүчи силәр әмәс, бәлки Худадур. У мени Пирәвнгә атиниң орнида қилип, униң пүткүл өйигә ғоҗа қилип тикләп, пүткүл зиминға баш вәзир қилип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Әнди тездин атамниң қешиға берип, униңға: — Сениң оғлуң Йүсүп: «Худа мени пүткүл Мисирға ғоҗа қилип қойди. Сән кечиктүрмәй, мениң қешимға кәлгин; ");
INSERT INTO uigcyr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","сән Гошән жутида турисән; шуниң билән сән өзүң, оғуллириң, нәврилириң, қойлириң, калилириң вә һәммә тәәллуқатлириң билән маңа йеқин турисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Өзүң, аиләң вә һәммә тәәллуқатиңни намратлиқ бесивалмисун дәп мән сени шу йәрдә бақимән; чүнки йәнә бәш жил ачарчилиқ бардур», деди, — дәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","— Мана силәрниң көзлириңлар вә иним Биняминниң көзлири силәргә гәп қиливатқан мениң өз ағзим екәнлигини көрүватиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Атамға мениң Мисирдики бу барлиқ шан-шәривим һәмдә силәрниң барлиқ көргиниңлар тоғрисида ейтип, атамни тездин бу йәргә елип келиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Шуниң билән у өзини Биняминға етип униң бойниға гирә селип жиғлап кәтти; Биняминму униң бойниға йөлинип жиғлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Андин Йүсүп барлиқ қериндшалирини сөйүп, уларни бир-бирләп қучағлап жиғлиди. Андин қериндшалири униң билән параңлашти. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Йүсүпниң қериндшалири кәлди, дегән хәвәр Пирәвнниң ордисиға йәткүзүлди; бу Пирәвн вә хизмәткарлириниң нәзиридә қутлуқ иш болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Пирәвн Йүсүпкә: — Қериндашлириңға: — «Силәр әнди мундақ қилиңлар; улақлириңларға жүк артип, Қанаан зиминиға берип, ");
INSERT INTO uigcyr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","атаңлар вә җәмәтиңларни елип мениң қешимға келиңлар; мән Мисир зиминидин әң есил йәрләрни силәргә берәй; силәр бу зиминдин чиққан назу-немәтләрдин йәйсиләр» — дегин. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Саңа болған әмрим шуки, сән уларға: «Балилириңлар вә аяллириңларни елиш үчүн Мисир зиминидин һарвуларни елип бериңлар. Шуниңдәк атаңларниму бу йәргә йәткүзүп келиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Пүткүл Мисир зиминидин әң есил җайлар силәрниңки болғачқа, өз сәрәмҗанлириңларға кариңлар болмисун» дәп буйруғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Шуниң билән Исраилниң оғуллири шундақ қилди; Йүсүп Пирәвнниң буйруғи бойичә уларға һарвуларни берип, йоли үчүнму озуқ бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Уларниң һәр биригә бир қур кийим бәрди; лекин Биняминға болса у үч йүз күмүч тәңгә, бәш қур кийим бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","У атисиғиму шу һәдийәләрни, йәни Мисирниң есил мәһсулатлири артилған он һаңга ешәк һәмдә ашлиқ, нан вә атисиға йол тәйярлиғи артилған он мада ешәкни әвәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Андин у қериндашлирини йолға селип, уларға: — Йолда җедәлләшмәңлар, дәп җекилиди. Улар йолға раван болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Улар Мисирдин чиқип, Қанаан зиминиға атиси Яқупниң қешиға берип, ");
INSERT INTO uigcyr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","униңға Йүсүп өзлиригә ейтқан гәпләрни йәткүзүп: «Йүсүп техи һаят екән! У пүткүл Мисир зиминиға баш вәзир екән!» деди. Амма у уларға ишәнмәй, жүриги қетип һошидин кетәй дәп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Лекин улар Йүсүпниң өзлиригә ейтқан барлиқ сөзлирини униңға дегәндә, шундақла Йүсүпниң өзини елип келишкә әвәткән һарвуларниму көргәндә, уларниң атиси Яқупниң роһиға җан кирди. ");
INSERT INTO uigcyr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Исраил шуниң билән: — Әнди арминим йоқ! Оғлум Йүсүп техи һаяттур! Мән өлмәстә берип уни көрүвалай, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Шуниң билән Исраил барлиқ тәәллуқатини елип йолға чиқип, Бәәр-Шебаға кәлди. У шу йәрдә атиси Исһақниң Худасиға қурбанлиқларни сунди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Кечиси Худа аламәт көрүнүшләрдә Исраилға: — Яқуп, Яқуп! девиди, у җавап берип: — Мана мән! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","У: — Атаңниң Тәңриси болған Худа Мәндурмән. Сән Мисирға бериштин қорқмиғин, чүнки Мән сени шу йәрдә улуқ бир қовм қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Мән сениң билән Мисирға биллә баримән вә Мән Өзүм җәзмән йәнә сени шу йәрдин яндуруп келимән. Йүсүп өз қоли билән сениң көзүңни жумдуриду, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Андин Яқуп Бәәр-Шебадин йолға чиқти; Исраилниң оғуллири атиси Яқуп вә уларниң бала-җақилирини Пирәвн уни епкелиш үчүн әвәткән һарвуларға олтарғузуп, ");
INSERT INTO uigcyr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","чарпайлири билән Қанаан зиминида тапқан тәәллуқатлирини елип маңди. Бу тәриқидә Яқуп билән барлиқ әвлатлири Мисирға кәлди; оғуллирини, оғул нәврилирини, қизлирини, қиз нәврилирини жиғип, нәсиллириниң һәммисини өзи билән биллә елип Мисирға кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Исраилниң оғуллири, йәни Яқупниң Мисирға кәлгән әвлатлири төвәндикичә: — Яқупниң тунҗа оғли Рубән; ");
INSERT INTO uigcyr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Рубәнниң оғуллири Һанох, Паллу, Һәзрон билән Карми. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Шимеонниң оғуллири: — Йәмуәл, Ямин, Оһад, Яқин, Зоһар вә Ⱪананий аялдин болған Саул.    ");
INSERT INTO uigcyr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Лавийниң оғуллири: — Гәршон, Коһат вә Мәрари. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Йәһуданиң оғуллири: — Әр, Онан, Шәлаһ, Пәрәз вә Зәраһ. Амма Әр вә Онан Қанаанниң зиминида өлүп кәткән еди. Пәрәзниң оғуллири Һәзрон билән Һамуллар еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Иссакарниң оғуллири: — Тола, Пуаһ, Йоб вә Шимрон. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Зәбулунниң оғуллири: — Сәрәд, Елон вә Җаһлийәл. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Булар Леяһниң Яқупқа Падан-Арамда туғуп бәргән оғул-әвлатлири еди; у йәнә қизи Динаһни туғуп бәрди. Буниң бу оғул-қиз пәрзәнтлири җәмий болуп оттуз үч җан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Гадниң оғуллири: — Зифион, Һагги, Шуни, Әзбон, Ери, Ароди вә Арәли. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Аширниң оғуллири: — Йимнаһ, Йишваһ, Йишви вә Берияһ. Уларниң сиңлиси Сераһ еди; Берияһниң оғуллири Һәбәр вә Малкиәл еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Булар болса Лабан қизи Леяһқа дедәк болушқа бәргән Зилпаһниң Яқупқа туғуп бәргән оғуллири болуп, җәмий он алтә җан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Яқупниң аяли Раһиләниң оғуллири Йүсүп вә Бинямин. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Йүсүпкә Мисир зиминида төрәлгән оғуллири Манассәһ вә Әфраим; буларни Ондики каһин Потифираһниң қизи Асинат униңға туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Биняминниң оғуллири: — Белаһ, Бәкәр, Ашбәл, Гера, Нааман, Еһи, Рош, Муппим, Һуппим вә Ард.    ");
INSERT INTO uigcyr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Булар Раһиләниң Яқупқа туғуп бәргән оғул-әвлатлири болуп, җәмий он төрт җан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Данниң оғли: — Һушим. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Нафталиниң оғуллири: — Яһзиәл, Гуни, Йәзәр вә Шилләм. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Булар Лабан қизи Раһиләгә дедәк болушқа бәргән Билһаһниң Яқупқа туғуп бәргән оғул-әвлатлири болуп, җәмий йәттә җан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Яқупниң келинлиридин башқа, Яқупниң пуштидин болған, униң билән биргә Мисирға кәлгәнләр җәмий атмиш алтә җан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Йүсүпниң Мисирда туғулған оғуллири икки еди. Яқупниң җәмәтидин болуп, Мисирға кәлгәнләр җәмий йәтмиш җан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Яқуп Йүсүптин көрсәтмә елип, өзлирини Гошәнгә башлап беришқа Йәһудани Йүсүпниң қешиға әвәтти. Шундақ қилип улар Гошән жутиға келип чүшти. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Йүсүп өзиниң вәзирлик һарвусини қатқузуп, атиси Исраилниң алдиға Гошәнгә чиқти. У өзини униң алдиға һазир қилип атисиға өзини етип бойниға бешини қоюп қучағлап, узундин узун жиғлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Исраил Йүсүпкә: Мән сениң йүзүңни көрүп, тирик екәнлигиңни билдим; әнди өлсәмму арминим йоқ, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Андин Йүсүп қериндашлири вә атисиниң өйдикилиригә мундақ деди: — Мән һазир чиқип Пирәвнгә хәвәр берип: «Қанаан зиминида олтарған қериндашлирим, шундақла атамниң өйидикиләр қешимға кәлди; ");
INSERT INTO uigcyr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","бу адәмләр падичилар болуп, мал беқиш билән шуғуллинип кәлгән, қой-калилири, шундақла барлиқ мал-мүлүклирини елип кәлди» дәп ейтай. ");
INSERT INTO uigcyr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Шундақ болидуки, Пирәвн силәрни чақириду; шу чағда у силәрдин: «Немә оқитиңлар бар?» дәп сориса, ");
INSERT INTO uigcyr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","силәр җавап берип: — Кәминилири кичигимиздин тартип ата-бовилиримизға охшаш пада беқип кәлгәнмиз, — дәңлар. Шундақ десәңлар Гошән жутида олтирип қалисиләр; чүнки падичиларниң һәммиси мисирлиқлар арисида көзгә илинмайду.    ");
INSERT INTO uigcyr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Йүсүп Пирәвнниң қешиға келип: — Атам билән қериндашлирим қой-калилири, шундақла һәммә мал-мүлүклирини биллә елип Қанаан зиминидин кәлди. Мана, улар һазир Гошән жутиға чүшти, дәп хәвәр берип, ");
INSERT INTO uigcyr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","қериндашлириниң ичидин бәшәйләнни елип, Пирәвнниң алдиға һазир қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Пирәвн униң қериндашлиридин: — Немә оқитиңлар бар, дәп соривиди, улар Пирәвнгә җавап берип: — Кәминилири ата-бовилиримизға охшаш мал баққучилармиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Андин улар Пирәвнгә илтимас қилип: — Қанаан зиминида қаттиқ қәһәтчилик болғачқа, кәминилириниң қойлиримизни бақидиғанға яйлақму йоқ; шуңа бу зиминда мусапир болуп турушқа кәлдуқ; җанаблиридин тәләп қилимизки, кәминилириниң Гошән жутида турушиға иҗазәт бәргәйла, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Пирәвн Йүсүпкә: — Атаң вә қериндашлириң қешиңға кәлди; ");
INSERT INTO uigcyr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","мана Мисир зимини сениң алдиңда турупту; атаң вә қериндашлириңни зиминниң әң есил йеридә олтарғузғин; улар Гошән жутида макан қилсун. Шуниңдәк, әгәр сән уларниң ичидики қабил кишиләрни билсәң, буларни мениң чарпайлиримға назарәтчи қилғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Кейин, Йүсүп атиси Яқупни елип, Пирәвнниң алдиға һазир қилди; Яқуп Пирәвнгә бәхит-бәрикәт тилиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Андин Пирәвн Яқуптин: — Өмрүңниң жил-күнлири нәччигә йәтти? — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Яқуп Пирәвнгә җавап берип: — Мусапирлиқ сәпиримниң күнлири бир йүз оттуз жилға йәтти; өмрүмниң күнлири аз һәм җапа-мушәққәтлик болуп, ата-бовилиримниң мусапирлиқ өмүр сәпириниң күнлиригә техи йәтмиди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Шуниң билән Яқуп Пирәвнгә бәхит-бәрикәт тиләп, алдидин чиқип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Шуниң билән Йүсүп атиси билән қериндашлирини Мисир зиминида олтирақлаштуруп қойди; Пирәвнниң буйруғинидәк уларға зиминниң әң есил йеридин, йәни Рамсәс дегән жуттин тәвәлик бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Йүсүп атиси, қериндашлири, шундақла атисиниң һәммә өйдикилирини бала-җақилириниң санлириға қарап ашлиқ билән тәминләп бақти. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Амма ачарчилиқ қаттиқ еғир болғачқа, зиминниң һеч йеридә озуқ-түлүк тепилмиди; Мисир зимини билән Қанаан зимини ачарчилиқтин хараплишип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Йүсүп ашлиқ сетип Мисир зимини билән Қанаан зиминидики барлиқ пулни жиғивалди. Андин Йүсүп бу пулни Пирәвнниң ордисиға йәткүзүп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Амма Мисир зимини билән Қанаан зиминидики Пул түгәп кәткәндә мисирлиқларниң һәммиси Йүсүпниң алдиға келип: — Бизгә нан бәргәйла! Пул түгәп кәткини үчүн силиниң алдилирида өлимизму? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Йүсүп җававән: — Пулуңлар қалмиған болса, чарпайлириңларни елип келип бәрсәңлар, мән маллириңлариға озуқ-түлүк тегишип беримән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Буниң билән улар чарпайлирини Йүсүпниң қешиға елип кәлгили турди; Йүсүп уларниң атлири, қой падилири, кала падилири вә ешәклириниң орниға озуқ-түлүк бәрди; шу жили маллириниң орниға уларға озуқ-түлүк берип бақти. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","У жил аяқлишип, улар иккинчи жили униң қешиға келип униңға: — Биз ғоҗимиздин һеч немини йошурмаймиз; пулимиз түгиди, чарпай мал падилиримиз болса ғоҗимизниң илкидә, ғоҗимизниң алдида тәнлиримиз билән йеримиздин башқа һеч нәрсә қалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Немишкә көз алдилирида биз һәм йеримизму өлүп кәтсун? Әнди сили өзимиз вә йеримизни озуқ-түлүккә тегишип еливалғайла; өзимиз вә йеримиз Пирәвнниң болуп, униңға қул болайли. Биз өлүп кәтмәй, тирик турушимиз, йеримизму вәйран болмаслиғи үчүн бизгә уруқ-түлүк бәргәйла, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Бу тәриқидә Йүсүп Мисирниң пүткүл терилғу йерини Пирәвн үчүн сетивалди; чүнки ачарчилиқ қаттиқ болғачқа, мисирлиқларниң һәр бири өз етизини сетип бәрди. Шуниң билән йәр-зимин Пирәвнниң болуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Йүсүп хәлиқни Мисирниң бу четидин йәнә бир четигичә һәр қайси шәһәрләргә көчүрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Пәқәт каһинларниң йерини у алмиди; чүнки каһинларға Пирәвн тәрипидин алаһидә тәминат берилгәчкә, улар Пирәвн тәрипидин тәминләнгән үлүшини йәп, өз йәрлирини сатмиған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Йүсүп хәлиққә: — Мана, мән бүгүн өзүңлар билән йәрлириңларни Пирәвн үчүн сетивалдим. Мана силәргә уруқ! Әнди йәр териңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Әнди шундақ қилисиләрки, чиққан һосулдин бәштин бирини Пирәвнгә берип, қалған төрт қисмини өзүңларға елип қелиңлар; у уруқлуқ һәмдә өзүңларға, җүмлидин өйүңдикиләргә вә кичик балилириңларға озуқ болсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Улар җававән: — Сили җенимизни қутқуздила. Ғоҗимизниң нәзиридә илтипат тапқан болсақла, Пирәвнниң қуллири болуп турайли, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Шуниң билән Йүсүп: — «Һосулниң бәштин бири Пирәвнгә берилсун» дәп бу ишни бүгүнгә қәдәр Мисир зимини үчүн қанун-бәлгүлимә қилди. Пәқәт каһинларниң йерила буниң сиртида болуп, Пирәвнгә тәвә болмиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Исраиллар Мисир зиминида, Гошән өлкисидә олтирақлашти; улар шу җайда йәр-зиминлик болуп, көпийип, толиму көпәйди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Яқуп Мисир зиминида он йәттә жил өмүр көрди; буниң билән Яқупниң өмүр күнлири бир йүз қириқ йәттә жилға йәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Исраилниң күнлири сәкратқа йеқинлашқанда, оғли Йүсүпни чақиртип, униңға: — Әгәр нәзириңдә илтипат тапқан болсам, қолуңни янпашмниң астиға қоюп, маңа шапаәт вә садақәтликни көрситип, мени Мисирда дәпнә қилма; ");
INSERT INTO uigcyr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","бәлки мән ата-бовилирим билән ятидиған вақтимда мени Мисирдин елип кетип, уларниң гөристаниға дәпнә қилғин, деди. У җавап берип: — Мән ейтқиниңдәк қилай, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Яқуп униңға: — Маңа қәсәм қилип бәргин, — деди. У униңға қәсәм қилип бәрди; андин Исраил карватниң баш тәрипидә сәҗдә қилди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Бу ишлардин кейин бириси Йүсүпкә: — Мана атаң кесәл болуп қапту, дәп хәвәр бәрди. У икки оғли Манассәһ билән Әфраимни биллә елип барди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Бириси Яқупқа: — Мана оғлуң Йүсүп қешиңға келиватиду, дәп хәвәр беривиди, Исраил күчәп қопуп кариватта олтарди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Яқуп Йүсүпкә: — Һәммигә Қадир Тәңри маңа Қанаан зиминидики Луз дегән җайда аян болуп, мени бәрикәтләп ");
INSERT INTO uigcyr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","маңа: Мана, Мән сениң нәслиңни көпәйтип, сени интайин зор көпәйтимән, сәндин бир түркүм хәлиқ чиқиримән; бу зиминни сәндин кейинки нәслиңгә әбәдий мирас қилип беримән, дәп ейтқан еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Әнди мән Мисирға келиштин илгири саңа Мисир зиминида туғулған икки оғлуң мениң һесаплиниду; Әфраим билән Манассәһ болса, худди Рубән билән Шимеонға охшаш, һәр иккиси мениң оғуллирим болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Улардин кейин тапқан балилириң өзүңниң болиду; улар кәлгүсидә мирасқа еришкәндә акилириниң нами астида болиду. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Маңа кәлсәк, Падандин келиватқинимда Раһилә Қанаан зиминида йол үстидә Әфратқа аз қалғанда мени ташлап өлүп кәтти. Мән уни шу йәрдә, йәни Әфратқа (йәни Бәйт-Ләһәмгә) баридиған йолда дәпнә қилдим, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Андин Исраил Йүсүпниң оғуллириға қарап: — Булар кимдур, — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Йүсүп атисиға җававән: — Булар болса Худа маңа бу йәрдә бәргән оғуллиримдур, — деди. У: — Уларни алдимға йеқин кәлтүргин, мән уларға бәхит-бәрикәт тиләй, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Әнди Исраилниң көзлири қерилиғидин ғувалишип яхши көрәлмәйтти. Шуңа Йүсүп уларни униң алдиға йеқинрақ кәлтүрди; у уларни сөйүп қучағлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Андин Исраил Йүсүпкә: — Мән сениң йүзүңни көрәләймән дәп һеч ойлимиған едим; лекин Худа мени сениң балилириңниму көрүшкә несип қилди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Йүсүп балиларни Яқупниң тизлириниң арилиғидин елип, йүзини йәргә тәккүзүп тазим қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Андин Йүсүп бу иккиләнни Исраилниң алдиға йеқин елип келип, Әфраимни оң қоли билән тутуп Исраилниң сол қолиға удуллап турғузди; Манассәһни сол қоли билән тутуп Исраилниң оң қолиға удуллап турғузди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Лекин Исраил оң қолини узитип, кәнҗи балиси Әфраимниң бешиға қойди, сол қолини Манассәһниң бешиға қойди. Манассәһ тунҗиси болсиму, у икки қолини қайчилап тутуп шундақ қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","У Йүсүпкә бәхит-бәрикәт тиләп: — Атилирим Ибраһим билән Исһақ Худа дәп билип йүзи алдида маңған, мени пүткүл өмрүмдә бу күнгичә падичидәк йетәкләп беқип кәлгән Худа, ");
INSERT INTO uigcyr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Маңа һәмҗәмәт болуп мени һәммә бала-қазадин қутқузған Пәриштә бу икки оғулни бәрикәтлисун; улар мениң исмим вә атилирим болған Ибраһим вә Исһақниң исимлири билән атилип, йәр йүзидә көп авуғай! — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Йүсүп атисиниң оң қолини Әфраимниң бешиға қойғинини көрүп көңлидә хапа болди; шуңа у атисиниң қолини тутуп, Әфраимниң бешидин елип Манассәһниң бешиға йөткимәкчи болуп, ");
INSERT INTO uigcyr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","атисиға: — Әй ата, бундақ қилмиғин; чүнки мана, тунҗиси будур; оң қолуңни униң бешиға қойғин! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Лекин атиси рәт қилип: — Билимән, и оғлум, билимән; униңдинму бир қовм чиқип, өзиму улуқ болиду, амма дәрһәқиқәт униң иниси униңдин техиму улуқ болиду; униң нәслидин наһайити көп қовмлар пәйда болиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Шуниң билән шу күни у бу иккисини бәрикәтләп: — Кәлгүсидә Исраиллар бәхит-бәрикәт тилигәндә: «Худа сени Әфраим билән Манассәһдәк улуқ қилсун!» дәйдиған болиду, деди. Бу тәриқидә у Әфраимни Манассәһтин үстүн қойди. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Андин Исраил Йүсүпкә йәнә: — Мана, мән өлимән; лекин Худа силәр билән биллә болуп, силәрни ата-бовилириңларниң зиминиға қайтуруп бариду. ");
INSERT INTO uigcyr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Мән саңа қериндашлириңниңкидин бир үлүш йәрни артуқ бәрдим; шу йәрни өзүм қилич вә оқяйим билән Аморийларниң қолидин тартивалған едим.    ");
INSERT INTO uigcyr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Андин Яқуп оғуллирини чақирип уларға мундақ деди: — Һәммиңлар җәм болуңлар, мән силәргә кейинки күнләрдә силәр йолуғидиған ишларни ейтип берәй: — ");
INSERT INTO uigcyr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Жиғилип келип аңлаңлар, и Яқупниң оғуллири; Атаңлар Исраилға қулақ селиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Әй Рубән, сән мениң тунҗа оғлумсән, Күч-қудритимсән, Күчүм бар вақтимниң тунҗа мевисидурсән, Салапәт вә қудрәттә алди едиң, ");
INSERT INTO uigcyr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Лекин қайнап тешип чүшкән судәк, Әнди алди болалмассән; Чүнки сән атаңниң көрписигә чиқтиң, Шуниң билән сән уни булғидиң! У мениң көрпәмниң үстигә чиқти!    ");
INSERT INTO uigcyr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Шимеон билән Лавий қериндашлардур; Уларниң қиличлири зораванлиқниң қураллиридур! ");
INSERT INTO uigcyr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Аһ җеним, уларниң мәслиһитигә кирмигин! И иззитим, уларниң җамаити билән четилип қалмиғай! Чүнки улар аччиғида адәмләрни өлтүрүп, Өз бешимчилиқ қилип буқиларниң пейини кәсти. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Уларниң аччиғи әшәддий болғачқа ләнәткә қалсун! Ғәзивиму рәһимсиз болғачқа ләнәткә қалсун! Мән уларни Яқупниң ичидә тарқитиветимән, Исраилниң ичидә уларни чечиветимән.    ");
INSERT INTO uigcyr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Әй Йәһуда! Сени болса қериндашлириң тәрипләр, Қолуң дүшмәнлириңниң гәҗгисини басар. Атаңниң оғуллири саңа баш урар, ");
INSERT INTO uigcyr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Йәһуда яш бир ширдур; Әй оғлум, сән овни тутупла чиқтиң; У ширдәк овниң йенида чөкүп созулуп ятса, Яки чиши ширдәк йетивалса, Кимму уни қозғашқа петинар?    ");
INSERT INTO uigcyr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Шаһанә һаса Йәһудадин кетип қалмайду, Йәһуданиң пуштидин қанун чиқарғучи өксүмәйду, Таки шу һоқуқ Егиси кәлгичә күтиду; Кәлгәндә, җаһан хәлиқлири униңға итаәт қилиду.    ");
INSERT INTO uigcyr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","У тәхийини үзүм телиға, Ешәк балисини сортлуқ үзүм телиға бағлап қояр. У либасини шарапта жуюп, Тонини үзүм шәрбитидә жуяр. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Униң көзлири шараптин қизирип кетәр, Чишлири сүт ичкинидин аппақ турар. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Зәбулун деңиз бойини макан қилар, Макани кемиләрниң панаһгаһи болар, Йәр-зимини Зидонғичә йетип барар. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Иссакар бәстлик бәрдәм бир ешәктур, У икки қотан арисида ятқандур; ");
INSERT INTO uigcyr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","У арамгаһниң яхши екәнлигигә қарап, Зиминниң есиллиғини көрүп, Жүк көтиришкә мүрисини егип, Алванға ишләйдиған қул болуп қалар. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан Исраил қәбилилиридин бири болар, Өз хәлқигә һөкүм чиқирар. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Дан йол үстидики илан, Чиғир йол үстидә турған зәһәрлик бир иландур. У атниң туйиғини чеқип, Ат мингүчини арқиға моллақ атқузар. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","И Пәрвәрдигар, ниҗатиңға тәлмүрүп күтүп кәлдим! ");
INSERT INTO uigcyr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Гадқа болса, қарақчилар қошуни һуҗум қилар; Лекин у тапинини бесип зәрбә берәр. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Аширниң тамиғида зәйтун мейи мол болар, У шаһлар үчүн назу-немәтләрни тәминләр. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Нафталидин чирайлиқ гәпләр чиқар, У әркин қоюветилгән маралдур. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Йүсүп мевилик дәрәқниң шехидур, Булақниң йенидики көп мевилик шахтәктур; Униң шахчилири тамдин һалқип кәткәндур.    ");
INSERT INTO uigcyr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Я атқучилар униңға азар қилип, Униңға оқ атти, униңға нәпрәтләнди. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Һалбуки, униң оқяйи мәзмут турар, Қол-биләклири әплик турғузулар, Шу күч Яқуптики қудрәт Егисиниң қоллиридиндур — (Исраилниң Қорам Теши, йәни униң Падичиси Униңдин чиқар!) ");
INSERT INTO uigcyr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Әшу күч атаңниң Тәңрисидиндур — (У саңа мәдәт берәр!) Йәни Һәммигә Қадирдиндур — У сени бәрикәтләр! Жуқирида асманниң бәрикәтлири билән, Төвәндә ятқан чоңқур суларниң бәрикәтлири билән, Әмчәк билән балиятқуниң бәрикити билән сени бәрикәтләр! ");
INSERT INTO uigcyr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Сениң атаңниң тилигән бәрикәтлири ата-бовилиримниң тилигән бәрикәтлиридин зиядә болди, Улар мәңгүлүк тағ-едирларниң чәтлиригичә йетәр, Улар Йүсүпниң бешиға чүшәр, Йәни өз қериндашлиридин айрим турғучиниң чоққисиға тегәр.    ");
INSERT INTO uigcyr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Бинямин житқуч бөридәктур; Әтигәндә у овни йәр. Кәчқурун у олҗисини тәқсим қилар» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Буларниң һәммиси Исраилниң он икки қәбилиси болуп, мәзкур сөзләр болса атисиниң уларға тилигән бәхит-бәрикәт сөзлиридур. У шуниң билән уларниң һәр биригә мас келидиған бир бәрикәт билән уларға бәхит-бәрикәт тилиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Андин Яқуп уларға мундақ тапилиди: — «Мән әнди өз қовмимниң қешиға қошулимән. Силәр мени ата-бовилиримниң йенида, Һиттийлардин болған Әфронниң етизлиғидики ғарға дәпнә қилиңлар; ");
INSERT INTO uigcyr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","у ғар болса Қанаан зиминида Мамрәниң удулида, Макпелаһниң етизлиғида. Ғарни Ибраһим гөристан болсун дәп шу етизлиқ билән қошуп Һиттий Әфрондин сетивалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Шу йәрдә Ибраһим аяли Сараһ билән дәпнә қилинған; шу йәрдә Исһақ аяли Ривкаһ биләнму дәпнә қилинған; шу йәрдә мәнму Леяһни дәпнә қилдим. ");
INSERT INTO uigcyr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Бу етизлиқ һәм ичидики ғар Һәтниң әвлатлиридин сетивелинған еди». ");
INSERT INTO uigcyr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Яқуп оғуллириға бу вәсийәтни тапилап болуп, путлирини кариватта түзләп, нәпәс тохтап өз қовмиға қошулди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Йүсүп атисиниң йүзигә өзини етип, униң үстидә жиғлап, уни сөйди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Андин Йүсүп өз хизмитидә болған тевипларға атисини мумия қилишни буйруди; шуниң билән тевиплар Исраилни мумия қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Буни қилишқа қириқ күн кәтти, чүнки мумия қилишқа шунчилик күн кетәтти. Мисирлиқлар униңға йәтмиш күн матәм тутти. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Униңға һаза тутуш күнлири өтүп болғанда, Йүсүп Пирәвнниң ордисидикиләргә: — Мән нәзириңларда илтипат тапқан болсам, Пирәвнниң қулақлириға сөз қилиңларки: — Атам маңа қәсәм қилдуруп: «Мана мән өлимән; сән мени мән Қанаан зиминида өзүм үчүн колап қойған гөргә дәпнә қилғин» дегән еди. Әнди Пирәвн маңа иҗазәт бәргәй, мән берип атамни дәпнә қилип болуп йенип кәлсәм, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Пирәвн җававән: — Сән берип өзүңгә атаң қәсәм қилдурғандәк уни дәпнә қилғин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Шуниң билән Йүсүп атисини дәпнә қилғили маңди. Пирәвнниң барлиқ хизмәткарлири, ординиң ақсақаллири һәм Мисир зиминидики ақсақаллар униң билән һәмраһ болуп маңди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Йүсүпниң өйидики һәммиси, қериндашлири вә атисиниң өйидикиләрму биллә барди; улар пәқәт кичик балилири, қой-кала падилирини Гошән жутида қоюп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Униң билән йәнә җәң һарвулири вә атлиқларму биллә барди; шуниң билән улар наһайити чоң бир қошун болди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Улар Иордан дәриясиниң у тәрипидики «Атадниң хамини»ға йетип кәлгәндә, шу йәрдә қаттиқ вә һәсрәтлик жиға-зерә қилип матәм тутуп жиғлашти. Йүсүп атиси үчүн йәттә күн матәм тутти. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Шу жутта олтиришлиқ Ⱪананийлар Атадниң хаминида болған бу матәмни көрүп: — Бу мисирлиқларниң интайин қаттиқ тутқан һазиси болди, дейишти. Бу сәвәптин у җайниң нами «Абәл-Мизраим» дәп аталди; у Иордан дәриясиниң у тәрипидидур. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Яқупниң оғуллири униң өзлиригә тапилиғинидәк қилди; ");
INSERT INTO uigcyr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","униң оғуллири уни Қанаан зиминиға елип берип, Мамрәниң удулида, Макпелаһниң етизлиғиниң ичидики ғарда дәпнә қилди. Шу ғарни Ибраһим қәбирстанлиқ қилай дәп Макпелаһниң етизлиғи билән қошуп Һиттий Әфрондин сетивалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Йүсүп атисини дәпнә қилғандин кейин, өзи, қериндашлири, шундақла атисини дәпнә қилишқа униңға һәмраһ болуп чиққан һәммә хәлиқләр Мисирға йенип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Лекин Йүсүпниң қериндашлири атисиниң өлүп кәткинини көргәндә: — Әнди Йүсүп бизгә дүшмән болуп бизниң униңға қилған барлиқ яманлиғимизни үстимизгә яндурармекин, дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Улар Йүсүпниң қешиға адәм әвәтип: — Атилири өлүштин илгири бизгә вәсийәт қилип тапилап: — ");
INSERT INTO uigcyr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Силәр Йүсүпкә: — Акилириң саңа рәзиллик қилған еди; әнди уларниң асийлиғи һәм гунайини кәчүргин! — дәңлар» — дегән еди. Һазир силидин өтүнүмизки, атилириниң Худасиниң бәндилириниң асийлиғини кәчүргәйла! — деди. Йүсүп бу гәпләрни аңлап жиғлиди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Андин акилири келип униң алдида өзлирини йәргә етип: — Мана, биз силиниң қуллиридурмиз! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Лекин Йүсүп уларға җававән: — Қорқмаңлар! Мән Худаниң орнида туруватамдим? ");
INSERT INTO uigcyr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Силәр дәрвәқә маңа шу ишни яман нийәт билән қилдиңлар; лекин Худа бүгүнки күндикидәк нурғунлиған хәлиқниң җенини тирик сақлап қелиш үчүн шу ишни яхшилиққа бекиткән еди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Шуңа әнди қорқмаңлар; мән һәм силәрни һәм бала-җақилириңларни бақимән, — деди вә уларниң көңлини хатирҗәм қилип меһирлик гәп қилди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Йүсүп атисиниң җәмәти билән биллә Мисирда туруп қалди. Йүсүп бир йүз он жил өмүр көрди. ");
INSERT INTO uigcyr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Бу тәриқидә Йүсүп Әфраимниң үчинчи әвладини көрди; Манассәһниң оғли Макирниң балилириму униң тизлири үстидә туғулди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Йүсүп қериндашлириға: — Мән өлүп кетимән; лекин Худа чоқум силәрни йоқлап силәрни бу зиминдин чиқирип, Ибраһим, Исһақ вә Яқупқа беришкә қәсәм қилип вәдә қилған зиминға йәткүзиду, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Андин Йүсүп йәнә қериндашлириға қәсәм ичкүзүп: «Худа силәрни чоқум йоқлайду; шу чағда силәр мениң сүйәклиримни елип, бу йәрдин чиқип кетишиңлар керәк», — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Йүсүп бир йүз он яшқа киргәндә вапат тапти. Улар уни мумия қилип, Мисирда бир мейит сандуғиға селип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Вә төвәндикиләр Исраил билән биллә Мисирға барған оғуллириниң исимлири (улар һәр қайсиси өз бала-җақилирини елип, Яқуп билән биллә Мисирға барған еди): —    ");
INSERT INTO uigcyr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Рубән, Шимеон, Лавий, Йәһуда, ");
INSERT INTO uigcyr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Иссакар, Зәбулун, Бинямин, ");
INSERT INTO uigcyr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Дан, Нафтали, Гад вә Ашир. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Әнди Яқупниң пуштидин болғанлар җәмий болуп йәтмиш адәм еди. Бу вақитта Йүсүп Мисирда еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Кейин Йүсүп, униң барлиқ қериндашлири һәмдә барлиқ замандашлири өлүп түгиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Шундақтиму, Исраиллар көп туғулуп, тез көпийип, интайин күчәйди; улар зиминға бир кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","У вақитларда Йүсүпни билмәйдиған йеңи бир падиша Мисирда тәхткә чиқти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","У хәлқигә: Мана, Исраилларниң хәлқи биздин зиядә көпийип һәмдә биздинму күчлинип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Әнди биз уларға нисбәтән ақиланә иш тутайли; болмиса, улар техиму көпийип кетиду, мабада уруш партлап қалса, шундақ болидуки, улар дүшмәнлиримиз тәрәпкә өтүп, бизгә һуҗум қилип, жуттин чиқип кетиши мүмкин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Шуниң билән улар уларни қиливатқан әмгәкләрдә харлаш үчүн иш башлирини тайинлап назарәтчиликкә қойди. Шуниң билән Исраиллар Пирәвн үчүн Питом билән Раамсәс дегән маддий әшя сақлайдиған шәһәрләрни ясап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Лекин уларни қанчә әзгәнсери, булар шунчә көпийип һәммә йәрни қаплиди; буниң билән мисирлиқлар Исраилларға өч болуп кәтти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Шуниң билән мисирлиқлар Исраилларға зулум қилип, уларни техиму қаттиқ ишлитип еғир ишларға салди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Мисирлиқлар уларни лайчилиқ, хиш-кесәк қуюш вә етизларниң һәр хил әмгәклиригә селип, ишниң қаттиқлиғи билән уларниң турмушиға қаттиқ еғирчилиқ салди; уларни немә әмгәккә салмисун, интайин җапалиқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Мисир падишаси икки ибраний туғут анисиға сөз қилип (уларниң бириниң исми Шифраһ, йәнә бириниң исми Пуаһ еди): ");
INSERT INTO uigcyr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","— силәр қачанлиги ибраний хотунларни туғдурсаңлар, туққанда убдан қараңлар; бовақ оғул болса, өлтүрүветиңлар; қиз болса, тирик қоюңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Лекин туғут анилири Худадин қорқуп, Мисирниң падишаси уларға ейтқандәк қилмай, бәлки оғул бовақларни тирик қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Шуңа Мисирниң падишаси туғут анилирини чақиртип улардин: — Бу немә қилғиниңлар?! Оғул балиларни немишкә тирик қойдуңлар? — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Туғут анилири Пирәвнгә җавап берип: — Ибраний аяллар мисирлиқ аялларға охшимайду. Улар күчлүк, сағлам-тимән болғини үчүн туғут анилири уларниң қешиға йетип барғичә, өзлири туғуп болиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Нәтиҗидә, Худа туғут анилириға илтипат көрсәтти; Исраил хәлқи давамлиқ көпийип, техиму күчәйди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Шундақ болдики, туғут анилири Худадин қорқидиған ихласмән болғанлиғи үчүн Худа уларни аилилик болушқа муйәссәр қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Буниң билән Пирәвн барлиқ пуқралириға: — Исраиллардин йеңи туғулған оғул балиларниң һәммисини дәрияға ташлаңлар, лекин қиз балиларниң һәммисини тирик қалдуруңлар, дәп әмир қилди.      ");
INSERT INTO uigcyr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Лавийниң җәмәтидин болған бир киши берип, Лавийниң нәслидин болған бир қизни хотунлуққа алди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Бу аял һамилдар болуп, бир оғул туғди. Ана униң чирайлиқ екәнлигини көрүп, уни үч ай йошуруп сақлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Уни йәнә йошурушқа амалсиз қалғанда, қомуштин бир севәт ясап, униңға ярйелим вә мом сугап, балини ичигә селип, дәрияниң қирғиқидики қомушлуқ арисиға қоюп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Андин балиниң һәдиси униңға немә боларкин дәп жирақтин қарап турди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","У вақитта Пирәвнниң қизи суға чөмүлгили дәрия тәрәпкә кәлди; униң чөрилири дәрия бойида айлинип жүрди. Пирәвнниң қизи қомушлуқниң арисида турған севәтни көрүп, хас чөрисини уни елип чиқишқа әвәтти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","У севәтни ечип қаривиди, мана, бир оғул балини көрди вә у бала жиғлап кәтти. Мәликә униңға ич ағритип: — Бу шүбһисизки ибранийларниң балилиридин бири екән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","У чағда балиниң һәдиси Пирәвнниң қизидин: — Мән берип, сили үчүн балини емитип бақидиған бир ибраний иник ана тепип келәйму? — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Пирәвнниң қизи униңға: — Барғин, деди. Қиз берип бовақниң анисини чақирип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Пирәвнниң қизи униңға: — Бу балини елип кетип мән үчүн емитип беқип бәр; һәққиңни беримән, деди. Шуниң билән аял балини елип кетип, уни емитип бақти. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Бала чоң болғанда уни Пирәвнниң қизиниң қешиға елип барди; у униңға оғул болди. У: «Мән уни судин чиқиривалған» дәп униңға Муса дегән исимни қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Муса чоң болғандин кейинки күнләрдә шундақ болдики, у өз қериндашлириниң йениға барди вә уларниң еғир әмгәккә селиниватқанлиғини өз көзи билән көрди. Арида, бир мисирлиқниң ибраний қериндашлиридин бирини уруватқанлиғини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","У төрт әтрапиға қарап, адәм йоқлуғини көрүп, һелиқи мисирлиқни уруп өлтүрүп, қумға көмүп йошуруп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Әтиси у йәнә чиқип қаривиди, мана икки ибраний бир-бири билән соқушувататти; у йолсизлиқ қиливатқан кишигә: — Өз қериндишиңни немишкә урисән? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Һелиқи киши җавап берип: — Ким сени бизгә һаким вә сорақчи қилип қойди? Һелиқи мисирлиқни өлтүргиниңдәк мениму өлтүрмәкчимусән? — деди. Муса бу гәпни аңлап қорқуп өз ичидә: «Мән қилған иш җәзмән ашкарә болуп қапту!» дәп ойлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Пирәвн һәм бу иштин хәвәр тепип, Мусани өлтүрмәкчи болди; лекин Муса Пирәвнниң алдидин қечип, Мидиян зиминиға берип олтирақлашти. Бир күни, у қудуқниң йениға келип олтарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Мидиянниң каһининиң йәттә қизи бар еди; улар келип, атисиниң қойлирини суғиришқа су тартип оқурларға қуюп толдурушқа башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","У вақитта йәрлик падичилар келип, уларни һайдиди, Муса қопуп қизларға ярдәм берип, қойлирини суғиришип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Улар атиси Реуәлниң қешиға йенип кәлгәндә, улардин: — Немишкә бүгүн шунчә тез йенип кәлдиңлар? — дәп сориди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Улар җавап берип: — Бир мисирлиқ адәм бизни падичиларниң қолидин қутқузди һәмдә биз үчүн су тартип, қой падимизни суғирипму бәрди! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","У қизлириға: — Ундақта у киши һазир нәдә?! Уни немишкә сиртта ташлап кәлдиңлар? Уни тамаққа чақириңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Муса у киши билән биллә турушқа мақул болди. У қизи Зиппораһни униңға хотунлуққа бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","У аял униңға бир оғул туғуп бәрди; Муса «Мән яқа жутта мусапирдурмән» дәп, униң исмини Гәршом дәп қойди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Нурғун күнләр өтүп, Мисирниң падишаси өлди. Исраиллар өз қуллуқ һалити түпәйлидин аһ-зар уруп, налә-пәряд көтәрди; қуллуқтин болған пәряди Худаниң һозуриға берип йәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Худа уларниң аһ-зарлирини аңлап, Өзиниң Ибраһим билән, Исһақ билән вә Яқуп билән түзгән әһдисини есигә алди. ");
INSERT INTO uigcyr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Шуниң билән Худа Исраилларниң һал-әһвалини көрди вә Худа уларға көңүл бөлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Муса болса қейинатиси Мидиянниң каһини Йәтрониң қой падисини бақатти. У қойларни башлап чөлниң әң четигә Худаниң теғи, йәни Һорәб теғиниң бағриға кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Шу йәрдә бир азғанлиқтин өрләп чиқиватқан от ялқуни ичидин Пәрвәрдигарниң Пәриштиси униңға көрүнди. Мана, азғанлиқ отта көйүватқан болсиму, лекин азған өзи көйүп кәтмигән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Муса: — Мән берип, бу әҗайип мәнзирини көрүп бақай; азғанлиқ немишкә көйүп кәтмәйдиғанду? — дәп ойлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Пәрвәрдигар униң буни көргили йолдин чәтнәп азғанлиққа кәлгинини көрди; Худа азғанлиқ ичидин уни: — Муса! Муса! — дәп чақирди. У: Мана мән! — дәп җавап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","У униңға: — Бу йәргә йеқин кәлмә; путлириңдин кәшиңни салғин; чүнки сән турған бу йәр муқәддәс җайдур.    ");
INSERT INTO uigcyr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Мән атаңниң Худаси, Ибраһимниң Худаси, Исһақниң Худаси вә Яқупниң Худасидурмән, — деди. Буни аңлап Муса Худаға қараштин қорқуп, йүзини етивалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Пәрвәрдигар униңға мундақ деди: — Бәрһәқ, Мән Мисирда туруватқан қовмимниң тартиватқан азап-оқубәтлирини көрдум, назарәтчиләрниң уларни харлаватқанлиғидин қилған пәрядини аңлидим; чүнки Мән уларниң дәрдлирини билимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Шуңа Мән уларни мисирлиқларниң қолидин қутқузуп, шу зиминдин чиқирип, яхши һәм кәң бир зиминға, сүт билән һәсәл еқип туридиған бир зиминға, йәни Ⱪананий, Һиттий, Аморий, Пәриззий, Һивий вә Йәбусийларниң жутиға елип беришқа чүштүм. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Мана әнди Исраилларниң налә-пәряди Маңа йәтти, мисирлиқларниң уларға қандақ зулум қилғанлиғиниму көрдүм. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Әнди сән кәл, Мән сени хәлқим Исраилларни Мисирдин елип чиқириш үчүн Пирәвнниң алдиға әвәтимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Лекин Муса Худаға: — Мән ким едим, Пирәвнниң алдиға берип Исраилларни Мисирдин чиқиралиғидәк? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","У җавап берип: — Бәрһәқ, Мән сән билән биллә болимән; сән қовмни Мисирдин елип чиққандин кейин бу тағда Худаға ибадәт қилисиләр; бу иш мана өзәңгә Мениң сени әвәткинимниң испат-бәлгүси болиду, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Шуниң билән Муса Худаға: — Мән Исраилларниң қешиға берип уларға: «Ата-бовилириңларниң Худаси мени қешиңларға әвәтти» десәм, улар мәндин: «Униң нами немә?» — дәп сориса, уларға немә дәп җавап беримән? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Худа Мусаға: — Мән «Әзәлдин бар Болғучи»дурмән — деди. Андин У: — Берип, Исраилларға: ««Әзәлдин бар Болғучи» мени қешиңларға әвәтти» дәп ейтқин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Худа Мусаға йәнә: — Исраилларға: — «Ата-бовилириңларниң Худаси, Ибраһимниң Худаси, Исһақниң Худаси вә Яқупниң Худаси болған «Яһвәһ» мени қешиңларға әвәтти; У: Яһвәһ дегән бу нам әбәткичә Мениң намим болиду, дәвирдин-дәвиргичә Мән шу нам билән әскә елинимән, дәйду» — дегин. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","— Берип, Исраилниң ақсақаллирини жиғип уларға: — «Ата-бовилириңларниң Худаси, йәни Ибраһим, Исһақ вә Яқупниң Худаси болған Пәрвәрдигар маңа көрүнүп: — Мән силәрни йоқлап кәлдим, Мисирда силәргә қандақ муамилә қилиниватқанлиғини көрдүм; ");
INSERT INTO uigcyr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","шуниң үчүн сөзүм шудурки, Мән силәрни Мисирниң зулумидин чиқирип, Ⱪананийлар, Һиттийлар, Аморийлар, Пәриззийләр, Һивийлар вә Йәбусийларниң зимини, йәни сүт билән һәсәл еқип туридиған зиминға елип баримән, деди, — дегин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","— Шуниң билән улар сениң сөзүңгә қулақ салидиған болиду. У вақитта сән, өзүң вә Исраилниң ақсақаллири билән биргә Мисир падишасиниң алдиға берип, униңға: «Ибранийларниң Худаси Пәрвәрдигар биз билән көрүшти. Әнди сиздин өтүнимизки, бизгә үч күнлүк йолни бесип, чөлгә берип, Худайимиз Пәрвәрдигарға қурбанлиқ қилишқа иҗазәт бәргәйсиз» — дәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Лекин Мисир падишасиниң һәтта қудрәтлик бир қолниң астида турупму, силәрни йәнила қоюп бәрмәйдиғинини билимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Шуңа қолумни узитип, мисирлиқларни Мән өз зимини ичидә көрсәтмәкчи болған һәр хил карамәт-мөҗизилирим билән уримән; андин Пирәвн силәрни қоюп бериду. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Бу қовмни мисирлиқларниң алдида илтипат таптуримән вә шуниң билән шундақ болидуки, силәр шу йәрдин чиққиниңларда, қуруқ қол чиқмайсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Бәлки һәр бир аял киши өз хошнисидин вә өз өйидә олтиришлиқ ят аялдин күмүч зиннәт буюмлири, алтун зиннәт буюмлири вә кийим-кечәкләрни тәләп қилиду. Бу нәрсиләрни оғул-қизлириңларға тақайсиләр, кийдүрисиләр; шу тәриқидә мисирлиқлардин олҗа алған болисиләр, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Муса җавап берип: — Мана, улар маңа ишәнмәй туруп, сөзүмгә қулақ салмайду, бәлки: «Пәрвәрдигар саңа көрүнмиди», дейиши мүмкин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Пәрвәрдигар униңға: — Қолуңдики бу немә? — дәп сориди. У: — Бу бир һаса, дәп җавап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","У: — Уни йәргә ташла, деди. Уни йәргә ташливиди, у бир иланға айланди; Муса униң алдидин қачти. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Андин Пәрвәрдигар Мусаға: — Қолуңни узитип, уни қуйруғидин тут, девиди, у қолини узитип, уни тутти. У йәнә униң қолида һасиға айланди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Пәрвәрдигар йәнә: — Буниң билән улар ата-бовилириниң Худаси, йәни Ибраһимниң Худаси, Исһақниң Худаси вә Яқупниң Худаси болған Пәрвәрдигарниң саңа көрүнгинигә ишиниду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Пәрвәрдигар униңға йәнә: — Қолуңни қойнуңға салғин, девиди, у қолини қойниға селип чиқиривиди, мана, қоли песә-мохо кесилигә гириптар болуп қардәк ақирип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Андин униңға: — Қолуңни йәнә қойнуңға салғин, девиди, қолини қойниға салди. Уни йәнә қойнидин чиқиривиди, мана, өз әксигә келип әтлириниң башқа йәрлиридәк болди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Пәрвәрдигар йәнә: — Шундақ болидуки, әгәр улар саңа ишәнмәй, алдинқи мөҗизилик аламәтгә көңүлшимисә, улар иккинчи мөҗизилик аламәткә ишиниду. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Һалбуки, улар бу икки мөҗизигә йәнила ишәнмисә вә я сөзүңгә қулақ салмиса, ундақта сән Нил дәриясиниң сүйидин елип, қуруқ йәргә төккин. Шуниң билән сән дәриядин алған су қуруқ йәр үстидә қанға айлиниду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Андин Муса Пәрвәрдигарға: — Әй Егәм, мән әслидинла гәпкә уста әмәстим, сән қулуңға сөз қилғандин кейинму йәнила шундақ; чүнки мән ағзим калва вә тилим еғир адәммән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Пәрвәрдигар униңға: — Ким инсанға еғиз бәргән? Ким адәмни гача яки гас, көргүчи яки кор қилған? Шундақ қилғучи Мән Пәрвәрдигар әмәсму? ");
INSERT INTO uigcyr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Әнди сән барғин, Мән Өзүм сениң ағзиң билән биллә болимән, немә сөзләйдиғиниңни саңа үгитип туримән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Лекин у: — Әй Егәм! Сәндин өтүнүп қалай, Сән бу ишқа халиған башқа бирисини әвәтип, шуниң қоли билән қилғин! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Буни аңлап Пәрвәрдигарниң ғәзиви Мусаға тутишип: — Лавийлардин болған акаң Һарун бар әмәсму? Униң гәпни убдан қилалайдиғинини билимән. Мана, у әнди сениң алдиңға чиқишқа аллиқачан йолға чиқти; у сени көрсә, көңли толиму хуш болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Әнди дәйдиған гәпләрни униңға ейт; Мән Өзүм сениң ағзиң билән биллә вә униң ағзи билән биллә болимән, немә қилиш керәклигиңларни силәргә үгитимән.    ");
INSERT INTO uigcyr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Һарун сениң орнуңда хәлиққә сөзләйду; шундақ болидуки, у саңа еғиз болиду, сән униңға Худадәк болисән. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Бу һасини қолуңға елип, униң билән шу мөҗизилик аламәтләрни көрситисән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Шуниң билән Муса қейинатиси Йәтрониң қешиға йенип берип, униңға: — Маңа иҗазәт бәргәйла, Мисирдики қериндашлиримниң қешиға барай, улар һаятму, әмәсму көрүп келәй, деди. Йәтро Мусаға: — Аман-есән берип кәлгин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Муса техи Мидияндики вақтида, Пәрвәрдигар униңға йәнә: — Мисирға йенип барғин! Чүнки сениң җениңни истигән кишиләр өлүп кәтти, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Шуниң билән Муса аяли вә оғуллирини елип, уларни бир ешәккә миндүрүп, Мисир зиминиға беришқа йолға чиқти. Маңғанда Муса Худаниң һасисини алғач кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Пәрвәрдигар Мусаға: — Мисирға йенип барғиниңда сән агаһ бол, Мән қолуңға тапшурған барлиқ карамәтләрни Пирәвнниң алдида көрсәткин. Лекин Мән униң көңлини хәлиқни қоюп бәрмигидәк қаттиқ қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Сән Пирәвнгә: — «Пәрвәрдигар мундақ дәйду: — Исраил Мениң оғлум, Мениң тунҗа оғлум болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Шуниң үчүн Мән саңа: Оғлумни Өзүмгә ибадәт қилишқа қоюп бәр, дедим. Униңға йол қоюшни рәт қилидиған болсаң, сениң тунҗа оғлуңни өлтүримән» — дегин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Амма Муса сәпәр қилип бир қоналғуға кәлгәндә, Пәрвәрдигар униңға учрап, уни өлтүрүвәтмәкчи болди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Шуниң билән Зиппораһ бир чақмақ тешини елип, оғлиниң хәтнилигини кесип, уни ериниң айиғиға ташлап: — Сән дәрвәқә алдимда қан төкәр әр екәнсән! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Шуниң билән Пәрвәрдигар уни қоюп бәрди (бу чағда Зиппораһ униңға: «Сән дәрвәқә алдимда қан төкәр бир әр екәнсән!» — деди. Бу сөзини у хәтнә түпәйлидин ейтти). ");
INSERT INTO uigcyr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Пәрвәрдигар Һарунға: — Сән чөл-баяванға берип, Муса билән көрүшкин, девиди, у берип Худаниң теғида униң билән учришип, уни сөйди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Муса өзини әвәткән Пәрвәрдигарниң һәммә сөзлири билән қилишқа буйруған барлиқ мөҗизилик аламәтләрни Һарунға дәп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Андин Муса билән Һарун берип, Исраилларниң барлиқ ақсақаллирини жиғди. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Һарун Пәрвәрдигарниң Мусаға ейтқан һәммә сөзлирини баян қилди вә хәлиқниң көз алдида шу мөҗизилик аламәтләрни көрсәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Буни көрүп, хәлиқ ишәнди; Пәрвәрдигарниң Исраилларни йоқлап, улар учриған харлиқларни көргәнлигини аңлиған һаман, башлирини егип сәҗдә қилишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Андин Муса билән Һарун Пирәвнниң алдиға берип, униңға: — Исраилниң Худаси Пәрвәрдигар саңа: — «Уларниң берип чөлдә Маңа ибадәт қилип, һейт өткүзүшигә қовмимға йол қойсун» дәйду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Лекин Пирәвн җавап берип: — Униң сөзигә қулақ селип, мени Исраилға йол қойғузидиған қандақ Пәрвәрдигар екән у? Мән у Пәрвәрдигарни тонумаймән һәм Исраилғиму йол қоймаймән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Улар сөз қилип: — Ибранийларниң Худаси биз билән көрүшти. Шуңа өтүнимизки, бизгә Пәрвәрдигар Худайимизға қурбанлиқ сунуш үчүн бизгә чөлгә беришқа үч күнлүк йолға рухсәт бәргәйсиз. Болмиса, У бизни ваба яки қилич билән уруши мүмкин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Лекин Мисирниң падишаси уларға җавап берип: — Әй Муса вә Һарун, немишкә иккиңлар хәлиқни ишлиридин тохтитип қоймақчи болисиләр? Берип өз әпкишиңларни көтириңлар! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Пирәвн йәнә: — Мана, хәлиқ жутта зиядә көпийип кәтти. Силәр болсаңлар, уларни әпкәшлиридин халас қилмақчисиләр, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Шу күни Пирәвн назарәтчиләргә вә назарәтчиләрниң қол астидики иш башлириға буйруқ чүшүрүп: — ");
INSERT INTO uigcyr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Һазирдин башлап хәлиққә илгәркидәк кесәк қуюшқа саман бәрмәңлар! Улар саманни өзлири жиғсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Лекин илгири қанчилик кесәк қуюп кәлгән болса, һелиһәм кам қилмай шунчилик кесәк қуйдуруңлар; чүнки улар һорунлишип: «Худайимизға қурбанлиқ өткүзүшкә бизни барғили қой» дәп ғәлвә қилишиватиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Әнди уларни өз ишиға толуқ бәнд болуп, ялған-явидақ гәпләргә қулақ салмаслиғи үчүн, бу адәмләрниң үстигә техиму еғир әмгәкләрни жүкләңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Шуниң билән хәлиқниң үстидики назарәтчиләр билән иш башлири чиқип хәлиққә: Пирәвн шундақ дедики, мән әнди силәргә саман бәрмәйдиған болдум. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Өзүңлар бериңлар, өзүңлар үчүн қәйәрдин саман тапалисаңлар, шу йәрдин елип келиңлар; лекин қилидиған ишлириңлар болса қилчиликму кемәйтилмәйду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Буниң билән хәлиқ пүткүл Мисир зиминиға тарилип, саманниң орниға пахал жиғишқа башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Назарәтчиләр болса уларни қистап: Силәргә саман берилгән чағдикидәк һазирму һәр күнлүк ишни шу күни қилиңлар, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Исраилларниң үстигә Пирәвнниң назарәтчилири тәрипидин қоюлған Исраиллиқ иш башлири таяқ йеди вә: — Түнүгүн вә бүгүн немишкә кесәк қуюш вәзипсини бурунқидәк тошқузуп орунлимидиңлар?! — дәп тил ишитти. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Андин Исраиллиқ иш башлири Пирәвнниң алдиға берип: Немишкә өз қуллириға мундақ муамилә қилидила? ");
INSERT INTO uigcyr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Өз қуллириға һеч саман берилмиди. Лекин назарәтчиләр йәнила «кесәк қуйдуруңлар» дәп бизни буйруйду. Мана, өз қуллири таяқ йәватиду, амма әйип болса өзлириниң адәмлиридә, дәп пәряд қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Лекин у йәнә: — Силәр һорун екәнсиләр! Һорун екәнсиләр! Шуңа силәр: «Берип Пәрвәрдигарға қурбанлиқ өткүзүшимизгә иҗазәт бәр дәватисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Қайтип берип ишиңни қилиш! Силәргә саман берилмәйду, бирақ кесәкләрни бәлгүләнгән сан бойичә авалқидәк толуқ тапшурушисән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Исраиллиқ иш башлири Пирәвнниң: «Силәр һәр күнлүк вәзипәңларни, йәни тәләп қилған кесәкләрни бәлгүләнгән сандин кемәйтсәңлар қәтъий болмайду» дегинигә қарап, бешиға бала-қазаниң чүшидиғанлиғини билишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Улар Пирәвнниң алдидин чиқип келиватқинида, улар билән көрүшүшкә келип шу йәрдә сақлап турған Муса вә Һарун билән учришип қалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Улар Муса билән Һарунға: — Бизни Пирәвнниң нәзиридә вә униң әмәлдарлириниң нәзиридә сеситип, бизни өлтүрүшкә уларниң қолиға қилич тутқузғиниңлар үчүн, Пәрвәрдигар силәрниң үстүңларға һөкүм қилсун! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Шуниң билән Муса Пәрвәрдигарниң алдиға йенип берип униңға: — Әй Егәм, немишкә бу хәлиқни балаға тиқтиң? Сән немә үчүн мени әвәттиң? ");
INSERT INTO uigcyr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Чүнки мән Пирәвнниң алдиға кирип Сениң намиң билән сөз қилғинимдин тартип, у бу хәлиқниң үстигә техиму зиядә азап қилғили турди. Амма Сән техичә қовмиңни һеч қутқузмидиң, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Лекин Пәрвәрдигар Мусаға: — Әнди сән Мениң Пирәвнгә қилидиғанлиримни көрисән; чүнки у қудрәтлик бир қолдин мәҗбурлинип, уларни қоюп бериду, қудрәтлик бир қолниң сәвәвидин өзиниң зиминидин уларни қоғлап чиқириветиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Андин Худа Мусаға йәнә сөз қилип мундақ деди: — Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Мән Ибраһимға, Исһаққа вә Яқупқа Қадир-мутләқ Тәңри сүпитидә көрүндүм; лекин «Яһвәһ» дегән намим билән уларға ашкарә тонулмидим. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Мән улар билән: — «Силәр мусапир болуп олтарған зиминни, йәни Қанаан зиминини силәргә беримән» дәп, улар билән әһдә бағлишип вәдә қилғанмән. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Әнди Мән мисирлиқлар қул қилип зулум салған Исраилларниң аһ-зарлирини аңлап, қилған шу әһдәмни есимгә алдим. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Шуңа Исраилларға мундақ дегин: — «Мән Пәрвәрдигардурмән; Мән Өзүм силәрни мисирлиқларниң еғир жүклири астидин чиқирип, уларниң қуллуғидин азат қилип, қолумни узитип уларға чоң балаю-апәтләрни чүшүрүп, силәргә һәмҗәмәт болуп һөрлүккә ериштүримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Силәрни Өз қовмим болушқа қобул қилимән вә Өзүм Худайиңлар болимән; шуниң билән силәр өзүңларни мисирлиқларниң жүклириниң астидин қутқузуп чиқарғучиниң Мән Худайиңлар Пәрвәрдигар екәнлигини билисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Мән шуниң билән силәрни қол көтирип Ибраһимға, Исһаққа вә Яқупқа беришкә қәсәм қилған зиминға елип баримән; Мән у йәрни силәргә мирас қилип зиминлиққа беримән; Мән Пәрвәрдигардурмән». ");
INSERT INTO uigcyr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Буларниң һәммисини Муса Исраилларға дәп бәрди; лекин улар еғир қуллуқ азавидин пиғанға чүшкән болуп, униңға қулақ салмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Андин Пәрвәрдигар Мусаға йәнә: — ");
INSERT INTO uigcyr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Берип Мисирниң падишаси Пирәвнгә: «Исраилларниң зиминиңдин кетишигә йол қой», дәп ейтқин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Лекин Муса Пәрвәрдигарниң алдида: Мана, Исраиллар маңа қулақ салмиған йәрдә, Пирәвн қандақму мәндәк калпуки хәтнә қилинмиған бир адәмгә қулақ салсун? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Амма Пәрвәрдигар Муса вә Һарунға сөзләп, уларниң Исраилларға вә Мисирниң падишаси Пирәвнгә Исраиллар тоғрилиқ: — «Улар Мисир зиминидин елип чиқирилсун» дегән әмир йәткүзүшини буйруди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Төвәндикиләр җәмәт башлиқлири: — Исраилниң тунҗа оғли болған Рубәнниң оғуллири Һануқ, Паллу, Һәзрон вә Карми. Булар болса Рубәнниң нәсиллири еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Шимеонниң оғуллири: — Йәмуәл, Ямин, Оһад, Яқин, Зоһар вә қанаанлиқ аялдин болған Сауллар еди; булар Шимеонниң нәсиллири еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Лавийниң оғуллириниң исимлири, нәсәбнамилиригә асасән: Гәршон, Коһат вә Мәрари; Лавийниң өмриниң жиллири бир йүз оттуз йәттә жил болди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Гәршонниң оғуллири аилилири бойичә: — Либни вә Шимәй. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Коһатниң оғуллири: — Амрам, Йизһар, Һеброн билән Уззиәл. Коһат бир йүз оттуз үч жил өмүр көрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Мәрариниң оғуллири: — Маһли вә Муши. Булар нәсәбнамилири бойичә Лавийниң нәсиллири еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Амрам өз һаммиси Йокәбәдни хотунлуққа алди, Йокәбәд униңға Һарун вә Мусани туғуп бәрди. Амрам бир йүз оттуз йәттә жил өмүр көрди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Йизһарниң оғуллири: — Кораһ, Нәфәг вә Зикри еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Уззиәлниң оғуллири: — Мишаәл, Әлзафан вә Ситри еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Һарун болса Наһшонниң сиңлисини, йәни Амминадабниң қизи Елишебани хотунлуққа алди. У униңға Надаб билән Абиһуни, вә Әлиазар билән Итамарни туғуп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Кораһниң оғуллири: — Ассир, Әлканаһ вә Абиасаф; булар Кораһларниң нәсиллири еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Һарунниң оғли Әлиазар Путиәлниң қизлириниң бирини хотунлуққа алди; у униңға Финиһасни туғуп бәрди; булар болса өз нәсәби бойичә һәммиси Лавийларниң җәмәт башлиқлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Пәрвәрдигарниң: — Исраилларни қошунлардәк топ-топи билән Мисир зиминидин елип чиқиңлар, дегән әмрини тапшурувалғучилар дәл мошу Һарун билән Муса еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Исраиллар Мисирдин чиқирилсун, дәп Мисирниң падишаси Пирәвнгә сөз қилғанлар дәл бу кишиләр, йәни мошу Муса билән Һарун еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Пәрвәрдигар Мисирниң зиминида Мусаға сөз қилған вақтида ");
INSERT INTO uigcyr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Мусаға: «Мән Пәрвәрдигардурмән. Саңа ейтқинимниң һәммисини Мисирниң падишаси Пирәвнгә дегин», дәп әмир қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Лекин Муса Пәрвәрдигарниң алдида: — Мәндәк калпуки хәтнә қилинмиған бир кишигә Пирәвн қандақму қулақ салсун?» — дәп җавап бәргән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Шуниң билән Пәрвәрдигар Мусаға: — Мана, Мән Пирәвнниң алдида сени Худаниң орнида қилдим. Акаң Һарун болса сениң пәйғәмбириң болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Мән саңа буйруғинимниң һәммисини униңға дәйсән; андин акаң Һарун Пирәвнгә униң өз зиминидин Исраилларни қоюп бериши керәклиги тоғрисида сөз қилиду.    ");
INSERT INTO uigcyr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Лекин Мән Пирәвнниң көңлини қаттиқ қилимән; буниң билән Мән Мисир зиминида мөҗизилик аламәтләр вә карамәтлиримни көпләп көрситимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Шундақтиму, Пирәвн силәргә қулақ салмайду. Амма Мән Мисирниң үстигә һөкүм чиқирип қолумни узитип, чоң балаю-апәтләрни чүшүрүп, қошунлирим болған Өз қовмим Исраилларни Мисир зиминидин чиқиримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Өз қолумни Мисирниң үстигә созғинимда, Исраилларни уларниң арисидин чиқарғинимда мисирлиқлар Мениң Пәрвәрдигар екәнлигимни тонуп йетиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Муса билән Һарун шундақ қилди; Пәрвәрдигар уларға қандақ тапилиған болса, уларму шундақ қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Улар Пирәвнгә сөз қилған вақитта Муса сәксән яшқа, Һарун сәксән үч яшқа киргән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Пәрвәрдигар Муса билән Һарунға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Әнди Пирәвн силәргә: — Өзүңларни тәстиқлап бир мөҗизә көрситиңлар, десә, сән Һарунға: — Һасаңни елип Пирәвнниң алдиға ташлиғин, дәп ейтқин. Шундақ қилиши биләнла һаса иланға айлиниду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Шуниң билән, Муса билән Һарун Пирәвнниң алдиға берип, Пәрвәрдигарниң буйруғинидәк қилди; Һарун һасисини Пирәвн билән униң әмәлдарлириниң алдиға ташливиди, у иланға айланди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","У вақитта Пирәвн данишмәнлири вә сеһиргәрлирини чақиртип кәлди; Мисирниң җадугәрлириму өз җадуси билән охшаш ишни қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Уларниң һәр бири өз һасисини ташлиди; уларму иланға айланди. Лекин Һарунниң һасиси уларниң һасилирини жутуп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Бирақ Пәрвәрдигар ейтқандәк Пирәвнниң көңли қаттиқлиқ билән Пәрвәрдигар ейтқандәк уларға қулақ салмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Андин Пәрвәрдигар Мусаға мундақ деди: — Пирәвнниң көңли қаттиқ; у қовмни қоюп беришни рәт қилиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Әнди сән әтә сәһәрдә Пирәвнниң қешиға барғин (шу вақитта у су бойиға чиқиду) — Сән униң билән көрүшүшкә дәрияниң бойида сақлап турғин; иланға айланған һасини қолуңға еливал. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Сән униңға мундақ дегин: — «Ибранийларниң Худаси Пәрвәрдигар мени алдиңға: «Чөлдә Маңа ибадәт қилиши үчүн қовмимни қоюп бәр» дейишкә әвәткән еди; лекин мана, бу вақитқичә һеч аңлимидиң. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Шуңа Пәрвәрдигар саңа: — «Сән шу аламәт билән Мениң Пәрвәрдигар екәнлигимни билисән», дәйду — Мана, мән қолумдики һаса билән дәрияниң сүйини урсам, су қанға айлиниду, ");
INSERT INTO uigcyr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","дәрияниң белиқлири өлүп, дәрияниң сүйи сесип кетиду; мисирлиқлар судин сәскинип, ичәлмәйдиған болуп қалиду». ");
INSERT INTO uigcyr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Пәрвәрдигар Мусаға йәнә: — Сән Һарунға: — Һасаңни елип мисирлиқларниң сулири қанға айлансун дәп уларниң үстигә, йәни еқинлири, өстәңлири, көллири вә су амбарлири үстигә қолуңни узатқин. Шуниң билән пүткүл Мисир зиминида, һәтта яғач вә таш қачилардики суларму қанға айлиниду, дегин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Муса билән Һарун Пәрвәрдигарниң буйруғинидәк қилди; Һарун Пирәвн вә әмәлдарлириниң көз алдида һасини көтирип, дәрияниң сүйини урувиди, пүтүн дәрияниң сүйи қанға айлинип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Дәриядики белиқлар өлүп, дәрияниң сүйи сесип кәтти. Мисирлиқлар дәрияниң сүйини ичәлмәйдиған болуп қалди, пүткүл Мисир зимини қанға толди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Лекин Мисирниң җадугәрлириму өз җадулири билән һәм шундақ қилди. Бу сәвәптин Пәрвәрдигар ейтқандәк Пирәвнниң көңли қаттиқ болуп, уларға қулақ салмиди; ");
INSERT INTO uigcyr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","әксичә Пирәвн өйигә қайтип кетип, бу ишқа һеч писәнт қилмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Дәрияниң сүйини ичәлмигини үчүн барлиқ мисирлиқлар ичкидәк су тепиш үчүн дәрияниң әтраплирини колиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Пәрвәрдигар дәрияни уруп, йәнә йәттә күн өтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Андин Пәрвәрдигар Мусаға: — Пирәвнниң алдиға берип униңға: — Пәрвәрдигар мундақ дәйду: — «Маңа ибадәт қилишқа Өз қовмимни қоюп бәр. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Лекин уларни қоюп беришни рәт қилсаң, мана, Мән дөлитиңниң һәммә йерини пақилар билән бастуруп уримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Дәрияда топ-топ пақилар пәйда болуп, дәриядин чиқип ордаңға, һоҗраңға, орун-көрпәңгә, әмәлдарлириңниң өйлиригә киривалиду, шуниңдәк хәлқиңниң учисиға, тонур вә тәңнилириңгә ямишип чиқивалиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Пақилар өзүңниң үстибешиға, хәлқиңниң үстибешиға вә һәммә әмәлдарлириңниң үстибешиға ямишип чиқивалиду» — дегин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Пәрвәрдигар Мусаға: — Сән Һарунға: Пақиларниң Мисир зимининиң үстигә чиқиши үчүн қолуңни узитип, һасаңни еқинлар, өстәңләр вә көлләрниң үстигә шилтиғин, дегин — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Шуниң билән Һарун қолини Мисирниң сулири үстигә узатти; шундақ қиливиди, пақилар чиқип Мисир зиминини қаплиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Лекин җадугәрләрму өз җадулири билән охшаш ишни қилип, Мисир зимини үстигә пақиларни пәйда қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Пирәвн Муса билән Һарунни чақиртип: — Пақиларни мәндин вә хәлқимдин нери қилиш үчүн Пәрвәрдигардин өтүнүңлар. Шундақ болса, мән хәлқиңни Пәрвәрдигарға қурбанлиқ қилсун дәп қоюп беримән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Муса Пирәвнгә: — Бопту, мән иззитиңни қилай, пәқәт дәриядики пақиларла қелип, башқилири өзүңдин вә өйлириңдин айрилсун дәп, сән, әмәлдарлириң вә хәлқиң үчүн мениң дуа қилидиған вақтимни бекиткин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","У җавап берип: — Әтә болсун, деди. Муса униңға: — Худайимиз Пәрвәрдигарға охшаш һеч бириниң йоқлуғини билишиң үчүн сениң дегиниңдәк болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Пақилар сәндин, өйлириңдин, әмәлдарлириң вә хәлқиңдин чиқип кетиду; пәқәт дәриядила қалиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Шуниң билән Муса вә Һарун Пирәвнниң алдидин чиқип кәтти. Андин Муса Пирәвнниң үстигә әвәтилгән пақилар тоғрисида Пәрвәрдигарға нида қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Пәрвәрдигар Мусаниң тилигинидәк қилди. Буниң билән өйләрдики, һойлилардики вә етизлардики пақилар өлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Хәлиқ уларни жиғип дога-дога қилди, пүткүл жут-зимин сесиқчилиққа толди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Лекин Пирәвн апәттин халас болғинини көргәндә, көңлини қаттиқ қилип, Пәрвәрдигар ейтқинидәк уларға қулақ салмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Андин Пәрвәрдигар Мусаға: — Сән Һарунға: — Һасаңни узитип, йәрниң тописини урғин. Буниң билән у пашиға айлинип, пүткүл Мисир зиминини қаплайду, дегин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Улар шундақ қилди; Һарун қолини узитип һасиси билән йәрниң тописини урувиди, адәмләр вә һайванларниң үстибешини паша басти; пүткүл Мисир зиминидики топа-чаңлар пашиға айланди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Җадугәрләрму өз җадулири билән шундақ қилип паша пәйда қилишқа урунған болсиму, пәйда қилалмиди. Пашилар болса һәм адәмләрниң һәм һайванларниң үстибешини қаплап кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Андин җадугәрләр Пирәвнгә: — Бу иш Худаниң бармиғиниң қилғини! — дейишти. Лекин Пирәвн көңлини қаттиқ қилип, Пәрвәрдигар ейтқинидәк уларға қулақ салмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Пәрвәрдигар Мусаға: — Әтә сәһәр қопуп Пирәвнниң алдиға берип турғин — (шу вақитта у су бойиға чиқиду) униңға: «Пәрвәрдигар мундақ дәйду: — Маңа ибадәт қилиши үчүн Өз қовмимни қоюп бәр! ");
INSERT INTO uigcyr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Чүнки әгәр қовмимни қоюп бәрмисәң, мана Мән сениң вә әмәлдарлириң, хәлқиң үстигә, өйлириңгә көкүйүнләрни әвәтимән; шуниң билән мисирлиқларниң өйлири вә һәтта улар туруватқан тупрақму көкүйүнләр билән толиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Лекин шу күнидә Өз қовмим туруватқан Гошән жутини башқичә қилимән; шундақ болидуки, у йәрдә көкүйүнләр тепилмайду. Шуниң билән сән Мән Пәрвәрдигарниң бу зиминда болғанлиғимни билисән. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Шундақ қилип Мән Өз қовмимни сениң хәлқиңдин пәриқләндүримән; бу мөҗизилик аламәт әтә йүз бериду», дәп ейтқин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Пәрвәрдигар дегинини қилди. Пирәвнниң өйлиригә, әмәлдарлириниң өйлиригә көкүйүнләр топ-топ болуп кирди; пүткүл Мисир зимининиң һәммә йери көкүйүнләр тәрипидин харап болушқа башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Пирәвн Муса билән Һарунни чақиртип келип уларға: Берип мошу зиминда Худайиңларға қурбанлиқ өткүзүңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Лекин Муса җавап берип: — Бундақ қилиш бизгә таза мувапиқ болмайду; чүнки биз Пәрвәрдигар Худайимизға сунмақчи болған қурбанлиқ мал мисирлиқларға нисбәтән жиркиничликтур. Әнди әгәр биз мисирлиқларниң көз алдида яман көрүнгән нәрсини қурбанлиқ қилсақ улар бизни чалма-кесәк қиливәтмәмду?    ");
INSERT INTO uigcyr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Биз үч күнлүк йолни бесип, чөлдә Пәрвәрдигар Худайимиз бизгә буйруғинидәк униңға қурбанлиқ сунушимиз керәк, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Пирәвн: — Силәрни Пәрвәрдигар Худайиңларға чөлдә қурбанлиқ өткүзүшкә барғили қойимән; пәқәт бәк жирақ кетип қалмаңлар, мениң үчүн дуа қилиңлар, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Муса җавап берип: — Мана, мән сениң алдиңдин чиқип Пәрвәрдигарға илтиҗа қилимән вә көкүйүнләр сән Пирәвндин, әмәлдарлириңдин вә хәлқиңдин әтә чиқип кетиду; лекин Пирәвн йәнә һейлә ишлитип, хәлиқни Пәрвәрдигарға қурбанлиқ қилишқа бериштин тосқучи болмисун, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Муса Пирәвнниң алдидин чиқип, Пәрвәрдигарға шундақ илтиҗа қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Пәрвәрдигар Муса тилигинидәк қилди; у көкүйүнләрни Пирәвн, әмәлдарлири вә хәлқидин чиқиривәтти; һәтта бир тал көкүйүнму қалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Лекин Пирәвн бу қетимму көңлини қаттиқ қилип, қовмни қоюп бәрмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Андин Пәрвәрдигар Мусаға: — Пирәвнниң алдиға берип униңға: — «Ибранийларниң Худаси Пәрвәрдигар мундақ дәйду: — Маңа ибадәт қилишиға Өз қовмимни қоюп бәр. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Әгәр уларни қоюп беришни рәт қилип, йәнила тутуп турувалидиған болсаң, ");
INSERT INTO uigcyr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","мана, Пәрвәрдигарниң қоли етизлиқтики чарпайлириңниң үстигә, ат-ешәкләр, төгиләр, вә қой-калилириңниң үстигә чүшүп интайин еғир бир ваба кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Лекин Пәрвәрдигар Исраилниң чарпайлирини мисирлиқларниң чарпайлиридин пәриқләндүриду. Нәтиҗидә, Исраилниң чарпайлиридин һеч бири өлмәйду» — дегин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Пәрвәрдигар вақитни бекитип: — Әтә Пәрвәрдигар зиминда бу ишни қилиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Әтиси Пәрвәрдигар шундақ қилди; мисирлиқларниң барлиқ чарпайлири өлди; лекин Исраилларниң чарпайлиридин бириму өлмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Пирәвн адәм әвәтип тәкшүривиди, мана, Исраилларниң чарпайлиридин бириму өлмигән еди. Лекин Пирәвнниң көңли қаттиқ қилинип, у қовмни қоюп бәрмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Андин Пәрвәрдигар Муса вә Һарунға: — Хумданниң күлидин чаңгилиңларни тошқузуп елиңлар, андин Муса уни Пирәвнниң көз алдида асманға қаритип чачсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Шундақ қилиши билән күл пүткүл Мисир зиминини қаплайдиған чаң-тозан болиду вә Мисир зиминидики һәммә йәрдә адәмләр вә һайванларниң бәдинигә чүшүши билән һүррәк-һүррәк чақа чиқириду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Шуниң билән улар хумдандин күл елип, Пирәвнниң алдиға берип турди вә Муса уни асманға қаритип чачти; у адәмләр вә һайванларниң бәдинигә чүшүши билән һүррәк-һүррәк чақа чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Җадугәрләр чақилар дәстидин Мусаниң алдида туралмай қалди; чүнки җадугәрләрниң бәдининиму, башқа барлиқ мисирлиқларниму охшаш чақа бесип кәткән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Лекин Пәрвәрдигар Пирәвнниң көңлини қаттиқ қилди; шуңа Пәрвәрдигар дәл Мусаға ейтқинидәк у уларға қулақ салмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Андин Пәрвәрдигар Мусаға: — Әтә таң сәһәр қопуп, Пирәвнниң алдида туруп униңға: «Ибранийларниң Худаси Пәрвәрдигар мундақ дәйду: — Қовмимни Маңа ибадәт қилишқа қоюп бәр; ");
INSERT INTO uigcyr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","чүнки Мән бу қетим һәммә балаю-апәтлиримни жүригиңгә, әмәлдарлириң вә пухралириңниң үстигә әвәтимән. Буниң билән сән пүткүл йәр йүзидә Мәндәк башқа бириниң йоқ екәнлигини билисән. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Чүнки Мән қолумни узитип, өзүң вә қовмиңни ваба билән урған болсамиди, бу вақитқичә сән йәр йүзидин йоқилип кетәттиң. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Һалбуки, Мениң сени орнуңға тиклишимдики мәхситим шу едики, дәл Өз қудритимни саңа көрситиш, шундақла намимниң пүткүл йәр йүзидә җакалиниши үчүн еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Сән йәнә қовмимға чоңчилиқ қилип, уларни қоюп беришни рәт қиливерәмсән? ");
INSERT INTO uigcyr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Мана, әтә мошу вақитларда Мисир дөлити бена болғандин буян һеч көрүлүп бақмиған қаттиқ мөлдүрни яғдуримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Шуниң үчүн адәм әвәтип, һайван вә етизда бар-йоқуңни жиғип ичкири солиғин; чүнки өйгә қайтурулмай сиртта қалған адәм вә һайванларниң һәммиси мөлдүрниң астида қелип өлүп кетиду! — дегин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Буни аңлап Пирәвнниң әмәлдарлириниң арисидин Пәрвәрдигарниң сөзидин қорққан һәр бир адәм өз қуллири вә чарпайлирини жүгүртүп өйлиригә елип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Лекин Пәрвәрдигарниң сөзини етиварға алмиғанлар өз қул вә маллирини ташқирида қалдуруп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Пәрвәрдигар Мусаға: — Мисир зиминидики һәр йәрдә, адәмләр үстигә, малларниң үстигә, шундақла Мисир зиминидики далаларниң һәммә от-чөплириниң үстигә мөлдүр яғсун дәп, асманға қарап қолуңни көтәргин, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Муса шуниң билән һасисини асманға қаритип көтиривиди, Пәрвәрдигар гүлдүрмамини гүлдүрлитип, мөлдүр яғдурди, йәр йүзидә чақмақ чеқиндилири чепип жүрәтти. Шундақ қилип Пәрвәрдигар Мисир зимини үстигә мөлдүр яғдурди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Мөлдүр йеғип, мөлдүр билән от арилаш чүшти; мөлдүр шунчә еғир болдики, Мисир дөлити бена болғандин тартип ундақ қаттиқ мөлдүр йеғип бақмиған еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Мөлдүр пүткүл Мисир зимининиң һәр йеридә чүшүп, инсан болсун, һайван болсун, һәммисини урди; мөлдүр етиздики һәммә от-чөпни уруп, йәрдики һәммә дәл-дәрәқләрниму сундурувәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Пәқәт Исраиллар олтиришлиқ Гошән зиминидила мөлдүр яғмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Пирәвн адәм әвәтип Муса билән Һарунни чақиртип уларға: — Мән бу қетим гуна қилдим! Пәрвәрдигар һәққанийдур; Сәһвәнлик болса мән вә хәлқимдин өтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Йәнә берип Пәрвәрдигардин өтүнүп илтиҗа қилиңлар! Худадин чиққан бу қаттиқ гүлдүрмамилар вә мөлдүр йетип ашти! Силәрни қоюп берәй; силәр әнди мошу йәрдә туривәрсәңлар болмайду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Муса униңға җавап берип: — Мән шәһәрдин чиққанда, Пәрвәрдигар тәрәпкә қарап қоллиримни йейип көтиримән; гүлдүрмамилар шу һаман бесиқип мөлдүр йәнә яғмайду. Йәр йүзи Пәрвәрдигарниңкидур, дәп билишиң үчүн шундақ болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Лекин сән вә сениң әмәлдарлириң, силәрниң Пәрвәрдигар Худадин техичә қорқмайватқиниңларни билимән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Шу чағда арпа баш чиқирип, зиғир ғунчилиған болғачқа, зиғир вә арпа мөлдүрдин вәйран қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Лекин буғдай билән қара буғдай кейинрәк бих чиқарғачқа, вәйран қилинмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Муса Пирәвнниң алдидин кетип, шәһәрдин чиқип Пәрвәрдигар тәрәпкә қарап қоллирини йейип көтәрди. Шуниң билән гүлдүрмама вә мөлдүр тохтап, ямғур йәргә йәнә төкүлмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Амма Пирәвн ямғур, мөлдүр вә гүлдүрмамиларниң тохтиғинини көргәндә, йәнә гуна садир қилди; уму, әмәлдарлириму көңлини қаттиқ қилишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Бу тәриқидә Пирәвнниң көңли қаттиқ туруверип, Пәрвәрдигар Мусаниң вастиси билән ейтқандәк, Исраилларни қоюп беришни рәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Андин Пәрвәрдигар Мусаға: — Пирәвнниң алдиға барғин; чүнки уларниң арисида бу мөҗизилик аламәтләрни көрситишим үчүн Пирәвнниң көңлини вә әмәлдарлириниң көңлини қаттиқ қилип қойдум. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Бу иш билән Мениң мисирлиқларни қандақ рәсва қилғанлиғим вә уларниң арисида көрсәткән мөҗизилик аламәтлиримни сән оғлуңниң андин нәврәңниң қулиқиға йәткүзисән. Буниң билән Мениң Пәрвәрдигар екәнлигимни билисиләр, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Шуниң билән Муса билән Һарун Пирәвнниң алдиға берип, униңға: — Ибранийларниң Худаси Пәрвәрдигар мундақ дәйду: «Өзүңни алдимда төвән тутушни қачанғичә рәт қилисән? Маңа ибадәт қилиш үчүн қовмимни қоюп бәр. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Чүнки әгәр сән қовмимни қоюп беришни рәт қилсаң, мана, Мән әтә сениң жутуңға чекәткә әвәтимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Улар силәр зимин йүзини көрмигидәк қилип йепиветиду, силәрниң мөлдүрдин аман қалған нәрсилириңларниму, далаларда өскән һәммә дәл-дәрәқлириңларниму йәп кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Улар орда-сарайлириңға, әмәлдарлириңниң сарайлири, шундақла барлиқ мисирлиқларниң өйлиригә толуп кетиду; бундақ апәтни ата-боваңлириң вә ата-бовилириңниң ата-бовилириму йәр йүзидә апиридә болғандин тартип көрүп бақмиған» — деди-дә, бурулуп Пирәвнниң алдидин чиқип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Пирәвнниң әмәлдарлири униңға: — Бу адәм бизгә қачанғичә қапқан болар? Өз Худаси Пәрвәрдигарға ибадәт қилишқа бу адәмләрни қоюп бәргәйла! Мисирниң харап болғинини техичә көрмәйватамдила? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Шуниң билән Муса билән Һарун Пирәвнниң алдиға йәнә чақиритип келинди. У уларға: — Пәрвәрдигарға ибадәт қилиш үчүн бериңлар; лекин баридиғанлар зади кимләр? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Муса җавап берип: — Яшлиримиз вә қери-чүриләр билән, оғуллиримиз вә қизлиримиз билән, қой вә кала падилиримизни елип һәммимиз баримиз; чүнки биз Пәрвәрдигар үчүн һейт өткүзүшимиз керәк, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","У уларға: — Силәрни бала-җақаңлар билән қошуп қоюп бәргинимдә, Пәрвәрдигар силәр билән биллә болғай! Мана, алдиңларда балаю-апәт турупту! ");
INSERT INTO uigcyr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Йоқсу, бундақ қилишиңларға болмайду! Пәрвәрдигарға ибадәт қилишқа пәқәт араңлардин әр кишиләрла барсун! Чүнки силәрниң тәливиңлар дәл шу әмәсмиди! — деди-дә, улар Пирәвнниң алдидин қоғлап чиқирилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Андин Пәрвәрдигар Мусаға: — Мисир зимининиң үстигә қолуңни узатқин. Шундақ қилсаң, чекәткиләр Мисир зиминини бесип, зиминдики һәр хил отяшларни, йәни мөлдүрдин аман қалғанниң һәммисини йәп кетиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Муса һасисини Мисир зимининиң үстигә узатти; Пәрвәрдигар шу күни вә кечиси зимин үстигә шәриқ шамили чиқарди. Сәһәрдә, шәриқ шамили чекәткиләрни учуруп кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Чекәткиләр Мисирниң пүткүл зиминиға йейилип, Мисирниң пүтүн чегарисиниму басти. Апәт интайин еғир болди; илгири бундақ чекәткә апити болуп бақмиған, мундин кейинму униңдәк болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Улар пүткүл зиминниң йүзини қаплиди, йәр қараңғулишип кәтти; улар мөлдүрдин аман қалған зиминдики һәммә отяшларни вә дәл-дәрәқләрниң барлиқ мевилирини йәп кәтти. Шуниң билән пүткүл Мисир зимини тәвәсидики дәл-дәрәқләрдә яки даладики гүл-гияларда һеч йешиллиқ қалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Андин Пирәвн алдирап-тенәп Муса билән Һарунни чақиртип уларға: — Мән һәм Худайиңлар Пәрвәрдигар алдида һәм силәрниң алдиңларда гуна қилдим. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Әнди мошу бир қетим гунайимдин өтүп Пәрвәрдигар Худайиңлардин бу өлүмни мәндин елип кетишини илтиҗа қилишиңларни өтүнимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Шуниң билән Муса Пирәвнниң алдидин чиқип Пәрвәрдигарға илтиҗа қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Шуниң билән Пәрвәрдигар шамални бурап ғәрип тәрәптин интайин күчлүк боран чиқирип, чекәткиләрни учуруп, Қизил Деңизға ғәриқ қилди; Мисирниң пүткүл тәвәсидә бир талму чекәткә қалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Лекин Пәрвәрдигар Пирәвнниң көңлини қаттиқ қилип қойғини үчүн у Исраилларни қоюп бәрмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Андин Пәрвәрдигар Мусаға: — Қолуңни асманға қаритип узатқин; шуниң билән қаттиқ бир қараңғулуқ болиду, һәтта адәм силиса қолиға туюлғидәк қоюқ қараңғулуқ Мисир зиминини қаплайду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Андин Муса қолини асманға қаритип узитивиди, қоюқ бир қараңғулуқ Мисир зиминини үч күнгичә қаплап турди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Үч күнгичә бири йәнә бирини көрәлмәс вә я һеч ким өз җайидин қозғилалмас болди; лекин барлиқ Исраиллар олтарған җайларда йоруқлуқ бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Пирәвн Мусани чақиртип униңға: — Берип, Пәрвәрдигарға ибадәт қилиңлар. Пәқәт қой вә кала падилириңлар қалсун; бала-җақилириңларниму елип барсаңлар болиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Муса җававән: — Ундақта Худайимиз Пәрвәрдигарға қурбанлиқ қилишқа инақлиқ қурбанлиғи вә көйдүрмә қурбанлиғиға лазимлиқ чарпайларни сән бизгә берәмсән? ");
INSERT INTO uigcyr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Өзимизниң чарпайлиримиз биз билән биргә кетиши керәк, бир туйиғиму кәйнидә қалса болмайду; чүнки Худайимиз Пәрвәрдигарға ибадәт қилишқа қурбанлиқ қилидиғинимизни булардин таллишимиз лазим. У йәргә йетип бармиғичә, Пәрвәрдигарға қайси қурбанлиқлар билән ибадәт қилидиғинимизни билмәймиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Лекин Пәрвәрдигар Пирәвнниң көңлини қаттиқ қилди; у уларни йәнила қоюп бәрмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Пирәвн Мусаға: — Алдимдин йоқал! Һези бол, иккинчи маңа көрүнгүчи болма! Чүнки йүзүмни йәнә көргән күнүң җениңдин айрилисән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Муса униңға: — Раст ейттиң! Мән сениң йүзүңни иккинчи көргүчи болмаймән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Шуниң билән Пәрвәрдигар Мусаға: — Йәнә бир апәтни Пирәвнниң үстигә вә Мисирниң үстигә чүшүримән. Андин у силәрни бу йәрдин кетишкә йол қойиду вә у силәрни һәммә нәрсилириңлар билән қошуп қоюп берип, бу йәрдин мутләқ қоғлап чиқириду. ");
INSERT INTO uigcyr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Әнди сән хәлиққә тапилап: — Һәр бириңлар, әр кишиләрниң һәр бири өз хошнисидин, аял кишиләрниң һәр бири өз хошнисидин күмүч буюмларни, алтун буюмларни сорап алсун, дегин, — деди    ");
INSERT INTO uigcyr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Пәрвәрдигар хәлқини мисирлиқларниң алдида илтипат тапқузди. Шуниңдәк Муса дегән бу адәм Мисир зиминида Пирәвнниң әмәлдарлириниң нәзиридә болсун, пухраларниң нәзиридә болсун, наһайити улуқ зат болди). ");
INSERT INTO uigcyr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Андин Муса йәнә: — Пәрвәрдигар мундақ дәйду: — «Мән йерим кечидә чиқип Мисирни кезип чиқимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Шу вақитта тәхттә олтириватқан Пирәвнниң тунҗа оғлидин тартип ярғунчақ тартидиған дедәкниң тунҗа оғлиғичә, шундақла барлиқ чарпайларниң тунҗилири, йәни Мисирдики барлиқ тунҗа җан егилири өлиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Бу сәвәптин пүткүл Мисир зиминида қаттиқ бир пәряд көтирилиду; униңдин илгири шундақ пәряд болуп бақмиған еди, мундин кейинму бундақ пәряд аңланмайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Лекин Исраилларға, мәйли адәмлири, мәйли һайванатлириға болсун, һәтта бир тал иштму қавап қоймайду. Буниңдин Пәрвәрдигарниң мисирлиқлар билән Исраилни пәриқләндүридиғанлиғини билисиләр». ");
INSERT INTO uigcyr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","— Шуниң билән бу әмәлдарлириңниң һәммиси алдимға келип, маңа тазим қилип: «Сили өзлири вә силигә әгәшкән барлиқ қовмлири чиқип кетишкәйла!» дәп ейтиду, андин чиқип кетимән» — деди-дә, қаттиқ ғәзәп билән Пирәвнниң алдидин чиқип кәтти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Пәрвәрдигар Мусаға: — Мисир зиминида Мениң карамәт мөҗизилиримниң көпләп көрситилиши үчүн Пирәвн силәргә қулақ салмайду, — дегән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Муса билән Һарун бу карамәт мөҗизиләрниң һәммисини Пирәвнниң алдида көрситип болди; лекин Пәрвәрдигар Пирәвнниң көңлини қаттиқ қилип қойғини үчүн у Исраилларни униң зиминидин кәткили қоймиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Пәрвәрдигар Мисир жутида Муса вә Һарунға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Бу ай силәргә айларниң ичидә беши, жилниң тунҗа ейи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Силәр пүтүн Исраил җамаитигә сөз қилип: — Бу айниң онинчи күни һәммиңлар атилириңларниң аилиси бойичә бир қозини елиңлар; һәр бир аилигә бирдин қоза елиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Әгәр мәлум бир аилә бир қозини йәп болалмиғидәк болса, ундақта өй егиси йенидики хошниси билән бирлишип адәм саниға қарап бир қоза елиңлар; һәр бир кишиниң иштиһасиға қарап һесаплап мувапиқ бир қоза һазирлаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Һәр бириңлар таллайдиған қозаңлар беҗирим, бир яшлиқ әркәк болсун; қой яки өшкә падилиридин таллансиму болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Қозини бу айниң он төртинчи күнигичә йениңларда турғузуңлар, — дегин. — Шу күни Исраилниң пүткүл җамаити таллиған мелини гугумда сойсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Андин улар униң қенидин елип гөш йейилгән өйниң ишикниң баш тәрипигә һәм икки ян кешикигә сүркәп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Улар шу кечиси гөшини отта кавап қилип йесун; уни петир нан вә аччиқ-чүчүк көктат билән қошуп йесун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Қәтъий хам яки суда пиширип йемәңлар, бәлки уни баш, пут вә ич-қаринлири билән отта кавап қилип йәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Униң һеч немисини әтигә қалдурмаңлар. Әгәр әтигә ешип қалғанлири болса, уни отқа селип көйдүрүветиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Силәр уни мундақ һаләттә йәңлар: — Уни йегәндә бәллириңларни чиң бағлап, аяқлириңларға кәш кийип, қоллириңларда һаса тутқан һалда тез йәңлар. У болса Пәрвәрдигарниң «өтүп кетиш» қозисидур. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Чүнки Мән у кечиси Мисир зиминини кезип өтимән; Мән Мисир зиминида мәйли инсан болсун, мәйли һайван болсун уларниң тунҗа туғулған әркикиниң һәммисини өлтүримән; шуниң билән Мән Мисирниң барлиқ бут-илаһлириниң үстидин һөкүм чиқиримән; Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Шу қурбанлиқниң қени силәр олтарған өйләрдә силәргә ниҗат бәлгүси болиду; бу қанларни көргинимдә силәргә өтүп туримән. Шуниң билән Мисир зиминини урғинимда һалакәт елип келидиған ваба-апәт силәргә тәгмәйду. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Бу күн силәргә хатирә күн болсун; уни Пәрвәрдигарниң һейти сүпитидә өткүзүп тәбрикләңлар; әбәдий бәлгүлимә сүпитидә нәсилдин-нәсилгә мәңгү өткүзүңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Йәттә күн петир нан йәңлар; биринчи күни өйүңлардин барлиқ хемиртуручларни йоқ қилиңлар; чүнки кимки биринчи күндин тартип йәттинчи күнгичә болдурулған нан йесә, шу киши Исраил қатаридин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Биринчи күни силәр муқәддәс ибадәт соруни түзүңлар; йәттинчи күниму һәм шундақ бир муқәддәс ибадәт соруни өткүзүлсун. Бу икки күн ичидә һеч қандақ иш-әмгәк қилинмисун; пәқәт һәр кишиниң йәйдиғинини тәйярлашқа мунасивәтлик ишларнила қилсаңлар болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Мән дәл шу күни силәрни қошун-қошун бойичә Мисир зиминидин чиқарғиним үчүн силәр петир нан һейтини өткүзүңлар; шу күнни нәсилдин-нәсилгә әбәдий бәлгүлимә сүпитидә һейт күни қилип бекитиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Биринчи айниң он төртинчи күни, кәчқурундин тартип шу айниң жигирмә биринчи күни кәчқурунғичә, петир нан йәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Йәттә күн ичидә өйлириңларда һеч хемиртуруч болмисун; чүнки мусапир болсун, зиминда туғулған болсун, кимки болдурулған нәрсиләрни йесә шу киши Исраил җамаитидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Силәр һеч қандақ болдурулған нәрсини йемәй, қәйәрдила турсаңлар, петир нан йәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Муса Исраилниң барлиқ ақсақаллирини чақирип уларға: — Берип һәр бириңларниң аилиси бойичә өзүңларға бир қозини тартип чиқирип пасха қозисини союңлар.    ");
INSERT INTO uigcyr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Андин бир тутам зупа елип уни қачидики қанға чилап, қачидики қанни ишикниң беши вә икки кешикигә сүркәңлар. Силәрдин әтигәнгичә һеч ким өйиниң ишигидин қәтъий чиқмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Чүнки Пәрвәрдигар мисирлиқларни уруп һалак қилиш үчүн, зиминни кезип өтиду; У ишикниң беши вә икки кешикидики қанни көргәндә, Пәрвәрдигар һалак қилғучиниң өйлириңларға кирип силәрни урушидин тосуш үчүн муһапизәт қилип ишикниң алдиға өтүп туриду.    ");
INSERT INTO uigcyr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Бу рәсим-қаидини өзүңлар вә балилириңлар үчүн әбәдий бир бәлгүлимә сүпитидә тутуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Силәр Пәрвәрдигар Өз вәдиси бойичә силәргә беридиған зиминға киргиниңларда бу һейтлиқ ибадәтни тутуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Балилириңлар силәрдин: «бу ибадитиңларниң мәнаси немә?» — дәп сориса, ");
INSERT INTO uigcyr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","силәр: «Бу мисирлиқларни урғинида, Мисирда Исраилларниң өйлириниң алдиға өтүп туруп, бизниң өйдикилиримизни қутқузған Пәрвәрдигарға болған «өтүп кетиш» қурбанлиғи болиду» — дәңлар. Шуни аңлиғанда, хәлиқ еңишип Худаға сәҗдә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Андин Исраиллар қайтип берип, Пәрвәрдигар дәл Муса билән Һарунға әмир қилғандәк иш көрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Вә шундақ болдики, йерим кечә болғанда, Пәрвәрдигар Пирәвнниң тәхтидә олтириватқан тунҗисидин тартип зинданда йетиватқан мәһбусниң тунҗисиғичә, Мисир зиминидики тунҗа оғулларниң һәммисини уруп өлтүрди, шундақла у һайванатларниң тунҗа туғулғанлириниңму һәммисини өлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Адәм өлмигән бирму өй қалмиғачқа, шу кечиси Пирәвнниң өзи, униң барлиқ әмәлдарлири вә барлиқ мисирлиқлар кечидә орнидин қопти; Мисир зиминида интайин қаттиқ пәряд көтирилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Пирәвн кечидә Муса билән Һарунни чақиртип: — Туруңлар, силәр вә Исраиллар билән биллә мениң хәлқимниң арисидин чиқип кетиңлар; ейтқиниңлардәк берип, Пәрвәрдигарға ибадәт қилиңлар! ");
INSERT INTO uigcyr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Силәрниң дегиниңлар бойичә қой, өчкә, кала падилириниму елип кетиңлар; мән үчүнму бәхит-бәрикәт тиләңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Мисирлиқ пухраларму «һәммимиз өлүп кәткидәкмиз» дейишип, хәлиқни зиминдин тез чиқириветиш үчүн уларни кетишкә алдиратти. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Хәлиқ техи болмиған хемирлирини елип, уни тәңниләргә селип, кийим-кечәклири билән йөгәп, мүрилиригә елип көтирип меңишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Исраиллар Мусаниң тапилиғини бойичә қилип, мисирлиқлардин күмүч буюмлар, алтун буюмлар вә кийим-кечәкләрни сорап елишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Пәрвәрдигар хәлиқни мисирлиқларниң көз алдида илтипат тапқузғини үчүн мисирлиқлар уларниң өзлиридин сориғанлирини бәрди; шундақ қилип Исраиллар мисирлиқлардин ғәниймәтләрни елип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Шуниң билән Исраиллар балиларни һесапқа алмиғанда алтә йүз миңчә әркәк болуп, Рамсәстин чиқип, Суккот шәһиригичә пиядә маңди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Улар билән биллә чоң бир топ шалғут хәлиқму уларға қошулуп маңди, йәнә нурғун чарвилар, көплигән кала-қой падилири билән биллә чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Мисирдин алғач чиққан хемирдин улар петир нан-тоғачларни әтти; чүнки улар Мисирда бирдәм-йерим дәм турғузулмай һайдалғини үчүн хемир болмиған еди; улар өзлири үчүн йемәклик тәйярливелишқиму үлгүрәлмигән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Исраилларниң Мисирда мусапир болуп турған вақти җәмий төрт йүз оттуз жил болди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Шундақ болдики, шу төрт йүз оттуз жил тошқанда, дәл шу күнидә Пәрвәрдигарниң барлиқ қошунлири Мисир зиминидин чиқип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Шу күни кечидә улар Мисир зиминидин чиқирилғини үчүн, шу кечини улар Пәрвәрдигарниң кечиси дәп тутуши керәк; шу кечини барлиқ Исраиллар әвлаттин әвлатқичә Пәрвәрдигарға атап тутуп, түниши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Пәрвәрдигар Муса билән Һарунға мундақ дегән еди: — Пасха қозиси тоғрисидики бәлгүлимә шу болсунки: — Һеч қандақ ят әллик адәм униңдин йемисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Лекин һәр кимниң пулға сетивалған қули болса, у хәтнә қилинсун, андин униңдин йесун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Амма өйүңларда вақитлиқ туруватқан мусапир яки мәдикар буниңдин йесә болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Гөшни башқа бир өйгә елип чиқмиғин; бирла өйдә йейилсун; қозиниң һеч бир сүйиги сундурулмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Пүткүл Исраил җамаити бу һейтни өткүзсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Әгәр сениң билән биргә турған мусапир болса, Пәрвәрдигарға атап пасха һейтини өткүзмәкчи болса, ундақта алди билән барлиқ әркәклири хәтнә қилинсун; андин келип һейт өткүзсун. У зиминда туғулған кишидәк саналсун. Лекин һеч бир хәтнисиз адәм униңдин йемисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Зиминда туғулған киши һәм араңларда турған мусапир үчүн охшаш қанун-бәлгүлимә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Шуниң билән Исраилларниң һәммиси дәл Пәрвәрдигар Муса билән Һарунға буйруғандәк шу ишларни ада қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Шу күнниң өзидә Пәрвәрдигар Исраилларни қошун-қошун бойичә Мисир зиминидин чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Пәрвәрдигар Мусаға: ");
INSERT INTO uigcyr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","— Исраиллар арисида балиятқуниң барлиқ тунҗа әркәк мевисини, мәйли у инсанниң яки һайванниң болсун, Маңа атап муқәддәс қилғин; у Маңа мәнсуптур, дегән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Муса хәлиқкә мундақ деди: — Силәр Мисирдин ибарәт «қуллуқ макани»дин чиққан бу күнни яд етиңлар; чүнки Пәрвәрдигар силәрни бу йәрдин қудрәтлик қоли билән чиқарди. Буниң үчүн һеч болдурулған нәрсә йейилмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Абиб ейиниң бүгүнки күни йолға чиққан күн.    ");
INSERT INTO uigcyr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Әнди Пәрвәрдигар саңа беришкә ата-бовилириңға қәсәм қилған, сүт билән һәсәл еқип туридиған зиминға, йәни Ⱪананий, Һиттий, Аморий, Һивий вә Йәбусийларниң зиминиға сени елип барғинида мошу Абиб ейида шу ибадәтни тутқин. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Йәттә күнгичә петир нан йәңлар; йәттинчи күнидә Пәрвәрдигарға алаһидә атиған һейт өткүзүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Йәттә күн ичидә петир нан йейилсун; силәрниң араңларда һеч қандақ болдурулған нан тепилмисун вә я чегарилириң ичидә һеч хемиртуручму көрүнмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Шу күни сән өз оғлуңға: «Мисирдин чиққинимда Пәрвәрдигарниң маңа көрсәткән илтипатини яд қилип тәшәккүр билдүрүш үчүн, бу һейтни өткүзимән», дәп чүшәндүргин. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Пәрвәрдигарниң қанун-тәлиминиң һемишә ағзиңдин чүшмәслиги үчүн, бу бәлгүлимини қолуңға бәлгү қилип селивал, пешанәңгә қашқидәк әсләтмә қилип орнитивал; чүнки Пәрвәрдигар сени қудрәтлик қоли билән Мисирдин чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Әнди бу бәлгүлимини жилму-жил бекитилгән вақтида тутқин. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Пәрвәрдигар сән билән ата-бовилириңға қилған қәсими бойичә сени Ⱪананийларниң зиминиға елип берип, уни саңа тәқдим қилғандин кейин, шундақ қилишиң керәк: — ");
INSERT INTO uigcyr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","барлиқ балиятқуниң тунҗа мевисини Пәрвәрдигарға атап сунисән; шундақла чарпай мелиңниң һәммә тунҗа әркәклириму Пәрвәрдигарға мәнсуп болсун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Амма ешәкләрниң һәммә тунҗилириниң орниға бирдин қоза бәргин. Әгәр униң орниға бир нәрсә бәрмисәң, униң бойнини сундурувәткин. Оғуллириңлар арисида барлиқ тунҗилириниң орниға һөрлүк бәдили төлүшүң керәк. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Кейинки күнләрдә оғлуң сәндин: «буниң мәнаси немидур», дәп сориса, сән униңға җавап берип: «Пәрвәрдигар қудрәтлик қоли билән бизни Мисирдин чиқирип, «қуллуқ макани»дин азат қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Шундақ болдики, Пирәвн бойни қаттиқлиқ қилип бизни қоюп беришни рәт қилғинида, Пәрвәрдигар Мисир зиминидики барлиқ тунҗа туғулғанларни, инсанниң болсун, малниң болсун, һәммисини уруп өлтүрди; буниң үчүн мән малниң балиятқусиниң тунҗа мевисини, йәни һәммә тунҗа туғулған әркәклирини Пәрвәрдигарға атап қурбанлиқ қилип сунимән вә оғуллиримниң һәр бир тунҗилири үчүн һөрлүк бәдили төләп беримән», дәп ейтқин. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Бу бәлгүлимини қолуңға әсләтмә-бәлгә қилип селивал, пешанәңгә қашқидәк әсләтмә қилип орнитивал, чүнки Пәрвәрдигар қудрәтлик қоли билән бизни Мисирдин чиқарди» — дегин. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Амма Пирәвн хәлиқни кетишкә қойғандин кейин, Филистийләрниң зиминидики йол йеқин болсиму, Худа уларни шу йол билән башлимиди; чүнки у: «хәлқим җәңгә учрап қалса, қорқуп пушайман қилип, Мисирға йенип кетиши мүмкин» дәп ойлиған еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Шу сәвәптин Худа хәлиқни айландуруп, Қизил Деңиз тәрәптики чөлниң йоли билән башлап маңди. Шундақ қилип Исраиллар Мисирдин чиққинида, қураллинип җәңгә тәйяр болуп тәртип билән маңди. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Муса Йүсүпниң сүйәклириниму биллә еливалди; чүнки Йүсүп әслидә Исраилниң оғуллири болған қериндашлирини: «Худа чоқум силәрни йоқлап һалиңлардин хәвәр алиду; шу чағда силәр мениң сүйәклиримни мошу йәрдин биллә елип кетиңлар» дәп қәсәм қилдурған еди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Андин улар Суккоттин чиқип, чөлниң четидики Етам дегән йәрдә чедирлирини тикти. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Әнди Пәрвәрдигар уларға йол көрситишкә күндүзи бир булут түврүгидә, кечиси йоруқлуқ беришкә от түврүгидә болуп уларниң алдида жүрәтти. Шуниң билән улар кечә-күндүз йол жүрәләйтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Булут түврүги күндүзи, от түврүги кечиси хәлиқтин айрилмай, алдида жүрәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Пәрвәрдигар Мусаға: ");
INSERT INTO uigcyr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","— Сән Исраилларға: «Силәр бурулуп Мигдол билән деңизниң арилиғидики Пи-Һаһиротниң алдиға берип чедир тикиңлар; Баал-Зефонниң удулидики деңизниң бойида чедир тикиңлар», дегин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Шуниң билән Пирәвн: «Исраиллар зиминда езип қалди, чөлниң ичидә қамилип қалди» дәп ойлайду; ");
INSERT INTO uigcyr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Исраилларни қоғлисун дәп Мән Пирәвнниң көңлини қаттиқ қилимән; шундақ қилип, Мән Пирәвн вә униң пүткүл қошунлири арқилиқ Өз улуқлуғумни аян қилимән; вә мисирлиқлар Мениң Пәрвәрдигар екәнлигимни билиду, — деди. Исраиллар Худаниң сөзи бойичә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","«У хәлиқ қечип кәтти» дәп Мисирниң падишасиға хәвәр бериливиди, Пирәвн билән әмәлдарлири хәлиқ тоғрисидики қараридин йенип: «Исраилларни қуллуқтин қоювәткинимиз, бу зади немә қилғинимиз?!» — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Пирәвн дәрһал җәң һарвусини қоштуруп, өз хәлқини башлап йолға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","У йәнә алтә йүз хилланған җәң һарвуси, шундақла Мисирдики барлиқ җәң һарвулирини жиғдуруп, уларниң һәр биригә ләшкәр башлиқлирини олтарғузуп елип маңди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Пәрвәрдигар Мисирниң падишаси Пирәвнниң көңлини қаттиқ қилғини үчүн, у Исраилларни қоғлиди. Бу чағда Исраиллар қоллирини егиз көтиришкән һалда Мисирдин чиқип болған еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Мисирлиқларниң һәммиси йәни Пирәвнниң барлиқ атлири билән җәң һарвулири, атлиқ ләшкәрлири билән пүткүл қошуни уларни қоғлап, Исраиллар деңиз бойиға чедир тиккән җайда, йәни Пи-Һаһиротниң йенида, Баал-Зефонниң удулида уларға йетишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Пирәвн йеқинлашқанда, Исраиллар бешини көтирип қаривиди, мана, мисирлиқлар уларниң арқисидин жүрүш қилип қоғлап келивататти! Шуни көргәндә Исраиллар толиму қорқушуп, Пәрвәрдигарға нида-пәряд көтәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Улар Мусаға: — Мисирда гөристан тепилмасмиди, сән бизни чөлдә өлсун дәп мошу йәргә елип кәлдиңғу?! Бизни Мисирдин елип чиқип, бизгә мундақ қилғиниң немиси?! ");
INSERT INTO uigcyr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Мисирда турған вақтимизда биз саңа: «Бизни мисирлиқларниң қуллуғида болушимизға қойғин, биз билән кариң болмисун» дәп ейтмиғанмидуқ? Мисирлиқларниң қуллуғида болғинимиз чөлгә келип өлгинимиздин әвзәл болатти! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Буниң билән Муса хәлиққә: — Қорқмай, тик туруңлар, Пәрвәрдигарниң бүгүн силәргә жүргүзидиған ниҗатини көрисиләр; чүнки силәр бүгүн көргән мисирлиқларни иккинчи көрмәйсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Пәрвәрдигар силәр үчүн җәң қилиду, лекин силәр болсаңлар җим турсаңларла болди, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Андин Пәрвәрдигар Мусаға: — Немишкә сән Маңа пәряд көтирисән? Исраилларға: «Алдиға меңиңлар» дәп буйруғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Лекин сән һасаңни көтирип қолуңни деңизға узитип, уни иккигә бөлгин; шундақта, Исраиллар деңизниң оттурисидин қуруқ йәр билән өтүп кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Мана, Мән уларни қоғлисун дәп мисирлиқларниң көңүллирини қаттиқ қилимән, шуниң билән Мән Пирәвн вә униң пүткүл қошуни, җәң һарвулири вә атлиқлири арқилиқ Өз улуқлуғимни аян қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Шундақ қилип, Мән Пирәвн вә униң җәң һарвулири вә атлиқлири арқилиқ Өз улуқлуғимни аян қилғинимда, мисирлиқлар Мениң Пәрвәрдигар екәнлигимни билиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Исраилниң қошуниниң алдида жүрүватқан Худаниң Пәриштиси әнди уларниң кәйнигә өтти; шуниңдәк уларниң алдида маңған булут түврүгиму уларниң кәйнигә йөткилип, ");
INSERT INTO uigcyr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","мисирлиқларниң чедиргаһи билән Исраилниң чедиргаһиниң арилиғида тохтиди; бу булут бир тәрәптә қараңғулуқ чүшүрүп, йәнә бир тәрәптә кечини йорутти. Буниң билән пүтүн бир кечә бир қошун йәнә бир қошунға йеқин келәлмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Муса қолини деңизниң үстигә узатти; Пәрвәрдигар пүтүн кечә шәриқтин күчлүк бир шамал чиқирип, деңизниң сүйини кәйнигә яндурди; У суни яндуруп деңизни қуруқ йәр қилди, сулар иккигә бөлүнди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Шу тәриқидә Исраиллар деңизниң оттурисидики қуруқ йәрдин меңип, өтүп кәтти; сулар болса уларниң оң вә сол йенида көтирилип тамдәк туратти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Амма мисирлиқлар уларни қоғлап келивататти — Пирәвнниң барлиқ атлири, җәң һарвулири вә атлиқ ләшкәрлири уларниң кәйнидин деңизниң оттурисиғичә кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Таң атқанда шундақ болдики, Пәрвәрдигар от билән булут түврүгидә туруп мисирлиқларниң қошуниға қариди вә мисирлиқларниң қошуниға паракәндичилик чүшүрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","У уларниң һарвулириниң чақлирини патқузуп, һайдап меңишини мүшкүл қилди. Мисирлиқлар: — Жүрүңлар, Исраилниң алдидин қачайли, чүнки Пәрвәрдигар улар үчүн мисирлиқларға қарши җәң қиливатиду, — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Пәрвәрдигар Мусаға: — Сулар йенип мисирлиқларниң үстигә, уларниң җәң һарвулириниң үстигә вә атлиқлириниң үстигә еқип берип, уларни чөктүрүвәтсун дәп қолуңни деңизниң үстигә узатқин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Муса қолини деңизниң үстигә узитивиди, таң атқанда деңизниң сүйи йәнә әслий һалитигә йенип кәлди. Қечиватқан мисирлиқлар еқинға қарши жүгүрүшти, Пәрвәрдигар уларни деңизниң оттурисида моллақ атқузди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Су әслигә йенип келип, җәң һарвулири билән атлиқларни, йәни Исраилларниң арқидин қоғлап деңизға киргән Пирәвнниң пүткүл қошунини ғәриқ қиливәтти; улардин бириму сақ қалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Лекин Исраиллар деңизниң оттурисидики қуруқ йәр билән меңип өтүп кәтти; сулар уларниң оң вә сол йенида көтирилип тамдәк туратти. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Шу тәриқидә Пәрвәрдигар у күни Исраилларни мисирлиқларниң қолидин қутқузди; Исраиллар мисирлиқларниң деңизниң бойида өлүк ятқинини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Исраил хәлқи Пәрвәрдигарниң мисирлиқларға ишләткән зор қудритини көрүп, Пәрвәрдигардин қорқти; улар Пәрвәрдигарға вә униң қули Мусаға ишәнди. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Шу чағда Муса билән Исраиллар Пәрвәрдигарға мәдһийә оқуп муну күйни ейтти: — «Мән Пәрвәрдигарни мәдһийиләп күй ейтай, Чүнки У карамәт улуқлуғини көрсәтти; У ат вә мингүчини деңизға ташливәтти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Мениң күчүм һәм мениң күйүм Яһ Өзидур; У маңа ниҗат болди; У мениң Тәңримдур, мән Уни улуқлаймән; У мениң атамниң Худасидур, мән Уни алий дәп мәдһийиләймән.    ");
INSERT INTO uigcyr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Пәрвәрдигар җәңчидур, Яһвәһ Униң намидур. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Пирәвнниң җәң һарвулирини һәм қошунлирини деңизға ташливәтти; Униң алий ләшкәр башлиқлири Қизил Деңизда ғәриқ қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Чоңқур сулар уларни көмүвәтти, Улар худди таштәк деңиз тегигә чөкүп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Сениң оң қолуң, әй Пәрвәрдигар, Қудрити билән шан-шәрәп тапти; Сениң оң қолуң, әй Пәрвәрдигар, Дүшмәнни кукум-талқан қиливәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Өз улуқлуғуңниң һәйвиси билән Өзүңгә қарши чиққанларни набут қилдиң, Сән отлуқ ғәзивиңни әвәттиң, У саманни көйдүргән оттәк уларни жутувәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Димиғиңниң нәпәси билән сулар дөң болуп өрлиди, Җушқунлиған долқунлар дөң кәби тик турди, Деңизниң оттурисидики чоңқур сулар қатуруп қоюлди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Дүшмән деди: «Мән уларни қоғлаймән, йетишимән, олҗа елип үләштүримән, Улардин дәрдимни чиқиримән, Қиличимни суғуруп, өз қолум билән уларни набут қилимән». ");
INSERT INTO uigcyr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Лекин Сән нәпәсиң билән пүвлидиң, Деңиз уларни көмүвәтти; Улар җушқунлуқ суларда қоғушундәк чөкүп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Илаһларниң арисида, әй Пәрвәрдигар, Ким Сениң тәңдишиң болсун? Пак-муқәддәслик ичидә Өз һәйвитиңни көрситидиған, Һәмд-мәдһийиләр арисида дәһшәтлик туридиған, Мөҗизә-карамәт яритидиған, Сәндәк ким болсун? ");
INSERT INTO uigcyr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Сән оң қолуңни узитишиң билән, Йәр-зимин уларни жутувәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Лекин Өзүңгә һәмҗәмәт қилип қутқузған қовмни рәһимдиллиғиң билән башлап чиқтиң; Сән уларни Өз муқәддәс маканиңға қудритиң билән һидайәт қилип йетәклидиң. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ят хәлиқләр буни аңлап, титришип кәтти; Филистийәдә туруватқанларни толғақтәк азап тутти. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Андин Едомниң әмирлири дәккә-дүккигә чүшти; Моабниң палванлирини болса, раса титрәк басти; Қанаан зиминидикиләрниң жүриги су болуп ақти; ");
INSERT INTO uigcyr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Қорқунуч вә дәһшәт уларни басти; Билигиңниң һәйвити билән улар худди таштәк мидирлалмай қалди; Хәлқиң өтүп кәткичә, и Пәрвәрдигар, Өзүң рәнә төләп һөр қилған хәлқиң өтүп болғичә.    ");
INSERT INTO uigcyr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Уларни башлап кирип, Өз мирасиң болған тағда көчәттәк тикисән, Өз маканиң қилған җайға, и Пәрвәрдигар, Өз қоллириң тәйярлиған муқәддәс җайға, и Рәб, уларни елип барисән. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Пәрвәрдигар әбәдил-әбәткичә падиша болуп һөкүм сүриду! ");
INSERT INTO uigcyr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Чүнки Пирәвнниң атлири, Җәң һарвулири атлиқлири билән биллә деңизға кирип болди; Пәрвәрдигар деңизниң сулирини уларниң үстигә яндурди, Лекин Исраиллар болса деңизниң оттурисидин қуруқ йәрдин меңип өтүп кәтти». ");
INSERT INTO uigcyr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Андин Һарунниң һәдиси пәйғәмбәр Мәрйәм қолиға дапни алди, барлиқ қиз-аялларму қолиға дап елип, уссул ойнишип униңға әгәшти. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Мәрйәм уларға җававән мундақ күйни оқуди: — «Пәрвәрдигарни мәдһийиләп күй ейтиңлар, Чүнки У зор улуқлуғини көрсәтти; У ат вә мингүчини деңизға ташливәтти!». ");
INSERT INTO uigcyr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Андин Муса Исраилларни Қизил Деңиздин башлап, Шур чөлигә елип барди. Улар уда үч күн чөлдә жүрүп, су тапалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Андин улар Мараһқа йетип кәлди; лекин у йәрниң сүйи аччиқ болуп, сүйини ичкили болмайтти; шуңа у җайниң нами «Мараһ» дәп қоюлған.    ");
INSERT INTO uigcyr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","У вақитта халайиқ: — Биз немә ичимиз? — дәп Мусадин ағринип ғотулдашқили турди. ");
INSERT INTO uigcyr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","У Пәрвәрдигарға пәряд көтәрди; Пәрвәрдигар униңға бир дәрәқни көрсәтти; у дәрәқ яғичини елип, суға ташливиди, су татлиқ суға айланди. У йәрдә Пәрвәрдигар уларға һөкүм-бәлгүлимә бекитип, уларни синап, мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","«Әгәр силәр көңүл қоюп Худайиңлар Пәрвәрдигарниң сөзини аңлап, Униң нәзиридә дурус болғанни қилип, әмирлиригә қулақ селип, барлиқ һөкүмлирини тутсаңлар, ундақта, Мән мисирлиқларниң үстигә салған кесәлләрдин һеч бирини үстүңгә салмаймән; чүнки Мәнки силәргә шипалиқ бәргүчи Пәрвәрдигардурмән». ");
INSERT INTO uigcyr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Андин улар Елимға йетип кәлди. Шу йәрдә он икки булақ билән йәтмиш хорма дәриғи бар еди; улар шу йәрдә суларниң бойида чедир тикти. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Андин Исраилларниң пүткүл җамаити Елимдин йолға атланди; Мисир зиминидин чиқип, иккинчи ейиниң он бәшинчи күнидә Елим билән Синайниң оттурисидики Син чөлигә йетип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Амма Исраилларниң пүткүл җамаити чөлдә Муса билән Һарунниң яман гепини қилип ғотулдашқили турди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Исраиллар уларға: — Пәрвәрдигарниң қоли бизни Мисир жутидила өлтүрүвәткән болса болмасмиди! Шу йәрдә биз гөш қайнаватқан қазанларни чөридәп олтирип, тойғидәк нан йемигәнмидуқ? Лекин силәр бу җамаәтниң һәммисини ачлиқ билән өлтүрмәкчи болуп бизни бу чөлгә елип кәлдиңлар! — дейишти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Буниң билән Пәрвәрдигар Мусаға: — Мана, Мән асмандин силәргә нан яғдуримән; шуниң билән хәлиқ һәр күни чиқип, бир күнлүк лазимлиғини жиғивалсун. Бу тәриқидә Мән уларниң Мениң қанун-әмирлиримдә маңидиған-маңмайдиғанлиғини синаймән. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Һәр һәптиниң алтинчи күни шундақ болидуки, улар жиғивалғанлирини тәйярлисун; у башқа күнләрдә еришидиғинидин бир һәссә көп болиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Андин Муса билән Һарун барлиқ Исраилларға: — Бүгүн ахшам силәрни Мисир зиминидин елип чиққучиниң Пәрвәрдигар екәнлигини билисиләр вә ");
INSERT INTO uigcyr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","әтә силәр Пәрвәрдигарниң шан-шәривини көрисиләр; чүнки У силәрниң Униң яман гепини қилип ғотулдашқиниңларни аңлиди; бизгә кәлсәк, силәр яман гепимизни қилип ғотулдиғидәк биз ким едуқ? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Муса йәнә: Пәрвәрдигар бүгүн ахшам силәргә йегили гөш берип, әтә әтигәндә тойғидәк нан бәргәндә буни билисиләр; чүнки Пәрвәрдигар силәр Униң яман гепини қилип ғотулдиғиниңларни аңлиди. Әнди биз немә едуқ? Силәрниң ғотулдашқиниңлар бизләргә қаритилған әмәс, бәлки Пәрвәрдигарға қаритилғандур, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Андин Муса Һарунға: — Сән Исраилларниң пүткүл җамаитигә: «Пәрвәрдигарниң алдиға келиңлар; чүнки У яман гәп билән ғотулдашқиниңларни аңлиди», дәп ейтқин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Шундақ болдики, Һарун Исраилларниң пүткүл җамаитигә сөзләп турғинида, улар чөл тәрәпкә қаривиди, мана, Пәрвәрдигарниң җуласи булутта аян болди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Шуниң билән Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","— Мән Исраилларниң яман гәп қилип ғотулдашқинини аңлидим; әнди уларға: «Гугумда силәр гөш йәйсиләр вә әтигәндә нандин тоюнисиләр, шуниң билән силәр Мениң Пәрвәрдигар Худайиңлар екәнлигимни билип йетисиләр» — дәп ейтқин, деди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Кәчқурунда шундақ болдики, бөдүниләр учуп келип, чедиргаһни қаплап кәтти; әтиси әтигәндә, чедиргаһниң әтрапидики йәрләргә шәбнәм чүшкән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Әтрапта ятқан шәбнәм көтирилип кәткәндин кейин, мана, чөллүкниң йәр йүзидә қиравдәк непиз, кичик-кичик жумилақ нәрсиләр туратти. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Исраиллар уни көргәндә, униң немә екәнлигини билмигини үчүн: — Бу немиду? — дәп сорашти. Муса уларға җававән: — Бу Пәрвәрдигар силәргә ата қилған озуқ-түлүктур. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Пәрвәрдигар шу ишни әмир қилип дедиги, «Һәр бириңлар йәйдиғиниңларға қарап униңдин жиғивелиңлар; һәр бириңлар аилидики адәм саниға қарап, һәр бир адәмгә бир омәр миқдарда жиғиңлар; һәр адәм өз чедиридики кишиләр үчүн жиғиңлар» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Исраиллар шундақ қилип, бәзиси көпрәк, бәзиси азрақ жиғивалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Улар уни омәр миқдари билән өлчивиди, көп жиққанларниңкидин ешип кәтмиди, аз жиққанларниңму кәмлик қилмиди; һәр бир киши өз йәйдиғиниға қарап жиққан еди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Муса уларға: — Һеч қандақ адәм булардин һеч немини әтигә қалдурмисун, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Шундақ болсиму, улар Мусаниң сөзигә қулақ салмиди; бәзиләр униңдин бир қисмини әтигә сақлап қойди. Амма сақлап қойғини қурутлап сесип кәтти. Бу иш үчүн Муса уларға хапа болуп аччиқланди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Шу сәвәптин уларниң һәр бири һәр әтигини чиқип өз йәйдиғиниға қарап жиғивалатти; қалғанлири болса аптап чиққанда ерип кетәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Лекин алтинчи күни шундақ болдики, улар күнлүк озуқниң икки һәссисини жиғди; демәк, һәр бир киши үчүн икки омәр миқдарда жиғивалди; андин җамаәт әмирлири һәммиси келип буни Мусаға ейтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Муса уларға: — Мана Пәрвәрдигарниң дегини: — Әтә арам күни, Пәрвәрдигарға аталған муқәддәс шабат күни болиду; пиширидиғиниңларни пиширип, қайнитидиғиниңларни қайинитип, ешип қалғанниң һәммисини әтигә сақлап қоюңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Улар Муса буйруғандәк, ешип қалғанни әтисигә сақлап қоювиди, улар сесип қалмиди, қурутлапму кәтмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Муса уларға: — Буни бүгүн йәңлар; чүнки бүгүн Пәрвәрдигарға аталған шабат күни болғини үчүн бүгүн даладин тапалмайсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Алтә күн силәр жиғсаңлар болиду; лекин йәттинчи күни шабат болғини үчүн у күнидә һеч немә тепилмайду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Һалбуки, йәттинчи күни хәлиқтин бир нәччиси озуқ-түлүк жиққили чиқивиди, һеч немә тапалмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Пәрвәрдигар Мусаға: «Силәр қачанғичә Мениң әмирлирим вә қанун-бәлгүлимилиримни тутушни рәт қилисиләр? ");
INSERT INTO uigcyr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Мана, Пәрвәрдигар силәргә шабат күнини бекитип бәрди; шуңа йәттинчи күни һәр бириңларни өз орнида туруп, сиртларға чиқмисун дәп, алтинчи күни икки күнлүк озуқ бериду», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Шуниң билән хәлиқ йәттинчи күни арам алди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Исраиллар бу озуқни «манна» дәп атиди; униң шәкли юмғақсүт уруғидәк, рәңги ақ болуп, тәми һәсәлгә миләнгән қотурмачқа охшайтти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Муса уларға: — Пәрвәрдигарниң әмри шуки, — Кейинки әвлатлириңларға Мән силәрни Мисирдин елип чиққанда, Мән силәргә чөлдә йейишкә ата қилған нанни көрситиш үчүн, униңдин комзәккә бир омәр тошқузуп, улар үчүн сақлап қоюңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Муса Һарунға: — Кәлгүси әвлатлириңларға көрситишкә сақлаш үчүн бир комзәкни елип, униңға бир омәр миқдарда манна селип, Пәрвәрдигарниң һозурида қоюп қойғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Кейин, Һарун Пәрвәрдигар Мусаға буйруғандәк комзәкни сақлаш үчүн уни һөкүм-гувалиқ сандуғиниң алдида қоюп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Шу тәриқидә Исраиллар адәм олтирақлашқан бир зиминға йетип кәлгичә қириқ жил «манна» йеди; улар Қанаан зимининиң чегаралириға йәткичә манна йеди. ");
INSERT INTO uigcyr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Әйни чағда бир «омәр» «әфаһ»ниң ондин биригә баравәр еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Андин пүткүл Исраил җамаити қопуп, Син чөлидин чиқип, Пәрвәрдигарниң әмри бойичә сәпәр қилип, Рәфидим дегән йәргә келип чедирлирини тикти. Амма у йәрдә хәлиққә ичкили су йоқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Шуниң билән хәлиқ Муса билән җедәллишип: — Бизгә ичкили су бәргин! — деди. Лекин Муса уларға: — Немишкә мениң билән җедәллишисиләр? Немишкә Пәрвәрдигарни синайсиләр? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Лекин хәлиқ чаңқап, су тәләп қилип, Мусадин ағринип ғотулдишип: — Сән немишкә бизни, балилиримизни вә мелимизни уссузлуқ билән өлтүрүшкә Мисирдин елип кәлдиң? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Шуниң билән Муса Пәрвәрдигарға пәряд көтирип: — Бу хәлиқни қандақ қилсам болар?! Улар һелила мени чалма-кесәк қилиши мүмкин! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Пәрвәрдигар Мусаға җававән: — Сән Исраилниң ақсақаллиридин бир нәччисини өзүң билән биллә елип чиқип, Нил дәриясиниң сүйини урғиниңда ишләткән һасаңни қолуңға елип хәлиқниң алдиға барғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Мана, Мән шу йәрдә, Һорәб теғидики қорам ташниң үстидә сениң алдиңда туримән; сән қорам ташни урғин. Буниң билән униңдин хәлиққә ичкили су чиқиду, — деди. Муса Исраилниң ақсақаллириниң көз алдида шундақ қилди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Муса Исраилларниң җедәлләшкини вә уларниң «Пәрвәрдигар зади аримизда барму-йоқму?» дейишип Пәрвәрдигарни синиғини үчүн, у йәрни «Массаһ» вә «Мәрибаһ» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Шу чағда Амаләкләр келип Рәфидимдә Исраилға һуҗум қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Муса Йәшуаға: Сән өзимиздин Амаләк билән җәң қилишқа адәм таллиғин. Мән әтә Худаниң һасисини қолумға елип дөңниң чоққисида туруп туримән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Йәшуа Муса буйруғинидәк қилип, Амаләкләр билән җәң қилди. Муса, Һарун вә Хур дөңниң чоққисиға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Шундақ болдики, Муса қолини көтирип турса, Исраил ғалип келәтти, лекин у қоллирини пәскә чүшүрүп турса, Амаләк ғалип келәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Мусаниң қоллири еғирлишип кәтти; улар бир ташни елип келип униң астиға қойди; у униң үстидә олтарди; андин Һарун билән Хур бири бир тәрипидә, бири йәнә бир тәрипидә униң қоллирини йөләп турди; бу тәриқидә униң қоллири таки күн патқичә мәзмут турди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Шундақ қилип, Йәшуа Амаләк вә униң хәлқини қиличлап набут қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Пәрвәрдигар Мусаға: — Бир әслимә болсун дәп бу ишларни бир китапқа йезип қалдурғин, шундақла шуларни Йәшуаниң қулақлириға оқуп бәр; чүнки Мән Амаләкниң намини асманларниң астидин, һәтта адәмләрниң есидинму мутләқ өчүрүветимән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Андин Муса бир қурбангаһни ясап, намини «Пәрвәрдигар туғумдур» дәп атиди ");
INSERT INTO uigcyr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","вә Муса: — Яһниң тәхти алдида бир қол көтирилип: — «Пәрвәрдигар әвлаттин әвлатқичә Амаләккә қарши җәң қилиду» дейилгән еди, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Мусаниң қейинатиси, йәни Мидиянниң каһини Йәтро Худаниң Муса үчүн һәмдә Өз хәлқи Исраил үчүн барлиқ қилғанлири тоғрилиқ аңлиди, йәни Пәрвәрдигарниң Исраилни Мисирдин чиқарғанлиғидин хәвәр тапти. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Шуниң билән Мусаниң қейинатиси Йәтро Мусаниң әслидә өз йениға әвәтивәткән аяли Зиппораһ вә униң икки оғлини елип йолға чиқти (биринчи оғлиниң исми Гәршом дәп қоюлған еди; чүнки Муса: «мән яқа жутта мусапир болуп туруватимән» дегән еди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Йәнә бириниң исми Әлиезәр дәп қоюлған еди; чүнки Муса: «Атамниң Худаси маңа ярдәмдә болуп, мени Пирәвнниң қиличидин қутқузди», дегән еди). ");
INSERT INTO uigcyr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Шундақ қилип Мусаниң қейинатиси Йәтро Мусаниң оғуллири билән аялини елип, Мусаниң чөлдә, Худаниң теғиниң йенида чедир тиккән йеригә йетип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","У әслидә Мусаға: — «Мана, мәнки қейинатаң Йәтро сениң аялиңни вә униң икки оғлини елип йениңға кетиватимән» дәп хәвәр әвәткән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Шуниң билән Муса өз қейинатисиниң алдиға чиқип, тазим қилип, уни сөйди. Улар бир-биридин һал-әһвал соришип чедирға кирди; ");
INSERT INTO uigcyr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Андин Муса қийнатисиға Исраилниң вәҗидин Пәрвәрдигарниң Пирәвн вә мисирлиқларға қилған һәммә әмәллирини сөзләп, уларниң йол бойи бешиға чүшкән җәбир-җапаларни баян қилип, Пәрвәрдигарниң қандақ қилип уларни қутқузғинини ейтип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Буни аңлап Йәтро Пәрвәрдигарниң Исраилға көрсәткән барлиқ яхшилиғидин, уларни мисирлиқларниң қолидин қутқузғанлиғидин шатланди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Йәтро шадлинип: — Силәрни мисирлиқларниң вә Пирәвнниң қолидин қутқузған Пәрвәрдигарға тәшәккүрләр болғай! У бу қовмни мисирлиқларниң қолидин қутқузди! ");
INSERT INTO uigcyr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Мән Пәрвәрдигарниң барлиқ илаһлардин үстүн туридиғанлиғини әнди билдим; чүнки У дәл улар йоғанчилиқ қилған ишта Өзиниң улардин үстүн туридиғанлиғини намайән қилди — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Андин Мусаниң қейинатиси Йәтро Худаға атап бир көйдүрмә қурбанлиқ вә бир нәччә тәшәккүр қурбанлиқлирини елип кәлди; Һарун билән Исраилниң һәр бир ақсақили Мусаниң қейинатиси билән биллә Худаниң һозурида таам йейишкә кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Әтиси Муса хәлиқниң иш-дәвалири үстидин һөкүм чиқиришқа олтарди; хәлиқ әтигәндин тартип кәчкичә Мусаниң чөрисидә турушти. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Мусаниң қейинатиси униң хәлқи үчүн қилған ишлирини көргәндә униңдин: — Сениң хәлиққә қиливатқан бу ишиң зади немә иш? Немишкә сән бу ишта ялғуз олтирисән, барлиқ хәлиқ немә үчүн әтигәндин кәчкичә сениң чөрәңдә туриду? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Муса қейинатисиға җавап берип: — Хәлиқ Худадин йол издәшкә мениң қешимға келиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Қачанки уларниң бир иш-дәваси чиқса улар йенимға келиду; шуниң билән мән уларниң оттурисида һөкүм чиқиримән вә шундақла Худаниң қанун-бәлгүлимилирини уларға билдүримән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Мусаниң қейинатиси униңға: — Бу қилғиниң яхши болмапту. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Сән җәзмән өзүңни һәмдә чөрәңдә турған хәлиқниму чарчитип қойисән; чүнки бу иш саңа бәк еғир келиду. Сән уни ялғуз қилип йетишәлмәйсән. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Әнди мениң сөзүмгә қулақ салғин, мән саңа бир мәслиһәт берәй вә шундақ қилсаң, Худа сениң билән биллә болиду: — Сән өзүң Худаниң алдида хәлиқниң вәкили болуп, уларниң ишлирини Худаға мәлум қилғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","сән хәлиққә қанун-бәлгүлимиләрни үгитип, маңидиған йолни көрситип, уларниң қандақ бурчи барлиғини уқтурғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Шуниң билән бир вақитта сән пүткүл хәлиқниң арисидин Худадин қорқидиған, нәпсанийәтчиликни яман көридиған һәм қабилийәтлик һәм диянәтлик адәмләрни тепип, уларни хәлиқниң үстигә баш қилип, бәзисини миң беши, бәзисини йүз беши, бәзисини әллик беши, бәзисини он беши қилип тайинлиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Шуниң билән булар һәр қандақ вақитта хәлиқниң иш-дәвалирини сорайду. Әгәр чоң бир иш-дәва чиқип қалса, буни саңа тапшурсун; лекин һәммә кичик иш-дәваларни улар өзлири беҗирисун. Шундақ қилип, улар сениң вәзипәңни йениклитип, жүкүңни көтиришүп бериду. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Әгәр шундақ қилсаң вә Худа саңа шундақ буйруса, өзүң вәзипәңдә пут тирәп туралайсән вә хәлқиңму хатирҗәмлик билән өз җайиға қайтип кетиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Муса қейинатисиниң сөзигә қулақ селип дегининиң һәммисини қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Муса пүткүл Исраил арисидин қабилийәтлик адәмләрни таллап, уларни хәлиқниң үстигә баш қилип, бәзисини миң беши, бәзисини йүз беши, бәзисини әллик беши, бәзисини он беши қилип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Булар һәр қандақ вақитта хәлиқниң иш-дәвалирини сорап турди; тәсрәк иш-дәваларни болса, Мусаға йоллайтти, кичик иш-дәваларни болса өзлири сорайтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Андин Муса қейинатисини йолға селип қойди, у өз жутиға қайтип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Исраиллар Мисир зиминидин чиқип, дәл үчинчи ейиниң башланған күни Синай чөлигә йетип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Улар Рәфидимдин чиқип, Синай чөлигә йетип келип, чөлдә чедир тикти; Исраил шу йәрдә, тағниң удулида тохтап чедир тикти. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Муса Худаниң алдиға чиқивиди, Пәрвәрдигар тағдин униңға хитап қилип мундақ деди: — Сән Яқупниң җәмәтигә сөз қилип, Исраилларға муну хәвәрни йәткүзгин: — ");
INSERT INTO uigcyr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","«Мениң мисирлиқларға немә қилғинимни, шундақла Мән силәрни худди бүркүт балилирини қанатлириға миндүрүп елип жүргәндәк, Өз қешимға елип кәлгинимни өзүңлар көрдүңлар.    ");
INSERT INTO uigcyr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Әнди силәр дәрһәқиқәт Мениң сөзүмни аңлап, әһдәмни тутсаңлар, ундақта барлиқ әлләрниң арисида Маңа хас бир гөһәр болисиләр — чүнки пүткүл йәр Мениңкидур — ");
INSERT INTO uigcyr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","вә силәр Маңа каһинлардин тәркиб тапқан хас бир падишалиқ вә муқәддәс бир қовм болисиләр». Мана бу сән Исраилларға дейишиң керәк болған сөзләрдур, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Шуниң билән Муса йенип келип, хәлиқниң ақсақаллирини чақиртип, Пәрвәрдигар униңға буйруған шу сөзләрниң һәммисини уларға йәткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Хәлиқниң һәммиси бир еғиздин: — Пәрвәрдигар буйруғанниң һәммисигә чоқум әмәл қилимиз! — дәп җавап бәрди. Андин Муса хәлиқниң җавап сөзлирини Пәрвәрдигарниң қешиға берип йәткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Пәрвәрдигар Мусаға: — Мана, Мән саңа сөз қилғинимда хәлиқ авазимни аңлисун, һемишә саңа ишәнсун дәп, йениңға қара булутниң қараңғулуғи ичидә келимән, дәп ейтти. Мусаму хәлиқниң дегәнлирини Пәрвәрдигарға аңлатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Пәрвәрдигар Мусаға йәнә: — Сән хәлиқниң қешиға берип, бүгүн вә әтә уларни пак-муқәддәс қилип, кийим-кечәклирини жуйдурғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Улар үчинчи күнигә тәйяр турсун; чүнки үчинчи күни барлиқ хәлиқниң көз алдида Пәрвәрдигар Синай теғиға чүшиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Сән хәлиқ үчүн тағниң әтрапиға бир пасил қилип, уларға: «Силәр еһтият қилиңлар, таққа чиқмаңлар яки униң етигигә тегип кәтмәңлар. Кимки таққа тәгсә өлтүрүлмәй қалмайду;    ");
INSERT INTO uigcyr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Униңға һәтта бирәр қоли тегип кәтсиму, чалма-кесәк қилип өлтүрүлсун яки оқ етип өлтүрүлсун. Мәйли һайван яки инсан болсун, шундақ қилса, тирик қалдурулмисун» — дәп ейтқин. Лекин Канай узун челинса, улар тағниң түвигә чиқсун, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Муса тағдин чүшүп хәлиқниң қешиға берип, хәлиқни Худаға атап муқәддәс қилди; улар кийим-кечәклирини жуйди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Андин Муса хәлиққә: — Үчинчи күнигә тәйяр туруңлар; һеч ким аяли билән йеқинчилиқ қилмисун, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Үчинчи күни болғанда, таң йоруши билән шундақ болдики, гүлдүрмамилар гүлдүрләп, чақмақ чеқип, тағ үстидә қоюқ бир парчә булут пәйда болди, зор қаттиқ челинған канайниң авази аңланди. Буни көрүп чедиргаһдики пүткүл хәлиқ қорқунучидин титрәп кәтти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Муса хәлиқни Худаниң алдида һазир болушқа чедиргаһдин елип чиқти. Улар келип тағниң түвидә өрә турди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Пәрвәрдигар Синай теғиға отта чүшүп кәлгини үчүн ис-түтәк пүткүл тағни қаплиди; ис-түтәк хумдандин өрлигән ис-түтәктәк үстигә өрләп чиқти. Пүткүл тағ қаттиқ тәвринишкә башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Канай авази барғансери күчийип интайин қаттиқ чиқти. Муса сөз қиливиди, Худа аңлап үнлүк аваз билән җавап бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Пәрвәрдигар Өзи Синай теғиға, тағниң чоққисиға чүшти; андин Пәрвәрдигар Мусани тағниң чоққисиға чақиривиди, Муса таққа чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Пәрвәрдигар Мусаға: — Сән чүшүп халайиқни агаһландуруп: Улар «Пәрвәрдигарни көримиз» дәп пасилдин бөсүп өтмисун; ундақ қилса, улардин көп адәм һалак болиду, дәп ейтқин. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Пәрвәрдигарға йеқин келәләйдиған каһинларму өзлирини Маңа атап муқәддәс қилсун; болмиса, Пәрвәрдигар сепилни бөскәндәк уларға һалакәт йәткүзиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Муса Пәрвәрдигарға: — Халайиқниң Синай теғиға чиқиши мүмкин әмәс; чүнки Сән Өзүң бизгә қаттиқ агаһландурдуң: тағни «муқәддәс» дәп қарап, униң әтрапиға пасилларни бекитиңлар, дәп әмир қилдиң, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Пәрвәрдигар Мусаға: — Маң, сән чүшүп кәткин. Андин сән Һарунни елип, биллә чиққин; лекин каһинлар вә хәлиқ болса Пәрвәрдигарниң қешиға барайли дәп пасилдин бөсүп өтмисун; болмиса, Пәрвәрдигар сепилни бөскәндәк уларниң үстигә чүшиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Шуниң билән Муса хәлиқниң қешиға чүшүп, уларға бу сөзни йәткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Худа муну барлиқ сөзләрни баян қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Мән сени «қуллуқ макани» болған Мисир зиминидин чиқирип кәлгән Пәрвәрдигар Худайиңдурмән. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Сениң Мәндин башқа һеч қандақ илаһиң болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Сән өзүң үчүн мәйли жуқуридики асманда болсун, мәйли төвәндики зиминда болсун, яки йәр астидики суларда болсун, һәр қандақ нәрсиниң қияпитидики һеч қандақ ойма шәкилни ясима.    ");
INSERT INTO uigcyr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Сән бундақ нәрсиләргә баш урма яки уларниң қуллуғиға кирмә. Чүнки Мәнки Пәрвәрдигар Худайиң вапасизлиққа һәсәт қилғучи Тәңридурмән. Мәндин нәпрәтләнгәнләрниң қәбиһликлирини өзлиригә, оғуллириға, һәтта нәврә-чәврилиригичә чүшүримән, ");
INSERT INTO uigcyr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Амма Мени сөйидиған вә әмирлиримни тутидиғанларға миң әвладиғичә өзгәрмәс меһриванлиқ көрситимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Пәрвәрдигар Худайиңниң намини қалаймиқан тилға алма; чүнки кимдәким намини қалаймиқан тилға алса, Пәрвәрдигар уни гунакар һесаплимай қалмайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Шабат күнини муқәддәс дәп билип тутқили ядиңда сақлиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Алтә күн ишләп барлиқ ишлириңни түгәткин; ");
INSERT INTO uigcyr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","лекин йәттинчи күни Пәрвәрдигар Худайиңға аталған шабат күнидур; сән шу күни һеч қандақ иш қилмайсән; мәйли сән яки оғлуң болсун, мәйли қизиң, мәйли қулуң, мәйли дедигиң, мәйли буқаң яки сән билән бир йәрдә туруватқан мусапир болсун, һеч қандақ иш қилмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Чүнки алтә күн ичидә Пәрвәрдигар асман билән зиминни, деңиз билән униң ичидики барини яратти андин йәттинчи күнидә арам алди. Буниң үчүн Пәрвәрдигар шабат күнини бәхит-бәрикәтлик күн қилип, уни муқәддәс күн дәп бекитти. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ата-анаңни һөрмәт қил. Шундақ қилсаң Пәрвәрдигар Худайиң саңа ата қилмақчи болған зиминда узун өмүр көрисән. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Қатиллиқ қилма. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Зина қилма. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Оғрилиқ қилма. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Хошнаң тоғрилиқ ялған гувалиқ бәрмә. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Сән хошнаңниң өй-имаритигә көз қириңни салма, нә хошнаңниң аяли, нә униң қулиға, нә униң дедиги, нә униң калиси, нә униң ишиги яки хошнаңниң һәр қандақ башқа нәрсисигә көз қириңни салма.    ");
INSERT INTO uigcyr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Пүткүл хәлиқ гүлдүрмамиларни, чеқин-ялқунларни, канайниң авази вә тағдин өрләп чиққан ис-түтәкләрни көрди вә аңлиди; улар буларни көрүп, титришип жирақ турушти ");
INSERT INTO uigcyr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","вә Мусаға: — Бизгә сәнла сөз қилғайсән, биз аңлаймиз; лекин Худа бизгә Өзи сөз қилмисун; чүнки ундақ қилса өлүп кетимиз, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Муса халайиққа җававән: — Қорқмаңлар; чүнки Худаниң бу йәргә келиши силәрни синаш үчүн, йәни силәрниң Униң дәһшәтлигини көз алдиңларға кәлтүрүп, гуна қилмаслиғиңлар үчүндур, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Шуниң билән халайиқ нерида турди; лекин Муса Худа ичидә турған қоюқ булутниң қешиға йеқин барди. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Пәрвәрдигар Мусаға: — Сән берип Исраилларға муну сөзләрни йәткүзгин: «Силәргә әрштин сөз қилғинимни көрдүңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Силәр Мениң орнумда илаһ дәп күмүчтин бутлар ясимаңлар, яки өзүңлар үчүн алтундин бутларни ясимаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","— Сән Мән үчүн тупрақтин бир қурбангаһ ясап, шу йәрдә көйдүрмә қурбанлиқ вә енақлиқ қурбанлиқлириңни, қой-өшкә билән калилириңни сунғин. Умумән Мән хәлиққә намимни һөрмәт билән әслитидиған барлиқ җайларда, йениңға келип саңа бәхит-бәрикәт ата қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","— Әгәр Маңа атап ташлардин қурбангаһ ясимақчи болсаң, ойулған ташлардин ясимиғин; чүнки ташларға әсвавиңни тәккүзсәң, улар напак болуп қалиду.    ");
INSERT INTO uigcyr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Қурбангаһимға чиқидиған пәләмпәй болмисун; ундақ болғанда, пәләмпәйдин чиққичә әвритиң көрүнүп қелиши мүмкин», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","— Сән уларниң алдиға қойидиған һөкүм-бәлгүлимиләр мунулардур: — ");
INSERT INTO uigcyr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Әгәр сән бир ибраний қулни сетивалған болсаң, у алтә жилғичә хизмитиңдә болуп, йәттинчи жили төләмсиз һөр қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","У қул қилинишқа тәнһа һаләттә елип келингән болса, тәнһа һаләттә кәтсун. Аяли билән биргә елип келингән болса, аялиму униң билән биллә кәтсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Әгәр ғоҗиси униңға хотун елип бәргән болса, шундақла аяли униңға оғул-қизларни туғуп бәргән болса, аял балилири билән ғоҗисиға қелип, әр ялғуз кәтсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Лекин әгәр қул елан қилип: «Мән ғоҗам, аялим вә балилиримға муһәббитим болғини үчүн һөр болуп кәтмәймән» десә, ");
INSERT INTO uigcyr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ундақта униң ғоҗиси уни Худаниң ибадәт соруниниң алдиға елип берип, уни ишикниң алдида яки ишикниң кешикиниң алдида турғузсун; андин ғоҗиси бигиз билән униң қулиқини тәшсун. Шундақ қилип, у мәңгүгә ғоҗисиниң қули болуп қалиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Әгәр бирким қизини дедәкликкә сетивәткән болса, у әр қуллар һөр қилинғандәк һөр қилинмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Әгәр өзигә хас сетивалған қиз ғоҗисиға яқмиса, ундақта у қиз тәрәпниң һәқ төләп уни һөр қилишиға йол қоюши керәк. Лекин ғоҗисиниң уни ят хәлиққә сетиш һоқуқи болмайду; чүнки ғоҗиси униңға вапасизлиқ қилғандур. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Әгәр у қизни оғлиға хас бекиткән болса, ундақта у бәлгүлимиләр бойичә униңға өз қизидәк муамилә қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Әгәр ғоҗиси йәнә хотун алса, әслидә әмригә алған дедигиниң йемәк-ичмекини, кийим-кечигини вә әр-хотунчилиқ бурчини кемәйтмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Әгәр у шу үч ишни ада қилмиса, ундақта у бәдәл төлимәй һөр болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Кимки бир адәмни уруп өлтүрүп қойса, уму чоқум өлтүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Лекин әгәр у киши өлгүчиниң җенини пайлап туруп қәстән өлтүрмигән, бәлки мән Худа униң қоли арқилиқ шу кишиниң өлүшигә йол қойған болсам, ундақ әһвалда Мән униңға қачидиған бир җайни орунлаштуримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Лекин әгәр бириси өз хошнисини һейлә билән өлтүримән дәп, униңға қәстән һуҗум қилса, у гәрчә панаһ издәп қурбангаһимға қечип кәлсиму, у шу йәрдә тутулсун вә өлүмгә мәһкүм қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Кимки өз атиси яки анисиға қол тәккүзсә, чоқум өлтүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Кимки бир адәмни булап сатқан болса яки униң қолида барлиғи мәлум болса, җәзмән өлтүрүлүши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Кимки өз атиси яки анисиға ләнәт қилип қарғиған болса, җәзмән өлтүрүлүши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Әгәр икки киши урушуп қелип, бири йәнә бирини таш я мошти билән урса, урулған киши өлмәй, орун тутуп йетип қалған болса, ");
INSERT INTO uigcyr_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","у киши қопуп һасиға тайинип ташқириға чиққидәк болса, ундақта уни урған киши җазадин халас қилинсун; пәқәт зәхимләнгүчиниң йетип иштин қалған вақти үчүн төләм берип, уни давалитип сәллимаза сақайтсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Әгәр бириси қули яки дедигини таяқта урса, шундақла қул яки дедәк нәқ мәйданда өлүп кәтсә, униң үчүн игиси чоқум җазаға тартилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Лекин әгәр таяқ йегүчи бир-икки күн тирик турса, ундақта қул ғоҗайининиң шәхси мал-мүлки болғини үчүн, қулниң җазасиға тартилмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Әгәр кишиләр бир-бири билән урушуп қелип, һамилдар бир аялни уруп салса, һамилдар аялда балиси балдур туғулушидин башқа зәхимлиниш болмиса, аялниң ериниң төләм тәливи бойичә һакимларниң тәстиқидин өткүзүлүп җәриманә төлисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Әгәр аял яки бала зиян-зәхәткә учриған болса, ундақта җениға җан, ");
INSERT INTO uigcyr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","көзигә көз, чишиға чиш, қолиға қол, путиға пут, ");
INSERT INTO uigcyr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","көйүккә көйүк, зәхимгә зәхим, көккә көк төләнсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Әгәр бириси өз қул я дедигиниң көзини уруп накар қилип қойса, көзи вәҗидин уни азат қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Шуниңдәк бириси өз қули я дедигиниң чишини уруп чиқиривәткән болса, чиши вәҗидин уни азат қилсун». ");
INSERT INTO uigcyr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Әгәр бир кала бир әр яки аял кишини үсүп өлтүрүп қойса, шу кала чоқум чалма-кесәк қилиниши керәк, униң гөши йейилмисун. Лекин калиниң егисигә гуна кәлмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Лекин бу уйниң илгиридин үсүш адити болуп, егисигә бу һәқтә агаһ берилгән болса, лекин йәнила уни бағлимиғини үчүн әр-аял кишиләрни үсүп өлтүрүп қойған болса, ундақта кала чалма-кесәк қилинсун, егисиму өлүмгә мәһкүм қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Лекин униңдин хун һәққи тәләп қилинса, өз җениниң орнида униңға қанчилик төләм қоюлған болса шуни бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Калидин үсүлгүчи оғул яки қиз бала болса, калиниң егиси охшашла жуқуриқи һөкүмдикидәк бир тәрәп қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Кала қул яки дедәкни үскән болса, калиниң егиси үсүлгүчиниң ғоҗисиға оттуз шәкәл күмүч бәрсун; андин кала чалма-кесәк қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Әгәр бириси бир ориниң ағзини очуқ қоюп яки колаватқан ориниң ағзини япмай, кала яки ешәк униңға чүшүп кәтсә, ");
INSERT INTO uigcyr_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Ундақта ориниң егиси мал егисиниң зийинини толуқ төләп бәрсун; өлгән мал униңки болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Әгәр бирисиниң калиси йәнә бирисиниң калисини үсүп өлтүрүп қойған болса, ундақта улар тирик қалған калини сетип, пулни баравәр бөлүшсун һәм өлүк калиниму шундақ бөлүшсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Лекин калиниң илгиридин үсидиған адити барлиғи ениқ туруп, егиси уни бағлимай қоювәткән болса, ундақта үскүчи калиниң егиси калиға кала төләп бәрсун, өлүк кала униң болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Әгәр бириси бир кала яки қойни оғрилап, уни сойса я сетивәтсә, у бир калиниң орниға бәш кала, бир қойниң орниға төрт қой төлисун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Оғри там тәшкәндә тутулуп қелип, таяқ йәп өлүп қалса, өлтүргүчигә хун җазаси кәлмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Лекин шу вақиә болған пәйттә күн чиқип қалған болса, ундақта өлтүргүчи хун җазасиға тартилсун. Оғри оғрилиғинини төләп зиянни толуқлап бериши керәк; униңда бир немә болмиса, қуллуққа сетилип, оғрилиған нәрсини төлиши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Оғри тутулғанда оғрилиған нәрсә, кала болсун, ешәк болсун, қой болсун униң қолида тирик һаләттә тепилса, у икки һәссә қиммәттә төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Әгәр бириси өз мал-чарвилирини етизлиққа яки үзүмзарлиққа отлашқа қоюветип, башқиларниң бағ-етизлиғида отлашқа йол қойса, ундақта у өзиниң әң есил мәһсулатлиридин яки үзүмзарлиғиниң әң есил мевисидин зиянни төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Әгәр от кетип, тикәнликкә тутишип кетип, андин өнчиләрни, баш тартип пишқан зираәтни көйдүрүп, пүткүл етизлиқни күл қиливәтсә, ундақта от қойғучи барлиқ зиянни төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Әгәр бириси хошнисиға пул яки мал-дуниясини аманәт қилған болса, булар өйидин оғрилинип кәтсә, шундақла оғри кейин тутулса, у оғрилиғинини икки һәссә қиммәттә төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Лекин оғри тепилмиса, өй егисиниң хошнисиниң мелиға қол тәккүзгән я тәккүзмигәнлиги мәлум болсун дәп, һакимларниң алдиға кәлтүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Һәр хил хиянәт, у мәйли кала, ешәк, қой, кийим-кечәк болсун, жүтүрүп қойған нәрсә болсун, улар тоғрилиқ бир хошниси: «әмәлийәттә мундақ еди» дәп талашқан болса, һәр иккисиниң дәваси һакимларниң алдиға кәлтүрүлсун; һакимлар қайсиға гуна бекитсә, шу хошнисиға икки һәссә қиммәттә төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Әгәр бириси хошнисиға ешәк, кала, қой яки башқа бир чарпайни аманәт қилса, бу аманәт мели киши көрмәй өлүп кәтсә, яки зәхимләнсә, яки һайдап әкитилсә, ");
INSERT INTO uigcyr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ундақта хошнисиниң мелиға қол тәккүзгән я тәккүзмигәнлиги мәлум болсун дәп, Пәрвәрдигарниң алдида уларниң оттурисида бир қәсәм ичүрүлсун. Мал егиси бу қәсәмни қобул қилсун; хошниси униңға төләм төләп бәрмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Лекин мал оғриланған болса, у егисигә төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Әгәр уни вәһший һайван боғуп қойған болса, у малниң қалдуғини гувалиқ үчүн көрситип, уни төләп бәрмисиму болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Әгәр бириси хошнисидин бир улақни өтнә елип, улақ егиси йоқ йәрдә зәхимләнсә яки өлүп қалса, өтнә алғучи толуқ төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Лекин егиси нәқ мәйданда болса, өтнә алғучи төләп бәрмисун; улақ иҗаригә елинған болса, алғучи төләм төлимисун; чүнки уни иҗарә төләп әкәлгән. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Әгәр бир адәм техи ятлиқ болмиған бир қизни аздуруп, униң билән биллә ятса, ундақта у униң тойлуғини бериши керәк, андин уни хотунлуққа алсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Лекин қизниң атиси уни униңға бәргили унимиса, зина қилғучи пак қизларниң тойлуғиға баравәр келидиған күмүч пулни таразида өлчәп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Җадугәр хотунни тирик қоймиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Һайван билән җинсий мунасивәт өткүзгән һәр бири җәзмән өлүмгә мәһкүм қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Кимдәким бирдин-бир Пәрвәрдигардин башқа һәр қандақ илаһқа қурбанлиқ сунса, һарам дәп мутләқ һалакәткә мәһкүм қилинсун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Силәрму Мисирда мусапир болуп турған екәнсиләр, мусапир болған кишини һеч харлимаңлар вә яки униңға һеч зулум қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Һәр қандақ тул хотун яки житим балини хорлимаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Сән уларни һәр қандақ тәрәптә хорлисаң, улар маңа пәряд көтәрсә, Мән уларниң авазини чоқум аңлаймән; ");
INSERT INTO uigcyr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","шуниң билән ғәзивим тутишип, силәрни қиличлап өлтүримән, силәрниң хотунлириңлар тул қилинип, балилириңлар житим болуп қалиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Әгәр сән Мениң хәлқимниң ичидин саңа хошна болған кәмбәғәлгә қәриз бәргән болсаң, униңға җазанихорлардәк муамилә қилмиғин; униңдин өсүм алмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Әгәр сән хошнаңниң чапинини гөрүгә алған болсаң, күн олтармаста униңға яндуруп бәр. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Чүнки чапини униң бирдин-бир йепинчиси болуп, бәдинини япидиған кийим шудур. У болмиса, у немини йепинип ятиду? Бу сәвәптин Маңа пәряд қилса, пәрядини аңлаймән; чүнки Мән шәпқәтликтурмән. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ⱨакимларға күпүрлүк қилма, вә хәлқиңниң әмирлириниму қарғап тиллима.    ");
INSERT INTO uigcyr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Хаминиңниң һосулиниң ашқинидин вә шарап-зәйтун мейи көлчигиңдин ташқинидин Маңа һәдийә сунушни кечиктүрмигин. Сән оғуллириңниң тунҗисини Маңа атиғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Кала билән қойлириңниң тунҗа балилириниму һәм шундақ атиғин; тунҗа бала йәттә күнгичә аниси билән биллә турсун; амма сәккизинчи күни уни Маңа атап сунғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Силәр Маңа аталған муқәддәс кишиләр болисиләр; шуңа далада житқуч һайван тәрипидин боғулған һайванниң гөшини йемәңлар, бәлки уни иштларға ташлап бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ялған гәпни яймиғин вә я ялған гувалиқ берип рәзил адәмгә ян басмиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Топқа әгишип рәзил ишта болма яки дәва-дәстурларда гувалиқ бәргәндә топқа әгишип һәқиқәтни бурмилима. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Кәмбәғәл дәва қилса, униңға ян басма. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Дүшминиңниң кала я ешиги езип кетип, саңа учрап қалса, уни елип келип, егисигә чоқум тапшуруп бәр. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Әгәр саңа өч болғанниң ешиги жүкни көтирәлмәй жүкниң астида ятқинини көрсәң, уни ярдәмсиз ташлимай, бәлки униңға ярдәмлишип ешигини қопурушуп беришиң зөрүр. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Араңдики кәмбәғәлниң дәвасида адаләтни бурмилима. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Һәр қандақ сахта иштин өзүңни нери тарт; бегуна адәм билән һәққаний адәмни өлтүрмигин; чүнки Мән рәзил адәмни һәргиз адил дәп ақлимаймән. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Шуниңдәк һеч қандақ пара йемә; чүнки пара көзи очуқларни кор қилип, һәққанийларниң сөзлирини бурмилайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Мусапир кишиләргә зулум қилма; чүнки өзүңлар Мисир зиминида мусапир болуп турған болғачқа, мусапирниң роһий һалини билисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Алтә жил өз йериңни терип, һосуллирини ал. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Лекин йәттинчи жили йәргә арам берип уни бош қой; хәлқиңниң намратлири униңдин жиғип йесун, улардин ашқинини җаңгалдики һайванлар йесун; шундақла үзүмзарлиғиң билән зәйтунзарлиғиңниму шундақ қилғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Алтә күн ичидә өз ишиңни ада қилип, йәттинчи күни арам елишиң зөрүр. Буниң билән кала-ешәклириң арам тапиду, дедигиңниң оғли билән мусапир кишиму һардуқини чиқириду. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Мән саңа ейтқинимниң һәммисини көңүл бөлүп ада қил; башқа илаһларниң намини тилиңға алма; булар һәтта ағзиңғиму чиқмисун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Һәр жилда үч қетим мениң үчүн һейт өткүзгин. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Алди билән «петир нан һейти»ни өткүз; саңа әмир қилғинимдәк Абиб ейидики бекитилгән күнләрдә йәттә күн петир нан йегин; чүнки шу айда сән Мисирдин чиққан едиң. Шу һейтта һечкиши алдимға қуруқ қол кәлмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Сән әҗир қилип териған етиздики зираитиңниң тунҗа һосулини орғанда «орма һейти»ни өткүз; шундақла сән әҗир сиңдүрүп йәрдин ахирқи һосул-мәһсулатлириңни жил ахирида жиққанда «һосул жиғиш һейти»ни өткүз. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Жилда үч қетим әркәклириңниң һәммиси Рәб Пәрвәрдигарниң һозуриға һазир болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Сән маңа аталған қурбанлиқниң қенини хемиртуруч селинған нан билән сунмиғин; һейт қурбанлиғиниң йеғини болса кечичә қондуруп әтигичигә сақлима. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Зиминиңдики дәсләпки һосулниң әң яхшсини Пәрвәрдигар Худайиңниң өйигә елип кәл. Оғлақни анисиниң сүтидә қайнитип пишарма.    ");
INSERT INTO uigcyr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Мана, Мән бир Пәриштини йолда сени қоғдап, Мән саңа тәйярлиған йәргә елип барсун дәп, алдиңда жүрүшкә әвәтимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Сән униң алдида өзүңгә агаһ бол, униң авазиға қулақ сал. Униң зитиға тәгмә; болмиса, у итаәтсизликлириңни кәчүрмәйду; чүнки Мениң намим униңдидур. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Лекин әгәр сән униң авазиға қулақ селип, Мениң барлиқ буйруғанлиримға әмәл қилсаң, Мән дүшмәнлириңгә дүшмән, күшәндилириңгә күшәндә болимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Чүнки Мениң Пәриштәм алдиңда жүрүп, сени Аморий, Һиттий, Пәриззий, Ⱪананий, Һивий вә Йәбусийларниң зиминиға башлап кириду; Мән уларни йоқитимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Сән уларниң илаһлириға баш уруп ибадәт қилма вә яки улар қилғандәк қилма; бәлки уларниң бутлирини үзүл-кесил чеқивәт, бут түврүклирини үзүл-кесил кукум-талған қиливәт; ");
INSERT INTO uigcyr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Лекин Худайиңлар Пәрвәрдигарниң ибадитидә болуңлар. Шундақ қилсаңлар У нан билән сүйүңларни бәрикәтләйду; Мән барлиқ кесәлликни араңлардин чиқирип ташлаймән. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Буниң билән зиминиңда бойидин аҗрап кетидиған яки туғмас һеч бир аял яки чарпай болмайду; өмрүңниң күнлирини толуқ қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Мән сениң алдиңда вәһимимни әвәтимән, қайси таипигә йеқинлашсаң шуларни паракәндә қилимән; шуниң билән һәммә дүшмәнлириңни кәйнигә яндуруп қачуримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Һивийлар, Ⱪананийлар вә Һиттийларни алдиңдин қоғлап чиқириветишкә сериқ һәриләрни алдиңда жүрүшкә әвәтимән.    ");
INSERT INTO uigcyr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Амма зиминниң Харабилишип, далада вәһший һайванлар көпийип саңа хәвп болуп қалмаслиғи үчүн, шу әлләрни алдиңдин бир жилғичә һайдивәтмәймән, ");
INSERT INTO uigcyr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Бәлки сән көпийип, зиминни пүтүнләй мирас қилип болғичә, аз-аздин һайдап туримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Сениң зиминиңниң чегарилирини Қизил Деңиздин тартип Филистийләрниң деңизиғичә, шуниңдәк чөлдин тартип Әфрат дәриясиғичә бекитимән; чүнки зиминда туруватқанларни һайдиветип йерини егилишиң үчүн, уларни қолуңға тапшуримән.    ");
INSERT INTO uigcyr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Сән улар билән вә яки илаһлири билән һеч қандақ бир әһдә түзмә. ");
INSERT INTO uigcyr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Уларниң сени алдимда гунаға патқузмаслиғи үчүн уларни зиминиңда қәтъий турғузма. Чүнки мабада сән уларниң илаһлириниң ибадитидә болсаң, бу иш саңа қапқан болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","У Мусаға йәнә: — «Сән берип, өзүң билән биллә Һарун, Надаб, Абиһуни вә Исраилларниң ақсақаллири арисидин йәтмиш адәмни елип, Пәрвәрдигарниң һозуриға чиқип, жирақта туруп сәҗдә қилиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Пәқәт Мусала Пәрвәрдигарниң алдиға йеқин кәлсун; башқилар йеқин кәлмисун, хәлиқ униң билән биллә үстигә чиқмисун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Муса келип Пәрвәрдигарниң барлиқ сөзлири билән һөкүмлирини халайиққа дәп бәрди; пүткүл халайиқ бир авазда: — Пәрвәрдигарниң ейтқан сөзлириниң һәммисигә әмәл қилимиз! — дәп җавап беришти. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Андин Муса Пәрвәрдигарниң һәммә сөзини хатириливелип, әтиси сәһәр қопуп тағниң түвидә бир қурбангаһни ясап, шу йәрдә Исраилниң он икки қәбилисиниң сани бойичә он икки таш түврүкни тиклиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Йәнә Исраилларниң бир нәччә жигитлирини әвәтти, улар берип Пәрвәрдигарға көйдүрмә қурбанлиқлар сунди, енақлиқ қурбанлиғи сүпитидә бир нәччә топақниму союп сунди. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Андин Муса қанниң йеримини қачиларға қачилиди, йәнә йеримини қурбангаһ үстигә чачти. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Андин у әһдинамини қолиға елип, хәлиққә оқуп бәрди. Улар җававән: — Пәрвәрдигарниң ейтқининиң һәммисигә қулақ селип, итаәт қилимиз! — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Шуниң билән Муса қачилардики қанни елип, хәлиққә сепип: — Мана, бу Пәрвәрдигар мошу сөзләрниң һәммисигә асасән силәр билән бағлиған әһдиниң қенидур, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Андин кейин Муса вә Һарун, Надаб вә Абиһу Исраилларниң ақсақаллиридин йәтмиш адәм билән биллә тағ үстигә чиқишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Улар шу йәрдә Исраилниң Худасини көрди; униң айиғиниң астида худди көк яқуттин ясалған нәпис паяндаздәк, асман гүмбизидәк сүпсүзүк бир җисим бар еди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Лекин у Исраилларниң мөтивәрлиригә қол тәккүзмиди; улар Худани көрүп турди һәмдә йәп-ичишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Пәрвәрдигар Мусаға: — Тағ үстигә, қешимға чиқип шу йәрдә турғин. Саңа уларға үгитишкә таш тахтайларни, йәни Мән йезип қойған қанун-әмирни беримән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Шуниң билән Муса қопуп, Ярдәмчиси Йәшуани елип маңди. Муса Худаниң теғиға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","У авал ақсақалларға: Биз йенип кәлгичә мошу йәрдә бизни сақлап туруңлар. Мана, Һарун билән хур силәрниң йениңларда қалиду; әгәр бирисиниң иш-дәваси чиқса, уларниң алдиға барсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Шуниң билән Муса тағниң үстигә чиқти вә тағни булут қаплиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Пәрвәрдигарниң җуласи Синай теғиниң үстидә тохтиди; булут уни алтә күнгичә қаплап турди; йәттинчи күни, Пәрвәрдигар булут ичидин Мусани чақирди; ");
INSERT INTO uigcyr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Пәрвәрдигарниң җуласиниң қияпити Исраилларниң көз алдида тағниң чоққисида һәммини жутқучи оттәк көрүнди. ");
INSERT INTO uigcyr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Муса булутниң ичигә кирип, тағниң үстигә чиқип кәтти. Муса қириқ кечә-күндүз тағда турди. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Сән Исраилларға ейтқин, улар Маңа бир «көтәрмә һәдийә»ни кәлтүрсун; кимниң көңли һәдийә сунушқа хуш болса, униңдин Маңа сунулидиған «көтәрмә һәдийә»ни тапшурувелиңлар.    ");
INSERT INTO uigcyr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Силәр улардин тапшурувалидиған көтәрмә һәдийә: — Алтун, күмүч, мис, ");
INSERT INTO uigcyr_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","көк, сөсүн вә қизил рәңлик жип, канап рәхт, тивит, ");
INSERT INTO uigcyr_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","қизил боялған қочқарниң терилири, делфинниң терилири, акатсийә яғичи, ");
INSERT INTO uigcyr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","чирақ үчүн зәйтун мейи, «мәсиһләш мейи» вә хушбуй үчүн хушбуй дора-дәрмәкләр, ");
INSERT INTO uigcyr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","әфод билән «қошен»ға орнитилидиған ақ һеқиқ вә башқа есил ташлар болсун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Мениң өзлири арисида макан қилишим үчүн шулардин Маңа бир муқәддәс туралғуни ясисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Уни Мән саңа барлиқ көрсәтмәкчи болғинимға асасән, йәни ибадәт чедириниң нусхиси вә барлиқ әсвап-сайманлириниң нусхисиға оп-охшаш қилип ясаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Улар акатсийә яғичидин бир сандуқ ясисун. Униң узунлуғи икки йерим гәз, кәңлиги бир йерим гәз, егизлиги бир йерим гәз болсун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Сән уни сап алтун билән қаплиғин; ичи вә сиртини алтун билән қаплап, униң үстүнки қисминиң чөрисигә алтундин гирвәк чиқар. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Униңға алтундин төрт һалқа қуйдуруп, төрт четиқиға бекиткин. Бир тәрипигә икки һалқа, йәнә бир тәрипигә икки һалқа болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Сән һәм акатсийә яғичидин икки балдақ ясап, һәр иккисини алтун билән қаплиғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","андин сандуқ улар арқилиқ көтирилсун дәп, балдақларни сандуқниң икки йенидики һалқилиридин өткүзүп қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Балдақлар һемишә сандуқтики һалқида турсун; улар униңдин чиқирилмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Мән саңа беридиған һөкүм-гувалиқни сандуққа қойғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Сандуқниң япқучи сүпитидә сән алтундин узунлуғи икки йерим гәз, кәңлиги бир йерим гәз болған бир «кәфарәт тәхти» ясиғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Икки керубни алтундин соқуп ясиғин. Уларни кәфарәт тәхтиниң икки тәрипигә орнатқин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Бир керубни бир тәрипигә, йәнә бир керубни йәнә бир тәрипигә орнитиш үчүн ясиғин. Икки тәрипидики керубларни кафарәт тәхти билән бир гәвдә қилиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Керублар бир-биригә йүзләнсун, қанатлирини кәфарәт тәхтиниң үстигә керип, қанатлири билән уни япсун; керубларниң йүзи кәфарәт тәхтигә қаритилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Сән кәфарәт тәхтини сандуқниң үстигә қоюп, Мән саңа беридиған һөкүм-гувалиқни сандуқниң ичигә қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Мән шу йәрдә сән билән көрүшимән; кәфарәт тәхти үстидә, йәни һөкүм-гувалиқ сандуғиниң үстидики икки керубниң оттурисида туруп саңа Исраилларға йәткүзүшкә тапшуридиған барлиқ әмирлирим тоғрисида сөз қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Һәм акатсийә яғичидин узунлуғи икки гәз, кәңлиги бир гәз, егизлиги бир йерим гәз болған бир ширә ясиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Уни сап алтун билән қаплап, униң үстүнки қисминиң чөрисигә алтундин гирвәк чиқар. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Сән ширәниң чөрисигә төрт илик егизликтә бир ләв ясиғин; бу ләвниң чөрисигиму алтундин бир гирвәк чиқар. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Сән у ширәгә алтундин төрт һалқа ясап, бу һалқиларни ширәниң төрт бүҗигидики четиққа орнатқин. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ширәни көтиришкә балдақлар өткүзүлсун дәп, һалқилар ширә левигә йеқин бекитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Балдақларни акатсийә яғичидин ясап, алтун билән қаплиғин; ширә улар арқилиқ көтирилиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ширәгә яндап легән, қача-тәхсә, пиялә вә шарап һәдийәлирини чачидиған қәдәһләрни ясиғин; уларни сап алтундин ясиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Мениң һозурумда турушқа сән ширәгә һемишә «тәқдим нан»ни қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Сән һәм сап алтундин бир чирақдан ясиғин. У чирақдан соқуп ясалсун; чирақданниң пути, ғоли, қәдәһлири, ғунчә вә чечәклири пүтүн бир алтундин соқулсун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Чирақданниң ғолиниң икки йенидин алтә шахчә чиқирилсун — чирақданниң бир йенидин үч шахчә, чирақданниң йәнә бир йенидин үч шахчә чиқирилсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","бир йенидики һәр бир шахчидә бадам гүли шәклидә ғунчиси вә чечиги болған үч қәдәһ чиқирилсун, йәнә бир йенидики һәр бир шахчидә бадам гүли шәклидә ғунчиси вә чечиги болған үч қәдәһ чиқирилсун. Чирақданға чиқирилған алтә шахчиниң һәммиси шундақ ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Чирақданниң ғолидин бадам гүли шәклидә ғунчиси вә чечиги болған төрт қәдәһ чиқирилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Булардин башқа биринчи икки шахчиниң астида бир ғунчә, иккинчи икки шахчиниң астида бир ғунчә, үчинчи икки шахчиниң астида бир ғунчә болсун; чирақданға чиқирилған алтә шахчиниң асти һәммиси шундақ болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Униң шу ғунчилири һәм шахчилири чирақдан билән бир гәвдә қилинсун — бир пүтүн сап алтундин соқуп ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Сән чирақданниң йәттә чириғини ясиғин; чирақлар удулға йоруқ чүшүрәлиши үчүн үсти тәрәпкә орнитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Униң пилик қайчилири билән күлданлири сап алтундин ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Чирақдан вә униң барлиқ әсваплири бир талант сап алтундин ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Саңа тағда аян қилинған нусха бойичә буларни еһтият билән ясиғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Муқәддәс чедирни он парчә йопуқтин ясатқин; йопуқлар непиз тоқулған ақ канап рәхткә көк, сөсүн вә қизил жиплар арилаштурулуп ишләнсун; униңға керубларниң сүритини чевәр қолларға нәпис қилип кәштиләп чиқарғузғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Һәр бир йопуқниң узунлуғи жигирмә сәккиз гәз, кәңлиги төрт гәз болуп, һәр бир йопуқ охшаш чоң-кичикликтә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Йопуқларниң бәши бир-биригә улансун, қалған бәш йопуқму һәм бир-биригә улансун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Сән улап чиқилған биринчи чоң парчиниң әң четидики қисмиға бир тәрипигә рәңги көк измә қадиғин, шуниңдәк улап чиқилған иккинчи чоң парчиниң әң четидикисиниң бир тәрипигиму һәм шундақ қилғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Биринчи чоң парчиниң әң четидики қисмиға әллик измә қадиғин, иккинчи чоң парчиниң әң четидикисигиму әллик измә қадиғин. Измиләр бир-биригә удулмуудул болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Муқәддәс чедир бир пүтүн болсун үчүн алтундин әллик илғу ясап, икки чоң парчә йопуқни шу илғулар билән бир-биригә туташтурғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Муқәддәс чедирни йепиш үчүн өшкә тивитидин йопуқларни ясиғин; йопуқтин он бир парчә ясиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Йопуқларниң һәр бириниң узунлуғи оттуз гәз, кәңлиги төрт гәз болуп, он бир йопуқниң һәммиси охшаш чоң-кичикликтә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Йопуқларниң бәшини улап бир қилип, қалған алтә йопуқниму улап бир қилип, алтинчи йопуқни икки қат қилип, чедирниң алди тәрипигә саңгилитип қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Сән биринчи улап чиқилған чоң парчиниң әң четидики қисмиға әллик измә, иккинчи улап чиқилған чоң парчиниң әң четидики қисмиға әллик измә қадиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Сән һәм мистин әллик илғу ясап, чедир бир пүтүн болсун үчүн уларни измиләргә өткүзүп икки чоң парчини улап қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Лекин йопуқниң чедирниң кәйнидин ешип қалған қисми, йәни ешип қалған йерим парчиси чедирниң кәйни тәрипидә саңгилап турсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Чедир йопуқлириниң чедирниң бойидин артуқ қисми, йәни у тәрипидин бир гәз, бу тәрипидин бир гәз, чедирниң икки тәрипидин саңгилап, уни толуқ япсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Буниңдин башқа, чедирға қизил боялған қочқар терисидин йопуқ ясап япқин, андин униң үстидинму делфин терисидин ясалған йәнә бир йопуқни қаплиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Муқәддәс чедирниң тик тахтайлирини акатсийә яғичидин ясап тиклигин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Һәр бир тахтайниң узунлуғи он гәз, кәңлиги бир йерим гәз болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Һәр бир тахтайниң иккидин туруми болсун, һәр икки тахтай шулар билән бир-биригә четилсун; чедирниң барлиқ тахтайлирини шундақ ясиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Чедирниң тахтайлирини шундақ ясиғин; жигирмисини җәнуп тәрәпкә тиклигин; ");
INSERT INTO uigcyr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","бу жигирмә тахтайниң тегигә күмүчтин қириқ тәглик ясиғин; бир тахтайниң астидики икки туруми үчүн иккидин тәглик, йәнә бир тахтайниң икки туруми үчүн иккидин тәглик ясиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Шуниңдәк чедирниң удул тәрипидә, йәни шимал тәрипидә жигирмә тахтай болсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","буларниң қириқ тәглиги күмүчтин болсун; бир тахтайниң тегигә иккидин тәглик, йәнә бир тахтайниң тегигә иккидин тәглик орунлаштурулсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Чедирниң кәйни тәрипигә, йәни ғәрип тәрәпкә алтә тахтай ясап тиклигин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Чедирниң кәйни тәрипидики икки булуңға икки тахтай ясап орнатқин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Бу булуң тахтайлири астидин үстигичә икки қат қилинип тахтайларни өз ара четиштурсун, үсти бир һалқиға бекитилсун. Һәр иккиси шундақ қилинип, икки булуңға тикләнсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Арқа тәрәптә сәккиз тахтай болиду, уларниң күмүчтин ясалған он алтә тәглиги болиду; бир тахтайниң тегидә икки тәглик, йәнә бир тахтайниң тегидә икки тәглик болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Буниңдин башқа сән акатсийә яғичидин балдақ ясиғин; чедирниң бу тәрипидики тахтайларға бәш балдақни, ");
INSERT INTO uigcyr_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","чедирниң у тәрипидики тахтайларға бәш балдақни, чедирниң арқа тәрипидики тахтайларға, йәни ғәрип тәрипидики тахтайларға бәш балдақни ясиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Тахтайларниң оттурисидики оттура балдақ бу тәрәптин у тәрәпкә йетидиған болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Тахтайларни алтун билән қаплап, балдақлар өткүзүлидиған һалқиларни алтундин ясап, балдақларни алтун билән қаплиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Чедирни саңа тағда аян қилинған нусха бойичә ясап тиклигин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Сән непиз тоқулған ақ канап рәхткә көк, сөсүн вә қизил жиплар арилаштурулуп ишләнгән бир пәрдә ясиғин; уни чевәр қоллар керубларниң сүритини нәпис қилип чүшүрүп кәштиләп чиқсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Уни акатсийә яғичидин ясалған төрт хадиға есип қойғин. Бу хадилар алтун билән қаплансун, һәр бириниң алтун илмики болсун; хадилар күмүчтин ясалған төрт тәгликкә орнитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Пәрдә чедир йопуғидики илмәкләргә есилип саңгилитип қоюлсун; андин һөкүм-гувалиқ сандуғини шу йәргә кәлтүрүп, пәрдиниң ичигә елип киргин. Шуниң билән пәрдә силәр үчүн муқәддәс җай билән әң муқәддәс җайниң оттурисидики бир айрима пәрдә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Андин сән «кәфарәт тәхти»ни әң муқәддәс җайдики һөкүм-гувалиқ сандуғиниң үстигә қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ширә болса пәрдиниң тешиға орунлаштурулсун; чирақданни ширәниң удулиға, чедирниң җәнуп тәрипигә қойғин; ширәни шимал тәрипигә қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Буниңдин башқа сән чедирниң кириш еғизиға непиз тоқулған ақ канап рәхткә көк, сөсүн вә қизил жиплар арилаштурулуп ишләнгән бир пәрдә ясиғин; у кәштичи тәрипидин кәштиләнсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Бу пәрдә үчүн акатсийә яғичидин бәш хада ясап, уларни алтун билән қаплиғин; һәр бириниң алтун илмики болсун; уларниң тегигә бәш данә тәгликни мистин қуюп тәйярлатқин. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Сән қурбангаһни акатсийә яғичидин ясиғин. Қурбангаһ төрт часа болсун; узунлуғи бәш гәз, кәңлиги бәш гәз, егизлиги үч гәз қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Униң төрт бүҗигигә қоюлидиған мүңгүзлирини ясиғин; мүңгүзлири қурбангаһ билән бир гәвдә қилинсун. Қурбангаһни мис билән қаплиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Қурбангаһниң яғ вә күлини елишқа дасларни ясиғин; униңға хас болған гүҗәкләрни, кориларни, лахшигирларни вә отданларниму ясиғин; униң барлиқ әсваплирини ясашқа мис ишләткин. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Қурбангаһ үчүн мистин бир шала ясиғин; шаланиң төрт бүҗигигә төрт мис һалқа ясап бекитип қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Шалани қурбангаһниң қап белиниң астидики гирвәктин төвәнрәк туридиған қилғин, шундақта шала қурбангаһниң дәл оттурисида болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Қурбангаһқа икки балдақ ясиғин; улар акатсийә яғичидин болсун, уларни мис билән қаплиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Қурбангаһни көтәргәндә, балдақлар униң икки йенида болуши үчүн, уларни һалқиларға өткүзүп қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Қурбангаһни тахтайлардин ясиғин, ичи бош болсун; у тағда саңа аян қилинған нусха бойичә һүнәрвәнләр тәйяр қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Муқәддәс чедирниң һойлисиниму ясиғин. Һойлиниң җәнубиға, йәни җәнупқа йүзләнгән тәрипигә непиз тоқулған ақ канап рәхттин пәрдиләрни тоқуғин; шу тәрипиниң узунлуғи йүз гәз болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Пәрдиләрни есишқа жигирмә хада ясалсун; уларниң тегигә қоюшқа жигирмә мис тәглик ясалсун; хадиларниң илмики билән балдақлар болса күмүчтин ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Шуниңға охшаш шимал тәрипидиму узунлуғи йүз гәз келидиған пәрдә болсун. Пәрдиләрни есишқа жигирмә хада ясалсун; уларниң тегигә қоюшқа жигирмә мис тәглик ясалсун; хадиларниң илмики билән балдақлар болса күмүчтин ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Һойлиниң ғәрип тәрипидә узунлуғи әллик гәз келидиған пәрдә болсун; униң он хадиси вә он тәглиги болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Һойлиниң шәриқ тәрипи, йәни күн чиқишқа йүзләнгән тәрипиниң кәңлиги әллик гәз болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Бир тәрипидә он бәш гәз келидиған пәрдә болсун; униң үч хадиси билән үч тәглиги болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Йәнә бир тәрипидә он бәш гәз келидиған пәрдә болсун; униң үч хадиси билән үч тәглиги болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Һойлиниң кириш еғизиға жигирмә гәз келидиған бир пәрдә қоюлсун; пәрдә непиз тоқулған ақ канап рәхткә көк, сөсүн вә қизил жиплар арилаштурулуп, кәштичи тәрипидин кәштиләнсун. Униң төрт хадиси билән төрт тәглиги болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Һойлиниң чөрисидики һәммә хадилар күмүчтин ясалған балдақлар билән бир-биригә четилсун; уларниң илмәклири күмүчтин, тәгликлири мистин ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Һойлиниң узунлуғи йүз гәз, кәңлиги һәр икки тәрипи әллик гәз болсун; непиз тоқулған ақ канап рәхттин ишләнгән пәрдиниң егизлиги бәш гәз қилинсун; хадиларниң тәгликлири мистин ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Муқәддәс чедирниң иш-хизмитидә ишлитилидиған барлиқ әсвап-сайманлири һәмдә барлиқ миқ-қозуқлири, шундақла һойлиниң барлиқ миқ-қозуқлири мистин болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","— Чирақниң һемишә йениқ туруши үчүн, чираққа ишлитишкә зәйтундин соқуп чиқирилған сап майни қешиңға кәлтүрүшкә Исраилларни буйруғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Җамаәт чедириниң ичидә, һөкүм-гувалиқ сандуғиниң удулидики пәрдиниң ташқирида Һарун вә оғуллири һәр кечиси әтигәнгичә Пәрвәрдигарниң алдида чирақларниң йениқ турғузуш ишида болсун. Бу иш дәвирдин-дәвиргичә Исраилларға әбәдий бир қанун-бәлгүлимә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Сән Исраилларниң ичидин акаң Һарун вә униң оғуллирини өз қешиңға кәлтүргин; уларни, йәни Һарун вә оғуллири Надаб, Абиһу, Әлиазар вә Итамарларниң Мениң каһинлиқ хизмитимдә болуши үчүн йениңға кәлтүргин. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Акаң Һарунға һәм шәрәп һәм гөзәллик үчүн муқәддәс кийимләрни тәйярлиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Һарунниң Маңа муқәддәс қилинип, Мениң каһинлиқ хизмитимдә болуши үчүн, Мән әқил-парасәтниң роһи билән қәлблирини толдурған чевәр кишиләрниң һәр биригә сөз қилип, уларни алаһидә кийимләрни тикишкә буйруғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Улар тикидиған кийимләр мунулардин ибарәт: — бир қошен, бир әфод, бир тон, кәштиләнгән бир халта көйнәк, бир сәллә вә бир бәлвағ. Мениң каһинлиқ хизмитимдә болуши үчүн, улар акаң Һарунға вә оғуллириға муқәддәс кийимләрни тиксун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Униңға алтун вә көк, сөсүн, қизил жиплар билән непиз тоқулған ақ канап рәхт ишлитилсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","әфодни улар алтун вә көк, сөсүн, қизил жиплар билән непиз тоқулған ақ канап рәхтләрни тәйярлап, чевәр қолларға нәпис қилип кәштилитип ишләтсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Әфодниң икки бешини бир-биргә туташтуруш үчүн икки долисида мүрилик тасма болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Әфодниң үстидин бағлайдиған, кәштиләнгән бәлвағ әфод билән бир пүтүн қилинсун вә униңға охшаш сипта ишлинип, алтун вә көк, сөсүн, қизил жиплар вә непиз тоқулған ақ канап рәхттин ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Икки ақ һеқиқни тепип, уларниң үстигә Исраилниң оғуллириниң намлирини ойдурғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","уларниң намлириниң алтиси бир яқутқа оюлсун, қалған алтиси болса йәнә бир яқутқа оюлсун, һәммиси туғулуш тәртиви бойичә пүтүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Худди яқут нәқишчилири ишлигәндәк, мөһүр оюлғандәк Исраилниң оғуллириниң намлирини икки яқутқа ойдурғин; улар алтундин ясалған көзлүккә бекитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Исраилниң оғуллириға әсләтмә таш болсун үчүн, икки яқутни әфодниң икки мүрилик тасмисиға қадиғузғин; шундақ болғанда, Һарун Пәрвәрдигарниң алдида уларниң намлирини әсләтмә сүпитидә мүрилиридә көтирип жүриду. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Буниңдин башқа, сән алтундин йәнә икки көзлүк вә сап алтундин шойнидәк ешип етилгән икки зәнҗир ясатқин; андин ешилмә зәнҗирләр көзлүкләргә бекитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Һөкүм қошени»ни чевәр қолларға нәпис қилип кәштилитип ясатқин; уни һәм әфодни ишлигән усулда ясиған, алтун вә көк, сөсүн, қизил жиплар билән непиз тоқулған ақ канап рәхттин ясиғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","У икки қат, төрт часа қилинсун; узунлуғи бир ғерич, кәңлигиму бир ғерич болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Униң үстигә төрт қатар қилип гөһәрләрни орнатқин: — биринчи қатарға қизил яқут, сериқ гөһәр вә зумрәт орнитилсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","иккинчи қатарға көк қаштеши, көк яқут вә алмас орнитилсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","үчинчи қатарға сөсүн яқут, пироза вә сөсүн квартс орнитилсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","төртинчи қатарға берил яқут, ақ һеқиқ вә анарташ орнитилсун; буларниң һәммиси алтун көзлүк ичигә орнитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Бу гөһәрләр Исраилниң оғуллириниң намлириға вәкил қилинип, уларниң санидәк он икки болуп, мөһүр ойғандәк һәр бир гөһәргә он икки қәбилиниң нами бирдин-бирдин пүтүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Қошенға шойнидәк ешилгән сап алтундин икки ешилмә зәнҗир ясиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Қошенға алтундин икки һалқа етип, икки һалқини қошенниң жуқуриқи икки бүҗигигә бекиткин; ");
INSERT INTO uigcyr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","андин алтундин ешилип ясалған икки зәнҗирни қошенниң жуқуриқи икки бүҗигидики һалқидин өткүзүп, ");
INSERT INTO uigcyr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ешилгән шу зәнҗирләрниң икки учини икки көзлүккә бекитип, көзлүкләрни әфодниң икки мүрилик тасмисиниң алди қисмиға орнатқин. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Буниңдин башқа сән алтундин икки һалқа ясап, уларни қошенниң асти тәрипидики икки бүҗигигә бекиткин; улар әфодқа тегишип туридиған қилинип ичигә қадалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Мундин башқа сән алтундин йәнә икки һалқа ясап, уларни әфодниң икки мүрилик тасмисиниң алди төвәнки қисмиға, йәни әфодқа улинидиған җайға йеқин қилип, кәшитиләнгән бәлвағдин егизрәк қилип бекиткин. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Қошенниң әфодниң кәшитиләнгән бәлвеғидин жуқурирақ туруши, қошенниң әфодтин аҗрап кәтмәслиги үчүн қошенниң һалқисини көк шойна билән әфодниң һалқисиға четип қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Шундақ қилғанда, Һарун муқәддәс җайға киргәндә, һөкүм қошенини тақиғачқа, Исраилниң оғуллириниң намлирини әсләтмә сүпитидә жүригиниң үстидә Пәрвәрдигарниң алдида дайим көтирип жүргән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Һарун Пәрвәрдигарниң алдиға киргәндә, урим билән туммим униң жүриги үстидә болуши үчүн, буларни һөкүм қошениниң ичигә алғин; мошундақ қилғанда, Һарун Исраилларға бағлиқ һөкүмләрни һемишә Пәрвәрдигарниң һозурида өз жүриги үстидә көтирип жүргән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Әфодниң ичидики тонни пүтүнләй көк рәңлик қилғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Тонниң башқа кийилидиған төшүги дәл оттурисида болсун; униң житилип кәтмәслиги үчүн худди бапкар тоқуғандәк, савутниң яқисиға охшаш чөрисигә пәваз чиқирилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Униң етигиниң чөрисигә көк, сөсүн вә қизил жиптин анарларни тоқуп асқин һәмдә алтун қоңғурақларни ясап, чөрисидики анарларниң арилиғиға бирдин есип қойғин; тонниң етигиниң пүткүл чөрисигә бир алтун қоңғурақ, бир анар, йәнә бир алтун қоңғурақ, бир анар... бекитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Һарун хизмәт қилған вақтида шу тонни кийсун; буниң билән Һарун Пәрвәрдигарниң алдиға барғанда, йәни муқәддәс җайға, Пәрвәрдигарниң алдиға кирип-чиққанда униң авази аңлинип туриду-дә, у өлүмдин аман қалиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Андин кейин сән сап алтундин нәпис бир отуғатни ясап, униң үстигә мөһүргә нәқишләнгәндәк: «Пәрвәрдигарға муқәддәс қилинди» дәп ойғин;    ");
INSERT INTO uigcyr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","уни көк рәңлик жип билән сәллисигә чиккин; у сәллиниң алди тәрипигә тақалсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","у Һарунниң пешанисидә турсун. Буниң билән Һарун Исраилларниң муқәддәс қилип кәлтүргән барлиқ муқәддәс һәдийәлиригә чаплашқан гуналарни өз үстигә елип көтириду; һәдийәләрниң Пәрвәрдигарниң алдида қобул қилиниши үчүн отуғат һемишә униң пешанисигә тақақлиқ турсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Буниңдин башқа ақ канап рәхттин бир көйнәк тоқуғин, шуниңдәк канап рәхттин тоқулған бир сәллә тәйярлиғин; кәштиләнгән бир бәлвағ ясиғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Һарунниң оғуллириға халта көйнәкләрни тиккин; уларғиму бәлвағларни тәйярла, уларға егиз бөкләрниму тиккин; булар уларға һәм шәрәп һәм гөзәллик болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Буларниң һәммисини сән акаң Һарун вә униң оғуллириға кийдүргин; андин уларниң Мениң алдимда каһинлиқ хизмитимдә болуши үчүн уларни мәсиһләп, Маңа муқәддәс қилип айриғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Уларниң әврәтлириниң йепиқ туруши үчүн уларға канап рәхттин тамбал әттүргин; у белидин янпишиғичә йепип турсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Һарун вә оғуллири җамаәт чедириға киргәндә яки муқәддәс җайда хизмәттә болуш үчүн қурбангаһқа йеқинлашқанда, улар гунакар болуп өлүп кәтмәслиги үчүн тамбални кийивалсун. Бу униңға вә униңдин кейинки нәсиллири үчүн әбәдий бир бәлгүлимә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Уларниң Маңа муқәддәс қилинип, каһинлиқ хизмитимдә болуши үчүн мундақ ишни ада қилишиң керәк: — сән бир яш әркәк топақ билән икки қочқарни талла (һәммиси беҗирим болсун) ");
INSERT INTO uigcyr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","һәмдә петир нан, зәйтун мейи иләштүрүлгән петир тоғач вә зәйтун мейи сүрүлүп мәсиһләнгән петир һәмәк нанларни тәйярла, буларниң һәммисини буғдай унидин қилғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","нанларниң һәммисини бир севәткә селип, севәтни, топақни вә икки қочқарни биллә һәдийә қилип кәлтүргин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Сән Һарун вә униң оғуллирини җамаәт чедириниң кириш еғизиға йеқин елип келип, уларни су билән жуйғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","андин кийимлирини елип келип, Һарунға халта көйнәк, әфод тони вә әфодни кийдүргин, қошенни тақиғин; андин белигә әфодниң кәштиләнгән бәлвеғини бағлиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Бешиға сәллини йөгәп, сәллигә муқәддәс отуғатни тақап қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Андин мәсиһләш мейини елип, бешиға қуюп уни мәсиһлигин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Андин сән униң оғуллирини елип келип, уларға халта көйнәкләрни кийдүргин; ");
INSERT INTO uigcyr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","уларға, йәни Һарун вә униң оғуллириға бәлвағларни бағлап, егиз бөкләрни кийдүргин. Шуниң билән әбәдий бәлгүлимә бойичә, каһинлиқ хизмити уларниңки болиду; шундақ қилип, сән Һарун билән униң оғуллирини Худаға муқәддәс қилип айрип тайинлиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","— Сән топақни җамаәт чедириниң алдиға елип кәлгин; елип кәлгиниңдә Һарун билән униң оғуллири қоллирини топақниң бешиға қойсун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Андин сән бу топақни Пәрвәрдигарниң алдида, җамаәт чедириниң кириш еғизиниң йенида боғузлиғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","топақниң қенидин елип бармиғиң билән уни қурбангаһниң мүңгүзлиригә сүрүп, қалған қанниң һәммисини қурбангаһниң түвигә төкүп қуйғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ич қарнини йөгәп турған барлиқ майни, шундақла җигәрниң үстидики чава май, икки бөрәк вә уларниң үстидики майни аҗритип буларни қурбангаһта көйдүргин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Топақниң гөши, териси вә тезигини болса чедиргаһниң сиртиға елип чиқип, отта көйдүрүвәткин; бу гуна қурбанлиғи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Андин сән қочқарларниң бирини елип кәлгин; Һарун билән униң оғуллири қоллирини қочқарниң бешиға қойсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","андин сән бу қочқарни боғузлап, униң қенидин қурбангаһниң үсти қисминиң әтрапиға сәпкин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Қочқарни парчилап, униң ич қарни билән пачақлирини жуюп, уларни гөш парчилири вә башниң үстигә қоюп, ");
INSERT INTO uigcyr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","пүтүн қочқарни қурбангаһта көйдүргин. Бу Пәрвәрдигарға аталған көйдүрмә қурбанлиқ — от арқилиқ сунулидиған, Пәрвәрдигарға хушбуй йәткүзидиған һәдийә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Кейин сән иккинчи қочқарни елип кәлгин; Һарун вә униң оғуллири қоллирини қочқарниң бешиға қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Андин бу қочқарни боғузлап қенидин елип, Һарунниң оң қулиқиниң юмшиқиға, униң оғуллириниң оң қулиқиниң юмшиқиға, уларниң оң қоллириниң чоң бармиғи билән оң путлириниң чоң бармиғиға сүркәп қойғин, қалған қанни қурбангаһниң үсти қисминиң әтрапиға сәпкин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Андин қурбангаһ үстидики қандин вә мәсиһләш мейидин елип, Һарунниң үстигә, униң кийимлиригә, шуниңдәк униң оғуллириниң үстигә вә уларниң кийимлиригиму сәпкин. Шундақ қилип у вә униң кийимлири, униң оғуллири вә уларниң кийимлириму униң билән тәң Худаға атап муқәддәс қилинған болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Андин сән қочқарниң мейи, қуйруқ мейи, ич қарнини йөгәп турған барлиқ май, җигәрниң үстидики чава май, икки бөрәк вә уларниң үстидики майни чиқар һәмдә оң арқа путини алғин — (чүнки бу қочқар каһинлиққа тикләш қурбанлиғиға аталған қочқардур) — ");
INSERT INTO uigcyr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","— буниңдин башқа сән Пәрвәрдигарниң алдида қоюлған петир нан севитидин бир гирдини, зәйтун мейи иләштүрүлгән петир тоғачтин бирни вә петир һәмәк нандин бирни елип, ");
INSERT INTO uigcyr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","буларниң һәммисини Һарунниң қоллириға вә униң оғуллириниң қоллириға қоюп, уларни «пулаңлатма һәдийә» сүпитидә Пәрвәрдигарниң алдида пулаңлатқузғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Андин сән буларни уларниң қоллиридин тапшуруп елип, Пәрвәрдигарниң алдида хушбуй чиқарсун дәп, қурбангаһтики көйдүрмә қурбанлиқниң үстидә қоюп көйдүргин. Бу от арқилиқ Пәрвәрдигарға сунулған һәдийә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Сән Һарунни каһинлиққа тикләш қурбанлиғиға аталған қочқарниң төшини елип «пулаңлатма һәдийә» сүпитидә Пәрвәрдигарниң һозурида пулаңлатқин; бу сениң үлүшүң болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Шуниңдәк, сән каһинлиққа тикләш қурбанлиғиға аталған қочқарниң «пулаңлатма һәдийә» сүпитидә пулаңлитилған төши билән «көтәрмә һәдийә» сүпитидә егиз көтирип пулаңлитилған арқа путини, йәни Һарун вә униң оғуллириға беғишланған шу үлүшләрни «муқәддәс» дәп айрип бекиткин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Шуниң билән бу нәрсиләр әбәдий бәлгүлимә бойичә Исраиллар тәрипидин Һарун вә оғуллириға беғишланған несивә болиду; чүнки у көтәрмә һәдийәдур. Булар Исраиллар тәрипидин сунулидиған енақлиқ қурбанлиқлиридин айрип чиқилип, уларниң Пәрвәрдигарға атап «егиз көтәргән һәдийә»си һесаплинип, «көтәрмә һәдийә» болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Һарунниң муқәддәс кийимлиригә кейин оғуллири варислиқ қилиду. Улар мәсиһлинип, каһинлиққа тайинланғандә шу кийимләрни кийсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Оғуллириниң қайсиси униң орнини бесип каһин болса, җамаәт чедириға кирип муқәддәс җайниң ичидә хизмәткә киришкәндә, бу кийимләрни уда йәттә күн кийип жүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Сән каһинлиққа тикләш қурбанлиғиға аталған қочқарни елип, униң гөшини муқәддәс җайда пишарғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","андин Һарун вә оғуллири қочқарниң гөши билән севәттики нанларни җамаәт чедириниң кириш еғизида йесун; ");
INSERT INTO uigcyr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","улар өзлириниң каһинлиққа тайинлинишидә Худаға атап муқәддәс қилинғанда кәфарәткә ишлитилгән нәрсиләрни йесун, лекин булар муқәддәс болғачқа, ят киши буниңдин һеч немини йемисун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Әгәр каһинлиққа тикләш қурбанлиқ гөшидин яки нандин әтигә азрақ ешип қалса, ешип қалғанни отта көйдүрүвәт; булар муқәддәс болғачқа, һеч ким униңдин йесә болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Сән шу тәриқидә Һарун вә униң оғуллири тоғрисида буйруғинимниң һәммисини беҗа кәлтүрүп, уда йәттә күнгичә уларни каһинлиққа тикләш вәзиписини ада қилғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Һәр күни кәфарәт қилинишқа гуна қурбанлиғи сүпитидә бир топақни сунғин. Қурбангаһниң өзини гунадин пак қилишқа униң үчүнму кәфарәт кәлтүргин, муқәддәс қилинсун дәп, уни зәйтун мейи билән мәсиһлигин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Йәттә күнгичә сән қурбангаһ үчүн кәфарәт кәлтүрүп, уни муқәддәс қилғин. Буниң билән у «әң муқәддәс нәрсиләрниң бири» һесаплиниду; униңға тәккән һәммә нәрсә муқәддәс һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Мана, қурбангаһта һемишә сунидиғанлириң мунулар: — һәр күни бир яшлиқ икки қоза қурбанлиқ қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Бирини әтигәндә, йәнә бирини гугумда қурбанлиқ қилип сунғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Биринчи қоза билән биргә зәйтун мейидин бир һинниң төрттин бири иләштүрүлгән буғдай унидин әфаһниң ондин бири вә йәнә шарап һәдийәси сүпитидә төрттин бир һин шарап қошуп сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Иккинчи қозини гугумда сунғин; уни әтигәнлик қурбанлиқниңкидәк, хушбуй болуши үчүн от арқилиқ Пәрвәрдигарға аталған қурбанлиқ сүпитидә ашлиқ һәдийәси вә шарап һәдийәси билән қошуп сунғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Шу тәриқидә бу көйдүрмә қурбанлиқ нәсилдин-нәсилгә җамаәт чедириниң кириш еғизида Пәрвәрдигарниң һозурида өткүзүлүп дайимлиқ қурбанлиқ болсун; Мән Пәрвәрдигар шу йәрдә силәр билән көрүшүп, сән билән сөзлишимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Шуниңдәк Мән шу йәрдә Исраиллар билән учришимән, шуниң билән у җай Мениң шан-шәривим билән муқәддәс қилиниду. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Мән җамаәт чедири билән қурбангаһни Өзүмгә атап муқәддәс қилимән; Һарун вә униң оғуллириниму Өзүмгә каһинлиқ хизмәттә болушқа айрип муқәддәс қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Шундақ қилип Мән Исраилларниң арисида макан қилип, уларниң Худаси болимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","У вақитта улар Мениң уларниң арисида макан қилишим үчүн уларни Мисир зиминидин чиқирип кәлгән Худаси Пәрвәрдигар екәнлигимни билиду; Мән уларниң Худаси Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Сән йәнә хушбуй яндуруш үчүн бир хушбуйгаһни ясатқин; уни акатсийә яғичидин тәйярлиғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","У төрт часа, узунлуғи бир гәз, кәңлиги бир гәз, егизлиги икки гәз болсун. Униң төрт бүҗигидики мүңгүзләр униң билән бир пүтүн қилип ясалсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Сән уни, йәни униң үстини, төрт әтрапини һәм мүңгүзлирини сап алтун билән қаплатқин; униң үсти қисминиң чөрисигә алтундин гирвәк чиқарғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Униңға алтундин икки һалқа ясап, униң гирвикиниң астиға бекиткин; уларни икки йениға удулму удул бекиткин. Хушбуйгаһни көтиридиған икки балдақни селиш үчүн буларни хушбуйгаһниң икки тәрипигә орунлаштурғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Балдақлирини акатсийә яғичидин ясап, алтун билән қаплиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Хушбуйгаһни һөкүм-гувалиқ сандуғиниң удулидики пәрдиниң сиртиға, йәни Мән сән билән көришидиған җай болған һөкүм-гувалиқ сандуғиниң үстидики кәфарәт тәхтиниң удулиға қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Һарун шуниң үстидә есил хушбуй әтирни яндурсун; һәр күни әтигәнлиги чирақларни пәрлигили кәлгәндә, хушбуйларни яндурсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Шуниңдәк Һарун гугумда чирақларни тизип яққанда, хушбуй яндурсун. Шундақ қилип Пәрвәрдигарниң алдида нәсилдин-нәсилгә хушбуй һемишә өчүрүлмәй йениқ болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Силәр униң үстидә нә һеч қандақ ғәйрий хушбуй яндурмаңлар, нә көйдүрмә қурбанлиқ нә ашлиқ һәдийәси сунмаңлар, шундақла униң үстигә һеч қандақ шарап һәдийәсини төкмәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Һәр жилда Һарун бир қетим хушбуйгаһниң мүңгүзлиригә кәфарәт кәлтүрсун; һәр қетим кәфарәт кәлтүридиған гуна қурбанлиғиниң қени билән униң үчүн кәфарәт кәлтүрсун. Нәсилдин-нәсилгә шундақ қилиңлар; бу хушбуйгаһ Пәрвәрдигарға «әң муқәддәс» һесаплинидиған нәрсиләрниң қатаридиндур. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Сән Исраилларниң санини ениқлаш үчүн уларни саниғиниңда, уларниң санилиши вәҗидин арисиға балаю-апәт кәлмәслиги үчүн, уларни саниғиниңда һәр бир адәм өз җени үчүн Пәрвәрдигарға кәфарәт пули тапшурсун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ройхәткә елинип, санақтин өткәнләрниң һәммиси бериши керәк болғини шуки, һәр бири муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә йерим шәкәл бәрсун (бир шәкәл жигирмә гәраһқа баравәр келиду). Бу йерим шәкәл Пәрвәрдигарға «көтәрмә һәдийә» болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ройхәткә елинип, санақтин өткәнләр, йәни жигирмә яш яки униңдин чоңларниң һәр бири Пәрвәрдигарға шу «көтәрмә һәдийә»ни бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Өз җениңларға кәфарәт кәлтүрүш үчүн Пәрвәрдигарға көтәрмә һәдийә бәргиниңларда бай киши йерим шәкәлдин артуқ бәрмисун, кәмбәғәл кишиму йерим шәкәлдин кам бәрмисун. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Сән Исраиллардин шу кәфарәт пулини тапшуруп елип, җамаәт чедириниң хизмитигә беғишлап ишләткин; у пул Исраилларға Пәрвәрдигарниң һозурида әсләтмә сүпитидә җениңларға кәфарәт кәлтүридиған болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Сән жуюнушқа ишлитишкә мистин йоған бир дас вә униңға мистин бир тәглик ясатқин; уни җамаәт чедири билән қурбангаһниң оттурисиға орунлаштуруп, ичигә су тоштуруп қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Һарун билән униң оғуллири униңдики су билән пут-қоллирини жуйсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Улар җамаәт чедириға киргәндә өлмәслиги үчүн су билән өзини жуюши керәк; улар хизмәт қилиш үчүн, қурбангаһқа йеқин берип Пәрвәрдигарға от арқилиқ атилидиған қурбанлиқ сунмақчи болғинидиму, шундақ қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Улар өлмәслиги үчүн пут-қоллирини жуйсун; бу иш уларға, йәни өзи вә униң нәсиллири үчүн әвлаттин әвлатқичә әбәдий бир бәлгүлимә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Сән һәммидин есил хушбуй дора-дәрмәкләрдин тәйярла, йәни мурмәкки суюқлуғидин бәш йүз шәкәл, дарчиндин икки йүз әллик шәкәл, егирдин икки йүз әллик шәкәл, ");
INSERT INTO uigcyr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","қовзақдарчиндин бәш йүз шәкәл елип (бу өлчәмләр муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә болсун) вә зәйтун мейидинму бир һин тәйярла; ");
INSERT INTO uigcyr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","бу дора-дәрмәкләр билән мәсиһ қилиш үчүн бир муқәддәс май — әтирчи чиқарғандәк бир хушбуй май чиқарғузғин. Бу «муқәддәс мәсиһләш мейи» болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Сән униң билән җамаәт чедирини, һөкүм-гувалиқ сандуғини, ");
INSERT INTO uigcyr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ширә вә униң барлиқ қача-қучилирини, чирақдан вә униң әсваплирини, хушбуйгаһни, ");
INSERT INTO uigcyr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","көйдүрмә қурбанлиқ қурбангаһи вә униң әсваплирини, жуюнуш деси вә униң тәглигини мәсиһлигин; ");
INSERT INTO uigcyr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","сән шу тәрздә уларни «әң муқәддәс нәрсиләр» қатарида муқәддәс қилғин. Уларға тәккән һәр қандақ нәрсиму «муқәддәс» һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Һарун билән униң оғуллирини болса Маңа каһинлиқ хизмәттә болуши үчүн мәсиһләп муқәддәс қилғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Исраилларға сөз қилип мундақ ейтқин: — Бу май әвлаттин әвлатқичә Маңа аталған муқәддәс мәсиһләш мейи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Уни адәмниң бәдинигә қуйса болмайду; шуниңдәк униңға охшайдиған яки тәркиби охшишидиған һеч қандақ майларни ясимаңлар. У муқәддәс болғини үчүн силәргиму муқәддәс болуши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Кимки тәркиби шуниңға охшайдиған май тәңшисә, яки уни елип ят бирисигә сүрсә, у өз хәлқи арисидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Пәрвәрдигар Мусаға мундақ деди: — Сән хушбуй дора-дәрмәкләр, йәни хушбуй йелим, деңиз қулулиси мейи, ақ девирқай вә сап мәстики тәйярлиғин. Буларниң һәммиси охшаш миқдарда болсун; ");
INSERT INTO uigcyr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Худди әтирчи май чиқарғанға охшаш, уларни тәңшәп хушбуй ясиғин; у тузланған, сап вә муқәддәс пурақлиқ әтир болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Сән униңдин азрақ елип, талқандәк убдан езип, җамаәт чедиридики һөкүм-гувалиқ сандуғиниң удулиға, йәни  Мән силәр билән көрүшидиған җайниң алдиға қойғин. Бу силәргә Пәрвәрдигарға аталған «әң муқәддәс нәрсиләр» қатарида һесаплансун. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Силәр ясиған бу хушбуйниң ретсепи билән өзүңларғиму охшаш бир хушбуйни ясивалсаңлар болмайду. У саңа нисбәтән ейтқанда Пәрвәрдигарға хас қилинған муқәддәс болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Кимки униң пуриғини пурап һозурлиниш үчүн униңға охшап кетидиған һәр қандақ бир хушбуйни ясиса, у өз хәлқи арисидин үзүп ташлансун. ");
INSERT INTO uigcyr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Пәрвәрдигар Худа Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Мана, Мән Өзүм Йәһуда қәбилисидин болған Хурниң нәвриси, уриниң оғли Бәзаләлни исмини атап чақирдим;    ");
INSERT INTO uigcyr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","уни Худаниң Роһи билән толдуруп, униңға даналиқ, әқил-парасәт, илим-һекмәт егилитип, уни һәртүрлүк ишни қилишқа қабилийәтлик қилип, ");
INSERT INTO uigcyr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","түрлүк-түрлүк һүнәрләрни қилалайдиған, йәни алтун, күмүч вә мис ишлирини қилалайдиған, ");
INSERT INTO uigcyr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","яқутларни кесип-оялайдиған, уларни зиннәт буюмлириға орниталайдиған, яғачларға нәқиш чиқиралайдиған, һәр хил һүнәр ишлирини қамлаштуралайдиған қилдим. ");
INSERT INTO uigcyr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Шуниңдәк мана, Мән йәнә Дан қәбилисидин Аһисамақниң оғли Оһолиябни униңға ярдәмчиликкә тайинлидим, шундақла Мән саңа буйруған һәммә нәрсиләрни ясисун дәп, барлиқ пәм-парасәтлик кишикәрниң көңлигә техиму әқил-парасәт ата қилдим; ");
INSERT INTO uigcyr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","шуниң билән улар җамаәт чедирини, һөкүм-гувалиқ сандуғини, униң үстидики кәфарәт тәхтини, чедириниң һәммә әсваплирини, ");
INSERT INTO uigcyr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ширә билән униң қача-қучилирини, сап алтундин ясилидиған чирақдан билән униң барлиқ әсваплирини, хушбуйгаһни, ");
INSERT INTO uigcyr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","көйдүрмә қурбанлиқ қурбангаһи билән униң барлиқ әсваплирини, жуюш деси билән униң тәглигини ясалайдиған, ");
INSERT INTO uigcyr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","хизмәт кийимлири, йәни каһинлиқ хизмитидә кийилидиған, Һарун каһинниң муқәддәс кийимлири вә униң оғуллириниң каһинлиқ кийимлирини тоқуялайдиған, ");
INSERT INTO uigcyr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","мәсиһләш мейи вә муқәддәс җайға тәйярлинидиған есил дора-дәрмәкләрдин хушбуйни ясалайдиған болди. Мән саңа әмир қилғиним бойичә улар барлиқ ишни беҗа кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Пәрвәрдигар Мусаға әмир қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Сән Исраилларға әмир қилип уларға: — «Силәр Мениң шабат күнлиримни чоқум тутуңлар; чүнки булар силәрниң өзүңларни пак-муқәддәс қилғучиниң Мән Пәрвәрдигар екәнлигини билишиңлар үчүн Мән билән силәрниң оттураңлардики бир нишанә-бәлгү болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Шабат күни силәргә муқәддәс қилип бекитилгини үчүн, уни тутуңлар; кимки уни бузса, өлүм җазасиға тартилмиса болмайду; бәрһәқ, кимки у күнидә һәр қандақ ишни қилса, өз хәлқи арисидин үзүп ташлансун. ");
INSERT INTO uigcyr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Алтә күн ичидә иш қилинсун; лекин йәттинчи күни Пәрвәрдигарға аталған муқәддәс күн болуп, арам алидиған шабат күни болиду; кимки шабат күнидә бирәр иш қилса, өлүм җазасиға тартилмиса болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Исраиллар шабат күнини тутуши керәк; улар әбәдий әһдә сүпитидә уни әвлаттин әвлатқичә тутсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Бу Мән билән Исраилларниң оттурисида әбәдий бир нишанә-бәлгү болиду; чүнки Пәрвәрдигар алтә күн ичидә асман билән зиминни яритип, йәттинчи күнидә арам елип раһәт тапқан еди», — дегин. ");
INSERT INTO uigcyr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Худа Синай теғида Мусаға бу сөзләрни қилип болғандин кейин, икки һөкүм-гувалиқ тахтийини униңға тапшурди. Тахтайлар таштин болуп, сөзләр Худаниң бармиғи билән уларға пүтүлгән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Хәлиқ Мусаниң тағдин чүшмәй һаял болуп қалғинини көрүп, Һарунниң қешиға жиғилип униңға: — Сән қопуп, бизгә алдимизда йол башлап маңидиған бир илаһ ясап бәргин! Чүнки бизни Мисир зиминидин чиқирип кәлгән Муса дегән һелиқи кишигә немә болуп кәткәнлигини билмәймиз, — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Һарун уларға: — Хотунлириңлар билән оғул-қизлириңларниң қулақлиридики алтун зирә һалқиларни чиқирип, мениң қешимға елип келиңлар, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Шуниң билән пүткүл хәлиқ өз қулақлиридики алтун зирә һалқиларни чиқирип Һарунниң қешиға елип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","У буларни уларниң қолидин елип, искинә билән қуйма бир мозайни ясатқузди. Шуниң билән улар: — Әй Исраил, сени Мисир зиминидин чиқирип кәлгән Худайиңлар мана будур! — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Һарун уни көрүп униң алдида бир қурбангаһни яситип андин: «Әтә Пәрвәрдигар үчүн бир һейт өткүзүлиду», дәп елан қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Әтиси улар сәһәр қопуп, көйдүрмә қурбанлиқларни сунуп, енақлиқ қурбанлиқлириниму кәлтүрди; андин халайиқ олтирип йәп-ичишти, қопуп әйш-ишрәт қилишти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Шу чағда Пәрвәрдигар Мусаға: — Орнуңдин тур, тездин пәскә чүшкин! Чүнки сән Мисир зиминидин чиқирип кәлгән хәлқиң бузуқчилиққа берилип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Мән уларға буйруған йолдин шунчә тезла чәтнәп, өзлири үчүн бир қуйма мозайни ясап, униңға чоқунуп қурбанлиқ кәлтүрүшти һәмдә: «Әй Исраил, сени Мисир зиминидин чиқирип кәлгән Худайиң мана шудур!», дейишти, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Андин Пәрвәрдигар Мусаға: — Мана, бу хәлиқни көрүп қойдум; мана, улар дәрвәқә бойни қаттиқ бир хәлиқтур. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Әнди Мени тосма, Мән ғәзәп отумни уларниң үстигә чүшүрүп, уларни жутуветимән; андин сени улуқ бир әл қилимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Лекин Муса Худаси Пәрвәрдигардин өтүнүп илтиҗа қилип мундақ деди: — Әй Пәрвәрдигар, немишкә сән ғәзәп отуңни Өзүң зор қудрәт вә күчлүк қол билән Мисир зиминидин чиқирип кәлгән хәлқиңниң үстигә чүшүрисән? ");
INSERT INTO uigcyr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Мисирлиқлар мазақ қилип: — Уларниң бешиға бала чүшүрүш үчүн, уларни тағларниң үстидә өлтүрүп йәр йүзидин йоқитиш үчүн, уларниң Худаси уларни елип кәтти, — дейишсунму? Өз отлуқ ғәзивиңдин йенип, Өз хәлқиңгә балаю-апәт кәлтүрүш нийитиңдин янғайсән! ");
INSERT INTO uigcyr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Өз қуллириң Ибраһим, Исһақ вә Исраилни яд қилғин; Сән уларға қәсәм билән вәдә қилип: «Нәслиңларни асмандики юлтузлардәк көпәйтимән, Өзүм униң тоғрисида сөзлигән мошу зиминниң һәммисини нәслиңларға беримән, улар униңға мәңгү егидарчилиқ қилидиған болиду» дегән едиңғу, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Шуниң билән Пәрвәрдигар Өз хәлқиниң үстигә: «Балаю-апәт чүшүримән» дегән нийитидин янди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Муса кәйнигә бурулуп, икки һөкүм-гувалиқ тахтийини қолиға елип тағдин чүшти. Тахтайларниң икки тәрипигә сөзләр пүтүлгән еди; у йүзигиму, бу йүзигиму пүтүклүк еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Бу тахтайлар болса Худаниң Өзиниң ясиғини, пүтүлгәнлири болса Худаниң Өзиниң пүткини еди, у тахтайларға оюлған еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Йәшуа хәлиқниң көтәргән чуқан-сүрәнлирини, вақирашлирини аңлап Мусаға: — Чедиргаһдин җәңниң хитаби чиқиватиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Лекин у җавап берип: — Аңлиниватқан аваз нә нусрәт тәнтәниси әмәс, нә мәғлубийәтниң пәряди әмәс, бәлки нахша-күй садаси! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Муса чедиргаһға йеқин келип, мозайни вә җамаәтниң уссулға чүшүп кәткәнлигини көрүп шундақ дәрғәзәп болдики, тахтайларни қолидин ташлап тағниң түвидә чеқивәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Андин улар ясиған мозайни отқа селип көйдүрүп, уни янчип кукум-талқан қилип, су үстигә чечип Исраилларни ичишкә мәҗбурлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Андин Муса Һарунға: Сән уларни шунчә еғир гунаға патқузғидәк, мошу хәлиқ саңа немә қилди? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Һарун җавап берип: — Ғоҗамниң ғәзәп-аччиғи туташмиғай! Бу хәлиқниң қандақ екәнлигини, уларниң зәзилликкә майил екәнлигини убдан билисән. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Улар маңа: — «Бизгә алдимизда йол башлап маңидиған бир илаһни ясап бәргин; чүнки бизни Мисир зиминидин чиқирип кәлгән Муса дегән шу адәмгә немә болғинини билмәймиз», деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Мән уларға: «Кимдә алтун болса шуни чиқирип бәрсун» десәм, улар маңа тапшуруп бәрди; мән уни отқа ташливидим, мана, бу мозай чиқти, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Муса хәлиқниң қандақсигә тизгинсиз болуп кәткәнлигини көрди; чүнки Һарун уларни дүшмәнлириниң алдида мәсқирә объекти болушқа өз мәйлигә қоювәткән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Муса чедиргаһниң кириш еғизиға берип, шу йәрдә туруп: — Кимки Пәрвәрдигарниң тәрипидә болса мениң йенимға кәлсун! — деди. Шуни девиди, Лавийларниң һәммиси униң қешиға жиғилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","У уларға: — Исраилниң Худаси Пәрвәрдигар мундақ дәйду: — «Һәр бир киши өз қиличини янпишиға есип, чедиргаһниң ичигә кирип, бу четидин у четигичә кезип жүрүп, һәр бири өз қериндишини, өз дост-бурадирини, өз хошнисини өлтүрсун!» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Шуниң билән Лавийлар Мусаниң буйруғини бойичә иш көрди; шу күни хәлиқниң ичидин үч миң киши өлтүрүлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Андин Муса: — Һәр бириңлар бүгүн өзүңларни Пәрвәрдигарға хас болушқа атидиңлар; чүнки һәр бириңлар һәтта өз оғлуңлар һәм қериндишиңларниму айимидиңлар; шуниң билән бүгүн бәхит-бәрикәтни үстүңларға чүшүрдуңлар, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Әтиси Муса хәлиққә сөз қилип: — Силәр дәрвәқә наһайити еғир бир гуна садир қилдиңлар. Әнди мана, мән Пәрвәрдигарниң алдиға чиқимән; гунайиңлар үчүн кәфарәт кәлтүрәләймәнмекин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Шуниң билән Муса Пәрвәрдигарниң алдиға йенип берип: — Һәй...! Бу хәлиқ дәрвәқә еғир бир гуна садир қилип, өзлиригә алтундин илаһларни ясапту! ");
INSERT INTO uigcyr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Лекин әнди Сән уларниң гунайини әпу қилишқа униғайсән..., унимисаң, исмимни Өзүң язған дәптириңдин өчүрүвәткин! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Пәрвәрдигар Мусаға җавап берип: — Кимки Мениң алдимда гуна қилған болса, униң етини Өз дәптиримдин өчүрүветимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Әнди сән берип, Мән саңа ейтқан җайға хәлиқни башлап барғин. Мана, Мениң Пәриштәм алдиңда маңиду. Лекин уларға җаза беридиған күнүм кәлгәндә, уларға гунайи үчүн җаза беримән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Бу сөздин кейин Пәрвәрдигар хәлиқниң Һарунниң қоли билән мозайни қуйдуруп ясатқини үчүн уларни ваба билән җазалиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Пәрвәрдигар Мусаға мундақ деди: — Сән орнуңдин туруп, өзүң Мисир зиминидин елип кәлгән хәлиқ билән биллә мошу йәрдин кетип: «Мән сениң нәслиңгә уни беримән» дәп қәсәм қилип Ибраһимға, Исһаққа вә Яқупқа вәдә қилған зиминға барғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Шуниң билән сениң алдиңда бир Пәриштә әвәтип, Ⱪананий, аморий, Һиттий, пәриззийләрни, һивий билән йәбусийларни һайдап чиқирип, ");
INSERT INTO uigcyr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","сени сүт билән һәсәл еқип туридиған зиминға кәлтүримән. Чүнки силәр бойни қаттиқ бир хәлиқ болғачқа, йолда силәрни һалак қиливәтмәслигим үчүн, Өзүм силәрниң араңларда болуп, шу зиминға биллә чиқмаймән, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Халайиқ бу қаттиқ сөзни аңлап, қайғуға чөмүп һеч қайсиси өз зибу-зиннәтлирини тақимиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Чүнки Пәрвәрдигар Мусаға сөз қилип: — Сән берип Исраилларға: «Пәрвәрдигар: — Силәр бойни қаттиқ бир хәлиқ екәнсиләр; әгәр Мән Пәрвәрдигар араңларға чиқип бир дәқиқила турсам, силәрни йоқитивәткән болаттим. Әнди силәр өзүңлардики зибу-зиннәтләрни еливетиңлар; шу чағда Мән силәргә немә қилидиғинимни билимән, деди», дәп ейтқин, — дегән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Шуңа Исраиллар Һорәб теғидин айрилипла зибу-зиннәтлирини өзлиридин еливәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Шуниң билән Муса өз чедирини елип, уни чедиргаһниң сиртида, чедиргаһдин нерирақ бир җайға тикип, уни «көрүшүш чедири» дәп атиди. Кимки Пәрвәрдигарни издәп, йол соримақчи болса чедиргаһниң сиртидики «көрүшүш чедири»ға баратти. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Шундақ болаттики, һәр қетим Муса чедирға чиқса, пүткүл халайиқ қопуп, һәр бири өз чедириниң ишигидә өрә туруп, Муса чедирға кирип болғичә униң кәйнидин қаришип туратти. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Андин Муса һәр қетим чедирға кирип кәтсә шундақ болаттики, булут түврүги чүшүп, чедирниң кириш еғизида тохтайтти; шуниң билән Пәрвәрдигар Муса билән сөзлишәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Пүткүл халайиқ булут түврүгиниң җамаәт чедириниң кириш еғизида тохтиғинини көрәтти; уни көргинидә хәлиқниң һәммиси қопуп, һәр бири өз чедириниң ишигидә туруп сәҗдә қилишатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Шу чағларда Пәрвәрдигар Муса билән кишиләр өз дост-бурадири билән сөзләшкәндәк, йүзму-йүз сөзлишәтти. Андин Муса чедиргаһға йенип келәтти; лекин униң хизмәткари болған Нунниң оғли Йәшуа дегән яш жигит чедирниң ичидин чиқмайтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Муса Пәрвәрдигарға мундақ деди: — Мана, Сән дайим маңа: «Бу хәлиқни елип чиққин» дәп кәлдиң; лекин Өзүң маңа: «Мән сени исмиңни билип тонуймән», вә шуниңдәк «Нәзирим алдида илтипат таптиң» дегән болсаңму, Сән мениң билән биргә кимни әвәтидиғиниңни маңа аян қилмидиң. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Әгәр мән растинла нәзириңдә илтипат тапқан болсам, өзүмниң Сени тонушум үчүн, нәзириңдә илтипат тепиверишим үчүн маңа Өз йолуңни аян қилғайсән; мана, бу хәлиқниң Өз хәлқиң болғинини нәзириңдә тутқайсән! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","У җавап берип: Мән Өзүм сән биллә биллә берип, саңа арам ата қилимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Муса униңға җававән: — Әгәр Сән Өзүң биз билән биллә маңмисаң, бизни бу йәрдин чиқармиғайсән; ");
INSERT INTO uigcyr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","чүнки, мән вә хәлқиң нәзириңдә илтипат тапқинимиз немидин билиниду? Әҗәба, Өзүңниң биз билән биллә маңғиниңдин билинмәмду? Шу сәвәптин мән вә хәлқиң йәр йүзидики һәр бир таипиләрдин алаһидә пәриқләнмәмдуқ?! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Пәрвәрдигар Мусаға: — Мошу илтиҗайиңниму иҗабәт қилимән; чүнки сән нәзиримдә илтипат таптиң вә Мән сени исмиңни билип тонуймән, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Шуниң билән Муса: — Өз шан-шәрпиңни маңа көрсәткәйсән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Пәрвәрдигар: — Өзүмниң пүткүл меһриванлиғимни сениң көз алдиңдин өткүзимән вә алдиңда «Яһвәһ» дегән намни җакалаймән. Кимгә шапаәт қилмақчи болсам шуниңға шапаәт көрситимән, кимгә рәһим-шәпқәт көрсәтмәкчи болсам, шуниңға рәһим-шәпқәт көрситимән, деди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Пәрвәрдигар униңға: — Сән йүзүмни көрәлмәйсән; чүнки һеч адәмзат Мени көрсә тирик қалмайду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Андин Пәрвәрдигар: — Мана, йенимда бир җай бардур; сән шу йәрдики қорам ташниң үстидә турғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Мениң шан-шәривим өтидиған вақитта, шундақ болидуки, Мән сени шу қорам ташниң йериқида турғузуп, Мән өтүп болғичә сени қолум билән йепип туримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Андин қолумни тартивалимән; шуниң билән сән Мениң арқа тәрипимни көрисән, лекин йүзүм көрүнмәйду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Пәрвәрдигар Мусаға: — Сән авалқиға охшаш өзүң үчүн таштин икки тахтайни йонуп кәл; Мән бу тахтайларға сән илгири чеқивәткән тахтайлардики сөзләрни йезип қойимән. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Сән әтә әтигәнгичә тәйяр болуп, сәһәрдә Синай теғиға чиқип, шу йәрдә тағниң чоққисида Мениң алдимда һазир болғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Лекин һеч киши сән билән биллә чиқмисун вә яки тағниң һеч йеридә башқа адәм көрүнмисун, қой-калиларму тағниң түвидә отлимисун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Муса авалқиға охшаш таштин икки тахтайни йонуп, әтиси таң сәһәр қопуп, бу икки таш тахтайни қолида елип, Пәрвәрдигарниң буйруғини бойичә Синай теғиға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Шуниң билән Пәрвәрдигар булутта чүшүп, шу йәрдә Мусаниң қешида туруп, «Яһвәһ» дегән намини җакалиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Пәрвәрдигар униң көз алдидин өтүп: — «Пәрвәрдигар, Пәрвәрдигар, рәһимдил вә меһир-шәпқәтликтур, асан ғәзәпләнмәйдиған, шапаәт билән вапаси кәң Тәңридур,    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","миңлиған-он миңлиғанларға рәһим-шапаәт көрситип, қәбиһлик, асийлиқ вә гунани кәчүргүчидур; лекин у гунакарларни һәргиз гунасиз дәп қаримайдиған, бәлки атиларниң қәбиһлигиниң җазасини балилири вә нәврлиригичә, шундақла үчинчи вә төртинчи әвладиғичә жүкләйдиған Тәңридур» — дәп җакалиди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Шуниң билән Муса дәрһал йәргә баш қоюп сәҗдә қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","— Әй Рәб, әгәр мән растинла нәзириңдә илтипат тапқан болсам, ундақта и Рәб, аримизда биз билән маңғайсән; чүнки бу хәлиқ дәрвәқә бойни қаттиқ бир хәлиқтур; бизниң қәбиһлигимизни вә гунайимизни кәчүргәйсән, бизни Өз мирасиң болушқа қобул қилғайсән! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Шуниң билән у Мусаға: — Мана, Мән бир әһдә түзимән; сениң барлиқ хәлқиң алдида пүткүл йәр йүзиниң һеч бир җайида яки һеч бир әл арисида қилинип бақмиған мөҗизиләрни яритимән. Шуниң билән сән арисида болған хәлқиңниң һәммиси Пәрвәрдигарниң карамәт әмәлини көриду; чүнки Мениң силәргә қилидиған әмәлим дәрвәқә дәһшәтлик иш болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Мән бүгүн саңа тапилайдиған әмирлиримни тутқин; мана, Мән силәрниң алдиңлардин Аморий, Ⱪананий, Һиттий, Пәриззий, Һивий вә Йәбусийларни һайдап чиқиримән. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Әнди һези болғинки, сән баридиған зиминда туруватқанлар билән һеч әһдә бағлашмиғин; болмиса, бу иш силәргә қапқан болиду; ");
INSERT INTO uigcyr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","бәлки силәр уларниң қурбангаһлирини чувуп, бут түврүклирини сундуруп, «ашәраһ» бутлирини кесип ташлаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Чүнки сән һеч қандақ башқа илаһқа ибадәт қилмаслиғиң керәк — чүнки Мәнки Пәрвәрдигарниң нами «Вапасизлиққа Һәсәт Қилғучи» болуп, һәсәт қилғучи бир илаһдурмән. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Болмиса, шу зиминда туруватқанлар билән әһдә түзүшүң мүмкин; андин улар илаһлириниң кәйнидин жүрүп бузуқчилиқ қилип, илаһлириға қурбанлиқлар өткүзгинидә, силәрни чақирса уларниң қурбанлиқлиридин йәп кетишиңлар мүмкин; ");
INSERT INTO uigcyr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","сән шундақла йәнә уларниң қизлирини оғуллириңға хотунлуққа елип беришиң мүмкин; у қизлар өз илаһлириниң кәйнидин жүрүп бузуқчилиқ қилғинида, улар оғуллириңниму өз илаһлириниң арқисидин маңғузуп, бузуқчилиқ қилдуруши мүмкин. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Өзүң үчүн һеч қандақ қуйма бутларни ясатмиғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Петир нан һейтини тутуңлар; Мениң әмир қилғинимдәк Абиб ейида, бекитилгән вақитта йәттә күн петир нан йәңлар. Чүнки силәр Абиб ейида Мисирдин чиққансиләр. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Балиятқуниң тунҗа мевиси Мениңки болиду; чарпай маллириңниң ичидин дәсләп туғулған әркәкләр, кала болсун, қой болсун уларниң тунҗилириниң һәммиси Мениңки болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Лекин ешәкләрниң тунҗа тәхәйлириниң орниға қоза билән бәдәл төлишиң лазим болиду. Әгәр орниға қоза бәрмисәң, тәхәйниң бойнини сундурувәткин. Тунҗи оғуллириңни болса, уларға бәдәл төләп қайтурувал. Һеч ким Мениң һозурумға қуруқ қол кәлмисун.    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Сән алтә күн ичидә иш-әмәлиңни қилип, йәттинчи күни арам елишиң зөрүр; йәр һайдаш вақти болсун, орма вақти болсун, арам елишиң зөрүр. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Йеңи буғдайниң тунҗа һосулини тәбрикләйдиған «һәптиләр һейти»ни өткүзүңлар; жилниң ахирида «һосул жиғиш һейти»ни өткүзүңлар.    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Сениң һәр бир әркәк кишилириң жилда үч қетим Исраилниң Худаси болған Рәб Пәрвәрдигарниң алдиға һазир болсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Чүнки Мән таипиләрни алдиңдин һайдиветип, чегаралириңни кеңәйтимән; шуниңдәк сән жилда үч қетим Пәрвәрдигар Худайиңниң алдиға һазир болушқа чиқип барсаң, һеч ким йериңгә көз қирини салмайду. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Маңа сунулидиған қурбанлиқниң қенини болдурулған нан билән биллә сунмиғин; яки өтүп кетиш һейтиниң қурбанлиғиниң гөшини әтигә қалдурма.    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Зиминиңниң дәсләпки һосулидин тунҗа мәһсулатларни Пәрвәрдигар Худайиңниң өйигә кәлтүрүп ата. Оғлақни анисиниң сүтидә қайнитип пишарма.    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Пәрвәрдигар Мусаға: — Бу сөзләрни өзүң үчүн йезивалғин; чүнки Мән мошу сөзләрни асас қилип сән билән вә Исраил билән әһдә бағлидим, деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","У вақитта Муса шу йәрдә Пәрвәрдигарниң һозурида қириқ кечә-күндүз турди; у һеч нәрсә йемиди, һеч су ичмиди. У йәрдә Пәрвәрдигар тахтайларға әһдиниң сөзлири болған он әмирни пүтти.    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Муса Синай теғидин чүшкәндә шундақ болдики (у тағдин чүшкәндә икки һөкүм-гувалиқ тахтийи униң қолида еди), өзиниң Пәрвәрдигар билән сөзләшкини үчүн йүзиниң пақирап кәткинини билмәйтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Әнди Һарун вә барлиқ Исраиллар Мусани көрди, мана, униң йүз териси пақирап туратти; улар униңға йеқин бериштин қорқушти. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Лекин Муса уларни чақиривиди, Һарун вә җамаәтниң барлиқ башлири йенип, униң қешиға кәлди; Муса улар билән сөзләшти. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Шуниңдин кейин, барлиқ Исраиллар униң йениға кәлди; у вақитта Муса Пәрвәрдигар өзигә Синай теғида сөз қилғинида тапшурған барлиқ әмирләрни уларға тапилиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Муса уларға дәйдиғинини дәп түгәтти. У сөзлигәндә йүзигә бир чүмпәрдә тартивалған еди;    ");
INSERT INTO uigcyr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Қачанки Муса Пәрвәрдигар билән сөзлишишкә униң һозуриға кирсә, чүмпәрдини еливетәтти, таки у йенип чиққичә шундақ болатти; йенип чиққанда өзигә немә тапиланған болса, шуни Исраилларға ейтип берәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Исраиллар Мусаниң йүз терисиниң пақирап турғинини көрәтти; шуңа Муса йәнә таки Пәрвәрдигар билән сөзләшкили униң һозуриға киргичә йүзигә чүмпәрдә тартивалатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Муса Исраилларниң пүткүл җамаитини жиғип уларға: — Пәрвәрдигар силәргә қилишқа буйруған әмирләр мунулардур: — ");
INSERT INTO uigcyr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Алтә күн иш-әмгәк күни болсун; лекин йәттинчи күни силәргә нисбәтән муқәддәс бир күн болуп, Пәрвәрдигарға аталған арам алидиған шабат күни болсун. Һәр ким шу күнидә иш-әмгәк қилса өлүмгә мәһкүм қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Шабат күнидә барлиқ туралғулириңларда һәргиз от қалимаңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Муса Исраилларниң пүткүл җамаитигә сөз қилип мундақ деди: — «Пәрвәрдигар буйруған әмир мана шуки: — ");
INSERT INTO uigcyr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Өзүңларниң араңлардин Пәрвәрдигарға бир «көтәрмә һәдийә» кәлтүрүңлар; көңли халиғанларниң һәр бири Пәрвәрдигарға бир «көтәрмә һәдийә»сини кәлтүрсун: йәни алтун, күмүч, мис, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","көк, сөсүн вә қизил жип, ақ канап рәхт, өшкә тивити, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","қизил боялған қочқар териси, делфин териси, акатсийә яғичи, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","чирақдан үчүн зәйтун мейи, «мәсиһләш мейи» билән хушбуй үчүн ишлитилидиған есил дора-дәрмәкләр, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","әфодқа һәм қошенға орнитилидиған һеқиқ вә башқа яқутларни кәлтүрүңлар». ");
INSERT INTO uigcyr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","— «Араңлардики барлиқ маһир устилар келип Пәрвәрдигар буйруғанниң һәммисини ясап бәрсун: ");
INSERT INTO uigcyr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","— муқәддәс чедир билән униң ички вә ташқи йопуқлирини, илғулирини, тахтайлирини, балдақлирини, хадилирини вә буларниң тәгликлирини, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","әһдә сандуғи вә униң балдақлирини, «кәфарәт тәхти»ни, «айрима пәрдә-йопуқ»ни, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ширә вә униң балдақлирини, униң барлиқ қача-қучилирини вә «тәқдим нанлири»ни, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","йоруқлуқ үчүн ясалған чирақдан вә униң әсваплирини, униң чирақлири вә чирақ мейини, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","хушбуйгаһ вә униң балдақлирини, «Мәсиһләш мейи»ни, дора-дәрмәкләрдин ишләнгән хушбуйни, муқәддәс чедириниң кириш еғизидики «ишик пәрдиси»ни, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","көйдүрмә қурбанлиқ қурбангаһи вә униң мис шаласини, балдақлирини вә барлиқ әсваплирини, жуюнуш деси вә униң тәглигини, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","һойлиниң пәрдилирини, униң хадилири вә уларниң тәгликлирини, һойлиниң кириш еғизидики пәрдини, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","чедирниң миқ-қозуқлирини, һойлиниң миқ-қозуқлирини, шундақла барлиқ танилирини, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","тоқулидиған кийимләр, йәни муқәддәс җайниң хизмитигә каһинлиқ хизмитидә кийилидиған, Һарун каһинниң муқәддәс кийимлирини һәм униң оғуллириниң кийимлирини тәйяр қилсун».    ");
INSERT INTO uigcyr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Шуниң билән пүткүл Исраил җамаити Мусаниң йенидин чиқип кетишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Андин көңли тартқанларниң һәр бири, роһи өзлиригә түрткә болғанларниң һәр бири келип, җамаәт чедирини ясашқа, шундақла чедирниң хизмитидә ишлитилидиған барлиқ сәрәмҗанларни ясашқа вә муқәддәс кийимләрни тикишкә Пәрвәрдигарға аталған «пулаңлатма һәдийә»ни кәлтүргили турди. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Улар әрләрму, аялларму келип, сунушқа көңли хуш болғанларниң һәр бири һәдийә кәлтүрүп, булапка, зирә-һалқа, үзүк, зуннар-биләйүзүк қатарлиқ һәр хил алтун буюмларни елип кәлди; алтунни «көтәрмә һәдийә» қилип берәй дегәнләрниң һәр бири уни Пәрвәрдигарға сунди. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Кимдә көк, сөсүн, қизил жип билән ақ канап рәхт, өшкә тивити, қизил боялған қочқар териси вә делфин териси болса, шуларни елип келишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Күмүч я мистин көтәрмә һәдийә кәлтүрәй дегәнләрниң һәр бири шуни Пәрвәрдигарға һәдийә қилип сунди. Кимдә чедирниң хизмитидә ишлитилидиған һәр хил сәрәмҗанларға яриғидәк акатсийә яғичи болса, уни елип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Қоли чевәр аялларниң һәр бири өз қоллири билән егирип, шу егиргән жип вә рәхтләрни, йәни көк, сөсүн вә қизил жип билән ақ канап рәхтләрни кәлтүрди,    ");
INSERT INTO uigcyr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Шуниңдәк көңли қозғалған аялларниң һәммиси һүнирини ишлитип өшкә тивитидин жип егиришти. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Әмирләр әфод вә қошенға орнитилидиған һеқиқлар вә яқутларни, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","дора-дәрмәкләрни, чираққа вә мәсиһләш мейиға ишлитилидиған зәйтун мейини, хушбуйға ишлитилидиған есил дора-дәрмәкләрни кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Шу тәриқидә Исраиллар Пәрвәрдигар Мусаниң вастиси билән буйруған ишларниң һәр қайсиға бир нәрсә беришкә көңли тартқан болса, әр болсун аял болсун һәр бири шуни елип келип, Пәрвәрдигарға атап ихтиярий һәдийә бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Андин Муса Исраилларға мундақ деди: — «Мана, Пәрвәрдигар Йәһуда қәбилисидин хурниң нәвриси, Уриниң оғли Бәзаләлни исмини атап чақирип,    ");
INSERT INTO uigcyr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","уни Худаниң Роһи билән толдуруп, униңға даналиқ, әқил-парасәт, илим-һекмәт егилитип, уни һәртүрлүк ишни қилишқа қабилийәтлик қилип, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","уни түрлүк-түрлүк һүнәрләрни қилалайдиған — алтун, күмүч вә мис ишлирини қилалайдиған, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","яқутларни кесип-оялайдиған, зиннәт буюмлириға орниталайдиған, яғачларға нәқиш чиқиралайдиған, һәр хил һүнәр ишлирини қамлаштуралайдиған қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","У йәнә униң көңлигә, шуниңдәк һәм Дан қәбилисидин болған Аһисамақниң оғли Оһолиябниң көңлигә башқиларға һүнәр үгитиш нийәт-истикини селип, ");
INSERT INTO uigcyr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","уларниң көңүллирини даналиқ-һекмәт билән толдуруп, уларни һәр хил нәққашлиқ-оймичилиқ ишлириға маһир қилип, көк, сөсүн вә қизил жип билән ақ канап рәхт билән кәштичилик қилишқа һәмдә бапкарлиққа иқтидарлиқ қилди. Шуниң билән улар һәр хил һүнәр ишлириниң вә һәр хил лайиһиләш ишлириниң һөддисидин чиқалайдиған болди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Шуниң билән Бәзаләл вә Оһолияблар, шуниңдәк Пәрвәрдигар муқәддәс чедир ясашниң һәр хил ишлириға керәк болған даналиқ-һекмәт вә әқил-парасәтни ата қилған маһир устиларниң һәр бири уларға қошулуп, шу ишни униң әмир қилғини бойичә әмәлгә ашуриду». ");
INSERT INTO uigcyr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Шу вақитта Муса Бәзаләл вә Оһолиябни, шундақла Пәрвәрдигар даналиқ-һекмәт билән көңүллирини толдурған, көңли өзини шу ишни қилишқа қатнишишқа далаләт қилған барлиқ һүнәрвән-касипларни чақирип жиғди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Улар келип муқәддәс чедирни ясашқа, шундақла униң иш-хизмәтлиригә керәклик сәрәмҗанларни ясашқа Исраиллар елип кәлтүргән барлиқ «көтәрмә һәдийә»ләрни Мусадин тапшурувалди. Исраил хәлқи йәнила өз мәйли билән һәр күни әтигини Мусаға ихтиярий һәдийә кәлтүрүп туратти. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Андин муқәддәс чедирниң ишлирини қиливатқан устиларниң һәммиси қолидики ишини қоюп қоюп келип, ");
INSERT INTO uigcyr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Мусаға: — Хәлиқниң елип кәлгини Пәрвәрдигар бизгә қилишқа буйруған ишни пүткүзүшкә еһтияҗ болғинидин көп ешип кәтти! — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Андин Муса әмир қилип, пүткүл чедиргаһ бойичә: «Мана, әр болсун, аял болсун, һеч ким муқәддәс чедирни ясаш үчүн «көтәрмә һәдийә» сүпитидә йәнә һеч қандақ нәрсә тәйярлап кәлмисун!» дәп җакалатти. Буниң билән көпчилик һәдийәләр кәлтүрүштин тохтитилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Чүнки улар тәйярлиған материяллар пүткүл қурулуш ишиға йетәтти, һәтта ешип қалатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Муқәддәс чедирниң қурулуш ишини қиливатқан устиларниң һәр бири непиз тоқулған ақ канап рәхткә көк, сөсүн вә қизил жиплар арилаштурулуп ишләнгән он парчә йопуқ ясап, керубларниң сүритини йопуқларға чевәрлик билән лайиһиләп нәпис қилип кәштиләп чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Һәр бир йопуқниң узунлуғи жигирмә сәккиз гәз, кәңлиги төрт гәз болуп, һәр бир йопуқ охшаш чоң-кичикликтә қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Бәзаләл йопуқларниң бәшини бир-биригә улиди, қалған бәш йопуқниму һәм бир-биригә улиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","У улап чиқилған биринчи чоң парчиниң әң четидики қисминиң бир тәрипигә рәңги көк измиләрни қадиди, шуниңдәк улап чиқилған иккинчи чоң парчиниң әң четидикисиниң бир тәрипигиму шундақ қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Биринчи чоң парчиниң әң четидики қисмиға әллик измә қадиди, иккинчи чоң парчиниң әң четидикисигиму әллик измә қадиди. Измиләр бир-биригә удулмуудул қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Муқәддәс чедир бир пүтүн болсун үчүн у алтундин әллик илғу ясап, икки парчә йопуқни шу илғулар билән бир-биригә туташтурди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","У муқәддәс чедирни йепиш үчүн өшкә тивитидин йопуқларни ясиди; йопуқтин он бир парчә ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Йопуқларниң һәр бириниң узунлуғи оттуз гәз, кәңлиги төрт гәз болуп, он бир йопуқниң һәммиси охшаш чоң-кичикликтә қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Йопуқларниң бәшини у улап бир қилип, қалған алтә йопуқниму улап бир қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","У биринчи улап чиқилған чоң парчиниң әң четидики қисмиға әллик измә, иккинчи улап чиқилған чоң парчиниң әң четидики қисмиға әллик измә қадиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","У чедир бир пүтүн болсун үчүн һәм мистин әллик илғу ясап, икки чоң парчини улап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","У буниңдин башқа чедирға қизил боялған қочқар терисидин йопуқ ясап япти, андин униң үстидинму делфин терисидин ясалған йәнә бир йопуқни қаплиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","У муқәддәс чедирниң тик тахтайлирини акатсийә яғичидин ясап тиклиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Һәр бир тахтайниң узунлуғи он гәз, кәңлиги бир йерим гәз қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Һәр бир тахтайниң иккидин туруми бар еди, һәр икки тахтай шулар билән бир-биригә четилди; у чедирниң барлиқ тахтайлирини шундақ ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","У чедирниң тахтайлирини шундақ ясиди; жигирмиси җәнуп тәрәпкә орнитилди; ");
INSERT INTO uigcyr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","у бу жигирмә тахтайниң тегигә күмүчтин қириқ тәглик ясиди; бир тахтайниң астидики икки туруми үчүн иккидин тәглик, йәнә бир тахтайниң икки туруми үчүн иккидин тәгликни ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Шуниңдәк у чедирниң удул тәрипигә, йәни шимал тәрипигә жигирмә тахтай ясиди, ");
INSERT INTO uigcyr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","шундақла буларниң қириқ тәглигини күмүчтин ясиди; бир тахтайниң тегигә иккидин тәглик, йәнә бир тахтайниң тегигә иккидин тәглик орунлаштурулди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Чедирниң кәйни тәрипигә, йәни ғәрип тәрәпкә алтә тахтайни ясап орнатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","У чедирниң кәйни тәрипидики икки булуңға икки тахтайни ясап орнатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Бу булуң тахтайлири астидин үстигичә икки қат қилип тахтайларни өз ара четиштурди, үсти бир һалқиға бекитилди. У һәр иккисини шундақ ясап, икки булуңға орнатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Шуңлашқиму у тәрипидә сәккиз тахтай болди, уларниң күмүчтин ясалған он алтә тәглиги бар еди; бир тахтайниң тегидә икки тәглик, йәнә бир тахтайниң тегидә икки тәглик бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Буниңдин башқа у акатсийә яғичидин балдақ ясиди; чедирниң бу тәрипидики тахтайларға бәш балдақни, ");
INSERT INTO uigcyr_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","чедирниң у тәрипидики тахтайларға бәш балдақни, чедирниң арқа тәрипидики тахтайларға, йәни ғәрип тәрипидики тахтайларғиму бәш балдақни ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","У тахтайларниң оттуридики оттура балдақни бу тәрәптин у тәрәпкә йәткүзүп ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","У тахтайларни алтун билән қаплап, балдақлар өткүзүлидиған һалқиларни алтундин ясап, балдақларни алтун билән қаплиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","У непиз тоқулған ақ канап рәхткә көк, сөсүн вә қизил жиплар арилаштурулуп ишләнгән бир пәрдә ясиди; уни керубларниң сүритини чевәрлик билән лайиһиләп нәпис қилип чүшүрүп, кәштиләп чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Уни есишқа у акатсийә яғичидин төрт хада ясап, алтун билән қаплиди. Уларниң илмәклири алтундин ясалди; хадиларға у күмүчтин төрт тәгликни қуюп ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","У чедирниң кириш еғизиға нәпис тоқулған ақ канап рәхткә көк, сөсүн вә қизил жиплар арилаштурулуп ишләнгән бир пәрдә ясиди, уни кәштичигә кәштиләтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","У йәнә бу пәрдиниң бәш хадисини илмәклири билән қошуп ясиди; уларниң башлирини вә балдақлирини алтун билән қаплиди; уларниң бәш тәглиги мистин ясалди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Андин Бәзаләл әһдә сандуғини акатсийә яғичидин ясиди; униң узунлуғи икки йерим гәз, егизлиги бир йерим гәз, кәңлиги бир йерим гәз еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","У униң ичи вә сиртини сап алтун билән қаплиди, униң үстүнки қисминиң чөрисигә алтундин гирвәк чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","У униң үчүн алтундин төрт һалқа қуюп, уларни униң төрт четиқиға бекитти; бир тәрипигә икки һалқа, йәнә бир тәрипигә икки һалқа бекитти. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","У һәм акатсийә яғичидин икки балдақ ясап, һәр иккисини алтун билән қаплиди; ");
INSERT INTO uigcyr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","андин сандуқ улар арқилиқ көтирилсун дәп, балдақларни сандуқниң икки йенидики һалқилиридин өткүзүп қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","У сандуқниң япқучи сүпитидә алтундин узунлуғи икки йерим гәз, кәңлиги бир йерим гәз болған бир «кәфарәт тәхти» ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","У икки керубни алтундин соқуп ясиди; уларни кәфарәт тәхтиниң икки тәрипигә орнатти; ");
INSERT INTO uigcyr_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","бир керубни бир тәрипигә, йәнә бир керубни йәнә бир тәрипигә орнатти. У икки тәрипидики керубларни кәфарәт тәхти билән бир гәвдә қилди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Керублар бир-биригә йүзлинип, қанатлирини кәфарәт тәхтиниң үстигә керип, қанатлири билән уни йепип туратти; керубларниң йүзи кәфарәт тәхтигә қаритилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","У һәм ширәни акатсийә яғичидин ясиди; униң узунлуғи икки гәз, кәңлиги бир гәз, егизлиги бир йерим гәз еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","У уни сап алтун билән қаплап, униң үстүнки қисминиң чөрисигә алтундин гирвәк чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","У ширәниң чөрисигә төрт илик егизликтә бир ләв ясиди; бу ләвниң чөрисигиму алтундин бир гирвәк чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","У ширәгә алтундин төрт һалқа ясап, бу һалқиларни ширәниң төрт бүҗигидики четиққа орнатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ширәни көтиришкә балдақлар өткүзүлсун дәп, һалқилар ширә левигә йеқин бекитилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ширә үчүн у балдақларни акатсийә яғичидин ясап, алтун билән қаплиди; ширә улар билән көтириләтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","У ширәниң үстигә қоюлидиған барлиқ буюмларни, йәни легәнлирини, қача-қуча тәхсилирини, шарап һәдийәлирини қуйидиған қәдәһ вә пиялиләрниң һәммисини сап алтундин ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","У һәм чирақданни сап алтундин ясиди; чирақданни соқуп ясиди; чирақданниң пути, ғоли, қәдәһлири, ғунчилири вә гүллири бир пүтүн алтундин соқулди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Чирақданниң ғолиниң икки йенидин алтә шахчә чиқирилди — чирақданниң бир йенидин үч шахчә, униң йәнә бир йенидин үч шахчә чиқирилди; ");
INSERT INTO uigcyr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","бир йенидики һәр бир шахчидә бадам гүли шәклидә ғунчиси вә чечиги болған үч қәдәһ чиқирилди, йәнә бир йенидики һәр бир шахчидә бадам гүли шәклидә ғунчиси вә чечиги болған үч қәдәһ чиқирилди. Чирақданға чиқирилған алтә шахчиниң һәммиси шундақ ясалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Чирақданниң ғолидин бадам гүли шәклидә ғунчиси вә чечиги болған төрт қәдәһ чиқирилди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Булардин башқа биринчи икки шахчиниң астида бир ғунчә, иккинчи икки шахчиниң астида бир ғунчә, үчинчи икки шахчиниң астида бир ғунчә ясалған еди; чирақданға чиқирилған алтә шахчиниң астиниң һәммиси шундақ еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Униң шу ғунчилири һәм шахчилири чирақдан билән бир гәвдә қилинди — бир пүтүн сап алтундин соқуп ясалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","У чирақданниң йәттә чириғини, шундақла униң пилик қайчилири билән күлданлирини сап алтундин ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","У чирақдан вә униң барлиқ әсваплирини бир талант сап алтундин ясиди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","У йәнә хушбуйгаһни акатсийә яғичидин ясиди. Униң узунлуғи бир гәз, кәңлиги бир гәз, егизлиги икки гәз болуп, төрт часа қилип ясалди; төрт бүҗигидики мүңгүзләр униң билән бир пүтүн қилип ясалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","У уни, йәни униң үстини, төрт әтрапини һәм мүңгүзлирини сап алтун билән қаплиди; униң үсти қисминиң чөрисигә алтундин гирвәк чиқарди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Униңға алтундин икки һалқа ясап, униң гирвикиниң астиға бекитти; уларни икки йениға удулму удул бекитти. Хушбуйгаһни көтиридиған икки балдақни селиш үчүн буларни хушбуйгаһниң икки тәрипигә орунлаштурди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","У балдақларни акатсийә яғичидин ясап, алтун билән қаплиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","У һәм муқәддәс Мәсиһләш мейини ясиди, андин әтирчи чиқарғандәк дора-дәрмәкләрни тәңшәп сап хушбуйни ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","У көйдүрмә қурбанлиқ қурбангаһини акатсийә яғичидин ясиди. Қурбангаһ төрт часа болуп, узунлуғи бәш гәз, кәңлиги бәш гәз, егизлиги үч гәз қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","У униң төрт бүҗигигә қоюлидиған мүңгүзлирини ясиди; мүңгүзлири қурбангаһ билән бир гәвдә қилинди. Қурбангаһни мис билән қаплиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","У қурбангаһниң барлиқ әсваплирини — униңға хас болған дасларни, гүҗәкләрни, кориларни, лахшигирларни вә отданларниму ясиди; униң барлиқ әсваплирини мистин ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Қурбангаһ үчүн мистин бир шала ясиди; шалани қурбангаһниң қап белиниң астидики гирвәктин төвәнрәк туридиған қилди; шала қурбангаһниң дәл оттурисида еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","У шаланиң төрт бүҗигигә балдақлар өткүзүлидиған төрт мис һалқини қуюп ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","У балдақларни акатсийә яғичидин ясап, уларни мис билән қаплиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Андин у қурбангаһни көтириш үчүн балдақларни қурбангаһниң икки йенидики һалқиларға өткүзүп қойди. У қурбангаһни тахтайлардин, ичини бош қилип ясиди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","У йәнә жуюнуш десини мистин, униң тәглигиниму мистин ясиди; у буларни «көрүшүш чедири»ниң кириш еғизиниң алдида хизмәттә болған аялларниң мис әйнәклиридин ясиди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Андин у чедирниң һойлисиниму ясиди. Һойлиниң җәнубиға, йәни җәнупқа йүзләнгән тәрипигә непиз тоқулған ақ канап рәхттин пәрдиләрни ясиди; униң узунлуғи йүз гәз еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Пәрдиләрни есишқа жигирмә хада вә хадиларниң жигирмә тәглигини у мистин ясиди. Хадиларниң илмәклири вә балдақлири күмүчтин ясалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Шуниңға охшаш шимал тәрипидиму узунлуғи йүз гәз келидиған пәрдә бар еди. Пәрдиләрни есишқа жигирмә хада вә хадиларниң жигирмә тәглигини у мистин ясиди. Хадиларниң илмәклири вә балдақлири күмүчтин ясалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Шуниңға охшаш ғәрип тәрипидә узунлуғи әллик гәз келидиған пәрдә бар еди; пәрдиләрни есишқа он хада вә хадиларниң он тәглигини у мистин ясиди. Хадиларниң илмәклири вә балдақлири күмүчтин ясалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Һойлиниң шәриқ тәрипи, йәни күн чиқишқа йүзләнгән тәрипиниң кәңлиги әллик гәз еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Бир тәрипидә он бәш гәз келидиған пәрдә болуп, униң үч хадиси билән үч тәглиги бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Йәнә бир тәрипидиму он бәш гәз келидиған пәрдә болуп, униң үч хадиси билән үч тәглиги бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Һойлиниң чөрисидики пәрдиләрниң һәммиси непиз тоқулған ақ канап рәхттин тикилгән еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Һойлиниң чөрисидики һәммә хадиларниң тәглиги мистин, уларниң илмәклири вә балдақлири күмүчтин ясалди; хадиларниң башлириму күмүчтин қапланған еди. Һойлиниң чөрисидики һәммә хадилар күмүчтин ясалған балдақлар билән бир-биригә четилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Һойлиниң кириш еғизидики пәрдә непиз тоқулған ақ канап рәхткә көк, сөсүн вә қизил жиплар арилаштурулуп, кәштичиләр тәрипидин кәштиләнди; униң узунлуғи жигирмә гәз, егизлиги һойлидики пәрдиләрниң егизлигигә охшаш болуп бәш гәз еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Униң төрт хадиси билән мистин ясалған төрт тәглиги бар еди; хадиларниң илмәклири күмүчтин ясалди, уларниң башлири күмүч билән қапланди вә балдақлири күмүчтин ясалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Муқәддәс чедирниң һәм чөрисидики һойлиниң барлиқ миқ-қозуқлири мистин ясалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Муқәддәс чедир, йәни «һөкүм-гувалиғи чедири» үчүн аталған материялларниң сани төвәндә хатириләнгән (улар Мусаниң буйруғи билән, каһин Һарунниң оғли Итамарниң қол астидики Лавийлар мәсъул болуп санақтин өткүзүлүп, Худаға аталған еди): — ");
INSERT INTO uigcyr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Йәһуда қәбилисидин болған Хурниң нәвриси, Уриниң оғли Бәзаләл Пәрвәрдигар Мусаға буйруғанниң һәммисини ада қилди; ");
INSERT INTO uigcyr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Дан қәбилисидин болған Аһисамақниң оғли Оһолияб униң ярдәмчиси еди; у болса нәққашлиқ-оймичилиқ устиси, лайиһилигүчи һәмдә көк, сөсүн, қизил жиптин ақ канап рәхткә кәштә тикәләйдиған уста еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Муқәддәс чедирни ясашқа ишлитилгән алтун, йәни «пулаңлатма һәдийә» сүпитидә кәлтүрүлгән алтунниң һәммиси муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә жигирмә тоққуз талант йәттә йүз оттуз шәкәл еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Җамаәт арисидин санақтин өткүзүлгән адәмләр тәрипидин кәлтүрүлгән күмүч болса муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә бир йүз талант бир миң йәттә йүз йәтмиш бәш шәкәл еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Бу күмүч нопуси ройхәткә елинған кишиләрдин елинған еди — демәк, кимки жигирмә яш я униңдин чоң, санақтин өткүзүлгәнләрниң һәр бири бир бека, йәни муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә йерим шәкәл күмүч бәрди. Санақтин өткән киши алтә йүз үч миң бәш йүз әллик киши еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Муқәддәс җайниң тәгликлирини һәм оттурисидики пәрдиниң тәгликлирини қуюшқа йүз талант күмүч кәтти; йүз талант күмүчтин йүз тәглик ясилип, һәр бир тәглик үчүн бир талант ишлитилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","У қалған бир миң йәттә йүз йәтмиш бәш шәкәл күмүчтин хадиларниң илмәклирини ясиди, уларниң башлирини қаплиди, шуниңдәк уларни бир-биригә чатидиған балдақларни ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","«Пулаңлатма һәдийә» сүпитидә кәлтүрүлгән мис болса йәтмиш талант, икки миң төрт йүз шәкәл чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Буниңдин у җамаәт чедириниң кириш еғизиниң тәгликлирини, мис қурбангаһни, униң мис шаласи вә қурбангаһниң барлиқ әсваплирини, ");
INSERT INTO uigcyr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","һойлиниң чөрисидики хада тәгликлирини, һойлиниң кириш еғизидики тәгликләрни, чедирниң барлиқ қозуқлирини вә һойлиниң чөрисидики қозуқларниң һәммисини ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Пәрвәрдигар Мусаға буйруғинидәк көк, сөсүн вә қизил жиплар ишлитилип, муқәддәс чедирниң хизмитидә кийилидиған каһинлиқ кийимләр, шундақла Һарунниң муқәддәс кийимлири тәйяр қилинди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Бәзаләл алтун вә көк, сөсүн, қизил жиплар билән непиз тоқулған ақ канап рәхтләрдин әфодни ясап тәйярлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Улар алтунни соқуп непиз қилип, уни кесип жип қилди, андин буларни маһирлиқ билән көк жиплар, сөсүн жиплар вә қизил жиплардин ақ канап рәхткә лаһайиләнгән нусхилар үстигә тоқуди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Улар әфодниң алди вә кәйни қисмини бир-биргә туташтуруп туридиған икки мүрилик тасма ясиди; әфодниң икки тәрипи бир-биригә туташтурулди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Әфодниң үстигә бағлайдиған бәлвағ әфод билән бир пүтүн қилинған болуп, униңға охшаш сипта ишлинип, алтун вә көк, сөсүн, қизил жиплар вә непиз тоқулған ақ канап рәхттин ясалди; һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Улар икки ақ һеқиқни икки алтун көзлүккә орнитип, уларниң үстигә худди мөһүр ойғандәк Исраилниң оғуллириниң намлирини оюп ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Исраилниң оғуллириға әсләтмә таш болсун үчүн, Пәрвәрдигар Мусаға буйруғандәк икки яқутни әфодниң икки мүрилик тасмисиға бекитип қойди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","У қошенни чевәр қолларға нәпис қилип кәштилитип ясиди; уни әфодни ишлигән усулда алтун вә көк, сөсүн, қизил жиплар билән непиз тоқулған ақ канап рәхттин ясиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Улар қошенни икки қат, төрт часа қилип ясиди; икки қат қилинғанда узунлуғи бир ғерич, кәңлигиму бир ғерич келәтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Униң үстигә төрт қатар қилип гөһәрләрни орнатти: — бир қатардикиси қизил яқут, сериқ гөһәр вә зумрәтләр еди; бу биринчи қатар еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Иккинчи қатарға көк қаштеши, көк яқут вә алмас, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","үчинчи қатарға сөсүн яқут, пироза вә сөсүн квартс, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","төртинчи қатарға берил яқут, ақ һеқиқ вә анарташ орнитилди; буларниң һәммиси алтун көзлүккә бекитилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Бу гөһәрләр Исраилниң оғуллириниң намлириға вәкил қилинип, уларниң санидәк он икки болуп, мөһүр ойғандәк һәр бир гөһәргә он икки қәбилиниң нами бирдин-бирдин пүтүлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Улар қошенға шойнидәк ешилгән сап алтундин икки ешилмә зәнҗир ясиди; ");
INSERT INTO uigcyr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","улар қошенға алтундин икки көзлүк вә икки һалқа етип, икки һалқини қошенниң жуқуриқи икки бүҗигигә бекитти; ");
INSERT INTO uigcyr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","андин шу алтундин ешилип ясалған икки зәнҗирни қошенниң жуқуриқи икки бүҗигидики һалқидин өткүзүп, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ешилгән шу зәнҗирләрниң икки учини икки көзлүккә бекитип, көзлүкләрни әфодниң икки мүрилик тасмисиниң алди қисмиға орнатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Буниңдин башқа улар алтундин икки һалқа ясап, уларни қошенниң асти тәрипидики икки бүҗигигә бекитти; улар әфодқа тегишип туридиған қилинип ичигә қадалди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Мундин башқа улар алтундин йәнә икки һалқа ясап, уларни әфодниң икки мүрилик тасмисиниң алди төвәнки қисмиға, әфодқа улинидиған җайға йеқин, кәшитиләнгән бәлвағдин егизрәк қилип бекитти. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Улар қошенниң әфодниң бәлвеғидин жуқурирақ туруши, қошенниң әфодтин аҗрап кәтмәслиги үчүн көк шойна билән қошенниң һалқисини әфодниң һалқисиға четип қойди. Буларниң һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Бәзаләл әфодниң ичидики тонни пүтүнләй көк рәңлик қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Тонниң башқа кийилидиған төшүги дәл оттурисида, худди савутниң яқисидәк ишләнгән еди; житилип кәтмәслиги үчүн униң чөрисигә пәваз ишләнди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Улар тонниң етигиниң чөрисигә көк, сөсүн вә қизил жиптин анарларни тоқуп есип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Улар һәмдә алтун қоңғурақларни ясап, қоңғурақларни тонниң етигиниң чөрисигә, анарларниң арилиғиға бирдин есип қойди; һәр икки анарниң оттурисиға бир қоңғурақ есип қоюлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Қаһинлиқ хизмитигә аит қоңғурақлар тонниң етигиниң чөрисигә бекитилди; бир алтун қоңғурақ, бир анар, бир алтун қоңғурақ, бир анар қилип бекитилди; һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Улар Һарун билән униң оғуллириға непиз тоқулған ақ канап рәхттин халта көйнәкләрни тикти; ");
INSERT INTO uigcyr_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","сәллини ақ канап рәхттә ясиди, шундақла чирайлиқ егиз бөкләрни ақ канап рәхттә, тамбалларни непиз тоқулған ақ канап рәхттә тәйярлиди; ");
INSERT INTO uigcyr_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","буниңдин башқа улар бәлвағниму көк, сөсүн вә қизил жип арилаштурулуп кәштиләнгән, непиз тоқулған ақ канап рәхттә тәйярлиди; буларниң һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Улар йәнә нәпис тахтайни, йәни муқәддәс отуғатни сап алтундин ясап, униң үстигә мөһүр ойғандәк: «Пәрвәрдигарға муқәддәс қилинди» дәп оюп пүтти; ");
INSERT INTO uigcyr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","улар отуғатқа көк рәңлик жипни бағлап, униң билән отуғатни сәллигә тақиди, булар Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Шу тәриқидә җамаәтниң ибадәт чедириниң һәммә қурулуши пүткүзүлди; Исраиллар Пәрвәрдигарниң Мусаға буйруғининиң һәммисини шу бойичә қилди; шу тәриқидә һәммисини пүттүрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Улар чедирни Мусаниң йениға елип кәлди — чедир йопуқлирини, униң барлиқ әсваплирини, илмәклирини, тахтайлирини, балдақлирини, хадилири билән тәгликлирини, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","шуниңдәк қизил боялған қочқар терисидин ясалған йопуқ билән делфин терисидин ясалған йопуқни, «айрима пәрдә»ни, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","әһдә сандуғи вә униң балдақлирини, «кәфарәт тәхти»ни, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ширә вә униң барлиқ әсваплирини, шундақла «тәқдим нанлар»ни, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","сап алтундин ясалған чирақдан билән униң чирақлирини, йәни үстигә тизилған чирақларни, униң барлиқ әсваплири һәм чирақ мейини, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","алтун хушбуйгаһ, мәсиһләш мейи, дора-дәрмәкләрдин ясалған хушбуйни, чедирниң кириш еғизиниң пәрдисини, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","мис қурбангаһ билән униң мис шаласини, униң балдақлири билән һәммә әсваплирини, жуюш деси билән униң тәглигини, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","һойлиниң чөрисидики пәрдиләрни, униң хадилири вә уларниң тәгликлирини, һойлиниң кириш еғизиниң пәрдиси билән һойлиниң танилири вә қозуқлирини, муқәддәс чедирниң, йәни җамаәт чедириға аит хизмәткә ишлитилидиған барлиқ әсвапларни, ");
INSERT INTO uigcyr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","муқәддәс җайға аит хизмәт үчүн тикилгән каһинлиқ кийимини, йәни Һарун каһинниң муқәддәс кийимлири билән униң оғуллириниң каһинлиқ кийимлирини болса, һәммисини елип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Бу ишларниң һәммисини Исраиллар Пәрвәрдигарниң Мусаға барлиқ буйруғанлири бойичә әнә шундақ ада қилған еди. ");
INSERT INTO uigcyr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Муса ишларниң һәммисигә тәпсилий қариди, мана, улар Пәрвәрдигарниң буйруғини бойичә бу ишларни пүткүзгән еди; буйрулғандәк, дәл шундақ қилған еди; Муса буларни көрүп, уларға бәхит-бәрикәт тиләп дуа қилди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Андин Пәрвәрдигар Мусаға мундақ әмир қилди: — ");
INSERT INTO uigcyr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Биринчи айниң беши, айниң биринчи күни сән җамаәт чедириниң муқәддәсханисини тиклигин. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Һөкүм-гувалиқ сандуғини униң ичигә қоюп, ички пәрдә арқилиқ әһдә сандуғини тосуп қойғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ширәни чедирниң ичигә әкирип, үстигә тизилидиған нәрсиләрни тизғин; андин чирақданни әкирип, үстигә чирақларни орунлаштурғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Алтун билән қапланған хушбуй көйдүргүчи қурбангаһни һөкүм-гувалиқ сандуғиниң удулиға тикләп қойғин; чедирниң кириш еғизиниң пәрдисини есип қойғин.    ");
INSERT INTO uigcyr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Көйдүрмә қурбанлиқ қурбангаһини муқәддәсханиниң, йәни җамаәт чедириниң кириш еғизиниң алдиға қойғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","андин жуюш десини җамаәт чедири билән қурбангаһниң оттурисиға орунлаштуруп, су тоштуруп қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Һойлиниң чөрисигә пәрдиләрни бекитип, һойлиниң кириш еғизиниң пәрдисини асқин; ");
INSERT INTO uigcyr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","андин «мәсиһләш мейи»ни елип, ибадәт чедири вә униң ичидики барлиқ нәрсиләрни мәсиһләп, уни вә барлиқ һәммә әсваплирини Худаға атап муқәддәс қилғин. Шундақ қилип пүткүл чедир муқәддәс болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Сән көйдүрмә қурбанлиқ қурбангаһини, шундақла униң барлиқ әсваплирини мәсиһләп, уни Худаға атап муқәддәс қилғин; буниң билән қурбангаһ «әң муқәддәс нәрсиләр» қатарида болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Сән йәнә жуюнуш деси вә униң тәглигини мәсиһләп муқәддәс қилғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Андин Һарун билән униң оғуллирини җамаәт чедириниң кириш еғизиға йеқин әкилип, уларни су билән жуйғин; ");
INSERT INTO uigcyr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Һарунға муқәддәс кийимләрни кийдүрүп, Маңа каһинлиқ хизмәттә болуши үчүн уни мәсиһләп, Маңа айрип муқәддәс қилғин. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Андин униң оғуллирини елип кирип, уларға халта көйнәкләрни кийдүрүп, ");
INSERT INTO uigcyr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","уларниң атисини мәсиһлигиниңдәк Маңа каһинлиқ хизмитидә болуши үчүн уларниму мәсиһлигин. Шуниң билән уларниң бу мәсиһлиниши улар үчүн әвлаттин әвлатқичә әбәдий каһинлиқниң бәлгиси болиду. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Муса шундақ қилди; Пәрвәрдигар униңға немә буйруған болса, у шундақ беҗа кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Шундақ болдики, иккинчи жилниң биринчи ейида, айниң биринчи күнидә ибадәт чедири тикләнди.    ");
INSERT INTO uigcyr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Муса чедирни тикип, тәгликлирини орунлаштуруп, тахтайлирини тизип, уларниң балдақлирини бекитип, хадилирини тиклиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Муқәддәс чедирниң үстигә ички йопуқни япти, андин униң үстигә ташқи йопуқни йепип қойди; буларниң һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Андин у һөкүм-гувалиқни елип, уни сандуқ ичигә қойди; балдақларни әһдә сандуғиниң һалқилиридин өткүзүп, «кәфарәт тәхти»ни сандуқниң үстигә орунлаштурди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Әһдә сандуғини муқәддәс чедир ичигә елип кирип, оттуриға «айрима пәрдә»ни тартти; шундақ қилип у һөкүм-гувалиқ сандуғини пәрдә арқилиқ тосуп қойди. Һәммә иш Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","У ширәни җамаәт чедириға елип кирип, муқәддәс җайниң шимал тәрипигә, «әң муқәддәс җай»дики пәрдиниң сиртиға қойди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","«Тәқдим нанлар»ни ширәниң үстигә, Пәрвәрдигарниң алдиға тизип қойди; буларниң һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Андин у чирақданни җамаәт чедириға елип кирип, уни муқәддәс җайниң җәнуп тәрипигә, ширәниң удулиға қойди, ");
INSERT INTO uigcyr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","чирақларни Пәрвәрдигарниң алдиға орунлаштурди; буларниң һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Андин у хушбуйни көйдүргүчи алтун қурбангаһни ичидики пәрдиниң алдиға тиклиди; ");
INSERT INTO uigcyr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Униң үстидә есил хушбуйни көйдүрди; буларниң һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","У ибадәт чедириниң кириш еғизиға пәрдә тартти. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Андин көйдүрмә қурбанлиқ қурбангаһини җамаәт чедиридики муқәддәс җайниң кириш еғизиға йеқин қойди; униң үстидә көйдүрмә қурбанлиқ вә қошумчә ашлиқ һәдийәсини өткүзди; буларниң һәммиси Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Жуюнуш десини җамаәт чедири билән қурбангаһниң оттурисиға қоюп, жуюшқа ишлитилидиған суни дасқа тошқузуп қуйди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","Муса вә Һарун билән униң оғуллири қачанла җамаәт чедириға кирсә яки қурбангаһқа йеқин барса, Пәрвәрдигарниң Мусаға буйруғинидәк қоллирини шу суда жуятти. Булар Пәрвәрдигарниң Мусаға буйруғинидәк қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Андин у чедир һәм қурбангаһниң әтрапиға һойла пәрдисини тикләп, һойлиниң кириш еғизиниң пәрдисини тартти. Шу тәриқидә Муса пүткүл ишни тамамлиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Шуниң билән булут җамаәт чедирини қаплап, Пәрвәрдигарниң җуласи ибадәт чедирини толдурди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Булут сайә чүшүрүп, Пәрвәрдигарниң җуласи чедирни толдурғини үчүн, Муса җамаәт чедириға кирәлмиди. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Қачанки булут җамаәт чедиридин көтирилсә, Исраиллар сәпәргә атлинатти. Һәр бир қетим сәпәрдә шундақ болатти. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Булут көтирилмисә улар қозғалмай, таки көтирилидиған күнгичә сәпәргә чиқмайтти. ");
INSERT INTO uigcyr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Чүнки күндүзи Пәрвәрдигарниң булути муқәддәс чедир үстидә туратти, кечиси униң үстидә от көрүнәтти; пүткүл Исраил җәмәтиниң көз алдида уларниң барлиқ қилған сәпәрлиридә шулар көрүнәтти. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Вә Пәрвәрдигар Мусани чақирип җамаәт чедиридин униңға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Сән Исраилларға сөз қилип уларға мундақ дегин: — Әгәр силәрдин бириңлар Пәрвәрдигарниң алдиға бир қурбанлиқни сунмақчи болсаңлар, қурбанлиғиңларни чарпайлардин, йәни кала яки ушшақ маллардин сунушуңлар керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Әгәр униң сунидиғини калилардин көйдүрмә қурбанлиқ болса, ундақта у беҗирим әркәк һайванни кәлтүрсун; униң Пәрвәрдигарниң алдида қобул болуши үчүн уни җамаәт чедириниң кириш ағзиниң алдида сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","У қолини көйдүрмә қурбанлиқниң бешиға қойсун; шуниң билән қурбанлиқ униң орниға кәфарәт болушқа қобул қилиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Андин у Пәрвәрдигарниң һозурида буқини боғузлисун; каһинлар болған Һарунниң оғуллири қенини кәлтүрүп, җамаәт чедириниң кириш ағзидики қурбангаһниң үсти қисминиң әтрапиға сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Андин қурбанлиқ қилғучи көйдүрмә қурбанлиқ қилинған һайванниң терисини союп, тенини парчилисун ");
INSERT INTO uigcyr_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","вә Һарун каһинниң оғуллири қурбангаһта от қалап отниң үстигә отунларни тизсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Андин каһинлар болған Һарунниң оғуллири гөш парчилирини, беши вә мейи билән қошуп, қурбангаһдики отниң үстидики отунниң үстигә тәртип билән тизип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Лекин униң ич-қарни билән пачақлирини қурбанлиқ сунғучи суда жуйсун; андин каһин һәммисини елип келип қурбангаһниң үстидә көйдүрсун. Бу от арқилиқ сунулидиған қурбанлиқ һесавида, Пәрвәрдигарға хушбуй чиқирилидиған көйдүрмә қурбанлиқ болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Әгәр у көйдүрмә қурбанлиқ қилиш үчүн ушшақ маллардин қой я өшкә қурбанлиқ қилай десә, ундақта у беҗирим болған бир әркикини кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","У уни қурбангаһниң шимал тәрипидә Пәрвәрдигарниң һозурида боғузлисун. Андин каһинлар болған Һарунниң оғуллири қенини елип, қурбангаһниң үсти қисминиң әтрапиға сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","қурбанлиқ қилғучи болса гөшни парчилап, беши билән мейини кесип айрисун. Андин каһин буларни елип қурбангаһтики отниң үстидики отунниң үстидә тәртип бойичә тизип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Лекин униң ич-қарни билән пачақларни қурбанлиқ сунғучи суда жуйсун; андин каһин һәммисини елип келип қурбангаһниң үстидә көйдүрсун. Бу от арқилиқ сунулидиған қурбанлиқ һесавида, Пәрвәрдигарға хушбуй чиқирилидиған көйдүрмә қурбанлиқ болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Әгәр қурбанлиқ қилғучи Пәрвәрдигарға атап учар-қанатлардин көйдүрмә қурбанлиқ қилай десә, ундақта у пахтәкләрдин яки кәптәр балилиридин қурбанлиқ кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Каһин уни қурбангаһниң йениға елип келип, бешини толғап үзүп уни қурбангаһниң үстидә көйдүрсун; униң қени сиқилип қурбангаһниң темиға сүртүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Лекин ташлиғини пәйлири билән қошуп қурбангаһниң шәриқ тәрипидики күллүккә ташливәтсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","у қурбанлиқни икки қанитиниң оттурисидин ярсун, бирақ уни икки парчә қиливәтмисун. Андин каһин буни елип қурбангаһдики отниң үстидики отунниң үстигә қоюп көйдүрсун; бу от арқилиқ сунулидиған қурбанлиқ һесавида, Пәрвәрдигарға хушбуй чиқирилидиған көйдүрмә қурбанлиқ болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Әгәр бирким Пәрвәрдигарниң һозуриға ашлиқ һәдийәси сунмақчи болса һәдийәси есил ундин болуши керәк; у униңға зәйтун мейи қуюп андин үстигә мәстики салсун.    ");
INSERT INTO uigcyr_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","У уни елип каһинлар болған Һарунниң оғуллириниң алдиға кәлтүрсун; андин каһин һәдийә сунғучиниң ядлиниши үчүн зәйтун мейи иләштүрүлгән ундин бир чаңгал елип, һәммә мәстики билән қошуп, бу һәдийәни қурбангаһта көйдүрсун; бу от арқилиқ сунулидиған, Пәрвәрдигарға хушбуй чиқирилидиған һәдийә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Амма ашлиқ һәдийәсидин қалғини болса, Һарун билән униң оғуллириға тәвә болсун. Бу Пәрвәрдигарға от арқилиқ сунулғанларниң ичидә «әң муқәддәсләрниң бири» һесаплиниду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Әгәр сән тонурда пиширилған нәрсиләрдин ашлиқ һәдийәси сүнай десәң, улар зәйтун мейи иләштүрүлгән есил ундин пиширилған тоғачлар яки зәйтун мейи сүрүлүп мәсиһләнгән петир һәмәк нанлардин болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Әгәр сениң кәлтүридиған һәдийәң тавида пиширилған ашлиқ һәдийәси болса у зәйтун мейи ишләштүрүлүп есил ундин петир һалда етилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Сән уни уштуп үстигә зәйтун мейи қуйғин; у ашлиқ һәдийәси болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Сениң кәлтүридиған һәдийәң қазанда пиширилған ашлиқ һәдийәси болса ундақта у есил ун билән зәйтун мейида етилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Шу йолларда тәйярланған ашлиқ һәдийәлирини Пәрвәрдигарниң һозуриға кәлтүргин; уни каһинға бәргин, у уни қурбангаһқа елип бариду. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Каһин болса ашлиқ һәдийәсидин «ядлиниш үлүши»ни елип қурбангаһниң үстидә көйдүрсун. Бу от арқилиқ сунулидиған, Пәрвәрдигарға хушбуй чиқирилидиған һәдийә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Амма ашлиқ һәдийәсидин қалғини болса, Һарун билән униң оғуллириға тәвә болсун. Бу Пәрвәрдигарға от арқилиқ сунулғанларниң ичидә «әң муқәддәсләрниң бири» һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Силәр Пәрвәрдигарниң һозуриға сунидиған һәр қандақ ашлиқ һәдийәлири ечитқу билән тәйярланмисун. Чүнки силәрниң Пәрвәрдигарға отта сунулидиған һәдийәңларниң һеч қайсисида ечитқу яки һәсәлни көйдүрүшкә болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Буларни Пәрвәрдигарниң алдиға «дәсләпки һосул» сүпитидә сунсаңлар болиду, лекин улар хушбуй сүпитидә қурбангаһниң үстидә көйдүрүлүп сунулмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Сениң һәр бир ашлиқ һәдийәң туз билән тузлиниши керәк; һәдийәңни Худайиңниң әһдә тузидин мәһрум қилмай, һәммә ашлиқ һәдийәлириңни туз билән тузлиғин. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Әгәр сән Пәрвәрдигарға «дәсләпки һосул»дин ашлиқ һәдийәси сүнай десәң, ундақта зираәтниң йеңи пишқан көк бешини елип, данларни отта қоруп, езип талқан сүпитидә сунғин; бу «дәсләпки һосул» һәдийәси болиду; ");
INSERT INTO uigcyr_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","сән униңға зәйтун мейи қуюп үстигә мәстики салғин; бу ашлиқ һәдийәси болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Каһин болса униңдин, йәни қоруп езилгән данлар билән зәйтун мейидин бир қисмини елип һәммә мәстики билән қошуп, боларни «ядлиниш үлүши» сүпитидә көйдүрсун. Бу от арқилиқ Пәрвәрдигарға сунулған һәдийә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Бирисиниң сунидиғини енақлиқ қурбанлиғи болса, шундақла калилардин сунса, у Пәрвәрдигарниң һозуриға беҗирим бир әркикини яки чишисини кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","У сунидиған бу һайванниң бешиға қолини қоюп, андин уни җамаәт чедириниң кириш еғизи алдида боғузлисун. Андин каһинлар болған Һарунниң оғуллири қенини қурбангаһниң үсти қисминиң әтрапиға сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Сунғучи киши бу енақлиқ қурбанлиғидин Пәрвәрдигарға атап отта сунулидиған һәдийә сүпитидә бир қисмини елип беғишлисун, йәни ич қарнини йөгәп турған майни, шундақла барлиқ ич мейини елип ");
INSERT INTO uigcyr_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","икки бөрәкни вә уларниң үстидики һәмдә икки янпишидики майни аҗритип, җигәрниң бөрәккичә болған чава мейини кесип, елип кәлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Һарунниң оғуллири болса буларни қурбангаһниң үстигә кәлтүрүп от үстигә қоюлған отунниң үстидики көйдүрмә қурбанлиққа қошуп көйдүрсун. Бу от арқилиқ сунулидиған, Пәрвәрдигарға хушбуй чиқирилидиған қурбанлиқ болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Бирисиниң Пәрвәрдигарға қилидиған енақлиқ қурбанлиғи үчүн сунидиғини ушшақ малдин болса, ундақта у беҗирим бир әркикини яки чишисини кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Әгәр униң қурбанлиғи қой болса уни Пәрвәрдигарниң алдиға кәлтүрүп, ");
INSERT INTO uigcyr_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","қурбанлиқ қилидиған бу һайванниң бешиға қолини қоюп, андин уни җамаәт чедириниң кириш ағзиниң алдида боғузлисун. Андин Һарунниң оғуллири қенини елип қурбангаһниң үсти қисминиң әтрапиға сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Сунғучи киши бу енақлиқ қурбанлиғидин Пәрвәрдигарға атап отта сунулидиған һәдийә сүпитидә бир қисмини, йәни униң мейини елип беғишлисун, — пүтүн майлиқ қуйруғини униң омуртқисиға йеқин йәрдин аҗритип елип, ич қарнини йөгәп турған майни, шундақла барлиқ ич мейини елип, ");
INSERT INTO uigcyr_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","икки бөрәкни вә уларниң үстидики һәмдә икки янпишидики майни аҗритип, җигәрниң бөрәккичә болған чава мейини кесип, елип кәлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Каһин буларни қурбангаһниң үстидә көйдүрсун; бу отта сунулидиған, Пәрвәрдигарға аталған таам һәдийәси болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Униң сунидиғини өшкә болса, буни Пәрвәрдигарниң һозуриға кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","У қолини униң бешиға қоюп, андин уни җамаәт чедириниң алдида боғузлисун. Андин Һарунниң оғуллири қенини елип қурбангаһниң үсти қисминиң әтрапиға сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Андин сунғучи киши бу қурбанлиқтин Пәрвәрдигарға атап отта сунулидиған һәдийә сүпитидә бир қисмини елип беғишлисун, йәни ич қарнини йөгәп турған майни, шундақла барлиқ ич мейини елип, ");
INSERT INTO uigcyr_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","икки бөрәкни вә уларниң үстидики һәмдә икки янпишидики майни аҗритип, җигәрниң бөрәккичә болған чава мейини кесип, елип кәлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Каһин буларни қурбангаһниң үстидә көйдүрсун; бу отта сунулидиған, хушбуй чиқиридиған таам һәдийәси болиду. Майниң һәммиси Пәрвәрдигарға тәвәдур. ");
INSERT INTO uigcyr_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Бу һәр қандақ турар җайиңларда силәргә әбәдий бәлгүлимә болиду; силәр һеч қандақ май яки қан йемәслигиңлар керәк.    ");
INSERT INTO uigcyr_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Исраилларға сөз қилип мундақ дегин: — «Бириси билмәй езип, Пәрвәрдигар «қилма» дәп буйруған һәр қандақ әмирләрдин биригә хилаплиқ қилип селип, гуна қилса, төвәндикидәк қилсун: — ");
INSERT INTO uigcyr_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","— әгәр мәсиһләнгән каһин хәлиқни гунаға путлаштуридиған бир гунани қилса, ундақта у бу қилған гунайи үчүн бир беҗирим яш топақни елип келип, Пәрвәрдигарға гуна қурбанлиғи сүпитидә сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","У топақни җамаәт чедириниң кириш ағзиниң йениға, Пәрвәрдигарниң алдиға кәлтүрүп, қолини униң бешиға қоюп, андин топақни Пәрвәрдигарниң һозурида боғузлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Андин мәсиһләнгән каһин топақниң қенидин азғина елип, җамаәт чедири ичигә көтирип апарсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","каһин шу йәрдә бармиғини қанға чилап, қанни әң муқәддәс җайниң пәрдисиниң алдида, Пәрвәрдигарниң һозурида йәттә мәртивә сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Шундақла каһин қандин елип, җамаәт чедири ичидә Пәрвәрдигарниң алдида турған хушбуйгаһниң мүңгүзлиригә сүрсун. Топақниң қалған һәммә қенини болса, җамаәт чедириниң кириш ағзиниң алдидики көйдүрмә қурбанлиқ қурбангаһиниң түвигә төкүп қойсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","андин у гуна қурбанлиғи болған топақниң ичидин һәммә мейини аҗритип чиқарсун — йәни ич қарнини йөгәп турған май билән қалған ич мейи, ");
INSERT INTO uigcyr_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","икки бөрәкни вә уларниң үстидики һәмдә икки янпишидики майни аҗритип, җигәрниң бөрәккичә болған чава мейини аҗратсун ");
INSERT INTO uigcyr_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(худди енақлиқ қурбанлиғи болған калиниң ичидики май аҗритилғандәк); андин каһин буларни көйдүрмә қурбанлиқ қурбангаһиниң үстидә көйдүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Лекин топақниң териси билән һәммә гөши, баш билән пачақлири, ич қарни билән жинини, ");
INSERT INTO uigcyr_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","йәни пүткүл топақниң қалған қисимлирини чедиргаһниң сиртиға елип чиқип, пак бир йәргә, йәни күлләр төкүлидиған җайға елип чиқип, отунниң үстидә отта көйдүрсун. Булар күлләр төкүлидиған җайда көйдүрүветилсун.    ");
INSERT INTO uigcyr_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Әгәр пүткүл Исраил җамаити өзи билмигән һалда езип гуна қилған болса, Пәрвәрдигарниң «қилма» дәп буйруған һәр қандақ әмирлиригә хилаплиқ ишларниң бирини қилип селип, гунаға чүшүп қалса,    ");
INSERT INTO uigcyr_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","шундақла уларниң садир қилған гунайи айдиңлашқан болса, ундақта җамаәт гуна қурбанлиғи сүпитидә бир яш топақни сунуп җамаәт чедириниң алдиға кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Җамаәтниң ақсақаллири Пәрвәрдигарниң алдида қоллирини топақниң бешиға қоюп, андин топақни Пәрвәрдигарниң алдида боғузлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Мәсиһләнгән каһин топақниң қенидин азғина елип җамаәт чедири ичигә елип кирсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","шу йәрдә бармиғини қанға чилап, қанни әң муқәддәс җайниң пәрдисиниң алдида, Пәрвәрдигарниң һозурида йәттә мәртивә сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Шундақла каһин қандин елип җамаәт чедири ичидә Пәрвәрдигарниң алдида турған хушбуйгаһниң мүңгүзлиригә сүрсун. Топақниң қалған һәммә қенини болса, җамаәт чедириниң кириш ағзиниң алдидики көйдүрмә қурбанлиқ қурбангаһиниң түвигә төкүп қойсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","каһин топақниң ичидин барлиқ мейини аҗритип елип, қурбангаһниң үстидә көйдүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","У гуна қурбанлиғи болған илгәрки топақни қилғиниға охшаш бу топақниму шундақ қилсун; вә дәл шундақ қилиши керәк; шу йол билән каһин улар үчүн кәфарәт кәлтүриду; шу гуна улардин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Андин у топақни чедиргаһниң ташқириға елип чиқип, илгәрки топақни көйдүргәндәк бу топақниму көйдүрсун. Бу җамаәт үчүн гуна қурбанлиғи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Әгәр бир әмир билмәй униң Худаси Пәрвәрдигарниң «қилма» дегән һәр қандақ әмирлириниң биригә хилаплиқ қилип селип, гунаға чүшүп қалса, ");
INSERT INTO uigcyr_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","вә қилған гунайи өзигә мәлум қилинған болса, ундақта у өзи қурбанлиқ үчүн беҗирим бир текини сунсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","у қолини текиниң бешиға қоюп, андин уни көйдүрмә қурбанлиқ қилинидиған һайванларни боғузлайдиған җайға елип берип Пәрвәрдигарниң алдида боғузлисун. Бу бир гуна қурбанлиғи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Каһин гуна қурбанлиғиниң қенидин бармиғиға азғина елип, уни көйдүрмә қурбанлиқ қурбангаһиниң мүңгүзлиригә сүрүп қойсун; андин қалған қенини көйдүрмә қурбанлиқ қурбангаһиниң түвигә төкүп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","У енақлиқ қурбанлиғи қилинған һайванниң мейини көйдүргәндәк, униң барлиқ мейини қурбангаһта көйдүрсун. Бу йол билән каһин уни гунайидин пакландуруш үчүн кәфарәт кәлтүриду вә шу гунайи униңдин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Әгәр пухралардин бири билмәй униң Худаси Пәрвәрдигарниң «қилма» дегән һәр қандақ әмирлириниң биригә хилаплиқ қилип селип, гунаға чүшүп қалса, ");
INSERT INTO uigcyr_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","вә қилған гунайи өзигә мәлум қилинған болса, ундақта у өзиниң, йәни у садир қилған гунайи үчүн қурбанлиқ қилишқа беҗирим бир чиши өшкини сунсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","у қолини гуна қурбанлиғиниң бешиға қоюп, андин уни көйдүрмә қурбанлиқларни боғузлайдиған җайға елип берип боғузлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Андин каһин униң қенидин бармиғиға азғина елип уни көйдүрмә қурбанлиқ қурбангаһиниң мүңгүзлиригә сүрүп қойсун; қалған барлиқ қенини қурбангаһниң түвигә төкүп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Енақлиқ қурбанлиғи қилинған һайванниң мейи ичидин аҗритилғандәк униңму һәммә мейини аҗритип чиқарсун; каһин уни Пәрвәрдигарниң алдида хушбуй кәлтүрсун дәп қурбангаһниң үстидә көйдүрсун. Шу йол билән каһин униң үчүн кәфарәт кәлтүриду; шу гуна униңдин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Әгәр у киши гуна қурбанлиғи үчүн қоза кәлтүрүшни халиса, беҗирим бир чиши қозини сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","У қолини гуна қурбанлиғи қозисиниң бешиға қоюп, көйдүрмә қурбанлиқлар боғузлинидиған җайға елип берип, уни гуна қурбанлиғи сүпитидә боғузлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Андин каһин гуна қурбанлиғиниң қенидин бармиғиға азғина елип уни көйдүрмә қурбанлиқ қурбангаһиниң мүңгүзлиригә сүрүп қойсун; униң қалған барлиқ қенини у қурбангаһниң түвигә төкүп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Енақлиқ қурбанлиғи қилинған қозиниң мейи ичидин аҗритилғандәк, униңму һәммә мейини аҗритип чиқарсун; каһин буларни Пәрвәрдигарға атап отта сунулидиған барлиқ қурбанлиқларға қошуп, қурбангаһниң үстидә көйдүрсун. Шу йол билән каһин униң садир қилған гунайи үчүн кәфарәт кәлтүриду; шу гуна униңдин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Әгәр бириси мәлум ишқа гувачи болуп, шундақла униңға қәсәм буйрулғинида көргини яки билгинидин мәлумат бәрмисә, ундақта у қәбиһлигиниң җазасиға тартилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Әгәр бириси өзи билмәй напак бир нәрсигә тегип кәтсә — мәйли у напак бир һайванниң җәсити болсун, мәйли напак бир чарпайниң җәсити болсун, яки напак бир өмилигүчи һайванниң җәсити болсун, мошундақ нәрсигә тегип кәтсә уму напак санилип гунакар һесаплиниду; ");
INSERT INTO uigcyr_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","әгәр шуниңдәк бириси өзи туймай мәлум кишиниң адәмни напак қилидиған һәр қандақ ниҗаситигә тегип кәтсә, шундақла у буни билип йәтсә, ундақта у гунакар һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Әгәр бириси аңсиз рәвиштә яман яки яхши бир ишни қилай дәп қәсәм қилип салса (кишиләр һәртүрлүк иш тоғрисида аңсиз рәвиштә қәсәм қилиши мүмкин), шундақла у буни тонуп йәтсә, у бу ишлар түпәйлидин гунакар һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Бириси жуқуриқи һәр қайси ишларда мән гунакар болдум дәп билсә, у өз гунайини «мән мундақ гуна қилдим» дәп иқрар қилсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","андин өзи садир қилған гунайиниң кафарити үчүн Пәрвәрдигарниң алдиға «итаәтсизликни тилигүчи қурбанлиқ» сүпитидә ушшақ малдин сағлиқ вә я бир чиши өшкини гуна қурбанлиғи қилип кәлтүрсун; андин каһин уни гунайидин пакландурушқа униң үчүн кәфарәт кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Әгәр у қойлардин қурбанлиқ қилишқа қурби йәтмисә, у қилған итаәтсизлиги үчүн икки пахтәк яки икки бачкини елип келип, бирини гуна қурбанлиғи үчүн, йәнә бирини көйдүрмә қурбанлиқ үчүн Пәрвәрдигарниң алдиға сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","У буларни каһинниң қешиға кәлтүргәндә, каһин авал гуна қурбанлиғиға тәйярланғанни қурбанлиқ қилип бойнини үзмәй, бешиға йеқин җайидин толғисун, лекин бешини бойнидин үзүвәтмисун;    ");
INSERT INTO uigcyr_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","андин гуна қурбанлиғиниң қенидин азғина елип қурбангаһниң темиға чачсун; қалған қени болса қурбангаһниң түвигә сиқип чиқирилсун. Буниң өзи гуна қурбанлиғи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Амма иккинчисини болса бекитилгән бәлгүлимә бойичә көйдүрмә қурбанлиқ қилип сунсун. Бу йол билән каһин униң қилған гунайи үчүн кәфарәт кәлтүриду вә шу гуна униңдин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Әгәр икки пахтәк яки икки бачкини кәлтүрүшкә қурби йәтмисә, ундақта гуна қилған киши гуна қурбанлиғи үчүн есил ундин бир әфаһниң ондин бирини кәлтүрсун; бу гуна қурбанлиғи болғачқа у униң үстигә зәйтун мейи қуймисун яки үстигә һеч қандақ мәстики салмисун; чүнки у гуна қурбанлиғи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","У уни каһинниң қешиға кәлтүрсун вә каһин буниңдин сунғучиниң «ядлиниш үлүши» сүпитидә бир чаңгал елип, шуни Пәрвәрдигарға атап отта сунулған қурбанлиқларға қошуп, қурбангаһниң үстидә көйдүрсун. Буниң өзи гуна қурбанлиғи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Бу йол билән у шу гуналардин қайсисини қилған болса, каһин униң үчүн кәфарәт кәлтүриду. ашлиқ һәдийәлиридикигә охшаш қалған қисми каһинға тәвә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Андин Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Бириси билмәй Пәрвәрдигарға аталған муқәддәс нәрсиләргә нисбәтән итаәтсизлик қилип гуна өткүзсә, ундақта у Пәрвәрдигарниң алдиға ушшақ малдин беҗирим бир қочқарни итаәтсизлик қурбанлиғи қилип кәлтүрсун; шу итаәтсизлик қурбанлиғи болған қочқарниң баһасини сән муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә күмүч шәкәлгә тохтатқин.    ");
INSERT INTO uigcyr_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Андин шу киши муқәддәс нәрсиләргә нисбәтән өткүзгән хаталиғидин болған зиянни толдурсун, шундақла зиянниң бәштин бири бойичә қошуп каһинға төләм төлисун. Бу йол билән каһин итаәтсизлик қурбанлиғи болған қочқарниң вастиси билән униң үчүн кәфарәт кәлтүриду; шу гуна униңдин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Әгәр бириси билмәй Пәрвәрдигарниң «қилма» дегән һәр қандақ әмирлириниң бирәрисигә хилаплиқ қилип, гунакар болған болса у қәбиһлигиниң җазасиға тартилиду; ");
INSERT INTO uigcyr_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","шундақ болса, у ушшақ малдин сән тохтатқан қиммәттә беҗирим бир қочқарни итаәтсизлик қурбанлиғи қилип сунсун. Бу йол билән каһин униң билмәй өткүзгән итаәтсизлиги үчүн кәфарәт кәлтүриду вә шу итаәтсизлик гунайи униңдин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Бу итаәтсизлик қурбанлиғи болиду; чүнки у дәрһәқиқәт Пәрвәрдигарниң алдида итаәтсизлик қилған. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Андин Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Әгәр бириси гуна қилип Пәрвәрдигарниң алдида вапасизлиқ қилип, хошниси өзигә аманәт яки капаләткә бәргән бир нәрсә яки хошнисидин зораванлиқ билән буливалған мәлум бир нәрсә тоғрисида ялған гәп қилған болса яки хошнисидин наһәқлиқ билән мәлум нәрсини тартивалған болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","яки жүтүп кәткән бир нәрсини тепивелип униңдин танса яки кишиләрниң гуна садир қилған һәр қандақ бир Иши тоғрисида ялған қәсәм ичсә, ");
INSERT INTO uigcyr_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","У гуна қилған ишта өзини гунакар дәп тонуп йәтсә, ундақта у буливалған яки наһәқ тартивалған нәрсә яки униңға аманәткә берилгән нәрсә болсун, яки жүтүп кетип тепивалған нәрсә болсун, ");
INSERT INTO uigcyr_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","яки у һәр қандақ нәрсә тоғрисида ялған қәсәм ичкән болсун, униң һәммисини толуқ баһаси бойичә төлисун, шундақла шу баниң бәштин бир қисми бойичә қошуп төлисун; у итаәтсизлик қурбанлиғини қилған күнидә төләмни егисигә тапшуруп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Андин у Пәрвәрдигарниң алдиға итаәтсизлик қурбанлиғи сүпитидә ушшақ малдин сән тохтатқан қиммәт бойичә беҗирим бир қочқарни итаәтсизлик қурбанлиғи қилип каһинниң қешиға елип кәлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Каһин бу йол билән униң үчүн Пәрвәрдигарниң алдида кәфарәт кәлтүриду вә у һәр қайси ишта итаәтсизлик қилған болсиму у униңдин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Сән Һарун билән оғуллириға көйдүрмә қурбанлиқ тоғрисида әмир қилип мундақ дегин: — Көйдүрмә қурбанлиқ тоғрисидики қаидә-низам мундақ болиду: — Көйдүрмә қурбанлиқ пүтүн кечә таң атқичә қурбангаһтики очақниң үстидә көйүп турсун; вә қурбангаһниң отини өчүрмәй йениқ турғузуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Каһин канап тонини кийип, ялаңачлиғини йепип, сағрисиғичә канап ич тамбал кийип турсун; қурбангаһниң үстидики от билән көйдүрүлгән көйдүрмә қурбанлиқниң күлини елип, қурбангаһниң бир тәрипидә қойсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","андин кийимлирини селиветип башқа кийимләрни кийип, күлини чедиргаһниң сиртиға елип чиқип пакиз бир җайда қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Қурбангаһниң оти болса һемишә йенип турсун; уни һеч вақит өчүрүшкә болмайду, каһин өзи һәр күни әтигәндә униңға отун селип, үстигә көйдүрмә қурбанлиқни тизсун вә униң үстигә енақлиқ қурбанлиқлириниң мейини қоюп көйдүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Үзүлмәс бир от қурбангаһниң үстидә һемишә көйүп турсун; у һәргиз өчүрүлмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ашлиқ һәдийәси тоғрисидики қаидә-низам мундақ: — Һарунниң оғуллиридин бири уни Пәрвәрдигарниң алдиға, қурбангаһниң алдиға кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","У ашлиқ һәдийәси болған есил унға қолини селип униңдин шундақла униңдики зәйтун мейидин бир чаңгал елип вә һәдийәниң үстидики барлиқ мәстикини қошуп, буларни қурбангаһ үстидә көйдүрсун; бу һәдийәниң «ядлиниш үлүши» болуп, Пәрвәрдигарниң алдида хушбуй кәлтүрүш үчүн қилинған болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ешип қалғанлирини болса Һарун билән оғуллири йесун; у ечитқу селинмай пиширилуп муқәддәс бир җайда йейилсун; улар уни җамаәт чедириниң һойлисида йесун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","У мутләқ ечитқусиз пиширилсун. Мән отта Маңа сунулидиған қурбанлиқ-һәдийәләр ичидин шуни уларниң өз үлүши болсун дәп уларға һәқ қилип бәрдим; у гуна вә итаәтсизликни тилигүчи қурбанлиқларға охшаш «әң муқәддәсләрниң бири» һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Һарунниң әвладидин болған әркәкләрниң һәммиси буниңдин йесун; бу дәвирдин-дәвиргә араңларда әбәдий бир бәлгүлимә болиду; Пәрвәрдигарға атап отта сунулғанлиридин булар уларниң үлүши болсун. Униңға қол тәккүзгүчи җәзмән муқәддәс болуши керәк.    ");
INSERT INTO uigcyr_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Һарун мәсиһлинидиған күнидә у вә оғуллириниң Пәрвәрдигарниң алдиға сунидиғини мундақ болуши керәк: — Улар үзүлмәс ашлиқ һәдийәси сүпитидә есил ундин бир әфаһниң ондин бирини сунуши керәк; әтигини йеримини, ахшими йәнә йеримини сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","У тавида зәйтун мейи билән етилсун; у зәйтун мейиға чилап пиширилғандин кейин сән уни елип кир; ашлиқ һәдийәсиниң пиширилған парчилирини хушбуй сүпитидә Пәрвәрдигарға атап сунғин. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Һарунниң оғуллириниң қайсиси униң орнида турушқа мәсиһләнгән болса уму һәдийәни шундақ тәйярлап сунсун; бу әбәдий мутләқ бир бәлгүлимә болиду. Бу һәдийә Пәрвәрдигарға атап толуқ көйдүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Каһинниң һәр бир ашлиқ һәдийәси болса пүтүнләй көйдүрүлсун; у һәргиз йейилмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Һарун билән оғуллириға мундақ дегин: — Гуна қурбанлиғи тоғрисидики қаидә-низам мундақ: — Гуна қурбанлиғиму көйдүрмә қурбанлиқ боғузлинидиған җайда, Пәрвәрдигарниң алдида боғузлансун; бу хил қурбанлиқ «әң муқәддәсләрниң бири» һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Гуна қурбанлиғини өткүзгүчи каһин өзи уни йесун; қурбанлиқ муқәддәс бир йәрдә, җамаәт чедириниң һойлисида йейилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Униң гөшигә қол тәккүзгүчи һәр ким муқәддәс болмиса болмайду, шуниңдәк әгәр униң қени бирисиниң кийимигә чачрап кәтсә, ундақта қан чечилған җай муқәддәс бир йәрдә жуюлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Қайси сапал қазанда қурбанлиқ қайнитилип пиширилған болса, у сундурулсун. Әгәр у мис қазанда қайнитип пиширилған болса, у қирип сүрүлсун һәм су билән жуюлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Каһинлардин болған барлиқ әр кишиләр униңдин йесә болиду. Бу «әң муқәддәсләрниң бири» һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Һалбуки, муқәддәс җайда кәфарәт кәлтүрүш үчүн қени җамаәт чедириға киргүзүлгән һәр қандақ гуна қурбанлиғи болса, һәргиз йейилмисун, бәлки пүтүнләй көйдүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Итаәтсизлик қурбанлиғи тоғрисидики қаидә-низам мана мундақ: — Бу қурбанлиқ «әң муқәддәсләрниң бири» һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Көйдүрмә қурбанлиқ боғузлинидиған җайда итаәтсизликни тиләш қурбанлиғиму боғузлиниду; каһин қенини қурбангаһниң үсти қисминиң әтрапиға сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Қурбанлиқ қилғучи киши барлиқ мейини сунсун; йәни майлиқ қуйруғи билән ич қарнини йөгәп турған майни, ");
INSERT INTO uigcyr_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","икки бөрәкни вә уларниң үстидики һәмдә икки янпишидики майни аҗритип, җигәрниң бөрәккичә болған чава мейини аҗритип сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Каһин буларни Пәрвәрдигарға атап отта сунулидиған қурбанлиқ сүпитидә қурбангаһта көйдүрсун. Бу итаәтсизлик қурбанлиғи болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Каһинлардин болған әр кишиләрниң һәммиси буни йесун; у муқәддәс йәрдә йейилсун; у «әң муқәддәсләрниң бири» һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Гуна қурбанлиғи қандақ болса итаәтсизлик қурбанлиғиму шундақ болиду; улар иккиси тоғрисидики қаидә-низам охшаш; бу қурбанлиқ кәфарәт кәлтүрүшкә қурбанлиқ өткүзгүчи каһинниң өзигә тәвә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Каһин бирисиниң сунған көйдүрмә қурбанлиғини өткүзгән болса, көйдүрмә қурбанлиқниң териси шу каһинниң болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Тонурда пиширилған һәр бир ашлиқ һәдийәси, шундақла қазанда яки тавида етилгән һәр бир ашлиқ һәдийәси болса уни өткүзгән каһинниң болиду, йәни каһинниң өзигә тәвә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Һәр бир ашлиқ һәдийәси, мәйли зәйтун мейи арилаштурулған болсун, яки қуруқ кәлтүрүлгән болсун, булар Һарунниң оғуллириниң һәр биригә баравәр бөлүп берилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Пәрвәрдигарға атап кәлтүрүлгән енақлиқ қурбанлиғи тоғрисидики қаидә-низам мундақ: — ");
INSERT INTO uigcyr_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Сунмақчи болған киши уни тәшәккүр ейтиш үчүн сунса, ундақта у «тәшәккүр қурбанлиғи» билән биллә зәйтун мейи иләштүрүлгән петир тоғачлар, зәйтун мейи сүрүлүп мәсиһләнгән петир һәмәк нанлар вә есил ундин зәйтун мейиға чилап пиширилған тоғачларниму кәлтүрсун.    ");
INSERT INTO uigcyr_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Шу тоғачлардин башқа, йәнә тәшәккүр ейтидиған енақлиқ қурбанлиғи билән биллә ечитқу селинған нанларниму сунсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","у шу сунғанлириниң һәр бир түридин бирни елип Пәрвәрдигар үчүн қош қоллап сунидиған «көтәрмә һәдийә» қилип кәлтүрсун; бу енақлиқ қурбанлиғиниң қенини қурбангаһниң үстигә сәпкән каһинниң өзигә тәгсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Тәшәккүр билдүридиған енақлиқ қурбанлиғиниң гөши болса қурбанлиқ қилинған шу күни йейилиши керәк; қурбанлиқни сунғучи киши таң атқичә униң һеч немисини қалдурмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Әгәр униң сунған қурбанлиғи қәсимигә хас қурбанлиқ яки ихтиярий кәлтүргән қурбанлиқ болса, ундақта һайванниң гөши қурбанлиқ қилинған күндә йейилсун; униңдин ешип қалғинини болса, әтисиму йейишкә болиду; ");
INSERT INTO uigcyr_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","лекин қурбанлиқниң гөшидин үчинчи күнигичә ешип қалса, у отта көйдүрүлүши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Енақлиқ қурбанлиғиниң гөшидин үчинчи күнидә йейилсә, ундақта қурбанлиқ қобул болмайду, қурбанлиқ сунғучиниң һесавиғиму һесапланмайду, бәлки мәкруһ болиду; кимдәким униңдин йесә өз қәбиһлигиниң җазасиға тартилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Шундақла напак нәрсигә тегип қалған гөшму йейилмәслиги керәк, бәлки отта көйдүрүлүши керәк. Һәр қандақ пак адәм напак нәрсигә тәгмигән қурбанлиқниң гөшини йесә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Лекин кимки напак һаләттә туруп Пәрвәрдигарға аталған енақлиқ қурбанлиғидин йесә, ундақта у өз хәлқидин үзүп ташлиниду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Кимки напак бир нәрсигә тегип кәтсә (мәйли напак һаләттики адәм болсун, напак бир һайван болсун яки һәр қандақ напак жиркиничлик нәрсә болсун) вә шундақла Пәрвәрдигарға хас аталған енақлиқ қурбанлиғиниң гөшидин йесә, ундақта у өз хәлқидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Исраилларға мундақ дегин: — Силәр кала, қой вә өшкиләрниң мейини һәргиз йемәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Өзлүгидин өлгән яки житқучлар боғуп қойған һайванниң җәситиниң мейини һәр қандақ ишқа ишләткили болиду, лекин һәргиз униңдин йемәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Чүнки кимки Пәрвәрдигарға атап отта сунулидиған һәр қандақ һайванниң мейини йесә, шуни йегән киши өз хәлиқлиридин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Силәр һәр қандақ турар җайиңларда һеч қандақ қанни, йәни учар-қанатларниң болсун яки чарпайларниң болсун қенини һәргиз естимал қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Кимдәким һәр қандақ қанни естимал қилса, шу киши өз хәлиқлиридин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Исраилларға мундақ дегин: — Кимки Пәрвәрдигарға атап бир енақлиқ қурбанлиғи сунса, ундақта у Пәрвәрдигарға хас болған һәдийәни шу енақлиқ қурбанлиқтин айрип кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Өз қоли билән Пәрвәрдигарға атиған, отта сунулидиған һәдийәләрни, йәни май билән төшни қошуп елип келип, төшни «пулаңлатма һәдийә» сүпитидә Пәрвәрдигарниң алдида пулаңлатсун.    ");
INSERT INTO uigcyr_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Каһин мейини қурбангаһ үстидә көйдүрүвәтсун. Төш болса Һарун билән униң оғуллириға хас болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Енақлиқ қурбанлиқлириңларниң оң арқа путини силәр «көтәрмә һәдийә» сүпитидә каһинға бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Һарунниң оғуллиридин қайсиси енақлиқ қурбанлиғиниң қени билән мейини сунған болса өз үлүши үчүн оң арқа путини өзи алсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Чүнки Мән Исраилларниң енақлиқ қурбанлиқлиридин «пулаңлатма һәдийә» болған төш билән «көтәрмә һәдийә» болған арқа путини әбәдий бир бәлгүлимә билән Исраиллардин елип, каһин Һарун вә униң оғуллириниң һәққи болсун дәп уларға тәқдим қилдим.    ");
INSERT INTO uigcyr_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Муса Һарун билән оғуллирини Пәрвәрдигарниң қуллуғида каһин болушқа униң алдиға кәлтүргән күнидә, уларға Пәрвәрдигарға атап отта сунулидиған қурбанлиқлардин тәқдим қилинидиған каһинлиқ үлүши мана шудур. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Муса уларни мәсиһлигән күнидә, Пәрвәрдигар бу үлүшни Исраиллардин елип уларға берилсун дәп әмир қилған. Бу Исраилларға дәвирдин дәвиргичә әбәдий бир бәлгүлимә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Көйдүрмә қурбанлиқ билән ашлиқ һәдийәси, гуна қурбанлиғи билән итаәтсизлик қурбанлиғи, каһинлиққа тикләш қурбанлиғи билән енақлиқ қурбанлиғи тоғрисидики қаидә-низам мана шудур. ");
INSERT INTO uigcyr_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Пәрвәрдигар Исраилларға: «Силәр бу Синай баяванида Пәрвәрдигарниң алдиға қурбанлиқлириңларни сунуңлар» дәп буйруған күнидә, у буларниң һәммисини Синай теғида Мусаға тапшурған еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Һарунни оғуллири билән биллә, вә уларниң мәхсус кийимлирини, «мәсиһләш мейи»ни, гуна қурбанлиғи болидиған топақ билән икки қочқарни, петир нан селинған севәтни елип келип,    ");
INSERT INTO uigcyr_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Исраилниң пүтүн җамаитини җамаәт чедириниң кириш ағзиниң алдиға җәм қилғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Муса Пәрвәрдигар униңға буйруғинидәк қилди, җамаәт җамаәт чедириниң кириш ағзиниң алдиға жиғилди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Андин Муса җамаәткә: — Пәрвәрдигар буйруған иш мана мундақ, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Шуниң билән Муса Һарун билән униң оғуллирини алдиға кәлтүрүп уларни су билән жуюп, ");
INSERT INTO uigcyr_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Һарунға көйнәк кийдүрүп, бәлвағ бағлап, тонни кийдүрди вә үстигә әфодни япти; у әфодниң бәлвеғини бағлап, әфодни униңға тақап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Андин Муса униңға «қошен»ни тақап, қошенниң ичигә «урим билән туммим»ни селип,    ");
INSERT INTO uigcyr_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Бешиға сәллә йөгәп Пәрвәрдигар униңға буйруғинидәк сәллиниң алди тәрипигә «алтун тахтилиқ муқәддәс отуғат»ни бекитип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Андин Муса мәсиһләш мейини елип ибадәт чедири билән ичидики барлиқ нәрсиләрниң һәммисини мәсиһләп муқәддәс қилди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","У майдин елип қурбангаһқа йәттә мәртивә чечип, қурбангаһ билән униң барчә қача-қучилирини, жуюнуш деси вә тәглигини Худаға атап муқәддәс қилишқа мәсиһлиди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","У йәнә мәсиһләш мейидин азрақ елип Һарунниң бешиға қуюп уни Худаға атап муқәддәс қилишқа мәсиһлиди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Андин Муса Һарунниң оғуллирини алдиға кәлтүрүп, Пәрвәрдигар униңға буйруғинидәк уларға көйнәк кийдүрүп, бәллиригә бәлвағ бағлап, уларға егиз бөкләрниму тақап қойди.    ");
INSERT INTO uigcyr_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Андин у гуна қурбанлиғи қилинидиған топақни йетиләп кәлди; Һарун билән униң оғуллири гуна қурбанлиғи қилинидиған топақниң бешиға қоллирини қойди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","У уни боғузлиди, андин Муса қенидин елип, өз бармиғи билән қурбангаһниң мүңгүзлиригә, чөрисигә сүрүп қурбангаһни гунадин паклиди; қалған қанни болса у қурбангаһниң түвигә төкүп, муқәддәс болушқа кәфарәт кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Андин у ич қарнини йөгәп турған майниң һәммисини, җигәрниң үстидики чава майни, икки бөрәк вә үстидики майлирини қошуп алди; андин Муса буларни қурбангаһниң үстидә көйдүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Бирақ Муса топақниң териси билән гөши вә тезигини болса Пәрвәрдигар өзигә буйруғинидәк чедиргаһниң ташқирида отта көйдүрүвәтти.    ");
INSERT INTO uigcyr_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Андин у көйдүрмә қурбанлиқ қилинидиған қочқарни кәлтүрди; Һарун билән униң оғуллири қоллирини қочқарниң бешиға қойди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Һарун қочқарни боғузлиди; андин Муса қенини елип қурбангаһниң үсти қисминиң әтрапиға сәпти; ");
INSERT INTO uigcyr_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Һарун қочқарни парчә-парчә қилип парчилиди; андин Муса бешини, парчиланған гөшлирини барлиқ мейи билән қошуп көйдүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Үчәй-қеринлири билән пачақлирини суда жуйди. Андин Муса қочқарни пүтүн пети қурбангаһ үстидә көйдүрди. Бу Пәрвәрдигар Мусаға буйруған, «Пәрвәрдигарға атап отта сунулидиған хушбуй чиқидиған қурбанлиқ» еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Андин у каһинлиққа тикләш қурбанлиғи қилинидиған қочқарни, иккинчи қочқарни кәлтүрди; Һарун билән униң оғуллири қоллирини қочқарниң бешиға қойди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","У уни боғузлиди; вә Муса униң қенидин елип Һарунниң оң қулиқиниң юмшиқи билән оң қолиниң баш бармиғиға сүрүп вә оң путиниң чоң бармиғиғиму сугап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Андин Муса Һарунниң оғуллирини алдиға кәлтүрүп, қандин елип уларниң оң қулақлириниң юмшиқи билән оң қоллириниң баш бармақлириға сүрди, уларниң оң путлириниң чоң бармақлириғиму сугап қойди, қалған қанни Муса қурбангаһниң чөрисигә сәпти. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Шундақ қилип, у мейи билән майлиқ қуйруғини, ич қарнини йөгәп турған барлиқ май билән җигәрниң үстидики чава мейини, икки бөрәк вә үстидики майлирини қошуп елип оң арқа путиниму кесип елип, ");
INSERT INTO uigcyr_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Пәрвәрдигарниң алдидики петир нан селинған севәттин бир петир тоғач билән бир зәйтун май тоғичи вә бир данә һәмәк нанни елип буларни май билән оң арқа путниң үстидә қойди; ");
INSERT INTO uigcyr_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","андин буларниң һәммисини Һарун билән униң оғуллириниң қоллириға тутқузуп, пулаңлатма һәдийә болсун дәп Пәрвәрдигарниң алдида пулаңлатти. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Андин Муса буларни уларниң қоллиридин елип қурбангаһтики көйдүрмә қурбанлиқниң үстидә қоюп көйдүрди. Бу «каһинлиққа тикләш қурбанлиғи» болуп, Пәрвәрдигарға атап отта сунулидиған, хушбуй чиқидиған қурбанлиқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Андин Муса төшни елип пулаңлатма һәдийә сүпитидә Пәрвәрдигарниң алдида пулаңлатти; Пәрвәрдигарниң униңға буйруғини бойичә, «каһинлиққа тикләш қурбанлиғи» болған қочқарниң бу қисми Мусаниң үлүши еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Андин Муса мәсиһләш мейидин вә қурбангаһниң үстидики қандин бир аз елип, Һарун билән униң кийимлиригә вә оғуллири билән уларниң кийимлиригә сәпти. Шундақ қилип, у Һарун вә кийимлирини, оғуллири билән уларниң кийимлирини муқәддәс қилди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Муса Һарун билән униң оғуллириға мундақ буйруди: — «Бу гөшни җамаәт чедириниң кириш ағзида қайнитип пиширип шу йәрдә олтирип «каһинлиққа тикләш қурбанлиғи»ға тәвә болған севәттики нан билән қошуп йәңлар; буларни Һарун билән оғуллири йесун, дәп буйруғинимдәк уни йәңлар; ");
INSERT INTO uigcyr_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","лекин гөш билән нандин ешип қалғанлириниң һәммисини отта көйдүрүветиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Силәр йәттә күнгичә җамаәт чедириниң кириш ағзидин чиқмай, Худаға атап каһинлиққа тикләш күнлириңлар тошқичә шу йәрдә туруңлар; чүнки силәрни Худаға атап каһинлиққа тикләш үчүн йәттә күн кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Бүгүн қилинған ишлар Пәрвәрдигарниң буйруғини бойичә силәр үчүн кәфарәт кәлтүрүлсун дәп қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Силәр өлмәслигиңлар үчүн Пәрвәрдигарниң әмрини тутуп җамаәт чедириниң кириш ағзиниң алдида кечә-күндүз йәттә күн турушуңлар керәк; чүнки маңа шундақ буйрулди». ");
INSERT INTO uigcyr_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Һарун билән оғуллири Пәрвәрдигарниң Мусаниң вастиси билән буйруғининиң һәммисини беҗа кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Сәккизинчи күни Муса Һарун билән униң оғуллири вә Исраилниң ақсақаллирини чақирип, ");
INSERT INTO uigcyr_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Һарунға мундақ деди: — «Сән гуна қурбанлиғиға беҗирим бир мозайни, көйдүрмә қурбанлиққа беҗирим бир қочқарни өзүң үчүн елип, Пәрвәрдигарниң алдиға кәлтүргин, ");
INSERT INTO uigcyr_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","андин Исраилларға сөз қилип: — Силәр гуна қурбанлиғи үчүн бир текә елип келиңлар, көйдүрмә қурбанлиқ үчүн бир мозай вә бир қоза елип келиңлар, һәр иккиси беҗирим, бир яшқа киргән болсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Пәрвәрдигарниң алдида сунушқа енақлиқ қурбанлиғи сүпитидә бир топақ билән бир қочқарни елип, зәйтун мейи иләштүрүлгән ашлиқ һәдийәси билән биллә кәлтүрүңлар; чүнки бүгүн Пәрвәрдигар Өзини силәргә аян қилиду, дегин». ");
INSERT INTO uigcyr_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Улар Муса буйруған нәрсиләрни җамаәт чедириниң алдиға елип кәлди; пүткүл җамаәт йеқин келип, Пәрвәрдигарниң алдида һазир болуп турди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Муса: — Мана, бу Пәрвәрдигар буйруған иштур; буни қилсаңлар Пәрвәрдигарниң шан-шәриви силәргә аян болиду, деди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Шуниң билән Муса Һарунға: — Сән қурбангаһқа йеқин берип гуна қурбанлиғиң билән көйдүрмә қурбанлиғиңни сунуп өзүң вә хәлиқ үчүн кәфарәт кәлтүргин; андин хәлиқниң қурбанлиғиниму сунуп, Пәрвәрдигар әмир қилғандәк улар һәққидә кәфарәт кәлтүргин» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Шуни девиди, Һарун қурбангаһқа йеқин берип өзи үчүн гуна қурбанлиғи болидиған мозайни боғузлиди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Һарунниң оғуллири қанни униңға сунуп бәрди; у бармиғини қанға тәккүзүп, қурбангаһниң мүңгүзлиригә сүрди, қалған қанни қурбангаһниң түвигә қуйди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Гуна қурбанлиғиниң мейи билән икки бөрәк вә җигәрниң үстидики чава майни елип, Пәрвәрдигар Мусаға буйруғинидәк уларни қурбангаһ үстидә көйдүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Гөш билән терисини болса чедиргаһниң ташқириға елип чиқип отта көйдүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Андин у көйдүрмә қурбанлиқ қилидиған қочқарни боғозлиди; Һарунниң оғуллири униңға қанни сунуп бәрди; у буни қурбангаһниң үсти қисминиң әтрапиға сәпти. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Андин улар парчә-парчә қилинған көйдүрмә қурбанлиқни беши билән биллә униңға сунуп бәрди; у буларни қурбангаһта көйдүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","У ич қарни билән пачақлирини жуюп, буларниму қурбангаһниң үстидә, көйдүрмә қурбанлиқниң үстигә қоюп көйдүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Андин у хәлиқниң қурбанлиғини кәлтүрди; хәлиқниң гуна қурбанлиғи болған текини боғузлап, илгири һайванни сунғандәк униму гуна қурбанлиғи қилип сунди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","У көйдүрмә қурбанлиқ қилидиған мални кәлтүрүп буниму бәлгүлимә бойичә сунди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Андин у ашлиқ һәдийәсини кәлтүрүп униңдин бир чаңгал елип әтигәнлик көйдүрмә қурбанлиққа қошуп қурбангаһ үстидә көйдүрди.    ");
INSERT INTO uigcyr_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Андин хәлиққә болидиған енақлиқ қурбанлиғи болидиған топақ билән қочқарни боғузлиди. Һарунниң оғуллири қенини униңға сунуп бәрди; у буни қурбангаһниң үсти қисминиң әтрапиға сәпти. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Улар топақ билән қочқарниң май қисмини, йәни майлиқ қуйруғи, ич қарнини йөгәп турған майлирини, икки бөрәк вә җигәрниң чава мейини елип, ");
INSERT INTO uigcyr_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Бу май парчилирини икки төшниң үстидә қойди, Һарун буларни қурбангаһниң үстидә көйдүрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Ахирида Һарун икки төш билән оң арқа путини пулаңлатма һәдийә сүпитидә Мусаниң буйруғинидәк Пәрвәрдигарниң алдида пулаңлатти. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Андин Һарун қоллирини хәлиққә қаритип көтирип, уларға бәхит тилиди; у гуна қурбанлиғи, көйдүрмә қурбанлиқ вә енақлиқ қурбанлиғини сунуп, қурбангаһтин чүшти. ");
INSERT INTO uigcyr_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Муса билән Һарун җамаәт чедириға кирип, йәнә йенип чиқип хәлиққә бәхит тилиди; шуниң билән Пәрвәрдигарниң шан-шәриви пүткүл хәлиққә аян болди; ");
INSERT INTO uigcyr_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Пәрвәрдигарниң алдидин от чиқип, қурбангаһ үстидики көйдүрмә қурбанлиқ билән майларни жутуп кәтти. Пүткүл хәлиқ буни көрүп, товлишип, дүм жиқилишти. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Һарунниң оғуллири Надаб билән Абиһу иккиси өз хушбуйданини елип униңға от йеқип үстигә хушбуйни селип, Пәрвәрдигар уларға буйруп бақмиған ғәйрий бир отни Пәрвәрдигарға сунди; ");
INSERT INTO uigcyr_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","шуниң билән Пәрвәрдигарниң алдидин от чиқип уларни йәвәтти; шуан улар Пәрвәрдигарниң алдида өлди. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Муса Һарунға: — Мана, бу Пәрвәрдигарниң: «Мән Маңа йеқин кәлгән адәмләрдә Өзүмниң муқәддәс екәнлигимни көрситимән вә барлиқ хәлиқниң алдида улуқлинимән» дегән сөзиниң өзидур, деди. Шуни девиди, Һарун җим туруп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Муса Һарунниң тағиси Уззиәлниң оғуллири болған Мишаәл билән Әлзафанни чақирип уларға: — Силәр йеқин келип өз қериндашлириңларни муқәддәс җайниң алдидин көтирип, чедиргаһниң ташқириға елип чиқиңлар» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Шуниң билән улар йеқин келип, уларни кийиклик көйнәклири билән көтирип Мусаниң буйруғинидәк чедиргаһниң ташқириға елип чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Муса Һарун вә оғуллири Әлиазар билән Итамарға: — Силәр башлириңларни очуқ қоймаңлар, кийимлириңларни житмаңлар; болмиса өзүңлар өлүп, пүткүл җамаәткә ғәзәп кәлтүрисиләр; лекин қериндашлириңлар болған пүткүл Исраил җәмәти Пәрвәрдигар яққан от түпәйлидин матәм тутуп жиғлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Амма силәр болсаңлар Пәрвәрдигарниң мәсиһләш мейи үстүңларға сүрүлгән болғачқа, җамаәт чедириниң ташқириға чиқмаңлар; болмиса өлисиләр, деди. Шуни девиди, улар Мусаниң буйруғинидәк қилди. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Пәрвәрдигар Һарунға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Сән өзүң вә оғуллириң шарап вә я башқа күчлүк һарақларни ичип, җамаәт чедириға һәргиз кирмәңлар; болмиса, өлүп кетисиләр. Бу силәр үчүн дәвирдин-дәвиргә әбәдий бир бәлгүлимә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Шундақ қилсаңлар, муқәддәс билән адәттикини, пак билән напакни пәриқ етип аҗриталайдиған болисиләр; ");
INSERT INTO uigcyr_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","шундақла Пәрвәрдигар Мусаниң вастиси билән Исраилларға тапшурған һәммә бәлгүлимиләрни уларға үгитәләйсиләр». ");
INSERT INTO uigcyr_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Муса Һарун вә униң тирик қалған оғуллири Әлиазар билән Итамарға мундақ деди: — «Силәр Пәрвәрдигарға атап отта сунулидиған қурбанлиқ-һәдийәләрдин ешип қалған ашлиқ һәдийәсини елип уни қурбангаһниң йенида ечитқу арилаштурмиған һалда йәңлар; чүнки у «әң муқәддәсләрниң бири» һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Бу Пәрвәрдигарға атап отта сунулидиған нәрсиләрдин сениң несивәң вә оғуллириңниң несивиси болғачқа, уни муқәддәс җайда йейишиңлар керәк; чүнки маңа шундақ буйрулғандур. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Униңдин башқа пулаңлатма һәдийә қилинған төш билән көтәрмә һәдийә қилинған арқа путни сән вә оғул-қизлириң биллә пак бир җайда йәңлар; чүнки булар сениң несивәң билән оғуллириңниң несивиси болсун дәп, Исраилларниң енақлиқ қурбанлиқлиридин силәргә берилгән. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Улар көтәрмә һәдийә қилинған арқа пут билән пулаңлатма һәдийә қилинған төшни отта сунулидиған майлири билән қошуп, Пәрвәрдигарниң алдида пулаңлатма һәдийә сүпитидә пулаңлитиш үчүн кәлтүрсун; Пәрвәрдигарниң буйруғини бойичә булар сениң вә оғуллириңниң несивиси болиду; бу әбәдий бир бәлгүлимә болиду». ");
INSERT INTO uigcyr_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Андин Муса гуна қурбанлиғи қилидиған текини издивиди, мана у аллиқачан көйдүрүлүп болған еди. Бу сәвәптин у Һарунниң тирик қалған икки оғли Әлиазар билән Итамарға аччиқлинип: ");
INSERT INTO uigcyr_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","— Немишкә силәр гуна қурбанлиғиниң гөшини муқәддәс җайда йемидиңлар? Чүнки у «әң муқәддәсләрниң бири» һесаплинатти, Пәрвәрдигар силәрни җамаәтниң гунайини көтирип улар үчүн униң алдида кәфарәт кәлтүрсун дәп, шуни силәргә тәқсим қилған еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Мана, униң қени муқәддәс җайниң ичигә кәлтүрүлмиди; силәр әслидә мән буйруғандәк уни муқәддәс җайда йейишиңлар керәк еди, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Лекин Һарун Мусаға: — Мана, булар бүгүн тоғра иш қилип өзлириниң гуна қурбанлиғи билән көйдүрмә қурбанлиғини Пәрвәрдигарниң алдида сунди; мениң бешимға шу ишлар кәлди; әгәр мән бүгүн гуна қурбанлиғиниң гөшини йегән болсам, Пәрвәрдигарниң нәзиридә убдан болаттиму? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Муса буни аңлап җававидин рази болди. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Пәрвәрдигар Муса билән Һарунға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Исраилларға мундақ дегин: — Йәр йүзидики барлиқ һайванларниң ичидин силәргә йейишкә болидиған җаниварлар шуки: — ");
INSERT INTO uigcyr_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Һайванлар ичидә һәм туяқлири пүтүн ачимақ (туяқлири пүтүнләй йериқ) һәм көшигүчи һайванларниң һәр бирини йесәңлар болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Лекин көшигүчи яки ачимақ туяқлиқ һайванлардин төвәндикиләрни йемәслигиңлар керәк: — Төгә: чүнки у көшигини билән туйиғи ачимақ әмәс. Шуңа у силәргә һарам болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Суғур болса көшигини билән туйиғи ачимақ әмәс — у силәргә һарам болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Тошқан болса буму көшигини билән туйиғи ачимақ әмәс — у силәргә һарам болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Чошқа болса туяқлири ачимақ (туяқлири пүтүнләй йериқ) болғини билән көшимигини үчүн силәргә һарам болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Силәр шу һайванларниң гөшидин йемәслигиңлар керәк вә уларниң өлүгигиму тәгмәңлар. Улар болса силәргә һарам болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Суда яшайдиған җаниварлардин төвәндикиләрни йейишкә болиду: — судики, йәни дәрия-деңизлардики җаниварлардин қанити вә қасирақлири болғанларни йейишкә болиду; ");
INSERT INTO uigcyr_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","лекин дәрия-деңизларда яшайдиған, йәни суларда топ-топ үзидиған барлиқ җаниварлардин, қасирақлири яки қанити болмиғанлирини йемәслигиңлар керәк; улар силәргә жиркиничлик саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Мәзкур җаниварлар дәрвәқә силәргә жиркиничлик саналсун; силәр уларниң гөшидин йемәслигиңлар керәк; уларниң өлүгини жиркиничлик дәп қараңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Судики җаниварларниң ичидин қанити билән қасириғи болмиған җаниварларниң һәммиси силәргә жиркиничлик саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Учар-қанатлардин төвәндикиләр силәргә жиркиничликтур; улар йейилмәслиги керәк вә силәргә жиркиничлик болсун: — йәни бүркүт, қорултаз-тапқушлар, деңиз бүркүти, ");
INSERT INTO uigcyr_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","қарлиғач қуйруқлуқ сар, лачин вә уларниң хиллири, ");
INSERT INTO uigcyr_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","һәммә қарға-қозғунлар вә уларниң хиллири, ");
INSERT INTO uigcyr_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","мөшүкяпилақ, төгиқуш, чайка, сар вә уларниң хиллири, ");
INSERT INTO uigcyr_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","һувқуш, қарна, ибис, ");
INSERT INTO uigcyr_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","аққу, сақийқуш, белиқъалғуч, ");
INSERT INTO uigcyr_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ләйләк, турна вә униң хиллири, һөпүп вә шәпәрәң қатарлиқлар силәргә һарам саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Буниңдин башқа төрт путлап маңидиған, учидиған ушшақ җаниварларниң һәммиси силәргә жиркиничлик болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Һалбуки, төрт путлап маңидиған, учидиған ушшақ җаниварлардин төвәндикиләрни йесәңлар болиду: — пути билән үгилик пачиғи болуп, йәр йүзидә сәкрәләйдиғанларни йесәңлар болиду; ");
INSERT INTO uigcyr_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","буларниң ичидин силәргә йейишкә болидиғанлири: — чекәткә вә униң хиллири, қара чекәткә вә униң хиллири, томузға вә униң хиллири, чақчиқиз вә униң хиллири. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Лекин төрт путлуқ болған өмилигүчи һәм учидиған һәммә башқа җаниварлар силәргә жиркиничлик саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Бу җаниварлардинму мундақ йол билән напак болисиләр; бирким уларниң өлүк тенигә тәгсә кәч киргичә напак һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Кимдәким буларниң өлүгиниң бир қисмини көтәрсә өз кийимлирини жуюши керәк, у киши кәч киргичә напак һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Туяқлири ачимақ, бирақ пүтүнләй бөлүнмигән яки көшимәйдиған һайванларниң һәммиси силәргә һарамдур; һәр ким уларниң өлүгигә тәгсә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Төрт пути билән маңидиған һайванларниң ичидин тапини билән маңидиғанларниң һәммиси силәргә напак болуп, һәр ким уларниң өлүк тәнлиригә тәгсә кәч киргичә напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Кимки уларниң өлүгини көтәрсә өз кийимлирини жуюши керәк, у киши кәч киргичә напак туриду. Бу һайванлар болса силәргә һарам болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Йәр йүзидә өмилигүчи ушшақ җаниварларниң ичидин силәргә һарам болғанлар мунулар: — қариғу зокор, чашқан, кәсләнчүк вә уларниң түрлири, ");
INSERT INTO uigcyr_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","салма, қизил кәсләнчүк, там кәсләнчүги, түгүрүк кәсләнчүк вә хамелеон қатарлиқлар һарам болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Буларниң һәммиси йәр йүзидә өмилигүчи һәммә ушшақ җаниварларниң ичидә силәргә һарам болиду; уларниң өлүгигә тәгсә, кәч киргичә напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Бу җаниварларниң өлүги һәр қандақ немигә чүшүп қалса шу немә напак һесаплиниду — һәр қандақ яғач қача-қуча болсун, кийим болсун, терә болсун, тағар болсун, һәр қандақ ишқа ишлитилидиған әсвап болсун, суға чилиниши керәк; улар кәч киргичә напак санилип, кейин пак болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Буларниң бири сапалдин ясалған һәр қандақ қача ичигә чүшүп қалса, шу қача ичидики һәммә нәрсә напак саналсун вә қача өзи сундурулсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Әгәр қачидики судин аш-таам үстигә чачрап кәтсә, аш-таам напак саналсун вә шундақла қачидики һәр қандақ ичимликму напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Һәр немигә ундақ өлүкниң бирәр қисми чүшүп қалсиму, напак саналсун. Әгәр тонур вә очақ болса, напак болди дәп чеқиветилсун; улар силәргә һарам болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Лекин шундақ әһвалда булақ яки су жиғилидиған көлчәк йәнила пак санилиду; амма бирким уларниң өлүк тенигә тәгсә напак болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Әгәр ундақ өлүкниң бирәр қисми теришқа тәйярланған данларға чүшүп қалса, буму йәнила пак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Лекин әгәр данниң үстигә су қуюлғандин кейин шундақ бир өлүкниң бирәр қисми чүшүп қалса, ундақта бу данлар силәргә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Әгәр силәргә йейишкә болидиған һайванлардин бири өлүп қалса, униң өлүгигә тәккән киши кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Кимки ундақ өлүкниң гөшидин йесә, өз кийимлирини жуюши керәк вә кәч киргичә напак саналсун; шундақла ундақ бир өлүкни көтәргән кишиму кийимлирини жуюши керәк вә у киши кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Йәр йүзидә өмилигүчи һәммә ушшақ җаниварлар жиркиничлик санилип, һәргиз йейилмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Қосиғи билән беғирлап маңидиған җанивар болсун, йәр йүзидә жүрүп төрт пути билән яки көп путлири билән маңидиған өмилигүчи җаниварларниң һәртүрлүгини болса, уларни һәргиз йемәңлар; чүнки улар жиркиничликтур. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Силәр болсаңлар мундақ өмилигүчи җаниварниң сәвәвидин өзүңларни жиркиничлик қилмаслиғиңлар керәк. Өзүңларни улар түпәйлидин напак қилмаңлар, болмиса уларниң сәвәвидин булғинип қалисиләр; ");
INSERT INTO uigcyr_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","чүнки Мән Худайиңлардурмән. Силәр өзүңларни Өзүмгә атап муқәддәс қилишиңлар керәк; Мән Өзүм муқәддәс болғач силәрму өзүңларни муқәддәс тутушуңлар керәк. Силәр өзүңларни йәр йүзидә өмилигүчи ушшақ һәр қандақ җаниварларниң сәвәвидин напак қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Чүнки Мән өз Худайиңлар болушқа силәрни Мисир зиминидин чиқирип кәлгән Пәрвәрдигардурмән; силәр муқәддәс болуңлар, чүнки Мән муқәддәстурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Шулар болса чарпай билән учар-қанатлар, суда жүридиған һәр бир җанивар билән йәр йүзидә өмилигүчи һәр бир ушшақ җаниварлар тоғрисидики қанун-бәлгүлимидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Булар билән һарам-һалални уқуп, йейишкә болидиған һайван билән йейишкә болмайдиған һайванларни пәриқ етәләйсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Исраилларға сөз қилип мундақ дегин: — «Аял киши һамилдар болуп оғул туғса, адәт көрүп ағриқ болған күнлиридикидәк йәттә күнгичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Сәккизинчи күни оғли болса хәтнә қилинсун.    ");
INSERT INTO uigcyr_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Аял болса шуниңдин кейин оттуз үч күнгичә «қан паклиниш»та турсун; паклиниш күнлири тамам болмиғичә һеч бир муқәддәс нәрсигә тәгмисун, муқәддәс җайғиму кирмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Әгәр у қиз туғса ундақта адәт күнлиридикидәк икки һәптигичә напак туруп, андин атмиш алтә күнгичә «қан паклиниш»та турсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Мәйли оғул яки қиз туғсун, қан паклиниш күнлири тамам болғандин кейин у аял көйдүрмә қурбанлиқ үчүн бир яшқа киргән қозини, гуна қурбанлиғи үчүн бир бачка яки пахтәкни елип җамаәт чедириниң кириш ағзиға, каһинниң қешиға кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Каһин уни Пәрвәрдигарниң алдида сунуп, шу аял үчүн кәфарәт кәлтүриду; шуниң билән у хунидин пак болиду. Оғул яки қиз туққан аял тоғрисидики қанун-бәлгүлимә мана шудур. ");
INSERT INTO uigcyr_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Әгәр униң қозиға қурби йәтмисә, у икки пахтәк яки икки бачка кәлтүрсун; уларниң бири көйдүрмә қурбанлиқ үчүн, йәнә бири гуна қурбанлиғи үчүн болиду; шу йол билән каһин униң үчүн кәфарәт кәлтүриду; у аял пак болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Пәрвәрдигар Муса билән Һарунға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Бирисиниң бәдининиң терисидә бир чиқан, яки тәмрәткә яки пақирақ ташма чиқип, униңдин бәдининиң терисидә песә-мохо кесилиниң җараһити пәйда болған болса, у киши Һарун каһинниң яки униң каһин оғуллиридин бириниң қешиға кәлтүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Каһин униң бәдининиң җараһитигә қарайду; җараһәт болған җайниң түки ақирип кәткән һәмдә җараһәтму әтрапидики теридин қениқрақ көрүнсә, бу песә-мохо кесәллигидур. Шуңа каһин уни көргәндин кейин шу кишини «напак» дәп җакалисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Лекин әгәр униң бәдининиң терисидики пәйда болған әшу ялтирақ чиқан ақ болуп, әтрапидики теридин қениқрақ көрүнмисә вә түкиму ақирип кәтмигән болса, каһин бу җараһәт бар кишини йәттә күнгичә айрим солап қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Йәттинчи күни каһин униңға қарисун вә әгәр җараһәт охшаш туруп, терисидә кеңийип кәтмигән болса, каһин уни йәнә йәттә күнгичә айрим солап қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Йәттинчи күни каһин униңға йәнә қарисун вә җараһәтниң рәңги суслашқан вә кеңийип кәтмигән болса, ундақта каһин уни «пак» дәп җакалисун; җараһәтниң пәқәт бир чақа екәнлиги бекитилип, кесәл киши өз кийимлирини жуюп пак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Лекин әгәр у каһинға көрүнүп «пак» дәп җакаланғандин кейин шу чақа терисидә кеңийип кәтсә, ундақта у йәнә бир қетим каһинға көрүнсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Каһин униңға йәнә қарисун вә әгәр чақа униң терисидә кеңийип кәткән болса, каһин уни «напак» дәп җакалисун; у җараһәт песә-моходур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Әгәр биркимдә песә-мохо җараһити пәйда болуп қалса каһинниң қешиға кәлтүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Каһин униң җараһитигә сәпселип қарисун; вә әгәр терисидә ақ бир чиқан пәйда болған, түки ақирип кәткән болса вә чиқан чиққан җайда әт-гөши көрүнүп қалған болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","бу униң бәдининиң терисигә чүшкән кона песә-мохо җараһитиниң қайтидин қозғилиши болуп, каһин уни «напак» дәп җакалисун. У напак болғини үчүн уни солашниң һаҗити йоқ. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Лекин әгәр песә-мохо қозғилип, җараһити бар кишиниң терисигә йейилип кәткән болса, каһин нәгила қариса шу йәрдә шу «песә-мохо» болса, терисини бешидин путиғичә қаплап кәткән болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ундақта каһин униңға сәпселип қарисун; мана, шу песә-мохо җараһити пүтүн бәдинини қаплап кәткән болса, у җараһити бар кишини «пак» дәп җакалисун; чүнки униң пүтүн бәдини ақирип кәткән болуп, у «пак» дәп саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Лекин қачаники униңда әт-гөши көрүнүп қалса, у киши напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Каһин мундақ көрүнгән әт-гөшигә қарап, у кишини «напак» дәп җакалисун; чүнки шу әт-гөш напак болуп, у песә-мохо кесилидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Һалбуки, әгәр әт-гөши қайтидин өзгирип, ақарса у киши йәнә каһинниң қешиға кәлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Каһин униңға сәпселип қарисун; җараһәт ақарған болса, каһин җараһити бар кишини «пак» дәп җакалисун; у пак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Әгәр биркимниң бәдининиң терисигә һүррәк чиқип сақийип, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","һүррәкниң орнида ақ чиқан яки қизғуч дағ пәйда болған болса, каһинға көрситилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Каһин униңға сәпселип қарисун; әгәр дағ әтрапидики теридин қениқрақ көрүнсә, шундақла униңдики түкләр ақирип қалған болса, ундақта каһин уни «напак» дәп җакалисун; чүнки бу һүррәктин қозғилип пәйда болған песә-мохо кесили җараһитидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Лекин каһин униңға сәпселип қариғанда, дағ чиққан җайда ақирип қалған түкләр болмиса, вә дағму әтрапидики теридин қениқрақ болмиса, рәңги сәл сусрақ болған болса, ундақта каһин уни йәттә күнгичә айрим солап қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Әгәр дағ дәрвәқә терисигә йейилип кәткән болса, каһин уни «напак» дәп җакалисун; чүнки бу песә-мохо җараһитидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Амма әгәр дағ өз җайида тохтап йейилмиған болса, бу пәқәт һүррәкниң зәхми, халас; каһин уни «пак» дәп җакалисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Әгәр бирисиниң бәдининиң терисиниң мәлум җайи көйүп қелип, көйгән җай ақ-қизғуч яки пүтүнләй ақ дағ болуп қалса, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","каһин униңға сәпселип қарисун; әгәр шу дағдики түкләр ақирип кәткән, дағму әтрапидики теридин қениқрақ болуп қалған болса, ундақта бу көйүк ярисидин пәйда болған песә-мохо кесилидур; каһин уни «напак» дәп җакалисун; чүнки у песә-мохо җараһитидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Лекин әгәр каһин сәпселип қариғанда, дағниң орнида һеч қандақ ақирип кәткән түк болмиса, шундақла дағму әтрапидики теридин қениқ болмиса, бәлки рәңги сус болса, ундақта каһин уни йәттә күнгичә айрим солап қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Йәттинчи күни каһин униңға йәнә қарисун; дағ терисидә кеңийип кәткән болса, каһин уни «напак» дәп җакалисун; чүнки у песә-мохо җараһитидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Амма әгәр дағ җайида тохтап, йейилмиған болса, шундақла рәңги сус болса, бу пәқәт көйүктин болған чавартқу, халас; каһин уни «пак» дәп җакалисун; чүнки у көйүкниң татуғи, халас. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Әгәр бир әр яки аял кишиниң бешида яки сақилида җараһәт пәйда болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","каһин җараһәткә сәпселип қарисун; әгәр җараһәт әтрапидики теридин қениқрақ көрүнсә, үстидә шалаң сериқ түк болса, ундақта каһин уни «напак» дәп җакалисун; чүнки бу җараһәт қақач болуп, баш яки сақалдики песә-мохониң аламитидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Әгәр каһин қақач җайға сәпселип қариғанда, у әтрапидики теридин қениқ көрүнмисә, шундақла униң ичидә һеч қандақ қара түкму болмиса, ундақта каһин қақичи бар кишини йәттә күнгичә айрим солап қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Каһин йәттинчи күни қақачқа йәнә сәпселип қарисун; қақач кеңийип кәтмәй, үстидиму һеч қандақ сериқ түк болмиса, шундақла қақач әтрапидики теридин қениқ көрүнмисә, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","җараһити бар киши барлиқ чач-сақилини чүшүрүвәтсун; қақачниң өзини ғирдимисун. Каһин қақичи бар кишини йәнә йәттә күнгичә айрим солап қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Йәттинчи күни каһин қақачқа сәпселип қарисун; әгәр қақач теридә кеңийип кәтмигән болса, шундақла әтрапидики теридин қениқ көрүнмисә, каһин уни «пак» дәп җакалисун. Андин у кийимлирини жуйсун; шуниң билән у пак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Лекин әгәр у «пак» дәп җакаланғандин кейин қақач теридә кеңийип кәтсә, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","каһин униңға йәнә сәпселип қарисун; әгәр қақач теридә кеңийип кәткән болса, сериқ түкниң бар-йоқлуғини тәкшүрүшниң һаҗити йоқ; чүнки бу киши напактур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Әгәр қақач җайида шу пети қелип, үстидин қара түк үнүп чиққан болса, қақач сақайған болиду; шу киши пак болғачқа, каһин уни «пак» дәп җакалиши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Әгәр әр яки аял кишиниң бәдининиң терисидә дағ пәйда болуп, бу дағлар пақирақ һәм ақ болса ");
INSERT INTO uigcyr_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","каһин сәпселип қарисун; әгәр бәдәнниң терисидики шу дағлар суслишип боз рәңгә йүзләнгән болса, бу теридин чиққан бир ташма, халас; бу киши пак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Әгәр биркимниң бешиниң түклири чүшүп кәткән болса, у пәқәт бир тақир баш, халас; у пак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Әгәр униң бешиниң түки пешанә тәрипидин чүшкән болса, у пәқәт пайнәкбаш, халас; у йәнила пак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Лекин әгәр униң тақир беши яки пайнәк бешида қизғуч ақ дағ көрүнсә, ундақта шу җараһәт униң тақир беши яки пайнәк бешидики песә-мохо кесилиниң бир аламитидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Каһин җараһитигә сәпселип қарисун; әгәр униң тақир бешида яки пайнәк бешида ишшиқ җараһәт болса һәмдә песә-мохо кесилиниң аламитидәк қизғуч ақ көрүнсә, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ундақта у песә-мохо кесилигә гириптар болған адәм болуп, напак һесаплиниду. Униң бешиға шундақ җараһәт чүшкән болғач, каһин уни мутләқ «напак» дәп җакалисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Шундақ җараһити бар песә-мохо кесили болған киши кийимлири житиқ, чачлири чувуқ, бурут-сақили йепиқлиқ һалда: «Напак, напак!» дәп товлап жүрүши керәк.    ");
INSERT INTO uigcyr_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Шу җараһити болған барлиқ күнләрдә у «напак» санилиду; у напак болғачқа, айрим туруши керәк; униң туралғуси чедиргаһниң сиртида болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Әгәр бир кийимдә, мәйли жуңдин яки канаптин тикилгән болсун униңда песә-мохо из-деғи пәйда болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","йәни канап яки жуңдин тоқулған рәхттә, өрүш жипида яки арқақ жиплирида болсун, терә-хурумда яки теридин етилгән һәр қандақ нәрсиләрдә песә-мохо из-деғи болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","шундақла кийим-кечәк яки терә-хурумда, өрүш жип яки арқақ жиплирида, я терә-хурумдин етилгән нәрсиләрдә пәйда болған из-дағ йешилрақ яки қизғуч болса бу из-дағ «песә-мохо из-деғи» дәп қарилип каһинға көрситилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Каһин даққа сәпселип қарисун, андин из-дағ пәйда болған нәрсини йәттә күнгичә айрим сақлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","У йәттинчи күни из-дағқа қарап бақсун; из-дағ чүшкән кийим-кечәк, мәйли арқақ жипта яки өрүш жипта болсун, яки терә-хурумда яки терә-хурумдин етилгән нәрсидә болсун, у кеңийип кәткән болса, бу из-дағ чириткүч песә-мохо кесили дәп һесаплинип, улар напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Шуниңдәк каһин өрүш жип яки арқақ жипида из-дағ болса кийим-кечәк яки терә-хурумдин етилгән нәрсидә шундақ из-дағ болса уларниму көйдүрүвәтсун; чүнки бу чириткүч песә-мохо кесилидур. Мундақ нәрсиләрниң һәммисини отта көйдүрүш керәктур. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Лекин каһин униңға сәпселип қариғанда, из-дағ кийим-кечәктики өрүш жипта болсун, арқақ жипта болсун, яки терә-хурумдин етилгән нәрсидә болсун, из-дағ кеңәймигән болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ундақта каһин деғи бар нәрсини жуюлсун дәп буйруп, иккинчи қетим уни йәттә күнгичә сақлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Бу нәрсә жуюлғандин кейин каһин йәнә даққа сәпселип қарисун; әгәр униң рәңги өзгәрмигән болса (гәрчә кеңийип кәтмигән болсиму), у йәнила напактур; сән уни отта көйдүргин. Чүнки мәйли униң из-деғи ич йүзидә болсун яки таш йүзидә болсун у чириткүч из-дағ һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Лекин әгәр каһин сәпселип қариғанда, мана, дағниң рәңги жуюлғандин кейин суслишип кәткән болса, у шу қисмини кийим-кечәктин, өрүш жиптин яки арқақ жиптин болсун, яки терә-хурумдин болсун уни житип елип, ташливәтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Әгәр бу из-дағ кийим-кечәктә, мәйли арқақ жипта яки өрүш жипта болсун, я терә-хурумдин етилгән нәрсидә көрүнсун, бу кеңийдиған бир хил песә-мохо из-деғи дәп саналсун; сән у чаплашқан кийим-кечәкни көйдүрүвәткин. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Лекин әгәр из-дағ кийим-кечәктә болсун (өрүш жипида яки арқақ жипида болсун) яки терә-хурумдин етилгән нәрсидә болсун, жуюлуш билән чиқип кәтсә, ундақта бу егин иккинчи қетим жуюлсун, андин пак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Песә-мохо кесилиниңкидәк из-дағ пәйда болған жуң яки канап рәхттин тоқулған кийим-кечәк (из-дағ өрүш жипта яки арқақ жипта болсун) яки терә-хурумдин етилгән нәрсиләр тоғрисидики қанун-бәлгүлимә мана шудур; буниң билән уларни пак яки напак җакалашқа болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Песә-мохо болған киши пак қилинидиған күнидә беҗа қилиш керәк болған қанун-бәлгүлимә мана төвәндикидәктур: — У каһинниң алдиға кәлтүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Каһин чедиргаһниң ташқириға чиқип, песә-мохо болған кишигә сәпселип қарисун; әгәр песә-мохо болған киши кесилидин сақайған болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Ундақта каһин пак қилинидиған кишигә пак, тирик қуштин иккини униңға қошуп кедир яғичи, қизил рәхт вә зофа кәлтүрүшкә буйрусун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Андин каһин қушларниң бирини еқин су қачиланған сапал козиниң үстидә боғузлаңлар дәп буйрусун; ");
INSERT INTO uigcyr_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","андин тирик қушни болса, каһин уни кедир яғичи, қизил рәхт вә зофа билән елип келип, бу нәрсиләрниң һәммисини тирик қуш билән биргә еқин суниң үстидә боғузланған қушниң қениға чилисун, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","андин песә-моходин пак қилинидиған кишигә йәттә қетим сепиши билән уни пак дәп җакалисун; вә тирик қушни далаға қоюп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Песә-моходин пак қилинидиған киши кийимлирини жуюп, бәдинидики барлиқ түкләрни чүшүрүп, суда жуюнғандин кейин пак һесаплиниду. Андин униңға чедиргаһқа киришкә иҗазәт болиду; пәқәт у йәттә күнгичә өз чедириниң тешида туруши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Йәттинчи күни у бәдинидики һәммә түкләрни чүшүрсун; башниң чач-сақаллири вә қешини, йәни барлиқ түклирини чүшүрсун; у кийимлирини жуюп өз бәдинини суда жуйсун, андин пак болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Сәккизинчи күни у икки беҗирим әркәк қоза билән бир яшқа киргән беҗирим чиши қозидин бирни, шуниңдәк бир әфаһниң ондин үчигә баравәр зәйтун мейи иләштүрүлгән есил ун «ашлиқ һәдийәси»ни, бир лог зәйтун мейини кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Уни «пак» дәп җакалайдиған бу рәсим-қаидини өткүзидиған каһин пак қилинидиған кишини вә у нәрсиләрни җамаәт чедириниң кириш ағзида, Пәрвәрдигарниң алдида һазир қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Андин каһин әркәк қозиларниң бирини елип итаәтсизлик қурбанлиғи қилип сунуп, униң билән биллә шу бир лог зәйтун мейиниму кәлтүрүп, пулаңлатма һәдийә сүпитидә Пәрвәрдигарниң алдида пулаңлатсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Қоза болса муқәддәс бир җайниң ичидә гуна қурбанлиғи билән көйдүрмә қурбанлиқлар боғузлинидиған җайда боғузлансун; чүнки итаәтсизлик қурбанлиғи болса гуна қурбанлиғиға охшаш, каһинға тәвә болуп «әң муқәддәсләрниң бири» санилиду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Каһин итаәтсизлик қурбанлиғиниң қенидин елип пак қилинидиған кишиниң оң қулиқиниң юмшиқиға вә оң қолиниң чоң бармиғи билән оң путиниң чоң бармиғиғиму сүрүп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Андин каһин шу бир лог зәйтун мейидин елип, өзиниң сол қолиниң алиқиниға азғина қуйсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Каһин оң бармиғини сол қолидики зәйтун мейиға чилап, Пәрвәрдигарниң алдида йәттә қетим бармиғи билән сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Андин каһин қолидики қалған майдин елип, пак қилинидиған кишиниң оң қулиқиниң юмшиқиға, оң қолиниң баш бармиғиға вә оң путиниң баш бармиғиға сүрүлгән итаәтсизлик қурбанлиғиниң қениниң үстигә сүрүп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Сүрүп болуп, каһин қолидики ешип қалған майни пак қилинидиған кишиниң бешиға қуйсун. Бу йол билән каһин униң үчүн Пәрвәрдигарниң алдида кәфарәт кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Андин каһин гуна қурбанлиғини сунуп, пак қилинидиған кишини напаклиғидин пак қилишқа кәфарәт кәлтүриду; ахирида у көйдүрмә қурбанлиқни боғузлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Каһин көйдүрмә қурбанлиқ билән ашлиқ һәдийәсини қурбангаһта сунсун. Бу йол билән каһин униң үчүн кәфарәт кәлтүрүп, у киши пак болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Лекин у кәмбәғәлликтин шундақ қилишқа қурби йәтмисә, өзигә кәфарәт кәлтүрүш үчүн «пулаңлатма һәдийә» сүпитидә ялғуз бир әркәк қозини итаәтсизлик қурбанлиғи қилип кәлтүрсун, шуниңдәк ашлиқ һәдийәси үчүн бир әфаһниң ондин биригә баравәр зәйтун мейи иләштүрүлгән есил ун билән бир лог зәйтун мейини кәлтүрсун ");
INSERT INTO uigcyr_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","вә өз әһвалиға яриша икки пахтәк яки икки бачка елип кәлсун; бири гуна қурбанлиғи үчүн, йәнә бири көйдүрмә қурбанлиқ үчүн болсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","сәккизинчи күни буларни өзиниң пак қилиниши үчүн җамаәт чедириниң кириш ағзиға елип келип, Пәрвәрдигарниң алдида каһинниң қешиға кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Каһин итаәтсизлик қурбанлиғи болидиған әркәк қоза билән шу бир лог майни елип, буларни пулаңлатма һәдийә сүпитидә Пәрвәрдигарниң алдида пулаңлатсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Итаәтсизлик қурбанлиғи қилинған әркәк қозини болса өзи боғузлисун; андин каһин итаәтсизлик қурбанлиғиниң қенидин азғина елип, пак қилинидиған кишиниң оң қулиқиниң юмшиқиға, оң қолиниң баш бармиғиға вә оң путиниң баш бармиғиға сүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Андин каһин майдин елип, сол қолиниң алиқиниға азғина қуйсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Шундақ қилип, каһин оң бармиғи билән сол қолидики майдин Пәрвәрдигарниң алдида йәттә қетим сәпсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Андин каһин өзи қолидики майдин елип, пак қилинидиған кишиниң оң қулиқиниң юмшиқиға вә оң қолиниң баш бармиғи билән оң путиниң баш бармиғиға итаәтсизлик қурбанлиғиниң қениниң үстигә сүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Шуниң билән Пәрвәрдигарниң алдида униңға кәфарәт кәлтүрүшкә каһин қолидики майниң қалғинини пак қилинидиған кишиниң бешиға қуйсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","андин шу киши өз қурбиға қарап пахтәктин бирни яки бачкидин бирни сунсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","өз қурбиға қарап, бирини гуна қурбанлиғи, йәнә бирини көйдүрмә қурбанлиқ қилип ашлиқ һәдийәси билән биллә сунсун. Бу йолда каһин Пәрвәрдигарниң алдида пак қилинидиған киши үчүн кәфарәт кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Өзидә песә-мохо болған, пак қилиниши үчүн ваҗип болидиған нәрсиләрни кәлтүрүшкә қурби йәтмәйдиған кишиләр тоғрисидики қанун-бәлгүлимә мана шулардур. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Пәрвәрдигар Муса билән Һарунға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","— Силәр Мән өзүңларға мирас қилип беридиған Қанаан зиминиға киргәндин кейин, Мән силәр егә болидиған шу зиминдики бир өйгә бир хил песә-мохо ярисини әвәтсәм, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","өйниң егиси каһинниң қешиға берип, униңға буни мәлум қилип: «Мениң өйүмгә ваба жуққандәк көрүниду», дәп мәлум қилиши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Каһин болса: — Өйдики һәммә нәрсиләр напак болмисун үчүн мән берип бу вабаға сәпселип қараштин бурун өйни бекарлаңлар, дәп буйрусун. Андин каһин кирип өйгә сәпселип қарисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","У шу вабаға сәпселип қариғинида, мана өйниң тамлириға ваба дағлири жуққан җайлар кавак болса, һәм йешилға майил яки қизғуч болуп, тамниң йүзидин қениқрақ болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","каһин өйниң ишигиниң алдиға чиқип, ишикни йәттә күнгичә тақап қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Андин каһин йәттинчи күни йенип келип, сәпселип қариғинида, өйниң тамлиридики из-дағ кеңийип кәткән болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","каһин: — Ваба жуққан ташларни чиқирип шәһәрниң сиртидики напак бир җайға ташливетиңлар, дәп буйрусун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Шуниң билән биргә у өйниң ичиниң төрт әтрапини қирдурсун вә улар қирған сугақни болса шәһәрниң тешидики напак бир җайға төкүвәтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Андин улар башқа ташларни елип, илгәрки ташларниң орнида қойсун вә башқа һак лай етип, униң билән өйни қайтидин сугисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Әгәр у ташларни чиқирип, өйни қирдуруп қайтидин сугатқандин кейин, өйдә ваба деғи йәнә пәйда болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ундақта каһин йәнә кирип буниңға сәпселип қарисун. Сәпселип қариғинида, мана из-дағ өйдә кеңийип кәткән болса, бу өйгә жуққини чириткүч ваба болиду; өй напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Бу вәҗидин улар өйни, йәни яғач-таш вә барлиқ сугиқи билән биллә чүшүрүп, һәммисини көтирип шәһәрниң сиртидики напак бир җайға ташливәтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Кимдәким өй тақалған мәзгилдә униңға кирсә, у кәч киргичә напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Әгәр бирким өй ичидә ятқан болса, кийимлирини жуйсун; вә әгәр бириси өйдә ғизаланған болса, уму өз кийимлирини жуйсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Лекин каһин кирип, өйгә сәпселип қариғинида өй сугалғандин кейин ваба униңда кеңийип кәтмигән болса, ундақта каһин өйни «пак» дәп җакалисун; чүнки униңдики ваба сақайған болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Андин у өйниң пак қилиниши үчүн икки қуш, кедир яғичи, қизил рәхт билән зофа елип келип, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","қушларниң бирини еқин су қачиланған сапал козиниң үстидә боғузлисун; ");
INSERT INTO uigcyr_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","андин у кедир яғичи, зофа, қизил рәхт вә тирик қушни биллә елип келип, бу нәрсиләрниң һәммисини боғузланған қушниң қениға, шундақла еқин суға чилап, өйгә йәттә мәртивә сәпсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","бу йол билән у өйни қушниң қени, еқин су, тирик қуш, кедир яғичи, зофа вә қизил рәхт арқилиқ напаклиқтин паклайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Андин у тирик қушни шәһәрниң сиртида, далада қоюп бәрсун. У шундақ қилип, өй үчүн кәфарәт кәлтүриду; у өй пак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Булар болса һәр хил песә-мохо җараһити, қақач, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","кийим-кечәк вә өйгә жуққан песә-мохо вабаси, ");
INSERT INTO uigcyr_vpl VALUES ("LV14_55b","004_14_55b","LEV","14","55b","55b","теридики чиқанлар, тәмрәткә вә пақирақ ақ из-дағлар тоғрисидики қанун-бәлгүлимидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Шу бәлгүлимиләр билән бир нәрсиниң қайси әһвалда напак, қайси әһвалда пак болидиғанлиғини пәриқ етишкә көрсәтмә беришкә болиду; мана бу песә-мохо тоғрисидики қанун-бәлгүлимидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Пәрвәрдигар Муса билән Һарунға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Исраилларға мундақ дәңлар: — Һәр қандақ әркәкниң өз тенидин ақма чиқса шу киши шу ақма сәвәвидин напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ақма чиқиштин болған напаклиқ тоғрисидики һөкүм шуки, ақмиси мәйли тенидин еқип турсун яки еқиштин тохтитилған болсун, шу киши йәнила напак саналсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","мундақ ақма болған киши ятқан һәр бир орун-көрпә напак санилиду вә у қайси нәрсиниң үстидә олтарса шу нәрсиму напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Кимки у ятқан орун-көрпигә тәгсә, өз кийимлирини жуюп, суда жуюнсун, андин кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Шуниңдәк кимки мундақ ақма болған киши олтарған нәрсидә олтарса өз кийимлирини жуюп, суда жуюнсун вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Кимки ақма болған кишиниң тенигә тәгсә, өз кийимлирини жуюп, суда жуюнсун, вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Әгәр ақма болған киши пак бирисигә түкүрсә, шу киши өз кийимлирини жуюп, суда жуюнсун, кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Қайсибир егәр-тоқумниң үстигә ақма болған киши минсә, шу нәрсә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Кимки униң тегидә қоюлған нәрсиләргә тәгсә кәч киргичә напак санилиду; вә кимки шу нәрсиләрни көтәрсә, өз кийимлирини жуюп, суда жуюнсун, вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ақма болған киши қолини жуймастин биркимгә тәккүзсә, шу киши өз кийимлирини жуюп, суда жуюнсун вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ақма болған киши сапал қачини тутуп салса, шу қача чеқиветилсун; яғач қача болса суда жуюлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Қачаники ақма бар киши ақма һалитидин қутулса, өзиниң пак қилиниши үчүн йәттә күнни һесаплап өткүзүп, андин кийимлирини жуюп, еқин суда жуюнсун; андин пак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Сәккизинчи күни икки пахтәк яки икки бачкини елип, җамаәт чедириниң кириш ағзиға, Пәрвәрдигарниң алдиға кәлтүрүп, каһинға тапшурсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Каһин улардин бирини гуна қурбанлиғи үчүн, йәнә бирини көйдүрмә қурбанлиқ үчүн сунсун. Бу йол билән каһин Пәрвәрдигарниң алдида униң ақма болғанлиғиға кәфарәт кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Әгәр бир әркәкниң мәниси өзлүгидин чиқип кәткән болса, у пүтүн бәдинини суда жуйсун, у кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Шуниңдәк адәмниң мәниси қайси кийимигә яки терисигә жуқуп қалса, суда жуюлсун вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Әр вә аял киши бир-биригә йеқинлишиши билән мәни чиқса, иккиси жуюнсун вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Әгәр аял кишиләр ақма келиш һалитидә турса вә ақмиси хун болса, у йәттә күнгичә «айрим» турсун; кимки униңға тәгсә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","«Айрим» туруш мәзгилидә, қайси нәрсиниң үстидә ятса, шу нәрсә напак санилиду, шундақла қайси нәрсиниң үстидә олтарған болса, шу нәрсиму напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Һәр ким униң орун-көрписигә тәгсә өз кийимлирини жуюп, суда жуюнсун вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Һәр ким у олтарған нәрсигә тәгсә, өз кийимлирини жуюп, суда жуюнсун вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Вә әгәр бирким у ятқан яки олтарған җайда қоюлған бирәр нәрсигә тәгсә, кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Әгәр бир әр киши шу һаләттики аял билән биргә ятса, шундақла униң хун напаклиғи шу әргә жуқуп қалса, у йәттә күнгичә напак саналсун; у ятқан һәр бир орун-көрпиму напак саналсун.    ");
INSERT INTO uigcyr_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Әгәр аял кишиниң адәт вақтиниң сиртидиму бир нәччә күнгичә хуни келип турса, яки хун ақмиси адәт вақтидин ешип кәткән болса, ундақта бу напак қан еқип турған күнлириниң һәммисидә, у адәт күнлиридә турғандәк саналсун, йәнә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Қан кәлгән һәр бир күндә у қайси орун-көрпә үстидә ятса, булар у адәт күнлиридә ятқан орун-көрпиләрдәк һесаплиниду; у қайси нәрсиниң үстидә олтарған болса, шу нәрсә адәт күнлириниң напаклиғидәк напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Һәр ким бу нәрсиләргә тәгсә напак болиду; шу киши кийимлирини жуюп, суда жуюнсун вә кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Аял киши қачан хун келиштин сақайса, у йәттә күнни һесаплап, өткүзүп болғанда пак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Сәккизинчи күни у икки пахтәк яки икки бачкини елип җамаәт чедириниң кириш ағзиға, каһинниң қешиға кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Каһин буларниң бирини гуна қурбанлиғи үчүн, йәнә бирини көйдүрмә қурбанлиқ үчүн өткүзсун; бу йол билән каһин униң напак ақма қенидин пак болушиға униң үчүн Пәрвәрдигарниң алдида кәфарәт кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Силәр мошу йол билән Исраилларни напаклиғидин үзүңлар; болмиса, улар напаклиғида туруверип, уларниң арисида турған мениң туралғу чедиримни булғиши түпәйлидин напак һалитидә өлүп кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ақма келиш һалитидә болған киши вә мәни кетиш билән напак болған киши тоғрисида, ");
INSERT INTO uigcyr_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Шуниңдәк хун келиш күнлиридики ағриқ аял киши тоғрилиқ, ақма һаләттә болған әр вә аял тоғрилиқ, напак һаләттики аял биллә ятқан әр тоғрилиқ кәлгән қанун-бәлгүлимә мана шулардур. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Һарунниң икки оғли Пәрвәрдигарниң алдиға йеқинлишиши билән өлүп кәтти. Улар өлүп кәткәндин кейин, Пәрвәрдигар Мусаға сөз қилди. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Пәрвәрдигар Мусаға мундақ деди: — «Сән өз қериндишиң Һарунға: «Сән өлүп кәтмәслигиң үчүн пәрдиниң ичидики муқәддәс җайға қоюлған әһдә сандуғиниң үстидики «кәфарәт тәхти»ниң алдиға һәр вақит кәлмә», дегин. Чүнки Мән «кәфарәт тәхти»ниң үстидики булутта аян болимән. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Һарун әң муқәддәс җайға муну йол билән кирсун: — Гуна қурбанлиғи үчүн бир яш топақ, көйдүрмә қурбанлиқ үчүн бир қочқарни кәлтүрсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","өзи муқәддәс канап халта көйнәкни кийип, әтлирини япидиған канап иштанниму кийип, белигә бир канап бәлвағни бағлап, бешиға канап сәллини йөгәп кәлсун. Булар муқәддәс кийимләр болғачқа, кийиштин илгири бәдинини суда жуйсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","У Исраилларниң җамаитидин гуна қурбанлиғи үчүн икки текә, көйдүрмә қурбанлиқ үчүн бир қочқарни тапшурувалсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Шуниң билән Һарун авал гуна қурбанлиғи болидиған топақни сунуп, өзи вә өз өйидикиләр үчүн кәфарәт кәлтүрүши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Андин у икки текини елип, уларни җамаәт чедириниң кириш ағзиниң алдиға кәлтүрүп, Пәрвәрдигарниң алдида турғузсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Андин Һарун бу икки текә тоғрисида чәк ташлисун; чәкниң бирини «Пәрвәрдигар үчүн», йәнә бирини «азазәл үчүн» ташлисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Һарун Пәрвәрдигарға чәк чүшкән текини кәлтүрүп, гуна қурбанлиғи сүпитидә сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Лекин «азазәл»гә чәк чүшкән текини болса, кәфарәт кәлтүрүши үчүн чөлгә һайдилишкә, шундақла «азазәл»гә әвәтилишкә Пәрвәрдигарниң алдида тирик қалдурулсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Андин Һарун гуна қурбанлиғини, йәни өзи үчүн болған топақни кәлтүрүп, өзи вә өз өйидикиләр үчүн кәфарәт кәлтүрүшкә өзигә гуна қурбанлиғи болидиған бу топақни боғузлисун; ");
INSERT INTO uigcyr_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Андин у Пәрвәрдигарниң алдидики қурбангаһтин елинған чоғ билән толған бир хушбуйданни елип, икки қоллап юмшақ езилгән есил хушбуй әтир билән толдуруп, буни пәрдиниң ичигә елип барсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","андин хушбуй ис-түтики һөкүм-гува сандуғиниң үстидики кәфарәт тәхтини қаплисун дәп, хушбуйни Пәрвәрдигарниң һозуридики отниң үстигә қойсун; шуниң билән у өлмәйду. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","У топақниң қенидин елип өз бармиғи билән кәфарәт тәхтиниң шәриқ тәрипигә чечип, кәфарәт тәхтиниң алдиғиму өз бармиғи билән қандин елип, йәттә қетим сәпсун.    ");
INSERT INTO uigcyr_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Андин у хәлиқ үчүн гуна қурбанлиғи қилинидиған текини боғузлисун; қенини пәрдиниң ичигә кәлтүрүп, топақниң қенини қилғандәк қилсун, йәни униң қенидин елип кәфарәт тәхтигә вә кәфарәт тәхтиниң алдиға чачсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","У бу йол билән муқәддәс җай үчүн кәфарәт кәлтүрүп, уни Исраилларниң напаклиғидин, һәммә итаәтсизликлирини елип баридиған гуналиридин паклайду вә шуниңдәк уларниң напаклиғи арисида туруватқан җамаәт чедири үчүнму шундақ кәфарәт қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","У кәфарәт кәлтүрүш үчүн әң муқәддәс җайға киргәндин тартип униңдин чиққичә һеч бир адәм җамаәт чедири ичидә болмисун; бу йол билән у өзи, өйидикиләр вә Исраилниң пүткүл җамаити үчүн кәфарәт кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Андин у Пәрвәрдигарниң алдидики қурбангаһқа чиқип, униң үчүнму кәфарәт кәлтүриду; шуниңдәк топақниң қени билән текиниң қенидин елип қурбангаһниң чөрисидики мүңгүзләргә сүрсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","у бармиғи билән қандин елип қурбангаһниң үстигә йәттә қетим сәпсун; шуниң билән у уни Исраилларниң напаклиқлиридин паклап Худаға атап муқәддәс қилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","— Муқәддәс җай, җамаәт чедири вә қурбангаһ үчүн кәфарәт кәлтүрүп болғандин кейин, у тирик текини кәлтүрсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","андин Һарун икки қолини тирик текиниң бешиға қоюп туруп, униң үстидә туруп, Исраилларниң барлиқ қәбиһликлири вә итаәтсизликлирини елип баридиған гуналирини иқрар қилип, уларни текиниң бешиға артсун; андин уни йенида тәйяр туридиған бир адәмниң қоли билән чөлгә әвәтивәтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Бу йол билән текә уларниң һәммә қәбиһликлирини өз үстигә елип, адәмзатсиз чөлгә кетиду. Шуңа у текини чөлгә қоювәтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","— Андин Һарун җамаәт чедириға кирип муқәддәс җайға киргән вақитта кийгән канап кийимлирини селип шу йәрдә уларни қоюп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","У муқәддәс йәрдә өз бәдинини суда жуюп, өз кийимлирини кийип ташқириға чиқип, өзиниң көйдүрмә қурбанлиғи билән хәлиқниң көйдүрмә қурбанлиғини сунуп, шу йол билән өзи вә хәлиқ үчүн кәфарәт кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Шундақла у гуна қурбанлиғиниң мейини қурбангаһта көйдүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Азазәл»гә бекитилгән текини елип берип қоювәткән киши өз кийимлирини жуюп, бәдинини суда жуюп, андин чедиргаһқа киришкә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Кәфарәт кәлтүрүш үчүн қени әң муқәддәс җайға елип кирилип, гуна қурбанлиғи қилинған топақ билән гуна қурбанлиғи қилинған текини бириси чедиргаһниң ташқириға елип чиқип, уларниң териси, гөши вә тезәклирини отта көйдүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Уларни көйдүргән киши өз кийимлирини жуюп, бәдинини суда жуюп, андин чедиргаһқа киришкә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","— Мана бу силәргә бир әбәдий қанун-бәлгүлимә болсун: — Һәр йәттинчи айниң онинчи күнидә силәр өз нәпсиңларни тартип өзүңларни төвән тутуңлар вә һеч қандақ иш қилмаңлар; мәйли йәрликләр болсун яки араңларда туруватқан Яқ. жутлуқлар болсун шундақ қилишиңлар керәк.    ");
INSERT INTO uigcyr_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Чүнки шу күнидә силәрни паклашқа силәр үчүн кәфарәт кәлтүрүлиду; Пәрвәрдигарниң алдида силәр һәммә гуналириңлардин пак болисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Бу күн силәргә пүтүнләй арам алидиған шабат күни болуп, нәпсиңларни тартип өзүңларни төвән тутисиләр; бу әбәдий бир бәлгүлимидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Кимки атисиниң орнида каһинлиқ жүргүзүш үчүн мәсиһ қилинип, Худаға атап тикләнгән каһин болса шу йол билән кәфарәт кәлтүриду. У канаптин етилгән муқәддәс кийимни кийип туруп, ");
INSERT INTO uigcyr_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Әң муқәддәс җай үчүн кәфарәт кәлтүриду; җамаәт чедири билән қурбангаһ үчүнму кәфарәт кәлтүриду; қалған каһинлар билән барлиқ хәлиқниң җамаити үчүн һәм кәфарәт кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Бу болса силәр үчүн әбәдий бир бәлгүлимә болиду; шуниң билән Исраилларни барлиқ гуналиридин паклаш үчүн жилда бир қетим кәфарәт кәлтүрүп берисиләр». Шуниң билән Һарун Пәрвәрдигар Мусаға буйруғинидәк қилди. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Һарун билән оғуллири вә барлиқ Исраилларға мундақ дегин: — Пәрвәрдигар силәргә буйруған һөкүм шуки: — ");
INSERT INTO uigcyr_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Исраилниң җәмәтлиридин болған һәр қандақ киши қурбанлиқ қилмақчи болуп, кала яки қой яки өшкини җамаәт чедириниң кириш ағзида, Пәрвәрдигарниң туралғу чедириниң алдиға, Пәрвәрдигарға аталған қурбанлиқ сүпитидә йетиләп әпкәлмәй, бәлки чедиргаһниң ичидә яки ташқирида боғузлиса, униңдин аққан қан шу кишиниң гәдинигә артилиду; бу адәм «қан төккән» дәп, өз хәлқидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Бу һөкүмниң мәхсити Исраилларниң һазирқидәк далада мал союп қурбанлиқ қилишниң орниға, қурбанлиқлирини җамаәт чедириниң кириш ағзида Пәрвәрдигарниң алдиға кәлтүрүп, каһинға тапшуруп Пәрвәрдигарға енақлиқ қурбанлиқлири сүпитидә сунуп боғузлиши үчүндур. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Каһин қанни елип җамаәт чедириниң кириш ағзиниң йенидики Пәрвәрдигарниң қурбангаһиниң үстигә сепип, Пәрвәрдигарға хушбуй кәлтүрүш үчүн майни көйдүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Шуниң билән улар әнди бурунқидәк бузуқлуқ қилип текә-җинларниң кәйнидә жүрүп, уларға өз қурбанлиқлирини өткүзүп жүрмисун. Мана бу улар үчүн дәвирдин-дәвиргичә әбәдий бир бәлгүлимә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Сән уларға: — Исраилниң җәмәтидин яки уларниң арисида туруватқан яқа жутлуқлардин бири көйдүрмә қурбанлиқ яки башқа қурбанлиқ өткүзмәкчи болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","уни Пәрвәрдигарға атап сунуш үчүн җамаәт чедириға кириш ағзиниң алдиға кәлтүрмисә, у киши өз хәлиқлиридин үзүп ташлансун» — дегин. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Әгәр Исраилниң җәмәтидин болған һәр қандақ адәм яки уларниң арисида туруватқан яқа жутлуқлар қан йесә, Мән йүзүмни қанни йегән шу кишигә қарши қилимән, уни өз хәлқидин үзүп ташлаймән. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Чүнки һәр бир җаниварниң җени болса униң қенидидур; Мән уни җениңлар үчүн қурбангаһ үстигә кәфарәт кәлтүрүшкә бәргәнмән. Чүнки қан өзидики җанниң вастиси билән кәфарәт кәлтүриду. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Шуңа бу сәвәптин Мән Исраилларға: — «Силәрниң һеч бириңлар қан йемәслигиңлар керәк, араңларда туруватқан яқа жутлуқларму қан йемәслиги керәк» — дегән едим. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Әгәр Исраиллардин бири яки уларниң арисида туруватқан яқа жутлуқларниң бири йейишкә болидиған бир чарпай һайван яки қушни овлап, қенини төксә, уни топа билән йепип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Чүнки һәр бир җаниварниң җени болса, униң қенидин ибарәттур. Униң җени қенида болғач мән Исраилларға: «Силәр һеч қандақ җаниварниң қенини йемәңлар, чүнки һәр бир җаниварниң җени униң қенидидур; кимки уни йесә үзүп ташлиниду» — дедим. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Кимдәким өлүп қалған яки житқучлар боғуп титма-титма қиливәткән бир һайванни йесә, мәйли у йәрлик яки яқа жутлуқ болсун өз кийимлирини жуюп, суда жуюнсун вә кәч киргичә напак саналсун; андин у пак болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Лекин у яки кийимлирини юмиса, яки суда бәдинини юмиса, шу киши өз қәбиһлигиниң җазасини тартиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Сән Исраилларға мундақ дегин: — «Мән болсам Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Силәр илгири турған Мисир зиминидикидәк ишларни қилмаңлар вә яки Мән силәрни елип баридиған Қанаан зиминидикидәк ишларни қилмаңлар; уларниң рәсим-адәтлиридә жүрмәңлар, ");
INSERT INTO uigcyr_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","бәлки Мениң һөкүмлиримгә әмәл қилип, қанун бәлгүлимилиримни тутуп шу бойичә меңиңлар. Мән Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Силәр чоқум Мениң бәлгүлимилирим билән һөкүмлиримни тутушуңлар керәк; инсан уларға әмәл қилидиған болса уларниң сәвәвидин һаятта болиду. Мән Пәрвәрдигардурмән.    ");
INSERT INTO uigcyr_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","— Һеч ким өзигә йеқин туққан болған аялға йеқинлиқ қилип әвритини ачмисун. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Анаңниң әвритигә тәгмә, бу атаңниң әвритигә тәккиниң болиду; у сениң анаң болғачқа униң әвритигә тәгсәң болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Атаңниң аялиниң әвритигиму тәгмә, чүнки шундақ қилсаң атаңниң әвритигә тәккәндәк болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Сән ача-сиңлиңниң, бир атидин болған яки бир анидин болған, яки шу өйдә туғулған яки башқа йәрдә туғулған болсун, униң әвритигә тәгмә. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Сән өз оғлуңниң қизи вә яки қизиңниң қизиниң әвритигә тәгмә; чүнки уларниң әврити сән өзүңниң әвритидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Сән атаңниң аялиниң қизиниң әвритигә тәгмә; у атаңдин туғулған, сениң ача-сиңлиң, шуңа униң әвритигә тәгмә.    ");
INSERT INTO uigcyr_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Сән атаңниң ача-сиңлисиниң әвритигиму тәгмә, чүнки у атаңниң биртуққинидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Сән анаңниң ача-сиңиллириниң әвритигиму тәгмә, чүнки у анаңниң биртуққинидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Атаңниң ака-инилириниң аялиниң әвритигә тәгмә; уларниң аяллириға йеқинлиқ қилма; чүнки улар сениң һаммаңдур. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Сән келиниңниң әвритигә тәгмә; у сениң оғлуңниң аяли болғачқа, униң әвритигә тәгсәң болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Сән ака-инилириңниң аялиниң әвритигә тәгмә; чүнки бу өз ака-инилириңниң әвритигә тәккәндәк болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Сән бир аялға вә шуниң билән биргә униң қизиниң әвритигә тәгмә; шундақла униң оғлиниң қизи вә қизиниң қизиниму хотунлуққа елип әвритигә тәгмә. Улар бир-биригә йеқин туққан болғачқа, мундақ иш пәсәндиликтур. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Сән аялиң һаят вақтида, униң ача-сиңлисини хотунлуққа елип әвритигә тәгмә. Ундақ қилсаң хотунуңға күндәшлик азавини кәлтүрисән. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Сән бир аялниң адәт көрүп напак турған вақтида йеқинлиқ қилип әвритигә тәгмә.    ");
INSERT INTO uigcyr_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Сән өз хошнаңниң аяли билән зина қилип өзүңни униң билән напак қилма. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Сән өз нәслиңдин һеч бирини Моләк мәбудиға атап оттин өткүзсәң қәтъий болмайду. Әгәр шундақ қилсаң Худайиңниң намини напак қилған болисән. Мән Өзүм Пәрвәрдигардурмән.    ");
INSERT INTO uigcyr_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Сән аяллар билән биргә болғандәк әр киши билән биргә болма. Бу иш жиркиничликтур. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Сән һеч һайван билән мунасивәт қилип өзүңни напак қилма; шуниңдәк аял кишиму мунасивәт қилдуруш үчүн бир һайванниң алдиға бармисун. Бу иш ипласлиқтур. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Силәр бу ишларни қилип өзүңларни напак қилмаңлар, чүнки мән силәрниң алдиңлардин чиқириватқан таипиләр болса шундақ ишларни қилип өзлирини напак қилған ");
INSERT INTO uigcyr_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","вә зиминиму напак болғандур. Буниң үчүн Мән у зиминниң қәбиһлигини өз бешиға чүшүримән, шуниңдәк у зиминму өзидә туруватқанларни қусуп чиқириветиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Лекин силәр болсаңлар Мениң бәлгүлимилирим билән һөкүмлиримни тутуңлар; силәрдин һеч ким, мәйли йәрлик яки араңларда туруватқан яқа жутлуқ болсун бу жиркиничлик ишлардин һеч бирини қилмисун ");
INSERT INTO uigcyr_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(чүнки бу барлиқ жиркиничлик ишларни силәрдин илгири шу зиминда турған хәлиқ қилип кәлгәчкә, зиминниң өзи напак болуп қалди). ");
INSERT INTO uigcyr_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Шундақ қилип зиминни напак қилсаңлар, зимин өзи силәрдин илгири өзидә турған әлләрни қусуп чиқарғандәк, силәрниму қусуп чиқириветиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Чүнки бу жиркиничлик ишларниң һәр қандиқини қилғучи, — мундақ қилмишларни қилған һәр қандақ киши өз хәлқи арисидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Силәр Мән силәргә тапилиғинимға әмәл қилишиңлар зөрүрдур; — демәк, силәр өзүңлардин илгири өткәнләр тутқан шу жиркиничлик рәсим-қаидиләрни тутуп, өзүңларни напак қилмаслиғиңлар керәк. Мән Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Сән Исраилларниң пүткүл җамаитигә сөз қилип уларға мундақ дегин: — «Мән Худайиңлар Пәрвәрдигар муқәддәс болғачқа, силәрму муқәддәс болушуңлар керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Силәр һәр бириңлар анаңлар билән атаңларни иззәтләңлар; Мениң шабат күнлиримни болса, уларни тутушуңлар керәк. Мән өзүм Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Силәр әрзимәс бутларға таянмаңлар, өзүңлар үчүн қуйма бутларни ясимаңлар. Мән өзүм Худайиңлар Пәрвәрдигардурмән.    ");
INSERT INTO uigcyr_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Силәр Пәрвәрдигарға енақлиқ қурбанлиғини кәлтүрүшни халисаңлар, қобул қилинғидәк йол билән уни сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Силәр уни сунған күни вә әтиси у йейилсун; үчинчи күнигә қалғини болса отта көйдүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Әгәр униңдин бир қисми үчинчи күни йейилсә қурбанлиқ һарам һесаплинип қобул қилинмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Кимки униңдин йесә өз гунайини өз үстигә алиду, чүнки у Пәрвәрдигарға атап муқәддәс қилинған нәрсини напак қилди; ундақ киши өз хәлқидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Силәр зиминиңлардики һосулни жиғсаңлар, сән етизиңниң булуң-пушқақлириғичә тамам жиғивалма вә һосулуңдин қалған васаңни теривалмиғин. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Үзүм таллириңни пасаңдиватма вә үзүм таллиридин чүшкән үзүмләрниму теривалма, бәлки буларни кәмбәғәлләр билән мусапирларға қойғин. Мән Өзүм Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Силәр оғрилиқ қилмаңлар, алдамчилиқ қилмаңлар, бир-бириңларға ялған сөзлимәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Мениң намим билән ялған қәсәм ичмәңлар, ундақ қилсаң Худайиңниң намини булғайсән. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Өз хошнаңға зулум қилма, униңкини өзүңниң қиливалма. Мәдикарниң һәққини кечичә йениңда қондуруп қалма. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Гас кишини тиллима, кор кишиниң алдида путлишаңғу нәрсини қойма; бәлки өз Худайиңдин қорққин. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Һөкүм қилғиниңларда һеч наһәқлиқ қилмаңлар; намратқиму ян басмай, байғиму йүз-хатирә қилмай, бәлки адиллиқ билән өз хошнаң үстидин тоғра һөкүм қилғин. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Өз хәлқиңниң арисида гәп тошуғучи болуп жүрмә; хошнаңниң җениға һеч қандақ зиян-зәхмәт йәткүзмә. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Сән көңлүңдә өз қериндишиңдин нәпрәтләнмигин; хошнаңда гуна болса сән униң сәвәвидин бешиңға гуна келип қалмаслиғи үчүн униңға тәнбиһ-несиһәт бәргин. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Сән интиқам алмиғин вә өз хәлқиңниң нәслигә һеч адавәтму сақлимиғин, бәлки хошнаңни өзүңни сөйгәндәк сөйгин. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Силәр Мениң қанун-бәлгүлимилиримни тутуңлар. Сән өз чарпайлириңни башқа нәсилләр билән чепиштурма, етизиңға икки хил уруқ салмиғин, икки хил жиптин тоқулған кийимни киймә. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Әгәр бир әр киши қиз-чокан билән йетип мунасивәт өткүзсә, вә у башқа бири билән вәдиләшкән дедәк болса, бу дедәкниң һөрлүк пули тапшурулмиған болса, яки униңға һөрлүк берилмигән болса, мувапиқ җаза берилсун. Лекин қиз-чокан һөр қилинмиғачқа, һәр иккиси өлтүрүлмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Әр киши болса өзиниң итаәтсизлик қурбанлиғини җамаәт чедириниң кириш ағзиниң алдиға, Пәрвәрдигарниң алдиға кәлтүрсун; итаәтсизлик қурбанлиғи бир қочқар болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Каһин у итаәтсизлик қурбанлиғи үчүн кәлтүргән қочқарни елип униң садир қилған гунайи үчүн Пәрвәрдигарниң алдида кәфарәт кәлтүриду; униң қилған гунайи униңдин кәчүрүлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Силәр зиминға кирип һәр хил йәйдиған мевилик дәрәқләрни тиккән болсаңлар, мевилирини «хәтнисиз» дәп қараңлар; үч жилғичә буни «хәтнисиз» дәп қарап униңдин йемәңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Төртинчи жили уларниң һәммә мевилири Пәрвәрдигарға мәдһийә сүпитидә муқәддәс қилип беғишлансун. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Андин бәшинчи жилдин тартип силәр уларниң мевилиридин йейишкә башлаңлар. Шундақ қилсаңлар зимин мәһсулатлирини силәргә зиядә қилиду. Мән Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Силәр қан чиқмиған нәрсини йемәңлар. Нә палчилиқ нә җадугәрлик қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Силәр бешиңларниң чекә-чөрисидики чачни чүшүрүп дүгиләк қиливалмаңлар, сақалниң уч-янлирини бузмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Силәр өлгәнләр үчүн бәдиниңларни зәхим йәткүзүп тилмаңлар, өзүңларға һеч қандақ гүл-сүрәт чәкмәңлар. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Сән қизиңни бузуқлуқ-паһишиликкә селип напак қилмиғин. Болмиса, зиминдикиләр бузуқлуқ-паһишиликкә берилип, пүткүл зиминни әйш-ишрәт қаплап кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Силәр Мениң шабат күнлиримни тутуңлар, Мениң муқәддәс җайимни һөрмәтләңлар. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Җинкәшләр билән сеһиргәрләргә таянмаңлар, уларниң кәйнидин жүрүп өзүңларни напак қилмаңлар. Мән өзүм Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ақ баш кишиниң алдида орнуңдин тур, қериларни һөрмәт қилғин; Худайиңдин қорққин. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Бир мусапир зиминда араңларда туруватқан болса силәр униңға зулум қилмаңлар, ");
INSERT INTO uigcyr_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","бәлки араңларда туруватқан мусапир силәргә йәрлик кишидәк болсун; уни өзүңни сөйгәндәк сөйгин; чүнки силәрму Мисир зиминида мусапир болғансиләр. Мән Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Силәрниң һөкүм чиқиришиңларда, узунлуқ, еғирлиқ вә һәҗим өлчәштә һеч қандақ наһәқлик болмисун; ");
INSERT INTO uigcyr_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","силәрдә адил тараза, адил тараза ташлири, адил әфаһ кәмчини билән адил һин кәмчини болсун. Мән силәрни Мисир зиминидин чиқирип кәлгән Худайиңлар Пәрвәрдигардурмән.    ");
INSERT INTO uigcyr_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Силәр Мениң барлиқ қанун-бәлгүлимилирим вә барлиқ һөкүмлиримни тутуп, уларға әмәл қилиңлар; мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Сән Исраилларға сөз қилип мундақ дегин: — Әгәр Исраилларниң бири вә яки Исраил зиминида туруватқан мусапирларниң бири Моләк бутиға нәслиниң бирини беғишлиса, униңға өлүм җазаси берилиши керәк; зиминдикиләр уни чалма-кесәк қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Вә Мән Өз йүзүмни бу кишигә қарши қилимән, чүнки өзи өз әвлатлириниң бирини Моләк бутиға беғишлап муқәддәс җайимни паскина қилип, Мениң намимни булғиғини үчүн уни өз хәлқидин үзүп ташлаймән. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Әгәр зиминда туруватқанлар өз нәслидин бирини Моләккә беғишлиғанда шу кишигә көзлирини жумуп, униң билән кари болмиса, шундақла уни өлтүрмисә, ");
INSERT INTO uigcyr_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Мән Өзүм йүзүмни у киши билән униң аилисигә қарши қилимән, уни вә униңға әгишип бузуқчилиқ қилғучилар, йәни Моләкниң кәйнидин жүрүп бузуқчилиқ қилғучиларниң һәммисини өз хәлқидин үзүп ташлаймән. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Җинкәшләр билән сеһиргәрләргә тайинип, уларниң кәйнигә кирип бузуқчилиқ қилип жүргүчиләр болса, Мән йүзүмни шу кишиләргә қарши қилип, уни өз хәлқидин үзүп ташлаймән. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Шуңа өзүңларни пак қилип муқәддәс болуңлар, чүнки Мән Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Қанун-бәлгүлимилиримни тутуп, уларға әмәл қилиңлар; Мән болсам силәрни муқәддәс қилғучи Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Әгәр бирким өз атиси яки анисини қарғиса, уларға өлүм җазаси берилмисә болмайду; чүнки у өз ата-анисини қарғиғини үчүн өз қени өз бешиға чүшкән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Әгәр бирким башқисиниң аяли билән зина қилса, йәни өз хошнисиниң аяли билән зина қилса, зина қилған әр билән аял иккиси өлүм җазасини тартмиса болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Әгәр бириси атисиниң аяли билән ятса, өз атисиниң әвритигә тәккән болиду; улар иккиси өлүм җазасини тартмиса болмайду; уларниң қени өз бешиға чүшкән болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Бириси өз келини билән ятса, иккиси ипласлиқ қилғини үчүн өлүм җазасини тартмиса болмайду; уларниң қени өз бешиға чүшкән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Бириси аял киши билән ятқандәк әр киши билән ятса иккиси жиркиничлик иш қилған болиду; уларға өлүм җазаси берилмисә болмайду. Өз қени өз бешиға чүшкән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Әгәр бириси қизи билән анисини қошуп хотунлуққа алса пәсәндилик қилған болиду. Әр билән икки аял отта көйдүрүлсун. Шуниң билән араңларда һеч пәсәндилик иш болмайду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Бириси бир һайван билән мунасивәт өткүзсә, у өлүм җазасини тартсун, һайванниму өлтурүңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Әгәр аял киши бир һайванниң қешиға берип мунасивәт қилдурса, аял билән һайванниң иккисини өлтүрүңлар; өз қени өз бешиға чүшкән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Бириси ача-сиңлисини, йәни атисидин яки анисидин болған қизни елип, әвритигә тәгсә вә бу қизму униң әвритигә тәгсә уятлиқ иш болиду; шуниң үчүн әр-аял иккиси өз хәлқиниң көз алдидин үзүп ташлансун; у өз һәдә яки сиңлисиниң әвритигә тәккәчкә, өз қәбиһлиги өз бешиға чүшкән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Бириси адәт көргән ағриқ вақтида бир аял билән биргә йетип, униң әвритигә тәгсә, ундақта у униң қан мәнбәсигә тәккән, аялму қан мәнбәсини ечип бәргән болуп, иккиси өз хәлқидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Сән өз анаңниң ача-сиңлиси вә атаңниң ача-сиңлисиниң әвритигә тәгмә; чүнки кимки шундақ қилса йеқин туққининиң әвритигә тәккән болиду; улар иккилисиниң өз қәбиһлиги өз бешиға чүшкән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Бириси тағисиниң аяли билән ятса тағисиниң әвритигә тәккән болиду; иккилиси өз гунайини өз бешиға алиду; улар пәрзәнтсиз өлиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Бириси ака-инисиниң аялини алса паскина бир иш болиду. У өз биртуққан ака-инисиниң әвритигә тәккән болиду; улар иккилиси пәрзәнтсиз қалиду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Силәр Мениң барлиқ қанун бәлгүлимилирим билән барлиқ һөкүмлиримни тутуп, буниңға мувапиқ әмәл қилиңлар; болмиса, Мән силәрни елип берип турғузидиған зимин силәрни қусуп чиқириветиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Силәр Мән алдиңлардин һайдиветидиған әлләрниң рәсим-қаидилири бойичә маңсаңлар болмайду; чүнки улар бу жиркиничлик ишларниң һәммисини қилип кәлди, вә шуниң үчүн улар Маңа жиркиничлик болди. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Шуниң үчүн Мән силәргә: «Силәр уларниң зиминини мирас қилип алисиләр; Мән шу сүт билән һәсәл ақидиған зиминни силәргә беримән», дәп ейтқан едим; силәрни башқа хәлиқләрдин айрим қилған Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Шуңа силәр пак вә напак чарпайларни пәриқ етип, пак вә напак учар-қанатларни тонуп, Мән силәр үчүн айрип, напак қилип бекитип бәргән җаниварларниң ичидин һәр қандиқи, чарпай яки учар-қанат болсун яки йәрдә өмилигүчи җанивар болсун, уларниң һеч бири билән өзүңларни напак қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Силәр Маңа хас пак-муқәддәс болушуңлар керәк; чүнки Мән Пәрвәрдигар пак-муқәддәстурмән, силәрни Маңа хас болсун дәп барлиқ әлләрдин айрим қилғанмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Җинкәш яки сеһиргәр болған һәр қандақ әр яки хотун кишигә өлүм җазаси берилмисә болмайду; хәлиқ уларни чалма-кесәк қилсун; уларниң қени өз бешиға чүшкән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — Сән каһинлар болған Һарунниң оғуллириға мундақ дегин: — бир каһин өз хәлқиниң арисидики өлгәнләр вәҗидин өзини напак қилмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Пәқәт өзиниң йеқин туққанлири үчүн — аниси билән атиси, оғли билән қизи вә ака-инисиниң өлүги түпәйлидин өзини напак қилса болиду; ");
INSERT INTO uigcyr_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","шуниңдәк әгәр ача-сиңлиси әргә тәгмәй пак қиз һаләттә өзи билән биллә туруватқан болса, униң өлүги түпәйлидин өзини напак қилса болиду; ");
INSERT INTO uigcyr_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","чүнки каһин өз хәлқиниң арисида мөтивәр болғачқа, өзини напак қилип булғимаслиғи керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Каһинлар бешини йерим-ята қилип чүшүрмәслиги, сақилиниң уч-янлирини һәм чүшүрмәслиги, бәдинигиму зәхим йәткүзүп тилмаслиғи керәк, ");
INSERT INTO uigcyr_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","бәлки улар өз Худасиға муқәддәс туруп, Худасиниң намини булғимаслиғи керәк; чүнки улар Пәрвәрдигарға атап отта сунулидиған қурбанлиқларни, өз Худасиниң ненини суниду; шуңа улар муқәддәс болуши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Улар бир аялни өз әмригә алғанда паһишә аялниму, бузуқ аялниму алмаслиғи керәк вә ери қоювәткән аялниму алмисун. Чүнки каһин болса өз Худасиға хас муқәддәс қилинған. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","У Худайиңниң ненини сунғини үчүн у саңа нисбәтән муқәддәс дәп санилиши керәк; чүнки силәрни муқәддәс қилғучи Пәрвәрдигар Өзүм муқәддәстурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Әгәр бир каһинниң қизи паһишилик қилип өзини булғиған қилса, өз атисини булғиған болиду; у отта көйдүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Бешиға мәсиһләш зәйтун мейи төкүлгән, каһинлиқ кийимләрни кийишкә тикләнгән, өз қериндашлириниң арисида баш каһин қилинған киши ялаңбаш болмисун, кийимлириниму житмисун; ");
INSERT INTO uigcyr_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","У йәнә һеч өлүккә йеқинлашмаслиғи керәк, һәтта атиси вә яки анисиниң өлүклириниң вәҗидин өзини напак қилмаслиғи керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","У вәзиписидә туруватқанда муқәддәс җайдин һәргиз айрилмисун вә шуниңдәк Худасиниң муқәддәс җайини булғимаслиғи керәк; чүнки униң Худасиниң уни Өзигә хас қилған «мәсиһләш мейи» униң бешида туриду. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","У хотун алса пак қизни елиши керәк; ");
INSERT INTO uigcyr_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","тул вә яки әрдин қоюветилгән аял вә яки бузуқ вә яки паһишә аял болса буларни алмаслиғи, бәлки өз хәлқидин болған пак қизни хотунлуққа елиши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Болмиса у өз хәлқиниң арисида өз уруғини напак қилиду; чүнки уни муқәддәс қилғучи Пәрвәрдигар Мәндурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Сән Һарунға мундақ дегин: — «Әвлаттин-әвлатқичә сениң нәслиңдин болған бириси мәйип болса, Худаниң ненини сунуш үчүн йеқин кәлмисун; ");
INSERT INTO uigcyr_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","мәйип болған һәр қандақ киши һәргиз йеқин кәлмисун — яки кор болсун, токур болсун, панақ болсун яки бир әзаси йәнә бир җүпидин узун болған адәм болсун, ");
INSERT INTO uigcyr_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","пути яки қоли сунуқ болсун, ");
INSERT INTO uigcyr_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","док болсун, парпа болсун, көзидә ақ болсун, қичишқақ болған болсун, тәмрәткә басқан болсун яки уруқдени езилгән һәр ким болсун, ");
INSERT INTO uigcyr_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Һарун каһинниң нәслидин болған ундақ мәйип кишиләрниң һеч бири Пәрвәрдигарға атап отта сунулидиған нәрсиләрни кәлтүрүшкә йеқин бармисун; ундақ киши мәйиптур; у өз Худасиниң ненини сунушқа йеқин кәлмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Һалбуки, у өз Худасиниң ненини, йәни «әң муқәддәс» вә «муқәддәс» һесапланған нәрсиләрниң һәр иккисидин йесун. ");
INSERT INTO uigcyr_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Пәқәт у пәрдидин өтүп ичкирисигә кирмәслиги яки қурбангаһқиму йеқин бармаслиғи керәк; чүнки у мәйиптур; болмиса, у Мениң муқәддәс җайлиримни булғиған болиду; чүнки уларни муқәддәс қилғучи Пәрвәрдигар Өзүмдурмән». ");
INSERT INTO uigcyr_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Бу сөзләрниң һәммисини Муса Һарун билән униң оғуллири вә Исраилларниң һәммисигә ейтип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Сән Һарун билән униң оғуллириға мундақ дегин: — «Силәр Исраилларниң Маңа атиған муқәддәс һәдийәләрни еһтиятчанлиқ билән бир тәрәп қилиңлар, болмиса улар намимни булғиши мүмкин. Мән Пәрвәрдигардурмән». ");
INSERT INTO uigcyr_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Уларға мундақ дегин: — «Силәр һәр бир дәвирләрдә, барлиқ нәсиллиңлардин һәр қайсиси Исраиллар Пәрвәрдигарға атиған пак нәрсиләргә напак һаләттә йеқинлашса, ундақ киши Мениң алдимдин үзүп ташлиниду. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Һарунниң нәслидин бири песә-мохо яки ақма кесили болған болса, пак болмиғичә муқәддәс нәрсиләрдин йемисун. Бирким өлүкниң сәвәвидин напак болған биркимгә вә яки мәниси еқип кәткән кишигә тегип кәтсә, ");
INSERT INTO uigcyr_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","яки адәмни напак қилидиған өмилигүчи җаниварға тәгсә яки һәр қандақ жуқуп қалидиған напаклиғи бар бир адәмгә тегип кәтсә, (напаклиғи немидин болушидин қәтъинәзәр) ");
INSERT INTO uigcyr_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","мундақ нәрсиләргә тәккән киши кәч киргичә напак болуп, муқәддәс нәрсиләрдин йемисун. У бәдинини суда жуйсун ");
INSERT INTO uigcyr_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","андин күн олтарғанда пак санилип, муқәддәс нәрсиләрдин йейишкә болиду; чүнки булар униң озуғидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","У өзлүгидин өлгән вә яки житқучлар боғуп қойған һайванни йейиш билән өзини напак қилмисун. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Улар Мениң бу тапилиғанлиримни тутуши керәк; болмиса, буниңға ихлассизлиқ қилса, шу өлүк түпәйлидин гунакар болуп өлиду; уларни муқәддәс қилғучи Пәрвәрдигар Өзүмдурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Каһинларға ят болған һеч қандақ киши муқәддәс нәрсиләрдин йемисун. Каһинниң йенидики мусапир-меһман вә яки мәдикари болсун уларму муқәддәс нәрсиләрдин йемисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Һалбуки, каһин өзи пул чиқирип сетивалған қул униңдин йейишкә болиду; шуниңдәк униң өйидә туғулған кишиму униңдин йесә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Каһинниң қизи ят кишигә тәккән болса уму «көтәрмә һәдийә» сүпитидә аталған муқәддәс нәрсиләрдин йемисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Лекин әгәр каһинниң қизи тул болуп қелип, яки қоюп берилип пәрзәнтсиз һаләттә атисиниң өйигә йенип келип, яш вақтидикидәк олтарған болса, ундақта атисиниң таамидин йейәләйду; лекин һеч бир ят киши униңдин йемәслиги керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Әгәр бирким билмәй, муқәддәс нәрсиләрдин йәп салса, ундақта у униңға шуниң бәштин бирини қошуп, муқәддәс нәрсиниң өзи билән каһинға қайтуруп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Каһинлар Исраилларниң Пәрвәрдигарға атиған нәрсилирини булғимаслиғи керәк; ");
INSERT INTO uigcyr_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","болмиса, хәлиқ муқәддәс һәдийиләрдин йейиши билән, каһинлар хәлиқниң гәдинигә итаәтсизлик гунайини жүкләп қойған болиду; чүнки уларни муқәддәс қилғучи Пәрвәрдигар Өзүмдурмән». ");
INSERT INTO uigcyr_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Сән Һарун билән униң оғуллири вә Исраилларниң һәммисигә мундақ дегин: — Әгәр Исраил җәмәтидин бири вә яки Исраил зиминида туруватқан мусапирларниң бири өз қәсәмлиригә бағлиқ қурбанлиқ яки ихтиярий қурбанлиқни сунуп, Пәрвәрдигарға атап көйдүрмә қурбанлиқ қилмақчи болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ундақта у қобул қилиниши үчүн беҗирим әркәк кала, қой яки өшкиләрдин кәлтүрүңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Әйиви болмиған бир җаниварни сунушуңлар керәк; чүнки шундақ болғини силәр үчүн қобул қилинмас. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Бириси калилардин яки ушшақ малдин өз қәсәмлиригә бағлиқ қурбанлиқ яки ихтиярий қурбанлиқни сунуп, Пәрвәрдигарға атап енақлиқ қурбанлиғи қилмақчи болса, сунулған һайван қобул қилиниши үчүн беҗирим болуши керәк; униң һеч қандақ әйиви болмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Кор яки ақсақ-чолақ, чонақ яки яриси йириңдап кәткән, тәмрәткә басқан яки қотур-чақа бесип қалған һайванлар болса — буларни Пәрвәрдигарға атап сунсаңлар яки буларни Пәрвәрдигарға атап қурбанлиқ сүпитидә қурбангаһта отта көйдүрсәңлар болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Топақ яки қойниң мәлум җүп әзасидин бири узунрақ я қисқа болса, мундақларни ихтиярий қурбанлиқ сүпитидә өткүзсәң болиду, лекин қәсәмгә бағлиқ болса қурбанлиқ үчүн қобул қилинмас. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Уруқдини зәхимләнгән, езилип кәткән, йерилған яки пичилған һайванни Пәрвәрдигарға атап қурбанлиқ қилмаңлар. Мундақ ишни өз зиминиңлардиму һәргиз қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Худайиңларниң нени сүпитидә яқа жутлуқ кишиниң қолидин шундақ һайванлардин һеч қайсисини елип сунмаңлар; чүнки улар мәйип болғачқа, силәр үчүн қобул қилинмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Бир мозай, қоза яки оғлақ туғулса йәттә күнгичә анисини әмсун; сәккизинчи күнидин башлап Пәрвәрдигарға атап отта сунидиған қурбанлиқ сүпитидә қобул болушқа ярайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Мәйли кала болсун, қой болсун, силәр аниси билән балисини бир күндә боғузлимаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Силәр Пәрвәрдигарға атап бир тәшәккүр қурбанлиғи сунмақчи болсаңлар, қобул қилинишқа лайиқ болған йол билән сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","У сунулған күнидә йейилиши керәк; униңдин һеч немини әтисигә қалдурмаслиғиңлар керәк. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Силәр Мениң әмирлиримни чиң тутуп, уларға әмәл қилиңлар. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Мениң муқәддәс намимни булғимаңлар, Мән әнди Исраилларниң арисида муқәддәс дәп билинимән. Мән силәрни муқәддәс қилғучи Пәрвәрдигар болуп, ");
INSERT INTO uigcyr_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Худайиңлар болушқа силәрни Мисир зиминидин чиқирип кәлдим. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Сән Исраилларға мундақ дегин: — Пәрвәрдигар бекиткән һейтлар, силәр муқәддәс сорунлар болсун дәп чақирип җакалайдиған һейтлирим мана мунулардур: — ");
INSERT INTO uigcyr_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","(алтә күн иш-әмгәк қилинсун; лекин йәттинчи күни «хас шабат күни», муқәддәс сорунлар күни болиду; у күни һеч қандақ иш-әмгәк қилмаңлар. Қәйәрдила турсаңлар бу күн Пәрвәрдигарға аталған шабат күни болиду).    ");
INSERT INTO uigcyr_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Силәр бекитилгән күнлири муқәддәс сорунлар болсун дәп чақирип җакалайдиған, Пәрвәрдигарниң һейтлири мана мунулардур: — ");
INSERT INTO uigcyr_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Биринчи айниң он төртинчи күни гугумда Пәрвәрдигарға аталған «өтүп кетиш һейти» болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Шу айниң он бәшинчи күни Пәрвәрдигарға аталған «петир нан» һейти болиду; силәр йәттә күнгичә петир нан йәйсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Биринчи күнидә силәр муқәддәс жиғилиш қилип, һеч қандақ иш-әмгәк қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Силәр йәттә күнгичә Пәрвәрдигарға атап отта сунидиған қурбанлиқларни сунуп туруңлар. Йәттинчи күнидә муқәддәс жиғилиш болиду; һеч қандақ иш-әмгәк қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Сән Исраилларға мундақ дегин: — Силәр Мән өзүңларға тәқдим қилидиған зиминға кирип, униңдин һосул жиққиниңларда, һосулуңларниң дәсләпки пишқинидин бир бағламни каһинниң қешиға елип бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Каһин силәр үчүн қобул болушқа уни Пәрвәрдигарниң алдида пулаңлатсун; уни пулаңлатқан вақит болса шабатниң әтиси болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Силәр уни пулаңлатқан күндә силәр бир яшқа киргән беҗирим бир қозини Пәрвәрдигарға атап көйдүрмә қурбанлиқ сүпитидә сунуңлар; ");
INSERT INTO uigcyr_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","шуниңға қошуп ашлиқ һәдийәси сүпитидә зәйтун мейи иләштүрүлгән есил ундин бир әфаһниң ондин бирини Пәрвәрдигарға хушбуй кәлтүрсун дәп отта сунуңлар; буниңға қошуп шарап һәдийәси сүпитидә шараптин бир һинниң төрттин бирини сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Силәр Худайиңларға хас болған бу һәдийәни сунидиған күндин илгири йеңи һосулдин һеч немини, нә нан нә қомач нә көк баш болсун йемәңлар. Бу дәвирдин-дәвиргичә силәр үчүн қәйәрдә турсаңлар әбәдий бир бәлгүлимә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Андин силәр шу шабат күнниң әтисидин, йәни шу бир бағламни пулаңлатма һәдийә сүпитидә сунған күнниң әтисидин тартип, йәттә һәптә санаңлар (улар толуқ һәптә болуши керәк); ");
INSERT INTO uigcyr_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","йәттинчи шабатниң иккинчи күнигичә әллик күнни санаңлар; андин Пәрвәрдигарға атап йеңи һосулдин бир ашлиқ һәдийәси сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Өзүңлар туруватқан җайлардин пулаңлатма һәдийә сүпитидә есил ундин бир әфаһниң ондин иккисидә етилгән икки нанни елип кәлтүрүңлар; улар ечитқу селип етилгән болсун; булар Пәрвәрдигарға аталған дәсләпки һосул һәдийәси дәп һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Нандин башқа йәнә бир яшлиқ йәттә беҗирим қоза, яш бир топақ вә икки қочқарни көйдүрмә қурбанлиқ сүпитидә Пәрвәрдигарға атап сунуңлар; уларға хас ашлиқ һәдийәлири вә шарап һәдийәлирини қошуп, һәммиси Пәрвәрдигарға хушбуй кәлтүрүшкә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Буниңдин башқа силәр гуна қурбанлиғи үчүн бир текини, енақлиқ қурбанлиғи үчүн бир яшлиқ икки қозини кәлтүрүңлар; ");
INSERT INTO uigcyr_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","каһин буларни, йәни шу икки қозини дәсләпки һосул нанлириға қошуп пулаңлатма һәдийә сүпитидә Пәрвәрдигар алдида пулаңлатсун. Булар болса Пәрвәрдигарға аталған муқәддәс санилип, каһинға тәгсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Шу күни силәр «бүгүн бизләргә муқәддәс жиғилиш болиду» дәп җакалаңлар; шу күни һеч қандақ иш-әмгәк қилмаңлар. Бу силәр үчүн қәйәрдила турсаңлар әбәдий бир бәлгүлимә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Етизиңниң булуң-пучқақлириғичә тамам жиғивалмаңлар, вә һосулуңдин қалған васаңни теривалмиғин, бәлки буларни кәмбәғәлләр билән мусапирларға қойғин. Мән Өзүм Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Сән Исраилларға мундақ дегин: — Силәр йәттинчи айниң биринчи күни толуқ арам елип, канайлар челиниш билән әсләтмә йосунда һейт қилип, муқәддәс сорунларни түзүңлар.    ");
INSERT INTO uigcyr_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","У күндә һеч қандақ иш-әмгәк қилмаңлар; Пәрвәрдигарға атап отта сунулидиған бир қурбанлиқ сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Йәттинчи айниң онинчи күни болса кәфарәт күни болиду; у күн силәр үчүн муқәддәс жиғилиш күни болиду; шу күни нәпсиңларни тартип өзүңларни төвән тутуп, Пәрвәрдигарға атап отта сунулидиған қурбанлиқни сунуңлар;    ");
INSERT INTO uigcyr_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","У күндә һеч қандақ иш-әмгәк қилмаңлар; чүнки у бир кәфарәт күни болуп, шу күн өзүңлар үчүн Худайиңлар Пәрвәрдигар алдида кәфарәт қилинишқа бекитилгәндур. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Һәр ким шу күни нәпсини тартмай өзини төвән тутмиса өз хәлқидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Кимдәким шу күндиму һәр қандақ бир иш қилса, Мән шу адәмни өз хәлқидин үзүп ташлаймән. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Шу күни һеч қандақ иш қилмаңлар; бу дәвирдин-дәвиргичә силәр үчүн қәйәрдә турсаңлар бир әбәдий бәлгүлимә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","У күн силәр үчүн толуқ арам алидиған шабат күни болиду; нәпсиңларни тартип өзүңларни төвән тутуңлар. Шу айниң тоққузинчи күни гугумдин тартип әтиси гугумғичә шабат күнигә риайә қилип арам елиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Сән Исраилларға мундақ дегин: — Йәттинчи айниң он бәшинчи күнидин башлап, йәттә күнгичә Пәрвәрдигарниң «кәпиләр һейти» болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Биринчи күндә муқәддәс жиғилиш болиду; һеч қандақ иш-әмгәк қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Йәттә күнгичә Пәрвәрдигарға атап отта сунулидиған қурбанлиқ сунуңлар; сәккизинчи күндә силәргә муқәддәс жиғилиш болиду; Пәрвәрдигарға атап отта сунулидиған қурбанлиқ сунуңлар. Бу өзи тәнтәнилик жиғилиш болғач, у күни һеч қандақ иш-әмгәк қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Силәр «муқәддәс сорунлар болсун» дәп җакалайдиған, йәни Пәрвәрдигар бекиткән һейтлар мана шулардур. Шу сорунларда силәр һәр қайси күнгә бекитилгини бойичә, Пәрвәрдигарға атап отта сунулидиған һәдийә-қурбанлиқ, йәни көйдүрмә қурбанлиқ, ашлиқ һәдийәси, башқа һәр хил қурбанлиқлар вә шарап һәдийәләрни сунисиләр; ");
INSERT INTO uigcyr_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","булардин башқа, Пәрвәрдигарниң шабат күнлирини тутисиләр вә Пәрвәрдигарға атап қалған һәдийәлириңларни берип, қәсәм қурбанлиқлириңларниң һәммисини ада қилип, ихтиярий қурбанлиқлириңларниң һәммисини сунисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Силәр әнди зиминдин һосул-мәһсулатлирини жиғип болуп, йәттинчи айниң он бәшинчи күнидин башлап йәттә күн Пәрвәрдигарниң һейтини өткүзүңлар. Биринчи күни толуқ арам елиш болиду, сәккизинчи конидиму толуқ арам елиш болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Биринчи күни силәр есил дәрәқләрдин шах-путақларни чатап, йәни хорма дәрәқлири билән қоюқ йопурмақлиқ дәрәқләрниң шахлирини кесип, ериқ бойидики сөгәт чивиқлирини қирқип Худайиңлар Пәрвәрдигар алдида йәттә күнни шундақ шат-хурам өткүзисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Силәр һәр жили бу йәттә күнни Пәрвәрдигарға атиған бир һейт сүпитидә өткүзүңлар; дәвирдин-дәвиргичә бу силәр үчүн әбәдий бир бәлгүлимә болиду. Силәр һейтни йәттинчи айда өткүзүңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Йәттә күнгичә кәпиләрдә туруңлар. Исраилда туғулғанларниң һәммиси кәпидә турсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Буниң билән Мән Исраилларни Мисир зиминидин чиқарғинимда, уларни кәпиләрдә турғузғинимни әвлатлириңлар билиду. Өзүм Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Шундақ қилип Муса Пәрвәрдигарниң бекиткән шу һейтлирини Исраилларға баян қилди. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Исраилларға чирақ һемишә йениқ туруши үчүн зәйтундин соқуп чиқирилған сап майни саңа елип келишкә буйруғин. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Һарун җамаәт чедириниң ичидә, һөкүм-гувалиқ сандуғиниң удулидики пәрдиниң сиртида һәр кечиси әтигәнгичә Пәрвәрдигарниң алдида чирақларни шундақ пәрләп турсун. Бу дәвирдин-дәвиргичә силәр үчүн әбәдий бир бәлгүлимә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Һарун һемишә Пәрвәрдигарниң алдида бу чирақларни пак чирақданниң үстигә тизип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Сән йәнә есил буғдай унидин он икки тоғачни әткин. Һәр бир тоғач бир әфаһниң ондин иккисигә баравәр болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Андин сән Пәрвәрдигарниң алдидики пак ширәниң үстигә алтидин икки қатар қилип тизғин. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Һәр бир қатарниң үстигә сап мәстики қойғин; шуниң билән улар Пәрвәрдигарға атап отта сунулидиған һәдийә, әсләтмә нан болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Буларни у Исраилларға вакалитән һәр бир шабат күни Пәрвәрдигарниң алдида тизсун; бу әбәдий бир әһдидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Нанлар Һарун билән униң оғуллириға тәвә болиду; улар уларни муқәддәс җайда йесун; чүнки бу нәрсиләр Пәрвәрдигарға атап отта сунулған нәрсиләр ичидә «әң муқәддәсләрниң бири» дәп санилип, Һарунға тәвә болиду; бу әбәдий бир бәлгүлимидур. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Аниси Исраилий, атиси Мисирлиқ бир оғул бар еди. У Исраилларниң арисиға барди; у чедиргаһта бир Исраилий билән урушуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Улар соқушқанда Исраилий аялниң оғли күпүрлүк қилип, Пәрвәрдигарниң намини булғап қарғиди. Хәлиқ уни Мусаниң алдиға елип барди. У кишиниң анисиниң исми Шеломит болуп, у Дан қәбилисидин болған Дибриниң қизи еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Шуниң билән улар Пәрвәрдигарниң һөкүм буйруғи чиққичә у кишини солап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Андин Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Қарғиғучини чедиргаһниң ташқириға елип чиқиңлар. Униң ейтқинини аңлиғанларниң һәммиси қоллирини униң бешиға қойсун, андин пүткүл җамаәт бир болуп уни чалма-кесәк қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Һәмдә сән Исраилларға мундақ дегин: — Әгәр бирким өз Худасини һақарәтләп қарғиса өз гунайини тартиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Пәрвәрдигарниң намиға күпүрлүк қилған һәр қандақ киши өлүмгә мәһкүм қилинсун; пүткүл җамаәт чоқум бир болуп уни чалма-кесәк қилсун; мәйли у мусапир болсун яки йәрлик болсун, муқәддәс намға күпүрлүк қилса өлтүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Әгәр бириси башқа бирисини уруп өлтүрсә, у өлүмгә мәһкүм қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Бириси бир чарпайни өлтүрсә, униң үчүн һайванни төләп, җанға-җан төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Бирким өз хошнисини мәйип қилса, у өзгигә қандақ қилған болса, униң өзигиму шундақ қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Бирәр әзаси сундуруветилгән болса, униңму сундурулсун; көзигә-көз, чишиға-чиш накар қилинсун; башқа кишини қандақ зәхимләндүргән болса уму һәм шундақ қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Кимдәким бир чарпайни өлтүрсә, чарпай төләп бәрсун; адәмни уруп өлтүргән киши болса, өлүм җазасиға мәһкүм қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Силәрдә бирла қанун болсун. мусапир яки йәрлик болсун, баравәр муамилә қилинсун; чүнки Мән Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Муса Исраилларға шуларни деди; шуниң билән улар шу қарғиғучини чедиргаһниң ташқириға елип чиқип, чалма-кесәк қилди. Шундақ қилип, Исраиллар Пәрвәрдигарниң Мусаға әмир қилғинидәк қилди. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Пәрвәрдигар Синай теғида Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Сән Исраилларға мундақ дегин: — Мән силәргә беридиған зиминға киргиниңларда у зиминниң өзиму Пәрвәрдигарға атап бир шабат арамини алсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Сән алтә жил етизиңни терип, алтә жил таллиқ беғиңни чатап, улардин һосулларни жиққин; ");
INSERT INTO uigcyr_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","амма йәттинчи жили зиминниң өзи үчүн бир «шабатлиқ арам» болсун; у Пәрвәрдигарға аталған бир «шабат» һесаплиниду. Шу жили сән етизиңни теримайсән вә таллиғиңни чатимайсән. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Өзлүгидин үнүп чиққан һосулни ормайсән; вә чаталмиған таллириңниң үзүмлирини үзмәйсән; чүнки шу жил зимин арам алидиған жилдур. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Һалбуки, зимин шабат жилида чиқарған һосул һәммиңларға озуқ болиду, йәни өзүң үчүн, қул-дедигиң үчүн, мәдикариң үчүн вә сениңкидә туруватқан мусапир үчүн, шуниңдәк мал-варанлириң үчүн ");
INSERT INTO uigcyr_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Вә зиминиңдики явайи һайванлар үчүнму озуқ болиду; зиминниң һәммә һосули озуқ болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Шуниңдәк сән йәттә қетимлиқ шабат жилини, йәни йәттә һәссә йәттә жилни саниғин; йәттә шабат жил күнлири қириқ тоққуз жил болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Шунчилик вақит өтүп, йәттинчи айда, айниң онинчи күни, кәфарәт күнидә бурға челип садасини жуқури чиқирисиләр; кәфарәт күниниң өзидә силәр пүткүл зиминиңларда бурғиниң садасини аңлитисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Шу әллигинчи жилини силәр муқәддәс дәп билип, пүткүл зиминда униңда барлиқ туруватқанларниң һәммисигә азатлиқни җакалишиңлар керәк. Шу жил силәргә «азатлиқ жили» болиду, һәр бириңлар өз йәр-мүлүклириңларға қайтисиләр, һәр бириңлар өз аилә-җәмәтиңларға қайтип барисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Бу әллигинчи жили силәргә бир азатлиқ жили болсун; у жили һеч немә теримайсиләр, өзлүгидин үнүп чиққан һосулниму ормайсиләр вә чаталмиған таллириңларниң үзүмлириниму жиғмайсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Чүнки бу азатлиқ жили болуп, силәргә муқәддәс һесаплансун; униң һосулини болса, етиз-далилардин тепип һәммиңлар йәйсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Азатлиқ жили араңлардики һәр бир адәм өз йәр-мүлкигә қайтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Силәр хошнаңларға бир немә сетип бәрсәңлар, яки хошнаңлардин бир немә сетивалсаңлар, бир-бириңларни бозәк қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Хошнаңдин йәрни сетивалсаң, ундақта «азатлиқ жили»дин кейин өткән жилларниң санини һесаплап униңдин сетивелишиң керәк; уму қалған жилларниң саниға қарап, йәрниң кейинки һосуллириға асасән саңа сетип бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","«Азатлиқ жили»ғичә болған жиллар көпрәк болса, баһасини шуниңға мувапиқ жуқури көтирисән; қалған жиллар азрақ болса, баһасини шуниңға мувапиқ кемәйтсун. Чүнки қалған жилларниң һосуллири қанчә болса, у шу бойичә саңа сетип бериду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Силәр бир-бириңларни бозәк қилмаңлар, бәлки Худайиңлардин қорқуңлар; чүнки Мән болсам Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Силәр Мениң бәлгүлимилиримни тутуп, һөкүмлиримдә туруп, шуларға әмәл қилиңлар; силәр шундақ қилсаңлар, зиминиңларда теч-аман турисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Шуниң билән зимин силәргә өз мевисини бериду, силәр тойғидәк йәп, униңда теч-аман турисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Әгәр силәр: — Мана, бизгә терип һосулни жиғишқа иҗазәт берилмисә, йәттинчи жили немә йәймиз, дәп сорисаңлар, ");
INSERT INTO uigcyr_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","силәргә мәлум болсунки, алтинчи жилида үч жилниң һосулини бәрсун дәп, Мән үстүңларға бәрикитимни «чүш» дәп буйруймән. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Вә шундақ болидуки, силәр сәккизинчи жили терийсиләр, амма тоққузинчи жилиғичә ешип қалған кона һосулдин техичә йәйсиләр; шу тоққузинчи жилиғичә силәр кона ашлиқтин йәйсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Йәр-зимин сетилса, мәңгүлүк сетилмисун, чүнки зиминниң өзи Мениңкидур, силәр болсаңлар Мениң йенимдики мусапир вә меһман, халас. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Силәр егә болидиған пүткүл зиминда йәр-зиминниң егилиригә уни «қайтурувелиш һоқуқи»ни яритип беришиңлар керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Әгәр қериндашлириңлардин бири кәмбәғәллишип, өз мирас йерини сетивәткән болса, униң йеқин туққини, йәни «һәмҗәмәт шапаәтчи»си келип өз қериндиши сатқан йәрни қайтуруп сетивалсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Әгәр униң һеч шапаәтчи туққини болмиса, лекин у яндурувелишқа керәклик пулни тапалиса, ");
INSERT INTO uigcyr_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Ундақта сатқиниға қанчә жил болғанлиғини һесаплап, азадлиқ жилиғичә қалған жиллар үчүн сетивалған кишигә мувапиқ пул берип, өз йеригә қайтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Лекин әгәр у яндурувелишқа керәклик пулни тапалмиса, өзи сетип бәргән йәр азатлиқ жилиғичә алғучиниң қолида турсун; азатлиқ жили кәлгәндә йәр йәр сетивалғучиниң қолидин чиқсун, өз егиси өз йәр-мүлкигә қайтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Әгәр бириси сепиллиқ шәһәрниң ичидики бир туралғу өйни сатқан болса, сетип бир жил ичидә уни яндурувелиш һоқуқи бардур. Толуқ бир жил түгәп болғичә, яндурувелиш һоқуқи бардур. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Лекин пүтүн жил ичидә яндурувелинмиса, сепиллиқ шәһәрниң ичидики бу өй нәсилдин-нәсилгә алған кишиниң қолида болуп, азатлиқ жили кәлсиму яндурулмас. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Лекин сепилсиз кәнтләрниң өйлири болса зиминниң етизлиридәк һесаплиниду; уларни яндуруп сетивалғили болиду; азатлиқ жили кәлгәндә әсли егисиниң қолиға яндурулиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Лекин Лавий шәһәрлиридә болса, Лавийлар өз мираси болған шәһәрләрдики өйлирини халиса һәр қачан қайтурувелиш һоқуқи бардур. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Лавийлардин бири өйлирини, йәни өз мираси болған шәһәрдики бир өйни қайтурувелиш һоқуқи бар болсиму, лекин қайтуруп алмиған болса, ундақ әһвалда у азатлиқ жили кәлгәндә яндурулиду; чүнки Лавий шәһәрлириниң өйлири болса Лавийларниң Исраилларниң арисидики мираси болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Шундақ һәм буларниң шәһәрлириниң чөрисидики етиз-йәрлири болса, уларниң әбәдий мираси болғачқа, сетилса болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Саңа хошна болған, қериндашлириңлардин бири кәмбәғәллишип, өз җенини бақалмай қалса, сән уни мусапир яки яқа жутлуқ меһмандәк йениңда турғузуп, униңдин хәвәр алғин. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Сән униңдин өсүм вә яки пайда алмиғин; сән Худайиңдин қорқуп, қериндишиңни қешиңда турушқа қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Пулуңни униңға өсүмгә бәрмә, ашлиғиңниму пайда елиш мәхситидә униңға өтнә бәрмигин. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Худайиңлар болушқа, Қанаан зиминини силәргә беришкә силәрни Мисир зиминидин чиқирип кәлгән Худайиңлар Пәрвәрдигар Өзүмдурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Әгәр саңа хошна болған қериндишиң кәмбәғәллишип, өзини саңа сатса, уни қулдәк қуллуқ хизмитигә салмиғин; ");
INSERT INTO uigcyr_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","бәлки у қешиңда мәдикар яки мусапирдәк турсун; азатлиқ жилиғичә сениң хизмитиңдә болсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","андин азат болуп өзи билән балилири қешиңдин чиқип, өз җәмәтигә йенип берип, ата-бовилириниң йәр-мүлкигә қайтсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Чүнки улар Мән Өзүм Мисир зиминидин чиқирип елип кәлгән қул-бәндилирим болғачқа, уларни қулдәк сетишқа йол қоймаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Сән уларға қаттиқ қоллуқ билән ғоҗилиқ қилмайсән, бәлки Худайиңдин қорққин. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Лекин өзүңгә қул яки дедәк алмақчи болсаң, уларни әтраптики ят әлләрдин шундақ қул я дедәк сетивалсаң болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Булардин башқа, араңларда олтирақлашқан мусапирларниң пәрзәнтлирини вә шуларниң җәмәтидин, йәни силәр билән биллә туруватқан, зиминиңларда туғулғанлардин қуллар сетивалсаңлар болиду; шуниң билән улар силәрниң мүлкүңлар болуп қалиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Силәр мошуларни өзүңлардин кейинки балилириңларға мирас қилип, уларға мүлүк болушқа қалдурсаңлар болиду; мошуларни әбәткичә қул қилсаңлар болиду; лекин өз қериндашлириңлар болған Исраиллар арисида болса, бир-бириңларға қаттиқ қоллуқ билән ғоҗилиқ қилмаслиғиңлар керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Әгәр араңларда олтиришлиқ бир мусапир яки яқа жутлуқ бейиған вә униңға хошна қериндишиң кәмбәғәллишип, өзини шу хошна мусапирға вә яки шу мусапирниң мәлум бир әвладиға сатса, ");
INSERT INTO uigcyr_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","у сетилғандин кейин униңда пул төләп һөрлүккә чиқиш һоқуқи қалиду; униң ака-укилириниң һәр қайсиси уни һөрлүккә сетивалса болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Шуниңдәк униң тағиси яки тағисиниң оғли вә яки җәмәтидин болған һәр қайси йеқин туққини уни һөрлүккә сетивалса болиду; яки өзиниң қурби йәтсә, пул берип өз-өзини һөрлүккә сетивалса болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Уни сетивалидиған киши униң ғоҗиси билән гәплишип сетилған жилдин тартип азатлиқ жилиғичә қанчилик болғанлиғини һесаплап, сетивелиш баһасини жилларниң саниға қарап һесаплисун; һөрлүк пули һесаплашта қулниң ғоҗисиға ишләшкә керәк болған қалған күнлириниң һәққи «мәдикарниң ишлигән күнлири»дәк һесаплансун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Азатлиқ жилиға йәнә хелә жиллар болса, шуни һесаплап, сетилған пулниң нисбити бойичә һөрлүк пулини һесаплап бәрсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","әгәр азатлиқ жилиға аз жиллар қалған болса, уни һесап қилип, қалған қуллуқ жиллириға мувапиқ пулни яндуруп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Болмиса, қул шу ғоҗисиниң йенида жиллиқ мәдикардәк туруши керәк; униң ғоҗиси сениң көз алдиңда униңға қаттиқ қоллуқ билән ғоҗилиқ қилмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Әгәр қул жуқуриқи йоллар билән һөрлүккә чиқалмиса, азатлиқ жили кәлгәндә қоюп берилсун — у балилири билән қошулуп азат болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Чүнки Исраилларниң өзи Маңа қул-бәндиләрдур; улар Мән Өзүм Мисир зиминидин чиқирип кәлгән қул-бәндилиримдур. Худайиңлар Пәрвәрдигар Өзүмдурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Силәр өзүңлар үчүн һеч қандақ бут ясимаңлар яки өзүңларға һеч ойма мәбуд яки һәйкәл-түврүкни турғузмаңлар яки уларға баш урушқа оюлған нәқишлик ташларни зиминиңларда һәргиз тиклимәңлар; чүнки Өзүм Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Мениң шабат күнлиримни тутуп, муқәддәс җайимға ихласмән болуңлар. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Әгәр силәр мениң бәлгүлимилиримдә меңип, әмирлиримни тутуп уларға әмәл қилсаңлар, ");
INSERT INTO uigcyr_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Мән йериңларниң өз һосулини берип турушиға, даладики дәрәқләрниң мевисини чиқиришиға вақтида ямғурлириңларни яғдуруп туримән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Шуниң билән хаман тепиш вақти үзүм жиғиш пәслигичә болиду, үзүм жиғиш вақти терилғу вақтиғичә болиду; силәр нениңларни тоюнғичә йәп, өз зиминиңларда теч-аман турисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Мән зиминға арам-течлиқ ата қилимән, шуниң билән һеч ким силәрни қорқуталмайду, арамхуда йетип ухлайсиләр; вәһший һайванларни зиминдин йоқитимән, қиличму зиминиңлардин өтмәйду; ");
INSERT INTO uigcyr_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","силәр дүшмәнлириңларни қоғлайсиләр, улар алдиңларда қиличлинип жиқилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Силәрдин бәш киши йүз кишини қоғлайду, йүз киши он миңни қачуриду; дүшмәнлириңлар болса алдиңларда қиличлинип жиқилиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Мән силәргә йүзүмни қаритип, силәрни пәрзәнт көргүзүп көпәйтимән, силәр билән бағлиған әһдәмни мәзмут турғузимән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Силәр техичә узун сақланған кона ашлиқни йәватқиниңларда, йеңи ашлиқ чиқиду; йеңиси вәҗидин конисини чиқириветисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Мән Өз маканимни араңларда турғузимән вә қәлбим силәрдин нәпрәтләнмәйду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Мән араңларда меңип силәрниң Худайиңлар болимән вә силәр Мениң хәлқим болисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Мән силәрни Мисирда уларниң қуллири болуштин һөр қилишқа шу зиминидин чиқарған Худайиңлар Пәрвәрдигардурмән; Мән боюнтуруғуңларниң асарәтлирини сундуруп, қәддиңларни тик қилип маңғуздум. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Һалбуки, әгәр силәр Маңа қулақ салмай, бу әмирләрниң һәммисигә әмәл қилмай, ");
INSERT INTO uigcyr_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","бәлгүлимилиримни ташлап, қәлбиңлардин һөкүмлиримни яман көрүп, барлиқ әмирлиримни тутмай, әһдәмни бузсаңлар, ");
INSERT INTO uigcyr_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Мәнму бешиңларға шу ишларни чүшүримәнки, — Мән силәргә вәһимә селип, көзүңларни кор қилидиған, җениңларни зәипләштүридиған сил-ваба кесили, кезик кесилини бешиңларға чүшүримән. Силәр уруғуңларни бекар чечип-терийсиләр, чүнки дүшмәнлириңлар уни йәп кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Мән йүзүмни силәргә қарши қилимән, шуниң билән силәр дүшмәнлириңлардин урулуп қачидиған болисиләр; силәрни өч көргүчиләр үстүңлардин һөкүмранлиқ қилиду; һеч ким силәрни қоғлимисиму, қачисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Булардин һеч ибрәт алмай, бәлки Маңа йәнә қулақ салмисаңлар, Мән гуналириңлар түпәйлидин силәргә болған җазани йәттә һәссә еғирлитимән, ");
INSERT INTO uigcyr_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","күч-һәйвәңлардин болған һакавурлуғиңларни сундуримән; асминиңларни төмүрдәк қилип, йериңларни мистәк қиливетимән; ");
INSERT INTO uigcyr_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","әҗир-җапайиңлар бекарға кетиду, йериңлар һосул бәрмәйду, даладики дәрәқләргә мевә чүшмәйду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Әгәр йәнила Мән билән қарши маңсаңлар, шундақла Маңа қулақ салмисаңлар, Мән гуналириңларға лайиқ бешиңларға чүшидиған ваба-күлпәтләрни йәнә йәттә һәссә еғирлитимән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Араңларға силәрни балилириңлардин җуда қилидиған, чарпайлириңларни йоқитидиған, силәрни азлитидиған явайи һайванларни әвәтимән; йол-кочилириңлар адәмзатсиз чөлдәк болуп қалиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Силәр бу ишлар арқилиқ ибрәт-тәрбийә алмай, бәлки йәнила Маңа қарши маңсаңлар, ");
INSERT INTO uigcyr_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Мәнму силәргә қарши меңип, гунайиңлар түпәйлидин болған җазани йәнә йәттә һәссә еғирлитип, Мән Өзүм силәрни уримән; ");
INSERT INTO uigcyr_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","үстүңларға әһдәмни бузғанлиқниң интиқамини алидиған қилич чүшүримән; шуниң билән силәр шәһәрләргә жиғиливалисиләр, Мән араңларға ваба чүшүримән; шуниң билән силәр дүшмәнләрниң қолиға чүшисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Силәргә йөләнчүк болған ашлиқни қурутуветимән; он аял бир болуп бир тонурда нан йеқип, нанларни силәргә таразида тартип бериду, амма буни йегиниңлар билән тоймайсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Әгәр булардин һеч ибрәт алмай, маңа қулақ салмисаңлар, бәлки маңа қарши маңсаңлар, ");
INSERT INTO uigcyr_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Мәнму қәһр билән силәргә қарши маңимән; Мән, йәни Мән Өзүм гуналириңлар түпәйлидин җаза-тәрбийини йәнә йәттә һәссә еғирлитип чүшүримән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Шуниң билән силәр оғуллириңларниң гөши вә қизлириңларниң гөшини йәйсиләр; ");
INSERT INTO uigcyr_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","шундақла Мән қурбанлиқ «жуқури җай»лириңлани вәйран қилип, «күн түврүк»лириңларни сундуруп, өлүклириңларни сунуқ бутлириңларниң үстигә ташливетимән; Мениң қәлбим силәрдин нәпрәтлиниду.    ");
INSERT INTO uigcyr_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Мән шәһәрлириңларни вәйран қилип, муқәддәс җайлириңларни харап қилип, қурбанлиғиңларниң хушбуйлирини йәнә пуримаймән; ");
INSERT INTO uigcyr_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","зиминни һалакәткә елип баримән; униңда олтирақлашқан дүшмәнлириңлар бу әһвалға һәйрануһәс қалиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Силәрни әлләрниң арисиға таритип, кәйниңлардин қилични суғуруп қоғлаймән; шуниң билән зиминиңлар вәйран болуп шәһәрлириңлар харап қилиниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","У вақитта, силәр дүшмәнлириңларниң зиминида туруватқиниңларда, зимин вәйранә болған барлиқ күнләрдә, зимин өз шабат күнлиридин сөйүниду; у заманда зимин дәрвәқә арам елип өз шабатлиридин сөйүниду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Өзи вәйранә болуп турған барлиқ күнлиридә у арам алиду, йәни силәр униңда туруватқан вақиттики шабат күнлириңларда һеч алмиған арамни әнди алиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Араңлардин қутулуп қалғанлар болса, улар дүшмәнләрниң зиминлирида турғинида көңүллиригә жүрәкзадилик салимән, шуниң билән улар чүшкән бир йопурмақниң шәписини аңлиса қиличтин қачқандәк қачиду; һеч ким қоғлимисиму жиқилип чүшиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Гәрчә һеч ким уларни қоғлимисиму, дәрвәқә қиличтин жиқитилғандәк улар бир-бириниң үстигә путлишип жиқилиду; силәрдә дүшмәнлириңларға қарши турғидәк күч қалмайду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Әлләрниң арисида һалак болисиләр, дүшмәнлириңларниң зимини силәрни йәп кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Араңлардин қутулуп қалғанлири болса өз рәзиллиги түпәйлидин дүшмәнлириңларниң зиминида зәиплишиду; вә ата-бовилириниң рәзиллигидиму жүрүп, шулар зәипләшкәндәк уларму зәиплишиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Һалбуки, улар өзи қилған рәзиллиги билән ата-бовилириниң садир қилған рәзиллигини, Маңа йүз өрүп асийлиқ қилғинини, шундақла уларниң Маңа қарши туруп маңғинини бойниға алиду, ");
INSERT INTO uigcyr_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","шуниңдәк Мениң уларға қарши маңғинимға, шуниңдәк уларни дүшмәнлириниң қолиға тапшурғинимға иқрар болиду. Шуңа әгәр у вақитта уларниң хәтнисиз көңли төвән қилинип, өз қәбиһлигиниң җазасини қобул қилса, ");
INSERT INTO uigcyr_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ундақта Мән Яқуп билән бағлиған әһдәмни яд қилип, Исһақ билән бағлиған әһдәмниму вә Ибраһим билән бағлиған әһдәмниму есимгә кәлтүримән, зиминниму яд қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Чүнки зимин улардин ташлинип, уларсиз болуп харабә турған вақитта, шабат күнлиридин сөйүниду; улар болса өз қәбиһлигиниң җазасини қобул қилиду; сәвәви дәл шуки, улар Мениң һөкүмлиримни ташлиди, бәлгүлимилиримни қәлбидин яман көргән еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Һалбуки, шундақ болсиму, улар өз дүшмәнлириниң зиминида турғинида Мән уларни ташлимаймән яки уларға өчлүк қилмаймән, шуниңдәк улар билән бағлиған әһдәмни бузмаймән, уларни йоқатмаймән; чүнки Мән Өзүм уларниң Худаси Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Мән бәлки уларни дәп, уларниң Худаси болушқа әлләрниң көзи алдида Мисир зиминидин чиқирип кәлгән ата-бовилири билән бағлашқан әһдәмни есимдә тутимән. Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Пәрвәрдигар Мусани васитә қилип, Синай теғида өзи билән Исраилларниң оттурисида бекиткән һөкүмләр, бәлгүлимиләр вә қанунлар мана шулар еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Сән Исраилларға мундақ дегин: — Әгәр бириси пәвқулъаддә бир қәсәм қилип мәлум кишиниң җенини Пәрвәрдигарға атиған болса, ундақта шу кишигә сән бекиткән җениниң қиммитиниң нәрхи төвәндикидәк болиду; ");
INSERT INTO uigcyr_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Йеши жигирмә билән атмишниң арилиғида болған әр киши болса, сән тохтитидиған қиммити муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә болсун; униң қиммити әллик шәкәл күмүчкә тохтитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Аял киши болса, араңларда тохтитилған қиммити оттуз шәкәл болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Әгәр йеши бәш билән жигирминиң арилиғида болса, әркәк үчүн тохтитилидиған қиммити жигирмә шәкәл болуп, аял киши үчүн он шәкәл болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Әгәр йеши бир ай билән бәш яшниң арилиғида болса, тохтитилидиған қиммити оғул бала үчүн бәш шәкәл, қиз бала үчүн үч шәкәл күмүч болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Әгәр атмиш я униңдин чоңрақ яштики киши болса, тохтитилидиған қиммити әр киши үчүн он бәш шәкәл, хотун киши үчүн он шәкәл болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Әгәр бириси тохтитилған қиммитини төләшкә қурби йәтмисә, у өзини каһинниң алдида тәқ қилсун; каһин униң қиммитини бекитсун. Каһин қәсәм қилғучиниң әһвалиға қарап униң қиммитини тохтитип бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Әгәр бириси қәсәм қилип Пәрвәрдигарға қурбанлиқ болушқа лайиқ болидиған бир һайванни униңға атиған болса, ундақта шундақ һайванлар Пәрвәрдигарға атап мутләқ муқәддәс саналсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","һайван начар болса униң орниға яхшини яки яхшиниң орниға начирини тегишишкә яки орниға башқисини алмаштурушқа һәргиз болмайду. Мабада атиғучи у һайванниң орниға йәнә бир һайванни йәңгүшлимәкчи болса, Авалқиси билән орниға әкәлгининиң һәр иккиси муқәддәс саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Әгәр һайван Пәрвәрдигарға аталған қурбанлиққа лайиқ болмайдиған бир «напак» һайван болса, ундақта у һайванни каһинниң алдиға елип кәлсун; ");
INSERT INTO uigcyr_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","андин каһин өзи униң яхши-яманлиғиға қарап қиммитини тохтатсун; каһин қиммитини қанчә тохтатқан болса шундақ болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Әгәр егиси пул төләп һайванни қайтурувулмақчи болса, тохтитилған қиммитигә йәнә униң бәштин бирини қошуп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Әгәр бириси Пәрвәрдигарға муқәддәс болсун дәп өйини униңға атап муқәддәс қилса, каһин униң яхши-яманлиғиға қарап қиммитини тохтатсун; каһин униң қиммитини қанчә тохтатқан болса, шу қиммити инавәтлик болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Кейин әгәр өйни атиғучи киши уни қайтурувалмақчи болса, у тохтитилған қиммитигә униң бәштин бирини қошуп бәрсун; андин өй йәнә униң болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Әгәр бириси өз мал-мүлки болған етизлиқниң бир қисмини Пәрвәрдигарға атап муқәддәс қилса, қиммити униңға қанчилик уруқ терилидиғанлиғиға қарап тохтитилсун; бир хомир арпа уруғи кетидиған йәр болса, қиммити әллик шәкәл көмүшкә тохтитилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Әгәр бириси «азатлиқ жили»дин тартип өз етизлиғини муқәддәс қилса, сән қанчә тохтатсаң шу болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Лекин әгәр бириси «азатлиқ жили»дин кейин өз етизлиғини муқәддәс қилған болса, каһин келидиған азатлиқ жилиғичә қанчилик жиллар қалғанлиғини һесаплап қиммитини тохтатсун. Өтүп кәткән жилларға қарап толуқ баһадин мувапиқ пул кемәйтилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Әгәр бириси өз етизлиғини муқәддәс қилғандин кейин пул төләп уни қайтурувалмақчи болса, у сән тохтатқан қиммитигә йәнә униң бәштин бирини қошуп бәрсун; шуниң билән етизлиқ униң өз қолиға қайтиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Әгәр у пул берип етизлиқни қайтурувалмиған болса яки башқа бирисигә сетип бәргән болса, кейин шу етизлиқни қайтурувелишқа болмайду, ");
INSERT INTO uigcyr_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Бәлки азатлиқ жили кәлгәндә етизлиқ «егисигә қайтурулидиғанда» у мутләқ беғишланған йәргә охшаш, Пәрвәрдигарға атап муқәддәс қилинип, мирас һоқуқи каһинға өтиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Әгәр бириси сетивалған амма өз мираси болмиған бир парчә йәр-етизни Пәрвәрдигарға атап муқәддәс қилған болса, ");
INSERT INTO uigcyr_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","каһин азатлиқ жилиғичә қалған жилни һесаплап, қиммитини тохтатсун. Андин у күни шу киши тохтитилған қиммитини Пәрвәрдигарға муқәддәс қилған нәрсә сүпитидә кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Лекин азатлиқ жили кәлгәндә, етизлиқ кимдин елинған болса, шу кишигә, йәни әслидики егисигә қайтуруп берилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Сән тохтитидиған барлиқ қиммәтләр болса һемишә муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә һесаплансун; бир шәкәл жигирмә гәраһқа баравәр болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Лекин чарпайниң тунҗа балиси тунҗа бала болғанлиғи сәвәвидин әслидинла Пәрвәрдигарға атилидиған болғачқа, кала болсун, қой-өшкә болсун һеч ким уни «Худаға атап» муқәддәс қилмисун; чүнки у әслидә Пәрвәрдигарниң еди. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Әгәр у напак бир һайвандин туғулған болса, егиси сән тохтатқан қиммәткә йәнә униң бәштин бирини қошуп берип, андин өзигә қайтурувалсун; лекин әгәр егиси уни өзигә қайтурувалмаймән десә, бу һайван сән тохтатқан қиммәткә сетилсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Әгәр бириси Пәрвәрдигарға өз мелидин, адәм болсун, һайван болсун яки мирас йери болсун, Пәрвәрдигарға мутләқ атиған болса, ундақ нәрсә һәргиз сетилмисун яки бәдәл төләш биләнму қайтурулмисун. Пәрвәрдигарға мутләқ аталған һәр нәрсә болса «әң муқәддәсләрниң бири» һесаплинип, униңға хас болиду. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Әгәр бир адәм Худаға мутләқ хас аталған болса, ундақта униң үчүн бәдәл берилип, қайтурувелинишқа һәргиз болмайду; у чоқум өлтүрүлүши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Йәр-зиминдин чиққан һәммә һосулниң ондин бири болған өшрә болса, йәрниң данлиқ зираәтлири болсун яки дәрәқләрниң мевиси болсун, Пәрвәрдигарниңки болиду; у Пәрвәрдигарға муқәддәс қилинғандур. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Бириси өз өшрилиридин мәлум бир нәрсини бәдәл берип қайтурувалмақчи болса, у шуниңға йәнә униң қиммитиниң бәштин бирини қошуп берип, қайтурувалсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Кала яки қой-өшкә падисидин елинидиған өшрә болса падичиниң тайиғи астидин өткүзүлгән һайванлардин һәр онинчиси болсун; Пәрвәрдигарға атилип муқәддәс қилинғини шу болсун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Һеч ким униң яхши-яманлиғиға қаримисун вә яки уни алмаштурмисун; әгәр уни алмаштуримән десә, Авалқиси билән орниға алмаштурулған һәр иккиси муқәддәс саналсун; у һәргиз бәдәл төлүп қайтурувелинмисун. ");
INSERT INTO uigcyr_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Пәрвәрдигар Синай теғида Мусаға тапилған, Исраилларға тапшуруш керәк болған әмирләр мана шулар еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Вә Исраиллар Мисирдин чиққандин кейин иккинчи жили иккинчи айниң биринчи күни Пәрвәрдигар Синай чөлидә, җамаәт чедирида туруп Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Силәр пүткүл Исраил җамаитини қәбилиси, ата җәмәти бойичә санини елип чиқиңлар; адәмләрниң исми асас қилинип, барлиқ әркәкләр тизимлансун. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Исраиллар ичидә умумән жигирмә яштин ашқан, җәңгә чиқалайдиғанларни Һарун билән иккиңлар уларниң қошун-қисмилири бойичә санақтин өткүзүңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Һәр бир қәбилидин силәргә ярдәмлишидиған бирдин киши болсун; уларниң һәр бири уларниң ата җәмәтиниң беши болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Төвәндикиләр силәргә ярдәмлишидиғанларниң исимлиғи: — Рубән қәбилисидин Шидөрниң оғли Әлизур; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Шимеон қәбилисидин Зури-шаддайниң оғли Шелумийәл; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Йәһуда қәбилисидин Амминадабниң оғли Наһшон; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Иссакар қәбилисидин Зуарниң оғли Нәтанәл; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Зәбулун қәбилисидин Һелонниң оғли Елиаб; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Йүсүп әвлатлири ичидә Әфраим қәбилисидин Аммиһудниң оғли Әлишама; Манассәһ қәбилисидин Пидаһзурниң оғли Гамалийәл; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Бинямин қәбилисидин Гидеониниң оғли Абидан; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Дан қәбилисидин Аммишаддайниң оғли Аһиезәр; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Ашир қәбилисидин Окранниң оғли Пагийәл; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Гад қәбилисидин Деуәлниң оғли Әлиасаф; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Нафтали қәбилисидин Енанниң оғли Аһира». ");
INSERT INTO uigcyr_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Булар җамаәт ичидин чақирилғанлар, йәни ата җәмәт-қәбилилириниң башлиқлири, миңлиған Исраилларниң баш сәрдарлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Шуниң билән Муса билән Һарун исми аталған бу кишиләрни башлап, ");
INSERT INTO uigcyr_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","иккинчи айниң биринчи күни пүткүл җамаәтни жиғди; улар хәлиқниң һәр бириниң қәбилә-нәсәби, ата җәмәти бойичә исмини асас қилип, жигирмә яштин жуқуриларниң һәммисини бир-бирләп тизимлиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Пәрвәрдигар Мусаға қандақ буйруған болса, Муса Синай чөлидә уларни шундақ санақтин өткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Исраилниң тунҗа оғли Рубәнниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиған әркәкләрниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Рубән қәбилисидин санақтин өткүзүлгәнләр җәмий қириқ алтә миң бәш йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Шимеонниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиған әркәкләрниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Шимеон қәбилисидин санақтин өткүзүлгәнләр җәмий әллик тоққуз миң үч йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Гадниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Гад қәбилисидин санақтин өткүзүлгәнләр җәмий қириқ бәш миң алтә йүз әллик киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Йәһуданиң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Йәһуда қәбилисидин санақтин өткүзүлгәнләр җәмий йәтмиш төрт миң алтә йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Иссакарниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Иссакар қәбилисидин санақтин өткүзүлгәнләр җәмий әллик төрт миң төрт йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Зәбулунниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Зәбулун қәбилисидин санақтин өткүзүлгәнләр җәмий әллик йәттә миң төрт йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Йүсүпниң әвлатлири: — униң оғли Әфраимниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Әфраим қәбилисидин санақтин өткүзүлгәнләр җәмий қириқ миң бәш йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Йүсүпниң иккинчи оғли Манассәһниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Манассәһ қәбилисидин санақтин өткүзүлгәнләр җәмий оттуз икки миң икки йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Биняминниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Бинямин қәбилисидин санақтин өткүзүлгәнләр җәмий оттуз бәш миң төрт йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Данниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Дан қәбилисидин санақтин өткүзүлгәнләр җәмий атмиш икки миң йәттә йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Аширниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ашир қәбилисидин санақтин өткүзүлгәнләр җәмий қириқ бир миң бәш йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Нафталиниң әвлатлири ата җәмәти, аилиси бойичә, исми асас қилинип, жигирмә яштин ашқан, җәңгә чиқалайдиғанларниң һәммиси бир-бирләп тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Нафтали қәбилисидин санақтин өткүзүлгәнләр җәмий әллик үч миң төрт йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Жуқириқилар болса санақтин өткүзүлгәнләр болуп, Муса билән Һарун һәм Исраилларниң он икки әмри (һәр бири өз ата җәмәтигә вәкил болди) уларни санақтин өткәзгән. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Шундақ қилип, Исраилларниң һәммиси, йәни Исраилда жигирмә яштин ашқанлардин, җәңгә чиқалайдиғанларниң һәммиси ата җәмәтлири бойичә тизимланди; ");
INSERT INTO uigcyr_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Санақтин өткүзүлгәнләр җәмий алтә йүз үч миң бәш йүз әллик киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Бирақ Лавийлар ата җәмәт-қәбилиси бойичә санақниң ичигә киргүзүлмиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Чүнки Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Сән пәқәт Лавий қәбилисинила шу һесапқа киргүзмигин, уларниң умумий саниниму Исраилларниң қатариға киргүзмигин. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Лекин сән Лавийларни Худаниң һөкүм-гувалиғи сақлақлиқ чедир вә униң ичидики барлиқ қача-қуча әсвапларни һәм униңға даир барлиқ нәрсиләрни башқурушқа тайинлиғин; улар ибадәт чедирини вә униң ичидики барлиқ қача-қуча әсвапларни көтириду; ибадәт чедириниң хизмитини қилғучилар шулар болсун, улар чедирниң төрт әтрапида өз чедирлирини тиксун. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Чедирни көчүридиған чағда уни Лавийлар сөксун; чедирни тикидиған чағда уни Лавийлар тиксун; Лавийларға ят болған һәр қандақ адәм униңға йеқинлашса өлүмгә мәһкүм қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Исраиллар баргаһ қурғанда һәр адәм өз қисмида, өзигә хас туғ астиға чедир тиксун. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Бирақ Худаниң ғәзиви Исраил җамаитиниң үстигә чүшмәслиги үчүн, Лавийлар Худаниң һөкүм-гувалиғи сақлақлиқ чедирниң төрт әтрапиға баргаһ қурсун; Лавийлар Худаниң һөкүм-гувалиғи сақлақлиқ чедирни муһапизәт қилишқа мәсъул болиду» — дегән еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Исраиллар әнә шундақ қилди; Пәрвәрдигар Мусаға қандақ буйруған болса, улар шундақ қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Пәрвәрдигар Муса билән Һарунға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Исраиллар һәр бири өзлириниң туғи астиға, өзлириниң ата җәмәтиниң байриғи астида чедир тиксун; җамаәт чедириниң төрт әтрапидин сәл жирақрақ баргаһ қурсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Күн чиқиш тәрәпкә, шәриқ тәрәпкә қаритип өз туғи астида қошун-қисми бойичә баргаһ қуридиғини Йәһуда болсун; Йәһудаларниң әмри Амминадабниң оғли Наһшон болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий йәтмиш төрт миң алтә йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Униң йенида баргаһ қуридиғини Иссакар қәбилиси болсун; Иссакарларниң әмри Зуарниң оғли Нәтанәл болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий әллик төрт миң төрт йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Уларниң йенида йәнә Зәбулун қәбилиси болсун; Зәбулунларниң әмри Һелонниң оғли Елиаб болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий әллик йәттә миң төрт йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Умумән Йәһуда баргаһиға қарайдиғанларниң һәммиси, йәни қошун-қисимлири бойичә санақтин өткүзүлгәнләр җәмий бир йүз сәксән алтә миң төрт йүз киши; улар алди билән йолға чиқсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","— Җәнуп тәрәптә, туғ тикләп, қошун тәртиви билән баргаһ қуридиғини Рубән қәбилиси болсун; Рубәнларниң әмри Шидөрниң оғли Әлизур болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий қириқ алтә миң бәш йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Униң йенида баргаһ қуридиғини Шимеон қәбилиси болсун; Шимеонларниң әмри Зури-шаддайниң оғли Шелумийәл болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий әллик тоққуз миң үч йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Уларниң йенида Гад қәбилиси болсун; Гадларниң әмри Деуәлниң оғли Әлиасаф болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий қириқ бәш миң алтә йүз әллик киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Рубән баргаһиға қарайдиғанларниң һәммиси, йәни қошуни бойичә санақтин өткүзүлгәнләр җәмий бир йүз әллик бир миң төрт йүз әллик киши; улар иккинчи сәп болуп йолға чиқсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Андин җамаәт чедири билән Лавийларниң баргаһи башқа баргаһларниң оттурисида маңсун; улар қандақ баргаһ қурған болса, шундақ йолға чиқсун; һәр қайсиси өз орнида өз туғи астида болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","— Күн петиш тәрәптә, туғ тикләп, қошун тәртиви билән баргаһ қуридиғини Әфраим қәбилиси болсун; Әфраимларниң әмри Аммиһудниң оғли Әлишама болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий қириқ миң бәш йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Униң йенида баргаһ қуридиғини Манассәһ қәбилиси болсун; Манассәһләрниң әмри Пидаһзурниң оғли Гамалийәл болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий оттуз икки миң икки йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Уларниң йенида Бинямин қәбилиси болсун; Биняминларниң әмри Гидеониниң оғли Абидан болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий оттуз бәш миң төрт йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Умумән Әфраим баргаһиға қарайдиғанларниң һәммиси, йәни қошун қисимлири бойичә санақтин өткүзүлгәнләр җәмий бир йүз сәккиз миң бир йүз киши; улар үчинчи сәп болуп йолға чиқсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","— Шимал тәрәптә, туғ тикләп, қошун тәртиви билән баргаһ қуридиғини Дан қәбилиси болсун. Данларниң әмри Аммишаддайниң оғли Аһиезәр болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий атмиш икки миң йәттә йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Униң йенида баргаһ қуридиғини Ашир қәбилиси болсун; Аширларниң әмри Окранниң оғли Пагийәл болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий қириқ бир миң бәш йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Уларниң йенида Нафтали қәбилиси болсун; Нафталиларниң әмри Енанниң оғли Аһира болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Униң қошуни, йәни санақтин өткүзүлгәнләр җәмий әллик үч миң төрт йүз киши. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Дан баргаһиға қарайдиғанларниң һәммиси, йәни қошун-қисимлири бойичә санақтин өткүзүлгәнләр җәмий бир йүз әллик йәттә миң алтә йүз киши; улар өз туғлири астида һәмминиң кәйнидә йолға чиқсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Жуқиридикиләр өз ата җәмәти бойичә санақтин өткүзүлгән Исраиллардур; қошун-қисимлири бойичә баргаһларда санақтин өткүзүлгәнләр җәмий алтә йүз үч миң бәш йүз әллик киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Бирақ Лавийларла, Пәрвәрдигарниң Мусаға қилған әмри бойичә, Исраиллар қатарида санақтин өткүзүлмиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Исраиллар Пәрвәрдигарниң Мусаға қилған барлиқ әмри бойичә иш тутуп, өзлириниң туғи бойичә баргаһ қуратти; улар өз қәбилиси вә ата җәмәти тәртиви бойичә йолға чиқатти. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Пәрвәрдигар Синай теғида Муса билән сөзләшкән күнләрдә, Һарун билән Мусаниң әвлатлири төвәндикиләрдин ибарәт еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Һарунниң оғуллириниң исми мундақ: тунҗа оғлиниң исми Надаб еди, униң йәнә Абиһу, Әлиазар, Итамар дегән оғуллири бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Һарунниң оғуллириниң исми әнә шундақ еди, улар мәсиһләнгән каһинлар еди; Муса уларни каһинлиқ вәзиписини өтәшкә Худаға атап айриған еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Лекин Надаб билән Абиһу Синай чөлидә ғәйрий бир отни Пәрвәрдигарниң алдиға сунғини түпәйлидин Пәрвәрдигар алдида өлди вә уларниң һеч нәсли қалдурулмиди; Әлиазар билән Итамар өз атиси Һарун алдида каһинлиқ вәзиписини өтиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Сән Лавий қәбилисини алдиңға кәлтүрүп, уларни каһин Һарунниң хизмитидә болушқа униң алдиға һазир қил. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Улар Һарунниң һаҗити вә пүткүл җамаәтниң һаҗитидин чиқип җамаәт чедириниң алдида вәзипә өтәп, ибадәт чедириниң хизмитини беҗирсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Улар йәнә җамаәт чедиридики барлиқ қача-қуча әсвапларни башқуруш билән Исраилларниң хизмитидә болуп вәзипә өтәп, ибадәт чедириниң ишлирини беҗирсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Сән Лавийларни Һарун билән униң оғуллириға тәқсимләп бәргин; улар Исраиллар ичидин мәхсус униңға таллап берилгән. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Һарун билән оғуллирини болса сән өзиниң каһинлиқ вәзиписини өтәшкә бекиткин; һәр қандақ ят киши йеқинлашса өлтүрүлсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Андин Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","— Қара, Мән Исраиллар ичидин Лавийларни таллидим, уларни Исраил ичидә балиятқуниң барлиқ тунҗа мевисиниң орниға, йәни чоң оғуллириниң орниға қойимән, шуңа Лавийлар Мениң болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Чүнки тунҗа оғулларниң һәммиси Мениңкидур; Мән Мисир зиминида тунҗа туғулғанларниң һәммисини қәтл қилған күнидә Исраилларниң ичидики тунҗиларниң һәммисини, мәйли адәм болсун яки һайван болсун, муқәддәс һесаплап Мениңки қилған едим. Улар Мениңкидур; Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Андин Пәрвәрдигар Синай чөл-баяванида Мусаға: — ");
INSERT INTO uigcyr_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","— Сән Лавийларни ата җәмәти, аилиси бойичә санақтин өткүз; барлиқ әркәкләрни, йәни бир айлиқтин ашқанларниң һәммисини санақтин өткүз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Шуниң билән Муса Пәрвәрдигарниң әмри бойичә, өзигә дейилгәндәк Лавийларни санақтин өткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Лавийниң оғуллириниң исми мундақ: — Гәршон, Коһат, Мәрари. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Гәршонниң оғуллириниң исми аилилири бойичә Либни вә Шимәй еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Коһатниң оғуллири аилилири бойичә Амрам, Изһар, Һеброн вә Уззиәл еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Мәрариниң оғуллири аилилири бойичә Маһли вә Муши еди. Буларниң һәммиси ата җәмәти бойичә Лавийларниң җәмәти болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Гәршондин Либниларниң җәмәти билән Шимәйләрниң җәмәти вуҗудқа кәлди; булар Гәршонларниң җәмәтлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Барлиқ әрләрниң саниға асасән, бир айлиқтин ашқанлириниң санақтин өткүзүлгәнлири җәмий йәттә миң бәш йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Гәршонниң җәмәти ибадәт чедириниң арқа тәрипидә, йәни ғәрип тәрәптә баргаһ қурди; ");
INSERT INTO uigcyr_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Гәршон җәмәтиниң әмри Лаәлниң оғли Әлиасаф еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Гәршонларниң җамаәт чедиридики вәзиписи ибадәт чедириниң өзидики астинқи икки япқуч-пәрдә, униң үстидики йопуқ вә җамаәт чедириниң ишик пәрдисигә, ");
INSERT INTO uigcyr_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","шундақла һойла әтрапидики пәрдиләр, һойла дәрвазисиниң пәрдиси (һойла пәрдилири ибадәт чедири билән қурбангаһни чөридәп туратти) вә һойлида ишлитилидиған мунасивәтлик барлиқ таниларға қараш еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Коһаттин Амрамларниң җәмәти, Изһарларниң җәмәти, Һебронларниң җәмәти вә Уззиәлләрниң җәмәти вуҗудқа кәлди; бу Коһатларниң җәмәтлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Барлиқ әркәкләрниң сани бойичә, бир айлиқтин ашқанлар җәмий сәккиз миң алтә йүз адәм болуп чиқти; улар муқәддәс җайға қараш вәзиписини өтәйдиған болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Коһат әвлатлириниң җәмәтлири җамаәт чедириниң җәнуп тәрипидә баргаһ тикти. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Коһат җәмәтиниң әмри Уззиәлниң оғли Әлизафан еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Уларниң вәзиписи әһдә сандуғи, ширә, чирақдан, икки қурбангаһ, шуниңдәк муқәддәс җайниң ичидә ишлитидиған қача-қуча, пәрдә вә ибадәт чедириниң ичидә ишлитидиған барлиқ нәрсиләргә қараш еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Лавийларниң әмирлириниң әмри болса каһин Һарунниң оғли Әлиазар еди; у муқәддәсханиға қараш вәзиписини өтәйдиғанлар үстидин назарәт қилидиған болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Мәраридин Маһли җәмәти билән Муши җәмәти вуҗудқа кәлди; булар Мәрариниң җәмәтлири болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Барлиқ әркәкләрниң саниға асасән, бир айлиқтин жуқури болғанлар санақтин өткүзүлгәндә җәмий алтә миң икки йүз киши чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Мәрариниң җәмәтиниң әмри Абиһайилниң оғли Зурийәл болди; улар ибадәт чедириниң шимал тәрипигә баргаһ қурди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Мәрари әвлатлириниң вәзиписи ибадәт чедириниң тахтайлири, балдақлири, хадилириға, тәгликлири барлиқ әсвап-җабдуқлириға қараш, шуниңдәк буларға мунасивәтлик ишлитилидиған барлиқ нәрсиләргә, ");
INSERT INTO uigcyr_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","шундақла һойлиниң төрт әтрапидики хадиларға вә уларниң тәгликлири, қозуқ вә таниларға мәсъул болушқа бәлгүләниди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ибадәт чедириниң алдиға, шәриқ тәрипигә, йәни җамаәт чедириниң күнчиқиш тәрипигә баргаһ қурғанлар Муса, Һарун вә Һарунниң оғуллири еди; улар Исраилларниң хизмитидә болуш вәзиписини өтәп, муқәддәс җайға қарайдиған болди; уларға ят болған һәр қандақ адәм муқәддәс җайға йеқинлашса, өлтүрүләтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Муса билән Һарун Пәрвәрдигарниң әмри бойичә, санақтин өткүзгән барлиқ Лавийлар, җәмәтлири бойичә, йәни бир айлиқтин жуқури санақтин өткүзүлгән әркәкләр җәмий жигирмә икки миң чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Пәрвәрдигар Мусаға: — Сән Исраиллар ичидә бир айлиқтин ашқан тунҗа оғулларни санақтин өткүзүп, исим-фамилиси бойичә тизимлап чиқ. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Сән Лавийларни Исраилларниң барлиқ тунҗилириниң орнида Маңа хас қил (Мән Пәрвәрдигардурмән); Лавийларниң мал-чарвилириниму Исраилларниң барлиқ тунҗа мал-чарвилириниң орнида Маңа хас қил, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Муса Пәрвәрдигарниң әмри бойичә, Исраилларниң тунҗилирини қоймай санақтин өткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Бир айлиқтин жуқури тунҗа оғул балилирини исим-фамилиси билән санақтин өткүзгәндә, улар җәмий жигирмә икки миң икки йүз йәтмиш үч киши чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Сән Лавийларни Исраилларниң тунҗилириниң орнида Маңа талла, шундақла Лавийларниң мал-чарвилириниму Исраилларниң мал-чарвилириниң орнида Маңа талла; шуниң билән Лавийлар Мениңки болиду; Мән Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Вә Лавийларниң санидин артуқ чиққан Исраилларниң тунҗилири, йәни шу икки йүз йәтмиш үчи үчүн һөрлүк һәққини қобул қилғин; ");
INSERT INTO uigcyr_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","шуларниң һәр бири үчүн бәш шәкәл күмүч ал, киши саниға қарап болсун; муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә улардин алғин (бир шәкәл жигирмә гәраһдур).    ");
INSERT INTO uigcyr_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Артуқ чиққан адәмләрниң, йәни һөрлүк һәққини төлиши керәк болғанларниң күмүчини Һарун билән униң оғуллириға бәр. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Әнди Лавийлар тәрипидин «һөрлүккә чиқирилған» дәп һесапланған тунҗа оғуллардин артуқ чиққанлардин болса, Муса улардин шу һөрлүк һәққини алди; ");
INSERT INTO uigcyr_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","у Исраилларниң тунҗилиридин шу күмүчни, йәни муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә җәмий бир миң үч йүз атмиш бәш шәкәл алди. ");
INSERT INTO uigcyr_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Муса Пәрвәрдигарниң әмри бойичә «һөрлүккә чиқирилған»ларниң күмүчини дәл Пәрвәрдигар буйруғинидәк, Һарун билән униң оғуллириға бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Андин Пәрвәрдигар Муса билән Һарунға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Сән Лавийлар ичидин ата җәмәти бойичә Коһат әвлатлириниң умумий санини тизимлиғин, ");
INSERT INTO uigcyr_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","оттуз яштин әллик яшқичә болған, җамаәт чедирида иш-хизмәт қилишқа келәләйдиғанларниң һәммисини тизимлап чиқ. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Коһат әвлатлириниң җамаәт чедири ичидики вәзиписи әң муқәддәс буюмларни башқуруш болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Баргаһ көчүрүлидиған чағда, Һарун билән униң оғуллири кирип «әң муқәддәс җай»дики «айрима пәрдә-йопуқ»ни чүшүрүп, униң билән һөкүм-гувалиқ сандуғини йөгисун; ");
INSERT INTO uigcyr_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","андин униң үстини делфинниң терисидин етилгән йопуқ билән орап, үстигә көк бир рәхтни йепип, андин көтиридиған балдақларни өткүзсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Тәқдим нан тизилған ширәгә көк бир рәхт селинип, үстигә легән, тәхсә, пиялә вә шарап һәдийәлирини чачидиған қәдәһләр тизип қоюлсун; ширәдиму «дайимий нан» тизилип туривәрсун;    ");
INSERT INTO uigcyr_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","бу нәрсиләрниң үсти қизил рәхт билән, униң үсти йәнә делфин терисидә етилгән бир йопуқ билән йепилип, андин көтиридиған балдақлар өткүзүп қоюлсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Улар көк рәхт елип, униң билән чирақдан билән үстидики чирақларни, пилик қисқучларни, күлданларни вә чирақданға ишлитидиған, барлиқ май қачилайдиған қачиларни йепип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Улар йәнә чирақдан билән чирақданға ишлитидиған һәммә қача-қуча әсвапларни делфин терисидин етилгән йопуқ билән йөгәп, андин әпкәшкә селип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Алтун хушбуйгаһқа көк бир рәхт селип, йәнә делфин терисидә етилгән йопуқ билән йепип, андин көтәргүчкә қош балдақларни өткүзүп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Муқәддәс җайниң ичидә ишлитидиған барлиқ қача-қучиларни көк бир рәхт билән йөгәп, андин үстигә делфин терисидә етилгән йопуқни йепип, андин бир әпкәшкә селип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Улар қурбангаһни күлидин тазилап, үстигә сөсүн рәңлик бир рәхтни йейип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Андин йәнә қурбангаһта ишлитилидиған әсваплар — күлдан, илмәк, бәлгүҗәк, чиниләр, шундақла барлиқ әсвапларни қурбангаһ үстигә тизип, андин делфин терисидә етилгән бир йопуқ билән йепип, андин көтиридиған балдақларни өткүзүп қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Пүтүн баргаһтикиләр йолға чиқидиған чағда, Һарун билән униң оғуллири муқәддәс җай вә муқәддәс җайдики барлиқ қача-қуча әсвапларни йепип болғандин кейин, Коһатниң әвлатлири келип көтәрсун; лекин өлүп кәтмәслик үчүн муқәддәс буюмларға қол тәккүзмисун. Җамаәт чедири ичидики нәрсиләрдин шуларни Коһатниң әвлатлири көтириши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Һарунниң оғли Әлиазарниң вәзиписи чирақ мейи, хушбуй әтир, дайимий тәқдим қилинидиған ашлиқ һәдийәси билән мәсиһләш мейиға қараш, шундақла пүткүл ибадәт чедири билән униң ичидики барлиқ нәрсиләр, муқәддәс җай һәм муқәддәс җайдики қача-қуча әсвапларға қараштин ибарәт. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Андин Пәрвәрдигар Муса билән Һарунға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Силәр Коһат җәмәтидикиләрни Лавийлар арисидин қәтъий йоқитип қоймаңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","бәлки уларниң өлмәй, һаят қелиши үчүн улар «әң муқәддәс» буюмларға йеқинлашқан чағда, Һарун билән униң оғуллири кирип уларниң һәр биригә қилидиған вә көтиридиған ишларни көрситип қойсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","улар пәқәт муқәддәс җайға киргәндә муқәддәс буюмларға бир дәқиқиму қаримисун, ундақ қилип қойса өлүп кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","23","Гәршон әвлатлири ичидә ата җәмәти вә аилилири бойичә, оттуз яштин әллик яшқичә болған, җамаәт чедири ичидә хизмәт қилиш сепигә кирәләйдиған һәммисини санақтин өткүзүп умумий санини ал. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Гәршон аилилириниң қилидиған хизмити вә улар көтиридиған нәрсиләр төвәндикичә: ");
INSERT INTO uigcyr_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","— улар җамаәт чедириниң өзини, йәни астидики ички пәрдилири вә сиртқи пәрдилирини, униң япқучини, шундақла үстигә япқан делфин терисидә етилгән йопуқни вә җамаәт чедириниң кириш ишигиниң пәрдисини, ");
INSERT INTO uigcyr_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ибадәт чедири билән қурбангаһни чөридәп тартилған һойлидики пәрдиләр билән кириш дәрвазисиниң пәрдисини, шуларға хас танилирини вә ишлитидиған барлиқ қача-қуча әсвапларни көтәрсун; бу әсвап-үскүниләргә мунасивәтлик керәк болған ишларни қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Гәршон әвлатлириниң пүтүн вәзиписи, йәни улар көтиридиған вә беҗиридиған барлиқ ишлар Һарун вә униң оғуллириниң көрсәтмилири бойичә болсун; уларниң немә көтиридиғанлиғини силәр бәлгүләп бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Гәршон әвлатлириниң җәмәтлириниң җамаәт чедириниң ичидә қилидиған хизмити шулар; улар каһин Һарунниң оғли Итамарниң қол астида туруп ишлисун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Мәрариниң әвлатлириниму, уларни ата җәмәти, аилилири бойичә, санақтин өткүз; ");
INSERT INTO uigcyr_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","оттуз яштин әллик яшқичә болған, җамаәт чедири ичидә хизмәт қилиш сепигә кирәләйдиған һәммисини санақтин өткүзүп умумий санини ал. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Уларниң җамаәт чедири ичидики барлиқ хизмити, йәни көтириш вәзиписи мундақ: — Улар җамаәт чедириниң тахтайлири, балдақлири, хадилири вә уларниң тәгликлири, ");
INSERT INTO uigcyr_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","һойлиниң төрт әтрапидики хадилар, уларниң тәгликлири, қозуқлири, таналири, барлиқ әсвап-үскүнә һәм шуларға керәклик болған барлиқ нәрсиләрни көтириш болсун; улар көтиридиған әсвап-үскүниләрни намини атап бир-бирләп һәр адәмгә көрситип бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Мәрари җәмәт-аилилириниң җамаәт чедири ичидә қилидиған барлиқ ишлири әнә шулар; улар каһин Һарунниң оғли Итамарниң қол астида туруп ишлисун. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","35","Муса билән Һарун вә җамаәтниң әмирлири Коһатниң әвлатлириниң оттуз яштин әллик яшқичә болған, җамаәт чедирида хизмәт қилиш сепигә кирәләйдиғанларниң һәммисини ата җәмәти, аилилири бойичә санақтин өткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Улардин җәмәти бойичә санақтин өткүзүлгәнләр җәмий икки миң йәттә йүз әллик киши болуп чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Мошулар Коһат җәмәтидин санақтин өткүзүлгәнләр болуп, җамаәт чедирида иш қилидиған һәр бири, йәни Пәрвәрдигарниң Мусаниң вастиси билән қилған әмри бойичә Муса билән Һарун санақтин өткүзгәнләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","39","Гәршонларниң ата җәмәти, аилилири бойичә, оттуз яштин әллик яшқичә болған, җамаәт чедирида хизмәт қилиш сепигә кирәләйдиған һәммиси санақтин өткүзүлди; ");
INSERT INTO uigcyr_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ата җәмәти, аилилири бойичә санақтин өткүзүлгәнләр җәмий икки миң алтә йүз оттуз киши болуп чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Мошулар Гәршон җәмәтидин санақтин өткүзүлгәнләр болуп, җамаәт чедирида иш қилидиған һәр бири, йәни Пәрвәрдигарниң Мусаниң вастиси билән қилған әмри бойичә Муса билән Һарун санақтин өткүзгәнләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","43","Мәрариларниң ата җәмәти, аилилири бойичә, оттуз яштин әллик яшқичә болған, җамаәт чедирида хизмәт қилиш сепигә кирәләйдиған һәммиси санақтин өткүзүлди; ");
INSERT INTO uigcyr_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ата җәмәти, аилилири бойичә санақтин өткүзүлгәнләр җәмий үч миң икки йүз киши болуп чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Мошулар Мәрари җәмәтидин санақтин өткүзүлгәнләр болуп, җамаәт чедирида иш қилидиған һәр бири, йәни Пәрвәрдигарниң Мусаниң вастиси билән қилған әмри бойичә Муса билән Һарун санақтин өткүзгәнләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","47","Санақтин өткүзүлгән Лавийлар мана шулар еди; Муса билән Һарун һәм Исраилларниң әмирлири улардин ата җәмәти, аилилири бойичә, оттуз яштин әллик яшқичә болған, җамаәт чедирида хизмәт қилиш вә жүк күтүрүш вәзиписигә кирәләйдиғанларни санақтин өткүзгән. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Уларниң сани җәмий сәккиз миң бәш йүз сәксән адәм болуп чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Пәрвәрдигарниң әмри бойичә, улар Муса тәрипидин санақтин өткүзүлди; һәр ким өзи қилидиған Иши вә көтиридиған жүкигә асасән санақтин өткүзүлди. Буларниң һәммиси Пәрвәрдигарниң Мусаға әмир қилғинидәк болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","3","Сән Исраилларға әмир қилип: «Силәр писә-мохо кесили билән ақма кесилигә гириптар болғанларни, шундақла өлүккә тегиши билән напак болуп қалған һәммисини әр-аял демәй баргаһтин чиқириветиңлар. Баргаһларни булғивәтмәслиги үчүн уларни баргаһтин чиқириветиңлар; чүнки Мән баргаһ оттурисида макан қилдим» — дегин, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Исраиллар шундақ қилип уларни баргаһтин чиқиривәтти; Пәрвәрдигар Мусаға қандақ әмир қилған болса, Исраиллар шундақ қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Сән Исраилларға ейтқин: — Мәйли әр яки аял болсун, әгәр у инсанларниң Пәрвәрдигарға вапасизлиқ қилидиған һәр қандақ гуналиридин бирини садир қилип, шуниң билән гунакар дәп бекитилсә, ");
INSERT INTO uigcyr_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ундақта у өзи өткүзгән гунайиға иқрар қилип, итаәтсизлиги кәлтүрүп чиқарған, зиянланғучиниң зийинини толуқ төләп бериши керәк вә униң сиртида у кишигә йәнә бәштин бир үлүшни қошуп төләп бәрсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Зиянланғучиниң мабада итаәтсизлик кәлтүрүп чиқарған зиянға берилгән төләм пулини алғидәк туққини болмиса, төләм пули гунакар болған кишиниң кафаритигә сунулидиған қошқарға қошулуп, Пәрвәрдигарға атилип, каһинға берилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Шуниңдәк Исраилларниң Худаға атиған барлиқ муқәддәс һәдийәлири, йәни каһинға кәлтүргән нәрсиләрдин барлиқ «көтәрмә қурбанлиқ-һәдийә»ләр каһинға һесап болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Һәр ким Худаға атиған һәдийәләр муқәддәс дәп һесаплансун, шундақла каһинниң болсун; кишиләр каһинға немә һәдийә қилса, униң һәммиси каһинниң болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Сән Исраилларға сөз қилип мундақ дегин: — Әгәр бирисиниң хотуни өз еридин йүз өрүгән, садақәтсизлик қилған болса, ");
INSERT INTO uigcyr_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","— демәк, башқа бириси билән йеқинлашқан, шундақла униң булғанғанлиғи ериниң көзлиридин йошурун болған болса, һеч гувачи болмиған һәм гуна қилған чеғида тутулупму қалмиған болса, ");
INSERT INTO uigcyr_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","шундақ әһвалда, ери өз хотунидин гуман қилип күнлисә, хотуни растла зина қилип булғанған болса (яки өз хотуниға гуман қилип күнлисиму, хотуни зина қилмиған вә булғанмиған болса) ");
INSERT INTO uigcyr_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","әһвалини испатлаш үчүн бу адәм хотунини каһинниң йениға әкәлсун һәм хотуни үчүн зөрүр ашлиқ һәдийәси, йәни арпа ундин ондин бир әфаһни алғач кәлсун; шу һәдийәниң үстигә у һеч зәйтун мейи қуймисун яки һеч мәстики қошуп қоймисун; чүнки бу күндашлиқ һәдийәси, әсләтмә ашлиқ һәдийәси болуп, уларниң қәбиһлигигә болған әсләтмидур. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Каһин у хотунни алдиға кәлтүрүп, Пәрвәрдигарниң һозурида турғузсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Каһин комзәккә муқәддәс судин қуюп, ибадәт чедириниң йәр тописидин бир чимдим елип суға чечип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Каһин у хотунни Пәрвәрдигарниң һозурида турғузуп, бешини ечип, әсләтмә ашлиқ һәдийәси, йәни күндашлиқ һәдийәсини униң қолиға тутқузсун, андин каһин қолиға қарғиш кәлтүргүчи әләм сүйини алсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Каһин у хотунға қәсәм ичкүзүп, униңға «Дәрвәқә сән һеч қандақ адәм билән биллә ятмиған, ериңниң орнида башқа бириси билән биллә болушқа езип бузуқлуқ қилмиған болсаң, ундақта сән бу қарғиш кәлтүргүчи әләм сүйидин халас болғайсән. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Лекин сән ериңниң орнида башқа бирисигә йеқинлишип өзүңни булғиған болсаң, ериңдин башқа бир әр сән билән биллә ятқан болса, —» десун; ");
INSERT INTO uigcyr_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","22","андин каһин у хотунға қарғиш қәсимини ичкүзгәндин кейин, йәнә униңға: «— Пәрвәрдигар янпашңни йиглитип, қосиғиңни ишшитивәтсун, шуниңдәк Пәрвәрдигар сени өз хәлқиң ичидә қарғиш вә қәсәм ичиш дәстикигә айландурсун; бу қарғиш сүйи ич-қарниңға кирип, қосиғиңни ишшитивәтсун, янпашңни йиглитивәтсун» дегәндә, у хотун: «Амин, амин» десун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Шуниңдәк каһин бу қарғиш сөзлирини дәптәргә пүтүп қойсун, шундақла язған сөзләрни әләм сүйигә чилисун, ");
INSERT INTO uigcyr_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","андин у хотунға бу қарғиш кәлтүргүчи әләм сүйини ичкүзсун, бу қарғиш кәлтүргүчи су униң ичигә кириши биләнла униңға азап-әләм болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Каһин у хотунниң қолидин күндашлиқ ашлиқ һәдийәсини елип, уни Пәрвәрдигарниң һозурида пулаңлитип болғандин кейин, қурбангаһқа елип кәлсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Каһин һәдийәдин бир сиқим ун елип, хатирә һесавида қурбангаһқа қоюп көйдүрсун; андин у хотунға бу суни ичкүзсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Каһин әнди у хотунға суни ичкүзгәндин кейин, әгәр у һәқиқий булғанған болуп, өз еригә садақәтсизлик қилған болса, чоқум шундақ болидуки, бу қарғиш сүйи униң ичигә киргәндин кейин униңға азап-әләм кәлтүриду; униң қосиғи ишшип, янпиши йигиләп кетиду; шуниң билән у хотун өз хәлқи ичидә қарғишқа кетиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Лекин әгәр у хотун булғанмиған пак болса, шу иштин халас болиду вә әксичә һамилдар болуп пәрзәнтлик болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Мана бу күндашлиқ тоғрисидики қанундур; хотун өз ериниң орнида башқа бириси билән биллә болуши билән езип булғанған болса ");
INSERT INTO uigcyr_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","вә яки бириси хотунидин гуман қилип күнлисә, ундақта у хотунини Пәрвәрдигарниң алдида турғузсун, каһин униңға шу қанун бойичә һәммини иҗра қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Әнә шундақ қилғанда, әр гунадин халас болуп, хотун өз гунайини көтириду. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Сән Исраилларға ейтқин: «Мәйли әр яки аял болсун, «Өзүмни Пәрвәрдигарға атап, назарийлардин болимән» дегән алаһидә бир қәсәмни ичкән болса, ");
INSERT INTO uigcyr_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ундақта у өзини һарақ-шараптин айрип пәрһиз тутсун; һарақ-шарап билән ишләнгән сиркиниму ичмисун яки һәр қандақ үзүм шәрбитини ичмисун вә һөл-қуруқ үзүмләрниму йемисун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Өзини Пәрвәрдигарға атиған барлиқ күнләрдә, үзүм телидин чиққан һәр қандақ нәрсини, мәйли үзүм уруғи болсун, шакили болсун, уларни йейишкә болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Өзүмни Пәрвәрдигарға атидим дәп қәсәм қилған күнлиридә, уларниң бешиға устира тәккүзүшкә болмайду; өзини Пәрвәрдигарға атиған күнләр өтүп болмиғичә, у муқәддәс болуши керәк; улар чачлирини узун қоюши керәк.    ");
INSERT INTO uigcyr_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","У қәсәм ичкән барлиқ күнлиридә һеч қандақ өлүкләргә йеқинлишишқа болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Униң өз атиси, аниси, қериндиши яки һәдә-сиңиллири өлүп қалған болса, уларни дәп өзини напак қилмаслиғи керәк; чүнки бешида Пәрвәрдигарғила хас болимән дәп бәргән вәдисиниң бәлгүси болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Өзини Худаға ативәткән барлиқ күнләрдә у Пәрвәрдигар алдида муқәддәс болуп турсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Мабада бир киши униң йенида туюқсиз өлүп қелип, өзини Пәрвәрдигарға атиғанлиқниң бәлгүси болған беши булғанған болса, у өзини паклаш күни вә кейинки йәттинчи күниму чечини алдурсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Сәккизинчи күни у икки пахтәкни яки икки бачкини елип җамаәт чедириниң дәрвазиси алдида каһинға тапшурсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Каһин бирини гуна қурбанлиғи, йәнә бирини көйдүрмә қурбанлиқ сүпитидә сунуп, өлүк сәвәвидин напак болуп қалған гунайини тиләп кәфарәт қилсун; назарий шу күнниң өзидә өз бешини қайтидин муқәддәс-пак қилсун, ");
INSERT INTO uigcyr_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","у өзини Пәрвәрдигарға атиған күнлирини яңливаштин башлисун, шуниң билән бир яшлиқ бир әркәк қозини итаәтсизлик қурбанлиғи қилип сунсун; илгәрки күнлири болса инавәтсиз һесаплансун; чүнки униң өзини Пәрвәрдигарға атиған һалити булғанған. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Назарийлардин бири өзини Пәрвәрдигарғила атиған күнләр тошқан күнидә у тоғрилиқ қанун-бәлгүлимә мундақ: — Кишиләр уни җамаәт чедириниң дәрвазиси алдиға әкәлсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","у өзи Пәрвәрдигарға сунулидиған көйдүрмә қурбанлиқ үчүн бир яшлиқ беҗирим әркәк қозини, гуна қурбанлиғи үчүн бир яшлиқ чиши беҗирим бир қозини, енақлиқ қурбанлиғи үчүн беҗирим бир қошқарни кәлтүрсун, ");
INSERT INTO uigcyr_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","шундақла бир севәт петир нан, зәйтун мейи иләштүрүлгән есил ундин пиширилған тоғачлар һәмдә зәйтун мейи сүрүлүп мәсиһләнгән петир һәмәк нанлар вә шу қурбанлиқларниң қошумчә ашлиқ һәдийәлири вә шарап һәдийәлирини кәлтүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Каһин буларни Пәрвәрдигарниң һозуриға кәлтүрүп, Назарийниң шу гуна қурбанлиғи билән көйдүрмә қурбанлиғини сунсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","у Пәрвәрдигарға аталған енақлиқ қурбанлиғи сүпитидә қошқарни сунсун, униңға қошуп бир севәт петир нанни сунсун; каһин шулар билән тәң Назарий қошуп тәқдим қилған ашлиқ һәдийәси билән шарап һәдийәсини кәлтүрүп сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Назарий җамаәт чедириниң дәрвазиси алдида өзини Пәрвәрдигарға атиғанлиғиға бәлгү қилип қоювәткән чечини чүшүрүп, чечини елип енақлиқ қурбанлиғи астидики отқа қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Назарий шу тәриқидә өзини Пәрвәрдигарғила атиғанлиқ чечини чүшүрүп болғандин кейин, каһин қайнап пиширилған қошқарниң бир алди қолини һәм севәттин бир петир нан билән бир петир һәмәк нанни елип келип Назарийниң қолиға тутқузсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Каһин буларни Пәрвәрдигарниң алдида пулаңлатма қурбанлиқ сүпитидә өрүсун; булар пулаңлатма қурбанлиқ сүпитидә сунған төш билән көтәрмә һәдийә қилинған алди қол билән қошулуп, муқәддәс дәп һесаплинип каһинға берилсун; андин кейин Назарий шарап ичсә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Шулар болса қәсәм ичкән Назарий тоғрисида, өзини Пәрвәрдигарға аташта сунуш зөрүр болған қурбанлиқ-һәдийәләр тоғрисида бекитилгән қанун-бәлгүлимидур; шуниңдәк униң қоли немигә йәтсә шуни сунсиму болиду; у ичкән қәсими бойичә, йәни өзини Худаға аташ вәдиси тоғрилиқ шу низам-бәлгүлимә бойичә һәммә ишни ада қилсун; вәдисигә әмәл қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Сән Һарун билән униң оғуллириға сөз қилип мундақ дегин: — Силәр Исраилларға мундақ бәхит-бәрикәт тиләңлар: — ");
INSERT INTO uigcyr_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«Пәрвәрдигар силәргә бәхит-бәрикәт ата қилғай, силәрни Өз панаһида сақлиғай; ");
INSERT INTO uigcyr_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Пәрвәрдигар йүзини силәрниң үстүңларда йорутуп, силәргә шапаәт қилғай; ");
INSERT INTO uigcyr_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Пәрвәрдигар йүзини үстүңларға қаритип көтирип, силәргә хатирҗәмлик бәргәй!» — дәп тиләңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Улар шундақ қилип намимни Исраилларниң үстигә қондуриду вә Мән уларға бәхит-бәрикәт ата қилимән. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","2","Муса ибадәт чедирини тиклигән күни, у чедирни мәсиһ қилип майлап муқәддәс қилди, шундақла униң ичидики барлиқ әсвап-җабдуқлар, қурбангаһ вә униң барлиқ қача-қуча әсваплирини мәсиһ қилип майлап муқәддәс қилди; шү күни шундақ болдики, Исраилниң әмирлири, йәни уларниң ата җәмәтиниң башлиқлири болған, қәбилә әмирлири келип һәдийәләрни сунди; шу қәбилиләрниң әмирлири санақтин өткүзүш ишиға назарәт қилғучилар еди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Улар өзлириниң һәдийәлирини Пәрвәрдигарниң һозуриға һазир қилишти, кәлтүрүлгән бу һәдийәләр җәмий болуп алтә һарву, он икки өкүздин ибарәт еди; һәр икки әмир бирлишип бирдин сайивәнлик һарву, һәр бир әмир бирдин өкүз елип кәлди; улар бу һәдийәләрни чедириниң алдиға әкилишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Җамаәт чедириниң ишлириға ишлитиш үчүн сән бу нәрсиләрни қобул қилип, Лавийларниң һәр бириниң беҗиридиған ишлири бойичә уларниң ишлитишигә бәргин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Шуниң билән Муса һарву билән өкүзләрни қобул қилип Лавийларға тапшуруп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","У Гәршон әвлатлириниң қилидиған ишлириға асасән, уларға икки һарву билән төрт өкүз бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Мәрари әвлатлириниң қилидиған ишлириға асасән, уларға төрт һарву билән сәккиз өкүз бәрди; уларниң һәммиси каһин Һарунниң оғли Итамарға қарайтти; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","лекин у Коһатниң әвлатлириға һеч немә бәрмиди; чүнки улар муқәддәс нәрсиләрни көтиришкә мәсъул еди; демәк, улар мәсъул болған нәрсиләрни өз мүрисидә көтирәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Қурбангаһ майлинип мәсиһләнгән күни, уни Худаға беғишлаш йолида әмирләр сунидиған һәдийәлирини елип келип, қурбангаһ алдиға қоюшти. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Пәрвәрдигар Мусаға: — Улар қурбангаһни беғишлаш йолида һәдийәлирини сунсун; һәр бир әмир өз күнидә сунсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Биринчи күни һәдийә сунғучи Йәһуда қәбилисидин Амминадабниң оғли Наһшон болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","көйдүрмә қурбанлиқ үчүн бир әркәк топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Амминадабниң оғли Наһшон сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Иккинчи күни һәдийә сунғучи Иссакарниң әмри Зуарниң оғли Нәтанәл болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Зуарниң оғли Нәтанәл сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Үчинчи күни һәдийә сунғучи Зәбулун әвлатлириниң әмри Һелонниң оғли Елиаб болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Һелонниң оғли Елиаб сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Төртинчи күни һәдийә сунғучи Рубән әвлатлириниң әмри Шидөрниң оғли Әлизур болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Шидөрниң оғли Әлизур сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Бәшинчи күни һәдийә сунғучи Шимеон әвлатлириниң әмри Зури-шаддайниң оғли Шелумийәл болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Зури-шаддайниң оғли Шелумийәл сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Алтинчи күни һәдийә сунғучи Гад әвлатлириниң әмри Деуәлниң оғли Әлиасаф болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Деуәлниң оғли Әлиасаф сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Йәттинчи күни һәдийә сунғучи Әфраим әвлатлириниң әмри Аммиһудниң оғли Әлишама болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Аммиһудниң оғли Әлишама сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Сәккизинчи күни һәдийә сунғучи Манассәһ әвлатлириниң әмри Пидаһзурниң оғли Гамалийәл болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Пидаһзурниң оғли Гамалийәл сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Тоққузинчи күни һәдийә сунғучи Бенямин әвлатлириниң әмри Гидеониниң оғли Абидан болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Гидеониниң оғли Абидан сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Онинчи күни һәдийә сунғучи Дан әвлатлириниң әмри Аммишаддайниң оғли Аһиезәр болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Аммишаддайниң оғли Аһиезәр сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Он биринчи күни һәдийә сунғучи Ашир әвлатлириниң әмри Окранниң оғли Пагийәл болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Окранниң оғли Пагийәл сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Он иккинчи күни һәдийә сунғучи Нафтали әвлатлириниң әмри Енанниң оғли Аһира болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","У сунған һәдийә еғирлиғи бир йүз оттуз шәкәл келидиған бир күмүч легән, еғирлиғи йәтмиш шәкәл келидиған бир күмүч дас болуп, булар муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнди; ашлиқ һәдийәси болсун дәп иккисигә зәйтун мейи арилаштурулған есил ун толдурулған еди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","он шәкәл еғирлиқта, хушбуй толдурулған бир алтун пиялә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","көйдүрмә қурбанлиқ үчүн бир топақ, бир қочқар, бир яшлиқ бир әркәк қоза; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","гуна қурбанлиғи үчүн бир текә; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","енақлиқ қурбанлиғи үчүн икки буқа, бәш қочқар, бәш текә, бир яшлиқ бәш әркәк қоза; булар Енанниң оғли Аһира сунған һәдийәләр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Қурбангаһ майлинип мәсиһләнгән күнидә, Исраил әмирлири қурбангаһқа сунған һәдийәләр: — җәмий он икки күмүч легән, он икки күмүч дас, он икки алтун пиялә болди, ");
INSERT INTO uigcyr_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","һәр бир күмүч легәнниң еғирлиғи бир йүз оттуз шәкәл, һәр бир күмүч дасниң еғирлиғи йәтмиш шәкәл еди; мошу қача-қучиға кәткән күмүч муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнгәндә, җәмий икки миң төрт йүз шәкәл чиқти; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","хушбуй билән толдурулған алтун пиялә он икки болуп, муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә өлчәнгәндә, һәр бир алтун пиялиниң еғирлиғи он шәкәл чиқти; бу алтун пиялиләрниң алтуни җәмий бир йүз жигирмә шәкәл чиқти; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","көйдүрмә қурбанлиқлар үчүн болған маллар: — җәмий он икки топақ, он икки қочқар, он икки бир яшлиқ әркәк қоза еди, һәр бири тегишлик ашлиқ һәдийәлири билән биллә сунулди; он икки текә гуна қурбанлиғи үчүн сунулди; ");
INSERT INTO uigcyr_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","енақлиқ қурбанлиқлири үчүн сунулғини җәмий жигирмә төрт буқа, атмиш қочқар, атмиш текә, бир яшлиқ атмиш әркәк қоза еди. Қурбангаһ майлинип мәсиһлинип, уни Худаға беғишлаш йолида сунулған һәдийәләр мана мошулар. ");
INSERT INTO uigcyr_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Муса Пәрвәрдигар билән сөзләшкили җамаәт чедириға киргән чеғида, у «һөкүм-гувалиқ сандуғи»ниң үстидики «кәфарәт тәхти»ниң икки тәрипидики керубниң оттурисидин униң өзигә гәп қилған авазини аңлап турди; Пәрвәрдигар шу йолда униңға сөз қилатти. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Сән Һарунға: «Сән чирақлар яқидиған чағда йәттә чирақниң һәммиси чирақданниң алдини йорутидиған болсун» дәп ейтип қой, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Һарун шундақ қилди; у чирақдан үстидики чирақларниң һәммисини яндуруп, худди Пәрвәрдигарниң Мусаға ейтқинидәк, чирақ нурини чирақданниң алдини йорутидиған қилип қойди. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Чирақданниң ясилиши мундақ: у алтундин болқа билән соқуп ясалған, путидин гүллиригичә болқа билән соқуп чиқирилған. Пәрвәрдигар Мусаға көрсәткән нусхидәк, у чирақданни шундақ ясатти. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Сән Исраилларниң ичидин Лавийларни таллап чиқип паклиғин. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Уларни паклаш үчүн уларға мундақ қил: «кәфарәт сүйи»ни уларниң бәдинигә чачқин; андин улар өзлири пүтүн бәдинини устура билән чүшүрсун, кийимлирини жуюп өзини пак қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Андин кейин улар бир топақ билән шуниңға қошуп ашлиқ һәдийәсини, йәни зәйтун мейи иләштүрүлгән есил унни кәлтүрсун; сән гуна қурбанлиғи үчүн йәнә бир топақни кәлтүр. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Сән Лавийларни җамаәт чедириниң алдиға кәлтүр вә пүтүн Исраил җамаитини жиғип кәл; ");
INSERT INTO uigcyr_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Лавийларни Пәрвәрдигарниң һозуриға һазир қилғин; андин Исраиллар келип қоллирини уларниң үстигә қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Һарун Лавийларни Исраилларниң «пулаңлатма қурбанлиқ»и сүпитидә Пәрвәрдигарниң хизмитини қилсун дәп, Пәрвәрдигарға һәдийә қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Лавийлар қоллирини һелиқи икки топақниң бешиға қойсун; сән бирини гуна қурбанлиғи болсун, бирини көйдүрмә қурбанлиқ болсун, Лавийлар үчүн кәфарәт кәлтүрсун дәп Пәрвәрдигарға сунғин. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Сән андин Лавийларни Һарун билән униң оғуллириниң алдида турғузуп, уларни пулаңлатма қурбанлиқ сүпитидә Пәрвәрдигарға һәдийә қил. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Лавийлар Мениңки болсун дәп, сән Лавийларни әнә шу тәриқидә Исраиллардин айрип чиқ. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Андин Лавийлар кирип җамаәт чедириниң ишлирини қилса болиду; сән уларни пакландур, уларни пулаңлатма қурбанлиқ сүпитидә һәдийә қил. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Чүнки улар Исраиллар ичидә пүтүнләй Маңа аталған; Мениң уларни Мениңки болсун дәп таллишим уларни Исраилларниң арисида балиятқуниң тунҗа мевиси орнида қойғанлиғимдур. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Чүнки Исраилларниң тунҗиси, мәйли у инсан яки һайван болсун, пүтүнләй Маңа тәвәдур; Мән Мисир зиминида барлиқ тунҗиларни өлтүргән күни уларни Өзүмгә муқәддәс қилип еливалған едим. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Мениң Лавийларни у йол билән таллишим уларни Исраилларниң ичидики тунҗилириниң орнида қоюшум үчүндур. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Вә җамаәт чедирида Исраилларниң хизмитидә болсун вә Исраилларниң гунайини тиләп кәфарәт кәлтүрсун, шуниңдәк Исраиллар муқәддәс җайға йеқинлашқанда улар арисида бала-қаза чиқмисун дәп, Мән Исраиллар ичидин Лавийларни Һарун билән униң оғуллириға бәрдим». ");
INSERT INTO uigcyr_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Муса, Һарун вә пүткүл Исраил җамаити Лавийларни шундақ қилди; Пәрвәрдигарниң Лавийлар тоғрилиқ Мусаға буйруғинидәк Исраиллар һәммисини беҗа кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Лавийлар шундақ қилип өзлирини гунадин паклап, кийим-кечәклирини жуюп пакизлиди; Һарун уларни пулаңлатма қурбанлиқ сүпитидә Пәрвәрдигарға һәдийә қилди; Һарун йәнә уларни паклашқа гунайини тиләп кәфарәт қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Андин кейин Лавийлар кирип Һарунниң алдида, шундақла униң оғуллириниң алдида, җамаәт чедири ичидики ишларни қилишқа киришти; Пәрвәрдигар Лавийлар тоғрилиқ Мусаға қандақ буйруған болса, Исраиллар уни шу бойичә беҗа кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Лавийларниң вәзиписи мундақ болсун: — Жигирмә бәш яштин жуқурилири кирип җамаәт чедири ичидики ишларни қилишқа сәпкә кирсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","әллик яшқа йәткәндин кейин сәптин чекинип шу хизмәтни қилмисун; ");
INSERT INTO uigcyr_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","лекин улар җамаәт чедири ичидә қериндашлириға ярдәмлишип, уларниң һаҗәтлиридин чиқишқа болиду, амма чедирдики рәсмий вәзипидә болмисун. Лавийларниң вәзипилири һәққидә уларға әнә шундақ қил». ");
INSERT INTO uigcyr_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Мисир зиминидин чиққандин кейинки иккинчи жили биринчи айда, Пәрвәрдигар Синай чөлидә Мусаға буйруп: — ");
INSERT INTO uigcyr_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Исраиллар бекитилгән вақитта өтүп кетиш һейтини өткүзсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","йәни мошу айниң он төртинчи күни гугумда, бекитилгән вақитта, барлиқ бәлгүлимә вә қаидә-тәртип бойичә һейтни өткүзүңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Шуниң билән Муса Исраилларға сөз қилип өтүп кетиш һейтини өткүзүшни буйруди. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Улар биринчи айниң он төртинчи күни гугумда, Синай чөлидә өтүп кетиш һейтини өткүзди; Пәрвәрдигар Мусаға қандақ буйруған болса, Исраиллар шундақ қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Бир нәччәйлән бир өлүккә тегип кетип напак болуп қалғанлиғи үчүн, улар шу күни өтүп кетиш һейтини өткүзәлмиди-дә, улар шу күни Муса билән Һарунниң алдиға келип Мусаға: — ");
INSERT INTO uigcyr_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Биз өлүп қалған адәмгә тегип кетип напак болуп қалған болсақму, лекин немишкә Исраилларниң қатарида, бекитилгән вақитта Пәрвәрдигарға сунушқа керәк болғинини елип келиштин рәт қилинимиз? — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","— Тохтап туруңлар, мән берип Пәрвәрдигар силәр тоғраңларда немә буйруйдикин, аңлап бақай, — деди Муса уларға. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Сән Исраилларға мундақ дегин: «Силәр вә силәрниң әвлатлириңлар ичидә бәзиләр өлүкләргә тегип кетип напак болуп қалған болса яки узақ сәпәр үстидә болса, улар йәнила Пәрвәрдигар үчүн өтүп кетиш һейтини өткүзүшкә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ундақ кишиләр иккинчи айниң он төртинчи күни гугумда һейтни өткүзсун; һейт таамини петир нан вә аччиқ көктатлар билән биллә йесун; ");
INSERT INTO uigcyr_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","улардин әтигә азрақму қалдурмисун вә қозисиниң устиханлиридин бирәрсиниму сундурғучи болмисун; улар һейтни өтүп кетиш һейтиниң барлиқ бәлгүлимилири бойичә өткүзсун.    ");
INSERT INTO uigcyr_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Һалбуки, пак болған, сәпәр үстидиму болмиған амма өтүп кетиш һейтини өткүзүшкә етивар бәрмигән киши болса өз хәлқидин үзүп ташлиниду; чүнки бекитилгән вақитта Пәрвәрдигарға сунуш керәк болғинини сунмиғанлиғи үчүн, у өз гунайини өз үстигә алиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Әгәр араңларда туруватқан ят әллик бир мусапир Пәрвәрдигар үчүн өтүп кетиш һейтини өткүзүшни халиса, у өтүп кетиш һейти тоғрисидики бәлгүлимә вә қаидә-тәртип бойичә өткүзсун; ят әллик мусапирлар үчүн вә зиминда туғулғанлар үчүнму араңларда шу бирла низам болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ибадәт чедири тикләнгән күни, булут ибадәт чедирини, йәни һөкүм-гувалиқ чедирини қаплап турди; кәчтин таки әтигәнгичә, булут худди оттәк ибадәт чедириниң үстидә турди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Дайим шундақ болатти; күндүзи булут ибадәт чедирини қаплап туратти, кечиси у отқа охшайтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Қачаники булут җамаәт чедириниң үстидин көтирилсә, Исраиллар йолға чиқатти; булут қәйәрдә тохтиса, Исраиллар шу йәрдә баргаһ тикәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Исраиллар Пәрвәрдигарниң буйруғи бойичә маңатти, Пәрвәрдигарниң буйруғи бойичә баргаһ тикәтти; булут ибадәт чедириниң үстидә қанчә узақ тохтиса, улар баргаһта шунчә узақ туратти. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Булут ибадәт чедириниң үстидә хелә күнләргичә тохтап турса, Исраилларму Пәрвәрдигарниң көрситмисини тутуп сәпәргә чиқмайтти; ");
INSERT INTO uigcyr_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","мабада булут ибадәт чедириниң үстидә пәқәт бир нәччә күнла тохтиса, улар Пәрвәрдигарниң буйруғи бойичә шу вақитта баргаһ қуруп ятатти, андин йәнә Пәрвәрдигарниң буйруғи бойичә сәпәргә атлинатти. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Вә мабада булут пәқәтла кәчтин әтигәнгичә тохтап, әттигәндә булут йәнә көтирилсә, улар йәнә йолға чиқатти; мәйли күндүзи яки кечиси булут көтирилсила, улар сәпәргә чиқатти. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Булут ибадәт чедириниң үстидә узунрақ турса, мәйли икки күн, бир ай, бир жил турсиму, Исраиллар йолға чиқмай баргаһта туруверәтти; лекин булут көтирилип маңсила улар сәпирини давамлаштуратти. ");
INSERT INTO uigcyr_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Пәрвәрдигарниң буйруғи билән улар баргаһ қуратти, Пәрвәрдигарниң буйруғи билән улар сәпәрни давамлаштуратти; улар Пәрвәрдигарниң Мусаниң вастиси билән бәргән әмри бойичә, Пәрвәрдигарниң көрситмисини тутатти. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Сән өзүңгә икки канай ясатқин; уларни күмүчтин соқтур. Улар җамаәтни жиғишқа, шундақла җамаәтни баргаһлирини жиғиштуруп йолға чиқишқа чақириш үчүн ишлитилиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Икки канай челинғанда пүткүл җамаәт сениң йениңға җамаәт чедири дәрвазисиниң алдиға жиғилидиған болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Әгәр ялғуз бири челинса, әмирлири, йәни миңлиған Исраилларниң миң бешилири сениң йениңға келип жиғилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Силәр қаттиқ жуқури аваз билән чалғанда күн чиқиш тәрәптики баргаһлар йолға чиқсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Андин силәр иккинчи қетим қаттиқ, жуқури аваз билән чалғанда җәнуп тәрәптики баргаһлар йолға чиқсун; улар йолға чиққан чағда канай қаттиқ, жуқури аваз билән челиниши керәктур. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Җамаәтни жиғилишқа чақиридиған чағда, канай челиңлар, амма қаттиқ, жуқури аваз билән чалмаңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Һарунниң әвлатлири, каһин болғанлар канайларни чалсун; булар силәргә әвлатму-әвлат бир әбәдий бәлгүлимә болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Әгәр силәр өз зиминиңларда силәргә зулум салған дүшминиңлар билән җәң қилишқа чиқсаңлар, қаттиқ, жуқури аваз билән челиңлар. Шуниң билән өзүңларниң Худаси болған Пәрвәрдигарниң алдида яд етилип, дүшминиңлардин қутулисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Буниңдин башқа, хошал күнлириңларда, бекитилгән һейтлириңларда вә айниң биринчи күнлиридә, силәр көйдүрмә қурбанлиқ вә енақлиқ қурбанлиқлирини сунғиниңларда, қурбанлиқларниң алдида туруп канай челиңлар; шуниң билән канайлар силәрни Худайиңларға әсләткүчи болиду; Мән Худайиңлар Пәрвәрдигардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Иккинчи жили, иккинчи айниң жигирминчи күни булут һөкүм-гувалиқ чедириниң үстидин көтирилди; ");
INSERT INTO uigcyr_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","шуниң билән Исраиллар Синай чөлидин чиқип, йол елип сәпәрлирини башлиди; булут Паран чөлидә тохтиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Бу уларниң биринчи қетим Пәрвәрдигарниң Мусаниң вастиси билән қилған әмри бойичә йолға чиқиши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Йәһуда баргаһи өзиниң туғи астида қошун-қошун болуп алди билән йолға чиқти; қошунниң башлиғи Амминадабниң оғли Наһшон еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Иссакар қәбилиси қошуниниң башлиғи Зуарниң оғли Нәтанәл еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Зәбулун қәбилиси қошуниниң башлиғи Һелонниң оғли Елиаб еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Андин ибадәт чедири чувулуп, Гәршонниң әвлатлири билән Мәрариниң әвлатлири уни көтирип йолға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Рубән баргаһи өзиниң туғи астида қошун-қошун болуп йолға чиқти; қошунниң башлиғи Шидөрниң оғли Әлизур еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Шимеон қәбилиси қошуниниң башлиғи Зури-шаддайниң оғли Шелумийәл еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Гад қәбилиси қошуниниң башлиғи Деуәлниң оғли Әлиасаф еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Андин Коһатлар муқәддәс буюмларни көтирип йолға чиқти; улар йетип келиштин бурун ибадәт чедирини көтәргүчиләр келип уни тикләп қоюшқан еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Әфраим баргаһи өзиниң туғи астида қошун-қошун болуп йолға чиқти; қошунниң башлиғи Аммиһудниң оғли Әлишама еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Манассәһ қәбилиси қошуниниң башлиғи Пидаһзурниң оғли Гамалийәл еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Бинямин қәбилиси қошуниниң башлиғи Гидеониниң оғли Абидан еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Дан баргаһи һәммә баргаһларниң арқа муһапизәтчиси болуп, өзиниң туғи астида қошун-қошун болуп йолға чиқти; қошунниң башлиғи Аммишаддайниң оғли Аһиезәр еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ашир қәбилиси қошуниниң башлиғи Окранниң оғли Пагийәл еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Нафтали қәбилиси қошуниниң башлиғи Енанниң оғли Аһира еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Булар Исраиллар йолға чиққанда қошун-қошун болуп меңиш тәртиви еди; улар шу тәриқидә йолға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Муса өзиниң қейинатиси, Мидиянлиқ Реуәлниң оғли Һобабқа: — Биз Пәрвәрдигар вәдә қилған йәргә қарап сәпәр қиливатимиз, У: «Мән у йәрни силәргә мирас қилип беримән» дегән; өзлириниң биз билән биллә меңишлирини өтүнимән, биз силигә яхши қараймиз, чүнки Пәрвәрдигар Исраил тоғрилиқ бәхит-саадәт ата қилимән дәп вәдә бәргән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Лекин Һобаб Мусаға: — Яқ, мән өз жутум, өз уруқ-туққанлиримға кетимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Муса униңға: Биздин айрилип кәтмисилә; чүнки сили чөлдә қандақ баргаһ қурушимиз керәклигини билила, сили бизгә көз болуп бәрсилә. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Шундақ болидуки, биз билән биллә барсила, кәлгүсидә Пәрвәрдигар бизгә қандақ яхшилиқ қилса, бизму силигә шундақ қилимиз! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Исраиллар Пәрвәрдигар теғидин йолға чиқип үч күн йол маңди; Пәрвәрдигарниң әһдә сандуғи уларға арам алидиған йәр издәп уларниң алдида үч күн йол башлап маңди. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Улар чедирлирини жиғиштуруп йолға чиқидиған чағларда, Пәрвәрдигарниң булути һаман уларниң үстидә болатти. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Әһдә сандуғи йолға чиқидиған чағда Муса: «Орнуңдин турғайсән, и Пәрвәрдигар; дүшмәнлириң тирипирән болсун; Саңа өчләр йүзүңниң алдидин қачсун!» — дәйтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Әһдә сандуғи тохтиған чағда у: «Қайтип кәлгәйсән, и Пәрвәрдигар, миңлиған-түмәнлигән Исраил хәлқи арисиға қайтип кәлгәйсән!» — дәйтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Вә шундақ болдики, хәлиқ ғотулдишатти, уларниң ғотулдашлири Пәрвәрдигарниң қулиқиға йетип интайин рәзил аңланди; У бу сөзләрни аңлиди вә Униң ғәзиви қозғалди; Пәрвәрдигарниң от-ялқуни уларниң арисида тутишип, баргаһниң четидики бәзиләрни көйдүрүшкә башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Хәлиқ бу чағда Мусаға ялвуривиди, Муса Пәрвәрдигардин тилиди; шуниң билән от пәсийип өчти. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Пәрвәрдигарниң оти уларниң оттурисида туташқанлиғи үчүн у у йәргә «Табәраһ» дәп ат қойди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Уларниң арисидики шалғут кишиләрниң нәпси тақилдап кәтти, Исраилларму йәнә жиғлашқа башлиди: «Әнди бизгә ким гөш бериду?    ");
INSERT INTO uigcyr_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Һелиму есимиздики, биз Мисирдики чағларда пул хәҗлимәй турупму белиқ йейәләйттуқ, йәнә тәрхәмәк, тавуз, пияз вә күдә пияз билән самсақму бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Мана бу йәрдә һазир көз алдимизда маннадин башқа һеч немә йоқ, әнди бизниң җенимизму қуруп кетиватиду» дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Манна гоя юмғақсүт уруғиға, көрүнүши гоя кәһриваға охшайтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Кишиләр уян-буян чепип уни жиғип, бәзидә ярғунчақта езип, бәзидә һаванчида соқуп, я бәзидә қазанда пиширип нан қилип йәйтти; тәми зәйтун майлиқ тоғачларға охшайтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Кечидә баргаһқа шәбнәм чүшкәндә, маннаму шуниң үстигә чүшәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Муса хәлиқниң аилиму-аилә һәр бири өз чедириниң ишиги алдида жиға-зерә қилишиватқинини аңлиди; буниңға Пәрвәрдигарниң ғәзиви қаттиқ қозғалди, бу иш Мусаниң нәзиридиму яман көрүнди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Муса Пәрвәрдигарға: — Сән бу барлиқ хәлиқниң еғир жүкини маңа артип қоюп, мән қулуңни немишкә бундақ қийнайсән; немишкә мән Сениң алдиңда илтипат тапмаймән? ");
INSERT INTO uigcyr_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Я мән бу пүтүн хәлиққә һамилдар болуп, уларни туғдумму? Сән техи маңа: «Сән уларни Мән қәсәм ичип уларниң ата-бовилириға мирас қилған шу йәргә йәткүзгичә, худди баққан атиси әмчәктики бовақни бағриға алғандәк бағриңға елип көтирип маң» дәватисән? ");
INSERT INTO uigcyr_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Мән бу хәлиққә нәдин гөш тепип берәләймән? Чүнки улар маңа жиғлап: «Сән бизгә йегидәк гөш тепип бәр!» дейишмәктә. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Мән бу хәлиқни көтиришни ялғуз үстүмгә елип кетәлмәйдикәнмән, бу иш маңа бәк еғир келиватиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Әгәр Сән маңа мошундақ муамилә қилмақчи болсаң, мән өтүнүп қалай, бу харап һалитимни маңа көрсәтмәй, илтипат қилип мени өлтүрүвәт! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Пәрвәрдигар Мусаға мундақ деди: — Исраил ақсақаллири ичидин, сән йенимға тонуйдиған хәлиқ ақсақаллири вә бәгләрдин йәтмишни таллап жиққин, уларни җамаәт чедириниң алдиға әкәл. Улар сениң билән биллә шу йәрдә турсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Мән шу йәргә чүшүп сениң билән сөзлишимән; вә сениң үстүңдә туруватқан Роһни елип уларниң үстигиму бөлүп қойимән. Шуниң билән улар сән билән биллә хәлиқни көтириш мәсъулийитини үстигә алиду, андин сән уни өзүң ялғуз көтәрмәйдиған болисән. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Сән хәлиққә мундақ дегин: «Әтә гөш йийишкә тәйярлинип өзәңләрни Худаға атап паклаңлар; чүнки силәр Пәрвәрдигарниң қулиқини ағритип жиғлап: «Әнди ким бизгә гөш бериду? Аһ, Мисирдики һалимиз бәк яхши еди!» дегән едиңлар әмәсму? Пәрвәрдигар дәрвәқә силәргә гөш бериду, силәр униңдин йәйсиләр. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Силәр бир күн, икки күн әмәс, бәш күн, он күн әмәс, жигирмә күнму әмәс, ");
INSERT INTO uigcyr_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","бәлки пүтүн бир ай йәйсиләр, таки бурниңлардин етилип чиқип һө болғичә йәйсиләр; чүнки силәр араңларда туруватқан Пәрвәрдигарни мәнситмәй, униң алдида жиғлап туруп: «Биз немә үчүн Мисирдин чиқтуқ?» — дедиңлар». ");
INSERT INTO uigcyr_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Муса: — Мән уларниң арисида туруватқан бу хәлиқтин йолға чиқалайдиған әркәкләр алтә йүз миң турса, Сән техи: «Мән уларни гөш йәйдиған, һәтта пүтүн бир ай гөш йәйдиған қилимән» дәйсән; ");
INSERT INTO uigcyr_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","әмисә қой, кала падилириниң һәммиси союлса уларға йетәмду? Яки деңиздики һәммә белиқ уларға тутуп берилсә, уларниң йийишигә йитәрму? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Шуниң билән Пәрвәрдигар Мусаға: — Пәрвәрдигарниң қоли қисқа болуп қаптиму? Әнди көрүп баққинә, Мениң саңа дегән сөзүм әмәлгә ашуруламду-йоқ? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Шуниң билән Муса чиқип Пәрвәрдигарниң сөзини хәлиққә йәткүзди вә хәлиқ ичидики ақсақаллардин йәтмиш адәмни таллап жиғип уларни җамаәт чедириниң әтрапида турғузди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Андин Пәрвәрдигар булут ичидин чүшүп, Муса билән сөзлишип, униңдики Роһтин елип йәтмиш ақсақалға қойди; Роһ уларниң үстигә қонуши билән улар бешарәт беришкә киришти. Лекин шу вақиттин кейин улар ундақ қилмиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Лекин у чағда улардин икки адәм баргаһта қалди; бирисиниң исми Әлдад, иккинчиси Медад еди (улар әслидә ақсақалларниң арисида тизимланған еди, лекин ибадәт чедириға чиқмай қалған еди). Роһ уларниң үстидиму қонди вә улар баргаһ ичидә бешарәт беришкә башлиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Яш бир жигит жүгүрүп келип Мусаға: — Әлдад билән Медад баргаһта бешарәт бериватиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Мусаниң хизмәткари, Муса таллиған сәрхил жигитлиридин бири, Нунниң оғли Йәшуа қопуп: — И ғоҗам Муса, уларни тосуғайла, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Лекин Муса униңға: — Сән мениң сәвәвимдин һәсәт қиливатамсән? Пәрвәрдигарниң пүтүн хәлқи пәйғәмбәр болуп кәтсә еди, Пәрвәрдигар Өзиниң Роһини уларниң үстигә қойса еди! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Шуниң билән Муса билән Исраил ақсақаллириниң һәммиси баргаһқа қайтип кетишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Әнди Пәрвәрдигар алдидин бир шамал чиқип, у деңиз тәрәптин бөдүниләрни учуртуп келип, баргаһниң әтрапиға йейивәтти; бөдүниләр баргаһниң у тәрипидиму бир күнлүк йол, бу тәрипидиму бир күнлүк йол кәлгидәк йәр йүзини икки гәз егизликтә кәлгидәк қаплиди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Хәлиқ орнидин туруп пүткүл шу күни, шу кечиси вә әтиси пүтүн күн бөдүнә тутуп жиғди, әң аз дегәнлириму алаһазәл икки хомир жиғди; улар буларни баргаһниң төрт әтрапиға өзлири үчүн йейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Улар гөшни чайнап езип болмай, гөш техи чишлири арисида турғанда, Пәрвәрдигарниң ғәзиви уларға қозғилип, хәлиқни интайин еғир бир ваба билән урди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Шуңа кишиләр шу йәрни «Қиброт-Һаттаваһ» дәп атиди; чүнки улар шу йәрдә нәпси тақилдиған кишиләрни йәрликкә қойған еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Кейин хәлиқ Қиброт-Һаттаваһтин йолға чиқип Һазиротқа келип, Һазиротта тохтиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Мәрийәм билән Һарун Мусаниң һәбәшлик қизни хотунлуққа алғини үчүн униңға қарши сөз қилди (чүнки у һәбәшлик бир қизни алған еди). ");
INSERT INTO uigcyr_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Улар: — Пәрвәрдигар пәқәт Муса биләнла сөзлишип, биз билән сөзләшмәптиму? — дейишти. Бу гәпни Пәрвәрдигар аңлиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Муса дегән бу адәм интайин кәмтәр-мөмин адәм болуп, бу тәрәптә йәр йүзидикиләр арисида униң алдиға өтидиғини йоқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Пәрвәрдигар Муса, Һарун вә Мәрийәмгә туюқсиз: — Силәр үчүңлар җамаәт чедириға келиңлар, — деди. Үчилиси чиқип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Андин Пәрвәрдигар әрштин булут түврүги ичидә чүшүп, җамаәт чедириниң алдида тохтап, Һарун билән Мәрйәмни қичқиривиди, улар алдиға кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","У уларға: — Әнди силәр гепимни аңлаңлар, әгәр силәрниң араңларда пәйғәмбәр болса, Мән Пәрвәрдигар аламәт көрүнүштә униңға Өзүмни аян қилимән, чүшидә униң билән сөзлишимән. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Лекин қулум Мусаға нисбәтән ундақ әмәс; у барлиқ аиләм ичидә толиму садиқтур; ");
INSERT INTO uigcyr_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Мән униң билән тепишмақ ейтип олтармай, йүзму йүз туруп беваситә сөзлишимән; у Мән Пәрвәрдигарниң қияпитини көрәләйду. Әнди силәр немишкә қулум Муса тоғрилиқ яман гәп қилиштин қорқмидиңлар? — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Пәрвәрдигарниң отлуқ ғәзиви уларға қозғалди вә у кетип қалди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Шуниң билән булут җамаәт чедири үстидин кәтти, вә мана, Мәрйәм худди аппақ қардәк песә-мохо болуп кәтти; Һарун бурулуп Мәрйәмгә қаривиди, мана, у песә-мохо болуп қалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Һарун Мусаға: — Вай ғоҗам! Наданлиқ қилип гуна өткүзүп қойғанлиғимиз сәвәвидин бу гунани бизниң үстимизгә артмиғайсән. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","У худди анисиниң қосиғидин чиққандила бәдини йерим чирик, өлүк туғулған балидәк болуп қалмиғай! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Шуниң билән Муса Пәрвәрдигарға: — И Тәңри, униң кесилини сақайтивәткән болсаң, — дәп нида қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Пәрвәрдигар Мусаға: — Әгәр атиси униң йүзигә түкүргән болса, у йәттә күн хиҗилчилиқ ичидә турған болатти әмәсму? Әнди у баргаһниң сиртиға йәттә күн қамап қоюлсун, андин у қайтип кәлсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Шуниң билән Мәрйәм баргаһ сиртиға йәттә күн қамап қоюлди, таки Мәрйәм қайтип кәлгичә хәлиқ йолға чиқмай туруп турди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Андин кейин хәлиқ Һазироттин йолға чиқип, Паран чөлидә баргаһ қурди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Мән Исраилларға мирас қилип бәргән Қанаан зиминини чарлап келишкә адәмләрни әвәткин; һәр бир ата җәмәткә тәвә қәбилидин бирдин адәм чиқирилсун, улар өз қәбилисидики әмир болсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Муса Пәрвәрдигарниң әмри бойичә, уларни Паран чөлидин йолға салди; уларниң һәммиси Исраилларниң башлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Төвәндикиләр уларниң исимлири: — Рубән қәбилисидин Заккурниң оғли Шаммуя, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Шимеон қәбилисидин Хориниң оғли Шафат, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Йәһуда қәбилисидин Йәфуннәһниң оғли Каләб, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Иссакар қәбилисидин Йүсүпниң оғли Игал, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Әфраим қәбилисидин Нунниң оғли Һошия, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Бинямин қәбилисидин Рафуниң оғли Палти, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Зәбулун қәбилисидин Содиниң оғли Гаддийәл, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Йүсүп қәбилисидин, йәни Манассәһ қәбилисидин Сусиниң оғли Гадди, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Дан қәбилисидин Гималлиниң оғли Аммийәл, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Ашир қәбилисидин Микаилниң оғли Сәтур, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Нафтали қәбилисидин Вофсиниң оғли Наһби, ");
INSERT INTO uigcyr_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Гад қәбилисидин Макиниң оғли Геуәл. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Мана булар Муса чарлап келиңлар дәп Қанаан зиминиға әвәткән адәмләрниң исми. Муса Нунниң оғли Һошияни Йәһошуя дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Муса уларни чарлап келишкә Қанаанға сәпәрвәр қилип: — Силәр мошу йәрдин Нәгәв чөли тәрәпкә қарап меңиңлар, андин тағлиқ районға чиқиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","У йәрниң қандақ екәнлигини, у йәрдикиләрниң күчлүк-аҗизлиғини, аз яки көплүгини көрүп беқиңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","улар туруватқан йәрниң қандақ екәнлигини, яхши-яманлиғини көрүңлар; улар туруватқан шәһәрләрниң қандақ екәнлигини, баргаһлиқ шәһәр яки сепил-қәлъәлик шәһәр екәнлигини; ");
INSERT INTO uigcyr_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","у йәрниң мунбәт яки мунбәтсиз екәнлигини, дәл-дәрәқлириниң бар-йоқлуғини көрүп келиңлар. Жүрәкликрәк болуп, мевә-чивилиридин алғач келиңлар, — деди. Бу чағ дәл үзүм пишип қалған вақит еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Улар шу тәрәпләргә чиқип, зиминни Зин чөлидин тартип таки Һамат еғизиниң йенидики Рәһобқичә берип чарлашти. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Улар җәнуп тәрәптә Һебронға барди, у йәрләрдә Анақийларниң әвлатлиридин Аһиман, Шишай, Талмай дегәнләр олтиришлиқ еди. Әслидә Һеброн шәһири Мисирдики Зоан шәһиридин йәттә жил илгири ясалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Улар «Әшкол җилғиси»ға кәлди, у йәрдә бир сап үзүми бар бир үзүм шехини кесип, бир балдаққа есип икки адәмгә көтәргүзүп маңди; улар азрақ анар билән әнҗирму елип қайтип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Исраиллар шу йәрдә кесивалған әшу үзүм сәвәвидин у йәр «Әшкол җилғиси» («үзүм сапиғи җилғиси») дәп аталди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Улар қириқ күндин кейин у йәрләрни чарлап түгитип, қайтип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Улар келип, Паран чөллүгидики Қадәштә Муса, Һарун вә пүтүн Исраил җамаити билән көрүшти. Улар иккиләнгә һәм пүткүл Исраил җамаитигә мәлумат бәрди һәм зиминниң мевилирини уларға көрсәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Улар Мусаға мәлумат берип: — Биз өзлири бериңлар дегән йәрләргә бардуқ, растинла сүт билән һәсәл еқип туридиған йәр екән, мана булар шу йәрниң мевилири. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Бирақ у йәрдикиләр бәк күчтүңгүр екән, шәһәрләр сепиллиқ болуп һәм пухта-һәйвәтлик екән. Униң үстигә, биз у йәрдә Анақийларниң әвлатлириниму көрдуқ. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Амаләкләр җәнуп тәрәптә туридикән; Һиттийлар, Йәбусийлар, Аморийлар тағларда туридикән; Ⱪананийлар деңиз бойлирида вә Иордан дәрияси бойлирида туридикән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Каләб Мусаниң алдида көпчиликни тиничлитип: — Биз дәрһал атлинип берип у йәрни егиләйли! Чүнки биз чоқум ғалип келимиз — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Лекин униң билән биллә чиққан башқилар болса: — Улар биздин күчлүк екән, шуңа уларға һуҗум қилсақ болмайду, — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Андин чарлиғучилар өзлири чарлап кәлгән зиминниң әһвалидин Исраилларға яман мәлумат берип: — Биз кирип чарлап өткән зимин болса өз аһалисини йәйдиған зимин екән; биз у йәрдә көргәнләрниң һәммиси йоған адәмләр екән. ");
INSERT INTO uigcyr_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","Биз у йәрләрдә «Нәфилийләр» дегән гигант адәмләрни көрдуқ (дәрвәқә Анақийларниң әвлатлири Нәфилийләрдин чиққандур); биз өзимизгә қарисақ чекәткидәк туридикәнмиз, биз уларғиму шундақ көринидикәнмиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Шуниң билән барлиқ җамаәт дад-пәряд көтирип жиғлиди; улар кечичә жиға-зерә қилишип чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Исраиллар Муса билән Һарунға тапа-тәнә қилип: — Биз балдурла Мисирда өлүп кәтсәк боптикән! Мошу чөл-җәзиридә өлүп кәтсәк боптикән! ");
INSERT INTO uigcyr_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Пәрвәрдигар немишкә бизни қилич астида өлсун, хотун бала-җақилиримиз булинип, дүшмәнниң олҗиси болсун дәп бизни бу йәргә башлап кәлгәнду? Униңдин көрә, Мисирға қайтип кәткинимиз яхши әмәсму? — дәп ғотулдашти. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Шуниң билән улар бир-биригә: — Башқидин бир башлиқ тикләп Мисирға қайтип кетәйли, — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Муса билән Һарун пүтүн Исраил җамаити алдида жиқилип дүм ятти. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Шу йәрни чарлап кәлгәнләр ичидики Нунниң оғли Йәшуа билән Йәфуннәһниң оғли Каләб кийимлирини житип, ");
INSERT INTO uigcyr_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","пүтүн Исраил җамаәтчилигигә: — Биз чарлап келишкә өтүп барған зимин интайин бәк яхши зимин екән. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Әгәр Пәрвәрдигар биздин сөйүнсә, бизни шу зиминға, йәни һәсәл билән сүт еқип туридиған шу зиминға башлап берип, уни бизгә бериду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Силәр пәқәт Пәрвәрдигарға асийлиқ қилмаңлар! У зиминидикиләрдин қорқмаңлар, чүнки улар бизгә нисбәтән бир ғизадур; уларниң панаһдарлири улардин кәтти, Пәрвәрдигар болса биз билән биллә; улардин қорқмаңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Һалбуки, пүткүл җамаәт тәрәп-тәрәптин: — У иккисини чалма-кесәк қилип өлтүрүветәйли, дейишти. Лекин Пәрвәрдигарниң җуласи җамаәт чедирида Исраилларға аян болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Пәрвәрдигар Мусаға: — Бу хәлиқ Мени қачанғичә мәнситмәйду? Гәрчә уларниң оттурисида шунчә мөҗизилик аламәтләрни яратқан болсамму, лекин улар Маңа қачанғичә ишинишмәйдикән? ");
INSERT INTO uigcyr_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Мән уларни ваба билән уруп йоқитимән, шуниң билән сени улардин техиму чоң вә қудрәтлик бир әл қилимән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Муса болса Пәрвәрдигарға мундақ деди: — «Бундақ болидиған болса бу ишни мисирлиқлар аңлап қалиду, чүнки Сән улуқ қудритиң билән бу хәлиқни уларниң арисидин елип чиққан едиң; ");
INSERT INTO uigcyr_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","вә Мисирлиқлар бу ишни шу зиминдики хәлиқләргиму ейтиду. У зиминдики аһалиму Сән Пәрвәрдигарниң бу хәлиқниң арисида екәнлигиңни, Сән Пәрвәрдигарниң уларниң алдида йүзму-йүз көрүнгәнлигиңни, Сениң булутиң дайим уларға сайә чүшүрүп кәлгәнлигини, шундақла Сениң күндүзи булут түврүгидә, кечиси от түврүгидә уларниң алдида маңғанлиғиңни аңлиған еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Әнди Сән бу хәлиқни худди бир адәмни өлтүргәндәк өлтүрүвәтсәң, Сениң нам-шөһритиңни аңлиған әлләрниң һәммиси: ");
INSERT INTO uigcyr_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","«Пәрвәрдигар бу хәлиқни Өзи уларға беришкә қәсәм қилған зиминға башлап баралмайдиғанлиғи үчүн, шуңа уларни әшу чөл-җәзиридә өлтүрүветипту» дәп қалиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Әнди өтүнимәнки, Рәббим қудритиңни җари қилдурғайсән, Өзүңниң: ");
INSERT INTO uigcyr_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","«Пәрвәрдигар асанлиқчә аччиқланмайду, Униң меһир-муһәббити тешип туриду; У гуна вә итаәтсизликни кәчүриду, лекин гунакарларни һәргиз гунасиз дәп қаримайду, атиларниң қәбиһлигини атисидин балисиғичә, һәтта нәврә-чәврилиригичә уларниң үстигә жүкләйду» дегиниңдәк қилғайсән.    ");
INSERT INTO uigcyr_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Меһир-шәпқитиңниң кәңрилиги бойичә, Мисирдики чағдин таки һазирғичә дайим кәчүрүп кәлгиниңдәк, бу хәлиқниң қәбиһлигини кәчүргәйсән!». ");
INSERT INTO uigcyr_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Пәрвәрдигар: — «Бопту, сән дегәндәк уларни кәчүрдүм. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Лекин Өз һаятим билән қәсәм қилимәнки, пүткүл йәр йүзи Мән Пәрвәрдигарниң шан-шәриви билән толиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Һалбуки, Мениң җулайимни, Мисирда вә чөл-җәзиридә көрсәткән мөҗизилик аламәтлиримни көрүп турупму Мени мошундақ он қетимлап синап йәнә авазимға қулақ салмиғанлар, ");
INSERT INTO uigcyr_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Мән қәсәм ичип уларниң ата-бовилириға мирас қилип беримән дегән у зиминни һәргиз көрәлмәйду; Мени мәнситмигәнләрдин бириму у жутни көрәлмәйду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Лекин өзидә башқичә бир роһниң болғини, пүтүн қәлби билән Маңа әгәшкини үчүн қулум Каләбни у киргән йәргә башлап киримән; униң әвлатлириму у йәргә мирасхор болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(шу чағда Амаләкләр билән Ⱪананийлар тағлиқ җилғиларда турувататти) — Әтә силәр йолуңлардин бурулуп, Қизил Деңизға баридиған йол билән меңип чөлгә сәпәр қилиңлар» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Пәрвәрдигар Муса билән Һарунға сөз қилип мундақ деди: ");
INSERT INTO uigcyr_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","— Мән Мениң яман гепимни қилип ғотулдишидиған бу рәзил җамаәткә қачанғичә чидишим керәк? Исраилларниң Мениң яман гепимни қилғанлири, шу тохтавсиз ғотулдашлириниң һәммисини аңлидим. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Сән уларға: — Пәрвәрдигар мундақ дәйду: «Мән һаятим билән қәсәм қилимәнки, хәп, Мән силәргә қулиқимға киргән сөзлириңлар бойичә муамилә қилмайдиған болсам! ");
INSERT INTO uigcyr_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Силәрниң өлүгүңлар мошу чөлдә ятиду; силәрниң ичиңларда санақтин өткүзүлгәнләр, йәни йеши жигирмидин ашқан, Мениң яман гепимни қилип ғотулдиғанларниң һәммиси пүтүн сани бойичә ");
INSERT INTO uigcyr_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Силәргә қол көтирип қәсәм қилип, туралғуңлар қилип беримән дегән зиминға һеч кирәлмәйду; пәқәт Йәфуннәһниң оғли Каләб билән Нунниң оғли Йәшуала кириду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Силәрниң кичик балилириңлар, йәни «Булинип, дүшмәнниң олҗиси болуп қалиду» дейилгәнләрни Мән башлап киримән, улар силәр кәмситкән у зиминдин бәһримән болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Бирақ силәр болсаңлар, силәр жиқилип, өлүгүңлар бу чөлдә қалиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Силәрниң балилириңлар бузуқлуқ-вапасизлиғиңларниң әлимини тартип, өлүгүңлар чөлдә йоқалғичә, бу чөлдә қириқ жил сәргәрдан болуп жүриду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Силәрниң шу зиминни чарлиған күнлириңларниң сани бойичә, қириқ күнниң һәр бир күнини бир жил һесаплап, қәбиһликлириңларни қириқ жил өз үстүңларға елип жүрисиләр; шу чағда Мениң өзүңлардин ятлашқинимниң немә екәнлигини билип йетисиләр» — дегин. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Мән Пәрвәрдигар шундақ дегән екәнмән, жиғилип Маңа қарши чиққан бу рәзил хәлиқ җамаитигә Мән чоқум шундақ қилимән; улар мошу чөл-җәзиридә йәветилиду, шу йәрдә өлиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Муса у зиминни чарлап келишкә әвәткәнләр қайтип кәлгәндә, у зимин тоғрилиқ яман хәвәр елип келиш билән пүтүн җамаәтни ғотулдитип, Мусаниң яман гепини қилғузғанлар, ");
INSERT INTO uigcyr_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","йәни у зимин тоғрилиқ яман хәвәр әкәлгән бу кишиләрниң һәммиси ваба кесили тегип Пәрвәрдигарниң алдида өлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Зиминни чарлап келишкә барған адәмләр ичидин пәқәт Нунниң оғли Йәшуа билән Йәфуннәһниң оғли Каләбла һаят қалди. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Муса бу гәпләрни пүткүл Исраил җамаитигә ейтивиди, һәммиси бәк һәсрәт чәкти. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Улар әтигән таң атқанда туруп таққа чиқип: — Мана биз кәлдуқ! Пәрвәрдигар ейтқан жутқа чиқип һуҗум қилайли; чүнки биз гуна қилдуқ, — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","— Силәр йәнә немишкә Пәрвәрдигарниң әмригә хилаплиқ қилисиләр? — деди Муса, — Бу иш ғәлибилик болмайду! ");
INSERT INTO uigcyr_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Пәрвәрдигар араңларда болмиғачқа, дүшмәнниң қиличи астида өлүп, мәғлуп болмаслиғиңлар үчүн һуҗумға чиқмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Чүнки Амаләкләр билән Ⱪананийлар у жутта, силәрниң алдиңларда туриду; силәр қилич астида өлүп кетисиләр; чүнки силәр Пәрвәрдигардин тенип кәттиңлар, Пәрвәрдигар силәр билән биллә болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Лекин, гәрчә Пәрвәрдигарниң әһдә сандуғи вә Муса баргаһтин қозғалмиған болсиму, улар йәнила өз мәйличә таққа чиқип һуҗумға өтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Шуниң билән Амаләкләр билән шу тағда турушлуқ Ⱪананийлар чүшүп уларни таки Хормаһғичә қоғлап, битчит қилип қирғин қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Сән Исраилларға мундақ дегин: — Силәр маканлишишиңлар үчүн силәргә тәқдим қилип беридиған зиминға киргән чеғиңларда, ");
INSERT INTO uigcyr_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","әгәр Пәрвәрдигарға атап отта сунулидиған, униңға хушбуй болсун дәп бирәр һәдийә-қурбанлиқ қилмақчи болсаңлар, қурбанлиқ кала яки қой-өшкә падисидин болсун. У көйдүрмә қурбанлиқ болсун, қәсәмни ада қилиш қурбанлиғи болсун, ихтиярий қурбанлиқ яки силәргә бекитилгән һейтлардики зөрүр қурбанлиқ болсун, ");
INSERT INTO uigcyr_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","қурбанлиқ сунғучи киши Пәрвәрдигарға атиғиниға бир ашлиқ һәдийәсини қошуп кәлтүрсун. Көйдүрмә қурбанлиқ яки башқа қурбанлиқ қоза болса, ундақта ашлиқ һәдийәси зәйтун мейидин бир һинниң төрттин бири иләштүрүлгән есил ундин әфаһниң ондин бири болсун; униңға йәнә шарап һәдийәси сүпитидә төрттин бир һин шарапни қошуп сунсун.    ");
INSERT INTO uigcyr_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Қурбанлиғиң қочқар болса, сән униңға ашлиқ һәдийәси сүпитидә үчтин бир һин зәйтун мейи иләштүрүлгән есил ундин әфаһниң ондин иккиси болсун ");
INSERT INTO uigcyr_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","вә шарап һәдийәси сүпитидә үчтин бир һин шарапни қошуп сунсун; булар Пәрвәрдигарға хушбуй чиқарсун дәп сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Әгәр сән Пәрвәрдигарға көйдүрмә қурбанлиқ, яки қәсәм ада қилиш қурбанлиғи яки енақлиқ қурбанлиғи сүпитидә топақ атиған болсаң, ");
INSERT INTO uigcyr_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ундақта топаққа ашлиқ һәдийәси сүпитидә йерим һин зәйтун мейи иләштүрүлгән есил ундин әфаһниң ондин үчини, ");
INSERT INTO uigcyr_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","шарап һәдийәси сүпитидә йерим һин шарапни қошуп сунғин; булар Пәрвәрдигарға атилип отта сунулуп, хушбуй чиқарсун дәп кәлтүрүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Һәр бир сунулған топақ, қочқар, қоза яки оғлаққа нисбәтән мошундақ қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Силәр сунидиғиниңларниң сани бойичә, һәр хил қурбанлиқниң саниға қарап шундақ қилисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Шу зиминда туғулғанларниң һәммиси Пәрвәрдигарға хушбуй чиқарсун дәп, отта сунулидиған қурбанлиқ қилмақчи болса әнә шундақ қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Шуниңдәк силәр билән биллә туруватқан мусапир яки әвлатму-әвлат силәр билән биллә туруватқанлар болса, хушбуй чиқарсун дәп отта сунулидиған қурбанлиқ қилмақчи болса, силәр қандақ қилған болсаңлар, уларму шундақ қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Пүткүл җамаәткә, мәйли силәр болуңлар яки силәр билән биллә туруватқан мусапир болсун, һәммиңлар үчүн охшаш бир бәлгүлимә болиду; силәр үчүн дәвирму-дәвир әбәдий бир бәлгүлимә болиду; Пәрвәрдигар алдида силәр қандақ болсаңлар, мусапирларму шундақтур. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Силәргиму, араңларда туруватқан мусапирларғиму охшаш бир қанун-бәлгүлимә, охшаш бир һөкүм болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Сән Исраилларға сөз қилип уларға мундақ дегин: — «Силәр Мән силәрни әкиридиған зиминға йетип барғанда, ");
INSERT INTO uigcyr_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","шу йәрдин чиққан ашлиқни йәйдиған чеғиңларда, Пәрвәрдигарға бир «көтәрмә һәдийә» тәқдим қилиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Силәр һәр бир йеңи хемирдин пишқан нанлардин бирини «көтәрмә һәдийә» қилип тәқдим қилиңлар; силәр уни тәқдим қилғанда худди хаманниң «көтәрмә һәдийә»сигә охшаш болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Дәвирдин-дәвиргә силәр дәсләпки һосулдин чиққан хемирдин бир нанни «көтәрмә һәдийә» сүпитидә Пәрвәрдигарға сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Әгәр силәр өзүңлар билмәй езип гуна қилип, Пәрвәрдигарниң Мусаға буйруған бу барлиқ әмирлиригә әмәл қилмиған болсаңлар, ");
INSERT INTO uigcyr_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","йәни Пәрвәрдигар буйруған күндин етиварән барлиқ әвлатлириңларғичә Пәрвәрдигарниң Мусаниң вастиси билән силәргә буйруған барлиқ ишлириға әмәл қилмиған болсаңлар, ");
INSERT INTO uigcyr_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","җамаәт шундақ бирәр гунаниң билмәй өткүзүлгәнлигидин хәвәрсиз болса, ундақта пүткүл җамаәт Пәрвәрдигарға хушбуй чиқарсун дәп яш бир топақни көйдүрмә қурбанлиқ сүпитидә сунсун һәмдә қаидә-низам бойичә униңға мунасивәтлик ашлиқ һәдийәси билән шарап һәдийәсини қошуп сунсун, вә униң үстигә бир текини гуна қурбанлиғи сүпитидә сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Шу йол билән каһин пүткүл Исраил җамаити үчүн кәфарәт кәлтүрүп, бу гуна улардин кәчүрүм қилиниду; чүнки бу билмәй өткүзүп қойған гуна вә улар өзлириниң билмәй өткүзүп қойған гунайи үчүн қурбанлиқ, йәни Пәрвәрдигарға атап отта сунулидиған қурбанлиқ вә гуна қурбанлиғини бирликтә Пәрвәрдигар алдиға сунған. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Бу гуна пүткүл Исраил җамаити билән уларниң арисида туруватқан мусапирларниң һәммисидин кәчүрүм қилиниду, чүнки бу пүткүл хәлиқ билмәй туруп өткүзүп қойған гунадур. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Әгәр бир киши билмәстин гуна қилип қойған болса, у бир яшлиқ бир чиши оғлақни гуна қурбанлиғи сүпитидә сунсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Каһин шу йол билән билмәй гуна қилип қойған адәм үчүн кәфарәт кәлтүриду; униң үчүн кәфарәт кәлтүрсә униң Пәрвәрдигар алдида билмәй өткүзгән гунайи униңдин кәчүрүм қилиниду. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Билмәй бирәр сәһвәнлик өткүзүп қойған барлиқ кишиләргә, мәйли шу зиминда туғулған Исраиллар болсун яки уларниң арисида туруватқан мусапирларға болсун, — силәрниң һәммиңларға охшаш бир қанун-бәлгүлимә тәтбиқлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Лекин жүригини қаптәк қилип иш көргән киши, мәйли у зиминда туғулған болсун яки мусапир болсун, Пәрвәрдигарға һақарәт кәлтүргән болиду; у һаман өз хәлқидин үзүп ташлиниду. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","У Пәрвәрдигарниң сөзини мәнситмигән екән, Пәрвәрдигарниң әмригә хилаплиқ қилған екән; шуниң үчүн у чоқум үзүп ташлиниду; гунайи өзиниң бешиға чүшиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Исраиллар чөл-җәзиридики вақитлирида, бир кишиниң шабат күнидә отун тәргәнлиги байқалди. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Отун териватқанлиғини байқап қалғанлар уни Муса, Һарун вә пүткүл җамаәтниң алдиға елип кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Уни қандақ бир тәрәп қилиш керәклиги техи көрситилмигәчкә, улар уни қамап қойди. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Пәрвәрдигар Мусаға: — У адәм өлтүрүлмисә болмайду; пүтүн җамаәт уни баргаһниң тешиға әпчиқип чалма-кесәк қилип өлтүрсун, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Андин пүтүн җамаәт у адәмни баргаһ сиртиға әпчиқип, худди Пәрвәрдигар Мусаға буйруғандәк, чалма-кесәк қилип өлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Сән Исраилларға мундақ дегин, улар әвлатму-әвлат кийим-кечәклириниң чөрисигә чучиларни тутсун һәм бүҗигидики чучилириниң һәр биригә көк шойна тикип қойсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","бу хил чучилар силәрниң уни тикип турушуңлар үчүн болиду; уни көргәндә Пәрвәрдигарниң барлиқ әмирлирини есиңларда тутуп, уларға әмәл қилишиңлар үчүн бу силәргә бир әсләтмә болиду; шуниңдәк силәрниң һазирқидәк өзүңларниң көңлүңлар вә көзүңларниң кәйнигә кирип, қатирап бузуқлуқ қилип кәтмәслигиңлар, ");
INSERT INTO uigcyr_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Мениң барлиқ әмирлиримни әстә тутушуңлар һәм униңға әмәл қилип, Худайиңларға атап пак-муқәддәс болушуңлар үчүн болсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Мән Худайиңлар болуш үчүн силәрни Мисир зиминидин елип чиққан Пәрвәрдигардурмән; Мән Пәрвәрдигар Худайиңлардурмән. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Лавийниң әвриси, Коһатниң нәвриси, Изһарниң оғли Кораһ вә Рубәнниң әвлатлиридин Елиабниң оғуллири Датан билән Абирам вә Пәләтниң оғли Он ");
INSERT INTO uigcyr_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Исраиллар ичидики җамаәт әмирлири болған, җамаәт ичидин сайлап чиқилған мөтивәрләрдин икки йүз әллик кишини башлап келип Мусаға қарши чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Улар жиғилип Мусаға қарши һәм Һарунға қарши чиқип: — Силәр һәддиңлардин бәк аштиңлар, пүткүл җамаәтниң һәммиси пак-муқәддәс, Пәрвәрдигарму уларниң арисида, шундақ туруғлуқ силәр немә дәп өзүңләрни Пәрвәрдигарниң җамаитидин үстүн қоюсиләр? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","5","Муса уларниң гепини аңлап дүм жиқилип, Кораһ билән униң гуруһидикиләргә сөз қилип: — Әтә әтигәндә Пәрвәрдигар кимләрниң Өзигә мәнсуп екәнлигини, кимләрниң пак-муқәддәс екәнлигини аян қилиду; шу кишини Өзигә йеқинлаштуриду; кимни таллиған болса, уни Өзигә йеқинлаштуриду. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Силәр мундақ қилиңлар: — Сән Кораһ вә сениң гуруһиңдикиләр һәммиси хушбуйданларни әпкелиңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","әтә Пәрвәрдигарниң алдида хушбуйданларға от йеқип, хушбуйни униң үстигә қоюңлар; Пәрвәрдигар кимни таллиса, шу муқәддәс-пак болған болсун! Әй силәр Лавийлар, һәддиңлардин бәк аштиңлар! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Муса йәнә Кораһқа: — И Лавийлар, гепимгә қулақ селиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","10","Исраилниң Худаси Пәрвәрдигар силәрни Өзиниң чедириниң ишлирини қилсун дәп һәмдә җамаәтниң алдида уларниң хизмитидә болсун дәп Өзигә йеқинлаштуруш үчүн силәрни Исраил җамаитидин айрип чиққан — йәни Пәрвәрдигар сени вә сениң һәммә қериндашлириң болған Лавийниң әвлатлирини бирдәк Өзигә йеқинлаштурғанлиғи силәрчә кичик ишму? Силәр йәнә техи каһинлиқ вәзиписини тама қиливатамсиләр? ");
INSERT INTO uigcyr_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Шу вәҗидин сән вә сениң гуруһиңдикиләр һәммиси жиғилип Пәрвәрдигарға қарши чиқиветипсиләр-дә; Һарун немиди, силәр униң үстидин шунчилик ағринип ғотулдишип кәткидәк? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Муса Елиабниң оғли Датан билән Абирамни қичқирип келишкә адәм әвәтивиди, улар: — Бармаймиз! ");
INSERT INTO uigcyr_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Сениң бизни сүт билән һәсәл ақидиған зиминдин башлап чиқип бу чөл-җәзиридә өлтәрмәкчи болғанлиғиңниң өзи кичик ишму? Сән техи өзүңни падиша һесаплап бизниң үстимиздин һөкүмранлиқ қилмақчиму? ");
INSERT INTO uigcyr_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Һалбуки, сән бизни сүт билән һәсәл ақидиған жутқа башлап кәлмидиң, етиз вә үзүмзарлиқларниму бизгә мирас қилип бәрмидиң. Сән бу хәқниң көзиниму оювалмақчиму? Биз бармаймиз! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Буни аңлап Муса қаттиқ ғәзәплинип Пәрвәрдигарға: — Уларниң соғат-һәдийәсигә етивар қилмиғайсән; мән уларниң һәтта бирәр ешигиниму тартивалмидим, бирәр адимигиму һеч зиян-зәхмәт йәткүзмидим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Муса Кораһқа: — Әтә сән вә сениң гуруһиңдикиләр — сән, улар вә Һарун Пәрвәрдигарниң алдиға келиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Һәр бириңлар өзүңларниң хушбуйданлириңларни әкилип униң үстигә хушбуйни селиңлар; һәр бириңлар өзүңларниң хушбуйданлириңларни, йәни җәмий икки йүз әллик хушбуйданни елип уни Пәрвәрдигарниң һозурида тутуп туруңлар; сәнму, Һарунму һәр бириңлар өз хушбуйданлириңларни елип келиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Шуниң билән һәр бир адәм өзиниң хушбуйданини елип, отни йеқип, хушбуй селип, Муса вә Һарун билән бирликтә җамаәт чедириниң дәрвазиси алдида турушти. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Кораһ Муса билән Һарунға һуҗум қилғили пүтүн җамаәтни жиғип җамаәт чедириниң дәрвазиси алдиға келивиди, Пәрвәрдигарниң җуласи пүткүл җамаәткә аян болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Пәрвәрдигар Муса билән Һарунға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Силәр бу хәлиқниң арисидин нери туруңлар, мән көз жумуп ачқичә уларни жутуветимән, — девиди, ");
INSERT INTO uigcyr_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Муса билән Һарун дүм жиқилип: — И Тәңрим, барлиқ әт егилириниң роһлириниң Худаси, бир адәм гуна қилса, ғәзивиңни пүтүн җамаәткә чачамсән? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Сән җамаәткә: «Силәр Кораһ, Датан вә Абирамниң турар җайлиридин айрилип улардин нери кетиңлар» — дәп буйруқ бәр, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Шуниң билән Муса орнидин туруп Датан билән Абирам тәрәпкә қарап маңди; Исраил ақсақаллириму униңға әгишип маңди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Муса җамаәткә: — Силәрдин өтүнимән, бу рәзил адәмләрниң чедирлиридин жирақ кетиңлар, уларниң барлиқ гуналири сәвәвидин улар билән биллә вәйран болмаслиғиңлар үчүн уларниң һеч нәрсисигә қол тәккүзмәңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Шуниң билән җамаәт Кораһ, Датан, Абирамниң чедирлириниң төрт әтрапидин нери кәтти; Датан билән Абирам болса өз аяллирини, оғул-қизлирини вә бовақлирини елип чиқип өз чедириниң ишиги алдида турди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Муса: — Буниңдин силәр шуни билисиләрки, бу ишларниң һәммиси мениң көңлүмдин чиққан әмәс, бәлки Пәрвәрдигар мени уларни ада қилишқа әвәткән: ");
INSERT INTO uigcyr_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","— әгәр бу адәмләрниң өлүми адәттики адәмләрниң өлүмигә охшаш болидиған яки уларниң бешиға чүшидиған қисмәтләр адәттики адәмләр дучар болидиған қисмәтләргә охшаш болидиған болса, Пәрвәрдигар мени әвәтмигән болатти. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Әгәр Пәрвәрдигар йеңи бир ишни қилип, йәр ағзини ечип уларни вә уларниң пүтүн нәрсисини жутуп кетиши билән, улар тирикла тәһтисараға чүшүп кәтсә, у чағда силәр бу адәмләрниң Пәрвәрдигарни мәнситмигәнлигини билип қалисиләр, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Мусаниң бу гепи ахирлишиши биләнла уларниң пути астидики йәр йерилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Йәр ағзини ечип уларни барлиқ аилисидикиләр билән, шуниңдәк Кораһқа тәвә һәммә адәмләрни қоймай тәәллуқатлири билән қошуп жутуп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Шундақ қилип, улар вә уларниң тәвәсидикиләрниң һәммиси тирикла тәһтисараға чүшүп кәтти, йәр уларниң үстидә йепилди. Улар шу йол билән җамаәтниң арисидин йоқалди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Уларниң әтрапида турған Исраилларниң һәммиси уларниң налисини аңлап: «Йәр бизниму жутуп кетәрмекин!» дейишип қечишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Андин Пәрвәрдигарниң алдидин бир от чиқип, хушбуй сунуватқан һелиқи икки йүз әллик адәмниму жутуп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Сән каһин Һарунниң оғли Әлиазарға буйруғин, у хушбуйданларни от арисидин теривелип, чоғлирини жирақларға чечивәтсун, чүнки у хушбуйданлар Худаға аталғандур; ");
INSERT INTO uigcyr_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","шуңа өзиниң җениға өзи замин болған гунакарларниң хушбуйданлирини теривалғин; улар қурбангаһни қаплаш үчүн соқуп непиз түникә қилинсун, чүнки бу хушбуйданлар әслидә Пәрвәрдигарниң һозуриға сунулуп униңға аталип муқәддәс қилинған. Шундақ қилип улар кейин Исраилларға ибрәт болидиған ишарәт-бәлгү болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Шуниң билән каһин Әлиазар отта көйдүрүветилгәнләр сунған мис хушбуйданларни теривалди; улар қурбангаһни қаплитишқа непиз түникә қилип соқулди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Шуниң билән қурбангаһниң бу қаплимиси Һарунниң әвлатлириға ят адәмләрниң худди Кораһ билән униң гуруһидикиләргә охшаш қисмәткә қалмаслиғи үчүн, Пәрвәрдигарниң һозурида хушбуй көйдүрүшкә йеқинлашмаслиғиға Исраиллар үчүн бир әсләтмә болди. Бу Пәрвәрдигарниң Мусаниң вастиси билән Әлиазарға буйруғанлиридур. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Әтиси пүткүл Исраил җамаити Муса билән Һарунниң яман гепини қилип: — Силәр Пәрвәрдигарниң хәлқини өлтүрдүңлар, — дәп ғотулдашти. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Вә шундақ болдики, җамаәт Муса билән Һарунға һуҗум қилишқа жиғиливатқанда, җамаәт бурулуп җамаәт чедириға қаривиди, вә мана, булут чедирни қапливалди һәм Пәрвәрдигарниң җуласи аян болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Шуниң билән Муса билән Һарун җамаәт чедириниң алдиға берип турди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Мән көзни жумуп ачқичә уларни йоқитип ташлишим үчүн иккиңлар бу җамаәттин чиқип нери кетиңлар, — дәп буйрувиди, иккилән жиқилип йәрдә дүм ятти. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Муса Һарунға: — Сән хушбуйданни елип униңға қурбангаһтики оттин сал, униңға хушбуй қоюп, улар үчүн кәфарәт кәлтүрүшкә тезликтә җамаәтниң арисиға апар; чүнки қәһр-ғәзәп Пәрвәрдигарниң алдидин чиқти, ваба басқили турди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Һарун Мусаниң дегинидәк қилип, хушбуйданни елип җамаәтниң арисиға жүгүрүп кирди; вә мана, ваба кишиләрниң арисида башланған еди; у хушбуйни хушбуйданға селип, хәлиқ үчүн кәфарәт кәлтүрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","У өлүкләр билән тирикләр оттурисида турувиди, ваба тохтиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Кораһниң вақиәси мунасивити билән өлгәнләрдин башқа, ваба сәвәвидин өлгәнләр он төрт миң йәттә йүз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Һарун җамаәт чедириниң дәрвазиси йенида турған Мусаниң йениға йенип кәлди; ваба тохтиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Сән Исраилларға сөз қилип, улардин ата җәмәти бойичә, һәр қәбилиниң әмридин бирдин он икки һаса алғин; сән уларниң һәр бириниң исмини өзиниң һасисиға йезип қойғин. ");
INSERT INTO uigcyr_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Лавий қәбилисиниң һасисиға Һарунниң исмини язғин, чүнки һәр бир ата җәмәт қәбилә башлиғи үчүн бир һаса вәкил болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Сән бу һасиларни җамаәт чедиридики һөкүм-гувалиқ сандуғиниң алдиға, йәни Мән сениң билән көрүшидиған йәргә қойғин.    ");
INSERT INTO uigcyr_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Вә шундақ болидуки, Мән таллиған кишиниң болса, униң һасиси бих сүриду; шундақ қилип Исраилларниң силәргә ғудурашқан гәплирини тохтитип Маңа аңланмайдиған қиливетимән». ");
INSERT INTO uigcyr_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Шуниң билән Муса Исраилларға шундақ сөз қилди; уларниң һәммә әмирлири униңға бирдин һасини, җәмий болуп он икки һасини бәрди; һәр бир ата җәмәткә бир һаса вәкил болди, Һарунниң һасисиму шуларниң ичидә еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Муса һасиларни һөкүм-гувалиқ чедириға әкирип Пәрвәрдигарниң һозуриға қойди. ");
INSERT INTO uigcyr_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Вә шундақ болдики, Муса әтиси һөкүм-гувалиқ чедириға киривиди, мана, Лавий җәмәтигә вәкил болған Һарунниң һасиси бих сүрүп, ғунчилап, чечәкләп, бадам чүшкән еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Муса һасиларниң һәммисини Пәрвәрдигарниң алдидин елип чиқип, Исраил хәлқигә көрсәтти; улар көргәндин кейин һәр ким өз һасилирини елип кетишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Пәрвәрдигар Мусаға: — Шу асийлиқ қилғучи балиларға бир агаһ бәлгүси болсун дәп Һарунниң һасисини һөкүм-гуваниң алдиға әкирип қойғин. Шундақ қилсаң сән уларниң ғудурашқан гәплирини тохтитип, Маңа аңланмайдиған қилисән; уларму шуниң билән өлүп кәтмәйду, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Муса шундақ қилди; Пәрвәрдигар өзигә қандақ буйруған болса у шундақ қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Исраиллар Мусаға сөз қилип: — Биз нәпәстин қалай дәватимиз, биз түгәштуқ, биз һәммимиз түгәштуқ! ");
INSERT INTO uigcyr_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Пәрвәрдигарниң ибадәт чедириға йеқинлашқанлар өлмәй қалмайду, шундақ екән, биз һәммимиз мутләқ нәпәстин қелишимиз керәкму? — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Пәрвәрдигар Һарунға мундақ деди: — Сән, оғуллириң вә ата җәмәтиңдикиләр сениң билән бирликтә муқәддәс җайға мунасивәтлик болған гунани, шуниңдәк сән вә оғуллириң бирликтә каһинлиқ вәзиписигә мунасивәтлик болған гунани үстүңларға алисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Сән қериндашлириң болған Лавий қәбилисидикиләрни, йәни ата-бовилириңниң қәбилисидикиләрни өзүң билән бирләштүр һәм уларни хизмитиңни қилиши үчүн башлап елип кәл; бирақ сән билән оғуллириң сениң билән бирликтә һөкүм-гувалиқ чедири алдида хизмәтләрни қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Улар сениң буйруқлириңға тәйяр туруп, шундақла чедирдики барлиқ хизмәт-вәзиписини өтәйду; пәқәт муқәддәс җайдики қача-қуча әсвапларға вә қурбангаһқа йеқинлашмисун; ундақ қилса, уларму, силәрму өлүп кетисиләр. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Улар сениң билән бирлишип, җамаәт чедиридики вәзипини өтәп, қилидиған һәр бир ишини қилсун; пәқәтла һеч ят кишиләр силәргә йеқинлашмисун. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Қәһр-ғәзәп йәнә Исраилларниң бешиға чүшмисун үчүн, силәр муқәддәс җайдики вәзипә билән қурбангаһдики вәзипини өтәшкә мәсъул болуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Мана, Мән Өзүм силәрниң қериндашлириңлар болған Лавийларни Исраиллар ичидин таллап чиқтим; улар җамаәт чедириниң ишлирини қилишқа Пәрвәрдигарға тәқдим қилинған болуп, силәргә соға сүпитидә ата қилинған. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Лекин сән вә оғуллириң сениң билән бирликтә каһинлиқ вәзипәңләрдә туруп, қурбангаһтики барлиқ ишларни һәм пәрдә ичидики ишларни беҗириңлар; силәрниң вәзипәңләр шундақ болсун. Каһинлиқ вәзиписини, хизмитимдә болушуңлар үчүн силәргә соға қилип бәрдим; ят адәмләр йеқинлашса, өлтүрүветилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Пәрвәрдигар Һарунға мундақ деди: — Мән Маңа сунулған көтәрмә һәдийәләрни, йәни Исраиллар Маңа муқәддәс дәп атиған барлиқ нәрсиләрни үлүшүңлар болсун дәп, мана мәңгүлүк бәлгүлимә билән саңа вә сениң әвлатлириңға тәқдим қилдим. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Исраиллар отта сунидиған, «әң муқәддәс» нәрсиләрдин силәргә мунулар қалдуруп берилиду: — уларниң Маңа атап сунған барлиқ нәрсилири, йәни барлиқ ашлиқ һәдийәлиридин, барлиқ гуна қурбанлиқлиридин, барлиқ итаәтсизлик қурбанлиқлиридин «әң муқәддәс» һесапланғанлири, саңа вә әвлатлириңға ата қилиниду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Сән шу үлүшүңни «әң муқәддәс» сүпитидә йегин, силәрдин болған һәр бир әр киши уни йесун; у саңа «әң муқәддәс» дәп билинсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Мунуларму сениң болиду: — Исраилларниң соғатлири ичидин көтәрмә һәдийәләр, барлиқ пулаңлатма һәдийәләр сениң; Мән уларни саңа, шундақла оғуллириң билән қизлириңға мәңгүлүк бәлгүлимә билән тәқдим қилдим; сениң өйүңдики һәр бир пак адәм униңдин йесә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Зәйтун мейидин әң есилини, йеңи шараптин әң есилини, шундақла ашлиқтин әң есилини, йәни Исраиллар Пәрвәрдигарға атап сунған дәсләпки пишқан мәһсулатларниң һәммисини Мән саңа тәқдим қилип бәрдим. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Улар йәрдин елип Пәрвәрдигарға атап әкәлгән дәсләпки пишқан нәрсиләрниң һәммиси сениң болсун; өйүңдики һәр бир пак адәм униңдин йесә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Исраилда Худаға мутләқ атилидиған һәр бир нәрсә сениң болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Улар Пәрвәрдигарға атап кәлтүридиған барлиқ җаниварларниң тунҗилири, мәйли инсан яки улақ-чарпай болсун сениң болиду; һалбуки, инсанларниң тунҗилирини болса уларни төләм төләп яндурувалсун вә напак һайванларниң тунҗилирини төләм төләп яндурувалсун.    ");
INSERT INTO uigcyr_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Төләм төләш керәк болғанлар үчүн йеши бир айлиқтин ашқанда төләм пули төләнсун; уларға сән тохтатқан баһа бойичә, йәни муқәддәс җайдики шәкәлниң өлчәм бирлиги бойичә (бир шәкәл жигирмә гәраһдур) баһа қоюп, бәш күмүч шәкәл ал. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Пәқәт тунҗа кала, тунҗа қой яки тунҗа оғлаққа төләм алсаң болмайду; уларниң һәммиси муқәддәстур. Сән уларниң қенини қурбангаһқа чечип, мейини Пәрвәрдигарға атап отта сунулидиған, Униңға хушбуй кәлтүридиған қурбанлиқ сүпитидә көйдүргин. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Уларниң гөши сениң болиду; худди «көтәрмә һәдийә» қилинған төш вә оң арқа путиға охшаш, саңа тәвә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Исраиллар Пәрвәрдигарға атап сунған муқәддәс нәрсиләр ичидики көтәрмә һәдийә-қурбанлиқниң һәммисини Мән саңа вә сениң билән биллә туруватқан оғул-қизлириңға мәңгүлүк бәлгүлимә билән тәқдим қилдим. Бу Пәрвәрдигар алдида сән вә сениң билән биллә туруватқан әвлатлириң үчүн мәңгүлүк тузлуқ әһдә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Пәрвәрдигар Һарунға мундақ деди: — Исраил зиминида сениң һеч қандақ мирасиң болмайду, уларниң арисидиму һеч қандақ несивәң болмайду; Исраиллар арисида мана Мән Өзүм сениң несивәң, сениң мирасиңдурмән. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Лавийларға болса, уларниң өтәйдиған хизмәтлири, йәни җамаәт чедиридики хизмити үчүн, мана Мән Исраилда тәқдим қилинған барлиқ «ондин бир үлүш»ниң һәммисини уларға мирас қилип бәргәнмән. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Буниңдин кейин, гунакар болуп өлүп кәтмәслиги үчүн, Исраиллар җамаәт чедириға йеқинлашмисун. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Җамаәт чедиридики хизмәтни болса, уни өтигүчиләр пәқәт Лавийларла болиду вә шу ишта болған гунайини өзлири үстигә алиду, бу силәр үчүн әвлатму-әвлат мәңгүлүк бир бәлгүлимә болиду; уларниң Исраилларниң ичидә һеч қандақ мираси болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Чүнки Исраилларниң Пәрвәрдигарға атап көтәрмә һәдийә сүпитидә сунған «ондин бир үлүши»ни Лавийларға мирас қилип тәқдим қилидиған болдум; шуңа Мән улар тоғрилиқ: Исраиллар ичидә һеч қандақ мираси болса болмайду, — дедим. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Сән Лавийларға ейтқин: «Силәр Исраилларниң қолидин Мән силәргә мирас болсун дәп тәқдим қилған «ондин бир үлүш»ни алған екәнсиләр, силәр шу ондин бир үлүшниң йәнә ондин бир үлүшини айрип, уни Пәрвәрдигарға атап көтәрмә һәдийә сүпитидә сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Бу йол билән силәрниң шу «көтәрмә һәдийә»ңлар силәргә «хамандики ашлиғиңлар»дин һәм «шарап көлчигидики толуп ташқан шарабиңлар»дин аталғанлар һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Бундақ болғанда, силәр Исраилларниң қолидин алған ондин бир үлүшниң һәммисидин Пәрвәрдигарға атап көтәрмә һәдийә сунисиләр; силәр Пәрвәрдигарға атиған шу «көтәрмә һәдийә»ни каһин Һарунға бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Силәргә тәқдим қилинған барлиқ нәрсиләрдин әң есилини елип шуларни муқәддәс һесаплап «Пәрвәрдигарға аталған толуқ көтәрмә һәдийә» сүпитидә сунуңлар». ");
INSERT INTO uigcyr_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Шуңа сән Лавийларға ейтқинки, «Силәр шулардин әң есилини көтирип сунсаңлар, бу силәр Лавийларниң хамандики ашлиғиңлар вә шарап көлчигидики шарабиңларға охшаш һесаплиниду. ");
INSERT INTO uigcyr_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Шундақ қилғандин кейин силәр вә өйдикилириңлар шу «ондин бир үлүш»ләрни халиған йәрдә йесәңлар болиду, чүнки бу силәрниң җамаәт чедиридики хизмитиңларниң инъами болиду; ");
INSERT INTO uigcyr_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Силәр шу үлүшләрдин әң есилини көтирип сунсаңлар, мошу ишиңлар сәвәвидин гунакар болмайсиләр. Ундақ қилсаңлар силәр Исраиллар атиған муқәддәс нәрсиләрни булғимайсиләр, шуниң билән өлмәйсиләр». ");
INSERT INTO uigcyr_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Пәрвәрдигар Муса билән Һарунға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Мән Пәрвәрдигар әмир қилған қанун-бәлгүлимә шуки: — Сән Исраилларға буйруғин, улар беҗирим, нуқсансиз, боюнтуруқ селинмиған қизил яш сийирдин бирни сениң йениңға әкәлсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Сән сийирни каһин Әлиазарға тапшур, у уни чедиргаһниң сиртиға әпчиқсун, андин бириси сийирни униң алдида боғузлисун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Каһин Әлиазар бармиғини қанға миләп, җамаәт чедириниң алдиға қаритип йәттә мәртәм чачсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Андин бириси Әлиазарниң көз алдида пүткүл сийирни көйдүрсун, йәни униң териси, гөши, қени вә тезәклирини көйдүрсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Каһин кедир яғичи, зофа өсүмлүги вә қизил рәхтни сийир көйдүрүлидиған отқа ташлисун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Андин каһин өз кийимини жуйсун вә бәдинини суда жуйсун, андин кейин баргаһқа киришкә болиду; лекин каһин кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Сийирни көйдүргән кишиму кийимлирини су билән жуюп, өз бәдинини суда жуйсун, андин у кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Пак бир адәм сийирниң күлини жиғип баргаһниң сиртидики пак бир йәргә қойсун; у Исраил җамаити үчүн «напаклиқни чиқарғучи су»ни ясашқа шу йәрдә сақлансун, у бир «гунани паклиғучи»дур. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Сийирниң күлини жиғиштурған адәм өзиниң кийимлирини жуйсун вә кәч киргичә напак саналсун. Бу Исраилларға вә уларниң арисида туруватқан мусапирларға мәңгүлүк қанун-бәлгүлимә болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","— Өлүккә, йәни һәр қандақ өлгән кишиниң җәситигә тегип кәткән һәр бир киши йәттә күн напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","У адәм үчинчи күни ашу су билән өзини паклисун, һәмдә йәттинчи күниму паклисун, андин у пак санилиду; әгәр у үчинчи күни һәмдә йәттинчи күни өзини паклимиса, пак саналмайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Һәр қандақ адәм өлүккә, йәни һәр қандақ өлгән кишиниң җәситигә тегип кәтсә, һәмдә өзини паклимиса, Пәрвәрдигарниң чедирини булғиған болиду; шу киши Исраил арисидин үзүп ташлиниду; чүнки «напаклиқни чиқарғучи су» униңға сепилмигәчкә, у напак санилиду; униң напаклиғи техичә үстидә туриду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Әгәр бирәр киши бир чедир ичидә өлүп қалған болса, у тоғрилиқ қанун-бәлгүлимә мундақ болиду: — шу чедирға киргән һәр бирси вә чедирда туруп қалғанларниң һәр бири йәттә күн напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Һәр бир очуқ турған, ағзи йепилмиған қача-қучиларниң һәммиси напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Шуниңдәк далада қилич-шәмшәр билән өлтүрүлгәнләргә, яки өзи өлүп қалғанниң өлүгигә, яки адәмниң устихининиға яки қәбригә тәккән һәр бир киши йәттә күнгичә напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Кишиләр бу напак киши үчүн «пакландурғучи қурбанлиқ»ниң күлидин азрақ елип комзәккә селип, уларниң үстигә еқин су қуйсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Андин пак бир киши зофа өсүмлүгини елип шу суға тәккүзүп уни чедирға вә ичидики барлиқ қача-қучиларға һәм шу йәрдә турған барлиқ кишиләрниң үстигә сепип қойсун, вә йәнә уни устиханға, өлтүрүлгүчигә яки қәбиргә тәккән кишиниң үстигә сепип қойсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Үчинчи күни вә йәттинчи күни һелиқи пак адәм пак болмиған адәмләрниң үстигә шу суни сепип қойсун; шундақ қилғанда, йәттинчи күнигә кәлгәндә у киши пакланған болиду; андин у киши кийимлирини жуюп, бәдинини суда жуйсун, кәч киргәндә у пак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Лекин напак болуп қелип, өзини паклимиған киши Пәрвәрдигарниң муқәддәс җайини булғиғини үчүн, җамаәт арисидин үзүп ташлиниду; «напаклиқни чиқарғучи су» униң үстигә сепилмигән, шуңа у напак санилиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Бу Исраилларға мәңгүлүк бәлгүлимә болиду, «напаклиқни чиқарғучи су»ни сәпкән киши болса өзиниң кийимлирини жуйсун вә «напаклиқни чиқарғучи су»ға тәккән киши кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Напак киши тәккән һәр қандақ нәрсиму напак санилиду; бу нәрсиләргә тәккән кишиләрму кәч киргичә напак саналсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Биринчи айниң ичидә Исраиллар, йәни пүткүл Исраил җамаити Зин чөлигә йетип келип, Қадәштә туруп қалди; Мәрйәм шу йәрдә вапат болди вә шу йәргә дәпнә қилинди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Җамаәткә ичидиғанға су йоқ еди, улар жиғилип Муса билән Һарунға һуҗум қилғили турди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Хәлиқ Муса билән тәгишип: — Қериндашлиримиз Пәрвәрдигарниң алдида өлгән чағда бизму биллә өлсәк боптикән! ");
INSERT INTO uigcyr_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Силәр немә үчүн биз вә чарпайлиримизни бу йәрдә өлүп кәтсун дәп, Пәрвәрдигарниң җамаитини бу чөл-җәзиригә башлап кәлдиңлар? ");
INSERT INTO uigcyr_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Силәр немә үчүн бизни Мисирдин елип чиқип бундақ дәһшәтлик йәргә әкәлдиңлар? Бу йәрдә я териқчилиқ қилғили йәр болмиса, я әнҗир, үзүм, анар болмиса, ичидиғанға суму болмиса, — дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Шуниң билән Муса билән Һарун җамаәттин айрилип җамаәт чедириниң дәрвазиси алдиға келип дүм жиқиливиди, Пәрвәрдигарниң җуласи у иккисигә аян болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Һасини қолуңға ал, андин сән акаң Һарун билән бирликтә җамаәтни жиғип, уларниң көз алдидила қорам ташқа буйруқ қил; шундақ қилсаң қорам таш өз сүйини чиқириду; шу йол билән сән уларға су чиқирип, җамаәт вә чарпайлири ичидиғанға су берисән.    ");
INSERT INTO uigcyr_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Шуниң билән Муса Пәрвәрдигарниң әмри бойичә Пәрвәрдигарниң һозуридин һасини алди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Муса билән Һарун иккиси җамаәтни қорам ташниң алдиға жиғди вә Муса уларға: — Гепимгә қулақ селиңлар, и асийлар! Биз силәргә бу қорам таштин су чиқирип берәйлиму?! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Андин Муса һасиси билән қорам ташни икки қетим урувиди, наһайити көп су еқип чиқти, судин җамаәтму, чарпайларму ичишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Пәрвәрдигар Муса билән Һарунға: — Силәр Маңа ишәнмәй, Исраиллар алдида Мени муқәддәс дәп һөрмәтлимигиниңлар үчүн, иккиңларниң бу җамаәтни Мән уларға тәқдим қилип бәргән зиминға башлап киришиңларға йол қоймаймән, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Су чиқирилған җай «Мәрибаһ сулири» дәп аталған; Исраиллар шу йәрдә Пәрвәрдигар билән такаллашқанлиғи үчүн, У уларниң оттурисида Өзиниң муқәддәс екәнлигини көрсәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Муса Қадәштин Едом падишаси билән көрүшүшкә әлчи әвәтип униңға: «Қериндашлири Исраил мундақ дәйду: — Биз тартиватқан җәбр-җапаларниң қандақлиғи өзлиригә мәлум, ");
INSERT INTO uigcyr_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","бизниң ата-бовилиримиз Мисирға чүшкән болуп, биз Мисирда узақ заман туруп кәттуқ; мисирлиқлар бизгиму, бизниң ата-бовилиримизғиму яман муамилә қилди; ");
INSERT INTO uigcyr_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","биз Пәрвәрдигарға йелиниведуқ, У бизниң заримизға қулақ селип, Пәриштә әвәтип бизни Мисирдин елип чиқти. Һазир мана, биз өзлириниң чегарисиға җайлашқан Қадәш дегән бир шәһәрдә туруватимиз.    ");
INSERT INTO uigcyr_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Әнди бизниң зиминлиридин өтүшимизгә рухсәт қилған болсила, биз етиз-ериқ вә үзүмзарлиқлардин өтмәймиз, қудуқлириңладин суму ичмәймиз; «Хан йоли» билән меңип чегарилиридин өтүп кәткичә оң-солға бурулмаймиз» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Лекин Едомлар униңға: «Силәрниң бизниң зиминимиздин өтүшүңләргә болмайду, өтимән десәңлар қилич көтирип силәргә җәңгә чиқимиз» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Исраиллар униңға: «Биз «көтирилгән йол» билән маңимиз, өзимиз вә маллиримиз сүйүңларни ичсәк, нәрхи бойичә һәққини беримиз; биз пәқәт пиядә өтүп кетимиз, башқа һеч тәливимиз йоқ» девиди, ");
INSERT INTO uigcyr_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Едом падишаси: «Яқ. Өтмәйсиләр!» деди. Едом падишаси наһайити көп адимини башлап чиқип Исраилларға зор һәйвә көрсәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Шундақ қилип Едомлар Исраилларниң уларниң тәвәлигидин өтүшигә әнә шу йосунда йол қоймиди; шуниң билән Исраиллар Едомларниң алдидин бурулуп кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Улар Қадәштин йолға чиқти; пүткүл Исраил хәлқи Һор теғиға кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Пәрвәрдигар Едомниң чегарисидики Һор теғида Муса билән Һарунға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Һарун өз хәлиқлиригә қошулуп кетиду; иккиңлар Мәрибаһ сулири дегән җайда Мениң әмримгә хилаплиқ қилғиниңлар үчүн, униң Мән Исраилларға тәқдим қилип бәргән зиминға киришигә болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Сән Һарун билән оғли Әлиазарни елип Һор теғиға чиққин; ");
INSERT INTO uigcyr_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Һарунниң кийимлирини салдуруп, оғли Әлиазарға кийдүрүп қой; Һарун шу йәрдә өлүп, өз хәлиқлиригә қошулиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Муса Пәрвәрдигарниң дегинидәк қилди, үчәйлән пүткүл җамаәтниң көз алдида Һор теғиға чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Муса Һарунниң кийимлирини салдуруп униң оғли Әлиазарға кийдүрүп қойди; Һарун тағниң чоққисида өлди. Андин Муса билән Әлиазар тағдин чүшүп кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Пүткүл җамаәт Һарунниң өлгәнлигини билди; шуниң билән пүтүн Исраил җәмәти Һарун үчүн оттуз күн матәм тутти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Җәнупта турушлуқ Арад мәмликитиниң Ⱪананийлардин болған падишаси Исраилларниң Атарим йоли билән келиватқанлиғини аңлап, чиқип улар билән соқушуп, нәччәйләнни тутқун қилип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Андин Исраиллар Пәрвәрдигарға қәсәм ичип: «Әгәр бу хәлиқни бизниң қолимизға пүтүнләй тапшуридиған болсаң, уларниң шәһәрлирини вәйран қилип ташлаймиз» — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Пәрвәрдигар Исраилларниң пәрядини аңлап, Қанаанлийларни уларниң қолиға тапшурди, шуниң билән улар Ⱪананийларни уларниң шәһәрлири билән қошуп вәйран қилди; шу сәвәптин улар шу йәрни «Хормаһ» дәп атиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Улар Һор теғидин йолға чиқип, Едом зиминини айлинип өтүш үчүн, Қизил Деңиз бойидики йолни бойлап маңди; хәлиқ мошу йол сәвәвидин көңлидә толиму тақәтсиз болуп, ");
INSERT INTO uigcyr_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Худаға вә Мусаға қарши чиқип: — Силәр немә үчүн бизни чөл-җәзиридә өлсун дәп Мисир зиминидин башлап чиққансиләр? Бу йәрдә я ашлиқ, я су йоқ, көңлимиз бу әрзимәс нанлардин бизар болди, дейишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Шу сәвәптин Пәрвәрдигар уларниң арисиға зәһәрлик иланларни әвәтти; иланлар уларни чақти, шу сәвәптин Исраиллардин нурғун адәм өлүп кәтти.    ");
INSERT INTO uigcyr_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Хәлиқ Мусаниң алдиға келип униңға: — Биз ағзимизни бузуп, Пәрвәрдигарға һәм саңа һуҗум қилип, яман гәп қилип гуна қилдуқ; Пәрвәрдигарға тилавәт қилсаң, у бу иланларни аримиздин елип кәткәй, — девиди, Муса хәлиқ үчүн дуа қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Пәрвәрдигар Мусаға: — Сән бир зәһәрлик иланниң шәклини ясап хадиға есип қойғин; илан чеқивалған һәр бири униңға қарисила қайта һаятқа еришиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Муса мистин бир илан яситип хадиға есип қойди; вә шундақ болдики, илан биркимни чеқивалған болса, у бу мис иланға қарисила, улар һаят қалди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Исраиллар йәнә йолға чиқип Оботқа келип чедир тикти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Йәнә Оботтин йолға чиқип, Моаб зимининиң удулида күн чиқиш тәрәптики Ийә-Ибаримға келип чедир тикти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Улар йәнә у йәрдин йолға чиқип Зәрәд җилғисида чедир тикти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Йәнә у йәрдин меңип Аморийларниң зимининиң четидин чиқип чөл-баявандин өтүп, еқип турған Арнон дәриясиниң у қетида чедир тикти (чүнки Арнон дәрияси Моабийларниң чегариси болуп, Моабийлар билән Аморийларниң оттурисида еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","15","Шуңа «Пәрвәрдигарниң җәңнамиси» дегән китапта: — «Суфаһдики Ваһәб вә дәрия-вадилири, Арнон дәрияси вә җилғилириниң янбағирлири, Арниң туралғусиғичә йетип, Моабниң чегарисиға чүшиду» дәп пүтүлгән еди). ");
INSERT INTO uigcyr_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Исраиллар йәнә у йәрдин меңип Бәәргә кәлди; «Бәәр» қудуқ дегән мәнада болуп, илгири Пәрвәрдигар Мусаға: «Сән хәлиқни жиғ, Мән уларға ичидиған су берәй» дегәндә шу қудуқни көздә тутқан. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Шу чағда Исраиллар муну нахшини ейтишқан: — «Аһ қудуқ, чиқсун сүйүң булдуқлап, Нахша ейтиңлар, қудуққа беғишлап: ");
INSERT INTO uigcyr_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Бу қудуқни әмирләр, Хәлиқниң каттилири қазған, Қанун чиқарғучиниң сөзи билән, Һасилири билән қазған». Исраиллар чөл-баявандин йәнә Маттанаһқа, ");
INSERT INTO uigcyr_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Маттанаһтин Наһалийәлгә, Наһалийәлдин Бамотқа, ");
INSERT INTO uigcyr_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Бамоттин Моаб даласидики җилғиға, йәнә чөл-баяван тәрәпкә қарап турған Писгаһ теғиниң чоққисиға йетип барди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Исраиллар Аморийларниң падишаси Сиһонниң алдиға әлчиләрни әвәтип:    ");
INSERT INTO uigcyr_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","— Бизниң өз зиминлиридин өтүвелишимизгә иҗазәт бәргәйла; биз силиниң етизлиқлириға вә үзүмзарлиқлириға кирмәймиз, қудуқлиридин суму ичмәймиз; тәвәлиридин өтүп кәткичә «Хан йоли»дин чиқмаймиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Сиһон Исраилларни өз чегарисидин өткили қоймайла қалмастин, әксичә у Исраиллар билән соқушимән дәп, өзиниң барлиқ хәлқини жиғип чөлгә қарап атланди. У Яһазға келип Исраилға һуҗум қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Исраиллар уни қилич билән чепип өлтүрүп, униң жутини Арнон дәриясидин Яббок дәриясиғичә, йәни Аммонийларниң чегарисиғичә егилиди; Аммонийларниң чегариси болса бәк мустәһкәм еди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Исраиллар бу йәрдики һәммә шәһәрни егилиди һәм Аморийларниң шәһәрлиригә, йәни Һәшбонға вә униңға тәвә барлиқ йеза-қишлақларғиму кирип орунлашти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Чүнки Һәшбон әслидә Аморийларниң падишаси Сиһонниң мәркизий шәһири еди; Сиһон әслидә Моабниң илгәрки падишаси билән соқушқан, униң Арнон дәриясиғичә болған һәммә зиминини тартивалған еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Шу сәвәптин шаирлар: — «Һәшбонға келиңлар! Мана Сиһонниң шәһири яңливаштин қурулсун, Сиһонниң шәһири мәһкәм қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Чүнки Һәшбонниң өзидин чиқти бир от, Сиһонниң шәһиридин бир ялқун ялқунлап, Жутувәтти Моабтики Ар шәһирини, Арнондики егиз җайларниң әмирлирини. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Вай саңа әй Моаб! Һәй Кемошниң үммити, түгәштиңлар! Чүнки Кемош өз оғуллирини қачқунға айландурди, Қизлирини әсирликкә берип, Аморийларниң падишаси Сиһонға тутуп бәрди!    ");
INSERT INTO uigcyr_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Биз уларни жиқитивәттуқ, Һәшбон таки Дибонғичә һалак болди; Биз һәтта Нофаһқичә (Нофаһтин Мәдәбаға йетиду) уларниң жутини вәйран қиливәттуқ!» — дәп шеир йезишқан еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Шуниң билән Исраиллар әнә шу тәриқидә Аморийларниң жутиға орунлашти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Муса Яазәрни чарлап келишкә чарлиғучиларни әвәтти; андин Исраиллар Яазәрниң йеза-қишлақлирини ишғал қилип, у йәрләрдики Аморийларни йеридин қоғливәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Шуниңдин кейин Исраиллар бурулуп, Башанниң йолини бойлап маңди; Башанниң падишаси Ог вә униң барлиқ хәлқи чиқип Әдрәйдә Исраиллар билән җәң қилишқа сәп түзди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Пәрвәрдигар Мусаға: — Қорқма, Мән уни, униң барлиқ хәлқи һәм зиминини қолуңға тапшуримән; сән уни илгири Һәшбонда турушлуқ Аморийларниң падишаси Сиһонни қилғандәк қилисән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Шуниң билән улар Ог билән униң оғуллирини һәм барлиқ хәлқиниң бирини қоймай қирип ташлиди вә униң зиминини егилиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Исраиллар йәнә йолға чиқип Моаб түзләңликлиридә, йәни Иордан дәриясиниң шәриқ тәрипидә, Йерихониң удулида чедир тикти. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Исраилларниң Аморийларға қилған ишлириниң һәммисини Зиппорниң оғли Балақ көрүп турған еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Моабийлар хәлиқтин интайин қорқушти, чүнки улар бәк көп еди; Моабийлар Исраилларниң сәвәвидин бәк алақзадә болуп кетишти. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Моабийлар Мидиян ақсақаллириға: «Бу бир топ адәм әтрапимиздики һәммә нәрсини, худди кала етиздики отни ялмиғандәк ялмап йәп кетидиған болди» — дейишти. У чағда Зиппорниң оғли Балақ Моабниң падишаси еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","У әлчиләрни Беорниң оғли Балаамниң алдиға, Балаамниң ана жутидики улуқ дәрия бойидики Петор шәһиригә берип, Балаамни чақирип келишкә әвәтип: падишасимиз: — «Қарисила, бир хәлиқ Мисирдин чиққан еди; мана, улар пүтүн зиминға ямрап кәтти, мана улар бизниң удулимизға келип чүшти.    ");
INSERT INTO uigcyr_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Улар мениңдин күчлүк болғачқа, әнди өзлири келип бу хәлиқни мән үчүн бир қарғап бәргән болсила; бәлким мән уларни йеңип, бу зиминдин қоғлап чиқиришим мумкин; чүнки өзлири кимгә бәхит тилисилә шуниң бәхит қучидиғанлиғини, кимни қарғисила, шуниң қарғишқа қалидиғанлиғини билимән» дәйду, дәңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Моабниң ақсақаллири билән Мидиянниң ақсақаллири қоллирида пал селиш инъамлирини елип маңди; улар Балаамниң алдиға келип Балақниң гәплирини йәткүзди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Балаам уларға: — Бүгүн ахшам мошу йәрдә қонуп қелиңлар, мән Пәрвәрдигарниң маңа қилған сөзи бойичә силәргә җавап йәткүзимән, — деди. Шуниң билән Моабниң шу әмирлири Балаамниңкидә қонуп қалди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Худа Балаамниңкигә келип: — Сениң билән биллә турған бу адәмләр ким? — девиди, ");
INSERT INTO uigcyr_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Балаам Худаға: — Моаб падишаси Зиппорниң оғли Балақ әлчиләрни әвәтип маңа: ");
INSERT INTO uigcyr_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","«Қарисила, Мисирдин бир хәлиқ чиққан еди, улар пүтүн зиминға ямрап кәтти; бу йәргә келип мениң үчүн уларни қарғап бәрсилә, шундақ қилсила бәлким уларни йеңип, бу йәрдин қоғливетәлишим мумкин» — деди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Худа Балаамға: Сән улар билән биллә барсаң болмайду, у хәлиқни қарғисаңму болмайду, чүнки уларға бәхит-бәрикәт ата қилинған, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Балаам әтигән туруп Балақниң әмәлдарлириға: — Силәр өз жутуңларға қайтип кетиңлар, чүнки Пәрвәрдигар мениң силәр билән биллә беришимға рухсәт қилмиди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Моабниң әмәлдарлири қопуп Балақниң йениға келип униңға: — Балаам биз билән биллә келишкә унимиди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Шуниң билән Балақ техиму көп вә техиму мөтивәр әмәлдарларни әвәтти, ");
INSERT INTO uigcyr_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Улар Балаамниң алдиға келип униңға: — Зиппорниң оғли Балақ мундақ дәйду: — «Һеч немә силиниң йенимға келишлирини тосмиғай; ");
INSERT INTO uigcyr_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","чүнки мән өзлирини зор шан-шөһрәткә егә қилимән; немә десилә мақул дәймән; шуңа маңа әшу хәлиқни қарғап бәрсилила болиду», — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Балаам Балақниң хизмәткарлириға җававән: — Балақ маңа өзиниң алтун-күмүчкә лиқ толған өз өйини бәрсиму, мәйли чоң яки кичик иш қилай, Худайим Пәрвәрдигарниң маңа буйруғанлиридин һалқип кетәлмәймән. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Силәрму бүгүн ахшам мошу йәрдә қонуп қелиңлар, Пәрвәрдигар йәнә шу ишлар тоғрисида маңа немә дәйдикин, шуни биләй, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Шу кечиси Худа Балаамниңкигә келип униңға: — У кишиләр сени тәклип қилип кәлгән болса, улар билән биллә барғин, лекин сән Мениң саңа ейтидиғанлирим бойичә иш қилишиң керәк, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Балаам әтигән туруп ешигини тоқуп Моабниң әмирлири билән биллә маңди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Худа Балаамниң маңғанлиғидин ғәзәпләнди; Пәрвәрдигарниң Пәриштиси уни тосушқа йолда туратти. У шу чағда ешигигә минип икки ғулами билән биллә кетивататти. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Мада ешәк Пәрвәрдигарниң Пәриштисиниң қолиға қилич алған һалда йолда турғанлиғини көрүп, йолдин чиқип етизлиқ билән меңивиди, Балаам ешәкни йолға чиқип меңишқа думбалап урди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Пәрвәрдигарниң Пәриштиси икки тәрипи тосма там билән тосулған үзүмзарлиқтики тар бир йолда турувалди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ешәк Пәрвәрдигарниң Пәриштисини көрүп, тамға қистилип меңип, Балаамниң путини тамға қистап яриландуруп қойди; Балаам ешәкни йәнә думбалиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Пәрвәрдигарниң Пәриштиси болса йәнә алдиғирақ берип, оң я солға бурулушқа болмайдиған техиму тар бир йәрдә күтүп турди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ешәк Пәрвәрдигарниң Пәриштисини көрүп маңмай, Балаамниң астида йетивалди; Балаам қаттиқ хапа болуп, ешәкни һасиси билән қаттиқ думбалап кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Бу чағда Пәрвәрдигар ешәккә зуван киргүзүвиди, ешәк Балаамға: — Мени үч қетим думбалайдиғанға саңа немә яманлиқ қиптимән? — девиди, ");
INSERT INTO uigcyr_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Балаам ешәккә: — Сән мени сәтләштүрдүң, қолумда қилич болған болса еди, сени чепип өлтүрүветәттим! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ешәк Балаамға: — Мән сениңки болғинимдин тартип минип кәлгән ешигиң мән әмәсму? Илгири мән саңа мошундақ қилиш адитим болуп баққанму? — девиди, — Яқ, — деди Балаам. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Әнә шу чағда Пәрвәрдигар Балаамниң көзлирини ачти, Балаам Пәрвәрдигарниң Пәриштисиниң қиличини ғилипидин чиқирип, йолда турғанлиғини көрди; у йәргә бешини қоюп сәҗдә қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Пәрвәрдигарниң Пәриштиси униңға: — Сән ешигиңни немә үчүн үч қетим думбалайсән? Қариғина, маңған йолуң Мениң нәзиримдә тәтүр болғачқа, сени тосушқа чиққучи Мән Өзүм едим. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ешәк Мени көрүп үч қетим Мениң алдимдин бурулуп кәтти; әгәр ешәк Мениң алдимдин бурулуп кәтмигән болса, Мән аллиқачан сени өлтүрүп ешәкни тирик қалдурған болаттим, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Балаам Пәрвәрдигарниң Пәриштисигә: — Мән гунакармән, Өзлириниң йолда мени тосуп турғанлиқлирини көрмәптимән; мабада әнди мениң беришим нәзәрлиридә рәзил көрүнсә, мән қайтип кетәй, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Пәрвәрдигарниң Пәриштиси Балаамға йәнә: — Бопту, бу кишиләр билән биллә барғин, бирақ пәқәт Мән саңа дегән сөзнила дегин, — деди. Шуниң билән Балаам Балақниң әмәлдарлири билән биллә маңди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Балақ Балаамни келиветипту дәп аңлап, қарши елиш үчүн Моабниң Арнон дәриясиниң бойидики, чегариниң әң бешидики шәһиригә кәлди: ");
INSERT INTO uigcyr_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","— Мән силини чақиришқа шунчә җиддий әлчи әвәткән едим, немә үчүн келишкә унимидила? Мән силини шан-шөһрәткә егә қилалмайттимму? — деди Балақ Балаамға. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","— Қарисила, мана кәлдимғу, әнди мән өз алдимға бир немә дейәләйттимму? — деди Балаам, — Худа ағзимға немә гәпни салса, мән шунила дәймән. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Балаам Балақ билән биллә йолға чиқип Кириат-Хузотқа кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Балақ кала, қойларни союп қурбанлиқ қилип, уларниң гөшидин Балаам вә униң билән биллә болған әмирләргә әвәтип бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Андин Балақ әтиси сәһәрдә Балаамни Баалниң егиз җайлириға елип чиқти; у шу йәрдин Исраил хәлқиниң әң чәттики бир қисмини көрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Балаам Балаққа: — Сили мошу йәргә маңа йәттә қурбангаһ яситип бәрсилә, мошу йәргә йәнә йәттә буқа билән йәттә қошқарму һазирлап бәрсилә, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Балақ Балаамниң дегинидәк қилип бәрди; Балақ билән Балаам иккиси һәр бир қурбангаһқа қурбанлиқ қилишқа бирдин буқа билән бирдин қошқар сунди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Балаам Балаққа: — Сили өз көйдүрмә қурбанлиқлириниң йенида турсила, мән алдиға баримән, Пәрвәрдигар мениң билән көрүшүшкә келәмдикин? У маңа немә дәп көрсәтмә бәрсә, мән өзлиригә шуни дәп беримән, — деди вә бир дөңгә чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Худа Балаам билән көрүшти; Балаам Худаға: — Мән йәттә қурбангаһ һазирлаттим, һәр бир қурбангаһқа қурбанлиқ сүпитидә бирдин буқа билән бирдин қошқар сундум, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Пәрвәрдигар Балаамниң ағзиға бир сөзни селип: — Балақниң йениға қайтип берип униңға мундақ, мундақ дегин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Шуниң билән у Балақниң йениға қайтип барди. Мана, у вә Моабниң барлиқ әмирлири униң көйдүрмә қурбанлиғиниң йенида туратти. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Балаам калам сөзини ағзиға елип мундақ деди: — Балақ мени Арам дегән жуттин, Моаб шаһи Балақ мени мәшриқ тағлиридин елип келип, Мундақ деди: — Кәл, мениң үчүн Яқупни қарғиғин. Кәл, Исраилни раса бир сөкүп әйиплигин. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Тәңри Өзи қарғимиған бирәвни мән қандақ қарғай? Пәрвәрдигар Өзи сөкүп әйиплимигән бирәвни мән қандақ сөкүп әйипләй? ");
INSERT INTO uigcyr_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Мән қорам ташларниң чоққилирида туруп уни көрмәктимән, Дөңләрдә туруп униңға нәзәр салмақтимән; Мана, улар йәккә яшайдиған бир қовм, Улар башқа қовмларниң қатарида саналмайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Яқупниң топилирини ким һесаплап чиқалайду? Һәтта Исраилниң төрттин бириниму ким санап чиқалайду? Мениң җеним һәққанийниң өлүмидәк өлсун, Мениң ахирим униңкидәк болғай! ");
INSERT INTO uigcyr_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Балақ Балаамға қарап: — Сән маңа немә қиливатисән?! Мән сени дүшмәнлиримни қарғап беришкә чақиритқан турсам, мана сән әксичә пүтүнләй уларға амәт тилидиң! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","— Пәрвәрдигарниң ағзимға салғинини йәткүзүшкә көңүл қоймисам боламти? — дәп җавап бәрди Балаам. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Балақ Балаамға: — Мениң билән биллә башқа бир йәргә барсила, уларни шу йәрдин көрәләйла; бирақ уларниң һәммисини әмәс, уларниң чегаридики бир қисминила көрәләйла; сили шу йәрдә туруп уларни мән үчүн қарғап бәрсилә, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Шуниң билән Балақ Балаамни «Зофимниң даласи»ға, Писгаһ теғиниң чоққисиға башлап берип, шу йәрдә йәттә қурбангаһ салдуруп, һәр бир қурбангаһқа қурбанлиқ сүпитидә бирдин буқа, бирдин қошқар сунди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Балаам Балаққа: — Сили мошу йәрдә өзлириниң көйдүрмә қурбанлиқлириниң йенида туруп турсила, мән аву яққа берип көрүшүп келәй, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Пәрвәрдигар Балаам билән көрүшүп, униң ағзиға бир сөзни селип: — Сән Балақниң йениға қайтип униңға мундақ, мундақ дегин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Балаам Балақниң йениға қайтип кәлгәндә, мана, у вә Моабниң барлиқ әмирлири униң көйдүрмә қурбанлиғиниң йенида туратти. — Пәрвәрдигар немә деди? — дәп сориди Балақ. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Балаам калам сөзини ағзиға елип мундақ деди: — «Һәй Балақ, сән қопуп аңлиғин, Аһ , Зиппорниң оғли, маңа қулақ салғин. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Тәңри инсан әмәстур, У ялған ейтмайду, Яки адәм балисиму әмәстур, У пушайман қилмайду. У дегән екән, ишқа ашурмай қаламду? У сөз қилған екән, вуҗудқа чиқармай қаламду? ");
INSERT INTO uigcyr_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Мана, маңа «бәрикәтлә» дәп тапшурулди, У бәрикәтлигән екән, буни мән яндуралмаймән. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","У Яқупта һеч гуна көрмигән, Исраилда наһәқлиқни учратмиған. Худаси Пәрвәрдигар униң билән биллә, Падишаһниң тәнтәнә авази униң арисидидур.    ");
INSERT INTO uigcyr_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Тәңри уни Мисирдин елип чиққан; Униңда явайи калиниңкидәк күч бардур.    ");
INSERT INTO uigcyr_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Чүнки Яқупларға әпсун карға кәлмәйду, Исраилларғиму пал карға кәлмәйду. Вақти-саити кәлгәндә, Яқуп билән Исраил тоғрисида: — «Тәңри нәқәдәр карамәт иш қилип бәргән-һә!» Дәп җакаланмай қалмайду! ");
INSERT INTO uigcyr_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Мана, бу қовм чиши ширдәк қопиду, Әркәк ширдәк қәддини руслайду; Өзи овлиған овни йемигичә, Өлтүргәнләрниң қенини ичмигичә, Һәргиз ятмайду!». ");
INSERT INTO uigcyr_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Балақ Балаамға: — Болди, сили уларни азрақму қарғимисила, уларға амәтму тилимисилә! — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Балаам Балаққа җавап қилип: — Мән силигә: — «Пәрвәрдигарниң маңа ейтқанлириниң һәммисигә әмәл қилмисам болмайду» дегән әмәсмидим? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Балақ Балаамға: — Кәлсилә, мән силини башқа бир йәргә апирай, Худаниң нәзиридә сили шу йәрдә туруп уларни қарғашлири мувапиқ тепилармекин? — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Шуниң билән Балақ Балаамни башлап, чөл-баяванға қарайдиған Пеор теғиниң чоққисиға кәлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Балаам Балаққа: — Сили бу йәрдә маңа йәттә қурбангаһ салдуруп бәрсилә, йәттә буқа билән йәттә қошқарму тәйярлап бәрсилә, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Балақ Балаамниң дегинидәк қилди, һәр бир қурбангаһқа бирдин буқа билән бирдин қочқар сунди. ");
INSERT INTO uigcyr_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Балаам Пәрвәрдигарниң Исраилларға бәхит-бәрикәт ата қилишни мувапиқ көргәнлигини көрүп йетип, алдинқи икки қетимқидикидәк сеһир ишлитишкә бармиди, бәлки йүзини чөл-баяван тәрәпкә қаратти. ");
INSERT INTO uigcyr_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Балаам бешини көтирип Исраилларниң қәбилә бойичә чедирларда олтирақлашқанлиғини көрди, Худаниң Роһи униң үстигә чүшти. ");
INSERT INTO uigcyr_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Шуниң билән у ағзиға калам сөзини елип мундақ деди: — «Беорниң оғли Балаам йәткүзидиған калам сөзи, Көзи ечилмиған адәмниң ейтидиған калам сөзи, ");
INSERT INTO uigcyr_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Йәни Тәңриниң сөзлирини аңлиғучи, Һәммигә Қадирниң аламәт көрүнүшини көргүчи, Мана әнди көзи ечилип дүм жиқилған киши йәткүзгән калам сөзи: — ");
INSERT INTO uigcyr_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Аһ Яқуп, чедирлириң нәқәдәр гөзәл, Туралғулириң нәқәдәр гөзәл, аһ Исраил! ");
INSERT INTO uigcyr_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Гоя кеңәйгән дәрия вадилиридәк, Худди дәрия бойидики бағлардәк, Гоя Пәрвәрдигар тикип өстүргән уд дәрәқлиридәк, Дәрия бойидики кедир дәрәқлиридәк; ");
INSERT INTO uigcyr_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Сулар униң соғилиридин еқип чиқиду, Әвлатлири сүйи мол җайларда болиду; Падишаси Гогдин ешип кетиду, Униң падишалиғи үстүн қилинип гүллиниду.    ");
INSERT INTO uigcyr_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Тәңри уни Мисирдин елип чиққан, Униңда явайи буқиниң күчи бардур; Дүшмән әлләрни у йәп кетиду, Устиханлирини езип ташлайду, Оқя етип уларни тешип ташлайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","У бағирлап ятса, әркәк ширдәк, Ятса һәм чиши ширдәк, Ким уни қозғитишқа петинар? Ким саңа бәхит-бәрикәт тилисә, бәхит-бәрикәт тапиду. Ким сени қарғиса, қарғишқа кетиду». ");
INSERT INTO uigcyr_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Балақ Балаамға аччиқлинип, қолини қолиға уруп кәтти; Балақ Балаамға: — Мән силини дүшминимни қарғап беришкә қичқиртқан едим вә мана, сили үч қетим пүтүнләй уларға амәт тилидилә! ");
INSERT INTO uigcyr_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Әнди тездин жутлириға қечип кәтсилә; мән әслидә силиниң иззәт-һөрмәтлирини катта қилай дегән едим, мана Пәрвәрдигар силини бу катта иззәт-һөрмәткә наил болуштин тосуп қойди, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Балаам Балаққа: — Мән әслидә өзлириниң әлчилиригә: ");
INSERT INTO uigcyr_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","«Балақ маңа өзиниң алтун-күмүчкә лиқ толған өз өйини бәрсиму, Пәрвәрдигарниң буйруғинидин һалқип, өз мәйлимчә яхши-яман иш қилалмаймән; Пәрвәрдигар маңа немә десә, мән шуни дәймән» дегән әмәсмидим? ");
INSERT INTO uigcyr_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Әнди мән өз хәлқимгә қайтимән; кәлсилә, мән өзлиригә бу хәлиқниң күнләрниң ахирида силиниң хәлиқлиригә қандақ муамилә қилидиғанлиғини ейтип берәй, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","У калам сөзини ағзиға елип мундақ деди: — Беорниң оғли Балаам йәткүзидиған калам сөзи, Көзлири ечилмиған киши ейтқан калам сөзи, ");
INSERT INTO uigcyr_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Тәңриниң сөзлирини аңлиғучи, Һәммидин Алийниң вәһийлирини билгүчи, Һәммигә Қадирниң аламәт көрүнүшини көргүчи, Мана әнди көзи ечилған дүм жиқилиған киши йәткүзидиған калам сөзи: — ");
INSERT INTO uigcyr_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Мән Уни көримән, лекин һазир әмәс; Мән Униңға қараймән, лекин йеқин йәрдин әмәс; Яқуптин чиқар бир юлтуз, Көтириләр Исраилдин бир шаһанә һаса; Чеқиветәр у Моабниң чекисини, Барлиқ Шетләрниң бешини янҗийду.    ");
INSERT INTO uigcyr_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Едом униңға тәвә болиду, Йәнә техи дүшмини Сеирлар униңға тәвә болиду; Исраил болса батурлуқ қилиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Яқуптин чиққан бири сәлтәнәт сүриду, Шәһәрдә қалған һәммәйләнни йоқитиду».    ");
INSERT INTO uigcyr_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Андин Балаам Амаләкни көрүп, мундақ калам сөзини ейтти: — «Амаләк еди әсли әлләр арисида баш, Әнди һалакәттур тәғдир-қисмити». ");
INSERT INTO uigcyr_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Андин Балаам Кенийләрни көрүп мундақ калам сөзини ейтти: — «Сениң маканиң мустәһкәм болуп, Чаңгаң қорам таш ичидә болсиму, ");
INSERT INTO uigcyr_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Лекин силәр Кенийләр һалак қилинип турисиләр; Таки Ашур силәрни тутқун қилип кәткичә». ");
INSERT INTO uigcyr_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Балаам йәнә калам сөзини давам қилип мундақ деди: — «Аһ , Тәңри бу ишларни қилған чеғида, Ким тирик қелишқа қадир болар? ");
INSERT INTO uigcyr_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Киттим тәрәплиридин кемиләр келип, Зулум-зәхмәт салиду Ашурға, Зулум-зәхмәт салиду Ебәргә; Лекин Киттимдин кәлгүчи өзиму һалакәткә йүзлинәр». ");
INSERT INTO uigcyr_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Шуниң билән Балаам орнидин қопуп өз жутиға қайтти; Балақму өз йолиға маңди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Исраиллар Шиттимда турған мәзгилдә, хәлиқ Моаб қизлири билән бузуқлуқ қилишқа берилип кәтти. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","У қизлар Исраилларни өз илаһлириға аталған қурбанлиқларға қатнишишқа чақирди; Исраилларму қурбанлиқлардин йәйдиған, уларниң илаһлириға бирликтә чоқунидиған болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Исраиллар Баал-Пеор билән әнә шу тәриқидә бағлинип кәткәнлиги үчүн, Пәрвәрдигарниң Исраилларға аччиғи қозғалди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Пәрвәрдигар Мусаға: — Пәрвәрдигарниң қаттиқ ғәзиви Исраилларға чүшмисун үчүн, хәлиқниң әмирлириниң һәммисини тутуп, уларни Мениң алдимда аптапта есип қойғин, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Шуниң билән Муса Исраилниң сорақчилириға: — Силәр берип һәр бириңлар өзүңларниң Баал-Пеор билән бағлинип кәткән адәмлирини өлтүрүветиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Вә Муса пүткүл Исраил җамаити билән җамаәт чедириниң дәрвазиси алдида жиға-зерә қилип туруватқанда, мана Исраиллардин бирәйлән келип уларниң көз алдидила Мидияний бир қизни өз қериндашлириниң йениға елип маңди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Каһин Һарунниң нәвриси, Әлиазарниң оғли Финиһас буни көрүп, җамаәт ичидин қопти-дә, қолиға нәйзә елип, ");
INSERT INTO uigcyr_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","һелиқи Исраил адәмниң арқисидин чедирниң ичкиригә кирип, қиз билән иккисиниң қарниға нәйзә тиқивәтти. Исраиллар арисида тарқалған ваба әнә шу чағдила тохтиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Шу чағда ваба тегип өлгәнләр җәмий жигирмә төрт миң адәмгә йәткән еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Андин Пәрвәрдигар Мусаға мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","— «Каһин Һарунниң нәвриси, Әлиазарниң оғли Финиһас Мени дәп вапасизлиққа болған һәситимни өз һәсити билип, Мениң Исраилларға болған ғәзивимни яндурди. Шуңа гәрчә Мән вапасизлиққа болған һәситимдин ғәзәпләнгән болсамму, Исраилларни йоқитивәтмидим. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Шуңа сән: — «Мана, Мән униңға өз аман-хатирҗәмлик әһдәмни тәқдим қилимән! ");
INSERT INTO uigcyr_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Бу әһдә униңға вә униң әвлатлириға тәвә болидиған мәңгүлүк каһинлиқ әһдиси болиду, чүнки у өз Худасини дәп вапасизлиққа һәсәт қилип, Исраиллар үчүн кәфарәт кәлтүрди» — дәп җакалиғин». ");
INSERT INTO uigcyr_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Өлтүрүлгән йәни һелиқи Мидияний қиз билән биллә өлтүрүлгән Исраил адәмниң исми Зимри болуп, Салуниң оғли, Шимеон қәбилисидики бир җәмәтниң әмри еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Өлтүрүлгән Мидияний қизниң исми Козби болуп, Зурниң қизи еди; Зур болса Мидияний бир қәбилиниң башлиғи еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Пәрвәрдигар Мусаға: — ");
INSERT INTO uigcyr_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Сән Мидиянийларға арам бәрмәй зәрбә бәргин; ");
INSERT INTO uigcyr_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","19","Чүнки улар һейлә-микир ишлитип силәргә арам бәрмигән; Пеордики ишта, шундақла уларниң сиңлиси болған Мидиянниң бир әмриниң қизи Козбиниң ишидиму һейлә-микир ишлитип силәрни аздурған, — деди. Козби ваба тарқалған күнидә Пеордики иш сәвәвидин өлтүрүлди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Вабадин кейин Пәрвәрдигар Муса билән Һарунниң оғли Әлиазарға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Силәр пүткүл Исраилларниң җамаити ичидә жигирмә яштин ашқан, җәңгә чиқалайдиғанларни ата җәмәти бойичә һесаплап санақтин өткүзүңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Шуниң билән Муса билән каһин Әлиазар Моаб түзләңликлиридә, йәни Йерихониң йенидики Иордан дәриясиниң бойида Исраиллар билән сөзлишип уларға: ");
INSERT INTO uigcyr_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Пәрвәрдигарниң Муса вә Мисирдин чиққан Исраилларға буйруғини бойичә, силәрдин жигирмә яштин ашқанларниң һәммиси тизимлинип санақтин өткүзүлүши керәк» дәп уқтурди. Тизимлитилған санлар мундақ болди: —    ");
INSERT INTO uigcyr_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Исраилниң тунҗа оғли Рубән еди. Рубәнниң әвлатлири, йәни Һануқниң нәслидин болған Һануқ җәмәти; Паллуниң нәслидин болған Паллу җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Һәзрон нәслидин болған Һәзрон җәмәти; Карми нәслидин болған Карми җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Булар Рубәнниң җәмәтлири болуп, улардин санақтин өткүзүлгини җәмий қириқ үч миң йәттә йүз оттуз киши болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Паллуниң оғли Елиаб; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Елиабниң оғуллири Нимуәл, Датан, Абирам еди. Датан билән Абирам әслидә җамаәт ичидин чақирилған мөтивәрләр болсиму, Кораһ гуруһидикиләр Пәрвәрдигар билән такаллашқанда, улар билән бирлишип Муса вә Һарун билән такаллашқан еди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Йәр ағзини ечип уларни Кораһ билән биргә жутуп кәткән; шу чағда Кораһ гуруһидикиләрниң һәммиси өлгән; башқиларға ибрәт болсун дәп, от униң икки йүз әллик адимини жутуп кәткән. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Лекин Кораһниң әвлатлири өлүп кәтмигән. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Шимеонниң әвлатлири, җәмәт бойичә, Нәмуәлниң нәслидин болған Нәмуәл җәмәти; Ямин нәслидин болған Ямин җәмәти; Яқин нәслидин болған Яқин җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Зәраһ нәслидин болған Зәраһ җәмәти; Саул нәслидин болған Саул җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Булар Шимеонниң җәмәтлири болуп, җәмий жигирмә икки миң икки йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Гад қәбилисидин, җәмәт бойичә, Зәфон нәслидин болған Зәфон җәмәти; Һагги нәслидин болған Һагги җәмәти; шуни нәслидин болған шуни җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Озни нәслидин болған Озни җәмәти; ери нәслидин болған ери җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Арод нәслидин болған Арод җәмәти; Арәли нәслидин болған Арәли җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Булар Гад әвлатлириниң җәмәтлири болуп, улар җәмәтлири бойичә санақтин өткүзүлгәндә җәмий қириқ миң бәш йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Йәһуданиң оғуллири Ер билән Онан еди; бу иккиси Қанаан зиминида өлүп кәткән. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Йәһуданиң әвлатлири, җәмәти бойичә, Шилаһниң нәслидин болған Шилаһ җәмәти; Пәрәзниң нәслидин болған Пәрәз җәмәти; Зәраһниң нәслидин болған Зәраһ җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Пәрәзниң әвлатлири Һәзронниң нәслидин болған Һәзрон җәмәти; Һамулниң нәслидин болған Һамул җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Булар Йәһуданиң җәмәтлири болуп, улар җәмәт бойичә санақтин өткүзүлгәндә җәмий йәтмиш алтә миң бәш йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Иссакарниң әвлатлири, җәмәт бойичә, Толаниң нәслидин болған Тола җәмәти; Пуаһниң нәслидин болған Пуаһ җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Яшубниң нәслидин болған Яшуб җәмәти; Шимронниң нәслидин болған Шимрон җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Булар Иссакарниң җәмәтлири болуп, улар җәмәт бойичә санақтин өткүзүлгәндә җәмий атмиш төрт миң үч йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Зәбулунниң әвлатлири, җәмәти бойичә, Сәрәдниң нәслидин болған Сәрәд җәмәти; Елон нәслидин болған Елон җәмәти; Җаһлийәлниң нәслидин болған Җаһлийәл җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Булар Зәбулунниң җәмәтлири болуп, улар җәмәт бойичә санақтин өткүзүлгәндә җәмий атмиш миң бәш йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Йүсүпниң оғуллири: — җәмәт бойичә, Манассәһ билән Әфраим еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Манассәһниң әвлатлири: — Макирниң нәслидин болған Макир җәмәти (Макирдин Гилеад төрәлгән), Гилеадниң нәслидин болған Гилеад җәмәти еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Төвәндикиләр Гилеадниң әвлатлири: — Йәәзәрниң нәслидин болған Йәәзәр җәмәти; Һәләкниң нәслидин болған Һәләк җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Асрийәлниң нәслидин болған Асрийәл җәмәти; Шәкәмниң нәслидин болған Шәкәм җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Шәмиданиң нәслидин болған Шәмида җәмәти; Һәфәрниң нәслидин болған Һәфәр җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Һәфәрниң оғли Зәлофиһад оғул пәрзәнт көрмәй қиз пәрзәнт көргән; Зәлофиһадниң қизлириниң исми Маһлаһ, Ноаһ, Һоглаһ, Милкаһ, Тирзаһ еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Булар Манассәһниң җәмәтлири болуп, санақтин өткүзүлгәндә җәмий әллик икки миң йәттә йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Төвәндикиләр Әфраимниң әвлатлири, җәмәти бойичә: — Шутилаһниң нәслидин болған Шутилаһ җәмәти; Бәкәрниң нәслидин болған Бәкәр җәмәти; Таһанниң нәслидин болған Таһан җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Шутиланиң әвлатлири Еранниң нәслидин болған Еран җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Мана булар Әфраим әвлатлириниң җәмәтлири болуп, һәр қайси җәмәтләр бойичә санақтин өткүзүлгәндә җәмий оттуз икки миң бәш йүз адәм чиқти. Җәмәтлири бойичә, уларниң һәммиси Йүсүпниң әвлатлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Биняминниң әвлатлири, җәмәти бойичә, Беланиң нәслидин болған Бела җәмәти; Ашбәлниң нәслидин болған Ашбәл җәмәти; Аһирамниң нәслидин болған Аһирам җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Шәфуфамниң нәслидин болған Шуфам җәмәти; Һуфамниң нәслидин болған Һуфам җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ард билән Нааман Беланиң оғуллири еди; Ардниң нәслидин болған Ард җәмәти; Нааманниң нәслидин болған Нааман җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Булар Биняминниң әвлатлири болуп, җәмәт бойичә санақтин өткүзүлгәндә җәмий қириқ бәш миң алтә йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Төвәндикиләр Данниң әвлатлири болуп, җәмәт бойичә, Шуһамниң нәслидин болған Шуһам җәмәти; җәмәт бойичә булар Данниң җәмәтлири еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Шуһамниң һәммә җәмәти санақтин өткүзүлгәндә җәмий атмиш төрт миң төрт йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Аширниң әвлатлири, җәмәт бойичә, Йимнаһниң нәслидин болған Йимнаһ җәмәти; Йишвиниң нәслидин болған Йишви җәмәти; Берияһниң нәслидин болған Берияһ җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Берияһниң әвлатлири, җәмәт бойичә, Һәбәрниң нәслидин болған Һәбәр җәмәти; Малкиәлниң нәслидин болған Малкиәл җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Аширниң қизиниң исми Сераһ еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Булар Ашир әвлатлириниң җәмәтлири болуп, улар җәмәт бойичә санақтин өткүзүлгәндә җәмий әллик үч миң төрт йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Нафталиниң әвлатлири, җәмәт бойичә, Яһзиәлниң нәслидин болған Яһзиәл җәмәти; Гуниниң нәслидин болған Гуни җәмәти; ");
INSERT INTO uigcyr_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Йәзәрниң нәслидин болған Йәзәр җәмәти; Шилләмниң нәслидин болған Шилләм җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Булар Нафталиниң җәмәтлири болуп, җәмәт бойичә санақтин өткүзүлгәндә җәмий қириқ бәш миң төрт йүз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Жуқириқилар Исраиллардин санақтин өткүзүлгәнләр болуп, җәмий алтә йүз бир миң йәттә йүз оттуз адәм чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Зимин мошуларға ройхәткә елинған сан бойичә мирас қилип тәқсим қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Мирасни адәм сани көп қәбилиләргә көпрәк, адәм сани аз қәбилиләргә азрақ бөл; мирас ройхәттин өткүзүлгән адәм саниға қарап һәр бир адәмгә бөлүп берилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Һалбуки, зимин чәк ташлиниш йоли билән бөлүнсун; улар мирасқа өзлириниң ата җәмәт-қәбилисиниң нами бойичә варислиқ қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Мирас уларға чәк ташлаш йоли билән адәм саниниң аз-көплүгигә қарап һәр бир аилә-җәмәткә бөлүп берилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Төвәндикиләр ата җәмәт бойичә санақтин өткүзүлгән Лавийлар: — Гәршонниң нәслидин болған Гәршон җәмәти; Коһатниң нәслидин болған Коһат җәмәти; Мәрариниң нәслидин болған Мәрари җәмәти. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Булар Лавийларниң җәмәтлири: — Либни җәмәти, Һеброн җәмәти, Маһли җәмәти, Муши җәмәти, Кораһ җәмәти. Коһаттин Амрам төрәлгән. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Амрамниң аялиниң исми Йокәбәд болуп, Лавийниң Мисирда туғулған қизи еди; у Амрамға Һарун, Муса вә уларниң һәдиси Мәрйәмни туғуп бәргән. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Һарундин Надаб, Абиһу, Әлиазар, Итамар төрәлгән. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Лекин Надаб билән Абиһу Пәрвәрдигарниң алдиға ғәйрий бир отни сунғанда өлүп кәткән.    ");
INSERT INTO uigcyr_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Лавийлар ичидә бир айлиқтин ашқан барлиқ әркәкләр санақтин өткүзүлгәндә җәмий жигирмә үч миң адәм чиқти. Улар Исраиллар ичидә санақтин өткүзүлмигән, чүнки уларға Исраиллар ичидә һеч қандақ мирас зимин бөлүп берилмигән. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Жуқирида ейтилған адәмләр Моаб түзләңликлиридә, Йерихониң удулидики Иордан дәрияси бойида Муса билән каһин Әлиазар тәрипидин санақтин өткүзүлгән Исраиллардур. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Бирақ бу адәмләр ичидә Муса билән каһин Һарун илгири Синай чөлидә санақтин өткүзгәндә санақтин өткүзүлгән бирму адәм йоқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Чүнки Пәрвәрдигар улар тоғрисида: «Улар чөлдә өлмәй қалмайду» дәп ейтқан еди. Шуңа, Йәфуннәһниң оғли Каләб билән Нунниң оғли Йәшуадин башқа бириму қалмиған. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Йүсүпниң оғли Манассәһниң нәслидин болған җәмәтләр ичидә Манассәһниң чәвриси, Макирниң әвриси, Гилеадниң нәвриси, Һәфәрниң оғли Зәлофиһадниң қизлири болуп, уларниң исми Маһлаһ, Ноаһ, Һоглаһ, Милкаһ, вә Тирзаһ еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Улар җамаәт чедириниң дәрвазиси алдиға келип, Муса билән каһин Әлиазар вә әмирләр билән пүткүл җамаәтниң алдида туруп: ");
INSERT INTO uigcyr_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","— Бизниң атимиз чөлдә өлүп кәткән; у у йәрдә Пәрвәрдигарға һуҗум қилғили жиғилғанлардин әмәс, йәни Кораһ гуруһидикиләрдин әмәс; у бәлки өз гунайи ичидә өлгән, вә униң оғул пәрзәнти йоқ еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Немә үчүн атимизниң оғли йоқлуғи сәвәплик униң нами униң җәмәтидин өчүрүветилиду? Өзлириниң бизгә атимизниң қериндашлири қатарида мирас бөлүп беришлирини өтүнимиз, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Муса уларниң бу ишини Пәрвәрдигарниң алдиға қойди. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Зәлофиһадниң қизлириниң ейтқини дурус, сән чоқум уларға атисиниң қериндашлири қатарида мирас бәр; уларниң атисиниң мирасини уларға өткүзүп бәргин. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Сән Исраилларға ейтқин: «Бир адәм өлүп кәткән чағда униң оғли болмиса, ундақта силәр униң мирасини қизиға өткүзүп бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Қизи болмиса, мирасини қериндашлириға бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Қериндашлири болмиса, мирасини ата җәмәт тағилириға бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Әгәр униң атисиниң қериндашлири болмиса, ундақта униң мирасини униң җәмәтидики әң йеқин бир туққиниға бериңлар; у адәм униң мирасиға егә болсун. Бу Пәрвәрдигар Мусаға буйруғандәк, Исраилларға чүшүрүлгән һөкүм, қанун-бәлгүлимә болуп қалсун». ");
INSERT INTO uigcyr_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Пәрвәрдигар Мусаға: — Сән маву Абарим теғиға чиқип, Мән Исраилларға тәқдим қилған зиминға қарап бақ.    ");
INSERT INTO uigcyr_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Көрүп болғандин кейин сәнму акаң Һарунға охшаш өз хәлиқлириңгә қошулисән.    ");
INSERT INTO uigcyr_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Чүнки Зин чөлидә, җамаәт җедәл чиқарған чағда, иккиңлар Мениң буйруғимға асийлиқ қилип, суниң ишида (Зин чөлидә, Қадәштики «Мәрибаһ сулири» дегән җайда) Мени җамаәтниң алдида муқәддәс дәп һөрмәтлимидиңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Муса Пәрвәрдигарға сөз қилип: ");
INSERT INTO uigcyr_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","— И Пәрвәрдигар, барлиқ әт егилириниң роһлириниң Худаси, Өз җамаитиниң падичисиз падидәк болуп қелишиниң алдини елиш үчүн җамаәтни идарә қилидиған, уларниң алдиға кирип чиқалайдиған, уларни башлап маңалайдиған бир адәмни тикләп беришиңни тиләймән, — деди.    ");
INSERT INTO uigcyr_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Сән Нунниң оғли Йәшуани таллиғин, — деди Пәрвәрдигар Мусаға, — Униңда Роһум бар, сән қолуңни униң бешиға қой,    ");
INSERT INTO uigcyr_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","уни каһин Әлиазар вә барлиқ җамаәтниң алдида турғузуп вәзипигә қой. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Сән пүткүл Исраил җамаити униң гепигә кириши үчүн өзүңниң иззәт-шөһритиңдин бир қисмини униңға бәргин. ");
INSERT INTO uigcyr_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","У каһин Әлиазарниң алдида турсун, Әлиазар уримниң һөкүмини васитә қилип туруп, Пәрвәрдигарниң һозурида униң үчүн йол сорисун; Исраил хәлқи, йәни пүткүл җамаәт униң буйруғи билән чиқиду, униң буйруғи билән кириши керәк.    ");
INSERT INTO uigcyr_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Шуниң билән Муса Пәрвәрдигарниң буйруғи бойичә иш көрүп, Йәшуани башлап келип, каһин Әлиазарниң вә барлиқ җамаәтниң алдида турғузди; ");
INSERT INTO uigcyr_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Әлиазар қолини униң бешиға қоюп, уни Пәрвәрдигарниң Мусаниң вастиси билән буйруғинидәк вәзипигә қойди. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Сән Исраилларға буйруп: — «Маңа сунулған һәдийә-қурбанлиқларни, йәни Маңа озуқ болидиған, хушбуй кәлтүридиған отта сунулидиған һәдийә-қурбанлиқларни болса, силәр һәр бирини бекитилгән қәрәлидә сунушқа көңүл қоюңлар» — дегин. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Сән уларға йәнә: «Силәрниң Пәрвәрдигарға атап отта сунидиған көйдүрмә қурбанлиғиңлар мундақ болиду: — һәр күни беҗирим бир яшлиқ әркәк қозидин иккини дайимий көйдүрмә қурбанлиқ қилиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Әтигини бирни, гугумда бирни сунуңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","йәнә төрттин бир һиндин соқуп чиқирилған зәйтун мейи иләштүрүлгән есил ундин ондин бир әфаһни ашлиқ һәдийәси сүпитидә сунуңлар.    ");
INSERT INTO uigcyr_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Синай теғида бәлгүләнгән, Пәрвәрдигарға атап хушбуй чиқарсун дәп, отта сунулидиған дайимий көйдүрмә қурбанлиқ мана шудур. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Һәр бир қоза үчүн униңға қошулидиған шарап һәдийәси төрттин бир һин шарап болиду; ечитма ичимлик болған шарап һәдийәси муқәддәс җайда Пәрвәрдигарға сунуп төкүлсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Сән иккинчи бир қозини гугумда сунғин; уни әтигәнкидәк ашлиқ һәдийәси вә шарап һәдийәси билән қошуп сунғин; у хушбуй кәлтүрүш үчүн Пәрвәрдигарға атап отта сунулидиған көйдүрмә қурбанлиқ болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","— Шабат күни беҗирим бир яшлиқ икки әркәк қоза сунулсун; униңға қошуп зәйтун мейи иләштүрүлгән есил ундин әфаһниң ондин иккиси ашлиқ һәдийәси сүпитидә сунулсун вә шарап һәдийәси сунулсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","бу һәр бир шабат күнидә сунулидиған шабат күнидики қурбанлиқтур; униң билән дайимий көйдүрмә қурбанлиқ вә қошумчә сунулидиған шарап һәдийәси биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","— Һәр айниң биринчи күни Пәрвәрдигарға атилидиған көйдүрмә қурбанлиқ сунуңлар; йәни икки яш топақ, бир қочқар, бир яшлиқ беҗирим йәттә әркәк қозини сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Һәр топақ бешиға зәйтун мейи иләштүрүлгән есил ундин әфаһниң ондин үчи ашлиқ һәдийәси сүпитидә, қошқарға зәйтун мейи иләштүрүлгән есил ундин әфаһниң ондин иккиси ашлиқ һәдийәси сүпитидә, ");
INSERT INTO uigcyr_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","һәр бир қоза бешиға зәйтун мейи иләштүрүлгән есил ундин әфаһниң ондин бири ашлиқ һәдийәси сүпитидә сунулсун; бу Пәрвәрдигарға отта сунулидиған, хушбуй чиқиридиған бир көйдүрмә қурбанлиқтур. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Уларниң шарап һәдийәлири болса: — һәр бир топақ бешиға шараптин йерим һин, қошқар бешиға һинниң үчтин бири, һәр бир қоза бешиға һинниң төрттин бири сунулсун. Бу һәр айда сунулидиған айлиқ көйдүрмә қурбанлиқ болуп, жилниң һәр ейида шундақ қилинсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Буларниң үстигә Пәрвәрдигарға атилидиған гуна қурбанлиқ сүпитидә бир текә сунулсун; шуларниң һәммиси дайимий көйдүрмә қурбанлиқ вә қошумчә шарап һәдийәси билән биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Биринчи айниң он төртинчи күни Пәрвәрдигарға аталған «өтүп кетиш» қозиси сунулсун.    ");
INSERT INTO uigcyr_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Шу айниң он бәшинчи күни һейт башлиниду; йәттә күн петир нан йейилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Биринчи күни муқәддәс жиғилиш өткүзүлсун, һеч қандақ иш-әмгәк қилмаслиғиңлар керәк, ");
INSERT INTO uigcyr_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","шу күни отта сунулидиған, Пәрвәрдигарға аталған көйдүрмә қурбанлиқ сүпитидә яш топақтин иккини, бир қочқар вә йәттә бир яшлиқ әркәк қоза сунуңлар; улар алдиңларда беҗирим көрүнсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","шуларға қошулидиған ашлиқ һәдийәлири зәйтун мейи иләштүрүлгән есил ун болуп, һәр бир топақ бешиға әфаһниң ондин үчи, қочқар бешиға әфаһниң ондин иккиси, ");
INSERT INTO uigcyr_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","шу йәттә қоза бешиға әфаһниң ондин бири сунулсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","шуниңдәк гунайиңлар үчүн кәфарәт кәлтүрүшкә гуна қурбанлиғи сүпитидә бир текә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Буларниң һәммисини әтигәнлик көйдүрмә қурбанлиқ, йәни дайимий көйдүрмә қурбанлиқтин айрим сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Силәр бу тәриқидә уда йәттә күн Пәрвәрдигарға атап отта сунулидиған, хушбуй кәлтүридиған ашундақ һәдийә-қурбанлиқларни сунуңлар; шуларниң һәммиси дайимий көйдүрмә қурбанлиқ вә қошуп сунулидиған шарап һәдийәсиниң сиртида сунулиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Йәттинчи күни муқәддәс жиғилиш өткүзүңлар, шу күни һеч қандақ иш-әмгәк қилишқа болмайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«Дәсләпки орма» күни, йәни «һәптиләр һейти»ңларда силәр йеңи ашлиқ һәдийәсини Пәрвәрдигарға сунған чағда муқәддәс жиғилиш өткүзүңлар; һеч қандақ иш-әмгәк қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Силәр Пәрвәрдигарға аталған, хушбуй кәлтүридиған көйдүрмә қурбанлиқ сүпитидә яш топақтин иккини, қочқардин бирни, бир яшлиқ әркәк қозидин йәттини сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Шуларға қошуп сунулидиған ашлиқ һәдийәси зәйтун мейи иләштүрүлгән есил ундин болуп, һәр бир топақ бешиға әфаһниң ондин үчи, қочқар бешиға әфаһниң ондин иккиси, ");
INSERT INTO uigcyr_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","шу йәттә қоза бешиға әфаһниң ондин бири сунулсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","шуниңдәк силәрниң гунайиңлар үчүн кәфарәт кәлтүрүшкә гуна қурбанлиғи сүпитидә бир текә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Шуларниң һәммиси дайимий көйдүрмә қурбанлиқ вә униң ашлиқ һәдийәсигә қошуп (буларниң һәммиси алдиңларда беҗирим көрүнсун), шарап һәдийәлири билән биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Йәттинчи айниң биринчи күни силәр муқәддәс жиғилиш өткүзүңлар; у күни һеч қандақ иш-әмгәк қилмаслиғиңлар керәк. Бу силәр үчүн канайлар челинидиған күни болиду.    ");
INSERT INTO uigcyr_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Силәр Пәрвәрдигарға аталған, хушбуй кәлтүридиған көйдүрмә қурбанлиқ сүпитидә яш бир топақ, бир қочқар, йәттә бир яшлиқ беҗирим әркәк қозини сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Шуларға қошуп сунулидиған ашлиқ һәдийәси зәйтун мейи иләштүрүлгән есил ундин болуп, һәр бир топақ бешиға әфаһниң ондин үчи, қочқар бешиға әфаһниң ондин иккиси, ");
INSERT INTO uigcyr_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","шу йәттә қоза бешиға әфаһниң ондин бири сунулсун; ");
INSERT INTO uigcyr_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","шуниңдәк силәрниң гунайиңлар үчүн кәфарәт кәлтүрүшкә гуна қурбанлиғи сүпитидә бир текә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Шуларни айниң биринчи күнидики көйдүрмә қурбанлиқ вә униңға қошумчә болған ашлиқ һәдийәси, дайимий көйдүрмә қурбанлиқ, униңға қошумчә болған ашлиқ һәдийәси вә буларға қошулидиған шарап һәдийәлириниң сиртида сунуңлар; буларниң һәммиси һәр бири бәлгүлимә бойичә Пәрвәрдигарға атап отта хушбуй кәлтүрсун дәп сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Йәттинчи айниң онинчи күни силәр муқәддәс жиғилиш өткүзүңлар; нәпсиңларни тартип өзүңларни төвән тутуңлар. У күни һеч қандақ иш-әмгәк қилишқа болмайду.    ");
INSERT INTO uigcyr_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Силәр Пәрвәрдигарға аталған, хушбуй кәлтүридиған көйдүрмә қурбанлиқ сүпитидә яш бир топақ, бир қочқар, бир яшлиқ әркәк қозидин йәттини сунуңлар (буларниң һәммиси алдиңларда беҗирим көрүнсун). ");
INSERT INTO uigcyr_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Шуларға қошуп сунулидиған ашлиқ һәдийәси зәйтун мейи иләштүрүлгән есил ундин болуп, һәр бир топақ бешиға әфаһниң ондин үчи, қочқар бешиға әфаһниң ондин иккиси, ");
INSERT INTO uigcyr_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","шу йәттә қоза бешиға әфаһниң ондин бирини, ");
INSERT INTO uigcyr_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","шуниңдәк гуна қурбанлиғи сүпитидә бир текә сунуңлар; уларниң һәммиси кәфарәт күнидики гуна қурбанлиғи, дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә буларниң шарап һәдийәлири биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Йәттинчи айниң он бәшинчи күни муқәддәс жиғилиш өткүзүңлар; у күни һеч қандақ иш-әмгәк қилишқа болмайду. Пәрвәрдигарға атап йәттә күн һейт қилиңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","силәр Пәрвәрдигарға атап, хушбуй кәлтүрсун дәп отта сунулидиған көйдүрмә қурбанлиқ сүпитидә яш топақтин он үчни, икки қочқар, бир яшлиқ әркәк қозидин он төртни сунуңлар (шулар һәммиси беҗирим болсун). ");
INSERT INTO uigcyr_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Шуларға қошуп сунулидиған ашлиқ һәдийәси зәйтун мейи иләштүрүлгән есил ундин болуп, он үч топақ бешиға әфаһниң ондин үчи, икки қочқар бешиға әфаһниң ондин иккиси, ");
INSERT INTO uigcyr_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","он төрт қоза бешиға әфаһниң ондин бирини, ");
INSERT INTO uigcyr_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","шуниңдәк гуна қурбанлиғи сүпитидә бир текә сунуңлар; шуларниң үстигә дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә шарап һәдийәси биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Иккинчи күни яш топақтин он иккини, икки қочқар, бир яшлиқ әркәк қозидин он төртни сунуңлар (шулар һәммиси беҗирим болсун) ");
INSERT INTO uigcyr_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","вә шундақла топақлар, қочқарлар вә әркәк қозиларниң саниға қарап бәлгүлимә бойичә қошумчә сунулидиған ашлиқ һәдийәлири билән шарап һәдийәлирини сунуңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Шуниңдәк гуна қурбанлиғи сүпитидә бир текә сунуңлар; шуларниң үстигә дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә шуларниң шарап һәдийәлири биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Үчинчи күни бир яш топақтин он бирни, икки қочқар, бир яшлиқ әркәк қозидин он төртни сунуңлар (шулар һәммиси беҗирим болсун) ");
INSERT INTO uigcyr_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","вә шундақла топақлар, қочқарлар вә әркәк қозиларниң саниға қарап бәлгүлимә бойичә қошумчә сунулидиған ашлиқ һәдийәлири билән шарап һәдийәлирини сунуңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","шуниңдәк гуна қурбанлиғи сүпитидә бир текә сунуңлар; шуларниң үстигә дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә шарап һәдийәси биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Төртинчи күни яш топақтин онни, икки қочқар, бир яшлиқ әркәк қозидин он төртни сунуңлар (шулар һәммиси беҗирим болсун) ");
INSERT INTO uigcyr_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","вә шундақла топақлар, қочқарлар вә әркәк қозиларниң саниға қарап бәлгүлимә бойичә қошумчә сунулидиған ашлиқ һәдийәлири билән шарап һәдийәлирини сунуңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","шуниңдәк гуна қурбанлиғи сүпитидә бир текә сунуңлар; шуларниң үстигә дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә шарап һәдийәси биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Бәшинчи күни яш топақтин тоққузни, икки қочқар, бир яшлиқ әркәк қозидин он төртни сунуңлар (шулар һәммиси беҗирим болсун) ");
INSERT INTO uigcyr_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","вә шундақла топақлар, қочқарлар вә әркәк қозиларниң саниға қарап бәлгүлимә бойичә қошумчә сунулидиған ашлиқ һәдийәлири билән шарап һәдийәлирини сунуңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","шуниңдәк гуна қурбанлиғи сүпитидә бир текә сунуңлар; шуларниң үстигә дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә шарап һәдийәси биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Алтинчи күни яш топақтин сәккизни, икки қочқар, бир яшлиқ әркәк қозидин он төртни сунуңлар (шулар һәммиси беҗирим болсун) ");
INSERT INTO uigcyr_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","вә шундақла топақлар, қочқарлар вә әркәк қозиларниң саниға қарап бәлгүлимә бойичә қошумчә сунулидиған ашлиқ һәдийәлири билән шарап һәдийәлирини сунуңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","шуниңдәк гуна қурбанлиғи сүпитидә бир текә сунуңлар; шуларниң үстигә дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә шарап һәдийәси биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Йәттинчи күни яш топақтин йәттини, икки қочқар, бир яшлиқ әркәк қозидин он төртни сунуңлар (шулар һәммиси беҗирим болсун) ");
INSERT INTO uigcyr_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","вә шундақла топақлар, қочқарлар вә әркәк қозиларниң саниға қарап бәлгүлимә бойичә қошумчә сунулидиған ашлиқ һәдийәлири билән шарап һәдийәлирини сунуңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","шуниңдәк гуна қурбанлиғи сүпитидә бир текә сунуңлар; шуларниң үстигә дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә шарап һәдийәси биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Сәккизинчи күни силәр муқәддәс жиғилиш өткүзүңлар; у күни һеч қандақ иш-әмгәк қилмаңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Силәр Пәрвәрдигарға атап, хушбуй кәлтүрсун дәп отта сунулидиған көйдүрмә қурбанлиқ сүпитидә бир топақ, бир қочқар вә бир яшлиқ әркәк қозидин он төртни (шулар һәммиси беҗирим болсун) ");
INSERT INTO uigcyr_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","һәмдә топақ, қочқар вә әркәк қозиларниң саниға қарап, бәлгүлимә бойичә қошумчә сунулидиған ашлиқ һәдийәлири билән шарап һәдийәлирини сунуңлар; ");
INSERT INTO uigcyr_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","шуниңдәк гуна қурбанлиғи сүпитидиму бир текә сунуңлар; шуларниң үстигә дайимий көйдүрмә қурбанлиқ, униң қошумчә ашлиқ һәдийәси вә шарап һәдийәси биллә сунулсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Бәлгүләнгән һейтлириңларда Пәрвәрдигарға атап сунулидиған қурбанлиқ-һәдийәләр әнә шулардур; силәрниң қәсәмгә бағлиқ яки ихтиярән сунидиғанлириңлар, көйдүрмә қурбанлиқлириңлар, ашлиқ һәдийәлириңлар, шарап һәдийәлириңлар вә енақлиқ қурбанлиқлириңлар болса, уларниң сиртидидур. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Шундақ қилип, Муса Пәрвәрдигарниң  өзигә буйруғанлириниң һәммисини қалдурмай Исраилларға уқтурди. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Муса Исраилларниң қәбилә башлиқлириға сөз қилип мундақ деди: — Пәрвәрдигарниң буйруғанлири мундақ: — ");
INSERT INTO uigcyr_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Әгәр бирәв Пәрвәрдигарға қәсәм ичкән болса яки өз өзини чәклимәкчи болуп қәсәм ичкән болса, ләвзидин қайтишқа болмайду, һаман ағзидин чиққан һәммә гәп бойичә иш тутуши керәк. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Қиз бала яш болуп, техи атисиниң өйидики чағда, өз-өзини чәкләш тоғрилиқ Пәрвәрдигарға қәсәм бәргән болса, ");
INSERT INTO uigcyr_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","амма атиси қизиниң қәсимини яки өз-өзини чәкләш тоғрисида бәргән вәдисини аңлиған вә қизиниң алдида үндимәй шүк турған болса, ундақта униң барлиқ қәсәмлири вә өз-өзини чәкләш тоғрисида қилған һәммә вәдиси инавәтлик болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Лекин қизниң атиси аңлиған чағда уни тосқан болса, униң қилған қәсәмлири яки өз-өзини чәкләш тоғрисида қилған вәдилиридин һеч бири инавәтлик болмайду; атиси уни тосқан болғачқа, Пәрвәрдигарму уни кәчүриду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","— Әгәр у қәсәм қилған яки өз-өзини чәкләшкә ағзида тәнтәклик билән вәдә қилған һаләттә әргә тәккән болса, ");
INSERT INTO uigcyr_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ери шуни аңлиған болса, лекин аңлиған күни үндимәй  шүк турған болса, ундақта униң қилған қәсәмлири яки өз-өзини чәкләшкә қилған гәплири инавәтлик болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Әгәр ери аңлиған күни уни тосқан болса, униң қилған қәсимини вә өз-өзини чәкләш тоғрилиқ ағзидин чиқарған тәнтәк гәплирини бекар қилса, ундақта улар инавәтсиз болиду; Пәрвәрдигар уни кәчүриду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Лекин тул хотун яки еридин аҗришип кәткән хотунлар қилған қәсәм, йәни униң өзини чәкләш тоғрилиқ қилған барлиқ вәдилири болса инавәтлик болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Әгәр у ериниң өйидә қәсәм қилған яки өз-өзини чәкләш тоғрилиқ қәсәм-вәдә ичкән, ");
INSERT INTO uigcyr_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ери аңлап туруқлуқ шүк турувелип тосмиған болса, ундақта униң барлиқ қилған қәсәмлири вә өз-өзини чәкләш тоғрилиқ қилған барлиқ вәдилири инавәтлик болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Лекин униң ери аңлап турған чағда униң қәсәм-вәдилирини ениқ рәт қилған болса, аял ағзидин чиқарған вәдә бериш вә өз-өзини чәкләп туруш тоғрилиқ қилған барлиқ вәдилириниң һеч қайсиси инавәтлик болмайду; униң ери буларни рәт қилған болғачқа, Пәрвәрдигар уни кәчүриду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Аялниң бәргән вәдисини вә униң чидап туруп өзүмни чәкләймән дәп қилған қәсәм-вәдисини униң ери инавәтликму қилалайду, инавәтсизму қилалайду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Әгәр униң ери һәр күни униң алдида шүк турувелип гәп қилмиса, ундақта униң бәргән барлиқ қилған қәсәмлирини вә өз-өзини чәкләп туруш тоғрилиқ қилған һәммә вәдилирини инавәтлик қилғанлиғи һесаплиниду; чүнки ериниң аңлап турған күнидә гәп қилмай шүк турғанлиғи униң аялиниң қәсәм-вәдилирини күчкә егә қилғанлиғидур. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Лекин ери аялиниң қәсәм-вәдилирини аңлап наһайити узақ вақитлардин кейин андин униң қәсәм-вәдилирини инавәтсиз қилса, ундақта у аялиниң гунайини өз үстигә алған болиду. ");
INSERT INTO uigcyr_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Жуқириқилар Пәрвәрдигарниң Мусаға буйруғанлири, йәни ери билән аяли, ата билән өз өйидә туруватқан, техи яшлиғида болған қизи оттурисидики низам-бәлгүмиләрдур. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Пәрвәрдигар Мусаға сөз қилип: — ");
INSERT INTO uigcyr_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Сән Мидиянлардин Исраилларниң интиқамини ал, андин өз хәлиқлириңгә қошулисән, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Муса хәлиққә мундақ деди: — Араңлардин җәңгә чиқишқа бир түркүм адәмләрни қуралландуруңлар; андин улар Мидиянлардин Пәрвәрдигар үчүн интиқам елишқа атлансун. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Силәр Исраилларниң һәр бир қәбилисидин җәң қилишқа миңдин адәм маңдуруңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Шуниң билән түмәнлигән Исраил хәлқиниң һәр қәбилисидин миңдин, җәмий он икки миң адәм җәң қилишқа қуралландурулди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Муса һәр қәбилидин миңдин адәмни җәң қилишқа маңдурди һәмдә Әлиазарниң оғли Финиһасни улар билән биллә маңдурди, Финиһасниң қолида муқәддәс әсваплар вә агаһ канай бар еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Улар Пәрвәрдигарниң Мусаға буйруғини бойичә Мидиянлар билән соқушқили чиқип, әркәкләрниң һәммисини өлтүрүвәтти; ");
INSERT INTO uigcyr_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","мошу өлтүрүлгәнләрдин башқа, йәнә Мидиянниң Әви, Рәкәм, Зур, Хур вә Рәба дегән бәш падишасини өлтүрди; йәнә Беорниң оғли Балаамни қилич билән чепип ташлиди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Исраиллар Мидиянларниң хотун-қизлири вә балилирини тутқун қилип кәтти, йәнә уларниң пүтүн чарва маллири, қой падилири вә мал-мүлүклирини олҗа қилди; ");
INSERT INTO uigcyr_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","улар туруватқан йәрләрдики барлиқ шәһәр вә барлиқ баргаһлириға от қоювәтти; ");
INSERT INTO uigcyr_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","улар адәм болсун мал болсун барлиқ ғәниймәт, барлиқ олҗини елип кәтти; ");
INSERT INTO uigcyr_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","улар тутқан әсирләрни һәм олҗа-ғәниймәтни Моаб түзләңликлиригә, Иордан дәрияси бойиға җайлашқан Йерихониң удулидики баргаһқа әкилип, Муса билән каһин Әлиазарға, шундақла Исраилларниң җамаитигә тапшурди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Муса, каһин Әлиазар вә җамаәтниң барлиқ әмирлири баргаһниң сиртиға чиқип уларни қарши алди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Лекин Муса җәңдин қайтқан һәрбий сәрдарларға, йәни миң беши, йүз бешиларға хапа болуп: — ");
INSERT INTO uigcyr_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Силәр аялларниң һәммисини тирик қалдурдуңларму? ");
INSERT INTO uigcyr_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Қараңлар, дәл шулар Балаамниң һейлә-мәслиһәти билән Пеордики ишта Исраилларни Пәрвәрдигар алдида гунаға патқузуши билән, Пәрвәрдигарниң җамаитигә ваба яғдурулған әмәсму?    ");
INSERT INTO uigcyr_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Әнди силәр барлиқ оғул балиларни өлтүрүветиңлар, әрләр билән мунасивәт өткүзгән аялларни қоймай өлтүрүветиңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Бирақ яш қизлар, йәни әрләр билән мунасивәт өткүзмигәнләрни болса, өзлириңларға тирик қалдуруңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Силәр баргаһ сиртида йәттә күн чедир тикип туруңлар; адәм өлтүргән вә өлүккә тәккән һәр ким үчинчи күни вә йәттинчи күни өзини паклисун; силәр вә силәр әсир қилған кишиләрниң һәммиси шундақ қилсун. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Барлиқ кийим-кечәк, терә әсвап үскүниләр, тивитта тоқулған барлиқ нәрсиләр һәм яғач әсвап-үскүниләрниң һәммисини паклаңлар, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Каһин Әлиазар җәңгә чиқип қайтқан ләшкәрләргә: — Мана Пәрвәрдигар Мусаға буйруған қанун-бәлгүлимә: ");
INSERT INTO uigcyr_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","алтун, күмүч, мис, төмүр, қәләй, қоғушун қатарлиқ ");
INSERT INTO uigcyr_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","отқа чидамлиқ нәрсиләрниң һәммисини оттин өткүзүңлар, шундақ қилсаңлар пак һесаплиниду; шундақтиму, йәнила «напаклиқни чиқарғучи су» билән пакизлаңлар; отқа чидамсиз нәрсиләрни шу судин өткүзүңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Йәттинчи күни кийимлириңларни жуюңлар, андин силәр пак һесаплинисиләр; андин кейин баргаһқа кирсәңлар болиду, — деди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Пәрвәрдигар Мусаға сөз қилип мундақ деди: — ");
INSERT INTO uigcyr_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Сән каһин Әлиазар вә җамаәт ичидики қәбилә каттилири билән бирликтә елинған олҗа-ғәнимәтниң, адәм болсун, чарпай болсун, шуларниң умумий санини һесаплап чиққин; ");
INSERT INTO uigcyr_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","олҗа-ғәниймәтни иккигә бөл, йеримини җәңгә чиққанларға бәр, қалған йеримини барлиқ җамаәткә бәр. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Сән йәнә чиқип җәңгә қатнашқан ләшкәрләр алидиған адәм, кала, ешәк яки қой падилиридин бәш йүздин бирини Пәрвәрдигарға аталған үлүш болсун дәп айриғин; ");
INSERT INTO uigcyr_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","силәр шуни ләшкәрләргә тәвә болған йеримидин елип Пәрвәрдигарға аталған «көтәрмә һәдийә» сүпитидә каһин Әлиазарға тапшуруңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Исраилларға тәвә болған йериминиң адәм, кала, ешәк, қой падилири, шундақла һәр хил һайванлардин әлликтин бирини Пәрвәрдигарниң җамаәт чедириға қарашқа мәсъул болған Лавийларға бериңлар. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Шуниң билән Муса билән каһин Әлиазар Пәрвәрдигарниң Мусаға буйруғинидәк қилди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Әнди олҗа-ғәниймәт, йәни җәңгә чиққан ләшкәрләр еливалған нәрсиләрдин қалғини қой җәмий алтә йүз йәтмиш бәш миң, ");
INSERT INTO uigcyr_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","кала йәтмиш икки миң, ");
INSERT INTO uigcyr_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ешәк атмиш бир миң, ");
INSERT INTO uigcyr_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","әркәкләр билән мунасивәт өткүзмигән қизлар оттуз икки миң чиқти. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Җәңгә чиққанларниң үлүши, йәни уларға тәвә йерими, қой җәмий үч йүз оттуз йәттә миң бәш йүз; ");
INSERT INTO uigcyr_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","бу қой падилиридин Пәрвәрдигарға аталғини алтә йүз йәтмиш бәш болди; ");
INSERT INTO uigcyr_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","кала оттуз алтә миң, буниңдин Пәрвәрдигарға аталғини йәтмиш икки болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Ешәк оттуз миң бәш йүз чиқти, буниңдин Пәрвәрдигарға аталғини атмиш бир болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Адәм он алтә миң чиқти, буниңдин Пәрвәрдигарға аталғини оттуз икки адәм болди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Муса Пәрвәрдигар өзигә буйруғини бойичә Пәрвәрдигарға сунулидиған «көтәрмә һәдийә» болған үлүшни каһин Әлиазарға тапшуруп бәрди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Исраилларға тәвә болған йерими, йәни Муса җәңгә чиқип кәлгәнләрдин елип бөлүп бәргини — ");
INSERT INTO uigcyr_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","җамаәткә тәвә болған шу йерими — қой үч йүз оттуз йәттә миң бәш йүз, ");
INSERT INTO uigcyr_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","кала оттуз алтә миң, ");
INSERT INTO uigcyr_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ешәк оттуз миң бәш йүз, ");
INSERT INTO uigcyr_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","адәм он алтә миң еди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Муса Пәрвәрдигар өзигә буйруғини бойичә, Исраилларға тәвә болған шу йериминиң, мәйли адәм яки һайван болсун, әлликтин бирини айрип елип Пәрвәрдигарниң ибадәт чедириға қарашқа мәсъул болған Лавийларға тапшурди. ");
INSERT INTO uigcyr_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Пүткүл қошунниң сәрдарлири, миң беши, йүз бешилири Муса билән көрүшкили келип, ");
INSERT INTO uigcyr_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Мусаға: — Хизмәткарлириниң қол астида җәң қилған ләшк